﻿USE sofia;
DROP TABLE IF EXISTS sofia.snp_vpl;
CREATE TABLE snp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snp_vpl WRITE;
INSERT INTO snp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu aulafo kolofala mino oluti wamo ya kulini etito ya ne. Yesu Kilisto ya Defiti kipa ufa fiyaigu yauti ya ne. Ido Defiti ya Abalahamu kipa ufa fiyaigu yauti ya ne. ");
INSERT INTO snp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamukafo Aisaka kedami. Ido Aisakakafo Yekopu kedami. Ido Yekopukafo Yuda yaki ido kunalafo-mota yaki kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ido Yudakafo Pelesite Selate kedami ya kipawa lele onibo ya Tamali ya ne. Ido Pelesikafo Hesiloni kedami. Ido Hesilonikafo Lamu kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ido Lamukafo Aminadapu kedami. Ido Aminadapukafo Nasoni kedami. Ido Nasonikafo Salimoni kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ido Salimonikafo Bowasi kedami ya kipawa olafo ya Lahapu ya ne. Ido Bowasikafo Obeti kedami ya kipawa olafo ya Luti ya ne. Ido Obetikafo Yesi kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ido Yesikafo kiyabani we wenaba Defiti kedami. Ido Defitikafo Solomoni kedami ya kipawa olafo ya komu ya Ulia olonafo ne. ");
INSERT INTO snp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ido Solomonikafo Lehobowami kedami. Ido Lehobowamikafo Abiya kedami. Ido Abiyakafo Asa kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ido Asakafo Yehosafati kedami. Ido Yehosafatikafo Yolami kedami. Ido Yolamikafo Usia kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ido Usiakafo Yotamu kedami. Ido Yotamukafo Ehasi kedami. Ido Ehasikafo Hesekia kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ido Hesekiakafo Manase kedami. Ido Manasekafo Emoni kedami. Ido Emonikafo Yosaiya kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ido Yosaiyakafo Yekonia yaki ido kunalafomota yaki kedami ya aya kamenalo ya Babiloni wenena kimiwenina yate Isilaeli wenena numunido meleti gilimiti uti ebanina Babilonika nela fi gedamo. ");
INSERT INTO snp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ido Babilonika nelalo utamo kamena yalo ya Yekoniakafo Sealitiyeli kedami. Ido Sealitiyelikafo Selubabeli kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ido Selubabelikafo Abiyuti kedami. Ido Abiyutikafo Eliyakimu kedami. Ido Eliyakimukafo Asoli kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ido Asolikafo Sadoku kedami. Ido Sadokukafo Ekimi kedami. Ido Ekimikafo Eliyuti kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ido Eliyutikafo Eleyasa kedami. Ido Eleyasakafo Matani kedami. Ido Matanikafo Yekopu kedami. ");
INSERT INTO snp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ido Yekopukafo Yosefe kedami. Ido Yosefe ya Malia wanafo ne. Ido olonafo Maliakafo Yesu kedami ya kuliya Kilistole, loto ya ne. ");
INSERT INTO snp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Etiti minamo, ya Abalahamu kede melami kipa minado yaloti oloto piyamo wenenawa fotini (14) wenenawa etiti oloto piti fulu uti uti ato dito dito aiga yalo Defiti oloto piyami. Ido Defiti kede melami kipa minado yaloti oloto piyamo wenenawa fotini (14) wenenawa ayaidana oti oloto piti fulumo idato, aiga yalo kuwonibo yate Isilaeli wenena Babilonika nelau olu fulo gedato minamo. Ido Babilonika minamo kamena yaloti oloto piyamo wenenawa ya fotini (14) wenenawa oloto piti folato, oloto piti folato ayaidana o minomo wato wato ena yalo ya aiga Kilisto oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ena Yesu Kilisto oloto piyami ka ya etito ne. Olafo Malia Yosefe ko mele edafa, u ekelámami kamenalo ya Goti Ouna Felegagakafo mona mele edaito ya Malia nomilipala mulunau nemo ya eyámae. ");
INSERT INTO snp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Etiti eyámafa, ido wanafo Yosefe ya monala efe limoma nenako, ya olu ukanalo koli edetenae, loto yamu kala auma wito kito momona oto ilifi fulitenae, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Eti loto netawa yamu kala ki minaito ya moda Wekola enisolela makafo famoku oloto pi umuto eti loumami, Defiti nakulafo Yosefeyo, ologafo Malia olunae, lotoma koli komámaneyo. Nomilipala mulunau nemo ya Goti Ounalekati nemo ya felegaga ne. ");
INSERT INTO snp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Felegaga neto ya nalafo kedageto ya amokafo wenenala lifimanina olu mofuto olu omuni kenagoliye, loto kuliya Yesule, loto melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ena netawa muki o fedami yamu Wekolakafo ka polofete welalo melaito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kolalo. Nomili ma weki onámami nomili ma nomilipala mulunau minoto nalafo ma kedageto kuliya ya Emanuwelile, loti melenagilae. Ido kuliya monawa ya Goti ya lalimoteki ne, loto ka mono lufuwau (Ais 7:14) ya nemo kawa ya wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ena Yosefe onototo nedito Wekola enisolelakafo ka loumami ya welalo meyalo meleto olonafodo ya ekelámoto, ");
INSERT INTO snp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","minomo uti uti yalo ya nalafo kedaito, ya kuliya Yesule, loto melaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yuda wenena kiyabani we wenaba Heloti minami kamenalalo ya Yudia ebaleka Betelehemu numudo yalo ya Yesu ya oloto piyaiye. Oloto piyami kamenalo ya moda fo idaidokati ka maninigu nemo we Yelusalemu numudo o fedeti ya eti loti loga amo, ");
INSERT INTO snp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yuda wenena kiyabani we wenaba oloto piyami ya numuna ega ya ne? Ukulula fo idaidoka yalo moda eyetoto ya kuliya olu faka loto oudelute-kate umunune, loto one, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eti loti lato, ya wenaba Helotikafo kawa kolito ya siya-mulunau keina ito, ido Yelusalemu wenena muki yaki ayaidana oti keina kolae. ");
INSERT INTO snp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Keina koli minato, ya Helotikafo Goti yokila ki umamo we wenabani yaki, ido wenena lo melami ka api gilibi-gilibi amo weki muki olu mau wi gedeto ya logimami, Gotikafo kiyabate we wekudi ilifi melami we Kilisto ya egalo oloto pinaiye? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","itibiti loumamo, Yudia ebaleka Betelehemu numudo yalo oloto pinagoliye. Ido polofetekafo lufuwa wiyaigu ya eti limo, ");
INSERT INTO snp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aiyo, Yudia mikau Yuda wenena numuna meya nabanina muki yauti ya Betelehemu numuna ya lumuto kefo efemako minámenanimo ne. Aya numuna meya naba yauti ya kiyaba we wekudi ma oto, ya wenenane Isilaeli wenena muki ya kiyaba o gedenagoliye, loto ka mono lufuwau (Mai 5:2) ya nemo ne, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eti loti loumato, ya Helotikafo kolito ya wemomo ka maninigu nemo we ya momona oto luni fiyaiye. Luni fiyaito ato, ya ukuluwa apito oloto piyami kamena yamu loga-miga o gedaiye. Loga-miga o gedaito, amote loumato, kolito ya logimami, ");
INSERT INTO snp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Linate Betelehemuka ya uti kipawa yamu auma witi moni wiliti olu oloto pi edetima ya oti lonomato, namo ya ayaidana oto uto kuliya olu faka loto oune-lune-kane umunae, loto unagolowe, loto logimito gilifi fulaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eti loto logimami ka ya koliti uti, ya moda ukuluwa komu fo idaidoka eyamo ya u komu uto kipawa nedo uto aufaleka minaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ukuluwama eyeti, ya seni-mulunigu alikani oti lalo naba-naba koli minae. ");
INSERT INTO snp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ena numuguma diti kipawa kefolate olafo Maliate geyeti, ya kuba wi edeti, kuliya olu faka loti, ouni-luni-kani umuti minae. Eti oti minoti ya koukamenina efiliti neta lalo umamo, ya kifana mona kuliya goli yaki, ido yokila ladanuwa imo kiyamo kuliya falagenesenisi yaki, ido yá nowala ladanuwa imo kuliya mulu ya umae. ");
INSERT INTO snp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Umato, Gotikafo famoku yau fuka ka ma eti logimami, Heloti nedo itibiti áumalo, lito koliti yamu ya kanu maleka uti inanimo ebanidoka itibiti wae. ");
INSERT INTO snp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Utato, ya moda Wekola enisolela makafo famoku yau Yosefe fede umuto eti loumami, Kamo nedito kipa kefolaki, ido olafoki koli gilimito Isipi ebaleka uto aya ebau ya minoto, ka kofa logiminamo yamu kiyabane o minalo. Moda kolabe? Helotikafo kipawa ofo fulunae, loto moni wilinagoliye, loumaito ");
INSERT INTO snp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosefe nedito kipa kefolaki, ido olafoki luwaila siniku akaima gilimito Isipi ebau wiye. ");
INSERT INTO snp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gilimito yau wito yalo minomo diti diti, ya aiga Heloti folami kamenalo ya itibiti Isilaeli mikau oti minae. Ido komu adeina Wekolakafo ka ma polofete welalo melaito eti limo, Isipi mikauti ya Nanefo lula fiyoneto itibito aiye, loto ka mono lufuwau (Hos 11:1) nemo ka ya etito wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ena ka maninigu nemo wemomo inanimo ebanidoka itibiti kanu ailo maleka wato, ya Helotikafo, Kone wiyae, loto kolami siya kala-kala loitaito kimiwe gilifi melaito, uti Betelehemu numuna nabau ido numuna-amuna adu negu muki yauti wenena nanibo melege lele olu fulámamo kipa kefola muki ya gini fulumo wae. Eti o gedami ya komu ka maninigu nemo we loga-miga o gedaito, weniguti ukulu fedami kamenawa loumato kolami yamamu koli minoto eti iye. ");
INSERT INTO snp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ena aya kawa ya polofete Yelemaiyakafo limo, Lama numuna meya yau nola ma kolamo ya kufu naba oto, Ei-ai, loto siya-mulunau naba-naba kolami ya wena Leselikafo ufa fiyami wenenala nomilipanina yamu kufu naba-naba o minaito, ya wenenala egaidana oto siya-muluna olu you lo edenune, loti kolafa, nomilipanina minámamo yamu, ogoufámae, loto ka mono lufuwau (Jer 31:15) nemo ka ya komu adeina lufuwa wiyaido ya netawa muki o fedaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ena Heloti fulutaito ya moda Wekola enisolela makafo Isipi ebau Yosefe famoku fede umuto eti loumami, ");
INSERT INTO snp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kipawa ofenagolimo wema fulutaiye. Yamu folomokalo yati nedito, amoki ido olafoki gilimito itibito Isilaeli mikau wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kawa loumami ya Yosefe kolito ya nedito kipawa yaki ido olafoki gilimaito, itibiti Isilaeli mikau wae. ");
INSERT INTO snp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wafa, ido Akelausi yakafo melafo Heloti ebala oluto Yuda wenena kiyabani we wenaba ne, loti lamo ya Yosefe kawa ya kolito ya, yalo uto minenube? loto koli umaito, ya famoku yau fuka ka ma kolito ya Galili mikau yau uti moniti ");
INSERT INTO snp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ya numuna naba ma kuliya Nasalete yau oti numuna ku onoti minae. Eti o minamo yamu ya komu adeina ya polofete yate lamo, Wenena muki yate amomu ya Nasalete we ne, loti lo edenawae, loti kawa lamo ya etito u ayalo wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ena kamena yalo ya noku wi gede-gede imo we Yoni Yudia eba kofo mikau ya o fedeto, wenena ka naba lo oloto gimito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kosinau kiyaba we wenaba wenenala kiyaba o ledami we kamenala moda alitinako, loti seti-muludi olu eleyapa wiyalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aya wewa Yoni yamu ya polofete Aisaiyakafo eti limo, Kofo mikau yalo we ya welauti ka auma wito eti loto lo oloto melenami, Wekola moninami kanula ya olufe loti wili edalo, loto lo minenaiye, loto limo ka ya ka mono lufuwau (Ais 40:3) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ido Yoni ukanalo owo ya yafo-kameli yowalakafo olufe lamo ya ukanalo owo wito, ido kimela ya bulumakau atuwakafo olufe lamo ya kofalalo ya kime wito, ido wela-neta ya ebenuki ido kofuku sabu fimona nowala yaki no-no o minaiye. ");
INSERT INTO snp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ena Yelusalemu wenena, ido Yudia mikaloti wenena muki yaki, ido wenena ebanina adu Yodani no nabalo nemo wenena yaki muki ya Yoni nedo oti ");
INSERT INTO snp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ya lifimanina lo oloto melato, Yodani no nabau ya noku wi gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noku wi gedaito, ya Falisi ido Sadusi we maleka ya noku wi gedaido ato, ya geyeto eti logimami, Linate koiyofa nomilipala minamo, Metefokafo lifima lolumunami kamena naba ya adu melainako, loti koliya enawae, loto fuka ka ya kemakafo logimaiye? ");
INSERT INTO snp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Linate seti-muludi olu eleyapa witi monatina efe limo ya melalo. ");
INSERT INTO snp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ido linate kolamo, Abalahamu ya autefo-kolofatema nenako, yamu Gotikafo lifimate olu itibito lomámenami ne, loti luti-katigu ya koli minafe? Etiti kolámalo. Gotikafo kifana-afana yakafo Abalahamu nakulafo-mota olufe lenae, lenami faifa olufe lenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ido luna ya yá monalo moda mele minami ne. Eti inako, yá ma ilawa lalo liyámenami yá muki monalo fukoto yoku kinagoliye. ");
INSERT INTO snp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Linate seti-muludi olu eleyapa wiyone, loti ato ya namo moda nokafo noku wi gedofa, ido we ma aiga enami ya namo olu fulo nedeto wenaba ona nemoma nenako, namo efe yamo kiyanalo netala olu fulo edenamo ya efe ádenagoliye. Aya wewa ya Ouna Felegaga yaki ido yo famulakikafo noku wi gedenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wewa ya yuwa witi lilika winami neta ya anau oluto lono oluto yuwa witi atuwa ya kilito fulo yo eifámenami yoku ya ito, yuwa witi kula ya olu mau wito oluto numugu melenagoliye, loto Yonikafo logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ena aya kamenalo ya Yesu Galili mikaloti Yodani no nabalo ya oto Yonikafo mono noku wi nedenaiye, loto amo nedoka o fedaito, ");
INSERT INTO snp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yonikafo loumami, E’e, namodoka ya nedito oto lane? Namo ya kamokafo noku wi nedenanimo ya lalo enagoliye, loto lo fuko edaifa, ");
INSERT INTO snp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ido Yesukafo limo, Moda laba, ido oiya ya namo wenelo meyalo melenanimo ya etito Goti mona lalo mele lomamidana oto melenalimo ya moda ogofunami ne, lito ya Yonikafo kolito ya welalo meyalo meleto, noku wi edaiye. ");
INSERT INTO snp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Noku wi edaito, Yesu ayalo nokuti dito, eyaima moda kosina godito Goti Ouna ya nema mulu yaidana oto lumuto, amodo fiyaito, ");
INSERT INTO snp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ido kosinaukati nola makafo limo, Moda youma we Nanefo sene-mulune umomo we ya lalo ona eyowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ena ayaloti ya Ouna Felegagakafo Yesu ya ilimito Satanikafo kepa mele edenaiye, loto kofo mikau akaiya ilimito idaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dito fo kamena foti (40), ido lumi ya foti (40) ya wela-neta moi wito minototo aiga ya kadunamu folaito, ");
INSERT INTO snp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","kepa mele-mele ledami we ya amo minaido oto loumami, Kamo Goti Nalafoma minotoma, kifana ama nemo ya loumageto weka-neta fedaneyo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Loumaito Yesukafo itibito loumami, Wenena mino kolinawamo ya wenineta nenawamo yako minámaiye. E’e, Goti welaloti ka limo muki meyalo melenawamo ya moda mino kolinawamo ne, loto ka mono lufuwau (Lo 8:3) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eti loto loumaito, ya Satanikafo felegaga numuna meya Yelusalemu yau ilimito uto Isilaeli wenena felegaga kuliyai numuna naba kolalo olu nedi edeto loumami, ");
INSERT INTO snp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kamo Goti Nalafoma minotoma umaloti satomo mikalo youma wiyo. Mono lufuwau yau eti limo, Kamomu ya enisolela ya logimageto, kiyaba o kedeti, kiyaga ya kifanakafo kofotenaiye, loti ya ani mulalo olu faka lo kedenagilae, loto ka mono lufuwau (Sng 91:11, 12) ya nemo ne, lito, ");
INSERT INTO snp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesukafo limo, Ido aya lufuwau yau ka ma eti limo, Wekola Gotitina ya kepa mele umámalo, loto ka mono lufuwau (Lo 6:16) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Loumaito, yaloti ya Satanikafo ilimito mowa naba-naba akaiyati nemo yalo ilimito dito, minoto mikau-mikau eba muki kuliyai neta-mata ilibito eti loumami, ");
INSERT INTO snp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kuba wi nedeto, kuline olu faka loto, ouga-luka-kaka nomagetoma ya netawa-matawa muki ya kumunagolowe, lito, ");
INSERT INTO snp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesukafo limo, Ka mono lufuwau eti limo, Wekola Gotitina oudi-luti-kati umuti aimolako kiyani umola fiti kouba-naba o edalo, loto limo (Lo 6:13) nenako, yamu Sataniyo, namodokati faiga womo! loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eti lito, Satani ya fulo edeito wito, ena Goti enisolela o fedeti Yesu ana olu faka lo edae. ");
INSERT INTO snp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ena Yoni nela numugu fulo edamo ka ya kolitoto, Yesu kawa ya kolito minami eba ya fulito, Galili mikau ya wiye. ");
INSERT INTO snp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Uto Nasalete numunaloti fokito uto, Kapeneyamu numuna nofuna Galili onowalo ya Sebuluni ido Napitali mikau ya onoto nedito minaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eti o minami ya komu adeina polofete Aisaiyakafo eti limo, ");
INSERT INTO snp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Wenena ya Sebuluni mikau ido Napitali mikau, ido kuwo no kanu anawalo ido Yodani no naba wela ya kuwo no filigaleka aya Galili ebau ya ailo feka wenena mikanina minamo ");
INSERT INTO snp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ya wenenawa sinidigu minamo ya lamena naba-naba moda eyato, ido wenena fulunagili minadoka ya lamenawa yakafo lamena o gedaiye, loto ka mono lufuwau (Ais 9:1-2) nemo ka yama u ayalo winaiye, loto aya mikau yau uto minaiye. ");
INSERT INTO snp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ena kamena yaloti Yesukafo apito eti lo oloto gimami, Seti-muludi olu eleyapa wiyalo. Kosinau nemo we wekudi wenenala kiyaba o gedami kamena moda adu otainako, yamu seti-muludi ya olu eleyapa witi melalo, loto lo oloto melemo wiye. ");
INSERT INTO snp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu ya Galili nofuna anawalo monimo uto eyami ya kunalafo-yalafo lele Saimonite kuliya ma Pita, ido Adulute laefa olami owo noku fuloti laefa olu minaito ");
INSERT INTO snp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesukafo logimami, Nege melailo. Mona api gilibinamo ya wenena olu-olu enawami we bulu gedenagolowe, lito, ");
INSERT INTO snp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","alako ya laefa owoninama fuliti ya ege meleti waiye. ");
INSERT INTO snp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ido yaloti monimo uti Sebedi nalafo lele Yemusite, Yonite ya geyaiye. Menibo Sebediki lakoina sipiku laefa owoni fukami kifiti minato, Yesukafo luni fiyaito, ");
INSERT INTO snp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ayalomati ya sipiki ido meniboki ya fulititi oti ege waiye. ");
INSERT INTO snp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ido Yesu Galili mikau muki monimo uto uto, mono numunina negu-negu dito, Gotikafo mikalo wenena kiyaba o gedami kala kuwa lalo ya lo oloto gimito, ido wenena neta kilamo ido ukani ogofu imo neta muki ya olu faka lo gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eti imo ya kala kuwa Silia mikau upatito koliti wenena muki neta kilamo, ido ukani ogofu imo, ido Satani kimiwela ya wenena lunigu idamo wenenati, ido kulu ginami wenenati, ido ani-kiyani gali-magalidimo wenenati muki ya amo nedoka gilimiti ato, olu lalo o gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eti o gedemo wito, ya Galili mikauti ido Dekapolisi ebalekati ido Yelusalemu numudoti, ido Yuda mikauti, ido Yodani no wela afulalekati wenena mau naba-naba olu mau witi ege monimo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wenena o mau witi oti ege melemo wamo ya Yesu geyeto ya mowaloma dito amedoto minaito, ya ege-ege moinamo we o fedeti olu ogona o edeti minae. ");
INSERT INTO snp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesukafo ka mono api gilibito eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Wenena inanimo ukani-luni olu faka ádoti Goti yakafoko ade olu faka lenaiye, loti kolinawamo wenena ya kosinau nemo we wekuditekafo wenenala kiyaba o ledami monawa ya moda mino gedaima nenako, yamu lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ido keina koli minamo wenena ya Gotikafo seni-mulunigu olu aila wi gedenagolimoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ido wenena seni-muluni oto lumuti meleti sodoti moni minamo wenena ya Gotikafo mikaleka eba muki ya iya ku gedaito olunawamoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ido wenena kadunamu nosámami fuluti kenebanido apatito nomu auma witi kolamo yamaidana oti wenena seni-mulunigu Goti monala efe limo mona yamu auma witi koliti moni minenawamo wenena ya Gotikafo mona lalo ogofuto giminagolimoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ido wenena ma keina kolamo yamu wenena mate milumani koliti ani olu faka lo gedeti moni minenawamo wenenawa ya Gotikafo ayaidana oto keinanina yamu ya milumani kolito ani olu faka lo gedenagolimoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ido wenena luni-kani mo lotoko moni minenawamo wenena ya omunikafo Goti eyenagilanako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ido wenena muliti meleti fina lowa lukafa ofo fuluti olu you lo gede-gede o minamo wenena ya Gotikafo namo nomilipane minae, loto lo gedenagolimoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ido wenena mona lalo efe limoko melemo wamo yamu ya wenena mate geyamo nosámaito, olu kopa o gedatoma ya kosinau wekuditekafo kiyaba o ledami mona moda mino gedaima nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ido linate ya namo nege melamo yamu ya wenena mate goduti giyadoti ido ka nosa naba ámami suki ka mona-mona fi gimatoma ya moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Koli minafe? Aya kanuwalo ya polofete yate olu komu meleti wamo ya wenena nosámamo yate ayaidana oti ginama ne. Kosinau meinawa naba-naba ya kiyaba o lede minainako, loti seti-muludigu kuli-kuli ageto moda lalo ona kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Linate ya mikalo ama koli kikito nomamo wenena ya kuwo mudini yamaidana oti minafa, ido aya kuwowa leyala ya fuli lagaiyama ya egaidana oto kofa leya enami ne? Aya kuwowa yamaidana ya lonolama kofa minámainako, faifa fuliti kiyanikafo leya witi upato fuli lenagilae. ");
INSERT INTO snp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ido linate ya mikaleka wenena feiya lamenanina yamaidana oti minae. Numuna eba mowalo ya ma ku onenawamo ya falukuto minámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ido wenena mate lamu kiti oluti masa lulau yau melámoti, lamu mele-mele amo ebalo yalo melato, wenena muki numugu minamo ya lamena o gedenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yamu lamenatinawa ayaidana oti ya wenena muki minado ya lamena o gedaneyo. Etiti ya monatina lalo melamo ya eyeti, kosinau Metibo kuliya olu faka loti oluti dinawae, loti ya etiti lamena o gedaneyo. ");
INSERT INTO snp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ena namo omo yamu Goti lo melami kafe ido polofete kanina ya olu fulenae, loto aiye, loti ya kati ki minafe? E’e, eti loti kolámalo. Namo omo ya olu fulenae, loto ámowe. Aya kawa yama o namodoka kulawa ya olu oloto pinaiye, loto omo ne. ");
INSERT INTO snp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yamu ka ona logimowe. Kolalo. Mika kosina fuli lenami kamenalo ya faifa fuli lenagolifa, ido Goti lo melami kala mono lufuwau wiyamo yauti ya lufuwa neta kefo efemafe, ido ka kefo efemafe u kopa ámunagoliye. Aya kawalo muki ya u ayalo uwasawai minageto kulawa o fedenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yamu wenena ma lo melami ka yauti kefola lawoko ma meyalo melámoto, kawa kefo efema nemo nenako, olu fulitalo, loto wenena api gilibinami, wewa ya kosinau wekudite kiyaba o ledami wenena minagu yauti kuliya oluto lumuto minenagoliye. Ido we makafo lo melami ka muki golodoto minoto, lo melami ka ya golodalo, loto api gilibami ya kosinau wekudite kiyaba o ledami wenena minagu yauti wewa kuliya ya dito akaiyati minenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Etito nemo nenako, loto ka ona logimowe. Linate monatina efe lenami yamo lo melami ka api gilibi-gilibi amo we, ido Falisi we monanina efe limo ya olu fulo edámenami ya linate kosinau wekudite kiyaba o ledami kilalau yau idámenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Adeina Gotikafo autibo-mota eti logimami, Wenena gini folámalo, loto (Kis 20:13), ido ka maki limo, We makafo ofo fulunami ya ka olu efe lo-lo amo ebalo ilimiti wato, wewa ofami yamu lifima ka lo edenawae, loto ka mono lufuwau (Kis 21:12) nemo ka ya linate moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Etito nemo nefa, ido nanimo ya aya kawa yamu ka ma logiminagolowe. Kolalo. We makafo aulafo siya-muluna koli nosámami umunami ya ka olu efe lo-lo amo ebalo ya ilimiti wato, lifima olu umunawae. Ido we makafo ka manegau minámamile, loto aulafo loumunami ya kanisole kiyabani wenaba minado ya ilimiti wato, ka olu efe lo-lo amo we yate lifimala umunawae. Ido we makafo kamo digani ka manegau minámami, loto aulafo ma loumunami ya aimola yo eifámenami yoku yau lifimawa meinala olunaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ena kamo ya Goti umunagolo waba, aukafo makafo siya-muluna koli nosámami numu minaiye, loto kolitoma ya komu Goti umunanimo neta mono folomolalo adu yalo meleito uto, aukafo yaki ka olu efe lo fuli loito, itibito oto netawa oluto ya Goti umo. ");
INSERT INTO snp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ido kamote kuwokafote ka olu efe lo-lo amo numudo unawaido ya kanudo yako alako ka lokoli-fakoli oti, seti-muludi olu lawoko melailo. Eti ámenawami ya ka olufe lamo we anido melageto, ido amote kimiwe anido melato, ido kimiwete nela numugu ya fulo nedetenawae, loto seti-muludi olu lawoko melailo. ");
INSERT INTO snp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yamu ka ona logiminagolowe. Nelau etito dinanimo ya alako nelauti fuli ádenagolane. E’e, lifimaka ya kifana muki ya itibito giminanimo yako nelauti fuli loto lumunagolane. ");
INSERT INTO snp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ido ka ma eti logimami, Linate kume-ugele ya ánalo, loto ka mono lufuwau (Kis 20:14) nemo ka ya linate moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Etito nemo nefa, ido nanimo ya aya kawa yamu ka ma logiminagolowe. Kolalo. We makafo wena ma eyeto siya-mulunau ya olu onenamolae, loto kolinami wewa ya aimola lula-kalau yau moda kume-ugele naiye. ");
INSERT INTO snp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ido omuga yakafo lifima olu mofu kedenami ya ukaga muki yo eifámenami yoku fulo nedetenaiye, loto omuga ya ikilito fulo. ");
INSERT INTO snp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ido agakafo lifima olu mofu kedenami ya ukaga muki yo eifámenami yoku fulo nedetenaiye, loto aga fukoto fulo. ");
INSERT INTO snp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ido ka ma eti logimami, We makafo olonafo fulo edenae, loto kolitoma ya wewa olonafo fulo edenami ka lufuwa wito umageto ya olonafo fulo edenami ne, loto ka mono lufuwau (Lo 24:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Etito nemo nefa, ido nanimo ya aya kawa yamu ka ma logiminagolowe. Kolalo. We ma olonafo kopa olu ono-ono moinámaifa, ido wanafokafo ya olonafo fuko fulitami wena ya we ailo ma unami, ya komu wanafo yakafo olonafo olu kume-ugele kanuwa wili edaiye. Ido we makafo fuko filiga-filiga amo wena ma olunami we ya kume-ugele nenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ena linate autibo-mota lo melami kanina ya moda kolitamo ya eti limo, Linate ka onale, loti ido neta ma eti enune, Wekola kuliya loti, lo gedoti melenawamo ya suki mona melámoti, kawa ya meyalo meleti, Wekola omunalo ya eti enune, loti lamo kawa efe lotiko eti alo, loto adeina ka monoku yauti moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Etito nemo nefa, ido nanimo ya aya kawa yamu ka ma logiminagolowe. Kolalo. Neta ma kuliya loti, ka onale, loti ádalo. Koli minafe? Kosinau nemo we wekuditekafo wenenala kiyaba o ledainako, linate wenena ma ka logiminagilima ya kosina kuliya loti, kawa ya olu onae, loti ádalo. ");
INSERT INTO snp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ido mika amalo ya Goti kiyana leya wi minami mika ya kuliya loti, kawa ya olu onale, loti ádalo. Ido Yelusalemu ya wekudite wenabate numunalama nenako, Yelusalemu kuliya loti kawa ya olu onale, loti ádalo. ");
INSERT INTO snp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ido linate ya linanimo manidi yowala ya ma lawoko ma olu feke loti, ido olu lumu loti enawamo ya ogoufámanako, yamu maniditi kuliya olu onale, loti ádalo. ");
INSERT INTO snp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Etito ya o, lenawamo ya faifa o, loti, ido e’e, lenawamo ya faifa e’e, loti lalo. Ka ma ya kawa mulalo ayalo enu witi olu aumafofo loti olu onale, loti lenawamo ya nosámami we nedokati enami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ido ka ma eti logimami, We makafo omugalo kofenami ya ayaidana oto lifima itibito omunalo ofo. Ido makafo wekau kofenami ayaidana oto welau lifima itibito ofo, loto ka mono lufuwau (Kis 21:24, Wkp 24:20, Lo 19:21) nemo ka ya linate moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Etito nemo nefa, ido ka ma lenagolowe. Kolalo. Wenena mate olu kopa o gedatoma itibiti olu kopa o gedámalo. E’e, we makafo wanega onaleka kofenami ya filiga adowaleka yaki nofo, loto wanega ilibo. ");
INSERT INTO snp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ido makafo olu kalo mele kedeto ukagalo owo lulau wiyanimo olunae, loto lenami we ya ukagalo owo mulalo wiyanimo yaki faifa umo. ");
INSERT INTO snp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ido kimiwe makafo, Koukamene mofuto kanu kofala linama unane, loto aumafofo lo kedenami, ya kofala maki faifa enu wito ilimito wo. ");
INSERT INTO snp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ido makafo neta mamu wako lokumunami ya faifa umo. Ido makafo kamodokati ya neta ma leiga meleto olunae, loto enami, ya mesafa wi umámo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ido ka ma eti logimami, Wenenatina adu ekeleti minamo wenena ya seti-muludi gimiti, ido kuwotibo ya seti-muludigu koli nosámami gimalo, loto ka mono lufuwau (Wkp 19:18) nemo ka ya linate moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Etito nemo nefa, ido nanimo ya aya kawa yamu ka ma logiminagolowe. Kolalo. Kuwotibo ya seti-muludi gimalo. Ido mona nosámami mele gedenawamo wenena yamu Goti loumalo. ");
INSERT INTO snp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eti enawamo yakafo Metibo kosinau nemo we ya nomilipala ona minenagilae. Moda kolafe? Amo yakafo fo ya olufe lito wenena nosámami yaki ido lalo yaki minado ya muki olu lawoko ito fo liye. Ido amokafo ko ya olufe lito wenena monanina efe loti melamo yaki ido efe loti melámamo yaki minado ya muki olu lawoko ito ko ya wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yamu linate yate seni-muluni gimamo wenena yako ya itibiti seti-muludi gimatoma ya meina olunawafe? E’e, aya monawa ya kifana takisi olu-olu amo we yaki mele minamo yae. Monawa ya ogoufámaiye. ");
INSERT INTO snp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ido linate ya wenenati yako aiyo-koiyo logiminawamo monate yakafo wenena maleka monani olu fulo edaiye, loti koli minafe? E’e, ailo feka wenena koli kikitámamo yaki aya monawa ya mele koli minamo yae. Moda kolafe? ");
INSERT INTO snp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Etito ya Metibo kosinau nemo we monala ya efe lotoko nemo, yamu linate ayaidana oti mona efe lotiko melalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Linate ya mona efe loto melenune, loti, ya wenena lalo leyenawae, loti omunido melenawamo, ya Metibo kosinau minami we yakafo ekeina neta ma gimámenami, yamu koti moniti, wenena lalo geyenawamo yamu kolámalo. ");
INSERT INTO snp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yamu ya ko ánamo wenena ani olu faka loto neta ma giminune, lenawamo ya wenena monabi lele wiyamo ya kulite oluti dinawae, loti kona oluti mono numugu ido kanudo-kanudo u komu uti bumu wekilofo nola melamo mona yamaidana oti ya melámalo. Ya monawa melamo meinala ya moda olutamo ne, lomo ona logimowe. ");
INSERT INTO snp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yamu linate yate neta ko ánamo wenena ani olu faka loto neta giminune, loti kolinawamo ya neta giminawamo monatina yamu ailo wenena logimámalo. ");
INSERT INTO snp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E’e, falukutiko ani olu faka loti gimalo. Eti enawamo ya Metibo neta falukuto nemo muki ya ko-ko imo we yakafo ekeina neta giminagoliye. ");
INSERT INTO snp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Linate Goti loumunawado ya monabi lele wiyamo wenena yamaidana oti loumámalo. Amo yate Goti loumunawado ya wenena leyenawae, loti mono numugu ido kanu anawalo omunido nedi minae. Monawa melamo yamaidana oti linate etiti melámalo. Ya monawa melamo meinala ya moda olutamo ne, lomo ona kula logimowe. ");
INSERT INTO snp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yamu kamokafo Goti loumunae, loto kolinanimo ya kaimo numugau ya dito, kanu kuitito Mekafo eyámanimo we loumu-umu o minagetoma, ya Mekafo mona muki momona enanimo ya ko-ko imo we yakafo ekeina neta kumunagoliye. ");
INSERT INTO snp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ido ailo feka wenena Goti monala yamu kolámamo wenena yate faifa ka ilulu kuti lo-lo amo ya koli lumunami ne, loti kani kiti lo-lo amo monani melamo yamaidana oti linate melámalo. ");
INSERT INTO snp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E’e, komu loga o edámamo kamenalo Metibo yakafo muki neta seti-muludigu kolamo ya moda kolitaima ne. ");
INSERT INTO snp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ena Metefo loumunagilima etiti loumalo, Metefo kosinau minanimo we ya wenena yate kulika olu faka lomo dito felegagale, loti minenawamo ne, loto kolone. ");
INSERT INTO snp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ido kamo kiyabate we wekudi kiyaba o ledanimo kamena o fedenagoliye, loto kolone. Ido kosinau weka lanido golodotiko minamo yamaidana oto wenena mikalo amau ya wekalo golodenune, loto kolone. ");
INSERT INTO snp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ido kamena-kamena wete-neta lomo. ");
INSERT INTO snp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ido wenena lifimani kilili o gedonimo yamaidana oto lamo lifimate ya kilili o ledo. ");
INSERT INTO snp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ido mona nosámami kepa mele lumunami nedo ya lilimámaba, ido mona nosámamikafo nela wi ledenaiguti ya efili ledo. Kamo kiyaba we wekudi kiyaba o ledanimo ya minomo uto uto aumafofoka ya minomo uto uto kulika ya dimo uto uto minowaminowa oto minenami ne. Ya onale, loti Goti loumunawamo ya eti loti loumalo. ");
INSERT INTO snp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Moda kolafe? Linate olu nosámami o gedenawamo wenena lifimani kilili o gedatoma, ya Metibo kosinau nemo wekafo linanimo lifimatina yaki ayaidana oto kilili o gedenagolimo ne. ");
INSERT INTO snp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Etito nefa, ido wenena lifimanina kilili o gedámenawamo ya Metibo yakafo linanimo lifimatina yaki ayaidana oto kilili o gedámenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Goti koli umuto konuma-kobina moi wi umuto ka loumuto minenanido ya monabi lele wiyamo wenena yaidana oto mona melámo. Wenenawa yate laina witi koni-weni olu kopaitamo, wenena leyenawamo ya konumakobina moi wi umamo ne, loti leyenagilae, loti lamo monanina yamaidana oto ya mona melámo. Monawa melamo meinala ya moda olutamo yae, lomo ka ona kula logimowe. ");
INSERT INTO snp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ido kamo ya Goti koli umuto konuma-kobina moi winae, lotoma ya koka-weka noku wito, atekalo ya yá nowala ladanuwa imo neta filito moino. ");
INSERT INTO snp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Eti enanimo ya wenena muki ya Goti koli umuto, konuma-kobina moi wi umaiye, loti keyámenawafa, ido Mekafo mona muki momona enanimo ya ko-ko imo we yakafo ekeina neta ya kumunagoliye. ");
INSERT INTO snp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Linate mikaleka koukame olu mau naba wi minato, ya kanu sigefa filito, ido ufa lenami ne. Ido ugele we yate numunina ya fukoti diti neta ugele olunawamo ne. Yamu mikaleka uma koukame ya olu mau wi-wi ámalo. ");
INSERT INTO snp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ido kosinau koukame olu mau winawamo ya kanu sigefa yakafo ánenagoliye. Ido ufa ádenagoliye. Ido ugele we yate numunani ya fukoti diti ugele olámenagilae. Yamu kosinau koukame ya olu mau wi-wi alo. ");
INSERT INTO snp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Moda kolafe? Koukametina melenawamo eba ya seti-muludi kati-manidi aumafofo loti aya ebau yako koli umunawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Omudi ya ukadi lamula ne. Yamu ya omudi lalo minagetoma lamena ya ukadi muki ya olu faito gedenagolimo ne. ");
INSERT INTO snp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ido omudi nosámagetoma ya ukadi muki ya sini yamu faito gedenagolimo ne. Yamu ya lamena lutigu nemo ya sinidenami ya moda naba-naba sinidenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","We makafo wenaba lele ya kouba-naba o gedenami ya ogoufámaiye. Eti enae, loto kolinami ya wenabala ma ya eleka fi umuto, ido ma ya siya-muluna umunami nefemo, ido malo ya u ekeleto, ido ma ya fulo edenami ne. Ayaidana oti linate Goti yaki ido kifanakoukame mikalo neta-mata yaki olu lawokoiti kouba-naba o gedenuwe, loti kolinawamo ya ogoufámae. ");
INSERT INTO snp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yamu ya ka ma logiminagolowe. Kolalo. Linate ya fulutenune, loti ya konuma-kobina nenawamo neta yaki, ido no yaki ya egaukati oluto nenumo ne? loti kati mumudi kiti, ido ukadi yamu koliti ya ukadelo owo ya nena neta winumo ne? loti kati mumudi ya kiyámalo. Omude kofawa minonimo mona yakafo wete-neta ya olu fulo edami ne, loti kolámafe? Ido ukadi yakafo ukanido owo ya olu fulo edami ne, loti yaki kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nema ya kosinalo bu loti moinamo monanina yamu kati kife lalo. Amo ya ufa neta kifámamo ne. Ido kulawa liyami ya doilámamo ne. Ido numugu ya weni-neta olu mau wiyámamo ne. Eti ámafa, ido Metibo kosinau nemo we yakafo weni-neta moda gimi-gimi imo ne. Yamu kolalo. Linate ya moda nema ya olu fulo gedeti minae, loti ya kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ido linate minagu yauti ya kemakafo aimola kala mumudi kiyaidoti ya mino oluto unami kamenala ya kefola maki enu wito minomo unami ne? ");
INSERT INTO snp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ido ukanido winawamo owo yamu ya nediti kati mumudi ki minae? Kofuku ugawa imo yamu kati kife lalo. Ugawa yakafo lono olámoto ido ukanalo owo olufe ádami ne. ");
INSERT INTO snp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Eti olufe ádaifa, ido ugawa yakafo Yuda wenena mikalo kiyaba we wekudinina Solomoni ukanalo owo lalo-talo wiyami ya olu fulo edami ne, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ake, linate koli kikitina kefo nemo wenenao, Goti yakafo yuwa-nela ya onema neto ido leda fukoti yoku kinawamo neta ya etito olu egelamima nenako, yamu ya moda ayaidana oto kiyaba lalo o ledenagoliye, loti ya kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yamu ya konuma-kobina yaki, ido no yaki egaidana oto oluto nenumo ne? loti, ido nena neta ukadelo winumo ne? loti kati mumudi ya kiyámalo. ");
INSERT INTO snp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","E’e, aya netawa-matawa muki yamu ya ailo feka wenena yate moni wili-wili afa, ido Metibo kosinau nemo we yakafo netawa-matawa muki ya linate olunawamo ogofunami neta ya moda koli minaiye. ");
INSERT INTO snp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yamu linate ya kosinau nemo we wekudi ya kiyaba we wenabate minenagoliye, loti, ido amo monala efe limo mona laloko meyalo melenune, loti auma witi koliti olu seti-muludigu ya komu meleti minaneyo. Eti enawamo ya netawa-matawa liliga muki yaki moda enu wito oloto pi giminagoliye. ");
INSERT INTO snp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ido linate ya leda yamu ya kati mumudi ya kiyámalo. Fo kamena leda yakafo aimola netala yamu kala kinagoliye. Fo kamena lawokolo ya aimola keinala ya moda ogofuto ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesukafo eti limo, Gotikafo linate olu kalo mele ledetenaiye, loti wenena olu kalo mele gedámalo. ");
INSERT INTO snp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yamu kamo olu kalo mele gedenanimo mona yaidana oto Gotikafo olu kalo mele kedenaiye. Ido gimi-gimi animo mona yaidana oto itibito kumunagoliye. ");
INSERT INTO snp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yamu ya egaidana oto aukafo omunalo momupa kefo efema nemo ya eyaba, ido kaimoka omugau yá lana naba nemo ya eyefe ádane? ");
INSERT INTO snp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ido yá lana ya kaimoka omugau nemo eyámanimo aukafo omunau momupa kefo efema nemo ya egaidana oto olu fulo kedenae, loto loumunanimo ne? ");
INSERT INTO snp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Monabi lele wiyanimo we, kamo kaimoka omugalo ya yá lana naba nemo ya komu olu fulito kofe loto minototo, aiga ya aukafo omunau momupa kefo efema nemo ya olu fulo. ");
INSERT INTO snp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Adala lofotenawae, loti felegaga neta lalo ya kula gimámalo. Ido yafo kiyanikafo leya witi eleyapa witi adala lofotenawae, loti okani ekeina lalo netatina ya mikalo fa fulámalo. ");
INSERT INTO snp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Linate neta ma lumunabe? loti loumuti minenawamo wenena netawamu kolinawamo ya giminami ne. Ido neta moni wili minenawamo wenena netawamu kolinawamo ya olu oloto pi gedenami ne. Ido kanudo kesoba winawamo wenena ya kanu wi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yamu neta lumunabe? loti loumuti minenawamo wenena ya moda olunawamo ne. Ido neta moni wili minenawamo wenena ya olu oloto pinawamo ne. Ido kanudo kesoba witi minenawamo wenena ya kanu wi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ena linate yauti we ma nalafokafo konumamu melafo loga o edenami ya kifana fowena umunami nefe? ");
INSERT INTO snp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ido laefa yamu loga o edagetoma ya salopaina umunaife? ");
INSERT INTO snp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Etiti linate ya wenena nosámamo minafa, ido nomilipatina neta lalo faifa gimi-gimi amo mona ya koli minae. Monawa koli minato, ido Metibo kosinau nemo we yakafo neta mamu loga o edenawamo wenena ya oto dito neta lalo-talo gimi-gimi enami ne. ");
INSERT INTO snp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yamu wenena mate etiti o mele nede-nede enawae, loto kolinanimo ya kamokafo yaki mona ayaidana oto mele gede-gede o. Lo melami ka ido polofete kanina monawa etito nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ido linate ya kanu wela kefo efema ya moni wiliti idalo. U kopa enawamo kanu wela ya naba-naba neto ido kanu kofala ya naba-naba nenako, wenena mumudi kanuwalo yau di-di amo ne. ");
INSERT INTO snp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Etito nefa, ido mino ko-ko amo ebau unawamo kanu welawa ya kefola neto, ido kanu ya kefola nenako, wenena lawoko-lawoko yako kanuwa ya olu oloto pi-pi o minae. ");
INSERT INTO snp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ka su mono api gilibamo wenena ya ekena o gedalo. Wenenawa ya oti koni winune, loti sipisipi you limo monani yaidana oti melafa, ido seni-mulunigu yau kula fadena yaidana oti minae. Yamu geyefe loti minalo. ");
INSERT INTO snp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aya wenenawa mona melenawado yati kulawa ya eyeti geyefe lenagilae. Lunadi liyami ya kefani kailau yauti dolinawafe? Ido yá kemani ailau yati ade ilawa ya dolinawafe? E’e, eti ámenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Etito yá lalo yakafo kulawa lalo li-li ifa, ido yá nosámami yakafo kulawa nosámami li-li iye. ");
INSERT INTO snp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yá lalo yakafo kula nosámami liyámaito, ido yá nosámami yakafo kula lalo linami ya ogoufámaiye. ");
INSERT INTO snp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Etito yá ma kula lalo liyámenami ya fukoti yoku ya kinagilae. ");
INSERT INTO snp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Etito nemo yamu Goti kala logiminagolo one, loti lo-lo amo wenena ya kulawanina eyeti geyefe lenagilae. ");
INSERT INTO snp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wenena mukite Wekolate, Wekolate, loti lonumu-numu o minamo wenena ya kosinau nemo we wenenala kiyaba o ledami kilalau idámenagilafa, ido Menefo kosinau nemo we welalo golodoti moni minamo wenena yako unagilae. ");
INSERT INTO snp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yamu iya melenami kamena nabalo ya wenena mukite eti lonumunawamo, Wekolate, Wekolate, kulikalo ya wenena logimonimoma ne. Ido kulikalo ya Satani kimiwela wenena seni-muluniguti olu fulo gedeto gilifonimoma ne. Ido kulikalo ya Goti aumala gilibami neta so loto onimo ne, loti lonumunawae. ");
INSERT INTO snp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Etiti lenawamo ya namokafo eti loto lo oloto giminamo, Linate ya geyámoma ne. Monani nosámami mele-mele amo ya namo minodoka faiga walo, loto logiminagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Wenena mate kane ya koliti meyalo melenawamo ya ka manenau nemo we numuna kifana mulalo kuwami yamaidana oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Numuna kuwaito, aiga ko naba-naba wito, no naba ya lafa oto, epe naba-naba yakafo oto numunawaloma auma wito ofaifa, ido numuna ya kifana naba mulalo aumafofo loto kuwainako, lumu fou ádaiye. ");
INSERT INTO snp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Etito nemo nefa, ido wenena mate kane koliti meyalo melámenawamo wenena ya ka manenau minámami we numuna akelo kuwami yamaidana oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Numuna kuwaito, aiga ko naba-naba wito, no naba ya lafa oto, epe naba-naba yakafo oto numunawaloma auma wito ofaito lumu fou loto upa-napatoto wiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesukafo kawa ya lo fuli lito wenena mau naba minoti ka logimami monala kolamo ya elegiyae. Amo ya lo melami ka api gilibi-gilibi amo we yaidana oto api gilibámoto, ka mono kula abogakafo api gilibainako, elegiyae. ");
INSERT INTO snp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu mowaloti lomaito, wenena mau naba-naba ege wae. ");
INSERT INTO snp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ege wato, ido moda okola kilami we ma Yesu nedo oto, kiyanalo kuba wi umuto eti limo, Wenabao, kamokafo eti enae, loto kolitoma okola kilomo ya kolouto nedo, loto lageto ukane ya moda koloutenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eti loto loumaito, Yesukafo ana sino loto wewa ukanalo olu minoto loumami, Eti enae. Okola kilanimo kolouto, lito ayalo okola kilami moda koloutiye. ");
INSERT INTO snp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ido Yesukafo limo, Neta o kedomo ka ya wenena logimámoto, uto yokila ki umami we ukaga ilibageto keyageto ena Mosesekafo ka lo melamidana oto neta umageto wenena muki yate okola kilanimoma moda koloutane, loti kolinagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ena Kapeneyamu numudo o fedaito, kimiwe kiyabani we ma Yesu nedo oto ");
INSERT INTO snp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","eti loumami, Wenabao, kouba-nabane we ipedotoko minoto, ukana ogofu naba-naba ito, numugu folomolo ono minaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Loumaito, Yesukafo itibito eti limo, Nanimokafo uto neta kilami ya olu faka lo edenagolowe, loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ido kimiwe kiyabani we yakafo eti limo, Wenabao, namo Yuda we minámonako, numuneu dinanimo ya efe ádenagoliye. Yamu kamo ka yako lageto kouba-nabane we neta kilami ya faka lenaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Etito namo yaki kiyaba o nedamo we wenido meyalo melenamo we minowe. Ido namo ya kimiwe kiyabani we minowe. Etito kimiwe ma wo, loumoneto ya moda wiye. Ido we ma ano, loumoneto ya moda aiye. Ido kouba-nabane we eti o, loumoneto ya eti iye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Loumaito, Yesukafo kawa limoma ya kolito elegito ege wamo wenena ya eti logimami, Ka ona logimowe. Kolalo. Isilaeli wenena muki yauti we ma koli kikila naba nemo wewa yaidana we ma eyámowe. ");
INSERT INTO snp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yamu logiminagolowe. Fo idaidokati ido fo lomaidokati ailo feka wenena muki ya oti kosinau nemo we wenenala kiyaba o gedami ebalau diti Abalahamu, Aisaka ido Yekopu lakoina amedoti weni-neta nenagilafa, ");
INSERT INTO snp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ido Yuda wenena Goti kala koliti kolámamo wenena ya gilifi eba sini naba digu fulo gedenami ebawau ya itageto kufu naba-naba oti weni kofala uguti minenagilae, logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Logimito kimiwe kiyabani wema eti loumami, Kamo wo. Koli kikitanimo yaidana oto kulawa oloto pi kedenaiye, loto loumaito, ido aya kamenalo ya kouba-nabala we neta kilami ya faka liye. ");
INSERT INTO snp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ido Yesu ya Pita numunau dito eyaima, ya Pita iyabala wena ya neta kilito ukana kala-kala lito folomolo ya ono minaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ono minami ya eyeto analo olaito, ukana kala-kala limoma ya fulo edaito wenawama nedito weni-neta ofo ki gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ena lunaga melaito Satani kimiwela seni-mulunigu mino gedamo wenena muki ya gilimiti Yesudoka ato, ka limokafo Satani kimiwela mino gedamo olu fulo gedeto gilifi melaito wato, ido neta kilamo wenena muki ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eti imo yamu Gotikafo polofete Aisaiya ka welalo melaito eti limo, Aimolakafo ukadeu ogoufami neta oluto, neta kilonimo mona-mona ya mofutaiye, loto ka mono lufuwau (Ais 53:4) nemo ka kulawa moda fedaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesukafo wenena mau nabate ogona o edamo ya geyeto, ege-ege moinamo we ya nofuna anawa filiga afulaleka wokele, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Logimaito, ka mono api gilibami we makafo amo nedo oto limo, Api lilibanimo we, eba muki unanimodoka ya namote lakoina unaliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Loumaito, Yesukafo eti limo, Kula fadena ya mika kofuti ku onato, ido nema kosinalo moinamo ya numunani neto minafa, ido namo We Kula ya oku ono-ono omo ebane ya minámaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu ege melamo we yauti we ma oto limo, Wekolao, komu uto menefo kale li edetoto kege moninafe? loto loga o edaifa, ");
INSERT INTO snp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesukafo limo, Nege ano. Fulunawamo wenena fulo gedageto amo yate ya folamo wenenanina kale li gedenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ena sipiku idaito ege-ege moinamo we ege uti ayau idae. ");
INSERT INTO snp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Diti nofugu ya moda epe naba-naba apito no ofaito, no satimo yakafo sipi no lulau lumunae, loto ifa, Yesu ya moda oku ono minaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oku ono minaido ege-ege moinamo we oti eku oti loumamo, Wekolao, no lulau lumuto fulunagolone. Ade olu faka lo, loti au loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Au loti loumato, amokafo limo, Linate koli kikitina kefola nemo we, nediti koli kolae? loto logimito onaiguti nedito epe yaki ido no satimo yaki goudaito, ayalo ya epe fu-fu ádoto, no satimo yaki momoga ámaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eti imo yamu wemomo ya elegiti eti lamo, Aiyo, we ya egaidana we minaito, epe yaki ido no yaki ka lido ya golodaiye? loti lae. ");
INSERT INTO snp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuki ege-ege moinamo weki nofuna filiga akailaleka Gadala wenena mikanido u fedato, we lele ma Satani kimiwela mino gedami we ya kono melamo ebaloti oti katula aiye. Wewa lele auma nosámami wiyainako, yamu wenena koli gimaito, aya kanudo yalo uti oti ámae. ");
INSERT INTO snp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","We lelewa yate eti loumami, Goti Nalafo, nedi-nedi o ledenagolo ane? Lifima olu iya mele ledenanimo kamena naba oiya fedámainako, ukade ogofu olu lumunagolo abe? loti loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Loga o edaito, yafo mau naba ma yowa minoti weni-neta no minato, ");
INSERT INTO snp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Satani kimiwela yate geyetiti loumamo, Lilifinae, lotoma ya yafo lunigu yowau lilifi fulo, loti aumafofo loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Loumato, ayau walo, loto logimaito, we lele luniguti fulo gedeiti yafo lunigu idato, yafowa koli lumuti lowau konidokati luwa fiti nofugu yau no noti moda folae. ");
INSERT INTO snp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Moda folato, yafo kiyaba amo we ya koli oluloti uti numuna meya yau diti, wenena muki aya kawa yaki we lelema Satani kimiwela mino gedami gilifami ka yaki logimae. ");
INSERT INTO snp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Logimato, ayalo ya muki wenena numuna meya yauti oti Yesuki katula enune, loti oti eyeti ya auma witi eti loumamo, Lamo ebate ya fulito wo, loti wako lo edae. ");
INSERT INTO snp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu sipiku dito nofuna wela filiga uto aimola numunalo fedaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fedaito, ya moda kiyana-ana ipedotoko nemo we ma agagalo meleti amo nedo ilimiti ato, Yesukafo koli kikito umamo monanina ya geyeto kiyana-ana ipedotoko nemo we ya loumami, Nanefo, koli komámaneyo. Lifimaka ya moda kilili otaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eti lito, moda wewa Goti kamana kiyaiye, loti ka mono api gilibamo we seni-mulunigu kolae. ");
INSERT INTO snp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kolato, Yesukafo seni-mulunigu kolamo ka ya geyeto eti limo, Linate nediti seti-muludigu yau ka nosámami koli minae? ");
INSERT INTO snp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Etito ipedotoko nemo we, Lifimaka ya kilili otami ne, loto loumunamo linate kulawa ya eyámanako, suki lifemo, ido ona liye, loti kolámenagilae. Ido, Agagalo yati nedito kanu moino, loto loumoneto kulawa eyenawanako, suki lifemo, ido ona liye, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Namo We Kula minomo mikalo ama ya lifima kilili enamo auma ya moda mino nedami ne, loti kenagilae, loto ya ipedotoko nemo wema eti loumami, Nedito, kunuka oluto itibito numugaleka wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Loumaito, wewama nedito kunula oluto numunaleka wiye. ");
INSERT INTO snp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wito, ya wenena mau naba ya eyetiti elegiti Goti ya aumala naba wenena anido gimami kuliya olu faka loti ebola lae. ");
INSERT INTO snp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu yaloti monimo uto wenena kifana takisi olu-olu amo ebalo ya Matiu amedoto minami ya eyeto eti loumami, Nege ano, loto loumaito ya nedito ege wiye. ");
INSERT INTO snp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ena numugu ya Yesu wela-neta no minaito wenena kifana takisi olu-olu amo we ido lifimanina nemo we mumudi ya oti Yesuki ege-ege moinamo weki lakoina weni-neta no minae. ");
INSERT INTO snp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Weni-neta no minato, Falisi we yate oti geyeti ege-ege moinamo we ya eti logimamo, Egaidana oto api gilibami we ya auwa wenena kifanani takisi olu-olu amo weki, ido lifimanina nemo we yaki lakoina wela-neta naiye? loti loga o gedae. ");
INSERT INTO snp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesukafo kawa lamo ya kolito eti limo, Neta kilámamo wenena ya lusa numugu ya ámu-ámu ae. E’e, neta ona kilamo wenena yako ya lusa numugu ya u-u ae. ");
INSERT INTO snp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Namo omo ya wenena mona efe limoko melamo wenena ya seti-muludi olu eleyapa witi melalo, loto logiminae, loto ámowe. E’e, lifimanina nemo wenena ya seti-muludi olu eleyapa witi melalo, loto logiminae, loto omo ne. Kolalo. Gotikafo eti limo, Sene-muluneu kolomo ya neta ofo ki numunawae, loto kolámoto, wenena milumani koliti ani olu faka lo-lo enawae, loto kolowe, loto ka mono lufuwau (Hos 6:6) ya nemo ne. Yamu linate uti kawa monawa ya moni wiliti kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ido Yoni ege melamo we ya Yesudoka oti eti loumamo, Lamoki ido Falisi weki wete-neta moi wiyogeto ya kamo kege-kege moinamo we ya egaidana oti weni-neta moi wiyámae? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesukafo itibito eti logimami, We ma wena olunami wenenalaki lakoina minami kamenalo ya wenenala seni-mulunigu keina koliti kufu nema ka lenawafe? E’e, eti ámenawafa, ido amodokati wewa ipoti olunawamo kamena ya fedenami yalo ya weni-neta moi winawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ido we makafo ukanalo owo lila fukenaido ya owo kofawa kefo makafo mulalo meleto kifinami ya noku wiyoneto kofawakafo lilama ika ageto fukotenaiye, loto kifámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ido we makafo no waini kofawa ya lipito yafo-meme atuwa lilau yau leikámenami ne. No waini kofawa yakafo yafo-meme atuwa lila ya foikageto no waini kofawa ya mikalo lekito u kopa wageto ido yafo-meme atuwa yaki fokito u kopa utenaiye, loto no waini kofawa ya yafo-meme atuwa kofawau yako lekinami ya lelewai faifa aumafofo loti minenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kawa ya logimi minaidoma ya kiyaba we ma oto kiyanalo kuba wi umuto ya limo, Olunefo oiya ya folami yamu kamo oto aga manenalo melageto ya moda nedinaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eti loto lomaito ya Yesu nedito ege wito ege-ege moinamo weki ege wae. ");
INSERT INTO snp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ege wato, ya wena makafo wanula leki-leki imo melege tuwelu (12) yalo ya netawa kilitoko nemo ya oto Yesu nedo egeka oto ukanalo owo onowalo olunamo ya moda olu faka lo nedenagoliye, loto kala kito oto ukanalo owo onowalo ya olaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Olaito, Yesu eleyapa wito wenawama eyeto ya loumami, Olunefo, koli komámaneyo. Koli kikitanimo yakafo olu faka lo kedaiye, loto loumaito, ayalo wenawama moda faka liye. ");
INSERT INTO snp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ido Yesu uto kiyaba we numunau dito ya kanugana nomu yaidana oti fu lo-lo amo wenena geyeto, ido wenena mau naba witi kufu ka naba-naba loti minamo ya kolito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Linate feka walo. Nomiliwa ya folámoto, faifa oku onaiye, loto logimaito wenenawa muki ya kiya o edae. ");
INSERT INTO snp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eti ato, ya muki gilifi feka fulitito, lulau dito nomiliwama analo oluto olu nedi edaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eti imo kala kuwa aya mikau muki ya upatoto wiye. ");
INSERT INTO snp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ena Yesu ebawa fulito wito we lele omuni likami yate ege uti eti lami, Defiti ufa fiyami weyo, milumate kolo, loti au loti laito, ");
INSERT INTO snp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ya uto numugu idaito omuni likami we lelema amo nedo aito eti logimami, Linate omudi ya olu falatenaiye, loti koli kikito nomaife? loto loga o gedaito amo yate O, Wenabao, koli kikito komoiye, loti loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eti laito, anakafo omunido oluto eti limo, Linate koli kikitami yakafo kulawa fede giminaiye, loto logimaito ");
INSERT INTO snp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","we lele omuni falatito Yesukafo limo, Kolailo. Neta eti omo ka ya wenena logimámailo, loto auma wito lo fuko gimaifa, ");
INSERT INTO snp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","lelemate uti kala kuwa laito ebawa negu-negu upatomo wito muki kolae. ");
INSERT INTO snp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ena we lelewama waito moda we ma Satani kimiwela siya-mulunau mino edami nei kilami we ya amo nedo ilimiti ae. ");
INSERT INTO snp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ilimiti ato, Satani kimiwela siya-mulunau minamima olu fulo edeto ilifi melaito nei kilami we ya ka lito wenena mau minamo wenena ya elegiti eti lamo, Isilaeli mikau neta yaidana ma eyámonimoma ne, loti lafa, ");
INSERT INTO snp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Falisi we yate eti lamo, Satani kimiwela kiyabani we wenaba aumala yakafo Satani kimiwela olu fulo gedeto gilifi melaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu uto numuna kefo naba muki ya monimo uto mono numunina negu-negu dito api gilibito, ya wenenala kiyaba o ledami kala kuwa ya lo oloto pi gimito, ido wenena neta ukanigu kilamo muki yaki, ido ukani ogofu neta kilamo muki yaki olu faka lo gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ido wenena mau naba-naba ya geyeto ya siya-mulunau milumani kolami, ya wenenawa yate egau unune? Kemakafo ade olu faka lo ledenaiye? loti aisa lamo ya sipisipi kiyabani we minámamo yaidana oti minanako, milumanina kolaiye. ");
INSERT INTO snp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yamu ege-ege moinamo we eti logimami, Konuma-kobina migu ya naba-naba kula lifa, lono olunawamo wenena lawoko-lawoko yako minae. ");
INSERT INTO snp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yamu linate lono aboga ya loumato lono olunawamo wenena ya lonolau ya gilifi melenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesukafo ege-ege moinamo we tuwelu (12) ya luni fiyaito ato ya Satani kimiwela olu fulo gedeto gilifi melamo auma, ido wenena neta mona-mona kilamo, ido ukani gelo imo olu faka lenawamo auma ya gimaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lonolalo gilifi melami we ya kulini etito ne: Komu melami ya Saimoni kuliya ma Pita ne. Ido kunalafo Adulu ya ne. Ido Sebedi nalafo Yemusite kunalafo Yonite ya minaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ido Filipi ne. Ido Batolomiu ne. Ido Tomasi ne. Ido Matiu kifana takisi olu-olu ami we ya ne. Ido Alifiusi nalafo Yemusi ne. Ido Tadiusi ya ne. ");
INSERT INTO snp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ido Saimoni ya Seloti maunigu yati nemo we ya ne. Ido Yudasi Isikaliyoti ya Yesu kuwonibo anido gimami we ya ne. ");
INSERT INTO snp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ena ege-ege moinamo we tuwelu (12) ya Yesukafo lonolalo gilifi melenami ya ka etito logimami, Uti ya ailo feka wenena minamo ebau yaki ido Samalia wenena numuni nabau yaki áumoti, ");
INSERT INTO snp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isilaeli wenena sipisipi fuisamo mona yaidana oti minamo wenena ebanigu yau walo. ");
INSERT INTO snp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Monimo uti kosinau nemo we wekudite kiyaba o ledenami kamenala moda alitimoma ne, loti lo oloto meleto logimimo walo. ");
INSERT INTO snp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Logimimo uti neta kilamo ya olu faka lo gedeti, folamo ya olu nedi gedeti, okola kilamo ya olu kolouto gedeti, ido Satani kimiwela mino gedamo ya olu fulo gedemo walo. Linate aumawa olamo ya meina fiti olámoti faifa olanako, yamu wenena ma netawa ya eti o gedetima ya meina olámalo. ");
INSERT INTO snp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ido kifana golife, kifana siluwafe ido kifana kapafe owonigu ya koliti áumalo. ");
INSERT INTO snp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ido moninagilima ya kifanani kolinawamo owo ya oluti áumalo. Ido ukanido owo lele yafe, ido kiyanido winawamo neta yafe, ido kolobo yafe oluti moinámalo. Lono olunami we ya lono meinala olunaiye. Yamu muki neta oluti moinámalo. ");
INSERT INTO snp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ido numuna negu-negu ya utima, mona lalo melami we moni wiliti wewaki lakoina numunau minomo uti ebawa ya fuliti unagilima ya nediti walo. ");
INSERT INTO snp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ena numugu ya ditima, ya you amene mona linate minadoka mino gedenaiye, loti logimalo. ");
INSERT INTO snp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aya numugu minamo wenena moda nasafili mona mele gedatoma, ya you amene katina yakafo amo minadoka mino gedenaiye. Ido wenenawa moda eti mele gedámatoma, ya you amene katina ya amo minadoka mino gedámoto, linate minadoka kofa itibinami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ido numuna ma yau wenena yate linateki koina wiyámoti, ido katina yaki koli fulitatoma, ya numunanife ido ebaninafe ya fulo gedeti unagilima ya kiyanido momupa ekelami ya itili o fulititi walo. ");
INSERT INTO snp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ka ona logimowe. Wenena muki lifima ka giminami kamena nabalo ya Sodomu ido Gomola wenena ya lifima ka oluto lumuto giminagolifa, aya ebawau minamo wenena ya lifima ka oluto dito giminagoliye, loto logimitoto lonodo gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesukafo limo, Moda nanimokafo linate sipisipi yaidana oti kula fadena yaidana amo wenena minagu ya gilifowe. Yamu ya koiyofa ka manenau nemo yaidana oti kati kife lalo. Ido nema mulu efe loto monala melami yaidana oti mona ya melalo. ");
INSERT INTO snp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Koti moinalo. We mate ani-kiyanido oluti numuna meyalo kanisole wenena anido melato gilimiti uti mono numunigu ya nela kefakafo ipi gininawamo nenako, koti moinalo. ");
INSERT INTO snp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ido yako minámaiye. Nege-nege moinamo yamu kuliyai we ido kiyaba we wenaba minado ya gilimiti wato, linate kane kune lo oloto melato amoki ido ailo feka wenenaki ya kolinagilae. ");
INSERT INTO snp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ido kiyaba we wenaba minadoka gilimiti watoma, ka egaidana oto lenumo ne? Ido ka lolomatoma nediye loto itibito logiminumo ne? loti ya kati mumudi kiyámalo. Aya kamenalo ka logiminawamo ya wetido melenami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Linate linanimoni ya ka ádenawafa, Metibo Ouna Felegaga yakafo linate wenigu yauti ka lenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ido we makafo kunalafo ya kuwolafo-mota anido gimageto ofo fulunawamo ne. Ido we makafo nomilipala ya ayaidana o gedenami ne. Ido nomilipani yate onibo menibo meni gimato gini fulunawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Linate ya wenenane minanako, wenena muki koli nosámami-asámami giminawafa, ido we makafo koli kiki loto auma wito minomo keina naba-naba fuli lenami kamenalo dinami we ya olu omuna kenami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ido numuna malo minamo wenena yate giniti giyadatoma fuliti numuna ailo ya koli walo. Ona logimowe. Linate Isilaeli numudo-namado yalo lono olumo wato namo We Kula enamo kamenalo ya lonotina fuli ádageto enamo ne. ");
INSERT INTO snp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ena ege melami we yakafo api ilibami we ya olu afima edámami ne. Ido kouba-naba we yamo wenabala ya olu afima o edámami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Etito nenako, ka kolinami we yamo api ilibami we mona melami yaidana oto minenami ya moda ne. Ido lonodo we ya lono aboga mona melami yaidana oto minenami ya moda ne. Ido numuna aboga namo minomo ya Belesebulile, lo nedetima moda oto diti wenenane muki yaki kamanina kinawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yamu kamadi kiyamo wenenawa ya kolini kolámalo. Neta muki falukuto nemo ya aiga oloto pi gedeto, ido asa wiyami nemo neta muki ya oloto pito gilibinagolima ne. ");
INSERT INTO snp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ido ka siniku logimomo kawa ya fo lenaido ya lo oloto meleti, ido ka ma sodoto kanigu lamo ya numuna obito diti au loti lo oloto melalo. ");
INSERT INTO snp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Eti ato, ukadi ya gini fulunawafa, ido oudi ya gini fuluti ogoufámamo wenena ya kolini kolámalo. Yo eifámenami yoku ya oudiki ukadi atuwa yaki lakoina gini fulunami we yako koliya kolalo. ");
INSERT INTO snp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ena nema somo lele ya meinala kefo efema ne. Etito nefa, Metibo kiyaba o gedami we ya nema somo lawoko mikalo lumu fou lenami ya kolami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ido ateni yowala muki yaki moda katotami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yamu koli kolámalo. Amo omunalo ya lamo wenenala minonimo yakafo nema somo muki ya olu fulo gedonima ne. ");
INSERT INTO snp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ena we makafo wenena onobanido kuline lo oloto melenami we ya namo ayaidana oto kosinau Menefo onobalalo kuliya ya lo oloto melenae. ");
INSERT INTO snp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ido we makafo wenena onobanido meya numuto eyámomo ne, lenami we ya namokafo ayaidana oto kosinau Menefo onobalalo mene umuto eyámomo ne, loto lenagolowe. ");
INSERT INTO snp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mikalo omo ya we wena ya olu you lo ledenae, loto aiye, loti kati kiyámalo. E’e, we wena ya olu you lo ledenae, loto ámoto, ile kimi oluto owe. ");
INSERT INTO snp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Namo omo ya kuwolafo-kuwolafo minenawae, loto omoma nenako, Nalafokafo melafo ya kuwolafo bulageto, ido olulafokafo olafo ya kuwolafo bulu edenami ne. Ido onofula yakafo itufala ya kuwolafo bulu edenami ne. ");
INSERT INTO snp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ido we ma aimola numunau onenawamo wenenala ya olu kuwolafo bulu edenawamo ne, loto ka mono lufuwau (Mai 7:6) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ido we ma olafofe melafofe siya-muluna giminami monala yakafo siya-muluna numunami monala ya olu fulo edaito ya yowone we minámaiye. Ido we ma nalafofe olulafofe ya siya-muluna giminami monala yakafo siya-muluna numunami monala olu fulo edaito ya yowone we minámaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ido we makafo yá yofola mofuto nege melámenami ya ayaidana oto namo yowone we minámaiye. ");
INSERT INTO snp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Etito we ma aimola ukana atuwamuko kolito minoto fulunami we ya u kopa unagoliye. Ido we ma namomu kolito monimo uto ukana atuwa fulunami ya omuna kofawa minowa-minowa enagoliye. ");
INSERT INTO snp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ido we ma linate koina wi gedenami ya namo ayaidana oto o nedenagoliye. Ido we ma koina wi nedenami ya nilifami we yaki o edenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ido polofete ya numunalo aito ya we makafo eyeto amo ya polofete ma nenako, koina wi edenae, loto enami we ya polofete meinala ya itibito olunagoliye. Ido we makafo monala efe limo we eyeto ama ya monala efe limo we ma nenako, koina wi edenae, loto enami we ya aimola monala efe limo we meinala ya itibito olunagoliye. ");
INSERT INTO snp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka ona kula logimowe. We ma yakafo nege-nege moinamo we yauti ma siya-muluna oluto lumuto minami we ya eyeto, nege melami yamu epe no umoneto nenaiye, loto eti enami we ya meinala u kopa ámunagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesukafo ege-ege moinamo we tuwelu (12) ya lono ka ya api gilibitoto ebawa fulito ka mono api gilibito lo oloto melenae, loto Galili mikau numuni meya nedo-nedo ya wiye. ");
INSERT INTO snp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ena Yoni noku wi gede-gede imo we yakafo nela numugu minoto Kilisto lono olami kala ya kolito ege melamo we ya Yesu nedo gilifi melaito ");
INSERT INTO snp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","uti eti loumamo, Enaiye, loti lamo ya wema minabemo, ido we ailo ma kiyabala enune? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ido Yesukafo logimami, Itibiti uti neta muki koliti ido omunikafo eyeti amo ya Yoni eti loumalo. ");
INSERT INTO snp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Omuni likami wenena ya omuni falato ae. Ido kiyani nosámami wenena ya kanu moni-moni ae. Ido okola kilamo ya gululudo gede-gede iye. Ido kani melami wenena ya ka koli-koli ae. Ido folamo wenena ya folaguti nedi-nedi ae. Ido neta ko ánamo wenena ya mate kala kuwa lalo lo oloto gimi-gimi ae. ");
INSERT INTO snp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ido wenena mate namomu koliti koli fulitámenawamo wenena ya alikani enagilae. Eti ae, loti loumalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eti logimaito, ya Yoni ege melamo we ya itibiti wae. Itibiti wato, Yesukafo wenena mau witi minamo ya logimami, Yoni yamu kofo mikalo wamo ya nena neta kenune, loti wamo ne? Konofa epekafo oluto uto oto imo ya kenagili wafe? ");
INSERT INTO snp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ido we ma ukanalo owo lalo-talo wiyami eyenagili wafe? E’e, moda ukanido owo lalo-talo wiyamo ya mikalo kiyaba we wekudi numunigu yako mino-mino enawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ido nena neta kenune, loti wamo ne? Polofete ma eyenagili wafe? O, eyenagili wamo wewa yamu ka ma logiminagolowe. Kolalo. Wewa eyamo ya polofete muki olu fulo gedeto nemo we ne. ");
INSERT INTO snp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Amomu Gotikafo limo, Moda kane lo oloto melenami we ilifoneto u komu mele kedeto kanuka wili kedenagoliye, loto ka mono lufuwau (Mal 3:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ka ona logimowe. Kolife loti kolalo. Wenaipate kedamo wenena muki yauti we makafo ya Yoni noku wi gede-gede imo we ya olu afima edámenami ne. Nefa, kosinau nemo we wekudite wenenala kiyaba o ledami kilalau faifa we ma kuliya minámami yakafoko Yoni olu afima o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ido Yoni noku wi gede-gede imo we kamenalalo yaloti oto oto oiya amalo ya kosinau nemo we wekudite wenenala kiyaba o ledami kala kuwa lalo ya wenena yate olunune, olunune, loti aumafofo loti olamo ne. ");
INSERT INTO snp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Polofete muki ido lo melami ka yate kala kuwa lo oloto melemo uti uti Yoni kamenalalo ya wae. ");
INSERT INTO snp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ido koli kikitenawamo ya yama Elaiya ya enami ne, lo-lo amoma ya Yoni yamu lae. ");
INSERT INTO snp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wenena kani nemo yate kawa ya kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Ena oiya minamo wenena ya egaidana oto lo fi meleto lenae? Ya ya nomilipa kefola yaidana oti minae. Nomilipa ya maketilo amedoti minoti koinanibo-mota luni fiti logimamo, Lamo owo ofoto nema loba, ido linate melege olámae. Ido folamo nema lo fi mele gedeto loba, ido linate kufu ámae, loti au loti logimae. ");
INSERT INTO snp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Moda kolafe? Yoni oto kefa kobina, no waini ánoto moi wi umami ya eyeti, ya Satani kimiwela ya mulunau mino edaiye, loti lo edae. ");
INSERT INTO snp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ido namo We Kula ya oto kefa kobina, no waini noto moi wiyámoneto neyeti, Ake, moda konuma naba-naba noto no waini naba-naba noto ido kifana takisi olu-olu amo we ido lifimanina nemo wenena yowoni we ya minaiye, loti lo nedae. Eti lafa, ido kala-manenau nemo ya mona lalo melami yakafo efe limo we ne, loti gilibinagoliye. ");
INSERT INTO snp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ena numudo-numudo aumala gilibami neta olu oloto pi gimaifa, ido seni-muluni olu eleyapa wiyámamo yamu goduto eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aiyo, Kolasini numudo wenenao, Betesaida numudo wenenao, linate ya u kopa unagilamo ya kolámafe? Linatedoka netawa Goti aumala oloto pi gedami neta ya Taiya numudo ido Saidoni numudo oloto pi gedami neko, ya adeinati seni-muluni olu eleyapa witi yo laina maninigu filiti ukanido owo fekali-makali imo ya wiyagi ne. ");
INSERT INTO snp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yamu ka logiminae. Kolalo. Lifima iya mele gedenami kamena nabalo ya Taiya ido Saidoni minamo wenena lifimani ya oto lumuto gimito, ido linate lifimati ya oto dito giminagoliye. ");
INSERT INTO snp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ido Kapeneyamu wenenao, kulite ya olu akaiya kosinalo dito minenaiye, loti kati kiyafe? E’e, eti ámenagoliye. Ya lowau fulaito yau lumuti minenagilae. Ido Goti aumala gilibami neta linate ebanigu olu oloto piyomo ya Sodomu wenena olu oloto pi gimomo neko, oiya ama ya Sodomu numuna eba fa minagi ne. ");
INSERT INTO snp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yamu ka logimowe. Wenena muki olu iya mele gedenami kamena nabalo ya lifimatina yakafo Sodomu minamo wenena lifimanina ya olu fulo edenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kamena yalo Yesukafo eti limo, Menefo, mika kosina Wekolala minanimo ya ka maninigu nemo wenena netawa ya olu faluku gedeto, ido fa wenena nomilipa kefolaidana oti minamo ya olu oloto pi gimanimo yamu keboka lo minowe, loto lokomowe. ");
INSERT INTO snp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Menefo, seka-mulugau eti enae, loto lalo kolanimo etito ya ne. ");
INSERT INTO snp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Menefokafo neta muki moda anelo meleitami ne. Ido wenena mukite Nalafo minomo monane ya kolife ádae. Menefo yako kolami ne. Ido wenena muki yate Menefo monala ya ayaida oti kolife ádae. Nalafo minomoki ido amo ya olu oloto pi gedenae, loto kolomo wenenaki yako koli minogeto wenena ma ya kolife ádae. ");
INSERT INTO snp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Linate lono naba-naba oluti, keina naba-naba koliti, aisa loti, wida loti minamo wenena ya namodoka ato, foli amene mona olu oloto pi gedenae. ");
INSERT INTO snp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yafane filiga akitilo mofuti minato api gilibinagolowe. Monane ya you loto nemo ido sene-mulune ya oluto lumuto we minoneto, oudi foli amene minenami mona ya giminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Etito yafane filiga akitilo moufamo ya you limo ne. Ido mofunawamo neta gimomo ya keina ámainako, kotiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aya kamenalo ya Sabati foliku ya Yesu yuwa witi kifagu wito, ege-ege moinamo we ege uti kadunamu fuluti yuwa witi ya leketi kula feketi noti wae. ");
INSERT INTO snp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eti amo ya Falisi we yate geyeti loga o edeti eti lamo, Kolabe? Kege-kege moinamo we yate lo fukami neta ya oti Sabati foli monala ya olu kopaitae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Loumato, amokafo itibito limo, Defitiki lawoko moinamo wenenaki kadunamu fuluti neta amo ka ya mono lufuwau yau linate katoti kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Goti numunau diti beleti melamo neta felegagale, loti lamo ya yokila ki umami we oluto gimaito namoma ne. Nato lo melami kala yau Gotikafo yokila ki umamo we inanimoniko nenawae, loto limo netawa Defiti ido wenenala ánenawamola ya nae. ");
INSERT INTO snp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ido lo melami ka mono lufuwa wiyagu yau Sabati foliku yokila ki umu-umu amo we ya mono numugu lono oluti, Sabati foli monala ya meyalo melámafa, lifimanina minámami ne. Kawa ya katoti kolife ádafe? ");
INSERT INTO snp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Etito nefa, namo moda logimowe. Oiya amalo makafo felegaga kuliyai numuna naba ya olu afima itami we ya minaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ido Gotikafo eti limo, Sene-muluneu kolomo ya neta ofo ki numunawae, loto kolámoto, wenena milumani koliti ani olu faka lo-lo enawae, loto kolowe, loto ka mono lufuwau (Hos 6:6) ya nemo ne. Linate ya kawa monala yama kolife loti kolamo neko, lifimani minámami wenena olu kalo meleti ligiya logimámagi ne. ");
INSERT INTO snp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yamu kolalo. Namo We Kula ya Sabati foli aboga minowe, loto Falisi we itibito logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ya ebawa ya fulito uto mono numunigu idaito, ");
INSERT INTO snp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","moda ana galidimo we ma neto, Falisi we yate Yesu ligiya loumunumo mona ma moni wilinune, loti eti loga o edamo, Yesuwo, Sabati foliku ya wenena neta kilamo ya olu faka lo gedenune, loti enawamo ya lo melami ka fukenawafe? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Amokafo itibito limo, Linate minadokati we ma sipisipila lawoko ma ya Sabati foliku kaleku lumunami ya wewa anadunu oluto olu feka o edámenami nefe? ");
INSERT INTO snp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipisipi ya fa neta nefa, ido wenena ya kula neta minae, loti kolámafe? Yamu Sabati foliku mona lalo melenumo ya lo melami ka ya fukámenune, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Logimito wewama, Aga folado, loumaito ana foladito ana filiga nemo yamaidana oto olu lalo ifa, ");
INSERT INTO snp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ido Falisi we yate feka lumuti, Yesu ofo fulunune, loti ka lo kifimo wae. ");
INSERT INTO snp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kawa lo kifamo ka ya Yesukafo kolitoto numuna ebawa ya fulito wito, wenena naba ege wato, neta kilamo wenena muki ya olu faka lo gedeto eti limo, ");
INSERT INTO snp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Namo ya olu oloto pi giminune, loti wenena logimámalo, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mona etito melami yamu komu adeina Gotikafo polofete Aisaiya ka welalo melaito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Moda ama ya kouba-nabane we iyaina o edomo ya sene-mulune umuto lalo eyomo we ne. Oune ya mele edoneto amokafo ailo feka wenena mona olufe lo gedomo ka ya logiminagoliye. ");
INSERT INTO snp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amo yama au-au loto moila fi gimámageto kanudokanudo ya nola kolámenagilae. ");
INSERT INTO snp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wenena koli kikinina aumala minámami ya konofa foikami yaidana oti minamo yamu leke fulito gedenae, loto ámenagoliye. Ido wenena ouni wida limo ya feiya kefo efema limo yaidana oti minamo yamu ofo efinae, loto ámenagoliye. Ido kala efe limo ya koliti meyalo mele minenawado ya kamena lalo oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ido kuliyalo ya ailo feka wenena mona-mona yate ade olu faka lo ledenaiye, loti kiyabala enawamo ne, loto ka mono lufuwau (Ais 42:1-4) nemo kama ya ayalo wiyaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ena we ma Satani kimiwela siya-mulunau mino edaito, omuna likoto ka ádami we ya Yesu nedo ilimiti ato, olu faka lo edaito, ya ka loto ido neta-mata eyaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eti o edaito, ya wenena mau minamo muki yate eyeti elegiti eti loga amo, Wewa ya Defiti ufa fiyami we minaife? lato, ");
INSERT INTO snp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falisi wenena yate kawa lamo koliti eti lamo, Wewa ya Satani kimiwela wenabanina Belesebuli aumala yakafoko Satani kimiwela olu fulo gedeto gilifi melaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Eti lato, Yesukafo kani kiyamo ya kolitoto eti logimami, Lawoko wenena inanimo foki filiga-filiga oti fina fi minenawamo ya ebanina olu kopa itenagilae. Ido numuna meya malo wenenafe ido ufa lawokoku wenenafe inanimo foki filiga-filiga oti fina fi minenawamo ya muki u kopa unagilae. ");
INSERT INTO snp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ido Satanikafo aimola Satani wenenala iyadotoma ya aimola foki filiga-filiga enagolagaiyama wenenala kiyaba o gedami lonola egaidana oto auma wito minenami ne? ");
INSERT INTO snp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ido namokafo Belesebuli aumala oluto Satani kimiwela wenena seni-mulunigu nemo gilifi melonetoma ya linate gege melamo wenige-mota ya kemakafo auma gimaito, wenena seni-muluniguti Satani kimiwela olu fulo gedeti gilifi mele-mele o minae? Yamu gege melamo wenena yate ya geyeti iya mele gedenagilae. ");
INSERT INTO snp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Etito nefa, ido Goti Ouna mino nedami aumalakafo wenena seni-muluniguti Satani kimiwela olu fulo gedeto gilifi melonetoma ya moda kosinau nemo we wekudite wenenala kiyaba o ledami mona ya linatedoka olu oloto pi gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Etito nefa, we makafo aumafofo limo we ma numunau ya fukoto dito koukamela olunae, lotoma ya komu uto aumafofo limo we ya nela wi edageto ya koukamela muki olunagoliye. ");
INSERT INTO snp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","We makafo namodo ekelámenami ya kuwonefo minenagoliye. Ido we ma namoki lakoina wenena olu mau wi gedámenami we yakafo wenena giyado fulenaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yamu logiminae. Kolalo. Wenena lifimani mona-mona muki ido wenena kamani kiyamo kani lifimani muki ya kilili o gedenagolifa, ido mate Ouna Felegaga kamana kinawamo ya lifimanina kilili o gedámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ido mate namo We Kula ya kamane kinawamo wenena ya lifimanina kilili enagolifa, Ouna Felegaga kamana kinawamo wenena ya lifimanina kilili o gedámenagoliye. E’e, kamena oiyafe, ido kamena nabalo fedenamife, lifimanina ya minowa-minowa ageto kilili ámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yá lalo minenami ya ilawa lalo linagoliye. Ido yá nosámami minenami ya ilawa nosámami linagoliye. Etito wenena ya yá ilawa eyefe loti eyenagilae. ");
INSERT INTO snp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Linate koiyofa nomilipala minamo, wenena nosámamo egaidana oti ka lalo ma lenawae? Etito seti-muludigu kolamo nemo neta yauti weti yamo kawa ya lenami ne. ");
INSERT INTO snp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","We lalo yakafo neta lalo ouna-lula-kala neguti ya neta lalo olu oloto piyaito, ido we nosámami yakafo neta nosámami ouna-lula-kala neguti ya neta nosámami olu oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Etito nefa, lifimani olu giminami kamena nabalo ya wenena fa ka lamo muki yamu lifima iya mele giminami ne, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yamu ka lo-lo ado yaloma kolito ya lifimala minámami we nefe, ido lifimala nemo we ne, loto iya melenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ena Falisi we ido lo melami ka api gilibi-gilibi amo we yate loga o edamo, Api lilibanimo we, Goti aumala lilibami neta ma kamokafo olu oloto piyageto eyenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lato, Yesukafo itibito logimami, Linate mona nosámami meleti Goti ekelámamo wenena yate Goti aumala lilibageto eyenune, loti lafe? Eti lafa, neta kofawa Goti aumala gilibami neta ma olu oloto pi gimámenami ne. Ido polofete Yona ukanalo Gotikafo aumala ilibami mebe-maba yako olu oloto pi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Etito Yona fo kamena tili (3) ido sini kamena tili (3) yalo ya laefa naba-naba mulunau nemo yamaidana oto namo We Kula ya fo kamena tili (3) ido sini kamena tili (3) yalo ya mika lulau yau minenagolowe. ");
INSERT INTO snp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ena lifimani giminami kamena nabalo ya Ninife numudo minamo we yate nediti, sino loti, oiya ama minamo wenena ligiya lo gedenagilae. Ninife numudo minamo we yate Yona ka limo ya koliti seni-muluni eleyapa wiyafa, ido oiya moda Yona olu fulo edomo we ya amau minofa, seti-muludi eleyapa wiyámae. ");
INSERT INTO snp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ido lifimani giminami kamena nabalo ya Seba mikau minamo wenena kiyabani wena yakafo nedito, sino loto, oiya ama minamo wenena ligiya lo gedenagoliye. Seba wenena kiyabani wena ya Solomoni ya ka manenau nemo we nenako, uto kala lalo kolinae, loto mika faiga-faigalekati ami nefa, ido oiya moda Solomoni olu fulo edomo we ya amau minofa, ka lomo ya kolámae. ");
INSERT INTO snp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ido Satani kimiwela we ma siya-mulunau mino edami lulauti oto fulo edeito uto kofo mikau yaleka monimo uto foli minenae, loto yaidana eba ma moni wilimo wifa, eba ma oloto piyámaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Oloto piyámoto eti loto limo, Komu minomo numuna fulo edomo yalo kofa itibito unae, loto kolito itibito wiye. Itibito o fedeto eyaima numuna kilili oto, feke loto, neta-mata muki lulau efe lotoko ne. ");
INSERT INTO snp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ido kofa feka uto Satani kimiwela seweni (7) kaila nosámami fiyamo kailala olu fulo edeti minamo ya gilimito aito, numunawa yau diti onoti nediti minae. Etiti minato, wewa ya komu Satani kimiwela lawokoko siya-mulunau nemo ya nosámaifa, ido aiga Satani kimiwela muki siya-mulunau minamo yate olu nosámami naba-naba o edamo ne. Ido monawa yaidana ya oiya ama minamo mona nosámami mele-mele o minamo wenena minadoka etito oloto pinami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ka logimi neto ya moda olafoki kunalafo-mota yaki feka kiyaba minoti, ka loumunagolone, loti lato ");
INSERT INTO snp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","we makafo eti loumami, Moda okafoki kunakafo-motaki ka lokumunagili feka kiyaba minae, loumaito, ");
INSERT INTO snp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","itibito eti loto limo, Kema ya onefo ne? Kema ya kunanefo-mota minae? loto ");
INSERT INTO snp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ege-ege moinamo we minado ya anakafo kisunu pito limo, Moda amau ya onefo ido kunanefo-mota minae. ");
INSERT INTO snp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ido mate kosinau Menefo kala lalo kiyami mona meyalo mele-mele amo ya kunanefo ido atenefo ido onefo ya minae, loto liye. ");
INSERT INTO snp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aya kamenalo ya Yesukafo numunauti lumuto no anawa akelo uto amedoto minaito, ");
INSERT INTO snp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","wenena naba so loti oti minaidoka mau wiyamo yamu sipiku dito amedoto minaito wenena mau wiyamo muki ya no akelo nediti minae. ");
INSERT INTO snp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","No akelo nedi minato, neta-mata muki kepa ka logimito ya eti limo, Moda we makafo ufa neta itili enae, loto migu wiye. ");
INSERT INTO snp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Migu uto itili ito ufa neta ma kanudo olumo wiyami ya nema yate oti no fuli lae. ");
INSERT INTO snp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ido ufa neta ma kifana feumau neto mika kefo ma mulalo nedo olumo wiyami ya mika kefo nemoma nenako, kenemaneto fou lifa, ");
INSERT INTO snp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","fo lido megunito lufawa minámainako, apatito folaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ido ufa neta ma kaila imo neta idaigu olumo wiyaito ya kaila imo neta yakafo dito olu itoto ofo folaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ido ufa neta ma mika lalo negu olumo wiyami ya fokito dito ilawa liyaiye. Ma yakafo ilawa so loto wani hadeti (100) yaidana oto liyaiye. Ido ma yakafo ilawa kefola naba sikisiti (60) yaidana oto liyaiye. Ido ma yakafo ilawa kefo efema teti (30) yaidana oto liyami yaidana-yaidana oto limo wae. ");
INSERT INTO snp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Linate kati nemo wenena ya kawa ya kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ena ege-ege moinamo we amo nedo oti ya eti lamo, Nedito kepa ka logimi-gimi o minane? loti loga o edato ");
INSERT INTO snp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","amokafo logimami, Kosinau nemo we wekudite wenenala kiyaba o ledami monala ka falukuto nemo ya linate olu oloto pi gimitaima ne. Ido wenena maleka olu oloto pi gimámaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ido we ma neta ko nami ya maki enu wito umageto ko nami netala so lenami ne. Etito nefa, ido we makafo neta ko ánenami ya neta ko nami netala kefo efema minenami ya amodokati itibito olunami ne. ");
INSERT INTO snp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Koli minafe? Omuni yakafo ko-ko o minafa, ido neta kofe loti eyámae. Kani yakafo ya ka koli-koli o minafa, ido kolife loti kolámae. Etiti minanako, yamu ka asa wito nemo ka ya logimowe. ");
INSERT INTO snp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aya wenenawa yamu Gotikafo kala ya polofete Aisaiya welalo melaito eti loto limo, Linate koli-koli o minafa, ka kolife loti kolámoti, ido ko-ko o minafa, neta kofe loti eyámenagilae. ");
INSERT INTO snp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wenenawa ya seni-muluni moda gedimoko minanako, kani anawako koliti omuni olu likotoko minae. Eti ámamo neko, omunikafo ko-ko o minoti, kanikafo koli-koli o minoti, luni-kanikafo kolife loti koliti seni-muluni ya olu eleyapa witi namodo ato olu faka lo gedogi ne, loto ka mono lufuwau (Ais 6:9-10) nemo ka yama moda oiya ama minamo wenena yalo wiyaiye. Yamu kepa ka logimimo wowe. ");
INSERT INTO snp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Linate nege melamo we omudikafo kofe loti eyeti ido katikafo kolife loti minanako, lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ka ona kula logimowe. Polofete muki yaki ido Goti wenenala monanina efe lamo wenenaki yate neta omo linate eyamo ya eyenune, loti kolafa, ido eyámamo ne. Ido neta api gilibomo linate kolamo ya kolinune, loti kolafa, ido kolámamo ne. Yamu kepa ka logimi minowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ufa neta itili imo we kepa ka monala ya linanimotina koliti fokiti kolife lalo. ");
INSERT INTO snp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","We makafo wekudite wenenala kiyaba o ledami kala kuwa ya kolito kolife ádaitoma ya nosámami abogakafo oto kama ya wewa siya-mulunau kifami yama kenemaneto olu fulitaiye. Ufa neta ya kanudo olumo wiyami yamaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ido we makafo Goti kala kolito ayalo siya-mulunau koli lalo kolami ya ufa neta kifana mulalo olumo wiyami yamaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wewa ya lufawala ona olu kiki ádoto, faifa mulalo nemo yakafo ya Goti kala yamu keina umuti kaila fi edatoma, koli kikila ya alako u kopa wiye. ");
INSERT INTO snp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ido we makafo Goti kala lalo kolaifa, mikalo neta-mata muki yamu keina kolaito, keinala ido kifana-koukame yakafo kola wito kala laloma olu ito edaito ilawa liyámaiye. Wewa ya ufa neta kaila neta idaigu olumo wiyami mika yamaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ido we makafo Goti kala lalo kolito, mona kolife loto kolami we ya ufa neta mika lalo negu olumo wiyami mika yamaidana oto ne. Ido wewa kulawa wani hadetife (100), ido sikisitife (60) ido tetife (30) ya oloto piyami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ido kepa ka ma loto logimami, Kosinau nemo we wenenala kiyaba o ledami monala ya we ma minau ya yuwa witi ufa lalo kifami yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wewa ufa lalo kifaifa, ido oku onami kamenalo ya kuwolafo yakafo oto omiya ufa oluto oto kifaigu kiliyalauma kifito wiye. ");
INSERT INTO snp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Etito ya yuwa witi ufa fou loto idami kamenalo omiya yaki lakoina moda oloto piyami ne. ");
INSERT INTO snp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yamu ya lonola olamo we yate mina aboga nedo uti loumamo, Wenabao, migau ufa neta laloko kifanima nefa, omiya ya egauti idaiye? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Loga o edato, ya eti limo, Kuwonefo makafo kifaito idaiye, loto logimaiye. Eti logimaito ya lonodo we yate loumamo, Lamo uto omiya ya afuto olufe lenube? loti loga o edato ya eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","E’e, omiya ya aufone, loti yuwa witi yaki afutenawae. ");
INSERT INTO snp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yamu yuwa witiki ido omiyaki lakoina minoto o melenaiye. Etito kula lageto yuwa witi fuko-fuko amo we komu ya omiya fukoti olu mau witi nelakafo asa witi fulo yoku iti kinawae. Ido yuwa witi ya olu mau witi oluti numuneu ya melalo, loto logiminagolowe, loto lonodo we logimami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ido kepa ka ma logimami, Kosinau nemo we wekudite wenenala kiyaba o ledami monala ya kolipa ilawa ya we ma oluto minau kifami yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kolipa ilawa kefola sagena yaidana oto nemo yakafo fou loto dito-dito kolipa yá naba wiye. Ido neta-mata muki migu kifamo olu fulo gedeto nemo yamu nema kosinalo moinamo yate oti akawalo yalo numuna ku onae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ido kepa ka ma logimami, Kosinau nemo we wekudite wenenala kiyaba o ledami monala ya etito yaidana oto ne. Wena ma beleti ofo kinagolowe, loto beleti olu fudodo imo neta kuliya yisi oluto, palawa naba yaki olu kofu-nafu oto meleto kiyaba ito, ena yisikafo upatoto wito beleti muki olu fudodo imo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kawa ya Yesukafo mau wiyamo wenena logimami, ya efe loto lo oloto pito logimámoto, kepa kako logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Etito komu adeina polofete makafo eti limo, Kepa ka logimomo ya mika kosina oloto piyami kamena yaloti neta falukuto nemo ya lenagolowe, loto ka mono lufuwau (Sng 78:2) nemo ka etito wiyami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu ya mau minamo wenena fulo gedeito numugu idaito ege-ege moinamo we amo minaido oti ya eti lamo, Kamo omiya migu idami kepa ka lanimo ya mona lageto kolinune, loumae. ");
INSERT INTO snp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ido amokafo itibito eti logimami, Wewa ufa neta lalo kifami we ya namo We Kula ya minowe. ");
INSERT INTO snp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ido mi kifamile, lomo ya mikau muki ya ne. Ido ufa neta lalo ya Goti kilalau minamo wenena ya minae. Ido omiya ufa ya nosámami aboga wenenala ya minae. ");
INSERT INTO snp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ido kuwolafo kifami wele, lomo ya nosámami aboga Satani ya ne. Ido yuwa witi fukenawamo kamenale, lomo ya mika kosina fuli lenami kamena ya ne. Ido fuko-fuko amo wenenale, lomo ya kosinau enisole ya minae. ");
INSERT INTO snp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ido omiya fukoti asa witi yoku ki fuli lamo ya ayaidana oto mika kosina fuli lenami kamenalo yalo ");
INSERT INTO snp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","namo We Kula ya enisolene gilifoneto, namo kilaneu yauti wenena muki wenenanina olu kopaitamo wenena, ido mona nosámami melamo wenena, muki ya olu mau wi gedeti ");
INSERT INTO snp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","eifámenami yoku ya fulo gedenawae. Yau fulo gedato lumunawamo ebau ya kufu naba-naba oti weni kofala uguti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kamena yalo monanina efe limo wenena yate fo kiyala giga limo yaidana oti Menibo kilalau lamena enawamo ne. Kani nemo wenena yate kawa ya kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kosinau nemo we wekudite wenenala kiyaba o ledami monala ya we makafo neta lalo-talo meinala kefo minámami yama ailo we migu kaleku falukami nemo ya olu oloto pito eyetoto uguinami yaidana oto ne. Netawa eyami yamu siya-muluna lalo kolito uto aimola koukamela muki kifanalo fulo fuli loito itibito uto neta lalo-talo kale liyami mikama ya meina fiyaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kosinau nemo we wekudite wenenala kiyaba o ledami monala ya etito yaidana oto ne. We makafo kifanalo fulo fuli lenae, loto ekeina neta omona biyane nemoma ya moni wilimo wiye. ");
INSERT INTO snp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Moni wili-wilito ekeina neta omona biyane nemo yama muki olu afima o gedamima ya olu oloto pito, koukame netala muki wenena gimaito kifana umato uto ekeina netawa omona biyane nemoma ya meina fiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ido kosinau nemo we wekudite wenenala kiyaba o ledami monala ya laefa olu-olu amo owo noku fulato lumuto laefa kola ailo-ailo nemo olami yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Owoma faitito ika oti olumo akeloma iti, amedoti laefa ya iya meleti, nenawamo neta lalo ya owoku meleti, ido ánenawamo neta ya fulitamo ne. ");
INSERT INTO snp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ido mika kosina fuli lenami kamenalo yaidana neta fedageto ya enisole yate oti wenena monani efe limo melamo wenena minagu yauti ma monani nosámami melamo ya iya meleti, ");
INSERT INTO snp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yo eifámenami yoku yau fulo gedato, lumuti yalo kufu naba-naba oti weni kofala uguti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Netawa muki yamu logimomo ya moda koliti kolife loti kolafe? loto loga o gedaito, eti loumamo, O, moda kolito kolife loto kolone, loumato, ");
INSERT INTO snp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","amokafo limo, Goti lo melami kala kolife loti kolamo we yate kosinau Menefo wenenala kiyaba o ledami ka api gilibomo ya koli kikitoti meyalo melenawamo, ya we ma api lilibamo ka lila ido ka kofawa yauti neta lalo olami yaidana oto ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesukafo kepa ka mona-mona muki ya loto lo fuli loito ebawa ya fulito ");
INSERT INTO snp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aimola numuna ebalalo oto mono numunigu dito ka mono api gilibaito, kolamo ya elegiti eti lamo, Aiyo, ka manenau nemo yaki ido Goti aumala lilibami netawa olu oloto pi lomami auma yaki egalekati olaiye? ");
INSERT INTO snp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wewa auwa ya numuna ku-ku imo we nalafoma yae. Ido olafo Malia ido kunalafo-mota Yemusikele Yosefekele Saimonikele ido Yudasikele yama yae. ");
INSERT INTO snp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ido emonala-mota muki ya lamoki lakoina minonima yae. Ena wewa ama netawa-matawa muki ya egalekati olaiye? loti ");
INSERT INTO snp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","amo yamu seni-mulunigu eleka fi umae. Eti ato Yesukafo eti limo, Polofete ma aimola numuna meyalo ido aimola numunalo yako wenenala kuliya olu faka ádenagilamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ido aya ebalo wenena muki koli kikinina minámainako, neta kofawa Goti aumala gilibami neta muki ya gilibámaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ena aya kamenalo ya Galili wenena kiyabani we wenaba Heloti ya Yesu kala kuwa kolitoto, amoki lakoina minamo wenena ya eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aya wewa ya Yoni noku wi-wi imo we minoto ya folaiguti olu nedi edainako, yamu Goti aumala lilibami auma ya mino edaito netawa iye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ido komu Helotikafo kunalafo Filipi olonafo Helotiyasi olami yamu Yonikafo eti loumami, Wenawa ya olanimo ya Mosese lo melami kala ya fukaninako, lifimaka ne, loto loumami yamu Helotikafo limo, Yoni ya oluti ana-kiyanalo nela wi edeti, nela numugu fulo edalo, logimito gilifi melaito wae. ");
INSERT INTO snp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wato, ofo fulunae, loto kolaifa, wenena muki yate polofete ne, loti kolamo yamu kolini kolaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ena Heloti oloto piyami kamena o fedaito, Helotiyasi olulafo ya wenena muki omunido melege olaito, Helotikafo eyami siya-mulunau koli lalo ito ya eti limo, ");
INSERT INTO snp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Namo Goti omunalo auma wito lo melomo, kamokafo neta yaidanaamaidana olunae, lenanimo ya moda kumunagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Loumaito, olafokafo komu olulafo kala oluto eti limo, Yoni noku wi-wi imo we kenobala fuko fuloto atela ya lapelo meleto oto nomo, loto loumo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Loumaito, kala meyalo melenami kiyaba wenabama siya-muluna keina ifa, weni-neta lakoina namo wenena omunido auma wito lo mele edainako, eti limo, Netawa oluto oto umo, loto ");
INSERT INTO snp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","we ma ilifi melaito, nela numugu ya uto Yoni kenobala fuko fuloto ");
INSERT INTO snp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","atela ya lapelo meleto oluto oto nomiliwa umaito, oluto uto olafo umaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ena Yoni ege melamo we yate oti kono ukana oluti uti kale li edeiti uti Yesu kawa ya loumae. ");
INSERT INTO snp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ena Yesu kawa kolitoto minami eba ya fulito sipiku dito fafato mikau wiye. Utaito wenena muki kawa ya koliti, numuni ebani fuliti mikalo moniti ege wae. ");
INSERT INTO snp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ege wato, Yesu nofuna anawalo o fedeto sipikuti lumuto, wenena muki ya geyeto siya-mulunau milumani kolito neta kilamo wenenani ya olu faka lo gede minaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ena lunaga melaito ege-ege moinamo we amo nedo oti ya eti loumamo, Amalo ya mika fafato minogeto moda lunaga meletaiye. Wenena ya gilifageto numudo-numudo uti weni-neta meina finawae, loti lafa, ");
INSERT INTO snp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesukafo nedito unawamo ne? Linate yate weni-neta ma gimalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Logimaito, itibiti loumamo, Beleti faifu (5) ido laefa lele (2) yako olu minone, loumato ");
INSERT INTO snp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","eti limo, Netawa ya ama namo minodoka otalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Logimito ido wenena mau wiyamo yuwalo amedalo, loto logimito beleti faifu (5) oluto laefa lele yaki oluto kosinau kogo koto, Siyane, lalole, loto loumuto ya beletiki laefaki leketo, ege-ege moinamo we gimaito, wenena mau naba minamo ya gimae. ");
INSERT INTO snp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gimato, muki wenena noti muni ito, luma nemo oluti koilamo ya owo kedikoko naba tuwelu (12) koilamo ya faitiye. ");
INSERT INTO snp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ido weni-neta namo wemomo ya faifu tauseni (5,000) minato, ido wenaipaki nomilipaki ya katámae. ");
INSERT INTO snp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ayalo Yesukafo ege-ege moinamo we ya eti logimami, Wenena mau wiyamo gilifi melodo ya linateki sipiku ya diti nofuna filiga akala komu meleti walo, loto logimaito, sipiku diti wae. ");
INSERT INTO snp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wato, wenena mau wiyamo ya gilifi meleito aimolako Goti loumunae, loto mowalo dito minaito, sinidito aimolako ayalo minaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Minaito, sipima mika fulito u nofuna muliti utaito, epe ma konidokati aito no yamo satoto oto sipima ofaito, oluto dito lumuto iye. ");
INSERT INTO snp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kolomolo yaleka Yesu nofuna no mulalo kiyanakafo leya wito monimo oto minado o fedaito, ");
INSERT INTO snp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","eyeti ukani ololo oti ya, Aiyo, kolofa ne, lato koli gimaito, kai melato ");
INSERT INTO snp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu alako logimami, Seti-muludi you laneyo. Namoma minowe. Koli gimámaneyo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Logimaito, Pitakafo eti loumami, Wekolao, ona minagetoma no mulalo ano, lonomageto no mulalo monimo minanido enae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eti lito, ya ano, loto loumaito, Pita sipikuti lumuto no mulalo monimo Yesu nedo aifa, ");
INSERT INTO snp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","epe naba imo eyamikafo koli umaito, no lulau lumuto, Wekolao, anelo olo, loto au loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ayalo Yesukafo ana sino loto ukanalo oluto eti limo, Koli kikika kefo efema nemo ya nedito kaka lele kiyane? loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","lelewai sipiku idaito, epe fulitaiye. ");
INSERT INTO snp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ido sipiku minamo we ouni-luni-kani ya umuti eti loumamo, Kamo ona Goti Nalafole, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ido nofuna ya yofototo uto Genesalete mikau o fedato, ");
INSERT INTO snp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","wemomo ebawa yau minamo yate eyetiti, aya wema ne, loti eyefe loti kolato, eba adu nedo-nedo ya ka fulo filiga-filiga ato, wenena neta kiliti minamo muki ya gilimiti amo nedo oti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Neta kilamo yate owo wiyanimo onowalo yako olunawafao? Loti wako lo edato, neta kilamo wenena muki anikafo olamo ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ka mono lufuwa api gilibamo we ido Falisi we ya Yelusalemukati Yesu nedo oti loga o edeti eti lamo, ");
INSERT INTO snp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kege-kege moinamo we yate autefo-mota kidene kanina koliti olu fulitae. Nediti weni-neta nenagilima ya ani noku wiyámae? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Loga o edato, amokafo eti limo, Ido linate ya nediti autibo-mota kidene kani meyalo meleti ya Goti lo melami kala meyalo melámae? ");
INSERT INTO snp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yamu Gotikafo limo, Otibo metibo kulini olu faka lalo, loto lo meleto lima ne. (Kis 20:12, Lo 5:16) Ido ka maki limo, We makafo ka nosámami olafofe melafofe ya lo gedenami, aya we ya ofo folalo, loto ka mono lufuwau (Kis 21:17, Wkp 20:9) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Etito nemo yama nefa, linatete eti lo-lo amo, We makafo olafofe melafofe eti logiminami, Koukamene ko nomo yakafo adi olu faka lenami netama ya Goti moda umutonako, yamu linate olámenawami ne, loto logiminami ");
INSERT INTO snp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ya netawa olafo melafo gimámenagoliye, loti lo-lo ae. Etiti linanimoni ya autibo-mota kidene kanina ya meyalo mele minafa, Goti lo melami ka ya olu faifa neta yaidana oti fulitae. ");
INSERT INTO snp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Linate monabi lele wiyamo yamu Gotikafo Aisaiya welalo ka melaito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Aya wenenawa ya wenido yako kuline olu faka lafa, ido senimulunigu koli nomámamo ne. ");
INSERT INTO snp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ouni-luni-kani sukiko numuti, ido fa wenena kidene kani yako api gilibi-gilibi ae, loto ka mono lufuwau (Ais 29:13) nemo ya linatemu ka ona lo gedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesukafo wenena mau wiyamo luni fiyaito, amo minaido ato, ya ani noku wi-wi amo mona yamu logimami, Koliti kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Neta-mata wetigu namo yakafo Goti omunalo linate ya olu ladi o gedámaifa, wetiguti feka ami yakafoko Goti omunalo linate ya olu ladi o gede minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Logimaito, ege-ege moinamo we ya amo minaido oti loumamo, Falisi wemomo ya ka lanimo kolititi lukafa naba otae. Moda kolabe? loti loumato, ");
INSERT INTO snp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","amokafo eti limo, Ufa neta Menefo kosinau nemo wekafo kifámami ya lufawaki afunami ne. ");
INSERT INTO snp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Koiti gedalo. Wenenawa kanu gilibamo omuni likami wenena yaidana oti minae. Ido omuna likami we makafo ailo ma omuna likami we ya kanu ma ilibagetoma, lelewai ya kale nabau yau lumu fou lenagilaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Logimaito, Pitakafo eti limo, Kepa kawa mona ya lolomageto kolinune, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesukafo goduto eti limo, Ake, linate yaki kolife loti kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Weti-neta ya wetigu nato, uto seti-kofumawau uto minoto, aiga ya sefe lo fulo-fulo amo yama kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eti ifa, wetiguti feka ami ya oudi-luti-kati yauti ami nemo yakafoko Goti omunalo linate ya olu ladi o gedenaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yamu oudi-luti-kati yauti ya kati-manidi nosámami kiyamo, wenena ya gini fulunumolae, ido kume-ugele nenumolae, ido kopa-napa olu onenumolae, ido neta ugele olunumolae, ido suki ka lenumolae, ido kamani kinumolae, loti kati kiyamo netawa muki ya oudi-luti-kati yauti ami ne. ");
INSERT INTO snp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aya netawa yakafo Goti omunalo linate olu ladi o gede minaifa, ido ani noku wiyámamo mona yakafo Goti omunalo olu ladi o gedámami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ena Yesu ya ebawa fulito monimo Taiyaki ido Saidoniki eba afulaleka wiye. ");
INSERT INTO snp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wito, yalo wena ma Yuda wena minámami ailo Kenani mikauti ami yakafo amodo oto lula naba fito eti loumami, Wekolao, Defiti ufa fiyami we, namomu mulugau miluma koli nedo. Satani kimiwelakafo olunefo siya-mulunau minoto kaila fi ede-ede minaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Loumaito, amokafo itibito ka ma loumámaito, ege-ege moinamo we amo nedo oti ya eti lamo, Wenawa ilulu kuto kai naba-naba mele minoto lege-lege melainako, ilifi melo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Loumato, eti limo, Isilaeli wenena sipisipi fuisamo mona yaidana oti meleti minadoka yako nilifaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Logimaito, wenawa ya oto amodo kiyanalo kuba wi edeto ya eti limo, Wenabao, ane olu faka lo, loumaito ");
INSERT INTO snp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","eti limo, Nomilipa weni-neta oluto fiyaloto kula giminumo mona ya onámaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Loumaito, itibito limo, Wenabao, ona laba, kulama yate aboganina weni-neta no minato lana mikalo olumo wiyami ya no-no ae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesukafo limo, Wenao, koli kikika naba ne. Fede numunaiye, loto kolanimo neta ya fede kumunami ne, loto loumaito, ayalo olulafo faka lo fulitaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ido Yesu aya eba fulito monimo Galili nofuna naba anawalo uto monimo mowalo dito amedoto minaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ido wenena mau naba-naba wiyamo yate kiyani nosámami, ido kiyani-ani gali-magalidimo, ido omuni likami, ido nei kilamo, ido neta ailo-ailo kilamo wenena ya gilimiti amo nedo oti kiyanalo mau wi gedato, muki olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Olu faka lo gedami, ya nei kilamoma ya ka lamo, ido kiyani-ani gali-magalidimoti yama ya u lalo wamo, ido kiyani nosámamiti yamaki kanu moinamo, ido omuni likamiti yamaki ya kamo ya geyeti yamu wenena muki yate elegiti Isilaeli wenena Gotinina ebola lae. ");
INSERT INTO snp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesukafo ege-ege moinamo we luni fiyaito ato, eti logimami, Wenena naba mau minamo ya fo kamena tili (3) yalo ya namoki umalo minamo ya nenawamo neta minámami yamu sene-muluneu miluma koli gimoneto, kadunamu folanako, uti kanudo lumu fou lotenawae, loto gilifi melámenagolowe, loto kolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eti loto logimaito, ege-ege moinamo wema yate loumamo, Eba ama fafato ya nenako, beleti naba ma egalekati oluto wenena mau naba yaidana ya gimogeto noti ogofunawamo ne? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ido Yesukafo limo, Beleti nenaki olu minae? loto loga o gedaito, itibiti loumamo, Lamo beleti seweni (7) ido laefa kefola maki olu minone, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eti loti loumato, wenena muki amedoti minalo, logimito ");
INSERT INTO snp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","beleti seweni (7) ido laefa ya oluto, Siyane, lalole, loto leketo ege-ege moinamo we gimaito, wenena mau naba minamo ya gimae. ");
INSERT INTO snp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gimato, muki ya noti muni ito, ido luma nemo ya olu mau wiyamo owo kedikoko naba seweni (7) koilamo ya faitiye. ");
INSERT INTO snp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ido weni-neta namo wemomo ya fo tauseni (4,000) minato, ido wenaipaki nomilipaki ya katámae. ");
INSERT INTO snp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ena wenena muki gilifi meleito ya sipiku dito uto monimo Magadani mikau wiye. ");
INSERT INTO snp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ena Falisi we ido Sadusi we yate kepa mele umunune, loti Yesu minaido oti ya eti lamo, Kosinaukati Goti aumala lilibinami neta ya lilibageto kenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lato, amokafo itibito logimami, Lunaga ya fo sapito kosina ufa lafa limo kotima, ya leda fo lenami ne, loti lo-lo ama ne. ");
INSERT INTO snp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ido leda ya kosina sinidoto epe itoma, onema ya ko winagoliye, loti lo-lo ama ne. Ido linate ya kosina monawa ya eyeti kolife loti kolitafa, ido namomu ido oiya kamena yamu ya mebe-mabawa fedami eyeti ya monawa kolife loti kolinawamo ya ogoufámae. ");
INSERT INTO snp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mona nosámami meleti Gotiki ekelámamo wenena yate Goti aumala gilibami neta moni wilafa, ido Goti aumala gilibami neta ma ya olu oloto pi gedámenami ne. E’e, polofete Yona ukanalo Gotikafo aumala ilibami mebe-maba yako olu oloto pi gedenami ne, loto logimito fulo gedeito wiye. ");
INSERT INTO snp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ido ege-ege moinamo we nofuna anawa filigaleka ya u fedeti beleti kani melaito oluti áumae. ");
INSERT INTO snp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ido Yesukafo limo, Falisi we ido Sadusi we yisinina ya ekena oti moinalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kawa logimami ya inanimonigu lokoli-fakoli oti ya eti lamo, Beleti oto ámoninako, yamu, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka lamo ya Yesu kolitoto eti limo, Koli kikitina kefo efema nemo we, nediti beleti otámamo yamu lokoli-fakoli o minae? ");
INSERT INTO snp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Linate ya kolife ádoti minafe? Beleti faifu (5) oluto wenena faifu tauseni (5,000) gimomo yama kati melaife? Ido luma nemo oluti owo nenaki ya koilae? Yamaki kati melaife? ");
INSERT INTO snp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ido beleti seweni (7) ya wenena fo tauseni (4,000) gimomo yamaki kati melaife? Ido luma nemo oluti owo naba nenaki ya koilae? Yamaki kati melaife? ");
INSERT INTO snp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Beleti yamu logimámowe. Egaidana oti kolife loti kolámae? Linate ya Falisi we ido Sadusi we yisinina ya ekena oti moinalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ayalo ka limo mona ya moda kolamo, Yisi ona yamu ekena oti moinalo, loto ádoto, Falisi we ido Sadusi we api gilibamo kanina yamu ekena oti moinalo, loto logimami kawa monawa ya kolife loti kolae. ");
INSERT INTO snp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesukafo Sisalia Filipai ebau ototo ege-ege moinamo we loga o gedeto eti limo, Wenena muki yate namo We Kula yamu ya kema minaiye, loti lo-lo ae? loto ya loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Loga o gedaito, itibiti eti loti lamo, Wenena maleka yate Yoni noku wi gede-gede imo we ya minane, loti lo minae. Ido maleka yate Elaiya ya minane, loti lo minae. Ido ma yate Yelemaiyafe, ido we ma polofete minaguti we ya minane, loti lo minae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ido linate yate namo ya kema ne, loti lo minae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimoni Pitakafo eti limo, Kamo ya kilifi melami we Kilisto, Goti minowa-minowa imo we Nalafo ona ya minane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Loumaito, Yesukafo limo, Ba-Yona nalafo Saimoniyo, ka etito lanimo ya wenena yate lo oloto pi komámae. Aya kawa ya Menefo kosinau nemo wekafo efe loto olu oloto pi kedami yamu lalo koli minomo wane. ");
INSERT INTO snp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kamo ya Pita minane, loto lokomowe. Ido kifana naba-naba ama mulalo ya mono wenenane olu mau wi gedemo idoneto fulumo wamo mona olu afima o gedenami ya ogoufámenaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ido kosinau nemo we wekudite wenenala kiyaba o ledami kilala kanu-wela wito kuto enanimo auma ya kumunae. Ido neta muki mikalo nela winanimo ya ayaidana oto kosinau yaki nela moda witami ne. Ido neta muki mikalo efilinanimo ya ayaidana oto kosinau yaki moda efilitami ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Loumutoto ege-ege moinamo we liliga ya logimami, Namo yamu ilifi melami we Kilistole, loti wenena muki logimámalo, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kamena yaloti Yesu Kilistokafo apito ege-ege moinamo we ka lo oloto pi gimito eti limo, Ena Yelusalemu numudo woneto wenena kiyabani we ido Goti yokila ki umamo we ido lo melami ka api gilibamo we yate keina naba-naba olu mofu nedeti nofo folato, fo kamena tili (3) minoneto ya olu nedi nedenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ena Pitakafo ilimito anawaleka uto oduto ya limo, Ake, Wekolao, moda netawa ya ona fede komámenami ne, loto auma wito loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Loumaito, Yesu eleyapa wito limo, Sataniyo, negeka wa. Kamo ya kifanalo kiyane uteba winamo kifana yaidana oto minane. Goti kala kiyami yaidana oto kaka kiyámoto, faifa mikalo wenena kani kiyamo yaidana oto kaka kiyanimo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesukafo ege-ege moinamo we ya logimami, We makafo namo nege melenae, lotoma ya aimola siya-mulunau kolinami neta ya fulito, yá yofola ya mofuto nege melenaiye. ");
INSERT INTO snp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yamu we makafo aimola ukana atuwamuko koli minoto fulunami we ya u kopa unagoliye. Ido we makafo namomu kolito monimo uto ukana atuwa fulunami ya omuna kofawa minowa-minowa enagoliye. ");
INSERT INTO snp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","We makafo mikalo neta-mata muki ya ko noto monimo wifa, ido ouna-lula-kala u kopa unami we ya ko nami netala-matala egaidana oto ana olu faka lenami ne? Ido nena-netakafo meina fito ouna-lula-kala kofa itibito olunaiye? ");
INSERT INTO snp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ena namo We Kula ya Menefo lamenala nabau yau kosinau enisoleneki lakoina ya oloto pito oto wenena muki inanimo monanina melado ya lifimanina iya mele giminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Namo ona logimowe. Oiya ama nedi minagu yauti maleka ya folámoti, komu ya namo We Kula ya wenenane kiyaba o gedenae, loto enamo kamena ya neyenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Fo kamena sikisi (6) ya utaito Yesukafo Pitale, ido Yemusile kunalafo Yonile gilimito mowa naba fanalo diti inanimoni yako minato, ");
INSERT INTO snp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","omunido Yesu ukana ya u ailo builaito, kola-wela ya fo lamena yaidana oto lamena ito, ido ukanalo owo ya feke ona limo yaidana oto lamena iye. ");
INSERT INTO snp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ayalo Mosesete ido Elaiyate oloto piti amoki ka lo minato geyae. ");
INSERT INTO snp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Geyetiti Pitakafo eti limo, Wekolao, amalo minonimo ya lalo iye. Kaimoka kolinanimo ya numuna kolo-kalo tili (3) kuwogeto, ma ya kamo numuga minenaiye. Ido ma ya Mosese numuna minenaiye. Ido ma ya Elaiya numuna minenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eti lito, moda kawa lo minaido ayalo ya limu ma lamena kuku limoma ya moda oto asa wi gedaito, ya moda limuku yauti nola ma kolamo eti limo, Ama ya sene-mulune umomo Nanefo ya ne. Amo ya lalo eyowe. Kala ya luti-katigu kolalo, loto liye. ");
INSERT INTO snp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ena ege-ege moinamo we kawa nola koliti ya mikalo lumu fou loti koli naba-naba kolato, ");
INSERT INTO snp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesukafo ya minado oto ukanido oluto ya eti logimami, Mikalo yati nediti koli kolámalo, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ko faka loti eyamo ya wenena ma minámato, Yesu aimola yako minaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ena mowaloti monimo lomado ya Yesukafo logimami, Neta oiya eyamo ya wenena ma logimámoti, minomo wato namo We Kula ya fulunaguti neidoneto ya logiminawae, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lo fuko gedaito, ege-ege moinamo we eti loti loga o edamo, Elaiya komu enami ne, loti lo melami ka api gilibi-gilibi amo we yate nediti eti lo minae? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Loga o edato, eti limo, Ya ona ne. Elaiyakafo komu oto neta-mata muki ya olufe lenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Etito nemoma nefa, Elaiya ya moda otaifa, eyeti eyefe loti eyámoti, neta-mata muki seni-mulunigu kolamo ya o edetama ne, loto logimowe. Ido ayaidana oti namo We Kula ya keina naba-naba numunagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eti lito, ege-ege moinamo we ya Yoni noku wi gede-gede imo we yamu logimaiye, loti kolae. ");
INSERT INTO snp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amo ya wenena mau witi minado ya itibiti o fedato, we makafo oto kiyanalo kiyana umola fito ");
INSERT INTO snp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","eti limo, Wenabao, nanefomu seka-mulugau milumala kolo. Kulu ofoto ukana ogofu naba-naba olu umaito, kamena-kamena yokufe, ido noku yau lumu fou lo-lo iye. ");
INSERT INTO snp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Etito kege-kege moinamo we minadoka ilimito ofa, ukana olu faka lo edenawamo ya ogoufámae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Loumaito, Yesukafo limo, Ake, linate koli kikitina minámaito monatina lekesa wiyami melamo wenenao, kamena nenaki ya linateki minenae? Ido kamena nenaki ya linate keinatina mofu gedenae? Kipawama ilimiti namodo alo, logimaito, ");
INSERT INTO snp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ilimiti ato, Yesukafo Satani kimiwela oudaito, kipa lulauti fulo edeito wito, ayalo ya moda faka loitaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ena ege-ege moinamo we inanimoko minoti Yesu nedo oti eti loga o edamo, Olu fulo edeto ilifinumo ya nedito ogoufámone? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","eti limo, Koli kikitina kefolako nenako, yamu ilifinawamo ya ogoufámae. Etito nemo nenako, namo ona logimowe. Koli kikitina ya yá kolipa ilawa yaidana oto minenami ya mowa aufa ya yaleka fulito amaleka ano, loumunawamo ya enagoliye. Ido neta ma yamu ogoufámone, loti ádenawamo ne.  ");
INSERT INTO snp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Eti enawafa, ido aya Satani kimiwelawa yaidana imo yamu ilifinuwe, lotima komu weti-neta moi witi Goti loumutiko ilifinagilae. Ilifinawamo kanu ma minámaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ido Galili yalo lako wato, Yesukafo eti limo, Namo We Kula ya wenena anido gimato ");
INSERT INTO snp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nofo folato, fo kamena tili (3) wageto fulunaguti ya olu nedi nedenagoliye, loto logimaito, koliti seni-muluni keina naba-naba iye. ");
INSERT INTO snp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ena Kapeneyamu numudo o fedato, ya felegaga kuliyai numuna naba kifana takisi olu-olu amo we yate Pita nedo oti loga o edeti lamo, Api gilibami we yakafo felegaga kuliyai numuna naba kifana takisi ya fulo-fulo ámaife? loti lae. ");
INSERT INTO snp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lato, itibito logimami, Moda fulo-fulo iye, loto logimito numunau di minaito, ayalo Yesu oto komu loga imo, Saimoniyo, kaka kiyo. Mikaleka wenena kiyabani we wenaba ya egalekati kifana takisi olu-olu ae? Wenenanina yalekatife, ido mika malekati amo wenena yalekatife? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Loga o edaito, Pitakafo limo, Mika malekati amo wenena yalekati olu-olu o minae, lito ya Yesukafo limo, Etito nemo nenako, lamo nanibo minonimo ya kifana takisi fulámenumo ne. ");
INSERT INTO snp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nefa, seni-muluni koli lumunawamo nosámotenaiye, loto uto nofugu ya laefa olamo nela ya noku fuloto laefa kana olunanimo ya ika oto welau ya olu atoto kifana ma minenami ya oluto kamote namote kulitelo kifana takisi ya gimo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aya kamenalo ya ege-ege moinamo we Yesu nedo oti loga o edamo, Kosinau nemo we wekudite wenenala kiyaba o ledami kilalau ya kema komu meleto kuliya nemo we minenagoliye? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Loga o edato, nomilipa kefola ma lula fiyaito, aito omunido minagu olu nedi edeto eti limo, ");
INSERT INTO snp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Namo ka ona logimowe. Linate monatina ya olu eleyapa witi u nomilipa kefola yaidana oti ámenawamo ya kosinau nemo we wekudite wenenala kiyaba o ledami we kilalau yau ámunagilae. ");
INSERT INTO snp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ido we ma siya-muluna oluto lumuto nomilipa kefola ama yaidana enami we ya kosinau nemo we wekudite wenenala kiyaba o ledami we kilalau u komu meleto kuliya nemo we ona minenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ido ma yate namomu koliti nomilipawa kefola amaidana oto minamo wenena olu koina wi gedenawamo ya namoki olu koina wi nedenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ido Yesukafo ka ma eti limo, We makafo nomilipawa kefola koli kikito nomamo wenena yauti ma ya kola wito koli kikila olu kopaitenami wewa ya ana-kiyanalo oluti kenebalalo kifana naba-naba nela witi kuwo no sumitigu no noto fulunaiye, loti fulo edamo neko, moda lalo agi ne. ");
INSERT INTO snp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mika negu-negu ya neta nosámami yakafo koli kikito nomamo wenena ya kani fito kanu lalototi ika o gedenami ne. Netawa-matawa nosámami ya moda fedenagolifa, ido we makafo koli kikito nomamo wenena ya kani oluto kanu lalotoka yati ika o gedenami we ya keina naba-naba kolinami ne. ");
INSERT INTO snp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yamu aga yakafofe ido kiyaga yakafofe lifima olu mofu kedagetoma aga yafe ido kiyaga yafe fukoto olu fulito. Moda kolafe? Etito aga filigakofe ido kiyaga filigakofe mako minageto ya mino ko-ko amo ebalo dinanimo mona yakafo aga lelefe ido kiyaga lelefe nemokafo eifámenami yoku unanimo mona ya olu afima edaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ido omuga yakafo neta eyeto lifima olu mofu kedagetoma ya omuga ikilito fulo. Etito omuga lawokoko minageto mino ko-ko amo ebalo ya unanimo mona yakafo omuga lele minageto yo eifámenami yoku yau unanimo mona ya olu afima edaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ido koti moinalo. Wenena nomilipawa kefomaidana yauti ma ya menumu o edámalo. Ka ama logimowe. Kolalo. Enisole kiyaba o gedamo kosinaleka minamo yate kamena-kamena Menefo kosinau nemo we ya kola-wela ko-ko o minae.  ");
INSERT INTO snp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yamu namo We Kula ya moni fuisamo wenena ya moni wilito olu omuni kenae, loto omo ne. ");
INSERT INTO snp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kati kiyalo. We ma sipisipila wani hadeti (100) neguti lawoko ma fuisagetoma, wewa yakafo sipisipila muki nainti-naini (99) faifa nemo ya fulo gedeito mowalo ya uto, sipisipila lawoko fuisamima ya moni wilámenaife? ");
INSERT INTO snp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ka ona logimowe. Moda moni wilito olu oloto pinami ya siya-muluna lalo kolami mona yakafo sipisipila nainti-naini (99) ya fa nemo yamu siya-muluna lalo kolami mona yama olu afima edenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Etito ayaidana oto Metibo kosinau nemo we yakafo nomilipawa kefola minagu yauti lawoko ma fusinaiye, loto kala kolámami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ena mono wenenaka minaguti koinakafo makafo mona nosámami mele kedenami ya uto linanimoniko minoti nosámami mona melami yamu oudo. Oudageto kaka ya kolife loto kolagetoma koinakafo kofa itibito olunanimo ne. ");
INSERT INTO snp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Etito nefa, ido kaka koli fulagetoma, kamoki we lawokofe ido lelefe lakoina ka kolinawamo ya gilimito minaido unawae. Aiga wenena lelefe ido lelei-lawokoife ya ka lanimo ya onae, loti logiminagilae. ");
INSERT INTO snp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ido kanina ya kolámagetoma monolo mau wi-wi amo wenena logimageto, uti loumato kanina yaki kolámagetoma ya ailo feka wenena ido kifana takisi olu-olu amo we mona mele gedenawamo yamaidana oti mona mele edenawae. ");
INSERT INTO snp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ka ona kula logimowe. Ama mikalo nela winanimo ya ayaidana oto kosinau yaki nela moda witami ne. Ido neta muki mikalo efilinanimo ya ayaidana oto kosinau yaki moda efilitami ne. ");
INSERT INTO snp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kofa logimowe. Mikalo uma lele mate neta-mata mamu koliti, seni-muluni lawoko meleti lumunabe? loti loumunawami ya Menefo kosinau nemo wekafo kolito netawa muki eti o gedenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yamu wenena lelekofe, ido tili (3) yako ya namo kulinelo lakoina minenawamo ya amo minagu yau minenagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ena Pitakafo Yesu nedoka oto eti limo, Wekolao, kamena nenaki koinanefokafo mona nosámami mele nedagetoma, lifimala kilili o edenae? Kamena seweni (7) meloneto ya modafe? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesukafo limo, Kamena seweni (7) melageto ya moda ne, loto lokomámowe. E’e, kamena sewedi-seweni (77) ya kilili o edemo wo. ");
INSERT INTO snp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yamu kosinau nemo we wekudite wenenala kiyaba o ledami monala ya mikalo kiyaba wenaba makafo kouba-nabala we lifima gimami ya olufe lenagolowe, loto kolami we yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ena lifima apito olufe lo gedemo wito we ma lifimala teni tauseni (10,000) taleni ya nemo amo nedo ilimiti ae. ");
INSERT INTO snp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ilimiti afa, lifimala itibito umunami ya ogoufámainako, yamu kiyaba wenabala yakafo kouba-nabala wenena ma eti logimami, Wewa, olonafo, nomilipala yaki gilifi ailo wenena lononido itageto, uti lono olato, lononina meinala ya olunae. Ido koukamela muki ya kifanalo fuloti kifana oluti ya kifanane moda nami ya itibiti nomalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Logimaito yamu koubanabala we yakafo kiyanalo oto kiyana umola fito wako lo edeto eti limo, Wenabao, ka lanimo eti ádoto, kiyaba mino. Kifanaka muki ya itibito kumunagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ido kiyabala we wenaba ya kala kolito, siya-mulunau milumala kolito, efilito lifimala kilili o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kilili o edaifa, kouba-naba wewa ya feka uto eyaima ya kouba-naba we ma wani hadeti (100) denaliyasi ya umaito lifimala faifa nemo we ya eyeto, kenebala oluto, ipili wito eti limo, Kifana komomo muki ya moda oiya itibito nomo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eti lito, kouba-naba wewa ya auwafo kiyanalo uto kiyana umola fito eti limo, Ka lanimo ya eti ádoto, kiyaba mino. Kifanaka muki ya itibito kumunagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Eti lifa, kala kolámoto, ilimito uto nela numugu fulo edeto limo, Kifana lifima muki itibito nomagetoma efili kedenae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Eti loumaito lono lakoina olamo koinalafo-mota yate koinanibo eyamo ya seni-muluni nosámaito, kiyabani we wenaba nedo uti kawa muki loumae. ");
INSERT INTO snp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Loumato, kiyabani we wenaba yakafo wewa lula fiyaito aito eti limo, Kouba-naba we nosámami ona minane. Milumane kolo, loto lonomaninako, kifana lifimaka muki ya kilili o kedowe. ");
INSERT INTO snp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Namo ka lanimo kolito, sene-muluneu milumaka kolomo yaidana oto kamo yaki koinakafo yamu seka-mulugau milumala nedito kolámane? loto loumuto, ");
INSERT INTO snp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","siya kala-kala naba lito, nela numugu ukana ogofu olu umunawamo we anido gimito eti limo, Kifana lifima muki itibito nomagetoma efili kedenae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ena linate muki seti-muludigu yau koinatibo-mota lifimanina ya kilili o gedámatoma Menefo kosinau nemo wekafo ayaidana oto lifimatina ya kilili o gedámenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu aya kawa ya lo fuli loito Galili mika fulito, monimo Yudia mikau Yodani no naba filigaleka wito, ");
INSERT INTO snp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","wenena mau naba-naba ege melato, ido yalo wenena neta kilamo olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ido Falisi we yate, Kepa mele umunune, loti amo minaido oti eti loti lamo, We ma olonafo ya mona mona melami yamu fuko fulitenami we yakafo lo melami ka fukenaife? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Loga o edato, amokafo eti limo, Kana ya mika kosina olu oloto piyami wekafo we wena olu oloto piyaiye, loto ka mono lufuwau (Stt 1:27) nemo ka ya katoti kolife loti kolámafe? Ido ka ma eti limo, ");
INSERT INTO snp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yamu wemomo yate onibo menibo fulo gedeiti olonibodo ekelamo, lele ya ukani u lawoko oti minenawaiye. loto ka mono lufuwau (Stt 2:24) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yamu lelewa ya lele minámaiye. E’e, moda u lawokoko oti minainako, yamu Gotikafo olu ekelami ya wenena fuko filiga-filiga o gedámalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Logimaito, itibiti lamo, Etito netoma ya Mosesekafo we ma olonafo fuko fulitenami we ya kiyaba we minadokati lufuwa wiyamo ya oluto olonafo umuto fuko fulitenamile, loto limo ya nedito liye? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Loga o edato, itibito logimami, Linate seti-muludi gedimo yamu Mosesekafo ya olodibo fuko filiga-filiga fulenawamo ya etiti enawae, loto kawa limo ne. Nefa, kana ya kanu yaidana oto minámaima ne. ");
INSERT INTO snp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E’e, we ma olonafo kopa olu ono-ono oto moinámami ya fuko fulito uto wena ailo olunami we ya moda kume-ugele nenaiye, loto logimowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eti lito ege-ege moinamo we ya eti loumamo, Etito netoma wena olámenagolimo mona yakafo we wena lakoina mofu meleti minenawami mona ya olu afima edaiye, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Loumato, ido amokafo eti limo, Wenena muki kawa kolamo ya ogofuti meyalo melámenawae. E’e, Gotikafo aya auma gimami wenena yako kawa meyalo melenawae. ");
INSERT INTO snp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Etito we maleka ya onibo mulunauti wenate ekeleti ogoufámenawamo we minamo yamu wena olámenawae. Ido wenena yate we maleka olu wenate ekeleti ogoufámenawamo we gedanako yamu wena olámenawae. Ido we maleka ya kosinau nemo we wekudite wenenala kiyaba o ledami we ya kouba-naba o edenune, loti kolanako, wena olámenawae. Kawa ya kolife loti koliti koli ogofunawamo ya kawa oluti meyalo melalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ena nomilipa kefola ma Yesu nedo gilimiti amo ya anakafo atenido oluto amomu kolito Goti loumunaiye, loti afa, ido ege-ege moinamo we yate goudae. ");
INSERT INTO snp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Goudato, Yesukafo eti limo, Kosinau nemo we wekudite wenena nomilipawa yaidana oti minamo wenena ya kiyaba o gedainako, yamu nomilipa namodo enawamo ya kanu ku gedámalo, loto logimito, ");
INSERT INTO snp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ana ya atenido olutoto, ebawa ya fulito wiye. ");
INSERT INTO snp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ena we ma moda Yesu nedo oto loga imo, Api lilibanimo we, namo kofawa minomo dinamo mona ya olunae, loto kolinamo ya nena mona lalo melenamo ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Loga o edaito, eti limo, Mona lalo yamu nedito loga o nedane? Lawoko yako lalo ne. Ido kamo omune kofawa minenae, lotoma lo melami ka ya meyalo melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eti loumaito, amokafo limo, Lo melami ka ya egamae? loto loga o edaito, Yesu eti limo, Wenena gini folámo. Kume-ugele áno. Neta ugele olámo. Ka suki logimámo. ");
INSERT INTO snp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Okafo mekafo kulini olu faka lo. (Kis 20:12-16) Kaimoka yamu kolanimo yamaidana oto wenena muki ya seka-muluga gimo, (Lo 5:16-20) loto ka mono lufuwau nemo ka ya loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Loumaito, we kofawe yakafo limo, Kawa muki ya moda meyalo melemo wowe. Yamu ma egaidana enae? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Loga o edaito, Yesukafo limo, Kamo ufe ona lenae, lotoma ya uto koukameka muki ya kifanalo fuloto, kifana oluto neta ko ánamo wenena ya iya mele gimo. Eti ageto ya kosinau koukame lalo oloto pi kumunagoliye. Ido oto nege melo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Loumaito, we kofawe yakafo kawa kolito, neta naba ko nami nenako, yamu siya-muluna keina naba ito ya wiye. ");
INSERT INTO snp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wito, Yesukafo limo, Ona logimowe. Koukame naba-naba ko nami we yakafo kosinau nemo we wekudite wenenala kiyaba o ledami kilalau dinae, loto kolinami ya koiya naba finaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka kofa logimowe. Yafo-kameli yakafo naka kifiyau unami ya koiya finami nefa, ido neta ko nami we yakafo Goti wekudite kilalau dinae, loto kolinami ya oto dito koiya naba-naba finami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Logimaito, ege-ege moinamo we kawa limo ya koliti, elegiti eti loga amo, Etito nenako, yamu kema wenena olu omuni kenaiye? loti lato, ");
INSERT INTO snp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesukafo kogo efe loto geyeto eti logimami, Wenena yate ya ogoufámafa, Goti yakafo neta-mata muki eti enami ya moda ogofuto minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Logimaito, Pitakafo loga o edeto eti limo, Lamo moda neta-mata muki fulitoto kege meloninako, nena neta olunumo ne? loto lito ");
INSERT INTO snp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesukafo limo, Ona logimowe. Neta-mata muki kofawa oloto pinami kamenalo ya namo We Kula yakafo wenena kiyaba o gedenae, loto lamenau ekeina folomolo ya amedoneto, linate nege-nege moinamo yaki ekeina folomo ya tuwelu (12) yalo amedoti minoti Isilaeli wenena afo monalo-monalo tuwelu (12) ya iya mele gedeti wenenawa kiyaba o gedenawae. ");
INSERT INTO snp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ido wenena mate ya namomu koliti numuni ebani, yanibo kunanibo gemonani, onibo menibo, nomilipani, mini fulitenawamo wenena ya ayalo naba-naba itibiti oluti, ido omuni kofawa minowa-minowa oti minomo dinagilae. ");
INSERT INTO snp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Etito nefa, ido wenena mumudi kulinigi we minamo ya kulini ya lumunami ne. Ido kulini lomami wenena ya kulinigi we minenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kosinau nemo we wekudite wenenala kiyaba o ledami monala ya mika aboga yaidana oto ne. Leda luwaila fo idaito mika aboga uto nela waini ilawa kifami migu ya lono olunawamo we gilimito enae, loto wiye. ");
INSERT INTO snp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Etito uto wewa lono olunawamo wemomo ya fo kamena lawoko lono oluti ya lono fo kamena lawoko meina kifana denaliyasi lawoko ya olunawae, logimaito, O, olunune, loti lato, ido nela waini ilawa minau ya lonodo gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aiga fo lo gedito maketilo uto, wemomo ma faifa nedi minamo ya geyeto logimami, ");
INSERT INTO snp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Linate yaki nela waini ilawa mineu uti ya lono olato lono meina efe loto giminagolowe, loto logimaito lonodo wae. ");
INSERT INTO snp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wato, ido folilo yaki kofa itibito uto, ido lunaga yaki kofa uto, wemomo ma ya lonolau gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ido lunaga fo saipami yaidana uto, wenena maleka nedi minamo ya geyeto logimami, Nediti faifa foli nedi minae? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Logimaito, amote loumamo, We makafo lono olunumo lomámainako, faifa minone, loti lato, amokafo limo, Linate yaki nela waini ilawa mineu uti lono olu nedalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena lunaga meletaito mika abogakafo kiyaba imo we loumami, Lono olamo we muki ya olu mau wito, lono olutato aiga amo we lono meinanina ya komu gimo. Ido komu amo we meinanina ya aiga gimo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eti loumaito wenena fo saipaito lunaga oti lono olamo we muki ya lono fo kamena lawoko meinala kifana denaliyasi lawoko ya gimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ido leda luwailati lono apiti olamo wenena yama meina naba olunumo ne, loti kani kiyafa, ayaidana oto wenena muki yaki lono fo kamena lawoko meinala kifana denaliyasi lawoko ya gimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Etito gimaito, meina olado ya mika aboga ya oduti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wenena aiga amo ya kamena linako lono olamo, ido lamo ya leda luwailati oto lono naba olu minogeto fo loitaigu lono olonimo olu lawokoito meina yaidana oto lomane, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Loumato, amokafo we ma itibito loumami, Wenenane, olu nosámami kedámowe. Kamokafo lono oluto ya fo kamena lawoko meina kifana denaliyasi lawoko ya olunae, loto labe? ");
INSERT INTO snp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yamu meinaka oluto wo. Aiga ami we ya kamoki meina ayaidana oto giminae, loto kolowe. ");
INSERT INTO snp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Namo nanimo netanema nenako, yaida-amaida enae, loto kolinamo ya eti ámenamo nefe? Ido neta gimi kolonako, yamu seka-muluga naba ofo nomabe? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Etito wenena so loti kulinigi we minamo ya kulini ya lumunami ne. Ido kulini lomami wenena ya kulinigi we minenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ya Yelusalemu dinae, loto ege-ege moinamo we tuwelu (12) ya gilimito inanimoko kanudo wamo ya eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Moda Yelusalemu numudo akaiya idogeto, yalo namo We Kula ya yokila ki umamo we wenabaniki ido lo melami ka api gilibamo weki anido gimato, ka fi numuti nofo fulunune, loti ");
INSERT INTO snp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ailo feka wenena anido gimato, kamane kiti, nela kefakafo ipi nofoti, yá yofolo ya nofo folato, fo kamena tili (3) wageto fulunaguti ya kofa nedinagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ena aiga Sebedi olonafo neta ma olunae, loto kolaito, ido nalafo lele yaki Yesu nedo ato, onibo ya kiyana umola fi umaito, ");
INSERT INTO snp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesukafo loga o edami, Nena neta olunae, loto kolane? loto lito, itibito eti loumami, Kamo wenenaka kiyaba o gedenanimo kamena yalo nanefo lele ya ma fulo aga onaleka ito, ido ma aga adowaleka ito gedageto, ya amedoti kafukalo we minenawaiye, loto kolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eti lito, Yesukafo limo, Loga o nedanimo neta ya monawa kolife ádane. Namo kaila fi nedenawamo kapu ya linate yaidana oti ogofuti olunawaife? loto loga o gedaito, eti lami, Faifa olunalimo ne, loti loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesukafo limo, Namo keina kolinamo yaidana oti kolinagilaifa, ido kafunelo filiga-filiga minenawami ne, loto lenamo ya ogoufámowe. E’e, Menefokafo ebawa olufe lo gedetami wenena ebanina ya ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Logimaito, ege-ege moinamo we teni (10) ya kawa koliti aunibo lele kafuwalo we minenaliye, loti lainako, lelewa koli nosámami gimae. ");
INSERT INTO snp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yamu Yesukafo luni fiyaito ato logimami, Linate kolamo ya ailo feka wenena kiyabani we yate lono olamo ya inanimoni kulini olu faka loti auma witi, eti alo, eti alo, loti ka logimi-gimi ama ne. Ido kiyabani we wenaba yaki auma witi logimiti kiyaba o gede-gede amo monanina ya linate koli minama ne. ");
INSERT INTO snp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Koli minafa, ido mona melamoidana linate minagu ya melámalo. E’e, we ma linategu yauti wenabatina minenae, loto kolinami we ya linate kouba-naba lonoti ya olaneyo. ");
INSERT INTO snp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ido makafo wenaba ona minenae, loto kolinami ya nelalo kouba-nabati we minoto kouba-naba lono olaneyo. ");
INSERT INTO snp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ayaidana oto namo We Kula ya wenena kouba-naba o nedenawae, loto ámowe. E’e, kouba-naba o gedeto, ido lifimanina yamu u kopa utenawae, loto inanimo ebanina oluto fulunae, loto owe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ena Yesuki ege-ege moinamo weki Yeliko numuna fulito wado wenena mau naba-naba Yesu ege wae. ");
INSERT INTO snp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ege wato, moda we lele ma omuni likami ya kanu anawalo amedoti minami yate Yesu aiye, loti lamo ka koliti eti lami, Wenabao, Defiti ufa fiyami we, milumate kolo, loti auma witi lula fiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eti laito wenena muki yate ka kedámoti sodoti minaliyo, loti goudafa, wewa lele yate, Wenabao, Defiti ufa fiyami we, milumate kolo, loti oto diti au naba loti lula fiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Laito, Yesu kanudo minoto luti fito loga o gedami, Namo ya linate nedi-nedi o ledenaiye, loti kolaiye? loto liye. ");
INSERT INTO snp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lito, itibiti eti lami, Wenabao, omude olu falato ledenane, loto koloiye, loti loumaito, ");
INSERT INTO snp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu siya-mulunau milumani kolito omunido olaito, ayalo omuni falatito ege waiye. ");
INSERT INTO snp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ena uto Yelusalemu alalili meleto, ya Betefage numuna Olifi mowa kiyanau yalo fedeto, Yesukafo ege-ege moinamo we yauti we lele ma gilifito ");
INSERT INTO snp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eti limo, Linate numuna meya ama adu negu yau uti, ayalo yafo-dogi olafote momolate nela witamo minenami ya geyeti, nelalo efiliti oluti itibiti namo minodo ailo. ");
INSERT INTO snp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eti aito we makafo loga o gedagetoma, Wekolakafo amo lonola ma neto yamu lito oiye, loti loumailo. Eti loumunawami ya ayalo yafo-dogi ya gilifinagoliye, loto logimito gilifaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eti imo yamu Gotikafo ka polofete welalo melaito eti limo, ");
INSERT INTO snp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Linate Saiyoni we wena eti loti logimalo. Eyalo. Kiyabatina we wekudi ya linate minadoka ami ya mona you limoko mele-mele imo we ya yafo-dogi meyalo amedoto minaiye. Yafo-dogi momola meyalo amedoto minoto ya aiye, loti ya logimalo, loto ka mono lufuwau (Sek 9:9) nemo ka yama ayalo wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ido ege-ege moinami we lelema Yesu welalo golodoti uti ");
INSERT INTO snp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yafo-dogi olafoki momolaki gilimiti oti, ukanido owo feka wiyami ya kololototi yafo-dogi meyalo melaito, Yesu dito amedoto minoto wiye. ");
INSERT INTO snp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wito, wenena naba-naba mau minamo yate, Wenabate ne, loti ukanido owo ya kololototi kanudo unaido kolaleka mikalo ya wilimo wato, ido wenena malekate ya yá akawa leketi kanudo ya melemo wae. ");
INSERT INTO snp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ido wenena mau nabate olu komu-komu o edamo ya ido mate olu aiga-aiga o edamo yate eti loti lamo, Aiyo, siyane, hosana! Defiti ufa fiyaiguti weyo, keboka lenune. Wekola kuliyalo ami we ya lalo kolimo wimo ne. Yoiyau kosinau minamo yaki ayaidana oti, Aiyo, siyane, hosana! loti lo-lo ae, loti aiyo-koiyo lo edemo wae. ");
INSERT INTO snp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ya monimo uto Yelusalemu numudo ya idaito wenena minamo muki ya elegiti eti lamo, We ama ya kema ne? loti loga-miga ato, ");
INSERT INTO snp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","wenena mau naba mate Galili mikau Nasalete numudoti polofete Yesu ya ne, loti itibiti logimi minae. ");
INSERT INTO snp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ido Yesukafo felegaga kuliyai numuna naba kilalau ya dito neta meina fiti minamo wenena, ido neta meinalo fuloti minamo wenena geyeto ya muki giyado feka ito, ido kifana kola ailo-ailo nemo ya olu filiga-filiga amo wenena folomonina muki yaki, ido nema mulu meinalo fuloti minamo wenena folomonina yaki muki ya olu eleyapa wito fululu kiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Fululu kito eti limo, Ka mono lufuwa wiyaigu eti loto limo, Numune ya ka lonumu-numu amo numunale, loti lenawamo ne, loto ka mono lufuwau (Ais 56:7) nemo nefa, linate yate olu ugele we numuni yaidana o minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eti logimito aya felegaga kuliyai numuna nabau minaido ya omuni likami ido kiyani nosámami wenena ato olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Olu faka lo gedaito, yokila ki umu-umu amo we kiyabani we ido lo melami ka api gilibamo we Goti aumala gilibami neta olu oloto piyami ya koti, ido nomilipa felegaga kuliyai numuna naba ebalo minamo ya Aiyo, Defiti ufa fiyami weyo, keboka lo minone, loti lamo ka koliti ya seni kala-kala loitaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Etiti ya loga o edamo, Amau minamo wenena ka lamo ya kolabe? loti lato, Yesukafo itibito logimami, O, moda kolowe. Ido ka ma, Nomilipa namunaki ido nomilipa yaki wenidoti keboka lenawae, loto ya oloto piyane, loto ka mono lufuwau (Sng 8:2) nemo kama linate ya katoti kolámafe? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Loga o gedeto fulo gedeito numuna meya naba kilalauti feka uto, Betani numudo dito luwaila yalo onaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ido leda luwaila numuna meya nabalo ya unae, loto kanudo monimo aido ya kadunamu fuluto ");
INSERT INTO snp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ya yá ade ma kanu anawalo eyeto yá monalo wifa, ilawa liyámaito ailako nemo eyeto, kofa ilawa liyámenane, loto loumaito, ayalo yá aila ya meguinaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yá aila meguinaito, ya ege-ege moinamo we eyeti elegiti eti lamo, Egaidana oto yá ade aila ya kenemane oto meguinaiye? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesukafo limo, Ona logimowe. Koli kikito numuti seti-muludi lele melámatoma, yá ade eti o edomo yaidana oti eti enagilae. Ido yako minámaiye. Linate mowa yaleka yowa nemo ya kuwo noku nedito wo, loti lenawamo ya kati meyalo melenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Neta ma muki yamu olunune, loti koli kikitoti Goti loumunawamo ya moda olunawae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ido Yesu ya felegaga kuliyai numuna naba kilalau dito, wenena ka mono api gilibi minaito yokila ki umamo kiyabani we yaki wenena kiyabani we wenaba yaki amodoka oti loga o edeti lamo, Kamo ya neta o-o animo ya kema welaloti kolito o-o ane? Ido kemakafo lokomaito o-o ane? loti lae. ");
INSERT INTO snp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lato, Yesukafo limo, Namo yaki linate ya neta lawoko ma loga o gedoneto, logane ya itibiti efe loti lonomatoma, namo ayaidana oto kema welaloti kolito netawa o-omo kuliya ya logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kolalo. Yoni noku wi gede-gede imo we ya kema welaloti eti o-o imo ne? Kosinau nemo we welaloti nefemo, ido faifa wenena wenidoti ne? loto loga o gedaiye. Loga o gedami kawa ya koliti yamu lokoli-fakoli oti eti lamo, Kosinau nemo we welaloti ne, lenumo ya nediti koli kikito umámae? lolumutenaiye, loto eti ádenune. ");
INSERT INTO snp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ido faifa wenena wenidoti ne, lenumo ya wenena muki Yoni polofete ne, loti kolamo yamu wenena kolini kolone, loto ya eti ádenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eti loti itibiti loumamo, Lamo kolife ádone, loti loumato, amokafo limo, Namo yaki ayaidana oto kema welaloti neta-mata o-omo yama logimámenagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesukafo eti limo, Kati kiyalo. We ma nalafo lele minami ya komu nalafo nedo uto loumami, Nanefo, onema ya uto nela waini ilawa mineu ya lono olo, loumageto, ");
INSERT INTO snp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","nalafokafo limo, E’e, eleka nofaito, lonoka olámenagolowe, lifa, aiga ya siya-muluna eleyapa witoto uto lono olaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ido wewa nalafo ma nedo uto ayaidana ka loumaito, nalafokafo itibito eti limo, O, menefo, uto lonoka olunagolowe, lifa, áumaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Etito nalafo lele yauti kemakafo melafo welalo golodiye? loto loga o gedaito, eti lamo, Komu nalafole, loti loumae. Loumato, Yesukafo limo, Namo ona logimowe. Kifanani takisi olu-olu amo we ido kopa olu ono-ono amo wenaipa ya Goti wekudite wenenala kiyaba o gedami kilalau yau linate u komu mele gedeti dinawae. ");
INSERT INTO snp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kolafe? Yonikafo linate minadoka mona efe limo kanuwa api gilibinae, loto aifa, linate yate koli kikito umámafa, kifana takisi olu-olu amo we ido kopa olu ono-ono amo wenaipa ya koli kikito umae. Eti amo ya linate geyetama nefa, seti-muludi olu eleyapa witi koli kiki ádae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesukafo limo, Kepa ka ma ya kolalo. Mika aboga we makafo migu nela waini ilawa kifito, kila fito, kiyanidunu nela waini ilawa lipinawamo eba olufe loto, nela waini ilawa kiyaba enawamo numuna kuto, eti o fuli loito mina lonowa ya kiyaba amo we anido meleito monimo eba faiga ma wiye. ");
INSERT INTO snp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ena nela waini ilawa kula lenami kamena ya adu melageto kouba-nabala we eti logimami, Mine kiyaba amo we minado uti, nela waini ilawa kula olu nedeti alo, loto gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Gilifi melaito, minado u fedato, mina kiyaba amo we yate kouba-nabala we ya ani-kiyanido oluti, we ma ya kefakafo ofoti, ma ya ofo fuluti, ma ya kifanadunu ofae. ");
INSERT INTO snp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eti ato, ena kofa kouba-nabala we ma so loti ya gilifi melaito wamo mina kiyaba amo we yate ayaidana o gedae. ");
INSERT INTO snp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eti ato, aiga ya aimola nalafo amo minado ilifito eti limo, Eyeti kala kolinawamo ne, loto ilifi minagu ya melaifa, ");
INSERT INTO snp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","mina kiyaba amo we yate nalafo ya eyeti, inanimoni lokoli-fakoli o minoti eti lamo, Amo yakafo melafo neta le fi mele edami netala muki olunagolinako, yamu ofo fuluto netala muki ya olunuwe, loti ");
INSERT INTO snp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","migu yauti olu feka fuloti, ofo folae. ");
INSERT INTO snp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yamu mina aboga yakafo enami ya mina kiyaba amo wewa ya nedi-nedi o gedenaiye? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Loga o gedaito, itibiti lamo, Nosámamo wewa ya olu nosámami o gedeto, gini fuluto, wenena ailo ma ya nela waini ilawa mina kiyaba enawamo, kula lenami kamenalo ya numu-numu enawae, loto migu lono anido giminaiye, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eti loumato, Yesukafo eti limo, Ka mono lufuwau yau eti limo, Kifana ya numuna kuwamo wenena eye fa netaidana itamo nefa, ido aya kifanawa yama moda numuna lagi kola fiyami ne. Wekola yakafo netawa eti imo ya eyeto elegiyone, loto ka mono lufuwau (Sng 118:22-23) nemo kawama ya katoti kolámafe? ");
INSERT INTO snp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yamu logimowe. Goti kiyaba we wekudi wenenala kiyaba o ledami mona ya linatedokati oluto ailo feka wenena kulawa olu oloto pinawamo ya anido giminagoliye.  ");
INSERT INTO snp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ido we makafo kifanawama yalo lumu fou lenami ya aumala leke-make oto olu kopa enami ne. Ido kifanawama yakafo we ma meyalo olumo winami ya wewa ukana ya moda upa-napatenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ido yokila ki umamo we kiyabani we ido Falisi we yate asa wiyami ka limo ya lamo lo ledaiye, loti koliti, ");
INSERT INTO snp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nela wi edenawamo kanu moni wilafa, wenena muki ya polofete ne, loti kolamo yamu kolini kolae. ");
INSERT INTO snp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesukafo kepa ka kofa eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kosinau nemo we wekudite yakafo wenenala kiyaba o ledenami monala ya kiyaba we wenaba ma nalafo wena olunagolimo yamu konuma-kobina naba olu mau wito ofo kiyami we yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wewa lonodo we eti logimami, Wenena komu luni fiyomo minado uti gilimiti enawae, loto gilifi melaito wafa, luni fiyami wenena ya eleka ginaito ámae. ");
INSERT INTO snp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yamu lonodo we ma kofa gilifi meleto eti logimami, Uti komu luni fiyomo wenena ya etiti logimalo, Konuma-kobina ya ofo kito, ido bulumakauti sipisipiti moda ofo kito, muki neta olufe lo fulitoninako, yamu oti we wena anido olu gimito weni-neta nenawae, loti logimalo, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Gilifi melaito, uti kawa logimafa, kolámoti faifa kanu ailo-ailo wato, ma ya aimola minau wito, ido ma ya aimola kifana lonolau wito, ");
INSERT INTO snp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ido maleka yate lonodo wewa ani-kiyanido oluti ukani olu nosámami o gedeti gini folae. ");
INSERT INTO snp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kiyaba we wenabama kawa kolito siya kala-kala lito, kimiwe gilifi melaito, uti gini folamo wenenawa muki gini fuluti, numuni ebani yaki feiya ae. ");
INSERT INTO snp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Feiya ato, lonodo we logimami, Nanefo wena olaito konuma-kobina olufe lomo ya nenune, loto wenena lu fi gedofa, monani efe ádami yamu enawamo ya ogoufámae. ");
INSERT INTO snp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yamu kanu kofala nedo-nedo uti, wenena muki geyenawamo ya luni fiti, neta nenuge alo, logimiti gilimiti enawae, loto lonodo we logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Logimaito, uti kanu kofala nedo-nedo monimo uti, wenena muki oloto piyamo, mona lalo melamo ido nosámami melamo, muki ya gilimiti ato, numuna nabau ya wenena naba mau witi amedoti minae. ");
INSERT INTO snp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mau witi amedoti numugu ya minato, kiyaba wenabakafo geyenae, loto dito wenena geyemo wiye. Geyemo wimo ya we ma kipa wena oludo unagili wi-wi amo owo ukanalo wiyámami ya eyeto loumami, ");
INSERT INTO snp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wenenane, kipa wena olunagilado wi-wi amo owo ukagalo wiyámanimo ya egaidana oto numugu amau ya idane? loto loga o edaito, wema ka ádaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ka ádaito, kiyaba we wenaba ya lonodo we eti logimami, Wewa ana-kiyanalo nela witi sinidigu feka fulato, aya siniku yau kufu naba-naba oti weni kofala uguti minenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ena ayaidana oto Gotikafo wenena muki ya luni fiyaifa, ido lawoko-lawoko iyaina o gedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ena Falisi we yate feka uti, Yesu ka lenami ya ka oluto ligiya lo edenune, loti mau witi kudala ki minoti, ");
INSERT INTO snp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","gege melamo we ido Heloti ege melamo we Yesu nedo gilifi melato uti eti loti lamo, Api lilibanimo we, ka ona kulako lo-lo ane, loto koli minone. Ido Goti kanula lalo yalo moninawamo monamu ona kula api lilibi-lilibi o minane. Ido faifa wenenafe, ido kulini nemo wenena ya kolini kolámoto, ka ona yako lo minane. ");
INSERT INTO snp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Etito loga o kedogeto itibito ka lenanimo kolinune. Ena kiyaba we wenaba Sisa kifana takisi umu-umu onimo mona ya efe loto nefe? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesukafo kani-manini nosámami kiyamo ya kolitoto eti logimami, Linate monabi lele wiyamo we, nediti kepa mele nomae? ");
INSERT INTO snp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kifana takisi fulenawamo kifana ya nilibalo, lito kifana denaliyasi lawoko ya olu oloto piti ilibato, ");
INSERT INTO snp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesukafo eyeto logimami, Ounaki lufuwalaki ama ya kema netala ne? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ya Sisa ounaki lufuwalaki ne, loti itibiti loumato eti limo, Etito Sisa netala oluti ya Sisa itibiti umalo. Ido Goti netala oluti ya Goti itibiti umalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kawa limo ya koliti elegiti fulo edeiti wae. ");
INSERT INTO snp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aya kamenalo Sadusi wenena ya wenena folagu yauti neidámenawamo ne, loti kolamo ya Yesu nedo oti loga o edamo, ");
INSERT INTO snp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Api lilibanimo we, Mosesekafo eti limo, We ma nomilipa kedámoto folagetoma, kunalafo yakafo wena-kenawa ya oluto yalafodo nomilipa olu oloto pi edenaiye, loto limo ne. ");
INSERT INTO snp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ido lamo minonigu ya yalafo-kunalafo seweni (7) ya minato, ena komu yanibo ya wena oluto nomilipa kedámoto folaito, kunalafokafo wenawa olaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oluto amo ayaidana oto folaito, kunalafo makafo wenawa oluto folaiye. Etiko oluti wato, yalafo-kunalafo seweni (7) ya wenawa lawoko oluti folae. ");
INSERT INTO snp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muki ya folato, aiga wenawa yamaki folaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Folaito, yalafokunalafo seweni (7) ya wenawa olamoma nenako, yamu wenena folamo ya kofa nedinawamo kamenalo ya kema olonafo minenami ne? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Loga o edato, Yesukafo itibito limo, Linate ya ka mono lufuwau nemo ka ido Goti aumala yaki kolife loti kolámanako, yamu kopa ka lo minae. ");
INSERT INTO snp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wenena folaguti nedinawamo kamenalo ya we wena mofu melámato, we wena anido olu gimámenagilae. E’e, Goti enisolela kosinau minamo yaidana oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ena wenena folaguti kofa nedinawamo kamena yamu Gotikafo logimami ka ya katámafe? ");
INSERT INTO snp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Eti logimami, Namo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila minowe, loto ka mono lufuwau (Kis 3:6) ya nemo ne. Amo ya wenena folamo Gotinina ya minámaiye. E’e, wenena omuni kofawa minamoko Gotinina ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ido wenena mau minamo ya kawa limo koliti ya mono api gilibami kala yamu elegiyae. ");
INSERT INTO snp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ena Falisi we yate Yesu ya Sadusi we olu you lo gedaiye, loti lamo kawa koliti ya mau witi minae. ");
INSERT INTO snp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ido mau minagu yauti we makafo lo melami ka ya katoto kolife limo we ya Yesu kepa mele edenae, loto amo nedo uto eti loumami, ");
INSERT INTO snp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Api lilibanimo we, lo melami ka yauti ya nena ka ya u komu uto auma wiyami ka ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Loga o edaito, Yesukafo limo, Seka-muluga muki ido ouga muki ido kaka-manega muki ya Wekola Gotika ya umo, ");
INSERT INTO snp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","loto lo melami kau (Lo 6:5) nemo kawa ya u komu uto auma wiyami ka ya ne. ");
INSERT INTO snp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ido aiga ka ma ayaidana oto nemo, Kaimokamu kolanimo yamaidana oto wenenaka muki ya seka-muluga gimigimi o mino, loto ka mono lufuwau (Wkp 19:18) ya nemo ya ne. ");
INSERT INTO snp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kawa lele ya Goti lo melami kala ido polofete kanina muki ya mona lufawa ona kula ya ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falisi we muki mau witi minamo ya Yesukafo eti loto loga o gedami, ");
INSERT INTO snp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Linate ya Goti ilifi melami we Kilisto yamu nediye loti koli minae? Kema ufa fiyami we ne? loto loga o gedaito, amo yate Defiti ufa fiyami we ne, loti itibiti loumae. ");
INSERT INTO snp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Loumato, amokafo eti limo, Etito ya Ouna Felegaga yakafo Defiti welau ka melaito, Wekolanele, loto limo ya egaidana oto lo edami ne? Yamu mono lufuwa wiyaigu yau eti limo, ");
INSERT INTO snp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Wekola yakafo Wekolane ya loumami, Ane onaleka amedoto kiyaba oto minageto, ya kuwokafomota fulo kiyaga feumau gedenagolowe, loto limo ne, loto ka mono lufuwau (Sng 110:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Etito Defitikafo ya, Wekolanele, loto lito Goti ilifi melami we Kilisto ya egaidana oto Defiti ufa fiyami we minami ne? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yamu wenena ma ka itibiti loumunawamo ya ogoufámato, aya kamena yalekati minomo wamo ya koliya koliti kofa loga-miga o edámae. ");
INSERT INTO snp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesukafo wenena mau wiyamo ido ege-ege moinamo we ya eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kolalo. Lo melami ka api gilibamo we ido Falisi we yate Mosese yaidana oti lo melami ka api gilibi-gilibi o minae. ");
INSERT INTO snp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yamu linate lo melami ka api gilibamo ka muki ya koliti meyalo melalo. Ido monanina mele-mele amo yaidana oti melámalo. E’e, wenikafo lo oloto melamo nefa, inanimo kanina ya meyalo melámae. ");
INSERT INTO snp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ido lo melami ka api gilibamo, wenena seni-muluni olu aila wi gedenami ka ádoti, auma wiyami ka logimiti keina olu mofu gedafa, ani olu faka lo gedámae. ");
INSERT INTO snp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ido wenena leyeti lebote lenawae, loti wenena omunido neta muki o-o ae. Ido wenena leyenawamo mono wenena minone, loti kolinagilae, loti lo melami ka ma aila nabalo lufuwa witi koukameu meleti onobanido asa witi wi-wi ae. Ido Goti loumunagili ukanido owo onowalo ekeina nela fana-fana wi-wi ae. ");
INSERT INTO snp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ido weni-neta naba nenawamo kamenalo ya wenena omunido folomo komu nedo yako ya amedenune, loti koliti, ido mono numugu yaki ayaidana oti wenena omunido ya folomo komu nedo minenune, loti koli-koli o minae. ");
INSERT INTO snp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ido maketilo ya wenena leyeti aiyo-koiyo ka lolumunawae, loti koliti, Api lilibamo wele, loti lebote lenawae, loti koli-koli o minae. ");
INSERT INTO snp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Eti afa, linate api gilibami we lawokoko ya ne. Ido linate muki ya yatibo-kunatibo ya minae. Yamu wenena mate, Api lilibamo wele, loti latoma, ya Eti ádalo, logimalo. ");
INSERT INTO snp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ido mikalo uma we ma, Metefole, loti kuliya olu akaiya oti ebola ádalo. E’e, Metibo lawokoko minami we ya kosinau minaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ido linate yamu wenena mate, Kiyabate we wenabale, loti latoma, ya eti ádalo, logimalo. Kiyabati we wenaba ya lawokoko ilifi melami we Kilisto ya ne. ");
INSERT INTO snp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ido linate yauti we makafo u komu meleto kuliyai we wenaba ona nemo we ya linate lonodo wenenatina minenaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yamu we ma aimola kuliya oluto dinami ya Gotikafo kuliya oluto lumunami ne. Ido we ma aimola kuliya oluto lumuto moni minenami ya Gotikafo kuliya olu akaiya edenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesukafo limo, Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Linate ya kosinau nemo we wekudite kilalau dinagilamo wenena konido ya kanu ku gede-gede o minae. Eti o minamo linanimote ya kilalau idámoti, ido dinagilamo wenena ya kanuma ku gede-gede o minae.  ");
INSERT INTO snp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Linate wena-kena ya koni witi numuni netanina ya ugele noti, ido wenena leyenawae, loti ka fana-fana Goti loumu-umu amoma nenako, lifimatina ya olu mulalo-mulalo oto melenaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Linate lege melenami we ma moni wilinune, loti ya kuwo no mulalo ido mikalo uti oti moinamo lono naba-naba oluti moni wili-wiliti, wewa oloto piyageto ya kopa api ilibato mona nosámami melenami yakafo linate mona nosámami melamo ya olu afima o gedainako, yo eifámenami yoku unami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aiyo, linate omuni likami yate wenena kanu gilibamo ya lifima ka naba-naba itibiti olunagilae. Linate ka etiti lamo, We ma eti enae, loto lido ya kawa limo olu auma wito olu onale, loto felegaga kuliyai numuna naba kuliya lenami we ya kawa faifa liye, loti lo-lo ae. Eti lafa, ido we makafo eti enae, loto kawa limo olu auma wito olu onale, loto kifana goli ya felegaga kuliyai numuna naba lulau nemo kuliya lenami we ya kawa meyalo melo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Linate ya ka maninigu minámami ido omuni likami wenenao, kifana goli ya kula nefemo, ido felegaga kuliyai numuna naba yakafo kifanawa olu felegaga imoma ya kula ne? ");
INSERT INTO snp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ido yako minámaiye. We makafo eti enae, loto kawa limo olu auma wito olu onale, loto neta ki-ki amo folomo kuliya lenaido yamu linate yate, Faifa liye, loti lo-lo afa, ido makafo Metefo faifa umunami neta ya yokila ki-ki amo folomolo nemo kuliya lenami we yamu linate lamo, Ka eti lanimo ya meyalo melo, loti loumu-umu ae. ");
INSERT INTO snp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Linate omuni likami wenenao, nena neta kula ne? Goti umunagili oluti amo neta ya kula nefemo, ido neta ki-ki amo folomolo yakafo umunawamo netawa olu felegaga imoma ya kula ne? ");
INSERT INTO snp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yamu we makafo eti enae, loto lenami we ya kawa limo olu auma wito olu onale, loto neta ki-ki amo folomo kuliya loto lenaido ya folomowa yaki ido neta muki folomo mulalo nemo kulini muki yaki auma wito olu onale, loto lenami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ido we makafo eti enae, loto kawa limo olu auma wito olu onale, loto lenami we ya felegaga kuliyai numuna naba kuliya lenaido ya numunawa kuliya yaki ido ayau minami we yaki kulini muki ya olu auma wito lenami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ido we makafo eti enae, loto kawa limo olu auma wito onale, loto kosina kuliya loto lenami we ya Goti minami ebala yaki ido eba aboga yaki kulini olu onale, loto lenami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Wete-neta olu leya enami neta-mata teni (10) ya olunawaguti ya neta lawoko ma iya meleti Goti umafa, lo melami ka kula yau mona naba nemo ya efe limoko melamo mona, ido wenena milumani seni-mulunigu kolamo mona, ido koli kikitamo monalo melemo idamo mona ya moda fulitae. Linate lo melami ka yau neta ma meyalo melamoidana oti muki neta kefola naba lakoina ya meyalo melalo. ");
INSERT INTO snp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Linate omuni likami yate wenena kanu gilibinawamo wenena minae. Etiti amo ya we makafo no nenami yau sekefa lumuto nemo yauti olu fulaifa, ido yafo-kameli yau nemo ya faifa no mitoto imo we yaidana oti minae. ");
INSERT INTO snp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aiyo, linate lo melami ka api gilibamo weki ido Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Kapuki lapeki ya feka atuwalo noku wiyafa, lulau yau neta-mata maki maki olunumolae, loti ouni-luni-kanigu yau auma witi koli minamo monaki, ido omudi folami neta-mata olu mau witi no fuli lenumolae, loti lalo kolamo monaki ya faitiye. ");
INSERT INTO snp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falisi we linate omuni likami ya neta lulau ya komu noku winawamo feka yaki lakoina feke loto mo lenami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Linate kono mele gedamo ebalo ufa kiyoba limo filamo yaidana oti minae. Aya ebalo fekaka ya wenena eyeti eba lalo ne, loti kolafa, ido lulau ya kono aumani ido neta-mata nosámami fitala kiyamikafo faitimo ne. ");
INSERT INTO snp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Linate yaki ayaidana oti ukadi atuwakafo wenena omunido lalo moniti monatina efe limo mele minafa, ido lutigu yau monabi lele wiyamo mona ido nosámamiasámami mona ya faitimo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aiyo, linate lo melami ka api gilibamo weki Falisi weki monabi lele wiyamo wenenao, lifima ka naba-naba itibiti olunawamo ne. Polofete kononi mele gedamo ebalo numuni ku gedeti ido monani efe limoko melamo wenena kononi melado neta kifiti eba ekeina o-o ae. ");
INSERT INTO snp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eti oti lamo, Autefo-mota kamenanidokama minonimo neko, polofete gini folamo wenena ya ani olu faka ádogi ne, loti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eti loti lamo kawa yakafo linate ya polofete gini fulu-fulu amo we ufa fiyamo wenenanina ne, loto moda ligiya lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ido aunibo-mota adeina apiti o-o amo netama oiya linate ayaidana oti monatina melemo idae. ");
INSERT INTO snp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Linate koiyofa nosámami nomilipala minamo, ya Gotikafo olu kalo mele gedeto yo eifámenami yoku yau fulo gedenami, ya egaidana oto koli unawamo ne? ");
INSERT INTO snp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yamu kolife loti kolalo. Polofete, ido ka maninigu nemo we, ido ka mono api gilibamo we ya linate minagu gilifi meloneto enawamo, maleka ya gini fuluti ido yá yofolo gininawamo ne. Ido maleka ya mono numudigu ya nela kefakafo ipi giniti ido giyadato numudo malo-malo u-unawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yamu wenena yate monani efe limo wenena mikalo uma ya gini folamo lifima muki ya linatedoka minenagoliye. Etito monala efe limo we Abeli ofo folami kamenaloti wenena ya gini fulumo uti uti Sekalaiya, Belekia nalafo yaki ofato folami kamenalo wae. Wewa ya felegaga kuliyai numuna nabaki neta ki-ki amo folomoki muliti yalo minaido ya ofo folae. Yamu lifimawa muki ya linatedoka giminami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Namo ona logimowe. Lifimawa muki ya oiya wenena minado ama fede giminami ne. ");
INSERT INTO snp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aiyo, Yelusalemu wenenao, Yelusalemu wenenao, linate yate polofete gini fuluti, ido kifanakafo wenena minagu gilifi melami ya fuloti ginamo, ya okolofokafo nomilipala okanau olu mau wi gedami yaidana oto linate muki ya kemaneu olu mau wi gedenae, loto kolofa, ido eleka ginaito, E’e, lae. ");
INSERT INTO snp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kolalo. Numudi ebatina fulitoneto ya polofete linateki minámato, linateko minenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yamu logimowe. Namo ya kofa neyámoti monimo uti uti Wekola kuliyalo ami we ya ebola logeto mino kolimo wiye, loti ka mono lufuwau (Sng 118:26) nemo ka lenawamo kamena yalo ya kofa neyenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu felegaga kuliyai numuna naba ya fulito wido ege-ege moinamo we ya felegaga kuliyai numuna naba kuwamo ya ilibinune, loti amo nedoka ato, ");
INSERT INTO snp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesukafo limo, Numuna kuwamo neta muki ya eyafe? Namo ona logimowe. Kifana makafo kifana ma mulalo nemo amaidana oti koitámenagilae. E’e, muki ya itufu fulato, lumu fou lenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Olifi mowalo ya amedoto minaito, ege-ege moinamo we amo lako ya minaido oti eti loumamo, Kawa lanimo yama nena kamenalo oloto pinami ne? Ido egaidana oto mebe-maba ya fedenami eyeto kamo kofa itibito enanimo kamena ido mika kosina fuli lenami kamena moda alitimo ne, loto kolinune? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Loga o edato, Yesukafo limo, Linate wenena mate oti kote witenawae, loti ko efe loti moinalo. ");
INSERT INTO snp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wenena so loti oti kuline oluti, namo Goti nilifi melami we Kilisto minowe, lenawamo ya wenena muki koni winagilae. Etito nenako, ko efe loti kiyaba oti minalo. ");
INSERT INTO snp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ido fina ka ido lowa ka ya kolinagilafa, koli gimámalo. Netawa yaidana fedenagolifa, mika kosina fuli lenami kamena ya ayalo fedámenami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","E’e, wenena mikau-mikau ya lowa fimo wato, ido mikalo kiyaba we ma wenenalaki ido kiyaba we ma wenenalaki lowa fina fimo unawamo ne. Ido mikau-mikau kadunamu naba oloto pitoko minageto, ido mika mima naba enami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ido netawa-matawa muki ya wenaipa nomilipa kedenagili ukani apito ogofu imo yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ena aya kamenalo ya linate namo wenenane minanako, yamu oluti ukadi ogofu olu gimiti keina naba olu mofu gedeti gini fulunawamo ne. Ido mikau-mikau wenena mukite wenenane minamo yamu seni-mulunigu koli nosámamiasámami giminagilae. ");
INSERT INTO snp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ido netawa ya oloto pinami kamenalo ya wenena so loti ya fulo nedeti kopa uti wenenani ya olu kuwonibo-mota anido gimiti inanimo-inanimo kuwolafo-kuwolafo bulunawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ido ka suki polofete so loti enawamo ya wenena muki koni winawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ido mona nosámami ya u naba-naba fedenagolinako, wenena muki ya seni-muluni gimi-gimi amo mona ya fulitenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Etiti minenagilafa, koli kiki loti auma witi minomo keinawa fuli lenami kamenalo dinawamo wenena ya Metefokafo olu omuni kenami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ido wenena muki mikau-mikau minamo ya kawa kolinagilae, loti wekudite kiyaba o ledami we kala kuwa lalo ya logimimo wato, kawa kolitato, ena aiga mika kosina fuli lenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Wenena yate Daniyeli ka limo, ka mono lufuwau (Dan 9:27, 11:31, 12:11) nemo kawa katenawamo ya kolife loti kolinagilae. Neta nosámami-asámami muki neta olu kopaitenami neta yamu limo, aya netawama eba felegagalo yalo minenami ya eyenawado ");
INSERT INTO snp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yudia mikau minenawamo wenena u mowaleka koli unagilae. ");
INSERT INTO snp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ido ma numuna obito minenaidoti ya lumuto numunau yauti koukamela olunami kamenala minámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ido ma ya minau lono olunaidoti ya kofa itibito uto ukanalo owo olámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ido aya kamenalo ya wenaipa nomilipa mulunigu nemoki, ido wenaipa nomilipanina amina gimi minenawamoki ya keina naba kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ido netawa fedageto koli unawamo ya epe naba lenami kamenalofe, ido Sabati foli kamenalo ya oloto pitenaiye, loti Goti loumu-umu o minalo. ");
INSERT INTO snp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aya kamenalo keinawa naba-naba fedenami ya mika kosina oloto piyaido akaimati oto oiya kamenalo minami keina yaidana oloto piyámami ne. Ido aiga yaki keina yaidana ma minámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kamenawa ya fukoto olu lina itámami neko, wenena ma ya minámagi ne. Etito nefa, amokafo wenenala iyaina o gedami yamu kolito kamenawa olu lina itenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ido aya kamenalo we makafo, Eyalo. Ilifi melami we Kilisto uma ya ne, loto lenaife, ido, Eyalo. Yowa ne, loto lenami ya koli kikito umámalo. ");
INSERT INTO snp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Etito wenena mate oloto piti suki ka lenawamo, maleka namo ya Kilisto minowe, lato ido ma yate, Namo polofete minowe, loti enawamo, ya neta kofawa naba-naba ailo-ailo ido aumani gilibami neta olu oloto pinawamo, ya Goti iyaina o gedami wenenala yaki koni winune, loti ogofunawamo neko ya koni winagi ne. ");
INSERT INTO snp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kamenawa aiga enami yamu linate moda komu logimitowe. ");
INSERT INTO snp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yamu moda kofo mikau yola minaiye, latoma, ya áumalo. Ido moda numugu lulau amau minaiye, lenawamo yaki kolámalo. ");
INSERT INTO snp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","E’e, kopanakafo filiga fo idaidokati kopana kito uto fo lomaidoka ya wimo yaidana oto wenena yate namo We Kula kofa itibito enamo ya neyenawae. ");
INSERT INTO snp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kolife loti kolafe? Kono ukana nedo yalo nema ikime ya oti mau wi-wi ae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ena kaila fiyami kamenawa fuli lageto ayalo, Fo ya sinidito, ikana lamenala ya fuli lito, ukulu ya kosinauti olumo wiyageto, kosinalo nemo neta muki ya momoga enagoliye, loto ka mono lufuwau (Ais 13:10, 34:4) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aya kamenalo namo We Kula enamo mebe-mabane kosinalo yalo oloto piyageto, mikau-mikau minamo wenena muki neyeti ya kufu nema naba lato, namo We Kula ya kosina limulo minoto aumane nabaki ido lamena nabaki oneto neyenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ena namo enisolene ya gilifi meloneto bumu wekilofo nola aumafofo loti nola meleti mika filiga-filiga yaleka-waka uti iyaina o gedami wenenala olu mau wi gedenawae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Linate ya yá ade monala yamo neta lilibami ka kolife loti kolalo. Yá ade akawa ya lilisawa bu loto nowala minoto aila kofawa wiyaitoma, ayalo fo lenami kamena alili iye, loti kolae. ");
INSERT INTO snp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Etito netawa muki yaki oloto piyaito linate eye minenawamo, ya kamenawa moda adu ona meletami ne, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka ona logimowe. Kamena oiya ama minamo wenena maleka folámato ya netawa muki logimomo ya oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mika kosina ya fuli lenagolifa, namo kane ya minowa-monowa omo dito fuli ádenami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Netawa muki oloto pinami kamena ya kolife limo we ma minámaiye. Ido kosinau enisole yaki kolife loti kolámae. Ido namoki Nalafo minomo ya kolife loto kolámowe. E’e, Metefo yako fedenami kamenawa ya koli minaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ido namo We Kula kofa itibito enamo kamenalo ya Nowa minami kamenalo wenena monani melamo yamaidana oti mona melenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","No lafawa naba ya fedámami kamenalo wenena weni-neta nonano noti, we wena mofu melato, we wena anido olu gimato, etiti yaida-amaida monalo moni minato, Nowa sipiku idami yalo ");
INSERT INTO snp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","no lafa naba-naba enami kamena ya kolife loti kolámato, no lafa naba-naba oto wenenawa muki ya kililifa oto gilimito wiye. Ido yamaidana oto namo We Kula itibito enamo kamenalo ya eti amo yaidana enawae. ");
INSERT INTO snp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ido kamena yalo we lele migu lono olu minenawaidokati ma ya oluti ido ma ya fulo edenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ido wena lele lakoina lono olu minenawaidoti ma ya oluti ido ma ya fulo edenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Etito ya nenako, yamu Wekolatina itibito enami kamena ya kolámanako, yamu koti kiyaba otiko minalo. ");
INSERT INTO snp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ido numuna aboga yakafo onema luwaila numuneu ugele we fukoto dinami ne, loto kolami neko, siniku ya kiyaba ageto fukoto idámagi ne. ");
INSERT INTO snp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Etiti linate yaki namo We Kula enamo kamenane ya kolámamo yamu kiyaba otiko minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesukafo eti limo, Ena lonodo we yauti kema yamo lono koli umuto efe loto oluto ka manenau nemo we ne? Lono aboga yakafo, Wewa ya lonone olamo wenena muki ya kiyaba o gedeto, weni-neta nenawamo kamenalo ya weni-neta iya meleto gimi-gimi enaiye, loto iyaina o edami ne. ");
INSERT INTO snp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aiga lono aboga itibito oto lonodo we loumaido meyalo meleto lono olu minami we eyageto ya lalo mino kolinagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Namo ka ona logimowe. Lono aboga ya oto netane-matane muki kiyaba o nedenaiye, loto koukamela muki ya lonodo we analo melenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Etito melenagolifa, ido lonodo we ya monala nosámenami meleto, lono aboga ya kenemane oto itibito ámenagoliye, loto siya-mulunau kolito ");
INSERT INTO snp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya auwafo-mota koubanaba we kefakafo ginito, ido no noti luni-kani olu kopa o-oti moinamo weki lakoina weni-neta ido nonano naba no-no minenawae. ");
INSERT INTO snp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ena wewa lono aboga itibito enami kamenala yamu kolámoto, ido oiya onema ámenagoliye, loto koli minaido, aya kamenalo moda o fedenaiye. ");
INSERT INTO snp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Fedeto we ya monabi lele wiyamo wenena ebanigu yau ilifi melageto, ayau moda kufu naba-naba oti weni kofala uguti minenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesukafo ka ma eti limo, Aya kamenalo ya kosinau nemo we wekudite wenenala kiyaba o ledami we monala ya nomili teni (10) yate lamunina ya oluti uti, kipa wena olunagolimo ya kanudo enaido katula oto ilimito enune, loti wamo yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nomili faifu (5) ya ka maninigu nemo nefa, ido maleka faifu (5) ya ka maninigu minámaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ka maninigu minámami nomiliwa yate lamunina oluti wafa, ido no lamuku lekinawamo ya ma olámae. ");
INSERT INTO snp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ido ka maninigu nemo nomiliwa yate lamunina oluti ido no fiyamo netau yau lamu no ma liligaleka witi, oluti wae. ");
INSERT INTO snp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ena kipawa wena olunagolimo ya enaidole, loti kiyaba afa, ámaito nomiliwa omuni fifi ito oku ono minae. ");
INSERT INTO snp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Oku ono minato, luwaila sini kamulu kiyami kamenalo ya wena olunagolimo we ya kanudo o fedageto ya uti, eyeti ilimiti itibiti alo, loto ka naba ma oloto wito, ");
INSERT INTO snp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","nomilima muki nediti lamunina olufe lamo, ");
INSERT INTO snp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ka maninigu minámami nomili yate ka maninigu nemo nomili ya eti logimamo, Lamute ya efinagoliye. Linate no ma leki ledalo, loti lafa, ");
INSERT INTO snp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ido ka maninigu nemo nomili yate, E’e, note uma ya linateki ido lamoki lekinumo ya ogoufámaiye. Linate uti no ma meina fiyalo, loti logimae. ");
INSERT INTO snp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ena lamu no meina finune, loti kanudo u minado ya wena olunagolimo kipawama aito, kiyabala o minamo nomili ya weni-neta ofo kiti melamo numugu ya lakoina idato kanu kuwae. ");
INSERT INTO snp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kanu moda kuwato, ido aigama nomili liligama yaki oti eti loumamo, Wenabao, wenabao, kanu wi ledomo, lafa, ");
INSERT INTO snp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ido amokafo limo, Namo ka ona logimowe. Linate geyefe loto geyámowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yamu kolalo. Itibito enamo kamena ya linate kolámamo yamu ya kamena-kamena moda koti kiyabane otiko minalo. ");
INSERT INTO snp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ido kamenawa enami ya etito yaidana oto ne. Kolalo. Kamena ma we makafo kanu faiga unae, loto lonola olamo we koukamela anido meleto, netane kiyaba o nedato unae, loto luni fiyaito, ato ");
INSERT INTO snp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","anido melami we ya lonodo we muki monani yaki ido neta-mata olufe lenawamo ogofuto mino gedami aumani yakimu kolito kifana ya iya meleto we ma kifana naba-naba kuliya taleni faifu (5) ya umami, ido we ma kifana naba taleni lele ya umami, ido we ma kifana taleni lawoko ya umami, etito gimitoto unagolimo kanu ya wiye. ");
INSERT INTO snp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ena kifana taleni faifu (5) olami wema ya alako uto kifanamakafo lono oluto kifana taleni faifu (5) maki ika oto olaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eti ito ido kifana taleni lele olami wema ayaidana oto kifana taleni lele maki olaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Olaifa, ido kifana taleni lawoko olami wema kifanawa oluto uto mikau ya kale lito falukaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aiga kamena fana minototo lonola olamo kiyabani we wenaba ya kifana gimami yama olufe lenae, loto itibito aiye. ");
INSERT INTO snp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eti ito kifana taleni faifu (5) ya olami wemakafo kifana taleni faifu (5) maki olu lakoito oluto loumami, Wenabao, eyo, kifana taleni faifu (5) nomanima lonowa olumo uto kifana taleni faifu (5) ya maki ounawa olowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Loumaito, kiyaba we wenaba yakafo itibito loumami, Kamo ya kouba-naba we lalo minoto kanelo golodanimo lonoka lalo eyowe. Kamo kefola netalo kiyaba we lalo minaninako, yaidana oto koukamene muki ya kiyaba o nedageto, namote ekeleto laloko minomo dinagolone, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ido kifana taleni lele olami wemakafo oto loumami, Wenabao, eyo, kifana taleni lele nomanima lonowa olumo uto kifana taleni lele maki ounawa olowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Loumaito, kiyaba we wenaba yakafo limo, Kouba-naba we lalo minoto ido kanelo golodanimo lonoka lalo eyowe. Kamo kefola netalo kiyaba we lalo minaninako, yaidana oto koukamene muki ya kiyaba o nedageto, namote ekeleto laloko minomo dinagolone, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ena kifana taleni lawoko olami wemakafo oto loumami, Wenabao, seka-muluga itamima minanimo ne, loto kolomo, konuma-kobina minigu kifamo ya dolito wenena ailote mikanigu ufa neta itili agu yauti doli no-no animoma nenako, ");
INSERT INTO snp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","yamu kolika kolito, kifana taleni lawoko nomanimo ya mikau kale lito falukomo uma ya ne, loto umaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Umaito, kiyaba wemakafo loumami, Kamo ya kouba-naba we kefali nosámami minane. Kamo neyanimo ya ailo wenena minigu yauti konuma-kobina kifamo ya dolito wenena ailo mikanigu ya ufa neta itili agu yauti doli no-no omo neyanima nefe? ");
INSERT INTO snp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ido namomu eti loto kolaninako, kifana kiyaba we anido meleto ido kiyabane we enami kamenalo ya kifanala melomo yaki kifana ouna yaki olunaiye, loto kifanane ya mele-mele amo numugu ya nedito mele nedámane? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Loga o edeto, ya eti logimami, Kifanawa taleni lawoko ya anauti oluti kifana taleni teni (10) ya olu minami we ya umalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Etito neta ma ko nami we ya maki enu wito umageto neta naba ko nenami we minenagoliye. Ido we ma neta kefoko ko nami ya aya neta kefo ko namima ya anauti ipenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ido kouba-naba we nosámami ya sinidigu feka fulato, siniku ya kufu naba-naba oti weni kofala uguti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Namo We Kula ya lamenane nabau enamo, enisole muki yaki lakoina enumo kamenalo, ya ekeina folomonelo dito amedoto minoneto, ");
INSERT INTO snp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","wenena mikau-mikau onobanelo olu mau wi gedato, ido sipisipi kiyaba wekafo sipisipi ido meme fokito iya mele gedami yaidana oto wenena fokito iya mele gedenagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipisipi ya ane onaleka fulo gedeto, ido meme ya ane adowaleka fulo gedenagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ena kiyabani we wekudi namo ya wenena ane onaleka minenawamo ya eti logiminamo, Linate Menefo ubalela gimami wenena ya alo. Kana mika oloto piyaidoti Menefokafo kiyaba wenena naba minenawae, loto ebatina le fi mele gedami eba ya olunawae. ");
INSERT INTO snp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kolafe? Kadunamu fuluto minoneto linate ya wene-neta nomamo ne. Ido nomu koloneto no ya nomamo ne. Ido eba ailo maukati oto kanudo minoneto numudigu ya nilimiti wamo ne. ");
INSERT INTO snp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ido ukanelo owo minámaito ukanelo owo ya wi nedamo ne. Ido neta kiloneto kiyaba o nedamo ne. Ido nela numugu minoneto oti neyamo ne, loto logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Etito logiminado ya monani efe limo wenenawa yate itibiti eti lonumunawamo, Wekolao, nenafeko kadunamu folageto keyeto weka-neta komonimo ne? Ido nomu kolageto no komonimo ne? ");
INSERT INTO snp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ido nenafeko ya eba ailo maukati we keyonimo minane, loto kilimito numudeuka wonimo ne? Ido ukagalo owo minámaito minageto ukagalo owo wi kedonimo ne? ");
INSERT INTO snp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ido nenafeko neta kilito minageto uto keyeto, ido nelau minageto uto keyonimo ne? loti loga o nedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ido namo kiyabani we wekudi ya itibito eti lenamo, Ka ona logimowe. Linate yate wenenane kulini minámami wenena ma eti o gedamo ya namoki eti o nedae, loto logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ido ane adowaleka minamo wenena yaki eti logiminamo, Linate u kopa unawamo wenena namo minodo ya fuliti, nosámami abogaki kimiwelaki yo eifámenami yo olufe lo gedaigu yau lumuti minalo. ");
INSERT INTO snp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kolafe? Namo ya kadunamu fuluto minoneto linate wene-neta ya nomámamo ne. Ido nomu koloneto no ya nomámamo ne. ");
INSERT INTO snp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ido eba ailo maukati oto minoneto numudigu ya nilimiti áumamo ne. Ido ukanelo owo minámaito ya ukanelo owo ya wi nedámamo ne. Ido neta kilito, ido nelau minoneto ya oti kiyaba o nedámamo ne, loto logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Logimoneto, amo yate lonumunawamo, Wekolao, nenafeko kadunamu folanimofe, ido nomu kolanimofe, ido eba ailo malekati animofe, ido ukagalo owo minámamife, ido neta kilanimofe, ido nelau minanimo ya aga olu faka ádone? loti loga o nedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ido itibito lenamo, Namo ona logimowe. Linate yate wenenane kulini minámami ma ya eti o gedámamo ya namoki eti o nedámamo ne, loto logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yamu uti minowaminowa enami lifima ya olumo dinagilae. Ido monani efe limo wenena ya omuni kofawa minowa-minowa oti minomo dinagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ena Yesukafo kawa muki lo fuli loito ya ege-ege moinamo we eti logimami, ");
INSERT INTO snp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Kamena lele ma wageto ya Goti Elita O Ledami foliwa oloto pinagoliye, loti koli minae. Ido namo We Kula ya kuwonefo-mota anido gimato ya yá yofolo nofenagilae, loto logimami ne. ");
INSERT INTO snp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ena kamena yalo yokila ki umamo we kiyabani we wenaba kuliya Kaiyafasi numuna nabau ya yokila ki umamo we kiyabani wemomo yaki ido Yuda wenena kiyabani wemomo yaki mau witi, ");
INSERT INTO snp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu nedo momona oti ana-kiyanalo nela witi ofo fulunagili ka loti lo kifafa, ");
INSERT INTO snp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","wenena muki fina lowa fitenawae, loti oiya amau foliwalo eti ámokele, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ena Yesu ya Betani numudoka komu okola kilami we Saimoni numunalo minoto ");
INSERT INTO snp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","amedoto wela-neta no minaito, ya wena makafo nomu kifana falake limo nomuku no ladanuwa imo meinala naba nemo ya oluto oto Yesu atelalo leki edaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eti ito, ege-ege moinamo we eyeti ko eleka fi umuti eti lamo, Meinala naba nemo netawa ya nedito fa fulaiye? ");
INSERT INTO snp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Netawa ya kifanalo fulami neko, meina naba oluto neta ko ánamo wenena gimagi ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Eti lato, Yesukafo aya ka ya kolitoto logimami, Linate wena ama ya nediti odu minae? Neta lalo o nedaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kolafe? Neta ko ánamo wenena ya moda linateki kamena-kamena lakoina ekeleti minenagilafa, ido namo ya linateki kamena fana ekeleto minámenagolowe. ");
INSERT INTO snp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Fulunamo kamena adu melainako, yamu yá nowala ladanuwa imo ukanelo leikami ya foloneto mele nedenawamo yamu ya eti o nedaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yamu ka ona logimowe. Kane kune lalo mikau-mikau logimimo uti uti wenawa ama netawa o nedami monala yaki lakoina logimimo wato, ya amomu koliwa-koliwa minenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ena we tuwelu (12) minaguti ya we ma kuliya Yudasi Isikaliyoti yokila ki umu-umu amo we kiyabani wemomo minadoka uto ya logimami, ");
INSERT INTO snp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Namokafo amo ya anido gimonetoma, ya kifana meina nenaki numunawamo ne? loto loga o gedaito, yalo amote kifana siluwa teti (30) ya katoti umato olaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kifanawa olaido yaloti ya anido giminami kanu ya moni wilimo wiye. ");
INSERT INTO snp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ena foliwa ya beleti olufe lageto fudenami neta yisi ya melámoti faifa kiti no-no amo foliwa komu kamenalo ya ege-ege moinamo we Yesu nedo oti loumato, Numuna egau ya Goti Elita O Gedami konuma-kobina ofo kito olufe lenune? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Amokafo limo, Numuna meya nabau ya we ma minenaido uti eti loumalo, Api lilibami wekafo eti lokomami, Kamenane alitimo yamu numugau namoki nege-nege moinamo weki Goti Elita O Gedami konuma-kobina nenune, loto liye, loti ya loumalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eti loto logimaito, ya welalo meleti ege-ege moinamo we Goti Elita O Gedami weni-neta ofo kiyae. ");
INSERT INTO snp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ena lunaga fo saipaito ya Yesuki ido ege-ege moinamo we tuwelu (12) yaki numunawa yau amedoti minoti ");
INSERT INTO snp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","weni-neta no minato, ya amokafo logimami, Ka ona logimowe. Linate yauti we makafo namo ya kuwonefo-mota anido giminagoliye, lito, ");
INSERT INTO snp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","seni-mulunigu keina naba-naba iti loumamo, Wekolao, namofe? loti muki loga o edae. ");
INSERT INTO snp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Loga o edato, amokafo limo, We ma lape yau ana fulageto namo yaki ane fulo ayau itenamo we yakafo kuwonefo anido giminagoliye. ");
INSERT INTO snp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Namo We Kula ya moda fulunamo kanune yamu ka mono lufuwau wiyadoma ya ayalo unagolowe. Etito unafa, ido namo We Kulama ya kuwonefo anido giminami we ya aiyo, lifima ka naba-naba itibito olunami ne. Olafo mulunauti oloto piyámami neko, ya lalo minagi ne, liye. ");
INSERT INTO snp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eti lito, kuwolafo-mota anido giminami we Yudasi yakafo loumami, Api lilibanimo we, namomu labe? lito ya, Kaimoka moda lane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ena weni-neta no minato Yesukafo beleti ma oluto, siyane, lalole, loto loumutoto ya leketo ege-ege moinamo we gimito logimami, Ama ya namo ukane ne. Oluti nalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Eti loito ena nomu oluto, siyane, lalole, loumutoto ya gimito eti logimami, Linate muki ya nomuwa yauti nalo. ");
INSERT INTO snp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ama ya namo wanune ne. Gotiki olu kutifi gedami ka olu auma wi edami wanune yakafo lifimanina kilili o gedenae, loto wenena mumudi yamu lekinamo ne. ");
INSERT INTO snp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ido ka ma logimowe. No waini ya kofa ma moda ánoto minomo uto uto Menefo kiyabate we wekudi kiyaba o ledami kilalau yau linateki ya kofa nenagolone, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ena eti loto logimaito, ya mono nema ma lotiti numudoti lumuti uti Olifi mowalo ya idae. ");
INSERT INTO snp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olifi mowalo idato, ya Yesukafo limo, Kolalo. Ka mono lufuwau eti limo, Namokafo sipisipi kiyabani we ya ofoneto, sipisipi mau minamo ya upatenagilae, loto ka mono lufuwau (Sek 13:7) ya nemo yamu onema oiya luwaila neta o nedenawamo yamu linate muki ya fulo nedeiti koli unagilae. ");
INSERT INTO snp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eti enawafa, ido namo fologuti nedito ya Galili mikau u komu mele gedeto unagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitakafo ka itibito limo, Maleka muki ya koli fulo kedeiti watoma, ya namo nanimo ya moda fulo kedámenagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesukafo limo, Namo ka ona lokomowe. Onema luwaila okolofo nola ádageto ya kamena tili (3) ya kuline olu falukunagolane, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eti lito, Pitakafo limo, Kofo fulunawamo ya namoki lakoina nofo fulatoma, moda kulika olu falukámenagolowe, loto loumaito, ido ege-ege moinamo we muki yaki ayaidana oti loumae. ");
INSERT INTO snp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ena Yesu ido ege-ege moinamo we ya eba ma kuliya Getesemani wato, amokafo limo, Amalo amedoti minato, yolalo uto Menefo loumunagolowe, loto ");
INSERT INTO snp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita ido Sebedi nalafo lele gilimito uto ya siya-mulunau kolami keina naba-naba o minoto, ");
INSERT INTO snp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","eti limo, Sene-muluneu keina naba-naba omo yakafo fulunamoidana imo yamu amalo minoti namoki lakoina kiyaba o minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eti loito, kefo ma monimo uto kola-wela mikalo olumo fito limo, Menefo, kanu ma minagaiyama miluma kolomo kapu ama olu fulo nedenane, loto kolomo nefa, ido namo kolodo mele nedámoto, kaimoka kolinanido ya mele nedo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Loumutoto ya itibito ege-ege moinamo we minado oto geyaima, oku ono minato ya Pita loumami, Namoki kamena lina efema lakoina kiyaba enawamo ya ogoufámafe? ");
INSERT INTO snp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ido neta ma fedeto ya kepa mele lumutenaiye, loti koti kiyaba oti Goti loumutiko minalo. Lutigu eti enune, loti kolafa, ido ukadi aumala ya kefo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eti loito kofa uto limo, Menefo, keinawa ya olu fulo nedámagaiyama ya moda mofunagolowe. Kaimoka kolinanido ya mele nedo, loto loumutoto, ");
INSERT INTO snp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ya kofa itibito aito, omuni fifi ito oku ono minamo ya geyeto ");
INSERT INTO snp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","fulo gedeito kofa uto Melafo loumami, ya komu loumami kama moda ayaida oto kofa loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eti loumuito ya kofa itibito ege-ege moinamo we minado oto logimami, Faifa minoti oku ono minafe? Kamena ya moda alitimo ya namo We Kula ya lifimanina nemo wenena anido moda gimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Neidato wokele. Afulaleka eyalo. Kuwonefo-mota anido gimami we ya moda o fedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Eti loto logimi minaito ya ege-ege moinamo we tuwelu (12) minagu yauti we ma Yudasi ya o fedami, wenena mau naba lakoina yaki amo wenena anigu emi nabati kefati olamo, ya yokila ki umu-umu amo we kiyabani we ido Yuda wenena kiyabani we yate, ilimiti enawae, loti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ido anido gimami we yakafo komu eti loto logimami, Wewa ya mudo edenamo ya ne. Ana-kiyanalo olalo, loto logimito ");
INSERT INTO snp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","oto alako Yesu nedo o fedeto loumami, Api lilibanimo we, siyane, loto mudo edaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mudo edaito, Yesukafo loumami, Yowone we, eti enae, loto animo ya eti o, loto loumaito, ya oti analo olu kiki loti anigu olae. ");
INSERT INTO snp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eti olato, moda Yesuki minamo we yauti makafo emila kimelauti ika oto yokila ki umu-umu amo we kiyabani we wenaba kouba-nabala we kala ya fuko fulitaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Fuko fulitaito, Yesukafo eyeto ya loumami, Wenena muki emikafo fina finawamo ya emikafo gini fuli lenagilanako, itibito kimekau wiyo. ");
INSERT INTO snp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ido Menefo loga o edonetoma ya oiya ama enisolela mau naba-naba sewedi tauseni (70,000) yaidana oto gilifageto ane olu faka lenawamo ne, loto kolámabe? ");
INSERT INTO snp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ido eti oneto ka mono lufuwau nemo yau ka ma namodo netawa o fedenami yamu limoma ya egaidana oto u ayalo kulawa fedenami ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ido aya kamenalo Yesukafo wenena mau minamo eti logimami, Namo ya ugele we wenabanina ne, loti koliti ya emiti kefati oluti oti nela fi nedenune, loti afe? Kamena-kamena felegaga kuliyai numuna naba kilalau ya wenena api gilibimo wodo yama ane-kiyanelo oluti nela fi nedámae. ");
INSERT INTO snp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Eti ámama nefa, ido oiya ama ya neta muki o nedamo ya polofete ka mono lufuwa wiyamo ka yama u ayalo kulawa fedenagoliye, loto logimaito, ayalo ege-ege moinamo we muki fulo edeiti koli wae. ");
INSERT INTO snp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ena Yesu ana-kiyanalo olu kiki loti olamo we yate ilimiti yokila ki umamo we kiyabani we wenaba Kaiyafasi nedo wato, ayauka ya mono api gilibamo we ido Yuda wenena kiyabani we ya mau witi minae. ");
INSERT INTO snp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eti ato, Pita ya faigato meleto ege uto, yokila ki umamo we kiyabani we wenaba numuna nabalo o fedeto kilalau dito, ya nedi-nedi o edenawae? Eyenae, loto kimiwe minagu uto amedoto minaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Minaito, ena yokila ki umamo we kiyabani wemomo ido kanisolenina kuliya Sanihetilini mau muki minoti ofo fulunumo ka olu oloto pinune, loti suki ka fi umunawamo ya moni wilimo wamo, ");
INSERT INTO snp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","wenena muki suki ka fi umunawamo ya o fedafa, ofo fulunawamo ka ma olu oloto piyámae. Eti o minato, ya aiga we lele o fedeti eti lami, ");
INSERT INTO snp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wewa yakafo eti limo, Goti felegaga kuliyai numuna naba ya lukoto fo kamena tili (3) wageto kofa ku fuli lenamo ne, lito ya moda kolonimo ne, loti laiye. ");
INSERT INTO snp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eti laito, ya yokila ki umamo we kiyabani we wenabakafo folomolokati nedito Yesu loumami, Kamo ka itibito ma ádenabe? Wewa ya ka lo kedami ya nediye loti laiye? loto loga o edaifa, ");
INSERT INTO snp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ido Yesu ya ka ádoto minaiye. Ka ádoto minaito ya yokila ki umamo kiyabani we wenabakafo loumami, Goti mino ko-ko imo we onobalalo loga o kedowe. Lolomo. Kamo Goti Nalafo Kilistoma minabe? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Loga o edaito, Yesukafo loumami, Kaimokakafo moda lotane. Ido ka ma logimowe. Aiga namo We Kula ya aumafofo limo we ana onaleka amedoto minoto, kosinalo limuku o fedoneto neyenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ena kawa lido ya yokila ki umamo we kiyabani we wenabanina aimola ukanalo owo fekalito ya limo, Ake, moda Metefo kamana kitaiye. Wenena ma ka fi umunawamo ya luni fiyámenuwe. Metefo kamana oiya kiyami ya moda kolitanako, ");
INSERT INTO snp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yamu linate moda nediye loti kolae? lito ya amote loumamo, Moda fulunami ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eti loti, ketufu o edeti, bemu-damu ofoti, ido malekate ani lukanadunu ofoti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kamo Goti ilifi melami we Kilistoma minanimo ya kofami we kema ne? Polofete ka lolomo, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ena Pita ya feka numuna kilala lulau amedoto minaito, ya lonodo nomili ma amo nedo o fedeto loumami, Kamo yaki Galili we Yesuki minanima ne, lito, ");
INSERT INTO snp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","amokafo wenena muki onobanido olu falukuto eti loto limo, Ka lanimo yamu kolife loto kolámowe, loto ");
INSERT INTO snp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kanu welalo wito, lonodo nomili makafo eyeto ya wenena yalo minamo logimami, We ama ya Yesu Nasalete weki lakoina minami ne, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Metefo onobalalo lo fukoto, We ya eyámowe, loto kofa olu falukuto liye. ");
INSERT INTO snp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eti lito, aiga ya adu nedi minamo wenena mate amo nedo o fedeti loumamo, Kaka lanimo noka ya kolife logeto kamo ya ona amo minagu yauti minane, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eti loumato, kofa Metefo onobalalo lo fukoto, Wewa ya moda eyámowe. Ka ona ádoneto Gotikafo olu kopa o nedenaiye, lito ayalo ya okolofo kokololo liye. ");
INSERT INTO snp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kokololo lito, Pitakafo Yesu ka komu loumami ya okolofo nola ádageto kamokafo kamena tili (3) ya kuline olu falukunanimo ne, loto loumami ka yamu kolito, feka uto kufu naba-naba iye. ");
INSERT INTO snp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ena ko lito yokila ki umu-umu amo we kiyabani wemomo muki ido Isilaeli wenena kiyabani we mau witi Yesu ofo fulunuwe, loti ka lo kifiti, ");
INSERT INTO snp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","analo nela witi ilimiti uti gamani kiyaba we wenaba Pailati analo umae. ");
INSERT INTO snp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Ido kuwolafo-mota anido gimami we Yudasi ya Yesu ofo fulunuwe, loti lamo ka ya kolito siya-muluna keina naba-naba ito anido gimami meinala kifana siluwa teti (30) olami yama itibito yokila ki umamo kiyabani we ido Isilaeli wenena kiyabani wemomo ya gimito eti logimami, Namo lifimala minámami we ya kuwolafo anido gimoneto ofo fulunagilanako, lifimane ya naba ne, logimaiye. Logimaifa, amo yate lamo, Lamodoka nedito oto lane? Ya kaimo netaka ne, loti loumato, ");
INSERT INTO snp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi kifanawama oluto uto felegaga kuliyai numuna nabau yau fulito fulo gedeto uto nela oto folaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Folaito, ido yokila ki umu-umu amo we kiyabani we yate kifanama oluti eti lamo, Kifanawa ya ofo fulunagili meina fiyama nenako, yamu felegaga kuliyai numuna naba kifana-koukameku melenumo ya ufe ádenagoliye. ");
INSERT INTO snp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ayawa nedi enumo ne? loti ka lomo uti ya kaba masa olufe lo-lo imo we mikala ya wenena eba malekati oti fulunawamo ya mele gedenumo mikale, loti aya kifanawa yamakafo meina fiyae. ");
INSERT INTO snp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yamu ya mikawa ya wanu mikale, loti kuliya melamo ya oiya ama yaki kuliyawa fa eti lo minae. ");
INSERT INTO snp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ido aya yamu ya komu adeina polofete Yelemaiya eti limo, Amomu ya Isilaeli wenena yate meinala litipelako kifana siluwa teti (30) ya ne, loti kifanawa ya oluti ");
INSERT INTO snp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wekolakafo kaba masa olufe lo-lo imo we mikala meina finawae, loto lonomaido ya meina fiyae, loto ka mono lufuwau (Sek 11:12-13, Jer 32:6-9) nemo kawa ya ayalo wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ilimiti oti gamani kiyaba we wenaba omunalo olu nedi edato, ya kiyaba we wenabamakafo loumami, Kamo Yuda wenena kiyabani we wekudi minabe? loto loga o edaito, ya Yesukafo limo, Kamo kaimoka ya moda lane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ido yokila ki umamo we kiyabani we ido Isilaeli wenena kiyabani we ya Yesu ka ligiya-fagiya ka lo fi umado ya ka ma ádaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ka ma ádaito, Pailatikafo limo, Kamo yamu ka muki ligiya-fagiya lo fi komamo ya ma kolámabe? loto loga o edaifa, ");
INSERT INTO snp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ligiya ka loumamo ya lawoko maki itibito logimámami, yamu ya kiyaba we wenabama kala ligi-ligi kito elegiyaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ena melegelo-melegelo aya foliwa fedaito ya gamani kiyabani wenaba yakafo mau wiyamo wenena ya nelau wenena yauti we ma efilito ilifi fulo, lato ya wewa efili fulo gede-gede iye. ");
INSERT INTO snp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ido aya kamenalo ya kaila fi-fi imo kuliyai we ma kuliya Balabasi ya nela numugu minaito, ");
INSERT INTO snp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailatikafo Yesu ya komumu witi anelo nomae, loto kolainako, wenena mau minamo ya eti logimami, Linate kolamo ya Balabasi ya efili fulo edenafemo, ido Yesu ya Kilistole, loti lamo we ya efili fulo edenae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ena Pailati ka olufe lo-lo amo folomolo yalo minaito, olonafokafo ka ma eti loto fulo edami, Monala efe limo we ya koito edo. Aya we yamu onema famo koto keina naba-naba folowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eti loto kawa fulo edaifa, ido yokila ki umu-umu amo we kiyabani wemomo ido Isilaeli wenena kiyabani wemomo yate mau minamo wenena kani olamo, Balabasi ya fulo edeito Yesu ya ofo folo, loti loumalo, loti logimae. ");
INSERT INTO snp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eti lato, ya gamani kiyaba we wenaba yakafo limo, Wewa lele yauti kema ya linatedoka ya fulo edenae? loto loga o gedaito ya amote Balabasi efili fulo edo, lato ya ");
INSERT INTO snp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailatikafo logimami, Ido Yesu ya Kilistole, loti lamo we ya amomu nedi edenae? loto loga o gedaito, ya mukite loumamo, Yá yofolo ofo folo, lato, ");
INSERT INTO snp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","amokafo logimami, Nediye? Nena mona nosámami ya melamimule? loto loga o gedaito ya ilulu kuti lamo, Yá yofolo ofo folo, loti auma witi lomo wae. ");
INSERT INTO snp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eti lato, ya Pailatikafo kolami, Kane kolámenagilae, loto kolito moda fina finagilamo yamu no ma lekito mau minamo wenena omunido ana noku wito eti logimami, Wewa ya ofo fulunawamo lifima ya namodoka minámenagoliye. Moda linanimonidokako ne, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ya wenena mukite ka itibiti loumamo, Wewa ofo fulunumo lifimawa ya lamoki nomilipate nakutefo-motadoka moda mino ledenaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eti lato, ya Balabasi efilito amodoka fulo edeito, ido Yesu ipi auma witi ofotiti, yá yofolo ofo fulunawae, loto kimiwe anido gimaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ena gamani kiyaba we wenaba kimiwela yate Yesu ilimiti uti Lomu gamani kiyabani we numuna kuliya Pilatoliumule, loti lamo kilalau diti kimiwe ma muki olu mau wi gedeti minoti ogona o edeti ");
INSERT INTO snp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","aimola ukanalo owo wakoti, owo fana kisi limo ma ukanalo wi edeti, ");
INSERT INTO snp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ido kefani kailakafo kokamu olufe loti atelalo kolouto wi edeti, konofa ma ana onaleka ya meleiti omunalo kiyani umola fi umuti suki neta oti koli umuti eti loumamo, Aiyo, Yuda wenena kiyabani we wekudi, siyane! loumuti ");
INSERT INTO snp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ketufu o edeti, konofama oluti atelalo ofomo wae. ");
INSERT INTO snp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ofomo uti kamana kiti, ya owo fanama wakoti aimola ukanalo owo itibiti wi edeti, ya yá yofolo ofenagili ilimiti feka wae. ");
INSERT INTO snp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yesu ilimiti wato, ya we ma Sailinikati ami we kuliya Saimoni eyeti, ya yá yofola ana olu faka loto mofunaiye, loti auma witi lo edato moufaito ");
INSERT INTO snp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ya monimo uti eba ma kuliya Gologota (kuliya monawa ya ateni auma ebale, loto nemo) yalo ya o fedae. ");
INSERT INTO snp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fedato no wainiki ido ekefa imo nowala yaki olu lakoiti nenaiye, loti umato, kefo efema noto kolaifa, eleka ofaito ánaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eti ánaito, moda yá yofolo ofoititi ya ukanalo owola yamu noka kedeti iya meleti olae. ");
INSERT INTO snp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Eti olato, amedoti yalo ya kiyaba o ede minae. ");
INSERT INTO snp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ido atela mulalo ya ofo folamo ka mona Pailatikafo eti loto lufuwa wiyami, Ama ya Yuda wenena kiyabani we wekudi Yesu ya ne, loto lufuwa wiyaito melae. ");
INSERT INTO snp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ido yá yofolo lele malo ya kaila fiyami we lele amoki lakoina ginamo ma ya filiga onaleka ido ma ya filiga adowaleka ya yá yofolo ginae. ");
INSERT INTO snp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ido yalo uti oti amo yate ka nosámami-asámami auma witi loumuti oni aga-aga wi umuti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ake! Kamo felegaga kuliyai numuna naba ya luko fulito fo kamena tili (3) ya kofa ku fukenamo ne, loto lanimo we kamo moda Goti Nalafo minotoma, kaimoka olu omuga koto yá yofolo yati lomo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eti lato, ido yokila ki umamo we kiyabani wemomo ido lo melami ka api gilibamo wemomo ido Isilaeli wenena kiyabani wemomo yalekate ayaidana oti kamana ki edeti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wenena ailo ya olu omuni ko-ko imoma nefa, aimola olu omuna kenae, loto ogoufámaiye. Isilaeli wenena wekudinina minami ya yá yofolo yati oiya amalo lomagetoma, ya moda koli kikito umunagolone. ");
INSERT INTO snp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Amo ya Goti Nalafo minowe, loto limoma ya koli kikito Goti umainako, yamu Gotikafo lalo eyagaiyama ya moda efili edenami ne, loti lo minae. ");
INSERT INTO snp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ido kaila we amoki lakoina yá yofolo ginamo ya ayaidana oti ka nosámami lo edaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ena folilo tuwelu (12) kiloku yalomati u lunaga tili (3) kiloku ya mikau-mikau muki ya sinidomo wiye. ");
INSERT INTO snp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ido lunaga tili (3) kiloku yaloma ya Yesukafo limo, Eli, Eli, lema sabaktani, loto auma wito limo ka monawa ya Gotine, Gotine, nedito fulo nedane? loto lito, ");
INSERT INTO snp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ayalo nedi minamo wenena kawa koliti eti lamo, Wewa ya Elaiya lula fiyaiye, lato, ");
INSERT INTO snp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ido makafo alako oluloto uto neta kuwo nokuti noi yaidana oto nemo ya oluto, no waini ekefa imo yau fito konofa oiyoto pito meleto, Yesu nenaiye, loto umaifa, ");
INSERT INTO snp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ido liligate, Fulitokele. Elaiya oto olu omuna kenaife? Ko minokele, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Eti lato, ido Yesu kofa ka auma wito loito ya moda ouna ilifi meleto folaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Folaito, ayalo ya felegaga kuliyai numuna naba lulau ya eyetenawae, loti lafo-lafo naba kailamo ya yaleka atelalokati fekalito waka lomami ne. Ido mika ya mima naba oto, kifana naba-naba foki-naki oto, ");
INSERT INTO snp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mele gedamo eba ya fokito, felegaga wenena moda folamo ya so loti kono ukani ya kofa nedi gedaito, ");
INSERT INTO snp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mele gedamo ebaleka yati oti, Yesu folaiguti moda neditami kamenalo ya numuna meya felegaga Yelusalemuka diti yalo monimo uti wenena naba oloto pi gimae. ");
INSERT INTO snp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ido kimiwe kiyabani we ido kimiwela ya Yesu kiyaba o edeti minamo yate mima imo ido neta ma muki oloto piyami ya eyeti koli naba-naba gimaito eti lamo, Wewa ya moda ona Goti Nalafo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yalo ya wenaipa muki Yesu Galili mikaloti ege meleti kouba-naba o edamo wenaipa ya faiga nedi minoti, neta koti koliti ");
INSERT INTO snp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ayau minamo wena ya Malia Madala numudoti wenakele, ido lilafo Yemusite Yosefete onibo Maliakele, ido Sebedi nalafo lele onibokele yama minae. ");
INSERT INTO snp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ena lunaga fo saipaito Alimatea numudoti neta-mata ko nami we ma kuliya Yosefe yakafo Yesu ege melami we ya oto ");
INSERT INTO snp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailati nedoka uto Yesu kono ukana ya numunabe? loto loga ito, Pailatikafo kimiwela ya, Umalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eti ato, Yosefekafo kono ukana oluto, lafo-lafo feke kofawa makafo asa wito, ");
INSERT INTO snp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kifana lula ligu aimola fulunamo ya mele nedenawae, loto liyaigu yau meleito, kifana fowena naba-naba ma kululu meleto oluto oto oto kifana lula welalo ma itoito moda wiye. ");
INSERT INTO snp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Moda wito, ena Malia Madala numudoti wena, ido lilafo Malia yate mele edami ebawalo adu yalo amedoti minaiye. ");
INSERT INTO snp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ena leda Sabati foli neta-mata olufe-fe lamo kamena fuli lito ya yokila ki umu-umu amo we kiyabani wemomo ido Falisi we ya Pailati nedoka uti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wenabao, kote wi-wi imo wewa yakafo kofawa minami kamenalo ya eti limo, Fuluto fo kamena tili (3) wageto kofa nedinagolowe, loto limo ka ya kate ki minonima ne. ");
INSERT INTO snp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yamu kimiwe ma gilifageto uti mele edamo kifana welalo itoti ya kamena tiliku (3) ya kiyaba oti minenawae. Eti ámenumo ya ege-ege moinamo we yate kono ukana ya ugele oluti uti, Yesu folaiguti neditaiye, loti wenena muki logiminawamo kawa yakafo komu koni wiyamo ka yama olu afima edetenaiye, loumae. ");
INSERT INTO snp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eti loumato, Pailatikafo limo, Kiyaba enawamo kimiwe gilimiti uti kono kalelo ya kanu olu kiki lenawamo monawa koli minamo yamaidana eti alo, logimaito, ");
INSERT INTO snp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","uti kono kaleloma kanu olu kiki lenune, loti kifana fowenalo aina meleititi fulo gedato, kimiwe kiyaba oti minae. ");
INSERT INTO snp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ena Sabati foli fuli lito salele komu kamenalo ko lenagolido ya Malia Madala numudoti ami wena ido lilafo Malia ya mele edamo eba kenaliye, loti aito ");
INSERT INTO snp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ayalo moda mima naba-naba ito Wekola enisolela ma kosinaukati lumuto o fedeto mele edamo ebalo kifana fowenama kanudo itamoma kululu meleto ya mulalo amedoto minaiye. ");
INSERT INTO snp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Amedoto minami ya ko kopana yamaidana oto lamena ito ukanalo owo ya feke nafu-nafu liye. ");
INSERT INTO snp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ido kimiwema kiyaba oti minamo ya eyeti koli gimaito, ukani ololo o kopaiti wenena ona folamo yamaidana oti lumu fou loti onomo wae. ");
INSERT INTO snp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ena enisolemakafo wena lelema logimami, Linate koli kolámailo. Yesu yá yofolo ofo folamo ya eyenaliye, loti ami ya moda koli minowe. ");
INSERT INTO snp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amo ya komu logimami yamaidana oto moda folaiguti olu nedi edainako, moda amalo minámaiye. E’e, mele edamo ebau yau diti onami ebala ya eyailo. ");
INSERT INTO snp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eyetiti alako uti ege-ege moinamo we ya eti logimailo, Folaiguti olu nedi edaito, ya moda Galili mikau u komu mele gedageto yalo eyenagilae, loti logimailo. Moda logimitowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eti logimaito, wena lelema kono melamo ebalekati alako uti ya luni-kanigu moda koli gimami yaki, ido alikani naba-naba ami yaki lakoina koliti ya ege-ege moinamo we logiminaliye, loti oluloti waido ");
INSERT INTO snp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ya moda kaita Yesukafo katulani oto ya, Setinane, loto logimaito, ya amodoka o fedeti kiyana abusa witi ya ouni-luni-kani umaiye. ");
INSERT INTO snp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ouni-luni-kani umaito, ya Yesukafo logimami, Koli gimámaneyo. Uti kunanefo-mota logimailo, Galili mikau uti yalo ya namo neyenagilae, loti logimailo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ena wena lelema waito, ya moda kale welalo kiyaba amo kimiwe ma Yelusalemu numudo uti netawa muki oloto piyaima ya yokila ki umu-umu amo we kiyabani wemomo logimae. ");
INSERT INTO snp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Logimato, ya yokila ki umu-umu amo we kiyabani wemomo ido Isilaeli wenena kiyabani wemomo yate mau witi ka lo kifiti ya kifana naba-naba oluti kimiwe gimiti ya logimamo, ");
INSERT INTO snp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Linate eti loti lalo, Luwaila ya oku ono minogeto ege-ege moinamo we yate oti kono ukana ya ugele oluti wae, loti lo oloto melalo. ");
INSERT INTO snp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ido kawa ya gamani kiyaba we wenaba kolitoma neta ma o ledetenaiye, loti koli gimámaneyo. Lalimote moda olu you lo edenumo ne, loti logimae. ");
INSERT INTO snp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eti loti logimato, ya kimiwe yate kifanama oluti ka logimado ya meyalo melae. Ido kawa ya Yuda wenena minagu upatomo wimo ya oiya ama ayaidana oti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ena ege-ege moinamo we leweni (11) ya Galili mikau uto Yesukafo mowalo yalo walo, loto logimaido yalo ya idae. ");
INSERT INTO snp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Diti yalo Yesu eyeti ya ouni-luni-kani umafa, ido maleka ya kani ligi-ligi ki minae. ");
INSERT INTO snp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ido Yesu amodoka o fedeto eti logimami, Kosinaleka ido mikaleka aumala muki ya namo nomainako, ");
INSERT INTO snp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","yamu linate uti wenena muki mikau-mikau minadoka ya nege enawamo mona api gilibiti, ya Menefo kuliyalo ido Nalafo namo kulinelo ido Ouna Felegaga kuliyalo noku wi gedeti, ");
INSERT INTO snp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ka lo mele gedodoma muki yaloma etiti meyalo melalo, loti api gilibalo. Eti ato namo ya moda linateki kamena-kamena mino gedemo uto uto mika kosina fuli lenaido minenagolowe, loto logimaiye. Modae. ");
INSERT INTO snp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ka ama ya Goti Nalafo Yesu Kilisto kala kuwa lalo ya ne. ");
INSERT INTO snp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ido polofete Aisaiyakafo ya Gotikafo Nalafo ka loumami ya eti limo, Moda kane lo oloto melenami we ilifoneto u komu mele kedeto kanuka wili kedenagoliye. (Mal 3:1) ");
INSERT INTO snp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kofo mikau yalo we ya welauti ka auma wito eti loto lo oloto melenami, Wekola moninami kanula ya olufe loti wili edalo, loto lo minenaiye, (Ais 40:3) loto ka mono lufuwau ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Etito Yoni ya kofo mikau ya oto noku wi gedeto eti lo oloto melami, Linate Gotikafo lifimate kilili o ledenaiye, loti seti-muludi olu eleyapa winawamo ya namo noku wi gedenagolowe, loto lo oloto melaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eti lo oloto melaito, Yudia ebau muki numudoti-numudoti wenena ato, ido Yelusalemu numudoti wenena muki amodoka oti, nosámami monanina lo oloto melato, Yodani no nabau ya noku wi gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ido Yoni ukanalo owo ya yafo-kameli yowalakafo olufe lamo ya wito, ido kimela ya bulumakau atuwakafo olufe lamo ya kofalalo ya kime wito, ido wela-neta ya ebenuki ido kofuku sabu fimona nowala yaki no-no imo ne. ");
INSERT INTO snp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ido eti loto lo oloto melami, We ma aiga enami ya namo olu fulo nedeto wenaba ona nemoma nenako, namo efe ya kiyanalo netala olu fulo edenamo ya efe ádenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Namo ya nokafo noku wi gedofa, ido wewa ya Ouna Felegagakafo ya noku wi gedenagoliye, loto lo oloto mele minaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ena aya kamenalo ya Yesu Galili ebau Nasalete numudokati oto Yodani no nabau ya Yonikafo noku wi edaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Noku wi edaito, ayalo nokuti dito eyaima kosina godito Ouna ya nema mulu yaidana oto lumuto amodo fiyaito, ");
INSERT INTO snp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ido kosinaukati nola makafo limo, Kamo ya Nanefo sene-mulune komomo we minanimo ya lalo ona keyowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ido ayalo ya Ounakafo Yesu ya kofo mikau ilifaito wiye. ");
INSERT INTO snp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uto, yalo fo kamena foti (40) ya onoto nedito minaito, Satanikafo kepa mele edemo wito, kefa fadenati yaki minaito, ido enisole yate ana olu faka lo edae. ");
INSERT INTO snp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ena Yoni ya nela numugu fulo edetato, Yesu ya Galili mikalo oto Goti kala kuwa lalo lo oloto melemo uto ");
INSERT INTO snp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ya eti limo, Kamena melami ya moda o fedaito, Goti wekudite wenenala kiyaba o ledenami kamena ya moda adu otainako, yamu seti-muludi olu eleyapa witi kawa kuwa lalo ya koli kikito umalo, loto logimimo wiye. ");
INSERT INTO snp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ena Yesu ya Galili nofuna anawalo monimo uto eyami ya Saimonite kunalafo Adulute laefa olu-olu ami we minami yamu noku ya laefa olu-olu amo owo ya fulo minami ya geyeto ");
INSERT INTO snp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","eti logimami, Linate nege melailo. Nege oti ya laefa olu-olu ami lonotina yaidana oti wenena olu-olu enawami we ya bulu gedenagolowe, loto logimaito ");
INSERT INTO snp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","alako laefa owoninama fuliti ya ege meleti waiye. ");
INSERT INTO snp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ido yaloti monimo uto Sebedi nalafo Yemusite Yonite ya sipiku laefa olu-olu amo owonina olufe lo minami ya geyeto, ");
INSERT INTO snp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","alako luni fiyaito, lelewa ya menibo ido kifana lono olamo we sipiku minamo ya fulo gedeiti Yesu ege waiye. ");
INSERT INTO snp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ena Kapeneyamu numudo wato Sabati folilo fedaito Yesu mono numugu dito api gilibaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Api gilibami ya lo melami ka api gilibamo we yaidana oto api gilibámoto, ka mono kula abogakafo api gilibainako, ya koliti elegiyae. ");
INSERT INTO snp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayalo mono numunigu we ma Satani kimiwela mino edami we yakafo au loto eti limo, ");
INSERT INTO snp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aiyo, Nasalete numudoti we Yesuwo, nedi-nedi o ledenagolo ane? Olu kopa o ledenagolo abe? Kamo ya keyefe loneto Gotidokati Felegaga we ya minane, loto au loto liye. ");
INSERT INTO snp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eti lito, ya Yesukafo lo fuko edeto loumami, Kamo ka kedámoto wewa fulo edeto dito wo, loumaito ");
INSERT INTO snp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Satani kimiwelakafo wewa olu imu-damu edeto siya-mulunauti feka oto au naba loto wiye. ");
INSERT INTO snp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wito, ido wenena muki weni lawa apaitaito ya lokoli-fakoli oti eti lamo, Aiyo, ya nena neta ne? Ka mono kofawa ya abogakafo api lilibaiye. Ido yako ya minámaiye. Satani kimiwela ya ka logimaito welalo golodae, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eti lato, ido Galili mikau muki ya kawa kuwa ya upatoto wimo ne. ");
INSERT INTO snp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuki ege-ege moinamo weki mono numuguti u feka uti, ayalo Yemusile Yonileki lakoina uti, Saimonite, Adulute numunigu idato, ");
INSERT INTO snp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni iyabala wena neta kilito ukana kala-kala lito, folomolo ya ono minami ka ya Yesu loumae. ");
INSERT INTO snp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Loumato, amo nedo uto analo oluto olu faka lito ukana kala-kala limoma ya fulo edaito nedito weni-neta apito ofo ki gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ena lunagama fo sapi fuli lito ya neta kilamo wenena ido Satani kimiwela seni-mulunigu mino gedamo wenena ya gilimiti Yesudoka ae. ");
INSERT INTO snp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Oti, numuna meya naba wenena muki minamo numuna kanu welalo mau minato, ");
INSERT INTO snp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesukafo wenena neta ailo-ailo kilamo olu faka lo gedeto Satani kimiwela mumudi ya wenena seni-mulunigu yauti olu fulo gedaifa, eyefe lanako, Ka kedámalo, logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ena leda luwaila sinidigu ya Yesu nedito numudoti lumuto wenena minámamo eba yalo uto Goti loumu minaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Loumu minaito, Saimoniki lakoina minamo wenenaki uti monila wiliti, ");
INSERT INTO snp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","eyeti eti loumamo, Wenena muki ya monika wili minae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Loumato, Yesu itibito logimami, Eba maleka numuna meya adu-adu nedo uto yalo minamo wenena yaki lo oloto giminae, loto ya owe. Yamu wokele, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eti logimito, Galili mika negu-negu ya uto mono numunigu lo oloto gimito, Satani kimiwela olu fulo gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ena okola kilami we ma Yesu nedo oto kiyana umola fito wako lo edeto loumami, Wenabao, kamokafo eti enae, loto kolinanimo ya okola kilomo ya kolouto nedo, loto lageto ukane ya moda koloutenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Loumaito, Yesukafo milumala kolito ana sino loto wewa ukanalo olu minoto loumami, Eti enae. Okola kilanimo kolouto, lito, ");
INSERT INTO snp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ayalo okola kilami ya fulo edaito ukana moda koloutiye. ");
INSERT INTO snp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesukafo ayalo ilifito auma wito lo fuko umami, ");
INSERT INTO snp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Neta eti o kedomo ka ya wenena logimámo. Uto yokila ki umami we ya ukaga ilibageto, keyageto ena Mosesekafo ka lo melamidana oto neta umageto wenena muki yate okola kilanimoma yamu koloutane, loti kolinagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eti loumaifa, ido uto netawa yamu apito wenena muki lo gimi-gimi iye. Yamu Yesu kofa numuna meya ya wenena omunido ámuto wenena minámamo ebalo yako minaifa, ido wenena eba malekati-malekati amodoka o-o ae. ");
INSERT INTO snp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kamena ma olu fulito Yesu kofa Kapeneyamu numudoka itibito aito wenena muki itibito ami kawa ya koliti, ");
INSERT INTO snp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wenena so loti oti mau minato, eba kiki lotami ya kanudoti yaki faito fulitato wenena ma minenawamo eba ma minámaito ya amokafo kala kuwa ya logimi minaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Logimi minaito, we fo (4) yate ana kiyana ipedotoko nemo we ma ilimiti amo nedo afa, ");
INSERT INTO snp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","wenena mau naba faitamo yamu Yesu nedo ya ilimiti unawamo ogoufámoti, numuna mulalo diti Yesu minaido manenalo ya menefa olu fuloti wewama kunuwalo ono minaido fulato numugu lomaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Numugu lomaito, Yesukafo koli kikito umamo monani ya geyeto ana kiyana ipedotoko nemo we ya eti loumami, Nanefo, lifimaka moda kilili otaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eti loumaito, lo melami ka api gilibamo we maleka yalo amedoti minoti eti loti kani kiyamo, ");
INSERT INTO snp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Aiyo, kawa ya nediye liye? Goti kamana ya kiyaiye. Lifima kilili o-o imo we ya Goti aimolakoma ne, loti kani ligi-ligi ki minae. ");
INSERT INTO snp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ayalo ya etiti seni-mulunigu ya kani ligi-ligi ki minamo ya Yesukafo kolito eti loto logimami, Linate ya netawa yamu nediti kani ligi-ligi kiyae? ");
INSERT INTO snp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ido ipedotoko nemo we, Lifimaka ya kilili otami ne, loto loumunamo ya linate kulawa ya eyámanako, suki lifemo, ido ona liye, loti kolámenagilae. Ido, Agagalo yati nedito, kunuka oluto wo, loto loumoneto kulawa eyenawanako, ya suki lifemo, ido ona liye, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Namo We Kula ya mikalo ama ya lifima kilili enamo auma ya moda mino nedami ne, loti kenagilae, loto ya ipedotoko nemo wema eti loumami, ");
INSERT INTO snp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nedito, kunuka oluto, itibito numugaleka wo, loto lokomowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eti loumaito, wewama nedito kunula oluto omunido feka wito wenena muki eyeti elegiti Goti ebola loti eti lamo, Neta yaidana oto komu eyámonima ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ena Yesu kofa feka uto ya nofuna anawaleka wito wenena muki mau minamo ya amodoka ato api gilibi minaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Api gilibito, monito Alifiusi nalafo Lifai ya kifana takisi olu-olu amo ebalo amedoto minami ya eyeto nege ano, lito nedito ege wiye. ");
INSERT INTO snp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu Lifai numunau wela-neta no minaito wenena so loti ege melanako, kifana takisi olu-olu amo weti ido lifimanina nemo weti yaki amoki ege-ege moinamo weki lakoina weni-neta no minae. ");
INSERT INTO snp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ido lo melami ka api gilibi-gilibi amo we yate wenena lifimanina nemo weki, ido kifana takisi olu-olu amo weki lakoina wela-neta no minami ya eyeti ege-ege moinamo we eti loti loga o gedamo, Egaidana oto ya auwa wenena kifanani takisi olu-olu amo weki, ido lifimanina nemo we yaki lakoina wela-neta no minaiye? loti loga o gedae. ");
INSERT INTO snp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Loga o gedato, Yesukafo kawa lamo ya kolito eti limo, Neta kilámamo wenena ya lusa numugu ya ámu-ámu ae. E’e, neta ona kilamo wenena yako ya lusa numugu ya u-u ae. Namo omo ya wenena mona efe limoko melamo wenena ya luni finae, loto ámowe. E’e, lifimanina nemo wenena ya luni finae, loto omo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ena kamena malo Yoni ege melamo wenenalaki, ido Falisi weki ya weni-neta moi witi ánato, wenena maleka Yesudoka oti loga o edamo, Yoni ege melamo weki, ido Falisi weki weni-neta moi wiyato ido kamo kege moinamo we ya egaidana oti weni-neta moi wiyámae? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Loga o edato, Yesu ya itibito logimami, We ma wena olunami we ya yowola wenenaki minenami kamenalo ya egaidana oti weni-neta moi witi minenawae? Amoki ya lakoina minenami kamenalo ya alikani oti weni-neta moi witi ogoufámenawae. ");
INSERT INTO snp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Moi witi ogoufámafa, aiga amodokati wewa ya ipoti olunawamo kamena yalo ya weni-neta moi winawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ido kepa ka ma eti logimami, We makafo ukanalo owo lila ma olu kifinae, loto kofawa fekalito lilalo meleto kifinami we ma minámaiye. E’e, eti enami ya netawa noku winami kamenalo ya lilaki kofawaki ya u lawoko áumoto kofawa yakafo auma wito lila ya olu kopaito fekalinami ne. ");
INSERT INTO snp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ido we makafo no waini kofawa ya lipito yafo-meme atuwa lilau yau leikámenami ne. E’e, no waini kofawa yakafo yafo-meme atuwa lila ya bemudageto ya no waini kofawa ya mikalo lekito u kopa wageto ido yafo-meme atuwa yaki fokito u kopa utenaiye, loto no waini kofawa ya yafo-meme atuwa kofawau lekinami ne. ");
INSERT INTO snp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ena Sabati foli malo ya Yesu yuwa witi kifagu wito ege moinamo we yaki uti ilawa ma apiti doilae. ");
INSERT INTO snp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eti ato, Falisi we mate geyeti ya eti loti loumamo, Geyo. Sabati foliku ya eti ámalo, loto lo fukami ya nediti eti ae? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ka itibito logimami, Defitiki lawoko moinamo wenenaki netamu koliti kadunamu fuluti neta amo ka ya mono lufuwau yau linate katoti kolámafe? ");
INSERT INTO snp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Goti yokila ki umamo we kiyabani we wenaba Abiyata minami kamenalo Defitikafo Goti numunau dito beleti oluto naima ne. Aya beletiwa Goti omunalo mele edamo ya wenena fa wenena ánenawae, loto lo fukamo neta ya Goti yokila ki umamo we inanimo yako no-no amo beletiwa yama oluto noto ido wenenala lakoina minamo yaki gimaito namoma ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ena ka ma enu wito logimami, Gotikafo Sabati foli yamu kolito wenena ya olu oloto pi gedámaiye. E’e, wenena yamu kolito Sabati foli ya mele gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Etito namo We Kula ya Sabati foli yaki aboga minowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ena kamena ma Yesu kofa mono numugu idaito ya we ma ana galidito ya ne. ");
INSERT INTO snp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ido wenena malekate Yesu ligiya loumunune, loti ka ma moni wilimo wamo ya Sabatiku yau wewa ya olu faka lo edenaifemo, ido olu faka lo edámenaiye? loti kogo eye minae. ");
INSERT INTO snp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kogo eye minato, Yesukafo ana galidimo we ya eti loto loumami, Kamo omunido nedi mino, loto loumuto, ");
INSERT INTO snp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ido muki eti loto loga o gedami, Sabati foliku ya mona lalo melenubemo, ido mona nosámami melenune? Ido wenena olu omuni kenubemo, ido olu kopa o gedenune? Linate kolamo ya nena mona ya ufe liye? loto loga o gedaito ya ka kedámae. ");
INSERT INTO snp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka kedámato, Yesu ya siya kala-kala lito kogo ogona oto geyami ya seni-muluni gedinako, keina naba kolito wewa eti loumami, Aga folado, lito ana foladito kofa lalo ya iye. ");
INSERT INTO snp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ana lalo ito, Falisi we feka uti Heloti ege melamo wenenaki Yesu ya ofo fulunune, loti ka lo kifimo uti apiti kudala kiyae. ");
INSERT INTO snp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ido Yesuki ege-ege moinamo weki yalo fuliti nofuna anawalo wato, wenena mau naba Galilikati oti ya ege wae. ");
INSERT INTO snp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ege wamo wenenawa ya neta muki imo ka ya kolititi maleka ya Yudiakati ato, ido maleka ya Yelusalemukati ato, ido maleka ya Idumea ebalekati ato, ido maleka ya Yodani no naba wela filigalekati ato, ido maleka ya Taiya numudo, ido Saidoni numudo eba adu nedo-nedo yaloti ae. ");
INSERT INTO snp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Etiti oti mau naba-naba minanako, Yesukafo ege moinamo we ya logimami, Wenena muki yate miwi nedetenawae, loto sipi kefola ya olufe lo nedalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eti logimami komu wenena so loti ya olu faka lo gedainako, yamu oiya neta kilamo wenena muki ya ukanalo olunune, loti adu adu oti itufu-matufu ae. ");
INSERT INTO snp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eti ato, ido Satani kimiwela mino gedamo wenena yate eyeti ya kiyanalo kiyani umola fiti au loti eti lamo, Kamo ya Goti Nalafo minane, loti lafa, ");
INSERT INTO snp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","amokafo eyefe lamo yamu auma wito lo fuko gimami, Namo ya olu oloto pi giminune, loti logimámalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ena Yesukafo mowalo dito aposolo lono olunawae, loto kolami we ya alo, logimaito amodoka ato, ");
INSERT INTO snp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","we tuwelu (12) ya namoki lakoina minoti, kane kune lalo lo oloto melenawae, loto gilifito weneloti Satani kimiwela olu fulo gedeti gilifi melenawae, loto iyaina o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wewa tuwelu (12) ya kulini etito ne: Saimoni, kuliya kofawa Pitale, loto melaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ido Sebedi nalafo Yemusite Yonite, kulini kofawa Bowanegesele, loto melami kuliya monawa ya ko kalake limo yaidana oti minaiye, loto melaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ido Adulu, Filipi, Batolomiu, Matiu, Tomasi, Alifiusi nalafo Yemusi, Tadiusi, Saimoni ya kuliya ma Seloti, ");
INSERT INTO snp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ido Yudasi Isikaliyoti Yesu kuwolafo anido melami we ya ne. ");
INSERT INTO snp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ena Yesu ya numugu idaito wenena kofa mau naba minanako, Yesuki ege moinamo weki weni-neta nenawamo kamena ya minámaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ido kawa wenenala yate koliti, Kala-manena ya u kopa wimo yamu ilimito unune, loti amo minaidoka ae. ");
INSERT INTO snp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eti ato, ido lo melami ka api gilibi-gilibi amo we Yelusalemukati amo yate eti lamo, Satani kimiwela wenabanina Belesebuli ya Yesu mino edaiye. Mino edaito amo ya Satani kimiwela wenabanina aumala yakafo Satani kimiwela wenena seni-mulunigu nemo ya olu fulo gedeto gilifi melaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yamu Yesukafo, Alo, logimito kepa ka eti loto logimami, Egaidana oto Satanikafo Satani olu fulo edeto ilifi melenami ne? ");
INSERT INTO snp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lawoko wenena inanimo foki filiga-filiga oti fina finawamo ya auma wi minámenagilae. ");
INSERT INTO snp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ido numuna meya lawoko yautife, ido ufa lawoko yauti, inanimoni foki filiga-filiga oti, fina finawamo ya auma wi minámenagilae. ");
INSERT INTO snp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ido Satani wenenala inanimoni foki filiga-filiga enawamo ya Satani auma wi minámaito kiyaba o gedami kamenala ya fuli lenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Etito we makafo auma wiyami we ma numunau ya fukoto dito koukamela olunae, lenami ya komu uto auma wiyami we ya nela wi edenami yako ya koukamela muki ugele olunagoliye. ");
INSERT INTO snp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ka ona logimowe. Wenena lifimani mona-mona muki ido wenena kamani kiyamo kani lifimani kilili o gedenagolifa, ");
INSERT INTO snp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","makafo Ouna Felegaga kamana kinami ya lifimala kilili o edámenagoliye. Aya lifimawa ya minomo dinagoliye, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Lo melami ka api gilibi-gilibi amo we yate Satani kimiwela siya-mulunau ne, loti lamo yamu Yesukafo kawa ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ena Yesu olafo kunalafo-mota o fedeti feka nedi minoti amo minaido, Ano, loti ka fulato, ");
INSERT INTO snp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","wenena mau naba ogona o edeti amedoti minamo wenena yate eti loumamo, Okafoki kunakafo-motaki ka lokumunagili feka minae, lato ");
INSERT INTO snp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesukafo itibito logimami, Onefo kunanefo-mota ya kema ya minae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loga o gedeto, ogona oti amedoti minamo wenena geyeto eti limo, Amau ya onefo kunanefo-mota ya minae. ");
INSERT INTO snp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ido mate kosinau Menefo kala lalo kiyami mona meyalo mele-mele amo ya onefo kunanefo nemonane-mota ya minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ena kamena malo, Yesukafo kofa nofuna anawalo ka mono api gilibaito, wenena so loti o fedeti olu mau witi ogona o edamo, yamu sipi mau dito nofudo amedoto minaito, wenena muki nofuna anawa akelo ya minomo wae. ");
INSERT INTO snp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Minomo wato, amokafo neta-mata muki kepa ka loto api gilibito eti limo, ");
INSERT INTO snp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kolalo. We makafo ufa neta itili enae, loto migu uto ");
INSERT INTO snp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","itili ito ufa neta ma kanudo olumo wiyami ya nema yate oti no fuli lae. ");
INSERT INTO snp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ido ufa neta ma kifana mulalo nedo olumo wiyami ya mika kefo nemoma nenako, alako fou lifa, ");
INSERT INTO snp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","fo lido ya megunito lufawa naba minámainako, apatito folaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ido ufa neta kaila imo neta idaigu olumo wiyaito, ya kaila imo neta yakafo dito olu itoto ofo folainako, kulawa liyámaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ido ufa neta ma mika lalo negu olumo wiyami ya fokito dito ilawa liyami ya tetife (30), ido sikisitife (60), ido wani hadeti (100) ya oloto pi gimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Linate kati nemo wenena ya kawa ya kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aiga ya Yesu aimolako minaito, ege moinamo we tuwelu (12) yaki ido lakoina mino-mino amo wenenaki yate kepa ka limo yamu loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","amokafo eti logimami, Goti wekudite wenenala kiyaba o ledami monala ka falukuto nemo ya linate moda olu oloto pi gimitaiye. Eti ifa, ido feka minamo wenena ya neta-mata muki ka asa witoko logimowe. ");
INSERT INTO snp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yamu eti loto limo, Ko-ko o minafa, neta kofe loti eyámenagilae. Ido koli-koli o minafa, ka kolife loti kolámenagilae. Eti ámamo neko, seni-muluni olu eleyapa wiyato lifimani kilili o gedagi ne, loto ka mono lufuwau (Ais 6:9-10) ya nemo ne. Yamu kepa ka logimi-gimi owe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ena Yesukafo eti loto logimami, Kepa kawa lomo ya kolife loti kolámafe? Ka muki asa wito lenamo, ya egaidana oti kolife loti kolinawamo ne? ");
INSERT INTO snp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ufa neta itili imo we ya Goti kala ya itili imo ya ne. ");
INSERT INTO snp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ido wenena ma ya ufa neta ma kanudo olumo wiyami yaidana oti minae. Wenenawa Goti kala ya kolafa, ayalo Satanikafo oto ya Goti kala seni-mulunigu kifami yama olu fulitaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ido maleka ya ufa neta ma kifana mulalo olumo wiyami yaidana oti minae. Wenenawa Goti kala koliti ayalo alikani naba afa, ");
INSERT INTO snp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ido lufawani minámainako, yamu kamena linako koli kikito umu minato, ya Goti kala koli kikito umamo yamu wenena mate kaila fi gedamo yamu keina naba-naba amodoka o fedenami kamenalo ya Goti kala ya fuliti u kopa wae. ");
INSERT INTO snp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ido maleka ya ufa neta ma kaila neta idaigu yau olumo wiyami yaidana oti minamo Goti kala kolafa, ");
INSERT INTO snp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ido ama mikaleka keina kolamo neta-mata yaki, ido neta ko namo neta-mata kote winami netaki, ido neta-mata mamu senimulunigu kolamo neta yamo o fedeto Goti kala ya olu itainako, kulawa ámami ne. ");
INSERT INTO snp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ido maleka ufa ma olumo mika lalo negu wiyami yaidana oti minamo ya Goti kala koliti koli kikito umato, amodoka kulawa tetife (30), ido sikisitife (60) ido wani hadetife (100) ya oloto pi gimi minami ne, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ido ka ma eti loto logimami, Linate ya lamu kiti oluti masa lulau yau melenawamo nefemo, ido folomo feumau yau melenawamo nefe? E’e, etiti melámoti, lamu mele-mele amo ebalo yalo ya melenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yamu kolalo. Komu neta ma kolife loti kolámamo neta ya aiga kolife loti kolinawamo ne. Etito neta-mata muki oiya falukuto nemo ya aiga olu oloto pi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ido kani nemo wenena yate kawa ya kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Linate ya ka kolinawamo ya koti kolalo. Ido gimi-gimi amo monatina yaidana oto itibito gimito, ido mulalo-mulalo oto giminami ne. ");
INSERT INTO snp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ido neta ko namo wenena ya aiga maki enu wito giminami ne. Ido neta ko ánamo wenena ya neta kefoko ko namoma ya amodokati ipenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ido ka ma enu wito eti logimami, Goti wekudi wenenala kiyaba o ledami monala ya etito ne: We ma ya ufa neta mikalo itili imo we ");
INSERT INTO snp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ya fo limo, sinidimo, onoto nedito oto minami kamenalo, ya ufa neta fou loto dito nefa, mona ya kolife loto kolámaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mika aimolakafo ya ufa neta olu auma wi edaito, komu aila oloto pito, aiga ugawa oloto piyaito, ya kilito oto, aiga kulawa liyaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kulawa liyaito, doliti olu mau winawamo kamenawalo ya kulawa ya doli-doli iye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ena Yesukafo eti loto loga o gedami, Goti wekudite wenenala kiyaba o ledami monala ya nena neta yaidana oto ne, loto lenune? Ido nena netalo olumo meleto asa wito lenune? ");
INSERT INTO snp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kolipa ilawa ya kefo efema yaidana oto ne. Kolipa ilawa kefo efe yakafo ufa neta muki mikau kifamo kefonina ya olu fulo edaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eti imo kolipa ufa ya kifato, fou loto yá kolipa naba dito migu neta muki olu fulo edaito, nema-afa kosinalo moinamo ya oti akawalo amene melaigu ya mino-mino amoma ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Etito Yesukafo Goti kala api giliboneto kolinawae, loto kepa ka yaidana oto mona-mona ka api gilibaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Api gilibami ka ya efe loto lo oloto pito logimámoto, kepa kako logimaifa, ido ege-ege moinamo weki amoki lawoko minado yalo kepa ka monawa muki ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kamena yalo ya lunaga fo saipaito Yesukafo ege-ege moinamo we eti logimami, Nofuna anawa filiga afulaleka wokele, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","wenena muki mau witi minamo wenena ya fulo gedeti Yesu sipi kefolau minaito ya ilimiti sipi maki lakoina wae. ");
INSERT INTO snp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wato, epe naba-naba oto ya nokafo sipi olu akaima ito ya sipikuma no lulau lumunae, loto ito, ");
INSERT INTO snp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu sipi meyalo ya lagalo oku ono minaito, ege-ege moinamo we oti eku oti eti loumamo, Api lilibanimo we, lalimo oiya ya no lulau lumuto fulunagolo onimo ya kaka ki lomámabe? lato, ");
INSERT INTO snp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","amo ya nedito ya epe naba-naba limo ya oduto ido no satimo ya, You lo mino. Sodoto mino, loumaito epe fu-fu ádoto no satimo momoga ámoto you loto ne. ");
INSERT INTO snp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","You loto neto, amokafo ege-ege moinamo we eti loto loga o gedami, Linate nediti koli kolae? Koli kikito nomámafe? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","koli naba-naba koliti inanimonigu eti loti lokoli-fakoli amo, Aiyo, we ya egaidana we minaito, epe yaki ido no yaki ka lido ya golodaiye? loti lae. ");
INSERT INTO snp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuki ege-ege moinamo weki no nofuna wela filiga akailaleka Gelasa wenena mikanido ya u fedato, ");
INSERT INTO snp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu sipikuti mikalo lomaito we ma Satani kimiwela mino edami we ya kifana lulau kono auma melamo ebauti ami ya katula iye. ");
INSERT INTO snp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wenena ya aya wewa kono ukani melamo ebalo onoto nedito minami we ya nela wi edenune, loti afa, ogoufámae. Ido nela auma wiyami ainikafo olufe lamo yakafo nela wi edenune, loti amo yaki ogoufámae. ");
INSERT INTO snp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Komu kamena so loto aini nelakafo ana-kiyanalo wi edafa, amokafo analo aini nela ika oto fulito ya ido kiyanalo aini nela fukoto fulitainako, ya auma wito olu afima edenami we ma ya minámaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E’e, wewa yakafo foliloti luwailaloti kono ukani melamo ebaloki mowaloki ya au naba loto aimola ukana-akana ya kifanakafo fuko-nako o-o iye. ");
INSERT INTO snp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wewa ya faigakati Yesu eyetoto amodoka oluloto o fedeto omunalo kiyana umola fiyaito, ");
INSERT INTO snp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesukafo eti limo, Satani kimiwela nosámamo linate we ya siya-mulunau ya fuliti walo, loto limo yamu wewama au naba-naba loto eti limo, Yesuwo, Goti akaiya nemo we wenaba Nalafo, nedi-nedi o nedenagolo namodoka ane? Ukane ogofu olu nomámenae, loto Goti kuliya loto ka lanimo ya olu onae, loto lonomo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Loumaito, Yesukafo, Kulika lo, loto loumaito siya-mulunau yau Satani kimiwela muki diti minainako, yamu kuline Lisiyonile, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Loumuto, Ya eba mauka olu fulo gedámo, loto wako lo edemo wiye. ");
INSERT INTO snp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ido mowalo adu yaleka yalo yafo mau naba noti minamo yamu ");
INSERT INTO snp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ya Satani kimiwela yate loumamo, Lilifi melageto ya yafo seni-mulunigu dinagolobao? loti wako lo edato, ");
INSERT INTO snp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O, lito Satani kimiwela ya wewa siya-mulunau ya fulititi yafo seni-mulunigu idato, yafo mau naba tu tauseni (2,000) yaidana oti minamo ya koli lumuti lowau konidokati oluloti nofugu yau no noti moda folae. ");
INSERT INTO snp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Folato, ya yafo kiyaba amo we ya eyeti koli oluloti uti wenena numuna meya nabauki ido migu minamo wenena yaki kawa logimato, wenena mate netawa eyenune, loti oti ");
INSERT INTO snp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesu minaido fedeti komu Satani kimiwela siya-mulunau mino edamo wewa ya oiya ukanalo owo wito kala-manena efe loto neto minoto ya Yesu kiyanalo amedoto minami we ya eyeti ya koli gimaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ido netawa koliti eyeti amo wenena yate Satani kimiwela mino edamo we kala yaki ido yafo kanina yaki logimae. ");
INSERT INTO snp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Logimato, wenena ya Yesu auma witi eti loumamo, Lamo ebate fulito wo, loti wako lo edae. ");
INSERT INTO snp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wako lo edato, sipiku di minaito wema komu Satani kimiwela mino edamo we ya Namote unalifao? loto wako loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","amokafo, E’e, kamo numugaleka wo. Wageto, Wekolakafo milumaka kolito ya neta-mata muki olufe lo kedami ya wenenaka logimo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eti loumaito, wewa Dekapolisi eba yalo uto Yesukafo neta-mata muki o edami ka ya lo gimi-gimi omo wito wenena muki kani mumudi kiyae. ");
INSERT INTO snp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ena Yesu sipiku nofuna wela filiga itibito uto anawalo minaito, wenena mau naba ya ogona o ede minae. ");
INSERT INTO snp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eti minato, mono numuna kiyaba we wenaba ma kuliya Yailusi yalo oto Yesu eyeto, kiyanalo kiyana umola fito eti loto wako loumami, ");
INSERT INTO snp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Olunefo kefola moda fulunagolinako, yamu olu faka lo edageto ya omuna kofawa minenaiye, loto amodoka oto aga ya ukanalo ya melo, loto wako liye. ");
INSERT INTO snp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wako lito, Yesute lakoina waiye. Waito, wenena mau naba yate olu lulau edeti wato, ");
INSERT INTO snp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","yalo wena ma nemo ya wanula leki-leki imo melege tuwelulo (12) yalo netawa kilaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Netawa kilito, lusa we so loti minadoka wito olu faka lo edenune, lato kifana meina fimo wifa, ukana ogofu umuti netawa kilami ya faka lo edámato neta kilami ya u naba wito, kifanala muki ya moda fuli liye. ");
INSERT INTO snp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ido wenawa ya Yesu monala lamo ka ya kolito egeka oto ukanalo owo ya olaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Olami ya faifa ukanalo owo olunamo ya faka lenagolowe, loto kala kiyainako, ukanalo owo ya olaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Olaito, ayalo ya ukanau neta kilami fuli lito, ukanau-akanau kolami ya faka liye. ");
INSERT INTO snp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Faka lito, ayalo Yesu aumala ma amodokati wimo ya kolito wenena mau naba minagu ya eleyapa wito eti loto loga o gedami, Ukanelo owo ya kema olaiye? lito ");
INSERT INTO snp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ege moinamo we yate itibiti loumamo, Wenena mau naba yate olu lulau o kedamo ya geyanimo ya nenako, egaidana oto namo ukanelo ya kemakafo olaiye? loto lane? loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Loumafa, Yesu ya kemakafo etiye? loto kala kito kogo ogona oto geye minaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Geye minaito, wenawa ukanalo neta fede umami ya kolito amodoka oto kiyanalo kiyana umola fito koli kolito ukana ololo oto, kawa monawa ya lo oloto meleto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesukafo loumami, Olunefo, kamo koli kikitanimo yakafo olu faka lo kedaiye. Keina kolanidokati efili kedoneto seka-muluga you lageto wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesukafo eti loumu minaito, ayalo ya mono numuna kiyaba we wenaba Yailusi numunau yati ma oti ya eti loti loumamo, Olukafo moda fulutaiye. Yamu api lilibami we ya koiya fi ámenune, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu kawa lamo ya koli fuli loto mono numuna kiyaba we wenaba eti loumami, Kaka lele kiyámoto namo koli kikito numutoko mino, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eti loumuto, wenena muki nege ámalo, loto logimito Pitale, ido Yemusile kunalafo Yonile yako gilimito uto ya ");
INSERT INTO snp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","mono numuna kiyaba wenaba numunalo fedato, wenena momoga-amoga oti au-au loti kufu-nema auma witi oti minamo ya geyaiye. ");
INSERT INTO snp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Geyeto, numugu dito wenenawa eti logimami, Momoga naba oti kufu ámalo. Nomiliwa ya folámoto faifa oku onaiye, loto logimaifa, ");
INSERT INTO snp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","kiya o edae. Kiya o edato, muki gilifi feka fulitito nomiliwa olafo melafo ege moinamo we lakoina amo we yaki gilimito, nomili ebalau ya dito ");
INSERT INTO snp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","analo oluto eti loumami, Talita kumi, limo kawa monawa ya nomili kefolao, neido, loto lokomowe, lito ");
INSERT INTO snp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ayalo ya nomiliwama nedito moinaiye. (Aya nomiliwa ya olafo kedaidoti melegela tuwelu (12) ya ne.) Moinaito, ya eyeti moda weni lawa apaitaito ");
INSERT INTO snp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesukafo eti lo fukami, Netawa ya logimámalo, loto ido, Nomili wela-neta umalo. Nenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ena Yesu ebawa ya fulito aimola numuna ebalalo ya ege moinamo weki lakoina wae. ");
INSERT INTO snp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lakoina uti, Sabati foliku mono numunigu dito apito logimami ka wenena so loti koliti weni nowala apaitaito ya eti lamo, We ama ya kala ya egalekati oluto liye? Amo ya ka manenau nemo we kemakafo api ilibaiye? Ido Goti aumala lilibami netawa olu oloto pi lomami auma ya egalekati olaiye? ");
INSERT INTO snp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wewa auwa ya faifa numuna ku-ku imo wema yae. Ido amo ya Malia nalafo yae. Ido kunalafo-mota Yemusikele, Yosefekele, Yudasikele, ido Saimonikele yama minamo yae. Ido emonala-mota muki ya lamoki lakoina ya minonimo yae, loti ya seni-mulunigu koli nosámami umae. ");
INSERT INTO snp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eti afa, Yesukafo eti loto logimami, Polofete ma ya muki ebau ya kuliya olu faka lafa, ido aimola numuna meyalo ido aimola numunau, ido wenenala minagu, ya kuliya olu faka ádenagilamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eti logimito, ido aya ebalo Goti gilibami neta ya oloto pi giminami ogoufámoto, neta kilamo wenena lawoko lawoko yako ukanido anakafo oluto ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ido koli kikito umámamo yamu kala mumudi kiyaiye. Ena Yesukafo numudo-numudo ya monito api gilibi-gilibi iye. ");
INSERT INTO snp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ido ege-ege moinamo we tuwelu (12) ya amodoka olu mau wi gedeto, lele lele lonolalo apito gilifi melenagolo ya komu Satani kimiwela olu fulo gedeti gilifi melenawae, loto ya auma gimaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Auma gimito eti loto logimami, Linate kanudo unawamo neta-mata olámoti, kolobo yako oluti, ido beletife, ido owotinafe, ido kifana owotife yaki olámoti faifa walo. ");
INSERT INTO snp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ido kiyanido neta winawafa, ido ukanido owo lele ya wiyámalo. ");
INSERT INTO snp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ido numugu dinawagu yau yako onoti nediti oti minomo uti numuna meya malo unagilima ya kamenalo ya numunawa fulitalo. ");
INSERT INTO snp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Etiti eba maleka u fedato koina wi gedámoti, ido ka lenawamo ya kolámatoma, numunawa ya fuliti kiyanido momupa ekelami ya kululu witi fuliti monatina kolinawae, loti fulo gedalo, loto logimitoto ya gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gilifi melaito, ya uti seti-muludi olu eleyapa wiyalo, loti lo oloto meleti, ");
INSERT INTO snp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Satani kimiwela so loti olu fulititi ya neta kilamo wenena so loti ya yá ilawa nowala fili gedeti ya olu faka lo gedae. ");
INSERT INTO snp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ena Yesu eti imo ka ya wenena muki kolato, mikalo kiyaba we wekudi Heloti yaki kawa kolaiye. Kolaito, wenena malekate eti lamo, Wewa Yesu ya Yoni noku wi gede-gede imo we ya ne. Amo yama folaiguti olu nedi edainako, mebe-mabawa ya olu oloto pi-pi o minaiye, loti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ido malekate ya eti lamo, Wewa ya Elaiya ya ne, lato ido malekate eti lamo, Amo ya polofete adeina minamo yamaidana oto polofete ma ya ne, loti etiti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kawa lamo ya Helotikafo kolito eti limo, Yoni namo kenobala fuko fulomo ya folaiguti olu nedi edaiye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Eti limo ya komu Helotikafo kunalafo Filipi olonafo kuliya Helotiyasi olaito, ya Yonikafo eti loumami, Helotiyo, kamo kunakafo olonafo olanimo ya lo melami ka ya fukane, loto loumu-umu iye. Eti loumami yamu wena Helotiyasi siya kala-kala lito, Yoni ya ofo fulunae, loto kolaifa, Heloti ya kolami, Yoni ya monala ya fe-fe loito felegaga we ne, loto kolito koliya kolito kiyaba lalo o edainako, Helotiyasikafo ofo fulunami ogoufámaiye. Ogoufámaito, Heloti ya Yoni ka limo kolito kala mumudi kiyami nefa, ka limo kolinae, loto lalo kolaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ena aiga ofo fulunami kamena ma etito oloto piyaiye. Heloti olafo kedami kamenala ya oloto piyaito, wenena kiyabani we wenaba yaki kimiwe kiyabani we wenaba yaki ido Galili minamo wenena kiyabani we wenaba yaki ato weni-neta ofo kiyaito nae. ");
INSERT INTO snp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Weni-neta nato, wena Helotiyasi olulafo oto omunido melege olaito Helotiki amoki lakoina namo wenenaki ya lalo eyato, mikalo wekudi yakafo nomiliwa eti loumami, Kamo ya, Neta ma olunae, lenanimo ya kumunae. ");
INSERT INTO snp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ido, Ebaka filiga olunae, lenanimo yaki moda kumunae, loto lo gedoto lo mele edaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lo mele edaito, feka uto, Ya nena neta loumunae? loto olafo loga o edaito, itibito loumami, Yoni noku wi gede-gede imo we manena ya olunae, loumo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eti loumaito, ayalo ya nomilima oluloto mikalo wekudima nedo oto eti loumami, Oiya Yoni noku wi gede-gede imo we atela ya lapelo nomo, liye. ");
INSERT INTO snp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kawa lito, mikalo wekudikafo kolito siya-mulunau keina naba-naba ifa, weni-neta amoki lakoina namo wenena omunido ya nomili ka lo mele edomo nenako, yamu ya nomiliwa kala ma olu fulitámenae, loto kala kito ");
INSERT INTO snp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ayalo kimiwe eti loumami, Yoni manena otano, loto ilifaito ya uto nela numugu Yoni kenobala fuko fuloto ");
INSERT INTO snp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","atela ya lapelo meleto oluto oto nomilima umaito ya oluto olafo umaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ido Yoni ege-ege moinamo we ya kawa koliti oti kono ukana ya oluti uti kale li edae. ");
INSERT INTO snp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesukafo aposolo komu gilifi melami we ya itibiti amodoka oti ya neta-mata eti amo ido api gilibamo ka muki ya loumae. ");
INSERT INTO snp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Loumato, ya wenena muki uti oti anako, neta nenawamo kamena minámaito, ya aposolo Yesukafo eti logimami, Lalimoko wenena minámenawamo ebalo uto foli minenune, logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Logimaito, sipiku diti eba fafato inanimoko wae. ");
INSERT INTO snp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Eba fafato wado ya wenena muki geyeti numuni meyau yati muki mikalo oluloti uti komu u fedae. ");
INSERT INTO snp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Komu u fedato, Yesu sipikuti mikalo lumuto ya wenena mau naba minamo geyeto ya sipisipi kiyabani we minámamo yamaida oti minanako, yamu siya-mulunau miluma koli gimito neta-mata muki api gilibaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Api gilibi minaito, lunaga fo sapinagolito ege moinamo we amodoka oti eti loumamo, Eba fafato ama ya minogeto ya sinidenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yamu wenena ya numudo-numudo ya gilifi fulageto weni-neta meina finawae, loto gilifi melo, loumae. ");
INSERT INTO snp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eti loumato, Linate yate weni-neta ma gimalo, loto logimaito itibiti loumamo, Aiyo, netawa meina finumo ya meinala kifana denaliyasi tu hadeti (200) yaidana oto minenagoliye. Lamote ya uti kifana naba fuloti beleti meina fi gedeti oti gimalo, loto labe? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Loga o edato, eti logimami, Beleti nenaki olu minae? Uti kalo, logimaito uti olu oloto pititi itibiti oti eti loumamo, Beleti faifu (5) ido laefa lele olu minone, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Loumato, eti logimami, Wenena muki mau minamo ya we fiti yuwa laloto ya amedalo, loti logimalo, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ido wenena fifiti-fifiti (50) ya mau minamo ido maleka wenena wani hadeti wani hadeti (100) ya mau minamo ya yuwalo amedoti minae. ");
INSERT INTO snp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amedoti minato, Yesukafo beleti faifu (5) ya oluto kosinalo ko faka loto, siyane, lalole, lototo ya leketo ege-ege moinamo we yate iya meleti wenena mau naba ya giminawae, loto gimaiye. Ido laefa lele yaki iya mele gimaito ");
INSERT INTO snp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","muki noti muni ito ");
INSERT INTO snp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ido ege moinamo wewa ya luma nemo onowa-fanawa minomo wimo ya kiyaka oti, owo kedikoko naba tuwelu (12) ya koilato faitimo ne. ");
INSERT INTO snp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ido weni-neta namo wemomo ya faifu tauseni (5,000) ya minae. ");
INSERT INTO snp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ayalo Yesukafo ege moinamo we ya eti logimami, Linate sipiku ya diti Betesaida numudo komu meleti walo, loto logimito wenena mau minamo ya gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Gilifi meleto fulo gedeito ya Goti loumunae, loto mowalo idaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Idaito, luwaila melenagolito sipima mika fulo faiga ito u nofuna muliti utaito, aimolako mikalo ya minaiye. ");
INSERT INTO snp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Minoto geyami ya epe naba ma konidokati oto olu bubudito koiya fiti ika o minato, ya Yesu geyaiye. Geyeto, kolomolomo yaleka ya no mulalo kiyanakafo leya wito monimo oto minado oto ya fulo gedeito unae, loto kala kiyaifa, ");
INSERT INTO snp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","amote Yesu no mulalo moinami ya eyeti eti kolamo, Kolofa ne, loti kani kiti ya muki eyeti koli naba-naba gimainako, ");
INSERT INTO snp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","au naba-naba lae. Au naba-naba lato, ayalo ya eti logimami, Seti-muludigu ya auma wiyalo. Namoma minowe. Koli gimámaneyo, loto logimito ");
INSERT INTO snp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","sipiku lakoina idaito ya epe fuli lito elegiti, ");
INSERT INTO snp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","seni-muluni gedimo nenako, komu beleti iya melami monala ya kolife loti kolámae. ");
INSERT INTO snp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ido nofuna ya yofototo uto Genesalete mikalo fedeti sipi no anawalo nela witi olu kiki loti ");
INSERT INTO snp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","sipikuti lomato, ayalo ya wenena ya Yesu eyefe loti, ");
INSERT INTO snp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","eba negu-negu yati muki oluloti oti minami ebaleka ya wenena neta kilamo ya kununido meleti gilimiti ae. ");
INSERT INTO snp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gilimiti amo yaidana oti Yesu eba muki amaufe yaufe, ido numuna meya nabalofe, ido kefolalofe wimo ya wenena mau minamo ebalo neta kilamo wenena ono gedeti ya eti loumamo, Ukagalo owo anawalo yako olunagolone, loti wako loumato ido wenena muki olamo ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falisi weki lo melami ka api gilibi-gilibi amo we malekaki ya Yelusalemukati Yesu nedo oti mau minato, ");
INSERT INTO snp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ege moinamo we maleka ani noku wiyámoti weni-neta nato ya geyae. ");
INSERT INTO snp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Geyeti, Falisi weki ido Yuda wenenaki muki ya aunibo-mota kidene kanina meyalo meleti weni-neta nenagilima ya komu ani noku witiko no-no ae. ");
INSERT INTO snp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ido maketilo yati neta ma oluti otima, komu noku witiko no-no ae. Ido kidene ka so loti kaputi masati lapeti noku wi-wi amo mona yamaidana oti meyalo melae. ");
INSERT INTO snp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yamu Falisi we ido lo melami ka api gilibi-gilibi amo we yate eti loti loga o edamo, Egaidana oti kege-kege moinamo we yate autefo-mota kidene kanina ya meyalo meleti weni-neta nenagilima ani noku wiyámae? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Loga o edato, itibito logimami, Aisaiyakafo komu adeina linate monabi lele wiyamo yamu ka ona loto eti limo, Wenenawa ya wenido yako kuline olu faka lafa, seni-mulunigu koli nomámoti, ");
INSERT INTO snp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","eti lamo, Kawa ya Goti kala ne, loti lafa, ido wenena kidene kani yako api gilibiti ouni-luni-kani nomamo monawa ya fa neta ne, loto ka mono lufuwa wiyaigu (Ais 29:13) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ido Goti lo melami kala ya linate olu fuliti wenena kidene kanina olu kiki loti olumo wae. ");
INSERT INTO snp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Linate eti lamo, Lalimo monate yako meyalo melenune, loti Goti lo melami kala fulitamo ya monate lalo ne, loti kani kiyafe? Olo. ");
INSERT INTO snp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yamu Mosesekafo eti limo, Otibo metibo kulini olu faka lalo, loto (Kis 20:12, Lo 5:16), ido ka maki eti limo, We makafo ka nosámami olafofe melafofe ya lo gedenami, aya we ya ofo folalo, loto ka mono lufuwau (Kis 21:17) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eti lifa, we makafo olafo melafo logiminami, Namo neta muki ko mele gedomo neta yama felegaga neto Goti moda umutomo ne, logiminami we ya ");
INSERT INTO snp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","linate eti loumamo, Okafo mekafo netawa gimito kofa olu lalo gedámanimo ya lalo ne, loti loumuti, ");
INSERT INTO snp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","linate monati etiti api gilibamokafo Goti kala olu fa neta oti fulitae. Ido linate mona yamaidana oti so loti eti mele-mele ae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesukafo wenena mau minamo luni fiyaito amo minaido ato eti logimami, Linate muki kane koliti ya kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Neta-mata feka nemo neta yakafo luteu dinami ya olu ladi o ledámenagolifa, ido neta-mata oude-lute-kateu yati feka ami neta yakafo olu ladi o ledaiye.  ");
INSERT INTO snp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Linate kati nemo wenena yate kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wenena mau minamo fulo gedeito numugu idaito, ya ege-ege moinamo we yate kepa kawa limo yamu loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","amokafo eti logimami, Ake, linate yaki kolife loti kolámafe? Neta-mata fekati luteu idami ya ");
INSERT INTO snp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","oudelute-kateu idámoto, sete kofumawau yako dito, aiga sefe lo fulo-fulo oninako, oude-lute-kate ya olu ladi o ledámaiye, loto limo ya etito wete-neta muki nonimo ya lalo ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eti loto ido ka ma eti limo, Oude-lute-kateuti feka ami yakafoko Goti omunalo ya olu ladi o ledaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yamu oudi-luti-kati yauti kati-manidi nosámami kiyamo mona, kopa olu onamo mona, neta ugele olamo mona, ofo folamo mona, kume-ugele namo mona, ");
INSERT INTO snp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ko lalo-talo melamo mona, wenena koli nosámami o gedamo mona, koni wiyamo mona, mona nosámami meleto wenena olu ukanido koli gedenami mona, netaninamu koliti seni-muluni nosámami mele gedamo mona, kamani kiyamo mona, ukani-luni oto diti kolamo mona, ka maninigu minámami mona, ");
INSERT INTO snp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","monawa nosámami-asámami muki ya oudi-luti-katigu yauti oto olu ladi o gede-gede iye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ena Yesu ya ebawa ya fulito uto eba ma Taiya numuna adu nedo ya u fedeto numugu dito, ya momona oto minenae, loto kolaifa, ido yalo u falukunami ya ogoufámami ne. ");
INSERT INTO snp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Etito nenako, wena ma olulafo kefola ya Satani kimiwela siya-mulunau mino edami ya wenawa Yesu kala kolito ayalo oto kiyanalo kiyana umola fiyaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kiyana umola fiyami wenawa ya ailo feka wena minoto Fonisia ebalo Silia mikalo oloto piyami wena yakafo eti loumami, Olunefo Satani kimiwela siya-mulunau mino edami ya olu fulo edeto ilifi melo, loto wako loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Etito wako loumaito, ya eti loumami, Nomilipa weni-neta oluti kula minagu fulamo ya efe ádaiye. Nomilipa komu nenawamo ne, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Eti loumaifa, ido itibito loumami, Wenabao, ona laba, ido nomilipa weni-neta no minato, lana mikalo olumo wiyami ya kula yate no-no ae, lito, ");
INSERT INTO snp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","eti loumami, Etito itibito lonomanimo yamu numugaleka itibito wageto olukafo Satani kimiwela ya fulo edeto utaiye, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Loumaito, numunaleka itibito uto ya olulafo folomolo ono minami eyami Satani kimiwela moda fulo edeito utaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ena Yesu Taiya eba ya fuloto uto Saidoni numudo fedeto, yaloti u Galili nofudo uto Dekapolisi ebalo fedaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Fedaito, ya we ma kala melami wela keina imoma ilimiti Yesu nedo oti, Agakafo ya ukanalo olo, loti wako loumato, ");
INSERT INTO snp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","amokafo wenena mau minadoti ilimito fele uto ya ana ilekiya kalau meleto ya ketufu oto we wela kuluma oluto, ");
INSERT INTO snp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kosinaleka koto mulunauti aku loto eti limo, Efata, loto limo ya monawa, Kaka ya olu godo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Loumaito, ya ayalo ya wewa kala ya moda olu godito, wela kulumama kotito, ka efe loto liye. ");
INSERT INTO snp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ka efe loto lito, Yesukafo logimami, Linate netawa yamu wenena ma logimámalo, loto lo fuko gedaifa, amote auma witi logimimo wato, ");
INSERT INTO snp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","wenena koliti weni lawa apaitaito eti lamo, Amo ya neta-mata muki ya laloko olufe liye. Kani melami wenena olu kani ki godoto, ido weni kuluma keina imo wenena olu efe lo gedaito, ka efe loti lae, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kamena yalo wenena naba kofa mau wi minato, weni-neta minámaito, Yesukafo ege moinamo we luni fiyaito ato eti logimami, ");
INSERT INTO snp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Wenena mau naba minamo ya fo kamena lelei-lawokoi (3) yalo ya namoki umalo minamo ya nenawamo neta minámainako, sene-muluneu miluma koli gimowe. ");
INSERT INTO snp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ido maleka ya faigakati amo ya numunidoka kadunamu folado ya gilifi melenamo ya kanudo lumu fou lenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Logimaito, ege moinamo wewa itibiti loumamo, Eba ama fafato ya nenako, beleti naba ma egalekati oluto gimogeto ogofuti nenawamo ne? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Loga o edato, itibito logimami, Beleti nenaki oluti ae? logimaito eti lamo, Seweni (7) ya ne, loumae. ");
INSERT INTO snp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Loumato, amokafo wenena muki mikalo amedoti minalo, logimito ya beleti seweni (7) ya oluto, siyane, lalole, loumuto leketo ege moinamo we wenena muki ya gimalo, loto gimaito eti ae. ");
INSERT INTO snp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ido laefa kefola maki nemo yamu siyane, lalole, loumuto ege moinamo we gimito, ya laefa yaki gimalo, logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Logimaito, gimato, muki noti muni ito ya aiga ege moinamo we ya luma nemo ya olu mau wiyamo owo ma kedikoko naba seweni (7) ya owo koilamo ya faitiye. ");
INSERT INTO snp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ido wemomo fo tauseni (4,000) ya yalo minae. Ido wenenawa ya gilifi meleito ");
INSERT INTO snp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ya Yesuki ege-ege moinamo weki sipiku diti ya Dalimanuta ebalo wae. ");
INSERT INTO snp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ido Falisi we ya Yesudoka oti moila fiti kepa mele umunuwe, loti ya eti loumamo, Kosinalo mebe-maba ma lilibageto kenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eti lato, amokafo siya-mulunau keina imo yauti aku loto eti logimami, Kamena oiya ama minamo wenena ya nediti Goti aumala lilibami mebe-maba ma oloto pi lomageto eyenune, loti lae? Ka ona logimowe. Goti aumala gilibami mebe-maba ma ya olu oloto pi gedámenamo ne, loto logimito, ");
INSERT INTO snp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","fulo gedeito sipiku itibito dito nofuna wela filigaleka wiye. ");
INSERT INTO snp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ege moinamo we ya beleti kani melaito otámato ya beleti lawoko mako sipiku amo minagu ne. ");
INSERT INTO snp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ido Yesukafo fuka ka logimami, Koti moinalo. Falisi we yisininaki, ido Helotiki yisilaki olu kopa o ledetenaiye, loti kofe loti moinalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eti logimami kawa yamu inanimonigu lokoli-fakoli oti eti lamo, Beleti oto ámoninako, yamu eti liye, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka lamo ya Yesu kolitoto eti limo, Nediti beleti otámamo yamu lokoli-fakoli o minae? Onema yaki ya koti kolife loti kolámafe? Ido seti-muludi gedife? ");
INSERT INTO snp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Omudi nemo yamo ágafe? Ido kati nemo yamo kolámafe? Komu neta omo yama ya kati melaife? ");
INSERT INTO snp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Beleti faifu (5) ya oluto wenena faifu tauseni (5,000) ya gimoneto luma nemo oluti owo kedikoko nenaki ya koilamo ne? loto loga o gedaito, itibiti loumamo, Lamo tuwelu (12) ya koilonimo ne, lato, ");
INSERT INTO snp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","eti logimami, Ido beleti seweni (7) ya oluto wenena muki fo tauseni (4,000) gimoneto luma nemo oluti owo kedikoko nenaki ya koilamo ne? loto loga o gedaito, itibiti loumamo, Lamo seweni (7) ya koilonimo ne, lato, ");
INSERT INTO snp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","eti logimami, Oiya yaki kolife loti kolámafe? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ena u Betesaida numudo fedato wenena mate omuna likami we ma ilimiti Yesu nedo oti ya agakafo ukanalo olo, loti wako loumato, ");
INSERT INTO snp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","amokafo omuna likami we analo oluto numunidoti ilimito uto ya omunalo ketufu oto anakafo ukanalo oluto eti loumami, Neta ma kabe? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ko faka loto eti loumami, Namo wenena geyofa, ido yá kanu moinamo yaidana kelae, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu anakafo kofa omunalo olaito, omuna falatito neta-mata muki eyefe loto kaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Efe loto kaito, aimola numunaleka ilifi meleto loumami, Numuna meya yau idámo, loto lo fuko edaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ena Yesuki ege moinamo weki eba naba kuliya Sisalia Filipaika uti numuna meya adu nemo ya wado kanudo ya eti limo, Wenena ya namomu ya kema minaiye, loti lo minae? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","itibiti loumamo, Wenena maleka yate, Yoni noku wi gede-gede imo wema ya minane, loti lo minae. Ido maleka yate, Elaiya ya minane, loti lo minae. Ido ma yate, Yelemaiya minabemo, ido polofete minagumati we ya minane, loti lo minae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eti lato, amokafo limo, Ido linate ya namo ya kema ne, loti lo minae? loto loga o gedaito, Pitakafo itibito loumami, Kamo ya Goti ilifi melami we Kilisto ya minane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ido kawa ya wenena logimámalo, loto ka auma wito lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ido amokafo api gilibito eti limo, We Kula namo ya keina naba-naba kolinagolowe. Ido Yuda wenena kiyabani we yaki yokila ki umamo we kiyabani we yaki ido lo melami ka api gilibi-gilibi amo we yalekate meni numunagilae. Numuti nofo folato, ya fo kamena tili (3) wageto, kofa nedinagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kawa ya oloto lito, Pitakafo ilimito anawaleka uto apito oudaifa, ");
INSERT INTO snp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ido Yesu ya eleyapa wito ege moinamo we geyeto Pita oduto eti loumami, Sataniyo, negeka wo. Kamo Goti kala kiyami yaidana oto kaka kiyámanimo faifa mikaleka wenena kani kiyamo yaidana oto kaka kiyane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ena Yesu mau minamo wenena ido ege moinamo we yaki, Namo minodo ya alo, loto luni fito eti logimami, Ma nege melenune, loti lenawamo ya linanimomuko kolamo ka ya fuliti kamena-kamena nege meleto fulunune, loti lenawamo ya yá yofonina mofuti ya nege-nege melenawae. ");
INSERT INTO snp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yamu makafo aimola ukana atuwa yamuko koli minoto fulunami we ya u kopa unagoliye. Ido makafo namomu ido kawa kuwa lalo yamu kolito monimo uto omuna kofawa minami monala ya fulito fulunami wewa ya omuna kofawa minomo dinagoliye. ");
INSERT INTO snp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kolafe? Makafo ya mikaleka neta-mata muki ya ko noto monimo wifa, ido aimola u kopa unami we ya egaidana oti ko nami netala-matala olu lalo o edenami ne? ");
INSERT INTO snp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ido moda fulutenami ya nena netakafo ouna meina fito itibito olunaiye? ");
INSERT INTO snp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ido kamena oiya ama minamo wenena ya mona nosámami meleti Gotidoka ekelámamo kamena negu mate namomu ido ka lomo yamu koliti ukanido kolinawamo wenena ya namo We Kula ya enisole felegaga yaki lakoina o Menefo lamenala yau fedenamo kamenalo ya wenenawa yamu kolito ayaidana oto ukanelo kolinagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ena Yesukafo eti logimami, Ka ona logimowe. Linate onema amalo nedi minagu yauti maleka folámoti faifa kofawa minamo ya Goti wekudi wenenala aumalakafo kiyaba o gedami kamena ya eyenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aiga fo kamena sikisi (6) utaito, ya Yesukafo Pitale, Yemusile, Yonile gilimito mowa fana-fanalo idaito, fele inanimoniko minato, yalo ya omunido ukana ya u ailo bulaito ");
INSERT INTO snp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ukanalo owo lamena oto u kiyoba ona builami ya wenena ukanido owo kiyoba bulu edamo ya mikalo wenena yate kiyoba yaidana oti bulu edámenagilae. ");
INSERT INTO snp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ido omunido Elaiyate, Mosesete, oloto piyaito Yesuki lokoli-fakoli o minato geyae. ");
INSERT INTO snp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Geyeti, koli naba koliti Pitakafo nediye lenae? loto kala kife ádoto, Yesu eti loumami, Api lilibanimo we, amalo minonimo ya lalo iye. Numuna kolo-kalo lelei-lawokoi ya kuwogeto ma ya kamo numuga minenaiye. Ido ma ya Mosese numuna minenaiye. Ido ma ya Elaiya numuna minenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eti loumaito, ya limu ma moda oloto pito asa wi gedaito, ya limuku yauti nola ma kolamo eti limo, Ama ya sene-mulune umomo Nanefo ya ne. Linate kala ya luti-katigu kolalo, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eti lito, kaita ko fulo yaleka waka afa, ya wenena ma geyámae. Yesukiko lakoina minae. ");
INSERT INTO snp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mowalekati lomado ya Yesukafo auma wito lo fuko gedami, Neta kamo yama wenena logimámalo. Aiga namo We Kula fulunaguti kofa neditoneto kawa ya logiminawae, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lo fuko gedaito, folaiguti kofa nedinami kawa monawa ya inanimoniko minagu yau lokoli-fakoli oti moni wilae. ");
INSERT INTO snp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Moni wiliti eti loti loga o edamo, Elaiya komu enami ne, loti ka mono api gilibamo we yate nediti eti lamo ne? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesukafo itibito logimami, Ona lae. Elaiya ya komu oto neta-mata muki ya olufe lenagoliye. Eti ageto ido mono lufuwa wiyagu yau namo We Kula yamu eti loti lamo, Amo ukana ogofu naba-naba kolaito, ido meni umunawae, loti lamo kawa ya nediye loti lufuwa wiyamo ne? ");
INSERT INTO snp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ka logimowe. Elaiya ya moda otaifa, ido amomu lo melami ka lufuwa wiyamo kamalo meyalo meleti eti edenune, loti netawa-matawa muki seni-mulunigu kolamo ya olu edetama ne, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ena Yesule, Pitale, Yonile, Yemusile itibiti ege-ege moinamo we liliga minadoka oti kamo ya wenena mau naba ogona o gede minato, ido lo melami ka api gilibamo we yaki ege-ege moinamo weki moila fiyamo ya geyae. ");
INSERT INTO snp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Geyato, mau witi minamo wenena muki ya Yesu eyeti elegiti oluloti amo nedo uti aiyo-koiyo loumato, ");
INSERT INTO snp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","amokafo, Moila fiyamo mona ya lonomalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eti logimaito, mau minamo wenena yauti we makafo loumami, Api lilibanimo we, nanefo siya-mulunau Satani kimiwela mino edami yamu ka ádaito ya kamodoka ilimito owe. ");
INSERT INTO snp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ido kamena-kamena Satani kimiwelakafo nanefo oluto fulo mikalo edaito, amo ketufu welauti dito, wela-auma ogofu kiki loto, ukana-akana bubudema mino-mino imo ne. Yamu namokafo kege-kege moinamo we siya-mulunauti ya olu fulo edeti ilifi melalo, loto logimofa, ido ogoufámae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Loumaito, Yesukafo itibito logimami, Aiyo, kamena oiya ama minamo wenena, linate koli kiki ádamo wenena, namo ya linateki kamena nenaki minenae? Ido kamena nenaki keinatina kolinae? Kipawama ilimiti namodo alo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ilimiti ato, Satani kimiwela yakafo Yesu eyeto ayalo ya kipawama olu kulu ofaito mikalo lumu fou loto kululu-kululu monito ya ketufu welauti kala-kala loto idaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesukafo kipawa melafo loga o edami, Kamena nenaki eti iye? lito itibito loumami, Kipa kefola minaidoti eti imo ne. ");
INSERT INTO snp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ido kamena-kamena Satani kimiwela yakafo ofo fulunae, loto nanefo yoku noku olu fulo ede-ede imo ne. Nefa, kamo ogofutoma ya lamo milumate kolito ade olu faka lo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eti loumaito, Yesukafo loumami, Ogofutomae, lanimo ya nedito lane? Wenena koli kikitamo wenena, Neta-mata eti enune, loti kolinawamo ya netawa-matawa ya ogofuti enawamo ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eti lito, ayalo ya kipa melafokafo loumami, Namo koli kikitomo nefa, koli kikine aumala minámaiye. Yamu kamokafo koli kikine ya olu auma wi nedeto ane olu faka lo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ido wenena muki oluloti oti mau wiyamo ya Yesukafo geyeto Satani kimiwela oduto eti loumami, Kamo kipa kala meleto ka ádenaiye, loto eti o edanimo ya ka auma wito lokomowe. Kipa siya-mulunauti feka oto fulo edeito uto kofa itibito ámo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eti loumaito, Satani kimiwelama kai naba meleto kipawa olu kulu naba-naba ofo edeto feka oto fulo edeito wito kipawama kono ukana kelaito ya wenena muki eti lamo, Aiyo, moda fulutaiye, loti lafa, ");
INSERT INTO snp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesukafo analo oluto olu faka lito ya nedi minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu numugu idaito, wenena ma minámado ya ege-ege moinamo we yate eti loti loga o edamo, Olu fulo edeto ilifinumo ya nedito ogoufámone? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","itibito logimami, Netawa yaidana olu fulo edenawamo ya komu Goti loumunawamo yakafoko olu fulo edenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ebawa fuliti Galili mikalo monimo uti Yesukafo ege-ege moinamo we api gilibami yamu wenena minonimo eba ya kolámenawae, loto kolaiye. Kolito eti logimami, We Kula namo ya wenena anido gimato, nofo folato, fo kamena tili (3) wageto fulunaguti ya kofa nedinae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eti logimaifa, kawa monala ya kolife ádoti koliya koliti ya netawa yamu loga o edámae. ");
INSERT INTO snp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uti Kapeneyamu fedeti Yesukafo numugu dito eti loto loga o gedami, Kanu onido ya nena netamu moila fiyae? lito, ");
INSERT INTO snp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kanudo ado ka lamo ya minagu yauti kemakafo u komu meleto kuliya nemo we minenagoliye, loti yamu moila fiyanako, ka kedámae. ");
INSERT INTO snp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ka kedámato Yesu amedoto ege moinamo we tuwelu (12) ya alo, logimaito koliti ato, eti logimami, We makafo namo kuline nemo we minenae, loto lenami we ya komu kuliya lumuto nemo minoto wenena muki kouba-naba o gedenaiye, loto logimito ");
INSERT INTO snp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","nomilipa kefola analo oluto, minagu olu nedi edeto, abusa wito eti logimami, ");
INSERT INTO snp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","We mate ya namo kuline yamu nomilipawa yaidana oto koina wi gedenagilamo we ya namoki koina wi nedenagilae. Ido namo koina wi nedenawamo we ya namoko koina wi nedámenagilae. E’e, nilifi melami we yaki koina wi edenagilae, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ena Yonikafo eti loumami, Api lilibanimo we, we ma kamo kulikalo Satani kimiwela olu fulo gede-gede imo we ya eyonimo nefa, aya wewa ya lamodoka ekelámami yamu lo fuko edone, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Loumaito, Yesukafo limo, Lo fuko edámalo. Makafo ya kulinelo Goti aumala gilibami neta oloto pi giminami we ya alako ka nosámami ogofuto lo nedámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yamu we ma ya kuwotefo builámenami we ya yowote we ne. ");
INSERT INTO snp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka ona logimowe. Linate Goti nilifami we Kilisto nege melanako, we makafo namo kuline yamu nomu oluto no giminami we ya meinala u kopa ámunagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ido we makafo faifa wenena koli kikito nomagu yauti lawoko ma koli kikila ya olu kopaitenami we ya Gotidokati lifima ka naba-naba itibito olunami ne. Ido wenena kifana naba-naba kenebalau nela witi ya no sumitigu yau fulo edamo neko, moda lalo agi ne. ");
INSERT INTO snp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ido agakafo lifima olu komagetoma, aga fuko fulito. Kamo aga dumani nageto omuga kofawa minanimo ya lalo nefa, aga lelewai yaki minoto yo eifámenami yoku unanimo ya nosa naba ámenami ne.  ");
INSERT INTO snp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yalo kinina ya folámato, ido yo yaki eifámenami ne. ");
INSERT INTO snp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ido kiyagakafo lifima olu mofu kedagetoma, kiyaga ya fuko fulito. Kamo keni-keni oto omuga kofawa minanimo ya lalo nefa, kiyaga lelewai yaki minenanimo ya yoku olu fulo kedenawamo ya nosa naba ámenami ne.  ");
INSERT INTO snp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yalo kinina ya folámato, ido yo yaki eifámenami ne. ");
INSERT INTO snp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Ido omugakafo lifima olu mofu kedagetoma, omuga ya olu fulito. Kamo omuga filigako minoto Goti wekudi wenenala kiyaba o gedami kilalau idageto ya lalo nefa, omuga lelewai minenanimo ya yo eifámenami yoku kinina ya folámato, ido yo yaki eifámenami negu ya olu fulo kedenawamo ya nosa naba ámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ido wenena u lalokako unawae, loto nela kuwo kiyamo yaidana oto Goti yamo kaila fi ledami ne. ");
INSERT INTO snp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kuwo ya lalo nefa, kuwo leya folámagaiyama nena netadunu leya fulunami kofa olufe lenune? Ido linate seti-muludigu kuwo amo yaidana oti you amene mona meleti wenenatinaki sodoti lakoina minalo, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ena Yesu ya aya ebawa fulito Yudia mikau uto no naba Yodani kilito filigaleka wiye. Wito wenena mau naba-naba minamo ya amodoka ato, api gilibi-gilibi imo monala meleto ya api gilibaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Api gilibaito, Falisi we mate kepa mele umunune, loti oti eti loti loga o edamo, We makafo olonafo fuko fulitenami we ya lo melami ka fukenaife? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","itibito logimami, Mosesekafo nena ka auma wito lo mele gedaiye? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Loga o gedaito, ya eti loumamo, Mosese ya we makafo olonefo fulitenae, loto lufuwa wito umuto fulito edenamile, loto limo ne, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Loumato, itibito logimami, Linate seti-muludigu gedinako, yamu kawa lufuwa wito logimaifa, ");
INSERT INTO snp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kana adeina akaimati neta-mata apito olu oloto piyami kamenalo ya Gotikafo We wena olu oloto piyami ne, loto ka mono lufuwau (Stt 1:27) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Etito nemoma nenako, Wemomo yate onibo menibo fulo gedeiti olonibodo ekelamo, lele ya ukani ");
INSERT INTO snp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","u lawoko oti minenawaiye, loto ka mono lufuwau (Stt 2:24) ya nemo ne. Etito lele minámoti u lawoko uti minenawami ne. ");
INSERT INTO snp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Etito nemo nenako, Gotikafo moda ekele gedetami ya wenena yate fuko filiga-filiga o gedámalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aiga numugu minoti ya ege-ege moinamo we ya netawa yamu kofa loga o edato, ");
INSERT INTO snp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesukafo itibito logimami, We makafo olonafo fuko fulito uto wena ma olami we ya moda kume-ugele naiye. ");
INSERT INTO snp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ido wena makafo wanafo fuko fulito uto we ma mofu melami wena ya moda kume-ugele naiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ena nomilipa kefola ya Yesu nedo gilimiti ato, ya anakafo atenido melenaiye, loti o minafa, ege-ege moinamo we yate geyeti goudae. ");
INSERT INTO snp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Goudato, Yesukafo koto siya kala-kala lito eti logimami, Nomilipa namodo alo, loti logimalo. Goti wekudi wenenala kiyaba o ledami kilalau ya yaidana wenena ebanina nenako, enawamo kanu ya ku gedámalo. ");
INSERT INTO snp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ka ona logimowe. Wenena ya Goti wekudite kiyaba o ledenaiye, loti kolinawamo wenena ya nomilipawa kefola yaidana oti ya kilalau dinawamo ne, loto logimito, ");
INSERT INTO snp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","nomilipa abusa wito, anakafo atenido oluto Melafo olu lalo o gedo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ena Yesu kanudo unae, loto wido ya we ma oluloto oto kiyanalo kiyana umola fito eti loumami, Api lilibanimo we lalo netao, Namo kofawa minomo dinamo mona olunae, loto kolinamo ya nena mona melenamo ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Loga o edaito, Yesukafo eti loumami, Kamo nedito namo ya we lalo minane, loto lane? Wenena lalo ma minámamo ne. Goti yako lalo ne. ");
INSERT INTO snp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lo melami ka yau eti limo, Wenena gini folámo. Kume-ugele áno. Neta ugele olámo. Ka suki loto wenena kamani kiyámo. Wenena koni wito netani olámo. Okafo mekafo kulini olu faka lo, loto ka mono lufuwau (Kis 20:12-16, Lo 5:16-20) nemo ka ya moda kolitanimo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Loumaito, itibito loumami, Api lilibanimo we, kipa kefola minomo kamenaleka yati kawa muki ya meyalo melemo wowe, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesukafo eyeto siya-muluna umuto loumami, Kamo ya neta lawoko mako eti ámane. Uto netaka-mataka muki ko nanimo ya kifanalo fuloto, kifana oluto, neta ko ánamo wenena iya mele gimo. Eti enanimo ya kosinauka neta-mata ko nenagolane. Ido oto nege melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Loumami kawa kolito koukame naba-naba ko nami nenako, kola-wela kifufu wito siya-muluna keina ito ya wiye. ");
INSERT INTO snp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wito, ya Yesukafo eleyapa wito ege moinamo we eti loto logimami, Koukame naba-naba ko namo we ya Goti wekudi wenenala kiyaba o ledami kilalau dinune, loti kolinawamo ya koiya naba-naba finawamo ne, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","kawa limo koliti elegiyafa, Yesu kofa ya limo, Nomilipao, makafo ya Goti wekudi wenenala kiyaba o ledami kilalau dinae, loto kolinami ya koiya naba-naba finami ne. ");
INSERT INTO snp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ido yafo-kameli yakafo naka kifiyau dinae, loto koiya naba fiyami yaidana oto koukame naba-naba ko namo we ya Goti kilalau dinune, loti kolinawamo ya oto diti koiya naba-naba finawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Logimami ka koliti eleigiti inanimoni yau lokoli-fakoli amo, Etito nenako, yamu kema wenena olu omuni kenaiye? loti lato, ");
INSERT INTO snp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesukafo geyeto eti limo, Wenena ya ogoufámenagilafa, ido Goti ya ogofunami ne. Neta-mata muki eti enae, loto kolami ya moda ogofu minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Logimaito, Pitakafo eti loumami, Lamo moda neta-mata muki fulitoto kege melonimo ne, loto lito, ");
INSERT INTO snp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesukafo itibito loumami, Ka ona logimowe. Wenena mate namoki kane kune laloki yamu koliti numuni ebani, ido yanibo kunanibo gemonani, ido onibo menibo, ido nomilipani, ido mini fulitenawamo wenena ");
INSERT INTO snp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya oiya minamo kamenalo netawa fulitamo mulalo-mulalo diti itibiti olunawamo ne. Numuni ebani, yanibo kunanibo gemonani, onibo menibo, nomilipani, mini olunawafa, ido yako minámaiye. Keina ma yaki kolinawamo ne. Ido kamena aiga o fedenami yalo Goti analoti kofawa minowa-minowa oti minomo dinawamo mona ya olunawae. ");
INSERT INTO snp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Etiti olunawafa, ido wenena mumudi kulinigi we minamo ya kulini ya lumunami ne. Ido kulini lomami wenena ya kulinigi we minenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena Yelusalemuka dinune, loti wado ya Yesu u komu mele gedeto wito ege-ege moinamo we eleigiti kani mumudi kiyato, ido gege melamo wenena ya koli kolae. Ido amokafo ege moinamo we tuwelu (12) ya anawaleka gilimito uto neta-mata o edenawamo yamu ya eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Moda Yelusalemuka idogeto yalo ya kuwonefo-mota yate namo We Kula ya yokila ki umu-umu amo we wenabani ido lo melami ka api gilibi-gilibi amo we anido ya gimato olu kalo mele nedeti nofo fulunawamo ka lo winagilae. Etiti ailo feka wenena anido gimato, ");
INSERT INTO snp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","wenenawa yate kamane kiti ketufu o nedeti ipi nofoti nofo fulunawae. Nofo folato, fo kamena tili (3) ya wageto fulunaguti kofa nedinae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ena Sebedi nalafo Yemusite Yonite Yesu nedo oti eti loumami, Api lilibanimo we, lokumunalimo neta ya olufe lo ledenane, loto koloiye, laito, ");
INSERT INTO snp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","itibito limo, Nena neta olufe lo ledenaiye, loti kolaiye? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Loga o gedaito, itibito loumami, Kamo lamenaka nabaki enanimo kamenalo ya lamo ma fulo aga onaleka ito ido ma aga adowaleka ito ledo, laiye. ");
INSERT INTO snp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Eti laifa, ido Yesukafo eti logimami, Linate ya ka lami monawa ya kolife ádaiye. Namo kaila fi nedamo kapu ya linate yaidana oti ogofuti olunawaife? Ido noku wi gedamo yaidana oti ya keina naba-naba yamo noku wi nedenawamo neta ayaidana oti olu ogofunawaife? lito, ");
INSERT INTO snp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","itibiti lami, Lamo ogoufoiye, loti loumaiye. Loumaito, eti logimami, Namo kaila fi nedamo neta ya linate ayaida olunawaiye. Ido nosámami neta o nedamo yaki linate o gedenawafa, ");
INSERT INTO snp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ido namokafo ma fulo ane onaleka edeto ido ma fulo adowaleka edeto enamo ya ogoufámowe. E’e, ebawa ya wenena olufe lo gedetami ebanina ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Logimaito, ege moinamo we teni (10) ya kawa kolititi seni kala-kala lito, Yemusite, Yonite koli nosámami gimiti goudae. ");
INSERT INTO snp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yamu Yesukafo alo, loto olu mau wi gedeto eti logimami, Ailo feka wenena kiyabani we yate lono olamo ya inanimoni kulini olu faka loti auma witi, eti alo, eti alo, loti ka logimi-gimi ama ne. Ido kiyabani wenaba yaki auma witi logimiti kiyaba o gede-gede amo monanina ya linate koli minama ne. ");
INSERT INTO snp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Koli minafa, ido linategu monawa ya melámalo. We makafo linate yauti kulinei we minenae, loto kolinami we ya linate kouba-naba lonoti ya olaneyo, loto loumowe. ");
INSERT INTO snp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ido we makafo linate yauti wenabani ona minenae, loto kolinami we ya lonotina we minoto muki kouba-naba o gedaneyo, loto loumowe. ");
INSERT INTO snp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ido yako minámaiye. Namo We Kula omo ya kouba-naba o nedenawae, loto ámowe. E’e, namo kouba-naba o gedenae, loto omo ne. Ido lifimani yamu gini fulutenaiye, loto fuluto wenena muki meina fito olu itibito olunae, loto omo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ena o Yeliko fedato, Yesuki ege-ege moinamo weki wenena mau naba yaki numuna meya naba fuliti wato ya Timeusi nalafo Batimeusi omuna likami we ya kanu anawalo amedoto neta wako lo-lo o minoto, ");
INSERT INTO snp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yesu Nasalete numudoti ami we aiye, loti lamo ka kolito apito au naba loto eti limo, Yesuwo, Defiti ufa fiyami we, milumane kolo, loto au loto liye. ");
INSERT INTO snp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eti lito, wenena mukite oduti eti lamo, Ka kedámo, loumafa, oto dito au naba loto limo, Yesuwo, Defiti ufa fiyami we, milumane kolo, lito, ");
INSERT INTO snp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesukafo ka limo kolito nedi minoto eti limo, Wewa ano, loti lula fiyalo, lito omuna likami we ya lula fiti eti loumamo, Alikani aneyo. Luka fiyaiye. Neido, loumato, ");
INSERT INTO snp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","amokafo ukanalo owo moufami ya fiyalo fulito satoto nedito Yesu nedo aiye. ");
INSERT INTO snp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aito, ya Yesukafo loga o edami, Namo ya kamo nedi-nedi o nedenaiye, loto kolane? loumaito ya omuna likami wekafo eti loumami, Api lilibanimo we, omune kenae, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesukafo eti loumami, Kanudo ya wo. Kamo koli kikitanimo yakafo olu faka lo kedetaiye, loto loumaito ayalo ya omuna falatito kanudo uto ege melaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ena oti, Yelusalemu alili meleti Betefage numudo ido Betani numudo Olifi mowalo o fedeti Yesukafo ege-ege moinamo we lele ya gilifi meleto eti logimami, ");
INSERT INTO snp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Numuna meya kami omunido yalo uti dinawaido ya yafo-dogi momola meyalo moinámamo ma nela witamo minenami eyenawami ya nelalo efiliti oluti itibiti namo minodo ailo. ");
INSERT INTO snp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ido we makafo, Linate ya nediti eti aiye? loto loga o gedagetoma, eti loumailo, Wekola lonola ma nenako, ya olutoto alako kofa itibito amalo ilifi melenaiye, loti loumailo, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gilifi melaito, uti yafo-dogi momola ya kanudo nemo numuna kanu welalo nela wiyamo olu oloto piti nela efilaito, ");
INSERT INTO snp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wenena ma yalo amedoti minamote eti lamo, Linate yafo-dogi momola ya nediti efilaiye? loti loga o gedato, ");
INSERT INTO snp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesukafo ka logimami yamaidana oti logimaito koliti, O, ilimiti wailo, lato, ");
INSERT INTO snp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","yafo-dogi Yesu nedo ilimiti uti ya ukanido owo moufami ya meyalo melaito Yesu dito amedoto minaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amedoto minaito, ya wenena muki ukanido owo kanudo melemo wato, ido wenena mate yá akawa miguti fukoti ya kanudo unaido kolaleka melemo wae. ");
INSERT INTO snp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ido komu melamo wenenaki ido egeka melamo wenenaki yate au naba loti eti lamo, Aiyo, siyane, hosana! Wekola kuliyalo ami we ya lalo kolimo wimo ne. ");
INSERT INTO snp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Autefo-kolofate Defitikafo wenenala kiyaba lalo o gedami monala yaidana oto wewa yakafo kiyaba lalo o ledenami mona ya lalo kolimo unumo mona ya ne. Yoiyau kosinau minamo yaki ayaidana oti, Aiyo, siyane, hosana, loti lo-lo ae, loti ya au loti lomo wae. ");
INSERT INTO snp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ena Yesukafo Yelusalemu dito uto felegaga kuliyai numuna nabau dito neta-mata muki ya ko fuli lito ya moda sinidenagolito amoki ido ege moinamo we tuwelu (12) yaki itibiti Betanika u fedae. ");
INSERT INTO snp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Leda Betanika fuloti wado kanudo Yesu kadunamu fuluto ");
INSERT INTO snp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ya yá ade ma aila wiyami faiga nemo ya eyeto uto ilawa liyami ya moni wilinae, loto yá nedo wifa, ilawa liyami kamena minámainako, ilawa liyami olu oloto piyámoto yá ailako eyaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yá ailako eyeto, yá eti loto loumami, Ilawaka ya wenena ma kofa ánenawae, loto loumaiye. Kawa ya loumami ege-ege moinamo we ya kolae. ");
INSERT INTO snp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu ya Yelusalemu o fedeto felegaga kuliyai numuna naba kilalau ya dito neta meina fiyamo wenenaki neta kifanalo fulamo wenenaki ya apito giyado feka iye. Ido kifana kola ailo-ailo nemo ya olu filiga-filiga amo wenena folomoniki, ido wenena nema mulu meinalo fulamo wenena lono folomoni yaki olu eleyapa wito fululu kiyaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Fululu kito, wenena neta-mata oluti felegaga kuliyai numuna naba kilalau diti lumuti amo wenena ya eti ámalo, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lo fuko gedeto api gilibito eti logimami, Gotikafo eti limo, Numune ya wenena mikau-mikau ya ka lonumu-numu amo numunale, loti lenawamo ne, loto ka mono lufuwau (Ais 56:7) nemo ka ya ne. Etito nefa, linate olu ugele we numuni yaidana o minae, (Jer 7:11) loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kawa ya logimami yamu wenena muki elegiyato yokila ki umu-umu amo we kiyabani weki, ido lo melami ka api gilibi-gilibi amo weki koliya koliti ofo fulunawamo kanu moni wilae. ");
INSERT INTO snp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ido lunaga sinidenagolito Yesuki ege-ege moinamo weki numuna meya naba ya fuliti wae. ");
INSERT INTO snp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Leda kanudo monimo uti ya yá ade lufawati ailati muki moda meguinami ya eyae. ");
INSERT INTO snp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eyato, Pitakafo kala kito Yesu ya eti loumami, Api lilibanimo we, eyo. Kamo ya yá ade olu kopaitenami ka loumanimo ya moda meguinaiye, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesukafo itibito loumami, Goti ya koli kikito umalo. ");
INSERT INTO snp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ka ona logimowe. Goti koli kikito umunami wekafo mowa ama ya kuwo noku nedito wo, loto kala lele kiyámoto loumunami ya moda ka lomo ya oloto pi nedenaiye, loto kala ki kikitoto kinami ya etito oloto pi edenami ne. ");
INSERT INTO snp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yamu logimowe. Neta ma muki yamu olunune, loti koli kikitoti Goti loumunawamo ya moda olunawae. ");
INSERT INTO snp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ido nedito minoto Goti loumunanimo kamenalo ya we ma mona nosámami ma mele kedami we lifimala ya kilili edo. Eti enanimo ya Mekafo kosinau nemo we yakafo kamo lifimaka yaki ayaidana oto kilili o kedenami ne.  ");
INSERT INTO snp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Etito nefa, we ma lifimala kilili o edámenanimo ya Mekafo kosinau nemo we yakafo lifimaka kilili o kedámenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ido kofa o Yelusalemu fedato, Yesu felegaga kuliyai numuna naba kilalau moni minaito, yokila ki umu-umu amo we kiyabani we ido lo melami ka api gilibi-gilibi amo we ido Yuda wenena kiyabani we ya amo nedo oti ");
INSERT INTO snp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","eti loti loga o edamo, Netawa eti o-o minanimo ya kema welaloti o-o ane? Ido kemakafo eti lokomaito o-o ane? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Loga o edato, Yesukafo itibito logimami, Namo ka ma loga o gedenagolowe. Itibiti lonomatoma kema welaloti netawa o-omo ya logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoni ya kema welaloti wenena noku wi gede-gede iye? Kosinau nemo we welaloti nefe, ido wenena wenidoti nefe? Lonomalo, logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Logimaito, inanimonigu lokoli-fakoli oti eti lamo, Lamo ya kosinau nemo we welaloti ne, loto lenumo ya amokafo, Aiyo, linate nediti koli kikito umámae? loto lolumunagolifa, ");
INSERT INTO snp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ido wenena wenidoti ne, loto lenube? loti kani ligi-ligi kiyamo, ya wenena muki Yoni ya polofete ona ne, loti kolanako, wenena kolini kolae. ");
INSERT INTO snp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yamu itibiti eti loumamo, Ya kolámone, loti loumato, Yesukafo limo, Namo yaki ayaidana oto kema welaloti netawa o-omo ya logimámenagolowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ena Yesukafo kepa ka apito logimami, We makafo mina kila ogona oto fito migu nela waini ilawa kifito kiyanidunu nela ilawa lipinawamo kale ya lito migu kiyaba enawamo numuna kuwaiye. Eti o fuli loito mina lonowa ya kiyaba amo we anido meleito monimo eba faiga ma wiye. ");
INSERT INTO snp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uto, nela waini ilawa lalami kamenalo ya mineuti ilawa lalami ma ya komato oluto itibito ano, loto mina kiyaba amo we minadoka kouba-nabala we ma ilifi melaito wiye. ");
INSERT INTO snp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wifa, ido ana-kiyanalo oluti ofoti neta ma umámoti iyadato itibito aiye. ");
INSERT INTO snp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Itibito aito mina aboga yakafo kouba-nabala we ma ya kofa ilifi melaito wifa, manena ofoti nosámami neta o edae. ");
INSERT INTO snp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Eti o edato, aiga we maki ya ilifi melaito wito wewa ya ofo folae. Ofo folato, we mumudi ya gilifi melaito wafa, maleka ya ginae. Maleka ya gini folae. ");
INSERT INTO snp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Gini folato, ilifi melenami we lawokoko ma nemo ya nalafo siya-muluna umami we ya ne. Nalafowa ya aiga ilifi minado ya meleto eti loto kolami, Nanefo kuliya ya olu faka lenagilae, loto kolito ilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ilifi melami wewa wimo ya mina kiyaba amo we yate eyeti inanimo yau eti lamo, Amo ya Melafokafo netala-matala olu iya ku edami wema ne. Yamu ofo folokele. Melafo fulunami kamenalo ya iya ku edami neta muki olunagolone, loti ");
INSERT INTO snp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ana-kiyanalo oluti ofo fuluti kono ukana ya migu yauti fulo feka itae. ");
INSERT INTO snp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ena waini ilawa mi abogakafo nedi-nedi enaiye? Kolafe? Amokafo mina kiyaba amo wenena minadoka oto gini fuluto migu lono ya ailo wenena anido melenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ido mono lufuwau ya eti limo, Kifana ya numuna kuwamo wenena eye fa netaidana itamo nefa, ido aya kifanawa yama moda numuna lagi kola fiyami ne. ");
INSERT INTO snp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wekola yakafo netawa eti imo ya eyeto elegiyone, loto ka mono lufuwau (Sng 118:22-23) nemo kawa ya katámafe? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Loga o gedaito, amote asa wiyami ka limo ya kolamo, Lamo ya lo ledami yamu nela wi edenune, loti kolafa, wenena mau minamo kolini koliti ya fulo edeti wae. ");
INSERT INTO snp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ena aiga Falisi wenena maki ido Heloti ege melamo wenena maki Yesu ya ka nosámami lenaido ya ligiya loumune, loti amo minaido gilifi melato ");
INSERT INTO snp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","amodoka oti eti loumamo, Api lilibanimo we, lamo kolonimo ya kamo ka onako lo-lo ane, loto kolone. Ido faifa wenenafe, ido kulini nemo wenena ya kolini kolámoto, kaka ligi-ligi kiyámoto Goti kanulalo moninawamo mona ya ona efe loto api lilibi-lilibi minane. Yamu lageto kolinune. Kiyaba we wenaba Sisa kifana takisi umu-umu onimo mona ya Goti omunalo ya efe loto nefe? Etito umu-umu enubemo, ido umámenune? loti lae. ");
INSERT INTO snp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eti lafa, ido Yesukafo monabi lele wiyamo monanina kolitoto ya eti logimami, Nediti kepa mele nomae? Kifana denaliyasi ya nilibato eyenae, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","kifana ma olu umato eyeto loga o gedami, Ouna kifanawalo ya kema ouna ne? Ido lufuwa yaki kema netala ne? loto loga o gedaito, itibiti loumamo, Ya Sisa netala ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eti lato, Yesukafo eti logimami, Etito Sisa netala oluti ya Sisa itibiti umalo. Ido Goti netala oluti ya Goti itibiti umalo, lito, eleigi minae. ");
INSERT INTO snp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ena Sadusi we yate wenena folaguti kofa neidámenagilae, loti lo-lo amo wenena ya Yesu nedoka oti eti loti loga o edamo, ");
INSERT INTO snp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Api lilibanimo we, Mosesekafo mono lufuwau eti loto wiyami, We ma folagetoma, olonafo kofawa minoto nomilipala ma olu oloto piyámainako, folami we kunalafo yakafo wena-kenawa ya oluto yalafodo nomilipa olu oloto pi edenaiye, loto lolomami ne. ");
INSERT INTO snp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ido we ma nalafo seweni (7) minagu yauti komu we yakafo wena olaifa, nomilipala kede melámoto folaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ido folami we kunalafo makafo wenawama olaifa, nomilipala olu oloto piyámoto ayaidana oto folaiye. Folaito, ya aiga kunalafo naba tili (3) yakafo wenawa ayamaidana iye. ");
INSERT INTO snp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Etiti kipawa seweni (7) yama ayaidako oti nomilipa ma kedámoti folato, aiga wenawa yamaki folami ne. ");
INSERT INTO snp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ena yalafo-kunalafo seweni (7) ya wenawa olamo yamu folaguti kofa nedinawamo kamenalo ya kema olonafo minenami ne? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Loga o edato, Yesu itibito logimami, Linate ya mono lufuwau nemo ka yaki ido Goti aumala yaki kolife ádanako, yamu kopa ka lo minae. ");
INSERT INTO snp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wenena folaguti nedinawamo kamenalo ya we wena mofu melámato, we wena anido olu gimámenagilae. E’e, enisole kosinau minamo yaidana oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ido wenena folaguti kofa nedinawamo yamu linate Mosese mono lufuwa wiyaigu ya yá kefolalo yo limo kala lufuwa wiyami ya katámafe? Yalo Gotikafo ka eti loumami, Namo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila minowe, loto ka mono lufuwau (Kis 3:6) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amo ya wenena folamo Gotinina minámaiye. E’e, wenena kofawa minamo wenena Gotinina ne. Linate kopa-napa kani ki minae, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ido lo melami ka api gilibi-gilibi amo we minaguti ma oto moila fiyamo ka kolito Yesu ya ka lalo itibito logimami kala kolito eti loto loga o edami, Lo melami ka muki yauti nena ka ya u komu uto auma wiyami ka ne? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesukafo itibito loumami, Ka ya u komu uto auma wiyami ka etito ne: Isilaeli wenenao, linate ya kolalo. Wekola Gotite ya Wekola lawokoko ne. ");
INSERT INTO snp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Seti-muludi muki, ido oudi muki, ido kati-manidi muki, ya Wekola Gotitina ya umalo, ");
INSERT INTO snp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ido auma wiyami ka naba tu (2) ya etito ne: Kaimokamu kolanimo yamaidana oto wenenaka muki ya seka-muluga gimi-gimi o mino, loto ka mono lufuwau (Lo 6:4-5, Wkp 19:18) nemo kawa lelewa ya ka makafo ya olu fulo edámenami ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Loumaito, ya eti loumami, Api lilibanimo we, ka efe loto lane. Goti ya lawokoko ne. Ido ailo ma minámaiye, loto lanimo ya ka ona lane. ");
INSERT INTO snp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ido kawa lanimo, Seti-muludi muki, ido oudi muki, ido kati-manidi muki ya Wekola Gotitina ya umalo. Ido kaimokamu kolanimo yaidana oto wenena muki seka-muluga gimi-gimi o mino, loto limo kawa yakafo yokila ki umamo neta muki, ido ofo ki umamo neta muki yaki ya olu fulo gedaiye, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eti lito, Yesu ya wewa ka efe loto loumami kala kolito eti loumami, Goti wekudi wenenala kiyaba o ledami kilalau dinawamo kanu ya kamodoka adu melaiye, loto loumaiye. Yaloti ya wenena koliya koliti kofa loga-miga o edámae. ");
INSERT INTO snp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ena Yesukafo felegaga kuliyai numuna naba kilalau ka mono api gilibi minami kamenalo ya eti loto loga o gedami, Lo melami ka api gilibi-gilibi amo we yate Goti ilifi melami we Kilisto ya Defiti nakulafole, loti lo-lo amo ya egaidana oti lo minae? ");
INSERT INTO snp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ouna Felegaga yakafo Defiti mino edeto welau ka melaito, eti limo, Wekola yakafo Wekolane ya loumami, Ane onaleka amedoto kiyaba oto minageto, ya kuwokafo-mota fulo kiyaga feumau gedenagolowe, loto limo ne, loto ka mono lufuwau (Sng 110:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ido Defiti ya aimolakafo loumami, Wekolanele, loto lito ya Kilisto ya egaidana oto Defiti ufa fiyaigu yauti minoto ido Wekolala yaki minaiye? loto liye. Ido wenena mau naba minamo ya kawa ya koliti seni-mulunigu lalo kolae. ");
INSERT INTO snp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesukafo api gilibito eti logimami, Linate ya lo melami ka api gilibi-gilibi amo we yamu koliti koti moinalo. Amo yate ukanido owo fana-fana witi moniti, ido maketilo ya wenena leyeti, aiyo-koiyo lolumunawae, loti koliti, ");
INSERT INTO snp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ido Yuda wenena mono numunigu idamo ya wenena omunido folomo welalo yako minenune, loti koliti, ido weni-neta nenune, loti amo kamena ya folomo welalo komu yaloko minenune, loti koli minae. ");
INSERT INTO snp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ido wena-kena numuni netani-matani fa oluti, ido wenena leyenawae, loti ka fana-fana Goti loumu-umu o minae. Aya wenenawa ya lifima ka naba-naba itibiti olunawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ya felegaga kuliyai numuna nabau kifana-koukame yau fulo-fulo amo ebato adu nedi minoto wenena naba mau minamo yate kifananina fulamo ya geye minaiye. Geye minaito, wenena neta-mata ko namo muki ya kifana naba fulafa, ");
INSERT INTO snp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","wena-kena ma netala minámami ya oto kifana lafa kefola leleko ma fulami ya wani (1) toya yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wenawa fulami ya eyeto ege-ege moinamo we ya alo, logimaito amodoka ato eti logimami, Ka ona logimowe. Wena-kenawa ya netala minámami yakafo kifanala koukameku fulami ya wenena muki kifanani fulamo ya olu afima o gedaiye. ");
INSERT INTO snp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aya wenena ya netani-matani ko nagu yauti fulafa, amo netala minámaigu yauti ya neta kefo efema mino edaido yama moda fulo fuli linako, ya ma minámaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ya felegaga kuliyai numuna naba fulito lomaito ya ege-ege moinamo we yauti makafo eti loumami, Api lilibanimo we, kokae. Kifana naba-nabati ido numuna nabati ya dowa liye, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesukafo itibito limo, Kamo ya numunawa naba kabe? Kifana makafo kifana ma mulalo nemo amaidana oto koitámenagilae. E’e, muki ya itufu fulato, lumu fou lenagoliye, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu Olifi mowalo amedoto minaito felegaga kuliyai numuna naba kolaleka neto Pitale, Yemusile, Yonile, Adulule ya inanimoko amo nedo oti eti loumamo, ");
INSERT INTO snp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Netawa ya nenafeko oloto pinami ne? Ido netawa muki ya moda alitagetoma, ya nena neta fedageto eyenune? Lolomo, loumae. ");
INSERT INTO snp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eti loumato, Yesukafo itibito logimami, Linate ya kote witenawae, loti koti moinalo. ");
INSERT INTO snp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wenena so loti ya oti kuline oluti eti lenawamo, Namo ya nilifi melami wewa ya minowe, loti wenena muki koni winagilae. ");
INSERT INTO snp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ido fina ka, ido lowa ka kolitima, koli gimámaneyo. Netawa oloto pinagolifa, mika kosina fuli lenami kamena ya oiya fedámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ido wenena mika malekaki mikalekati lowa fina fimo wato, ido mikalo wekudi ma wenenalaki, ido ma wenenalaki ya lowa fina fimo unagilae. Ido mikau-mikau mima naba oto, ido kadunamu fulunawamo kamena ya oloto pinami ne. Netawa kolinawamo, ya wenaipa ukani ogofu ito nomilipani kedamo yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Linate ya koti moinalo. Linate ya ani-kiyanido oluti gilimiti uti kanisole wenena anido gimato, ido mono numunigu ipi gininawamo ne. Ido linate nege melamo yamu wenena kiyabani we wenaba ido mikalo wekudi omunido ya olu nedi gedenagilae. Eti o gedato ya namo kane logiminawae. ");
INSERT INTO snp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ido komu kane kune lalo ya wenena mikau-mikau lo oloto giminagilae. ");
INSERT INTO snp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ido ani-kiyanido oluti gilimiti uti olu kalo mele gedenawamo maunigu watoma, linate ya ka egaidana oto itibito logiminumo ne? loti kati ligi-ligi kiyámalo. Aya kamenalo ya linanimo katidoti ádenagilae. E’e, Ouna Felegaga yakafo wetido ka lenawamo melenami kawa ya faifa logimalo. ");
INSERT INTO snp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ido yalafokafo kunalafo ya kuwolafo-mota anido gimageto ofo fulunawamo ne. Ido melafokafo nomilipala ya kuwolafo-mota anido gimageto ofo fulunawamo ne. Ido nomilipani yate onibo menibo meni gimiti kuwonibo-mota anido gimato gini fulunawamo ne. ");
INSERT INTO snp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Linate ya wenenane minanako, wenena muki koli nosámami-asámami giminawafa, koli kiki loti auma witi minomo keinawa fuli lenami kamenalo dinawamo wenena ya olu omuni kenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Namo lufuwa ama wiyomo ka ya linate katenawamo ya kati kife loti monawa kolife loti kolalo, loto logimowe. Yesukafo ka ma enu wito logimami, Ido aiga neta nosámami-asámami muki neta olu kopaitenami neta ya oto Gotikafo, E’e, limo ebalo minenami ya eyeti Yudia mikalo minenawamo wenena ya mowalo koli dinawae. ");
INSERT INTO snp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ido ma numuna obito minenaidoti ya lumuto numunau yauti koukamela olámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ido makafo minau lono olunaidoti ya kofa itibito uto ukanalo owo ya olámenagoliye. ");
INSERT INTO snp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ido aya kamenalo ya aiyo, wenaipa nomilipani mulunigu nemoki, ido wenaipa nomilipanina amina gimi minenawamoki ya keina naba-naba kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ido netawa fedenami ya epe naba lenami kamenalo oloto pitenaiye, loti Goti loumu-umu o minalo. ");
INSERT INTO snp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Netawa oloto piyagetoma, keina naba-naba kolinawamo netawa ya Gotikafo mika kosina olu oloto piyaido akaimati ya keinawa naba-naba yaidana oloto piyámami ne. Ido aiga yaki keinawa yaidana ma oloto piyámenami ne. ");
INSERT INTO snp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ido Wekolakafo kamenawa ya olu lina itámami neko, wenena ma ya minámagi ne. Etito nefa, amokafo wenenala iyaina o gedami yamu kolito kamenawa ya olu lina itami ne. ");
INSERT INTO snp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ido aya kamenawalo ya we makafo lenami, Eyalo. Ilifi melami we Kilisto uma ya ne, loto lenaife, ido, Eyalo. Yowa ne, loto lenami ya koli kikito umámalo. ");
INSERT INTO snp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wenena ma oloto piti suki ka lenawamo, maleka, Namo nilifi melami we Kilisto minowe, lato ido mate, Namo polofete minowe, loti enawamo, ya neta kofawa naba-naba ailo-ailo ido aumani gilibami neta olu oloto pinawamo, ya Goti iyaina o gedami wenenala yaki koni winune, loti ogofunawamo neko ya koni winagi ne. ");
INSERT INTO snp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eti enawamo ya linate koti kiyaba oti moinalo. Netawa-matawa muki aiga enami neta yamu komu oloto piyámami kamenalo ka muki ya moda logimowe. ");
INSERT INTO snp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ena keinawa naba fuli lageto, aya kamenalo ya Fo ya sinidito, ikana lamenala ya fuli lito, ");
INSERT INTO snp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ukulu ya kosinauti olumo wiyageto, kosinalo nemo neta muki ya momoga enagoliye, loto ka mono lufuwau (Ais 13:10, 34:4) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aya kamenalo ya namo We Kula ya aumane lamenane naba-naba mino nedageto kosinalo limuku oneto ya neyenagilae. ");
INSERT INTO snp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Namo enisolene ya gilifi meloneto uti fo idaidoka fo lomaidoka mikau-mikau yauti iyaina o gedomo wenenane ya gilimiti olu mau wi gedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Linate ya yá ade monala yamo neta lilibami ka ya kolife loti kolalo. Yá ade akawa ya lilisawa bu loto nowala minoto aila kofawa wiyaitoma, ayalo fo lenami kamena alili iye, loti kolae. ");
INSERT INTO snp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Etito netawa muki logimomo ya oloto piyageto linate eye minenawamo, kamenawa moda ona adu meletami ne, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ka ona logimowe. Kamena oiya ama minamo wenena maleka folámato ya netawa muki logimomo ya oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kolalo. Mika kosina ya fuli lenagolifa, kane ya minowa-minowa omo dito fuli ádenami ne. ");
INSERT INTO snp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Netawa muki oloto pinagolimo kamenala, ya ma koli minamo wenena ma minámae. Ido kosinalo enisole ya kolámae. Ido Nalafo namo yaki ya kolámowe. E’e, Metefo yako ya koli minaiye. ");
INSERT INTO snp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ido linate yaki kamenawa oloto pinami ya kolámanako, omudi falatoti koti kiyaba oti minalo. ");
INSERT INTO snp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kamenawa oloto pinami ya we ma faiga wimo yaidana oto ne. Wewa numuna fulito uto kouba-nabala we netala-matala kiyaba o edenawamo wenena muki lono gimito ido kanu welalo kiyaba o minenami we ya koto kiyaba oto mino, loumuito wiye. ");
INSERT INTO snp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ido numuna aboga ya nenafeko itibito enaiye? Luwailafe? Luwaila akailafe? Okolofo lenaidofe? Ko lenaidofe? Itibito enamo kamena ya kolife ádanako, yamu koti kiyaba alo. ");
INSERT INTO snp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Namo kaita itibito oto, linate oku ono minenawamo ya olu oloto pitenae, loto, koti kiyaba alo. ");
INSERT INTO snp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ido kawa linate logimomo ya wenena muki ayaidana oto eti loto logimomo, Koti kiyaba alo, loto logimowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ena kamena lele uto, Goti Elita o Gedami foliwaki, ido beleti olufe lagu yisi melámoti faifa kiti no-no amo foliwaki ya o fedenami yokila ki umu-umu amo we kiyabani we ido lo melami ka api gilibi-gilibi amo we yate Yesu nedo momona oti ana-kiyanalo nela witi ofo fulunagili ka loti lo kifafa, ");
INSERT INTO snp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","wenena ya so lanako, fina fitenawae, loti foliwalo ya ofo folámenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ena Yesu ya Betanika numudoka ya komu okola kilami we Saimoni numunau amedoto minoto wela-neta no minaito, wena makafo nomu kifana falake limo nomuku no ladanuwa imo nalitikafo olufe lamo meinala naba nemo ya oluto oto nomuma wela leketo no ya Yesu atelalo leki edaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Leki edaito, wenena minagu yauti mate seni kala-kala lito, inanimoni yau eti lamo, Nowa ladanuwa imo ya nedito fa fulaiye? ");
INSERT INTO snp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Netawa ya kifanalo fulami neko, we ma melege lawoko lono oluti meina olami yaidana oto oluto neta ko ánamo wenena ya gimagi ne, loti auma witi oudae. ");
INSERT INTO snp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Oudato, Yesukafo logimami, Koiti edalo. Nediti ya odu minae? Amo yakafo neta lalo o nedaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kolafe? Neta ko ánamo wenena ya moda linateki kamena-kamena lakoina ekeleti minato, ani olu faka lenune, loti kolinawamo ya faifa ani olu faka lenagilafa, namo ya linateki kamena-kamena lakoina minámenagolo ne. ");
INSERT INTO snp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amokafo ya fulunamo kamena adu melainako, yamu komu no ladanuwa imo ukanelo leikami ya foloneto kale li nedenagilamo yamu ya eti o nedaiye. Eti o nedenami neta ya o nedaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ka ona logimowe. Kane kune lalo mikau-mikau logimimo unawado ya wenawa ama netawa o nedami kala yaki logimimo wato ya amomu koliwa-koliwa minenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ena Yesu ege moinamo we tuwelu (12) ya minaguti Yudasi Isikaliyoti yakafo, Yesu ya kuwolafo-mota anido melenae, loto yokila ki umu-umu amo we kiyabani we minado wiye. ");
INSERT INTO snp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wito, kala koliti alikani naba-naba oti meina kumunune, lo mele umato, Yesu anido giminami kanu ya moni wilimo wiye. ");
INSERT INTO snp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ena foliwa beleti olufe lagu fudenami neta yisi melámoti faifa kiti no-no amo foliwa o fedaito, komu kamenalo ya Elita O Gedami kate meletenaiye, loti sipisipi momola ofo kiti no-no amo ne. Aya kamena ya fedaito ege moinamo we Yesu nedo oti eti loti loga o edamo, Numuna egau Goti Elita O Gedami wete-neta ofo kito olufe lenune? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Loga o edato, ege-ege moinamo we lele ya gilifi meleto eti logimami, Numuna meya nabau dinawaido ya we ma no fi-fi amo masa mofuto enami we ya katula enawami ya ege meleti wailo. ");
INSERT INTO snp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ege uti, numunau idami numuna aboga eti logimailo, Api lilibami wekafo ya nege-nege moinamo weki Gotikafo Elita O Gedami wete-neta nenumo eba ya ega ya ne? loto loga o kedaiye, loti loumailo. ");
INSERT INTO snp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eti loumunawami ya eba naba ma kunu-anu wiliti olufe lotamo eba ya gilibageto, yau wete-neta ofo kiyailo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Logimaito, fulo edeiti uti numuna meya nabau diti Yesu limo netawa yaidana olu oloto piti Goti Elita O Gedami weni-neta ofo kiyaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lunaga fo saipaito, ya Yesuki ege moinamo we tuwelu (12) yaki oti ");
INSERT INTO snp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","amedoti weni-neta noti minoti ya Yesukafo eti logimami, Ka ona logimowe. Linate yauti we makafo namo ya kuwonefo-mota anido giminagoliye. Wewa ya namote wete-neta nomi we ne, lito, ");
INSERT INTO snp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","seni-mulunigu keina naba-naba ito muki eti loumamo, Namofe? Namofe? lato, ");
INSERT INTO snp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","itibito logimami, Nege moinamo we tuwelu (12) minagu yauti lawoko ma lapeku namote beleti fuloto neta oluto nomi we ya ne. ");
INSERT INTO snp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Namo We Kula ya moda fulunamo kanune yamu ka mono lufuwau wiyado ayaloma ya unagolowe. Etito unafa, ido namo We Kulama ya kuwonefo anido giminami we ya aiyo, lifima ka naba-naba itibito olunami ne. Wewa ya olafokafo kedámami neko, lalo minagi ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Weni-neta no minato, Yesukafo beleti ma oluto, siyane, lalole, loto loumutoto, leketo ege-ege moinamo we gimito ya logimami, Olalo. Ukane ya ne, loto, ");
INSERT INTO snp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ido nomu oluto, siyane, lalole, loumutoto ya gimaito, muki ya nomu yauti nae. ");
INSERT INTO snp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nato, amokafo eti limo, Ama ya namo wanune ne. Gotiki olu kutifi gedami ka olu auma wi edami wanune ya wenena mumudi yamu lekinamo ne. ");
INSERT INTO snp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ka ona logimowe. No waini ya kofa ma moda ánoto minomo uto uto Goti wekudi wenenala kiyaba o ledami kilalau linateki no waini kofawa ma kofa nenagolone, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Logimaito, mono nema loititi ya feka uti Olifi mowalo wae. ");
INSERT INTO snp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olifi mowalo idato, Yesukafo limo, Gotikafo eti limo, Namokafo sipisipi kiyaba we ya ofoneto sipisipi ya upatenagilae, loto ka mono lufuwau (Sek 13:7) nemo nenako, linate muki ya fulo nedeiti koli unagilae. ");
INSERT INTO snp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eti enawafa, ido namo fulunaguti nedito ya Galili mikau komu mele gedeto unagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Logimaito, Pitakafo ka itibito limo, Maleka muki ya koli fulo kedeiti watoma, ya namo nanimone ya moda fulo kedámenagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Loumaito, Yesukafo limo, Namo ka ona lokomowe. Onema luwaila okolofo kamena lele nola ádageto, ya kaimoka yakafo kamena lelei-lawokoi ya kuline olu falukunagolane, loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eti lifa, Pitakafo ilulu kuto auma wito loumami, Kofo fulunawamo ya namoki lakoina nofo fulatoma, moda kulika ya olu falukámenagolowe, loto loumaito, ido ege-ege moinamo we muki yaki ayaidanako oti loumae. ");
INSERT INTO snp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ena Yesu ido ege-ege moinamo we ya eba ma kuliya Getesemani oti amokafo eti limo, Amalo amedoti minalo. Namo yolalo uto Menefo loumunagolowe, logimito, ");
INSERT INTO snp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitale, Yemusile, Yonile gilimito uto yaloti apito siya-mulunau keina naba-naba oto nosámaito metolito kolito eti logimami, ");
INSERT INTO snp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sene-muluneu keina naba-naba omo yakafo fulunamoidana imo yamu amalo minoti kiyaba o minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eti loito, kefo ma monimo uto kola-wela mikalo olumo fito, Kanu ma minagaiyama, kamenawa ya olu fulo nedenaiye, loto Goti ya ");
INSERT INTO snp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","eti loumami, Weyano, Menefo, neta-mata muki eti enanimo ya moda ogofuto minane. Miluma kolomo kapu ama ya olu fulo nedenane, loto kolomo nefa, ido namo kolodo mele nedámoto, kaimoka kolinanido ya mele nedo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Loumutoto, ya itibito ege-ege moinamo we minado oto geyaima, oku ono minato ya Pita loumami, Saimoniyo, oku onabe? Namoki kamena lina efema lakoina kiyaba enanimo ya ogoufámabe? ");
INSERT INTO snp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ido neta ma kepa mele lumuto enami neta lamodoka fede lumutenaiye, loti koti kiyaba oti Goti loumutiko minalo. Lutigu eti enune, loti kolafa, ido ukadi aumala ya kefo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eti loito, kofa uto Melafo komu loumami kama moda ayaidana oto kofa loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Loumutoto kofa itibito ami omuni fi-fi ito oku ono minamo ya geyaito itibiti loumunawamo ka ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ena kofa itibito minado oto eti logimami, Faifa minoti oku onoti foli minafe? Modae. Kamenane ya moda o fedainako, namo We Kula ya lifimanina nemo wenena anido moda gimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Neidato, wokele. Kuwonefo-mota anido gimami we ya moda o fedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Eti logimi minaito ya ege-ege moinamo we tuwelu (12) minagu yauti ma Yudasi ya o fedaito ido amoki lakoina amo wenena mau naba minamo anigu ya emi nabati kefati olamo ya o fedae. O fedamo wenenawa ya yokila ki umamo we kiyabani we, ido lo melami ka api gilibamo we, ido Yuda wenena kiyabani we yate, Ilimiti enawae, loti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gilifi melato, kuwolafo-mota anido melami we yakafo komu logimito limo, Wewa ya mudo edenamo ya ne. Ana-kiyanalo oluti nela wi edeti kiyaba o edeti ilimiti walo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eti logimito, ya alako Yesu nedo o fedeto loumami, Api lilibanimo we, loto mudo edaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mudo edaito, Yesu analo olu kiki loti anigu olae. ");
INSERT INTO snp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Anigu olato, wenena adu nedi minagu yauti we makafo emila fana kimelauti ika oto yokila ki umamo kiyabani we wenaba kouba-nabala we kala ya fuko fulitaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Fuko fulitaito, Yesukafo limo, Namomu ya ugele we wenaba ne, loti koliti ya emiti kefati oluti oti nela fi nedenune, loti afe? ");
INSERT INTO snp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kamena-kamena felegaga kuliyai numuna naba kilalau ya wenena api gilibimo wodo yama anelo-kiyanelo oluti nela fi nedámamo ne. Eti o nedámama nefa, ka mono lufuwa wiyamo ka yama u ayalo winaiye, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ege-ege moinamo we muki ya fulo edeiti koli wae. ");
INSERT INTO snp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Koli wato, we kofawe ukanalo lafo-lafoko wiyami ya Yesu ege wito amote analo olato, ");
INSERT INTO snp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lafo-lafola apaso fulito ya apako koli wiye. ");
INSERT INTO snp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ena Yesu ana-kiyanalo olu kiki loti ilimiti yokila ki umu-umu amo we kiyabani we wenaba minaido wato, yalo yokila ki umamo we wenabani muki ido lo melami ka api gilibamo we, ido Yuda wenena kiyabani we ya o fedeti mau witi minae. ");
INSERT INTO snp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mau witi minato, Pita faigato meleto ege uto yokila ki umamo we kiyabani we wenaba numuna kilalau dito yalo kimiweki lakoina amedoti yo labiti minae. ");
INSERT INTO snp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ena yokila ki umamo we kiyabani wemomo, ido Yuda mono kanisole we muki yate Yesu ofo fulunawamo ka olu oloto pinune, lafa, ka ma olu oloto piyámae. ");
INSERT INTO snp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Olu oloto piyámato, muki ya suki ka fi umunawamo ya o fedafa, ka lamo ya u lawoko áumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","U lawoko áumaito, wenena mate nedito suki ka lo edeti eti lamo, ");
INSERT INTO snp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Wewa yakafo eti limo, Felegaga kuliyai numunawa naba anikafo kuwamo ya lukoto fo kamena tili (3) wageto numuna ma wenena yate kuwámamo ya ku fuli lenamo ne, lito ya moda kolonimo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eti lafa, kanina yaki ya u lawoko áumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","U lawoko áumaito, yokila ki umamo we kiyabani we wenaba yakafo omunido nedi minoto Yesu eti loto loga o edami, Kamo ya ka ma itibito ádenabe? Wenenawa kalo mele kedamo ya nena ka lae? loto loga o edaifa, ");
INSERT INTO snp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu ya ka itibito loumámoto minaiye. Loumámoto minaito, yokila ki umamo kiyabani we wenaba yakafo kofa loga o edami, Kamo mino kolimo wimo we Nalafo ya kilifi melami we Kilisto minabe? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesukafo itibito loumami, Namo ya minowe. Ido aiga namo We Kula ya aumafofo limo we ana onaleka amedoto minoto kosinalo limuku o fedoneto neyenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kawa lido ya yokila ki umamo kiyabani we wenabanina aimola ukanalo owo fekalito ya limo, Ake, nedito ka ma moni wilinumo ne? ");
INSERT INTO snp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Moda Metefo kamana oiya kiyami kala ya kolitama ya nenako, yamu linate moda nediye loti kolae? loto loga o gedaito, muki yate, Moda fulunami ne, lae. ");
INSERT INTO snp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eti lato, mate ketufu o edeti lafo-lafokafo omunalo fitoti anidunu ofoti eti loumamo, Polofete ka lolomo, lato, ido kimiwe yate ilimiti uti anidunu ofae. ");
INSERT INTO snp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Netawa eti o edato, Pita ya feka numuna kilalau afumaleka minaito, nomili ma yokila ki umamo kiyabani we wenaba kouba-naba nomilila oto ");
INSERT INTO snp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita yo labito minami ya kogo eyeto eti loumami, Kamo ya Nasaletekati ami we Yesuki minanima ne, lifa, ");
INSERT INTO snp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","amokafo eti limo, E’e, ka lanimo ya kolife loto kolámowe, loumuto uto numuna kanu welalo minaiye. Minaito okolofokafo liye. ");
INSERT INTO snp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yalo minaito, kouba-naba nomiliwa eyeto wenena adu nedi minamo ilulu kuto logimami, Wewa ya auwafo-mota minagu yauti ne, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitakafo kofa, E’e, loumaiye. Loumaito, aiga kefola adu nedi minamo wenena yate eti loumamo, Kamo ya Galili we minaninako, auwafo-mota minagu yauti moda minane, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lato, amokafo auma wito itibito logimami, Wewa yamu ka lamo ya moda eyámowe. Ka ona ádoneto Gotikafo olu kopa o nedenaiye, liye. ");
INSERT INTO snp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kawa lido ayalo ya okolofo kofa kokololo lito ya Pitakafo Yesu ka komu loumami, Okolofo kamena lele nola ádageto kamokafo kamena lelei-lawokoi (3) ya kuline olu falukunagolane, loto loumami ka yamu kolito kufu naba-naba iye. ");
INSERT INTO snp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ena ko lito, yokila ki umamo we kiyabani we muki, ido Isilaeli wenena kiyabani weti, lo melami ka api gilibamo weti, mono kanisole we muki yaki mau witi lokoli-fakoli oti kani olu lawoko meleti Yesu analo nela witi ilimiti uti Pailati analo umae. ");
INSERT INTO snp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Umato, amokafo eti loto loga o edami, Kamo ya Yuda wenena kiyabani we wekudi minabe? lito itibito loumami, O, kamo kaimoka ya moda lane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ido yokila ki umamo we kiyabani we yate muki ka ligiya loumato, ");
INSERT INTO snp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","kofa Pailatikafo loga o edami, Ka ma itibito ádenanimo nefe? Ligiya ka muki lo kedamo ya kolo, loumaifa, ");
INSERT INTO snp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kofa itibito logimámaito, Pailati ya ligi-ligi kala kiyaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ena melegelo-melegelo aya foliwalo ya gamani kiyabani wenabama yakafo mau minamo wenena yate nela we ma kuliya lato, ya efili fulo gede-gede imo mona ya melaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ido aya kamenalo ya nela numugu gamaniki fina fiti wenena gini folamo wenena minagu yauti kaila fi-fi imo we ma kuliya Balabasi ya ne. ");
INSERT INTO snp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ido mau minamo wenena yate Pailati nedo oti eti lamo, Komu mona mele lede-lede animo yamaidana oto kofa mele ledo, lae. ");
INSERT INTO snp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eti lato, amokafo eti loto loga o gedami, Namo ya linate Yuda wenena kiyabati we wekudi ya efili fulo edenaiye, loti kolafe? loto loga o gedami, ");
INSERT INTO snp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yokila ki umamo we kiyabani we ya wenena muki koli umuti lamo koli fulitenagilae, loti kolamo yamu komumu witi anelo melae, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kolaifa, yokila ki umamo we kiyabani we yate mau minamo wenena ile fali senigu wiyato, ya amote eti lamo, E’e, Balabasi ya efili edo, lato ");
INSERT INTO snp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","eti logimami, Ena wewa ya Yuda wenena kiyabani we wekudile, loti kuliya melamo we ya nedi-nedi o edenae? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","itibiti au naba loti eti lamo, Yá yofolo ofo folo, lae. ");
INSERT INTO snp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eti lato, amokafo kofa eti loto logimami, Nediye? Nena mona nosámami ya melamimule? loto loga o gedaifa, lo gedoti ilulu kuti lamo, Yá yofolo ofo folo, loti au naba loti lae. ");
INSERT INTO snp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eti lato, Pailatikafo wenena mau naba ya seni-mulunigu lalo kolinawae, loto Balabasi ya efili fulo gede gimito ido Yesu ya ipi auma witi ofotiti yá yofolo ofo fulunawae, loto kimiwe anido melaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ena kimiwe yate Yesu ilimiti uti Lomu gamani kiyabani we numuna kuliya Pilatoliumu kilalau diti kimiwe muki ya olu mau wi gedeti, ");
INSERT INTO snp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ukanalo owo fana kisi limo ma wi edeti, ido kefani kailakafo kokamu olufe loti atelalo kolouto wi edeti, ");
INSERT INTO snp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","eti loti apiti lula fiyamo, Aiyo, Yuda wenena kiyabani we wekudiyo, siyane, loti ");
INSERT INTO snp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","konofakafo atelalo ofomo uti ketufu o edeti, kiyani umola fiti, suki neta oti koli umae. ");
INSERT INTO snp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Etiti kamana kititi, owo fana kisi limoma wakoti aimola ukanalo owo itibiti wi edeti ya yá yofolo ofenagili ilimiti feka wae. ");
INSERT INTO snp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesu ilimiti wado, ya we ma Alekisadate Lufusite menibo kuliya Saimoni ya Sailinikati we kanudo Yelusalemuka unae, loto aido ya eyeti analo oluti yá yofola ya akikalo moufo, loti auma witi loumato moufaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Moufaito, uti eba ma kuliya Gologota yalo ya fedae. (Kuliya monawa ya ateni aumale, loti melae.) ");
INSERT INTO snp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Fedato, no wainiki ido yá nowala kuliya muluki olu lakoiti nenaiye, loti umafa, ánaito, ");
INSERT INTO snp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","yá yofolo ofae. Ofoti, ukanalo owo yamu noka kedeti iya meleti olae. ");
INSERT INTO snp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ofamo kamena ya naini kiloku (9) ya yá yofolo ofamo ne. ");
INSERT INTO snp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ido kalo mele edamo ka lufuwa wiyami ya, Yuda wenena kiyabani we wekudi ne, loto lufuwa wiyaito melae. ");
INSERT INTO snp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ido kaila fiyami we lele amoki lakoina ginamo ma ya filiga onaleka ido ma ya filiga adowaleka ya yá yofolo ginae.  ");
INSERT INTO snp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ido, Amo ya ka koliti kolámoti amo we yaidana oto minaiye, loti eyamo ne, loto ka mono lufuwau (Ais 53:12) nemo ka yama ayalo ya wiyaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ido wenena uti oti amo yate ka nosámami-asámami auma witi loumuti oni aga-aga wi umuti, eti loumamo, Ake! Kamo felegaga kuliyai numuna naba ya luko fulito fo kamena tili (3) kofa ku fukenamo ne, loto lanimo we ");
INSERT INTO snp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yá yofoloti lumuto kaimoka olu omuga ko, loti loumae. ");
INSERT INTO snp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eti loumato, ido ayaidana oti yokila ki umamo we kiyabani weki, lo melami ka api gilibamo weki inanimonigu kamana kiti eti lamo, Wenena ailo ya olu omuni ko-ko imoma nefa, ido aimola olu omuna kenae, loto ya ogoufámaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ido aya wewa Goti ilifi melami we Kilisto ya Isilaeli wenena kiyabate we wekudima yá yofolo yati lomageto eyetoma, koli kikito umunune, loti lato, ido we amoki lakoina yá yofolo ginamo yaki ka nosámami loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ena folilo 12 kiloku (12) yalomati u lunaga tili kiloku (3) ya mikau-mikau muki ya sinidomo wiye. ");
INSERT INTO snp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ido lunaga tili (3) kiloku yaloma ya Yesukafo au loto limo, Eloi, Eloi, lama sabaktani? loto au loto limo ka monawa ya Gotine, Gotine, nedito fulo nedane? loto au loto liye. ");
INSERT INTO snp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ido adu nedi minamo wenena kawa koliti eti lamo, Kolalo. Elaiya lula fiyaiye, lato ");
INSERT INTO snp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ido we makafo alako oluloto uto neta kuwo nokuti noi yaidana kelami ya oluto no waini ekefa imo yau fito konofa oiyoto pito Yesu nenaiye, loto umuto eti logimami, Oiya koita edalo. Elaiya oto efili edageto lumunaife? Ko minokele, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eti lito, ido Yesukafo au naba loto wela mula fuli lito folaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Folaito, ya ayalo ya felegaga kuliyai numuna naba lulau ya eyetenawae, loti lafo-lafo naba kailamo ya yaleka atelalokati filiga-filiga fekalito waka lomami ne. ");
INSERT INTO snp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ido kimiwe Yesu omunalo nedi minami we yakafo au loto folami monala eyeto eti limo, Wewa ya moda ona Goti Nalafo ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yalo ya wenaipa maki ya faiga minoti neta koti koliti minae. Minagu yau Malia Madala numudoti wenati, ido Yosefete Yemusi lilafote onibo Maliati, ido Salometi ya minae. ");
INSERT INTO snp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Komu Yesu Galilika minami kamenalo ya wenaipawa ya ege meleti kouba-naba o edato, ido wenaipa ma so loti amoki lakoina oti Yelusalemuka fedamo yamaki yalo minae. ");
INSERT INTO snp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ena lunaga sinidenagolito ya Sabati foli alili melaito Yuda wenena Sabati folimu weni-neta ofo ki melenawamo kamenalo nenako, ");
INSERT INTO snp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefe Alimatea numudoti we Yuda wenena kiyabani we kanisole minagu kuliya nemo we aimola ya Goti wekudi wenenala kiyaba o gedami kamenala ya kiyaba o minami wewa yakafo auma wito Pailati nedo uto Yesu kono ukana ya numunabe? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Loga o edaito, Pailatikafo limo, Moda fulutaife? loto kala ligi-ligi kito kimiwe kiyabani we, ano, loto ka fulo edaito kolito aito eti loto loga o edami, Yesu ya moda fulutaife? lito, ");
INSERT INTO snp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","kimiwe kiyabani wekafo itibito loumami, Moda fulutaiye, lito Pailati ya Yesu kono ukana ya olo, loto Yosefe loumaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Loumaito, Yosefe uto lafo-lafo kiyoba ma meina fito uto kono ukana yá yofoloti oluto lafo-lafokafo asa wito oluto uto kifana lulau melaiye. Meleito, kifana fowena naba-naba ma kululu meleto oluto oto oto, kifana lula welalo ma olu itaiye. ");
INSERT INTO snp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Olu itaito, Malia Madalakati wenate, Yosefe lilafo olafo Maliate ya mele edami eba ya eye minaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena Sabati foliwa fuli lito ya Madalakati wena Maliate, Yemusi olafo Malia lilafole, Salomele ya uto Yesu kono ukanalo ya yá nowala fili edenune, loti ladanuwa imo neta meina fiti ");
INSERT INTO snp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","leda Sadeku ko lido ya kifana lulau kono ukana melagu ya unune, loti wae. ");
INSERT INTO snp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Uti kanudo ya inanimoni lokoli-fakoli amo, Kemakafo ade olu faka loto kifana naba kale welalo itamo yama kululu mele ledenaiye? loti lokoli-fakoli oti ");
INSERT INTO snp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ko faka loti kamo ya kifanawa naba-nabama ya kululu utaito eyae. ");
INSERT INTO snp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eyeti kifana lulau yau diti we kofawe ma ukanalo owo kiyoba wito ya anawaleka amedoto minami ya eyeti koli gimaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Koli gimaito wewa yakafo eti logimami, Koli kolámalo. Linate ya Yesu Nasaletekati we yá yofolo ofo folamo ya monila wili minae. Amo ya folaiguti kofa neditami ne. Amau ya minámaito, mele edamo ebau ya kalo. ");
INSERT INTO snp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ala uti ege-ege moinamo we logimiti ido Pita yaki ya eti loumalo, Amo ya komu logimami yaidana oto Galilika komu mele gedaito yalo ya eyenagilae, loti logimalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eti logimaito, wenaipa ukani ololo oti eleigiti kifana lulauti feka uti oluloti wae. Uti koli gimainako, kawa ya wenena logimámae.  ");
INSERT INTO snp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sadeku ko lido Yesu ya folaiguti kofa nedito komu Malia Madala wena Satani kimiwela seweni (7) ya siya-mulunauti olu fulo edeto gilifi melami wenama omunalo oloto pi umaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oloto pi umaito, amokafo uto komu lakoina mino-mino amo wenena seni-mulunigu keina naba-naba ito kufu nema o minado ya uto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Logimaifa, Yesu kofawa minaito Malia ya eyami kala koliti ya koli kikito umámae. ");
INSERT INTO snp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aiga ege melamo we minaguti we lele migu unagili moinaido ya Yesu ailo keleto omunido oloto piyaito, ");
INSERT INTO snp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","eyeti wewa lele ya itibiti muki minado uti logimaifa, kawa yaki logimamo koli kikito gimámae. ");
INSERT INTO snp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aiga ya ege melamo we leweni (11) ya neta no minado, Yesu ya omunido oloto piyaito koli kikito umámoti ido folaiguti neidami eyamo wenena ya logimamo kani ya ilulu kuti koli kikito gimámanako, yamu goudaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Godutoto, eti logimami, Wenena muki mikau-mikau minadoka uti kane kune lalo ya logimi-gimi alo. ");
INSERT INTO snp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wenena ya koli kikito numuti mono noku winawamo wenena ya olu omuni kenami ne. Eti enaifa, wenena koli kikito nomámenawamo wenena ya lifima ka giminami ne. ");
INSERT INTO snp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ido koli kikito numunawamo wenena ya Goti aumala gilibami mebe-maba ya gimageto aya wenenawa ya weneloti Satani kimiwela ya olu fulo gede-gede enawamo ne. Ido luwa-lawa ka kofawa ya lenawamo ne. ");
INSERT INTO snp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ido anikafo koiyofa fa olunawamo ne. Ido lota ya wenena gini fulunami netati ya nenawamo ya olu nosámami o gedámenami ne. Ido anikafo neta kilamo wenena ya ukanido olunawamo ya olu faka lo gedenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ena Wekola Yesu ya kawa logimi fuli loitaito Gotikafo ilimito kosinau idaito yalo Goti ana onaleka amedoto minaiye. ");
INSERT INTO snp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Minaito, ena ege-ege moinamo we ya uti mikau-mikau kawa kuwa lalo lo oloto melemo wato, Wekolakafo ani olu faka loto aumala gimito wenena muki ya kane kune ya ona ne, loti kolinagilae, loto aumala gilibami neta ya olu oloto pito gilibi-gilibi iye. Modae. ");
INSERT INTO snp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Wenabane Tiyofilusiyo, namo lufuwa ama lufuwa wi fulo kedowe. Kato. Lamo minonigu ya neta oloto pi lomami neta ya kana apito oloto piyaido akaimati ya wenena omunikafo eyeti ka monolo kouba-naba lono olamo wenena lo oloto lomamo ka ayawa ya wenena mukite kawa kuwa wife loto lufuwa winune, loti kolamo ya moda kolane. ");
INSERT INTO snp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Eti loto kolaninako, namo moda ayaida oto netawa muki kana apito oloto piyaidoti ya mama oto kolimo idomoma nenako, loto ya kamomu kolito olu efe-efe loto lufuwa wiyomo ya katoto kolito ka mono api kilibamo ya ona kula ne, loto kolife lenane, loto kane kito ya lufuwa ama ya wiyowe. Eyo. ");
INSERT INTO snp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ena Yudia wenena kiyabani we wenaba Heloti kamenalalo yalo Goti yokila ki umamo wenena ma lono kulini naba ya Abiya wenena yauti we ma nemo kuliya Sekalaiya ya olonafo kuliya Elisabeti yaki ya Goti yokila ki umami we wenaba Aloni ufa fiyami yauti wena ne. ");
INSERT INTO snp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Etito minami ya olonafo wanafo lele ya Goti omunalo ya luni-kani laloko oti minoti, Wekola lo melami ka muki ya olu meyalo mele-mele o minaito, lifimani minámaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eti o minaifa, ido Elisabeti ya keni-wena nenako, nomilipanina minámaito, we kilofo wena kilofo melaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ena wewa Sekalaiya yokila ki umamo wenenalaki lono kamenani fedaito, Goti omunalo lono olu minaiye. Lono olu minaito, yokila kiyamo wenenawa yate ki-ki amo monanina olu meyalo meleti, ");
INSERT INTO snp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ido ladanuwa imo kinami we kuliya olu oloto pinune, loto olu mebe-maba oto noka kedogeto kuliya oloto pinami we yamo ya lonowa olunaiye, loti kedamo ya Sekalaiya kuliya oloto piyaiye. Oloto piyaito, ladanuwa imo neta kinae, loto Wekola felegaga kuliyai numuna nabau yau lulau idaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lulau dito ladanuwa imo neta kinami kamena yalo ya wenena muki mau minamo wenena ya feka minoti Goti loumuti minae. ");
INSERT INTO snp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eti o minato, ladanuwa imo neta ki-ki amo folomo onaleka yalo ya Wekola enisolela ma oloto pi umaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Oloto pi umaito Sekalaiyakafo eyeto ukana ololo oto koli naba-naba umaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Koli naba-naba umaito, enisolekafo eti loumami, Sekalaiyao, koli komámaneyo. Goti ka loumanimo ka ya koli minainako, ologafo Elisabeti ya kipa ma kedenagoliye. Kedageto ya kuliya Yonile, loto melo. ");
INSERT INTO snp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ido oloto pinami yamu seka-muluga moda idageto alikani ageto wenena muki alikani naba-naba enagilae. ");
INSERT INTO snp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eti ato, Wekola omunalo wenaba minoto, no wainife ido olu omuni moninami no mafe ya áno, loto lo fuko edo. Amo ya olafo mulunau minenaigu ya Goti Ouna Felegaga mino edeto siya-mulunau faitoto mino edenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Etito minageto yakafo aiga Isilaeli wenena so loti ya itibito olu Wekola Gotinidoka giliminagoliye. ");
INSERT INTO snp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ido Ouna Felegagakafo Elaiya mino edeto olu auma wi edami yaidana oto amo ya mino edageto, Wekola u komu mele edenami we minenagoliye. Wewa ya wenena seni-muluni olu eleyapa wi gedageto nomilipaniki luni-kani lawoko melenagilae. Ido ka koliti kolámoti amo wenena yaki luni oluwe o gedageto ya wenena mona efe limoko melamo yaidana oti ka mono mona ya efe loti mele minenagilae. Etito ya wenena olufe lo gedageto ya moda efe loti minoti Wekola kiyabala o minenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eti loumaito, Sekalaiyakafo ka itibito eti loumami, Egaidana oto ka ona lane, loto kolinae? Namo we kilofo meloneto olonefoki ayaidana oto moda kilofo melainao, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Enisolekafo ka itibito loumami, Namo ya Gebiliyeli, Goti omunalo nedito mino-mino owe. Eti oneto, amo yakafo, Kawa kuwa lalo loumo, loto kamodoka nilifi melaito, lumuto lokomowe. ");
INSERT INTO snp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ya koli mino. Kawa lokomomo kamenala ageto ya moda kulawa enami ne. Nefa, kawa lokomomo ya koli kiki ádanimo yamu oiya amalekati ka ádoto minenagolane. Ka ádoto minageto ya kawa kulawa enami kamenalo ya kofa ka lenagolane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Etiti lo minaito, feka mau minoti Sekalaiya kiyabala minamo wenena yate felegaga kuliyai numuna naba lulau yau kamena fana minaiye, loti kani ligi-ligi ki minae. ");
INSERT INTO snp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eti o minato, aiga lumuto, ka lenami ogoufámaiye. Ka lenami ogoufámoto mebe-maba yako o gimainako, wenenawa ya eti loti kolamo, Felegaga kuliyai numuna nabau yau neta ma oloto pi umaiye, loti kolae. ");
INSERT INTO snp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ena yokila kiyami lono kamenala fuli lito ya aimola numunaleka itibito wiye. ");
INSERT INTO snp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Uto minaito, aiga olonafo Elisabeti nomilipala mulunau nemo ne. Nomilipala mulunau neto ya ikana faifu (5) yalo falukuto minoto eti loto limo, ");
INSERT INTO snp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Namo keni-wena minomo yamu wenena omunido ukanelo koli minofa, oiya ya Wekolakafo neyami kamenalo ya ukanelo kolomo ka ya olu fulo nedenae, loto ya eti o nedami ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ena ikanala sikisi (6) yalo ya Gotikafo enisolela Gebiliyeli ilifi melaito, Galili mikalo Nasalete numudo wiye. ");
INSERT INTO snp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Uto yalo ya nomili we olámamo nomili kuliya Malia ya adeina wekudi Defiti ufa fiyami we ma kuliya Yosefe ko mele edamo nomili nedo o fedaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Oto oloto pi umuto eti loumami, Siyane, Wekolakafo siya-mulunau lalo naba keyeto mino kedaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eti loto loumaito, ka limo yamu ya siya-mulunau keina naba-naba ito, Nena kama ne? loto kala ligi-ligi kiyaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kala ligi-ligi kiyaito, enisolekafo eti loto loumami, Maliao, koli komámaneyo. Goti siya-mulunau lalo naba keyaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ena ka ma lokumunae. Koli mino. Aiga ya nomilipaka mulugau minageto ya nakafo kedenanimo ya kuliya Yesule, loto melo. ");
INSERT INTO snp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Amo ya kuliyai we minenami ya akaiya nemo we Nalafole, loti lenawamo ne. Ido Wekola Gotikafo aulafo kolofala Defiti kiyaba we lonolama umunagoliye. ");
INSERT INTO snp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ido Yekopu ufa fiyami wenena kiyabani we wekudi minowa-minowa oto minoto kiyaba omo dinami ya ma fuli ádenami ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Loumaito, Maliakafo ka itibito eti loto loumami, Namo we makafo olu ono nedámaito minomoma nenako, ka lanimo ya egaida oto gedenaiye? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Loga o edaito, enisolekafo ka itibito eti loto loumami, Ouna Felegagakafo kamodoka ageto ya akaiya nemo we aumala yakafo kamamuna yaidana oto olu fito kedenagolinako, nomilipaka kedenanimo ya Gotikafo felegagale, loto ido Nanefole, loto lenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ido yako minámaiye. Wenenaka Elisabeti wena kilofo meletami ya keni-wena ne, loti lo edamoma nefa, oiya nalafo mulunau nemo ya ikanala sikisi (6) ya utaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yamu Goti yakafo neta-mata muki eti enami ya moda ogofunami ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eti loto loumaito, Maliakafo ka itibito eti loto loumami, Namo Wekola kouba-nabala nomili minomo ya neyane. Yamu ka lanimo ya eti o nedenaiye, loto lito ya enisolekafo fulo edeito wiye. ");
INSERT INTO snp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ena kamena yalo ya Malia nedito mowalo Yuda wenena numuni meya yalo alako uto ");
INSERT INTO snp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","fedeto Sekalaiya numunau dito ya, Siyane, loto Elisabeti loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eti loto loumaito, Elisabeti kolami kamenalo ayalo ya mulunau nomilipala nemo ya satito, Ouna Felegagakafo Elisabeti siya-mulunau faitoto mino edaito ");
INSERT INTO snp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabetikafo lu aumawai eti loto fiyami, Aiyo, moiyo, wenaipa muki yauti kamo Gotikafo keyeto olu lalo o kedami ne. Ido nomilipaka mulugau nemo kedenanimo yaki olu lalo o edenami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ido Wekolane olafokafo namo minodo animo ya namo faifa wena ma minonako, nedito oto eti o nedane? ");
INSERT INTO snp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yamu kolo. Kamo siyane, loto lonomanimo ya noka lebona kolodo ayalo ya muluneu nomilipane alikani oto satiye. ");
INSERT INTO snp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ido kamo Wekoladokati ka lokomami ka ya kulawa enaiye, loto koli kikito umanimo wena ya moda lalo alikani o-o animo ne, loto Elisabetikafo eti loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ena Maliakafo eti loto limo, Nanimo oune-lune-kane yakafo Wekola kuliya olu faka loto ebola lo minowe. ");
INSERT INTO snp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ido Goti ya olu omune kami we minainako, yamu ouneu ya alikani o-o minowe. ");
INSERT INTO snp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Namo ya fa neta kouba-nabala nomili efema ya minofa, ido neye lalo melainako, yamu oiya amaloti wenena muki kofawa minamoki ido oloto pinawamoki yate namomu koliti ya wenawa lalo koli minomo unami mona ya Gotikafo umaiye, loti lo-lo o nedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Aumafofo aboga yakafo neta naba namodoka olu oloto piyaito, kuliya felegaga nemo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wenena muki kofawa minamoki ido aiga oloto pinawamoki ya wewa koliya kolinawado milumanina koli-koli enami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ido wewa anakafo auma wiyami lono oluto ya wenena ouni-luni-kanigu inanimo kulini olu faka lamo wenena ya olu upato gedaito wamo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kulinigi wenena minoti wenena kiyaba o gedamo we ya kulini olu waka o gedeto, ido kulini minámami wenena efe yako ya kulini olu faka lo gedami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ido kadunamu folamo wenena ya neta lalo gimaito muni ifa, ido neta ko namo wenena ya amodokati gilifi melaito, anigu neta ma olámoti wamo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Isilaeli wenena kouba-nabala wenena minonimo ya ade olu faka loto milumate kolami ya minowa-minowa oto kala melámami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Etito milumate kolito Abalahamu yaki, ufa fiyami wenenala yaki ka lo mele ledami yamu u ayalo wiyami ya minowa-minowa oto nemo ne, loto eti limo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ena ikana lelei-lawokoi (3) yalo Malia ya Elisabetite lakoina minoti aimola numunaleka itibito wiye. ");
INSERT INTO snp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ena Elisabeti kamenala fedaito ya nalafo kedaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nalafo kedaito, adu ekeleti minamo wenena, ido wenenala maleka minamo koliti ya, Aiyo, Wekolakafo milumala naba-naba kolami mona amodoka olu oloto piyaiye, loti amoki alikani naba ae. ");
INSERT INTO snp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ena yaloti fo kamena eiti (8) wito yalo ya kipa ukanau Goti ainala fukenune, loti mau witi melafo Sekalaiya kuliyalo lilafole, loti melenune, loti lafa, ido ");
INSERT INTO snp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","olafokafo limo, E’e, kuliya Yonile, loti melalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Logimaito, amote ka itibiti eti loti loumamo, Aiyo, wenenatina yauti ma kulini yaidana ma minámaima ne, loti ");
INSERT INTO snp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","melafo Sekalaiya ya mebe-maba oti nalafo kuliya melenami yamu loga o edae. ");
INSERT INTO snp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Loga o edato, amokafo lufuwa winami neta numunawae, loto mebe-maba ito oluti umato, Kuliya ya Yonile, loto lufuwa wiyaito ya kani mumudi kiyae. ");
INSERT INTO snp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ido ayalo wela kuluma olu kotito ka loto Goti ebola liye. ");
INSERT INTO snp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ido adu ekeleti minamo wenena muki ya weni lawa apaitaiye. Ido Yudia eba naba mowalo-mowalo yalo netawa yamu lokoli-fakoli omo wae. ");
INSERT INTO snp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eti o minamo ya kawa kolamo wenena muki yate lunigu kolamo ya Wekola aumala mino edamile, loti kolamo yamu eti loti lamo, Kipa yakafo naba dito egaida we minenaiye? loti eti lo minae. ");
INSERT INTO snp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ido melafo Sekalaiya ya Ouna Felegagakafo lulau mino faitito ya Goti welaloti ka eti loto ya limo, ");
INSERT INTO snp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Wekola ya Isilaeli wenena Gotite ebola lokele. Amokafo ya wenenaladoka oto meina fi ledeto nelauti efili ledaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eti o ledeto kouba-nabala we Defiti ufa fiyamila yauti olu omude kenami we auma wiyami we ya olu oloto pi ledami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eti o ledenae, loto aimola kala ya adeinati polofetela felegaga we wenigu ya melaito eti loti lamo, ");
INSERT INTO snp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Goti yakafo olu omudi kenae, loto kuwotefo-mota anigu yauti, ido wenena seni-mulunigu nosámami koli lumunawamo anigu yauti olu omude kenami ne, loti lamo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Etito Gotikafo autefo kolofate-mota ya milumanina kolito, amoki olu kutifi ledami kala felegaga nemo ya kala melámami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gotikafo autefo Abalahamu ya auma wito lo gedimo kawa ya eti limo, ");
INSERT INTO snp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Kuwotibo-mota anidoti olu omudi koneto kolini kolámoti, kuline olu faka loti seti-muludi numuti, mikalo minamo kamenalo yalo mona efe lotiko melenawamo ya felegaga wenena mino-mino enawae, loto lo melami ne. ");
INSERT INTO snp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ido kaimo, nomilipane ya kamomu akaiya nemo we polofetelale, loti lenawamo ne. Kamokafo Wekola moninami kanu ya wili edenae, loto komu melenane. ");
INSERT INTO snp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Komu melenanimo ya Wekola lifimate kilili o ledeto olu omude kenaiye, loto wenenala logimi-gimi enagolane. ");
INSERT INTO snp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Etito Gotite ouna-lula-kalau yau milumate kolami ya fo yaidana oto lamena lumunami we ya kosinalo akaiyati lamodoka ya ilifi melenaiye. ");
INSERT INTO snp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wewa yakafo lamo wenena sinidigu minoto fulunumo kamena yamu koli kolonimo ya lamena o ledeto, you amene mona ya api lilibinaiye, loto ilifi melaiye, loto Sekalaiya limo ne. ");
INSERT INTO snp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ido kipawa naba dito, ouna-lula-kala ya auma wimo idaito, uto kofo mikau yau minomo uto, aiga Isilaeli wenena omunido oloto pi gedami ne. ");
INSERT INTO snp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ena Yoni namuna minami kamena yalo ya Lomu mikalo kiyaba we wekudi Sisa Ogasitusi welaloti ka ma eti loto lo melami, Wenena mikau-mikau minamo Lomu gamanikafo kiyaba imo wenena ya kulini lufuwa wiyalo, loto lo melaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Eti loto lo melami ya Silia ebalo we naba Kuiliniusi yakafo wenena kiyaba o gedami kamenala yalo kulini wiyamo lonowa yaidana komu ma olámamo nefa, ido aya kamenalo yati apiti lonowa oluti kulini wiyamo ne. ");
INSERT INTO snp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kulini wiyato, wenena muki kulite winawae, loti inanimo numuni meya yaloko wae. ");
INSERT INTO snp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wato, Defiti ufa fiyami we ma Yosefe ya ayaida oto Galili ebalo numuna meya Nasalete yalo minami yaloti Yudia ebalo Defiti numunala meya Betelehemu yalo wiye. ");
INSERT INTO snp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uto ya ko mele edamo nomili Malia nomilipala mulunau nemo yaki lakoina kulite winawae, loti waiye. ");
INSERT INTO snp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Uti yalo ya minaito, nomilipala kedenami kamenala fedaito kedaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kedaifa, ido wenena numuna meyalo ya liti linako, numugu eba ma minámaito, kana nalafo kedami ya lafo-lafokafo asa wito bulumakau wela-neta melamo ebau yau ono edaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ido eba ayalo ya wenena ma luwaila yalo yuwa fafato ma sipisipinina kiyaba oti minae. ");
INSERT INTO snp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kiyaba oti minato, Wekola enisolela makafo kaita oloto pi gimaito, Wekola lamenalakafo lamena o gede fulitaito, koli naba-naba gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Koli naba-naba gimaito, enisolemakafo eti loto logimami, Linate koli gimámaneyo. Namo wenena muki lalo koliti alikani naba-naba enawamo neta oloto pi gimami ya kawa kuwa lalo logimowe. ");
INSERT INTO snp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Onema ya Defiti numuna meyalo yalo ya olu omudi kenami we ya linatemu oto kedaiye. Amo ya Gotikafo ilifi melami we Kilisto minoto ya Wekola minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Minami ya eyenawamo mebe-mabala ya etito ne. Kipa namunama lafo-lafokafo asa wiyamo ya bulumakau wela-neta melamo ebau yau ono minenami ya linate eyenawamo ya uti olu oloto pinagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eti loto logimaito, ayalo Goti kosinau kimiwela enisole mau naba-naba oloto piti ya komu ami wema olu ekeleti ya Goti ebola eti loti lamo, ");
INSERT INTO snp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Yoiyau kosinau minamo ya Goti lamena kuliya ya olu faka lomo idae. Ido wenena Goti lalo geyami wenena mikaleka minamo ya you amene mona ya oloto pi gedaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ena enisole yate fulo gedeiti kosinauka idato, sipisipi kiyaba amo we yate eti loti lokoli-fakoli amo, Betelehemu numudo uto ya Wekola welaloti lo oloto lomami neta ya kulawa eyenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eti loti lokoli-fakoli oti alako uti Maliate Yosefete kipa namuna bulumakau wela-neta melamo ebau yau ono minami ya olu oloto pi gedeti ya eye minae. ");
INSERT INTO snp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Geyetiti uti ya kipa kefola kala kuwa yamu logimaito, kawa kolamoma ya lo oloto melemo wae. ");
INSERT INTO snp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lo oloto melato, weniguti kawa kolamo wenena muki koliti, elegiti muluni idaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ido Malia ya netawa muki yamu siya-mulunau ya metolito kolito minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ido sipisipi kiyaba amo we ya lononido itibiti uti, neta-mata muki kolamo neta yamaki, ido eyamo neta yamakimu Goti kuliya olu faka loti ebola lowa-lowa minae. Neta-mata muki logimaidoma ya moda wiyami ne. ");
INSERT INTO snp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ena kipawa oloto pito minaito, fo kamena eiti (8) wito ya ukanau Goti ainala fukenawamo kamenalo ya kuliya Yesule, loti melamo ne. Ya kuliyawa ya komu Malia mulunau nomilipala minámaito enisolekafo loumami kuliya yama melae. ");
INSERT INTO snp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ena Wekola lo melami ka Mosesekafo lufuwa wi melami ka yalo ya olu meyalo meleti olu mo lenawami kamena alitito ya kipawa ilimiti Wekola omunalo olu oloto piti ya yokila ki umunaliye, loti ya Yelusalemuka idaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eti ami ya Wekola lo melami ka lufuwa wiyaigu eti limo, Kana nomilipani nanibo oloto piyatoma, Wekola felegaga we iyaina o edalo, loto ka mono lufuwau (Kis 13:2, 12, 15) nemo ka meyalo meleti eti o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ido ka ma ya etito nemo, Nema mulu lelefemo, ido nema mulu momola lelefe ya oluti uti ofoto kinaiye, loti yokila ki umunami we ya umunawae, loto ka mono lufuwau (Wkp 12:8) nemo ka koliti yaki oluti waiye. ");
INSERT INTO snp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ena Yelusalemuka we ma nemo kuliya Simeyoni ya mona efe limo meleto, mono olu kiki lo minoto, Isilaeli wenena luni-ouni olu you lo gedenami kamena oloto pinaiye, loto kiyaba o minaiye. Eti o minaito ya Ouna Felegaga lulau mino edaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mino edeto ka eti loto lo oloto umami, Kamo folámageto Wekola ilifinami we Kilisto oloto piyageto eyenagolane, loto lo oloto umaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ena Ounakafo ilimito felegaga kuliyai numuna naba kilala yau idaiye. Idaito, kipa namuna Yesu olafote melafote yate ilimiti uti ya Goti lo melami kala yamalo olu meyalo mele edenaliye, loti ayau idaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Idaito Simeyonikafo kipawa namuna oluto abusa wito Goti ebola eti loto limo, ");
INSERT INTO snp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","Wekolao, oiya amaleka ya kamo olu omude kenami we ya wenena mikau-mikau minonimo wenena muki omudelo olu oloto piyanimo ya omune kulakafo eyowe. Eyonako, kouba-nabaka we namo ka lo mele nedeto ya moda meyalo meletaninako, yamu lalo kolito fulunagolowe. ");
INSERT INTO snp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Amokafo ya ailo feka wenena ka ona kula olu oloto pi gedenae, loto luni lamena o gedageto ya amodokati Isilaeli wenenaka kulini ya faka lenaiye, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ido kipawa yamu kawa eti lito ya olafo melafo koliti elegi minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eti o minaito, Simeyonikafo Goti olu lalo o gedenami ne, loto amomu kolito Goti loumaiye. Goti loumutoto ya kipawa olafo Malia eti loto loumami, Ena ka ma lokomowe. Gotikafo eti loto kolami, Kipawa yamo Isilaeli minamo wenena maleka ya olu lumu fou lo gedeto, ido maleka ya olu faka lo gedenaiye. Ido amo ya Goti kolami neta gilibinami we minageto wenena mukite ka nosámami lo edenawamo ne, loto iyaina o edami ne. ");
INSERT INTO snp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Etito iyaina o edami ya wenena muki ka luni-kanigu nemo ka ya olu oloto pinagoliye, loto ya eti o edenami ne. Ido kamo seka-mulugau ya emikafo fukaito ogofu imo yaidana oto miluma nosámami kolinanimo ogofu oloto pi kumunagoliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ena polofete wena ma nemo kuliya Ana ya Aseli ufa fiyaiguti we Fanuweli olulafo ya ne. Ena wenawa ya nomililoti we uto ekeleto minami ya melege seweni (7) yaidana wimo wena wanafo folaito, ");
INSERT INTO snp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wena-kena minomo idami melegela eiti-fo (84) ya olu fulito wena kilofo melaiye. Ena wenawa kilofo yakafo ya felegaga kuliyai numuna nabau yau kamena-kamena yauko minoto, leda lunaga Goti loumutoko minoto, kamena ma wela-neta moi wito minoto Goti loumutoko minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aya kamenalo ya wenawa yakafo olafo melafo minado o fedeto, Goti ebola loumuto, uto Yelusalemu wenena efili gedenami kamena kiyaba o minamo wenena muki ya kipawa yamu logimi-gimi iye. ");
INSERT INTO snp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ena olafote melafote Wekola lo melami ka yama meyalo mele fuli loiti ya itibiti Galili mikalo uti, inanimoni numuni meya Nasalete yalo waiye. ");
INSERT INTO snp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uti yalo minaito kipawama auma wito ka manenau faitito ya Goti nasafilila mino edaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ena melegelo-melegelo Goti Elita O Gedami folilo yalo olafote melafote ya Yelusalemu numudo di-di ami ne. ");
INSERT INTO snp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Eti o-o minaito ya kipawama melegela tuwelu (12) ya olu fulaito, foli monawa meyalo meleti ya idae. ");
INSERT INTO snp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Diti minato, foli kamena fuli lito ya kipa Yesu Yelusalemuka minami ya olafote melafote kolámoti, fulo edeiti itibiti uti uti, ");
INSERT INTO snp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","aiga ya kani kiyami, Lakoina onimo wenena maki moda komu wife? loti kani kiti, uti uti fo kamena lawoko ya olu fuliti kanudo wenenani loga-miga oti monila wilimo waiye. ");
INSERT INTO snp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Monila wilimo waifa, ido olu oloto pi edámoti fuliti kofa Yelusalemuka itibiti monila wilimo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Monila wilimo idaito, fo kamena lelei-lawokoi utaito, felegaga kuliyai numuna nabau yau olu oloto piyaiye. Olu oloto piti eyami ya amokafo mono api gilibamo we minagu yau minoto, ka lamo ya kolito loga-miga o gede minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Etito loga-miga o gedeto, kolife limo kala yaki ido ka itibito logimami kala yaki muki ya kolamo yamu elegiyamo ne. ");
INSERT INTO snp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eti o minato, olafote melafote ya eyeti ouni wito olafokafo eti loto loumami, Nanefo, kamo nedito eti o ledane? Mekafote sete-muludeu ogofu naba-naba kolito monika wili minomi ya ma ágabe? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Loumaito, amokafo ka itibito eti loto logimami, Aiyo, moiyo, linate ya nediti namo monine wilaiye? Namo Menefo numunalo minomo ya efe loto minowe. Yama kolámaife? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ido logimami kawa ya koliti kolife ádami ne. ");
INSERT INTO snp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eti oti amoki lakoina Nasalete numudo itibiti lumuti, yalo ya olafo melafo ka lami ka ya kolito meyalo mele minaiye. Meyalo mele minaito, olafo ya netawa muki yamu siya-mulunau ya metolito kolito minaiye. ");
INSERT INTO snp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ido Yesu ya naba dito, ka manenau mene oto naba nemo ya Gotiki ido wenenaki lakoina eye lalo melemo idamo ne. ");
INSERT INTO snp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ena Lomu wenena mikau-mikau muki kiyabani we wekudi Taibeliyasi Sisa kiyaba omo idami ya melege fifitini (15) utaito kamena yalo ya Pontiusi Pailatikafo ya Yudia mikalo minamo wenena kiyaba o gede minaiye. Ido Helotikafo ya Galili minamo wenena kiyaba o gede minaiye. Ido Heloti yalafo Filipikafo ya Itulia ido Tilakonitisi eba lele ya kiyaba o gede minaiye. Ido Abilene ebalo ya Lisaniyasikafo ya kiyaba o gede minaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gamani kiyabani wewa etiti minomo wato, ido Goti yokila ki umamo we kiyabani we wenabani kulini ya Anasite ido Kaiyafasite ya mono lono olu minami ne. Ido aya kamena yalo ya Sekalaiya nalafo Yoni ya mika kofo mikalo minaito, amodoka Goti kala ya o fedeto mino edami ne. ");
INSERT INTO snp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Etito Yonikafo no naba Yodani amaleka, afulaleka monito ka eti logimami, Linate Gotikafo lifimate kilili o ledenaiye, loti seti-muludi olu eleyapa winawamo ya namo noku wi gedenagolowe, loto lo oloto melaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yamu polofete Aisaiyakafo ka mono lufuwau ya eti limo, Kofo mikau yalo we ya welauti ka auma wito eti loto lo oloto melenami, Wekola moninami kanula ya olufe loti wili edalo. ");
INSERT INTO snp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mowa ebalo kowo muki ya uguniti olu faitalo. Ido mowa naba-naba muki idami lomami ya eba muki lumuto dito imo ya olu litipeko alo. Ido kanu tekae limo ya olufe lalo. Ido kanu nosámami ya olu lalo oti olufe lalo. ");
INSERT INTO snp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eti ato, wenena muki mikau-mikau ya Goti olu omuna kenami mona ya eyenagilae, loto lo minenaiye, loto ka mono lufuwau (Ais 40:3-5) nemo ka yama Yonidoka gedimo ne. ");
INSERT INTO snp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ido wenena mau naba ya mono noku wi ledenami ne, loti Yoni nedo ato, amokafo eti loto logimami, Linate koiyofa nomilipala minamo, ka naba oloto pi lumutenaiye, loti koli koliti walo, loto kemakafo fuka ka logimaito ya ae? ");
INSERT INTO snp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yamu linate luni-kani olu eleyapa wiyamo wenena yaidako mona kula olu oloto piyalo. Ido Abalahamu ufa fiyami wenenama minoninako, Gotikafo lalo leyami ne, loti kolámalo. Yamu namo ka ma logimowe. Gotikafo kifana-afana yakafo Abalahamu nakulafo-mota olufe lenae, lenami faifa olufe lenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ido oiya ama ya luna ya yá monalo melami ne. Yamu yá ma ilawa lalo liyámenami yá muki monalo lufawalo fukoto yoku kinagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Logimaito, wenena mau minamo ya, Aiyo, eti enami nedi-nedi enune? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Loga o edato, amokafo eti loto logimami, Wenena mate ukanido owo lele ko nenawamo ya iya meleti, we ma ukanalo owo ko ánenami ma ya umalo. Ido weti-neta ko nenawamo ya ayaida alo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Logimaito, kifana takisi olu-olu amo we yaki ayaidana oti mono noku wi ledenaiye, loti ya amodoka oti, loga o edeti lamo, Api lilibanimo we, lamo yaki nedi-nedi enune? lato ");
INSERT INTO snp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","itibito eti loto logimami, Wenena kifana takisi etiti melenawae, loto lo melami kalo ya kifana takisi ma mene oti ugele olámalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Logimaito, kimiwe malekaki ayaidana oti ya, Ena lamo yaki nedi-nedi enune? loti loga o edato, eti loto logimami, Linate kifanani ipoti olunune, loti, ido suki-faki ka loti, ligiya-fagiya ka suki neta oti logimámalo. Moda lono meinatina olamo ya moda lalo ne, loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eti loto logimaito, wenena muki koliti neta ma kiyaba o minamo ya Yoni ya Gotidokati ilifi melami we Kilisto nefemo? loti luni-kani ligi-ligi ki minato, ");
INSERT INTO snp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yonikafo ka itibito eti logimami, Nanimone ya no yakafoko noku wi gede-gede ofa, ido we ma aumalakafo olu fulo nedami we ya enami ne. Namo efe ya amo yaidana we ya minámonako, kiyanalo netala olu fulo edenamo ya efe ádenagoliye. Enami wewa ya Ouna Felegaga ido yo yakafo ya noku wi gedenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ido amo ya yuwa witi lilika winami ebala ya efe loto kililito kula ya olu mau wito numugu melenafa, ido moita neta ya yo eifámenami yoku kinagolowe, loto anau ya lilika winami netala olu minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Etito ya api gilibami ka ma muki ya oluto Goti kala kuwa lalo ya wenena lo oloto gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ena Yonikafo wenena kiyaba o gedami wenabani Heloti monala nosa naba ámami yamu oudaiye. Wewa yakafo yalafo olonafo Helotiyasi ya ika oto wena oluto, ido nosámami mona liliga muki yaki o meleto, ");
INSERT INTO snp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ido mulalo mene oto Yoni yaki nela numugu fulo edami ne. ");
INSERT INTO snp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ena (komu nela numugu ámami kamenalo ya) wenena muki Yonidoka wato, mono noku wi gedami kamenalo ya Yesu ayaida oto wito, noku wi edaito, Yesukafo Goti loumu minoto kosina eya lito ");
INSERT INTO snp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ouna Felegagakafo nema mulu yaidana kelami amodoka lomaiye. Lomaito, ya kosinauti nola ma kolamo eti limo, Nanefo sene-mulune komomo we minanimo ya lalo ona keyowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ena Yesu melegela teti (30) yaidana oto olu fuloto ya mono lonola aipaiye. Ido wenena yate melafo Yosefe ya ne, loti kani ki minae. Ido Yosefe melafo Heli ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ido Heli melafo Matati ya ne. Ido Matati melafo Lifai ya ne. Ido Lifai melafo Meliki ya ne. Ido Meliki melafo Yanai ya ne. Ido Yanai melafo Yosefe ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ido Yosefe melafo Matatiasi ya ne. Ido Matatiasi melafo Amosi ya ne. Ido Amosi melafo Nahamu ya ne. Ido Nahamu melafo Esili ya ne. Ido Esili melafo Nagai ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ido Nagai melafo Mati ya ne. Ido Mati melafo Matatiasi ya ne. Ido Matatiasi melafo Semeni ya ne. Ido Semeni melafo Yoseke ya ne. Ido Yoseke melafo Yoda ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ido Yoda melafo Yowanani ya ne. Ido Yowanani melafo Lesa ya ne. Ido Lesa melafo Selubabeli ya ne. Ido Selubabeli melafo Sealitiyeli ya ne. Ido Sealitiyeli melafo Neli ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ido Neli melafo Meliki ya ne. Ido Meliki melafo Adi ya ne. Ido Adi melafo Kosamu ya ne. Ido Kosamu melafo Elimadamu ya ne. Ido Elimadamu melafo Eli ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ido Eli melafo Yosuwa ya ne. Ido Yosuwa melafo Eliyeseli ya ne. Ido Eliyeseli melafo Yolimu ya ne. Ido Yolimu melafo Matati ya ne. Ido Matati melafo Lifai ne. ");
INSERT INTO snp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ido Lifai melafo Simeyoni ya ne. Ido Simeyoni melafo Yuda ya ne. Ido Yuda melafo Yosefe ya ne. Ido Yosefe melafo Yonamu ya ne. Ido Yonamu melafo Eliyakimu ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ido Eliyakimu melafo Melea ya ne. Ido Melea melafo Mena ya ne. Ido Mena melafo Matata ya ne. Ido Matata melafo Natani ya ne. Ido Natani melafo Defiti ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ido Defiti melafo Yesi ya ne. Ido Yesi melafo Obeti ya ne. Ido Obeti melafo Bowasi ya ne. Ido Bowasi melafo Salimoni ya ne. Ido Salimoni melafo Nasoni ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ido Nasoni melafo Aminadapu ya ne. Ido Aminadapu melafo Atimini ya ne. Ido Atimini melafo Alani ya ne. Ido Alani melafo Hesiloni ya ne. Ido Hesiloni melafo Pelesi ya ne. Ido Pelesi melafo Yuda ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ido Yuda melafo Yekopu ya ne. Ido Yekopu melafo Aisaka ya ne. Ido Aisaka melafo Abalahamu ya ne. Ido Abalahamu melafo Tela ya ne. Ido Tela melafo Naholi ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ido Naholi melafo Seluku ya ne. Ido Seluku melafo Leu ya ne. Ido Leu melafo Peleki ya ne. Ido Peleki melafo Ebeli ya ne. Ido Ebeli melafo Sela ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ido Sela melafo Kainani ya ne. Ido Kainani melafo Alipakisati ya ne. Ido Alipakisati melafo Semu ya ne. Ido Semu melafo Nowa ya ne. Ido Nowa melafo Lameki ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ido Lameki melafo Metusela ya ne. Ido Metusela melafo Enoku ya ne. Ido Enoku melafo Yaleti ya ne. Ido Yaleti melafo Mahalaleli ya ne. Ido Mahalaleli melafo Kenani ya ne. ");
INSERT INTO snp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ido Kenani melafo Enosi ya ne. Ido Enosi melafo Seti ya ne. Ido Seti melafo Adamu ya ne. Ido Adamu melafo Goti ya ne. ");
INSERT INTO snp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ena Yesu ya Ouna Felegagakafo lulau mino faito edaito, Yodani no nabaloti itibito Ounakafo ilimito u mika fafato wiye. ");
INSERT INTO snp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uto yalo ya fo kamena foti (40) ya onoto nedito minaito, Satanikafo kepa mele ede-ede o minaiye. Ido aya kamenawa yau ya Yesu wela-neta ánoto minomo idaito, kamenawa ya fuli lito kadunamu folaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kadunamu folaito, Satanikafo eti loto loumami, Ena, kamo Goti Nalafoma minotoma, kifana ama nemo ya loumageto weka-neta fedaneyo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Loumaito, Yesukafo ka itibito eti loto loumami, Wenena mino kolinawamo ya weni-neta nenawamo yako minámaiye, loto ka mono lufuwau (Lo 8:3) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eti loto loumaito ya Satanikafo ilimito dito wenena mikau-mikau kiyabani we wekudi kiyaba o gedamo ebanina muki ya kaita ilibi fuli liye. ");
INSERT INTO snp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ilibi fuli loto ya eti loto loumami, Ena ebawa muki yaki, ido kulini kuni-kani mino gedami yaki ya kamo kumu fuli lenagolowe. Netawa muki numutaito, olutomo ya we ma umunae, loto kolinamo ya fa umunagolowe. ");
INSERT INTO snp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yamu kuline olu faka loto ouga-luka-kaka nomagetoma, netawa muki ya kamo netaka enaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eti loto loumaito, Yesukafo ka itibito eti loto loumami, Ena ka ma eti limo, Wekola Gotitina kuliya olu faka loti oudi-luti-kati umuti, aimolako kouba-naba o edalo, loto ka mono lufuwau (Lo 6:13) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eti loto loumaito, Satanikafo ilimito Yelusalemu uto felegaga kuliyai numuna naba kolalo fulo edeto ya eti loto loumami, Kamo Goti Nalafoma minotoma, umaloti satomo mikalo youma wiyo. ");
INSERT INTO snp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ka mono lufuwau ya eti limo, Kamomu ya enisolela logimageto, kiyaba o kedeti ");
INSERT INTO snp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kiyaga ya kifanakafo kofotenaiye, loti ya ani mulalo olu faka lo kedenagilae, loto ka mono lufuwau (Sng 91:11-12) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eti loto loumaito, Yesukafo ka itibito eti loto loumami, Ena ka ma limo, Wekola Gotitina ya kepa mele umámalo, loto ka mono lufuwau (Lo 6:16) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eti loto loumaito, Satanikafo kepa mele umami ka muki lo fulito ya amodokati uto kamena malole, loto kiyaba o minaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ena Yesu ya Ouna Felegaga aumala mino edaito, Galili mikalo itibito wiye. Itibito uto kala kuwa numudo-namado Galili adu nemo numudo ya u fuli liye. ");
INSERT INTO snp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Etito yalo ya mono numunigu negu-negu ka mono api gilibaito, koliti ebola lo minae. ");
INSERT INTO snp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Etito monimo uto Nasalete numudo aimola kipa kefola minoto u naba idami numudo Sabati foliku mono numugu di-di imo yamaidana idaiye. Dito mono lufuwa kato giminae, loto neidaito, ");
INSERT INTO snp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","polofete Aisaiya lufuwa wiyami lolokuto ya olu umae. Olu umato foladoto ka ma olu oloto piyami kawa ya eti loto nemo, ");
INSERT INTO snp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wekola Ounakafo neta ko ánoti minamo wenena kala kuwa lalo lo oloto gimo, loto mino nedami ne. Mino nedeto ya eti loto lonomami, Uto ya nela wi gedamo wenena ya Nela yauti efili gedageto minenawae, loto etito lo oloto gimo. Ido omuni likami wenena ya Omuni kofa falatageto kenawae, loto lo oloto gimo. Ido kuwonibo-mota yate olu nosámami o gede minamo wenena ya efili gedo. ");
INSERT INTO snp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ido Wekola olu lalo o gedenami kamena ya moda alitiye, loto lo oloto gimo, loto eti loto lonumuto nilifi melami ne, loto ka mono lufuwau (Ais 61:1-2) nemo ka ya kato gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kawa ya katoto lufuwa ya iya fito, kiyaba we olu umuto, amedoto minaiye. Amedoto minaito ya wenena mono numugu minamo wenena muki amodoka kogo eyae. ");
INSERT INTO snp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kogo eyato, ka apito logimami, Mono kawa katomo ama ya onema linate kani kolado ya moda kulawa oloto piyami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eti logimaito, amo yate ka lalo lo edato, welauti ya nasafili ka limo ya lalo koliti muluni idaito, eti loti lo minamo, Aiyo, amo Yosefe nalafo minaife? Olo, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eti lo minato, amokafo eti loto logimami, Linate ya ka ma lo-lo amo ka ya eti loti lonumunawamo, Lusa we, kamo lusa ki gede-gede animo yamaidana oto kaimokamu kiyo. Aumaka Kapeneyamu numudo gilibanimo yamu kolonimo aya aumakawa yama amalo kaimo numugalo yaki lilibageto kenune, loti lonumunagilae. ");
INSERT INTO snp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yamu namo ka ona logimowe. Polofete ya aimola numuna meyalo yako wenenala yate kuliya olu faka ádenagilae. ");
INSERT INTO snp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ido ka ma ona logimowe. Elaiya kamenalalo ya melege tiliki hafuki (3 ½) yalo ko wiyámaito, kadunamu naba-naba mikau-mikau oloto pito fuli loto nemo kamenalo ya Isilaeli mikalo ya wena-kena muki minamo ne. ");
INSERT INTO snp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Etiti minafa, aya wena-kena muki minado Gotikafo Elaiya ilifi melámaiye. E’e, ailo wenena Saidoni mikalo Salefata numudo wena-kena lawoko ma nedoka yako ilifaito wiye. ");
INSERT INTO snp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ena Polofete Elisa nemo kamenalalo ya Isilaeli mikalo ya okola kilamo wenena muki minagu yauti Gotikafo ma kolouto gedámaifa, ailo Silia mikaloti we Namani yako kolouto edaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eti loto logimaito, mono numugu minamo wenena muki koliti ya seni kala-kala naba-naba lito, ");
INSERT INTO snp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ya nediti uti numudo yati ilifi feka itufu-matufu oti, numuna meya mowalo kolalo ilimiti diti, fulo edogeto lumunaiye, loti lowa anawaleka ilimiti wae. ");
INSERT INTO snp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Eti o edafa, amokafo minagu ya felala oto wiye. ");
INSERT INTO snp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ena lumuto Galili mikalo numuna ma Kapeneyamu yalo fedeto, Sabati foliku ya ka mono api gilibi minaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Api gilibami ya ka mono kula abogakafo api gilibainako, koliti elegiyae. ");
INSERT INTO snp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ido mono numugu yau we ma Satani kimiwela ma mino edami we ma nemo yakafo Yesu eyeto, kai naba meleto eti loto limo, ");
INSERT INTO snp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Yae, Nasalete numudoti we Yesuwo, nedi-nedi o ledenagolo ane? Olu kopa o ledenagolo abe? Kamo Gotidokati Felegaga we ya minanimo ya namo keyefe lowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eti lito, Yesukafo eti loto lo fuko edeto limo, Kamo ka kedámoto wewa ya fulo edeto dito wo, lito Satani kimiwela wenena omunido wewa mikalo olu lumu fou lo edeto, siya-mulunauti feka oto wiye. Eti o edeto wewa ukana olu kopa o edámaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ido wenena muki weni lawa apaitaito, lokoli-fakoli oti eti loti lamo, Aiyo, ka ama ya nena kama ne? Amo auma aboga yaidana oto aumala naba nemo wekafo ya Satani kimiwela ya ka logimaito, diti u-u amo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eti lato, aya ebawa yau kala kuwa numudo-namado upatoto wimo ne. ");
INSERT INTO snp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ena Yesu mono numuguti lumuto Saimoni numunau idaito, ayau Saimoni iyabala wena neta kilito ukana kala-kala limo ka ya koliti Yesu loumae. ");
INSERT INTO snp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Loumato, amodoka oto yalo nedi minoto, ya ukana kala-kala limoma lo fuko edaito, ya fulo edeito wito, ayalo ya wenawamakafo nedito weni-neta ofo ki gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ena fo sapinagolito wenena muki wenenanina neta ailo-ailo kilamo ya Yesudoka gilimiti ato, ya muki ukanido anakafo oluto olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eti o gedami yako minámaiye. Wenena maleka seni-mulunigu yauti Satani kimiwela diti kai naba meleti ya, Kamo Goti Nalafo minane, loti lae. Eti lamo, ya amo Goti ilifi melami we Kilisto ne, loti kolamo yamu ya amokafo, Ka kedámalo, loto lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ena ko lito Yesu numudokati lumuto, wenena minámamo eba yalo uto minaiye. Minaito, wenena monila wiliti ya eyeti amodoka oti eti loumamo, Lamo fulo ledeito áumo, loti ika o edae. ");
INSERT INTO snp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ika o edafa, amokafo eti loto logimami, Goti wekudi wenenala kiyaba o ledami kala kuwa lalo ya wenena numudo-namado minamo yaki ya logimo, loto nilifi melainako, uto lo oloto giminagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eti loto Yudia mikalo mono numuni minomo wigu yau monito mono logimimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ena kamena ma ya Yesu Genesalete nofuna anawalo nedi minaito, wenena mau naba ya Goti kala kolinune, loti olu lulau o ede minamo ne. ");
INSERT INTO snp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Olu lulau o ede minato, amo ya sipi lele nofuna anawalo eyaito laefa olu-olu amo we ya sipiku minámoti laefa olu-olu amo owonina noku witi minae. ");
INSERT INTO snp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Minato, amo ya sipi ma, Saimoni sipilau ya dito eti loumami, Sipika ya no akelo nedo yaloti kefoma itufo, loto loumuito ya sipi ayau amedoto ka mono api gilibimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Api gilibimo uto fuli loto Yesu ya Saimoni eti loto loumami, Laefa olunune, loti nofuna muliti uti owotina ya noku fulalo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eti loto loumaito, Saimonikafo itibito loumami, Api lilibanimo weyo, lamo ya moda luwaila lono naba oluto monimo uto melemo woba-woba, ido laefa ya olámonimo ne. Nefa, kamo wekalo kofa melenae, lito uti ");
INSERT INTO snp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ya owonina fuloti laefa ya so loti ika ato, owo fukenae, loto imo ne. ");
INSERT INTO snp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eti o minoti, lono lawoko olamo we ma sipi mau minamo ya, Linate oti ade olu faka lalo, loti ani mebe-maba ato ya lakoina laefa olamo sipi lele faitoto olu afima itenae, loto iye. ");
INSERT INTO snp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eti o minato, Saimoni Pitakafo netawa eyeto ya Yesu kiyanalo kiyana umola fito eti loumami, Aiyo, Wekolao, namo lifima nemo we ma minowe. Fulo nedeto wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Eti loto loumami ya aimolaki ido wenenala lakoina minamo muki yaki laefa muki olamo yamu koliti weni lawa apaitami ne. ");
INSERT INTO snp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Weni lawa apaitami ya Saimoniki lono lawoko olamo we Yemusite Yonite, Sebedi nalafo lele ya ayaida oti weni lawa gediye. Eti o minato, Yesukafo Saimoni eti loto loumami, Kamo koli komámaneyo. Oiya amalekati wenena olu-olu enane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eti lito, amo ya sipi ika ato no akelo wito ya netani-matani muki fuliti Yesu ege wae. ");
INSERT INTO snp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ena kamena ma Yesu ya numuna meya malo ya minaito, we ma okola ukanalo muki kilami we yakafo oto Yesu eyeto ya kola-wela mikau fito eti loto wako lo edami, Wekolao, kamo eti enae, loto kolinanimo ya okola kilomo ya kolouto nedo, loto lageto ukane ya moda koloutenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Loumaito, Yesukafo ana sino loto wewa ukanalo olu minoto loumami, Eti enae. Okola kilanimo kolouto, lito ayalo okola ya fulito edaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eti o edeto ya eti loto lo fuko edami, Kamo kawa ya wenena logimámoto, faifa uto yokila ki umami we ya ukaga ilibageto kenaiye. Koto ya ukaga koloutami yamu Mosesekafo ka lo melamidana oto neta umageto wenena muki yate okola kilanimoma yamu koloutane, loti kolinagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eti loto loumaifa, ido kala kuwa ya numudo-namado ba loto wito, wenena mau naba-naba oti kala koliti neta kilonimo olu faka lo ledenaiye, loti mau witi minae. ");
INSERT INTO snp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mau witi minafa, ido kamena-kamena Yesu ya u mika kofo mikalo uto Goti loumu-umu o minaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ena kamena ma Yesukafo wenena mono logimi minaito Falisi we ido lo melami ka api gilibamo we Galili numudo-namadoti, ido Yudia mikaloti, ido Yelusalemu numudoti muki oti ya wenena minagu amedoti minae. Amedoti minato, Wekola aumalakafo wenena neta kilamo olu faka lo gedami auma ya Yesuki mino edaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mino edaito, ena ipedimo we ma ya wenenalate kunulo meleti, oti ya numugu oluti diti, Yesu kiyanalo olumo fulenune, loti afa, ");
INSERT INTO snp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ido wenena mau minamo yamu oluti dinawamo eba minámaito, numuna mulalo oluti diti menefa ya olu fuloti wewa kunulo ono minami fulato, wenena minagu Yesu omunalo ya lomaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eti amo ya Yesu koli kikito umamo monanina geyeto, wewa eti loto loumami, Wenenane, lifimaka moda kilili otaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eti lito, Goti lo melami ka api gilibamo we ido Falisi we kawa ya koliti eti loti kani kolamo, Aiyo, Goti kamana kiyami we ya kemae? Lifima kilili o-o imo we ya Goti aimolakoma nenako, loti kolae. ");
INSERT INTO snp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Eti loti koli minato, Yesukafo kolito ya ka itibito eti logimami, Linate ya netawa yamu nediti ya seti-muludigu ya kani ligi-ligi ki minae? ");
INSERT INTO snp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ido ipedotoko nemo we, Lifimaka ya kilili otami ne, loto loumunamo linate kulawa ya eyámanako, suki lifemo, ido ona liye, loti kolámenagilae. Ido, Nedito moino, loto loumoneto kulawa eyenawamo, suki lifemo, ido ona liye, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yamu namo We Kula mikaleka ama ya lifimani kilili o gedenamo auma mino nedami ya kolinagilae, loto ipedimo we eti loumami, Namo ka lokomowe. Nedito, kunuka oluto numugaleka wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eti loumaito, wewa ayalo omunido nedito netalo onami neta ya oluto, Goti ebola lomo-lomo numunaleka wiye. ");
INSERT INTO snp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eti ito, wenena muki eyeti kani mumudi kiti koli koliti eti lamo, Onema neta ailo ma oloto piyaito eyone, loti Goti ebola lae. ");
INSERT INTO snp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ena yaloti ya kanu uto, kifana takisi olu-olu imo we ma kuliya Lifai ya kifana takisi olu-olu amo ebalo amedoto minami ya eyeto, Nege ano, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","amo ya nedito netala-matala muki fulito ege wiye. ");
INSERT INTO snp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ege uto, numunauka wela-neta naba-naba ofo ki edeito ya kifana takisi olu-olu amo we muki ido wenena liliga maki olu mau wi gedaito oti lako nae. ");
INSERT INTO snp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lako no minato, Falisi wete ido lo melami ka api gilibi amo we maunigu minamo we yate koli nosámamiti Yesu ege-ege moinamo we eti loti logimamo, Egaidana oti linate takisi olu-olu amo we yaki, ido lifimani nemo we yaki weni-neta no minae? loti loga o gedato, ");
INSERT INTO snp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesukafo kolito ka itibito eti loto limo, Neta kilámamo wenena ya lusa numugu ya ámu-ámu afa, ido neta ona kilamo wenena yako ya lusa numugu ya u-u ae. ");
INSERT INTO snp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ido namo omo ya wenena mona efe limoko melamo wenena ya luni finae, loto ámowe. E’e, lifimanina nemo wenena ya luni fito seti-muludi ya olu eleyapa witi melalo, loto logiminae, loto omo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ena amo yate eti loti loumamo, Yoni ege-ege melamo we ya kamena-kamena weni-neta moi witi minoti, Goti loumamo lono olu-olu o minama ne. Ido Falisi we gege melamo wenena yaki ayaida oti o-o ama ne. Eti o-o ama nefa, ido kamo kege moinamo we ya weni-neta ido nonano no-no o minae, lato, ");
INSERT INTO snp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ya eti loto logimami, We ma wena olunami we ya yowola wenenaki minenami kamenalo ya linate yate wenenawa weni-neta moi witi minalo, loti logiminawafe? ");
INSERT INTO snp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","E’e, etito minámaiye. Aiga amodokati wena olunagolimo wewa ya ipoti olunawamo kamena yalo ya weni-neta moi witi minenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eti logimito, ido kepa ka ma yaki eti loto logimami, We makafo ukanalo owo kofawaloti ma fekalito lilalo kifinami we ma minámaiye. E’e, eti enami ya kofawa ya fekalito, ido lilaki kofawaki u lawoko ámunami ne. ");
INSERT INTO snp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ido makafo no waini kofawa ya meme atuwa lilau yau lekinami we ya minámaiye. E’e, eti enami ya no waini kofawakafo meme atuwa ya foikageto no wainiki, ido meme atuwa yaki lakoina u kopa enagoliye. ");
INSERT INTO snp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yamu ya no waini kofawa ya meme atuwa kofawa yauko lekinawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ido makafo no waini lila nototo ya kofawa nenae, loto kolinami we ya ma minámaiye. E’e, lila ya leya folaiye, loto kolami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ena Sabati foli malo ya yuwa witi kifagu yau uti, ege-ege moinamo we ilawa ma doliti anikafo kululu witi nae. ");
INSERT INTO snp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eti ato, Falisi we mate geyeti ya eti loti lamo, Sabati foliku ya eti ámalo, loto lo fukami neta ya nediti eti ae? lato ");
INSERT INTO snp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ka itibito logimami, Defitiki lawoko moinamo wenenaki kadunamu fuluti neta amo ka ya mono lufuwau yau linate katoti kolámafe? ");
INSERT INTO snp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Defiti ya Goti numunau dito, beleti Goti omunalo mele edamo ya oluto oto beletiwa noto wenenala gimaito, lakoina namoma ne. Beletiwa ya wenena fa wenena ánenawae, loto lo fukamo neta ya Goti yokila ki umamo we inanimo yako no-no amo beleti yama ya Defiti yokila kiyamo we yauti ma minámaifa, oluto nami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eti logimito ka ma enu wi meleto eti limo, We Kula namo ya Sabati foli aboga minowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ena Sabati foli malo mono numugu dito ka mono api gilibi minaido yalo we ma ana onaleka galidimo ya minaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Eti o minaito, Falisi we yaki, ido lo melami ka api gilibamo we yaki ligiya lo edenune, loti ka ma moni wiliti, Sabati foliku yau wewa olu faka lo edenaifemo, ido olu faka lo edámenaiye? loti kogo eye minae. ");
INSERT INTO snp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kogo eye minafa, Yesukafo lunigu ya geye fuli loto ya wewa ana galidimo ya loumami, Kamo wenena omunido ya nedito mino, loto loumaito, amo nedito yalo minaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yalo minaito, Yesukafo eti logimami, Namo ka ma loga o gedenae. Lo melami ka ya Sabati foliku yau olu lalo o gedalo, loto lifemo, ido olu nosámami o gedalo, loto liye? Ido wenena olu omuni kalo, loto lifemo, ido olu kopa o gedalo, loto liye? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eti loto loga o gedeto, olu ogona oto geyeto ya wewa eti loumami, Aga folado, loto lito ya ana foladito kofa lalo iye. ");
INSERT INTO snp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ana kofa lalo ifa, ido amo yate seni kala-kala lito, Yesu olu yaida-amaida o edenune, loti ka lokoli-fakoli ae. ");
INSERT INTO snp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ena kamena malo ya Yesukafo Goti loumunae, loto mowalo idaiye. Dito luwaila ya Goti loumu minaito, ko liye. ");
INSERT INTO snp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko lito ege melamo wenena luni fiyaito, ato minagu yati we tuwelu (12) ya kiyaka oto, kulini naba ya aposolole, loto melaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ido wewa kulini etito ne. Saimoni kuliya kofawa Pitale, loto melami, ido kunalafo Adulu, ido Yemusi ido Yoni, ido Filipi, ido Batolomiu, ");
INSERT INTO snp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ido Matiu, ido Tomasi, ido Alifiusi nalafo Yemusi, ido Saimoni kuliya ma Selotile, loti melamo, ");
INSERT INTO snp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ido Yemusi nalafo Yudasi, ido lilafo Yudasi Isikaliyoti ya Yesu kuwolafo anido melami we ya ne. ");
INSERT INTO snp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuki amoki lakoina lumuti ya lumu ofunalo fedeti yalo ya ege melamo wenena muki ya minae. Minato, wenena mau naba Yudia mikalo numudo-namadoti, ido Yelusalemu numudoti, ido kuwo no anawalo Taiya numudo ido Saidoni numudo eba yaloti ya o-o amo, ");
INSERT INTO snp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","mono lenami ya kolinune, loti, ido neta kilonimo ya olu faka lo ledenaiye, loti ya o-o minae. O-o minato, seni-mulunigu Satani kimiwelate mino gedamo wenena ya olu faka lo gede-gede iye. ");
INSERT INTO snp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ido amodokati aumala ya uto muki olu faka lo gede-gede inako, wenena mau naba muki ya adekafo ukanalo olunune, loti koliti ya ae. ");
INSERT INTO snp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesukafo ko faka loto ege-ege moinamo wenena geyeto eti logimami, Linate neta ko ánamo wenena ya kosinau nemo we wekudi wenenala kiyaba o ledami monala ya moda mino gedaima nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ido linate oiya kadunamu fuluti minamo wenena ya muni enagolinako, yamu moda lalo koli minomo wae. Ido linate kamena amaleka kufu o minamo wenena kiya enawamoma nenako, yamu moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ido linate ya We Kula namo nege melamo yamu wenena mate koli nosámami gimiti, fulo faiga o gedeti, kamani kiti kuliti olu kopaiti enawamo yamu linate moda lalo koli minomo wae. ");
INSERT INTO snp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wenenawa aunibo kolofanige-mota yate polofete ayaida o gedato, linate ya neta yaidana oloto pi gedagetoma, kosinalo lifimatina lalo olu le fito mele gedainako, seti-muludi lalo koliti satoti alikani alo. ");
INSERT INTO snp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Etiti minenagilafa, ido neta ko namo wenenao, aiyo, linate ya olu alikani o gedami netatina ya moda olutanako, aiga keina ka naba-naba kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ido oiya ama neta naba noti muni imo wenenao, aiyo, aiga linate kadunamu fulunagilanako, keina ka naba-naba kolinagilae. Ido oiya amaleka kiya o minamo wenenao, aiyo, aiga linate ya miluma koliti kufu nema enagilanako, keina ka naba-naba kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ido linate ya wenena muki yate gebotina loti kuliti oto diti lalo o gedenawamo yamu aiyo, keina ka naba-naba kolinagilae. Aunibo kolofanige-mota yate ayaidana oti ka suki lamo polofete ya geboni loti, lo lalo gedamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ena ka ma mene oto eti loto logimami, Ena linate kane kolamo wenena ka ma logimowe. Linate kuwotige-mota seti-muludi gimalo. Ido koli nosámami giminawamo wenena ya linate itibiti olu lalo o gedalo. ");
INSERT INTO snp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ido wenena mate olu kopa o gedenune, loti kudawati ki minenawamo wenenamu koliti ya olu lalo o gedo, loti Goti loumalo. Ido olu kopa o gedenawamo wenena ya amomu koliti Goti loumalo. ");
INSERT INTO snp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ena makafo wanega filigaleka kofenami ya filiga yaki nofo, loto wanega ilibo. Ido makafo ukagalo owo mulalo wiyanimo olunami ya ukagalo owo lulau wiyanimo yaki olunae, lenami ya, E’e, loumámo. ");
INSERT INTO snp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ido makafo neta mamu wako lokumunami ya faifa umo. Ido makafo netaka ipoto olunami ya itibito olunae, loto auma wito loumámo. ");
INSERT INTO snp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ido wenena mate etitiko o mele lede-lede enawae, loti kolinawamo ya linate yaki mona ayaidana oti mele gede-gede alo. ");
INSERT INTO snp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Linate ya wenena seni-muluni gimi minamo wenena yako itibiti seti-muludi giminawamo ya egaidana oti meina olunawae? Mono kolámamo wenenaki ya wenenani seni-muluni gimi minamo wenena ya itibiti seni-muluni gimi minamoma ne. ");
INSERT INTO snp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ido linate olu lalo o gede minamo wenena yako itibiti olu lalo o gedenawamo ya egaidana oto Goti ya gebotina lenaiye? Mono kolámamo wenena yate ayaida oti eti o-o minamo ne. ");
INSERT INTO snp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ido olu itibiti giminawamo wenena yako neta lifima olu gimi minenawamo linate ya egaidana oto Goti ya gebotina lenaiye? Mono kolámamo wenena yate wenenanina mono kolámamo wenena ya ayaidana oti muki neta gimonimo olu itibiti lumunawae, loti ya lifima olu gimi-gimi amo ne. ");
INSERT INTO snp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eti o minamoma nefa, ido linate kuwotibo-mota seti-muludi gimiti, mona lalo meleti, ido olu itibiti lifima lomámenawae, loti koliti ya fa olu gimi minalo. Etiti minenawamo ya lifima lalo le fi gedami ya naba oluti akaiya dito nemo we nomilipala oti minenagilae. Amo ya wenena amomu kolámamo wenena ido luni gedimo wenena ya faifa olu lalo o gede-gede imo we ne. ");
INSERT INTO snp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Metibokafo wenena milumanina kolami ya linate ayaida oti milumani kolalo. ");
INSERT INTO snp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Linate wenena olu kalo mele gedámato, Gotikafo moda linate olu kalo mele gedámenaiye. Ido we ya lifimala ne, loti ádalo. Eti ámatoma, Gotikafo moda linate lifimatina ne, loto ádenaiye. Ido wenenatina lifimani kilili o gedenawamo, Gotikafo linate lifimatina kilili o gedenaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ido neta giminawamo, Gotikafo linate giminami ya oto dito miwito, mau naba wi gedeto, fitoto fululu kito giminagoliye. Neta gimi-gimi enawamo mona yaidana oto giminagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Etito ya kepa ka ma eti loto mene oto logimami, Omuna likami we makafo omuna likami we ma kanu ilibinae, loto enami nefe? E’e, kale nabau lelewai ya lumu fou lenagilaiye. ");
INSERT INTO snp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ena ege melami we yakafo api ilibami we olu afima o edámami ne. Etito nefa, api ilibageto ya monawa ko fuli lenami yamo api ilibami we yaidana oto minenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ido aukafo omunau momupa kefo efema nemo ya egaidana oto eyaba, ido kaimoka omugau yá lana ya eyefe ádane? ");
INSERT INTO snp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ido yá lana ya kaimoka omugau nemo eyámanimo aukafo omunau momupa kefo efema nemo ya egaidana oto olu fulo kedenae, loto loumunanimo ne? Monabi lele wiyanimo we, kamo kaimoka omugau yau yá lana nemo ya komu olu fulito, kofe loto minototo aukafo momupa omunau nemo ya olu fulo edo. ");
INSERT INTO snp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kolalo. Yá lalo yamo egaidana oto ilawa nosámami linaiye? Ido yá nosámami yamo egaidana oto ilawa lalo ya linaiye? Eti ámenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yamu wenena ya yá ilawa eyefe loti eyenagilae. Kolafe? Ade ilawa ya kefani kailau yauti doilámenagilamo ne. Ido lunadi ya yá kemani yauti doilámenagilamo ne. ");
INSERT INTO snp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","We lalo yakafo neta lalo ouna-kula-kala neguti ya neta lalo olu oloto piyaiye. Ido we nosámami yakafo neta nosámami ouna-luna-kala neguti ya neta nosámami ya olu oloto piyaiye. Etito ya lunigu faitoto nemo ka yauti weniguti ka lo feka o minae. ");
INSERT INTO snp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Linate weti atuwalo Wekolao, Wekolao, loti lonomafa, ka logimomo olu meyalo melámamo ya nediti eti ae? ");
INSERT INTO snp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Makafo namodoka oto ya ka lomo kolito, olu meyalo mele minami we mona ya gilibinagolowe. ");
INSERT INTO snp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wewa ya we makafo numuna kunagolowe, loto kale lito, fulo afima uto, kifanalo numuna kuwami we yamaidana oto ne. Etito ku fuli loito ya aiga ko wiyami kamenalo no lafa oto numuna itufaifa, numuna ya yá gedimokafo kuwainako, yamu auma wito ne. ");
INSERT INTO snp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Etito nefa, makafo ka lomo ya kolito koli fulitami we ya we makafo ya numuna kunagolowe, loto aka ma su neta oto mika mulaloko fito kuwami we yamaidana oto ne. No lafa oto numuna itufaito ayalo mofuluto lumuto upa-napa limo ne. ");
INSERT INTO snp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ena Yesu ya mono ka wenena logimi fuli lototo ya Kapeneyamu numudo dito wiye. ");
INSERT INTO snp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wito yalo ya kimiwe wani hadeti (100) kiyaba o gedami we kouba-nabala we ma koli lalo umami we ya neta kilito fulunagolo imo minaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Minaito, wenabala kimiwe kiyabani wekafo Yesu kala kuwa kolito, Yuda wenena kiyabani we ma eti logimami, Linate Yesu nedoka uti, Oto kouba-nabane we olu faka lo edenane, loti loumalo, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gilifi melaito, Yesudoka uti, ka auma witi eti loti wako lo edamo, Wewa ya monala lalo nemo nenako, kamo eti o edenanimo ya lalo enaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Amokafo lamo Yuda wenena siya-muluna lumuto ya mono numude ku ledami ne, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Etiti wako lo edato ya Yesu ya kolito amoki lako wae. Uti numuna olu alili melato kimiwe kiyabani wekafo wenenala ma Yesu nedo gilifi meleto ya ka eti loto logimaito wamo, Wekolao, namo Yuda we minámonako, numuneu dinanimo efe ádenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ido kamodoka enae, loto kolofa, ido namo yaki ya kamo yaidana we ya minámonako, keinalo kolowe. Yamu kamo faifa wekakafo ka lageto kouba-nabane we ya moda faka lenaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Etito namo yaki kiyaba o nedamo we wenido meyalo meleto ya lono oluto ido namo ya kimiwe kiyabani we minomo kiyaba o gedeto etito we ma wo, loumonetoma, moda wiye. Ido we ma ano, loumoneto ya moda aiye. Ido kouba-nabane we, lono ya olo, loumonetoma, lonowa ya olu-olu o minaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Loumaito, Yesukafo kawa limoma ya kolito, elegito wenena mau ege wamo wenenadoka oluwe oto eti logimami, Namo ya logimowe. Muki Isilaeli wenena yauti we ma koli kikila naba nemo wewa yaidana we ma eyámowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eti lito, gilifami wema ya itibiti uti numugu idato, kouba-naba we moda faka lito eyae. ");
INSERT INTO snp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ena aiga kefola Yesukafo numuna meya naba ma kuliya Naini yalo unae, loto wito ege-ege moinamo we ido wenena mau naba ya ege wae. ");
INSERT INTO snp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ege wato, numuna meya kanudo ya u fedaito, wenena ma kono ukana ya yafalo meleti oluti lomae. Lomato, ido wenena muki ya wena-kena ma nalafo lawoko ya folaito mele edenune, loti wena-kenaki numudoti lakoina lomae. ");
INSERT INTO snp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lomato, Wekolakafo wena-kena eyeto siya-mulunau milumala kolito, Kufu ámo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eti loumuto u adu anakafo ya yafalo olaito, kono yafa melamo we kanudo nedi minato, amokafo eti loto limo, We kofawe, kamo lokomowe. Neido, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eti loumaito, folami we kofawe ya nedito ka liye. Eti o minaito, Yesukafo olafote minenawaiye, loto olu umaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eti o gedaito, wenena muki ya weni lawa apaitaito, Goti ebola loti eti lamo, Ei, polofete naba ma minonigu oloto piyami ne, lato, ido liligate eti lamo, Gotikafo wenenala ani olu faka lenae, loto ami ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ido aya kala kuwa ya Yudia ebalo ido eba yaleka waka yau upatoto wimo ne. ");
INSERT INTO snp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ena Yoni ege-ege moinamo we yate Yesu kala kuwa ya loumae. ");
INSERT INTO snp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Loumato, kolito, ege moinami we lele ya ailo, logimaito ya aito eti logimami, Wekoladoka uti ya eti loti loga o edailo, Enaiye, loti lufuwa wiyamoma ya wema minabemo, ido we ailo kiyabala enune? loti loga o edailo, loto logimito gilifaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gilifaito, we lele ya Yesudoka uti eti lami, Yoni noku wi gede-gede imo wekafo eti loto kamodoka lilifaiye. Enaiye, loti lufuwa wiyamoma ya wema minabemo, ido we ailo kiyabala enune? loti loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eti loti loga o edaito, Yesukafo aya kamenalo ya wenena neta-mata naba kilamo olu faka loto, ido seni-mulunigu Satani kimiwela mino gedamo gilifi feka fulaiye. Ido omuni likami muki ya omuni olu falato gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eti o gedeto we lelema ya ka itibito eti logimami, Linate itibiti uti, neta muki koliti, ido omunikafo eyeti ami ya Yoni eti loti loumailo. Omuni likami wenena ya omuni falato ae. Ido kiyani nosámami wenena ya kanu moni-moni ae. Ido okola kilamo wenena ya gululudo gede-gede iye. Ido kani melami wenena ya ka koli-koli ae. Ido folamo wenena ya folaguti nedi-nedi ae. Ido neta ko ánamo wenena ya mate kala kuwa lalo lo oloto gimi-gimi ae. ");
INSERT INTO snp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ido wenena mate namomu koliti koli fulitámenawamo wenena ya lalo koli minomo wae. Etiti loumailo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ido Yoni gilifami we lele itibito waito, Yesukafo wenena mau minamo ya Yoni yamu eti loto logimami, Linate mika kofo mikalo nena neta kenune, loti wamo ne? Konofa ma epekafo oluto uto oto imo kenune, loti kenagili wafe? ");
INSERT INTO snp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","E’e, latoma, we ma ukanalo owo lalo-talo wiyami ya eyenagili wafe? E’e, moda ukanido owo lalo-talo witi, neta-mata ko noti minamo wenena ya mikalo kiyaba we wekudi numunigu yau minae. ");
INSERT INTO snp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yamu nena neta kenune, loti wamo ne? Ido polofete ya eyenagili wafe? O, eyenagili wamo wewa yamu ka ma logimowe. Wewama eyamo ya polofete maleka olu fulo gedeto nemo we ne. ");
INSERT INTO snp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Amomu ya mono lufuwau ya eti limo, Moda kane lo oloto melenami we ilifoneto u komu mele kedeto kanuka wili kedenagoliye, loto ka mono lufuwau (Mal 3:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yamu namo ka logimowe. Wenaipate kedamo wenena muki yauti makafo Yoni olu fulo edami we ma minámaiye. Minámaifa, ido Goti wekudite wenenala kiyaba o ledami kilalau we ma kuliya minámami we efema nemo we yamakafo Yoni olu fulo ede minami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Logimaito, Yesu kala kolitamo wenena muki ido kifana takisi olu-olu amo we yaki Yoni mono noku wi gedainako, Goti monala moda efe liye, loti kolae. ");
INSERT INTO snp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Eti kolato, ido Falisi we ido lo melami kala koli fuli lamo we Yonikafo mono noku wi gedámainako, Gotikafo, Olu yaidanaamaidana o gedenae, loto kala lalo kiyami ya fulitae. ");
INSERT INTO snp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ena Yesukafo mau minamo wenena eti loto logimami, Kamena oiya ama minamo wenena ya kemaidana oto olu lawoko o gedenae? Ido egaidana wenena minae? ");
INSERT INTO snp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wenenawa ya nomilipa kefola yaidana oti minae. Nomilipawa kefola ya maketilo amedoti minoti koinanibomota luni fiti au loti logimamo, Owo ofoto nema loba, ido linate melege olámae. Ido folamo nema lo fi mele gedeto loba, ido linate kufu ámae, loti logimamo ne. ");
INSERT INTO snp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Etito Yoni noku wi gede-gede imo we ya oto, wela-neta ido no waini ánoto moi wiyaito linate eti lo edamo, Satani kimiwela mino edaiye, loti lo edae. ");
INSERT INTO snp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ido namo We Kula ya oto wene-netaki noki ya no minoneto linate eti lo nedamo, Ake, we ya wela-netaki ido noki yamuko koli minoto kifana takisi olu-olu amo weki lifimani nemo wenenaki yowo melaiye, loti lo nedae. ");
INSERT INTO snp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eti lo minato, Gotidokati ka maninigu nemo ya olamo wenena muki ya ka manenau nemo ya ona kula ne, loti gilibi-gilibi ae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ena Falisi we ma kuliya Saimoni ya namoki wete-neta lakoina nenube? loto Yesu loga o edaito, numunau dito, amedoti weni-neta lakoina no minae. ");
INSERT INTO snp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lakoina no minato, numuna meya yaloti wena nosámami makafo kolito ya no ladanuwa imo ma nomu kifana falake limo nomuku nemo ya oluto numunau dito ");
INSERT INTO snp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","egeka minoto kufu oto, omuna nowalakafo kiyanalo fili edeto, manena yowalakafo kilili o edeto, kiyana mudoto, ladanuwa imo no yalo leki edaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eti o edaito, Falisi we Yesu olu numunau edami wewa yakafo eyeto ya lulau eti loto kolami, Wewa ya polofete nemo neko, wenawa neta eti o edami ido monala yakimu lifimala nemo wena minaiye, loto kolife lagi ne, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eti loto kolaito, Yesukafo ka itibito eti loto loumami, Saimoniyo, namo ka ma lokumunae, loto loumaito, amokafo ka itibito limo, Api lilibanimo we, moda lonomo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Loumaito, Yesukafo eti limo, Kifana lonodo olami we makafo we lele ma lifima umunawami kifanawa Yuda kifana kuliya denaliyasi faifu hadeti (500) ya ma umuto, ido ma fifiti (50) ya umaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Etito gimaito aiga ya lifimawa uma finae, loto kifanala moni wilaifa, itibiti ogoufámaito damoto faifa kilili o gedaiye. Kilili o gedageto, lelewai ya seni-muluni umunagilaifa, ido makafo oto dito siya-muluna umunagoliye. Ya kemamu lowe? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Etito loga o edaito, Saimonikafo ka itibito eti loto loumami, Lifimala naba nemo kilili o edami we eti enami ne, lito ya Yesukafo eti loto loumami, Moda efe loto kaka kiyane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eti loto loumuto ya wena nedoka oluwe oto ya Saimoni eti loto loumami, Wenawa ya eyabe? Namo numugau idomo ya kiyane noku winamo no fi nomámaba, ido amo yakafo omuna nowalakafo kiyanelo lekito atela yowalakafo kilili o nedaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ido kamo numugau idodo yalomati oto oiya amalo aito, kamoma mudo nedámanima nefa, amo yakafo kiyane mudomo wiye. ");
INSERT INTO snp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ido kamokafo atenelo yá nowala fili nedámanima nefa, amokafo kiyanelo ladanuwa imo nokafo fili nede minaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yamu ka ma lokomowe. Amokafo siya-muluna naba-naba nomami yamu lifimala naba-naba nemo ya kilili otami ne. Etito nefa, ido we ma lifimala kefoko nemo we kilili o edami ya siya-muluna kefo efemako umami ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eti loto loumuto ido wena ya eti loto loumami, Lifimaka moda kilili otaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eti loto loumaito, weni-neta lakoina noti minamo wenena yate lokoli-fukoli eti lamo, Ake, wewa ya lifima yaki kilili imo we ya kema ne? loti kolae. ");
INSERT INTO snp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ido Yesukafo wenawama ya eti loto loumami, Koli kikika yakafo moda olu omuga ko kedetaiye. Kamo wageto you amene mona ya mino kedenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ena Yesu ya numudo-namado monimo uto, Goti wekudite wenenala kiyaba o ledami kala kuwa lalo ya lo oloto meleto logimimo wiye. Logimimo wimo ya ege-ege moinamo we tuwelu (12) yaki lakoina wae. ");
INSERT INTO snp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ido wenaipa maleka ya Satani kimiwela seni-mulunigu mino gedamo ya olu fulo gedeto gilifi meleto ido neta kilamo olu faka lo gedami wenaipa yaki lakoina minae. Lakoina minamo wenawa ya etito ne: Ma ya Madala numudoti wena kuliya Malia ya siya-mulunauti Satani kimiwela seweni (7) ya olu fulo gedeto gilifi melami ya ne. ");
INSERT INTO snp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ido ma ya Yowana Heloti kouba-nabala we kiyabani we kuliya Kusa olonafo ya ne. Ido ma ya kuliya Susana ido wenaipa liligaleka muki ya lakoina minae. Ido wenaipawa netani-matani ko nagu yauti ani olu faka loti gimi-gimi ae. ");
INSERT INTO snp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ena numudoti-namadoti wenena muki uti u Yesudoka mau naba wi minato ya amokafo kepa ka ma eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Neta kifi-kifi imo we makafo ufa neta ma itili enae, loto migu wiye. Uto itili ito, ya ufa neta ma kanudo olumo wiyami wenena yate leya witi kululu wiyato, nema yate oti no fuli lae. ");
INSERT INTO snp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ido ufa neta ma ya kifana mulalo olumo wito, fokito idaifa, mika nowala minámainako, yamu ufa fou loto idami ya meguinami ne. ");
INSERT INTO snp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ido ufa neta ma ya kaila imo neta idaigu yau olumo wito, fokito idaito, kaila neta yakafo ayaida oto dito, ufa ya olu itoto ofo folami ne. ");
INSERT INTO snp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ido ufa neta ma ya mika lalo negu olumo wito fokito dito ilawa liyami ya u wani hadeti (100) liyami ne, loto logimaiye. Eti loto kepa ka ya lo fuli loto ya eti au loto limo, Linate katina nemo wenena yate kawa ya kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eti loto logimaito, ege-ege moinamo we yate kepa ka monawa yamu loga o edae. ");
INSERT INTO snp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Loga o edato, eti loto logimami, Goti wekudite wenenala kiyaba o ledami ka falukami ya linate oloto pi gimoneto moda kolae. Kolafa, mate Ko-ko o minafa, neta kofe loti eyámenagilae. Ido koli-koli o minafa, kolife loti kolámenagilae, loto ka mono lufuwau (Ais 6:9) ya nemo ne. Etito nenako, kepa ka yako logimowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Eti loto logimami, Ena kepa ka lomo ya monawa etito ne. Ufa ya Goti kala ya ne. ");
INSERT INTO snp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ido ufa neta ma kanudo olumo wiyami yaidana oti wenena mate Goti kala kolafa, ayalo Satanikafo oto, Goti koli kikito umato, olu omuni kotenaiye, loto ya kawa ya seni-muluniguti ipoto olu fulo gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ido ufa neta ma kifana mulalo olumo wiyami yaidana oti wenena mate Goti kala koliti, ayalo alikani naba afa, ido lufawani minámaiye. Minámaito, kamena linako koli kiki umuti ya kepa mele gimami kamenalo ya Goti kala fuliti u kopa wae. ");
INSERT INTO snp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ido ufa neta ma kaila idaigu yau olumo wiyami yaidana oti ya wenena mate Goti kala kolafa, ido uti ya mikaleka keina kolamo neta-mata yaki, ido neta ko namo neta-mata yaki, ido alikani enawamo neta-mata yaki netawa-matawa yakafo kawa kolamo yama olu itoto gedainako, wenenawadoka kulawa fede gimámaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ido ufa ma olumo mika lalo negu wiyami yaidana oti wenena ma luni-kani ona lalo nemo yate Goti kala koliti olu kiki loti auma witi minomo idato, amodoka kulawa oloto pi gimi minaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kolalo. Wenena yate lamu kiti oluti masa lulaufe, ido folomo feumau ya melámenawamo ne. E’e, wenena numugu dinawamo ya lamena eyenawae, loti lamu mele-mele amo ebalo yalo ya melenagilae. ");
INSERT INTO snp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ido ayaidana oto neta-mata muki oiya faluku nemo ya aiga olu oloto pinagoliye. Ido neta-mata muki olu momona-amona oto olu miwi minamo neta ya muki oloto pi fuli lageto, wenena koli fuli lenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yamu linate ka kolinawamo monatina yamu kati kife lalo. Neta ko namo wenena ya ma enu wito gimageto, ido wenena ya moda neta ko nonimo wenena minone, loti kani kiyamo wenenadokati netawa ya ipoto olunagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ena Yesu olafoki kunalafo-motaki amodoka unune, loti afa, wenena mau naba minoti olu lulau o edanako, ogoufámae. ");
INSERT INTO snp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ogoufámato, mate geyeti uti Yesu eti loti loumamo, Okafoki kunakafo-motaki keyenune, loti feto youma minae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eti loti loumato, amokafo itibito eti loto logimami, Goti kala koliti olu meyalo melamo wenena ya onefo kunanefo-mota ya minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kamena ma ya Yesu ege-ege moinamo we ya eti loto logimami, Nofuna anawa filiga afulaleka ya wokele, lito koliti sipiku diti wae. ");
INSERT INTO snp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Etiti wado ya Yesu omuna fi-fi ito oku onaito, epe naba-naba oto, no ya olu nosámami itaito, no satoto sipi lulau idaito, noku lumunune, loti ae. ");
INSERT INTO snp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eti o minato, ege-ege moinamo we minaidoka oti eku oti eti loti loumamo, Wekolao, wekolao, lamo no lulau lumuto fulunagolone, lato, ya amo nedito epeki no satimoki ya goudaito, ya epeki no satimoki fulitito you loto neto ");
INSERT INTO snp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ege-ege moinamo we eti loto loga o gedami, Linate nediti koli kikito nomámae? loto limo ya koliya koliti, elegiti ya eti loti loga-loga amo, Aiyo, we ya egaidana we minaito, epe yaki ido no yaki ka lido ya golodaiye? loti lae. ");
INSERT INTO snp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ena sipiku monimo uti no nofuna filiga akailaleka Gelasa ebalo u fedae. ");
INSERT INTO snp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yalo u fedato, Yesu mikalo idaito we ma Satani kimiwela mino edami wema ya numuna meya afulaleka yati aito ya katula aiye. Katula ami wewa ya adeinati ukanalo owo wiyámoto, numugu onámoto, kono melado yalo ku onoto moni-moni iye. ");
INSERT INTO snp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wewa yakafo Yesu eyeto kai meleto kiyanalo kiyana umola fito ka au loto limo, Yesuwo, Goti akaiya nemo we Nalafo, nedi-nedi o nedenagolo ane? Ukane ogofu olu nomámo, loto auma wito lokomowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Eti loto loumami, ya Yesukafo Satani kimiwela ya wewa siya-mulunau yauti lumuto wo, loto loumami yamamu ya eti loto loumaiye. Ido adeina afimalekati wewa ya ana-kiyanalo oluti nela ainikafo nela wi edeti kiyaba o edafa, ido Satani kimiwelawa yakafo kamena-kamena ya wewa olaito nela-ala fuko-nako o fulitaito, iyadaito eba fafato koli u-u iye. ");
INSERT INTO snp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ido Yesukafo wewa, Kulika lo, loto loumaito, siya-mulunau yau Satani kimiwela mukite diti minamo yamu, Kuline Lisiyonile, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Loumaito, Satani kimiwela yate, Lowau lilifageto lumutenune, loti ya eti o ledámo, loti wako lo edae. ");
INSERT INTO snp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ido mowalo adu yaleka yalo yafo mau naba noti minamo yamu ya Satani kimiwela yate, Yafo lunigu dinune, loti wako lo edato ya, O, liye. ");
INSERT INTO snp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","O, lito wewa siya-muluna yauti lumuti yafo lunigu idato, yafowa koli lumuti lowau konidokati luwa fiti nofugu yau no noti moda folae. ");
INSERT INTO snp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Folato, yafo kiyaba amo we ya eyeti koli oluloti uti wenena numuna meya nabaloti kefolaloti minamo ya kawa logimae. ");
INSERT INTO snp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Logimato, wenena mate netawa eyenune, loti Yesudoka o fedeti, wewa siya-mulunauti Satani kimiwela fulo edamo we ya ukanalo owo wito, kala-manena efe loto neto minoto, ya Yesu kiyanalo amedoto minami ya eyeti ya koli koli minae. ");
INSERT INTO snp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Koli koli minato, netawa koliti eyeti amo wenena yate Satani kimiwela mino edami we olu lalo o edami monawa wetata o gimae. ");
INSERT INTO snp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kawa wetata o gimato, Gelasa mikalo minamo wenena muki ya koli naba gimainako, Yesu mikate fulito unaiye, loti loumae. Eti loti loumato ya itibito unae, loto sipiku dito fulo gedeito wiye. ");
INSERT INTO snp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ido fulo gedeto wido wewa Satani kimiwela fulo edamo we yakafo, Namote unalifao? loto wako lo edaifa, Yesukafo eti loto loumami, ");
INSERT INTO snp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","E’e, kamo numugaleka itibito uto ya Gotikafo kamodoka lono naba olami kawa ya wenenaka lo oloto gimo, loto ilifaito, wewa ya uto Yesukafo olu lalo o edami neta naba ya wenena muki lo oloto gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ena Yesu itibito aito, wenena mau naba kiyabala o minamo ya eyeti aiyo-koiyo lo edae. ");
INSERT INTO snp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ena mono numuna kiyaba we ma kuliya Yailusi ya oto Yesu kiyanalo kiyana umola fito, Namo numuneu ano, loto wako lo edaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wako lo edami wewa ya olulafo lawokoko nemo melegela ya tuwelu (12) yaidana oto nemo nomili ya fulunae, loto ono minami yamu etito wako lo edaiye. Yesu ya wewa wako lo edami kala ya kolito, lakoina wami ya wenena yate olu lulau o ede minae. ");
INSERT INTO snp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Eti o edamo wenena minagu wena ma nemo ya wanula leki-leki imo melege tuwelu (12) yalo ya netawa kilaiye. Netawa kilami wenawa ya lusa we yate olu faka lo edenune, loti afa, ogoufámae. ");
INSERT INTO snp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ena wenawa ya Yesu egeka uto, ukanalo owo onowalo olaito ya ayalo wanula gelediye. ");
INSERT INTO snp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wanula geledito, Yesukafo, Kemakafo ukanelo olaiye? lito ya wenena mukite, E’e, lamo eti ámone, lato ya Pitakafo eti loto loumami, Wekolao, wenena mau naba yate olu lulau o kedeti liti-liti lanako, ido kitufu-natufu o minae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eti loto loumaito, Yesukafo eti loto limo, E’e, ailo makafo ukanelo olaito namodokati aumane ma wimo ya kolowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eti lito, wenawamakafo monane apoilaiye, loto ukana ololo oto o fedeto, Yesu kiyanalo kiyana umola fito ya wenena muki omunido ya neta kilami ka ya loto, ido ukanalo olaito ayalo moda faka limo ka yaki lo oloto melaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lo oloto melaito, Yesukafo eti loto loumami, Olunefone, kamo koli kikitanimo yakafo olu faka lo kedami ne. Seka-muluga you lageto wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ena eti loumu minaito, ayalo ya Yailusi mono kiyaba we numunauti makafo oto ya eti loto loumami, Olukafo moda fulutaiye. Yamu api lilibami we ya koiya fa fitenaiye, loto ya ámenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eti loto loumami ka ya Yesukafo kolito ya Yailusi ka itibito eti loumami, Koli komámaneyo. Koli kikito numuto minageto ya olukafo faka lenagoliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eti loumuto u numudoka fedeto ya dinae, loto wenena liliga lo fuko gedeto, Pitale, Yonile, Yemusile, ido nomiliwa olafote melafote yako gilimito idae. ");
INSERT INTO snp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Idato, wenena mukite kufu-nema oti ei-ai, loti afa, Yesukafo eti loto logimami, Linate kufu ámalo. Nomili ya folámoto faifa oku ono minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eti loto logimaito, wenenawa yate nomiliwa ya moda folaito, konima nenako, loti ya kiya o edae. ");
INSERT INTO snp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eti o edafa, amokafo analo oluto ya eti loto lula fito limo, Nomiliyo, neido, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eti loto loumaito, ouna itibito aito ayalo ya neidaiye. Neidaito, Yesu eti logimami, Wela-neta umalo. Nenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Logimaito, olafote melafote elegi minaito, amokafo kawa wenena ma logimámailo, loto auma wito lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ena Yesukafo ege-ege moinamo we tuwelu (12) amodoka olu mau wi gedeto Satani kimiwela olu fulo gedeti gilifi melenawamo auma ido neta kilamo olu faka lo gedenawamo auma ya gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Auma gimito, eti logimami, Uti Goti wekudi wenenala kiyaba o ledami ka ya lo oloto gimiti ya ido neta kilamo ya olu faka lo gedalo, loto gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Gilifi melenagolo ya ka ma mene oto eti loto logimami, Linate unawamo ya kanudo neta-mata owotinafe, ido kolobofe, ido beletife, ido kifanafe ya olu minámoti faifa walo. ");
INSERT INTO snp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ido numugu dinawagu ayau yako onoti nediti oti minomo uti numuna meya malo unagilima aya kamenalo ya numunawa fuliti walo. ");
INSERT INTO snp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ido u fedato koina wi gedámenawamo, numunawa ya fuliti kiyanido momupa ekelami ya kululu witi, fuliti monatina kolinawae, loti fulo gedalo, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Gilifi melaito, uti numudo-numudo eba nedo-nedo moniti Goti kala kuwa lalo lo oloto gimiti, neta kilamo olu faka lo gedemo wae. ");
INSERT INTO snp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ena gamani wenabani Helotikafo Yesu neta-mata imo ka ya kolito, kala ligi-ligi kiyaiye. Wenena mate ya Yoni folaiguti olu nedi edaito minaiye, loti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ido mate ya Elaiya kofa oloto pito minaiye, loti lo-lo ae. Ido liligate ya adeina polofete minagu ma folaiguti nedito minaiye, loti lo-lo ae. ");
INSERT INTO snp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eti lo minamo yamu Helotikafo kala ligi-ligi kito ya eti limo, Namo weneloti ya Yoni kenebala fitamo ne. Wewa yamamu ka yaidana lo minamo kolomo yamu kema ne? loto ya eyenami kanu ma moni wili minaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ena aposolo we yate moinadoti itibiti oti lono olamo ka ya Yesu loumae. Loumato, Yesukafo gilimito, lalimoko minenune, loto numuna meya kuliya Betesaida wiye. ");
INSERT INTO snp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gilimito wito, wenena mau naba-naba ya koliti gege uti ya Yesudoka o fedae. O fedato, koina wi gedeto Goti wekudi wenenala kiyaba o ledami ka ya logimito, neta kilamo wenena ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ena fo sapinae, loto ito ya ege-ege moinamo we tuwelu (12) ya amo nedoka oti eti loti loumamo, Amalo ya fafato mikalo minonimo yamu kolito wenena mau naba ya uti numudo-numudo ido mini numuni adu nedo yalo ya weni-netaki ido onenawamo eba ya moni wilinawae, loto gilifi melo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eti loti loumafa, ido amokafo, Linanimo weni-neta ma gimalo, loto logimaito, itibiti loumamo, Lamo beleti faifu (5) ido laefa lele (2) yakiko olu minone. Yamu nedi enune? Uto wenenawa muki weni-neta meina finumomu labe? loti lae. ");
INSERT INTO snp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Eti loti lamo ya wemomo ya faifu tauseni (5,000) yaidana oti minamo yamu lae. Eti lato, amokafo ege-ege moinamo we ya eti loto logimami, Linate wenena logimato we fiti mau fifiti-fifiti (50-50) witi amedoti minomo unawae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eti loto logimaito, amote uti eti o gedato, muki amedoti minomo wae. ");
INSERT INTO snp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eti ato, Yesukafo beleti faifu (5) yaki ido laefa lele (2) yaki oluto kosinalo ko faka loto, siyane, lalole, loto ya leketo ege-ege moinamo we yate iya meleti, wenena mau naba ya giminawae, loto gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gimaito, muki wenena nato muni ito ya luma nemo onowa-fanawa minomo wimo ya kiyaka oti owo kedikoko naba ya tuwelu (12) koilato faitiye. ");
INSERT INTO snp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kamena ma Yesuki ege-ege moinamo weki inanimoko minoti, Yesu aimolako Goti loumu minaido yalo ya eti loto loga o gedeto limo, Wenena mau naba yate namomu lamo ya kema minaiye, loti lo minae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Loga o gedaito, ka itibiti eti loumamo, Mate kamo Yoni noku wi gede-gede imo we ya minane, loti lae. Ido mate Elaiya ya minane, loti lae. Ido mate ya adeina polofete minaguti ma ya folaiguti kofa neidami we ya minane, loti lo minae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eti loumato, amokafo, Etiti lafa, ido linate ya namomu ya kema ne, loti lo minae? loto loga o gedaito, Pitakafo ka itibito eti loto loumami, Gotikafo kilifi melami we Kilistole, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Loumaito, ido kawa ya wenena logimámalo, loto auma wito lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ido ka ma mene oto logimami, We Kula namo ya keina naba-naba koloneto Yuda wenena kiyabani weki, yokila ki umamo we kiyabani weki, ido lo melami ka api gilibamo we yalekate meni numuti nofato fuluto ya fo kamena tili (3) wageto kofa nedinagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ena Yesukafo ya muki eti loto logimami, Ma nege melenune, lotima, inanimomuko kolamo ka ya fuliti, kamena-kamena yá yofonina mofuti nege melenawae. ");
INSERT INTO snp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ido we makafo aimola ukana atuwamuko koli minoto fulunami we ya u kopa unagoliye. Ido makafo namomu kolito monimo uto omuna kofawa minami monala ya fulito fulunami we ya omuna kofawa minowa-minowa enagoliye. ");
INSERT INTO snp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ido mate ya mikaleka neta-mata muki ya ko noti monimo wafa, ido inanimoni u kopa unawamo ya egaidana oti lalo enawamo ne? ");
INSERT INTO snp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ido makafo namomu ido ka lomo yamu kolito ukanalo kolinami we ya namo We Kula lamenane yaki, ido Menefo ido felegaga enisole lamenani yaki o fedenamo kamenalo ya wewa yamu kolito ayaidana oto ukanelo kolinagolowe. ");
INSERT INTO snp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ena ka ona logimowe. Linate onema amalo minagu yauti maleka folámoti faifa minato, Goti wekudi wenenala kiyaba o ledami kamena olu oloto pi gimageto eyenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ena Yesukafo kawa logimi fuli loito neto ya fo kamena eiti (8) utaito yalo Goti loumunae, loto Pitale, Yonile, Yemusile gilimito mowalo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dito, Goti loumu minaido ya kola-wela u ailo ito ido ukanalo owo u lamena oto kiyoba ko sili gae-gae fulami yaida iye. ");
INSERT INTO snp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eti o minaito, we lele Mosesete Elaiyate ");
INSERT INTO snp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kosina lamenaki oloto piti, amoki ka lokoli-fakoli amo ya Yesu Yelusalemu ya fuli loto fulunami ka ya lo minae. ");
INSERT INTO snp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lo minato, ya Pitaki lakoina minami we leleki omuni fi-fi ito oku onadoti nediti Yesu lamenala yaki ido we lele lakoina minami we yaki geyae. ");
INSERT INTO snp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Geyato, we lele Yesudokati waido ya Pitakafo Yesu eti loto loumami, Api lilibanimo we, lamo amalo minonimo ya lalo ne. Lalimo kolo-kalo numuna lelei-lawokoi kuto ma ya kamo numuga minenaiye. Ido ma ya Mosese numuna minenaiye. Ido ma ya Elaiya numuna minenaiye, loto loumaiye. (Eti loumuto ka limo monala ya kolife ádaiye.) ");
INSERT INTO snp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eti lo minaito, limu makafo oloto pito asa wi gedaito ege-ege moinamo we ya koli gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Koli gimaito, limuku yauti nola ma kolamo eti limo, Ama ya Nanefo iyaina o edomo wema ne. Kala ya luti-katigu kolalo, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka lo fuli lito ya Yesu aimolako minami ya eyae. Ena kamena yalo ya netawa eyamo ya wenena ma logimámoti faifa koliti minae. ");
INSERT INTO snp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ena leda mowaloti lomado ya wenena mau naba ato katula ae. ");
INSERT INTO snp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Katula ato, ayalo wenena minagu yau we makafo eti loto lu fiyami, Api lilibanimo weyo, nanefo nomilipane lawokoko ma nenako, eyo, loto wako lo kedowe. ");
INSERT INTO snp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kolabe? Satani kimiwela makafo olu kiki lo edaito, kaita kai-kai nosámami melaito ido olu ipili-napili wi edaito ketufu kala-kala welau yati di-di imo ne. Eti imowa ya ala fulo edámoto kamena fana-fana etito ukana olu kopa o edemo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eti o edaito, namo kege-kege moinamo we yate siya-mulunauti olu fulo edeti ilifinawae, loto wako lo gedofa, ido ogoufámae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eti loto loumaito, Yesukafo ka itibito eti loto limo, Ake, linate koli kikitina minámaito monatina lekesa wiyami melamo wenenao, kamena nenaki ya linateki minenae? Ido kamena nenaki linate keinatina mofu gedenae? Nakafo ilimito ano, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eti loto loumaito, kipawa ya Yesu nedo o minaito ya Satani kimiwelakafo olu mikalo fulo edaito, kululukululu monito, ketufu welauti kala-kala loto idaiye. Eti o edaito, ya Yesukafo Satani kimiwela, Eti ámo, lo fuko edeto, ya kipa olu faka lo edeto melafo itibito olu umaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eti o gedaito, muki yate Goti aumala naba ya eyeti elegiyae. Ido wenena muki ya Yesu neta-mata oto meleto o-o minami yamu elegi minato, amokafo ege-ege moinamo we ya eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ka ama logiminamo ya koliti eti loti kolife lalo. We Kula namo ya nofo fulunawamo wenena anido giminagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eti loto logimaifa, kala ya kolife lotenawae, loto Gotikafo kala monawa olu faluku gedainako, yamu kani ligi-ligi kiti loga o edenune, loti kolafa, ido koli gimaito loga o edámae. ");
INSERT INTO snp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ena ege-ege moinamo we yate moila fiti eti loti lamo, Lamodokati ya kema komu meleto kuliya nemo we minenagoliye? loti lae. ");
INSERT INTO snp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Eti loti lafa, ido luni-kanigu kolamo ka ya Yesukafo kolito ya nomilipa kefola ma ilimito adu nedi meleto ");
INSERT INTO snp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","eti loto logimami, Kolalo. Wenena mate namo kulinelo nomilipa kefola yaidana ma koina wi gedenawamo wenena ya namoki koina wi nedenagilae. Ido koina wi nedenawamo wenena ya nilifi melami we yaki koina wi edenagilae. Yamu linate yauti we ma kiyanido lumuto minenami we ya liliga muki ya olu fulo gedeto u komu melenaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ena Yonikafo eti loumami, Api lilibanimo weyo, we makafo kamo kulikalo Satani kimiwela gilifaito eyonimo ya lamodoka mene oto kege melámainako, yamu lo fuko edone, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Loumaito, Yesukafo eti loto limo, Lo fuko edámalo. Linate kuwotibo bulu gedámami we ya linate yowoti we ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ena Yesu kosinau dinami kamenala alitito ya Yelusalemu numudo unae, loto auma wito kolito ");
INSERT INTO snp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","wenena gilifaito komu meleti uti Samalia wenena numuni malo u fedeti, Yesu onenami numuna ma olu oloto pi edenune, loti idafa, ");
INSERT INTO snp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ido Yesu ya Yelusalemu numudo unagolimo yamu wenenawa amoki koina wi edámae. ");
INSERT INTO snp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Amoki koina wi edámamo monani ya ege-ege moinamo we Yemusite Yonite koti eti loti loumami, Wekolao, lamo ya kosinau lu fiyoito kosinauti yo lomageto lo ludo fuli lenawae, loto kolabe? loti laito ");
INSERT INTO snp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","amokafo oluwe oto goudaito ");
INSERT INTO snp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","u numuna maleka wae. ");
INSERT INTO snp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ena kanudo wato, we makafo eti loto loumami, Eba muki unanidoka ya namote lakoina unaliye, lito, ");
INSERT INTO snp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesukafo eti loto loumami, Kula fadena yate mika kofuti ku onato ido nema kosinalo moinamo ya numunani neto minafa, namo We Kula ya oku ono-ono omo ebane ya minámaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eti loto loumuito ena we ma eyeto, Oto nege melo, loto loumaifa, wewa yakafo itibito loumami, Wekolao, komu ya uto menefo kale li edetoto kege moninafe? loto loumaito, ");
INSERT INTO snp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesukafo eti loto loumami, Fulunawamo wenena fulo gedageto amo yate ya folamo wenenani mele gedenagilae. Ido kamo ya uto Goti wekudi wenenala kiyaba o ledami ka ya lo oloto gimo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ena we makafo eti loto loumami, Wekolao, namo ya kege melenafa, komu ya uto numunelo minamo wenena ya aiyo-koiyo lo gedeto minalo, loto logimitoto ya kege melenafe? loto loumaito, ");
INSERT INTO snp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesukafo itibito loumami, Wenena ma ya lono kila olunune, loti olafa, neta mamu koliti fulitenube? loti luni-kani lele melenawamo ya Goti wekudi wenenala kiyaba o ledami kilalau dinawamo ya ogoufámae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ena aiga Wekolakafo ege melamo wenena sewedi-tu (72) ma iyaina o gedeto ya numuna meya muki ido eba muki aimola unae, loto kolami ebalo ya we lele lele u komu mele nedeti unawae, loto gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gilifi melenagolo ya lono ka eti loto logimami, Konuma-kobina migu ya naba-naba kula lifa, lono olunawamo wenena ya naba minámae, loti linate lono aboga loumato ya lono olunawamo wenena ma ya lonolau ya gilifi melenaiye, loti loumalo. ");
INSERT INTO snp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Linate walo. Namo gilifi melomo linate ya sipisipi momola yaidana oti kula fadena minagu yau gilifi melowe. ");
INSERT INTO snp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Unawamo ya kifanafe, ido owofe, ido kiyanido winawamo neta mafe ya ma olámoti faifa walo. Ido kanu unawado ya wenena ma geyetima, faifa minoti ka-ka logimiti lokoli-fakoli ámalo. ");
INSERT INTO snp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ena uti u fedeti numuna mau dinawamo komu ya, Numuna amau ya you amene mona ya mino gedenaiye, loti logimalo. ");
INSERT INTO snp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eti loti logimato, we ma you amene mona amodoka mino edami numugu minenami, linate you amene mona yamu loumamo ya wewadoka ya mino edenagoliye. Ido ma minámenami, monawa yamu loumamo ya linatedoka kofa itibito enagoliye. ");
INSERT INTO snp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ido lono olamo wenena yate meinanina olunawamo nenako, yamu dinawamo numugu ayau yako onoti nediti oti, konuma-kobina muki giminawamo ya nalo. Numuna mauka-mauka idámalo. ");
INSERT INTO snp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ena numuna meyalo maleka o fedato ya wenena yate koina wi gedeti ya weni-neta giminawamo ya nalo. ");
INSERT INTO snp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Noti ya ayau neta kilamo wenena ya olu faka lo gedeti eti loti logimalo, Goti wekudi wenenala kiyaba o ledami kamena ya linatedoka alito gedaiye, loti logimalo. ");
INSERT INTO snp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ido u numuna meyalo maleka o fedato, wenena ya linateki koina wi gedámenawamo, kanunido moniti ya eti loti logimalo, ");
INSERT INTO snp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Linate numunidokati fulo gedeito unune, lotima, momupanina yaki kiyadelo ekelami ya pupa loto itili oto fulo ebatinauka fulito gedone. Eti o gedoba, ido linate ya fuka ka logimonimo ya kolalo. Goti wekudi wenenala kiyaba o ledami kamenala ya moda alitimo ne, loti logimalo. ");
INSERT INTO snp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka ona lowe. Kamena nabalo ya Sodomu minamo wenena lifima ka oluto lumuto giminagolifa, ido numunawau minamo wenena lifima ka ya oluto dito giminagoliye. ");
INSERT INTO snp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aiyo, Kolasini wenenao, Betesaida wenenao, linate u kopa unagilamo ya kolámafe? Linatedoka Goti aumala oloto pi gedami netawa-matawa ya Taiya wenenaki ido Saidoni wenenaki numunido oloto pi gedami neko, adeinati seni-muluni olu eleyapa witi ukanido owo migoli-agoli witi yo laina filiti minagi ne. Etito nefa, linate seti-muludi eleyapa wiyámoti faifa gedito minae. ");
INSERT INTO snp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eti o minafa, ido lifima ka giminami kamenalo ya Taiya ido Saidoni minamo wenena lifima ka ya oto lumuto gimito, ido linate lifima ka ya oto dito giminagoliye. ");
INSERT INTO snp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ena Kapeneyamu wenenao, linanimo kuliti ya olu akaiya kosinalo dito minenaiye, loti kati kiyafe? E’e, eti ámenagoliye. Ya lowau fulo gedaito yau lumuti minenagilae, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ena ka ma mene oto logimami, Linate ka lenawamo ka ya kolinawamo wenena ya namoki kolinagilae. Ido koli fulo gedenawamo wenena ya namoki koli fulo nedenagilae. Ido namo koli fulo nedenawamo wenena ya nilifi melami we yaki koli fulo edenagilae, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ido sewedi-tu (72) wenenawa monititi itibiti oti ya seni-mulunigu lalo ito eti loti loumamo, Wekolao, kamo kulikalo Satani kimiwela yate wetelo golodae, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Loumato, Yesukafo eti loto logimami, Satani ya kosinauti kopana yaidana oto olumo wiyaito eyomo ne. ");
INSERT INTO snp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Namo linate auma gimonako, salopaina ido fuma makana mulalo leya witi, kuwotefo aumala muki ya olu afima o edato, neta makafo olu kopa o gedenami ya ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Etito nefa, linate Satani kimiwela wetido meyalo melamo yamu alikani ámalo. E’e, kulitina kosinau lufuwa witami nenako, yamu alikani alo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ido aya kamenalo ya Ouna Felegaga Yesu siya-mulunau mino edami yakafo alikani naba-naba umaito ya eti limo, Menefo, kosinauka mikaleka Wekolala, ka maninigu nemo wenena ya netawa ya olu faluku gedeto, ido fa wenena nomilipa kefolaidana oti minamo ya olu oloto pi gimanimo yamu keboka lo minowe. Kamo seka-mulugau eti enae, loto lalo kolanimo ya moda eti o gedane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Loumutoto, ido wenena eti loto logimami, Menefokafo neta-mata muki ya moda anelo meletami ne. Ido Nalafo namo ya we makafo neyefe loto neyami we ma minámaiye. E’e, Menefo yako neyefe loto neyaiye. Ido ayaidana oto we makafo Menefo eyefe loto eyami we ma minámaiye. E’e, namoki ido wenena olu oloto pi giminae, loto kolomo wenena yakiko Menefo eyefe lonimo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eti logimito ege-ege moinamo weki inanimoko minoti ya eti loto logimami, Wenena omuninakafo linate neta eyamo yaidana oti eyeti ya alikani o-o enagilae. ");
INSERT INTO snp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ka logimowe. Polofete muki ido mikalo kiyaba we wekudi muki yate linate neta eyamo yaidana oto eyenune, loti kolafa, ido eyámamo ne. Ido linate ka kolamo yaidana oto kolinune, loti kolafa, ido kolámamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kamena ma lo melami ka kolife lo fuli limo we makafo Yesu kepa mele edenae, loto nedito eti loto loga o edami, Api lilibanimo we, namo kofawa minomo dinamo mona olunae, loto kolinamo, ya nena mona melenamo ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Loga o edaito, Yesukafo eti loto loga o edami, Lo melami ka lufuwa wiyaigu yau nediye liye? Kamo ya katoto nediye loto kolane? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Loumaito, itibito loumami, Seka-muluga muki ido ouga muki ido kaka-manega muki ya Wekola Gotika ya umo. Ido kaimokamu kolanimo yamaidana oto wenenaka muki ya seka-muluga gimi-gimi o mino, loto ka mono lufuwau (Lo 6:5, Wkp 19:18) ya nemo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Loumaito, Yesukafo eti loumami, Oiya ya ka efe loto itibito lonomane. Kawa ya meyalo melenanimo, minowa-minowa oto kofawa minomo dinane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eti loumaifa, wewa yakafo monane efe limo ya oloto pinaiye, loto itibito loga o edami, Kemamu ya koloneto wenenane minenaiye? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesukafo itibito loumami, Kolo. We ma Yelusalemu numudoti Yeliko numudo monimo lomaido ugele we yate kaita ofoti ukanalo owo wakoti netala muki oluti ofoti fulunaiye, loti fulo edeiti wae. ");
INSERT INTO snp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wato, Goti yokila ki umami we ma aya kanudo monimo lumuto wewa ya eyeto kanuma fulito u filigaleka kanu anawaleka afula uto wimo ne. ");
INSERT INTO snp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ido ayaidana oto we ma Lifai ufa fiyaigu yauti we ya aya ebalo oto eyeto kanu anawa filigaleka afula uto fulo edeito wimo ne. ");
INSERT INTO snp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Fulo edeito wifa, Samalia we ma kanudo monimo oto ya wewa ono minami ebalo o fedeto eyeto milumala kolaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Milumala kolito amo nedo uto ukana ofo fukado ya no wainiki yá ilawa nowalaki yakafo noku wito asa wi edaiye. Asa wi edeto aimola yafola-dogi meyalo ya olu meleto numuna naba ma kanudo moinamo siniditoma uti ono-ono amo numugu ya ilimito dito kiyaba o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kiyaba o edeto, leda kifana lele koilami ya oluto numuna aboga umuto eti loto loumami, Wewa ya kiyaba o edo. Ido kifana komomo ogoufámagetoma, itibito enamo kamenalo ya kifana ma yalo kumunagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ena wema lelei-lawokoi yauti kema ya ugele wete ofamo we wenenala ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Loga o edaito, lo melami ka katoto kolife limo wekafo ka itibito loumami, Milumala kolami wele, loto lito, Yesukafo, Kamo ya uto mona melami yaidanako oto melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuki ege-ege moinamo weki kanu monimo uti numuna malo fedato, wena ma kuliya Matakafo nasafili o gedaito, ");
INSERT INTO snp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","kunalafo kuliya Malia Wekola kiyanalo amedoto ka limo ya koli minaiye. ");
INSERT INTO snp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Koli minaifa, atelafo Mata neta ofo kiyami lonokafo nela wi edaito, uto oto minoto Yesu nedo oto eti loto loumami, Wekolao, kunanefo ya fulo nedeito wito kouba-naba lono ya nanimoko olomo ya neyanimo lalo ife? Kamo loumageto ane olu faka lenaiye, loto lito, ");
INSERT INTO snp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesukafo eti loto loumami, Matao, Matao, kamo neta-mata mukimu kolito kaka mumudi kito seka-mulugau keina koli minane. ");
INSERT INTO snp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Eti o minaba, ido mona lalo lawokoko ma mino kedámaiye. Ido Malia mona lalo melenae, loto mona melami yamamo ya kamo monaka olu fulo edainako, mate amodokati monala ya ipoto olámenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kamena ma ya eba malo Yesukafo Goti loumu minaiye. Loumu fuli lito ya ege-ege moinami we makafo amo nedo oto eti loto loumami, Wekolao, Yonikafo ege-ege moinamo we Goti loumunawamo mona api gilibami yaida oto kamo ya api lilibo, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lito, Yesukafo eti logimami, Linate Goti loumunune, loti ya etiti loumalo, Metefo, wenena yate kulika olu faka lomo dito felegagale, loti minenawamo ne, loto kolone. Ido kamo kiyabate we wekudi kiyaba o ledanimo kamena o fedenagoliye, loto kolone. ");
INSERT INTO snp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ido kamena-kamena weteneta ya lomo. ");
INSERT INTO snp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ido lamo yaki wenena muki olu nosámami o ledamo lifimanina kilili o gedonimo yamu kamo lifimate kilili o ledo. Ido mona nosámami kepa mele lumunami nedo ya lilimito áumo, loti Goti loumunawamo ya eti loti loumalo. ");
INSERT INTO snp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ena kati kiyalo. Linatedokati makafo luwaila yalo uto auwafo lula fito eti loumunami, Aunefo, kamo beleti lelei-lawokoi ma nomo. ");
INSERT INTO snp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Aunefo ma kanu moinaidoti namo minodo o fedaito wela-neta umunae, loto ofa, kobina ma numuneu minámaiye, loto loumunaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ido numunau minami we yamo itibito eti loumunami, Neku ámo. Numuna kanu kuto olu kiki loito, namoki nomilipaneki folomolo oku onoto minone. Yamu folomonelo yati nedito neta ma ogofuto komámenagolowe, loto loumunaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka logimowe. Numuna aboga ya wewa yowone wema ne, loto kolito folomoloti nedito beleti umámaifa, wewa ya ilulu kuto loga o edainako, yamu folomoloka yati beleti moda ogofuto olu umunagoliye. ");
INSERT INTO snp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yamu ka logimowe. Linate ya neta ma lumunabe? loti Goti loumu minenawamo ya netawamu kolinawamo ya giminami ne. Ido neta moni wili minenawamo ya olu oloto pi gedenami ne. Ido kanudo kesoba winawamo ya kanu wi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Etito neta lumunabe? loti loumu minenawamo wenena ya moda olunawamo ne. Ido neta moni wili minenawamo wenena ya olu oloto pinawamo ne. Ido kanudo kesoba wi minenawamo wenena ya kanu wi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ido linatedokati ya we ma nalafokafo laefa yamu loga o edenami, ya salopaina olu umunaife? ");
INSERT INTO snp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ido okolofo mulamu loga o edenami, fuma makana olu umunaife? ");
INSERT INTO snp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Etiti linate ya wenena nosámamo minafa, nomilipatina neta lalo faifa gimi-gimi amo mona ya koli minae. Monawa koli minato, ido Metibo kosinau nemo we yakafo oto dito wenena ya Ouga Felegaga lomo, loti loumunawamo ya moda giminami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesukafo Satani kimiwela we ma mino edeto olu nei kili edami ya siya-mulunauti ilifi melaito fulo edaito wito wewa komu nei kilami yakafo ka lito wenena mau minamo ya elegi minae. ");
INSERT INTO snp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Elegi minafa, liliga yate eti lamo, Amo ya Satani kimiwela wenabanina Belesebuli aumala yakafo Satani kimiwela ya olu fulo gedeto gilifi melaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ido ma yate, Kepa mele edenune, loti kolamo, Kosinalo mebe-maba olu oloto pi ledageto kenune, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Loumato, Yesukafo kani kiyamo ya koli fuli loto eti loto logimami, Lawoko wenena inanimo foki filiga-filiga oti fina fi minenawamo ya inanimo ebanina olu kopa itenagilae. Ido afo mona lawoko yau wenena minamo inanimo foki filiga-filiga oti fina finawamo ya afo monati ya olu kopa itenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ido Sataniki ido wenenalaki inanimo foki filiga-filiga oti fina fi minenawamo, egaidana oto auma wi minenami ne? Linate ya namomu koliti, Satani kimiwela wenabanina Belesebuli aumala olamikafo Satani kimiwela olu fulo gedeto gilifi melaiye, loti lo-lo amo kawa yamu logimowe. ");
INSERT INTO snp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ido namo ya Belesebuli aumala olomokafo Satani kimiwela ya olu fulo gedeto gilifi melonetoma, ya linate gege melamo wenenanina ya kemakafo auma gimaito olu fulo gedeti gilifi mele-mele ae? Yamu gege melamo wenena yate ya geyeti iya mele gedenagilae. ");
INSERT INTO snp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ido namo ya Goti aumala olomokafo Satani kimiwela ya olu fulo gedeto gilifi melomo yamu Goti wekudi wenenala kiyaba o ledami monala ya linatedoka mino gedami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kolalo. Auma wiyami wekafo lawelaki kiyalaki minami aimola numuna ebala kiyaba ageto ya netala-matala muki fa minenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Fa minenagolifa, ido aumala olu fulo edami we makafo oto ofoto kiya lawela olu auma wi edami netawa ipoto oluto koukamela ya iya melenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","We ma namodo ekelámami ya kuwonefo ne. Ido we makafo namoki lakoina lono oluto olu mau wi gedámami we ya olu upato gede minaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ido Satani kimiwela nosámami we ma siya-mulunau mino edami lulauti lumuto fulo edeito uto kofo mikau yaleka monimo uto foli minenae, loto yaidana eba ma moni wilimo wifa, eba ma oloto piyámaiye. Oloto piyámaito eti loto limo, Kofa itibito komu minomo numuneuka unae, loto kolito itibito wiye. ");
INSERT INTO snp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Itibito o fedeto eyaima numuna kilili oto, feke loto, neta-mata muki lulau efe lotoko ne. ");
INSERT INTO snp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Etito eyeto kofa feka uto, Satani kimiwela nosámami seweni (7) ya kaila nosámami fiyamo amo kailala olu fulo edeti minamo ya gilimito aito numunawa yauma diti onoti nediti minae. Etiti minato wewa komu ya Satani kimiwela lawokoko siya-mulunau nemoma nefa, ido aiga ya Satani kimiwela muki siya-mulunau minamo yate olu nosámami naba-naba o edenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu kawa logimi minaido ya wenena mau minagu yauti wena ma lula fito limo, Kamo mulunauti kedeto amina komami wena ya lalo koli minomo wiye, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","aimola itibito loumami, Ona laba, ido Goti kala koliti golodamo wenena ya lalo koli minomo wae, lenumo ya moda efe lenami ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ido wenena mau naba wiyamo yate Yesu olu lulau o ede minato eti loto logimami, Oiya minamo wenena monanina nosámami-asámami mele minae. Mebe-maba ma olu oloto pi ledenanimo, eyenune, loti lafa, Goti aumala gilibami neta ma olu oloto pi gimámenami ne. E’e, polofete Yona ukanalo Gotikafo aumala ilibami mebe-maba yako olu oloto pi gedenami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona monala melami yakafo mebe-maba Ninife numudo wenena oloto pi gedami yaidana oto We kula namo monane melomo yakafo kamena oiya ama minamo wenena mebe-maba oloto pi gedenamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ido lifima ka giminami kamena nabalo ya Seba wenena kiyabani wena wenakudi yakafo nedito kamena oiya ama minamo wenena ya ligiya lo gedenaiye. Amo ya Solomoni ka manenau nemo we nenako, uto kala lalo kolinae, loto mika faigalekati ami nefa, ido oiya moda Solomoni olu fulo edomo we ya amau minowe. ");
INSERT INTO snp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ido lifimani giminami kamena nabalo ya Ninife numudo minamo wenena yate nediti kamena oiya ama minamo wenena ya ligiya lo gedenagilae. Ninife numudo minamo wenena yate Yona kala koliti, seni-muluni eleyapa wiyafa, ido oiya ama moda Yona olu fulo edomo we amau ya minowe. ");
INSERT INTO snp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","We makafo lamu kito olu falukunami ebau melenamife, ido masakafo olu fitenami we ya ma minámaiye. E’e, wenena numugu dinawamo lamena eyenawae, loto lamu mele-mele amo ebalalo melenami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ido omuga ya ukaga lamula ne. Yamu omuga lalo minagetoma, lamena ya ukaga muki ya olu faito kedenagolimo ne. Ido omuga nosámagetoma, sini ya ukaga muki olu faito kedenagolimo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ido lamenawa lukau nemo ya sinidotenaiye, loto koto kiyaba oto mino. ");
INSERT INTO snp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Etito ukaga muki lamenakafo faito kedageto, sinido kedenami eba ma minámageto, lamu ya lamena o kedenami yaidana oto ukaga muki lamena o kedenaiye, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ka lo fuli loto minaito, Falisi we makafo wela-neta nenaiye, loto numunau ilimito wiye. Ilimito wito numunau dito weni-neta namo folomolo amediye. ");
INSERT INTO snp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amedoto nenagolifa, ana komu noku wiyámami yamu Falisi wekafo eyeto kala mumudi kiyaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kala mumudi kiyaito, Wekolakafo eti loto loumami, Aiyo, linate Falisi we yate kapuki lapeki atuwalo feka yako noku wiyafa, lutigu yau wenena netanina ipoti netamata maki maki olunumolae, loti kolamo monaki, ido nosámami kani kiyamo monaki ya faitiye. ");
INSERT INTO snp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Linate kati-manidi minámami wenenao, atuwa olu oloto piyami we ya lulau yaki olu oloto piyámaife? ");
INSERT INTO snp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Etito nefa, neta lape lulau nemo neta ya ko ánamo wenena giminawamo ya muki neta olu mo lo gedenami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aiyo, linate Falisi we ya lifima ka nabanaba itibiti olunawamo ne. Linate yate neta teni (10) ya olagu yauti fokiti lawoko Goti umamo ya geneti loboti miguti kobina olu leya enami neta-mata mona-mona ya umafa, ido neta kula nemo, efe limo mona ido seti-muludi Goti umunawamo mona ya fulitae. Efe limo mona ido seti-muludi Goti umamo monaki melamo neko, ido neta Goti umamo mona melamo yaki fulitámamo neko, ya fa u yalo efe lagi ne. ");
INSERT INTO snp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aiyo, linate Falisi we yate mono numugu dinawamo ya folomo komu nedo minenune, loti koli-koli o minoti, ido maketilo ya wenena leyeti aiyo-koiyo lolumunawae, loti kolanako, yamu lifima ka naba-naba itibiti olunawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aiyo, linate ya kono auma mika lulau falukuto neto wenena kolámoti mulalo moinamo eba yaidana oti minanako, lifima ka naba-naba itibiti olunawamo ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eti lito, lo melami ka katoti kolife lamo we minaguti we makafo itibito eti loto loumami, Api lilibanimo we, kamo ka etito lanimo yamo kulite yaki oluto lomane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Loumaito, Yesukafo itibito eti loumami, Ido linate lo melami ka katoti kolife lamo we yate wenena keina naba gimato, keina folamo ya neta ma mofu gedenune, loti ani olu faka lo gedámanako, lifima ka naba-naba itibiti olunawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aiyo, linate ka keina naba-naba kolinagilae. Autige-mota kolofati yate polofete ya gini folato, ido linate gini folamo yamu koliti, kiniba ekeina oluti kale li gedamo ebani olu lalo o minamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Etiti linate yate autige-mota kolofati gini folamo monanina ya lalole, loti lae. Eti lato, amo yate polofete gini folato, ido linate ya polofete kono aumanido numuna ku gedamo ne. ");
INSERT INTO snp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Etito nenako, Goti ka manenau nemo we yakafo eti loto limo, Polofeteki ido aposoloki amodoka gilifi meloneto enawae. Gilifi meloneto enawamo maleka ya gini fulunawamo ne. Ido maleka ya olu keina koli gedenawae, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ido mika kosina olu oloto piyami kamenaloti polofete muki gini folamo wanuni yamu lifima ka ya kamena oiya ama minamo wenenadoka ya fede giminami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Etito Abeli ofo folami kamenaloti gini fulumo uti uti Sekalaiya ofato folami kamenalo wamo ne. Wewa ya felegaga kuliyai numuna nabaki ido Goti yokila ki umamo folomoloki muliti yalo minaido ofo folamo ne. Ka ona lowe. Lifimawa ka muki ya kamena oiya ama minamo wenenadoka ya fede giminami ne. ");
INSERT INTO snp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aiyo, linate lo melami ka katoti kolife lamo we yate mono ka koli fuli lotone, loti mono ka kolife loti kolinawamo kanu-wela witi kuti enawamo neta ya oluti wae. Linanimo kanu-welau idámoti, ido we wena dito mono ka kolinune, loti lamo wenena ya kanu ku gede itanako, yamu linate lifima ka naba-naba itibiti olunawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kawa eti loto logimito wimo Falisi weki, ido lo melami ka api gilibamo weki olu kuwolafo bulu edeti, moila fi umuti, ilulu kuti loga-miga o edeti, ");
INSERT INTO snp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","welaloti efe ádami ka ma lito olu kalo mele edenune, loti kiyaba o minae. ");
INSERT INTO snp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ena wenena mau naba-naba tausenitauseni minamo ya amodoka o fedeti liti-liti loti kiyanido leya wi minae. Eti o minato, Yesukafo apito ege-ege moinamo we komu eti loto logimami, Linate ya Falisi monabi lele wiyamo monani ya yisi yaidana oto nemo ya koti kiyaba oti moinalo. ");
INSERT INTO snp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ido neta muki falukuto nemo ya aiga oloto pi gedeto ido neta asa wiyami nemo neta muki ya oloto pito gilibinami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ido siniku ka lamo ya fo lido yalo kawa lamo yama kolinagilae. Ido numugu lulau sodoto kanigu ka lamo ya numuna obito yalekati lo oloto melato kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aunefo-motao, ka logimowe, Linate ya ukadi gini fulunawafa, ido kofa olu kopa o gedeti ogoufámamo wenena ya kolini kolámalo. ");
INSERT INTO snp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kolini kolámafa, ido ma koliya kolinawamo ya gilibinagolowe. Wewa yakafo ya ukadi gini fulutoto lowau gitufunami aumala ya mino edami wewa koliya ona kolalo. Ona lowe. Koliya kolalo. ");
INSERT INTO snp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ena nema somo faifu (5) meinala ya kefo efema ne. Etito nefa, Goti ya nemawa lawokoti yaidana u kala melámenami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ido linate ateni yowala muki ya moda katotami ne. Koli kolámalo. Omunalo ya linate wenenala minamo nema somo muki ya olu fulo gedamo ne. ");
INSERT INTO snp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ido ka logimowe. We makafo wenena onobanido kuline lo oloto melenami we ya namo We Kula yakafo ayaidana oto Goti enisolela onobanido ya kuliya lo oloto melenae. ");
INSERT INTO snp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ido we makafo wenena onobanido meya numuto eyámomo ne, lenami we ya Goti enisolela onobanido ya mene umuto eyámomo ne, loto lenamo ne. ");
INSERT INTO snp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ido we makafo namo We Kula ya kamane kinami we ya lifimala kilili enagolifa, ido we makafo Ouna Felegaga kamana kinami we ya lifimala kilili o edámenami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kolalo. We mate ani-kiyanido oluti olu kiki loti ika oti gilimiti mono numuna kanisole mau wiyagufe, ido kiyabani we wenaba ido kiyabani we mau wiyagu enawamo, ya ka lolomato nediye loto itibito logiminumo ne? Ido ka egaidana oto lenumo ne? loti kati ligi-ligi kiyámalo. ");
INSERT INTO snp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","E’e, aya kamenalo yalo Ouna Felegaga yakafo ka logiminawamo ka ya api gilibinami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ido wenena mau wiyagu yauti makafo eti loto limo, Api lilibanimo we, kamo loumageto yanefokafo neta iya ku ledami neta iya meleto filiga ya namo numunaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Loumaito, Yesukafo itibito loumami, Aiyo, kemakafo ka olu efe-efe lo gedenamo wefe, ido muliti we bulu nedaiye? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ido ka ma eti loto logimami, Koti moinalo. Neta-mata maki maki olunumolae, loti kolamo mona muki yauti ma meletenune, loti koti kiyaba oti moinalo. Wenena mikalo ama minoti neta-mata naba ko namo netanina yamo kofawa minamo mona gimámenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ena kepa ka ma eti loto logimami, Ena ko nami we ma mikala lalo nenako, kulawa nabanaba liyaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kulawa liyami ya eyeto eti loto kala kiyami, Nedi enae? Eba minámainako, egau kulawa olu mau winae? loto kala ki minaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kala kitoto eti limo, Eti enae. Numune ya lukoto kofawa olu naba ito kuto kulawane muki ido koukamene muki meloneto minenaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ido nanimone ya kane eti loto kolinae. Namo netane-matane naba ya melege so loto unaifa, faifa minenagolinako, namo ya sodoto use loto minoto, nonanone noto, wene-netati noto, alikani o-o enagolowe, loto kolowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Eti lifa, ido Gotikafo eti loto loumami, Ka manegau minámami we, onema luwaila folageto kamenaka ya fuli lenagoliye. Ena netaka-mataka moda olu mau wito melemo idanimo ya kema netala bulunaiye? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ayaidana oto we makafo aimolamu kolito netala-matala moda olu mau wito melemo dinami we Goti omunalo ya u neta ko ánami we ona bulunami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ena Yesukafo ege-ege moinamo we eti loto logimami, Kolalo. Linate ya fulutenune, loti ya konuma-kobina nenawamo netamu koliti ido ukadi yamu koliti ukadelo owo ya nena neta winumo ne? loti kati mumudi ya kiyámalo. ");
INSERT INTO snp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Omude kofawa minonimo mona yakafo wete-neta ya olu fulo edami ne. Ido ukade yakafo ukadelo owo ya olu fulo edami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nema yamu kati kife lalo. Amo ya ufa neta ya kifámamo ne. Ido kulawa liyami ya doilámamo ne. Ido numugu ya weni-neta mau witi melámamo ne. Eti ámafa, ido Gotikafo weni-neta moda gimi-gimi imo ne. Kolafe? Linate ya moda nema ya olu fulo gedeti minae. ");
INSERT INTO snp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ido linate minagu yauti ya kemakafo aimola kala mumudi kiyaidoti ya omuna kofawa mino oluto unami kamenala ya kefola maki enu wito minomo unami ne? ");
INSERT INTO snp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ido netawa kefola neta efe yaidana olu efe lenawamo ogoufámoti, ya neta liliga yamu nediti kati mumudi ki minae? ");
INSERT INTO snp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ido kofuku neta ugawa imo yamu kati kife lalo. Ugawa yakafo lono olámoto ukanalo owo olufe ádami ne. Etito olufe ádaifa, ido ugawa yakafo Yuda wenena kiyabani we wekudi Solomoni ukanalo owo lalo-talo wiyami ya olu fulo edami ne, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ido Goti yakafo yuwa-nela ya onema neto ido leda ya fukoti yoku kinawamo neta ya etito olu egelamima nenako, yamu ya moda ayaidana oto kiyaba lalo o ledenagoliye, loti ya kolámafe? Aiyo, linate koli kikitina ya kefoko nemo wenena minae. ");
INSERT INTO snp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Linate konuma-kobina yaki, ido no yaki egaidana oto oluto nenumo ne, loti moni wiliti seti-muludigu nosámami koliti kati mumudi ya kiyámalo. ");
INSERT INTO snp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","E’e, aya netawa-matawa muki yamu ya ailo feka wenena yate moni wili-wili minafa, ido Metibo yakafo neta-mata muki ya linate olunawamo ogofunami neta ya moda koli minaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yamu linate ya Goti ya kiyabate we wekudi minenaiye, loti auma witi koliti seti-muludigu ya olu komu mele minaneyo. Eti enawamo ya netawa-matawa liliga muki yaki moda enu wito oloto pi giminagoliye. ");
INSERT INTO snp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ido linate mau kefola minamo ya koli kolámalo. Metibo yakafo namo wenenane kiyaba o gedomo yaidana oti wenena kiyaba o gedenawae, loto lalo kolito lonowa gimami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Koukametina ya kifanalo fuloti meina oluti neta ko ánamo wenena gimalo. Ido kifana kolinawamo owo fitala kiyámenami ya olalo. Ido kosinauka neta olu mau winawamo ya ugele we yate adu ámenagilae. Ido kanu sigefa yakafo ánenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Moda kolafe? Koukametina melenawamo ebau ya seti-muludi kati-manidi aumafofo loti aya ebau yako koli umunawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ena linate lonola olunune, loti ukanido owo ya olu kiki loti lamenatina kiti minalo. ");
INSERT INTO snp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ido lono we yate kiyabani we ya we wena anido olu gimiti konuma-kobina nadoka yati itibito oto kanudo kesoba wiyageto ayalo kanu wi edenune, loti kiyabala o minamo wenena yaidana oti minalo. ");
INSERT INTO snp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ido kiyabani we enami yakafo lonodo we ya auma witi kiyabala o-o minamo monanina geyeto lalo geyowe, loto lito alikani naba-naba enagilae. Ona logimowe. Kiyaba we yakafo ukanalo owo ya olu kiki loto neta no-no amo ebalo oti amedoti minato weni-neta giminae, loto logimito kouba-naba o gedenami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ido luwailafe, ido leda luwaila ya kiyabani we oto lonodo we auma witi kiyabala o-o minamo monanina geyeto lalo geyowe, lageto alikani naba-naba enagilae. ");
INSERT INTO snp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Etito nefa, kolife loti kolalo. Numuna aboga yakafo onema luwaila numuneu ugele we fukoti dinagilae, loto kolami neko, siniku ya kiyaba ageto fukoti idámagi ne. ");
INSERT INTO snp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ido linateki ya namo We Kula enamo kamenane ya kolámanako, yamu kiyaba otiko minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eti loto logimaito, Pitakafo limo, Wekolao, kamo kepa kawa lanimo ya lalimomuko labemo, ido mukimu lane? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Loga o edaito, Wekola itibito loumami, Ena lonodo we yauti kema yamo lono efe loto oluto ka manenau nemo we ne? Lono aboga yakafo wewa ya lonone olamo wenena muki ya kiyaba o gedeto weni-neta nenawamo kamenalo ya weni-neta iya meleto gimi-gimi enaiye, loto iyaina o edami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aiga lono aboga itibito oto lonodo we kawa loumaido meyalo meleto lono olu minami we eyageto ya lalo mino kolinagoliye. ");
INSERT INTO snp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Namo ka ona logimowe. Lono aboga ya oto netane-matane muki kiyaba o nedenaiye, loto koukamela muki ya lonodo we analo melenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Etito melenagolifa, ido lonodo we ya mona nosámenami meleto lono aboga we alako itibito ámenagoliye, loto siya-mulunau kolito auwafo-mota kouba-naba weki wenaki kefakafo ginito ido wela-neta noto no noto lula-kala olu kopa o-oto minenami, ");
INSERT INTO snp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ya lono aboga itibito enami kamenala yamu kolámoto, ido onema oiya ámunagoliye, loto kolaido, aya kamenalo yalo o fedenaiye. Fedeto lono aboga yakafo fuko-nako o edeto, koli kikitámamo wenena ebanigu ya ilifi melenaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ido lonodo we ya lono aboga kala kolaifa, neta olufe loto kala golo ádenami ya auma witi ofenagilae. ");
INSERT INTO snp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eti enagilafa, lonodo we ya lono aboga kala koli efe ádoto mona nosámami melenami ya kamena lina ofenagilae. Ido netamata muki gimami wenena ya amodokati netamata ma mulalo-mulalo ya itibiti numunawamo ne, loto kolito, ido neta-mata muki kiyaba o nedenawamo wenena ya neta-mata kiyaba o nedenawamo lono ma mulalo-mulalo ya giminae, loto kolami ne. ");
INSERT INTO snp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Namo omo ya wenena mikalo minado yo fulenae, loto omo ne. Fuloneto alako lenaiye, loto auma wito kolowe. ");
INSERT INTO snp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Etito kolofa, ido noku wi gedamo yaidana oti ya keina naba-naba yamo noku wi nedenagilanako, keina kolinagolowe. Netawa fuli ádenaido ya keina koli minowe. ");
INSERT INTO snp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Linate kolamo mikalo omo ya we wena ya olu you lo ledenae, loto aiye, loti kolafe? Etito minámaiye. Ona logimowe. Namo wenena ya olu kuwonibo-kuwonibo o gedenae, loto omo ne. ");
INSERT INTO snp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ido oiya ama kamenalekati wenena faifu (5) ya numuna lawokoku minamo yama ya fokiti u ailo-ailo wato, wenena filiga tili (3) ya minamo yate wenena liliga lele (2) minamo ya kuwonibo-kuwonibo u bulu gedenawae. Ido lele (2) yamate wenena liliga tili (3) yama kuwonibo-kuwonibo u bulunagilae. ");
INSERT INTO snp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Etiti u ailo-ailo uti ya melafo yamo nalafo kuwolafo bulageto, ido nalafo yamo melafo kuwolafo bulu edenami ne. Ido olafo yamo olulafo kuwolafo bulu edenami ne. Ido olulafo yamo olafo kuwolafo bulu edenami ne. Ido aula-ilofo yamo onofula kuwolafo bulu edenami ne. Ido onofula yamo aula-ilofo ya kuwolafo bulu edenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesukafo wenena naba mau minamo eti loto logimami, Linate ya kosinalo limu kuwami ya eyetima, ko winagoliye, loti lo-lo ato ya moda eti iye. ");
INSERT INTO snp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ido epe ya maukati oto epe fu-fu litoma, fo lenagoliye, loti lo-lo ato ya moda o-o ima ne. ");
INSERT INTO snp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Linate monabi lele wiyamo wenena, aya mikalo kosinalo mebe-maba oloto piyami ya etiti kolife loti kolama nefa, ido oiya ama kamenalo mebe-maba ma oloto piyaito ya eye minamo ya egaidana oti kolife loti kolámae? ");
INSERT INTO snp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Linanimotina ya mona efe limo ya nediti iya meleti kofe ádae? ");
INSERT INTO snp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ido kamote kuwokafote ka olu efe lo-lo amo numugu unawaido kanudo yalo ka lalo loumageto, seti-muludi lawoko meleti, ka olu efe lo-lo ami we analo melageto kimiwe yate nela wi kedeti nela numugu yau fulo nedetenawae, loto seti-muludi lawoko melailo. ");
INSERT INTO snp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka ona logimowe. Lifimaka kifana muki ya itibito giminanimo yako ya nelauti fuli loto lumunagolane, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aya kamenalo ya wenena maleka yalo minamo yate Pailatikafo kimiwela gilifi melaito uti Galili wenena ma yokila kinawamo minadoka uti gini folamo ka ya Yesu loumae. ");
INSERT INTO snp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Loumato, amokafo itibito logimami, Aya Galili wenena netawa keina imo kolamo yamu lifimanina yakafo Galili wenena liliga muki lifimani ya olu fulo edaiye, loti kolafe? ");
INSERT INTO snp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","E’e, moda etito minámaiye, loto logimowe. Etito minámaifa, ido seti-muludi olu eleyapa wiyámenawamo ya linate yaki ayaidana oti u kopa unagilae. ");
INSERT INTO snp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ido we eitini (18) ya Silowamu numudo minamo numuna fana-fana yakafo lumu fou loto gini folami we lifimani yamamo Yelusalemu minamo wenena muki lifimani ya olu fulo edaiye, loti kolafe? ");
INSERT INTO snp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","E’e, moda etito minámaiye, loto logimowe. Etito minámaifa, ido seti-muludi olu eleyapa witi melámenawamo linate yaki ayaidana oti u kopa unagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ena kepa ka eti logimami, Yá ade ma migu neto ya aboga yamo minau uto, ade liyami ya moni wilinae, loto moni wilaifa, olu oloto piyámaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Olu oloto piyámaito, mina kiyaba imo we eti loto loumami, Melege tili (3) yalo yá adewa nedo oto kula moni wili-wili minofa, olu oloto piyámowe. Yamu fukoto fulito. Mine mika aumala faifa notenaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Loumaito, mina kiyaba imo wekafo itibito loumami, Wenabao, melege lawoko ma yáwa koitageto faifa minageto, mika monau ya kofuto mika winagolowe. ");
INSERT INTO snp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ido melege lawoko ma wageto, ilawa linaife, ya kenaliye. Ilawa liyagetoma, ya lalo minenagolifa, ido ilawa liyámagetoma, ofo fukenaliye, loto loumaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ena Sabati foliku Yesukafo mono numuna malo api gilibi minaito, ");
INSERT INTO snp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","yalo moda wena ma nemo Satani kimiwela melege eitini (18) ya mino edeto olu neta kili edaito, meya nosámami kuba witoko nemo, nedito efe loto moninami ya ogoufámaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ena Yesukafo wenawa eyeto eti loto loumami, Namodo ano, lito kolito aito eti loumami, Wenao, neta kilanimo yama moda apaso kedowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Loumuto anakafo manenalo olaito, ayalo meya ya efe lito, nedito, efe loto monito, Goti ebola lo minaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ena mono kiyaba wekafo Yesu Sabati foliku wenawa olu faka lo edami yamu siya kala-kala lito wenena minamo eti loto logimami, Kolalo. Lono kamena ya sikisi (6) ya ne. Etito nemoma nenako, neta kilamo ya olu faka lo ledenaiye, loti lenawamo ya lono kamenalo yako alo. Ido Sabati foliku yalo ámalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eti loto logimaito, Wekolakafo itibito loumami, Monabi lele wiyamo ya minae. Linate muki Sabati foliku bulumakautife ido yafotina-dogi nelauti efiliti no nenawae, loti gilimiti nolo u-u afe? Olo. ");
INSERT INTO snp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yamu Abalahamu ufa fiyaigu yauti minami wenawa ya Satanikafo kamena fana melege eitini (18) yalo nela wi edemo wimo ya Sabati foliku ya nela wi edami neta yati olu efilitomo ya ufe ádaife? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kawa logimami ya koliti kuwolafo-mota ukanido koli minato, ido wenena muki ya neta-mata lalo imo yamu alikani naba-naba o minae. ");
INSERT INTO snp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ena Yesukafo eti loto loga o gedami, Goti wekudite wenenala kiyaba o ledami monala ya nena neta yaidana oto ne? Nena netalo olu meleto lenae? ");
INSERT INTO snp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kolipa ilawa ya we makafo oluto uto minau kifami yaidana oto ne. Kifaito, fou loto dito dito aiga yá kolipa naba oloto piyaito, nema-afa kosinalo u moni-moni amo ya oti akawalo mino-mino amoma ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ido kofa ya loga o gedami, Goti wekudite wenenala kiyaba o ledami mona ya nena netalo olu meleto lenae? ");
INSERT INTO snp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Netama ya beleti olu fudenami neta kuliya yisi yaidana oto ne. Wena ma beleti ofo kinagolowe, loto yisi oluto palawa naba yaki olu kofu-nafu ito yau ya yisi yamo lono oluto neta muki ya olu fudodo imo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ena Yesu Yelusalemu unae, loto monimo wimo ya numuna meya nabaloti ido kefolati yaki uto mono ka api gilibimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Etito makafo eti loto limo, Wekolao, wenena mau kefomako olu omuni kenaife? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Loga o edaito, itibito limo, Linate kanu kefolau dinune, loti kolinawamo koiya naba ya fiyalo, loto logimowe. Yamu wenena mukite dinune, loti lenawafa, ido ogoufámenawae. ");
INSERT INTO snp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ido numuna aboga namo nedito kanu moda kunamo kamena fedenami yalo linate feka minoti kanu kesoba wi minoti, eti loti wako lo nedenawamo, We nabao, kanu wi ledo, loti lonumunawafa, ido namokafo itibito logiminamo, Linate ya geyefe loto geyámowe. Ido numuna ebati yaki ya ágowe, loto lenagolowe. ");
INSERT INTO snp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eti loto loneto linate yate eti loti lonumunawamo, Kamoki lakoina wetenetati ido nonanoti nonima ne. Ido numude kanutelo yalo mono ya api lilibi-lilibi anima ne, loti lonumunawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eti loti lonumunawafa, ido itibito logiminamo, Linate ya geyefe ádowe. Egalekati wenena minae? Linate nosámami monako mele-mele amo wenena muki ya fulo nedeti faiga walo, loto logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eti logimoneto, ena Abalahamu, Aisaka, Yekopu, ido polofete muki ya Goti wekudi wenenala kiyaba o ledami ebala yalo minato linate geyenawafa, ido linanimote ya fulito gedanako, yamu feka minoti, kufu au-au loti, weni kofala uguti minenagilae. ");
INSERT INTO snp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ena mika negu-negu filiga-filiga yaleka-waka yalekati wenena oti Goti wekudi wenenala kiyaba o ledami ebalau diti weni-neta nenagilae. ");
INSERT INTO snp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ido wenena oiya kulinigi we minamo ya aiga kulini ya lumunami ne. Ido oiya kulini lomami wenena ya aiga kulinigi we minenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aya kamenalo Falisi we mate Yesu nedo oti loumamo, Helotikafo kofenae, loto kolami yamu mika ama fulito eba malo wo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Loumato, amokafo itibito logimami, Linate itibiti uti wewa kula-fadena ya eti loti loumalo, Koli minabe? Moda onemaki ido ledaki Satani kimiwela mino gedamo gilifi melemo uto, wenena neta kilamo olu faka lo gedomo woneto ido fo kamena tili (3) wageto lonone ya fuli lenagoliye, loti loumalo. ");
INSERT INTO snp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ido namo ya onema ya monimo uto, leda yaki monimo uto, oko yaki monimo unagolowe. Ya neditole? Yelusalemu kilala feka yalo polofete ma ofo folámenawae. E’e, Yelusalemu numudoka yako nofo fulunawae. ");
INSERT INTO snp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aiyo, Yelusalemu wenenao, Yelusalemu wenenao, linate polofete gini fulu-fulu o minae. Ido linanidoka gilifi melami we ya kifanakafo gini fulu-fulu amo ne. Ido okolofokafo momola olu mau wi gedeto okanakafo olu fito gede-gede imo yaidana oto kamena mumudi namokafo linate kemaneu olu mau gedenae, loto kolofa, ido eleka fimo wae. ");
INSERT INTO snp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Eyalo. Numudi meya ya fulito edenaiye. Ido linate kofa neyámoti monimo uti uti, Wekola kuliyalo ami we ya lalo kolimo wimo ne, loto ka mono lufuwau (Sng 118:26) nemo ka lenawamo kamena yalo ya kofa neyenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ena Sabati foliku malo Yesu wene-neta nenae, loto Falisi kuliya nemo we ma numunau idaito, auma witi eye minae. ");
INSERT INTO snp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eye minato, moda omunalo we ma ana-kiyana fudimo ya neto ");
INSERT INTO snp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesukafo eyeto ya Falisi weki ido ka lo melami ka kolamo weki eti logimami, Sabati foliku olu faka lo edenuwe, loti lenawamo ya lo melami ka fukenawafemo, ido fukámenawae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Loga o gedaito, ka ádoti minamo yamu anakafo neta kilami we oluto olu faka lo edeto ilifaito wiye. ");
INSERT INTO snp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wito, ena eti logimami, Kani kiyalo. Linate yauti we ma nalafofe ido bulumakaulafe ya Sabati foliku ya kale fana no negu yau lumu fou lenami ya wewa yamo alako olu faka lo edámenaife? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","itibiti loumunawamo ka ya minámaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ido Yesukafo wenena weni-neta nenune, loti amo wenena yate folomo konido oloto nemo folomolo yaloko minenune, loti kolamo ya geyeto kepa ka ma logimami, ");
INSERT INTO snp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","We makafo nalafo wena olageto wete-neta ya nenagologe. Kamo ano, loto kamodoka ka fulo kedeto, ido we ma kuliya nemo kulika olu fulo edenami we yaki ka fulo edetoma, ");
INSERT INTO snp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kamodoka oto, Folomoka ya we ama ya umo, loto lokomageto ukagalo kolito uto faifa wenena ebanido yalo minotenae, loto folomolo konido oloto nemo yalo amedámo. ");
INSERT INTO snp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E’e, ano, lokomagetoma, kamo uto faifa wenena ebanido yalo minenanimo ya weni-neta aboga kamodoka oto lokumunami, Wenenane, oto folomo laloto yalo minenane, loto lokumunami ne. Eti lokumunami aya kamenalo ya wenena muki omunido ya kulika dinami ne. ");
INSERT INTO snp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Etito makafo aimola kuliya oluto dinami ya Gotikafo ya kuliya oluto lumunami ne. Ido makafo aimola kuliya oluto lumuto moni minenami ya Gotikafo kuliya olu akaiya o edenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ido Yesukafo wela-neta aboga eti loumami, Ena folilofe, ido lunagafe, weni-neta naba ofo kitoma, yowoka-motafe, ido atekafo-motafe, ido wenenakafe, ido wenena adu minoti neta ko namo wenenafe, wete-neta nenuge alo, loto ka fulo gedámo. Alo, logiminanimo, ya itibiti lokumunawamo, Kamo ya lamoki lakoina nenane, lato, lifimane fuli lotenaiye, loto alo, logimámo. ");
INSERT INTO snp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E’e, weni-neta naba ofo kinanimo ya neta ko ánamo wenenati, kebili siyamoti, ido kiyani-ani nosámami wenenati, ido omuni likami wenenati, Alo, loto ka fulo gedo. ");
INSERT INTO snp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Etito ka fulo gedenanimo ya lalo koli minomo unagolane. Ido aya wenenawa itibiti lifima kumunawamo ya ogoufámanako, yamu efe limo mona melamo wenena folaguti olu nedi gedenami kamenalo ya lifima itibito kumunaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ido Yesuki lakoina amedoti weni-neta no minamo wenena minagu yauti we makafo kawa kolito eti loumami, Goti wekudi wenenala kiyaba o ledami ebalau diti ya weni-neta nenawamo wenena ya kolomo lalo koli minomo unagilae, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eti loumaito, Yesukafo itibito limo, We makafo wenena muki weni-neta ofo ki gedoneto nenawae, loto enawamo kamena ya mele gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ena neta-mata muki ya olufe lo fuli loitami kamena yalo ya wenenadoka ya kouba-nabala we ilifaito uto eti loto logimami, Neta-mata muki ofo kitae. Alo, logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eti logimaifa, wenenawa muki ka ailo-ailo loti ámunawamo ka lae. Eti lato, we makafo eti limo, Namo oiyako mika ma meina fiyomo nenako, yakafo ika o nedaito kenae, loto wowe. Yamu kamo wenaba nedoka uto loumageto kawa ya kolinami nosámenaife? loto ya liye. ");
INSERT INTO snp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ido makafo limo, Namo oiyako bulumakau teni (10) ya meina fiyomo nenako, uto lono olunawamo kepa meleto enagolowe. Yamu kamo wenaba nedoka uto loumageto kawa kolinami nosámenaife? loto ya liye. ");
INSERT INTO snp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ido mamakafo limo, Namo oiyako wena olomo yamu ámunae, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Etito kouba-naba we yakafo itibito uto, we nabala kawa lamo ka ya loumaito, kolito numuna aboga siya kala-kala lito, kouba-nabala we eti loto loumami, Kamo alako numuna meya nabau uto kanu kofalalo ido kanu kefolalo ya monito neta ko ánamoti, kebili siyamoti, omuni likamiti, kiyani nosámamiti gilimito ano, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eti loumaito, kawa kouba-nabala we kolito, ayalo meyalo meleto itibito oto wenabala ya eti loto loumami, Wenabane, kamo ka lanido ya meyalo meleto gilimito ofa, ido eba maleka ya faifa ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eti loumaito, we nabala ya eti limo, Yamu numuna meya fulito uto kanu kofalalo ido migu kanudo ya monito wenena minenawamo ya auma wito gilimito ageto oti numuneu faitenawae. ");
INSERT INTO snp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ena logiminagolowe. Wenena komu ka fulo gedeto weni-neta ofo ki gedomo ya ma ánenawamo ne, loto liye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ena wenena mau naba minamo ya Yesu ege wato, eleyapa wito eti logimami, ");
INSERT INTO snp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","We makafo namodoka oto olafo, melafo, olonafo, nomilipala, yalafo, kunalafo, ido aimola omuna kofawa minenami mona yaki meya gimámenami ya nege melenami ogoufámenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ido yá yofola mofuto nege melámenami we ya nege melenami ya ogoufámaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kati kife lalo. Linate minagu yauti we makafo numuna naba ma kunae, loto lenami ya komu amedoto meinala kolito kifanane ogofunaife? loto kifanala katenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eti ámenami, numuna folomo wilinaido kifanala fuli lageto numuna ku fuli lenami ogoufámaito, wenena muki netawa eyeti ya kamana kinawae. ");
INSERT INTO snp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kamana kiti ya eti lenawamo, Wewa ya numuna apito ku fuli lenami ya ogoufámaiye, loti lo edenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ido mikalo kiyaba we wekudi makafo mikalo kiyaba we wekudi maki lowa finune, loto lenami ya komu amedoto mau wiyamo kimiwela teni tauseni (10,000) yate kuwolafo kimiwela tuwedi tauseni (20,000) enagilamo ya olu fulo gedenubemo, ido olu fulo gedámenune? loto kala kinaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ido olu fulo gedámenune, loto kolitoma, kuwolafo faiga minenami kamenalo inateki egaidana oto olu kutifinune? loto ka fulo edenae, loto wenenala kuwolafo nedoka gilifi melaito unawae. ");
INSERT INTO snp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ido ayaidana oto linate yauti makafo netala-matala muki ya meya umámenami ya nege melenami ya ogoufámenaiye. ");
INSERT INTO snp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kolalo. Kuwo ya neta leya imo nefa, leyala fuli lagaiyama ya egaidana oto kofa leya enami ne? ");
INSERT INTO snp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lonola fuli limo ne. Etito kuwowaki ido bulumakau sefeki mikau ya olu eleyapa wito neta kifámenagolone. Faifa fulitone. Linate katina nemo wenena ya kawa kolife loti kolalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ena kifana takisi olu-olu amo weki ido mona nosámami mele-mele amo weki muki Yesu kala kolinune, loti amodoka oti ogona o ede minae. ");
INSERT INTO snp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eti o minafa, Falisi weki ido lo melamo ka api gilibamo weki yate Yesu koli nosámami umuti eti lamo, We ama ya mona nosámami mele-mele amo wenena yaki koina wi gedeto lakoina no-no o minae, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eti lato, ena Yesu ya kepa ka logimami, ");
INSERT INTO snp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kolalo. Linate minagu yauti we makafo sipisipila wani hadeti (100) minaguti lawoko ma ya fuisageto liliga nainti-naini (99) ya faifa nemo ya yuwa namo ebalo fulo gedetoto uto fuisamima ya moni wilimo uto uto olu oloto pinami nefe? ");
INSERT INTO snp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Olu oloto pito alikani naba-naba oto eyauto ");
INSERT INTO snp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","numudoka itibito enami ne. O fedeto auwafo-motaki ido wenena adu minoti ekelamo wenenalaki olu mau wi gedeto eti loto logiminami, Sipisipine fuisamima ya olu oloto pitowe. Yamu namoki lakoina alikani naba-naba enune, loto lenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ido ka logimowe. Kosinauka minamo yate ayaidana oti lifima mino edami we lawoko makafo siya-muluna olu eleyapa winami, alikani naba-naba o minae. Ido alikani naba-naba enawamo monaniwa yakafo wenena nainti-naini (99) mona efe limoko mele-mele onimo nenako, sete-mulude eleyapa wiyámenune, loti lenawamo yamu alikani amo mona ya olu fulo edaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ido wena makafo kifanala siluwa teni (10) nemo yauti lawoko ma fuisaito feiya kito numugu ya moita kilito esama-masama oto moni wilimo uto uto oloto pinagolife? ");
INSERT INTO snp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oloto pitoto wenawa ya auwafo-motaki ido wenenala adu minamo yaki olu mau wi gedeto logiminami, Kifanane siluwa lawoko ma fuisami yama olu oloto pitowe. Yamu namoki lakoina alikani naba-naba enune, loto lenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ido ka ma logimowe. Ayaidana oto Goti enisolela omunido lifimala nemo we makafo siya-muluna olu eleyapa winami, alikani naba-naba o minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesukafo ka ma enu wito logimami, We ma nalafo lele minami ya ");
INSERT INTO snp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","aiga kedami kipa yakafo melafo loumami, Netaka iya ku nedanimo yama nomo, loto loumaito netala iya meleto nalafo lele gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Netala nalafo gimaito kamena lina efe lako minoito aiga kedami kipamakafo netala-matala muki olu mau wito oluto eba ma faiga mauka uto yalo iya ku edami netala muki kifanalo fuloto mona nosámami meleto monito kifanala fulo fuli liye. ");
INSERT INTO snp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kifanala koukamela muki ya fuli loito minaito mika yalo kadunamu naba oloto piyaito, Wene-neta ma minámainako, kadunamu fulutenae, loto ");
INSERT INTO snp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","aya ebalo wenena ma nedo uto lonoka olunae, lito, Yafone weni-neta umuto kiyaba o, loto yalo fulo edaito yafola kiyaba iye. ");
INSERT INTO snp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yafola kiyaba oto kadunamu folaifa, we ma wela-neta umámainako, yafo weni-neta ya noneto mune enaiye, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Eti loto kolito oku onaiguti ega-maga oito nedito eti loto kala kiyami, Menefo koubanabala we muki ya konuma-kobina noti minamo leiga neta so loto nemo nefa, namo ya kadunamu fulu minowe. ");
INSERT INTO snp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Etito nemoma nenako, menefo nedoka itibito uto eti loumunae: Menefo, namo ya kosinau minami wete kamote mona nosámami mele gedomo yamu lifimane ne. ");
INSERT INTO snp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yamu nanefo ne, loto lenanimo ya efe ádenami ne. E’e, kamo lonokalo kouba-naba wele, loto fulo nedenane, loto kala kito ");
INSERT INTO snp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","nedito melafodoka wiye. Wimo ya melafokafo faigati eyeto mulunau milumala naba kolito nalafodoka oluloto uto abusa wito mudo edaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mudo edaito, nalafokafo loumami, Menefo, namo kosinau minami we ya mona nosámami mele edeto ido kamo omugalo mona nosámami mele kedomo yamu lifimane ne. Yamu nanefo ne, loto lenanimo ya efe ádenami ne, loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","melafokafo kouba-nabala we eti logimami, Kenemane oti ukanalo owo lalo-talo ukanido owo maleka olu afima o edami yama oluti oti ukanalo wi edeti, analo ekeina neta lalo wi edeti, kiyanalo neta yaki wi edalo. ");
INSERT INTO snp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Etiti ya uti bulumakau dunuma fiyami ya oluti oti ofo kuwato alikani oto nenune. ");
INSERT INTO snp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nanefowa ama yamu moda folaiye, loto loma nefa, kofa neidaiye. Ido fuisaito kofa olu oloto piyowe, logimaito ena apiti alikani oti noti minae. ");
INSERT INTO snp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Eti o minato, nalafo komu kipa ya lonogu minaiguti oto numuna lega adu ya o fedeto nema loti melege olamo ya kolito ");
INSERT INTO snp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","kouba-naba we ma lula fito eti loumami, Nedi-nedi ae? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Loga o edaito, eti loumami, Kunakafo folámoto itibito aito metibomakafo bulumakau dunuma fiyami ma ofoto ku edaito noto minone, loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Eti loto loumami ka ya kolito siya kala-kala lito lukafa oto numugu idámenagolowe, lito melafokafo kolito numunauti lumuto loumami, Numugu ido, loto kala fi minaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kala fi minaifa, amokafo eti loto melafo loumami, Kolabe? Melege so loto kouba-naba o kedeto ido kakalo kamena lawoko ma olu fulámomoma ne. Nefa, ido kamo ya meme momolati ya yaidana oto nomageto wenenaneki minámo-minámo onima ne. Ona moda eti ámanima ne. ");
INSERT INTO snp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eti ámanima nefa, ido nakafo ama ya netaka-mataka oluto monito wenaipa nomilipa kopa olu ono-ono oto gimi fuli loto kofa itibito aito ya kamo kala kolito yafoka-bulumakau momola dunuma fiyami ya ofo ki edane, loto eti loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eti loumaito, melafokafo limo, Nanefone, kamena-kamena namote minomima nenako, namo netane muki ya kaimo netaka ne. ");
INSERT INTO snp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Etito nefa, onema ya sete-muludeu lalo kolokele. Aya kunakafowa ya fulutaima nefa, onema kofa neidaiye. Ido u kopa utaima nefa, onema kofa olu oloto piyone, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesukafo ege-ege moinamo we ya ka eti logimami, Neta ko nami we ma nedo oti koukamela kiyaba we yamu koukameka moda fulaiye, loti lodobe fiyae. ");
INSERT INTO snp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yamu namodoka ano, loumaito aito loumami, Kamomu lo kede minamo kawa ya kolowe. Koukamene kiyaba we minanimo lonone ma kofa olámenane. Yamu kifana oluto ido kifana fulitanimo mona ya olu oloto pi nomo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Eti loumaito, kiyaba wekafo kala mumudi kito ya nedi-nedi enae? We nabanekafo lononelo yaloti olu fulo nedainako, migu lono olunafe? E’e, aumane minámainako. Wenena wako logiminafe? E’e, eti enamo ya ukanelo kolinagolowe. ");
INSERT INTO snp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aiyo, wenabane nilifageto wenenate wene-neta nomato, numunigu onoto nedito enamo yamu neta enae, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eti loto kolito, wenabala netala lifima olu umamo wenena muki alo, lito ya kala koliti ato, komu ami we ya kiyaba wewakafo loumami, Kamo wenabanedokati netala olanimo ya kamodoka lifima nenaki ne? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","namodoka ya yá olifi nowala dalamu wani hadeti (100) yaidana nemo moda notowe, lito ya eti loumami, Amodokati neta olanimo lufuwa ya oluto, kenemaneto amedoto dalamu fifiti (50) yako olu oloto meleto lufuwa wiyo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ena aiga ami we ya loumami, Wenabane netala olanimo ya neta nenaki uma fiyámanimo ne? loto loga o edaito, itibito loumami, Yuwa witi beki naba wani hadeti (100) ya moda notomo ne, lito eti loto loumami, Uma fiyámanimo neta lufuwa wiyami ya oluto, amedoto yuwa witi beki naba eitiko (80) ya ne, loto olu oloto meleto lufuwa wiyo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ido koukame kiyaba we kaila imo mona melami we ya ka manenau nemo yaidana oto kala kiyainako, wenabala yakafo ebola limo ne. Yamu ama mikaleka monamu kolife loti kolamo wenena ya inanimo ani olu faka lenawamo monaninakafo wenena lamedo minamo ya inanimo ani olu faka lenawamo monani ya olu fulo edaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kolalo. Linate ama nosámami mikalo kifana-koukame ko namo neta yakafo wenena koina wi gedalo. Eti ato kifana-koukameti fuli lenaido ya minowa-minowa oti minenawamo ebau ya koina wi gedenawae, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Makafo kefo-afola neta kiyaba lalo oto olu minenami ya ayaidana oto neta-mata naba yaki kiyaba lalo enagoliye. Ido makafo kefola-afola neta ya koto kiyaba ámenami yakafo ayaidana oto neta naba ya kiyaba ámenami ne. ");
INSERT INTO snp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Etito nemo nenako, kamo ya kifana-koukame ama mikalo ya kiyaba lalo o edámenanimo, kemakafo neta ko nami netala ona kula ya kiyaba o nedenane, loto agalo melenami ne? ");
INSERT INTO snp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ido kamo ailo wenena koukamenina ya kiyaba lalo ámenanimo, kemakafo kaimoka netaka ne, loto koukame komageto olu minenanimo ne? ");
INSERT INTO snp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","We makafo wenaba lele ya kouba-naba o gedenami ya ogoufámaiye. Eti enae, loto kolinami ya wenabala ma ya eleka fi umuto, ido ma ya siya-muluna umunami nefemo, ido malo ya u ekeleto, ido ma ya fulo edenami ne. Ayaidana oti linate Goti ido kifana-koukame mikalo neta-mata ya olu lawokoiti kouba-naba o gedenune, loti kolinawamo ya ogoufámae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ido Falisi we kifana ya seni-muluni umamo we yate Yesu kawa limo ya koliti kamana ki minae. ");
INSERT INTO snp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eti ato, amokafo eti loto logimami, Linate ya wenena omunido efe limo mona melonimo wenena minone, loti monabi lele wi minafa, Gotikafo seti-muludigu kani kiyamo monawa ya koli minaiye. Ido wenena yate neta ma kuliya oluti di minamo neta ya Goti omunalo ya fitala kiyami neta yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kolafe? Lo melami ka, ido polofete kanina ya lo oloto melemo uti Yoni minami kamenalo ya wae. Yaloti Goti wekudi kiyaba o ledami kala kuwa lalo lo oloto melemo wato, Gotidoka unune, loti auma witi kolamo wenena muki ya koiya fiti lono olu minae. ");
INSERT INTO snp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ido aiga ya mika kosina fuli lenami ya faifa fuli lenagolifa, ido lo melami ka yauti ka kefo efemako ya u kopa ámunami ne. ");
INSERT INTO snp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ena we makafo olonafo fuko fulito, uto wena ailo olami ya kume-ugele naiye. Ido we makafo wena wanafo fuko fulitami ya wena olami ya kume-ugele naiye. ");
INSERT INTO snp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ido neta ko nami we ma nemokafo ukanalo owo kisiki kiyobaki meinala naba nemo wito, kamena-kamena wela-neta laloko no-no o minaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No minaito, ido we ma neta ko ánami wako o-o imo we kuliya Lasalusi ukana muki numuna limo we ");
INSERT INTO snp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","neta ko nami we wela-neta leiga ya fulenawamo oluto nenaiye, loti kila kanu welalo wenenalate olumo fulo edato, ono minaiye. Ono minaito, kula yate oti numuna lido kenabu-kenabu o edae. ");
INSERT INTO snp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ena aiga wako o-o imo wema folaito, enisolete ilimiti diti Abalahamu kemanau fulo edae. Ido neta ko nami wemaki folaito, kale li edae. ");
INSERT INTO snp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kale li edato, yo eifámenami yoku minoto ogofu naba-naba kolito ko faka loto yaleka faiga aufaito kami ya Abalahamute Lasalusite lakoina minami ya geyaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Geyeto Abalahamu eti loto loumami, Menefone, namo milumane kolito ya yoku ogofu naba-naba kolonako, oto ana gala noku fito wene kulumalo fili nedenaiye, loto Lasalusi namodoka ilifo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Loumaifa, ido Abalahamukafo itibito loumami, Nanefone, koli minane. Mikalo minanimo kamenalo ya netaka-mataka lalo ya moda olageto, ido Lasalusi ya netala-matala nosámami olaima nefa, oiya siya-muluna olu aila wi ede minoneto, ido kamo ogofu koli minane. ");
INSERT INTO snp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ido yako minámaiye. Filiga-filiga lamo minonido linate minado muliti yau kowo naba-naba failainako, wenena amalo minamo ya filigaleka ogofuti kamo minanidoka ya ámunagilae. Ido kamo minanidoka yati ogofuti lamo minonido ya ámenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ena itibito loumami, Menefone, ka ma lenae, koli nomo. Menefo numunau kunanefomota faifu (5) ya minamo ne. Amoki yo eifámenami eba amau ya lumuti ogofu naba-naba kolitenawae, loto Lasalusi ilifageto uto fuka ka logiminaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Etito loumaito, Abalahamu yakafo itibito loumami, Kunakafomota ya Moseseki polofeteki lufuwa wiyamo yama mino gedaima nenako, kolinagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eti lito, loumami, E’e, Abalahamu, menefone, etito minámaiye. We ma folaiguti nedito logiminami ya seni-muluni olu eleyapa winagilae, liye. ");
INSERT INTO snp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eti lito, ya loumami, Mosesete polofetete kanina koli fuliti minatoma, ido we ma folaiguti nedito uto logiminami ya ayaidana oti kala ya koli fulitenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesukafo ege-ege moinamo we eti logimami, Neta-mata mona-mona yakafo oto wenena ya olu nosámami mona melenawae, loto enagoliye. Eti enagolifa, we makafo etito olu lifima fede giminami we ya aiyo, lifima ka naba-naba itibito olunami ne. ");
INSERT INTO snp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaidana we yakafo wenenane yauti lawoko aumala minámami ma olu lifima fede umunae, loto lenami we ya ana-kiyanalo oluti, kenebalalo kifana naba-naba nela witi kuwo noku fulo edamo neko, moda lalo agi ne. ");
INSERT INTO snp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yamu linanimo monatina ya koti kiyaba otiko moinalo. Ido koinakafo makafo nosámami mona melami ya oudageto, siya-muluna olu eleyapa winami, lifimala kilili o edo. ");
INSERT INTO snp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ido fo kamena lawokolo ya kamena seweni (7) ya olu nosámami o kedenami ya kamena seweni (7) ya kamodoka itibito oto sene-mulune olu eleyapa wiyowe, lenami, lifimala kilili o edo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ido aposolo yate Wekola loumamo, Kamo koli kikite ya olu naba-naba o ledo, loti lato, ");
INSERT INTO snp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","amokafo itibito logimami, Linate koli kikitina ya kolipa ilawa yaidana oto kefola minenami ya yá yola afuto lumuto kuwo noku minoto dinane, loti loumunawamo ya wenido meyalo meleto eti enagoliye. ");
INSERT INTO snp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kati ki efe loti kiyalo. Linate yauti we ma kouba-nabala we ya migu mika fi minenaife, ido sipisipi kiyaba o minenaife, lunaga melageto migu yati itibito oto numugu dinami ya wenabala yakafo loumunami, Alako ano. Weka-neta no, loto loumunaife? ");
INSERT INTO snp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E’e, etito minámaiye. Amomakafo eti loumunami, Aiyo, kamo wene-neta ofo kito, ukagalo owo wito, wene-neta nomageto notoneto aiga kaimoka ofo ki nenane, loto loumunagoliye. ");
INSERT INTO snp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ido kouba-nabala we ya ka loumaido meyalo melami ya ebola lenaife? E’e, eti o edámenaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yamu linateki ayaidana oti neta logimodo ya o fuli lageto, Lamo faifa kouba-naba we minoto lonote yako ologe. Lebote ya ádalo, loti lalo, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ena Yesu ya Yelusalemu unae, loto kanudo Galili mika onowalo, ido Samalia mika onowalo ya monimo uto, ");
INSERT INTO snp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","numuna meya malo u fedeto idaito, okola kilamo we teni (10) yate katula oti, ");
INSERT INTO snp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","faiga minoti au loti lula fiti eti lamo, Yesuwo, wenabao, lamo milumate ya kolo, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eti loumamo we ya geyeto logimami, Linate uti ukani ya yokila ki umamo we ya gilibalo, lito koliti kanudo monimo wado yalo ukani olu mo lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ido wemomo wagu yauti we lawoko makafo ukana mo limo ya eyetoto itibito Yesu nedo oto, Goti ebola au-au loto lomo aiye. ");
INSERT INTO snp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Oto ya Yesu kiyanalo kiyana umola fito, Siyane, lalole, loto loumaiye. Eti loto loumami wewa ya Samalia we ne. ");
INSERT INTO snp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ya loga imo, We teni (10) okola kilamo ya muki olu mo lo gedofe? Olo. Ido liliga naini (9) egau ya minae? ");
INSERT INTO snp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ailo feka we ama yako oto Goti ebola lenae, loto itibito ainako, liliga ya Goti ebola lenune, loti itibiti ámafe? loto loga o gedeto, ");
INSERT INTO snp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ido wewama eti loto loumami, Kamo nedito wo. Koli kikitanimo yakafo ukagalo ya olu faka lo kedaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kamena ma Falisi we yate Yesu loga o edamo, Goti wekudi wenenala kiyaba o ledami kamena ya nenafeko o fedenami ne? loti loga o edato, Yesu ya itibito logimami, Goti wekudi wenenala kiyaba o ledami kamena ya mebe-mabaki wenena omunikafo eyenawamo ya ámenami ne. ");
INSERT INTO snp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","E’e, Goti wekudi wenenala kiyaba o ledami ya moda linate minagu mino gedami nenako, Uma ya ne. Eyalo, ido, Yola ya ne. Eyalo, loti ádenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ena ege-ege moinamo we eti loto logimami, Aiga linate ya namo We Kula ya kofa oloto pi gedenamo kamena lawoko ya eyenune, loti auma witi kolinagilafa, eyámenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ido mate eti logiminawamo, Yolaleka ne. Eyalo, ido, Umaleka ne. Eyalo, loti logiminawamo ya eyenune, loti oluloti gege melámalo. ");
INSERT INTO snp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","E’e, kopana ito kosinalo ya filiga falake loto filiga lamena o fulitami yaidana oto namo We Kula kamenanelo ya itibito o fedenamo ne. ");
INSERT INTO snp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Etito oloto pinafa, ido kamena oiya ama minamo wenena komu keina naba-naba mona-mona numuti, meni numuti neyefe loti neyámenawae. ");
INSERT INTO snp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ido namo We Kula itibito enamo kamenalo ya Nowa minami kamenalo wenena monani melamo yamaidana oti mona melenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aya kamenalo ya wenena weni-neta nonano noti, we wena mofu meleti, we wena anido olu gimiti, yaidana-amaidana mona melemo uti, u Nowa sipiku idaido yalo wafa, ido no lafa naba ya o fedeto muki olu kopa o gedami ne. ");
INSERT INTO snp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ido Loti kamenalalo yaki ayaidana oti weni-neta nonano noti, neta-mata meina fiti, neta-mata kifanalo fuloti, ufa neta kifiti, numunina kuti etiti mino-mino omo idae. ");
INSERT INTO snp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Etiti minafa, Loti Sodomu fulito wimo kamena yalo yo yaki kifana salifa yo limo yaki ko wiyami yaidana oto kosinalo yati lumuto wenena muki olu kopa o gedami ne. ");
INSERT INTO snp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ido namo We Kula olu oloto pi gedenamo kamenalo ya adeina wenena monawa melamo yamaidana oti eti enawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aya kamenalo ya we ma numunala obito minenaidoti ya lumuto uto koukame-akamene lulau olunae, loto numunalau idámenaiye. Ido ayaidana oto we ma minau minenami ya itibito netane ma olunae, loto numudo ámunagoliye. ");
INSERT INTO snp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loti olonafo kala yamu kati ki efe lalo. ");
INSERT INTO snp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Makafo aimola oto meleto imo monala ya olu kiki lo minenae, loto kolami ya u kopa unagoliye. Ido makafo aimola oto meleto imo monala yamu kolámenami ya omuna kofawa minowa-minowa enami ne. ");
INSERT INTO snp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ka ma logimowe. Aya luwaila yalo lele folomolo lawokolo ono minenawami ya lawoko ma oluti ido lawoko ma fulo edenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ido wena lele lakoina lono olu minenawaidoti ma oluti ido ma fulo edenawamo ne.  ");
INSERT INTO snp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ido we lele migu minenawami ma ya oluti ido ma ya fulo edenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eti logimaito, amo ya loumamo, Wekolao, kawa lanimo ya egaleka oloto pinaiye? loti loga o edato, itibito logimami, Kono ukana nedo yalo nema ikime ya oti mau wi-wi ae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ena Yesu ya ege-ege moinamo we ya kamena-kamena Goti loumutiko minoti, aisa loti fulitámenawae, loto kepa ka logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Etito logimami, Numuna meya malo ka olu efe lo-lo imo we ma nemo ya Goti koliya kolámoto, ido wenenati yaki koli gimito geye lalo melámaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ido numuna meya ayau ya wena-kena ma nemo yakafo kamena-kamena ya ka olu efe lo-lo imo we nedo ya uto ilulu kuto eti loto loumu-umu imo, Kuwonefokafo kane ya olu fulo nedainako, yamu kamo ya ane olu faka lo nedo, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Eti lito, wewa ya wena-kena kala kamena fana koli fulito minami nefa, aiga siya-mulunau eti loto kolami, Namo ya Goti koliya kolámoto, ido wenenati yaki koli gimito geye lalo melámowe. ");
INSERT INTO snp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Etito nefa, wena-kenawa ya ilulu kuto kamena-kamena loga lonumutoko minageto, aisa lotenanako, yamu ana olu faka lenae, loto kolaiye, loto Yesu ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ena Wekolakafo eti limo, Linate ya ka olu efe lo-lo imo we monala efe ádami we kalawa ya kolalo. ");
INSERT INTO snp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ido Goti iyaina o gedami wenenala ya fo lido sinidigu kamena-kamena au loti loumu-umu o minamo ya ani olu faka ádenaife? Ido kiyaba omo wato aiga ya ani olu faka lenae, loto ádenaife? ");
INSERT INTO snp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","E’e, ka ona logimowe. Kenemane oto ani olu faka lenagoliye. Etito nefa, namo We Kula enamo kamenalo ya mikalo koli kikitina nomamo wenena ya olu oloto pinafe? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ido Yesukafo wenena maleka inanimomu kolamo, Mona efe lotoko mele minone, loti wenena liliga muki ya koli fulo gedamo wenena ya kepa ka maki eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","We lele ma Goti loumunaliye, loti felegaga kuliyai numuna nabau idami, ma ya Falisi we, ido ma ya kifana takisi olu-olu imo we ne. ");
INSERT INTO snp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ido Falisi wema ya nedi minoto, aimolamu ya kolito eti loumami, Aiyo, Gotiyo, wenena liliga ya ugele noti, mona nosámami-asámami meleti, kume-ugele namo mona melamo we, ido kifana takisi olu-olu imo we ama nemo yaidana oto minámonako, yamu siyane, lalole, loto lokomowe. ");
INSERT INTO snp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Namo salele lawoko lulau fo kamena lele wene-neta moi wito ánoto minoto, koukame kofawa oluto ko nomo neta yauti mau naini (9) ya nanimone olumo uto ido mau lawoko (1) ya kumu-kumu omo ne, loto etito loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Eti loumaifa, ido kifana takisi olu-olu imo we faiga afumaleka nedi minoto, kosinau kogo ko faka ádoto, ikiyalo kesoba wito, eti loumami, Aiyo, Gotiyo, namo lifimane nemo we ya minowe. Yamu milumane kolo, loto limo ne. ");
INSERT INTO snp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Etito loumami we ya Gotikafo monaka efe limo we minane, lo edaito numunaleka wimo ne. Ido ailo wema yamu etito ádaiye, loto logimowe. Yamu we ma aimola kuliya olu faka lo minenami we ya Gotikafo kuliya oluto lumunami ne. Ido we ma aimola kuliya oluto lumuto moni minenami we ya Gotikafo kuliya olu akaiya edenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ido nomilipa kefola Yesu nedo gilimiti ato, anakafo atenido melenaiye, loti afa, ege-ege moinamo we yate goudae. ");
INSERT INTO snp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Goudafa, Yesu ya nomilipa kefola luni fito, amo nedo olu mau wi gedeto, eti limo, Nomilipawa yaidana oti minamo wenena ya Goti wekudi wenenala kiyaba o gedainako, yamu namodo enawamo ya kanu ku gedámalo. ");
INSERT INTO snp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ka ona logimowe. We makafo nomilipa neta faifa umunawamo neta olunami yaidana oto Goti wekudi wenenala kiyaba o ledami monala ya olámenami ya Goti kilala yau idámenaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ido kiyaba we makafo eti loumami, Api lilibanimo we lalo, namo kofawa minomo dinamo mona ya olunae, loto kolinamo ya nena mona melenamo ne? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Loga o edaito, Yesukafo itibito loumami, Nedito ya we lalole, loto lo nedane? We lalo ma ya minámaiye. Goti yako lalo ne. ");
INSERT INTO snp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ena kamo lo melami ka moda kolife loto kolitanima ne. Etito limo, Kume-ugele áno. Wenena gini folámo. Neta ugele olámo. Ka suki logimámo. Okafo mekafo kulini olu faka lo, loto ka mono lufuwau (Kis 20:12-16, Lo 5:16-20) nemo ka ya koli minane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Loumaito, itibito limo, Kipa kefola minomo kamenaleka yati kawa muki ya meyalo melemo wowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Loumaito, Yesukafo kawa kolitoto eti loumami, Kamo ya neta lawoko mako eti enanimo neta ya faifa ne. Neta-mata muki ko nanimo ya kifanalo fuloto, kifana oluto neta ko ánamo wenena iya mele gimageto ya kosinau koukame ko nenagolane. Ido oto nege melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kawa loumami ya kolitoto koukame naba-naba ko nami nenako siya-muluna keina iye. ");
INSERT INTO snp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eti imo Yesu eyeto loumami, Koukame naba-naba ko namo wenena ya Goti wekudi wenenala kiyaba o ledami kilalau dinawamo ya koiya naba finawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yafo-kameli yakafo naka kifiyau dinami ya koiya naba finami nefa, ido koukame ko namo wenena yate Goti kilalau dinawamo ya oto diti koiya naba-naba finawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wenena ya kawa limo ya kolititi eti lamo, Etito nenako, yamu kema wenena olu omuni kenaiye? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ya limo, Wenena yate ya ogoufámafa, ido Goti yakafo neta-mata muki eti enami ya moda ogofuto minaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitakafo eti loto loumami, Lamo ko nonimo netate-matate muki ya moda fulitoto kege melone, loumaito, ");
INSERT INTO snp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ya logimami, Ka ona logimowe. We makafo Goti wekudi wenenala kiyaba o ledami yamu numunala ebalafe, ido olonafofe, ido yalafo-kunalafofe, ido olafo melafofe, ido nomilipalafe fulitenami ");
INSERT INTO snp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya oiya minami kamenalo neta fulitami mulalo-mulalo dito itibito umunami ya oluto, ido aiga kamena o fedenami yalo ya minowa-minowa oto minomo dinami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ya ege-ege moinamo we tuwelu (12) yako gilimito anawaleka uto, eti loto logimami, Lamo ya Yelusalemu idogeto polofetete namo We Kula yamu lufuwa wi melamo ka yama muki u ayalo winaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Namo We Kula ya anekiyanelo oluti ailo feka wenena anido gimato, amote kiya o nedeti, kamane kiti, ketufu o nedeti, ");
INSERT INTO snp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ipi nofoti, nofo fulunagilae. Ido fo kamena lelei-lawokoi (3) wageto fulunaguti ya kofa nedinagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eti logimami kawa muki ya kolife loti kolámae. Ka limo monawa ya olu faluku gedami yamu nena netamu liye? loti ya kolife ádae. ");
INSERT INTO snp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu monimo uto Yeliko olu alili melaito, omuna likami we ma ya kanu anawalo amedoto minoto, neta wako lo-lo imo wema ne. ");
INSERT INTO snp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ido wenena mau naba kanu ayalo uti ka lamo ya kolitoto eti loto loga imo, Yae, nedi-nedi ae? loto loga ito, ");
INSERT INTO snp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","eti loti loumamo, Yesu Nasalete numudoti ami we ya monimo wiye, loumato, ");
INSERT INTO snp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","wewa ya au loto lula fito eti limo, Yesuwo, Defiti nakulafo, namo milumane kolo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eti lito, wenena komu meleti wamo yate wewa oduti eti loumamo, Ka kedámoto mino, loti lafa, kofa au naba-naba loto eti limo, Defiti nakulafo, milumane kolo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ka limo kolito, nedi minoto, wewa ya ilimiti minodo alo, lito ilimiti ato adu minaito wewa ya Yesukafo loga o edami, ");
INSERT INTO snp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Namo ya kamo nedi-nedi o nedenaiye, loto kolane? loumaito, itibito eti loto loumami, Wekolao, omune kenae, loto kolowe, loto lomaito, ");
INSERT INTO snp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu itibito loumami, Omuga ko. Koli kikitanimo yakafo olu faka lo kedaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Loumaito, moda ayalo omuna likami ya falatito, Yesu ege meleto Goti ebola lomo wiye. Ido wenena muki ya eyeti amo yaki Goti ebola lomo wae. ");
INSERT INTO snp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ya Yeliko numudo uto, monimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ido yalo we ma kuliya Sakiusi ya kifana takisi olu-olu amo we kiyabani we naba minoto, neta ko nami we minaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ido wewa yakafo Yesu ya egaidana we ne? loto eyenae, loto kolaifa, we lina nenako, wenena mau naba minagu minoto eyefe ádaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yamu Yesu unaidoka kanu afumaleka ya oluloto komu uto, eyenae, loto ya yá adeku dito ya minaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Minaito, Yesu aya ebalo o fedeto ko faka loto eyeto, eti limo, Sakiusiyo, alako itibito mikalo lomo. Namo onema ya kamo numugau minenae, loto kolowe, loto loumaito ");
INSERT INTO snp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ayalo kenemaneto itibito lumuto, siya-muluna alikani ito, aiyo-koiyo lo edeto, ilimito numunauka wiye. ");
INSERT INTO snp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wito wenena muki ya eyeti, koli nosámami umuti eti lamo, Aiyo, lifimala nemo we numunau dito yalo onenagoliye, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Eti lafa, Sakiusi nedito, Wekola ya eti loumami, Wekolao, moda kolo. Oiya ama namo koukamene muki iya meleto filiga ya neta ko ánamo wenena giminae. Ido we ma ka suki loumuto netala lawoko ma ugele olomo ya mulalo-mulalo meleto itibito neta fo (4) yaidana umunagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ido Yesukafo eti limo, Wewa yaki Abalahamu ufa fiyaigu yauti nenako, onema Gotikafo numunawau minamo wenena olu omuni kaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Etito namo We Kula wenena moni fuisamo wenena ya moni wilito olu omuni kenae, loto omo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kawa ya koli minato, Yesu Yelusalemu olu alitami yamu wenena Goti wekudi wenenala kiyaba o ledami mona ya oiya eti-mati oloto pinaiye, loti kolato Yesukafo kepa ka ma enu wito eti logimami, ");
INSERT INTO snp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kuliya nemo we ma eba faigalo uto minoto, mikalo kiyabani we wekudi bulu nedato, itibito enagolowe, loto ");
INSERT INTO snp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","kouba-nabala we minaguti ya teni (10) luni fiyaito, ato Giliki kifana kuliya mina lawoko ya muki gimito eti logimami, Kifanawa gimomo ya oluti kifanakafo lono olumo wato itibito enae, lototo wiye. ");
INSERT INTO snp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wifa, ido kiyaba o gedami wenena amomu koli nosámami umuti, wewa wido ya kiyabate we wekudi minenaiye, loto kolámone, loto kawa fulenune, loti wenena ma egeka gilifi melato wae. ");
INSERT INTO snp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wafa, ido kiyabani we wekudi buluto, aiga ya itibito aiye. Itibito oto kifanane gimomo ounawa nenaki olu mene amo ya kolinae, loto kouba-nabala we luni fiyaito ae. ");
INSERT INTO snp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Komu ami we eti loto loumami, Wenabao, kamo kifana mina nomanimo yakafo lono oluto kifanaka ounawa teni (10) maki olu mele kedomo ya ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eti lito, kiyaba we ya eti loumami, Kouba-nabane weyo, lonoka lalo eyowe. Kamo neta kefo efema ya kiyaba lalo aninako, numuna meya teni (10) ya kiyaba enane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Loumaito, ido kouba-nabala we naba tu ya oto eti limo, We nabao, kamo kifana mina nomanimo yakafo lono oluto kifanaka ounawa faifu (5) maki olu mele kedomo ya ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Loumaito, kiyaba we ya eti loumami, Numuna meya faifu (5) ya kiyaba enane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Eti loumaito, kouba-nabala we ma oto eti loumami, We nabao, kamo kifana mina nomanima lafo-lafoku yau asa wito falukuto melomo uma ya ne. ");
INSERT INTO snp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kamo seka-muluga itanimo nenako, kolika kolowe. Ido neta ma netaka minámami ya faifa olu-olu animo ne. Ido neta migu kifamo neta kifámanimo ya faifa kofu-kofu anima ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eti loto loumaito, kiyabala we yakafo itibito loumami, Kouba-naba we kefali nosámanimo, kaimoka ka lanimo yakafo olu kalo kedenagolowe. Namo sene-mulune itoto, neta ma netane minámami ya faifa olu-olu oto, ido neta migu kifamo neta kifámomo ya faifa kofu-kofu omo ya moda kolitabe? Olo. ");
INSERT INTO snp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Eti loto kolanimo ya itibito enami kamenalo ya kifanalaki ounaki olunaiye, loto kifanane komomo ya kifana mele-mele amo numugu ya nedito mele nedámane? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Loga o edeto wenena adu nedi minamo ya eti loto logimami, Kifana anau olu nemo ya ipoti oluti kifana mina teni (10) ko nami we ya umalo, loto logimaito ");
INSERT INTO snp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","amo yate itibiti loumamo, We nabao, amo ya kifana mina teni (10) ya moda olu minaima ne, loti loumato, ");
INSERT INTO snp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","itibito eti loto logimami, Neta ma ko namo wenena muki ya maki enu wito giminami ne. Ido neta ma ko ánamo wenena neta kefo ko namoma ya amodokati ipenami ne, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ena kuwonefo-mota namomu ya mikalo wekudite minenaiye, loti kolámamo ya gilimiti oti namo omunelo ya gini folalo, loto limo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ena Yesu ya kawa ya logimi fuli lototo Yelusalemu unae, loto komu meleto idaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Monimo dito mowa kuliya Olifi mowa yalo Betefage ido Betani numuna olu adu meleto ege-ege moinamo we lele komu gilifi meleto eti logimami, ");
INSERT INTO snp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Linate numuna meya youmalo uti dinawaido ya yafo-dogi momola meyalo moinámamo nela witamo minenami ya eyeti nelalo efiliti oluti amalo itibiti ailo. ");
INSERT INTO snp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ido we makafo, Linate ya nediti nela ya efilaiye? loto loga o gedaitoma, eti loumailo, Wekola lonola ma neto yamu lito oiye, loti loumailo, loto logimito gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gilifi melaito, wewa lele ya monimo uti netawa muki Yesu logimamidana oto oloto pi gimaito eyeti ");
INSERT INTO snp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","uti yafo-dogi momola ya nela efili minaito aboga yate oti logimamo, Linate ya nediti yafote-dogi momola ya nela efili minaiye? loti loga o gedato, ");
INSERT INTO snp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","itibiti logimami, Wekola lonola ma neto yamu lito oiye, loti laiye. ");
INSERT INTO snp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eti loti yafo-dogi momola ya ilimiti Yesu nedo ya oti ukanido owo mulalo wiyamo ya kololototi yafo-dogi momola meyalo ya meleti Yesu ana olu faka lato meyalo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dito minoto monimo wito wenena yate ukanido owo feka wiyamo ya kololototi kanudo unaido kolaleka wilimo wae. ");
INSERT INTO snp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eti ato, Yelusalemu adu Olifi mowa fulito waka afumaleka wimo kanudo ya aito, ege melamo wenena muki mau naba yate alikani naba oti, Goti aumala gilibami neta muki oloto pi gedami ya eyamo yamu au naba-naba loti Goti ebola loti, kuliya olu faka loti eti lamo, ");
INSERT INTO snp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aiyo, kiyabate we wekudi Wekola kuliyalo ami we ya lalo kolimo wimo ne. Ido kosinau you amene mona ya oloto piyaito, yoiyau kosinau minamo yaki ayaidana oti kuliya olu faka lo-lo ae, loti ya lomo wae. ");
INSERT INTO snp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wenena mau naba minagu yauti Falisi we mate Yesu eti loti loumamo, Api lilibanimo we, kege melamo we ya lo fuko gedageto weni itoti minenawae, loti loumato, ");
INSERT INTO snp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","itibito logimami, Namo ka logimowe. Ka ádatoma, kifana yate kai melenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ena Yesu monimo uto, Yelusalemu olu alili meleto, numuna meya naba ya eyeto wenena yau minamo kufuni o gedeto ");
INSERT INTO snp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","eti limo, Aiyo, onema oiya amalo namokafo olu you amene mona mele gedenamo mona ya linanimotina kolife loti koli minamo neko, lalo agi ne. Nefa, oiya netawa olu faluku gedami yamu omudikafo ogofuti ágae. ");
INSERT INTO snp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ogofuti ágato, kamena ma enami yalo ya linate kuwotibo-mota numuna meya naba kilalo kifana okoli melemo diti yalo diti ogona o gedeti kanu muki unawagu-unawagu ito gedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ido numuni meya muki ya luko-mako oti olu kopa o edeti we wena nomilipani muki minamo ya gini fulunawamo ne. Gotikafo olu omuni kenae, loto ami kamenala ya kolife loti eyámamo nenako, yamu kifana ya kifana ma mulalo nemo ma minámenami ne, loto limo ne. ");
INSERT INTO snp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ena Yesu felegaga kuliyai numuna naba kilalau dito wenena neta kifanalo fuloti minamo ya apito giyado feka ito eti logimami, ");
INSERT INTO snp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Numune ya ka lonumu-numu amo numunale, loti lenawamo ne, loto ka mono lufuwau (Ais 56:7) ya nemo nefa, linate yate olu ugele we numuni yaidana o minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ido kamena-kamena ya felegaga kuliyai numuna nabau api gilibimo wifa, yokila ki umamo we kiyabani we, ido lo melami ka api gilibamo we, ido wenena kiyabani we yate Yesu ofo fulunawamo kanu ya moni wilafa, ");
INSERT INTO snp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","wenena mau minamo ya auma witi ka limo ya kolanako, yamu ofo fulunawamo kanu ya olu oloto piyámamo ne. ");
INSERT INTO snp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kamena ma Yesu ya felegaga kuliyai numuna naba kilalau ya wenena api gilibito kawa kuwa lalo lo oloto melaito, yokila ki umamo kiyabani we, ido lo melami ka api gilibamo we, ido wenena kiyabani we yaki amodoka oti ");
INSERT INTO snp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","eti loumamo, Kamo netawa o-o minanimo ya kema welaloti kolito o-o ane? Kemakafo lokomaito o-o ane? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","itibito logimami, Namo yaki ka ma loga o gedenagolowe. Lonomalo. ");
INSERT INTO snp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoni ya kema welaloti wenena noku wi gedaiye? Kosinau nemo we welaloti nefemo, ido wenena wenidoti nefe? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Loga o gedaito, inanimoni lokoli-fakoli oti eti lamo, Lamo ya kosinau nemo welokati ne, loto lenumo ya amokafo ya, Aiyo, linate ya nediti koli kikito umámae? loto lolumunagoliye. ");
INSERT INTO snp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ido wenenadokati ne, loto lenumo ya wenena muki yate kolamo Yoni ya polofete ne, loti kolama nenako, kifanakafo lofo fulunagilae, loti kolamo yamu ");
INSERT INTO snp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","itibiti loumamo, Egalekati ne? Lamo kolife ádone, loti loumato, ");
INSERT INTO snp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesukafo limo, Namo yaki kema welaloti amaleka neta o-omo ya logimámenagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ido Yesu ya wenena muki kepa ka apito eti logimami, We makafo nela waini kifomo mine ya kiyaba o minenune, lenawamo meina numunawae, loto lonowa anido meleito mika faiga uto yalo kamena fana minaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Minaito, ilawa linami kamenalo ya kouba-nabala we ma mineuti ilawa liliga umato oluto enaiye, loto mina kiyaba o minamo we minado ilifi melaito, u fedaifa, ofoti, neta ma umámoti, iyadato, faifa itibito aiye. ");
INSERT INTO snp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Itibito aito, kouba-naba we ma ilifi melaito, minadoka wifa, amoki ofoti olu nosámami o edeti neta ma umámoti iyadato faifa itibito aiye. ");
INSERT INTO snp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Itibito aito, kouba-nabala we mama ilifi melaito, minadoka wifa, ayaidana oti ofoti ukana olu nosámami o edeti itufae. ");
INSERT INTO snp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Itufato, nela waini mi aboga yakafo eti loto limo, Nedi nedi enae? Nanefo sene-mulune umomo we ya minado ilifi melenae. Ilifi meloneto unami ya kala kolinagilae, loto kolito ilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ilifi melaito, minadoka wifa, eyeti lokoli-fakoli oti eti lamo, Wewa ami yakafo melafo fulunami kamenalo netala-matala iya ku edami ya olunagolinako, yamu ofo folokele. Lalimote melafo fulunami kamenalo ya iya ku edami netala muki ya olunagolone, loti ");
INSERT INTO snp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ya anakiyanalo oluti nela waini migu yauti olu fulo feka iti ofo folae. Yamu linate kati kiyalo. Nela waini mi aboga yakafo nedi-nedi o gedenami ne? ");
INSERT INTO snp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Amokafo minado uto ya nela waini mi kiyaba o edamo wewa muki ya gini fuluto, migu lonowa ya ailo wenena anido melenagoliye, loto logimaiye. Logimaito, kawa kolado eti lamo, Ei, eti ámenami ya lalo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Eti lato, Yesukafo kogo geyeto, eti loto logimami, Kifana ya numuna kuwamo wenena eye fa netaidana itamo nefa, ido aya kifanawa yama moda numuna lagi kola fiyami ne, loto ka mono lufuwau (Sng 118:22) nemo kawa monala ya linate egaidana oti lenawamo ne? ");
INSERT INTO snp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kolalo. We makafo kifanawama yalo lumu fou lenami ya aumala leke-make oto olu kopa enami ne. Ido kifanawa yakafo we ma meyalo olumo winami ya wewa ukana ya upa-napatenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eti logimaito, lo melami ka api gilibamo weki, ido yokila ki umamo we kiyabani weki ya Yesukafo kepa kawa limo ya inanimoni lo gedami ka kolititi, ayalo ana-kiyanalo olunune, loti kanu ya moni wilafa, wenena kolini kolae. ");
INSERT INTO snp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ena kiyaba amo ya wenena maleka ya momona oti neta ma enaido eyenawae, loti gilifi melae. Gilifi melamo wenenawa ya monate efe limo wenena minone, loti suki neta ae. Amo ya Yesu ka lenami ya kolito ligiya lo edenumo mona ma moni wilito, olu oloto pito ilimito uto gamani kiyaba we wenaba analo melenune, loti kolamo yamu ");
INSERT INTO snp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","eti loti loga o edamo, Api lilibanimo we, kolonimo ya kamo ka onako loto mona efe limoko api gilibi-gilibi animo ne. Ido wenena mele dilumu o gimámane. Ido Goti kanulalo moninumo mona ya ona efe loto api lilibi-lilibi o minane, loto koli minone. ");
INSERT INTO snp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yamu lageto kolinune. Kiyaba we wenaba Sisa kifana takisi umu-umu onimo mona ya efe loto nefe? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eti loti loga o edato, kepa mele edamo kolito eti logimami, ");
INSERT INTO snp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kifana denaliyasi ya nilibalo. Ounaki lufuwalaki kifanawalo nemo ya kema netala ne? loto loga o gedaito, itibiti eti loti lamo, Ya Sisa ounaki lufuwalaki ne, loti loumato, ");
INSERT INTO snp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","eti logimami, Etito Sisa netala oluti ya Sisa itibiti umalo. Ido Goti netala oluti ya Goti itibiti umalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ido amo yate Yesu ya wenena omunido ka lenami ma oluti ligiya lo edenawamo ka ma ogofuti oloto piyámae. Ido itibito ka logimami koliti elegiti, ka ádoti minae. ");
INSERT INTO snp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ena Sadusi we maleka wenena folaguti kofa neidámenawamo ne, loti kolamo wenena ya Yesu nedo oti eti loti loga o edamo, ");
INSERT INTO snp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Api lilibanimo we, Mosesekafo mono ka lufuwau eti loto limo, We ma nomilipala kedámoto folagetoma, olonafo kofawa minaito kunalafo wena-kenawa ya oluto yalafodo nomilipa olu oloto pi edenaiye, loto limo ne. ");
INSERT INTO snp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yamu we ma nalafo seweni (7) minagu yauti komu we yakafo wena olaifa, nomilipala kedámoto ya folaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ido folami we kunalafo makafo wenawa olaifa, ayaidana oto folaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Folaito, aiga kunalafo naba tili (3) yakafo olaifa, folaiye. Etiti kipawa seweni (7) yama ayaidana oti oluti nomilipala ma kedámoti folae. ");
INSERT INTO snp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Folato, ido aiga wenawa yamaki folaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ena folaguti kofa nedinawamo kamenalo we seweni (7) ya wenawa olamoma nenako, yamu aya kamenalo ya kema olonafo minenami ne? loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesukafo itibito eti loto logimami, Onema kamena amalo minamo wenena ya we wena mofu meleti, we wena anido olu gimi minae. ");
INSERT INTO snp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Eti afa, ido aiga kamena naba fedenaido yalo Gotikafo wenena maleka yamu eti limo, Monani efe limo wenena folaguti kofa olu nedi gedoneto namoki minenawae, loto lo gedami wenena ya we wena mofu melámoti, we wena anido olu gimámenagilae. ");
INSERT INTO snp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aya wenenawa ya enisole yaidana oti kofawa minomo diti ya kofa ogofuti folámenagilae. E’e, ido folaguti olu kofa nedi gedami nenako, Goti nomilipala minae. ");
INSERT INTO snp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ido Mosese yaki yá kefolalo yo limo kala ya lufuwa wiyaigu yau Wekola kala yamu eti limo, Namo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila minaiye, loto ka mono lufuwau (Kis 3:6) nemo ka yakafo wenena folamo ya folaguti kofa nedinawae, loto api lilibaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yamu amo omunalo wenenala muki ya kofawa minomo idamo nenako, Goti ya folamo wenena Gotinina minámaifa, kofawa minamo wenena Gotinina ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eti loto logimaito, lo melami ka api gilibamo we malekate itibiti eti loumamo, Wekolao, kamo ka lageto lalo iye, loti, ");
INSERT INTO snp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","koli gimaito kofa loga-miga o edámae. ");
INSERT INTO snp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ena Yesukafo ya eti loto logimami, Goti ilifi melami we Kilisto ya Defiti nakulafole, loti lo minamo ya nediti lae? ");
INSERT INTO snp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Defiti aimola yakafo Mono Nema lufuwa wiyagu yau eti loto limo, Wekola yakafo Wekolane ya loumami, Ane onaleka amedoto kiyaba oto minageto, ");
INSERT INTO snp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ya kuwokafo-mota fulo kiyaga feumau gedenagolowe, loto limo ne, loto ka mono lufuwau (Sng 110:1) ya limo ne. ");
INSERT INTO snp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Etito Defitikafo ya Wekolanele, loto linako, egaidana oto amo ufa fiyaiguti minami ne? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wenena muki ka limo koli minado Yesu ya ege-ege moinamo we eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Linate ya lo melami ka api gilibamo we yamu koti kiyaba oti moinalo. Amo yate ukanido owo fana-fana witi moniti, ido maketilo ya wenena leyeti aiyo-koiyo lolumunawae, loti koliti, ido mono numugu idamo ya wenena omunido folomo welalo yako minenune, loti koliti, ido weni-neta nenune, loti amo kamena ya folomo welalo komu yaloko minenune, loti koli minae. ");
INSERT INTO snp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ido wena-kena numuni netani-matani fa oluti, ido wenena leyenawae, loti ka fana-fana Goti loumu-umu o minae. Aya wenenawa ya lifima ka naba-naba itibito giminagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ya ko faka loto neta-mata ko namo wenena yate kifana ya felegaga kuliyai numuna nabau kifana-koukame yau fulo minamo ya geyaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Geyeto ido wena-kena ma netala minámami ya oto kifana lafa kefola leleko ya wani (1) toya yaidana oto fulami yaki eyaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eyeto eti loto limo, Ka ona logimowe. Wena-kenawa netala minámami kifanala fulami yakafo wenena liliga kifanani fulamoma ya olu fulo gedaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aya wenena ya neta-mata ko namo yauti fulato, netanina muki faifa nefa, ido amo netala minámaigu yauti ya neta kefo efema mino edaido muki moda fulo fuli lito ya ma minámaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ena ege-ege moinamo we malekate wenenate kifana lalo-talo melamoki, ido Goti seni-muluni umuti umamo netaki yakafo felegaga kuliyai numuna naba ekeina olu edamo ya koti lomo wafa, ido Yesukafo logimami, ");
INSERT INTO snp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Netawa ama eyamo ya kamena aiga fedenami kamenalo kifana makafo kifana ma mulalo nemo ya koitámoti, muki ya luko-mako enagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ido amo yate eti loti loumamo, Api lilibanimo we, netawa ya nenafeko fedenaiye? Ido nena mebe-maba oloto piyageto netawa ya moda alili melaiye? loto kolinune, loti loga o edato, ");
INSERT INTO snp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","itibito eti logimami, Linate kote witenawae, loti koti kiyaba oti moinalo. Wenena so loti ya oti kuline oluti eti lenawamo, Namo ya wewa ya minowe, loti ido, Kamena naba ya moda alitiye, loti lenagilae. Linate ya wenenawa ya gege melámalo. ");
INSERT INTO snp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ido fina ka ido lowa ka kolitima, koli gimámaneyo. Netawa ya komu oloto pinagolifa, mika kosina fuli lenami kamena ya ayalo fedámenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ido ka ma enu wito logimami, Ido wenena mikau-mikau fina lowa fimo wato, ido mikalo kiyaba we ma wenenalaki ido kiyaba we ma wenenalaki lowa fina fimo unawamo ne. ");
INSERT INTO snp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ido mika mima naba-naba enaiye. Ido kadunamu naba fedenaiye. Ido eba maleka neta kilinawamo neta nosámami-asámami oloto pinaiye. Ido neta mona-mona koli naba-naba giminamiki, ido kosinaloti mebe-maba naba-naba yaki ya oloto pinagoliye. ");
INSERT INTO snp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Netawa muki ya oloto piyámageto linate ani-kiyanido oluti olu nosámami o gedeti, gilimiti mono numuna kiyaba weki ido nela numuna kiyaba weki anido melenawamo ne. Ido mikalo wekudiki wenena kiyabani we wenabaki omunido ya nedi gedenagilae. Linate namo kuline olu minamo yamu eti o gedenagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eti o gedenawamo kamenalo ya linate kala kuwa lalo ya lo oloto melenagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Linate lo oloto melato, ligiya lo gedenawado nena ka itibito logiminumo ne, loto kate ligi-ligi kiyámenune, loti auma witi kolalo. ");
INSERT INTO snp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nanimone yakafo wetido ka meleto ido manidigu melenamo ka ya kuwotibo-mota yate katina oluti lumuti olu fulo gedenune, loti lenawamo ya ogoufámenagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Linate ya otige, metige, yatige kunatigemota ido minamo ufa wenenati, ido yowotibomota yate kuwotibo-mota anido melato, minagu yauti maleka ya gini fulunagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ido linate ya wenenane minanako, wenena muki senimulunigu koli nosámami-asámami giminagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Eti enagilafa, manidi yowala lawoko ma ya u kopa ámenagoliye. ");
INSERT INTO snp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","E’e, linate mino auma witi minenawamo ya kofawa minomo dinawamo mona oloto pi gedenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ido ka ma enu wito logimami, Ena kimiwe mau naba yate oti Yelusalemu olu ogona enawamo geyenawado ya moda u kopa unami kamenala alitiye, loti ya kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aya kamenalo Yudia mikalo minenawamo wenena ya mowaleka koli walo. Ido numuna meya nabau minenawamo wenena ya ebawa fuloti walo. Ido migu minenawamo wenena ya numuna meya nabau idámalo. ");
INSERT INTO snp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aya kamenawalo ya lifima ka itibito giminami kala lufuwa wiyamo muki yama u ayalo winaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ido aya kamenalo aiyo, wenaipa nomilipa mulunigu nemoki, ido wenaipa nomilipanina amina no minenawamoki ya keina naba-naba kolinagilae. Ido wenena muki mikawa amalo minenawamo ya keina naba kolato, Gotikafo wenenawa lifima ka itibito giminaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ido kuwonibo-mota yate gini-gini amo emi yakafo giniti, ido nela wi gedeti, gilimiti mikau-mikau unagilae. Ido ailo feka wenena yate Yelusalemu mikalo kiyani leya wimo moinato, kamenani fuli lageto kofa leya wiyámenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ido ka ma enu wito logimami, Ena fo, ikana, ukulu yalo mebe-maba oloto pinagoliye. Ido mikalo wenena mikau-mikau minamo yate kuwo nokafo satoto naba-naba imo nola naba lenami ya koliti kani ligi-ligi kiti koli naba giminagoliye. ");
INSERT INTO snp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ido kosinalo neta nemo ya momoga enami nenako, wemomo mikalo neta ma fedenami kenune, loti kiyaba o minenawamo ya koli naba-naba gimageto, folamo yaidana oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aya kamenalo We Kula namo ya kosinalo limuku o fedeto aumane nabaki, ido lamena nabaki oneto neyenagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aya netawa apito oloto pinami, meina fito efili gedomo kamena moda adu mele minainako, yamu nediti ko faka lalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesukafo kepa ka eti loto logimami, Linate ya yá adeki ido yá liliga muki koti monanina kolalo. ");
INSERT INTO snp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yá aila kofawa winami, linanimote ya koti, ayalo fo lenami kamena adu melaiye, loti ya koli-koli ae. ");
INSERT INTO snp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Etito netawa logimomo yaki oloto piyaito, linate eye minenawamo, Goti wekudite wenenala kiyaba o ledami kamenala adu melaiye, loti kolinagilae. ");
INSERT INTO snp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ka ona logimowe. Kamena oiya ama minamo wenena maleka folámato ya netawa muki logimomo ya oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kolalo. Mika kosina ya fuli lenagolifa, namo kane ya minowa-minowa omo dito fuli ádenami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Linate ya koti kiyaba oti moinalo. Nonano weti-neta naba nato, omudi monito kati-manidi u kopa unami mona, ido ukadi atuwa neta yamu kati mumudi kiti, seti-muludigu keina naba-naba kolitenawae, loti kamena naba yakafo kilifu ku olamomaidana oto kaita oloto pi ledetenaiye, loti koti kiyaba oti moinalo. ");
INSERT INTO snp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Etito aya kamenawa ya wenena muki mikau-mikau minenawado yalo ya oloto pinagoliye. ");
INSERT INTO snp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yamu netawa oloto pinami olu afima o ledetenaiye, loto ido We Kula omunalo ogofuto nedi minenagolone, loto ade olu faka lo, loti kamena-kamena koti kiyaba oti moniti Goti loumumo idalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ido kamena-kamena Yesu ya felegaga kuliyai numuna nabau ya api gilibi-gilibi o minaito, lunaga melaito, numuna meya fulito Olifi mowalo dito yalo ya luwaila mino-mino iye. ");
INSERT INTO snp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eti o minaito ko lito wenena muki ka lenami ya kolinune, loti felegaga kuliyai numuna nabau oti mau wiyae. ");
INSERT INTO snp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ena folima ya beleti olufe loti fudodo imo neta yisi melámoti faifa kiti no-no amo foliwa kuliya Elita o Gedami kamena ya alili melaito, ");
INSERT INTO snp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Goti yokila ki umamo we kiyabani weki, ido lo melami ka api gilibamo we yaki ya wenena kolinina kolanako, yamu Yesu ya egaidana oto ofo fulunuwe? loti kanu ma moni wilimo wae. ");
INSERT INTO snp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Etiti minato, Yesu ege-ege moinamo we tuwelu (12) minagu yauti we ma kuliya Yudasi kuliya ma Isikaliyoti nemo ya Satanikafo lulau idaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Lulau idaito, Yudasikafo Goti yokila ki umamo we kiyabani we ido felegaga kuliyai numuna naba kimiwe kiyabani we minado uto Yesu ya anido melenami ka ya logimaito, lakoina lokoli-fakoli o minae. ");
INSERT INTO snp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lokoli-fakoli o minoti, seni-muluni alikani naba-naba oti ya kifana kumunune, loti loumato, ");
INSERT INTO snp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O, loto wenena naba minámamo kamenalo Yesu kuwolafo-mota anido giminae, loto kiyaba o minaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ena folima ya beleti olufe loti fudimo neta yisi melámoti faifa kiti no-no amo kamena ya oloto piyaiye. Aya kamenalo ya Elita O Gedami kate meletenaiye, loti sipisipi momola ya ofoti no-no ae. ");
INSERT INTO snp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yamu Yesukafo Pitate Yonite eti loto gilifi melami, Linate ya uti Elita O Gedami kobina nenumo ofo kinawaiye, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","itibiti eti loumami, Numuna egau ofo kinaliye? loti loga o edaito, ");
INSERT INTO snp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","eti loto logimami, Kolailo. Linate numuna meya nabau dinawaido ya we ma no fi-fi amo masa mofu enami we ya katula oti, ege meleti wailo. Ido numunau dinami ya ayau idailo. ");
INSERT INTO snp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Diti numuna aboga eti loumailo, Api lilibami wekafo nege-nege moinamo weki Elita O Gedami kobina nenumo eba ega ya ne? loto loga o kedaiye, loti loumailo. ");
INSERT INTO snp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eti loumunawami ya eba naba ma folomo kunu-anu wilamo eba ya gilibageto yau wete-neta ofo kiyailo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Logimaito, fulo edeiti uti, Yesu limo netawa yaidana olu oloto piti, Goti Elita O Gedami weni-neta ofo kiyaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ena kamenawama o fedaito, Yesuki ido aposolola yaki neta nenawamo folomolo amedoti minae. ");
INSERT INTO snp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amedoti minato, eti loto logimami, Miluma kolinamo kamenane alitimo yamu komu ya Elita O Gedami wete-neta ama linateki nenune, loto auma wito kolowe. ");
INSERT INTO snp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ido aya yamu ka ma logimowe. Namo ya Elita O Gedami wete-neta kofa ánoto Goti wekudi wenenala kiyaba o ledami ebalo Elita O Gedami mona ona ya enaido yalo kofa nenae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Logimito ya nomu olutoto, siyane, lalole, loto loumuto ya eti logimami, Linate oluti minagu ya iya melalo. ");
INSERT INTO snp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka ma logimowe. Namo ya no waini kofa ánoto Goti wekudi wenenala kiyaba o ledenami kamena oloto pinami yalo kofa nenae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eti logimito beleti oluto, siyane, lalole, loumuto ya leketo gimito eti loto logimami, Ama ya namo ukane nemo ya linatemu umu minowe. Monawa etiti melenawamo kamenalo ya kati ki numuti etiti melemo idalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ido aiga no fuli lotiti ya nomuma yaki ayaidana oto oluto eti logimami, Nomu amau ya namo wanune ya Gotiki olu kutifi gedami ka kofawa olu auma wi edami wanune ya linatemu lekinamo ne. ");
INSERT INTO snp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Etito nefa, namo kuwonefo-mota anido melenami we ya namote folomolo amalo ya lakoina wete-neta no minoiye. ");
INSERT INTO snp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","We Kula namo ya Gotikafo, Eti enane, loto limo welalo ya melenagolofa, ido kuwonefo anido melenami we ya aiyo, lifima ka naba-naba itibito olunami ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eti loto logimaito, inanimoni minagu yau, Kemakafo ya eti enaiye? loti loga-loga ae. ");
INSERT INTO snp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ena ege-ege moinamo we yate moila fi filiga-filiga oti ya lamo, Lalimo yauti kema kuliya u komu uto ne? lato, ");
INSERT INTO snp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesukafo ya eti loto logimami, Ailo feka wenena mikalo kiyabani we wekudi yate wenena auma witi kiyaba o gedato, ido kiyabani we ma kulini ya wenena koinanibo-motale, loti melae. ");
INSERT INTO snp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Etiti melamo mona yaidana oti linate melámalo. E’e, linate minagu yauti kuliya nemo we ya linate kunanibo aiga we yaidana oto minenaiye. Ido kiyabatina we ya kouba-naba we yaidana oto minenaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kolalo. We lele yauti kema ya kuliya nemo we ne? We ma amedoto minoto wela-neta no minami wefemo, ido kouba-nabala we wela-neta ofo ki umunami we ne? Wela-neta no minami we ya kuliya nemo we ne, loti koli minae. Etito nefa, ido namo ya linate minagu minomo ya kouba-nabatina we yaidana oto minowe. ");
INSERT INTO snp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ido neta-mata muki kepa mele numunae, loto fedami kamenalo ya linate yate fulo nedeiti ámuti namoki lakoina mino-mino amoma wenena ya minae. ");
INSERT INTO snp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ido Menefokafo kiyaba we wekudi lono nomami yaidana oto namo ya kiyaba we wekudi lono ya linate gimowe. ");
INSERT INTO snp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Namo kiyaba we wekudi lono olunado yalo linate namoki lakoina neta noti, ekeina folomolo amedoti minoti, Isilaeli wenena afo monalo-monalo tuwelu (12) ya iya mele gedeti wenenawa kiyaba o gedenawae, loto lonowa gimowe, loto logimowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesukafo limo, Saimoniyo, Saimoniyo, Satanikafo yuwa witi ilawa lilika wiyamo yaidana oto linate ya lilika winafao, loto Goti loumaifa, ");
INSERT INTO snp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ido namo yakafo koli kikitanimo ya fuli lotenaiye, loto kamomu kolito Goti loumowe. Ido kamo eleyapa wito itibito enanido ya aukafomota olu aumafofo lo gedo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eti loto loumaito, itibito loumami, Wekolao, kamo nela fi kedenawafe, ido kofo fulunawafe, unanido ya lakoina unagolowe, lito ");
INSERT INTO snp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesukafo limo, Pitao, lokomowe. Okolofokafo onema luwaila nola ádageto kamo kamena lelei-lawokoi ya wewa eyámowe, loto kuline olu faluku nedenagolane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ena Yesu ya loga o gedami, Komu gilifi meloneto kifana owotina, ido owo, ido kiyanido wiyamo neta ya olámoti moinamo yama neta ma mino gedámami nefe? loto loga o edaito, itibiti loumamo, Lamo ya neta ma moni wilámone, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Loumato, amo eti logimami, Etito ya nefa, oiya ya kifana owo ko nenawamo ya oluti, ido owo yaki oluti, ido fina finawamo emi ko ánotima, ukanido owo ya kifanalo fuloti meina olunawamo yakafo fina finawamo emi ya meina fiyalo. ");
INSERT INTO snp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lufuwa wiyaigu eti limo, Amo ya koliti kolámoti amo wenena yaidana oto minaiye, loti eyamo ne, loto ka mono lufuwau (Ais 53:12) nemo ka yama namodoka kulawa enagoliye. Ona, namomu lufuwa wiyamo muki ya moda kulawa o fuli lenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eti logimaito, ege-ege moinamo we eti loti loumamo, Wekolao, lamo ya fina finumo emi lele ya olu minone. Eyo, loumato, itibito logimami, Moda ya ogoufaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ena Yesu ya kamena-kamena o-o imo ya oto Olifi mowalo ya idaito, ege-ege moinamo we ege wae. ");
INSERT INTO snp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ege wato, ido ebawalo yama o fedeto ege-ege moinamo we eti logimami, Linate ya mona nosámami yakafo kepa mele ledageto ya lumu fou lotenune, loti Goti ya loumutiko minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Logimito fulo gedeito amodokati monimo kefo ma uto, kiyana umola fito ya Goti eti loto loumami, ");
INSERT INTO snp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Menefo, miluma kolomo kapu ama ya olu fulo nedo, loto kolomo nefa, kaimoka kolinanido ya mele nedo, loto loumaiye.  ");
INSERT INTO snp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eti lito, kosinau yati enisole makafo oloto pi edeto auma umaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ido Yesu ya siya-mulunau keina naba-naba kolito, Goti ya auma wito loumumo idami kola-welalo ya koiya fiyamila ya wanu yaidana oto mikalo ya lomaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Etito loumuito ya nedito, itibito ege-ege moinamo we minado uto geyami ya seni-mulunigu keina naba imo yamu aisa loti oku ono minae. ");
INSERT INTO snp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oku ono minamo ya eti loto logimami, Linate nediti oku ono minae? Mona nosámami kepa mele ledenaido ya lumu fou lotenune, loti Goti loumu-umu o minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu kawa ya eti lo minaito, wenena naba mau minamo amodoka o fedato, ege-ege moinamo we tuwelu (12) yauti wema kuliya Yudasi yakafo olu komu meleto gilimito Yesu nedo oto, mudo edenae, loto adu aifa, ");
INSERT INTO snp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu ya loga o edami, Yudasiyo, We Kula namo ya mudo nedenanimokafo olu kuwonefo-mota anido melabe? loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ido Yesu ege melamo we ya neta fedenagolimo ya koliti eti loti loumamo, Wekolao, lamo ya fina fi-fi onimo emite yakafo gininube? loti loga o edeti, ");
INSERT INTO snp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","amodokati makafo yokila ki umu-umu amo we wenabani kouba-nabala we emikafo kala onaleka ya fuko fulitaifa, ");
INSERT INTO snp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu ya netawa eyeto eti limo, Mona ya fulitalo, loto wewa kala ya oluto olu faka lo edaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ena Yesukafo Goti yokila ki umamo we kiyabani we, ido felegaga kuliyai numuna naba kiyaba amo kimiwe kiyabani we, ido we kilofo kulinigi we ya, ana-kiyanalo olunune, loti o fedamo ya eti loto logimami, Linate kolamo namo ya ugele wenaba ne, loti koliti emiki, ido kefaki oluti minodo afe? ");
INSERT INTO snp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kamena-kamena ya felegaga kuliyai numuna naba ebalo linateki minomo yama ane-kiyanelo olámamoma ne. Ane-kiyanelo olámamo nefa, oiya ama kamenatina neto ido sinidimo kiyaba we kamenala ya ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ena amote Yesu ana-kiyanalo oluti, ilimiti uti yokila ki umu-umu amo we kiyabani we wenaba numunau idae. Idato, Pita ya faigato meleto gege monimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Gege uto numunawa kilalau ya diti, yo kiti labiti minado ya Pita ya u ayau ekeleto minagu ne. ");
INSERT INTO snp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Minaito, kouba-naba nomili makafo oto yo lamena ido yalo amedoto minami ya eyeto, kogo eyefe loto eti limo, Wewa ama amoki lakoina minanima ne, loto lifa, ");
INSERT INTO snp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ido Pita limo, Nomiliyo, namo amo eyámomoma ne, loto olu falukuto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Loumaito, ido aiga kefoma ya we makafo eyeto eti loto loumami, Kamo yaki auwafo-mota minagu yauti ya minane, loto lito, itibito loumami, We amala, namo ya etito minámowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Eti loumaito, ido aiga wani (1) awa yaidana oto minoto, we ma oto lo gedoto limo, Ya ona lowe. Wewa ama ya Galili we nenako, Yesuki minami ya ne, loto lifa, ");
INSERT INTO snp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita itibito loumami, We amala, ka lanimo ya kolife loto kolámowe, loto lo minaido ayalo okolofo kokololo liye. ");
INSERT INTO snp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kokololo lito, Wekolakafo oluwe oto Pita kogo eyefe loto eyaito, ka komu eti loto loumami, Okolofokafo onema luwaila nola ádageto kamo kamena lelei-lawokoi kuline olu faluku nedenagolane, loto loumami ka ya kolito, ");
INSERT INTO snp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","feka uto kufu naba-naba iye. ");
INSERT INTO snp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ena Yesu kiyaba o edeti minamo we yate kamana kiti ya ofo minoti, ");
INSERT INTO snp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","lafo-lafokafo omunalo itoti loumamo, Polofete ka lolomo. Kofami we ya kema ne? loti loga o edeti, ");
INSERT INTO snp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ido ka nosámami-asámami ka muki ya loumae. ");
INSERT INTO snp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ena ko lito leda Yuda wenena we kilofo kulinigi weki, ido Goti yokila ki umamo we kiyabani weki, ido lo melami ka api gilibamo weki ya kanisole mau witi minado Yesu ya ilimiti uti omunido olu nedi edae. ");
INSERT INTO snp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Olu nedi edato, eti loti loga o edamo, Kamo ya ilifi melami we Kilisto minagetoma, lolomo, loti loumato, itibito eti logimami, Namo ya linate logimonetoma, koli kikito nomámenagilae. ");
INSERT INTO snp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ido loga o gedenamo ya itibiti lonomámenagilae. ");
INSERT INTO snp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Etito nefa, oiya kamena amalekati We Kula namo ya Goti aumafofo limo we ana onaleka amedoto minenagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eti loto logimaito, amote loga o edamo, Yamu ya kamo Goti Nalafo minabe? loti lato, itibito logimami, Linanimote, Etito minane, loti lamo ya ka ona lae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eti logimami kawa ya koliti eti lamo, Lalimote ya nedito ka maki ya kolinumo ne? Aimola welaloti ya moda kolone, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ena mau minamo wenena muki ya nediti, Pailati nedo ilimiti ");
INSERT INTO snp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","uti, ligiya eti loti lamo, Aya we yamo lamo Yuda wenena muki olu kopa o lede minami we ya olu oloto piyone. Amokafo eti limo, Linate kifana takisi Lomu kiyaba we wenaba Sisa umámenawae, loto logimaiye. Ido, Namo nilifi melami we Kilisto ya kiyaba we wekudi ya minowe, loto eti lo minaiye, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eti lato, Pailatikafo kolito eti loumami, Kamo ya Yuda wenena kiyabani we wekudi minabe? loto loga o edaito, Yesukafo itibito limo, Ona lane, lito, ");
INSERT INTO snp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailatikafo Goti yokila ki umamo we kiyabani we ido wenena muki mau minamo ya logimami, Namo ya wewa lifimala moni wilito olu oloto piyámowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Logimaifa, ilulu kuti lo gedoti loumamo, Wewa yakafo api gilibami kala yamo Yudia mikalo minamo wenena muki seni-muluni olu kopa o gedemo wiye. Olu kopa o gedami ya Galili mikalo yaloti apito gilibimo ami oto oiya amalo ya fedaiye, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailati ya kawa kolito eti limo, Wewa ya Galili we nefemo? loto loga o gedeto, ");
INSERT INTO snp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ido Heloti kiyaba imo ebalaleka yati aiye, loti lamo ya kolito, Heloti ya oiya Yelusalemu minaima nenako, amo nedo ilimiti unawae, loto gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Gilifi melaito, Heloti nedoka ilimiti o fedato, Heloti ya kamena fana Yesu kala koli-koli o minami nenako, eyenae, loto kolito eyeito alikani naba-naba ito, Goti aumala nilibinami neta ya olu oloto pi nedageto eyenae, loto koli minaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Etito koli minoto Yesu loga-miga o edemo wifa, itibito ka ádoto minaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka ádoto minaito, Goti yokila ki umamo we kiyabani weki, ido lo melami ka api gilibamo we yateki yalo nedi minoti auma witi ligiya lo ede minae. ");
INSERT INTO snp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eti ato, Helotiki ido kimiwelaki yate noka kede umuti, kamana kiti, kiyaba we ukanalo owo ma wi edeti, Pailati minaidoka kofa ilimiti unawae, loti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ido Pailatite Helotite komu ya kuwolafo-kuwolafo minami nefa, ido fo kamena yalo ya yowo melaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ena Pailatikafo yokila ki umamo we kiyabani weti, ido wenena kiyabani we nabati, ido faifa wenena muki yaki olu mau wi gedeto, ");
INSERT INTO snp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","eti loto logimami, Linate wewa Lomu gamaniki fina lowa finune, loto wenena ile fali seni-mulunigu wiyami wele, loti lo edamo ya namodoka ilimiti ato, namokafo omunido ya ligiya lo edamo katina kolito, lifimala ya moni wilofa, ma olu oloto piyámowe. ");
INSERT INTO snp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ido Heloti yaki ayaidana oto lifimala ma olu oloto piyámainako, yamu ya lamodoka ilifi melami ya moda koli minae. Wewa ya neta ma ofo fulunumo neta ma o melámaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yamu ya ipi ofoto, nelauti efili edeto fulo edenagolowe, loto logimaiye.  ");
INSERT INTO snp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Eti logimami ya aya foliwa ya nelalo we ma nelauti efili edeto fulo edo, loti loumamo wewa ya nelauti efili edenaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eti logimami kawa ya kolititi ka noni olu lako meleti au loti loumamo, Wewa ya ofo folo. Balabasi nelauti efilito adelo melo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Eti loti lamo Balabasiwa ya numuna meya naba fina-lowa kito, gamani wenena fi ginito, we ma ofo folaito, yamu nela numugu fulo edamo ne. ");
INSERT INTO snp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ido Pailatikafo Yesu efili edenae, loto kolami ya kofa logimaifa, ");
INSERT INTO snp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ido ilulu kuti au loti eti lamo, Yá yofolo ofo folo. Yá yofolo ofo folo, loti lo minae. ");
INSERT INTO snp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eti lato, amokafo kofa eti loto logimami, Nediye? Nena mona nosámami ya melamimule? Namo ya wewa ofo fulunawamo lifimala ya moni wilofa, olu oloto piyámonako, yamu ipi ofoto ilifi fuloneto unaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eti logimaifa, lo gedoti ilulu kuti lamo, Yá yofolo ofo folo, loti au loti lo minato, kanina yakafo amo kala olu fulo edainako, ");
INSERT INTO snp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailati ya kolami, Kanina meyalo melenae, loto ");
INSERT INTO snp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","kaila fi-fi imo we fina-lowa kito we ofo folaito, nela numugu minami we ya adelo melo, loti lamo wewa ya nelauti efili edeto, ido Yesu ya ofo fulunawae, loti koli minamo yamu kimiwela anido melaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ena Yesu ilimiti wado we ma kuliya Saimoni ya Sailinikati we kanudo Yelusalemu u fedenae, loto aido ya eyeti, analo oluti yá yofo akiyalo mofu edeti, Yesu meyalo ege melenaiye, loti auma witi loumae. ");
INSERT INTO snp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ena we wena muki gege monimo wagu yauti wenaipa ma kufu nema o edemo uti miluma-aluma kolae. ");
INSERT INTO snp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eti ato, Yesu oluwe oto eti logimami, Aiyo, Yelusalemu wenaipao, namomu kufu ámalo. Linanimoti ido nomilipati yamu kufu alo. ");
INSERT INTO snp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kolafe? Kamena ma fedenami kamena yalo eti loti lenawamo, Wenaipa keni minamo, ido wenaipa nomilipa kedámamo wenaipa, ido wenaipa aminido nomilipa ánamo wenaipa ya alikani enagilae, loti etiti lenagilae. ");
INSERT INTO snp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ido Aya kamenalo eti loti lenawamo, Linate mowa naba ya lamodoka lumuti miwi ledalo. Linate mowa kefola ya lamo minonido lumuti ukade ya ogofu olu lulau o ledalo, loti ka mono lufuwau (Hos 10:8) nemo ka ya lenagilae. ");
INSERT INTO snp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ido yá kofawa nemo ya nosámami netawa eti amo ya yá gedimo kamenalo ya nena neta nosámami mulalo-mulalo enawamo ne? Kolafe? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ena we lele ma kaila fiyami we ya amoki gini fulunune, loti gilimiti wae. ");
INSERT INTO snp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gilimiti uti eba ma kuliya Ateni Aumale, loti nedo ya o fedeti, yalo amoki ido kaila fiyami weki ginamo ma filiga onaleka, ido ma ya filiga adowaleka ya yá yofolo ginae. ");
INSERT INTO snp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ginato, Yesukafo eti limo, Menefo, neta amo ya monawa kolámoti amo yamu ka lifimanina ya kilili o gedo, loto loumaiye. Ido kimiwe yate ukanalo owo yamu noka kedeti iya meleti olae. ");
INSERT INTO snp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ido wenena nediti ko minato, kiyabani we yaki ka nosámami-asámami eti loti lo edamo, Wenena ailo ya olu omuni ko-ko imoma we ya Gotikafo ilifi melami we Kilisto, iyaina o edami we yama minagetoma, aimola olu omuna kenaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ido kimiwe ya ayaidana oti amodoka oti kamana ki minoti, nenaiye, loti ekefa imo no waini umuti, ");
INSERT INTO snp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","eti loumamo, Kamo Yuda wenena kiyabani we wekudi minotoma, kaimoka ya olu omuga ko, loti loumae. ");
INSERT INTO snp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ido atelalo neta lufuwa wiyaito melamo ya eti loto wiyami, Wewa ama ya Yuda wenena kiyabani we wekudi minaiye, loto wiyami ne. ");
INSERT INTO snp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ido kaila fiyami we ma yá yofolo minami yakafo ka nosámami eti loto loumami, Kamo Goti ilifi melami we Kilisto minabe? Olo. Kaimokaki ido lamo yaki olu omude ko, loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ido kaila fiyami we mamakafo oduto eti loumami, Kamo ya keina olami yaidana oto olanimo yamu Goti koliya kolámabe? ");
INSERT INTO snp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lamo mona nosámami melonimo yamu lifimate efe loto nemo ya itibito oloba, ido wewa ama mona nosámami ma melámami ne, loto ");
INSERT INTO snp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","eti loto loumami, Yesuwo, kiyaba we wekudi enanimo kamenalo ya namomu kolinabe? loto lito, ");
INSERT INTO snp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ya itibito loumami, Namo ka ona lokomowe. Onema ya namote Paladaisika minenaliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ena folilo, tuwelu (12) kiloku yalomati u lunaga tili (3) kiloku ya fo ádaito, mikau-mikau muki ya sinidomo wiye. ");
INSERT INTO snp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sinidomo wito, ido felegaga kuliyai numuna naba lulau ya eyetenawae, loti lafo-lafo naba kailamo ya filiga-filiga fekailami ne. ");
INSERT INTO snp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ido Yesukafo au naba loto eti limo, Menefo, agalo oune ya melowe, loto wela-mula fuli lito folaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Folaito, kimiwe kiyabani wekafo neta ya eyeto, Goti ebola loto eti limo, Wewa ya moda monala efe loto melami we ya minaiye, loto liye. ");
INSERT INTO snp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ido wenena muki neta kenune, loti o fedeti mau minamo yate netawa koti koliti, seni-mulunigu keina koliti, ikinido ofoti itibiti monimo wae. ");
INSERT INTO snp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Eti afa, aulafo-motati ido Galili mikaloti ege melamo wenaipati ya faiga nedi minoti netawa koti koliti minae. ");
INSERT INTO snp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ena we ma nemo kuliya Yosefe ya Yuda kanisole we minami, we lalo monala efe limo ne. ");
INSERT INTO snp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ido auwafo-mota Yesu ofo fulunune, loti lamo kamenalo ya amo eti enune, loto ádaiye. E’e, aya wewa ya oloto piyami numuna meya ya Yuda wenena numuni kuliya Alimatea wewa ya Goti wekudi wenenala kiyaba o ledami kamena ya kiyaba omo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aya wewa yakafo Pailati nedo uto, Yesu kono ukana ya numunabe? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O, lito uto kono ukana ya yá yofoloti oluto, lafo-lafokafo asa wito, oluto uto kifana lulau kono melenune, loti olufe loti kono yau melámagu yau Yesu kono ukana ya mele edaiye. ");
INSERT INTO snp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mele edaito, aya kamena kuliya Olufe Lenawamo Kamenale, loto neto Sabati foliwa alitimo oloto pinagoliye. ");
INSERT INTO snp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ido wenaipa Yesuki Galili mikaloti lakoina amo ya Yosefe ege uti, kifana lula eyeti, ido kono ukana kifana lulau melami monala ya ko fuli loti, ");
INSERT INTO snp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","numudoka itibiti uti, yá nowala ladanuwa imo fili edenawamo neta olu mau wiyafa, lo melami ka meyalo meleti Sabati foliwalo lono olámae. ");
INSERT INTO snp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ena Sabati foliwa fuli lito salele komu kamenalo ko lenagolido wenaipawa neta ladanuwa imo neta olu mau wiyamo neta yama kifana lula limo ebalo oluti wae. ");
INSERT INTO snp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","U fedeti eyamo kifana naba kale wela itamo yama ya kululu wito kale wela godo minaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Godo minaito, lulau diti Wekola Yesu kono ukana moni wilafa, olu oloto piyámae. ");
INSERT INTO snp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Olu oloto piyámoti yamu kani ligi-ligi ki minato, kaita we lele ma ukanido owo ko sili gae-gae fulamidana lamena imo wiyami ya oloto piti nedi minaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nedi minami ya geyeti koli gimaito, kuba wi umuti mikalo ko minato, wewa yate eti loti logimami, Linate nediti omuna kofawa nemo we ya folamo wenena minagu yau moni wilaiye? ");
INSERT INTO snp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Amo ya folaiguti kofa neditami ne. Amau ya minámaiye. E’e, amo yakafo linateki Galili mikalo minami kamenalo logimami ka kolalo. ");
INSERT INTO snp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eti loto logimami, We Kula namo ya lifimanina nemo we anido melato, yá yofolo nofo folato, fo kamena lelei-lawokoi (3) wageto ya kofa nedinagolowe, loto logimaima ne, loti laiye. ");
INSERT INTO snp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eti laito, wenaipa Yesu logimami kala ya kani ki minae. ");
INSERT INTO snp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ena kifana lula yaloti itibiti numudoka uti, ege-ege moinamo we leweni (11) yaki, ido liliga wenenaki netawa muki yamu logimae. ");
INSERT INTO snp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Etiti aposolo logimamo wenaipa ya kulini etito nemo, Malia Madala numudoti ami, ido ma Yowana, ido ma Yemusi olafo Malia, ido liliga maleka yaki lakoina minae. ");
INSERT INTO snp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Eti loti kawa logimafa, ido kanina kolamo ya fa ka lae, loti koliti koli kiki ádae. ");
INSERT INTO snp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Koli kiki ádato, Pita ya nedito, kifana lula limo ebalo oluloto o fedeto, kuba wito eyami lafo-lafo yako neto koto, nedi-nedi iye? loto numudoka itibito kala kimo wiye. ");
INSERT INTO snp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ena aya fo kamenalo ege melamo we minagu yati lele ma Emeusi numudo unaliye, loti waiye. Numunawa yaloti Yelusalemu ya leweni (11) kilomita yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ena wewa lelema ya kanudo monimo uti, neta muki oloto piyami yamu lokoli-fakoli omo waiye. ");
INSERT INTO snp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Etiti lokoli-fakoli omo waito, Yesu aimola ya oto amodo ekelaito, lakoina wafa, ");
INSERT INTO snp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","makafo olu omuni likami yaidana oti edaito eyefe loti eyámaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eyefe loti eyámaito, amokafo eti logimami, Linate kanudo monimo aido ya nena netamu lokoli-fakoli omo aiye? loto loga o gedaito, lelewama momoga oti ámuti, faifa nedi minoti, koni-weni keina iye. ");
INSERT INTO snp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ena ma ya kuliya Kiliyopasi yakafo loga o edami, Wenena muki Yelusalemu oti minamo ya koli fuli linako, kamoko netawa oloto piyami neta ya kolámabe? lito ");
INSERT INTO snp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","loga o gedami, Nena neta yae? lito itibiti loumami, Yesu Nasaletekati ami we kala yae. Amo ya polofete minoto ido Goti omunaloti ido wenena muki omunidoti ya neta o-o imoki ido ka lo-lo imoki ya auma wiyami ne. ");
INSERT INTO snp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Etito auma wiyami nefa, yokila ki umamo we wenabaninaki ido lamo kiyabate weki yate ana-kiyanalo oluti ofo fulunawae, loti kuwolafo-mota anido melato yá yofolo ofo folae. ");
INSERT INTO snp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eti afa, lalimote aimola ya lamo Isilaeli wenena ya meina fito efili ledenaiye, loto komu kolone. Ido netawa oloto piyami fo kamena lelei-lawokoi (3) yaidana moda utami ne. ");
INSERT INTO snp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ido minonigu yauti wenaipa mate olu elegi ledae. Amo ya leda luwaila kifana lulau uti ");
INSERT INTO snp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kamo ya kono ukana ya moda olu oloto piyámoti, itibiti lamodoka oti eti lamo, Lamo yate famo yaidana oto eyonimo enisole lele oloto pi lumuti, Yesu ya kofawa minaiye, loti laiye, loti lolomae. ");
INSERT INTO snp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ena kawa kolito, lamodokati autefo-mota liligaleka ya kifana lula yau uti, wenaipate lolomamo yamaidana oti ya ayalo eyafa, ido aimola ya eyámae, loti loumaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Loumaito, amokafo eti loto logimami, Linate ya ka manidigu minámami wenena, seti-muludi gedimo yamu polofete ka lamo muki ya koli kiki ádo minae. ");
INSERT INTO snp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kolife loti kolámaife? Goti ilifi melami we Kilisto ya komu netawa keina naba-naba kolitoto lamenalau ya dinami ne, loti kolámaife? Olo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eti logimami ya Mosesekafo ka lufuwa wiyami ka yaki, ido polofete muki lufuwa wiyamo ka yaki yaloti apito mono lufuwau yau muki neta aimola yamu lamo ya olu oloto pi gedemo wiye. ");
INSERT INTO snp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ena uti Emeusi numuna meya olu alitato, Yesu ya eba malo monimo unae, loto ifa, ");
INSERT INTO snp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","E’e, loti auma witi eti lami, Fo lomami ya sinidenami nenako, kamo lamoki minenune, loti laito, amoki minenae, loto koli gimaito, numugu lakoina idae. ");
INSERT INTO snp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Numugu diti, weni-neta nenawamo folomolo amedoti minato ya beleti oluto leketo, siyane, lalole, loumuto apito gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Apito gimaito, omuni olu falato gedaito eyefe lami kamenalo ayalo eyámaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eyámoti inanimo eti loti lami, Kanudo lolomami ya ka mono lufuwauti monawa ya olu oloto pito lolomaito, sete-mulude idami ne, loti laiye. ");
INSERT INTO snp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eti loti ayalo nediti Yelusalemuka itibiti waiye. U fedeti geyami ya ege-ege moinamo we leweni (11) yaki, ido aunige-motaki mau witi minamo eti loti lamo, ");
INSERT INTO snp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ya onae. Wekola ya folaiguti moda nedito, Saimoni oloto pi umaiye, loti lato, ");
INSERT INTO snp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","lelewa ya ayaidana oti kanudo neta oloto pi gimami monaki, ido Yesu ya beleti lekaito eyefe loti eyami monawa yaki logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kawa logimi minado ya Yesu aimolakafo minagu yau oloto pito nedi minoto eti loto logimami, You amene mona ya linatedoka mino gedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Logimaito, kolofa oloto piyaiye, loti kani ki minoti ya ukani ololo oto koli naba-naba gimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Koli gimaito, amokafo eti loto logimami, Nediti seti-muludigu keina koliti kati ligi-ligi ki minae? ");
INSERT INTO snp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ama ya nanimo yama minowe. Linate ane-kiyane eyalo. Ena oti ukane oluti neyefe lalo. Kolofa ya aumalaki ukana emilalaki minámaifa, namo aumaneki ukane emilaneki minomo ya neyalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eti logimito ana kiyana gilibaito, ");
INSERT INTO snp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","kawa koliti elegiti alikani amo yamu auma witi koli kikito umámato, eti loto loga o gedami, Konuma ma nefe? Nenagolowe, lito, ");
INSERT INTO snp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","laefa kiyamo ma ya olu umato, ");
INSERT INTO snp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","oluto omunido naiye. ");
INSERT INTO snp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ido nototo eti loto logimami, Kolalo. Mosesekafo lo melami ka ya lufuwa wiyaigu, ido polofete yate lufuwa wiyagu, ido Mono Nema lufuwa wiyagu yau namomu lufuwa wiyamo ka muki yama u ayalo winaiye, loto namo linateki minodoma eti loto logimomo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eti logimito ka mono lufuwa wiyamo kolife loti kolinagilae, loto api gilibi minoto ");
INSERT INTO snp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","eti limo, Kolalo. Etiti lufuwa wiyamoma ne: Goti ilifi melami we Kilisto ya keina naba kolito, folageto fo kamena tili (3) wageto fulunaiguti kofa nedinaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Neidageto, kuliyalo ya wenena seni-muluni olu eleyapa winawamo ya lifimanina kilili o gedenaiye, loti lo oloto gimimo unawae. Ido kala kuwa lo oloto gimimo unawamo yate Yelusalemu yaloti lonowa apiti wenena mikau-mikau minagu ya uti kala kuwa lo oloto piti logimimo unawae. ");
INSERT INTO snp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ido linate netawa kamo ya wenena logimimo walo. ");
INSERT INTO snp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ido namo ya neta ma Menefokafo giminae, loto lo mele gedami netawa ya linatedoka ya ilifi melenae, loto logimowe. Ido numuna meya naba yau kiyaba oti minomo wato, akaiyati auma ya lumuto mino gedageto yaloti ya apiti logimimo unagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ena numudoti gilimito uto Betani numudo adu fedeto ana faka loto Gotikafo olu lalo o gedo, loto ");
INSERT INTO snp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","lo minaido ya fulo gedeito kosinalo idaiye. ");
INSERT INTO snp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Idaito, kuliya olu faka loti, ouni-lunikani umuti, alikani naba-naba oti, Yelusalemuka ya itibiti wae. ");
INSERT INTO snp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Itibiti uti kamena-kamena felegaga kuliyai numuna nabau minoti, Goti ebola lo-lo o minamo ne. Modae. ");
INSERT INTO snp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka ya kana monau akaimati minomo dito minoto ya Gotiki lawoko mino edemo idami ne. Ido Kawa ya Goti aimola ya ne. ");
INSERT INTO snp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ido Kawa ya kana monau akaimati Gotiki lawoko minoto mino edemo idami, ");
INSERT INTO snp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ya neta-mata muki oloto piyami ya amo yakafoko olu oloto piyami ne. Etito amo ya minámami neko, mika, kosina, neta-mata muki ya oloto piyámagi ne. ");
INSERT INTO snp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ido amodoka ya kofawa minomo idami mona kula ya ne. Ido aya kofawa minomo idami mona kulawa yakafo wenena olu lamena o ledami ne. ");
INSERT INTO snp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lamenawa yakafo lumiku ya lamena ito, lumikafo lamena eifámaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ena we ma kuliya Yoni ya lamenawa yamu lo oloto melageto, wenena muki yate lamena aboga koli kikito umunawae, loto Gotikafo ilifi melami ne. ");
INSERT INTO snp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ilifami wewa Yoni ya lamena aboga minámaiye. E’e, faifa lamena aboga kala kuwa lo oloto melami we ya ne. ");
INSERT INTO snp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ena lamena aboga wenena mikau-mikau olu lamena o ledami ya Yoni kamenalalo ya mikalo oloto pito ami ne. ");
INSERT INTO snp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mikalo ami wewa ya aimola aumalakafo mika ya olu oloto piyaifa, mikaleka wenena yate kofe loti eyámae. ");
INSERT INTO snp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ido aimola ebalaleka oloto pito aifa, wenenala ya amoki koina wiyámamo ne. ");
INSERT INTO snp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Koina wiyámafa, ido wenena ma amoki koina witi kuliya koli kikitoti moni minamo wenena ya Goti nomilipala minenawamo kanu ya olu oloto pi gede minaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wenena ukanigutiko oloto piyamo wenena ya Goti nomilipala minámae. Ido we wena ekelenaliye, loti ekelaigu yauti oloto piyamo wenena ya Goti nomilipala minámae. Ido wenena linanimoni kani kiyado yati Goti nomilipala ya oloto piyámae. E’e, Goti nomilipala ya Gotidokati oloto piyamo minae. ");
INSERT INTO snp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ena Kala ya ukana atuwaki oloto pito, lamo minonigu ya minoto, nasafili ido mona ona kula aboga minami we ya lalimote lamena monala eyonimo, ya Metefo Nalafo lawoko lamena monala yaidana oto ne. ");
INSERT INTO snp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ena amomu ya Yonikafo lo oloto meleto, lo faka loto eti limo, Aiga ami we ya namo oloto piyámoneto minomo idami we nenako, namo olu fulo nedeto wenaba ona nemo ne, loto logimitomo we yama ama ya ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ena nasafili aboga yakafo lamo wenena muki ya amodokati nasafili o ledemo wiye. ");
INSERT INTO snp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Goti lo melami ka ya Mosese anau meleto lomaima nefa, Yesu Kilistodokati nasafili o ledeto mona ona kula ya lilibaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ena Goti ya we makafo eyami we ma minámaiye. E’e, Nalafo Goti lawoko Melafo kemanau minami wekafo ya monala olu oloto pi lomami ne. ");
INSERT INTO snp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Ena Yelusalemu numudoti Goti yokila ki umu-umu amo we ido felegaga kuliyai numuna naba kouba-naba we ya Yuda wenena yate gilifi melato Yoni nedo uti ya loumamo, Kamo ya kema we ma minane? loti loga o edato ya monala olu falukámoto, lo oloto meleto eti loto logimami, Namo ya Goti ilifi melami we Kilisto yama minámowe, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Logimaito, ya amo yate kofa loga o edamo, Ena kamo ya kema minane? Elaiya minabe? lato itibito logimami, E’e, namo Elaiya minámowe, lito amo yate lamo, Kamo polofete kiyabala onimo we yama minabe? lato ya amo, E’e, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eti limo yamu amo yate eti loti loumamo, Ena kamo ya kema ma minane? Kamo animo yamu lilifi melato one. Kamo kaimoka ya yaidana we minowe, loto lolomageto uto logiminune, loumae. ");
INSERT INTO snp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Loumato, eti logimami, Polofete Aisaiya eti limo, Kofo mikau yalo we ya welauti ka auma wito eti loto lo oloto melenami, Wekola kanula ya olufe lalo, loto lo minenaiye, loto ka mono lufuwau (Ais 40:3) nemo ka yama oiya namo ya o fedowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ido Falisi we minaguti Yonidoka gilifi melato wamo wenena yate ");
INSERT INTO snp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","loga o edeti lamo, Ena ka lanimo ya namo Goti ilifi melami we Kilisto ya minámowe. Ido Elaiya ya minámowe. Ido polofete kiyabala onimo we yama minámowe, loto lanimo ya kamo nedito noku wi gede-gede ane? lato, ");
INSERT INTO snp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yonikafo eti loto logimami, Namo ya wenena no yakafoko noku wi gede minofa, ido linate minagu yau we ma oloto pito minami we ya linate eyefe ádae. ");
INSERT INTO snp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Amo ya nege aifa, namo efe ya amo yaidana we ya minámonako, kiyanalo wiyami neta efilinamo ya efe ádenagoliye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kawa ya Betani numudo Yodani no filiga afulaleka yalo ya Yonikafo wenena noku wi gedaido, yalo ya kawa ya oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ena leda ya Yesu Yoni nedo ya wito, faigati eyeto ya wenena eti loto logimami, Eyalo. Goti Sipisipila Momola yolakafo wenena mikau-mikau lifimate olu moufami we ya ne. ");
INSERT INTO snp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Olu moufami we yamu eti logimoma, Aiga ami we ya namo oloto piyámoneto minomo idami we nenako, namo olu fulo nedeto wenaba ona nemo ne. ");
INSERT INTO snp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ido nanimo komu ya eyefe ádomo nefa, monala ya linate Isilaeli wenenane logimoneto kolinawae, loto ya o fedeto nokafo noku wi gedoma ne, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ido ka ma aimola omuna eyami neta yamu Yonikafo eti loto lo oloto pi gimami, Ouna ya nema mulu yaidana oto kosinauti lumuto amodoka ya neto eyomo ne. ");
INSERT INTO snp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nanimo komu ya eyefe ádofa, nokafo noku wi gedomo lonowa nomami wekafo eti loto lonomami, Ouna ya lumuto amodoka ya minageto eyenagolane. Eyenanimo we ya Ouna Felegagakafo noku wi gedenagoliye, loto lonomami ");
INSERT INTO snp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","yamu namo neta ya komo nenako, loto monala eti loto logimoma, Amo ya Goti Nalafo ya ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ena leda ya Yoniki ido ege melamo we yauti we lele yaki ebawau ya minato, ");
INSERT INTO snp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu leketo ayalo ya wito, Yonikafo eyeto we lele ya logimito limo, Eyailo. Goti Sipisipila Momola yola ya ne, lito, ");
INSERT INTO snp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","lele ya kawa koliti Yesu ege waiye. ");
INSERT INTO snp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ege waito, Yesukafo oluwe oto geyeto ya, Linate ya nediti aiye? lito ma yakafo limo, Api lilibanimo we, numuga egau ya minane? loto loga o edaito ");
INSERT INTO snp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ya logimami, Oti eyailo, loto logimaito, lele ya ege-ege uti numuna eyeti ya fo lunaga melenae, loto ito yalo ya Yesu minaido ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ena Yoni kala koliti Yesu ege wami we ma Saimoni Pita kunalafo Adulu yakafo ");
INSERT INTO snp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","alako uto yalafo Saimoni olu oloto pi edeto, eti loto loumami, Lamo Mesaiya olu oloto piyoiye, loto limo, ya kawa monawa ya Gotikafo ilifi melami we Kilistole, loto ne. ");
INSERT INTO snp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kawa loumuto ya Yesu nedoka ilimito wito, Yesukafo eyeto ya limo, Kamo Yoni nalafo Saimoniyo, kulika kofawa Sifasile, loto ya melowe, loto limo, ya Yuda wenena kanidokati kuliya Sifasi, ya Giliki wenena kanidokati ya kuliya Pita ya ne. ");
INSERT INTO snp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ena leda ya Yesukafo Galili mikalo unae, loto ya Filipi eyeto eti loumami, Kamo nege-nege ano, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Loumami wewa Filipi ya Adulute Pitate numunani Betesaidakati ami we ne. ");
INSERT INTO snp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wewa Filipikafo uto Nataniyeli eyeto eti loumami, Mosesekafo lo melami ka lufuwa wiyaigu ido polofete yaki lufuwa wiyagu yau we yamu wiyamo wewa yama oiya olu oloto piyone. Ya we ya Nasalete numudoti ami we Yosefe nalafo Yesu ya ne, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Loumaito, Nataniyelikafo ka eti loto itibito loumami, Nasalete numudo yati neta lalo ma oloto pinami nefe? lito Filipikafo loumami, Kamo oto eyo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eti loumaito, Nataniyeli ya uto Yesu nedo u fedaito, Yesukafo eyeto ya limo, Eyalo. We ama ya Isilaeli we kula nemo ya siya-mulunau ka suki ya ma minámaiye, lito ");
INSERT INTO snp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyelikafo loga o edeto limo, Kamo egaidana oto ya namo neyeto lane? lito Yesukafo limo, Filipikafo luka fiyámaito ya yá ade monau ya minageto keyoma ne, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Loumaito, Nataniyelikafo eti loto loumami, Api lilibanimo we, kamo Goti Nalafo Isilaeli wenena kiyabate we wekudi ona ya minane, lito ");
INSERT INTO snp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesukafo limo, Yá ade monau ya minanima lo oloto pi komomo yamu koli kikito nomabe? Aiga ya neta naba kulawa ya oto dito eyenagolane, loto, ");
INSERT INTO snp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ido ka ma enu wito limo, Namo ka ona kula logimowe. Linate kosina godageto Goti enisolela yate We Kula namo minodo ya diti lumuti ato geyenagilae, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ena lono kamena lele fuli lito Galili mikalo Kana numudo ya we wena anido olu giminune, loti weni-neta ofo ki minado, Yesu olafo ayalo minaito, ");
INSERT INTO snp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu yaki ege-ege moinamo we yaki lo mele gedato ya ae. ");
INSERT INTO snp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ato, wenena mau witi neta no minato, no waini fuli lito ya Yesu olafokafo loumami, No waini ma minámaiye, lito ");
INSERT INTO snp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesukafo loumami, Moiyo, lono yamu ka lonomámo. Kamenane oiya nefe? loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Loumaito, olafokafo numuna aboga kouba-nabala we eti loto logimami, Lono ma logiminami ya olalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ena numuna yalo ya kifana malu naba begako sikisi (6) neto, ya Yuda wenena ka mono monanina ya neta-mata kamena-kamena noku wi-wi amo yamu numugu-numugu no maluku ya minomo wiye. Maluwa ma yau dalamu kefolau kamena faifu (5), ido ma yau kamena seweni (7) ya no fiti olumo leki-leki amo ya nabanina etito ne. ");
INSERT INTO snp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Etito neto ya Yesukafo numuna aboga kouba-nabala we eti loto logimami, Linate no fiti maluku yau leikalo, lito amo yate eti oti no ya fiti leikato lumuto faito fulitaito ");
INSERT INTO snp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesukafo eti loto logimami, Linate ma fiti konuma-kobina kiyaba imo weloka ya oluti walo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Eti logimaito, no fiti oluti wato, no yakafo no wainika wito weni-neta kiyaba imo we ya no kolaifa, monala kolámami, kouba-naba we no fiti maluku leikamo we yateko no waini monala kolife lae. Ido weni-neta kiyaba imo we yakafo wena olami we ilimito oto ");
INSERT INTO snp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","eti loto loumami, Komu no waini leya imo gimogeto, noti kani-manini u kopa ito aiga no waini leya ámami ya gimi-gimi onima ne. Monate etito nema nefa, kamo ya olu eleyapa wito leya imoma ya miwitaniguti oiya oloto piyaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Etito Yesu yakafo Galili mikau ya Kana numudo yalo ya neta kofawa aumala gilibami lonola apito oluto, lamena aumala olu oloto piyaito ya ege-ege moinamo we eyeti koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ena Yesule, olafole, kunalafo-motaki, ido ege-ege moinamo we yaki muki ya Kana numudoti lumuti Kapeneyamu numudo o fedeti ya kamena malekako yalo ya minae. ");
INSERT INTO snp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ena Yuda wenena Gotikafo Elita O Gedami foli kamenani alitito, Yesu ya Yelusalemu numudo ya dito ");
INSERT INTO snp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","felegaga kuliyai numuna naba kilalau dito eyami, ya Goti yokila ki umunawamo yamu sipisipi, bulumakau ido nema mulu ya kifanalo fulamo wenena, ido folomolo ya kifana kola ailo-ailo nemo ya olu filiga-filiga amo wenena ya Yesukafo geyeto, ");
INSERT INTO snp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","nela ya miyaito u kefaka wito, wenena yaki sipisipi bulumakau yaki ginifo-ganifo o gimaito koli wato, kifana-afana yaki oluto fululu kito, folomoti yaki itufu-matufu oto, ");
INSERT INTO snp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nema mulu olu minamo we ya eti loto logimami, Linate netawa olu fekaitalo. Ama Menefo numunau ya neta kopa eti ato ya maketi yaidana ámaneyo, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Eti imo yamu ya ege-ege moinamo we ya ka mono lufuwau nemo ka yamu eti loti kani kiyamo, Kamo numuga olufe-fe lenae, loto auma wito kolito sene-mulune yo loto kutifi-natifi iye, loto ka mono lufuwau (Sng 69:9) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ena Yuda wenena yate loga o edeti lamo, Kamo eti animo ya aumaka monaka yakafo nena neta olu oloto pi lumunanimo ne? lato, ");
INSERT INTO snp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","amokafo ka itibito eti loto logimami, Linate felegaga kuliyai numuna naba ama ya lukoito namo fo kamena tili (3) wageto kofa ku fukenagolowe, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Logimaito, amote eti loti loumamo, Lamo yate-mete minamo yate felegaga kuliyai numuna naba ama ya melege foti-sikisi (46) ya wito ku fukama nenako, ya kamo ya fo kamena tili (3) yako ku fukenae, loto labe? loti loumafa, ");
INSERT INTO snp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ido Yesukafo ukana yamu olumo felegaga kuliyai numuna nabalo ya meleto kepa ka logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eti loto logimito minoto folaiguti neidaito ya ege-ege moinamo we kawa ya kolife lamo ne. Ido Yesu kala limo yaki ido ka mono lufuwau ya Goti kala wiyamo yaki ya koliti ya koli kikitamo ne. ");
INSERT INTO snp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ena Yesukafo Goti Elita O Gedami foliku ya Yelusalemu numudo ya aumala gilibami neta mona-mona imo ya wenena mukite eyeti kuliya koli kikito umafa, ");
INSERT INTO snp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ido Yesukafo wenena monani geye fuli linako, ya amodoka metolito minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Amo ya we ma monala kolinae, loto wenena maleka loga o gedámami ne. E’e, aimolakafo wenena seni-mulunigu ya ko fuli loto geyaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ena Falisi we minagu yauti we ma nemo kuliya Nikodemusi ya Yuda mono kanisole we ya ");
INSERT INTO snp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","luwaila Yesu nedo oto ya eti loumami, Api lilibanimo we, lamo monaka ya koli minone. Kamo api lilibanimo we ya Gotidokati anima ne. Kamo neta kofawa olu oloto pi lumu-lumu animo, ya Goti kamoki minámami neko, etito olu oloto piyámagi ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Eti loumaito, Yesukafo ka itibito eti loto loumami, Namo ka ona kula lokomowe. Ma ya auma wito kofawa oloto piyámenami yakafo Goti wekudite wenenala kiyaba o ledami kilala ya eyámenagoliye, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Eti loumaito, Nikodemusikafo eti loto loga o edami, Aiyo, we ma naba ditami yakafo ya egaidana oto kofa nomilipa namuna buluto oloto pinami ne? Egaidana oto kofa olafo mulunau ya idageto kofa ya kedenami ne? loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lito, ya Yesukafo eti loto loumami, Namo ka ona kula lokomowe. Ma ya nokuti ido Ounauti kofawa oloto piyámenawamo ya Goti wekudite wenenala kiyaba o ledami kilalau ya ma ámunagilae. ");
INSERT INTO snp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wenena ukaniguti oloto piyamo ya faifa wenena yaidana oti minae. Ido Ounau yati kofawa oloto piyamo ya ouni ya Goti Ouna yaidana oti minae. ");
INSERT INTO snp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kofawa oloto piyaneyo, loto lomo ya kolito kaka ligi-ligi kiyámo. ");
INSERT INTO snp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Epe ya kopa-napa o-o minoto ya kokoweke limo yako koli minane. Monawa ya egalekati apito aife? Ido u egaleka fuli life? Ya ma kolámone. Ounau yati oloto piyamo wenena ya ayaidana oti minae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Eti lito, ya Nikodemusikafo ka itibito eti loto loga o edami, Ya egaidana oto eti enumo ne? lito, ");
INSERT INTO snp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesukafo ka itibito loumami, Kamo Isilaeli wenena api gilibanimo wema minaba, kolife ádabe? ");
INSERT INTO snp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Namo ka ona kula lokomowe. Lamo neta kolonido ido eyonido, ayalo ya loto lo oloto gilibi minoba, linate ya kate ya koli fulo minae. ");
INSERT INTO snp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ido mikaleka neta yamu logimomo ya koli kiki ádanako, kosinauka neta yamu logiminamo ya egaidana oti koli kikitenawamo ne? ");
INSERT INTO snp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wenena ma kosinauka idámae. We Kula nanimo lawoko yako kosinauka minodoti lomomo ne. ");
INSERT INTO snp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ido Mosesekafo komu afimaleka ya kofo mikalo ya koiyofa lebonala olufe loto olu faka limo yamaidana oti We Kula namo ya olu faka lenagilae. ");
INSERT INTO snp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Olu faka lenagilanako, koli kikito numunawamo wenena muki ya kofawa minowa-minowa oti minomo dinagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ena Goti yakafo mikalo wenena muki ya siya-muluna oto dito gimami yamu Nalafo lawokoko ilifi melaima, ya koli kikito umunawamo wenena ya u kopa ámuti, moda kofawa minowa-minowa oti minomo dinagilae, loto ilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ilifi melami, ya mikalo wenena lifima ka olu itibito giminae, loto ilifi melámaiye. E’e, Nalafokafo wenena olu omuni kenaiye, loto ilifi melaito lomaiye. ");
INSERT INTO snp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Koli kikito umunawamo wenena ya lifima ka olu itibito gimámenami ne. Ido koli kikito umámenawamo wenena ya Goti Nalafo lawokoko kuliya koli kikito umámanako, yamu lifima ka olu itibito gimami mona oiya ama moda mino gedami ne. ");
INSERT INTO snp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ido lifima ka olu itibito gimami monawa etito ya ne: Lamena yakafo mikalo wenena olu alalili mele gede minaifa, monani nosámaido minanako, lamena ya seni-muluni umámoti, sinidimo ya seni-muluni umae. ");
INSERT INTO snp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nosámami mona mele minamo wenena yate lamena eleka fi umuti, ya monate olu oloto pitenaiye, loti lamedo ya ámoti minae. ");
INSERT INTO snp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ido mona ona kula mele minamo wenena yate Goti lulau mino edeto monate mele-mele onimo monawa ya olu oloto pinagoliye, loti lamedo ya oti minae. ");
INSERT INTO snp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ena aiga Yesuki ege-ege moinamo we yaki Yelusalemu fuliti Yudia mika anawalo ya uti, yalo ya minoti wenena noku wi gedae. ");
INSERT INTO snp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ido Yoni ya nela numugu fulo edámamo kamenalo nenako, amokafo ayaidana oto mika ma kuliya Ainoni adu Salimi numudo ya no so loto nemo yamu neto wenena oti-oti ato, ya noku wi gede-gede iye. ");
INSERT INTO snp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Noku wi gede-gede ito, Yoni ege moinamo we malekaki Yuda we maki noku wiyamo mona yamu moila fiyae. ");
INSERT INTO snp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Moila fiyato, Yoni ege moinamo we yate Yoni nedo ya uti eti loti loumamo, Api lilibanimo we, kamo Yodani no filigaleka afula minageto we ma u keyeto katula ito monala lo oloto pi lomanimo we yamakafo oiya kamena amaleka wenena noku wi gede minaito, ya amodoka u fuli lae, loumae. ");
INSERT INTO snp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Loumato, Yonikafo ka itibito logimami, We ma kosina abogakafo neta umámagaiyama aimolakafo egaidana oto olunami ne? Moda olámenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namo komu eti logimomo, Namo Gotikafo ilifi melami we Kilisto ya minámowe. Minámofa, Gotikafo u komu meleto kanula olufe lo, loto nilifi melaito owe, loto logimomo kawa ya linate moda kolitama ne. ");
INSERT INTO snp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kipa ma ko mele edamo ya wena olunami ya ne. Ido koinalafo adu nedi minoto nola lebona kolito siya-mulunau ya lalo kolinami ne. Yamu namo oiya lalo kolomo mona ya sene-muluneu faitimo ne. ");
INSERT INTO snp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Amo kuliya ya dimo unami, ido namo kuline ya lumumo unami ne. ");
INSERT INTO snp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ena yaleka yowauti lomami we yakafo wenena muki olu fulo ledaiye. Wenena mikaleka oloto piyonimo ya mikalo wenena minoto, mikaleka netamu lo minoba, kosinaukati lomami we yakafo muki olu fulo lede fuli limo we ya ne. ");
INSERT INTO snp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Amo ya koto kolito imo neta yamu lo oloto melaifa, wenena yate kala koli fulo minae. ");
INSERT INTO snp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Gotikafo ilifi melami we siya-mulunau ya Ouna faitoto melainako, Goti kala ya lo minami yamu ka limo koli kikitamo wenena yate Goti monala ya mona ona kula ya ne, loti olu faka lo minamo ne. ");
INSERT INTO snp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Melafokafo Nalafo siya-muluna umuto, neta-mata muki ya analo mele fuli limo ne. ");
INSERT INTO snp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goti Nalafo koli kikito umamo wenena oiya amalekati ya omuni kofawa minowa-minowa oti minomo idamo ne. Ido Goti Nalafo kala golo ádamo wenena ya mino kolimo dinawamo mona ya ágenawamo ne. Gotikafo eleka fi gimami mona moda mino gedami ne. ");
INSERT INTO snp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ena Falisi we yate Yesumu eti loti kolamo, Yonikafo ege melamo wenena naba olu mau wito noku wi gedaito, ido Yesukafo Yoni olu fulo edeto wenena naba-naba olu mau wi gedeto noku wi gedami yamu kolafa, ");
INSERT INTO snp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesukafo aimola ya wenena ma noku wi gedámaiye. Ege-ege moinamo we yako noku wi gede-gede ae. ");
INSERT INTO snp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ido Wekolakafo kawa eti lamo ya kolito, Yudia mika fulito Galili mikalo itibito unae, loto ");
INSERT INTO snp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","unami kanu ya Samalia mikalo ya leketo wiye. ");
INSERT INTO snp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Etito Samalia mikalo ya leketo uto uto numuna ma kuliya Sikali yalo ya u fedaiye. Numunawa ya Yekopukafo nalafo Yosefe mika olu umami ya olu alalili meleto, ");
INSERT INTO snp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ayalo ya Yekopu no kale li melaido ya folilo Yesu u ayalo fedeto, aisa loto kale wela anawalo ya amedoto mino kolaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Minaito, ege-ege moinamo we weni-neta meina finune, loti numudoka ya idato, Yesu aimolako minaito, Samalia wena ma no finae, loto o fedaito Yesukafo eti loto loumami, Kamo no ma nomageto nenae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Eti loumaifa, Yuda wenena ido Samalia wenena yaki weni-neta moi mamakeke loti moi wiyamoma nenako, loto wenawa yakafo eti loto loumami, Kamo Yuda we makafo Samalia wena namodoka nedito nomu ya lane? liye. ");
INSERT INTO snp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Lito, Yesukafo ka itibito loumami, Kamo Goti nasafili monala yaki, ido namo no ma nomageto nenae, loto lokomomo we monane yaki ya kolife lanimo neko, ena ma nomo, loto laniko ya no fiyawa yaidana oto komogi ne, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Loumaito, wenawa yakafo eti loto loumami, We kofawe, no kale fana nenako, kamo no finanimo netaka yaki minámainako, no ma finanimo fiyawa egalekati oloto pinamimu lane? ");
INSERT INTO snp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Autefo-kolofate Yekopukafo no kale ya liyami ama ya ne. Ido amo nalafo-mota yaki, sipisipila, bulumakaula yaki muki no ayau yatiko noti minama ne. Kamo ya Yekopu olu fulo edeto noma olu oloto pinagolo labe? lito ");
INSERT INTO snp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ya Yesukafo ka itibito eti loumami, No amauti nenawamo wenena yate kofa nomu fulunagilae. ");
INSERT INTO snp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ido namo none gimoneto nenawamo wenena ya nomu kofa folámoti fa minomo diti minenagilae. Nowa ya gimito mulunigu ya no fiyawa yaidana oto olu oloto pi gedoneto, omuni kofawa minowa-minowa oti minomo dinagilae, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Eti lito, wenawa yakafo eti loto loumami, We kofawe, kamo nowa ya nomageto noto nomu aiga folámoto, amalo ya oto no fi-fi o minomo ya fulitenae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Eti lito ya Yesukafo loumami, Uto wagafo lula fito ilimito ano, lito, ");
INSERT INTO snp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","wenawa yakafo ka itibito limo, Namo wanefo ma minámaiye, lito, Yesukafo loumami, Kamo wanefo minámaiye, lanimo ya ona efe loto lane. ");
INSERT INTO snp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ido wagafo faifu (5) mofu meleto fulito anima ne. Ido oiya yaki welo ekele minanimo auwae kamo wanefo ya minámaiye, loto lanimo ya ka ona oloto lane, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Loumaito, wenawa yakafo eti loto loumami, We kofawe, kamo polofete minanimo ya oiya ya kolowe. ");
INSERT INTO snp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yamu ya lageto kolinae. Lamo Samalia wenena autefo-mota yate mowa amalo ya Goti ouni-luni-kani umumo idamo ne. Ido linate Yuda wenena yate wenena muki Yelusalemuka ya Goti oudi-luti-kati umalo, loti logimi-gimi ama ne, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Loumaito, Yesukafo eti loto loumami, Wenao, namo ka lokomowe. Koli kikito mino. Kamena ma alili enagolimo, ya ageto ya linate Menefo ouni-luni-kani umunawamo ya mowa amalo ma ámenagilae. Ido Yelusalemuka yaki ámunagilae. ");
INSERT INTO snp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Linate ya kolife ádoti oudiluti-kati umu-umu ae. Olu omuni kami mona ya Yuda wenenadokati nenako, lamo ya kolife loto oude-lute-kate umu-umu o minone. ");
INSERT INTO snp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ido kamena ma enami ya moda fedetaiye. Yalo ya ouni-luni-kani umamo wenena kula ya Ouna lulau mino edeti, aimola monala ona kulalo meyalo meleti ya Menefo ouni-luni-kani umunagilae. Etiti numunawae, loto Menefokafo wenena yaidana o minamo ya moni wilami ne. ");
INSERT INTO snp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goti ya Ouna nemoma nenako, yamu ouniluni-kani umunawamo wenena ya Ouna lulau mino edeti, aimola monala ona kulalo meyalo meleti ouni-luni-kani ya umunawae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Loumaito, wenawa yakafo eti loumami, Mesaiya, kuliya ma Kilisto ya Gotikafo ilifi melami we oloto pinaiye, loti lamo ya namo koli minowe. Amokafo oloto pito neta-mata muki ya lo oloto pi ledenagoliye, lito ");
INSERT INTO snp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesukafo loumami, Kamo lanimo ya namo ya minowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eti lo minaito, ege-ege moinamo we ya itibiti o fedeti wenate ka lokoli-fakoli ami yamu kani mumudi kiti, Nena ka loumane? Nedito lokoli-fakoli o minaiye? loto loumunune, loti kolafa, keina ito fulitae. ");
INSERT INTO snp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ena wenawa yakafo no nomula fulito numudoka ya itibito uto wenena eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Linate oti we ma yakafo neta oto meleto omo muki lo oloto pito lonomami ya eyalo. Ya we ya Gotikafo ilifi melami we Kilisto ya nefemo? lito, ");
INSERT INTO snp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","koliti numuna meyaloti lumuti ya Yesu nedo wokele, loti wae. ");
INSERT INTO snp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wato, Yesu ege-ege moinamo we ya amo nedo minoti, ka auma witi loumamo, Api lilibanimo we, weka-neta no, loti loumato, ");
INSERT INTO snp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","amokafo logimami, Kobina ailoma olu minofa, ya linate ma kolámae, lito, ");
INSERT INTO snp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ege-ege moinamo we ya lokoli-fakoli oti lamo, Wenena makafo konuma-kobina oluto oto olumo umaifemo? loti lae. ");
INSERT INTO snp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Eti lato, ya Yesukafo logimami, Nilifi melami we kala lalo kiyami mona ya meyalo meleto lonola olu fuli lenamo ya namo wene-neta ya ne. ");
INSERT INTO snp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Linanimotina eti loti lo-lo amo, Ikana fo (4) ya fuli lageto ya kobina kula lotainako, pili nenune, loti lafa, nanimo logimowe. Linate ko faka loti koti lono kila eyalo. Kobina kula limo kamena oiya eti-mati ya moda fedetaito, ");
INSERT INTO snp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","oluti olu mau-mau wiyamo wenena yate meinawa olu minae. Ya meinawa kula yakafo wenena muki omuni kofawa minomo dinawae. Yamu neta olu kifamo wenena yate kulawa olu mau wiyamo wenena yate lakoina alikani enagilae. ");
INSERT INTO snp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yamu ka ama ya eti lamo, Ma yate neta olu kifi-kifi ato, ido ma yate kulawa olu mau wi-wi ae, loti lo-lo amo ka ya ona ne. ");
INSERT INTO snp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Linate neta olu kifámaguti kula olu mau winawae, loto ya namokafo gilifi melowe. Lonodo we mate lono olato, kula moda lotami ne. Linate ya kulawa lakoina olu mau wimo wae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ena Samalia wenawa yakafo numunaloti wenenala eti loto logimami, Neta oto meleto omoma muki ya lo oloto nomaiye, loto logimami ka yamu ya wenenala mukite Yesu koli kikito umamo, ");
INSERT INTO snp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","yamu Yesu nedo u fedeti lamoki minenune, loti Yesu wako lo edamo ya Yesukafo koli gimito, oto fo kamena lele amo numunido ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Minoto ka mono logimaito, wenena muki koliti koli kikito umamo, ");
INSERT INTO snp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","yamu wenawa ya eti loti loumamo, Komu ya kamo kakalo oto koli kikitonimo nefa, oiya ya lalimote ka limo welaloti ka kolito ya koli kikitone. Wewa ya ona mikau-mikau wenena olu omude kenami we ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Ena Yesu ya komu lo oloto meleto eti limo, Polofete ma aimola numuna ebalalo minenami ya kuliya olu faka ádenagilae, loto linako, Samalia wenenaki fo kamena leleko minoto Galili mikalo wiye. ");
INSERT INTO snp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Uto Galili mikalo ya u fedaito, komu ya Galili wenena muki ya Yelusalemu uti Gotikafo Elita O Gedami foliku ya minagu ya Yesu lono olaito eyamo yamu amoki koina wiyae. ");
INSERT INTO snp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ido Galili mikalo Kana numudo ya komu ka lito no yakafo no wainika wido yalo ya kofa itibito oto minaiye. Ido Kapeneyamu numudo kiyaba we wenaba ma nemo ya nalafo neta naba kilami, ");
INSERT INTO snp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","yamu Yesu ya Yudia mikaloti itibito Galili mikalo kofa o fedaiye, lato ya kiyaba we wenabawa ya kolito, Kana numudo Yesu nedo dito, nalafo fulunami kamenala adu melainako, yamu Yesu ya lumuto, nanefo olu faka lo edenane, loto wako lo edaiye. ");
INSERT INTO snp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Eti lo edaito, Yesukafo eti loto loumami, Linate ya neta kofawa aumane gilibomo neta ya omudi ágenawamo ya koli kikito nomámenagilae, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eti lito, kiyaba wekafo eti loto loumami, Wenabao, nanefo moda fulutenaiye, loto kenemane oto enabe? lito ");
INSERT INTO snp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesukafo eti loto loumami, Nakafo moda omuna kofawa minaiye. Faifa wo, lito ya kiyaba wekafo Yesu ka loumami ya koli kikitoto itibito wiye. ");
INSERT INTO snp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ena itibito uto kanudo monimo lomaido ya lonola olamo we oti katula oti ya, Nakafo moda omuna kofawa minaiye, loumae. ");
INSERT INTO snp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eti loumato, ya faka limo kamena yamu loga o gedaito, amote eti loti loumamo, Ena amo ya melo fo muliti neto ya ukana yopayo wiyami ya fulo edaiye, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ido kiyaba we yakafo monawa eti loto kolami, Kamena yalo ya Yesukafo, Nakafo moda omuna kofawa minaiye, loto lonomami ne, loto kolito, uto amo yaki ido numunalo lakoina minamo wenenala muki yaki koli kikitae. ");
INSERT INTO snp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesukafo etito netawa kofawa ya ototo Yudia mikaloti Galili mikalo itibito uto minaido ya neta kofawa aumala gilibami ya kamena lele olu oloto pi gimaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Minoto aiga ya Yuda wenena foli kamenani naba ma alitito Yesu ya Yelusalemuka idaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ena Yelusalemu kanu wela ma kuliya Sipisipi Kanuwae, loto nemo kanu anawalo ya nofuna ma nemo kuliya Beteseda anawalo ya kolokalo numuna faifu (5) ya minomo wimo, ");
INSERT INTO snp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ayau ya wenena neta kilamo, omuni likami, kiyani bemu imo, ukani ipedimo, muki wenena yau ono minae. ");
INSERT INTO snp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ena Wekoladokati enisole makafo kamena ma nofugu ya lumuto no ya olu momoga iye. Olu momoga ito neta kilamo wenena yauti ma komu lumuto noku wito neta kilamila ya olu faka lo edaiye. Yamu wenena muki no ya momoga enaidole, loti kiyaba ae. ");
INSERT INTO snp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ena we ma neta kilito onomo idami ya melege teti-eiti (38) ya wiye. ");
INSERT INTO snp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wito, Yesukafo wewa ya eyeto kolami, Kamena fana ono minaiye, loto kolito, loga o edeto limo, Kamo faka lenae, loto koli minabe? loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Loumaito, neta kilami we yakafo eti loto loumami, We kofawe, we makafo no ya momoga agetoma ya noku ya fulo nedenami we ma minámainako, nanimone lumunae, loto o-ofa, ailo-ailote fulo aiga nedeiti lumu-lumu ae, lito ");
INSERT INTO snp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesukafo eti loto loumami, Kamo nedito kunuka oluto moino, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Loumaito, ayalo ya ukana lalo ito, nedito kunula oluto wiye. Ido fo kamena yalo ya Sabati foli kamena ya nemo ");
INSERT INTO snp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","yamu Yuda wenena yate wewa neta faka limo we ya eti loti loumamo, Oiya Sabati foliku ama ya nedito kunuka oluto mofu minane? Ya neta lo fukamo neta ane, loumae. ");
INSERT INTO snp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Loumato, amokafo eti loto logimami, Olu faka lo nedami we yakafo, Kunuka oluto moino, loto lonomami ne, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Logimaito, amote loga o edeti lamo, Kunuka oluto moino, loto lokomami we ya kema ne? lafa, ");
INSERT INTO snp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ido Yesu ya wenena mau naba minagu yau sodoto wito, faka limo we ya kuliya kolámaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eti ito, aiga Yesukafo wewama ya felegaga kuliyai numuna nabau olu oloto pito ya eti loto loumami, Ukaga moda lalo otaiye. Yamu kolito ya neta ma keina naba-naba imo neta ya oto dito oloto pi numutenaiye, loto ya mona nosámami kofa melámo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eti loto loumaito, we yakafo uto Yuda wenena eti loto logimami, Olufe lo nedami wema ya Yesu ya ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ena Yesukafo ya Sabati foliku ya lonowa olami yamu ya Yuda wenena yate olu keina mofu edae. ");
INSERT INTO snp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eti o minato, Yesukafo eti loto logimami, Menefo yakafo lono kamena-kamena olu minami yamu nanimo yaki olu minowe, loto logimami ");
INSERT INTO snp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","yamu amote eti loti kolamo, Yesukafo ya Sabati foli ya olu kopaitami yako minámaiye. E’e, oto dito Goti yamu nanimo Menefo ne, loto aimola ya olu Goti nabamaidana itaiye, loti ya neta lele yamu ofo fulunune, loti koli umumo idae. ");
INSERT INTO snp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ena Yesukafo ka eti loto logimami, Ka ona kula logimowe. Goti Nalafo nanimo senemuluneuti kane kito lono olámenamo ne. E’e, Menefokafo lono olaido ya eyeto, ayalo yako ya olu-olu o minowe. Neta-mata muki Menefokafo olaido ya Nalafo namokafo ayalo olu-olu o minowe. ");
INSERT INTO snp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Menefokafo Nalafo namo siyamuluna numuto, lono olu minami lono nilibi fuli lo minaiye. Ido lono ama ko minamo yako minámaiye. E’e, lono naba nilibageto linate eyenawamo ya eleiginagilae. ");
INSERT INTO snp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Menefo yakafo wenena folamo ya olu nedi gedeto, omuni kofawa olu gimami ayaidana oto Nalafo namokafo we ma wena ma omuni kofawa olu giminae, lenamo ya faifa olu giminagolowe. ");
INSERT INTO snp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ido Menefo ya wenena lifima ka itibito gimámenami ne. Lonowa ya Nalafo namo anelo melami ne. ");
INSERT INTO snp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Etito ya Menefo kuliya olu faka lamo wenena muki ya ayaidana oti Nalafo namo kuline olu faka lo minenagilae. Ma yate Nalafo namo kuline olu faka ádenawamo yate nilifi melami we Menefo ayaidana oti ya kuliya olu faka ádenagilae. ");
INSERT INTO snp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Namo ka ona kula logimowe. Namo kane koli lunigu meleti ido nilifi melami we koli kikito umamo wenena ya omuni kofawa minowaminowa enawamo mona ya moda olutamo ne. Ido lifima ka itibiti olámenagilae. E’e, fulunawamo mona ya fulititi, oiya amaloti ya kofawa minomo dinagilae. ");
INSERT INTO snp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Namo ka ona kula logimowe. Kamena ma enami ya moda fedetaiye. Yalo ya folamo wenena yate Goti Nalafo namo none lebona koliti, omuni kofawa minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Menefo omuna kofawa minomo idami mona ya moda mino edami ne. Ido Nalafo namo yaki ayaidana oto omune kofawa minomo idomo mona ya mino kedenaiye, loto monawa nomami ne. ");
INSERT INTO snp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ido We Kulama minonako, wenena lifima ka itibito olu giminane, loto lonomami ne. ");
INSERT INTO snp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ka ya koliti kati ligi-ligi kiyámalo. Kamena melami ya alitageto ya kono melagu ono minamo wenena ya namo none lebona ya koliti ");
INSERT INTO snp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nedinagilae. Neidato, ya wenena mona lalo melamo ya nedinawado ya omuni kofawa minomo dinagilae. Ido wenena mona nosámami melamo ya nedinawado ya lifima ka itibito giminagolowe. ");
INSERT INTO snp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Namo nanimone oune-lune-kaneloti kolito lono olunamo ma minámaiye. E’e, Menefo welalotiko lifimani itibito gimi-gimi o minowe. Nanimo weneloti lono olunae, loto kolámoto nilifi melami we welalotiko olunae, loto kolonako, lifimani itibito gimi-gimi omo ya efe lenagoliye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ido Yesukafo ka ma mene oto limo, Nanimone monane lenamo yakafo kula ámenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Makafo monane lo oloto mele minaiye. Lo oloto melageto ya kulawa enagoliye, loto koli minowe. ");
INSERT INTO snp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Linate ya wenena Yoni nedo gilifi melato uti loga o edato, ka ona kula lo oloto melaima ne. ");
INSERT INTO snp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nefa, wenena yate monane lo oloto melenawae, loto ádowe. Kawa lomo ya linate kolato Gotikafo olu omudi kenaiye, loto linanimo yamu ya lo minowe. ");
INSERT INTO snp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni ya feiya lamu yaidana oto olu lamena o gedaima ne. Eti ito kamena yalo linate ya lamenala eye lalo meleti minama ne. ");
INSERT INTO snp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nefa, Yonikafo namo monane lo oloto melami ya mulaloko lo oloto piyaiye. Menefokafo lono ka lonomami lono kula olu oloto pi fuli lenane, loto nilifi melaito lomomo ne. Nilifi melami monawa ya lonone yakafo ya olu oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ido Menefo nilifi melami yakafo amo yaki monane lo oloto piyami ne. Linate ya aimola welaloti ka kolámamo ne. Ido kola-wela yaki ya ágamo ne. ");
INSERT INTO snp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ido nilifi melaito minomo ya linate koli kikito nomámanako, kala ya seti-muludigu mino gedámaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Linate ka mono lufuwau ya katoti ya omudi kofawa minenawamo monawa ya olu oloto pinune, loti koliti ya katae. Eti loti katagu ya lufuwa yakafo ya namo monane lo oloto melaifa, linate koli nomámae. ");
INSERT INTO snp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ido linate namodoka ya ato omudi kofawa olu giminae, loto lofa, linate ya eleka ginaito namodoka ámae. ");
INSERT INTO snp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wenena yate namo kuline oto dinawae, loto ádowe. ");
INSERT INTO snp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Linate monatina ya koli minowe. Oudi-luti-kati Gotidoka ya minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","E’e, namo Menefo welaloti linate minado lomomo nefa, linate namoki koina wiyámae. Ena minoto we ma aimola kala kiyaido o fedenami ya amoki koina winawae. ");
INSERT INTO snp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Linate ya wenena yate gebotina lenawamo ya lalo kolafa, ido Goti lawoko minami wekafo gebotina lenami mona ya melenune, loti kolámamo wenena ya linate egaidana oti koli kikito umunawamo ne? ");
INSERT INTO snp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ido linate ya amo yakafo Melafo loumageto ligiya lolumunagoliye, loti ya namomu ádalo. Etito minámaiye. Linate Mosesedoka ekeleti minamo nefa, Mosese aimola kala yakafo ligiya logiminami ne. ");
INSERT INTO snp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesekafo ka lufuwa wiyaigu ya namomu wiyami nenako, linate kala koli kikitamo neko, namoki koli kikito nomagi ne. ");
INSERT INTO snp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nefa, linate Mosese kala lufuwa koli fulitanako, namo kane egaidana oti koli kiki lenawamo ne? loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesukafo ka ya lo fuli loto Galili nofuna kuliya ma Taibeliyasi nofudo yalo ya leketo filiga afulaleka wiye. ");
INSERT INTO snp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wito, wenena mau naba ya neta-mata kilamo wenena olu faka lo gedeto monala gilibaito eyamo yamu ege meleti wae. ");
INSERT INTO snp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ege meleti wato, Yesu ya ege-ege moinamo we gilimito mowalo ya diti amedoti minae. ");
INSERT INTO snp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ido Yuda wenena Gotikafo Elita O Gedami foliwa alitito ");
INSERT INTO snp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ya ko faka loto wenenawa mau naba-nabama o fedato geyeto Filipi loga o edeto limo, Beleti ya egaloti meina fito wenena naba lako ya gimogeto ogofunami ne? loto ");
INSERT INTO snp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","neta enae, loto koli minoto ya kepa meleto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Loga o edaito, ya Filipikafo ka itibito loumami, We makafo ikana eiti (8) ya lono oluto meinala oluto melemo dinami yakafo beleti meina fito gimogeto muni ámenagoliye, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Loumaito, ege-ege moinamo we yauti ma Saimoni Pita kunalafo Adulu yakafo eti loto loumami, ");
INSERT INTO snp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Amalo ya kipa ma nemo yakafo beleti yuwa balikafo olufe lamo faifu (5) ido laefa lele yaki olu minaifa, wenena mau naba minanako, efe yakafo nedi enune? liye. ");
INSERT INTO snp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eti lito, Yesukafo limo, linate wenena logimato ya olu mau witi mikalo minalo, lito minato mika yalo ya yuwa eba naba-naba nedo ya wemomo faifu tauseni (5,000) ya amedoti minomo wae. ");
INSERT INTO snp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Etiti amedoti minomo wato Yesukafo beleti ya oluto, siyane, lalole, loumuto, wenenawa mau naba amedoti minamo ya iya mele gimaiye. Ido laefa yaki ayaidana oto ya etito nenune, loti kolado ya gimaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gimaito, kobina noti-noti muni ito Yesukafo ege-ege moinamo we eti loto logimami, Luma nemo ya u kopa otenaiye. Kiyaka alo, lito ");
INSERT INTO snp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","beleti yuwa balikafo olufe lamo faifu (5) yamakafo luma nemoma ya kiyaka oti owo kedikoko naba tuwelu (12) ya koilato lumuto faito fulitaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ido wenena aumala gilibami neta eti imo monala eyeti ya eti loti lamo, Polofete lakoma mikaleka oloto pinaiye, loti lamoma moda ama ya ne, loti ");
INSERT INTO snp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ido Yesu olu ogona o edeti anikafo oluti kiyabate we wekudi bulu edenune, loti ato, ya geyefe loto fulo gedeito, aimolako mowalo ya idaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena lunaga fo saipaito ya ege-ege moinamo we ya nofuna anawalo lumuti ");
INSERT INTO snp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapeneyamu numudo itibito unune, loti sipiku idae. Sipiku idato, sini naba dito ya Yesu o fedámaito wewa yako wafa, ");
INSERT INTO snp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","epe auma wito, no sato naba itaito, ");
INSERT INTO snp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","uti ala faiga faifufe (5), ido sikisife (6), kilomita yaidalo uti no muliti ya u fedato, Yesu ya no mulalo ya leya-leya wito gege uto sipi ya olu alalili melaito eyeti ya ukani ololo iye. ");
INSERT INTO snp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Eti o minato, ya luni fito limo, Namoma minowe. Linate ya koli gimámaneyo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Logimaito, sipiku ya ido, loti ilimi meleiti ya unune, loto kolamo ebalekama sipi ya alako u ayalo fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ena wenena mau naba-naba ya nofuna filiga afulaleka ono minato, ko lito ya eti loti lamo, Melo luwaila ya sipi lawoko yako neto ya eye minogeto ayau ege-ege moinamo we ya Yesu fulo edeiti inanimoko diti wamoma ne, loti kolae. ");
INSERT INTO snp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eti loti koliti minato ya Taibeliyasi numudoti sipi ma ya Wekolakafo siyane, lalole, loumuto kobina gimaito, nado yaloma ya o fedato, ");
INSERT INTO snp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","wenena yate Yesuki ido ege moinamo we yaki amalo minámae, loti koliti ya sipiku ya diti Kapeneyamu numudoka itibiti uti yalo monila wilae. ");
INSERT INTO snp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nofuna wela amaleka ya wenenawa Yesu monila wiliti olu oloto piti ya eti loti loumamo, Api lilibanimo we, kamo nenafeko animo ne? loti loga o edato ");
INSERT INTO snp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesukafo eti loto logimami, Namo ka ona kula logimowe. Linate neta mona kofawa aumane giliboneto eye minamo yamu ya kolámae. Weni-neta gimoneto noti muti imo yamamu ya namo moni wili minae. ");
INSERT INTO snp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Linate ya lono oluti kobina fa neta u kopa unami neta yamu ya kolámalo. Omuni kofawa minowaminowa enawamo kobina yamu ya lonowa olalo. Namo We Kula ya Goti Menefokafo lufuwala mele nomami yamu ya namo kofawa minomo dinawamo kobinawa ya giminagolowe, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Logimaito, eti loti itibiti loga o edamo, Lamo nedi-nedi oto Goti lonola olu minenune? lato, ");
INSERT INTO snp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesukafo itibito logimami, Gotikafo nilifainako, koli kikito numu-numu o minamo wenena ya Goti lonola olu minamo wenena minae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eti lito, amote itibiti loumamo, Ena nena neta ma kofawa ailoma aumaka lilibanimo neta ya olu oloto piyageto eyeto koli kikito kumunune? Kamo nena lono olunane? ");
INSERT INTO snp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Autefo kolofate-mota yate mika kofo mikalo ya wenineta kuliya mana no-no amo yamu eti limo, Nenawae, loto kosinauti kobina gimami ne, loto ka mono lufuwau (Kis 16:4, Sng 78:24) ya nemo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eti lato, Yesukafo eti loto logimami, Ka ona kula logimowe. Mosesekafo ya kosinaukati kobina gimámaima ne. E’e, Menefokafo ya kosinaukati kobina kula gimi minaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kobina kosinaukati lumuto mikaleka wenena omuni kofawa olu oloto pi gimami ya Goti kobinala kula ya ne, lito ");
INSERT INTO snp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","amote eti loti loumamo, Wekola, kamo kobina lanimo ya kamena-kamena lumutoko mino, loumae. ");
INSERT INTO snp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Loumato, Yesukafo eti loto logimami, Omuni kofawa mino-mino amo kobina ya namo ya minowe. Namodoka amo wenena ya moda kadunamu folámenagilae. Ido koli kikito numu minamo wenena ya moda no yamuki kolámenagilae. ");
INSERT INTO snp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Etito nefa, linate ya namo neyafa, koti koli kikito nomámae, loto ya logimitoma ne. ");
INSERT INTO snp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Menefokafo numu minami wenena ya namodoka o fuli lenawamo ne. Ido wenena namodo enawamo ya ma olu kopa fulo gedámenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kosinauti lomomo ya nanimone weneloti ka lonowa olunae, loto lomámowe. E’e, nilifi melami we welaloti ka lonowa olunae, loto lomomo ne. ");
INSERT INTO snp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Menefokafo nomami wenena muki yauti ma u kopa ámunawae, loto geyeto kiyaba o gedeto kamena nabalo ya muki olu nedi gedenagolowe, loto lomo ka ya nilifi melami we kala lalo kiyami ka ya ne. ");
INSERT INTO snp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nalafo namo neyefe loti neyeti, koli kikito numunawamo wenena muki ya omuni kofawa minomo diti minenagilae, loto lomo ka ya Menefo kala lalo kiyami ka ya ne. Ena nanimone kamena nabalo ya olu nedi gedenagolowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Eti loto ya kosinauti kobina ya namo ya minowe, limomu ya Yuda wenena yate koli nosámamiti ka eti loti ");
INSERT INTO snp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","lo minamo, Ena, ama we ya Yosefe nalafo Yesu olafote melafote lele ya lamo geyonima ne. Ido kosinauti lomoma ne, loto limo ya nedito eti loto ya lo minaiye? lae. ");
INSERT INTO snp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Eti lato, Yesukafo itibito eti logimami, Linanimonigu ya kolamo nosámamiti etiti ya ádalo. ");
INSERT INTO snp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","We ma aimola siya-mulunauti kolito namodoka enami ya ma minámaiye. E’e, Menefo nilifami yakafo ika o gedagetoko enawamo ne. Wenenawa ya nanimo kamena nabalo ya olu nedi gedenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Polofete yate eti lamo, Goti aimolakafo wenena muki ka mono api gilibinagoliye, loti ka mono lufuwau (Ais 54:13) ya nemo ne. Yamu wenena ya Menefokafo ka logimito api gilibami ya kawa kolamo wenena ya namodoka enagilae. ");
INSERT INTO snp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Menefo eyamo wenena ya ma minámae. E’e, Gotidokati lomomo we namo lawokokafo Menefo eyomo we ya minowe. ");
INSERT INTO snp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Namo ka ona kula logimowe. Ma yate namo koli kikito nomamo wenena ya omuni kofawa minomo ditiko minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Omuni kofawa minenawamo kobinawa ya namo ya minowe. ");
INSERT INTO snp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Linate autibo-kolofatina ya mika kofo mikalo ya weni-neta kuliya mana oloto piyaito ya noti minoti folamo ne. ");
INSERT INTO snp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nefa, wenena mate kosinauti lomami kobina nenawamo wenena ya folámenagilae. Ya kobinawa namodoka ama ne. ");
INSERT INTO snp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Omuni kofawa minenawamo kobinawa ya kosinauti lomomo namo nanimo ya minowe. Yamu ma yate namodokati kobina noti ya minomo diti minowa-minowa oti minenagilae. Namo emilane ya kobinaidana ne. Mikau-mikau wenena omuni kofawa minomo dinawae, loto ya emilane giminagolowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yamu Yuda wenena linanimonina ka lodilumu oti eti loti lamo, We ya egaidana oto emilala lomageto nenumomu liye? lae. ");
INSERT INTO snp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eti lato, Yesukafo eti loto logimami, Namo ka ona kula logimowe. Linate ya We Kula namo emilane ido wanune ánenawamo ya omudi kofawa minenawamo mona ya lunigu mino gedámenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma yate namo emilane wanune notiko minenawamo wenena ya minowaminowa oti minato nanimo kamena nabalo ya olu nedi gedenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Namo emilane ya kobina kula ne. Ido wanune ya no kula ne. ");
INSERT INTO snp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Namo emilane ido wanune notiko minenawamo wenena ya namo luneu mino nedenagilae. Ido namo yaki amo lunigu mino gedenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Menefo ya minowa-minowa oto nemo we yakafo nilifi melaito lomomo yamu Menefodo metolito mino-mino o minowe. Etito minoneto namo noti minenawamo wenena yaki ayaidana oti namodo metoliti minenawamo ya minomo diti minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kosinauti kobina ya monawa etito ne: Ya autibo-kolofatina yate mana noti ya minoti folama nefa, namo kobinane ama nenawamo wenena ya minomo diti minowaminowa oti minenagilae, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kawa ya Kapeneyamu numudo mono numugu ya minoto ya logimito api-napi gilibaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Eti loto api gilibaito, ya ege melamo wenena yauti wenena so loti koliti eti lamo, Ka ya kolonimo keinaidana oto liye. Ya kema kolinami ne? loti ");
INSERT INTO snp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ya eleka ginaito Yesukafo ya siya-mulunau kolito eti loto logimami, Linate ka ya kolamo nosámaife? ");
INSERT INTO snp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Etiti kolamo ya We Kula namo komu minomo ebato olu itibito idoneto ya omunikafo kotima ya nedi enawamo ne? ");
INSERT INTO snp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ukade atuwa ido emila yakafo omude kofawa minomo dinumo kanuwa ma minámaiye. E’e, omude kofawa minomo dinumo kanuwa ya Goti Ouna lonola ne. Namo ka logimomo ya oudi ido omudi kofawa minomo dinawamo kanuwa ya ne. ");
INSERT INTO snp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nefa, linatedokati wenena liligaleka koli kiki ádo minae, loto logimaiye. Yesu ya koli kikito umámamo ya adeina afimalekati geye fuli loto geyemo idaiye. Ido ayaidana oto kuwolafo anido melenami we yaki eyefe loto eye minaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ido ka ma eti loto enu wito limo, Yamu ya eti loto logimoma ne. Wenena ya Menefokafo olu aila wi gedámageto namodoka oti minenawamo ma minámaiye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ena kamena yaloti ya ege melamo wenena yauti wenena so loti amo minaido ya minámenune, loti eleka ginaito fulo edae. ");
INSERT INTO snp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yamu Yesukafo ege-ege moinamo we tuwelu (12) ya loga o gedeto limo, Linate ayaidana oti fulo nedenune, loti lo minafe? liye. ");
INSERT INTO snp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ido Saimoni Pitakafo eti loto loumami, Wekolao, kamo fulo kedeitoma kemado unumo ne? Kamo lawokokafo omude kofawa minenumo kala olu minane. ");
INSERT INTO snp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lamo ya kamo koli kikito kumuto eti loto koli kumu minonimo ya kamo ya Gotidokati felegaga we minane, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Loumaito, Yesukafo eti loto logimami, Namokafo linate tuwelu (12) ya luti fiyofa, ido linate yauti ma ya Satanidoka ekeleto minaiye, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kawa logimami ya ege-ege moinamo we tuwelu (12) yauti ya we ma kuwolafo anido melenami we Saimoni Isikaliyoti nalafo Yudasi yamu liye. ");
INSERT INTO snp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ena Yudia ebalo Yuda wenena yate, Yesu ofenune, loti kudala kiyamo yamu mikanina fulito Galili mikalo yako u yaleka waka oto moinaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Etito moni minaito, Yuda wenena numuna kolokalo kuwamo foliwa kamenani alitiye. ");
INSERT INTO snp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Alitito, Yesu kunalafo-mota yate eti loti loumamo, Kamo ya aumaka gilibinanimo neta ma olu oloto piyageto kege melamo wenena yate eyenawae, loto ya eba ama fulito ya Yudia mikalo ya uto gilibo. ");
INSERT INTO snp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma yakafo oloto pinae, lenami ya falukuto minoto lono olunami ya ma minámaiye. Yamu kamo ya lono yaidana olunae, loto kolinanimo ya uto wenena muki ya olu oloto pi gimageto eyenawae, loti ");
INSERT INTO snp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","kunalafomota yate koli kikito umámoti eti lae. ");
INSERT INTO snp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Lato, ya Yesukafo eti loto logimami, Linate kamena-kamenau ya neta enune, lotima fa enagilae. Namo kamenane ya oiya o fedámaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wenena yate ya linate koli nosámami gimámenagilae. Namo ya monani nosámami ya lo oloto pi gedomo yamu koli nosámami numu minae. ");
INSERT INTO snp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Linanimoko foliku ya walo. Namo ya kamenane o fedámami, yamu ya oiya eti-mati ya ámunagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Eti loto Galili mikalo ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ena kunalafo-mota komu wato, aiga aimolako umalo pito wiye. ");
INSERT INTO snp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ena foliku ya Yuda wenena kiyaba we yate moni wiliti eti loti loga-loga amo, Egaleka minaiye? loti lae. ");
INSERT INTO snp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ido fa wenena yate amomu momona oti kumomo fimo idae. Yauti liligate, Amo ya we lalo ne, lato ido liligate, E’e, etito minámaiye. Amo ya wenena koni wi minaiye, loti lafa, ");
INSERT INTO snp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yuda we kiyaba we kolini ya koliti ka oloto ádae. ");
INSERT INTO snp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ena foli kofalau ya Yesukafo ya felegaga kuliyai numuna naba kilalau ya dito ka mono loto api-napi gilibaito, ");
INSERT INTO snp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuda we kiyaba we yate, Aiyo, lo kolaiye, loti ya eti loti lamo, Lamo lufuwa numudeu ya idámaima nenako, egalekati oto ka mono monawa ya kolito liye? lato ");
INSERT INTO snp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesukafo eti loto logimami, Namo mono api gilibomo ya namodokati minámaiye. E’e, nilifi melami we yalekati ne. ");
INSERT INTO snp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yamu wenena mate ka mono monawa ama ya Gotidokati nefemo, ido nanimo Yesudokati ne? loti moni wilinawamo wenena yauti Goti kala lalo kiyaido golodenune, loti kolinawamo wenena yate monawa kolinagilae. ");
INSERT INTO snp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Makafo aimola kalaukati kolito lenami we ya aimola kuliya dito minenaiye, loto lenagolifa, namokafo nilifi melami we kuliya dito minenaiye, loto lomo ya mona ona kulako meloneto, nosámami mona ma ya ukaneu minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesekafo ya lo melami ka lo oloto pi gimaima nefa, linatedokati ya ma lo melami ka golodamo we ma minámae. Ena linate nena netamu ya nofenune, loti ya lo minae? logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Logimaito, ya wenena fa wenena yate eti loti lamo, Kamo ya Satani kimiwelakafo seka-mulugau mino kedaiye. Kamo kema kofenae, loto liye? lae. ");
INSERT INTO snp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lato, ena Yesukafo eti loto logimami, Namo Sabati foliku neta kofawa lawoko aumane gilibomo yamu oti aiyo, loti lo yaleka waka kofamo minae. ");
INSERT INTO snp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesekafo natige-mota ukanido Goti ainala fukenune, loto logimaima nefa, ya monawa ya Mosesekafo api gilibámaito, aulafo-kolofala yate aipama ne. Eti logimainako, linate Sabati foliku ya Goti ainala fuko-fuko o minae. ");
INSERT INTO snp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yamu ya Mosesekafo ka lo melami ya koli fulitotenune, loti ya Sabati foliku ya natige-mota ukanido ya Goti ainala fuko gedeti lonowa ya olu-olu o minae. Eti o minamo namo ya Sabati foliku ya we ma ukana-ana muki ya olufe lo edomo yamu ya nediti ya koli nosámami nomae? ");
INSERT INTO snp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wenena monani kofe ádotima faifa kopa lifima kawa ya ádalo. Kofe lenawado yaloko lalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ena Yelusalemu wenena yauti mate eti loti lamo, We ya ofenune, loti lo-lo amoma ya moda ama ya nemo yae. ");
INSERT INTO snp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nedito ka olotoko limo ya mono kiyaba we yate ka lo fuko edámamo minae? Ya monala kolamo ya Gotikafo ilifi melami we Kilisto ne, loti kolafe? ");
INSERT INTO snp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E’e, Yesu oloto piyami eba ya koli minoba, Goti ilifi melami we Kilisto fedenami ya ebala ya kolife ádenagolone, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Etiti lamo yamu Yesukafo ya felegaga kuliyai numuna nabau ya ka mono api gilibi minoto lo faka loto limo, E’e, linate kofe loti neyeti namo oloto piyomo eba ya koli minone, lafa, lomomo ya nanimo sene-muluneuti kolito lomámomo ne. Mona ona kula aboga nemo yakafo nilifi melaito lomomo ne. Ido amomu ya linate kati kife loti kolámae. ");
INSERT INTO snp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Namo ya aimola muluna kemanauti nilifi melaito lomomo nenako, namo eyefe lo minowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kawa eti limomu nela wi edenune, loti lafa, kamenala oiya o fedámami yamu ani keina ito fulitae. ");
INSERT INTO snp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ena wenena fa wenena muki yate Yesu koli kikito umuti eti loti lo minamo, We ama yakafo neta kofawa aumala lilibi minami ya Goti ilifi melami we Kilisto o fedenami yakafo we ama olu afima o edeto ya olu oloto pinagolife? loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ena wenena mau minamo yate kawa amomu momona oti kumomo fiti lato ya Falisi we yate koliti, Goti yokila ki umu-umu amo we kiyabani we yaki ya lokoli-fakoli oti, Yesu ya nela fi edalo, loti felegaga kuliyai numuna naba kimiwe gilifi melato wamo, ");
INSERT INTO snp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","yamu Yesukafo eti loto limo, Namo kamena lina efema linateki minoto nilifi melami we minaidoka itibinagolowe. ");
INSERT INTO snp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Itiboneto, linate namomu moni wiliti olu oloto piti neyámenagilae. Ido uto minenado ya linate ma ámunagilae, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Logimaito, Yuda wenena yate eti loti lokoli-fakoli amo, Wewa ya egaleka wageto monila wilito olu oloto piyámenumo ka liye? Yuda wenenate Giliki mikalo minomo wadoka ya uto Giliki wenena ka mono logiminae, loto kolito life? ");
INSERT INTO snp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Monine wiliti olu oloto piti neyámenagilae, loto, ido unado yalo ya ma ámunagilae, loto limo ya egaidanamu liye? loti ya lokoli-fakoli ae. ");
INSERT INTO snp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ena Yuda wenena yate foli minomo diti mino fuli lenune, loti wenena mau naba-naba witi minato, Yesukafo nedito minoto ka auma wito limo, Ma yate nomu kolinawamo ya namodoka oti nenawae. ");
INSERT INTO snp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ido ma yate koli kikito numu minenawamo yamu ka mono lufuwanina yau eti loti wiyamo, Yaidana amo wenena ya no fiya yaidana oto seni-mulunigu olu oloto pi gedageto no yaidana oto lumutoko minenagoliye, loti ya wiyamo ne, loto ");
INSERT INTO snp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","kawa limo ya Ouna yamu liye. Ido monawa etito ne. Yesu koli kikito umamo wenena ya Ouna Felegaga giminae, loto ya Yesu kamena yalo ya kosinau lamenala lulau ya itibito idámainako, ya Ouna lomámami ne. ");
INSERT INTO snp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ido wenena ya ka ya kolagu yauti mate Yesumu eti lamo, Amo ya polofete yama ona ne, lato ");
INSERT INTO snp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ido mate, Amo ya Gotikafo ilifi melami we Kilisto ne, lato, ido liligaleka yauti mate, Fulitalo. Kilisto ya Galili mikalo oloto pinami nefe? E’e, ");
INSERT INTO snp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kilisto ya Defiti numuna atela Betelehemu yalo Defiti ufa fiyami wenena yauti oloto pinagoliye, loti ka mono lufuwau ya eti loti wiyamoma ne, loti lanako, ");
INSERT INTO snp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","wenena muki ya amomu ka ailo-ailo loti foki filiga-aliga oti, ");
INSERT INTO snp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","liligate nela ofenune, loti lafa, ani keina ito fulo edae. ");
INSERT INTO snp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ena felegaga kuliyai numuna naba kimiwe ya Goti yokila ki umamo we kiyabani we ido Falisi we minado ya itibiti wato, loga o gedeti lamo, Linate nediti olámoti faifa ae? loti loga ato, ");
INSERT INTO snp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","kimiwe yate ka itibiti lamo, Ena, wewa ka limo yaidana oti komuma ádamo nenako, loto olámoto faifa one, lato, ");
INSERT INTO snp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Falisi we yate ka itibiti logimamo, Linate yaki ya koti wiyaife? ");
INSERT INTO snp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kiyaba we wenaba yauti ido Falisi we lamodokati ya ma koli kikito umobe? ");
INSERT INTO snp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","E’e, ya ma eti ámonimo nefa, wenena fa wenena mau minamo yama lo melami ka ya kolámoti, Goti omunalo u kopa unawamo wenena yamako koli kikito umae, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Eti lato, ena koinanibo we ma Nikodemusi ya komu Yesu nedo wimo we ya eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Linate we ma monala ya loga o edeti kolámoti, ido monala nosámami eyámoti lifima ka logiminawamo yamaidana iye. Eti alo, loto lo melami ka lufuwa wiyagu yau eti loto nemo nefe? Etito minámaiye, lito, ");
INSERT INTO snp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","koinalafomota yate ka eti loti itibiti lamo, Ena, kamo yaki Galili mikaloti abe? Ka mono lufuwau ya katoto kolo. Polofete ya Galili mikaloti oloto piyámenawamo ne, loto nemo ya kolo, loti lae.  ");
INSERT INTO snp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eti loti upatoti numunigu-numunigu wae. ");
INSERT INTO snp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ena Yesu ya Olifi mowalo ya dito minaito, ");
INSERT INTO snp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ko lito yaloti itibito felegaga kuliyai numuna naba kilalau idaito, wenena mate amodoka oti mau wiyato, yalo amedoto minoto ka mono logimito api gilibaito, ");
INSERT INTO snp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","lo melami ka api gilibi-gilibi amo we ido Falisi we yate wena ma kume-ugele no minaido eyeti olu oloto piti Yesu nedo ilimiti uti olu omunido nedi edeti ");
INSERT INTO snp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesu eti loti loumamo, Api lilibanimo we, wena ama yakafo kume-ugele no minaido eyeto olu oloto piyone. ");
INSERT INTO snp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yamu Mosesekafo wena yaidana enawamo ya kifanakafo gini folalo, loto lo melami ka yamo lolomaiye. Ido kamodokati ya nediye loto ne? loti ");
INSERT INTO snp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ya faifa eti loti loga o edeti, ka olu yaida-amaida kama lagetoma ya ligiya lo edenune, loti kepa meleti lae. Eti lato, Yesukafo kuba wito anakafo mikalo ya lufuwa wiyaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lufuwa wi minaito, loga-miga o edato, amo ya nedito eti loto logimami, Linate yauti ma lifimala minámageto minenami we yakafo apito kifanakafo ofageto ya ofalo. ");
INSERT INTO snp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eti loito kofa kuba wito mikalo ya lufuwa wiyaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ena amote kala koliti kiyabani we we kilofo ya komu wito eyeti lawoko lawoko ege uti u fuli lato, wena ya Yesu omunalo aimolako ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ena Yesu ya nedito loga o edeto limo, Wenao, egaleka wae? Lifima ka ma lokomámamo nefe? lito ");
INSERT INTO snp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","wenawa yakafo limo, Wenaba, ma minámaiye, lito ya Yesukafo limo, Ena namo yaki lifima ka ma lokomámenagolowe. Kamo ya itibito uto mona nosámami ya kofa melámo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ena Yesukafo wenena ka ma mene oto logimami, Namo wenena mikau-mikau ya lamenani minonako, ma namo nege-nege moninawamo ya sinidigu ya moinámenagilae. E’e, omuni kofawa minenawamo lamenawa ya mino gedenagoliye, liye. ");
INSERT INTO snp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lito, Falisi we yate eti loti loumamo, Ama ya kamo kaimo monaka lo oloto melanimo yama kolonimo kula minámaiye, lato, ");
INSERT INTO snp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesukafo eti loto logimami, Namo ya omo ebalekati ido unamo ebaleka ya monawa koli minonako, namo nanimo monane lo oloto meloneto kulawa o minaiye. Linate ya omo ebalekati ido unamo ebaleka ya monawa kolámoti koli kopaitae. ");
INSERT INTO snp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Linate lifima ka lo-lo o minamo yakafo atuwa o minaiye. Namo ya lifima ka ya oiya ádenamo ne. ");
INSERT INTO snp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nefa, ido ma lenae, loto lenamo ya moda ona kula lenamo ne. Namo lifima ka ya nanimoko lenamo minámaiye. E’e, Menefo nilifi melami yakafo ane olu faka lageto lenamo yamu kula enagoliye. ");
INSERT INTO snp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ido linanimo lo melami ka lufuwatigu yau eti limo, We lele yate we ma monala lo oloto piyaitoma kula ne, loto ya lufuwau yau nemo ne. ");
INSERT INTO snp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yamu ya namo monane lo oloto piyoneto ido Menefo nilifi melami yakafo ayaidana oto monane lo oloto pi minaiye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ka ya eti loto logimaito, amote loga o edeti lamo, Mekafo ega ya ne? lato ya amokafo logimami, Linate namo neyefe ádanako, Menefo ayaidana oti kolife ádae. Namo ya neyefe lamo neko Menefo yamuki kolife lagi ne. ");
INSERT INTO snp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Eti loto Yesukafo felegaga kuliyai numuna nabau ya kifana melamo koukame negu eba mau ya ka mono logimito ka ya liye. Ena kamenala oiya alitámami yamu ya ani keina ito nela numugu ya fulo edámae. ");
INSERT INTO snp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ena Yesukafo mene oto eti loto logimami, Namo fulo gedeto woneto linate namomu moni wiliti ya lifimaniki minoti fulunawamo ne. Namo uto minenado ya linate ámunagilae, lito ");
INSERT INTO snp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yuda wenena yate lamo, Namo unadoka ya ámunagilae, loto limo ya nedito ya liye? Aimola nedala oluto fulunagolo lifemo? lato, ");
INSERT INTO snp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesukafo eti loto logimami, Linate ya wakati minae. Namo ya yalekati minowe. Linate ya mika amaloti minafa, namo ya mika amaloti minámowe. ");
INSERT INTO snp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yamu ya lifimaniki ya minoti fulunawamo ne, loto ya logimomo ne. Namo minomo ama ya monane logimi-gimi omo ya koli kiki ádenawamo ya lifimani faifa mino gedageto fulunagilae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eti lito, ya amote loga o edeti lamo, Ena, kamo kema minane? lato, Yesukafo logimami, Lono aipodoti logimi-gimi omo aya efe ya ne. ");
INSERT INTO snp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Namo ya linate lifimani ido keinani yamu ka mumudi olu minofa, nilifi melami we yakafo aimola ka ona kula lo-lo o minaito, nanimo ya amo welauti kolodo ya mikalo amalo lo oloto melowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kawa ya Melafomu eti loto logimaifa, amo yate kolife ádae. ");
INSERT INTO snp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yamu Yesukafo enu wito eti loto logimami, Linate We Kula namo yá yofolo nofoti olu akaiya faka lo nedenawado ya monane kolife lenagilae. Ido nanimone senemuluneuti kolito neta ma ámoto, Menefokafo api nilibami kawa ya lo minomo yaki ya kolife lenagilae. ");
INSERT INTO snp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nilifi melami we ya namodoka mino nedaito, namo kamena-kamena neta oneto kolami lalo imo yamu namo ma fulo nedámaiye, loto ");
INSERT INTO snp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ka eti lo minaito wenena mumudi koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ena Yesukafo koli kikito umamo Yuda wenena eti loto logimami, Linate ya namo kanelo moni minenawamo ya namo nege moinamo wenena kula minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Etiti minoti ka ona kula ya kolife lato, aya kawa ona kula yakafo efili gedenagoliye, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eti lito, amote ka itibiti eti loti loumamo, Lamo Abalahamu ufa fiyami wenenala minonimo ya ma nela wi ledato minámoninako, kamo efili gedenami ne, loto lanimo ya nedito lane? loumae. ");
INSERT INTO snp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Loumato, Yesukafo ka itibito eti loto logimami, Namo ka ona lema logimowe. Ma yate nosámami mona melamo ya monawa yakafo nela wi gedaito, nelalo kouba-naba o minamo yamu lowe. ");
INSERT INTO snp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nela wi gedami wenena wenabani numuna ebalalo ya kamena-kamena kiyaba oti minomo idámenagilae. E’e, Nalafo ya Melafo numuna ebalalo ya kamena-kamena minowaminowa oto minomo dinagoliye. ");
INSERT INTO snp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yamu ya Nalafo namo efili gedonetoma linate ona nela wi gedámageto minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Linate Abalahamu ufa fiyami wenenala minamo ya moda koli minowe. Etiti minafa, namo kane ya linatedoka kopopo o-o minainako, nofo fulunune, loti lo-lo o minae. ");
INSERT INTO snp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Namo Menefodoka neta eyomo ya lo-lo o minowe. Ido linate linanimotina metibodokati neta koliti ya o-o minae, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","lamo metefo Abalahamu ne, loti ka itibiti loumato, ya Yesukafo eti loto logimami, Linate Abalahamu ufa fiyami wenenala kula minamo neko amo monala yaidana oti mele minagi ne. ");
INSERT INTO snp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nefa, Gotidokati ka ona kula kolomo logimi minomo ya linate nofenune, loti lo minae. Neta yaidana Abalahamukafo ámami ne. ");
INSERT INTO snp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Linate ya linanimo metibo kanulalo ya egeto meleti leya wi-wi o minae, lito ya amote eti loumamo, Kopa kanudoti oloto piyonimo minámaiye. Metefo lawoko Goti ne, lato, ");
INSERT INTO snp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesukafo eti loto logimami, Namo ya Gotite minoidoti lomomo ne. Nanimo sene-muluneuti kolito lomámomo ne. E’e, amokafo nilifi melaito lomomoma nenako, linate metibo ya Goti nemo neko, seti-muludi ya namo nomagi ne. ");
INSERT INTO snp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nediti ya ka lomo ya kolife ádo minae? Namo ka lomo ya linate ogofuti kolámamo yamu ya kolife ádo minae. ");
INSERT INTO snp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Linate metibo Satani wenenala minoti, metibo kolami mona ya meyalo melenune, loti koliti minae. Amo ya kana afimaukati gini fulumo idami we ya minaiye. Ido siya-mulunau ka ona ma minámainako, ka ona kula koli fulitami we ya ne. Amo ya ka suki we ido suki aboga minami yakafo aimola monala ya meleto ka suki lo-lo o minaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ido namo ya ka ona kula logimi-gimi o minofa, linate kane ya koli fulo minae. ");
INSERT INTO snp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Linatedokati mate namo lifimane lenawamo ya fowe loti ádenagilae. Namo ka ona kula logimomo ya nediti koli kikito nomámae? ");
INSERT INTO snp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wenena ma Goti wenenala minamo yate ka limo moda koli minae. Linate Goti wenenala minámanako, kala koli fulo minae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Eti lito, Yuda wenena yate ka itibiti eti loti ya loumamo, Kamo Samalia we ma Satani kimiwela seka-mulugau dito minaiye, loto ya ka ona lo minobe? lato, ");
INSERT INTO snp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesukafo ka itibito eti loto logimami, Satani kimiwela sene-muluneu minámaiye. E’e, namo Menefo kuliya olu faka lo minofa, linate ya namo kuline ya oto lumuti fulo minae. ");
INSERT INTO snp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Namo nanimo kuline dinaiye, loto ádowe. Makafo kuline olu faka lo nedenami ya iya meleto olufe lenami we ne. ");
INSERT INTO snp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Namo ka ona kula logimowe. Ma yate namo kane olu minenawamo wenena ya folámenagilae. E’e, moda minowa-minowa oti minomo dinawamo ne, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Eti lito, Yuda wenena yate eti loti loumamo, Kamo Satani kimiwela seka-mulugau mino kedami ya oiya ona koli minone. Abalahamu moda folami ne. Ido polofete ya ayaidana oti folamo ne. Ido kamo eti loto lanimo, Namo kane olu minenawamo wenena ya folámoti, minowa-minowa oti minenagilae, loto lanimo, ");
INSERT INTO snp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ya autefo-kolofate Abalahamu wenaba lakoma folamima nenako, kamo ya olu afima edenae, loto labe? Ido polofete ya ayaidana oti folamo ne. Kamo nedito kaimo kulika oluto di minane? loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eti lato, Yesukafo ka itibito eti loto logimaiye. Namo nanimo kuline olu faka lonetoma ya kuline u fa neta enagoliye. Menefo yamu Gotite ne, loti lamoma ya amokafo kuline olu faka lo minaiye. ");
INSERT INTO snp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Linate amo ya kolife ádae. Namo ya kolife lo minowe. Yamu namo ya kolife ádowe, loto lomo neko, ya linate yaidana minoto ka suki logi ne. Ido namo ya kolife loto kala olu meyalo meleto moni minowe. ");
INSERT INTO snp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Autibo-kolofati Abalahamukafo ya namo kamenane alitageto kenae, loto lalo koli minami ne. Ido minoto kamena alitito koto alikani ima ne. ");
INSERT INTO snp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Eti lito, Yuda wenena yate loumamo, Kamo melegeka fifiti (50) ya olu fulámaninako, kamo Abalahamu eyanimo nefe? Olo, lato, ");
INSERT INTO snp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesukafo logimami, Namo ona lema logimowe. Namo Abalahamu oloto piyámaito minomo wema minowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eti limomu kifana oluti ofenune, loti lafa, felegaga kuliyai numuna nabau yati ya falukuto u yau amau oto feka lumuto wiye. ");
INSERT INTO snp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ena Yesukafo ya kanudo uto we ma olafo mulunauti omuna likami olu oloto pito eyaito, ");
INSERT INTO snp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ege-ege moinamo we yate loga o edeti lamo, Api lilibanimo we, kema lifimalakafo omuna likami ne? Ama ya aimoladokati nefemo, ido olafo melafodokati ne? ");
INSERT INTO snp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eti lato, Yesukafo eti loto logimami, E’e, aimola lifimala ido olafo melafo lifimanina yalekati ya minámaiye. Goti aumala monala amodoka oloto pinaiye, loto neta etito oloto pito ne. ");
INSERT INTO snp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Fo lito minonido ya nilifi melami we lonola oluto minokele. Sinidenami ya lonola olunumo kamenawa fuli lenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Namo mikaleka minomo kamenalo ya namo wenena mikau-mikau ya lamenani minowe, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Eti loto ya mikalo ketufu oto kululu wito we omuna likami ya omunalo fili edaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Fili edeto ya eti loto ilifi melami, Kamo ya Silowamu nofugu ya uto noku wiyo, loto loumaiye. No Silowamu ya Yuda kanidokati Ilifi Melamile, loti ya kuliya monawa ya nemo ne. Ena wewa ya uto noku wito omuna kaiye. Omuna koto wenenala minado ya itibito aiye. ");
INSERT INTO snp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Itibito ami wewa komu wako lo gede-gede imo we ya koliti wenenawa yate muki oiya eyeti loga-loga oti lamo, Mikalo amedoto minoto wako lo lede-lede imo wema ya nefe? lato, ");
INSERT INTO snp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","liligate lamo, Moda ya nemo yae, lato, ido liligate, E’e, yamaidana ailo ma ne, lato, ya aimola auma wito limo, Namo yama ya minomo yae, liye. ");
INSERT INTO snp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eti lito, loga o edeti eti lamo, Kamo egaidana oto omuga falatane? lato, ");
INSERT INTO snp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","amokafo itibito logimami, Wema kuliya Yesu yakafo mikalo ketufu oto kululu wito omunelo fili nedeto ya eti loto lonomami, Kamo Silowamu nofugu ya uto noku wiyo, lito uto noku wiyoneto omune falatiye. ");
INSERT INTO snp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eti lito, loga o edeti lamo, We ya egaleka minaiye? lato, Ya namo kolámowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ena Yesukafo kaba kululu wito omunalo fili edaito, omuna falatimo ya Sabati foliku ya neta eti iye. Yamu ya omuna falatimo we ya Falisi we minado ya ilimiti wato, ");
INSERT INTO snp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Falisi we yate ayaidana oti loga o edeti lamo, Kamo egaidana oto omuga falatane? lato, ya amo eti loto logimami, Amo ya omunelo kaba ya fili nedaito, namo ya uto noku wito omune komo ne, liye. ");
INSERT INTO snp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Eti lito, Falisi we yauti mate eti lamo, We ya Sabati foli olu kopaitami ya Gotidokati minámaiye, lato ya mate lamo, Amo ya nosámami neko, neta yaidanama etito olufe ádagi ne. Eti loti ka lodilumu oti lae. ");
INSERT INTO snp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yamu ya omuna falatimo we ya kofa loga o edeti lamo, Omuga olu falato kedami yamu kaimoka ya amo yamu nediye loto koli minane? lato, amokafo limo, Polofete ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ena Yuda wenena yate eti loti lamo, We ama ya omuna likaito minaimakafo omuna falatiye, loti ya ona lafemo, ido suki lae? loti kani ligi-ligi kiti olafote melafote luni fiyato aito, ");
INSERT INTO snp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","loga o gedeti lamo, Linate natiboma kedami kamenaloti omuna likaiye, loti lo minamoma ama ya nefe? Etito minaima egaidana oto omuna falatiye? loti loga o gedae. ");
INSERT INTO snp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Loga o gedato, olafote melafote yate ka itibiti eti loti lami, Natefo ya amalo nemo ya koli minoiye. Ido kedami kamenaloti omuna likami yaki koli minoiye. ");
INSERT INTO snp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ido egaidana oto omuna kaife? Ido kemakafo omuna olu falato edaife? Ya we ya kolámoiye. Kipawa ya naba ditaima ne. Aimola loga o edato monawa logimaneyo, loti lami ");
INSERT INTO snp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ya Yuda wenena yamu koli gimaito eti laiye. Ya koli gimami monawa etito ne: Yuda wenena yate komu ka eti loti lokoli-fakoli lamo, Mate Yesu yamu Gotikafo ilifi melami we Kilisto ne, loti lenawamo ya ka mono kolagu yauti fulo feka o gedenune, loti lama ne. ");
INSERT INTO snp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yamu ya olafote melafote ya koli gimaito, eti lami, Amo ya naba ditami ne. Aimola loga o edalo, loti ya laiye. ");
INSERT INTO snp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yamu omuna komu likami we ya kofa lula fiti eti loti loumamo, Kamo Goti kuliya olu faka loto ka ona lolomo. Wewa ya monala koli minone. Amo we nosámami ne, lato, ");
INSERT INTO snp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","eti loto logimami, Amo ya we nosámami nefe? Ido lalo nefe? Ya ma kolámowe. Omune likoto minomakafo omune falatomo netawa lawoko ya kolife lo minowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eti logimaito, ilulu kuti loga o edamo, Nedi-nedi o kedaiye? Egaidana oto omuga olu falatiye? lato, ");
INSERT INTO snp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","amokafo eti loto logimami, Namo logimoma ya linate kolámae. Nedito kofa logimoneto kolinune, loti lo minae? Linate yaki ege melenune, loti lo minafe? Olala! logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eti lito, olu leke-make o edeti eti loti lamo, Kamo ya ege melanimo we minane. Lamo ya Mosese ege moinonimo we ya minone. ");
INSERT INTO snp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mosese ya Gotikafo ka loumami ya koli minoba, we ama ya yaukati amaukati oloto pito aife? Ya ma kolámone, loumae. ");
INSERT INTO snp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eti lato, we yakafo ka itibito eti loto logimami, Omune olu falatimo we ya yaukati aife? Amaukati aife? Oloto pito ami ya kolife ádone, loti lamo ya ka manidigu minámaito lafe? ");
INSERT INTO snp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Lamo Goti yakafo nosámamo wenena ka lenawamo ya kolámami ne, loto ya koli minone. Ido ma yate Goti koli umuti welalo golodoti moni minenawamo wenena ya ka lenawamo moda koli minami ne, loto yaki koli minone. ");
INSERT INTO snp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yamu we kemakafo we ma omuna likami oloto pito nemo ya omuna olu falatiye? Ka yaidana ka mika oloto piyaigu akaimati kolámoto minomo idonimo ne. ");
INSERT INTO snp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wewa ya Gotidokati lomámami neko, lono yaidana olámagi ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eti logimaito, amote eti loti loumamo, Okafo mekafo kopa moniti kedamo kamoki u ayaida animo yakafo ka mono api lilibinae, loto labe? Olo, loti ya itufu fulae. ");
INSERT INTO snp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ilifato, ya Yesukafo kolito olu oloto pito loga o edeto limo, Kamo We Kula koli kikito umu minabe? lito, ");
INSERT INTO snp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","wewa yakafo limo, Wenabao, kamo kemamu lane? Nilibageto eyefe loto ya koli kikito umunae, lito, ");
INSERT INTO snp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesukafo eti loto loumami, Kamo moda kotanimo yae. Ka lokomomo ama ya minomo yae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eti loumaito, wewama yakafo eti limo, Wekolao, namo koli kikito komowe, loto ounalula-kala ya umaiye. ");
INSERT INTO snp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ena Yesukafo eti loto limo, Namo wenena lifima itibito giminae, loto mikalo lomomo ne. Yamu ya wenena mate omude likaiye, loti kolamo wenena ya omuni olu falato gedenae. Ido omude moda falatotaiye, loti kolamo wenena ya omuni faifa likoto minenaiye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eti loto lito, Falisi we liliga adu minamo yate koliti ya eti lamo, Aiyo, lamo omude likami minogeto labe? lato, ");
INSERT INTO snp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesukafo eti loto logimami, Linate omuni likami minamo neko, lifimatina minámagi ne. Nefa, linanimotina ya lamo omude moda falatito minone, loti lo-lo amoma nenako, lifimatina mino gedenagoliye, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ena Yesukafo ka ma eti loto logimami, Namo ona lema logimowe. Makafo sipisipi kilanigu dinae, lotoma, kanudo idámoto maleka kila kofalalo dinami ya ugele we ido neta kopa olami we ne. ");
INSERT INTO snp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ido kanudo efe loto dinami we ya sipisipi kiyabani we ne. ");
INSERT INTO snp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Amo o fedenami ya kanu kiyaba we yakafo eyeto kanu wi edenagoliye. Kanu wi edageto sipisipi yate nola lebona kolato aimola sipisipila ya kulini loto lu fito kilauti gilimito lumunagoliye. ");
INSERT INTO snp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Gilimito lumuto olu komu mele gedeto wageto nola lebona ya kolanako, ege unagilae. ");
INSERT INTO snp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Etiti ege unagilafa, ido we kofawa makafo lu finami ya ege ámunagilae. Amo nola lebona ailo nenako, amodokati koli unagilae, loto ");
INSERT INTO snp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ka asa wito eti loto logimami ya nena netamu liye? loti kani ligi-ligi kiyae. ");
INSERT INTO snp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kani ligi-ligi kiyamo yamu Yesukafo ka enu wito eti loto logimami, Ka ona kula logimowe. Sipisipi dinawamo kanunina namo ya minowe. ");
INSERT INTO snp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Namo oloto piyámomo kamenalo komu oloto piyamo we ya ugele we, neta-mata olu kopaitamo we minafa, sipisipi yate kanina kolámamo ne. ");
INSERT INTO snp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kanu ya namo ya minowe. Namodo dinawamo wenena ya olu omuni koneto ya uti oti weni-neta olu oloto piti ya noti minenawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ugele namo we yate giniti olu kopa o gedeti ugele oluti koli unune, lotiko o fede minae. Ido namo ya ouni-luni-kani kofawa olu gimoneto laloko minenawae, loto oloto piyowe. ");
INSERT INTO snp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Namo ya sipisipi kiyabani we lalo minowe. Kiyaba we lalokafo sipisipi kiyaba o gede minoneto nofo fulunawae, loto ya fa kiyaba o gede minowe. ");
INSERT INTO snp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sipisipi aboga minámami we ya kifana meinawa yamuko kolito kiyaba o gedainako, yamu kofukuti kula fadena o fedenami ya wewa eyeto sipisipi ya fulo gedeito koli unagoliye. Koli wageto, kula fadenakafo ya oto sipisipi ya ginito olu upatenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Eti enami we ya meinala yamuko lonola olainako, sipisipi yamu kala ki gimámoto koli unagoliye. ");
INSERT INTO snp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Namo ya sipisipi kiyabani we lalo minowe. Menefokafo namo neyaito ido amo eyoneto koli filiga-filiga o-o minoiye. Ido ayaidana oto namoki ido sipisipineki koli filiga-filiga o-o minone. Yamu ya namo sipisipi kiyaba o gede minoneto nofo fulunawae, loto ya fa kiyaba o gede minowe. ");
INSERT INTO snp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ena namo sipisipine ma so loti minamo ya kila amauko ma minámae. Maki lakoina gilimito oneto none lebona ya kolinagilae. Etito sipisipi ya mau lawoko wi gedoneto ya kila lawoko ido kiyaba we lawoko etito oloto pito minenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Namo oto meleto omo ya fulito fulunagolowe. Yamu Menefokafo siya-muluna numu minaiye. Namo oto meleto omo ya fulito fuluto kofa nedito minenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","We mate faifa nofo folámenagilae. E’e, nanimo kane lalo kiyodo ya fulito fulunagolowe. Namo fuluto ido nedito enamo aumane moda mino nedaiye. Eti loto Menefokafo lonomami ne, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Eti lito, Yuda we yate koliti kofa lodilumu oti ");
INSERT INTO snp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","minaguti mumudite eti loti lamo, Amo ya Satani kimiwelakafo siya-mulunau idaito ouna u kopa wimo we ya ka limo ya nediti koli minae? lato, ");
INSERT INTO snp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ido mate eti lamo, Satani kimiwela mino edenami yakafo ka yaidana ádenagoliye. Ido Satani kimiwela makafo we ma omuna likami ya olu falatenami nefe? lae. ");
INSERT INTO snp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ena Yuda we yate felegaga kuliyai numuna naba lusa kiyamo foli kamenawalo ya epe limo kamenawa fedaito ");
INSERT INTO snp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ya felegaga kuliyai numuna naba ogona-agona oti kolokalo numuna yaidana oti kuwamo anawaleka ya kuliya Solomoni Kilalau ya Yesu uto oto monito minaiye. ");
INSERT INTO snp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Moni minaito, Yuda wenena yate olu ogona o edeti eti loti loumamo, Kamo nedito kamena fana ya monaka olu falukageto kate lele ki minone? Kamo Gotikafo ilifi melami we Kilisto minotoma, lo oloto meleto lolomomo, lato, ");
INSERT INTO snp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesukafo ka itibito eti loto logimami, Namo moda logimitomoma nefa, ya linate koli kiki ádae. Namo Menefo kuliyalo lono olu-olu o minomo yakafo monane lo oloto gimi minaifa, ");
INSERT INTO snp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","linate ya namo sipisipine oti minámanako, koli kikito nomámae. ");
INSERT INTO snp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Namo sipisipine yaidana oti moni minamo wenena ya namo none lebona kolato ya geyefe lo minoneto nege moni minae. ");
INSERT INTO snp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nege moni minato, omuni kofawa minowaminowa enawamo mona olu gimoneto u kopa ámuti moda minomo diti minenagilae. Ya wenena ya namo aneloti makafo apasoto olunami ya ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Menefokafo namodo minenawae, loto olumo nomami we yakafo wenena ido neta-mata muki ya olu afima o gede fuli lo minainako, ma yate Menefo anauti apasoti olunune, loti enawamo ya ogoufámenagilae. ");
INSERT INTO snp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Namo ido Menefo ya lawoko minoiye, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eti lito, Yuda wenena yate kofa kifana nuba oti ofo fulunune, loti ato ");
INSERT INTO snp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesukafo eti loto logimami, Lono lalo neta mona-mona Menefo aumalalo oloneto ya eye minamo lonone lalo ologu yauti ma nena neta yamu kifanakafo nofenune, loti lo-lo o minae? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Loga o gedaito, Yuda we yate ka itibiti eti loti loumamo, Lono lalo olu-olu animo yamu minámaiye. Kamo faifa wenena makafo namo Goti minowe, lo-lo o minanimo ya Goti kamana kiyane. Yamu ya kifanakafo kofenune, loto lo minone, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Eti lato, Yesukafo ka itibito eti loto logimami, Gotikafo lo melami kala linate gimaigu yau eti limo, Linate Goti yaidana oti minae, loto ya nanimo loma ne, loto ka mono lufuwau (Sng 82:6) nemo ka ya kolámafe? ");
INSERT INTO snp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yamu ka mono lufuwau ka nemo ya u kopa ámenagolinako, Gotikafo linate Goti yaidana oti minae, loto kala kolamo we ya logimainako, ");
INSERT INTO snp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","namo ya Menefokafo oluto fele fulo nedaito, lumuto mikalo minomo ya Goti Nalafo minowe, loto logimomo yamu linate Goti kamana kiyane, loti ya nediti lae? ");
INSERT INTO snp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Neta o-omo ya linate eyamo ya Menefokafo o-o imomaidana ámonetoma ya namo koli kikito nomámalo. ");
INSERT INTO snp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ido netawa o-oneto ya neyama nefa, koli kikito nomámotima ya neta kofawa aumala gilibomo yalekama koliti ya neyefe lalo. Neyefe lenawamo ya Menefokafo luneu mino nedaito, ido namo ayaidana oto amo lulau mino edomo mona ya kolife lalo, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Eti lito, nela numugu fulo edenune, loti afa, amo fulo gedeito wiye. ");
INSERT INTO snp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uto kofa Yodani no wela filigaleka afula Yonikafo komu apito wenena noku wi gedaido yalo uto minaiye. ");
INSERT INTO snp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yalo minaito, wenena mukite minaido ya u fedeti ka eti loti lamo, Yoni ya Goti aumala lilibami neta mona olu oloto piyámaifa, wewa amamu kala limoma muki ya ka ona kula ne, lato, ");
INSERT INTO snp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","mika yalo ya wenena mukite Yesu koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ena Betani numudo ya we ma kuliya Lasalusi ya neta kilito onaido ya Maliate atelafo Matate numuni meya yalo ya ne. ");
INSERT INTO snp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Komu Malia yakafo ladanuwa imo nowala ya Wekola fili edeto manena yowalakafo kiyanalo kilili edami wena emonala Lasalusi ya neta kilamima nenako, ");
INSERT INTO snp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","yamu kunalafo atelafo lele yate Wekolao, seka-muluga umanimo wema moda neta kili minaiye, loti ka ya Yesudoka fulaito ya wiye. ");
INSERT INTO snp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eti loti fulaito, Yesukafo kawa kolito ya eti loto limo, Netawa kilami ya fulunami neta kilámaiye. E’e, netawa fede umami ya Goti aumala gilibageto eyeti Goti kuliya olu akaiya enawae, loto fede umaiye. Ido yako minámaiye. Netawa kilami yakafo Goti Nalafo namo ya aumala ya giliboneto kuline olu faka lenawae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ena Yesu ya Matale, kunalafole, Lasalusile ya siya-muluna gimito, ");
INSERT INTO snp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ido neta kilami kawa ya kolito, minaido ayalo ya fo kamena lele fa minoto, ");
INSERT INTO snp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","aiga ya eti limo, Yudia mikalo itibito wokele, loto ege-ege moinamo we logimaito, ");
INSERT INTO snp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","eti loti loga o edamo, Api lilibanimo we, Yuda we yate komu yaloma kifanakafo kofenune, loti lamo yama nenako, kamo nedito kofa itibinune, loto lane? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Etiti loga o edato, Yesukafo ka itibito logimami, Mate ledafe, folilofe ido lunagafe ya moninawamo wenena ya mikaleka ama lamedo moinanako, moda uteba-ateba ginámenagolifa, ");
INSERT INTO snp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ido ma ya luwaila moninawamo ya lamena minámainako, uteba-ateba gininagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ena ka ma enu wito eti logimami, Yowote we Lasalusi oku onami ya uto eku enagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eti logimami yamu ege-ege moinamo we yate eti loti loumamo, Wekolao, oku onenami ya neta kilami moda faka lenami ne, loti lamo, ");
INSERT INTO snp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ya Yesu ya Lasalusi folami yamu logimaifa, ido oku ona onamimu liye, loti kolife ádanako, ");
INSERT INTO snp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","yamu Yesukafo ka lo oloto ito logimami, Lasalusi ya moda fulutaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ido linate koli kiki lenawae, loto namo uto yalo minámoneto folaito, ya linatemu kolito senemulune lalo iye. Moda amodoka wokele, loto logimaito, ");
INSERT INTO snp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ido Tomasi kuliya ma Didimusi yakafo Yesu ege-ege moinamo we liliga ya eti loto logimami, Amoki fulunuge, lako wokele, loto ya logimaiye. Wewa kuliya ya Giliki wenena kanidokati ya Didimusile, loto nemo kuliya monawa ya lobe kipale, loto ne. ");
INSERT INTO snp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ena Lasalusi kono ukana kaleku mele edamo ya fo kamena fo (4) ya wito Yesu u fedeto ya kawa kolaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ena Betani numuna ya Yelusalemu minomo lomaido adu kilomita tili (3) ya kofala ma yalo ya nenako, ");
INSERT INTO snp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuda wenena mukite Matate Maliate gemonani folami yamu afele uto geyenune, loti wae. ");
INSERT INTO snp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wato, ena Yesu o fedaiye, loti lamo ka ya Mata kolito, Malia ya numugu fa minaifa, ido amo ya uto kanudo katula enae, loto wiye. ");
INSERT INTO snp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Uto katula oto ya eti loto loumami, Wekolao, kamo amalo minanimo neko, nemonane folámagi ne. ");
INSERT INTO snp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ido oiya ama kamo ya neta yaidana neta yamu Goti loumageto moda kumunamima ne, loto ya koli minowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Loumaito, Yesukafo eti loto loumami, Kemonaka ya moda kofa nedinagoliye, loumaito, ");
INSERT INTO snp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matakafo eti loto loumami, Aiga kamena nabalo ya wenena folaguti nedinawamo kamenalo ya kofa nedinami ya koli minowe, lito ");
INSERT INTO snp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesukafo loumami, Itibiti neidamo ido omuni kofawa minamo aboga ya nanimo ya minonako, ma namo koli kikito numunawamo yate fulunawafa, ayawa ya moda kofawa minomo dinagilae. ");
INSERT INTO snp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ido ma yate omuni kofawa minoti koli kikito numunawamo ya folámotiko minomo uti minenagilae. Kamo kawa ya koli kikitabe? lito, ");
INSERT INTO snp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ya Matakafo loumami, O, Wekolao, Gotikafo Nalafo Kilisto ilifi melami we ya mikaleka lumunagoliye, loti lamoma ya kamo minanimo ya koli kikito komowe, loto ya loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Eti loto kunalafo Malia nedo uto nimu-nimu loto eti limo, Api lilibami wema oto kamo kaka-kaka liye, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ya Maliakafo kolito ayalo nedito Yesu nedo unae, loto kolito wiye. ");
INSERT INTO snp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Wito, ya Yuda wenena kenanumukubanumu oti numunau minamo wenena yate ya eyeto ya kono kalelo ya kufu enae, loto wiye, loti ege uti eyamo ya Yesu ya numuna onowalo Mata ka loumaido ayalo minaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yamu Malia ya numuna onowalo ya lumuto Yesu eyeto kiyana abusa wito eti loto loumami, Wekolao, kamo amalo minanimo neko, nemonane ya folámagi ne, loto ");
INSERT INTO snp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","kufu ito ya Yuda wenena ege wamo yaki lakoina kufu amo ya Yesukafo geyeto siya-mulunau yukeke ito keina naba fuluto ");
INSERT INTO snp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ya egau mele edae? lito ya Wenabao, oto eyo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ena Yesu ya omunau kufu di faitoto omunauti omuna nowala lomaito, ");
INSERT INTO snp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuda wenena eyeti eti loti lamo, Eyalo. Siya-muluna naba-naba umaiye, lato, ");
INSERT INTO snp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ido liligate lamo, We ama ya omuna likami we olu falato edami yamaidana oto amalo minami neko, ya fa olu faka lo edagi ne, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eti lato, ya Yesukafo kofa siya-mulunau yukeke ito kono kalelo ya u fedeto ya kono aumala kifana lula kanu ya kifana nabakafo itamo ya eyeto ");
INSERT INTO snp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ya kifana olu fulalo, lito ya folami we emona-ilofo Matakafo eti loto loumami, Wenabao, kamena fo (4) ya onami yakafo uwanu otaiye, lito, ");
INSERT INTO snp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesukafo eti loto loumami, Kamo koli kikito numunanimo Goti aumala oloto piyageto eyenanimo ne, loto lokomomo ya kolámabe? loto loumaito, ");
INSERT INTO snp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","kifana olu fulato, ya Yesukafo ko akawa ito eti loto limo, Weyano, kamo lokomomo kolanimo yamu ya keboka lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kamo kamena-kamena lokomomo koli-koli o minanimo ya koli minofa, wenena amau minomo wamo ya kamo nilifi melageto lomomo yama koli kikitenawae, loto ya lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eti loto lo faka loto loumami, Lasalusiyo, kamo lomo, loto lu fiyaito, ");
INSERT INTO snp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ya folami wema lomaiye. Lomaito, kiyana-analo ya owo lafolafokafo nela luku edamo ido kola-wela lafolafokafo asa wiyamo yama Yesukafo efili fulo edalo, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ena Yuda wenena Malia minaidoka o fedamo wenena yauti mumudite Yesu neta imo ya eyeti koli kikito umafa, ");
INSERT INTO snp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","liligate ya Falisi we minado ya uti Yesukafo neta imo ka yama wetata gimato, ");
INSERT INTO snp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","amote kawa ya koliti Goti yokila ki umamo we kiyabani we yate mono kanisole olu mau wi gedeti eti loti lokoli-fakoli amo, Ama we yakafo neta kofawa mumudi oto aumala gilibami we ya nedi-nedi o edenune? ");
INSERT INTO snp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lalimo koito edenumo ya wenena muki yate koli kikito umunagilanako, Lomu kimiwe yate olu kuwotefo buluti oti felegaga ebate ido wenenate yaki muki olu kopaiti ledenagilae, loti ya lae. ");
INSERT INTO snp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eti loti ya ena amo minagu yauti we ma kuliya Kaiyafasi ya melege lawoko ayau ya Goti yokila ki umamo we kiyabani we wenaba yakafo eti loto limo, Linate ka manidigu minámami minafe? ");
INSERT INTO snp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lamo Yuda wenena muki ya u kopa otenune, loto we lawoko ma lamomu oto fulunami ya lalo minenagolone, loti ya kolámafe? loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eti loto limo ka ya aimola kala kiyaido ádaiye. Melege onema ama ya ayau ya Goti yokila ki umamo we kiyabani we wenaba minaima nenako, Yesu ya ona Yuda wenenamu oto fulunaiye, loto limo ka ya ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kawa limo ka ya Yuda wenena yamuko ádaiye. Goti nomilipala mikau-mikau mino oluti wamo wenena muki ya olu mau wi ledaito mau lawoko wito minenune, loto yamu kawa ya logimami ne. ");
INSERT INTO snp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ena kamena yaloti mele piti ya egaidana oto Yesu ya ofenune? loti kudala kiyae. ");
INSERT INTO snp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yamu ya Yesukafo Yuda wenena minado ya kofa oloto pito moinámoto, mika ma kofo mika adu nemo filigaleka ya numuna ma nemo kuliya Efelaimi yalo ya ege-ege moinamo we gilimito wito yalo ya minae. ");
INSERT INTO snp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ena Yuda wenena Gotikafo Elita O Gedami foli kamenani alitito numuna kefoku-kefoku yati wenena so loti ukade-oude-lute-kate noku wito Goti omunalo mo loto minenune, loti Yelusalemu ya idae. ");
INSERT INTO snp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Diti felegaga kuliyai numuna nabau ya Yesu moni wiliti eti loti ya lokoli-fakoli amo, Linate nediye loti kolae? Amo ya oto foli ya ágenaife? lato, ");
INSERT INTO snp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Goti yokila ki umamo we kiyabani we ido Falisi we yate ka auma witi eti loti lamo, Linate ma yate minenami eba kolitima ya oti lolomato nela wi edenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ena Gotikafo Elita O Gedami foliwa alitoto kamena sikisi (6) yako wageto neto, Yesu ya Betani numudo ya u fedaito numuna yalo ya Lasalusi Yesukafo folaiguti olu nedi edami we ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Minami eba yalo ya Yesu konuma-kobina ofo ki edato, Matakafo olufe loto mele gedaito, Lasalusiki lako noti minato, ");
INSERT INTO snp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliakafo yá nowala ladanuwa imo kuliya naliti meinala naba nemo ya oluto Yesu kiyanalo lekito fili edeto atela yowalakafo kilili edaito, numugu ya moifawa faito fulitaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Etito nefa, Yesu ege-ege moinamo we yauti ma Yudasi Isikaliyoti kuwolafo anido melami we yakafo eti loto limo, ");
INSERT INTO snp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ladanuwa imo no ya fuloto kifana meina olunumo ya we makafo melege lawoko lono oluto meinala olami yaidana oluto wenena neta ko ánamo wenena ya gimonimo neko, lalo agi ne, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Eti loto limo ka ya neta ko ánamo wenena yamu kolito ádaiye. Aimola ya ugele we minoto Yesu ege-ege moinamo we kifana-koukameni kiyaba oto kifana melagu yati ugele olu-olu imo ne. ");
INSERT INTO snp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yamu Yesukafo eti loto ya limo, Linate wena ya ka loumámalo. Ladanuwa imo no ya kiyanelo fili nedami ya foloneto mele nedenawamo yamu kolito mele minami nefa, oiya fili nedaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wenena neta ko ánamo wenena ya moda linateki ekeleti minomo unawafa, namo ya linateki kamena fana ekeleto minámenagolowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ena Yuda wenena so loti yate numuna yalo minaiye, loti lamo ya koliti ayalo ya u fedamo ya Yesu yamuko áumae. Lasalusi folaiguti olu nedi edaito minami we yaki eyenune, loti wae. ");
INSERT INTO snp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ido Lasalusi yamu Yuda wenena mumudi yate kiyabani we kiyanido yati Yesudoka u ekeleti koli kikito umamo yamu Goti yokila ki umamo we kiyabani we ama ya Lasalusi yaki lakoina gininune, loti ka lono olae. ");
INSERT INTO snp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ena leda ko lito wenena mau naba yate foliku ya Yelusalemu ya o fedamo wenena yate Yesu kanudo o minaiye, loti kala kuwa koliti ");
INSERT INTO snp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ya yá aila leketi olu ani-ani oti kanudo katula enune, loti uti ya aiyo-koiyo ka lo edeti eti loti lamo, Aiyo, siyane, hosana! Wekola kuliyalo ami we ya lalo kolimo wimo ne. Isilaeli wenena kiyabate we wekudi ya lalo kolimo wimo ne, loti aiyo-koiyo ka lo edemo wae. ");
INSERT INTO snp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ena Yesukafo yafo-dogi agele olu oloto pito meyalo ya minoto wimo yamu ka mono lufuwau ya eti limo, ");
INSERT INTO snp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Linate Saiyoni wenenao, koli gimámaneyo. Eyalo. Kiyabatina we wekudi ya yafo-dogi agele meyalo amedoto minoto ya aiye, loto ka mono lufuwau (Sek 9:9) nemo ka yama oiya ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ya ka ya ege-ege moinamo we ya komu ya kolife ádoti minafa, ido Yesu kosinau lamenalauka itibito idaito, aya kawa ya koliti ama ya amomu lufuwa wiyanako, neta eti o edae, loti koliti ya kolife lamo ne. ");
INSERT INTO snp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ena komu Yesukafo Lasalusi lula fito olu nedi edaito kono kalekuti lomaito, eyamo wenena mau naba yate liligaleka wetata o gimato, ");
INSERT INTO snp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","aumala gilibami netawa ya kawa kolamo yamuki wenena so loti kanudo katula ato, ");
INSERT INTO snp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Falisi we yate inanimoko eti loti lokolifakoli amo, Linate ka lamoma eleka ginami ya koli minafe? Muki wenena amodoka u ekeletamo ama yae, loti lokoli-fakoli ae. ");
INSERT INTO snp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ena Yuda wenena foliku ya Goti oudelute-kate umunune, loti Yelusalemu o fedamo wenena minagu ya Giliki wenena ma minoti ");
INSERT INTO snp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Galili mikalo Betesaida numudoti we Filipi minaido ya oti eti loti loumamo, We kofawe, lamo Yesu ya eyenune, loto kolone, loumae. ");
INSERT INTO snp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Loumato, Filipi uto Adulu ya loumaito lako Yesu nedo ya uti ka ya loumaito, ");
INSERT INTO snp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesukafo eti loto ya logimami, We Kula namo kuline oloto pi lalo enami kamenawa ama ya fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ka ona lema logimowe. Yuwa witi ufa ya mikau lumuto foikámotoma ya idámenami ne. Nefa, lumuto mula fudoto fokinami ya dito ilawa mumudi oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wenena makafo aimolamuko kolinami we ya u kopa unagolifa, makafo ama mikalo aimolamu kolámenami ya omuna kofawa minowa-minowa enagoliye. ");
INSERT INTO snp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ido makafo namo kouba-nabane we minenae, lenami ya nege-nege moni minaneyo. Ido namo minodo ya kouba-nabane we yaki minenagolone. Ido ma ya namo kouba-naba o nedenawamo wenena ya Menefokafo kulini olu faka lenagoliye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ido ka ma mene oto eti loto logimami, Ama ya sene-muluneu yukeke ito kolomo keina iye. Ena nediye lenamo ne? Weyano, kamenane alitimo ya kamo olu fulito nedo, lenafe? E’e, kamenawa yamu Menefo nilifi melaito, lomomoma nenako, yaidana ádenamo ne. ");
INSERT INTO snp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Weyano, kamo aumaka olu oloto piyageto kulika oloto pi lalo enaiye, lito ya kosinauti ka eti loto limo, Kuline moda oloto pi lalo ito ido kofa ma oloto pi lalo enagoliye, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eti lito, wenena mau minamo yate koliti ya mate kopana ko kalake liye, lato, ido ma yate enisole makafo ka loumaiye, lato, ");
INSERT INTO snp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesukafo wenido yati oluto eti loto logimami, Ka ya nanimomu minámaiye. E’e, linatemu oto oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Oiya ama ya mikaleka wenena lifima ka giminami kamena alitinako, mika amalo wenena wenabani Satani ya itufu fulitenagolowe. ");
INSERT INTO snp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ido mikalekati olu faka lo nedato, mikau-mikau wenena muki ika oneto namodoka enagilae, loto ");
INSERT INTO snp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ya eti limo ka ya fulunami monawa yamu ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Logimaito, wenena mau minamo yate ka itibiti eti loti loumamo, Lamo lo melami ka yau eti loto neto kolonimo, Gotikafo ilifi melami we Kilisto ya folámoto ya minomo uto minenagoliye, loto limo ka ya kolitonimo ne. Etito nefa, ido kaimoka ya We Kula ama ya olu akaiya edenagilae, loto ya nedito lane? We Kula ya kema ne? loumae. ");
INSERT INTO snp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Loumato, Yesukafo ka eti loto logimami, Yo lamena ya linate minagu ya kamena lina efema lamena enagoliye. Yamu ya sinikafo asa wi ledetenaiye, loti ya yo lamena mino gedami kamenalo ya oti meleti moniti minalo. Ma yate sinidenaigu uti kanu kofe ádenagilae. ");
INSERT INTO snp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yamu ya yo lamena mino gedami kamenalo ya lamena wenenala kula enune, loti lamenawa ya koli kikito umalo, loto ya Yesukafo ka eti loto uto falukuto minaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ena Yesukafo ya neta mona-mona oto aumala omuni kulalo ya gilibaifa, koli kikito umámae. ");
INSERT INTO snp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Koli kikito umámamo ka ya polofete Aisaiyakafo eti limo, Wekolao, ka wetata o gimonimo ya kemakafo koli kikito minaiye? Ido Wekola aumala oloto pi gimami ya kemakafo eyefe lenaiye? loto ka mono lufuwau (Ais 53:1) nemo ka yama u Yesudo ya kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Ido Aisaiya ka ma eti limo, Omunikafo ko-ko o minoti, lunikafo kolife loti koliti, seni-muluni ya olu eleyapa witi namodo ato olu faka lo gedetenae, loto ya omuni ofo likoto luni olu gedo gedaiye, loto ka mono lufuwau (Ais 6:10) nemo ka ya koli kiki ádamo monawa yamu ya liye. ");
INSERT INTO snp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Eti loto Aisaiyakafo kawa lufuwa wiyami ya Yesu aumala lamenala naba eyainako, yamu amomu loto ya lufuwa wiyami ne. ");
INSERT INTO snp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ena Yuda wenena kiyabani we liligate Yesu koli kikito umafa, lo oloto pinunako, Falisi we yate ya mono numuguti olu fulito ledetenawae, loti koli gimaito, Yesu koli kikito umamo ya lo oloto piyámae. ");
INSERT INTO snp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aya wenenawa ya mikaleka wenena yate kulini olu faka lenawamo yamuko kolamo, ido Gotikafo kulini olu faka lenami yamu kolámae. ");
INSERT INTO snp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ena Yesu ya ka lo faka loto eti limo, Namo koli kikito nomamo wenena ya namoko o nomámae. Nilifi melami we yaki lakoina koli kikito lomae. ");
INSERT INTO snp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ido namo neyefe lamo wenena ya nilifi melami we yaki lakoina leyefe lae. ");
INSERT INTO snp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ido koli kikito numunawamo wenena ya siniku minámenawae, loto namo mikaleka minamo wenena olu lamena o gedenae, loto lomomo ne. ");
INSERT INTO snp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ido kane koli fulitenawamo ya lifima ka gimámenagolowe. E’e, namo ya wenena lifimani olu giminae, loto ámowe. Olu omuni kenae, loto lomomo ne. ");
INSERT INTO snp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ido namo fulo nedeiti kane yaki koli fulitenawamo wenena ya lifima ka itibito giminami we ya ne. Ka lomo ka yamo kamena nabalo ya olu kalo mele gedeto, lifima ka itibito giminami ne. ");
INSERT INTO snp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Namo ka lomo ya nanimo luneuti kolito ma ádowe. E’e, Menefo nilifi melami we aimolakafo ka eti loto lo oloto melenane, loto lo meleto kane olami ya ne. ");
INSERT INTO snp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ido amo welaloti ka yakafo omudi kofawa minenawamo kanuwa nemo ya koli minowe. Yamu ka lo minomo ya Menefokafo kane oluto lonomaido ayalo ya lo-lo o minowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ena Gotikafo Elita O Gedami foliwa alitito Yesukafo aimolamu eti loto kolami, Namo mika fulito Menefodoka itibito dinamo kamenane ya alitiye, loto kolito ya mikaleka wenenala siya-muluna gimami ya sene-mulune gimi fuli loto fulunae, loto ya kolaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ena Satanikafo Saimoni Isikaliyoti nalafo Yudasi ya Yesu kuwolafo anido melenaiye, loto ile fali siya-mulunau wiyaito, ya luwaila kobina nenune, loti mau wi minato, ");
INSERT INTO snp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ya eti loto kolami, Menefo yakafo neta-mata muki ya namo anelo mele fuli limo ne. Ido namo ya Gotidokati lomoma nenako, kofa ya Gotidoka itibito dinamo ne, loto kolito, ");
INSERT INTO snp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","weni-neta noti minaguti nedito, ukanalo owo fana ya kololototo tauli ya kofalalo lukaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lukuto no ya lapeku ya lekito apito ege-ege moinamo we kiyani noku wi gedeto tauli kofalalo lukami yakafo kilili o gedaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eti o gedemo oto Saimoni Pita nedo ya aito, eti loto loumami, Kamo Wekolamakafo kiyane noku winae, loto abe? lito ");
INSERT INTO snp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesukafo ka itibito eti loto loumami, Neta o minomo ya monawa oiya amaleka ya kolámane. Minoto aiga afimaleka kolinagolane, lito ");
INSERT INTO snp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitakafo eti loto loumami, E’e, namo kiyane ya noku wiyámenane. Fulito, loumaiye. Loumaito, Yesukafo eti loto loumami, Namo noku wi kedámenamo ya namote lute lawoko minámenagoliye, lito, ");
INSERT INTO snp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimoni Pitakafo eti loto loumami, Aiyo, Wekolao, eti lotoma ya kiyane yako noku wi nedámoto, ane, manene yaki muki noku wi nedo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Loumaito, Yesukafo eti loumami, Ma ya noku onoti aiga kiyaniko noku wiyatoma, ukani mo loto minenagilae. Yamu linate ya yaidana oto olu mo lo gedofa, linate muki yamu ádowe, loto limo, ");
INSERT INTO snp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ya kuwolafo anido melami we ya eyefe linako, linate muki ya mo loti minae, loto ádowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ena kiyani noku wi fuli loto ukanalo owo fana ya kofa olu wito weni-neta noti minagu kofa amedoto eti loto logimami, Namo neta ama o gedomo ya monawa linate koli minafe? ");
INSERT INTO snp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Linate ya api lilibanimo we ido Wekolate, loti ya lonumu-numu o minamo we yama moda ya minonako, lema lonumu minae. ");
INSERT INTO snp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Etito namo Wekolatina ido api gilibomo wemakafo kiyadi noku wi gedomo ya linate ayaidana oti wenenatina kiyani noku wimo walo. ");
INSERT INTO snp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Namo eti enawae, loto neta o gedomo mona ya linate yaki ayaidanako omo unawae, loto gilibowe. ");
INSERT INTO snp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Namo ona lema logimowe. Kouba-naba we yakafo wenabala olu afima o edámenami ne. Ido ilifi melaito wimo we yakafo ilifi melami we ya olu afima o edeto minenami we yaki ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yamu linate ka logimomo kolife loti ayalo efe ya meyalo meleti minenawamo ya moda lalo kolimo unawae. ");
INSERT INTO snp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Lalo kolimo unawafa, linate muki yamu ádowe. E’e, namo iyaina o gedomo wenena ya koli minowe. Ka lufuwa ma ya eti limo, Wela-neta beleti umomo we ya nofenami kuwonefo builami we ya ne, loto ka mono lufuwau (Sng 41:9) nemo ka yama u ayalo kulawa fedenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Neta ya aiga oloto pinagolito ya namo minomo ama ya monane logimi-gimi omo ya linate koli kikitenawae, loto ya oiya oloto piyámaito komu logimi minowe. ");
INSERT INTO snp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Namo ka ona lema logimowe. Ma yate lono ka logimomo ya koliti uti olamo wenena ya we mate olu koina wi gedenawamo ya namo lono aboga yaki olu koina wi nedenagilae. Ido namo o nedenawamo ya nilifi melami we yaki olu koina wi edenagilae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ena Yesukafo kawa eti loto siya-mulunau yukeke ito keina fuluto eti loto lo oloto meleto logimami, Namo ka ona lema logimowe. Linatedokati makafo namo ya kuwonefo-mota anido giminagoliye, lito, ");
INSERT INTO snp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ege-ege moinamo we ya kogo inanimo geyeti, Kemamu liye? loti ligiligi kani kiyae. ");
INSERT INTO snp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ena ege-ege moinamo we yauti ma ya Yesu siya-muluna umami we ya Yesute lako ekeleti amedoti minaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yalo amedoti minaito, ya Saimoni Pitakafo omuna kifiya fatana kito loumami, Loga o edageto lokomaneyo. Ya kemamu liye? lito ");
INSERT INTO snp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","amo ya atela ya Yesu ikiyalo ya fuloto loga o edami, Wekolao, kamo kemamu lane? lito ");
INSERT INTO snp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesukafo ka itibito limo, Beleti obokito supuku ya fito olu umoneto nenami we yamu lowe, loto ya beleti obokito supuku ya fito Saimoni Isikaliyoti nalafo Yudasi ya olu umaito naiye. ");
INSERT INTO snp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Naito, Satanikafo siya-mulunau idaito ya Yesukafo Yudasi eti loto loumami, Neta enae, loto lanima ya uto alako omo, loto ");
INSERT INTO snp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ya ka eti loto loumami ya liliga muki yau minamo ya monawa kolife ádae. ");
INSERT INTO snp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kolife ádamo yauti malekate eti loti kolamo, Yudasikafo ya kifana mele-mele onimo koukame kiyaba imo we nenako, wenena neta ko ánamo wenena ya kifana giminaiye, loto ilifi melaifemo, ido foli neta ma meina finaiye, loto ilifi melaiye? loti kolae. ");
INSERT INTO snp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ena Yudasi ya beleti obokito umami ya noto ayalo yati lumuto uto sinidigu ya wiye. ");
INSERT INTO snp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ena Yudasi wito, Yesukafo eti loto limo, Oiya ama ya We Kula namo ya kuline oloto wiye. Ido namodoti ya Goti kuliya oloto wiye. ");
INSERT INTO snp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ido namodoti Goti kuliya oloto winako, Goti aimoladokati ya namo kuline olu oloto pinagoliye. Oiya eti-mati ya kuline olu oloto pinagolimo ne. ");
INSERT INTO snp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nomilipane-motao, namo ya kamena lina efema ya linateki minenagolowe. Ena namo monine wilinagilae. Yamu Yuda wenena logimomaidana oto oiya linate yaki logimowe. Namo unado ya ámunagilae. ");
INSERT INTO snp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ena lo melomo ka kofawa logimowe. Linanimotina seti-muludi ya gimi-gimi o minalo. Namokafo ya sene-mulune linate gimi-gimo omo yamaidana oti linanimotina seti-muludi gimi-gimi otiko minalo. ");
INSERT INTO snp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Etiti seti-muludi gimi-gimi enawamo ya wenena muki yate ya namo nege-nege moniti minamo wenena kula minae, loti ya geyenagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ena Saimoni Pitakafo loga o edeto limo, Wenabane, kamo ya egaleka unane? lito ya Yesukafo ka itibito loumami, Namo unado ya oiya eti-mati ya nege ámunagolane. Minoto aiga nege enagolane, lito, ");
INSERT INTO snp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitakafo eti loto loumami, Wenabane, nedito oiya kege ámunamo ne? Nofo fulunune, lotima fa nofo fulunawae. Namo kege melenae, lito, ");
INSERT INTO snp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesukafo ka itibito loumami, Ona, kamo fa nofo fulunawae. Kege melenae, loto labe? Namo ona lema lokomowe. Okolofo nola ádageto kamo kamena tili (3) ya kuline olu falukunagolane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ena Yesukafo ka ma enu wito eti loto logimami, Linate seti-muludigu yukeke ageto keina folámalo. Goti koli kikito umuti namoki lakoina koli kikito nomalo. ");
INSERT INTO snp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Menefo numuna meyalo ya numuna so loto minomo wiye. Ayalo ya eba olufe lo gedenae, loto unagolowe. Ya etito minámami neko, kawa ya logimámogi ne. ");
INSERT INTO snp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ido uto eba olufe lo gedetoto, ya namo minenado ya linateki namoki lakoina minenagolone, loto kofa itibito oto gilimito unagolowe. ");
INSERT INTO snp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ido uto minenamo kanuwa ya eye minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Logimaito, Tomasikafo eti loto loumami, Wenabate, kamo uto minenanimo eba ya lamo kolife ádone. Yamu egaidana oto kanu ya kenumo ne? lito, ");
INSERT INTO snp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesukafo eti loto loumami, Kanu ido mona ona kula ido kofawa minenawamo mona ya nanimo ya minowe. Etito minomo ya namo fulo nedeiti Menefo nedo unawamo ya ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Linate namo neyefe lamo neko, Menefo yaki eyefe lo minagi ne. Oiya amaloti ya Menefo kolife loti ya eyefe lo minae, liye. ");
INSERT INTO snp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Lito, Filipikafo eti loto loumami, Wenabate, kamo Metefo lilibageto eyenumo yamo ya ogofunaiye, lito, ");
INSERT INTO snp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesukafo loumami, Filipiyo, namo kamena fana linateki minomo yama neyefe ádanimo nefe? Namo neyamo wenena yate Menefo ya eye minae. Kamo ya Metefo lilibageto kenune, lanimo ya nedito lane? ");
INSERT INTO snp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Namo ya Menefo lulau mino edomo, ido Menefo ya namo luneu mino nedami ya koli kiki ádabe? Ka logimi-gimi omo ya nanimodokati logimámowe. E’e, Menefo luneu mino nedami yakafo lonola ya olu-olu o minaiye. ");
INSERT INTO snp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Namo ya Menefo lulau mino edoneto, ido Menefo ya namo luneu mino nedaiye. Ya kawa ya koliti koli kikito nomalo. Ido koli kiki ádotima ya neta o-omo monane yamu koliti koli kikito nomalo. ");
INSERT INTO snp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Namo ona lema logimowe. Namo koli kikito numunawamo wenena yate lono olu minomo yaidana oti ya olunagilae. Ido yako minámaiye. Namo Menefodoka dinagolomo yamu ya namo olu fulo nedeti olunagilae. ");
INSERT INTO snp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nalafo namodokati Menefo kuliya dinagoliye, loto namo kulinelo ya linate neta-mata mamu lonumunawamo ya moda enagolowe. ");
INSERT INTO snp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Linate namo kuline olu minoti neta-mata mamu lonumunawamo ya moda enagolowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ena ka ma enu wito eti loto ya limo, Linate seti-muludi numu minenawamo ya wenelo golodenagilae. ");
INSERT INTO snp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Etiti minenawamo ya namo Menefo loumoneto linate adi olu faka lenami we ma ilifi melageto lumuto linateki minowaminowa oto minenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Amo ya ka ona kula aboga Ouna ya ne. Amo ya mika ama wenenala yate eyefe ádoti ya ido kolife ádanako, yamu olámenawamo ne. Amo ya lumuto lutigu mino gedenagolimo we ya oiya linateki minomino inako, linate koli-ágoli ámoti, kutifi o ede minae. ");
INSERT INTO snp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Namo fulo gedoneto, lifa nomilipa keleti minámenagilae. E’e, namo linatedoka itibito enagolowe. ");
INSERT INTO snp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kamena kofala lina ma nenako, ya fuli lageto linate ya neyenagilafa, ido mika ama wenenala ya neyámenagilae. Namo ya omune kofawa minomo idonako, linate yaki omudi kofawa minomo dinagilae. ");
INSERT INTO snp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kamenawa yalo ya eti loti kolinawamo, Namo ya Menefo lulau mino edowe. Ido linate ya namo luneu mino nedae. Ido namo ya linate lutigu mino gedowe. Ya kamenawa yalo ya kolife lenagilae. ");
INSERT INTO snp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Weneloti kane olu minoti meyalo melamo wenena ya seni-muluni nomamo wenena minae. Ido seni-muluni nomamo wenena ya Menefokafo siya-muluna gimageto nanimo yaki sene-mulune gimito monane olu oloto pi giminagolowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eti lito, Yudasi Isikaliyoti lilafokafo loga o edeto limo, Wenaba, kamo ya nedito monaka ya lamo yako olu oloto pi lumuto, ido mikalo wenena liligaleka olu oloto pi gimámenanimo ne? lito, ");
INSERT INTO snp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesukafo ka itibito loumami, Seni-muluni numunawamo wenena ya kane koliti golodenagilae. Ido seni-muluni numuti kanelo golodenawamo wenena ya Menefokafo siyamuluna giminagoliye. Siya-muluna gimageto namoki lakoina wenenawaleka ya uto lako mino gedemo dinagoloiye. ");
INSERT INTO snp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ido seni-muluni nomámenawamo wenena ya kane ya koliti golo ádenagilae. Ido kawa koli-koli o minamo ya nanimo kane ma minámaiye. E’e, ya Menefo nilifi melami we kala ya ne. ");
INSERT INTO snp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ena namo nanimo ya linateki minoto ya kawa muki logimofa, ");
INSERT INTO snp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","adi olu faka lenami we Ouna Felegaga ya Menefokafo namo kulinelo ilifi melageto lumuto neta muki neta ya api-napi o gimito ya ido nanimo logimi minomo ka ya kofa kati-manidigu mele gedenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ena namo you amene mona gimomo ya mino gedageto unae. Mika ama wenenala you lo gedamo yaidana oto olu you lo gedámowe. E’e, namo nanimo you amene monane ya gimowe. Yamu ya seti-muludigu yukeke ageto keina folámalo. Ido koli gimámaneyo. ");
INSERT INTO snp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Namo uto minoto linatedoka kofa itibito enagolowe, loto logimitoneto kolitamoma ne. Menefo ya we naba-naba minoto olu fulo nedaima nenako, linate luti-kati nomamo neko, ya Menefodoka dinagolomo yamu seti-muludigu lalo kolagi ne. ");
INSERT INTO snp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ama ya kulawa oloto piyámaito, aiga oloto piyageto eyeti koli kiki loti kolinawae, loto ya komu ya logimowe. ");
INSERT INTO snp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ena namo ama ya ka ma mumudi enu wito logimámenagolowe. E’e, mika amalo wenena wenabanina Satani oto namo ya olu fulo nedámenagolifa, ");
INSERT INTO snp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","namo Menefo sene-mulune umutoko minomo ya mika ama wenenala kolife lenawae, loto Menefo ka lonomami ya olu meyalo melenagolowe. Nedito wokele, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ena ka ma enu wito eti loto logimami, Ilawa liyami nela waini kofala mona ona ya namo minoneto, ido Menefo ya nela waini kilau kiyaba imo we aboga ne. ");
INSERT INTO snp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Neto ya yá akawa ma ya namodoka mino oluti uti ilawa liyámamo ya alito olu fulitenagolifa, akawa mate ilawa linawamo ya lalo diti ilawa so loti linawae, loto kiyanau ya ali fulitenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Linate ya ka mono logimomo kawa yakafo ouni-luni-kanigu nosámami neta nemo ya oiya olu fulito gedetaiye. ");
INSERT INTO snp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yamu linate ya namodoka mino nedalo. Mino nedato ya namoki ya mino gedenagolowe. Nela waini akawa yakafo kofalalo minámenami ya aimolako minenami ya ilawa liyámenagoliye. Ido linate ya ayaidana oti namodoka mino nedámenawamo ya ilawa liyámenagilae. ");
INSERT INTO snp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nela waini kofala mona ya namo minoneto, ido uma akawa ya linate ya minae. Ma yate namodoka mino nedamo wenena ya namo ya amodoka mino gedoneto, amo yate ilawa nabanaba liyae. Linate namoki minámenawamo ya neta ma enawamo ya ogoufámenami ne. ");
INSERT INTO snp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Makafo namodoka mino nedámenawamo ya yá akawa yaidana oto alito olu fulitato fulunagoliye. Folageto ya olu mau witi fulo yoku iti kinagilae. ");
INSERT INTO snp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Linate namodoka mino nedato ido kane ya linatedoka mino gedenami ya neta yaidaamaidanamu Menefo loumunawamo ya oloto pi giminagoliye. ");
INSERT INTO snp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Linate ilawa naba-naba linawamo ya geyeti namo nege melamo wenena minae, loti geyefe loti Menefo kuliya ya olu faka lenagilae. ");
INSERT INTO snp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Menefokafo siya-muluna numu-numu o minami yaidana oto namokafo sene-mulune linate gimi-gimi o minowe. Yamu linate namo sene-mulune gimodo ayaloko ya minalo. ");
INSERT INTO snp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Namo ya Menefo ka limo ya kolito golodoto ya siya-muluna nomaido ayalo yako moni-moni o minowe. Linate ayaidana oti namo wenelo ya golodotima ya sene-mulune gimodo yaloko ya minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Namo lune-kaneu lalo kolomo yakafo linate seti-muludigu uto faitoto minenaiye, loto ka ama ya logimi fuli lowe. ");
INSERT INTO snp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Namo lo melomo kane ya eti loto logimowe. Namokafo sene-mulune gimomo yamaidana oti linanimotina ya seti-muludi gimi-gimi o minalo. ");
INSERT INTO snp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","We ma yowola wenenamu oto fulunami mona ya wenena seni-muluni gimiti olu lalo o gedamo mona muki ya ofo fuloto ne. ");
INSERT INTO snp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ka muki logimomo ya meyalo meleti minotima ya namo yowone wenena minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Namo kamena amaloti ya kouba-nabane wele, loto kofa logimámenagolowe. E’e, namo yowone wenenanele, loto logimowe. Kouba-naba we yakafo wenabala neta-mata oto meleto imo monala ma kofe ádaifa, nanimo ya Menefodokati ka kolodo ya lo oloto pito logimi fuli lomo yamu namo kouba-nabane wele, loto ádoto yowone wenena minae, loto logimowe. ");
INSERT INTO snp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Linate namo iyaina o nedámamoma ne. E’e, namokafo linate ya uti ilawa olu oloto pinawae, loto iyaina o gedeto luti fiyomoma ne. Ido ilawa olu oloto pinawamo ya minowa-minowa oto minomo dinagoliye. Etiti minoti ya namo kulinelo ya Menefo neta yaidana-amaidanamu loumunawamo ya giminagoliye. ");
INSERT INTO snp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Namo mona etiti melenawamo ka ya logimowe. Linate ya seti-muludi gimi-gimi o minalo, loto ka auma wito lo mele gedowe. ");
INSERT INTO snp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ena mika ama wenenala yate seni-muluni koli nosámami giminawamo ya linate eti loti ya kolalo. Wekolate ya komu apiti ya koli nosámami umama ne, loti namodo ya kolalo. ");
INSERT INTO snp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Linate ya mika ama wenenala yaki ekelamo neko, ya wenenatele, loti seni-muluni gimagi ne. Nefa, namo ya mika ama wenenala minagu yati linate luti fiyomo yamu amo monanina linate fulo gegeka itanako, ya koli nosámami gimi minae. ");
INSERT INTO snp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kouba-naba we yakafo wenabala olu afima o edámenami ne, loto komu logimomo ka ya kati kife lalo. Olu nosámami o nomamo yamaidana oti linate o giminawamo ne. Ido namo kane koli lunigu melamo yamaidana oti linate katina kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nilifi melami we ya eyefe ádama nenako, namo wenenane ya minae, loti koliti olu ya ama o gedenawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ena namo amo minado ya lumuto logimámomo neko, lifimaninaki minámagi ne. Nefa, ama lifimanina ya egaidana oti olu falukunawamo ne? ");
INSERT INTO snp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma yate namo seni-muluni koli nosámami nomamo wenena Menefoki ya ayaidana oti koli nosámami umae. ");
INSERT INTO snp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amo minagu ya mona kofawa melomo, ya wenena komu melámamo mona ya namo olu oloto pito melámomo neko, lifimaninaki minámagi ne. Nefa, ama ya olu oloto pito meloneto eyamo yate ya eye fuliti, namo koli nosámami numuti ya Menefo ayaidana oti koli nosámami umu minae. ");
INSERT INTO snp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Eti amo yamu ya lo melami kanigu ya eti limo, Amo yate faifa koli nosámami nomae, loto ka mono lufuwau (Sng 35:19, 69:4) nemo ka ya ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ena adi olu faka lenami we ya Menefodokati ilifi melenamo we ka ona kula aboga Ouna ya Menefodokati lumunami kamenalo ya monane lo oloto pinagoliye. ");
INSERT INTO snp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ido linate ya lonone aipodomati namoki minomo idama nenako, linate yaki monane lo oloto melalo. ");
INSERT INTO snp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Linate ya namo fulo nedeiti uteba witenawae, loto ka ya komu logimitoma ne. ");
INSERT INTO snp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Amo yate mono numuguti ya gilifi feka fuliti kanu ku gedenawamo ne. Ido kamena ma alitenagoliye. Yalo ya Goti lonola olu minonimo ne, loti ya linate gini fulunawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Amo ya Menefote namote leyefe ádanako, ya eti enawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eti enawafa, namo kawa komu ya logimitomoma ne. Ya ka ya kulawa fedageto ya amokafo komu lolomaima ne, loti ya kati ki gedoti kinawae, loto ya logimowe. Komu ya kamena fanaidana linateki minenagolonako, loto logimámoma ne. ");
INSERT INTO snp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ena ama ya nilifi melami we nedoka dinae, loto odoma ya linatedoka yati makafo kamo egaleka unane? loto loga o nedami we ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Minámaifa, logimomo kawa yamu milumawa seti-muludigu auwa ya faito minaiye. ");
INSERT INTO snp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Etiti minafa, namo ka ona logimowe. Linate ufe lenawae, loto ya itibito dinagolowe. Namo itibito idámenamo ya linatedoka adi olu faka lenami we ya lomámenagoliye. Yamu dito ilifi meloneto ya linatedoka lumunami ne. ");
INSERT INTO snp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lumuto wenena monanina apoli gimageto ya nosámami monawa, ido efe limo monawa, ido lifimani itibito giminami monawa ya kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Namo koli kikito nomámanako, ya amokafo nosámami monawa ya lageto kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ido Menefodoka itibito idoneto kofa neyámenagilanako, ya amokafo efe limo monawa ya lageto kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ido mika amalo wenaba Satani lifimala itibito umaima nenako, Gotikafo wenena lifimani itibito giminami monawa ya lageto kolinawamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ena ka logiminamo ka so loto fa nefa, kamena oiya ama ya lo fuli loto logiminamo ya keina fulutenawae, loto logimámowe. ");
INSERT INTO snp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yamu ka ona kula aboga Ouna ya lumuto kawa ona kula ya api gilibi fuli lenagoliye. Ya aimola siyamulunauti logimámenami, Gotikafo loumami aya yako logiminagoliye. Ido neta-mata aiga oloto pinami yaki lo oloto giminagoliye. ");
INSERT INTO snp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ka ya nanimodokati oluto lo oloto giminami yakafo namo kuline olu faka lenagoliye. ");
INSERT INTO snp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Menefodoka neta-mata muki nemo ya aboga namo minowe. Yamu ya namodokati oluto lo oloto giminagoliye, loto logimoma ne. ");
INSERT INTO snp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kamena lina efema minoti neyámenagilae. Ido kofa kamena lina efema minoti ya kofa neyenagilae, lito, ");
INSERT INTO snp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ege-ege moinamo we yauti maleka ya lokoli-fakoli oti eti lamo, Nena netamu ya ka eti loto liye? Kamena lina efema minoti neyámenagilae, loto, ido kamena lina efema minoti ya kofa neyenagilae, loto ya ido Menefodoka dinagolonako, loto limo yamu ");
INSERT INTO snp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","eti loti lamo, Kamena lina ne, limo ya nediye liye? Ya monawa lamo kolife ádone, lae. ");
INSERT INTO snp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ena loga o edenune, loti kolamo, Yesukafo seni-mulunigu geyeto ya eti loto logimami, Linate kamena lina efema minoti neyámenagilae, loto, ido kamena lina efema minoti ya kofa neyenagilae, loto logimomo yamamu ya lokolifakoli o minafe? ");
INSERT INTO snp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Namo ka ona lema logimowe. Linate kufu oti kufu nema o minato, ido mika ama wenenala yate alikani enagilae. Linate miluma-aluma koliti minenagilafa, milumatina yakafo olu eleyapa wito seti-muludi lalo kolinagilae. ");
INSERT INTO snp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wena makafo nomilipala kedenae, loto kamenala alitageto ya miluma kolinami ne. Nefa, nomilipala kede oloto pitoma ya miluma kolami yama fulitito ya nomilipala kedami yamu siya-muluna lalo kolinami ne. ");
INSERT INTO snp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ido linate ayaidana oti ya kamena amaleka miluma naba koli minafa, kofa itibito oto geyoneto seti-muludi lalo kolinagilae. Setimuludi lalo kolinawamo monawa ya olu kopa o gedenami we ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ena kamena yalo ya neta yaidanaamaidanamu ma loga o nedámenagilae. Namo ka ona kula logimowe. Linate Menefo neta yaida-amaidanamu loumunawamo ya namo kuline olu minanako, giminagoliye. ");
INSERT INTO snp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Komu minomo idado yaloma ya namo kulinelo ya neta mamu loumámamo ne. Oiya amalekati ya loumu-umu o minalo. Eti loumu-umu o minenawamo ya setimuludi laloko koli-koli o minenawae, loto ya giminagoliye. ");
INSERT INTO snp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ka logimi minomo yama asa wito logimoma nefa, kamena ma alitenami yalo ka asa wito ádoto, Menefo yamu lo oloto pito logiminagolowe. ");
INSERT INTO snp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kamena yalo ya kuline olu minoti ka loumunagilae. Namokafo linate yamu Menefo loumu gedenae, loto logimámowe. ");
INSERT INTO snp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","E’e, namo Menefodokati lomomo ka ya koli kiki loti seti-muludi numu-numu o minanako, Menefo aimola siya-muluna ya gimi-gimi o minainako, namokafo Menefo loumu gedenae, loto ádowe. Linate kuline olu minoti ka loumunagilae. ");
INSERT INTO snp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Namo Menefodokati mikalo lomomo ne. Ido ama mika ya fulito Menefodoka kofa itibito dinagolowe, lito, ");
INSERT INTO snp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ege-ege moinamo we ya eti loti loumamo, Aiyo, kamo oiya ama ya ka asa wito ádoto, lo oloto lomanimo ya ");
INSERT INTO snp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","neta-mata muki ya kaimokafo koli fuli lane, loto koli minone. Yamu ya kamo Gotidokati lomanimo ne, loto koli kikito minoninako, kofa loga-miga o kedámenagolone, loti loumae. ");
INSERT INTO snp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Eti loti loumato, Yesukafo ka itibito eti loto logimami, Linate oiya ya koli kikito minafe? ");
INSERT INTO snp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kolalo. Kamena ma alitageto yalo ya linate namo fulo nedeiti upa-napatoti numunidoka u fuli lenawamo ne. Kamenawa oiya ne. Linate fulo nedenagilafa, nanimoko minámenagolowe. E’e, Menefo namodoka mino nedainako, nanimoko minámenamo ne. ");
INSERT INTO snp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Namo luneu mino nedeti ya you amene mona olunawae, loto ya ka ya logimowe. Linate mikalo amalo minoti keina nabau mino-mino afa, namo ya mikaleka keina imo monala muki olu afima o edonako, yamu linate ya aumaniki minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ena Yesukafo ka ya lo fuli loto, kosinauka ko faka loto, eti loto Goti loumami, Menefone, kamenawama alitiye. Kamo ya Nakafo namo kuline olu oloto piyageto namo Nakafokafo ayaidana oto kamo kulika olu oloto pinagolowe. ");
INSERT INTO snp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kamo mikau-mikau wenena muki kiyabani we fulo nedanimo ya wenena olu mau wi gedeto nomageto, namodo amo wenena ya kofawa minowa-minowa enawamo mona olu oloto pi giminane, loto lonomanima ne. ");
INSERT INTO snp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ido kofawa minowa-minowa enawamo monawa ya etito ne, Kamo Goti ona kula lawoko ido namo Yesu Kilisto nilifi melageto omo we ya lamoki kutifi ledenawamo ya omuni kofawa minowa-minowa oti minenagilae. ");
INSERT INTO snp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ena lono ka lonomanima oluto olu fuli loto ya mikalo ya kulika olu oloto piyowe. ");
INSERT INTO snp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yamu Menefone, mika ama oloto piyámami kamenalo ya kamote kosinau kulite akaiya dito nemo yamaidana oto oiya ama ya kamoki minoneto ya kofa olu itibi nomageto olu minenae. ");
INSERT INTO snp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ena mikalo wenena yauti olu mau wi gedeto nomageto namodo amo wenena ya kulika lo oloto pi gimomo ne. Ya wenena kamo wenenaka minamo ya namo nomanimo ne. Ido kamo kaka ya koli kiki loti meyalo meleti ");
INSERT INTO snp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ya neta-mata muki nomanimo ya kamodoka yatiko mino nedami yama oiya ya kolife lo minae. ");
INSERT INTO snp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kamo ka lonomanima ya logimoneto koliti olu minae. Etiti ya kamodokati lomomo yama kolife loti ido kamo nilifi melanimo yama koli kiki lae. ");
INSERT INTO snp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Namo wenenawa yamu kolito lokomowe. Mika ama wenenala yamu oto lokomámowe. Nomanimo yama kaimo wenenaka kula minamo yamamu amomu kolito lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Namo wenenane muki ya kamo wenenaka kula minae. Ido kamo wenenaka yaki ya namo wenenane kula minae. Ido amo lunigu yau namo kuline olu oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Namo mikaleka minomo fuli lotainako, amo yako mikaleka minato, namo ya kamodoka enagolo ya owe. Felegaga Menefo, lalimo lute lawoko meleto mino-mino o minomi ya amote ayaidana oti luni lawoko meleti minenawae, loto kamo kulika nomanimo yamakafo kiyaba o gedo. ");
INSERT INTO snp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Amodoka mino gedomo ya kulika nomanimo yakafo kiyaba o gedoneto ma u kopa áumamo ne. Lowa eba nomilipala lawoko yako u kopa wido ya ka mono lufuwau nemo ka ya ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ido ama ya kamodoka dinae, loto namo sene-mulune lalo kolomo yamakafo amo seni-mulunigu dito faitenaiye, loto mikalo ama minoto kawa ya lowe. ");
INSERT INTO snp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ena namokafo kaka ya logimoneto olu minato, namo monane ya mika ama wenenala monani yaidana oto minámainako, amo yaki ayaidana oti monani ailo melanako, mika ama wenenala yate koli nosámami gimi-gimi o minae. ");
INSERT INTO snp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kamo mikalekati gilimo, loto ádowe. Nosámami aboga ya olu kopa o gedetenaiye, loto kiyaba o gedo, loto lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mika ama wenenala mikaleka mona melamo yaidana oto namo melámonako, amo yaki ayaidana oti mikaleka mona melámae. ");
INSERT INTO snp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kamo ka ona kula yakafo ukani-ouni-lunikani olu felegaga o gedo. Kamo ka lanimo ya ka ona kula ya ne. ");
INSERT INTO snp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kamokafo lono ka lonumuto mikaleka nilifi melanimo yaidana oto lono ka logimito mikau-mikau gilifi melomo ne. ");
INSERT INTO snp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amo ya ka ona kula olamo yakafo ya ukaniouni-luni-kani olu felegaga itenaiye, loto nanimo ya amomu kolito ukane-oune-lune-kane olu felegaga itowe. ");
INSERT INTO snp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ena namo ya wenenawa yamuko kolito lokomámowe. E’e, ka mono logimato koliti koli kikito numumo dinawamo wenena muki yamuki kolito lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amo ya luni lawoko mele gedo, loto lokomowe. Menefone, kamo ya namo luneu minanimo ido namo ya lukau minomo yaidana oti amo ya lalimo luteu minenawae, loto kolito lokomowe. Eti ato, mika ama wenenala yate kaimoka nilifi melageto lomomo yama koli kikitenawae, loto kolito lokomowe. ");
INSERT INTO snp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Lalimo lute lawoko meleto mino-mino o minomi yaidana oti amo ya luni lawoko meleti minenawae, loto ya kulite dinami mona nomanimo yama gimomo ne. ");
INSERT INTO snp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Namo lunigu minoneto, ido kamo luneu minageto, amo luni kutifiti u lawoko wato, mika ama wenenala yate kaimoka nilifi melageto lomomo yama kolife lenawae. Ido kamo ya sekamuluga nomanimo yamaidana oto gimi-gimi o minane, loti yaki kolife lenawae. ");
INSERT INTO snp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ena Menefone, nomanimo wenena yama namo minenado minenawae, loto kolowe. Mika kosina apito oloto piyámami kamenalo ya sekamuluga numuto kosina lamena nomanimo yama lalimoki minoti eye lalo melenawae, loto kolowe. ");
INSERT INTO snp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Menefo efe limo mona aboga, mika ama wenenala yate kamo keyefe ádafa, nanimo ya moda keyefe lo minoneto, ido wenenawa yate kaimoka nilifi melageto lomomo yama kolife lo minae. ");
INSERT INTO snp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Namo kaka kuka lo oloto pi gimitomo, ya moda logimitoko minenagolowe. Kamo sekamuluga nomanimo mona yama mino gedenami, ido nanimo yaki lunigu mino gedenae, loto kaka kuka logimitoko minenagolowe, loto ya Goti loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ena Yesukafo ya Goti loumu fuli loto ege-ege moinamo weki lokoina numudoti lumuti no kefola ma kuliya Kidiloni ya kiliti yá kiniba ma nedo yalo ya wae. ");
INSERT INTO snp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wado yalo ya Yesu ya ege-ege moinamo we yaki kamenakamena mau wi-wi ato, kuwolafo anido melenami we Yudasi yaki komu ebawa ya eyami ne. ");
INSERT INTO snp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ena yalo minato, ya Yudasikafo gamani kimiwe yaki ido Goti yokila ki umamo we kiyabani we ido Falisi we kimiweni yaki gilimito amo minadoka wito lumuti lamu-feiyati kiti kefaafaki oluti wae. ");
INSERT INTO snp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wato, ena Yesukafo neta-mata o edenawamo neta ya koli fuli loto ya yá kiniba kanu welalo ya uto geyeto eti limo, Linate kema moni wili minae? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","amote itibiti loumamo, Nasalete numudoti we Yesu moni wilone, loti loumato, Yesukafo limo, Namo ama ya minomo yae, loto logimaito, ido kuwolafo anido melami we Yudasi yaki minagu ya minaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ena Yesukafo, Namo ama ya minomo yae, loto logimami, ya eleigiti gegekati uti lumu fou lae. ");
INSERT INTO snp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Eti ato, kofa loga o gedeto limo, Linate kema moni wili minae? lito, amote Nasalete numudoti we Yesu moni wilone, lato, ");
INSERT INTO snp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesukafo ka itibito logimami, Namo ama ya minowe, loto logimomo ya namomu moni wilitima ya ama minamo we ya koito gedalo, lito, ");
INSERT INTO snp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","eti amo yamu komu ya eti loto limo, Nomanimo wenena yama kiyaba o gedoneto ma u kopa áumamo ne, loto komu limo ka yama ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ena Saimoni Pitakafo ya emi fana olu minami ya ika oto yokila ki umamo we kiyabani we naba kouba-nabala we kuliya Malukusi ya kala onaleka ya fuko fulitaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Eti ito, Yesukafo Pita eti loto loumami, Emika ya owolau ya koilo. Keinawa ya Menefokafo nomami yama olámenamo nefe? loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ena gamani kimiweki, kiyabani we wenabani yaki, ido Yuda wenena yauti felegaga kuliyai numuna naba kimiwe yaki ya Yesu oluti nela wi edeti ");
INSERT INTO snp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasi nedo ya ilimiti wae. Ena Anasi olulafo olami we Kaiyafasi ya melege lawoko ayau ya Goti yokila ki umamo we kiyabani we wenaba minainako, yamu Anasi nedo ya ilimiti wae. ");
INSERT INTO snp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafasi yakafo komu Yuda we eti loto logimami, We lawoko ma lamomu oto fulunami ya lalo minenagolone, loto logimitami ne. ");
INSERT INTO snp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ena Saimoni Pitate Yesu ege-ege moinami we mate ya Yesu ilimiti wado ege ya waiye. Wami ege-ege moinami wewa ya yokila ki umuumu amo we kiyabani we wenaba yakafo eye minami nenako, Yesu ege uto numuna kilalau ya lako idaifa, ");
INSERT INTO snp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ya kila welalo feka ya nedi minaiye. Nedi minaito, yokila kiyamo we kiyabani we wenaba eyami wewa yakafo lumuto kila welalo kiyaba imo nomili ya loumaito Pita kanu wi edaito, kila lulauka ya idaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Idaito, kanu kiyaba imo nomiliwa yakafo Pita eti loto loumami, Kamo ya we youma ege-ege moinamo we yauti ma minabemo? lito, ya E’e, namo minámowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Eti lito, ya kouba-naba we ido felegaga kuliyai numuna naba kimiwe yate epe fuluti yo kiti labi minato, Pita yaki lakoina nedi minoti yo labi minae. ");
INSERT INTO snp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ena yokila ki umamo we kiyabani we wenaba yakafo Yesu ege-ege moinamo we yaki ido ka mono lo-lo imo ka yakimu loga-miga o edaito, ");
INSERT INTO snp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesukafo ka itibito loumami, Namo ya mono numunigu ido felegaga kuliyai numuna nabau ya Yuda wenena mau witi minado ya wenena muki ka oloto logimito, api gilibi-gilibi omoma ne. Ka falukuto ya ma ádowe. ");
INSERT INTO snp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yamu nedito namo loga o nedane? Kane logimoneto kolamo wenena ya loga o gede kae. Amo ya ka logimi-gimi omo ka ya moda koli minamo ne, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Eti lito, felegaga kuliyai numuna naba kimiwe minagu yauti makafo Yesu ofoto ya eti limo, Kamo yokila ki umamo we kiyabani we wenaba ya ka yaidana ya nedito loumane? lito ");
INSERT INTO snp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesukafo ka itibito eti loto loumami, Ka nosámami loneyama ya monawa lo oloto melo. Ido ka lalo lenamo ya nedito nofane? loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Loumaito, Anasikafo logimaito, Yesu ana nela witi yokila ki umamo we kiyabani we wenaba Kaiyafasi nedo ilimiti wae. ");
INSERT INTO snp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ena Saimoni Pita ya yo labito nedi minaito, loga o edeti lamo, Ege-ege moinamo we minagumati kamo ya ma minabemo? lato, ya amokafo, E’e, namo minámowe, logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Logimaito, yokila ki umamo we kiyabani we wenaba kouba-nabala we yauti ma Pitakafo ofoto kala fuko fulitami we yama wenenalakafo eti loto loumami, Aiyo, kamo yá kinibauma amoki lako minageto keyoma nenae, lito ");
INSERT INTO snp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitakafo kofa, E’e, lito ayalo ya okolofokafo nola liye. ");
INSERT INTO snp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ena ko lo falatito Yesu ya Kaiyafasi negu yauti ilimiti lumuti gamani numudo ya wae. Uti Yuda wenena yate Goti omunalo ya sete-mulude olu fuma wito Goti Elita O Gedami foliwau ya wete-neta ánotenune, loti gamani numunau ya idámoti feka ya minae. ");
INSERT INTO snp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Feka minato, Pailatikafo ayalo lumuto loga o gedeto limo, We ama ya nena lifimala nemomu ya ilimiti ae? lito, ");
INSERT INTO snp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","wenena yate ka itibiti eti loti loumamo, Amo ya nosámami mona melámami neko, kamo minanido ya ilimito ámogi ne, lae. ");
INSERT INTO snp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Eti lato, Pailatikafo eti loto logimami, Linanimotina oluti lo melamo katinau yati lifimala olu umalo, lito, Yuda wenena yate eti loti loumamo, Lamo wenena lifimani olu gimito gini folámenawamole, loti lo fuko ledetama ne, lae. ");
INSERT INTO snp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eti loti lamo ya Yesu fulunami kanu aimolakafo ka komu lo oloto gimitaidoma ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ena Pailatikafo gamani numugu ya itibito dito Yesu ilimiti alo, lito ya koliti ilimiti ato, ya loga o edami, Kamo ona Yuda wenena kiyabani we wekudi minabe? Olo, lito, ");
INSERT INTO snp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesukafo itibito limo, Ka ya kaimoka kakaloti labemo, ido wenena mate namomu eti lokomato kolito lane? loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Loumaito, Pailatikafo itibito limo, Namo ya Yuda we minámowe. Kaimoka wenenaka ido yokila kiyamo we kiyabani we yate namo minodo ya kilimiti amo ya kamo nedi ageto kilimiti ae? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Loga o edaito, Yesukafo ka itibito eti loto limo, Namo ama mikaleka wenena wekudinina ya minámowe. Mikalo wenena wekudinina minomo neko, kouba-nabane we yate namo ane olu faka loti Yuda wenena yate nela fi nedetenawae, loti lowa fi gimagi ne. Nefa, namo wenena kiyaba o gedomo monane ya mikaleka wenena wekudinina kiyaba o gedamo mona yaidana oto minámaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ido Pailatikafo eti loto loumami, Kamo wekudi ma minabe? Olo, lito ya Yesukafo ka itibito limo, Moda ya lanimo yae. Namo wekudi minoto ya ka ona kula lo oloto pi giminae, loto mikaleka lumuto oloto piyomo ne. Yamu ka ona kula kolife lamo wenena ya namo kane yaki kolife lae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Loumaito, Pailatikafo eti loto loumami, Ka ona kula ya nena neta ne? loto ya liye. Pailatikafo eti lototo kofa feka ya uto Yuda wenena minado lumuto eti loto logimami, Namo we ama ya lifimala moni wilofa, olu oloto piyámowe. ");
INSERT INTO snp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Monatina ma etito nemo, Goti Elita O Gedami folilo linate lonomado ya namo nelalo minamo we yauti ma ya efili edowe. Monani etiti melamo yamu onema ama ya linate Yuda wenena kiyabani we wekudi efili edoneto fa mino ledenaiye, loti kolafemo? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Loga o gedaito amo yate kofa eti loti auma witi lamo, E’e, ama we ya minámaiye. Balabasi ya efili edo, loti lae. Eti lamo we Balabasi ya wenena ginito netani-matani ipoto olu-olu imo we ne. ");
INSERT INTO snp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ena Pailatikafo logimaito, kimiwe yate Yesu yafo atuwa kaila lelelimo ipi yakafo ofoti, ");
INSERT INTO snp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","kefani kailakafo kokamu olufe loti manenalo ya aumawai kolouto wi edeti, ukanalo owo fana kisi limo yaki wi edae. ");
INSERT INTO snp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Etiti ya amo nedo oti, Aiyo, siyane, Yuda wenena kiyabani we wekudi, siyane, loti anikafo aumawai ofae. ");
INSERT INTO snp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ena Pailatikafo Yuda wenena minado ya kofa lumuto eti loto logimami, Eyalo. Namo linatedoka ilimito lomomo ya lifimala moni wilofa, olu oloto piyámowe, loto logimomo ya kolalo, liye. ");
INSERT INTO snp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lito, ya Yesu kokamuwa kaila imo wi edamo ido owo kisi limo yaki wiyami lomaito, Pailatikafo gilibito ya, We ama ya eyalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Logimaito, yokila ki umamo we kiyabani we ido felegaga kuliyai numuna naba kimiwe yaki eyeti ya, Yá yofolo ofo! Yá yofolo ofo! loti ka auma witi lato, Pailatikafo eti loto logimami, Namo lifimala moni wilofa, olu oloto piyámonako, linate linanimotina oluti uti ya yá yofolo ofalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Logimaito, Yuda wenena yate ka itibiti eti loti loumamo, Amokafo namo Goti Nalafo minowe, loto aimola yamu lo-lo o minami ya wenena yaida lenawamo ya fulunawae, loto lo melami kateu ya nemo ne, lato, ");
INSERT INTO snp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailati ya kolito koli naba kolaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Koli naba kolito ya Yesu ilimito gamani numugu kofa dito loga o edeto limo, Kamo egalekati animo ne? lito ya Yesukafo ka itibito loumámaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ka itibito loumámaito, Pailatikafo eti loumami, Ka lonomámanimo nefe? Namokafo efili kedenawae, lenamo ya efili kedenagilae. Ido yá yofolo kofenawae, lenamo ya kofenagilae. Yaida mona muki ya namoko kiyaba oma ne. Ya ma kolámabe? loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Loumaito, Yesukafo ka itibito eti loto loumami, Akaiya nemo we yakafo auma komámami neko, kamo auma wito namo olu afima o nedámagi ne. Yamu ya wenena kamodoka nilimiti amo wenena lifimanikafo kamo lifimaka olu fulo edeto ne, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Eti lito, Pailatikafo kawa ya kolito Yesu efili edenae, loto kolaifa, Yuda wenena yate eti loti auma witi lamo, Kamo we ya efili edenanimo ya Sisa kafuwalo we minámenagolane. We makafo kiyaba we wenaba minowe, lenami ya Sisa olu afima o edenae, loto ya liye, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Eti loti lamo ka ya Pailati ya kolito logimaito, Yesu ilimiti lomato, ka lo onowa mele-mele imo folomolo ya amedoto minaiye. Ebawa ya Kifanakafo Olufe Lamo Ebale, loti kuliya melamo ya Yuda wenena kanidokati ya Gabatale, loti kuliya melae. ");
INSERT INTO snp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ena Yuda wenena Gotikafo Elita O Gedami foliwa neta-mata olufe lenawamo kamena ya neto, ya belo alitito ya Pailati folomolo ya minoto Yuda wenena eti loto logimami, Linate wekuditinama ama ya eyalo, lito, ");
INSERT INTO snp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","amo yate eti loti auma witi lamo, Ilifi fulo! Ilifi fulo! Yá yofolo ofo! lato, Pailatikafo eti loto logimami, Aiyo, wekuditina yá yofolo ofoneto fulunaiye, loti lo minafe? Olalo, lito yokila ki umamo we kiyabani we yate ka eti loti itibiti loumamo, Lamo wekudite Sisa lawokomako nema ne. Ma minámamo ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eti lato, Pailati kolito Yesu yá yofolo fulunaiye, loto fulo anigu itaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ena kimiwe yate Yesu oluti yá yofo olu umato moufaito, mika ma kuliya Ateni Aumale, loti melamo, ya Yuda kalekati kuliya Gologotale, loti melamo, yalo ya ilimiti uti ");
INSERT INTO snp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","yá yofolo ofamo, ya we lele ma lakoina ginamo ya ma ya ofo filigaleka iti, ma ya ofo filigaleka iti, ido Yesu ya ofo muliti ya itae. ");
INSERT INTO snp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ena Pailatikafo lito ya yá yofolo Yesu atela mulalo ya eti loti lufuwa wiyamo, Nasalete we Yesu ya Yuda wenena kiyabani we wekudi ne, loti wiyamo, ");
INSERT INTO snp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ya Yuda ka ido Lomu ka ido Giliki ka tili (3) yalekati wiyato, Yesu ofamo eba ya adu numudo nenako, Yuda wenena so loti ayalo uti oti amo yate lufuwawa ya katae. ");
INSERT INTO snp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Etiti katato, Yuda wenena yokila ki umamo we kiyabani we yate uti Pailati eti loti loumamo, Kamo Yuda wenena kiyabani we wekudi ne, loto lufuwa wiyanimo ya fulito. Aimolakafo namo Yuda wenena kiyabani we wekudi minowe, loto limo we ne, loto wiyo, lato, ");
INSERT INTO snp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailatikafo ka itibito logimami, Lufuwa wiyomo ya moda witowe, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ena kimiwe yate Yesu yá yofolo ofoti ukanalo owo olamo ya u fo (4) wito iya meleti olafa, ukanalo owo lulau ya yalekati owo omo waka lomamo kifamo yaidana oti kifámamo ");
INSERT INTO snp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","yamu ya eti loti lokoli-fakoli amo, Ya fekailámoto mele muliti ito noka kedeto melafo makafo olu fulo ledenami ya olunaiye, loti ya eti amo yamu ka ma mono lufuwau ya eti loto limo, Amo yate ukanelo owo iya mele oluti ma luma nemo ya noka kedeti olae, loto ka mono lufuwau (Sng 22:18) nemo ka ya ayalo kulawa fedaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ena Yesu olafole kunalafole, Kolopasi olonafo Maliale, lilafo Madala numudoti wena Maliale Yesu yá yofola monau ya nedi minae. ");
INSERT INTO snp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ido Yesukafo olafoki ege-ege moinami we siyamuluna umami weki adu nedi minami ya geyeto olafo eti loto loumami, Wenao, nakafo auwa ya ne, loto, ");
INSERT INTO snp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ido ege-ege moinami wewa eti loto loumami, Okafo ya ne, lito ya kamena yaloti ya aimola numunau ilimito uto kiyaba o edemo wiye. ");
INSERT INTO snp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ena Yesukafo lonola fuli limo ya kolito mono lufuwau ka ma nemoma ya kulawa fedenaiye, loto ya Kenebane apaitaiye, lito ");
INSERT INTO snp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","no waini ekefa imo ma nomuku negu yau ya kuwo nokuti noi aila yaidanakafo ekefa imo noku yau fiti oiyo umalo ya welau wiyato naiye. ");
INSERT INTO snp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Noto ya Moda fuli lotaiye, loto manena olu kuba wito ouna ilifi meleto folaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ido aya kamenalo Yuda wenena Goti Elita O Gedami foliwa neta-mata olufe lenawamo kamena neto, ido leda ya Sabati foliwa naba nenako, wenena yá yofolo ginamo ya kono ukani ya yá yofolo fa minenami eleka lofaiye, loti Pailati eti loti loumamo, Kimiwe yate kiyani auma leketi kono ukani ya ikiliti oluti unawae, loti loumato, ");
INSERT INTO snp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","O, lito kimiwe yate we lele Yesuki ginamo ya ma kiyana auma leketi, uti ma kiyana auma lekae. ");
INSERT INTO snp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Leketi uti Yesu ofado ya uti moda fulutami ya eyeti kiyana auma lekámae. ");
INSERT INTO snp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lekámafa, kimiwe makafo yofalau ya kiyakafo magala ofaito, wanuki noki ayauti lomaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","Eti o edamo yamu eti limo, Aumala ya lekámenagilae, loto ka mono lufuwau (Sng 34:20) ya nemo ne. Ido ka ma eti limo, Amo yate magala ofamo we ya eye minenagilae, loto ka mono lufuwau (Sek 12:10) nemo ka ya kulawa fedenaiye, loto netawa ya oloto piyaiye. Ena netawa lufuwa wiyami wewa netawa ya aimola omuna kulakafo eyami nenako, lo oloto melomo ya ona lowe, loto koli minaiye. Kawa ya ona kula ne. Yamu ya linate yaki koli kikitenawae, loto lo oloto melaiye. ");
INSERT INTO snp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ena Alimatea numudoti we Yosefe ya Yesu ege melami we minaifa, Yuda wenena kolini kolito lo oloto piyámoto monala mele falukuto meleto moni minami yakafo Pailati nedo ya uto Yesu kono ukana ikilito oluto unagolowe, loto loumaito, Pailatikafo, O, lito uto ikilito oluto wiye. ");
INSERT INTO snp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Eti ito, Nikodemusi yaki komu Yesu nedo luwaila wimo we yakafo yá nowala ladanuwa imo neta lele ma kuliya mulu yaki ma kuliya alo yaki olu lawoko ito keinala teti (30) kilogilamu yaidana oto ya futuwai oluto uto Yosefe ana olu faka lito ");
INSERT INTO snp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yesu kono ukanalo ya yá nowala fili edeti owo lafo-lafo kiyobakafo asa wi edami ya Yuda wenena yate wenena folamo ya eti o gede-gede ae. ");
INSERT INTO snp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ena Yesu yá ofolo ofado filigaleka ya yá kiniba ma negu yau kifana lula ma kono ukana melenune, loti uwaitagu ya wenena ma mele gedámamo kofawa negu ");
INSERT INTO snp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ya Yuda wenena Sabati foliwa neta-mata olufe lenawamo kamenawa nemo yamu koliti eba adu yau ya Yesu kono ukana ya mele edaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ena Sabati foli fuli lito salele komu kamenalo leda luwaila ko ádaito Madala numudoti wena Malia ya kono ukana melamo ebalo ya u fedeto eyami ya kono melamo kifana lula welaloti kifana naba ya u ailo uto, kanu godo minaito, ");
INSERT INTO snp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","eyeto oluloto uto Saimoni Pitate Yesu ege-ege moinami we siya-muluna umami wete eti loto logimami, Wekola kono ukana oluti utanako, egauka melafe? Lamo ma kolámone, liye. ");
INSERT INTO snp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Eti lito, Pitate ege-ege moinami wewa yate kono melado ya unaliye, loti ");
INSERT INTO snp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","oluloti wami ya ege-ege moinami we mamamo Pita olu aiga edeito u komu u fedeto ");
INSERT INTO snp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","lulau ya idámoto ya kuba wito kami ya owo lafo-lafo kiyobakafo asa wi edamo yako neto kaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Etito ko minaito, Saimoni Pitakafo aiga u fedeto lulau dito ya owo kiyoba ya neto koto ");
INSERT INTO snp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ido manenalo asa wiyamo neta ma owo kiyobaki ekeleto minámoto ailo fele iya fi minaito ya eyaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eyaito ya kono melado komu u fedami we yamaki ayaida oto dito eyeto ya koli kikitiye. ");
INSERT INTO snp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aya kamenalo ya Yesu folaiguti nedinagoliye, loto mono lufuwau nemo ka yama kolife ádamo ne. ");
INSERT INTO snp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ena kofa itibiti numunidoka waiye. ");
INSERT INTO snp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ena Malia ya kono melamo lega ya nedi minoto kufu oto, kanu welalo ya kuba wito kono melamo ebau ya kami, ");
INSERT INTO snp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","enisole lele ukanido owo kiyobaki Yesu mele edado ya amedoti minami ya ma ya manena nedoma neto ido ma ya kiyana nedoma neto ya geyaito, ");
INSERT INTO snp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","amo yate eti loti loumami, Wenao, nedito kufu o minane? laito, amokafo logimami, Wekolanema olumo egauka melafe? Kolámowe, loto ");
INSERT INTO snp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","olu eleyapa wito kami ya Yesu aimola nedi minami eyaifa, Yesu ne, loto eyefe ádaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eyefe ádaito, Yesukafo loga o edeto limo, Wenao, nedito kufu ane? Kema moni wili minane? lito ya amokafo ya yá kiniba kiyaba we ya ne, loto kala kito eti loto loumami, Wenabao, kamokafo olumo maleka meletoma ya lonomageto kolito uto oluto unafao, lito, ");
INSERT INTO snp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesukafo, Maliao, lito, amokafo olu eleyapa wito Yuda kalekati Labonai, loto loumami ka monawa ya api lilibanimo we, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Eti lito, Yesukafo eti loto loumami, Oiya Menefodoka idámomo yamu neyabusa wiyámo. Kunanefo-mota minado ya uto eti loto logimo, Namoki linateki Metefo ido Gotite nedo ya dinagolowe, liye, loto logimo, lito, ");
INSERT INTO snp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Madala wena Malia itibito oto ege-ege moinamo we eti loto lo oloto gimami, Namo Wekola eyetowe, loto, ido kawa loumami yama logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ena aya kamenawa ya Sade lunaga sinidito ege-ege moinamo we ya Yuda wenena kolini koliti numugu mau witi kanu ku kiki loito minato, Yesu ya kiliyanigu o fedeto nedi minoto eti loto logimami, You amene mona ya linatedoka mino gedenaiye, loto ");
INSERT INTO snp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ana leleki yofalaki ya gilibaito, ege-ege moinamo we ya Wekola eyeti seni-muluni lalo kolae. ");
INSERT INTO snp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ena Yesukafo kofa eti loto logimami, You amene mona ya linatedoka mino gedenaiye. Menefokafo namo nilifi melami yaidana oto namokafo linate gilifi melowe, loto ");
INSERT INTO snp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","wela-mula fulo gedeto ya eti loto logimami, Ouna Felegaga ya mino gedenaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Linate wenena lifimani kilili o gedenawamo ya moda ona kilili iye. Ido lifimani koito gedenawamo ya moda ona fa mino gedaiye, loto ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ena ege-ege moinamo we tuwelu (12) yauti ma kuliya Tomasi kuliya ma Didimusi ya ege moinamo we minagu ya minámaito, Yesu oloto pi gimaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eti inako, ege-ege moinamo we liliga yate loumamo, Wekola eyone, loti loumafa, eti loto logimami, Namo nanimo omunekafo koto anau nilikafo ofamo ya eyeto ane umakafo godigu loloi oto ido yofalau yaki anekafo loloi otomako ya koli kikitenae, loto ya liye. ");
INSERT INTO snp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ena fo kamena eiti (8) ya wito ege-ege moinamo we numugu ya kofa minamo ya Tomasiki lakoina minoti kanu ku kiki loito minato, Yesu ya kiliyanigu kofa o fedeto nedi minoto eti loto logimami, You amene mona linatedoka mino gedaiye, loto ");
INSERT INTO snp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasi eti loto loumami, Kamo aga umakafo aneu ya loloi oto eyo. Ido aga sino loto yofaneu ya olu kolo. Olu kolitoma ya kaka lele kiyámoto koli kikilo, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasikafo ka itibito eti loto loumami, Kamo Wekolane ido Gotine minane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Loumaito, Yesukafo loumami, Kamo neyaninako, koli kikitane. Namo neyámoti koli kikitamo wenena ya lalo kolitiko minenagilae, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ena neta kofawa aumala gilibami neta ma so loto Yesukafo ege-ege moinamo we omunido yalo ya olu oloto piyami neta ya lufuwau amau ya muki wiyámami ne. ");
INSERT INTO snp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wiyami efe uma ya eti loto wiyami, Linate katoti koliti ya Yesu ya Goti Nalafo ilifi melami we Kilisto ne, loti koli kikitenawae. Koli kikito umuti ya amo kuliyalo omudi kofawa mino gedemo dinagilae, loto wiyami ne. ");
INSERT INTO snp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ena kofa aiga ege-ege moinamo we Taibeliyasi nofudo ya minato, Yesu oloto pi gimami ya etito oloto pi gimami ne. ");
INSERT INTO snp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Pitale, Tomasi kuliya ma Didimusile, Galili mikalo Kana numudoti we Nataniyelile, Sebedi nalafo lele yaki ido ege-ege moinamo we yauti ma lele yaki etiti wenena yaleka minato, ");
INSERT INTO snp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimoni Pitakafo eti loto logimami, Namo laefalo moninae, loto unagolowe, lito, ya eti loumamo, Kamoki lakoina unune, loti sipiku ya diti uti moinamo ya luwaila yalo ya laefa ma olámae. ");
INSERT INTO snp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Eti ato, ko lenae, loto ido ya Yesu no akelo ya nedi minaifa, lebona eyámato, ");
INSERT INTO snp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesukafo eti loto loga o gedami, Nanefo-motao, laefa ma olafe? lito amote, Ma minámaiye, loti ka itibiti loumato, ");
INSERT INTO snp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","amokafo eti loto logimami, Owo ya fulo filiga sipi onaleka ya itenawamo ya olunagilae, lito owo ya fulo onaleka ya itato, laefa ya faitito ika o moinafa, ogoufámae. ");
INSERT INTO snp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yamu ya Yesu ege-ege moinami we siya-muluna umami wekafo ya Pita eti loto loumami, Moda Wekola ya nemo yae, loumaito, Saimoni Pita kawa kolito ukanalo owo ya kololoto meleito lono olaido yati kofa olu wito sipikuti nofugu ya satomo wito wimo ya ");
INSERT INTO snp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","no ake faiga minámami wani hadeti (100) mita yaidana oto neto wito, ido ege-ege moinamo we liliga ya noku fiyamo owoku ya laefa faitito sipiku minoti ika-ika oti oluti wae. ");
INSERT INTO snp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Uti olumo noku meleiti akelo ya lumuti kamo ya yo ligu ya laefati beletiti neto ya kae. ");
INSERT INTO snp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kato, Yesukafo eti loto logimami, Laefa olamo maleka oluti alo, lito, ");
INSERT INTO snp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimoni Pitakafo sipiku ya dito owo ya noku yati ika oto oluto ekela ami ya laefa naba-naba faitimo ya wani hadeti fifiti-tili (153) yaleka ya nemo nefa, owo ya fukámaiye. ");
INSERT INTO snp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ena Yesukafo eti loto logimami, Oti ledakonuma nalo, lito ya ege-ege moinamo we ya, Wekola ya ne, loti koli fuli lotanako, ya kamo kema minane? loti loga o edámae. ");
INSERT INTO snp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ena Yesu oto beletiti laefati oluto iya meleto gimaiye. ");
INSERT INTO snp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yawe ya Yesu folaiguti nedito ege-ege moinamo we oloto pi gimami ya kamena tili (3) oloto pi gimaiye. ");
INSERT INTO snp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ena leda-konuma notiti minado ya Yesukafo Saimoni Pita eti loto loga o edami, Yoni nalafo Saimoniyo, koinakafo-mota seni-muluni numu minamo we ya olu fulo gedeto seka-muluga nomabe? lito Pitakafo loumami, O, Wekolao, namo sene-muluneu ya kamomu kolomo ya neye minane, lito ya Yesukafo loumami, Sipisipine momola weni-neta gimo. ");
INSERT INTO snp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Eti loto kofa loga o edami, Yoni nalafo Saimoniyo, kamo ona seka-muluga nomabe? lito Pitakafo loumami, O, Wekolao, namo senemuluneu kamomu kolomo ya neye minane, lito ya Yesukafo loumami, Sipisipine ya kiyaba o gedo. ");
INSERT INTO snp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Eti loto kofa ma eti loto loga o edami, Yoni nalafo Saimoniyo, kamo ona seka-mulugau ya namomu kolabe? loto kamena tili (3) loga o edami yamu Pita siya-muluna keina ito ka itibito loumami, Aiyo, Wekolao, kamo neta-mata muki ya koli fuli lo minanimo wema minaninako, namo sene-muluneu ya kamomu kolomo yaki koli minane, lito ya Yesukafo loumami, Sipisipine weni-neta gimo. ");
INSERT INTO snp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Namo ona lema lokomowe. Kamo we kofawe minanimo kamenalo ya kimekati olufe loto wito kanu ma moninae, loto kolanidoka ya moni-moni anima nefa, ido aiga we kilofo meleto minenanimo kamenalo ya aga sino lageto, we makafo kime wi kedeto ma ámunae, loto kolinanimo ebaleka yaleka kilimito unami ne. ");
INSERT INTO snp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Eti loto limo ya Pita fulunami monawa yakafo Goti kuliya olu faka lenaiye, loto kolito liye. Eti loto ya Pita loumuto limo, Kamo oto nege-nege melo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eti loto loumaito, Pita ya oluwe oto Yesu ege-ege moinami we siya-muluna umami we gege wito eyami wewa ya komu Goti Elita O Gedami kobinawa nagu ya atela ya Yesu ikiyalo ya fuloto eti loto loga o edami, Wekolane, kemakafo kamo kuwokafo anido giminamimu lane? loto loumami we ");
INSERT INTO snp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ya Pitakafo eyeto Yesu loga o edeto limo, Wekolao, ama we ya nedi enami ne? loto loga o edaito, ");
INSERT INTO snp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesukafo eti loto loumami, Amo ya namo itibito enamo kamenalo ya faifa minenaiye, loto kolinamo ya kamo netaka nefe? Kamo ya faifa nege yako melo, loto liye. ");
INSERT INTO snp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eti limo yamu mono koinanibo liliga yate aiga ya eti loti lo oloto melamo, Yesu ege-ege moinami wewa ya folámenagoliye, loti lafa, Yesukafo ya folámenami ne, loto ádami ne. Faifa eti loto loumami, Namo itibito enamo kamenalo ya faifa minenaiye, loto kolinamo ya kamo netaka nefe? loto ya limo ne. ");
INSERT INTO snp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ena ege-ege moinami wewa yamakafo netawa-matawa eye fuli limo netaleka lo oloto meleto lufuwau amau ya wiyami we ya ne. Kawa ya lo oloto melami ya ka ona kula ne, loto koli minone. ");
INSERT INTO snp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ena Yesukafo neta-mata ma muki oto meleto imo yama ya egaidana oto lufuwau ya wi fuli lenumo ne? Muki lufuwau ya olu melonimo neko, lufuwa neta yamo uto mikaumikau faito fulitageto eba ma minámoto buku ma fa minagi ne, loto kolowe. Modae. ");
INSERT INTO snp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyofilusiyo, namo Luka moda komu lufuwa wi fulo kedogu ya Yesu oto meleto imo ka muki ya lono apito olumo uto uto, ka mono apito logimimo uto uto, ");
INSERT INTO snp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","olu kosinau dinagolo ya iya ku gedami we aposolo ya Ouna Felegaga welaloti ya ka lo mele gedetaito, ya Gotikafo ilimito kosinau idami kawa muki yamu ya moda lufuwa wi kumutomo ne. ");
INSERT INTO snp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesukafo ukana ogofu naba-naba kolitoto aposolo wenenalawa minado ya fedeto, wenena yate omune kofawa ne, loti koliti kani ligi-ligi kiyámenawae, loto mebe-maba mumudi ya olu oloto pi gimaiye. Olu oloto pi gimito kamena foti (40) ya mikalo minoto Goti kiyaba we wekudite kiyaba o ledami ka logimimo wiye. ");
INSERT INTO snp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kawa logimimo uto kamena ma lakoina weni-neta no minado yalo lo melami etito gimami, Linate Yelusalemu ya fulámoti, Menefo neta giminae, loto lo mele gimami ya logimomo ya kiyaba o minalo. ");
INSERT INTO snp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yamu Yoni ya nokafo noku wi gedaifa, ido fo kamena maleka wageto yalo linate Ouna Felegaga yakafo noku wi gedenagolowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Logimaito, ido mau witi minado loga o edeti lamo, Wekolao, Isilaeli wenena kofa olu auma wi lumuto kiyabate we wekudi lono olunabe? loti loga o edae. ");
INSERT INTO snp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Etiti loga o edato, Yesukafo itibito logimami, Linate Metefo aimola aumalalo netawa fedenami kamena melami ya kolinuwe, loti lafa, ido fedenami kamenawa ya netatina minámaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","E’e, netatina minámaifa, ido Ouna Felegaga ya mino gedaido yalo auma ya gimaito oluti uti Yelusalemu numudo, ido Yudia mika negu-negu, ido Samalia mika negu-negu, ido luwa-lawa mika faiga negu yaki kane kune ya lo oloto gimimo unagilae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eti loto logimaito, Gotikafo omunido olu faka loto ilimito kosinau idaito, limukafo faluku o edaito ya ogofuti eyámae. ");
INSERT INTO snp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ogofuti eyámoti kosinau akawa auma witi kogo ko minato, we lele ukanido owo feke wiyami ya kaita minadoka oti nedi minaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nedi minoti eti loto logimami, Galili wenenao, nediti amalo ya nedi minoti kosinau kogo ko minae? Wewa Yesu ya linatedokati ilimito kosinau idami ya itibito mikalo enami kamena ya kosinau wito eyamo yaidana oto itibito enagoliye, loti laiye. ");
INSERT INTO snp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Eti laito, ya minamo mowa Olifi ya fuliti lumuti kilomita lawoko yaidana uti Yelusalemu numudo ya itibiti wae. ");
INSERT INTO snp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Itibiti u fedeti numuna ma mulalo aifa nedo diti minomo wae. Minamo wenena ya kulini etito ne: Pita, Yoni, Yemusi, Adulu, Filipi ido Tomasi, Batolomiu ido Matiu, Alifiusi nalafo Yemusi, Saimoni kuliya ma Seloti, ido Yemusi nalafo Yudasi yaleka we ya minae. ");
INSERT INTO snp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Etiti wenena muki mau wi-wi amo yaki, Yesu kunalafo-motaki, olafo Maliaki, ido wenaipamaki muki seni-muluni lawoko meleti minoti Goti loumumo wae. ");
INSERT INTO snp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ena kamena yalo koli kikitamo wenena wani hadeti tuwedi (120) ya mau minagu ya Pitakafo omunido nedito ");
INSERT INTO snp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","eti loto logimami, Mono wenenane-motao, kolalo. Yudasikafo Yesu ya kuwolafo-mota gilimito oto anido gimami we kala ya adeina afimaleka Ouna Felegagakafo Defiti welalo ka ya melami kama oiya u ayaloma wiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ido Yudasi komu lamoki lakoina ekeleto minoto mono lono olumo wone. ");
INSERT INTO snp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Etito nefa, wewa mona nosámami melami, meinala umamo yakafo mika ma meina fito aya mikalo ya lumu fou loto, muluna poloka kito siya-mulunau neta muki feka aito folaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Folaito, Yelusalemu numudo minamo wenena muki ya kawa koli fuli lamo yamu folami mikawa ya kuliya Akeldamale, loti melamo katelokati monawa ya Wanu Leikami Mikale, loto ne. ");
INSERT INTO snp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yamu mono lufuwa bukuku Mono Nema yau eti limo, Numuna ya lupa minageto wenena ma yau minámenagilae, loto ka mono lufuwau (Sng 69:25) ya nemo ne. Ido maki ya eti limo, We ma yakafo kiyaba we lonola ya olunami ne, loto ka mono lufuwau (Sng 109:8) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Etito yamu Wekolate Yesu ya folaiguti kofa nedami kala ya lo oloto melenami we ma lamo minonigu yauti Yesu lamoki minami kamena muki yalo lakoina moni-moni ami we ma iya ku melokele. ");
INSERT INTO snp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Wewa olu oloto pinumo ya Yonikafo noku wi gede minaido yaloti uto Yesu lamodoka ilimito kamenalo kosinau idami ya eye fuli lonimo wemomo yaumati we ma iya ku melokele, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eti logimaito, we lele ma ya ma kuliya Yosefe kuliya lele ma Basabasi ido ma Yasitusi, ido we ma kuliya Matiyasi ya olu oloto piyamo ne. ");
INSERT INTO snp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ido mukite Goti eti loumamo, Wekolao, wenena muki sete-muludeu ko-ko animo we kaimokafo Yudasi lonola fulitito aimola kanulalo uto u kopa wimoma nenako, yamu we lele yauti lawoko ma iya ku edanimo we ya ebala olunami wewa lilibo, loti loumu minae. ");
INSERT INTO snp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eti loumutiti mau minamo ya noka kedeti Matiyasi kuliya ya oloto piti, aposolo minenaiye, loti lato aposolo leweni (11) minagu ya ekeleti minae. ");
INSERT INTO snp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ena foli felegaga kamena ya kuliya Pentikosi fedaito, eba lawoko nedo yalo koli kikitamo wenena muki mau minae. ");
INSERT INTO snp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mau minato, kaita nola ma kosinauti epe naba-naba fu-fu limo nola yaidana oto limo ya numugu yau amedoti minamo muki ya kolae. ");
INSERT INTO snp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kolato, neta ma yo kuluma yaidana oto oloto pito netawa ya poni-poni loto wenena numugu minamo muki ya ukanido lomaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ukanido lomaito, ido muki ya Ouna Felegaga yakafo mino gedeto seni-mulunigu faitoto, luwa-lawa ka mona-mona lenawae, loto auma gimaito ya ka mona-mona lomo wae. ");
INSERT INTO snp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ido aya kamenalo Yuda wenena Goti koliya kolamo ya mikau-mikau Yelusalemu yati numudoka oti yalo minae. ");
INSERT INTO snp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aya wenenawa yate ka lamowa ya koliti yamu mau minamo muki yate wenenawa inanimoni kani yama loti lato kolanako, yamu moda elegi minae. ");
INSERT INTO snp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Elegi minoti kani ligi-ligi kiti loga o gedamo, Ka lo minamo we muki ya Galili wenena minafe? Olo. ");
INSERT INTO snp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ya egaidana oti lalimote kate ona ya weniguti lamo ya otefo metefote lolomamo yaidana oto kolone? ");
INSERT INTO snp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ido lalimo muki minonimo ya Patia wenena, ido Midia wenena, ido Elamu wenena, ido wenena ma Mesopotemiakati, ido Yudiakati, ido Kapadosiakati, ido Pontusikati, ido Esiakati, ");
INSERT INTO snp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ido Filigiakati, ido Pamufiliakati, ido Isipikati, ido Libia ebaukati Sailini adu nemo wenena, ido Lomu wenena oto amau minonimo yaki ");
INSERT INTO snp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","maleka Yuda wenena ona minone. Ido maleka wenena ailo-ailo oto Yuda wenena monani olonimo yaki, ido lalimo ya Kiliti wenena, ido Alebia wenena etito ya minoba, ido Gotikafo auma wiyami neta lalo olufe lito amo yamu lalimote katelokati lato moda kolife loto koli minone, loti minae. ");
INSERT INTO snp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eti loti eleigiti kani ligi-ligi kiti inanimo loga o gedamo, Netawa kolonimo ya monawa ya nena ne? loti loga-miga ae. ");
INSERT INTO snp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Etiti loga-miga ato, wenena malekate eti lamo, No waini muki ya noti kani-manini u kopa wito minae, loti kiya o gedae. ");
INSERT INTO snp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ena Pitakafo Yesu lonodo we leweni (11) yaki minadoti nedito, wenena mau naba minamo au naba loto eti logimami, Wenenane-motao, Yuda wenena minamo ido linate Yelusalemu ku onamo wenena muki kawa kolamo monawa fokito logiminagolowe. Ka logiminamo ya kani kiti kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Linate ya wemomowa ya no waini noti kani-manini u kopa wae, loti kolafa, ido etito minámaiye. E’e, oiya uma ya leda naini (9) kiloku yaidana otoko nenako. ");
INSERT INTO snp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Netawa yamu polofete Yowelikafo eti limo, ");
INSERT INTO snp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Gotikafo eti limo, Kamena naba alitenami kamenalo Oune ya wenena muki mona-mona ya gimoneto, natibo-mota ido olutibo-mota kane lo oloto melenagilae. Ido linate we kofaweti ya famo yaidana oti ya eyenagilae. Ido we kilofo-akilofo yaki famo kula eyenagilae. ");
INSERT INTO snp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ido aya kamenalo kouba-nabane we wena Oune ya gimoneto kane ya lo oloto melenagilae. ");
INSERT INTO snp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ido kosina akawa yaki mebe-maba ma gilibito ido mikalo umalo yaki namo aumane gilibomo neta ya wanuti, ido yoti, yokila nabati ya gilibinagolowe. ");
INSERT INTO snp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gilibinamo ya fo ádoto ido ikana ya olu wanu yaidana lafa lenagoliye. Etito lenaido yalo ya Wekola kamenala naba ido lamenala ya oloto pinami ne. ");
INSERT INTO snp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ido Wekola kuliyalo lula finawamo wenena muki ya olu omuni kenami ne, loto ka mono lufuwau (Jol 2:28-32) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ido linate Isilaeli wenena kawa koli minalo. Nasalete numudoti ami we Yesu ya Goti aumala lilibami neta mona-mona yaki, ido mebe-maba yaki, aumala nabaki olu oloto pi gimami ya Gotikafo ilifi melomo we ne, loti kolinagilae, loto etito amokafo mino edaito, netawa ya omunido olu oloto pi gimaito, linanimote netawa ya moda koli minae. ");
INSERT INTO snp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Adeina afimalekati Gotikafo wewa yama ya linate anido melenae, loto kolito kala lalo kiyaito, linateki ido ka koliti kolámoti amo we yaki ana-kiyanalo oluti yá yofolo ofoti folae. ");
INSERT INTO snp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ofoti folafa, ido folami mona yakafo nela wi edenami ya ogoufámainako, Gotikafo fuluto ogofu naba-naba kolaigu yauti efili edeto folaiguti olu nedi edaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ido Defitikafo amomu eti limo, Wekola ya kamena-kamena omunelo minaito ya eye-eye o minowe. Ido ane onaleka minami nenako, neta-mata makafo olu afima o nedámenagoliye. ");
INSERT INTO snp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ido oune ya folamo ebau yau fulo edeto koito edámoto, namo Felegaga We minomo ukane aumane ya fitala kiyámenaiye, loto lanimoma nenako, yamu sene-muluneu lalo kolowe. Yamu namo ya wenekafo alikani ka loto, mikaleka ukaneki minomo kamenalo ya kamo o nedenanimo kolito kiyabaka oto minomo dinae. ");
INSERT INTO snp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ido kofawa minomo idamo kanu nilibito namo mino nedageto, alikani naba-naba enagolowe, loto ka mono lufuwau (Sng 16:8-11) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mono wenenane-motao, auma wito logimowe. Autefo-kolofate Defiti ya fulutaito, kale li edato, ido kale li edamo ebala ya amau adu ya ne. ");
INSERT INTO snp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ido amo ya polofete minoto eti loto kolami, Gotikafo onale, loto kamo ufa fiyanimo yauti we ma olu nedi edageto, kamo ekeina folomoka yalo minoto ya wenena kiyaba o gedenagoliye, loto auma wito lo mele umami ne, loto koli minaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Etito netawa fedenami ya kolainako, yamu Metefokafo ilifi melami we Kilisto ya fulunaiguti olu nedi edeto ya folamo ebau fulo edámaito, kono ukana ya kaleku yau fitala kiyámenami ne, loto monawa ya lo oloto gimami ne. ");
INSERT INTO snp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ido Gotikafo Yesu folaiguti kofa olu nedi edaito, ido lalimo muki ya omude yakafo moda eyefe lonimo ne. ");
INSERT INTO snp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ido Goti ya Yesu kuliya olu faka loto, ane onaleka kuliyai we minenaiye, loto ido Ouna Felegaga kumunae, loto lo mele umamima ya Melafodoka yati oluto ido netawa onema linate eyeti kolamo ya oloto pi ledaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Oloto pi ledaito, Defiti aimola ukana ya kosinau idámami nefa, eti limo, Wekola yakafo Wekolane ya loumami, Ane onaleka amedoto kiyaba oto minageto, ");
INSERT INTO snp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya kuwokafo-mota fulo kiyaga feumau gedenagolowe, loto limo ne, loto ka mono lufuwau (Sng 110:1) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yamu linate Isilaeli wenena muki ya kolife loti kolalo. Linate yate we yá yofolo ofo folamo wewa Yesu ya Goti yakafo Wekola, ido ilifi melomo we Kilisto ya ne, loto bulu edaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ena kawa logimami ya koliti seni-mulunigu keina naba-naba koliti, Pitaki aposolo liligaki eti loti loga o gedamo, Mono wenenate-motao, nedi-nedi enune? loti loga ae. ");
INSERT INTO snp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Loga o gedato, Pitakafo itibito logimami, Linanimoni muki ya seti-muludi olu eleyapa witi Yesu Kilisto kuliyalo noku winawamo ya Gotikafo lifimatina kilili o gedeto, Ouna Felegaga gimageto olunagilae. ");
INSERT INTO snp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yamu linate ido nomilipatina ido faiga minamo wenena muki Wekola Gotitekafo luni finami wenena muki ya Ouna Felegaga giminae, loto lo mele gedaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eti logimito, ka maleka muki fuka ka auma wito eti logimami, Linate kamena oiya amo minamo wenena nosámamo minagu lifimanina olunawamo yaidana oti olutenuwe, loti fulo gedalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eti logimaito, ido kamena yalo wenena so loti tili tauseni (3,000) yate Pita ka limo ya koli kikito umato noku wi gedamo ya koli kikitamo wenena enu wiyae. ");
INSERT INTO snp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ena kolife lenune, loti aposolo api gilibamo ka auma witi koli-koli o minamo mono wenena maleka ani olu faka lo gede minoti, weni-netati ya lakoina noti Goti loumu-umu o minae. ");
INSERT INTO snp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Eti o minato, aposolo yate Goti aumala gilibami neta mona-mona ido mebe-maba gilibi-gilibi amo netawa ya wenena muki eyeti elegi minae. ");
INSERT INTO snp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ido koli kikitamo wenena seni-muluni lawoko meleti, netani-matani olu lawoko oti olu minae. ");
INSERT INTO snp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yamu mikani ido koukameni maki kifanalo fuloti kifana oluti wenena netamu moni wilamo wenena iya meleti gimae. ");
INSERT INTO snp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iya meleti gimiti, seni-muluni lawoko melamo ya kamena-kamena felegaga kuliyai numuna naba kilalau yau lakoina uti mau wi-wi o minae. Mau witi minoti, numunigu-numunigu weni-neta ido mono kobina ya iya meleti no-no minoti, seni-mulunigu alikani oti, luni-kani lawoko meleti, ");
INSERT INTO snp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Goti ebola loumato, wenena muki ya geye lalo meleti geye minae. Etiti minato, kamena-kamena ya Wekolakafo maunigu yau olu omuni kami wenena ya olu mene o gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kamena malo ya lunaga tili kiloku (3) yaidana oto Goti loumunawamo kamena adu melaito ya Pitate Yonite felegaga kuliyai numuna nabau idaiye. ");
INSERT INTO snp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Diti yalo felegaga numuna kanu kuliya Omona Biyanele, lamo kanu welalo yalo we ma olafo mulunauti kiyana nosámami ma nemo ya eyaiye. Eyami wewa ya kamena-kamena auwafo-mota yate mofuti oti yalo fulo edato ya wenena felegaga kuliyai numuna nabau diti lumuti amo ya kifanamu wako lo gede-gede iye. ");
INSERT INTO snp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wewa yakafo Pitate Yonite felegaga kuliyai numuna nabau dinagili ami ya geyetoto, Neta ma nomailo, loto wako lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wako lo gedaito, Pitate Yonite wewa eyefe loti eyeti ya Pitakafo, Lamo ya leyo, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ena wewa, Neta ma numunagilaiye, loto kogo geyaito ");
INSERT INTO snp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pitakafo loumami, Kifana ma ko ánofa, ido neta ma ko nomo ya moda kumunagolowe. Yesu Kilisto Nasalete numudoti ami we kuliyalo ya kamo mikaloti nedito kanu moino, loto loumuto, ");
INSERT INTO snp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ana onaleka oluto olu faka lo edaiye. Eti o edaito ya ayalomati kiyana moda aumafofo lito, ");
INSERT INTO snp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","satoto kiyanakafo nedito kanu monito monimo uto, felegaga kuliyai numuna nabau ya we lele yaki lakoina diti uti wewa yakafo satomo akaiya-akaiya wito Goti ebola liye. ");
INSERT INTO snp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Etito kanu monito Goti ebola limo ya wenena muki eyeti ");
INSERT INTO snp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","eyefe lotiti, Aiyo, wewa ya felegaga kuliyai numuna nabalo kanu kuliya Omona Biyanele, lamo kanu welalo ama ya kifana-koukamemu wako lo lede-lede ima ya nefe? loti u lalo wimo eyeti ya elegiyae. ");
INSERT INTO snp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ido wewa yakafo Pitate ido Yonite ukanido oluto minaido ya wenena muki oluloti amo minado felegaga kuliyai numuna naba ogonaagona oti kolokalo numuna yaidana oti kuwamo anawaleka ya kuliya Solomoni Kilalau, yaleka o fedeti elegiti olu mau witi minae. ");
INSERT INTO snp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Eti ato, Pitakafo geyetoto eti loto logimami, Isilaeli wenenao, linate nediti elegiti minae? Kogo leyamo ya lalimo aumate yakafofe, ido lalimo Goti monalalo meyalo melenumo lonote yakafofe wewa ya olu kanu moni edaiye, loti kati kiyafe? Olo? ");
INSERT INTO snp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abalahamu, Aisaka, Yekopu Gotinina, lalimote aute-mota kolofate Gotinina yakafo moda we naba ne, loti kolinagilae, loto koubanabala we Yesu olu naba o edeto kuliya lamenala umaiye. Eti ifa, linate ya ofato fulunaiye, loti Yesu ya kuwolafo-mota anido melamo ne. Eti melafa, ido komu ya Pailatikafo nelauti efili fulo edenae, loto lima ya linate, E’e, loti mesafa wi umamo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mesafa wi umuti, felegaga nemo we monala efe limo we ya meti umuti, wenena gini folami we efili fulo edenane, loti loumamo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Linate kofawa minomo dinawamo mona aboga ya oluti ofo folafa, ido Gotikafo folaiguti olu nedi edaito, omudekafo eyomi ne. ");
INSERT INTO snp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ido wewa ama eyeti koliti o-o minamo ya Yesu kuliyalo koli kikito umonimo mona yakafo olu aumafofo lo edami ne. Etito Yesu kuliya yakafo ido Yesu koli kikito umonimo mona amodokati ami yakafo wewa kiyana nosámami moda olu faka lo edaito ya linate muki eye minamo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ena mono wenenane-motao, linate ido kiyabani we Yesu eti o edamo monawa ya kolife ádamo ya moda kolowe. ");
INSERT INTO snp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Eti o edafa, adeina Gotikafo ilifi melami we Kilisto ya keina kolinagoliye, loto limo ka polofete muki wenido melaito kalawama ya oiya linate mona melado ya kalawama etito wiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yamu lifimate kilili o ledeto, Wekolakafo oudeu olu aila wi ledenami kamena ya lamodoka lilifinaiye, loti seti-muludi eleyapa witi Gotidoka itibiti alo. ");
INSERT INTO snp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Itibiti ato, Yesu ya ilifi melami we Kilisto minami ya adeina akaimati lamomu moda olu iyaina o edeitami ya minonido ilifi melenagoliye, loti seti-muludi eleyapa wiyalo. ");
INSERT INTO snp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aiga ilifi melenagolifa, oiya kosinau kiyaba minageto, polofete felegaga we wenido lo mele lomami ka ya melaito, ka lamo ya neta-mata muki kofawa olufe lenami kamena fedageto yalo Yesu itibito enagoliye. ");
INSERT INTO snp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yamu Mosese yakafo eti limo, Wekola Gotitina yakafo linate wenenatina minaguti polofete ma namo yaidana oto olu oloto pi gimito gilifi melenaiye. Olu oloto pi giminami wewa yakafo logimami kala muki ya koliti meyalo melalo. ");
INSERT INTO snp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ido makafo kala koli kolámenami ya Goti wenenala yauti moda u kopa unagoliye, loto ka mono lufuwau (Lo 18:15, 18-19) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Etiti polofete muki Samuweli kamenalalo akaimati ka lomo idamo yama ya oiya ama netawa-matawa o fedami yamu ka lo-lo amo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ido Gotikafo polofete neta iya ku gedami ido autibo kolofati-mota amoki olu kutifi gedami ka ya linate iya ku gedami ya moda olunagilae. Ido Gotikafo Abalahamu eti loumami, Namo ya ufa fiyanimo we yakafo mikau-mikau wenena muki olu lalo o gedenae, loto ka mono lufuwau (Stt 22:18) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eti loto loumami ya linate nosámami monatina ya olu fuliti seti-muludi olu eleyapa wiyato olu lalo o gedenae, loto kouba-nabala we ya olu oloto pito komu linanimodoka gilifaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitate Yonite wenena ka logimi minaito, Goti yokila ki umamo weki, ido felegaga kuliyai numuna naba kimiwe wenabaniki, ido Sadusi wenenaki ya we lele minaido o fedae. ");
INSERT INTO snp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Minaido o fedeti aposolo ya wenena api gilibiti eti logimamo, Yesu folaiguti neidainako, wenena ya ayaidana oto fulunuguti nedinune, loti lamo ka ya kolamo yamu seni kala-kala naba lito, oti ");
INSERT INTO snp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pitate Yonite anido olafa, lunaga melainako, yamu leda ligiya lo gedenuwe, loti nela numugu yau olumo fulo gedae. ");
INSERT INTO snp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Olumo fulo gedafa, ido ka mono lami kolamo wenena ya muki koli kikito umuti, ido Yesu wenenalaki ekeleti koli kikitamo wenena so loti faifu tauseni (5,000) yaidana minae. ");
INSERT INTO snp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ido leda ya Yuda wenena wenabaniti, ido wenena kiyabani weti, ido lo melami ka api gilibamo weti ya Yelusalemu numudo mau wiyae. ");
INSERT INTO snp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mau minagu ya Goti yokila ki umamo we wenabani Anasile, ido wenenala Kaiyafasile, Yonile, Alekisadale, ido wenenala maki lakoina mau minae. ");
INSERT INTO snp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mau minoti we lele ya olu mau minagu gilimiti idato, omunido ya minaito, eti loti loga o gedamo, Kema aumalalofe, ido kuliyalofe lonowa ama ya olaiye? loti loga o gedae. ");
INSERT INTO snp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Loga o gedato, Ouna Felegagakafo Pita siyamulunau faitoto mino edaito eti loto logimami, Wenabate ido kiyabate wenenao, ");
INSERT INTO snp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lamo we kiyana nosámami olu lalo edomi yamu egaidana oti wewa ya olu faka lo edaiye? loti loga o ledamo yamu lo oloto melenae. ");
INSERT INTO snp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ena lo oloto melenamo ya linateki ido Isilaeli wenena muki yaki kolife loti kolalo. Gotikafo ilifi melami we Yesu Kilisto, Nasalete numudoti we ya linate yá yofolo ofato folami ya Gotikafo folaiguti olu nedi edami we kuliyalo ya wewa omunido nedi minami ya olu faka lo edaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ido wewa yamu eti limo, Kifana ya numuna kuwamo wenena eye fa netaidana itamo nefa, ido aya kifanawa yama moda numuna lagi kola fiyami ne, loto ka mono lufuwau (Sng 118:22) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu yakafoko olu omude kenami ne. Etito nenako, mikau-mikau wenena minagu yauti makafo kuliyalo olu omude kenumo we ma minámaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ena Pitate Yonite koli gimámaito mau minamo wenena yate geyamo ya we lele ya fa wenena minoti, lufuwa api gilibamo numugu kamena lina efemako wamima ne, loti koliti yamu elegiti, ena amo ya Yesuki lakoina minomino ama ne, loti ya koli minae. ");
INSERT INTO snp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eti koli minato, we olu faka lo edami we ya lakoina nedi minamoma ya eyamo yamu ka lenawamo ya ma minámaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ka minámaito, kanisole mauniguti feka uti minailo, lato, lumuti minaito, inanimoni ka lo kifiti ya eti lamo, ");
INSERT INTO snp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Lalimote we lele ya nedi-nedi o gedenune? Wewa lele yate Metefo aumala lilibami neta naba ya olu oloto piyaito, ya Yelusalemu numudo minamo wenena muki ya koli fuli lotae. Ido netawa oloto piyámaiye, loto lenumo ya ogoufámone. ");
INSERT INTO snp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ido kawa ya numudo-namado upatoto wenena koli fuli lotenawae, loto lalimote ya wewa kuliyalo ya wenena ma kofa logimámailo, loto aumafofo loto lo fuko gedenune, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eti lotiti we lelema kofa luni fiyato aito, eti logimamo, Yesu kuliyalo wenena kofa logimiti api gilibámailo, loti aumafofo loti lo fuko gedae. ");
INSERT INTO snp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lo fuka gedafa, Pitate Yonite yate ka itibiti eti logimami, Lamo katina yalo golodoto Goti kala fulitenumo ya Goti kolinami lalo enaife? Kawa ya linanimotina iya meleti kolalo. ");
INSERT INTO snp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yamu lamo netama eyeto kolito o minomi neta ya lo oloto melámenalimo ya ogoufámoiye. E’e, lo oloto melemo dinagoloiye, loti laiye. ");
INSERT INTO snp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Eti loti laito, wenena muki netawa eti amo ya koliti Goti ebola loumuti minanako, kiyaba we yate we leledoka neta ma o gedámamo faifa koli giminami ka makafo igamu oti nelauti efiliti gilifi fulato waiye. ");
INSERT INTO snp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ido Goti aumala gilibami netakafo we kiyana nosámami olu lalo o edami wewa ya melegela foti (40) ya ne. ");
INSERT INTO snp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ena Pitate Yonite nelauti efili gedato, mono wenenani minado uti Goti yokila ki umamo wenabani ido wenena kiyabani we ka logimamo ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ka logimami ya kolititi luni olu lawoko meleti, Goti eti loti loumamo, Wekola nabao, mika kosina kuwo no ido netamata mona-mona neta nemo ya olu oloto piyane. ");
INSERT INTO snp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ido kamo Ouga Felegaga yakafo kouba-nabaka we autefo Defiti welalo ka melaito eti limo, Ailo feka wenena ya nediti seni kalakala naba lo minae? Ido wenenawa yate nediti Wekola ya kudala ki minae? Eti afa, ogoufámae. ");
INSERT INTO snp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ido mikalo kiyaba we wekudi yaki ya minoti, wenena kiyabani we Wekola Goti yaki ido ilifi melami weki lowa fi giminune, loti wenena naba ya mau witi ki minae, loto ka mono lufuwau (Sng 2:1-2) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ona lito, ido aya numuna meyalo ya Heloti ido Pontiusi Pailati yaki ailo feka wenena ido Isilaeli wenena yaki ya mau witi oti felegaga kouba-nabaka we Nakafo Yesu ya ilifi melanimo we lowa fi umunune, loti ka lo kifae. ");
INSERT INTO snp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Etiti ka lo kifamo ya eti-mati enawae, loto kamo kaimoka aumakakafo ido kolitoto komu lotanimo yaloma wiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eti afa, kamo Wekolate oiya kuwotefo-mota ka makafo igamu oti lamo yamu lamo kouba-naba o kedonimo ya aumakama lomageto, wenenawa kolini kolámoto, kaka ya wenena muki logimimo dinune. ");
INSERT INTO snp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Etito aumaka ya lilibito, felegaga kouba-nabaka we Nakafo Yesu kuliyalo ya wenena neta kilamo ya olu faka lo gedeto aumaka lilibanimo neta olu oloto pimo wo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eti loti loumuitato, numuna mau minamo numuna ya mima naba-naba ito, Ouna Felegagakafo oto seni-mulunigu mino faitito, kolini kolámoti Goti kala ya aumafofo loti logimiti minae. ");
INSERT INTO snp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ido koli kikitamo wenena muki luni-kani lawoko meleti, ido we ma netala ko nami yama ya nanimoko netane ne, loto ádami ne. E’e, muki wenena yate netanina ko namo neta muki ya iya melamo ne. ");
INSERT INTO snp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ido aposolo yate Wekola Yesu folaiguti kofa neidami kala ya auma naba-naba witi logimimo wae. Ido nasafili mona naba ya mino gedami ne. ");
INSERT INTO snp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ido aya wenena minagu yau ya netamu moni wilamo wenena ma minámamo ne. Ido kamena maleka neta ko namo wenena ya numuni-ebani netani-matani nemo yama kifanalo fuloti meina oluti ");
INSERT INTO snp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposolodoka ya gimato, amo yate neta ko ánamo wenena netamu moni wilamo wenena ya iya meleti gimae. ");
INSERT INTO snp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Eti ato, ya we ma nemo kuliya Yosefe ya aposolo yate kuliya Banabasile, loti melamo kuliyawa mona ya olu aila wi gedami wele, loti melamo wewa ya Lifai ufa fiyaigu yauti kuwo nokafo ogona imo eba kuliya Saipulusi yauti oloto piyami ne. ");
INSERT INTO snp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wewa yakafo mikala ma kifanalo fulo fuli loito meina ya oluto aposolo gimami ne. ");
INSERT INTO snp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ena we ma nemo kuliya Ananaiyasi olonafo Safailate lakoina mikani ma yaki kifanalo fuloti meina olaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Meina oluti eti enune, lito olonafokafo, O, lito meinawama oluti iya meleti, filiga nanimo netanele, loto meleito filigako oluto uto ya aposolo suki ka loto gimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Gimaito, Pitakafo eti loto loga o edami, Ananaiyasi, kamo nedito Satanikafo lukau ya mino kedaito, Ouna Felegaga ka suki loumuto mikaka meinala liliga olu falukane? ");
INSERT INTO snp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Komu mikawa kifanalo fulámanimo kamenalo ya kaimo mikaka nemo nefe? Ido aiga ya meina fiyamo kifanawa ya oluto kaimoka aboga minoto yaida-amaida enae, loto eti abe? Ya egaidana oto luka-kakau kolito olu kopaito eti ane? Eti animo ya wenena ma ka suki logimámane. E’e, Goti ka suki loumane, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Eti loumaito, Ananaiyasi kawa kolito lumu fou loto moda folaiye. Folaito, wenena muki kawa koliti koli naba-naba gimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ido we kofawe yate kono ukana lafo-lafokafo asa witi oluti uti kale li edae. ");
INSERT INTO snp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ena aiga tili (3) awa yaidana oto olu fulito olonafo kawa ya kolámoto o fedeto numugu idaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Numugu idaito, Pitakafo loga o edeto loumami, Mikati meinala olami ya etito nefe? lito, amokafo, Ona lane, meinala etito ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ido Pitakafo eti loumami, Linate setimuludi lawoko meleti Wekola Ouna ya kepa mele edenune, loti ya egaidana oti kolaiye? Koli mino. Wagafo kale li edamo wenena numuna kanu welalo minamo ya kamoki kilimiti uti kale li kedenagilae, lito ");
INSERT INTO snp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ayalo kiyanalo lumu fou loto moda folaito, we kofawe yate numugu diti kono ukana oluti uti wanafo kale li edagu ayau ya mele edae. ");
INSERT INTO snp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ido monolo mau wi-wi amo wenena muki ido muki kawa kolamo ya koli naba gimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo yate mebe-maba yaki, ido Goti aumala gilibi-gilibi imo neta mona-mona ya wenena minagu ya olu oloto piyae. Eti ato, ido koli kikitamo wenena muki ya seni-muluni lako meleti felegaga kuliyai numuna naba ogona-agona oti kolokalo numuna yaidana oti kuwamo anawaleka ya kuliya Solomoni Kilalale, loti lamo yau mau wi-wi o minae. ");
INSERT INTO snp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mau wiyato, wenena yate lalo geyafa, koli kolanako, yamu ya amoki mau wiyámamo ne. ");
INSERT INTO snp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Etito nefa, we wena so loti mulalo-mulalo oti Wekola koli kikito umamo ya amodoka mene otiko minae. ");
INSERT INTO snp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Etito wenenani neta kilamo ya yafalo meleti, ido ma ya agagalo meleti gilimiti oti kunu wiliti yalo meleti eti kolamo, Pita uto oto enami kamamunakafo neta kilamo wenena maleka ya ukanido oluto olu faka lo gedenaiye, loti kanudo mele-mele ae. ");
INSERT INTO snp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eti o-o ato, ido Yelusalemu numuna eba adu numudo-namadoti wenena muki mau wiyamo ya neta kilamo wenenaniki, ido Satani kimiwela seni-mulunigu mino gedeti olu nosámami gedami wenenaniki gilimiti amo wenena muki ya moda olu faka lo fuli lae. ");
INSERT INTO snp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ena yokila ki umamo we kiyabani we wenaba yaki ekeleti minamo we muki Sadusi wenena maunigu minamo ya netawa yamu koliti komumu witi ");
INSERT INTO snp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aposolo ani-kiyanido oluti nela numunau yau olumo fulo gedae. ");
INSERT INTO snp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Fulo gedato, luwaila Wekola enisolela yakafo nela numuna kanu wi gedeto feka gilimito uto ");
INSERT INTO snp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","eti logimami, Linate uti felegaga kuliyai numuna nabau diti wenena muki minamo ya omuni kofawa minenawamo mona ka muki ya logimalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Logimami ka koliti meyalo meleti leda ko lido ya felegaga kuliyai numuna naba kilalau diti ka mono api gilibi minae. Ido yokila ki umamo we kiyabani we wenaba yaki ege melamo wenena yaki o fedeti Sanihetilini Kanisole ya Isilaeli wenena kiyabani wenaba minamo muki olu mau wi gedeti, ya kimiwe nela numuguti aposolo ya gilimiti alo, loti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gilifi melato, kimiwe yate uti nela numugu ya moni wilafa, minámato, ");
INSERT INTO snp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","itibiti oti eti logimamo, Lamo u fedeto eyonimo ya nela numuna kanu moda aumafofo loti ku kiki loitato, ido kiyaba we yaki kanudo kiyaba oti minato, kanu wito dito moni wiloba, minámae, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Logimato, ya yokila ki umamo we wenabanina yate ido felegaga kuliyai numuna naba kimiwe kiyabani wete kawa ya koliti netawa fedami yamu kani ligi-ligi kiyae. ");
INSERT INTO snp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Eti o minato, we ma minado fedeto eti logimami, Eyalo. Nela numugu fulo gedamo wenenama ya felegaga kuliyai numuna nabau ya wenena ka mono api gilibi minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Logimaito, koliti kimiwe kiyabani weki ido kimiweki uti aposolo gilimiti afa, wenena yate kifana fuloti lofotenawae, loti koli gimaito, sodoti gilimiti ae. ");
INSERT INTO snp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gilimiti oti yokila ki umamo kiyabani we wenaba yakafo loga o gedenaiye, loti kanisole wenena omunido ya olu nedi gedato, eti loto loga o gedami, ");
INSERT INTO snp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Lamo ya, Wewa welalo ya api gilibámalo, loto lo fuko gimonima nefa, kolámoti linate ka ya Yelusalemu numudo kofa lato, wenena muki katina koli fuli lato, ido linate yaki wewa ya lamote ofo folae, lenune, loti lifima lamodoka melenune, loti auma witi koli minae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Eti logimato, Pitaki ido aposolo yaki ka itibiti logimamo, Wenena kanina ya koli fulito Goti kala yako meyalo melone. ");
INSERT INTO snp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ido autefomota Gotinina yakafo Yesu, linate yá yofolo ofo folamo we, ya folaiguti olu nedi edeto ");
INSERT INTO snp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","aimola ana onaleka meleto ya oluto dito kiyabani we wenaba ido olu omuni kenami wele, loto mele minaiye. Mele minami ya Isilaeli wenena seni-muluni olu eleyapa wiyato lifimate kilili o gedenaiye, loto melaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eti lo melaito, ido lamo netawa eyeto lo oloto melemo wogeto ido Ouna Felegaga ya Gotikafo kalalo golodamo wenena gimami we yaki ayaidana oto lo oloto pimo wiye, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ena kawa lamo ya Kanisole wenena kolititi ya seni kala-kala naba-naba lito, Gini fulunuwe, loti kolae. ");
INSERT INTO snp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Eti loti kolafa, Falisi we ma kuliya Gamaliyeli, lo melami ka api gilibami we, wenena muki kuliya olu faka lamo wewakafo Kanisole kulumanigu nedito kimiwe eti logimami, Aposolo feka gilimiti wato, kamena lina feka minenawae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eti logimaito, feka gilimiti wato, amokafo eti limo, Linate Isilaeli wenena neta ma wemomowa ya o gedenuwe, loti kolinawamo ya kolife loti kati kiyalo. ");
INSERT INTO snp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Komu we ma nemo kuliya Teudasi yakafo, Namo kuline nemo we minowe, loto lito wenena so loti fo hadeti (400) yaidana oti ege melama nefa, kuwolafo-mota yate ofo folato, ege melamo wenena muki ya upatoti wato, lonola ya u fa neta bulaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ena aiga gamanikafo wenena kulini lufuwa wiyamo kamenalo ya Galili we ma kuliya Yudasi oloto piyami yakafo wenena ma ile-fali senigu wito, Gamani wenenaki fina finune, lito ege wato ofo folato ege melamo wenenala muki ya upatae. ");
INSERT INTO snp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eti upatato, ido oiya netawa-matawa fedami yamu ka logimowe. Linate wemomowa ya olu kopa gedámoti koito gedalo. Nelauti efilito fulo gedalo. Ido lonowa mona ya faifa wenenadokati minagetoma, lonowa ya u kopa unagolimo ne. ");
INSERT INTO snp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nefa, lonowa mona ya Goti aimoladoka minagetoma ya Gotiki fina fi minanako, Wemomowa lononina ya itenune, loti enawafa, ogoufámenawamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliyeli eti logimaito, ka limo lalo koliti aposolo luni fiyato, itibiti ato, olu kimiwe gimato, kefadunu ginae. Ginato, auma witi lo fuko gimamo, Yesu welaloti ya kofa wenena api gilibámalo, loti logimiti nelauti efili fulo gedato, ");
INSERT INTO snp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kanisole mau wiyaguti lumuti eti loto kolami, Gotikafo lalo leyeto Yesu yamu keina naba ogofuto koloiye, loto kolaiye, loti kolami nenako, yamu lelewa seni-mulunigu alikani naba-naba aiye. ");
INSERT INTO snp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ena kamena-kamena felegaga kuliyai numuna nabau, ido wenena numunigu Yesu ya Gotikafo ilifi melami we Kilisto ya ne, loti kala kuwa lalo ya api gilibiti lo oloto melemo utiko minae. ");
INSERT INTO snp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kamena yalo koli kikitamo wenena so loti Yesu ege melamo wenena mene-mene omo wato, ido minagu yauti Giliki ka lamo wenena yate moila ka eti loti lamo, Yuda ka lamo yate wenena kamena-kamena neta-mata ko ánamo wenena neta iya meleti gimi-gimi o minado ya lamo wenaipa-kenate ya ani olu faka ádo-ádo ae, loti moila ka logimae. ");
INSERT INTO snp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eti logimato, Yesu lonola we tuwelu (12) yate ege melamo wenena muki olu mau wi gedeti eti loti logimamo, Lalimo ya Goti kala api gilibonimo lonowa fulitoma weni-neta iya melamo lono oluto meleto moni minenumo ya efe ádenagoliye. ");
INSERT INTO snp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yamu mono wenenate-motao, linanimo minagu yauti wemomo seweni (7) Ounakafo lunigu mino faitimo we, ka maninigu nemo we, lalo geyenawamo ya moni wiliti olu oloto pi gedato lonowa ya anido meleto ");
INSERT INTO snp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ido lamo ya Goti loumu-umu onimo lono ido kala kuwa lo oloto melenumo lono auma wito olu-olu minenagolone, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Eti logimato, mau minamo wenena muki ya lalo koliti Sitifeni koli kikila naba neto Ouna Felegaga siya-mulunau faitito mino edami we ya kiyaka oti, ido Filipi, Polokolusi, Nikanoli, Timoni, Pamenasi, Nikolasi Antiyoku numudoti ami we Yuda mono wenenadoka enu wiyami we yaki kiyaka o gedae. ");
INSERT INTO snp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wemomowa kiyaka o gedamo ya aposolo minado gilimiti ato, Goti loumutiti anikafo wemomo maninido melae. ");
INSERT INTO snp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Etito Goti kala kuwa ya upatoto monimo wito Yelusalemu numudo koli kikitamo wenena muki mene-mene omo wato, ido yokila ki umamo we minaguti yauti ma so loti kala kuwa lalo koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ena Gotikafo Sitifeni ya nasafili mino o edeto auma umaito, wenena minagu ya mebemabaki Goti aumala gilibami netaki monamona olu oloto piyaifa, ");
INSERT INTO snp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","wenena malekate Sitifeni moila fi umae. Wenenawa ya Yuda wenena mono numunani ma kuliya ya efili ledamo we mono numunile, loti lamo mauniguti mate Yuda wenena minamo Sailini mikalekati amo, ido ma Alekisadilia mikaloti amo, ido ma Silisia mikalekati amo, ido ma Esia mikalekati amo wenena yate Sitifeni moila fi umu minafa, ");
INSERT INTO snp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ouna yakafo Sitifeni welau ka melaito, ka lido fulo edenawamo ya ogoufámae. ");
INSERT INTO snp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ogoufámamo nenako, momona oti wenena ma olu oloto pi gedeti kani oluti eti loti logimamo, Sitifeni yakafo Mosesete ido Gotite kamani kiyaito kolonimo ne, loti logimalo, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Etiti ka lamo yakafo wenena fa wenena ido Yuda mono kiyabani we ido ka mono api gilibamo we ile-fali senigu wiyato Sitifeni minaido oti anakiyanalo oluti kanisole mau minagu ilimiti wae. ");
INSERT INTO snp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ilimiti uti ka su lo edenawamo wenena ya gilimiti ato, amo yate eti logimamo, Wewa ya kamena-kamena felegaga eba ama ido lo melami ka ya kamani kimo wimo ne. ");
INSERT INTO snp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yamu kolonimo ya Yesu Nasalete numudoti ami we yakafo felegaga kuliyai numuna naba ya luko fulito ido monate Mosesekafo lomami ya olu eleyapa wi melenagoliye, loto limo kawa kolonima ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eti loti lato, Sanihetilini kanisole mau minagu amedoti minamo wenena muki yate Sitifenidoka kogo eyamo kola-wela ya enisole kola-wela yaidana ito eyamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ena yokila ki umu-umu amo we kiyabani we wenabakafo Sitifeni loga o edeto loumami, Kawa lo kedamo ya ona nefe? loto lito, ");
INSERT INTO snp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitifenikafo itibito loto loumami, Wenenane, ido menefo-motao, ka lenagolomo ya kolalo. Adeina autefo kolofate Abalahamu Halani numudoka ku onámaido Mesopotemia mikalo minami kamenalo ya lamena aboga Goti yakafo oloto pi edeto ");
INSERT INTO snp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","eti loto loumami, Mikaka ido wenenaka fulo gedeito mika ma kilibinamo ebaleka wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eti loumaito, ka kolito Kalidia mika fulito, Halani numudo uto yalo minaiye. Minaito, melafo fulutaito Gotikafo ilifi melaito oto linate oiya minamo mikalo ya o fedaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Etito u ilifi melami ya mika ma aimola aboga ona minenaiye, loto umámami ne. E’e, mika kefola efe maki umámami ne. Umámaifa, ido aiga kamo ido ufa fiyaniguti wenena mika gimoneto aboga ona minenawae, loto lo mele umaiye. Eti loto melaima nefa, aya kamenalo ya Abalahamu nomilipala minámae. ");
INSERT INTO snp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ena Gotikafo eti loumami, Ufa fiyanigu yauti wenenaka ya wau wenena yaidana oti minoti, ailo wenena mikanigu ya melege fo hadeti (400) yalo ya minoti kouba-naba o gedeti, keina naba-naba kolimo unawae. (Stt 15:13-14) ");
INSERT INTO snp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Eti enawamo nefa, ido kouba-naba o gedamo wenena ya namokafo lifimanina itibito gimoneto aiga ufa fiyaniguti wenenaka ebawa ya fuliti oti mika amalo ya ouni-luni-kani numuti minenagilae, loto ka mono lufuwau (Kis 3:12) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eti loumuto ainala ukanigu fukenawamo ya namoki olu kutifi gedenae, loto lo mele umaiye. Ena aiga Abalahamu nalafo Aisaka oloto pito, fo kamena eiti (8) wageto Goti ainala ukanau fuko edaiye. Ido Aisaka nalafo Yekopu oloto piyami, ido Yekopu nalafo autefo-mota tuwelu (12) ya oloto piyamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ido autefo-mota kunanibo Yosefe komumu witi kifanamu koliti wenena anigu gimiti meina olato Isipika mikalo ilimiti wae. Ilimiti wafa, Gotikafo amodoka mino edeto ");
INSERT INTO snp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","keina kolaiguti oluto ka manenau mele edaito minami Isipi wenena kiyabani we wekudi Felo yakafo Yosefe mona lalo melami ya eyeto Isipika wenena muki ido aimola numuna ebala kiyaba o gedeto minenaiye, loto kuliyai we naba olu nedi edaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ena aiga Kenani mikalo ido Isipi mikalo muki ya kadunamu kamena naba oloto pito numuna eba gedo fulitageto keina naba-naba koliti autefo-mota kadunamu fuluti minae. ");
INSERT INTO snp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Minoti Yekopu ya Isipika yuwa witi ya ne, loti lamo ka ya kolito autefo-mota kana gilifaito yalo wae. ");
INSERT INTO snp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Uti itibiti oti kofa wato, Yosefekafo yalafo-mota monala lo oloto mele gimaito, ido mikalo kiyabani we wekudi Felokafo Yosefe wenenala geyefe liye. ");
INSERT INTO snp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Etito ya Yosefekafo alo, lotaito, melafo Yekopukele wenenala muki we wena sewedi-faifu (75) ya gilimito wae. ");
INSERT INTO snp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ena Yekopu Isipika uto minoto folaito, ido autefomota ayaidana uti minoti aiga folae. ");
INSERT INTO snp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Folato, kono ukani oluti Sekemuka oti eba ma Abalahamukafo komu adeina Sekemu numudo Hamoli nalafo-mota kono melenumole, loti lamo eba meina fiyaigu yama kale li gedae. ");
INSERT INTO snp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ena adeina Gotikafo Abalahamu lo mele edami kaloma u ayalo winami kamena ya alili melaido yalo wenenate Isipika minamo ya kefo minámae. ");
INSERT INTO snp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Etiti minomo wato, Isipi kiyaba we wekudi kofawa ma oloto piyami yakafo Yosefe eyefe ádaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eyefe ádami wewa yakafo wenenate ya koni wito olu nosámami o gedeto, autefo-mota nomilipani ya fulo feka gedeto fulunawae, loto aumafofo liye. ");
INSERT INTO snp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kamena yalo ya Mosese oloto piyaito, kipawa Goti omunalo ya omuna biyane minoto ikana tili (3) ya melafo numunau yau olu kiyaba o edemo wato, ");
INSERT INTO snp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","aiga numuna kila feka fulo edamo kamenalo Isipi kiyabani we wekudi Felo olulafokafo olu leboilami ya aimola kedami yaidana oto kiyaba o edaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kiyaba o edaito, Isipi wenena ka maninigu nemo ka muki ya api ilibato, ya kalo ido lonodo ya u wenaba ya bulu edae. ");
INSERT INTO snp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ena melegela foti (40) ya olu fuloto Isilaeli wenenane uto geyenae, loto ");
INSERT INTO snp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","uto eyami ya Isipi we makafo Isilaeli we ma ofo minaito eyetoto uto ana olu faka loto Isipi we ya ofo folaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ofo fulutoto eti loto kolami, Wenenane yate namomu kolife loti Gotikafo wenenane Isipi wenena kiyabani we wekudi analoti efili gedenae, loto aumala nomaiye, kolinagilae, loto kala kiyaifa, etiti kani kiyámae. ");
INSERT INTO snp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ido leda Isilaeli we lele ma fina fi minami ya geyeto olu filiga-filiga o gedeto, olu kutifi gedenae, loto kolito eti loto logimami, Aiyo, linate ufa lawoko ma minainako, nediti fina fiyae? loto loga o gedaifa, ");
INSERT INTO snp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","koinalafo olu nosámami edami we yakafo Mosese itufu fulito loumami, Kamo ya kiyabate we ido lifima lumunanimo we kemakafo bulu kedami ne? ");
INSERT INTO snp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Meloma Isipi we ofo folanima yamaidana oto namo nofenagolabe? Olo. lito, ");
INSERT INTO snp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ya Mosesekafo ka ya kolito Midiyani wenena mikanigu koli uto, yalo numuna ku onoto, wau we yaidana minoto, wena olami nalafo lele ya oloto piyaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ena melege foti (40) ya aya ebalo minototo ya uto kofo mikau Sinai mowa adu minaido yalo kaila imo yá ailau ma yo lito yo famula yau ya enisole ma oloto pi edaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Netawa eyami yamu elegito eyefe lenae, loto adu wito Wekolakafo eti loto loumami nola ya kolaito eti limo, ");
INSERT INTO snp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Namo aukafo-mota Gotitina minoto ido Abalahamule, Aisakale, Yekopule Gotinina minowe, loto lito Mosese nola kolito ya koli naba kolito ukana ololo oto ko faka ádaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ko faka ádaito, Wekolakafo eti loto loumami, Mika leya wiyanimo yalo ya felegaga mika nenako, kiyagalo wiyanimo neta kololoto. ");
INSERT INTO snp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Namo ya wenenane Isipi mikalo minamo ya olu nosámami o gedato, moda koto, kufu amo ya kolitoto efili gedenae, loto omo ne. Amalo ano. Isipika itibito kilifi melenagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Aya wewa Mosese ya wenenalate mesafa wi umuti, kamo ya kiyabate we ido lifima lomanimo we kemakafo bulu kedami ne? loti lo edamo wewa yama Goti aimolakafo we yamo kiyabani we wenaba ido nelauti efili gedenami we minenaiye, loto enisolela ilifaito, yá kefolau oloto pi umuto Goti kala loumami ne. ");
INSERT INTO snp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aya wewa yakafo Isipikati gilimito wiye. Ido Isipi mikaloki ido Kuwo No Kisi Limo yaloki ido kofo mikau melege foti (40) yalo minado ya Goti aumala gilibami neta mona-mona olu oloto pi gedemo wimo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aya wewa Mosese yakafo Isilael wenena eti loto logimami, Gotikafo linate ufa fiyagu yauti polofete ma namo yaidana oto ya linatedoka gilifi melenagoliye, loto logimami ne. ");
INSERT INTO snp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ido kofo mikau mau minagu yau minoto, ido enisole ya Sinai mowa yalo loumami yaki lakoina minoto, autefo-kolofate-motaki lakoina minoto, olu kofawa minomo dinawamo ka ya kolitoto lo oloto mele gedami ne. ");
INSERT INTO snp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Etito nemo nefa, ido autefo-kolofate-mota yate Mosese kala golodámae. E’e, kala golodámoti meni umuti, Isipi mikalo itibiti unune, loti lunigu ya etiti koli minoti ");
INSERT INTO snp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aloni eti loumamo, Kamo goti lebonani olufe lageto u komu meleti lilimiti unune. Wewa Mosese Isipikati lilimito ami we ya nedi-nedi o minaiye? Ya kolámone, loti loumamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eti loumamo kamena yalo bulumakau momola lebonala olufe loti gotiwa ya neta umunune, loti neta ofo kiti yokila ki umuti inanimoni anikafo olufe lamo netawa kuliya ya olu faka lo edenune, loti konuma-kobina naba ofo ki nae. ");
INSERT INTO snp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Etiti afa, Gotikafo mesafa kito kosinaleka neta-mata ya ouni-luni-kani umunawae, loto liye. Eti loto limo yaidana oto polofete lufuwa wiyagu ya eti limo, Isilaeli wenenao, linate kofo mikau melege foti (40) yalo minadoma ya bulumakauti sipisipiti ofoti yokila ki numunune, loti ki numu-numu o minamo nefe? ");
INSERT INTO snp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","E’e, etiti minámoma ne. Linate gotitina ma kuliya Moloki ya seli numuna ku edagu yau meleti mofuti moni-moni amoma ne. Ido gotitina ma kuliya Lefani ya ukulu yaidana oto lebona imo ya oluti moni-moni amoma ne. Eti amo ya gotiwa ya ouni-luni-kani giminuwe, loti ya olufe lamo nenako, yamu kuwotibo-mota anido gimoneto anikiyanido oluti gilimiti Babiloni mikau faiga yalo unagilae, loto ka mono lufuwau (Amo 5:25-27) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Autefo-kolofate-mota kofo mikau minamo kamenalo ya Gotikafo linateki lakoina minomo wowe, loto logimami mebe-mabala felegaga seli mono numuna ya amoki lakoina ne. Aya numuna kunawamo kamamuna Gotikafo Mosese etiti kunawae, loto ilibaito, eyaido yalo kuwamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Etiti kuwamo, aiga ya autefo-kolofate-motaki, ido kiyabani we Yosuwaki Gotikafo komu meleto ailo feka wenena gitufu fulitami mikanina ya olado felegaga seli numunawa olamo ya mofuti oluti oti mikawalo o fedato yalo ya minomo Defiti minami kamenalo wiye. ");
INSERT INTO snp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Minomo wito, Defiti Goti lalo eyami we yakafo eti loto loumami, Yekopu Gotila minanimo ya numuna ku kedenafe? loto loga o edaifa, ");
INSERT INTO snp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Solomonikafo moda numuna ya ku edami ne. ");
INSERT INTO snp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Etito nefa, Goti akaiya nemo we ya wenena anikafo numuna kuwamo yau minámenami ne. Yamu polofetekafo eti loto limo, ");
INSERT INTO snp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Wekolakafo eti loto limo, Kosina ya ekeina folomone ya neto, ido mika ya kiyane leya wi-wi o minomoma ebane nenako, ido egaidana oti numuna ku nedenawae? Ido onenamo ebane ya egau ne? ");
INSERT INTO snp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Namo anekafo netawa-matawa muki olu oloto piyomo ne, loti kolámafe? loto limo ne, loto ka mono lufuwau (Ais 66:1-2) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Linate ka koliti kolámoti amo wenena minamo ya seti-muludigu ido kati-manidigu ka mono kolámamo wenena minae. Ido linanimo ya autibo-kolofati-mota yamaidana oti minamo kamena-kamena Ouna Felegaga ya golo-golo ádamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ido polofete yauti we ma ya autibo-mota yate olu kopa edámamo nefe? Mona efe limo we ya oloto pinaiye, loti ka lo melamo we yaki gini folamo ne. Ido wewa ya linatete ya kuwolafo-mota anido meleti ofo folamo ne. ");
INSERT INTO snp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Linate eti amo ya lo melami ka ya enisole Goti welauti gimato oluti nefa, ido meyalo melámamo ne, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitifeni kawa logimami ya koliti seni kalakala naba lifa, ");
INSERT INTO snp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ouna Felegaga siya-mulunau ya faitito kosinau kogo ko minoto eyami Goti lamenala naba yaki ido Yesu ya Goti ana onaleka nedito minami ya eyaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eyeto eti loto logimami, Moda kosina godo neto We kula ya Goti ana onaleka minami ya eyowe, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Logimami ka ya koliti anikafo kanigu itoti au naba-naba loti ya muki oluloti oti olu lulau edeti, ");
INSERT INTO snp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ana-kiyanalo oluti yaloti numudo kila feka ika oti, oluti uti kifanakafo ofomo uti, ukanido owo fana ya kololototi, we kofawe ma kuliya Solo ya kiyanalo melae. ");
INSERT INTO snp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Meleti ya Sitifeni kifanakafo ofo minato, ya eti limo, Wekola Yesuwo, oune ya olo, loto loumuto, ");
INSERT INTO snp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ido kiyana umola fito au naba eti loumami, Wekolao, lifimanina amodoka melámo, loto eti loito ya folaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Solo ya yalo minoto Sitifeni ofo folamo ya siya-muluna lalo iye. Ido aya kamena yaloti Yelusalemuka monolo mau wi-wi amo wenena ya keina naba-naba apito kolato, muki ya giyadato, Yudia ido Samalia mikau-mikau upatoti wato, aposolo yako Yelusalemu minae. ");
INSERT INTO snp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Minato, Goti monala melamo we mate ya Sitifeni kono ukana oluti uti kale li edeti amomu kufu nema naba ae. ");
INSERT INTO snp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Eti afa, Solokafo monolo mau wi-wi amo wenena ya apito olu kopa o gedeto numuni negu-negu muki dito we wena ani-kiyanido ika oto nela numugu olumo fulo gedaito minae. ");
INSERT INTO snp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ido upatoti wamo wenenate ya numudonamado uti kala kuwa ya logimimo wae. ");
INSERT INTO snp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Logimimo wato, ido Filipi yakafo Samalia ebalo wenena numuni nabalo uto Gotikafo ilifi melami we Kilisto kala ya lo oloto melaito, ");
INSERT INTO snp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","wenena muki mau naba minamo yate kala ya koliti Goti aumala gilibami neta olu oloto piyami ya eyeti, ka logimami ya auma witi koli minae. ");
INSERT INTO snp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ido Satani kimiwela yate wenena muki mino gedamo ya lunigu yau diti kai naba-naba melato, ido ma ya ukani ipedotoko nemo, ido ma ya kiyani galidimo yaleka ya olu faka lo gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yamu aya numudo minamo wenena muki alikani nabanaba ae. ");
INSERT INTO snp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ido numuna meya ayalo ya we ma nemo kuliya Saimoni yakafo kamena fana kibe lusa ki-ki ito, Samalia minamo wenena muki netawa koliti elegiyae. Wewa aimola kuliya olu faka loto, Namo kuline nemo we minowe, lito ");
INSERT INTO snp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","wenena muki kulini nemo ido fa wenena yaki ka logimami ya auma witi koli minoti eti loti lamo, Wewa ya goti kuliya Aumala Naba Nemo ya minaiye, loti lo-lo minae. ");
INSERT INTO snp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ido kamena fana kibe lusa ki-ki imo monala eyeti moda elegiyanako, amodoka ege melae. ");
INSERT INTO snp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Eti afa, Filipikafo Goti wekudite wenenala kiyaba o ledami ka ido Yesu Kilisto kuliya yamu kala kuwa logimaito, koliti koli kikitamo we wena muki mono noku wiyae. ");
INSERT INTO snp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mono noku wiyato, Saimoni aimolakafo ayaidana oto koli kikito umutoto noku wiyaiye. Noku wito Filipi nedo-nedo moinami ege meleto Goti aumala gilibami neta mona-mona olu oloto pi gedami ya eyeto elegi minaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ido Yelusalemu numudoka aposolo yate Samalia wenena Goti kala kuwa koliti koli kikito umamo ya kolado Pitate Yonite amodo gilifi melae. ");
INSERT INTO snp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Gilifi melato, amodoka u fedaito, Ouna Felegagakafo koli kikitamo wenena lunigu mino gedámaito, faifa Yesu kuliyalo yako noku wiyanako, Ouna Felegaga lunigu lumuto mino gedenaiye, loti Wekola loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eti loumuiti we lelete anikafo ya koli kikitamo wenena maninido melaito, Ouna Felegaga mino gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ido aposolo anikafo ya wenena maninido melaito, Ouna Felegaga mino gedami Saimonikafo eyeto uto kifana oluto ");
INSERT INTO snp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","lele minaido uto eti loto logimami, Linate kifana gimoneto aumawa nomaito, namo ayaidana oto wenena maninido ane meloneto Ouna Felegaga mino gedenaiye, loto nomo, liye. ");
INSERT INTO snp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pitakafo eti loto loumami, Gotikafo faifa lomami neta ya kamo kifanakafo meina finae, loto laninako, ya kifanaka yate kamote moda lakoina yo eifámenami yoku yau unagilaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kamo ya Goti omunalo ya ouga-luka-kaka efe ádainako, lonowa lamoki lakoina lono olámenagolane. ");
INSERT INTO snp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Nosámami neta yakafo lukau olu faitoto netawa nela wi kedami ne, loto kolowe. Yamu seka-muluga eleyapa wito nosámami monaka fulito, seka-mulugau netawa nosámami kolanimo neta ya Wekola lifimaka kilili o nedo, loto loumo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimonikafo itibito loumami, Netawa linate lami ya ma oloto pi numutenaiye, linate namomu Goti loumailo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ena Yesu monala eyami logimiti Wekola kala kuwa lo oloto meleiti ya Yelusalemu itibiti unagili uti moinado wenena Samalia numuna meya muki minamo ya kala kuwa logimimo waiye. ");
INSERT INTO snp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ena Wekola enisolela makafo Filipi minaido oto eti loto loumami, Kamo ya kanu ya waka afulaleka fafato mikau yau Yelusalemu numudokati lumuto u Gasa numudoka wimo yalo kanudo wo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Loumaito, apito monimo uto aya kanudo yalo moda kiyaba we ma Itiyopiakati ami we ma katula iye. Wewa Itiyopia mikau kiyabani wena wenakudi Kadasi kifana-koukamela kiyaba imo we yakafo Yelusalemuka Goti oune-lune-kane umunae, loto uto, ");
INSERT INTO snp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aiga numunaleka itibito enami kamenalo ya yafo-hosite ika o-o ami netalo amedoto minoto polofete Aisaiya mono lufuwa wiyami ka ya katomo wiye. ");
INSERT INTO snp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Katomo wito, Ounakafo Filipi eti loto loumami, Kamo ya uto mulalo moinami neta adu ege-ege wo, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi kolito oluloto uto wewa ya polofete Aisaiya lufuwa wiyami ka ya kato minami ya kolito loga o edami, Kamo lufuwa katanimo ya monawa kolife loto kolabe? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Loga o edaito, itibito loumami, We makafo ka monawa ya api nilibámenami ya egaidana oto kolife lenamo ne? loto loumuto kamo dito namote lakoina amedoto minenaliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Loumami ya ka mono lufuwalo etito katami, Sipisipi ma ofenuwe, loti ilimiti wado, ido sipisipi momola yowala fukenawado ya sipisipi kai melámami yaidana oto amokafo ka ádaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ka ádaito, ukana kolinami ona umuti ligiya lo edado efe loti olu kalo mele edámae. Ido mikalo minami kamenala ya fukoti, ofo folanako, kemakafo ufa fiyaiguti wenenala kani ogofu lenagoliye? loto ka mono lufuwau (Ais 53:7-8) ya nemo ka kato minaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kato minami kiyaba wekafo Filipi loga o edami, Lonomageto kolinagolowe. Polofete ya kemamu eti liye? Aimolamufe, ido we mamu liye? loto loga o edaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Loga o edaito, Filipikafo yaloti mele pito aya mono kawaloti Yesu kala kuwa lalo ya api ilibimo wiye. ");
INSERT INTO snp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Etito ilibimo wito monimo lumuti nolo ya fedaito kiyaba wekafo limo, Moda noma ama ya ne. Namo mono noku winamo ya kemakafo kanu ku nedenaiye? loto loga o edaiye.  ");
INSERT INTO snp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipikafo loumami, Kamo ouga-luka-kaka muki koli kikito umutoma ya moda noku winane, loto loumaito, itibito loumami, Namokafo Yesu Kilisto ya Goti Nalafo ne, loto koli kikito umowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ido yafo-hosite ika o-o ami neta ya olu you loto melaito, Filipite kiyaba wete yaloti lumuti noku lomato, Filipi noku wi edaiye. ");
INSERT INTO snp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Noku wi edeito nokuti feka aito, Wekola Ouna yakafo Filipi ilimito wito kiyaba wekafo kofa eyámaito alikani naba oto kanulalo wiye. ");
INSERT INTO snp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kanulalo wito, ido Filipi ya Asidoti numudo yalo oloto pito numudo-namado monimo uto kala kuwa lalo ya logimimo uto Sisalia numudo fedaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Solokafo Wekola ege melamo wenena gini fulunae, loto igamu imo uto Goti yokila ki umamo we kiyabani we wenaba nedo uto ");
INSERT INTO snp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","eti loumami, Namo Damasikusi numudoka uto Yesu kanulalo moinamo wenena ma minenawamo wefe, ido wenafe olu oloto pi gedetoma anikiyanido nela wito ya Yelusalemu numudoka gilimito enae, loto kolomo yamu kamokafo Damasikusi numudo Yuda wenena mono numunigu mau wi-wi amo wenena ya lufuwa wi gedeto nomagetoma ya oluto unae, loto loumaito, ya lufuwa wi umaito oluto wiye. ");
INSERT INTO snp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yalo uto uto Damasikusi numuna olu alalili melaito, ya kosinauti lamenakafo kaita ogona o edeto lamena iye. ");
INSERT INTO snp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eti ito, mikalo lumu fou loto nola ma kolami eti loto loumami, Solo, Solo, kamo nedito olu kopa o nede minane? loto loumami ya kolito ");
INSERT INTO snp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","eti limo, Wekolao, kamo kema minane? loto loga o edaito, amokafo itibito loumami, Namo Yesu ya olu kopa o nede minanimo we ya minowe. ");
INSERT INTO snp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ena kamo nedito, numuna meya nabaleka wageto yalo neta enanimo ka ya lokumunagoliye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Loumaito, wemomo amoki moinamo we ya ka nola kolafa, ido we ma eyámamo yamu ka kedámoti minae. ");
INSERT INTO snp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ido Solo mikalekati nedito ya kogo kenae, loto omuna falatifa, neta ma ágaito analo oluti Damasikusi numudoka ilimiti wato, ");
INSERT INTO snp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","yalo fo kamena tili (3) omuna likaito minoto wela-netati nonanoti ya ánaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ena Damasikusi numudo Yesu ege melami we ma kuliya Ananaiyasi nemo ido famoidana olumo omunalo melaigu ya Wekolakafo loumami, Ananaiyasiyo, loto loumaito, ya itibito limo, Ye, Wekolao, namo ama minowe, lito, ");
INSERT INTO snp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ya Wekolakafo eti loto loumami, Kamo uto kanu ma kuliya Efe Limole, lamo yalo uto Yudasi numunalo we ma Tasusi numudoti ami we kuliya Solo ya moni wilo. Wewa ya lonumu minaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lonumu minoto famoidana kami ya we ma kuliya Ananaiyasi yakafo amodoka o fedeto omuna kofa kenaiye, loto anakafo ukanalo melami we ya kaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Loumaito, Ananaiyasikafo limo, Wekolao, wewa yamu wenena muki ka lamo ya moda kolitomo ne. Amo yamo wenenaka Yelusalemuka minamo ya olu kopa o gede-gede imo ne. ");
INSERT INTO snp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ido amalo ya ayaidana oto yokila ki komamo we wenabani kulinido oto wenenaka muki kulikalo olu faka lo ledo, loto lokumunumo ya adekiyadelo nela wito lilimito unae, loto aiye, loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wekolakafo eti loto loumami, Kamo faifa wo. Wewa namo kouba-nabane we minoto, ailo feka wenenati ido kiyabani we wekudi minagu ido Isilaeli wenenati minagu ya uto kuline olu oloto pi giminaiye, loto iyaina o edetowe. ");
INSERT INTO snp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ido kuline yamu keina naba-naba kolinami ya ilibinagolowe, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Eti loumaito, ya Ananaiyasi uto numugu yau dito Solo ukanalo anakafo meleto eti loto loumami, Wenenane, Solo, Wekola ya Yesu aimola kanudo oloto pi komami we yakafo kamo omuga kofa kageto Ouna Felegaga mino kedami faitenagoliye, loto ya nilifaito owe, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ayalo Solo omunauti neta ma laefa kidinuma yaidana olumo wiyaito, omuna kofa koto, nedito mono noku wiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eti ito welaneta nototo kofa auma olaiye. Ena Solo ya Yesu ege melamo we Damasikusi numudoka minamo yaki kamena mumudi lakoina minoto, ");
INSERT INTO snp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ayalo Yuda wenena mono numunigu dito Yesu ya Goti Nalafo ne, loto apito lo oloto melaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lo oloto melaito, wenena muki kala ya kolamo elegiti eti loti lamo, Yelusalemu numudo wenena ya Yesuwo, ade olu faka lo ledo, loti lamo wenena ya ginimo wimo wema nefe? Ido amalo ayaida oto nela wi gedeto yokila kiyamo we kiyabani we minadoka gilimito unae, loto imo we aima yama nefe? loti loga-miga ae. ");
INSERT INTO snp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eti lafa, Solo auma wito lo oloto melemo uto Yesu ya ona Gotikafo ilifi melami we Kilisto ya minami nenako, yamu logimaito, Yuda wenena Damasikusi numudo minamo kani ligi-ligi kiyae. ");
INSERT INTO snp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ena fo kamena so loti wageto ya Yuda wenenate Solo ofo fulunuwe, loti mau witi ka lo kifafa, ");
INSERT INTO snp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ido Solokafo ka lo kifamo ka kolaiye. Kolaito fo lido ido siniku ya numuna meya naba kila kanu-anu welalo ya ofo fulunuwe, loti kiyaba afa, ");
INSERT INTO snp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ege melamo we yate luwaila siniku ya Solo ilimiti uti kifana numuna meya kila mulalo yama minoti kedikoko owoku koli edeti nela onowa filiga-filiga olu minoti fulato yalo lumuto u feka wiye. ");
INSERT INTO snp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ena Yelusalemu numudoka u fedeto Yesu ege melamo weki ekelenae, lifa, amo ya Yesu ege melami we ne, loti koli kikitámoti ya koliya kolae. ");
INSERT INTO snp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Koliya kolato, Banabasikafo oto ana olu faka loto, ilimito aposolo minadoka waiye. Uti Solo kanudo Wekola eyaito, ka loumami kolito Damasikusi numudo uto wenena kolini kolámoto Yesu kuliyalo lo oloto melami kala ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Logimaito, etito Solo ya amoki lakoina minoto Yelusalemu numudo faifa monito wenena kolini kolámoto Wekola kuliyalo lo oloto mele-mele iye. ");
INSERT INTO snp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lo oloto melami ya Yuda wenena Giliki ka lamo wenena yaki moila-moila fiyaifa, ofo fulunawamo kanu moni wilato, ");
INSERT INTO snp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","mono wenenala yate kawa koliti, ya ilimiti Sisalia numudo uti ilifi fulato u Tasusi numudo u fedaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Etito Yesu wenenala Yudia, Galili, Samalia minado ya you amene kamena lalo oloto piyaito, Ouna Felegagakafo seni-mulunigu olu aila wito auma wi gedaito, wenena muki amodoka menemene ato Wekola koliya koliti moinae. ");
INSERT INTO snp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ido Pita ya numudo-namado ya monimo uto felegaga wenena liliga maki geyenae, loto Lidaka numudo minadoka u fedaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yalo minoto we ma eyami kuliya Ainiyasi ukana ipedimo folomoloko onoito minami melege eiti (8) ya wimo we ");
INSERT INTO snp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ya Pitakafo eti loto loumami, Ainiyasiyo, Yesu Kilistokafo olu faka lo kedaiye. Nedito, kunuka olufe lo, lito ayalo neidaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Neidaito, wenena muki Lida numudoti ido Saloni ofuna mikaloti minamo ya eyeti seni-muluni eleyapa witi Wekola koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ido Yopa numudo Yesu ege melami wena ma kuliya Tabita (Giliki wenena kanidokati kuliya Dokasi) ya nemo kamena-kamena mona laloko meleto neta ko ánamo wenena ani olu faka lo-lo iye. ");
INSERT INTO snp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aya kamena yalo ya neta naba kilito folaito, ya kono ukana noku witi olu numuna ofugu mauka diti melae. ");
INSERT INTO snp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Melato, ya Lida numuna ya Yopa numuna adu nemo yamu Yesu ege melamo wenena yate Pita Yopa numudo minami ya koliti we lele ma amodoka gilifi melato, alako lamo minonido ano, loti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Gilifi melato, uti loumaito, Pitaki lakoina oti o fedato, ilimiti ofugu ayau idato wenaipa-kena muki ya amo nedo oti ogona o edeti kufu nema oti minoti Dokasikafo omuna kofawa minoto ukanido owo mona-mona kifito gimami neta ya ilibi minae. ");
INSERT INTO snp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ilibato, Pitakafo wenena muki gilifi fulo fekaito, kiyana umola fito Goti loumuito eleyapa wito wena folami ya eyeto, Tabitao, neido, lito omuna falatoto Pita eyeto amediye. ");
INSERT INTO snp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Amedoto minaito, Pitakafo analo oluto olu nedi edaito nedito minaito, koli kikitamo wenena ido wenaipa-kena amodoka luni fiyaito, idato ya Dokasi omuna kofawa minami ya gilibaiye. ");
INSERT INTO snp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ido kawa ya Yopa numudo upatoto wito wenena koli fuli loti, mumudi Wekola koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ido Pita Yopa numudo we ma kuliya Saimoni bulumakau atuwa olufe lo-lo imo we numunau amoki lakoina kamena fana minaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ena Sisalia numudo we ma nemo kuliya Koniliusi ya ne. Amo ya kimiwe mau naba minamo kulini Itali Mikalo Kimiwele, loti lamo yauti kimiwe wani hadeti (100) ya kiyabani we ne. ");
INSERT INTO snp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wewa ido wenenala muki ya mono koliti Goti koliya koliti moinae. Etito ya Yuda wenena neta ko ánamo wenena ya kifana-afana neta-mata muki gimito, ido Goti loumu-umu imo we ne. ");
INSERT INTO snp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ido fo kamena malo ya lunaga tili (3) kiloku yaidanalo neta ma famo yaidana oto efe loto eyami ya Goti enisolela makafo famoku oloto pi umuto amo nedo oto, Koniliusiyo, loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lomaito, kogo ko faka loto eyeto koli naba-naba umaito eti loto loumami, Wekolao, nediye? loto loga o edaito, enisolemakafo itibito loto loumami, Goti loumu-umu animo kaka ido neta ko ánamo wenena nasafili o gedanimo monaka ya Goti kolito kamomu kala ki minaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yamu kamo Yopa numudo wemomo ma gilifi melageto uti we ma kuliya Saimoni, kuliya ma Pita ya monila wiliti ilimiti itibiti enawae. ");
INSERT INTO snp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wewa ya lilafo Saimoni bulumakau atuwa olufe lo-lo imo we numunau kuwo no anawaleka akaila yalo minaiye, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Loumuto utaito, ena Koniliusi kouba-nabala we lele maki ido kimiwela amoteko mino-mino amo we minagu yauti we ma mono kolami yaki luni fiyaito, ");
INSERT INTO snp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","amodoka ato ya netawa muki fede umami yama logimito Yopa numudoka gilifi melaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Gilifi melaito, monimo uti uti kanudo onoti, ko lito kofa uti numuna meya olu alili melado ya folilo Pitakafo Goti loumunae, loto numuna obito eba ketalo dito minaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Minoto ya Goti loumu minaidoti kadunamu fuluto neta ma nenae, loto kolaifa, ido weni-neta ofo ki minamo kamenalo neta ma famoidana kami ne. ");
INSERT INTO snp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Famoku eyami ya kosina godito yauti neta naba ma lafo-lafo yaidana oto onowa filiga-filiga ya olu minoto fulaito, mikalo lomami eyaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Eyami ya lafo-lafowa lulau yafo mona-mona ani-kiyani fo (4) nemo ido yá kefa-afa, ido koiyofa-aiyofa, nema-afa, mona-mona yau minamo eyaito, ");
INSERT INTO snp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ido ka nola makafo eti loto loumami, Pita, kamo nedito ya ofoto no, loto loumaifa, ");
INSERT INTO snp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pitakafo limo, Wekolao, yaidana ámenae. Namo neta fuma wiyami ido neta mo ádami ya moda ánodo ne, loto liye. ");
INSERT INTO snp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eti lito, ka nolamakafo kofa loumami, Neta ma Gotikafo mo loto nemo neta olufe limo, ya neta fuma wiyami ne, loto ádo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eti loumuto ido netawa ya ayamaidana oto kamena tili (3) oloto pitoto ya ayalo itibito kosinauka idaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Idaito, Pitakafo neta kofawa kami ya monawa yamu kala mumudi ki minaido Koniliusikafo gilifi melami wenenala Saimoni numuna olu oloto piti numuna kila kanudo minoti ");
INSERT INTO snp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","wenena luni fiti eti lamo, Saimoni kuliya ma Pita ya numuna amau nefe? loti loga o gedae. ");
INSERT INTO snp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Loga o gedato, Pitakafo neta kami yamu kala ki minaito, Ounakafo eti loto loumami, Saimoniyo, we tili (3) moni wili kede minae. ");
INSERT INTO snp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aya wenenawa ya namokafo gilifi meloneto ya amoki unae, loto kaka lele kiyámoto, nedito lomageto lakoina walo, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ka loumutaito, Pita minadoka lumuto eti loto logimami, We ma monila wilimo amo we yama minowe. Linate ya nediye loti ae? loto loga o gedaito, ");
INSERT INTO snp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","wewa yate eti loti loumamo, Kimiwe wani hadeti (100) mau wiyamo kiyabani we Koniliusikafo lilifi melaito one. Amo ya efe limo mona meleto Goti koliya kolami we nemo ya Yuda wenena muki amomu kolamo lalo kolae. Lalo kolato, enisole felegaga nemo makafo oloto pi umuto eti loto loumami, Pita ka lenami kolinune, loto amodoka gilifi melaito uti ilimiti ato ya Pita numugau enaiye, loto loumaito, kolito lilifi melaiye, loti loumae. ");
INSERT INTO snp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Loumato, Pitakafo numugu idalo, loto nasafili o gedaito, yalo onato ko lito Pitaki ido wemomowaki Yopa numudoti Yesu mono wenenala malekaki lakoina wae. ");
INSERT INTO snp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ena uti ya kanudo onoti uto Sisalia numudo u fedato Koniliusikafo wenenala ido auwa-mota olu mau wi gedaito, kiyabani minato ");
INSERT INTO snp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","o fedato, Pitakafo numugu dinae, loto kanugu idaido Koniliusi oto oune-lune-kane umunae, loto kiyanalo kiyana umola fiyaifa, ");
INSERT INTO snp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pitakafo olu nedi edeto eti loumami, Neido. Namo yaki fa we yako minowe, loto loumaito, ");
INSERT INTO snp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","lokoli-fakoli oti, numugu diti wenena mau minamo ya geyaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Geyeto eti loto logimami, Linate lamo Yuda wenena monate ya koli minama ne. Lo fukamo monate ya ailo feka wenenaki ekelámoti, ido numunigu yaki idámalo, loto lo fuko ledetami ne. Etito nemo nefa, Gotikafo we ma ya fuma wiyami ido mo ádami ne, loto ádo, loto nilibaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yamu ano, lageto ya kane lele kiyámoto owe. Ido lune fiyanimo monawa ya lageto kolinae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Logimaito, Koniliusikafo itibito eti loto loumami, Neta oloto pi nedami ya eyeto sini kamena fo (4) onotowe. Netawa yamu ka lokumunagolowe. Aya kamenalo lunaga tili (3) kilokulo ya numuneu Goti loumu minoneto moda ayalo ya we makafo ukanalo owo lamena imo wiyami we ya namodoka omunelo oloto pito eti loto lonomami, ");
INSERT INTO snp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Koniliusiyo, Goti ka loumanimo ya kolito, ido neta ko ánamo wenena neta-mata gimanimo monaka ya kolaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yamu Yopa numudo wemomo gilifageto Saimoni kuliya ma Pita ya ilimiti enawae. Amo lilafo Saimoni bulumakau atuwa olufe lo-lo imo we numunau kuwo no anawaleka akaila minaiye, loto lonomaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eti lonomaito, ayalo wenena gilifoneto kamodoka wato ya kamo kane kolito animo yamu sene-muluneu lalo iye. Ido lamo ya oto ama Goti omunalo olu mau wito minonimo Wekolakafo kamo ka logimo, loto aumafofo loto lokomami yama lageto kolinune, loto loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ena Pitakafo apito eti logimami, Goti ya wenena iya meleto eika wiyámaifa, ");
INSERT INTO snp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ido wenena muki nedo-nedo ufa monalo-monalo koliya kolinawamo ya ido monani efe loti mele minamo wenena ya koina wi gedaiye. Kawa onale, loto oiya kolife loto kolowe. ");
INSERT INTO snp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ido kawa Gotikafo Isilaeli wenena fulo ledami ka ya Yesu Kilistokafo olu you lo ledami ka ya lo oloto melaiye. Wewa ya mikau-mikau wenena muki Wekolate ya ne. ");
INSERT INTO snp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ido kana Galilika Yonikafo noku wi-wi imo ka ya lo oloto melaito, aiga Yudia eba nedo-nedo neta muki o fedami ya moda koli minama ne. ");
INSERT INTO snp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Koli minama ya Gotikafo Yesu ya Nasaletekati ami we lonone olunaiye, loto Felegaga Ounaki ido aumala nabaki umuto, ido Goti ya mino edainako, mika nedo-nedo uto oto wenena lalo o gedeto, ido Satanikafo olu kopaitami wenena muki ya olu faka lo gedami kawa linate muki moda koli minama ne. ");
INSERT INTO snp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ido lamo omudekafo Yelusalemu numudo ido Yuda wenena mikaninalo neta muki oto melami ya moda eyonimo ne. Ido yá yofolo ofo folafa, ");
INSERT INTO snp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","fo kamena tili (3) yalo ya Gotikafo folaiguti kofa olu nedi edeto oloto pi lomaifa, ");
INSERT INTO snp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ido wenena muki ya eyámae. E’e, wenena iyaina o ledami wenena yako ya folaiguti neditaito, wete-neta amoki lakoina nonimo ya oloto pi ledami ne. ");
INSERT INTO snp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Amokafo ka gedimo eti lolomami, Wenena muki ya lo oloto meleti gimalo. Ido Gotikafo wenena folamoki ido omuni kofawa minamo wenenaki lifimani itibito giminane, loto iya melami wewa namo ya minowe, loto logimalo, loto lolomaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ido polofete muki yate amomu eti loti lamo, Wenena muki koli kikito umamo ya kuliyalo lifimanina kilili o gedenami ne, loti lamo ne. ");
INSERT INTO snp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitakafo kawa lo minaito, ya muki koliti minamo wenenadoka Ouna Felegaga oto mino gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mino gedaito, ido Yuda wenena koli kikitamo ya Pitaki lakoina amo yate Gotikafo ailo feka wenena ya Felegaga Ouna moda gimami ya koliti elegiti naba ae. ");
INSERT INTO snp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Eleigi ato, ido wenenawa ya luwa-lawa ka mona-mona loti Goti ebola lomo wamo ne. Ena Pitakafo eti loto limo, ");
INSERT INTO snp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Wenenawa Felegaga Ouna mino ledami yaidana oto moda mino gedainako, yamu nokafo noku wi gedenune, loti ya kemakafo mono noku wi gedenawamo kanu ya ku gedenagoliye? ");
INSERT INTO snp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yamu Yesu kuliyalo noku wi gedalo, loto auma wito logimaiye. Logimaito, ena kamena maleka lamoki mino ledo, loti loumae. ");
INSERT INTO snp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ido aposoloki ido Yesu mono wenenala Yudia mikau-mikau minamo yate ailo feka wenena yaki Goti kala ya koliti kolife loti kolae, loti lamo kawa kolae. ");
INSERT INTO snp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Yamu Pita Yelusalemu numudo itibito wito Yuda wenena koli kikitamo yate eti loti loumamo, ");
INSERT INTO snp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kamo ya Goti ainala ukanigu fukámamo wenena numunigu dito wetineta lakoina namo ne, loti oudae. ");
INSERT INTO snp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Oudato, Pitakafo neta muki oloto pi umami neta ya efe loto eti loto logimami, ");
INSERT INTO snp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Etito namo Yopa numudo minoto Goti loumu minodo ya famoidana komo ya neta ma lafo-lafo naba yaidana kosinauti onawalo filiga-filiga olato, namodoka lomaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Netawa lomami lulau yau komo ya numudo yafo ani-kiyani fo (4) nemo, kefa fadena ido koiyofa-aiyofa, nema-afa kosinalo moinamo, muki ya eyowe. ");
INSERT INTO snp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ido kolomo ka nola makafo eti loto lonomami, Pitao, nedito neta auwa ofoto no, lonomaifa, ");
INSERT INTO snp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","itibito ya loumomo, Wekolao, e’e, namo neta fuma wiyami mo ádami neta ya ánenamo omo ne, loto loumowe. ");
INSERT INTO snp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Loumoneto, ya ka nolamakafo kofa eti loto lonomami, Neta ma Gotikafo olu mo lotami neta yamu mo ádami ne, loto ádo, loto lonomaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eti lonumuto ido netawa ya ayamaidana oto kamena tili (3) oloto pitoto ya ayalo ika oto itibito kosinauka idaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ayalo ya we tili (3) makafo Sisaliakati gilifi namo minodo melami we ya numunalo minodo ya o fedae. ");
INSERT INTO snp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O fedato, Ouna yakafo amoki unune, lotoma kaka lele kiyámoto lakoina walo, loto lonomaito, mono wenenane sikisi (6) yaki lakoina uto Koniliusi numunau yau muki idone. ");
INSERT INTO snp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Idogeto, amokafo neta fede umami mona ya lolomami etito ne. Enisole yakafo numunau oloto pi umuto eti loumami, Kamo Yopa numudo gilifageto Saimoni, kuliya ma Pita ilimiti ato ");
INSERT INTO snp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ka lageto kamo ido wenenaka yaki kolato, kawa yamo olu omudi kenagoliye, loto loumaiye, loto lolomaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eti lolomaito, namo ka apito logimodo ya Ouna Felegaga kana lamodoka lomami yamaidana oto amodoka lomaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lomaito, Wekola ka limomamu kofa kane kiyoneto amokafo eti limo, Yoni ya nokafo noku wi gedaifa, Goti yamo Ouna Felegagakafo linate noku wi gedenaiye, loto limo ne. ");
INSERT INTO snp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Etito nenako, lalimo Wekola Yesu Kilisto koli kikito umonimo Gotikafo Ouna Felegaga lomami yamaidana oto gimagetoma ya namo ya egaidana oto Goti, E’e, loumuto kanu ku gedenamo ne? loto loga o gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ka limo kolititi odunawamo ka ma minámaito, Goti ebola loti eti lamo, Gotikafo ailo feka wenena yaki omuni kenawae, loto seni-muluni olu eleyapa winawamo mona gimami ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ena Sitifeni ofo fulamo kamenalo koli kikitamo wenena keina naba-naba kolato, giyadato faiga upatoto uti Fonisia ebau, Saipulusi mikau ido Antiyoku numudo wamo ya kala kuwa Yuda wenenako logimimo wae. ");
INSERT INTO snp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eti afa, ido maleka Saipulusi ido Sailini ebalekati amo we yate Antiyoku numudo uti Giliki wenena yaki Wekola Yesu kala kuwa logimomo wae. ");
INSERT INTO snp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Logimimo wamo Wekola aumala ya mino gedami yamu wenena naba-naba seni-muluni eleyapa witi Wekola koli kikito umae. ");
INSERT INTO snp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Koli kikito umato Yelusalemuka monolo mau wi-wi amo wenena ya kawa koliti Banabasi ya ilifi melato, Antiyoku numudo wiye. ");
INSERT INTO snp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","U fedeto Goti nasafili o gedami mona ya eyeto siya-mulunau lalo kolito, ya kamena-kamena Wekola auma witi koli kikito umutiko minalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Logimami we ya we lalo neto siya-mulunau Felegaga Ounakafo mino ede faitito, ido koli kikila naba ne. Ido wenena naba-naba gilimaito, Wekoladoka ekelae. ");
INSERT INTO snp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ena Banabasikafo Solo ya moni wilinae, loto Tasusi numudo uto ");
INSERT INTO snp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","olu oloto pito, ilimito Antiyoku numudo itibito oto, melege lawokolo wewa lelema ya monolo mau wi-wi amo wenenaki lakoina olu mau witi wenena naba-naba ya api gilibi-gilibi minaiye. Ido kana Antiyoku numudo yalo Yesu ege melamo we ya Kilisto wenenalale, loti kulini melae. ");
INSERT INTO snp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aya kamenalo polofete maleka Yelusalemu numudoti oti Antiyoku numudo o fedae. ");
INSERT INTO snp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","O fedamo minaguti we ma kuliya Agabusi ya Ouna yakafo welalo melaito eti loto logimami, Lomu mika negu-negu kadunamu naba-naba oloto pinagoliye, loto logimaiye. (Ido kadunamuwa naba-naba ya aiga kiyaba we wenaba Kolodiusi kamenala yalo ya oloto piyaiye.) ");
INSERT INTO snp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ido Yesu ege melamo wenena yate mono wenenate Yudia minamo ani olu faka lenune, loti linanimo muki netani yauti ma iya meleti giminawamo neta ya olu mau wiyae. ");
INSERT INTO snp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Etiti giminawamo netawa ya Banabasite Solote anido meleti, mono kiyabani we ya gimailo, loti gimiti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ena aya kamenalo ya gamani kiyaba we wenaba Helotikafo monolo mau wi-wi amo wenena ya keina naba giminae, loto maleka ani-kiyanido oluto nelalo fulo gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Eti o gedeto ya Yoni yalafo Yemusi ya emi fanakafo ofo folalo, loto kimiwe logimaito ofo folae. ");
INSERT INTO snp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ofo folato, ya Yuda wenena eyeti lalo kolamo ya geyeto kimiwela Pita yaki ana-kiyanalo olaiye. Olami Yuda wenena foli kamenanina ya beleti olufe loti fudenami neta yisi melámoti faifa kiti no-no amo foliwa yalo olami ne. ");
INSERT INTO snp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Olaito, ya kimiwe mau fo (4) minamo anido melaito ya kiyaba o ede minae. Ido mau muki yau kimiwe fo (4) minae. Etiti minato, Helotikafo Goti Elita O Gedami foliwa fuli lageto ya wenena muki omunido olu kalo mele edenae, loto kala kiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kala kiyaito, Pita ya nela numugu minaito ido monolo mau minamo wenena Pita yamu koliti Goti auma witi loumu-umu o minae. ");
INSERT INTO snp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Eti o minato, Helotikafo, Leda wenena omunido Pita olu kalo mele edenae, loto kolami kamenalo yalo luwaila sinidigu yau kimiwe lele filiga-filiga minoti kiyaba o edaigu muliti ya Pita oku ono minaito, ya auma wiyami nela lele ainikafo olufe lamo yakafo nela wi edeti, ido nela numugu kanu welalo ya kimiwe maleka kiyaba oti minae. ");
INSERT INTO snp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ena Wekola enisolela ma kaita o oloto piyaito, nela numugu lamena naba-naba ito, ido enisolekafo Pita ukanalo ofoto eku oto, Alako neido, loto loumaito, ayalo ya Pita analo ya auma wiyami nela kulalu oto mikalo olumo wiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ido enisolekafo loumami, Ukagalo owo wito kiyagalo winanimo neta wiyo, loumaito, kala meyalo melaiye. Ido ukagalo owo mulalo wi-wi animo ya wito nege ano, loumaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Loumaito, nela numuguti Pita ege wito, Netawa ya ona fede nomámaiye. Faifa famoidana kowe, loto kala kiyaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kala kiyaito, lelema ya kimiwe kiyaba o edeti minamo we ya fulo gedeti uti uti, kimiwe liliga kiyaba o edeti minamo yaki fulo gedeti uti kanu gedimo ainikafo olufe lamo ya wenena numuna meya nabaleka unuwe, loti wiyamo kanu yalo o fedaito kanuwa aimolakafo kanu wiyaito, ya lumuti feka uti kanudo lakoina waido yaloti kaita enisolema fulo edeto wiye. ");
INSERT INTO snp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Utaito, ya Pitakafo kolami, Namo oiya ya netawa ya moda ona fede nomaiye, loto kolife loto kolowe. Ido Gotikafo enisolela ilifi namodo meleto Heloti anauti ido Yuda wenena neta nosámami eti o nedenagili kani kiyagu yauti moda efili nedaiye, loto kolaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Eti loto kolami ya Yoni, kuliya ma Maki, olafo Malia numuna yalo ya wenena naba mau witi Goti loumu minado ya uto ");
INSERT INTO snp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","numuna kila kanudo kesoba wiyaiye. Kesoba wiyaito, kouba-naba nomili ma kuliya Loda yakafo kanu winae, loto aifa, ");
INSERT INTO snp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pita nola ya kolitoto siya-mulunau lalo naba kolami yamu kanu wiyámoto faifa itibito oluloto uto, Pita ya kanudo minaiye, loto logimaifa, ");
INSERT INTO snp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ido, Kudu-kudu kilane, loti lae. Eti loti lafa, ido, E’e, ona logimowe. Amo ya ne, loto ilulu kuto logimaito, amo yate, Enisolela ne, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eti lato, Pitakafo kanu kesoba ilulu kuto wi minaito, ya kanu witi eyeti elegiyae. ");
INSERT INTO snp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Elegiti minato, ya amokafo, Ka ádalo, loto anakafo mebe-maba o gimito ya Wekolakafo nela numugu yauti ilimi feka itami mona logimaiye. Logimami ya Yemusiki ido koinatefo-mota yaki netawa yamu logimalo, loto logimito fulo gedeito eba mauka wiye. ");
INSERT INTO snp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ena ko lito nela numugu kimiwe yate, Pita egau wiye? loti lo yaleka waka oti ya koli naba-naba koli minae. ");
INSERT INTO snp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Koli kolato, Helotikafo lito ya auma witi moni wili edafa, olu oloto piyámato, ya kimiwe kiyaba o edamo ya loga-miga o gedeto ya gini folalo, lito eti o gedae. Eti o gedato, Heloti Yudia mikalo fulito Sisalia numudo uto yalo minaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heloti ya Taiya numudo wenenate Saidoni numudo wenenate moila fiyaito, wenenawa yate luni-kani olu lawoko meleti amoki lokoli-fakoli minenune, loti kolae. Eti loti koliti, komu ya Heloti numuna kiyaba we Bilastusi ade olu faka lenaiye, loti uti kala olae. Kala olamo ya ayau eba Heloti kiyaba o gedami wenena konuma kobina lumu-lumu anako amoki fina fiyámenune, loti you amene mona mele ledo, loti Heloti nedo unune, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eti lato, kamena melami aya kamenalo Helotikafo kiyaba we wekudi ekeinala ya wito folomolalo amedoto minoto wenena ka logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ka logimaito, wenena yate, Aiyo, amo ka limo ya wenena kani minámaiye. E’e, ya goti kala ne, loti au naba lomo wae. ");
INSERT INTO snp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Etiti au lato, Heloti ya Goti ebola ádainako, ayalo Wekola enisolelakafo ofaito koiyofa-lenipate ukana lulau nato folaiye. ");
INSERT INTO snp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Folaito, Goti kala ya u naba uto upatomo wiye. ");
INSERT INTO snp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ido Banabasite ido Solote lononi olami fuli lito Yelusalemukati oti Yoni kuliya ma Maki ya ilimiti itibiti aiye. ");
INSERT INTO snp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ido Antiyoku numudo yalo monolo mau wiyamo wenena minagu ya kala kuwa lalo lo oloto melamo we ido ka mono api gilibamo we minae. Aya wewa kulini etito ne: Banabasile, ido Simeyoni ya kuliya ma Nigele, ido Sailinikati ami we Lusiusi yale, ido Manaini ya amo kipa minami kamenalo kiyaba we wenaba Helotiki lakoina minoto naba idami we yale, ido Solo ya ne. ");
INSERT INTO snp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Etito Wekola ouni-luni-kani umuti konuma ánoti moi witi minamo kamenalo Ouna Felegagakafo, Banabasite ido Solote lonone olunawaiye, loto logimomo yama ya linate lelewa ya fokiti iya melalo, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yamu konuma ánoti moi witi Goti loumuiti anikafo atenido meleti gilifi melae. ");
INSERT INTO snp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ouna Felegagakafo etito lelewa gilifi melaito, ya uti Selusia numudo akaimaleka fedeti sipiku diti uti Saipulusi mikau ya kuwo no muliti nedo ya uti, ");
INSERT INTO snp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamisi numudo fedeti, Yuda wenena mono numunigu Goti kala ya lo oloto melaito, ido Yoni yaki lakoina minoto ya ani olu faka limo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Etiti nokafo olu ogona imo mikau ya moni fuli loti u Pafosi numudo fedeti yalo ya Yuda we ma kibe lusa ki-ki imo suki polofete ma kuliya Ba-Yesu, ido kuliya ma Elimasile, loto nemo wewa ya katula aiye. ");
INSERT INTO snp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wewa ya aya ebau kiyaba we wenaba Segiusi Paulusiki lakoina minaito kiyaba we wenaba ka manenau nemo we yakafo Goti kala ya kolinae, loto Banabasite ido Solote ka fulo gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ka fulo gedaifa, Elimasi ya kuliya mona ya kibe lusa ki-ki imo we yakafo wewa lele ya kuwonibo buluto kiyaba we wenaba ya koli kikitimo monaleka yati olu eleyapa wi edenae, loto lono olaiye, ");
INSERT INTO snp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lono olaifa, ido Solo, kuliya ma Polo, ya siya-mulunau Ouna Felegaga mino ede faitimo yakafo Elimasi efe loto kogo eyeto eti loumami, ");
INSERT INTO snp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Kamo ya Satani nomilipala minane. Ido mona-ana efe limo mona muki ya kuwolafo minane. Ido kote wiyanimo monaki, nosámami netaki yakafo ukagau faitimo ne. Wekola monala lalo ya olu kopa omo wanimo monaka ya fulitámenabe? ");
INSERT INTO snp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kamo eti o-o minaninako, oiya Wekolakafo kofageto omuga likoto minoto ya kamena ma yaloti fo limo ya ágenagolane, loto loumaito, ayalo amodoka ya limuki ido sinidimoki ya aito omuna likaito anakafo kanu moni wilito analo oluti kanu ilibinawamo wenena moni wili-wili o minaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Netawa oloto piyami ya kiyaba we wenaba yakafo eyeto ido Wekola kala api ilibamo ka ya kolito elegito koli kikitiye. ");
INSERT INTO snp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ena Poloki lakoina moinamo wenenala yaki Pafosi numudo fuliti sipiku kofa diti uti Pamufilia mikalo Pega numudo fedato, yaloti ya Yoni fulo gedeto itibito Yelusalemu wiye. ");
INSERT INTO snp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wito, Pega numudokati uti Pisidia mikalo Antiyoku numudo fedae. U fedeti Sabati yalo Yuda wenena mono numunigu diti amedoti minato, ");
INSERT INTO snp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ido wemakafo lo melami ka ido polofete lufuwa wiyamo ka yauti ya kato fuli lito mono numuna kiyaba we yate ka fulo gedeti eti logimamo, Mono wenenate-motao, olu auma wi ledenami ka ya logiminune, loti kolitima kawa ya lolomalo, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Eti logimato, Polokafo nedito anakafo mebe-maba oto eti logimami, Linate Isilaeli wenenaki ido ailo feka wenena Goti koliya kolamo yaki ka lenagolomo ya kolalo. ");
INSERT INTO snp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lamo Isilaeli wenena Gotite yakafo lamo aute-mota kolofate ya iyaina o gedeto, ido Isipika wau uti minamo kamenalo ya kipa ufa fito ya olu mau naba-naba wi gedeto, aumala aumafofo limo yakafo ebawa yaloti gilimito wimo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Etito gilimito fafato mikalo wito melege foti (40) yalo ya minomo wamo wenenawa mona nosámami melafa, kiyaba lalo o gedemo wimo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Etito ya ido Kenani mikalo wenena afo monalomonalo seweni (7) ya minamo ya ginito mikani ya oluto wenenala gimami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gimaito, ya minomo wamo melege fo hadeti fifiti (450) yaidana olu fuloti minamo ne. Etiti minotiti wenenane ya kiyaba o gedenawae, loto kiyabani we ya olu oloto pi gimi-gimi omo polofete Samuweli kamenalalo wiye. ");
INSERT INTO snp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ido aya kamenalo ya Isilaeli wenena yate Goti eti loti loga o edamo, Kiyabate we wekudi kiyaba o ledenami we ma lumunabe? loti loga o edato, Benisamini ufa fiyaigu yauti ya Kisi nalafo Solo ya olu oloto pi gimaito wewa kiyaba o gedemo melege foti (40) ya wiye. ");
INSERT INTO snp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Etito kiyaba o gedaito, aiga Gotikafo Solo olu fulo edeito ya Defiti kiyabani we wekudi mino gedenaiye, loto olu oloto pi gimaiye. Gimami we yamu eti limo, Yesi nalafo Defiti kala kiyami ya namo kane kiyomo yamaidana oto nenako, eti enaiye, loto namo senemulune kolomo neta muki ya meyalo melenagoliye, loto ka mono lufuwau (Sng 89:20) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Eti loto ido lo mele ledami kala ya kulawa linaiye, loto wewa ufa fiyaigu yauti lamo Isilaeli wenena olu omude kami we Yesu ya lomami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ido komu Yesu ámami kamenalo Yonikafo Isilaeli wenena muki seni-muluni eleyapa witi mono noku wi fuli lenawae, loto lo oloto melemo wimo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ido mono lonola ya fuli lenagolito ya amokafo eti loto loga o gedami, Linate kolamo ya namo kema ne, loti kolae? Namo wewa ya minámowe. E’e, aiga enami we ya namo efe yamo kiyanalo wiyami netala olu fulo edenamo ya efe ádenagoliye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mono wenenane-motao, linate Abalahamu nakulafo-mota minamo yaki linate ailo feka wenena Goti koliya kolamo yaki lamodo kawa olu omude kenami ka ya fulo ledami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yelusalemuka minamo wenenaki, ido kiyabani weki ya Yesu efe loti eyámamo ne. E’e, ido aya wenenawa ya Yuda mono numunigu SabatikuSabatiku ya polofete lufuwa wiyagu yauti katoti koliti o-o minamo wenena ya Yesu ligiya loumado ayalo ya polofete ka lamo ya olu wiyami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wenenawa Yesu ofo fulunawamo ka ya moni wilamo olu oloto piyámafa, ofo folo, loti Pailati ilulu kuti loumamo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ido amomu polofete yate ka mono lufuwau wiyamo neta muki yama o ede fuli loitato, ege melamo we yate kono ukana ya yá yofoloti oluti uti kifana lulau mele edamo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mele edafa, Gotikafo folaiguti olu nedi edaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Olu nedi edaito, ido komu Yesu ofo folámamo kamenalo Galili mikalo fulito Yelusalemu wimo kamenalo amoki lakoina wamo wenena ya Yesu fulutoto kofa nedami we ya kamena so loto oloto pi gimaito eyae. Oiya aya wenenawa yate lamo Isilaeli wenenate Yesu kala kuwa lo oloto mele-mele logimae. ");
INSERT INTO snp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Yesu kala kuwa lalo ya logimoge. Gotikafo Yuda wenenate autefo kolofate-mota ya giminae, loto adeina auma wito lo mele gimami yama ");
INSERT INTO snp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yesu folaiguti olu nedi edaido yalo nanibo-mota minonimo yaki ailo feka wenenaki auma wito lo mele gimami kala oiya moda olu kulawa o ledetaiye. Yamu Gotikafo eti loto limo, Namo ya onema kamo kedoneto, ya nanimo Nanefo ya minane, loto ka mono lufuwau (Sng 2:7) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ido Gotikafo Yesu folaiguti olu nedi edainako, ukana aumala fitala kiyámenami ne, loto kawa ya onale, loto lilibami ka ma Goti ya eti loto limo, Namokafo komu Defiti felegaga neta lalo ona nemo neta yama kumunae, loto lo melomo netawa yama linate giminae, loto ka mono lufuwau (Ais 55:3) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yamu eba maleka eti limo, Kamokafo felegaga we ya ukana aumala fitala kiyámenaiye, loto auma wito lane, loto ka mono lufuwau (Sng 16:10) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ido Defiti kofawa minami kamenalo ya Goti kalalo meyalo meleto wenenala minagu ya lono olumo uto folageto aulafo-mota mele gedagu ya mele edato kono ukana fitala kiyami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nefa, ido wewa ama ya Gotikafo olu nedi edami we ya kono ukana fitala kiyámami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yamu wenenane-motao, Yesu neta imo yakafo lifimate ya kilili o ledami ka ya lo oloto mele gimonimo ya kolinagilae, loto kolone. ");
INSERT INTO snp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ido Mosese lo melami ka yakafo nosámami mona-ana muki kilili o ledeto monanina efe limo wenena minae, loto lo ledami ogoufámami yama wewa yakafo koli kikitamo wenena muki ya lifimani kilili o gede fuli loto monatina efe limo wenena minae, loto lo gedami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ido polofete lo melamo ka ya linatedoka gimitenaiye, loto koti moinalo. Kawa ya eti lamo, ");
INSERT INTO snp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Linate Goti kamana kiyamo wenena ya kolalo. Namokafo linate minamo kamenalo neta enamo yama makafo netawa logimami neko, koli kikito umámagi ne. Netawa enamo ya linate eyeti kati ligi-ligi kiti u kopa walo. loti ka mono lufuwau (Hab 1:5) ya nemo ne, loto Polokafo logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ena Polote Banabasite Yuda wenena mono numunani fuliti unagilaido wenena yate eti logimamo, Kofa Sabatiku ya itibiti oti ka maki enu witi lolumunawaiye, loti logimae. ");
INSERT INTO snp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Logimiti wenena mau naba mono numuniguti lumuti Yuda wenena so loti ido ailo feka wenena Yuda mono auma witi kolamo yaki Polote Banabasite gege wato, lelewa yate kani oluti Goti nasafilila mona ya fulitámoti olu kikito minalo, loti logimi minaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ena Sabati ma o fedaito, wenena so loti numuna meya nabau minamo ya Wekola kala ya kolinuwe, loti oti mau naba wiyae. ");
INSERT INTO snp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mau naba wiyamo ya Yuda wenena yate geyeti komumu witi, Polo ka limo ya wi fuko edeti kamana kiyae. ");
INSERT INTO snp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Eti ato, Polote ido Banabasite kolini kolámoti eti logimami, Yuda wenena Goti kala komu logiminune, loto moda logimitoto nefa, kawa koli kikito umámoti meti umamo linanimo ya omude kofawa minowa-minowa oto minomo dinumo ya ogoufámone, loti lanako, lamo ya fulo gedeto ailo feka wenena minado yalo unagoloiye. ");
INSERT INTO snp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yamu Wekolakafo eti limo Namokafo linate mikau-mikau uti olu omuni kenawamo ka logiminawae, loto ailo feka wenena seni-muluni lamena o gedenawamo wenenane ya gilifi melowe, loto ka mono lufuwau (Ais 49:6) ya nemo ka auma wito lolomaiye, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ido ailo feka wenena kawa ya koliti senimulunigu lalo koliti Wekola kala ya lalo ne, loti lamo wenenawa ya omuni kofawa minowaminowa oto minomo dinagilae, loto iyaina o gedeitami wenena ya koli kikitae. ");
INSERT INTO snp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ido mikau-mikau ya Wekola kala upatoto wifa, ");
INSERT INTO snp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ido Yuda wenena yate Goti koliya kolamo wenaipa kulini nemoki ido numudo wenabanina yaki ile fali senigu wiyato, Polote Banabasite kamani kiti olu keina naba o gedeti ebanidoti giyadato wami ne. ");
INSERT INTO snp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Giyadanako, ya wewa lele kiyanido momupa itili fuliti Aikoniyamu numudoka waiye. ");
INSERT INTO snp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Uti Yesu ege melamo wenena ya alikani naba-naba ato, ido Ouna Felegagakafo seni-mulunigu faito mino gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ena Aikoniyamu numudo Polote Banabasite ayaida oti Yuda wenena mono numunigu diti lo oloto mele gimaito, wenena so loti Yuda wenenaki ailo feka wenenaki ya ka lami koliti koli kikitae. ");
INSERT INTO snp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Eti afa, Yuda wenena koli kikitamo yate ailo feka wenena ile fali senigu witi Yesu wenenala yamu seni kala-kala lageto koli nosámami giminawae, loti kani fiyae. ");
INSERT INTO snp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Etito Polote Banabasite ya aya ebawalo ya kamena fana minoti kolini kolámoti Wekola yamu auma witi logimimo waiye. Eti o minaito, ya Wekolakafo nasafili o gedami kala kolinawamo wenena kawa ona kulako ne, loto kolinagilae, loto aumala gilibami neta monamona olu oloto pi giminami auma ya we lelewa gimaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gimaito, numuna meya nabau minamo wenena fokiti maleka ya Yuda wenena amodoka ekelato, ido maleka ya aposolodoka ekelae. ");
INSERT INTO snp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Eti ekelato, aiga ailo feka wenenate, Yuda wenenate ido kiyabani weki yate lelewai olu keina gimito kifanakafo gini fulunune, loti kudawani ki minae. ");
INSERT INTO snp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Etiti kudawani ki minato, Polote Banabasite kawa ya kolititi koli uti Likonia mikalo u fedeti Listila numudo ido Debe numudo ido numuna eba ma mino adu ekeleto nemo ebau yaki moniti ");
INSERT INTO snp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","kawa kuwa lalo ya logimimo waiye. ");
INSERT INTO snp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ido Listila numudo yalo we ma olafo mulunauti kiyana galidimo ya kanu ogofuto moinámami we ma ne. ");
INSERT INTO snp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aya wewa ya Polo ka logimami ya koli minaito, Polokafo efe loto eyeto kolami ya wewa Yesu koli kikito umaito, olu faka lo edenaiye, loto kolito ");
INSERT INTO snp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ya lula fito eti loumami, Kiyaga leya wito neido, loto auma wito loumaito, ayalo satomo akaiya wito apito kanu moinaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kanu moinaito, ido wenena mau naba yate Polo neta imo ya eyeti au loti eti lamo, Aiyo, goti ya wenena ukade yaidana oti bulamo ya lamodoka lomae, loti Likonia kanidokati au loti lae. ");
INSERT INTO snp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ena Banabasi ya suki goti kuliya Susile, loti melae. Ido Polo ka lo fukoto lo-lo imo yamu suki goti kuliya Hemesile, loti melae. ");
INSERT INTO snp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ido suki gotinina Susi mono numunala ya numuna meya naba kilala feka ya ne. Ido suki goti Susi yokila ki umami weki, ido wenena mauki aposolowa lele yokila ki giminuwe, loti kolanako, yamu yokila ki giminami wekafo bulumakau weki ido ekeina neta-mataki oluto numuna meya naba kanu welalo ya aiye. ");
INSERT INTO snp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Etito aifa, aposolo Banabasite Polote kawa ya koliti ukanido owo ya fekaliti wenena naba mau minamo ya maunigu oluloti oti au loti lami, ");
INSERT INTO snp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Aiyo, linate nediti neta ya o minae? Lamo ya faifa we linate yaidana oto minoiye. Lamo ya kawa kuwa lalo ya lo oloto pi gimito linate suki goti kopa neta koli umamo ya fuliti eleyapa witi, Goti omuna kofawa nemo we mika kosina, kuwo no ido neta-mata mona-mona yau nemo ya olu oloto piyami wema ya ekelenawae, loto logimoiye. ");
INSERT INTO snp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Komu adeina amokafo wenena ya linanimoni monani ya melenawae, loto koitami nefa, ");
INSERT INTO snp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","aimola monala ya moda olu oloto pi lomaiye. Amo ya kosinauti ko fulo gedeto ido neta kifamo ilawa kula lenami kamenalo wenineta ya gimainako, yamu netawa eti imo yakafo kiyaba lalo o gedami monala ya gilibaiye. Gilibaito, linate koti seni-mulunigu alikani nabanaba ae, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Etito logimaifa, ido wenenawa yate we lele yokila ki giminagolone, loti ilulu kuwato, ido Polote Banabasite, koiya naba fiti, E’e, loti lo fuko gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ena Antiyoku ido Aikoniyamu numudokati Yuda wenena ma oti wenena kani fiyato, kifana fuloti Polo ofae. Ofamo ya fulutaiye, loti koliti ukana ya ika oti numuna meya naba kilalauti oluti feka wae. ");
INSERT INTO snp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Oluti feka wafa, ido ege melamo wenena oti olu ogona o edato, kofa nedito numuna meya nabau itibito uto leda ya Banabasite Debe numudo waiye. ");
INSERT INTO snp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ido Polote Banabasite kawa kuwa lalo ya Debe numudo lo oloto meleti, wenena so loti olu Yesu ege mele gedaiye. Ena itibiti Listila numudo, ido Aikoniyamu numudo, ido Antiyoku numudo o fedaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","O fedeti ya Yesu ege melamo wenena auma witi koli kikito umutiko minenawae, loti apito logimimo waiye. Apiti logimami ya eti lamo, Lalimo ya Goti wekudi wenenala kiyaba o ledami kilalau dinune, loto kolinumo ya mikalo amau komu ya keina so loto ya kolinumo ne, loti logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Eti logimiti Polote Banabasite, Monolo mau wi-wi amo wenena maunigu-maunigu yauti mono kiyaba we minenawae, loti we maleka iyaina o gedeti ido weni-neta moi witi minoti, Goti loumu-umu minotiti kiyabani wewa Wekola ya koli kikito umamo we ya analo ya melae. ");
INSERT INTO snp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Analo meleti Pisidia mikalo monimo uti Pamufilia mikalo fedeti, ");
INSERT INTO snp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pega numudo minamo wenena ya kala kuwa logimititi Atalia numudo lumuti, ");
INSERT INTO snp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","yaloti sipiku diti uti Antiyoku numudo fedaiye. Antiyoku fedami ya komu mono wenena ya wewa lele mono lono olunawami Goti nasafili o gedageto lonola olunawaiye, loti Goti analo melato, uti lonowa olumo utiti fuli lageto itibiti aya ebau kofa aiye. ");
INSERT INTO snp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","O fedeti yalo Polote Banabasite yate mono wenena ya olu mau wi gedeti Gotikafo lelewa ani olu faka loto auma wi gedaito mono lono olami ka logimiti, ido ailo feka wenena koli kikitamo kanu wi gedami ka ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Etito logimiti Yesu ege melamo wenenaki kamena fana lakoina minae. ");
INSERT INTO snp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ido wemomo maleka Yudia mikaloti oti Antiyoku numudo fedeti Yesu mono wenenala eti loti api gilibamo, Linate Mosese lo melami kala yauti api lilibami mona ya meyalo meleti Goti ainala ukadigu fukámenawamo ya olu omudi ágenawamo ne, loti api gilibi-gilibi o minae. ");
INSERT INTO snp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Etiti gilibanako Polote Banabasite wenenawaki auma witi moila naba fiyae. Kawa yamu Yesu wenenala yate Polote Banabasite lakoina koli kikitamo wenena maki ya iya meleti aposolo ido mono kiyaba we minadoka ya uti kama neta api gilibamo ka yamu lokoli-fakoli minenagilae, loti Yelusalemuka gilifi melato wae. ");
INSERT INTO snp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Etiti mono wenena ya gilifi melato uti Fonisia ebalo ido Samalia ebalo monimo uti ailo feka wenena seni-muluni eleyapa wiyamo mona yamu logimi-gimi omo wae. Kawa ya Yesu mono wenenala koliti seni-mulunigu lalo naba kolae. ");
INSERT INTO snp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Seni-muluni lalo ito, ido Polote Banabasite ya Yelusalemuka u fedaito, Yesu mono wenenalati, ido aposoloti, mono kiyaba weti yate aiyo-koiyo naba logimato, Gotikafo lonone olunaiye, loto mino gedaito lonola olamo ka ya logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Eti logimaito, koli kikitamo wenena ma Falisi we minaguti amo yate nediti eti lamo, Ailo feka wenena Goti ainala ukanigu fukoti Mosese lo melami ka olu meyalo melalo, loto auma wito logiminune, loti lae. ");
INSERT INTO snp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eti lato, ya aposoloki mono kiyaba weki kawa ya fokito kolinuwe, loti olu mau witi ");
INSERT INTO snp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","kamena fana ka lo yaleka waka o minato, Pita nedito eti logimami, Wenenane-motao, komu Gotikafo ailo feka wenena ya kala kuwa lo oloto melageto ya koliti koli kikito numunawae, loto linate minagu yauti namo ya iyaina o nedetami mona yama moda koli minamo ne. ");
INSERT INTO snp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Goti setemuludeu koli-koli imo wekafo kolami ya ailo feka wenena koli kikito numunawamo wenenane minae, loti ya kolinawae, loto Ouna Felegaga lomami yamaidana oto gimaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Etito gimami ya mona ailo mele gedeto, ido mona ailo mele ledámaiye. E’e, moda koli kikito umanako, lifimanina ya kilili o gedaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Eti nemo nenako, linate nediti Goti siya olu kala-kala lo edae? Lamoki ido autefo-motaki keina ya mofunumo ya ogoufámonimo keinawa ya nediti olu mofu gedae? ");
INSERT INTO snp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","E’e, etito minámaiye. Wekola Yesu Kilisto ya nasafilila yakafo olu omude kami yaidana oto wenenawa yaki olu omuni kaiye, loto koli minone, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Etito logimaito, mau minamo muki ya ka meto fulitaito minoti Gotikafo Polote Banabasite gimaito ya aumala gilibami neta ya ailo feka wenena minagu olu oloto pi gedami ka Polote Banabasite logimaito koli minae. ");
INSERT INTO snp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ka logimi fuli lito Yemusikafo eti loto logimami, Mono wenenane-motao, ka lomo ya kolife loti kolalo. ");
INSERT INTO snp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Gotikafo ya namo wenenane minenawae, loto komu ya ailo feka wenena minaguti aimola wenenala iyaina oto kiyaba o gedami mona ya Saimonikafo lolomaito kolone. ");
INSERT INTO snp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ido polofete yaki ka ayamaidana eti lamo, ");
INSERT INTO snp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Wekolakafo ka asa wito eti loto limo, Aiga namo itibito oto Defiti numuna lumu fou limo ya kofa kuto numuna u kopa wimo ya olufe lenae. ");
INSERT INTO snp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Yamu wenena liliga yaki ido ailo feka wenena nanimo wenenane minenawae, loto lo melomo wenena yaki ya Wekola moni wilinawamo ne. Ido ailo feka wenena nanimo wenenane minenawae, loto Wekolakafo netawa eti imo ne, loto ");
INSERT INTO snp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wekola komu adeinalekati netawa kolami we yakafo eti limo ne, loti ka mono lufuwau (Amo 9:11-12) ya nemo ne. ");
INSERT INTO snp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yamu kane-manene kolomo ya ailo feka wenena yate eleyapa witi Gotidoka wamo wenena ya keina gimámenune, loto kolowe. ");
INSERT INTO snp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Keina gimámoto ka fulo gedeto etito logiminuwe, Konuma-kobina suki gotinina gimamo ya ánalo. Ido kopa olu onámalo. Ido neta kenobalalo ipili witi ofo folamo ya ánalo. Ido wanu yaki ánalo, loto lufuwa wi fulo gedenune. ");
INSERT INTO snp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yamu adeinaukati numudo-numudo Mosese kala ya lo oloto mele-mele minato, ido oiya ya ayaidana oto Sabatiku-Sabatiku Yuda wenena mono numuni negu-negu ya katoto koli-koli o minone, loto logimaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ena aposolo ido mono kiyaba weki lakoina mono wenena mau naba muki yaki ka lo kifititi minagu yauti we lele ma olu oloto piti, Polote Banabasiteki lakoina Antiyoku numudo unawae, loti mono wenena kiyabani we ya kuliya Yudasi kuliya ma ya Basabasi, ido we ma kuliya Sailasi ya olu oloto piti lufuwa witi gimato oluti wae. ");
INSERT INTO snp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wato, lufuwawa wi fulo gedeti eti lamo, Aiyo, lamo aposolo ido mono kiyaba we ya mono wenenatina minonimo yate linate ailo feka wenena ya Antiyoku numudo minamo, ido Silia ebau minamo, ido Silisia ebau minamo, ya setinane, loto aiyokoiyo ka fulo gedone. ");
INSERT INTO snp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ena wenena ma lamodokati uti linatedoka u fedeti ka lamo yakafo seti-muludigu fiti kati-manidi ya olu kopaitae, loti lamo ka ya kolone. ");
INSERT INTO snp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Aya kawa ya kolito olu mau wito ka lo kifito sete-mulude olu lawoko meleto we maleka iyaina oto wewaki Polote Banabasite sete-mulude gimonimo weki lakoina linatedoka gilifi melone. ");
INSERT INTO snp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Wewa lele ya Wekola Yesu Kilisto lonola olainako, yamu wenena gini fulunune, loti igamu ae. ");
INSERT INTO snp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yamu Yudasite ido Sailasite yate wenikafo ka lufuwa wi fulo gedonimo yaidana oto logimato kolinagilae, loto gilifi melogeto wae. ");
INSERT INTO snp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ido lamoki Ouna Felegagaki ya keina maki olu mofu gedámenune, loto efe loto kolonimo yamu mona etiti logiminumo ya meyalo melalo. ");
INSERT INTO snp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ido suki goti ya konuma kobina ofo ki gimamo ya linate moi witi ánalo. Ido wanu yaki moi witi ánalo. Ido neta ma kenobalalo ipili witi ofo folamo yaki moi witi ánalo. Ido kopa-napa olu onamo mona yaki melámalo. Linate netawa-matawa ya ekena oti moninawamo ya lalo ne. Modae, loti ka lufuwa wi fulo gedae. ");
INSERT INTO snp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wemomoma ya gilifi melato, uti Antiyoku numudo ya lumuti mono wenena muki olu mau wi gedeti, lufuwama ya gimato, ");
INSERT INTO snp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","katoti koliti olu auma wi gedeti fulamo lufuwa yamamu seni-muluni lalo iye. ");
INSERT INTO snp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Etito Yudasite Sailasite ya polofete minoti ya wenena ya olu aila wi gedeti olu auma wi gedenune, loti ka naba logimi minaiye. ");
INSERT INTO snp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wewa lele ya kamena fana Antiyoku numudo minaito ya Yesu mono wenenala yate you amene mona ya mino gedenaiye, loti wenena gilifi melamo wenenadoka ya itibito unawaiye, loti gilifi melae.  ");
INSERT INTO snp_vpl VALUES ("AC15_34","074_15_34","ACT","15"