﻿USE sofia;
DROP TABLE IF EXISTS sofia.snp_lambau_vpl;
CREATE TABLE snp_lambau_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snp_lambau_vpl WRITE;
INSERT INTO snp_lambau_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu awalafo holofala mino liti uwabo ya hulitina feito ya ne. Yesu Kilisto ya Defiti hipa yufa figu yauti ya ne. Ido Defiti ya Abalahamu hipa yufa figu yauti ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamukafo Aisaka hedaibo. Ido Aisakakafo Yekopu hedaibo. Ido Yekopukafo Yuda yagi ido unalafo-mota yagi hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ido Yudakafo Pelesite Selate hedaibo ya hipawa loiti otinafo ya Tamali ya ne. Ido Pelesikafo Hesiloni hedaibo. Ido Hesilonikafo Lamu hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ido Lamukafo Aminadapu hedaibo. Ido Aminadapukafo Nasoni hedaibo. Ido Nasonikafo Salimoni hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ido Salimonikafo Bowasi hedaibo ya hipawa olafo ya Lahapu ya ne. Ido Bowasikafo Obeti hedaibo ya hipawa olafo ya Luti ya ne. Ido Obetikafo Yesi hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ido Yesikafo hiyabatina we wenaba Defiti hedaibo. Ido Defitikafo Solomoni hedaibo ya hipawa olafo ya homu ya Ulia olonafo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ido Solomonikafo Lehobowami hedaibo. Ido Lehobowamikafo Abiya hedaibo. Ido Abiyakafo Asa hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ido Asakafo Yehosafati hedaibo. Ido Yehosafatikafo Yolami hedaibo. Ido Yolamikafo Usia hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ido Usiakafo Yotamu hedaibo. Ido Yotamukafo Ehasi hedaibo. Ido Ehasikafo Hesekia hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ido Hesekiakafo Manase hedaibo. Ido Manasekafo Emoni hedaibo. Ido Emonikafo Yosaiya hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ido Yosaiyakafo Yekonia yagi ido unalafo-mota yagi hedaibo ya aya hamenalo ya Babiloni wenina himiwetina yasi Isilaeli wenina numunatinalo moloti idipiti uti ebatina Babilonika nala fi betiyabo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ido Babilonika nalalo uwabo hamena yalo ya Yekoniakafo Sealitiyeli hedaibo. Ido Sealitiyelikafo Selubabeli hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ido Selubabelikafo Abiyuti hedaibo. Ido Abiyutikafo Eliyakimu hedaibo. Ido Eliyakimukafo Asoli hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ido Asolikafo Sadoku hedaibo. Ido Sadokukafo Ekimi hedaibo. Ido Ekimikafo Eliyuti hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ido Eliyutikafo Eleyasa hedaibo. Ido Eleyasakafo Matani hedaibo. Ido Matanikafo Yekopu hedaibo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ido Yekopukafo Yosefe hedaibo. Ido Yosefe ya Malia wanafo ne. Ido olonafo Maliakafo Yesu hedaibo ya huliya Kilisto ne, loto ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Feti minabo, ya Abalahamu hedo molaibo hipa minado yaloti oloto piyabo weninawa fotini (14) weninawa feti oloto piti fuli uti-uti ato yoto-yoto aliga yalo Defiti oloto pibo. Ido Defiti hedo molaibo hipa minado yaloti oloto piyabo weninawa fotini (14) weninawa ayaidana oti oloto piti fulimo yowato, aliga yalo uwotinafo yasi Isilaeli wenina Babilonika nalau li fulo betiyato minabo. Ido Babilonika minabo hamena yaloti oloto piyabo weninawa ya fotini (14) weninawa oloto piti fuliyato, oloto piti fuliyato ayaidana fe minomo uwato uwato ena yalo ya aliga Kilisto oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ena Yesu Kilisto oloto pibo ha ya feito ne. Olafo Malia Yosefe wa molo edafa, u kelámaibo hamenalo ya Goti Weuna Fele yakafo mona molo edaito ya Malia olufola houmalau nebo ya wa edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Feti wa edámafa, ido wanafo Yosefe ya monala fefe liboma nenako, ya li ulalo holi edotanowe, loto yagunu hala auba ito kito momona oto ilifi fulitanowe, loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Feto loto idafawa yagunu hala ki neto ya moda Wenaba enisolela makafo wamoku oloto pi muto feto lomuibo, Defiti hipala Yosefeyo, ologafo Malia linowe, lotoma holi homámaneyo. Olufola houmalau nebo ya Goti Weunalokati nebo ya fele ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Fele neto ya hipala hedageto ya emokafo weninala lifimatina li mofuto li nomudina wanogolaiye, loto huliya Yesu ne, loto molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ena idafawa muki lo fedibo yagunu Wenabakafo ha polofeti welalo molaito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Holilo. Olu ma wegi unámibo olu ma olufola houmalau minoto hipala ma hedageto huliya ya Emanuweli ne, loti molanigilae. Ido huliya monawa ya Goti ya leimotegi ne, loto ha mono lufuwau (Ais 7:14) ya nebo hawa ya iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ena Yosefe unototo sinoito Wenaba enisolelakafo ha lomuibo ya welalo meyalo moloto olonafodo ya u kelámoto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","minomo uti uti yalo ya hipala hedaito, ya huliya Yesu ne, loto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yuda wenina hiyabatina we wenaba Heloti nebo hamenalalo ya Yudia ebauka Betelehemu numudo yalo ya Yesu ya oloto piye. Oloto pibo hamenalo ya moda fo yoidokati ha manadinau nebo we Yelusalemu numudo lo fedoti ya feto loti loga abo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yuda wenina hiyabatina we wenaba oloto pibo ya numuna igau ya ne? Ofiyala fo yoidokati yalo moda watoto ya huliya li faka loto weude-lute-hate munune, loto one, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Feto loti lato, ya wenaba Helotikafo hawa holito ya lula-halau hena aito, ido Yelusalemu wenina muki yagi ayaidana oti hena holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hena holi minato, ya Helotikafo Goti sokila hi muwabo we wenabatina yagi, ido wenina lo molaibo ha api itibi-itibi abo wegi muki li nuba o betito ya lobibo, Gotikafo hiyabate wehudi ilifi molaibo we Kilisto ya igalo oloto pinaiye? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","liwila oti lomuwabo, Yudia ebaleka Betelehemu numudo yalo oloto pinogolaiye. Ido polofetikafo lufuwa igu ya feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aiyo, Yudia mikau Yuda wenina numuna meya nabatina muki yauti ya Betelehemu numuna ya lumuto hefola efomako minámananibo ne. Aya numuna meya naba yauti ya hiyaba we wehudi ma loto, ya weninane Isilaeli wenina muki ya hiyaba o betinogolaiye, loto ha mono lufuwau (Mai 5:2) ya nebo ne, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Feto loti lomuwato, ya Helotikafo holito ya wemoli ha manadinau nebo we ya momona oto sutina fiye. Sutina fito ato, ya ofiyawa apito oloto pibo hamena yagunu loga-miga o betiye. Loga-miga o betito emotinasi lomuwato, holito ya lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hemotina Betelehemuka ya uti hipawa yagunu auba iti moniti wita oti li oloto pi edotima ya loti lonomato, nemo ya ayaidana oto uto huliya li faka loto weune-lune-hane munowe, loto unogolowe, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Feto loto lobibo ha ya holiti uti, ya moda ofiyawa homu fo yoidoka wa edabo ya u homu uto hipawa nedo uto yowaleka ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ofiyawama wa edoti ya lutina-hatinau ake ito holi dowa loti naba-naba holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ena numuguma yoti hipawa hefolate olafo Maliate wa betiti ya huba i edoti, huliya li faka loti, weudina-lutina-hatina muti minae. Feto feti minoti ya huwamenatina filoti idafa dowa muwabo, ya hefana mona huliya goli yagi, ido sokila ladanuwa aibo hiyabo huliya falagenesenisi yagi, ido yá nowala ladanuwa aibo huliya mulu ya muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Muwato, Gotikafo wamoku yau fuka ha ma feto lobibo, Heloti nedo liwila oti aguwámilo, lito holiti yagunu ya hanu maleka uti eimotina ebatinaloka liwila oti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Utato, ya moda Wenaba enisolela makafo wamoku yau Yosefe fedo muto feto lomuibo, Hemo sinoito hipa hefolagi, ido olafogi holi idipito Isipi ebaloka uto aya ebau ya minoto, ha hofa lobinobo yagunu hiyabane o minalo. Moda holabe? Helotikafo hipawa hofo fulinowe, loto wita anogolaiye, lomuito ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosefe sinoito hipa hefolagi, ido olafogi lubuka midipuku akaima idipito Isipi ebau wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Idipito yau wito yalo minomo yoti yoti, ya aliga Heloti fulibo hamenalo ya liwila oti Isilaeli mikau loti minae. Ido homu aidena Wenabakafo ha ma polofeti welalo molaito feto libo, Isipi mikauti ya Hipane sula fiyoto liwila oto aiye, loto ha mono lufuwau (Hos 11:1) nebo ha ya feito iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ena ha manadinau nebo wemoli eimotina ebatinaloka liwila oti hanu eito maleka uwato, ya Helotikafo, Hone iyae, loto holibo sebala hala-kala loitaito himiwe idipi molaito, uti Betelehemu numuna nabau ido numuna-amuna selo negu muki yauti wenina hipatina melege loiti li fulámabo hipa hefola muki ya hofo beti fulimo uwae. Feto fe betibo ya homu ha manadinau nebo we loga-miga o betito, wetinauti ofiya fedibo hamenawa lomuwato holibo yamagunu holi minoto feto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ena aya hawa ya polofeti Yelemaiyakafo libo, Lama numuna meya yau nola ma holiyabo ya hufo naba oto, Ei-ai, loto lula-halau naba-naba holibo ya wena Leselikafo yufa fibo weninala olufotina yagunu hufo naba-naba o neto, ya weninala igaidana oto lula-hala li you lo edanune, loti holiyafa, olufotina minámabo yagunu ogofuwámae, loto ha mono lufuwau (Jer 31:15) nebo ha ya homu aidena lufuwa ibo ya idafawa muki lo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ena Heloti fulitaito ya moda Wenaba enisolela makafo Isipi ebau Yosefe wamoku fedo muto feto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hipawa hofanogolaibo wema fulitaiye. Yagunu folomokalo yati sinoito, emogi ido olafogi idipito liwila oto Isilaeli mikau uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hawa lomuibo ya Yosefe holito ya sinoito hipawa yagi ido olafogi idipito, liwila oti Isilaeli mikau uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Uwafa, ido Akelausi yakafo melafo Heloti ebala lito Yuda wenina hiyabatina we wenaba ne, loti labo ya Yosefe hawa ya holito ya, yalo uto minanube? loto holi muito ya wamoku yau fuka ha ma holito ya Galili mikau yau uti moniti ");
INSERT INTO snp_lambau_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ya numuna naba ma huliya Nasalete yau loti numuna huti unoti minae. Feto fe minabo yagunu ya homu aidena ya polofeti yasi labo, Wenina muki yasi emogunu ya Nasalete we ne, loti lo edanae, loti hawa labo ya feito u ayalo iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ena hamena yalo ya noku i beti-beti aibo we Yoni Yudia eba hafali mikau ya lo fedoto, wenina ha naba lo oloto bito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Okulumau hiyaba we wenaba weninala hiyaba o ledaibo we hamenala moda alili ainako, loti lutina-hatina li elepa iyalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aya wewa Yoni yagunu ya polofeti Aisaiyakafo feto libo, Hafali mikau yalo ya we ya welauti ha auba ito feto loto lo oloto molanaibo, Wenaba moninaibo hanula ya lifefe loti wili edalo, loto lo minanaiye, loto libo ha ya ha mono lufuwau (Ais 40:3) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ido Yoni ulalo owo ya safu-kameli opalagunu lifefe labo ya ulalo owo holoito, ido hebela ya bulumakau etuwagunu lifefe labo ya hofalalo ya hebe ito, ido wela-idafa ya witugi ido hofuku suwau fimona nowala yagi no-no o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ena Yelusalemu wenina, ido Yudia mikaloti wenina muki yagi, ido wenina ebatina selo Yodani no nabalo nebo wenina yagi muki ya Yoni nedo loti ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ya lifimatina lo oloto molato, Yodani no nabau ya noku i betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noku i betito, ya Falisi ido Sadusi we maleka ya noku i betido ato, ya wa betito feto lobibo, Hemotina hosofa olufola minabo, Metefokafo lifima lolumunaibo hamena naba ya selo ainako, loti holiya anae, loto fuka ha ya hemakafo lobiye? ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hemotina lutina-hatina li elepa iti monatina fefe libo ya molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ido hemotina holiyabo, Abalahamu ya awatefo-holofatema nenako, yagunu Gotikafo lifimate li liwila oto lomámanaibo ne, loti lutina-hatinau ya holi minafe? Feti holiyámilo. Gotikafo hefana-afana yakafo Abalahamu ouwamela-mota lifefe lanowe, lanaibo aifa lifefe lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ido lona ya yá monalo moda molo minaibo ne. Feto feyainako, yá ma ilawa dowa iyámanaibo yá muki monalo fukoto soku hinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Hemotina lutina-hatina li elepa iyone, loti lato ya nemo moda nogunu noku i betiyofa, ido we ma aliga anaibo ya nemo li fulo nedoto wenaba ona neboma nenako, nemo efo yamo hinalo idafala li fulo edanobo ya fefe ladámanogolaiye. Aya wewa ya Weuna Fele yagi ido so hulumagunu yagi noku i betinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wewa ya suwa witi lilika inaibo idafa ya anau lito onona lito suwa witi etuwa ya hilito fulo so fiyámanaibo soku ya ito, suwa witi hula ya li nuba oto lito numugu molanogolaiye, loto Yonikafo lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ena aya hamenalo ya Yesu Galili mikaloti Yodani no nabalo ya loto Yonikafo mono noku i nedanaiye, loto emo nedoka lo fedito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yonikafo lomuibo, E'e, nemodoka ya neidafaito loto lane? Nemo ya hemokafo noku i nedananibo ya dowa lanogolaiye, loto lo fuko edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ido Yesukafo libo, Moda laba, ido onesa ya nemo wenelo meyalo molananibo ya feito Goti mona dowa molo lumiboidana oto molanoibo ya moda ogofunaibo ne, lito ya Yonikafo holito ya welalo meyalo moloto, noku i edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Noku i edaito, Yesu ayalo nokuti yoto, waima moda okuluma godito Goti Weuna ya nama mulu yaidana oto lumuto, emodo limo ito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ido okulumauti nola makafo libo, Moda yoma we Hipane lune-hane muwobo we ya dowa ona wa edowe, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ena ayaloti ya Weuna Felekafo Yesu ya ilimito Satanikafo hepa molo edanaiye, loto hafali mikau akaisa ilimito yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yoto fo hamena foti (40), ido lubu ya foti (40) ya wela-idafa moi ito minototo aliga ya inagunu fulito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","hepa molo-molo ledaibo we ya emo nedo loto lomuibo, Hemo Goti Hipalama minotoma, hefana me ya nebo ya lomuwageto weka-idafa fedaneyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lomuito Yesukafo liwila oto lomuibo, Wenina mino holinabo ya wetina-idafa nanabo yako minámiye. E'e, Goti welaloti ha libo muki meyalo molanabo ya moda mino holinabo ne, loto ha mono lufuwau (Lo 8:3) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Feto loto lomuito, ya Satanikafo fele numuna meya Yelusalemu yau ilimito uto Isilaeli wenina fele huliyagi numuna naba holalo li sinoi edoto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hemo Goti Hipalama minotoma meloti satomo mikalo yoma iyo. Mono lufuwau yau feto libo, Hemogunu ya enisolela ya lobiyageto, hiyaba o hedoti, higa ya hefanakafo fukotanaiye, loti ya adina mulalo li faka lo hedanigilae, loto ha mono lufuwau (Sng 91:11,12) ya nebo ne, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesukafo libo, Ido aya lufuwau yau ha ma feto libo, Wenaba Gotitina ya hepa molo umámilo, loto ha mono lufuwau (Lo 6:16) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lomuito, yaloti ya Satanikafo ilimito obula naba-naba akaisati nebo yalo ilimito yoto, minoto mikau-mikau eba muki huliyagi idafa-adafa ilibito feto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huba i nedoto, huline li faka loto, weuga-luka-haka nomagetoma ya idafa-adafawa muki ya humunogolowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesukafo libo, Ha mono lufuwau feto libo, Wenaba Gotitina weudina-lutina-hatina muti eimolako hidina obula fiti houba-naba o edalo, loto libo (Lo 6:13) nenako, yagunu Sataniyo, nemodokati faiga uwowo! loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Feto lito, Satani ya fulo edo itoto wito, ena Goti enisolela lo fedoti Yesu ana li faka lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ena Yoni nala numugu fulo edabo ha ya holitoto, Yesu hawa ya holito nebo eba ya fulitoto, Galili mikau ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Uto Nasalete numudoti fokito uto, Kapeneyamu numuna momeno Galili anawalo ya Sebuluni ido Napitali mikau ya unoto sinoito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Feto lo nebo ya homu aidena polofeti Aisaiyakafo feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Wenina ya Sebuluni mikau ido Napitali mikau, ido ho no hanu anawalo ido Yodani no naba wela ya ho no filigaleka aya Galili ebau ya eito feka wenina mikatina minabo ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ya weninawa midipu igu minabo ya lamena naba-naba moda wato, ido wenina fulinigili minadoka ya lamenawa yakafo lamena o betiye, loto ha mono lufuwau (Ais 9:1-2) nebo ha yama u ayalo inaiye, loto aya mikau yau uto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ena hamena yaloti Yesukafo apito feto lo oloto bibo, Lutina-hatina li elepa iyalo. Okulumau nebo we wehudi weninala hiyaba o betibo hamena moda selo lotainako, yagunu lutina-hatina ya li elepa iti molalo, loto lo oloto molomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu ya Galili momeno anawalo monimo uto waibo ya unalafo-yalafo loiti Saimonite huliya ma Pita, ido Adulute laefa libo owo noku fuloti laefa li minaito ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesukafo lobibo, Nege molaliyo. Mona api itibinobo ya wenina li-li anaibo we buli betinogolowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","aloko ya laefa owotinama fulitoti ya ege moloti uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ido yaloti monimo uti Sebedi hipala loiti Yemusite, Yonite ya wa betiye. Metinafo Sebedigi maina sipiku laefa owotina fukaibo hifiti minato, Yesukafo sutina fito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ayalomati ya sipigi ido metinafogi ya fulitoti loti ege uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ido Yesu Galili mikau muki monimo uto uto, mono numunatina negu-negu yoto, Gotikafo mikalo wenina hiyaba o betibo hala ukuwa dowa ya lo oloto bito, ido wenina idafa i hiliyabo ido utina ogofu aibo idafa muki ya li faka lo betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Feto feyaibo ya hala ukuwa Silia mikau upatito holiti wenina muki idafa i hiliyabo, ido utina ogofu aibo, ido Satani himiwela ya wenina lutinau yowabo weninagi, ido hulu hofo betibo weninagi, ido adina-hidina galidibo weninagi muki ya emo nedoka idipiti ato, li dowa lo betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Feto fe betimo wito, ya Galili mikauti ido Dekapolisi ebalokati ido Yelusalemu numudoti, ido Yuda mikauti, ido Yodani no wela yolalokati wenina mau naba-naba li nuba oti ege monimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wenina lo nuba oti loti ege molomo uwabo ya Yesu wa betito ya obulaloma yoto amedoto neto, ya ege-ege moniyabo we lo fedoti li hona o edoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesukafo ha mono api itibito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Wenina eimotina utina-lutina li faka ladámoti Goti yakafoko ade li faka lanaiye, loti holinabo wenina ya okulumau nebo we wehuditekafo weninala hiyaba o ledaibo monawa ya moda mino betima nenako, yagunu holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ido hena holi minabo wenina ya Gotikafo lutina-hatinau li aila i betinogolaiboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ido wenina lutina-hatina ito lumuti moloti holoti moni minabo wenina ya Gotikafo mikaleka eba muki ya weuna fi betito linaboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ido wenina inagunu nosámibo fuliti henobatinalo opaito nogunu auba iti holiyabo yamaidana oti wenina lutina-hatinau Goti monala fefe libo mona yagunu auba iti holiti moni minanabo wenina ya Gotikafo mona dowa ogofuto binogolaiboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ido wenina ma hena holiyabo yagunu wenina masi milumatina holiti adina li faka lo betiti moni minanabo weninawa ya Gotikafo ayaidana oto henatina yagunu ya milumatina holito adina li faka lo betinogolaiboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ido wenina lutina-hatina hiluwa lotoko moni minanabo wenina ya nomudinakafo Goti wa edanigilanako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ido wenina lusaku moloti fina lowa lukafa hofo fuliti li you lo beti-beti o minabo wenina ya Gotikafo nemo olufone minae, loto lo betinogolaiboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ido wenina mona dowa fefe liboko molomo uwabo yagunu ya wenina masi wa edabo nosámito, li hopa o betiyatoma ya okulumau wehuditekafo hiyaba o ledaibo mona moda mino betima nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ido hemotina ya nemo nege molabo yagunu ya wenina masi hanu biti heni fulo betiti ido ha nosa naba ámibo sugi ha mona-mona fi biyatoma ya moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Holi minafe? Aya hanuwalo ya polofeti yasi li homu moloti uwabo ya wenina nosámabo yasi ayaidana oti hofo betiyama ne. Okulumau meinawa naba-naba ya hiyaba o ledo nenako, loti lutina-hatinau ake-make iyageto moda dowa ona holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Hemotina ya mikalo me ya holi hikito nomabo wenina ya ho hainoli yamaidana oti minafa, ido aya howa la fulibo ya hulageyama ya igaidana oto hofa la fulinaibo ne? Aya howa yamaidana ya ononalama hofa mináminako, aifa fulitoti hidinagunu lala iti upato hulanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ido hemotina ya mikaloka wenina le lamenatina yamaidana oti minae. Numuna eba obulalo ya ma hu unanabo ya faluku oto minámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ido wenina masi lamu hiti liti masa lulau yau molámoti, lamu molo-molo abo ebalo yalo molato, wenina muki numugu minabo ya lamena o betinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yagunu lamenatinawa ayaidana oti ya wenina muki minado ya lamena o betiyaneyo. Feti ya monatina dowa molabo ya wati, okulumau Metinafo huliya li faka loti iti yonae, loti ya feti lamena o betiyaneyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ena nemo obo yagunu Goti lo molaibo hafe ido polofeti hatina ya li fulanowe, loto aiye, loti ya hatina ki minafe? E'e, feto loti holiyámilo. Nemo obo ya li fulanowe, loto ámowe. Aya hawa yama lo nemodoka hulawa ya li oloto pinaiye, loto obo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yagunu ha ona lobiyowe. Holilo. Mika okuluma hulanaibo hamenalo ya aifa hulanogolaifa, ido Goti lo molaibo hala mono lufuwau iyabo yauti ya lufuwa idafa hefola efomafe, ido ha hefola efomafe u hopa aguwámanogolaiye. Aya hawalo muki ya u ayalo uwapaso minageto hulawa lo fedanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yagunu wenina ma lo molaibo ha yauti hefola mako ma meyalo molámoto, hawa hefola efoma nebo nenako, li fulitalo, loto wenina api itibinaibo, wewa ya okulumau wehudite hiyaba o ledaibo wenina minagu yauti huliya ito lumuto minanogolaiye. Ido we makafo lo molaibo ha muki hololoto minoto, lo molaibo ha ya hololalo, loto api itibibo ya okulumau wehudite hiyaba o ledaibo wenina minagu yauti wewa huliya ya yoto akaisati minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Feito nebo nenako, loto ha ona lobiyowe. Hemotina monatina fefe lanaibo yamo lo molaibo ha api itibi-itibi abo we, ido Falisi we monatina fefe libo ya li fulo edámanaibo ya hemotina okulumau wehudite hiyaba o ledaibo hilalau yau yowámanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aidena Gotikafo awatinafo-mota feto lobibo, Wenina hofo beti fuliyámilo, loto (Kis 20:13), ido ha magi libo, We makafo hofo fulinaibo ya ha li fefe lo-lo abo ebato ilimiti uwato, wewa hofaibo yagunu lifima ha lo edanae, loto ha mono lufuwau (Kis 21:12) nebo ha ya hemotina moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Feito nebo nefa, ido neimo ya aya hawa yagunu ha ma lobinogolowe. Holilo. We makafo hounalafo lula-hala holi nosámibo munaibo ya ha li fefe lo-lo abo ebato ya ilimiti uwato, lifima li munae. Ido we makafo ha managau minámibo ne, loto hounalafo lomunaibo ya kanisole hiyabatina wenaba minado ya ilimiti uwato, ha li fefe lo-lo abo we yasi lifimala munae. Ido we makafo hemo digani ha managau minámibo, loto hounalafo ma lomunaibo ya eimola so fiyámanaibo soku yau lifimawa meinala linaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ena hemo ya Goti munogolo uwaba, hounakafo makafo lula-hala holi nosámibo numu ne, loto holitoma ya homu Goti munanibo idafa mono folomolalo selo yalo molo itoto uto, hounakafo yagi ha li fefe lo huloto, liwila oto loto idafawa lito ya Goti umo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ido hemote uwokafote ha li fefe lo-lo abo numudo unanido ya hanudo yako aloko ha loyolalo-melo oti, lutina-hatina li mako molaliyo. Feto ladámanaibo ya ha lifefe labo we adinalo molageto, ido emote himiwe adinalo molato, ido himiwe yasi nala numugu ya fulo nedotanae, loto lutina-hatina li mako molaliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yagunu ha ona lobinogolowe. Nalau feito yonanibo ya aloko nalauti huladámanogolane. E'e, lifimaka ya hefana muki ya liwila oto binanibo yako nalauti huloto lumunogolane. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ido ha ma feto lobibo, Hemotina hume-ugele ya ámilo, loto ha mono lufuwau (Kis 20:14) nebo ha ya hemotina moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Feito nebo nefa, ido neimo ya aya hawa yagunu ha ma lobinogolowe. Holilo. We makafo wena ma wa edoto lula-halau ya li unanobolae, loto holinaibo wewa ya eimola lula-halau yau moda hume-ugele aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ido nomuga yakafo lifima li mofu hedanaibo ya uka muki so fiyámanaibo soku fulo nedotanaiye, loto nomuga ya kilito fulito. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ido agakafo lifima li mofu hedanaibo ya uka muki so fiyámanaibo soku fulo nedotanaiye, loto aga fukoto fulito. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ido ha ma feto lobibo, We makafo olonafo fulo edanowe, loto holitoma ya wewa olonafo fulo edanaibo ha lufuwa ito muwageto ya olonafo fulo edanaibo ne, loto ha mono lufuwau (Lo 24:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Feito nebo nefa, ido neimo ya aya hawa yagunu ha ma lobinogolowe. Holilo. We ma olonafo hopa li uno-uno moniyámifa, ido wanafokafo ya olonafo fuko fulitaibo wena ya we eito ma unaibo, ya homu wanafo yakafo olonafo li hume-ugele hanuwa wili edaiye. Ido we makafo fuko filiga-filiga abo wena ma linaibo we ya hume-ugele anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ena hemotina awatinafo-mota lo molaibo hatina ya moda holitabo ya feto libo, Hemotina ha onae, loti ido idafa ma feto feyanune, Wenaba huliya loti, lo gedoti molanabo ya sugi mona molámoti, hawa ya meyalo moloti, Wenaba nomunalo ya feto feyanune, loti labo hawa fefe lotiko feto feyalo, loto aidena ha monoku yauti moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Feito nebo nefa, ido neimo ya aya hawa yagunu ha ma lobinogolowe. Holilo. Idafa ma huliya loti, ha onae, loti ladámilo. Holi minafe? Okulumau nebo we wehuditekafo weninala hiyaba o ledainako, hemotina wenina ma ha lobinigilima ya okuluma huliya loti, hawa ya li onae, loti ladámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ido mika melo ya Goti hina lala i nebo mika ya huliya loti, hawa ya li ona ne, loti ladámilo. Ido Yelusalemu ya Wehudite Wenabate numunalama nenako, Yelusalemu huliya loti hawa ya li ona ne, loti ladámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ido hemotina ya heimotina manadina opala ya ma mako ma li feke loti, ido li lubufa loti anabo ya ogofuwámanako, yagunu manadinati huliya li onae, loti ladámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Feito ya o, lanabo ya aifa o, loti, ido e'e, lanabo ya aifa e'e, loti lalo. Ha ma ya hawa mulalo ayalo onu iti li aubafofo loti li onae, loti lanabo ya nosámibo we nedokati anaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ido ha ma feto lobibo, We makafo nomugalo hofo hedanaibo ya ayaidana oto lifima liwila oto nomunalo hofo. Ido makafo wekau hofo hedanaibo ayaidana oto welau lifima liwila oto hofo, loto ha mono lufuwau (Kis 21:24, Wkp 24:2 Lo 19:21) nebo ha ya hemotina moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Feito nebo nefa, ido ha ma lanogolowe. Holilo. Wenina masi li hopa o betiyatoma liwila oto li hopa o betiyámilo. E'e, we makafo wanaga onaleka hofanaibo ya filiga adawaleka yagi hofo nedo, loto wanaga ilibiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ido makafo li halo molo hedoto ukalo owo lulau iyanibo linowe, loto lanaibo we ya ukalo owo mulalo iyanibo yagi aifa umo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ido himiwe makafo, huwamenane mofuto hanu hofala foumama unane, loto aubafofo lo hedanaibo, ya hofala magi aifa onu ito ilimito uwo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ido makafo idafa magunu wako lohumunaibo ya aifa umo. Ido makafo hemodokati ya idafa ma hefa moloto linowe, loto anaibo, ya mesafa i umámo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ido ha ma feto lobibo, Weninatina selo keloti minabo wenina ya lutina-hatina biti, ido uwotinafo ya lutina-hatinau holi nosámibo bilo, loto ha mono lufuwau (Wkp 19:18) nebo ha ya hemotina moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Feito nebo nefa, ido neimo aya hawa yagunu ha ma lobinogolowe. Holilo. Uwotinafo ya lutina-hatina bilo. Ido mona nosámibo molo betinabo wenina yagunu Goti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Feto feyanabo yakafo Metinafo okulumau nebo we ya olufola ona minanigilae. Moda holiyafe? Emo yakafo fo ya lifefe lito wenina nosámibo yagi ido dowa yagi minado ya muki li mako ito fo liye. Ido emokafo ho ya lifefe lito wenina monatina fefe loti molabo yagi ido fefe loti molámabo yagi minado ya muki li mako ito ho ya iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yagunu hemotina yasi lutina-hatina biyabo wenina yako ya liwila oti lutina-hatina biyatoma ya meina linafe? E'e, aya monawa ya hefana takisi li-li abo we yagi molo minabo yae. Monawa ya ogofuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ido hemotina ya weninatina yako aiyo-weiyo lobinabo monate yakafo wenina malekama monatina li fulo edaiye, loti holi minafe? E'e, eito feka wenina holi hikitámabo yagi aya monawa ya molo holi minabo yae. Moda holiyafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Feito ya Metinafo okulumau nebo we monala ya fefe lotoko nebo, yagunu hemotina ayaidana oti mona fefe lotiko molalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Hemotina ya mona fefe loto molanune, loti, ya wenina dowa wa ledanae, loti nomudinalo molanabo, ya Metinafo okulumau nebo we yakafo ekeni idafa ma biyámanaibo, yagunu wati moniti, wenina dowa wa betinabo yagunu holiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yagunu ya wa námabo wenina adina li faka loto idafa ma binune, lanabo ya wenina monona loiti iyabo ya hulite iti yonae, loti hona liti mono numugu ido hanudo-hanudo u homu uti bomu wekilofo nola molabo mona yamaidana oti ya molámilo. Ya monawa molabo meinala ya moda litabo ne, loto nemo ona lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yagunu hemotina yasi idafa wa námabo wenina adina li faka loto idafa binune, loti holinabo ya idafa binabo monatina yagunu eito wenina lobiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E'e, faluku otiko adina li faka loti bilo. Feto anabo ya Metinafo idafa faluku oto nebo muki ya wa-wa aibo we yakafo ekeni idafa binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Hemotina Goti lomunado ya monona loiti iyabo wenina yamaidana oti lomuwámilo. Emotina yasi Goti lomunado ya wenina wa ledanae, loti mono numugu ido hanu anawalo nomudinalo sinoi minae. Monawa molabo yamaidana oti hemotina feti molámilo. Ya monawa molabo meinala ya moda litabo ne, loto lemo ona hula lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yagunu hemokafo Goti lomunowe, loto holinanibo ya heimo numunakau ya yoto, hanu huitito Mekafo wa edámanibo we lomu-lomu o minagetoma, ya Mekafo mona muki momona ananibo ya wa-wa aibo we yakafo ekeni idafa humunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ido eito feka wenina Goti monala yagunu holiyámabo wenina yasi aifa ha ilalu huti lo-lo abo ya holi lumunaibo ne, loti hatina kiti lo-lo abo monatina molabo yamaidana oti hemotina molámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E'e, homu loga o edámabo hamenalo Metinafo yakafo muki idafa lutina-hatinau holiyabo ya moda holitaima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ena Metefo lomunigilima feti lomuilo, Metefo okulumau minanibo we ya wenina yasi hulika li faka lomo yoto fele ne, loti minanabo ne, loto holiyone. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ido hemo hiyabate we wehudi hiyaba o ledanibo hamena lo fedanogolaiye, loto holiyone. Ido okulumau weka lanido hololotiko minabo yamaidana oto wenina mikalo meu ya wekalo hololanune, loto holiyone. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ido hamena-hamena wete-idafa lomo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ido wenina lifimatina hilili o betiyonibo yamaidana oto lemo lifimate ya hilili o ledo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ido mona nosámibo hepa molo lumunaibo nedo ya lilimiyámaba, ido mona nosámibo nala i ledanaiguti ya wina ledo. Hemo hiyaba we wehudi hiyaba o ledanibo ya minomo uto uto aubafofoka ya minomo uto uto hulika ya yoimo uto uto minowa-minowa oto minanaibo ne. Ya onae, loti Goti lomunabo ya feto loti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Moda holiyafe? Hemotina li nosámibo o betinabo wenina lifimatina hilili o betiyatoma, ya Metinafo okulumau nebo wekafo heimotina lifimatina yagi ayaidana oto hilili o betinogolaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Feito nefa, ido wenina lifimatina hilili o betiyámanabo ya Metinafo yakafo heimotina lifimatina yagi ayaidana oto hilili o betiyámanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Goti holi muto hoba-hobina moi i muto ha lomuto minananido ya monona loiti iyabo wenina yaidana oto mona molámo. Weninawa yasi lana liti hotina-wetina li hopaitabo, wenina wa ledanabo ya hoba-hobina moi i muwabo ne, loti wa ledanigilae, loti labo monatina yamaidana oto ya mona molámo. Monawa molabo meinala ya moda liyabo yae, loto nemo ha ona hula lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ido hemo ya Goti holi muto hoba-hobina moi inowe, lotoma ya hoka-weka noku ito, atakalo ya yá nowala ladanuwa aibo idafa wilito moniyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Feto feyananibo ya wenina muki ya Goti holi muto, hoba-hobina moi i muiye, loti wa hedámanafa, ido Mekafo mona muki momona ananibo ya wa-wa aibo we yakafo ekeni idafa ya humunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hemotina mikaloka huwamena li nuba naba o minato, ya hanu sisigafa wilito, ido yufa lanaibo ne. Ido ugele we yasi numunatina ya fukoti yoti idafa ugele linabo ne. Yagunu mikaloka me ya huwamena ya li nuba o-o ámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ido okulumau huwamena li nuba anabo ya hanu sisigafa yakafo námanogolaiye. Ido yufa ladámanogolaiye. Ido ugele we yasi numunatina ya fukoti yoti ugele liyámanigilae. Yagunu okulumau huwamena ya li nuba o-o alo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Moda holiyafe? Huwamenatina molanabo eba ya lutina-hatina-manadina aubafofo loti aya ebau yako holi munabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nomudina ya utina lamula ne. Yagunu ya nomudina dowa minagetoma lamena ya utina muki ya li faito betinogolaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ido nomudina nosámagetoma ya utina muki ya midipu yagunu faito betinogolaibo ne. Yagunu ya lamena lutinau nebo ya midipu inaibo ya moda naba-naba midipu inogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","We makafo wenaba loiti ya houba-naba o betinaibo ya ogofuwámiye. Feto feyanowe, loto holinaibo ya wenabala ma ya eleka fi muto, ido ma ya lula-hala munaibo nefemo, ido malo ya u keloto, ido ma ya fulo edanaibo ne. Ayaidana oti hemotina Goti yagi ido hefana-huwamena mikalo idafa-adafa yagi li makoiti houba-naba o betinune, loti holinabo ya ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yagunu ya ha ma lobinogolowe. Holilo. Hemotina ya fulitanune, loti ya wetina-idafa nanabo idafa yagi, ido no yagi ya igaukati lito nanubo ne? loti hatina abi kiti, ido utina yagunu holiti ya utelo owo ya nena idafa holoinubo ne? loti hatina abi ya kiyámilo. Nomude hofawa minonibo mona yakafo wete-idafa ya li fulo edaibo ne, loti holiyámafe? Ido utina yakafo utinalo owo ya li fulo edaibo ne, loti yagi holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nama ya okulumalo bu loti moniyabo monatina yagunu hatina ki fefe lalo. Emotina ya yufa idafa hifiyámabo ne. Ido hulawa libo ya doliyámabo ne. Ido numugu ya wetina-idafa li nuba ámabo ne. Feto feyámafa, ido Metinafo okulumau nebo we yakafo wetina-idafa moda bi-bi aibo ne. Yagunu holilo. Hemotina ya moda nama ya li fulo betiti minae, loti ya holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ido hemotina minagu yauti ya hemakafo eimola hala abi kidoti ya mino lito unaibo hamenala ya hefola magi onu ito minomo unaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ido utinalo inabo owo yagunu ya neidafaito hatina abi ki minae? Hofuku huwawa ibo yagunu hatina ki fefe lalo. Huwawa yakafo onona liyámoto ido ulalo owo lifefe ladámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Feto lifefe ladámifa, ido huwawa yakafo Yuda wenina mikalo hiyaba we wehuditina Solomoni ulalo owo lali-idafa ibo ya li fulo edaibo ne, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ake, hemotina holi hikitina hefola nebo weninao, Goti yakafo suwa-nala ya eletifo neto ido leda fukoti soku hinabo idafa ya feito li golaiboma nenako, yagunu ya moda ayaidana oto hiyaba dowa o ledanogolaiye, loti ya holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yagunu ya hoba-idafa yagi, ido no yagi igaidana oto lito nanubo ne? loti, ido nena-idafa utelo holoinubo ne? loti hatina abi ya kiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","E'e, aya idafa-adafawa muki yagunu ya eito feka wenina yasi wita-wita afa, ido Metinafo okulumau nebo we yakafo idafa-adafawa muki ya hemotina linabo ogofunaibo idafa ya moda holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yagunu hemotina ya okulumau nebo we wehudi ya hiyaba we wenabate minanogolaiye, loti, ido emo monala fefe libo mona dowako meyalo molanune, loti auba iti holiti li lutina-hatinau ya homu moloti minaneyo. Feto anabo ya idafa-adafawa malekama muki yagi moda onu ito oloto pi binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ido hemotina ya leda yagunu ya hatina abi ya kiyámilo. Fo hamena leda yakafo eimola idafala yagunu hala kinogolaiye. Fo hamena makolo ya eimola henala ya moda ogofuto ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesukafo feto libo, Gotikafo hemotina li halo molo ledotanaiye, loti wenina li halo molo betiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yagunu hemo li halo molo betinanibo mona yaidana oto Gotikafo li halo molo hedanaiye. Ido bi-bi anibo mona yaidana oto liwila oto humunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yagunu ya igaidana oto hounakafo nomunalo mouta hefola efoma nebo ya wa edaba, ido heimoka nomugau yá lana naba nebo ya wafefe ladámane? ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ido yá lana ya heimoka nomugau nebo wa edámanibo hounakafo nomunau mouta hefola efoma nebo ya igaidana oto li fulo hedanowe, loto lomunanibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Monona loiti iyanibo we, hemo heimoka nomugalo ya yá lana naba nebo ya homu li fulitoto wafefe loto minototo, aliga ya hounakafo nomunau mouta hefola efoma nebo ya li fulo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Adala hofo ledotanae, loti fele idafa dowa ya hula biyámilo. Ido safu hidinakafo lala iti elepa iti adala hofo ledotanae, loti ekeni okani dowa idafatina ya mikalo aifa fulámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hemotina idafa ma lumunabe? loti lomuti minanabo wenina idafawagunu holinabo ya binaibo ne. Ido idafa moni wita minanabo wenina idafawagunu holinabo ya li oloto pi betinaibo ne. Ido hanudo hesoba inabo wenina ya hanu si betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yagunu idafa lumunabe? loti lomuti minanabo wenina ya moda linabo ne. Ido idafa moni wita minanabo wenina ya li oloto pinabo ne. Ido hanudo hesoba iti minanabo wenina ya hanu si betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ena hemotina yauti we ma hipalakafo hobagunu melafo loga o edanaibo ya hefana fowena munaibo nefe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ido laefa yagunu loga o edagetoma ya salopaina munaife? ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Feti hemotina ya wenina nosámabo minafa, ido olufotina idafa dowa aifa bi-bi abo mona ya holi minae. Monawa holi minato, ido Metibo okulumau nebo we yakafo idafa magunu loga o edanabo wenina ya ito yoto idafa lali-idafa bi-bi anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yagunu wenina masi feti o molo nedo-nedo anae, loto holinanibo ya hemokafo yagi mona ayaidana oto molo beti-beti o. Lo molaibo ha ido polofeti hatina monawa feito nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ido hemotina ya hanu wela hefola efoma ya moni wita oti yoilo. U hopa anabo hanu wela ya naba-naba neto ido hanu hofala ya naba-naba nenako, wenina abi hanuwalo yau yoi-yoi abo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Feito nefa, ido mino wa-wa abo ebau unabo hanu welawa ya hefola neto, ido hanu ya hefola nenako, wenina mako-mako yako hanuwa ya li oloto pi-pi o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ha sugi mono api itibiyabo wenina ya wati ekei o betilo. Weninawa ya loti hotina inune, loti sipisipi you libo monatina yaidana oti molafa, ido lutina-hatinau yau liye-hula yaidana oti minae. Yagunu wa betifefe loti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aya weninawa mona molanado yati hulawa ya wati wa betifefe lanigilae. Adi ibo ya agina hasuwalau yauti linafe? Ido yá menifa ailau yati sigolo ilawa ya linafe? E'e, feto feyámanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Feito yá dowa yakafo hulawa dowa i-i aifa, ido yá nosámibo yakafo hulawa nosámibo i-i aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yá dowa yakafo hula nosámibo iyámito, ido yá nosámibo yakafo hula dowa loto inaibo ya ogofuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Feito yá ma hula dowa iyámanaibo ya fukoti soku ya hinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Feito nebo yagunu Goti hala lobinogolo one, loti lo-lo abo wenina ya hulawatina wati wa betifefe lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wenina mukisi Wenabate, Wenabate, loti lonumu-numu o minabo wenina ya okulumau nebo we weninala hiyaba o ledaibo hilalau yowámanigilafa, ido Menefo okulumau nebo we welalo hololoti moni minabo wenina yako unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yagunu hona molanaibo hamena nabalo ya wenina mukisi feto lonumunabo, Wenabate, Wenabate, hulikalo ya wenina lobiyoniboma ne. Ido hulikalo ya Satani himiwela wenina lutina-hatinauti li fulo betito idipiyoniboma ne. Ido hulikalo ya Goti aubala itibibo idafa abi loto onibo ne, loti lonumunae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Feti lanabo ya nemokafo feto loto lo oloto binobo, Hemotina ya wa betiyámoma ne. Monatina nosámibo molo-molo abo ya nemo minodoka faiga wilo, loto lobinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Wenina masi hane ya holiti meyalo molanabo ya ha mananau nebo we numuna hefana mulalo huibo yamaidana oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Numuna huito, aliga ho naba-naba ito, no naba ya wilito, asi naba-naba yakafo loto numunawaloma auba ito hofaifa, ido numuna ya hefana naba mulalo aubafofo loto huinako, lumu fou ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Feito nebo nefa, ido wenina masi hane holiti meyalo molámabo wenina ya ha mananau minámibo we numuna sesepalo huibo yamaidana oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Numuna huito, aliga ho naba-naba ito, no naba ya wilito, asi naba-naba yakafo loto numunawaloma auba ito hofaito lumu fou loto upa-napatoto wiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesukafo hawa ya lo hulito wenina nuba naba minoti ha lobibo monala holiyabo ya elegiyae. Emo ya lo molaibo ha api itibi-itibi abo we yaidana oto api itibiyámoto, ha mono hula yawalakafo api itibinako, elegiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu obulaloti lumito, wenina mau naba-naba ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ege uwato, ido moda okola hilibo we ma Yesu nedo loto, hinalo huba i muto feto libo, Wenabao, hemokafo feto feyanowe, loto holitoma okola hiliyobo ya holuto nedo, loto lageto une ya moda holutanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Feto loto lomuito, Yesukafo ana sino loto wewa ulalo li minoto lomuibo, Feto feyanowe. Okola hiliyanibo holuto, lito ayalo okola hilibo moda holutiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ido Yesukafo libo, Idafa fe hedobo ha ya wenina lobiyámoto, uto sokila hi muibo we uka ilibiyageto wa hedageto ena Mosesekafo ha lo molaiboidana oto idafa muwageto wenina muki yasi okola hiliyaniboma moda holutane, loti holinigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ena Kapeneyamu numudo lo fedito, himiwe hiyabatina we ma Yesu nedo loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","feto lomuibo, Wenabao, houba-nabane we hebilisitoko minoto, ula ogofu naba-naba aito, numugu folomoloko uno ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lomuito, Yesukafo liwila oto feto libo, Nemokafo uto idafa i hilibo ya li faka lo edanogolowe, loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ido himiwe hiyabatina we yakafo feto libo, Wenabao, nemo Yuda we minámonako, numunaneu yonanibo ya fefe ladámanogolaiye. Yagunu hemo ha yako lageto houba-nabane we idafa i hilibo ya faka lanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Feito nemo yagi hiyaba o nedabo we wetinalo meyalo molanobo we minowe. Ido nemo ya himiwe hiyabatina we minowe. Feito himiwe ma uwo, lomuwoto ya moda wiye. Ido we ma ano, lomuwoto ya moda aiye. Ido houba-nabane we feto feyo, lomuwoto ya feto feyaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lomuito, Yesukafo hawa liboma ya holito elegito ege uwabo wenina ya feto lobibo, Ha ona lobiyowe. Holilo. Isilaeli wenina muki yauti we ma holi hikila naba nebo wewa yaidana we ma wa edámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yagunu lobinogolowe. Fo yoidokati ido fo lumidokati eito feka wenina muki ya loti okulumau nebo we weninala hiyaba o betibo ebalau yoti Abalahamu, Aisaka ido Yekopu maina amedoti wetina-idafa nanigilafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ido Yuda wenina Goti hala holiti holiyámabo wenina ya idipi eba midipu naba igu fulo betinaibo ebawau itageto hufo naba-naba oti wetina hofala guti minanigilae, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lobito himiwe hiyabatina wema feto lomuibo, Hemo uwo. Holi hikitanibo yaidana oto hulawa oloto pi hedanaiye, loto lomuito, ido aya hamenalo ya houba-nabala we idafa hilibo ya faka liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ido Yesu ya Pita numunalau yoto wa edaima, ya Pita ola-kilofo wena ya idafa hilito ula hala-kala lito folomolo ya uno ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Uno nebo ya wa edoto analo lito, ula hala-kala liboma ya fulo edaito wenawama sinoito wetina-idafa hofo hi betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ena lunaga molaito Satani himiwela lutina-hatinau mino betiyabo wenina muki ya idipiti Yesudoka ato, ha libo yakafo Satani himiwela mino betiyabo li fulo betito idipi molaito uwato, ido idafa i hiliyabo wenina muki ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Feto feyaibo yagunu Gotikafo polofeti Aisaiya ha welalo molaito feto libo, Eimolakafo uteu ogofu aibo idafa lito, idafa hiliyonibo mona-mona ya mofutaiye, loto ha mono lufuwau (Ais 53:4) nebo ha hulawa moda fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesukafo wenina nuba naba li hona o edabo ya wa betito, ege-ege moniyabo we ya momeno anawa filiga yolaleka uwokelo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lobito, ha mono api itibibo we makafo emo nedo loto libo, Api lilibiyanibo we, eba muki unanibodoka ya nemote maina unoiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lomuito, Yesukafo feto libo, Liye-hula ya mika hofuti hu unato, ido nama okulumalo moniyabo ya numunatina neto minafa, ido nemo We Hula ya uwo uno-uno obo ebane ya minámiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu ege molabo we yauti we ma loto libo, Wenabao, homu uto menefo hale li edoto aliga hege moninofe? loto loga o edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesukafo libo, Nege ano. Fulinabo wenina fulo betiyageto emotina yasi ya fuliyabo weninatina hale li betinigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ena sipiku yoito ege-ege moniyabo we ege uti ayau yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yoti momenoku ya moda asi naba-naba apito no hofaito, no halafu yakafo sipi hofaito no lulau lumunowe, loto feyaifa, Yesu ya moda uwo uno ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Uwo uno nedo ege-ege moniyabo we loti ilimikuti feti lomuwabo, Wenabao, no lulau lumuto fulinogolone. Ade li faka lo, loti ha naba loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ha naba loti lomuwato, emokafo libo, Hemotina holi hikitina hefola nebo we, nedafaito holi holiyae? loto lobito unaiguti sinoito asi yagi ido no halafu yagi hanu muito, ayalo ya asi fu-fu ladámoto, no halafu yagi momoga ámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Feto aibo yagunu wemoli ya elegiti feto labo, Aiyo, we ya igaidana we neto, asi yagi ido no yagi ha lido ya hololiye? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesugi ege-ege moniyabo wegi momeno filiga yoilaleka Gadala wenina mikatinalo u fedato, we loiti ma Satani himiwela mino betibo we ya hono molabo ebaloti loti hatula aiye. Wewa loiti auba nosámibo inako, yagunu wenina holi bito, aya hanudo yalo uti loti ámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","We loitiwa yasi feto lomuibo, Goti Hipala, neidafa fe ledanogolo ane? Lifima li hona molo ledanaibo hamena naba onesa fedáminako, ute ogofu li lumunogolo abe? loti loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Loga o edaito, safu mau naba ma yowa minoti wetina-idafa no minato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Satani himiwela yasi wa betiti lomuwabo, Lilifinowe, lotoma ya safu lutinau yowau lilifi fulo, loti aubafofo loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lomuwato, ayau wilo, loto lobito, we loiti lutinauti fulo betiti safu lutinau yowato, safuwa holi lumuti lowau hotinadokati luwa fiti momenoku yau no noti moda fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Moda fuliyato, safu hiyaba abo we ya holi oluloti uti numuna meyau yoti, wenina muki aya hawa yagi we loitima Satani himiwela mino betibo idipibo ha yagi lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lobiyato, ayalo ya muki wenina numuna meya yauti loti Yesugi hatula anune, loti loti wa edoti ya auba iti feto lomuwabo, Lemo ebate ya fulitoto uwo, loti wako lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu sipiku yoto momeno wela filiga uto eimola numunalalo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fedito, ya moda hina-ana hebilisitoko nebo we ma agakalo moloti emo nedo ilimiti ato, Yesukafo holi hikito muwabo monatina ya wa betito hina-ana hebilisitoko nebo we ya lomuibo, Hipane, holi homámaneyo. Lifimaka ya moda hilili otaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Feto lito, moda wewa Goti hamana hiye, loti ha mono api itibiyabo we lutina-hatinau holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Holiyato, Yesukafo lutina-hatinau holiyabo ha ya wa betito feto libo, Hemotina nedafaito lutina-hatinau yau ha nosámibo holi minae? ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Feito hebilisitoko nebo we, Lifimaka ya hilili otaibo ne, loto lomunobo hemotina hulawa ya wa edámanako, sugi lifemo, ido ona liye, loti holiyámanigilae. Ido, Agakalo yati sinoito hanu moniyo, loto lomuwoto hulawa wa edananako, sugi lifemo, ido ona liye, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nemo We Hula minobo mikalo meu ya lifima hilili anobo auba ya moda mino nedaibo ne, loti wanigilae, loto ya hebilisitoko nebo wema feto lomuibo, Sinoito, hunuka lito liwila oto numunakaloka uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lomuito, wewama sinoito hunula lito numunaleka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wito, ya wenina nuba naba ya watiti elegiti Goti ya aubala naba wenina adinalo bibo huliya li faka loti ebola lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu yaloti monimo uto wenina hefana takisi li-li abo ebalo ya Matiu amedoto nebo ya wa edoto feto lomuibo, Nege ano, loto lomuito ya sinoito ege wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ena numugu ya Yesu wela-idafa no neto wenina hefana takisi li-li abo we ido lifimatina nebo we abi-idafa loti Yesugi ege-ege moniyabo wegi maina wetina-idafa no minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wetina-idafa no minato, Falisi we yasi loti wa betiti ege-ege moniyabo we ya feto lobiyabo, Igaidana oto api itibibo we ya yo-hola wenina hefanatina takisi li-li abo wegi, ido lifimatina nebo we yagi maina wela-idafa naiye? loti loga o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesukafo hawa labo ya holito feto libo, Idafa i hiliyámabo wenina ya lusa numugu ya aguwámae. E'e, idafa ona hiliyabo wenina yako ya lusa numugu ya u-u ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nemo obo ya wenina mona fefe liboko molabo wenina ya lutina-hatina li elepa iti molalo, loto lobinowe, loto ámowe. E'e, lifimatina nebo wenina ya lutina-hatina li elepa iti molalo, loto lobinowe, loto obo ne. Holilo. Gotikafo feto libo, Lune-haneu holiyobo ya idafa hofo hi numunae, loto holiyámoto, wenina milumatina holiti adina li faka lanae, loto holiyowe, loto ha mono lufuwau (Hos 6:6) ya nebo ne. Yagunu hemotina uti hawa monawa ya moniti wita oti holi fefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ido Yoni ege molabo we ya Yesudoka loti feto lomuwabo, Lemogi ido Falisi wegi wete-idafa moi iyogeto ya hemo hege-hege moniyabo we ya igaidana oti wetina-idafa moi iyámae? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesukafo liwila oto feto lobibo, We ma wena linaibo weninalagi maina nebo hamenalo ya weninala lutina-hatinau hena holiti hufo nama ha lanafe? E'e, feto feyámanafa, ido emodokati wewa ipoti linabo hamena ya fedanaibo yalo ya wetina idafa moi inabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ido we makafo ulalo owo lila fukanaido ya owo hofawa hefola makafo mulalo moloto hifinaibo ya noku iyoto hofawakafo lilama ika ageto fukotanaiye, loto hifiyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ido we makafo no waini hofawa ya lipito safu-meme etuwa lilau yau lekiyámanaibo ne. No waini hofawa yakafo safu-meme etuwa lila ya fokiyageto no waini hofawa ya mikalo lekito u hopa uwageto ido safu-meme etuwa yagi fokito u hopa utanaiye, loto no waini hofawa ya safu-meme etuwa hofawau yako lekinaibo ya loitiwagi aifa aubafofo loti minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hawa ya lobi nedoma ya hiyaba we ma loto hinalo huba i muto ya libo, Olune onesa ya fulibo yagunu hemo loto aga mananalo molageto ya moda sinoinaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Feto loto lumito ya Yesu sinoito ege wito ege-ege moniyabo wegi ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ege uwato, ya wena makafo lunula leki-leki aibo melege tuwelu (12) yalo ya idafawa hilitoko nebo ya loto Yesu nedo egeka loto ulalo owo onuwalo linobo ya moda li faka lo nedanogolaiye, loto hala kito loto ulalo owo onuwalo ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lito, Yesu elepa ito wenawama wa edoto ya lomuibo, Olune, holi homámaneyo. Holi hikitanibo yakafo li faka lo hedaiye, loto lomuito, ayalo wenawama moda faka liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ido Yesu uto hiyaba we numunalau yoto ya hanugana nomu yaidana oti fu lo-lo abo wenina wa betito, ido wenina nuba naba oti hufo ha naba-naba loti minabo ya holito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hemotina feka wilo. Oluwa ya fuliyámoto, aifa uwo unaiye, loto lobito weninawa muki ya hiya o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Feto lato, ya muki idipi feka fulitito, lulau yoto oluwama analo lito li sinoi edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Feto feyaibo hala ukuwa aya mikau muki ya upatoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ena Yesu ebawa fulito wito we loiti nomudina likaibo yasi ege uti feto laibo, Defiti yufa fibo weyo, milumate holiyo, loti su naba loti laito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ya uto numugu yoito nomudina likaibo we loitima emo nedo aito feto lobibo, Hemotina nomudina ya li falatanaiye, loti holi hikito nomaife? loto loga o betito emotina yasi O, Wenabao, holi hikito homoiye, loti lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Feto laito, anagunu nomudinalo lito feto libo, Hemotina holi hikitaibo yakafo hulawa fedo binaiye, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","we loiti nomudina falatito Yesukafo libo, Holiliyo. Idafa feto feyobo ha ya wenina lobiyámiliyo, loto auba ito lo fuko betifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","loitimasi uti hala ukuwa laito ebawa negu-negu upatomo wito muki holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ena we loitiwama uwaito moda we ma Satani himiwela lula-halau mino edaibo nei molaibo we ya emo nedo ilimiti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ilimiti ato, Satani himiwela lula-halau neboma li fulo edoto ilifi molaito nei molaibo we ya ha lito wenina mau minabo wenina ya elegiti feto labo, Isilaeli mikau idafa yaidana ma wagámoniboma ne, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Falisi we yasi feto labo, Satani himiwela hiyabatina we wenaba aubala yakafo Satani himiwela li fulo betito idipi molaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu uto numuna hefola naba muki ya monimo uto mono numunatina negu-negu yoto api itibito, ya weninala hiyaba o ledaibo hala ukuwa ya lo oloto pi bito, ido wenina idafa utinau i hiliyabo muki yagi, ido utina ogofu idafa i hiliyabo muki yagi li faka lo betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ido wenina nuba naba-naba ya wa betito ya lula-halau milumatina holibo, ya weninawa yasi igau unune? Hemakafo ade li faka lo ledanaiye? loti awisa labo ya sipisipi hiyabatina we minámabo yaidana oti minanako, milumatina holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yagunu ege-ege moniyabo we feto lobibo, Hoba-hobina migu ya naba-naba hula lifa, onona linabo wenina mako-mako yako minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yagunu hemotina onona yawala ya lomuwato onona linabo wenina ya ononalau ya idipi molanaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesukafo ege-ege moniyabo we tuwelu (12) ya sutina fito ato ya Satani himiwela li fulo betito idipi molabo auba, ido wenina idafa mona-mona i hiliyabo, ido utina elo aibo li faka lanabo auba ya biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ononalalo idipi molaibo we ya hulitina feito ne: Homu molaibo ya Saimoni huliya ma Pita ne. Ido unalafo Adulu ya ne. Ido Sebedi hipala Yemusite unalafo Yonite ya minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ido Filipi ne. Ido Batolomiu ne. Ido Tomasi ne. Ido Matiu hefana takisi li-li aibo we ya ne. Ido Alifiusi hipala Yemusi ne. Ido Tadiusi ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ido Saimoni ya Seloti minagu yauti nebo we ya ne. Ido Yudasi Isikaliyoti ya Yesu uwotinafo adinalo bibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ena ege-ege moniyabo we tuwelu (12) ya Yesukafo ononalalo idipi molanaibo ya ha feito lobibo, Uti ya eito feka wenina minabo ebau yagi ido Samalia wenina numunatina nabau yagi aguwámoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isilaeli wenina sipisipi moni faluku abo mona yaidana oti minabo wenina ebatinau yau wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Monimo uti okulumau nebo we wehudite hiyaba o ledanaibo hamenala moda alili aiboma ne, loti lo oloto moloto lobimo wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lobimo uti idafa i hiliyabo ya li faka lo betiti, fuliyabo ya li sinoi betiti, okola i hiliyabo ya li holuto betiti, ido Satani himiwela mino betiyabo ya li fulo betimo wilo. Hemotina aubawa liyabo ya meina fiti liyámoti aifa liyanako, yagunu wenina ma idafawa ya feto fe betitima ya meina liyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ido hefana golife, hefana siluwafe ido hefana kapafe otinau ya holiti aguwámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ido moninigilima ya hefanatina holinabo owo ya liti aguwámilo. Ido utinalo owo loiti yafe, ido hidinalo inabo idafa yafe, ido holobo yafe liti moniyámilo. Onona linaibo we ya onona meinala linaiye. Yagunu muki idafa liti moniyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ido numuna negu-negu ya utima, mona dowa molaibo we wita oti wewagi maina numunalau minomo uti ebawa ya fulitoti unigilima ya sinoiti wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ena numugu ya yotima, ya you amena mona hemotina minadoka mino betinaiye, loti lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aya numugu minabo wenina moda aifa li dowa lo ledaibo mona molo betiyatoma, ya you amena hatina yakafo emotina minadoka mino betinaiye. Ido weninawa moda feto molo betiyámatoma, ya you amena hatina ya emotina minadoka mino betiyámoto, hemotina minadoka hofa liwila oto anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ido numuna ma yau wenina yasi hemotinagi houna iyámoti, ido hatina yagi holi fulitatoma, ya numunatinafe ido ebatinafe ya fulo betiti unigilima ya hidinalo huwopa kelaibo ya itili o fulitoti wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ha ona lobiyowe. Wenina muki lifima ha binaibo hamena nabalo ya Sodomu ido Gomola wenina ya lifima ha lito lumuto binogolaifa, aya ebawau minabo wenina ya lifima ha lito yoto binogolaiye, loto lobitoto onodo idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesukafo libo, Moda neimokafo hemotina sipisipi yaidana oti liye-hula yaidana feyabo wenina minagu ya idipiyowe. Yagunu ya hosofa ha mananau nebo yaidana oti hatina kifefe lalo. Ido nama mulu fefe loto monala molaibo yaidana oti mona ya molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wati monilo. We masi adinalo-hidinalo liti numuna meyalo kanisole wenina adinalo molato idipiti uti mono numunatinau ya nala ikulagunu hofo betinabo nenako, wati monilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ido yako minámiye. Nege-nege moniyabo yagunu huliyagi we ido hiyaba we wenaba minado ya idipiti uwato, hemotina hane ukune lo oloto molato emotinagi ido eito feka weninagi ya holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ido hiyaba we wenaba minadoka idipiti uwatoma, ha igaidana oto lanubo ne? Ido ha lolomatoma nedafaiye, loto liwila oto lobinubo ne? loti ya hatina abi kiyámilo. Aya hamenalo ha lobinabo ya wetinalo molanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hemotina heimotina ya ha ladámanafa, Metinafo Weuna Fele yakafo hemotina wetinau yauti ha lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ido we makafo unalafo ya uwolafo-mota adinalo biyageto hofo fulinabo ne. Ido we makafo olufola ya ayaidana o betinaibo ne. Ido olufotina yasi otinafo metinafo metina biyato hofo beti fulinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hemotina ya weninane minanako, wenina muki holi nosámibo-asámibo binafa, ido we makafo holi hiki loto auba ito minobo hena naba-naba hulanaibo hamenalo yonaibo we ya li nomuna wanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ido numuna malo minabo wenina yasi hofo betiti heni betiyatoma fulitoti numuna eito ya holi wilo. Ona lobiyowe. Hemotina Isilaeli numudo-namado yalo onona limo uwato nemo We Hula anobo hamenalo ya ononatina huladámageto anobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ena ege molaibo we yakafo api ilibibo we ya li yoima edámibo ne. Ido houba-naba we yamo wenabala ya li yoima o edámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Feito nenako, ha holinaibo we yamo api ilibibo we mona molaibo yaidana oto minanaibo ya moda ne. Ido onodo we ya onona yawala mona molaibo yaidana oto minanaibo ya moda ne. Ido numuna yawala nemo minobo ya Belesebuli ne, lo nedotima loto yoti weninane muki yagi hamadina hinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yagunu hamadina hiyabo weninawa ya holitina holiyámilo. Idafa muki faluku oto nebo ya aliga oloto pi betito, ido wase ibo nebo idafa muki ya oloto pito idipinogolaima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ido ha midipuku lobiyobo hawa ya fo lanaido ya lo oloto moloti, ido ha ma holoto hatinau labo ya numuna obito yoti ha naba loti lo oloto molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Feto lato, utina ya hofo beti fulinafa, ido weudina ya hofo beti fuliti ogofuwámabo wenina ya holitina holiyámilo. So fiyámanaibo soku ya weudinagi utina etuwa yagi maina hofo beti fulinaibo we yako holiya holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ena nama lomo loiti ya meinala hefola efoma ne. Feito nefa, Metinafo hiyaba o betibo we ya nama lomo mako mikalo lumu fou lanaibo ya holibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ido atatina opala muki yagi moda hitotaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yagunu holi holiyámilo. Emo nomunalo ya lemo weninala minonibo yakafo nama lomo muki ya li fulo betiyonima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ena we makafo wenina onobatinalo huline lo oloto molanaibo we ya nemo ayaidana oto okulumau Menefo onobalalo huliya ya lo oloto molanowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ido we makafo wenina onobatinalo meya numuto wa edámobo ne, lanaibo we ya nemokafo ayaidana oto okulumau Menefo onobalalo mene muto wa edámobo ne, loto lanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mikalo obo ya we wena ya li you lo ledanowe, loto aiye, loti hatina kiyámilo. E'e, we wena ya li you lo ledanowe, loto ámoto, ile himi lito owe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nemo obo ya uwolafo-uwolafo minanae, loto oboma nenako, Hipalakafo melafo ya uwolafo buliyageto, ido oluwakafo olafo ya uwolafo buli edanaibo ne. Ido onofula yakafo ola-kilofo ya uwolafo buli edanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ido we ma eimola numunalau unanabo weninala ya li uwolafo buli edanabo ne, loto ha mono lufuwau (Mai 7:6) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ido we ma olafofe melafofe lula-hala binaibo monala yakafo lula-hala numunaibo monala ya li fulo edaito ya yonewe minámiye. Ido we ma hipalafe oluwafe ya lula-hala binaibo monala yakafo lula-hala numunaibo monala li fulo edaito ya yonewe minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ido we makafo yá yofola mofuto nege molámanaibo ya ayaidana oto nemo yonewe minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Feito we ma eimola ula etuwagunuko holito minoto fulinaibo we ya u hopa unogolaiye. Ido we ma nemogunu holito monimo uto ula etuwa fulinaibo ya nomuna hofawa minowa-minowa anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ido we ma hemotina houna i betinaibo ya nemo ayaidana oto fe nedanogolaiye. Ido we ma houna i nedanaibo ya nilifibo we yagi fe edanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ido polofeti ya numunalalo aito ya we makafo wa edoto emo ya polofeti ma nenako, houna i edanowe, loto lanaibo we ya polofeti meinala ya liwila oto linogolaiye. Ido we makafo monala fefe libo we wa edoto me ya ya monala fefe libo we ma nenako, houna i edanowe, loto lanaibo we ya eimola monala fefe libo we meinala ya liwila oto linogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ha ona hula lobiyowe. We ma yakafo nege-nege moniyabo we yauti ma lula-hala ito lumuto nebo we ya wa edoto, nege molaibo yagunu hefa no muwoto nanaiye, loto feto feyanaibo we ya meinala u hopa aguwámanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesukafo ege-ege moniyabo we tuwelu (12) ya onona ha ya api itibitoto ebawa fulitoto ha mono api itibito lo oloto molanowe, loto Galili mikau numunatina meya nedo-nedo ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ena Yoni noku i beti-beti aibo we yakafo nala numugu minoto Kilisto onona libo hala ya holito ege molabo we ya Yesu nedo idipi molaito ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","uti feto lomuwabo, Anaiye, loti labo ya wema minabemo, ido we eito ma hiyabala anune? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ido Yesukafo lobibo, Liwila oti uti idafa muki holiti ido nomudinagunu wati abo ya Yoni feto lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nomudina likaibo wenina ya nomudina falatae. Ido hidina nosámibo wenina ya hanu moni-moni ae. Ido okola i hiliyabo ya hululudo beti-beti aiye. Ido hatina molaibo wenina ya ha holi-holi ae. Ido fuliyabo wenina ya fuliyaguti sinoi-sinoi ae. Ido idafa wa námabo wenina ya masi hala ukuwa dowa lo oloto bi-bi ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ido wenina masi nemogunu holiti holi fulitámanabo wenina ya ake inigilae. Feto feyae, loti lomuilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Feto lobito, ya Yoni ege molabo we ya liwila oti uwae. Liwila oti uwato, Yesukafo wenina nuba oti minabo ya lobibo, Yoni yagunu hafali mikalo uwabo ya nena idafa wanune, loti uwabo ne? Honofa asikafo lito uto loto aibo ya wanigili uwafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ido we ma ulalo owo dowa-idafa holoibo wanigili uwafe? E'e, moda utinalo owo dowa-idafa holoiyabo ya mikalo hiyaba we wehudi numunatinau yako mino-mino anabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ido nena idafa wanune, loti uwabo ne? Polofeti ma wa edanigili uwafe? O, wa edanigili uwabo wewa yagunu ha ma lobinogolowe. Holilo. Wewa wa edabo ya polofeti muki li fulo betito nebo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Emogunu Gotikafo libo, Moda hane lo oloto molanaibo we ilifiyoto u homu molo hedoto hanuka wili hedanogolaiye, loto ha mono lufuwau (Mal 3:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ha ona lobiyowe. Holifefe loti holilo. Wenipasi hedabo wenina muki yauti we makafo ya Yoni noku i beti-beti aibo we ya li yoima edámanaibo ne. Nefa, okulumau nebo we wehudite weninala hiyaba o ledaibo hilalau aifa we ma huliya minámibo yakafoko Yoni li yoima o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ido Yoni noku i beti-beti aibo we hamenalalo yaloti loto loto onesa melo ya okulumau nebo we wehudite weninala hiyaba o ledaibo hala ukuwa dowa ya wenina yasi linune, linune, loti aubafofo loti liyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Polofeti muki ido lo molaibo ha yasi hala ukuwa lo oloto molomo uti uti Yoni hamenalalo ya uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ido holi hikitanabo yama Elaiya ya anaibo ne, lo-lo aboma ya Yoni yagunu lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wenina hatina nebo yasi hawa ya holifefe loti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Ena onesa minabo wenina ya igaidana oto lo fi moloto lanowe? Ya olufo hefola yaidana oti minae. Olufo ya maketilo amedoti minoti hounatinafo-mota sutina fiti lobiyabo, Lemo nomu hofoto nama loba, ido hemotina melege liyámae. Ido fuliyabo nama lo fi molo betito loba, ido hemotina hufo ámae, loti ha naba loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Moda holiyafe? Yoni loto hafa hobina, no waini námoto moi i muibo ya wa edoti, ya Satani himiwela ya lulau mino edaiye, loti lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ido nemo We Hula ya loto hafa hobina, no waini noto moi iyámoto wa nedoti, Ake, moda hoba naba-naba noto no waini naba-naba noto ido hefana takisi li-li abo we ido lifimatina nebo wenina yotinawe ya ne, loti lo nedae. Feto lafa, ido hala-mananau nebo ya mona dowa molaibo yakafo fefe libo we ne, loti idipinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ena numudo-numudo aubala idipibo idafa li oloto pi bifa, ido lutina-hatina li elepa iyámabo yagunu hanu bito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aiyo, Kolasini numudo weninao, Betesaida numudo weninao, hemotina ya u hopa unigilabo ya holiyámafe? Hemotinaloka idafawa Goti aubala oloto pi betibo idafa ya Taiya numudo ido Saidoni numudo oloto pi betibo neko, ya aidenati lutina-hatina li elepa iti so lana manadinau wiliti utinalo owo fekali-makali aibo ya iyadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yagunu ha lobinowe. Holilo. Lifima hona molo betinaibo hamena nabalo ya Taiya ido Saidoni minabo wenina lifimatina ya ito lumuto bito, ido hemotina lifimatina ya ito yoto binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ido Kapeneyamu weninao, hulite ya li akaisa okulumalo yoto minanaiye, loti hatina kiyafe? E'e, feto feyámanogolaiye. Ya lowau fulaito yau lumuti minanigilae. Ido Goti aubala idipibo idafa hemotina ebatinau li oloto piyobo ya Sodomu wenina li oloto pi biyobo neko, onesa me ya ya Sodomu numuna eba aifa minadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yagunu ha lobiyowe. Wenina muki li hona molo betinaibo hamena nabalo ya lifimatina yakafo Sodomu minabo wenina lifimatina ya li fulo edanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hamena yalo Yesukafo feto libo, Menefo, mika okuluma Wenabala minanibo ya ha manadinau nebo wenina idafawa ya li faluku betito, ido aifa wenina olufo hefolaidana oti minabo ya li oloto pi biyanibo yagunu luwaka lo minowe, loto lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Menefo, luka-hakau feto feyanowe, loto holi dowa loto anibo feito ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Menefokafo idafa muki moda anelo moloitaibo ne. Ido wenina muki yasi Hipala minobo monane ya holi fefe ladámae. Menefo yako holibo ne. Ido wenina muki yasi Menefo monala ya ayaida oti holi fefe ladámae. Hipala minobo yagi ido emo ya li oloto pi betinowe, loto holiyobo weninagi yako holi minogeto wenina ma ya holi fefe ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hemotina onona naba-naba liti, hena naba-naba holiti, awisa loti, amika molabo wenina ya nemodoka ato, foli amena mona li oloto pi betinowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yaofane filiga abutinalo mofuti minato api itibinogolowe. Monane ya you loto nebo ido lune-hane ya ito lumuto we minoto, weudina foli amena minanaibo mona ya binogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Feito yaofane filiga abutinalo mofuwabo ya you libo ne. Ido mofunabo idafa biyobo ya hena áminako, hotiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aya hamenalo ya Sabati foliku ya Yesu suwa witi hifiyagu wito, ege-ege moniyabo we ege uti inagunu fuliti suwa witi ya lekoti hula feke oti noti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Feto feyabo ya Falisi we yasi wa betiti loga o edoti feto labo, Holabe? Hege-hege moniyabo we yasi lo fukaibo idafa ya oti Sabati foli monala ya li hopaitae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lomuwato, emokafo liwila oto libo, Defitigi mako moniyabo weninagi inagunu fuliti idafa feyabo ha ya mono lufuwau yau hemotina hitoti holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Goti numunalau yoti beleti molabo idafa fele ne, loti labo ya sokila molo muibo we lito bito naboma ne. Nato lo molaibo hala yau Gotikafo sokila hi muwabo we eimotinako nanae, loto libo idafawa Defiti ido weninala námanabo ya nae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ido lo molaibo ha mono lufuwa iyagu yau Sabati foliku sokila hi mu-mu abo we ya mono numugu onona liti, Sabati foli monala ya meyalo molámafa, lifimatina minámibo ne. Hawa ya hitoti holi fefe ladámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Feito nefa, nemo moda lobiyowe. Onesa melo makafo fele huliyagi numuna naba ya li yoima itaibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ido Gotikafo feto libo, Lune-haneu holiyobo ya idafa hofo hi numunae, loto holiyámoto, wenina milumatina holiti adina li faka lo-lo anae, loto holowe, loto ha mono lufuwau (Hos 6:6) ya nebo ne. Hemotina ya hawa monala yama holifefe loti holiyabo neko, lifimatina minámibo wenina li halo moloti sigiya lobiyámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yagunu holilo. Nemo We Hula ya Sabati foli yawala minowe, loto Falisi we liwila oto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ya ebawa ya fulito uto mono numunatinau yoito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","moda ana galidibo we ma neto, Falisi we yasi Yesu sigiya lomunubo mona ma monito wita anune, loti feto loga o edabo, Yesuwo, Sabati foliku ya wenina idafa hiliyabo ya li faka lo betinune, loti anabo ya lo molaibo ha fukanafe? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Emokafo liwila oto libo, Hemotina minadokati we ma sipisipila mako ma ya Sabati foliku haleku lumunaibo ya wewa anagunu lito li feka o edámanaibo nefe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipisipi ya aifa idafa nefa, ido wenina ya hula idafa minae, loti holiyámafe? Yagunu Sabati foliku mona dowa molanubo ya lo molaibo ha ya fukámanune, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lobito wewama, Aga sinolo, lomuito ana sino lito ana filiga nebo yamaidana oto li dowa feyaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ido Falisi we yasi feka lumuti, Yesu hofo fulinune, loti ha hudala hiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hawa lo hifiyabo ha ya Yesukafo holitoto numuna ebawa ya fulitoto wito, wenina naba ege uwato, idafa i hiliyabo wenina muki ya li faka lo betito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nemo ya li oloto pi binune, loti wenina lobiyámilo, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mona feito molaibo yagunu homu aidena Gotikafo polofeti Aisaiya ha welalo molaito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Moda me ya ya houba-nabane we wa molo o edobo ya lune-hane muto dowa loto wa edobo we ne. Weune ya molo edoto emokafo eito feka wenina mona lifefe lo betiyobo ha ya lobinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Emo yama ha naba loto moliya fi biyámageto hanudo-hanudo ya nola holiyámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wenina holi hikitina aubala minámibo ya honofa fokibo yaidana oti minabo yagunu leko fulito betinowe, loto ámanogolaiye. Ido wenina weudina you libo ya lamena le hefola efoma libo yaidana oti minabo yagunu hofo finowe, loto ámanogolaiye. Ido hala fefe libo ya holiti meyalo molo minanado ya hamena dowa oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ido huliyalo ya eito feka wenina mona-mona yasi ade li faka lo ledanaiye, loti hiyabala anabo ne, loto ha mono lufuwau (Ais 42:1-4) nebo hama ya ayalo iye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ena we ma Satani himiwela lula-halau mino edaito, nomuna likoto ha ladámibo we ya Yesu nedo ilimiti ato, li faka lo edaito, ya ha loto ido idafa-adafa waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Feto feyaito, ya wenina mau minabo muki yasi wati elegiti feto loga abo, Wewa ya Defiti yufa fibo we nefe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falisi wenina yasi hawa labo holiti feto labo, Wewa ya Satani himiwela wenabatina Belesebuli aubala yakafoko Satani himiwela li fulo betito idipi molaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Feto lato, Yesukafo hatina kiyabo ya holitoto feto lobibo, Mako wenina eimotina foki filiga-filiga oti fina fi minanabo ya ebatina li hopa itanigilae. Ido numuna meya malo weninafe ido yufa makoku weninafe eimotina foki filiga-filiga oti fina fi minanabo ya muki u hopa unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ido Satanikafo eimola Satani weninala heni betitoma ya eimola foki filiga-filiga anogolageyama weninala hiyaba o betibo ononala igaidana oto auba ito minanaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ido nemokafo Belesebuli aubala lito Satani himiwela wenina lutina-hatinau nebo idipi molotoma ya hemotina egetina molabo weninatina-mota ya hemakafo auba bito, wenina lutina-hatinauti Satani himiwela li fulo betiti idipi molo-molo o minae? Yagunu egetina molabo wenina yasi ya wa betiti hona molo betinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Feito nefa, ido Goti Weuna mino nedaibo aubalakafo wenina lutina-hatinauti Satani himiwela li fulo betito idipi molotoma ya moda okulumau nebo we wehudite weninala hiyaba o ledaibo mona ya hemotinaloka li oloto pi betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Feito nefa, we makafo aubafofo libo we ma numunalau ya fukoto yoto huwamenala linowe, lotoma ya homu uto aubafofo libo we ya nala i edageto ya huwamenala muki linogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","We makafo nemodo kelámanaibo ya uwonefo minanogolaiye. Ido we ma nemogi maina wenina li nuba o betiyámanaibo we yakafo wenina heni fulo betinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yagunu lobinowe. Holilo. Wenina lifimatina mona-mona muki ido wenina hamadina hiyabo hatina lifimatina muki ya hilili o betinogolaifa, ido masi Weuna Fele hamana hinabo ya lifimatina hilili o betiyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ido masi nemo We Hula ya hamane hinabo wenina ya lifimatina hilili anogolaifa, Weuna Fele hamana hinabo wenina ya lifimatina hilili o betiyámanogolaiye. E'e, hamena onesafe, ido hamena nabalo fedanaibofe, lifimatina ya minowa-minowa ageto hilili ámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yá dowa minanaibo ya ilawa dowa inogolaiye. Ido yá nosámibo minanaibo ya ilawa nosámibo inogolaiye. Feito wenina ya yá ilawa wafefe loti wanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hemotina hosofa olufola minabo, wenina nosámabo igaidana oti ha dowa ma lanae? Feito lutina-hatinau holiyabo nebo idafa yauti wetina yamo hawa ya lanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","We dowa yakafo idafa dowa weuna-lula-hala neguti ya idafa dowa li oloto pito, ido we nosámibo yakafo idafa nosámibo weuna-lula-hala neguti ya idafa nosámibo li oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Feito nefa, lifimatina li binaibo hamena nabalo ya wenina aifa ha labo muki yagunu lifima hona molo binaibo ne, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yagunu ha lo-lo ado yaloma holito ya lifimala minámibo we nefe, ido lifimala nebo we ne, loto hona molanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ena Falisi we ido lo molaibo ha api itibi-itibi abo we yasi loga o edabo, Api lilibiyanibo we, Goti aubala lilibibo idafa ma hemokafo li oloto piyageto wanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lato, Yesukafo liwila oto lobibo, Hemotina mona nosámibo moloti Goti kelámabo wenina yasi Goti aubala lilibiyageto wanune, loti lafe? Feto lafa, idafa hofawa Goti aubala itibibo idafa ma li oloto pi biyámanaibo ne. Ido polofeti Yona ulalo Gotikafo aubala ilibibo mebe-maba yako li oloto pi betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Feito Yona fo hamena tili (3) ido lubuka hamena tili (3) yalo ya laefa naba-naba houmalau nebo yamaidana oto nemo We Hula ya fo hamena tili (3) ido lubuka hamena tili (3) yalo ya mika lulau yau minanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ena lifimatina binaibo hamena nabalo ya Ninife numudo minabo we yasi sinoiti, sino loti, onesa me ya minabo wenina sigiya lo betinigilae. Ninife numudo minabo we yasi Yona ha libo ya holiti lutina-hatina elepa iyafa, ido onesa moda Yona li fulo edobo we ya meu minofa, lutina-hatina elepa iyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ido lifimatina binaibo hamena nabalo ya Seba mikau minabo wenina hiyabatina wena yakafo sinoito, sino loto, onesa me ya minabo wenina sigiya lo betinogolaiye. Seba wenina hiyabatina wena ya Solomoni ya ha mananau nebo we nenako, uto hala dowa holinowe, loto mika faiga-faigakati aibo nefa, ido onesa moda Solomoni li fulo edobo we ya meu minofa, ha lobo ya holiyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ido Satani himiwela we ma lula-halau mino edaibo lulauti loto fulo edoito uto hafali mikau yaleka monimo uto foli minanowe, loto yaidana eba ma monito wita omo wifa, eba ma oloto piyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Oloto piyámoto feto loto libo, Homu minobo numuna fulo edobo yalo hofa liwila oto unowe, loto holito liwila oto wiye. Liwila oto lo fedoto waima numuna hilili oto, feke loto, idafa-adafa muki lulau fefe lotoko ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ido hofa feka uto Satani himiwela seweni (7) hasuwala nosámibo fiyabo hasuwalala li fulo edoti minabo ya idipito aito, numunawa yau yoti unoti sinoiti minae. Feti minato, wewa ya homu Satani himiwela makoko lula-halau nebo ya nosámifa, ido aliga Satani himiwela muki lula-halau minabo yasi li nosámibo naba-naba o edabo ne. Ido monawa yaidana ya onesa me ya minabo mona nosámibo molo-molo o minabo wenina minadoka feito oloto pinaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ha lobi neto ya moda olafogi unalafo-mota yagi feka hiyaba minoti, ha lomunogolone, loti lato ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","we makafo feto lomuibo, Moda okafogi unakafo-motagi ha lohumunigili feka hiyaba minae, lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","liwila oto feto loto libo, Hema ya onefo ne? Hema ya unanefo-mota minae? loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ege-ege moniyabo we minado ya anagunu hetu pito libo, Moda meu ya onefo ido unanefo-mota minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ido masi okulumau Menefo hala dowa kibo mona meyalo molo-molo abo ya unanefo ido atonefo ido onefo ya minae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aya hamenalo ya Yesukafo numunauti lumuto no anawa sesepalo uto amedoto neto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","wenina naba abi loti nedoka nuba abo yagunu sipiku yoto amedoto neto wenina nuba abo muki ya no sesepalo sinoiti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","No sesepalo sinoi minato, idafa-adafa muki wase ito ha lobito ya feto libo, Moda we makafo yufa idafa itili anowe, loto migu wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Migu uto itili aito yufa idafa ma hanudo limo ibo ya nama yasi loti no hulae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ido yufa idafa ma hefana feumau neto mika hefola ma mulalo nedo limo ibo ya mika hefola neboma nenako, henemane oto fou lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","fo lido megunito lufawa mináminako, opaitaito fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ido yufa idafa ma hasuwala aibo idafa yoigu limo ito ya hasuwala aibo idafa yakafo yoto li itoto hofo fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ido yufa idafa ma mika dowa negu limo ibo ya fokito yoto ilawa iye. Ma yakafo ilawa abi loto wani hadeti (100) yaidana oto iye. Ido ma yakafo ilawa hefolama nabaidana sikisiti (60) yaidana oto iye. Ido ma yakafo ilawa hefola efoma teti (30) yaidana oto ibo yaidana-yaidana oto imo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hemotina hatina nebo wenina ya hawa ya holifefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ena ege-ege moniyabo we emo nedo loti ya feto labo, Nedafaito wase ito ha lobi-lobi o minane? loti loga o edato ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","emokafo lobibo, Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ha faluku oto nebo ya hemotina li oloto pi bitaima ne. Ido wenina malekama li oloto pi biyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ido we ma idafa wa naibo ya magi onu ito muwageto wa naibo idafala abi lanaibo ne. Feito nefa, ido we makafo idafa wa námanaibo ya idafa wa naibo idafala hefola efoma minanaibo ya emodokati liwila oto linaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Holi minafe? Nomudina yakafo wa-wa o minafa, ido idafa wafefe loti wagámae. Hatina yakafo ya ha holi-holi o minafa, ido holifefe loti holiyámae. Feti minanako, yagunu ha wase ito nebo ha ya lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aya weninawa yagunu Gotikafo hala ya polofeti Aisaiya welalo molaito feto loto libo, Hemotina holi-holi o minafa, ha holifefe loti holiyámoti, ido wa-wa o minafa, idafa wafefe loti wagámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Weninawa ya lutina-hatina moda gediboko minanako, hatina anawako holiti nomudina li likotoko minae. Feto feyámabo neko, nomudinakafo wa-wa o minoti, hatinakafo holi-holi o minoti, lutina-hatinakafo holifefe loti holiti lutina-muludina ya li elepa iti nemodo ato li faka lo betiyadi ne, loto ha mono lufuwau (Ais 6:9-10) nebo ha yama moda onesa me ya minabo wenina yalo iye. Yagunu wase ito ha lobimo uwowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hemotina nege molabo we nomudinakafo wafefe loti wati ido hatinakafo holifefe loti minanako, holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ha ona hula lobiyowe. Polofeti muki yagi ido Goti weninala monatina fefe labo weninagi yasi idafa obo hemotina wa edabo ya wanune, loti holiyafa, ido wa edámabo ne. Ido idafa api itibiyobo hemotina holiyabo ya holinune, loti holiyafa, ido holiyámabo ne. Yagunu wase ito ha lobi minowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yufa idafa itili aibo we wase ibo ha monala ya heimotina holiti fokiti holifefe lalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","We makafo wehudite weninala hiyaba o ledaibo hala ukuwa ya holito holifefe ladámitoma ya nosámibo yawalakafo loto hama ya wewa lula-halau hifibo yama henemane oto li fulitaiye. Yufa idafa ya hanudo limo ibo yamaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ido we makafo Goti hala holito ayalo lula-halau holi dowa holibo ya yufa idafa hefana mulalo limo ibo yamaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wewa ya lufawala ona li hiki ladámoto, aifa mulalo nebo yakafo ya Goti hala yagunu hena muti hasuwala fi edatoma, holi hikila ya aloko u hopa wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ido we makafo Goti hala dowa holifa, mikalo idafa-adafa muki yagunu hena holito, henala ido hefana-huwamena yakafo hola ito hala dowama li ito edaito ilawa iyámiye. Wewa ya yufa idafa hasuwala idafa yoigu limo ibo mika yamaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ido we makafo Goti hala dowa holito, mona holifefe loto holibo we ya yufa idafa mika dowa negu limo ibo mika yamaidana oto ne. Ido wewa hulawa wani hadetife (100), ido sikisitife (60) ido tetife (30) ya oloto pibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ido wase ibo ha ma loto lobibo, Okulumau nebo we weninala hiyaba o ledaibo monala ya we ma minawau ya suwa witi yufa dowa hifibo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wewa yufa dowa hififa, ido oku unaibo hamenalo ya uwolafo yakafo loto hofu yufa lito loto witi hifigu hiyalauma hifito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Feito ya suwa witi yufa fou loto yoibo hamenalo hofu yagi maina moda oloto pibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yagunu ya ononala liyabo we yasi mina yawala nedo uti lomuwabo, Wenabao, migau yufa idafa dowako hifiyanima nefa, hofu ya igauti yoiye? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Loga o edato, ya feto libo, Uwonefo makafo hifito yoiye, loto lobiye. Feto lobito ya onodo we yasi lomuwabo, Lemo uto hofu ya apu oto lifefe lanube? loti loga o edato ya feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","E'e, hofu ya apu one, loti suwa witi yagi apu otanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yagunu suwa witigi ido hofugi maina minoto o molanaiye. Feito hula lageto suwa witi fuko-fuko abo we homu ya hofu fukoti li nuba oti nalagunu wase iti fulo soku itoti hinae. Ido suwa witi ya li nuba oti liti numunaneu ya molalo, loto lobinogolowe, loto onodo we lobibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ido wase ito ha ma lobibo, Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya holipa ilawa ya we ma lito minau hifibo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Holipa ilawa hefola sogeya yaidana oto nebo yakafo fou loto yoto-yoto holipa yá naba yoiye. Ido idafa-adafa muki migu hifiyabo li fulo betito nebo yagunu nama okulumalo moniyabo yasi loti akawalo yalo numuna hu unae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ido wase ito ha ma lobibo, Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya feito yaidana oto ne. Wena ma beleti hofo hinogolowe, loto beleti li fudibo idafa huliya yisi lito, palawa naba yagi li buli-naboli oto moloto hiyaba aito, ena yisikafo upatoto ito beleti muki li fudibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Hawa ya Yesukafo nuba abo wenina lobibo, ya fefe loto lo oloto pito lobiyámoto, wase ibo hako lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Feito homu aidena polofeti makafo feto libo, Wase ito ha lobiyobo ya mika okuluma oloto pibo hamena yaloti idafa faluku oto nebo ya lanogolowe, loto ha mono lufuwau (Sng 78:2) nebo ha feito ibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu ya mau minabo wenina fulo beti itoto numugu yoito ege-ege moniyabo we emo nedo loti ya feto labo, Hemo hofu migu yoibo wase ito ha lanibo ya mona lageto holinune, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ido emokafo liwila oto feto lobibo, Wewa yufa idafa dowa hifibo we ya nemo We Hula ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ido mi hifibo ne, lobo ya mikau muki ya ne. Ido yufa idafa dowa ya Goti hilalau minabo wenina ya minae. Ido hofu yufa nosámibo we yawala weninala ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ido uwolafo hifibo we ne, lobo ya nosámibo we yawala Satani ya ne. Ido suwa witi fukanabo hamenae, lobo ya mika okuluma hulanaibo hamena ya ne. Ido fuko-fuko abo weninae, lobo ya okulumau enisole ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ido hofu fukoti wase iti soku hi hulabo ya ayaidana oto mika okuluma hulanaibo hamenalo yalo ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","nemo We Hula ya enisolene idipi moloto, nemo hilaneu yauti wenina muki weninatina li hopaitabo wenina, ido mona nosámibo molabo wenina, muki ya li nuba o betiti ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","fiyámanaibo soku ya fulo betinae. Yau fulo betiyato lumunabo ebau ya hufo naba-naba oti wetina hofala guti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hamena yalo monatina fefe libo wenina yasi fo hiyala fulaibo yaidana oti Metinafo hilalau lamena anabo ne. Hatina nebo wenina yasi hawa ya holifefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya we makafo idafa dowa idafa meinala hefola minámibo yama eito we migu haleku faluku molaibo ya li oloto pito watoto guninaibo yaidana oto ne. Idafawa waibo yagunu lula-hala holi dowa loto uto eimola huwamenala muki hefanalo fulo hulo itoto liwila oto uto idafa dowa idafa hale libo mikama ya meina fiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya feito yaidana oto ne. We makafo hefanalo fulo hulanowe, loto ekeni idafa omonala neboma ya wita omo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wita-wita oto ekeni idafa omonala nebo yama muki li yoima o betiboma ya li oloto pito, huwamena idafala muki wenina bito hefana muwato uto ekeni idafawa omonala neboma ya meina fiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ido okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya laefa li-li abo owo noku fulato lumuto laefa hola eito-eito nebo libo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Owoma faitito ika oti limo sesepaloma oti, amedoti laefa ya hona moloti, nanabo idafa dowa ya owoku moloti, ido námanabo idafa ya fulitabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ido mika okuluma hulanaibo hamenalo yaidana idafa fedageto ya enisole yasi loti wenina monatina fefe libo molabo wenina minagu yauti ma monatina nosámibo molabo ya hona moloti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","so fiyámanaibo soku yau fulo betiyato, lumuti yalo hufo naba-naba oti wetina hofala guti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Idafawa muki yagunu lobiyobo ya moda holiti holifefe loti holiyafe? loto loga o betito, feto lomuwabo, O, moda holito holifefe loto holiyone, lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","emokafo libo, Goti lo molaibo hala holifefe loti holiyabo we yasi okulumau Menefo weninala hiyaba o ledaibo ha api itibiyobo ya holi hikitoti meyalo molanabo, ya we ma api lilibiyabo ha lila ido ha hofawa yauti idafa dowa libo yaidana oto ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesukafo wase ito ha mona-mona muki ya loto lo hulo itoto ebawa ya fulitoto ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","eimola numunala ebalalo loto mono numunatinau yoto ha mono api itibito, holiyabo ya elegiti feto labo, Aiyo, ha mananau nebo yagi ido Goti aubala lilibibo idafawa li oloto pi lumibo auba yagi igaukati liye? ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wewa yo-hola ya numuna hu-hu aibo we hipalama yae. Ido olafo Malia ido unalafo-mota Yemusikele Yosefekele Saimonikele ido Yudasikele yama yae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ido emonala-mota muki ya lemogi maina minonima yae. Ena wewa me ya idafa-adafawa muki ya igaukati liye? loti ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","emo yagunu lutina-hatinau eleka fi umae. Feto feyato Yesukafo feto libo, Polofeti ma eimola numunala meyalo ido eimola numunalalo yako weninala huliya li faka ladámanigilabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ido aya ebalo wenina muki holi hikitina mináminako, idafa hofawa Goti aubala idipibo idafa muki ya idipiyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ena aya hamenalo ya Galili wenina hiyabatina we wenaba Heloti ya Yesu hala ukuwa holitoto, emogi maina minabo wenina ya feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aya wewa ya Yoni noku i-i aibo we minoto ya fuliguti li sinoi edainako, yagunu Goti aubala lilibibo auba ya mino edaito idafawa feyaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ido homu Helotikafo unalafo Filipi olonafo Helotiyasi libo yagunu Yonikafo feto lomuibo, Wenawa ya liyanibo ya Mosese lo molaibo hala ya fukaninako, lifimaka ne, loto lomuibo yagunu Helotikafo libo, Yoni ya liti analo-hinalo nala i edoti, nala numugu fulo edalo, lobito idipi molaito uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Uwato, hofo fulinowe, loto holifa, wenina muki yasi polofeti ne, loti holiyabo yagunu holitina holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ena Heloti oloto pibo hamena lo fedito, Helotiyasi oluwa ya wenina muki nomudinalo melege lito, Helotikafo wa edaibo lula-halau holi dowa lito ya feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nemo Goti nomunalo auba ito lo molobo, hemokafo idafa yaidana-meidana linowe, lananibo ya moda humunogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lomuito, olafokafo homu oluwa hala lito feto libo, Yoni noku i-i aibo we henobala fuko fuloto atala ya lapelo moloto ito loto nomo, loto lomuwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lomuito, hala meyalo molanaibo hiyaba wenabama lula-hala hena aifa, wetina-idafa maina nabo wenina nomudinalo auba ito lo molo edainako, feto libo, Idafawa lito loto umo, loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","we ma ilifi molaito, nala numugu ya uto Yoni henobala fuko fuloto ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","atala ya lapelo moloto lito loto oluwa muito, lito uto olafo muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ena Yoni ege molabo we yasi loti hono ula liti uti haleu moloti uti Yesu hawa ya lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ena Yesu hawa holitoto nebo eba ya fulito sipiku yoto hameto mikau wiye. Utaito wenina muki hawa ya holiti, numunatina ebatina fulitoti mikalo moniti ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ege uwato, Yesu momeno anawalo lo fedoto sipikuti lumuto, wenina muki ya wa betito lula-halau milumatina holito idafa i hiliyabo weninatina ya li faka lo beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ena lunaga molaito ege-ege moniyabo we emo nedo loti ya feto lomuwabo, Melo ya mika hameto minogeto moda lunaga molotaiye. Wenina ya idipi molageto numudo-numudo uti wetina idafa meina finae, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesukafo neidafaito unabo ne? Hemotina yasi wetina-idafa ma bilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lobito, liwila oti lomuwabo, Beleti faifu (5) ido laefa loiti (2) yako li minone, lomuwato ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","feto libo, Idafawa ya me ya nemo minodoka italo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lobito ido wenina nuba abo suwalo amedalo, loto lobito beleti faifu (5) lito laefa loiti yagi lito okulumau wa faka loto, dowae, lalowe, loto lomuto ya beletigi laefagi fukoto, ege-ege moniyabo we bito, wenina mau naba minabo ya biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Biyato, muki wenina noti houmatina aito, luma nebo liti holiyabo ya owo egepisa naba tuwelu (12) holiyabo ya faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ido wetina idafa nabo wemoli ya faifu tauseni (5,000) minato, ido wenipagi olufogi ya hitámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ayalo Yesukafo ege-ege moniyabo we ya feto lobibo, Wenina nuba abo idipi molodo ya hemotinagi sipiku ya yoti momeno filiga anawalo homu moloti wilo, loto lobito, sipiku yoti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Uwato, wenina nuba abo ya idipi moloitoto eimolako Goti lomunowe, loto obulalo yoto neto, midipu ito eimolako ayalo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Neto, sipima mika fulito u momeno lusaku utaito, asi ma hotinalokati aito no yamo halafu ito loto sipima hofaito, lito yoto lumuto iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Holomolomo yaleka Yesu no momeno mulalo hinagunu lala ito monimo loto minado lo fedito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","wa edoti utina ololo oti ya, Aiyo, holofa ne, lato holi bito, hai molato ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu aloko lobibo, Lutina-hatina you laneyo. Nemoma minowe. Holi biyámaneyo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lobito, Pitakafo feto lomuibo, Wenabao, ona minagetoma no mulalo ano, lonomageto no mulalo monimo minanido anowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Feto lito, ya ano, loto lomuito, Pita sipikuti lumuto no mulalo monimo Yesu nedo aifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","asi naba aibo waibokafo holi muito, no lulau lumuto, Wenabao, anelo liyo, loto hai moloto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ayalo Yesukafo ana sino loto ulalo lito feto libo, Holi hikika hefola efoma nebo ya neidafaito haka loiti kiyane? loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","loitiwa sipiku yowaito, asi fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ido sipiku minabo we weudina-lutina-hatina ya muti feto lomuwabo, Hemo ona Goti Hipala ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ido momeno ya yofototo uto Genesalete mikau lo fedato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","wemoli ebawa yau minabo yasi wa edotiti, aya wema ne, loti wafefe loti holiyato, eba selo nedo-nedo ya ha fulo filiga-filiga ato, wenina idafa i hiliti minabo muki ya idipiti emo nedo loti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Idafa i hiliyabo yasi owo holoiyanibo onuwalo yako linafao? loti wako lo edato, idafa i hiliyabo wenina muki adinagunu liyabo ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ha mono lufuwa api itibiyabo we ido Falisi we ya Yelusalemukati Yesu nedo loti loga o edoti feto labo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hege-hege moniyabo we yasi awatefo-mota hidene hatina holiti li fulitae. Nedafaito wetina-idafa nanigilima ya adina noku iyámae? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Loga o edato, emokafo feto libo, Ido hemotina ya nedafaito awatinafo-mota hidene hatina meyalo moloti ya Goti lo molaibo hala meyalo molámae? ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yagunu Gotikafo libo, Otinafo metinafo hulitina li faka lalo, loto lo moloto lima ne. (Kis 20:12, Lo 5:16) Ido ha magi libo, We makafo ha nosámibo olafofe melafofe ya lo betinaibo, aya we ya hofo fulilo, loto ha mono lufuwau (Kis 21:17, Wkp 20:9) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Feito nebo yama nefa, hemotina yasi feto lo-lo abo, We makafo olafofe melafofe feto lobinaibo, Huwamenane wa nobo yakafo adina li faka lanaibo idafama ya Goti moda mutonako, yagunu hemotina liyámanaibo ne, loto lobinaibo ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ya idafawa olafo melafo biyámanogolaiye, loti lo-lo ae. Feti heimotina ya awatinafo-mota hidene hatina ya meyalo molo minafa, Goti lo molaibo ha ya li aifa idafa yaidana oti fulitae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hemotina monona loiti iyabo yagunu Gotikafo Aisaiya welalo ha molaito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Aya weninawa ya wetinalo yako huline li faka lafa, ido lutina-hatinau holi nomámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Weudina-lutina-hatina sugiko numuti, ido aifa wenina hidene hatina yako api itibi-itibi ae, loto ha mono lufuwau (Ais 29:13) nebo ya hemotinagunu ha ona lo betiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesukafo wenina nuba abo sutina fito, emo nedo ato, ya adina noku i-i abo mona yagunu lobibo, Holiti holifefe loti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Idafa-adafa wetinau nabo yakafo Goti nomunalo hemotina ya li ladi o betiyámifa, wetinauti feka aibo yakafoko Goti nomunalo hemotina ya li ladi o beti ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lobito, ege-ege moniyabo we ya emo nedo loti lomuwabo, Falisi wemoli ya ha lanibo holititi lukafa naba otae. Moda holabe? loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","emokafo feto libo, Yufa idafa Menefo okulumau nebo wekafo hifiyámibo ya lufawagi apu anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waiti betilo. Weninawa hanu idipiyabo nomudina likaibo wenina yaidana oti minae. Ido nomuna likaibo we makafo eito ma nomuna likaibo we ya hanu ma ilibiyagetoma, loitiwa ya hale nabau yau lumu fou lanigilaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lobito, Pitakafo feto libo, Wase ito hawa mona ya lolomageto holinune, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesukafo hanu bito feto libo, Ake, hemotina yagi holifefe loti holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wetina-idafa ya wetinau nato, uto sebatinau-houmatinau uto minoto, aliga ya sefe lo fulo-fulo abo yama holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Feto feyaifa, wetinauti feka aibo ya weudina-lutina-hatina yauti aibo nebo yakafoko Goti nomunalo hemotina ya li ladi o betinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yagunu weudina-lutina-hatina yauti ya hatina-manadina nosámibo kiyabo, wenina ya hofo beti fulinubolae, ido hume-ugele anubolae, ido hopa-napa li unanubolae, ido idafa ugele linubolae, ido sugi ha lanubolae, ido hamadina hinubolae, loti hatina kiyabo idafawa muki ya weudina-lutina-hatina yauti aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aya idafawa yakafo Goti nomunalo hemotina li ladi o beti nefa, ido adina noku iyámabo mona yakafo Goti nomunalo li ladi o betiyámibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ena Yesu ya ebawa fulitoto monimo Taiyagi ido Saidonigi eba yolaleka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wito, yalo wena ma Yuda wena minámibo eito Kenani mikauti aibo yakafo emodo loto sula naba fito feto lomuibo, Wenabao, Defiti yufa fibo we, nemogunu mulugau miluma holi nedo. Satani himiwelakafo olune lula-halau minoto hasuwala fi edo-edo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lomuito, emokafo liwila oto ha ma lomuwámito, ege-ege moniyabo we emo nedo loti ya feto labo, Wenawa ilalu huto hai naba-naba molo minoto lege-lege molainako, ilifi molo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lomuwato, feto libo, Isilaeli wenina sipisipi moni faluku abo mona yaidana oti moloti minado yako nilifiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lobito, wenawa ya loto emodo hinalo huba i muto ya feto libo, Wenabao, ane li faka lo, lomuito ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","feto libo, Olufo wetina-idafa lito fiyasito hula binubo mona ya unámiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lomuito, liwila oto libo, Wenabao, ona laba, hulama yasi yawalatina wetina-idafa no minato lana mikalo limo ibo ya no-no ae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesukafo libo, Wenao, holi hikika naba ne. Fedo numunaiye, loto holiyanibo idafa ya fedo humunaibo ne, loto lomuito, ayalo oluwa faka lo fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ido Yesu aya eba fulito monibo Galili momeno naba anawalo uto monimo obulalo yoto amedoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ido wenina nuba naba-naba abo yasi hidina nosámibo, ido hidina-adina galidibo, ido nomudina likaibo, ido nei molabo, ido idafa eito-eito i hiliyabo wenina ya idipiti emo nedo loti hinalo nuba o betiyato, muki li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Li faka lo betibo, ya nei molaboma ya ha labo, ido hidina-adina galidibogi yama ya u dowa loti uwabo, ido hidina nosámibo yamagi hanu moniyabo, ido nomudina likaibo yamagi ya wabo ya wa betiti yagunu wenina muki yasi elegiti Isilaeli wenina Gotitina ebola lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesukafo ege-ege moniyabo we sutina fito ato, feto lobibo, Wenina naba nuba minabo ya fo hamena tili (3) yalo ya nemogi melo minabo ya nanabo idafa minámibo yagunu lune-haneu miluma holi biyoto, inagunu fuliyanako, uti hanudo lumu fou lotanae, loto idipi molámanogolowe, loto holiyowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Feto loto lobito, ege-ege moniyabo wema yasi lomuwabo, Eba me ya hameto ya nenako, beleti naba ma igalekati lito wenina nuba naba yaidana ya biyogeto noti ogofunabo ne? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ido Yesukafo libo, Beleti nenaki li minae? loto loga o betito, liwila oti lomuwabo, Lemo beleti seweni (7) ido laefa hefola magi li minone, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Feto loti lomuwato, wenina muki amedoti minalo, lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","beleti seweni (7) ido laefa ya lito, dowae, lalowe, loto lekoto ege-ege moniyabo we bito, wenina nuba naba minabo ya biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Biyato, muki ya noti houmatina aito, ido luma nebo ya li nuba abo owo egepisa naba seweni (7) holiyabo ya faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ido wetina-idafa nabo wemoli ya fo tauseni (4,000) minato, ido wenipagi olufogi ya hitámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ena wenina muki idipi moloitoto ya sipiku yoto uto monimo Magadani mikau wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ena Falisi we ido Sadusi we yasi hepa molo munune, loti Yesu nedo loti ya feto labo, Okulumauti Goti aubala lilibinaibo idafa ya lilibiyageto wanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lato, emokafo liwila oto lobibo, Lunaga ya fo sapito okuluma ufa luta libo watima, ya leda fo lanaibo ne, loti lo-lo ama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ido leda ya okuluma lubufa loto asi aitoma, eletifo ya ho inogolaiye, loti lo-lo ama ne. Ido hemotina ya okuluma monawa ya wati holifefe loti holitafa, ido nemogunu ido eletifo hamena yagunu ya mebe-mabawa fedibo wati ya monawa holifefe loti holinabo ya ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mona nosámibo moloti Gotigi kelámabo wenina yasi Goti aubala idipibo idafa moniti wita afa, ido Goti aubala idipibo idafa ma ya li oloto pi betiyámanaibo ne. E'e, polofeti Yona ulalo Gotikafo aubala ilibibo mebe-maba yako li oloto pi betinaibo ne, loto lobito fulo betito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ido ege-ege moniyabo we momeno anawa filigaleka ya u fedoti beleti hatina molaito liti aguwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ido Yesukafo libo, Falisi we ido Sadusi we yisitina ya ekei oti monilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hawa lobibo ya eimotinagu loyolalo-melo oti ya feto labo, Beleti loto itámoninako, yagunu, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ha labo ya Yesu holitoto feto libo, Holi hikitina hefola efoma nebo we, nedafaito beleti itámabo yagunu loyolalo-melo o minae? ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hemotina ya holifefe ladámoti minafe? Beleti faifu (5) lito wenina faifu tauseni (5,000) biyobo yama hatina molaife? Ido luma nebo liti owo nenaki ya holiyae? Yamagi hatina molaife? ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ido beleti seweni (7) ya wenina fo tauseni (4,000) biyobo yamagi hatina molaife? Ido luma nebo liti owo naba nenaki ya holiyae? Yamagi hatina molaife? ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Beleti yagunu lobiyámowe. Igaidana oti holifefe loti holiyámae? Hemotina ya Falisi we ido Sadusi we yisitina ya ekei oti monilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ayalo ha libo mona ya moda holiyabo, Yisi ona yagunu ekei oti monilo, loto ladámoto, Falisi we ido Sadusi we api itibiyabo hatina yagunu ekei oti monilo, loto lobibo hawa monawa ya holifefe loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesukafo Sisalia Filipai ebau lototo ege-ege moniyabo we loga o betito feto libo, Wenina muki yasi nemo We Hula yagunu ya hema ne, loti lo-lo ae? loto ya loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Loga o betito, liwila oti feto loti labo, Wenina maleka masi Yoni noku i beti-beti aibo we ya minane, loti lo minae. Ido maleka masi Elaiya ya minane, loti lo minae. Ido ma yasi Yelemaiyafe, ido we ma polofeti minagu yauti we ya minane, loti lo minae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ido hemotina yasi nemo ya hema ne, loti lo minae? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimoni Pitakafo feto libo, Hemo ya hilifi molaibo we Kilisto, Goti minowa-minowa aibo we Hipala ona ya minane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lomuito, Yesukafo libo, Ba-Yona hipala Saimoniyo, ha feito lanibo ya wenina yasi lo oloto pi homámae. Aya hawa ya menefo okulumau nebo wekafo fefe loto li oloto pi hedaibo yagunu dowa loto holi minomo uwane. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hemo ya Pita minane, loto lohomowe. Ido hefana naba-naba me ya mulalo ya mono weninane li nuba o betimo yowoto fulimo uwabo mona li yoima o betinaibo ya ogofuwámanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ido okulumau nebo we wehudite weninala hiyaba o ledaibo hilala hanu-wela ito huto feyananibo auba ya humunowe. Ido idafa muki mikalo nala inanibo ya ayaidana oto okulumau yagi nala moda itaibo ne. Ido idafa muki mikalo wina ananibo ya ayaidana oto okulumau yagi moda wina otaibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lomutoto ege-ege moniyabo we maleka ya lobibo, Nemo yagunu ilifi molaibo we Kilisto ne, loti wenina muki lobiyámilo, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hamena yaloti Yesu Kilistokafo apito ege-ege moniyabo we ha lo oloto pi bito feto libo, Ena Yelusalemu numudo uwoto wenina hiyabatina we ido Goti sokila hi muwabo we ido lo molaibo ha api itibiyabo we yasi hena naba-naba li mofu nedoti hofo nedo fuliyato, fo hamena tili (3) minoto ya li sinoi nedanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ena Pitakafo ilimito anawaleka uto hanu muto ya libo, Ake, Wenabao, moda idafawa ya ona fedo homámanaibo ne, loto auba ito lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lomuito, Yesu elepa ito libo, Sataniyo, negeka uwa. Hemo ya hefanalo hine uteba inabo hefana yaidana oto minane. Goti hala kibo yaidana oto haka kiyámoto, aifa mikalo wenina hatina kiyabo yaidana oto haka kiyanibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesukafo ege-ege moniyabo we ya lobibo, We makafo nemo nege molanowe, lotoma ya eimola lula-halau holinaibo idafa ya fulitoto, yá yofola ya mofuto nege molanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yagunu we makafo eimola ula etuwagunuko holi minoto fulinaibo we ya u hopa unogolaiye. Ido we makafo nemogunu holito monimo uto ula etuwa fulinaibo ya nomuna hofawa minowa-minowa anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","We makafo mikalo idafa-adafa muki ya wa noto monimo wifa, ido weuna-lula-hala u hopa unaibo we ya wa naibo idafa-adafala igaidana oto ana li faka lanaibo ne? Ido nena-idafakafo meina fito weuna-lula-hala hofa liwila oto linaiye? ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ena nemo We Hula ya Menefo lamenala nabau yau okulumau enisolenegi maina ya oloto pito loto wenina muki eimotina monatina molado ya lifimatina hona molo binogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nemo ona lobiyowe. Onesa me ya sinoi minagu yauti malekama ya fuliyámoti, homu ya nemo We Hula ya weninane hiyaba o betinowe, loto anobo hamena ya wa nedanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Fo hamena sikisi (6) ya utaito Yesukafo Pitale, ido Yemusile unalafo Yonile idipito obula naba fanalo yoti eimotina yako minato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","nomudinalo Yesu ula ya u eito bulito, hola-wela ya fo lamenala yaidana oto lamena aito, ido ulalo owo ya feke ona libo yaidana oto lamena aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ayalo Mosesete ido Elaiyate oloto piti emogi ha lo minato wa betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wa betiti Pitakafo feto libo, Wenabao, melo minonibo ya dowa liye. Heimoka holinanibo ya numuna holo-hala tili (3) huwogeto, ma ya hemo numunaka minanaiye. Ido ma ya Mosese numunala minanaiye. Ido ma ya Elaiya numunala minanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Feto lito, moda hawa lo nedo ayalo ya limu ma lamena hu-hu liboma ya moda loto wase i betito, ya moda limuku yauti nola ma holiyabo feto libo, Me ya ya lune-hane muwobo Hipane ya ne. Emo ya dowa loto wa edowe. Hala ya lutina-hatinau holilo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ena ege-ege moniyabo we hawa nola holiti ya mikalo lumu fou loti holi naba-naba holiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesukafo ya minado loto utinalo lito ya feto lobibo, Mikalo yati sinoiti holi holiyámilo, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","wa faka loti wa edabo ya wenina ma minámato, Yesu eimola yako ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ena obulaloti monimo lomado ya Yesukafo lobibo, Idafa onesa wa edabo ya wenina ma lobiyámoti, minomo uwato nemo We Hula ya fulinoguti sinoitoto ya lobinae, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lo fuko betito, ege-ege moniyabo we feto loti loga o edabo, Elaiya homu anaibo ne, loti lo molaibo ha api itibi-itibi abo we yasi neidafaito feto lo minae? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Loga o edato, feto libo, Ya ona ne. Elaiyakafo homu loto idafa-adafa muki ya lifefe lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Feito neboma nefa, Elaiya ya moda lotaifa, wati wafefe loti wa edámoti, idafa-adafa muki lutina-hatinau holiyabo ya fe edotama ne, loto lobiyowe. Ido ayaidana oti nemo We Hula ya hena naba-naba numunigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Feto lito, ege-ege moniyabo we ya Yoni noku i beti-beti aibo we yagunu lobiye, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Emotina ya wenina nuba oti minado ya liwila oti lo fedato, we makafo loto hinalo hina obula fito ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","feto libo, Wenabao, hipanegunu luka-hakau milumala holiyo. Hululu hofoto ula ogofu naba-naba li muito, hamena-hamena sokufe, ido noku yau lumu fou lo-lo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Feito hege-hege moniyabo we minadoka ilimito ofa, ula li faka lo edanabo ya ogofuwámae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lomuito, Yesukafo libo, Ake, hemotina holi hikitina minámito monatina lekesa ibo molabo weninao, hamena nenaki ya hemotinagi minanowe? Ido hamena nenaki ya hemotina henatina mofu betinowe? Hipawama ilimiti nemodo alo, lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ilimiti ato, Yesukafo Satani himiwela hanu muito, hipa lulauti fulo edoito wito, ayalo ya moda faka loitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ena ege-ege moniyabo we eimotinako minoti Yesu nedo loti feto loga o edabo, Li fulo edoto ilifinubo ya neidafaito ogofuwámone? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","feto libo, Holi hikitina hefolako nenako, yagunu ilifinabo ya ogofuwámae. Feito nebo nenako, nemo ona lobiyowe. Holi hikitina ya yá holipa ilawa yaidana oto minanaibo ya obula yowa ya okaleka fulitoto meleka ano, lomunabo ya anogolaiye. Ido idafa ma yagunu ogofuwámone, loti ladámanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Feto feyanafa, ido aya Satani himiwelawa yaidana hilibo yagunu ilifinune, lotima homu wetina-idafa moi iti Goti lomutiko ilifinigilae. Ilifinabo hanu ma minámiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ido Galili yalo maina uwato, Yesukafo feto libo, Nemo We Hula ya wenina adinalo biyato ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hofo nedo fuliyato, fo hamena tili (3) uwageto fulinoguti ya li sinoi nedanogolaiye, loto lobito, holiti lutina-hatina hena naba-naba aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ena Kapeneyamu numudo lo fedato, ya fele huliyagi numuna naba hefana takisi li-li abo we yasi Pita nedo loti loga o edoti labo, Api itibibo we yakafo fele huliyagi numuna naba hefana takisi ya fulo-fulo ámife? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lato, liwila oto lobibo, Moda fulo-fulo aiye, loto lobito numunau yoi neto, ayalo Yesu loto homu loga aibo, Saimoniyo, haka kiyo. Mikaleka wenina hiyabatina we wenaba ya igalekati hefana takisi li-li ae? Weninatina yalekatife, ido mika malekamati abo wenina yalekatife? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Loga o edaito, Pitakafo libo, Mika malekamati abo wenina yalekati li-li o minae, lito ya Yesukafo libo, Feto nebo nenako, lemo hipatina minonibo ya hefana takisi fulámanubo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nefa, lutina-hatina holi lumunabo nosámotanaiye, loto uto momenoku ya laefa liyabo nala ya noku fuloto laefa hana linanibo ya ika oto welau ya li atoto hefana ma minanaibo ya lito hemote nemote hulitelo hefana takisi ya biyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aya hamenalo ya ege-ege moniyabo we Yesu nedo loti loga o edabo, Okulumau nebo we wehudite weninala hiyaba o ledaibo hilalau ya hema homu moloto huliya nebo we minanogolaiye? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Loga o edato, olufo hefola ma sula fito, aito nomudinalo minagu li sinoi edoto feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nemo ha ona lobiyowe. Hemotina monatina ya li elepa iti u olufo hefola yaidana oti feyámanabo ya okulumau nebo we wehudite weninala hiyaba o ledaibo we hilalau yau aguwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ido we ma lula-hala lito lumuto olufo hefola me ya yaidana anaibo we ya okulumau nebo we wehudite weninala hiyaba o ledaibo we hilalau u homu moloto huliya nebo we ona minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ido ma yasi nemogunu holiti olufowa hefola meidana oto minabo wenina li houna i betinabo ya nemogi li houna i nedanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ido Yesukafo ha ma feto libo, We makafo olufowa hefola holi hikito nomabo wenina yauti ma ya hola ito holi hikila li hopaitanaibo wewa ya analo hinalo liti henobalalo hefana naba-naba nala iti ho nolula hamulupigu no noto fulinaiye, loti fulo edabo neko, moda dowa loto feyadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mika negu-negu ya idafa nosámibo yakafo holi hikito nomabo wenina ya hatina fito hanu lalototi ika o betinaibo ne. Idafa-adafawa nosámibo ya moda fedanogolaifa, ido we makafo holi hikito nomabo wenina ya hatina lito hanu lalotoka yati ika o betinaibo we ya hena naba-naba holinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yagunu aga yakafofe ido higa yakafofe lifima li mofu hedagetoma aga yafe ido higa yafe fukoto li fulito. Moda holiyafe? Feito aga filigakofe ido higa filigakofe mako minageto ya minowa-minowa abo ebalo yonanibo mona yakafo aga loitife ido higa loitife nebokafo fiyámanaibo soku unanibo mona ya li yoima edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ido nomuga yakafo idafa wa edoto lifima li mofu hedagetoma ya nomuga kilito fulo. Feito nomuga makoko minageto minowa-minowa abo ebalo ya unanibo mona yakafo nomuga loiti minageto so fiyámanaibo soku yau unanibo mona ya li yoima edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ido wati monilo. Wenina olufowa hefolaidana yauti ma ya miyanumu o edámilo. Ha me ya lobiyowe. Holilo. Enisole hiyaba o betiyabo okulumauka minabo yasi hamena-hamena Menefo okulumau nebo we ya hola-wela wa o minae.  ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yagunu nemo We Hula ya moni faluku abo wenina ya monito wita oto li nomudina wanowe, loto obo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Hatina kiyalo. We ma sipisipila wani hadeti (100) neguti mako ma moni faluku agetoma, wewa yakafo sipisipila muki nainti-naini (99) aifa nebo ya fulo betitoto obulalo ya uto, sipisipila mako moni faluku aiboma ya monito wita ámanaife? ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ha ona lobiyowe. Moda monito wita oto li oloto pinaibo ya lula-hala dowa holibo mona yakafo sipisipila nainti-naini (99) ya aifa nebo yagunu lula-hala dowa holibo mona yama li yoima edanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Feito ayaidana oto Metinafo okulumau nebo we yakafo olufowa hefola minagu yauti mako ma moni faluku anaiye, loto hala holiyámibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ena mono weninaka minaguti hounakafo makafo mona nosámibo molo hedanaibo ya uto heimotinako minoti nosámibo mona molaibo yagunu hanu umo. Hanu muwageto haka ya holifefe loto holiyagetoma hounakafo hofa liwila oto linanibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Feito nefa, ido haka holi fulagetoma, hemogi we makofe ido loitife maina ha holinabo ya idipito nedo unae. Aliga wenina loitife ido loitigi-makogife ya ha lanibo ya onae, loti lobinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ido hatina ya holiyámagetoma monolo nuba abo wenina lobiyageto, uti lomuwato hatina yagi holiyámagetoma ya eito feka wenina ido hefana takisi li-li abo we mona molo betinabo yamaidana oti mona molo edanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ha ona hula lobiyowe. Me ya mikalo nala inanibo ya ayaidana oto okulumau yagi nala moda itaibo ne. Ido idafa muki mikalo wina ananibo ya ayaidana oto okulumau yagi moda wina aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hofa lobiyowe. Mikalo me ya loiti masi idafa-adafa magunu holiti, lutina-hatina mako moloti lumunabe? loti lomunaibo ya Menefo okulumau nebo wekafo holito idafawa muki feto fe betinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yagunu wenina loitikofe, ido tili (3) yako ya nemo hulinelo maina minanabo ya emotina minagu yau minanogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ena Pitakafo Yesu nedoka loto feto libo, Wenabao, hamena nenaki hounanefokafo mona nosámibo molo nedagetoma, lifimala hilili o edanowe? Hamena seweni (7) moloto ya modafe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesukafo libo, Hamena seweni (7) molageto ya moda ne, loto lohomámowe. E'e, hamena sewedi-seweni (77) ya hilili o edomo uwo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yagunu okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya mikalo hiyaba wenaba makafo houba-nabala we lifima bibo ya lifefe lanogolowe, loto holibo we yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ena lifima apito lifefe lo betimo wito we ma lifimala teni tauseni (1000) taleni ya nebo emo nedo ilimiti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ilimiti afa, lifimala liwila oto munaibo ya ogofuwáminako, yagunu hiyaba wenabala yakafo houba-nabala wenina ma feto lobibo, Wewa, olonafo, olufola yagi idipi eito wenina ononatinalo itageto, uti onona liyato, ononatina meinala ya linowe. Ido huwamenala muki ya hefanalo fuloti hefana liti ya hefanane moda naibo ya liwila oti numilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lobito yagunu houba-nabala we yakafo hinalo loto hina obula fito wako lo edoto feto libo, Wenabao, ha lanibo feto ladámoto, hiyaba mino. Hefanaka muki ya liwila oto humunogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ido hiyabala we wenaba ya hala holito, lula-halau milumala holito, wina oto lifimala hilili o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Hilili o edaifa, houba-naba wewa ya feka uto wa edaima ya houba-naba we ma wani hadeti (100) denaliyasi ya muito lifimala aifa nebo we ya wa edoto, henobala lito, ipili hito feto libo, Hefana homobo muki ya moda onesa liwila oto nomo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Feto lito, houba-naba wewa ya hounalafo hinalo uto hina obula fito feto libo, Ha lanibo ya feto ladámoto, hiyaba mino. Hefanaka muki ya liwila oto humunogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Feto lifa, hala holiyámoto, ilimito uto nala numugu fulo edoto libo, Hefana lifima muki liwila oto nomagetoma wina hedanowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Feto lomuito onona maina liyabo hounalafo-mota yasi hounatinafo wabo ya lutina-hatina nosámito, hiyabatina we wenaba nedo uti hawa muki lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lomuwato, hiyabatina we wenaba yakafo wewa sula fito aito feto libo, Houba-naba we nosámanibo ona minane. Milumane holiyo, loto lonomaninako, hefana lifimaka muki ya hilili o hedowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nemo ha lanibo holito, lune-haneu milumaka holiyobo yaidana oto hemo yagi hounakafo yagunu luka-hakau milumala neidafaito holiyámane? loto lomuto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","sebala hala-kala naba lito, nala numugu ula ogofu li munabo we adinalo bito feto libo, Hefana lifima muki liwila oto nomagetoma wina hedanowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ena hemotina muki lutina-hatinau yau hounatinafo-mota lifimatina ya hilili o betiyámatoma Menefo okulumau nebo wekafo ayaidana oto lifimatina ya hilili o betiyámanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu aya hawa ya lo huloito Galili mika fulitoto, monimo Yudia mikau Yodani no naba filigaleka wito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","wenina nuba naba-naba ege molato, ido yalo wenina idafa i hiliyabo li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ido Falisi we yasi, hepa molo munune, loti emo nedo loti feto loti labo, We ma olonafo ya mona-mona molaibo yagunu fuko fulitanaibo we yakafo lo molaibo ha fukanaife? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Loga o edato, emokafo feto libo, Hana ya mika okuluma li oloto pibo wekafo we wena li oloto piye, loto ha mono lufuwau (Stt 1:27) nebo ha ya hitoti holifefe loti holiyámafe? Ido ha ma feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yagunu wemoli yasi otinafo metinafo fulo betiti olodinafolo kelabo, loitiwa ya utina u mako loti minanaiye, loto ha mono lufuwau (Stt 2:24) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yagunu loitiwa ya loiti minámiye. E'e, moda u makoko loti minainako, yagunu Gotikafo li kelaibo ya wenina fuko filiga-filiga o betiyámilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lobito, liwila oti labo, Feto netoma ya Mosesekafo we ma olonafo fuko fulitanaibo we ya hiyaba we minadokati lufuwa iyabo ya lito olonafo muto fuko fulitanaibo ne, loto libo ya neidafaito liye? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Loga o edato, liwila oto lobibo, Hemotina lutina-hatina gedibo yagunu Mosesekafo ya olodinafo fuko filiga-filiga fulanabo ya feti feyanae, loto hawa libo ne. Nefa, hana ya hanu yaidana oto minámima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E'e, we ma olonafo hopa li uno-uno oto moniyámibo ya fuko fulitoto uto wena eito linaibo we ya moda hume-ugele anaiye, loto lobiyowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Feto lito ege-ege moniyabo we ya feto lomuwabo, Feto netoma wena liyámanogolaibo mona yakafo we wena maina mofu moloti minanaibo mona ya li yoima edaiye, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lomuwato, ido emokafo feto libo, Wenina muki hawa holiyabo ya ogofuti meyalo molámanae. E'e, Gotikafo aya auba bibo wenina yako hawa meyalo molanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Feito we malekama ya otinafo houmalauti wenagi keloti ogofuwámanabo we minabo yagunu wena liyámanae. Ido wenina yasi we malekama li wenagi keloti ogofuwámanabo we gedanako yagunu wena liyámanae. Ido we malekama ya okulumau nebo we wehudite weninala hiyaba o ledaibo we ya houba-naba o edanune, loti holiyanako, wena liyámanae. Hawa ya holifefe loti holiti holi ogofunabo ya hawa liti meyalo molalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ena olufo hefola ma Yesu nedo idipiti abo ya anagunu atatinalo lito emotinagunu holito Goti lomunaiye, loti lafa, ido ege-ege moniyabo we yasi hanu biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hanu biyato, Yesukafo feto libo, Okulumau nebo we wehudite wenina olufowa yaidana oti minabo wenina ya hiyaba o betinako, yagunu olufo nemodo anabo ya hanu hu betiyámilo, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ana ya atatinalo litoto, ebawa ya fulitoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ena we ma moda Yesu nedo loto loga aibo, Api lilibiyanibo we, nemo hofawa minomo yonabo mona ya linowe, loto holinobo ya nena mona dowa molanobo ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Loga o edaito, feto libo, Mona dowa yagunu neidafaito loga o nedane? Mako yako dowa ne. Ido hemo nomune hofawa minanowe, lotoma lo molaibo ha ya meyalo molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Feto lomuito, emokafo libo, Lo molaibo ha ya igamae? loto loga o edaito, Yesu feto libo, Wenina hofo beti fuliyámo. Hume-ugele ámo. Idafa ugele liyámo. Ha sugi lobiyámo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Okafo mekafo hulitina li faka lo. (Kis 20:12-16) Heimoka yagunu holiyanibo yamaidana oto wenina muki ya luka-haka biyo, (Lo5:16-20) loto ha mono lufuwau nebo ha ya lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lomuito, we hofawe yakafo libo, Hawa muki ya moda meyalo molomo uwowe. Yagunu ma igaidana anowe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Loga o edaito, Yesukafo libo, Hemo ufefe ona lanowe, lotoma ya uto huwamenaka muki ya hefanalo fuloto, hefana lito idafa wa námabo wenina ya hona moloto biyo. Feto feyageto ya okulumau huwamena dowa oloto pi humunogolaiye. Ido loto nege molo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lomuito, we hofawe yakafo hawa holito, idafa naba wa naibo nenako, yagunu lula-hala hena naba aito ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wito, Yesukafo libo, Ona lobiyowe. Huwamena naba-naba wa naibo we yakafo okulumau nebo we wehudite weninala hiyaba o ledaibo hilalau yonowe, loto holinaibo ya hosa naba finaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ha hofa lobiyowe. Safu-kameli yakafo naka lulau unaibo ya hosa finaibo nefa, ido idafa wa naibo we yakafo Goti wehudite hilalau yonowe, loto holinaibo ya ito yoto hosa naba-naba finaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lobito, ege-ege moniyabo we hawa libo ya holiti, elegiti feto loga abo, Feto nenako, yagunu hemakafo wenina li nomudina wanaiye? loti lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesukafo wenu fefe loto wa betito feto lobibo, Wenina yasi ya ogofuwámafa, Goti yakafo idafa-adafa muki feto feyanaibo ya moda ogofuto ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lobito, Pitakafo loga o edoto feto libo, Lemo moda idafa-adafa muki fulitoto hege moloninako, nena idafa linubo ne? loto lito ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesukafo libo, Ona lobiyowe. Idafa-adafa muki hofawa oloto pinaibo hamenalo ya nemo We Hula yakafo wenina hiyaba o betinowe, loto lamenau ekeni folomolo ya amedoto, hemotina nege-nege moniyabo yagi ekeni folomolo ya tuwelu (12) yalo amedoti minoti Isilaeli wenina afu monalo-monalo tuwelu (12) ya hona molo betiti weninawa hiyaba o betinae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ido wenina masi ya nemogunu holiti numunatina ebatina, yatinafo unatinafo emonatina, otinafo metinafo, olufotina, midina fulitanabo wenina ya ayalo naba-naba liwila oti liti, ido nomudina hofawa minowa-minowa oti minomo yonigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Feito nefa, ido wenina abi hulitinagi we minabo ya hulitina ya lumunaibo ne. Ido hulitina lumibo wenina ya hulitinagi we minanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Okulumau nebo we wehudite weninala hiyaba o ledaibo monala ya mika yawala yaidana oto ne. Leda luwaila fo yoito mika yawala uto nala waini ilawa hifibo migu ya onona linabo we idipito anowe, loto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Feito uto wewa onona linabo wemoli ya fo hamena mako onona liti ya onona fo hamena mako hefana meina denaliyasi mako ya linae, lobito, O, linune, loti lato, ido nala waini ilawa minau ya onodo idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aliga fo lo gedito maketilo uto, wemoli ma aifa sinoi minabo ya wa betito lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hemotina yagi nala waini ilawa mineu uti ya onona liyato onona meina fefe loto binogolowe, loto lobito onodo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Uwato, ido folilo yagi hofa liwila oto uto, ido lunaga yagi hofa uto, wemoli ma ya ononalau idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ido lunaga fo hufinogolaibo hamena yaidana uto, wenina malekama sinoi minabo ya wa betito lobibo, Neidafaito aifa foli sinoi minae? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lobito, emotinasi lomuwabo, We makafo onona linubo lomáminako, aifa minone, loti lato, emokafo libo, Hemotina yagi mineu uti nala waini ilawa onona li nedalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena lunaga molotaito mika yawalakafo hiyaba aibo we lomuibo, Onona liyabo we muki ya li nuba oto, onona litato aliga abo we onona meinatina ya homu biyo. Ido homu abo we meinatina ya aliga biyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Feto lomuito wenina fo sapito lunaga loti onona liyabo we muki ya onona fo hamena mako meinala hefana denaliyasi mako ya biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ido leda luwailati onona apiti liyabo wenina yama meina naba linubo ne, loti hatina kiyafa, ayaidana oto wenina muki yagi onona fo hamena mako meinala hefana denaliyasi mako ya biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Feito bito, meina liyado ya mika yawala ya hanu muti lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wenina aliga abo ya hamena foumako onona liyabo, ido lemo ya leda luwailati loto onona naba li minogeto fo ligu onona liyonibo meina li mako itoto meina yaidana oto lomane, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lomuwato, emokafo we ma liwila oto lomuibo, Weninane, li nosámibo hedámowe. Hemokafo onona lito ya fo hamena mako meina hefana denaliyasi mako ya linowe, loto labe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yagunu meinaka lito uwo. Aliga aibo we ya hemogi meina ayaidana oto binowe, loto holiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nemo neimo idafanema nenako, yaidana-meidana anowe, loto holinobo ya feto ámanobo nefe? Ido idafa bi holiyonako, yagunu luka-haka naba hofo nomabe? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Feito wenina abi loti hulitinagi we minabo ya hulitina ya lumunaibo ne. Ido hulitina lumibo wenina ya hulitinagi we minanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ya Yelusalemu yonowe, loto ege-ege moniyabo we tuwelu (12) ya idipito eimotinako hanudo uwabo ya feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Moda Yelusalemu numudo akaisa yowogeto, yalo nemo We Hula ya sokila molo muwabo we wenabatinagi ido lo molaibo ha api itibiyabo wegi adinalo biyato, ha fi numuti hofo nedo fulinune, loti ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","eito feka wenina adinalo biyato, hamane hiti, nala osogunu ikula hofo nedoti, yá yofolo ya hofo nedo fuliyato, fo hamena tili (3) uwageto fulinoguti ya hofa sinoinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ena aliga Sebedi olonafo idafa ma linowe, loto holito, ido hipala loiti yagi Yesu nedo ato, otinafokafo hina obula fi muito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesukafo loga o edaibo, Nena idafa linowe, loto holiyane? loto lito, liwila oto feto lomuibo, Hemo weninaka hiyaba o betinanibo hamena yalo hipane loiti ya ma fulo aga onaleka ito, ido ma aga adawaleka ito betiyageto, ya amedoti hafukalo we minanaiye, loto holiyowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Feto lito, Yesukafo libo, Loga o nedanibo idafa ya monawa holifefe ladámane. Nemo hasuwala fi nedanabo hapu ya hemotina yaidana oti ogofuti linaife? loto loga o betito, feto laibo, Aifa linoibo ne, loti lomuwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesukafo libo, Nemo hena holinobo yaidana oti holinigilaifa, ido hafunelo filiga-filiga minanaibo ne, loto lanobo ya ogofuwámowe. E'e, Menefokafo ebawa lifefe lo betitaibo wenina ebatina ya ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lobito, ege-ege moniyabo we teni (10) ya hawa holiti hounatinafo loiti hafuwalo we minanoiye, loti lainako, loitiwa holi nosámibo biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yagunu Yesukafo sutina fito ato lobibo, Hemotina holiyabo ya eito feka wenina hiyabatina we yasi onona liyabo ya eimotina hulitina li faka loti auba iti, feti feyalo, feti feyalo, loti ha lobi-lobi ama ne. Ido hiyabatina we wenaba yagi auba iti lobiti hiyaba o beti-beti abo monatina ya hemotina holi minama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Holi minafa, ido mona molaboidana hemotina minagu ya molámilo. E'e, we ma hemotinagu yauti wenabatina minanowe, loto holinaibo we ya hemotina houba-naba ononatina ya liyaneyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ido makafo wenaba ona minanowe, loto holinaibo ya nalalo houba-nabatina we minoto houba-naba onona liyaneyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ayaidana oto nemo We Hula ya wenina houba-naba o nedanae, loto ámowe. E'e, houba-naba o betito, ido lifimatina yagunu u hopa utanae, loto eimotina ebatina lito fulinowe, loto owe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ena Yesugi ege-ege moniyabo wegi Yeliko numuna fulitoto uwado wenina nuba naba-naba Yesu ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ege uwato, moda we loiti ma nomudina likaibo ya hanu anawalo amedoti minaibo yasi Yesu aiye, loti labo ha holiti feto laibo, Wenabao, Defiti yufa fibo we, milumate holiyo, loti auba iti sula fiyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Feto laito wenina muki yasi, Ha hedámoti holoti minaliyo, loti hanu biyafa, wewa loiti yasi, Wenabao, Defiti yufa fibo we, milumate holiyo, loti oto yoti ha naba loti sula fiyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Laito, Yesu hanudo minoto sutina fito loga o betibo, Nemo ya hemotina neidafa o ledanaiye, loti holiyaiye? loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lito, liwila oti feto laibo, Wenabao, nomude li falato ledanane, loto holiyoiye, loti lomuwaito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu lula-halau milumatina holito nomudinalo lito, ayalo nomudina falatito ege uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ena uto Yelusalemu li alili moloto, ya Betefage numuna Olifi obula hinau yalo fedoto, Yesukafo ege-ege moniyabo we yauti we loiti ma idipito ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","feto libo, Hemotina numuna meya meu selo negu yau uti, ayalo safu-dogi olafogi mofolagi nala iyabo minanaibo ya wa betiti, nala wina oti liti liwila oti nemo minodo aliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Feto aito we makafo loga o betiyagetoma, Wenabakafo emo ononala ma neto yagunu lito oiye, loti lomuliyo. Feto lomunaibo ya ayalo safu-dogi ya idipinogolaiye, loto lobito idipiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Feto feyaibo yagunu Gotikafo ha polofeti welalo molaito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Hemotina Saiyoni we wena feto loti lobilo. Walo. Hiyabatina we wehudi ya hemotina minadoka aibo ya mona you liboko molo-molo aibo we ya safu-dogi meyalo amedoto ne. Safu-dogi mofola meyalo amedoto minoto ya aiye, loti ya lobilo, loto ha mono lufuwau (Sek 9:9) nebo ha yama ayalo iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ido ege-ege monibo we loitima Yesu welalo hololoti uti ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","safu-dogi olafogi mofolagi idipiti loti, utinalo owo feka iyaibo ya li fuloti safu-dogi meyalo molaito, Yesu yoto amedoto minoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wito, wenina naba-naba mau minabo yasi, Wenabate ne, loti utinalo owo ya li fuloti hanudo unaido holaleka mikalo ya wilimo uwato, ido wenina malekama ya yá akawa lekoti hanudo ya molomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ido wenina nuba naba li homu-homu o edabo ya ido masi li aliga-aliga o edabo yasi feto loti labo, Aiyo, dowae, hosana! Defiti yufa figuti weyo, luwaka lanune. Wenaba huliyalo aibo we ya dowa loto holimo wibo ne. Yoisau okulumau minabo yagi ayaidana oti, aiyo, dowae, hosana! loti lo-lo ae, loti aiyo-weiyo lo edomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ya monimo uto Yelusalemu numudo ya yoito wenina minabo muki ya elegiti feto labo, We me ya ya hema ne? loti loga-miga ato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","wenina nuba naba masi, Galili mikau Nasalete numudoti polofeti Yesu ya ne, loti liwila oti lobi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ido Yesukafo fele huliyagi numuna naba hilalau ya yoto idafa meina fiti minabo wenina, ido idafa meinalo fuloti minabo wenina wa betito ya muki heni fulo feka betito, ido hefana hola eito-eito nebo ya li filiga-filiga abo wenina folomotina muki yagi, ido nama mulu meinalo fuloti minabo wenina folomotina yagi muki ya li elepa ito fululu kaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Fululu kaito feto libo, Ha mono lufuwa igu feto loto libo, Numunane ya ha lonumu-numu abo numuna ne, loti lanabo ne, loto ha mono lufuwau (Ais 56:7) nebo nefa, hemotina yasi li ugele we numunatina yaidana o minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Feto lobito aya fele huliyagi numuna nabau minaido ya nomudina likaibo ido hidina nosámibo wenina ato li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Li faka lo betito, sokila molo muwabo we hiyabatina we ido lo molaibo ha api itibiyabo we Goti aubala itibibo idafa li oloto pibo ya wati, ido olufo fele huliyagi numuna naba ebalo minabo yasi Aiyo, Defiti yufa fibo weyo, luwaka lo minone, loti labo ha holiti ya sebatina hala-kala loitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Feti ya loga o edabo, Meu minabo wenina ha labo ya holabe? loti lato, Yesukafo liwila oto lobibo, O, moda holiyowe. Ido ha ma, Olufo namunagi ido olufo yagi wetinaloti luwaka lanae, loto ya oloto piyane, loto ha mono lufuwau (Sng 8:2) nebo hama hemotina ya hitoti holiyámafe? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Loga o betito fulo betitoto numuna meya naba hilalauti feka uto, Betani numudo yoto lubuka yalo unaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ido leda luwaila numuna meya nabalo ya unowe, loto hanudo monimo aido ya inagunu fulito ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ya yá sigolo ma hanu anawalo watoto yá monalo wifa, ilawa iyámito ailako nebo watoto, hofa ilawa iyámanaiye, loto lomuito, ayalo yá aila ya meguniye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yá aila megunito, ya ege-ege moniyabo we wati elegiti feto labo, Igaidana oto yá sigolo aila ya henemane oto meguniye? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesukafo libo, Ona lobiyowe. Holi hikito numuti lutina-hatina loiti molámatoma, yá sigolo feto fe edobo yaidana oti feto feyanigilae. Ido yako minámiye. Hemotina obula okaleka yowa nebo ya ho noku sinoito uwo, loti lanabo ya hatina meyalo molanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Idafa ma muki yagunu linune, loti holi hikitoti Goti lomunabo ya moda linae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ido Yesu ya fele huliyagi numuna naba hilalau yoto, wenina ha mono api itibi neto sokila molo muwabo hiyabatina we yagi wenina hiyabatina we wenaba yagi emodoka loti loga o edoti labo, Hemo ya idafa fe-fe anibo ya hema welaloti holito fe-fe ane? Ido hemakafo lohumito fe-fe ane? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lato, Yesukafo libo, Nemo yagi hemotina ya idafa mako ma loga o betiyoto, logane ya liwila oti fefe loti lonomatoma, nemo ayaidana oto hema welaloti holito idafawa feyobo huliya ya lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Holilo. Yoni noku i beti-beti aibo we ya hema welaloti feto fe-fe aibo ne? Okulumau nebo we welaloti nefemo, ido aifa wenina wetinaloti ne? loto loga o betiye. Loga o betibo hawa ya holiti yagunu loyolalo-melo oti feto labo, Okulumau nebo we welaloti ne, lanubo ya nedafaito holi hikito umámae? lolumutanaiye, loto feto ladámanune. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ido aifa wenina wetinaloti ne, lanubo ya wenina muki Yoni polofeti ne, loti holiyabo yagunu wenina holitina holiyone, loto ya feto ladámanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Feto loti liwila oti lomuwabo, Lemo holifefe ladámone, loti lomuwato, emokafo libo, Nemo yagi ayaidana oto hema welaloti idafa-adafa fe-feyobo yama lobiyámanogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesukafo feto libo, Hatina kiyalo. We ma hipala loiti minaibo ya homu hipala nedo uto lomuibo, Hipane, eletifo ya uto nala waini ilawa mineu ya onona liyo, lomuwageto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","hipalakafo libo, E'e, eleka hofo nedaito, ononaka liyámanogolowe, lifa, aliga ya lula-hala elepa itoto uto onona liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ido wewa hipala ma nedo uto ayaidana ha lomuito, hipalakafo liwila oto feto libo, O, menefo, uto ononaka linogolowe, lifa, aguwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Feito hipala loiti yauti hemakafo melafo welalo hololiye? loto loga o betito, feto labo, Homu hipala ne, loti lomuwae. Lomuwato, Yesukafo libo, Nemo ona lobiyowe. Hefanatina takisi li-li abo we ido hopa li uno-uno abo wenipa ya Goti wehudite weninala hiyaba o betibo hilalau yau hemotina u homu molo betiti yonae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Holiyafe? Yonikafo hemotina minadoka mona fefe libo hanuwa api itibinowe, loto aifa, hemotina yasi holi hikito umámafa, hefana takisi li-li abo we ido hopa li uno-uno abo wenipa ya holi hikito muwae. Feto feyabo ya hemotina wa edotama nefa, lutina-hatina li elepa iti holi hiki ladámae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesukafo libo, Wase ibo ha ma holilo. Mika yawala we makafo migu nala waini ilawa hifito, hila fito, hidinagunu nala waini ilawa lipi anabo eba lifefe loto, nala waini ilawa hiyaba anabo numuna huto, feto fe huloitoto minawa ononawa ya hiyaba abo we adinalo moloito monimo eba faigaka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ena nala waini ilawa hula lanaibo hamena ya alili agetoma houba-nabala we feto lobibo, Mine hiyaba abo we minado uti, nala waini ilawa hula li nedoti alo, loto idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Idipi molaito, mina hiyaba abo we minadoka u fedato, mina hiyaba abo we yasi houba-nabala we ma adinalo-hidinalo liti, we ma ya mainafagunu hofoti, ma ya hofo fuliti, ma ya hefanagunu hofae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Feto feyato, ena houba-nabala we ma abi loti ya hofa idipi molaito uwabo mina hiyaba abo we yasi ayaidana hofa fe betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Feto feyato, aliga ya eimola hipala emotina minado ilifito feto libo, Wa edoti hala holinabo ne, loto ilifi minagu ya molaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","mina hiyaba abo we yasi hipala ya wa edoti, eimotina loyolalo-melo o minoti feto labo, Emo yakafo melafo idafala we fi molo edaibo idafala muki linogolainako, yagunu hofo fulito idafala muki ya linune, loti ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","migu yauti li feka fuloti, hofo fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yagunu mina yawala yakafo anaibo ya mina hiyaba abo wewa ya neidafa fe betinaiye? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Loga o betito, liwila oti labo, Nosámabo wewa ya li nosámibo o betito, hofo beti fulito, wenina eito ma ya nala waini ilawa mina hiyaba anabo, hula lanaibo hamenalo ya numu-numu anae, loto migu onona adinalo binaiye, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Feto lomuwato, Yesukafo feto libo, Ha mono lufuwau yau feto libo, Hefana ya numuna huwabo wenina wa aifa idafaidana itabo nefa, ido aya hefanawa yama moda numuna lagi hola fibo ne. Wenaba yakafo idafawa feto feyaibo ya wa edoto elegiyone, loto ha mono lufuwau (Sng 118:22-23) nebo hawama ya hitoti holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yagunu lobiyowe. Goti hiyaba we wehudi weninala hiyaba o ledaibo mona ya hemotinalokati lito eito feka wenina hulawa li oloto pinabo ya adinalo binogolaiye.  ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ido we makafo hefanawama yalo lumu fou lanaibo ya aubala leko-mako loto li hopa anaibo ne. Ido hefanawama yakafo we ma meyalo limo inaibo ya wewa ula ya moda metala-atala anaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ido sokila hi muwabo we hiyabatina we ido Falisi we yasi wase ito ha libo ya lemo lo ledaiye, loti holiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nala i edanabo hanu moniti wita afa, wenina muki ya polofeti ne, loti holiyabo yagunu holitina holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesukafo wase ito ha hofa feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Okulumau nebo wehudite yakafo weninala hiyaba o ledanaibo monala ya hiyaba wenaba ma hipala wena linogolaibo yagunu wela-idafa naba li nuba oto hofo hibo we yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wewa yakafo onodo we feto lobibo, Wenina homu sutina fiyobo minado uti idipiti anae, loto idipi molaito uwafa, sutina fibo wenina ya eleka o betito ámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yagunu onodo we ma hofa idipi moloto feto lobibo, Uti homu sutina fiyobo wenina ya feti lobilo, hoba-hobina ya hofo hito, ido bulumakaufena sipisipifena moda hofo hito, muki idafa lifefe lo huloninako, yagunu loti we wena adinalo li bito wetina-idafa nanae, loti lobilo, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Idipi molaito, uti hawa lobiyafa, holiyámoti aifa hanu eito-eito uwato, ma ya eimola minau wito, ido ma ya eimola hefana ononalalo wito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ido malekama yasi onodo wewa adinalo-hidinalo liti utina li nosámibo o betiti hofo beti fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hiyaba wenabama hawa holito sebala hala-kala lito, himiwe idipi molaito, uti hofo beti fuliyabo weninawa muki hofo beti fuliti, numunatina ebatina yagi lepa ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lepa ato, onodo we lobibo, Hipane wena lito wela idafa lifefe lobo ya nanune, loto wenina su fi betiyofa, monatina fefe ladámibo yagunu anabo ya ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yagunu hanu hofala nedo-nedo uti, wenina muki wa betinabo ya sutina fiti, idafa nanuniyo alo, lobiti idipiti anae, loto onodo we lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lobito, uti hanu hofala nedo-nedo monimo uti, wenina muki oloto piyabo, mona dowa molabo ido nosámibo molabo, muki ya idipiti ato, numuna nabau ya wenina naba nuba oti amedoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nuba oti amedoti numugu ya minato, hiyaba wenabakafo wa betinowe, loto yoto wenina wa betimo wiye. Wa betimo wibo ya we ma hipa wena lido unigili holoi-holoi abo owo ulalo iyámibo ya wa edoto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Weninane, hipa wena linigilado holoi-holoi abo owo ukalo iyámanibo ya igaidana oto numugu meu ya yowane? loto loga o edaito, wema ha ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ha ladámito, hiyaba wenaba ya onodo we feto lobibo, Wewa analo-hinalo nala iti midipu igu feka fulato, aya midipu igu yau hufo naba-naba oti wetina hofala guti minanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ena ayaidana oto Gotikafo wenina muki ya sutina fifa, ido mako-mako wa molo betiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ena Falisi we yasi feka uti, Yesu ha lanaibo ya ha lito sigiya lo edanune, loti nuba oti hudala hi minoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","egetina molabo we ido Heloti ege molabo we Yesu nedo idipi molato uti feto loti labo, Api lilibiyanibo we, ha ona hulako lane, loto holi minone. Ido Goti hanula dowa yalo moninabo monagunu ona hula api lilibi-lilibi o minane. Ido aifa weninafe, ido hulitina nebo wenina ya holitina holiyámoto, ha ona yako lo minane. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Feito loga o hedogeto ha liwila oto lananibo holinune. Ena hiyaba wenaba Sisa hefana takisi mu-mu onibo mona ya fefe loto nefe? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesukafo hatina-manadina nosámibo hiyabo ya holitoto feto lobibo, Hemotina monona loiti iyabo we, nedafaito hepa molo nomae? ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hefana takisi fulanabo hefana ya nilibilo, lito hefana denaliyasi mako ya li oloto piti ilibiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesukafo wa edoto lobibo, Weunagi lufuwalagi me ya ya hema idafala ne? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ya Sisa weunagi lufuwalagi ne, loti liwila oti lomuwato feto libo, Feto Sisa idafala liti ya Sisa liwila oti muilo. Ido Goti idafala liti ya Goti liwila oti muilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hawa libo ya holiti elegiti fulo edoiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aya hamenalo Sadusi wenina ya wenina fuliyagu yauti sinoiyámanabo ne, loti holiyabo ya Yesu nedo loti loga o edabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Api lilibiyanibo we, Mosesekafo feto libo, We ma olufo hedámoto fuliyagetoma, unalafo yakafo wena-hiyona ya lito yalafodo olufo li oloto pi edanaiye, loto libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ido lemo minonigu ya yalafo-unalafo seweni (7) ya minato, ena homu yatinafo ya wena lito olufo hedámoto fulito, unalafokafo wenawa liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lito emo ayaidana oto fulito, unalafo makafo wenawa lito fuliye. Fetiko fe liti uwato, yalafo-unalafo seweni (7) ya wenawa mako liti fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muki ya fuliyato, aliga wenawa yamagi fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Fulito, yalafo-unalafo seweni (7) ya wenawa liyaboma nenako, yagunu wenina fuliyabo ya hofa sinoinabo hamenalo ya hema olonafo minanaibo ne? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Loga o edato, Yesukafo liwila oto libo, Hemotina ya ha mono lufuwau nebo ha ido Goti aubala yagi holifefe loti holiyámanako, yagunu hopa ha lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wenina fuliyaguti sinoinabo hamenalo ya we wena mofu molámato, we wena adinalo li biyámanigilae. E'e, Goti enisolela okulumau minabo yaidana oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ena wenina fuliyaguti hofa sinoinabo hamena yagunu Gotikafo lobibo ha ya hitámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Feto lobibo, Nemo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila minowe, loto ha mono lufuwau (Kis 3:6) ya nebo ne. Emo ya wenina fuliyabo Gotitina ya minámiye. E'e, wenina nomudina hofawa minabo yako Gotitina ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ido wenina mau minabo ya hawa libo holiti ya mono api itibibo hala yagunu elegiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ena Falisi we yasi Yesu ya Sadusi we li you lo betiye, loti labo hawa holiti ya nuba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ido mau minagu yauti we makafo lo molaibo ha ya hitoto holifefe libo we ya Yesu hepa molo edanowe, loto emo nedo uto feto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Api lilibiyanibo we, lo molaibo ha yauti ya nena ha ya u homu uto auba ibo ha ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Loga o edaito, Yesukafo libo, Luka-haka muki ido weuga muki ido haka-managa muki ya Wenaba Gotika ya umo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","loto lo molaibo hau (Lo 6:5) nebo hawa ya u homu uto auba ibo ha ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ido aliga ha ma ayaidana oto nebo, Heimokagunu holiyanibo yamaidana oto weninaka muki ya luka-haka bi-bi o mino, loto ha mono lufuwau (Wkp 19:18) ya nebo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hawa loiti ya Goti lo molaibo hala ido polofeti hatina muki ya mona lufawa ona hula ya ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falisi we muki nuba oti minabo ya Yesukafo feto loto loga o betibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Hemotina ya Goti ilifi molaibo we Kilisto yagunu nedafaiye loti holi minae? Hema yufa fibo we ne? loto loga o betito, emotina yasi Defiti yufa fibo we ne, loti liwila oti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Lomuwato, emokafo feto libo, Feto ya Weuna Fele yakafo Defiti welau ha molaito, Wenabane ne, loto libo ya igaidana oto lo edaibo ne? Yagunu mono lufuwa igu yau feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Wenaba yakafo Wenabane ya lomuibo, Ane onaleka amedoto hiyaba oto minageto, ya uwokafo-mota fulo higa feumau betinogolowe, loto libo ne, loto ha mono lufuwau (Sng 110:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Feito Defitikafo ya, Wenabane ne, loto lito Goti ilifi molaibo we Kilisto ya igaidana oto Defiti yufa fibo we nebo ne? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yagunu wenina ma ha liwila oti lomunabo ya ogofuwámato, aya hamena yalokati minomo uwabo ya holiya holiti hofa loga-miga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesukafo wenina nuba abo ido ege-ege moniyabo we ya feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Holilo. Lo molaibo ha api itibiyabo we ido Falisi we yasi Mosese yaidana oti lo molaibo ha api itibi-itibi o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yagunu hemotina lo molaibo ha api itibiyabo ha muki ya holiti meyalo molalo. Ido monatina molo-molo abo yaidana oti molámilo. E'e, wetinagunu lo oloto molabo nefa, eimotina hatina ya meyalo molámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ido lo molaibo ha api itibiyabo, wenina lutina-hatina li aila i betinaibo ha ladámoti, auba ibo ha lobiti hena li mofu betiyafa, adina li faka lo betiyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ido wenina wa ledoti luwate lanae, loti wenina nomudinalo idafa muki fe-fe ae. Ido wenina wa ledanabo mono wenina minone, loti holinigilae, loti lo molaibo ha ma aila nabalo lufuwa iti huwamenau moloti onobatinalo wase iti molae. Ido Goti lomunigili utinalo owo onuwalo ekeni nala fana-fanalo i-i ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ido wetina-idafa naba nanabo hamenalo ya wenina nomudinalo folomo homu nedo yako ya amedanune, loti holiti, ido mono numugu yagi ayaidana oti wenina nomudinalo ya folomo homu nedo minanune, loti holi-holi o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ido maketilo ya wenina wa ledoti aiyo-weiyo ha lolumunae, loti holiti, Api lilibiyabo weninae, loti luwate lanae, loti holi-holi o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Feto feyafa, hemotina api itibibo we makoko ya ne. Ido hemotina muki ya yatinafo-unatinafo ya minae. Yagunu wenina masi, Api lilibiyabo weninae, loti latoma, ya feto ladámilo, lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ido mikalo me ya we ma, Metefo ne, loti huliya li akaisa oti luwala ladámilo. E'e, Metinafo makoko nebo we ya okulumau ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ido hemotina yagunu wenina masi, hiyabate wenaba ne, loti latoma, ya feto ladámilo, lobilo. Hiyabatina wenaba ya makoko ilifi molaibo we Kilisto ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ido hemotina yauti we makafo u homu moloto huliyagi wenaba ona nebo we ya hemotina onodo weninatina minanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yagunu we ma eimola huliya ito yonaibo ya Gotikafo huliya ito lumunaibo ne. Ido we ma eimola huliya ito lumuto moni minanaibo ya Gotikafo huliya li akaisa edanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesukafo libo, Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Hemotina ya okulumau nebo we wehudite hilalau yonigilabo wenina hotinalo ya hanu hu beti-beti o minae. Feto fe minabo heimotinasi ya hilalau yowámoti, ido yonigilabo wenina ya hanuma hu beti-beti o minae.  ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Hemotina wena-hiyona ya hotina iti numunatina idafatina ya ugele noti, ido wenina wa ledanae, loti ha fana-fana Goti lomu-lomu aboma nenako, lifimatina ya li mulalo-mulalo oto molanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Hemotina lege molanaibo we ma wita anune, loti ya ho no mulalo ido mikalo uti loti moniyabo onona naba-naba liti moniti wita-wita oti, wewa oloto piyageto ya hopa api ilibiyato mona nosámibo molanaibo yakafo hemotina mona nosámibo molabo ya li yoima o betinako, so fiyámanaibo soku unaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aiyo, hemotina nomudina likaibo yasi wenina hanu idipiyabo ya lifima ha naba-naba liwila oti linigilae. Hemotina ha feti labo, we ma feto feyanowe, loto lido ya hawa libo li auba ito li onae, loto fele huliyagi numuna naba huliya lanaibo we ya hawa aifa liye, loti lo-lo ae. Feto lafa, ido we makafo feto feyanowe, loto hawa libo li auba ito li onae, loto hefana goli ya fele huliyagi numuna naba lulau nebo huliya lanaibo we ya hawa meyalo molo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hemotina ya ha manadinau minámibo ido nomudina likaibo weninao, hefana goli ya hula nefemo, ido fele huliyagi numuna naba yakafo hefanawa li fele aiboma ya hula ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ido yako minámiye. We makafo feto feyanowe, loto hawa libo li auba ito li onae, loto idafa hi-hi abo folomo huliya lanaido yagunu hemotina yasi, Aifa liye, loti lo-lo afa, ido makafo Metefo aifa munaibo idafa ya sokila hi-hi abo folomolo nebo huliya lanaibo we yagunu hemotina labo, ha feto lanibo ya meyalo molo, loti lomu-lomu ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hemotina nomudina likaibo weninao, nena idafa hula ne? Goti munigili liti abo idafa ya hula nefemo, ido idafa hi-hi abo folomolo yakafo munabo idafawa li fele aiboma ya hula ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yagunu we makafo feto feyanowe, loto lanaibo we ya hawa libo li auba ito li onae, loto idafa hi-hi abo folomo huliya loto lanaido ya folomowa yagi ido idafa muki folomo mulalo nebo hulitina muki yagi auba ito li onae, loto lanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ido we makafo feto feyanowe, loto hawa libo li auba ito li onae, loto lanaibo we ya fele huliyagi numuna naba huliya lanaido ya numunawa huliya yagi ido ayau nebo we yagi hulitina muki ya li auba ito lanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ido we makafo feto feyanowe, loto hawa libo li auba ito onae, loto okuluma huliya loto lanaibo we ya Goti nebo ebala yagi ido eba yawala yagi hulitina li onae, loto lanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Wete-idafa li la fulinaibo idafa-adafa teni (10) ya linaguti ya idafa mako ma hona moloti Goti muwafa, lo molaibo ha hula yau mona naba nebo ya fefe liboko molabo mona, ido wenina milumatina lutina-hatinau holiyabo mona, ido holi hikitabo monalo molomo yowabo mona ya moda fulitae. Hemotina lo molaibo ha yau idafa ma meyalo molaboidana oti muki idafa hefola naba maina ya meyalo molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hemotina nomudina likaibo yasi wenina hanu idipinabo wenina minae. Feti feyabo ya we makafo no nanaibo yau hemeuna lumuto nebo yauti li fulaifa, ido safu-kameli yau nebo ya aifa no mikilito aibo we yaidana oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aiyo, hemotina lo molaibo ha api itibiyabo wegi ido Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Kapugi lapegi ya feka etuwalo noku no iyafa, lulau yau idafa-adafa magi magi linubolae, loti weudina-lutina-hatinau yau auba iti holi minabo monagi, ido nomudina fulibo idafa-adafa li nuba oti no hulanubolae, loti dowa loti holiyabo monagi ya faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falisi we hemotina nomudina likaibo ya idafa lulau ya homu noku no inabo feka yagi maina feke loto hiluwa lanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Hemotina hono molo betiyabo ebato ufa hiyoba libo wiliyabo yaidana oti minae. Aya ebato fekaka ya wenina wati eba dowa ne, loti holiyafa, ido lulau ya hono aubatina ido idafa-adafa nosámibo lilitibo nebokafo faitibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hemotina yagi ayaidana oti utina etuwakafo wenina nomudinalo dowa moniti monatina fefe libo molo minafa, ido lutinau yau monona loiti iyabo mona ido nosámibo-asámibo mona ya faitibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aiyo, hemotina lo molaibo ha api itibiyabo wegi Falisi wegi monona loiti iyabo weninao, lifima ha naba-naba liwila oti linabo ne. Polofeti honotina molo betiyabo ebalo numunatina hu betiti ido monatina fefe liboko molabo wenina honotina molado idafa hifiti ebawa goloti feyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Feto feti labo, Awatefo-mota hamenatinalokama minonibo neko, polofeti hofo beti fuliyabo wenina ya adina li faka ladámadi ne, loti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Feto loti labo hawa yakafo hemotina ya polofeti hofo beti fuli-fuli abo we yufa fiyabo weninatina ne, loto moda sigiya lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ido awatinafo-mota aidena apiti fe-fe abo idafama onesa hemotina ayaidana oti monatina molomo yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hemotina hosofa nosámibo olufola minabo, ya Gotikafo li halo molo betito so fiyámanaibo soku yau fulo betinaibo, ya igaidana oto holi unabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yagunu holifefe loti holilo. Polofeti, ido ha manadinau nebo we, ido ha mono api itibiyabo we ya hemotina minagu idipi moloto anabo, malekama ya hofo beti fuliti ido yá yofolo hofo betinabo ne. Ido malekama ya mono numunatinau ya nala ikula hofo betiti ido heni fulo betiyato numudo malo-malo unabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yagunu wenina yasi monatina fefe libo wenina mikalo me ya ya hofo beti fuliyabo lifima muki ya hemotinaloka minanogolaiye. Feito monala fefe libo we Abeli hofo fulibo hamenaloti wenina ya hofo beti fulimo uti uti Sekalaiya, Belekia hipala yagi hofato fulibo hamenalo uwae. Wewa ya fele huliyagi numuna naba yagi idafa hi-hi abo folomogi lusaku yalo nedo ya hofo fuliyae. Yagunu lifimawa muki ya hemotinaloka binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nemo ona lobiyowe. Lifimawa muki ya onesa wenina minado me ya fedo binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aiyo, Yelusalemu weninao, Yelusalemu weninao, hemotina yasi polofeti hofo beti fuliti, ido hefanagunu wenina minagu idipi molaibo ya fuloti hofo betiyabo, ya okolofokafo olufola okonau li nuba o betibo yaidana oto hemotina muki ya hamaneu li nuba o betinowe, loto holiyofa, ido eleka o betito, e'e, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Holilo. Numunatina ebatina fulitoto ya polofeti hemotinagi minámato, heimotinako minanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yagunu lobiyowe. Nemo ya hofa wa nedámoti monimo uti uti Wenaba huliyalo aibo we ya ebola logeto mino holimo wiye, loti ha mono lufuwau (Sng 118:26) nebo ha lanabo hamena yalo ya hofa wa nedanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu fele huliyagi numuna naba ya fulitoto wido ege-ege moniyabo we ya fele huliyagi numuna naba huwabo ya ilibinune, loti emo nedoka ato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesukafo libo, Numuna huwabo idafa muki ya wafe? Nemo ona lobiyowe. Hefana makafo hefana ma mulalo nebo meidana oti waitámanigilae. E'e, muki ya itifu fulato, lumu fou lanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Olifi obulalo ya amedoto neto, ege-ege moniyabo we emo maina ya nedo loti feto lomuwabo, Hawa lanibo yama nena hamenalo oloto pinaibo ne? Ido igaidana oto mebe-maba ya fedanaibo wato hemo hofa liwila oto ananibo hamena ido mika okuluma hulanaibo hamena moda alili aibo ne, loto holinune? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Loga o edato, Yesukafo libo, Hemotina wenina masi loti hote itanae, loti wa fefe loti monilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wenina abi lokati huline liti, nemo Goti nilifi molaibo we Kilisto minowe, lanabo ya wenina muki hotina inigilae. Feito nenako, wafefe loti hiyaba oti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ido fina ha ido lowa ha ya holinigilafa, holi biyámilo. Idafawa yaidana fedanogolaifa, mika okuluma hulanaibo hamena ya ayalo fedámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","E'e, wenina mikau-mikau ya lowa fimo uwato, ido mikalo hiyaba we ma weninalagi ido hiyaba we ma weninalagi lowa fina fimo unabo ne. Ido mikau-mikau inagunu naba oloto pitoko minageto, ido mika mima naba anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ido idafa-adafawa muki ya wenipa olufo hedanigili utina apito ogofu aibo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ena aya hamenalo ya hemotina nemo weninane minanako, yagunu liti utina ogofu li biti hena naba li mofu betiti hofo beti fulinabo ne. Ido mikau-mikau wenina muki yasi weninane minabo yagunu lutina-hatinau holi nosámibo-asámibo binigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ido idafawa ya oloto pinaibo hamenalo ya wenina abi loti ya fulo nedoti hopa uti weninatina ya li uwotinafo-mota adinalo biti eimotina-eimotina uwolafo-uwolafo bulinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ido ha sugi polofeti abi lokati anabo ya wenina muki hotina inabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ido mona nosámibo ya u naba-naba fedanogolainako, wenina muki ya lutina-hatina bi-bi abo mona ya fulitanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Feti minanigilafa, holi hiki loti auba iti minobo henawa hulanaibo hamenalo yonabo wenina ya Metefokafo li nomudina wanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ido wenina muki mikau-mikau minabo ya hawa holinigilae, loti wehudite hiyaba o ledaibo we hala ukuwa dowa ya lobimo uwato, hawa holitato, ena aliga mika okuluma hulanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Wenina yasi Daniyeli ha libo, Ha mono lufuwau (Dan 9:27, 11:31, 12:11) nebo hawa hitanabo ya holifefe loti holinigilae. Idafa nosámibo-asámibo muki idafa li hopaitanaibo idafa yagunu libo, aya idafawama eba felelo yalo minanaibo ya wa edanado ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yudia mikau minanabo wenina u obulaleka holi unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ido ma numuna obito minanaidoti ya lumuto numunalau yauti huwamenala linaibo hamenala minámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ido ma ya minau onona linaidoti ya hofa liwila oto uto ulalo owo liyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ido aya hamenalo ya wenipa olufo houmatinau nebogi, ido wenipa olufotina amina bi minanabogi ya hena naba holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ido idafawa fedageto holi unabo ya asi naba anaibo hamenalofe, ido Sabati foli hamenalo ya oloto pitanaiye, loti Goti lomu-lomu o minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aya hamenalo henawa naba-naba fedanaibo ya mika okuluma oloto pido akaisati loto onesa hamenalo minaibo hena yaidana oloto piyámibo ne. Ido aliga yagi hena yaidana ma minámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hamenawa ya fukoto li fouma itámibo neko, wenina ma ya minámadi ne. Feito nefa, emokafo weninala wa molo o betibo yagunu holito hamenawa li fouma itanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ido aya hamenalo we makafo, Wa edalo. Ilifi molaibo we Kilisto me ya ya ne, loto lanaife, ido, Walo. Yowa ne, loto lanaibo ya holi hikito umámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Feito wenina masi oloto piti sugi ha lanabo, maleka nemo ya Kilisto minowe, lato ido ma yasi, Nemo polofeti minowe, loti feyanabo, ya idafa hofawa naba-naba eito-eito ido aubatina idipibo idafa li oloto pinabo, ya Goti weuna fi betibo weninala yagi hotina inune, loti ogofunabo neko ya hotina inadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hamenawa aliga anaibo yagunu hemotina moda homu lobitowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yagunu moda hafali mikau yola ne, latoma, ya aguwámilo. Ido moda numugu lulau meu ne, lanabo yagi holiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","E'e, hopanakafo filiga fo yoidokati hopana hito uto fo lumidoka ya wibo yaidana oto wenina yasi nemo We Hula hofa liwila oto anobo ya wa nedanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Holifefe loti holiyafe? Hono ula nedo yalo nama hiyala ya loti nuba ae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ena hasuwala fiyabo hamenawa hulageto yalo, Fo ya lubu ito, igana lamenala ya hulito, ofiya ya okulumauti limo iyageto, okulumalo nebo idafa muki ya momoga anogolaiye, loto ha mono lufuwau (Ais 13:1 34:4) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aya hamenalo nemo We Hula anobo mebe-mabane okulumalo yalo oloto piyageto, mikau-mikau minabo wenina muki wa nedoti ya hufo nama naba lato, nemo We Hula ya okuluma limulo minoto aubane nabagi ido lamena nabagi feyoto wa nedanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ena nemo enisolene ya idipi moloto bomu wekilofo nola aubafofo loti moloti mika filiga-filiga okaleka-wakaleka uti weuna fi betibo weninala li nuba o betinae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hemotina ya yá sigolo monala yamo idafa lilibibo ha holifefe loti holilo. Yá sigolo akawa ya adoloma bu loto nowala minoto aila hofawa itoma, ayalo fo lanaibo hamena alili aiye, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Feito idafawa muki yagi oloto pito hemotina wa minanabo, ya hamenawa moda selo ona molaibo ne, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ha ona lobiyowe. Hamena onesa me ya minabo wenina malekama fuliyámato ya idafawa muki lobiyobo ya oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mika okuluma ya hulanogolaifa, nemo hane ya minowa-monowa omo yoto huladámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Idafawa muki oloto pinaibo hamena ya holifefe libo we ma minámiye. Ido okulumau enisole yagi holifefe loti holiyámae. Ido nemogi Hipala minobo ya holifefe loto holámowe. E'e, Metefo yako fedanaibo hamenawa ya holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ido nemo We Hula hofa liwila oto anobo hamenalo ya Nowa nebo hamenalo wenina monatina molabo yamaidana oti mona molanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","No luta naba ya oloto piyámibo hamenalo wenina wetina-idafa no-ano noti, we wena mofu molato, we wena adinalo li biyato, feti yaidana-meidana monalo moni minato, Nowa sipiku yoibo yalo ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","no luta naba-naba wilito anaibo hamena ya holifefe loti holiyámato, no luta naba-naba wilito loto weninawa muki ya hililifa oto idipito wiye. Ido yamaidana oto nemo We Hula liwila oto anobo hamenalo ya feto feyabo yaidana anae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ido hamena yalo we loiti migu onona li minanaidokati ma ya liti ido ma ya fulo edanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ido wena loiti maina onona li minanaidoti ma ya liti ido ma ya fulo edanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Feito ya nenako, yagunu Wenabatina liwila oto anaibo hamena ya holiyámanako, yagunu wati hiyaba otiko minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ido numuna yawala yakafo eletifo luwaila numunaneu ugele we fukoto yonaibo ne, loto holibo neko, midipuku ya hiyaba ageto fukoto yowámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Feti hemotina yagi nemo We Hula anobo hamenane ya holiyámabo yagunu hiyaba otiko minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesukafo feto libo, Ena onodo we yauti hemakafo onona holi muto fefe loto lito ha mananau nebo we ne? Onona yawala yakafo, Wewa ya ononane liyabo wenina muki ya hiyaba o betito, wetina-idafa nanabo hamenalo ya wetina-idafa hona moloto bi-bi anaiye, loto weuna fi edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aliga onona yawala liwila oto loto onodo we lomuido meyalo moloto onona li nebo we wa edageto ya dowa mino holinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nemo ha ona lobiyowe. Onona yawala ya loto idafa-adafane muki hiyaba o nedanaiye, loto huwamenala muki ya onodo we analo molanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Feito molanogolaifa, ido onodo we ya monala nosámanaibo moloto, onona yawala ya henemane oto liwila oto ámanogolaiye, loto lula-halau holito ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya hounalafo-mota houba-naba we osogunu hofo betito, ido no noti lutina-hatina li hopa oti moniyabo wegi maina wetina idafa ido no-ano naba no-no minanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ena wewa onona yawala liwila oto anaibo hamenala yagunu holiyámoto, ido onesa eletifo ámanogolaiye, loto holi nedo, aya hamenalo moda lo fedanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Fedoto we ya monona loiti iyabo wenina ebatinau yau ilifi molageto, ayau moda hufo naba-naba oti wetina hofala guti minanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesukafo ha ma feto libo, Aya hamenalo ya okulumau nebo we wehudite weninala hiyaba o ledaibo we monala ya olipa teni (10) yasi lamutina ya liti uti, hipa wena linogolaibo ya hanudo anaido hatula oto ilimito anune, loti uwabo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Olipa faifu (5) ya ha manadinau nebo nefa, ido maleka faifu (5) ya ha manadinau minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ha manadinau minámibo olipawa yasi lamutina liti uwafa, ido no lamuku lekinabo ya ma liyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ido ha manadinau nebo olipawa yasi lamutina liti ido no fiyabo idafau yau lamu no ma malekama liti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ena hipawa wena linogolaibo ya anaido ne, loti hiyaba afa, ámito olipawa nomudina fifi aito uwo uno minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Uwo uno minato, lubuka luwaila midipu ibo hamenalo ya wena linogolaibo we ya hanudo lo fedageto ya uti, wa edoti ilimiti liwila oti alo, loto ha naba ma oloto wito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","olipama muki sinoiti lamutina lifefe labo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ha manadinau minámibo olipa yasi ha manadinau nebo olipa ya feto lobiyabo, Lamute ya finogolaiye. Hemotina no ma leki ledalo, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ido ha manadinau nebo olipa yasi, E'e, note me ya hemotinagi ido lemogi lekinubo ya ogofuwámiye. Hemotina uti no ma meina fiyalo, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ena lamu no meina finune, loti hanudo u minado ya wena linogolaibo hipawama aito, hiyabala o minabo olipa ya wetina-idafa hofo hiti molabo numugu ya maina yowato hanu huwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hanu moda huwato, ido aligama olipa malekama yagi loti feto lomuwabo, Wenabao, wenabao, hanu si ledowo, lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ido emokafo libo, Nemo ha ona lobiyowe. Hemotina wa betifefe loto wa betiyámowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yagunu holilo. Liwila oto anobo hamena ya hemotina holiyámabo yagunu ya hamena-hamena moda wati hiyabane otiko minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ido hamenawa anaibo ya feito yaidana oto ne. Holilo. Hamena ma we makafo hanu faiga unowe, loto ononala liyabo we huwamenala adinalo moloto, idafane hiyaba o nedato unowe, loto sutina fito, ato ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","adinalo molaibo we ya onodo we muki monatina yagi ido idafa-adafa lifefe lanabo ogofuto mino betibo aubatina yagunugi holito hefana ya hona moloto we ma hefanala naba-naba huliya taleni faifu (5) ya muibo, ido we ma hefana naba taleni loiti ya muibo, ido we ma hefana taleni mako ya muibo, feito bitoto unogolaibo hanu ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ena hefana taleni faifu (5) libo wema ya aloko uto hefanamakafo onona lito hefana taleni faifu (5) magi ika oto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Feto feyaito ido hefana taleni loiti libo wema ayaidana oto hefana taleni loiti magi liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lifa, ido hefana taleni mako libo wema hefanawa lito uto mikau ya hale lito faluku aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aliga hamena fana minototo ononala liyabo hiyabatina we wenaba ya hefana bibo yama lifefe lanowe, loto liwila oto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Feto feyaito hefana taleni faifu (5) ya libo wemakafo hefana taleni faifu (5) magi li makoito lito lomuibo, Wenabao, wao, hefana taleni faifu (5) nomanima ononawa limo uto hefana taleni faifu (5) ya magi weunawa liyowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lomuito, hiyaba we wenaba yakafo liwila oto lomuibo, Hemo ya houba-naba we dowa minoto hanelo hololanibo ononaka dowa wa owe. Hemo hefola idafalo hiyaba we dowa minaninako, yaidana oto huwamenane muki ya hiyaba o nedageto, nemote keloto dowa lotoko minomo yonogolone, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ido hefana taleni loiti libo wemakafo loto lomuibo, Wenabao, wao, hefana taleni loiti nomanima ononawa limo uto hefana taleni loiti magi weunawa liyowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lomuito, hiyaba we wenaba yakafo libo, Houba-naba we dowa minoto ido hanelo hololanibo ononaka dowa wa owe. Hemo hefola idafalo hiyaba we dowa minaninako, yaidana oto huwamenane muki ya hiyaba o nedageto, nemote keloto laloko minomo yonogolone, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ena hefana taleni mako libo wemakafo loto lomuibo, Wenabao, luka-haka ito aiboma minanibo ne, loto holiyobo, hoba-hobina midinau hifiyabo ya lito wenina eito mikatinau yufa idafa itili agu yauti liti no-no aniboma nenako, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","yagunu holika holito, hefana taleni mako nomanibo ya mikau hale lito faluku obo me ya ya ne, loto muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Muito, hiyaba wemakafo lomuibo, Hemo ya houba-naba we hafali nosámibo minane. Hemo wa nedanibo ya eito wenina midinau yauti wetina-idafa hifiyabo ya lito wenina eito mikatinau ya yufa idafa itili agu yauti liti no-no obo wa nedanima nefe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ido nemogunu feto loto holiyaninako, hefana hiyaba we adinalo moloto ido hiyabane we anaibo hamenalo ya hefanala molobo yagi hefana weuna yagi linaiye, loto hefanane ya molo-molo abo numugu ya neidafaito molo nedámane? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Loga o edoto, ya feto lobibo, Hefanawa taleni mako ya anauti liti hefana taleni teni (10) ya li nebo we ya muilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Feito idafa ma wa naibo we ya magi onu ito muwageto idafa naba wa nanaibo we minanogolaiye. Ido we ma idafa hefolako wa naibo ya aya idafa hefola wa naiboma ya anauti ipo anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ido houba-naba we nosámibo ya midipu igu feka fulitato, midipu igu ya hufo naba-naba oti wetina hofala guti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nemo We Hula ya lamenane nabau anobo, enisole muki yagi maina anubo hamenalo, ya ekeni folomonelo yoto amedoto minoto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","wenina mikau-mikau onobanelo li nuba o betiyato, ido sipisipi hiyaba wekafo sipisipi ido meme fokito hona molo betibo yaidana oto wenina fokito hona molo betinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipisipi ya ane onaleka fulo betito, ido meme ya ane adawaleka fulo betinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ena hiyabatina we wehudi nemo ya wenina ane onaleka minanabo ya feto lobinobo, Hemotina Menefo nesibala bibo wenina ya alo. Hana mika oloto pidoti Menefokafo hiyaba wenina naba minanae, loto ebatina we fi molo betibo eba ya linae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Holiyafe? Nemo inagunu fulito minoto hemotina ya wene-idafa nomabo ne. Ido nogunu holiyoto no ya nomabo ne. Ido eba eito maukati oto hanudo minoto numunatinau ya nilimiti uwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ido unelo owo minámito unelo owo ya holoi nedabo ne. Ido idafa i hiliyoto hiyaba o nedabo ne. Ido nala numugu minoto loti wa nedabo ne, loto lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Feto lobinado ya monatina fefe libo weninawa yasi liwila oti feto lonumunabo, Wenabao, nenafeko inagunu fuliyageto wa hedoto weka-idafa homonibo ne? Ido nogunu holiyageto no homonibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ido nenafeko ya eba eito maukati we wa hedonibo minane, loto hilimito numunateuka uwonibo ne? Ido ukalo owo minámito minageto ukalo owo holoi hedonibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ido nenafeko idafa hilito minageto uto wa hedoto, ido nalau minageto uto wa hedonibo ne? loti loga o nedanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ido nemo hiyabatina we wehudi ya liwila oto feto lanobo, Ha ona lobiyowe. Hemotina yasi weninane hulitina minámibo wenina ma feto fe betiyabo ya nemogi feto fe nedae, loto lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ido ane adawaleka minabo wenina yagi feto lobinobo, Hemotina u hopa unabo wenina nemo minodo ya fulitoti, nosámibo yawalagi himiwelagi so fiyámanaibo so lifefe lo betigu yau lumuti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Holiyafe? Nemo ya inagunu fulito minoto hemotina wene-idafa ya nomámabo ne. Ido nogunu holiyoto no ya nomámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ido eba eito maukati loto minoto numunatinau ya nilimiti aguwámabo ne. Ido unelo owo minámito ya unelo owo ya holoi nedámabo ne. Ido idafa hilito, ido nalau minoto ya loti hiyaba o nedámabo ne, loto lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lobiyoto, emotina yasi lonumunabo, Wenabao, nenafeko inagunu fuliyanibofe, ido nogunu holiyanibofe, ido eba eito malekati anibofe, ido ukalo owo minámibofe, ido idafa i hiliyanibofe, ido nalau minanibo ya aga li faka ladámone? loti loga o nedanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ido liwila oto lanobo, Nemo ona lobiyowe. Hemotina yasi weninane hulitina minámibo ma ya feto fe betiyámabo ya nemogi feto fe nedámabo ne, loto lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yagunu uti minowa-minowa anaibo lifima ya limo yonigilae. Ido monatina fefe libo wenina ya nomudina hofawa minowa-minowa oti minomo yonigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ena Yesukafo hawa muki lo huloitoto ya ege-ege moniyabo we feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Hamena loiti ma uwageto ya Goti Uta O Ledaibo foliwa oloto pinogolaiye, loti holi minae. Ido nemo We Hula ya uwonefo-mota adinalo biyato ya yá yofolo hofo nedanigilae, loto lobibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ena hamena yalo sokila molo muwabo we hiyabatina we wenaba huliya Kaiyafasi numuna nabau ya sokila molo muwabo we hiyabatina wemoli yagi ido Yuda wenina hiyabatina wemoli yagi nuba oti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu nedo momona oti analo-hinalo nala iti hofo fulinigili ha loti hudala hiyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","wenina muki lowa fina fitanae, loti onesa meu foliwalo feto feyámokelo, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ena Yesu ya Betani numudoka homu okola i hilibo we Saimoni numunalo minoto ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","amedoto wela-idafa no neto, ya wena makafo nomu hefana pana hibo nomuku no ladanuwa aibo meinala naba nebo ya lito loto Yesu atalalo leki edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Feto feyaito, ege-ege moniyabo we wati wa eleka fi muti feto labo, Meinala naba nebo idafawa ya neidafaito aifa fulaiye? ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Idafawa ya hefanalo fulaibo neko, meina naba lito idafa wa námabo wenina biyadi ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Feto lato, Yesukafo aya ha ya holitoto lobibo, Hemotina wena me ya ya nedafaito hanu mu minae? Idafa dowa o nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Holiyafe? Idafa wa námabo wenina ya moda hemotinagi hamena-hamena maina keloti minanigilafa, ido nemo ya hemotinagi hamena fana keloto minámanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Fulinobo hamena selo ainako, yagunu yá nowala ladanuwa aibo unelo lekibo ya fuliyoto molo nedanabo yagunu ya feto fe nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yagunu ha ona lobiyowe. Hane ukune dowa mikau-mikau lobimo uti uti wenawa me ya idafawa fe nedaibo monala yagi maina lobimo uwato, ya emogunu holiwa-holiwa minanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ena we tuwelu (12) minaguti ya we ma huliya Yudasi Isikaliyoti sokila molo mu-mu abo we hiyabatina wemoli minadoka uto ya lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nemokafo emo ya adinalo biyotoma, ya hefana meina nenaki numunabo ne? loto loga o betito, yalo emotinasi hefana siluwa teti (30) ya hitoti muwato liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hefanawa lido yaloti ya adinalo binaibo hanu ya monito wita omo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ena foliwa ya beleti lifefe lageto pupu lanaibo idafa yisi ya molámoti aifa hiti no-no abo foliwa homu hamenalo ya ege-ege moniyabo we Yesu nedo loti lomuwato, numuna igau ya Goti Uta O Betibo wete idafa hofo hito lifefe lanune? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Emokafo libo, Numuna meya nabau ya we ma minanaido uti feto lomuilo, Api lilibibo wekafo feto lohumibo, Hamenane alili aibo yagunu numunakau nemogi nege-nege moniyabo wegi Goti Uta O Betibo hoba-hobina nanune, loto liye, loti ya lomuilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Feto loto lobito, ya welalo moloti ege-ege moniyabo we Goti Uta O Betibo wetina-idafa hofo hiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ena lunaga fo sapito ya Yesugi ido ege-ege moniyabo we tuwelu (12) yagi numunawa yau amedoti minoti ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","wetina-idafa no minato, ya emokafo lobibo, Ha ona lobiyowe. Hemotina yauti we makafo nemo ya uwonefo-mota adinalo binogolaiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","lutina-hatinau hena naba-naba aito lomuwabo, Wenabao, nemofe? loti muki loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Loga o edato, emokafo libo, We ma lape yau ana fulageto nemo yagi ane fulo ayau itanobo we yakafo uwonefo adinalo binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nemo We Hula ya moda fulinobo hanune yagunu ha mono lufuwau iyadoma ya ayalo unogolowe. Feito unafa, ido nemo We Hulama ya uwonefo adinalo binaibo we ya aiyo, lifima ha naba-naba liwila oto linaibo ne. Olafo houmalauti oloto piyámibo neko, ya dowa minadi ne, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Feto lito, uwolafo-mota adinalo binaibo we Yudasi yakafo lomuibo, Api lilibiyanibo we, nemogunu labe? lito ya, Heimoka moda lane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ena wetina-idafa no minato Yesukafo beleti ma lito, dowae, lalowe, loto lomutoto ya lekoto ege-ege moniyabo we bito lobibo, Me ya ya nemo une ne. Liti nalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Feto lo itoto ena nomu lito, dowae, lalowe, lomutoto ya bito feto lobibo, Hemotina muki ya nomuwa yauti nalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Me ya ya nemo lunune ne. Gotigi li hutifina betibo ha li auba i edaibo lunune yakafo lifimatina hilili o betinowe, loto wenina abi yagunu lekinobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ido ha ma lobiyowe. No waini ya hofa ma moda námoto minomo uto uto Menefo hiyabate we wehudi hiyaba o ledaibo hilalau yau hemotinagi ya hofa nanogolone, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ena feto loto lobito, ya mono nama ma lotiti numudoti lumuti uti Olifi obulalo ya yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olifi obulalo yowato, ya Yesukafo libo, Holilo. Ha mono lufuwau feto libo, Nemokafo sipisipi hiyabatina we ya hofoto, sipisipi mau minabo ya upatanigilae, loto ha mono lufuwau (Sek 13:7) ya nebo yagunu eletifo onesa luwaila idafa fe nedanabo yagunu hemotina muki ya fulo nedo iti holi unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Feto feyanafa, ido nemo fuliyoguti sinoito ya Galili mikau u homu molo betito unogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitakafo ha liwila oto libo, Maleka muki ya holi fulo hedoiti uwatoma, ya nemo neimone ya moda fulo hedámanogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesukafo libo, Nemo ha ona lohomowe. Eletifo luwaila okolofo nola ladámageto ya hamena tili (3) ya huline li faluku anogolane, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Feto lito, Pitakafo libo, Hofo fulinabo ya nemogi maina hofo nedo fuliyatoma, moda hulika li faluku ámanogolowe, loto lomuito, ido ege-ege moniyabo we muki yagi ayaidana oti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ena Yesu ido ege-ege moniyabo we ya eba ma huliya Getesemani uwato, emokafo libo, Melo amedoti minalo, yolalo uto menefo lomunogolowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita ido Sebedi hipala loiti idipito uto ya lula-halau holibo hena naba-naba o minoto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","feto libo, Lune-haneu hena naba-naba obo yakafo fulinoboidana aibo yagunu melo minoti nemogi maina hiyaba o minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Feto lo itoto, hefola ma monimo uto hola-wela mikalo fito libo, Menefo, hanu ma minageyama miluma holiyobo kapu me ya li fulo nedanane, loto holiyobo nefa, ido nemo holiyodo molo nedámoto, heimoka holinanido ya molo nedo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lomutoto ya liwila oto ege-ege moniyabo we minado loto wa betima, uwo uno minato ya Pita lomuibo, Nemogi hamena fouma efoma maina hiyaba anabo ya ogofuwámafa? ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ido idafa ma fedoto ya hepa molo lumutanaiye, loti wati hiyaba oti Goti lomutiko minalo. Lutinau feto feyanune, loti holiyafa, ido utina aubala ya hefola ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Feto lo itoto hofa uto libo, Menefo, henawa ya li fulo nedámageyama ya moda mofunogolowe. Heimoka holinanido ya molo nedo, loto lomutoto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ya hofa liwila oto aito, nomudina o fifi aito uwo uno minabo ya wa betito ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","fulo betito hofa uto Melafo lomuibo, ya homu lomuibo hama moda ayaida oto hofa lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Feto lomuito ya hofa liwila oto ege-ege moniyabo we minado loto lobibo, Aifa minoti uwo uno minafe? Hamena ya moda alili aibo ya nemo We Hula ya lifimatina nebo wenina adinalo moda biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sinoiyato uwokelo. Yolaleka walo. Uwonefo-mota adinalo bibo we ya moda lo fediye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Feto loto lobi neto ya ege-ege moniyabo we tuwelu (12) minagu yauti we ma Yudasi ya lo fedibo, wenina nuba naba maina yagi abo wenina adinau mi nabafena mainafafena liyabo, ya sokila hi mu-mu abo we hiyabatina we ido Yuda wenina hiyabatina we yasi, ilimiti anae, loti idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ido adinalo bibo we yakafo homu feto loto lobibo, Wewa ya mudo edanobo ya ne. Analo-hinalo liyalo, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","aloko loto Yesu nedo lo fedoto lomuibo, Api lilibiyanibo we, dowae, loto mudo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mudo edaito, Yesukafo lomuibo, Yonewe, feto feyanowe, loto anibo ya feto feyo, loto lomuito, ya loti analo li hiki loti adinau liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Feto liyato, moda Yesugi minabo we yauti makafo mila hebelauti ika oto sokila molo mu-mu abo we hiyabatina we wenaba houba-nabala we hala ya fuko fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Fuko fulitaito, Yesukafo wa edoto ya lomuibo, Wenina muki migunu fina finabo ya migunu hofo beti hulanigilanako, liwila oto hebekau iyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ido Menefo loga o edotoma ya onesa me ya enisolela mau naba-naba sewedi tauseni (7000) yaidana oto idipi molageto ane li faka lanabo ne, loto holiyámabe? ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ido feto fe neto ha mono lufuwau nebo yau ha ma nemodo idafawa lo fedanaibo yagunu liboma ya igaidana oto u ayalo hulawa fedanaibo ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ido aya hamenalo Yesukafo wenina mau minabo feto lobibo, Nemo ya ugele we wenabatina ne, loti holiti ya mifena mainafafena liti loti nala fi nedanune, loti afe? Hamena-hamena fele huliyagi numuna naba hilalau ya wenina api itibimo uwodo yama anelo-hinelo liti nala fi nedámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Feto feyámama nefa, ido onesa me ya idafa muki o nedabo ya polofeti ha mono lufuwa iyabo ha yama u ayalo hulawa fedanogolaiye, loto lobito, yalo ege-ege moniyabo we muki fulo edoiti holi uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ena Yesu analo hinalo li hiki loti liyabo we yasi ilimiti sokila hi muwabo we hiyabatina we wenaba Kaiyafasi nedo uwato, ayauka ya mono api itibiyabo we ido Yuda wenina hiyabatina we ya nuba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Feto feyato, Pita ya faigato moloto ege uto, sokila hi muwabo we hiyabatina we wenaba numuna nabalo lo fedoto hilalau yoto, ya neidafa fe edanae? Wanowe, loto himiwe minagu uto amedoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Neto, ena sokila hi muwabo we hiyabatina wemoli ido kanisoletina huliya Sanihetilini mau muki minoti hofo fulinubo ha li oloto pinune, loti sugi ha fi munabo ya moni wita omo uwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","wenina muki sugi ha fi munabo ya lo fedafa, hofo fulinabo ha ma li oloto piyámae. Feto fe minato, ya aliga we loiti lo fedoti feto laibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wewa yakafo feto libo, Goti fele huliyagi numuna naba ya lukoto fo hamena tili (3) uwageto hofa huto hulanobo ne, lito ya moda holiyonibo ne, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Feto laito, ya sokila hi muwabo we hiyabatina we wenabakafo folomoloti sinoito Yesu lomuibo, Hemo ha liwila oto ma ladámabe? Wewa ya ha lo hedaibo ya nedafaiye loti laiye? loto loga o edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ido Yesu ya ha ladámoto ne. Ha ladámoto neto ya sokila hi muwabo hiyabatina we wenabakafo lomuibo, Goti mino wa-wa aibo we onobalalo loga o hedowe. Lolomo. Hemo Goti Hipala Kilistoma minabe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Loga o edaito, Yesukafo lomuibo, Heimokakafo moda lotane. Ido ha ma lobiyowe. Aliga nemo We Hula ya aubafofo libo we ana onaleka amedoto minoto, okulumalo limuku lo fedoto wa nedanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ena hawa lido ya sokila hi muwabo we hiyabatina we wenabatina eimola ulalo owo feka lito ya libo, Ake, moda Metefo hamana hitaiye. Wenina ma ha fi munabo ya sutina fiyámanune. Metefo hamana onesa hibo ya moda holitanako, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yagunu hemotina moda neidafaiye loti holiyae? lito ya emotinasi lomuwabo, Moda fulinaibo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Feto loti, etefu o edoti, adina nubati hofoti, ido malekamasi adina lukana atapogunu hofoti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Hemo Goti ilifi molaibo we Kilistoma minanibo ya hofaibo we hema ne? Polofeti ha lolomo, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ena Pita ya feka numuna hilala lulau amedoto neto, ya onodo olu ma emo nedo lo fedoto lomuibo, Hemo yagi Galili we Yesugi minanima ne, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pitakafo wenina muki onobatinalo li faluku oto feto loto libo, Ha lanibo yagunu holifefe loto holiyámowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","hanu welalo sito, onodo olu makafo wa edoto ya wenina yalo minabo lobibo, We me ya ya Yesu Nasalete wegi maina nebo ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Metefo onobalalo lo fukoto, We ya wa edámowe, loto hofa li faluku oto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Feto lito, aliga ya selo sinoi minabo wenina masi emo nedo lo fedoti lomuwabo, Haka lanibo noka ya holifefe logeto hemo ya ona emotina minagu yauti minane, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Feto lomuwato, hofa Metefo onobalalo lo fukoto, Wewa ya moda wa edámowe. Ha ona ladámoto Gotikafo li hopa o nedanaiye, lito ayalo ya okolofo kokololo liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kokololo lito, Pitakafo Yesu ha homu lomuibo ya okolofo nola ladámageto hemokafo hamena tili (3) ya huline li faluku ananibo ne, loto lomuibo ha yagunu holito, feka uto hufo naba-naba aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ena ho lito sokila hi mu-mu abo we hiyabatina wemoli muki ido Isilaeli wenina hiyabatina we nuba oti Yesu hofo fulinune, loti ha lo fukoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","analo nala iti ilimiti uti gamani hiyaba we wenaba Pailati analo muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Ido uwolafo-mota adinalo bibo we Yudasi ya Yesu hofo fulinune, loti labo ha ya holito lula-hala hena naba-naba aito adinalo bibo meinala hefana siluwa teti (30) libo yama liwila oto sokila hi muwabo hiyabatina we ido Isilaeli wenina hiyabatina wemoli ya bito feto lobibo, Nemo lifimala minámibo we ya uwolafo adinalo biyoto hofo fulinigilanako, lifimane ya naba ne, lobiye. Lobifa, emotina yasi labo, Lemodoka neidafaito loto lane? Ya heimoka idafaka ne, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi hefanawama lito uto fele huliyagi numuna nabau yau fulitoto fulo betito uto nala oto fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Fulito, ido sokila hi mu-mu abo we hiyabatina we yasi hefanama liti feto labo, Hefanawa ya hofo fulinigili meina fiyama nenako, yagunu fele huliyagi numuna naba hefana-huwamenaku molanubo ya ufefe ladámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ayawa neidafa anubo ne? loti ha lomo uti ya haba masa lifefe lo-lo aibo we mikala ya wenina eba malekamati loti fulinabo ya molo betinubo mika ne, loti aya hefanawa yamagunu meina fiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yagunu ya mikawa ya lunu mika ne, loti huliya molabo ya onesa me yagi huliyawa aifa feto lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ido aya yagunu ya homu aidena polofeti Yelemaiya feto libo, Emogunu ya Isilaeli wenina yasi meinala litipelako hefana siluwa teti (30) ya ne, loti hefanawa ya liti ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wenabakafo haba masa lifefe lo-lo aibo we mikala meina finae, loto lonumido ya meina fiyae, loto ha mono lufuwau (Sek 11:12-13, Jer 32:6-9) nebo hawa ya ayalo iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ilimiti loti gamani hiyaba we wenaba nomunalo li sinoi edato, ya hiyaba we wenabamakafo lomuibo, Hemo Yuda wenina hiyabatina we wehudi minabe? loto loga o edaito, ya Yesukafo libo, Hemo heimoka ya moda lane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ido sokila hi muwabo we hiyabatina we ido Isilaeli wenina hiyabatina we ya Yesu ha sigiya-magiya ha lo fi umado ya ha ma ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ha ma ladámito, Pailatikafo libo, Hemo yagunu ha muki sigiya-magiya lo fi homabo ya ma holámabe? loto loga o edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","sigiya ha lomuwabo ya mako magi liwila oto lobiyámibo, yagunu ya hiyaba we wenabama hala loiti-loiti kito elegiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ena melegelo-melegelo aya foliwa fedito ya gamani hiyabatina wenaba yakafo nuba abo wenina ya nalau wenina yauti we ma wina oto ilifi fulo, lato ya wewa wina fulo beti-beti aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ido aya hamenalo ya hasuwala fi-fi aibo huliyagi we ma huliya Balabasi ya nala numugu neto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailatikafo Yesu ya wauwa liti anelo nomae, loto holinako, wenina mau minabo ya feto lobibo, Hemotina holiyabo ya Balabasi ya wina fulo edanofemo, ido Yesu ya Kilisto ne, loti labo we ya wina fulo edanowe? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ena Pailati ha lifefe lo-lo abo folomolo yalo neto, olonafokafo ha ma feto loto fulo edaibo, Monala fefe libo we ya waito edo. Aya we yagunu eletifo wamo wato hena naba-naba fuliyowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Feto loto hawa fulo edaifa, ido sokila hi mu-mu abo we hiyabatina wemoli ido Isilaeli wenina hiyabatina wemoli yasi mau minabo wenina hatina liyabo, Balabasi ya fulo edoito Yesu ya hofo fulilo, loti lomuilo, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Feto lato, ya gamani hiyaba we wenaba yakafo libo, Wewa loiti yauti hema ya hemotinaloka ya fulo edanowe? loto loga o betito ya emotinasi Balabasi wina fulo edo, lato ya ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailatikafo lobibo, Ido Yesu ya Kilisto ne, loti labo we ya emogunu neidafa edanowe? loto loga o betito, ya muki yasi lomuwabo, Yá yofolo hofo fulilo, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","emokafo lobibo, Neidafaiye? Nena mona nosámibo ya molaibogunu ne? loto loga o betito ya ilalu huti labo, Yá yofolo hofo fulilo, loti auba iti lomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Feto lato, ya Pailatikafo holibo, Hane holiyámanigilae, loto holito moda fina finigilabo yagunu no ma lekito mau minabo wenina nomudinalo ana noku ito feto lobibo, Wewa ya hofo fulinabo lifima ya nemodoka minámanogolaiye. Moda heimotinalokako ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ya wenina mukisi ha liwila oti lomuwabo, Wewa hofo fulinubo lifimawa ya lemogi olufote ouwamete-motaloka moda mino ledanaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Feto lato, ya Balabasi wina oto emodoka fulo edoito, ido Yesu ikula auba iti hofotiti, yá yofolo hofo fulinae, loto himiwe adinalo biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ena gamani hiyaba we wenaba himiwela yasi Yesu ilimiti uti Lomu gamani hiyabatina we numuna huliya Pilatoliumu ne, loti labo hilalau yoti himiwe ma muki li nuba o betiti minoti li hona o edoti ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","eimola ulalo owo li fuloti, owo fana hisi libo ma ulalo i edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ido agina hasuwalagunu nala liti helekamu lifefe loti atalalo holuto i edoti, honofa ma ana onaleka ya molo itoti nomunalo hidina obula fi muti sugi idafa oti holi muti feto lomuwabo, Aiyo, Yuda wenina hiyabatina we wehudi, dowae! lomuti ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","etefu o edoti, honofama liti atalalo hofomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hofomo uti hamana hiti, ya owo fanama li fuloti eimola ulalo owo liwila oti i edoti, ya yá yofolo hofanigili ilimiti feka uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yesu ilimiti uwato, ya we ma Sailinikati aibo we huliya Saimoni wa edoti, ya yá yofola ana li faka loto mofunaiye, loti auba iti lo edato mofuito ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ya monimo uti eba ma huliya Gologota (huliya monawa ya atatina auba eba ne, loto nebo) yalo ya lo fedae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fedato no waini nogi ido ekefa aibo nowala yagi li maina itoti nanaiye, loti muwato, hefola efoma noto holifa, eleka hofaito námiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Feto námito, moda yá yofolo hofo ititi ya ulalo owola yagunu noka hedoti hona moloti liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Feto liyato, amedoti yalo ya hiyaba o edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ido atala mulalo ya hofo fuliyabo ha mona Pailatikafo feto loto lufuwa ibo, Me ya ya Yuda wenina hiyabatina we wehudi Yesu ya ne, loto lufuwa ito molae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ido yá yofolo loiti malo ya hasuwala fibo we loiti emogi maina hofo betiyabo ma ya filiga onaleka ido ma ya filiga adawaleka ya yá yofolo hofo betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ido yalo uti loti abo yasi ha nosámibo-asámibo auba iti lomuti otina gima-gama o muti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ake! Hemo fele huliyagi numuna naba ya luko fulito fo hamena tili (3) ya hofa hu fukanobo ne, loto lanibo we hemo moda Goti Hipala minotoma, heimoka li nomuga wato yá yofolo yati lomo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Feto lato, ido sokila hi muwabo we hiyabatina wemoli ido lo molaibo ha api itibiyabo wemoli ido Isilaeli wenina hiyabatina wemoli yalekasi ayaidana oti hamana hi edoti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wenina eito ya li nomudina wa-wa aiboma nefa, eimola li nomuna wanowe, loto ogofuwámiye. Isilaeli wenina wehuditina nebo ya yá yofolo yati onesa melo lomagetoma, ya moda holi hikito munogolone. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Emo ya Goti Hipala minowe, loto liboma ya holi hikito Goti muinako, yagunu Gotikafo dowa loto wa edageyama ya moda wina edanaibo ne, loti lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ido hasuwala we emogi maina yá yofolo hofo betiyabo ya ayaidana oti ha nosámibo lo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ena folilo tuwelu (12) kiloku yalomati u lunaga tili (3) kiloku ya mikau-mikau muki ya lubu imo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ido lunaga tili (3) kiloku yaloma ya Yesukafo libo, Eli, Eli, lama sabaktani, loto auba ito libo ha monawa ya Gotine, Gotine, neidafaito fulo nedane? loto lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ayalo sinoi minabo wenina hawa holiti feto labo, Wewa ya Elaiya sula fiye, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ido makafo aloko oluloto uto idafa ho nokuti noi yaidana oto nebo ya lito, no waini ekefa aibo yau fito honofa osolo pito moloto, Yesu nanaiye, loto muifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ido malekamasi, Fulitokelo. Elaiya loto li nomuna wanaife? Wa minokelo, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Feto lato, ido Yesu hofa ha auba ito loto ya moda weuna ilifi moloto fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Fulito, ayalo ya fele huliyagi numuna naba lulau ya watanae, loti lafo-lafo naba diyabo ya oka atalalokati fekalito waka lumibo ne. Ido mika ya mima naba oto, hefana naba-naba foki-naki oto, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","molo betiyabo eba ya fokito, fele wenina moda fuliyabo ya abi loti hono utina ya hofa sinoi betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","molo betiyabo ebaleka yati loti, Yesu fuliguti moda sinoitaibo hamenalo ya numuna meya fele Yelusalemuka yoti yalo monimo uti wenina naba oloto pi biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ido himiwe hiyabatina we ido himiwela ya Yesu hiyaba o edoti minabo yasi mima aibo ido idafa ma muki oloto pibo ya wati holi naba-naba bito feto labo, Wewa ya moda ona Goti Hipala ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yalo ya wenipa muki Yesu Galili mikaloti ege moloti houba-naba o edabo wenipa ya faigaka sinoi minoti, idafa wati holiti ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ayau minabo wena ya Malia Madala numudoti wenakele, ido abalafo Yemusite Yosefete otinafo Maliakele, ido Sebedi hipala loiti otinafokele yama minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ena lunaga fo sapito Alimatea numudoti idafa-adafa wa naibo we ma huliya Yosefe yakafo Yesu ege molaibo we ya loto ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailati nedoka uto Yesu hono ula ya numunabe? loto loga aito, Pailatikafo himiwela ya, Muilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Feto feyato, Yosefekafo hono ula lito, lafo-lafo feke hofawa makafo wase ito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hefana lula ligu eimola fulinobo ya molo nedanae, loto liyaigu yau moloito, hefana fowena naba-naba ma hululu moloto lito oto oto hefana lula welalo ma lotana itoto moda wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Moda wito, ena Malia Madala numudoti wena, ido abalafo Malia yate molo edaibo ebawalo selo yalo amedoti minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ena leda Sabati foli idafa-adafa lifefe labo hamena hulito ya sokila hi mu-mu abo we hiyabatina wemoli ido Falisi we ya Pailati nedoka uti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wenabao, hote i-i aibo wewa yakafo hofawa nebo hamenalo ya feto libo, Fulito fo hamena tili (3) uwageto hofa sinoinogolowe, loto libo ha ya hate ki minonima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yagunu himiwe ma idipi molageto uti molo edabo hefana welalo lotana itoti ya hamena tiliku (3) ya hiyaba oti minanae. Feto feyámanubo ya ege-ege moniyabo we yasi hono ula ya ugele liti uti, Yesu fuliguti sinoitaiye, loti wenina muki lobinabo hawa yakafo homu hotina iyabo ha yama li yoima edotanaiye, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Feto lomuwato, Pailatikafo libo, Hiyaba anabo himiwe idipiti uti hono halelo ya hanu li hiki lanabo monawa holi minabo yamaidana feto feyalo, lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","uti hono haleloma hanu li hiki lanune, loti hefana fowenalo ane moloititi fulo betiyato, himiwe hiyaba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ena Sabati foli hulito salele homu hamenalo ho lanogolaido ya Malia Madala numudoti aibo wena ido abalafo Malia ya molo edabo eba wanoiye, loti aito ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ayalo moda mima naba-naba aito Wenaba enisolela ma okulumauti lumuto lo fedoto molo edabo ebalo hefana fowenama hanudo lotana iyaboma hululu moloto ya mulalo amedoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Amedoto nebo ya ho hopana yamaidana oto lamena aito ulalo owo ya hiyoba feke ona liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ido himiwema hiyaba oti minabo ya wa edoti holi bito, utina ololo o hopaiti wenina ona fuliyabo yamaidana oti lumu fou loti unomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ena enisolemakafo wena loitima lobibo, Hemotina holi holiyámilo. Yesu yá yofolo hofo fuliyabo ya wa edanoiye, loti aibo ya moda holi minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Emo ya homu lobibo yamaidana oto moda fuliguti li sinoi edainako, moda melo minámiye. E'e, molo edabo ebau yau yoti unaibo ebala ya waliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Watiti aloko uti ege-ege moniyabo we ya feto lobilo, Fuliguti li sinoi edaito, ya moda Galili mikau u homu molo betiyageto yalo wa edanigilae, loti lobilo. Moda lobitowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Feto lobito, wena loitima hono molabo ebalokati aloko uti ya lutina-hatinau moda holi bibo yagi, ido ake naba-naba aibo yagi maina holiti ya ege-ege moniyabo we lobinoiye, loti oluloti uwaido ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ya moda haita Yesukafo hatula oto ya, Dowae, lalowe, loto lobito, ya emodoka lo fedoti hina abusa iti ya weudina-lutina-hatina muwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Weudina-lutina-hatina muwaito, ya Yesukafo lobibo, Holi ámiliyo. Uti unanefo-mota lobilo, Galili mikau uti yalo ya nemo wa nedanigilae, loti lobilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ena wena loitima uwaito, ya moda hale welalo hiyaba abo himiwe ma Yelusalemu numudo uti idafawa muki oloto pima ya sokila hi mu-mu abo we hiyabatina wemoli lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lobiyato, ya sokila hi mu-mu abo we hiyabatina wemoli ido Isilaeli wenina hiyabatina wemoli yasi nuba oti ha lo humomo fiti ya hefana naba-naba liti himiwe biti ya lobiyabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hemotina feto loti lalo, Lubuka ya uwo uno minogeto ege-ege moniyabo we yasi loti hono ula ya ugele liti uwae, loti lo oloto molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ido hawa ya gamani hiyaba we wenaba holitoma idafa ma o ledotanaiye, loti holi biyámaneyo. Leimote moda li you lo edanubo ne, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Feto loti lobiyato, ya himiwe yasi hefanama liti ha lobiyado ya meyalo molae. Ido hawa ya Yuda wenina minagu upatomo wibo ya onesa me ya ayaidana oti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ena ege-ege moniyabo we leweni (11) ya Galili mikau uto Yesukafo obulalo yalo wilo, loto lobido yalo ya yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yoti yalo Yesu wa edoti ya weudina-lutina-hatina muwafa, ido malekama ya hatina loiti-loiti ki minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ido Yesu emotinaloka lo fedoto feto lobibo, Okulumau ido mikaleka aubala muki ya nemo numinako, ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","yagunu hemotina uti wenina muki mikau-mikau minadoka ya nege anabo mona api itibiti, ya Menefo huliyalo ido Hipala nemo hulinelo ido Weuna Fele huliyalo noku i betiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ha lo molo betiyodoma muki yaloma feti meyalo molalo, loti api itibilo. Feto feyato nemo ya moda hemotinagi hamena-hamena mino betimo uto uto mika okuluma hulanaido minanogolowe, loto lobiye. Modae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ha me ya ya Goti Hipala Yesu Kilisto hala ukuwa dowa ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ido polofeti Aisaiyakafo ya Gotikafo Hipala ha lomuibo ya feto libo, Moda hane lo oloto molanaibo we ilifiyoto u homu molo hedoto hanuka wili hedanogolaiye. (Mal 3:1) ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hafali mikau yalo we ya welauti ha auba ito feto loto lo oloto molanaibo, Wenaba moninaibo hanula ya lifefe loti wili edalo, loto lo minanaiye, (Ais 40:3) loto ha mono lufuwau ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Feito Yoni ya hafali mikau ya loto noku i betito feto lo oloto molaibo, Hemotina Gotikafo lifimate hilili o ledanaiye, loti lutina-hatina li elepa inabo ya nemo noku i betinogolowe, loto lo oloto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Feto lo oloto molaito, Yudia ebau muki numudoti-numudoti wenina ato, ido Yelusalemu numudoti wenina muki emodoka loti, nosámibo monatina lo oloto molato, Yodani no nabau ya noku i betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ido Yoni ulalo owo ya safu-kameli opalagunu lifefe labo ya ito, ido hebela ya bulumakau etuwagunu lifefe labo ya hofalalo ya hebe ito, ido wela-idafa ya witugi ido hofuku suwau fimona nowala yagi no-no aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ido feto loto lo oloto molaibo, We ma aliga anaibo ya nemo li fulo nedoto wenaba ona neboma nenako, nemo efo ya hinalo idafala li fulo edanobo ya fefe ladámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nemo ya nogunu noku i betiyofa, ido wewa ya Weuna Felegunu ya noku i betinogolaiye, loto lo oloto molo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ena aya hamenalo ya Yesu Galili ebau Nasalete numudokati loto Yodani no nabau ya Yonikafo noku i edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Noku i edaito, ayalo nokuti yoto wa edaima okuluma godito Weuna ya nama mulu yaidana oto lumuto emodo fito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ido okulumauti nola makafo libo, Hemo ya Hipane lune-hane homobo we minanibo ya dowa ona wa hedowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ido ayalo ya Weunakafo Yesu ya hafali mikau ilifito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uto, yalo fo hamena foti (40) ya unoto sinoito neto, Satanikafo hepa molo edomo wito, liye-hafa yagi neto, ido enisole yasi ana li faka lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ena Yoni ya nala numugu fulo edotato, Yesu ya Galili mikalo loto Goti hala ukuwa dowa lo oloto molomo uto ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ya feto libo, Hamena molaibo ya moda lo fedito, Goti we hudite weninala hiyaba o ledanaibo hamena ya moda alili ainako, yagunu lutina-hatina li elepa iti hawa ukuwa dowa ya holi hikito muilo, loto lobimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ena Yesu ya Galili momeno anawalo monimo uto wa edaibo ya Saimonite unalafo Adulute laefa li-li aibo we minaibo yagunu noku ya laefa li-li abo owo ya fulo minaibo ya wa betito ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","feto lobibo, Hemotina nege molaliyo. Nege loti ya laefa li-li aibo ononatina yaidana oti wenina li-li anaibo we ya buli betinogolowe, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","aloko laefa owotinama fulitoti ya ege moloti uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ido yaloti monimo uto Sebedi hipala Yemusite Yonite ya sipiku laefa li-li abo owotina lifefe lo minaibo ya wa betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","aloko sutina fito, loitiwa ya metinafo ido hefana onona liyabo we sipiku minabo ya fulo betiti Yesu ege uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ena Kapeneyamu numudo uwato Sabati folilo fedito Yesu mono numugu yoto api itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Api itibibo ya lo molaibo ha api itibiyabo we yaidana oto api itibiyámoto, ha mono hula yawalakafo api itibinako, ya holiti elegiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayalo mono numunatinau we ma Satani himiwela mino edaibo we yakafo hai moloto feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aiyo, Nasalete numudoti we Yesuwo, neidafa-neidafa fe ledanogolo ane? Li hopa o ledanogolo abe? Hemo ya wa hedofefe loto Gotidokati Fele we ya minane, loto ha naba loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Feto lito, ya Yesukafo lo fuko edoto lomuibo, Hemo ha hedámoto wewa fulo edoto yoto uwo, lomuito ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Satani himiwelakafo wewa li imu-damu edoto lula-halauti feka loto hai naba moloto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wito, ido wenina muki wetina lauwa opaito ya loyolalo-melo oti feto labo, Aiyo, ya nena idafa ne? Ha mono hofawa ya yawalakafo api lilibiye. Ido yako ya minámiye. Satani himiwela ya ha lobito welalo hololae, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Feto lato, ido Galili mikau muki ya hawa ukuwa ya upatoto wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesugi ege-ege moniyabo wegi mono numuguti u feka uti, ayalo Yemusile Yonilegi maina uti, Saimonite, Adulute numunatinau yowato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni ola-kilofo idafa i hilito ula hala-kala lito, folomolo ya uno nebo ha ya Yesu lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lomuwato, emo nedo uto analo lito li faka lito ula hala-kala liboma ya fulo edaito sinoito wetina-idafa apito hofo hi betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ena lunagama fo sapi hulito ya idafa i hiliyabo wenina ido Satani himiwela lutina-hatinau mino betiyabo wenina ya idipiti Yesudoka ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Loti, numuna meya naba wenina muki minabo numuna hanu welalo mau minato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesukafo wenina idafa eito-eito hiliyabo li faka lo betito Satani himiwela abi ya wenina lutina-hatinau yauti li fulo betifa, wa edofefe lanako, Ha hedámilo, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ena leda luwaila midipu igu ya Yesu sinoito numudoti lumuto wenina minámabo eba yalo uto Goti lomu ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lomu neto, Saimonigi maina minabo weninagi uti moni witala oti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","wa edoti feto lomuwabo, Wenina muki ya moni witaka minae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lomuwato, Yesu liwila oto lobibo, Eba maleka numuna meya selo-selo nedo uto yalo minabo wenina yagi lo oloto binae, loto ya owe. Yagunu uwokelo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Feto lobito, Galili mika negu-negu ya uto mono numunatinau lo oloto bito, Satani himiwela li fulo betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ena okola hilibo we ma Yesu nedo loto hina obula fito wako lo edoto lomuibo, Wenabao, hemokafo feto feyanowe, loto holinanibo ya okola hiliyobo ya holuto nedo, loto lageto une ya moda holutanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Lomuito, Yesukafo milumala holito ana sino loto wewa ulalo li minoto lomuibo, Feto feyanowe. Okola hiliyanibo holuto, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ayalo okola hilibo ya fulo edaito ula moda holutiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesukafo ayalo ilifito auba ito lo fuko muibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Idafa feto fe hedobo ha ya wenina lobiyámo. Uto sokila hi muibo we ya uka ilibiyageto, wa hedageto ena Mosesekafo ha lo molaiboidana oto idafa muwageto wenina muki yasi okola hiliyaniboma yagunu holutane, loti holinigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Feto lomuifa, ido uto idafawa yagunu apito wenina muki lo bi-bi aiye. Yagunu Yesu hofa numuna meya ya wenina nomudinalo aguwámoto wenina minámabo ebalo yako nefa, ido wenina eba malekati-malekati emodoka lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hamena ma li fulitoto Yesu hofa Kapeneyamu numudoka liwila oto aito wenina muki liwila oto aibo hawa ya holiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wenina abi loti mau minato, eba hiki lotaibo ya hanudoti yagi faito fulitato wenina ma minanabo eba ma minámito ya emokafo hala ukuwa ya lobi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lobi neto, we fo (4) yasi ana hina hebilisito nebo we ma ilimiti emo nedo afa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","wenina mau naba faitabo yagunu Yesu nedo ya ilimiti unabo ogofuwámoti, numuna mulalo yoti Yesu nedo mananalo ya menefa li fuloti wewama hunuwalo uno nedo fulato numugu lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Numugu lumito, Yesukafo holi hikito muwabo monatina ya wa betito ana hina hebilisito nebo we ya feto lomuibo, Hipane, lifimaka moda hilili otaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Feto lomuito, lo molaibo ha api itibiyabo we malekama yalo amedoti minoti feto loti hatina kiyabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Aiyo, hawa ya nedafaiye liye? Goti hamana ya hiye. Lifima hilili o-o aibo we ya Goti eimolakoma ne, loti hatina loiti-loiti ki minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ayalo ya feti lutina-hatinau ya hatina loiti-loiti ki minabo ya Yesukafo holito feto loto lobibo, Hemotina ya idafawa yagunu nedafaito hatina loiti-loiti kiyae? ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ido hebilisito nebo we, Lifimaka ya hilili otaibo ne, loto lomunobo ya hemotina hulawa ya wa edámanako, sugi lifemo, ido ona liye, loti holiyámanigilae. Ido, Agakalo yati sinoito, hunuka lito uwo, loto lomuwoto hulawa wa edananako, ya sugi lifemo, ido ona liye, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nemo We Hula ya mikalo me ya ya lifima hilili anobo auba ya moda mino nedaibo ne, loti wanigilae, loto ya hebilisito nebo wema feto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Sinoito, hunuka lito, liwila oto numunakaloka uwo, loto lohomowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Feto lomuito, wewama sinoito hunula lito nomudinalo feka wito wenina muki wati elegiti Goti ebola loti feto labo, Idafa yaidana oto homu wagámonima ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ena Yesu hofa feka uto ya momeno anawaleka wito wenina muki mau minabo ya emodoka ato api itibi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Api itibito, monito Alifiusi hipala Lifai ya hefana takisi li-li abo ebalo amedoto nebo ya wa edoto nege ano, lito sinoito ege wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu Lifai numunalau wela-idafa no neto wenina abi lokati ege molanako, hefana takisi li-li abo weninagi ido lifimatina nebo wenina yagi emo ege-ege moniyabo wegi maina wetina-idafa no minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ido lo molaibo ha api itibi-itibi abo we yasi wenina lifimatina nebo wegi, ido hefana takisi li-li abo weninagi maina wela-idafa no nebo ya wa edoti ege-ege moniyabo we feto loti loga o betiyabo, Igaidana oto ya yo-hola wenina hefanatina takisi li-li abo weninagi, ido lifimatina nebo we yagi maina wela-idafa no ne? loti loga o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Loga o betiyato, Yesukafo hawa labo ya holito feto libo, Idafa i hiliyámabo wenina ya lusa numugu ya aguwámae. E'e, idafa ona i hiliyabo wenina yako ya lusa numugu ya u-u ae. Nemo obo ya wenina mona fefe liboko molabo wenina ya sutina finowe, loto ámowe. E'e, lifimatina nebo wenina ya sutina finowe, loto obo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ena hamena malo Yoni ege molabo weninalagi, ido Falisi wegi ya wetina-idafa moi iti námato, wenina malekama Yesudoka loti loga o edabo, Yoni ege molabo wegi, ido Falisi wegi wetina-idafa moi iyato ido hemo hege moniyabo we ya igaidana oti wetina-idafa moi iyámae? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Loga o edato, Yesu ya liwila oto lobibo, We ma wena linaibo we ya yolawe-motagi minanaibo hamenalo ya igaidana oti wetina-idafa moi iti minanae? Emogi ya maina minanaibo hamenalo ya ake iti wetina-idafa moi iti ogofuwámanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Moi iti ogofuwámafa, aliga emodokati wewa ya ipoti linabo hamena yalo ya wetina-idafa moi inabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ido wase ito ha ma feto lobibo, We makafo ulalo owo lila ma li hifinowe, loto hofawa fekalito lilalo moloto hifinaibo we ma minámiye. E'e, feto feyanaibo ya idafawa noku inaibo hamenalo ya lilagi hofawagi ya u mako aguwámoto hofawa yakafo auba ito lila ya li hopaito fekalinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ido we makafo no waini hofawa ya lipi oto safu-meme etuwa lilau yau lekiyámanaibo ne. E'e, no waini hofawa yakafo safu-meme etuwa lila ya fokiyageto ya no waini hofawa ya mikalo lekito u hopa uwageto ido safu-meme etuwa yagi fokito u hopa utanaiye, loto no waini hofawa ya safu-meme etuwa hofawau lekinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ena Sabati foli malo ya Yesu suwa witi hifiyagu wito ege moniyabo we yagi uti ilawa ma apiti doliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Feto feyato, Falisi we masi wa betiti ya feto loti lomuwabo, Walo. Sabati foliku ya feto feyámilo, loto lo fukaibo ya nedafaito feto feyae? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ha liwila oto lobibo, Defitigi maina moniyabo weninagi idafagunu holiti inagunu fuliti idafa feyabo ha ya mono lufuwau yau hemotina hitoti holámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Goti sokila hi muwabo we hiyabatina we wenaba Abiyata nebo hamenalo Defitikafo Goti numunalau yoto beleti lito naima ne. Aya beletiwa Goti nomunalo molo edabo ya wenina aifa wenina námanae, loto lo fukabo idafa ya Goti sokila hi muwabo we eimotina yako no-no abo beletiwa yama lito noto ido weninala maina minabo yagi bito naboma ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ena ha ma onu ito lobibo, Gotikafo Sabati foli yagunu holito wenina ya li oloto pi betiyámiye. E'e, wenina yagunu holito Sabati foli ya molo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Feito nemo We Hula ya Sabati foli yagi yawala minowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ena hamena ma Yesu hofa mono numugu yoito ya we ma ana galidibo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ido wenina malekamasi Yesu sigiya lomunune, loti ha ma moni wita omo uwabo ya Sabatiku yau wewa ya li faka lo edanaifemo, ido li faka lo edámanaiye? loti wenu wa minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wenu wa minato, Yesukafo ana galidibo we ya feto loto lomuibo, Hemo nomudinalo sinoi mino, loto lomuto, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ido muki feto loto loga o betibo, Sabati foliku ya mona dowa molanubemo, ido mona nosámibo molanune? Ido wenina li nomudina wanubemo, ido li hopa o betinune? Hemotina holiyabo ya nena mona ya u fefe liye? loto loga o betito ya ha hedámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ha hedámato, Yesu ya lula hala-kala lito wenu li hona oto wa betibo ya lutina-hatina gedinako, hena naba holito wewa feto lomuibo, Aga sinolo, lito ana sino lito hofa dowa ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ana dowa lito, Falisi we feka uti Heloti ege molabo weninagi Yesu ya hofo fulinune, loti ha lo fukoti uti apiti hudala hiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ido Yesugi ege-ege moniyabo wegi yalo fulitoti momeno anawalo uwato, wenina mau naba Galilikati loti ya ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ege uwabo weninawa ya idafa muki feyaibo ha ya holititi malekama ya Yudiakati ato, ido malekama ya Yelusalemukati ato, ido malekama ya Idumea ebalokati ato, ido malekama ya Yodani no naba wela filigalekati ato, ido malekama ya Taiya numudo, ido Saidoni numudo eba selo nedo-nedo yaloti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Feiti loti mau naba-naba minanako, Yesukafo ege moniyabo we ya lobibo, Wenina muki yasi mi i nedotanae, loto sipi hefola ya lifefe lo nedalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Feto lobibo homu wenina abi loti ya li faka lo betinako, yagunu onesa idafa hiliyabo wenina muki ya ulalo linune, loti selo selo loti itifu-natifu ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Feto feyato, ido Satani himiwela mino betiyabo wenina yasi wa edoti ya hinalo hidina obula fiti hai moloti feto labo, Hemo ya Goti Hipala minane, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","emokafo wa edofefe labo yagunu auba ito lo fuko bibo, Nemo ya li oloto pi binune, loti lobiyámilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ena Yesukafo obulalo yoto aposolo onona linae, loto holibo we ya alo, lobito emodoka ato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","we tuwelu (12) ya nemogi maina minoti, hane ukune dowa lo oloto molanae, loto idipito weneloti Satani himiwela li fulo betiti idipi molanae, loto weuna fi betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wewa tuwelu (12) ya hulitina feito ne: Saimoni, huliya hofawa Pita ne, loto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ido Sebedi hipala Yemusite Yonite, hulitina hofawa Bowanegese ne, loto molaibo huliya monawa ya ho halake libo yaidana oti minaiye, loto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ido Adulu, Filipi, Batolomiu, Matiu, Tomasi, Alifiusi hipala Yemusi, Tadiusi, Saimoni ya huliya ma Seloti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ido Yudasi Isikaliyoti Yesu uwolafo adinalo molaibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ena Yesu ya numugu yoito wenina hofa mau naba minanako, Yesugi ege moniyabo wegi wetina-idafa nanabo hamena ya minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ido hawa weninala yasi holiti, Hala-manana ya u hopa wibo yagunu ilimito unune, loti emo nedoka ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Feto feyato, ido lo molaibo ha api itibi-itibi abo we Yelusalemukati emotina yasi feto labo, Satani himiwela wenabatina Belesebuli ya Yesu mino edaiye. Mino edaito emo ya Satani himiwela wenabatina aubala yakafo Satani himiwela wenina lutina-hatinau nebo ya li fulo betito idipi molaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yagunu Yesukafo, Alo, lobito wase ito ha feto loto lobibo, Igaidana oto Satanikafo Satani li fulo edoto ilifi molanaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mako wenina eimotina foki filiga-filiga oti fina finabo ya auba i minámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ido numuna meya mako yautife, ido yufa mako yauti, eimotina foki filiga-filiga oti, fina finabo ya auba i minámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ido Satani weninala eimotina foki filiga-filiga anabo ya Satani auba i minámito hiyaba o betibo hamenala ya hulanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Feito we makafo auba ibo we ma numunalau ya fukoto yoto huwamenala linowe, lanaibo ya homu uto auba ibo we ya nala i edanaibo yako ya huwamenala muki ugele linogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ha ona lobiyowe. Wenina lifimatina mona-mona muki ido wenina hamadina hiyabo hatina lifimatina hilili o betinogolaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","makafo Weuna Fele hamana hinaibo ya lifimala hilili o edámanogolaiye. Aya lifimawa ya minomo yonogolaiye, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Lo molaibo ha api itibi-itibi abo we yasi Satani himiwela lula-halau ne, loti labo yagunu Yesukafo hawa ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ena Yesu olafo unalafo-mota lo fedoti feka sinoi minoti emo nedo, Ano, loti ha fulato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","wenina mau naba li hona o edoti amedoti minabo wenina yasi feto lomuwabo, Okafogi unakafo-motagi ha lohumunigili feka loti minae, lato ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesukafo liwila oto lobibo, Onefo unanefo-mota ya hema ya minae? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loga o betito, li hona oti amedoti minabo wenina wa betito feto libo, Meu ya onefo unanefo-mota ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ido masi okulumau Menefo hala dowa kibo mona meyalo molo-molo abo ya onefo unanefo nemonane-mota ya minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ena hamena ma, Yesukafo hofa momeno anawalo ha mono api itibito, wenina abi loti lo fedoti li nuba oti li hona o edabo, yagunu sipi mau yoto amedoto neto, wenina muki momeno anawa sesepalo ya minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Minomo uwato, emokafo idafa-adafa muki wase ito ha loto api itibito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Holilo. We makafo yufa idafa itili anowe, loto migu uto ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","itili aito yufa idafa ma hanudo limo ibo ya nama yasi loti no hulae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ido yufa idafa ma hefana mulalo nedo limo ibo ya mika hefola neboma nenako, aloko fou lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","fo lido ya megunito lufawa naba mináminako, opaito fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ido yufa idafa hasuwala aibo idafa yoigu limo ito, ya hasuwala aibo idafa yakafo yoto li fitoto hofo fulinako, hulawa iyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ido yufa idafa ma mika dowa negu limo ibo ya fokito yoto ilawa ibo ya tetife (30), ido sikisitife (60), ido wani hadeti (100) ya oloto pi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hemotina hatina nebo wenina ya hawa ya holi fefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aliga ya Yesu eimolako neto, ege moniyabo we tuwelu (12) yagi ido maina mino-mino abo weninagi yasi wase ito ha libo yagunu loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","emokafo feto lobibo, Goti wehudite weninala hiyaba o ledaibo monala ha faluku oto nebo ya hemotina moda li oloto pi bitaiye. Feto feyaifa, ido feka minabo wenina ya idafa-adafa muki ha wase itoko lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yagunu feto loto libo, Wa-wa o minafa, idafa wafefe loti wagámanigilae. Ido holi-holi o minafa, ha holifefe loti holiyámanigilae. Feto feyámabo neko, lutina-hatina li elepa iyato lifimatina hilili o betiyadi ne, loto ha mono lufuwau (Ais 6:9-10) ya nebo ne. Yagunu wase ito ha lobi-lobi owe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ena Yesukafo feto loto lobibo, Wase ito hawa lobo ya holifefe loti holámafe? Ha muki wase ito lanobo, ya igaidana oti holifefe loti holinabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yufa idafa itili aibo we ya Goti hala ya itili aibo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ido wenina ma ya yufa idafa ma hanudo limo ibo yaidana oti minae. Weninawa Goti hala ya holiyafa, ayalo Satanikafo loto ya Goti hala lutina-hatinau hifibo yama li fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ido malekama ya yufa idafa ma hefana mulalo limo ibo yaidana oti minae. Weninawa Goti hala holiti ayalo ake naba iyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ido lufawatina mináminako, yagunu hamena foumako holi hikito mu minato, ya Goti hala holi hikito muwabo yagunu wenina masi hasuwala fi betiyabo yagunu hena naba-naba emodoka lo fedanaibo hamenalo ya Goti hala ya fulitoti u hopa uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ido malekama ya yufa idafa ma hasuwala idafa yoigu yau limo ibo yaidana oti minabo Goti hala holiyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ido me ya mikaleka hena holiyabo idafa-adafa yagi, ido idafa wa nabo idafa-adafa hote inaibo idafagi, ido idafa-adafa magunu lutina-hatinau holiyabo idafa yamo lo fedoto Goti hala ya litainako, hulawa ámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ido malekama yufa ma limo mika dowa negu ibo yaidana oti minabo ya Goti hala holiti holi hikito muwato, emodoka hulawa tetife (30), ido sikisitife (60) ido wani hadetife (100) ya oloto pi bi nebo ne, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ido ha ma feto loto lobibo, Hemotina ya lamu hiti liti masa lulau yau molanabo nefemo, ido folomo feumau yau molanabo nefe? E'e, feti molámoti, lamu molo-molo abo ebalo yalo ya molanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yagunu holilo. Homu idafa ma holifefe loti holiyámabo idafa ya aliga holifefe loti holinabo ne. Feito idafa-adafa muki onesa faluku oto nebo ya aliga li oloto pi betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ido hatina nebo wenina yasi hawa ya holifefe loti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hemotina ya ha holinabo ya wati holilo. Ido bi-bi abo monatina yaidana oto liwila oto bito, ido mulalo-mulalo oto binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ido idafa wa nabo wenina ya aliga magi onu ito binaibo ne. Ido idafa wa námabo wenina ya idafa hefolako wa naboma ya emodokati ipo anaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ido ha ma onu ito feto lobibo, Goti wehudi weninala hiyaba o ledaibo monala ya feito ne: We ma ya yufa idafa mikalo itili aibo we ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ya ho libo, ido lubu ibo, unoto sinoito oto nebo hamenalo, ya yufa idafa fou loto yoto nefa, mona ya holifefe loto holiyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mika eimolakafo ya yufa idafa li auba i edaito, homu aila oloto pito, aliga huwawa oloto pito, ya hilitoto, aliga hulawa iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hulawa ito, doliti li nuba anabo hamenawalo ya hulawa ya doli-doli aiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ena Yesukafo feto loto loga o betibo, Goti wehudite weninala hiyaba o ledaibo monala ya nena idafa yaidana oto ne, loto lanune? Ido nena idafalo limo moloto wase ito lanune? ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Holipa ilawa ya hefola efoma yaidana oto ne. Holipa ilawa hefola efo yakafo yufa idafa muki mikau hifiyabo hefo-itala ya li fulo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Feto feyaibo holipa yufa ya hifiyato, fou loto yá holipa naba yoto migu idafa muki li fulo edaito, nama-afa okulumalo moniyabo ya loti akawalo amena molaigu ya mino-mino aboma ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Feito Yesukafo Goti hala api itibiyoto holinae, loto wase ibo ha yaidana oto mona-mona ha api itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Api itibibo ha ya fefe loto lo oloto pito lobiyámoto, hepa hako lobifa, ido ege-ege moniyabo wegi emogi mako minado yalo wase ibo ha monawa muki ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hamena yalo ya lunaga fo sapito Yesukafo ege-ege moniyabo we feto lobibo, Momeno anawa filiga yolaleka uwokelo, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","wenina muki nuba oti minabo wenina ya fulo betiti Yesu sipi hefolau neto ya ilimiti sipi magi maina uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uwato, asi naba-naba loto ya nokafo sipi li yoima ito ya sipikuma no lulau lumunowe, loto feyaito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu sipi meyalo ya lagalo uwo uno neto, ege-ege moniyabo we loti ilimikuti feto lomuwabo, Api lilibiyanibo we, leimo onesa ya no lulau lumuto fulinogolo onibo ya haka ki lomámabe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","emo ya sinoito ya asi naba-naba aibo ya hanu muito ido no halafu ya, You lo mino. Holoto mino, lomuito asi fu-fu ladámoto no halafu momoga ámoto you loto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","You loto neto, emokafo ege-ege moniyabo we feto loto loga o betibo, Hemotina nedafaito holi holiyae? Holi hikito nomámafe? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","holi naba-naba holiti eimotinau feto loti loyolalo-melo abo, Aiyo, we ya igaidana we neto, asi yagi ido no yagi ha lido ya hololiye? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesugi ege-ege moniyabo wegi no momeno wela filiga yoilaleka Gelasa wenina mikatinalo ya uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu sipikuti mikalo lumito we ma Satani himiwela mino edaibo we ya hefana lulau hono auba molabo ebauti aibo ya hatula aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wenina ya aya wewa hono molabo ebalo unoto sinoito nebo we ya nala i edanune, loti afa, ogofuwámae. Ido nala auba ibo ainigunu lifefe labo yagunu nala i edanune, loti feyabo yagi ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Homu hamena abi loti aini nalagunu analo-hinalo i edafa, emokafo analo aini nala ika oto fuloto ya ido hinalo aini nala fukoto fulitainako, ya auba ito li yoima edanaibo we ma ya minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E'e, wewa yakafo folilogi lubukagi hono molabo ebalogi obulalogi ya hai naba moloto eimola ula-falau ya hefanagunu fuko-nako o-o aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wewa ya faigakati Yesu wa edototo emodoka oluloto lo fedoto nomunalo hina obula fito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesukafo feto libo, Satani himiwela nosámabo hemotina we ya lula-halau ya fulitoti wilo, loto libo yagunu wewama hai naba-naba moloto feto libo, Yesuwo, Goti akaisa nebo we wenaba Hipala, nena-idafa fe nedanogolo nemodoka ane? Une ogofu li nomámanowe, loto Goti huliya loto ha lanibo ya li onae, loto lonomo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lomuito, Yesukafo, Hulika lo, loto lomuito lula-halau yau Satani himiwela muki yoti minanako, yagunu huline Lisiyoni ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lomuto, Ya eba mauka li fulo betiyámo, loto wako lo edomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ido obulalo selo yaleka yalo safu mau naba noti minabo yagunu ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ya Satani himiwela yasi lomuwabo, Lilifi molageto ya safu lutinau yonogolobao? loti wako lo edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O, lito Satani himiwela ya wewa lula-halau ya fulititi safu lutina-hatinau yowato, safu mau naba tu tauseni (2,000) yaidana oti minabo ya holi lumuti lowau hotinalokati oluloti momenoku yau no noti moda fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fuliyato, ya safu hiyaba abo we ya wati holi oluloti uti wenina numuna meya nabaugi ido migu minabo wenina yagi hawa lobiyato, wenina masi idafawa wa edanune, loti oti ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesu nedo loti homu Satani himiwela lula-halau mino edabo wewa ya onesa ulalo owo holoito hala-manana fefe loto neto minoto ya Yesu hinalo amedoto nebo we ya wa edoti ya holi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ido idafawa holiti wati abo wenina yasi Satani himiwela mino edabo we hala yagi ido safu hatina yagi lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lobiyato, wenina ya Yesu auba iti feto lomuwabo, Lemo ebate fulitoto uwo, loti wako lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wako lo edato, sipiku yoi neto wema homu Satani himiwela mino edabo we ya Nemote unoifao? loto wako loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","emokafo, E'e, hemo numunakaloka uwo. Uwageto, Wenabakafo milumaka holito ya idafa-adafa muki lifefe lo hedaibo ya weninaka lobiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Feto lomuito, wewa Dekapolisi eba yalo uto Yesukafo idafa-adafa muki o edaibo ha ya lo bi-bi omo wito wenina muki hatina abi kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ena Yesu sipiku momeno wela filiga liwila oto uto anawalo neto, wenina mau naba ya li hona o edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Feto minato, mono numuna hiyaba we wenaba ma huliya Yailusi yalo loto Yesu wa edoto, hinalo hina obula fito feto loto wako lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Olune hefola moda fulinogolainako, yagunu li faka lo edageto ya nomuna hofawa minanaiye, loto emodoka loto aga ya ulalo ya molo, loto wako liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wako lito, Yesute maina uwaiye. Uwaito, wenina mau naba yasi li lulau edoti uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","yalo wena ma nebo ya lunula leki-leki aibo melege tuwelulo (12) yalo idafawa i hiliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Idafawa i hilito, lusa we abi loti minadoka wito li faka lo edanune, lato hefana meina fimo wifa, ula ogofu muti idafawa i hilibo ya faka lo edámato idafa i hilibo ya u naba wito, hefanala muki ya moda huliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ido wenawa ya Yesu monala labo ha ya holito egeka loto ulalo owo ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Libo ya aifa ulalo owo linobo ya faka lanogolowe, loto hala kinako, ulalo owo ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lito, ayalo ya ulau idafa hilibo hulito, ula-falau holibo ya faka liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Faka lito, ayalo Yesu aubala ma emodokati wibo ya holito wenina mau naba minagu ya elepa ito feto loto loga o betibo, Unelo owo ya hema liye? lito ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ege moniyabo we yasi liwila oti lomuwabo, Wenina mau naba yasi li lulau o hedabo ya wa betiyanibo ya nenako, igaidana oto nemo unelo ya hemakafo liye? loto lane? loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lomuwafa, Yesu ya hemakafo feyaiye? loto hala kito wenu li hona oto wa beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wa beti neto, wenawa ulalo idafa fedo muibo ya holito emodoka loto hinalo hina obula fito holi holito ula ololo loto, hawa monawa ya lo oloto moloto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesukafo lomuibo, Olune, hemo holi hikitanibo yakafo li faka lo hedaiye. Hena holiyanidokati wina hedoto luka-haka you lageto uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesukafo feto lomu neto, ayalo ya mono numuna hiyaba we wenaba Yailusi numunalau yati ma loti ya feto loti lomuwabo, Oluka moda fulitaiye. Yagunu api lilibibo we ya hosa fi umámanune, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu hawa labo ya holi huloto mono numuna hiyaba we wenaba feto lomuibo, Haka loiti kiyámoto nemo holi hikito numutoko mino, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Feto lomuto, wenina muki nege ámilo, loto lobito Pitale, ido Yemusile unalafo Yonile yako idipito uto ya ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","mono numuna hiyaba wenaba numunalalo fedato, wenina momoga-amoga oti hai-hai moloti hufo-nama auba iti oti minabo ya wa betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wa betito, numugu yoto weninawa feto lobibo, Momoga naba oti hufo ámilo. Oluwa ya fuliyámoto aifa uwo unaiye, loto lobifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","hiya o edae. Hiya o edato, muki idipi feka fulitoto oluwa olafo melafo ege moniyabo we maina abo we yagi idipito, olu ebalau ya yoto ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","analo lito feto lomuibo, Talita kumi, libo hawa monawa ya olu hefolao, sinoiyo, loto lohomowe, lito ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ayalo ya oluwama sinoito moniye. (Aya oluwa ya olafo hedaidoti melegela tuwelu (12) ya ne.) Monito, ya wa edoti moda wetina lauwa opaito ");
INSERT INTO snp_lambau_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesukafo feto lo fukaibo, Idafawa ya lobiyámilo, loto ido, Olu wela-idafa muilo. Nanaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ena Yesu ebawa ya fulitoto eimola numunala ebalalo ya ege moniyabo wegi maina uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Maina uti, Sabati foliku mono numunatinau yoto apito lobibo ha wenina abi loti holiti wetina nowala opaito ya feto labo, We meya ya hala ya igalekati lito liye? Emo ya ha mananau nebo we hemakafo api ilibiye? Ido Goti aubala lilibibo idafawa li oloto pi lumibo auba ya igalekati liye? ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wewa yo-hola ya aifa numuna hu-hu aibo wema yae. Ido emo ya Malia hipala yae. Ido unalafo-mota Yemusikele, Yosefekele, Yudasikele, ido Saimonikele yama minabo yae. Ido emonala-mota muki ya lemogi maina ya minonibo yae, loti ya lutina-hatinau holi nosámibo umae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Feto feyafa, Yesukafo feto loto lobibo, Polofeti ma ya muki ebau ya huliya li faka lafa, ido eimola numuna meyalo ido eimola numunalau, ido weninala minagu, ya huliya li faka ladámanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Feto lobito, ido aya ebalo Goti itibibo idafa ya oloto pi binaibo ogofuwámoto, idafa hiliyabo wenina mako mako yako utinalo anagunu lito ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ido holi hikito umámabo yagunu hala abi kiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ena Yesukafo numudo-numudo ya monito api itibi-itibi aiye. Ido ege-ege moniyabo we tuwelu (12) ya emodoka li nuba o betito, loiti loiti ononalalo apito idipi molanogolo ya homu Satani himiwela li fulo betiti idipi molanae, loto ya auba biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Auba bito feto loto lobibo, Hemotina hanudo unabo idafa-adafa liyámoti, holobo yako liti, ido beletife, ido owotinafe, ido hefana owotinafe yagi liyámoti aifa wilalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ido hidinalo idafa holoinafa, ido utinalo owo loiti ya holoiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ido numugu yonagu yau yako unoti sinoiti oti minomo uti numuna meya malo unigilima ya hamenalo ya numunawa fulitalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Feti eba maleka u fedato houna i betiyámoti, ido ha lanabo ya holiyámatoma, numunawa ya fulitoti hidinalo huwopa kelaibo ya hululu iti fulitoti monatina holinae, loti fulo betilo, loto lobitoto ya idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Idipi molaito, ya uti lutina-hatina li elepa iyalo, loti lo oloto moloti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Satani himiwela abi loti li fulititi ya idafa hiliyabo wenina abi loti ya yá ilawa nowala wili betiti ya li faka lo betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ena Yesu feto feyaibo ha ya wenina muki holiyato, mikalo hiyaba we wehudi Heloti yagi hawa holiye. Holito, wenina malekamasi feto labo, Wewa Yesu ya Yoni noku i beti-beti aibo we ya ne. Emo yama fuliguti li sinoi edainako, mebe-mabawa ya li oloto pi-pi o ne, loti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ido malekamasi ya feto labo, Wewa ya Elaiya ya ne, lato ido malekamasi feto labo, Emo ya polofeti aidena minabo yamaidana oto polofeti ma ya ne, loti feti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hawa labo ya Helotikafo holito feto libo, Yoni nemo henobala fuko fulobo ya fuliguti li sinoi edaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Feto libo ya homu Helotikafo unalafo Filipi olonafo huliya Helotiyasi lito, ya Yonikafo feto lomuibo, Helotiyo, hemo unakafo olonafo liyanibo ya lo molaibo ha ya fukane, loto lomu-lomu aiye. Feto lomuibo yagunu wena Helotiyasi sebala hala-kala lito, Yoni ya hofo fulinowe, loto holifa, Heloti ya holibo, Yoni ya monala ya fefe lototo fele we ne, loto holito holiya holito hiyaba dowa o edainako, Helotiyasikafo hofo fuli edanaibo ogofuwámiye. Ogofuwámito, Heloti ya Yoni ha libo holito hala abi kibo nefa, ha libo holinowe, loto dowa loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ena aliga hofo fulinaibo hamena ma feito oloto piye. Heloti olafo hedaibo hamenala ya oloto pito, wenina hiyabatina we wenaba yagi himiwe hiyabatina we wenaba yagi ido Galili minabo wenina hiyabatina we wenaba yagi ato wetina-idafa hofo hito nae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wetina-idafa nato, wena Helotiyasi oluwa loto nomudinalo melege lito Helotigi emogi maina nabo weninagi ya dowa wa edato, mikalo wehudi yakafo oluwa feto lomuibo, Hemo ya, idafa ma linowe, lananibo ya humunowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ido, Ebaka filiga linowe, lananibo yagi moda humunowe, loto lo gedoto lo molo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lo molo edaito, feka uto, Ya nena idafa lomunowe? loto olafo loga o edaito, liwila oto lomuibo, Yoni noku i beti-beti aibo we manana ya linowe, lomuwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Feto lomuito, ayalo ya oluma oluloto mikalo wehudima nedo loto feto lomuibo, Onesa Yoni noku i beti-beti aibo we atala ya lapelo nomo, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hawa lito, mikalo wehudikafo holito lula-halau hena naba-naba aifa, wetina-idafa emogi maina nabo wenina nomudinalo ya olu ha lo molo edobo nenako, yagunu ya oluwa hala ma li fulitámanowe, loto hala kito ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ayalo himiwe feto lomuibo, Yoni manana itano, loto ilifito ya uto nala numugu Yoni henobala fuko fuloto ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","atala ya lapelo moloto lito loto oluma muito ya lito olafo muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ido Yoni ege-ege moniyabo we ya hawa holiti loti hono ula ya liti uti hale li edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesukafo aposolo homu idipi molaibo we ya liwila oti emodoka loti ya idafa-adafa feto feyabo ido api itibiyabo ha muki ya lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lomuwato, ya wenina muki uti loti anako, idafa nanabo hamena minámito, ya aposolo Yesukafo feto lobibo, Leimoko wenina minámanabo ebalo uto foli minanune, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lobito, sipiku yoti eba hameto eimotinako uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Eba hameto uwado ya wenina muki wa betiti numunatina meyau yati muki mikalo oluloti uti homu u fedae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Homu u fedato, Yesu sipikuti mikalo lumuto ya wenina mau naba minabo wa betito ya sipisipi hiyabatina we minámabo yamaida oti minanako, yagunu lula-halau miluma holi bito idafa-adafa muki api itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Api itibi neto, lunaga fo sapinogolaito ege moniyabo we emodoka loti feto lomuwabo, Eba hameto meu ya minogeto ya midipu inogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yagunu wenina ya numudo-numudo ya idipi fulageto wetina-idafa meina finae, loto idipi molo, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Feto lomuwato, hemotina yasi wetina-idafa ma bilo, loto lobito liwila oti lomuwabo, Aiyo, idafawa meina finubo ya meinala hefana denaliyasi tu hadeti (200) yaidana oto minanogolaiye. Lemote ya uti hefana naba fuloti beleti meina fi betiti loti bilo, loto labe? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Loga o edato, feto lobibo, Beleti nenaki li minae? Uti walo, lobito uti li oloto pititi liwila oti loti feto lomuwabo, Beleti faifu (5) ido laefa loiti li minone, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Lomuwato, feto lobibo, Wenina muki mau minabo ya we fiti suwa dowalo ya amedalo, loti lobilo, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ido wenina fifiti-fifiti (50) ya mau minabo ido malekama wenina wani hadeti wani hadeti (100) ya mau minabo ya suwalo amedoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amedoti minato, Yesukafo beleti faifu (5) ya lito okulumalo wa faka loto, dowae, lalowe, lototo ya lekoto ege-ege moniyabo we yasi hona moloti wenina mau naba ya binae, loto biye. Ido laefa loiti yagi hona molo bito ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","muki noti houmatina aito ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ido ege moniyabo wewa ya luma nebo onuwa-fanawa minomo wibo ya haka oti, owo egepisa naba tuwelu (12) ya holiyato faitibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ido wetina-idafa nabo wemoli ya faifu tauseni (5,000) ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ayalo Yesukafo ege moniyabo we ya feto lobibo, Hemotina sipiku ya yoti Betesaida numudo homu moloti wilo, loto lobito wenina mau minabo ya idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Idipi moloto fulo betito ya Goti lomunowe, loto obulalo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yoito, luwaila molanogolaito sipima mika fulo faiga ito u momeno lusa utaito, eimolako mikalo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Minoto wa betibo ya asi naba ma hotinalokati loto li bubulito hosa fiti ika o minato, ya Yesu wa betiye. Wa betito, holomolomo yaleka ya no mulalo hinagunu lala ito monimo loto minado loto ya fulo betitoto unowe, loto hala kifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","emotinasi Yesu no mulalo monibo ya wa edoti feto holiyabo, Holofa ne, loti hatina kiti ya muki wa edoti holi naba-naba binako, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","hai naba-naba molae. Hai naba-naba molato, ayalo ya feto lobibo, Lutina-hatinau ya auba iyalo. Nemoma minowe. Holi biyámaneyo, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","sipiku maina yoito ya asi hulito elegiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","lutina-hatina gedibo nenako, homu beleti hona molaibo monala ya holifefe loti holiyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ido momeno ya yofototo uto Genesalete mikalo fedoti sipi no anawalo nala iti li hiki loti ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","sipikuti lomato, ayalo ya wenina ya Yesu wa edofefe loti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","eba negu-negu yauti muki oluloti loti nebo ebaleka ya wenina idafa hiliyabo ya hunutinalo moloti idipiti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Idipiti abo yaidana oti Yesu eba muki meukafe yaukafe, ido numuna meya nabalofe, ido hefolalofe wibo ya wenina mau minabo ebalo idafa hiliyabo wenina uno betiti ya feto lomuwabo, Ukalo owo anawalo yako linogolone, loti wako lomuwato ido wenina muki liyabo ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falisi wegi lo molaibo ha api itibi-itibi abo we malekamagi ya Yelusalemukati Yesu nedo loti mau minato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ege moniyabo we malekama adina noku iyámoti wetina-idafa nato ya wa betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wa betiti, Falisi wegi ido Yuda weninagi muki ya awatinafo-mota hidene hatina meyalo moloti wetina-idafa nanigilima ya homu adina noku noititi no-no ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ido maketilo yati idafa ma liti lotima, homu noku noititi no-no ae. Ido hidene ha abi loti kapufena masafena lapefena noku noi-noi abo mona yamaidana oti meyalo molae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yagunu Falisi we ido lo molaibo ha api itibi-itibi abo we yasi feto loti loga o edabo, Igaidana oti hege-hege moniyabo we yasi awatefo-mota hidene hatina ya meyalo moloti wetina-idafa nanigilima adina noku iyámae? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Loga o edato, liwila oto lobibo, Aisaiyakafo homu aidena hemotina monona loiti iyabo yagunu ha ona loto feto libo, Weninawa ya wetinalo yako huline li faka lafa, lutina-hatinau holi nomámoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","feto labo, Hawa ya Goti hala ne, loti lafa, ido wenina hidene hatina yako api itibiti weudina-lutina-hatina nomabo monawa ya aifa idafa ne, loto ha mono lufuwa igu (Ais 29:13) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ido Goti lo molaibo hala ya hemotina li fulitoti wenina hidene hatina li hiki loti limo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hemotina feto labo, Leimo monate yako meyalo molanune, loti Goti lo molaibo hala fulitabo ya monate dowa ne, loti hatina kiyafe? Olo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yagunu Mosesekafo feto libo, Otinafo metinafo hulitina li faka lalo, loto (Kis 20:12, Lo 5:16), ido ha magi feto libo, We makafo ha nosámibo olafofe melafofe ya lo betinaibo, aya we ya hofo fulilo, loto ha mono lufuwau (Kis 21:17) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Feto lifa, we makafo olafo melafo lobinaibo, Nemo idafa muki wa molo betiyobo idafa yama fele neto Goti moda mutobo ne, lobinaibo we ya ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","hemotina feto lomuwabo, Okafo mekafo idafawa bito hofa li dowa betiyámanibo ya dowa ne, loti lomuti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","hemotina monatina feti api itibiyabokafo Goti hala li aifa idafa oti fulitae. Ido hemotina mona yamaidana oti abi loti feto molo-molo ae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesukafo wenina mau minabo sutina fito emo nedo ato feto lobibo, Hemotina muki hane holiti ya holifefe loti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Idafa-adafa feka nebo idafa yakafo luteu yonaibo ya li ladi o ledámanogolaifa, ido idafa-adafa weude-lute-hateu yati feka aibo idafa yakafo li ladi o ledaiye.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hemotina hatina nebo wenina yasi holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wenina mau minabo fulo betito numugu yoito, ya ege-ege moniyabo we yasi wase ito hawa libo yagunu loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","emokafo feto lobibo, Ake, hemotina yagi holifefe loti holiyámafe? Idafa-adafa fekati luteu yoibo ya ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","weude-lute-hateu yowámoto, sebate houmalau yako yoto, aliga sefe lo fulo-fulo oninako, weude-lute-hate ya li ladi o ledámiye, loto libo ya feito wete-idafa muki nonibo ya dowa ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Feto loto ido ha ma feto libo, Weude-lute-hateuti feka aibo yakafoko Goti nomunalo ya li ladi o ledaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yagunu weudina-lutina-hatina yauti hatina-manadina nosámibo kiyabo mona, hopa li unabo mona, idafa ugele liyabo mona, hofo fuliyabo mona, hume-ugele abo mona, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","wa lalo-talo molabo mona, wenina holi nosámibo o betiyabo mona, hotina iyabo mona, mona nosámibo moloto wenina li utinalo holi betinaibo mona, idafatinagunu holiti lutina-hatina nosámibo molo betiyabo mona, hamadina hiyabo mona, utina-lutina ito yoti holiyabo mona, ha manadinau minámibo mona, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","monawa nosámibo-asámibo muki ya weudina-lutina-hatinau yauti loto li ladi o beti-beti aiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ena Yesu ya ebawa ya fulitoto uto eba ma Taiya numuna selo nedo ya uto numugu yoto, ya momona oto minanowe, loto holifa, ido yalo u faluku anaibo ya ogofuwámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Feito nenako, wena ma oluwa hefola ya Satani himiwela lula-halau mino edaibo ya wenawa Yesu hala holito ayalo loto hinalo hina obula fiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hina obula fibo wenawa ya eito feka wena minoto Fonisia ebalo Silia mikalo oloto pibo wena yakafo feto lomuibo, Olune Satani himiwela lula-halau mino edaibo ya li fulo edoto ilifi molo, loto wako lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Feito wako lomuito, ya feto lomuibo, Olufo wetina-idafa liti hula minagu fulabo ya fefe ladámiye. Olufo homu nanabo ne, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Feto lomuifa, ido liwila oto lomuibo, Wenabao, ona laba, ido olufo wetina-idafa no minato, lana mikalo limo ibo ya hula yasi no-no ae, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","feto lomuibo, Feto liwila oto lonomanibo yagunu numunakaloka liwila oto uwageto oluka Satani himiwela ya fulo edoto utaiye, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lomuito, numunalaloka liwila oto uto ya oluwa folomolo uno nebo wa edaibo Satani himiwela moda fulo edoito utaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ena Yesu Taiya eba ya fulitoto uto Saidoni numudo fedoto, yaloti u Galili momenolo uto Dekapolisi ebalo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Fedito, ya we ma hala molaibo wela hena aiboma ilimiti Yesu nedo loti, Agagunu ya ulalo liyo, loti wako lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","emokafo wenina mau minadoti ilimito fele uto ya ana ilefala halau moloto ya etefu oto we wela huluma lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","okulumaleka wato halauti aku loto feto libo, Efata, loto libo ya monawa, Haka ya li godo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lomuito, ya ayalo ya wewa hala ya moda li godito, wela hulumama hotito, ha fefe loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ha fefe loto lito, Yesukafo lobibo, Hemotina idafawa yagunu wenina ma lobiyámilo, loto lo fuko betifa, emotinasi auba iti lobimo uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","wenina holiti wetina lauwa opaito feto labo, Emo ya idafa-adafa muki ya dowa lotoko lifefe liye. Hatina molaibo wenina li hatina li godoto, ido wetina huluma hena aibo wenina li fefe lo betito, ha fefe loti lae, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hamena yalo wenina naba hofa nuba o minato, wetina-idafa minámito, Yesukafo ege moniyabo we sutina fito ato feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Wenina mau naba minabo ya fo hamena loitigi-makogi (3) yalo ya nemogi melo minabo ya nanabo idafa mináminako, lune-haneu miluma holi biyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ido maleka ya faigakati abo ya inagunu fuliyado ya numunatinaloka idipi molanobo ya hanudo lumu fou lanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lobito, ege moniyabo wewa liwila oti lomuwabo, Eba me ya hameto ya nenako, beleti naba ma igalekati lito biyogeto ogofuti nanabo ne? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Loga o edato, liwila oto lobibo, Beleti nenaki liti ae? lobito feto labo, Seweni (7) ya ne, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Lomuwato, emokafo wenina muki mikalo amedoti minalo, lobito ya beleti seweni (7) ya lito, dowae, lalowe, lomuto lekoto ege moniyabo we wenina muki ya bilo, loto bito feto feyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ido laefa hefola magi nebo yagunu dowae, lalowe, lomuto ege moniyabo we bito, ya laefa yagi bilo, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lobito, biyato, muki noti houmatina aito ya aliga ege moniyabo we ya luma nebo ya li nuba abo owo ma egepisa naba seweni (7) ya owo holiyabo ya faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ido wemoli fo tauseni (4,000) ya yalo minae. Ido weninawa ya idipi molo itoto ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ya Yesugi ege-ege moniyabo wegi sipiku yoti ya Dalimanuta ebalo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ido Falisi we ya Yesudoka loti moliya fiti hepa molo munune, loti ya feto lomuwabo, Okulumalo mebe-maba ma lilibiyageto wanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Feto lato, emokafo lula-halau hena aibo yauti aku loto feto lobibo, Hamena onesa meya minabo wenina ya nedafaito Goti aubala lilibibo mebe-maba ma oloto pi lomageto wa edanune, loti lae? Ha ona lobiyowe. Goti aubala idipibo mebe-maba ma ya li oloto pi betiyámanobo ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","fulo betito sipiku liwila oto yoto momeno wela filigaleka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ege moniyabo we ya beleti hatina molaito itámato ya beleti makoko sipiku emotina minagu ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ido Yesukafo fuka ha lobibo, Wati monilo. Falisi we yisitinagi, ido Heloti yisilagi li hopa o ledotanaiye, loti wafefe loti monilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Feto lobibo hawa yagunu eimotina loyolalo-melo oti feto labo, Beleti itámoninako, yagunu feto liye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ha labo ya Yesu holitoto feto libo, Neidafaiti beleti itámabo yagunu loyolalo-melo o minae? Eletifo yagi ya wati holifefe loti holiyámafe? Ido lutina-hatina gedife? ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nomudina nebo ya wagámafe? Ido hatina nebo yamo holiyámafe? Homu idafa feyobo yama ya hatina molaife? ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Beleti faifu (5) ya lito wenina faifu tauseni (5,000) ya biyoto luma nebo liti owo egepisa nenaki ya holiyabo ne? loto loga o betito, liwila oti lomuwabo, Lemo tuwelu (12) ya holiyonibo ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","feto lobibo, Ido beleti seweni (7) ya lito wenina muki fo tauseni (4,000) biyoto luma nebo liti owo egepisa nenaki ya holiyabo ne? loto loga o betito, liwila oti lomuwabo, Lemo seweni (7) ya holiyonibo ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","feto lobibo, Onesa yagi holifefe loti holiyámafe? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ena u Betesaida numudo fedato wenina masi nomuna likaibo we ma ilimiti Yesu nedo loti ya agagunu ulalo liyo, loti wako lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","emokafo nomuna likaibo we analo lito numunatinaloti ilimito uto ya nomunalo etefu oto anagunu ulalo lito feto lomuibo, Idafa ma wabe? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","wa faka loto feto lomuibo, Nemo wenina wa betiyofa, ido yá hanu moniyabo yaidana hiliyae, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu anagunu hofa nomunalo lito, nomuna falatito idafa-adafa muki wafefe loto waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Fefe loto waito, eimola numunalaloka ilifi moloto lomuibo, Numuna meya yau yowámo, loto lo fuko edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ena Yesugi ege moniyabo wegi eba naba huliya Sisalia Filipaika uti numuna meya selo nebo ya uwado hanudo ya feto libo, Wenina ya nemogunu ya hema ne, loti lo minae? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","liwila oti lomuwabo, Wenina malekama yasi, Yoni noku i beti-beti aibo wema ya minane, loti lo minae. Ido malekama yasi, Elaiya ya minane, loti lo minae. Ido ma yasi, Yelemaiya minabemo, ido polofeti minagumati we ya minane, loti lo minae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Feto lato, emokafo libo, Ido hemotina ya nemo ya hema ne, loti lo minae? loto loga o betito, Pitakafo liwila oto lomuibo, Hemo ya Goti ilifi molaibo we Kilisto ya minane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ido hawa ya wenina lobiyámilo, loto ha auba ito lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ido emokafo api itibito feto libo, We Hula nemo ya hena naba-naba holinogolowe. Ido Yuda wenina hiyabatina we yagi sokila hi muwabo we hiyabatina we yagi ido lo molaibo ha api itibi-itibi abo we yalekasi metina numunigilae. Numuti hofo nedo fuliyato, ya fo hamena tili (3) uwageto, hofa sinoinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hawa ya oloto lito, Pitakafo ilimito anawaleka uto apito hanu muifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ido Yesu ya elepa ito ege moniyabo we wa betito Pita hanu muto feto lomuibo, Sataniyo, negeka uwo. Hemo Goti hala kibo yaidana oto haka kiyámanibo aifa mikaleka wenina hatina kiyabo yaidana oto haka kiyane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ena Yesu mau minabo wenina ido ege moniyabo we yagi, Nemo minodo ya alo, loto sutina fito feto lobibo, Ma nege molanune, loti lanabo ya heimotinagunuko holiyabo ha ya fulitoti hamena-hamena nege moloto fulinune, loti lanabo ya yá yofotina mofuti ya nege-nege molanae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yagunu makafo eimola ula etuwa yagunuko holi minoto fulinaibo we ya u hopa unogolaiye. Ido makafo nemogunu ido hawa ukuwa dowa yagunu holito monimo uto nomuna hofawa nebo monala ya fulitoto fulinaibo wewa ya nomuna hofawa minomo yonogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Holafe? Makafo ya mikaleka idafa-adafa muki ya wa noto monimo wifa, ido eimola u hopa unaibo we ya igaidana oti wa naibo idafa-adafala li dowa lo edanaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ido moda fulitanaibo ya nena idafakafo weuna meina fito liwila oto linaiye? ");
INSERT INTO snp_lambau_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ido hamena onesa me ya minabo wenina ya mona nosámibo moloti Gotidoka kelámabo hamena negu masi nemogunu ido ha lobo yagunu holiti utinalo holinabo wenina ya nemo We Hula ya enisole fele yagi maina o Menefo lamenala yau fedanobo hamenalo ya weninawa yagunu holito ayaidana oto unelo holinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ena Yesukafo feto lobibo, Ha ona lobiyowe. Hemotina eletifo melo sinoi minagu yauti maleka fuliyámoti aifa hofawa minabo ya Goti wehudi weninala aubalakafo hiyaba o betibo hamena ya wanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aliga fo hamena sikisi (6) utaito, ya Yesukafo Pitale, Yemusile, Yonile idipito obula fana-fanalo yoito, fele eimotinako minato, yalo ya nomudinalo ula ya u eito bulito ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ulalo owo lamena oto u hiyoba ona bulibo ya wenina utinalo owo hiyoba buli edabo ya mikalo wenina yasi hiyoba yaidana oti buli edámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ido nomudinalo Elaiyate, Mosesete, oloto pito Yesugi loyolalo-melo o minato wa betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Wa betiti, holi naba holiti Pitakafo nedafaiye lanowe? loto hala ki fefe ladámoto, Yesu feto lomuibo, Api lilibiyanibo we, melo minonibo ya dowa liye. Numuna holo-hala loitigi-makogi ya huwogeto ma ya hemo numunaka minanaiye. Ido ma ya Mosese numunala minanaiye. Ido ma ya Elaiya numunala minanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Feto lomuito, ya limu ma moda oloto pito wase i betito, ya limuku yauti nola ma holiyabo feto libo, Me ya ya lune-hane muwobo Hipane ya ne. Hemotina hala ya lutina-hatinau holilo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Feto lito, haita wa fulo oka waka afa, ya wenina ma wa betiyámae. Yesugiko maina minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Obulalokati lomado ya Yesukafo auba ito lo fuko betibo, Idafa wabo yama wenina lobiyámilo. Aliga nemo We Hula fulinoguti hofa sinoiyoto hawa ya lobinae, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lo fuko betito, fuliguti hofa sinoinaibo hawa monawa ya eimotinako minagu yau loyolalo-melo oti moni wita ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Moni wita oti feto loti loga o edabo, Elaiya homu anaibo ne, loti ha mono api itibiyabo we yasi nedafaito feto labo ne? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesukafo liwila oto lobibo, Ona lae. Elaiya ya homu loto idafa-adafa muki ya lifefe lanogolaiye. Feto feyageto ido mono lufuwa iyagu yau nemo We Hula yagunu feto loti labo, Emo ula ogofu naba-naba holito, ido metina munae, loti labo hawa ya nedafaiye loti lufuwa iyabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ha lobiyowe. Elaiya ya moda lotaifa, ido emogunu lo molaibo ha lufuwa iyabo hamalo meyalo moloti feto fe edanune, loti idafa-adafawa muki lutina-hatinau holiyabo ya li edotama ne, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ena Yesule, Pitale, Yonile, Yemusile liwila oti ege-ege moniyabo we malekama minadoka loti hemo ya wenina mau naba li hona o beti minato, ido lo molaibo ha api itibiyabo we yagi ege-ege moniyabo wegi moliya fiyabo ya wa betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wa betiyato, li nuba oti minabo wenina muki ya Yesu wa edoti elegiti oluloti emo nedo uti aiyo-weiyo lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","emokafo, Moliya fiyabo mona ya lonomalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Feto lobito, mau minabo wenina yauti we makafo lomuibo, Api lilibiyanibo we, hipane lula-halau Satani himiwela mino edaibo yagunu ha ladámito ya hemodoka ilimito owe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ido hamena-hamena Satani himiwelakafo hipane lito fulo mikalo edaito, emo etefu welauti yoto, wela-auba ogofuto hiki loto, ula-falau gedoto mino-mino aibo ne. Yagunu nemokafo hege-hege moniyabo we lula-halauti ya li fulo edoti ilifi molalo, loto lobiyofa, ido ogofuwámae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lomuito, Yesukafo liwila oto lobibo, Aiyo, hamena onesa me ya minabo wenina, hemotina holi hiki ladámabo wenina, nemo ya hemotinagi hamena nenaki minanowe? Ido hamena nenaki henatina holinowe? Hipawama ilimiti nemodo alo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ilimiti ato, Satani himiwela yakafo Yesu wa edoto ayalo ya hipawama li hululu hofo edaito mikalo lumu fou loto hululu-hululu monito ya etefu welauti hala-kala loto yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesukafo hipawa melafo loga o edaibo, Hamena nenaki feto feyaiye? lito liwila oto lomuibo, Hipa hefola nedoti feto feyaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ido hamena-hamena Satani himiwela yakafo hofo fulinowe, loto hipane soku noku li fulo edo-edo aibo ne. Nefa, hemo ogofutoma ya lemo milumate holito ade li faka lo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Feto lomuito, Yesukafo lomuibo, Ogofutomae, lanibo ya neidafaito lane? Wenina holi hikitabo wenina, Idafa-adafa feto feyanune, loti holinabo ya idafa-adafawa ya ogofuti feyanabo ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Feto lito, ayalo ya hipa melafokafo lomuibo, Nemo holi hikitobo nefa, holi hikine aubala minámiye. Yagunu hemokafo holi hikine ya li auba i nedoto ane li faka lo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ido wenina muki oluloti loti mau iyabo ya Yesukafo wa betito Satani himiwela hanu muito feto lomuibo, Hemo hipa hala moloto ha ladámanaiye, loto feto fe edanibo ya ha auba ito lohomowe. Hipa lula-halauti feka loto fulo edoito uto hofa liwila oto ámo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Feto lomuito, Satani himiwelama hai naba moloto hipawa li hululu naba-naba hofo edoto feka loto fulo edoito wito hipawama hono ula hilito ya wenina muki feto labo, Aiyo, moda fulitaiye, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesukafo analo lito li faka lito ya sinoi ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu numugu yoito, wenina ma minámado ya ege-ege moniyabo we yasi feto loti loga o edabo, Li fulo edoto ilifinubo ya neidafaito ogofuwámone? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","liwila oto lobibo, Idafawa yaidana li fulo edanabo ya homu Goti lomunabo yakafoko li fulo edanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ebawa fulitoti Galili mikalo monimo uti Yesukafo ege-ege moniyabo we api itibibo yagunu wenina minonibo eba ya holiyámanae, loto holiye. Holito feto lobibo, We Hula nemo ya wenina adinalo biyato, hofo nedo fuliyato, fo hamena tili (3) uwageto fulinoguti ya hofa sinoinowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Feto lobifa, hawa monala ya holifefe ladámoti holiya holiti ya idafawa yagunu loga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uti Kapeneyamu fedoti Yesukafo numugu yoto feto loto loga o betibo, Hanu onido ya nena idafagunu moliya fiyae? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","hanudo ado ha labo ya minagu yauti hemakafo u homu moloto huliya nebo we minanogolaiye, loti yagunu moliya fiyanako, ha hedámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ha hedámato Yesu amedoto ege moniyabo we tuwelu (12) ya alo, lobito holiti ato, feto lobibo, We makafo nemo huline nebo we minanowe, loto lanaibo we ya homu huliya ito lumuto minoto wenina muki houba-naba o betinaiye, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","olufo hefola analo lito, minagu li sinoi edoto, abusa ito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","We masi ya nemo huline yagunu olufowa yaidana oto houna i betinigilabo we ya nemogi houna i nedanigilae. Ido nemo houna i nedanabo we ya nemoko houna i nedámanigilae. E'e, nilifi molaibo we yagi houna i edanigilae, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ena Yonikafo feto lomuibo, Api lilibiyanibo we, we ma hemo hulikalo Satani himiwela li fulo beti-beti aibo we ya wa edonibo nefa, aya wewa ya lemodoka kelámibo yagunu lo fuko edone, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lomuito, Yesukafo libo, Lo fuko edámilo. Makafo ya hulinelo Goti aubala idipibo idafa oloto pi binaibo we ya aloko ha nosámibo ogofuto lo nedámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yagunu we ma ya uwotefo buliyámanaibo we ya yotewe ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ha ona lobiyowe. Hemotina Goti nilifibo we Kilisto nege molanako, we makafo nemo huline yagunu nomu lito no binaibo we ya meinala u hopa aguwámanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ido we makafo aifa wenina holi hikito nomagu yauti mako ma holi hikila ya li hopaitanaibo we ya Gotidokati lifima ha naba-naba liwila oto linaibo ne. Ido wenina hefana naba-naba henobalau nala iti ya no supili igu yau fulo edabo neko, moda dowa ladi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ido agakafo lifima li homagetoma, aga fuko fulito. Hemo aga dumani nageto nomuga hofawa minanaibo ya dowa nefa, aga loitiwa yagi minoto so fiyámanaibo soku unanibo ya nosa naba ámanaibo ne.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yalo hinina ya fuliyámato, ido so yagi fiyámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ido higakafo lifima li mofu hedagetoma, higa ya fuko fulito. Hemo keni-keni oto nomuga hofawa minanibo ya dowa nefa, higa loitiwa yagi minananibo ya soku li fulo hedanabo ya nosa naba ámanaibo ne.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yalo hinina ya fuliyámato, ido so yagi fiyámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Ido nomugakafo lifima li mofu hedagetoma, nomuga ya li fulito. Hemo nomuga filigako minoto Goti wehudi weninala hiyaba o betibo hilalau yowageto ya dowa nefa, nomuga loitiwagi minananibo ya so fiyámanaibo soku hinina ya fuliyámato, ido so yagi fiyámanaibo negu ya li fulo hedanabo ya nosa naba ámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ido wenina u dowa lotoko unae, loto nala ho hiyabo yaidana oto Goti yamo hasuwala fi ledaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ho ya dowa nefa, ho la fuliyámageyama nena idafagunu la fulinaibo hofa lifefe lanune? Ido hemotina lutina-hatinau ho abo yaidana oti you amena mona moloti weninatinagi holoti maina minalo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ena Yesu ya aya ebawa fulitoto Yudia mikau uto no naba Yodani hilito filiga wiye. Wito wenina mau naba-naba minabo ya emodoka ato, api itibi-itibi aibo monala moloto ya api itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Api itibito, Falisi we masi hepa molo munune, loti, loti feto loti loga o edabo, We makafo olonafo fuko fulitanaibo we ya lo molaibo ha fukanaife? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","liwila oto lobibo, Mosesekafo nena ha auba ito lo molo betiye? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Loga o betito, ya feto lomuwabo, Mosese ya we makafo olonefo fulitanowe, loto lufuwa ito muto fulito edanaibo ne, loto libo ne, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lomuwato, liwila oto lobibo, Hemotina lutina-hatinau gedinako, yagunu hawa lufuwa ito lobifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","hana aidena akaimati idafa-adafa apito li oloto pibo hamenalo ya Gotikafo We wena li oloto pibo ne, loto ha mono lufuwau (Stt 1:27) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Feito neboma nenako, Wemoli yasi otinafo metinafo fulo beti itoti olodinafodo kelabo, loiti ya utina ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","u mako oti minanaiye, loto ha mono lufuwau (Stt 2:24) ya nebo ne. Feto loiti minámoti u mako uti minanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Feto nebo nenako, Gotikafo moda kelo betitaibo ya wenina yasi fuko filiga-filiga o betiyámilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aliga numugu minoti ya ege-ege moniyabo we ya idafawa yagunu hofa loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesukafo liwila oto lobibo, We makafo olonafo fuko fulitoto uto wena ma libo we ya moda hume-ugele aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ido wena makafo wanafo fuko fulitoto uto we ma mofu molaibo wena ya moda hume-ugele aiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ena olufo hefola ya Yesu nedo idipiti ato, ya anagunu atatinalo molanaiye, loti o minafa, ege-ege moniyabo we yasi wa betiti hanu biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hanu biyato, Yesukafo wato lula hala-kala lito feto lobibo, Olufo nemodo alo, loti lobilo. Goti wehudi weninala hiyaba o ledaibo hilalau ya yaidana wenina ebatina nenako, anabo hanu ya hu betiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ha ona lobiyowe. Wenina ya Goti wehudite hiyaba o ledanaiye, loti holinabo wenina ya olufowa hefola yaidana oti ya hilalau yonabo ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","olufo abusa ito, anagunu atatinalo lito Melafo li dowa lo betiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ena Yesu hanudo unowe, loto wido ya we ma oluloto loto hinalo hina obula fito feto lomuibo, Api lilibiyanibo we dowa idafao, Nemo hofawa minomo yonobo mona linowe, loto holinobo ya nena mona molanobo ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Loga o edaito, Yesukafo feto lomuibo, Hemo neidafaito nemo ya we dowa minane, loto lane? Wenina dowa loto ma minámabo ne. Goti yako dowa ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lo molaibo ha yau feto libo, Wenina hofo beti fuliyámo. Hume-ugele ámo. Idafa ugele liyámo. Ha sugi loto wenina hamadina hiyámo. Wenina hotina ito idafatina liyámo. Okafo mekafo hulitina li faka lo, loto ha mono lufuwau (Kis 20:12-16, Lo 5:16-20) nebo ha ya moda holitanibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lomuito, liwila oto lomuibo, Api lilibiyanibo we, hipa hefola minobo hamenaloka yati hawa muki ya meyalo molomo uwowe, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesukafo wa edoto lula-hala muto lomuibo, Hemo ya idafa mako ma feto feyámane. Uto idafa-adafaka muki wa nanibo ya hefanalo fulitoto, hefana lito, idafa wa námabo wenina hona molo biyo. Feto feyananibo ya okulumau idafa-adafa wa nanogolane. Ido loto nege molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lomuibo hawa holito huwamena naba-naba wa naibo nenako, hola-wela hisimi ito lula-hala hena aito ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wito, ya Yesukafo elepa ito ege moniyabo we feto loto lobibo, Huwamena naba-naba wa nabo we ya Goti wehudi weninala hiyaba o ledaibo hilalau yonune, loti holinabo ya hosa naba-naba finabo ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","hawa libo holiti elegiyafa, Yesu hofa ya libo, Olufo, makafo ya Goti wehudi weninala hiyaba o ledaibo hilalau yonowe, loto holinaibo ya hosa naba-naba finaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ido safu-kameli yakafo naka hifiyau yonowe, loto hosa naba fibo yaidana oto huwamena naba-naba wa nabo we ya Goti hilalau yonune, loti holinabo ya oto yoti hosa naba-naba finabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lobibo ha holiti elegiti eimotina yau loyolalo-melo abo, Feto nenako, yagunu iga wenina li nomudina wanaiye? loti lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesukafo wa betito feto libo, Wenina ya ogofuwámanigilafa, ido Goti ya ogofunaibo ne. Idafa-adafa muki feto feyanowe, loto holibo ya moda ogofu ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lobito, Pitakafo feto lomuibo, Lemo moda idafa-adafa muki fulitoto hege molonibo ne, loto lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesukafo liwila oto lomuibo, Ha ona lobiyowe. Wenina masi nemogi hane ukune dowagi yagunu holiti numunatina ebatina, ido yatinafo unatinafo emonatina, ido otinafo metinafo, ido olufotina, ido midina fulitanabo wenina ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya onesa minabo hamenalo idafawa fulitabo mulalo-mulalo yoti liwila oti linabo ne. Numunatina ebatina, yatinafo unatinafo emonatina, otinafo metinafo, olufotina, midina linafa, ido yako minámiye. Hena ma yagi holinabo ne. Ido hamena aliga lo fedanaibo yalo Goti analoti hofawa minowa-minowa oti minomo yonabo mona ya linae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Feti linafa, ido wenina abi hulitinagi we minabo ya hulitina ya lumunaibo ne. Ido hulitina lumibo wenina ya hulitinagi we minanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena Yelusalemuka yonune, loti uwado ya Yesu u homu molo betito wito ege-ege moniyabo we elegiti hatina abi kiyato, ido egetina molabo wenina ya holi holiyae. Ido emokafo ege moniyabo we tuwelu (12) ya anawaleka idipito uto idafa-adafa o edanabo yagunu ya feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Moda Yelusalemuka yowogeto yalo ya uwonefo-mota yasi nemo We Hula ya sokila hi mu-mu abo we wenabatina ido lo molaibo ha api itibi-itibi abo we adinalo ya biyato li halo molo nedoti hofo nedo fulinabo ha lo inigilae. Feti eito feka wenina adinalo biyato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","weninawa yasi hamane hiti etefu o nedoti ikula hofo nedoti hofo nedo fulinae. Hofo nedo fuliyato, fo hamena tili (3) ya uwageto fulinoguti hofa sinoinowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ena Sebedi hipala Yemusite Yonite Yesu nedo loti feto lomuibo, Api lilibiyanibo we, lohumunogoloibo idafa ya lifefe lo ledanane, loto holiyoiye, laito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","liwila oto libo, Nena idafa lifefe lo ledanaiye, loti holiyaiye? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Loga o betito, liwila oto lomuibo, Hemo lamenaka nabagi ananibo hamenalo ya lemo ma fulo aga onaleka ito ido ma aga adawaleka ito ledo, laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Feto laifa, ido Yesukafo feto lobibo, Hemotina ya ha laibo monawa ya holifefe ladámaiye. Nemo hasuwala fi nedabo kapu ya hemotina yaidana oti ogofuti linaife? Ido noku i betiyabo yaidana oti ya hena naba-naba yamo noku i nedanabo idafa ayaidana oti li ogofunaife? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","liwila oti laibo, Lemo ogofuwoiye, loti lomuwaiye. Lomuito, feto lobibo, Nemo hasuwala fi nedabo idafa ya hemotina ayaida linaiye. Ido nosámibo idafa fe nedabo yagi hemotina o betinafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ido nemokafo ma fulo ane onaleka edoto ido ma fulo adawaleka edoto anobo ya ogofuwámowe. E'e, ebawa ya wenina lifefe lo betitaibo ebatina ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lobito, ege moniyabo we teni (10) ya hawa holititi sebatina hala-kala lito, Yemusite, Yonite holi nosámibo biti hanu biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yagunu Yesukafo alo, loto li nuba o betito feto lobibo, Eito feka wenina hiyabatina we yasi onona liyabo ya eimotina hulitina li faka loti auba iti, feto feyalo, feto feyalo, loti ha lobi-lobi ama ne. Ido hiyabatina wenaba yagi auba iti lobiti hiyaba o beti-beti abo monatina ya hemotina holi minama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Holi minafa, ido hemotinagu monawa ya molámilo. We makafo hemotina yauti hulinegi we minanowe, loto holinaibo we ya hemotina houba-naba ononatina ya liyaneyo, loto lomuwowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ido we makafo hemotina yauti wenabatina ona minanowe, loto holinaibo we ya ononatina we minoto muki houba-naba o betiyaneyo, loto lomuwowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ido yako minámiye. Nemo We Hula obo ya houba-naba o nedanae, loto ámowe. E'e, nemo houba-naba o betinowe, loto obo ne. Ido lifimatina yagunu hofo beti fulitanaiye, loto fulito wenina muki meina fito li liwila oto linowe, loto obo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ena lo Yeliko fedato, Yesugi ege-ege moniyabo wegi wenina mau naba yagi numuna meya naba fulitoti uwato ya Timeusi hipala Batimeusi nomuna likaibo we ya hanu anawalo amedoto idafa wako lo-lo o minoto, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yesu Nasalete numudoti aibo we aiye, loti labo ha holito apito ha naba loto feto libo, Yesuwo, Defiti yufa fibo we, milumane holiyo, loto ha loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Feto lito, wenina mukisi hanu muti feto labo, Ha hedámo, lomuwafa, ito yoto ha naba loto libo, Yesuwo, Defiti yufa fibo we, milumane holiyo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesukafo ha libo holito sinoi minoto feto libo, Wewa ano, loti sula filo, lito nomuna likaibo we ya sula fiti feto lomuwabo, Ake iyo. Suka fiye. Sinoiyo, lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","emokafo ulalo owo mofuibo ya fiyasi fuloto sato moloto sinoito Yesu nedo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aito, ya Yesukafo loga o edaibo, Nemo ya hemo neidafa-neidafa fe nedanaiye, loto holiyane? lomuito ya nomuna likaibo wekafo feto lomuibo, Api lilibiyanibo we, nomune wanowe, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesukafo feto lomuibo, Hanudo ya uwo. Hemo holi hikitanibo yakafo li faka lo hedotaiye, loto lomuito ayalo ya nomuna falatito hanudo uto ege molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ena loti, Yelusalemu alili moloti Betefage numudo ido Betani numudo Olifi obulalo lo fedoti Yesukafo ege-ege moniyabo we loiti ya idipi moloto feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Numuna meya waibo nomudinalo yalo uti yonaido ya safu-dogi mofola meyalo moniyámabo ma nala itabo minanaibo wa edanaibo ya nalalo wina oti liti liwila oti nemo minodo aliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ido we makafo, Hemotina ya nedafaito feto aiye? loto loga o betiyagetoma, feto lomuliyo, Wenaba ononala ma nenako, ya litoto aloko hofa liwila oto melo ilifi molanaiye, loti lomuliyo, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Idipi molaito, uti safu-dogi mofola ya hanudo nebo numuna hanu welalo nala iyabo li oloto piti nala wina aito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wenina ma yalo amedoti minabo yasi feto labo, Hemotina safu-dogi mofola ya nedafaito wina ae? loti loga o betiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesukafo ha lobibo yamaidana oti lobito holiti, O, ilimiti wiliyo, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","safu-dogi Yesu nedo ilimiti uti ya utinalo owo mofuibo ya meyalo molaito Yesu yoto amedoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amedoto neto, ya wenina muki utinalo owo hanudo molomo uwato, ido wenina masi yá akawa miguti fukoti ya hanudo unaido holaleka molomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ido homu molabo weninagi ido egeka molabo weninagi yasi su naba loti feto labo, Aiyo, siyane, hosana! Wenaba huliyalo aibo we ya dowa loto holimo wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Awatefo-holofate Defitikafo weninala hiyaba dowa o betibo monala yaidana oto wewa yakafo hiyaba dowa o ledanaibo mona ya dowa loto holimo unubo mona ya ne. Yoisau okulumau minabo yagi ayaidana oti, Aiyo, siyane, hosana, loti lo-lo ae, loti ya ha naba loti lomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ena Yesukafo Yelusalemu yoto uto fele huliyagi numuna nabau yoto idafa-adafa muki ya wa hulito ya moda midipu inogolaito emogi ido ege moniyabo we tuwelu (12) yagi liwila oti Betanika u fedae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Leda Betanika fuloti uwado hanudo Yesu inagunu fulito ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ya yá sigolo ma aila ibo faiga nebo ya wa edoto uto ilawa ibo ya moni wita anowe, loto yá nedo wifa, ilawa ibo hamena mináminako, ilawa ibo li oloto piyámoto yá ailako waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yá ailako wato, yá feto loto lomuibo, Ilawaka ya wenina ma hofa námanae, loto lomuiye. Hawa ya lomuibo ege-ege moniyabo we ya holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu ya Yelusalemu lo fedoto fele huliyagi numuna naba hilalau ya yoto idafa meina fiyabo weninagi idafa hefanalo fulabo weninagi ya apito heni feka iye. Ido hefana hola eito-eito nebo ya li filiga-filiga abo wenina folomotinagi, ido wenina nama mulu meinalo fulabo wenina onona folomotina yagi li elepa ito fululu kaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Fululu kaito, wenina idafa-adafa liti fele huliyagi numuna naba hilalau yoti lumuti abo wenina ya feto feyámilo, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lo fuko betito api itibito feto lobibo, Gotikafo feto libo, Numunane ya wenina mikau-mikau ya ha lonumu-numu abo numunae, loti lanabo ne, loto ha mono lufuwau (Ais 56:7) nebo ha ya ne. Feto nefa, hemotina li ugele we numunatina yaidana o minae, (Jer 7:11) loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hawa ya lobibo yagunu wenina muki elegiyato sokila hi mu-mu abo we hiyabatina wegi, ido lo molaibo ha api itibi-itibi abo wegi holiya holiti hofo fulinabo hanu moni wita ae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ido lunaga midipu inogolaito Yesugi ege-ege moniyabo wegi numuna meya naba ya fulitoti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Leda hanudo monimo uti ya yá sigolo lufawagi ailagi muki moda megunibo ya wae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wato, Pitakafo hala kito Yesu ya feto lomuibo, Api lilibiyanibo we, wao. Hemo ya yá sigolo li hopaitanaibo ha lomuwanibo ya moda meguniye, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesukafo liwila oto lomuibo, Goti ya holi hikito muilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ha ona lobiyowe. Goti holi hikito munaibo wekafo obula me ya ya ho noku sinoito uwo, loto hala loiti kiyámoto lomunaibo ya moda ha lobo ya oloto pi nedanaiye, loto hala ki hikitoto hinaibo ya feito oloto pi edanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yagunu lobiyowe. Idafa ma muki yagunu linune, loti holi hikitoti Goti lomunabo ya moda linae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ido sinoito minoto Goti lomunanibo hamenalo ya we ma mona nosámibo ma molo hedaibo we lifimala ya hilili edo. Feto feyananibo ya Mekafo okulumau nebo we yakafo hemo lifimaka yagi ayaidana oto hilili o hedanaibo ne.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Feito nefa, we ma lifimala hilili o edámananibo ya Mekafo okulumau nebo we yakafo lifimaka hilili o hedámanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ido hofa lo Yelusalemu fedato, Yesu fele huliyagi numuna naba hilalau moni neto, sokila hi mu-mu abo we hiyabatina we ido lo molaibo ha api itibi-itibi abo we ido Yuda wenina hiyabatina we ya emo nedo loti ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","feto loti loga o edabo, Idafawa feto fe-fe minanibo ya hema welaloti fe-fe ane? Ido hemakafo feto lohumito fe-fe ane? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Loga o edato, Yesukafo liwila oto lobibo, Nemo ha ma loga o betinogolowe. Liwila oti lonomatoma hema welaloti idafawa fe-feyobo ya lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoni ya hema welaloti wenina noku i beti-beti aiye? Okulumau nebo we welaloti nefe, ido wenina wetinaloti nefe? Lonumilo, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lobito, eimotinagu loyolalo-melo oti feto labo, Lemo ya okulumau nebo we welaloti ne, loto lanubo ya emokafo, Aiyo, hemotina nedafaito holi hikito umámae? loto lolumunogolaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ido wenina wetinaloti ne, loto lanube? loti hatina ligi-ligi kiyabo, ya wenina muki Yoni ya polofeti ona ne, loti holiyanako, wenina holitina holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yagunu liwila oti feto lomuwabo, Ya holiyámone, loti lomuwato, Yesukafo libo, Nemo yagi ayaidana oto hema welaloti idafawa fe-feyobo ya lobiyámanogolowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ena Yesukafo wase ito ha apito lobibo, We makafo mina hila li hona oto fito migu nala waini ilawa hifito hidinagunu nala ilawa lipiyanabo hale ya lito migu hiyaba anabo numuna huiye. Feto fe hulo itoto mina ononawa ya hiyaba abo we adinalo moloitoto monimo eba faiga ma wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uto, nala waini ilawa falatibo hamenalo ya mineuti ilawa falatibo ma ya homato lito liwila oto ano, loto mina hiyaba abo we minadoka houba-nabala we ma ilifi molaito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wifa, ido analo-hinalo liti hofo edoti idafa ma umámoti heni fulato liwila oto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Liwila oto aito mina yawala yakafo houba-nabala we ma ya hofa ilifi molaito wifa, manana hofoti nosámibo idafa fe edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Feto fe edato, aliga we magi ya ilifi molaito wito wewa ya hofo fuliyae. Hofo fuliyato, we abi ya idipi molaito uwafa, maleka ya hofo betiyae. Maleka ya hofo beti fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hofo beti fuliyato, ilifi molanaibo we makoko ma nebo ya hipala lula-hala muibo we ya ne. Hipalawa ya aliga ilifi minado ya moloto feto loto holibo, Hipane huliya ya li faka lanigilae, loto holito ilifi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ilifi molaibo wewa wibo ya mina hiyaba abo we yasi wa edoti eimotina yau feto labo, Emo ya Melafokafo idafa-adafala li weuna fi edaibo wema ne. Yagunu hofo fuliyokelo. Melafo fulinaibo hamenalo ya weuna fi edaibo idafa muki linogolone, loti ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","analo-hinalo liti hofo fuliti hono ula ya migu yauti fulo feka itae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ena waini ilawa mina yawalakafo neidafa-neidafa anaiye? Holiyafe? Emokafo mina hiyaba abo wenina minadoka loto hofo beti fulito migu onona ya eito wenina adinalo molanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ido mono lufuwau ya feto libo, Hefana ya numuna huwabo wenina wa aifa idafaidana itabo nefa, ido aya hefanawa yama moda numuna lagi hola fibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wenaba yakafo idafawa feto libo ya wato elegiyone, loto ha mono lufuwau (Sng 118:22-23) nebo hawa ya hitámafe? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Loga o betito, emotinasi wase ito ha libo ya holiyabo, Lemo ya lo ledaibo yagunu nala i edanune, loti holafa, wenina mau minabo holitina holiti ya fulo edoti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ena aliga Falisi wenina magi ido Heloti ege molabo wenina magi Yesu ya ha nosámibo lanaido ya sigiya lomune, loti emo nedo idipi molato ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","emodoka loti feto lomuwabo, Api lilibiyanibo we, lemo holiyonibo ya hemo ha onako lo-lo ane, loto holiyone. Ido aifa weninafe, ido hulitina nebo wenina ya holitina holiyámoto, haka ligi-ligi kiyámoto Goti hanulalo moninabo mona ya ona fefe loto api lilibi-lilibi minane. Yagunu lageto holinune. Hiyaba we wenaba Sisa hefana takisi mu-mu onibo mona ya Goti nomunalo ya fefe loto nefe? Feito mu-mu anubemo, ido umámanune? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Feto lafa, ido Yesukafo monona loiti iyabo monatina holitoto ya feto lobibo, Neidafaiti hepa molo nomae? Hefana denaliyasi ya nilibiyato wanowe, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","hefana ma li muwato watoto loga o betibo, Weuna hefanawalo ya hema weuna ne? Ido lufuwa yagi hema idafala ne? loto loga o betito, liwila oti lomuwabo, Ya Sisa idafala ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Feto lato, Yesukafo feto lobibo, Feto Sisa idafala liti ya Sisa liwila oti muilo. Ido Goti idafala liti ya Goti liwila oti muilo, lito, elegi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ena Sadusi we yasi wenina fuliyaguti hofa sinoiyámanigilae, loti lo-lo abo wenina ya Yesu nedoka loti feto loti loga o edabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Api lilibiyanibo we, Mosesekafo mono lufuwau feto loto ibo, We ma fuliyagetoma, olonafo hofawa minoto olufola ma li oloto piyáminako, fulibo we unalafo yakafo wena-hiyonawa ya lito yalafodo olufo li oloto pi edanaiye, loto lolumibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ido we ma hipala seweni (7) minagu yauti homu we yakafo wena lifa, olufola hedo molámoto fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ido fulibo we unalafo makafo wenawama lifa, olufola li oloto piyámoto ayaidana oto fuliye. Fulito, ya aliga unalafo naba tili (3) yakafo wenawa ayamaidana aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Feti hipawa seweni (7) yama ayaidako oti olufo ma hedámoti fuliyato, aliga wenawa yamagi fulibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ena yalafo-unalafo seweni (7) ya wenawa liyabo yagunu fuliyaguti hofa sinoinabo hamenalo ya hema olonafo minanaibo ne? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Loga o edato, Yesu liwila oto lobibo, Hemotina ya mono lufuwau nebo ha yagi ido Goti aubala yagi holifefe ladámanako, yagunu hopa ha lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wenina fuliyaguti sinoinabo hamenalo ya we wena mofu molámoto, we wena adinalo li biyámanigilae. E'e, enisole okulumau minabo yaidana oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ido wenina fuliyaguti hofa sinoinabo yagunu hemotina Mosese mono lufuwa igu ya yá hefolalo so libo hala lufuwa ibo ya hitámafe? Yalo Gotikafo ha feto lomuibo, Nemo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila minowe, loto ha mono lufuwau (Kis 3:6) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Emo ya wenina fuliyabo Gotitina minámiye. E'e, wenina hofawa minabo wenina Gotitina ne. Hemotina hopa-napa hatina ki minae, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ido lo molaibo ha api itibi-itibi abo we minaguti ma loto moliya fiyabo ha holito Yesu ya ha dowa loto liwila oto lobibo hala holito feto loto loga o edaibo, Lo molaibo ha muki yauti nena ha ya u homu uto auba ibo ha ne? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesukafo liwila oto lomuibo, Ha ya u homu uto auba ibo ha feito ne: Isilaeli weninao, hemotina ya holilo. Wenaba Gotite ya Wenaba makoko ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lutina-hatina muki, ido weudina muki, ido hatina-manadina muki, ido aubatina muki, ya wenaba Gotitina ya muilo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ido auba ibo ha naba tu (2) ya feito ne: Heimokagunu holiyanibo yamaidana oto weninaka muki ya luka-haka bi-bi o mino, loto ha mono lufuwau (Lo 6:4-5, Wkp 19:18) nebo hawa loitiwa ya ha makafo ya li fulo edámanaibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lomuito, ya feto lomuibo, Api lilibiyanibo we, ha fefe loto lane. Goti ya makoko ne. Ido eito ma minámiye, loto lanibo ya ha ona lane. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ido hawa lanibo, Lutina-hatina muki, ido weudina muki, ido hatina-manadina muki ya Wenaba Gotitina ya muilo. Ido heimokagunu holiyanibo yaidana oto wenina muki luka-haka bi-bi o mino, loto libo hawa yakafo sokila hi muwabo idafa muki, ido hofo hi muwabo idafa muki yagi ya li fulo betiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Feto lito, Yesu ya wewa ha fefe loto lomuibo hala holito feto lomuibo, Goti wehudi weninala hiyaba o ledaibo hilalau yonabo hanu ya hemodoka selo molaiye, loto lomuiye. Yaloti ya wenina holiya holiti hofa loga-miga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ena Yesukafo fele huliyagi numuna naba hilalau ha mono api itibi nebo hamenalo ya feto loto loga o betibo, Lo molaibo ha api itibi-itibi abo we yasi Goti ilifi molaibo we Kilisto ya Defiti ouwamela ne, loti lo-lo abo ya igaidana oti lo minae? ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Weuna Fele yakafo Defiti mino edoto welau ha molaito, feto libo, Wenaba yakafo Wenabane ya lomuibo, Ane onaleka amedoto hiyaba oto minageto, ya uwokafo-mota fulo higa feumau betinogolowe, loto libo ne, loto ha mono lufuwau (Sng 110:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ido Defiti ya eimolakafo lomuibo, Wenabane ne, loto lito ya Kilisto ya igaidana oto Defiti yufa figu yauti minoto ido Wenabala yagi ne? loto liye. Ido wenina mau naba minabo ya hawa ya holiti lutina-hatinau dowa loto holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesukafo api itibito feto lobibo, Hemotina ya lo molaibo ha api itibi-itibi abo we yagunu holiti wati monilo. Emotina yasi utinalo owo fana-fana iti moniti, ido maketilo ya wenina wa ledoti, aiyo-weiyo lolumunae, loti holiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ido Yuda wenina mono numunatinau yowabo ya wenina nomudinalo folomo welalo yako minanune, loti holiti, ido wetina-idafa nanune, loti feyabo hamena ya folomo welalo homu yaloko minanune, loti holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ido wena-hiyona numunatina idafa-adafatina aifa liti, ido wenina wa ledanae, loti ha fana-fana Goti lomu-lomu o minae. Aya weninawa ya lifima ha naba-naba liwila oti linabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ya fele huliyagi numuna nabau hefana-huwamena yau fulo-fulo abo ebato selo sinoi minoto wenina naba mau minabo yasi hefanatina fulabo ya wa beti ne. Wa beti neto, wenina idafa-adafa wa nabo muki ya hefana naba fulafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","wena-hiyona ma idafala minámibo ya loto hefana luta hefola loitiko ma fulaibo ya wani (1) toya yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wenawa fulaibo ya watoto ege-ege moniyabo we ya alo, lobito emodoka ato feto lobibo, Ha ona lobiyowe. Wena-hiyona ya idafala minámibo yakafo hefanala huwamenaku fulaibo ya wenina muki hefanatina fulabo ya li yoima o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aya wenina ya idafa-adafatina wa nagu yauti fulafa, emo idafala minámigu yauti ya idafa hefola efoma mino edaido yama moda fulo hulinako, ya ma minámiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ya fele huliyagi numuna naba fulitoto lumito ya ege-ege moniyabo we yauti makafo feto lomuibo, Api lilibiyanibo we, waohae. Hefana naba-nabagi ido numuna nabagi ya dowa liye, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesukafo liwila oto libo, Hemo ya numunawa naba wabe? Hefana makafo hefana ma mulalo nebo meidana oto waitámanigilae. E'e, muki ya itifu fulato, lumu fou lanogolaiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu Olifi obulalo amedoto neto fele huliyagi numuna naba holaleka neto Pitale, Yemusile, Yonile, Adulule ya eimotinako emo nedo loti feto lomuwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Idafawa ya nenafeko oloto pinaibo ne? Ido idafawa muki ya moda alilitagetoma, ya nena idafa fedageto wa edanune? Lolomo, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Feto lomuwato, Yesukafo liwila oto lobibo, Hemotina ya hote itanae, loti wati monilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wenina abi loti ya loti huline liti feto lanabo, Nemo ya nilifi molaibo wewa ya minowe, loti wenina muki hotina inigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ido fina ha, ido lowa ha holitima, holi biyámaneyo. Idafawa oloto pinogolaifa, mika okuluma hulanaibo hamena ya onesa oloto piyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ido wenina mika malekagi mikalokati lowa fina fimo uwato, ido mikalo wehudi ma weninalagi, ido ma weninalagi ya lowa fina fimo unigilae. Ido mikau-mikau mima naba oto, ido inagunu fulinabo hamena ya oloto pinaibo ne. Idafawa holinabo, ya wenipa utina ogofu aito olufotina hedabo yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hemotina ya wati monilo. Hemotina ya adinalo-hidinalo liti idipiti uti kanisole wenina adinalo biyato, ido mono numunatinau ikula hofo betinabo ne. Ido hemotina nege molabo yagunu wenina hiyabatina we wenaba ido mikalo wehudi nomudinalo ya li sinoi betinigilae. Feto fe betiyato ya nemo hane lobinae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ido homu hane ukune dowa ya wenina mikau-mikau lo oloto binigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ido adinalo-hidinalo liti idipiti uti li halo molo betinabo lusanigu uwatoma, hemotina ya ha igaidana oto liwila oto lobinubo ne? loti hatina loiti-loiti kiyámilo. Aya hamenalo ya heimotina hatinalokati ladámanigilae. E'e, Weuna Fele yakafo wetinalo ha lanabo molanaibo hawa ya aifa lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ido yalafokafo unalafo ya uwolafo-mota adinalo biyageto hofo fulinabo ne. Ido melafokafo olufola ya uwolafo-mota adinalo biyageto hofo fulinabo ne. Ido olufotina yasi otinafo metinafo metina biti uwotinafo-mota adinalo biyato hofo beti fulinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Hemotina ya weninane minanako, wenina muki holi nosámibo-asámibo binafa, holi hiki loti auba iti minobo henawa hulanaibo hamenalo yonabo wenina ya li nomudina wanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nemo lufuwa me ya iyobo ha ya hemotina hitanabo ya hatina kifefe loti monawa holifefe loti holilo, loto lobiyowe. Yesukafo ha ma onu ito lobibo, Ido aliga idafa nosámibo-asámibo muki idafa li hopaitanaibo idafa ya loto Gotikafo, E'e, libo ebalo minanaibo ya wati Yudia mikalo minanabo wenina ya obulalo holi yonae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ido ma numuna obito minanaidoti ya lumuto numunalau yauti huwamenala liyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ido makafo minawau onona linaidoti ya hofa liwila oto uto ulalo owo ya liyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ido aya hamenalo ya aiyo, wenipa olufotina houmatinau nebogi, ido wenipa olufotina amina bi minanabogi ya hena naba-naba holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ido idafawa fedanaibo ya asi naba anaibo hamenalo oloto pitanaiye, loti Goti lomu-lomu o minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Idafawa oloto piyagetoma, hena naba-naba holinabo idafawa ya Gotikafo mika okuluma li oloto pido akaimati ya henawa naba-naba yaidana oloto piyámibo ne. Ido aliga yagi henawa yaidana ma oloto piyámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ido Wenabakafo hamenawa ya li fouma itámibo neko, wenina ma ya minámadi ne. Feito nefa, emokafo weninala weuna fi betibo yagunu holito hamenawa ya li fouma itaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ido aya hamenawalo ya we makafo lanaibo, Walo. Ilifi molaibo we Kilisto me ya ya ne, loto lanaife, ido, Walo. Yowa ne, loto lanaibo ya holi hikito umámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wenina ma oloto piti sugi ha lanabo, maleka, Nemo nilifi molaibo we Kilisto minowe, lato ido masi, Nemo polofeti minowe, loti anabo, ya idafa hofawa naba-naba eito-eito ido aubatina idipibo idafa li oloto pinabo, ya Goti weuna fi betibo weninala yagi hotina inune, loti ogofunabo neko ya hotina inadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Feto feyanabo ya hemotina wati hiyaba oti monilo. Idafa-adafawa muki aliga anaibo idafa yagunu homu oloto piyámibo hamenalo ha muki ya moda lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ena henawa naba hulageto, aya hamenalo ya, Fo ya midipu ito, igana lamenala ya hulito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ofiya ya okulumauti limo iyageto, okulumalo nebo idafa muki ya momoga anogolaiye, loto ha mono lufuwau (Ais 13:1 34:4) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aya hamenalo ya nemo We Hula ya aubane lamenane naba-naba mino nedageto okulumalo limuku loto ya wa nedanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nemo enisolene ya idipi moloto uti fo yoidokati fo lumidoka mikau-mikau yauti weuna fi betiyobo weninane ya idipiti li nuba o betinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hemotina ya yá sigolo monala yamo idafa lilibibo ha ya holifefe loti holilo. Yá sigolo akawa ya adoloma bu loto nowala minoto aila hofawa itoma, ayalo fo lanaibo hamena alili aiye, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Feito idafawa muki lobiyobo ya oloto piyageto hemotina wa minanabo, hamenawa moda ona selo molotaibo ne, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ha ona lobiyowe. Hamena onesa me ya minabo wenina maleka fuliyámato ya idafawa muki lobiyobo ya oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Holilo. Mika okuluma ya hulanogolaifa, hane ya minowa-minowa omo yoto huladámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Idafawa muki oloto pinogolaibo hamenala, ya ma holi minabo wenina ma minámae. Ido okulumalo enisole ya holiyámae. Ido Hipala nemo yagi ya holiyámowe. E'e, Metefo yako ya holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ido hemotina yagi hamenawa oloto pinaibo ya holiyámanako, nomudina falatoti wati hiyaba oti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hamenawa oloto pinaibo ya we ma faiga wibo yaidana oto ne. Wewa numuna fulitoto uto houba-nabala we idafa-adafala hiyaba o edanabo wenina muki onona bito ido hanu welalo hiyaba o minanaibo we ya wato hiyaba oto mino, lomu itoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ido numuna yawala ya nenafeko liwila oto anaiye? Lunagafe? Luwailafe? Okolofo lanaidofe? Ho lanaidofe? Liwila oto anobo hamena ya holifefe ladámanako, yagunu wati hiyaba alo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nemo haita liwila oto loto, hemotina uwo uno minanabo ya li oloto pitanowe, loto, wati hiyaba alo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ido hawa hemotina lobiyobo ya wenina muki ayaidana oto feto loto lobiyobo, Wati hiyaba alo, loto lobiyowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ena hamena loiti utaito, Goti Uta o Betibo foliwagi, ido beleti lifefe lagu yisi molámoti aifa hiti no-no abo foliwagi ya oloto pinaibo sokila hi mu-mu abo we hiyabatina we ido lo molaibo ha api itibi-itibi abo we yasi Yesu nedo momona oti analo-hinalo nala iti hofo fulinigili ha loti lo moloti hudawa hiyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","wenina ya abi lanako, fina fitanae, loti foliwalo ya hofo fuliyámanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ena Yesu ya Betanika numudoka ya homu okola hilibo we Saimoni numunalau amedoto minoto wela-idafa no neto, wena makafo nomu hefana pana hibo nomuku no ladanuwa aibo nalitikafo lifefe labo meinala naba nebo ya lito loto nomuma wela lekoto no ya Yesu atalalo leki edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Leki edaito, wenina minagu yauti masi lutina hala-kala lito, eimotina yau feto labo, Nowa ladanuwa aibo ya neidafaito aifa fulaiye? ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Idafawa ya hefanalo fulaibo neko, we ma melege mako onona liti meina libo yaidana oto lito idafa wa námabo wenina ya biyadi ne, loti auba iti hanu muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hanu muwato, Yesukafo lobibo, Waiti edalo. Nedafaito ya hanu mu minae? Emo yakafo idafa dowa fe nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Holiyafe? Idafa wa námabo wenina ya moda hemotinagi hamena-hamena maina keloti minato, adina li faka lanune, loti holinabo ya aifa adina li faka lanigilafa, nemo ya hemotinagi hamena-hamena maina minámanogolo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Emokafo ya fulinobo hamena selo molainako, yagunu homu no ladanuwa aibo unelo lekibo ya fuliyoto hale li nedanigilabo yagunu ya feto fe nedaiye. Feto fe nedanaibo idafa ya fe nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ha ona lobiyowe. Hane ukune dowa mikau-mikau lobimo unado ya wenawa me ya idafawa fe nedaibo hala yagi lobimo uwato ya emogunu holiwa-holiwa minanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ena Yesu ege moniyabo we tuwelu (12) ya minaguti Yudasi Isikaliyoti yakafo, Yesu ya uwolafo-mota adinalo molanowe, loto sokila hi mu-mu abo we hiyabatina we minado wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wito, hala holiti ake naba-naba oti meina humunune, lo molo muwato, Yesu adinalo binaibo hanu ya moni wita omo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ena foliwa beleti lifefe lagu fudanaibo idafa yisi molámoti aifa hiti no-no abo foliwa lo fedito, homu hamenalo ya Uta O Betibo hate molotanaiye, loti sipisipi mofola hofo hiti no-no abo ne. Aya hamena ya fedito ege moniyabo we Yesu nedo loti feto loti loga o edabo, Numuna igau Goti Uta O Betibo wete-idafa hofo hito lifefe lanune? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Loga o edato, ege-ege moniyabo we loiti ya idipi moloto feto lobibo, Numuna meya nabau yonaido ya we ma no fi-fi abo masa mofuto anaibo we ya hatula anaibo ya ege moloti wiliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ege uti, numunalau yoibo numuna yawala feto lobiliyo, Api lilibibo wekafo ya nege-nege moniyabo wegi Gotikafo Uta O Betibo wete-idafa nanubo eba ya igau ya ne? loto loga o hedaiye, loti lomuliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Feto lomunaibo ya eba naba ma hunu-anu wiliti lifefe lotabo eba ya idipiyageto, yau wete-idafa hofo hililo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lobito, fulo edoiti uti numuna meya nabau yoti Yesu libo idafawa yaidana li oloto piti Goti Uta O Betibo wetina-idafa hofo hiyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lunaga fo sapito, ya Yesugi ege moniyabo we tuwelu (12) yagi loti ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","amedoti wetina-idafa noti minoti ya Yesukafo feto lobibo, Ha ona lobiyowe. Hemotina yauti we makafo nemo ya Uwonefo-mota adinalo binogolaiye. Wewa ya nemote wete-idafa noibo we ne, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","lutina-hatinau hena naba-naba aito muki feto lomuwabo, Nemofe? Nemofe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","liwila oto lobibo, Nege moniyabo we tuwelu (12) minagu yauti mako ma lapeku nemote beleti fuloto idafa lito noibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nemo We Hula ya moda fulinobo hanune yagunu ha mono lufuwau iyado ayaloma ya unogolowe. Feito unafa, ido nemo We Hulama ya uwonefo adinalo binaibo we ya aiyo, lifima ha naba-naba liwila oto linaibo ne. Wewa ya olafokafo hedámibo neko, dowa minadi ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wetina-idafa no minato, Yesukafo beleti ma lito, dowae, lalowe, loto lomutoto, lekoto ege-ege moniyabo we bito ya lobibo, Lilo. Une ya ne, loto, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ido nomu lito, dowae, lalowe, lomutoto ya bito, muki ya nomu yauti nae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nato, emokafo feto libo, Me ya ya nemo lunune ne. Gotigi li hutifina betibo ha li auba i edaibo lunune ya wenina abi yagunu lekinobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ha ona lobiyowe. No waini ya hofa ma moda námoto minomo uto uto Goti wehudi weninala hiyaba o ledaibo hilalau hemotinagi no waini hofawa ma hofa nanogolone, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lobito, mono nama lo ititi ya feka uti Olifi obulalo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olifi obulalo yowato, Yesukafo libo, Gotikafo feto libo, Nemokafo sipisipi hiyaba we ya hofoto sipisipi ya upatanigilae, loto ha mono lufuwau (Sek 13:7) nebo nenako, hemotina muki ya fulo nedoti holi unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Feto feyanafa, ido nemo fulinoguti sinoito ya Galili mikau homu molo betito unogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lobito, Pitakafo ha liwila oto libo, Maleka muki ya holi fulo hedoiti uwatoma, ya nemo neimone ya moda fulo hedámanogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lomuito, Yesukafo libo, Nemo ha ona lohomowe. Eletifo luwaila okolofo hamena loiti nola ladámageto, ya heimoka yakafo hamena loitigi-makogi ya huline li faluku anogolane, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Feto lifa, Pitakafo ilalu huto auba ito lomuibo, Hofo fulinabo ya nemogi maina hofo nedo fuliyatoma, moda hulika ya li faluku ámanogolowe, loto lomuito, ido ege-ege moniyabo we muki yagi ayaidanako oti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ena Yesu ido ege-ege moniyabo we ya eba ma huliya Getesemani loti emokafo feto libo, Melo amedoti minalo. Nemo yolalo uto Menefo lomunogolowe, lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitale, Yemusile, Yonile idipito uto yaloti apito lula-halau hena naba-naba oto nosámito metolito holito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lune-haneu hena naba-naba obo yakafo fulinoboidana aibo yagunu melo minoti hiyaba o minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Feto lo itoto, hefola ma monimo uto hola-wela mikalo limo fito, hanu ma minageyama, hamenawa ya li fulo nedanaiye, loto Goti ya ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","feto lomuibo, Wauwe, Menefo, idafa-adafa muki feto feyananibo ya moda ogofuto minane. Miluma holiyobo kapu me ya ya li fulo nedanane, loto holiyobo nefa, ido nemo holiyodo molo nedámoto, heimoka holinanido ya molo nedo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lomutoto, ya liwila oto ege-ege moniyabo we minado loto wa betima, uwo uno minato ya Pita lomuibo, Saimoniyo, uwo unabe? Nemogi hamena fouma efoma maina hiyaba ananibo ya ogofuwámabe? ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ido idafa ma hepa molo lumuto anaibo idafa lemodoka fedo lumutanaiye, loti wati hiyaba oti Goti lomutiko minalo. Lutinau feto feyanune, loti holiyafa, ido utina aubala ya hefola ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Feto lo itoto, hofa uto Melafo homu lomuibo hama moda ayaidana oto hofa lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lomutoto hofa liwila oto aibo nomudina fifi aito uwo uno minabo ya wa betito liwila oti lomunabo ha ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ena hofa liwila oto minado loto feto lobibo, Aifa minoti uwo unoti foli minafe? Modae. Hamenane ya moda lo fedinako, nemo We Hula ya lifimatina nebo wenina adinalo moda biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sinoiyato, uwokelo. Uwonefo-mota adinalo bibo we ya moda lo fediye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Feto lobi neto ya ege-ege moniyabo we tuwelu (12) minagu yauti ma Yudasi ya lo fedito ido emogi maina abo wenina mau naba minabo adinau ya mi nabafena mainafafena liyabo ya lo fedae. Lo fedabo weninawa ya sokila hi muwabo we hiyabatina we, ido lo molaibo ha api itibiyabo we, ido Yuda wenina hiyabatina we yasi, Ilimiti anae, loti idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Idipi molato, uwolafo-mota adinalo molaibo we yakafo homu lobito libo, Wewa ya mudo edanobo ya ne. Analo-hinalo liti nala i edoti hiyaba o edoti ilimiti wilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Feto lobito, ya aloko Yesu nedo lo fedoto lomuibo, Api lilibiyanibo we, loto mudo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mudo edaito, Yesu analo li hiki loti adinau liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Adinau liyato, wenina selo sinoi minagu yauti we makafo mila fana hebelauti ika oto sokila hi muwabo hiyabatina we wenaba houba-nabala we hala ya fuko fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Fuko fulitaito, Yesukafo libo, Nemogunu ya ugele we wenaba ne, loti holiti ya mifena mainafafena liti loti nala fi nedanune, loti afe? ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hamena-hamena fele huliyagi numuna naba hilalau ya wenina api itibimo uwodo yama anelo-hinelo liti nala fi nedámabo ne. Feto fe nedámama nefa, ha mono lufuwa iyabo ha yama u ayalo inaiye, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ege-ege moniyabo we muki ya fulo edoititi holi uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Holi uwato, we hofawe ulalo lafo-lafoko holoibo ya Yesu ege wito emotinasi analo liyato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lafo-lafola apaso fulitoto ya apako holi wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ena Yesu analo-hinalo li hiki loti ilimiti sokila hi mu-mu abo we hiyabatina we wenaba nedo uwato, yalo sokila hi muwabo we wenabatina muki ido lo molaibo ha api itibiyabo we, ido Yuda wenina hiyabatina we ya lo fedoti nuba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nuba oti minato, Pita faigato moloto ege uto sokila hi muwabo we hiyabatina we wenaba numuna hilalau yoto yalo himiwegi maina amedoti so labi oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ena sokila hi muwabo we hiyabatina wemoli, ido Yuda mono kanisole we muki yasi Yesu hofo fulinabo ha li oloto pinune, lafa, ha ma li oloto piyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Li oloto piyámato, muki ya sugi ha fi munabo ya lo fedafa, ha labo ya u mako aguwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","U mako aguwámito, wenina masi sinoito sugi ha lo edoti feto labo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Wewa yakafo feto libo, Fele huliyagi numunawa naba adinagunu huwabo ya lukoto fo hamena tili (3) uwageto numuna ma wenina yasi huwámabo ya hu hulanobo ne, lito ya moda holiyonibo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Feto lafa, hatina yagi ya u mako aguwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","U mako aguwámito, sokila hi muwabo we hiyabatina we wenaba yakafo nomudinalo sinoi minoto Yesu feto loto loga o edaibo, Hemo ya ha ma liwila oto ladámanabe? Weninawa halo molo hedabo ya nena ha lae? loto loga o edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu ya ha liwila oto lomuwámoto ne. Lomuwámoto neto, sokila hi muwabo hiyabatina we wenaba yakafo hofa loga o edaibo, Hemo mino holimo wibo we Hipala ya hilifi molaibo we Kilisto minabe? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesukafo liwila oto lomuibo, Nemo ya minowe. Ido aliga nemo We Hula ya aubafofo libo we ana onaleka amedoto minoto okulumalo limuku oloto piyoto wa nedanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hawa lido ya sokila hi muwabo hiyabatina we wenabatina eimola ulalo owo fekalito ya libo, Ake, neidafaito ha ma moni wita anubo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Moda Metefo hamana onesa hibo hala ya holitama ya nenako, yagunu hemotina moda nedafaiye loti holiyae? loto loga o betito, muki yasi, moda fulinaibo ne, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Feto lato, masi etefu o edoti lafo-lafogunu nomunalo wase iti adinagunu hofo edoti feto lomuwabo, Polofeti ha lolomo, lato, ido himiwe yasi ilimiti uti adinagunu hofo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Idafawa feto fe edato, Pita ya feka numuna hilalau youmaleka neto, olu ma sokila hi muwabo hiyabatina we wenaba houba-naba oluwa loto ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita so labi oto nebo ya wenu wa edoto feto lomuibo, Hemo ya Nasaletekati aibo we Yesugi minanima ne, lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","emokafo feto libo, E'e, ha lanibo ya holifefe loto holiyámowe, lomuto uto numuna hanu welalo ne. Neto okolofokafo liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yalo neto, houba-naba oluwa wa edoto wenina selo sinoi minabo ilalu huto lobibo, Wewa ya hounalafo-mota? Minagu yauti ne, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitakafo hofa, E'e, lomuiye. Lomuito, aliga hefola selo sinoi minabo wenina yasi feto lomuwabo, Hemo ya Galili we minaninako, hounalafo-mota? minagu yauti moda minane, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lato, emokafo auba ito liwila oto lobibo, Wewa yagunu ha labo ya moda wa edámowe. Ha ona ladámoto ya Gotikafo li hopa o nedanaiye, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hawa lido ayalo ya okolofo hofa kokololo lito ya Pitakafo Yesu ha homu lomuibo, Okolofo hamena loiti nola ladámageto hemokafo hamena loitigi-makogi (3) ya huline li faluku anogolane, loto lomuibo ha yagunu holito hufo naba-naba aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ena ho lito, sokila hi muwabo we hiyabatina we muki, ido Isilaeli wenina hiyabatina weninagi, lo molaibo ha api itibiyabo weninagi, mono kanisole we muki yagi nuba oti loyolalo-melo oti hatina li mako moloti Yesu analo nala iti ilimiti uti Pailati analo muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Muwato, emokafo feto loto loga o edaibo, Hemo ya Yuda wenina hiyabatina we wehudi minabe? lito liwila oto lomuibo, O, hemo heimoka ya moda lane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ido sokila hi muwabo we hiyabatina we yasi muki ha sigiya lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","hofa Pailatikafo loga o edaibo, Ha ma liwila oto ladámananibo nefe? Sigiya ha muki lo hedabo ya holiyo, lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","hofa liwila oto lobiyámito, Pailati ya loiti hala kiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ena melegelo-melegelo aya foliwalo ya gamani hiyabatina wenabama yakafo mau minabo wenina yasi nala we ma huliya lato, ya wina fulo beti-beti aibo mona ya molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ido aya hamenalo ya nala numugu gamanigi fina fiti wenina hofo beti fuliyabo wenina minagu yauti hasuwala fi-fi aibo we ma huliya Balabasi ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ido mau minabo wenina yasi Pailati nedo loti feto labo, Homu mona molo ledo-ledo anibo yamaidana oto hofa molo ledo, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Feto lato, emokafo feto loto loga o betibo, Nemo ya hemotina Yuda wenina hiyabatina we wehudi ya wina fulo edanaiye, loti holiyafe? loto loga o betibo, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","sokila hi muwabo we hiyabatina we ya wenina muki holi muti labo holi fulitanigilae, loti holiyabo yagunu wauwa liti anelo molae, loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Holifa, sokila hi muwabo we hiyabatina we yasi mau minabo wenina sebatinau fali witunu iyato, ya emotinasi feto labo, E'e, Balabasi ya wina edo, lato ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","feto lobibo, Ena wewa ya Yuda wenina hiyabatina we wehudi ne, loti huliya molabo we ya neidafa-neidafa o edanowe? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","liwila oti hai naba moloti feto labo, Yá yofolo hofo fuliyo, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Feto lato, emokafo hofa feto loto lobibo, Nedafaiye? Nena mona nosámibo ya molaibogunu ne? loto loga o betifa, lo gedoti ilalu huti labo, Yá yofolo hofo fuliyo, loti hai naba moloti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Feto lato, Pailatikafo wenina mau naba ya lutina-hatinau dowa loti holinae, loto Balabasi ya wina fulo beti bito ido Yesu ya ikula auba iti hofo edotiti yá yofolo hofo fulinae, loto himiwe adinalo molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ena himiwe yasi Yesu ilimiti uti Lomu gamani hiyabatina we numuna huliya Pilatoliumu hilalau yoti himiwe muki ya li nuba o betiti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ulalo owo fana luta libo ma holoi edoti, ido nala agina hasuwalagunu helekamu lifefe loti atalalo holuto i edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","feto loti apiti sula fiyabo, Aiyo, Yuda wenina hiyabatina we wehudiyo, siyane, loti ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","honofa liti atalalo hofo edomo uti etefu o edoti, hidina obula fiti, sugi idafa oti holi umae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Feti hamana hititi, owo fana luta liboma li fuloti eimola ulalo owo liwila oti holoi edoti ya yá yofolo hofo edanigili ilimiti feka uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesu ilimiti uwado, ya we ma Alekisadate Lufusite metinafo huliya Saimoni ya Sailinikati we hanudo Yelusalemuka unowe, loto aido ya wa edoti analo liti yá yofola ya abukalo mofuwo, loti auba iti lomuwato mofuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mofuito, uti eba ma huliya Gologota yalo ya fedae. (Huliya monawa ya atatina auba ne, loti molae.) ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Fedato, no waini nogi ido yá nowala huliya mulugi li maina itoti nanaiye, loti umafa, námiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yá yofolo hofae. Hofoti, ulalo owo yagunu noka hedoti hona moloti liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hofo edabo hamena ya naini kiloku (9) ya yá yofolo hofo edabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ido halo molo edabo ha lufuwa ibo ya, Yuda wenina hiyabatina we wehudi ne, loto lufuwa ito molae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ido hasuwala fibo we loiti emogi maina hofo betiyabo ma ya filiga onaleka ido ma ya filiga adawaleka ya yá yofolo hofo betiyae.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ido, Emo ya ha holiti holiyámoti abo we yaidana oto ne, loti wa edabo ne, loto ha mono lufuwau (Ais 53:12) nebo ha yama ayalo ya iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ido wenina uti loti emotina yasi ha nosámibo-asámibo auba iti lomuti otina gima-gama i muti, feto lomuwabo, Ake! Hemo fele huliyagi numuna naba ya luko fulitoto fo hamena tili (3) hofa hu fukanobo ne, loto lanibo we ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yá yofoloti lumuto heimoka li nomuga wao, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Feto lomuwato, ido ayaidana oti sokila hi muwabo we hiyabatina wegi, lo molaibo ha api itibiyabo wegi eimotinagu hamana hiti feto labo, Wenina eito ya li nomudina wa-wa aiboma nefa, ido eimola li nomuna wanowe, loto ya ogofuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ido aya wewa Goti ilifi molaibo we Kilisto ya Isilaeli wenina hiyabate we wehudima yá yofolo yati lomageto watoma, holi hikito munune, loti lato, ido we emogi maina yá yofolo hofo betiyabo yagi ha nosámibo lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ena folilo 12 kiloku (12) yalomati u lunaga tili kiloku (3) ya mikau-mikau muki ya midipu imo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ido lunaga tili (3) kiloku yaloma ya Yesukafo hai moloto libo, Eloi, Eloi, lama sabaktani? loto hai moloto libo ha monawa ya Gotine, Gotine, neidafaito fulo nedane? loto hai moloto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ido selo sinoi minabo wenina hawa holiti feto labo, Holilo. Elaiya sula fiye, lato ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ido we makafo aloko oluloto uto idafa ho nokuti noi yaidana hilibo ya lito no waini ekefa aibo yau fito honofa osolo pito Yesu nanaiye, loto muto feto lobibo, Onesa waita edalo. Elaiya loto wina edageto lumunaife? Wa minokelo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Feto lito, ido Yesukafo hai naba moloto wela mula hulito fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Fulito, ya ayalo ya fele huliyagi numuna naba lulau ya wa edotanae, loti lafo-lafo naba diyabo ya yaleka atalalokati filiga-filiga fekalito waka lumibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ido himiwe Yesu nomunalo sinoi nebo we yakafo hai moloto fulibo monala wa edoto feto libo, Wewa ya moda ona Goti Hipala ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yalo ya wenipa magi ya faiga minoti idafa wati holiti minae. Minagu yau Malia Madala numudoti wenagi, ido Yosefete Yemusi abalafote otinafo Maliagi, ido Salomegi ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Homu Yesu Galilika nebo hamenalo ya wenipawa ya ege moloti houba-naba o edato, ido wenipa ma abi loti emogi maina loti Yelusalemuka fedabo yamagi yalo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ena lunaga midipu inogolaito ya Sabati foli alili aito Yuda wenina Sabati foligunu wetina-idafa hofo hi molanabo hamenalo nenako, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefe Alimatea numudoti we Yuda wenina hiyabatina we kanisole minagu huliya nebo we eimola ya Goti wehudi weninala hiyaba o betibo hamenala ya hiyaba o minaibo wewa yakafo auba ito Pailati nedo uto Yesu hono ula ya numunabe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Loga o edaito, Pailatikafo libo, Moda fulitaife? loto hala loiti-loiti kito himiwe hiyabatina we, ano, loto ha fulo edaito holito aito feto loto loga o edaibo, Yesu ya moda fulitaife? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","himiwe hiyabatina wekafo liwila oto lomuibo, Moda fulitaiye, lito Pailati ya Yesu hono ula ya liyo, loto Yosefe lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lomuito, Yosefe uto lafo-lafo hiyoba feke ma meina fito uto hono ula yá yofoloti lito lafo-lafogunu wase ito lito uto hefana lulau molaiye. Molo itoto, hefana fowena naba-naba ma hululu moloto lito loto oto, hefana lula welalo ma lotana iye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lotana ito, Malia Madalakati wenate, Yosefe abalafo olafo Maliate ya molo edaibo eba ya wa minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena Sabati foliwa hulito ya Madalakati wena Maliate, Yemusi olafo Malia abalafole, Salomele ya uto Yesu hono ulalo ya yá nowala wili edanune, loti ladanuwa aibo idafa meina fiti ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","leda Sadeku ho lido ya hefana lulau hono ula molagu ya unune, loti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Uti hanudo ya eimotina loyolalo-melo abo, Hemakafo ade li faka loto hefana naba hale welalo lotana itabo yama hululu molo ledanaiye? loti loyolalo-melo oti ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","wa faka loti hemo ya hefanawa naba-nabama ya hululu utaito wa edae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wa edoti hefana lulau yau yoti we hofawe ma ulalo owo hiyoba feke ito ya anawaleka amedoto nebo ya wa edoti holi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Holi bito wewa yakafo feto lobibo, Holi holiyámilo. Hemotina ya Yesu Nasaletekati we yá yofolo hofo fuliyabo ya moni witala minae. Emo ya fuliguti hofa sinoitaibo ne. Meu ya minámito, molo edabo ebau ya walo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Alo uti ege-ege moniyabo we lobiti ido Pita yagi ya feto lomuilo, Emo ya homu lobibo yaidana oto Galilika homu molo betito yalo ya wa edanigilae, loti lobilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Feto lobito, wenipa utina ololo oti elegiti hefana lulauti feka uti oluloti uwae. Uti holi binako, hawa ya wenina lobiyámae.  ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sadeku ho lido Yesu ya fuliguti hofa sinoito homu Malia Madala wena Satani himiwela seweni (7) ya lula-halauti li fulo edoto idipi molaibo wenama nomunalo oloto pi muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oloto pi muito, emokafo uto homu maina mino-mino abo wenina lutina-hatinau hena naba-naba aito hufo nama o minado ya uto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lobifa, Yesu hofawa neto Malia ya wa edaibo hala holiti ya holi hikito umámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aliga ege molabo we minaguti we loiti migu unigili moniyaido ya Yesu eito hilito nomudinalo oloto pito, ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","wa edoti wewa loiti ya liwila oti muki minado uti lobifa, hawa yagi lobiyabo holi hikito biyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aliga ya ege molabo we leweni (11) ya idafa no minado, Yesu ya nomudinalo oloto pito holi hikito umámoti ido fuliguti sinoibo wa edabo wenina ya lobiyabo hatina ya ilalu huti holi hikito biyámanako, yagunu hanu biye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hanu bitoto, feto lobibo, Wenina muki mikau-mikau minadoka uti hane ukune dowa ya lobi-lobi alo. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wenina ya holi hikito numuti mono noku inabo wenina ya li nomudina wanaibo ne. Feto feyanaifa, wenina holi hikito nomámanabo wenina ya lifima ha binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ido holi hikito numunabo wenina ya Goti aubala idipibo mebe-maba ya biyageto aya weninawa ya weneloti Satani himiwela ya li fulo beti-beti anabo ne. Ido lowa-lawa ha hofawa ya lanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ido adinagunu hosofa aifa linabo ne. Ido hifena ya wenina hofo beti fulinaibo idafafena ya nanabo ya li nosámibo o betiyámanaibo ne. Ido adinakafo idafa hiliyabo wenina ya utinalo linabo ya li faka lo betinaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ena wenaba Yesu ya hawa lobi huloitaito Gotikafo ilimito okulumau yoito yalo Goti ana onaleka amedoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Neto, ena ege-ege moniyabo we ya uti mikau-mikau hawa ukuwa dowa lo oloto molomo uwato, Wenabakafo adina li faka loto aubala bito wenina muki ya hane ukune ya ona ne, loti holinigilae, loto aubala idipibo idafa ya li oloto pito idipi-idipi aiye. Modae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Wenabane Tiyofilusiyo, nemo lufuwa me ya lufuwa i fulo hedowe. Hito. Lemo minonigu ya idafa oloto pi lumibo idafa ya hana apito oloto pido akaisati ya wenina nomudinakafo wati ha monolo houba-naba onona liyabo wenina lo oloto lomabo ha ayawa ya wenina muki hawa ukuwa wife loto lufuwa inune, loti holiyabo ya moda holiyane. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Feto loto holiyaninako, nemo moda ayaidana oto idafawa muki hana apito oloto pidoti ya mama oto holimo yowoboma nenako, loto ya hemogunu holito li fefe-fefe loto lufuwa iyobo ya hitoto holito ha mono api hilibiyabo ya ona hula ne, loto holifefe lanane, loto hane kito ya lufuwa me ya iyowe. Wao. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ena Yudia wenina hiyabatina we wenaba Heloti hamenalalo yalo Goti sokila hi muwabo wenina ma onona hulitina naba ya Abiya wenina yauti we ma nebo huliya Sekalaiya ya olonafo huliya Elisabeti yagi ya Goti sokila hi muibo we wenaba Aloni yufa fibo yauti wena ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Feito minaibo ya olonafo wanafo loiti ya Goti nomunalo ya lutina-hatina dowa lotiko minoti, Wenaba lo molaibo ha muki ya li meyalo molo-molo o minaito, lifimatina minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Feto fe minaifa, ido Elisabeti ya heni-wena nenako, olufotina minámito, we kilofo wena kilofo molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ena wewa Sekalaiya sokila hi muwabo weninalagi onona hamenatina aito, Goti nomunalo onona li ne. Onona li neto, sokila hiyabo weninawa yasi hi-hi abo monatina li meyalo moloti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ido ladanuwa aibo hinaibo we huliya li oloto pinune, loto li mebe-maba oto noka hedogeto huliya oloto pinaibo we yamo ya ononawa linaiye, loti hedabo ya Sekalaiya huliya oloto piye. Oloto pito, ladanuwa aibo idafa hinowe, loto Wenaba fele huliyagi numuna nabau yau lulau yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lulau yoto ladanuwa aibo idafa hinaibo hamena yalo ya wenina muki nuba minabo wenina ya feka minoti Goti lomuti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Feto fe minato, ladanuwa aibo idafa hi-hi abo folomo onaleka yalo ya Wenaba enisolela ma oloto pi muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Oloto pi muito Sekalaiyakafo wa edoto ula ololo oto holi naba-naba muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Holi naba-naba muito, enisolekafo feto lomuibo, Sekalaiyao, holi homámaneyo. Goti ha lomuwanibo ha ya holi nenako, ologafo Elisabeti ya hipa ma hedanogolaiye. Hedageto ya huliya Yoni ne, loto molo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ido oloto pinaibo yagunu luka-haka moda yowageto ake iyageto wenina muki ake naba-naba inigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Feto ato, Wenaba nomunalo wenaba minoto, no wainife ido li nomudina moninaibo no mafe ya námo, loto lo fuko edo. Emo ya olafo houmalau minanigu ya Goti Weuna Fele mino edoto lula-halau faitoto mino edanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Feito minageto yakafo aliga Isilaeli wenina abi loti ya liwila oto li Wenaba Gotitinaloka idipinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ido Weuna Felekafo Elaiya mino edoto li auba i edaibo yaidana oto emo ya mino edageto, Wenaba u homu molo edanaibo we minanogolaiye. Wewa ya wenina lutina-hatina li elepa i betiyageto olufotinagi lutina-hatina mako molanigilae. Ido ha holiti holámoti abo wenina yagi lutina liwewe o betiyageto ya wenina mona fefe liboko molabo yaidana oti ha mono mona ya fefe loti molo minanigilae. Feto ya wenina lifefe lo betiyageto ya moda fefe loti minoti Wenaba hiyabala o minanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Feto lomuito, Sekalaiyakafo ha liwila oto feto lomuibo, Igaidana oto ha ona lane, loto holinowe? Nemo we kilofo moloto olonefogi ayaidana oto moda kilofo molainao, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Enisolekafo ha liwila oto lomuibo, Nemo ya Gebiliyeli, Goti nomunalo sinoito mino-mino owe. Feto feyoto, emo yakafo, hawa ukuwa dowa loto lomuwo, loto hemodoka nilifi molaito, lumuto lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ya holi mino. Hawa lohomobo hamenala ageto ya moda hulawa anaibo ne. Nefa, hawa lohomobo ya holi hiki ladámanibo yagunu onesa melokati ha ladámoto minanogolane. Ha ladámoto minageto ya hawa hulawa anaibo hamenalo ya hofa ha lanogolane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Feti lo neto, feka nuba minoti Sekalaiya hiyabala minabo wenina yasi fele huliyagi numuna naba lulau yau hamena fana ne, loti hatina loiti-loiti ki minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Feto fe minato, aliga lumuto, ha lanaibo ogofuwámiye. Ha lanaibo ogofuwámoto mebe-maba yako o binako, weninawa ya feto loti holiyabo, Fele huliyagi numuna nabau yau idafa ma oloto pi muiye, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ena sokila hibo onona hamenala hulito ya eimola numunalaloka liwila oto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Uto minaito, aliga olonafo Elisabeti olufola houmalau nebo ne. Olufola houmalau neto ya igana faifu (5) yalo faluku oto minoto feto loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nemo heni-wena minobo yagunu wenina nomudinalo unelo holi minofa, onesa ya Wenabakafo wa nedaibo hamenalo ya unelo holiyobo ha ya li fulo nedanowe, loto ya feto fe nedaibo ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ena iganala sikisi (6) yalo ya Gotikafo enisolela Gebiliyeli ilifi molaito, Galili mikalo Nasalete numudo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Uto yalo ya olu we liyámabo olu huliya Malia ya aidena wehudi Defiti yufa fibo we ma huliya Yosefe wa molo edabo olu nedo lo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Loto oloto pi muto feto lomuibo, Dowae, Wenabakafo lula-halau dowa loto naba wa hedoto mino hedaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Feto loto lomuito, ha libo yagunu ya lula-halau hena naba-naba aito, Nena hama ne? loto hala loiti-loiti kiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hala loiti-loiti kito, enisolekafo feto loto lomuibo, Maliao, holi homámaneyo. Goti lula-halau dowa loto naba wa hedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ena ha ma lohumunowe. Holi mino. Aliga ya olufoka houmakau minageto ya hipaka hedananibo ya huliya Yesu ne, loto molo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Emo ya huliyagi we minanaibo ya akaisa nebo we Hipala ne, loti lanabo ne. Ido Wenaba Gotikafo awalafo holofala Defiti hiyaba we ononalama munogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ido Yekopu yufa fibo wenina hiyabatina we wehudi minowa-minowa oto minoto hiyaba omo yonaibo ya ma huladámanaibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lomuito, Maliakafo ha liwila oto feto loto lomuibo, Nemo we makafo li uno nedámito minoboma nenako, ha lanibo ya igaida oto gedanaiye? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Loga o edaito, enisolekafo ha liwila oto feto loto lomuibo, Weuna Felekafo hemodoka ageto ya akaisa nebo we aubala yakafo hamamuna yaidana oto li fito hedanogolainako, olufoka hedananibo ya Gotikafo fele ne, loto ido Hipane ne, loto lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ido yako minámiye. Weninaka Elisabeti wena kilofo molotaibo ya heni-wena ne, loti lo edaboma nefa, onesa hipala houmalau nebo ya iganala sikisi (6) ya utaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yagunu Goti yakafo idafa-adafa muki feto feyanaibo ya moda ogofunaibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Feto loto lomuito, Maliakafo ha liwila oto feto loto lomuibo, Nemo Wenaba houba-nabala olu minobo ya wa nedane. Yagunu ha lanibo ya feto fe nedanaiye, loto lito ya enisolekafo fulo edoito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ena hamena yalo ya Malia sinoito obulalo Yuda wenina numunatina meya yalo aloko uto ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","fedoto Sekalaiya numunalau yoto ya, Dowae, loto Elisabeti lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Feto loto lomuito, Elisabeti holibo hamenalo ayalo ya houmalau olufola nebo ya sato molaito, Weuna Felekafo Elisabeti lula-halau faitoto mino edaito ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabetikafo su aubawagi feto loto fibo, Aiyo, wenao, wenipa muki yauti hemo Gotikafo wa hedoto li dowa lo hedaibo ne. Ido olufoka houmakau nebo hedananibo yagi li dowa lo edanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ido Wenabane olafokafo nemo minodo anibo ya nemo aifa wena ma minonako, neidafaito loto feto fe nedane? ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yagunu holiyo. Hemo siyane, loto lonomanibo ya noka fefeluma holiyodo ayalo ya houmaneu olufone ake ito sato molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ido hemo Wenabalokati ha lohumibo ha ya hulawa anaiye, loto holi hikito muwanibo wena ya moda dowa ake i-i anibo ne, loto Elisabetikafo feto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ena Maliakafo feto loto libo, Neimo weune-lune-hane yakafo Wenaba huliya li faka loto ebola lo minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ido Goti ya li nomune waibo we nenako, yagunu weuneu ya ake i-i minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nemo ya aifa idafa houba-nabala olu efoma ya minofa, ido wa nedo dowa molainako, yagunu onesa meloti wenina muki hofawa minabogi ido oloto pinabogi yasi nemogunu holiti ya wenawa dowa holi minomo unaibo mona ya Gotikafo muiye, loti lo-lo o nedanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Aubafofo yawala yakafo idafa naba nemodoka li oloto pito, huliya fele nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wenina muki hofawa minabogi ido aliga oloto pinabogi ya wewa holiya holinado milumatina holi-holi anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ido wewa anagunu auba ibo onona lito ya wenina weudina-lutina-hatinau eimotina hulitina li faka labo wenina ya li upato betito uwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hulitinagi wenina minoti wenina hiyaba o betiyabo we ya hulitina li waka o betito, ido hulitina minámibo wenina efo yako ya hulitina li faka lo betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ido inagunu fuliyabo wenina ya idafa dowa bito houmatina aifa, ido idafa wa nabo wenina ya emodokati idipi molaito, adinau idafa ma liyámoti uwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Isilaeli wenina houba-nabala wenina minonibo ya ade li faka loto milumate holibo ya minowa-minowa oto hala molámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Feito milumate holito Abalahamu yagi, yufa fibo weninala yagi ha lo molo ledaibo yagunu u ayalo ibo ya minowa-minowa oto nebo ne, loto feto libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ena igana loitigi-makogi (3) yalo Malia ya Elisabetite maina minoti eimola numunalaloka liwila oto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ena Elisabeti hamenala aito ya hipala hedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hipala hedaito, selo keloti minabo wenina, ido weninala malekama minabo holiti ya, Aiyo, Wenabakafo milumala naba-naba holibo mona emodoka li oloto piye, loti emogi ake naba iyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ena yaloti fo hamena eiti (8) wito yalo ya hipa ulau Goti anela fukanune, loti nuba oti melafo Sekalaiya huliyalo abalafo ne, loti molanune, loti lafa, ido ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","olafokafo libo, E'e, huliya Yoni ne, loti molalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lobito, emotinasi ha liwila oti feto loti lomuwabo, Aiyo, weninatina yauti ma hulitina yaidana ma minámima ne, loti ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","melafo Sekalaiya ya mebe-maba oti hipala huliya molanaibo yagunu loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Loga o edato, emokafo lufuwa inaibo idafa numunae, loto mebe-maba aito liti muwato, Huliya ya Yoni ne, loto lufuwa ito ya hatina abi kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ido ayalo wela huluma li hotito ha loto Goti ebola liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ido selo keloti minabo wenina muki ya wetina lauwa opaiye. Ido Yudia eba naba obulalo-obulalo yalo idafawa yagunu loyolalo-melo omo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Feto fe minabo ya hawa holiyabo wenina muki yasi lutinau holiyabo ya Wenaba aubala mino edaibo ne, loti holiyabo yagunu feto loti labo, Hipa yakafo naba lito igaida we minanaiye? loti feto lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ido melafo Sekalaiya ya Weuna Felekafo lulau mino faitito ya Goti welaloti ha feto loto ya libo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Wenaba ya Isilaeli wenina Gotite ebola lokelo. Emokafo ya weninalaloka loto meina fi ledoto nalauti wina ledaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Feto fe ledoto houba-nabala we Defiti yufa fibo yauti li nomude wanaibo we auba ibo we ya li oloto pi ledaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Feto fe ladanowe, loto eimola hala ya aidenati polofetila fele we wetinau ya molaito feto loti labo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Goti yakafo li nomudina wanowe, loto uwotefo-mota adinau yauti, ido wenina lutina-hatinau nosámibo holi lumunabo adinau yauti li nomude wanaibo ne, loti labo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Feito Gotikafo awatefo holofate-mota ya milumatina holito, emogi li hutifina ledaibo hala fele nebo ya hala molámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gotikafo awatefo Abalahamu ya auba ito lo gedibo hawa ya feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Uwotinafo-mota adinaloti li nomudina wa oto holitina holámoti, huline li faka loti lutina-hatina numuti, mikalo minabo hamenalo yalo mona fefe lotiko molanabo ya fele wenina mino-mino anae, loto lo molaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ido heimo, olufone ya hemogunu akaisa nebo we polofetilae, loti lanabo ne. Hemokafo Wenaba moninaibo hanu ya wili edanowe, loto homu molanane. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Homu molananibo ya Wenaba lifimate hilili o ledoto li nomude wanaiye, loto weninala lobi-lobi anogolane. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Feito Gotite weuna-lula-halau yau milumate holibo ya fo yaidana oto lamena lumunaibo we ya okulumalo akaisati lemodoka ya ilifi molanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wewa yakafo lemo wenina midipu igu minoto fulinubo hamena yagunu holi holiyonibo ya lamena o ledoto, you amena mona ya api lilibinaiye, loto ilifi molaiye, loto Sekalaiya libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ido hipawa naba lito, weuna-lula-hala ya auba ibo yoito, uto hafali mikau yau minomo uto, aliga Isilaeli wenina nomudinalo oloto pi betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ena Yoni namuna nebo hamena yalo ya Lomu mikalo hiyaba we wehudi Sisa Ogasitusi welaloti ha ma feto loto lo molaibo, wenina mikau-mikau minabo Lomu gamanikafo hiyaba aibo wenina ya hulitina lufuwa iyalo, loto lo molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Feto loto lo molaibo ya Silia ebalo we naba Kuiliniusi yakafo wenina hiyaba o betibo hamenala yalo hulitina iyabo ononawa yaidana homu ma liyámabo nefa, ido aya hamenalo yati apiti ononawa liti hulitina iyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hulitina iyato, wenina muki hulite inae, loti eimotina numunatina meya yaloko uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Uwato, Defiti yufa fibo we ma Yosefe ya ayaida oto Galili ebalo numuna meya Nasalete yalo minaibo yaloti Yudia ebalo Defiti numunala meya Betelehemu yalo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uto ya wa molo edabo olu Malia olufola mulunau nebo yagi maina hulite inae, loti uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Uti yalo ya minaito, olufola hedanaibo hamenala aito hedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hedaifa, ido wenina numuna meyalo ya liti linako, numugu eba ma minámito, hana hipala hedaibo ya lafo-lafogunu wase ito bulumakau wela-idafa molabo ebau yau uno edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ido eba ayalo ya wenina ma lubuka yalo suwa fafato ma sipisipitina hiyaba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hiyaba oti minato, Wenaba enisolela makafo haita oloto pi bito, Wenaba lamenala yakafo lamena o beti fulitaito, holi naba-naba biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Holi naba-naba bito, enisolemakafo feto loto lobibo, Hemotina holi biyámaneyo. Nemo wenina muki dowa holiti ake naba-naba inabo idafa oloto pi bibo ya hawa ukuwa dowa lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Eletifo ya Defiti numuna meyalo yalo ya li nomudina wanaibo we ya hemotinagunu oto hedaiye. Emo ya Gotikafo ilifi molaibo we Kilisto minoto ya Wenaba ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nebo ya wa edanabo mebe-mabala ya feito ne. Hipa namunama lafo-lafogunu wase iyabo ya bulumakau wela-idafa molabo ebau yau uno minanaibo ya hemotina wa edanabo ya uti li oloto pinigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Feto loto lobito, ayalo Goti okulumau himiwela enisole nuba naba-naba oloto piti ya homu aibo wema li keloti ya Goti ebola feto loti labo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Yoisau okulumau minabo ya Goti lamena huliya ya li faka lomo yowae. Ido wenina Goti dowa wa betibo wenina mikaleka minabo ya you amena mona ya oloto pi betiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ena enisole yasi fulo betiti okulumau yowato, sipisipi hiyaba abo we yasi feto loti loyolalo-melo abo, Betelehemu numudo uto ya Wenaba welaloti lo oloto lumibo idafa ya hulawa wanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Feto loti loyolalo-melo oti aloko uti Maliate Yosefete hipa namuna bulumakau wela-idafa molabo ebau yau uno nebo ya li oloto pi betiti ya wa minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wa betiti uti ya hipa hefola hala ukuwa yagunu lobito, hawa holiyaboma ya lo oloto molomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lo oloto molato, wetinauti hawa holiyabo wenina muki holiti, elegiti muludina yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ido Malia ya idafawa muki yagunu lula-halau ya metolito holito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ido sipisipi hiyaba abo we ya ononatinalo liwila oti uti, idafa-adafa muki holiyabo idafa yamagi, ido wa edabo idafa yamagunugi Goti huliya li faka loti ebola lo-lo minae. Idafa-adafa muki lobidoma ya moda ibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ena hipawa oloto pito neto, fo hamena eiti (8) wito ya ulau Goti anela fukanabo hamenalo ya huliya Yesu ne, loti molabo ne. Ya huliyawa ya homu Malia houmalau olufola minámito enisolekafo lomuibo huliya yama molae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ena Wenaba lo molaibo ha Mosesekafo lufuwa i molaibo ha yalo ya li meyalo moloti li hiluwa lanaibo hamena alili aito ya hipawa ilimiti Wenaba nomunalo li oloto piti ya sokila hi munoiye, loti ya Yelusalemuka yowaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Feto aibo ya Wenaba lo molaibo ha lufuwa igu feto libo, Hana olufotina hipatina oloto piyatoma, Wenaba fele we wa molo edalo, loto ha mono lufuwau (Kis 13:2, 12,15) nebo ha meyalo moloti feto fe edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ido ha ma ya feito nebo, Nama mulu loitifemo, ido nama mulu mofola loitife ya liti uti hofoto hinaiye, loti sokila hi munaibo we ya munae, loto ha mono lufuwau (Wkp 12:8) nebo ha holiti yagi liti uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ena Yelusalemuka we ma nebo huliya Simeyoni ya mona fefe libo moloto, mono li hiki lo minoto, Isilaeli wenina lutina-weudina li you lo betinaibo hamena oloto pinaiye, loto hiyaba o ne. Feto fe neto ya Weuna Fele lulau mino edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mino edoto ha feto loto lo oloto muibo, Hemo fuliyámageto Wenaba ilifinaibo we Kilisto oloto piyageto wa edanogolane, loto lo oloto muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ena Weunakafo ilimito fele huliyagi numuna naba hilala yau yoiye. Yoito, hipa namuna Yesu olafote melafote yasi ilimiti uti ya Goti lo molaibo hala yamalo li meyalo molo edanoiye, loti ayau yowaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yowaito Simeyonikafo hipawa namuna lito abusa ito Goti ebola feto loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","Wenabao, onesa meleka ya hemo li nomude wanaibo we ya wenina mikau-mikau minonibo wenina muki nomudelo li oloto piyanibo ya nomune hulagunu wa edowe. Wa edonako, houba-nabaka we nemo ha lo molo nedoto ya moda meyalo molotaninako, yagunu dowa loto holito fulinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Emokafo ya eito feka wenina ha ona hula li oloto pi betinowe, loto sutina lamena o betiyageto ya emodokati Isilaeli weninaka hulitina ya faka lanaiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ido hipawa yagunu hawa feto lito ya olafo melafo holiti elegi minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Feto o minaito, Simeyonikafo Goti li dowa lo betinaibo ne, loto emogunu holito Goti lomuiye. Goti lomutoto ya hipawa olafo Malia feto loto lomuibo, Ena ha ma lohomowe. Gotikafo feto loto holibo, Hipawa yamo Isilaeli minabo wenina malekama ya li lumu fou lo betito, ido malekama ya li faka lo betinaiye. Ido emo ya Goti holibo idafa itibinaibo we minageto wenina muki ha nosámibo lo edanabo ne, loto weuna fi edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Feito weuna fi edaibo ya wenina muki ha lutina-hatinau nebo ha ya li oloto pinogolaiye, loto ya feto fe edanaibo ne. Ido hemo luka-hakau ya mikafo fukaito ogofu aibo yaidana oto miluma nosámibo holinanibo ogofu oloto pi humunogolaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ena polofeti wena ma nebo huliya Ana ya Aseli yufa figuti we Fanuweli oluwa ya ne. Ena wenawa ya olu nedoti we uto keloto minaibo ya melege seweni (7) yaidana wibo wena wanafo fulito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wena-hiyona minomo yoibo melegela eiti-fo (84) ya li fulitoto wena kilofo molaiye. Ena wenawa mabuli yakafo ya fele huliyagi numuna nabau yau hamena-hamena yauko minoto, leda lunaga Goti lomutoko minoto, hamena ma wela-idafa moi ito minoto Goti lomutoko ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aya hamenalo ya wenawa yakafo olafo melafo minado lo fedoto, Goti ebola lomuto, uto Yelusalemu wenina wina betinaibo hamena hiyaba o minabo wenina muki ya hipawa yagunu lobi-lobi aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ena olafote melafote Wenaba lo molaibo ha yama meyalo molo hulo iti ya liwila oti Galili mikalo uti, eimotina numunatina meya Nasalete yalo uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uti yalo minaito hipawama auba ito ha mananau faitito ya Goti aifa li dowa lo ledaibo monala mino edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ena melegelo-melegelo Goti Uta O Betibo folilo yalo olafote melafote ya Yelusalemu numudo yoi-yoi aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Feto fe-fe minaito ya hipawama melegela tuwelu (12) ya li fulaito, foli monawa meyalo moloti ya yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yoti minato, foli hamena hulito ya hipa Yesu Yelusalemuka nebo ya olafote melafote holámoti, fulo edoiti liwila oti uti uti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","aliga ya hatina kiyaibo, Maina onibo wenina magi moda homu wife? loti hatina kiti, uti uti fo hamena mako ya li fulitoti hanudo weninatina loga-miga oti moni witala omo uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Moni witala omo uwaifa, ido li oloto pi edámoti fulitoti hofa Yelusalemuka liwila oti witala omo yowaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Moni witala omo yowaito, fo hamena loitigi-makogi utaito, fele huliyagi numuna nabau yau li oloto piye. Li oloto piti wa edaibo ya emokafo mono api itibiyabo we minagu yau minoto, ha labo ya holito loga-miga o beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Feito loga-miga o betito, holifefe libo hala yagi ido ha liwila oto lobibo hala yagi muki ya holiyabo yagunu elegiyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Feto fe minato, olafote melafote ya wa edoti weudina wito olafokafo feto loto lomuibo, Hipane, hemo neidafaito feto fe ledane? Mekafote lute-hateu ogofu naba-naba holito witaka o minoibo ya ma wagámabe? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lomuito, emokafo ha liwila oto feto loto lobibo, Aiyo, wenao, hemotina ya nedafaito nemo witane aiye? Nemo Menefo numunalau minobo ya fefe loto minowe. Yama holiyámaife? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ido lobibo hawa ya holiti holifefe ladámaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Feto feti emotinagi maina Nasalete numudo liwila oti lumuti, yalo ya olafo melafo ha laibo ha ya holito meyalo molo ne. Meyalo molo neto, olafo ya idafawa muki yagunu lula-halau ya metolito holito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ido Yesu ya naba lito, ha mananau onu ito naba nebo ya Gotigi ido weninagi maina wa edo dowa molomo yowabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ena Lomu wenina mikau-mikau muki hiyabatina wehudi Taibeliyasi Sisa hiyaba omo yoibo ya melege fifitini (15) utaito hamena yalo ya Pontiusi Pailatikafo ya Yudia mikalo minabo wenina hiyaba o beti ne. Ido Helotikafo ya Galili minabo wenina hiyaba o beti ne. Ido Heloti yalafo Filipikafo ya Itulia ido Tilakonitisi eba loiti ya hiyaba o beti ne. Ido Abilene ebalo ya Lisaniyasikafo ya hiyaba o beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gamani hiyabatina wewa feti minomo uwato, ido Goti sokila hi muwabo we hiyabatina we wenabatina hulitina ya Anasite ido Kaiyafasite ya mono onona liyaibo ne. Ido aya hamena yalo ya Sekalaiya hipala Yoni ya mika hafali mikalo neto, emodoka Goti hala ya lo fedoto mino edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Feito Yonikafo no naba Yodani meleka, yolaleka monito ha feto lobibo, Hemotina Gotikafo lifimate hilili o ledanaiye, loti lutina-hatina li elepa inabo ya nemo noku i betinogolowe, loto lo oloto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yagunu polofeti Aisaiyakafo ha mono lufuwau ya feto libo, Hafali mikau yalo we ya welauti ha auba ito feto loto lo oloto molanaibo, Wenaba moninaibo hanula ya lifefe loti wili edalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Obula ebalo ha muki ya guniti li faitalo. Ido obula naba-naba muki yoibo lumibo ya eba muki lumuto yoto aibo ya li hunomu alo. Ido hanu losa aibo ya lifefe lalo. Ido hanu nosámibo ya li dowa loti lifefe lalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Feto ato, wenina muki mikau-mikau ya Goti li nomuna wanaibo mona ya wanigilae, loto lo minanaiye, loto ha mono lufuwau (Ais 40:3-5) nebo ha yama Yonidoka gedibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ido wenina nuba naba ya mono noku i ledanaibo ne, loti Yoni nedo ato, emokafo feto loto lobibo, Hemotina hosofa olufola minabo, ha naba oloto pi lumutanaiye, loti holi holiti wilo, loto hemakafo fuka ha lobito ya ae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yagunu hemotina lutina-hatina li elepa iyabo wenina yaidako mona hula li oloto pilo. Ido Abalahamu yufa fibo weninama minoninako, Gotikafo dowa wa ledaibo ne, loti holiyámilo. Yagunu nemo ha ma lobiyowe. Gotikafo hefana-afana yakafo Abalahamu ouwamela-mota lifefe lanowe, lanaibo aifa lifefe lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ido onesa me ya ya lona ya yá monalo molaibo ne. Yagunu yá ma ilawa dowa iyámanaibo yá muki monalo lufawalo fukoto soku hinogolaiye loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lobito, wenina nuba minabo ya, Aiyo, feto feyanaibo neidafa feyanune? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Loga o edato, emokafo feto loto lobibo, Wenina masi utinalo owo loiti wa nanabo ya hona moloti, we ma ulalo owo wa námanaibo ma ya muilo. Ido wetina-idafa wa nanabo ya ayaidana feyalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lobito, hefana takisi li-li abo we yagi ayaidana oti mono noku i ledanaiye, loti ya emodoka loti, loga o edoti labo, Api lilibiyanibo we, lemo yagi neidafa feyanune? lato ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","liwila oto feto loto lobibo, Wenina hefana takisi feti molanae, loto lo molaibo halo ya hefana takisi ma homi iti ugele liyámilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Lobito, himiwe malekamagi ayaidana oti ya, Ena lemo yagi neidafa feyanune? loti loga o edato, feto loto lobibo, Hemotina hefanatina ipoti linune, loti, ido sugi-namagi ha loti, sigiya-magiya ha sugi-idafa oti lobiyámilo. Moda onona meinatina liyabo ya moda dowa ne, loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Feto loto lobito, wenina muki holiti idafa ma hiyaba o minabo ya Yoni ya Gotidokati ilifi molaibo we Kilisto nefemo? loti lutina-hatina loiti-loiti ki minato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yonikafo ha liwila oto feto lobibo, Neimone ya no yakafoko noku i beti-beti feyofa, ido we ma aubalakafo li fulo nedaibo we ya anaibo ne. Nemo efo ya emo yaidana we ya minámonako, hinalo idafala li fulo edanobo ya fefe ladámanogolaiye. Anaibo wewa ya Weuna Fele ido so yakafo ya noku i betinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ido emo ya suwa witi lilika inaibo ebala ya fefe loto hililito hula ya li nuba oto numugu molanofa, ido mouta idafa ya so fiyámanaibo soku hinogolowe, loto anau ya lilika inaibo idafala li ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Feito ya api itibibo ha ma muki ya lito Goti hala ukuwa dowa ya wenina lo oloto biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ena Yonikafo wenina hiyaba o betibo wenabatina Heloti monala nosa naba ámibo yagunu hanu muiye. Wewa yakafo yalafo olonafo Helotiyasi ya ika oto wena lito, ido nosámibo mona malekama muki yagi o moloto, ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ido mulalo onu ito Yoni yagi nala numugu fulo edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ena (homu nala numugu ámibo hamenalo ya) wenina muki Yonidoka uwato, mono noku i betibo hamenalo ya Yesu ayaidana oto wito, noku i edaito, Yesukafo Goti lomu minoto okuluma eya lito ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Weuna Felekafo nama mulu yaidana hilibo emodoka lumiye. Lumito, ya okulumauti nola ma holiyabo feto libo, Hipane lune-hane homobo we minanibo ya dowa ona wa hedowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ena Yesu melegela teti (30) yaidana oto li fuloto ya mono ononala apiye. Ido wenina yasi melafo Yosefe ya ne, loti hatina ki minae. Ido Yosefe melafo Heli ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ido Heli melafo Matati ya ne. Ido Matati melafo Lifai ya ne. Ido Lifai melafo Meliki ya ne. Ido Meliki melafo Yanai ya ne. Ido Yanai melafo Yosefe ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ido Yosefe melafo Matatiasi ya ne. Ido Matatiasi melafo Amosi ya ne. Ido Amosi melafo Nahamu ya ne. Ido Nahamu melafo Esili ya ne. Ido Esili melafo Nagai Ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ido Nagai melafo Mati ya ne. Ido Mati melafo Matatiasi ya ne. Ido Matatiasi melafo Semeni ya ne. Ido Semeni melafo Yoseke ya ne. Ido Yoseke melafo Yoda ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ido Yoda melafo Yowanani ya ne. Ido Yowanani melafo Lesa ya ne. Ido Lesa melafo Selubabeli ya ne. Ido Selubabeli melafo Sealitiyeli ya ne. Ido Sealitiyeli melafo Neli ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ido Neli melafo Meliki ya ne. Ido Meliki melafo Adi ya ne. Ido Adi melafo Kosamu ya ne. Ido Kosamu melafo Elimadamu ya ne. Ido Elimadamu melafo Eli Ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ido Eli melafo Yosuwa ya ne. Ido Yosuwa melafo Eliyeseli ya ne. Ido Eliyeseli melafo Yolimu ya ne. Ido Yolimu melafo Matati ya ne. Ido Matati melafo Lifai ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ido Lifai melafo Simeyoni ya ne. Ido Simeyoni melafo Yuda ya ne. Ido Yuda melafo Yosefe ya ne. Ido Yosefe melafo Yonamu ya ne. Ido Yonamu melafo Eliyakimu ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ido Eliyakimu melafo Melea ya ne. Ido Melea melafo Mena ya ne. Ido Mena melafo Matata ya ne. Ido Matata melafo Natani ya ne. Ido Natani melafo Defiti ya Ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ido Defiti melafo Yesi ya ne. Ido Yesi melafo Obeti ya ne. Ido Obeti melafo Bowasi ya ne. Ido Bowasi melafo Salimoni ya ne. Ido Salimoni melafo Nasoni ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ido Nasoni melafo Aminadapu ya ne. Ido Aminadapu melafo Atimini ya ne. Ido Atimini melafo Alani ya ne. Ido Alani melafo Hesiloni ya ne. Ido Hesiloni melafo Pelesi ya ne. Ido Pelesi melafo Yuda ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ido Yuda melafo Yekopu ya ne. Ido Yekopu melafo Aisaka ya ne. Ido Aisaka melafo Abalahamu ya ne. Ido Abalahamu melafo Tela ya ne. Ido Tela melafo Naholi ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ido Naholi melafo Seluku ya ne. Ido Seluku melafo Leu ya ne. Ido Leu melafo Peleki ya ne. Ido Peleki melafo Ebeli ya ne. Ido Ebeli melafo Sela ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ido Sela melafo Kainani ya ne. Ido Kainani melafo Alipakisati ya ne. Ido Alipakisati melafo Semu ya ne. Ido Semu melafo Nowa ya ne. Ido Nowa melafo Lameki ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ido Lameki melafo Metusela ya ne. Ido Metusela melafo Enoku ya ne. Ido Enoku melafo Yaleti ya ne. Ido Yaleti melafo Mahalaleli ya ne. Ido Mahalaleli melafo Kenani ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ido Kenani melafo Enosi ya ne. Ido Enosi melafo Seti ya ne. Ido Seti melafo Adamu ya ne. Ido Adamu melafo Goti ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ena Yesu ya Weuna Felekafo lulau mino faito edaito, Yodani no nabaloti liwila oto Weunakafo ilimito u mika hameto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uto yalo ya fo hamena foti (40) ya unoto sinoito neto, Satanikafo hepa molo edo-edo o ne. Ido aya hamenawa yau ya Yesu wela-idafa námoto minomo yoito, hamenawa ya hulito inagunu fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Inagunu fulito, Satanikafo feto loto lomuibo, Ena, hemo Goti Hipalama minotoma, hefana me ya nebo ya lomuwageto weka-idafa oloto piyaneyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lomuito, Yesukafo ha liwila oto feto loto lomuibo, Wenina mino holinabo ya wetina-idafa nanabo yako minámiye, loto ha mono lufuwau (Lo 8:3) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Feto loto lomuito ya Satanikafo ilimito yoto wenina mikau-mikau hiyabatina we hudi hiyaba o betiyabo ebatina muki ya haita ilibi huliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ilibi huloto ya feto loto lomuibo, Ena ebawa muki yagi, ido hulitina ukutina-hatina mino betibo yagi ya hemo humu hulanogolowe. Idafawa muki numutaito, litobo ya we ma munowe, loto holinobo ya aifa munogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yagunu huline li faka loto weuga-luka-haka nomagetoma, idafawa muki ya hemo idafaka anaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Feto loto lomuito, Yesukafo ha liwila oto feto loto lomuibo, Ena ha ma feto libo, Wenaba Gotitina huliya li faka loti weudina-lutina-hatina muti, eimolako houba-naba o edalo, loto ha mono lufuwau (Lo 6:13) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Feto loto lomuito, Satanikafo ilimito Yelusalemu uto fele huliyagi numuna naba holalo fulo edoto ya feto loto lomuibo, Hemo Goti Hipalama minotoma, meloti sato moloto mikalo youma iyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ha mono lufuwau ya feto libo, Hemogunu ya enisolela lobiyageto, hiyaba o hedoti ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","higa ya hefanagunu hofotanaiye, loti ya adina mulalo li faka lo hedanigilae, loto ha mono lufuwau (Sng 91:11-12) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Feto loto lomuito, Yesukafo ha liwila oto feto loto lomuibo, Ena ha ma libo, Wenaba Gotitina ya hepa molo umámilo, loto ha mono lufuwau (Lo 6:16) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Feto loto lomuito, Satanikafo hepa molo muibo ha muki lo fulitoto ya emodokati uto hamena malo ne, loto hiyaba o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ena Yesu ya Weuna Fele aubala mino edaito, Galili mikalo liwila oto wiye. Liwila oto uto hala ukuwa numudo-namado Galili selo nebo numudo ya u huliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Feito yalo ya mono numunatinau negu-negu ha mono api itibito, holiti ebola lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Feito monimo uto Nasalete numudo eimola hipa hefola minoto u naba libo numudo Sabati foliku mono numugu yoi-yoi aibo yamaidana yoiye. Yoito mono lufuwa hito binowe, loto sinoito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","polofeti Aisaiya lufuwa ibo lolokuto ya li muwae. Li muwato ataloto ha ma li oloto pibo hawa ya feto loto nebo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wenaba Weunakafo idafa wa námoti minabo wenina hala ukuwa dowa lo oloto biyo, loto mino nedaibo ne. Mino nedoto ya feto loto lonumibo, Uto ya nala i betiyabo wenina ya nala yauti wina betiyageto minanae, loto feito lo oloto biyo. Ido nomudina likaibo wenina ya nomudina hofa falatageto wanae, loto lo oloto biyo. Ido uwotinafo-mota yasi li nosámibo o beti minabo wenina ya wina betiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ido Wenaba li dowa lo betinaibo hamena ya moda alili aiye, loto lo oloto biyo, loto feto loto lonumuto nilifi molaibo ne, loto ha mono lufuwau (Ais 61:1-2) nebo ha ya hito biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hawa ya hitoto lufuwa ya lolokuto, hiyaba we li muto, amedoto ne. Amedoto neto ya wenina mono numugu minabo wenina muki emodoka wenu wa edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wenu wa edato, ha apito lobibo, Mono hawa hitobo me ya ya eletifo hemotina hatina holiyado ya moda hulawa oloto pibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Feto lobito, emotina yasi ha dowa lo edato, welauti ya aifa li dowa lo ledaibo ha libo ya dowa holiti muludina yoito, feto loti lo minabo, Aiyo, emo Yosefe hipala nefe? Olo, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Feto lo minato, emokafo feto loto lobibo, Hemotina ya ha ma lo-lo abo ha ya feto loti lonumunabo, Lusa we, hemo lusa hi beti-beti anibo yamaidana oto heimokagunu hiyo. Aubaka Kapeneyamu numudo itibiyanibo yagunu holiyonibo aya aubakawa yama melo heimo numunakalo yagi lilibiyageto wanune, loti lonumunigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yagunu nemo ha ona lobiyowe. Polofeti ya eimola numunala melo yako weninala yasi huliya li faka ladámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ido ha ma ona lobiyowe. Elaiya hamenalalo ya melege tili hafugi (3 1/2) yalo ho iyámito, inagunu naba-naba mikau-mikau oloto pito huloto nebo hamenalo ya Isilaeli mikalo ya wena-hiyona muki minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Feti minafa, aya wena-hiyona muki minado Gotikafo Elaiya ilifi molámiye. E'e, eito wenina Saidoni mikalo Salefata numudo wena-hiyona mako ma nedoka yako ilifito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ena Polofeti Elisa nebo hamenalalo ya Isilaeli mikalo ya okola i hiliyabo wenina muki minagu yauti Gotikafo ma holuto betiyámifa, eito Silia mikaloti we Namani yako holuto edaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Feto loto lobito, mono numugu minabo wenina muki holiti ya sebatina hala-kala naba-naba lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ya sinoiti uti numudo yati ilifi feka itifu-natifu oti, numuna meya obulalo holalo ilimiti yoti, fulo edogeto lumunaiye, loti lowa anawaleka ilimiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Feto fe edafa, emokafo minagu ya felele kito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ena lumuto Galili mikalo numuna ma Kapeneyamu yalo fedoto, Sabati foliku ya ha mono api itibi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Api itibibo ya ha mono hula yawalakafo api itibinako, holiti elegiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ido mono numugu yau we ma Satani himiwela ma mino edaibo we ma nebo yakafo Yesu wa edoto, hai naba moloto feto loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Yae, Nasalete numudoti we Yesuwo, neidafa fe ledanogolo ane? Li hopa o ledanogolo abe? Hemo Gotidokati Fele we ya minanibo ya nemo wa hedofefe lowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Feto lito, Yesukafo feto loto lo fuko edoto libo, Hemo ha hedámoto wewa ya fulo edoto yoto uwo, lito Satani himiwela wenina nomudinalo wewa mikalo li lumu fou lo edoto, lula-halauti feka loto wiye. Feto fe edoto wewa ula li hopa o edámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ido wenina muki wetina lauwa opaitaito, loyolalo-melo oti feto loti labo, Aiyo, ha me ya ya nena hama ne? Emo auba yawala yaidana oto aubala naba nebo wekafo ya Satani himiwela ya ha lobito, yoti u-u abo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Feto lato, aya ebawa yau hala ukuwa numudo-namado upatoto wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ena Yesu mono numuguti lumuto Saimoni numunalau yoito, ayau Saimoni ola-kilofo wena idafa i hilito ula hala-kala libo ha ya holiti Yesu lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lomuwato, emodoka loto yalo sinoi minoto, ya ula hala-kala liboma lo fuko edaito, ya fulo edoito wito, ayalo ya wenawamakafo sinoito wetina idafa hofo hi betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ena fo sapinogolaito wenina muki weninatina idafa eito-eito i hiliyabo ya Yesudoka idipiti ato, ya muki utinalo anagunu lito li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Feto fe betibo yako minámiye. Wenina malekama lutina-hatinau yauti Satani himiwela yoti hai naba moloti ya, hemo Goti Hipala minane, loti lae. Feto labo, ya emo Goti ilifi molaibo we Kilisto ne, loti holiyabo yagunu ya emokafo, Ha hedámilo, loto lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ena ho lito Yesu numudokati lumuto, wenina minámabo eba yalo uto ne. Neto, wenina witala edoti ya wa edoti emodoka loti feto lomuwabo, Lemo fulo ledoito aguwámo, loti ika o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ika o edafa, emokafo feto loto lobibo, Goti wehudi weninala hiyaba o ledaibo hala ukuwa dowa ya wenina numudo-namado minabo yagi ya lobiyo, loto nilifi molainako, uto lo oloto binogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Feto loto Yudia mikalo mono numunatina minomo wigu yau monito mono lobimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ena hamena ma ya Yesu Genesalete momeno anawalo sinoi neto, wenina nuba naba ya Goti hala holinune, loti li lulau o edo minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Li lulau o edo minato, emo ya sipi loiti momeno anawalo waito laefa li-li abo we ya sipiku minámoti laefa li-li abo owotina noku iti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Minato, emo ya sipi ma, Saimoni sipilau ya yoto feto lomuibo, Sipika ya no sesepalo nedo yaloti hefolama itifuo, loto lomu itoto ya sipi ayau amedoto ha mono api itibimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Api itibimo uto huloto Yesu ya Saimoni feto loto lomuibo, Laefa linune, loti momeno lusaku uti otina ya noku fulalo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Feto loto lomuito, Saimonikafo liwila oto lomuibo, Api lilibiyanibo weyo, lemo ya moda lubuka onona naba lito monimo uto molomo uwoba-uwoba, ido laefa ya liyámonibo ne. Nefa, hemo wekalo hofa molanowe, lito uti ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ya otina fuloti laefa ya abi loti ika ato, owo fukanowe, loto aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Feto fe minoti, onona mako liyabo we ma sipi nuba minabo ya, hemotina loti ade li faka lalo, loti adina mebe-maba ato ya maina laefa liyabo sipi loiti faitoto li yoima itanowe, loto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Feto fe minato, Saimoni Pitakafo idafawa wa edoto ya Yesu hinalo hina obula fito feto lomuibo, Aiyo, Wenabao, nemo lifima nebo we ma minowe. Fulo nedoto uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Feto loto lomuibo ya eimolagi ido weninala maina minabo muki yagi laefa muki liyabo yagunu holiti wetina lauwa opaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wetina lauwa opaibo ya Saimonigi onona mako liyabo we Yemusite Yonite, Sebedi hipala loiti ya ayaida oti wetina lauwa gediye. Feto fe minato, Yesukafo Saimoni feto loto lomuibo, Hemo holi homámaneyo. Onesa melokati wenina li-li anane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Feto lito, emo ya sipi ika ato no sesepalo wito ya idafa-adafatina muki fulitoti Yesu ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ena hamena ma Yesu ya numuna meya malo ya neto, we ma okola ulalo muki i hilibo we yakafo loto Yesu wa edoto ya hola-wela mikau fito feto loto wako lo edaibo, Wenabao, hemo feto anowe, loto holinanibo ya okola hiliyobo ya holuto nedo, loto lageto une ya moda holutanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lomuito, Yesukafo ana sino loto wewa ulalo li minoto lomuibo, Feto feyanowe. Okola i hiliyanibo holuto, lito ayalo okola ya fulito edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Feto fe edoto ya feto loto lo fuko edaibo, Hemo hawa ya wenina lobiyámoto, aifa uto sokila hi muibo we ya uka ilibiyageto wanaiye. Wato ya uka holutibo yagunu Mosesekafo ha lo molaiboidana oto idafa muwageto wenina muki yasi okola hiliyaniboma yagunu holutane, loti holinigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Feto loto lomuifa, ido hala ukuwa ya numudo-namado ba loto wito, wenina nuba naba-naba loti hala holiti idafa hiliyonibo li faka lo ledanaiye, loti nuba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nuba oti minafa, ido hamena-hamena Yesu ya u mika huwopa mikalo uto Goti lomu-lomu o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ena hamena ma Yesukafo wenina mono lobi neto Falisi we ido lo molaibo ha api itibiyabo we Galili numudo-namadoti, ido Yudia mikaloti, ido Yelusalemu numudoti muki loti ya wenina minagu amedoti minae. Amedoti minato, Wenaba aubalakafo wenina idafa i hiliyabo li faka lo betibo auba ya Yesugi mino edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mino edaito, ena hebilisibo we ma ya weninalasi hunulo moloti, oti ya numugu liti yoti, Yesu hinalo limo fulanune, loti feyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ido wenina nuba minabo yagunu liti yonabo eba minámito, numuna mulalo liti yoti menefa ya li fuloti wewa hunulo uno nebo fulato, wenina minagu Yesu nomunalo ya lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Feto feyabo ya Yesu holi hikito muwabo monatina wa betito, wewa feto loto lomuibo, Weninane, lifimaka moda hilili otaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Feto lito, Goti lo molaibo ha api itibiyabo we ido Falisi we hawa ya holiti feto loti hatina holiyabo, Aiyo, Goti hamana hibo we ya hemae? Lifima hilili o-o aibo we ya Goti eimolakoma nenako, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Feto loti holi minato, Yesukafo holito ya ha liwila oto feto lobibo, Hemotina ya idafawa yagunu nedafaito ya lutina-hatinau ya hatina ligi-ligi ki minae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ido hebilisito nebo we, lifimaka ya hilili otaibo ne, loto lomunabo hemotina hulawa ya wa edámanako, sugi lifemo, ido ona liye, loti holiyámanigilae. Ido, sinoito moniyo, loto lomuwoto hulawa wa edanabo, sugi lifemo, ido ona liye, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yagunu nemo we Hula mikaleka me ya ya lifimatina hilili o betinobo auba mino nedaibo ya holinigilae, loto hebilisibo we feto lomuibo, Nemo ha lohomowe. Sinoito, hunuka lito numunakaloka uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Feto lomuito, wewa ayalo nomudinalo sinoito idafalo unaibo idafa ya lito, Goti ebola lomo-lomo numunalaloka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Feto feyaito, wenina muki wati hatina abi kiti holi holiti feto labo, Onesa idafa eito ma oloto pito wa one, loti Goti ebola lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ena yaloti ya hanu uto, hefana takisi li-li aibo we ma huliya Lifai ya hefana takisi li-li abo ebalo amedoto nebo ya wa edoto, Nege ano, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","emo ya sinoito idafa-adafala muki fulitoto ege wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ege uto, numunalauka wela-idafa naba-naba hofo hi edoito ya hefana takisi li-li abo we muki ido wenina maleka magi li nuba o betito loti maina nae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Maina no minato, Falisi weninagi ido lo molaibo ha api itibi abo we lusanigu minabo weninagi holi nosámiboti Yesu ege-ege moniyabo we feto loti lobiyabo, Igaidana oti hemotina takisi li-li abo we yagi, ido lifimatina nebo we yagi wetina idafa no minae? loti loga o betiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesukafo holito ha liwila oto feto loto libo, Idafa i hiliyámabo wenina ya lusa numugu ya aguwámafa, ido idafa ona i hiliyabo wenina yako ya lusa numugu ya u-u ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ido nemo obo ya wenina mona fefe liboko molabo wenina ya sutina finowe, loto ámowe. E'e, lifimatina nebo wenina ya sutina fito lutina-hatina ya li elepa iti molalo, loto lobinowe, loto obo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ena emotina yasi feto loti lomuwabo, Yoni ege-ege molabo we ya hamena-hamena wetina idafa moi iti minoti, Goti lomuwabo onona li-li o minama ne. Ido Falisi we egetina molabo wenina yagi ayaidana oti o-o ama ne. Feto o-o ama nefa, ido hemo hege moniyabo we ya wetina-idafa ido no-ano no-no o minae, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ya feto loto lobibo, We ma wena linaibo we ya yolawe weninagi minanaibo hamenalo ya hemotina yasi weninawa wetina idafa moi iti minalo, loti lobinafe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","E'e, feito minámiye. Aliga emotinadokati wena linogolaibo wewa ya ipoti linabo hamena yalo ya wetina idafa moi iti minanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Feto lobito, ido wase ibo ha ma yagi feto loto lobibo, We makafo ulalo owo hofawaloti ma fekalito lilalo hifinaibo we ma minámiye. E'e, feto feyanaibo ya hofawa ya fekalito, ido lilagi hofawagi u mako aguwámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ido makafo no waini hofawa ya meme etuwa lilau yau lekinaibo we ya minámiye. E'e, feto feyanaibo ya no waini hofawakafo meme etuwa ya fokiyageto no waini nogi, ido meme etuwa yagi maina u hopa anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yagunu ya no waini hofawa ya meme etuwa hofawa yauko lekinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ido makafo no waini lila nototo ya hofawa nanowe, loto holinaibo we ya ma minámiye. E'e, lila ya la fuliye, loto holibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ena Sabati foli malo ya suwa witi hifiyagu yau uti, ege-ege moniyabo we ilawa ma doliti adinagunu hululu iti nae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Feto feyato, Falisi we masi wa betiti ya feto loti labo, Sabati foliku ya feto feyámilo, loto lo fukaibo idafa ya nedafaito feto feyae? lato ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ha liwila oto lobibo, Defitigi mako moniyabo weninagi inagunu fuliti idafa abo ha ya mono lufuwau yau hemotina hitoti holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Defiti ya Goti numunalau yoto, beleti Goti nomunalo molo edabo ya lito loto beletiwa noto weninala bito, maina naboma ne. Beletiwa ya wenina aifa wenina námanae, loto lo fukabo idafa ya Goti sokila hi muwabo we eimotina yako no-no abo beleti yama ya Defiti sokila hiyabo we yauti ma minámifa, lito naibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Feto lobito ha ma onu i moloto feto libo, We Hula nemo ya Sabati foli yawala minowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ena Sabati foli malo mono numugu yoto ha mono api itibi nedo yalo we ma ana onaleka galidibo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Feto fe neto, Falisi we yagi, ido lo molaibo ha api itibiyabo we yagi sigiya lo edanune, loti ha ma wita oti, Sabati foliku yau wewa li faka lo edanaifemo, ido li faka lo edámanaiye? loti wenu wa minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wenu wa minafa, Yesukafo lutinau ya wa beti huloto ya wewa ana galidibo ya lomuibo, Hemo wenina nomudinalo ya sinoito mino, loto lomuito, emo sinoito yalo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yalo neto, Yesukafo feto lobibo, Nemo ha ma loga o betinowe. Lo molaibo ha ya Sabati foliku yau li dowa lo betiyalo, loto lifemo, ido li nosámibo o betiyalo, loto liye? Ido wenina li nomudina walo, loto lifemo, ido li hopa o betiyalo, loto liye? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Feto loto loga o betito, li hona oto wa betito ya wewa feto lomuibo, Aga sinolo, loto lito ya ana sino lito hofa dowa liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ana hofa dowa lifa, ido emotina yasi sebatina hala-kala lito, Yesu li yaidana-meidana o edanune, loti ha loyolalo-melo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ena hamena malo ya Yesukafo Goti lomunowe, loto obulalo yoiye. Yoito lubuka ya Goti lomu neto, ho liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ho lito ege molabo wenina sutina fito, ato minagu yati we tuwelu (12) ya haka oto, hulitina naba ya aposolo ne, loto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ido wewa hulitina feito ne. Saimoni huliya hofawa Pita ne, loto molaibo, ido unalafo Adulu, ido Yemusi ido Yoni, ido Filipi, ido Batolomiu, ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ido Matiu, ido Tomasi, ido Alifiusi hipala Yemusi, ido Saimoni huliya ma Seloti ne, loti molabo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ido Yemusi hipala Yudasi, ido abalafo Yudasi Isikaliyoti ya Yesu uwolafo adinalo molaibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesugi emotinagi maina lumuti ya lumu omunalo fedoti yalo ya ege molabo wenina muki ya minae. Minato, wenina nuba naba Yudia mikalo numudo-namadoti, ido Yelusalemu numudoti, ido ho no anawalo Taiya numudo ido Saidoni numudo eba yaloti ya o-o abo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mono lanaibo ya holinune, loti, ido idafa hiliyonibo ya li faka lo ledanaiye, loti ya o-o minae. O-o minato, lutina-hatinau Satani himiwelasi mino betiyabo wenina ya li faka lo beti-beti aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ido emodokati aubala ya uto muki li faka lo beti-beti ainako, wenina nuba naba muki ya adegunu ulalo linune, loti holiti ya ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesukafo wa faka loto ege-ege moniyabo wenina wa betito feto lobibo, Hemotina idafa wa námabo wenina ya okulumau nebo we wehudi weninala hiyaba o ledaibo monala ya moda mino betima nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ido hemotina onesa inagunu fuliti minabo wenina ya houmatina anogolainako, yagunu moda dowa holi minomo uwae. Ido hemotina hamena meleka hufo o minabo wenina hiya anaboma nenako, yagunu moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ido hemotina ya We Hula nemo nege molabo yagunu wenina masi holi nosámibo biti, fulo faiga o betiti, hamadina hiti hulitina li hopaiti anabo yagunu hemotina moda holi dowa loti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Weninawa awatinafo holofatina-mota yasi polofeti ayaida o betiyato, hemotina ya idafa yaidana oloto pi betiyagetoma, okulumalo lifimatina dowa li we fito molo betinako, lutina-hatina dowa loti holiti sato moloti ake ito alo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Feti minanigilafa, ido idafa wa nabo weninao, aiyo, hemotina ya li ake ito o betibo idafatina ya moda litanako, aliga hena ha naba-naba holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ido onesa me ya idafa naba noti houmatina aibo weninao, aiyo, aliga hemotina inagunu fulinigilanako, hena ha naba-naba holinigilae. Ido onesa meleka hiya o minabo weninao, aiyo, aliga hemotina ya miluma holiti hufo nama anigilanako, hena ha naba-naba holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ido hemotina ya wenina muki yasi ebotina loti hulitina ito yoti dowa o betinabo yagunu aiyo, hena ha naba-naba holinigilae. Awatinafo holofatina-mota yasi ayaidana oti ha sugi labo Polofeti ya luwatina loti, lo dowa betiyabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ena ha ma onu ito feto loto lobibo, Ena hemotina hane holiyabo wenina ha ma lobiyowe. Hemotina uwotinafo-mota lutina-hatina bilo. Ido holi nosámibo binabo wenina ya hemotina liwila oti li dowa lo betilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ido wenina masi li hopa o betinune, loti hudawatina hi minanabo weninagunu holiti ya li dowa lo betiyo, loti Goti lomuilo. Ido li hopa o betinabo wenina ya emotinagunu holiti Goti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ena makafo wanaga filigaleka hofanaibo ya filiga yagi hofo nedo, loto wanaga ilibiyo. Ido makafo ukalo owo mulalo iyanibo linaibo ya ukalo owo lulau iyanibo yagi linowe, lanaibo ya, E'e, lomuwámo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ido makafo idafa magunu wako lohumunaibo ya aifa umo. Ido makafo idafaka ipoto linaibo ya liwila oto linowe, loto auba ito lomuwámo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ido wenina masi feitiko o molo ledo-ledo feyanae, loti holinabo ya hemotina yagi mona ayaidana oti molo beti-beti alo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Hemotina ya wenina lutina-hatina bi minabo wenina yako liwila oti lutina-hatina binabo ya igaidana oti meina linae? Mono holiyámabo weninagi ya weninatina lutina-hatina bi minabo wenina ya liwila oti lutina-hatina bi minaboma ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ido hemotina li dowa lo beti minabo wenina yako liwila oti li dowa lo betinabo ya igaidana oto Goti ya ebotina lanaiye? Mono holiyámabo wenina yasi ayaidana oti feto fe minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ido liwila oti binabo wenina yako idafa lifima li bi minanabo hemotina ya igaidana oto Goti ya ebotina lanaiye? Mono holiyámabo wenina yasi weninatina mono holiyámabo wenina ya ayaidana oti muki idafa biyonibo li liwila oti lumunae, loti ya lifima li bi-bi abo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Feto fe minaboma nefa, ido hemotina uwotinafo-mota lutina-hatina biti, mona dowa moloti, ido liwila oti lifima lomámanae, loti holiti ya aifa li bi minalo. Feti minanabo ya lifima dowa we fi betibo ya naba liti yoisa yoto nebo we olufola oti minanigilae. Emo ya wenina emogunu holiyámabo wenina ido lutina gedibo wenina ya aifa li dowa lo beti-beti aibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Metinafokafo wenina milumatina holibo ya hemotina ayaidana oti milumatina holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Hemotina wenina li halo molo betiyámato, Gotikafo moda hemotina li halo molo betiyámanaiye. Ido we ya lifimala ne, loti ladámilo. Feto feyámatoma, Gotikafo moda hemotina lifimatina ne, loto ladámanaiye. Ido weninatina lifimatina hilili o betinabo, Gotikafo hemotina lifimatina hilili o betinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ido idafa binabo, Gotikafo hemotina binaibo ya ito yoto mi ito, nuba naba o betito, fitoto fululu kaito binogolaiye. Idafa bi-bi anabo mona yaidana oto binogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Feito ya wase ibo ha ma feto loto onu ito lobibo, Nomuna likaibo we makafo nomuna likaibo we ma hanu ilibinowe, loto anaibo nefe? E'e, hale nabau loitiwa ya lumu fou lanigilaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ena ege molaibo we yakafo api ilibibo we li yoima o edámibo ne. Feto nefa, api ilibiyageto ya monawa wa hulanaibo yamo api ilibibo we yaidana oto minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ido hounakafo nomunau huwopa hefola efoma nebo ya igaidana oto waba, ido heimoka nomugau yá lana ya wafefe ladámane? ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ido yá lana ya heimoka nomugau nebo wagámanibo hounakafo nomunau huwopa hefola efoma nebo ya igaidana oto li fulo hedanowe, loto lomunanibo ne? Monona loiti iyanibo we, hemo heimoka nomugau yau yá lana nebo ya homu li fulitoto, wafefe loto minototo hounakafo huwopa nomunau nebo ya li fulo edo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Holilo. Yá dowa yamo igaidana oto ilawa nosámibo inaiye? Ido yá nosámibo yamo igaidana oto ilawa dowa ya inaiye? Feto feyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yagunu wenina ya yá ilawa wafefe loti wa edanigilae. Holiyafe? Sigolo ilawa ya agina hasuwalau yauti liyámanigilabo ne. Ido adi ya yá menifa yauti liyámanigilabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","We dowa yakafo idafa dowa weuna-lula-hala neguti ya idafa dowa li oloto piye. Ido we nosámibo yakafo idafa nosámibo weuna-lula-hala neguti ya idafa nosámibo ya li oloto piye. Feto ya lutinau faitoto nebo ha yauti wetinauti ha lo feka o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hemotina wetina etuwalo Wenabao, Wenabao, loti lonomafa, ha lobiyobo li meyalo molámabo ya nedafaito feto ae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Makafo nemodoka loto ya ha lobo holito, li meyalo molo nebo we mona ya itibinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wewa ya we makafo numuna hunogolowe, loto hale lito, fulo yoima uto, hefanalo numuna huibo we yamaidana oto ne. Feto hu hulo itoto ya aliga ho ibo hamenalo no wilito numuna itifuifa, numuna ya yá gedibogunu huinako, yagunu auba ito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Feito nefa, makafo ha lobo ya holito holi fulitaibo we ya we makafo ya numuna hunogolowe, loto aka ma sugi idafa oto mika mulaloko fito huibo we yamaidana oto ne. No wilito numuna itifuito ayalo mofulito lumuto upa-napa libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ena Yesu ya mono ha wenina lobi hulototo ya Kapeneyamu numudo yoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wito yalo ya himiwe wani hadeti (100) hiyaba o betibo we houba-nabala we ma holi dowa muibo we ya idafa hilito fulinogolo aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Neto, wenabala himiwe hiyabatina wekafo Yesu hala ukuwa holito, Yuda wenina hiyabatina we ma feto lobibo, Hemotina Yesu nedoka uti, loto houba-nabane we li faka lo edanane, loti lomuilo, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Idipi molaito, Yesudoka uti, ha auba iti feto loti wako lo edabo, Wewa ya monala dowa nebo nenako, hemo feto fe edananibo ya dowa feyanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Emokafo lemo Yuda wenina lula-hala lumuto ya mono numunate hu ledaibo ne, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Feti wako lo edato, ya Yesu ya holito emotinagi maina uwae. Uti numuna li alili molato himiwe hiyabatina wekafo weninala ma Yesu nedo idipi moloto ya ha feto loto lobito uwabo, Wenabao, nemo Yuda we minámonako, numunaneu yonanibo fefe ladámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ido hemodoka anowe, loto holiyofa, ido nemo yagi ya hemo yaidana we ya minámonako, hena holiyowe. Yagunu hemo aifa wekakafo ha lageto houba-nabane we ya moda faka lanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Feito nemo yagi hiyaba o nedabo we wetinalo meyalo moloto ya onona lito ido nemo ya himiwe hiyabatina we minobo hiyaba o betito feito we ma uwo, lomuwotoma, moda wiye. Ido we ma ano, lomuwoto ya moda aiye. Ido houba-nabane we, onona ya liyo, lomuwotoma, ononawa ya li-li o ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lomuito, Yesukafo hawa liboma ya holito, elegito wenina nuba ege uwabo weninaloka liwewe oto feto lobibo, Nemo ya lobiyowe. Muki Isilaeli wenina yauti we ma holi hikila naba nebo wewa yaidana we ma wa edámowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Feto lito, idipibo wema ya liwila oti uti numugu yowato, houba-naba we moda faka lito wa edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ena aliga hefola Yesukafo numuna meya naba ma huliya Naini yalo unowe, loto wito ege-ege moniyabo we ido wenina nuba naba ya ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ege uwato, numuna meya hanudo ya u fedito, wenina ma hono ula ya yaofalo moloti liti lomae. Lomato, ido wenina muki ya wena-hiyona ma hipala mako ya fulito molo edanune, loti wena-hiyonagi numudoti maina lomae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lomato, Wenabakafo wena-hiyona wa edoto lula-halau milumala holito, Hufo ámo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Feto lomuto u selo anagunu ya yaofalo lito, hono yaofa molabo we hanudo sinoi minato, emokafo feto loto libo, We hofawe, hemo lohomowe. Sinoiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Feto lomuito, fulibo we hofawe ya sinoito ha liye. Feto fe neto, Yesukafo olafote minanaiye, loto li muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Feto fe betito, wenina muki ya wetina lauwa opaitaito, Goti ebola loti feto labo, Ei, polofeti naba ma minonigu oloto pibo ne, lato, ido malekamasi feto labo, Gotikafo weninala adina li faka lanowe, loto aibo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ido aya hala ukuwa ya Yudia ebalo ido eba oka waka yau upatoto wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ena Yoni ege-ege moniyabo we yasi Yesu hala ukuwa ya lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Lomuwato, holito, ege monibo we loiti ya aliyo, lobito ya aito feto lobibo, Wenabadoka uti ya feto loti loga o edaliyo, anaiye, loti lufuwa iyaboma ya wema minabemo, ido we eito hiyabala anune? loti loga o edaliyo, loto lobito idipiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Idipito, we loiti ya Yesudoka uti feto laibo, Yoni noku i beti-beti aibo wekafo feto loto hemodoka lilifiye. Anaiye, loti lufuwa iyaboma ya wema minabemo, ido we eito hiyabala anune? loti loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Feto loti loga o edaito, Yesukafo aya hamenalo ya wenina idafa-adafa naba i hiliyabo li faka loto, ido lutina-hatinau Satani himiwela mino betiyabo idipi feka fulaiye. Ido nomudina likaibo muki ya nomudina li falato betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Feto fe betito we loitima ya ha liwila oto feto lobibo, Hemotina liwila oti uti, idafa muki holiti, ido nomudinagunu wati ya Yoni feto loti lomuilo. Nomudina likaibo wenina ya nomudina falato ae. Ido hidina nosámibo wenina ya hanu moni-moni ae. Ido okola i hiliyabo wenina ya gululudo beti-beti aiye. Ido hatina molaibo wenina ya ha holi-holi ae. Ido fuliyabo wenina ya fuliyaguti sinoi-sinoi ae. Ido idafa wa námabo wenina ya masi hala ukuwa dowa lo oloto bi-bi ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ido wenina masi nemogunu holiti holi fulitámanabo wenina ya dowa holi minomo uwae. Feito lomuilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ido Yoni idipibo we loiti liwila oto uwaito, Yesukafo wenina nuba minabo ya Yoni yagunu feto loto lobibo, Hemotina mika hafali mikalo nena idafa wanune, loti uwabo ne? Honofa ma asigunu lito uto oto aibo wanune, loti wanigili uwafe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","E'e, latoma, we ma ulalo owo lali-idafa ibo ya wanigili uwafe? E'e, moda utinalo owo lali-idafa iti, idafa-adafa wa noti minabo wenina ya mikalo hiyaba we wehudi numunatinau yau minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yagunu nena idafa wanune, loti uwabo ne? Ido polofeti ya wanigili uwafe? O, wanigili uwabo wewa yagunu ha ma lobiyowe. Wewama wa edabo ya polofeti malekama li fulo betito nebo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Emogunu ya mono lufuwau ya feto libo, Moda hane lo oloto molanaibo we ilifiyoto u homu molo hedoto hanuka wili hedanogolaiye, loto ha mono lufuwau (Mal 3:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yagunu nemo ha lobiyowe. Wenipasi hedabo wenina muki yauti makafo Yoni li fulo edaibo we ma minámiye. Minámifa, ido Goti we hudite weninala hiyaba o ledaibo hilalau we ma huliya minámibo we efoma nebo we yamakafo Yoni li fulo edo nebo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lobito, Yesu hala holitabo wenina muki ido hefana takisi li-li abo we yagi Yoni mono noku i betinako, Goti monala moda fefe liye, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Feto holiyato, ido Falisi we ido lo molaibo hala holi hulabo we Yonikafo mono noku i betiyáminako, Gotikafo, li yaidana-meidana o betinowe, loto hala dowa kibo ya fulitae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ena Yesukafo nuba minabo wenina feto loto lobibo, Hamena onesa me ya minabo wenina ya hemaidana oto li mako o betinowe? Ido igaidana wenina minae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Weninawa ya olufo hefola yaidana oti minae. Olufowa hefola ya maketilo amedoti minoti hounatinafo-mota sutina fiti ha naba loti lobiyabo, Oka hofoto nama loba, ido hemotina melege liyámae. Ido fuliyabo nama lo fi molo betito loba, ido hemotina hufo ámae, loti lobiyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Feito Yoni noku i beti-beti aibo we ya loto, wela-idafa ido no waini námoto moi ito hemotina feto lo edabo, Satani himiwela mino edaiye, loti lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ido nemo We Hula ya loto wene-idafagi nogi ya no minoto hemotina feto lo nedabo, Ake, we ya wela-idafagi ido nogi yagunuko holi minoto hefana takisi li-li abo wegi lifimatina nebo weninagi yowo molaiye, loti lo nedae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Feto lo minato, Gotidokati ha manadinau nebo ya liyabo wenina muki ya ha mananau nebo ya ona hula ne, loti itibi-itibi ae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ena Falisi we ma huliya Saimoni ya nemogi wete-idafa maina nanube? loto Yesu loga o edaito, numunalau yoto, amedoti wetina idafa maina no minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Maina no minato, numuna meya yaloti wena nosámibo makafo holito ya no ladanuwa aibo ma nomu hefana pana hibo nomuku nebo ya lito numunalau yoto ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","egeka minoto hufo oto, nomuna nowalagunu hinalo wili edoto, manana opalagunu hilili o edoto, hina mudoto, ladanuwa aibo no yalo leki edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Feto fe edaito, Falisi we Yesu li numunalau edaibo wewa yakafo wato ya lulau feto loto holibo, Wewa ya polofeti nebo neko, wenawa idafa feto fe edaibo ido monala yagunu lifimala nebo wena ne, loto holifefe ladi ne, loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Feto loto holito, Yesukafo ha liwila oto feto loto lomuibo, Saimoniyo, nemo ha ma lohumunowe, loto lomuito, emokafo ha liwila oto libo, Api lilibiyanibo we, moda lonomo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lomuito, Yesukafo feto libo, Hefana onodo libo we makafo we loiti ma lifima munaibo hefanawa Yuda hefana huliya denaliyasi faifu hadeti (500) ya ma muto, ido ma fifiti (50) ya muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Feito bito aliga ya lifimawa uma finowe, loto hefanala wita aifa, liwila oti ogofuwámito feyámoto aifa hilili o betiye. Hilili o betiyageto, loitiwa ya lutina-hatina munigilafa, ido makafo loto yoto lula-hala munogolaiye. Ya hemagunu lowe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Feito loga o edaito, Saimonikafo ha liwila oto feto loto lomuibo, Lifimala naba nebo hilili o edaibo we feto anaibo ne, lito ya Yesukafo feto loto lomuibo, Moda fefe loto haka hiyane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Feto loto lomuto ya wena nedoka liwewe oto ya Saimoni feto loto lomuibo, Wenawa ya wa abe? Nemo numunakau yowobo ya hine noku inobo no fi nomámaba, ido emo yakafo nomuna nowalagunu hinelo lekito atala opalagunu hilili o nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ido hemo numunakau yowodo yalomati oto onesa melo aito, hemoma mudo nedámanima nefa, emo yakafo hine mudomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ido hemokafo atanelo yá nowala wili nedámanima nefa, emokafo hinelo ladanuwa aibo nogunu wili nedo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yagunu ha ma lohomowe. Emokafo lula-hala naba-naba numibo yagunu lifimala naba-naba nebo ya hilili otaibo ne. Feto nefa, ido we ma lifimala hefolako nebo we hilili o edaibo ya lula-hala hefola efomako muibo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Feto loto lomuto ido wena ya feto loto lomuibo, Lifimaka moda hilili otaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Feto loto lomuito, wetina idafa maina noti minabo wenina yasi loyolalo-melo feto labo, Ake, wewa ya lifima yagi hilili aibo we ya hema ne? loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ido Yesukafo wenawama ya feto loto lomuibo, Holi hikika yakafo moda li nomuga wa hedotaiye. Hemo uwageto you amena mona ya mino hedanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ena Yesu ya numudo-namado monimo uto, Goti we hudite weninala hiyaba o ledaibo hala ukuwa dowa ya lo oloto moloto lobimo wiye. Lobimo wibo ya ege-ege moniyabo we tuwelu (12) yagi maina uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ido wenipa malekama ya Satani himiwela lutina-hatinau mino betiyabo ya li fulo betito idipi moloto ido idafa i hiliyabo li faka lo betibo wenipa yagi maina minae. Maina minabo wenawa ya feito ne: Ma ya Madala numudoti wena huliya Malia ya lula-halauti Satani himiwela seweni (7) ya li fulo betito idipi molaibo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ido ma ya Yowana Heloti houba-nabala we hiyabatina we huliya Kusa olonafo ya ne. Ido ma ya huliya Susana ido wenipa malekama muki ya maina minae. Ido wenipawa idafa-adafatina wa nagu yauti adina li faka loti bi-bi ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ena numudoti-namadoti wenina muki uti u Yesudoka nuba naba o minato ya emokafo wase ibo ha ma feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Idafa hifi-hifi aibo we makafo yufa idafa ma itili anowe, loto migu wiye. Uto itili aito, ya yufa idafa ma hanudo limo ibo wenina yasi lala iti hululu iyato, nama yasi oti no hulae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ido yufa idafa ma ya hefana mulalo limo ito, fokito yoifa, mika nowala mináminako, yagunu yufa fou loto yoibo ya megunibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ido yufa idafa ma ya hasuwala aibo idafa yoigu yau limo ito, fokito yoito, hasuwala idafa yakafo ayaida oto yoto, yufa ya li fitoto hofo fulibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ido yufa idafa ma ya mika dowa negu limo ito fokito yoto ilawa ibo ya u wani hadeti (100) ibo ne, loto lobiye. Feto loto wase ibo ha ya lo huloto ya feto su loto libo, Hemotina hatina nebo wenina yasi hawa ya holifefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Feto loto lobito, ege-ege moniyabo we yasi wase ibo ha monawa yagunu loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Loga o edato, feto loto lobibo, Goti we hudite weninala hiyaba o ledaibo ha faluku aibo ya hemotina oloto pi biyoto moda holiyae. Holiyafa, masi Wa-wa o minafa, idafa wafefe loti wagámanigilae. Ido holi-holi o minafa, holifefe loti holiyámanigilae, loto ha mono lufuwau (Ais 6:9) ya nebo ne. Feto nenako, wase ibo ha yako lobiyowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Feto loto lobibo, Ena wase ito ha lobo ya monawa feito ne. Yufa ya Goti hala ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ido yufa idafa ma hanudo limo ibo yaidana oti wenina masi Goti hala holiyafa, ayalo Satanikafo loto, Goti holi hikito muwato, li nomudina watanaiye, loto ya hawa ya lutina-hatinauti ipoto li fulo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ido yufa idafa ma hefana mulalo limo ibo yaidana oti wenina masi Goti hala holiti, ayalo ake naba iyafa, ido lufawatina minámiye. Minámito, hamena foumako holi hiki muti ya hepa molo bibo hamenalo ya Goti hala fulitoti u hopa uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ido yufa idafa ma hasuwala yoigu yau limo ibo yaidana oti ya wenina masi Goti hala holiyafa, ido uti ya mikaleka hena holiyabo idafa-adafa yagi, ido idafa wa nabo idafa-adafa yagi, ido ake inabo idafa-adafa yagi idafa-adafawa yakafo hawa holiyabo yama li fito betinako, weninawadoka hulawa fedo biyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ido yufa ma limo mika dowa negu ibo yaidana oti wenina ma lutina-hatina ona dowa nebo yasi Goti hala holiti li hiki loti auba iti minomo yowato, emodoka hulawa oloto pi bi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Holilo. Wenina yasi lamu hiti liti masa lulaufe, ido folomo feumau ya molámanabo ne. E'e, wenina numugu yonabo ya lamena wanae, loti lamu molo-molo abo ebalo yalo ya molanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ido ayaidana oto idafa-adafa muki onesa faluku nebo ya aliga li oloto pinogolaiye. Ido idafa-adafa muki li momona-amona oto li mi i minabo idafa ya muki oloto pi hulageto, wenina holi hulanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yagunu hemotina ha holinabo monatina yagunu hatina kifefe lalo. Idafa wa nabo wenina ya ma onu ito biyageto, ido wenina ya moda idafa wa nonibo wenina minone, loti hatina kiyabo weninalokati idafawa ya ipoto linogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ena Yesu olafogi unalafo-motagi emodoka unune, loti afa, wenina nuba naba minoti li lulau o edanako, ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ogofuwámato, masi wa betiti uti Yesu feto loti lomuwabo, Okafogi unakafo-motagi wa hedanune, loti feka youma minae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Feto loti lomuwato, emokafo liwila oto feto loto lobibo, Goti hala holiti li meyalo molabo wenina ya onefo unanefo-mota ya minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hamena ma ya Yesu ege-ege moniyabo we ya feto loto lobibo, Momeno anawa filiga yolaleka ya uwokelo, lito holiti sipiku yoti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Feti uwado ya Yesu nomuna fifi aito uwo unaito, asi naba-naba loto, no ya li nosámibo itaito, no halafuto sipi lulau yoito, noku lumunune, loti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Feto o minato, ege-ege moniyabo we minaidoka loti ilimikuti oti feto loti lomuwabo, Wenabao, wenabao, lemo no lulau lumuto fulinogolone, lato, ya emo sinoito asigi no halafugi ya hanu muito, ya asigi no halafugi fulitito holoto neto ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ege-ege moniyabo we feto loto loga o betibo, Hemotina nedafaito holi hikito nomámae? loto libo ya holiya holiti, elegiti ya feto loti loga-loga abo, Aiyo, we ya igaidana we neto, asi yagi ido no yagi ha lido ya hololiye? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ena sipiku monimo uti no momeno filiga yolaleka Gelasa ebalo u fedae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yalo u fedato, Yesu mikalo yoito we ma Satani himiwela mino edaibo wema ya numuna meya yolaleka yati aito ya hatula aiye. Hatula aibo wewa ya aidenati ulalo owo holoiyámoto, numugu unámoto, hono molado yalo hu unoto moni-moni aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wewa yakafo Yesu wa edoto hai moloto hinalo hina obula fito ha naba loto libo, Yesuwo, Goti akaisa nebo we Hipala, neidafa-neidafa fe nedanogolo ane? Une ogofu li nomámo, loto auba ito lohomowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Feto loto lomuibo, Ya Yesukafo Satani himiwela ya wewa lula-halau yauti lumuto uwo, loto lomuibo yamagunu ya feto loto lomuiye. Ido aidena yoimalokati wewa ya analo-hinalo liti nala ainigunu nala i edoti hiyaba o edafa, ido Satani himiwelawa yakafo hamena-hamena ya wewa lito nala-idafa fuko-nako o fulitaito, henito eba hameto holi u-u aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ido Yesukafo wewa, Hulika lo, loto lomuito, lula-halau yau Satani himiwela mukisi yoti minabo yagunu, huline Lisiyoniye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lomuito, Satani himiwela yasi, Lowau lilifiyageto lumutanune, loti ya feto fe ledámo, loti wako lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ido obulalo selo yaleka yalo safu nuba naba noti minabo yagunu ya Satani himiwela yasi, Safu lutinau yonune, loti wako lo edato ya, O, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","O, lito wewa lula-hala yauti lumuti safu lutinau yowato, safuwa holi lumuti lowau hotinalokati luwa fiti momenoku yau no noti moda fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fuliyato, safu hiyaba abo we ya wati holi oluloti uti wenina numuna meya nabaloti hefolaloti minabo ya hawa lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lobiyato, wenina masi idafawa wanune, loti Yesudoka lo fedoti, wewa lula-halauti Satani himiwela fulo edabo we ya ulalo owo holoito, hala-manana fefe loto neto minoto, ya Yesu hinalo amedoto nebo ya wati ya holi holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Holi holi minato, idafawa holiti wati abo wenina yasi Satani himiwela mino edaibo we li dowa lo edaibo monawa eteme o biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hawa eteme o biyato, Gelasa mikalo minabo wenina muki ya holi naba binako, Yesu mikate fulitoto unaiye, loti lomuwae. Feto loti lomuwato ya liwila oto unowe, loto sipiku yoto fulo betito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ido fulo betito wido wewa Satani himiwela fulo edabo we yakafo, Nemote unoifao? loto wako lo edaifa, Yesukafo feto loto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","E'e, hemo numunakaloka liwila oto uto ya Gotikafo hemodoka onona naba libo hawa ya weninaka lo oloto biyo, loto ilifito, wewa ya uto Yesukafo li dowa lo edaibo idafa naba ya wenina muki lo oloto biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ena Yesu liwila oto aito, wenina nuba naba hiyabala o minabo ya wa edoti aiyo-weiyo lo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ena mono numuna hiyaba we ma huliya Yailusi ya loto Yesu hinalo hina obula fito, Nemo numunaneu ano, loto wako lo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wako lo edaibo wewa ya oluwa makoko nebo melegela ya tuwelu (12) yaidana oto nebo olu ya fulinowe, loto uno nebo yagunu feito wako lo edaiye. Yesu ya wewa wako lo edaibo hala ya holito, maina uwaibo ya wenina yasi li lulau o edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Feto fe edabo wenina minagu wena ma nebo ya lunula leki-leki aibo melege tuwelu (12) yalo ya idafawa i hiliye. Idafawa i hilibo wenawa ya lusa we yasi li faka lo edanune, loti afa, ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ena wenawa ya Yesu egeka uto, ulalo owo onuwalo lito ya ayalo lunula hapaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lunula hapaito, Yesukafo, Hemakafo unelo liye? Lito ya wenina mukisi, E'e, lemo feto feyámone, lato ya Pitakafo feto loto lomuibo, Wenabao, wenina nuba naba yasi li lulau o hedoti liti-liti lanako, ido itifu-natifu o minae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Feto loto lomuito, Yesukafo feto loto libo, E'e, eito makafo unelo lito nemodokati aubane ma ibo ya holiyowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Feto lito, wenawamakafo monane poliye, loto ula ololo oto lo fedoto, Yesu hinalo hina obula fito ya wenina muki nomudinalo ya idafa i hilibo ha ya loto, ido ulalo lito ayalo moda faka libo ha yagi lo oloto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lo oloto molaito, Yesukafo feto loto lomuibo, Olune, hemo holi hikitanibo yakafo li faka lo hedaibo ne. Luka-haka you lageto uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ena feto lomu neto, ayalo ya Yailusi mono hiyaba we numunalauti makafo loto ya feto loto lomuibo, Oluka moda fulitaiye. Yagunu api lilibibo we ya hosa aifa fitanaiye, loto ya ámanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Feto loto lomuibo ha ya Yesukafo holito ya Yailusi ha liwila oto feto lomuibo, Holi homámaneyo. Holi hikito numuto minageto ya oluka faka lanogolaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Feto lomuto u numudoka fedoto ya yonowe, loto wenina maleka lo fuko betito, Pitale, Yonile, Yemusile, ido oluwa olafote melafote yako idipito yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yowato, wenina mukisi hufo-nama oti ei-ai, loti feyafa, Yesukafo feto loto lobibo, Hemotina hufo ámilo. Olu ya fuliyámoto aifa uwo uno ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Feto loto lobito, weninawa yasi oluwa ya moda fulito, wa onima nenako, loti ya hiya o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Feto fe edafa, emokafo analo lito ya feto loto sula fito libo, Oluwo, sinoiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Feto loto lomuito, weuna liwila oto aito ayalo ya sinoiye. Sinoito, Yesu feto lobibo, Wela-idafa muilo. Nanaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lobito, olafote melafote elegi minaito, emokafo hawa wenina ma lobiyámilo, loto auba ito lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ena Yesukafo ege-ege moniyabo we tuwelu (12) emodoka li nuba o betito Satani himiwela li fulo betiti idipi molanabo auba ido idafa i hiliyabo li faka lo betinabo auba ya biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Auba bito, feto lobibo, Uti Goti wehudi weninala hiyaba o ledaibo ha ya lo oloto biti ya ido idafa i hiliyabo ya li faka lo betilo, loto idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Idipi molanogolo ya ha ma onu ito feto loto lobibo, Hemotina unabo ya hanudo idafa-adafa owotinafe, ido holobofe, ido beletife, ido hefanafe ya li minámoti aifa wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ido numugu yonagu ayau yako unoti sinoiti oti minomo uti numuna meya malo unigilima aya hamenalo ya numunawa fulitoti wilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ido u fedato houna i betiyámanabo, numunawa ya fulitoti hidinalo huwopa kelaibo ya hululu iti, fulitoti monatina holinae, loti fulo betilo, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Idipi molaito, uti numudo-numudo eba nedo-nedo moniti Goti hala ukuwa dowa lo oloto biti, idafa i hiliyabo li faka lo betimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ena gamani wenabatina Helotikafo Yesu idafa-adafa aibo ha ya holito, hala ligi-ligi kiye. Wenina masi ya Yoni fuliguti li sinoi edaito ne, loti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ido masi ya Elaiya hofa oloto pito ne, loti lo-lo ae. Ido malekamasi ya aidena polofeti minagu ma fuliguti sinoito ne, loti lo-lo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Feto lo minabo yagunu Helotikafo hala ligi-ligi kito ya feto libo, Nemo weneloti ya Yoni henobala fukabo ne. Wewa yamagunu ha yaidana lo minabo holiyobo yagunu hema ne? loto ya wa edanaibo hanu ma wita ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ena aposolo we yasi moniyadoti liwila oti loti onona liyabo ha ya Yesu lomuwae. Lomuwato, Yesukafo idipito, leimoko minanune, loto numuna meya huliya Betesaida wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Idipito wito, wenina nuba naba-naba ya holiti egetina uti ya Yesudoka lo fedae. Lo fedato, houna i betito Goti wehudi weninala hiyaba o ledaibo ha ya lobito, idafa i hiliyabo wenina ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ena fo sapinowe, loto ito ya ege-ege moniyabo we tuwelu (12) ya emo nedoka loti feto loti lomuwabo, Melo ya hameto mikalo minonibo yagunu holito wenina nuba naba ya uti numudo-numudo ido midina numunatina selo nedo yalo ya wetina-idafagi ido unanabo eba ya moni wita anae, loto idipi molo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Feto loti lomuwafa, ido emokafo, Heimotina wetina-idafa ma bilo, loto lobito, liwila oti lomuwabo, Lemo beleti faifu (5) ido laefa loiti (2) yagiko li minone. Yagunu neidafa feyanune? Uto weninawa muki wetina-idafa meina finubogunu labe? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Feto loti labo ya wemoli ya faifu tauseni (5,000) yaidana oti minabo yagunu lae. Feto lato, emokafo ege-ege moniyabo we ya feto loto lobibo, Hemotina wenina lobiyato we fiti nuba fifiti-fifiti (50-50) oti amedoti minomo unae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Feto loto lobito, emotinasi uti feto fe betiyato, muki amedoti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Feto feyato, Yesukafo beleti faifu (5) yagi ido laefa loiti (2) yagi lito okulumalo wa faka loto, Dowae, lalowe, loto ya lekoto ege-ege moniyabo we yasi hona moloti, wenina nuba naba ya binae, loto biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bito, muki wenina nato houmatina aito ya luma nebo onuwa-fanawa minomo wibo ya haka oti owo egepisa naba ya tuwelu (12) holiyato faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hamena ma Yesugi ege-ege moniyabo wegi eimotinako minoti, Yesu eimolako Goti lomu nedo yalo ya feto loto loga o betito libo, Wenina nuba naba yasi nemogunu labo ya hema ne, loti lo minae? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Loga o betito, ha liwila oti feto lomuwabo, Masi hemo Yoni noku i beti-beti aibo we ya minane, loti lae. Ido masi Elaiya ya minane, loti lae. Ido masi ya aidena polofeti minaguti ma ya fuliguti hofa sinoibo we ya minane, loti lo minae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Feto lomuwato, emokafo, Feito lafa, ido hemotina ya nemogunu ya hema ne, loti lo minae? loto loga o betito, Pitakafo ha liwila oto feto loto lomuibo, Gotikafo hilifi molaibo we Kilisto ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lomuito, ido hawa ya wenina lobiyámilo, loto auba ito lo fuko betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ido ha ma onu ito lobibo, We Hula nemo ya hena naba-naba holiyoto Yuda wenina hiyabatina wegi, sokila hi muwabo we hiyabatina wegi, ido lo molaibo ha api itibiyabo we yalekate metina numuti hofo nedato fulito ya fo hamena tili (3) uwageto hofa sinoinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ena Yesukafo ya muki feto loto lobibo, Ma nege molanune, lotima, eimotinagunuko holiyabo ha ya fulitoti, hamena-hamena yá yofotina mofuti nege molanae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ido we makafo eimola ula etuwagunuko holi minoto fulinaibo we ya u hopa unogolaiye. Ido makafo nemogunu holito monimo uto nomuna hofawa minaibo monala ya fulitoto fulinaibo we ya nomuna hofawa minowa-minowa anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ido masi ya mikaleka idafa-adafa muki ya wa noti monimo uwafa, ido eimotina u hopa unabo ya igaidana oti dowa lanabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ido makafo nemogunu ido ha lobo yagunu holito ulalo holinaibo we ya nemo we Hula lamenane yagi, ido Menefo ido fele enisole lamenatina yagi lo fedanobo hamenalo ya wewa yagunu holito ayaidana oto unelo holinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ena ha ona lobiyowe. Hemotina eletifo melo minagu yauti malekama fuliyámoti aifa minato, Goti wehudi weninala hiyaba o ledaibo hamena li oloto pi biyageto wa edanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ena Yesukafo hawa lobi huloitoto neto ya fo hamena eiti (8) utaito yalo Goti lomunowe, loto Pitale, Yonile, Yemusile idipito obulalo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yoto, Goti lomu nedo ya hola-wela u eito ito ido ulalo owo u lamena loto hiyoba ho sili ge-ge fulaibo yaidana oto feyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Feto fe neto, we loiti Mosesete Elaiyate ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","okuluma lamenagi oloto piti, emogi ha loyolalo-melo abo ya Yesu Yelusalemu ya huloto fulinaibo ha ya lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lo minato, ya Pitagi maina nebo we loitigi nomudina fifi aito uwo unadoti sinoiti Yesu lamenala yagi ido we loiti maina minaibo we yagi wa betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wa betiyato, we loiti Yesudokati uwaido ya Pitakafo Yesu feto loto lomuibo, Api lilibiyanibo we, lemo melo minonibo ya dowa ne. Leimo numuna holo-hala loitigi-makogi huto ma ya hemo numunaka minanaiye. Ido ma ya Mosese numunala minanaiye. Ido ma ya Elaiya numunala minanaiye, loto lomuiye. (Feto lomuto ha libo monala ya holifefe ladámiye.) ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Feto lo neto, limu makafo oloto pito wase i betito ege-ege moniyabo we ya holi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Holi bito, limuku yauti nola ma holiyabo feto libo, Meya ya Hipane wa molo edobo wema ne. Hala ya lutina-hatinau holilo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ha lo hulito ya Yesu eimolako nebo ya wa edae. Ena hamena yalo ya idafawa wa edabo ya wenina ma lobiyámoti aifa holiti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ena leda obulaloti lomado ya wenina nuba naba ato hatula ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hatula ato, ayalo wenina minagu yau we makafo feto loto su fibo, Api lilibiyanibo weyo, hipane olufone mako ma nenako, wao, loto wako lo hedowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Holabe? Satani himiwela makafo li hiki lo edaito, haita hai-hai nosámibo molaito ido li ipili-napili i edaito etefu hala-kala welau yati yoi-yoi aibo ne. Feto feyaibowa ya alo fulo edámoto hamena fana-fana feito ula li hopa o edomo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Feto fe edaito, nemo hege-hege moniyabo we yasi lula-halauti li fulo edoti ilifinae, loto wako lo betiyofa, ido ogofuwámae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Feto loto lomuito, Yesukafo ha liwila oto feto loto libo, Ake, hemotina holi hikitina minámito monatina lekesa ibo molabo weninao, hamena nenaki ya hemotinagi minanowe? Ido hamena nenaki hemotina henatina mofu betinowe? Hipaka ilimito ano, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Feto loto lomuito, hipawa ya Yesu nedo o neto ya Satani himiwelakafo li mikalo fulo edaito, hululu-hululu monito, etefu welauti hala-kala loto yoiye. Feto fe edaito, ya Yesukafo Satani himiwela, feto feyámo, lo fuko edoto, ya hipa li faka lo edoto melafo liwila oto li muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Feto fe betito, muki yasi Goti aubala naba ya wati elegiyae. Ido wenina muki ya Yesu idafa-adafa oto moloto o-o nebo yagunu elegi minato, emokafo ege-ege moniyabo we ya feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ha me ya lobinobo ya holiti feto loti holifefe lalo. We Hula nemo ya hofo nedo fulinabo wenina adinalo binogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Feto loto lobifa, hala ya holifefe lotanae, loto Gotikafo hala monawa li faluku betinako, yagunu hatina ligi-ligi kiti loga o edanune, loti holiyafa, ido holi bito loga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ena ege-ege moniyabo we yasi moliya fiti feto loti labo, Lemodokati ya hema homu moloto huliya nebo we minanogolaiye? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Feto loti lafa, ido lutina-hatinau holiyabo ha ya Yesukafo holito ya olufo hefola ma ilimito selo sinoi moloto ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","feto loto lobibo, Holilo. Wenina masi nemo hulinelo olufo hefola yaidana ma houna i betinabo wenina ya nemogi houna i nedanigilae. Ido houna i nedanabo wenina ya nilifi molaibo we yagi houna i edanigilae. Yagunu hemotina yauti we ma hidinalo lumuto minanaibo we ya maleka muki ya li fulo betito u homu molanaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ena Yonikafo feto lomuibo, Api lilibiyanibo weyo, we makafo hemo hulikalo Satani himiwela idipito wa onibo ya lemodoka onu ito hege moláminako, yagunu lo fuko edone, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lomuito, Yesukafo feto loto libo, Lo fuko edámilo. Hemotina uwotinafo buli betiyámibo we ya hemotina yotinawe ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ena Yesu okulumau yonaibo hamenala alili aito ya Yelusalemu numudo unowe, loto auba ito holito ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","wenina idipito homu moloti uti Samalia wenina numunatina malo u fedoti, Yesu unanaibo numuna ma li oloto pi edanune, loti yowafa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ido Yesu ya Yelusalemu numudo unogolaibo yagunu weninawa emogi houna i edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Emogi houna i edámabo monatina ya ege-ege moniyabo we Yemusite Yonite wati feto loti lomuwaibo, Wenabao, lemo ya okulumau su fiyoito okulumauti so lomageto lo ludo hulanae, loto holabe? loti laito ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","emokafo liwewe oto hanu betito ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","u numuna malekama uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ena hanudo uwato, we makafo feto loto lomuibo, Eba muki unanidoka ya nemote maina unoiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesukafo feto loto lomuibo, Liye-hula yasi mika hofuti hu unato ido nama okulumalo moniyabo ya numunatina neto minafa, nemo We Hula ya uwo uno-uno obo ebane ya minámiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Feto loto lomuitoto ena we ma wa edoto, loto nege molo, loto lomuifa, wewa yakafo liwila oto lomuibo, Wenabao, homu ya uto menefo hale li edoto hege moninofe? loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesukafo feto loto lomuibo, Fulinabo wenina fulo betiyageto emotina yasi ya fuliyabo weninatina molo betinigilae. Ido hemo ya uto Goti wehudi weninala hiyaba o ledaibo ha ya lo oloto biyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ena we makafo feto loto lomuibo, Wenabao, nemo ya hege molanofa, homu ya uto numunanelo minabo wenina ya aiyo-weiyo lo betito minalo, loto lobitoto ya hege molanofe? loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesukafo liwila oto lomuibo, Wenina ma ya onona hila linune, loti liyafa, idafa magunu holiti fulitanube? loti lutina-hatina loiti molanabo ya Goti wehudi weninala hiyaba o ledaibo hilalau yonabo ya ogofuwámae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ena aliga Wenabakafo ege molabo wenina sewedi-tu (72) ma weuna fi betito ya numuna meya muki ido eba muki eimola unowe, loto holibo ebalo ya we loiti loiti u homu molo nedoti unae, loto idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Idipi molanogolo ya onona ha feto loto lobibo, Hoba-hobina migu ya naba-naba hula lifa, onona linabo wenina ya naba minámae, loti hemotina onona yawala lomuwato ya onona linabo wenina ma ya ononalau ya idipi molanaiye, loti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hemotina wilalo. Nemo idipi molobo hemotina ya sipisipi mofola yaidana oti liye-hula minagu yau idipi molowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Unabo ya hefanafe, ido owofe, ido hidinalo inabo idafa mafe ya ma liyámoti aifa wilalo. Ido hanu unado ya wenina ma wa betitima, aifa minoti ha-ha lobiti loyolalo-melo ámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ena uti u fedoti numuna mau yonabo homu ya, numuna meu ya you amena mona ya mino betinaiye, loti lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Feto loti lobiyato, we ma you amena mona emodoka mino edaibo numugu minanaibo, hemotina you amena mona yagunu lomuwabo ya wewadoka ya mino edanogolaiye. Ido ma minámanaibo, monawa yagunu lomuwabo ya hemotinaloka hofa liwila oto anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ido onona liyabo wenina yasi meinatina linabo nenako, yagunu yonabo numugu ayau yako unoti sinoiti oti, hoba-idafa muki binabo ya nalo. Numuna mauka-mauka yowámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ena numuna meyalo malekama lo fedato ya wenina yasi houna i betiti ya wetina-idafa binabo ya nalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Noti ya ayau idafa hiliyabo wenina ya li faka lo betiti feto loti lobilo, Goti wehudi weninala hiyaba o ledaibo hamena ya hemotinaloka alilito betiye, loti lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ido u numuna meyalo malekama lo fedato, wenina ya hemotinagi houna i betiyámanabo, hanutinalo moniti ya feto loti lobilo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hemotina numunatinalokati fulo betitoto unune, lotima, huwopatina yagi hidelo kelaibo ya pu loto itili oto fulo ebatinauka fulito betiyone. Feto fe betiyoba, ido hemotina ya fuka ha lobiyonibo ya holilo. Goti wehudi weninala hiyaba o ledaibo hamenala ya moda alili aibo ne, loti lobilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ha ona lowe. Hamena nabalo ya Sodomu minabo wenina lifima ha ito lumuto binogolaifa, ido numunawau minabo wenina lifima ha ya ito yoto binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aiyo, Kolasini weninao, Betesaida weninao, hemotina u hopa unigilabo ya holiyámafe? Hemotinaloka Goti aubala oloto pi betibo idafa-adafawa ya Taiya weninagi ido Saidoni weninagi numunatinalo oloto pi betibo neko, aidenati lutina-hatina li elepa iti utinalo owo lilapa-alapa holoiti so lana wiliti minadi ne. Feto nefa, hemotina lutina-hatina elepa iyámoti aifa gedito minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Feto fe minafa, ido lifima ha binaibo hamenalo ya Taiya ido Saidoni minabo wenina lifima ha ya ito lumuto bito, ido hemotina lifima ha ya ito yoto binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ena Kapeneyamu weninao, heimotina hulitina ya li yoisa okulumalo yoto minanaiye, loti hatina kiyafe? E'e, feto feyámanogolaiye. Ya lowau fulo betito yau lumuti minanigilae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ena ha ma onu ito lobibo, Hemotina ha lanabo ha ya holinabo wenina ya nemogi holinigilae. Ido holi fulo betinabo wenina ya nemogi holi fulo nedanigilae. Ido nemo holi fulo nedanabo wenina ya nilifi molaibo we yagi holi fulo edanigilae, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ido sewedi-tu (72) weninawa monititi liwila oti loti ya lutina-hatinau dowa lito feto loti lomuwabo, Wenabao, hemo hulikalo Satani himiwela yasi wetelo hololae, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lomuwato, Yesukafo feto loto lobibo, Satani ya okulumauti hopana yaidana oto limo ito wa edobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nemo hemotina auba biyonako, hosofa ido hamuke mulalo lala iti, uwotefo aubala muki ya li yoima o edato, idafa makafo li hopa o betinaibo ya ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Feito nefa, hemotina Satani himiwela wetinalo meyalo molabo yagunu ake iyámilo. E'e, hulitina okulumau lufuwa itaibo nenako, yagunu ake iyalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ido aya hamenalo ya Weuna Fele Yesu lula-halau mino edaibo yakafo ake ito naba-naba muito ya feto libo, Menefo, okulumau mikaleka Wenabala, ha manadinau nebo wenina ya idafawa ya li faluku betito, ido aifa wenina olufo hefolaidana oti minabo ya li oloto pi biyanibo yagunu heboka lo minowe. Hemo luka-hakau feto feyanowe, loto dowa holiyanibo ya moda feto fe betiyane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lomutoto, ido wenina feto loto lobibo, Menefokafo idafa-adafa muki ya moda anelo molotaibo ne. Ido Hipala nemo ya we makafo wa nedofefe loto wa nedaibo we ma minámiye. E'e, Menefo yako wa nedofefe loto wa nedaiye. Ido ayaidana oto we makafo Menefo wafefe loto wa edaibo we ma minámiye. E'e, nemogi ido wenina li oloto pi binowe, loto holiyobo wenina yagiko Menefo wafefe lonibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Feto lobito ege-ege moniyabo wegi eimotinako minoti ya feto loto lobibo, Wenina nomudinakafo hemotina idafa wa edabo yaidana oti wati ya ake i-i anigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ha lobiyowe. Polofeti muki ido mikalo hiyaba we wehudi muki yasi hemotina idafa wa edabo yaidana oto wa edanune, loti holiyafa, ido wa edámabo ne. Ido hemotina ha holiyabo yaidana oto holinune, loti holiyafa, ido holiyámabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hamena ma lo molaibo ha holifefe lo hulibo we makafo Yesu hepa molo edanowe, loto sinoito feto loto loga o edaibo, Api lilibiyanibo we, nemo hofawa minomo yonobo mona linowe, loto holinobo, ya nena mona molanobo ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Loga o edaito, Yesukafo feto loto loga o edaibo, Lo molaibo ha lufuwa igu yau nedafaiye liye? Hemo ya hitoto nedafaiye loto holiyane? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lomuito, liwila oto lomuibo, Luka-haka muki ido weuga muki ido aubaka muki ido haka-managa muki ya Wenaba Gotika ya umo. Ido heimokagunu holiyanibo yamaidana oto weninaka muki ya luka-haka bi-bi o mino, loto ha mono lufuwau (Lo 6:5, Wkp 19:18) ya nebo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lomuito, Yesukafo feto lomuibo, Onesa ya ha fefe loto liwila oto lonomane. Hawa ya meyalo molananibo, minowa-minowa oto hofawa minomo yonane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Feto lomuifa, wewa yakafo monane fefe libo ya oloto pinaiye, loto liwila oto loga o edaibo, Hemagunu ya holiyoto weninane minanaiye? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesukafo liwila oto lomuibo, Holiyo. We ma Yelusalemu numudoti Yeliko numudo monimo lumido ugele we yasi haita hofoti ulalo owo wakoti idafala muki liti hofoti fulinaiye, loti fulo edo itoti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Uwato, Goti sokila hi muibo we ma aya hanudo monimo lumuto wewa ya wa edoto hanuma fulitoto u filigaleka hanu anawaleka yola uto wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ido ayaidana oto we ma Lifai yufa figu yauti we ya aya ebalo loto wa edoto hanu anawa filigaleka yola uto fulo edoito wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Fulo edoito wifa, Samalia we ma hanudo monimo loto ya wewa uno nebo ebalo lo fedoto wa edoto milumala holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Milumala holito emo nedo uto ula hofo fukado ya no wainigi yá ilawa nowalagi yakafo noku ito wase i edaiye. Wase i edoto eimola safula-dogi meyalo ya li moloto numuna naba ma hanudo moniyabo lubu itoma uti uno-uno abo numugu ya ilimito yoto hiyaba o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hiyaba o edoto, leda hefana loiti holibo ya lito numuna yawala muto feto loto lomuibo, Wewa ya hiyaba o edo. Ido hefana homobo ogofuwámagetoma, liwila oto anobo hamenalo ya hefana ma yalo humunogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ena wema loitigi-makogi yauti hema ya ugele we yasi hofabo we weninala ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Loga o edaito, lo molaibo ha hitoto holifefe libo wekafo ha liwila oto lomuibo, Milumala holibo we ne, loto lito, Yesukafo, Hemo ya uto mona molaibo yaidanako oto molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesugi ege-ege moniyabo wegi hanu monimo uti numuna malo fedato, wena ma huliya Matakafo aifa li dowa lo betito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","unalafo huliya Malia Wenaba hinalo amedoto ha libo ya holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Holi nefa, atolafo Mata idafa hofo hibo ononakafo nala i edaito, uto loto minoto Yesu nedo loto feto loto lomuibo, Wenabao, unanefo ya fulo nedoito wito houba-naba onona ya neimoko liyobo ya wa nedanibo dowa life? Hemo lumuwageto ane li faka lanaiye, loto lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesukafo feto loto lomuibo, Matao, Matao, hemo idafa-adafa mukigunu holito haka abi kito luka-hakau hena holi minane. ");
INSERT INTO snp_lambau_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Feto fe minaba, ido mona dowa makoko ma mino hedámiye. Ido Malia mona dowa molanowe, loto mona molaibo yamamo ya hemo monaka li fulo edainako, masi emodokati monala ya ipoto liyámanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hamena ma ya eba malo Yesukafo Goti lomu ne. Lomu hulito ya ege-ege monibo we makafo emo nedo loto feto loto lomuibo, Wenabao, Yonikafo ege-ege moniyabo we Goti lomunabo mona api itibibo yaidana oto hemo ya api lilibiyo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lito, Yesukafo feto lobibo, Hemotina Goti lomunune, loti ya feti lomuilo, Metefo, wenina yasi hulika li faka lomo yoto fele ne, loti minanabo ne, loto holiyone. Ido hemo hiyabate we wehudi hiyaba o ledanibo hamena lo fedanogolaiye, loto holiyone. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ido hamena-hamena wete-idafa ya lomo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ido lemo yagi wenina muki li nosámibo o ledabo lifimatina hilili o betiyonibo yagunu hemo lifimate hilili o ledo. Ido mona nosámibo hepa molo lumunaibo nedo ya lilimito aguwámo, loti Goti lomunabo ya feto loti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ena hatina kiyalo. Hemotinadokati makafo luwaila yalo uto hounalafo sula fito feto lomunaibo, Hounanefo, hemo beleti loitigi-makogi ma nomo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yonewe ma hanu monidoti nemo minodo lo fedito wela-idafa munowe, loto feyofa, hoba-idafa ma numunaneu minámiye, loto lomunaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ido numunalau nebo we yamo liwila oto feto lomunaibo, Nilimiku ámo. Numuna hanu huto li hiki lo itoto, nemogi olufonegi folomolo uwo unoto minone. Yagunu folomonelo yati sinoito idafa ma ogofuto homámanogolowe, loto lomunaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ha lobiyowe. Numuna yawala ya wewa yonewema ne, loto holito folomoloti sinoito beleti umámifa, wewa ya ilalu huto loga o edainako, yagunu folomoloka yati beleti moda ogofuto li munogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yagunu ha lobiyowe. Hemotina ya idafa ma lumunabe? loti Goti lomu minanabo ya idafawagunu holinabo ya binaibo ne. Ido idafa moni wita minanabo ya li oloto pi betinaibo ne. Ido hanudo hesoba inabo ya hanu si betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Feito idafa lumunabe? loti lomu minanabo wenina ya moda linabo ne. Ido idafa moni wita minanabo wenina ya li oloto pinabo ne. Ido hanudo hesoba i minanabo wenina ya hanu si betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ido hemotinadokati ya we ma hipalakafo laefa yagunu loga o edanaibo, ya salopaina li munaife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ido okolofo mulagunu loga o edanaibo, hamuke li munaife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Feti hemotina ya wenina nosámabo minafa, olufotina idafa dowa loto aifa bi-bi abo mona ya holi minae. Monawa holi minato, ido Metinafo okulumau nebo we yakafo loto yoto wenina ya Weuga Fele lomo, loti lomunabo ya moda binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesukafo Satani himiwela we ma mino edoto li nei molo edaibo ya lula-halauti ilifi molaito fulo edaito wito wewa homu nei molaibo yakafo ha lito wenina mau minabo ya elegi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Elegi minafa, maleka yasi feto labo, Emo ya Satani himiwela wenabatina Belesebuli aubala yakafo Satani himiwela ya li fulo betito idipi molaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ido ma yasi, Hepa molo edanune, loti holiyabo, Okulumalo mebe-maba li oloto pi ledageto wanune, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lomuwato, Yesukafo hatina kiyabo ya holi huloto feto loto lobibo, Mako wenina eimotina foki filiga-filiga oti fina fi minanabo ya eimotina ebatina li hopa itanigilae. Ido afu mona mako yau wenina minabo eimotina foki filiga-filiga oti fina finabo ya afu monatina ya li hopa itanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ido Satanigi ido weninalagi eimotina foki filiga-filiga oti fina fi minanabo, igaidana oto auba i minanaibo ne? Hemotina ya nemogunu holiti, Satani himiwela wenabatina Belesebuli aubala libokafo Satani himiwela li fulo betito idipi molaiye, loti lo-lo abo hawa yagunu lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ido nemo ya Belesebuli aubala liyobo yakafo Satani himiwela ya li fulo betito idipi molotoma, ya hemotina egetina molabo weninatina ya hemakafo auba bito li fulo betiti idipi molo-molo ae? Yagunu egetina molabo wenina yasi ya wa betiti hona molo betinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ido nemo ya Goti aubala liyobokafo Satani himiwela ya li fulo betito idipi molobo yagunu Goti wehudi weninala hiyaba o ledaibo monala ya hemotinaloka mino betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Holilo. Auba ibo wekafo huwalagi hiyalagi nebo eimola numuna ebala hiyaba ageto ya idafa-adafala muki aifa minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aifa minanogolaifa, ido aubala li fulo edaibo we makafo loto hofoto hiya huwala li auba i edaibo idafawa ipoto lito huwamenala ya hona molanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","We ma nemodo kelámibo ya uwonefo ne. Ido we makafo nemogi maina onona lito li nuba o betiyámibo we ya li upato beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ido Satani himiwela nosámibo we ma lula-halau mino edaibo lulauti lumuto fulo edo itoto uto hameto mikau yaleka monimo uto foli minanowe, loto yaidana eba ma moni wita omo wifa, eba ma oloto piyámiye. Oloto piyámito feto loto libo, Hofa liwila oto homu minobo numunaneu unowe, loto holito liwila oto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Liwila oto lo fedoto wa edaima numunala hilili oto, feke loto, idafa-adafa muki lulau fefe lotoko ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Feito wato hofa feka uto, Satani himiwela nosámibo seweni (7) ya hasuwala nosámibo fiyabo emo hasuwalala li fulo edoti minabo ya idipito aito numunawa yauma yoti unoti sinoiti minae. Feti minato wewa homu ya Satani himiwela makoko lula-halau neboma nefa, ido aliga ya Satani himiwela muki lula-halau minabo yasi li nosámibo naba-naba o edanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu hawa lobi nedo ya wenina mau minagu yauti wena ma sula fito libo, Hemo houmalauti hedoto amina humibo wena ya dowa loto holi minomo wiye, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","eimola liwila oto lomuibo, Ona laba, ido Goti hala holiti hololabo wenina ya dowa loti holi minomo uwae, lanubo ya moda fefe lanaibo ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ido wenina nuba naba abo yasi Yesu li lulau o edo minato feto loto lobibo, Onesa minabo wenina monatina nosámibo-asámibo molo minae. Mebe-maba ma li oloto pi ledanaibo, wa edanune, loti lafa, Goti aubala itibibo idafa ma li oloto pi biyámanaibo ne. E'e, polofeti Yona ulalo Gotikafo aubala ilibibo mebe-maba yako li oloto pi betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona monala molaibo yakafo mebe-maba Ninife numudo wenina oloto pi betibo yaidana oto We Hula nemo monane molobo yakafo hamena onesa me ya minabo wenina mebe-maba oloto pi betinobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ido lifima ha binaibo hamena nabalo ya Seba wenina hiyabatina wenahudi yakafo sinoito hamena onesa me ya minabo wenina ya sigiya lo betinaiye. Emo ya Solomoni ha mananau nebo we nenako, uto hala dowa loto holinowe, loto mika faigalekati aibo nefa, ido onesa moda Solomoni li fulo edobo we ya meu minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ido lifimatina binaibo hamena nabalo ya Ninife numudo minabo wenina yasi sinoiti hamena onesa me ya minabo wenina ya sigiya lo betinigilae. Ninife numudo minabo wenina yasi Yona hala holiti, lutina-hatina elepa iyafa, ido onesa me ya moda Yona li fulo edobo we meu ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","We makafo lamu hito li faluku anaibo ebau molanaibofe, ido masagunu li fitanaibo we ya ma minámiye. E'e, wenina numugu yonabo lamena wanae, loto lamu molo-molo abo ebalalo molanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ido nomuga ya uka lamula ne. Yagunu nomuga dowa minagetoma, lamena ya uka muki ya li faito hedanogolaibo ne. Ido nomuga nosámagetoma, midipu ya uka muki li faito hedanogolaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ido lamenawa lukau nebo ya midipu itanaiye, loto wato hiyaba oto mino. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Feito uka muki lamenakafo faito hedageto, midipu i hedanaibo eba ma minámageto, lamu ya lamena o hedanaibo yaidana oto uka muki lamena o hedanaiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ha lo huloto neto, Falisi we makafo wela-idafa nanaiye, loto numunalau ilimito wiye. Ilimito wito numunalau yoto wetina-idafa nabo folomolo amediye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amedoto nanogolaifa, ana homu noku iyámibo yagunu Falisi wekafo wa edoto hala abi kiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hala abi kito, Wenabakafo feto loto lomuibo, Aiyo, hemotina Falisi we yasi kapugi lapegi etuwalo feka yako noku iyafa, lutinau yau wenina idafatina ipoti idafa-adafa magi magi linubolae, loti holiyabo monagi, ido nosámibo hatina kiyabo monagi ya faitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hemotina hatina-manadina minámibo weninao, etuwa li oloto pibo we ya lulau yagi li oloto piyámife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Feito nefa, idafa lape lulau nebo idafa ya wa námabo wenina binabo ya muki idafa li hiluwa lo betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aiyo, hemotina Falisi we ya lifima ha naba-naba liwila oti linabo ne. Hemotina yasi idafa teni (10) ya liyagu yauti fokiti mako Goti muwabo ya henenafena lobofena miguti hobina li la fulinaibo idafa-adafa mona-mona ya muwafa, ido idafa hula nebo, fefe libo mona ido lutina-hatina Goti munabo mona ya fulitae. Fefe libo mona ido lutina-hatina Goti muwabo monagi molabo neko, ido idafa Goti muwabo mona molabo yagi fulitámabo neko, ya aifa u yalo fefe ladi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aiyo, hemotina Falisi we yasi mono numugu yonabo ya folomo homu nedo minanune, loti holi-holi o minoti, ido maketilo ya wenina wa ledoti aiyo-weiyo lolumunae, loti holiyanako, yagunu lifima ha naba-naba liwila oti linabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aiyo, hemotina ya hono auba mika lulau faluku oto neto wenina holiyámoti mulalo moniyabo eba yaidana oti minanako, lifima ha naba-naba liwila oti linabo ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Feto lito, lo molaibo ha hitoti holifefe labo we minaguti we makafo liwila oto feto loto lomuibo, Api lilibiyanibo we, hemo ha feito lanibo yamo hulite yagi lito lomane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lomuito, Yesukafo liwila oto feto lomuibo, Ido hemotina lo molaibo ha hitoti holifefe labo we yasi wenina hena naba biyato, hena fuliyabo ya idafa ma mofu betinune, loti adina li faka lo betiyámanako, lifima ha naba-naba liwila oti linabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aiyo, hemotina ha hena naba-naba holinigilae. Awatinafo-mota holofatina yasi polofeti ya hofo beti fuliyato, ido hemotina hofo beti fuliyabo yagunu holiti, hini eba ekeni liti hale li betiyabo ebatina li dowa lo minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Feti hemotina yasi awatinafo-mota holofatina hofo beti fuliyabo monatina ya dowae, loti lae. Feto lato, emotina yasi polofeti hofo beti fuliyato, ido hemotina ya polofeti hono aubatinalo numuna hu betiyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Feito nenako, Goti ha mananau nebo we yakafo feto loto libo, Polofetigi ido aposologi emotinaloka idipi moloto anae. Idipi moloto anabo malekama ya hofo beti fulinabo ne. Ido malekama ya li hena holi betinae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ido mika okuluma li oloto pibo hamenaloti polofeti muki hofo beti fuliyabo lunutina yagunu lifima ha ya hamena onesa me ya minabo weninaloka ya fedo binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Feito Abeli hofo fulibo hamenaloti hofo beti fulimo uti uti Sekalaiya hofato fulibo hamenalo uwabo ne. Wewa ya fele huliyagi numuna nabagi ido Goti sokila hi muwabo folomologi lusaku yalo nedo hofo fuliyabo ne. Ha ona lowe. Lifimawa ha muki ya hamena onesa me ya minabo weninaloka ya fedo binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aiyo, hemotina lo molaibo ha hitoti holifefe labo we yasi mono ha holi hulotone, loti mono ha holifefe loti holinabo hanu-wela siti huti anabo idafa ya liti uwae. Heimotina hanu-welau yowámoti, ido we wena yoto mono ha holinune, loti labo wenina ya hanu hu beti itanako, yagunu hemotina lifima ha naba-naba liwila oti linabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hawa feto loto lobito wibo Falisi wegi, ido lo molaibo ha api itibiyabo wegi li uwolafo buli edoti, moliya fi muti, ilalu huti loga-miga o edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","welaloti fefe ladámibo ha ma lito li halo molo edanune, loti hiyaba o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ena wenina nuba naba-naba tauseni-tauseni minabo ya emodoka lo fedoti liti-liti loti hidinalo lala i minae. Feto fe minato, Yesukafo apito ege-ege moniyabo we homu feto loto lobibo, Hemotina ya Falisi monona loiti iyabo monatina ya yisi yaidana oto nebo ya wati hiyaba oti monilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ido idafa muki faluku oto nebo ya aliga oloto pi betito ido idafa wase ito nebo idafa muki ya oloto pito itibinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ido midipu igu ha labo ya fo lido yalo hawa labo yama holinigilae. Ido numugu lulau holoto hatinau ha labo ya numuna obito yalekati lo oloto molato holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yonewe-motao, ha lobiyowe, Hemotina ya utina hofo beti fulinafa, ido hofa li hopa o betiti ogofuwámabo wenina ya holitina holiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Holitina holiyámafa, ido ma holiya holinabo ya itibinogolowe. Wewa yakafo ya utina hofo beti fulitoto lowau itifu betinaibo aubala ya mino edaibo wewa holiya ona holilo. Ona lowe. Holiya holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ena nama lomo faifu (5) meinala ya hefola efoma ne. Feito nefa, Goti ya namawa makoti yaidana u hala molámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ido hemotina atatina opala muki ya moda hitotaibo ne. Holi holiyámilo. Nomunalo ya hemotina weninala minabo nama lomo muki ya li fulo betiyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ido ha lobiyowe. We makafo wenina onobatinalo huline lo oloto molanaibo we ya nemo We Hula yakafo ayaidana oto Goti enisolela onobatinalo ya huliya lo oloto molanowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ido we makafo wenina onobatinalo meya numuto wa edámobo ne, lanaibo we ya Goti enisolela onobatinalo ya mene muto wa edámobo ne, loto lanobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ido we makafo nemo We Hula ya hamane hinaibo we ya lifimala hilili anogolaifa, ido we makafo Weuna Fele hamana hinaibo we ya lifimala hilili o edámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Holilo. We masi adinalo-hidinalo liti li hiki loti ika oti idipiti mono numuna kanisole nuba agufe, ido hiyabatina we wenaba ido hiyabatina we nuba agu anabo, ya ha lolomato neidafaiye loto liwila oto lobinubo ne? Ido ha igaidana oto lanubo ne? loti hatina loiti-loiti kiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","E'e, aya hamenalo yalo Weuna Fele yakafo ha lobinabo ha ya api itibinaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ido wenina nuba agu yauti makafo feto loto libo, Api lilibiyanibo we, hemo lomuwageto yanefokafo idafa weuna fi ledaibo idafa hona moloto filiga ya nemo numunaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lomuito, Yesukafo liwila oto lomuibo, Aiyo, hemakafo ha li fefe-fefe lo betinobo wefe, ido lusaku we buli nedaiye? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ido ha ma feto loto lobibo, Wati monilo. Idafa-adafa magi magi linubolae, loti holiyabo mona muki yauti ma molotanune, loti wati hiyaba oti monilo. Wenina mikalo me ya minoti idafa-adafa naba wa nabo idafatina yamo hofawa minabo mona biyámanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ena wase ibo ha ma feto loto lobibo, Ena wa naibo we ma mikala dowa nenako, hulawa naba-naba iye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hulawa ibo ya wato feto loto hala kibo, Neidafa feyanowe? Eba mináminako, igau hulawa li nuba anowe? loto hala ki ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hala kitoto feto libo, Feto feyanowe. Numunane ya lukoto hofawa li naba ito huto hulawane muki ido huwamenane muki moloto minanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ido neimone ya hane feto loto holinowe. Nemo idafa-adafane naba ya melege abi loto nefa, aifa minanogolainako, nemo ya holoto use loto minoto, nonefena noto, wene-idafafena noto, ake i-i minanogolowe, loto holiyowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Feto lifa, ido Gotikafo feto loto lomuibo, Ha managau minámibo we, eletifo lubuka fuliyageto hamenaka ya hulanogolaiye. Ena idafa-adafaka moda li nuba ito molomo yowanibo ya hema idafala bulinaiye? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ayaidana oto we makafo eimolagunu holito idafa-adafala moda li nuba oto molomo yonaibo we Goti nomunalo ya u idafa wa námibo we ona bulinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ena Yesukafo ege-ege moniyabo we feto loto lobibo, Holilo. Hemotina ya fulitanune, loti ya hoba-idafa nanabo idafagunu holiti ido utina yagunu holiti utelo owo ya nena idafa inubo ne? loti hatina abi ya kiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nomude hofawa minonibo mona yakafo wete-idafa ya li fulo edaibo ne. Ido ute yakafo utelo owo ya li fulo edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nama yagunu hatina kifefe lalo. Emotina ya yufa idafa ya hifiyámabo ne. Ido hulawa ibo ya doliyámabo ne. Ido numugu ya wetina-idafa nuba oti molámabo ne. Feto feyámafa, ido Gotikafo wetina-idafa moda bi-bi aibo ne. Holafe? Hemotina ya moda nama ya li fulo betiti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ido hemotina minagu yauti ya hemakafo eimola hala abi kidoti ya nomuna hofawa mino lito unaibo hamenala ya hefola magi onu ito minomo unaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ido idafawa hefola idafa efo yaidana li fefe lanabo ogofuwámoti, ya idafa maleka yagunu neidafaito hatina abi ki minae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ido hofuku idafa huwawa aibo yagunu hatina kifefe lalo. Huwawa yakafo onona liyámoto ulalo owo lifefe ladámibo ne. Feito lifefe ladámifa, ido huwawa yakafo Yuda wenina hiyabatina we wehudi Solomoni ulalo owo dowa-idafa holoibo ya li fulo edaibo ne, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ido Goti yakafo suwa-nala ya eletifo neto ido leda ya fukoti soku hinabo idafa ya feito li golaiboma nenako, yagunu ya moda ayaidana oto hiyaba dowa o ledanogolaiye, loti ya holiyámafe? Aiyo, hemotina holi hikitina ya hefolako nebo wenina minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hemotina hoba-hobina yagi, ido no yagi igaidana oto lito nanubo ne, loti moni wita oti lutina-hatinau nosámibo holiti hatina abi ya kiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","E'e, aya idafa-adafawa muki yagunu ya eito feka wenina yasi moni wita-wita minafa, ido Metinafo yakafo idafa-adafa muki ya hemotina linabo ogofunaibo idafa ya moda holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yagunu hemotina ya Goti ya hiyabate we wehudi minanaiye, loti auba iti holiti lutina-hatinau ya li homu molo minaneyo. Feto feyanabo ya idafa-adafawa maleka muki yagi moda onu ito oloto pi binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ido hemotina mau hefola minabo ya holi holiyámilo. Metinafo yakafo nemo weninane hiyaba o betiyobo yaidana oti wenina hiyaba o betinae, loto dowa loto holito ononawa bibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Huwamenatina ya hefanalo fuloti meina liti idafa wa námabo wenina bilo. Ido hefana holinabo owo lilitámanaibo ya liyalo. Ido okulumau idafa li nuba anabo ya ugele we yasi selo ámanigilae. Ido hanu sisigafa yakafo námanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Moda holiyafe? Huwamenatina molanabo ebau ya lutina-muludina hatina-manadina aubafofo loti aya ebau yako holi munabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ena hemotina ononala linune, loti utinalo owo ya li hiki loti lamenatina hiti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ido onona we yasi hiyabatina we ya we wena adinalo li biti hoba-hobina nadoka yati liwila oto loto hanudo hesoba iyageto ayalo hanu si edanune, loti hiyabala o minabo wenina yaidana oti minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ido hiyabatina we anaibo yakafo onodo we ya auba iti hiyabala o-o minabo monatina wa betito dowa loto wa betiyowe, loto lito ake naba-naba inigilae. Ona lobiyowe. Hiyaba we yakafo ulalo owo ya li hiki loto idafa no-no abo ebalo loti amedoti minato wetina-idafa binowe, loto lobito houba-naba o betinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ido lubukafe, ido leda luwaila ya hiyabatina we loto onodo we auba iti hiyabala o-o minabo monatina wa betito dowa loto wa betiyowe, lageto ake naba-naba inigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Feito nefa, holifefe loti holilo. Numuna yawala yakafo eletifo lubuka numunaneu ugele we fukoti yonigilae, loto holibo neko, midipu igu ya hiyaba ageto fukoti yowámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ido hemotinagi ya nemo We Hula anobo hamenane ya holiyámanako, yagunu hiyaba otiko minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Feto loto lobito, Pitakafo libo, Wenabao, hemo wase ito hawa lanibo ya leimogunuko labemo, ido mukigunu lane? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Loga o edaito, Wenaba liwila oto lomuibo, Ena onodo we yauti hema yamo onona fefe loto lito ha mananau nebo we ne? Onona yawala yakafo wewa ya ononane liyabo wenina muki ya hiyaba o betito wetina-idafa nanabo hamenalo ya wetina-idafa hona moloto bi-bi anaiye, loto weuna fi edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aliga onona yawala liwila oto loto onodo we hawa lomuido meyalo moloto onona li minaibo we wa edageto ya dowa mino holinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nemo ha ona lobiyowe. Onona yawala ya loto idafa-adafane muki hiyaba o nedanaiye, loto huwamenala muki ya onodo we analo molanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Feito molanogolaifa, ido onodo we ya mona nosámanaibo moloto onona yawala we aloko liwila oto ámanogolaiye, loto lula-halau holito hounalafo-mota houba-naba wegi wenagi inafagunu hofo betito ido wela-idafa noto no noto lula-hala li hopa o-oto minanaibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ya onona yawala liwila oto anaibo hamenala yagunu holiyámoto, ido eletifo onesa aguwámanogolaiye, loto holido, aya hamenalo yalo lo fedanaiye. Fedoto onona yawala yakafo fuko-nako o edoto, holi hikitámabo wenina ebatinau ya ilifi molanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ido onodo we ya onona yawala hala holifa, idafa lifefe loto hala hololadámanaibo ya auba iti hofo edanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Feto feyanigilafa, onodo we ya onona yawala hala holi fefe ladámoto mona nosámibo molanaibo ya hamena fouma hofo edanigilae. Ido idafa-adafa muki bibo wenina ya emodokati idafa-adafa ma mulalo-mulalo ya liwila oti numunabo ne, loto holito, ido idafa-adafa muki hiyaba o nedanabo wenina ya idafa-adafa hiyaba o nedanabo onona ma mulalo-mulalo ya binowe, loto holibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nemo obo ya wenina mikalo minado so fulanowe, loto obo ne. Fuloto aloko lanaiye, loto auba ito holiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Feito holiyofa, ido noku i betiyabo yaidana oti ya hena naba-naba yamo noku i nedanigilanako, hena holinogolowe. Idafawa huladámanaido ya hena holi minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hemotina holiyabo mikalo obo ya we wena ya li you lo ledanowe, loto aiye, loti holiyafe? Feito minámiye. Ona lobiyowe. Nemo wenina ya li uwotinafo-uwotinafo o betinowe, loto obo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ido onesa me ya hamenalokati wenina faifu (5) ya numuna makoku minabo yama ya fokiti u eito-eito uwato, wenina filiga tili (3) ya minabo yasi wenina maleka loiti (2) minabo ya uwotinafo-uwotinafo u buli betinae. Ido loiti (2) yamasi wenina maleka tili (3) yama uwotinafo-uwotinafo u bulinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Feti u eito-eito uti ya melafo yakafo hipala uwolafo buliyageto, ido hipala yakafo melafo uwolafo buli edanaibo ne. Ido olafo yakafo oluwa uwolafo buli edanaibo ne. Ido oluwa yakafo olafo uwolafo buli edanaibo ne. Ido ola-kilofo yakafo onofula uwolafo buli edanaibo ne. Ido onofula yakafo ola-kilofo ya uwolafo buli edanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesukafo wenina naba nuba minabo feto loto lobibo, Hemotina ya okulumalo limu huibo ya watima, ho inogolaiye, loti lo-lo ato ya moda feto feyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ido asi ya maukati loto asi fu-fu litoma, hota lanogolaiye, loti lo-lo ato ya moda o-o aima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hemotina monona loiti iyabo wenina, aya mikalo okulumalo mebe-maba oloto pibo ya feti holifefe loti holama nefa, ido onesa me ya hamenalo mebe-maba ma oloto pito ya wa minabo ya igaidana oti holifefe loti holiyámae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Heimotina ya mona fefe libo ya neidafaiti hona moloti wafefe ladámae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ido hemote uwokafote ha li fefe lo-lo abo numugu unanido hanudo yalo ha dowa loto lomuwageto, lutina-hatina mako moloti, ha li fefe lo-lo aibo we analo molageto himiwe yasi nala i hedoti nala numugu yau fulo nedotanae, loto lutina-hatina mako molaliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ha ona lobiyowe. Lifimaka hefana muki ya liwila oto binanibo yako ya nalauti huloto lumunogolane, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aya hamenalo ya wenina maleka yalo minabo yasi Pailatikafo himiwela idipi molaito uti Galili wenina ma sokila hinabo minadoka uti hofo beti fuliyabo ha ya Yesu lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lomuwato, emokafo liwila oto lobibo, Aya Galili wenina idafawa hena aibo holiyabo yagunu lifimatina yakafo Galili wenina maleka muki lifimatina ya li fulo edaiye, loti holiyafe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","E'e, moda feito minámiye, loto lobiyowe. Feito minámifa, ido lutina-hatina li elepa iyámanabo ya hemotina yagi ayaidana oti u hopa unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ido we eitini (18) ya Silowamu numudo minabo numuna fana-fana yakafo lumu fou loto hofo beti fulibo we lifimatina yamamo Yelusalemu minabo wenina muki lifimatina ya li fulo edaiye, loti holiyafe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","E'e, moda feito minámiye, loto lobiyowe. Feito minámifa, ido lutina-hatina li elepa iti molámanabo hemotina yagi ayaidana oti u hopa unigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ena wase ibo ha feto lobibo, Yá sigolo ma migu neto ya yawala yamo minau uto, sigolo ibo ya moni wita anowe, loto moni wita aifa, li oloto piyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Li oloto piyámito, mina hiyaba aibo we feto loto lomuibo, Melege tili (3) yalo yá sigolowa nedo loto hula moni wita-wita minofa, li oloto piyámowe. Yagunu fukoto fulitoto. Mine mika aubala aifa notanaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lomuito, mina hiyaba aibo wekafo liwila oto lomuibo, Wenabao, melege mako ma yáwa waitageto aifa minageto, mika monau ya hofuto mika inogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ido melege mako ma uwageto, ilawa inaife, ya wanoiye. Ilawa iyagetoma, ya dowa minanogolaifa, ido ilawa iyámagetoma, hofo fukanoiye, loto lomuiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ena Sabati foliku Yesukafo mono numuna malo api itibi neto, ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","yalo moda wena ma nebo Satani himiwela melege eitini (18) ya mino edoto li idafa hili edaito, meya nosámibo huba itoko nebo, sinoito fefe loto moninaibo ya ogofuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ena Yesukafo wenawa wa edoto feto loto lomuibo, Nemodo ano, lito holito aito feto lomuibo, Wenao, idafa hiliyanibo yama moda apaso hedowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lomuto anagunu mananalo lito, ayalo meya ya fefe lito, sinoito, fefe loto monito, Goti ebola lo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ena mono hiyaba wekafo Yesu Sabati foliku wenawa li faka lo edaibo yagunu lula hala-kala lito wenina minabo feto loto lobibo, Holilo. Onona hamena ya sikisi (6) ya ne. Feito neboma nenako, idafa hiliyabo ya li faka lo ledanaiye, loti lanabo ya onona hamenalo yako alo. Ido Sabati foliku yalo ámilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Feto loto lobito, Wenabakafo liwila oto lomuibo, Monona loiti iyabo ya minae. Hemotina muki Sabati foliku bulumakautinafe ido safutina-dogi nalauti wina oti no nanae, loti idipiti nolo u-u afe? Olo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yagunu Abalahamu yufa figu yauti nebo wenawa ya Satanikafo hamena fana melege eitini (18) yalo nala i edomo wibo ya Sabati foliku ya nala i edaibo idafa yati li wina otobo ya u fefe ladámife? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hawa lobibo ya holiti uwolafo-mota utinalo holi minato, ido wenina muki ya idafa-adafa dowa libo yagunu ake naba-naba i minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ena Yesukafo feto loto loga o betibo, Goti we hudite weninala hiyaba o ledaibo monala ya nena idafa yaidana oto ne? Nena idafalo li moloto lanowe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Holipa ilawa ya we makafo lito uto minau hifibo yaidana oto ne. Hifito, fou loto yoto yoto aliga yá holipa naba oloto pito, nama-afa okulumalo u moni-moni abo ya loti akawalo mino-mino aboma ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ido hofa ya loga o betibo, Goti we hudite weninala hiyaba o ledaibo mona ya nena idafalo li moloto lanowe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Idafawa ya beleti li pupu lanaibo idafa huliya yisi yaidana oto ne. Wena ma beleti hofo hinogolowe, loto yisi lito palawa naba yagi li buli-naboli aito yau ya yisi yamo onona lito idafa muki ya li pupu loto aibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ena Yesu Yelusalemu unowe, loto monimo wibo ya numuna meya nabalofena ido hefolafena yagi uto mono ha api itibimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Feito makafo feto loto libo, Wenabao, wenina mau hefolamako li nomudina wanaife? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Loga o edaito, liwila oto libo, Hemotina hanu hefolau yonune, loti holinabo hosa naba ya fiyalo, loto lobiyowe. Yagunu wenina mukisi yonune, loti lanafa, ido ogofuwámanae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ido numuna yawala nemo sinoito hanu moda hunobo hamena oloto pinaibo yalo hemotina feka minoti hanu hesoba i minoti, feto loti wako lo nedanabo, Wenabao, hanu si ledo, loti lonumunafa, ido nemokafo liwila oto lobinobo, Hemotina ya wa betifefe loto wa betiyámowe. Ido numuna ebatina yagi ya wagámowe, loto lanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Feto loto lito hemotina yasi feto loti lonumunabo, Hemogi maina wete-idafafena ido nofena nonima ne. Ido numunate hanutelo yalo sinoito mono ya api lilibi-lilibi anima ne, loti lonumunabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Feto loti lonumunafa, ido liwila oto lobinobo, Hemotina ya wa betifefe ladámowe. Igalekati wenina minae? Hemotina nosámibo monako molo-molo abo wenina muki ya fulo nedoti faiga wilalo, loto lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Feto lobiyoto, ena Abalahamu, Aisaka, Yekopu, ido polofeti muki ya Goti wehudi weninala hiyaba o ledaibo ebala yalo minato hemotina wa betinafa, ido heimotina ya fulito betiyanako, yagunu feka minoti, hufo hai-hai moloti, wetina hofala guti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ena mika negu-negu filiga-filiga oka-waka yalekati wenina loti Goti wehudi weninala hiyaba o ledaibo ebalau yoti wetina-idafa nanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ido wenina onesa hulitinagi we minabo ya aliga hulitina ya lumunaibo ne. Ido onesa hulitina lumibo wenina ya aliga hulitinagi we minanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aya hamenalo Falisi we masi Yesu nedo loti lomuwabo, Helotikafo hofo hedanowe, loto holibo yagunu mika melo fulitoto eba malo uwo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lomuwato, emokafo liwila oto lobibo, Hemotina liwila oti uti wewa liye-hula ya feto loti lomuilo, Holi minabe? Moda eletifogi ido ledagi Satani himiwela mino betiyabo idipi molomo uto, wenina idafa i hiliyabo li faka lo betiyomo uwoto ido fo hamena tili (3) uwageto ononane ya hulanogolaiye, loti lomuilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ido nemo ya eletifo ya monimo uto, leda yagi monimo uto, oko yagi monimo unogolowe. Ya neidafaitowe? Yelusalemu hilala feka yalo polofeti ma hofo fuliyámanae. E'e, Yelusalemu numudoka yako hofo nedo fulinae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aiyo, Yelusalemu weninao, Yelusalemu weninao, hemotina polofeti hofo beti fuli-fuli o minae. Ido hemotinadoka idipi molaibo we ya hefanagunu hofo beti fuli-fuli abo ne. Ido okolofokafo mofola li nuba o betito okonagunu li fito beti-beti aibo yaidana oto hamena abi nemokafo hemotina hemaneu li nuba betinowe, loto holiyofa, ido eleka fimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Walo. Numunatina meya ya fulito edanaiye. Ido hemotina hofa wa nedámoti monimo uti uti, Wenaba huliyalo aibo we ya dowa loto holimo wibo ne, loto ha mono lufuwau (Sng 118:26) nebo ha lanabo hamena yalo ya hofa wa nedanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ena Sabati foliku malo Yesu wene-idafa nanowe, loto Falisi huliya nebo we ma numunalau yoito, auba iti wa edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wa edo minato, moda nomunalo we ma ana-hina moloto fudibo ya neto ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesukafo wa edoto ya Falisi wegi ido ha lo molaibo ha holiyabo wegi feto lobibo, Sabati foliku li faka lo edanune, loti lanabo ya lo molaibo ha fukanafemo, ido fukámanae? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Loga o betito, ha ladámoti minabo yagunu anagunu idafa hilibo we lito li faka lo edoto ilifito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wito, ena feto lobibo, Hatina kiyalo. Hemotina yauti we ma hipalafe ido bulumakaulafe ya Sabati foliku ya hale fana no negu yau lumu fou lanaibo ya wewa yakafo aloko li faka lo edámanaife? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","liwila oti lomunabo ha ya minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ido Yesukafo wenina wetina-idafa nanune, loti abo wenina yasi folomo hotinalo oloto nebo folomolo yaloko minanune, loti holiyabo ya wa betito wase ibo ha ma lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","We makafo hipala wena liyageto wete-idafa ya nanogoloniyo. Hemo ano, loto hemodoka ha fulo hedoto, ido we ma huliya nebo hulika li fulo edanaibo we yagi ha fulo edotoma, ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","hemodoka loto, Folomoka ya we me ya ya umo, loto lohomageto ukalo holito uto aifa wenina ebatinalo yalo minotanowe, loto folomolo hotinalo oloto nebo yalo amedámo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E'e, ano, lohomagetoma, hemo uto aifa wenina ebatinalo yalo minananibo ya wetina-idafa yawala hemodoka loto lohumunaibo, Weninane, loto folomo dowa loto yalo minanane, loto lohumunaibo ne. Feto lohumunaibo aya hamenalo ya wenina muki nomudinalo ya hulika yonaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Feito makafo eimola huliya ito yonaibo ya Gotikafo ya huliya ito lumunaibo ne. Ido makafo eimola huliya ito lumuto moni minanaibo ya Gotikafo huliya li yoisa o edanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ido Yesukafo wela-idafa yawala feto lomuibo, Ena folilofe, ido lunagafe, wetina-idafa naba hofo hitoma, yokawe-motafe, ido atokafo-motafe, ido weninakafe, ido wenina selo minoti idafa wa nabo weninafe, wete-idafa nanuniyo alo, loto ha fulo betiyámo. Alo, lobinanibo, ya liwila oti lohumunabo, Hemo ya lemogi maina nanane, lato, lifimane hulotanaiye, loto alo, lobiyámo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E'e, wetina-idafa naba hofo hinanibo ya idafa wa námabo weninagi, hebilisiyabo weninagi, ido hidina-adina nosámibo weninagi, ido nomudina likaibo weninagi, Alo, loto ha fulo betiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Feito ha fulo betinanibo ya dowa loto holi minomo unogolane. Ido aya weninawa liwila oti lifima humunabo ya ogofuwámanako, yagunu fefe libo mona molabo wenina fuliyaguti li sinoi betinaibo hamenalo ya lifima liwila oto humunaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ido Yesugi maina amedoti wetina-idafa no minabo wenina minagu yauti we makafo hawa holito feto lomuibo, Goti wehudi weninala hiyaba o ledaibo ebalau yoti ya wetina-idafa nanabo wenina ya holiyobo dowa loti holi minomo unigilae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Feto lomuito, Yesukafo liwila oto libo, We makafo wenina muki wetina-idafa hofo hi betiyoto nanae, loto anabo hamena ya molo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ena idafa-adafa muki ya lifefe lo huloitaibo hamena yalo ya weninaloka ya houba-nabala we ilifito uto feto loto lobibo, Idafa-adafa muki hofo hitae. Alo, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Feto lobifa, weninawa muki ha eito-eito loti aguwámanabo ha lae. Feto lato, we makafo feto libo, Nemo onesako mika ma meina fiyobo nenako, yakafo ika o nedaito wanowe, loto uwowe. Yagunu hemo wenaba nedoka uto lumuwageto hawa ya holinaibo nosámanaife? loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ido makafo libo, Nemo onesako bulumakau teni (10) ya meina fiyobo nenako, uto onona linabo hepa moloto anogolowe. Yagunu hemo wenaba nedoka uto lomuwageto hawa holinaibo nosámanaife? loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ido mamakafo libo, Nemo onesako wena liyobo yagunu aguwámanowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Feito houba-naba we yakafo liwila oto uto, we nabala hawa labo ha ya lomuito, holito numuna yawala sebala hala-kala lito, houba-nabala we feto loto lomuibo, Hemo aloko numuna meya nabau uto hanu hofalalo ido hanu hefolalo ya monito idafa wa námabogi, hebilisiyabogi, nomudina likaibogi, hidina nosámibogi idipito ano, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Feto lomuito, hawa houba-nabala we holito, ayalo meyalo moloto liwila oto loto wenabala ya feto loto lomuibo, Wenabane, hemo ha lanido ya meyalo moloto idipito feyofa, ido eba maleka ya aifa ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Feto lomuito, wenabala ya feto libo, Yagunu numuna meya fulitoto uto hanu hofalalo ido migu hanudo ya monito wenina minanabo ya auba ito idipito ageto loti numunaneu faitanae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ena lobinogolowe. Wenina homu ha fulo betito wetina-idafa hofo hi betiyobo ya ma námanabo ne, loto liye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ena wenina nuba naba minabo ya Yesu ege uwato, elepa ito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","We makafo nemodoka loto olafo, melafo, olonafo, olufola, yalafo, unalafo, ido eimola nomuna hofawa minanaibo mona yagi meya biyámanaibo ya nege molanaibo ogofuwámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ido yá yofola mofuto nege molámanaibo we ya nege molanaibo ya ogofuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hatina kifefe lalo. Hemotina minagu yauti we makafo numuna naba ma hunowe, loto lanaibo ya homu amedoto meinala holito hefanane ogofunaife? loto hefanala hitanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Feto feyámanaibo, numuna folomo wilinaido hefanala hulageto numuna hu hulanaibo ogofuwámito, wenina muki idafawa wati ya hamana hinae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hamana hiti ya feto lanabo, Wewa ya numuna apito hu hulanaibo ya ogofuwámiye, loti lo edanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ido mikalo hiyaba we wehudi makafo mikalo hiyaba we wehudi magi lowa finune, loto lanaibo ya homu amedoto nuba abo himiwela teni tauseni (1000) yasi uwolafo himiwela tuwedi tauseni (2000) anigilabo ya li fulo betinubemo, ido li fulo betiyámanune? loto hala kinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ido li fulo betiyámanune, loto holitoma, uwolafo faiga minanaibo hamenalo emotinagi igaidana oto li hutifina anune? loto ha fulo edanowe, loto weninala uwolafo nedoka idipi molaito unae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ido ayaidana oto hemotina yauti makafo idafa-adafala muki ya meya umámanaibo ya nege molanaibo ya ogofuwámanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Holilo. Ho ya idafa la fulibo nefa, la fulibo hulageyama ya igaidana oto hofa la fulinaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ononala hulibo ne. Feito howagi ido bulumakau sefegi mikau ya li elepa ito idafa hifiyámanogolone. Aifa fulitone. Hemotina hatina nebo wenina ya hawa holifefe loti holilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ena hefana takisi li-li abo wegi ido mona nosámibo molo-molo abo wegi muki Yesu hala holinune, loti emodoka loti li hona o edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Feto fe minafa, Falisi wegi ido lo molabo ha api itibiyabo wegi yasi Yesu holi nosámibo muti feto labo, We me ya ya mona nosámibo molo-molo abo wenina yagi houna i betito maina no-no o minae, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Feto lato, ena Yesu ya wase ito ha lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Holilo. Hemotina minagu yauti we makafo sipisipila wani hadeti (100) minaguti mako ma ya moni faluku ageto malekama nainti-naini (99) ya aifa nebo ya suwa nabo ebalo fulo betitoto uto moni faluku aiboma ya moni wita omo uto uto li oloto pinaibo nefe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Li oloto pito ake naba-naba ito li heleyau moloto ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","numudoka liwila oto itanaibo ne. Lo fedoto yolawe-motagi ido wenina selo minoti kelabo weninalagi li nuba o betito feto loto lobinaibo, Sipisipine moni faluku aiboma ya li oloto pitowe. Yagunu nemogi maina ake naba-naba inune, loto lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ido ha lobiyowe. Okulumauka minabo yasi ayaidana oti lifima mino edaibo we mako makafo lula-hala li elepa inaibo, ake naba-naba i minae. Ido ake naba-naba inabo monatinawa yakafo wenina nainti-naini (99) mona fefe liboko molo-molo onibo nenako, lute-hate elepa iyámanune, loti lanabo yagunu ake iyabo mona ya li fulo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ido wena makafo hefanala siluwa teni (10) nebo yauti mako ma limo ito faluku aito le hito numugu ya mouta hiloto esama-asama oto wita omo uto uto li oloto pinogolaife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oloto pitoto wenawa ya yolawe-motagi ido weninala selo minabo yagi li nuba o betito lobinaibo, Hefanane siluwa mako ma limo ito faluku aibo yama li oloto pitowe. Yagunu nemogi maina ake naba-naba inune, loto lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ido ha ma lobiyowe. Ayaidana oto Goti enisolela nomudinalo lifimala nebo we makafo lula-hala li elepa inaibo, ake naba-naba i minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesukafo ha ma onu ito lobibo, We ma hipala loiti minaibo ya ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","aliga hedaibo hipa yakafo melafo lomuibo, Idafaka weuga fi nedanibo yama nomo, loto lomuito idafala hona moloto hipala loiti biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Idafala hipala bito hamena fouma efomako mino itoto aliga hedaibo hipamakafo idafa-adafala muki li nuba oto lito eba ma faiga meuka uto yalo weuna fi edaibo idafala muki hefanalo fuloto mona nosámibo moloto monito hefanala fulo huliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hefanala huwamenala muki ya hulo itoto neto mika yalo inagunu naba oloto pito, Wene-idafa ma mináminako, inagunu fulitanowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","aya ebalo wenina ma nedo uto ononaka linowe, lito, Safune wetina-idafa muto hiyaba o, loto yalo fulo edaito safula hiyaba aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Safula hiyaba oto inagunu fulifa, we ma wela-idafa umáminako, safu wetina-idafa ya noto houmane anaiye, loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Feto loto holito uwo unaiguti ega-namaga oto sinoito feto loto hala kibo, Menefo houba-nabala we muki ya hoba-idafa noti minabo hefa idafa abi loto nebo nefa, nemo ya inagunu fuli minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Feito neboma nenako, menefo nedoka liwila oto uto feto lomunowe: Menefo, nemo ya okulumau nebo wete hemote mona nosámibo molo betiyobo yagunu lifimane ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yagunu hipane ne, loto lananibo ya fefe ladámanaibo ne. E'e, hemo ononakalo houba-naba we ne, loto fulo nedanane, loto hala kito ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","sinoito melafodoka wiye. Wibo ya melafokafo faigati wa edoto mulunau milumala naba holito hipaladoka oluloto uto abusa ito hola mudiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hola mudito, hipalakafo lomuibo, Menefo, nemo okulumau nebo we ya mona nosámibo molo edoto ido hemo nomugalo mona nosámibo molo hedobo yagunu lifimane ne. Yagunu hipane ne, loto lananibo ya fefe ladámanaibo ne, loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","melafokafo houba-nabala we feto lobibo, Henemane oti ulalo owo dowa-idafa utinalo owo maleka li yoima o edaibo yama liti loti ulalo holoi edoti, analo ekeni idafa dowa holoi edoti, hinalo idafa yagi holoi edalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Feti ya uti bulumakau lulumala fibo ya liti loti hofo huwato ake ito nanune. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hipanewa me ya yagunu moda fuliye, loto loma nefa, hofa sinoiye. Ido moni faluku aito hofa li oloto piyowe, lobito ena apiti ake iti noti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Feto fe minato, hipala homu hipa ya onogu neguti loto numuna lega selo ya lo fedoto nama loti melege liyabo ya holito ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Houba-naba we ma sula fito feto lomuibo, Neidafaiti feyae? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Loga o edaito, feto lomuibo, Unakafo fuliyámoto liwila oto aito metinafomakafo bulumakau lulumala fibo ma hofoto hu edaito noto minone, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Feto loto lomuibo ha ya holito sebala hala-kala lito lukafa oto numugu yowámanogolowe, lito melafokafo holito numunalauti lumuto lomuibo, Numugu yowo, loto hala fi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hala fi nefa, emokafo feto loto melafo lomuibo, Holabe? Melege abi loto houba-naba o hedoto ido hakalo hamena mako ma holi fulámoma ne. Nefa, ido hemo ya meme mofolagi ya yaidana oto nomageto weninanegi minámo-minámo onima ne. Ona moda feto feyámanima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Feto feyámanima nefa, ido hipaka me ya ya idafa-adafaka lito monito wenipa olufo hopa li uno-uno oto bi huloto hofa liwila oto aito ya hemo hala holito safuka-bulumakau mofola lulumala fibo ya hofo hi edane, loto feto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Feto lomuito, melafokafo libo, Hipane, hamena-hamena nemote minoiboma nenako, nemo idafane muki ya heimo idafaka ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Feito nefa, eletifo ya lute-hateu dowa loto holiyokelo. Aya unakafowa ya fulitaima nefa, eletifo hofa sinoiye. Ido u hopa utaima nefa, eletifo hofa li oloto piyone, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesukafo ege-ege moniyabo we ya ha feto lobibo, Idafa wa naibo we ma nedo loti huwamenala hiyaba we yagunu huwamenaka moda fulaiye, loti lodobe fiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yagunu nemodoka ano, lomuito aito lomuibo, Hemogunu lo hedo minabo hawa ya holiyowe. Huwamenane hiyaba we minanibo ononane ma hofa liyámanane. Yagunu hefana lito ido hefana fulitanibo mona ya li oloto pi nomo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Feto lomuito, hiyaba wekafo hala abi kito ya neidafa-neidafa feyanowe? We nabanekafo ononanelo yaloti li fulo nedainako, migu onona linofe? E'e, aubane mináminako. Wenina wako lobinofe? E'e, feto feyanobo ya unelo holinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aiyo, wenabane nilifiyageto weninasi wene-idafa nomato, numunatinau unoto sinoito anobo yagunu idafa anowe, loto holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Feto loto holito, wenabala idafala lifima li muwabo wenina muki alo, lito ya hala holiti ato, homu aibo we ya hiyaba wewakafo lomuibo, Hemo wenabanedokati idafala liyanibo ya hemodoka lifima nenaki ne? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nemodoka ya yá olifi nowala dalamu wani hadeti (100) yaidana nebo moda notowe, lito ya feto lomuibo, Emodokati idafa liyanibo lufuwa ya lito, henemane oto amedoto dalamu fifiti (50) yako li oloto moloto lufuwa iyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ena aliga aibo we ya lomuibo, Wenabane idafala liyanibo ya idafa nenaki me ya fiyámanibo ne? loto loga o edaito, liwila oto lomuibo, Suwa witi beki naba wani hadeti (100) ya moda notobo ne, lito feto loto lomuibo, Me ya fiyámanibo idafa lufuwa ibo ya lito, amedoto suwa witi beki naba eitiko (80) ya ne, loto li oloto moloto lufuwa iyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ido huwamena hiyaba we hasuwala aibo mona molaibo we ya ha mananau nebo yaidana oto hala kinako, wenabala yakafo ebola libo ne. Yagunu melo mikaleka monagunu holifefe loti holiyabo wenina ya eimotina adina li faka lanabo monatinakafo wenina lamenalo minabo ya eimotina adina li faka lanabo monatina ya li fulo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Holilo. Hemotina me ya nosámibo mikalo hefana-huwamena wa nabo idafa yakafo wenina houna i betilo. Feto feyato hefana-huwamenafena hulanaido ya minowa-minowa oti minanabo ebau ya houna i betinae, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Makafo hefo-itala idafa hiyaba dowa loto li minanaibo ya ayaidana oto idafa-adafa naba yagi hiyaba dowa lanogolaiye. Ido makafo hefo-itala idafa ya wato hiyaba ámanaibo yakafo ayaidana oto idafa naba ya hiyaba ámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Feito nebo nenako, hemo ya hefana-huwamena me ya mikalo ya hiyaba dowa o edámananibo, hemakafo idafa wa naibo idafala ona hula ya hiyaba o nedanane, loto agalo molanaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ido hemo eito wenina huwamenatina ya hiyaba dowa loto ámananibo, hemakafo heimoka idafaka ne, loto huwamena homageto li minananibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","We makafo wenaba loiti ya houba-naba o betinaibo ya ogofuwámiye. Feto feyanowe, loto holinaibo ya wenabala ma ya eleka fi muto, ido ma ya lula-hala munaibo nefemo, ido malo ya u keloto, ido ma ya fulo edanaibo ne. Ayaidana oti hemotina Goti ido hefana-huwamena mikalo idafa-adafa ya li mako itoti houba-naba o betinune, loti holinabo ya ogofuwámae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ido Falisi we hefana ya lutina-hatina muwabo we yasi Yesu hawa libo ya holiti hamana hi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Feto feyato, emokafo feto loto lobibo, Hemotina ya wenina nomudinalo fefe libo mona molonibo wenina minone, loti monona loiti i minafa, Gotikafo lutina-hatinau hatina kiyabo monawa ya holi ne. Ido wenina yasi idafa ma huliya iti yoi minabo idafa ya Goti nomunalo ya lilitibo idafa yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Holiyafe? Lo molaibo ha, ido polofeti hatina ya lo oloto molomo uti Yoni nebo hamenalo ya uwae. Yaloti Goti wehudi hiyaba o ledaibo hala ukuwa dowa lo oloto molomo uwato, Gotidoka unune, loti auba iti holiyabo wenina muki ya hosa fiti onona li minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ido aliga ya mika okuluma hulanaibo ya aifa hulanogolaifa, ido lo molaibo ha yauti ha hefola efomako ya u hopa aguwámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ena we makafo olonafo fuko fulitoto, uto wena eito libo ya hume-ugele aiye. Ido we makafo wena wanafo fuko fulitaibo ya wena libo ya hume-ugele aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ido idafa wa naibo we ma nebokafo ulalo owo luta-hisigi hiyobagi meinala naba nebo holoito, hamena-hamena wela-idafa dowa lotoko no-no o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No neto, ido we ma idafa wa námibo wako o-o aibo we huliya Lasalusi ula muki numuna libo we ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","idafa wa naibo we wela-idafa hefa aibo ya fulanabo lito nanaiye, loti hila hanu welalo weninalasi limo fulo edato, uno ne. Uno neto, hula yasi loti numuna lido henabu-henabu o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ena aliga wako o-o aibo wema fulito, enisolesi ilimiti yoti Abalahamu hamanau fulo edae. Ido idafa wa naibo wemagi fulito, hale li edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hale li edato, so fiyámanaibo soku minoto ogofu naba-naba holito wa faka loto yaleka faiga yowaito waibo ya Abalahamute Lasalusite maina minaibo ya wa betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wa betito Abalahamu feto loto lomuibo, Menefone, nemo milumane holito ya soku ogofu naba-naba holiyonako, loto ana gala noku fito wene hulumalo wili nedanaiye, loto Lasalusi nemodoka ilifiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lomuifa, ido Abalahamukafo liwila oto lomuibo, Hipane, holi minane. Mikalo minanibo hamenalo ya idafa-adafaka dowa ya moda liyageto, ido Lasalusi ya idafa-adafala nosámibo lima nefa, onesa lula-hala li aila i edo minoto, ido hemo ogofu holi minane. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ido yako minámiye. Filiga-filiga lemo minonido hemotina minado lusaku yau ha naba-naba falinako, wenina melo minabo ya filigaleka ogofuti hemo minanidoka ya aguwámanigilae. Ido hemo minanidoka yati ogofuti lemo minonido ya ámanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ena liwila oto lomuibo, Menefone, ha ma lanowe, holi nomo. Menefo numunalau unanefo-mota faifu (5) ya minabo ne. Emotinagi so fiyámanaibo eba meu ya lumuti ogofu naba-naba holitanae, loto Lasalusi ilifiyageto uto fuka ha lobinaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Feito lomuito, Abalahamu yakafo liwila oto lomuibo, Unakafo-mota ya Mosesegi polofetigi lufuwa iyabo yama mino betima nenako, holinigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Feto lito, lomuibo, E'e, Abalahamu, menefone, feito minámiye. We ma fuliguti sinoito lobinaibo ya lutina-hatina li elepa inigilae, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Feto lito, ya lomuibo, Mosesete polofetite hatina holi fulitoti minatoma, ido we ma fuliguti sinoito uto lobinaibo ya ayaidana oti hala ya holi fulitanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesukafo ege-ege moniyabo we feto lobibo, Idafa-adafa mona-mona yakafo loto wenina ya li nosámibo mona molanae, loto anogolaiye. Feto anogolaifa, we makafo feito li lifima fedo binaibo we ya aiyo, lifima ha naba-naba liwila oto linaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaidana we yakafo weninane yauti mako aubala minámibo ma li lifima fedo munowe, loto lanaibo we ya analo-hinalo liti, henobalalo hefana naba-naba nala iti ho noku fulo edabo neko, moda dowa ladi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yagunu heimotina monatina ya wati hiyaba otiko monilo. Ido hounakafo makafo nosámibo mona molaibo ya hanu muwageto, lula-hala li elepa inaibo, lifimala hilili o edo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ido fo hamena makolo ya hamena seweni (7) ya li nosámibo o hedanaibo ya hamena seweni (7) ya hemodoka liwila oto loto lune-hane li elepa iyowe, lanaibo, lifimala hilili o edo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ido aposolo yasi Wenaba lomuwabo, Hemo holi hikite ya li naba-naba o ledo, loti lato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","emokafo liwila oto lobibo, Hemotina holi hikitina ya holipa ilawa yaidana oto hefola minanaibo ya yá ma apu oto lumuto ho noku minoto yonane, loti lomunabo ya wetinalo meyalo moloto feto feyanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hatina ki fefe loti kiyalo. Hemotina yauti we ma houba-nabala we ya migu mika fi minanaife, ido sipisipi hiyaba o minanaife, lunaga molageto migu yati liwila oto loto numugu yonaibo ya wenabala yakafo lomunaibo, Aloko ano. Weka-idafa no, loto lomunaife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E'e, feito minámiye. Emomakafo feto lomunaibo, Aiyo, hemo wene-idafa hofo hito, ukalo owo holoito, wene-idafa nomageto nototo aliga heimoka hofo hi nanane, loto lomunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ido houba-nabala we ya ha lomuido meyalo molaibo ya ebola lanaife? E'e, feto fe edámanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yagunu hemotinagi ayaidana oti idafa lobiyodo ya o hulageto, lemo aifa houba-naba we minoto ononate yako liyoniyo. Luwate ya ladámilo, loti lalo, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ena Yesu ya Yelusalemu unowe, loto hanudo Galili mika onuwalo, ido Samalia mika onuwalo ya monimo uto, ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","numuna meya malo u fedoto yoito, okola hiliyabo we teni (10) yasi hatula oti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","faiga minoti ha naba loti sula fiti feto labo, Yesuwo, wenabao, lemo milumate ya holiyo, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Feto lomuwabo we ya wa betito lobibo, Hemotina uti utina ya sokila hi muwabo we ya itibilo, lito holiti hanudo monimo uwado yalo utina li hiluwa lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ido wemoli uwagu yauti we mako makafo ula hiluwa libo ya wa edototo liwila oto Yesu nedo loto, Goti ebola ha naba-naba loto lomo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Loto ya Yesu hinalo hina obula fito, Dowae, lalowe, loto lomuiye. Feto loto lomuibo wewa ya Samalia we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ya loga aibo, We teni (10) okola hiliyabo ya muki li hiluwa lo betiyofe? Olo. Ido malekama naini (9) igau ya minae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Eito feka we me ya yako loto Goti ebola lanowe, loto liwila oto ainako, malekama ya Goti ebola lanune, loti liwila oti ámafe? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ido wewama feto loto lomuibo, Hemo sinoito uwo. Holi hikitanibo yakafo ukalo ya li faka lo hedaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hamena ma Falisi we yasi Yesu loga o edabo, Goti wehudi weninala hiyaba o ledaibo hamena ya nenafeko lo oloto pinaibo ne? loti loga o edato, Yesu ya liwila oto lobibo, Goti wehudi weninala hiyaba o ledaibo hamena ya mebe-mabagi wenina nomudinagunu wa edanabo ya ámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","E'e, Goti wehudi weninala hiyaba o ledaibo ya moda hemotina minagu mino betibo nenako, melo ya ne. Walo, ido, yola ya ne. Walo, loti ladámanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ena ege-ege moniyabo we feto loto lobibo, Aliga hemotina ya nemo We Hula ya hofa oloto pi betinobo hamena mako ya wa edanune, loti auba iti holinigilafa, wa edámanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ido masi feto lobinabo, Yolaleka ne. Wa edalo, ido, meleka ne. Wa edalo, loti lobinabo ya wa edanune, loti oluloti egetina molámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","E'e, hopana hito okulumalo ya filiga pana hito filiga lamena o fulitaibo yaidana oto nemo We Hula hamenanelo ya liwila oto lo oloto pinobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Feito oloto pinofa, ido hamena onesa me ya minabo wenina homu hena naba-naba mona-mona numuti, metina numuti wa nedofe loti wa nedámanae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ido nemo We Hula liwila oto anobo hamenalo ya Nowa nebo hamenalo wenina monatina molabo yamaidana oti mona molanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aya hamenalo ya wenina wetina-idafa no-ano noti, we wena mofu moloti, we wena adinalo li biti, yaidana-meidana mona molomo uti, u Nowa sipiku yoido yalo uwafa, ido no luta naba wilito ya lo fedoto muki li hopa o betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ido Loti hamenalalo yagi ayaidana oti wetina-idafa no-ano noti, idafa-adafa meina fiti, idafa-adafa hefanalo fuloti, yufa idafa hifiti, numunatina huti feti mino-mino omo yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Feti minafa, Loti Sodomu fulitoto wibo hamena yalo so yagi hefana salifa so libo yagi ho ibo yaidana oto okulumalo yati lumuto wenina muki li hopa o betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ido nemo We Hula li oloto pi betinobo hamenalo ya aidena wenina monawa molabo yamaidana oti feto anabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aya hamenalo ya we ma numunala obito minanaidoti ya lumuto uto huwamena-amenane lulau linowe, loto numunalau yowámanaiye. Ido ayaidana oto we ma minau minanaibo ya liwila oto idafane ma linowe, loto numudo aguwámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loti olonafo hala yagunu hatina ki fefe lalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Makafo eimola oto moloto aibo monala ya li hiki lo minanowe, loto holibo ya u hopa unogolaiye. Ido makafo eimola oto moloto aibo monala yagunu holiyámanaibo ya nomuna hofawa minowa-minowa anaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ha ma lobiyowe. Aya lubuka yalo loiti folomolo makolo uno minanaibo ya mako ma liti ido mako ma fulo edanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ido wena loiti maina onona li minanaidoti ma liti ido ma fulo edanabo ne.  ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ido we loiti migu minanaibo ma ya liti ido ma ya fulo edanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Feto lobito, emotina ya lomuwabo, Wenabao, hawa lanibo ya igaleka oloto pinaiye? loti loga o edato, liwila oto lobibo, Hono ula nedo yalo nama hiyala ya loti nuba o-o ae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ena Yesu ya ege-ege moniyabo we ya hamena-hamena Goti lomutiko minoti, awisa loti fulitámanae, loto wase ibo ha lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Feito lobibo, Numuna meya malo ha li fefe lo-lo aibo we ma nebo ya Goti holiya holiyámoto, ido weninafena yagi holi bito wa beti dowa molámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ido numuna meya ayau ya wena-hiyona ma nebo yakafo hamena-hamena ya ha li fefe lo-lo aibo we nedo ya uto ilalu huto feto loto lomu-lomu aibo, Uwotefokafo hane ya li fulo nedainako, yagunu hemo ya ane li faka lo nedo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Feto lito, wewa ya wena-hiyona hala hamena fana holi fulito nebo nefa, aliga lula-halau feto loto holibo, Nemo ya Goti holiya holiyámoto, ido weninafena yagi holi bito wa beti dowa molámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Feito nefa, wena-hiyona ya ilalu huto hamena-hamena loga lonumutoko minageto, awisa lotananako, yagunu ana li faka lanowe, loto holiye, loto Yesu ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ena Wenabakafo feto libo, Hemotina ya ha li fefe lo-lo aibo we monala fefe ladámibo we hala ya holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ido Goti wa molo betibo weninala ya fo lido midipu igu hamena-hamena ha naba loti lomu-lomu o minabo ya adina li faka ladámanaife? Ido hiyaba omo uwato aliga ya adina li faka lanowe, loto ladámanaife? ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","E'e, ha ona lobiyowe. Henemane oto adina li faka lanogolaiye. Feito nefa, nemo We Hula anobo hamenalo ya mikalo holi hikitina nomabo wenina ya li oloto pinofe? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ido Yesukafo wenina maleka eimotinagunu holiyabo, Mona fefe lotoko molo minone, loti wenina malekama muki ya holi fulo betiyabo wenina ya wase ibo ha magi feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","We loiti ma Goti lomunoiye, loti fele huliyagi numuna nabau yoibo, ma ya Falisi we, ido ma ya hefana takisi li-li aibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ido Falisi wema ya sinoi minoto, eimolagunu ya holito feto lomuibo, Aiyo, Gotiyo, wenina malekama ya ugele noti, mona nosámibo-asámibo moloti, hume-ugele abo mona molabo we, ido hefana takisi li-li aibo we me ya nebo yaidana oto minámonako, yagunu dowae, lalowe, loto lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nemo salele mako lulau fo hamena loiti wene-idafa moi ito námoto minoto, huwamena hofawa lito wa nobo idafa yauti mau naini (9) ya neimone limo uto ido mau mako (1) ya humu-humu obo ne, loto feito lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Feto lomuifa, ido hefana takisi li-li aibo we faiga youmaleka sinoi minoto, okulumau wenu wa faka ladámoto, ikiyalo hesoba ito, feto lomuibo, Aiyo, Gotiyo, nemo lifimane nebo we ya minowe. Yagunu milumane holiyo, loto libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Feito lomuibo we ya Gotikafo monaka fefe libo we minane, lo edaito numunalaloka wibo ne. Ido eito wema yagunu feito ladámiye, loto lobiyowe. Yagunu we ma eimola huliya li faka lo minanaibo we ya Gotikafo huliya ito lumunaibo ne. Ido we ma eimola huliya ito lumuto moni minanaibo we ya Gotikafo huliya li yoisa edanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ido olufo hefola Yesu nedo idipiti ato, anagunu atatinalo molanaiye, loti afa, ege-ege moniyabo we yasi hanu biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hanu biyafa, Yesu ya olufo hefola sutina fito, emo nedo li nuba o betito, feto libo, Olufowa yaidana oti minabo wenina ya Goti wehudi weninala hiyaba o betinako, yagunu nemodo anabo ya hanu hu betiyámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ha ona lobiyowe. We makafo olufo idafa aifa munabo idafa linaibo yaidana oto Goti wehudi weninala hiyaba o ledaibo monala ya liyámanaibo ya Goti hilala yau yowámanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ido hiyaba we makafo feto lomuibo, Api lilibiyanibo we dowa, nemo hofawa minomo yonobo mona ya linowe, loto holinobo ya nena mona molanobo ne? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Loga o edaito, Yesukafo liwila oto lomuibo, Neidafaito ya we dowae, loto lo nedane? We dowa ma ya minámiye. Goti yako dowa ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ena hemo lo molaibo ha moda holifefe loto holitanima ne. Feito libo, Hume-ugele ámo. Wenina hofo beti fuliyámo. Idafa ugele liyámo. Ha sugi lobiyámo. Okafo mekafo hulitina li faka lo, loto ha mono lufuwau (Kis 20:12-16, Lo 5:16-20) nebo ha ya holi minane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lomuito, liwila oto libo, Hipa hefola minobo hamenaloka yati hawa muki ya meyalo molomo uwowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Lomuito, Yesukafo hawa holitoto feto lomuibo, Hemo ya idafa mako mako feto feyananibo idafa ya aifa ne. Idafa-adafa muki wa nanibo ya hefanalo fuloto, hefana lito idafa wa námabo wenina hona molo biyageto ya okulumau huwamena wa nanogolane. Ido loto nege molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hawa lomuibo ya holitoto huwamena naba-naba wa naibo nenako lula-hala hena aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Feto feyaibo Yesu wa edoto lomuibo, Huwamena naba-naba wa nabo wenina ya Goti wehudi weninala hiyaba o ledaibo hilalau yonabo ya hosa naba finabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Safu-kameli yakafo naka hifiyau yonaibo ya hosa naba finaibo nefa, ido huwamena wa nabo wenina yasi Goti hilalau yonabo ya loto yoti hosa naba-naba finabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wenina ya hawa libo ya holititi feto labo, Feito nenako, yagunu wenina hema li nomudina wanaiye? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ya libo, Wenina yasi ya ogofuwámafa, ido Goti yakafo idafa-adafa muki feto feyanaibo ya moda ogofuto ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitakafo feto loto lomuibo, Lemo wa nonibo idafa-adafate muki ya moda fulitoto hege molone, lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ya lobibo, Ha ona lobiyowe. We makafo Goti wehudi weninala hiyaba o ledaibo yagunu numunala ebalafe, ido olonafofe, ido yalafo-unalafofe, ido olafo melafofe, ido olufolafe fulitanaibo ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya onesa nebo hamenalo idafa fulitaibo mulalo-mulalo yoto liwila oto munaibo ya lito, ido aliga hamena lo fedanaibo yalo ya minowa-minowa oto minomo yonaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ya ege-ege moniyabo we tuwelu (12) yako idipito anawaleka uto, feto loto lobibo, Lemo ya Yelusalemu yowogeto polofetite nemo We Hula yagunu lufuwa i molabo ha yama muki u ayalo inaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nemo We Hula ya anelo-hinelo liti eito feka wenina adinalo biyato, emotinasi hiya o nedoti, hamane hiti, etefu o nedoti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ikula hofo nedoti, hofo nedo fulinigilae. Ido fo hamena loitigi-makogi (3) uwageto fulinoguti ya hofa sinoinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Feto lobibo hawa muki ya holifefe loti holiyámae. Ha libo monawa ya li faluku betibo yagunu nena idafagunu liye? loti ya holifefe ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu monimo uto Yeliko li alili molaito, nomuna likaibo we ma ya hanu anawalo amedoto minoto, idafa wako lo-lo aibo wema ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ido wenina nuba naba hanu ayalo uti ha labo ya holitoto feto loto loga aibo, Yae, neidafa-neidafa feyae? loto loga aito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","feto loti lomuwabo, Yesu Nasalete numudoti aibo we ya monimo wiye, lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","wewa ya ha naba loto sula fito feto libo, Yesuwo, Defiti hipala, nemo milumane holiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Feto lito, wenina homu moloti uwabo yasi wewa hanu muti feto lomuwabo, Ha hedámoto mino, loti lafa, hofa su naba-naba loto feto libo, Defiti hipala, milumane holiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ha libo holito, sinoi minoto, wewa ya ilimiti minodo alo, lito ilimiti ato selo neto wewa ya Yesukafo loga o edaibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nemo ya hemo neidafa-neidafa fe nedanaiye, loto holiyane? Lomuito, liwila oto feto loto lomuibo, Wenabao, nomune wanowe, loto holiyowe, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu liwila oto lomuibo, Nomuga wao. Holi hikitanibo yakafo li faka lo hedaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lomuito, moda ayalo nomuna likaibo ya falatito, Yesu ege moloto Goti ebola lomo wiye. Ido wenina muki ya wa edoti emo yagi Goti ebola lomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ya Yeliko numudo uto, monimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ido yalo we ma huliya Sakiusi ya hefana takisi li-li abo we hiyabatina we naba minoto, idafa wa naibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ido wewa yakafo Yesu ya igaidana we ne? loto wa edanowe, loto holifa, we fouma nenako, wenina nuba naba minagu minoto wa edofefe ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yagunu Yesu unaidoka hanu youmaleka ya oluloto homu uto, wa edanowe, loto ya yá sigoloku yoto ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Neto, Yesu aya ebalo lo fedoto wa faka loto wa edoto, feto libo, Sakiusiyo, aloko liwila oto mikalo lomo. Nemo eletifo ya hemo numunakau minanowe, loto holiyowe, loto lomuito ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ayalo henemane oto liwila oto lumuto, lula-hala ake ito, aiyo-weiyo lo edoto, ilimito numunalauka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wito wenina muki ya wati, holi nosámibo muti feto labo, Aiyo, lifimala nebo we numunalau yoto yalo unanogolaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Feto lafa, Sakiusi sinoito, Wenaba ya feto lomuibo, Wenabao, moda holiyo. Onesa melo nemo huwamenane muki hona moloto filiga ya idafa wa námabo wenina binowe. Ido we ma ha sugi lomuto idafala mako ma ugele liyobo ya mulalo-mulalo moloto liwila oto idafa fo (4) yaidana munogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ido Yesukafo feto libo, Wewa yagi Abalahamu yufa figu yauti nenako, eletifo Gotikafo numunawau minabo wenina li nomudina waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Feito nemo We Hula wenina moni faluku abo wenina ya moni wita aito li nomudina wanowe, loto obo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hawa ya holi minato, Yesu Yelusalemu li alili aiye yagunu wenina Goti wehudi weninala hiyaba o ledaibo mona ya onesa feto-namato oloto pinaiye, loti holiyato Yesukafo wase ibo ha ma onu ito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huliya nebo we ma eba faigalo uto minoto, mikalo hiyabatina we wehudi buli nedato, liwila oto anogolowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","houba-nabala we minaguti ya teni (10) sutina fito, ato Giliki hefana huliya mina mako ya muki bito feto lobibo, Hefanawa biyobo ya liti hefanagunu onona limo uwato liwila oto anowe, lototo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wifa, ido hiyaba o betibo wenina emogunu holi nosámibo muti, wewa wido ya hiyabate we wehudi minanaiye, loto holiyámone, loto hawa fulanune, loti wenina ma egeka idipi molato uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Uwafa, ido hiyabatina we wehudi bulito, aliga ya liwila oto aiye. Liwila oto loto hefanane biyobo weunawa nenaki li homi abo ya holinowe, loto houba-nabala we sutina fito ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Homu aibo we feto loto lomuibo, Wenabao, hemo hefana mina nomanibo yakafo onona lito hefanaka weunawa teni (10) magi li molo hedobo ya ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Feto lito, hiyaba we ya feto lomuibo, Houba-nabane weyo, ononaka dowa loto wa owe. Hemo idafa hefola efoma ya hiyaba dowa laninako, numuna meya teni (10) ya hiyaba anane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lomuito, ido houba-nabala we naba tu ya loto feto libo, We nabao, hemo hefana mina nomanibo yakafo onona lito hefanaka weunawa faifu (5) magi li molo hedobo ya ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Lomuito, hiyaba we ya feto lomuibo, Numuna meya faifu (5) ya hiyaba anane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Feto lomuito, houba-nabala we ma loto feto lomuibo, We nabao, hemo hefana mina nomanima lafo-lafoku yau wase ito faluku oto molobo me ya ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hemo luka-haka ito anibo nenako, holika holiyowe. Ido idafa ma idafaka minámibo ya aifa li-li anibo ne. Ido idafa migu hifiyabo idafa hifiyámanibo ya aifa hofu-hofu anima ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Feto loto lomuito, hiyabala we yakafo liwila oto lomuibo, Houba-naba we hafali nosámanibo, heimoka ha lanibo yakafo li halo hedanogolowe. Nemo lune-hane itoto, idafa ma idafane minámibo ya aifa li-li oto, ido idafa migu hifiyabo idafa hifiyámobo ya aifa hofu-hofu obo ya moda holitabe? Olo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Feto loto holiyanibo ya liwila oto anaibo hamenalo ya hefanala weunagi linaiye, loto hefanane homobo ya hefana molo-molo abo numugu ya neidafaito molo nedámane? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Loga o edoto wenina selo sinoi minabo ya feto loto lobibo, Hefana anau li nebo ya ipoti liti hefana mina teni (10) wa naibo we ya muilo, loto lobito ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","emotina yasi liwila oti lomuwabo, We nabao, emo ya hefana mina teni (10) ya moda li nema ne, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","liwila oto feto loto lobibo, Idafa ma wa nabo wenina muki ya magi onu ito binaibo ne. Ido idafa ma wa námabo wenina idafa hefola wa naboma ya emodokati ipo anaibo ne, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ena uwonefo-mota nemogunu ya mikalo we hudite minanaiye, loti holiyámabo ya idipiti oti nemo nomunelo ya hofo beti fulilo, loto libo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ena Yesu ya hawa ya lobi hulototo Yelusalemu unowe, loto homu moloto yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Monimo yoto obula huliya Olifi obula yalo Betefage ido Betani numuna li selo moloto ege-ege moniyabo we loiti homu idipi moloto feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hemotina numuna meya youmalo uti yonaido ya safu-dogi mofola meyalo moniyámabo nala iyabo minanaibo ya wa edoti nalalo wina oti liti melo liwila oti aliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ido we makafo, Hemotina ya neidafaiti nala ya wina aiye? loto loga o betitoma, feto lomuilo, Wenaba ononala ma neto yagunu lito oiye, loti lomuliyo, loto lobito idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Idipi molaito, wewa loiti ya monimo uti idafawa muki Yesu lobiboidana oto oloto pi bito wa edoti ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","uti safu-dogi mofola ya nala wina neto yawala yasi oti lobiyabo, Hemotina ya neidafaiti safute-dogi mofola ya nala wina minaiye? loti loga o betiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","liwila oti lobibo, Wenaba ononala ma neto yagunu lito oiye, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Feto loti safu-dogi mofola ya ilimiti Yesu nedo ya loti utinalo owo mulalo holoiyabo ya li fuloti safu-dogi mofola meyalo ya moloti Yesu ana li faka lato meyalo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yoto minoto monimo wito wenina yasi utinalo owo feka holoiyabo ya li fuloti hanudo unaido holaleka wilimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Feto feyato, Yelusalemu selo Olifi obula fulitoto waka youmaleka wibo hanudo ya aito, ege molabo wenina muki nuba naba yasi ake naba iti, Goti aubala itibibo idafa muki oloto pi betibo ya wa edabo yagunu ha naba-naba loti Goti ebola loti, huliya li faka loti feto labo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aiyo, hiyabate we wehudi Wenaba huliyalo aibo we ya dowa loto holimo wibo ne. Ido okulumau you amena mona ya oloto pito, yoisau okulumau minabo yagi ayaidana oti huliya li faka lo-lo ae, loti ya lomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wenina nuba naba minagu yauti Falisi we masi Yesu feto loti lomuwabo, Api lilibiyanibo we, hege molabo we ya lo fuko betiyageto wetina itoti minanae, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","liwila oto lobibo, Nemo ha lobiyowe. Ha ladámatoma, hefana yasi hai molanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ena Yesu monimo uto, Yelusalemu li alili moloto, numuna meya naba ya wato wenina yau minabo hufotina o betito ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","feto libo, Aiyo, eletifo onesa melo nemokafo li you amena mona molo betinobo mona ya heimotina holifefe loti holi minabo neko, dowa ladi ne. Nefa, onesa idafawa li faluku betibo yagunu nomudinagunu ogofuti wagámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ogofuti wagámato, hamena ma anaibo yalo ya hemotina uwotinafo-mota numuna meya naba hilalo hefana koli molomo yoti yalo yoti li hona o betiti hanu muki unagu-unagu lotana ito betinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ido numunatina meya muki ya luko-mako oti li hopa o edoti we wena olufotina muki minabo ya hofo beti fulinabo ne. Gotikafo li nomudina wanowe, loto aibo hamenala ya holifefe loti wa edámabo nenako, yagunu hefana ya hefana ma mulalo nebo ma minámanaibo ne, loto libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ena Yesu fele huliyagi numuna naba hilalau yoto wenina idafa hefanalo fuloti minabo ya apito heni betido feka aito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Numunane ya ha lonumu-numu abo numunae, loti lanabo ne, loto ha mono lufuwau (Ais 56:7) ya nebo nefa, hemotina yasi li ugele we numunatina yaidana o minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ido hamena-hamena ya fele huliyagi numuna nabau api itibibo wifa, sokila hi muwabo we hiyabatina we, ido lo molaibo ha api itibiyabo we, ido wenina hiyabatina we yasi Yesu hofo fulinabo hanu ya moni wita afa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","wenina nuba minabo ya auba iti ha libo ya holiyanako, yagunu hofo fulinabo hanu ya li oloto piyámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hamena ma Yesu ya fele huliyagi numuna naba hilalau ya wenina api itibito hawa ukuwa dowa lo oloto molaito, sokila hi muwabo hiyabatina we, ido lo molaibo ha api itibiyabo we, ido wenina hiyabatina we yagi emodoka loti ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","feto lomuwabo, Hemo idafawa fe-fe minanibo ya hema welaloti holito fe-fe ane? Hemakafo lohumito fe-fe ane? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","liwila oto lobibo, Nemo yagi ha ma loga o betinogolowe. Lonumilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoni ya hema welaloti wenina noku i betiye? Okulumau nebo we welaloti nefemo, ido wenina wetinaloti nefe? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Loga o betito, eimotina loyolalo-melo oti feto labo, Lemo ya okulumau nebo welokati ne, loto lanubo ya emokafo ya, Aiyo, hemotina ya neidafaiti holi hikito umámae? loto lolumunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ido weninalokati ne, loto lanubo ya wenina muki yasi holiyabo Yoni ya polofeti ne, loti holiyama nenako, hefanagunu hofo ledo fulinigilae, loti holiyabo yagunu ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","liwila oti lomuwabo, Igalekati ne? Lemo holifefe ladámone, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesukafo libo, Nemo yagi hema welaloti meleka idafa feyobo ya lobiyámanogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ido Yesu ya wenina muki wase ibo ha apito feto lobibo, We makafo nala waini hifiyobo mine ya hiyaba o minanune, lanabo meina numunae, loto ononawa adinalo molo itoto mika faiga uto yalo hamena fana ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Neto, ilawa inaibo hamenalo ya houba-nabala we ma mineuti ilawa malekama muwato lito anaiye, loto mina hiyaba o minabo we minado ilifi molaito, u fedifa, hofoti, idafa ma umámoti, heni edato, aifa liwila oto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Liwila oto aito, houba-naba we ma ilifi molaito, minadoka wifa, emogi hofoti li nosámibo o edoti idafa ma umámoti heni fulo edato aifa liwila oto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Liwila oto aito, houba-nabala we mama ilifi molaito, minadoka wifa, ayaidana oti hofo edoti ula li nosámibo o edoti itifuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Itifuwato, nala waini mina yawala yakafo feto loto libo, Neidafa-neidafa feyanowe? Hipane lune-hane muwobo we ya minado ilifi molanowe. Ilifi moloto unaibo ya hala holinigilae, loto holito ilifi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ilifi molaito, minadoka wifa, wa edoti loyolalo-melo oti feto labo, Wewa aibo yakafo melafo fulinaibo hamenalo idafa-adafala weuna fi edaibo ya linogolainako, yagunu hofo fuliyokelo. Leimote melafo fulinaibo hamenalo ya weuna fi edaibo idafala muki ya linogolone, loti ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ya analo-hinalo liti nala waini migu yauti li fulo feka iti hofo fuliyae. Yagunu hemotina hatina kiyalo. Nala waini mina yawala yakafo neidafa-neidafa o betinaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Emokafo minado uto ya nala waini mina hiyaba o edabo wewa muki ya hofo beti fulito, migu ononawa ya eito wenina adinalo molanogolaiye, loto lobiye. Lobito, hawa holiyado feto labo, Ei, feto ámanaibo ya dowa ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Feto lato, Yesukafo wenu wa betito, feto loto lobibo, Hefana ya numuna huwabo wenina wa edo aifa idafaidana itabo nefa, ido aya hefanawa yama moda numuna lagi hola fibo ne, loto ha mono lufuwau (Sng 118:22) nebo hawa monala ya hemotina igaidana oti lanabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Holilo. We makafo hefanawama yalo lumu fou lanaibo ya aubala leko-mako oto li hopa anaibo ne. Ido hefanawa yakafo we ma meyalo limo inaibo ya wewa ula ya metala-atala anaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Feto lobito, lo molaibo ha api itibiyabo wegi, ido sokila hi muwabo we hiyabatina wegi ya Yesukafo wase ito hawa libo ya eimotina lo betibo ha holititi, ayalo analo-hinalo linune, loti hanu ya moni wita afa, wenina holitina holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ena hiyaba abo ya wenina maleka ya momona oti idafa ma anaido wa edanae, loti idipi molae. Idipi molabo weninawa ya monate fefe libo wenina minone, loti sugi idafa feyae. Feyabo ya Yesu ha lanaibo ya holito sigiya lo edanubo mona ma moni wita oto, li oloto pito ilimito uto gamani hiyaba we wenaba analo molanune, loti holiyabo yagunu ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","feto loti loga o edabo, Api lilibiyanibo we, holiyonibo ya hemo ha onako loto mona fefe liboko api itibi-itibi anibo ne. Ido wenina molo yoilumu o biyámane. Ido Goti hanulalo moninubo mona ya ona fefe loto api lilibi-lilibi o minane, loto holi minone. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yagunu lageto holinune. Hiyaba we wenaba Sisa hefana takisi mu-mu onibo mona ya fefe loto nefe? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Feto loti loga o edato, hepa molo edabo holito feto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Hefana denaliyasi ya nilibilo. Weunagi lufuwalagi hefanawalo nebo ya hema idafala ne? loto loga o betito, liwila oti feto loti labo, Ya Sisa weunagi lufuwalagi ne, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","feto lobibo, feito Sisa idafala liti ya Sisa liwila oti muilo. Ido Goti idafala liti ya Goti liwila oti muilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ido emotina yasi Yesu ya wenina nomudinalo ha lanaibo ma liti sigiya lo edanabo ha ma ogofuti oloto piyámae. Ido liwila oto ha lobibo holiti elegiti, ha ladámoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ena Sadusi we maleka wenina fuliyaguti hofa sinoiyámanabo ne, loti holiyabo wenina ya Yesu nedo loti feto loti loga o edabo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Api lilibiyanibo we, Mosesekafo mono ha lufuwau feto loto libo, We ma olufola hedámoto fuliyagetoma, olonafo hofawa neto unalafo wena-hiyona ya lito yalafodo olufo li oloto pi edanaiye, loto libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yagunu we ma hipala seweni (7) minagu yauti homu we yakafo wena lifa, olufola hedámoto ya fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ido fulibo we unalafo makafo wenawa lifa, ayaidana oto fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Fulito, aliga unalafo naba tili (3) yakafo lifa, fuliye. Feti hipawa seweni (7) yama ayaidana oti liti olufola ma hedámoti fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Fuliyato, ido aliga wenawa yamagi fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ena fuliyaguti hofa sinoinabo hamenalo we seweni (7) ya wenawa liyaboma nenako, yagunu aya hamenalo ya hema olonafo minanaibo ne? loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesukafo liwila oto feto loto lobibo, Onesa hamena melo minabo wenina ya we wena mofu moloti, we wena adinalo li bi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Feto feyafa, ido aliga hamena naba fedanaido yalo Gotikafo wenina maleka yagunu feto libo, Monatina fefe libo wenina fuliyaguti hofa li sinoi betiyoto nemogi minanae, loto lo betibo wenina ya we wena mofu molámoti, we wena adinalo li biyámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aya weninawa ya enisole yaidana oti hofawa minomo yoti ya hofa ogofuti fuliyámanigilae. E'e, ido fuliyaguti li hofa sinoi betibo nenako, Goti olufola minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ido Mosese yagi yá hefolalo so libo hala ya lufuwa igu yau Wenaba hala yagunu feto libo, Nemo ya Abalahamu Gotila minoto, ido Aisaka Gotila minoto, ido Yekopu Gotila ne, loto ha mono lufuwau (Kis 3:6) nebo ha yakafo wenina fuliyabo ya fuliyaguti hofa sinoinae, loto api lilibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yagunu emo nomunalo weninala muki ya hofawa minomo yowabo nenako, Goti ya fuliyabo wenina Gotitina minámifa, hofawa minabo wenina Gotitina ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Feto loto lobito, lo molaibo ha api itibiyabo we malekamasi liwila oti feto lomuwabo, Wenabao, hemo ha lageto dowa liye, loti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","holi bito hofa loga-miga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ena Yesukafo ya feto loto lobibo, Goti ilifi molaibo we Kilisto ya Defiti ouwamela ne, loti lo minabo ya neidafaiti lae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Defiti eimola yakafo Mono Nama lufuwa iyagu yau feto loto libo, Wenaba yakafo Wenabane ya lomuibo, Ane onaleka amedoto hiyaba oto minageto, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ya uwokafo-mota fulo higa feumau betinogolowe, loto libo ne, loto ha mono lufuwau (Sng 110:1) ya libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Feito Defitikafo ya Wenabane ne, loto linako, igaidana oto emo yufa figuti nebo ne? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wenina muki ha libo holi minado Yesu ya ege-ege moniyabo we feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Hemotina ya lo molaibo ha api itibiyabo we yagunu wati hiyaba oti monilo. Emotina yasi utinalo owo fana-fana holoiti moniti, ido maketilo ya wenina wa ledoti aiyo-weiyo lolumunae, loti holiti, ido mono numugu yowabo ya wenina nomudinalo folomo welalo yako minanune, loti holiti, ido wetina-idafa nanune, loti abo hamena ya folomo welalo homu yaloko minanune, loti holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ido wena-hiyona numunatina idafa-adafatina aifa liti, ido wenina wa ledanae, loti ha fana-fana Goti lomu-lomu o minae. Aya weninawa ya lifima ha naba-naba liwila oto binogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ya wa faka loto idafa-adafa wa nabo wenina yasi hefana ya fele huliyagi numuna nabau hefana-huwamena yau fulo minabo ya wa betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wa betito ido wena-hiyona ma idafala minámibo ya loto hefana luta hefola loitiko ya wani (1) toya yaidana oto fulaibo yagi wa edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wa edoto feto loto libo, Ha ona lobiyowe. Wena-hiyonawa idafala minámibo hefanala fulaibo yakafo wenina malekama hefanatina fulaboma ya li fulo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aya wenina ya idafa-adafa wa nabo yauti fulato, idafatina muki aifa nefa, ido emo idafala minámigu yauti ya idafa hefola efoma mino edaido muki moda fulo hulito ya ma minámiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ena ege-ege moniyabo we malekamasi weninasi hefana lali-idafa molabogi, ido Goti lutina-hatina muti muwabo idafagi yakafo fele huliyagi numuna naba ekeni li edabo ya wati lomo uwafa, ido Yesukafo lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Idafawa me ya wabo ya hamena aliga oloto pinaibo hamenalo hefana makafo hefana ma mulalo nebo ya waitámoti, muki ya holi-makoli anigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ido emotina yasi feto loti lomuwabo, Api lilibiyanibo we, idafawa ya nenafeko fedanaiye? Ido nena mebe-maba oloto piyageto idafawa ya moda alili molaiye? loto holinune, loti loga o edato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","liwila oto feto lobibo, Hemotina hote itanae, loti wati hiyaba oti monilo. Wenina abi loti ya loti huline liti feto lanabo, Nemo ya wewa ya minowe, loti ido, Hamena naba ya moda alili aiye, loti lanigilae. Hemotina ya weninawa ya egetina molámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ido fina ha ido lowa ha holitima, holi biyámaneyo. Idafawa ya homu oloto pinogolaifa, mika okuluma hulanaibo hamena ya ayalo fedámanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ido ha ma onu ito lobibo, Ido wenina mikau-mikau fina lowa fimo uwato, ido mikalo hiyaba we ma weninalagi ido hiyaba we ma weninalagi lowa fina fimo unabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ido mika mima naba-naba anaiye. Ido inagunu naba fedanaiye. Ido eba maleka idafa hilinabo idafa nosámibo-asámibo oloto pinaiye. Ido idafa mona-mona holi naba-naba binaibogi, ido okulumaloti mebe-maba naba-naba yagi ya oloto pinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Idafawa muki ya oloto piyámageto hemotina adinalo-hidinalo liti li nosámibo o betiti, idipiti mono numuna hiyaba wegi ido nala numuna hiyaba wegi adinalo molanabo ne. Ido mikalo wehudigi wenina hiyabatina we wenabagi nomudinalo ya sinoi betinigilae. Hemotina nemo huline li minabo yagunu feto fe betinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Feto fe betinabo hamenalo ya hemotina hala ukuwa dowa ya lo oloto molanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hemotina lo oloto molato, sigiya lo betinado nena ha liwila oto lobinubo ne, loto hate loiti-loiti kiyámanune, loti auba iti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Neimone yakafo wetinalo ha moloto ido manadinau molanobo ha ya uwotinafo-mota yasi hatina iti lumuti li fulo betinune, loti lanabo ya ogofuwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hemotina ya otinafo, metinafo, yatinafo unatinafo-mota ido minabo yufa weninatina, ido yotinawe-mota yasi uwotinafo-mota adinalo molato, minagu yauti maleka ya hofo beti fulinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ido hemotina ya weninane minanako, wenina muki lutina-hatinau holi nosámibo-asámibo binigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Feto feyanigilafa, manadina opala mako ma ya u hopa ámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","E'e, hemotina mino auba iti minanabo ya hofawa minomo yonabo mona oloto pi betinogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ido ha ma onu ito lobibo, Ena himiwe nuba naba yasi loti Yelusalemu li hona anabo wa betinado ya moda u hopa unaibo hamenala alili aiye, loti ya holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aya hamenalo Yudia mikalo minanabo wenina ya obulaleka holi wilalo. Ido numuna meya nabau minanabo wenina ya ebawa fuloti wilalo. Ido migu minanabo wenina ya numuna meya nabau yowámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aya hamenawalo ya lifima ha liwila oto binaibo hala lufuwa iyabo muki yama u ayalo inaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ido aya hamenalo aiyo, wenipa olufo houmatinau nebogi, ido wenipa olufotina amina no minanabogi ya hena naba-naba holinigilae. Ido wenina muki mikawa melo minanabo ya hena naba holiyato, Gotikafo weninawa lifima ha liwila oto binaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ido uwotinafo-mota yasi hofo-hofo beti abo mi yakafo hofo beti, ido nala i betiti, idipiti mikau-mikau unigilae. Ido eito feka wenina yasi Yelusalemu mikalo hidina lala imo moniyato, hamenatina hulageto hofa lala iyámanigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ido ha ma onu ito lobibo, Ena fo, igana, ofiya yalo mebe-maba oloto pinogolaiye. Ido mikalo wenina mikau-mikau minabo yasi ho nokafo sato moloto naba-naba aibo nola naba lanaibo ya holiti hatina ligi-ligi kiti holi naba binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ido okulumalo idafa nebo ya momoga anaibo nenako, wemoli mikalo idafa ma oloto pinaibo wanune, loti hiyaba o minanabo ya holi naba-naba biyageto, fuliyabo yaidana oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aya hamenalo We Hula nemo ya okulumalo limuku lo fedoto aubane nabagi, ido lamena nabagi oto wa nedanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aya idafawa apito oloto pinaibo, meina fito wina betiyobo hamena moda selo molo nenako, yagunu sinoiti wa faka lalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesukafo wase ibo ha feto loto lobibo, Hemotina ya yá sigologi ido yá malekama muki wati monatina holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yá aila hofawa inaibo, heimotina ya wati, ayalo fo lanaibo hamena selo molaiye, loti ya holi-holi ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Feito idafawa lobiyobo yagi oloto pito, hemotina wa edo minanabo, Goti we hudite weninala hiyaba o ledaibo hamenala selo molaiye, loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ha ona lobiyowe. Hamena onesa me ya minabo wenina maleka fuliyámato ya idafawa muki lobiyobo ya oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Holilo. Mika okuluma ya hulanogolaifa, nemo hane ya minowa-minowa omo yoto huladámanaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hemotina ya wati hiyaba oti monilo. No-ano wetina-idafa naba nato, nomudina monito hatina-manadina u hopa unaibo mona, ido utina etuwa idafa yagunu hatina abi kiti, lutina-hatinau hena naba-naba holitanae, loti hamena naba yakafo helefu hu liyabomaidana oto haita oloto pi ledotanaiye, loti wati hiyaba oti monilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Feito aya hamenawa ya wenina muki mikau-mikau minanado yalo ya oloto pinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yagunu idafawa oloto pinaibo li yoima o ledotanaiye, loto ido We Hula nomunalo ogofuto sinoi minanogolone, loto ade li faka lo, loti hamena-hamena wati hiyaba oti moniti Goti lomumo yoilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ido hamena-hamena Yesu ya fele huliyagi numuna nabau ya api itibi-itibi o neto, lunaga molaito, numuna meya fulitoto Olifi obulalo yoto yalo ya lubuka mino-mino aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Feto fe neto ho lito wenina muki ha lanaibo ya holinune, loti fele huliyagi numuna nabau loti nuba ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ena folima ya beleti lifefe loti pupu libo idafa yisi molámoti aifa hiti no-no abo foliwa huliya Uta o Betibo hamena ya alili molaito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Goti sokila hi muwabo we hiyabatina wegi, ido lo molaibo ha api itibiyabo we yagi ya wenina holitina holiyanako, yagunu Yesu ya igaidana oto hofo fulinune? loti hanu ma moni wita omo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Feti minato, Yesu ege-ege moniyabo we tuwelu (12) minagu yauti we ma huliya Yudasi huliya ma Isikaliyoti nebo ya Satanikafo lulau yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Lulau yoito, Yudasikafo Goti sokila hi muwabo we hiyabatina we ido fele huliyagi numuna naba himiwe hiyabatina we minado uto Yesu ya adinalo molanaibo ha ya lobito, maina loyolalo-melo o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Loyolalo-melo o minoti, lutina-hatina ake naba-naba iti ya hefana humunune, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O, loto wenina naba minámabo hamenalo Yesu uwolafo-mota adinalo binowe, loto hiyaba o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ena folima ya beleti lifefe loti pupu libo idafa yisi molámoti aifa hiti no-no abo hamena ya oloto piye. Aya hamenalo ya Uta O Betibo hate molotanaiye, loti sipisipi mofola ya hofoti no-no ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yagunu Yesukafo Pitate Yonite feto loto idipi molaibo, hemotina ya uti Uta O Betibo hobina nanubo hofo hinaiye, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","liwila oti feto lomuibo, Numuna igau hofo hinoiye? loti loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","feto loto lobibo, Holiliyo. Hemotina numuna meya nabau yonaido ya we ma no fi-fi abo masa mofuto anaibo we ya hatula oti, ege moloti wiliyo. Ido numunalau yonaibo ya ayau yoiliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yoti numuna yawala feto lomuliyo, Api lilibibo wekafo nege-nege moniyabo wegi Uta O Betibo hobina nanubo eba igau ya ne? loto loga o hedaiye, loti lomuliyo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Feto lomunaibo ya eba naba ma folomo hunu-anu wiliyabo eba ya itibiyageto yau wete-idafa hofo hiliyo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lobito, fulo edo itoti uti, Yesu libo idafawa yaidana li oloto piti, Goti Uta O Betibo wetina-idafa hofo hiyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ena hamenawama lo fedito, Yesugi ido aposolola yagi idafa nanabo folomolo amedoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amedoti minato, feto loto lobibo, Miluma holinobo hamenane alili aibo yagunu homu ya Uta O Betibo wete-idafa meya hemotinagi nanune, loto auba ito holiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ido aya yagunu ha ma lobiyowe. Nemo ya Uta O Betibo wete-idafa hofa námoto Goti wehudi weninala hiyaba o ledaibo ebalo Uta O Betibo mona ona ya anaido yalo hofa nanowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lobito ya nomu litoto, dowae, lalowe, loto lomuto ya feto lobibo, Hemotina liti minagu ya hona molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ha ma lobiyowe. Nemo ya no waini hofa námoto Goti wehudi weninala hiyaba o ledanaibo hamena oloto pinaibo yalo hofa nanowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Feto lobito beleti lito, dowae, lalowe, lomuto ya lekoto bito feto loto lobibo, Me ya ya nemo une nebo ya hemotinagunu mu minowe. Monawa feti molanabo hamenalo ya hatina ki numuti feti molomo yoilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ido aliga no hulotiti ya nomuma yagi ayaidana oto lito feto lobibo, Nomu meu ya nemo lunune ya Gotigi li hutifina betibo ha hofawa li auba i edaibo lunune ya hemotinagunu lekinobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Feito nefa, nemo uwonefo-mota adinalo molanaibo we ya nemote folomolo melo ya maina wete-idafa no minoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","We Hula nemo ya Gotikafo, Feto feyanane, loto libo welalo ya molanogolofa, ido uwonefo adinalo molanaibo we ya aiyo, lifima ha naba-naba liwila oto linaibo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Feto loto lobito, eimotina minagu yau, Hemakafo ya feto feyanaiye? loti loga-loga ae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ena ege-ege moniyabo we yasi moliya fi filiga-filiga oti ya labo, Leimo yauti hema huliya u homu uto ne? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesukafo ya feto loto lobibo, Eito feka wenina mikalo hiyabatina we wehudi yasi wenina auba iti hiyaba o betiyato, ido hiyabatina we ma hulitina ya wenina hounatinafo-motae, loti molae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Feti molabo mona yaidana oti hemotina molámilo. E'e, hemotina minagu yauti huliya nebo we ya hemotina unatinafo aliga we yaidana oto minanaiye. Ido hiyabatina we ya houba-naba we yaidana oto minanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Holilo. We loiti yauti hema ya huliya nebo we ne? We ma amedoto minoto wela-idafa no nebo wefemo, ido houba-nabala we wela-idafa hofo hi munaibo we ne? Wela-idafa no nebo we ya huliya nebo we ne, loti holi minae. Feito nefa, ido nemo ya hemotina minagu minobo ya houba-nabatina we yaidana oto minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ido idafa-adafa muki hepa molo numunowe, loto fedibo hamenalo ya hemotina yasi fulo nedoiti aguwámoti nemogi maina mino-mino aboma wenina ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ido Menefokafo hiyaba we wehudi onona numibo yaidana oto nemo ya hiyaba we wehudi onona ya hemotina biyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nemo hiyaba we wehudi onona linodo yalo hemotina nemogi maina idafa noti, ekeni folomolo amedoti minoti, Isilaeli wenina afu monalo-monalo tuwelu (12) ya hona molo betiti weninawa hiyaba o betinae, loto ononawa biyowe, loto lobiyowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesukafo libo, Saimoniyo, Saimoniyo, Satanikafo suwa witi ilawa lilika iyabo yaidana oto hemotina ya lilika inofao, loto Goti lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ido nemo yakafo holi hikitanibo ya hulotanaiye, loto hemogunu holito Goti lomuwowe. Ido hemo elepa ito liwila oto ananido ya hounakafo-mota li aubafofo lo betiyo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Feto loto lomuito, liwila oto lomuibo, Wenabao, hemo nala fi hedanafe, ido hofo fulinafe, unanido ya maina unogolowe, lito ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesukafo libo, Pitao, lohomowe. Okolofokafo eletifo luwaila nola ladámageto hemo hamena loitigi-makogi ya wewa wa edámowe, loto huline li faluku nedanogolane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ena Yesu ya loga o betibo, Homu idipi moloto hefana otina, ido owo, ido hidinalo holoiyabo idafa ya liyámoti moniyabo yama idafa ma mino betiyámibo nefe? loto loga o edaito, liwila oti lomuwabo, Lemo ya idafa ma moni wita ámone, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lomuwato, emo feto lobibo, Feito ya nefa, onesa ya hefana owo wa nanabo ya liti, ido owo yagi liti, ido fina finabo mi wa námotima, utinalo owo ya hefanalo fuloti meina linabo yakafo fina finabo mi ya meina fiyalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lufuwa igu feto libo, Emo ya holiti holiyámoti abo wenina yaidana oto ne, loti wa edabo ne, loto ha mono lufuwau (Ais 53:12) nebo ha yama nemodoka hulawa anogolaiye. Ona, nemogunu lufuwa iyabo muki ya moda hulawa o hulanogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Feto lobito, ege-ege moniyabo we feto loti lomuwabo, Wenabao, lemo ya fina finubo mi loiti ya li minone. Wao, lomuwato, liwila oto lobibo, Moda ya ogofuiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ena Yesu ya hamena-hamena o-o aibo ya loto Olifi obulalo ya yoito, ege-ege moniyabo we ege uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ege uwato, ido ebawalo yama lo fedoto ege-ege moniyabo we feto lobibo, Hemotina ya mona nosámibo yakafo hepa molo ledageto ya lumu fou lotanune, loti Goti ya lomutiko minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lobito fulo betitoto emotinalokati monimo hefola ma uto, hina obula fito ya Goti feto loto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Menefo, miluma holiyobo kapu me ya ya li fulo nedo, loto holiyobo nefa, heimoka holinanido ya molo nedo, loto lomuiye.  ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Feto lito, okulumau yati enisole makafo oloto pi edoto auba muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ido Yesu ya lula-halau hena naba-naba holito, Goti ya auba ito lomumo yoibo hola-welalo ya hosa fibo ya lunu yaidana oto mikalo ya lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Feito lomu itoto ya sinoito, liwila oto ege-ege moniyabo we minado uto wa betibo ya lutina-hatinau hena naba aibo yagunu awisa loti uwo uno minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Uwo uno minabo ya feto loto lobibo, Hemotina neidafaito uwo uno minae? Mona nosámibo hepa molo ledanaido ya lumu fou lotanune, loti Goti lomu-lomu o minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu hawa ya feto lo neto, wenina naba mau minabo emodoka lo fedato, ege-ege moniyabo we tuwelu (12) yauti wema huliya Yudasi yakafo li homu moloto idipito Yesu nedo loto, mudo edanowe, loto selo aifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu ya loga o edaibo, Yudasiyo, We Hula nemo ya mudo nedananibo yakafo li uwonefo-mota adinalo molabe? loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ido Yesu ege molabo we ya idafa fedanogolaibo ya holiti feto loti lomuwabo, Wenabao, lemo ya fina fi-fi onibo mite yakafo hofo betinube? loti loga o edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","emotinalokati makafo sokila hi mu-mu abo we wenabatina houba-nabala we aibo migunu hala onaleka ya fuko fulitaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu ya idafawa wa edoto feto libo, Mona ya fulitalo, loto wewa hala ya lito li faka lo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ena Yesukafo Goti sokila hi muwabo we hiyabatina we, ido fele huliyagi numuna naba hiyaba abo himiwe hiyabatina we, ido we kilofo hulitinagi we ya, analo-hinalo linune, loti lo fedabo ya feto loto lobibo, Hemotina holiyabo nemo ya ugele wenaba ne, loti holiti migi, ido mainafagi liti minodo afe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hamena-hamena ya fele huliyagi numuna naba ebalo hemotinagi minobo yama anelo-hinelo liyámaboma ne. Anelo-hinelo liyámabo nefa, onesa me ya hamenatina neto ido midipu ibo hiyaba we hamenala ya ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ena emotinasi Yesu analo-hinalo liti, ilimiti uti sokila hi mu-mu abo we hiyabatina we wenaba numunalau yowae. Yowato, Pita ya faigato moloto egetina monimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Egetina uto numunawa hilalau ya yoti, so hiti labi oti minado ya Pita ya u ayau keloto minagu ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Neto, houba-naba olu makafo loto so lamena aido yalo amedoto nebo ya wa edoto, wenu wa edofefe loto feto libo, Wewa me ya emogi maina minanima ne, loto lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ido Pita libo, Oluwo, nemo emo wa edámoboma ne, loto li faluku oto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lomuito, ido aliga hefolama ya we makafo wa edoto feto loto lomuibo, Hemo yagi hounalafo-mota minagu yauti ya minane, loto lito, liwila oto lomuibo, We meyala, nemo ya feito minámowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Feto lomuito, ido aliga wani (1) auwa yaidana oto minoto, we ma loto lo gedoto libo, Ya ona lowe. Wewa me ya Galili we nenako, Yesugi nebo ya ne, loto lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita liwila oto lomuibo, We meyala, ha lanibo ya holifefe loto holiyámowe, loto lo nedo ayalo okolofo kokololo liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kokololo lito, Wenabakafo liwewe oto Pita wenu wa edofefe loto wa edaito, ha homu feto loto lomuibo, Okolofokafo eletifo luwaila nola ladámageto hemo hamena loitigi-makogi huline li faluku nedanogolane, loto lomuibo ha ya holito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","feka uto hufo naba-naba aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ena Yesu hiyaba o edoti minabo we yasi hamana hiti ya hofo edo minoti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","lafo-lafogunu nomunalo itoti lomuwabo, Polofeti ha lolomo. Hofaibo we ya hema ne? loti loga o edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ido ha nosámibo-asámibo ha muki ya lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ena ho lito leda Yuda wenina we kilofo hulitinagi wegi, ido Goti sokila hi muwabo we hiyabatina wegi, ido lo molaibo ha api itibiyabo wegi ya kanisole nuba oti minado Yesu ya ilimiti uti nomudinalo li sinoi edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Li sinoi edato, feto loti loga o edabo, Hemo ya ilifi molaibo we Kilisto minagetoma, lolomo, loti lomuwato, liwila oto feto lobibo, Nemo ya hemotina lobiyotoma, holi hikito nomámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ido loga o betinobo ya liwila oti lonomámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Feito nefa, onesa hamena melekati We Hula nemo ya Goti aubafofo libo we ana onaleka amedoto minanogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Feto loto lobito, emotinasi loga o edabo, Yagunu ya hemo Goti Hipala minabe? loti lato, liwila oto lobibo, Heimotina, feito minane, loti labo ya ha ona lae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Feto lobibo hawa ya holiti feto labo, Leimote ya neidafaito ha magi ya holinubo ne? Eimola welaloti ya moda holiyone, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ena mau minabo wenina muki ya sinoiti, Pailati nedo ilimiti ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","uti, sigiya feto loti labo, Aya we yamo lemo Yuda wenina muki li hopa o ledo nebo we ya li oloto piyone. Emokafo feto libo, Hemotina hefana takisi Lomu hiyaba we wenaba Sisa umámanae, loto lobiye. Ido, Nemo nilifi molaibo we Kilisto ya hiyaba we wehudi ya minowe, loto feto lo ne, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Feto lato, Pailatikafo holito feto lomuibo, Hemo ya Yuda wenina hiyabatina we wehudi minabe? loto loga o edaito, Yesukafo liwila oto libo, Ona lane, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailatikafo Goti sokila hi muwabo we hiyabatina we ido wenina muki mau minabo ya lobibo, Nemo ya wewa lifimala moni wita oto li oloto piyámowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lobifa, ilalu huti lo gedoti lomuwabo, Wewa yakafo api itibibo hala yamo Yudia mikalo minabo wenina muki lutina-hatina li hopa o betimo wiye. Li hopa o betibo ya Galili mikalo yaloti apito itibimo aibo loto onesa melo ya fediye, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailati ya hawa holito feto libo, Wewa ya Galili we nefemo? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ido Heloti hiyaba aibo ebalaloka yati aiye, loti labo ya holito, Heloti ya onesa Yelusalemu nema nenako, emo nedo ilimiti unae, loto idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Idipi molaito, Heloti nedoka ilimiti lo fedato, Heloti ya hamena fana Yesu hala holi-holi o nebo nenako, wa edanowe, loto holito wa edoito ake naba-naba ito, Goti aubala nilibinaibo idafa ya li oloto pi nedageto wa edanowe, loto holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Feito holi minoto Yesu loga-miga o edomo wifa, liwila oto ha ladámoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ha ladámoto neto, Goti sokila hi muwabo we hiyabatina wegi, ido lo molaibo ha api itibiyabo we yasigi yalo sinoi minoti auba iti sigiya lo edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Feto feyato, Helotigi ido himiwelagi yasi noka hedo muti, hamana hiti, hiyaba we ulalo owo ma holoi edoti, Pailati nedoka hofa ilimiti unae, loti idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ido Pailatite Helotite homu ya uwolafo-uwolafo minaibo nefa, ido fo hamena yalo ya yowo molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ena Pailatikafo sokila hi muwabo we hiyabatina wetina, ido wenina hiyabatina we nabagi, ido aifa wenina muki yagi li nuba o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","feto loto lobibo, Hemotina wewa Lomu gamanigi fina lowa finune, loto wenina lutina-hatina fali witunu ibo we ne, loti lo edabo ya nemodoka ilimiti ato, nemokafo nomudinalo ya sigiya lo edabo hatina holito, lifimala ya moni wita ofa, ma li oloto piyámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ido Heloti yagi ayaidana oto lifimala ma li oloto piyáminako, yagunu ya lemodoka ilifi molaibo ya moda holi minae. Wewa ya idafa ma hofo fulinubo idafa ma o molámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yagunu ya ikula hofo edoto, nalauti wina edoto fulo edanogolowe, loto lobiye.  ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Feto lobibo ya aya foliwa ya nalalo we ma nalauti wina edoto fulo edo, loti lomuwabo wewa ya nalauti wina edanaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Feto lobibo hawa ya holititi ha notina li maina moloti hai moloti lomuwabo, Wewa ya hofo fuliyo. Balabasi nalauti wina oto adelo molo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Feto loti labo Balabasiwa ya numuna meya naba fina-lowa hito, gamani wenina fi hofo betito, we ma hofo fulito, yagunu nala numugu fulo edabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ido Pailatikafo Yesu wina edanowe, loto holibo ya hofa lobifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ido ilalu huti hai moloti feto labo, Yá yofolo hofo fuliyo. Yá yofolo hofo fuliyo, loti lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Feto lato, emokafo hofa feto loto lobibo, Neidafaiye? Nena mona nosámibo ya molaibogunuwe? Nemo ya wewa hofo edo fulinabo lifimala ya moni wita ofa, li oloto piyámonako, yagunu ikula hofo edoto ilifi fuloneto unaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Feto lobifa, lo gedoti ilalu huti labo, Yá yofolo hofo fuliyo, loti ha naba loti lo minato, hatina yakafo emo hala li fulo edainako, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailati ya holibo, Hatina meyalo molanowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","hasuwala fi-fi aibo we fina-lowa hito we hofo fulito, nala numugu minaibo we ya adelo molo, loti labo wewa ya nalauti wina edoto, ido Yesu ya hofo fulinae, loti holi minabo yagunu himiwela adinalo molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ena Yesu ilimiti uwado we ma huliya Saimoni ya Sailinikati we hanudo Yelusalemu u fedanowe, loto aido ya wa edoti, analo liti yá yofo abulalo mofu edoti, Yesu meyalo ege molanaiye, loti auba iti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ena we wena muki egetina monimo uwagu yauti wenipa ma hufo nama o edomo uti miluma-aluma holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Feto feyato, Yesu liwewe oto feto lobibo, Aiyo, Yelusalemu wenipao, nemogunu hufo ámilo. Heimotinagi ido olufotinagi yagunu hufo alo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Holiyafe? Hamena ma oloto pinaibo hamena yalo feto loti lanabo, Wenipa heni minabo, ido wenipa olufo hedámabo wenipa, ido wenipa aminatinalo olufo námabo wenipa ya ake inigilae, loti feti lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ido Aya hamenalo feto loti lanabo, Hemotina obula naba ya lemodoka lumuti mi i ledalo. Hemotina obula hefola ya lemo minonido lumuti ute ya ogofu li lulau o ledalo, loti ha mono lufuwau (Hos 10:8) nebo ha ya lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ido yá hofawa nebo ya nosámibo idafawa feto feyabo ya yá gedibo hamenalo ya nena idafa nosámibo mulalo-mulalo feyanabo ne? Holiyafe? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ena we loiti ma hasuwala fibo we ya emogi hofo beti fulinune, loti idipiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Idipiti uti eba ma huliya Atatina Auba ne, loti nedo ya lo fedoti, yalo emogi ido hasuwala fibo wegi hofo betiyabo ma filiga onaleka, ido ma ya filiga adawaleka ya yá yofolo hofo betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hofo betiyato, Yesukafo feto libo, Menefo, idafa feyabo ya monawa holiyámoti abo yagunu ha lifimatina ya hilili o betiyo, loto lomuiye. Ido himiwe yasi ulalo owo yagunu noka hedoti hona moloti liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ido wenina sinoiti wa minato, hiyabatina we yagi ha nosámibo-asámibo feto loti lo edabo, Wenina eito ya li nomudina wa-wa aiboma we ya Gotikafo ilifi molaibo we Kilisto, wa molo edaibo we yama minagetoma, eimola li nomuna wanaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ido himiwe ya ayaidana oti emodoka loti hamana hi minoti, nanaiye, loti ekefa aibo no waini muti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","feto lomuwabo, Hemo Yuda wenina hiyabatina we wehudi minotoma, heimoka ya li nomuga wa, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ido atalalo idafa lufuwa ito molabo ya feto loto ibo, Wewa me ya ya Yuda wenina hiyabatina we wehudi ne, loto ibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ido hasuwala fibo we ma yá yofolo minaibo yakafo ha nosámibo feto loto lomuibo, Hemo Goti ilifi molaibo we Kilisto minabe? Olo. Heimokagi ido lemo yagi li nomude wa, loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ido hasuwala fibo we mamakafo hanu muito feto lomuibo, Hemo ya hena libo yaidana oto liyanibo yagunu Goti holiya holámabe? ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lemo mona nosámibo molonibo yagunu lifimate fefe loto nebo ya liwila oto liyoba, ido wewa me ya mona nosámibo ma molámibo ne, loto ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","feto loto lomuibo, Yesuwo, hiyaba we wehudi ananibo hamenalo ya nemogunu holinabe? loto lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ya liwila oto lomuibo, Nemo ha ona lohomowe. Eletifo ya nemote Paladaisika minanoiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ena folilo, tuwelu (12) kiloku yalomati u lunaga tili (3) kiloku ya fo ladámito, mikau-mikau muki ya midipu omo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Midipu omo wito, ido fele huliyagi numuna naba lulau ya wa edotanae, loti lafo-lafo naba diyabo ya filiga-filiga fekalibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ido Yesukafo ha naba loto feto libo, Menefo, agalo weune ya molowe, loto wela-mula hulito fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Fulito, himiwe hiyabatina wekafo idafa ya wa edoto, Goti ebola loto feto libo, Wewa ya moda monala fefe loto molaibo we ya ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ido wenina muki idafa wanune, loti lo fedoti mau minabo yasi idafawa wati holiti, lutina-hatinau hena holiti, ikitinalo hofoti liwila oti monimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Feto feyafa, yolawe-motagi ido Galili mikaloti ege molabo wenipagi ya faiga sinoi minoti idafawa wati holiti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ena we ma nebo huliya Yosefe ya Yuda kanisole we nebo, we dowa monala fefe libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ido hounalafo-mota Yesu hofo fulinune, loti labo hamenalo ya emo feto feyanune, loto ladámiye. E'e, aya wewa ya oloto pibo numuna meya ya Yuda wenina numunatina huliya Alimatea wewa ya Goti wehudi weninala hiyaba o ledaibo hamena ya hiyaba omo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aya wewa yakafo Pailati nedo uto, Yesu hono ula ya numunabe? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O, lito uto hono ula ya yá yofoloti lito, lafo-lafogunu wase ito, lito uto hefana lulau hono molanune, loti lifefe loti hono yau molámagu yau Yesu hono ula ya molo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Molo edaito, aya hamena huliya Lifefe Lanabo Hamenae, loto neto Sabati foliwa alili aibo oloto pinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ido wenipa Yesugi Galili mikaloti maina abo ya Yosefe ege uti, hefana lula wati, ido hono ula hefana lulau molaibo monala ya wa huloti, ");
INSERT INTO snp_lambau_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","numudoka liwila oti uti, yá nowala ladanuwa aibo wili edanabo idafa li nuba iyafa, lo molaibo ha meyalo moloti Sabati foliwalo onona liyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ena Sabati foliwa hulito salele homu hamenalo ho lanogolaido wenipawa idafa ladanuwa aibo idafa li nuba abo idafa yama hefana lula libo ebalo liti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","U fedoti wabo hefana naba hale wela lotana itabo yama ya hululu wito hale wela godo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Godo neto, lulau yoti Wenaba Yesu hono ula moni wita afa, li oloto piyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Li oloto piyámoti yagunu hatina loiti-loiti ki minato, haita we loiti ma utinalo owo ho sili ge-ge fulaiboidana lamena aido ya oloto piti sinoi minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sinoi minaibo ya wa betiti holi bito, huba i muti mikalo wa minato, wewa yasi feto loti lobibo, Hemotina sinoiti nomuna hofawa nebo we ya fuliyabo wenina minagu yau moni wita aiye? ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Emo ya fuliguti hofa sinoitaibo ne. Meu ya minámiye. E'e, emo yakafo hemotinagi Galili mikalo nebo hamenalo lobibo ha holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Feto loto lobibo, We Hula nemo ya lifimatina nebo we adinalo molato, yá yofolo hofo nedo fuliyato, fo hamena loitigi-makogi (3) uwageto ya hofa sinoinogolowe, loto lobiboma ne, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Feto laito, wenipa Yesu lobibo hala ya hatina ki minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ena hefana lula yaloti liwila oti numudoka uti, ege-ege moniyabo we leweni (11) yagi, ido malekama weninagi idafawa muki yagunu lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Feti aposolo lobiyabo wenipa ya hulitina feito nebo, Malia Madala numudoti aibo, ido ma Yowana, ido ma Yemusi olafo Malia, ido malekama maleka yagi maina minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Feto loti hawa lobiyafa, ido hatina holiyabo ya aifa ha lae, loti holiti holi hiki ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Holi hiki ladámato, Pita ya sinoito, hefana lula libo ebalo oluloto lo fedoto, huba ito waibo lafo-lafo yako neto wato, neidafa-neidafa aiye? loto numudoka liwila oto hala kimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ena aya fo hamenalo ege molabo we minagu yati loiti ma Emeusi numudo unoiye, loti uwaiye. Numunawa yaloti Yelusalemu ya leweni (11) kilomita yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ena wewa loitima ya hanudo monimo uti, idafa muki oloto pibo yagunu loyolalo-melo omo uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Feti loyolalo-melo omo uwaito, Yesu eimola ya loto emotinado kelaito, maina uwafa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","makafo li nomudina likaibo yaidana oti edaito wa edofefe loti wa edámaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Wa edofefe loti wa edámaito, emokafo feto lobibo, Hemotina hanudo monimo aido ya nena idafagunu loyolalo-melo omo aiye? loto loga o betito, loitiwama momoga oti aguwámoti, aifa sinoi minoti, hotina-wetina hena aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ena ma ya huliya Kiliyopasi yakafo loga o edaibo, Wenina muki Yelusalemu loti minabo ya holi hulinako, hemoko idafawa oloto pibo idafa ya holámabe? lito ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","loga o betibo, Nena idafa yae? lito liwila oti lomuibo, Yesu Nasaletekati aibo we hala yae. Emo ya polofeti minoto ido Goti nomunalogi ido wenina muki nomudinalogi ya idafa o-o aibogi ido ha lo-lo aibogi ya auba ibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Feito auba ibo nefa, sokila hi muwabo we wenabatinagi ido lemo hiyabate wegi yasi analo-hinalo liti hofo fuli edanae, loti uwolafo-mota adinalo molato yá yofolo hofo fuli edae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Feto feyafa, leimote eimola ya lemo Isilaeli wenina ya meina fito wina ledanaiye, loto homu holiyone. Ido idafawa oloto pibo fo hamena loitigi-makogi (3) yaidana moda utaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ido minonigu yauti wenipa masi li elegi ledae. Emotina ya leda luwaila hefana lulau uti ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wabo ya hono ula ya moda li oloto piyámoti, liwila oti lemodoka loti feto labo, Lemo yasi wamo yaidana oto wa onibo enisole loiti oloto pi lumuti, Yesu ya hofawa ne, loti laiye, loti lolomae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ena hawa holito, lemodokati hounatefo-mota malekaloka ya hefana lula yau uti, wenipate lolomabo yamaidana oti ya ayalo wa edafa, ido eimola ya wa edámae, loti lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lobito, emokafo feto loto lobibo, Hemotina ya ha manadinau minámibo wenina, lutina-hatina gedibo yagunu polofeti ha labo muki ya holi hiki ladámo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Holifefe loti holiyámaife? Goti ilifi molaibo we Kilisto ya homu idafawa hena naba-naba holitoto lamenalau ya yonaibo ne, loti holiyámaife? Olo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Feto lobibo ya Mosesekafo ha lufuwa ibo ha yagi, ido polofeti muki lufuwa iyabo ha yagi yaloti apito mono lufuwau yau muki idafa eimola yagunu labo ya li oloto pi betimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ena uti Emeusi numuna meya li alili ato, Yesu ya eba malo monimo unowe, loto wifa, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","E'e, loti auba iti feto laibo, Fo lumibo ya midipu anaibo nenako, hemo lemogi minanune, loti laito, emogi minanowe, loto holi bito, numugu maina yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Numugu yoti, wetina-idafa nanabo folomolo amedoti minato ya beleti lito lekoto, dowae, lalowe, lomuto apito biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Apito bito, nomudina li falato betito wa edofefe laibo hamenalo ayalo wa edámaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wa edámoti eimotina feto loti laibo, Hanudo lolumibo ya ha mono lufuwauti monawa ya li oloto pito lolumito, lute-hate yoibo ne, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Feto loti ayalo sinoiti Yelusalemuka liwila oti uwaiye. U fedoti wa betibo ya ege-ege moniyabo we leweni (11) yagi, ido hounatinafo-motagi nuba oti minabo feto loti labo, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ya onae. Wenaba ya fuliguti moda sinoito, Saimoni oloto pi muiye, loti lato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Loitiwa ya ayaidana oti hanudo idafa oloto pi bibo monagi, ido Yesu ya beleti lekaito wa edofefe loti wa edaibo monawa yagi lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hawa lobi minado ya Yesu eimolakafo minagu yau oloto pito sinoi minoto feto loto lobibo, You amena mona ya hemotinaloka mino betiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lobito, holiyofa oloto piye, loti hatina ki minoti ya utina ololo oto holi naba-naba biye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Holi bito, emokafo feto loto lobibo, Neidafaiti lutina-hatinau hena holiti hatina loiti-loiti ki minae? ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Me ya ya neimo yama minowe. Hemotina ane-hine walo. Ena loti une liti wa nedofefe lalo. Holofa ya aubalagi ula milalagi minámifa, nemo aubanegi une milanegi minobo ya wa nedalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Feto lobito ana hina itibito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","hawa holiti elegiti ake iyabo yagunu auba iti holi hikito umámato, feto loto loga o betibo, Hoba ma nefe? Nanogolowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","laefa hiyabo ma ya li muwato, ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","lito nomudinalo naiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ido nototo feto loto lobibo, Holilo. Mosesekafo lo molaibo ha ya lufuwa igu, ido polofeti yasi lufuwa iyagu, ido Mono Nama lufuwa iyagu yau nemogunu lufuwa iyabo ha muki yama u ayalo inaiye, loto nemo hemotinagi minodoma feto loto lobiyobo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Feto lobito ha mono lufuwa iyabo holifefe loti holinigilae, loto api itibi minoto ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","feto libo, Holilo. Feti lufuwa iyaboma ne: Goti ilifi molaibo we Kilisto ya hena naba holito, fuliyageto fo hamena tili (3) uwageto fulinaiguti hofa sinoinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sinoiyageto, huliyalo ya wenina lutina-hatina li elepa inabo ya lifimatina hilili o betinaiye, loti lo oloto bimo unae. Ido hala ukuwa lo oloto bimo unabo yasi Yelusalemu yaloti ononawa apiti wenina mikau-mikau minagu ya uti hala ukuwa lo oloto piti lobimo unae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ido hemotina idafawa hemo ya wenina lobimo wilalo. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ido nemo ya idafa ma Menefokafo binowe, loto lo molo betibo idafawa ya hemotinaloka ya ilifi molanowe, loto lobiyowe. Ido numuna meya naba yau hiyaba oti minomo uwato, yoisauti auba ya lumuto mino betiyageto yaloti ya apiti lobimo unigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ena numudoti idipito uto Betani numudo selo fedoto ana faka loto Gotikafo li dowa lo betiyo, loto ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","lo nedo ya fulo betitoto okulumalo yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yoito, huliya li faka loti, weudina-lutina-hatina muti, ake naba-naba iti, Yelusalemuka ya liwila oti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Liwila oti uti hamena-hamena fele huliyagi numuna nabau minoti, Goti ebola lo-lo o minabo ne. Modae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ha ya hana monau akaimati minomo yoto minoto ya Gotigi mako mino edomo yoibo ne. Ido Hawa ya Goti eimola ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ido Hawa ya hana monau akaimati Gotigi mako minoto mino edomo yoibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ya idafa-adafa muki oloto pibo ya emo yakafoko li oloto pibo ne. Feito emo ya minámibo neko, mika, okuluma, idafa-adafa muki ya oloto piyámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ido emodoka ya hofawa minomo yoibo mona hula ya ne. Ido aya hofawa minomo yoibo mona hulawa yakafo wenina li lamena o ledaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lamenawa yakafo lubu igu ya lamena aito, lubukafo lamena fiyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ena we ma huliya Yoni ya lamenawa yagunu lo oloto molageto, wenina muki yasi lamena yawala holi hikito munae, loto Gotikafo ilifi molaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ilifibo wewa Yoni ya lamena yawala minámiye. E'e, aifa lamena yawala hala ukuwa lo oloto molaibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ena lamena yawala wenina mikau-mikau li lamena o ledaibo ya Yoni hamenalalo ya mikalo oloto pito aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mikalo aibo wewa ya eimola aubalagunu mika ya li oloto pifa, mikaleka wenina yasi wafefe loti wa edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ido eimola ebalaloka oloto pito aifa, weninala ya emogi houna iyámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Houna iyámafa, ido wenina ma emogi houna iti huliya holi hikitoti moni minabo wenina ya Goti olufola minanabo hanu ya li oloto pi beti ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wenina utinautiko oloto piyabo wenina ya Goti olufola minámae. Ido we wena kelanoiye, loti kelaigu yauti oloto piyabo wenina ya Goti olufola minámae. Ido wenina heimotina hatina kiyado yati Goti olufola ya oloto piyámae. E'e, Goti olufola ya Gotidokati oloto piyabo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ena Hala ya ula etuwagi oloto pito, lemo minonigu ya minoto, aifa li dowa lo ledaibo mona ido mona ona hula yawala nebo we ya leimote lamena monala wa edonibo, ya Metefo Hipala mako lamena monala yaidana oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ena emogunu ya Yonikafo lo oloto moloto, lo faka loto feto libo, Aliga aibo we ya nemo oloto piyámoto minomo yoibo we nenako, nemo li fulo nedoto wenaba ona nebo ne, loto lobitobo we yama me ya ya ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ena aifa li dowa lo ledaibo yawala yakafo lemo wenina muki ya emodokati aifa li dowa lo ledomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Goti lo molaibo ha ya Mosese anau moloto lumima nefa, Yesu Kilistodokati aifa li dowa lo ledoto mona ona hula ya lilibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ena Goti ya we makafo wa edaibo we ma minámiye. E'e, Hipala Goti mako Melafo hamanau nebo wekafo ya monala li oloto pi lumibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Ena Yelusalemu numudoti Goti sokila hi mu-mu abo we ido fele huliyagi numuna naba houba-naba we ya Yuda wenina yasi idipi molato Yoni nedo uti ya lomuwabo, Hemo ya we hema minane? loti loga o edato ya monala li faluku ámoto, lo oloto moloto feto loto lobibo, Nemo ya Goti ilifi molaibo we Kilisto yama minámowe, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Lobito, ya emotina yasi hofa loga o edabo, Ena hemo ya hema minane? Elaiya minabe? lato liwila oto lobibo, E'e, nemo Elaiya minámowe, lito emotina yasi labo, Hemo polofeti hiyabala onibo we yama minabe? lato ya emo, E'e, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Feto libo yagunu emotina yasi feto loti lomuwabo, Ena hemo ya hema minane? Hemo anibo yagunu lilifi molato one. Hemo heimoka ya yaidana we minowe, loto lolomageto uto lobinune, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Lomuwato, feto lobibo, Polofeti Aisaiya feto libo, Hafali mikau yalo we ya welauti ha auba ito feto loto lo oloto molanaibo, Wenaba hanula ya lifefe lalo, loto lo minanaiye, loto ha mono lufuwau (Ais 40:3) nebo ha yama onesa nemo ya lo fedowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ido Falisi wenina minaguti Yonidoka idipi molato uwabo wenina yasi ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","loga o edoti labo, Ena ha lanibo ya nemo Goti ilifi molaibo we Kilisto ya minámowe. Ido Elaiya ya minámowe. Ido polofeti hiyabala onibo we yama minámowe, loto lanibo ya hemo neidafaito noku i beti-beti ane? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yonikafo feto loto lobibo, Nemo ya wenina nogunuko noku i beti minofa, ido hemotina minagu yau we ma oloto pito nebo we ya hemotina wa edofefe ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Emo ya nege aifa, nemo efo ya emo yaidana we ya minámonako, hinalo ibo idafa wina anobo ya fefe ladámanogolaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hawa ya Betani numudo Yodani no filiga yolaleka yalo ya Yonikafo wenina noku i betido, yalo ya hawa ya oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ena leda ya Yesu Yoni nedo ya wito, faigati wa edoto ya wenina feto loto lobibo, Walo. Goti Sipisipila Mofola yolakafo wenina mikau-mikau lifimate li mofuibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Li mofuibo we yagunu feto lobiyoma, Aliga aibo we ya nemo oloto piyámoto minomo yoibo we nenako, nemo li fulo nedoto wenaba ona nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ido neimo homu ya wa edofefe ladámobo nefa, monala ya hemotina Isilaeli weninane lobiyoto holinae, loto ya lo fedoto nogunu noku i betiyoma ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ido ha ma eimola nomuna wa edaibo idafa yagunu Yonikafo feto loto lo oloto pi bibo, Weuna ya nama mulu yaidana oto okulumauti lumuto emodoka ya neto wa edobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neimo homu ya wa edofefe ladámofa, nogunu noku i betiyobo ononawa numibo wekafo feto loto lonumibo, Weuna ya lumuto emodoka ya minageto wa edanogolane. Wa edananibo we ya Weuna Felekafo noku i betinogolaiye, loto lonumibo ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","yagunu nemo idafa ya wa obo nenako, loto monala feto loto lobiyoma, Emo ya Goti Hipala ya ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ena leda ya Yonigi ido ege molabo we yauti we loiti yagi ebawau ya minato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu lekoto ayalo ya wito, Yonikafo wa edoto we loiti ya lobito libo, Wa edaliyo. Goti Sipisipila Mofola yola ya ne, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","loiti ya hawa holiti Yesu ege uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ege uwaito, Yesukafo liwewe oto wa betito ya, Hemotina ya neidafaito aiye? lito ma yakafo libo, Api lilibiyanibo we, numunaka igau ya minane? loto loga o edaito ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ya lobibo, Loti waliyo, loto lobito, loiti ya ege-ege uti numunala wati ya fo lunaga molanowe, loto aito yalo ya Yesu nedo ya minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ena Yoni hala holiti Yesu ege wibo we ma Saimoni Pita unalafo Adulu yakafo ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","aloko uto yalafo Saimoni li oloto pi edoto, feto loto lomuibo, Lemo Mesaiya li oloto piyoiye, loto libo, ya hawa monawa ya Gotikafo ilifi molaibo we Kilisto ne, loto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hawa lomuto ya Yesu nedoka ilimito wito, Yesukafo wa edoto ya libo, Hemo Yoni hipala Saimoniyo, hulika hofawa Sifasi ne, loto ya molowe, loto libo, ya Yuda wenina hatinalokati huliya Sifasi, ya Giliki wenina hatinalokati ya huliya Pita ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ena leda ya Yesukafo Galili mikalo unowe, loto ya Filipi wa edoto feto lomuibo, Hemo nege-nege ano, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Lomuibo wewa Filipi ya Adulute Pitate numunatina Betesaidakati aibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wewa Filipikafo uto Nataniyeli wa edoto feto lomuibo, Mosesekafo lo molaibo ha lufuwa igu ido polofeti yagi lufuwa iyagu yau we yagunu iyabo wewa yama onesa li oloto piyone. Ya we ya Nasalete numudoti aibo we Yosefe hipala Yesu ya ne, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lomuito, Nataniyelikafo ha feto loto liwila oto lomuibo, Nasalete numudo yati idafa dowa ma oloto pinaibo nefe? lito Filipikafo lomuibo, Hemo loto wao, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Feto lomuito, Nataniyeli ya uto Yesu nedo u fedito, Yesukafo wa edoto ya libo, Walo. We me ya ya Isilaeli we hula nebo ya lula-halau ha sugi ya ma minámiye, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyelikafo loga o edoto libo, Hemo igaidana oto ya nemo wa nedoto lane? lito Yesukafo libo, Filipikafo suka fiyámito ya yá sigolo monau ya minageto wa hedoma ne, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Lomuito, Nataniyelikafo feto loto lomuibo, Api lilibiyanibo we, hemo Goti Hipala Isilaeli wenina hiyabate we wehudi ona ya minane, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesukafo libo, Yá sigolo monau ya minanima lo oloto pi homobo yagunu holi hikito nomabe? Aliga ya idafa naba hulawa ya ito yoto wa edanogolane, loto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ido ha ma onu ito libo, Nemo ha ona hula lobiyowe. Hemotina okuluma eya lageto Goti enisolela yasi We Hula nemo minodo ya yoti lumuti ato wa betinigilae, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ena onona hamena loiti hulito Galili mikalo Kana numudo ya we wena adinalo li binune, loti wetina-idafa hofo hi minado, Yesu olafo ayalo neto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu yagi ege-ege moniyabo we yagi lo molo betiyato ya ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ato, wenina nuba oti idafa no minato, no waini hulito ya Yesu olafokafo lomuibo, No waini ma minámiye, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesukafo lomuibo, Wenao, onona yagunu ha lonomámo. Hamenane onesa nefe? lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lomuito, olafokafo numuna yawala houba-nabala we feto loto lobibo, Onona ma lobinaibo ya liyalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ena numuna yalo ya hefana malu naba sikisi (6) neto, ya Yuda wenina ha mono monatina ya idafa-adafa hamena-hamena noku i-i abo yagunu numugu-numugu no maluku ya minomo wiye. Maluwa ma yau dalamu hefolau hamena faifu (5), ido ma yau hamena seweni (7) ya no fiti ito loti leki-leki abo ya nabatina feito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Feito neto ya Yesukafo numuna yawala houba-nabala we feto loto lobibo, Hemotina no fiti maluku yau lekiyalo, lito emotina yasi feto feti no ya fiti lekiyato lumuto faito fulitaito ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesukafo feto loto lobibo, Hemotina ma fiti wetina-idafa hiyaba aibo weloka ya liti wilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Feto lobito, no fiti liti uwato, no yakafo no waini bulito wetina-idafa hiyaba aibo we ya no holifa, monala holámibo, houba-naba we no fiti maluku lekiyabo we yasiko no waini monala holifefe lae. Ido wetina-idafa hiyaba aibo we yakafo wena libo we ilimito loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","feto loto lomuibo, Homu no waini la fulibo biyogeto, noti hatina-manadina u hopa ito aliga no waini la fuliyámibo ya bi-bi onima ne. Monate feito nema nefa, hemo ya li elepa ito la fuliboma ya mi ito molaniguti onesa oloto piye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Feito Yesu yakafo Galili mikau ya Kana numudo yalo ya idafa hofawa aubala itibibo ononala apito lito, lamena aubala li oloto pito ya ege-ege moniyabo we wati holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ena Yesule, olafole, unalafo-motagi, ido ege-ege moniyabo we yagi muki ya Kana numudoti lumuti Kapeneyamu numudo lo fedoti ya hamena malekako yalo ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ena Yuda wenina Gotikafo Uta O Betibo foli hamenatina alili aito, Yesu ya Yelusalemu numudo ya yoto ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","fele huliyagi numuna naba hilalau yoto wa edaibo, ya Goti sokila hi munabo yagunu sipisipi, bulumakau ido nama mulu ya hefanalo fulabo wenina, ido folomolo ya hefana hola eito-eito nebo ya li filiga-filiga abo wenina ya Yesukafo wa betito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","nala ya mibo u mainafa hilito, wenina yagi sipisipi bulumakau yagi henito hofo betito holi uwato, hefana-afana yagi lito fululu kaito, folomotina yagi itifu-natifu oto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nama mulu li minabo we ya feto loto lobibo, Hemotina idafawa li fekaitalo. Me ya Menefo numunalau ya idafa hopa feto feyato ya maketi yaidana ámaneyo, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Feto feyaibo yagunu ya ege-ege moniyabo we ya ha mono lufuwau nebo ha yagunu feto loti hatina kiyabo, Hemo numunaka lifefe lanowe, loto auba ito holito lune-hane so loto hutifina-natifina aiye, loto ha mono lufuwau (Sng 69:9) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ena Yuda wenina yasi loga o edoti labo, Hemo feto anibo ya aubaka monaka yakafo nena idafa li oloto pi lumunanibo ne? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","emokafo ha liwila oto feto loto lobibo, Hemotina fele huliyagi numuna naba me ya ya luko itoto nemo fo hamena tili (3) uwageto hofa hu fukanogolowe, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lobito, emotinasi feto loti lomuwabo, Lemo yatefo-metefo minabo yasi fele huliyagi numuna naba meya ya melege foti-sikisi (46) ya wito hu fukama nenako, ya hemo ya fo hamena tili (3) yako hu fukanowe, loto labe? loti lomuwafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ido Yesukafo ula yagunu libo fele huliyagi numuna nabalo ya moloto wase ito ha lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Feto loto lobito minoto fuliguti sinoito ya ege-ege moniyabo we hawa ya holifefe labo ne. Ido Yesu hala libo yagi ido ha mono lufuwau ya Goti hala iyabo yagi ya holiti ya holi hikitabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ena Yesukafo Goti Uta O Betibo foliku ya Yelusalemu numudo ya aubala itibibo idafa mona-mona aibo ya wenina muki yasi wati huliya holi hikito muwafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ido Yesukafo wenina monatina wa beti hulinako, ya emodoka metolito minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Emo ya we ma monala holinowe, loto wenina maleka loga o betiyámibo ne. E'e, eimolakafo wenina lutina-hatinau ya wa huloto wa betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ena Falisi we minagu yauti we ma nebo huliya Nikodemusi ya Yuda mono kanisole we ya ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","lubuka Yesu nedo loto ya feto lomuibo, Api lilibiyanibo we, lemo monaka ya holi minone. Hemo api lilibiyanibo we ya Gotidokati anima ne. Hemo idafa hofawa li oloto pi lumu-lumu anibo, ya Goti hemogi minámibo neko, feito li oloto piyámadi ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Feto lomuito, Yesukafo ha liwila oto feto loto lomuibo, Nemo ha ona hula lohomowe. Ma ya auba ito hofawa oloto piyámanaibo yakafo Goti wehudite weninala hiyaba o ledaibo hilala ya wa edámanogolaiye, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Feto lomuito, Nikodemusikafo feto loto loga o edaibo, Aiyo, we ma alo naba litaibo yakafo ya igaidana oto hofa olufo namuna bulito oloto pinaibo ne? Igaidana oto hofa olafo houmalau ya yowageto hofa ya hedanaibo ne? loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lito, ya Yesukafo feto loto lomuibo, Nemo ha ona hula lohomowe. Ma ya nokuti ido Weunauti hofawa oloto piyámanabo ya Goti wehudite weninala hiyaba o ledaibo hilalau ya ma aguwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wenina utinauti oloto piyabo ya aifa wenina yaidana oti minae. Ido Weunau yati hofawa oloto piyabo ya weudina ya Goti Weuna yaidana oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hofawa oloto piyaneyo, loto lobo ya holito haka loiti-loiti kiyámo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Asi ya hopa-napa o-o minoto ya fufu-fafa libo yako holi minane. Monawa ya igalekati apito aife? Ido u igaleka hulife? Ya ma holiyámone. Weunau yati oloto piyabo wenina ya ayaidana oti minae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Feto lito, ya Nikodemusikafo ha liwila oto feto loto loga o edaibo, Ya igaidana oto feto anubo ne? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesukafo ha liwila oto lomuibo, Hemo Isilaeli wenina api itibiyanibo wema minaba, holifefe ladámabe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nemo ha ona hula lohomowe. Lemo idafa holiyonido ido wa onido, ayalo ya loto lo oloto itibi minoba, hemotina ya hate ya holi fulo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ido mikaleka idafa yagunu lobiyobo ya holi hiki ladámanako, okulumau idafa yagunu lobinobo ya igaidana oti holi hikitanabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wenina ma okulumau yowámae. We Hula neimo mako yako okulumau minodoti lomobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ido Mosesekafo homu yoimaloka ya hafali mikalo ya hosofa fefelumala lifefe loto li faka libo yamaidana oti We Hula nemo ya li faka lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Li faka lanigilanako, holi hikito numunabo wenina muki ya hofawa minowa-minowa oti minomo yonigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ena Goti yakafo mikalo wenina muki ya lula-hala ito yoto bibo yagunu Hipala makoko ilifi molaima, ya holi hikito munabo wenina ya u hopa aguwámoti, moda hofawa minowa-minowa oti minomo yonigilae, loto ilifi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ilifi molaibo, ya mikalo wenina lifima ha li liwila oto binowe, loto ilifi molámiye. E'e, Hipalakafo wenina li nomudina wanaiye, loto ilifi molaito lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Holi hikito munabo wenina ya lifima ha li liwila oto biyámanaibo ne. Ido holi hikito umámanabo wenina ya Goti Hipala makoko huliya holi hikito umámanako, yagunu lifima ha li liwila oto bibo mona onesa me ya moda mino betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ido lifima ha li liwila oto bibo monawa feito ya ne: Lamena yakafo mikalo wenina li alo alili molo beti nefa, monatina nosámido minanako, lamena ya lutina-hatina umámoti, midipu ibo ya lutina-hatina muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nosámibo mona molo minabo wenina yasi lamena eleka fi muti, ya monate li oloto pitanaiye, loti lamenalo ya ámoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ido mona ona hula molo minabo wenina yasi Goti lulau mino edoto monate molo-molo onibo monawa ya li oloto pinogolaiye, loti lamenalo ya loti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ena aliga Yesugi ege-ege moniyabo we yagi Yelusalemu fulitoti Yudia mika anawalo ya uti, yalo ya minoti wenina noku i betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ido Yoni ya nala numugu fulo edámabo hamenalo nenako, emokafo ayaidana oto mika ma huliya Ainoni selo Salimi numudo ya no abi oto nebo yagunu neto wenina loti-loti ato, ya noku i beti-beti aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Noku i beti-beti aito, Yoni ege moniyabo we malekamagi Yuda we magi noku iyabo mona yagunu moliya fiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Moliya fiyato, Yoni ege moniyabo we yasi Yoni nedo ya uti feto loti lomuwabo, Api lilibiyanibo we, hemo Yodani no filigaleka yola minageto we ma u wa hedoto hatula ito monala lo oloto pi lomanibo we yamakafo onesa hamena meleka wenina noku i beti neto, ya emodoka u hulae, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Lomuwato, Yonikafo ha liwila oto lobibo, We ma okuluma yawalakafo idafa umámageyama eimolakafo igaidana oto linaibo ne? Moda liyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nemo homu feto lobiyobo, Nemo Gotikafo ilifi molaibo we Kilisto ya minámowe. Minámofa, Gotikafo u homu moloto hanula lifefe lo, loto nilifi molaito owe, loto lobiyobo hawa ya hemotina moda holitama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hipa ma wa molo edabo ya wena linaibo ya ne. Ido hounalafo selo sinoi minoto nola fefeluma holito lula-halau ya dowa loto holinaibo ne. Yagunu nemo onesa dowa loto holiyobo mona ya lune-haneu faitibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Emo huliya ya yoimo unaibo ne, ido nemo huline ya lumumo unaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ena okaleka yowauti lumibo we yakafo wenina muki li fulo ledaiye. Wenina mikaloka oloto piyonibo ya mikalo wenina minoto, mikaleka idafagunu lo minoba, okulumauti lumibo we yakafo muki li fulo ledo hulibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Emo ya wato holito aibo idafa yagunu lo oloto molaifa, wenina yasi hala holi fulo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Gotikafo ilifi molaibo we lula-halau ya Weuna faitoto molainako, Goti hala ya lo nebo yagunu ha libo holi hikitabo wenina yasi Goti monala ya mona ona hula ya ne, loti li faka lo minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Melafokafo Hipala lula-hala muto, idafa-adafa muki ya analo molo hulibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goti Hipala holi hikito muwabo wenina onesa melekati ya nomudina hofawa minowa-minowa oti minomo yowabo ne. Ido Goti Hipala hala hololadámabo wenina ya mino holimo yonabo mona ya wagámanabo ne. Gotikafo eleka fi bibo mona moda mino betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ena Falisi wenina yasi Yesugunu feto loti holiyabo, Yonikafo ege molabo wenina naba li nuba oto noku i betito, ido Yesukafo Yoni li fulo edoto wenina naba-naba li nuba o betito noku i betibo yagunu holiyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesukafo eimola ya wenina ma noku i betiyámiye. Ege-ege moniyabo we yako noku i beti-beti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ido Wenabakafo hawa feto labo ya holito, Yudia mika fulitoto Galili mikalo liwila oto unowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","unaibo hanu ya Samalia mikalo ya lekoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Feito Samalia mikalo ya lekoto uto uto numuna ma huliya Sikali yalo ya u fediye. Numunawa ya Yekopukafo hipala Yosefe mika li muibo ya li alili moloto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ayalo ya Yekopu no hale li molaido ya folilo Yesu u ayalo fedoto, awisa loto hale wela anawalo ya amedoto mino holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Neto, ege-ege moniyabo we wetina-idafa meina finune, loti numudoka ya yowato, Yesu eimolako neto, Samalia wena ma no finowe, loto lo fedito Yesukafo feto loto lomuibo, Hemo no ma nomageto nanowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Feto lomuifa, Yuda wenina ido Samalia wenina yagi wetina-idafa moi mamakeke loti moi iyaboma nenako, loto wenawa yakafo feto loto lomuibo, Hemo Yuda we makafo Samalia wena nemodoka neidafaito nogunu ya lane? liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Lito, Yesukafo ha liwila oto lomuibo, Hemo Goti aifa li dowa lo ledaibo monala yagi, ido nemo no ma nomageto nanowe, loto lohomobo we monane yagi ya holifefe lanibo neko, ena ma nomo, loto laniko ya no atala yaidana oto homadi ne, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lomuito, wenawa yakafo feto loto lomuibo, We hofawe, no hale fana nenako, hemo no finanibo idafaka yagi mináminako, no ma finanibo atalawa igalekati oloto pinaibogunu lane? ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Awatefo-holofate Yekopukafo no hale ya libo me ya ya ne. Ido emo hipala-mota yagi, sipisipila, bulumakaula yagi muki no ayau yatiko noti minama ne. Hemo ya Yekopu li fulo edoto noma li oloto pinogolo labe? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ya Yesukafo ha liwila oto feto lomuibo, No meuti nanabo wenina yasi hofa nogunu holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ido nemo none biyoto nanabo wenina ya nogunu hofa holiyámoti aifa minomo yoti minanigilae. Nowa ya bito muludinau ya no atalawa yaidana oto li oloto pi betiyoto, nomudina hofawa minowa-minowa oti minomo yonigilae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Feto lito, wenawa yakafo feto loto lomuibo, We hofawe, hemo nowa ya nomageto noto nogunu aliga holiyámoto, melo ya loto no fi-fi o minobo ya fulitanowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Feto lito ya Yesukafo lomuibo, Uto wagafo sula fito ilimito ano, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","wenawa yakafo ha liwila oto libo, Nemo wanefo ma minámiye, lito, Yesukafo lomuibo, Hemo wanefo minámiye, lanibo ya ona fefe loto lane. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ido wagafo faifu (5) mofu moloto fulitoto anima ne. Ido onesa yagi welo kelo minanibo yo-holae hemo wanefo ya minámiye, loto lanibo ya ha ona oloto lane, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Lomuito, wenawa yakafo feto loto lomuibo, We hofawe, hemo polofeti minanibo ya onesa ya holiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yagunu ya lageto holinowe. Lemo Samalia wenina awatefo-mota yasi obula melo ya Goti weudina-lutina-hatina mumo yowabo ne. Ido hemotina Yuda wenina yasi wenina muki Yelusalemuka ya Goti weudina-lutina-hatina muilo, loti lobi-lobi ama ne, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lomuito, Yesukafo feto loto lomuibo, Wenao, nemo ha lohomowe. Holi hikito mino. Hamena ma alili anogolaibo, ya ageto ya hemotina Menefo weudina-lutina-hatina munabo ya obula melo ma ámanigilae. Ido Yelusalemuka yagi aguwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hemotina ya holifefe ladámoti weudina-lutina-hatina mu-mu ae. Li nomudina waibo mona ya Yuda weninalokati nenako, lemo ya holifefe loto weude-lute-hate mu-mu o minone. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ido hamena ma anaibo ya moda fedotaiye. Yalo ya weudina-lutina-hatina muwabo wenina hula ya Weuna lulau mino edoti, eimola monala ona hulalo meyalo moloti ya Menefo weudina-lutina-hatina munigilae. Feti numunae, loto Menefokafo wenina yaidana o minabo ya moni wita aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goti ya Weuna neboma nenako, yagunu weudina-lutina-hatina munabo wenina ya Weuna lulau mino edoti, eimola monala ona hulalo meyalo moloti weudina-lutina-hatina ya munae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lomuito, wenawa yakafo feto lomuibo, Mesaiya, huliya ma Kilisto ya Gotikafo ilifi molaibo we oloto pinaiye, loti labo ya nemo holi minowe. Emokafo oloto pito idafa-adafa muki ya lo oloto pi ledanogolaiye, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesukafo lomuibo, Hemo lanibo ya nemo ya minowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Feto lo neto, ege-ege moniyabo we ya liwila oti lo fedoti wenagi ha loyolalo-melo aibo yagunu hatina abi kiti, Nena ha lomuwane? Neidafaito loyolalo-melo o minaiye? loto lomunune, loti holiyafa, hena aito fulitae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ena wenawa yakafo no nomula fulitoto numudoka ya liwila oto uto wenina feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Hemotina loti we ma yakafo idafa oto moloto obo muki lo oloto pito lonumibo ya wa edalo. Ya we ya Gotikafo ilifi molaibo we Kilisto ya nefemo? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","holiti numuna meyaloti lumuti ya Yesu nedo uwokelo, loti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Uwato, Yesu ege-ege moniyabo we ya emo nedo minoti, ha auba iti lomuwabo, Api lilibiyanibo we, weka-idafa no, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","emokafo lobibo, Hoba-idafa eitoma li minofa, ya hemotina ma holámae, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ege-ege moniyabo we ya loyolalo-melo oti labo, Wenina makafo hoba-hobina ito loto limo muifemo? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Feto lato, ya Yesukafo lobibo, Nilifi molaibo we hala dowa kibo mona ya meyalo moloto ononala li hulanobo ya nemo wene-idafa ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Heimotina feto loti lo-lo abo, Igana fo (4) ya hulageto ya hobina hula lotainako, lolobe nanune, loti lafa, neimo lobiyowe. Hemotina wa faka loti wati onona hila walo. Hobina hula libo hamena onesa feto-namato ya moda fedotaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","liti li nuba-nuba abo wenina yasi meinawa li minae. Ya meinawa hula yakafo wenina muki nomudina hofawa minomo yonae. Yagunu idafa li hifiyabo wenina yasi hulawa li nuba abo wenina yasi maina ake inigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yagunu ha me ya ya feto labo, Ma yasi idafa li hifi-hifi ato, ido ma yasi hulawa li nuba o-o ae, loti lo-lo abo ha ya ona ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hemotina idafa li hifiyámaguti hula li nuba anae, loto ya nemokafo idipi molowe. Onodo we masi onona liyato, hula moda lotaibo ne. Hemotina ya hulawa maina li nuba omo uwae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ena Samalia wenawa yakafo numunaloti weninala feto loto lobibo, Idafa oto moloto oboma muki ya lo oloto numiye, loto lobibo ha yagunu ya weninala muki yasi Yesu holi hikito muwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","yagunu Yesu nedo u fedoti lemogi minanune, loti Yesu wako lo edabo ya Yesukafo holi bito, loto fo hamena loiti eimotina numunatinalo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Minoto ha mono lobito, wenina muki holiti holi hikito muwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","yagunu wenawa ya feto loti lomuwabo, Homu ya hemo hakalo loto holi hikitonibo nefa, onesa ya leimote ha libo welaloti ha holito ya holi hikitone. Wewa ya ona mikau-mikau wenina li nomude wanaibo we ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Ena Yesu ya homu lo oloto moloto feto libo, Polofeti ma eimola numuna ebalalo minanaibo ya huliya li faka ladámanigilae, loto linako, Samalia weninagi fo hamena loitiko minoto Galili mikalo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Uto Galili mikalo ya u fedito, homu ya Galili wenina muki ya Yelusalemu uti Gotikafo Uta O Betibo foliku ya minagu ya Yesu onona lito wabo yagunu emogi houna iyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ido Galili mikalo Kana numudo ya homu ha lito no yakafo no wainika wido yalo ya hofa liwila oto loto ne. Ido Kapeneyamu numudo hiyaba we wenaba ma nebo ya hipala idafa naba hilibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","yagunu Yesu ya Yudia mikaloti liwila oto Galili mikalo hofa lo fediye, lato ya hiyaba we wenabawa ya holito, Kana numudo Yesu nedo yoto, hipala fulinaibo hamenala selo molainako, yagunu Yesu ya lumuto, hipane li faka lo edanane, loto wako lo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Feto lo edaito, Yesukafo feto loto lomuibo, Hemotina ya idafa hofawa aubane itibiyobo idafa ya nomudina wagámanabo ya holi hikito nomámanigilae, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Feto lito, hiyaba wekafo feto loto lomuibo, Wenabao, hipane moda fulitanaiye, loto henemane oto anabe? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesukafo feto loto lomuibo, Hipaka moda nomuna hofawa ne. Aifa uwo, lito ya hiyaba wekafo Yesu ha lomuibo ya holi hikitoto liwila oto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ena liwila oto uto hanudo monimo lumido ya ononala liyabo we loti hatula oti ya, Hipaka moda nomuna hofawa ne, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Feto lomuwato, ya faka libo hamena yagunu loga o betito, emotinasi feto loti lomuwabo, Ena emo ya aso fo lusato nebo hamenalo ya ula sopaso ibo ya fulo edaiye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ido hiyaba we yakafo monawa feto loto holibo, Hamena yalo ya Yesukafo, Hipaka moda nomuna hofawa ne, loto lonumibo ne, loto holito, uto emo yagi ido numunalo maina minabo weninala muki yagi holi hikitae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesukafo feito idafawa hofawa ya fetoto Yudia mikaloti Galili mikalo liwila oto uto nedo ya idafa hofawa aubala itibibo ya hamena loiti li oloto pi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Minoto aliga ya Yuda wenina foli hamenatina naba ma alili aito Yesu ya Yelusalemuka yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ena Yelusalemu hanu wela ma huliya Sipisipi Hanuwae, loto nebo hanu anawalo ya momeno ma nebo huliya Beteseda anawalo ya holo-hala numuna faifu (5) ya minomo wibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ayau ya wenina idafa hiliyabo, nomudina likaibo, hidina bemu ibo, utina hebilisibo, muki wenina yau uno minae.  ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ena Wenabalokati enisole makafo hamena ma momenoku ya lumuto no ya li momoga aiye. Li momoga aito idafa hiliyabo wenina yauti ma homu lumuto noku ito idafa hilibo ya li faka lo edaiye. Yagunu wenina muki no ya momoga anaido ne, loti hiyaba ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ena we ma idafa hilito unomo yoibo ya melege teti-eiti (38) ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wito, Yesukafo wewa ya wa edoto holibo, Hamena fana uno ne, loto holito, loga o edoto libo, Hemo faka lanowe, loto holi minabe? lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lomuito, idafa hilibo we yakafo feto loto lomuibo, We hofawe, we makafo no ya momoga agetoma ya noku ya fulo nedanaibo we ma mináminako, neimone lumunowe, loto fe-fe ofa, eito-eitosi fulo aliga nedoiti lumu-lumu ae, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesukafo feto loto lomuibo, Hemo sinoito hunuka lito moniyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lomuito, ayalo ya ula dowa lito, sinoito hunula lito wiye. Ido fo hamena yalo ya Sabati foli hamena ya nebo ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","yagunu Yuda wenina yasi wewa idafa faka libo we ya feto loti lomuwabo, Onesa Sabati foliku me ya ya neidafaito hunuka lito mofu minane? Ya idafa lo fukabo idafa ane, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lomuwato, emokafo feto loto lobibo, Li faka lo nedaibo we yakafo, Hunuka lito moniyo, loto lonumibo ne, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Lobito, emotinasi loga o edoti labo, Hunuka lito moniyo, loto lohumibo we ya hema ne? lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ido Yesu ya wenina mau naba minagu yau holoto wito, faka libo we ya huliya holiyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Feto feyaito, aliga Yesukafo wewama ya fele huliyagi numuna nabau li oloto pito ya feto loto lomuibo, Uka moda dowa lotaiye. Yagunu holito ya idafa ma hena naba-naba aibo idafa ya loto yoto oloto pi numutanaiye, loto ya mona nosámibo hofa molámo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Feto loto lomuito, we yakafo uto Yuda wenina feto loto lobibo, Lifefe lo nedaibo wema ya Yesu ya ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ena Yesukafo ya Sabati foliku ya ononawa libo yagunu ya Yuda wenina yasi li hena mofu edae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Feto fe minato, Yesukafo feto loto lobibo, Menefo yakafo onona hamena-hamena li nebo yagunu neimo yagi li minowe, loto lobibo ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","yagunu emotinasi feto loti holiyabo, Yesukafo ya Sabati foli ya li hopaitaibo yako minámiye. E'e, ito yoto Goti yagunu neimo Menefo ne, loto eimola ya li Goti nabamaidana itaiye, loti ya idafa loiti yagunu hofo fulinune, loti holi mumo yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ena Yesukafo ha feto loto lobibo, Ha ona hula lobiyowe. Goti Hipala neimo lune-haneuti hane kito onona liyámanobo ne. E'e, Menefokafo onona lido ya wa edoto, ayalo yako ya li-li o minowe. Idafa-adafa muki Menefokafo lido ya Hipala nemokafo ayalo li-li o minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Menefokafo Hipala nemo lula-hala numuto, onona li nebo onona nilibi hulo ne. Ido onona me ya wa minabo yako minámiye. E'e, onona naba nilibiyageto hemotina wa edanabo ya eleginigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Menefo yakafo wenina fuliyabo ya li sinoi betito, nomudina hofawa li bibo ayaidana oto Hipala nemokafo we ma wena ma nomudina hofawa li binowe, lanobo ya aifa li binogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ido Menefo ya wenina lifima ha liwila oto biyámanaibo ne. Ononawa ya Hipala nemo anelo molaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Feito ya Menefo huliya li faka labo wenina muki ya ayaidana oti Hipala nemo huline li faka lo minanigilae. Ma yasi Hipala nemo huline li faka ladámanabo yasi nilifi molaibo we Menefo ayaidana oti ya huliya li faka ladámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nemo ha ona hula lobiyowe. Nemo hane holi lutinau moloti ido nilifi molaibo we holi hikito muwabo wenina ya nomudina hofawa minowa-minowa anabo mona ya moda litabo ne. Ido lifima ha liwila oti liyámanigilae. E'e, fulinabo mona ya fulititi, onesa meloti ya hofawa minomo yonigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nemo ha ona hula lobiyowe. Hamena ma anaibo ya moda fedotaiye. Yalo ya fuliyabo wenina yasi Goti Hipala nemo none fefeluma holiti, nomudina hofawa minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Menefo nomuna hofawa minomo yoibo mona ya moda mino edaibo ne. Ido Hipala nemo yagi ayaidana oto nomune hofawa minomo yowobo mona ya mino hedanaiye, loto monawa numibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ido We Hulama minonako, wenina lifima ha liwila oto li binane, loto lonumibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ha ya holiti hatina loiti-loiti kiyámilo. Hamena molaibo ya alili ageto ya hono molagu uno minabo wenina ya nemo none fefeluma ya holiti ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","sinoinigilae. Sinoiyato, ya wenina mona dowa molabo ya sinoinado ya nomudina hofawa minomo yonigilae. Ido wenina mona nosámibo molabo ya sinoinado ya lifima ha liwila oto binogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nemo neimone weune-lune-haneloti holito onona linobo ma minámiye. E'e, Menefo welalotiko lifimatina liwila oto bi-bi o minowe. Neimo weneloti onona linowe, loto holiyámoto, nilifi molaibo we welalotiko linowe, loto holiyonako, lifimatina liwila oto bi-bi obo ya fefe lanogolaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ido Yesukafo ha ma onu ito libo, Neimone monane lanobo yakafo hula ámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Makafo monane lo oloto molo ne. Lo oloto molageto ya hulawa anogolaiye, loto holi minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hemotina ya wenina Yoni nedo idipi molato uti loga o edato, ha ona hula lo oloto molaima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nefa, wenina yasi monane lo oloto molanae, loto ladámowe. Hawa lobo ya hemotina holiyato Gotikafo li nomudina wanaiye, loto heimotina yagunu ya lo minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni ya le lamu yaidana oto li lamena o betima ne. Feto feyaito hamena yalo hemotina ya lamenala wa dowa moloti minama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nefa, Yonikafo nemo monane lo oloto molaibo ya mulaloko lo oloto piye. Menefokafo onona ha lonumibo onona hula li oloto pi hulanane, loto nilifi molaito lomobo ne. Nilifi molaibo monawa ya ononane yakafo ya li oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ido Menefo nilifi molaibo yakafo emo yagi monane lo oloto pibo ne. Hemotina ya eimola welaloti ha holiyámabo ne. Ido hola-wela yagi ya wagámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ido nilifi molaito minobo ya hemotina holi hikito nomámanako, hala ya lutina-hatinau mino betiyámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hemotina ha mono lufuwau ya hitoti ya nomudina hofawa minanabo monawa ya li oloto pinune, loti holiti ya hitae. Feto loti hitagu ya lufuwa yakafo ya nemo monane lo oloto molaifa, hemotina holi nomámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ido hemotina nemodoka ya ato nomudina hofawa li binowe, loto lofa, hemotina ya eleka hofo betito nemodoka ámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wenina yasi nemo huline ito yonae, loto ladámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Hemotina monatina ya holi minowe. Weudina-lutina-hatina Gotidoka ya minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","E'e, nemo Menefo welaloti hemotina minado lomobo nefa, hemotina nemogi houna iyámae. Ena minoto we ma eimola hala kido lo fedanaibo ya emogi houna inae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hemotina ya wenina yasi ebotina lanabo ya dowa holiyafa, ido Goti mako nebo wekafo ebotina lanaibo mona ya molanune, loti holiyámabo wenina ya hemotina igaidana oti holi hikito munabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ido hemotina ya emo yakafo Melafo lomuwageto sigiya lolumunogolaiye, loti ya nemogunu ladámilo. Feito minámiye. Hemotina Mosesedoka keloti minabo nefa, Mosese eimola hala yakafo sigiya lobinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesekafo ha lufuwa igu ya nemogunu ibo nenako, hemotina hala holi hikitabo neko, nemogi holi hikito nomadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nefa, hemotina Mosese hala lufuwa holi fulitanako, nemo hane igaidana oti holi hiki lanabo ne? loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesukafo ha ya lo huloto Galili momeno huliya ma Taibeliyasi momenolo yalo ya lekoto filiga yolaleka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wito, wenina mau naba ya idafa-adafa hiliyabo wenina li faka lo betito monala itibito wabo yagunu ege moloti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ege moloti uwato, Yesu ya ege-ege moniyabo we idipito obulalo ya yoti amedoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ido Yuda wenina Gotikafo Uta O Betibo foliwa alili aito ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ya wa faka loto weninawa nuba naba-nabama lo fedato wa betito Filipi loga o edoto libo, Beleti ya igaloti meina fito wenina naba me ya ya biyogeto ogofunaibo ne? loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","idafa anowe, loto holi minoto ya hepa moloto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Loga o edaito, ya Filipikafo ha liwila oto lomuibo, We makafo igana eiti (8) ya onona lito meinala lito molomo yonaibo yakafo beleti meina fito biyogeto houmatina ámanogolaiye, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lomuito, ege-ege moniyabo we yauti ma Saimoni Pita unalafo Adulu yakafo feto loto lomuibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Melo ya hipa ma nebo yakafo beleti suwa baligunu lifefe labo faifu (5) ido laefa loiti yagi li nefa, wenina mau naba minanako, efo yakafo neidafa anune? liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Feto lito, Yesukafo libo, Hemotina wenina lobiyato ya li nuba oti mikalo minalo, lito minato mika yalo ya suwa eba naba-naba nedo ya wemoli faifu tauseni (5,000) ya amedoti minomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Feti amedoti minomo uwato Yesukafo beleti ya lito, dowae, lalowe, lomuto, weninawa nuba naba amedoti minabo ya hona molo biye. Ido laefa yagi ayaidana oto ya feito nanune, loti holiyado ya biye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bito, hobina noti-noti houmatina aito Yesukafo ege-ege moniyabo we feto loto lobibo, Luma nebo ya u hopa otanaiye. Li haka alo, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","beleti suwa baligunu lifefe labo faifu (5) yamakafo luma neboma ya haka oti owo egepisa naba tuwelu (12) ya holiyato lumuto faito fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ido wenina aubala itibibo idafa feto feyaibo monala wati ya feto loti labo, Polofeti yama mikaleka oloto pinaiye, loti laboma moda me ya ya ne, loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ido Yesu li hona o edoti adinagunu liti hiyabate wehudi buli edanune, loti ato, ya wa betifefe loto fulo betitoto, eimolako obulalo ya yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena lunaga fo sapito ya ege-ege moniyabo we ya momeno anawalo lumuti ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapeneyamu numudo liwila oto unune, loti sipiku yowae. Sipiku yowato, midipu naba ito ya Yesu lo fedámito wewa yako uwafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","asi auba ito, no halafu naba itaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","uti alo faiga faifufe (5), ido sikisife (6), kilomita yaidalo uti no lusaku ya u fedato, Yesu ya no mulalo ya lala-lala ito egetina uto sipi ya li alo alili molaito wa edoti ya utina ololo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Feto fe minato, ya sutina fito libo, Nemoma minowe. Hemotina ya holi biyámaneyo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lobito, sipiku ya yowo, loti ilimi molo itoti ya unune, loto holiyabo ebalokama sipi ya aloko u ayalo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ena wenina nuba naba-naba ya momeno filiga yolaleka uno minato, ho lito ya feto loti labo, Aso lubuka ya sipi mako yako neto ya wa minogeto ayau ege-ege moniyabo we ya Yesu fulo edo itoti eimotinako yoti uwaboma ne, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Feto loti holiti minato ya Taibeliyasi numudoti sipi ma ya Wenabakafo dowae, lalowe, lomuto hobina bito, nado yaloma ya lo fedato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","wenina yasi Yesugi ido ege moniyabo we yagi melo minámae, loti holiti ya sipiku ya yoti Kapeneyamu numudoka liwila oti uti yalo moni witala ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Momeno wela meleka ya weninawa Yesu moni witala oti li oloto piti ya feto loti lomuwabo, Api lilibiyanibo we, hemo nenafeko anibo ne? loti loga o edato ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesukafo feto loto lobibo, Nemo ha ona hula lobiyowe. Hemotina idafa mona hofawa aubane itibiyoto wa minabo yagunu ya holámae. Wetina-idafa biyoto noti houmatina aibo yamagunu ya nemo moni wita minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hemotina ya onona liti hobina aifa idafa u hopa unaibo idafa yagunu ya holiyámilo. Nomudina hofawa minowa-minowa anabo hobina yagunu ya ononawa liyalo. Nemo We Hula ya Goti Menefokafo lufuwala molo numibo yagunu ya nemo hofawa minomo yonabo hobinawa ya binogolowe, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lobito, feto loti liwila oti loga o edabo, Lemo nena-idafa oto Goti ononala li minanune? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesukafo liwila oto lobibo, Gotikafo nilifinako, holi hikito numu-numu o minabo wenina ya Goti ononala li minabo wenina minae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Feto lito, emotinasi liwila oti lomuwabo, Ena nena idafa ma hofawa eitoma aubaka lilibiyanibo idafa ya li oloto piyageto wato holi hikito humunune? Hemo nena onona linane? ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Awatefo holofate-mota yasi mika hafali mikalo ya wetina-idafa huliya mana no-no abo yagunu feto libo, Nanae, loto okulumauti hobina bibo ne, loto ha mono lufuwau (Kis 16:4, Sng 78:24) ya nebo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Feto lato, Yesukafo feto loto lobibo, Ha ona hula lobiyowe. Mosesekafo ya okulumauti hobina biyámima ne. E'e, Menefokafo ya okulumauti hobina hula bi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hobina okulumaukati lumuto mikaleka wenina nomudina hofawa li oloto pi bibo ya Goti hobinala hula ya ne, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","emotinasi feto loti lomuwabo, Wenaba, hemo hobina lanibo ya hamena-hamena lumutoko mino, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Lomuwato, Yesukafo feto loto lobibo, Nomudina hofawa mino-mino abo hobina ya nemo ya minowe. Nemodoka abo wenina ya moda inagunu fuliyámanigilae. Ido holi hikito numu minabo wenina ya moda no yagunu holiyámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Feito nefa, hemotina ya nemo wa nedafa, wati holi hikito nomámae, loto ya lobitoma ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Menefokafo numu nebo wenina ya nemodoka lo hulanabo ne. Ido wenina nemodo anabo ya ma li hopa fulo betiyámanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Okulumauti lomobo ya neimone weneloti ha ononawa linowe, loto lomámowe. E'e, nilifi molaibo we welaloti ha ononawa linowe, loto lomobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Menefokafo numibo wenina muki yauti ma u hopa aguwámanae, loto wa betito hiyaba o betito hamena nabalo ya muki li sinoi betinogolowe, loto lobo ha ya nilifi molaibo we hala dowa kibo ha ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hipala nemo wa nedofefe loti wa nedoti, holi hikito numunabo wenina muki ya nomudina hofawa minomo yoti minanigilae, loto lobo ha ya Menefo hala dowa kibo ha ya ne. Ena neimone hamena nabalo ya li sinoi betinogolowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Feto loto ya okulumauti hobina ya nemo ya minowe, libogunu ya Yuda wenina yasi holi nosámibogi ha feto loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","lo minabo, Ena, me ya we ya Yosefe hipala Yesu olafote melafote loiti ya lemo wa betiyonima ne. Ido okulumauti lomoma ne, loto libo ya neidafaito feto loto ya lo ne? lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Feto lato, Yesukafo liwila oto feto lobibo, Hemotinau ya holiyabo nosámibogi feti ya ladámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","We ma eimola lula-halauti holito nemodoka anaibo ya ma minámiye. E'e, Menefo nilifibo yakafo ika o betiyagetoko anabo ne. Weninawa ya neimo hamena nabalo ya li sinoi betinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Polofeti yasi feto labo, Goti eimolakafo wenina muki ha mono api itibinogolaiye, loti ha mono lufuwau (Ais 54:13) ya nebo ne. Yagunu wenina ya Menefokafo ha lobito api itibibo ya hawa holiyabo wenina ya nemodoka anigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Menefo wa edabo wenina ya ma minámae. E'e, Gotidokati lomobo we nemo makokafo Menefo wa edobo we ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nemo ha ona hula lobiyowe. Ma yasi nemo holi hikito nomabo wenina ya nomudina hofawa minomo yotiko minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nomudina hofawa minanabo hobinawa ya nemo ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hemotina awatinafo-holofatina ya mika hafali mikalo ya wetina-idafa huliya mana oloto pito ya noti minoti fuliyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nefa, wenina masi okulumauti lumibo hobina nanabo wenina ya fuliyámanigilae. Ya hobinawa nemodoka me ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nomudina hofawa minanabo hobinawa ya okulumauti lomobo nemo neimone ya minowe. Yagunu ma yasi nemodokati hobina noti ya minomo yoti minowa-minowa oti minanigilae. Nemo milane ya hobinaidana ne. Mikau-mikau wenina nomudina hofawa minomo yonae, loto ya milane binogolowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yagunu Yuda wenina heimotina ha loyoilumu oti feto loti labo, We ya igaidana oto milala lomageto nanubogunu liye? lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Feto lato, Yesukafo feto loto lobibo, Nemo ha ona hula lobiyowe. Hemotina ya We Hula nemo milane ido lunune námanabo ya nomudina hofawa minanabo mona ya lutinau mino betiyámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma yasi nemo milane lunune notiko minanabo wenina ya minowa-minowa oti minato neimo hamena nabalo ya li sinoi betinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nemo milane ya hobina hula ne. Ido lunune ya no hula ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nemo milane ido lunune notiko minanabo wenina ya nemo luneu mino nedanigilae. Ido nemo yagi emotina lutinau mino betinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Menefo ya minowa-minowa oto nebo we yakafo nilifi molaito lomobo yagunu Menefodo metolito mino-mino o minowe. Feito minoto nemo noti minanabo wenina yagi ayaidana oti nemodo metoliti minanabo ya minomo yoti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Okulumauti hobina ya monawa feito ne: Ya awatinafo-holofatina yasi mana noti ya minoti fuliyama nefa, nemo hobinane me ya nanabo wenina ya minomo yoti minowa-minowa oti minanigilae, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hawa ya Kapeneyamu numudo mono numugu ya minoto ya lobito api-napi itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Feto loto api itibito, ya ege molabo wenina yauti wenina abi loti holiti feto labo, Ha ya holiyonibo henaidana oto liye. Ya hema holinaibo ne? loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ya eleka hofo betito Yesukafo ya lula-halau holito feto loto lobibo, Hemotina ha ya holiyabo nosámife? ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Feti holiyabo ya We Hula nemo homu minobo ebato liwila oto yowoto ya nomudinagunu watima ya neidafa anabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ute etuwa ido mila yakafo nomude hofawa minomo yonubo hanuwa ma minámiye. E'e, nomude hofawa minomo yonubo hanuwa ya Goti Weuna ononala ne. Nemo ha lobiyobo ya weudina ido nomudina hofawa minomo yonabo hanuwa ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nefa, hemotinadokati wenina malekaloka holi hiki ladámo minae, loto lobiye. Yesu ya holi hikito umámabo ya aidena yoimalokati wa beti huloto wa betimo yoiye. Ido ayaidana oto uwolafo adinalo molanaibo we yagi wa edofefe loto wa ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ido ha ma feto loto onu ito libo, Yagunu ya feto loto lobiyoma ne. Wenina ya Menefokafo li aila i betiyámageto nemodoka loti minanabo ma minámiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ena hamena yaloti ya ege molabo wenina yauti wenina abi loti emo nedo ya minámanune, loti eleka hofo betito fulo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yagunu Yesukafo ege-ege moniyabo we tuwelu (12) ya loga o betito libo, Hemotina ayaidana oti fulo nedanune, loti lo minafe? liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ido Saimoni Pitakafo feto loto lomuibo, Wenabao, hemo fulo hedoto hemado unubo ne? Hemo makokafo nomude hofawa minanubo hala li minane. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lemo ya hemo holi hikito humuto feto loto holi humu minonibo ya hemo ya Gotidokati fele we minane, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Lomuito, Yesukafo feto loto lobibo, Nemokafo hemotina tuwelu (12) ya sutina fiyofa, ido hemotina yauti ma ya Satanidoka keloto ne, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hawa lobibo ya ege-ege moniyabo we tuwelu (12) yauti ya we ma uwolafo adinalo molanaibo we Saimoni Isikaliyoti hipala Yudasi yagunu liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ena Yudia ebalo Yuda wenina yasi, Yesu hofanune, loti hudala hiyabo yagunu mikatina fulitoto Galili mikalo yako u yaleka meleka oto moniye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Feito moni neto, Yuda wenina numuna holo-hala huwabo foliwa hamenatina alili aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Alili aito, Yesu unalafo-mota yasi feto loti lomuwabo, Hemo ya aubaka itibiyanibo idafa ma li oloto piyageto hege molabo wenina yasi wanae, loto ya eba me ya fulitoto ya Yudia mikalo ya uto itibiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma yakafo li oloto pinowe, lanaibo ya faluku oto minoto onona linaibo ya ma minámiye. Yagunu hemo ya onona yaidana linowe, loto holinanibo ya uto wenina muki ya li oloto pi biyageto wanae, loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","unalafo-mota yasi holi hikito umámoti feto lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Lato, ya Yesukafo feto loto lobibo, Hemotina hamena-hamenau ya idafa anune, lotima aifa anigilae. Nemo hamenane ya onesa lo fedámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wenina yasi ya hemotina holi nosámibo biyámanigilae. Nemo ya monatina nosámibo ya lo oloto pi betiyobo yagunu holi nosámibo numu minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Heimotinako foliku ya wilalo. Nemo ya hamenane lo fedámibo, yagunu ya onesa feto-namato ya aguwámanogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Feto loto Galili mikalo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ena unalafo-mota homu uwato, aliga eimolako umalo pito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ena foliku ya Yuda wenina hiyaba we yasi moni witala oti feto loti loga-loga abo, Igaleka ne? loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ido aifa wenina yasi emogunu momona oti humomo fimo yowae. Yauti malekamasi, Emo ya we dowa ne, lato ido malekamasi, E'e, feito minámiye. Emo ya wenina hotina i ne, loti lafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yuda we hiyaba we holitina ya holiti ha oloto ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ena foli hofalau ya Yesukafo ya fele huliyagi numuna naba hilalau ya yoto ha mono loto api-napi itibito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuda we hiyaba we yasi, Aiyo, lo holiye, loti ya feto loti labo, Lemo lufuwa numunateu ya yowámima nenako, igalekati loto ha mono monawa ya holito liye? lato ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesukafo feto loto lobibo, Nemo mono api itibiyobo ya nemodokati minámiye. E'e, nilifi molaibo we yalekati ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yagunu wenina masi ha mono monawa me ya ya Gotidokati nefemo, ido neimo Yesudokati ne? loti moni wita anabo wenina yauti Goti hala dowa kido hololanune, loti holinabo wenina yasi monawa holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Makafo eimola halaukati holito lanaibo we ya eimola huliya yoto minanaiye, loto lanogolaifa, nemokafo nilifi molaibo we huliya yoto minanaiye, loto lobo ya mona ona hulako moloto, nosámibo mona ma ya uneu minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesekafo ya lo molaibo ha lo oloto pi bima nefa, hemotinalokati ya ma lo molaibo ha hololabo we ma minámae. Ena hemotina nena idafagunu ya hofo nedanune, loti ya lo minae? lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lobito, ya wenina aifa wenina yasi feto loti labo, Hemo ya Satani himiwelakafo luka-hakau mino hedaiye. Hemo hema hofo hedanowe, loto liye? lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lato, ena Yesukafo feto loto lobibo, Nemo Sabati foliku idafa hofawa mako aubane itibiyobo yagunu oti aiyo, loti lo yaleka meleka oti hofo hedanune, loti lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesekafo hipatina-mota utinalo Goti anela fukanune, loto lobima nefa, ya monawa ya Mosesekafo api itibiyámito, awalafo-holofala yasi apiyama ne. Feto lobinako, hemotina Sabati foliku ya Goti anela fuko-fuko o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yagunu ya Mosesekafo ha lo molaibo ya holi fulitotanune, loti ya Sabati foliku ya hipatina-mota utinalo ya Goti anela fuko betiti ononawa ya li-li o minae. Feto fe minabo nemo ya Sabati foliku ya we ma ula-falau muki ya lifefe lo edobo yagunu ya neidafaiti ya holi nosámibo nomae? ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wenina monatina wafefe ladámotima aifa hopa lifima hawa ya ladámilo. Wafefe lanado yaloko lalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ena Yelusalemu wenina yauti masi feto loti labo, We ya hofanune, loti lo-lo aboma ya moda me ya ya nebo yae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Neidafaito ha olotoko libo ya mono hiyaba we yasi ha lo fuko edámabo minae? Ya monala holiyabo ya Gotikafo ilifi molaibo we Kilisto ne, loti holiyafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E'e, Yesu oloto pibo eba ya holi minoba, Goti ilifi molaibo we Kilisto oloto pinaibo ya ebala ya holifefe ladámanogolone, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Feti labo yagunu Yesukafo ya fele huliyagi numuna nabau ya ha mono api itibi minoto lo faka loto libo, E'e, hemotina wafefe loti wa nedoti nemo oloto piyobo eba ya holi minone, lafa, lomobo ya neimo lune-haneuti holito lomámobo ne. Mona ona hula yawala nebo yakafo nilifi molaito lomobo ne. Ido emogunu ya hemotina hatina kifefe loti holámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nemo ya eimola lula hamanauti nilifi molaito lomobo nenako, nemo wa edofefe lo minowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hawa feto libogunu nala i edanune, loti lafa, hamenala onesa lo fedámibo yagunu adina hena aito fulitae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ena wenina aifa wenina muki yasi Yesu holi hikito muti feto loti lo minabo, We me ya yakafo idafa hofawa aubala lilibi nebo ya Goti ilifi molaibo we Kilisto lo fedanaibo yakafo we me ya li yoima o edoto ya li oloto pinogolaife? loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ena wenina mau minabo yasi hawa emogunu momona oti humomo fiti lato ya Falisi we yasi holiti, Goti sokila hi mu-mu abo we hiyabatina we yagi ya loyolalo-melo oti, Yesu ya nala fi edalo, loti fele huliyagi numuna naba himiwe idipi molato uwabo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","yagunu Yesukafo feto loto libo, Nemo hamena fouma efoma hemotinagi minoto nilifi molaibo we nedoka liwila anogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Liwila oto, hemotina nemogunu moni wita oti li oloto piti wa nedámanigilae. Ido uto minanodo ya hemotina ma aguwámanigilae, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Lobito, Yuda wenina yasi feto loti loyolalo-melo abo, Wewa ya igaleka uwageto moni witala oto li oloto piyámanubo ha liye? Yuda weninasi Giliki mikalo minomo uwadoka ya uto Giliki wenina ha mono lobinowe, loto holito life? ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Moni witane oti li oloto piti wa nedámanigilae, loto, ido unodo yalo ya ma aguwámanigilae, loto libo ya igaidanagunu liye? loti ya loyolalo-melo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ena Yuda wenina yasi foli minomo yoti mino hulanune, loti wenina nuba naba-naba iti minato, Yesukafo sinoito minoto ha auba ito libo, Ma yasi nogunu holinabo ya nemodoka loti nanae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ido ma yasi holi hikito numu minanabo yagunu ha mono lufuwatina yau feto loti iyabo, Yaidana abo wenina ya no atala yaidana oto lutina-hatinau li oloto pi betiyageto no yaidana oto lumutoko minanogolaiye, loti ya iyabo ne, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","hawa libo ya Weuna yagunu liye. Ido monawa feito ne. Yesu holi hikito muwabo wenina ya Weuna Fele binowe, loto ya Yesu hamena yalo ya okulumau lamenala lulau ya liwila oto yowáminako, ya Weuna lomámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ido wenina ya ha ya holiyagu yauti masi Yesugunu feto labo, Emo ya polofeti yama ona ne, lato ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ido masi, Emo ya Gotikafo ilifi molaibo we Kilisto ne, lato, ido malekaloka yauti masi, Fulitalo. Kilisto ya Galili mikalo oloto pinaibo nefe? E'e, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kilisto ya Defiti numuna atala Betelehemu yalo Defiti yufa fibo wenina yauti oloto pinogolaiye, loti ha mono lufuwau ya feto loti iyaboma ne, loti lanako, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","wenina muki ya emogunu ha eito-eito loti foki yaleka-meleka oti, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","malekamasi nala hofo edanune, loti lafa, adina hena aito fulo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ena fele huliyagi numuna naba himiwe ya Goti sokila hi muwabo we hiyabatina we ido Falisi we minado ya liwila oti uwato, loga o betiti labo, Hemotina neidafaiti liyámoti aifa ae? loti loga ato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","himiwe yasi ha liwila oti labo, Ena, wewa ha libo yaidana oti homuma ladámabo nenako, loto liyámoto aifa one, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Falisi we yasi ha liwila oti lobiyabo, Hemotina yagi ya hotina ife? ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hiyaba we wenaba yauti ido Falisi we lemodokati ya ma holi hikito muwobe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","E'e, ya ma feto ámonibo nefa, wenina aifa wenina nuba minabo yama lo molaibo ha ya holiyámoti, Goti nomunalo u hopa unabo wenina yamako holi hikito muwae, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Feto lato, ena hounatinafo we ma Nikodemusi ya homu Yesu nedo wibo we ya feto loto lobibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Hemotina we ma monala ya loga o edoti holiyámoti, ido monala nosámibo wa edámoti lifima ha lobinabo yamaidana aiye. Feto feyalo, loto lo molaibo ha lufuwa iyagu yau feto loto nebo nefe? Feito minámiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","hounalafo-mota yasi ha feto loti liwila oti labo, Ena, hemo yagi Galili mikaloti abe? Ha mono lufuwau ya hitoto walo. Polofeti ya Galili mikaloti oloto piyámanabo ne, loto nebo ya walo, loti lae.  ");
INSERT INTO snp_lambau_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Feto loti upatoti numunatinau-numunatinau uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ena Yesu ya Olifi obulalo ya yoto neto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ho lito yaloti liwila oto fele huliyagi numuna naba hilalau yoito, wenina masi emodoka loti nuba ato, yalo amedoto minoto ha mono lobito api itibito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","lo molaibo ha api itibi-itibi abo we ido Falisi we yasi wena ma hume-ugele o nedo wa edoti li oloto piti Yesu nedo ilimiti uti li nomudinalo sinoi edoti ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesu feto loti lomuwabo, Api lilibiyanibo we, wena me yakafo hume-ugele o nedo wa edoto li oloto piyone. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yagunu Mosesekafo wena yaidana anabo ya hefanagunu hofo beti fulilo, loto lo molaibo ha yamo lolumiye. Ido hemodokati ya neidafaiye loto ne? loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ya aifa feto loti loga o edoti, ha li yaidana-meidana hama lagetoma ya sigiya lo edanune, loti hepa moloti lae. Feto lato, Yesukafo huba ito anagunu mikalo ya lufuwa iye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lufuwa i neto, loga-miga o edato, emo ya sinoito feto loto lobibo, Hemotina yauti ma lifimala minámageto minanaibo we yakafo apito hefanagunu hofageto ya hofalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Feto lototo hofa huba ito mikalo ya lufuwa iye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ena emotinasi hala holiti hiyabatina we we kilofo ya homu wito wa edoti mako mako ege uti u hulato, wena ya Yesu nomunalo eimolako ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ena Yesu ya sinoito loga o edoto libo, Wenao, igaleka uwae? Lifima ha ma lohomámabo nefe? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","wenawa yakafo libo, Wenaba, ma minámiye, lito ya Yesukafo libo, Ena nemo yagi lifima ha ma lohomámanogolowe. Hemo ya liwila oto uto mona nosámibo ya hofa molámo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ena Yesukafo wenina ha ma onu ito lobibo, Nemo wenina mikau-mikau ya lamenatina minonako, ma nemo nege-nege moninabo ya midipu igu ya moniyámanigilae. E'e, nomudina hofawa minanabo lamenawa ya mino betinogolaiye, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lito, Falisi we yasi feto loti lomuwabo, Me ya ya hemo heimo monaka lo oloto molanibo yama holiyonibo hula minámiye, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesukafo feto loto lobibo, Nemo ya obo ebalekati ido unobo ebaloka ya monawa holi minonako, nemo neimo monane lo oloto moloto hulawa o ne. Hemotina ya obo ebalokati ido unobo ebaloka ya monawa holiyámoti holi hopaitae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hemotina lifima ha lo-lo o minabo yakafo etuwa o ne. Nemo ya lifima ha ya onesa ladámanobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nefa, ido ma lanowe, loto lanobo ya moda ona hula lanobo ne. Nemo lifima ha ya neimoko lanobo minámiye. E'e, Menefo nilifi molaibo yakafo ane li faka lageto lanobo yagunu hula anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ido heimotina lo molaibo ha lufuwatinau yau feto libo, We loiti yasi we ma monala lo oloto pitoma hula ne, loto ya lufuwau yau nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yagunu ya nemo monane lo oloto piyoto ido Menefo nilifi molaibo yakafo ayaidana oto monane lo oloto pi ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ha ya feto loto lobito, emotinasi loga o edoti labo, Mekafo iga ya ne? lato ya emokafo lobibo, Hemotina nemo wa nedofefe ladámanako, Menefo ayaidana oti holifefe ladámae. Nemo ya wa nedofefe labo neko Menefo yagi holifefe ladi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Feto loto Yesukafo fele huliyagi numuna nabau ya hefana molabo huwamena negu eba mau ya ha mono lobito ha ya liye. Ena hamenala onesa alili ámibo yagunu ya adina hena aito nala numugu ya fulo edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ena Yesukafo onu ito feto loto lobibo, Nemo fulo betito uwoto hemotina nemogunu moni wita oti ya lifimatinagi minoti fulinabo ne. Nemo uto minanodo ya hemotina aguwámanigilae, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yuda wenina yasi labo, Nemo unodoka ya aguwámanigilae, loto libo ya neidafaito ya liye? Eimola nedala lito fulinogolo lifemo? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesukafo feto loto lobibo, Hemotina ya wakati minae. Nemo ya okalekati minowe. Hemotina ya mikalo meloti minafa, nemo ya mikalo meloti minámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yagunu ya lifimatinagi ya minoti fulinabo ne, loto ya lobiyobo ne. Nemo minobo me ya ya monane lobi-lobi obo ya holi hiki ladámanabo ya lifimatina aifa mino betiyageto fulinigilae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Feto lito, ya emotinasi loga o edoti labo, Ena, hemo hema minane? lato, Yesukafo lobibo, Onona apiyodoti lobi-lobi obo aya efo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nemo ya hemotina lifimatina ido henatina yagunu ha abi li minofa, nilifi molaibo we yakafo eimola ha ona hula lo-lo o neto, neimo ya emo welauti holiyodo ya mikalo melo lo oloto molowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hawa ya Melafogunu feto loto lobifa, emotina yasi holifefe ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yagunu Yesukafo onu ito feto loto lobibo, Hemotina We Hula nemo yá yofolo hofo nedoti li faka yoisa lo nedanado ya monane holifefe lanigilae. Ido neimone lune-haneuti holito idafa ma ámoto, Menefokafo api nilibibo hawa ya lo minobo yagi ya holifefe lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nilifi molaibo we ya nemodoka mino nedaito, nemo hamena-hamena idafa oto holibo dowa libo yagunu nemo ma fulo nedámiye, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ha feto lo neto wenina abi holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ena Yesukafo holi hikito muwabo Yuda wenina feto loto lobibo, Hemotina ya nemo hanelo moni minanabo ya nemo nege moniyabo wenina hula minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Feti minoti ha ona hula ya holifefe lato, aya hawa ona hula yakafo wina betinogolaiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Feto lito, emotinasi ha liwila oti feto loti lomuwabo, Lemo Abalahamu yufa fibo weninala minonibo ya ma nala i ledato minámoninako, hemo wina betinaibo ne, loto lanibo ya neidafaito lane? lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Lomuwato, Yesukafo ha liwila oto feto loto lobibo, Nemo ha ona lama lobiyowe. Ma yasi nosámibo mona molabo ya monawa yakafo nala i betito, nalalo houba-naba o minabo yagunu lowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nala i betibo wenina wenabatina numuna ebalalo ya hamena-hamena hiyaba oti minomo yowámanigilae. E'e, Hipala ya Melafo numunala ebalalo ya hamena-hamena minowa-minowa oto minomo yonogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yagunu ya Hipala nemo wina betiyotoma hemotina ona nala i betiyámageto minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hemotina Abalahamu yufa fibo weninala minabo ya moda holi minowe. Feti minafa, nemo hane ya hemotinaloka hopopo o nenako, hofo nedo fulinune, loti lo-lo o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nemo Menefodoka idafa wa obo ya lo-lo o minowe. Ido hemotina heimotina metinafodokati idafa holiti ya fe-fe minae, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lemo metefo Abalahamu ne, loti ha liwila oti lomuwato, ya Yesukafo feto loto lobibo, Hemotina Abalahamu yufa fibo weninala hula minabo neko emo monala yaidana oti molo minadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nefa, Gotidokati ha ona hula holiyobo lobi minobo ya hemotina hofo nedanune, loti lo minae. Idafa yaidana Abalahamukafo feyámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hemotina ya heimotina metinafo hanulalo ya egeto moloti lala i-i o minae, lito ya emotinasi feto lomuwabo, Hopa hanudoti oloto piyonibo minámiye. Metefo mako Goti ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesukafo feto loto lobibo, Nemo ya Gotite minoidoti lomobo ne. Neimo lune-haneuti holito lomámobo ne. E'e, emokafo nilifi molaito lomoboma nenako, hemotina metinafo ya Goti nebo neko, lutina-hatina ya nemo nomadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Neidafaiti ya ha lobo ya holifefe ladámo minae? Nemo ha lobo ya hemotina ogofuti holiyámabo yagunu ya holifefe ladámo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hemotina metinafo Satani weninala minoti, metinafo feyaibo mona ya meyalo molanune, loti holiti minae. Emo ya hana yoimaukati hofo beti fulimo yoibo we ya ne. Ido lula-halau ha ona ma mináminako, ha ona hula holi fulitaibo we ya ne. Emo ya ha sugi we ido sugi yawala nebo yakafo eimola monala ya moloto ha sugi lo-lo o ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ido nemo ya ha ona hula lobi-lobi o minofa, hemotina hane ya holi fulo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hemotinalokati masi nemo lifimane lanabo ya fowe loti ladámanigilae. Nemo ha ona hula lobiyobo ya neidafaiti holi hikito nomámae? ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wenina ma Goti weninala minabo yasi ha libo moda holi minae. Hemotina Goti weninala minámanako, hala holi fulo minae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Feto lito, Yuda wenina yasi ha liwila oti feto loti ya lomuwabo, Hemo Samalia we ma Satani himiwela luka-hakau yoto ne, loto ya ha ona lo minobe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesukafo ha liwila oto feto loto lobibo, Satani himiwela lune-haneu minámiye. E'e, nemo Menefo huliya li faka lo minofa, hemotina ya nemo huline ya ito lumuti fulo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nemo neimone huline yonaiye, loto ladámowe. Makafo huline li faka lo nedanaibo ya hona moloto lifefe lanaibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nemo ha ona hula lobiyowe. Ma yasi nemo hane li minanabo wenina ya fuliyámanigilae. E'e, moda minowa-minowa oti minomo yonabo ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Feto lito, Yuda wenina yasi feto loti lomuwabo, Hemo Satani himiwela luka-hakau mino hedaibo ya onesa ona holi minone. Abalahamu moda fulibo ne. Ido polofeti ya ayaidana oti fuliyabo ne. Ido hemo feto loto lanibo, Nemo hane li minanabo wenina ya fuliyámoti, minowa-minowa oti minanigilae, loto lanibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ya awatefo-holofate Abalahamu wenaba yama fuliboma nenako, hemo ya li yoima edanowe, loto labe? Ido polofeti ya ayaidana oti fuliyabo ne. Hemo neidafaito heimo hulika ito yoi minane? loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Feto lato, Yesukafo ha liwila oto feto loto lobiye. Nemo neimone huline li faka lotoma ya huline u aifa idafa anogolaiye. Menefo yagunu Gotite ne, loti laboma ya emokafo huline li faka lo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hemotina abo ya holifefe ladámae. Nemo ya holifefe lo minowe. Yagunu nemo ya holifefe ladámowe, loto lobo neko, ya hemotina yaidana minoto ha sugi ladi ne. Ido nemo ya holifefe loto hala li meyalo moloto moni minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Awatinafo-holofatina Abalahamukafo ya nemo hamenane alili ageto wanowe, loto dowa loto holi nebo ne. Ido minoto hamena alili aito wato ake ima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Feto lito, Yuda wenina yasi lomuwabo, Hemo melegeka fifiti (50) ya li fulámaninako, hemo Abalahamu wa edanibo nefe? Olo, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesukafo lobibo, Nemo ona lama lobiyowe. Nemo Abalahamu oloto piyámito minobo wema minowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Feto libogunu hefana liti hofanune, loti lafa, fele huliyagi numuna nabau yati ya faluku oto u yau meu oto feka lumuto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ena Yesukafo ya hanudo uto we ma olafo houmalauti nomuna likaibo li oloto pito wa edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ege-ege moniyabo we yasi loga o edoti labo, Api lilibiyanibo we, hema lifimalakafo nomuna likaibo ne? Me ya ya eimoladokati nefemo, ido olafo melafodokati ne? ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Feto lato, Yesukafo feto loto lobibo, E'e, eimola lifimala ido olafo melafo lifimatina yalekati ya minámiye. Goti aubala monala emodoka oloto pinaiye, loto idafa feito oloto pito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Fo lito minonido ya nilifi molaibo we ononala lito minokelo. Midipu inaibo ya ononala linubo hamenawa hulanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nemo mikaleka minobo hamenalo ya nemo wenina mikau-mikau ya lamenatina minowe, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Feto loto ya mikalo etefu oto hululu ito we nomuna likaibo ya nomunalo wili edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wili edoto ya feto loto ilifi molaibo, Hemo ya Silowamu momenoku ya uto noku iyo, loto lomuiye. No Silowamu ya Yuda hatinadokati Ilifi Molaibo ne, loti ya huliya monawa ya nebo ne. Ena wewa ya uto noku ito nomuna waiye. Nomuna wato weninala minado ya liwila oto aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Liwila oto aibo wewa homu wako lo beti-beti aibo we ya holiti weninawa yasi muki onesa wa edoti loga-loga oti labo, Mikalo amedoto minoto wako lo ledo-ledo aibo wema ya nefe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","malekamasi labo, Moda ya nebo yae, lato, ido malekamasi, E'e, yamaidana eito ma ne, lato, ya eimola auba ito libo, Nemo yama ya minobo yae, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Feto lito, loga o edoti feto labo, Hemo igaidana oto nomuga falatane? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","emokafo liwila oto lobibo, Wema huliya Yesu yakafo mikalo etefu oto hululu ito nomunelo wili nedoto ya feto loto lonumibo, Hemo Silowamu momenoku ya uto noku iyo, lito uto noku iyoto nomune falatiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Feto lito, loga o edoti labo, We ya igaleka ne? lato, Ya nemo holiyámowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ena Yesukafo haba hululu ito nomunalo wili edaito, nomuna falatibo ya Sabati foliku ya idafa feto feyaiye. Yagunu ya nomuna falatibo we ya Falisi we minado ya ilimiti uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Falisi we yasi ayaidana oti loga o edoti labo, Hemo igaidana oto nomuga falatane? lato, ya emo feto loto lobibo, Emo ya nomunelo haba ya wili nedaito, nemo ya uto noku ito nomune wa obo ne, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Feto lito, Falisi we yauti masi feto labo, We ya Sabati foli li hopaitaibo ya Gotidokati minámiye, lato ya masi labo, Emo ya nosámibo neko, idafa yaidanama feito lifefe ladámadi ne. Feto loti ha loyoilumu oti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yagunu ya nomuna falatibo we ya hofa loga o edoti labo, Nomuga li falato hedaibo yagunu heimoka ya emo yagunu nenae loto holi minane? lato, emokafo libo, Polofeti ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ena Yuda wenina yasi feto loti labo, We me ya ya homu nomuna likaito neboma onesa nomuna falatiye, loti ya ona lafemo, ido sugi lae? loti hatina loiti-loiti kiti olafote melafote sutina fiyato aito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","loga o betiti labo, Hemotina hipatinama hedaibo hamenaloti nomuna likaiye, loti lo minaboma me ya nefe? Feito neboma igaidana oto nomuna falatiye? loti loga o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Loga o betiyato, olafote melafote yasi ha liwila oti feto loti laibo, Hipate ya melo nebo ya holi minoiye. Ido hedaibo hamenaloti nomuna likaibo yagi holi minoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ido igaidana oto nomuna waife? Ido hemakafo nomuna li falato edaife? Ya we ya holiyámoiye. Hipawa ya naba litaima ne. Eimola loga o edato monawa lobiyaneyo, loti laibo ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ya Yuda wenina yagunu holi bito feto laiye. Ya holi bibo monawa feito ne: Yuda wenina yasi homu ha feto loti loyolalo-melo labo, Masi Yesu yagunu Gotikafo ilifi molaibo we Kilisto ne, loti lanabo ya ha mono holiyagu yauti fulo feka o betinune, loti lama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yagunu ya olafote melafote ya holi bito, feto laibo, Emo ya naba litaima ne. Eimola loga o edalo, loti ya laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yagunu nomuna homu likaibo we ya hofa sula fiti feto loti lomuwabo, Hemo Goti huliya li faka loto ha ona lolomo. Wewa ya monala holi minone. Emo we nosámibo ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","feto loto lobibo, Emo ya we nosámibo nefe? Ido dowa nefe? Ya ma holiyámowe. Nomune likoto minoma nomune falatobo idafawa mako ya holifefe lo minowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Feto lobito, ilalu huti loga o edabo, Nena-idafa o hedaiye? Igaidana oto nomuga li falatiye? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","emokafo feto loto lobibo, Nemo lobiyoma ya hemotina holámae. Neidafaito hofa lobiyoto holinune, loti lo minae? Hemotina yagi ege molanune, loti lo minafe? Olilo! lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Feto lito, li leko-mako o edoti feto loti labo, Hemo ya ege molanibo we minane. Lemo ya Mosese ege moniyonibo we ya minone. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mosese ya Gotikafo ha lomuibo ya holi minoba, we me ya ya yaukati meukati oloto pito aife? Ya ma holiyámone, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Feto lato, we yakafo ha liwila oto feto loto lobibo, Nomune li falatibo we ya yaukati aife? Meukati aife? Oloto pito aibo ya wafefe ladámone, loti labo ya ha manadinau minámito lafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Lemo Goti yakafo nosámabo wenina ha lanabo ya holámibo ne, loto ya holi minone. Ido ma yasi Goti holi muti welalo hololoti moni minanabo wenina ya ha lanabo moda holi nebo ne, loto yagi holi minone. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yagunu we hemakafo we ma nomuna likaibo oloto pito nebo ya nomuna li falatiye? Ha yaidana ha mika oloto pigu yoimati holiyámoto minomo yowonibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wewa ya Gotidokati lomámibo neko, onona yaidana liyámadi ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Feto lobito, emotinasi feto loti lomuwabo, Okafo mekafo hopa moniti hedabo hemogi u ayaida anibo yakafo ha mono api lilibinowe, loto labe? Olo, loti ya itifu fulae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ilifiyato, ya Yesukafo holito li oloto pito loga o edoto libo, Hemo We Hula holi hikito mu minabe? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","wewa yakafo libo, Wenabao, hemo hemagunu lane? Nilibiyageto wafefe loto ya holi hikito munowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesukafo feto loto lomuibo, Hemo moda watanibo yae. Ha lohomobo me ya ya minobo yae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Feto lomuito, wewama yakafo feto libo, Wenabao, nemo holi hikito homowe, loto weuna-lula-hala ya muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ena Yesukafo feto loto libo, Nemo wenina lifima liwila oto binowe, loto mikalo lomobo ne. Yagunu ya wenina masi nomude likaiye, loti holiyabo wenina ya nomudina li falato betinowe. Ido nomude moda falatotaiye, loti holiyabo wenina ya nomudina aifa likoto minanaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Feto loto lito, Falisi we malekama selo minabo yasi holiti ya feto labo, Aiyo, lemo nomude likaibo minogeto labe? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesukafo feto loto lobibo, Hemotina nomudina likaibo minabo neko, lifimatina minámadi ne. Nefa, heimotina ya lemo nomude moda falatito minone, loti lo-lo aboma nenako, lifimatina mino betinogolaiye, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ena Yesukafo ha ma feto loto lobibo, Nemo ona lama lobiyowe. Makafo sipisipi hilatinau yonowe, lotoma, hanudo yowámoto maleka hila hofalalo yonaibo ya ugele we ido idafa hopa libo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ido hanudo fefe loto yonaibo we ya sipisipi hiyabatina we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Emo lo fedanaibo ya hanu hiyaba we yakafo wa edoto hanu si edanogolaiye. Hanu si edageto sipisipi yasi nola fefeluma holiyato eimola sipisipila ya hulitina loto su fito hilauti idipito lumunogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Idipito lumuto li homu molo betito uwageto nola fefeluma ya holiyanako, ege unigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Feti ege unigilafa, ido we hofawa makafo su finaibo ya ege aguwámanigilae. Emo nola fefeluma eito nenako, emodokati holi unigilae, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ha wase ito feto loto lobibo ya nena idafagunu liye? loti hatina ligi-ligi kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hatina ligi-ligi kiyabo yagunu Yesukafo ha onu ito feto loto lobibo, Ha ona hula lobiyowe. Sipisipi yonabo hanutina nemo ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nemo oloto piyámobo hamenalo homu oloto piyabo we ya ugele we, idafa-adafa li hopaitabo we minafa, sipisipi yasi hatina holiyámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hanu ya nemo ya minowe. Nemodo yonabo wenina ya li nomudina wa oto ya uti loti wetina-idafa li oloto piti ya noti minanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ugele nabo we yasi hofo betiti li hopa o betiti ugele liti holi unune, lotiko lo fedo minae. Ido nemo ya weudina-lutina-hatina hofawa li biyoto dowa lotoko minanae, loto oloto piyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nemo ya sipisipi hiyabatina we dowa minowe. Hiyaba we dowakafo sipisipi hiyaba o beti minoto hofo nedo fulinae, loto ya aifa hiyaba o beti minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sipisipi yawala minámibo we ya hefana meinawa yagunuko holito hiyaba o betinako, yagunu hofukuti liye-hula lo fedanaibo ya wewa wa edoto sipisipi ya fulo betitoto holi unogolaiye. Holi uwageto, liye-hulakafo ya loto sipisipi ya hofo betito li upatanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Feto feyanaibo we ya meinala yagunuko ononala linako, sipisipi yagunu hala ki biyámoto holi unogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nemo ya sipisipi hiyabatina we dowa minowe. Menefokafo nemo wa nedaito ido emo wa edoto holi filiga-filiga o-o minoiye. Ido ayaidana oto nemogi ido sipisipinegi holi filiga-filiga o-o minone. Yagunu ya nemo sipisipi hiyaba o beti minoto hofo nedo fulinae, loto ya aifa hiyaba o beti minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ena nemo sipisipine ma abi loti minabo ya hila meuko ma minámae. Magi maina idipito loto none fefeluma ya holinigilae. Feito sipisipi ya mau mako i betiyoto ya hila mako ido hiyaba we mako feito oloto pito minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nemo oto moloto obo ya fulitoto fulinogolowe. Yagunu Menefokafo lula-hala numu ne. Nemo oto moloto obo ya fulitoto fulito hofa sinoito minanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","We masi aifa hofo nedo fuliyámanigilae. E'e, neimo hane dowa loto kiyodo ya fulitoto fulinogolowe. Nemo fulito ido sinoito anobo aubane moda mino nedaiye. Feto loto Menefokafo lonumibo ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Feto lito, Yuda we yasi holiti hofa loyoilumu oti ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","minaguti wenina abisi feto loti labo, Emo ya Satani himiwelakafo lula-halau yoito weuna u hopa wibo we ya ha libo ya neidafaiti holi minae? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ido masi feto labo, Satani himiwela mino edanaibo yakafo ha yaidana ladámanogolaiye. Ido Satani himiwela makafo we ma nomuna likaibo ya li falatanaibo nefe? lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ena Yuda wenina yasi fele huliyagi numuna naba lusa hiyabo foli hamenawalo ya asi aibo hamenawa fedito ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ya fele huliyagi numuna naba li hona-mana oti holo-hala numuna yaidana oti huwabo anawaleka ya huliya Solomoni Hilalau ya Yesu uto loto monito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Moni neto, Yuda wenina yasi li hona o edoti feto loti lomuwabo, Hemo neidafaito hamena fana ya monaka li faluku ageto hate ligi-lige ki minone? Hemo Gotikafo ilifi molaibo we Kilisto minotoma, lo oloto moloto lolomo, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesukafo ha liwila oto feto loto lobibo, Nemo moda lobitoboma nefa, ya hemotina holi hiki ladámae. Nemo Menefo huliyalo onona li-li o minobo yakafo monane lo oloto bi nefa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","hemotina ya nemo sipisipine oti minámanako, holi hikito nomámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nemo sipisipine yaidana oti moni minabo wenina ya nemo none fefeluma holiyato ya wa betifefe lo minoto nege moni minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nege moni minato, nomudina hofawa minowa-minowa anabo mona li biyoto u hopa aguwámoti moda minomo yoti minanigilae. Ya wenina ya nemo aneuti makafo apasoto linaibo ya ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Menefokafo nemodo minanae, loto limo numibo we yakafo wenina ido idafa-adafa muki ya li yoima o beti hulo nenako, ma yasi Menefo anauti apasoti linune, loti anabo ya ogofuwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nemo ido Menefo ya mako minoiye, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Feto lito, Yuda wenina yasi hofa hefana nuba oti hofo fulinune, loti ato ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesukafo feto loto lobibo, Onona dowa idafa mona-mona Menefo aubalalo liyoto ya wa minabo ononane dowa liyogu yauti ma nena idafa yagunu hefanagunu hofo nedanune, loti lo-lo o minae? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Loga o betito, Yuda wenina yasi ha liwila oti feto loti lomuwabo, Onona dowa loto li-li anibo yagunu minámiye. Hemo aifa wenina makafo nemo Goti minowe, lo-lo o minanibo ya Goti hamana hiyane. Yagunu ya hefanagunu hofo hedanune, loto lo minone, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Feto lato, Yesukafo ha liwila oto feto loto lobibo, Gotikafo lo molaibo hala hemotina bigu yau feto libo, Hemotina Goti yaidana oti minae, loto ya neimo loma ne, loto ha mono lufuwau (Sng 82:6) nebo ha ya holiyámafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yagunu ha mono lufuwau ha nebo ya u hopa ámanogolainako, Gotikafo hemotina Goti yaidana oti minae, loto hala holiyabo we ya lobinako, ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nemo ya Menefokafo lito fele fulo nedaito, lumuto mikalo minobo ya Goti Hipala minowe, loto lobiyobo yagunu hemotina Goti hamana hiyane, loti ya neidafaiti lae? ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Idafa fe-feyobo ya hemotina wabo ya Menefokafo fe-fe aibomaidana ámotoma ya nemo holi hikito nomámilo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ido idafawa fe-feyoto ya wa nedama nefa, holi hikito nomámotima ya idafa hofawa aubala itibiyobo yalekama holiti ya wa nedofefe lalo. Wa nedofefe lanabo ya Menefokafo luneu mino nedaito, ido nemo ayaidana oto emo lulau mino edobo mona ya holifefe lalo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Feto lito, nala numugu fulo edanune, loti afa, emo fulo betitoto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uto hofa Yodani no wela filigaleka yola Yonikafo homu apito wenina noku i betido yalo uto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yalo neto, wenina mukisi nedo ya u fedoti ha feto loti labo, Yoni ya Goti aubala lilibibo idafa mona li oloto piyámifa, wewa meyagunu hala liboma muki ya ha ona hula ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","mika yalo ya wenina mukisi Yesu holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ena Betani numudo ya we ma huliya Lasalusi ya idafa hilito unaido ya Maliate atolafo Matate numunatina meya yalo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Homu Malia yakafo ladanuwa aibo nowala ya Wenaba wili edoto manana opalagunu hinalo hilili edaibo wena emonala Lasalusi ya idafa hiliboma nenako, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","yagunu unalafo atolafo loiti yasi Wenabao, luka-haka muwanibo wema moda idafa hili ne, loti ha ya Yesudoka fulaito ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Feto loti fulaito, Yesukafo hawa holito ya feto loto libo, Idafawa hilibo ya fulinaibo idafa hiliyámiye. E'e, idafawa fedo muibo ya Goti aubala itibiyageto wati Goti huliya li yoisa anae, loto fedo muiye. Ido yako minámiye. Idafawa hilibo yakafo Goti Hipala nemo ya aubala ya itibiyoto huline li faka lanae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ena Yesu ya Matale, unalafole, Lasalusile ya lula-hala bito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ido idafa hilibo hawa ya holito, nedo ayalo ya fo hamena loiti aifa minoto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","aliga ya feto libo, Yudia mikalo liwila oto uwokelo, loto ege-ege moniyabo we lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","feto loti loga o edabo, Api lilibiyanibo we, Yuda wenina yasi homu yaloma hefanagunu hofo hedanune, loti labo yama nenako, hemo neidafaito hofa liwila anune, loto lane? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Feti loga o edato, Yesukafo ha liwila oto lobibo, Masi ledafe, folilofe ido lunagafe ya moninabo wenina ya mikaleka me ya lamenalo moninako, moda uteba-ateba hofo betiyámanogolaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ido ma ya lubuka moninabo ya lamena mináminako, uteba-ateba hofo betinogolaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ena ha ma onu ito feto lobibo, Yotewe Lasalusi uwo unaibo ya uto ilimikunogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Feto lobibo yagunu ege-ege moniyabo we yasi feto loti lomuwabo, Wenabao, uwo unanaibo ya idafa hilibo moda faka lanaibo ne, loti labo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ya Yesu ya Lasalusi fulibo yagunu lobifa, ido uwo ona unaibogunu liye, loti holifefe ladámanako, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","yagunu Yesukafo ha lo oloto itoto lobibo, Lasalusi ya moda fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ido hemotina holi hiki lanae, loto nemo uto yalo minámoto fulito, ya hemotinagunu holito lune-hane dowa liye. Moda emodoka uwokelo, loto lobito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ido Tomasi huliya ma Didimusi yakafo Yesu ege-ege moniyabo we malekama ya feto loto lobibo, Emogi fulinuniyo, maina uwokelo, loto ya lobiye. Wewa huliya ya Giliki wenina hatinalokati ya Didimusi ne, loto nebo huliya monawa ya lobe hipa ne, loto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ena Lasalusi hono ula haleku molo edabo ya fo hamena fo (4) ya wito Yesu u fedoto ya hawa holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ena Betani numuna ya Yelusalemu minomo lumido selo kilomita tili (3) ya hofala ma yalo ya nenako, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuda wenina mukisi Matate Maliate emonatina fulibo yagunu afele uto wa betinune, loti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Uwato, ena Yesu lo fediye, loti labo ha ya Mata holito, Malia ya numugu aifa nefa, ido emo ya uto hanudo hatula anowe, loto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Uto hatula oto ya feto loto lomuibo, Wenabao, hemo melo minanibo neko, nemonane fuliyámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ido onesa me ya hemo ya idafa yaidana idafa yagunu Goti lomuwageto moda humunaiboma ne, loto ya holi minowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Lomuito, Yesukafo feto loto lomuibo, Hemonaka ya moda hofa sinoinogolaiye, lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matakafo feto loto lomuibo, Aliga hamena nabalo ya wenina fuliyaguti sinoinabo hamenalo ya hofa sinoinaibo ya holi minowe, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesukafo lomuibo, Liwila oti sinoiyabo ido nomudina hofawa minabo yawala ya neimo ya minonako, ma nemo holi hikito numunabo yasi fulinafa, ayawa ya moda hofawa minomo yonigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ido ma yasi nomudina hofawa minoti holi hikito numunabo ya fuliyámotiko minomo uti minanigilae. Hemo hawa ya holi hikitabe? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ya Matakafo lomuibo, O, Wenabao, Gotikafo Hipala Kilisto ilifi molaibo we ya mikaloka lumunogolaiye, loti laboma ya hemo minanibo ya holi hikito homowe, loto ya lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Feto loto unalafo Malia nedo uto nimu-nimu loto feto libo, Api lilibibo wema loto hemo haka-haka liye, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ya Maliakafo holito ayalo sinoito Yesu nedo unowe, loto holito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Wito, ya Yuda wenina hubanumu-hubanumu oti numunalau minabo wenina yasi ya wa edoto ya hono halelo ya hufo anowe, loto wiye, loti ege uti wa edabo ya Yesu ya numuna onuwalo Mata ha lomuido ayalo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yagunu Malia ya numuna onuwalo ya lumuto Yesu wa edoto hina abusa ito feto loto lomuibo, Wenabao, hemo melo minanibo neko, nemonane ya fuliyámadi ne, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","hufo aito ya Yuda wenina ege uwabo yagi maina hufo abo ya Yesukafo wa betito lula-halau sukeke aito hena naba fulito ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ya igau molo edae? lito ya Wenabao, loto wao, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ena Yesu ya nomunau hufo yoi faitoto nomunauti nomuna nowala lumito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuda wenina wati feto loti labo, Walo. Lula-hala naba-naba muiye, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ido malekamasi labo, We me ya ya nomuna likaibo we li falato edaibo yamaidana oto melo nebo neko, ya aifa li faka lo edadi ne, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Feto lato, ya Yesukafo hofa lula-halau sukeke aito hono halelo ya u fedoto ya hono aubala hefana lulau hanu ya hefana nabagunu lotana iyabo ya wato ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ya hefana li fulalo, lito ya fulibo we emonala Matakafo feto loto lomuibo, Wenabao, hamena fo (4) ya unaibo yakafo unama otaiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesukafo feto loto lomuibo, Hemo holi hikito numunanibo Goti aubala oloto piyageto wa edananibo ne, loto lohomobo ya holámabe? loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","hefana li fulato, ya Yesukafo wa yowa itoto feto loto libo, Wauwe, hemo lohomobo holiyanibo yagunu ya heboka lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hemo hamena-hamena lohomobo holi-holi o minanibo ya holi minofa, wenina meu minomo uwabo ya hemo nilifi molageto lomobo yama holi hikitanae, loto ya lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Feto loto lo faka loto lomuibo, Lasalusiyo, hemo lomo, loto su fito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ya fulibo wema lumiye. Lumito, hinalo-analo ya owo lafo-lafogunu nala loloku edabo ido hola-wela lafo-lafogunu wase iyabo yama Yesukafo wina fulo edalo, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ena Yuda wenina Malia nedoka lo fedabo wenina yauti abi yasi Yesu idafa aibo ya wati holi hikito muwafa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","malekamasi ya Falisi we minado ya uti Yesukafo idafa aibo ha yama eteme biyato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","emotinasi hawa ya holiti Goti sokila hi muwabo we hiyabatina we yasi mono kanisole li nuba o betiti feto loti loyolalo-melo abo, Me ya we yakafo idafa hofawa abi oto aubala itibibo we ya nena-idafa fe edanune? ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Leimo waito edanubo ya wenina muki yasi holi hikito munigilanako, Lomu himiwe yasi li uwotefo buliti loti fele ebate ido weninate yagi muki li hopa itoti ledanigilae, loti ya lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Feto loti ya ena emotina minagu yauti we ma huliya Kaiyafasi ya melege mako ayau ya Goti sokila hi muwabo we hiyabatina we wenaba yakafo feto loto libo, Hemotina ha manadinau minámibo minafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lemo Yuda wenina muki ya u hopa otanune, loto we mako ma lemogunu loto fulinaibo ya dowa loto minanogolone, loti ya holiyámafe? loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Feto loto libo ha ya eimola hala kido ladámiye. Melege eletifo me ya ya ayau ya Goti sokila hi muwabo we hiyabatina we wenaba nema nenako, Yesu ya ona Yuda weninagunu loto fulinaiye, loto libo ha ya ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hawa libo ha ya Yuda wenina yagunuko ladámiye. Goti olufola mikau-mikau mino liti uwabo wenina muki ya li nuba o ledaito mau mako ito minanune, loto yagunu hawa ya lobibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ena hamena yaloti molo fiti ya igaidana oto Yesu ya hofanune? loti hudala hiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yagunu ya Yesukafo Yuda wenina minado ya hofa oloto pito moniyámoto, mika ma hafali mika selo nebo filigaleka ya numuna ma nebo huliya Efelaimi yalo ya ege-ege moniyabo we idipito wito yalo ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ena Yuda wenina Gotikafo Uta O Betibo foli hamenatina alili aito numuna hefolau-hefolau yati wenina abi loti ute-weude-lute-hate noku ito Goti nomunalo hiluwa loto minanune, loti Yelusalemu ya yowae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yoti fele huliyagi numuna nabau ya Yesu moni wita oti feto loti ya loyolalo-melo abo, Hemotina neidafaiye loti holiyae? Emo ya loto foli ya wagámanaife? lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Goti sokila hi muwabo we hiyabatina we ido Falisi wenina yasi ha auba iti feto loti labo, Hemotina ma yasi minanaibo eba holitima ya loti lolomato nala i edanune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ena Gotikafo Uta O Betibo foliwa alili aito hamena sikisi (6) yako wito neto, Yesu ya Betani numudo ya u fedito numuna yalo ya Lasalusi Yesukafo fuliguti li sinoi edaibo we ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nebo eba yalo ya Yesu wetina-idafa hofo hi edato, Matakafo lifefe loto molo betito, Lasalusigi maina noti minato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliakafo yá nowala ladanuwa aibo huliya naliti meinala naba nebo ya lito Yesu hinalo lekito wili edoto atala opalagunu hilili edaito, numugu ya unala ladanuwa faito fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Feito nefa, Yesu ege-ege moniyabo we yauti ma Yudasi Isikaliyoti uwolafo adinalo molaibo we yakafo feto loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ladanuwa aibo no ya fuloto hefana meina linubo ya we makafo melege mako onona lito meinala libo yaidana lito wenina idafa wa námabo wenina ya biyonibo neko, dowa ladi ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Feto loto libo ha ya idafa wa námabo wenina yagunu holito ladámiye. Eimola ya ugele we minoto Yesu ege-ege moniyabo we hefana-huwamenatina hiyaba oto hefana molagu yauti ugele li-li aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yagunu Yesukafo feto loto ya libo, Hemotina wena ya ha lomuwámilo. Ladanuwa aibo no ya hinelo wili nedaibo ya fuliyoto molo nedanabo yagunu holito molo nebo nefa, onesa wili nedaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wenina idafa wa námabo wenina ya moda hemotinagi keloti minomo unafa, nemo ya hemotinagi hamena fana keloto minámanogolowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ena Yuda wenina abi loti numuna yalo ne, loti labo ya holiti ayalo ya u fedabo ya Yesu yagunuko aguwámae. Lasalusi fuliguti li sinoi edaito nebo we yagi wa edanune, loti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ido Lasalusi yagunu Yuda wenina abi yasi hiyabatina we hidinalo yati Yesudoka u keloti holi hikito muwabo yagunu Goti sokila hi muwabo we hiyabatina we me ya ya Lasalusi yagi maina hofo betinune, loti ha onona liyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ena leda ho lito wenina mau naba yasi foliku ya Yelusalemu ya lo fedabo wenina yasi Yesu hanudo lo ne, loti hala ukuwa holiti ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ya yá aila lekoti li adina-adina oti hanudo hatula anune, loti uti ya aiyo-weiyo ha lo edoti feto loti labo, Aiyo, dowae, hosana! Wenaba huliyalo aibo we ya dowa loto holimo wibo ne. Isilaeli wenina hiyabate we wehudi ya dowa loto holimo wibo ne, loti aiyo-weiyo ha lo edomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ena Yesukafo safu-dogi agele li oloto pito meyalo ya minoto wibo yagunu ha mono lufuwau ya feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Hemotina Saiyoni weninao, holi biyámaneyo. Walo. Hiyabatina we wehudi ya safu-dogi agele meyalo amedoto minoto ya aiye, loto ha mono lufuwau (Sek 9:9) nebo ha yama onesa ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ya ha ya ege-ege moniyabo we ya homu ya holifefe ladámoti minafa, ido Yesu okulumau lamenalauka liwila oto yoito, aya hawa ya holiti me ya ya emogunu lufuwa iyanako, idafa feto fe edae, loti holiti ya holifefe labo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ena homu Yesukafo Lasalusi sula fito li sinoi edaito hono halekuti lumito, wa edabo wenina mau naba yasi malekaloka eteme lo biyato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","aubala itibibo idafawa ya hawa holiyabo yagunugi wenina abi loti hanudo hatula ato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Falisi we yasi eimotinako feto loti loyolalo-melo abo, Hemotina ha laboma eleka hofo betibo ya holi minafe? Muki wenina emodoka u kelotabo me ya yae, loti loyolalo-melo ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ena Yuda wenina foliku ya Goti weude-lute-hate munune, loti Yelusalemu lo fedabo wenina minagu ya Giliki wenina ma minoti ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Galili mikalo Betesaida numudoti we Filipi nedo ya loti feto loti lomuwabo, We hofawe, lemo Yesu ya wa edanune, loto holiyone, lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lomuwato, Filipi uto Adulu ya lomuito maina Yesu nedo ya uti ha ya lomuwaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesukafo feto loto ya lobibo, We Hula nemo huline oloto pi dowa loto anaibo hamenawa me ya ya fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ha ona lama lobiyowe. Suwa witi yufa ya mikau lumuto fokiyámotoma ya yowámanaibo ne. Nefa, lumuto houmala fudoto fokinaibo ya yoto ilawa abi oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wenina makafo eimolagunuko holinaibo we ya u hopa unogolaifa, makafo me ya mikalo eimolagunu holiyámanaibo ya nomuna hofawa minowa-minowa anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ido makafo nemo houba-nabane we minanowe, lanaibo ya nege-nege moni minaneyo. Ido nemo minodo ya houba-nabane we yagi minanogolone. Ido ma ya nemo houba-naba o nedanabo wenina ya Menefokafo hulitina li faka lanogolaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ido ha ma onu ito feto loto lobibo, Me ya ya lune-haneu sukeke aito holiyobo hena aiye. Ena neidafaiye lanobo ne? Wauwe, hamenane alili aibo ya hemo li fulito nedo, lanofe? E'e, hamenawa yagunu Menefo nilifi molaito, lomoboma nenako, yaidana ladámanobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wauwe, hemo aubaka li oloto piyageto hulika oloto pi dowa lanaiye, lito ya okulumauti ha feto loto libo, Huline moda oloto pi dowa lito ido hofa ma oloto pi dowa lanogolaiye, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Feto lito, wenina mau minabo yasi holiti ya masi hopana ho halake liye, lato, ido ma yasi enisole makafo ha lomuiye, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesukafo wetinalo yati lito feto loto lobibo, Ha ya neimonegunu minámiye. E'e, hemotinagunu oto oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Onesa me ya ya mikaleka wenina lifima ha binaibo hamena alili ainako, mika melo wenina wenabatina Satani ya itifu fulitanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ido mikalokati li faka lo nedato, mikau-mikau wenina muki ika oto nemodoka anigilae, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ya feto libo ha ya fulinaibo monawa yagunu ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lobito, wenina mau minabo yasi ha liwila oti feto loti lomuwabo, Lemo lo molaibo ha yau feto loto neto holiyonibo, Gotikafo ilifi molaibo we Kilisto ya fuliyámoto ya minomo uto minanogolaiye, loto libo ha ya holitonibo ne. Feito nefa, ido heimoka ya We Hula me ya ya li yoisa edanigilae, loto ya neidafaito lane? We Hula ya hema ne? lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Lomuwato, Yesukafo ha feto loto lobibo, So lamena ya hemotina minagu ya hamena fouma efoma lamena anogolaiye. Yagunu ya midipukafo wase i ledotanaiye, loti ya so lamena mino betibo hamenalo ya oti moloti moniti minalo. Ma yasi midipu inaigu uti hanu wafefe ladámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yagunu ya so lamena mino betibo hamenalo ya lamena weninala hula minanune, loti lamenawa ya holi hikito muilo, loto ya Yesukafo ha feto loto uto faluku oto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ena Yesukafo ya idafa mona-mona feto aubala nomudina hulalo ya itibifa, holi hikito umámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Holi hikito umámabo ha ya polofeti Aisaiyakafo feto libo, Wenabao, ha eteme lo biyonibo ya hemakafo holi hikito ne? Ido Wenaba aubala oloto pi bibo ya hemakafo wa edofefe lanaiye? loto ha mono lufuwau (Ais 53:1) nebo ha yama u Yesudo ya hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Ido Aisaiya ha ma feto libo, Nomudinakafo wa-wa o minoti, lutinakafo holifefe loti holiti, lutina-hatina ya li elepa iti nemodo ato li faka lo betitanowe, loto ya nomudina hofo likoto lutina li gedo betiye, loto ha mono lufuwau (Ais 6:10) nebo ha ya holi hiki ladámabo monawa yagunu ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Feto loto Aisaiyakafo hawa lufuwa ibo ya Yesu aubala lamenala naba wa edainako, yagunu emogunu loto ya lufuwa ibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ena Yuda wenina hiyabatina we malekamasi Yesu holi hikito muwafa, lo oloto pinunako, Falisi we yasi ya mono numuguti li fulitoto ledotanae, loti holi bito, Yesu holi hikito muwabo ya lo oloto piyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aya weninawa ya mikaleka wenina yasi hulitina li faka lanabo yagunuko holiyabo, ido Gotikafo hulitina li faka lanaibo yagunu holámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ena Yesu ya ha lo faka loto feto libo, Nemo holi hiki nomabo wenina ya nemoko o nomámae. Nilifi molaibo we yagi maina holi hikito lomae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ido nemo wa nedofefe labo wenina ya nilifi molaibo we yagi maina wa ledofefe lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ido holi hikito numunabo wenina ya midipu igu minámanae, loto nemo mikaleka minabo wenina li lamena o betinowe, loto lomobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ido hane holi fulitanabo ya lifima ha biyámanogolowe. E'e, nemo ya wenina lifimatina li binowe, loto ámowe. Li nomudina wanowe, loto lomobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ido nemo fulo nedoiti hane yagi holi fulitanabo wenina ya lifima ha liwila oto binaibo we ya ne. Ha lobo ha yamo hamena nabalo ya li halo molo betito, lifima ha liwila oto binaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nemo ha lobo ya neimo luneuti holito ma ladámowe. E'e, Menefo nilifi molaibo we eimolakafo ha feto loto lo oloto molanane, loto lo moloto hane libo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ido emo welaloti ha yakafo nomudina hofawa minanabo hanuwa nebo ya holi minowe. Yagunu ha lo minobo ya Menefokafo hane lito lonumido ayalo ya lo-lo o minowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ena Gotikafo Uta O Betibo foliwa alili aito Yesukafo eimolagunu feto loto holibo, Nemo mika fulitoto Menefodoka liwila oto yonobo hamenane ya alili aiye, loto holito ya mikaleka weninala lula-hala bibo ya lune-hane bi huloto fulinowe, loto ya holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ena Satanikafo Saimoni Isikaliyoti hipala Yudasi ya Yesu uwolafo adinalo molanaiye, loto sebala fali witunu ito, ya lubuka hobina nanune, loti nuba o minato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ya feto loto holibo, Menefo yakafo idafa-adafa muki ya nemo anelo molo hulibo ne. Ido nemo ya Gotidokati lomoma nenako, hofa ya Gotidoka liwila oto yonobo ne, loto holito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","wetina-idafa noti minaguti sinoito, ulalo owo fana ya li fuloto tauli ya hofalalo lolokuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lolokuto no ya lapeku ya lekito apito ege-ege moniyabo we hidina noku i betito tauli hofalalo lolokuibo yama lito hilili o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Feto fe betimo loto Saimoni Pita nedo ya aito, feto loto lomuibo, Hemo Wenabamakafo hine noku inowe, loto abe? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesukafo ha liwila oto feto loto lomuibo, Idafa fe minobo ya monawa onesa meleka ya holiyámane. Minoto aliga yoimaloka holinogolane, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitakafo feto loto lomuibo, E'e, nemo hine ya noku iyámanane. Fulito, lomuiye. Lomuito, Yesukafo feto loto lomuibo, Nemo noku i hedámanobo ya nemote lute mako minámanogolaiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimoni Pitakafo feto loto lomuibo, Aiyo, Wenabao, feto lotoma ya hine yako noku i nedámoto, ane, manane yagi muki noku i nedo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Lomuito, Yesukafo feto lomuibo, Ma ya noku unoti aliga hidinako noku iyatoma, utina hiluwa loto minanigilae. Yagunu hemotina ya yaidana oto li hiluwa lo betiyofa, hemotina muki yagunu ladámowe, loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ya uwolafo adinalo molaibo we ya wafefe linako, hemotina muki ya hiluwa loti minae, loto ladámowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ena hidina noku i huloto ulalo owo fana ya hofa li holoito wetina-idafa noti minagu hofa amedoto feto loto lobibo, Nemo idafa me ya o betiyobo ya monawa hemotina holi minafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hemotina ya api lilibiyanibo we ido Wenabate, loti ya lonumu-numu o minabo we yama moda ya minonako, lama lonumu minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Feito nemo Wenabatina ido api itibiyobo wemakafo hidina noku uno betiyobo ya hemotina ayaidana oti weninatina hidina noku unaibo wilalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nemo feto feyanae, loto idafa o betiyobo mona ya hemotina yagi ayaidanako omo unae, loto itibiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nemo ona lama lobiyowe. Houba-naba we yakafo wenabala li yoima o edámanaibo ne. Ido ilifi molaito wibo we yakafo ilifi molaibo we ya li yoima o edoto minanaibo we yagi ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yagunu hemotina ha lobiyobo holifefe loti ayalo efo ya meyalo moloti minanabo ya moda dowa loti holimo unae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Dowa loti holimo unafa, hemotina muki yagunu ladámowe. E'e, nemo wa molo betiyobo wenina ya holi minowe. Ha lufuwa ma ya feto libo, Wela-idafa beleti muwobo we ya hofo nedanaibo uwonefo bulibo we ya ne, loto ha mono lufuwau (Sng 41:9) nebo ha yama u ayalo hulawa fedanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Idafa ya aliga oloto pinogolaito ya nemo minobo me ya ya monane lobi-lobi obo ya hemotina holi hikitanae, loto ya onesa oloto piyámito homu lobi minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nemo ha ona lama lobiyowe. Ma yasi onona ha lobiyobo ya holiti uti liyabo wenina ya we masi li houna i betinabo ya nemo onona yawala yagi li houna i nedanigilae. Ido nemo o nedanabo ya nilifi molaibo we yagi li houna i edanigilae, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ena Yesukafo hawa feto loto lula-halau sukeke aito hena fulito feto loto lo oloto moloto lobibo, Nemo ha ona lama lobiyowe. Hemotinadokati makafo nemo ya uwonefo-mota adinalo binogolaiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ege-ege moniyabo we ya wenu eimotina wa betiti, Hemagunu liye? loti hatina loiti-loiti kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ena ege-ege moniyabo we yauti ma ya Yesu lula-hala muibo we ya Yesugi maina keloti amedoti minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yalo amedoti minaito, ya Saimoni Pitakafo nomuna hifa faka loto lomuibo, Loga o edageto lohomaneyo. Ya hemagunu liye? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","emo ya atala ya Yesu ikiyalo ya fuloto loga o edaibo, Wenabao, hemo hemagunu lane? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesukafo ha liwila oto libo, Beleti bolito supuku ya fito li muwoto nanaibo we yagunu lowe, loto ya beleti bolito supuku ya fito Saimoni Isikaliyoti hipala Yudasi ya li muito naiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Naito, Satanikafo lula-halau yoito ya Yesukafo Yudasi feto loto lomuibo, Idafa feyanowe, loto lanima ya uto aloko feyo, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ya ha feto loto lomuibo ya malekama muki yau minabo ya monawa holifefe ladámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Holifefe ladámabo yauti malekamasi feto loti holiyabo, Yudasikafo ya hefana molo-molo onibo huwamena hiyaba aibo we nenako, wenina idafa wa námabo wenina ya hefana binaiye, loto ilifi molaifemo, ido foli idafa ma meina finaiye, loto ilifi molaiye? loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ena Yudasi ya beleti bolito muibo ya noto ayalo yati lumuto uto midipu igu ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ena Yudasi wito, Yesukafo feto loto libo, Onesa me ya ya We Hula nemo ya huline oloto wiye. Ido nemodoti ya Goti huliya oloto wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ido nemodoti Goti huliya oloto winako, Goti eimoladokati ya nemo huline li oloto pinogolaiye. Onesa feto-namato ya huline li oloto pinogolaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Olufone-motao, nemo ya hamena fouma efoma ya hemotinagi minanogolowe. Ena nemo moni witane anigilae. Yagunu Yuda wenina lobiyomaidana oto onesa hemotina yagi lobiyowe. Nemo unodo ya aguwámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ena lo molobo ha hofawa lobiyowe. Heimotina lutina-hatina ya bi-bi o minalo. Nemokafo ya lune-hane hemotina bi-bi obo yamaidana oti heimotina lutina-hatina bi-bi otiko minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Feti lutina-hatina bi-bi anabo ya wenina muki yasi ya nemo nege-nege moniti minabo wenina hula minae, loti ya wa betinigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ena Saimoni Pitakafo loga o edoto libo, Wenabane, hemo ya igaleka unane? lito ya Yesukafo ha liwila oto lomuibo, Nemo unodo ya onesa feto-namato ya nege aguwámanogolane. Minoto aliga nege anogolane, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitakafo feto loto lomuibo, Wenabane, neidafaito onesa hege aguwámanobo ne? Hofo nedo fulinune, lotima aifa hofo nedo fulinae. Nemo hege molanowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesukafo ha liwila oto lomuibo, Ona, hemo aifa hofo nedo fulinae. Hege molanowe, loto labe? Nemo ona lama lohomowe. Okolofo nola ladámageto hemo hamena tili (3) ya huline li faluku itanogolane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ena Yesukafo ha ma onu ito feto loto lobibo, Hemotina lutina-hatinau sukeke ageto hena fuliyámilo. Goti holi hikito muti nemogi maina holi hikito numilo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Menefo numuna meyalo ya numuna abi idafa minomo wiye. Ayalo ya eba lifefe lo betinowe, loto unogolowe. Ya feito minámibo neko, hawa ya lobiyámadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ido uto eba lifefe lo betitoto, ya nemo minanodo ya hemotinagi nemogi maina minanogolone, loto hofa liwila oto loto idipito unogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ido uto minanobo hanuwa ya wa minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Lobito, Tomasikafo feto loto lomuibo, Wenabate, hemo uto minananibo eba ya lemo holifefe ladámone. Yagunu igaidana oto hanu ya wanubo ne? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesukafo feto loto lomuibo, Hanu ido mona ona hula ido hofawa minanabo mona ya neimo ya minowe. Feito minobo ya nemo fulo nedoiti Menefo nedo unabo ya ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hemotina nemo wa nedofefe labo neko, Menefo yagi wa edofefe lo minadi ne. Onesa meloti ya Menefo holifefe loti ya wa edofefe lo minae, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Lito, Filipikafo feto loto lomuibo, Wenabate, hemo Metefo lilibiyageto wa edanubo yamo ya ogofunaiye, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesukafo lomuibo, Filipiyo, nemo hamena fana hemotinagi minobo yama wa nedofefe ladámanibo nefe? Nemo wa nedabo wenina yasi Menefo ya wa minae. Hemo ya Metefo lilibiyageto wanune, lanibo ya neidafaito lane? ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nemo ya Menefo lulau mino edobo, ido Menefo ya nemo luneu mino nedaibo ya holi hiki ladámabe? Ha lobi-lobi obo ya neimodokati lobiyámowe. E'e, Menefo luneu mino nedaibo yakafo ononala ya li-li o minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nemo ya Menefo lulau mino edoto, ido Menefo ya nemo luneu mino nedaiye. Ya hawa ya holiti holi hikito numilo. Ido holi hiki ladámotima ya idafa fe-fe obo monane yagunu holiti holi hikito numilo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nemo ona lama lobiyowe. Nemo holi hikito numunabo wenina yasi onona li minobo yaidana oti ya linigilae. Ido yako minámiye. Nemo Menefodoka yonogolobo yagunu ya nemo li fulo nedoti linigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hipala nemodokati Menefo huliya yonogolaiye, loto nemo hulinelo ya hemotina idafa-adafa magunu lonumunabo ya moda feyanogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hemotina nemo huline li minoti idafa-adafa magunu lonumunabo ya moda feyanogolowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ena ha ma onu ito feto loto ya libo, Hemotina lutina-hatina numu minanabo ya wenelo hololanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Feti minanabo ya nemo Menefo lomuwoto hemotina adina li faka lanaibo we ma ilifi molageto lumuto hemotinagi minowa-minowa oto minanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Emo ya ha ona hula yawala Weuna ya ne. Emo ya mika me ya weninala yasi wa edofefe ladámoti ya ido holifefe ladámanako, yagunu liyámanabo ne. Emo ya lumuto lutinau mino betinogolaibo we ya onesa hemotinagi mino-mino ainako, hutifina o edo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nemo fulo betiyoto, nabuna olufo hiliti minámanigilae. E'e, nemo hemotinaloka liwila oto anogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hamena hofala fouma ma nenako, ya hulageto hemotina ya wa nedanigilafa, ido mika me ya weninala ya wa nedámanigilae. Nemo ya nomune hofawa minomo yowonako, hemotina yagi nomudina hofawa minomo yonigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hamenawa yalo ya feto loti holinabo, Nemo ya Menefo lulau mino edowe. Ido hemotina ya nemo luneu mino nedae. Ido nemo ya hemotina lutinau mino betiyowe. Ya hamenawa yalo ya holifefe lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Weneloti hane li minoti meyalo molabo wenina ya lutina-hatina nomabo wenina minae. Ido lutina-hatina nomabo wenina ya Menefokafo lula-hala biyageto neimo yagi lune-hane bito monane li oloto pi binogolowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Feto lito, Yudasi Isikaliyoti abalafokafo loga o edoto libo, Wenaba, hemo ya neidafaito monaka ya lemo yako li oloto pi lumuto, ido mikalo wenina malekaloka li oloto pi biyámananibo ne? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesukafo ha liwila oto lomuibo, Lutina-hatina numunabo wenina ya hane holiti hololanigilae. Ido lutina-hatina numuti hanelo hololanabo wenina ya Menefokafo lula-hala binogolaiye. Lula-hala biyageto nemogi maina weninawaloka ya uto maina mino betimo yonogoloiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ido lutina-hatina nomámanabo wenina ya hane ya holiti hololadámanigilae. Ido hawa holi-holi o minabo ya neimo hane ma minámiye. E'e, ya Menefo nilifi molaibo we hala ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ena nemo neimo ya hemotinagi minoto ya hawa muki lobiyofa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","adina li faka lanaibo we Weuna Fele ya Menefokafo nemo hulinelo ilifi molageto lumuto idafa muki idafa ya api-napi o bito ya ido neimo lobi minobo ha ya hofa hatina-manadinau molo betinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ena nemo you amena mona biyobo ya mino betiyageto unowe. Mika me ya weninala you lo betiyabo yaidana oto li you lo betiyámowe. E'e, nemo neimo you amena monane ya biyowe. Yagunu ya lutina-hatinau sukeke ageto hena fuliyámilo. Ido holi biyámaneyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nemo uto minoto hemotinaloka hofa liwila oto anogolowe, loto lobitoto holitaboma ne. Menefo ya we naba-naba minoto li fulo nedaima nenako, hemotina lutina-hatina nomabo neko, ya Menefodoka yonogolobo yagunu lutina-hatinau dowa loti holiyadi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me ya ya hulawa oloto piyámito, aliga oloto piyageto wati holi hiki loti holinae, loto ya homu ya lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ena nemo me ya ya ha ma abi onu ito lobiyámanogolowe. E'e, mika melo wenina wenabatina Satani loto nemo ya li fulo nedámanogolaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nemo Menefo lune-hane mutoko minobo ya mika me ya weninala holifefe lanae, loto Menefo ha lonumibo ya li meyalo molanogolowe. Sinoito uwokelo, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ena ha ma onu ito feto loto lobibo, Ilawa ibo nala waini hofala mona ona ya nemo minoto, ido Menefo ya nala waini hilau hiyaba aibo we yawala ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Neto ya yá akawa ma ya nemodoka mino liti uti ilawa iyámabo ya atalito li fulitanogolaifa, akawa masi ilawa inabo ya dowa loti yoti ilawa abi idafa inae, loto hinau ya atali fulitanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hemotina ya ha mono lobiyobo hawa yakafo weudina-lutina-hatinau nosámibo idafa nebo ya onesa li fulitoto betitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yagunu hemotina ya nemodoka mino nedalo. Mino nedato ya nemogi ya mino betinogolowe. Nala waini akawa yakafo hofalalo minámanaibo ya eimolako minanaibo ya ilawa iyámanogolaiye. Ido hemotina ya ayaidana oti nemodoka mino nedámanabo ya ilawa iyámanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nala waini hofala mona ya nemo minoto, ido me ya akawa ya hemotina ya minae. Ma yasi nemodoka mino nedabo wenina ya nemo ya emodoka mino betiyoto, emotina yasi ilawa naba-naba iyae. Hemotina nemogi minámanabo ya idafa ma anabo ya ogofuwámanaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Makafo nemodoka mino nedámanabo ya yá akawa yaidana oto atalito li fulitato fulinogolaiye. Fuliyageto ya li nuba oti fulo soku iti hinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hemotina nemodoka mino nedato ido hane ya hemotinaloka mino betinaibo ya idafa yaida-meidanagunu Menefo lomunabo ya oloto pi binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hemotina ilawa naba-naba inabo ya wa betiti nemo nege molabo wenina minae, loti wa betifefe loti Menefo huliya ya li faka lanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Menefokafo lula-hala numu-numu o nebo yaidana oto nemokafo lune-hane hemotina bi-bi o minowe. Yagunu hemotina nemo lune-hane biyodo ayaloko ya minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nemo ya Menefo ha libo ya holito hololoto ya lula-hala numido ayalo yako moni-moni o minowe. Hemotina ayaidana oti nemo wenelo ya hololotima ya lune-hane biyodo yaloko ya minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nemo lune-haneu dowa loto holiyobo yakafo hemotina lutina-hatinau uto faitoto minanaiye, loto ha me ya ya lobi hulowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nemo lo molobo hane ya feto loto lobiyowe. Nemokafo lune-hane biyobo yamaidana oti heimotina ya lutina-hatina bi-bi o minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","We ma yolawe-motagunu loto fulinaibo mona ya wenina lutina-hatina biti li dowa lo betiyabo mona muki ya hofo fuloto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ha muki lobiyobo ya meyalo moloti minotima ya nemo yonewe-mota minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nemo hamena meloti ya houba-nabane we ne, loto hofa lobiyámanogolowe. E'e, nemo yonewe-motae minae, loto lobiyowe. Houba-naba we yakafo wenabala idafa-adafa oto moloto aibo monala ma wafefe ladámifa, neimo ya Menefodokati ha holiyodo ya lo oloto pito lobi hulobo yagunu nemo houba-nabane we ne, loto ladámoto yonewe-mota minae, loto lobiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hemotina nemo weudina fi nedámaboma ne. E'e, nemokafo hemotina ya uti ilawa li oloto pinae, loto weune fi betito sutina fiyoboma ne. Ido ilawa li oloto pinabo ya minowa-minowa oto minomo yonogolaiye. Feti minoti ya nemo hulinelo ya Menefo idafa yaidana-meidanagunu lomunabo ya binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nemo mona feti molanabo ha ya lobiyowe. Hemotina ya lutina-hatina bi-bi o minalo, loto ha auba ito lo molo betiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ena mika me ya weninala yasi lutina-hatina holi nosámibo binabo ya hemotina feto loti ya holilo. Wenabate ya homu apiti ya holi nosámibo umama ne, loti nemodo ya holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hemotina ya mika me ya weninala yagi kelabo neko, ya weninate ne, loti lutina-hatina biyadi ne. Nefa, nemo ya mika me ya weninala minagu yati hemotina sutina fiyobo yagunu emotina monatina hemotina fulo egetinaloka itanako, ya holi nosámibo bi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Houba-naba we yakafo wenabala li yoima o edámanaibo ne, loto homu lobiyobo ha ya hatina kifefe lalo. Li nosámibo o nomabo yamaidana oti hemotina o binabo ne. Ido nemo hane holi lutinau molabo yamaidana oti hemotina hatina holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nilifi molaibo we ya wa edofefe ladámama nenako, nemo weninane ya minae, loti holiti li ya me ya o betinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ena nemo emotina minado ya lumuto lobiyámobo neko, lifimatinagi minámadi ne. Nefa, me ya lifimatina ya igaidana oti li faluku anabo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma yasi nemo lutina-hatina holi nosámibo nomabo wenina Menefogi ya ayaidana oti holi nosámibo muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Emotina minagu ya mona hofawa molobo, ya wenina homu molámabo mona ya nemo li oloto pito molámobo neko, lifimatinagi minámadi ne. Nefa, me ya ya li oloto pito moloto wa edabo yasi ya wa edo fulitoti, nemo holi nosámibo numuti ya Menefo ayaidana oti holi nosámibo mu minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Feto feyabo yagunu ya lo molaibo hatinau ya feto libo, Emotina yasi aifa holi nosámibo nomae, loto ha mono lufuwau (Sng 35:19, 69:4) nebo ha ya ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ena adina li faka lanaibo we ya Menefodokati ilifi molanobo we ha ona hula yawala Weuna ya Menefodokati lumunaibo hamenalo ya monane lo oloto pinogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ido hemotina ya ononane apiyodomati nemogi minomo yowama nenako, hemotina yagi monane lo oloto molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Hemotina ya nemo fulo nedoti uteba itanae, loto ha ya homu lobitoma ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Emotina yasi mono numuguti ya idipi feka fulitoti hanu hu betinabo ne. Ido hamena ma alilitanogolaiye. Yalo ya Goti ononala li minonibo ne, loti ya hemotina hofo beti fulinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Emotina ya Menefote nemote wa ledofefe ladámanako, ya feto feyanabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Feto feyanafa, nemo hawa homu ya lobitoboma ne. Ya ha ya hulawa fedageto ya emokafo homu lolumima ne, loti ya hatina ki gedoti hinae, loto ya lobiyowe. Homu ya hamena fanaidana hemotinagi minanogolonako, loto lobiyámoma ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ena me ya ya nilifi molaibo we nedoka yonowe, loto odoma ya hemotinaloka yati makafo hemo igaleka unane? loto loga o nedaibo we ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Minámifa, lobiyobo hawa yagunu milumawa lutina-hatinau yo-hola ya faito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Feti minafa, nemo ha ona lobiyowe. Hemotina ufefe lanae, loto ya liwila oto yonogolowe. Nemo liwila oto yowámanobo ya hemotinaloka adina li faka lanaibo we ya lomámanogolaiye. Yagunu yoto ilifi moloto ya hemotinaloka lumunaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lumuto wenina monatina poli biyageto ya nosámibo monawa, ido fefe libo monawa, ido lifimatina liwila oto binaibo monawa ya holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nemo holi hikito nomámanako, ya emokafo nosámibo monawa ya lageto holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ido Menefodoka liwila oto yowoto hofa wa nedámanigilanako, ya emokafo fefe libo monawa ya lageto holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ido mika melo wenaba Satani lifimala liwila oto muima nenako, Gotikafo wenina lifimatina liwila oto binaibo monawa ya lageto holinabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ena ha lobinobo ha abi loto aifa nefa, hamena onesa me ya ya lo huloto lobinobo ya hena fulitanae, loto lobiyámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yagunu ha ona hula yawala Weuna ya lumuto hawa ona hula ya api itibi hulanogolaiye. Ya eimola lula-halauti lobiyámanaibo, Gotikafo lomuibo aya yako lobinogolaiye. Ido idafa-adafa aliga oloto pinaibo yagi lo oloto binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ha ya neimodokati lito lo oloto binaibo yakafo nemo huline li faka lanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Menefodoka idafa-adafa muki nebo ya yawala nemo minowe. Yagunu ya nemodokati lito lo oloto binogolaiye, loto lobiyoma ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hamena fouma efoma minoti wa nedámanigilae. Ido hofa hamena fouma efoma minoti ya hofa wa nedanigilae, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ege-ege moniyabo we yauti maleka ya loyolalo-melo oti feto labo, Nena idafagunu ya ha feto loto liye? Hamena fouma efoma minoti wa nedámanigilae, loto, ido hamena fouma efoma minoti ya hofa wa nedanigilae, loto ya ido Menefodoka yonogolonako, loto libo yagunu ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","feto loti labo, Hamena fouma ne, libo ya neidafaiye liye? Ya monawa lemo holifefe ladámone, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ena loga o edanune, loti holiyabo, Yesukafo lutina-hatinau wa betito ya feto loto lobibo, Hemotina hamena fouma efoma minoti wa nedámanigilae, loto, ido hamena fouma efoma minoti ya hofa wa nedanigilae, loto lobiyobo yamagunu ya loyolalo-melo o minafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nemo ha ona lama lobiyowe. Hemotina hufo oti hufo nama o minato, ido mika me ya weninala yasi ake inigilae. Hemotina miluma-aluma holiti minanigilafa, milumatina yakafo li elepa ito lutina-hatina dowa loti holinigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wena makafo olufola hedanowe, loto hamenala alili ageto ya miluma holinaibo ne. Nefa, olufola hedo oloto pitoma ya miluma holibo yama fulitito ya olufola hedaibo yagunu lula-hala dowa loto holinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ido hemotina ayaidana oti ya hamena meleka miluma naba holi minafa, hofa liwila oto loto wa betiyoto lutina-hatina dowa loti holinigilae. Lutina-hatina dowa loti holinabo monawa ya li hopa o betinaibo we ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ena hamena yalo ya idafa yaidana-meidanagunu ma loga o nedámanigilae. Nemo ha ona hula lobiyowe. Hemotina Menefo idafa yaida-meidanagunu lomunabo ya nemo huline li minanako, binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Homu minomo yowado yaloma ya nemo hulinelo ya idafa magunu lomuwámabo ne. Onesa melekati ya lomu-lomu o minalo. Feto lomu-lomu o minanabo ya lutina-hatina dowa lotoko holi-holi o minanae, loto ya binogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ha lobi minobo yama wase ito lobiyoma nefa, hamena ma alili anaibo yalo ha wase ito ladámoto, Menefo yagunu lo oloto pito lobinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hamena yalo ya huline li minoti ha lomunigilae. Nemokafo hemotina yagunu Menefo lomu betinowe, loto lobiyámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","E'e, nemo Menefodokati lomobo ha ya holi hiki loti lutina-hatina numu-numu o minanako, Menefo eimola lula-hala ya bi-bi o nenako, nemokafo Menefo lomu betinowe, loto ladámowe. Hemotina huline li minoti ha lomunigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nemo Menefodokati mikalo lomobo ne. Ido me ya mika ya fulito Menefodoka hofa liwila oto yonogolowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ege-ege moniyabo we ya feto loti lomuwabo, Aiyo, hemo onesa me ya ya ha wase ito ladámoto, lo oloto lomanibo ya ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","idafa-adafa muki ya heimokafo holi hulane, loto holi minone. Yagunu ya hemo Gotidokati lomanibo ne, loto holi hikito minoninako, hofa loga-miga o hedámanogolone, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Feto loti lomuwato, Yesukafo ha liwila oto feto loto lobibo, Hemotina onesa ya holi hikito minafe? ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Holilo. Hamena ma alili ageto yalo ya hemotina nemo fulo nedo ititi upa-napatoti numunatinaloka u hulanabo ne. Hamenawa onesa ne. Hemotina fulo nedanigilafa, neimoko minámanogolowe. E'e, Menefo nemodoka mino nedainako, neimoko minámanobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nemo luneu mino nedoti ya you amena mona linae, loto ya ha ya lobiyowe. Hemotina mikalo melo minoti hena nabau mino-mino afa, nemo ya mikaleka hena aibo monala muki li yoima o edonako, yagunu hemotina ya aubatinagi minalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ena Yesukafo ha ya lo huloto, okulumau wa faka loto, feto loto Goti lomuibo, Menefone, hamenawama alili aiye. Hemo ya Hipaka nemo huline li oloto piyageto nemo Hipakakafo ayaidana oto hemo hulika li oloto pinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hemo mikau-mikau wenina muki hiyabatina we fulo nedanibo ya wenina li nuba o betito nomageto, nemodo abo wenina ya hofawa minowa-minowa anabo mona li oloto pi binane, loto lonomanima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ido hofawa minowa-minowa anabo monawa ya feito ne, Hemo Goti ona hula mako ido nemo Yesu Kilisto nilifi molageto obo we ya lemogi hutifina ledanabo ya nomudina hofawa minowa-minowa oti minanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ena onona ha lonomanima lito li huloto ya mikalo ya hulika li oloto piyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yagunu Menefone, mika me ya oloto piyámibo hamenalo ya hemote okulumau hulite yoisa yoto nebo yamaidana oto onesa me ya ya hemogi minoto ya hofa li liwila nomageto li minanowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ena mikalo wenina yauti li nuba o betito nomageto nemodo abo wenina ya hulika lo oloto pi biyobo ne. Ya wenina hemo weninaka minabo ya nemo nomanibo ne. Ido hemo haka ya holi hiki loti meyalo moloti ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ya idafa-adafa muki nomanibo ya hemodoka yatiko mino nedaibo yama onesa ya holifefe lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hemo ha lonomanima ya lobiyoto holiti li minae. Feti ya hemodokati lomobo yama holifefe loti ido hemo nilifi molanibo yama holi hiki lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nemo weninawa yagunu holito lohomowe. Mika me ya weninala yagunu loto lohomámowe. Nomanibo yama heimo weninaka hula minabo yamagunu emotinagunu holito lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nemo weninane muki ya hemo weninaka hula minae. Ido hemo weninaka yagi ya nemo weninane hula minae. Ido emotina lutinau yau nemo huline li oloto piye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nemo mikaleka minobo hulotainako, emotina yako mikaleka minato, nemo ya hemodoka anogolo ya owe. Fele Menefo, leimo lute mako moloto mino-mino o minoibo ya emotinasi ayaidana oti lutina mako moloti minanae, loto hemo hulika nomanibo yamakafo hiyaba o betiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Emotinaloka mino betiyobo ya hulika nomanibo yakafo hiyaba o betiyoto ma u hopa aguwámabo ne. Lowa eba olufola mako yako u hopa wido ya ha mono lufuwau nebo ha ya ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ido me ya ya hemodoka yonowe, loto nemo lune-hane dowa loto holiyobo yamakafo emotina lutina-hatinau yoto faitanaiye, loto mikalo me ya minoto hawa ya lowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ena nemokafo haka ya lobiyoto li minato, nemo monane ya mika me ya weninala monatina yaidana oto mináminako, emotina yagi ayaidana oti monatina eito molanako, mika me ya weninala yasi holi nosámibo bi-bi o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hemo mikalokati idipiyo, loto ladámowe. Nosámibo yawala ya li hopa o betitanaiye, loto hiyaba o betiyo, loto lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mika me ya weninala mikaleka mona molabo yaidana oto nemo molámonako, emotina yagi ayaidana oti mikaleka mona molámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hemo ha ona hula yakafo utina-weudina-lutina-hatina li fele o betiyo. Hemo ha lanibo ya ha ona hula ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hemokafo onona ha lonumuto mikaleka nilifi molanibo yaidana oto onona ha lobito mikau-mikau idipi molobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Emotina ya ha ona hula liyabo yakafo ya utina-weudina-lutina-hatina li fele itanaiye, loto neimo ya emotinagunu holito une-weune-lune-hane li fele itowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ena nemo ya weninawa yagunuko holito lohomámowe. E'e, ha mono lobiyato holiti holi hikito numumo yonabo wenina muki yagunugi holito lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Emotina ya lutina mako molo betiyo, loto lohomowe. Menefone, hemo ya nemo luneu minanibo ido nemo ya lukau minobo yaidana oti emotina ya leimo luteu minanae, loto holito lohomowe. Feto feyato, mika me ya weninala yasi heimoka nilifi molageto lomobo yama holi hikitanae, loto holito lohomowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leimo lute mako moloto mino-mino o minoibo yaidana oti emotina ya lutina mako moloti minanae, loto ya hulite yonaibo mona nomanibo yama biyobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nemo lutinau minoto, ido hemo luneu minageto, emotina lutina hutifinati u mako uwato, mika me ya weninala yasi heimoka nilifi molageto lomobo yama holifefe lanae. Ido hemo ya luka-haka nomanibo yamaidana oto bi-bi o minane, loti yagi holifefe lanae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ena Menefone, nomanibo wenina yama nemo minanodo minanae, loto holiyowe. Mika okuluma apito oloto piyámibo hamenalo ya luka-haka numuto okuluma lamena nomanibo yama leimogi minoti wa dowa molanae, loto holiyowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Menefo fefe libo mona yawala, mika me ya weninala yasi hemo wa hedofefe ladámafa, neimo ya moda wa hedofefe lo minoto, ido weninawa yasi heimoka nilifi molageto lomobo yama holifefe lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nemo haka ukuka lo oloto pi bitobo, ya moda lobitoko minanogolowe. Hemo luka-haka nomanibo mona yama mino betinaibo, ido neimo yagi lutinau mino betinowe, loto haka ukuka lobitoko minanogolowe, loto ya Goti lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ena Yesukafo ya Goti lomu huloto ege-ege moniyabo wegi maina numudoti lumuti no hefola ma huliya Kidiloni ya hiliti yá hiniba ma nedo yalo ya uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uwado yalo ya Yesu ya ege-ege moniyabo we yagi hamena-hamena nuba o-o ato, uwolafo adinalo molanaibo we Yudasi yagi homu ebawa ya waibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ena yalo minato, ya Yudasikafo gamani himiwe yagi ido Goti sokila hi muwabo we hiyabatina we ido Falisi we himiwetina yagi idipito abo minadoka wito lumuti lamu-letina hiti mainafa-anafagi liti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Uwato, ena Yesukafo idafa-adafa o edanabo idafa ya holi huloto ya yá hiniba hanu welalo ya uto wa betito feto libo, Hemotina hema moni wita minae? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","emotinasi liwila oti lomuwabo, Nasalete numudoti we Yesu moni wita one, loti lomuwato, Yesukafo libo, Nemo me ya ya minobo yae, loto lobito, ido uwolafo adinalo molaibo we Yudasi yagi minagu ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ena Yesukafo, Nemo me ya ya minobo yae, loto lobibo, ya elegiti egetinalokati uti lumu fou lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Feto feyato, hofa loga o betito libo, Hemotina hema moni wita minae? lito, emotinasi, Nasalete numudoti we Yesu moni wita one, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesukafo ha liwila oto lobibo, Nemo me ya ya minowe, loto lobiyobo ya nemogunu moni wita otima ya me ya minabo we ya waito betilo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","feto feyabo yagunu homu ya feto loto libo, Nomanibo wenina yama hiyaba o betiyoto ma u hopa aguwámabo ne, loto homu libo ha yama ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ena Saimoni Pitakafo ya mi fana li nebo ya ika oto sokila hi muwabo we hiyabatina we naba houba-nabala we huliya Malukusi ya hala onaleka ya fuko fulitaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Feto feyaito, Yesukafo Pita feto loto lomuibo, Mika ya owolau ya holiyo. Henawa ya Menefokafo numibo yama liyámanobo nefe? loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ena gamani himiwegi, hiyabatina we wenabatina yagi, ido Yuda wenina yauti fele huliyagi numuna naba himiwe yagi ya Yesu liti nala i edoti ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasi nedo ya ilimiti uwae. Ena Anasi oluwa libo we Kaiyafasi ya melege mako ayau ya Goti sokila hi muwabo we hiyabatina we wenaba nenako, yagunu Anasi nedo ya ilimiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafasi yakafo homu Yuda we feto loto lobibo, We mako ma lemogunu loto fulinaibo ya dowa minanogolone, loto lobitaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ena Saimoni Pitate Yesu ege-ege monibo we mate ya Yesu ilimiti uwado ege ya uwaiye. Uwaibo ege-ege monibo wewa ya sokila hi mu-mu abo we hiyabatina we wenaba yakafo wa nebo nenako, Yesu ege uto numuna hilalau ya maina yoifa, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ya hila welalo feka ya sinoi ne. Sinoi neto, sokila hiyabo we hiyabatina we wenaba waibo wewa yakafo lumuto hila welalo hiyaba aibo olu ya lomuito Pita hanu si edaito, hila lulauka ya yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yoito, hanu hiyaba aibo oluwa yakafo Pita feto loto lomuibo, Hemo ya we youma ege-ege moniyabo we yauti ma minabemo? lito, ya E'e, nemo minámowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Feto lito, ya houba-naba we ido fele huliyagi numuna naba himiwe yagi asi fuliti so hiti labi minato, Pita yagi maina sinoi minoti so labi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ena sokila hi muwabo we hiyabatina we wenaba yakafo Yesu ege-ege moniyabo we yagi ido ha mono lo-lo aibo ha muki yagunu loga-miga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesukafo ha liwila oto lomuibo, Nemo ya mono numunatinau ido fele huliyagi numuna nabau ya Yuda wenina mau iti minado ya wenina muki ha oloto lobito, api itibi-itibi oboma ne. Ha faluku oto ya ma ladámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yagunu neidafaito nemo loga o nedane? Hane lobiyoto holiyabo wenina ya loga o beti wae. Emotina ya ha lobi-lobi obo ha ya moda holi minabo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Feto lito, fele huliyagi numuna naba himiwe minagu yauti makafo Yesu hofoto ya feto libo, Hemo sokila hi muwabo we hiyabatina we wenaba ya ha yaidana ya neidafaito lomuwane? lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesukafo ha liwila oto feto loto lomuibo, Ha nosámibo loneyama ya monawa lo oloto molo. Ido ha dowa lanobo ya neidafaito hofo nedane? lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lomuito, Anasikafo lobito, Yesu ana nala iti sokila hi muwabo we hiyabatina we wenaba Kaiyafasi nedo ilimiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ena Saimoni Pita ya so labi oto sinoi neto, loga o edoti labo, Ege-ege moniyabo we minagumati hemo ya ma minabemo? lato, ya emokafo, E'e, nemo minámowe, lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Lobito, sokila hi muwabo we hiyabatina we wenaba houba-nabala we yauti ma Pitakafo hofoto hala fuko fulitaibo we yama weninalakafo feto loto lomuibo, Aiyo, hemo yá hinibauma emogi maina minageto wa hedoma nanowe, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitakafo hofa, E'e, lito ayalo ya okolofo nola liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ena ho lo falatito Yesu ya Kaiyafasi negu yauti ilimiti lumuti gamani numudo ya uwae. Uti Yuda wenina yasi Goti nomunalo ya lute-hate li fuma ito Goti Uta O Betibo foliwau ya wete-idafa námotanune, loti gamani numunau ya yowámoti feka ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Feka minato, Pailatikafo ayalo lumuto loga o betito libo, We me ya ya nena lifimala nebogunu ya ilimiti ae? lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","wenina yasi ha liwila oti feto loti lomuwabo, Emo ya nosámibo mona molámibo neko, hemo minanido ya ilimito ámadi ne, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Feto lato, Pailatikafo feto loto lobibo, Heimotina liti lo molabo hatinau yati lifimala li muilo, lito, Yuda wenina yasi feto loti lomuwabo, Lemo wenina lifimatina li bito hofo beti fuliyámanabo ne, loti lo fuko ledotama ne, lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Feto loti labo ya Yesu fulinaibo hanu eimolakafo ha homu lo oloto bitaidoma ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ena Pailatikafo gamani numugu ya liwila oto yoto Yesu ilimiti alo, lito ya holiti ilimiti ato, ya loga o edaibo, Hemo ona Yuda wenina hiyabatina we wehudi minabe? Olo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesukafo liwila oto libo, Ha ya heimoka hakaloti labemo, ido wenina masi nemogunu feto lohomato holito lane? lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Lomuito, Pailatikafo liwila oto libo, Nemo ya Yuda we minámowe. Heimoka weninaka ido sokila hiyabo we hiyabatina we yasi nemo minodo ya hilimiti abo ya hemo neidafa feyageto hilimiti ae? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Loga o edaito, Yesukafo ha liwila oto feto loto libo, Nemo me ya mikaleka wenina wehuditina ya minámowe. Mikalo wenina wehuditina minobo neko, houba-nabane we yasi nemo ane li faka loti Yuda wenina yasi nala fi nedotanae, loti lowa fi biyadi ne. Nefa, nemo wenina hiyaba o betiyobo monane ya mikaleka wenina wehuditina hiyaba o betiyabo mona yaidana oto minámiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ido Pailatikafo feto loto lomuibo, Hemo wehudi ma minabe? Olo, lito ya Yesukafo ha liwila oto libo, Moda ya lanibo yae. Nemo wehudi minoto ya ha ona hula lo oloto pi binowe, loto mikaleka lumuto oloto piyobo ne. Yagunu ha ona hula holifefe labo wenina ya nemo hane yagi holifefe lae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lomuito, Pailatikafo feto loto lomuibo, Ha ona hula ya nena idafa ne? loto ya liye. Pailatikafo feto lototo hofa feka ya uto Yuda wenina minado lumuto feto loto lobibo, Nemo we me ya ya lifimala wita ofa, li oloto piyámowe. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Monatina ma feito nebo, Goti Uta O Betibo folilo hemotina lonomado ya nemo nalalo minabo we yauti ma ya wina edowe. Monatina feti molabo yagunu eletifo me ya ya hemotina Yuda wenina hiyabatina we wehudi wina edoto aifa mino ledanaiye, loti holiyafemo? loto loga o betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Loga o betito emotina yasi hofa feto loti auba iti labo, E'e, me ya we ya minámiye. Balabasi ya wina edo, loti lae. Feto labo we Balabasi ya wenina hofo betito idafa-adafatina ipoto li-li aibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ena Pailatikafo lobito, himiwe yasi Yesu safu etuwa hasuwala lifefe labo ikulagunu hofoti, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","agina hasuwalagunu helekamu lifefe loti mananalo ya auba iti holoi edoti, ulalo owo fana luta-hisi libo yagi holoi edae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Feti ya emo nedo loti, Aiyo, dowae, Yuda wenina hiyabatina we wehudi, dowae, loti adinagunu aubawagi hofae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ena Pailatikafo Yuda wenina minado ya hofa lumuto feto loto lobibo, Walo. Nemo hemotinaloka ilimito lomobo ya lifimala moni wita ofa, li oloto piyámowe, loto lobiyobo ya holilo, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lito, ya Yesu helekamula hasuwala fibo i edabo ido owo luta-hisi libo yagi holoito lumito, Pailatikafo itibito ya, We me ya ya wa edalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lobito, sokila hi muwabo we hiyabatina we ido fele huliyagi numuna naba himiwe yagi wa edoti ya, yá yofolo hofo! Yá yofolo hofo? loti ha auba iti lato, Pailatikafo feto loto lobibo, Nemo lifimala wita ofa, li oloto piyámonako, hemotina heimotina liti uti ya yá yofolo hofalo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Lobito, Yuda wenina yasi ha liwila oti feto loti lomuwabo, Emokafo nemo Goti Hipala minowe, loto eimola yagunu lo-lo o nebo ya wenina yaidana lanabo ya fulinae, loto lo molaibo hateu ya nebo ne, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailati ya holito holi naba holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Holi naba holito ya Yesu ilimito gamani numugu hofa yoto loga o edoto libo, Hemo igalekati anibo ne? lito ya Yesukafo ha liwila oto lomuwámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ha liwila oto lomuwámito, Pailatikafo feto lomuibo, Ha lonomámanibo nefe? Nemokafo wina hedanae, lanobo ya wina hedanigilae. Ido yá yofolo hofo hedanae, lanobo ya hofo hedanigilae. Yaida mona muki ya nemoko hiyaba oma ne. Ya ma holámabe? lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Lomuito, Yesukafo ha liwila oto feto loto lomuibo, Yoisa nebo we yakafo auba homámibo neko, hemo auba ito nemo li yoima o nedámadi ne. Yagunu ya wenina hemodoka nilimiti abo wenina lifimatinakafo hemo lifimaka li fulo edoto ne, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Feto lito, Pailatikafo hawa ya holito Yesu wina edanowe, loto holifa, Yuda wenina yasi feto loti auba iti labo, Hemo we ya wina edananibo ya Sisa hafuwalo we minámanogolane. We makafo hiyaba we wenaba minowe, lanaibo ya Sisa li yoima o edanowe, loto ya liye, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Feto loti labo ha ya Pailati ya holito lobito, Yesu ilimiti lomato, ha lo onuwa molo-molo aibo folomolo ya amedoto ne. Ebawa ya Hefanagunu Lifefe Labo Eba ne, loti huliya molabo ya Yuda wenina hatinalokati ya Gabata ne, loti huliya molae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ena Yuda wenina Gotikafo Uta O Betibo foliwa idafa-adafa lifefe lanabo hamena ya neto, ya belo alili aito ya Pailati folomolo ya minoto Yuda wenina feto loto lobibo, Hemotina wehuditinama me ya ya wa edalo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","emotina yasi feto loti auba iti labo, Ilifi fulo! Ilifi fulo! Yá yofolo hofo? lato, Pailatikafo feto loto lobibo, Aiyo, wehuditina yá yofolo hofoto fulinaiye, loti lo minafe? Olilo, lito sokila hi muwabo we hiyabatina we yasi ha feto loti liwila oti lomuwabo, Lemo wehudite Sisa makomako nema ne. Ma minámabo ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Feto lato, Pailati holito Yesu yá yofolo fulinaiye, loto fulo adinau itaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ena himiwe yasi Yesu liti yá yofo li muwato mofuito, mika ma huliya Atatina Auba ne, loti molabo, ya Yuda halokati huliya Gologota ne, loti molabo, yalo ya ilimiti uti ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","yá yofolo hofo edabo, ya we loiti ma maina hofo betiyabo ya ma ya hofo anawa filigaleka iti, ido ma ya hofo anawa filigaleka iti, ido Yesu ya hofo lusaku ya itae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ena Pailatikafo lito ya yá yofolo Yesu atala mulalo ya feto loti lufuwa iyabo, Nasalete we Yesu ya Yuda wenina hiyabatina we wehudi ne, loti iyabo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ya Yuda ha ido Lomu ha ido Giliki ha tili (3) yalekati iyato, Yesu hofabo eba ya selo numudo nenako, Yuda wenina abi loti ayalo uti loti emotina yasi lufuwawa ya hitae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Feti hitato, Yuda wenina sokila hi muwabo we hiyabatina we yasi uti Pailati feto loti lomuwabo, Hemo Yuda wenina hiyabatina we wehudi ne, loto lufuwa iyanibo ya fulitoto. Eimolakafo nemo Yuda wenina hiyabatina we wehudi minowe, loto libo we ne, loto iyo, lato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailatikafo ha liwila oto lobibo, Lufuwa iyobo ya moda itowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ena himiwe yasi Yesu yá yofolo hofoti ulalo owo liyabo ya u fo (4) wito hona moloti liyafa, ulalo owo lulau ya okati owo lumu waka lumibo hifiyabo yaidana oti hifiyámabo ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","yagunu ya feto loti loyolalo-melo abo, Ya fekaliyámoto molo lusaku itoto noka hedoto melafo makafo linaibo ya linaiye, loti ya feto feyabo yagunu ha ma mono lufuwau ya feto loto libo, Emotina yasi unelo owo hona molo liti ma luma nebo ya noka hedoti liyae, loto ha mono lufuwau (Sng 22:18) nebo ha ya ayalo hulawa fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ena Yesu olafole unalafole, Kolopasi olonafo Maliale, abalafo Madala numudoti wena Maliale Yesu yá yofola monau ya sinoi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ido Yesukafo olafogi ege-ege monibo we lula-hala muibo wegi selo sinoi minaibo ya wa betito olafo feto loto lomuibo, Wenao, hipaka yo-hola ya ne, loto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ido ege-ege monibo wewa feto loto lomuibo, Okafo ya ne, lito ya hamena yaloti ya eimola numunalau ilimito uto hiyaba o edomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ena Yesukafo ononala hulibo ya holito mono lufuwau ha ma neboma ya hulawa fedanaiye, loto ya Henobane opaiye, lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","no waini ekefa aibo ma nomuku negu yau ya ho nokuti noi aila yaidanakafo ekefa aibo noku yau fiti oso umalo ya welau iyato naiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Noto ya Moda hulotaiye, loto manana li huba ito weuna ilifi moloto fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ido aya hamenalo Yuda wenina Goti Uta O Betibo foliwa idafa-adafa lifefe lanabo hamena neto, ido leda ya Sabati foliwa naba nenako, wenina yá yofolo hofo betiyabo ya hono utina ya yá yofolo aifa minanaibo eleka hofo ledaiye, loti Pailati feto loti lomuwabo, Himiwe yasi hidina auba lekoti hono utina ya kiliti liti unae, loti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","O, lito himiwe yasi we loiti Yesugi hofo betiyabo ya ma hina auba lekoti, uti ma hina auba lekae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lekoti uti Yesu hofado ya uti moda fulitaibo ya wati hina auba lekámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lekámafa, himiwe makafo yofalau ya hiyagunu magala fito, lunugi nogi ayauti lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","Feto fe edabo yagunu feto libo, Aubala ya lekámanigilae, loto ha mono lufuwau (Sng 34:20) ya nebo ne. Ido ha ma feto libo, Emotina yasi magala fi edabo we ya wa minanigilae, loto ha mono lufuwau (Sek 12:10) nebo ha ya hulawa fedanaiye, loto idafawa ya oloto piye. Ena idafawa lufuwa ibo wewa idafawa ya eimola nomuna hulagunu wa edaibo nenako, lo oloto molobo ya ona lowe, loto holi ne. Hawa ya ona hula ne. Yagunu ya hemotina yagi holi hikitanae, loto lo oloto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ena Alimatea numudoti we Yosefe ya Yesu ege molaibo we nefa, Yuda wenina holitina holito lo oloto piyámoto monala molo faluku oto moloto moni nebo yakafo Pailati nedo ya uto Yesu hono ula kilito lito unogolowe, loto lomuito, Pailatikafo, O, lito uto kilito lito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Feto feyaito, Nikodemusi yagi homu Yesu nedo lubuka wibo we yakafo yá nowala ladanuwa aibo idafa loiti ma huliya mulu yagi ma huliya alo yagi li mako aito henala teti (30) kilogilamu yaidana oto ya nomuwagi lito uto Yosefe ana li faka lito ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yesu hono ulalo ya yá nowala wili edoti owo lafo-lafo hiyobagunu wase i edaibo ya Yuda wenina yasi wenina fuliyabo ya feto fe beti-beti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ena Yesu yá yofolo hofado filigaleka ya yá hiniba ma negu yau hefana lula ma hono ula molanune, loti uwaitagu ya wenina ma molo betiyámabo hofawa negu ");
INSERT INTO snp_lambau_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ya Yuda wenina Sabati foliwa idafa-adafa lifefe lanabo hamenawa nebo yagunu holiti eba selo yau ya Yesu hono ula ya molo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ena Sabati foli hulito salele homu hamenalo leda lubuka ho ladámito Madala numudoti wena Malia ya hono ula molabo ebalo ya u fedoto waibo ya hono molabo hefana lula welaloti hefana naba ya u eito uto, hanu godo neto, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","wato oluloto uto Saimoni Pitate Yesu ege-ege monibo we lula-hala muibo wete feto loto lobibo, Wenaba hono ula liti utanako, igauka molafe? Lemo ma holiyámone, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Feto lito, Pitate ege-ege monibo wewa yasi hono molado ya unoiye, loti ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","oluloti uwaibo ya ege-ege monibo we mamamo Pita li aliga edoito u homu u fedoto ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","lulau ya yowámoto ya huba ito waibo ya owo lafo-lafo hiyobagunu wase i edabo yako neto waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Feito wa neto, Saimoni Pitakafo aliga u fedoto lulau yoto ya owo hiyoba ya neto wato ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ido mananalo wase iyabo idafa ma owo hiyobagi keloto minámoto eito fele yo fi neto ya waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Waito ya hono molado homu u fedibo we yamagi ayaidana oto yoto wato ya holi hikitiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aya hamenalo ya Yesu fuliguti sinoinogolaiye, loto mono lufuwau nebo ha yama holifefe ladámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ena hofa liwila oti numunatinaloka uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ena Malia ya hono molabo lega ya sinoi minoto hufo oto, hanu welalo ya huba ito hono molabo ebau ya waibo, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","enisole loiti utinalo owo hiyobagi Yesu molo edado ya amedoti minaibo ya ma ya mananaloka neto ido ma ya hinaloka neto ya wa betito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","emotina yasi feto loti lomuwaibo, Wenao, neidafaito hufo o minane? laito, emokafo lobibo, Wenabanema limo igauka molafe? Wagámowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","li elepa ito waibo ya Yesu eimola sinoi o nebo wa edaifa, Yesu ne, loto wafefe ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wafefe ladámito, Yesukafo loga o edoto libo, Wenao, neidafaito hufo ane? Hema moni wita minane? lito ya emokafo ya yá hiniba hiyaba we ya ne, loto hala kito feto loto lomuibo, Wenabao, hemokafo limo maleka molotoma ya lonomageto holito uto lito unofao, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesukafo, Maliao, lito, emokafo li elepa ito Yuda halokati Labonai, loto lomuibo ha monawa ya api lilibiyanibo we, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Feto lito, Yesukafo feto loto lomuibo, Onesa Menefodoka yowámobo yagunu minodo ya abusa iyámo. Unanefo-mota minado ya uto feto loto lobiyo, Nemogi hemotinagi Metefo ido Gotite nedo ya yonogolowe, liye, loto lobiyo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Madala wena Malia liwila oto loto ege-ege moniyabo we feto loto lo oloto bibo, Nemo Wenaba wa edoto owe, loto, ido hawa lomuibo yama lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ena aya hamenawa ya Sade lunaga lubu ito ege-ege moniyabo we ya Yuda wenina holitina holiti numugu nuba oti hanu hu hiki lo ititi minato, Yesu ya hiyatinau lo fedoto sinoi minoto feto loto lobibo, You amena mona ya hemotinaloka mino betinaiye, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ana loiti yofalagi ya itibito, ege-ege moniyabo we ya Wenaba wa edoti lutina-hatina dowa loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ena Yesukafo hofa feto loto lobibo, You amena mona ya hemotinaloka mino betinaiye. Menefokafo nemo nilifi molaibo yaidana oto nemokafo hemotina idipi molowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","wela-mula fulo betito ya feto loto lobibo, Weuna Fele ya mino betinaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hemotina wenina lifimatina hilili o betinabo ya moda ona hilili aiye. Ido lifimatina waito betinabo ya moda ona aifa mino betiye, loto ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ena ege-ege moniyabo we tuwelu (12) yauti ma huliya Tomasi huliya ma Didimusi ya ege moniyabo we minagu ya minámito, Yesu oloto pi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Feto ainako, ege-ege moniyabo we malekama yasi lomuwabo, Wenaba wa edone, loti lomuwafa, feto loto lobibo, Nemo neimo nomunegunu wato anau niligunu hofabo fulala ya wato ane umagunu godigu lolesa oto ido yofalau yagi anegunu lolesa otomako ya holi hikitanowe, loto ya liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ena fo hamena eiti (8) ya wito ege-ege moniyabo we numugu ya hofa minabo ya Tomasigi maina minoti hanu hu hiki lo ititi minato, Yesu ya hiyatinau hofa lo fedoto sinoi minoto feto loto lobibo, You amena mona hemotinaloka mino betiye, loto ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasi feto loto lomuibo, Hemo aga umagunu aneu ya lolesa oto wao. Ido aga sino loto yofaneu ya li holiyo. Li holitoma ya haka loiti-loiti kiyámoto holi hikilo, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasikafo ha liwila oto feto loto lomuibo, Hemo Wenabane ido Gotine minane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Lomuito, Yesukafo lomuibo, Hemo wa nedaninako, holi hikitane. Nemo wa nedámoti holi hikitabo wenina ya dowa loti holitiko minanigilae, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ena idafa hofawa aubala itibibo idafa ma abi idafa Yesukafo ege-ege moniyabo we nomudinalo yalo ya li oloto pibo idafa ya lufuwau meu ya muki iyámibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ibo efo me ya ya feto loto ibo, Hemotina hitoti holiti ya Yesu ya Goti Hipala ilifi molaibo we Kilisto ne, loti holi hikitanae. Holi hikito muti ya emo huliyalo nomudina hofawa minomo yonigilae, loto ibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ena hofa aliga ege-ege moniyabo we Taibeliyasi momenolo ya minato, Yesu oloto pi bibo ya feito oloto pi bibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Pitale, Tomasi huliya ma Didimusile, Galili mikalo Kana numudoti we Nataniyelile, Sebedi hipala loiti yagi ido ege-ege moniyabo we yauti ma loiti yagi feti wenina yaleka minato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimoni Pitakafo feto loto lobibo, Nemo laefalo moninowe, loto unogolowe, lito, ya feto lomuwabo, Hemogi maina unune, loti sipiku ya yoti uti moniyabo ya lubuka yalo ya laefa ma liyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Feto feyato, ho lanowe, loto feyaido ya Yesu no sesepalo ya sinoi nefa, fefeluma wa edámato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesukafo feto loto loga o betibo, Hipane-motao, laefa ma liyafe? lito emotinasi, Ma liyámiye, loti ha liwila oti lomuwato, ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","emokafo feto loto lobibo, Owo ya fulo filiga sipi onaleka ya itanabo ya linigilae, lito owo ya fulo onaleka ya itato, laefa ya faitito ika o moniyafa, ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yagunu ya Yesu ege-ege monibo we lula-hala muibo wekafo ya Pita feto loto lomuibo, Moda Wenaba ya nebo yae, lomuito, Saimoni Pita hawa holito ulalo owo ya li fuloto molo itoto onona lido yati hofa li ito sipikuti nolulau ya satomo ito wibo ya ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","no sesepa faiga minámibo wani hadeti (100) mita yaidana oto neto wito, ido ege-ege moniyabo we malekama ya owo noku fulabo ya laefa faitito sipiku minoti ika-ika oti liti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Uti limo noku molo ititi sesepalo ya lumuti hemo ya so ligu ya laefagi beletigi neto ya wae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wato, Yesukafo feto loto lobibo, Laefa liyabo maleka liti alo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimoni Pitakafo sipiku ya yoto owo ya noku yati ika oto lito no anawalo aibo ya laefa naba-naba faitibo ya wani hadeti fifiti-tili (153) yaleka ya nebo nefa, owo ya fukámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ena Yesukafo feto loto lobibo, Loti leda-hoba nalo, lito ya ege-ege moniyabo we ya, Wenaba ya ne, loti holi hulotanako, ya hemo hema minane? loti loga o edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ena Yesu loto beletigi laefagi lito hona moloto biye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yawe ya Yesu fuliguti sinoito ege-ege moniyabo we oloto pi bibo ya hamena tili (3) oloto pi biye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ena leda-hoba notiti minado ya Yesukafo Saimoni Pita feto loto loga o edaibo, Yoni hipala Saimoniyo, hounakafo-mota lutina-hatina numu minabo we ya li fulo betito luka-haka nomabe? lito Pitakafo lomuibo, O, Wenabao, nemo lune-haneu ya hemogunu holiyobo ya wa nedo minane, lito ya Yesukafo lomuibo, Sipisipine mofola wetina-idafa biyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Feto loto hofa loga o edaibo, Yoni hipala Saimoniyo, hemo ona luka-haka nomabe? lito Pitakafo lomuibo, O, Wenabao, nemo lune-haneu hemogunu holiyobo ya wa nedo minane, lito ya Yesukafo lomuibo, Sipisipine ya hiyaba o betiyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Feto loto hofa ma feto loto loga o edaibo, Yoni hipala Saimoniyo, hemo ona luka-hakau ya nemogunu holabe? loto hamena tili (3) loga o edaibo yagunu Pita lula-hala hena aito ha liwila oto lomuibo, Aiyo, Wenabao, hemo idafa-adafa muki ya holi hulo minanibo wema minaninako, nemo lune-haneu ya hemogunu holiyobo yagi holi minane, lito ya Yesukafo lomuibo, Sipisipine wetina-idafa biyo. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nemo ona lama lohomowe. Hemo we hofawe minanibo hamenalo ya hebekagi lifefe loto ito hanu ma moninowe, loto holiyanido ya moni-moni anima nefa, ido aliga we kilofo moloto minananibo hamenalo ya aga sino lageto, we makafo hebe i hedoto ma aguwámanowe, loto holinanibo ebaleka yaleka hilimito unaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Feto loto libo ya Pita fulinaibo monawa yakafo Goti huliya li faka lanaiye, loto holito liye. Feto loto ya Pita lomuto libo, Hemo loto nege-nege molo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Feto loto lomuito, Pita ya liwewe oto Yesu ege-ege monibo we lula-hala muibo we egetina wito wa edaibo wewa ya homu Goti Uta O Betibo hobinawa nagu ya atala ya Yesu ikiyalo ya fuloto feto loto loga o edaibo, Wenabane, hemakafo hemo uwokafo adinalo binaibogunu lane? loto lomuibo we ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ya Pitakafo wa edoto Yesu loga o edoto libo, Wenabao, me ya we ya neidafa anaibo ne? loto loga o edaito, ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesukafo feto loto lomuibo, Emo ya nemo liwila oto anobo hamenalo ya aifa minanaiye, loto holinobo ya hemo idafaka nefe? Hemo ya aifa nege yako molo, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Feto libo yagunu mono hounatinafo malekama yasi aliga ya feto loti lo oloto molabo, Yesu ege-ege monibo wewa ya fuliyámanogolaiye, loti lafa, Yesukafo ya fuliyámanaibo ne, loto ladámibo ne. Aifa feto loto lomuibo, Nemo liwila oto anobo hamenalo ya aifa minanaiye, loto holinobo ya hemo idafaka nefe? loto ya libo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ena ege-ege monibo wewa yamakafo idafa-adafawa wa hulibo idafaloka lo oloto moloto lufuwau meu ya ibo we ya ne. Hawa ya lo oloto molaibo ya ha ona hula ne, loto holi minone. ");
INSERT INTO snp_lambau_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ena Yesukafo idafa-adafa ma muki oto moloto aibo yama ya igaidana oto lufuwau ya i hulanubo ne? Muki lufuwau ya li molonibo neko, lufuwa idafa yamo uto mikau-mikau faito fulitageto eba ma minámoto buku ma aifa minadi ne, loto holiyowe. Modae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyofilusiyo, nemo Luku moda homu lufuwa i fulo hedogu ya Yesu oto moloto aibo ha muki ya onona apito limo uto-uto, ha mono apito lobimo uto uto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","li okulumau yonogolo ya weuna fi betibo we aposolo ya Weuna Fele welaloti ya ha lo molo betitaito, ya Gotikafo ilimito okulumau yoibo hawa muki yagunu ya moda lufuwa i humutobo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesukafo ula ogofu naba-naba holitoto aposolo weninalawa minado ya fedoto, wenina yasi nomune hofawa ne, loti holiti hatina loiti-loiti kiyámanae, loto mebe-maba abi ya li oloto pi biye. Li oloto pi bito hamena foti (40) ya mikalo minoto Goti hiyaba we wehudite hiyaba o ledaibo ha lobimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hawa lobimo uto hamena ma maina wetina-idafa no minado yalo lo molaibo feito bibo, Hemotina Yelusalemu ya fulámoti, Menefo idafa binowe, loto lo molo bibo ya lobiyobo ya hiyaba o minalo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yagunu Yoni ya nogunu noku i betifa, ido fo hamena malekama uwageto yalo hemotina Weuna Fele yakafo noku i betinogolowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lobito, ido nuba oti minado loga o edoti labo, Wenabao, Isilaeli wenina hofa li auba i lumuto hiyabate we wehudi onona linabe? loti loga o edae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Feti loga o edato, Yesukafo liwila oto lobibo, Hemotina Metefo eimola aubalalo idafawa fedanaibo hamena molaibo ya holinune, loti lafa, ido fedanaibo hamenawa ya idafatina minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","E'e, idafatina minámifa, ido Weuna Fele ya mino betido yalo auba ya bito liti uti Yelusalemu numudo, ido Yudia mika negu-negu, ido Samalia mika negu-negu, ido lowa-lawa mika faiga negu yagi hane ukune ya lo oloto bimo unigilae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Feto loto lobito, Gotikafo nomudinalo li faka loto ilimito okulumau yoito, limukafo li faluku edaito ya ogofuti wa edámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ogofuti wa edámoti okulumau akawa auba iti wenu wa minato, we loiti utinalo owo feke libo ya haita minadoka loti sinoi minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Sinoi minoti feto loto lobibo, Galili weninao, nedafaito melo ya sinoi minoti okulumau wenu wa minae? Wewa Yesu ya hemotinalokati ilimito okulumau yoibo ya liwila oto mikalo anaibo hamena ya okulumau wito wa edabo yaidana oto liwila oto anogolaiye, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Feto laito, ya minabo obula Olifi ya fulitoti lumuti mako kilomita yaidana uti Yelusalemu numudo ya liwila oti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Liwila oti u fedoti numuna ma mulalo aifa nedo yoti minomo uwae. Minabo wenina ya hulitina feito ne: Pita, Yoni, Yemusi, Adulu, Filipi ido Tomasi, Batolomiu ido Matiu, Alifiusi hipala Yemusi, Saimoni huliya ma Seloti, ido Yemusi hipala Yudasi yaleka we ya minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Feti wenina muki nuba o-o abo yagi, Yesu unalafo-motagi, olafo Maliagi, ido wenipamagi muki lutina-hatina mako moloti minoti Goti lomumo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ena hamena yalo holi hikitabo wenina wani hadeti tuwedi (120) ya nuba minagu ya Pitakafo nomudinalo sinoito ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","feto loto lobibo, Mono weninane-motao, holilo. Yudasikafo Yesu ya uwolafo-mota idipito loto adinalo bibo we hala ya aidena yoimaloka Weuna Fele yakafo Defiti welalo ha ya molaibo hama onesa u ayaloma iye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ido Yudasi homu lemogi maina keloto minoto mono onona limo uwone. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Feito nefa, wewa mona nosámibo molaibo, meinala muwabo yakafo mika ma meina fito aya mikalo ya lumu fou loto, sebala opoloka hito lula-halau idafa muki feka aito fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Fulito, Yelusalemu numudo minabo wenina muki ya hawa holi hulabo yagunu fulibo mikawa ya huliya Akeldama ne, loti molabo hatelokati monawa ya Lunu Lekibo Mika ne, loto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yagunu mono lufuwa bukuku Mono Nama yau feto libo, Numuna ya yupa minageto wenina ma yau minámanigilae, loto ha mono lufuwau (Sng 69:25) ya nebo ne. Ido magi ya feto libo, We ma yakafo hiyaba we ononala ya linaibo ne, loto ha mono lufuwau (Sng 109:8) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Feito yagunu Wenabate Yesu ya fuliguti hofa sinoibo hala ya lo oloto molanaibo we ma lemo minonigu yauti Yesu lemogi nebo hamena muki yalo maina moni-moni aibo we ma li oloto molokelo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Wewa li oloto pinubo ya Yonikafo noku i beti nedo yaloti uto Yesu lemodoka ilimito hamenalo okulumau yoibo ya wa edo hulonibo wemoli yaumati we ma li oloto molokelo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Feto lobito, we loiti ya ma huliya Yosefe huliya loiti ma Basabasi ido ma Yasitusi, ido we ma huliya Matiyasi ya li oloto piyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ido mukisi Goti feto lomuwabo, Wenabao, wenina muki lute-hateu wa-wa anibo we heimokafo Yudasi ononala fulitoto eimola hanulalo uto u hopa wiboma nenako, yagunu we loiti yauti mako ma weuga fi edanibo we ya ebala linaibo wewa lilibiyo, loti lomu minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Feto lomutiti nuba minabo ya noka hedoti Matiyasi huliya ya oloto piti, aposolo minanaiye, loti lato aposolo leweni (11) minagu ya keloti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ena foli fele hamena ya huliya Pentikosi hamenala aibo, eba mako nedo yalo holi hikitabo wenina muki nuba minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nuba minato, haita nola ma okulumauti asi naba-naba fu-fu libo nola yaidana oto libo ya numugu yau amedoti minabo muki ya holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Holiyato, idafa ma so huluma yaidana oto oloto pito idafawa ya poni-poni loto wenina numugu minabo muki ya utinalo lumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Utinalo lumito, ido muki ya Weuna Fele yakafo mino betito lutina-hatinau faitoto, lowa-lawa ha mona-mona lanae, loto auba bito ya ha mona-mona lomo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ido aya hamenalo Yuda wenina Goti holiya holiyabo ya mikau-mikau Yelusalemu yati numudoka loti yalo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aya weninawa yasi ha labowa ya holiti yagunu nuba minabo muki yasi weninawa eimotina hatina yama loti lato holiyanako, yagunu moda elegi i minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Elegi minoti hatina loiti-loiti kiti loga o betiyabo, Ha lo minabo we muki ya Galili wenina minafe? Olo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ya igaidana oti leimote hate ona ya wetinauti labo ya otefo metefogi lolomabo yaidana oto holiyone? ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ido leimo muki minonibo ya Patia wenina, ido Midia wenina, ido Elamu wenina, ido wenina ma Mesopotemiakati, ido Yudiakati, ido Kapadosiakati, ido Pontusikati, ido Esiakati, ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ido Filigiakati, ido Pamufiliakati, ido Isipikati, ido Libia ebaukati Sailini selo nebo wenina, ido Lomu wenina loto meu minonibo yagi ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","malekama Yuda wenina ona minone. Ido malekama wenina eito-eito loto Yuda wenina monatina liyonibo yagi, ido leimo ya Kiliti wenina, ido Alebia wenina feito ya minoba, ido Gotikafo auba ibo idafa dowa lifefe lito emo yagunu leimote hatelokati lato moda holifefe loto holi minone, loti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Feto loti elegiti hatina ligi-ligi kiti eimotina loga o betiyabo, Idafawa holiyonibo ya monawa ya nena idafa ne? loti loga-miga ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Feti loga-miga ato, wenina malekamasi feto labo, No waini muki ya noti hatina-manadina u hopa wito minae, loti hiya o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ena Pitakafo Yesu onodo we leweni (11) yagi minadoti sinoito, wenina nuba naba minabo ha naba loto feto lobibo, Weninane-motao, Yuda wenina minabo ido hemotina Yelusalemu hu unabo wenina muki hawa holiyabo monawa fokito lobinogolowe. Ha lobinobo ya hatina kiti holifefe loti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hemotina ya wemoliwa ya no waini noti hatina-manadina u hopa uwae, loti holiyafa, ido feito minámiye. E'e, onesa me ya ya leda (9) naini kiloku yaidana otoko nenako. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Idafawa yagunu polofeti Yowelikafo feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Gotikafo feto libo, Hamena naba alili anaibo hamenalo Weune ya wenina muki mona-mona ya biyoto, hipatina-mota ido olutina-mota hane lo oloto molanigilae. Ido hemotina we hofawetina ya wamo yaidana oti ya wanigilae. Ido we kilofo-akilofo yagi wamo hula wanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ido aya hamenalo houba-nabane we wena Weune ya biyoto hane ya lo oloto molanigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ido okuluma akawa yagi mebe-maba ma idipito ido mikalo melo yagi nemo aubane idipiyobo idafa ya lunufena, ido sofena, sokila nabafena ya itibinogolowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Itibinobo ya fo ladámoto ido igana ya li lunu yaidana luta lanogolaiye. Feito lanaido yalo ya Wenaba hamenala naba ido lamenala ya oloto pinaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ido Wenaba huliyalo sula finabo wenina muki ya li nomudina wanaibo ne, loto ha mono lufuwau (Jol 2:28-32) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ido hemotina Isilaeli wenina hawa holi minalo. Nasalete numudoti aibo we Yesu ya Goti aubala lilibibo idafa mona-mona yagi, ido mebe-maba yagi, aubala nabagi li oloto pi bibo ya Gotikafo ilifi molobo we ne, loti holinigilae, loto feito emokafo mino edaito, idafawa ya nomudinalo li oloto pi bito, heimotina idafawa ya moda holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aidena yoimalokati Gotikafo wewa yama ya hemotina adinalo molanowe, loto holito hala dowa kito, hemotinagi ido ha holiti holámoti abo we yagi analo-hinalo liti yá yofolo hofoti fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hofoti fuliyafa, ido fulibo mona yakafo nala i edanaibo ya ogofuwáminako, Gotikafo fulito ogofu naba-naba holigu yauti wina edoto fuliguti li sinoi edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ido Defitikafo emogunu feto libo, Wenaba ya hamena-hamena nomunelo neto ya wa-wa edo o minowe. Ido ane onaleka nebo nenako, idafa-adafa makafo li yoima o nedámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ido weune ya fuliyabo ebau yau fulo edoto waito edámoto, nemo Fele We minobo une aubane ya lilitámanaiye, loto laniboma nenako, yagunu lune-haneu dowa holiyowe. Yagunu nemo ya wenemamo ake ito ha loto, mikaleka unegi minobo hamenalo ya hemo fe nedananibo holito hiyabaka oto minomo yonowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ido hofawa minomo yowabo hanu nilibito nemo mino nedageto, ake naba-naba inogolowe, loto ha mono lufuwau (Sng 16:8-11) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mono weninane-motao, auba ito lobiyowe. Awatefo-holofate Defiti ya fulitaito, hale li edato, ido hale li edabo ebala ya meu selo ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ido emo ya polofeti minoto feto loto holibo, Gotikafo ona ne, loto hemo yufa fiyanibo yauti we ma li sinoi edageto, hemo ekeni folomoka yalo minoto ya wenina hiyaba o betinogolaiye, loto auba ito lo molo muibo ne, loto holi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Feito idafawa oloto pinaibo ya holinako, yagunu Metefokafo ilifi molaibo we Kilisto ya fulinaiguti li sinoi edoto ya fuliyabo ebau fulo edámito, hono ula ya haleku yau lilitámanaibo ne, loto monawa ya lo oloto bima ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ido Gotikafo Yesu fuliguti hofa li sinoi edaito, ido leimo muki ya nomude yagunu moda wa edofefe lonibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ido Goti ya Yesu huliya li faka loto, ane onaleka huliyagi we minanaiye, loto ido Weuna Fele humunowe, loto lo molo muiboma ya Melafodoka yati lito ido idafawa eletifo hemotina wati holiyabo ya oloto pi ledaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Oloto pi ledaito, Defiti eimola ula ya okulumau yowámibo nefa, ido feto libo, Wenaba yakafo Wenabane ya lomuibo, Ane onaleka amedoto hiyaba oto minageto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya uwokafo-mota fulo higa feumau betinogolowe, loto libo ne, loto ha mono lufuwau (Sng 110:1) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yagunu hemotina Isilaeli wenina muki ya holifefe loti holilo. Hemotina yasi we yá yofolo hofo fuliyabo wewa Yesu ya Goti yakafo Wenaba, ido ilifi molobo we Kilisto ya ne, loto buli edaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ena hawa lobibo ya holiti lutina-hatinau hena naba-naba holiti, Pitagi aposolo malekamagi feto loti loga o betiyabo, Mono weninate-motao, neidafa feyanune? loti loga ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Loga o betiyato, Pitakafo liwila oto lobibo, Heimotina muki ya lutina-hatina li elepa iti Yesu Kilisto huliyalo noku inabo ya Gotikafo lifimatina hilili o betito, Weuna Fele biyageto linigilae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yagunu hemotina ido olufotinagi ido faiga minabo wenina muki Wenaba Gotitekafo sutina finaibo wenina muki ya Weuna Fele binowe, loto lo molo betiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Feto lobito, ha malekama muki fuka ha auba ito feto lobibo, Hemotina hamena onesa me ya minabo wenina nosámabo minagu lifimatina linabo yaidana oti litanune, loti fulo betilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Feto lobito, ido hamena yalo wenina abi loti tili tauseni (3,000) yasi Pita ha libo ya holi hikito muwato noku i betiyabo ya holi hikitabo wenina onu iyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ena holifefe lanune, loti aposolo api itibiyabo ha auba iti holi minabo mono wenina malekama adinalo li faka lo beti minoti, wetina-idafafena ya maina noti Goti lomu-lomu o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Feto fe minato, aposolo yasi Goti aubala idipibo idafa mona-mona ido mebe-maba idipi-idipi abo idafawa ya wenina muki wati elegi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ido holi hikitabo wenina lutina-hatina mako moloti, idafa-adafatina li mako oti li minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yagunu mikatina ido huwamenatina magi hefanalo fuloti hefana liti wenina idafagunu wita abo wenina hona moloti biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hona moloti biti, lutina-hatina mako molabo ya hamena-hamena fele huliyagi numuna naba hilalau yau maina uti nuba o-o minae. Nuba oti minoti, numunatinau-numunatinau wetina-idafa ido mono hobina ya hona moloti no-no minoti, lutinau ake iti hatinau mako moloti, ");
INSERT INTO snp_lambau_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Goti ebola lomuwato, wenina muki ya wa beti dowa moloti wa beti minae. Feti minato, hamena-hamena ya Wenabakafo nuba minagu yau li nomudina waibo wenina ya li homi i betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Hamena ma ya lunaga tili kiloku (3) yaidana oto Goti lomunabo hamena selo aito ya Pitate Yonite fele huliyagi numuna nabau yowaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yoti yalo fele numuna hanu huliya Omonala ne, labo hanu welalo yalo we ma olafo houmalauti hina nosámibo ma nebo ya wa edaiye. Wa edaibo wewa ya hamena-hamena hounalafo-mota yasi mofuti ito loti yalo fulo edato ya wenina fele huliyagi numuna nabau yoti lumuti abo ya hefanagunu wako lo beti-beti aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wewa yakafo Pitate Yonite fele huliyagi numuna nabau yonigili aibo ya wa betitoto, Idafa ma numiliyo, loto wako lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wako lo betito, Pitate Yonite wewa wa edofefe loti wa edoti ya Pitakafo, Lemo ya wa ledo, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ena wewa, Idafa ma numunigilaiye, loto wenu wa betito ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pitakafo feto lomuibo, Hefana ma wa námofa, ido idafa ma wa nobo ya moda humunogolowe. Yesu Kilisto Nasalete numudoti aibo we huliyalo ya hemo mikaloti sinoito hanu moniyo, loto lomuto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ana onaleka lito li faka lo edaiye. Feto fe edaito ya ayalomati hina moda aubafofo lito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","sato moloto hinagunu sinoito hanu monimo uto, fele huliyagi numuna nabau ya we loiti yagi maina yoti uti wewa yakafo satomo akaisa-akaisa oto uto Goti ebola liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Feito hanu monito Goti ebola libo ya wenina muki wa edoti ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","wa edofefe lotiti, Aiyo, wewa ya fele huliyagi numuna nabalo hanu huliya Omonala ne, labo hanu welalo me ya ya hefana-huwamenagunu wako lo ledo-ledo aima ya nefe? loti u dowa libo wati ya elegiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ido wewa yakafo Pitate Yonite utinalo lito nedo ya wenina muki oluloti emotina minado fele huliyagi numuna naba li hona-hona oti holo-hala numuna yaidana oti huwabo anawaleka ya huliya Solomoni Hilalau, yaleka lo fedoti elegiti li nuba oti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Feto feyato, Pitakafo wa betito feto loto lobibo, Isilaeli weninao, hemotina neidafaito elegiti i minae? Wenu wa ledabo ya leimo aubate yakafofe, ido leimo Goti monalalo meyalo molanubo ononate yakafofe wewa ya li hanu moni edaiye, loti hatina kiyafe? Olo? ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abalahamu, Aisaka, Yekopu Gotitina, leimote awatefo-mota holofate Gotitina yakafo moda we naba ne, loti holinigilae, loto houba-nabala we Yesu li naba o edoto huliya lamenala muiye. Feto feyaifa, hemotina ya hofato fulinaiye, loti Yesu ya uwolafo-mota adinalo molabo ne. Feto molafa, ido homu ya Pailatikafo nalauti wina fulo edanowe, loto lima ya hemotina, E'e, loti mesafa i muwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mesafa i muti, fele nebo we monala fefe libo we ya metina muti, wenina hofo beti fulibo we wina fulo edanane, loti lomuwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hemotina hofawa minomo yonabo mona yawala ya liti hofo fuliyafa, ido Gotikafo fuliguti li sinoi edaito, nomudegunu wa edoibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ido wewa me ya wa edoti holiti o minabo ya Yesu huliyalo holi hikito muwonibo mona yakafo li aubafofo lo edaibo ne. Feito Yesu huliya yakafo ido Yesu holi hikito muwonibo mona emodokati aibo yakafo wewa hina nosámibo moda li faka lo edaito ya hemotina muki wa minabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ena mono weninane-motao, hemotina ido hiyabatina we Yesu feto fe edabo monawa ya holifefe ladámabo ya moda holowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Feto fe edafa, aidena Gotikafo ilifi molaibo we Kilisto ya hena holinogolaiye, loto libo ha polofeti muki wetinalo molaito halawama onesa hemotina mona molado ya halawama feito iye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yagunu lifimate hilili o ledoto, Wenabakafo weudeu li aila i ledanaibo hamena ya lemodoka lilifinaiye, loti lutina-hatina elepa iti Gotidoka liwila oti alo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Liwila oti ato, Yesu ya ilifi molaibo we Kilisto nebo ya aidena akaimati lemogunu moda li wa molo edotaibo ya minonido ilifi molanogolaiye, loti lutina-hatina elepa iyalo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aliga ilifi molanogolaifa, onesa okulumau hiyaba minageto, polofeti fele we wetinalo lo molo lumibo ha ya molaito, ha labo ya idafa-adafa muki hofawa lifefe lanaibo hamena oloto piyageto yalo Yesu liwila oto anogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yagunu Mosese yakafo feto libo, Wenaba Gotitina yakafo hemotina weninatina minaguti polofeti ma nebo yaidana oto li oloto pi bito idipi molanaiye. Li oloto pi binaibo wewa yakafo lobibo hala muki ya holiti meyalo molalo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ido makafo hala holi holiyámanaibo ya Goti weninala yauti moda u hopa unogolaiye, loto ha mono lufuwau (Lo 18:15, 18-19) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Feti polofeti muki Samuweli hamenalalo akaimati ha lomo yowabo yama ya onesa me ya idafawa aibo yagunu ha lo-lo abo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ido Gotikafo polofeti idafa weuna fi betibo ido awatinafo holofatina-mota emogi li hutifina betibo ha ya hemotina weuna fi betibo ya moda linigilae. Ido Gotikafo Abalahamu feto lomuibo, Nemo ya yufa fiyanibo we yakafo mikau-mikau wenina muki li dowa lo betinowe, loto ha mono lufuwau (Stt 22:18) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Feto loto lomuibo ya hemotina nosámibo monatina ya li fulitoti lutina-hatina li elepa iyato li dowa lo betinowe, loto houba-nabala we ya li oloto pito homu heimotinaloka idipi molaiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitate Yonite wenina ha lobi minaito, Goti sokila hi muwabo wegi, ido fele huliyagi numuna naba himiwe wenabatinagi, ido Sadusi weninagi ya we loiti minaido ya ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Minaido loti aposolo ya wenina api itibiti feto lobiyabo, Yesu fuliguti sinoinako, wenina ya ayaidana oto fulinuguti sinoinune, loti labo ha ya holiyabo yagunu sebatina hala-kala naba lito, loti ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pitate Yonite adinalo liyafa, lunaga molainako, yagunu leda sigiya lo betinune, loti nala numugu yau limo fulo betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Limo fulo betiyafa, ido ha mono laibo holiyabo wenina ya muki holi hikito muti, ido Yesu weninalagi keloti holi hikitabo wenina abi loti faifu tauseni (5,000) yaidana minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ido leda ya Yuda wenina wenabatinagi, ido wenina hiyabatina wegi, ido lo molaibo ha api itibiyabo wegi ya Yelusalemu numudo nuba ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nuba minagu ya Goti sokila hi muwabo we wenabatina Anasile, ido weninala Kaiyafasile, Yonile, Alekisadale, ido weninala magi maina nuba minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nuba minoti we loiti ya li nuba minagu idipiti yowato, nomudinalo ya minaito, feto loti loga o betiyabo, Hema aubalalofe, ido huliyalofe ononawa me ya ya liyaiye? loti loga o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Loga o betiyato, Weuna Felekafo Pita lula-halau faitoto mino edaito feto loto lobibo, Wenabate ido hiyabate weninao, ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lemo we hina nosámibo li dowa lo edoibo yagunu igaidana oti wewa ya li faka lo edaiye? loti loga o ledabo yagunu lo oloto molanowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ena lo oloto molanobo ya hemotinagi ido Isilaeli wenina muki yagi holifefe loti holilo. Gotikafo ilifi molaibo we Yesu Kilisto, Nasalete numudoti we ya hemotina yá yofolo hofato fulibo ya Gotikafo fuliguti li sinoi edaibo we huliyalo ya wewa nomudinalo sinoi nebo ya li faka lo edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ido wewa yagunu feto libo, Hefana ya numuna huwabo wenina wa aifa idafaidana itabo nefa, ido aya hefanawa yama moda numuna lagi hola fibo ne, loto ha mono lufuwau (Sng 118:22) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu yakafoko li nomude wanaibo ne. Feito nenako, wenina mikau-mikau minagu yauti makafo huliyalo li nomude wanubo we ma minámiye, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ena Pitate Yonite holi biyámito nuba minabo wenina yasi wa betiyabo ya we loiti ya aifa wenina minoti, lufuwa api itibiyabo numugu hamena fouma efomako uwaiboma ne, loti holiti yagunu elegiti, ena emotina ya Yesugi maina mino-mino ama ne, loti ya holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Feto holi minato, we li faka lo edaibo we ya maina sinoi minaboma ya wa edabo yagunu ha lanabo ya ma minámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ha minámito, kanisole mauniguti feka uti minaliyo, lato, lumuti minaito, eimotina ha lo humomo fiti ya feto labo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Leimote we loiti ya neidafa fe betinune? Wewa loiti yasi Metefo aubala lilibibo idafa naba ya li oloto pito, ya Yelusalemu numudo minabo wenina muki ya holi hulotae. Ido idafawa oloto piyámiye, loto lanubo ya ogofuwámone. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ido hawa ya numudo-namado upatoto wenina holi hulotanae, loto leimote ya wewa huliyalo ya wenina ma hofa lobiyámilo, loto aubafofo loto lo fuko betinune, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Feto lotiti we loitima hofa sutina fiyato aito, feto lobiyabo, Yesu huliyalo wenina hofa lobiti api itibiyámilo, loti aubafofo loti lo fuko betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lo fuko betiyafa, Pitate Yonite yasi ha liwila oti feto lobiyaibo, Lemo hatina yalo hololoto Goti hala fulitanubo ya Goti holinaibo dowa lanaife? Hawa ya heimotina hona moloti holilo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yagunu lemo idafawa watoto holito fe minoibo idafa ya lo oloto molámanoibo ya ogofuwámoiye. E'e, lo oloto molomo yonogoloiye, loti laiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Feto loti laito, wenina muki idafawa feto feyabo ya holiti Goti ebola lomuti minanako, hiyaba we yasi we loitidoka idafa ma fe betiyámabo aifa holi binaibo ha makafo lalafu oti nalauti wina oti itibi fulato uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ido Goti aubala idipibo idafakafo we hina nosámibo li dowa lo edaibo wewa ya melegela foti (40) ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ena Pitate Yonite nalauti wina betiyato, mono weninatina minado uti Goti sokila hi muwabo wenabatina ido wenina hiyabatina we ha lobiyabo ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ha lobibo ya holititi lutina li mako moloti, Goti feto loti lomuwabo, Wenaba nabao, mika okuluma ho no ido idafa-adafa mona-mona idafa nebo ya li oloto piyane. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ido hemo Weuga Fele yakafo houba-nabaka we awatefo Defiti welalo ha molaito feto libo, Eito feka wenina ya neidafaito sebatina hala-kala naba lo minae? Ido weninawa yasi nedafaito Wenaba ya hudala hi minae? Feto feyafa, ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ido mikalo hiyaba we wehudi yagi ya minoti, wenina hiyabatina we Wenaba Goti yagi ido ilifi molaibo wegi lowa fi binune, loti wenina naba ya nuba oti ki minae, loto ha mono lufuwau (Sng 2:1-2) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ona lito, ido aya numuna meyalo ya Heloti ido Pontiusi Pailati yagi eito feka wenina ido Isilaeli wenina yagi ya nuba oti fele houba-nabaka we Hipaka Yesu ya ilifi molanibo we lowa fi munune, loti hudala hiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Feti hudala hiyabo ya feto-feto feyanae, loto hemo heimoka aubakamamo ido holitoto homu lotanibo yaloma iye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Feto feyafa, hemo Wenabate onesa uwotefo-mota ha magunu lalafu oti labo yagunu lemo houba-naba o hedonibo ya aubakama lomageto, weninawa holitina holiyámoto, haka ya wenina muki lobimo yonune. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Feito aubaka ya lilibito, fele houba-nabaka we Hipaka Yesu huliyalo ya wenina idafa i hiliyabo ya li faka lo betito aubaka lilibiyanibo idafa li oloto pimo uwo, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Feto loti lomu itato, numuna mau minabo numuna ya mima naba-naba aito, Weuna Felekafo loto lutina-hatinau mino faitito, holitina holiyámoti Goti hala ya aubafofo loti lobiti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ido holi hikitabo wenina muki lutina-hatina mako moloti, ido we ma idafala wa naibo yama ya neimoko idafane ne, loto ladámibo ne. E'e, muki wenina yasi idafatina wa nabo idafa muki ya hona molabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ido aposolo yasi Wenaba Yesu fuliguti hofa sinoibo hala ya aubafofo loti lobimo uwae. Ido aifa li dowa lo ledaibo mona naba ya mino betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ido aya wenina minagu yau ya idafagunu moni wita abo wenina ma minámabo ne. Ido hamena maleka idafa wa nabo wenina ya numunatina-ebatina idafa-adafatina nebo yama hefanalo fuloti meina liti ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposolodoka ya biyato, emotina yasi idafa wa námabo wenina idafagunu moni wita abo wenina ya hona moloti biyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Feto feyato, ya we ma nebo huliya Yosefe ya aposolo yasi huliya Banabasi ne, loti molabo huliyawa mona ya li aila i betibo we ne, loti molabo wewa ya Lifai yufa figu yauti ho nokafo li hona aibo eba huliya Saipulusi yauti oloto pibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wewa yakafo mikala ma hefanalo fulo hulototo meina ya lito aposolo bibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ena we ma nebo huliya Ananaiyasi olonafo Safailate maina mikatina ma yagi hefanalo fuloti meina liyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Meina liti feto feyanune, lito olonafokafo, O, lito meinawama liti hona moloti, filigama neimo idafane ne, loto molototo filigako lito uto ya aposolo sugi ha loto biye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bito, Pitakafo feto loto loga o edaibo, Ananaiyasi, hemo neidafaito Satanikafo lukau ya mino hedaito, Weuna Fele ha sugi lomuto mikaka meinala malekama li faluku ane? ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Homu mikawa hefanalo fulámanibo hamenalo ya heimo mikaka nebo nefe? Ido aliga ya meina fiyabo hefanawa ya lito heimoka yawala minoto yaida-meida anowe, loto feto feyabe? Ya igaidana oto luka-hakau holito li hopaito feto feyane? Feto feyanibo ya wenina ma ha sugi lobiyámane. E'e, Goti ha sugi lomuwane, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Feto lomuito, Ananaiyasi hawa holito lumu fou loto moda fuliye. Fulito, wenina muki hawa holiti holi naba-naba biye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ido wenina hofawe yasi hono ula ya lafo-lafogunu wase iti uti hale liti molo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ena aliga tili (3) auwa yaidana oto li fulito olonafo hawa ya holiyámoto loto numugu yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Numugu yoito, Pitakafo loga o edoto lomuibo, Mikatina meinala liyaibo ya feito nefe? lito, emokafo, Ona lane, meinala feito ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ido Pitakafo feto lomuibo, Hemotina lutina-hatina mako moloti Wenaba Weuna ya hepa molo edanune, loti ya igaidana oti holiyaiye? Holi mino. Wagafo hale liti molo edabo wenina numuna hanu welalo minabo ya hemogi hilimiti uti hale liti molo hedanigilae, lito ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","wenawama ayalo hinalo lumu fou loto moda fulito, wenina hofawe yasi numugu yoti hono ula liti uti wanafo hale liti molo edagu ayaleka ya molo edae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ido monolo li nuba abo wenina muki ido muki hawa holiyabo ya holi naba biye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo yasi mebe-maba yagi, ido Goti aubala idipi-idipi aibo idafa mona-mona ya wenina minagu ya li oloto piyae. Feto feyato, ido holi hikitabo wenina muki ya lutina-hatina mako moloti fele huliyagi numuna naba li hona-hona oti numuna holo-hala yaidana oti huwabo anawaleka ya huliya Solomoni Hilala ne, loti labo yau li nuba o minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuba minato, wenina yasi dowa wa betiyafa, holi holiyanako, yagunu ya emotinagi nuba ámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Feito nefa, we wena abi loti mulalo-mulalo oti Wenaba holi hikito muwabo ya emotinadoka homi itiko minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Feito weninatina idafa i hiliyabo ya yaofalo moloti, ido ma ya agakalo moloti idipiti loti hunu wiliti yalo fulo betiti feto holiyabo, Pita uto loto anaibo hamamuna yakafo idafa i hiliyabo wenina malekama ya utinalo lito li faka lo betinaiye, loti hanudo fulo beti-beti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Feto fe-fe ato, ido numuna eba selo Yelusalemu numudo-namadoti wenina muki nuba abo ya idafa i hiliyabo weninatinagi, ido Satani himiwela lutina-hatinau mino betiti li nosámibo o betibo weninatinagi idipiti abo wenina muki ya moda li faka lo hulae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ena sokila hi muwabo we hiyabatina we wenaba yagi keloti minabo we muki Sadusi wenina minagu minabo ya idafawa yagunu holiti wauwa liti ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aposolo adinalo-hidinalo liti nala numugu yau limo fulo betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Fulo betiyato, lubuka Wenaba enisolela yakafo nala numuna hanu si betito feka idipito uto ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","feto lobibo, Hemotina uti fele huliyagi numuna nabau yoti wenina muki minabo ya nomudina hofawa minanabo ha mona muki ya lobilo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lobibo ha holiti meyalo moloti leda ho lido ya fele huliyagi numuna naba hilalau yoti mono ha api itibi minae. Ido sokila hi muwabo we hiyabatina we wenaba yagi ege molabo wenina yagi loti Sanihetilini kanisole ya Isilaeli wenina hiyabatina wenaba minabo muki li nuba o betiti, ya himiwe nala numuguti aposolo ya idipiti alo, loti idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Idipi molato, himiwe yasi uti nala numugu ya moni wita afa, minámato, ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","liwila oti loti feto lobiyabo, Lemo uto wa onibo ya nala numuna hanu moda aubafofo loti hu hiki loitato, ido hiyaba we yagi hanudo hiyaba oti minato, hanu sito yoto wita oba, minámae, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lobiyato, ya sokila hi muwabo we wenabatina yasi ido fele huliyagi numuna naba himiwe hiyabatina we yasi hawa ya holiti idafawa oloto pibo yagunu hatina ligi-ligi kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Feto fe minato, we ma minado loto feto lobibo, Walo. Nala numugu fulo betiyabo weninama ya fele huliyagi numuna nabau ya wenina mono ha api itibi minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lobito, holiti himiwe hiyabatina wegi ido himiwegi uti aposolo idipiti afa, wenina yasi hefana fuloti hofo ledotanae, loti holi bito, holoti idipiti ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Idipiti loti sokila hi muwabo hiyabatina we wenaba yakafo loga o betinaiye, loti kanisole wenina nomudinalo ya li sinoi betiyato, feto loto loga o betibo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Lemo ya, Wewa welalo ya api itibiyámilo, loto lo fuko biyonima nefa, holámoti hemotina ha ya Yelusalemu numudo hofa lato, wenina muki hatina holi hulato, ido hemotina yagi wewa ya lemote hofo fuliyae, lanune, loti lifima lemodoka molanune, loti auba iti holi minae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Feto lobiyato, Pitagi ido aposolo yagi ha liwila oti lobiyabo, Wenina hatina ya holi fulitoto Goti hala yako meyalo molone. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ido awatefo-mota Gotitina yakafo Yesu, hemotina yá yofolo hofo fuliyabo we, ya fuliguti li sinoi edoto ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","eimola ana onaleka moloto ya lito yoto hiyabatina we wenaba ido li nomudina wanaibo we ne, loto molo ne. Molo nebo ya Isilaeli wenina lutina-hatina li elepa iyato lifimate hilili o betinaiye, loto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Feto lo molaito, ido lemo idafawa watoto lo oloto molomo uwogeto ido Weuna Fele ya Gotikafo halalo hololabo wenina bibo we yagi ayaidana oto lo oloto pimo wiye, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ena hawa labo ya kanisole wenina holititi ya sebatina hala-kala naba-naba lito, hofo beti fulinune, loti holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Feto loti holiyafa, Falisi we ma huliya Gamaliyeli, lo molaibo ha api itibibo we, wenina muki huliya li faka labo wewakafo kanisole hulumanigu sinoito himiwe feto lobibo, Aposolo feka idipiti uwato, hamena fouma feka minanae, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Feto lobito, feka idipiti uwato, emokafo feto libo, Hemotina Isilaeli wenina, wemoliwa idafa ma ya fe betinune, loti holinabo ya holifefe loti hatina kiyalo. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Homu we ma nebo huliya Teudasi yakafo, Nemo huline nebo we minowe, loto lito wenina abi loti fo hadeti (400) yaidana oti ege molama nefa, uwolafo-mota yasi hofo fuliyato, ege molabo wenina muki ya upatoti uwato, ononala ya u aifa idafa buliye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ena aliga gamanikafo wenina hulitina lufuwa iyabo hamenalo ya Galili we ma huliya Yudasi oloto pibo yakafo wenina ma ile-fali sebatinau fito, Gamani weninagi fina finune, lito ege uwato hofo fuliyato ege molabo weninala muki ya upatae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Feto upatato, ido onesa idafa-adafawa fedibo yagunu ha lobiyowe. Hemotina wemoliwa ya li hopa betiyámoti waito betilo. Nalauti wina oto fulo betilo. Ido ononawa mona ya aifa weninalokati minagetoma, ononawa ya u hopa unogolaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nefa, ononawa mona ya Goti eimoladoka minagetoma ya Gotigi fina fi minanako, Wemoliwa ononatina ya itanune, loti anafa, ogofuwámanabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliyeli feto lobito, ha libo dowa loti holiti aposolo sutina fiyato, liwila oti ato, li himiwe biyato, osogunu hofo betiyae. Hofo betiyato, auba iti lo fuko biyabo, Yesu welaloti ya hofa wenina api itibiyámilo, loti lobiti nalauti wina fulo betiyato, ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kanisole nuba minaguti lumuti feto loto holibo, Gotikafo dowa loto wa ledoto Yesu yagunu hena naba ogofuto holiyoiye, loto holaiye, loti holaibo nenako, yagunu loitiwa lutina-hatinau ake naba-naba iyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ena hamena-hamena fele huliyagi numuna nabau, ido wenina numunatinau Yesu ya Gotikafo ilifi molaibo we Kilisto ya ne, loti hala ukuwa dowa ya api itibiti lo oloto molomo uti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hamena yalo holi hikitabo wenina abi loti Yesu ege molabo wenina onu-onu imo uwato, ido minagu yauti Giliki ha labo wenina yasi moliya ha feto loti labo, Yuda ha labo yasi wenina hamena-hamena idafa-adafa wa námabo wenina idafa hona moloti bi-bi o minado ya lemo wenipa-hiyonate ya adinalo li faka ladámo-ladámo ae, loti moliya ha lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Feto lobiyato, Yesu ononala we tuwelu (12) yasi ege molabo wenina muki li nuba o betiti feto loti lobiyabo, Leimo ya Goti hala api itibiyonibo ononawa fulitotoma wetina idafa hona molabo onona lito moloto moni minanubo ya fefe ladámanogolaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yagunu mono weninate-motao, heimotina minagu yauti wemoli seweni (7) Weunakafo lutinau mino faitibo we, ha manadinau nebo we, dowa loti wa betinabo ya wita oti li oloto pi betiyato ononawa ya adinalo moloto ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ido lemo ya Goti lomu-lomu onibo onona ido hala ukuwa lo oloto molanubo onona auba ito li-li minanogolone, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Feto lobiyato, mau minabo wenina muki ya dowa loti holiti Sitifeni holi hikila naba neto Weuna Fele lula-halau faitito mino edaibo we ya haka oti, ido Filipi, Polokolusi, Nikanoli, Timoni, Pamenasi, Nikolasi Antiyoku numudoti aibo we Yuda mono weninadoka onu ibo we yagi haka o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wemoliwa haka o betiyabo ya aposolo minado idipiti ato, Goti lomutiti adinagunu wemoli manadinalo molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Feito Goti hala ukuwa ya upatoto monimo wito Yelusalemu numudo holi hikitabo wenina muki onu-onu imo uwato, ido sokila hi muwabo we minaguti yauti ma abi loti hala ukuwa dowa holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ena Gotikafo Sitifeni ya aifa li dowa lo ledaibo mino o edoto auba muito, wenina minagu ya mebe-mabagi Goti aubala itibibo idafagi mona-mona li oloto pifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","wenina malekamasi Sitifeni moliya fi muwae. Weninawa ya Yuda wenina mono numunatina ma huliya ya wina ledabo we mono numunatina ne, loti labo minaguti masi Yuda wenina minabo Sailini mikaloti abo, ido ma Alekisadilia mikaloti abo, ido ma Silisia mikaloti abo, ido ma Esia mikaloti abo wenina yasi Sitifeni moliya fi mu minafa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Weuna yakafo Sitifeni welalo ha molaito, ha lido fulo edanabo ya ogofuwámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ogofuwámabo nenako, momona oti wenina ma li oloto pi betiti hatina liti feto loti lobiyabo, Sitifeni yakafo Mosesete ido Gotite hamadina hito holiyonibo ne, loti lobilo, loti lobiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Feti ha labo yakafo wenina aifa wenina ido Yuda mono hiyabatina we ido ha mono api itibiyabo we sebatinau fali witunu iyato Sitifeni nedo loti analo-hinalo liti kanisole nuba minagu ilimiti uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ilimiti uti ha sugi lo edanabo wenina ya idipiti ato, emotina yasi feto lobiyabo, Wewa ya hamena-hamena fele eba me ya ido lo molaibo ha ya hamadina himo wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yagunu holiyonibo ya Yesu Nasalete numudoti aibo we yakafo fele huliyagi numuna naba ya luko fulitoto ido monate Mosesekafo lumibo ya li elepa i molanogolaiye, loto libo hawa holiyonima ne, loti lae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Feto loti lato, Sanihetilini kanisole nuba minagu amedoti minabo wenina muki yasi Sitifenidoka wenu wa edabo hola-wela ya enisole hola-wela yaidana aito wa edabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ena sokila hi mu-mu abo we hiyabatina we wenabakafo Sitifeni loga o edoto lomuibo, Hawa lo hedabo ya ona nefe? loto lito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitifenikafo liwila oto loto lomuibo, Weninane, ido menefo-motao, ha lanogolobo ya holilo. Aidena awatefo holofate Abalahamu Mesopotemia mikalo nebo hamenalo Halani numudoka hu unámido ya lamena yawala Goti yakafo oloto pi muto ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","feto loto lomuibo, Mikaka ido weninaka fulo beti itoto mika ma hilibinabo ebaloka uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Feto lomuito, ha holito Kalidia mika fulitoto, Halani numudo uto yalo ne. Neto, melafo fulitaito Gotikafo ilifi molaito loto hemotina onesa minabo mikalo ya lo fediye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Feito u ilifi molaibo ya mika ma eimola yawala ona minanaiye, loto umámibo ne. E'e, mika hefola efo magi umámibo ne. Umámifa, ido aliga hemo ido yufa fiyaniguti wenina mika biyoto yawala ona minanae, loto lo molo muiye. Feto loto molaima nefa, aya hamenalo ya Abalahamu olufola minámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ena Gotikafo feto lomuibo, Yufa fiyanigu yauti weninaka ya wau wenina yaidana oti minoti, eito wenina mikatinau ya melege fo hadeti (400) yalo ya minoti houba-naba o betiti, hena naba-naba holimo unae. (Stt 15:13-14) ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Feto feyanabo nefa, ido houba-naba o betiyabo wenina ya nemokafo lifimatina liwila oto biyoto aliga yufa fiyaniguti weninaka ebawa ya fulitoti loti mika melo ya weudina-lutina-hatina numuti minanigilae, loto ha mono lufuwau (Kis 3:12) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Feto lomuto anela utinau fukanabo ya nemogi li hutifina betinowe, loto lo molo muiye. Ena aliga Abalahamu hipala Aisaka oloto pito, fo hamena eiti (8) uwageto Goti anela ulau fuko edaiye. Ido Aisaka hipala Yekopu oloto pibo, ido Yekopu hipala awatefo-mota tuwelu (12) ya oloto piyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ido awatefo-mota unatinafo Yosefe wauwa liti hefanagunu holiti wenina adinau biti meina liyato Isipi mikalo ilimiti uwae. Ilimiti uwafa, Gotikafo emodoka mino edoto ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hena holiguti lito ha mananau molo edaito nebo Isipi wenina hiyabatina we wehudi Felo yakafo Yosefe mona dowa molaibo ya wato Isipika wenina muki ido eimola numunala ebala hiyaba o betito minanaiye, loto huliyagi we naba li sinoi edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ena aliga Kenani mikau ido Isipi mikau muki ya inagunu hamena naba oloto pito numuna eba gedo fulitageto hena naba-naba holiti awatefo-mota inagunu fuliti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Minoti Yekopu ya Isipika suwa witi ya ne, loti labo ha ya holito awatefo-mota hana idipi fulaito yalo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Uti liwila oti loti hofa uwato, Yosefekafo yalafo-mota monala lo oloto molo bito, ido mikalo hiyabatina wehudi Felokafo Yosefe weninala wa betifefe liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Feito ya Yosefekafo alo, lotaito, melafo Yekopukele weninala muki we wena sewedi-faifu (75) ya idipito uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ena Yekopu Isipika uto minoto fulito, ido awatefo-mota ayaidana uti minoti aliga fuliyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Fuliyato, hono utina liti Sekemuka loti eba ma Abalahamukafo homu aidena Sekemu numudo Hamoli hipala-mota hono molanubo ne, loti labo eba meina figu yama hale li betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ena aidena Gotikafo Abalahamu lo molo edaibo haloma u ayalo inaibo hamena ya alili aido yalo weninate Isipika minabo ya hefola minámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Feti minomo uwato, Isipi hiyaba wehudi hofawa ma oloto pibo yakafo Yosefe wa edofefe ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wa edofefe ladámibo wewa yakafo weninate ya hotina ito li nosámibo o betito, awatefo-mota olufotina ya fulo feka betito fulinae, loto aubafofo liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hamena yalo ya Mosese oloto pito, hipawa Goti nomunalo ya nomuna omonala minoto igana tili (3) ya melafo numunalau yau li hiyaba o edomo uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","aliga numuna hila feka fulo edabo hamenalo Isipi hiyabatina we wehudi Felo oluwakafo ina fi libo ya eimola hedaibo yaidana oto hiyaba o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hiyaba o edaito, Isipi wenina ha manadinau nebo ha muki ya api ilibiyato, ya halo ido onodo ya u wenaba ya buli edae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ena melegela foti (40) ya li fuloto Isilaeli weninane uto wa betinowe, loto ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","uto wa edaibo ya Isipi we makafo Isilaeli we ma hofo neto wa edototo uto analo li faka loto Isipi we ya hofo fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hofo fulitoto feto loto holibo, Weninane yasi nemogunu holifefe loti Gotikafo weninane Isipi wenina hiyabatina we wehudi analoti wina betinowe, loto aubala numiye, holinigilae, loto hala kifa, feti hatina kiyámae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ido leda Isilaeli we loiti ma fina fi minaibo ya wa betito li filiga-filiga o betito, li hutifina betinowe, loto holito feto loto lobibo, Aiyo, hemotina yufa mako ma minainako, neidafaito fina fiyae? loto loga o betifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","hounalafo li nosámibo edaibo we yakafo Mosese itifu fulitoto lomuibo, Hemo ya hiyabate we ido lifima lumunanibo we hemakafo buli hedaibo ne? ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Asoma Isipi we hofo fuliyanima yamaidana oto nemo hofo nedanogolabe? Olo, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ya Mosesekafo ha ya holito Midiyani wenina mikatinau holi uto, yalo numuna hu unoto, wau we yaidana minoto, wena libo hipala loiti ya oloto piyaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ena melege foti (40) ya aya ebalo minototo ya uto hafali mikau Sinai obula selo nedo yalo hasuwala fibo yá ailau ya so lito so hulumau ya enisole ma oloto pi muiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Idafawa wa edaibo yagunu elegito wafefe lanowe, loto selo wito Wenabakafo feto loto lomuibo nola ya holito feto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nemo awakafo-mota Gotitina minoto ido Abalahamule, Aisakale, Yekopule Gotitina minowe, loto lito Mosese nola holito ya holi naba holito ula ololo loto wa faka ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wa faka ladámito, Wenabakafo feto loto lomuibo, Mika lala iyanibo yalo ya fele mika nenako, higalo iyanibo idafa li fuloto. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nemo ya weninane Isipi mikalo minabo ya li nosámibo o betiyato, moda wato, hufo abo ya holitoto wina betinowe, loto obo ne. Melo ano. Isipika liwila oto hilifi molanogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Aya wewa Mosese ya weninalasi mesafa i muti, hemo ya hiyabate we ido lifima lomanibo we hemakafo buli hedaibo ne? loti lo edabo wewa yama Goti eimolakafo we yamo hiyabatina we wenaba ido nalauti wina betinaibo we minanaiye, loto enisolela ilifito, yá hefolau oloto pi muto Goti hala lomuibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aya wewa yakafo Isipikati idipito wiye. Ido Isipi mikalogi ido Ho No Luta Libo yalogi ido mikau hafali melege foti (40) yalo minado ya Goti aubala idipibo idafa mona-mona li oloto pi betimo wibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aya wewa Mosese yakafo Isilaeli wenina feto loto lobibo, Gotikafo hemotina yufa fiyagu yauti polofeti ma nemo yaidana oto ya hemotinaloka idipi molanogolaiye, loto lobibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ido mikau hafali nuba oti minagu yau minoto, ido enisole ya Sinai obula yalo Mosese lomuibo yagi maina minoto, awatefo-holofate-motagi maina minoto, li hofawa minomo yonabo ha ya holitoto lo oloto molo betibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Feito nebo nefa, ido awatefo-holofate-mota yasi Mosese hala hololadámae. E'e, hala hololadámoti metina muti, Isipi mikalo elepa ito unune, loti lutinau ya feti holi minoti ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aloni feto lomuwabo, Hemo goti yaidana oti lifefe lageto u homu moloti lilimiti unune. Wewa Mosese Isipikati lilimito aibo we ya neidafa fe ne? Ya holiyámone, loti lomuwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Feto lomuwabo ya hamenalo bulumakau mofola fefelumala lifefe loti gotiwa ya idafa munune, loti idafa hofo hiti sokila hi muti eimotina adinagunu lifefe labo idafawa huliya ya li faka lo edanune, loti hoba-hobina naba hofo hi nae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Feiti feyafa, Gotikafo mesafa hito okulumaloka idafa-adafa ya weudina-lutina-hatina munae, loto liye. Feto loto libo yaidana oto polofeti lufuwa iyagu ya feto libo, Isilaeli weninao, hemotina hafali mikau melege foti (40) yalo minadoma ya bulumakaufena sipisipifena hofoti sokila hi numunune, loti hi numu-numu o minabo nefe? ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","E'e, feti minámoma ne. Hemotina gotitina ma huliya Moloki ya seli numuna hu edagu yau moloti mofuti ito moni-moni aboma ne. Ido gotitina ma huliya Lefani ya ofiya yaidana oto fefeluma aibo ya liti moni-moni aboma ne. Feto feyabo ya gotiwa ya weudina-lutina-hatina binune, loti ya lifefe labo nenako, yagunu uwotinafo-mota adinalo biyoto adinalo-hidinalo liti idipiti Babiloni mikau faiga yalo unigilae, loto ha mono lufuwau (Amo 5:25-27) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Awatefo-holofate-mota mikau hafali minabo hamenalo ya Gotikafo hemotinagi maina minomo uwowe, loto lobibo mebe-mabala fele seli mono numuna ya emotinagi maina ne. Aya numuna hunabo hamamuna Gotikafo Mosese feti hunae, loto ilibito, wa edaido yalo huwabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Feti huwabo, aliga ya awatefo-holofate-motagi, ido hiyabatina we Yosuwagi Gotikafo homu moloto eito feka wenina itifu fulo betibo mikatina ya liyado seli numunawa fele liyabo ya mofuti liti loti ebawalo lo fedato yalo ya minobo Defiti nebo hamenalalo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Minomo wito, Defiti Goti dowa loto wa edaibo we yakafo feto loto lomuibo, Yekopu Gotila minanibo ya numuna hu hedanofe? loto loga o edaifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Solomonikafo moda numuna ya hu edaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Feito nefa, Goti akaisa nebo we ya wenina adinagunu numuna huwabo yau minámanaibo ne. Yagunu polofetikafo feto loto libo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Wenabakafo feto loto libo, Okuluma ya ekeni folomone ya neto, ido mika ya hine lala i-i o minoboma ebane nenako, ido igaidana oti numuna hu nedanae? Ido unanobo ebane ya igau ne? ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nemo anegunu idafa-adafawa muki li oloto piyobo ne, loti holámafe? loto libo ne, loto ha mono lufuwau (Ais 66:1-2) ya nebo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Hemotina ha holiti holámoti abo wenina minabo ya lutina-hatinau ido hatina-manadinau ha mono holámabo wenina minae. Ido heimotina ya awatinafo-holofatina-mota yamaidana oti minabo hamena-hamena Weuna Fele ya hololadámabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ido polofeti yauti we ma ya awatinafo-mota yasi li hopa edámabo nefe? Mona fefe libo we ya oloto pinaiye, loti ha lo molabo we yagi hofo beti fuliyabo ne. Ido wewa ya hemotina ya uwolafo-mota adinalo moloti hofo fuliyabo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hemotina feto feyabo ya lo molaibo ha ya enisole Goti welauti biyato liti nefa, ido meyalo molámabo ne, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitifeni hawa lobibo ya holiti sebatina hala-kala naba lifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Weuna Fele lula-halau ya faitito okulumau wenu wa minoto waibo Goti lamenala naba yagi ido Yesu ya Goti ana onaleka sinoito nebo ya wa edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wa edoto feto loto lobibo, Moda okuluma godo neto We Hula ya Goti ana onaleka nebo ya wa edowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lobibo ha ya holiti adinagunu hatinau lotana iti ha naba-naba loti ya muki oluloti loti li lulau edoti, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","analo-hinalo liti yaloti numudo hila feka ika oti, liti uti hefanagunu hofomo uti, utinalo owo fana ya li fuloti, we hofawe ma huliya Solo ya hinalo molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Moloti ya Sitifeni hefanagunu hofo minato, ya feto libo, Wenaba Yesuwo, weune ya liyo, loto lomuto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ido hina obula fito ha naba feto lomuibo, Wenabao, lifimatina emotinaloka molámo, loto feto lo itoto ya fuliye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Solo yalo minoto Sitifeni hofo fuliyabo ya lula-hala dowa liye. Ido aya hamena yaloti Yelusalemuka monolo nuba o-o abo wenina ya hena naba-naba apito holiyato, muki ya heni betiyato, Yudia ido Samalia mikau-mikau upatoti uwato, aposolo yako Yelusalemu minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Minato, Goti monala molabo we masi ya Sitifeni hono ula liti uti hale lito molo edoti emogunu hufo nama naba ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Feto feyafa, Solokafo monolo nuba o-o abo wenina ya apito li hopa o betito numunatina negu-negu muki yoto we wena adinalo-hidinalo ika oto nala numugu limo fulo betito minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ido upatoti uwabo weninasi ya numudo-namado uti hala ukuwa ya lobimo uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Lobimo uwato, ido Filipi yakafo Samalia ebalo wenina numunatina nabalo uto Gotikafo ilifi molaibo we Kilisto hala ya lo oloto molaito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","wenina muki nuba naba minabo yasi hala ya holiti Goti aubala idipibo idafa li oloto pibo ya wati, ha lobibo ya auba iti holi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ido Satani himiwela yasi wenina muki mino betiyabo ya lutinau yau yoti hai naba-naba molato, ido ma ya utina hebilisito nebo, ido ma ya hidina galidibo yaleka ya li faka lo betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yagunu aya numudo minabo wenina muki ake naba-naba iyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ido numuna meya ayalo ya we ma nebo huliya Saimoni yakafo hamena fana hifena lusa hito, Samalia minabo wenina muki idafawa holiti elegiyae. Wewa eimola huliya li faka loto, Nemo huline nebo we minowe, lito ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","wenina muki hulitina nebo ido aifa wenina yagi ha lobibo ya auba iti holi minoti feto loti labo, Wewa ya goti huliya Aubala Naba Nebo ya ne, loti lo-lo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ido hamena fana hifena lusa hibo monala wati moda elegiyanako, emodoka ege molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Feto feyafa, Filipikafo Goti wehudite weninala hiyaba o ledaibo ha ido Yesu Kilisto huliya yagunu hala ukuwa lobito, holiti holi hikitabo we wena muki mono noku iyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mono noku iyato, Saimoni eimolakafo ayaidana oto holi hikito mutoto noku iye. Noku itoto Filipi nedo monibo ege moloto Goti aubala idipibo idafa mona-mona li oloto pi betibo ya wato elegi ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ido Yelusalemu numudoka aposolo yasi Samalia wenina Goti hala ukuwa holiti holi hikito muwabo ya holiyado Pitate Yonite emotinalo idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Idipi molato, emotinaloka u fedito, Weuna Felekafo holi hikitabo wenina lutinau mino betiyámito, aifa Yesu huliyalo yako noku iyanako, Weuna Fele lutinau lumuto mino betinaiye, loti Wenaba lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Feto lomu itoti we loitisi adinagunu ya holi hikitabo wenina manadinalo molaito, Weuna Fele mino betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ido aposolo adinagunu ya wenina manadinalo molaito, Weuna Fele mino betibo Saimonikafo watoto uto hefana lito ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","loiti minaido uto feto loto lobibo, Hemotina hefana biyoto aubawa nomaito, nemo ayaidana oto wenina manadinalo ane moloto Weuna Fele mino betinaiye, loto nomo, liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pitakafo feto loto lomuibo, Gotikafo aifa lumibo idafa ya hemo hefanamamo meina finowe, loto laninako, ya hefanaka yagi hemogi moda maina so fiyámanaibo soku yau unigilaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hemo ya Goti nomunalo ya weuga-luka-haka fefe ladáminako, ononawa lemogi maina onona liyámanogolane. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Nosámibo idafa yakafo lukau yoi faitoto idafawa nala fi hedaibo ne, loto holiyowe. Yagunu luka-haka elepa ito nosámibo monaka fulito, luka-hakau idafawa nosámibo holiyanibo idafa ya Wenaba lifimaka hilili o nedo, loto lomuwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimonikafo liwila oto lomuibo, Idafawa hemotina laibo ya ma oloto pi numutanaiye, hemotina nemogunu Goti lomuliyo, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ena Yesu monala waibo lobiti Wenaba hala ukuwa lo oloto molo itoti ya Yelusalemu liwila oti unigili uti moni minado wenina Samalia numuna meya muki minabo ya hala ukuwa lobimo uwaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ena Wenaba enisolela makafo Filipi nedo loto feto loto lomuibo, Hemo ya hanu ya waka yolaleka hameto mikau yau Yelusalemu numudokati lumuto u Gasa numudoka wibo hanudo yalo uwo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lomuito, apito monimo uto aya hanudo yalo moda hiyaba we ma Itiyopiakati aibo we ma hatula aiye. Wewa Itiyopia mikau hiyabatina wena wenahudi Kadasi hefana-huwamenala hiyaba aibo we yakafo Yelusalemuka Goti weune-lune-hane munowe, loto uto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aliga numunalaloka liwila oto anaibo hamenalo ya safu-hosi ika aibo idafalo amedoto minoto polofeti Aisaiya mono lufuwa ibo ha ya hitomo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hitomo wito, Weunakafo Filipi feto loto lomuibo, Hemo ya uto mulalo monibo idafa selo ege-ege uwo, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi holito oluloto uto wewa ya polofeti Aisaiya lufuwa ibo ha ya hito nebo ya holito loga o edaibo, Hemo lufuwa hitanibo ya monawa holifefe loto holabe? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Loga o edaito, liwila oto lomuibo, We makafo ha monawa ya api nilibiyámanaibo ya igaidana oto holifefe lanobo ne? loto lomuto hemo yoto nemote maina amedoto minanoiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lomuibo ha ya mono lufuwalo feito hitaibo, Sipisipi ma hofanune, loti ilimiti uwado, ido sipisipi mofola opala fukanado ya sipisipi hai molámibo yaidana oto emokafo ha ladámiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ha ladámito, ulalo holinaibo ona muti sigiya lo edado fefe loti li halo molo edámae. Ido mikalo nebo hamenala ya fukoti, hofo fuliyanako, hemakafo yufa figuti weninala hatina ogofu anogolaiye? loto ha mono lufuwau (Ais 53:7-8) ya nebo ha hito ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hito nebo hiyaba oto nebo wekafo Filipi loga o edaibo, Lonomageto holinogolowe. Polofeti ya hemagunu feto liye? Eimolagunu life, ido we magunu liye? loto loga o edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Loga o edaito, Filipikafo yaloti molo pito aya mono hawaloti Yesu hala ukuwa dowa ya api ilibimo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Feito ilibimo wito monimo lumuti nolo ya fedito hiyaba wekafo libo, Moda noma me ya ne. Nemo mono noku inobo ya hemakafo hanu hu nedanaiye? loto loga o edaiye.  ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipikafo lomuibo, Hemo weuga-luka-haka muki holi hikito mutoma ya moda noku inane, loto lomuito, liwila oto lomuibo, Nemokafo Yesu Kilisto ya Goti Hipala ne, loto holi hikito muwowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ido safu-hosi ika aibo idafa ya li you loto molaito, Filipite hiyaba wete yaloti lumuti noku lomato, Filipi noku i edaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Noku i edoito nokuti feka aito, Wenaba Weuna yakafo Filipi ilimito wito hiyaba wekafo hofa wa edámito ake naba ito hanulalo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hanulalo wito, ido Filipi ya Asidoti numudo yalo oloto pito numudo-namado monimo uto hala ukuwa dowa ya lobimo uto Sisalia numudo wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Solokafo Wenaba ege molabo wenina hofo beti fulinowe, loto lalafu betito aibo uto Goti sokila hi muwabo we hiyabatina we wenaba nedo uto ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","feto lomuibo, Nemo Damasikusi numudoka uto Yesu hanulalo moniyabo wenina ma minanabo wefe, ido wenafe li oloto pi betitoma adinalo-hidinalo nala ito ya Yelusalemu numudoka idipito anowe, loto holiyobo yagunu hemokafo Damasikusi numudo Yuda wenina mono numunatinau nuba o-o abo wenina ya lufuwa i betito nomagetoma ya lito unowe, loto lomuito, ya lufuwa i muito lito wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yalo monimo uto Damasikusi numuna u alili aito, ya okulumauti lamenakafo haita li hona o edoto lamena aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Feto feyaito, mikalo lumu fou loto nola ma holibo feto loto lomuibo, Solo, Solo, hemo neidafaito li hopa o nedo minane? loto lomuibo ya holito ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","feto libo, Wenabao, hemo hema minane? loto loga o edaito, emokafo liwila oto lomuibo, Nemo Yesu ya li hopa o nedo minanibo we ya minowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ena hemo sinoito, numuna meya nabaleka uwageto yalo idafa feyananibo ha ya lohumunogolaiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lomuito, wemoli Sologi moniyabo we ya ha nola holiyafa, ido we ma wa edámabo yagunu ha hedámoti minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ido Solo mikaloti sinoito ya wenu wanowe, loto nomuna falatifa, idafa ma wagámito analo liti Damasikusi numudoka ilimiti uwato, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","yalo fo hamena tili (3) nomuna likaito minoto wela-idafagi no-anogi ya námiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ena Damasikusi numudo Yesu ege molaibo we ma huliya Ananaiyasi nebo ido wamoidana libo nomunalo molaigu ya Wenabakafo lomuibo, Ananaiyasiyo, loto lomuito, ya liwila oto libo, Ye, Wenabao, nemo me ya minowe, lito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ya Wenabakafo feto loto lomuibo, Hemo uto hanu ma huliya Fefe Libo ne, labo yalo uto Yudasi numunalalo we ma Tasusi numudoti aibo we huliya Solo ya wita edo. Wewa ya lonumu ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lonumu minoto wamoidana waibo ya we ma huliya Ananaiyasi yakafo emo nedoka loto nomuna hofa wanaiye, loto anagunu ulalo molaibo wewa ya waiye, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lomuito, Ananaiyasikafo libo, Wenabao, wewa yagunu wenina muki ha labo ya moda holitobo ne. Emo yakafo weninaka Yelusalemuka minabo ya li hopa o beti-beti aibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ido melo ya ayaidana oto sokila hi homabo we wenabatina hulitinalo loto weninaka muki hulikalo li faka lo ledo, loto lohumunubo ya hidelo-adelo nala ito lilimito unowe, loto aiye, loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wenabakafo feto loto lomuibo, Hemo aifa uwo. Wewa nemo houba-nabane we minoto, eito feka weninagi ido hiyabatina we wehudi minagu ido Isilaeli weninagi minagu ya uto huline li oloto pi binaiye, loto weune fi edotowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ido huline yagunu hena naba-naba holinaibo ya ilibinogolowe, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Feto lomuito, ya Ananaiyasi uto numugu yau yoto Solo ulalo anagunu moloto feto loto lomuibo, Weninane, Solo, Wenaba ya Yesu eimola hanudo oloto pi humibo we yakafo hemo nomuga hofa wageto Weuna Fele hemogu mino hedaibo ya faitanogolaiye, loto ya nilifito owe, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ayalo Solo nomunauti idafa ma laefa lifala yaidana limo ito, nomuna hofa wato, sinoito mono noku iye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Feto feyaito wela-idafa nototo hofa auba liye. Ena Solo ya Yesu ege molabo we Damasikusi numudoka minabo yagi hamena abi maina minoto, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ayalo Yuda wenina mono numunatinau yoto Yesu ya Goti Hipala ne, loto apito lo oloto molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lo oloto molaito, wenina muki hala ya holiyabo elegiti feto loti labo, Yelusalemu numudo wenina ya Yesuwo, adelo li faka lo ledo, loti labo wenina ya hofo betimo wibo wema nefe? Ido melo ayaida oto nala i betito sokila hiyabo we hiyabatina we minadoka idipito unowe, loto feyaibo we aima yama ya nefe? loti loga-miga ae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Feto lafa, Solo auba ito lo oloto molomo uto Yesu ya ona Gotikafo ilifi molaibo we Kilisto ya nebo nenako, yagunu lobito, Yuda wenina Damasikusi numudo minabo hatina loiti-loiti kiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ena fo hamena abi loti uwageto ya Yuda weninasi Solo hofo fulinune, loti nuba oti hudala hiyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ido Solokafo hudala hiyabo ha holiye. Holito fo hamena ido lubuka ya numuna meya naba hanu hila hadena ya hofo fulinune, loti hiyaba afa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Solo ege molabo we yasi lubuka midipu igu ya Solo ilimiti uti hefana numuna meya hila mulalo yama minoti owo egepisa owoku holi edoti nala onuwa filiga-filiga li minoti fulato yalo lumuto u feka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ena Yelusalemu numudoka loto Yesu ege molabo wegi kelanowe, lifa, emo ya Yesu ege molaibo we ne, loti holi hikitámoti ya holiya holiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Holiya holiyato, Banabasikafo loto analo li faka loto, ilimito aposolo minadoka uwaiye. Uti Solokafo hanudo Wenaba wa edaito, ha lomuibo holito Damasikusi numudo uto wenina holitina holiyámoto Yesu huliyalo lo oloto molaibo hala ya lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Lobito, feito Solo ya emogi maina minoto Yelusalemu numudo aifa monito wenina holitina holámoto Wenaba huliyalo lo oloto molo-molo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lo oloto molaibo ya Yuda wenina Giliki ha labo wenina yagi moliya-moliya fifa, hofo fulinabo hanu moni wita ato, ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","mono weninala yasi hawa holiti, ya ilimiti Sisalia numudo uti ilifi fulato u Tasusi numudo ya wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Feito Yesu weninala Yudia, Galili, Samalia minado ya you amena hamena dowa oloto pito, Weuna Felekafo lutina-hatinau li aila ito auba i betito, wenina muki emotinadoka homi-homi ato Wenaba holiya holiti moniyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ido Pita ya numudo-namado ya monimo uto fele wenina maleka magi wa betinowe, loto Lida numudo minadoka wiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yalo minoto we ma wa edaibo huliya Ainiyasi ula hebilisibo folomoloko unoito nebo melege eiti (8) ya wibo we ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ya Pitakafo feto loto lomuibo, Ainiyasiyo, Yesu Kilistokafo li faka lo hedaiye. Sinoito, hunuka lifefe lo, lito ayalo sinoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sinoito, wenina muki Lida numudoti ido Saloni omuna mikaloti minabo ya wati lutina-hatina elepa iti Wenaba holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ido Yopa numudo Yesu ege molaibo wena ma huliya Tabita (Giliki wenina hatinalokati huliya Dokasi) ya nebo hamena-hamena mona dowako moloto idafa wa námabo wenina adinalo li faka lo-lo aiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aya hamena yalo ya idafa naba hilito fulito, ya hono ula noku noiti li numuna ofugu yoti molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Molato, ya Lida numuna ya Yopa numuna selo nebo yagunu Yesu ege molabo wenina yasi Pita Yopa numudo nebo ya holiti we loiti ma Pita nedoka idipi molato, aloko lemo minonido ano, loti idipi molae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Idipi molato, uti lomuito, Pitagi maina loti lo fedato, ilimiti ofugu ayau yowato wenipa-hiyona muki ya emo nedo loti li hona o edoti hufo nama oti minoti Dokasikafo nomuna hofawa minoto utinalo owo mona-mona hifito bibo idafa ya ilibi minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ilibiyato, Pitakafo wenina muki idipi fulo feka itoto, hina obula fito Goti lomu itoto elepa ito wena fulibo ya wa edoto, Tabitao, sinoiyo, lito nomuna falatoto Pita wa edoto amediye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Amedoto neto, Pitakafo analo lito li sinoi edaito sinoito neto, holi hikitabo wenina ido wenipa-hiyona emodoka sutina fito, yowato ya Dokasi nomuna hofawa nebo ya itibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ido hawa ya Yopa numudo upatoto wito holi huloti, wenina abi idafa Wenaba holi hikito muwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ido Pita Yopa numudo we ma huliya Saimoni bulumakau etuwa lifefe lo-lo aibo we numunalau emogi maina hamena fana minaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ena Sisalia numudo we ma nebo huliya Koniliusi ya ne. Emo ya himiwe nuba naba minabo hulitina Itali Mikalo Himiwe, loti labo yauti himiwe wani hadeti (100) ya hiyabatina we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wewa ido weninala muki ya mono holiti Goti holiya holiti moniyae. Feito ya Yuda wenina idafa wa námabo wenina ya hefana-afana idafa-adafa muki bito, ido Goti lomu-lomu aibo we ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ido fo hamena malo ya lunaga tili (3) kiloku yaidanalo idafa ma wamo yaidana oto fefe loto waibo ya Goti enisolela makafo wamoku oloto pi muto emo nedo loto, Koniliusiyo, lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lomuito, wenu wa faka loto wa edoto holi naba-naba muito feto loto lomuibo, Wenabao, nedafaiye? loto loga o edaito, enisolemakafo liwila oto loto lomuibo, Goti lomu-lomu anibo haka ido idafa wa námabo wenina aifa li dowa lo betiyanibo monaka ya Goti holito hemogunu hala ki ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yagunu hemo Yopa numudo wemoli ma idipi molageto uti we ma huliya Saimoni, ido huliya ma Pita ya moni witala oti liwila oti ilimiti anae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wewa ya abalafo Saimoni bulumakau etuwa lifefe lo-lo aibo we numunalau ho no anawaloka yoila yalo ne, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Feito lomuto enisole utaito, ena Koniliusi houba-nabala we loiti magi ido himiwela emoteko mino-mino abo we minagu yauti we ma mono holibo yagi sutina fito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","emodoka ato ya idafawa muki oloto pibo yama lobito Yopa numudoka idipi molaiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Idipi molaito, monimo uti uti hanudo unoti, ho lito hofa uti numuna meya li alili molado ya folilo Pitakafo Goti lomunowe, loto numuna obito eba hatapalo yoto ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Minoto ya Goti lomu nedoti inagunu fulito idafa ma nanowe, loto holifa, ido wetina-idafa hofo hi minabo hamenalo idafa ma wamoidana waibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wamoku waibo ya okuluma lula lito yauti idafa naba ma lafo-lafo yaidana oto onuwa filiga-filiga ya li minoto fulaito, mikalo lumibo waiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Waibo ya lafo-lafowa lulau safu mona-mona hidina-adina fo (4) nebo ido yá hafa-afa, ido hosofa-asofa, nama-afa, mona-mona yau minabo waito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ido ha nola makafo feto loto lomuibo, Pita, hemo sinoito ya hofoto no, loto lomuifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pitakafo feto libo, Wenabao, yaidana feyámanowe. Nemo idafa fuma ibo ido idafa hiluwa ladámibo ya moda námobo ne, loto liye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Feto lito, ha nolamakafo hofa lomuibo, Idafa ma Gotikafo hiluwa loto nebo idafa lifefe libo, ya idafa fuma ibo ne, loto ladámo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Feto lomuto ido idafawa ya ayamaidana oto hamena tili (3) oloto pitoto ya ayalo liwila oto okulumauka yoiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Yoito, Pitakafo idafa hofawa waibo ya monawa yagunu hala abi ki nedo Koniliusikafo idipi molaibo weninala Saimoni numunala li oloto piti numunala hila hanudo minoti ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","wenina sutina fiti feto labo, Saimoni huliya ma Pita ya numunala meu nefe? loti loga o betiyae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Loga o betiyato, Pitakafo idafa waibo yagunu hala ki neto, Weunakafo feto loto lomuibo, Saimoniyo, we tili (3) wita hedo minae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aya weninawa ya nemokafo idipi moloto ya emotinagi unowe, loto haka loiti kiyámoto, sinoito lomageto maina wilo, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ha lomutaito, Pita minadoka lumuto feto loto lobibo, We ma witala omo abo we yama minowe. Hemotina ya nedafaiye loti ae? loto loga o betito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","wewa yasi feto loti lomuwabo, Himiwe wani hadeti (100) nuba abo hiyabatina we Koniliusikafo lilifi molaito one. Emo ya fefe libo mona moloto Goti holiya holibo we nebo ya Yuda wenina muki emogunu holiyabo dowa loti holiyae. Dowa loti holiyato, enisole fele nebo makafo oloto pi muto feto loto lomuibo, Pita ha lanaibo holinune, loto emodoka idipi molaito uti ilimiti ato ya Pita numunakau anaiye, loto lomuito, holito lilifi molaiye, loti lomuwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lomuwato, Pitakafo numugu yoilo, loto aifa li dowa lo betito, yalo unato ho lito Pitagi ido wemoliwagi Yopa numudoti Yesu mono weninala malekamagi maina uwae. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ena uti ya hanudo unoti uto Sisalia numudo uwato Koniliusikafo weninala ido hounalafo-mota li nuba o betito, hiyabatina minato ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","yalo ato, Pitakafo numugu yonowe, loto hanuku yoido Koniliusi loto weune-lune-hane munowe, loto hinalo hina obula fifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pitakafo li sinoi edoto feto lomuibo, Sinoiyo. Nemo yagi aifa we yako minowe, loto lomuito, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","loyolalo-melo oti, numugu yoti wenina nuba minabo ya wa betiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wa betito feto loto lobibo, Hemotina lemo Yuda wenina monate ya holi minama ne. Lo fukabo monate ya eito feka weninagi kelámoti, ido numunatinau yagi yowámilo, loto lo fuko ledotaibo ne. Feito nebo nefa, Gotikafo we ma ya fuma ibo ido hiluwa ladámibo ne, loto ladámo, loto nilibiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yagunu ano, lageto ya hane loiti kiyámoto owe. Ido sune fiyanibo monawa ya lageto holinowe, loto lobiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Lobito, Koniliusikafo liwila oto feto loto lomuibo, Idafa oloto pi nedaibo ya wato lubu hamena fo (4) uno minowe. Idafawa yagunu ha lohumunogolowe. Aya hamenalo lunaga tili (3) kilokulo ya numunaneu Goti lomu minoto moda ayalo ya we makafo ulalo owo lamena aibo holoibo we ya nemodoka nomunelo oloto pito feto loto lonumibo, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Koniliusiyo, Goti ha lomuwanibo ya holito, ido idafa wa námabo wenina idafa-adafa biyanibo monaka ya holiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yagunu Yopa numudo wemoli idipi molageto Saimoni huliya ma Pita ya ilimiti anae. Emo abalafo Saimoni bulumakau etuwa lifefe lo-lo aibo we numunalau ho no anawaleka yola ne, loto lonumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Feto lonumito, ayalo wenina idipi moloto hemodoka uwato ya hemo hane holito anibo yagunu lune-haneu dowa liye. Ido lemo ya loto me ya Goti nomunalo li nuba oto minonibo Wenabakafo hemo ha lobiyo, loto aubafofo loto lohumibo yama lageto holinune, loto lomuiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ena Pitakafo apito feto lobibo, Goti ya wenina hona moloto ekei ámifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ido wenina muki yufa nedo-nedo monalo-monalo holiya holinabo ya ido monatina fefe loti molo minabo wenina ya houna i betiye. Hawa onae, loto onesa holifefe loto holowe. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ido hawa Gotikafo Isilaeli wenina fulo ledaibo ha ya Yesu Kilistokafo li you lo ledaibo ha ya lo oloto molaiye. Wewa ya mikau-mikau wenina muki Wenabate ya ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ido hana Galilika Yonikafo noku i-i aibo ha ya lo oloto molaito, aliga Yudia eba nedo-nedo idafa muki lo oloto pibo ya moda holi minama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Holi minama ya Gotikafo Yesu ya Nasaletekati aibo we ononane linaiye, loto Fele Weunagi ido aubala nabagi muto, ido Goti ya mino edainako, mika nedo-nedo uto loto wenina dowa lo betito, ido Satanikafo li hopa itaibo wenina muki ya li faka lo betibo hawa ya hemotina muki moda holi minama ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ido lemo nomudegunu Yelusalemu numudo ido Yuda wenina mikatinalo idafa muki fe molaibo ya moda wa onibo ne. Ido yá yofolo hofo fuliyafa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","fo hamena tili (3) yalo ya Gotikafo fuliguti hofa li sinoi edoto oloto pi lumifa, ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ido wenina muki ya wa edámae. E'e, wenina weuna fi ledaibo wenina yako ya fuliguti sinoitaito, wete-idafa emogi maina nonibo ya oloto pi ledaibo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Emokafo ha gedibo feto lolumibo, Wenina muki ya lo oloto moloti bilo. Ido Gotikafo wenina fuliyabogi ido nomudina hofawa minabo weninagi lifimatina liwila oto binane, loto hona molaibo wewa nemo ya minowe, loto lobilo, loto lolumiye. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ido polofeti muki yasi emogunu feto loti labo, Wenina muki holi hikito muwabo ya huliyalo lifimatina hilili o betinaibo ne, loti labo ne. ");
INSERT INTO snp_lambau_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitakafo hawa lo neto, ya muki holiti minabo weninawaloka Weuna Fele loto mino betiye. ");
INSERT IN