﻿USE sofia;
DROP TABLE IF EXISTS sofia.snnNT_vpl;
CREATE TABLE snnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snnNT_vpl WRITE;
INSERT INTO snnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yureca, Jesucristo ira bain ba'isi'cuare toyani jo'case'e ba'iji. Baguë ira bain ru'ruña ba'isi'cua yua David, Abraham, ja'ancua bateña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham yua Isaac pë'caguë baquëña. Isaac yua Jacob pë'caguë baquëña. Jacob yua Judá, Judá yo'jecua, bacua pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá yua Tamarni huejani, Fares, Zara, bacua pë'caguë baquëña. Fares yua Esrom pë'caguë baquëña. Esrom yua Aram pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram yua Aminadab pë'caguë baquëña. Aminadab yua Naasón pë'caguë baquëña. Naasón yua Salmón pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón yua Rahabni huejani, Booz pë'caguë baquëña. Booz yua Rutni huejani, Obed pë'caguë baquëña. Obed yua Isaí pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí yua mai ira taita ba'isi'quë David pë'caguë baquëña. Mai ira taita ba'isi'quë David, yua Israel bain quë'rë ta'yejeiye ëjaguë ba'iguëbi yua Urías rënjo hua'jesi'coni huejani, Salomón pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón yua Roboam pë'caguë baquëña. Roboam yua Abías pë'caguë baquëña. Abías yua Asa pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yua Josafat pë'caguë baquëña. Josafat yua Joram pë'caguë baquëña. Joram yua Uzías pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías yua Jotam pë'caguë baquëña. Jotam yua Acaz pë'caguë baquëña. Acaz yua Ezequías pëcaguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías yua Manasés pë'caguë baquëña. Manasés yua Amón pë'caguë baquëña. Amón yua Josías pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías yua Jeconías, Jeconías yo'jecua, bacua pë'caguë baquëña. Ba'iguëna, ja'anrën yua Israel bain preso zeanni sasirën baquëña, Babiloniana sasirën. ");
INSERT INTO snnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ja'nca preso zeanni sasi'cua ba'ijënna, ja'nrëbi Jeconías yua Salatiel pë'caguë baquëña. Salatiel yua Zorobabel pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel yua Abiud pë'caguë baquëña. Abiud yua Eliaquim pë'caguë baquëña. Abiud yua Eliaquim pë'caguë baquëña. Eliaquim yua Azor pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor yua Sadoc pë'caguë baquëña. Sadoc yua Aquim pë'caguë baquëña. Aquim yua Eliud pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud yua Eleazar pë'caguë baquëña. Eleazar yua Matán pë'caguë baquëña. Matán yua Jacob pë'caguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob yua José, María ënjë, baguë pë'caguë baquëña. María yua Jesusni të'ya raco'ë, Cristo hue'eguëni. ");
INSERT INTO snnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ja'nca ba'iguëna, Abraham ba'isirënbi David ba'isirën tëca, ja'anrënte cuencueto, catorce pë'caguë sanhuë zin jojosi'cua bateña. Ja'nrëbi, David ba'isirënbi Israel bain preso zeanni Babiloniana sasirën tëca, ja'anrënte cuencueto, catorce pë'caguë sanhuë zin jojosi'cua bateña. Ja'nrëbi, preso zeanni sasirënbi Cristo të'ya raisirën tëca, ja'anrënre cuencueto, catorce pë'caguë sanhuë zin jojosi'cua bateña. ");
INSERT INTO snnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yureca Jesucristo të'ya raise'ere quëato, ñaca baji'i. Baguë pë'cago María yua Joseni huejaja'go baco'ë. Yuta huejama'icua ba'ijënna, Riusu Espíritubi bagona ti'anni, Ta'yejeiguë sëani, Riusu zin të'yajeija'ye re'huabi. Re'huaguëna, bago bainbi masihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ja'nca masijënna, bago huejaja'guë José hue'eguë, re'o bainguë ba'iguëbi bainni gu'aye caye güeguë, Bagote ro yahue jo'cani senjoza ro'taguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ja'nca ro'taguë ba'iguëna, Riusu anje hua'guëbi gaje meni, Josebi ëoruna canni ëñaguëna, baguëni quëani achobi: —José, David bainguë, Maríani huejaye huaji yëye beoye ba'ijë'ën. Riusu Espíritubi bagona ti'anni, zin të'yajeija'ye re'huaguëna, zinbë ba'igo. ");
INSERT INTO snnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ja'nca zinbë ba'igobi zinre të'ya raigona, baguë mamire JESUS hue'yojë'ën. Baguë bain gu'a juchana zemosi'cuare tëani, bacua juchare senjoni, bacuani baja'guë sëani, ja'nca baguëte hue'yojë'ën, anjebi guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yua Riusu ira coca cani jo'case'e, baguë ira bainguë raosi'quë toyani jo'case'e, ja'anre ro'tani, güina'ru ba'ija'guë caguë, yure ba'iyete cuencueni si'aye re'huabi. Ba coca toyani jo'case'e yua ñaca baji'i: ");
INSERT INTO snnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Romi zingobi zin nëcani, zinre të'ya raija'go'co. Të'ya raigona, baguë mami yua Emanuel hue'yosi'quë ba'ija'guë'bi, toyani jo'case'e baji'i. Ja'an mami yua bain cocabi cato, Riusu yua mai naconi te'e ba'iji, caji. ");
INSERT INTO snnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja'nrëbi, Josebi sëta rani, Riusu anje guanseni jo'case'e'ru güina'ru yo'obi. Maríani huejani babi. ");
INSERT INTO snnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ja'nca huejani baguëta'an, bago zin ru'rureba të'ya raisi'quëni të'ya raiye tëca, Josebi María naconi zin cu'emaji'i. Cu'ema'iguëbi, bago zin të'ya raigona, baguëte JESUS hue'yobi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús të'ya raisi jobo yua Belén hue'ebi, Judea yija ba'i jobo. Bain ta'yejeiye ëjaguë Herodes hue'ebi ja'anrën. Ja'nca ba'iguëna, ma'choco ëñajën ye'yesi'cuabi ënsëguë eta rai ca'ncobi rani, Jerusalenna ti'anni, ");
INSERT INTO snnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","coca senni acha bi'rahuë: —Judío bain ta'yejeiyereba ëjaguë ba'ija'guë yuara të'ya raisi'quë, ¿jarore ba'iguë'ne baguë? Yëquënabi ënsëguë etajei yijare ba'ijën, ba ma'chocote ëñani, baguë të'ya raise'ere masihuë. Ja'nca ëñani, ma'chocobi saguëna, be'teni ti'anhuë. Ti'anni, baguëna gugurini rëañu cajën ba'iyë yëquëna, senni achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Senni achajën ba'ijënna, bain ta'yejeiye ëjaguë Herodesbi achani, gue ro'taye beoye ba'iguë, ai quëquëbi. Si'a Jerusalén bain'ga baguë naconi te'e quëquëjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ja'nca quëquëjënna, Herodesbi pairi ëjacua, ira coca ye'yocua, si'acuani choini, ñë'coni, bacuani si'a jëja senni achabi: —Ba Cristo ba'ija'guë ¿jarona të'ya raisi'quë ba'ija'guë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Senni achaguëna, bacua sehuohuë: —Belén huë'e jobo, Judea yija ba'i jobo, ja'anruna të'ya raisi'quë ba'ija'guë'bi. Riusu ira bainguë raosi'quëbi ñaca toyani maina jo'cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén huë'e jobo bain, Judea yijare ba'icua, mësacuabi yua ai ta'yejeiyereba ba'icua ba'ija'cua'ë. Judea yija ëja bain ba'ija'cuare ro'tato, te'eguëbi mësacua huë'e jobobi rani, yë'ë bain Israel bain cacuare guanseguë ba'ija'guë'bi, maina toyani jo'cabi, quëani achohuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Quëani achojënna, ja'nrëbi Herodes yua ba ma'choco ëñajën ye'yesi'cuare yahue choini, bacua ma'choco ëñasirënrebare senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Senni achani, masini, ja'nrëbi, bacuare Belenna saoguë cabi: —Mësacua sani, ba zin hua'guë ba'iyete re'oye senni achani cu'ejë'ën. Cu'eni, tinjani, ja'nrëbi yë'ëna quëa raijë'ën. Yë'ë'ga baguëna sani gugurini rëanza, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ja'nca caguëna, bacua saë'ë. Sani ëñato, bacua ma'choco ënsëguë etajei yija ëñase'e yua ja'ansirure sëji'i. Ja'nca së'iguë, bacuare sabi. Sani, ba zin hua'guë ba'i huë'ena ti'anni, ja'anruna nëcajaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nëcajaiguëna, ma'choco ëñajën ye'yesi'cuabi ba ma'chocore ëñajën, ai bojoreba bojojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ja'nca bojojën, ba huë'ena cacani ëñato, ba zin hua'guë yua baguë pë'cago María naconi baji'i. Ba'iguëna, bacua yua baguëna gugurini rëanjën, baguë ta'yejeiye ba'iyete ro'tajën, ai bojohuë baguëre. Ja'nca bojojën, bacua gajonguanre a'nqueni, ai ro'i bonsere inni, baguëna ro insihuë. Zoa curi, incienso, mirra, ja'an ma'ña sëñete baguëna ro insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Insini, ja'nrëbi ëoruna canni ëñato, Riusu quëabi: Herodes ba'iruna se'e go'ima'ijë'ën, cani ëñobi. Ëñoguëna, bacua yua tin ma'abi sani, bacua yijana go'imate. ");
INSERT INTO snnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ja'nca gotena, Josebi ëoruna canni ëñato, Riusu anjebi ëoruna cabi: —Yua huëijë'ën. Ba zin hua'guë, baguë pë'cago, bacuare sani, Egipto yijana gatijë'ën. Baruna ti'anni, yë'ë quëaye tëca bëani ba'ijë'ën. Herodes yua ba zin hua'guëte huaza caguë, baguëte cu'e ganoji, ëoruna cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Caguëna, José yua ja'ansirën huëni, ba zin hua'guë, baguë pë'cago, bacuare ñamibi sani, Egipto yijana gatini saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sani ti'anni, Herodes junni huesëye tëca bëani baë'ë. Riusu ira bainguë raosi'quë cani jo'case'e'ru: “Yë'ë Zinre Egipto yijabi etaye choë'ë” ja'an cani jo'case'e'ru güina'ru yo'o güesebi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yureca Herodes yua ma'choco ëñajën ye'yesi'cuare ëjoni jëhuabi. Bacua yijana go'ise'ere achani, Yë'ëre ro coquehuë caguë, ai bëinreba bënji'i. Ja'nca bëinguëbi si'a zin hua'na samu tëcahuëan bacua go'ye ba'icuare, ëmëcua, Belén huë'e jobo ca'nco ba'icua, ja'ancuare huani senjojë'ën guanseguë cabi. Ma'choco ëñajën ye'yesi'cua case'ere ro'tani, zin hua'na ba'i tëcahuëanre cuencueni, ja'nca guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ja'nca ba'iguëna, Riusu ira bainguë raosi'quë Jeremías hue'eguë, baguë coca cani jo'case'e'ru güina'ru baji'i: ");
INSERT INTO snnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá yijana achato, ai ba'iye ai jëja ota oiye baji'i. Ira pë'cago ba'isi'co Raquel baco'ë. Bago mamacua junni huesësi'cua ba'ijënna, ai ota oco'ë bago. Zin hua'na beogo sëani, yequëcuabi bagoni bojo güeseye poremaë'ë, cani jo'cabi Jeremías. ");
INSERT INTO snnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ja'nrëbi, Herodesbi junni huesëguëna, Riusu anjebi gaje meni, José yua Egipto yijare ba'iguëna, baguë ëo cainsiruna ëñoni, baguëni cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Yua huëijë'ën. Ba zin hua'guë, baguë pë'cago, bacuare sani, Israel yijana go'ijë'ën. Zin hua'guëni huani senjoñe yëcuabi yua junni huesëhuë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Caguëna, José yua ja'ansi'quë huëni, ba zin hua'guë, baguë pë'cago, bacuare sani, Israel yijana goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Goni, ti'an bi'rani achato, Arequelao hue'eguëbi yua Judea bainni guanseguë baji'i. Baguë pë'caguë Herodesbi junni huesëguëna, baguëbi bëani, bainni guanseguë baji'i. Ja'nca ba'iguëna, Josebi achani, Judeana saiye ai huaji yëguë baji'i. Ja'nca ba'iguëbi ëoruna canni ëñato, Riusu anjebi baguëni coca yihuoguë cabi. Ja'nca caguëna, Josebi huëni, ba zin hua'guë, baguë pë'cago, bacuare sani, Galilea yijana quëñëni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ja'nca quëñëni sani, ti'anni, Nazaret huë'e jobona bëani baji'i. Riusu ira bain raosi'cua cani jo'case'e: “Nazareno bainguë casi'quë ba'ija'guë'bi” zoe cani jo'carena, güina'ru baji'i Jesusre. ");
INSERT INTO snnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ja'nrëbi jë'te, Juan Bautizaguëbi Judea yija beo re'otona ti'anni, bainni coca quëani acho bi'rabi: ");
INSERT INTO snnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Riusu ba'i jobo ëñoja'ñe yurera ti'anja'ñeta'an ba'iji. Ja'nca sëani, mësacua gu'a jucha yo'ojën ba'ise'ere gare jo'cani, mame recoyo re'huani ba'ijë'ën, quëani achoguë baji'i Juan. ");
INSERT INTO snnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan ba'iyete cato, Riusu ira bainguë raosi'quë Isaías hue'eguëbi baguë ba'ija'yete zoe cocare toyani jo'cabi: Riusu bainguëbi beo re'otona ti'anni, ai jëja coca bainni quëani achoja'guë'bi: “Mai Ëjaguë rai ma'a re'huaye'ru re'huajë'ën. Te'e ruin ma'are baguëte yo'ocaijë'ën” quëani achoja'guë'bi, toyani jo'cabi Isaías. ");
INSERT INTO snnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja'nca toyani jo'caguëna, Juanbi ti'anni güina'ru yo'obi. Baguë cañare ëñato, camello rañabi tëonse'e baji'i. Ga'ni tëinme baguë sëri seihuëte tënji'i. Baguë aonre ëñato, ba yija bu'nsu, o'a baya, ja'an baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ja'nca ba'iguëna, ai jai jubë bainbi, Jerusalén huë'e jobo, Judea yija, Jordán ziaya ca'nco, ja'anruanbi rani, Juanni achañu cajën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ja'nca raicuabi bacua gu'a jucha beoru quëareba quëatoca, Juanbi bacuare Jordán ziayana bautizabi. ");
INSERT INTO snnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ja'nca bautizaguëbi, fariseo bain, saduceo bain, ja'ancuabi bautiza güesejañu cajën raijënna, bacuani bëiñe ëñani cabi: —¡Mësacua yua ro aña jubë se'ga'ru ro coquejën raisi'cua'ë! Riusu bënni senjosi'cua ba'ija'cua sëani, ¿queaca jëaye ro'taye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mësacua yua gu'a juchare senjoni, mësacua recoyo mame re'huani ba'ijë'ën. Ja'nca yo'ojën ba'itoca, te'e ruiñe ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ro mësacua coca, Yëquëna yua taita Abraham mamacua sëani, Riusubi yëquënani bëinma'iji catoca, ro huacha ro'tayë mësacua. Riusubi ënjo'on ba'i gatabëanbi inni, Abraham mamacuare re'huaye yënica, ja'nca re'huaye poreji. ");
INSERT INTO snnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gu'a sunqui cueye'ru yo'oji Riusu. Zu'ubobi inni, re'oye guë'tosibo ba'iguëna, si'a sunquire ëñani, gu'a sunqui ba'itoca, aon quëinma'itoca, yua ba sunqui sita ru'rubi cueni, sunquire taonni, toana ëoji. Ja'nca yo'oye'ru gu'a bainni yo'oye ro'taji Riusu, caguë quëabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mësacua gu'a jucha ro'tajën ba'ise'ere beoru jo'cani senjotoca, mësacuare ocona bautizayë yë'ë. Ja'nca bautizaguëta'an, yequë, yë'ë'ru quë'rë ta'yejeiye ëjaguëbi yuara raiye ba'iji. Baguëca yua Riusu Espíritu naconi, toa naconi, mësacuare bautizaja'guë'bi. Quë'rë ta'yejeiye ëjaguëre sëani, yë'ë'ga ro yo'o conguë yo'oye'ru, baguë guëon ju'iyete sacaiye porema'iñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigo aonra'carëan tutuna huëaye'ru yo'oguë raiji. Baguë huëa macabi inni, aonra'carëanre tutuna huëani, hui'ya sëohuëan senjoguëna, trigo aon se'ga baguë aon re'huaruna ayani baji. Ja'nrëbi, hui'ya sëohuëanre chiani, toana senjoni ëoji. Ba toare cato, gare yayaye beoye ba'iji. Baguë bain conjën ba'icuani ja'ncara'ru re'huani baji. Yequëcua conma'icuani toana senjoni ëoji, quëabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ja'nca bautizaguë ba'iguëna, Jesusbi Galilea yijabi rani, Jordañana ti'anni, Juanni bautiza güeseye ro'taguë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ja'nca ro'taguë raiguëna, Juanbi baguëni ënse ëaye cabi: —Yë'ë yua ro yo'o conguëre'ru ba'iguëna, më'ë yua yë'ëni bautizare'ahuë. Ja'nca sëani, ¿më'ë guere ro'taguë yë'ëna raiguë'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Caguëna, Jesús sehuobi: —Re'oji. Yureca Riusu re'oye ro'taguë ba'iyete güina'ru yo'ojën ba'ina'a. Ja'nca sëani, yë'ëre yureca bautizajë'ën, caguë sehuobi. Ja'nca sehuoguëna, Juanbi baguëte bautizabi. ");
INSERT INTO snnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizaguëna, ja'nrëbi Jesús yua ziayabi etabi. Etani, ja'ansirën guënamë re'otore ëñato, pico re'otobi joni a'nqueguëna, Riusu Espíritubi eta rani, ju'ncubo ba'iye'ru ëñoni, Jesusna gaje meni tuabi. ");
INSERT INTO snnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tuaguëna, ja'nrëbi guënamë re'otobi coca achoni raobi: —Ënquë yua yë'ë Zin ai yësi'quë'bi ba'iji. Baguëni ai bojoyë yë'ë, quëani achoni raobi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ja'nrëbi, Jesús yua Riusu Espíritute baguëna, Espíritubi baguëte beo re'otona sabi. Saguëna, zupai huatibi Jesusni coqueza caguë, baguëte choji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús yua cuarenta umuguseñare ja'anrute ba'iguë, gare aon aiñe beoye ba'iguëna, ai aon gu'abi baguëre. ");
INSERT INTO snnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aon gu'a ju'inguëna, ja'nrëbi, zupai huatibi baguëna ti'anni cabi: —Më'ë yua Riusu Zin bani'ga, ën gatabëanre inni, aonbëan'ru re'huani ainjë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Caguëna, Jesusbi sehuobi: —Bañë. Riusu coca ñaca toyani jo'case'e ba'iji: “Aon aiñe se'gabi ba'ima'icua'ë bain. Riusu cocarebare cato, si'ayebi recoyo aon sëani, ja'anbi recoyo huajëreba huajëjën ba'iyë bain” caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sehuoguëna, ja'nrëbi, zupaibi baguëte sani, Riusu huë'e jobo Jerusalén casi jobona ti'anni, Riusu uja huë'e mi'chiyona mëani, nëconi, ");
INSERT INTO snnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","baguëni cabi: —Më'ëbi Riusu Zin bani'ga, yijana chajë'ën. Riusu coca yua ñaca caji: Riusu anje sanhuëni më'ëre cuiraye guanseji. Guanseguëna, gatana junjama'iñe cajën, më'ëre ëñajën cuirajën, më'ëre tëani bayë, toyani jo'case'e ba'iji, cabi zupai. ");
INSERT INTO snnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Caguëna, Jesús sehuobi: —Bañë. Yequëru'ga toyani jo'case'e ba'iji ën coca: “Mai Ëjaguë Riusuni ro coquejën choima'ijë'ën.” Ja'nca toyani jo'case'e sëani, më'ë case'ere yo'oma'iñë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sehuoguëna, ja'nrëbi zupaibi yua baguëte ëmë cubë na'miñona mëani, si'a ën yija re'otoña, ta'yejeiye ba'i joboan ba'iguëna, te'e jëana baguëni ëñoni, ");
INSERT INTO snnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","baguëni cabi: —Ai re'otoña si'ayere më'ëna insini, ba re'otoña ëjaguëre më'ëre re'huayë yë'ë. Yë'ëna gugurini rëantoca, ja'an beoru më'ëna insiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Caguëna, Jesús sehuobi: —Bañë. Yë'ë ba'irubi quëñëni saijë'ën, zupai huati. Riusu coca yua ñaca caji: “Mai Ëjaguë Riusu se'gana gugurini rëanni, baguë se'gani conjën ba'ijë'ën” toyani jo'case'e sëani, më'ë case'e'ru yo'oma'iñë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ja'nca caguë sehuoguëna, zupai huatibi baguëte jo'cani saji'i. Saiguëna, Riusu anje sanhuëbi rani, Jesusre conjën cuirahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ja'nrëbi, Jesús yua Juan ba'iyete achato, preso zeansi'quë baji'i. Ja'nca ba'iguëna, ja'nrëbi Jesús yua Galilea yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sani, Nazaret huë'e jobore jo'cani, Capernaum huë'e jobona ti'anni, baruna bëani baji'i. Capernaum yua jai zitara yëruhua baji'i. Zabulón, Neftalí, ja'an yija re'oto huë'e jobo baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Riusu ira bainguë raosi'quë Isaías hue'eguë ba'isi'quëbi coca toyani jo'caguëna, yure güina'ru yo'obi Jesús. Isaías coca toyani jo'case'e yua ñaca baji'i: ");
INSERT INTO snnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón yija, Neftalí yija, ja'an yijaña yua jai zitara yëruhua ba'i ma'a ca'ncorëte ba'iji. Jordaña que ca'ncona ti'anji. Ja'an yija si'aye yua Galilea casi yija ba'iguëna, judío bain jubë ba'ima'icuabi ja'anruna ti'anjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ja'an yija bain yua Riusu ba'iyete ro huesë hua'na ba'ijën, zijei re'oto ba'iye'ru baë'ë. Ja'nca ba'icuabi, ai mia re'oto ëñoguëna, ai bojojën ëñahuë. Junni huesëse'e'ru ba'icuabi, zijeibëte ba'ijën, ai sa'nti hua'na ba'ijënna, mame umuguse ñatani saoye'ru bacuani ëñose'e ba'iji. Ja'nca ëñose'e ba'iguëna, ai bojoye huanoji bacuare, toyani jo'cabi Isaías. Toyani jo'caguëna, Jesús yua baruna yure ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti'anni, ja'nrëbi, si'a bainni quëani acho bi'rabi: —Riusu ba'i jobo ëñoja'ñe yurera ti'anja'ñeta'an ba'iji. Ja'nca sëani, mësacua gu'a juchare jo'cani, mësacua ro'tajën ba'ise'e beoru mame re'huani ba'ijë'ën, quëani achoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ja'nrëbi, Jesús yua Galilea zitara yëruhuana sani, mejabëbi ganiguë, ëñato, Simón caguëbi, baguë yo'jeguë Andrés hue'eguë naconi ba'ijën, hua'ire yojën baë'ë, hua'i yoye ye'yesi'cua sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hua'ire yojënna, Jesusbi bacuani coca caguë choji'i: —Mësacua yua yë'ëni te'e conjën raijë'ën. Mësacua yua hua'i yoye ye'yesi'cua ba'ijënna, bainre yoye mësacuani ye'yoyë yë'ë, caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Caguë choiguëna, bacua hua'i yorëanre ja'ansiruna gare jo'cani, baguëni te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Saijënna, baguëbi se'erë sani ëñato, Zebedeo mamacua samucua, Santiago hue'eguë, baguë yo'jeguë Juan naconi baë'ë. Bacua pë'caguë Zebedeo naconi yogute ba'ijën, bacua hua'i yorëanre ta'nëjën ñuë'ë. Ja'nca ñu'ijënna, Jesusbi bacuani choji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Choiguëna, bacuabi ja'ansirën bacua pë'caguëte jo'cani saë'ë. Ba yogute gare jo'cani, Jesusni te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ja'nrëbi, Jesús yua si'a Galilea yijana saiguë, bain ñë'ca huë'eñana cacani ye'yoguë, Riusu ba'i jobore bojo cocare quëani achoguë, si'a rau bacuare huachoguë ganiguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ja'nca yo'oguë ba'iguëna, si'a bain Siria yijare ba'icuabi achani, bacua bain rauna ju'incua, ja'si yo'ocua, huati bacua, hue'nhue rau bacua, gara rau bacua, ja'ancuare Jesusna sani ëñohuë. Sani ëñojënna, bacuare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huachoguëna, ja'nrëbi, yequëcua ai jai jubë bain, Galilea yija, Decápolis yija, Jerusalén huë'e jobo, Judea yija, Jordaña que ca'nco, si'aruan ba'icuabi Jesús naconi te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bain jubëbi raijënna, Jesusbi bacuare ëñani, cubë na'miña quëñëni mëji'i. Mëni ti'anni bëaguëna, baguë bain concuabi baguëna ti'an raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Raijënna, Jesusbi yihuo cocare bacuani ye'yoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ro porema'i hua'nabi Riusu Espíritute cu'etoca, ai bojoreba bojojën ba'iyë. Riusu ba'i jobo ëjacua'ru ruinja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bain gu'a juchare ro'tajën ota oitoca, ai bojoreba bojojën ba'iyë. Riusubi bacua oiyete senjoni jo'caja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Riusu yëye se'gare yo'oye cu'ejën ba'itoca, ai bojoreba bojojën ba'iyë. Bacua yua ëja bain ba'iye cu'ema'iñe cayë. Riusubi si'a yija ëjacuare bacuare re'huaguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aon gu'ana ju'incua aon cu'eye'ru re'oye yo'oye ai cu'ejën ba'itoca, ai bojoreba bojojën ba'iyë. Riusubi yajisi'cuare bacuare re'huaguë ba'ija'guë'bi. Riusubi re'oye yo'oye bacuare conja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bainni ai oijën conjën ba'itoca, ai bojoreba bojojën ba'iyë. Riusubi bacuare'ga ai oiguë conguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Gu'a jucha gare yo'oye beoye ba'itoca, ai bojoreba bojojën ba'iyë. Ja'an ba'icuabi Riusuni ëñajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bainni sa'ñeña bojo güesejën ba'itoca, ai bojoreba bojojën ba'iyë. Bacua yua Riusu mamacua casi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yequëcuabi yë'ë bain re'oye yo'oyete ëñani, bacuani je'o batoca, yë'ë bainbi ai bojoreba bojojën ba'iyë. Riusu ba'i jobo ëjacua ruinja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mësacuare'ga je'o bani, mësacuani hui'ya cani, yë'ëre concua ba'iyete ai bëinjën, ro coquejën, gu'aye cajën ba'itoca, mësacua'ga bojoreba bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Riusu ira bain raosi'cuare'ga ai gu'aye yo'ojën baë'ë, ja'anrë. Yureca, mësacuare'ga ai je'o bajën ba'ija'cua'ë. Ja'nca ba'ijënna, mësacua yua Riusu ba'i jobona ti'anni, baguë bayete ro coreba coja'cua sëani, mësacua ai bojoreba bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mësacua yua onhua huanoñe'ru bainni re'oye ëñojën ba'icua'ë. Ja'nca ëñojën, re'oye yo'ojën ba'ijënna, bacuabi huaji yëjën, gu'aye yo'oye yëma'iñe. Ja'nca ëñojën ba'icuata'an, onhua huanoñebi carajeitoca, se'e mame re'huaye gare porema'iñë. Gu'a onhua ba'itoca, senjoñe se'ga ba'iji, bain za'nguruna. ");
INSERT INTO snnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mësacua yua mia re'oto ëñoñe'ru ba'ijën, bainni re'oye ëñojën ba'icua'ë. Huë'e jobote cubëna yo'otoca, si'a bainbi ëñañe poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Majahuëte zëonni, guënarobi meñe jaoni ta'pimajën ba'iyë mai. Si'a huë'e bainbi ëñaja'bë cajën, ëmëna reoyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ja'nca sëani, mësacua yua mia re'oto ëñoñe'ru, bainni re'oye ëñojën ba'ijë'ën. Ja'nca ëñojën ba'itoca, bainbi mësacua re'oye yo'ojën ba'iyete ëñani, mësacua Taita Riusu guënamë re'otore ba'iguëte ro'tani, Riusu ta'yejeiye ba'iyete ai re'oye cajën bojoyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Riusu ira guansesi coca toyani jo'case'e, Riusu ira bain raosi'cua toyani jo'case'e, ja'anre cato, gare quëñoni senjoguë raimaë'ë yë'ë. Ba coca case'e yua Riusu te'e ruiñe ba'i coca ba'iji. Ja'anre bainni masi güeseguë raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ja'an cocare cato, guënamë re'oto, yija re'oto carajeiye tëca, te'e cocara'huërëte gue toñe beoye ba'ija'guë'bi. Ru'ru Riusu coca cani jo'case'e'ru si'aye güina'ru yo'ose'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja'nca sëani, bainguëbi te'e guansesi coca cani jo'case'e'ru tin yo'oni, yequëcuani tin yo'oye ye'yotoca, ja'anguëbi yua Riusu ba'iruna ti'anni quë'rë yo'jereba ba'iguë hue'eguë ba'ija'guë'bi. Bainguëbi si'a guansesi coca cani jo'case'ere te'e ruiñe yo'oni, yequëcuani te'e ruiñe yo'oye ye'yotoca, ja'anguëbi Riusu ba'i jobona ti'anni, quë'rë jaiguëreba ba'iguë hue'eguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mësacuani ganreba yihuoguë cayë yë'ë. Ira coca ye'yocua, fariseo bain, bacua re'oye yo'oye'ru quë'rë re'oye yo'ojën ba'ima'itoca, mësacuabi yua Riusu ba'i jobona ti'añe porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mësacua yua ira coca guanseni jo'case'ere achani masiyë. Bainre huani senjoñe beoye ba'ijë'ën, caji. Bainre huani senjotoca, Riusu bënni senjoñe ba'ija'guë'bi. Ja'an coca guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ja'nca ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë cayë: Mësacua bainni bëinjën ba'itoca, bënni senjoñe mësacuare ba'ija'guë'bi. Mësacua bainni gu'aye catoca, ëja bain bënni senjoñe mësacuare ba'ija'guë'bi. Mësacua bainni, Gu'a bainguë'ë më'ë, mësacuabi catoca, Riusubi bënni, baguë toana senjoni ëoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ja'nca ba'iguë sëani, më'ëbi më'ë gue jo'ya ma'carëte Riusuna ro insiza caguë, misabëna sani jo'ca bi'rani, ja'nrëbi më'ë bainguë bëinguë ba'iyete ro'tatoca, ");
INSERT INTO snnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","më'ë gue ma'carë bayete Riusuna insima'ijë'ën. Ja'anre ru'ru ca'ncorëna jo'cani, ja'nrëbi më'ë bainguëna sani, baguëni menajë'ën. Baguë naconi te'e bojoguë ba'ijë'ën. Ja'nca ba'iguë, ja'nrëbi yo'je, Riusu misabëna sani, më'ë gue ma'carë bayete Riusuna ro insiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yequëbi rani, më'ë gu'aye yo'oye më'ëni cani, më'ëre ëja bainna sa ëaye yo'otoca, ru'ru baguëni besa ro'ini baguëni menajë'ën. Ja'nca yo'oma'itoca, baguë yua ëja bainguë bënni senjoñete më'ëre jo'caji. Jo'caguëna, ëja bainguëbi më'ëre soldado ëjaguëna insiji. Insiguëna, soldado ëjaguëbi më'ëre preso zeanni, ya'o huë'ena guaoji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Guaoguëna, më'ë si'a curi ro'iye tëca gare etaye beoye ba'iyë. Ja'anre si'a jëja yihuoguë cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mësacua yua ira coca guanseni jo'case'ere achani masiyë. Romini yahue baye beoye ba'ijë'ën caji. Ja'an coca guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ja'nca ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë cayë: Yeconi yahue ba ëaye gu'aye ro'taguë ba'itoca, yua gu'a bainguë ruiñë më'ë. Bagoni yahue basi'quë'ru gu'aye yo'osi'quë ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Më'ë jëja ñacogabi gu'a juchare yo'o ëaye ro'tatoca, më'ë ñacogate rutani senjojë'ën. Te'e ñacoga se'gare beoguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji më'ëre. Si'a më'ë ga'nihuë Riusu toana senjoni ëose'e ba'itoca, quë'rë ai gu'aye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Më'ë jëja ëntë sarabi gu'a juchare yo'o ëaye ro'tatoca, më'ë ëntë sarare tëyoni senjojë'ën. Te'e ëntë sara se'gare beoguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji më'ëre. Si'a më'ë ga'nihuë Riusu toana senjoni ëose'e ba'itoca, quë'rë ai gu'aye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ira coca guanseni jo'case'e yua ñaca'ga caji: “Më'ë rënjore jo'cani senjotoca, ru'ru senjo cocare utina toyani, bagona insijë'ën” caji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ja'nca case'e ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë cayë: Si'a bain rënjore jo'cani senjocua, bagobi yequëni yahue bama'itoca, ja'ancuabi bagoni ai gu'aye yo'oyë. Bagote gu'a romigore re'huayë. Y si'a bain jo'cani senjosi'coni huejani bacua, ja'ancua yua bagoni yahue baye'ru bajën ba'icua'ë, cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mësacua yua ira coca guanseni jo'case'ere achani masiyë. Mësacuabi Riusuni cuencueni ganreba catoca, ro coqueye beoye Riusuni cuencueni ganreba cajën ba'ijë'ën. Riusuni cuencueni case'e'ru güina'ru yo'ojën ba'ijë'ën, guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ja'nca ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë quëayë: Mësacua yua ganreba coca canica, Riusuni cuencueye beoye ba'ijë'ën. Guënamë re'oto mamire cuencueye beoye ba'ijë'ën, Riusu jëja ba'i jobo sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yija re'oto mamire'ga cuencueye beoye ba'ijë'ën, mai Ta'yejeiye Riusu jëja guanseguë ba'i jobo sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mësacua sinjobëre'ga cuencueye beoye ba'ijë'ën. Mësacua yua te'e raña ju'inse'e re'huaye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ja'nca sëani, mësacuabi “Ja'nca ba'iji” caye yëtoca, ja'an se'gare cajë'ën. Mësacuabi “Bañë” caye yëtoca, ja'an se'gare cajë'ën. Quë'rë jëja catoca, gu'aye se'ga cayë, yihuoguë cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mësacua yua ira coca guanseni jo'case'ere achani masiyë. Yequëbi më'ëni ja'si yo'otoca, më'ë ñacogare totaye, o më'ë gunjiñëre hua'huaye, ja'anre yo'otoca, më'ë yua baguëni güina'ru ja'si yo'o güeseye poreyë, guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ja'nca ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë quëayë yë'ë: Më'ëni gu'aye yo'oguëni güina'ru baguëni gu'aye yo'oye beoye ba'ijë'ën. Yequëbi më'ë jëja huayohuana huaitoca, yequë huayohuare'ga baguëna bonëni huai güesejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yequëbi më'ë ëntë sara canre tëatoca, më'ë guayoni se canre'ga baguëna insijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yequëbi baguë carga te'e kilómetro hue'oye më'ëni guansetoca, baguë naconi samu kilómetro hue'oni saiguë bojojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yequëbi bonsere sentoca, baguëna insijë'ën. Yequëbi më'ë bonsere prestaye sentoca, baguëni ënseye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mësacua yua ira coca guanseni jo'case'ere masiyë. Mësacua gaje bainni ai yëjën ba'ijë'ën. Mësacuare je'o bacuani ai güereba güejën ba'ijë'ën, guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ja'nca ba'iguëta'an, yë'ëca mësacuani ñaca yihuoguë quëayë: Mësacuare je'o bacuani quë'rë yëjën ba'ijë'ën. Mësacuani bëinjën ganicuata'an, bacua ba'iyete Riusuni ujajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja'nca re'oye yo'ojën ba'itoca, mësacua Taita Riusu guënamë re'oto ba'iguëbi baguë mamacuare mësacuare re'huani baji. Baguë yua gu'a bain re'o bain, si'acuani te'e cuiraguë conji. Ënsëguëte mia güeseguë, oco güeseguë, si'acuana jo'caguë, te'e conji. ");
INSERT INTO snnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mësacuani ai yëjën ba'icua se'gani ai yëjën ba'itoca, Riusu ro insija'ye ai caraji mësacuare. Impuesto curi tëacua, ja'ancua yua gu'a bain ba'icuata'an, bacuabi sa'ñeña ai yëjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mësacua bain se'gani saludaye cajën ba'itoca, ai caraji mësacuare. Ro ën yija bain yo'oye'ru quë'rë yo'omajën ba'iyë mësacua. Judío bain jubë ba'ima'icua'ga ja'anre yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mësacua yua te'e ruiñereba yo'ojën ba'ijë'ën. Mësacua Taita Riusu, guënamë re'oto ba'iguëbi te'e ruiñereba yo'oguë ba'iye'ru, güina'ru yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mësacuabi re'oye yo'oto, bainbi ëñaja'bë gare ro'taye beoye ba'ijën, mësacua re'oye yo'ojën ba'ijë'ën. Ja'nca ro'tajën ba'itoca, mësacua Taita Riusu guënamë re'otore ba'iguëbi mësacua coja'yete gare insima'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ja'nca sëani, mësacua yua bonse beo hua'nana curi insijën, yequëcuani quëaye beoye ba'ijë'ën. Yequëcuabi ja'nca yo'ojën ba'iyë. Yëquëna yua re'o bain'ë cajën, ro coquejën, bain ñë'ca huë'eña, huë'e joboreba ba'iruan, bain ba'iruanna sani, yëquëna re'oye yo'oyete ëñani re'oye caja'bë cajën, curi beo hua'nana curi insiyë. Ja'nca yo'ojën, Riusu insija'yete coñu ro'tacuata'an, Riusuna coye beoye ba'ija'cua'ë bacua. Ja'nca ro'tajën yo'oye'ru mësacua yo'oye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Curi beo hua'nana curi insinica, mësacua yua caye beoye ba'ijën, ");
INSERT INTO snnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ro yahue insijën ba'ijë'ën. Ja'nca insijën ba'itoca, mësacua Taita Riusu se'gabi ëñani, baguë bayete mësacuana insireba insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mësacua yua Riusuni ujato, yequëcuabi yë'ë ujayete ëñaja'bë ro'taye beoye ba'ijë'ën. Yequëcuabi ja'nca yo'ojën ba'iyë. Yëquëna yua re'o bain'ë cajën, ro coquejën, bain ñë'ca huë'eña, huë'e joboreba ba'iruan, bain ba'iruanre nëcani ujaye ai yëyë bacua. Ja'nca yo'ojën, Riusu insija'yete coñu ro'tacuata'an, Riusuna coye beoye ba'ija'cua'ë bacua. Ja'nca ro'tajën yo'oye'ru mësacua yua yo'oye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mësacuabi Riusuni ujato, mësacua cain sonohuëna cacani, anto sa'rore ta'pini, ja'nrëbi te'e hua'guë ba'iguëbi yua më'ë Taita Riusuni yahuera'rë ujajë'ën. Ja'nca ujajënna, më'ë Taita se'gabi ëñani, baguë bayete më'ëna insireba insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Riusuni ujato, zoe raijeiyereba ujaye beoye ba'ijë'ën. Gu'a bainbi ai zoe raijeiyereba uja cocare cani achotoca, Riusubi quë'rë re'oye achaji ro'tajën, ro ta'yejeiye cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mësacua yua bacua ujajën caye'ru caye beoye ba'ijë'ën. Mësacua Taita Riusuni senni achajënna, baguëbi mësacua carayete ru'ru masiji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ja'nca sëani, mësacua yua ñaca ujajën ba'ijë'ën: Yëquëna Taita, guënamë re'otore ba'iguëna, si'acuabi më'ë ta'yejeiye ba'iyete ruiñereba ro'tajën ba'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Më'ë ba'i jobo yuara yëquënana ti'anja'guëta'an ba'ija'guë. Si'acua ën yija ba'icuabi më'ë yëye'ru yo'ojën ba'ija'bë, guënamë re'oto ba'icua yo'ojën ba'iye'ru. ");
INSERT INTO snnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yëquëna aon aiñe, yure umuguse aiñete insijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yëquëna gu'aye yo'ose'ere huanë yeni ro'tama'ijë'ën. Yëquënabi yequëcua gu'aye yo'ose'ere huanë yeni ro'tamajën ba'iye'ru, më'ë'ga ja'nca yo'ojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ai guaja ba'iyete yëquënani jo'cama'ijë'ën. Yëquënani gu'a ma'a ganiñete quëñoni bajë'ën. Më'ë se'gabi ta'yejeiyereba pore ëjaguë sëani, më'ëni caraye beoye go'sijei cocare cani tonjën bojojën bañuni. Ja'nca raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mësacuabi Riusuni ujajën, mësacuani gu'aye yo'osi'cua banica, bacua gu'aye yo'ose'ere huanë yeye cajë'ën. Ja'nca catoca, mësacua Taita Riusu guënamë re'oto ba'iguëbi mësacua gu'aye yo'ose'ere'ga huanë yeye caji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mësacuabi ja'nca huanë yeye cama'itoca, mësacua Taita Riusu guënamë re'oto ba'iguëbi mësacua gu'aye yo'ose'ere gare huanë yema'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mësacuabi aon aiñe jo'canica, ro sa'nti hua'na'ru ëñojën ba'ima'ijë'ën. Yequëcuabi ja'nca yo'ojën ba'iyë. Yëquëna yua re'o bain'ë cajën, ro coquejën, yëquëna aon aiñe jo'cayete ëñani yëquëna re'oye yo'oyete masija'bë cajën, bacua ziañare sa'nti ziaña ba'iye'ru ai yo'ojën re'huayë. Ja'nca yo'ojën, Riusu insija'yete coni bañu ro'tacuata'an, Riusuna coye beoye ba'ija'cua'ë bacua. Mësacua yua bacua yo'ojën ba'iye'ru yo'oye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mësacuabi aon aiñe jo'canica, Bainbi masima'ija'bë cajën, mësacua sinjobëte ëcobi so'onni, mësacua ziare zoani, yahue aon aiñe jo'cajë'ën. Mësacua Taita Riusu se'gabi masija'guë cajënna, baguë se'gabi ëñani, baguë bayete mësacuana insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ën yija bonse yua ro bu'juni si'aji. Ro pu'ncani si'aji. Jiancuabi ro inni sayë. Ja'nca sëani, ja'an bonsere ro bëyoni baye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Riusu ba'i jobo baja'yete quë'rë ro'tajën ba'ijë'ën. Ja'anre cojënna, gare bu'juma'iñe ba'ija'guë'bi. Gare pu'ncani si'ama'iñe ba'ija'guë'bi. Jiancuabi gare inni saye porema'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Riusu ba'i jobo baja'yete ro'tajën ba'itoca, ai recoyo bojojën ba'iyë mësacua. Ën yija bonsere ro'tajën ba'itoca, ja'an se'gare coni baja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mësacua ñaco yua recoyo majahuë'ru ba'iji. Mësacua ñacobi te'e ruiñe yo'oye yëtoca, si'a recoyo yua miañereba miaji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mësacua ñacobi gu'aye yo'oye yëtoca, si'a recoyo yua zijepë'ru ruinji. Ja'nca sëani, mësacua yua ëñare bajën, re'oye ro'tajën ba'ijë'ën. Yequërë mësacuabi mia recoyo baye ro'tacuata'an, ¡zijei recoyo se'ga bajën ba'ima'iñe! ");
INSERT INTO snnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Samu ëjacuani sehuoye mësacua porema'iñë. Ja'nca sehuojën ba'itoca, yequëni ai gu'aye ro'tani, yequëni ai yëreba yëyë. Ru'ru ba'iguëni conreba conni, yequëni ai je'o bayë mësacua. Ja'nca sëani, Riusuni ai yëjën ba'itoca, bonsere te'e yëye porema'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yureca, mësacuani yihuoreba yihuoyë yë'ë. Mësacua bonse carayete oiye beoye ba'ijë'ën. Mësacua aon aiñe, gono uncuye, can ju'iye, ja'anre oiye beoye ba'ijë'ën. Riusubi mësacuare ro aon aincuare re'huamaji'i. Riusubi mësacua ga'nihuëanre re'huaguë, ro caña ju'iye se'ga re'huamaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mësacua yua bi'an hua'na ba'iyete ëñani ye'yejë'ën. Ba hua'nabi aon tanma'icua ba'iyë. Aon tëama'icua ba'iyë. Aon aya huë'eña beoyë. Ja'nca ba'icuareta'an, mësacua Taita Riusu guënamë re'otore ba'iguëbi bacua aonre insiji. Ja'nca insiguëbi mësacuare ro'taguë, bi'an hua'nani bojoye'ru mësacuani quë'rë ta'yejeiye bojoguë ro'taguë cuiraji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mësacua bonse carayete oitoca, gare quë'rë zoe ba'iye mësacua porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Mësacua queaca ro'tajën, caña ju'iyete coni baja'ma cajën oiye'ne? Jo'ya corore irayete ëñani ye'yejë'ën. Jo'ya coro se'gabi re'o canre tëonma'iji. Riusubi jo'ya coro re'oye ëñoñe jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mai ira bonse ëjaguë ba'isi'quë, Salomón hue'eguë ba'isi'quë, baguë caña ju'iguë ba'ise'e yua ai re'o cañara ba'ise'eta'an, jo'ya corobi ta'yejeiye ai re'oye ëñoji. ");
INSERT INTO snnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Riusu se'gabi jo'ya corore cuiraji. Yure umuguse jorini, ja'nrëbi miato güeanni si'aguëreta'an, Riusubi jo'ya corore ai re'oye cuiraji. Ja'nca cuiraguëbi mësacuare'ga quë'rë ta'yejeiye ai re'oye cuiraye masiji. Ja'nca sëani, mësacua ro ro'tajën ba'iyete jo'cani, baguëni si'a recoyo ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Riusubi mësacuani ai re'oye cuiraye masiguë sëani, mësacua bonse carayete oiye beoye ba'ijë'ën. “Aonre bani ainja'ma, gonore bani uncuja'ma, cañare bani ju'ija'ma” ja'anre caye beoye ba'ijën, bonsere oimajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gu'a bain se'gabi ja'an bonsere cu'ejën ba'ijënna, mësacua bonse caraye si'ayete masiji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ja'nca ba'iguëna, Riusu ba'i jobo ba'iyete ru'ru si'arën ro'tajën, baguë re'oye yo'oye'ru re'oye yo'ojën ba'ijë'ën. Ja'nca yo'ojën ba'itoca, mësacua bonse caraye si'ayete mësacuana insireba insija'guë'bi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mësacua miato ba'ija'yere'ga oiye beoye ba'ijë'ën. Miato ti'añe tëca ëjoni, ja'nrëbi ja'an umuguse ba'iyete ro'taye poreyë. Yure umuguse ba'iye ai yo'ojën ro'taye se'gare ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yequëcua gu'aye yo'ose'ere cama'ijë'ën. Ja'nca cama'itoca, Riusubi mësacua gu'aye yo'ose'ere cama'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mësacuabi yequëcua gu'aye yo'ose'ere bëinjën cajënna, Riusubi güina'ru mësacua gu'aye yo'ose'ere bëinguë caja'guë'bi. Mësacua cuencue ro'rohuëbi güina'ru cuencueni insiguëna, Riusubi ja'ansi ro'rohuëbi cuencueni mësacuana insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Më'ë bainguë ñacogana ëñani, Hui'yara'carëte rutacaza caguë, yua jai hui'ya maca më'ë ñacogate ba'iguëna, ja'anre ro ro'taguë rutama'itoca, ¿queaca më'ë bainguë ñaco ba'i macare rutacaiguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Më'ë ñaco ba'i macare rutaye ro'tama'itoca, ro coqueguë yihuoyë më'ë. Ru'ru më'ë ñacoga ba'i maca, ja'anre rutani, ja'nrëbi, ai re'oye ëñañe poreguëbi sani, më'ë bainguë ñacogana re'oye ëñani, baguë hui'yara'carëte guaja beoye rutacaiye poreyë më'ë. Më'ë bainguë jucha yo'ose'ere senjoñe yihuoye yënica, ru'ru më'ë gu'a juchare jo'cani senjojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Riusu insini jo'case'ere gu'aye yo'ocuana insima'ijë'ën. Jo'ya yai hua'nana insiye'ru ba'iji. Bacuabi ro coca yo'oni, mësacuani cuncuyë. Ai re'o gatara'carëan ai ro'ira'carëan cuchi hua'nana insiye'ru ba'iji. Bacuabi ro za'nguni senjoñë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mësacua yëyete jo'caye beoye senreba sentoca, Riusubi insiji. Mësacua yëyete jo'caye beoye cu'ereba cu'etoca, mësacua cu'eyete tinjañë. Huë'ena ti'anni, jo'caye beoye je'njuni achotoca, huë'e ba'icuabi mësacuana ancoyë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Riusuni jo'caye beoye sentoca, Riusubi insiji. Riusuni jo'caye beoye cu'etoca, Riusu ba'iyete tinjañë. Riusu anto sa'rona jo'caye beoye je'njuni achotoca, Riusubi ancoji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mësacua zin hua'nabi aonbëte mësacuani sentoca, ¿gatabëte insiye mësacua? Bañë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ziaya hua'ire sentoca, ¿añare insiye mësacua? Bañë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mësacua yua gu'a bain ba'icuabi mësacua zin hua'nana re'o aon insiye masicuata'an, mësacua Taita Riusu guënamë re'oto ba'iguëbi yua, si'acua baguëni senni achajënna, bacuana quë'rë ta'yejeiye baguë bayete ai re'oye insiye masiji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ja'nca ba'iguëna, yequëcuani re'oye yo'oye cato, bacua yua mësacua yëye'ru mësacuani re'oye yo'ojënna, mësacua'ga güina'ru bacuani re'oye yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Se'e baguë bainni ye'yoguë yihuobi Jesús. Mësacuabi Riusu ba'i jobona ti'anni carajeiye beoye ba'iye yënica, rëño sa'robi cacajë'ën. Yequë sa'ro jai sa'ro sëani, ai jai jubë bainbi cacani, jai ma'aja'an guaja beoye ganicuata'an, gare huesëni ñaca ba'iruan carajeiyë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ba rëño sa'robi cacato, ba ai yo'ojën ba'i ma'aja'an ai guaja ganicuata'an, Riusu ba'i jobona ti'anni carajeiye beoye ba'ijën, huajëreba huajëjën ba'ija'cua'ë. Rëño jubë bain se'gabi ja'an ma'are tinjani ganini ti'añë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yequëcuabi rani, Riusu coca quëacua'ë yëquëna ro coquejën cajënna, mësacua ëñare bajë'ën. Bacua yua Riusu bain ba'iye, oveja hua'na ba'iye, ja'an ba'iye'ru ëñocuata'an, airu yai hua'na yo'oye'ru Riusu bain jubëte ro huesoni si'aye ro'tajën raiyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bacua yo'o yo'oyete ëñani, bacua ba'iyete masiye poreyë mësacua. Sunqui quëiñete ro'tani, bacua ba'iyete masiye poreyë. Miu sunquiñare ëñato, ëyere tinjama'iñë. Susina ëñato, higo uncuere tinjama'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Re'o sunqui banica, re'o uncue quëinji. Gu'a sunqui banica, gu'a uncue quëinji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Re'o sunqui banica, gu'a uncue gare quëinma'iji. Gu'a sunqui banica, re'o uncue gare quëinma'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Si'a sunqui yua re'o uncue quëinma'itoca, ro cueni taonni, të'cani, toana senjoni ëose'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ja'nca sëani, güina'ru re'o bain, gu'a bain, bacua ba'iyete masiye yënica, bacua yo'o yo'ojën ba'iyete ëñani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ai jai jubë bainbi yë'ëni, Ëjaguë, Ëjaguë cajën ba'icuata'an, bacua yua Riusu ba'i jobona gare ti'anma'ija'cua'ë. Yë'ë Taita Riusu guënamë re'oto ba'iguë, baguë yëye'ru yo'ojën ba'icua, ja'ancua se'gabi baguë ba'i jobona ti'anja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yë'ë ëñojai umugusebi ti'anguëna, ai jai jubë bainbi yë'ëni cajën ba'ija'cua'ë: “Ëjaguë, Ëjaguë, yëquëna ai re'oye yo'ojën ba'ise'ere masiyë më'ë. Më'ë ba'iyete ro'tajën, më'ë cocare quëani achojën baë'ë. Më'ë ba'iyete ro'tajën, huati hua'ire etoni saojën baë'ë. Më'ë ba'iyete ro'tajën, ai ta'yejeiye yo'o yo'ojën, bainni ëñojën baë'ë yëquëna. Ja'nca sëani, më'ëna ti'ansi'cua'ë yëquëna” cajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ja'nca cajën ba'ijënna, yë'ëbi bacuani bëinguë sehuoja'guë'ë: “Mësacuare huesëguë'ë yë'ë. Yë'ë ba'iru quëñëni saijë'ën. Ro gu'aye yo'ojën ba'icua'ë mësacua” sehuoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ja'nca sëani, yë'ë coca case'ere achani te'e ruiñe yo'ocua ba'iyete cato, gatabana huë'e yo'osi'quë'ru ba'iyë bacua. Masiguëbi ja'nca yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ja'nca yo'oguëna, ja'nrëbi ai tëñe ocoguëna, ai co'jeya raiguëna, ai jëja tutuguëna, ba huë'ebi tainmaji'i. Jai gatabana gui'isi huë'e sëani, ai jëja babi. ");
INSERT INTO snnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yequëcua yë'ë coca case'ere ro achani te'e ruiñe yo'oma'icua ba'iyete cato, mejabëna huë'e yo'osi'cua'ru ba'iyë bacua. Ro ro'tajën ba'i hua'nabi ja'nca yo'oyë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ja'nca yo'ojënna, ja'nrëbi ai tëñe ocoguëna, jai co'jeya raiguëna, ai jëja tutuguëna, ba huë'ebi ma'mani gurujaji'i. Ai jëja gurujani meani huesëbi” cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja'nca caguë, baguë yihuo cocare cani tëjibi. Tëjiguëna, si'a bain hua'nabi ai bojojën achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bacua ira coca ye'yocua ye'yojën ba'ise'e'ru quë'rë ai ta'yejeiyera ye'yoguë baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ja'nrëbi, Jesusbi ba cubëbi gajeguëna, ai jai jubë bainbi baguë naconi saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Saijënna, yureca yequëbi, gu'a ca'nmi rauna ju'inguëbi Jesusna ti'anni, baguëna gugurini rëanni, baguëni cabi: —Ëjaguë, më'ëbi yë'ëre onica, yë'ë gu'a raure tënoni huachojë'ën, huachoye poreguë sëani, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Caguëna, Jesusbi baguë ëntë sarare mi'nani, baguëni pa'roni cabi: —Më'ëni oiguë huachoyë yë'ë. Huajë hua'guë ba'ijë'ën, cabi. Caguëna, ja'ansi'quë baguë gu'a ca'nmi rau yua gare tënosi'quë baji'i. Huajë raji'i baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Huajë raiguëna, Jesusbi baguëni yihuoguë cabi: —Achajë'ën. Më'ë huajë raise'ere yequëcuani gare quëaye beoye ba'ijë'ën. Ëñe se'gare yo'ojë'ën. Pairina sani, më'ë huajë raise'ere ëñojë'ën. Ëñoni, Moisés ira coca guanseguë ba'ise'e'ru, jo'ya hua'guë case'ere inni, pairini quëani achoni, misabëna tëoni ëocaija'guë caguë, pairina insijë'ën, më'ë yua huajë raisi'quë sëani. Ja'nca yo'otoca, bain hua'nabi më'ë huajë raise'ere ëñani masiyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja'nca cani, ja'nrëbi sani, Capernaum huë'e jobona ti'anbi. Ti'anguëna, soldado ëjaguëbi baguëna ti'an rani, ");
INSERT INTO snnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cocare senni achaguë cabi: —Ëjaguë, yë'ë yo'o conguëbi huë'ere ba'iguë, garasi'quë uinguë, ai yo'oji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Caguëna, Jesusbi: —Ja'nca ba'ito, baguëni huachoguë saiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Caguëna, soldado ëjaguëbi ënseguë cabi: —Yë'ë huë'ena raima'ijë'ën, Ëjaguë. Më'ë yua ai ta'yejeiye ëjaguëte sëani, yë'ë huë'ena caca güeseye porema'iñë yë'ë. Si'aye ëñaguë sëani, so'obi ëñani huachojë'ën. Ja'nca huachoye catoca, yë'ë yo'o conguëbi huajë raija'guëbi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yë'ë yua ja'nca senni achaguëbi yequëcua yë'ë ëjacuani sehuoye bayë. Yequëcua soldado hua'nani guanseye bayë yë'ë. Te'e soldado hua'guëni, Saijë'ën catoca, baguë saiji. Yequëni, Raijë'ën catoca, baguë raiji. Yë'ë yo'o conguëni, Yë'ë case'e'ru yo'ojë'ën catoca, güina'ru yo'oji baguë. Ja'nca sëani, më'ë raima'ijë'ën caguë señë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja'nca caguëna, Jesús yua gue ro'taye beoye achaguë, yua bain jubë baguë naconi raisi'cuana bonëni, bacuani yihuoguë cabi: —Ënquë soldado ëjaguëbi yë'ëni ai ta'yejeiye recoyo ro'taji. Si'a Israel bain recoyote ëñato, baguë recoyo ro'taye'ru ai caraji bacuare. ");
INSERT INTO snnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mësacuani ganreba cayë yë'ë. Ai jai jubëan bain yequëruan bain ti'an raisi'cua yua Riusu ba'i jobona ti'anni, Abraham, Isaac, Jacob, bacua naconi guënamë re'otona ñë'cani aonre ainjën bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ja'nca ba'ijënna, Israel bainreba Riusu cuencuesi'cuata'an, bacuabi ti'ani raisi'cuana bonëni, bacuani yihuoguë cabi: —Ënquë soldado ëjaguëbi yë'ëni ai ta'yejeiye recoyo ro'taji. Si'a Iñe porema'ija'cua'ë. Zijei re'otoreba ba'iruna bënni senjosi'cua ba'ija'cua'ë. Ja'nca ba'icuabi ai oijën, zemeñoana cuncujën, ai yo'ojën ba'ija'cua'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ja'nca cani, ja'nrëbi soldado ëjaguëna bonëni, baguëni cabi: —Yua më'ë huë'ena go'ijë'ën. Më'ëbi si'a recoyo ro'taguëna, güina'ru yo'ose'e ba'iji, cabi. Caguëna, baguë yo'o conguëbi te'e jëana huajë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ja'nrëbi, Jesús yua Pedro huë'ena cacani ëñato, Pedro huagobi rau jayoni unco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ja'nca uingona, Jesusbi bago ëntë sarana pa'robi. Pa'roguëna, bago rau jayoye tëni saji'i. Tëni saquëna, bagobi huajë hua'go huëni, baguëni cuira bi'rago. ");
INSERT INTO snnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ja'nrëbi na'iguëna, ai jai jubë bain huati bacuare Jesusna sani ëñohuë. Ëñojënna, baguë yua te'e coca se'ga cani, huati hua'ire etoni saobi. Saoni, si'a rauna ju'incuare'ga huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ja'nca huachoguëbi Riusu ira bainguë raosi'quë Isaías cani jo'case'e'ru güina'ru yure yo'oguë baji'i. “Maire pa'npo ëaye ba'iguëna, maire conreba conji. Maibi rauna ju'injënna, maire huachoyereba huachoji” cani jo'case'e ba'iguëna, güina'ru yure yo'oguë baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja'nrëbi, quë'rë jai jubëan bainbi Jesusre të'ijeiye nëcajënna, Jesusbi bacuare ëñani, baguëre concuani: Que të'huina je'eñu cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Caguëna, yequëbi ira coca ye'yoguëbi ti'anni, Jesusni cabi: —Ëjaguë, më'ëni conguë saza, si'a më'ë ganijeija'ruan, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Caguëna, Jesús sehuobi: —Airu hua'i hua'nabi gojeñana caincua'ë. Ca hua'i hua'nabi ziaroan tuijën caincua'ë. Ja'nca ba'iyeta'an, yë'ë, Riusu Raosi'quëreba ba'iguëbi yua umeni cainru gare beoguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sehuoguëna, yequë, baguëte conguë ba'iguëbi cabi: —Ëjaguë, ru'ru yë'ë taita ju'insi'quëni tañe bayë. Tanni tëjini, më'ëre conguë te'e saiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Caguëna, Jesusbi sehuobi: —Yë'ëna te'e conguë raijë'ën yurera'rë. Yë'ëre recoyo bojoma'icua, junni huesësi'cua'ru ba'ijën, ja'ancua se'gabi bacua bain junni huesësi'cuare tanja'bë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cani, ja'nrëbi yoguna cacaguëna, baguëre concuabi baguë naconi je'enni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sani, jobo zitara ba'ijënna, ai jëja tutu rabi. Raguëna, ai jai të'a jë'cani, yoguna cacaguëna, oco bu'i bi'rabi. Ja'nca ba'iguëna, Jesús yua cainsi'quë unji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ja'nca uinguëna, bacuabi sëtoni cahuë: —¡Ëjaguë, huëni ëñajë'ën! ¡Maibi huesëni carajeiyë! huaji yëjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Cajënna, baguë cabi: —¿Mësacua guere yo'ojën, yë'ëni si'a recoyo ro'tama'ijën, ro quëquëjën ba'iye'ne? cabi. Cani, ja'nrëbi huëni, Tutu saojë'ën, zitara të'a cuaujaijë'ën caguë guansebi. Guanseguëna, tutu'ga, zitara'ga ja'anse'ebi nëcajaji'i. Gare tutuye beoye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ja'nca ba'iguëna, bacuabi ai ëñajën rëinjën, sa'ñeña senni achajën cahuë: —¿Yua gue bainguëguë'ne ba hua'guë? Baguëbi guanseguëna, tutu'ga, jai zitara'ga ja'anse'ebi achani, jaë'ë cani guajaji'i, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja'nrëbi, que të'huina jenni, Gadara yijana ti'anhuë. Ti'anjënna, samucua huati zemosi'cuabi bain tansi re'ohuëbi etani, Jesusna tëhuo raë'ë. Huati zemosi'cua sëani, ai coca cu'ejën ba'ijënna, yequëcuabi baruna saiye huaji yëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yureca Jesusna tëhuo rani, ai güijën cahuë: —¿Më'ë guere ro'taguë raquë'ne ënjo'on? Më'ë yua Riusu Zin ba'iguë'ë. ¿Yëquënani ai yo'o güeseja'guëbi quë'rë ja'anrë raquë? güijën senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Senni achajënna, cuchi jubë ai ba'i jubëbi so'orë ba'ijën, aonre cu'ejën, aonre ainjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ba'ijënna, huati hua'i zemosi'cuabi Jesusni senreba sen'ë: —Yëquënani etoni saotoca, ba cuchi jubëna saojë'ën. Bacuana cacaye yëyë, senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Cajënna, —Saijë'ën, cabi. Caguëna, huati hua'ibi bainre jo'cani, etani sani, cuchi jubëna te'e cacahuë. Cacajënna, ja'ansirën si'a jubëbi hue'nhue raguëna, jaba të'ntëbana huë'huëni, rëi zitarana tonni runi huesëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Runi huesëjënna, cuchi cuiracuabi quëquëni, gatini saë'ë. Huë'e jobona sani, si'aye quëani achomate. Huati zemosi'cua ba'iyere'ga quëani achomate. ");
INSERT INTO snnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quëani achojënna, ja'nrëbi huë'e jobo bain si'acuabi Jesusni tinjajën raë'ë. Rani, Jesusni ëñani, yëquëna yijabi etani gare saijë'ën sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ja'nca senni achajënna, Jesusbi yua yoguna cacani, baguë huë'e jobona go'i bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Goni ti'anguëna, ja'nrëbi, yequëcuabi garasi'quëte camare uinguëna, Jesusna sani ëñohuë. Ëñojënna, Jesusbi baguë ñacobi ëñani, bacua recoyo ro'tayete masini si'ani, garasi'quëni cabi: —Bojo recoyo bajë'ën, mami. Më'ë gu'a jucha yua gare tënose'e ba'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Caguëna, ja'nrëbi, ira coca ye'yocuabi sa'ñeña yahue ro'tajën ñuë'ë: “Baguë yua Riusuni gu'aye caji” ro'tajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ro'tajën bëinjënna, Jesusbi baguë ñacobi ëñani, bacua yahue ro'tase'ere masini, bacuani cabi: —¿Mësacua guere gu'aye ro'tajën bëiñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bainbi “Më'ë gu'a jucha yua tënose'e ba'iji” caye porecuata'an, “Huëni ganijë'ën” catoca, bacua huachoye porema'iñete masi güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja'nca ba'iyeta'an, yë'ë yua Riusu Raosi'quëreba ba'iguëbi bain gu'a juchare tënoñe poreguë'ë. Ja'anre mësacuani ëñoñë yë'ë, cabi. Cani, ja'nrëbi garasi'quëni cabi: —Yureca huëijë'ën. Më'ë camare inni, më'ë huë'ena saijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ja'nca caguëna, baguë yua huëni baguë huë'ena saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ja'nca saiguëna, bain hua'nabi quëquë ëaye ro'tajën, Riusuni bojoreba bojojën, ro bainre huachoye poreguë re'huasi'quëre sëani, baguëni ai re'oye cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ja'nrëbi, Jesusbi se'e sani ëñato, Mateo hue'eguëbi impuesto curi co huë'ere ñuji'i. Ja'nca ñu'iguëna, Jesusbi: —Yë'ëna te'e rani conjë'ën caguë choji'i. Choiguëna, baguë yua huëni, baguëna te'e conguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saiguëna, ja'nrëbi jë'të, Jesusbi huë'ere ba'iguë, aon ainguë ñu'iguëna, yequëcua impuesto curi cocua, yequëcua gu'a bain casi'cua, ai jai jubëbi rani, Jesús, baguëre concua naconi aon ainjën te'e bëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bëajënna, fariseo bainbi ti'anni ëñahuë. Ja'nca ëñacuabi Jesusre concuani bëinjën senni achahuë: —¿Mësacua ëjaguë guere yo'oguë, impuesto curi cocua, gu'a bain, bacua naconi aon ainguë te'e ñu'iguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Senni achajënna, Jesusbi achani, bacuani sehuobi: —Huajëjën ba'icuabi ëco yo'oguëte senma'iñë. Rauna ju'incua se'gabi ëco yo'oguëte señë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Riusu coca toyani jo'case'e ëñere ye'yejë'ën: “Bain oijën concuare cu'eyë yë'ë. Hua'ire huani misabëna ëocuare cu'ema'iñë yë'ë.” Ja'an cocare ye'yejë'ën. Yë'ë re'o bainguë'ë cajën ba'itoca, bacuare choiguë raimaë'ë yë'ë. Yë'ë gu'a bainguë'ë cajën ba'itoca, ja'ancuare choiguë raisi'quë'ë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ja'nrëbi, Juan Bautizaguëre concuabi rani, Jesusni senni achahuë: —Yëquëna, fariseo bain, yua aon aiñe jo'cajënna, ¿më'ëre concua guere ro'tajën, aon aiñe jo'cama'iñe'ne? senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Cajënna, Jesús sehuobi: —Ro huacha ro'tajën ba'iyë mësacua. Huejaja'guëbi yuta ba'iguëna, baguë huejaye concuabi aon aiñe jo'caye gare porema'iñë. Ja'nca porema'ijënna, huejaja'guëre preso zeanni quëñoni gare sai umuguse ti'anguëna, ja'anrën bacuabi aon aiñe jo'caja'cua'ë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Cani, ja'nrëbi bacuani yeque yihuo cocare quëabi: —Mame canbi ira canna ja'chemajën ba'iyë. Ja'nca ja'chetoca, mame canbi guë'nguëguëna, ira canbi quë'rë se'e ye'reni gu'ajeiji. ");
INSERT INTO snnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bisi ëye jo'cha huajë jo'chare yua ira ga'ni jo'cha corohuëanna ayamajën ba'iyë. Ayatoca, huajë jo'chabi ira ga'ni corohuëanre juejueni jañuni si'aji. Ga'ni corohuëan'ga gu'a corohuëan'ru ruinji. Huajë bisi ëye jo'cha banica, mame ga'ni jo'cha corohuëanna ayajë'ën. Ja'nca ayatoca, bisi ëye jo'cha, ga'ni corohuëan'ga gare huesëye beoye ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ja'an cocare caguë ba'iguëna, yequë bainguë, bain ëjaguë ba'iguëbi caca rani, Jesusna gugurini rëanni, baguëni coca senni achaguë cabi: —Yë'ë mamacobi yurera'rë junco'ë. Ja'nca ba'igoreta'an, raijë'ën. Më'ë ëntë sarare bagona pa'rotoca, go'ya raija'go'co, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ja'nca caguëna, Jesusbi huëni, baguë naconi saji'i. Baguëre concua'ga te'e conni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja'nca saijënna, yeco, u'chu rauna ju'ingobi, si'a sara samu tëcahuëan ju'in hua'go ba'igobi baguë yo'jeja'an rani, baguë can yëruhuate pa'rogo. ");
INSERT INTO snnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Baguë can se'gare pa'roni huajëza” cago pa'rogo. ");
INSERT INTO snnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ja'nca pa'rogona, Jesusbi bonëni, bagoni ëñani cabi: —Bojo recoyo bajë'ën, mami. Më'ëbi yë'ëni si'a recoyo ro'tasi'co sëani, huajë raë'ë më'ë, cabi. Caguëna, bagobi ja'ansi'ru huajë raco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ja'nrëbi, Jesús yua bain ëjaguë huë'ena ti'anni ëñato, bain hua'nabi ai ota oijën, ro hui'ya güijën baë'ë. Yequëcuabi músicate sa'ntijën juë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ja'nca yo'ojënna, Jesusbi bacuani cabi: —Mësacua etani saijë'ën. Mamacobi ju'inmaco'ë. Ro canni uingo bago, cabi. Ja'nca caguëna, baguëni bëinjën, ai jayajën chohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chojënna, yequëcuabi bacuare hue'sena etohuë. Etojënna, Jesusbi cacani, ba romi zin hua'go ëntë sarana zeanguëna, bagobi huëni nëcago. ");
INSERT INTO snnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ja'nca nëcagona, bainbi Jesús huachose'ere ëñani, si'aruanna quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ja'nrëbi, Jesusbi barubi sani ganiguëna, samucua ñaco ëñama'icuabi baguë yo'jeja'an be'tejën, ai jëja güihuë: —Taita David bainguë, yëquëna hua'nani oiguë conjë'ën, güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cajënna, Jesús yua huë'ena cacani ba'iguëna, ñaco ëñama'icuabi baguëna caca raë'ë. Raijënna, Jesusbi bacuani senni achabi: —¿Mësacua yë'ë huachoye poreyete si'a recoñoa ro'taye? senni achabi. Senni achaguëna, —Ro'tayë, Ëjaguë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ja'nca sehuojënna, Jesusbi bacua ñacore pa'roni, bacuani cabi: —Mësacuabi yë'ëni recoyo ro'tajënna, yë'ë'ga güina'ru mësacuani huachoguë ba'iyë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Caguëna, bacua ñaco yua ja'ansirën sëtani ëñani huajë raisi'cua baë'ë. Ba'ijënna, Jesusbi bacuani si'a jëja yihuoguë cabi: —Mësacuare huachose'ere yequëcuani gare quëani achoye beoye ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Caguëna, ba hua'nabi sani, Jesús re'oye yo'oni conse'ere si'a bainni quëani achojën ganihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ja'nca saijënna, ja'ansirën yequëcuabi yi'o ma'tëbë ba'iguë, gu'a huati baguë, ja'anguëte Jesusna sani ëñohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ëñojënna, Jesusbi baguë gu'a huatire etoni saoguëna, ba bainguëbi coca ca bi'rabi. Ja'nca ca bi'raguëna, bain hua'nabi ai ëñajën rëinjën cahuë: —Yure yo'ose'e'ru Israel yija bainbi gare ëñama'isi'cua ba'iyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cajënna, fariseo bainbi ti'an rani, bëinjën cahuë: —Gu'aye yo'oji baguë. Zupai huatibi conguëna, ja'nca huati hua'ire etoni saoye poreji, cajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ja'nrëbi, Jesús yua si'a huë'e joboña, si'aruan bain ba'iruanna saiguë, bacua ñë'ca huë'eñana cacani ye'yoguë, Riusu ba'i jobo cocare quëani achoguë, rauna ju'incua, si'a rau ba'iye bacuani huachoguë, ja'anre yo'oguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ja'nca ba'iguëbi bain jubëni ai sa'ntiguë, oireba oiguë ëñabi. Chao hua'na caguë, ro porema'i hua'nabi oveja hua'na cuiraguë beo hua'na'ru ba'iye ëñoñë bacua, ro'taguë ëñabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ja'nca ëñani, ja'nrëbi, baguëte concuani cabi: —Queruna ëñajë'ën. Aon tanse'ebi yuara ya'jise'e sëani, yuareba tëaye ba'iji. Riusu ba'i jobo cu'ecuare tëani baye cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ja'nca sëani, mai Ëjaguë Riusu yua bainre tëani ba Ëjaguë ba'iguëna, baguëni ñaca senreba senni achajën ba'ijë'ën: Më'ë bainre tëani baye ro'taguë sëani, më'ëre yo'o concua, më'ë tanse'ere tëacaicua, ja'ancuare cuencueni, më'ë bainre tëaye raojë'ën, senni achajën ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja'nrëbi, Jesusbi baguëte concua si'a sara samucuare choiguëna, baguëna ti'an raë'ë. Ti'an raijënna, bacuare gu'a huati hua'ire etoni saoye porecuare re'huabi. Si'a bain ju'incua, si'a rau ju'incua huachoye porecuare bacuare re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ba cuencueni re'huasi'cua yua ñaca hue'ecua baë'ë: Ru'ru, Simón caguëni Pedro hue'yobi. Yequë, Andrés, Pedro yo'jeguë baji'i. Yequë Santiago, yequë Santiago yo'jeguë Juan, ja'an samucua Zebedeo mamacua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Yequë Felipe, yequë Bartolomé, yequë Tomás, yequë Mateo impuesto curi coguë baji'i. Yequë Alfeo zin Santiago, yequë Lebeo, Tadeo'ga hue'eguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yequë Simón hue'eguë celote jubë baji'i. Yequë Judas Iscariote, Jesús je'o bacuana insini senjoja'guë baji'i. Ja'an hue'ecuare cuencueni re'huabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja'ancua si'a sara samucuare cuencueni re'huani, bacuani coca guanseguë saobi: —Judío jubë ba'ima'icuana saima'ijë'ën. Samaria yija huë'e joboñana gare saimajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel bain se'gana saijë'ën. Riusu bain quëñëni saisi'cua, oveja hua'na ro quëñëni huesësi'cua'ru ba'iye, ja'ancua se'gana sani, ");
INSERT INTO snnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","bacuani ñaca quëani achojë'ën: “Riusu ba'i jobo yuara ti'anja'ñeta'an ba'iji” quëani achojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ja'nca ba'icuabi rau ju'incuare huachojë'ën. Junni huesësi'cuare go'ya rai güesejë'ën. Gu'a ca'nmi rau bacuare tënoni huachojë'ën. Huati hua'ire etoni saojë'ën. Ja'nca yo'oye porecua'ru ro'iye beoye re'huasi'cua sëani, mësacua yua bainre conjën, bacua ro'iye senma'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mësacua yua curire gare saye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bonse turubëte sama'ijë'ën. Te'e ëntë sara can se'ga sajë'ën. Guëon ju'iyete sama'ijë'ën. Ro'ojën sai tubëte sama'ijë'ën. Yo'ore concuani ba'icua aonre ro insiye ba'icua sëani, mësacua ja'nca saijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sani, huë'e jobona ti'anto, re'o bain banica, bacuare cu'eni, mësacua saiye tëca, bacua huë'ena bëani ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ja'an huë'ena ti'anni, baru bainni saludajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Re'o bain ba'itoca, mësacua bojojën saludase'ere bacuana jo'cajë'ën. Gu'a bain ba'itoca, jo'cama'ijë'ën. Mësacua saludase'ere go'iye quëñojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yequërë baru bainbi mësacuani bojomajën, mësacua coca quëani achoyete achaye güejën ba'itoca, barubi quëñëni saijë'ën. Ba huë'e jobobi saijën, ba bainbi ëñajënna, mësacua guëon ba'i ya'ore cue'nconi tonjë'ën. Ja'nca yo'otoca, bacua gu'a jucha yo'ose'ere masiyë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mësacuani ñaca ganreba quëayë. Sodoma, Gomorra, ja'an huë'e jobo bainni bënni senjoja'ñe'ru, bacua yua quë'rë ta'yejeiye bënni senjosi'cua ba'ija'cua'ë, Riusu ëñojai umugusebi ti'anguëna. ");
INSERT INTO snnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yureca, mësacuare saoguëna, mësacua yua oveja hua'na airu yai jubëna ti'anja'cua'ru ba'ijën, mësacua saiyë. Ja'nca sëani, aña hua'na masiye ro'tareba ro'taye'ru ai masiye ro'tajën ba'ijë'ën. Ja'nca ba'icuata'an, ju'ncubo hua'na gu'aye yo'oye beoye ba'iye'ru, gare gu'aye yo'oye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mësacua ëñare bajë'ën. Yequëcuabi mësacuani bëinjën, mësacuare preso zeanni bacua ëja bainna sani nëcoja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yequëcuabi mësacuare zeanni, yë'ë bain concuare sëani, mësacuare bain ta'yejeiye ëjacua ba'iruanna sani nëconi ëñoja'cua'ë. Ja'nca ëñojënna, mësacua yua yë'ë ba'iyete gu'a bainni quëani achoye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ja'nca preso zeanni nëcojënna, mësacua sehuoja'yete ru'ru ro'taye beoye ba'ijën, huaji yëmajën ba'ijë'ën. Mësacua sehuoja'rën ti'anguëna, Riusubi mësacua coca sehuoja'yete quëaji. ");
INSERT INTO snnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mësacua se'gabi ba sehuo cocare ro'tama'ija'cua'ë. Mësacua Taita Riusu Espíritubi quëaguëna, ja'an cocare sehuoja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ja'anrën ti'anguëna, bainbi ba yo'jecuani preso zeanni huani senjo güeseja'cua'ë. Yequëcua'ga ba mamacuare preso zeanni, huani senjo güeseja'cua'ë. Yequëcua'ga ba pë'caguë sanhuëre preso zeanni, huani senjo güeseja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mësacua yua yë'ë bainrebare sëani, si'a bainbi mësacuani ai je'o ëñaja'cua'ë. Je'o ëñaja'cuata'an, yë'ëni si'a recoyo jo'caye beoye ro'tajën ba'ijë'ën. Ja'nca ro'tatoca, carajei umuguseña ti'anguëna, Riusubi mësacuani tëani baja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mësacuabi te'e huë'e jobona sani, mësacuare je'o batoca, yequë huë'e jobona gatini saijë'ën. Ja'nca saijënna, mësacuani yihuoreba yihuoyë yë'ë: Riusu Raosi'quëreba ba'iguëbi yë'ë gaje rai umuguse ti'anguëna, si'a Israel bain huë'e joboña ëñajën saiye porema'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ye'yeguëbi yua baguë ye'yoguë'ru quë'rë ta'yejeiye baye porema'iji. Yo'o conguëbi baguë ëjaguë'ru quë'rë ta'yejeiye baye porema'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ye'yecuabi bacua ye'yocua te'e masijën te'e ta'yejeiye ba'iye'ru ruintoca, re'oji. Yo'o concuabi bacua ëjacua ba'iye'ru ruintoca, re'oji. Yë'ë yua Riusu ba'i jobo ëjaguë ba'iguëna, bainbi yë'ëni Beelzebú Zupai Huati cahuë. Ja'nca cacuabi quë'rë se'e yë'ë bainrebare gu'aye caja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ja'nca caja'cua ba'ijënna, bacuani huaji yëye beoye ba'ijë'ën. Riusubi bacua gu'aye yo'oni yahuese'e beorure ëñoni, si'acuani masi güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yë'ëbi mësacuani yahue coca caguëna, beoru si'a bainni quëani achojën ba'ijë'ën. Mësacuabi bain yahue coca cayete achato, si'a bainni güijën quëani achojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ro ën yija bainni huaji yëye beoye ba'ijë'ën. Mësacua ëmëje'en ga'nihuë se'gare huani senjoñe poreyë. Riusu se'gani huaji yëjën ba'ijë'ën, bain recoyore gare carajei güeseye poreguëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Samu bi'an hua'nare te'e curi so'corë naconi coye poreyë. Ja'nca choa ma'carë ro'icuareta'an, Riusubi ga bi'an hua'guëni ro'taguë, gare huanë yeye beoye ba'iji. Riusubi yëma'itoca, bi'an hua'guë te'eguë se'gabi junni to'inma'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mësacua sinjobë rañare'ga cuencueguë, mësacua ba'iye si'ayete masiji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ja'nca sëani, bainni gare huaji yëye beoye ba'ijë'ën. Si'a bi'an jubë'ru mësacuani ai re'oye ëñaguë, mësacuani quë'rë ta'yejeiye ai yëguë ba'iji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bain jubëbi achajënna, mësacua yua ñaca cajë'ën: Yëquëna yua Jesucristo baincua'ë cajë'ën. Ja'nca catoca, Yë'ë'ga, Taita Riusu guënamë re'oto ba'iguëbi achaguëna, yë'ë bainreba concua ai re'o hua'na'ë caguë quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yequëcua, bain jubëbi achajënna, yë'ë ba'iyete gu'a güeye catoca, yë'ë'ga, yua Taita Riusu guënamë re'oto ba'iguëbi achaguëna, bacuare gu'a güeye cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bainni sa'ñeña huaiye beoye ba'iyete jo'caguë raimaë'ë yë'ë. Mësacuabi ja'anre huacha ro'tama'ijë'ën. Bainni sa'ñeña huai güeseguë raë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yequëni baguë pë'caguëte huaiye ro'ta güeseyë yë'ë. Yeconi bago pë'cagote huaiye ro'ta güeseyë yë'ë. Yeconi bago huagote huaiye ro'ta güeseyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Je'o bacuare cu'eto, bain te'e huë'e ba'icua'ë cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pë'caguë sanhuëte yë'ëre'ru quë'rë yëguëbi yë'ë bainguë ba'iye porema'iji. Mama hua'nare yë'ëre'ru quë'rë yëguëbi yë'ë bainguë ba'iye porema'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yë'ë naconi te'e yo'o conguë ba'iye baji. Yë'ë yua ai yo'oye'ru güina'ru ai yo'oye yëma'iguëbi yua yë'ë bainguë ba'iye porema'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bainbi ro bacua ba'iye se'gare ro'tatoca, junni si'aye se'ga ba'iji bacuare. Yë'ë ba'iye ro'ina güeye beoye junni huesëtoca, ja'ancuabi go'ya rani, huajëreba huajëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yequëcuabi mësacuani te'e ruiñe ëñajën ba'itoca, yua yë'ëre'ga te'e ruiñe ëñajën ba'iyë. Yë'ëni te'e ruiñe ëñajën ba'itoca, yua yë'ë Taita yë'ëre raosi'quëre'ga te'e ruiñe ëñajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yequëcuabi Riusu bainguë raosi'quëni te'e ruiñe ëñani bojotoca, Riusu bainguë raosi'quë bojoja'ye'ru bojojën ba'ija'cua'ë. Yequëcuabi re'o bainguëni te'e ruiñe ëñani bojotoca, re'o bainguëni bojojën ba'ija'ye'ru bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yequëcuabi yë'ë bainguë yë'ëre conguë te'eguë se'gani te'e ruiñe ëñani, quë'rë yo'jereba ba'iye'ru baguëni oco se'gare uncuatoca, Riusubi baguë ro insija'ye ro'tase'ere baguëni gare jo'caye beoye insija'guë'bi, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ja'nrëbi, Jesusbi baguëre concua si'a sara samucuani coca yihuoni tëjini, baguëbi sani, bain huë'e joboñana ti'anni, baguë cocare quëani achoni, bainre ye'yoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ba'iguëna, Juanbi, ya'o huë'ere preso guaosi'quëbi Cristo yo'oguë ba'iyete achani, baguëre concua samucuare choini, bacua naconi ");
INSERT INTO snnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesusni coca caguë saobi: —¿Më'ë yua ba Cristo raija'guë ba'iguë'guë? Ba'ima'itoca, ¿yequë raija'guëni ëjoye baye mai? Jesusni senni achaguë saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Saoguëna, Juanre concuabi Jesusna ti'anni, senni achahuë. Senni achajënna, Jesús sehuobi: —Mësacua yua Juanna go'ini, mësacua yure ëñase'e, mësacua yure achase'e, ja'anre baguëni quëajaijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ñaco ëñama'icuabi yua ñaco huajëyë. Guëon garasi'cuabi yua ganiñë. Gu'a ca'nmi rau bacuabi tënosi'cua ba'ijën, huajë raiyë. Ganjo achama'icuabi ganjo achayë. Junni huesësi'cuabi go'ya raiyë. Riusu bojo coca yua bonse beo hua'nani quëani achose'ebi ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yë'ëni güeye beoye recoyo ro'tajën ba'icuabi ai ba'iye ai bojoreba bojojën ba'iyë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cani, bacuabi go'ijënna, Jesús yua bain jubëni Juan ba'iyete quëa bi'rabi: —Mësacua yua beo re'otona sani, Juanre ëñañu cajën, ¿neni ëñañe ro'tare'ne? “Ro jëja beo hua'guë, jë'je sahua tutu taonse'e'ru ba'iye ëñajaiñu” ja'anre ëñañe gare ro'tamaë'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Neni ëñañe ro'tare'ne mësacua? “Ëjaguë caña ju'iguëte ëñajaiñu” ja'anre ëñañe gare ro'tamaë'ë mësacua. Ëja bain caña ju'icua, yua me'najeiñe ba'icua, ja'ancua yua ta'yejeiye ëja bain huë'eñare ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Neni ëñañe ro'tare'ne mësacua? “Riusu coca quëaguëte ëñajaiñu” catoca, mësacua yua te'e ruiñe ro'tahuë. Aito. Riusu coca quëacua si'acua'ru yua quë'rë ta'yejeiye ëjaguëte mësacua ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Riusu ira coca toyani jo'case'ere ëñato, ën coca yua Juanre toyani jo'case'e ba'iji: Më'ëre quëaguëte ru'ru saohuë, më'ë rai ma'are re'huacaiguëte, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ja'nca toyani jo'caguëna, mësacuani quëareba quëayë yë'ë. Juan Bautizaguëbi yua Riusu coca quëaye raosi'cua si'acua'ru quë'rë ta'yejeiye ëjaguëbi ba'iji. Ja'nca ba'iyeta'an, Riusu ba'i jobo ba'icuare ëñato, baru ba'iguë quë'rë yo'jeguëreba ba'iguëbi yua Juan'ru quë'rë ëjaguë'ru ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Bautizaguë ba'isirënbi yurerën tëca gu'a bainbi Riusu ba'i jobona huañu cajën, ai je'o ëñajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Riusu ira bain raosi'cua, ira bainguë ba'isi'quë Moisés naconi, si'acuabi Riusu ba'i jobore quëani achojën, Juan ba'iye tëca ja'nca cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mësacuabi recoyo ro'taye poretoca, Juan yua Riusu ira bainguë raosi'quë Elías hue'eguë te'e ba'iguë'bi. Ja'anguëbi yua bainna raija'guë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yureca ganjo banica, achani ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yureca, bain hua'na yureña ba'icua ¿queaca yo'ojën ba'iye'ne? Zin hua'na sa'ñeña huere yo'ocua'ru ba'iyë. Yequëcuabi yua yequëcuani coca cayë: ");
INSERT INTO snnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Yëquënabi jurihuëanbi juijën ba'iyeta'an, mësacua conjën pairamaë'ë. Sa'ntiye gantajën ba'iyeta'an, mësacua conjën ota oimaë'ë.” Ja'nca cajën ba'iyete yureña bain ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juanbi rani, baguë aon aiñe jo'cani, bisi ëye jo'cha gare uncuye beoye ba'iguëna, mësacuabi Ro ro'taguë yo'o hua'guë'bi ba'iji, baguëte cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja'nrëbi yë'ë, Riusu Raosi'quëreba ba'iguëbi rani, aonre anni, gonore uncuguëna, mësacuabi yeque cocabi yë'ëre cajën, Aon ain huati'bi. Jo'chana güebe huati'bi. Gu'a bain, impuesto curi cocua, ro bacua gu'a gajeguë ba'i'te, yë'ëre cajën, yë'ëre jayayë mësacua. Ja'nca cacuata'an, Riusu masiyete ëñañe yënica, Riusuni ye'yereba ye'yecua bacua yo'oyete ëñajë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cani, ja'nrëbi, baguë huë'e joboñana sani ta'yejeiye yo'o yo'oni ëñosiruanre ai bëinguë ca bi'rabi, baruan bainbi bacua gu'a juchare gare jo'caye beoye ba'icuare sëani: ");
INSERT INTO snnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Mësacua Corazín huë'e jobo bain, ai bënni senjoñe ba'ija'guë'bi mësacuare, cayë. Betsaida bainre'ga, ai bënni senjoja'ñe cani jo'cayë mësacuare. Riusu ta'yejeiye yo'ose'e, mësacuana ëñose'e, ja'anre Tiro bain, Sidón bain, bacuani ëñose'e ba'itoca, ai ba'irën bacua gu'a juchare jo'cani senjore'ahuë. Costal cañare sayani, yë'tëbi bacua sinjobëanna yu'yujën ba'ire'ahuë, bacua jucha senjose'ere eñojën ba'icua. ");
INSERT INTO snnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Riusu cuencuesi umuguse ti'anguëna, Tiro, Sidón, ja'an bainre bënni senjoja'ñe'ru mësacuani quë'rë ta'yejeiye ai jëja bënni senjosi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mësacua Capernaum bainre'ga ai bënni senjoja'ñe cani jo'cayë yë'ë. ¿Mësacua yua Riusu ba'i jobona ti'añe ro'taye? Bañë. Ba toana senjoni saoye se'ga ba'ija'guë'bi mësacuare. Riusu ta'yejeiye yo'o yo'ose'e, mësacuana ëñose'e, ja'anre yua Sodoma bainni ëñose'e ba'itoca, ja'an huë'e jobobi yureña tëca ba'iguë ba'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Riusu cuencuesi umuguse ti'anguëna, Sodoma bainre bënni senjoja'ñe'ru mësacuani quë'rë ta'yejeiye jëja bënni senjosi'cua ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cani, ja'nrëbi, Jesús yua Taita Riusuni ujaguë cabi: —Taita, më'ë yua guënamë re'oto, yija re'oto, si'a re'oto ta'yejeiye Ëjaguë'ë. Yë'ë coca yure quëani achoguëna, bain masi ëjacua si'aye ye'yesi'cua'ë cajën ba'icuata'an, ja'an cocare masiye porema'iñë bacua. Bacua masiyete ënsehuë më'ë. Yequëcua zin hua'na ba'iye'ru ba'icuabi “Ye'yeye caraji yë'ëre” cajënna, ja'ancuani yë'ë cocare masi güesehuë më'ë. Ja'nca sëani, më'ëni ai bojoguë, surupa cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Më'ë yëse'e se'gare yo'osi'quë sëani, më'ë bainre ai re'oye conhuë më'ë, ujaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ujani ja'nrëbi bainni yihuoguë cabi: —Yureca, yë'ë Taitabi yë'ëna si'ayete insini jo'cabi. Yë'ë Taita se'gabi yë'ëre masiji. Yequëcua bañë. Yë'ë se'gabi yë'ë Taitare masiyë. Yequëcua bañë. Yë'ëbi yë'ë Taita ba'iyete yë'ë bain cuencuesi'cuani ëñoguëna, ja'nrëbi yë'ë Taitani masiye poreyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ai jëja yo'o yo'ojën guajasi'cua, ai rëquëye hue'ojën guajasi'cua, mësacua si'acua yë'ëna raijë'ën. Raitoca, mësacuani te'e ruiñe bëani huajë güeseyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yë'ëna rani, yë'ë ba'iyete ye'yeye, ja'an se'gare hue'ojën ba'ijë'ën. Huëjeiye'ru ba'iji. Yë'ë yua jëja guanseye beoye ba'iguë'ë. Ro yo'jereba ba'iguë'ru ëñoguë'ë yë'ë. Ja'nca sëani, yë'ëna rani, te'e ruiñe bëani huajëjë'ën. Mësacua yua recoyo re'o huanoñe ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ja'nca ba'icuabi yë'ë ba'iyete ye'yejën, rëquëye beoye hue'ojën, yë'ëre guaja beoye conjën ba'ijë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ja'nrëbi, yo'o yo'oma'i umuguse ba'iguëna, Jesús yua trigo aon zio re'otobi ganiguë, baguë concuare aon gu'aguëna, aon za'zaboanre tëani, aonra'carëanre ain bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ja'nca yo'ojënna, fariseo bainbi ëñani, Jesusni bëinjën cahuë: —Ëñajë'ën. ¿Më'ëre concua queaca ro'tajën, aonre tëaye'ne? Yo'o yo'oma'i umuguse sëani, mai ira coca toyani jo'case'ere'ru tin yo'oye porema'iñë, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Cajënna, Jesusbi sehuobi: —Mai ira coca toyani jo'case'ere ëñajën, David yo'ose'ere cato, ¿ja'an quë'rore mësacua ëñamate'ne? Baguëre concua naconi ganini, aon gu'aguëna, ");
INSERT INTO snnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidbi Riusu huë'ena cacani, baru ba'i aonbëan Riusuna jo'case'ere inni ainguë ba'nji. Pairi bain se'gabi aiñe porejënna, yequëcuabi aiñe porema'iñeta'an, Davidbi inni ainguë, baguëte concuare'ga aonguë ba'nji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Yequë quë'rore'ga mësacua ëñamate'ne? Yo'o yo'oma'i umuguse ba'iguëna, pairi bainbi Riusu huë'e yo'o ma'carëanre yo'ocuata'an, jucha beoyë caji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yureca mësacuani quëareba quëayë yë'ë. Riusu huë'e ta'yejeiye ba'iyete cato, yë'ë yua Riusu Raosi'quëreba ba'iguëbi quë'rë ta'yejeiye ba'iguë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mësacua yua ën coca toyani jo'case'e: “Bainre oijën concuare cu'eyë yë'ë. Hua'ire huani misabëna ëocaicuare cu'ema'iñë yë'ë.” Ja'an cocare re'oye ye'yejën ba'itoca, mësacua yua jucha beo hua'nare ëñajën, Gu'a bain'ë ro'tajën bacuare cama'ire'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yureca Riusu Raosi'quëreba ba'iguëbi yua yo'o yo'oma'i umuguse ëjaguë'ë yë'ë, cabi Jesús ");
INSERT INTO snnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cani, ja'nrëbi se'e sani, bacua ñë'ca huë'ena cacabi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Cacani ëñato, guë'nguësi sara baguëbi baji'i. Ba'iguëna, baru bainbi Jesusni senni achahuë: —¿Yo'o yo'oma'i umuguse ba'iguëna, bainre huachoye poreye'ne? senni achahuë. Ro coquehuë. Baguë sehuoja'yete achañu. Re'oye sehuoma'itoca, Gu'aye cahuë më'ë cañu ro'tajën, baguëni ja'nca senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Senni achajënna, Jesús sehuobi: —Mësacua jubë ba'iguëbi oveja jo'yare baguë, yo'o yo'oma'i umugusebi gojena to'intoca, baguë ovejare oire bani, baguëte zeanni, huëani etoma'iguë? ");
INSERT INTO snnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ja'nca oire bani contoca, bainre coñe quë'rë ta'yejeiye yo'ojën ba'ijë'ën. Ja'nca sëani, yo'o yo'oma'i umuguse ba'iguëna, re'oye yo'oye poreyë mai, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cani ja'nrëbi guë'nguësi sara baguëni: —Më'ë ëntë sarare mi'najë'ën, cabi. Caguëna, mi'nabi. Mi'nani, baguë yequë sara ba'iye'ru huajë sara re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ja'nrëbi, fariseo bainbi sani, sa'ñeña coca senni achajën: “¿Queaca yo'oni Jesusre huani senjoñe'ne mai?” senni achajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja'nca senni achajën ba'ijënna, Jesusbi masini, barubi etani saji'i. Sani, ai jai jubë bainbi raijënna, si'a rau bacuare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Huachoni, Yë'ë yo'oguë ba'iyete yequëcuani quëani achoye beoye ba'ijë'ën, caguë yihuobi bacuare. ");
INSERT INTO snnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ja'nca yihuoguë, Riusu ira bainguë raosi'quë Isaías hue'eguë ba'isi'quë, baguë coca toyani jo'case'e'ru güina'ru yo'oguë baji'i: ");
INSERT INTO snnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yureca, yë'ë yo'o conguëte cuencueni bainna saoja'guë'ë. Yë'ë ai yësi'quë'bi ba'iji. Yë'ë recoyobi baguëni ai bojoguë ba'iyë yë'ë. Baguëte saoguë, yë'ë Espíritute baguëna jo'caguëna, si'a bain judío bain jubë ba'ima'icuare'ga, si'acuana sani, Riusu ëñojai umuguse ti'anja'ñete bacuani quëani achoguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bain huai cocare caye beoye ba'ija'guë'bi. Jëja güiye beoye ba'ija'guë'bi. Ai jëja coca cani achoma'iguëbi bain huë'e jobona ganini, güiye beoye ba'ija'guëbi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jëja recoyo beo hua'na banica, bacua recoyo ro'taye conja'guë'bi. Yequëcua yua ja'ancuare ro jo'cani senjoñe'ru gare yo'oye beoye ba'ija'guë'bi. Riusu ëñojai umuguse ti'añe tëca, ja'nca ba'ija'guë'bi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ja'nca ba'iguëna, si'a bainbi baguë ba'iyete ro'tajën, baguë conja'ñete ëjojën ba'ija'cua'ë, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ja'nrëbi, yequëcuabi ñaco ëñama'iguë, yi'o ma'tëbë ba'iguë, huati baguë, ja'anguëte Jesusna rani ëñohuë. Rani ëñojënna, Jesusbi baguëte huachoguëna, ñaco ëñani, coca ca bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja'nca huachoguëna, si'a bainbi ai ëñajën rëinjën, coca cahuë: —¿Yureca gue'ne? ¿David mamaquëma'iguë baguë? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ja'nca cajënna, fariseo bainbi achani, bëinjën cahuë: —Gu'a huati ëjaguë Beelzebú hue'eguëbi conguëna, huati hua'ire ja'nca etoni saoye poreji baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cajënna, Jesusbi baguë ñacobi ëñani, bacua yahue ro'tase'ere masibi. Ja'nca masini, bacuani cabi: —Te'e jobo bainbi sa'ñeña huatoca, si'acuabi huesëni carajeiyë. Te'e jubë bain, te'e huë'e bain, ja'ancuabi sa'ñeña huatoca, si'acuabi huesëni carajeiyë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ja'nca ba'iguëna, güina'ru, zupai huati concuabi sa'ñeña huatoca, bacua'ga huesëni carajeiyë. Ro huacha ro'tayë mësacua. Zupaire concuabi ja'nca yo'oma'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mësacuabi cajën, Beelzebú conse'ebi huati hua'ire etoni saoyë yë'ë cajën, ro huacha cayë mësacua. Ja'nca catoca, mësacua bainbi huati hua'ire etoni saojënna, ¿nebi bacuare conguë'ne? ¿Zupai huatibi conma'iguë? Ja'nca etoni saocuabi mësacua gu'aye yo'ose'ere ëñojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yë'ëbi huati hua'ire etoni saoguëna, Riusu Espíritu se'gabi yë'ëre conji. Ja'nca conguëna, Riusubi baguë ta'yejeiye ba'iyete mësacuana yuara ëñoguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yequëcuabi jëja baguë huë'ena jian cacaye yëtoca, ru'ru jëja baguëni preso hueñe bayë. Baguëte preso huenma'itoca, baguë bonsere jiañe porema'iñë. Zupai huati'ga ja'ncara'ru jëja baguëna, yë'ëbi baguëni preso huenja'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yë'ë naconi te'e conma'icuabi yua yë'ëni je'o bayë. Yë'ë naconi te'e yo'o yo'ojën ba'ima'icuabi yua yë'ë bain ñë'cosi'cuare saoni senjoñë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ja'nca sëani, mësacuani yihuoreba yihuoguë cayë yë'ë. Bain gu'a coca ro bëyoni case'e si'ayete Riusubi huanë yeye poreji. Riusu Espírituni gu'a coca ro bëyoni catoca, Riusubi gare huanë yeye beoye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yequëcua, yë'ëni Riusu Raosi'quëreba ba'iguëna, gu'a coca ro bëyoni catoca, Riusubi huanë ye güeseye poreji. Riusu Espírituni gu'a coca ro bëyoni catoca, Riusubi gare huanë yeye beoye ba'iji. Yure ba'irën, Riusu ëñojairën'ga, gare jo'caye beoye huanë yema'iji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Re'o sunquiñë banica, re'o uncuere quëinji. Gu'a sunquiñë banica, gu'a uncuere quëinji. Ba sunqui uncuere ëñani, si'a sunquiñë ba'iyete masiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mësacua yua aña hua'na ba'iye'ru ro coquejën, ro gu'aye yo'ojën ba'icua'ë. Ja'nca sëani, mësacua yua re'oye caye gare porema'iñë. Bain recoyo ro'tayete masiye yëtoca, baguë yi'obo cayete achani ro'tani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Re'o bainguë banica, baguë recoyo re'oye ro'tani, ai re'oye conji. Gu'a bainguë banica, baguë recoyo gu'aye ro'tani ai gu'aye yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mësacuani ganreba yihuoguë cayë yë'ë. Riusu ëñojai umuguse ti'anguëna, Riusubi si'a bain gu'aye cani tonse'ere ro'ta güeseni, bacua gu'aye yo'ojën ba'ise'ere senni achaja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ja'nca sëani, mësacuabi re'o coca cajën ba'itoca, Riusubi re'o bain'ë mësacua, caja'guë'bi. Mësacuabi gu'a coca cajën ba'itoca, Riusubi gu'a bain'ë mësacua, caja'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Caguëna, ja'nrëbi, ira coca ye'yocua, fariseo bain naconi, bacuabi Jesusna sani, coca senni achahuë: —Ëjaguë, më'ë ta'yejeiye ba'iyete ëñojë'ën. Ëñañu, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cajënna, Jesús sehuobi: —Yureña bainbi Riusure ro jo'cani senjojën, yë'ëni ta'yejeiye yo'o yo'oni ëñoñete señë. Ja'nca sencuareta'an, Riusu ira bainguë raosi'quë Jonás hue'eguë ba'isi'quë, baguë ba'ise'e se'gare quëani masi güeseyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás yua samute umuguseña na'ijani ñatajani ba jai ziaya hua'ibi rëonsi'quë ba'iguë ba'nji. Ja'nca ba'iguëna, yë'ë, Riusu Raosi'quëreba ba'iguëbi güina'ru samute umuguseña na'ijani ñatajani yijana tansi'quë ba'ija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Riusu ëñojai umuguse ti'anguëna, Nínive huë'e jobo bainbi huëni, yureña bain gu'aye ba'iyete masi güeseja'cua'ë. Jonás coca quëani achose'ere achani mame recoyo re'huasi'cua sëani, mësacua gu'aye ba'iyete masi güeseyë bacua. Yurera ba'iguëna, Jonas'ru quë'rë ta'yejeiye ye'yoguëbi mësacuana ti'anhuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Riusu ëñojai umuguse ti'anguëna, sëribë ca'nco re'oto, baru ba'i ëjago ba'isi'cobi huëni, yureña bain gu'aye ba'iyete ëñoja'go'co. Bago yua Salomón masiye ye'yoyete achaza cago, ai so'ona sani baguë cocare achago ba'nco. Yurera ba'iguëna, Salomon'ru quë'rë ta'yejeiye ye'yoguëbi mësacuana ti'anni yë'ë ta'yejeiye ba'iyete mësacuani ëñohuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gu'a huatibi bainguëte etani saiguë, beo re'otona ganiguë, bëani huajëye ba'irute cu'eji. Cu'eni, re'orute tinjama'iguëbi yua ");
INSERT INTO snnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yë'ë etasi huë'ena se'e goza caji. Ja'nca cani, baruna go'ini ëñato, yua huati beo huë'e, re'oye re'huani re'oye yuase'e baji'i, bainguë recoyo. ");
INSERT INTO snnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ja'nca ba'iguëna, baguë yua se'e sani, yequëcua huati hua'i, te'e ëntë sara samucuare cu'eji. Baguë'ru quë'rë gu'a huati hua'ire cu'eni, bacuare choini, rani, si'a jubëbi ba etasi huë'ena cacani bëayë, bainguë recoyona. Ja'nca bëajënna, ba bainguë yua quë'rë se'e ai ba'iye ai gu'ajaiguë baji'i. Ru'rureba ba'ise'e yua quë'rë re'oye baji'i. Yureña bain'ga ai gu'aye ba'ijën, quë'rë se'e gu'ajeijën ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yuta cani tëjima'iguëna, yureca Jesús pë'cago, Jesús yo'jecua, bacuabi ti'an rani, hue'se ca'ncore ëjojën, baguëte choni raohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Raojënna, bacua raosi'quëbi Jesusni quëabi: —Më'ë pë'cago, më'ë yo'jecua, bacuabi hue'se ca'ncore ëjojën, më'ëni choiyë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Quëaguëna, Jesús sehuobi: —¿Yë'ë pë'cago, yë'ë yo'jecua, jarocua'ne? senni achaguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ja'nca senni, ja'nrëbi baguë concuare ba bainni ëñoni cabi: —Yë'ë pë'cago, yë'ë yo'jecua yua ënjo'on ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yë'ë Taita Riusu guënamë re'oto ba'iguë, baguë yëye'ru yo'ojën ba'icua, ja'ancuabi yua yë'ë yo'jeguë sanhuë, yë'ë yo'jego sanhuë, yë'ë pë'cago sanhuë ba'icua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cani, ja'ansi umuguse, Jesús yua baguë ba'i huë'ebi etani, zitara yëruhuana sani bëabi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bëani, ai jai jubë bainbi ñë'ca raë'ë. Ai jai jubë bain sëani, Jesús yua yoguna cacani bëaguëna, bain jubëbi mejagu yëruhuate achajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Achajën nëcajënna, ja'nrëbi ye'yo cocabi bacuani ai ba'iye ai yihuoguë quëani achobi: —Bainguëbi zio yo'oguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sani, yijare re'oye re'huani tëjini, aonra'carëanre mo'gasi yijana yu'yuguë ganibi. Yu'yuguë ganiguëna, yequëra'carëanbi ma'ana to'inguëna, bi'an hua'nabi chiani uncueni si'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yequëra'carëanbi gata yijana to'inguëna, ya'obi beanguëna, ai besa ticubi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ja'nca ticuguëna, ja'nrëbi ai ja'suye ënsëguëna, sita beo sahua sëani, ticubi cueneni junji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yequëra'carëanbi miubëna to'inguëna, miubi irani hueanguëna, aonbi quëinmaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yequëra'carëanbi yua re'oye re'huasi yijana to'inguëna, aonbi irani, jorini, re'oye quënji'i. Quëinguëbi yequë sahuañabi cienra'carëan quënji'i. Yequë sahuañabi sesentara'carëan quënji'i. Yequë sahuañabi treintara'carëan quënji'i, caguë ye'yobi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ye'yoni ja'nrëbi, Mësacuabi ganjo banica, achani ye'yejë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ja'nca caguëna, ja'nrëbi baguëre conjën ba'icuabi rani, baguëni coca senni achahuë: —¿Më'ë guere ja'ancuani ye'yo cocabi yihuoguë caguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Senni achajënna, sehuobi: —Riusubi baguë ba'i jobo ba'iyete mësacuani te'e ruiñe quëani, baru ba'i yahuese'ere mësacuani te'e ruiñe masi güeseji. Ja'ancuareta'an, banji. ");
INSERT INTO snnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mësacuabi ai ba'iye ai batoca, quë'rë ai ba'iye mësacuana insise'e ba'ija'guë'bi. Ja'nca ba'iguëna, mësacuabi aireba coni baja'cua'ë. Ai ba'iye beotoca, mësacua baye choa ma'carë se'ga batoca, beoru quë'ñeni tëase'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja'nca ba'iye sëani, ja'ancuani yihuoguë, ye'yo coca se'gabi bacuani quëayë. Ñaco bacuata'an, ëñañe porema'iñë. Ganjo bacuata'an, achaye porema'iñë. Gue ye'yeye beoye ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Riusu ira bainguë raosi'quë, Isaías hue'eguë ba'isi'quëbi coca cani jo'caguëna, ja'ancuabi güina'ru yo'ojën ba'icua'ë. Ñaca cani jo'cabi Isaías: Mësacuabi ganjo bacuata'an, mësacua achaye güecua'ë. Ñaco bacuata'an, mësacua ëñañe güecua'ë. Ja'anre bacuani quëani achojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bacuabi yë'ë ro'taye'ru ro'taye güecuare sëani, ja'nca bacuani quëajë'ën. Bacua recoñoa bain huanoma'iñe'ru ro'tajën ba'iyë. Bacua ganjo gui'ise'e'ru ba'iyë. Bacua ñaco ta'pise'e'ru ba'iyë. Ruiñe ëñañe beoye baza cajën, ruiñe achaye beoye baza cajën, ruiñe ye'yeye beoye baza cajën, yë'ëre güecua'ru ruën'ë bacua. Yë'ëna bonë rani, huacho güeseye gare güejën ba'icua'ë, Isaíasni cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ja'nca ba'icuata'an, mësacua ñacobi te'e ruiñe ëñacua sëani, bojojën ba'ijë'ën. Mësacua ganjobi te'e ruiñe achacua sëani, bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mësacuani yihuoreba yihuoguë cayë. Riusu ira bain ba'isi'cua, yequëcua re'o bain ba'ijën ba'isi'cua, bacuabi mësacua yure ëñañete ëñañe ëjocuata'an, bacuabi ëñañe poremaë'ë. Mësacua yure achayete achaye ëjocuata'an, bacuabi achaye poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ja'nca ba'isi'cua ba'ijënna, mësacua yureca achajë'ën. Zio yo'oguë cocare mësacuani te'e ruiñe quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bainbi Riusu ba'i jobo cocare achani, ro huesë ëaye achajën ba'itoca, zupai huatibi rani, bacua coca achase'ere bacua recoyo bayete tëani senjoji. Aonra'carëan ma'ana to'inse'e'ru ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yequëra'carëan gata yijana to'inse'ere ro'tato, ëñere ye'yejë'ën. Bainbi Riusu cocarebare achani, ja'ansirën bojojën ba'ijën, ba cocare ro'tayë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ja'nca ro'tacuata'an, sita beo sahua ba'iye'ru ba'ijën, jëja recoyo beocua'ru zoe ro'tama'iñë. Yequëcuabi je'o ëñajën, hui'ya yo'ojënna, bacua yua Riusu cocareba ro'ire ai yo'ojën, ba cocare recoyo ro'taye jo'cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yequëra'carëan miubëna to'inse'ere ro'tato, ëñere ye'yejë'ën. Bainbi Riusu cocarebare achajën ba'icuata'an, ro ën yija ba'iye se'gare ro'tajën, coquesi'cua'ru ruiñë. Bonse se'gare bani bojoza cajën, aonra'carëan hueanni si'ase'e'ru Riusu cocarebare recoyo ro'taye gare jo'cayë. Ja'nca jo'cajën, re'oye yo'oye gare ëñomajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yequëra'carëan re'oye re'huasi yijana to'inse'ere ro'tato, ëñere ye'yejë'ën. Bainbi Riusu cocarebare achani, recoñoa re'huani, re'oye yo'oye ai ba'iye ai ëñojën ba'iyë. Ja'nca ba'icuabi yequëcua yua cienra'carëan quëiñe'ru ba'iyë. Yequëcua yua sesentara'carëan quëiñe'ru ba'iyë. Yequëcua yua treintara'carëan quëiñe'ru ba'iyë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Quëani ja'nrëbi, se'e yeque ye'yo cocare bacuani yihuobi: —Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare achani ye'yejë'ën. Yequë bainguëbi baguë ziore tanguë, aonra'carëan re'ora'carëanre tanbi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tanguëna, ja'nrëbi baguë bainbi ñamibi cainjënna, je'o baguëbi yahue rani, ro tayara'carëanre ba ziona yahue tanni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tanni saquëna, ja'nrëbi re'hue aon sahuañabi irani quëinguëna, ba hui'ya taya'ga ba ziona ca'nquese'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ba'iguëna, ba zio cuiracuabi yua bacua ëjaguëna sani quëani achohuë: “Ëjaguë, më'ë aonra'carëan tanse'e yua re'ora'carëan ba'itoca, ¿hui'yabi queaca huiguë'ne?” senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Cajënna, baguë sehuobi: “Je'oguëbi tanguëna, hui'yabi huiji” sehuobi. Sehuoguëna, bacuabi cahuë: “Ja'nca ba'itoca, hui'ya tayare rutani senjoñu” cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cajënna, baguëbi cabi: “Bañë. Ja'nca yo'oma'ijë'ën. Hui'ya tayare rutatoca, aon sahuañare'ga yequërë hui'ya naconi huacha rutama'iñe. ");
INSERT INTO snnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Si'aye te'e irani, aon tëarën tëca te'e iraja'guë. Ja'nrëbi aon tëarën ti'anguëna, aon tëacuani quëaja'guë'ë yë'ë: Ru'ru mësacua yua hui'ya tayare rutani, jurëanre gueonni ëojaiñu cajën bëyojë'ën. Ja'nca bëyoni ja'nrëbi, aonre tëani, yë'ë aon ayaruna ayajë'ën” caja'guë'ë yë'ë, cabi ba ëjaguë. Ja'an cocare achani, Riusu ba'i jobo ba'iyete ye'yejë'ën, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Quëani ja'nrëbi yeque coca, ye'yo cocare bacuani yihuoguë quëabi: —Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare achani ye'yejë'ën: Yequë bainguëbi mostazara'carë te'era'carëte sani, baguë ziona tanbi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Si'ara'carëan'ru quë'rë zinra'carë ba'ito'ga, yijana tanse'ebi irani, yua si'a sunquiñëa'ru quë'rë jai sunquiñëbi iraji. Ja'nca iraguëna, ca hua'i hua'nabi rani, bacua ziaroanre mostaza sunquiñë cabëanna suaye poreyë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Quëani ja'nrëbi yeque coca, ye'yo cocare bacuani yihuoguë quëabi: —Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare achani ye'yejë'ën: Romi hua'gobi aonre boza cago, harina samute ro'rohuëanre cuencueni, ja'nrëbi aon huo'co macare inni harinana ayani ja'mego. Ja'nca ja'megona, harinabë si'abëbi huo'cojaji'i, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ja'nca yihuoguë, ye'yo coca se'gare bain jubëanni quëani achobi. Ja'an coca se'gabi quëaguë, ");
INSERT INTO snnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Riusu ira bainguë ba'isi'quë coca toyani jo'case'e'ru güina'ru yo'oguë baji'i. Ën coca toyani jo'case'e baji'i: Yë'ë yua bainni yihuoza caguë, ye'yo coca se'gare bacuani yihuoguë quëaja'guë'ë yë'ë. Ën yija re'huani jo'casirën ba'iguëna, Riusubi ja'an cocare ro'tani, bainni zoe quëamaji'i. Quëama'iguëna, yurera bainni quëaja'guë'ë yë'ë, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ja'nrëbi, bain jubëanre yihuoni tëjini, bacuare jo'cani, huë'ena goji'i. Go'iguëna, baguëre concuabi baguëna ti'an rani, coca senni achahuë: —Më'ë coca quëase'e, gu'a hui'ya taya ziona tanse'e, ja'anre yëquënani te'e ruiñe quëajë'ën, baguëni senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Senni achajënna, baguëbi sehuobi: —Ba aonra'carëan re'ora'carëanre tansi'quë yua yë'ë'ë. Bainguë'ru Raosi'quëreba'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ba zio yua si'a ën yija re'oto'ë. Ba aonra'carëan re'ora'carëanre ro'tato, yua Riusu bain'ë. Riusu ba'i jobore ba'ija'cua'ë. Ba hui'ya taya tanse'ere ro'tato, gu'a bain'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ba je'o baguë hui'ya tanse'ere ro'tato, ja'anguë yua zupai huati'bi ba'iji. Aon tëarënre ro'tato, ën yija carajeirënre cayë. Aon tëacuare ro'tato, Riusu anje sanhuë'ë cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gu'a hui'ya taya rutani gueonni ëoyete ro'tato, ën yija carajeirën ti'anguëna, ja'nca ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yë'ë yua Bainguë'ru Raosi'quërebabi yë'ë anje sanhuëre choini, bain jubëan ñë'casi'cuana saoja'guë'ë yë'ë. Saoguëna, bacuabi gu'a jucha yo'ojën ba'isi'cuare cu'eni, si'a gu'a bainre quë'ñeni, ");
INSERT INTO snnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","baru ba'i toana senjoni saoja'cua'ë. Saojënna, bacuabi ai oijën, ai ja'siye ai yo'ojën, bacuabi bacua zemeñoa cuncujën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ja'nca ba'ijënna, ja'nrëbi yequëcua re'oye yo'ojën ba'isi'cuabi Taita Riusu ba'i jobore ba'ijën, ënsëguë miañe'ru ai go'sijeiye ba'ija'cua'ë. Yureca, ganjo bacuabi achani ye'yejë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Cani, ja'nrëbi se'e ye'yo cocare yihuoguë quëabi: —Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare achani ye'yejë'ën: Bainguëbi yequëcua ba yijana no'ani, a'ta bonse yahue tanni ta'pise'e ba'iguëna, tinjabi. Ja'nca tinjaguëbi ai bojoguë, ba bonsere se'e ta'pini, ja'nrëbi baguë baye si'aye bendieni, ba yija ëjaguëna sani, baguë yijare coni babi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare achani ye'yejë'ën: Go'sijei curi ëjaguëbi re'o curi perlara'carë te'era'carë quë'rë ta'yejeiye ai ro'ira'carëte tinjabi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ja'nca tinjaguëbi baguë baye si'aye bendieni, ja'anra'carëte coni babi. ");
INSERT INTO snnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Riusu ba'i jobo ba'iyete ye'yeye yëtoca, ën cocare'ga achani ye'yejë'ën: Yequëcuabi huanterëte sani, jai ziayana senjoni, ziaya hua'i hua'na si'a hua'i hua'nare yoni bahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja'nca yoni bacuabi ziaya yëruhuana bëani, ba hua'ire cuencuehuë. Cuencueni, re'o hua'i hua'na ba'itoca, bacua sotoroanna ayani bahuë. Gu'a hua'i hua'na ba'itoca, senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ën yija carajeirën ti'anguëna, Riusu anje sanhuëbi güina'ru yo'oja'cua'ë. Bain jubëanna sani, gu'a bainre quë'ñeni, re'o bainre re'huani baja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ja'nrëbi, gu'a bainre sani, ba toana senjoja'cua'ë. Senjojënna, bacuabi ai oijën ai ja'siye ai yo'ojën, bacua zemeñoa cuncujën ba'ija'cua'ë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ja'nca yihuoguë quëani, baguëre concuani senni achabi: ¿Mësacua yua yë'ë coca yihuose'e si'aye achare? senni achabi. Senni achaguëna, —Jaë'ë. Achahuë, Ëjaguë, cajën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sehuojënna, bacuani se'e yihuoguë quëabi Jesús: —Ja'nca achatoca, mësacua yua Riusu ba'i jobo ba'iyete re'oye ye'yesi'cua ba'ijën, Riusu ira coca ye'yocua'ru si'a bainni ye'yoye porecua'ë. Mësacua ja'anrë masise'e, mësacua yurera mame ye'yese'e, mësacua si'aye masiyete ro'tani, yequëcuani te'e ruiñe ye'yojën ba'ijë'ën. Jai huë'e ëjaguë baye, ira ma'carëan, mame ma'carëan, ja'anre bani, baguë yo'o yo'oye yëtoca, si'a ma'carëanre ëñani, baguë yësi ma'carëte cuencueni, baguë yo'o yo'oye masiji. Ja'anguë ba'iye'ru ba'iyë mësacua'ga, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja'nca quëani, baguë ye'yo cocare yihuoni tëjini, baguë yua huëni, baguë zinrën ba'isi jobona saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sani ti'anni, bain ñë'ca huë'eña, baru ba'i huë'eñana cacani, bainre ye'yobi. Ye'yoguëna, bain hua'nabi ai achajën rëinjën cahuë: —¿Baguë coca ye'yose'e queaca ja'anre masiguë'ne baguë? ¿Baguë ta'yejeiye yo'o yo'oni ëñose'e, queaca yo'oye poreguë'ne baguë? ");
INSERT INTO snnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ro bainguë se'ga ba'iguëbi sunqui te'ntoguë mamaquë ba'iguë'bi. Baguë pë'cago yua María hue'ego. Baguë yo'jecua yua Santiago, José, Simón, Judas, ja'an hue'e hua'na ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Baguë romi yo'jecua si'acua yua mai naconi ba'iyë. Ja'nca sëani, ro mai hua'na ba'iye'ru ba'iguëbi ¿queaca ja'an yo'oye poreguë'ne? cajën, ");
INSERT INTO snnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","baguë cocare achaye güejën, baguëte te'e ruiñe ëñamajën baë'ë. Baguëni ëñañe gu'a güejën baë'ë. Ja'nca ba'ijënna, Jesusbi bacuani cabi: —Riusu bain raosi'cua banica, si'acuabi bacuani te'e ruiñe ëñajën bojoyë. Bacua te'e jobo bain, bacua te'e huë'e bain, bacua se'gabi bacuani gu'aye ro'tajën, bacuani ëñañe gu'a güejën ba'iyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ja'nca caguë, baru ba'icuabi baguëni recoyo ro'taye güecua sëani, baguë ta'yejeiye masiyete yua bacuani masi güeseye poremaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ja'an umuguseñabi si'a re'oto bainbi Jesús ba'iyete achani masijënna, bain ta'yejeiye ëjaguë Herodesbi achani, ");
INSERT INTO snnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","baguë bain concuani cabi: —Juan Bautizaguë'bi ba'iji baguë. Junni huesësi'quëbi yua go'ya raji'i. Ja'nca go'ya raiguëbi ta'yejeiye masiguë ëñoñe poreji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes yua ja'anrë Juanre preso zeanni, ya'o huë'ena preso gueoñe guansebi. Herodías yua baguë yo'jeguë Felipe rënjo ba'igona, Herodesbi bagote tëani babi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ja'nca tëani baguëna, Juanbi Herodesni bëinguë caguë baji'i. —Bagote ja'nca tëani baguëbi ai gu'aye yo'ohuë më'ë, caguë baji'i. Ja'nca sëani, Baguëre preso zeanjë'ën, caguë guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Guanseni, baguëni huani senjoja'ma ro'taguë yo'omaji'i, bain jubëni huaji yëguë sëani. Bacuabi Juanre ëñajën, Riusu raosi'quë'bi ba'iji ro'tajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ja'nrëbi, Herodes të'ya raisi tëcahuë'ru ba'iye ti'anguëna, baguë bain choisi'cuabi ñë'ca raijënna, Herodías mamaco romi zingobi cacani pairago. Pairagona, Herodesbi bagoni ëñani bojobi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ja'nca bojoguëbi bagoni cani jo'cabi: —Më'ëni te'e ruiñe cayë yë'ë. Më'ë gue gu'a ma'carëanre sentoca, më'ëna roreba insiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Caguëna, ja'nrëbi pë'cagobi yihuogona, ba romi zingobi Herodesni senni achago cago: —Juan Bautizaguë sinjobëte tëyoni, guëna re'ahuana tëoni, ënjo'ona rani, yë'ëni ëñojë'ën, cago senco'ë bago. ");
INSERT INTO snnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cagona, Herodesbi ai sa'nti hua'guë runji'i. Ja'nca ruinguëta'an, baguë cani jo'case'e'ru tin yo'oye yëmaji'i, ba bain gajecuabi achasi'cua sëani. Ja'nrëbi, Juanni huani senjojë'ën caguë, ");
INSERT INTO snnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ya'o huë'ena coca saobi. Saoguëna, bacuabi Juan sinjobëte tëyoni, ");
INSERT INTO snnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","guëna re'ahuana tëoni raoni, ba romi zingona insihuë. Insijënna, bago pë'cagona sani ëñogo. ");
INSERT INTO snnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja'nrëbi, Juanre conjën ba'icuabi rani, baguë ga'nihuëte sani tanhuë. Tanni ja'nrëbi, Jesusna sani quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Quëajënna, ja'nrëbi, Jesús yua yoguna cacani, bain beo re'otona quëñëni saji'i. Saiguëna, si'a bain jubëanbi achani, si'a huë'e joboanbi etani, ma'abi saijën, baguëni be'tehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja'nrëbi, Jesús yua baguë sairuna ti'anni, jeni, mëni, ai jai jubë bainre ëñabi. Ja'nca ëñani, bacuani ai oire babi. Bacua ju'in hua'nare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ja'nrëbi na'iguëna, baguëre concuabi ti'anni, baguëni cahuë: —Yua na'iji. Bain beo re'oto'ë ënjo'on. Ja'nca sëani, bacuare saojë'ën. Huë'e jo'borëanna sani bacua aon aiñe coja'bë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Cajënna, Jesús sehuobi: —Bañë. Ja'nca saoma'ina'a. Mësacua se'gabi bacuani aon cuiraje'en, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Caguëna, bacua cahuë: —Yëquëna hua'na yua cinco jo'jo aonbëan, samu ziaya hua'i hua'na, ja'an se'ga bayë ënjo'on, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Cajënna: —Ja'an aonre yë'ëna rani insijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cani ja'nrëbi, si'a bain hua'nani re'o tayahuëanna bëaye guansebi. Guanseni ja'nrëbi, ba cinco jo'jo aonbëan, ba samu ziaya hua'i hua'nare inni, guënamë re'otore mëiñe ëñani, Riusuni surupa cani, aonbëanre jë'yeni, baguëre concuana insibi. Insiguëna, bacuabi yua bain hua'nana insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Insijënna, si'a hua'nabi anni yajihuë. Ja'nrëbi, aon anni jëhuasi mi'chirëanre chiani, doce jë'eña bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ba bain ainsi'cuare ëmëcua se'gare cuencuejënna, cinco mil baë'ë. Romi hua'nare, zin hua'nare cuencuemaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ja'nrëbi, Jesús yua baguëre concuare choini, yoguna cacani, Të'huina je'enjë'ën caguë guansebi. Guanseni, saijënna, baguë yua bain jubëanre quëani saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Saoni tëjini, ja'nrëbi, cu re'otona sani, te'e hua'guë ba'iguëbi Riusuni coca ujabi. Ujani na'ijani, te'e hua'guë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ba'iguëna, baguëre concuabi yogute ba'ijën, jobo zitarate huahuajënna, ai jëja tutu raguëna, të'abi ai huëji'i. Huëiguëna, bacuabi ai yo'ojënna, ");
INSERT INTO snnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ñata ñamibi Jesusbi zitara canja'an ganiguë, bacuana ti'an raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ti'an raiguëna, baguëre concuabi ëñani, ai quëquëreba quëquëjën güihuë: —¡Huatibi raiji! quëquëjën güihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Güijënna, Jesusbi ja'ansi'quë bacuani cabi: —¡Mësacua jëja recoyo bajë'ën! Yë'ë'ë. Quëquëye beoye ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Caguëna, Pedrobi baguëni cabi: —Ëjaguë, më'ë ba'iye te'e ruiñe ba'itoca, yë'ëre'ga zitara canja'an ganiñe guansejë'ën. Më'ë ba'iruna ti'anza, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Caguëna, Jesusbi: —Raijë'ën, sehuobi. Sehuoguëna, Pedro yua yogubi etani, zitara canja'an ganini, Jesús ba'iru tëca saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sani, ja'nrëbi ba jëja tuture ro'tani, ja'nrëbi huaji yë bi'rani, baguë yua ruca bi'rabi. Ruca bi'rani, ai jëja güibi: —¡Ëjaguë, yë'ëre zeanni huëajë'ën! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Caguëna, Jesús yua ja'ansi'quë baguë ëntë sarare mi'nani, Pedrote zeanni, baguëni cabi: —¿Më'ë guere yo'oguë huaji yëguë'ne? ¡Yë'ë ta'yejeiye yo'oye poreyete recoyo ro'taye caraji më'ëre! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Caguëna, ba hua'nabi yoguna cacajënna, tutubi carajaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Carajeiguëna, yogu ba'icuabi Jesusna gugurini rëanni bojohuë. —Riusu Zinreba'ë më'ë, cajën yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ja'nrëbi, bacuabi je'enni, Genesaret yijana ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti'anni mëijënna, baru bainbi baguëni masini, si'a ba re'otona coca saoni, ju'in hua'nare raye guansehuë. Ja'nca guanseni, ju'in hua'nare rani, Jesusni ëñoni, ");
INSERT INTO snnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","baguëni cahuë: Më'ë can na'mire pa'roye se'ga yëyë cajën sen'ë. Senni, si'a hua'na baguë canre pa'rocua, ja'ancuabi huajë raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ja'nrëbi, fariseo bain, ira coca ye'yocua, Jerusalenbi raisi'cuabi Jesusna ti'anni baguëni bëinjën senni achahuë: ");
INSERT INTO snnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Më'ëre concuabi guere yo'ojën, mai ira bain ba'isi'cua yo'ojën ba'ise'e'ru tin yo'oye'ne? Bacua ëntë abumajën, aonre aincua sëani, ai gu'aye yo'ohuë bacua, bëinjën senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Senni achajënna, Jesús sehuoguë cabi: —¿Mësacua'ga guere yo'ojën, ro mësacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru yo'oñu cajën, Riusu guanseni jo'case'e'ru tin yo'oye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Riusu coca guanseni jo'case'ere ro'tajë'ën: “Më'ë pë'caguëni, më'ë pë'cagoni te'e ruiñe ëñajën ba'ijë'ën” cani jo'cabi. “Bainguëbi baguë pë'caguë sanhuëni gu'aye catoca, baguëni huani senjojë'ën” cani jo'case'e'ga ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ja'nca cani jo'case'e ba'iguëta'an, mësacuabi ro tin guansejën ba'iyë: “Mësacuabi mësacua pë'caguë, pë'cago, bacuani: Yë'ë baye si'aye Corbán ba'iji. Riusuna cuencueni jo'case'e'ë cayë. Ja'nca sëani, mësacuana insiye porema'iñë, ja'anre catoca, mësacua pë'caguë sanhuëni conni cuiraye yo'oma'ijë'ën.” Ja'an cocare ro huacha ye'yojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ja'nca ye'yojën, mësacua ira bain ba'isi'cua yo'ojën ba'ise'ere ye'yoñu cajën, Riusu coca guanseni jo'case'ere ro huesoni senjojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ja'nca sëani, mësacuabi re'o bain ba'iye ro cajën, ro coqueyë. Riusu ira bainguë ba'isi'quë, Isaías hue'eguë ba'isi'quëbi mësacua yure ba'iyete ai masiye quëabi: ");
INSERT INTO snnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Judío bainbi Riusuni te'e ruiñe ëñañe'ru ëñojën, ro bacua yi'oboan se'gabi re'oye cajën, ro coqueyë. Ja'nca cajën, bacua recoñoabi baguëni ro'tamajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ro coquejën, Riusuni ro gugurini rëanjën ba'iyë. Ro ën yija bain ro'tase'e se'gare ye'yojën, Riusu cocareba'ë cajën, ro coqueyë, toyani jo'cabi Isaías, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja'nca cani, ja'nrëbi, bain hua'nare choini, bacuani yihuoguë cabi: —Mësacua te'e ruiñe achani ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bain aon ainse'ebi gu'ajeiye beoye ba'iyë. Bain recoyo ro'tani case'e se'ga, ja'an se'gabi gu'ajeijën ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Caguëna, ja'nrëbi, baguëre concuabi baguëna sani quëahuë: —Më'ëbi yure coca caguëna, fariseo hua'na chao hua'nabi ai oijën, ai yo'ojën achahuë, quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Quëajënna, Jesús sehuobi: —Bacua oijën ba'iyete ro'tama'ijë'ën. Yë'ë Taita Riusu guënamë re'oto ba'iguëbi si'a sunquire, si'a sahuare ëñani, baguë tanma'ise'e banica, gare rutani senjoja'guë'bi. Ja'nca case'e sëani, bacua coca ye'yoyete achama'ijë'ën. Bainni te'e ruin ma'are ëñoñu cajën ba'icuata'an, ro coqueyë. Ñaco ëñama'icua'ru ba'iyë. Ñaco ëñama'iguëbi yua yequë ñaco ëñama'iguëni ma'are ëñoza caguë, baguëte satoca, ba samucuabi ro yorobëna tonni huesëyë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Caguëna, ja'nrëbi, Pedrobi baguëni coca senni achabi: —Më'ë ye'yo coca yure case'e yëquënani te'e ruiñe quëajë'ën, senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Senni achaguëna, Jesús sehuobi: —¿Mësacua yua ro huesë ëaye achare? ");
INSERT INTO snnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ja'nca ba'itoca, mësacua te'e ruiñe achani ye'yejë'ën. Bain aon ainse'ebi guëtabë se'gana ti'anni, ja'nrëbi ro anni saoye se'gabi etani huesëji. ");
INSERT INTO snnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bain recoyo ro'tani yi'obobi case'e'ga ja'anbi cajën, ro gu'ajeijën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bainbi ro recoyo ro'tajën, gu'aye se'gare ro'tani, gu'aye yo'ojën ba'iyë. Bainre huani senjojën, ëmëcua romicua sa'ñeña ro yahue bajën ro a'ta yo'ojën, bonsere jianjën, ro coquejën bain gu'aye yo'ose'ere tinja cajën, bainre gu'aye cajën, ja'anre gu'aye yo'ojën ganiñë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ja'nca gu'aye ro'tajën, gu'ajeijën ba'iyë bain hua'na. Ëntë abumajën aon aintoca, bainbi gare gu'ajeiye beoye ba'iyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ja'nrëbi, Jesusbi sani, Tiro, Sidón, ja'anruan ba'i yijana etani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sani, ti'anguëna, yureca baru ba'i romigo, cananea baingobi Jesusna rani, ai güigo quëago: —Ëjaguë, mai ira taita David bainguë, yë'ëre oire bani conjë'ën. Yë'ë zin hua'gobi huati zemosi'co ai yo'ogo, güigo quëago. ");
INSERT INTO snnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Güigo quëagona, gare sehuoye beoye baji'i baguë. Ba'iguëna, baguëre concuabi baguëni senreba sen'ë: —Bagote saojë'ën. Yëquënani ai hui'ya güigo bago, senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Cajënna, Jesús sehuobi: —Israel bain yua Riusu bain quëñëni saisi'cua, oveja hua'na ro quëñëni huesësi'cua'ru ba'ijënna, ja'ancua se'gana raosi'quë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sehuoguëna, ba hua'go yua Jesusna gugurini rëanni cago: —¡Ëjaguë, yë'ë hua'goni conjë'ën! cago. ");
INSERT INTO snnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Cagona, baguë sehuobi: —Tin bainre ru'ru contoca, gu'aji. Bain zin hua'na aonre tëani, jo'ya yai hua'nana aoñe, ja'ncara'ru yo'otoca, gu'aji sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sehuoguëna, bagobi cago: —Te'e ruiñe cahuë më'ë, Ëjaguë. Ja'nca caguëta'an, jo'ya yai hua'nabi bacua ëjaguë aon zi'nga mesabi to'inse'ere aiñë, cago bago. ");
INSERT INTO snnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ja'nca cagona, Jesusbi sehuobi: —Mami, yë'ëni ai ta'yejeiye recoyo ro'tago, re'oye sehuohuë më'ë. Ja'nca sëani, më'ë yëye'ru ba'iye, güina'ru yo'ose'e'ë, sehuoguë quëabi. Ja'nca quëaguëna, bago mamacobi ja'ansi'co huajë raco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ja'nrëbi, Jesusbi etani sani, Galilea zitara yëruhuana ti'anni, ja'nrëbi, cu re'otona mëni, ja'anruna bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ba'iguëna, ai jai jubëan bainbi baguëna ti'an raë'ë. Bacua bain ëntë saraña guëoña garasi'cua, ca'jacua ñaco ëñama'icua, yi'o ma'tëbëan ba'icua, yequëcuare'ga Jesús guëon na'mi tëca rani umeni, baguëni ëñohuë. Ëñojënna, bacuare huachobi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Huachoguëna, bain hua'nabi ëñani, yi'o ma'tëbëan ba'isi'cuabi coca cajënna, ëntë saraña guëoña garase'e ba'isi'cuabi huajë raijënna, ca'jajën ba'isi'cuabi te'e ruiñe ganijënna, ñaco ëñamajën ba'isi'cuabi ëñajënna, ja'nca huajë raijënna, bain hua'nabi ai ëñajën rëinjën, Israel bain Riusubi ai ta'yejeiye ëñasi'quë'bi ba'iji cajën, baguëni ai ta'yejeiye cajën bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ja'nrëbi, Jesús yua baguëte concuare choini, bacuani cabi: —Ën bainbi samute umuguseña yë'ë naconi ba'ijën, aon aiñe beojënna, bacuani ai oire bayë yë'ë. Bacua yua ro aon gu'ana ju'incuabi ma'ana ro pa'npani gurujeima'iñe caguë bacuare saoye yëma'iñë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Caguëna, baguëre concuabi sehuojën senni achahuë: —Yua ën re'oto beo re'oto ba'iguëna, ¿bacua aon aiñe jarona cu'eye'ne mai? Ai jai jubë bain sëani, porema'iñë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sehuojënna, Jesusbi senni achabi: —¿Mësacua jo'jo aonbëan quejeibëan baye'ne? senji'i. Senni achaguëna: —Te'e ëntë sara samubëanre bayë. Ziaya hua'ire'ga rëño hua'na, samu hua'nare bayë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sehuojënna, Jesusbi bain hua'nani yijana bëa güesebi. ");
INSERT INTO snnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bëa güeseni, ja'nrëbi, jo'jo aonbëan te'e ëntë sara samubëanre, ba ziaya hua'ire inni, Riusuni surupa cani, ja'nrëbi jë'yeni, baguëre concuana insibi. Insiguëna, bain jubëanna huo'hueni insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Insijënna, si'a hua'nabi anni yajihuë. Yajijënna, aon anni jëhuase'ere chiani, te'e ëntë sara samu jë'eña bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ba aon ainsi'cuare ëmëcua se'gare cuencuejënna, cuatro mil baë'ë. Romi hua'nare, zin hua'nare cuencuemaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ja'nrëbi, Jesús yua bain hua'nare saoni, ja'nrëbi yoguna cacani, Magdala yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ja'nrëbi, fariseo bain, saduceo bain, bacuabi Jesusna tëhuo rani, Baguëni huacha sehuo güeseñu cajën, Riusu ta'yejeiye yo'oni ëñoñe baguëni sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Senjënna, baguëbi yua sehuobi: —Mësacua yua na'ito ba'iguëna, guënamë re'otona ëñani, “Majei pico sëani, re'o ñami ba'ija'guë'bi” cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ja'nrëbi ñataguëna, mësacuabi ëñani, “Majei picobi ëñoguëna, oco ca'niji” mesacua cayë. Mësacuabi: Ai masiye ro'tani quëayë mai, cajën, ro coquejën ba'iyë. Guënamë re'oto ba'iyete masini cacuata'an, yureña ba'ija'yete masini caye mësacua gare huesëcua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yureña bainbi ai gu'aye yo'ojën yë'ëni ta'yejeiye yo'o yo'oni ëñoñe señë. Ja'nca sencuareta'an, gare ëñoñe beoye ba'iyë. Riusu ira bainguë raosi'quë Jonás hue'eguë ba'isi'quë, baguë ba'ise'e se'gare quëani masi güeseyë yë'ë, sehuoguë cabi Jesús. Ja'nca cani, bacuare jo'cani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sani, baguëre concua naconi que të'huina jen'ë. Jenni ti'anni, baguëre concua yua aonre saye huanë yehuë cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ja'nca cajën ba'ijënna, Jesusbi bacuani yihuoguë cabi. —Mësacua ëñare bajë'ën. Fariseo bain, saduceo bain, bacua aon huo'coye ro'tamajën ba'ijë'ën, yihuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Caguëna, bacuabi sa'ñeña coca ca bi'rahuë: —Aonre saye huanë yesi'cuare sëani, ja'nca maini yihuoji baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Cajënna, Jesusbi bacua case'ere masini, bacuani bëinguë cabi: —Yë'ëni recoyo ro'taye mësacuare ai caraji. ¿Mësacua queaca ro'tajën, aon saye huanë yese'e sa'ñeña caye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mësacuabi ñaco bajën, ¿guere ëñama'iñe'ne? Mësacua yua ro huesë ëaye ba'ijën, yuta ye'yemajën ba'iyë. Yë'ëbi te'e ëntë sara jo'jo aonbëan naconi cinco mil bainni aonguëna, ¿mësacua ja'anre huanë yete? ¿Mësacua chiase'e, quejei jë'eña chiase'ere ro'tamajën huanë yete? ");
INSERT INTO snnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ja'nrëbi, yë'ëbi te'e ëntë sara samu jo'jo aonbëan naconi cuatro mil bainni aonguëna, ¿mësacua ja'anre huanë yete? ¿Mësacua chiase'e, quejei jë'eña chiase'ere ro'tamajën huanë yete? ");
INSERT INTO snnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mësacuabi ja'an ba'ise'ere huanë yema'itoca, yë'ë yure yihuoguë case'ere achani, aon sayete camaë'ë yë'ë. Mësacua yua ja'anre ro'tani masijë'ën. Mësacua yua ëñare bajë'ën. Fariseo bain, saduceo bain, bacua aon huo'coye ro'tamajën ba'ijë'ën, cahuë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Caguëna, ja'nrëbi, bacua yua se'e ro'tani, baguë coca yihuose'ere masihuë. Ro aon huo'coyete camaji'i baguë. Fariseo bain, saduceo bain, bacua coca ye'yoye, ja'anre ëñare bajën ro'tamajën ba'ijë'ën, cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja'nrëbi, Jesús yua Cesarea Filipo casi re'otona ti'anni, baguëre concuani coca senni achabi: —Bainbi yë'ëre, Bainguë'ru Raosi'quëreba ba'iguëte cajën, ¿gueguëguë'ne yë'ëre caye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Senni achaguëna, bacua sehuohuë: —Yequëcuabi më'ëre cajën, Juan Bautizaguë'bi më'ëre cayë. Yequëcuabi, Elías'bi më'ëre cayë. Yequëcuabi, Jeremías'bi, o yequë Riusu ira bainguë raosi'quë'bi më'ëre cayë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sehuojënna, baguëbi senni achabi: —Mësacua'ga cajën, ¿gueguëguë'ne yë'ëre caye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Senni achaguëna, Simón Pedrobi sehuobi: —Më'ë yua Riusu Raosi'quëreba'ë. Ba Cristo ba'iguë'ë më'ë. Mai Taita Riusu huajëreba huajëguë ba'iguë, baguë Zinreba ba'iguë'ë më'ë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ja'nca quëaguëna, Jesusbi sehuoguë cabi: —Simón, Jonás mamaquë, ai ta'yejeiye ai re'oye ba'ija'guë'bi më'ëre. Ro ën yija bain hua'nabi ja'an cocare më'ëni quëamaë'ë. Yë'ë Taita Riusu guënamë re'otore ba'iguëbi ja'anre quëaguëna, më'ëbi achani masihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yureca, më'ëni ñaca yihuoguë cayë yë'ë. Më'ë yua Pedro hue'eyë. Hue'eguëna, më'ë coca yure quëase'e yua te'e ruiñe quëase'e sëani, jai gatabë jëja baye'ru gare carajeiye beoye ba'ija'guë'ë më'ë. Ja'nca ba'iguëna, yë'ëbi ja'an coca quëase'ere jo'caguë, yë'ë bainreba jubëte ta'yejeiye re'huani yo'oja'guë'ë yë'ë. Ja'nca yo'oguëna, si'a zupaire concua gu'aye guansejën ba'icuabi yë'ë bainreba jubëte quëñoni senjoñe gare porema'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja'nrëbi, Riusu ba'i jobo caca sa'ro re'hua ëjaguëre më'ëre re'huaja'guë'ë yë'ë. Më'ëbi ën yija ënseye guanseguëna, Taita Riusu guënamë re'oto ba'iguëbi güina'ru te'e ënseye caja'guë'bi. Më'ëbi ën yija yo'oye jo'caye guanseguëna, Taita Riusu guënamë re'oto ba'iguëbi güina'ru te'e jo'caye caja'guë'bi, Pedroni yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cani ja'nrëbi, baguëre concuani si'a jëja yihuoguë, baguë Cristo ba'iye, Riusu Raosi'quëreba ba'iye, ja'anre yequëcuani gare quëama'ijë'ën bacuani yihuoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ja'nrëbi, Jesús yua baguëre concuani ñaca yihuoguë quëa bi'rabi: —Yë'ë yua Jerusalén huë'e jobona sani, ai ta'yejeiye ai ja'siye ai yo'oye bayë. Ira ëja bain, pairi ëjacua, ira coca ye'yocua, ja'ancuabi yë'ëni ai je'o bajën, ai gu'aye yo'ojën, yë'ëni huani senjoja'cua'ë. Huani senjocuareta'an, samute umuguseña bani, go'ya raija'guë'ë yë'ë, caguë, bacuani yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Quëaguëna, Pedro yua baguëte ca'ncona sani, baguëni bëinguë ca bi'rabi: —¡Ëjaguë, më'ë case'e'ru gare beoja'guë'bi! ¡Më'ëni gare ja'nca yo'oma'ija'cua'ë! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Caguëna, Jesusbi Pedrona bonëni cabi: —¡Quëñëni saijë'ën! Më'ëbi zupai huati caye'ru caguë, yë'ë yo'oja'yete ro gu'aye ënse ëaye yo'oyë më'ë. Ja'nca sëani, Riusu ro'taye'ru tin ro'tayë më'ë. Ro ën yija bain ro'taye'ru te'e ro'tayë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cani, ja'nrëbi baguëre concuani yihuoguë cabi: —Bainbi yë'ëni te'e coñe yëtoca, bacua ba'iyete ro'tamajën ba'ija'bë. Yë'ë ai yo'oja'ye'ru ai yo'oye ro'tajën ba'icuabi yë'ë naconi te'e yo'o conjën raija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ro bacua ba'iye se'gare ro'tatoca, bacuabi huesëni si'ayë. Ro bacua ba'iyete ro'tamajën, yë'ë yo'ore satoca, bacuabi carajeiye beoye huajëreba huajëja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bainbi si'a ën yija ba'iyete bani, ja'nrëbi junni huesëtoca, bacua bonse base'ere coye gare porema'iñë. Ro guaja yo'o yo'osi'cua ba'iyë. Bacuabi gare se'e huajë rani bonse baye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi yë'ë guënamë re'oto yo'o concua naconi raiguë, yë'ë Taita Riusu ta'yejeiye go'sijeiye'ru ai ta'yejeiye ai go'sijeiguëbi ti'an raija'guë'ë yë'ë. Ti'an rani, ja'nrëbi, si'a bain yo'o yo'ojën ba'ise'ere cuencueni, bacua ro'ija'yete insija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yureca, mësacuani ganreba yihuoguë quëayë yë'ë. Mësacua jubë ba'icua yequëcua ënjo'on nëcacuabi yuta junni huesëma'iñë. Ru'ru yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi ai ta'yejeiye ëjaguë ba'iye'ru guënamë re'otobi raiguëna, mësacuabi ëñaja'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cani ja'nrëbi, te'e ëntë sara te'e ba'i umuguse, Jesusbi yua ëmë cubëna mëji'i. Mëni, Pedro, Santiago, Santiago yo'jeguë Juan, bacua se'gare ja'anruna mëabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mëani, bacuabi ëñajënna, baguë ba'iye yua tin ëñobi. Baguë zia yua ënsëguë ma'ñoñe'ru ai go'sijei ziara runji'i. Baguë caña yua mia re'oto ñatani saoye'ru ai ta'yejeiye ai pojeiyereba ai go'sijei cañara runji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ja'nrëbi, Moisés, Elías, bacuabi gaje meni nëcahuë. Jesús naconi coca cajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ja'nca nëcajënna, Pedrobi Jesusni cabi: —Ëjaguë, ¡maibi ënjo'onre ba'ijënna, ai re'oye ba'iji! Ja'nca sëani, më'ëbi yëtoca, samute huë'erëanre yo'ozaniñë. Te'e huë'erë më'ëre yo'ocaiyë. Te'e huë'erë Moisesre yo'ocaiyë. Te'e huë'erë Elíasre yo'ocaiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yureca, Pedrobi yuta coca cani tëjima'iguëna, picobë ai miañe ba'ibëbi nëca meni, bacuare na'oguëna, picobë sa'nahuëbi bain cocare achoni raobi: —Ënquë yua yë'ë Zin ai yësi'quë'bi ba'iji. Baguëni ai ba'iye ai bojoyë yë'ë. Baguëbi coca caguëna, mësacua achajën ba'ijë'ën, achoni raobi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ja'nca achoni raoguëna, Jesusre concuabi ai ba'iye ai achajën ruinjën, yijana tanni umehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tanni umejënna, ja'nrëbi Jesús yua bacuana pa'roni cabi: —Mësacua huëijë'ën. Huaji yëye beoye gare ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Caguëna, bacuabi mëiñe ëñani cu'eto, Jesús se'gabi bacua naconi baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ja'nrëbi, cubëbi gajejën, Jesusbi bacuani coca guansebi: —Mësacua guënamë toya yure ëñase'e yua yequëcuani gare quëaye beoye ba'ijë'ën. Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi junni tonni go'ya raiye tëca ja'nca quëaye beoye ba'ijë'ën, guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Caguëna, baguëre concuabi baguëni senni achahuë: —Ira coca ye'yocuabi, Elíasbi ru'ru ti'an raiye ba'iji cajën, ¿guere ro'tajën caye'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Senni achajënna, sehuoguë quëabi: —Te'e ruiñe cayë bacua. Elíasbi ru'ru ti'an raiye ba'iji. Si'aye mame re'huaguë raiji. ");
INSERT INTO snnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yureca, mësacuani ganreba cayë yë'ë. Elíasbi yuara ti'an raisi'quë baji'i. Ja'nca ba'iguëna, baguëre je'o bacuabi baguëte huesëjën, ro bacua gu'a ëase'ere baguëni gu'aye yo'ojën baë'ë. Ja'nca yo'ojën ba'icuabi yë'ëre'ga, Bainguë'ru Raosi'quëreba ba'iguëna, yë'ëni ai gu'aye yo'ojënna, ai ba'iye ai yo'oja'guë'ë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ja'nca quëaguëna, baguëre concuabi achani, Juan Bautizaguë ba'iyete quëaguëna, masihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ja'nrëbi, bain jubë ba'iruna ti'anjënna, yequëbi Jesusna ti'an rani, gugurini rëanni cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ëjaguë, yë'ë zinni ai oire bani conjë'ën. Hue'nhue neni, toana tainguë yua ziayana tonni ruiguë yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ja'nca yo'oguëna, më'ëre concuabi huachoja'bë caguë, baguëte rahuë. Raguëna, bacua poremaë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Caguëna, Jesusbi bacuani cabi: —¡Yë'ëni si'a recoyo ro'taye ai caraji mësacuare! ¡Ro ën yija bain gu'aye ro'taye'ru ro ro'tajën ba'iyë mësacua! ¿Mësacuani yuta quejei zoe ye'yoye baye'ne? ¿Mësacua ye'yeye quejei zoe yuta ëjoye baye'ne yë'ë? Ba hua'guëre yua yë'ëna rajë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Cani, baguëte rajënna, ba gu'a hue'nhue huatini bëinguë guanseni cabi. Caguëna, huatibi etani saiguëna, zin hua'guëbi ja'ansi'quë huajë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ja'nrëbi jë'te, ba concua se'gabi Jesusna rani senni achahuë: —¿Yëquëna hua'na guere ba huatire etoni saoye poremate'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Senni achajënna, sehuobi: —Mësacuare yë'ëni recoyo ro'taye caraguëna, huatire etoni saoye poremaë'ë. Mësacuani ganreba yihuoguë cayë. Mostazara'carë ai zinra'carë ba'iguëna, mësacuabi ja'an se'gare'ru yë'ëni recoyo ro'tatoca, que cubëna, Ja'anse'e quëñëni yequëruna saijë'ën guansejënna, ja'anse'ebi quëñëni saiji. Mësacuabi yë'ë poreyete te'e ruiñe recoyo ro'tajën ba'itoca, si'aye yo'oye poreyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ja'an huati hua'ire etoni saoye yëtoca, mësacuabi aon aiñe jo'cajën, Riusuni ujareba ujajën ba'ijë'ën, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ja'nrëbi, bacuabi se'e Galilea yijare te'e ba'ijën ganijënna, Jesusbi bacuani yihuoguë quëabi: —Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëna, yequëcuabi yë'ëre preso zeanni, gu'a bainna insija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Insijënna, bacuabi yë'ëni huani senjoja'cua'ë. Huani senjorena, ja'nrëbi, samute umuguseña bani, yë'ëbi go'ya raija'guë'ë, quëabi. Ja'nca quëaguëna, bacuabi achani, ai ba'iye ai sa'nti hua'na baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ja'nrëbi, Capernaum huë'e jobona ti'anjënna, Riusu huë'e impuesto curi cocuabi Pedrona sani, baguëni senni achahuë: —¿Më'ë ëjaguë yua ba impuesto curire ro'iguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Senni achajënna: —Jaë'ë. Ro'iji, sehuobi. Ja'nca sehuoni, ja'nrëbi huë'ena ti'anni, ro'i cocare Jesusni senni achaza caguëna, Jesusbi ru'ru baguëni senni achabi: —¿Guere ro'taguë'ne, Simón? Ën yija bain ta'yejeiye ëjacuabi impuesto curire senni achajën, ¿jarocuani señe'ne? ¿Bacua te'e bainni, o tincuani ro'iye señe? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Senni achaguëna, Pedrobi: —Tincuani ro'iye señë, sehuobi. Sehuoguëna, Jesusbi cabi: —Te'e ruiñe cahuë më'ë. Ja'nca ba'iguëna, ta'yejeiye ëjacua te'e bain yua gare ro'iye beoye ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ja'nca ba'itoca, impuesto curi sencuabi bëinma'iñe cajën, ba curire roñu. Zitarana sani, huitose'enre senjoni, hua'ire maujë'ën. Ru'ru mausi'quëre inni, baguë yi'obote ya'oni ëñato, curi so'cohuare tinjaja'guë'ë më'ë. Ja'an so'cohuate sani, mai samucua impuesto ro'iyete ba impuesto sencuana insijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Caguëna, ja'nrëbi, Jesusre concuabi baguëna rani, baguëni senni achahuë: —Riusu ba'i jobona ti'anjën, yëquëna jubë ba'icuare ba'iguë, ¿jaroguëbi quë'rë ta'yejeiye ëjaguë ba'ija'guëguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Senni achajënna, baguë yua zin hua'guëre choini, bacua jobona nëconi ëñoni, ");
INSERT INTO snnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","bacuani yihuoguë cabi: —Mësacuani ganreba yihuoguë cayë yë'ë. Mësacua ro'tajën ba'iyete jo'cani, zin hua'na ro'tajën ba'iye'ru ro'tajën ba'ijë'ën. Ja'nca ba'ima'itoca, Riusu ba'i jobona ti'añe gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ën hua'guë zin hua'guë ba'iye'ru ba'itoca, yequëcua ba'iye'ru quë'rë yo'jereba ba'iguë'ë yë'ë ro'taguë ba'itoca, ja'anguëbi Riusu ba'i jobona ti'anni, quë'rë ta'yejeiye ëjaguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yë'ë ba'iyete ro'tajën, zin hua'na ënquë'ru ba'icuani conjën ba'itoca, yë'ëre'ga güina'ru ai conjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zin hua'na ënquë'ru ba'icuabi yë'ëni si'a recoyo ro'tajënna, bacuare gare gu'aye yo'oye beoye ba'ijë'ën. Bainguëbi yua te'eguëni gu'a jucha yo'o güesetoca, baguëni ai bëinreba bënni senjoja'guë'bi Riusu. Ru'ru jai gata to'obëbi inni, baguë ñaje tëcana gueonni, baguëte jai ziayana senjoni rëotoca, baguëte quë'rë re'oye ba'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bainbi gu'aye yo'ojën, yequëcuani jucha yo'o güesejën ñu'ñujeima'iñë. Ja'nca ba'ijënna, bacuani ai bënni senjoñe cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yureca, më'ë ëntë sarabi, më'ë guëonbi gu'a juchare yo'o ëaye ro'tatoca, tëyoni senjotoca, quë'rë re'oye ba'ire'abi. Te'e ëntë sara se'ga, o te'e guëon se'ga baguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji. Samu ëntë saraña, samu guëoña baguëbi jai toana senjosi'quë ba'itoca, ai gu'aye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Më'ë ñacogabi gu'a juchare yo'o ëaye ro'tatoca, më'ë ñacogate rutani senjotoca, quë'rë re'oye ba'ire'abi. Te'e ñacoga se'ga baguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji. Samu ñacogaña baguëbi jai toana senjosi'quë ba'itoca, ai gu'aye ba'iji. Ja'nca sëani, gu'a jucha yo'oye gare jo'cani senjojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ja'nca sëani, mësacua ëñare bajën, zin hua'na ënquë zin hua'guë ba'iye'ru gare gu'aye yo'oye beoye ba'ijë'ën. Te'eguëtere'ga gare gu'aye yo'oye beoye ba'ijë'ën. Mësacuani ganreba yihuoguë quëayë. Bacua anje hua'na ëñajën cuiracuabi yë'ë Taita Riusu guënamë re'oto ba'iguëte gare jo'caye beoye baguë naconi te'e ba'ijën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi gu'a ma'ana ganijën huesëcuare cu'eni, bacuare tëani baza caguë, ja'an raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mësacua yua ën cocare ro'tani ye'yejë'ën. Jo'ya baguëbi yua cien oveja hua'na baguëbi, te'eguëbi quëñëni huesëguëna, ¿queaca yo'oguë'ne? Baguë oveja jubë, noventa y nueve ba'icuare cu jabana jo'cani, ba quëñëni huesësi'quëni cu'eguë saiji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cu'eni, baguëte tinjatoca, mësacuani ganreba quëayë, baguëte ai ta'yejeiye ai bojoji. Baguë oveja jubë noventa y nueve ba'icua quëñëni huesëma'isi'cuare bojoye'ru baguëte quë'rë ta'yejeiye ai bojoji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ja'nca ba'iguëna, yë'ë Taita Riusu guënamë re'otore ba'iguëbi ëncua zin hua'nani ëñaguë, Huesëni si'aye gare beoye ba'ija'bë caguë ëñaji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Më'ë te'e bainguëbi më'ëni gu'aye yo'otoca, baguëna sani, baguë juchare quëajë'ën. Quëaguëna, më'ëni achani bojotoca, re'oji. Më'ë bainguë naconi recoyo te'e zi'inni ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Më'ëni achaye güetoca, yequëcua më'ë baincua, te'eguë o samucuare choini sani, më'ë te'e bainguë gu'aye yo'osi'quëni coca senni achajë'ën. Senni achaguëna, më'ë bain concuabi baguë sehuose'ere achani, baguë juchare te'e ruiñe masiye poreyë. Riusu ira coca toyani jo'case'e'ru güina'ru ba'ija'guë: Samucuabi o samutecuabi te'e quëatoca, te'e ruiñe quëayë, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ja'nca senni achaguëna, ja'nrëbi, gu'aye yo'osi'quëbi më'ë bain concua yihuojën cayete yuta achaye güetoca, baguë gu'aye yo'ose'ere si'a hua'na Riusu bainreba jubë ba'icuani quëajë'ën. Quëaguëna, bacuabi yihuojënna, ja'nrëbi yuta achaye güetoca, ro gu'a bainguë ba'iye'ru baguëni ëñamajën ba'ijë'ën. Më'ë bain jubë ba'ima'iguë, impuesto curi coguë, bacua gu'aye ba'iyete ëñañe'ru, baguëni ëñamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mësacuani ganreba yihuoguë quëayë yë'ë. Mësacua ën yija ënseye cajënna, Taita Riusu guënamë re'oto ba'iguëbi güina'ru te'e ënseye caja'guë'bi. Mësacuabi ën yija yo'oye jo'caye cajënna, Taita Riusu guënamë re'oto ba'iguëbi güina'ru te'e jo'caye caja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ñaca'ga mësacuani yihuoguë quëayë. Mësacua jubë ba'icua samucua se'gabi te'e ro'tajën, Riusuni te'e sentoca, yë'ë Taita Riusu guënamë re'oto ba'iguëbi gare ënseye beoye mësacuare yo'ocaija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Samucua o samutecua, yë'ë ba'iyete recoyo ro'tajën ba'icuabi te'eruna ñë'ca raijënna, yë'ë'ga bacua naconi te'e ba'iyë yë'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Caguëna, ja'nrëbi, Pedrobi rani, Jesusni coca senni achabi: —Ëjaguë, yë'ë bainguëbi yë'ëni gu'aye yo'oni, ja'nrëbi yë'ëni huanë yeye sentoca, yë'ëbi huanë yeye cayë. Ja'nrëbi, se'e gu'aye yo'oni se'e huanë yeye sentoca, ¿quejei viaje baguëni huanë yeye caye baye'ne yë'ë? ¿Siete tëca caye baye yë'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Senni achaguëna, Jesús sehuobi: —Ja'an se'ga catoca, ai caraji më'ëre. Më'ë huanë yeyete senni achaguëna, gare jo'caye beoye baguëni setenta y siete tëca huanë yeye caguë ba'ijë'ën, cayë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sehuoni ja'nrëbi, bacuani se'e coca yihuoguë quëabi Jesús: —Riusu ba'i jobo ba'iyete ye'yeye yëtoca, bain ta'yejeiye ëjaguë yo'ose'ere ro'tani ye'yejë'ën. Baguëre yo'o concua curi debese'ere senni achaza caguë, bacuani te'ena, te'ena, choji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Choiguëna, te'eguë, ai ta'yejeiye debe baguë, millón ja'o quë'rë ta'yejeiye debe baguëre ba ëjaguëna nëcohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nëcojënna, baguë debese'ere ro'iye porema'iguëna, ëjaguëbi baguëte bendieye guansebi. Baguë, baguë rënjo, baguë zin hua'na, si'a jubëte bendieni, curi coni, ja'an curibi baguë debese'ere ro'iye ba'iji, caguë guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Guanseguëna, ba yo'o conguëbi ëjaguëna gugurini rëanni, baguëni senreba senni achabi: “Ëjaguë, yuta bëiñe beoye ëjojë'ën. Si'aye bojora'rë ro'iyë yë'ë” senreba senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ja'nca senni achaguëna, ëjaguëbi baguëni oire bani, baguë debese'e beorure tënoni, si'aye huanë yeye cani, baguëte debema'iguëte re'huani etobi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Etoguëna, ba yo'o conguëbi etani, yequë baguë gajeguë cien ja'o debesi'quëre tëhuobi. Tëhuoni, bënni, baguë ñajemona zeanni, Më'ë curi debese'ere ro'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Caguëna, baguë gajeguëbi gugurini rëanni baguëni senreba senni achabi: “Yuta bëiñe beoye ëjojë'ën. Si'aye bojora'rë ro'iyë” senreba senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Senguëna, baguë yua ëjoye güeguëbi baguë gajeguëte preso zeañe guanseni, Më'ë ro'iye tëca ya'o huë'ere ba'ijë'ën cani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jo'caguëna, yequëcua baguë gaje concuabi baguë yo'ose'ere ëñani, ai oire bajën, bacua ëjaguëna sani, si'aye quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Quëani achojënna, ëjaguëbi baguëte choini, baguëni bëinguë cabi: “¡Ai gu'aye yo'ohuë më'ë! Më'ëbi senreba senni achaguëna, më'ë debese'e si'aye tënoni, huanë yeye cahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ja'nca më'ëni oire bani conguëna, më'ë gajeguëni güina'ru oire bani conre'ahuë më'ë” caguë bënji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ja'nca bëinguëbi baguë ya'o huë'e si'nsecuare choini, Baguë si'aye ro'iye tëca baguëni si'nsejën ba'ijë'ën, caguë guansebi, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ja'nca quëani, ja'nrëbi bacuani ñaca yihuoni tëjibi: —Mësacua'ga më'ë te'e bainni te'e ruiñe oire bani, bacua gu'aye yo'ose'ere güina'ru huanë yeye cajë'ën. Ja'nca cama'itoca, yë'ë Taita Riusu, guënamë re'oto ba'iguëbi mësacuani güina'ru si'nseja'guë'bi, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja'nrëbi, baguë cocare yihuoni tëjini, Galilea yijabi sani, Judea yija, Jordán ziaya que ca'nco ba'i re'otona sani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sani ba'iguëbi, jai jubëan bainbi be'tejënna, bacua ju'in hua'nare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huachoguëna, ja'nrëbi fariseo bainbi ti'an rani, Baguëni huacha sehuo güeseñu cajën, baguëni cocare ro coquejën senni achahuë: —Bainguëbi baguë rënjore jo'cani senjoñe yëtoca, ¿ro baguë yëse'e'ru bagote jo'cani senjoñe poreguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Senni achajënna, sehuobi: —¿Mësacua yua Riusu cocare queaca yo'ojën ye'yemate'ne? Ru'rureba ba'isirën, Riusubi bainre re'huaguë, ëmëguëte, romigote, re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ja'nca re'huaguë, yua ñaca cani jo'cabi: “Yureca ëmëguëbi baguë pë'caguëte pë'cagote gare jo'cani, baguë rënjoni zi'inni ba'ijë'ën. Ja'nca ba'iguëna, ba samucuabi te'e bainguë ba'iye'ru ba'iyë” cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ja'nca cani jo'caguëna, bacua yua samucua ba'iye'ru ba'ima'iñë. Te'e bainguë ba'iye'ru ba'iyë. Ja'nca ba'ijënna, Riusu re'huani zi'insi'cuare sëani, ro bainbi gare quëñoñe beoye ba'ija'bë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Caguëna, baguëni senni achahuë: —Ja'nca ba'itoca, ¿Moisesbi queaca ro'taguë, tin guanseni jo'caguë'ne? Bain rënjore jo'cani senjoñe yëtoca, bagote senjo cocare utina toyani bagona insijë'ën, cani maina jo'cabi, senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Senni achajënna, sehuobi: —Mësacua achaye gu'a güecua sëani, Moisesbi mësacua rënjore jo'cani senjoñe ënsemaji'i. Ja'nca ënsema'iguëna, Riusubi ru'rureba ba'isirënbi ja'nca ro'tamaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yë'ë'ga yureca ñaca yihuoguë cayë: Si'a bain rënjore jo'cani senjoni, bagobi yequëni yahue bama'itoca, ja'nrëbi yeconi huejatoca, ai gu'aye yo'oyë. Si'a bain yua romigo jo'cani senjosi'coni huejani bacua, ja'ancua'ga ai gu'aye yo'oyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Caguëna, baguëre concuabi baguëni cahuë. —Yureca, bainbi bacua rënjo naconi ja'nca bajën ba'itoca, bainbi romi beocua ba'ire'ahuë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Cajënna, Jesús sehuobi: —Si'a bainbi mësacua case'ere achani masiye porema'iñë. Riusu cuencuesi'cua se'gabi achani masiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ja'ancuabi huejaye porema'iñë cajën ba'iyë. Yequëcua yua zin cu'eye porema'icua'ru të'ya raisi'cua ba'iyë. Yequëcua yua, bainbi re'huajënna, zin cu'eye porema'icuare'ru re'huasi'cua ba'iyë. Yequëcua yua Riusu yo'ore yo'oza cajën, ja'an ro'ire romi beocua ba'iyë. Ja'an coca cani jo'case'ere achani masiye porecua se'gabi ja'nca huejamajën ba'ija'bë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ja'nrëbi, yequëcuabi bacua zin hua'nare rani, bacuare Jesusni ëñoni cahuë. Më'ë ëntë sarañabi bacuana pa'roni, ujajë'ën cajën, ëñohuë. Ëñojënna, Jesusre concuabi bacuani bëinjën cani ënsehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ënsejënna, Jesusbi cabi: —Zin hua'nabi yë'ëna raija'bë. Bacuare ënseye beoye ba'ijë'ën. Zin hua'na recoyo ro'taye'ru ba'icua, Quë'rë yo'je bainguë'ë yë'ë cacua, ja'ancuabi Riusu ba'i jobo ba'icua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cani ja'nrëbi, baguë ëntë sarañabi zin hua'nana pa'roni, re'oye cani jo'cani, ja'nrëbi saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saiguëna, ja'nrëbi yequë bainguëbi Jesusna ti'an rani, baguëni senni achabi: —Ëjaguë, Riusu ba'i jobona sani, carajeiye beoye huajëreba huajëye yëyë. Baruna ti'anto, ¿ru'ru gue re'o yo'o yo'oye baye'ne yë'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Senni achaguëna, sehuobi: —¿Më'ë queaca ro'taguë, yë'ëni re'oye yo'o cocare senni achaguë'ne? Riusu se'ga re'oguë'bi ba'iji. Baguë ba'i jobona sani, carajeiye beoye huajëreba huajëye yëtoca, baguë coca guanseni jo'case'ere jo'caye beoye yo'oguë ba'ijë'ën, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sehuoguëna, baguë yua: —¿Jaro coca? senni achabi. Senni achaguëna, sehuobi: —Bainre huani senjoma'ijë'ën. Yeconi yahue bama'ijë'ën. Bonsere jiama'ijë'ën. Coquema'iguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Më'ë pë'caguëte, më'ë pë'cagote te'e ruiñe ëñaguë ba'ijë'ën. Më'ë ja'ansi'quë yëye ba'iye'ru, më'ë te'e jubë bainre güina'ru ai yëguë ba'ijë'ën. Ja'an coca guanseni jo'case'ere yo'oguë ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Caguëna, ba bainguëbi cabi: —Ja'an si'aye yë'ë zinrënna achani yo'oguë ba'iyë yë'ë. ¿Guere yuta yë'ëre yo'oye caraguë'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Caguëna, Jesús sehuobi: —Më'ë yua gare re'ojeiye yënica, më'ë bonse si'aye injani bendiejë'ën. Bendieni, ba curi cose'ere curi beo hua'nana ro insijë'ën. Ja'nca insitoca, Riusu bayete ai ta'yejeiye ai coreba coja'guë'ë më'ë. Ja'nca coja'guë sëani, yë'ëre te'e conguë raijë'ën, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sehuoguëna, ba hua'guëbi achani, ai sa'ntiguë, ro recoyo oiguë saji'i, ai ba'iye ai bonse baguëbi ro insini jo'caye yëma'iguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ja'nca saiguëna, Jesús yua baguëre concuani yihuoguë cabi: —Mësacuani ganreba yihuoguë quëayë yë'ë. Bonse ëjacuabi Riusu ba'i jobona ti'añe yëcuareta'an, ai jëjaji. ");
INSERT INTO snnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ja'anre ai yihuoguë quëayë yë'ë. Bonse ëjacuabi Riusu ba'i jobona ti'añe yëcuareta'an, ai jëjaji. Camello hua'guëbi guëna miu gojena cacaye'ru Riusu ba'i jobona ti'añe quë'rë ta'yejeiye ai jëjaji bacuare, yihuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Caguëna, baguëre concuabi ai achajën rëinjën, baguëni senni achahuë: —Ja'nca ba'itoca, ¿jarocuabi Riusu ba'i jobona ti'añe poreye'ne? Riusu bain tëani baja'cuabi gare beoye, ro'tayë yëquëna, senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Senni achaguëna, Jesusbi bacuani ëñani cabi: —Bain hua'na ja'ansi'cuabi ti'añe gare porema'icua'ë. Riusu se'gabi bacuare tëani baye poreji. Si'aye yo'oye poreguë ba'iguë'bi, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Caguëna, Pedrobi sehuobi: —Yëquënabi yua yëquëna bonse si'aye gare jo'cani, më'ëni te'e conjën zi'inhuë. Ja'nca sëani, ¿Yëquëna guere coja'ye'ne? sehuoguë senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Senguëna, Jesús sehuobi: —Mësacuani ganreba quëani achoyë yë'ë. Riusubi si'aye mame re'huani jo'caguëna, yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi yë'ë jëja guëna seihuëna bëaguë, ai ta'yejeiye ba'iguëbi bëani ba'ija'guë'ë. Ja'nrëbi, mësacua'ga, yë'ëni te'e conjën zi'incua sëani, mësacua jëja guëna seihuëan si'a sara samuhuëanna bëani ba'ija'cua'ë. Bëani ba'ija'cuabi si'a Israel bain jubëan si'a sara samubëanre ëñani, bacuani ai jëja guansejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yureca, bainguëbi baguë huë'e, baguë ma'yë sanhuë, baguë yo'je sanhuë, baguë pë'caguë, baguë pë'cago, baguë zin hua'na, baguë ba'i yija, ja'anre yë'ë ba'iye ro'ina gare jo'catoca, baguë yua quë'rë se'e cien viaje'ru ta'yejeiye coni baja'guë'bi. Baguë'ga yua si'arën ba'iguë, gare carajeiye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yequëcua quë'rë ëja bain ba'iye yëcuareta'an, quë'rë yo'je ba'icuare re'huasi'cua ba'ija'cua'ë. Yequëcua quë'rë yo'je bain ba'icuareta'an, quë'rë ëja bainre re'huasi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Riusu bainbi baguë ba'i jobore ba'ijën, ja'nca ba'iyë. Zio ëjaguë cocare achani, ja'anre ye'yejë'ën. Yo'o concuare cu'eni choza caguë, zijeirën sani, bainre tëhuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tëhuoni, “Mësacua si'a umuguse yo'o contoca, te'e denario so'core ro'iyë” caguëna, “Re'oji. Conñu” cajën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Satena, ja'nrëbi rëno ñëse ba'iguëna a las nueve'ru ba'iye së'iguëna, ba ëjaguëbi se'e huë'e jobona sani ëñato, yequëcua yo'o cu'ecuabi ro ëjojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ba'ijënna, ba ëjaguëbi choini cabi: “Mësacua sani yë'ë ëye ziona yo'o conjë'ën. Mësacua yo'o yo'oni tëjijënna, re'oye ro'iyë” cabi. Caguëna, yo'o conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ja'nrëbi, mëñereba së'irën, ja'nrëbi a las tres'ru ba'iye, ja'anrëan'ga se'e huë'e jobona sani, yequëcua yo'o concuare choini, baguë ziona güina'ru saobi ba ëjaguë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ja'nrëbi, a las cinco'ru ba'iye se'e sani ëñato, yequëcua yo'o beo hua'na choima'isi'cua baë'ë. Ba'ijënna, ba ëjaguëbi, “Mësacua ¿guere ro ëjojën nëcaye'ne ënjo'on?” senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Senni achaguëna, “Ëja bainbi yëquënare choimajënna, ro ba'iyë” sehuohuë. Ja'nca sehuojënna, ba ëjaguëbi cabi: “Mësacua'ga yë'ë ziona sani, yë'ë yo'ore conjë'ën” cabi. Caguëna, saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja'nca sani tonni, ja'nrëbi na'i si'aguëna, ba ëjaguëbi baguë curi conni cuiraguëte choini, baguëte cabi: “Yua'ë. Yë'ë yo'o consi'cuare choini, bacuare ro'ini saojë'ën. Quë'rë yo'je raisi'cuare ru'ru ro'ini, quë'rë ru'ru raisi'cuare quë'rë yo'je ro'ini saojë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Caguëna, ja'nrëbi a las cinco choisi'cuabi curi ro'iruna raijënna, te'e denario so'core ga bainguë ba'iye roji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ja'nca ro'iguëna, zijeirën choisi'cuabi ëñani, “Quë'rë ta'yejeiye maire ro'ija'guë'bi” ro'tahuë. Ja'nca ro'tacuareta'an, bacuare'ga, ga bainguë ba'iye te'e denario so'core roji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ro'iguëna, bacuabi coni ëñani, ba ëjaguëni bëinjën ");
INSERT INTO snnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","cahuë: “Quë'rë yo'je raisi'cuabi te'e hora se'ga yo'o yo'ojënna, yëquënare ro'iye'ru te'e so'core roë'ë më'ë. Yëquënabi si'a umuguse yo'o yo'ojën, ai ja'su yajijënna, ai guaja yo'ohuë. Ja'nca sëani, yëquënare ai gu'aye yo'ohuë më'ë” cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cajënna, ba ëjaguëbi sehuobi: “Banhuë. Mësacuani gu'aye yo'omaë'ë yë'ë. Mësacuani yo'o coñe choiguë, te'e denario so'co ro'iye cahuë. Mësacuabi ja'anre masijën, ");
INSERT INTO snnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","mësacua denario so'co ro'ise'ere bani saijë'ën. Yë'ë curi sëani, yë'ë yëse'e'ru ro'iye poreguëbi quë'rë yo'je raisi'cuana mësacuare ro'ise'e'ru te'e roë'ë yë'ë. Ja'nca bacuare re'oye ro'iguëna, ¿mësacua guere gu'aye ro'tajën bëiñe'ne?” cabi ba ëjaguë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yureca ja'an cocare achani, Riusu ba'i jobo ba'iyete ye'yejë'ën. Quë'rë yo'je ti'ansi'cuabi quë'rë jëja ba'icuare re'huasi'cua ba'ija'cua'ë. Quë'rë ru'ru ti'ansi'cuabi quë'rë yo'je ba'icuare'ru re'huasi'cua ba'ija'cua'ë. Riusubi ai jai jubë bainre choiguëta'an, rëño jubë se'gare baguë bainrebare cuencueni re'huaji. ");
INSERT INTO snnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ja'nrëbi, Jesusbi Jerusalén huë'e jobona saiguë, baguëre concua si'a sara samucuare yahue sani, yihuoguë quëabi: ");
INSERT INTO snnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Yureca maibi Jerusalén huë'e jobona saiyë. Sani ti'anjënna, yequëcuabi yë'ëre Bainguë'ru Raosi'quërebare preso zeanni, pairi ëjacua, ira coca ye'yocua, ja'ancuana yë'ëre preso insija'cua'ë. Insijënna, ja'ancuabi yë'ëre gu'aye cajën, yë'ëre huani senjoñe caja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ja'nca cani, judío bain jubë ba'ima'icuana yë'ëre insija'cua'ë. Insijënna, bacuabi yë'ëre jayajën, yë'ëre si'nsejën, yë'ëre huani senjoja'cua'ë. Huani senjoja'cuareta'an, samute umuguseña bani, Riusubi yë'ëre huajëguëte go'ya rai güeseni jo'caja'guë'bi, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ja'nrëbi, Zebedeo mamacua, Santiago, Juan hue'ecua, bacua pë'cago naconi Jesusna ti'an raijënna, pë'cagobi baguëna gugurini rëanni, Më'ëbi yënica, yë'ëre re'oye yo'ocaijë'ën cago senco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sengona, Jesús yua bagoni senni achabi: —Më'ë ¿guere senni achago'ne? senni achabi. Senni achaguëna, bago sehuogo: —Më'ë ta'yejeiye re'otona ti'anni ba'iguë, yë'ë mamacuare re'oye ëñani, te'eguëni më'ë jëja ca'ncona bëa güesejë'ën. Yequëni më'ë ari ca'ncona bëa güesejë'ën, sehuogo senni achago. ");
INSERT INTO snnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Senni achagona, Jesús yua bago mamacuani sehuobi: —Mësacuabi ro huesë ëaye sen'ë. Yequëcuabi yë'ëni ai ja'si yo'oja'cua'ë. ¿Mësacua güina'ru ai ja'siye ai yo'oye poreja'cua'ne? sehuoguë senni achabi. Senni achaguëna, bacuabi: —Ja'nca poreja'cua'ë yëquëna, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sehuojënna, yua bacuani cabi: —Mësacua yua yë'ë ai yo'oye ba'iye'ru ai yo'ojën ba'ija'cuata'an, yë'ë jëja ca'ncona, yë'ë ari ca'ncona bëaye, ja'anre cuencueni caye porema'iñë yë'ë. Yë'ë Taitabi ja'anre cuencueguë, baguë se'gabi ja'anruan bëani ba'ija'cuare cuencueni caja'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Caguëna, baguëre concua yequëcua si'a sara ba'icuabi achani, Santiago, Juan, bacuani bëinjën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ja'nca ëñajënna, Jesusbi si'acuare choini, yihuoguë cabi: —Ro ën yija bain ta'yejeiye ëjacuabi bacua bain, bacua yo'je ëjacua, si'acuani ai jëja guansejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ja'nca ba'icuata'an, mësacuaca yua ja'nca guansema'ija'cua'ë. Mësacua jubë ba'iguëbi ëja bainguë ba'iye yëtoca, më'ë gajecuani conni cuiraguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ru'ru ba'iguë ba'iye yëtoca, më'ë gajecua yo'o conguë'ru ruinguë, bacuare cuirani conguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yë'ë'ga Bainguë'ru Raosi'quërebabi ba'iguë, yë'ëre cuirani concuare cu'eguë raimaë'ë. Yequëcuani conni cuiraza caguë, bain zemosi'cuare etoye ro'taguë, junni tonguë raisi'quë'ë yë'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ja'nca cani tonni, Jericó huë'e jobobi saiguëna, ai jai jubë bainbi baguëni conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Saijënna, yureca ñaco ëñama'icua samucuabi ma'a yëruhuate ñuë'ë. Ñu'icuabi Jesús raiyete achani, ai jëja güijën cahuë: —¡Ëjaguë, mai ira taita David mamaquëbi ba'iyë më'ë! ¡Yëquënani oire bani conjë'ën! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Cajënna, bain hua'nabi bacuani bëinjën, Güima'ijë'ën, bacuani cahuë. Ja'nca cayeta'an, bacua yua quë'rë jëja güijën cahuë: —¡Ëjaguë, mai ira taita David mamaquëbi ba'iyë më'ë! ¡Yëquënani oire bani conjë'ën! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Güijën cajënna, Jesusbi nëcajani, bacuare choini, bacuani senni achabi: —Mësacua ¿guere yë'ëre señe'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Senni achaguëna, bacuabi sehuojën sen'ë: —Ëjaguë, yëquënare ñaco re'huacaijë'ën, sehuojën sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ja'nca senni achajënna, Jesusbi bacuani ai oire bani, bacua ñacore pa'robi. Pa'roguëna, bacuabi te'e jëana ñaco ëñani, baguë naconi te'e conni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ja'nrëbi, Jesús yua Jerusalén huë'e jobona ti'an bi'rani, Betfagé huë'e jo'borë cueñe ba'ijën, Olivo cubë ca'ncorë ba'ijën, Jesusbi baguëre concua samucuare choini, ");
INSERT INTO snnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","bacuani coca cabi: —Mësacua que huë'e jo'borëna saijë'ën. Burra hua'go, bago zin hua'guë naconi gueonni rëonsi'cuare tinjañë. Tinjani, ba hua'nare jo'chini, yë'ëna rajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yequëcuabi mësacuani ënseto ñaca yë'ë case'e'ru sehuojë'ën: Mai Ëjaguëbi bacuare yëji. Jë'te bacuare go'yaji, cajën sehuojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yureca ja'an cocare caguëna, Riusu ira bainguë raosi'quë quëani jo'case'ere ro'tajë'ën. Riusubi baguë cani jo'case'e'ru güina'ru ba'ija'guë caguëna, yureca Jesusbi baguëre concuani burrote inja'ñe guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Riusu ira bainguë raosi'quëbi ru'ru ñaca quëani jo'cabi: Yureca, Jerusalén huë'e jobo bain ba'ija'cuani quëani achojë'ën: Mësacua quë'rë ta'yejeiye ëjaguëbi ti'an raiguëna, baguëte ëñajë'ën. Ëja bain re'oye ëñoñe'ru re'oye ëñoñe beoye ba'iguëbi burrote tuiguë raiji, quëani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ja'nrëbi, Jesusre concuabi baguë guanseni case'ere achani, güina'ru yo'ojën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sani, ba burra hua'go, bago mamaquë naconi, ba hua'nare injani rani, bacua cañate ba hua'nana tëojënna, Jesusbi tuabi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tuani saiguëna, ai jai jubë bainbi bacua cañate baguë sai ma'ana uanjënna, yequëcuabi ju'cahuëanre tëyoni, ma'ana baguë sairuna uanhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ai jai jubë bainbi ja'anrëna saijën, yo'jena saijën, ai bojora bojojën güihuë: —¡Hosana! ¡Ai bojoreba bojoñuni! ¡Mai ira taita ba'isi'quë David mamaquëbi raiguëna, bojojën bañuni! ¡Mai Ta'yejeiyereba Ëjaguë Riusubi raoguëna, mai Ëjaguëni ai bojoreba bojojën bañuni! ¡Hosana! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ja'nrëbi, Jesús yua Jerusalén huë'e jobona ti'anguëna, si'a bain hua'na baru ba'icuabi huë'huë ganojën, gue ro'taye beoye ëñajën, —¿Gueguëguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Senni achajënna, baguë naconi raicuabi sehuohuë: —Riusu bainguë raosi'quë'bi ba'iji. Nazaret huë'e jobo, Galilea ba'i jobobi raisi'quë'bi ba'iji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja'nrëbi, Jesús yua Riusu uja huë'ena ti'anni cacabi. Cacani, bonse insicua, bonse cocua ba'ijënna, bacuare etoni saobi. Curi sa'ñecua ba'ijënna, bacua mesañare bonani taonbi. Ju'ncubo insicua ba'ijënna, bacua ñu'i seihuëanre bonani taonbi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ja'nca yo'oni, bacuani bëinguë cabi: —Riusu ira coca toyani jo'case'ere ëñato, ñaca caji: “Yë'ë huë'e yua si'a re'oto bain uja huë'e case'e'ë.” Ja'nca toyani jo'case'eta'an, mësacuabi ro jiancua gati huë'ere yë'ë huë'ere re'huahuë, bëinguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Caguëna, ja'nrëbi ñaco beocua, yequëcua ca'jacua, bacuabi Riusu uja huë'ena cacani Jesusna ti'anjënna, bacuare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ja'nca huachoguëbi ai ta'yejeiye yo'oni ëñoguëna, pairi ëjacua, a coca ye'yocua, bacuabi ëñani, ai bën'ë. Zin hua'na'ga Riusu uja huë'ere ba'ijën, “Mai ira taita David mamaquëbi raiguëna, ai bojoreba bojojën bañuni” cajën ba'ijënna, bacuabi ai bëinjën, ");
INSERT INTO snnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesusni senni achahuë: —¿Ba zin hua'na coca cajënna, më'ë guere yo'oguë ënsema'iguë'ne? senni achahuë. Senni achajënna, Jesús sehuobi: —Bacuare ënsema'iñë. ¿Mësacua yua Riusu coca toyani jo'case'ere ëñato, ën cocare ëñamate? Zin hua'na, chuchu hua'na yuta ba'icuareta'an, Riusuni re'o coca bojojën ca güesehuë më'ë, toyani jo'case'e ba'iji, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ja'nca sehuoni, bacuare jo'cani, jai huë'e jobobi sani, Betania casi jo'borëna ti'anni, baruna canji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Canni ñatani, jai huë'e jobona go'iguëna, ai aon gu'abi baguëre. ");
INSERT INTO snnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aon gu'aguëna, higo uncuere tëani uncueza caguë, bañëna ti'anni ëñato, higo uncue gare beobi. Ja'o se'ga baji'i. Ja'nca ba'iguëna, Jesús yua bañëna bënni senjoñe cani jo'caguë: —¡Gare se'e higo uncuere quëiñe beoye ba'ijë'ën, cani jo'cabi. Cani jo'caguëna, ba higo sunquiñëbi te'e jëana cueneni si'abi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cueneni si'aguëna, Jesusre concuabi ai ëñajën rëinjën, baguëni senni achahuë: —¿Bañë queaca yo'oguë cueneni si'aguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Senni achajënna, Jesús sehuobi: —Mësacuani ganreba yihuoguë quëayë yë'ë. Mësacua yua huaji yëye beoye ba'ijën, Riusu ta'yejeiye yo'oye poreyete si'a recoyo ro'tajën ba'ijë'ën. Ja'nca recoyo ro'tajën ba'itoca, yë'ë yua higoñëna yure yo'ose'e'ru quë'rë ta'yejeiye yo'oye poreja'cua'ë mësacua. Que cubëre'ga ta'yejeiye yo'oye poreja'cua'ë. Ën cocare cajën, “Ënjo'onbi gare quëñëni, ja'anse'ebi jai ziayana runi huesëjë'ën” ja'anre guansejënna, Riusubi ba cubëte ja'nca quëñoni rëoni huesoji. ");
INSERT INTO snnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mësacuabi Riusuni coca senni achajënna, Riusubi si'aye gare ënseye beoye mësacuana insiji, baguëni si'a recoyo ro'tajën ba'itoca, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cani, ja'nrëbi Riusu uja huë'ena cacani, bainni ye'yo bi'rabi. Ye'yo bi'raguëna, pairi ëjacua, judío bain iracua, bacuabi ti'an rani, baguëni senni achahuë: —¿Më'ë queaca ro'taguë, ënjo'ona rani ëjaguë yo'oye'ru yo'oguë'ne? ¿Nebi më'ëre guanseni raore'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Senni achajënna, Jesús sehuobi: —Yë'ë'ga yua mësacuani coca senni achayë. Senni achaguëna, mësacua yua te'e ruiñe sehuojë'ën. Ja'nca sehuotoca, ja'nrëbi, yë'ë ëjaguë ba'iyete mësacuani quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nebi Juanni bain bautizaye guanseni raore'ne? ¿Riusu raosi'quë o ën yija bain raosi'quë baquë baguë? senni achabi. Senni achaguëna, bacuabi sa'ñeña yahue ca bi'rahuë: —Baguë senni achase'ere sehuoye ai jëjaji maire. Riusu raosi'quë baji'i sehuotoca, Jesusbi maini: “¿Mësacua queaca ro'tajën, baguëni recoyo ro'tamate'ne?” cama'iguë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ja'nca ba'iguëna, “Bain raosi'quë baji'i” caye güeyë mai. Si'a bainbi Juan ba'ise'ere te'e ruiñe ro'tajën, Riusu bainguë raosi'quë baji'i ro'tajën ba'icua sëani, tin caye huaji yëyë mai, sa'ñeña cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ja'nca cani, ja'nrëbi, Jesusni sehuohuë: —Juan raose'ere huesëyë yëquëna, sehuohuë. Ja'nca sehuojënna, Jesusbi bacuani cabi: —Mësacua ja'nca sehuotoca, yë'ë ëjaguë ba'iyete, yë'ë raose'ere mësacuani gare quëaye beoye ba'iyë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Cani ja'nrëbi, yeque coca bacuani yihuoguë cabi: —Ën cocare achani ro'tani ye'yejë'ën. Yequë bainguëbi samu mamacuani babi. Ma'yë ba'iguëna sani, “Mami, yure umuguse më'ë sani, ziona yo'o yo'oguë ba'ijë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Caguëna, “Bañë. Yëma'iñë” sehuobi. Ja'nca sehuoguëbi jë'te “Gu'aye sehuohuë yë'ë” se'e go'iye ro'tani, ziona sani yo'o yo'obi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ja'nrëbi, baguë taitabi yequë mamaquë, ba yo'jeguë ba'iguëna sani, güina'ru cabi. Caguëna, baguë yua “Jaë'ë. Saiyë, Taita” sehuobi. Ja'nca sehuoguëbi yo'o yo'oguë saimaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ja'nca ba'iguëna, mësacua ro'tani quëajë'ën. ¿Jaroguëbi baguë taita case'ere'ru yo'oguë'ne? ¿Ru'ru ba'iguë o yo'je ba'iguë re'oye yo'oguë'ne? senni achabi Jesús. Senni achaguëna: —Ru'ru ba'iguëbi re'oye yo'obi, sehuohuë. Sehuojënna, Jesús yua bacuani bëinguë cabi: —Mësacuani ganreba caguë quëayë yë'ë. Impuesto curi cocua, gu'a romi hua'na, gu'areba gu'ana ba'icuabi mësacua'ru quë'rë re'o bain'ë. Riusu ba'i jobona ti'anjënna, mësacuaca bañë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan bautizaguëbi yua mësacuana ti'an rani, re'o bainguë'ru ëñoguëna, baguë quëani achose'ere gare ro'tamaë'ë mësacua. Ja'nca ro'tama'icuata'an, impuesto curi cocua, gu'a romi hua'na, bacuabi achani, si'a recoyo ro'tahuë. Ro'tajënna, mësacuabi ëñani, mësacua gu'a juchare senjoñe beoye gare baë'ë. Juan coca case'ere gare ro'taye beoye baë'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yureca yeque cocare achani ro'tani ye'yejë'ën. Yequë bainguëbi bisi ëye ziore tanbi. Tanni, tu'ahuëte baguë zio të'ijeiye yo'oni, ëye tumu ro'rohuëte gatabëna te'ntoni, ja'nrëbi ëmë huë'ere nëcobi, ba zio ëñañete. Ja'nca yo'oni tëjini, zio cuiracaicuare choini, baguë ziore bacuana jo'cani, yequë yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sani, ja'nrëbi, ëye tëarën ti'anguëna, zio ëjaguëbi baguëre yo'o concuare choini, ëye tëase'ere injaijë'ën caguë, baguë zio cuiracuana saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Saoguëna, ja'nrëbi ti'anjënna, ba zio cuiracuabi te'e yo'o conguëte zeanni huani, ja'nrëbi yequëni huani senjoni, yequëni gatabi senjojën huani senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ja'nca yo'ojënna, ba ëjaguëbi se'e yequëcua quë'rë jai jubë yo'o concuare saobi. Saoguëna, ba zio cuiracuabi bacuani güina'ru gu'aye yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yo'ojënna, ja'nrëbi yo'je, ba ëjaguëbi baguë zinre choiguë, “Yë'ë zinre saotoca, baguëni te'e ruiñe ëñañë bacua” ro'taguë, baguë zinre saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Saoguëna, zio cuiracuabi baguëte ëñani, sa'ñeña coca cahuë: “Ëñajë'ën. Mai ëjaguë zinbi rai'te. Baguë taita bayete coni baja'guëre sëani, raijë'ën. Baguëni huani senjoñu. Ja'nca yo'otoca, baguë yija baja'yete coni bayë mai” sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ja'nca cani, baguëte zeanni, baguëte huani senjoni, baguë ga'nihuëte zio hue'se ca'ncona jo'cani senjohuë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cani ja'nrëbi, ba bain achacuani senni achabi: —Ja'nca huani senjojënna, ba zio ëjaguëbi rani, ¿ba cuiracuani guere yo'oja'guë'ne? senni achabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Senni achaguëna, bacuabi sehuohuë: —Ba zio cuiracuani ai jëja si'nseni, bacuani huani senjoni, ja'nrëbi yequëcua, ba zio tëaja'yete re'oye insicua, ja'ancuana cuiraye jo'caja'guë'bi, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sehuojënna, Jesús yua bacuani cabi: —Mësacua yua Riusu coca toyani jo'case'ere ëñajën, ¿ën cocare ro'tamate'ne? Ñaca caji: Riusubi baguë gatabëte jo'caguëna, ro ën yija bain yo'o concua huë'e yo'ocuabi ba gatabëte ëñani, gu'aji cajën, babëre senjohuë. Senjocuata'an, ba gatabëbi yua quë'rë ze'en gatabë'ru re'huase'e baji'i. Mai Ëjaguë Riusubi ja'nca re'huaguëna, maibi ai ëñajën rëinjën ba'iyë, caji Riusu coca. ");
INSERT INTO snnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ja'nca case'e sëani, mësacuani ñaca quëareba quëayë. Riusu yua baguë ba'i jobore mësacuana jo'casi'quëbi yurera mësacuare quëñoni senjoni, yequë bain re'oye cuirani conja'cua, ja'ancuana jo'caja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Riusu gatabë jo'case'ere cato, bainguëbi ja'an gatabëna gurutoca, hua'huani si'asi'quë'ru ruinji. Ja'an gatabëbi bainguëna to'intoca, ya'obë'ru ruinji. Bainbi yë'ëre senjotoca, gurujani huesëyë. Si'nseni senjosi'cua'ru ruiñë, bacuana bëiñe cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Caguëna, pairi ëjacua, fariseo bain, bacuabi Jesús coca yihuose'ere achani, “Maire gu'aye cani jo'cabi baguë” cajën, ");
INSERT INTO snnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","baguëni preso zeanja'ma cajën ëñahuë. Bain hua'na si'a jubëbi Jesusre re'oye ëñajën, “Riusu bainguë raosi'quë'bi ba'iji” cajën baë'ë. Ja'nca ba'ijënna, bainre huaji yëjën, baguëte preso zeanmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ja'nrëbi se'e, Jesusbi bainre yihuoguë, bacuani coca cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Riusu ba'i jobo ba'iyete masiye yëtoca, hueja fiesta yo'ose'ere achani ye'yejë'ën. Bain ta'yejeiye ëjaguëbi baguë zin huejaja'yete ro'tani, ai re'o aon fiestate yo'ocaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Baguëre yo'o concuare choini, bain choisi'cua raiye quëajaijë'ën caguë saobi. Saoguëna, ba bain choisi'cuabi raima'iñë cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Cajënna, se'e yequë yo'o concuani cabi: “Ba bain choisi'cuana sani quëajë'ën. Yureca aon fiestate re'huahuë. Huaca hua'na, toro zin hua'na jujusi hua'na, ja'an hua'nare huani, si'a aonre re'huani, mësacua raiyete ëjoyë yë'ë. Ja'anre bacuani quëajë'ën” cani saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Saoguëna, yo'o concuabi quëajatena, ba choisi'cuabi ro güeye cani, yequëruanna saë'ë. Yequëbi baguë ziona saji'i. Yequëbi baguë bonse insiruna saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yequëcuaca ba ëjaguëre yo'o concua raosi'cuare ro zeanni, ro gu'aye yo'oni, bacuani huani senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja'nca yo'ojënna, bain ta'yejeiye ëjaguëbi ai bëinreba bënji'i. Ja'nca bëinguëbi baguë soldado jubëte bacuani huaye saobi. Saoguëna, bain huani senjosi'cuare sëani, bacuani huani senjoni, bacua huë'e jobore ëoni senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ja'nca yo'ojënna, ba ëjaguëbi se'e baguëre yo'o concuani cabi: “Yua hueja fiesta yo'oyete gare re'huahuë yë'ë. Re'huaguëna, choisi'cuabi gu'aye sehuojënna, bacuani gare ruiñe ëñama'iñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ja'nca sëani, mësacua yua huë'e jobo ma'añana sani, si'a bainre cu'ejani, fiestana raiye choijë'ën” cani, bacuare saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Saoguëna, baguëre yo'o concuabi sani, bacua bain tinjasi'cuare choë'ë. Re'o bain, gu'a bain, si'acuare choijënna, bacuabi rani, ba ëjaguë fiesta huë'e bu'iye tëca ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ti'anjënna, ëjaguëbi cacani ëñato, te'eguëbi yua hueja fiesta can beoguëna, ");
INSERT INTO snnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ëjaguëbi baguëni bëinguë cabi: “¿Më'ë queaca ro'taguë, hueja fiesta canre coma'iguëbi raquë'ne?” caguëna, gare sehuoye beoye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ja'nca ba'iguëna, ba ëjaguëbi baguë bain concuani cabi: “Baguëni zeanni, baguë guëoñare baguë ëntë sarañare huenni, baguëte quëñoni, hue'se re'oto, zijei re'otona senjojë'ën. Ja'anru yua bain ai yo'ojën ba'iru'ë. Bacuabi ai oijën, bacua zemeñoare cuncujën ba'iyë cabi baguë” yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ja'nca yihuoni, ba achacuani se'e cabi: Riusubi ai jai jubë bainre choiguëta'an, rëño jubë se'gare baguë bainrebare cuencueni re'huaji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ja'nca caguëna, fariseo bainbi bacua gajecuana sani, bacua naconi coca cahuë: “Jesusbi huacha sehuoja'guë cajën, baguëni coquejën senni achañu” cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Cani ja'nrëbi, bacua bain concua Herodes gu'a gajecua naconi, bacuare Jesusna saohuë. Saojënna, bacua yua Jesusna ti'anni, baguëni coca senni achahuë: —Ëjaguë, yëquënabi më'ë coca masiye ye'yose'ere achani, te'e ruiñereba'ë ro'tajën ba'iyë. Ro ën yija bain ye'yojën ba'iyete achama'iguë, te'e ruiñe ye'yoguë'ë më'ë. Ëja bain achacua ba'itoca, më'ëbi gare huaji yëye beoye te'e ruiñe ba'i coca se'gare ye'yoguë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ja'nca sëani, më'ëni coca senni achajën raë'ë yëquëna. Bain ta'yejeiye ëjaguëbi impuesto curi ro'iye senni achaguëna, ¿maibi baguëni ro'iye baye? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Senni achajënna, Jesús yua bacua ro coque ëaye case'ere masibi. Ja'nca masini, bacuani sehuoguë cabi: —¿Mësacua gu'aye ro'tajën, guere yë'ëni ro coquejën, yë'ëni ro zemo cocare senni achaye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Impuesto curi so'core injaijë'ën. Ëñaza, cabi. Caguëna, denario so'cohuate injani rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rani ëñojënna, bacuani senni achabi: —¿Jaro bainguë ziabi curi so'cohuate së'iguë'ne? ¿Gue mami hue'eguëbi së'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Senni achaguëna: —Bain ta'yejeiye ëjaguë'bi së'iji, sehuohuë. Sehuojënna, baguë cabi: —Bain ta'yejeiye ëjaguë ba ma'carëan ba'itoca, bain ta'yejeiye ëjaguëna go'yani insijën ba'ijë'ën. Riusu ba ma'carëan ba'itoca, Riusuna go'yani insijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Caguëna, bacuabi ai achajën rëinjën quëquësi'cuabi ro jo'cani saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ja'nrëbi, yequëcua, saduceo bain hue'ecuabi Jesusna ëñajën saë'ë. Ja'ancua yua, Bain ju'insi'cua yua go'ya raima'icua ba'iyë, ja'anre cajën ye'yojën ba'iyë. Ja'nca ba'icuabi Jesusna sani, baguëni coca senni achajën, ");
INSERT INTO snnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","baguëni cahuë: —Ëjaguë, Moisés coca cani jo'case'ere më'ëni senni achajën raë'ë. Maina ñaca toyani jo'cabi baguë: Bainguëbi zin beoguë banica, ja'anguëbi junni huesëtoca, baguë yo'jeguëbi baguë rënjo jo'casi'core huejaye baji. Bagote huejani, baguë ma'yëre zinre cu'ecaiye baji baguë, toyani jo'cabi Moisés. ");
INSERT INTO snnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ja'nca toyani jo'caguëna, yureca yequëcuabi yëquëna jubëte baë'ë. Ma'yëreba ba'iguëbi baguë yo'jecua, te'e ëntë sara te'ecua naconi baë'ë. Ma'yëreba ba'iguëbi baguë rënjoni huejani, zin beoguëbi junni huesëni, baguë rënjore ba yo'jeguëna jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jo'caguëna, ba samu ba'iguëbi ba hua'jegoni huejani, güina'ru junni huesëbi. Ja'nrëbi samute ba'iguë, te'e ëntë sara samu ba'iguë tëca, si'acuabi bagoni huejani, güina'ru zin beocua junni huesëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Junni huesëjënna, ja'nrëbi yo'je, ba hua'jego'ga junni huesëgo. ");
INSERT INTO snnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ja'nca junni huesësi'cuabi se'e go'ya raitoca, ¿bago yua jaroguë rënjo ba'ija'go'cone? Si'acua te'e ëntë sara samucua bagoni basi'cua sëani, ¿më'ë guere quëaguë'ne? baguëni senni achani, baguë huacha sehuoye ëjojën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ëjojën nëcajënna, Jesusbi bacuani sehuoguë cabi: —Mësacua yua ai huacha ro'tajën ba'icua'ë. Riusu cocareba toyani jo'case'ere gare huesëjën ba'icua'ë. Riusu ta'yejeiye yo'o yo'oye poreyete gare huesëjën ba'icua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bain junni huesësi'cuabi go'ya raijën, sa'ñeña gare huejama'icua ba'iyë. Riusu anje sanhuë guënamë re'otore ba'icua'ru ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yeque cocare'ga mësacuani yihuoye bayë yë'ë. Mësacua yua Moisés toyani jo'casi pëbëte anconi, toa zëinsi sahua quë'rona ëñani, bain ju'insi'cua go'ya raiyete ye'yejë'ën. Riusubi yua Moisesni ñaca quëaguë ba'nji: ");
INSERT INTO snnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraham yua yë'ëni Taita Riusu caji. Isaacbi yë'ëni Taita Riusu caji. Jacobi yë'ëni Taita Riusu caji” Riusubi quëaguë ba'nji. Ja'nca quëasi'quë sëani, mai Ëjaguë Riusubi bain junni huesësi'cua, bacua Riusu beoguë'bi ba'iji. Bain huajëcua, bacua Riusu se'ga ba'iguë'bi, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja'nca sehuoguëna, bain hua'nabi achani, baguë coca yihuoguë ye'yose'ere ai achajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús yua saduceo bainni ja'nca sehuoguëna, gare caye beoye baë'ë. Ja'nca ba'ijënna, fariseo bainbi ja'anre achani, bacuabi ñë'cani baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba'ijënna, bacua jubë ba'iguë, ira coca ai re'oye ye'yesi'quëbi Jesús sehuoja'yete masiza caguë, Jesusna sani coca senni achabi: ");
INSERT INTO snnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ëjaguë, Riusu coca guanseni jo'case'ere cato, ¿Gue cocabi quë'rë ta'yejeiye ba'i coca ba'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Senni achaguëna, Jesús sehuobi: —“Më'ë Ëjaguë Riusuni ai yëreba yëguë ba'ijë'ën. Më'ë recoyo, më'ë yacahuë, më'ë ro'taye, ja'anbi më'ë porese'e'ru si'a jëja baguëni ai yëreba yëguë ba'ijë'ën.” ");
INSERT INTO snnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja'an coca yua quë'rë ta'yejeiye ba'i coca'ë cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yeque coca ai ta'yejeiye ba'i cocare'ga maina guanseni jo'case'e ba'iji. Ñaca caji: “Më'ë te'e bainni ai yëreba yëguë ba'ijë'ën. Më'ë ja'ansi'quë yëguë ba'iye'ru më'ë te'e bainni ai yëreba yëguë ba'ijë'ën” guanseni jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ja'an coca, samu guanseni jo'casi coca yua Riusu coca quë'rë ta'yejeiye ba'i coca ba'iji. Moisés coca toyani jo'case'e, Riusu ira bain raosi'cua toyani jo'case'e, si'ayete ëñani masito, ja'an samu coca yure quëase'ebi quë'rë te'e ruiñe ye'yoni ëñosi coca ba'iji, sehuoguë cabi Jesús ");
INSERT INTO snnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ja'nrëbi, fariseo bainbi barure ñë'casi'cua ba'ijënna, Jesusbi bacuani ");
INSERT INTO snnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","coca senni achabi: —Mësacua yua ba Cristo Raosi'quëreba ba'iyete ro'tato, ¿ja'an hua'guë, jaroguë zinguë'ne? Quëajë'ën yë'ëre, caguë, senni achabi. Senni achaguëna: —Mai ira taita ba'isi'quë David, ja'anguë zin ba'iji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sehuojënna, Jesusbi bacuani senni achabi: —Ja'nca sehuoto, ëñere ro'tani sehuojë'ën. Riusu Espíritubi Davidni ro'ta güeseguëna, Davidbi ñaca cani jo'cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Riusubi yë'ë Ëjaguëni cabi: “Yë'ë jëja ca'ncona bëani, më'ë je'o carajei ñësebë tëca ba'ijë'ën” cani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja'nca cani jo'caguë, Cristo raosi'quëre David zin caye poremaji'i, baguëte Ëjaguë casi'quë sëani, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ja'nca sehuoguëna, si'acuabi ro caye beoye ba'ijën baë'ë. Ja'an umugusebi baguëni se'e coca senni achaye huaji yëjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ja'nrëbi Jesús yua bain jubë, baguëre concua, bacuani coca yihuoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ira coca ye'yocua, fariseo bain, bacua yua Moisés coca toyani jo'case'ere ëñajën, bainni ye'yojën quëacua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja'nca ba'ijënna, bacua quëaye si'aye achani re'oye ro'tajën, te'e ruiñe yo'ojën ba'ijë'ën. Bacua yo'ojën ba'iyete cato, ja'anre güina'ru yo'oye beoye ba'ijë'ën. Bacuabi ai coca yihuojën quëacuata'an, bacua quëaye'ru te'e ruiñe yo'oma'icua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bain hua'nani coca guansejën, Te'e ruiñe yo'ojën ba'ijë'ën cajënna, ai jëja yo'ojën guajayë. Ja'nca guajajënna, bacuaca gare coñe beoye ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bacua yo'oyete cato, bainbi ëñani maire re'oye ro'tajën ba'ija'bë cajën, ja'anre ro'tajën, bacua yo'o ma'carëanre yo'ojën ba'iyë bacua. Riusu coca toyani bacua canna së'quese'ere ai ba'iye ju'ijën ëñoñu cajën, quë'rë zoa ma'carëan can yëruhuabi re'oye reojën ëñoñu cajën, ja'anre yo'ojën ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aon fiestana saito, quë'rë ëja bain ba'iruna bëani ba'ijën bojoñu cayë. Riusu coca ye'ye huë'ena saito, quë'rë re'oruanna bëani ba'ijën bojoñu cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Huë'e joborebana saito, bain saludayete ai bojojën ëjoyë. Bainbi bacuare saludato, Ta'yejeiye ëjaguë catoca, ai bojoyë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ja'nca ba'icuata'an, mësacua yua ja'an saludayete cu'eye beoye ba'ijë'ën. Mësacua yua te'e ëjaguë se'gare achaye bayë. Mësacua si'acua yua te'e bain ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mësacuabi ën yija bainre saludatoca, Taitareba gare caye beoye ba'ijë'ën. Taita Riusu yua guënamë re'otore ba'iguëna, ja'anguë se'gani Taitareba saludajën cajën ba'ijë'ën, gañaguëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bainbi mësacuani ëjaguë caye, ja'anre cu'eye beoye ba'ijë'ën. Cristo se'gabi mësacua ëjaguë'bi ba'iji, gañaguëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mësacua jubë ba'iguëbi quë'rë ëja bainguë ba'itoca, më'ë gajecuani conni cuiraguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Quë'rë ëja bainguë'ru re'huasi'quë baza catoca, quë'rë yo'je bainguë'ru re'huasi'quë ba'ija'guë'bi. Quë'rë yo'je bainguë'ru, ro yo'o con hua'guë'ru re'huasi'quë baza catoca, ëja bainguë'ru re'huasi'quë ba'ija'guë'bi, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ja'nca cani, ja'nrëbi fariseo bain, ira coca ye'yesi'cua, bacuare ai bëinguë cani jo'cabi: —Mësacua ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. Riusu ba'i jobona ti'añe yëcuani ënsejënna, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. Mësacua baruna ti'anma'icuabi ba ti'añe yëcuare ënseyë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mësacua ira coca ye'yocua, fariseo bain, re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. Romi hua'je hua'na huë'eñare tëani, bacuare senjoni ja'nrëbi, Re'o bain ba'iye ëñoñu cajën, uja coca ro zoe senreba sencua sëani, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. Mësacua yua quë'rë ta'yejeiye bënni senjosi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mësacua ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. So'o bainguëte cu'eni Riusu bainguëre baguëte re'huaza cajën, si'a ën yija re'otona ro ganijën ba'ijën, baguëte cu'eni tinjani, mësacua cocare ye'yoni tëjijënna, baguë yua mësacua'ru quë'rë gu'a bainguë re'huasi'quëbi ba'iji. Mësacua naconi Riusu toana te'e saiji. Ja'nca yo'ocuare sëani, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. ");
INSERT INTO snnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mësacua yua Riusu ma'a ëñocua ba'iyë yëquëna cajën, ro ñaco beocua'ru ba'ijën, Riusu ma'a ëñoñe huesëcua'ë. Ja'nca sëani, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. Ën cocare ro huesë ëaye cajën ba'iyë mësacua: “Bainbi Riusu uja huë'ere ro'tajën, ganreba coca cuencueni catoca, bacua ganreba coca cuencueni case'e'ru yo'oye jo'caye poreyë. Ja'nca porecuabi Riusu uja huë'e zoa curire ro'tajën, ganreba coca cuencueni catoca, bacua cuencueni case'e'ru yo'oye bayë” cajën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ja'nca cacuabi ro ro'tajën, ñaco beocua'ru ba'ijën, gu'aye yo'ojën ba'iyë. Ba zoa curire ro'tajën, ganreba coca cuencueni catoca, gare huacha yo'ojën ba'iyë. Riusu uja huë'ere quë'rë ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ja'nrëbi yeque coca mësacuabi ro ro'tajën guansejën ba'iyë: “Bainbi misabëte ro'tajën, ganreba coca cuencueni catoca, bacua cuencueni case'e'ru yo'oye jo'caye poreyë. Ja'nca porecuabi Riusuna insise'e, misabëna jo'case'e, ja'anre ro'tajën ganreba coca cuencueni catoca, bacua cuencueni case'e'ru yo'oye bayë” cajën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ja'nca cacuabi ro ro'tajën ñaco beocua'ru ba'ijën, ro huesë hua'na'ru ba'iyë. Riusuna insisi ma'carëte ro'tajën, ganreba coca cuencueni catoca, gare huacha yo'ojën ba'iyë. Riusu huë'e misabëte quë'rë ro'tajën ba'ijë'ën. Ba insisi ma'carëte misabëna tëoguëna, re'o maca'ë caji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ja'nca ba'iguëna, misabëte ro'tajën, ganreba coca cuencueni catoca, babëna tëose'ere'ga ro'tajën, ganreba coca cuencueni cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Riusu uja huë'ere ro'tajën, ganreba coca cuencueni catoca, Riusu yua ba huë'ere ba'iguë, ja'anguëre'ga ganreba coca cuencueni cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Guënamë re'otore ro'tajën, ganreba coca cuencueni catoca, Riusu jëja guëna seihuëre'ga ro'tajën ganreba coca cuencueni cayë. Riusure'ga ro'tajën, ganreba coca cuencueni cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mësacua, ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. Menta, anís, comino, ja'an re'o sën ja'ore ro'tajën, décima parte ba'iyete quëñoni, ja'anre Riusuna insijën ba'icua'ë. Ja'nca insijën ba'icuata'an, Riusu jëja coca guanseni jo'case'ere ro ro'tajën, ro yo'omajën ba'iyë mësacua. Re'oye yo'oye, bainni oire bani coñe, Riusuni si'a recoyo ro'taye, ja'anre guanseni jo'case'e ba'iguëna, quë'rë jëja ro'tajën yo'ojën ba'ijë'ën mësacua. Ja'nca ro'tamajënna, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. Re'o sën ja'ore Riusuna insijënna, re'oye yo'ohuë. Ja'anre yo'ojën, Riusu jëja coca guanseni jo'case'ere'ga ru'ru quë'rë ta'yejeiye yo'ojën ba'ire'ahuë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ja'nca yo'oma'isi'cuabi Riusu ma'are bainni ëñocua ba'iyë yëquëna cajën, ro coquejën, ñaco ëñama'icua'ru ba'iyë mësacua! Mësacua aonre ainjën, taya hui'yare ëñani, rutani senjoñë. Ja'nca senjocuabi camello hua'guë jaiguëte ëñamajën, ja'anguëte ro ro'tajën rëoñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mësacua ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. Tasa ro'rohuë, guëna re'ahuë, ja'anre zoajën, guërëbë ca'nco se'gare zoajën ba'iyë mësacua. Yacahuëte zoaye beoye ba'iyë. Güina'ru, mësacua yua re'oye abujën, re'o bain'ru ëñojën, ro coqueyë. Mësacua recoyo ro'tayete cato, ai gu'aye yo'ocua ba'iyë. Ro coquejën jianjën, yequëcua bayete ro coquejën tëani bayë mësacua. Ja'nca ba'icuani ai bënni senjoñe cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mësacua fariseo bain, ro ñaco ëñama'icua'ru huacha yo'ojën, ru'ru guëna re'ahua yacahuëre zoajë'ën. Mësacua recoyo ro'taye, si'aye mame re'huani ba'ijë'ën. Ja'nca ba'itoca, re'o bainreba ruinjën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mësacua, ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë. Mësacua yua bain tansiruan, pojei re'cobi re'oye tënosiruan, ja'anruan'ru ba'iyë mësacua. Ëmëje'en ba'i ca'ncona ëñato, ai re'o hua'na'ru ëñoñë mësacua. Ja'nca ëñocuata'an, ju'insi'cua gu'an tansiruan sa'nahuë ba'iye ja'anra'ru ai gu'a recoñoa bayë mësacua. Si'si recoyo ro'tajën ba'icua'ë mësacua. Ja'nca ba'icuare sëani, ai bënni senjoñe cani jo'case'e ba'iji mësacuare. ");
INSERT INTO snnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bain hua'nabi mësacuani ëñato, re'o hua'na'ru ëñojën ba'iyë mësacua. Ja'nca ëñocuata'an, ro coquejën ëñoñë. Gu'a hua'na se'ga ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mësacua ira coca ye'yocua, fariseo bain, Re'o bain ba'iyë yëquëna cajën, ro coquejën ba'iyë mësacua. Riusu ira bain raosi'cua, si'a re'o bain, junni huesësi'cuare ro'tajën, mësacua yua bacua tansiruanre re'oye re'huani ai re'o gatare nëconi jo'cajën, ");
INSERT INTO snnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ñaca cayë: “Yëquënabi ba ira bain ba'isi'cua naconi ba'ijën ba'itoca, bacua naconi Riusu bainni te'e huani senjoma'ire'ahuë, gu'aye yo'ose'e sëani” cayë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ja'nca cacua sëani, mësacua gu'aye yo'oyete ëñojën ba'iyë. Mësacua ira bain ba'isi'cuabi Riusu bainni huani senjojënna, mësacua yua bacua mamacua sëani, güina'ru yo'ocua ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yureca, mësacua ira bain ba'isi'cua, bacua gu'a yo'o, ja'an yo'ore sani, Riusu ta'yejeiyereba raosi'quëni yuareba huani senjoja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mësacua yua aña hua'na'ru ro coquejën, ro gu'aye yo'ojën ba'icua'ë. Ja'nca ba'icuabi Riusu bënni, ba toana senjoja'ñete gare jëaye beoye ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ja'nca ba'ijënna, yureca yë'ëbi yua Riusu bain raosi'cua, re'o bain masiye ëñocua, Riusu cocare yihuocua, ja'ancuare mësacuana saoni jo'cayë. Saoni jo'caguëna, mësacuabi yequëcuani crusu sa'cahuëna reoni, huani senjoja'cua'ë. Yequëcuani mësacua coca ye'yo huë'eñana sani, si'nseni, ja'nrëbi si'a huë'e joboñana bi'rajën, bacuani je'o bajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ja'nca ba'ijënna, Riusubi si'a baguë re'o bain huani senjosi'cuare ro'tani, mësacua jucha'ë caguë bëinja'guë'bi. Ru'ru Abel, re'o bainguë ba'isi'quë huani senjosi'quë, ja'anguëte ro'tani, ja'nrëbi yo'je, Berequías mamaquë Zacarías, Riusu huë'e misabë ca'ncore ba'iguëna huani senjosi'quë, si'acuare ro'tani, Mësacuabi huani senjohuë caguë ba'iji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ganreba mësacuani caguë quëayë yë'ë. Riusubi bënni senjoñe ro'taguë, yurera güina'ru mësacuani yo'oye ro'taji baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén bain, Jerusalén bain, mësacuani coca quëaye bayë yë'ë. Riusu ira bain raosi'cua si'acuani huani senjohuë mësacua. Riusu coca quëaye raosi'cuani gatabi senjojën, huani senjohuë mësacua. Mësacua mamacuare ai ta'yejeiye choini jëhuahuë yë'ë. Cura hua'gobi bago zin hua'nare choini, bago ganhua cabëan yijacuana ta'pini cuirago yo'oye'ru mësacua mamacuare güina'ru cuiraye yëhuë yë'ë. Ja'nca yëguëbi choiguëna, mësacua raiye güereba güehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ja'nca sëani, mësacuani bënni senjoñe cani jo'cayë yë'ë. Mësacua huë'e yua senjosi huë'e'ru ruinji. ");
INSERT INTO snnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yureca ën coca: “Riusu cuencuesi'quëbi raiguëna, baguëni bojoreba bojojën bañuni” ja'an coca cani jo'case'e ba'ija'ye tëca, mësacua yua yë'ëni gare se'e ëñama'icua ba'iyë, cani, ja'nrëbi bacuare jo'cani saji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jo'cani saiguë, Riusu uja huë'ere jo'cani saiguëna, baguëte concuabi tëhuo rani, ba uja huë'eña jai huë'eñare Jesusni ëñohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ëñojënna, Jesús yua bacuani quëabi: —Mësacuabi ën huë'eñare ëñajënna, mësacuani ganreba quëayë yë'ë. Si'a huë'eña yua ñañoni taonsi huë'eña ba'ija'guë'bi. Gare te'e gatabë tuiye beoye ba'ija'guë'bi, quëaguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ja'nca quëani, ja'nrëbi, Olivo casi cubëna mëni bëaguëna, baguëte concua se'gabi tëhuo rani, baguëni yahue senni achahuë: —¿Riusu huë'e quejeito taonni huesoye'ne? ¿Më'ë se'e raija'ye, ën yija carajeiye, ja'anrën ti'anja'ñete queaca masiye poreye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Senni achajënna, Jesús sehuobi: —Mësacua ëñare bajë'ën. Yequëcuabi mësacuani ro coquema'iñe cajën, mësacua ëñare bajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bainre coquecua ai ba'icuabi rani, “Riusu Raosi'quëreba'ë yë'ë. Ba Cristo'ë yë'ë” cajën, ro coquejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mësacua yua si'aruan guerra huayete achajën, quëquëye beoye ba'ijë'ën. Bain guerra huaja'ye yuara cuencuese'e ba'iguëna, ën yija carajeirën yuta ti'anma'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bain jubëan yua sa'ñeña ai guerra huani ai yo'ojën ba'ija'cua'ë. Si'aruan yija ñu'cueye, aon gu'ana ju'iñe, ja'anna ai yo'ojënna, ");
INSERT INTO snnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","yuta ai yo'ojën ba'iye ai caraji. ");
INSERT INTO snnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ja'nrëbi, yequëcuabi mësacuani preso zeanni, mësacuani ai yo'o güeseja'cua'ë. Mësacuare huani senjoja'cua'ë. Mësacua yua yë'ë bainrebare sëani, si'a re'oto bainbi mësacuani bëinjën, je'o bajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ja'nca ba'iguëna, yequëcua yë'ë bainreba cacua, ai jai jubëbi yë'ë ma'a ëñose'ere gare jo'cani senjoja'cua'ë. Sa'ñeña ro coquejën preso zean güesejën, sa'ñeña je'o bajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yequëcua, Riusu bain raosi'cua'ë yëquëna cajën, ro coquejën, ai jai jubë bainni ai gu'aye yo'o güesejën ganija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ja'nrëbi, bain hua'nabi ai ta'yejeiye gu'ajeijën, bacua sa'ñeña ai yëjën ba'ise'ere gare jo'caja'cua'ë. Riusute ai yëye jo'cajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ja'nca ba'ija'yeta'an, yë'ëni si'a recoyo jo'caye beoye ro'tajën ba'ijë'ën. Ja'nca ro'tajën ba'itoca, carajeirën ti'anguëna, Riusubi mësacuani tëani baja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yureca Riusu ba'i jobo ba'iye, ja'an cocareba ru'ru si'a ën yija bainna quëani achose'e ba'ija'guë'bi. Si'a re'oto bainbi ja'anre masija'bë caguë, ba cocare si'aruanna quëani achose'e ba'ija'guë'bi. Ja'nca ba'iguëna, ja'nrëbi, ën yijabi carajeija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yureca Riusu bainguë ja'anrë raosi'quë Daniel hue'eguë, ja'anguëbi carajeirën ba'ija'guë, ba gu'aye huesoni si'aja'guë, ja'anguëte cani toyani jo'cabi. Ro ën yija bainbi ja'an gu'aguëni inni sani, Riusu uja huë'ena nëconi baja'cua'ë. Ën coca ëñacuabi te'e ruiñe ye'yeni masija'bë cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ja'nca nëconi bajënna, Judea yija ba'icuabi yua cu re'otona sani gatija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yequëcua, bacua huë'e ëmëje'en ba'irute banica, bacua huë'e bonsere injën gajema'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yequëcua huë'e jobo ca'ncoña ba'icua banica, bacua cañate injën go'ima'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Romi hua'na zinbë ba'icua, zin chuchajën ba'icua, ja'ancua banica, ¡bacuare ai yo'ojën ba'ija'guë'ë! ¡Chao hua'na! ");
INSERT INTO snnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bacua sani gatija'rën ti'anguëna, sësërën, yo'o yo'oma'i umuguse, ja'anrën ba'ima'ija'ñe cajën, Riusuni ujajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ja'an umuguseña ti'anguëna, bainbi ai ta'yejeiye ai yo'ojën ba'ija'cua'ë. Bainbi si'a Riusu re'huani jo'casi umuguseña ai yo'ojën ba'iye'ru quë'rë ta'yejeiye ai yo'ojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja'nca ai yo'ojën ba'ijënna, mai Ëjaguë Riusubi zoe ai yo'oma'i güeseji. Ai yo'o güesetoca, si'a bainbi gare huesëni carajeijën ba'ire'ahuë. Riusu bainreba cuencuesi'cuani ai yëguë sëani, bainbi zoe ai yo'ojën ba'ima'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ja'an umuguseña ti'anguëna, yequëcuabi mësacuani coque ëaye yo'ojën ba'ija'cua'ë. Bacuabi cajën, “Ëñajë'ën. Querute ba'iji Cristo” o “Ëñajë'ën. Ënjo'onre ba'iji” ja'anre catoca, bacuani achaye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jai jubë bainbi Cristo'ë yë'ë cacua, Riusu raosi'quë'ë yë'ë cacua, ja'ancuabi rani, bainni ro coquejën, Riusu ta'yejeiye masini ëñoñe'ru ëñojën, Riusu bain cuencuesi'cuare'ga coqueñu cajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yureca yë'ëbi mësacuani ru'ru quëaguëna, bacua coquejën case'ere ëñare bajën, achaye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ja'nca sëani, bacuabi, “Ëñajaijë'ën. Cristo yua beo re'otore ba'iji” catoca, sani ëñama'ijë'ën. Yequëcuabi, “Huë'e sa'nahuëreba ba'iji Cristo” catoca, bacua cocare ro'tama'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mëjobi ënsëguë etajei ca'ncobi jue'neni, ënsëguë rucajai ca'nco tëca miaguëna, ja'anre ro'tani, yë'ë se'e ti'an raija'yete masijë'ën. Yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi te'e jëana gaje raija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ga'nihuëbi pu'ncaguë uinguëna, guëta caro hua'nabi ñë'ca raiyë. Ja'anre ro'tani, ëñe se'ga masijë'ën: Bainbi gare gu'ajaijën ba'ijënna, Riusubi yua te'e jëana bënni senjoguë raija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ja'anrën ti'anguëna, bainbi ai yo'oni si'ajënna, ja'nrëbi ja'an umuguseña bani, ënsëguëbi gare yayajeija'guë'bi. Ñañaguë'ga gare se'e ëñoma'ija'guë'bi. Ma'choco hua'i'ga guënamë re'otobi tonni huesëni si'aja'cua'ë. Guënamë re'oto si'a re'otobi ai jëja ñu'cueja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja'nrëbi bain hua'nabi pico re'otona ëñato, yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi gaje raija'guë'ë yë'ë. Gaje raiguë ba'iguëna, si'a ën yija bain jubëanbi ëñani, bacua gu'a jucha yo'ojën ba'ise'ere ro'tani, ai ota oijën güija'cua'ë. Yë'ë yua ai ta'yejeiye ba'iguë, ai go'sijeiye ba'iguë, pico re'otobi gaje raiguëna, yë'ëre ëñaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ja'nca gaje meni ëñoja'guëbi yua coneta ai jëja juni, yë'ë guënamë re'oto yo'o concuani coca guanseguë caja'guë'ë yë'ë: “Mësacua si'a yija ca'ncoña, si'a guënamë ca'ncoña, si'aruanna sani, yë'ë bainreba cuencuesi'cuare ñë'cojani rajë'ën” guanseguë cani, yo'o concuare saoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mësacua yua higo sunquiñë ja'o sariyete ëñani ye'yejë'ën. Bañëbi juinja cabëanbi irani, ja'nrëbi ja'o sari bi'raji. Sari bi'raguëna, mësacuabi ëñani, Ënsërën ti'anji cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yë'ë coca yure case'ere'ga ro'tajën, ja'an ba'ija'ye ti'anguëna, güina'ru, mësacua yua Carajei umuguseña ti'anbi cajën, ja'anre masijën ba'ijë'ën, te'e jëana ti'anja'ñe sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mësacuani ganreba yihuoguë quëayë yë'ë. Yureña bainbi yuta junni huesëma'ijënna, yë'ë coca case'e'ru si'aye ru'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Guënamë re'oto, yija re'oto, ja'anbi gare carajeito'ga, yë'ë cocareba cani jo'case'ebi yua carajeiye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ja'an umuguse ba'ija'ye, ja'an hora ba'ija'ye, ja'anre senni achatoca, bainbi gare huesëjën ba'iyë. Riusu guënamë re'oto yo'o concua'ga gare huesëjën ba'iyë. Yë'ë'ga, Riusu Zin ba'iguëca gare huesëguë ba'iyë. Taita Riusu se'gabi masiji. ");
INSERT INTO snnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yë'ë gaje raija'yete masiye yëtoca, ira bainguë ba'isi'quë Noé, baguë ba'isi umuguseña'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ja'an umuguseña, co'jeya yuta raimaquëna, bain hua'nabi bacua aon ainjën gono uncujën, yequëcuabi romire huejajën, ja'nca yo'ojën ba'nhuë. Noebi baguë yoguna cacaguëna, ja'an umuguse tëca ja'nca yo'ojën ba'nhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja'nrëbi co'jeyabi rani, bacuani gare huesoni si'aguëna, ba co'jeya raija'yete gare huesëjën ba'nhuë. Ja'nca huesëjën ba'ijënna, yë'ë gaje rairën'ga güinajeiñe ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ja'anrën ti'anguëna, samucuabi ziore ba'ijën, te'e yo'o yo'ojënna, te'eguëte sayë. Yequëni jo'cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Romi hua'na samucuabi huea toarote te'e ba'ijën, hueare toajënna, te'egote sayë. Yeconi jo'cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ja'nca ba'iguëna, mësacuaca ëñajën ba'ijën, Riusuni jo'caye beoye ujajën ba'ijë'ën. Mësacua Ëjaguë ti'anja'rënre huesëcua sëani, ja'nca ëñajën ëjojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ëñe'ga achani masijë'ën. Huë'e ëjaguëbi jianguë raija'yete, ñami gue hora raija'yete masitoca, ëñaguë ëjoguë ba'ire'abi. Baguë huë'e bonsere jian güesema'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mësacua'ga güina'ru yë'ë gaje raija'yete ëñajën ëjojën ba'ijë'ën. Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi gaje raija'ye cato, mësacuabi ro'tama'ijënna, te'e jëana gaje raija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ëja bainguëre yo'o concua yo'ose'ere ro'tajë'ën. Te'eguëbi te'e ruiñe recoyo ro'taguëna, baguë ëjaguëbi so'o sai bi'raguë, baguë huë'ere cuiraye guanseni, baguëni cani jo'cabi. “Yë'ëre yo'o concuani bacua yo'o yo'oye guanseguë, bacua aon aiñe insiguë ba'ijë'ën” cani jo'cani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sani ja'nrëbi jë'te, se'e rani ëñato, baguëre yo'o conguëbi baguë huë'ere ai re'oye cuiraguë ba'itoca, baguëni ai bojoguë, baguëni ai conguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ja'nca ba'iguë, baguë huë'e, baguë yija, baguë bonse, si'ayete baguëre yo'o conguë re'oye yo'osi'quëna insini, baguë yo'je ëjaguëre re'huaguëna, ai bojoguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ja'nca ba'iguëna, yequë yo'o conguë re'oye yo'oma'iguëna, ja'anguëna güina'ru jo'cani so'ona saitoca, ja'anguëbi gu'aye yo'oji. “Yë'ë ëjaguëbi zoe sani raima'iji” caguë, ");
INSERT INTO snnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","baguë gaje concuani huani, güebe ëaye ba'icua naconi aon anni jo'cha uncuni ba'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","baguë ro'taguë ba'ima'i umuguse, baguë huanë yeni ba'iguëna, baguë ëjaguëbi joë ba'irënbi ti'an raija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ja'nca ti'an rani ëñani, baguëni ai bënni senjoguë, gu'a bain ba'iruna jo'cani senjoja'guë'bi. Re'o bain'ë yëquëna, casi'cuabi ro coquejënna, ja'anruna jo'cani senjosi'cua ba'ijën, ai ta'yejeiye oijën, bacua zemeñoare cuncujën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yureca, Riusu ba'i jobo ba'iyete masiye yëtoca, yequëcua romi zincua si'a sara ba'icuare quëaguëna, achani ye'yejë'ën. Hueja fiestana saicuabi bacua majahuëanre sani, huejaja'guëni ëjoñu cajën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bacua jubë ba'icua, te'e ëntë sara ba'icuabi ro ro'tajën huesë hua'na baë'ë. Yequëcua te'e ëntë sara ba'icuabi ai masiye ro'tajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ro huesë hua'nabi saijën, maja ro'rohuëanre samaë'ë, bacua majahuëanna queoyete. ");
INSERT INTO snnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Masiye yo'ocuaca maja ro'rohuëanre bacua majahuëan naconi sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ja'nca sani ëjojënna, ba huejaja'guëbi yuta raimaquëna, si'acuabi umeni cainjën ëjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ja'nca ëjojënna, ñami jobo ba'iguëna, bainbi quëani achojën güihuë: “¡Ëñajë'ën! Huejaja'guëbi raiji. Baguëni tëhuojën saiñu” güihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Güijënna, ba romi zincuabi huëni, bacua majahuëanre re'huahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Re'huani, ba huesë hua'na te'e ëntë sara ba'icuabi bacua masi gajecuani cahuë: “Yëquëna majahuëan yaya bi'raji. Mësacua majare choa ma'carë insijë'ën” cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Cajënna, maja bacuabi sehuohuë: “Bañë. Ja'nca yo'otoca, majabi ti'anma'iji. Mësacua yua maja bendiecuana sani coni bajë'ën” sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ja'nca sehuojënna, cojën saë'ë. Saisi'cua ba'ijënna, ba huejaja'guëbi ti'anbi. Ti'anguëna, yequëcua re'o majahuëan re'huasi'cuabi baguë naconi hueja fiesta huë'ena te'e cacahuë. Cacajënna, anto sa'ro yua ta'pise'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ja'nrëbi ba maja cojën saisi'cuabi rani, anto sa'rona choë'ë: “Ëjaguë, ëjaguë, ancojë'ën” cajën choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ja'nca choicuareta'an, huejaja'guëbi sehuobi: “Mësacuani ganreba caguë quëayë. Mësacua yua tincuare sëani, mësacuani huesëguë'ë yë'ë” sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ja'nca ba'iguëna, ëñere achani ye'yejë'ën. Mësacua yua Ëjaguë ti'an raiyete ëñajën ëjojën ba'ijë'ën. Baguë rai umuguse, baguë raija'rën, ja'anre gare huesëja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ën cocare achani, Riusu ba'i jobo ba'iyete ye'yejë'ën. Ëja bainguëbi so'o yijana saiza caguë, baguëre yo'o concuare choini, baguë bonsere bacuana jo'ca bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ru'ru ba'iguëna curi so'co cinco mil so'coña insibi. Yequëna samu mil so'coña insibi. Yequëna te'e mil so'coña insibi. Insini, bacuani cabi: “Mësacua porese'e'ru negociajaijën, curi jaijei güesejën ba'ijë'ën” caguë, baguë curire huo'hueni jo'cabi. Insini tëjini, ja'nrëbi saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Saquëna, cinco mil so'coña cosi'quëbi ja'ansi'quë sani, negociajani, se'e yequë cinco milre ganani babi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Samu mil so'coña cosi'quë'ga sani, se'e yequë samu milre güinajeiñe ganani babi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Te'e mil so'coña cosi'quëca sani, yijana no'ani, baguë ëjaguë curire yahueni re'huani babi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ja'nca yo'ojënna, ai zoe ba'iguëna, ba ëjaguëbi se'e goni, baguëre yo'o concuare choini, baguë curi insise'ere cuencueza caguë senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Senguëna, cinco mil so'co cosi'quë yua se'e yequë cinco milre ganasi'quëbi rani, ëjaguëni quëabi: “Ëjaguë, më'ëbi cinco mil so'coña yë'ëna insiguëna, se'e yequë cinco mil më'ëre ganacaë'ë. Më'ë curi sëani, se'e coni bajë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ja'nca caguëna, ëjaguëbi sehuobi: “Ai re'oye jaijeini curi ganahuë më'ë. Yë'ë yua choa ma'carëte insiguëna, yë'ëre jo'cani senjoma'isi'quëbi ai re'oye yo'ohuë më'ë. Ja'nca sëani, quë'rë ta'yejeiye ëjaguëre më'ëre re'huayë yë'ë. Yë'ë naconi te'e bojoguë ba'ijë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Caguëna, ja'nrëbi samu mil so'co cosi'quëbi baguë ëjaguëna rani quëabi: “Ëjaguë, më'ëbi samu mil so'coña yë'ëna insiguëna, yureca se'e samu milre më'ëre ganacaë'ë yë'ë. Më'ë curi sëani, se'e coni bajë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ja'nca caguëna, ëjaguëbi sehuobi: “Ai re'oye jaijeini curi ganahuë më'ë. Yë'ë yua choa ma'carëte insiguëna, yë'ëre jo'cani senjoma'isi'quëbi ai re'oye yo'ohuë më'ë. Ja'nca sëani, quë'rë ta'yejeiye ëjaguëre më'ëre re'huayë yë'ë. Yë'ë naconi te'e bojoguë ba'ijë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Caguëna, ja'nrëbi te'e mil so'co cosi'quëbi rani, ëjaguëni quëabi: “Ëjaguë, më'ë yua ai jëja guanse ëjaguë ba'iguëna, masihuë yë'ë. Yequëcua yo'o yo'ose'ere tëani baguë'ë më'ë. Yequëcua zioña tanse'ere tëani baguë'ë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja'nca ba'iguëna, më'ë curire huesoma'iñe caguë, më'ëni huaji yëhuë yë'ë. Më'ë te'e mil so'coña coni, sani, yijana no'ani yahueni re'huacaë'ë. Ja'nca yahueni re'huase'e ba'iguëna, më'ë curire coni bajë'ën” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ja'nca caguëna, ëjaguëbi bëinguë sehuobi: “Ai gu'aye yo'ohuë më'ë. Ro ñame hua'guë se'ga ba'iyë. ¿Yequëcua yo'o yo'ose'ere tëani baguë'ë yë'ë, caguë? ¿Yequëcua zioña tanse'ere tëani baguë'ë yë'ë, caguë? ");
INSERT INTO snnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ja'nca catoca, yë'ë curire sani, curi re'hua huë'ena jo'care'ahuë më'ë. Ja'nca jo'catoca, yë'ëbi se'e rani coto, rédito naconi, curi jaijaquëna, coni bare'ahuë yë'ë” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cani, yequëcua, baru nëcacuana bonëni cabi: “Baguë te'e mil so'coña tëani, diez mil baguëna insijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ai ta'yejeiye cosi'quëna quë'rë ai ta'yejeiye insise'e ba'ija'guë'bi. Baguëte carajeiye beoye ba'ija'guë'bi. Choa ma'carë cosi'quëni baguë bayete tëase'e ba'ija'guë'bi, cayë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yureca ba yo'o conguë gu'a ñame hua'guëni zeanni, hue'se ca'nco, zijei re'otoreba ba'iruna baguëte senjojë'ën. Ja'anru ba'icuabi ai oijën, bacua zemeñoare ai cuncujën ba'ija'cua'ë” cabi ba ëjaguë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yureca yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi, yë'ë guënamë re'oto yo'o concua si'a jubë naconi se'e gaje raiguë, yë'ë jëja guëna seihuë go'sijei seihuëna bëani, ");
INSERT INTO snnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","si'a ën yija re'oto bain ñë'cosi'cuani ëñaja'guë'ë yë'ë. Ëñani, yequëcuare ca'ncorëna quë'ñeni, yequëcuare jo'caja'guë'ë yë'ë. Jo'ya ëjaguë yo'oye'ru, oveja hua'nare chivo jubëbi quë'ñeñe'ru, bainre quë'ñeja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oveja hua'nare jëja ca'ncona quë'ñeñë. Chivo hua'nare ari ca'ncona quë'ñeñë. Ja'nca quë'ñeñe'ru bainre quë'ñeja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ja'nca quë'ñeñe'ru quë'ñeni, ja'nrëbi, yë'ë yua Ta'yejeiye Ëjaguë ba'iguëbi jëja ca'ncona quë'ñesi'cuani caja'guë'ë yë'ë: “Mësacua raijë'ën. Yë'ë Taitabi mësacuani cuencueni, mësacuani ai re'oye yo'oye ro'tani, baguë ba'i jobore ën yija re'huani jo'casirënbi mësacuare re'huacaiguë baji'i. Ja'nca ba'iguëna, ja'an jobona ti'anni, si'arën ba'ijën, bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yë'ë yua aon gu'a ju'inguë ba'iguëna, yë'ëre aon aonhuë mësacua. Oco ëa ju'inguë ba'iguëna, yë'ëre gono uncuahuë. Tinrubi raisi'quëbi ba'iguëna, yë'ëni bojojën, mësacua huë'ena cacaye choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Can beohuë ba'isi'quë ba'iguëna, yë'ëna canre insihuë. Ju'inguë ba'iguëna, yë'ëre ëña raë'ë. Ya'o huë'ena zeansi'quë ba'iguëna, yë'ëna rani conhuë.” Ja'an cocare bacuani caja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Caguëna, ja'nrëbi ba jubë re'o bainbi yë'ëni sehuoja'cua'ë: “Ëjaguë, më'ë case'ere achama'iñë yëquëna. ¿Më'ë aon gu'a ju'inguë ba'iguëna, yëquëna quejeito aon aonre'ne? ¿Më'ë oco ëa ju'inguë ba'iguëna, yëquëna quejeito gono uncuare'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Më'ë tinrubi raisi'quë ba'iguëna, quejeito yëquëna huë'ena chote'ne? ¿Më'ë can beohuë ba'isi'quë ba'iguëna, quejeito më'ëre can insire'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Më'ë ju'in hua'guë ba'isirën, më'ë ya'o huë'ena zeansirën, ja'anrëan ba'iguëna, quejeito më'ëni ëñajën sate'ne, Ëjaguë?” sehuojën senni achaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Senni achajënna, yë'ë yua bacuani sehuoja'guë'ë: “Mësacuani quëareba quëayë yë'ë. Yë'ë bainreba, quë'rë yo'je ba'icua, ja'ancuani re'oye yo'oni conjën, ja'nca yë'ëni ai re'oye yo'oni conhuë mësacua” sehuoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ja'nca sehuoni, ja'nrëbi ari ca'nco ba'icuana bonëni, bacuani bëinguë caja'guë'ë yë'ë: “Mësacua bënni senjosi'cua yua yë'ë ba'irubi quëñëni saijë'ën. Ba toa yayaye beoye ba'iguëna, zupai huati, baguë huati concua, bacua ba'i re'oto re'huani jo'case'e, ja'anruna sani, si'arën ba'ijë'ën mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yë'ë yua aon gu'a ju'inguë ba'iguëna, mësacua yua yë'ëre aon aonmaë'ë. Oco ëa ju'inguë ba'iguëna, yë'ëre gono uncuamaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tinrubi raisi'quë ba'iguëna, mësacua huë'ena cacaye choimaë'ë. Can beohuë ba'iguëna, yë'ëre can insimaë'ë. Ju'inguë ba'iguëna, ya'o huë'ena zemosi'quë ba'iguëna, mësacuabi gare yë'ëre ëñajaimaë'ë” bacuani bëinguë caja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Caguëna, bacuabi sehuoja'cua'ë: “Ëjaguë, më'ë case'ere achama'iñë yëquëna. ¿Më'ë aon gu'a ju'inguë ba'isi'quë, më'ë oco ëa ju'inguë ba'isi'quë, më'ë tinrubi raisi'quë, can beohuë ba'isi'quë, ju'inguë ba'isi'quë, ya'o huë'ena zemosi'quë, ja'an ba'iguëna, quejeito më'ëni conmate'ne yëquëna?” sehuojën senni achaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Senni achajënna, yë'ëbi bacuani sehuoja'guë'ë: “Mësacuani quëareba quëayë yë'ë. Yë'ë bainreba, quë'rë yo'je ba'icua, ja'ancuare gare conmajën, ja'nca yë'ëre güinajeiñe conmaë'ë mësacua” sehuoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja'nca sehuoguëna, bacuabi sani, yua gare caraye beoye bënni senjosi'cua ba'ija'cua'ë. Re'o bainca yua caraye beoye si'arën bojojën ba'ija'cua'ë” cani, baguëre concuani yihuoni tëjibi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ja'nca yihuoni tëjini, Jesusbi baguëre concuani cabi: ");
INSERT INTO snnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Yureca samu umuguseña bani, pascua umugusebi ti'anji. Ja'anre masiyë mësacua. Ja'nca ti'anguëna, judío ëja bainbi yë'ë, Bainguë'ru Raosi'quëreba ba'iguë, yua yë'ëre preso zeanni, yë'ëni crusu sa'cahuëna reoñu cajën, yë'ëni huani senjo güeseja'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ja'nrëbi, pairi ëja bain, bain iracua, ja'ancuabi quë'rë ta'yejeiye pairi ëjaguë, Caifás hue'eguë, baguë huë'ena ñë'cani, ");
INSERT INTO snnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sa'ñeña coca cajën, Jesusni yahuera'rë preso zeanni, baguëni huani senjoñu cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ja'nca cajën: —Fiesta ta'yejeiye umuguse ba'itoca, preso zeañe porema'iñë. Zeantoca, bain hua'nabi ai jai jubë ba'ijën, yequërë maini bëinjën maini je'o ëñama'iñe, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yureca, Jesusbi Betania huë'e jo'borëte baji'i. Simón hue'eguë, ira ca'mi raure junni huajë raisi'quë, baguë huë'ere baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ja'nca ba'iguëbi aon ainguë ñu'iguëna, romigobi ti'anni, ma'ña re'co, nardo casi re'co, alabastro gata ro'rohuëna rago. Ai roji'i ba re'co. Ja'anre rani, ba re'core Jesús sinjobëna jañuni tongo. ");
INSERT INTO snnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jañuni tongona, Jesusre concuabi ëñani, bagoni bëinjën, sa'ñeña cahuë: —¿Queaca ro'tago bago, ba re'core ro jañuni tonni huesogo'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ba re'core bendietoca, ai curi coni, bonse caracuana ro insiye porere'ahuë, sa'ñeña cajën, bagoni bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bëinjënna, Jesusbi bacuani ëñani cabi: —Mësacua ¿guere ro'tajën ënseye'ne? Ma'ña re'core yë'ëna jañuni tongo, ai re'oye yo'ogo bago. ");
INSERT INTO snnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bonse caracuare cato, bacua yua mësacua naconi si'arën ba'iyë. Mësacua yëse'era'ru bacuana insiye poreyë. Yë'ëca mësacua naconi zoe ba'ima'iñë ënjo'on. ");
INSERT INTO snnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yureca bagobi yë'ë junni tanja'ñete ro'tago, yë'ë ga'nihuëte ma'ña re'cobi ru'ru re'huago. ");
INSERT INTO snnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mësacuani ganreba yihuoguë quëayë yë'ë. Yë'ë bainbi Riusu cocarebare si'aruanna quëani achojën, ënco ba'iyete gare huanë yema'iñe cajën, bago yure yo'ose'ere'ga quëani achojën ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ja'nrëbi, Judas Iscariote hue'eguë, Jesusre concua jubë si'a sara samucua ba'i jubë, ja'an jubë ba'iguëbi yua pairi ëja bainna sani, ");
INSERT INTO snnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bacuani senni achabi: —Jesusre mësacuana insitoca, ¿mësacua quejeiye yë'ëre ro'iye'ne? senni achabi. Senni achaguëna, bacua yua treinta curi so'coña, plata so'coñare baguëna insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Insijënna, ja'nrëbi, Judas yua Jesusre insini senjoñe ro'ta bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ja'nrëbi, judío bainbi Aon huo'coma'ise'ere aiñu cajën, ja'an fiesta umuguse ru'ru ba'i umugusebi ti'anguëna, Jesusre concuabi baguëni senni achahuë: —¿Mai pascua aon ainru jarona sani re'huaye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Senni achajënna, Jesús yua bacuani cabi: —Mësacua yua huë'e jobona saijë'ën. Sani ti'anni, Ja'anguë hue'eja'guëni tëhuoni, ñaca quëajë'ën: “Mai Ëjaguëbi më'ëni coca senni achaguë raobi: Yë'ë carajeirën ti'anbi. Më'ë huë'ena sani, yë'ëre concua naconi pascua aonre ainzaniñë” quëajë'ën, cani, bacuare saobi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Saoguëna, bacuabi sani, Jesús quëase'e'ru güina'ru yo'oni, pascua aonre re'huahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Re'huajënna, ja'nrëbi, na'i si'aguëna, Jesusbi ti'an rani, baguëre concua si'a sara samucua naconi bëani, aonre ain bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ja'nrëbi, ainjënna, Jesús cabi: —Mësacuani ganreba caguë quëayë yë'ë. Mësacua jubë ba'iguë, te'eguëbi yë'ëre yequëcuana preso insini senjoja'guë'bi, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ja'nca caguëna, bacuabi ai sa'ntijën, te'ena, te'ena, baguëni senni acha bi'rahuë: —¿Yë'ë'ye, Ëjaguë? senni acha bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Senni achajënna, sehuobi: —Yë'ë naconi te'e guëna re'ahuana aon ainguë, ja'anguëbi yë'ëre insini senjoja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Riusu coca toyani jo'case'ere ëñato, yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi junni toñe ba'iye quëaji. Ja'nca quëase'eta'an, yë'ëre insini senjoja'guëte ai bënni senjoja'ñe cani jo'case'e ba'iji. ¡Baguë bënni senjoja'ñete ro'tato, chao hua'guë ai yo'oja'guë'bi! Baguë të'ya raise'e beotoca, quë'rë re'oye ba'ire'abi baguëre, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Caguëna, ja'nrëbi Judas hue'eguë, baguëte insini senjoja'guëbi Jesusni: —¿Ëjaguë, yë'ë'ye? senni achabi. Senni achaguëna, Jesusbi: —Jaë'ë. Më'ë case'e'ru güinajeiñe ba'ija'guë'bi, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja'nrëbi, aonre ainjënna, Jesusbi ba jo'jo aonbëte inni, Riusuni ujaguë, Surupa cabi. Cani ja'nrëbi, aonbëte jë'yeni, baguëre concuana huo'hueni, bacuani cabi: —Mësacua coni ainjë'ën. Yë'ë ga'nihuë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cani ja'nrëbi, uncu ro'rohuëte inni, se'e Riusuni ujaguë, Surupa cani, ja'nrëbi ba uncu ro'rohuëte bacuana insini, bacuani cabi: —Mësacua si'acuabi coni uncujë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yë'ë zie meni tonse'e'ë. Ai jai jubë bain gu'a juchana zemosi'cuare tëani re'huani baza caguë, bainni mame coca cani jo'caja'guë'ë cayë yë'ë. Ja'an ro'ire yë'ë zie yua meni tonse'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yureca, mësacuani quëareba quëayë yë'ë. Bisi ëye gonore gare se'e uncuma'iñë yë'ë ënjo'on. Yë'ë Taita ba'i jobona ti'anni, ja'nrëbi ba gono mame re'huase'ere mësacua naconi te'e uncuni ba'ija'guë'ë yë'ë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Caguëna, ja'nrëbi, Riusuni bojojën gantani, bacuabi Olivo casi cubëna saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sani, Jesús yua bacuani quëabi: —Yure ñami, mësacua si'acuabi, yë'ëre güejën, yë'ëre ro jo'cani senjoja'cua'ë. Riusu coca toyani jo'case'ere'ru güina'ru yo'oja'cua'ë mësacua. Ën coca toyani jo'case'ere achajë'ën: “Oveja ëjaguëni huani senjojënna, oveja jo'ya hua'nabi ro bacua yësiruanna gatini saiyë” toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ja'nca huani senjojënna, yua go'ya raija'guë'ë yë'ë. Go'ya rani ja'nrëbi, Galilea yijana mësacua ru'runa sani, mësacuare tëhuoja'guë'ë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Quëaguëna, ja'nrëbi, Pedrobi baguëni cabi: —Si'acuabi më'ëre güejën senjocuareta'an, yë'ëca bañë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Caguëna, Jesús yua baguëni cabi: —Më'ëni ganreba quëayë yë'ë. Yure ñami, curabi yuta yu'ima'iguëna, më'ëbi samute ba'iye Jesusre ëñama'iguë'ë yë'ë caja'guë'ë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Caguëna, Pedro yua baguëni cabi: —Ja'nca cama'ija'guë'ë yë'ë. Më'ë naconi te'e junni tonza ru'ru, cabi. Caguëna, si'acuabi Jesusni güinajeiñe cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cajënna, bacua naconi sani, ja'nrëbi jo'ya re'ohuë, Getsemaní hue'eruna ti'anni, bacuani cabi: —Mësacua yua ënjo'ona bëani ëjojë'ën. Yë'ëbi queruna ujaguë saiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Cani ja'nrëbi, Pedro, Zebedeo mamacua samucua, bacuare quë'rë so'orë sabi. Ja'nca saguëbi recoyo ai sa'ntireba sa'ntiguë, ai yo'oguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ja'nca ba'iguëbi bacuani cabi: —Ai recoyo sa'ntiye huanoji yë'ëre. Junni tonja'ñe huanoji yë'ëre. Ja'nca ba'iguëna, mësacua yua ënjo'ona bëani, yë'ë naconi te'e ëñajën ëjojën ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cani ja'nrëbi, se'erë quëñëni, yijana gugurini umeni, Riusuni senreba senni achabi: —Yë'ë Taita, më'ëbi si'aye yo'oye poreyë. Yë'ë ai yo'oja'ye yurera ti'anguëna, më'ëbi yë'ëre tëaye poreyë. Ja'nca poreguëta'an, ro yë'ë yëse'e se'gare yo'oma'ijë'ën. Më'ë yëye se'gare yo'ojë'ën, ujaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cani ja'nrëbi, baguëre concua jo'casiruna goni ëñato, cainsi hua'na uën'ë. Ja'nca uinjënna, Jesús yua Pedroni bëinguë cabi: —¿Mësacua yua te'e hora se'ga yë'ë naconi ëñajën ëjoye poremate'ne? ");
INSERT INTO snnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Zupai huatibi coquema'ija'guë cajën, ëñajën ujajën ba'ijë'ën. Mësacua recoyo jëja bacuata'an, mësacua ga'nihuëte pa'npoye se'ga ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cani ja'nrëbi, se'e samu ba'iye quëñëni, se'e Riusuni ujaguë cabi: —Yë'ë Taita, yë'ë ai yo'oja'ye ba'ima'ija'ma caguëta'an, më'ë yëye'ru ai yo'oye baja'guë'ë yë'ë ujaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cani ja'nrëbi se'e goni ëñato, baguëre concuabi cainsi'cua uën'ë, ai ëo caiñe bacua sëani. ");
INSERT INTO snnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ja'nca uinjënna, baguë yua se'e samute ba'iye quëñëni, se'e Riusuni ujani, güina'ru coca cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cani ja'nrëbi, se'e baguëre concuana go'ini, bacuani cabi: —¿Mësacua yua zoe canni huajëye ro'taye? Yureca re'oji. Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëte preso zeanrën ti'anbi. Yureca yequëcuabi yë'ëre preso zeanni, yë'ëre gu'a bainna insija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ja'nca sëani, huëijë'ën. Saiñu. Yë'ëre ro coqueguë insija'guëbi yuara ti'anji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ja'nca caguë, baguëre concuani yuta coca cani tëjima'iguëna, Judas hue'eguëbi ti'anbi. Jesusre concua si'a sara samucua, bacua naconi ba'iguëbi baji'i. Ja'anguëbi yua yequëcua naconi, ai jai jubë bain guerra hua hua'tiña, bain huai cabëan, ja'anre bajën, Jesusre zeanjën raë'ë. Pairi ëjacua, judío bain ira ëjacua, bacuabi guansejënna, raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ja'nca raijënna, Judasbi Jesusre insiza caguë ro'taguë, yua ba bainni ru'ru ën cocare quëasi'quë baji'i: —Jesús ba'iruna ti'anni, baguëni muchaguë saludayë yë'ë. Ja'nca saludaguëna, ja'anguëni zeanni bajën, baguëte preso sajë'ën, quëasi'quë baji'i Judas. ");
INSERT INTO snnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja'nca quëasi'quëbi yureca Jesusna ja'nsi'quë tëhuoni: —¿Ba'iguë më'ë, Ëjaguë? cani, ja'nrëbi baguëni muchabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Muchaguëna, Jesús yua baguëni: —¿Më'ë gue raquë'ne? Senni achabi. Senni achaguëna, ja'nrëbi ba bainbi Jesusre tëhuoni, baguëni preso zeanni bahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Zeanni bajënna, joë ba'irën, Jesús naconi ba'iguëbi baguë guerra hua hua'tire rutani, pairi ta'yejeiye ëjaguë yo'o conguëni huaguë, baguë ganjorote jue'reni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tonguëna, Jesús yua ja'anguëni cabi: —Më'ë guerra hua hua'tire se'e hua'ti re'hua corohuëna jëojë'ën. Se'e yo'oma'ijë'ën. Si'acua ja'an hua'ti naconi huatoca, ja'ansi hua'tibi huani senjosi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aito. ¿Porema'iñe yë'ë Taitare ujaguë señe? Yë'ëbi Taita Riusuni ujani sentoca, baguë guënamë re'oto yo'o concua si'a sara samu jubëan jai jubëanre te'e jëana yë'ëna raoni coñe poreji. ");
INSERT INTO snnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ja'nca coñe poreguëta'an, yureca ja'nca yë'ëre conma'iji. Ja'nca contoca, baguë cocareba toyani jo'case'e'ru güinajeiñe yo'oma'ire'abi. Junni toñe ba'iji yë'ëre toyani jo'case'e sëani yë'ëre jëa güesema'iji cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cani ja'nrëbi, bain jubëanni coca cabi: —Mësacua yua guerra hua hua'tiñare bajën, bain huai cabëanre bajën, ¿queaca ro'tajën, jianguëre'ru yë'ëre yahue zeanjën rate'ne? Mësacua naconi si'a umuguseña Riusu uja huë'ere baë'ë yë'ë. Ja'nca ba'iguëbi mësacuani coca ye'yoguë ba'iguëna, mësacuabi yë'ëni preso zeañe beoye baë'ë ja'anrë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ja'nca ba'iyeta'an, Riusu ira bain ba'isi'cuabi baguë cocare toyani jo'cajënna, Riusubi bacua case'e'ru ba'ija'guë caguëna, yureña bacua cani jo'case'e'ru güina'ru yo'ose'e ba'iji, cabi Jesús. Ja'nca caguëna, baguëre concua si'acuabi baguëte jo'cani senjoni, ro gatini saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ja'nrëbi, preso zeancuabi Jesusre sani, Caifás hue'eguë, pairi ta'yejeiye ëjaguë, baguë ba'iruna nëcohuë. Ira coca ye'yocua, ira ëjacua, bacuabi ñë'casi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro'ga Jesusre so'o be'teguë, yua pairi ta'yejeiye ëjaguë huë'e yija tëca ti'anbi. Ti'anni, Jesús carajeiyete ëñaza caguë, soldado hua'na naconi bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ba'iguëna, pairi ëjacua, si'a ëja bain ñë'casi'cua naconi, bacuabi Jesusre huani senjoñe cañu cajën, baguë gu'aye yo'ose'ere tinjañu cajën ba'icuata'an, baguëte gu'aye caye poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yequëcua, ai jai jubë ba'icua, Baguë gu'aye yo'ose'ere ëñahuë yë'ë cajën, ro coquejën quëacuata'an, baguëni huani senjoñe caye yuta poremaë'ë. Ja'nrëbi gu'aye cacua samucuabi nëca rani ");
INSERT INTO snnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","cahuë: —Ënquëbi gu'aye caguëna, yëquënabi achahuë: “Riusu uja huë'e, bain yo'osi huë'ere taonni senjoñë yë'ë. Taonni senjoni, ja'nrëbi, samute umuguseña bani, ba huë'ere se'e yo'oyë yë'ë” cabi baguë, gu'aye cajën coquehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ja'nca cajënna, pairi ta'yejeiye ëjaguëbi nëcani, Jesusni senni achabi: —¿Gare sehuoye beoye ba'iguë më'ë? Bacuabi më'ë gu'aye yo'ose'ere quëajënna, ¿më'ë guere yo'oguë sehuoma'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Senni achaguëna, Jesús gare caye beoye nëcabi. Gare sehuoye beoye baji'i. Ja'nca ba'iguëna, pairi ta'yejeiye ëjaguëbi baguëni bëinguë cabi: —Mai huajëguë ba'i Riusubi ëñaguëna, cuencue coca cani te'e ruiñe quëajë'ën. ¿Më'ë yua ba Cristo Raosi'quë'guë? ¿Mai Ëjaguë Riusu Zin'guë më'ë? Te'e ruiñe sehuojë'ën, bëinguë cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Caguëna, Jesús sehuobi: —Më'ë case'e'ru ja'nca ba'iguë'ë yë'ë. Mai Ta'yejeiyereba Ëjaguë Riusubi baguë Bainguë Raosi'quëre yë'ëre re'huani raoguëna, baguë jëja ca'ncona bëani ba'ija'guë'ë yë'ë. Bëani ba'iguë, ja'nrëbi pico re'otobi gaje raiguëna, mësacuabi yë'ëre ëñaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ja'nca caguëna, pairi ta'yejeiye ëjaguëbi bëinreba bëinguë, baguë cañate zeanni ye'reguë cabi: —Riusuni gu'aye cabi baguë. Yua baguë gu'a jucha quëacuare se'e cu'ema'ina'a. Baguëbi Riusuni gu'aye caguëna, mësacuabi achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ja'nca sëani, ¿Queaca yo'oja'cua'ne mësacua caye'ne? senni achabi. Senni achaguëna, bacuabi: —Baguëni huani senjoñe ba'ija'guë'bi, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sehuoni, yua baguë ñacona canbi gueonni nëcojënna, yequëcuabi baguë ziana go tutuhuë. Yequëcuabi baguëre jëja huaë'ë. Yequëcuabi bacua ëntë abëbi baguëni huaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ja'nca huaijën, baguëni bëinjën senni achahuë: —¿Jaroguëbi më'ëni huaquë'ne? ¡Më'ë yua Riusu Raosi'quëreba ba'iye caguë sëani, masini quëajë'ën! cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yureca Pedrobi huë'e yijare ñu'iguëna, romi zingo yo'o congobi baguëni tëhuoni cago: —Më'ë'ga Jesús, ba Galilea bainguë, baguë naconi baë'ë, cago. ");
INSERT INTO snnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Cagona, Pedrobi sehuoguë, si'acuabi achajënna, cabi: —Banhuë. Më'ë caye achama'iguë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ja'nca cani, bain caca sa'ro tëca quëñëni gatiguëna, yeco romi zingobi baguëte ëñani, baru ba'icuani coca quëago: —Ënquëbi Jesús Nazareno naconi te'e baji'i, quëago. ");
INSERT INTO snnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Quëagona, Pedro yua Riusu achayete senni achaguë, bacuani cuencue cocare ganreba cabi: —Banhuë. Ba bainguëte gare ëñama'iguë'ë yë'ë. Baguëte huesëguë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Caguëna, ja'nrëbi jë'te, baru ba'icuabi Pedroni tëhuoni cahuë: —Aito. Jesusre consi'quë baë'ë më'ë. Më'ëbi Galilea bain caye'ru caguëna, masihuë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Cajënna, baguë yua ai jëja sehuobi: —Banhuë. Yë'ëbi te'e ruiñe cama'itoca, Riusubi ëñani, yë'ëni huaija'guë. Mësacuabi ba bainguëte cajënna, baguëte gare huesëguë'ë yë'ë, sehuoguë cabi. Caguëna, ja'ansirën curabi yuji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ja'nca yu'iguëna, Pedrobi Jesús coca case'ere ro'tajaji'i: “Curabi yuta yu'ima'iguëna, më'ëbi samute ba'iye yë'ëre huesëye caja'guë'ë më'ë.” Ja'an coca case'ere ro'tani, ja'nrëbi sani, si'a recoyo oireba oji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ja'nrëbi ñataguëna, pairi ëjacua, judío bain ira ëjacua, si'a ëja bainbi ñë'cani, sa'ñeña coca cajën, Baguëre sani huani senjo güeseñu cajën, ");
INSERT INTO snnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","baguëte preso zeanni huenni, romano bain ta'yejeiye ëjaguë Pilato hue'eguëna sani nëcohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yureca Judas hue'eguë, Jesusre insini senjosi'quëbi Jesús huani senjoja'ñete ëñani, Baguëni ai gu'aye yo'ohuë yë'ë caguë, baguë treinta so'coña plata so'coñare inni, pairi ëjacua, ira ëja bain, bacuana go'yani ");
INSERT INTO snnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","quëabi: —Ai gu'aye yo'ohuë yë'ë. Gu'aye yo'oma'iguëni ro zean güesehuë yë'ë, quëabi. Quëaguëna, bacuabi sehuohuë: —¿Më'ë queaca ro'taguë, ja'an cocare yëquënani quëaguë raquë'ne? Më'ë se'ga masijë'ën, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ja'nca sehuojënna, baguë plata so'coña Riusu huë'e ba'iruna ro senjoni jo'cani saji'i. Sani ja'nrëbi, bisimebi baguë ñaje tëcana gueonni, ja'nsi'quëbi huajë gui'ini reani junji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ja'nrëbi, pairi ëja bainbi ba plata curi senjose'ere chiani, sa'ñeña cahuë: —Yureca, ën curi yua bainguëni huani senjoñe ro'ise'ere sëani, Riusu huë'e gajonguna ayaye porema'iñë cajën, ");
INSERT INTO snnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","guere yo'oye'ne senni achajën, bacuabi sani, sotoroan re'huacua yija, ja'an casi yijare ba curibi cohuë. Yequë yijaña raisi'cuabi junni huesëtoca, ba yijana bacuare tañu cajën, ba yijare cohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja'nca ro'tani cojën, ja'an yija yua zie yija hue'yohuë. Hue'yojënna, yure umuguseña tëca ja'nca hue'eji. ");
INSERT INTO snnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yureca Riusu ira bainguë ba'isi'quë Jeremías hue'eguëbi cocare cani jo'caguëna, bacua yo'ose'e yua ëñe'ru güina'ru baji'i: “Ja'nrëbi ba plata so'coña treinta so'coña Israel bain ro'tani bacua bainguëte ro'iye, ja'an so'coñabi inni, ");
INSERT INTO snnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","soto re'huacua yijare cohuë. Mai Ëjaguë Riusu yë'ëni ëñose'e'ru güina'ru cohuë” cani jo'case'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yureca Jesusbi romano bain ta'yejeiye ëjaguë ba'irute nëcabi. Nëcaguëna, ba ëjaguëbi coca senni achabi: —¿Më'ë yua judío bain quë'rë ta'yejeiye ëjaguë'guë? senni achabi. Senni achaguëna, Jesusbi: —Ja'nca ba'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pairi ëja bainca, ira bainca baguë gu'aye yo'ose'ere cajënna, gare sehuoye beoye baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yureca ja'nca sehuoma'iguëna, Pilatobi baguëni jëja senni achabi: —Bacuabi më'ëre aireba gu'aye cajënna, ¿më'ë guere yo'oguë achama'iguë'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Caguëna, Jesús yua gare sehuoye beoye nëcabi. Ja'nca nëcaguëna, Pilatobi gue ro'taye beoye ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yua ja'an fiesta umuguseña ba'iguëna, Pilatobi si'a tëcahuëan preso zeansi'quë bain sensi'quë te'eguëte etoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yure tëcahuë, ja'an gu'aye yo'osi'quë Barrabás hue'eguë yua preso zeansi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ja'nca ba'iguëna, bain ñë'casi'cua ba'ijënna, Pilatobi bacuani senni achabi: —¿Jaroguëni tijoni etoye señe'ne mësacua? ¿Barrabasre etoye o Jesús, ba Cristo hue'eguëte etoye señe? senni achabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pairi ëjacua yua Jesusre ro bëinjën insijënna, Pilatobi ja'anre masibi. Ja'nca masiguëbi ja'an cocare bainni senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yureca baguë jëja ñu'i seihuëte ñu'iguëna, baguë rënjobi baguëna cocare quëago raogo: —Ba re'o bainguëni gare gu'aye yo'oye beoye ba'ijë'ën. Yure ñami ai gu'a ëo caingo ëñahuë. Baguë ba'iyete ëñani ai yo'ohuë yë'ë, quëago raogo. ");
INSERT INTO snnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ja'nrëbi pairi ëjacua, judío bain ira ëjacua, bacuabi bain naconi coca cajën, Barrabasni etoye senjë'ën. Jesusni huani senjoñe senjë'ën, cajën bainni cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Cajënna, Pilatobi se'e bacuani senni achabi: —Ba samucua preso zeansi'cuare ro'tajë'ën. ¿Jaroguëni tijoni etoye'ne yë'ë? senni achabi. Senni achaguëna, bacuabi: —Barrabasni tijoni etojë'ën, cajën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ja'nca sehuojënna, Pilato yua bacuani senni achabi: —Ja'nca catoca, ¿ba Jesús, yua Cristo casi'quë, ja'anguëte guere yo'oye'ne yë'ë? senni achabi. Senni achaguëna, si'a jubëbi: —¡Crusu sa'cahuëna quenni reojë'ën! sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sehuojënna, Pilatobi se'e senni achabi: —¿Mësacua queaca ro'tajën, ja'nca caye'ne baguëre? ¿Gue gu'a jucha yo'oguë baquë'ne baguë? senni achabi. Senni achaguëna, bain jubëbi quë'rë se'e ai güijën sehuohuë: —¡Baguëte crusu sa'cahuëna quenni reojë'ën! güijën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ja'nca sehuojënna, Pilatobi se'e sehuoye porema'iñe masibi. Guerra huëoye se'ga ba'iguëna, bacuani se'e sehuoye jo'cani, ja'nrëbi ocore inni, baguë ëntë sarare zoani tonguë, bainni cabi: —Mësacuabi ënquë re'o bainguëni huani senjoñe yëtoca, mësacua se'ga yo'ojë'ën. Yë'ëca baguë huani senjoñete sehuoma'iñë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Caguëna, si'a jubë bainbi sehuohuë: —Baguëni huani senjoñe guanseguëna, yëquëna, yëquëna zin hua'na yuta raima'icuabi baguëre huani senjoñete Riusuni sehuoja'cua'ë, cajën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ja'nca sehuojënna, Pilatobi Barrabasni tijoni etoni, ja'nrëbi Jesusre si'nseni, huani senjoñe guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Guanseguëna, Pilato soldado hua'nabi Jesusre Pilato huë'e yijana sani, bacua soldado gajecua, si'a jubëre choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Choijënna, bacuabi sani, baguë cañate rutani, ja'nrëbi bajacu can ëja bain canre inni, baguëna sayahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sayani, miu ma ga'huare tëonni, baguë sinjobëna tëohuë. Ëja bain guanse tëcabëre'ga inni, baguë jëja ëntë sarana zean güesehuë. Ja'nca yo'oni, ja'nrëbi baguëna gugurini, baguëni ai jayajën cahuë: —¡Carajeiye beoye huajëni ba'ijë'ën, judío bain quë'rë ta'yejeiye ëjaguë! jayajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ja'nca jayani ja'nrëbi, baguëna go tutuni, ja'nrëbi baguë jëja tëcabëbi rutani, baguë sinjobëna huaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja'nrëbi, baguëni jayani tëjini, baguë bajacu canre rutani, baguë cañate baguëna sayani ja'nrëbi, Baguëte crusu sa'cahuëna quenni reoñu cajën sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sani, ja'nrëbi Cirene bainguë Simón hue'eguëni tëhuoni rantoni, Jesús crusu sa'cahuëte cuanni tëoni sajë'ën cajën guansehuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Guanseni ja'nrëbi, Jesusre sani, Gólgota casiru, sinjo gu'anbë casiru, ja'an cubëna ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ti'anni, gu'a jo'cha sënje naconi ja'mese'ere inni, Jesusni rurajënna, baguë yua ro ne'neni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ja'nrëbi, baguëte crusu sa'cahuëna quenni reoni, soldado hua'nabi, Baguë cañate inni baja'cuare masiñu cajën, gata toyasira'carëanre sa'ñeña ña'goni tonni ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ja'nca ëñani, ja'nrëbi bëani, baguë ba'iyete re'oye ëñañu cajën yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ja'nrëbi, baguë gu'a jucha yo'ose'ere ro'tani, ën cocare toyani, ba crusuna së'ohuë: “Ënquë Jesús hue'eguë yua judío bain quë'rë ta'yejeiye ëjaguë'bi ba'iji” toyani së'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yequëcuare'ga bain huani bonse jiancua samucuare, ja'ancuare'ga Jesús naconi bacua crusu sa'cahuëanna gueonni retohuë. Yequëre Jesús jëja ca'ncona reohuë. Yequëre Jesús ari ca'ncona reohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ja'nrëbi, bain hua'na ca'ncorë ganijën saicuabi Jesusni bëinsi ziaña ëñajën, baguëni bain ëyëjën ");
INSERT INTO snnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","cahuë: —Më'ëbi ro ro'tani caguë ba'isi'quë'ë. Riusu uja huë'ere taonni si'ani, ja'nrëbi samute umuguseña mame huë'e yo'oyë yë'ë casi'quë sëani, yurera'rë ja'ansi'quë jëajë'ën. Më'ë yua Riusu Zin ba'itoca, crusu sa'cahuëbi gajejë'ën, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ja'nca bëinjënna, pairi ëjacua'ga, ira coca ye'yocua, ira ëja bain, bacua naconi Jesusni jayajën, sa'ñeña cahuë: ");
INSERT INTO snnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Yequëcuabi ai yo'ojënna, bacua jëayete ëñoguë baji'i baguë. Ja'nca ëñoguëta'an, ja'ansi'quëbi jëaye poremai'te baguë. Baguë yua Israel bain quë'rë ta'yejeiye ëjaguë banica, yurera'rë baguë crusu sa'cahuëbi tijini gajeja'guë. Tijini gajetoca, baguëni si'a recoyo ro'tayë mai. ");
INSERT INTO snnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Baguë yua Riusuni si'a recoyo ro'tayë yë'ë caguëna, Riusubi yurera'rë baguëte tëani conja'guë. Yë'ë yua Riusu Zinreba'ë casi'quë sëani, ja'nca yo'oja'guë Riusu, baguëni ai yëguë ba'itoca, baguëni jayajën, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cajënna, jiancua'ga, baguë naconi retosi'cua, bacua'ga baguëni güina'ru te'e jayajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ja'nrëbi mëñereba së'iguëna, si'a re'oto beoru na'i si'abi. Samute hora ba'iye tëca zijei re'oto se'ga baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ba'iguëna, ja'nrëbi, ënsëguëbi a las tres'ru së'iguëna, Jesusbi si'a jëja coca güini achobi: —Elí, Elí ¿lama sabactani? güini achobi. Bain cocabi cato, Taita Riusu, Taita Riusu, ¿më'ë queaca ro'taguë, yë'ëre jo'cani senjoguë'ne? güini achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Güini achoguëna, yequëcua baru ba'icuabi achani: —Mai ira bainguë ba'isi'quë Elíasni choi'te baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cani, bacua jubë ba'iguëbi besa sani, can së'ohuëre inni, zoa huansoyo na'miñona huenni, sënje jo'cha re'cona huahuani saënni, Jesusbi zu'nzuja'guë caguë, baguë yi'obona nëcoguëna, ");
INSERT INTO snnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","baguë gajecuabi cahuë: —Yo'oma'ijë'ën. Yequërë Elíasbi rani, baguëte tijoni gachoma'iguë cajën, ëjoni ëñañu, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cajënna, ja'nrëbi Jesús yua se'e ai jëja güini achoni, ja'nrëbi junni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Junni tonguëna, ja'ansirën Riusu uja huë'e sa'nahuë retosi canbi samu të'ntëña ba'iye ja'anse'e yua jobora ye'reni saji'i. Ëmëje'enbi yijacua tëca ye'reni saji'i. Yija'ga ñu'cueguëna, gatabëanbi joni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bain tansiruan'ga a'nqueguëna, Riusu bainreba junni tonni tansi'cuani huajë hua'nare etobi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Etoguëna, Jesús go'ya rairën ti'anguëna, bacuabi bacua tansiruanbi etani, Jerusalén huë'e jobo Riusu cuencuesi jobona sani ba'ijënna, ai jai jubë bainbi ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja'nrëbi soldado ëjaguë, baguë naconi ba'ijën Jesusre ëñajën ba'icua, bacuabi yija ñu'cuese'e, yequë yo'oguë ba'ise'ere'ga ëñani, gue ro'taye beoye quëquëni cahuë: —Aito. Ënquëbi Riusu Zinreba baji'i, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Romi hua'na'ga so'orëbi ëñajën nëcahuë. Jesús naconi Galilea yijabi te'e raijën, baguëni consi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ja'nca ba'icuare cato, yeco María Magdalena, yeco María, Santiago, José bacua mamá baco'ë. Yeco, Zebedeo mamacua, bacua mamá baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ja'nrëbi, na'i si'aguëna, Arimatea huë'e jobo bainguë José hue'eguë, ai bonse baguë, ja'anguëbi ti'anbi. Baguë'ga Jesús bainguë consi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ja'anguëbi yua Pilatona sani, Jesús ga'nihuëte senji'i. Senguëna, Pilatobi baguëna insini saoye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Guanseguëna, Josebi Jesús ga'nihuëte sani, re'o can pojei canbi ga'nebi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ga'neni ja'nrëbi. José tanja'ru, gata të'ntëbana mame no'asi goje, ja'anruna sani, baguëte uanbi. Ja'nca uanni, jai gatabëbi bonani, ba tansi gojere taunni ta'pini jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ja'nca yo'oguëna, María Magdalena, yeco María naconi baë'ë. Jesús tansiru ca'ncorëte ëñajën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ja'nrëbi yequë umuguse, yo'o yo'oma'i umuguse ja'anrë ba'i umuguse si'aguëna, pairi ëjacuabi, fariseo bain naconi Pilatona sani, ");
INSERT INTO snnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","si'a jubëbi baguëni quëahuë: —Ëjaguë, ba Cristo ro coqueguë casi'quëbi yua huajëguë ba'i umuguseña ñaca caguë baji'i: “Samute umuguseña bani, go'ya raija'guë'ë yë'ë” caguëna, baguë case'ere yure ro'tahuë yëquëna. ");
INSERT INTO snnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ja'nca casi'quë ba'iguëna, yure samute umuguseña tëca ba'iguëna, baguë tansirute re'oye ëñajën cuiraye guansejë'ën. Yequërë baguëte conjën ba'isi'cuabi baguë ga'nihuëte jianni satoca, “Go'ya raisi'quë'bi” quëani achoma'iñe. Ja'nca ro coquejën yo'otoca, baguë Cristo ba'iye ro coqueguë case'e'ru quë'rë ai gu'aye coquejën ba'ire'ahuë maire, Pilatoni cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Cajënna, Pilatobi sehuobi: —Mësacua yua soldado jubëte bacua sëani, ja'ancuare baguëre tansiruna sani nëconi, mësacua porese'e ai re'oye ëñajën cuirajën ba'ijë'ën, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ja'nca caguëna, bacua yua baguëre tansiruna sani, ba gatabë ta'pisibëte quëonni së'queni jo'cahuë. Jo'cani, soldado hua'na tansiruna jo'cahuë. Ja'nca yo'ojënna, jiancuabi ti'añe poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ja'nrëbi, judío bain yo'o yo'oma'i umuguse si'aguëna, semana ja'anrë ba'i umuguse, domingo umugusebi ñatani, María Magdalenabi, yeco María naconi Jesús tansiruna ëñajën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sani ëñato, yija ai jëja ñu'cuebi. Riusu anje conguëbi guënamë re'otobi gaje meni, ba gatabëte bonani quëñoni, babëre bëani ñuji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anje ga'nihuë ba'iyete cato, mëjo jue'neñe'ru ëñobi. Baguë caña yua ai pojeiyereba ai pojei cañara baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ja'nca ba'iguëbi gaje raiguëna, soldado hua'na tansirute ëñacuabi ai quëquëreba quëquëjën to'ntojën, ja'nrëbi junni garasi'cua'ru nëcajën ëñohuë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ja'nrëbi, Riusu anje conguëbi ba romi hua'nani cabi: —Mësacua huaji yëma'ijë'ën. Mësacua yua Jesús, ba quenni reosi'quë, ja'anguëni cu'ejën raisi'cuare masiyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ënjo'on'ga beoji baguë. Go'ya raji'i. Baguë cani jo'case'e'ru güina'ru ba'iji. Raijë'ën. Baguë uinsirute ëña rani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yureca besa sani, baguëte concuani quëajaijë'ën: Ju'insi'quëbi go'ya raji'i baguë. Go'ya raisi'quëbi yureca Galilea yijana mësacua ru'ru sani, mësacuani ëjoji. Ja'anruna sani, baguëni tëhuoni ëñajë'ën. Ja'anre quëajaijë'ën. Yë'ë case'e'ru yo'ojë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Caguëna, bacuabi ba tansirute jo'cani, besa saë'ë. Huaji yëjën, ja'nrëbi ai bojoyereba bojojën, Jesusre concuana quëajaiñu cajën, huë'huëjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ja'nca saijënna, yureca Jesusbi bacuani tëhuoni saludabi. Saludaguëna, baguë guëoñare gugurini su'ncajën, baguëni ai bojojën baguëni ai yëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ja'nca yo'ojënna, Jesús yua bacuani yihuoguë cabi: —Mësacua huaji yëma'ijë'ën. Yë'ë bainrebana sani quëajë'ën: “Galilea, yijana saijë'ën. Sani yë'ëre tëhuoni ëñaja'cua'ë” quëajë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Caguëna, romi hua'nabi quëajën saijënna, ba soldado jubë ba'icuabi huë'e jobona sani, pairi ëjacuani ba yo'oguë ba'ise'e si'aye quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Quëajënna, pairi ëjacuabi si'a ira ëjacua naconi ñë'cani, sa'ñeña coca cani, ja'nrëbi soldado hua'nana ai curire insijën, ");
INSERT INTO snnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bacuani yahue yihuojën guansehuë: —Mësacua yua bainna sani, ñaca quëajë'ën: “Yëquënabi cainjënna, baguëre concuabi ñamibi ti'anni, baguë ga'nihuëte jianni samate” cajën quëajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ja'nca quëajënna, Pilatobi achatoca, yëquënabi baguëni re'o coca cajën, baguëni bojo güeseyë. Ja'nrëbi mësacuani bëiñe beoye ba'iji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ja'nca cajënna, soldado hua'nabi bacua curire coni, pairi ëja bain guansese'ere'ru coca quëani achohuë. Quëani achojënna, yure umuguseña tëca judío bainbi ja'an cocare sa'ñeña quëani achojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ja'nrëbi, Jesusre concua, si'a sara bain te'e bainguë, bacuabi Galilea yijana sani, Jesús quëasi cubëna më'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mëni, ja'nrëbi baguëni ëñani, baguëna gugurini rëanni, baguëni ai yëjën bojohuë. Bacua jubë ba'icua yequëcuaca baguëni si'a recoyo ro'taye huaji yëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ja'nca ba'ijënna, Jesusbi bacuana cueonni quëabi: —Taita Riusubi cuencueguëna, guënamë re'oto, yija re'oto, si'aye bani, Ta'yejeiyereba Ëjaguë ba'iguëbi si'aye baru ba'icuani guanseguë ba'iguë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ja'nca sëani, mësacua yua si'a jubëan bainna sani, yë'ë bainreba concuare re'huajë'ën. Ja'nca re'huajën, Taita Riusu, baguë Zin, baguë Espíritu, ja'ancua ba'iyete ro'tajën, yë'ë bainrebare oco bautizajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ja'nca yo'oni, yë'ë yua mësacuani guanseni jo'case'e'ru si'aye güina'ru ye'yojën ba'ijë'ën, bacua te'e ruiñe yo'ojën ba'ija'yete. Ja'nca ba'ijënna, yureca, mësacuare gare jo'caye beoye ba'iguë, ën yija carajeirën tëca mësacua naconi te'e conguë ba'iyë yë'ë. Ja'nca raë'ë. Amén.");
INSERT INTO snnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yureca, Riusu cocarebare, baguë Zin Jesucristo ën yijana raise'ere toyani jo'cayë: ");
INSERT INTO snnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Riusu ira bainguë raosi'quë, Isaías hue'eguëbi Riusu cocare uti pëbëna toyani jo'caguëna, ñaca toyase'e baji'i: Achajë'ën, yureca. Më'ëre quëaja'guëte ru'ru saohuë, më'ë rai ma'are re'huacaiguëte. ");
INSERT INTO snnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Saoguëna, ja'anguëbi yua beo re'otona ti'anni, ñaca quëani achoja'guë'bi: “Mai Ëjaguë rai ma'are re'huaye'ru re'huajë'ën. Te'e ruin ma'are yo'ocaijë'ën baguëre” toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ja'nca ba'iguëna, yureca Juan Bautizaguëbi beo re'otona ti'anni, bainna ñaca quëani achobi: “Mësacua ro'tajën ba'ise'e beoru mame re'huani ba'ijën, bautiza güesejë'ën. Riusubi yë'ë gu'a jucha yo'oguë ba'ise'ere huanë yeni ro'tama'ija'guë cajën, ja'nca yo'ojë'ën” quëani achoguë baji'i Juan. ");
INSERT INTO snnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ja'nca quëani achoguëna, si'a bainbi baguëni achajaiñu cajën, baguëni tëhuojaë'ë. Judea yija, Jerusalén huë'e jobo, ja'anruanbi etani, baguëni tëhuojaë'ë. Tëhuojani, bacua gu'a jucha beorure Riusuni quëajën, Juanni bautiza güesehuë, Jordán ziayana. ");
INSERT INTO snnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yureca, Juanbi yua camello raña canre ju'iguë, ga'ni tëinme baguë sëri seihuëte tënji'i. Bu'nsu, o'a baya, baguë aon ja'an baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ja'nca ba'iguëbi yua bainni ñaca quëani achoguë baji'i: —Yequëbi, yë'ë'ru quë'rë ta'yejeiye Ëjaguëbi yuareba raiye ba'iji. Yë'ë'ru quë'rë ta'yejeiye Ëjaguëte sëani, yë'ë'ga gugurini rëanni, baguëni yo'o coñe gare ti'anma'iguë ba'iyë. Baguë guëon ju'iyete ti'jeye ti'anma'iguë'ë yë'ë, baguëre. ");
INSERT INTO snnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yë'ëbi yua mësacuare ocona bautizaguë'ë. Baguëca yua Riusu Espíritu naconi mësacuare bautizaja'guë'bi, quëani achoguë baji'i Juan. ");
INSERT INTO snnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Quëani achoguë ba'iguëna, ja'an umuguseñabi Jesusbi Nazaret huë'e jobo, Galilea yija ba'i jobo, ja'an jobobi sani, Juanna ti'anjani, Jordán ziayana bautiza güesebi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bautiza güeseni, ja'nrëbi, guënamë re'otobi a'nqueni saoguëna, Riusu Espíritubi eta rani, ju'ncubo ba'iye'ru ëñoni, Jesusna gaje meni tuabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tuaguëna, ja'nrëbi, guënamë re'otobi ñaca cani achobi: —Më'ë yua yë'ë Zin ai yësi'quë'ë. Më'ëni ai bojoyë yë'ë, cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cani achoguëna, ja'ansirën, Riusu Espíritubi Jesusre beo re'otona sabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Saguëna, cuarenta umuguseña barute ba'iguë, airu hua'i hua'na naconi ba'iguëna, zupai huatibi ti'an rani, Yë'ëna rani conjë'ën, coqueguë choji'i. Choquëna, conmaji'i. Conma'iguëna, Riusu guënamë re'oto yo'o con hua'nabi baguëni cuirahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ja'nrëbi jë'te, Juanni preso zeanni guaorena, Jesusbi Galilea yijana sani, Riusu cocarebare bainni quëani acho bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ñaca quëani achoguë baji'i: —Yua'ë. Riusu ba'i jobo ëñoja'ñe yurera ti'anja'ñeta'an ba'iji. Ja'nca sëani, mësacua ro'tajën ba'ise'e beoru mame re'huani, Riusu cocarebare achani, si'a recoñoa ro'tajën ba'ijë'ën, quëani achoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ja'nca ba'iguëbi Galilea zitara yëruhuana sani, mejabëbi ganini ëñato, Simón hue'eguëbi, baguë yo'jeguë Andrés naconi ba'ijën, hua'ire yojën baë'ë, hua'i yoye ye'yesi'cua sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hua'ire yojënna, Jesusbi bacuani coca caguë choji'i: —Mësacua yë'ëni te'e conjën raijë'ën. Mësacua yua hua'i yoye ye'yesi'cua ba'ijënna, bainre yoye mësacuani ye'yoyë yë'ë, caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Caguë choiguëna, bacua yua ja'ansirën bacua hua'i yorëanre gare jo'cani, Jesusni te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Saijënna, baguëbi se'erë sani ëñato, Zebedeo mamacua, Santiago hue'eguë, baguë yo'jeguë Juan naconi baë'ë. Bacua pë'caguë Zebedeo naconi yogute ba'ijën, bacua hua'i yorëanre ta'nëjën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ja'nca ñu'ijënna, Jesusbi bacuani choji'i. Choiguëna, bacuabi yua bacua pë'caguë Zebedeore jo'cani saë'ë. Yo'o concua naconi yoguna jo'cani, Jesusni te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sani ja'nrëbi, Capernaum huë'e jobona ti'anhuë. Ti'anrena, ja'nrëbi, yo'o yo'oma'i umuguse ba'iguëna, Jesusbi bain ñë'ca huë'ena cacani, bainni coca ye'yo bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ai ta'yejeiye Ëjaguë masiye ye'yoye'ru bacuani ye'yoguëna, bain hua'nabi ai achajën rën'ë. Bacua ira coca ye'yocua ye'yoye'ru quë'rë ta'yejeiyera ye'yoguë baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ye'yoguë ba'iguëna, yequë bainguë gu'a huati cacasi'quë yua bacua ñë'ca huë'ere baji'i. Ja'nca ba'iguëbi yua te'e jëana güiguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Yëquëna ba'iru queaca ro'taguë raquë'ne Jesús Nazareno? Yëquënani ro huesoni si'aguë raisi'quë'ë më'ë. Më'ëre masiyë yë'ë. Më'ë yua Riusu Zin Raosi'quëreba ba'iguë'ë, güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Güiguë caguëna, Jesusbi gu'a huatini bëinguë guanseni cabi: —¡Cama'ijë'ën, huati! ¡Ba bainguëte etani saijë'ën! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ja'nca caguëna, huatibi ba bainguëte ai jëja hue'nhue yo'oni, ai jëja güiguë, bainguëte etani jo'cani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Etani saiguëna, si'a bain hua'nabi quëquësi'cua ba'ijën, sa'ñeña senni achajën cahuë: —¿Gue'ne, yureca? ¿Guerebare ye'yoguë'ne baguë? ¡Ai masi Ëjaguëbi rani, huati hua'ini coca guanseguëna, bacuabi achani yo'oyë! sa'ñeña cajën, ai ëñajën rëinjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ja'nrëbi, si'a Galilea yija ca'ncoñana Jesús yo'ose'ere ai quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ja'nrëbi, ba ñë'ca huë'ebi etajënna, Jesusbi Simón, Andrés, bacua naconi bacua huë'ena sani cacabi. Santiago, Juan, bacuabi conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cacani ba'ijënna, Simón huago, baguë rënjo pë'cagobi rau jayogo uingona, Jesusni quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Quëajënna, baguë yua bago uinruna cacani, bago ëntë sarare zeanni, bagote huëabi. Huëaguëna, ja'ansirën rau go'yani huajëgo, yua bacuani cuira bi'rago. ");
INSERT INTO snnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ja'nrëbi na'iguëna, yua ënsëguë ruajaquëna, rau ju'incuare, huati cacasi'cuare'ga, si'acuare Jesusna sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sani, si'a huë'e jobo bainbi ti'anni, baguë anto sa'rore ñë'cani ëjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ëjojënna, Jesús yua ai jai jubë bain si'a rau ju'incuani huachobi. Gu'a huati hua'i bain cacasi'cuare'ga guanseni, bacuare etoni saobi. Ja'nca saoni, huati hua'ibi coca caye yëjënna, ënsebi, baguëte masicuare sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja'nrëbi, ñata ñamibi, yuta ënsëguë etama'iguëna, Jesusbi huëni, bain beoruna sani, Taita Riusu naconi coca uja bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ujaguë ba'iguëna, Simón, yequëcua baguë naconi ba'icuabi Jesusni cu'ejën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sani, baguëte tinjani, baguëni cahuë: —Si'a bainbi më'ëni cu'eyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cajënna, Jesusbi sehuobi: —Cueñe ba'i huë'e joboñana saiñu. Ja'anruan bainre'ga Riusu cocarebare quëani achoza caguë, ja'an raisi'quë'ë yë'ë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ja'nca cani, si'a Galilea yija ca'ncoñana ganini, bain ñë'ca huë'eñana cacani, Riusu cocarebare bainni quëani achoguë, gu'a huati hua'ire etoni bi'rani saoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ba'iguëna, ja'nrëbi, gu'a ca'mi rau ju'inguëbi Jesusna rani, baguëna gugurini rëanni, baguëni senreba senji'i: —Më'ëbi yënica, yë'ë gu'a raure tënoni huachojë'ën, huachoye pore Ëjaguë sëani, senguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ja'nca caguëna, Jesusbi baguëni oiguë bani, baguë ëntë sarare mi'nani, baguëni pa'roguë cabi: —Huachoye yëyë. Më'ë yua huajë hua'guë ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Caguëna, ja'ansirën gu'a ca'mi rau go'yani, yua huajë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Huajë raiguëna, Jesús yua baguëte sao bi'rani, baguëni si'a jëja coca yihuoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Achajë'ën. Më'ë huajë raise'ere yequëcuani gare quëaye beoye ba'ijë'ën. Ëñe se'gare yo'ojë'ën. Më'ë pairina sani, më'ë huajë raise'ere baguëni ëñojë'ën. Ëñoni, Moisés ira coca guanseguë ba'ise'e'ru, baguë casi jo'ya hua'guëre inni, më'ë pairina sani, pairibi huani ëocaija'guë caguë, jo'ya hua'guëre pairina insijë'ën, më'ë yua huajë raisi'quë sëani. Ja'nca yo'otoca, bain hua'nabi më'ë huajë raise'ere ëñani masiyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ja'nca cani saoguëna, ba huajë raisi'quëbi ro achani, baguë huajë raise'ere si'a bainna quëani achojaji'i. Ja'nca quëani achoguëna, Jesusbi, yua bainbi ëñajënna, huë'e jobona ti'añe poremaji'i. Beo re'otoña se'gare ba'iguëna, si'aruan ba'icuabi baguëni ëñajën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ja'nrëbi, yequë umuguseña ba'iguëna, Jesús yua Capernaum huë'e jobona go'ini, baguë huë'ere ba'iguëna, bainbi achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ja'nca achani, yurera, ai jai jubë bainbi baguë huë'ena ñë'ca rani, huë'e bu'iye ba'iye sëani, anto sa'ro ba'iruna ti'añe poremaë'ë. Ja'nca ba'ijënna, Jesusbi Riusu cocarebare bacuani quëani achobi. ");
INSERT INTO snnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Quëani achoguëna, yequëcua gajese'gacuabi garasi'quëni camare uinguëna, cuanni rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rani, ai jai jubë bain ba'ijënna, Jesusna cacaye poremajën, huë'e ëmëje'ena mëani, Jesús ëmëje'en ba'irute goje otani, garasi'quëre camare uinguëna, Jesús ba'iruna meñe gachohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gachojën, Jesusbi huachoye poreji ro'tajënna, Jesusbi baguë ñacobi ëñani, bacua recoyo ro'tayete masini, ba garasi'quëni cabi: —Mami, më'ë gu'a jucha yua gare tënose'e ba'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Caguëna, ira coca ye'yocuabi achajën ñu'ijën, ja'ansi'cua bëinjën ro'tajën baë'ë: ");
INSERT INTO snnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ba hua'guë queaca ro'taguë, ja'an cocare caguë'ne? Riusu se'gabi bain juchare tënoñe poreji. Yequëcuabi porema'iñë. Ja'nca sëani, baguë yua tëno cocare caguë, Riusure ro gu'aye caji” sa'ñeña ro'tajën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ro'tajën ñu'ijënna, Jesusbi baguë ñacobi ëñani, bacua bëinjën ro'tase'ere masini, bacuani cabi: —¿Mësacua guere yo'ojën, ja'nca ro'tajën bëiñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bainbi, “Më'ë gu'a jucha yua tënose'e ba'iji” caye poreyë. Ja'nca caye porecuata'an, “Huëni, më'ë camare inni ganijë'ën” catoca, bacua huachoye porema'iñete ëñoñë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ja'nca ba'iyeta'an, yë'ë yua Riusu Raosi'quëreba ba'iguëbi bain gu'a juchare tënoñe pore Ëjaguë'ë. Ja'anre mësacuani ëñoñë yë'ë, cabi. Cani, ja'nrëbi, garasi'quëni cabi: ");
INSERT INTO snnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Yureca, huëijë'ën. Më'ë camare inni, më'ë huë'ena go'ijë'ën, caguë cayë yë'ë, cani achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Caguëna, baguë yua ja'ansirën huëni, baguë camare inni saji'i. Ja'nca saiguëna, si'a bainbi ai ëñajën rëinjën, Riusuni bojoreba bojojën, re'o cocare baguëni cahuë: —Yure yo'ose'e'ru maibi gare ëñama'isi'cua'ë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ja'nrëbi jë'te, Jesusbi se'e Galilea zitara yëruhuana saji'i. Sani, si'a bain hua'nabi baguëna ñë'cajënna, bacuare coca yihuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yihuoni tëjini, se'e sani ëñato, Alfeo mamaquë Leví hue'eguëbi impuesto curi co huë'ere ñuji'i. Ja'nca ñu'iguëna, baguëni: —Yë'ëni te'e conguë raijë'ën, caguë choji'i. Caguë choiguëna, Levibi huëni, Jesusni te'e conguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ja'nrëbi jë'te, Jesusbi baguë bain concua naconi Leví huë'ere ba'ijën, aonre ainjën ñu'ijënna, gu'a bain impuesto curi cocua naconi ai jai jubëbi Jesusni te'e conjën, aonre aën'ë. Ai jai jubë bainbi baguëni te'e conjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ba'ijënna, ira coca ye'yocua, fariseo bain naconi, bacuabi ti'anni, Jesusbi gu'a bain naconi te'e aon ainguëna, ëñahuë. Ja'nca ëñani, Jesús bain concuani bëinjën cahuë: —¿Mësacua ëjaguë guere yo'oguë, impuesto curi cocua, gu'a bain, bacua naconi aon ainguë'ne? cajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bëinjënna, Jesusbi bacua case'ere achani, bacuani coca sehuobi: —Huajëjën ba'icuabi ëco yo'oguëte senma'iñë. Rauna ju'incua se'gabi ëco yo'oguëte señë. Yë'ë re'o bainguë'ë cajën ba'itoca, ja'ancuare choiguë raimaë'ë yë'ë. Yë'ë gu'a bainguë'ë cajën ba'itoca, ja'ancuare choiguë raisi'quë'ë yë'ë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ja'nrëbi jë'te, Juanre concua, fariseo bainre concua, bacuabi aon aiñe jo'cajënna, yequëcuabi Jesusna sani, coca senni achahuë: —Juanre concua, fariseo bainre concua, bacuabi aon aiñe jo'cajënna, ¿më'ëre concua guere yo'ojën aon aiñe jo'cama'iñe'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Senni achajënna, Jesús sehuobi: —Ro huacha ro'tajën ba'iyë mësacua. Huejaja'guëbi fiestare yo'oguëna, ja'anre ro'tajën ba'ijë'ën. Huejaja'guëbi yuta ba'iguëna, baguë bain choisi'cuabi aon aiñe jo'caye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ja'nca porema'ijënna, huejaja'guëre preso zeanni quëñoja'an umuguse ti'anguëna, ja'anrën bacuabi aon aiñe jo'caja'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Cani ja'nrëbi, bacuani yeque ye'yo cocare quëabi: —Mame canbi ira canna ja'cheye bañë. Ja'nca ja'chetoca, mame canbi guë'nguëguëna, ira canbi quë'rë se'e ye'reni gu'a can'ru ruinji. ");
INSERT INTO snnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bisi ëye jo'cha huajë jo'chare yua ira ga'ni jo'cha corohuëanna ayaye bañë. Ayatoca, huajë jo'chabi ira ga'ni corohuëanre juejueni jañuni sani si'aji. Ga'ni corohuëan'ga gu'a corohuëan'ru ruinji. Huajë bisi ëye jo'cha banica, mame ga'ni jo'cha corohuëanna ayaye ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ja'nrëbi, yo'o yo'oma'i umuguse ba'iguëna, Jesusbi baguëte concua naconi trigo aon zio re'otobi ganijën, baguëre concuabi aon za'zaboanre tëa bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tëa bi'rajënna, fariseo bainbi ëñani, Jesusni bëinjën cahuë: —Ëñajë'ën. ¿Më'ëre concua guere yo'ojën, aonre tëaye'ne? Yo'o yo'oma'i umuguse sëani, mai ira coca guanseni jo'case'e'ru tin yo'oye porema'iñë, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Cajënna, Jesusbi sehuobi: —Mai ira coca toyani jo'case'ere ëñajën, ¿David yo'ose'ere cato, ja'an quë'rore mësacua ëñamate'ne? Baguëre concua naconi ganini, aon gu'aguëna, ");
INSERT INTO snnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","pairi ta'yejeiye ëjaguë Abiatar ba'isirën ba'iguëna, Davidbi Riusu huë'ena cacani, baru ba'i jo'jo aonbëan Riusuna jo'case'ere inni ainguë ba'nji. Pairi bain se'gabi aiñe porejënna, yequëcuabi aiñe porema'iñeta'an, Davidbi inni ainguë, baguëte concuare'ga aonguë ba'nji, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cani, bacuani se'e yihuoguë cabi: —Riusubi ru'ru bainguëte re'huani jo'caguë ba'nji. Ja'nrëbi yo'je, yo'o yo'oma'i umugusere re'huani jo'caguë ba'nji, bain bëa huajëyete. Yo'o yo'oma'i umugusere re'huaguë, bainni ro guanseye ro'tama'iji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ja'nca sëani, yë'ë'ga yua Riusu Raosi'quërebabi yua yo'o yo'oma'i umuguse Ëjaguë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja'nrëbi se'e, Jesusbi bain ñë'ca huë'ere ba'iguëna, guë'nguësi sara baguëbi baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ja'nca ba'iguëna, fariseo bainbi yua Jesús huachoja'ye ëñañu cajën, yahue ro'tajën ëjohuë. Guë'nguësi sara baguëte huachotoca, “Ai gu'aye yo'ohuë më'ë” cañu, ro'tajën ëjohuë, yo'o yo'oma'i umuguse sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ja'nca ro'tajën ëjojënna, Jesusbi guë'nguësi sara baguëni cabi: —Huëni raijë'ën. Bain joborana nëca raijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cani ja'nrëbi, baguëbi raiguëna, fariseo bain barute ba'icuani cabi Jesús: —Mai ira ba'isi coca toyani jo'case'ere ëñato, yo'o yo'oma'i umuguse banica, ¿gue yo'o yo'oye poreye'ne mai? ¿Guere caguë'ne? ¿Bainni coñe o bainni ja'si yo'oye caguë? ¿Rauna ju'inguëte huachoye o baguëni huesoni si'aye caguë? bacuani senni achaguë cabi. Ja'nca senni achaguëna, bacuabi gare sehuoye beoye baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ja'nca ba'ijënna, Jesusbi si'acuare bonëjeiñe ëñaguë bënji'i. Bacua achaye güejënna, ai sa'ntiguë baji'i. Ja'nca ba'iguëbi guë'nguësi sara baguëni cabi: —Më'ë ëntë sarare mi'najë'ën, cabi. Caguëna, baguë yua mi'nani, huajë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Huajë raiguëna, ja'nrëbi, fariseo bainbi etani, Herodes bainna sani, bacuani coca senni achahuë: —¿Queaca Jesusre huani senjoñe'ne mai? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ja'nrëbi, Jesús yua baguëre concua naconi etani, zitarana saë'ë. Saijënna, ai jai jubë bain Galileabi raisi'cua yua baguëni achajën be'tejaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea, Jerusalén, Idumea, Jordán ziaya que ca'ncoña, Tiro, Sidón, ja'anruan bain'ga ai jai jubëbi Jesús yo'ose'ere achani, baguëna ñë'ca raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Raijënna, baguëre concuani: “Yogute injani, yë'ëre re'huacaijë'ën” cabi. Bain jubëbi baguëni quëon ëaye ba'ijënna, ba yogute re'huacaiye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ai bainre huachosi'quë sëani, si'acua rau ju'incuabi ti'anni, baguëni pa'roni huajëñu cajën, baguëni quëon ëaye yo'ojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Gu'a huati hua'ibi yua baguëni ëñajën, baguëni gugurini rëanjën, baguëni güijën cahuë: —¡Riusu Zinreba'ë më'ë! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ja'nca cajënna, Jesusbi bacuani si'a jëja guanseguë, Yë'ë ba'iyete quëani achoma'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ja'nrëbi yo'je, Jesusbi cubëna mëni ba'iguë, baguë bain jia'noni cuencueja'cuare choji'i. Choiguëna, baguëna mëni ñë'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ñë'cajënna, si'a sara samucuare, baguë naconi conjën ba'icuare, Riusu cocareba quëani achocuare, ja'ancuare jia'noni cuencuebi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Cuencueni, ju'incuare huacho ëjacua, gu'a huati hua'ire etoni sao ëjacua, ja'ancuare bacuare cuencueni re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ba cuencueni re'huasi'cua yua ñaca hue'ecua baë'ë: Simón caguëni Pedro hue'yobi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ja'nrëbi Santiago, ja'nrëbi Santiago yo'jeguë Juan, Zebedeo mamacua ba'ijënna, jëja bacuare sëani, Boanerges hue'yobi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ja'nrëbi Andrés, ja'nrëbi Felipe, ja'nrëbi Bartolomé, ja'nrëbi Mateo, ja'nrëbi Tomás, ja'nrëbi Alfeo mamaquë Santiago, ja'nrëbi Tadeo, ja'nrëbi Simón ja'an celote jubë ba'iguë, ");
INSERT INTO snnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja'nrëbi Judas Iscariote, Jesusre je'o bacuana insini senjoja'guë, ja'ancuare cuencueni re'huabi Jesús. Ja'nrëbi jë'te, Jesusbi baguëre concua naconi yequë huë'ena sani ti'anni, ");
INSERT INTO snnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ai jai jubë bainbi ñë'ca raijënna, bacua aon aiñe'ga poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ja'nca porema'ijënna, yequëcuabi, Loco hua'guë'ru ruinguë ba'iji baguë cajënna, Jesús te'e huë'e bainbi achani, Baguëte zeanni rañu cajën, baguëte zeanjën saimate. ");
INSERT INTO snnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yequëcua'ga ira coca ye'yocua, Jerusalenbi raisi'cuabi baguëte gu'aye cahuë: —Baguë yua gu'a huati ëjaguë Beelzebú hue'eguë, ja'anguë naconi zemosi'quë'bi ba'iji. Ja'nca sëani, Beelzebubi conguëna, gu'a huati hua'ire etoni saoye poreji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Cajënna, ja'nrëbi, Jesús yua bacuare choini, ye'yo cocabi bacuare bëinguë yihuoguë quëabi: —¿Mësacua yua zupai huatire concua sa'ñeña etoni saoye poreye ro'taye? Ja'nca yo'oma'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te'e jobo bainbi sa'ñeña huatoca, si'acuabi huesëni carajeiyë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te'e huë'e bainbi sa'ñeña huatoca, si'acuabi huesëni carajeiyë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ja'nca carajeijënna, güina'ru zupai huatire concuabi sa'ñeña huatoca, bacua'ga huesëni carajeiyë. Zupai'ga huesëni carajeiji. ");
INSERT INTO snnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yequëcuabi jëja baguë huë'ena jian cacaye yëtoca, ru'ru jëja baguëni preso hueñe bayë. Baguëte preso huenma'itoca, baguë bonsere jiañe porema'iñë. Huentoca, baguë bonsere tëani saye poreyë. Güina'ru, Zupaini huentoca, baguë zeansi'cuare tëani saye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mësacuani ganreba yihuoguë cani achoyë yë'ë. Si'a bain gu'a jucha yo'ojën ba'ise'e, bacua gu'aye cani tonse'e, ja'anre huanë yeye poreji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ja'nca huanë yeye poreto'ga, Riusu Espíritute gu'aye cani tontoca, ja'an gu'a juchare gare huanë yeye beoye ba'iji Riusu. Ja'an gu'a juchare gare tënoñe beoye ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bainbi Gu'a huati zemosi'quëbi ba'iji cajënna, ja'nca coca yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ja'nrëbi jë'te, Jesús pë'cago, baguë yo'jecua, bacuabi ti'an rani, hue'se ca'ncore ëjojën, baguëte choijaijë'ën cani raohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Raojënna, bain hua'na Jesús të'ijeiye ñu'icuabi baguëni quëahuë: —Më'ë mamá, më'ë yo'jecua, bacuabi hue'se ca'ncore ëjojën, më'ëni choiyë, quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Quëajënna, Jesús sehuobi: —¿Yë'ë mamá, yë'ë yo'jecua, jarocua'ne? senni achaguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ja'nca sehuoni ja'nrëbi, si'acuani bonëjeiñe ëñani, bacuani se'e cabi: —Yë'ë mamá, yë'ë yo'jecua yua ënjo'on ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Riusu yëyete yo'ojën ba'icua, ja'ancuani, Yë'ë yo'jeguë, yë'ë yo'jego, yë'ë mamá, ja'anre bacuani cayë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ja'nrëbi jë'te, Jesusbi zitara yëruhuate ba'iguë, bainni coca yihuo bi'raguëna, ai jai jubë bainbi ñë'ca raë'ë. Ai jai jubë bain sëani, Jesús yua yoguna cacani bëaguëna, bain jubëbi mejabë yëruhuate achajën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Achajën ñu'ijënna, Jesusbi ye'yo cocabi bacuani ai yihuoguë quëabi: ");
INSERT INTO snnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Mësacua achajë'ën. Bainguëbi zio yo'oguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sani, yijare re'oye re'huani tëjini, aonra'carëanre mo'gasi yijana yu'yuguë ganibi. Yu'yuguë ganiguëna, yequëra'carëanbi ma'ana to'inguëna, bi'an hua'nabi chiani uncueni si'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yequëra'carëanbi gata yijana to'inguëna, bean yija ba'iguëna, ai besa ticubi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ja'nca ticuguëna, ja'nrëbi, ai ja'suye ënsëguëna, sita beo sahua sëani, ticubi cueneni junji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yequëra'carëanbi miubëna to'inguëna, miubi quë'rë ta'yejeiye irani hueanguëna, aon quëinmaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yequëra'carëanbi yua re'oye re'huasi yijana to'inguëna, aonbi irani, jorini, re'oye quënji'i. Quëinguëbi yequë sahuañabi treintara'carëan quënji'i. Yequë sahuañabi sesentara'carëan quënji'i. Yequë sahuañabi cienra'carëan quënji'i, caguë yihuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yihuoni ja'nrëbi, bacuani se'e cabi: —Mësacuabi ganjo banica, achani ye'yejë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ja'nrëbi jë'te, Jesusbi te'e hua'guë ba'iguëna, baguëre concua si'a sara samucuabi, yequëcua baru ba'icua, bacuabi yua Jesús ye'yo coca te'e ruiñe quëayete senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Senni achajënna, Jesús sehuobi: —Riusubi baguë ba'i jobo ba'iyete mësacuani te'e ruiñe quëani, baru ba'i yahuese'ere mësacuani te'e ruiñe masi güeseji. Yequëcuareta'an, banji. Baguë bain jubë beocuare sëani, ye'yo coca se'gabi bacuani beoru quëani achoyë, ñaca toyani jo'case'e'ru ba'ija'ye: ");
INSERT INTO snnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ñaco bacuata'an, ëñani ye'yema'ija'bë caguë, ganjo bacuata'an, achani ye'yema'ija'bë caguë, bacua gu'a jucha yo'ojën ba'ise'e yua mame re'huama'ija'bë caguë, ye'yo coca se'gabi bacuani quëaji Riusu, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Caguë sehuoni, ja'nrëbi ba ye'yo cocare bacuani te'e ruiñe quëabi: —¿Mësacua yua yë'ë ye'yo coca case'ere achamate? Ja'nca achama'itoca, ¿mësacua yua si'a ye'yo cocare queaca achaye poreye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aonra'carëan yu'yusi'quë yua Riusu cocareba quëani achoguë'ru ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Quëani achoguëna, yequëcuabi achajën, aonra'carëan ma'ana to'inse'e'ru ba'iyë. Riusu cocarebare achajënna, ja'nrëbi jë'te, zupai huatibi rani, ba cocareba bacua recoñoana re'huase'ere quë'ñeni si'aji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yequëcuabi achajën, aonra'carëan gata yijana to'inse'e'ru ba'iyë. Riusu cocarebare achani bojojën, ");
INSERT INTO snnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","sita saima'iñe'ru ba'ijën, ja'nji recoñoa bacuabi zoe beoye recoyo ro'tama'iñë. Yequëcuabi je'o ëñajën, hui'ya yo'ojënna, bacua yua Riusu cocareba ro'ire ai yo'ojën, ba cocare recoyo ro'taye jo'cayë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yequëcuabi achajën, aonra'carëan miubëna to'inse'e'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Riusu cocarebare achajën ba'icuata'an, ën yija bonsere ba ëaye ro'tajën, ro coquesi'cua ruiñë. Bonse se'ga si'ayete bani bojoza ro'tajën, aonra'carëan huenni si'ase'e'ru Riusu cocarebare recoyo ro'taye gare jo'cayë. Ja'nca jo'cajën, re'o yo'o yo'oye ëñomajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yequëcuabi achajën, aonra'carëan re'oye re'huasi yijana to'inse'e'ru ba'iyë. Riusu cocarebare achani, recoyona re'huani, re'o yo'o yo'oye ai ta'yejeiye ëñojën ba'iyë. Yequëcua yua treintara'carëan quëiñe'ru ba'iyë. Yequëcua yua sesentara'carëan quëiñe'ru ba'iyë. Yequëcua yua cienra'carëan quëiñe'ru ba'iyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cani ja'nrëbi, yeque cocare bacuani yihuoguë cabi: —Majahuëte zëonto, ¿ro gajongu sa'nahuëna meñe jaoni ta'piye? ¿o cama yijacuana nëcoye? Bañë. Si'aruanna miaja'guë cajën, ëmëna reoyë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ja'nca ba'iye'ru ba'iguëna, bainbi bacua gu'a jucha yo'ojën ba'ise'ere yahueye yëcuareta'an, Riusubi si'aye ëñoni, si'acuani masi güeseji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mësacua yua ganjo banica, achani ye'yejë'ën, yihuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Cani ja'nrëbi, yeque cocare bacuani yihuoguë cabi: —Mësacua yua ye'yo cocare ëñare bajën, achajën ba'ijë'ën. Mësacua yua bainna cuencueni insijën ba'iye'ru, Riusubi güina'ru mësacuana cuencueni inisji. Mësacua yua baguë cocarebare te'e ruiñe achajën ba'itoca, mësacuana quë'rë se'e ai ta'yejeiye insireba insiji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mësacuabi ai batoca, quë'rë ta'yejeiye mësacuana insise'e ba'ija'guë'bi. Ai ba'iye beotoca, mësacua baye choa ma'carë se'ga batoca, beoru quë'ñeni tëase'e ba'ija'guë'bi, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Cani ja'nrëbi, yeque cocare bacuani yihuoguë cani achobi: —¿Riusu ba'i jobo queaca ba'iguë'ne? Aonra'carë yijana tanse'e'ru ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bainguëbi yijana tanni, ja'nrëbi yequë umuguseña canni ñataguëna, aonra'carëbi ticuni iraji. ¿Queaca jojoni ticuguë'ne? sento, huesëji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yijana tanse'e yua ja'anse'ebi jojoni iraji. Ru'ru, ticu se'gabi jojoni irani, ja'nrëbi aon za'zabo quëinji. Quënni, ja'nrëbi yo'je, za'zabobi yayuni ya'jiji. ");
INSERT INTO snnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya'jiguëna, aon tëa umuguse ti'anguëna, aonre tëajën saiyë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cani ja'nrëbi, yeque cocare bacuani yihuoguë cani achobi: —¿Riusu ba'i jobo queaca ba'iguë'ne? ¿Que ye'yo cocare quëaye'ne? ");
INSERT INTO snnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostazara'carë ai zinra'carë, ja'an'ru ba'iji. Si'ara'carëan'ru quë'rë zinra'carë ba'iguëta'an, ");
INSERT INTO snnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","yijana tanse'ebi irani yua si'a sunquiñëa'ru quë'rë jai sunquiñë irani, jai cabëan quënquëna, bi'an hua'nabi ba sunquiñë sësëyena ziaroan suani, bëa huajëye poreyë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja'nca ye'yoguë, ye'yo coca se'gare ye'yoguë, Riusu cocarebare bainni ye'yoguë, bacua achaye porese'e'ru yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bainre ye'yoguë, ye'yo coca se'gare quëabi. Baguëre concuare ye'yoguë, si'aye te'e ruiñera quëani yihuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yihuoni, ja'nrëbi na'iguëna, baguëre concuani: —Zitara que të'huina je'eñu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Caguëna, bacuabi bain jubëte jo'cani, Jesusre, ba yogute ñu'iguëna, sahuë. Yequë bainbi bacua yoguanbi te'e conni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jesusre sajënna, ja'nrëbi ai jëja tutu raguëna, të'a yua huëni, oco yua yoguna cacaguëna, oco bu'i bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ja'nca ba'iguëna, Jesús yua yogu sëri seihuëte ba'iguë, sinjo tëobëna tëoni cainguë unji'i. Cainguëna, baguëte sëtoni cahuë: —¡Ëjaguë! ¿Më'ë guere yo'oguë, mai huesëni si'ayete ëñama'iguë'ne? huaji yëjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Cajënna, Jesusbi sëta rani, huëni, tutu can jëjoni saoni, zitarana guanseguë cabi: —¡Ja'anse'e guajë'ën! ¡Ja'anse'e carajeijë'ën! cabi. Caguëna, tutu'ga, zitara'ga, ja'anse'ebi carajaji'i. Gue tutuye beoye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ja'nca ba'iguëna, Jesusbi baguëre concuani cabi: —¿Mësacua guere yo'ojën, yë'ëni si'a recoyo ro'tamajën, ro quëquëjën ba'iye'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Caguëna, ba hua'nabi ai huaji yëjën, ai ëñajën rëinjën, sa'ñeña cahuë: —¿Yua queaca ba'iguë'ne ba hua'guë? Baguëbi guanseguëna, tutu'ga, jai zitara'ga, ja'anse'ebi achani, Jaë'ë cani carajaji'i, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ja'nrëbi, zitarate je'enni, Gerasa yijana ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ti'anni, Jesusbi mëi bi'raguëna, yua gu'a huati cacasi'quëbi bain tansi re'ohuëbi etani, tëhuo raji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja'anguë yua bain tansi re'ohuëte ba'iguëna, yequëcuabi que maca'ga, guëname'ga baguëni preso zeanni tayoñu cajën yo'ocuata'an, jëja beohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Baguëni preso zeansi'cuabi guënameñabi baguë guëoña, baguë ëntë saraña, baguëni ai re'oye huento'ga, baguë yua ro tëteni si'aye se'ga yo'oguë baji'i. Ja'ansi'quë yua baguë ëntë sarañabi ra'nteni tëteni, ja'nrëbi gatabi hua'huani guënameare jë'yeni si'aguë baji'i. Ja'nca ba'iguëna, baguëni zeanni hueñe porecuabi beohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Baguë yua umugusebi, ñamibi bain tansirute ba'iguë, cu re'otore ba'iguë, si'a jëja güiguë, gatabi ja'ansi'quë huaiguë, ja'si yo'oguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ja'nca ba'iguëbi Jesusni, so'orëbi raiguëna, ëñani, baguëna ai jëja huë'huëni tëhuoni, baguëna gugurini rëanni, ");
INSERT INTO snnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","baguëni cabi: —¿Më'ë guere ro'taguë, yë'ë ba'iruna raquë'ne, Jesús? Më'ë yua ba ta'yejeiyereba Ëjaguë Riusu Zin'ë. Riusubi ëñaguëna, më'ëni senreba señë yë'ë: Yë'ëni ai yo'o güesema'ijë'ën, señë, güiguë cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesús yua ën coca: —Etani saijë'ën, gu'aye yo'o huati, ja'anre casi'quë sëani, ai jëja güiguë cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Caguëna, Jesusbi baguëni senni achabi: —¿Më'ë gue mami hue'eguë'ne? senni achabi. Senni achaguëna: —Jai Jubë hue'eyë, jai jubë huati hua'i ba'icua sëani, sehuobi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sehuoni ja'nrëbi, Jesusni senreba senji'i: —Yëquëna huati jubëte ën yijabi gare etoni saoma'ijë'ën, senguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Senguë ba'iguëna, cuchi jubë ai jai jubëbi cueñe ba'i cubë jabate ba'ijën, bacua aonre cu'ejën, aonre ainjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ba'ijënna, huati hua'ibi Jesusni senni achahuë: —Ja'an cuchi hua'nana yëquënate saojë'ën. Ba hua'nana cacaye yëyë, senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ja'nca senni achajënna, Jesusbi Saijë'ën cabi. Caguëna, huati hua'ibi ba bainguëte jo'cani, cuchi hua'nana sani cacahuë. Cacani ba'ijënna, samu mil cuchi hua'na ba'iye'ru ba'ijën, ja'ansi'cua yua rëi të'ntëbana huë'huëni, zitarana tonni runi huesëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Runi huesërena, cuchi cuiracuabi ai quëquëni, ja'nrëbi huë'e jobo, huë'e jobo ca'ncoña, ja'anruan bainna sani quëamate. Quëajënna, bainbi ëñajën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús ba'iruna rani ëñato, huati hua'i basi'quë yua caña sayasi'quëbi te'e ruiñe ro'taguë ñuji'i. Ja'nca ñu'iguëna, bacuabi ai huaji yëjën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ëñajënna, baru bain ëñasi'cuabi huati hua'i etosi cocare, cuchi hua'na huesësi cocare quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Quëani achojënna, Jesusni bacua yijabi gare saiye guansehuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Guansejënna, ja'nrëbi, Jesusbi baguë yoguna cacaguëna, huati hua'i etosi'quëbi Jesusni, Më'ë naconi te'e saza caguëna, ");
INSERT INTO snnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusbi ënseni, baguëni yihuoguë cabi: —Më'ë huë'ena go'ijë'ën. Më'ë bainni yë'ë conse'e, yë'ë oiguë base'e, ja'anre quëani achojë'ën. Yë'ë ta'yejeiye Ëjaguëbi yë'ëni ai re'oye conbi caguë, bacuani quëani achojaijë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Caguëna, baguë yua sani, si'a bain Decapolis huë'e joboña ba'icuare Jesús conguë ba'ise'e si'aye quëani achobi. Quëani achoguëna, bain hua'na si'acuabi ai achajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja'nrëbi, Jesús yua yogubi jenni go'iguëna, ai jai jubë bainbi zitara yëruhuana ti'anni, baguëni tëhuo raë'ë. Tëhuo raijënna, baguë yua ba yëruhuate ba'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","bain ñë'ca huë'e ëjaguë Jairo hue'eguëbi raji'i. Rani, Jesusni ëñani, baguë guëon na'mina gugurini rëanni, ");
INSERT INTO snnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","baguëni senreba senji'i: —Yë'ë zin hua'gobi ai ju'in hua'go ba'igona, raijë'ën. Më'ë ëntë sarañare bagona pa'roni huachojë'ën. Huajë raija'go caguë, bagote conjë'ën, senreba senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Senguëna, Jesusbi baguë naconi saji'i. Saiguëna, ai jai jubë bainbi baguëni be'tejën, ai quëon ëaye yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja'nca yo'ojënna, u'chu rau ju'ingobi, si'a sara samu tëcahuëan ju'in hua'go ba'igobi bain jubë naconi ba'igo, Jesusni be'tego baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ba hua'go yua ai ëco yo'ocuana saisi'cobi ai yo'ogo, bago curire bacuana ro'igo si'agoca gare huajë raima'igo, quë'rë ju'in hua'go runco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ja'nca ba'igobi Jesús ba'iyete achani, Jesusna sani, yurera bain jubë naconi baguë yo'jeja'an sani, baguë canre pa'rogo. ");
INSERT INTO snnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Baguë can se'gare pa'roni huajëza cago yo'ogo. ");
INSERT INTO snnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ja'nca pa'rogona, ja'ansirën u'chu rau tëcabi. Tëcaguëna, Yë'ëre rau tëcaye huanoji ro'tago. ");
INSERT INTO snnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ro'tagona, Jesús yua baguë ta'yejeiye poreyebi huachoye huanoguëna, bain jubë ba'iguëbi go'iye bonëni, bainni ëñani: —¿Nebi yë'ë can pa'roye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Senni achaguëna, baguëre concuabi baguëni cahuë: —Ëñajë'ën, Ëjaguë. Bainbi më'ëna ai quëonjënna, ¿më'ë guere ro'taguë, më'ë can pa'rosi'cuare cu'eguë'ne? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Cajënna, Jesús yua si'a bainna bonëjeiñe ëñaguë, baguëni pa'rosi'core cu'ebi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cu'eguëna, ba hua'go yua ai huaji yëgo to'ntogobi baguëna gugurini rëanni, bago yo'ose'e si'aye quëago. ");
INSERT INTO snnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Quëagona, baguë yua bagoni yihuoguë cabi: —Mami, më'ëbi yë'ëni si'a recoyo ro'tasi'co sëani, huajë raë'ë më'ë. Ja'nca huajë raisi'co yua bojogo saijë'ën. Më'ë raure senjosi'cobi huajë hua'go ba'ijë'ën, yihuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ja'nrëbi, Jesús yuta coca cani tëjima'iguëna, ñë'ca huë'e ëjaguë quë'robi Jaironi coca quëacuabi ti'anhuë. Ja'nca ti'ancuabi: —Më'ë zin hua'gobi junni huesëgo. Ja'nca sëani, mai Ëjaguëte choima'ijë'ën, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Cajënna, Jesús yua bacua quëase'ere ro achani, ñë'ca huë'e ëjaguëni yihuoguë cabi: —Huaji yëye beoye ba'ijë'ën. Yë'ëni si'a recoyo ro'taye se'ga ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ja'nca cani, bain jubëbi baguë naconi sai ëaye ba'ijënna, ënsebi Jesús. Pedro, Santiago, Santiago yo'jeguë Juan, bacua se'gare sabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sani, ñë'ca huë'e ëjaguë quë'rona ti'anni ëñato, bain hua'nabi ota oijën, hui'ya güijën, ai gu'aye achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ja'nca yo'ojënna, Jesusbi cacani, bacuani cabi: —¿Mësacua guere ro'tajën, ro ota oijën güiye'ne? Zin hua'gobi ju'inmaco'ë. Cainsi hua'go se'ga ba'igo, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Caguëna, bacuabi baguëni ai jayajën chohuë. Ja'nca chojënna, Jesusbi si'a hua'nare etoni saobi. Saoni ja'nrëbi, ba zin hua'go pë'caguë, pë'cago, baguë naconi raisi'cua, ja'ancua se'gare sani, zin hua'go uinruna cacahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Cacani, baguëbi yua bago ëntë sarare zeanni, bagoni: —Talita, cumi, cabi. Bain cocabi cato, “Huëijë'ën, mami, cayë” cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Caguëna, ja'ansirën, zin hua'go si'a sara samu tëcahuëan ba'igobi sëtani huëni, gani bi'rago. Gani bi'ragona, bain hua'nabi ai ëñajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ëñajën rëinjënna, Jesús yua bacuani si'a jëja guanseguë, Yequëcuani gare quëaye beoye ba'ijë'ën cabi. Cani ja'nrëbi, bagote aon cuiraye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja'nrëbi, Jesús yua barubi sani, baguëre concuabi conjënna, baguë yijana goji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Go'ini, ti'anni, yo'o yo'oma'i umugusebi bain ñë'ca huë'ena sani, bainni coca yihuo bi'rabi. Yihuo bi'raguëna, ai jai jubë bainbi ai achajën rëinjën, sa'ñeña coca cahuë: —¿Baguë coca ye'yose'e queaca ye'yeni masiguë'ne baguë? Ai masi ëjaguëbi ye'yoguëna, ¿nebi baguëni ye'yore'ne? Baguë ta'yejeiye masiguë ëñoguëna, ¿nebi baguëte coñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ro bainguë se'ga ba'iguëbi ro María mamaquë'bi ba'iji. Baguë yo'jecua Santiago, José, Judas, Simón, baguë romi yo'jecua'ga, si'acuabi ënjo'on bain, mai naconi ba'icua'ë, cahuë. Ja'nca cajën, baguë cocare achaye güejën, baguëte te'e ruiñe ëñamajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ja'nca ba'ijënna, Jesusbi bacuani cabi: —Riusu bain raosi'cua banica, si'acuabi bacuani te'e ruiñe ëñajën bojoyë. Bacua te'e huë'e bain, bacua se'gabi bacuani gu'aye ro'tajën, bacuani te'e ruiñe ëñamajën ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ja'nca caguë, yua baguë ta'yejeiye masiye baru bainni masi güeseye gare poremaji'i. Rau ju'in hua'na, te'e hua'na se'gare baguë ëntë sarañabi pa'roni huachobi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Baru bainbi yua baguëni recoyo ro'taye güecua sëani, ja'an se'gare yo'oye poreguë, gue ro'taye beoye bacuani ëñabi. Ja'nrëbi jë'te, yequë huë'e joboña cueñe ba'iguëna, baguë yua baruanna sani, bainni coca yihuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ja'nrëbi, Jesús yua baguëre concuare si'a sara samucuare choini, bacuani cabi: —Mësacua yua huati hua'ire etoye porecuabi saijë'ën caguë, bacuare samu baincua jubëanre cuencueni, tinruanna saicuare re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ja'nca re'huani, bacuani coca yihuoguë cabi: —Mësacua yua bonsere sama'ijë'ën. Bonse turubë, aon, curi, ja'anre sama'ijë'ën. Mësacua ro'ojën sai turubëan se'gare sajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Guëon ju'i pe'perëanre ju'ijë'ën. Te'e ëntë sara can ju'ijë'ën. Samu caña sama'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mësacua yua huë'e jobona ti'anni, ba huë'e jobobi saiye tëca te'e huë'e se'gare ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yequërë baru bainbi mësacuani bojomajën, mësacua coca quëani achoyete achaye güejën ba'itoca, barubi quëñëni saijë'ën. Saijën, bacuabi ëñajënna, mësacua guëon ba'i ya'ore cue'nconi tonjë'ën. Ja'nca yo'otoca, bacuabi bacua gu'a jucha yo'ose'ere masiyë. Ja'nca yo'ocua banica, Sodoma, Gomorra, ja'anruan bain bënni senjoja'ñe'ru, bacua yua quë'rë ta'yejeiye bënni senjosi'cua ba'ija'cua'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ja'nca caguëna, bacuabi sani, Riusu cocare bainni quëani achohuë: —Mësacua gu'a jucha yo'ojën ba'ise'ere beorure jo'cani, mame recoyo re'huani ba'ijë'ën, quëani achojën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ja'nca quëani achojën, gu'a huati hua'ire ai ta'yejeiye etoni saojën, olivo hui'yabebi jañuni tonjën, rau ju'incua ai ta'yejeiye huachojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ja'nca yo'ojënna, bain ta'yejeiye ëjaguë Herodes hue'eguëbi achabi. Si'a bainbi Jesús yo'oye porese'ere achani masihuë. Herodesbi ja'anre achani, coca cabi: —Juan Bautizaguë'bi ba'iji baguë. Junni huesësi'quëta'an, baguë yua go'ya raimaquë. Ja'nca go'ya raiguëbi baguë ta'yejeiye masini ëñoñe poreji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Caguëna, yequëcuabi: —Riusu ira bainguë raosi'quë Elías'bi ba'iji, cahuë. Cajënna, yequëcuabi: —Banji. Yequë'bi. Riusu ira bain raosi'cua ba'icua, te'eguëbi ba'iji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cajënna, Herodesbi achani cabi: —Banji. Juan'bi ba'iji. Baguë sinjobëte tëyoye guansehuë yë'ë. Guanseguëna, yurera go'ya raji'i baguë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes yua ru'ru Juanre preso zeanni, ya'o huë'ena guaoye guansebi. Herodías ro'ina ja'nca yo'obi. Ja'ango yua Herodes yo'jeguë Felipe rënjo ba'isi'cobi ba'igona, Herodes yua bagote tëani babi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tëani baguëna, Juanbi baguëni bëinguë cabi: —Më'ë yo'jeguë rënjore sëani, bagote tëani baye porema'iñë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Caguëna, Herodíasbi yua Juanni bëingo, Baguëni huani senjoza cagoreta'an, Herodesbi ënsebi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juan ba'iyete ëñani, re'o bainguë, jucha beo hua'guë ba'iguëna, Herodesbi ja'anre masiguë, bagote ënsebi. Juanbi Riusu cocare quëani achoguëna, Herodesbi ro huesë ëaye achaguëta'an, baguëni bojoguë achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ja'nca bagote ënseguëna, jë'te ba'iguëna, Herodíasbi Juanni huani senjoñe poreyete ro'tago. Herodes të'ya raisi tëcahuë'ru ba'iye ti'anguëna, Fiestare yo'oza caguë, baguë yo'je ëjacua, baguë soldado ëjacua, Galilea ëjacua, bacuare choini, aon fiestare yo'obi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja'nca yo'oguëna, Herodías mamaco, romi zingobi fiesta yo'oruna cacani pairagona, Herodes, baguë choisi'cua naconi, bacuabi bagoni ai ëa ëñani bojohuë. Pairani tëjigona, Herodes yua bagoni cabi: —Më'ëbi gue gu'a ma'carëanre sentoca, më'ëna ro insiyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ro coquema'iñë yë'ë. Më'ëbi yëtoca, yë'ë guanse jobore cuencueni, jobo ba'iye tëca më'ëna ro insiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Caguëna, bagobi etani, bago pë'cagoni senni achago: —Mamá, ¿guere señe'ne yë'ë? senni achago. Senni achagona, Herodíasbi sehuogo: —Juan Bautizaguë sinjobëte senjë'ën, sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ja'nca sehuogona, ba romi zingobi ja'ansirën Herodesna go'ini, baguëni sengo quëago: —Juan Bautizaguë sinjobëte tëyojë'ën. Tëyoni ja'nrëbi, guëna re'ahuana tëoni, yurera'rë yë'ëna rani ëñojë'ën, cago sengo bago. ");
INSERT INTO snnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ja'nca sengona, Herodesbi ai sa'nti hua'guë runji'i. Ja'nca ruinguëta'an, baguë ganreba case'e'ru tin yo'oye yëmaji'i, baguë gajecua achasi'cuare sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ja'nca ba'iguëna, Herodes yua ja'ansirën soldadote choini, Juan sinjobëte tëyoni rajë'ën caguë guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Guanseguëna, soldadobi ya'o huë'ena sani, Juan sinjobëte tëyoni, guëna re'ahuana tëoni, Herodesna rani jo'cabi. Jo'caguëna, Herodes yua ba romi zingona insiguëna, bago'ga sani, bago pë'cagona jo'cajaco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jo'cagona, ja'nrëbi, Juanre consi'cuabi baguë huani senjose'ere achani, baguë ga'nihuëte injën raë'ë. Rani, baguë ga'nihuëte sani tanhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ja'nrëbi jë'te, Jesús bain cuencueni saosi'cuabi se'e baguëna ñë'ca rani, bacua yo'ojën ba'ise'e, bacua ye'yojën ba'ise'e si'aye baguëni quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Quëani achojënna, Jesusbi bacuani cabi: —Re'oji. Yureca raijë'ën. Bain beoruna sani, bëani huajëñu, cabi. Ai jai jubë bainbi ëñajën, raijën ba'ijënna, Bacuare conñu cajën yo'ojën, bacuabi yuta bacua aon aiñe poremaë'ë. Ja'nca sëani, Jesusbi bëani huajë cocare bacuani cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cani, bacua se'gare sabi. Sani, yoguna cacani, bain beo re'otona saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Saijënna, ai jai jubë bainbi bacuare ëñani, Jesusre masini, bacua saija'runa ma'abi ru'ru sani ti'anhuë. Si'a joboña bainbi sani, baruna ti'anni ëjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ëjojënna, ja'nrëbi, Jesusbi ti'anni, yogubi etani mëni, ai jai jubë bain raisi'cuani ëñabi. Ja'nca ëñani, bacuare ai oire babi. Oveja hua'na cuiraguë beocua'ru ba'iye ëñoñë bacua caguë, bacuani ai ba'iye coca yihuo bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yihuoni na'ijaiguëna, baguëre concuabi rani, baguëni coca cahuë: —Yua na'iji. Ën re'oto yua bain beo re'oto sëani, ");
INSERT INTO snnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","bainre go'i güesejë'ën. Bacua yua cueñe ba'i huë'e jo'borëanna sani, bacua cainruan, bacua aon aiñe, ja'anre cu'eja'bë caguë, bacuare go'i güesejë'ën. Aon beocua'ë bacua, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Cajënna, Jesús sehuobi: —Mësacua se'gabi bacua aonre aonjë'ën, sehuobi. Sehuoguëna, bacua senni achahuë: —¿Yua yëquëna sani, samu cien denario so'coña ro'iye aonre coni rani bacuani aoñe yëguë më'ë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Senni achajënna, Jesusbi sehuoguë senni achabi: —¿Mësacua jo'jo aonbëan quejeibëan baye'ne? Sani ëñajë'ën, cabi. Caguëna, sani ëñani rani quëahuë: —Te'e ëntë sarabëanre bayë. Samu ziaya hua'ire'ga bayë yëquëna, quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Quëajënna, Jesusbi si'a bainni guanseguë cabi: —Mësacua yua jubëan ñë'cani, re'o tayahuëanna bëani huajëjë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Caguëna, yequëcua cien ba'icua'ru ba'iye, yequëcua cincuenta ba'icua'ru ba'iye, jubëan ñë'cani bëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bëajënna, ja'nrëbi, Jesús yua ba te'e ëntë sara jo'jo aonbëanre, ba samu ziaya hua'ire inni, mëiñe ëñani, Riusuni bojoguë, Surupa cabi. Cani, aonbëanre jë'yeni, baguëre concuana insibi, bainni aoñete. Insini, güina'ru, ba samu ziaya hua'ire inni jë'yebi, si'a hua'na aiñete. ");
INSERT INTO snnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ja'nca jë'yeni aonni, si'a hua'nabi anni yajihuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Anni yajirena, ja'nrëbi, Jesusre concuabi ba aon anni jëhuasi mi'chirëanre chiani, ziaya hua'i mi'chirëanre chiani, si'a sara samu jë'eñana bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ba aon ainsi'cua, ëmëcua se'gare cuencueto, cinco mil baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ja'nrëbi jë'te, Jesusbi baguëre concuani guanseguë cabi: —Mësacua yua yoguna cacani, Betsaida huë'e jobona je'enni, ru'ru saijë'ën. Yë'ëbi yua bainre bacua huë'eñana go'i güeseyë, guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Caguëna, baguëre concuabi saë'ë. Saijënna, baguë yua bainre go'i güeseni, ja'nrëbi cubëna mëni, Riusu naconi ujabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ujaguë na'iguëna, ñami ti'anguëna, Jesusbi cubëte te'e hua'guë ba'iguëna, baguëre concuabi jobo zitarate ba'ijën, go'iye tutuguëna, ai jëja ro'ajën, ro guajahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Guajajën ñatajaijënna, ñata ñami ba'iguëna, Jesusbi ëñani, bacua ba'iru tëca zitara canja'an ganiguë raji'i. Rani, bacuare tayojeiye saiye'ru ëñoguëna, ");
INSERT INTO snnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","bacuabi ëñani, Huatibi raiji ro'tajën, ");
INSERT INTO snnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ai quëquëreba quëquëjën, ai jëja güihuë. Güijënna, Jesusbi bacuani cabi: —¡Mësacua jëja recoyo bajë'ën! ¡Yë'ë'ë! ¡Quëquëye beoye ba'ijë'ën! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cani ja'nrëbi, bacua yoguna cacaguëna, tutubi carajaji'i. Carajaquëna, bacuabi gue ro'taye beoye ai ëñajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ëñajën rëinjën, Jesús ta'yejeiye yo'oni ëñoguë ba'ise'e, bain jubë aonguë ba'ise'e, ja'anre te'e ruiñe ye'yemaë'ë. Yuta bacua ye'yeni si'a recoyo ro'taye ai carabi bacuare. ");
INSERT INTO snnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ja'nrëbi, zitarate je'enni, Genesaret yijana ti'anhuë. Ti'anni, yogute gueonni, ");
INSERT INTO snnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mëijënna, bain hua'na baru ba'icuabi Jesusre ëñani masihuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Masini ja'nrëbi, si'a ca'ncoñabi bacua ju'incuare camañare uinjënna, Jesús ba'irute quëajënna, baguëna cuanni rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ja'nca rajënna, bacuare huachobi. Si'a baru ba'i huë'e joboñana ti'anni, huë'e joboña ca'ncoñana ti'anni ba'iguëna, bacua rau ju'incuare rani, bacua huë'e jobo ma'a yëruhuana uanni ëjoni, Jesusbi raiguëna, Më'ë can na'mi se'gare pa'roni huajëja'bë cajën, Jesusni sen'ë. Senjënna, si'acua baguëni pa'rocuabi huajë hua'na go'ya raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ja'nrëbi, fariseo bainbi ira coca ye'yocua naconi, Jerusalenbi rani, ");
INSERT INTO snnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesusre concuare ëñato, yequëcuabi bacua ëntë saraña si'si sarañare bajën, bacua aonre ainjën baë'ë. Ëntë abuma'isi'cuare sëani, fariseo bainbi bacuani bëinjën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseo bain, si'a judío bainbi bacua aonre aiñe yëto, ru'ru ai tayejeiye ëntë abuyë. Bacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru güina'ru yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aon coruna sani rani, bacua ëntë yua re'oye abuma'itoca, bacua aonre ainma'iñë. Ro bacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru yo'ojën, bacua gono ro'rohuëanre zoaye, bacua sotoroanre, bacua guënaroanre re'oyera zoaye, ja'anre ai cuirajën yo'oyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ja'nca yo'ojën ba'icua, fariseo bain, ira coca ye'yocua, bacuabi Jesusre tëhuoni, baguëni senni achahuë: —¿Më'ëre concua queaca yo'ojën, mai ira bain ba'isi'cua yo'ojën ba'ise'e'ru tin yo'oye'ne? Ro si'si ëntë sarañate bajën, bacua aonre ainjën, ai gu'aye yo'oyë, senni achajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ja'nca bëinjënna, Jesusbi sehuobi: —Mësacua re'o bain ba'iyë yëquëna cajën, ro coqueyë. Riusu ira bainguë raosi'quë Isaías hue'eguëbi mësacua ba'iyete ro'tani, ai masiye toyani jo'cabi: Judío bainbi Riusuni te'e ruiñe ëñañe'ru ëñojën, ro bacua yi'oboan se'gabi ro re'oye achoye cajën, ro coqueyë. Ja'nca cajën, bacua recoñoabi baguëni ro'tamajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ro coquejën, Riusuni ro gugurini rëanjën ba'iyë. Ro bain ro'tase'e se'gare ye'yojën, Riusu cocareba'ë cajën, ro coqueyë, toyani jo'cabi Isaías. ");
INSERT INTO snnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mësacua'ga Isaías toyani jo'case'e'ru güina'ru yo'ojën, ro coquejën ba'iyë. Riusu cocarebare ro jo'cani senjojën, ro bain yo'ojën ba'iye'ru yo'ojën ba'iyë. Mësacua ocobëan, uncu ro'rohuëan, ja'anre re'oye zoañu cajën, ro mësacua ira bain yo'ojën ba'ise'e'ru güina'ru ro ta'yejeiye yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mësacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru güina'ru yo'oñu cajën, Riusu coca guanseni jo'case'ere ro jo'cani senjohuë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Riusu bainguë Moisesbi coca guanseni jo'cabi: “Më'ë pë'caguë, më'ë pë'cago, bacuare te'e ruiñe ëñaguë ba'ijë'ën. Bainguëbi baguë pë'caguë sanhuëni gu'aye catoca, baguëni huani senjojë'ën” guanseni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ja'nca guanseni jo'caguëta'an, mësacuabi ro tin ye'yojën, bainre ñaca cayë: “Mësacuabi mësacua pë'caguë, pë'cago, bacuani: Yë'ë baye si'aye Corbán ba'iji. Riusuna insise'e'ë cayë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ja'nca insise'ere sëani, mësacuana insiye porema'iñë, ja'anre catoca, mësacua pë'caguë sanhuëni conni cuiraye yo'oma'ijë'ën.” Ja'an cocare huacha ye'yojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ja'nca ye'yojën, Riusu coca guanseni jo'case'ere ro carajei güesejën, ro mësacua ira bain ba'isi'cua yo'ojën ba'ise'ere ro ye'yojën ba'iyë. Ja'nca yo'ojën, mësacua yequë yo'o ai ta'yejeiye ro yo'oreba yo'ojën ba'iyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja'nca cani, ja'nrëbi, bainre se'e choini, bacuani yihuoguë cabi: —Mësacua si'acua yë'ëre achani ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bain aon ainse'ebi gu'a bain'ru ruiñe beoye ba'iyë. Bain recoyo ro'tani case'e se'ga, ja'an se'gabi gu'ajeijën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mësacua ganjo banica, achani ye'yejë'ën, cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ja'nca cani, ja'nrëbi, bainre jo'cani, baguë huë'ena go'ini cacaguëna, baguëre concuabi baguë ye'yo coca yure case'ere senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Senni achajënna, Jesús sehuobi: —¿Mësacua'ga ro huesë ëaye achare? Ja'nca ba'itoca, mësacua te'e ruiñe achani ye'yejë'ën. Bain aon ainse'ebi bacuani gu'aye yo'o güesema'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bain aon ainse'ebi bacua recoyona ti'anma'iji. Guëtabë se'gana ti'anni, ja'nrëbi, ro anni saoye se'gabi etani huesëji, sehuobi. Ja'nca sehuoguë, si'a aon re'o aon ba'iye cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ja'nca cani, bacuani yihuoguë quëabi: —Bain recoyo ro'tani yi'obobi case'e, ja'anbi cajën, ro gu'ajeijën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bainbi ro recoyo ro'tajën, gu'aye se'gare ro'tani gu'aye yo'ojën ba'iyë. Ëmëcua, romicua, sa'ñeña ro yahue bajën, ro a'ta yo'ojën, ");
INSERT INTO snnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bonsere ro ëa ëñajën, bainre gu'aye cajën, bacua se'gare'ru huanoñe ro'tajën, ro huesë ëaye yo'oreba yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ja'nca gu'aye ro'tajën, recoyo se'gabi ro'tani yo'ojën, gu'ajeijën ba'iyë bain hua'na, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ja'nrëbi, Jesusbi sani, Tiro, Sidón, ja'anruan ba'i yijana ti'anbi. Ti'anni, Bainbi yë'ë ënjo'on ba'iyete achama'ija'bë caguë, baru ba'i huë'ena cacani, te'eguë ba'iye ro'tabi. Ja'nca ro'taguëta'an, te'eguë ba'iye poremaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yeco romigobi baguë ba'iyete achani, baguëna rani, baguë guëon na'mina gugurini rëango. ");
INSERT INTO snnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Judía baingo beogo. Tin baingo, Sirofenicia baingo ba'igona, bago zin hua'gobi gu'a huati cacasi'co baco'ë. Ja'nca ba'igona, pë'cagobi Jesusna rani, bago gu'a huati etoni saoye senco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sengona, Jesusbi ye'yo cocabi sehuobi: —Yë'ë bain se'gare coñe bayë ru'ru. Tin bainre ru'ru contoca, gu'aji. Bain zin hua'na aonre tëani, jo'ya yai hua'nana aoñe, ja'nca yo'otoca, gu'aji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sehuoguëna, bagobi cago: —Te'e ruiñe cahuë më'ë Ëjaguë. Ja'nca caguëta'an, zin hua'nabi aonre ainjën, bacua aon zi'ngare mesa yijacuana tonjënna, jo'ya yai hua'nabi chiani aiñë, cago. ");
INSERT INTO snnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ja'nca cagona, Jesusbi bagoni quëabi: —Ai re'oye sehuohuë më'ë. Ja'nca sëani, më'ë huë'ena go'ijë'ën. Gu'a huatibi më'ë zin hua'gore gare jo'cani saji'i, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Quëaguëna, bagobi go'ini ëñato, zin hua'gobi camate unco'ë. Gu'a huati gare etani saisi'quëbi baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ja'nrëbi, Jesús yua Tirobi sani, ja'nrëbi Sidonbi sani, Decápolis huë'e joboñabi sani, Galilea zitarana ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ti'anguëna, yequëcuabi bacua bainguëte baguëna sani ëñohuë. Ja'anguë yua ganjo achama'iguë, hue'nhue coca caguë baji'i. Ja'nca ba'iguëna, baguëte ëñojën, Jesús ëntë sarabi pa'roni huachoye sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Senjënna, Jesusbi baguëte bain ba'irubi quëñoni, ca'ncona sabi. Sani ja'nrëbi, baguë mëoñoabi yua ba bainguë ganjoroanna guioni, ba bainguë zemeñona gore tonni tëobi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ja'nca yo'oni ja'nrëbi, mëiñe ëñani, ba bainguëni oire bani, ja'nrëbi: —¡Efata! cabi. Bain cocabi cato, ¡Ja'anse'e ti'jija'guë! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja'nca caguëna, ba bainguë ganjo, baguë zemeño, yua ja'anse'e ti'jiguëna, baguë yua huajë raji'i. Re'oye coca caye porebi. ");
INSERT INTO snnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja'nca huajë raiguëna, Jesusbi bain hua'nani guanseguë, “Yequëcuani gare quëani achoma'ijë'ën” guanseguë cabi. Cani, quë'rë guansese'eta'an, ba hua'nabi quë'rë cani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ja'nca cani achojën, ai ëama'iñereba ëñajën rëinjën, coca cahuë: —Baguë yo'o yua si'aye ai re'oye yo'oji. Ja'nca yo'oguëna, ganjo achama'icuabi achaye poreyë. Yi'o ma'tëbë ba'icua'ga coca caye poreyë, cajën bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja'nrëbi, ja'an umuguseña ba'iguëna, ai jai jubë bainbi ñë'ca raijënna, bacua aon aiñe beobi. Beoguëna, Jesusbi baguëre concuare choini, bacuani cabi: ");
INSERT INTO snnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ën bainbi samute umuguseña yë'ë naconi ba'ijën, aon aiñe beojënna, bacuani ai oire bayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bacua huë'ena go'i güesetoca, bacua yua ro aon gu'ana ju'incuabi ma'ana ro pa'npani gurujaiyë. Yequëcua yua ai so'o raisi'cua ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Caguëna, baguëre concuabi sehuoye senni achahuë: —Yua ën re'oto beo re'oto ba'iguëna, ¿guere bacuani aon aoñe'ne mai? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Senni achajënna, Jesusbi bacuani senni achabi: —¿Mësacua jo'jo aonbëan quejeibëanre baye'ne? senni achabi. Senni achaguëna: —Te'e ëntë sara samubëanre bayë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sehuojënna, ja'nrëbi, Jesusbi bainre yua yijana bëaye guansebi. Ja'nca guanseni, ba aonbëan te'e ëntë sara samubëanre inni, Riusuni Surupa cani, ba aonbëanre jë'yeni, baguëre concuana insibi. Insiguëna, bacuabi yua bain hua'nana huo'hueni insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ziaya hua'ire'ga samu rëño hua'nare bahuë. Ja'an hua'ire Jesusna insijënna, Jesusbi ba hua'ire re'oye cani, bainna huo'hueye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Guanseguëna, si'a hua'nabi aon anni yajihuë. Anni yajirena, ja'nrëbi, aon anni jëhuase'ere chiani, te'e ëntë sara samu jë'eña bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ba aon ainsi'cuare cuencueto, cuatro mil ba'icua'ru baë'ë. Ja'nrëbi, Jesús yua bacuare go'i coca cani, ");
INSERT INTO snnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","baguëre concua naconi yoguna cacani, Dalmanuta yijana saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sani ti'anjënna, ja'nrëbi, fariseo bainbi Jesusre tëhuo rani, baguëni coca senni acha bi'rahuë. Baguëni huacha sehuo güeseñu cajën, baguëni: “Ta'yejeiye yo'o yo'oni ëñojë'ën. Guënamë re'otobi etoni ëñojë'ën” senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Senni achajënna, Jesusbi ai sa'ntiguë, bacuani bëinguë cabi: —¿Mësacua queaca ro'tajën, ta'yejeiye yo'o yo'oni ëñojë'ën yë'ëre caye'ne? Mësacuani ganreba caguë quëayë. Ta'yejeiye yo'o yua mësacuani gare ëñoma'iñë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cani ja'nrëbi, bacuare jo'cani, yoguna se'e cacani, zitara të'huina se'e je'enni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ja'nca saiguëna, baguëre concuabi yogute ba'ijën, aonre saye huanë yehuë. Te'e jo'jo aonbë se'gare bahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ja'nca bajënna, Jesusbi bacuani guanseguë cabi: —Mësacua ëñare bajë'ën. Fariseo bain, Herodes bain, bacua aon huo'coye ro'tamajën ba'ijë'ën, guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Caguëna, baguëre concuabi sa'ñeña coca ca bi'rahuë: —Aonre saye huanë yesi'cua sëani, ja'anre maini guanseguë cabi baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Cajënna, Jesusbi bacuani bëinguë cabi: —¿Mësacua queaca ro'tajën, aonre saye huanë yehuë caye'ne? Mësacua yuta ye'yema'icua ba'iyë. Yuta ro huesë ëaye achajën ba'iyë. Mësacuare recoyo ro'taye ai caraji. ");
INSERT INTO snnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mësacua ñaco bajën, ¿guere yo'ojën ëñama'iñe'ne? Mësacua ganjo bajën, ¿guere yo'ojën achama'iñe'ne? Mësacuabi ro ro'tajën, ro huanë yejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yë'ëbi te'e ëntë sara jo'jo aonbëanre jë'yeni cinco mil bainre aonguëna, mësacuabi aon anni jëhuase'ere chiani, ¿quejei jë'eñara bu'iye ayare'ne? senni achabi. Senni achaguëna: —Si'a sara samu jë'eña, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sehuojënna, baguë yua se'e senni achabi: —Yë'ëbi te'e ëntë sara samu aonbëanre jë'yeni, cuatro mil bainni aonguëna, mësacuabi aon anni jëhuase'ere chiani, ¿quejei jë'eñara bu'iye ayare'ne? senni achabi. Senni achaguëna: —Te'e ëntë sara samu jë'eña, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sehuojënna, baguë yua bacuani: —¿Yuta achama'iñe mësacua? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ja'nrëbi jë'te, Betsaidana ti'anhuë. Ti'anjënna, yequëcuabi ñaco ëñama'iguëte Jesusna rani, Baguëte pa'roni huachojë'ën, sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ja'nca senjënna, Jesusbi ñaco ëñama'iguëni ëntë sarana zeanni, huë'e jobo ca'ncona sabi. Sani ja'nrëbi, baguë ñacona gore tonni tëoni, baguë ëntë sarañabi baguëna pa'roni, ja'nrëbi, baguëni coca senni achabi: —¿Më'ë guere ëñaguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Senni achaguëna, ñaco ëñama'iguëbi sëtani ëñani sehuobi: —Bainre ëñañë yë'ë. Bain ganicua ba'icuareta'an, sunquiñëa ba'iye'ru yë'ëre ëñoñë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Caguëna, ja'nrëbi, Jesús yua se'e baguë ëntë sarañabi baguë ñacona pa'roguëna, baguëbi se'e sëtani ëñato, si'aye te'e ruiñe ëñaguë baji'i. Gare huajë raisi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ja'nca ba'iguëna, Jesús yua baguëni cabi: —Ba huë'e jobona se'e saima'ijë'ën. Yë'ë yure huachose'ere yequëcuani gare quëaye beoye ba'ijë'ën caguë, më'ë huë'ena go'ijë'ën guanseni jo'cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ja'nrëbi jë'te, Jesús, baguëre concua naconi, bacuabi yua Cesarea Filipo huë'e joboña tëca saë'ë. Sani, ma'abi ganijënna, Jesusbi baguëre concuani coca senni achabi: —Bainbi yë'ëre coca cajën, ¿gueguëguë'ne yë'ëre caye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Senni achaguëna, sehuohuë: —Yequëcuabi më'ëre cajën, Juan Bautizaguë'bi, më'ëre cayë. Yequëcuabi, Elías'bi, më'ëre cayë. Yequëcuabi, Riusu bainguë raosi'quë'bi, më'ëre cayë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sehuojënna, bacuani se'e senni achabi Jesús: —Mësacua'ga cajën, ¿gueguëguë'ne yë'ëre caye'ne? senni achabi. Senni achaguëna, ja'nrëbi, Pedrobi sehuobi: —Më'ë yua Riusu Raosi'quëreba'ë. Ba Cristo ba'iguë'ë më'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja'nca sehuoguëna, Jesusbi bacuani guanseguë: —Mësacua yua ja'anre yequëcuani gare quëaye beoye ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ja'nrëbi, baguëre concuare yihuoguë ca bi'rabi: —Yë'ë yua Bainguë'ru Raosi'quëreba sëani, ai ta'yejeiye ja'siye ai yo'oye bayë yë'ë. Israel bain ira ëjacua, pairi ëjacua, ira coca ye'yocua, ja'ancuabi yë'ëre ai je'o bajën, yë'ëni huani senjoja'cua'ë. Huani senjocuata'an, samute umuguseña ba'ini, go'ya raija'guë'ë yë'ë caguë, bacuani te'e ruiñera quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ja'nca quëaguëna, Pedro yua baguëte ca'ncona sani, baguëni ai bëinguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Caguëna, Jesusbi yua baguë yequë concuana bonëni, Pedroni bëinguë sehuoguë cabi: —¡Quëñëni saijë'ën! ¡Zupai huati caye'ru cayë më'ë! Riusu ro'taye'ru tin ro'tayë më'ë. Ro bain ro'taye'ru te'e ro'tayë më'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cani ja'nrëbi, baguëre concua, bain hua'na baru ba'icua, bacuare choini, bacuani coca yihuoguë quëabi: —Bainbi yë'ëni te'e coñe yëtoca, bacua ba'iyete ro'tama'ijën ba'ija'bë. Bainbi crusu sa'cahuëna ju'iñe ro'tani, yë'ë naconi te'e ganijën raija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ro bacua ba'iye se'gare ro'tatoca, bacuabi huesëni si'ayë. Yë'ë ba'iye, Riusu cocareba, ja'anre quëani achojën, ja'an ro'ina junni huesëtoca, bacuabi go'ya rani huajëreba huajëja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bainbi si'a ën yija ba'iyete coni bani, ja'nrëbi junni huesëtoca, bacua bonsere baye gare porema'iñë. Ro guaja yo'o yo'osi'cua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bacuabi gare se'e go'ya rani bonse baye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yë'ëre gu'a güeni senjoñe ro'tatoca, yë'ë cocareba ye'yose'ere gu'a güeni senjoñe ro'tatoca, yë'ë'ga bacuare güeni senjoja'guë'ë. Ën yija bainbi ai gu'aye yo'ojën, sa'ñeña ro a'ta yo'ojën ba'ijënna, mësacuabi bacua naconi te'e conjën ba'itoca, yë'ë bënni senjo umuguse ti'anguëna, mësacuare güeni senjoja'guë'ë yë'ë. Yë'ë yua Riusu Raosi'quëreba ba'iguëbi, yë'ë Taita Riusu naconi, baguë guënamë re'oto yo'o con hua'na naconi, ai ta'yejeiye ai go'sijeiye raiguë, yë'ë bainrebare inguë raija'guë'ë yë'ë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ja'nca quëani, ja'nrëbi, bacuani se'e yihuoguë cabi: —Mësacuani ganreba quëayë yë'ë. Mësacua jubë ba'icua yequëcua ënjo'on nëcacuabi yuta junni huesëma'iñë. Ru'ru, Riusubi ënjo'ona ti'anni, baguë ta'yejeiyereba yo'oye poreyete ëñoguëna, mësacuabi ëñaja'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ja'nrëbi, te'e ëntë sara te'e umuguseña ba'ini, Jesusbi yua ai ëmë cubëna mëji'i. Mëni, Pedro, Santiago, Juan, bacua se'gare ja'anruna mëabi. Mëani, bacuabi ëñajënna, baguë ba'iye yua tin ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Baguë caña yua ai ta'yejeiye pojeiyereba ai go'sijei cañara runji'i. Caña zoacua si'acuabi baguë cañate zoatoca, ta'yejeiye pojei caña zoaye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ja'nrëbi, Elías, Moisés, bacuabi gaje meni nëcahuë. Jesús naconi coca cajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ja'nca nëcajënna, Pedrobi Jesusni cabi: —Ëjaguë, ¡maibi ënjo'onre ba'ijënna, ai re'oye ba'iji! Ja'nca sëani, samute huë'erëanre yo'oñu. Te'e huë'erë më'ëna yo'ocaiyë. Te'e huë'erë Moisesna yo'ocaiyë. Te'e huë'erë Elíasna yo'ocaiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesusre concuabi ai quëquësi hua'na ba'ijënna, Pedrobi ro huesë ëaye coca cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Caguëna, ja'nrëbi, oco picobi nëca meni, si'acuare na'oguëna, picobë sa'nahuëbi bain coca achoni raobi: —Ënquë yua yë'ë Zin'bi. Yë'ë ai yësi'quë'bi. Baguëbi coca caguëna, mësacua achajën ba'ijë'ën, achoni raobi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ja'nca achoni raoguëna, ba hua'nabi bonëjeiñe ëñani, Jesús se'gare ëñahuë. Yequëcuabi gare beohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ja'nrëbi, cubëbi gajejën, Jesusbi bacua ëñase'ere yequëcuani quëani achoye beoye ba'ijë'ën guanseguë cabi. Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëbi junni tonni go'ya raiguëna, ja'nrëbi, yequëcuani quëani achojë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ja'nca caguëna, bacua se'gabi bacua ëñase'ere yahue masijën, yequëcuani quëani achomaë'ë. Quëani achoma'icua'ga yua sa'ñeña coca senni achajën, baguë junni tonni go'ya raiye caguë, guere caguë'ne, sa'ñeña senni achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ja'nca senni achajën, ja'nrëbi Jesusni senni achahuë: —Ira coca ye'yocuabi, Elíasbi ru'ru ti'an raiye ba'iji cajën, ¿guere ro'tajën caye'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Senni achajënna, baguë sehuobi: —Te'e ruiñe cayë bacua. Elíasbi ru'ru ti'an raiye ba'iji. Si'aye mame re'huaguë raiji. Ja'nca re'huaguë raiguëta'an, Riusu coca toyani jo'case'ere ëñato, yë'ë ba'iyere'ga quëaji. Yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi ai ta'yejeiye ja'siye ai yo'oguë ba'iguëna, yequëcuabi yë'ëni je'o ëñajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elías ba'iyete cato, mësacuani ñaca quëayë yë'ë. Yua ti'an raisi'quë'bi baji'i. Ja'nca ba'iguëna, Elíasre je'o bacuabi ro bacua gu'a ëase'e'ru baguëni güina'ru gu'aye yo'ojën baë'ë, sehuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja'nrëbi jë'te, baguë yequë concua ba'iruna ti'anni ëñato, ai jai jubë bain, ira coca ye'yocua naconi baë'ë. Ira coca ye'yocuabi yua baguëre concua naconi bëin coca cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ja'nca ba'ijën, ja'nrëbi, Jesusni ëñani, si'a bainbi ai ëñajën rëinjën, baguëna besa sani saludahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Saludajënna, Jesusbi baguëre concuani senni achabi: —¿Mësacua yua gue coca bacua naconi cajën ba'iye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Senni achaguëna, yequë bainguë ba jubë bain naconi ba'iguëbi sehuoguë quëabi: —Ëjaguë, yë'ë zin hua'guëte më'ëni ëñoguë raë'ë. Gu'a huati cacasi'quë sëani, yi'o ma'tëbë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Baguëbi pasiaguë saiguëna, ba huatibi baguëni hue'nhue yo'oni, baguëte yijana ro jëjoni saoni taonguëna, baguë yi'obobi chiri mëani to'inji. Mëani tonni, gunjire ai jëja guëonni, si'a ga'nihuë garani, ai yo'oji. Ja'nca ba'iguëna, më'ëre concuanni huati etoye sen'ë yë'ë. Senguëna, bacuabi etoye poremaë'ë, cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Caguëna, Jesusbi ai sa'ntiguë, baguëre concuani cabi: —¡Yë'ëni si'a recoyo ro'taye ai caraji mësacuare! ¡Ro bain ro'taye'ru ro'tajën ba'iyë mësacua! ¿Mësacua ye'yeyete quejei zoe yuta ëjoye ba'iye'ne yë'ë? Ba hua'guëre yua yë'ëna rajë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Caguëna, ba zin hua'guëre rajënna, ba gu'a huatibi Jesusni ëñani, zin hua'guëni ai jëja hue'nhue yo'obi. Yo'oguëna, baguë yua yijana tanni, bo'neguë uinguë, baguë yi'obobi chirire mëani tonni, ai yo'obi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ai yo'oguëna, Jesús yua baguë pë'caguëni senni achabi: —¿Quejei zoe huatire baguë'ne baguë? senni achabi. Senni achaguëna, pë'caguëbi sehuobi: —Baguë zinrënna gu'a huatire baji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gu'a huatibi cue'yonica, baguëni huani senjoza caguë, yua toabo, ziaya, ja'anruanna jëjoni saoni tonji. Ja'nca ba'iguëna, më'ëbi poretoca, yëquënani oireba oiguë conjë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Caguëna, Jesús cabi: —Më'ëbi yë'ë poreyete si'a recoyo ro'tatoca, baguëni huachoyë yë'ë. Bainbi yë'ë yo'oye poreyete si'a recoyo ro'tatoca, Riusubi bacuare si'aye yo'ocaiji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Caguëna, ja'nrëbi, ba pë'caguëbi si'a jëja güiguë sehuobi: —¡Më'ëna si'a recoyo ro'tayë yë'ë! ¡Më'ëni si'a recoyo ro'taye caratoca, yë'ëre oireba oiguë conjë'ën! güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Caguëna, ai jai jubë bainbi ñë'ca raijënna, Jesusbi ëñani, ba gu'a huatini bëinguë guanseguë cabi: —Më'ë gu'a huati, yi'o ma'tëbë huati, ganjo achama'i güese huati, ja'an ba'iguëna, më'ëni si'a jëja guanseguë cayë yë'ë. Ba zin hua'guëre gare etani saijë'ën. Baguëte gare se'e caca raima'iguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Caguëna, gu'a huatibi ai jëja güini, zin hua'guëni se'e hue'nhue yo'oni, ju'insi'quë'ru jo'cani, gare etani saji'i. Saiguëna, bain hua'nabi, Yua junji'i baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Cajënna, Jesusbi baguë ëntë sarare zeanni, baguëte huëabi. Huëaguëna, zin hua'guëbi huajë rani nëcabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ja'nrëbi, Jesús yua baguë huë'ena go'ini ba'iguëna, baguëre concuabi baguëni senni achahuë: —¿Yëquëna hua'na guere yo'ojën, gu'a huatire etoni saoye poremate'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Senni achajënna, sehuobi: —Mësacua yua aon aiñe jo'cajën, Riusuni ujareba ujajën ba'ijë'ën. Ja'nca yo'oma'itoca, ja'an huati hua'ire etoni saoye gare porema'iñë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ja'nrëbi, bacuabi barubi sani, Galilea ma'aja'an ganijaë'ë. Jesús yua baguëre concuani coca yihuoguë sëani, yequëcuabi baguë ganiñete masima'ija'bë caguë, bacua naconi yahue ganiguë saji'i. Baguëre concuani coca yihuoguë, baguë ba'ija'yete quëabi: —Yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëna, yequëcuabi yë'ëre preso zeanni, gu'a bainna insija'cua'ë. Insijënna, bacuabi yë'ëni huani senjoja'cua'ë. Huani senjorena, ja'nrëbi, samute umuguseña ba'ini, yë'ëbi go'ya raija'guë'ë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Quëaguëna, baguëre concuabi ro huesë ëaye achahuë. Baguë coca yihuose'ere senni achaye huaji yëjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ja'nrëbi, bacuabi Capernaum huë'e jobona ti'anhuë. Ti'anni, bacua huë'ena cacani ba'ijënna, Jesusbi bacuani senni achabi: —¿Mësacua gue coca cajën rate'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Senni achaguëna, ro sehuoye beoye achahuë. Bacuabi ma'a raijën, bacua quë'rë ta'yejeiye ëjaguë ba'ija'yete sa'ñeña ro'tajën, sa'neña cajën bëinjën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja'nca sëani, Jesusbi bëani, baguëre concua si'a sara samucuare choini, bacuani yihuoguë cabi: —Bainguëbi quë'rë ta'yejeiye ëjaguë ba'iye yëtoca, quë'rë yo'je ba'iguë ruiñe baji. Si'a bain yo'o con hua'guë'ë cajën, si'acuani conni cuiraguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Cani ja'nrëbi, zin hua'guëre choini, bacua joborana rani nëcobi. Ja'nrëbi, baguëte cuanni, si'nquina ñoni, bacuani yihuoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Bainbi yë'ëni re'oye yo'oni coñe ro'tatoca, zin hua'guë, ënquë ba'iguëre'ru re'oye ro'tani yo'ojën conjë'ën. Ja'nca yo'otoca, yë'ëni te'e ruiñe ëñajën ba'iyë. Yë'ëni te'e ruiñe ëñajën ba'itoca, yë'ë Taitare'ga, yë'ëre raosi'quë, ja'anguëre'ga te'e ruiñe ëñajën ba'iyë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Caguëna, ja'nrëbi, Juanbi baguëni quëabi: —Ëjaguë, yequë bainguë Më'ëni te'e coñë yë'ë, caguëbi huati hua'ire etoni saoguëna, yëquënabi ëñahuë. Ëñani, mai naconi te'e ba'ima'iguëre sëani, baguëte ënsehuë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Caguëna, Jesusbi sehuobi: —Ja'an yo'ocuare ënsema'ijë'ën. Yë'ëni coñe cacuabi ta'yejeiye yo'o yo'oni ëñoni, ja'nrëbi jë'te, yë'ëre gu'aye caye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maini gu'aye yo'omajën ba'icuabi maire te'e conjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Si'a bainbi, mësacuare, Cristo bainrebare sëani, Mësacuare re'oye conñu cajën, oco se'gare mësacuana uncuatoca, Riusubi baguë ta'yejeiye insija'ye ro'tase'ere bacuana jo'caye beoye insija'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Cani ja'nrëbi, bacuani yihuoguë cabi: —Zin hua'na ënquë'ru ba'icuabi yë'ëni si'a recoyo ro'tajënna, ai bojoyë yë'ë. Bainguëbi yua te'e zin hua'guë se'gani gu'a jucha yo'o güesetoca, baguëni ai bënni senjoja'guë'bi Riusu. Ru'ru, jai gata to'obëbi inni, baguë ñaje tëcana gueonni, baguëte jai ziayana senjoni rëotoca, baguëre quë'rë re'oye ba'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Më'ë ëntë sarabi gu'a juchare yo'o ëaye ro'tatoca, më'ë ëntë sarare të'cani senjojë'ën. Te'e ëntë sara se'gare baguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji. Samu ëntë sarañare baguëbi ba toana senjosi'quë ba'itoca, ai gu'aye ba'iji. Ja'an toare yayoye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Baru ba'i peco hua'nabi gare carajeiye beoye ba'ijënna, baru ba'i toabi gare yayaye beoye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Më'ë guëonbi gu'a juchare yo'o ëaye ro'tatoca, më'ë guëonre të'cani senjojë'ën. Te'e guëon se'gare baguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji. Samu guëoñare baguëbi ba toana senjonsi'quë ba'itoca, ai gu'aye ba'iji. Ja'an toare yayoye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Baru ba'i peco hua'nabi gare carajeiye beoye ba'ijënna, baru ba'i toabi gare yayaye beoye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Më'ë ñacogabi gu'a juchare yo'o ëaye ro'tatoca, më'ë ñacogate rutani senjojë'ën. Te'e ñacoga se'gare baguëbi Riusu ba'i jobona ti'antoca, quë'rë re'oye ba'iji. Samu ñacogañare baguëbi ba toana senjosi'quë ba'itoca, ai gu'aye ba'iji. Ja'an toare yayoye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Baru ba'i peco hua'nabi gare carajeiye beoye ba'ijënna, baru ba'i toabi gare yayaye beoye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jo'ya hua'nare huani, Riusu misabëna uanni, toabi ëoni insito, ru'ru onhuabi so'oñe bayë. Riusu bain hua'na'ga Riusuna insisi'cua sëani, toana ëosi'cua ba'iye'ru, yë'ë ro'ina ai yo'oye bayë. Ja'nca ai yo'ojën ba'itoca, quë'rë ai re'oye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Onhuabi so'ontoca, hua'ibi ai hua'i sënguë ba'iji. Gu'a onhua ba'itoca, onhua huanoma'iñe ba'itoca, hua'i sënma'iji. Gu'aji. Mësacua'ga ëñare bajën, recoyo gu'ajeiye beoye ba'ijë'ën. Sa'ñeña bojojën ba'ijë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ja'nrëbi jë'te, Jesusbi Capernaum huë'e jobobi sani, Judea yija, Jordán ziaya que ca'nco, ënsëguë eta rai ca'nco, ja'anruna saji'i. Sani, bainbi ñë'ca raijënna, baguë yo'oguë ba'ise'e'ru bacuani coca yihuoguë ye'yoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ba'iguëna, fariseo bainbi ti'an rani, Baguëni huacha sehuo güeseñu cajën, baguëni cocare ro coquejën senni achahuë: —¿Bainguëbi baguë rënjore jo'cani senjoñe poreguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Senni achajënna, Jesús sehuoguë senni achabi: —Moisesbi coca guanseni jo'caguë, ¿guere mësacuani guanseguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Senni achaguëna, sehuohuë: —Moisés coca guanseni jo'case'ere ëñato, bain rënjore jo'cani senjoñe yëtoca, bagote senjo cocare utina toyani, bagona insijë'ën, cani jo'case'e baji'i, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sehuojënna, Jesús cabi: —Mësacua achaye güecuare sëani, Moisesbi ja'an cocare mësacuani guanseni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ja'nca jo'caguëta'an, ru'rureba ba'isirën, Riusubi si'aye re'huani jo'caguë, bainre re'huaguë, ëmëguëte, romigote, re'huani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja'nca re'huani jo'cani, ën cocare guanseni jo'cabi: “Ëmëguëbi baguë pë'caguëte pë'cagote gare jo'cani, baguë rënjoni zi'inni ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ja'nca ba'iguëna, ba samucuabi te'e bainguë ba'iye'ru ba'iyë” guanseni jo'cabi Riusu. Ja'nca guanseni jo'caguëna, bacua yua samucua ba'iye'ru ba'ima'iñë. Te'e bainguë ba'iye'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ja'nca ba'ijënna, Riusu re'huani zi'nzi güesese'e sëani, ro bainbi gare quë'ñema'ija'bë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cani, ja'nrëbi huë'ena ti'anni ba'ijënna, baguëre concuabi ba coca guansese'ere ro'tani, baguëni se'e senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Senni achajënna, Jesús sehuobi: —Ëmëguëbi baguë rënjore senjoni, yeconi huejatoca, ja'anrë ba'isi'coni ai gu'aye yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Romigobi bago ënjëre senjoni, yequëni huejatoca, ai gu'aye yo'ogo, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ja'nrëbi jë'te, yequëcuabi bacua zin hua'nare rani, Jesusbi baguë ëntë sarañabi bacuana pa'roni, bacuare re'oye cani jo'caja'guë cajën, baguëni tëhuohuë. Tëhuojënna, Jesusre concuabi bacuani bëinjën cani ënsehuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ënsejënna, Jesusbi ëñani, baguëre concuani bëinguë cabi: —Zin hua'nabi yë'ëna raija'bë. Bacuare ënsema'ijë'ën. Zin hua'na recoyo ro'taye'ru ba'icua, ja'ancuabi Riusu ba'i jobo ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mësacuani ganreba caguë quëayë yë'ë: Bainbi Riusu ba'i jobona ti'añe yëtoca, zin hua'na recoyo ro'tajën ba'iye'ru yë'ëni si'a recoyo ro'taye bayë. Ja'nca recoyo ro'tama'icuabi Riusu ba'i jobona gare ti'anma'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cani ja'nrëbi, zin hua'nare cuainguë, baguë ëntë sarañabi bacuana pa'roni, bacuare re'o cocare cani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja'nrëbi, Jesusbi se'e saiguëna, yequë bainguëbi baguëna huë'huë rani, baguëna gugurini rëanni, coca senni achabi: —Ëjaguë, më'ë yua re'o bainguëre sëani, më'ëni coca senni achaguë raë'ë. Riusu ba'i jobona sani, carajeiye beoye si'arën huajëguë ba'iyete yëyë yë'ë. Baruna ti'anto, ¿guere ru'ru yo'oye baye'ne yë'ë? caguë senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Senni achaguëna, Jesús sehuobi: —¿Më'ë queaca ro'taguë, yë'ëre re'o bainguë ba'iyete caguë'ne? Riusu se'ga re'oye yo'oguë'bi ba'iji. Yequëcua re'oye yo'ocua beoyë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Më'ëbi carajeiye beoye huajëguë ba'iye yëtoca, Riusu coca guanseni jo'case'ere yo'oguë ba'ijë'ën. Riusu cocare ëñato, “Yequëni yeconi yahue bani a'ta yo'oma'ijë'ën. Bainre huani senjoma'ijë'ën. Bonsere jianma'ijë'ën. Yequëcua ba'iyete coquemajën ba'ijë'ën. Ro coqueye yo'oma'ijë'ën. Më'ë pë'caguëni pë'cagoni te'e ruiñe ëñaguë ba'ijë'ën” ja'an cocare toyani jo'case'e ba'iguëna, më'ëbi masiyë, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sehuoguëna, ba bainguëbi cabi: —Ëjaguë, Riusu coca guansese'ere yë'ë zinrënna achani yo'oguë ba'iyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Caguëna, Jesusbi baguëni oiguë ëñani, baguëni yihuoguë cabi: —Te'e yo'oye se'ga caraji më'ëre. Më'ë bonse si'ayete injani, bonse beo hua'nana ro insijë'ën. Ja'nca insitoca, Riusu bayete ai ta'yejeiye coreba coja'guë'ë më'ë. Ja'nca coja'guë sëani, yë'ëre te'e conguë, ro junni tonja'guë'ru ba'iye yë'ë naconi te'e conguë raijë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ja'nca caguëna, ba hua'guëbi achani, ai sa'ntiguë, ro recoyo oiguë, ai ba'iye bonse baguëbi ro conma'iguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Saiguëna, Jesusbi bonëjeiñe ëñani, baguëre concuani cabi: —¡Bonse ëjacuabi Riusu ba'i jobona ti'añe yëcuareta'an, ai guaja'ë bacuare! cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ja'nca caguëna, baguëre concuabi baguë cocare achani, ai sa'nti hua'na ruën'ë. Ruinjënna, Jesusbi bacuani se'e yihuoguë cabi: —Mami sanhuë. ¡Bonse ba ëaye ro'tacuabi Riusu ba'i jobona ti'añe yëcuareta'an, ai guaja'ë bacuare! ");
INSERT INTO snnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camello hua'guëbi guëna miu gojena cacaye yëtoca, ai guaja'ë baguëre. Bonse ëjaguë'ga Riusu ba'i jobona ti'añe yëtoca, quë'rë ai guaja'ë baguëre, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Caguëna, bacuabi ai achajën rëinjën, sa'ñeña senni achahuë: —Ja'nca ba'itoca, ¿jarocuabi Riusu ba'i jobona ti'añe poreye'ne? Riusu bain tëani basi'cua gare beoyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Cajënna, Jesusbi bacuani ëñani cabi: —Ro bain hua'na ja'ansi'cuabi ti'añe gare porema'iñë. Riusu se'gabi bacuare tëani baye poreji. Si'aye yo'oye poreguë ba'iguë'bi ba'iji baguë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Caguëna, Pedrobi Jesusni cabi: —Ëjaguë, yëquënabi yua yëquëna bonse si'aye gare jo'cani, më'ëni te'e conjën zi'inhuë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Caguëna, Jesús sehuobi: —Mësacuani ganreba yihuoguë cayë yë'ë: Bainguëbi baguë bonse, baguë huë'e, baguë ma'yë sanhuë, baguë yo'je sanhuë, baguë pë'caguë, baguë pë'cago, baguë rënjo, baguë zin hua'na, baguë ba'i yija, ja'anre yë'ë ro'ina, yë'ë cocareba quëani achoye ro'ina gare jo'cani, yë'ëni te'e conguë zi'intoca, ");
INSERT INTO snnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","baguë yua quë'rë se'e yure ba'irënra cien viaje'ru quë'rë coni baja'guë'bi. Huë'eña, ma'yë sanhuë, yo'je sanhuë, pë'cago sanhuë, zin hua'na, baguë ba'i yijaña, ja'anre ai coreba coni baja'guë'bi. Baguëna, yequëcuabi baguëni je'o bajënna, ai ja'siye aireba yo'oguë baja'guë'bi. Ja'nrëbi, ën yija carajeirën ti'anguëna, baguë yua gare ju'iñe beoye si'arën ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yureña bain, ai ta'yejeiye ba'icuabi quë'rë ëja bain ba'iye yëcuata'an, quë'rë yo'je ba'icua'ru re'huasi'cua ba'ija'cua'ë. Yure ba'icua quë'rë yo'je bain ba'icuareta'an, quë'rë ta'yejeiye ëja bain re'huasi'cua ba'ija'cua'ë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yureca, bacuabi ma'aja'an saijën, Jerusalén huë'e jobona ti'añe ro'tahuë. Jesusbi ru'ru saiguëna, baguëre concuabi quëquësi'cua ba'ijën, baguë yo'jena huaji yëjën be'teni saë'ë. Saijënna, Jesusbi bonëni, baguëre concua si'a sara samucuare choini, yequëcua baguëre gu'aye yo'oja'yete bacuani quëani achoni, ");
INSERT INTO snnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","bacuani yihuoguë cabi: —Yureca, maibi Jerusalenna saijënna, mësacua masiyë. Ja'anruna ti'anjënna, yequëcuabi yë'ë, Bainguë'ru Raosi'quëreba ba'iguëna, yë'ëre zeanni, pairi ëjacua, ira coca ye'yocua, bacuana preso insija'cua'ë. Insijënna, bacuabi yë'ëre huani senjoñe cani, gu'a bainna insija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Insijënna, gu'a bainbi yë'ëre jayajën, yë'ëni huaijën, yë'ëre go tutujën, ga'ni za'zabobi yë'ëre si'nsejën, ja'nrëbi yë'ëni huani senjoja'cua'ë. Huani senjojënna, ja'nrëbi, samute umuguseña ba'ini, go'ya raija'guë'ë yë'ë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Quëaguëna, ja'nrëbi, Santiago, Juan, Zebedeo mamacua ja'an hue'ecua, bacuabi Jesusna sani cahuë: —Ëjaguë, yëquënabi senjënna, yëquënani re'oye yo'ojë'ën, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cajënna, Jesusbi: —¿Mësacua guere yë'ëni senni achaye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Senni achaguëna, bacua cahuë: —Yëquënabi më'ë go'sijei re'otona ti'anni ba'ijënna, yëquënani re'oye ëñani, te'eguëni më'ë jëja ca'ncona bëa güesejë'ën. Yequëni më'ë ari ca'ncona bëa güesejë'ën, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Cajënna, Jesusbi cabi: —Mësacuabi ro huesë ëaye senni achajën ba'iyë. Yequëcuabi yë'ëni ai ja'si yo'oni, yë'ëre huani senjoja'cua'ë. ¿Mësacua güina'ru ai ja'siye ai yo'oye poreye? caguë senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Senni achaguëna, bacuabi: —Ja'nca poreyë yëquëna, sehuohuë. Sehuojënna, Jesús cabi: —Mësacua yua yë'ë ai yo'oye ba'iye'ru ai yo'ojën ba'ija'cuata'an, ");
INSERT INTO snnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","yë'ë jëja ca'ncona, yë'ë ari ca'ncona bëaye, ja'anre cuencueni caye porema'iñë yë'ë. Yë'ë Taitabi ja'anre cuencueguë, baguë se'gabi ja'anruan bëani ba'ija'cuare cuencueni caja'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja'nca caguëna, baguëre concua yequëcua si'a sara ba'icuabi achani, Santiago, Juan, bacuani bëinsi'cua ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ja'nca ëñajënna, Jesusbi si'acuare choini, yihuoguë cabi: —Ro bain ta'yejeiye ëjacuabi bacua bain, bacua yo'je ëjacua, si'acuani ai jëja guansejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ja'nca ba'icuata'an, mësacua yua ja'nca guansema'ija'cua'ë. Mësacua jubë ba'iguëbi ëja bainguë ba'iye yëtoca, më'ë gajecuani conni cuiraguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ru'ru ba'iguë ba'iye yëtoca, më'ë gajecua yo'o conguë ruinguë, si'acuare conni cuiraguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yë'ë'ga Bainguë'ru Raosi'quë'bi ba'iguë, yë'ëre conni cuiracuare cu'eguë raimaë'ë. Yequëcuani cuirani conza caguë, bain zemosi'cua etoye ro'taguë, junni tonguë raisi'quë'ë yë'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ja'nca cani tonni, Jericó huë'e jobona ti'anni, baguëre concua naconi ganini, ja'an huë'e jobobi saiguëna, ai jai jubë bainbi baguëni conjënna, ñaco ëñama'iguë, Bartimeo hue'eguëbi ma'a yëruhuate ñu'iguë, curi senguë baji'i. Timeo mamaquë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ja'nca ba'iguëbi Jesús Nazareno raiyete achani ai jëja güiguë cabi: —¡Jesús, mai ira taita David mamaquëbi ba'iguë'ru ba'iyë më'ë! ¡Yë'ëni oire bani conjë'ën! güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Güiguëna, bain hua'nabi baguëni bëinjën, Güima'ijë'ën, baguëni cahuë. Ja'nca cacuareta'an, baguë yua quë'rë se'e jëja güiguë cabi: —¡David mamaquë, yë'ëni oire bani conjë'ën! güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ja'nca caguëna, Jesusbi nëcajani, bain hua'nani: —Baguëte choijë'ën, cabi. Caguëna, bain hua'nabi ñaco ëñama'iguëte choini cahuë: —Jëja bani huëijë'ën. Ëjaguëbi më'ëre choiji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ja'nca cajënna, baguëbi yua baguë se canre tijoni senjoni, ja'nrëbi besa huëni cha'caguë, Jesusna saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Saiguëna, Jesusbi baguëni senni achabi: —¿Më'ë guere yë'ëre senguë'ne? senni achabi. Senni achaguëna, ñaco ëñama'iguëbi Jesusni: —Ëjaguë, ñaco ëñañe yëyë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sehuoguëna, Jesús cabi: —Yua huajëguë saijë'ën. Yë'ëni si'a recoyo ro'taguë sëani, huajë raë'ë më'ë, cabi. Caguëna, baguë yua te'e jëana ëñani, Jesús naconi ma'aja'an te'e conni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ja'nrëbi, Jerusalén huë'e jobona ti'an bi'rani, Betfagé, Betania, ja'an huë'e jo'borëan cueñe ba'ijën, Olivo cubë ca'ncorë ba'ijën, Jesusbi baguëre concua samucuare choini, ");
INSERT INTO snnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","coca cabi: —Mësacua yua que huë'e jo'borëna saijë'ën. Burro bonsëguë yoni rëonsi'quë, yuta bain tuama'iguë ba'iguëna, ja'an hua'guëre tinjañë mësacua. Tinjani ja'nrëbi, baguëte jo'chini rajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yequëcuabi ¿Mësacua guere yo'ojën ba burrote jo'chiye'ne? senni achatoca, mësacua yua bacuani ñaca sehuojë'ën: Mai Ëjaguëbi baguëte yëji. Jë'terë baguëte go'yaji, cajën sehuojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Caguëna, bacuabi sani ëñato, bain ba'i huë'e ma'a yëruhuate ba'iguëna, burro bonsë hua'guë yoni rëonsi'quë baji'i. Ba'iguëna, bacuabi baguëte jo'chihuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jo'chijënna, yequëcua baru ba'icuabi bacuani coca senni achahuë: —¿Mësacua guere yo'ojën, burro hua'guëre jo'chiye'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Senni achajënna, bacua yua Jesús quëase'e'ru güina'ru bacuani sehuohuë. Ja'nca sehuoni, bacuare se'e ënsema'ijënna, ba burro hua'guëte sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sani ja'nrëbi, Jesús ba'iruna ti'anni, bacua cañate burrona tëojënna, Jesusbi baguëna tuabi. ");
INSERT INTO snnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuaguëna, ai jai jubë bainbi bacua cañate baguë sai ma'ana uanjënna, yequëcuabi ju'cahuëanre tëyoni, ma'ana uanhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ai jai jubë bainbi ja'anrëna saijën, yo'jena saijën, ai bojora bojojën güihuë: —¡Ai bojoreba bojoñuni! ¡Mai ta'yejeiyereba Ëjaguë Riusu Raosi'quëbi maina ti'an raji'i! ");
INSERT INTO snnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Mai ira taita ba'isi'quë David guanseguë ba'ise'e'ru quë'rë ta'yejeiye maini guanseguë conguë raji'i baguë! ¡Riusuni ai bojoreba bojojën bañuni! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja'nca güijën cajënna, Jesusbi Jerusalenna ti'anni, Riusu uja huë'ena cacabi. Cacani, si'a ca'ncoña ba'i ma'carëanre ëñani, ja'nrëbi, na'iguëna, baguëre concua si'a sara samucua naconi Betaniana sani caën'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Canni ñatani, ja'nrëbi, Betaniabi saijënna, Jesusre aon gu'abi. ");
INSERT INTO snnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aon gu'aguëna, Jesusbi so'ona ëñato, higo sunquiñë ja'o sarisiñë baji'i. Ba'iguëna, bañëna sani uncue cu'eguëna, beobi. Higo ya'jirën yuta ti'anmaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja'nrëbi, Jesús yua bañëre bëinguë cabi: —Bainbi yua më'ë uncuere gare se'e uncueye beoye ba'ija'bë, cabi. Ja'nca caguëna, baguëre concuabi achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ja'nrëbi sani, bacuabi Jerusalenna ti'anhuë. Ti'anni, Jesusbi Riusu uja huë'ena cacani, bonse insicua, bonse cocua ba'ijënna, bacuare etoni sao bi'rabi. Curi sa'ñecua ba'ijënna, bacua mesañare bo'neni tantobi Jesús. Ju'ncubo insicua ba'ijënna, bacua ñu'i seihuëanre bo'neni tantobi. ");
INSERT INTO snnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yequëcuabi bacua bonse ma'carëanre Riusu huë'e sa'nahuëbi rë'rëjënna, Jesusbi ënsebi. ");
INSERT INTO snnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ja'nrëbi, Jesusbi bain hua'nare coca yihuo bi'rabi: —Riusu ira coca toyani jo'case'ere ëñato, ñaca caji: “Yë'ë huë'e yua si'a re'oto bain uja huë'e case'e'ë.” Ja'nca cani jo'case'eta'an, mësacuabi ro jiancua gati huë'ere yë'ë Taita huë'ere re'huahuë, bëinguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja'nca caguëna, pairi ëjacua, ira coca ye'yocua, bacuabi achani, baguëni bëinjën, Baguëni huani senjoñu cacuata'an, baguëni huani senjoñe huaji yëhuë, ai bain hua'nabi baguë ye'yose'ere ai bojojën achacuare sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ja'nrëbi na'i si'aguëna, Jesusbi ba huë'e jobobi saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sani ñataguëna, baguëre concua naconi se'e rani, ma'abi ganini ëñato, higo sunquiñë baji'i. Gare güeanni si'a sita ju'insiñë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ja'nca ba'iguëna, Pedrobi yequë umuguse case'ere ro'tani, Jesusni cabi: —Ëjaguë, ëñajë'ën. Më'ëbi ja'an sunquiñëna bënni senjoni jo'caguëna, yure hueanni ju'insiñë ba'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Caguëna, Jesusbi sehuobi: —Mësacua yua Riusuni si'a recoyo ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mësacuani ganreba yihuoguë quëayë yë'ë. Mësacua huaji yëye beoye ba'ijën, Riusu ta'yejeiye yo'oye poreyete si'a recoyo ro'tajën ba'ijë'ën. Bainbi ja'nca recoyo ro'tajën ba'itoca, bacuabi que cubëna coca guansejën: “Ja'anse'ebi quëñëni, ja'anse'ebi jai ziayana tonni runi huesëjë'ën” ja'an cocare guansejënna, Riusubi ja'nca tonni rëoni huesoji. Bainbi Riusuni te'e ruiñe si'a recoyo ro'tatoca, Riusubi bacua ujase'e'ru güina'ru yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ja'nca sëani, mësacuani ganreba yihuoyë yë'ë. Mësacuabi Riusuni coca senni achajën, Riusubi yë'ë sensi ma'carë si'aye yë'ëna ënseye beoye insiji ro'tajën ba'itoca, Riusubi si'aye gare ënseye beoye mësacuana insiji. ");
INSERT INTO snnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mësacuabi Riusuni ujajën, mësacuani gu'aye yo'osi'cua banica, bacua gu'aye yo'ose'ere huanë yeye cajë'ën. Ja'nca catoca, mësacua Taita Riusu guënamë re'oto ba'iguëbi mësacua gu'aye yo'ose'e'ga huanë yeye caji. ");
INSERT INTO snnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mësacuabi ja'nca huanë yeye cama'itoca, mësacua Taita Riusu guënamë re'oto ba'iguëbi mësacua gu'aye yo'ose'ere gare huanë yema'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cani ja'nrëbi, baguëre concua naconi Jerusalenna sani ti'anhuë. Ti'anni, Jesusbi Riusu uja huë'ena cacani, si'a ca'ncoña ganiguëna, pairi ëjacua, ira coca ye'yocua, judío bain iracua, bacuabi Jesusna tëhuoni, ");
INSERT INTO snnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","baguëni coca senni achahuë: —¿Më'ë queaca ro'taguë, ënjo'ona rani, ëjaguë yo'oye'ru yo'oguë'ne? ¿Nebi më'ëre raore'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Senni achajënna, Jesús sehuobi: —Yë'ë'ga yua mësacuani coca senni achayë. Senni achaguëna, mësacua te'e ruiñe sehuojë'ën. Ja'nca sehuotoca, ja'nrëbi, yë'ë Ëjaguë ba'iyete mësacuani quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nebi Juanni bain bautizaye raore'ne? ¿Riusu raosi'quë, o ro bain raosi'quë baquë baguë? Mësacua te'e ruiñe sehuojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Caguëna, bacuabi sa'ñeña yahue senni acha bi'rahuë: —Baguë senni achase'ere sehuoye ai huaji yaye'ë maire. Riusu raosi'quë baji'i sehuotoca, Jesusbi maini: “¿Mësacua guere yo'ojën, baguëni recoyo ro'tamate'ne?” cama'iguë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ja'nca ba'iguëna, “Bain raosi'quë baji'i” caye güeyë mai, sa'ñeña senni achajën baë'ë. Bainre huaji yëcua sëani, Bain raosi'quë baji'i caye güehuë bacua. Si'a bainbi Juan ba'ise'ere te'e ruiñe ro'tajën, Riusu bainguë raosi'quë baji'i, ro'tajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja'nca ro'tajën ba'ijënna, judío bain ëjacuabi huaji yëjën, Jesusni ñaca sehuohuë: —Juan raose'ere huesëyë yëquëna, sehuohuë. Ja'nca sehuojënna, Jesusbi bacuani cabi: —Mësacuabi ja'nca sehuotoca, yë'ë Ëjaguë ba'iyete mësacuani gare quëaye beoye ba'iyë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cani ja'nrëbi, Jesús yua ye'yo cocabi bacuani caguë, ñaca yihuoguë quëabi: —Yequë bainguëbi bisi ëye ziore tanbi. Tanni, tu'ahuëte baguë zio bonëjeiñe ta'ntani, ëye tumu ro'rohuëte gatabëna te'ntoni, ja'nrëbi ëmë huë'ere gatabi nëcobi, ba zio ëñañete. Ja'nca yo'oni tëjini, zio cuiracaicuare choini, baguë ziore bacuana jo'cani, ja'nrëbi yequë yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sani, ja'nrëbi ëye tëarën ti'anguëna, zio ëjaguëbi baguëre yo'o conguëte choini, Ëye tëase'ere injaijë'ën caguë, baguë zio cuiracuana saobi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Saoguëna, baguë yua sani ti'anguëna, bacuabi yua baguëte zeanni, huani, ro ëye beo hua'guëre saoni senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Senjojënna, ëjaguëna go'iguëna, ëjaguëbi yequë yo'o conguëte choini, zio cuiracuana saobi. Saoguëna, baguëre'ga ai gu'aye yo'ohuë. Gatabi baguëni senjojën, baguë sinjobëna huaijën, baguëte saoni senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Senjojënna, ëjaguëbi yequëre'ga bacuana saobi. Saoguëna, ba hua'guëre huani senjohuë. Huani senjojënna, ëjaguëbi yequëcuare'ga te'enate, te'enate saobi. Saoguëna, zio cuiracuabi yequëcuani gu'aye huaë'ë. Yequëcuani huani senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ja'nca yo'ojënna, ja'nrëbi, zio ëjaguëbi baguë zin ai yësi'quëre ro'tani, “Yë'ë zinre bacuana saotoca, baguëni te'e ruiñe ëñañë bacua” caguë, baguë zinre saobi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ja'nca saoguëna, zio cuiracuabi baguëte ëñani, sa'ñeña coca cahuë: “Ëñajë'ën. Mai ëjaguë zinbi rai'te. Baguë taita bayete coni baja'guëre sëani raijë'ën. Baguëni huani senjoñu. Ja'nca yo'otoca, baguë yija baja'yete coni baja'cua'ë mai” cahuë sa'ñeña. ");
INSERT INTO snnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ja'nca cani, baguëte zeanni, baguëte huani senjoni, baguë ga'nihuëte zio ca'ncona jo'cani senjohuë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Quëani ja'nrëbi, ba bain achacuani senni achabi: —Ja'nca huani senjojënna, ¿ba zio ëjaguë guere yo'oja'guë'ne? Baguë yua zio cuiracuana sani, bacuare huani senjoni, ja'nrëbi, baguë ziore yua yequëcuana cuiraye jo'caja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mësacua yua Riusu coca toyani jo'case'ere ëñajën, ¿ën cocare ëñamate'ne? Ñaca caji: Riusubi baguë gatabëte jo'caguëna, ro bain yo'o concua huë'e yo'ocuabi ba gatabëte ëñani, Gu'aji cajën, babëte senjohuë. Senjocuata'an, ba gatabëbi yua quë'rë ze'en gatabë re'huase'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mai Ëjaguë Riusubi ja'nca re'huaguëna, maibi ai ëñajën rëinjën ba'iyë, caji Riusu coca, bacuani quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ja'nca quëani tonguëna, bacuabi Jesusni ai bëinjën, Baguë ye'yo cocabi yihuoguë, maire gu'aye caji cajën, baguëni preso zean ëaye ba'icuata'an, bainni ro huaji yëjën, baguëni preso zeanmaë'ë. Baguëte ro quëñëni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ja'nrëbi jë'te, judío ëja bainbi fariseo bain, Herodes gu'a gajecua, bacuare choini, coca guansehuë: —Mësacua yua Jesusna sani, baguëni coquejën, coca senni achajë'ën. Huacha sehuoja'guë cajën, baguëni senni achajë'ën. Huacha sehuoguëna, ja'nrëbi, baguëni preso zean güeseye poreyë mai, guansejën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cajënna, bacuabi Jesusna sani, baguëni senni achajën cahuë: —Ëjaguë, yëquënabi më'ë coca masiye ye'yose'ere achani te'e ruiñereba'ë ro'tajën ba'iyë. Ro bain ye'yojën ba'iyete achama'iguë, te'e ruiñe ye'yoguë'ë më'ë. Ëja bain ye'yose'e ba'ito'ga, më'ëbi bacua ye'yose'e'ru güina'ru ye'yoma'iguë'ë. Riusu ma'ana ganiñe se'gare te'e ruiñe ye'yoguë ba'iyë më'ë. Ja'nca sëani, më'ëni coca senni achaye yëyë yëquëna. Bain ta'yejeiye ëjaguëbi impuesto curi ro'iye senguëna, ¿maibi baguëni ro'iye baye? ¿Ro'iye, o ro'ima'iñe'ne? Quëajë'ën yëquënate, senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Senni achajënna, Jesús yua bacua ro coque ëaye case'ere masibi. Ja'nca masini, bacuani sehuoguë cabi: —¿Mësacua queaca ro'tajën, yë'ëni ro coquejën, yë'ëni zemo cocare senni achaye'ne? Curi so'corëte injaijë'ën. Ëñaza, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Caguëna, bacuabi inni rani ëñohuë. Ëñojënna, baguë yua bacuani senni achabi: —¿Gue bainguë ziabi curi so'corëte së'iguë'ne? ¿Gue mami hue'eguëbi së'iguë'ne? senni achabi. Senni achaguëna, bacuabi: —Bain ta'yejeiye ëjaguë'bi së'iji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ja'nca sehuojënna, Jesusbi bacuani yihuoguë cabi: —Bain ta'yejeiye ëjaguë ba ma'carëan ba'itoca, bain ta'yejeiye ëjaguëna go'yaye insijën ba'ijë'ën. Riusu ba ma'carëan ba'itoca, Riusuna go'yaye insijë'ën, cabi. Ja'nca caguë sehuoguëna, bacuabi ai quëquësi'cua achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ja'nrëbi, yequëcua, saduceo bain hue'ecuabi Jesusna ëñajën saë'ë. Ja'ancua yua, Bain ju'insi'cuabi gare go'ya raima'icua ba'iyë, ja'nca ye'yojën ba'iyë. Ja'nca ba'icuabi Jesusna sani, baguëni coca senni achajën cahuë: ");
INSERT INTO snnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ëjaguë, Moisés ira coca toyani jo'case'ere më'ëni senni achaye bayë yëquëna. Ën cocare maina toyani jo'cabi baguë: “Bainguëbi zin beoguë banica, ja'anguëbi junni huesëtoca, baguë yo'jeguëbi baguë rënjo jo'casi'core huejaye baji. Bagote huejani, baguë ma'yëre zinre cu'ecaiye baji baguë” toyani jo'cabi Moisés. ");
INSERT INTO snnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ja'nca toyani jo'caguëna, yequë bain ba'ise'ere më'ëni quëaye bayë yëquëna. Ma'yëreba ba'iguëbi baguë yo'jecua, te'e ëntë sara te'ecua ba'ijën ba'nhuë. Ma'yëreba ba'iguëbi baguë rënjoni huejani, zin beoguëbi junni huesëguë ba'nji. ");
INSERT INTO snnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja'nca junni huesëguëna, baguë yo'jeguë samu ba'iguëbi ba hua'jegoni huejani, baguë'ga güina'ru zin beoguëbi junni huesëguë ba'nji. Junni huesëguëna, samute ba'iguëbi güina'ru bagoni huejani, zin beoguëbi junni huesëguë ba'nji. ");
INSERT INTO snnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Si'a hua'na, te'e ëntë sara samucuabi ja'nca bagoni huejani, zin beocuabi junni huesëjën ba'nhuë. Ja'nca junni huesëjënna, ja'nrëbi, bago'ga junni huesëgo ba'nco. ");
INSERT INTO snnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ja'nca junni huesësi'cuabi se'e go'ya raitoca, ¿bago yua jaroguë rënjo ba'ija'go'ne? Si'acua, te'e ëntë sara samucuabi bagoni basi'cua sëani, ¿më'ë guere quëaguë'ne? baguëni senni achani, baguë huacha sehuoja'ye ëjojën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ëjojën nëcajënna, Jesusbi bacuani sehuoguë cabi: —Mësacua yua ai huacha ro'tajën ba'icua'ë. Riusu cocareba toyani jo'case'ere gare huesëjën ba'icua'ë. Riusu ta'yejeiye yo'o yo'oye poreyete gare huesëjën ba'icua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bain junni tonsi'cuabi go'ya raijën, sa'ñeña gare huejama'icua ba'iyë. Bacua romi zincuare yequëcuana huejaye gare jo'cama'icua ba'iyë. Riusu guënamë re'oto yo'o concua'ru ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yeque cocare'ga mësacuani yihuoye bayë yë'ë. Mësacua yua Moisés toyani jo'casi pëbëte anconi, toa zëinsi sahua quë'rona ëñani, bain ju'insi'cua go'ya raiyete ye'yejë'ën. Riusubi yua Moisesni ñaca quëabi: “Yë'ë yua quë'rë ta'yejeiyereba Riusu ba'iguë'ë. Më'ë ira bain ba'isi'cua Abraham, Isaac, Jacob, ja'ancuabi yureña yë'ëni recoyo te'e zi'inni ba'icua'ë” quëabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ja'nca quëasi'quë sëani, bain junni huesësi'cuabi Riusuni recoyo zi'iñe beoye ba'iyë. Bain huajëcua, junni tonni go'ya raisi'cua, ja'ancuabi Riusuni recoyo te'e zi'inni ba'icua'ë. Ja'nca ba'icua sëani, mësacuabi ai huachareba huacha ro'tajën ba'iyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ja'nca caguëna, yequë, ira coca ye'yoguëbi Jesús coca yure ye'yose'ere achani, Ai re'oye masiye sehuobi caguë, Jesusni coca senni achabi: —Riusu coca guanseni jo'case'ere cato, ¿Gue cocabi quë'rë ta'yejeiye ba'i coca ba'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Senni achaguëna, Jesús sehuobi: —Quë'rë ta'yejeiye ba'i coca yua ëñe ba'iji: “Achajë'ën, Israel bain. Mai Ëjaguë Riusubi yua gañaguë'bi ba'iji. Yequë ëjaguë beoji. ");
INSERT INTO snnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ja'nca ba'iguëna, më'ë Ëjaguë Riusuni ai yëreba yëguë ba'ijë'ën. Më'ë recoyo, më'ë ro'taye, më'ë ba'iye, ja'anbi më'ë porese'e'ru si'a jëja baguëni ai yëreba yëguë ba'ijë'ën” maina guanseni jo'case'e ba'iji. Ja'an coca guanseni jo'case'e yua quë'rë ta'yejeiye ba'i coca'ë cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yeque coca ai ta'yejeiye ba'i cocare'ga maina guanseni jo'case'e ba'iji. Ëñe ba'iji: “Më'ë te'e bainni ai yëreba yëguë ba'ijë'ën. Më'ë ja'ansi'quë yëguë ba'iye'ru më'ë te'e bainni ai yëreba yëguë ba'ijë'ën” guanseni jo'case'e ba'iji. Yeque guanseni jo'casi cocare cu'eto, quë'rë ta'yejeiye ba'i coca beoji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Caguëna, ba ira coca ye'yoguëbi Jesusni cabi: —Ai masiye quëahuë më'ë, Ëjaguë. Te'e ruiñereba ba'iji më'ë coca ye'yose'e. Mai Ëjaguë Riusu yua gaña Ëjaguë'bi ba'iji. Yequë ëjaguë beoji. Ja'anre caguë, te'e ruiñe quëahuë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mai Ëjaguë Riusuni ai yëreba yëjën, mai recoyo, mai ro'taye, mai ba'iye, ja'anbi mai porese'e'ru si'a jëja baguëni ai yëreba yëjën bañuni. Mai te'e bainre'ga ja'ansi'cua yëye'ru ai yëreba yëjën bañuni. Ja'nca yëjën ba'itoca, Riusubi si'a mai misabëna ëoni insiye, ja'anna bojoye'ru quë'rë ta'yejeiye bojoguë ëñaji maire, cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Caguëna, ja'nrëbi, Jesús yua baguë case'ere achani cabi: —Te'e ruiñe masiye sehuohuë më'ë. Ja'nca yëguë ba'itoca, Riusu ba'i jobona ti'añe ba'ija'guë'ë më'ë, cabi Jesús. Ja'nca caguëna, ja'nrëbi, bain hua'nabi Jesusni se'e coca senni achaye gare huaji yëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja'nrëbi, Jesusbi Riusu uja huë'ere ba'iguë, bainre coca ye'yoguë cabi: —Ira coca ye'yocuabi Riusu Raosi'quëreba ba'iguë, Cristo hue'eguëte bainni quëajën, Mai ira taita David, ro baguë mamaquë se'ga ba'iji Cristo, quëajën, ro huacha ro'tajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Riusu Espíritubi Davidni ro'ta güeseguëna, Davidbi ñaca cani jo'cabi: Riusubi yë'ë Ëjaguëni cabi: “Yë'ë jëja ca'ncona bëani, më'ë je'o carajei ñësebë tëca ba'ijë'ën” cani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja'nca cani jo'caguëna, Cristo raosi'quëre baguë mamaquë caye poremaji'i, baguëte Ëjaguë casi'quë sëani, ye'yoguë cabi Jesús. Ja'nca caguëna, bain hua'na ai jai jubë ba'icuabi baguëni ai bojojën achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja'nrëbi, Jesusbi se'e ye'yoguë, ñaca cabi: —Ira coca ye'yocuabi coca ye'yojënna, mësacua yua ëñare bajën, bacuare achamajën ba'ijë'ën. Ëja bain ba'iye se'ga ëñoñe yëyë bacua. Zoa can re'o canre sayani, si'aruanna ëño ëaye ba'ijën ganiñë bacua. Bainbi re'oye achoye saludajënna, ai acha ëaji bacuare. ");
INSERT INTO snnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bain ñë'ca huë'eñana sani, ëja bain bëaruan se'gare cu'ejën ba'iyë. Aon fiestana sani, quë'rë re'oruan se'gare cu'eni bëayë bacua. ");
INSERT INTO snnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ja'nca ba'icuata'an, hua'je hua'nani ro coquejën, bacua huë'eñare ro tëteni bayë. Riusuni zoe coca ujajën, Bain ëñaja'bë caye se'ga ba'ijën, ro coqueyë. Ja'nca yo'ojënna, Riusubi bacuani quë'rë ta'yejeiye bënni senjoja'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ja'nrëbi jë'te, Jesusbi Riusu huë'e curi gajongu ba'iruna sani, ca'ncorëna bëani ëñato, bain hua'nabi bacua curire Riusuna insijën, gajonguna ayajën baë'ë. Yequëcua curi ëjacuabi ai ta'yejeiye ai curire ayajën insihuë. ");
INSERT INTO snnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ja'nca insijënna, ja'nrëbi, hua'je hua'go bonse beo hua'gobi rani, samu curi so'corëan, te'e centavo ro'irëan, ja'an se'gare ayago insigo. ");
INSERT INTO snnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Insigona, Jesusbi baguëre concuare choini, bacuani cabi: —Mësacuani ganreba quëayë yë'ë. Ja'an hua'je hua'go bonse beo hua'gobi bago curire Riusuna insigo, si'a bain insiye'ru quë'rë ta'yejeiye insigo bago. ");
INSERT INTO snnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bacuabi a'ta curire bajën, ro bacua jëhuase'e se'gare ayajën insiyë. Bagoca bonse beo hua'gobi bago gaña so'corëanre insini si'ago, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ja'nrëbi, Jesusbi Riusu huë'ebi eta bi'raguëna, baguëte conguë te'eguëbi baguëni cabi: —¡Ëjaguë, ëñajë'ën! ¡Ën huë'e ai re'o huë'e bëaji! ¡Ai re'o gatabi re'huase'e ba'iji! bojoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Caguëna, Jesús sehuoguë cabi: —Më'ëbi ën huë'eña jai huë'eñare ëñaguë, yë'ë quëayete te'e ruiñe achajë'ën. Si'a huë'eñare ëñaguë, yë'ë quëayete te'e ruiñe achajë'ën. Si'a huë'eña yua ñañoni taonsi huë'eña ba'ija'guë'bi. Gare te'e gatabë tuiye beoye ba'ija'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cani ja'nrëbi, Olivo casi cubë, Riusu huë'e ca'ncorëte ba'iguëna, bacuabi mëni bëahuë. Bëani ja'nrëbi, Pedro, Santiago, Juan, Andrés, bacuabi Jesusni tëhuo rani, baguëni yahue senni achahuë: ");
INSERT INTO snnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Riusu huë'e quejeito tanni huesëguë'ne? ¿Më'ë coca yure quëase'e'ru ba'ija'ye queaca masiye poreye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Senni achajënna, Jesús sehuobi: —Mësacua ëñare bajë'ën. Yequëcuabi mësacuani ro coquema'iñe cajën, mësacua ëñare bajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bainre coquecua ai jai jubë ba'icuabi rani, “Riusu Raosi'quëreba'ë yë'ë. Ba Cristo'ë yë'ë” cajën, ro coquejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mësacua yua si'aruan guerra huayete achajën, quëquëye beoye ba'ijë'ën. Bain guerra huaja'ye yuara cuencuese'e ba'iguëna, ën yija carajeirën yuta ti'anma'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bain jubëan yua sa'ñeña ai guerra huani ai yo'oja'cua'ë. Si'aruan yija ñu'cueye, aon gu'ana ju'iñe, ja'anna ai yo'ojën, yuta quë'rë se'e ai yo'ojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mësacuaca ai ëñare bajë'ën. Yequëcuabi mësacuare preso zeanni, ëja bain ñë'casiruanna nëconi, mësacuare gu'aye caja'cua'ë. Mësacuare bain ñë'ca huë'eñana sani, mësacuani gu'aye huaija'cua'ë. Mësacua yua yë'ë cocare quëani achocuare sëani, ëja bain ba'iruan, ta'yejeiye ëjacua ba'iruan, ja'anruanna mësacuare rërëni sani nëcojënna, mësacuabi nëcani coca sehuojën ba'ija'cua'ë. Ja'nca nëcani sehuojën, yë'ë ba'iyete bacuani te'e ruiñe quëani achoye poreja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ën yija carajeirën ti'anguëna, ru'ru si'a joboña bainbi Riusu cocarebare achaye bayë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mësacuare preso zeanni nëcojënna, mësacua coca sehuoja'yete ru'ru ro'tamajën, huaji yëye beoye ba'ijë'ën. Mësacua sehuorën ti'anguëna, Riusubi mësacua coca sehuoja'yete quëaji. Mësacua se'gabi sehuo cocare ro'tama'ija'cua'ë. Riusu Espíritubi mësacuani quëaguëna, ja'an cocare sehuoja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ën yija carajeirën ti'anguëna, bainbi bacua yo'jecuani preso zeanni bacuare huani senjo güeseyë. Pë'caguë sanhuë'ga bacua zin hua'nare preso zeanni huani senjoja'cua'ë. Yequëcua'ga bacua pë'caguë sanhuëre preso zeanni huani senjo güeseja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mësacua yua yë'ë bainrebare sëani, si'a bainbi mësacuani ai je'o ëñaja'cua'ë. Je'o ëñaja'cuata'an, yë'ëni si'a recoyo jo'caye beoye ro'tajën ba'ijë'ën. Ja'nca ro'tatoca, carajeirën ti'anguëna, Riusubi mësacuani tëani baja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Riusu bainguë ja'anrë raosi'quë Daniel hue'eguë, ja'anguëbi carajeirën ba'ija'guë, ba gu'aye ñu'ñujei güeseni si'aja'guë, ja'anguëte cani toyani jo'cabi. Ro bainbi ja'anguëte inni sani, Riusu bain ñë'ca huë'ena nëconi baja'cua'ë. Ën cocare ëñacuabi te'e ruiñe ye'yeni masija'bë cayë. Ja'nca nëconi bajënna, Judea yija ba'icuabi yua cu re'otona sani gatija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yequëcua bacua huë'e ëmëje'en ba'irute banica, bacua huë'e bonsere injën gajema'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yequëcua huë'e jobo ca'ncoña ba'icua, ziore ba'icua banica, bacua cañate injën go'ima'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Romi hua'na zinbë ba'icua, zin chuchajën ba'icua, ja'ancua banica, ¡bacuare ai ta'yejeiye ai yo'ojën ba'ija'cua'ë! ¡Chao hua'na! ");
INSERT INTO snnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bacua sani gatija'rën ti'anguëna, Sësërën ba'ima'ija'ñe cajën, Riusuni ujajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ja'an umuguseña ti'anguëna, bainbi ai ta'yejeiye ai yo'ojën ba'ija'cua'ë. Bainbi si'a Riusu re'huani jo'casi umuguseña ai yo'ojën ba'ise'e'ru quë'rë ta'yejeiye ai yo'ojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja'nca ai yo'ojën ba'ijënna, mai Ëjaguë Riusubi, Zoe ai yo'oma'iñe caji. Cama'itoca, si'a bainbi gare huesëni si'are'ahuë. Riusu bainreba cuencuesi'cuani ai yëguë sëani, bainbi zoe ai yo'oma'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ja'an umuguseña ti'anguëna, yequëcuabi mësacuani coque ëaye yo'ojën ba'ija'cua'ë. Bacua coca, “Ëñajë'ën. Querëte ba'iji” o “Ëñajë'ën. Cristobi ënjo'onre ba'iji” ja'anre catoca, bacuani achamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jai jubë bain, Cristo'ë yë'ë, cacua, Riusu raosi'quë'ë yë'ë cacua, ja'ancuabi rani, bainni ro coquejën, Riusu ta'yejeiye masini ëñoñe'ru ëñojën, Riusu bain cuencuesi'cuare'ga coquejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ja'nca coquejën ba'ija'cuabi raijënna, yë'ëbi mësacuani ru'ru quëaguëna, bacua coca coqueja'yete ëñare bajën, achamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ja'an umuguseña ti'anguëna, bainbi ai yo'ojën carajeijënna, ja'nrëbi, ënsëguëbi gare na'ini huesëja'guë'bi. Ñañaguë'ga gare se'e miama'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma'choco hua'i'ga guënamë re'otobi tonni huesëjën ba'ija'cua'ë. Guënamë re'oto si'a re'otobi ai jëja ñu'cueja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja'nrëbi, pico re'otona ëñato, yë'ë, Bainguë'ru Raosi'quëbi ai ta'yejeiye ba'iguë, ai go'sijeiye ba'iguë, yijana gaje meni ëñoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gaje meni ëñoni yua yë'ë guënamë re'oto yo'o con hua'nani coca guanseguë caja'guë'ë: “Mësacua si'a yija ca'ncoña, si'a guënamë ca'ncoña, si'aruanna sani, yë'ë bainreba cuencuesi'cuare ñë'coni rajë'ën” guanseguë caja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mësacua yua higo sunquiñë ja'o sariyete ëñani ye'yejë'ën. Ja'añëbi juinja cabëanbi irani, ja'nrëbi ja'o sari bi'raji. Sari bi'raguëna, mësacuabi ëñani, Ënsërënbi ti'anji cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yë'ë coca yure case'ere'ga ro'tajën, ja'an ba'ija'yete ti'anguëna, güina'ru, mësacua yua, Carajei umuguseña ti'anbi cajën, ja'anre masijën ba'ijë'ën, te'e jëana ti'anja'ñe sëani. ");
INSERT INTO snnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mësacuani ganreba yihuoguë quëayë yë'ë. Yureña bainbi yuta junni huesëma'ijënna, yë'ë coca case'e'ru si'aye ru'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Guënamë re'oto, yija re'oto, ja'anbi gare carajeiguëta'an, yë'ë cocareba cani jo'case'ebi yua carajeiye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ja'an umuguse ba'ija'ye, ja'an hora ba'ija'ye, ja'anre senni achatoca, bainbi gare huesëjën ba'iyë. Riusu guënamë re'oto yo'o con hua'na'ga gare huesëjën ba'iyë. Yë'ë'ga, Riusu Zin ba'iguëca gare huesëguë ba'iyë. Taita Riusu se'gabi masiji. ");
INSERT INTO snnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ja'nca ba'iguëna, mësacuaca ëñajën ba'ijën, Riusuni jo'caye beoye ujajën ba'ijë'ën. Ba joë ba'irën ti'anja'ñe huesëcua sëani, ja'nca ëñajën ëjojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bainguë so'o yijana saiyete ro'tani ye'yejë'ën. Ru'ru, baguëre yo'o concuare choini, baguë huë'ere cuiracaiye guanseni, si'acuani bacua yo'ore guanseni, ja'nrëbi baguë huë'e anto sa'ro cuiraguëni, Yë'ë raiyete ai ëñaguë ëjoguë ba'ijë'ën cani, ja'nrëbi bacuare jo'cani saiji. ");
INSERT INTO snnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mësacua'ga güina'ru ëñajën ëjojën ba'ijë'ën. Ba huë'e cuiracuabi bacua ëjaguë raija'yete huesëyë. Mësacua'ga yë'ë ti'an raija'rënre huesëyë. Ënsëguë ruajairën, ñami jobo, cura yu'irën, zijeirën, ¿quejeito ti'an raiguë'ne? cajën, mësacuabi huesëyë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yequërë cainsi hua'nabi yë'ë ti'an raija'rën ëñamajën ba'itoca, yë'ëbi te'e jëana ti'an rani, mësacuare ëñani bojoma'iñë. ");
INSERT INTO snnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mësacuani yihuoye'ru si'a bainni yihuoreba yihuoguë cayë yë'ë: Yë'ë ti'an raija'rënre ëñajën ëjojën ba'ijë'ën, yihuoguë cani jo'cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ja'nrëbi, judío bain pascua umuguse, bacua aon huo'coma'ise'e aiñe, ja'an umuguse yuta samu umuguseña carabi. Pairi ëja bain, ira coca ye'yocua naconi ñë'cani, Jesusni yahue preso zeañu cajën, Baguëni huani senjoñu cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ja'nca ba'icuabi sa'ñeña cahuë: —Fiesta ta'yejei umuguse ba'itoca, baguëni preso zeañe porema'iñë. Zeantoca, bain hua'nabi ai jai jubë ba'ijën, yequërë maire coca huajën ënsema'iñe, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yureca, Jesusbi Betania huë'e jobore baji'i. Simón hue'eguë, ira ca'mi raure junni huajë raisi'quë, baguë huë'ere baji'i Jesús. Ja'nca ba'iguëbi aon ainguë ñu'iguëna, romigobi ti'ango. Ma'ña re'co, nardo casi re'co alabastro gata ro'rohuëna rago. Ai roji'i ba re'co. Ja'anre rani, ja'nrëbi, ro'rohuëte hua'huani, ba re'core Jesús sinjobëna jañuni tongo. ");
INSERT INTO snnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jañuni tongona, yequëcua barute ñu'icuabi bëinjën ëñahuë. Bëinjën ëñacuabi sa'ñeña coca cahuë: —¿Queaca ro'tago bago, ba ma'ña re'core ro jañuni tonni huesogo'ne? Ai gu'aye yo'ogo bago. ");
INSERT INTO snnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ba re'core bendietoca, samute cien denario so'core coni, bonse beo hua'nana ro insiye porere'ahuë, sa'ñeña cajën, bagoni bëinjën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bëinjën ëñajënna, Jesusbi cabi: —Mësacua yua bago yëse'e yo'ogona, ënseye cama'ijë'ën. Ma'ña re'core yë'ëna jañuni tongo, ai re'oye yo'ogo bago. ");
INSERT INTO snnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bonse beo hua'nare cato, mësacua naconi si'arën ba'ijënna, mësacua yëse'e'ru bacuani re'oye yo'oye poreyë. Yë'ëca mësacua naconi zoe ba'ima'iñë ënjo'on. ");
INSERT INTO snnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ja'nca ba'iguëna, ëncobi bago porese'e'ru yë'ëni re'oye yo'ogo. Yë'ë junni tanja'ñete ro'tago, yë'ë ga'nihuëte ma'ña re'cobi ru'ru re'huago. ");
INSERT INTO snnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mësacuani ganreba yihuoguë quëayë yë'ë. Yë'ë bainbi Riusu cocarebare si'aruanna quëani achojën, ënco ba'iyete gare huanë yema'iñe cajën, bago yure yo'ose'ere'ga quëani achojën ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ja'nrëbi, Judas Iscariote hue'eguë, Jesusre concua jubë ba'iguëbi, yua pairi ëja bainna sani, Jesusre mësacuana preso insijaza caguë, bacua naconi coca senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Senni achaguëna, bacuabi, Curire më'ëna ro'iyë cajën, baguë senni achase'ere bojohuë. Ja'nca bojojënna, Judasbi sani, Jesusre insini senjoñete re'huajaza caguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ja'nrëbi, judío bainbi, Aon huo'coma'ise'ere aiñu cajën, ja'an fiesta umugusebi ti'anguëna, bacua pascua aonre re'hua bi'rahuë. Oveja jo'yare huani, Riusubi yi'eni bojoja'guë cajën, ja'an hua'ire boye ro'tahuë. Ja'nca ro'tajën yo'ojënna, Jesusre concuabi baguëni senni achahuë: —¿Mai pascua aon aiñe jarona sani re'huaye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Senni achajënna, baguë yua samucua baguëre concuare choini, bacuani guanseguë cabi: —Mësacua yua huë'e jobona saijë'ën. Sani ti'anjënna, ocobë cuanguëbi mësacuani tëhuoja'guë'bi. Tëhuoguëna, baguë naconi saijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Baguë ba'i huë'ena cacaguëna, mësacua yua ba huë'e ëjaguëni ñaca quëajë'ën: “Mai Ëjaguëbi më'ëni coca senni achaguë raobi: ¿Jaro sonohuëna cacani, yë'ëre concua naconi pascua aonre aiñe'ne yë'ë?” Ja'an cocare ba huë'e ëjaguëni senni achajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Senni achajënna, ja'nrëbi, baguë yua mësacuare samu ba'i huë'ena mëani, ëmëje'en ba'i sonohuë jai sonohuëte mësacuani ëñoja'guë'bi. Ja'nca ëñoguëna, mësacua ja'anruna cacani, mai pascua aonre re'huajë'ën, guanseguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Caguëna, baguëre concua saosi'cuabi huë'e jobona sani ti'anjënna, Jesús quëase'e'ru güina'ru baji'i. Ba'iguëna, ba huë'e sonohuëna cacani, bacua pascua aonre re'huahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Re'huajënna, ja'nrëbi, na'i si'aguëna, Jesusbi baguëre concua si'a sara samucua naconi ti'anni, ");
INSERT INTO snnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","bëani, ba aonre ain bi'rani, bacuani coca quëa bi'rabi: —Mësacuani ganreba quëayë yë'ë. Mësacua jubë ba'iguëbi, yë'ë naconi te'e aonre ainguë ñu'iguëbi, ja'anguëbi yua yë'ëni ro coqueguë, yë'ëre yequëcuana preso insini senjoja'guë'bi, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ja'nca quëaguëna, bacuabi ai sa'ntijën, te'ena, te'ena baguëna cueonni, baguëni senni acha bi'rahuë: —¿Yë'ë'ye? ¿Yë'ë'ye? ¿Yë'ëbi ba'ija'guë'ye? baguëni senni acha bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Senni achajënna, bacuani sehuobi: —Mësacua jubë si'a sara samucua ba'i jubë ba'iguë, yë'ë naconi te'e guëna re'ahuana aon ainguë, ja'anguëbi yë'ëre insini senjoja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Riusu coca toyani jo'case'ere ëñato, yë'ë yua Bainguë'ru Raosi'quëreba ba'iguëbi junni toñe ba'ija'ye quëaji. Ja'nca quëase'eta'an, yë'ëre insini senjoja'guëte ai bëiñe cani jo'case'e ba'iji. ¡Baguë bënni senjoja'ñete ro'tato, chao hua'guë ai yo'oja'guë'bi! Baguë të'ya raise'e beonica, quë'rë re'oye ba'ire'abi baguëre, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja'nrëbi, bacua aonre ainjënna, Jesusbi ba jo'jo aonbëte inni, Riusuni ujaguë, Surupa cabi. Cani ja'nrëbi, aonbëte jë'yeni, baguëre concuana huo'hueni, bacuani cabi: —Mësacua coni ainjë'ën. Yë'ë ga'nihuë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cani ja'nrëbi, baguë uncu ro'rohuëte inni, se'e Riusuni ujaguë, Surupa cani, ja'nrëbi ba uncu ro'rohuëte bacuana insini, si'acuabi coni uncuhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uncujënna, bacuani cabi: —Yë'ë zie meni tonse'e'ë. Ai jai jubë bain gu'a juchana zemosi'cuare tëani baza caguë, bainni mame coca jia'noni jo'caja'guë'ë yë'ë. Ja'an ro'ire yë'ë zie yua meni tonse'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yureca, mësacuani te'e ruiñe quëayë: Bisi ëye gonore gare se'e uncuma'iñë yë'ë ënjo'on. Riusu ba'i jobona ti'anni, ja'nrëbi ba mame gono re'huase'ere uncuni bojoja'guë'ë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Caguëna, ja'nrëbi, Riusuni bojojën gantani, bacuabi yua Olivo casi cubëna saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sani, Jesusbi bacuani quëabi: —Yure ñami, mësacua si'acuabi, yë'ëre gu'a güeye ro'tajënna, yë'ëre ro jo'cani senjoñë. Riusu coca toyani jo'case'e'ru güina'ru yo'oyë mësacua. Ën coca toyani jo'case'e ba'iguëna, mësacua achajë'ën: “Oveja ëjaguëni huani senjojënna, oveja jo'ya hua'nabi ro gatini saiyë” toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ja'nca huani senjosi'quë ba'ija'guëbi yua go'ya raija'guë'ë yë'ë. Go'ya rani ja'nrëbi, Galilea yijana mësacua ru'runa sani, mësacuare tëhuoja'guë'ë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Caguëna, ja'nrëbi, Pedrobi baguëni cabi: —Si'acuabi më'ëre gu'a güeni jo'cani senjocuata'an, yë'ëca bañë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Caguëna, Jesús yua baguëni cabi: —Më'ëni ganreba quëayë yë'ë. Yure ñami, curabi yuta samu ba'iye yu'ima'iguëna, më'ëbi samute ba'iye yë'ëre huesëye caja'guë'ë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Caguëna, Pedrobi si'a jëja sehuoguë cabi: —Ja'nca yo'oma'ija'guë'ë yë'ë. Më'ë naconi te'e junni tonza ru'ru, cabi. Caguëna, si'acuabi Jesusni güina'ru cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ja'nrëbi jë'te, jo'ya re'ohuë, Getsemaní casiruna ti'anjënna, Jesusbi baguëre concuani cabi: —Mësacua yua ënjo'ona bëani ëjojë'ën. Yë'ë ujaguë saiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cani ja'nrëbi, Pedro, Santiago, Juan, bacuare quë'rë so'orë sabi. Ja'nca saguëbi recoyo ai sa'ntireba sa'ntiguë, ai yo'oguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ja'nca ba'iguëbi bacuani cabi: —Ai recoyo sa'ntiye huanoji yë'ëre. Junni toñe'ru ba'iji yë'ëre. Ja'nca ba'iguëna, mësacua yua ënjo'ona bëani, ëñajën ëjojën ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cani ja'nrëbi, se'erë quëñëni, yijana gugurini rëanni, Riusuni senreba senji'i: —Taita, më'ëbi porenica, yë'ë ai yo'oni junni tonja'ñe jëayete yë'ëre ëñojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yë'ë Taita, më'ëbi si'aye yo'oye poreyë. Yë'ë ai yo'oja'ye yurera ti'anguëna, më'ëbi yë'ëre tëaye poreyë. Ja'nca poreguëta'an, ro yë'ë yëse'e se'gare yo'oma'ijë'ën. Më'ë yëse'e yo'ojë'ën, ujaguë senji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Senni ja'nrëbi, baguë concuare jo'casiruna go'ini ëñato, cainsi hua'na uën'ë. Ja'nca uijënna, Jesusbi Pedroni bëinguë cabi: —Simón, ¿më'ë guere yo'oguë cainguë'ne? ¿Rëño ñë'serë se'ga huajëguë ëjoye poremaquë? ");
INSERT INTO snnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Zupaibi coquema'ija'guë cajën, ëñajën ujajën ba'ijë'ën. Mësacua recoyo jëja bacuata'an, mësacua ga'nihuëte pa'npaye se'ga ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cani ja'nrëbi, se'e ujaza caguë quëñëbi. Quëñëni, baguë ja'anrë ujase'e'ru güina'ru ujabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ujani, ja'nrëbi se'e go'ini ëñato, baguëre concua ai ëo canni ju'incua sëani, yua se'e cainsi hua'na uën'ë. Ja'nca uincuabi sëtani, Jesusni coca sehuoye ro'tamajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ba'ijënna, Jesusbi se'e ujaguë sani, ja'nrëbi se'e go'ini, bacuani cabi: —¿Mësacua yua zoe canni huajëye ro'taye? Yureca, re'oji. Yë'ë, Bainguë'ru Raosi'quëreba ba'iguëte preso zeañe ti'anbi. Yureca, yequëcuabi yë'ëre preso zeanni, yë'ëre gu'a bainna insini senjoja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ja'nca sëani, huëijë'ën. Saiñu. Yë'ëre insini senjoja'guëbi yuara ti'anji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ja'nca caguë, baguëre concuani yuta coca cani tëjima'iguëna, Judas hue'eguëbi ti'anbi. Jesusre concua si'a sara samucua ba'i jubë ba'iguëbi baji'i. Ja'anguëbi yua yequëcua naconi ai jai jubë bain guerra hua hua'tiña, bain huai cabëan, ja'anre bajën, Jesusni zeanjën raë'ë. Pairi ëjacua, ira coca ye'yocua, judío bain ira ëjacua, bacuabi raojënna, raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja'nca raijënna, Judasbi Jesusre insini senjoñe ro'taguë, yua ba bainni ru'ru ën cocare quëasi'quë baji'i: —Jesús ba'iruna ti'anni, baguëni muchaguë saludayë yë'ë. Ja'nca saludaguëna, ja'anguëni zeanni bajën, ëñajën ba'ijën, baguëte preso sajë'ën, quëasi'quë baji'i Judas. ");
INSERT INTO snnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ja'nca quëasi'quëbi Jesús ba'iruna ti'anni, Jesusni tëhuoni saludaguë cabi: —¿Ba'iguë më'ë, Ëjaguë? cani, ja'nrëbi baguëni muchabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ja'nca muchaguëna, ja'nrëbi, Jesusre preso zeanni sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sajënna, ja'ansirën, Jesús naconi ba'iguëbi baguë guerra hua hua'tire rutani, pairi ta'yejeiye ëjaguë yo'o conguëni huani, baguë ganjorote cue'reni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja'nrëbi, Jesús yua baguëte zeancuani cabi: —Mësacua yua guerra hua hua'tiñare bajën, bain huai cabëanre bajën, ¿queaca ro'tajën, jiansi'quë ba'iguëreta'an, yë'ëni yahue preso zeanjën rate'ne? ");
INSERT INTO snnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mësacua naconi si'a umuguseña Riusu uja huë'ere baë'ë yë'ë. Ja'nca ba'iguëbi mësacuani coca ye'yoguë ba'iguëna, mësacuabi yë'ëre gare preso zeanmajën baë'ë ja'anrë. Ja'nca ba'ise'eta'an, Riusubi baguë coca toyani jo'case'e'ru yë'ëre preso zeañe ënsema'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Caguëna, baguëre concuabi baguëte jo'cani senjoni, ro gatini saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ja'nrëbi yequë, bonsëguëbi Jesús naconi te'e saiguëbi baji'i. Ga'ne can se'gare ju'iguëna, Jesús zeansi'cuabi bonsëguëte zeanjënna, ");
INSERT INTO snnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","baguë canre jo'cani senjoni, can beohuë gatini saji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ja'nrëbi, preso zeansi'cuabi Jesusre sani, pairi ta'yejeiye ëjaguë ba'iruna nëcohuë. Nëcojënna, pairi ëjacua, judío bain ira ëjacua, ira coca ye'yocua, bacuabi ñë'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro'ga Jesusre so'orë be'teguë, yua pairi ta'yejeiye ëjaguë huë'e yija tëca ti'anbi. Ti'anni, soldado hua'na naconi bëani, bacua toana cuin bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Cuin bi'raguëna, pairi ëjacua, si'a ëja bain ñë'casi'cua naconi, bacuabi Jesusre huani senjoñe cañu cajën, baguë gu'aye yo'ose'ere cu'ejën ba'icuata'an, baguëte gu'aye caye ti'anmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yequëcuabi ro coquejën, baguë gu'aye yo'ose'ere tinja cajën, bacua yua te'e camaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yequëcua'ga nëcani, baguë yo'oguë ba'ise'ere coquejën quëahuë: ");
INSERT INTO snnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Baguëbi gu'aye caguëna, yëquënabi achahuë: “Riusu uja huë'e, bain yo'osi huë'ere taonni senjoja'guë'ë yë'ë. Taonni senjoni ja'nrëbi, samute umuguseñabi yequë huë'e, bain yo'oma'isi huë'ere yo'oja'guë'ë yë'ë” cabi baguë, coquejën quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ja'nca quëacua'ga gare te'e quëamaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ja'nrëbi, pairi ta'yejeiye ëjaguëbi bacua jobona nëcani, Jesusni senni achabi: —¿Gare sehuoye beoye ba'iguë më'ë? Bacuabi më'ë gu'aye yo'ose'ere quëajënna, ¿më'ë guere yo'oguë sehuoma'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Senni achaguëna, Jesús gare caye beoye nëcabi. Gare sehuoye beoye baji'i. Ja'nca ba'iguëna, pairi ta'yejeiye ëjaguëbi baguëni se'e senni achabi: —¿Më'ë yua ba Cristo Raosi'quë'guë? ¿Mai Ëjaguë Riusu Zin'guë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Senni achaguëna, Jesús sehuobi: —Ja'nca ba'iguë'ë yë'ë. Mai ta'yejeiyereba Ëjaguë Riusubi baguë Bainguë'ru Raoja'guëre yë'ëre re'huani raoguëna, baguë jëja ca'ncona bëani ba'ija'guë'ë yë'ë. Pico re'otobi gaje meni raija'guë'ë yë'ë. Ja'nca ba'iguëna, mësacuabi yë'ëre ëñaja'cua'ë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ja'nca caguëna, pairi ta'yejeiye ëjaguëbi bëinreba bëinguë, baguë cañate ye'reguë cabi: —¡Yua baguë gu'a jucha quëacuare se'e cu'ema'ina'a! ");
INSERT INTO snnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Baguëbi yure gu'aye caguëna, mësacua achahuë. Riusuni gu'aye casi'quëre sëani, ¿mësacua gue si'nseyete caye'ne? senni achaguë cabi. Caguëna, si'a jubëbi baguëni huani senjo güeseñu cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cajënna, yequëcuabi baguëre go tutuni, ja'nrëbi, baguë ziare canbi huenni ta'pini, baguëni cuehuë. Ja'nca cuejën, baguëni jayajën cahuë: —¿Nebi më'ëni cuere'ne? Masiye ëñajë'ën, cahuë. Soldado hua'na'ga Riusu huë'ere ëñacuabi baguë ziare cuejën huaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ja'nrëbi, Pedro yua huë'e yijare ba'iguë, toa ba'irute cuinguë ñu'iguëna, pairi ta'yejeiye ëjaguëre yo'o concua jubë ba'igobi ti'anni, ");
INSERT INTO snnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","baguëni ëñani, coca cago: —Më'ë'ga Jesús Nazarenote te'e consi'quë baë'ë, cago bago. ");
INSERT INTO snnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Cagona, Pedrobi sehuobi: —Banhuë. Baguëte gare huesëguë'ë yë'ë. Më'ëbi coca cagona, baguëre gare ëñama'iguë'ë yë'ë, sehuobi. Ja'nca sehuoni, bain caca sa'ro tëca quëñëni gatiguëna, ja'nrëbi curabi yuji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yu'iguëna, ja'nrëbi, ba yo'o congobi Pedroni se'e ëñani, baru ba'icuani coca quëa bi'rago: —Jesús Nazareno te'e consi'quë'bi. Baguëreba'bi, quëago. ");
INSERT INTO snnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Quëagona, Pedrobi se'e huesëye sehuobi. Ja'nrëbi jë'te, baru ba'icuabi Pedroni se'e cahuë: —Aito. Jesús consi'quë baë'ë më'ë. Galilea bain coca caye'ru cayë më'ë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Cajënna, Pedrobi ai jëja sehuobi: —Banhuë. Yë'ëbi te'e ruiñe cama'itoca, yë'ëre huaijë'ën. Mësacuabi ba bainguëte cajënna, baguëte gare huesëguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sehuoguëna, ja'ansirën curabi samu ba'iye yuji'i. Yu'iguëna, Pedrobi Jesús coca case'ere ro'tabi: “Curabi yuta samu ba'iye yu'ima'iguëna, më'ëbi samute ba'iye yë'ëre huesëye caja'guë'ë.” Ja'an coca case'ere ro'tani, si'a recoyo oi bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja'nrëbi ñataguëna, pairi ëjacua, judío bain ira ëjacua, ira coca ye'yocua, si'a ëja bainbi ñë'cani, Jesús yua preso gueonsi'quë ba'iguëna, baguëte bain ta'yejeiye ëjaguë Pilato hue'eguëna sani nëcohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nëcojënna, Pilatobi baguëni senni achabi: —¿Më'ë yua judío bain quë'rë ta'yejeiye ëjaguë'guë? senni achabi. Senni achaguëna, Jesús sehuobi: —Më'ëbi ja'nca caguëna, ja'nca ba'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ja'nrëbi, pairi ëja bainbi ai ta'yejeiye Jesusre gu'aye cani jëhuahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Cani jëhuajënna, Pilatobi baguëni se'e senni achabi: —Bacuabi më'ëre ai ta'yejeiye gu'aye cajënna, ¿më'ë guere yo'oguë, sehuoma'iguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Senni achaguëna, Jesús yua gare caye beoye sehuomaji'i. Sehuoma'iguëna, Pilatobi gue ro'taye beoye ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yua ja'an fiesta umuguseña ba'iguëna, Pilatobi si'a tëcahuëan preso zeansi'quë, bain sensi'quë, te'eguëte etoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yure tëcahuë, guerra huañu caguë, bain huani senjosi'quë Barrabás hue'eguë yua preso zeansi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yureca, bain jubëbi Pilatoni, Më'ë yo'oguë ba'ise'e'ru yurera yo'ojë'ën cajën, te'e preso zeansi'quëre tijoni etojë'ën sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Senjënna, Pilatobi bacuani senni achabi: —¿Judío bain quë'rë ta'yejeiye ëjaguë, ja'anguëte tijoni etoye señe mësacua? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pairi ëjacua yua baguëte ro bëinjën insise'ere masiguëbi bacuani ja'nca senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ja'nca senni achaguëna, pairi ëjacuabi bainni tin ro'ta güesejën, Barrabás tijoni etoye señu bainre ca bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ca bi'rajënna, Pilatobi bainni senni achabi: —Ja'nca tijoni etoye sentoca, ¿mësacua quë'rë ta'yejeiye ëjaguë, judío bain ëjaguë casi'quë, ja'anguëni guere yo'oye'ne yë'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Senni achaguëna, si'a jëja güijën sehuohuë: —¡Baguëte crusu sa'cahuëna quenni reojë'ën! sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sehuojënna, Pilatobi bacuani se'e senni achabi: —¿Mësacua queaca ro'tajën baguëre caye'ne? ¿Gue gu'a jucha yo'oguë baquë'ne baguë? senni achabi. Ja'nca senni achaguëreta'an, bain jubëbi quë'rë jëja güijën sehuohuë: —Baguëte crusu sa'cahuëna quenni reojë'ën, güijën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ja'nca güijën sehuojënna, Pilatobi, Bainbi bëinma'iñe caguë, bacua yëse'e'ru yo'obi. Barrabasre tijoni etoni, ja'nrëbi, Jesusre si'nseye guanseni, baguëte quenni reoja'cuana jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ja'nca jo'caguëna, soldado hua'nabi baguëte güenaro huë'e yijana sani, bacua soldado gaje concua si'acuare choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Choini ja'nrëbi, bajacu can, ëja bain canre inni baguëna sayahuë. Sayani, miu ga'hua marote tëonni, baguë sinjobëna tëohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ja'nca yo'oni ja'nrëbi, baguëni jayajën saludajën güihuë: —¡Carajeiye beoye huajëni ba'ijë'ën, judío bain quë'rë ta'yejeiye ëjaguë! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ja'nca cajën, baguë sinjobëna tëcabëbi huaijën, baguëre go tutujën, baguëni gugurini rëanjën, ai jayajën yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja'nca jayani tëjini, baguë bajacu canre rutani, baguë cañate baguëna sayahuë. Sayani ja'nrëbi, baguëte crusu sa'cahuëna quenni reojën sahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sajënna, ja'nrëbi, Cirene bainguë Simón hue'eguë, Alejandro, Rufo, bacua taita ba'iguëbi yua zio re'otona saisi'quëbi raji'i. Raiguëna, soldado hua'nabi baguëte tëhuoni rantoni, Jesús crusu sa'cahuëte cuanni sajë'ën guansehuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Guanseni ja'nrëbi, Jesusre sani, Gólgota casiru, sinjo gu'anbë casiru, ja'an cubëna ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ti'anni ja'nrëbi, gu'a jo'cha mirra ma'ña naconi ja'mese'ere inni, Jesusni rurajënna, uncumaji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ja'nrëbi, baguëte crusu sa'cahuëna quenni reohuë. Reoni, soldado hua'nabi, Baguë cañate coni baja'cuare masiñu cajën, gata toyasira'carëanre sa'ñeña senjojën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baguëte quenni reosirënre cato, ënsëguëbi las nueve'ru sëji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Quenni reoni, ja'nrëbi, baguë gu'a jucha yo'ose'ere ro'tani, ën cocare toyani, ba crusuna së'ohuë: “Judío bain quë'rë ta'yejeiye ëjaguë'bi ba'iji” toyani së'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yequëcuare'ga bonsere tëtejën huaicua samucuare Jesús naconi bacua crusu sa'cahuëanna reohuë. Yequëre Jesús jëja ca'ncona reohuë. Yequëre Jesús ari ca'ncona reohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ja'nca reojënna, Riusu ira coca zoe toyani jo'case'e'ru güina'ru baji'i: “Gu'a bain naconi cuencuesi'quë ba'ija'guë'bi” toyani jo'case'e ba'iguëna, bacuabi Jesusni güina'ru yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ja'nrëbi, bain hua'na ca'ncorë ganijën saicuabi Jesusni bëinsi ziaña ëñajën, baguëni bain ëyëjën cahuë: —¡Ba! Më'ëbi ro ro'taguë casi'quë'ë. Riusu uja huë'ere taonni si'ani, ja'nrëbi samute umuguseña mame huë'e yo'oja'guë'ë yë'ë casi'quë sëani, ");
INSERT INTO snnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yurera'rë ja'ansi'quë jëajë'ën. Crusu sa'cahuëbi gajejë'ën, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cajënna, pairi ëja bain, ira coca ye'yocua, bacua'ga Jesusni jayajën, sa'ñeña coca cajën baë'ë: —Yequëcuabi ai yo'ojënna, bacua jëayete ëñoguë baji'i baguë. Ja'nca ëñoguëta'an, ja'ansi'quëbi jëaye gare porema'iji baguë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Baguë yua Riusu Raosi'quëreba, ba Cristo hue'eguë, Israel bain quë'rë ta'yejeiye Ëjaguë, ja'anguëbi ba'itoca, yurera'rë baguë crusu sa'cahuëbi tijini gajeja'guë. Tijini gajetoca, baguëni si'a recoyo ro'tayë mai, sa'ñeña cajën baë'ë. Cajën ba'ijënna, baguë ca'ncorëan reosi'cua'ga baguëni te'e jayajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ja'nrëbi, mëñera së'iguëna, si'a re'oto beoru na'i si'abi. Samute hora ba'iye tëca zijei re'oto se'ga baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ba'iguëna, ja'nrëbi, ënsëguëbi las tres'ru së'iguëna, Jesusbi si'a jëja coca güini achobi: —Eloi, Eloi ¿lama sabactani? güini achobi. Bain cocabi cato: Taita Riusu, Taita Riusu, ¿më'ë queaca ro'taguë, yë'ëre jo'cani senjoguë'ne? güini achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Güini achoguëna, yequëcua baru ba'icuabi achani, sa'ñeña cahuë: —Achajë'ën. Riusu ira bainguë raosi'quë Elías hue'eguëte choiji baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cani, bacua jubë ba'iguëbi besa hua'guë sani, sayabëte inni, sënje jo'chana ja'njeni, tëcabëbi jëoni, Jesusna mëani, baguëni rurani, baguë bainni cabi: —Yua ëjojën bañuni. Yequërë Elíasbi rani, baguëte tijoni gachoma'iguë cajën, ëjoni ëñañu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Caguëna, ja'nrëbi, Jesusbi ai jëja güini achoni, ja'nrëbi junni reabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Junni reaguëna, ja'ansirën Riusu uja huë'e sa'nahuë reosi canbi samu të'ntëña ba'iye ja'anse'e yua joboraja'an ye'rebi. Ëmëje'en ca'ncobi yijacua ca'nco tëca ye'rebi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesusbi güini achoni, junni reaguëna, soldado ëjaguëbi nëcaguë ëñani, ja'nrëbi coca cabi: —Riusu Zinreba baji'i baguë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Romi hua'na'ga so'orëbi ëñajën nëcahuë. Yeco María Magdalena baco'ë. Yeco María, Santiago bë'jeguë, José, bacua mamá baco'ë. Salome'ga baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ja'ncuabi yua Jesús Galilea ba'isirën baguëte te'e conjën, cuirajën baë'ë. Yequë romi hua'na'ga ai jai jubë Jesús naconi Jerusalenna raisi'cuabi baguëni ëñajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ja'nrëbi na'iguëna, yo'o yo'oma'i umuguse ja'anrë ba'i umuguse sëani, bain yo'o yo'oma'iñe re'huaye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ja'nca ba'iguëna, Arimatea huë'e jobo bainguë José hue'eguëbi Pilatona sani, Jesús ga'nihuëre senji'i. Judío ëja bain jubë ba'iguëbi ba'iguëna, si'a bainbi baguëni ai ruiñe ëñajën baë'ë. Ja'anguë yua Riusu ba'i jobo ti'an raija'yete ëñaguë ëjoguë ba'iguëbi yua jëja recoyo re'huani, Pilatona sani, Jesús ga'nihuëre senji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Senguëna, Pilatobi, ¿Yure'ne junquë baguë? senni achani, ja'nrëbi, baguë soldado ëjaguëte choini, Jesús ju'inse'ere senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Senni achaguëna, soldado ëjaguëbi, Yua ju'insi'quë ba'iji baguë, sehuobi. Ja'nca sehuoguëna, Pilatobi Jesús ga'nihuëte Josena insiye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Guanseguëna, Josebi re'o can pojei canre coni, Jesús ga'nihuëte gachoni, ba canbi ganobi. Ganoni ja'nrëbi, bain tan goje gata të'ntëbana te'ntose'e ba'iguëna, baguëte sani, ba gojena uanni, ja'nrëbi, jai gatabëbi bonani, ba gojere ta'pibi. ");
INSERT INTO snnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ja'nca uanni ta'piguëna, María Magdalena, yeco María José mamá, bacuabi ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ja'nrëbi, yo'o yo'oma'i umuguse si'aguëna, María Magdalena, María Santiago mamá, Salomé, bacuabi, Jesús ga'nihuëte ma'ña so'onjën saiñu cajën, ma'ñare cohuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Coni ja'nrëbi, semana ja'anrë ba'i umuguse ñataguëna, zijeirën ba'iguëna, bacuabi Jesús tansiruna saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Saijën, sa'ñeña cahuë: —Ba gatabëbi tansi gojena ta'pisibë ba'iguëna, ¿nebi maire bonani otacaija'cua'ne? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cani ja'nrëbi, ti'anni ëñato, ba gatabë ai jaibë ba'iguëreta'an, yua otani quëñose'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ja'nca ba'iguëna, bacuabi ba tansi gojena cacani ëñato, bonsëguëbi jëja ca'ncore ñuji'i. Zoa can pojei canre ju'iguë baji'i. Ja'nca ba'iguëna, romi hua'nabi gue ro'taye beoye ëñajën quëquëhuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Quëquëjënna, bonsëguëbi bacuani cabi: —Mësacua quëquëma'ijë'ën. Mësacuabi Jesús Nazareno crusu sa'cahuëna quenni reosi'quëre cu'ejënna, ënjo'on beoji baguë. Yua go'ya rani saji'i. Baguëre uansirute ëñani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yureca, mësacua sani, Jesusre concua, Pedro sanhuëni quëajaijë'ën: “Jesusbi mësacua ru'ru, Galilea yijana saji'i. Ja'nca saquëna, mësacua yua ja'anruna baguëte tëhuojën saijë'ën. Mësacuabi baguë quëase'e'ru, ja'anruna baguëte tëhuoni ëñaja'cua'ë” quëajë'ën, bonsëguëbi quëani achobi. ");
INSERT INTO snnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Quëani achoguëna, romi hua'nabi ai quëquëreba quëquëjën, tansi gojebi besa etani sani gatihuë. Huaji yëjën ba'icuabi yequëcuani gue quëaye beoye saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yureca, semana ja'anrë umuguse ñataguëna, Jesusbi go'ya rani, María Magdalenana ru'ru gaje meni ëñobi. Ja'ango yua te'e ëntë sara samu gu'a huati hua'i cacasi'co ba'igo ba'nco. Ja'nca ba'isi'co ba'igona, Jesusbi ba huati hua'ire etoni saoguë ba'nji. Ja'nca ba'iguëbi yureca bagona gaje meni ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ëñoguëna, ja'nrëbi, bago yua, baguëre conjën ganisi'cua ai sa'ntijën ota oijën ba'ijënna, bacuana sani quëago. ");
INSERT INTO snnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesusbi go'ya raji'i. Baguëni ëñahuë yë'ë, quëagona, bacuabi bago cocare achani, Te'e ruiñe cama'iñë më'ë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ja'nrëbi jë'te, Jesusbi baguëre concua samucua zio re'otona ganijën ba'ijënna, tin re'huasi'quë'ru gaje meni, bacuani ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ëñoguëna, bacuabi sani, yequë bacuare conjën gajecuana quëajaë'ë. Quëajaijënna, bacua cocare'ga achani Te'e ruiñe cama'iñë mësacua, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ja'nrëbi jë'te, Jesusre concua si'a sara te'ecuabi aon ainjën ñu'ijënna, Jesusbi bacuana gaje meni ëñobi. Ëñoni, baguëni te'e ruiñe ro'tama'isi'cua, recoyo ro'taye güesi'cua, ja'an ba'isi'cuare sëani, bacuani bëinguë cabi. Baguë go'ya raise'ere ëñasi'cuani te'e ruiñe recoyo ro'taye güecuare sëani, bacuani bëinguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ja'nca cani, ja'nrëbi bacua yo'ore guanseni jo'cabi: —Mësacua yua si'a yija re'otona sani, si'a bainni Riusu cocarebare quëani achojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ba cocarebare si'a recoyo ro'tajën ba'icua, ja'ancuare tëani baja'guë'ë yë'ë. Ba cocarebare ro'taye güecuare ai ta'yejeiye bënni senjoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ba cocarebare si'a recoyo ro'tajën ba'icuare masiye yëtoca, ën cocare ëñani, bacuare masijë'ën: Yë'ë ta'yejeiye ba'iyete cajën, gu'a huati hua'ire etoni saoye poreyë. Tin cocare caye ye'yema'icuata'an, te'e jëana ba cocare caye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aña hua'nare zeantoca, aña hua'nabi bacuani ja'si yo'oma'iñë. Eore uncutoca, gare ja'siye beoye ba'iyë. Yë'ëni si'a recoyo ro'tajën ba'icuabi bacua ëntë sarañabi rau ju'incuare pa'roni huachoye poreyë. Ja'anre ëñani, yë'ëni si'a recoyo ro'tajën ba'icuare masijë'ën, guanseni jo'cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja'nca guanseni jo'cani tëjiguëna, Riusubi baguëte guënamë re'otona mëabi. Mëaguëna, Riusu jëja ca'ncona bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ba'iguëna, ja'nrëbi, bacuabi sani, Riusu cocarebare si'a re'oto bainni quëani achojaë'ë. Quëani achojaijënna, mai Ëjaguë Jesusbi bacuani conguë baji'i. Bacuabi ba cocarebare quëani achojaijënna, Jesusbi ai ta'yejeiye yo'ore yo'oni ëñoguë, baguë cocareba te'e ruin cocareba ba'iyete si'a bainni masi güeseguë baji'i. Ja'nca raë'ë. Amén.");
INSERT INTO snnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yë'ë bainguë Teófilo: Cristobi mai naconi yo'oguë ba'ise'ere quëato, ai bain hua'nabi ja'an cocare toyani jo'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yequëcua, baguë yo'oguë ba'ise'e beoru ëñasi'cuabi quëani achojënna, ai bain hua'nabi toyani maina jo'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ja'nca jo'cajënna, yë'ë'ga bacua quëani toyase'e si'ayereba te'e ruiñe ëñani ro'taguë ye'yehuë. Ye'yeni, ja'nrëbi, baguë yo'oguë ba'ise'ere re'oye toyani jo'caza caguë, ën cocare te'e ruiñe toyani, më'ëna saohuë, ëjaguë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bain ye'yose'ere te'e ruiñe masijë'ën, caguë, ën cocare re'oye re'huani, më'ëna saohuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes yua Judea yija ëjaguë ba'isirën ba'iguëna, pairi bainguë Zacarías hue'eguë baji'i. Abías jubë bainguë ba'iguëna, baguë rënjo Isabel hue'egobi yua pairi jubë bain romigo baco'ë. Bago ira bainguë ba'isi'quë Aarón hue'eguë ba'nquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ai re'o bain baë'ë, ba samucua. Riusubi ëñaguëna, gare te'e ruiñereba yo'ojën baë'ë. Riusu guanseni jo'case'e beoru achani, si'aye te'e ruiñe yo'ojën baë'ë. Ja'nca sëani, yequëcuabi bacuare gu'aye cañu ro'tacuata'an, poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ja'nca ba'icuabi, bago gare zin beogo baco'ë. Zin garasi'co baco'ë. Si'a jubë yua ai ahuero hua'na baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ja'nrëbi, Zacarías yua Riusu huë'e ba'i ma'carëanre ëñaguë ba'iguë, baguë yo'o yo'obi, baguë yo'o yo'o umuguse cuencuese'e sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ja'an umuguse cuencuesi'quë sëani, Riusu huë'ena cacani, baguë ira pairi bain ba'isi'cua yo'ojën ba'ise'e'ru güina'ru ma'ñare misabëna ëoni, Riusuna mëobi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ja'nca cacani ëoguëna, bain jubëbi hue'sere ujajën nëcahuë, ma'ña ëorën ba'iguëna. ");
INSERT INTO snnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ujajën nëcajënna, ja'nrëbi, Zacarías yua ma'ñare ëoni mëoguëna, Riusu anje hua'guëbi yua misabë jëja ca'ncona gaje meji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gaje mequëna, baguë yua ai quëquë huesësi'quëbi caye beoye ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ja'nca ëñaguëna, anje hua'guëbi cabi: —Zacarías, quëquëma'ijë'ën. Më'ëbi Riusuni senni achaguëna, Riusubi achani conji. Ja'nca conguëna, më'ë rënjo Isabelbi yua më'ë zinre të'ya raija'go'co. Të'ya raigona, baguë mami Juan hue'yojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aireba bojoguë ba'ija'guë'ë më'ë, zinre baguë sëani. Yequëcua'ga ai jai jubë bainbi më'ë naconi te'e bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Riusubi ëñaguëna, ai re'o ëjaguë ba'ija'guë'bi. Jo'cha gare uncuye beoye ba'ija'guë'bi. Baguë të'ya rai umugusebi Riusu Espíritu naconi te'e zi'insi'quë bojo recoyo baguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ja'nca ba'iguëbi Israel bain gu'a ma'a ganicuani cu'eni rani, ba Ëjaguë Riusuni recoyo se'e zi'in güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Riusu bainguë raosi'quë ba'ija'guë'bi. Riusu ira raosi'quë Elías hue'eguë, baguë jëja recoyo baguë, yua Riusu Espíritu naconi te'e zi'insi'quë ba'iguë ba'nji. Ja'nca ba'iguëna, më'ë zin yua güina'ru ba'ija'guë'bi. Yequëcuabi bacua zincua naconi je'o bajënna, yequëcuabi bacua pë'caguë sanhuë naconi je'o bajënna, baguëbi yua sa'ñeña je'o beoye ba'i güeseja'guë'bi bacuare. Achaye yëma'icuani Jaë'ë sehuo güeseja'guë'bi. Sa'ñeña bojojën ba'i güeseja'guë'bi. Ba'i güeseguëna, se'e te'e ruiñe ro'tajën ba'ija'cua'ë. Bainbi bacua Ëjaguë Riusuni te'e ruiñe ro'taja'bë caguë, bacua recoyo ro'tayete mame re'huaja'guë'bi baguë, cani jo'cabi Riusu anje hua'guë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Caguëna, Zacarías yua baguëni senni achabi: —Më'ëbi coca quëaguëna, ¿queaca masiye'ne yë'ë? Yë'ë, yë'ë rënjo, yëquënabi ai ahuero hua'na ba'ijënna, huesë ëaji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Caguëna, anje sehuobi: —Yë'ë yua Gabriel hue'eguë, yua Riusu raosi'quë'ë. Baguëbi guanseguëna, më'ëna gaje meni, baguë bojo güese cocare quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Quëaguëna, më'ëbi te'e ruiñe ro'tama'iguë achamaë'ë. Ja'nca achama'isi'quë sëani, yua yi'o ma'tëbë ba'ija'guë'ë më'ë. Më'ë zin të'ya raima'i ñësebë, coca caye gare porema'iñë më'ë, yë'ë case'e'ru ba'ija'ye tëca, anjebi sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ja'nrëbi, bain jubë yua hue'se ca'ncore nëcajën, Zacaríasni ëjojën, ¿Guere yo'oguë baguë, sa'nahuë zoe ba'iguë'ne? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cajënna, ja'nrëbi baguëbi yua etani, bacuani coca caye porema'i hua'guë baji'i. Ja'nca ba'iguëna, baguë guënamë toya ëñase'ere masihuë. Baguë ëntë sarañabi bacuani ro ña'queye se'ga quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ja'nrëbi, baguë cuencuesi umuguseña si'aguëna, Riusu huë'e yo'o ma'carëanre yo'oni tëjini, baguë huë'ena goji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Go'iguëna, ja'nrëbi yo'je, baguë rënjo Isabelbi yua zin nëcago, te'e ëntë sara ñañaguë hua'ire huë'ena bëago, huë'ere etaye beoye baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ja'nca ba'igobi ja'ansi'co ro'tago: Yë'ë Ëjaguë Riusubi yë'ëre ai re'oye conguëna, bainbi se'e yë'ë zin të'ya raima'iñete gu'aye caye beoye ba'ija'cua'ë, ro'tago bojogo. ");
INSERT INTO snnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ja'nrëbi, te'e ëntë sara te'e ñañaguë hua'i zinbë ba'igona, Riusubi baguë guënamë re'oto yo'o conguë, Gabrielni guanseni, Galilea yija huë'e jobo, Nazaret huë'e jobo, ja'an jobona baguëte saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ja'anru ba'i romi zingo María hue'egoni coca quëaguë saobi Riusu. Bago yua José hue'eguë, ira ëjaguë ba'isi'quë David bainguë, ja'anguëni huejajaza cago ro'tago ba'igona, ");
INSERT INTO snnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Riusu anje hua'guëbi bagona ti'anni, bagoni saludaguë cabi: —Bojogo ba'ijë'ën. Riusubi më'ë naconi ba'iguëna, baguë quë'rë ta'yejeiye consi'co'ë më'ë. Më'ëni ai re'oye ëñaguë sëani, si'a romicua'ru më'ëni quë'rë ai conji Riusu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Caguëna, Maríabi ai quëquëni huesësi'cobi caye beoye ëñago. ");
INSERT INTO snnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja'nca ëñagona, anjebi bagoni cabi: —Quëquëma'ijë'ën, María. Riusubi më'ëni re'oye ëñaguë, më'ëni ai re'oye conja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Më'ëbi yua zin nëcago, ëmëguëni të'ya raija'go'ë. Të'ya rani, baguë mami Jesusre hue'yojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ai ta'yejeiye ëjaguë ba'ija'guë'bi. Mai ta'yejeiyereba Riusu Zin casi'quë ba'ija'guë'bi. Riusubi baguë bain ta'yejeiye ëjaguëre baguëre re'huaye ro'taji, baguë ira ëjaguë ba'isi'quë David ba'ise'e'ru. ");
INSERT INTO snnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel bain ëjaguë si'arën ba'ija'guë'bi. Gare carajeiye beoye guanseguë ba'ija'guë'bi, anjebi quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Quëaguëna, Maríabi cago: —Ënjëre beogo sëani, ¿queaca zin ba'ija'go'ne? cago, senni achago. ");
INSERT INTO snnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Senni achagona, anjebi quëabi: —Riusu Espíritubi më'ëna ti'anni, mai ta'yejeiyereba Ëjaguë Riusubi më'ëni guënamë pico naconi gaje meni, më'ëni na'oni baguëna, Riusu Zinre të'ya raija'go'ë më'ë. Të'ya raigona, Riusu Zin casi'quëbi Riusu cuencuesi'quë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Më'ë baingo Isabelre'ga ro'tajë'ën. Të'ya raima'igo garasi'co case'eta'an, bago yua te'e ëntë sara te'e ñañaguë hua'i zinbë ba'igo. Ai ahuera hua'go ba'igota'an, ja'nca të'ya raija'gota'an ba'igo. ");
INSERT INTO snnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bain yo'oye porema'icuata'an, Riusubi si'aye yo'oye poreji, anjebi quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Quëaguëna, Maríabi cago: —Riusu yo'o con hua'go se'ga ba'i hua'go'ë yë'ë. Më'ë quëase'e'ru ba'iye yë'ëre yo'oja'guë Riusu, cago sehuogo bago. Cago sehuogona, anjebi quëani tonni huesëbi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja'nrëbi, Maríabi huëni, Yë'ë baingo Isabelni ëñajaza cago, cu re'oto huë'e jobo, Judea yija huë'e jobo, ja'anruna besa saco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sani, Zacarías huë'ena ti'anni, Isabelni saludago. ");
INSERT INTO snnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saludagona, Isabelbi achagona, Isabel zinbi bago guëtabë sa'nahuë yua ñu'cuebi. Ñu'cueguëna, Isabel yua Riusu Espíritu naconi te'e zi'inni ba'igobi bojo recoyo bago runco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Runni, ja'nrëbi, re'oye achoye Maríani bojogo ai jëja ujago cago: —Riusubi si'a romicuare ëñaguëta'an, më'ëre quë'rë ta'yejeiye conguë baji. Më'ë zin të'ya raija'guëre'ga ai conji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Më'ëbi, mai Ëjaguë pë'cagobi yë'ëni ëña raigona, ai bojoyë yë'ë. Riusubi bojo güeseguë, yë'ë hua'go, ro baingo ba'igote ai re'oye ëñani, Riusu re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Më'ëbi yë'ëni saludagona, yë'ë zin sa'nahuë ba'iguëbi ja'ansirën ai bojoguë ñu'cuebi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Më'ëbi Riusu coca quëase'ere achani, ja'nca ba'ija'guë ro'tago, ai bojogo ba'iyë më'ë, cago Isabel. ");
INSERT INTO snnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Cagona, Maríabi cago: Yë'ë recoyo ai bojoyereba bojogo ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Riusu ai ta'yejeiguë'bi ba'iji, cayë yë'ë hua'go, yë'ëre tëani baja'guëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Baguë yo'o con hua'go se'ga ba'igona, yë'ëna re'oye ro'tani, yë'ëre tëani baji yë'ë hua'gore. Ja'nca sëani, si'a bainbi yë'ëre ëñani, Bagoni ai re'oye ai conji Riusu cajën bojoja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ta'yejeiyereba Riusubi yë'ëre conreba conguëna, ai bojoreba bojoyë yë'ë, Riusu se'ga re'oye ba'iguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Si'a hua'na baguëna oijën gugurijën ba'itoca, bacuani oiguë, bacuani conji Riusu. Ja'nca conguë, gare carajeiye beoye baguë bainre oiguë conji. ");
INSERT INTO snnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yequëcua ro bacua se'gare'ru huanoguëna, bacuabi ai huacha ro'tajënna, Riusubi yua bacuare te'e jëana etoni senjobi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yequëcua bain ta'yejeiye ëjacua ba'icuareta'an, Riusubi bacuare etoni saoni, yequëcua ro porema'icua se'gare ëñani, bacuani ëja bain re'huani baji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yequëcua aon caracuare ëñani, bacuani ai re'oye conreba conguë insibi. Yequëcua a'ta bonse bacuareta'an, ro bonse beo hua'nare etoni saobi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mai ira bain ba'isi'cuani coca cani jo'case'ere ro'tani, güina'ru yo'oji Riusu. Baguë bain Israel hue'ecuani gare huanë yeye beoye conji. ");
INSERT INTO snnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abrahamre'ga ro'tani, baguëni ai oiguë ai re'oye conbi Riusu. Abraham bain ba'ija'cua, yureña ba'icua, yequëcua yuta ba'ima'icuare'ga, si'acuare ro'tani, gare carajeiye beoye conreba conji Riusu, cago María. ");
INSERT INTO snnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ja'nca cani, ja'nrëbi samute ñañaguë hua'i Isabel naconi bëani ba'igo, ja'nrëbi bani tëjini, bago huë'ena goco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ja'nrëbi, Isabel të'ya rai umuguse ti'anguëna, ëmëguëni të'ya raco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Të'ya raigona, bago bain gaje hua'nabi bagona ti'anni ëñajën, bago naconi bojoreba bojohuë, Riusu ai re'oye conse'e sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ja'nrëbi, zin hua'guëbi te'e ëntë sara samute umuguseña baguëna, bainbi baguë go neño ga'nirëte tëyojën rani, Baguë pë'caguë mami Zacarías hue'eja'guë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cajënna, pë'cagobi: —Banji. Juan hue'eja'guë'bi, cago. ");
INSERT INTO snnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cagona, bacua cahuë: —¿Më'ë guere cago'ne? Më'ë bain Juan hue'ecua beoyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ja'nca cani, ja'nrëbi, baguë pë'caguëna bonëni, bacua ëntë saraña se'gabi ro ña'queni, mamaquë mami hue'eja'yete senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Senni achajënna, Zacaríasbi uti ja'ore senni, ja'nrëbi, Juan hue'eji, toyani eñobi. Ja'nca toyani ëñoguëna, bacuabi ai ëñajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ëñajën rëinjënna, ja'ansirënbi, Zacaríasbi, yi'obobi ti'jiguëna, yua Riusuni re'o cocareba bojoguë ca bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ca bi'raguëna, baincuabi ai huaji yëjën, ba huë'ebi sani, si'aye quëajënna, ba yo'ose'e si'a Judea yija cu re'oto ba'iruan'ga quëani achojaise'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Si'acua ja'an cocare achani ro'tani, sa'ñeña senni achahuë: —¿Gueguë ba'ija'guëguë'ne ba zin hua'guë? senni achahuë. Riusubi oiguë, baguëre ëñani consi'quëre sëani, si'a bainbi ëñani, ja'anre sa'ñeña senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ja'nca ba'iguëna, Juan pë'caguë Zacaríasbi Riusu Espíritu naconi zi'inni, bojo recoyo runji'i. Runni, Riusu coca yihuoni raose'ere quëani acho bi'rabi: ");
INSERT INTO snnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israel bain, mai Ta'yejeiye Ëjaguë Riusu, baguë ba'iyete ro'tajën bojojën gantañuni. Baguë bain jucha zemosi'cuani conguë raisi'quë'bi ba'iji. Maire huajëreba ba'icuare etojeiguë raisi'quë'bi ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Riusu raoja'guë, baguë bainguë David yo'je ba'ija'guë, maire tëani baja'guë, ja'anguëre mai ta'yejeiye ëjaguëre re'huani, maina raobi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Baguë ira bain raosi'cua naconi quëani jo'case'e ba'iguëna, güina'ru maina quëani jo'cabi Riusu: ");
INSERT INTO snnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yequëcuabi maini je'o bajën, maire hueso ëaye yo'ojënna, Riusubi maire tëani, maini baye cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mai ira bain ba'isi'cuani oiguë, bacuani coca cani jo'case'ere ro'taguë, baguë cani jo'case'e'ru güina'ru yo'obi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Riusu coca cani jo'case'e, mai ira bainguë ba'isi'quë Abrahamni ganreba cani jo'case'e ën coca baji'i: ");
INSERT INTO snnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Yequëcuabi maini je'o bajënna, maire tëani, maini baye cabi Riusu. Maini baguë, baguë yo'o con hua'nare re'huani, Mësacua gare huaji yëye beoye yë'ëni conjën ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Si'a mai ba'i umuguseñabi baguë naconi ba'ijën, baguë ai yëreba yësi'cua ba'ijënna, te'e ruiñe yo'ocuare maire re'huani baye cabi Riusu, cabi Zacarías. Cani ja'nrëbi, baguë zin hua'guëre ëñani, baguëte cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ja'nca sëani, yë'ë mami, më'ë yua mai ta'yejeiyereba Riusu cuencueni raosi'quë'ë. Baguë coca quëaja'guëre më'ëre re'huabi Riusu. Më'ëbi ru'ru sani, mai Ëjaguë rai ma'are re'huaye bayë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Baguë bainna sani, bacua gu'a juchare jo'cani senjojënna, Riusubi bacuare tëani bani, bacua gu'a jucha yo'ojën ba'ise'ere gare ro'tama'iñe caja'guë'bi Riusu. Ja'anre bacuani quëani achoye bayë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mai Ëjaguë Riusubi maini ai oiguë conji. Mai hua'nabi ro porema'icuareta'an, maini ai re'oye cuiraguë oiguë conji. Go'sijei umuguse ñatani saoye'ru maina ti'an rani, bojo recoyo ba hua'nare maire re'huani jo'caji. ");
INSERT INTO snnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ja'nca re'huani jo'caguëbi zijei re'oto ba'icua, gare bënni senjosi'cua ba'ija'cua, ja'ancuani baguë go'sijei re'otore te'e ruiñe masi güeseji Riusu. Mësacua gare huaji yëye beoye yë'ëni te'e zi'inni conjën ba'ijë'ën caguë, maire choiji Riusu, gantaguë cabi Zacarías. ");
INSERT INTO snnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Caguëna, ja'nrëbi, baguë zin hua'guëbi irani, jëja baguë, te'e ruiñe ba'i recoyo re'huani baji'i. Irani tëjini, ja'nrëbi, bain beo re'otona sani, bëani baji'i. Israel bainna sani quëa umuguse ti'añe tëca baruna bëani ba'iguë ëjobi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja'nrëbi, bain ëjaguëreba, Augusto hue'eguëbi si'a bainni guanseguë, Si'acua mamire ëja bain uti pëbëna toya güesejë'ën caguë guanseni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ja'nca guanseni jo'caguë, bain cuencuese'e, ru'ru ba'iye cuencuese'e baji'i. Ja'nca ba'iguëna, Cirenio hue'eguëbi yua Siria yija bain quë'rë ta'yejeiye ëjaguë baji'i, ja'anrën. ");
INSERT INTO snnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bainre cuencueye guanseguë, Si'acuabi mësacua të'ya raisi huë'e jobona go'ini, mësacua mamire ëja bain uti pëbëna toya güesejë'ën, guanseni tonni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ja'nca guanseni jo'caguëna, Josebi baguë huë'e jobona sai bi'rabi. Nazaret huë'e jobo, Galilea yija ba'i jobobi sani, Belén huë'e jobo, baguë ira ëjaguë ba'isi'quë David hue'eguë, baguë huë'e jobo, Judea yija ba'i jobo, ja'anruna sani, baguë mamire toya güesejaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Toya güesejaiguë, Maríare'ga sabi, bago naconi huejaye ro'taguë sëani. Yua ira zinbë ba'igoni sabi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ja'nca sani, Belenna ti'anni, bain cain huë'ena cainru cu'eni jëhuani, cainru beoguëna, jo'ya hua'na be'jerëna sani cacani baë'ë. Ba'ijën, bago të'ya rairën ti'anguëna, bago zin ru'ru ba'iguëte të'ya rani, canbi ganoni, jo'ya hua'na aon aonguna uango. ");
INSERT INTO snnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ja'nrëbi, ja'ansi ca'nco jo'ya hua'na cuiracua baë'ë. Cuirajën ba'icuabi bacua oveja jo'ya hua'nare ñamibi ëñajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ja'nca ëñajën ba'ijënna, Riusu guënamë re'oto yo'o con hua'guëbi bacuana gaje meni ti'anbi. Ti'anguëna, ai go'sijei re'otora ti'anguëna, jo'ya ëñacuabi ai quëquësi'cua ëñajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ja'nca ba'ijënna, yo'o con hua'guëbi bacuani quëabi: —Quëquëma'ijë'ën mësacua. Bojo güese cocare mësacuani quëaguë raisi'quë'ë yë'ë. Si'a bainbi achani ai bojoreba bojoye'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yure, ira ëjaguë David huë'e jobo, Belenre ba'iguë, Riusu raosi'quë të'ya raisi'quë'bi ba'iji. Mësacuana ti'an rani, mësacuare Riusu bainrebare re'huani baza caguë raji'i. Mai ta'yejeiyereba ëjaguë ba'ija'guëbi Cristo hue'eji baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mësacuabi huë'e jobona sani cu'eto, Riusu Zin raosi'quëre tinjani ëñaja'cua'ë. Canbi ganosi'quëbi jo'ya hua'na aon aongute uinguëna, baguëte ëñani masija'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Caguëna, ja'nrëbi, ai jai jubë anje hua'nabi te'e jëana gaje meni ti'anhuë. Ti'anni, si'a jubëbi Riusuni bojoreba bojojën gantahuë: ");
INSERT INTO snnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Mai ta'yejeiyereba Riusubi guënamë re'oto ëjaguëreba'bi ba'iji. Baguë bain ai yësi'cua, yija re'otore ba'icuani bojoguë, huaji yëye beoye ba'ija'bë caji, Riusure yo'o con hua'nabi gantajën quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gantani tonni, yua guënamë re'otona go'ijënna, jo'ya hua'na cuiracuabi sa'ñeña ca bi'rahuë: —Belenna saiñu. Riusu raosi'quëre yure quëani achosi'quëni sani ëñajaiñu cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cani, besa sani ëñato, María, José baë'ë. Zin hua'guëbi jo'ya hua'na aon aongute uinguëna, ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ja'nca ëñani, ba zin hua'guë ba'iye, anje hua'guë cani jo'case'ere bacuani quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ja'nca quëajënna, si'a hua'nabi ai bojoreba bojojën achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ja'nca bojojënna, Maríabi ja'an si'aye ro'tani, bago recoyona re'huani, gare huanë yeye beoye baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ja'nrëbi, jo'ya hua'na cuiracuabi yua Riusu quëani achose'e beoru achani, Riusu yo'oni jo'case'e beoru ëñani, Riusuni bojoreba bojojën, baguëni gantajën goë'ë. Riusure yo'o conguë quëase'e'ru güina'ru baji'i, cajën bojojën goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja'nrëbi, te'e ëntë sara samute umuguseña ba'ini, ba zin hua'guë go neño ga'nirëte tëyo güeseni, baguë mami Jesús hue'yohuë. María yuta zin nëcama'irën, Riusure yo'o conguëbi gaje meni quëaguëna, ja'an mamire yure baguëte hue'yohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hue'yoni ja'nrëbi pë'caguë sanhuë pa'roma'i umuguseña carajeiye tëca ba'ijën, Moisés coca cani jo'case'e'ru yo'ojën, tënosi hua'na runni tonni, ja'nrëbi Zin hua'guëre Riusu huë'ena sani, Riusu conja'guëte re'hua güeseñu cajën, Jerusalén huë'e jobona sani, Riusu huë'ena cacahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Moisés coca toyani jo'case'e'ru güina'ru yo'ohuë: Si'a zin hua'na ru'ru të'ya raisi'cua banica, Riusu conja'cuare re'hua güesejë'ën, cani jo'case'e sëani, Jesusre sani, Riusu conja'guëte re'hua güesehuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ja'nca re'hua güesejën, Moisés coca toyani jo'case'e'ru yo'ojën, jo'ya ca hua'i hua'nare inni, samu jure hua'na, o samu ju'ncubo hua'na, ja'an hua'nare inni, misabëna ëoni Riusuna mëojën, zin hua'guëre Riusu conja'guëte re'hua güesehuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ja'nca re'hua güesejënna, yequë Simeón hue'eguëbi Riusu huë'ena cacani baji'i. Ja'an ba'iguëbi ai re'o bainguë ba'iguë, Riusuni caraye beoye yo'o conguë te'e ruiñe yo'oye se'ga baji'i. Israel bain etojeirënre ai ro'taguë, Riusu etojeiyete caraye beoye ëñaguë ëjoguë baji'i. Ja'nca ba'iguëna, Riusu Espíritubi baguë recoyona gaje meni bëani, ba'iguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bëani ba'iguëbi Simeonni masi güeseguë baji'i: Më'ë yija yuta ba'iguë, Riusu raoja'guëte ëñaja'guë'ë më'ë, masi güesebi Riusu. Ja'nca masi güeseguë sëani, ");
INSERT INTO snnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","yureca Riusu Espíritubi saguëna, Simeonbi Riusu huë'ena cacani baji'i. Cacani ba'iguëbi, Jesús pë'caguë sanhuëbi Riusu coca cani jo'case'e'ru yo'ojënna, bacuana ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ti'anni, zin hua'guëre inni cuanni ëñaguë, Riusuni ai bojoreba bojoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ah, Ëjaguë, më'ë coca cani jo'case'e'ru güina'ru yo'osi'quë sëani, yë'ë hua'guë më'ë yo'o con hua'guë se'ga ba'iguëbi më'ëni ai bojoreba bojoyë yë'ë. Më'ë raosi'quërebabi ti'anguëna, yurera baguëni ai bojoguë ëñañë yë'ë. Ja'nca ëñaguë, yureca bojo hua'guëbi junni, ën yijare gare jo'caye poreyë yë'ë, Ja'quë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Më'ë bainrebare re'huani baja'guëre raoguëna, baguëte yure ëñahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Si'a bainni baguëre ëñani masija'bë caguë raoguëna, yurera ti'an raisi'quë'bi ba'iji baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Si'a ën yija bainni go'sijei re'otorebare ëñoni masi güeseja'guë'bi ti'anguëna, bojoyë yë'ë. Judío bain jubë ba'ima'icuare'ga go'sijeiyete te'e ruiñe ëñoni, Israel bainre quë'rë ëja bainre re'huani jo'caja'guë'bi ba'iji ënquë, bojoguë cabi Simeón. ");
INSERT INTO snnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja'nca caguëna, ba zin hua'guë pë'caguë sanhuë, José, María, bacuabi ai bojo recoyo re'huani baë'ë, bacua zinre case'e sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ba'ijënna, Simeonbi bacuani ai re'oye caguë, ëñani jo'cani, ja'nrëbi Jesús pë'cago Maríani jë'te ba'ija'yete cani achobi: —Achajë'ën. Riusubi ënquëre cuencueni raoguëna, ai bain Israel ba'icuabi baguë yo'oguë ba'iyete ëñaja'cua'ë. Ëñani, yequëcuabi baguëni zi'inni re'oye ba'ija'cua'ë. Yequëcuaca baguëni gu'a güejën, gu'aye ba'ija'cua'ë. Baguëte Riusu raosi'quërebare ro jo'cani senjojën, ");
INSERT INTO snnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","bacua gu'a recoyo ro'tayete te'e ruiñe masi güesejën ba'ija'cua'ë. Baguëte ro jo'cani senjojën gu'aye yo'ojënna, më'ëbi aireba sa'ntigo, si'a recoyo oireba oigo ba'ija'go'ë, cani jo'cabi Simeón. ");
INSERT INTO snnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cani jo'caguëna, yeco'ga Ana hue'egobi querë baco'ë. Riusu baingobi baguë cocare masini quëago baco'ë. Aser jubë baingo ba'igo, bago taita Fanuel hue'eguëna, ai ahuera hua'go baco'ë. Romi zingo ba'isirën huejani, bago ënjë naconi te'e ëntë sara samu tëcahuëan ba'igona, junni huesëguëña baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Junni huesëguëna, bago hua'jeni ba'irën yua ochenta y cuatro tëcahuëan te'e hua'go baco'ë. Ja'nca ba'igobi Riusu huë'e se'gare ba'igo, Riusu yo'o coñe se'ga ba'igo. Aon aiñe jo'cago, Riusuni ujago, jo'caye beoye Riusu yo'o se'gare yo'ogo. ");
INSERT INTO snnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ja'nca ba'igobi ja'ansirën Jesús pë'caguë sanhuëna ti'an rani, Riusu zin hua'guëni ëñani bojogo. Riusuni ai bojoreba bojogo, surupa cago, zin hua'guë ba'ija'yete bago bainni quëani acho bi'rago. Quëani achogona, bacuabi achani, Maire etoja'guëni ëjojën ba'icuareta'an, yua ti'anbi cajën bojojën achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja'nrëbi, Jesús pë'caguë sanhuëbi Moisés coca toyani jo'case'e'ru yo'oni tëjini, bacua huë'e jobo Nazaretna goë'ë, Galilea yija huë'e jobo. ");
INSERT INTO snnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Go'ini ti'anni ba'ijënna, zin hua'guëbi irani, ai jëja bani, ai masiye ye'yeguëna, Riusubi baguëni ai re'oye conni cuiraguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yureca, Jesús pë'caguë sanhuëbi Nazaret huë'e jobore ba'ijën, si'a tëcahuëan Pascua umuguseña ba'iguëna, Riusuni bojojën yo'ojaiñu cajën, Jerusalén huë'e jobona saijën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ja'nca ba'ijënna, Jesusbi si'a sara samu tëcahuëanre bani, baguë bain yo'ojën ba'iye'ru yo'oguë, Pascua umuguseñabi Riusuni bojoñu cajën saijënna, baguë yua te'e conguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sani, Pascua umuguseña yo'oni tëjini, baguë bainbi go'ijënna, Jesusbi Jerusalenna bëabi. Bëaguëna, baguë pë'caguë sanhuëbi huesëjën, ");
INSERT INTO snnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mai jubë bain naconi ba'ima'iguë baguë cajën, ma'abi go'ijën na'ijaë'ë. Na'ijani, ja'nrëbi bacua bain ba'iruanna baguëre cu'e ganocuata'an, ");
INSERT INTO snnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","gare baguëre tinjamaë'e. Tinjamajën, ja'ansirën Jerusalenna bonëni, baguëni cu'ejën, se'e goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Go'ini, samute umuguseña baguëte cu'eni, ja'nrëbi Riusu uja huë'ena cacani ëñato, Riusu coca masiye ye'yocua naconi ñu'iguë baji'i baguë. Ja'nca ñu'iguëbi bacuani ai coca senni achaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Senni achani bacua cocare'ga masiye sehuoguë ba'iguëna, ba hua'nabi ai achajën rëinjën, sa'ñeña cajën, ¿Queaca masiye sehuoye poreguë'ne baguë? ro'tajën cajën, baguëre ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ja'nca cajën ëñajënna, baguë pë'caguë sanhuë'ga ti'anni, ¿gue'ne? sa'ñeña cajën, pë'cagobi Jesusni cago: —Mami, ¿më'ë guere yo'oguë, bëani ba'iguë'ne? Më'ë taita, yë'ë, yëquënabi më'ëni ai cu'ejën ai sa'ntijën baë'ë, cago. ");
INSERT INTO snnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Cagona, Jesús sehuobi: —¿Mësacua queaca ro'tajën, yë'ëni cu'eye'ne? Yë'ë Ja'quë yo'o ma'carëanre yo'oguë bëaguëna, mësacua ro'tama'iñe? caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ja'nca sehuoguëna, baguë coca case'ere ro huesë ëaye achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ja'nrëbi, bacua naconi Nazaret huë'e jobona goji'i Jesús. Go'ini ba'iguë, bacua guanseyete achani jaë'ë caguë yo'oguë baji'i. Yo'oguë ba'iguëna, baguë pë'cagobi ja'an si'aye ro'tani, bago recoyona re'huani, gare huanë yeye beoye baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja'nrëbi, Jesusbi irani, ai jëja baguë'ru runni, ai masiye ye'yesi'quë'ru ruinguëna, Riusubi baguëni ëñani bojoguë baji'i. Bain'ga baguëni re'oye ëñajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ja'nrëbi, bain ta'yejeiye ëjaguëreba Tiberio hue'eguëbi bëani, quince tëcahuëan ba'iguëna, ja'an tëcahuë ti'anguëna, Judea bain ëjaguë Poncio Pilato baji'i. Herodes'ga Galilea bain ëjaguë baji'i. Herodes yo'jeguë Felipe yua Iturea, Traconite, ja'an bain ëjaguë baji'i. Lisanias yua Abilinia bain ëjaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ja'an tëcahuë, judío bain pairi ta'yejeiye ëjacua, Anás, Caifás, ja'ancua baë'ë. Ja'nca ba'ijënna, ja'an tëcahuë, Zacarías mamaquë Juanbi bain beo re'otore ba'iguëna, Riusubi baguëna ti'anni, Ën cocare bainni quëani achojë'ën, caguë guansebi. ");
INSERT INTO snnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Caguë guanseguëna, Juanbi si'a Jordán ziaya ba'i re'otobi ganini, Riusu cocare quëani achoguë baji'i: —Mësacua gu'aye yo'ojën ba'ise'e beoru jo'cani senjoni, bautiza güesejë'ën. Ja'nca yo'otoca, Riusubi mësacua gu'a jucha yo'ojën ba'ise'ere huanë yeni, gare mësacua recoyore mame re'huani tënoni baja'guë'bi quëani achoguë baji'i Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yua Juanre cuencueni raose'ere ro'tato, Riusubi baguëte ai zoe cuencuebi. Riusu ira bainguë ba'isi'quë Isaíasbi ñaca toyani jo'cabi: Riusu bainguëbi beo re'otona ti'anni, Riusu cocare si'a jëja cani achoja'guë'bi: Mësacua recoyore mame re'huani ba'ijë'ën. Mai ëjaguë rai ma'are re'huaye'ru re'huani, te'e ruin ma'are yo'ocaijë'ën baguëre. ");
INSERT INTO snnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Si'a yorobëan ba'itoca, yua beoru ya'obi pë'npëye ba'iji. Cubëan ba'itoca, yua beoru quëroni ñañoni tonni, senjoñe ba'iji. To'nqueboan ba'i ma'a ba'itoca, yua te'e ruin ma'a ba'iye re'huaye ba'iji. Gu'a ma'a ba'itoca, te'e ruiñe gani güeseye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ja'nca re'huani ba'iguëna, Riusubi baguë bainre tëani, baguë ba'i jobona sani baguëna, si'a bainbi ëñaja'cua'ë, toyani jo'caguë ba'nji Isaías. ");
INSERT INTO snnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ja'nca ba'iguëna, ai bainbi Juanna ti'anni, Bautiza güesejañu cajënna, Juanbi bacuani si'a jëja yihuoguë cabi: —Mësacua yua aña hua'na'ru gu'aye ro'tajën raë'ë. Riusu bënni senjosi'cua yuara ba'ija'cua sëani, ¿mësacua queaca jëaye ro'taye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mësacua gu'aye yo'ojën ba'ise'ere gare jo'cani senjoni, mësacua mame recoyo re'huani ba'ijë'ën. Te'e ruiñe ro'tajën ba'ijë'ën. Mësacua sa'ñeña coca cajën ba'iye'ru gare se'e cama'ijë'ën: “Yëquëna yua Abraham re'o bain yo'je ba'icuare sëani, Riusubi bënni senjoma'iji” ro huacha ro'tayë mësacua. Mësacuani ganreba cayë. Riusubi Abraham re'o bainre re'huaye yëtoca, ënjo'on ba'i gatabëanre inni, baguë re'o bainre guaja beoye re'huaye poreji. ");
INSERT INTO snnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gu'a sunqui cueye'ru yo'oji Riusu. Zu'ubo re'oye guë'tosibobi inni, si'a sunquire ëñani, gu'a sunqui ba'itoca, aon quëinma'iñe ba'itoca, yua si'a sunqui sitare cueni, sunquire taonni, toana senjoni ëoji. Ja'nca yo'oye'ru yo'oye ro'taji Riusu, yihuoguë cabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Caguëna, bainbi baguëni senni achahuë: —Ja'nca yo'oye ro'tatoca, yëquëna ¿queaca yo'oja'cua'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Senni achajënna, bacuani sehuobi Juan: —Mësacua bainni oijën conjë'ën. Samu ëntë sara cañare banica, te'e canre ëntë sara can beo hua'guëna ro insijë'ën. Mësacua aonre bajën, aon beocuana huo'hueni ro insijë'ën, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ja'nrëbi, impuesto curi cocuabi Bautiza güeseñu cajën, Juanna ti'anni, baguëni senni achahuë: —Yequëna'ga ¿queaca yo'oja'cua'ne, Ëjaguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Senni achajënna, bacuani yihuoguë cabi: —Ëja bain guanseni jo'casi cocare ëñani, ja'an coca caye se'gare'ru yo'ojën, impuesto curire coni bajë'ën. Coqueye beoye yo'ojën, quë'rë ta'yejeiye coni bama'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Caguëna, ja'nrëbi soldado hua'nabi Juanna ti'anni, baguëni senni achahuë: —Yequëna'ga ¿queaca yo'oja'cua'ne? senni achahuë. Senni achajënna, Juan sehuobi: —Bain bonsere coqueye beoye tëtema'ijë'ën. Mësacua jubë yequëcuabi gu'aye cajën, Bain bonsere tëteni baza cajën, bainre ro huai ëaye yo'ojën tëteyë. Yequëcuabi bainre preso zean ëaye yo'ojën tëteyë. Ja'an yo'oye'ru yo'omajën ba'ijë'ën. Mësacua ëja bain curi ro'ise'ere coni, ja'an se'gare bani, bojojën ba'ijë'ën, caguë sehuobi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ja'nca sehuoguëna, bainbi achani, baguëte re'oye ëñajën, ¿Riusu raosi'quërebama'iguë baguë? sa'ñeña senni achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ja'nca senni achajën ba'ijënna, Juanbi si'acuani quëareba quëabi: —Bañë. Ocona bautizaye se'ga ba'iguë'ë yë'ë. Yequëca yë'ë ba'iye'ru quë'rë ta'yejeiye ëjaguërebabi yuara ti'anja'ñeta'an ba'iji. Baguëbi bainre bautizato, Riusu Espíritu naconi, toa naconi, ja'anre gaje me güeseni, bainre bautizaja'guë'bi. Ai ta'yejeiye ëjaguërebare sëani, baguëni yo'o coñe gare ti'anma'iguë'ë yë'ë. Baguë guëon ju'i co'rore ti'jeye'ga gare ti'anma'iguë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Bain recoyo ro'tayete masiza caguë, baguë ñacobi ëñani, bain re'oye ro'taye, bain gu'aye ro'taye, ja'anre te'e ruiñe masija'guë'bi baguë. Trigo aonra'carëanre tutuna huëaye'ru yo'oguë raiji. Baguë huëa macabi inni aonra'carëanre tutuna huëani, hui'ya sëohuëan senjoguëna, trigo aonra'carëan se'gare baguë aon re'huaruna ayani baji. Ja'nca bani, ja'nrëbi hui'ya sëohuëanre chiani, toana senjoni ëoji. Ja'an toare cato, gare yayaye beoye ba'iji. Baguë bainrebare re'huani baja'yete quëayë. Yequëcua, baguëte güeni senjocuare toana senjoni ëoja'guë'bi, bainni quëabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ja'nca quëaguë, si'a bainni ai yihuoguë, Riusu bojo güese cocarebare quë'rë ai ba'iye quëani achoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ja'nca quëani achoguë, bain ëjaguë Herodesni ai bëinguë cabi: Më'ë yo'jeguë Felipe rënjore ro tëani baguë sëani, ai gu'aye yo'ohuë më'ë, bëinguë cabi. Herodías hue'egote ro tëani baguëre sëani, ai bëinguë cani, yequë baguë gu'aye yo'ose'ere'ga baguëni ro'ta güeseni, Herodesni bëin coca cani jo'cabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cani jo'caguëna, Herodes yua achaye güeguë, quë'rë se'e ai gu'aye yo'oguë, Juanni preso zeanni, baguëte ya'o huë'ena guao güeseni babi. ");
INSERT INTO snnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanre zeanni guao güesesirën yuta ti'anma'iguëna, Juan yua bainre bautizaguë ba'iguëna, Jesusbi ti'an raji'i. Ti'an rani, Juanbi baguëte bautizaguëna, Jesusbi Ja'quë Riusu naconi coca ca bi'rabi. Ca bi'rani mëiñe ëñato, guënamë re'otobi ja'anse'e a'nqueni saoguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Riusu Espíritubi eta rani, ju'ncubo ba'iye'ru ëñoni, Jesusna gaje meni tuabi. Tuaguëna, guënamë re'otobi coca cani achobi: —Më'ë yua yë'ë Zin ai yësi'quë'bi ba'iyë. Më'ëni ai bojoguë ëñañë yë'ë, guënamë re'otobi cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesucristo ën yija ba'iguë ba'iyete cato, baguë bainre con bi'raguë, yua treinta tëcahuëan baye'ru babi. Bainbi ro'tani cato, baguë pë'caguë yua José baquëña. José pë'caguë yua Elí baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí pë'caguë yua Matat baquëña. Matat pë'caguë yua Leví baquëña. Leví pë'caguë yua Melqui baquëña. Melqui pë'caguë yua Jana baquëña. Jana pë'caguë yua José baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pë'caguë yua Matatías baquëña. Matatías pë'caguë yua Amós baquëña. Amós pë'caguë yua Nahum baquëña. Nahum pë'caguë yua Elsi baquëña. Elsi pë'caguë yua Nagai baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pë'caguë yua Maat baquëña. Maat pë'caguë yua Matatías baquëña. Matatías pë'caguë yua Semei baquëña. Semei pë'caguë yua Josec baquëña. Josec pë'caguë yua Judá baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pë'caguë yua Joanán baquëña. Joanán pë'caguë yua Resa baquëña. Resa pë'caguë yua Zorobabel baquëña. Zorobabel pë'caguë yua Salatiel baquëña. Salatiel pë'caguë yua Neri baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pë'caguë yua Melqui baquëña. Melqui pë'caguë yua Adi baquëña. Adi pë'caguë yua Cosam baquëña. Cosam pë'caguë yua Elmadam baquëña. Elmadam pë'caguë yua Er baguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pë'caguë yua Jesús baquëña. Jesús pë'caguë yua Eliezer baquëña. Eliezer pë'caguë yua Jorim baquëña. Jorim pë'caguë yua Matat baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pë'caguë yua Leví baquëña. Leví pë'caguë yua Simeón baquëña. Simeón pë'caguë yua Judá baquëña. Judá pë'caguë yua José baquëña. José pë'caguë yua Jonam baquëña. Jonam pë'caguë yua Eliaquim baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim pë'caguë yua Melea baquëña. Melea pë'caguë yua Mena baquëña. Mena pë'caguë yua Matata baquëña. Matata pë'caguë yua Natán baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán pë'caguë yua David baquëña. David pë'caguë yua Isaí baquëña. Isaí pë'caguë yua Obed baquëña. Obed pë'caguë yua Booz baquëña. Booz pë'caguë yua Sala baquëña. Sala pë'caguë yua Naasón baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón pë'caguë yua Aminadab baquëña. Aminadab pë'caguë yua Admin baquëña. Admin pë'caguë yua Arni baquëña. Arni pë'caguë yua Esrom baquëña. Esrom pë'caguë yua Fares baquëña. Fares pë'caguë yua Judá baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pë'caguë yua Jacob baquëña. Jacob pë'caguë yua Isaac baquëña. Isaac pë'caguë yua Abraham baquëña. Abraham pë'caguë yua Taré baquëña. Taré pë'caguë yua Nacor baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pë'caguë yua Serug baquëña. Serug pë'caguë yua Ragau baquëña. Ragau pë'caguë yua Peleg baquëña. Peleg pë'caguë yua Heber baquëña. Heber pë'caguë yua Sala baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pë'caguë yua Cainán baquëña. Cainán pë'caguë yua Arfaxad baquëña. Arfaxad pë'caguë yua Sem baquëña. Sem pë'caguë yua Noé baquëña. Noé pë'caguë yua Lamec baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pë'caguë yua Matusalén baquëña. Matusalén pë'caguë yua Enoc baquëña. Enoc pë'caguë yua Jared baquëña. Jared pë'caguë yua Mahalaleel baquëña. Mahalaleel pë'caguë yua Cainán baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pë'caguë yua Enós baquëña. Enós pë'caguë yua Set baquëña. Set pë'caguë yua Adán baquëña. Adán pë'caguë yua Riusu baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yureca, Jesusbi Riusu Espírituna te'e zi'inni, recoyo bojoreba bojoguë, Jordán ziaya re'otore jo'cani saiguëna, Riusu Espíritubi baguëte beo re'otona sabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Saguëna, cuarenta umuguseña ba'iguëna, zupai huatibi ti'an rani, Jesusni gu'aye yo'o güeseza caguë, baguëni coqueguë ca bi'rabi. Ca bi'raguëna, Jesusbi gare aon ainmaquë ba'iguëna, cuarenta umuguseña ba'iguëna, ai aon gu'abi baguëre. ");
INSERT INTO snnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aon gu'aguëna, zupai huatibi Jesusni gu'aye ro'ta güeseza caguë, ti'anni, cabi: —Më'ëbi Riusu Zin sëani, ën gatabëte inni, jo'jo aonbëte re'huani ainjë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Caguëna, Jesús sehuobi: —Bañë. Riusu coca toyani jo'case'ere ëñato, ñaca caji: “Bain hua'nabi aon aiñe se'ga yo'ojën ba'itoca, re'oye ba'ima'iñë. Riusu cocareba cani jo'case'ere te'e ruiñe ye'yejën ba'itoca, ai re'oyereba ba'ijën ba'ija'cua'ë.” Ja'an coca toyani jo'case'e sëani, më'ë case'ere yo'oma'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sehuoguëna, ja'nrëbi zupai huatibi baguëte ëmë cubë na'miñona mëani nëconi, si'a ën yija re'otoñare te'e jëana ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ëñoni, baguëni cabi: —Ja'an si'ayete më'ëna insini, si'a ën yija re'otoña ëjaguëre më'ëre re'huayë yë'ë. Yë'ëna insini jo'case'e sëani, yë'ë yëse'e'ru më'ëna insini jo'caye poreyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ja'nca sëani, më'ëbi yë'ëna gugurini rëanni, ujatoca, si'a ëña re'otoña beoru më'ë se'gana ro insini jo'cayë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Caguëna, Jesús sehuobi: —Bañë. Yë'ëre gare jo'cani saijë'ën, Zupai. Riusu coca toyani jo'case'ere ëñato, ñaca caji: “Mai Ëjaguë Riusu se'gana gugurini rëanni, baguë se'gana ujajën ba'ijë'ën” caji. Ja'nca toyani jo'case'e sëani, më'ë caye'ru yo'oma'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sehuoguëna, zupaibi baguëte se'e sani, Jerusalén huë'e jobona ti'anni, Riusu huë'e mi'chiyona nëconi, baguëni cabi: —Më'ëbi Riusu Zin sëani, yijana chajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Riusu coca cani jo'case'ere ëñato, ñaca caji: Riusubi guanseguëna, baguë guënamë re'oto yo'o con hua'nabi më'ëre ëñajën cuirayë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gatana ju'njema'ija'guë cajën, më'ëre ëñajën cuirajën, më'ëre tëani bayë, toyani jo'case'e ba'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Caguëna, Jesús sehuobi: —Bañë. Riusu coca yequë ca'nco'ga ñaca caji: “Riusuni gu'aye yo'o güeseza cama'ijë'ën” toyani jo'case'e sëani, më'ë case'ere yo'oma'iguë'ë yë'ë, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sehuoguëna, zupai huatibi baguëni se'e yo'o güeseye ro'taye porema'iguë sëani, baguëte jo'cani sani, se'e zoe raimaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ja'nrëbi, Riusu Espíritu naconi te'e zi'inni ba'iguëbi ai ta'yejeiye yo'oguë, Galilea yijana go'iguëna, si'a bain ja'anruan ba'icuabi baguë ba'iyete ai cani achojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Si'a huë'e joboñana sani ti'anni, bacua ñë'ca huë'eñana cacani, bainni coca yihuoguëna, si'acuabi bojojën, baguë ta'yejeiye ba'iyete ai re'oye cani achojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ja'nca ba'ijënna, ja'nrëbi, Nazaret huë'e jobo, baguë zinrën ba'isi jobona sani, yo'o yo'oma'i umuguse ba'iguëna, baguë bain yo'ojën ba'ise'e'ru yo'oguë, bain ñë'ca huë'ena cacani baji'i. Ja'nca ba'iguëbi bain jobona nëcani, ");
INSERT INTO snnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Riusu coca toyani jo'case'ere cani achoza caguë, Isaías toyani jo'casi pëbëte insijënna, baguëbi inni anconi ëñato, ën coca toyasiru baji'i: ");
INSERT INTO snnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Riusu cuencueni raosi'quëre sëani, baguë Espírituni yë'ëna gaje meni ba güeseguëna, yë'ë yo'ore yo'ojë'ën, caguë guansebi yë'ëre. Yë'ë bojo güese cocare bonse beo hua'nani quëani achojë'ën. Recoyo ai yo'ojën sa'nti hua'nare bojo recoyo bacuare re'huajë'ën. Jucha zemosicuana sani, bacua etojeiyete cani achojë'ën. Ñaco ëñama'icuare se'e ëña güesejë'ën. Je'o base'e ro'ire ai yo'ojën ba'icuana sani, bacua etojeiyete masi güesejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Riusu rani mame re'huaja'yete si'acuani quëani achoguë ba'ijë'ën caguë, yë'ëre cuencueni raobi Riusu, cani achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cani achoni tëjini, uti pëbëte se'e ganoni, uti pëbë re'hua ëjaguëna go'yani, bëabi. Bëaguëna, si'a ñë'ca huë'e bainbi baguëni ai zoe ëñajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zoe ëñajënna, Jesusbi bacuani coca ca bi'rabi: —Ja'an coca cani jo'case'e ba'iguëna, yure umuguse Riusubi güina'ru yo'o bi'raguë, baguë Raosi'quërebare mësacuani ëñobi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Caguëna, si'acuabi Jesus ba'iyete ai re'oye cajën, baguë re'o coca cani achose'ere ai bojoreba bojojën baë'ë. Yequëcuaca sa'ñeña senni acha bi'rahuë: —¿José mamaquëma'iguë baguë? baguëte jayaye'ru cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cajënna, bacuani sehuobi Jesús: —Mësacua ira bain coca cani jo'case'ere ro'tajën, yequërë yë'ë ba'iyete güina'ru caye'ne? “Më'ëbi ëco uañe masinica, ja'ansi'quëre huachojë'ën” ja'an cocare ro'tani, yë'ë ba'iyete ro'taye mësacua? Yequë cocare'ga yë'ë ba'iyete ro'tajën, yë'ëre cama'iñe'ne? “Më'ëbi Capernaum huë'e jobo ba'iguë yo'ose'e, yëquëna achani masise'e, ja'an'ru güina'ru yëquënani re'oye yo'ojë'ën, më'ë zinrën ba'iguë ba'isi jobore sëani” ja'an coca yë'ëre cama'iñe'ne mësacua? ");
INSERT INTO snnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ja'nca ro'tajën cacuare sëani, mësacua gu'a recoyo ro'tayete masiyë yë'ë. Riusubi baguë bainre coca cani achocuare raoguëna, bacua zinrën ba'ijën ba'isi jobo bainbi bacuani te'e ruiñe ëñamajën, bacuani bojoma'iñë. Ja'nca bojoma'icua sëani, Riusubi tinruan ba'icuare quë'rë re'oye ëñaguë conji. ");
INSERT INTO snnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Riusu ira bainguë raosi'quë Elíasre ro'tajë'ën. Baguë ba'i umuguseña ba'iguëna, ai romi hua'je hua'na Israel yijare ba'ijën, ai yo'ojën bateña. Samute tëcahuëan jobo ocoma'iguëna, ai aon gu'ana ju'iñe ba'iguëna, Riusubi Elíasni baguë yo'ore guanseguëña: ");
INSERT INTO snnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Israel romi hua'je hua'nana conguë saima'ijë'ën. Sarepta baingo, Sidón huë'e jobo ca'ncore ba'igona, ja'ango Israel bain jubë ba'ima'igore conguë saijë'ën caguë, baguëte saoguëña Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Riusu ira bainguë raosi'quë Eliseore'ga ro'tajë'ën. Baguë ba'i umuguseña ba'iguëna, ai ira ca'mi rau bacua Israel yijare ba'ijën, ai yo'ojën bateña. Ja'nca ba'ijënna, Riusubi Eliseoni baguë yo'ore guanseguëña: Naamán hue'eguë, Siria yijabi raisi'quë, ja'anguë se'gare conguë, baguë ira ca'mi raure huachojë'ën caguë, baguëte saoguëña Riusu, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Caguëna, si'acua ñë'ca huë'ere ba'icuabi achani, ai bëinreba bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ja'nca bëinjën, bacuabi Jesusre zeanni rërëni, huë'e jobo ca'ncona sani, ja'anru ba'i cubëna mëani, Ëmë të'ntëbana senjoni baguëre tonñu cajën, senjo ëaye yo'ojënna, ");
INSERT INTO snnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesusbi tijini, bacua joborebabi etajani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ja'nca sani, yequë Galilea huë'e jobo, Capernaum huë'e jobona ti'anni, yo'o yo'oma'i umugusebi bainbi ñë'cajënna, bacuani coca yihuo bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yihuo bi'raguëna, bain hua'nabi achani, ai bojo recoyo re'huani, Ai masiyereba te'e ruiñe caguë, maire yihuoji baguë, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ja'nrëbi, yihuoguë ba'iguëna, yequëbi gu'a huati recoyo cacasi'quëbi bain jobona nëcani, ai jëja güiguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Më'ë guere yo'oguë raquë'ne, Jesús Nazareno? Yëquëna jobore jo'cani, gare saijë'ën. Yëquënani ro carajei güeseguë raiguëna, gare saijë'ën. Më'ë yua Riusu raosi'quëreba ba'iguëna, më'ëni masiyë yë'ë, güiguë cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Güiguë caguëna, Jesusbi baguë huati cacasi'quëni ai bëinguë cabi: —¡Caye beoye ba'ijë'ën, huati! ¡Ba bainguëre jo'cani, etani saijë'ën! bëinguë cabi Jesús. Caguëna, gu'a huatibi ja'an bainguëte te'e jëana yijana taonni uanni, ja'nrëbi baguëte jo'cani etani saji'i. Baguëte ja'si yo'oye beoye saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Saiguëna, si'a bain hua'nabi ai quëquëjën, sa'ñeña senni acha bi'rahuë: —¿Gue'ne yureca? Ta'yejeiye ëjaguërebabi coca guanseguëna, gu'a huati hua'ibi bainre jo'cani etani saiyë, sa'ñeña cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ja'nrëbi, Jesus yo'ose'ere cani achojën, si'a ca'ncoña bainbi achani, bojo coca sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja'nrëbi, yihuoni tëjini, Jesusbi ñë'ca huë'ebi etani sani, Simón huë'ena ti'anbi. Ti'anni bainbi quëajënna achato, Simón rënjo pë'cagobi ai rau jayoni uncoña. ");
INSERT INTO snnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uingona, baguë yua bago uinruna cacani, ja'an rau jayoyete bëin coca cabi. Caguëna, bago rau yua ja'anse'e tëquëna, go'yago. Go'yani, bago yua ja'ansi'co huëni, bain cuira bi'rago. ");
INSERT INTO snnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ja'nrëbi ënsëguë ruajaquëna, si'a bainbi bacua rauna ju'incua, si'a rau bacuare Jesusna sani ëñojënna, bacuare huachobi. Baguë ëntë sarañabi pa'roni ga ju'in hua'nani huachoguëna, si'a hua'nabi huajë hua'na saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gu'a huati hua'i cacasi'cuare'ga Jesusna sani ëñojënna, Jesusbi coca guanseguëna, huati hua'ibi ai güijën, bainre jo'cani etani gare saë'ë. Ja'nca güijën, —Më'ë yua Riusu Zinreba'ë, güijën cajënna, Jesusbi bëin coca caguë, bacua coca güijënna, ënseguë baji'i. Riusu raosi'quërebare masijënna, Jesús yua bacua coca cayete ënseguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ja'nca ba'iguëbi canni ñatani, huë'e jobobi sani, bain beojën ba'iruna ti'anni baji'i. Ti'anni ba'iguëna, bain hua'nabi huëni, ¿Jarona saquë'ne baguë? cajën, baguëni cu'ejaë'ë. Cu'ejani, baguëte tinjani, Yëquëna naconi gare bëani ba'ijë'ën cajën ba'icuareta'an, ");
INSERT INTO snnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","bacuani sehuobi Jesús: —Porema'iñë. Si'a huë'e jobo bainna raosi'quë sëani, Riusu bainrebare mame re'huani baja'yete yequë huë'e joboña bainni quëani achoguë saiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja'nca cani, si'a Galilea yija huë'e joboñana sani, bain ñë'ca huë'eñana cacani, Riusu cocarebare quëani achoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ja'nca ba'iguëbi yequë umuguse Genesaret zitara yëruhuana ti'anni ba'iguëna, ai ëama'iñereba bain jubëbi baguëna ti'an rani, Riusu cocarebare achañu cajën, si'a ca'ncoñabi baguëni jë'jejën guiojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ba'ijënna, Jesusbi ca'ncore ëñato, samu yoguan mejabëna rërëni tëosiguan baji'i. Hua'i yocuabi mëani, bacua huanterëanre zoajën saimate. ");
INSERT INTO snnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Te'e yogu Simón yogu ba'iguëna, Jesusbi cacani, Simonni, Choa ma'carë quëñëni huahuañu cabi. Cani, ja'nca quëñëni, Jesusbi yogute ñu'iguë, bain hua'nani coca yihuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yihuoni tëjini, ja'nrëbi Simonni cabi: —Rëi zitara ba'iruna saiñu. Më'ë huanterëanre senjoni, hua'ire yojë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Caguëna, Simonbi sehuobi: —Ëjaguë, yëquënabi yure ñami hua'ire yojën ñata hua'nata'an, ro hua'i beo hua'na raë'ë. Ja'nca ba'iyeta'an, më'ëbi guanseguëna, huanterëte se'e senjoni, ëñana'a, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cani, ja'nrëbi huanterëte senjoni, ziaya hua'ire ai ta'yejeiye yohuë. Huanterë ye're ëaye ba'iye ai hua'i yohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ja'nca yoni, bacua gajecua yequë yogute ba'ijënna, bacua ëntë sarañabi ba'bojën choë'ë. Choni, bacuabi raijënna, samu yoguan ruca ëaye ba'iye tëca hua'ire bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ayajënna, ja'nrëbi, Simón Pedrobi ba hua'i yose'ere ëñani, Jesusna gugurini rëanni, baguëni cabi: —Ai gu'a bain hua'guë'ë yë'ë. Ja'nca sëani, Ëjaguë, yë'ëre jo'cani saijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ja'nca caguë, Simón, baguë naconi ba'icua, si'acuabi bacua hua'i yo'ose'e ai ba'iye yose'ere ëñajën, ai quëquëhuë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simón gajecua Santiago, Juan, ja'an Zebedeo mamacua, bacua'ga güina'ru ai quëquëhuë. Quëquëjënna, Jesusbi Simonni cabi: —Quëquëma'ijë'ën. Yureca bainrebare yoguë ba'ijë'ën, cabi. Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Caguëna, bacuabi bacua yoguanre rërëni mëani, si'ayete gare jo'cani senjoni, Jesús naconi te'e conjën, gare saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sani, yequë huë'e jobona ti'anjënna, ira ca'mi rauna ju'inguëbi yua Jesusna ti'anni, gugurini rëanni, baguëni senni achabi: —Ëjaguë, më'ëbi yënica, yë'ë hua'guëre huachojë'ën. Ta'yejeiye ba'iguë sëani, huachoye poreyë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Caguëna, Jesusbi baguë ëntë sarare mi'nani, baguëna pa'roguë cabi: —Aito. Yëyë. Huajë hua'guë ba'ijë'ën, cabi. Ja'nca caguëna, ja'ansirën, ira ca'mi rau beo hua'guë runji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ruinguëna, Jesusbi baguëni guanseguë cabi: —Yequëcuani më'ë huajë raise'ere gare quëamaquë ba'ijë'ën. Pairi se'gana saiguë ba'ijë'ën. Ja'nca ba'iguë, më'ë huajë raise'ere baguëni ëñojë'ën. Ja'nca ëñoni, ja'nrëbi, ba hua'i ëoye, Moisés guanseni jo'case'e'ru inni, misabëna tëoni ëoni, Riusuna mëojë'ën. Ja'nca bojoguë yo'oguëna, bainbi më'ë huajë raise'ere masija'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ja'nca caguëta'an, Jesús yo'ose'e, baguë ba'iye cato, bain hua'nabi yua quë'rë se'e sa'ñeña quëajën, si'aruanna quëani ganojaë'ë. Quëani ganojaijënna, ai bainbi, Baguë coca yihuoyete achañu cajën, bacua rau huacho güesejën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Raijënna, baguë se'gabi yua bain beo re'otona gatini sani, Taita Riusu naconi ujaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ja'nrëbi, yequë umuguse ba'iguëna, Jesusbi bainre coca yihuoguëna, yequëcua fariseo bain, yequëcua ira bain toyani jo'casi coca masiye ye'yocua, bacuabi achajën ñuë'ë. Si'a huë'e joboñabi raisi'cua baë'ë. Galilea huë'e joboña, Judea huë'e joboña, Jerusalén, ja'anruanbi rani, Jesusre achajënna, Ja'quë Riusubi ai ta'yejeiyereba conguëna, Jesusbi rau ju'incuare huachoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huachoguë ba'iguëna, yequëcuabi garasi'quëni camare uinguëna, cuanni rahuë. Rani, Jesusna cacani, Ënquëre uanjaiñu cajën ba'icuata'an, ");
INSERT INTO snnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ai bain ba'ijënna, garasi'quë naconi cacaye gare poremaë'ë. Ja'nca sëani, huë'e ëmëje'ena mëani, huë'e ja'ore otani, goje yo'ohuë. Yo'oni ja'nrëbi, garasi'quëre cama uinguëna, bain jobona meñe gachoni, Jesús ba'iruna uanhuë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja'nca uanni, Jesusbi huachoye poreji cajën, baguëni recoyo ro'tajënna, Jesusbi baguë ñacobi ëñani, bacua ro'tase'ere masibi. Ja'nca masini, garasi'quëni cabi: —Mami, më'ë gu'a jucha yo'oguë ba'ise'e yua gare huanë yeni tonse'e ba'iji. Më'ë recoyo yua mame re'huani tënose'e ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja'nca caguëna, bain ye'yocua, fariseo bain naconi, bacuabi achani, ja'ansi'cua ro'tajën, ¿Baguë guere yo'oguë, Riusure gu'aye caguë'ne? Ro bainguë sëani, bain juchare gare huanë yeni toñe ti'anma'iji, ro'tajën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ro'tajën ñu'ijënna, Jesusbi baguë ñacobi ëñani, bacua ro'tase'ere masini, bacuana bonëni cabi: —¿Mësacua guere yo'ojën ja'nca ro'tajën cajën ñu'iñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Si'a bainbi “Më'ë gu'a jucha yua huanë yeni tonse'e ba'iji” caye poreyë. Caye porecuata'an, “Huëni, më'ë camare inni ganijë'ën” catoca, bacua huachoye porema'iñete masi güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ja'nca güesecuata'an, yë'ë yua Riusu raosi'quëreba ba'iguë sëani, bain gu'a juchare huanë yeni toñe pore ëjaguë'ë yë'ë. Ja'anre mësacuani yure ëñoñë cabi. Cani ja'nrëni, garasi'quëni cabi: —Achajë'ën. Më'ë camare inni, më'ë huë'ena go'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Caguëna, si'acuabi ëñajënna, garasi'quëbi yua ja'ansirën huëni, baguë camare inni, Taita Riusuni ai bojo coca caguë, baguë huë'ena goji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Go'iguëna, si'a bainbi ai bojoreba bojojën, Riusuni ai re'oye ro'tajën cahuë: —Riusurebabi ai ta'yejeiyereba ai re'oye yo'oguëna, gare ëñama'icuabi ëñañë mai, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ja'nrëbi, Jesusbi etani sani ëñato, impuesto curi coguë, Leví hue'eguëbi baguë curi corute ñuji'i. Ñu'iguëna, Jesús yua baguëni —Yë'ëre te'e conguë raijë'ën, caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Choiguëna, Levibi te'e jëana huëni, si'aye gare jo'cani senjoni, Jesusni te'e conni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sani ja'nrëbi jë'te, Jesusni bojoguë, Fiestare yo'oza caguë, baguë gajecuare baguë huë'ena choji'i. Choiguëna, impuesto curi tëtecua, yequëcua naconi, ai bainbi sani, Leví huë'ena ti'anni, Jesús naconi aon ainjën te'e bojojën ñuë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ñu'ijënna, fariseo bain, bacua gaje ye'yocua naconi ti'anni, Jesusre yo'o concuani ëñani, bëin coca ca bi'rahuë: —¿Mësacua guere yo'ojën, gu'a bain naconi te'e ñu'ijën, aon ainjën, gono uncujën conni ba'iye'ne? Impuesto curi tëtecua naconi te'e ñu'ijën, ai gu'aye yo'oyë mësacua, senni achajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ja'nca senni achajënna, Jesusbi bacuani ye'yo coca caye'ru bacuani sehuobi: —Huajë hua'nabi ëco yo'oguëte senma'iñë. Rauna ju'incua se'gabi ëco yo'oguëte señë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Güina'ru, re'o bain casi'cua ba'itoca, bacuare choiguë raimaë'ë yë'ë. Gu'a bain se'gare choiguë raisi'quë'ë yë'ë, bacua gu'a juchare senjoni mame recoyo re'huacuare, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sehuoguëna, bacua yua yeque cocare baguëni senni achahuë: —Juanre yo'o concua, fariseo bainre yo'o concua, bacuabi Riusuni ujaye se'ga yo'oñu cajën bacua aon ainmajënna, ¿më'ëre yo'o concua queaca ro'tajën, güina'ru yo'oma'iñe'ne? Ro aon ainjën, ro gono uncujën yo'ocua'ë, senni achajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Senni achajënna, Jesús sehuobi: —Mësacua ¿queaca ro'tajën, bain hueja fiestana choisi'cuani aon ainma'iñe guanseye'ne? Huejaja'guëbi yuta ba'iguëna, aon aiñe gare jo'cama'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ja'nca jo'camajënna, jë'te yequëcuabi ba huejaja'guëte preso zeanni quëñoja'cua'ë. Ja'nca quëñojënna, ja'anrën ti'anguëna, yë'ëre yo'o concuabi aon aiñe jo'caja'cua'ë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ja'nca cani, ja'nrëbi se'e yeque ye'yo cocare bacuani quëa bi'rabi: —Ira ye'resi canre re'huaye yëtoca, mame ju'i canbi ye'reni, ira canna ja'cheni ta'nëñe gare yo'oma'icua'ë. Ja'nca yo'otoca, mame can yua gu'a can'ru ruinguëna, ira can ja'chese'ebi ai si'si ëñoji. ");
INSERT INTO snnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bisi ëye jo'cha huajë jo'cha ba'itoca, ira ga'ni corohuëanna ayaye gare yo'oma'icua'ë. Yo'otoca, huajë jo'chabi huo'coni, ira ga'ni corohuëanre juejueni, jañuni huesëji. Ga'ni corohuëan'ga gu'a corohuëan'ru ruinji. ");
INSERT INTO snnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ja'nca sëani, maibi huajë jo'chare mame ga'ni corohuëanna ayayë. Ja'nca ayajënna, ba jo'cha, ba ga'ni corohuëan re'oye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bisi ëye jo'cha ira jo'cha, ja'anre uncuye ye'yesi'cuabi yua huajë jo'chare uncuye güeyë. “Ira jo'cha yua quë'rë hua'i sëñera ba'iji” cajën, huajë jo'chare güecua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ja'nrëbi yequë umuguse, yo'o yo'oma'i umuguse ba'iguëna, Jesusbi baguëre yo'o concua naconi trigo zio re'otobi ganijën, baguëre concuabi trigo za'zare tëani, bacua ëntë sarañabi bo'teni, trigora'carëanre huajë ainjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ja'nca ainjën saijënna, fariseo bainbi ti'anni, bacuani bëinjën, coca senni achahuë: —¿Mësacua guere yo'ojën, mai ira coca toyani jo'case'e'ru tin yo'oye'ne, yo'o yo'oma'i umuguse sëani? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Senni achajënna, Jesús sehuobi: —Mësacua yua mai ira coca toyani jo'case'ere ëñajën, ¿David yo'osi cocare ëñamate'ne? Baguëre concua naconi sani, aon gu'aguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","baguë yua Riusu huë'ena cacani, Riusuna jo'casi aonbëan, jo'jo aonbëanre inni anquëña. Ainguë, baguëre concuare'ga aon huo'hueguëña. Riusu pairi bain se'gabi ja'an aonre ainja'bë cani jo'case'eta'an, David yua bain ta'yejeiye ëjaguë sëani, tin yo'oguëña. Ja'an coca toyani jo'case'e ba'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","yë'ë'ga Riusu Raosi'quëreba ba'iguë, yo'o yo'oma'i umuguse ëjaguë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ja'nrëbi, yequë umuguse yo'o yo'oma'i umuguse ba'iguëna, Jesusbi bain ñë'ca huë'ena ti'anni, bainre coca yihuoguë baji'i. Yihuoguë ba'iguëna, yequëbi baguë jëja ëntë sara guë'nguësi sara ba'iguë, ja'anguëbi baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ba'iguëna, fariseo bain, ira coca ye'yocua naconi ba'ijën, Jesusni yahue ëñajën ëjohuë. Ja'an bainguëni huachotoca, baguë gu'aye yo'oyete cani achoñu cajën, yo'o yo'oma'i umuguse ba'iguëna, Jesusre yahue ëñajën ëjohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ja'nca ëjojënna, Jesusbi baguë ñacobi ëñani, bacua yahue ro'tase'ere masini, guë'nguësi sara baguëte choiguë cabi: —Huëni raijë'ën. Bain joborana nëcani ba'ijë'ën, caguë choji'i. Choni, ba bainguëbi huëni raiguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús yua bain hua'nani cabi: —Yë'ëbi coca senni achaguëna, mësacua ro'tajë'ën. Mai ira coca toyani jo'case'ere ëñato, yo'o yo'oma'i umuguse ba'itoca, ¿gue yo'o yo'oye poreye'ne mai? ¿Guere caguë'ne? ¿Bainni re'oye yo'oye, o bainni gu'aye yo'oye caguë? ¿Rauna ju'inguëte huachoye, o baguëte carajei güeseye caguë? ¿Guere caguë'ne mai ira coca toyani jo'case'e? senni achaguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ja'nca senni achaguë, si'acuani bonëjeiñe ëñani, ja'nrëbi guë'nguësi sara baguëni cabi: —Më'ë ëntë sarare mi'najë'ën, cabi. Caguëna, ba hua'guë yua baguë ëntë sara mi'nani, ja'ansirën huajë ëntë sara baguë runji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ja'nca ruinguëna, ja'an gu'aye ro'tacuabi ai bëinreba bëinjën, sa'ñeña coca ca bi'rahuë: ¿Queaca yo'oni baguëte carajei güeseja'ye'ne mai? senni achajën, Jesusni bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja'nrëbi jë'te, Jesusbi, Taita Riusu naconi ujajaza caguë, jai cubëna mëni, si'a ñami ujaguë ñatajaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ñatajani ja'nrëbi, baguëre yo'o concuare choini, si'a sara samucuare cuencueni, Yë'ë ta'yejeiye yo'ore yo'ojën ba'ijë'ën caguë jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bacua mami hue'eyete cato, ñaca hue'ecua baë'ë: Simón hue'eguëte yua yequë mami Pedrote hue'yobi. Yequë Andrés, Simón yo'jeguë baji'i. Yequë Santiago, yequë Juan, yequë Felipe, yequë Bartolomé, ");
INSERT INTO snnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yequë Mateo, yequë Tomás, yequë Alfeo mamaquë Santiago, yequë Simón hue'eguë cananista jubë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yequë Santiago yo'jeguë Judas, yequë Judas Iscariote hue'eguë, Jesusre preso zean güeseni senjoja'guë, ja'ancuare cuencueni, baguë ta'yejeiye yo'o concuare re'huabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ja'nca re'huani tëjini, bacua naconi gajeni, te'e ruin yija ba'iguëna, baguëre yo'o concua naconi ti'anni, bainre yihuo bi'rabi. Ai jai jubë bain ñë'casi'cua baë'ë. Judea yija bain, Jerusalén huë'e jobo bain, Tiro, Sidón, ja'an huë'e joboña bain, ai jai jubëbi ti'an rani, Jesús cocare achañu cajën, Mai raure huacho güeseñu cajën raisi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ja'nca ba'ijën, gu'a huati cacasi'cua'ga ti'an raijënna, Jesusbi si'acuare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ja'nca huachoguë ba'iguëna, bain hua'nabi, Baguë ta'yejeiyereba yo'oyete ëñani masiñu cajën, baguëni pa'ro ëaye yo'ojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ja'nrëbi, Jesusbi baguëre yo'o concuani ëñaguë, yihuo cocare cabi: Mësacua yua yo'jereba ba'i hua'na ba'icuata'an, bojo recoyo re'huani ba'ijë'ën. Riusu re'otorebare ba'ijën ai ta'yejeiye coreba cojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mësacua yua Riusu ba'iyete quë'rë se'e masi ëaye ba'icuata'an, bojo recoyo re'huani ba'ijë'ën. Riusuni te'e ruiñereba masija'cua'ë. Mësacua gu'a jucha yo'ojën ba'ise'ere ai oijën ba'icuata'an, bojo recoyo re'huani ba'ijë'ën. Jë'te gare oiye beoye chojën bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mësacua yua yë'ë bainreba, Riusu Raosi'quëreba re'huasi'cua ba'ijënna, yequëcuabi ja'an ro'ina mësacuare ai je'o bajën, mësacuare saoni senjojën, mësacuare ro a'ta gu'aye ro'tajën, ai hui'ya cajën, ja'an ba'ija'cua'ë. Ja'nca ba'ijënna, mësacuabi ai yo'ojën ba'icuata'an, bojo recoyo re'huani ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ja'an umuguseñabi ai yo'ojën ba'icuata'an, mësacua ai bojoreba bojojën, Riusu guënamë re'oto insija'yete te'e jëana coja'yeta'an ba'iji yë'ëre cajën, ai bojo recoyo re'huani ba'ijë'ën. Ja'an gu'a bainbi mësacuani je'o bajën, bacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru, Riusu bainre gu'aye yo'ojën ba'ise'e'ru, mësacuani güina'ru gu'aye yo'ojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yureca mësacua bonse ëjacua ba'ijën, ja'an bonse se'gare bojojën ba'itoca, ai bëiñe cani jo'case'e ba'iji mësacuare. Riusu insija'yete gare coye beoye ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mësacua yua ro ën yija ba'iyete bojoreba bojojën ba'itoca, mësacuare ai bëiñe cani jo'case'e ba'iji. Mësacua yua ai aon gu'ana ju'injën ba'ija'cua'ë. Mësacua yua yureña ba'iye se'gare ai bojojën, sa'ñeña gue güihuara chojën ba'itoca, ai bëiñe cani jo'case'e ba'iji mësacuare. Mësacua yua si'a recoyo ai sa'ntireba sa'ntijën ai oijën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mësacua bainbi mësacua ba'iyete ai re'oye cajën ba'itoca, Riusu ro'tayete te'e ruiñe masijë'ën. Mësacuani bënni senjoja'ñeta'an ba'iji. Mësacua ira bain ba'isi'cuabi güina'ru yo'ojën bateña. Yequëcuabi ti'anjën, Riusu raosi'quë'ë yë'ë coquejën cajënna, mësacua ira bain ba'isi'cuabi bacua ba'iyete ai re'oye cajën bateña. Mësacua bainbi yureña mësacuare'ga ai re'oye cajënna, Riusu bënni senjoja'ñete masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yureca, mësacua, yë'ë cocare achani Jaë'ë cajën ba'icua, mësacuani ñaca yihuoyë yë'ë: Yequëcuabi mësacuani je'o batoca, bacuare ai oijën conjën, bacuani ai yëreba yëjën ba'ijë'ën. Yequëcuabi mësacuani ai bëintoca, bacuare re'oye yo'oye se'ga ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yequëcuabi mësacuani gu'aye catoca, bacuani re'oye cani jo'caye se'ga ba'ijë'ën. Yequëcuabi mësacuani ai hui'ya yo'otoca, bacuani oire bajën, Riusuni senni achajën, bacua ba'iyete ujajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yequëbi më'ë huayohuana huaitoca, më'ë yequë huayohuare'ga baguëni huai güesejë'ën. Yequëbi më'ë guayoni se canre tëteni batoca, më'ë ëntë sara canre'ga baguëna ro insijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yequëbi më'ë ba ma'carëanre sentoca, ënseye beoye baguëna ro insijë'ën. Më'ë bayete ro tëteni batoca, baguë se'e go'yayete senma'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yequëcuani re'oye yo'oye ro'tato, mësacuani re'oye yo'oye, mësacua yëyete ro'tajën, yequëcuare'ga güina'ru te'e ruiñe yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mësacuare ai yëcua se'gani ai yëjën ba'itoca, mësacuabi re'oye yo'oye ti'anma'icua ba'iyë. Gu'a bainbi güina'ru re'oye yo'oye masiyë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mësacuare re'oye yo'ocua se'gani re'oye yo'ojën ba'itoca, mësacuabi re'oye yo'oye ti'anma'icua ba'iyë. Gu'a bainbi güina'ru re'oye yo'oye masiyë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mësacua bonse go'yajaicua se'gani bonse prestajën ba'itoca, mësacuabi re'oye yo'oye ti'anma'icua baesacua yëyete ro'tajën, yequëcuare'ga güina'ru te'e ruiñe 'iyë. Gu'a bainbi bacua gu'a gajecuani bacua bonsere prestajën, Bacuabi ja'anre go'yaja'bë cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mësacuaca mësacuani je'o bacuani ai yëjën ba'ijë'ën. Bacuani re'oye yo'oye se'ga ba'ijë'ën. Mësacua bonsere prestaye sentoca, ja'anre se'e coni baye ro'tamajën, bacuana insijën ba'ijë'ën. Ja'nca yo'ojën ba'itoca, Riusu ta'yejeiye insija'yete ai coni baja'cua'ë mësacua. Riusu ta'yejeiyereba ba'iguë sëani, mësacuani caraye beoye ai conreba conguë ba'iji. Baguë yua ro gu'a bain, baguëni surupa gare cama'icua, ja'ancuare ai re'oye conguë sëani, mësacuare'ga quë'rë ta'yejeiye conreba conguë'bi ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ja'nca sëani, mësacua yua Taita Riusu oiguë bani coñete ro'tajën, mësacua güina'ru bainre oijën conjën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mësacua yua yequëcua gu'aye yo'oyete bëinjën cama'ijë'ën. Bacuare bënni senjo cocare caye beoye ba'ijë'ën. Ja'nca ba'itoca, Riusu'ga mësacuare bënni senjoma'ija'guë'bi. Bacuabi gu'aye yo'ojënna, Më'ë gu'aye yo'oni tonse'ere huanë yeye se'ga ba'iyë yë'ë, bacuani cajë'ën. Ja'nca catoca, Riusubi mësacua gu'aye yo'ojën ba'ise'ere ëñani, mësacua gu'aye yo'ojën ba'ise'ere huanë yeye se'gare caja'guë'bi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mësacua bonsere ëñajën, yequëcuana ro insijën ba'ijë'ën. Ja'nca ro insijën ba'itoca, Riusu'ga mësacuana ai insireba insija'guë'bi. Gare ënseye beoye insiguë, mësacua jai turubëna ayani, ña'goni guioni, turubë bu'iye tëca ai ayaye'ru mësacuana ta'yejeiye ai insireba insija'guë'bi Riusu. Mësacua yua, Bonsere bendieza cajën, bonsere cuencueni insijënna, Riusubi ëñani, mësacua cuencuese'e'ru güina'ru cuencueni mësacuana insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mësacua yua ën cocare'ga ro'tani ye'yejë'ën. Ñaco ëñama'iguëbi baguë ñaco ëñama'i gajeguëni caguë: Raijë'ën. Saiñu. Ma'are më'ëni ëñoza caguë, ja'nrëbi saitoca, ¿queaca ma'are ëñoñe poreguë'ne? Porema'iji. Si'a samucuabi saijën, yorobëna te'e gurujani tonni huesëyë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Masiye ye'yoguëna, baguë coca ye'yeguëbi ye'yoguë'ru quë'rë ta'yejeiye masiye ti'anma'iji. Ti'anma'iguë, baguë uti ye'yeni tëjini, baguë ye'yoguë ba'iye'ru te'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yureca, më'ë gaje hua'guëbi gu'aye yo'oguëna, baguëni bënni senjo cocare cama'ijë'ën. Baguë ñacogana ëñani, Hui'ya zin'garëte rutaza caguë, yua jai hui'ya maca më'ë ñacogate ba'iguëna, ja'anre ro ro'taguë rutama'itoca, ");
INSERT INTO snnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿queaca më'ë gajeguë ñaco ba'i zi'ngarëte rutaguë'ne? Më'ë ñacoga ba'i macare rutaye ro'tama'itoca, ro coqueguë yihuoyë më'ë. Ru'ru, më'ë ñacoga ba'i maca, ja'an jai hui'ya macare rutani, ja'nrëbi ai re'oye ëñañe poreguëbi sani, më'ë gajeguë ñacogana re'oye ëñani, ja'an hui'ya zi'ngarëte guaja beoye rutaye poreyë më'ë. Më'ë gajeguëni gu'a jucha yo'ose'ere senjojë'ën yihuoye ro'tatoca, ru'ru më'ë gu'a juchare jo'cani senjojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bain coca cayete achani, bacua recoyo ba'iyete masijë'ën. Re'o sunquiñë ba'itoca, gu'a uncue gare quëinma'iji. Gu'a sunquiñë ba'itoca, re'o uncue gare quëinma'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mësacua yua si'a sunquire ëñajën, ba uncue quëinse'ere ëñajën, ja'an sunquiñë ba'iyete masijë'ën. Miu sunquiñë ba'itoca, higo uncuere ja'añëna tëaye porema'iñë. Susihuë ba'itoca, ëyere tëaye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Güina'ru, re'o bainguëbi coca catoca, re'oye se'gare caji, re'o recoyo baguë sëani. Gu'a bainguëbi coca catoca, gu'aye se'gare caji, gu'a recoyo baguë sëani. Ja'nca sëani, bain recoyo ba'iyete masiye yëtoca, bacua coca cayete achani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mësacua jubë ba'icua yequëcuabi yë'ëre cajën, Ëjaguë, Ëjaguë, cajën ba'icuata'an, yë'ë cayete gare yo'oye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yë'ëna ti'an rani, yë'ë cocare te'e ruiñe achani, gare güeye beoye yo'otoca, ");
INSERT INTO snnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","re'o huë'e yo'oguë'ru ba'iyë. Ja'an huë'ere yo'oguë, ai rëiye no'ani, gata yija tëca no'ani, huë'e ture gata naconi guioni, re'oye pë'npëni, re'o huë'ere nëcoji. Nëcoguëna, ja'nrëbi, ziayabi ai co'jeya rëoni, ai saoya ti'anguëna, baguë huë'e gurujaima'iji, gata naconi guiose'e sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yequëbi yë'ëna ti'an rani, yë'ë cocare ro achani, ro yo'oye beoye saitoca, gu'a huë'e yo'oguë'ru ba'iji. Ja'an huë'ere yo'oguë, bean goje no'aguë, huë'e ture re'oye guioma'iguë, huë'ere te'e ruiñe nëcoma'iji. Ja'nrëbi, ziayabi ai co'jeya rëoni, ai saoya ti'anguëna, baguë huë'e yua te'e jëana gurujani meaji, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cani, bainre yihuoni tëjini, ja'nrëbi Capernaum huë'e jobona sani baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ba'iguëna, romano bainguë soldado jubë ëjaguëbi baguë yo'o conguëbi rau neni ju'inguë ba'iguëna, baguëte ai oire baguë, ");
INSERT INTO snnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesús ba'iyete achani, Yë'ë yo'o con huaguëni huacho raija'guë caguë, judío ëja bainni caguë guansebi: Jesusni quëajaijë'ën: Yë'ë yo'o con hua'guëbi rau neni ju'inguëna, huacho raija'guë caguë guanseni saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Saoguëna, bacuabi Jesusna sani, baguëni si'a jëja senni achahuë: —Romano ëjaguëbi ai re'oye yo'oguëre sëani, baguëte conjë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yëquëna jubë judío bainni ai re'oye conguë, yëquëna ñë'ca huë'ere yo'oye guanseni, si'aye roji'i. Ja'nca sëani, baguë yo'o conguëte huacho raijë'ën, senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ja'nca cajënna, bacua naconi saji'i. Sani, ti'an bi'rani, yuta so'orë ba'iguëna, romano ëjaguëbi baguë gaje hua'na naconi Jesusna coca raobi: —Ëjaguë, më'ëni ro guaja choë'ë yë'ë. Më'ë yua ai ta'yejeiye ëjaguërebare sëani, yë'ë huë'ena cacayete më'ëni choiye ti'anma'iguë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yë'ë'ga sani, më'ëni choiye ti'anma'iguë'ë yë'ë. Ja'nca ti'anma'iguëre sëani, yë'ë huë'e ti'anma'ijë'ën. Më'ë guanse coca se'gare caguëna, yë'ë yo'o con hua'guëbi huajë raija'guë'bi. Ja'an se'gare yo'ojë'ën caguë saoyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ja'nca caguë saoguëbi yequëcua yë'ë ëjacuani sehuoye bayë yë'ë. Yequëcua soldado hua'nare guanseye bayë yë'ë. Yequëni, Saijë'ën catoca, baguë saiji. Yequëni, Raijë'ën catoca, baguë raiji. Yë'ë yo'o con hua'guëre'ga, Yë'ë case'e'ru yo'ojë'ën catoca, te'e ruiñe yo'oji baguë. Yë'ë case'e'ru te'e yo'ocua sëani, më'ë raima'iguë huacho coca guanseye se'ga cajë'ën, caguë raobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Caguë raoguëna, Jesusbi achani, romano ëjaguë case'ere ai bojoguë, bain be'tejën raicuana bonëni cabi: —Ja'an soldado ëjaguëbi yë'ëni ai recoyo ro'taji. Si'a Israel bain recoyo ro'tayete ëñato, baguë recoyo ro'taye'ru ro'taye ti'anma'iñë si'acua, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Caguëna, judío ëja bainbi romano ëjaguë huë'ena go'ini ëñato, baguë yo'o con hua'guëbi gare huajë raisi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ja'nca ba'iguëna, ja'nrëbi, Jesús yua yequë huë'e jobo, Naín huë'e jobona saji'i, baguëre yo'o conjën ye'yecua naconi. Ai bain jubë be'tejën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sani, huë'e jobo caca sa'rona ti'anni ëñato, bain hua'nabi ju'insi'quëni tanza cajën, etajën baë'ë. Ju'insi'quë pë'cago hua'jeni ba'igobi gaña hua'guëni hueansi'co baco'ë. Ai bain jubëbi bagore conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja'nca saijënna, Jesusbi ai oiguë, bagoni cabi: —Oima'ijë'ën cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Cani ja'nrëbi, baguëre tan ganjoguna ti'anni pa'roguëna, bagu sacuabi nëcajaë'ë. Nëcajaijënna, ja'ansi'quëbi ju'insi'quëni coca cabi: —Huëijë'ën, mami, yë'ëbi cayë më'ëre, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Caguëna, ja'nrëbi ba bonsëguë junni uinguëbi huëni bëani, coca ca bi'rabi. Coca ca bi'raguëna, baguëte ba pë'cagoni ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ëñoguëna, si'a bainbi ai ëñajën rëinjën, Taita Riusuni ai bojojën cahuë: —Riusu Raosi'quë ai ta'yejeiye ëjaguëbi maina ti'an raji'i. Baguë bainna rani, maini ai oiguë conji. Baguë bainrebare re'huani, maire tëani baza caguë raisi'quë'bi, cajën bojohuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Cajën bojojënna, ja'nrëbi yequëcuabi achani, baguë yo'ose'ere si'a Judea huë'e joboñana quëani achojaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Quëani achojaijënna, Juanre concuabi achani, Juanna sani, si'aye quëahuë. Quëarena, Juan yua baguëre yo'o concuare samucuare choini, bacuani guanseguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mësacua yua Jesusni senni achajaijë'ën. ¿Më'ë yua Riusu Raoja'guëreba cani jo'casi'quë ba'iguë'guë? Ba'ima'itoca, ¿Riusubi yequëre raoja'guë'guë? Ja'an cocare baguëni senni achani rani quëajë'ën caguë, bacuare saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Saoguëna, bacuabi Jesusna sani ti'anni, baguëre senni achahuë: —Yëquëna yua Juan Bautizaguë raosi'cua'ë. Më'ëni coca senni achaye guansebi: ¿Më'ë yua Riusu Raoja'guëreba cani jo'casi'quë ba'iguë'guë? Ba'ima'itoca, ¿Riusubi yequëre raoja'guë'guë? Jesusni senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja'nca senni achajën ëñato, Jesusbi ai bain hua'nani huachoguë baji'i. Yequëcuabi rauna ju'injënna, yequëcuabi huati hua'ire bajënna, yequëcuabi ñaco ëñama'ijënna, Jesusbi si'acuare huachoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ja'nca huachoguë, bacuani sehuobi: —Mësacua yua Juanna go'ini, mësacua ëñase'e, mësacua achase'e, ja'an si'ayete baguëni quëajaijë'ën. Ñaco ëñama'icuabi ñaco huajëyë. Ira ca'mi rau bacuabi huajë raiyë. Ganjo achama'icuabi ganjo huajëyë. Guëon garasi'cuabi se'e ganiñë. Junni huesësi'cuabi go'ya raiyë. Bonse beo hua'na'ga Riusu bojo güese cocare te'e ruiñe achaye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ja'nca sëani, yë'ëni jo'caye beoye recoyo ro'tajën ba'itoca, ai bojoreba bojojën ba'ija'cua'ë. Ja'anre Juanna quëajaijë'ën caguë, bacuare Juanna saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Saoni, gotena, Jesusbi bain jubëni Juan ba'iyete quëa bi'rabi: —Mësacuabi beo re'otona sani, Juanre ëñañu cajën, ¿neni ëñañe ro'tare'ne? “Ro jëja beo hua'guë, jë'je sahua tutu taonse'e'ru ba'iguëte ëñajaiñu” cacuata'an, ai jëja recoyo babi Juan. ");
INSERT INTO snnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mësacua neni ëñañe ro'tare'ne? “Ëjaguë caña ju'iguëte ëñajaiñu” cacuata'an, ja'nca ju'imaji'i. Ëjaguë caña ju'icua yua me'najeiñe ba'icua, ja'ancua yua ta'yejeiye ëja bain huë'eña se'gare ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Mësacua neni ëñañe ro'tare'ne? “Riusu coca quëani achoguëte ëñajaiñu” catoca, mësacua te'e ruiñe ro'tahuë. Aito. Riusu coca quëani achocua si'acua'ru quë'rë ta'yejeiye ëjaguë ba'iguëni mësacua ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Riusu ira coca toyani jo'case'ere ëñato, yua Juanre ñaca toyani jo'case'e ba'iji: Bain ëjaguë rai ma'are re'huacaija'guë caguë, yë'ë coca quëani achoguëte bainna ru'ru saohuë yë'ë, cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ja'nca cani jo'caguëna, mësacuani ganreba quëayë yë'ë. Juanbi yua Riusu coca quëaye raosi'cua si'acua'ru quë'rë ta'yejeiye ëjaguë ba'iji baguë. Ja'nca ba'iguëta'an, Riusu ba'i jobona ëñato, baru ba'iguë quë'rë yo'je ba'i hua'guëbi Juanre quë'rë ta'yejeiye ëjaguëbi ba'iji, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ja'nca quëaguëna, bain hua'na, impuesto curi cocua ja'ancua yua Juanna sani bautiza güesesi'cua ba'ijën, ja'ancuabi achani, Riusubi te'e ruiñe yo'oji cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ja'nca cajën ba'ijënna, fariseo bain, ira coca ye'yocua naconi, bacuabi yua Juan bautizayete güejën, Riusu insini jo'caja'ye, baguë coñete gare gu'a güejën senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Güejën senjojënna, Mai Ëjaguë Jesusbi bacuani quëabi: —Yureña bain ba'iyete ¿queaca quëaye'ne yë'ë? ");
INSERT INTO snnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zin hua'na sa'ñeña huere yo'ocua'ru ba'iyë. Ja'nca ba'ijën, bacua gajecuani güijën cayë: “Yëquënabi jurihuëte juijënna, ¿mësacua guere yo'ojën pairamate'ne? Yëquënabi sa'ntiye gantajënna, ¿mësacua guere yo'ojën oimate'ne?” güijën cayë zin hua'na. ");
INSERT INTO snnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ja'nca güijën cajënna, yureña bainbi güina'ru yo'ojën ba'iyë. Juan Bautizaguëbi rani, baguë aon aiñe jo'caguë, bisi ëye jo'cha uncuye beoye ba'iguëna, mësacuabi Ro hue'nhue huati hua'guë'bi baguëte cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ja'nrëbi yë'ë, Riusu Raosi'quëreba ba'iguëbi rani, aonre anni, gonore uncuguëna, mësacuabi yeque coca yë'ëre cajën, “Aon ain huati'bi. Jo'cha güebe huati'bi. Gu'a bain, impuesto curi cocua, ro bacua gajeguë'ru ba'i'te” yë'ëre ja'nca cajën ye'ere gu'a güeyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ja'nca cacuata'an, Riusu masiyete ye'yeye yënica, Riusu bain baguë ba'iyete masicuare ëñani masijë'ën quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ja'nrëbi, fariseo bainguë Simón hue'eguëbi Jesusre choiguëna, Jesusbi baguë huë'ena sani, baguë naconi bëani aon anji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aon ainguëna, yeco gu'a romigo ba'igobi ja'ansi huë'e jobore ba'igo yua Jesús ba'iye, fariseo huë'ere aon ainguë ba'iye, ja'anre achani, bago yua ma'ña sën re'core inni, alabastro gata ro'rohuëna bu'iye tëca queoni ayani, ");
INSERT INTO snnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","fariseo huë'ena saco'ë. Sani ti'anni, Jesús yo'je, baguë guëoña ba'iruna rëanni, ai oco'ë. Oni, bago oise'ebi baguë guëoñana ai meoni tonni zoago. Zoani, bago rañababi cuenani, baguë guëoña ai muchani, bago ma'ña re'core baguë guëoñana jañuni zoani tongo. ");
INSERT INTO snnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja'nca yo'ogona, ja'an fariseo bainguë Simonbi bago yo'ose'ere ëñani ro'tabi: “Ënquë yua Riusureba Raosi'quë banica, bago gu'aye yo'ogo ba'iyete masire'abi. Bagoni ëñani, gu'a romigo ba'iyete masini ënsere'abi” ro'taguë ëñaguë ñuji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ro'taguë ñu'iguëna, Jesusbi cabi: —Simón, më'ëni coca quëaye yëyë yë'ë cabi. Caguëna, —Cajë'ën, Ëjaguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sehuoguëna, ye'yo cocare baguëni quëabi Jesús: —Curi presta ëjaguëbi curi prestaguëna, samucuabi baguëni ro'ija'cua baë'ë. Yequëbi quinientos denario so'coña ro'ija'ye baji'i. Yequëbi cincuenta denario so'coña ro'ija'ye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Si'a jubëbi baguëni ro'iye porema'icua ba'ijënna, ba ëjaguëbi bacua ro'iyete se'e senmaji'i. Mësacua yua gare yë'ëre ro'iye beoye ba'ijë'ën caguë, bacuani huanë ye cocare cani tonbi. Ja'nca huanë yeye caguëna, ¿jaroguëbi ba ëjaguëni quë'rë ta'yejeiye ai yëguë'ne? senni achabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Senni achaguëna, Simón sehuobi: —Baguëni quë'rë ro'ija'ye ba'isi'quëma'iguë sehuobi. Sehuoguëna, Jesusbi —Te'e ruiñe sehuohuë më'ë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Cani, ja'nrëbi ba romigona bonëni ëñani, Simonni se'e cabi: —Ënconi ëñani ro'tajë'ën. Yë'ëbi më'ë huë'ena caca rani ba'iguëna, më'ëbi yë'ëni bojoguë conmaë'ë. Yë'ë guëoñare zoaye ocore gare guansemaë'ë më'ë. Ënco'ga bago oise'e se'gabi yë'ë guëoña jo'caye beoye zoani tongo, bago rañababi cuenago, ja'an se'ga yo'ogo. ");
INSERT INTO snnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Më'ëbi yë'ëni gare oiye beoye ëñani saludaguëna, ënco'ga yë'ë ti'ansirënbi yë'ëni ai bojogo, yë'ë guëoñare muchago gare jo'caye beoye yo'ogo. ");
INSERT INTO snnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Më'ëbi hui'yabe re'core guansemaë'ë, yë'ë sinjobëna queoni jañuñete. Ënco'ga ma'ña re'core rani, yë'ë guëoñana queoni jañuni tongo. ");
INSERT INTO snnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ja'nca yo'ogobi yë'ëni ai ta'yejeiye ai yëreba yëgo sëani, bago ai gu'a jucha huanë yese'ere bainni masi güesego. Yequëcua'ga choa ma'carë se'ga gu'aye yo'oni huanë ye güesejën, yë'ëni ta'yejeiye yëma'icua ba'iyë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Cani ja'nrëbi, ba romigona bonëni cabi: —Mami, më'ë gu'a jucha yo'ogo ba'ise'e si'ayete huanë yeyë yë'ë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Caguëna, yequëcua ba aon aiñete choisi'cuabi yua sa'ñeña bëin coca ca bi'rahuë: —¿Ënquë, bain juchare huanë yeye caguë, gueguëguë'ne? sa'ñeña senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cajënna, Jesusbi bagoni cabi: —Yë'ëni si'a recoyo ro'tani bojogo sëani, Riusu ba'i jobona ti'anni ba'ija'go'ë më'ë. Yureca jucha beogo, bojogo saijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ja'nrëbi jë'te, Jesusbi sani, ai huë'e joboña, bain ba'iruanna ti'anni, Riusu bojo güese coca, Riusu bainreba re'huani baja'yete quëani achoguëna, baguëre ta'yejeiye yo'o concua si'a sara samucuabi baguëni te'e conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Conjën saijënna, yequë romi hua'na'ga baguëni conjën saë'ë. Romi hua'na ba'iyete ëñato, yequë romi hua'naca yua huati cacasi'cua baë'ë. Yequë romi hua'naca rauna ju'incua baë'ë. Ja'nca ba'isi'cua ba'ijënna, Jesusbi si'acuani huachoni gare huajë rai güesebi. María hue'ego'ga, Magdalena mami bago, yua te'e ëntë sara samu huati hua'i cacasi'co ba'igona, Jesusbi si'a huati hua'ire etoni saoni senjoguëna, querë huajë raco'ë bago. ");
INSERT INTO snnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana hue'ego'ga baco'ë. Bago ënjë Cuzabi Herodes meñe yo'je ëjaguë baji'i. Yeco Susana, yequëcua romi hua'na naconi ba'ijënna, Jesusbi si'acuani bacua rau base'ere huachobi. Huachoguëna, ba hua'na yua bacua porese'e Jesusni conjën, insijën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ja'nrëbi, ai jai jubëan bainbi si'a huë'e joboñabi etani, Jesusna ti'anni ba'ijënna, bacuani ye'yo coca cani acho bi'rabi: ");
INSERT INTO snnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Bainguëbi Aonre tanza caguë saji'i. Sani, yijare re'oye re'huani tëjini, aonra'carëanre re'oye mo'gasi yijana senjoguë, yequëra'carëanre ma'ana tonguëna, bain za'nguye, bi'an uncueye, ja'anna huesëbi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yequëra'carëanre senjoguë, gata yijana tonguëna, ticubi irani, ja'nrëbi yija yaquima'iguëna, ro güeanbi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yequëra'carëanre senjoguë, miubëna tonguëna, miubi irani huenni huesobi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yequëra'carëanre senjoguë, re'oye re'huasi yijana tonguëna, aon sahuabi irani, aonre quënji'i. Aonra'carëan quëinse'ere cuencueto, cien viaje ba'iye tëca quë'rë ta'yejeiye quënji'i, cabi Jesús. Ja'an ye'yo cocare cani, bainni si'a jëja cabi: —Mësacua yua ganjo banica, te'e ruiñe achani ro'tajën ye'yejë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ja'nca caguëna, baguëre yo'o concuabi huesë ëaye achajën baguëni senni achahuë: —¿Gue cocare ye'yoguë caguë'ne, Ëjaguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Senni achajënna, baguë sehuobi: —Riusubi baguë ba'i jobo ba'ija'yete cani achoza caguë, mësacuani si'aye te'e ruiñe masi güeseji. Yequëcuareta'an banji. Bacuani cani achoto, ye'yo coca se'gare bacuani quëaji Riusu. Te'e ruiñe ye'yeye yëma'icua sëani, yë'ë cocare achani, ro huesë ëaye ba'icua'ë. Yë'ë ëñoñere'ga ëñani, ro huesë ëaye ëñajën ba'iyë bacua, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Caguë sehuoni, ja'nrëbi zio tanguë cocare bacuani te'e ruiñe quëabi: —Baguë yua aonra'carëan senjoguëna, yua Riusu coca cani achoye'ru ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma'ana tonsira'carëanre cato, bain hua'nabi Riusu cocare achani, ja'nrëbi ro ro'tajën saiyë. Zupai huatibi rani, Riusu bënni senjoja'ñete jëama'ija'bë caguë, bacua coca achase'ere ro tëteni saoni senjoji. Bacuabi ro recoyo ro'tamajën saiyë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gata yijana tonse'ere cato, Riusu coca achacua yequëcua ba'iyë. Riusu cocare achasi'cuata'an, ai bojoye achani, ja'nrëbi sani, zoe beoye ba'ijën, ba cocare gare huanë yeni jo'cani senjoñë. Be'su sita ba'iye'ru ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Miubëna tonsira'carëanre cato, Riusu cocare achacua yequëcua ba'iyë. Riusu cocare achacuata'an, ën yija bonsere ba ëaye ba'ijën, ja'an se'gare ro'tani, Riusu yëyete gare se'e ro'tamajën, baguëte gare jo'cani senjoñë. Gare aon quëiñe beoye ba'iye'ru ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Re'oye re'huasi yijana tonse'ere cato, Riusu cocare achacua yequëcua ba'iyë. Bacuabi achani, bacua recoyona re'oye re'huani, Riusu case'ere te'e ruiñe yo'oyë. Aon tëarën ti'añe tëca re'oye yo'o conjën, Riusu yëyete gare caraye beoye yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bainbi majahuëte zëontoca, guënarobi ro meñe jaoni ta'pima'iñë. Cama yijacuana ro yahuema'iñë. Bañë. Huë'ena ti'ancuabi re'oye ëñaja'bë cajën, majahuëte zëonni, ëmëna reoyë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ja'nca cani jo'caguëna, ëñere ro'tani ye'yejë'ën. Bain hua'nabi gu'aye yo'oni gatiza cajën yo'ocuareta'an, Riusubi si'aye ëñani, bacua yo'ose'ere si'acuani masi güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ja'nca sëani, mësacua yua yë'ë cocare achani, te'e ruiñe ro'tajën ba'ijë'ën. Riusu insise'ere ai coni batoca, quë'rë se'e ai coni baja'cua'ë. Riusu insise'ere choa ma'carë se'gare coni batoca, Riusubi ja'anre gare tëani, ro beo hua'guëre saoni senjoja'guë'bi, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Caguë quëaguëna, Jesús pë'cago, baguë yo'je hua'na naconi, bacuabi ti'an rani, ai jai jubë bain ba'ijënna, baguëna ti'añe poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Porema'ijënna, yequëbi Jesusni cabi: —Më'ë pë'cago, më'ë yo'jecua, bacua yua hue'se ca'ncore nëcajën, më'ëni cu'eyë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Caguëna, Jesusbi sehuoguë, si'acuani cabi: —Bacuabi yë'ëre cu'ecuata'an, yë'ë cocare achani te'e ruiñe yo'ojën ba'icua, ja'ancua se'gabi yë'ë bainreba ba'iyë. Yë'ë mamá, yë'ë yo'jecua, ja'anre cayë bacuare, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ja'nrëbi, yequë umuguse, Jesús yua baguëre yo'o concua naconi ba'iguë, yua yoguna cacani, Que të'huina saiñu caguëna, bacuabi conjën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sani, jobo zitara ba'ijënna, Jesusbi umeni canji'i. Canni ba'iguëna, ai jëja tutu raiguëna, yogu yua oco bu'i bi'rabi. Bu'i bi'raguëna, Rucani huesëma'iñe cajën, ai huaji yëjën, ");
INSERT INTO snnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesusni sëtoni cahuë: —Ëjaguë, conjë'ën. Maibi rucani huesëyë cahuë. Cajënna, Jesusbi huëni, gue tutu, gue zitara të'a, ja'anre bëinguë cani, cuauye guanseguëna, si'aye beoru ja'anse'ebi cuauni carajaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Carajaiguëna, Jesús yua baguëre yo'o concuani bëin coca cabi: —¿Mësacua guere yo'ojën, yë'ëni recoyo ro'tama'iñe'ne? cabi. Caguëna, bacuabi ai quëquëjën, sa'ñeña senni achahuë: —¿Ba hua'guë gue bainguëguë'ne? Baguë coca guanseye se'ga caguëna, tutu'ga, zitara të'a'ga ja'anse'ebi achani Jaë'ë cani cuaubi, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Cajënna, ja'nrëbi que të'huina ti'anni ëñato, Gerasa yija baji'i, Galilea je'eñera. ");
INSERT INTO snnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti'anjënna, Jesusbi mëji'i. Mëiguëna, baru bainguë huati zemosi'quëbi baguëna tëhuo raji'i. Tëhuo raiguëbi yua huë'e ba'iye jo'cani senjosi'quë baji'i. Can beohuë ba'iguë, bain tanru se'gare baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ja'nca ba'iguëbi yua Jesusni ëñani, baguëna ti'anni, gugurini rëanni, baguëni ai jëja huaji yaye achoyereba güiguë cabi: —Më'ë yua Ta'yejeiyereba Ëjaguë Riusu Zin sëani, ¿më'ë queaca ro'taguë raquë'ne, Jesús? Më'ëni senreba señë. Yë'ëni bënni senjoñe beoye ba'ijë'ën, güiguë cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesusbi baguë huati etaye guanseguë sëani, ja'nca güiguë cabi baguë. Baguë huatibi yua baguëni ai hue'nhue yo'oguë baji'i. Ba'iguëna, baru bainbi guënameanbi inni, baguëni gueonza cani yo'ojënna, baguë ëntë sara gueonse'e, baguë guëon gueonse'e, ja'anre ro tëteni si'aguëna, huati hua'ibi ba bainguëre beo re'otona sani bahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ja'nca ba'isi'quë ba'iguëna, Jesús yua baguëni senni achabi: —¿Më'ë gue mami hue'eguë'ne? senni achabi. Senni achaguëna: —Yë'ë ai jai jubë hue'eyë sehuobi, ai jai jubë huati hua'i zemosi'quë sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sehuoguëna, ja'nrëbi, huati jubë yua Jesusni senreba senni achahuë: —Ja'an rëi gojena saoni senjoma'ijë'ën yëquënare, cajën sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Senjënna, ja'nrëbi cubë jabare ëñato, ai jai jubë cuchi hua'na aon ainjën baë'ë. Ba'ijënna, huati hua'ibi, Yëquënare cuchi jubëna saojë'ën, baguëni senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cani, Jesusbi bacuare saoguëna, huati hua'ibi ba bainguëte jo'cani sani, cuchi hua'nana cacahuë. Cacajënna, cuchi hua'na, si'a jubëbi ro ro'tajën, huë'huëjën sani, të'ntëbana tonni, zitarana chani runi huesëhuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Runi huesëjënna, cuchi cuiracuabi ëñani, ja'nrëbi huaji yëjën, besa huë'huëni sani, si'aruan huë'e jobo ti'añe tëca sani, cuchi runi huesëse'ere quëani achojaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Quëani achojaijënna, bainbi ëñajën raë'ë. Jesusna rani, ëñato, huati etoni saosi'quëbi yua Jesús guëon na'mi ca'ncore ñuji'i. Caña yua ju'iguëbi, yua te'e ruiñereba ro'taguë ñuji'i. Ja'nca ñu'iguëna, si'a bainbi ai huaji yëjën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ëñajënna, baguë huajë raise'ere ëñasi'cuabi yua bacuani quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Quëajënna, si'acua Gerasa yija ba'icuabi ai huaji yëjën, Jesusna ti'anni, Ënjo'onbi gare go'ijë'ën, cajën cahuë. Ja'nca cajënna, Jesús yua yoguna cacani go'i bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Go'i bi'raguëna, huati hua'ire saosi'quëbi yua Jesusni, Më'ë naconi saza senni achaguë cabi. Caguëna, Jesusbi baguëte sehuoguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ënjo'ona bëani ba'ijë'ën, mami. Më'ë huë'ena go'ini, Riusu conse'e, më'ëni ai re'oye yo'ose'e, ja'anre coca quëaguë go'ijë'ën, caguë guansebi Jesús. Caguë guanseguëna, baguë sani, Jesús conni yo'ose'ere si'a bainni quëani achojaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ja'nrëbi, Jesús yua go'ini, Galileana ti'anguëna, bain jubëbi baguëni zoe ëjocua sëani, baguëni ai bojojën, baguëni saludahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Saludajënna, ñë'ca huë'e ëjaguë Jairo hue'eguëbi raji'i. Rani, Jesusna gugurini rëanni, baguëni caguë senni achabi: —Yë'ë huë'ena sani, yë'ë zin hua'gore ëñajaijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Baguë zin hua'go gaña hua'go ba'igo, si'a sara samu tëcahuëan bagobi, ai ju'in hua'go baco'ë. Ja'nca caguëna, Jesusbi conguë saji'i. Ma'abi saiguëna, ai bain be'tejën baë'ë. Si'a ca'ncoñabi baguëni jë'jejën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ja'nca saijënna, yecobi u'chu rauna si'a sara samu tëcahuëan ju'ingo baco'ë. Ëco yo'ocuana ëñogo ba'igobi bago curire bacuana insini si'agota'an, gare huajë raima'igo baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ja'nca ba'igobi bain jubë naconi saigo, Jesús yo'jena ti'anni, baguë can na'mire pa'rogona, u'chu rau te'e jëana tëcabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tëcaguëna, Jesús cabi: —¿Nebi yë'ë can pa'rore'ne? senni achabi. Senni achaguëna, si'acua, Banhuë cajënna, Pedro, baguë gajecua naconi, bacua cahuë: —Ëjaguë, bain hua'nabi si'a ca'ncoñabi më'ëna jë'jejënna, ¿queaca ro'taguë, Nebi pa'rore'ne senni achaguë'ne? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Cajënna, Jesús sehuobi: —Yë'ë huachose'e huanoguëna, yë'ëni pa'rosi'core cu'eyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Caguëna, huajë raisi'cobi yua se'e gatiye porema'igo, yua ai huaji yëgo to'ntogo, Jesús guëon na'mina gugurini rëanni, baguëni pa'rose'e, bago te'e jëana huajë raise'e, ja'anre beoru quëago, si'acua ëñajënna. ");
INSERT INTO snnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Quëagona, Jesús cabi: —Yë'ëni si'a recoyo ro'tago sëani, huajë raë'ë më'ë, mami. Ja'nca ba'igo sëani, bojogo saijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Caguë, yuta cani tëjima'iguëna, ëjaguë Jairo bainguëbi coca quëaguë raji'i. Rani, Jaironi cabi: —Më'ë zin hua'gobi yua junni huesëgo. Ja'nca sëani, yua mai Ëjaguëre se'e cama'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Caguëna, Jesusbi achani, Jaironi cabi: —Oima'ijë'ën. Më'ë recoyo ro'taye se'ga ba'ijë'ën. Bagobi huajë raija'go'co, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ja'nca cani, baguë huë'ena sani ti'anni, yequëcuare cacaye ënsebi. Pedro, Santiago, Juan, ba romi zingo pë'caguë sanhuë, bacua se'gare baguë naconi sa'nahuëna guaobi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Guaoni, si'a bainbi ba romi zingote aireba oijën sa'ntiye gantajën yo'ojënna, Jesusbi cabi: —Mësacua oima'ijë'ën. Romi zingo ju'inmaco'ë. Ro cainsi'cobi uingo bago, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Caguëna, si'acuabi baguëni ai jayajën ai chohuë, bago junni huesëse'ere masicua sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ja'nca jayajënna, ja'nrëbi, Jesús yua romi zingo ëntë sarana zeanni, bagoni jëja cabi: —Huëijë'ën, mami, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Caguëna, go'ya rani, te'e jëana huëco'ë. Huëigona, Jesusbi bago bainni, Aon aonjë'ën bagore, caguë guansebi. ");
INSERT INTO snnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ja'nca ba'iguëna, bago pë'caguë sanhuëbi ai ëñajën rëinjënna, Jesusbi Bago go'ya raise'ere yequëcuani quëama'ijë'ën, caguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ja'nrëbi, Jesús yua baguëre yo'o concua si'a sara samucuare choini, huatire etoni saocuare, rau huachocuare, bacuare re'huabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ja'nca re'huani, bacuani yihuoguë cabi: —Mësacua yua Riusu ba'i jobona ti'anni ba'ija'yete quëani achojaijë'ën. Rauna ju'incuare huachojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mësacua sani, bonse, aon, ja'anre sama'ijë'ën. Ro'ojën sai tubë, turubë, curi, yequë ëntë sara can, ja'anre gare saye ro'tama'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ja'nca sani, mësacuani bojojën ba'icua, bacua huë'ena cacani, ba huë'e jobobi saiye tëca, ba huë'ena bëani ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yequëcuabi bacua huë'ena cacaye ënsetoca, mësacuabi ba huë'e jobobi saijën, ja'anru bainbi ëñajënna, mësacua guëon ba'i ya'ore cue'nconi tonjë'ën. Bacua gu'aye yo'ose'ere masija'bë cajën, ja'nca yo'ojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Cani tëjini, bacuare saoguëna, bacua saë'ë. Si'a huë'e joboñabi saijën, Riusu bojo güese cocare quëani achojën, si'a bain rau bacuare huachojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ja'nca yo'ojënna, Galilea ëjaguë Herodes hue'eguëbi yua Jesús yo'ose'e si'aye achani, ai ro'taguë ëñabi. Bain hua'nabi Jesusre cajën, yequëcuabi, Juan Bautizaguë'bi junni go'ya raisi'quëma'iguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yequëcuabi, Riusu ira raosi'quë Elíasbi maina se'e gaje meni ba'ima'iguë, cahuë. Yequëcuabi, Mai ira bain ba'isi'cua Riusu coca casi'cua, ja'ancua'ru ba'ima'iguë. Maina gaje meni ba'ima'iguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Cajënna, Herodes'ga cabi: —Juanni huani senjo güesehuë yë'ë. Baguë sinjobëte tëyoye guansesi'quëta'an, ënquë ¿gue bainguëguë'ne? Bain hua'nabi baguë ta'yejeiye yo'ore cani achojënna, yë'ëbi achaguë, ¿guere yo'oye'ne yë'ë? senni achaguë cabi. Cani, baguë yua quë'rë se'e Jesusna ti'an ëaye yo'oguë, Baguëni ëñaja'ma caguëta'an, poremaji'i baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ja'nrëbi, Jesusre yo'o concua saisi'cuabi raë'ë. Rani, bacua yo'ose'e beoru baguëni quëahuë. Quëajënna, bacuani cabi: —Re'oji, mami sanhuë. Raijë'ën. Bain beoruna bëani huajëjaiñu, caguë, bacuare Betsaida huë'e jobo cueñe ba'iruna huëoni sabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sani ti'anjënna, bain hua'nabi bacua sairute masini, Jesusna be'tejën saë'ë. Sani ti'anjënna, Jesusbi bacuani bojoguë ëñaguë, Riusu ba'i jobona ti'anni ba'ija'yete bacuani quëani achoni, bacua jubë ba'icua rau bacuare huachobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ja'nca yo'oguëna, ënsëguëbi ruajaiguëna, baguëre ta'yejeiye concua si'a sara samucuabi baguëni cueonni cahuë: —Ëjaguë, bain hua'nare go'i güesejë'ën. Bacua aon, bacua cainru, ja'anre bain ba'iruanna sani cu'eni cainja'bë caguë, bacuare cani go'i güesejë'ën. Beo re'oto'ë ënjo'on, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Cajënna, Jesús yua bacuani sehuobi: —Mësacua se'ga aon aonjë'ën bacuare, sehuobi. Sehuoguëna, bacua sehuojën quëahuë: —Te'e ëntë sara jo'jo aonbëan, samu ziaya hua'i, ja'an se'gare bayë yëquëna. Bacua yua ai jai jubë bain ba'ijënna, ¿yëquënabi bacuare cuiraye aon cojani raye yëguë më'ë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bain jubëre cuencueto, cinco mil ëmëcua ba'iye'ru baë'ë. Ja'nca senni achajënna, Jesús yua baguëre yo'o concuani cabi: —Bain hua'nani jurëan bëa güesejë'ën, cincuenta ba'i jurëan'ru, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Caguëna, ja'nca yo'oni tëjijënna, bainbi jurëan bëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bëajënna, Jesusbi ba cinco jo'jo aonbëan, samu ziaya hua'i hua'nare, ja'anre inni, guënamëna mëiñe ëñaguë, Riusuni senni surupa cani, aonre jë'yeni, baguëre concuana insibi, Bainni cuirajë'ën caguë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ja'nrëbi, si'a hua'nabi yajiye tëca aën'ë. Anni tëjijënna, Jesusre concuabi aon ainjën jëhuase'ere chiani, si'a sara samu jë'eña bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ja'nrëbi, Jesús yua te'eguë ba'iguë, Riusuni ujaguëna, baguëre yo'o concuabi baguëna raë'ë. Raijënna, bacuani senni achabi: —Bainbi yë'ëre cajën, ¿gueguëguë'ne yë'ëre, cajën ro'taye'ne bacua? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Senni achaguëna, bacua sehuohuë: —Yequëcuabi cajën, Juan Bautizaguë'ë më'ë cayë. Yequëcuabi, Elías ba'iguë'ë më'ë cayë. Yequëcuabi, Mai ira bain ba'isi'cua Riusu raosi'cua, ja'ancua ba'iye'ru ba'iyë më'ë cayë. Junni tonni go'ya raisi'quë'ë më'ë cayë, sehuohuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sehuojënna, bacuani se'e senni achabi: —Mësacua'ga yë'ëre cajën, ¿gueguëguë'ne yë'ëre, cajën ro'taye'ne mësacua? senni achaguë cabi Jesús. Senni achaguëna, Pedro sehuobi: —Riusu Raosi'quëreba'ë më'ë. Baguë Cristo'ë më'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ja'nca sehuoguëna, Jesús yua bacuani yihuoreba yihuoguë guanseguë, Yequëcuani yë'ë ba'iyete quëaye beoye ba'ijë'ën caguë, ");
INSERT INTO snnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","yua yeque cocare bacuani quëabi: —Yë'ë, Riusu Raosi'quëreba ba'iguë, ai ja'si huanoñe ba'ija'guë'ë yë'ë. Ira bain, pairi ëjacua, ira ba'isi coca ye'yocua, bacuabi yë'ëre ai gu'a güejën, yë'ëni huani senjo güeseja'cua'ë. Huani senjo güesejënna, samute umuguseña ba'iguëna, yë'ëbi go'ya raija'guë'ë, bacuani cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cani ja'nrëbi, si'a bainni cabi: —Bainbi yë'ë naconi te'e zi'inni ba'iye yënica, bacua ba'iyete huanë yeni, jo'cani senjoñe bayë. Si'a umuguseña bacuabi crusu sa'cahuëna ju'iñe'ru ba'iye ro'tajën, bacua yëyete gare jo'cani, yë'ë yëye se'gare güeye beoye yo'ojën, te'e coñe bayë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ro bacua ba'iye se'gare ro'tatoca, bacuabi ro huesëni si'ayë. Yë'ë ba'iye se'gare ro'tatoca, bacuabi huajëreba huajëjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bacuabi te'e jëana carajeitoca, ¿queaca ro'tajën, si'a ën yija bayete coni baye ro'taye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yë'ëre gu'a güeguë senjoñe ro'tatoca, yë'ë coca ye'yose'ere gu'a güeguë senjoñe ro'tatoca, yë'ë'ga Riusu Raosi'quëreba ba'iguë, yë'ë Taita naconi, Riusu guënamë re'oto yo'o concua naconi, ba in rai umugusebi ënsëguë ma'ñoñe'ru quë'rë ta'yejeiye rani, bacuare'ga güeguë senjoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ganreba yihuoguë, mësacuani quëani achoyë. Ënjo'on ba'icuare ëñato, yequëcuabi Riusu ba'i jobore ëñañe tëca, bacua junni huesëma'iñë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ja'nrëbi, te'e ëntë sara samute umuguseña ba'ini, Jesús yua Pedro, Santiago, Juan, bacuare choini, Riusu naconi coca ujañu caguë, bacuare ëmë cubë na'miñona mëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mëani, baguë yua ujaguëna, baguë zia yua tin zia ëñoguëna, baguë cañare ëñato, ai pojeiyereba go'sijei cañare ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ëñoguëna, ja'ansirën samucua ëmëcuabi gaje meni eta rani, Jesús naconi coca cajën baë'ë. Moisés, Elías, ja'ancua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Riusu ta'yejeiye go'sijeiyereba ba'ijën, bacuabi gaje meni, Jesús naconi coca cajën, baguë junni tonja'ñete cahuë. Riusu re'huase'e sëani, Jerusalén huë'e jobore ba'iguë junni tonja'ñete sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ja'nca cajënna, Pedro sanhuëbi ai ëo caincuata'an, cainmajën, Jesús go'sijeiyete ëñajën, baguë naconi ba'icuare'ga ëñajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja'nca ëñajën, ja'an raisi'cuabi go'ijënna, Pedro yua Jesusni cabi: —Ëjaguë, maibi ënjo'on ba'ijënna, ai re'oye ba'iji. Ja'nca sëani, samute huë'erëanre yo'oñu. Më'ëna te'e huë'erë yo'ocaiyë. Moisesna yequë huë'erë yo'ocaiyë. Elíasna yequë huë'erë yo'ocaiyë, cabi Pedro. Ro ro'taguë cabi Pedro. ");
INSERT INTO snnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yuta cani tëjima'iguëna, oco picobi nëca meni, si'acuare na'oguëna, Jesusre concuabi ai quëquëhuë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Quëquëjënna, picobë sa'nahuëbi bain coca achoni raobi: —Ënquë yua yë'ë Zin ai yësi'quëreba'bi. Yë'ë cuencueni raosi'quëre sëani, baguëbi coca caguëna, mësacua achajë'ën, cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cani tëjiguëna, bacuabi ëñato, Jesús yua te'e hua'guë baji'i. Ja'nca ba'iguëna, bacua yua gare caye beoye ëñahuë. Bacua ëñase'ere ro'tato, yequëcuani gare quëaye beoye baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ja'nrëbi, yequë umuguse ñataguëna, bacua ba'i cubëbi gajehuë. Gajejënna, ai jai jubë bainbi Jesusni tëhuojën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tëhuojën raijënna, ba jubë ba'iguë te'eguëbi Jesusni güiguë cabi: —Ëjaguë, më'ëni senreba señë yë'ë. Yë'ë zin hua'guë gaña hua'guëre ëña raijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gu'a huatibi baguëni hue'nhue yo'oguë, baguëte yijana taonni, yi'obobi chiri mëañe tëca yo'oguë, baguëte ai ja'si güeseye gare jo'cama'iguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja'nca ba'iguëna, yë'ëbi yua më'ëre yo'o concuana rani, baguë huati etoni saoyete bacuani senni achahuë. Senni achato'ga bacua poremaë'ë, cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Caguëna, Jesusbi bacuani cabi: —Mësacua yua ro ro'tajën, recoyo gu'aye ro'tajën ba'iyë. ¿Quejei zoe ro ye'yemajën ba'iye'ne mësacua? Ro guaja ye'yo coca mësacuani caguë ba'iyë yë'ë, cani, ja'nrëbi, ba bainguëni: Më'ë zin hua'guëre yë'ëna rajë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Caguëna, zin hua'guëbi rai bi'raguëna, gu'a huatibi se'e baguëni hue'nhue yo'oni, baguëte yijana jëjoni taonbi. Taonguëna, Jesusbi ja'an huatini bëinguë cabi: —Zin hua'guëre etani gare saijë'ën caguëna, ja'ansirën etani gare saji'i. Ja'nca saiguëna, Jesús yua zin hua'guëre huachoni, baguë pë'caguëna sani, huajë hua'guëre baguëna ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ja'nca ëñoguëna, bain hua'nabi ai bojoreba bojojën, Riusu ta'yejeiyereba ba'iyete ai cani achojën baë'ë. Ja'nca ai bojoreba bojojën cajënna, Jesusbi baguëre yo'o concuani coca quëabi: ");
INSERT INTO snnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Mësacua yua yë'ë cocare achajë'ën. Gare huanë yeye beoye achajë'ën. Yë'ë, Riusu Raosi'quëreba ba'iguëna, yequëcuabi yë'ëre gu'a jucha baguëre'ru zeanni, yë'ëre gu'a bainna insini senjojën ba'ija'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Caguëna, baguë case'ere ro huesë ëaye achahuë. Riusu coca yuta masi ëama'iñere sëani, achani masiye ti'anmaë'ë bacua. Ja'nca huesë ëaye achacuabi Jesusni Te'e ruiñe quëajë'ën caye huaji yëhuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ja'nrëbi, Jesusre yo'o concuabi sa'ñeña cajën, Mai jubë ba'icua ¿gueguëbi quë'rë ta'yejeiye ëjaguë ba'iguë'ne? cajënna, ");
INSERT INTO snnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesusbi bacuani ëñani, bacua cayete masibi. Masini ja'nrëbi zin hua'guëre choini rani, baguë ca'ncona nëcobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nëconi, bacuani yihuoguë cabi Jesús: —Yë'ë ba'iyete ro'tajën, ënquë zin hua'guëni conjën ba'itoca, yë'ëre'ga güina'ru conjën ba'iyë. Yë'ëre conjën ba'itoca, Ja'quë Riusu yë'ëre raosi'quë, baguëre'ga güina'ru conjën ba'iyë. Mësacua jubë ba'icua, quë'rë yo'jereba ba'i hua'guë, ja'anguëbi mësacua jubë quë'rë ta'yejeiye ëjaguë ba'ija'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Caguëna, Juanbi baguëni cabi: —Ëjaguë, yequë bainguëni tëhuohuë yëquëna. Më'ë ta'yejeiye ba'iyete caguë, gu'a huati hua'ire etoni saoguë baji'i. Ja'nca yo'oguëna, mai jubë ba'ima'iguëre sëani, baguëre ënsehuë yëquëna, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Caguëna, Jesús cabi: —Baguëre ënsema'ijë'ën. Maini je'o bama'itoca, maini te'e yo'o conji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ja'nrëbi, Jesús guënamë re'otona go'irën ti'anja'ñeta'an ba'iguëna, baguë yua, Yurera Jerusalén huë'e jobona te'e ruiñe saiza caguë, yo'o bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ja'nca yo'oguë, baguë bainre ru'ru saobi. Saoguë, bacuani cabi: —Yë'ë yure ñami cain huë'ere cu'eni, ja'an bain naconi re'hua coca cajë'ën caguë, bacuare ru'ru saobi. Saoguëna, bacuabi yua Samaria huë'e jo'borëna sani, cainrute senni achajënna, ");
INSERT INTO snnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria bainbi ënsehuë. Jerusalenna te'e ruiñe saija'guëre sëani, bacua huë'e jobona choiye yëmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yëmajënna, Santiago, Juan, bacuabi masini, Samaria bainre bëiñe ro'tajën, Jesusni cahuë: —Ëjaguë, yëquëna hua'nabi guënamë re'otona guanseni, toare gachoni, ja'an Samaria bainni ëoni si'añu. Riusu ira bainguë raosi'quë yo'ose'e'ru güina'ru yo'oñu cajënna, ¿më'ë queaca ro'taguë'ne? senni achajën cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Senni achajënna, Jesusbi bacuani ëñani, bëin coca sehuobi: —Bañë. Ja'nca yo'oma'ijë'ën. Riusu Espíritubi mësacua naconi ba'iguë, ja'anre yo'oye gare güeji. Ja'nca sëani, mësacua ¿queaca ro'tajën bainre ñu'ñujei güeseye caye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yë'ë, Riusu Raosi'quëreba ba'iguëbi yua bainre ñu'ñujei güeseye gare ro'tama'iguë'ë. Bainre mame recoyo re'huaye, ja'an se'gare yo'oye ro'taguë ba'iguë'ë yë'ë cabi Jesús. Cani ja'nrëbi, bacuabi conjën, yequë huë'e jobona saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ja'nca sani, ma'aja'an saijën, yequë bainguëni tëhuojënna, baguë yua Jesusni cabi: —Ëjaguë, si'a më'ë sairuanna te'e conguë saiza cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Caguëna, Jesús sehuobi: —Yë'ë ën yijare ba'iye'ru ba'iye yënica, raijë'ën. Airu hua'i hua'nabi yija gojeñana caincua'ë. Ca hua'i hua'nabi bacua ziaroanre tuijën caincua'ë. Ja'nca caincuata'an, yë'ë, Riusu Raosi'quëreba ba'iguë yua umeni cainru gare beo hua'guë'ë yë'ë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cani ja'nrëbi, yequë bainguëni choiguë: —Yë'ëre te'e conguë raijë'ën, cabi. Caguëna, baguë sehuobi: —Ëjaguë, yë'ë taita ju'insi'quëni tanjaza ru'ru, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sehuoguëna, Jesús yua baguëni cabi: —Yë'ëni recoyo bojoye güecua, recoyo ju'insi'cua'ru ba'icua, ja'ancua se'gabi bacua bain junni huesësi'cuare tanja'bë. Më'ëca Riusu bojo güese cocare quëani achoguë raijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Caguëna, ja'nrëbi yequëbi Jesusni cabi: —Ëjaguë, më'ëre te'e conguë saiza caguë, ru'ru yë'ë bainna sani gare sai cocare bacuani quëajani raiyë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Caguëna, Jesús sehuobi: —Riusu yo'ore coñe porema'iñë më'ë. Yë'ë yo'ore conza cani, ja'nrëbi yequë yo'ore yo'oye ro'tatoca, gu'aji, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ja'nrëbi jë'te, Jesusbi yequë bain setentacuare cuencueni, baguë coca quëani achocuare re'huani, samucua ba'i jurëanre quë'ñeni, si'a huë'e jo'borëan baguë ëñaguë saijai joboñana bacuare sao bi'rabi Jesús. Sao bi'raguë, bacuani yihuoguë ");
INSERT INTO snnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","cabi: —Mësacua yua saijën, ën cocare ro'tajën ba'ijë'ën. Ja'quë Riusubi ai aonre tëani baye'ru tëani baye ro'taguëta'an, aon tëaja'cua yua choa jubë se'ga ba'iyë. Ja'nca sëani, Riusuni ujajën, Ja'quë, më'ë cocareba quëani achojaicua quë'rë jai jubëre huëoni re'huani raojë'ën. Më'ë aon tëani baja'cua ba'iye'ru më'ë bain ba'ija'cuare ñë'coni re'huaja'bë cajën, Ja'quë Riusuni jo'caye beoye ujajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mësacua yua yë'ë cocare quëani achojën, ëñere'ga ro'tajën ba'ijë'ën. Mësacua yua jo'ya hua'na ba'iye'ru ba'icuareta'an, airu yai jobona saoye'ru mësacuare saoyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mësacua yua turubë, curi ayabë, guëon jui coro, ja'anre gare sama'ijë'ën. Te'e ruiñe se'ga saijën, ma'ana tëhuocuare gare saludamajën, te'e ruiñera saijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sani, ja'nrëbi bain huë'ena ti'anni, bainre saludajën, “Ën huë'e ba'icua yua bojojën ba'ijë'ën” cajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cajënna, mësacuani bojojën sehuotoca, bacuani bojojën ba'ijë'ën. Bojojën sehuoma'itoca, bacuani bojoma'iñe cani, ja'nrëbi jo'cani se'e saijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bojojën sehuocua huë'ena ti'anni, ja'an huë'ena bëani ba'ijë'ën. Bacuabi cuirajënna, bacua aon, bacua gono, Riusu insise'ere sëani, coni ainjën, bacuani bojojë'ën. Ja'an huë'e jobore ba'ijën, ja'an huë'e se'gare ba'ijë'ën. Yequë huë'eñana cainjën saima'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ja'nca sëani, mësacuabi bain ba'iruna ti'anni, mësacuana bojojën ba'icuana cacani ba'ijën, bacua aonre ainjën, ");
INSERT INTO snnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","bacua rau ju'incuare huachojën, bacuani quëani achojë'ën: Riusu bainrebare re'huani baja'yete cato, yua te'e jëana ti'anja'ñeta'an ba'iji, quëani achojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ja'nrëbi, yequë huë'e jobona ti'anni, mësacuani bojoma'itoca, bacua huë'e joboreba ba'iruna sani, si'acuani bëin coca cajë'ën: ");
INSERT INTO snnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Mësacuabi yequënani bojoma'icuare sëani, mësacua huë'e jobo ya'o së'ase'ere yëquëna guëoñabi cue'nconi tonni gare jo'cayë ënjo'on. Ja'nca yo'ojënna, mësacua yua ën cocare ro'tajë'ën: Riusu bainrebare re'huani baja'yete cato, yua te'e jëana ti'anja'ñeta'an ba'iji. Ja'anre cajën, bacua bënni senjoja'ñete bacuani masi güesejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ja'an umuguse, Riusu cuencuesi umuguse ti'anguëna, Sodoma bainni bënni senjose'e'ru quë'rë ta'yejeiye bënni senjosi'cua ba'ija'cua'ë bacua, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Cani ja'nrëbi, yequë huë'e joboña bainni bënni senjoja'ñete quëa bi'rabi Jesús: —Corazin huë'e jobo bain, Betsaida huë'e jobo bain, mësacua yua ai yo'ojën ba'ija'cua'ë. Riusu ta'yejeiye yo'ose'e, mësacuani ëñose'e, ja'anre Tiro bain, Sidón bain, ja'ancuani ëñoguë ba'itoca, bacua yua ai zoe ba'irën bacua gu'a juchare gare jo'cani senjore'ahuë. Bacua yua ai sa'ntiye ai oijën, costal cañare sayani, yë'tëbi inni, bacua sinjobëna yu'yujën ba'ire'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ja'nca sëani, Riusu cuencuesi umuguse ti'anguëna, Riusubi mësacuani ëñani, Tiro, Sidón, ja'an huë'e jobo bainni bënni senjoja'ñe'ru mësacuani quë'rë ta'yejeiye ai bënni senjoguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mësacua Capernaum bainre'ga ai bënni senjoja'ñete quëayë yë'ë. Mësacuabi ro'tajën, Riusu ba'i re'otona ti'anja'cua'ë mai, cajën ba'icuareta'an, ja'an jai toa se'gana ti'anja'cua'ë mësacua, cani jo'cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ja'nrëbi baguëre concuani se'e caguë quëabi Jesús: —Si'a hua'na mësacua cocare te'e ruiñe achacuabi yë'ë cocare'ga te'e ruiñe achayë. Si'a hua'na, mësacuare gu'a güeni senjocuabi yë'ëre'ga gu'a güeni senjoñë. Si'a hua'na, yë'ëre gu'a güeni senjocua'ga Ja'quë Riusu yë'ëre cuencueni raosi'quëre'ga gu'a güeni senjoñë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ja'nca cani tonni, baguë bain setentacuare saobi. Saoguëna bacuabi sani, baguë case'ere yo'oni, ai bojo hua'na rani, Jesusni quëahuë: —Ëjaguë, yëquënabi më'ë ta'yejeiye ba'iyete cani achojën, si'a yo'ore ta'yejeiye yo'oye porehuë. Gu'a huati hua'i'ga yëquëna cocare achajën, yëquëna case'ere achani yo'ohuë, cajën bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Cajën bojojënna, Jesusbi quëabi: —Ja'nca raë'ë. Zupai huati'ga guënamë re'otore ba'iguë, mëjo jue'neñe'ru te'e jëana tonni huesëguëna, ëñahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ja'nca sëani, mësacua achajë'ën. Yë'ëbi mësacuare sao bi'raguë, ai ta'yejeiye ba'icuare mësacuare re'huahuë. Aña hua'na, buni hua'na, ja'an hua'nana za'nguto, gare ja'si yo'oma'iñë bacua. Zupai huatibi ta'yejeiye je'o baguëna, mësacuabi, baguëni quë'rë ta'yejeiyereba yo'oni, baguëre saoni senjoñe poreyë. Ja'nca porejënna, gare ja'si yo'oye beoye ba'iji mësacuare. ");
INSERT INTO snnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ja'nca porecua ba'ijën, zupaire concuabi mësacuare achani yo'ojënna, ja'anre ro'tajën bojomajën ba'ijë'ën. Mësacua mami yua Riusu uti pëbëna toyani jo'case'e ba'iguëna, ja'an se'gare ro'tajën, ja'an se'gare bojojën ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ja'nca cani, Riusu Espíritu naconi bojo recoyo re'huani, ai bojoreba bojoguë, Riusuni ujaguë cabi: —Taita Riusu, më'ëbi guënamë re'oto, yija re'oto, si'aye re'huani baguëna, më'ëni ai bojoreba bojoguë cayë yë'ë. Ro bain cocare ta'yejeiye ye'yeni masicuabi më'ë masi güeseyete masiye yëcuareta'an, bacuani masi güesemaë'ë më'ë. Zin hua'na ro'taye'ru ro'tacua, bacua se'gani më'ë ba'iyete masi güesehuë më'ë. Aito, Taita. Më'ë yëse'e sëani, ja'nca bacuani masi güesehuë më'ë, ujaguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ja'nca ujani, baguëre concuare quëabi: —Yë'ë Taita Riusubi si'aye yë'ëna insini jo'cabi. Yë'ë Taita se'gabi yë'ëre, baguë Zinre masiji. Yequëcuabi yë'ëre gare huesëyë. Yë'ë se'gabi yë'ë Taita Riusuni masiyë. Yequëcuabi baguëte gare huesëyë. Yë'ë, baguë Zin sëani, yë'ë yëye'ru yo'oguë, yequëcuani yë'ë Taita ba'iyete masi güeseye poreyë. Ja'nca masi güeseguëna, bacua se'gabi baguëni masiyë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ja'nrëbi baguëre yo'o concuare ëñani, bacua se'gani ñaca quëabi Jesús: —Mësacua yua yë'ëni ëñajën, yë'ë yo'o yo'oyete ëñajën, bojoreba bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Riusu ira bain raosi'cua, bain ta'yejeiye ëjacua, bacua yua yë'ë, Riusu Raoja'guëreba ba'iguëte ëñani masiye yëcuata'an, yë'ëre ëñamaë'ë. Yë'ë cocare achaye yëcuata'an, yë'ëre achamaë'ë. Mësacuaca yë'ëre ëñani, yë'ëre achani, yë'ëni masicua sëani, ai bojoreba bojojën ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Caguëna, ja'nrëbi ira coca toyani jo'case'ere ye'yoguëbi ti'anni, Jesusni huacha sehuo güeseza caguë, baguëni coqueguë senni achabi: —Ëjaguë, Riusu naconi carajeiye beoye si'arën ba'iye yëyë yë'ë. Ja'an ba'ija'yete baza caguë, ¿gue yo'o yo'oye baye'ne yë'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Senni achaguëna, Jesús sehuobi: —Riusu ira coca toyani jo'case'ere ëñaguë, ¿guere ye'yeguë'ne më'ë? ¿Gue coca cani jo'case'e ba'iguë'ne? senni achaguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sehuoguëna, ba hua'guëbi cabi: —Ja'an cocare ëñato, ñaca caji: “Më'ë Ëjaguë Riusuni si'a recoyo bojoguë, baguëni ai yëreba yëguë ba'ijë'ën. Më'ë ba'iye, më'ë ro'taye, ja'an naconi si'a jëja ta'yejeiye baguëni yëreba yëjën ba'ijë'ën. Më'ë ba'iyete te'e ro'taguë ba'iye'ru më'ë te'e bain hua'nani re'oye ro'taguë, bacuare yëreba yëguë ba'ijë'ën.” Ja'anre caji Riusu ira coca toyani jo'case'e, caguë sehuobi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sehuoguëna, Jesús cabi: —Te'e ruiñera sehuohuë më'ë. Ja'an cani jo'case'e'ru yo'otoca, Riusu naconi carajeiye beoye ba'ija'guë'ë më'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Caguëna, ira coca ye'yoguëbi ja'ansi'quë ro'taguë, Bain hua'nabi yë'ë cocare achani, yë'ë masiye ro'tayete masija'bë caguë, Jesusni se'e senni achabi: —Më'ëbi te'e bainre caguëna, ¿jarocua'ne? senni achabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Senni achaguëna, Jesusbi ye'yo cocare quëaguë, baguëni sehuobi: —Yequë bainguëbi Jericó huë'e jobona saza caguë, Jerusalenbi saiguëna, ja'nrëbi bonse jiancuabi baguëni tëhuo rani, baguëni zeanni, baguë bonse, baguë caña, si'ayete tëteni, baguëni ai ja'si yo'oni, baguëni huani ya'tu güeseni, baguëte ju'in hua'guëre jo'cani senjoni saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Senjoni satena, ja'nrëbi pairi hua'guëbi ja'ansi ma'abi saiguë, ju'in hua'guëna ti'anni ëñaguë, ca'nco quëhuijani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Saquëna, ja'nrëbi Riusu huë'e yo'o conguë Levita bainguë'ga ti'anni ëñaguë, baguë'ga ro ca'nco quëhuijani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Saquëna, ja'nrëbi Samaria bainguë tin jobo bainguëbi ti'anni ëñaguë, baguëca Chao hua'guë caguë, ju'in hua'guëni ai oire baguë, baguëre coñe se'ga ro'tabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ja'nca ro'taguë, Baguë ja'si nesiruanre re'huaza caguë, hui'yabe, jo'cha, ja'anbi ja'ñeni, canbi re'oye huenbi. Huenni, baguë burro hua'guëna tëoni, bain cain huë'ena sani, baguëre cuira bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cuirani ñatani, ja'nrëbi samu curi so'corëanre inni, ba huë'e ëjaguëna insini cabi: “Ënquëre re'oye ëñaguë cuirajë'ën. Quë'rë se'e ro'iye banica, yë'ëbi se'e rani, më'ë ro'ise'ere go'yayë” cabi baguë, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Quëani, Jesús yua baguëni senni achabi: —Më'ë yua ëñere ro'tani quëajë'ën. Ya'tu güesesi'quëbi ma'are uinguëna, ¿jaroguëbi baguëni ëñaguë, baguë te'e bainre yo'oye'ru yo'oguë'ne? ¿Queaca ro'taguë'ne më'ë? senni achabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Senni achaguëna, ira coca ye'yoguëbi sehuobi: —Baguëni ai oire baguë consi'quë, ja'anguë baji'i. sehuobi. Sehuoguëna, Jesús cabi: —Ja'anguë baji'i. Ja'nca ba'iguëna, më'ë'ga güina'ru sani, bainre güina'ru oire baguë conguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ja'nrëbi, Jesusbi se'e sani, baguëre concua naconi yequë huë'e jobona ti'anguëna, Marta hue'egobi baguëte choigona, bago huë'ena cacani ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Cacani ëñaguëna, yeco, María hue'ego, Marta yo'jego ba'igobi Jesús cocare achani ye'yeza cago, baguë guëon na'mi ca'ncona bëani achago baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Achago ba'igona, Martabi bago yo'o ma'carëanre zoe yo'oni ya'jani, Jesusna bonëni cago: —Ëjaguë, yë'ë yo'jegobi ro cue'yoni, huë'e yo'o ma'carëanre conma'igona, yë'ë se'gabi yo'oye porema'iñë. Ja'nca sëani, ¿yë'ëre coñe bagoni guanseye ro'tama'iguë më'ë? cago. ");
INSERT INTO snnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Cagona, Jesús sehuobi: —Marta, Marta, ai sa'nti hua'go cayë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yë'ë cocarebare achani ye'yetoca, re'oye ba'iji. Maríaca yë'ë cocare ja'nca te'e ruiñe achani ye'yegona, bagore gare ënsema'iguë ba'iyë yë'ë. Ja'an cocare bojogona, yequëcuabi bagoni gare sa'nti güeseye beoye ba'ija'cua'ë, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ja'nrëbi, yequë umuguseña ba'iguëna, Jesusbi sani, Riusuni ujaguë, coca senni tëjiguëna, baguëre yo'o con hua'guëbi baguëni senni achabi: —Ëjaguë, yëquënani ujaye ye'yojë'ën. Juanbi baguëre yo'o concuani ujaye ye'yoguëna, yëquënare'ga güina'ru ujaye ye'yojë'ën senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Senni achaguëna, Jesús cabi: —Mësacuabi Taita Riusuni ujanica ñaca ba'iye cajë'ën: Yëquëna Taita, quënamë re'otore ba'iguëna, si'a bainbi më'ë ta'yejeiyereba ba'iyete te'e ruiñe ro'tajën ba'ija'bë. Më'ë bainreba jobore re'huaguë, yëquënare te'e jëana ëño raijë'ën. Më'ë guënamë re'oto ba'icuabi më'ë yëye'ru yo'ojënna, ën yija bain'ga më'ë yëye'ru güina'ru yo'ojën ba'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yëquëna aon aiñe, yure umuguse aiñe se'gare insijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yëquëna gu'aye yo'ojën ba'ise'ere huanë yeni ro'tama'ijë'ën. Yequëcuabi yëquënani gu'aye yo'ojënna, bacua gu'aye yo'ose'ere huanë yeye cani se'e ro'tamaë'ë yëquëna. Ja'nca ro'tamajënna, më'ë'ga yëquënani güina'ru yëquëna gu'aye yo'ose'ere ro'tama'iguë ba'ijë'ën. Yëquënani gu'aye yo'oye ro'ta güesema'ijë'ën. Ja'anre yëquënare etojei güesejë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Cani, bacuani se'e yeque cocare ye'yo bi'rabi Jesús: —Yequë bainguë yo'ose'ere ro'tajë'ën. Ñami jobo ba'iguëna, baguë gajeguëbi ëñaguë raiguëna, aon beoguëña, baguëte cuirayete. Ja'nca beoguëbi yequë baguë gajeguë huë'ena sani, baguëni senni achaguëña: “Besa, samute jo'jo aonbëanre prestajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","So'o bainguëbi yë'ë huë'ena ti'anguëna, baguëni aon cuiraye beoyë yë'ë” caguë quëaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Caguë quëaguëna, baguë gajeguë huë'e sa'nahuë ba'iguëbi sehuoguëña: “Porema'iñë. Anto sa'rore ta'pini tëjihuë yë'ë. Zin hua'na naconi yua cain umesi'cua sëani, huëni insiye porema'iñë yë'ë” sehuoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ja'nca sehuoguëna, hue'se nëcaguëbi jo'caye beoye se'e senni achaguëna, baguë gajeguëbi, Yë'ëre se'e hui'ya senma'ija'guë caguë, baguë yua huëni, baguë yëse'e insiguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja'nca insisi'quë sëani, mësacuare güina'ru quëayë yë'ë. Mësacua yëyete senreba sentoca, Riusubi insija'guë'bi. Jo'caye beoye ujajënna, Riusubi ai masiye sehuoja'guë'bi. Riusuni recoyo te'e zi'inni baza catoca, Riusubi baguë ba'iyete mësacuani masireba masi güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ën yija bain senreba señe'ru Riusuni senni achajën ba'ijë'ën. Ën yija bainbi si'a jëja sentoca, bacua bainbi insiyë. Si'a jëja cu'etoca, bacuabi tinjañë. Si'a jëja je'njuni achotoca, bacua bainbi anconi caca güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mësacua'ga ën cocare achani ye'yejë'ën. Mësacua zin hua'nabi ziaya hua'ire sentoca, ¿añare insiye mësacua? Bañë. ¿Jo'jo aonbëte sentoca, gatabëte insiye mësacua? Bañë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Cura ziare sentoca, bunire insiye mësacua? Bañë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mësacua yua gu'aye yo'oye ye'yesi'cua ba'ijën, mësacua zin hua'nani re'oye insini cuiraye masijënna, mai Taita Riusu guënamë re'otore ba'iguëbi quë'rë ta'yejeiye maini conni cuirareba cuiraye masiji. Maibi baguë Espíritu raoyete sentoca, gare ënseye beoye maina raoji Riusu, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ja'nrëbi jë'te, Jesusbi yi'o ma'tëbë bainguëni tëhuoni, baguë gu'a huatire etoni saoguë baji'i. Etoni tëjiguëna, ja'an bainguëbi coca ca bi'rabi. Coca caguëna, bain hua'nabi ai bojoreba bojojën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ëñajënna, yequëcua'ga ai jayajën cahuë: —Huati hua'i ëjaguë Beelzebú hue'eguë, ja'anguëbi conguëna, Jesusbi huati hua'ire etobi'te, jayajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cajënna, yequëcua'ga Jesusni huacha sehuo güeseñu cajën, baguëni ñaca senni achahuë: —Ta'yejeiyereba yo'ore yo'ojë'ën. Ëñaza, senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ja'nca gu'aye cajënna, Jesusbi bacua ro'tayete masiguë, bacuani sehuobi: —Te'e yija bainbi si'a jurëanre re'huani sa'ñeña guerra huatoca, si'a jubë gare ñu'ñujeiñë. Te'e huë'e bainbi sa'ñeña je'o batoca, si'acua gare ñu'ñujeiñë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ja'nca sëani, zupai jobobi güina'ru sa'ñeña huatoca, güina'ru jëja beoguë carajeiji. Mësacuabi jaya coca cajënna, ja'nca sehuoyë yë'ë. Yureca Beelzebubi ¿queaca yë'ëre conguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mësacua bain'ga huati hua'ire etoni saojënna, ¿jaro ëjaguëbi ta'yejeiye conguë'ne? Bañë. Mësacuabi yë'ëre jayajën cajën, mësacua ro huacha cayete si'acuani masi güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Riusu se'gabi yë'ëre conguëna, huati hua'ire etoni saoyë yë'ë. Ja'nca conguëna, baguë bainrebare re'huani baja'yete ro'tajë'ën. Te'e jëana ti'anja'ñeta'an ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ën cocare'ga ro'tani, Riusu ta'yejeiye ba'iyete masijë'ën. Yequë bainguë ai jëja baguëbi baguë hua guëna naconi baguë huë'ere re'oye ëñaguëna, yequëcuabi tëani saye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yequë'ga baguë'ru quë'rë jëja baguëbi baguë huë'ena ti'anni, baguëni quë'rë ta'yejeiye huani saoni senjotoca, baguë huë'ena cacani, baguë hua guëna, baguë bonse beoru tëteni sani, baguë bainna huo'hueni insiji. ");
INSERT INTO snnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yureca, yë'ëre re'oye ëñama'icua ba'itoca, yë'ëni gu'aye ro'taye se'ga ba'iyë. Yë'ëre yo'o conma'icua ba'itoca, yë'ë re'huase'ere ro ñu'ñu güesejani senjoñë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ën cocare'ga ro'tani, bain gu'ajeiyete ye'yejë'ën. Gu'a huatibi bainguëte etani saiguë, beo re'otona ganiguë, ¿Jarona bëani huajëye'ne yë'ë? caguë, cu'eni jëhuani, se'e ro'tani, Yë'ë etasi huë'ena goza cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ja'nca cani, baruna go'ini ëñato, yua re'oye re'huasi huë'e, yua re'oye yuase'e baji'i, bainguë recoyo. ");
INSERT INTO snnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ja'nca ba'iguëna, baguë yua se'e sani, baguë gu'a gajecua te'e ëntë sara samucuare tëhuoni choji'i. Baguë'ru quë'rë ta'yejeiye gu'aye ba'icuani choini, rani, si'a jubëbi ba etasi huë'ena cacani bëahuë, bainguë recoyona. Ja'nca bëani ba'ijënna, ja'an bainguë yua quë'rë ta'yejeiye ai gu'ajeiguë baji'i. Ru'rureba ba'ise'e'ru quë'rë ta'yejeiye gu'aguë baji'i, ye'yoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ye'yoguë caguëna, romi hua'go bain jubë naconi ba'igobi baguëni coca güigo cago: —¡Më'ë pë'cagobi më'ëni të'ya rani, më'ëni chuchasi'co sëani, ai bojoreba bojogo ba'ija'go! güigo cago. ");
INSERT INTO snnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Güigo cagona, Jesús sehuobi: —Riusu cocare achani te'e ruiñe yo'ocua'ga bago bojoye'ru quë'rë ta'yejeiye ai bojoreba bojojën ba'ija'cua'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ja'nca sehuoni, bain hua'nabi quë'rë jai jubë ñë'cajënna, bacuani coca quëa bi'rabi: —Yureña bainbi ai gu'aye ro'tajën, yë'ëni senni achajën, Ta'yejeiyereba yo'ore yo'ojë'ën. Ëñaza, senni achajën cajënna, Riusu ira raosi'quë Jonás hue'eguë, baguë ba'ise'e se'gare yureña bainni masi güeseyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás yua Nínive huë'e jobo bainna raosi'quë ba'ise'e'ru yë'ë'ga, Riusu Raosi'quëreba ba'iguë, yureña bainna raosi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yecore'ga, ira baingo ba'isi'co, sëribë ca'nco bain ta'yejeiye ëjago ba'isi'core ro'tani, Riusu bënni senjoja'ñete masijë'ën. Bain ta'yejeiye ëjaguë Salomonbi ai masiguë yihuoguëna, bagobi Salomón masiguë yihuo cocare achani masijaza cago, ai so'o sani baguëna ti'anni achagoña. Ja'nca achani masisi'core sëani, mësacua yua bago yo'ogo ba'ise'ere ro'tani, yë'ë cocareba yureña quëani achose'ere quë'rë te'e ruiñe achani ye'yejën ba'ijë'ën. Achaye güetoca, yë'ë yua Salomon'ru quë'rë ta'yejeiyereba masiguë sëani, Riusubi mësacuani quë'rë ta'yejeiye bënni senjoguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Riusu cuencuesi umuguse ti'anguëna, Nínive huë'e jobo bainre'ga ëñaja'cua'ë mësacua. Bacua yua Jonás coca quëani achose'ere achani, bacua gu'a juchare jo'cani senjoreña. Yureña'ga yë'ëbi ti'an rani, Riusu cocarebare quëani achoguëna, mësacua yua achaye güetoca, ai ta'yejeiyereba bënni senjosi'cua ba'ija'cua'ë mësacua, yë'ë yua Jonas'ru quë'rë ta'yejeiye ba'iguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mësacua yua te'e ruiñe yo'ocua ba'iye yënica, ën cocare achani ye'yejë'ën. Bainbi majahuëte zëonni, ro'rohuëbi meñe jaoni ta'pima'icua ba'iyë. Majahuëte gare yahueye beoye ba'iyë. Bain ti'ancuabi, re'oye ëñaja'bë cajën, majahuëte zëonni ëmëna reoyë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mësacua ñaco yua mësacua recoyo majahuë'ru ba'iji. Mësacua ñacobi ëñajën, te'e ruiñe yo'oye ro'tatoca, si'a recoyo miañereba miaji. Gu'aye yo'oye ro'tatoca, si'a recoyo yua zijei recoyo'ru ruinji. ");
INSERT INTO snnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ja'nca sëani, mësacua ëñare bajën, te'e ruiñe ro'tajën ba'ijë'ën. Ja'nca ro'tama'itoca, gu'a ëase'e se'gare ro'tatoca, zijeiye se'ga ba'iji mësacua recoyore. ");
INSERT INTO snnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si'a recoyoreba te'e ruiñe ro'tajën ba'itoca, gare zijeiye beoye ba'itoca, mësacua yua gare jo'caye beoye te'e ruiñereba masini re'oye yo'oye se'ga ba'iyë. Majahuë re'oye miañe'ru te'e ruiñe ëñani, te'e ruiñe masini yo'oye porecua'ru ruiñë mësacua, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cani tëjiguëna, fariseo bainguëbi baguëni choiguë, Yë'ë huë'ena sani, yë'ëre aon aiñe conjë'ën caguë choiguëna, Jesusbi te'e conguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sani ti'anni, fariseo bain yo'oye'ru yo'oma'iguë, baguë ëntë sarañare bacua zoaye'ru zoamaquëna, baguëre choisi'quëbi gu'aye ro'taguë ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ja'nca ëñaguëna, Ëjaguë Jesusbi baguëni cabi: —Mësacua fariseo bainbi guëna ro'rohuëanre zoajën, guërëbë ca'nco se'gare zoacua ba'iyë. Sa'nahuë ca'ncore zoaye ro'tama'icua ba'iyë. Güina'ru, mësacua recoyo gu'a recoyoreba se'ga ba'iyë. Ro gu'aye ro'tajën, bain bayete ro tëteni bajën, ");
INSERT INTO snnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","mësacua ¿queaca ro'tajën, ro huesë ëaye yo'ojën ba'iye'ne? Mësacuabi ëmëje'en ca'nco se'gare ëñajën, Yë'ë ga'nihuë Riusu re'huani jo'case'ere sëani, re'oye zoani re'huaza cajën, mësacua ¿queaca ro'tajën, mësacua recoyo re'oye re'huani, Riusu yëyete yo'oma'iñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mësacua yua bonse beo hua'nana insijën, Riusu yëye'ru bacuana ro insiñu cajën, ro yo'omajën ba'ijë'ën. Mësacua recoyo oire bajën, Bacuana te'e ruiñe conñu cajën, Riusu yëyete yo'ojën, bacuani te'e ruiñe conjën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mësacua fariseo bain gu'aye yo'ojënna, Riusubi mësacuani ai bënni senjoja'guëbi. Mësacua yua Riusu coca cani jo'case'ere te'e ruiñe yo'oñu cajën, mësacua ma'ña sëñete inni, décima parte ba'iyete cuencueni, Riusu cani jo'case'e'ru cuencueni, baguëna insiyë mësacua. Ja'nca insicuata'an, Riusu yëye'ru te'e ruiñe yo'omajën, Riusuni gare yëye beoye ba'icua'ë mësacua. Ja'anre quë'rë ta'yejeiye ro'tajën, mësacua cuencueni insiye'ru yo'ojën, quë'rë ta'yejeiye yo'ojën, Riusuni si'a recoyo yëjën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mësacua fariseo bain gu'aye yo'ojënna, Riusubi mësacuani ai bënni senjoja'guë'bi. Mësacua yua bain ñë'ca huë'ena sani, ëja bain ñu'i seihuë se'gana bëaye yëyë. Mësacua yua huë'e joborebana sani, bain saludayete ëjojën, Ëja bainre saludaye'ru yë'ëre saludaja'bë cajën, ëjoyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mësacua ira coca cani jo'case'ere ye'yocua, mësacua fariseo bain, si'acuabi re'o bain ba'iye'ru ro coquejën ëñojënna, Riusu bënni senjoñe se'ga ba'ija'guë'bi mësacuare. Bain tansiruan se'ga'ru ba'iyë mësacua. Ro ëmëje'en ca'nco se'gare re'oye ëñocuata'an, ai ënto sëñe se'ga ba'iyë, sa'nahuë ca'ncore. Bain hua'nabi ëmëje'en ca'nco se'gare ëñajën, Bain tansiruan ai re'oye ëñoji cajën, mësacua gu'a recoñoa ba'iyete ro huesë ëaye ëñañë, bëinguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Caguëna, ira coca cani jo'case'ere te'e ruiñe masiguëbi Jesusni cabi: —Ëjaguë, më'ëbi ja'an cocare caguë, yë'ë, yë'ëre conjën ba'icuare'ga caguë, yëquënare gu'aye achoye cayë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Caguëna, Jesús sehuobi: —Aito. Mësacua, ira coca cani jo'case'ere te'e ruiñe masicuare'ga ai bënni senjoja'guë'bi Riusu. Mësacua yua bain hua'nani ai guaja yo'o güesecuata'an, mësacuabi güina'ru yo'oye beoye ba'ijën, bacuani gare conmajën ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mësacuabi ai gu'aye ro'tajën ba'ijënna, Riusubi mësacuani ai bënni senjoñe ba'ija'guë'bi. Riusu ira bain cuencueni raosi'cua tansiruanre re'oye re'huajën, re'oruan ëñoja'guë cajën, bojojën yo'ojënna, Riusubi bëinji. Mësacua ira bain ba'isi'cuabi Riusu bain raosi'cuani huani senjosi'cuare sëani, mësacua yua bacua ro'tajën ba'ise'e'ru güina'ru gu'aye ro'tajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mësacua yua ja'an bain tansiruanre re'oye re'huajën, mësacua ira bain ba'isi'cua huani senjose'ere re'oye ro'tajën, bacua ro'tajën ba'ise'e'ru te'e ro'tacua'ru ëñoñë mësacua. Bacuabi Riusu bainni huani senjosi'cua ba'ijënna, mësacua yua Riusu bain tansiruanre re'oye re'huajën, güina'ru gu'aye yo'ocua'ru ëñoñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Riusubi mësacua yo'ojën ba'ija'yete te'e ruiñe masiguë sëani, ñaca cani jo'cabi: “Yë'ëbi yë'ë coca cani achocua, yë'ë ta'yejeiye yo'ore concua, ja'ancuare re'huani, bainna saoguëna, bain hua'nabi ro cue'yoni, bacuani ro je'o bajën, yequëcuare ja'si yo'ojën, yequëcuare huani senjoja'cua'ë” cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ja'nca cani jo'casi'quë sëani, baguë bain cuencueni raosi'cuare ro'taguë, baguë ën yija re'huani jo'casirënbi raosi'cua huani senjosi'cua ba'ijënna, yureña bain gu'aye yo'ose'e ba'iji caguë, mësacuani sehuoye senja'guë'bi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Baguë ira bainguë raosi'quë Abel hue'eguë, baguë huani senjose'ere ro'taguë, si'a jë'te raosi'cua huani senjose'ere ro'taguë, baguë bainguë Zacarías ba'isirën tëca raosi'cua, si'acuare huani senjojënna, mësacuani sehuoye senja'guë'bi Riusu. Zacarías hue'eguë ba'isi'quëre cato, baguë yua misabë ca'ncorëte nëcaguëna, mësacua ira bain ba'isi'cuabi baguëni huani senjohuë. Ja'nca sëani, mësacuani ganreba caguë quëayë yë'ë. Riusu bain raosi'cua huani senjosi'cua si'acuare ro'taguë, yureña bainni sehuoye senji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mësacua, ira coca te'e ruiñe masicua, ai bënni senjosi'cua ba'ija'cua'ë. Riusubi baguë masiye ye'yose'ere bainna jo'caguëna, mësacua se'gabi ro yahue re'huani, bainni gare ye'yomaë'ë. Ye'yomajën, bain hua'nabi ye'yeye yëcuareta'an, gare ënsehuë mësacua. Ja'nca sëani, Riusubi mësacuani ai bënni senjoja'guë'bi, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ja'nca caguë quëaguëna, ira coca te'e ruiñe masicua, fariseo bain, bacuabi ai bëinreba bëinjën, baguëni ai hui'ya senni achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Baguëni huacha sehuo güeseñu cajën, baguëni coque ëaye ro'tajën, baguëni hui'ya senjën, baguë sehuoyete ai achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ja'nca ba'icuata'an, quë'rë jai jubëan bainbi Jesús cocare achañu cajën, sa'ñeña jë'jejën quëonjën, baguëna ti'anhuë. Ja'nca ti'anjënna, Jesusbi baguëre yo'o concuani ru'ru yihuoguë cabi: —Mësacua yua ëñare bajën, fariseo bain aon huo'coye, bacua yo'ojën ba'iye ja'anre ëñani, gare yo'oye beoye ba'ijë'ën. Bacua yua ëmëje'en ca'nco se'gare re'huajën, Re'o bain ba'iyë yëquëna cajën, ro coquejën, ro gu'aye yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bacuabi ro yahue gu'aye yo'ojënna, Riusubi si'aye ëñani masiji. Si'a bain yahue gu'aye yo'ojënna, Riusubi si'ayereba masini, si'ayete si'a bainni masi güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ja'nca sëani, mësacua yahue case'e, zijei re'oto cani jo'case'e ba'iguëna, Riusubi si'a bainni te'e ruiñera masi güeseja'guëbi. Si'a bainbi te'e ruiñe achajën ba'ija'cua'ë. Mësacua huë'ena yahue quëajën ba'ise'e ba'itoca, si'a huë'e jobona quëani achose'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mësacua yua yë'ë gaje hua'na ba'ijënna, mësacuani yihuoguë quëayë yë'ë. Yequëcuabi mësacuani huani senjo ëaye yo'otoca, bacuani gue huaji yëye beoye ba'ijë'ën. Bain ga'nihuë se'gare huani senjoñe porecuabi mësacua recoyo carajei güeseye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Riusu bënni senjoja'ñe se'gare huaji yëjën ro'tajën ba'ijë'ën. Gu'a jucha yo'otoca, mësacuabi junni huesëjënna, Riusu yua ja'an toana mësacuare senjoni saoye poreji. Ja'nca sëani, Gu'aye yo'oma'iñe cajën, Riusuni bëin güesemajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ën cocare ro'tani, Riusu ta'yejeiye conreba coñete masijë'ën. Bi'an hua'na te'e ëntë sara ba'i hua'nare coni misabëna ëoye yëtoca, samu curi so'corëan se'gare ro'iye bayë mai. Ta'yejeiye ro'ima'iñe ba'iguëna, Riusu'ga bi'an ba'iyete gare huanë yema'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bi'an hua'na ba'iyete ai ro'taguë, mësacua ba'iyere'ga quë'rë ta'yejeiye ai ro'taguë ba'iji Riusu. Mësacua sinjobë rañare'ga cuencueni, ga rañañë ba'iye masiji Riusu. Ja'nca sëani, mësacua yua gare huaji yëye beoye Riusu conreba coñete masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ën cocare'ga mësacuani yihuoguë quëayë yë'ë. Bain hua'nabi achajënna, mësacua yua yë'ë ba'iyete quëani achojën ba'ijë'ën. Yë'ë yua Cristo bainguë'ë. Riusu Raosi'quëreba bainguë'ë yë'ë, quëani achojën ba'itoca, yë'ë'ga mësacua ba'iyete ëñaguë, Riusu guënamë re'oto yo'o con hua'nabi achajënna, Yë'ë bainreba yo'o concua ai re'o hua'na'ë, cani achoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yequëcua yë'ë ba'iyete ro'tajën, bain hua'nabi achajënna, Cristo bain ba'iyete cani achoye yëma'iñë yë'ë, catoca, yë'ë'ga, Riusu Raosi'quëreba ba'iguë, Riusu guënamë re'oto yo'o con hua'nabi achajënna, bacua ba'iyete güeni senjoñe caja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yë'ë ba'iyete gu'aye catoca, ja'nrëbi ja'an gu'aye case'ere huanë yeye senreba sentoca, Riusubi huanë yeni ro'tama'iguë ba'ija'guë'bi. Riusu Espíritu ba'iyete gu'aye catoca, ja'an gu'aye case'ere huanë yeye senreba sento'ga, Riusubi gare huanë yeye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yequëcuabi mësacuare preso zeanni, huë'e jobo ëjacua, bain ta'yejeiye ëjacua, bacua ba'iruanna nëconi gu'aye cajënna, mësacua sehuo coca caja'yete ru'ru ro'tamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mësacua sehuorën ti'anguëna, Riusu Espíritubi masi güeseguëna, ja'an cocare ëja bainni sehuojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Caguëna, yequë, bain jubë naconi ba'iguëbi Jesusni cabi: —Ëjaguë, yë'ë ja'yëbi yëquëna taita bonse jo'case'ere yë'ëna huo'hueni insiye yëma'iguëna, baguëni huo'hueye guansejë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Caguëna, Jesús sehuobi: —Bañë. Mësacua bonse huo'hueye cama'iguë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ja'nca cani, si'a hua'nani ñaca yihuoguë cabi: —Mësacua ëñare bajën, bonse ba ëayete ro'tamajën ba'ijë'ën. Bonse se'gare batoca, quë'rë re'oye ba'iye gare porema'iñë mësacua, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ja'nca cani, ye'yo cocare ñaca quëabi: —Ai ta'yejeiye bonse ëjaguë baquëña. Baguë aon tanse'ere ëñaguë, ai aon tëa güeseguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja'nca tëa güeseguë, ja'ansi'quë ro'taguëña: “¿Queaca yo'oye'ne yë'ë? Ai aon tëase'e ba'iguëna, ¿jarona ayani baye'ne yë'ë? Aon aya huë'eñana ayaye ti'anma'iñe sëani, ");
INSERT INTO snnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","yë'ë rëño huë'eñare ñañoni taonni, senjoni, quë'rë jai huë'eñare yo'oza, ro'taguë ba'iyë yë'ë. Ja'nca yo'oni tëjini, yë'ë aonre ayani bani, ");
INSERT INTO snnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ja'nrëbi yë'ë se'ga bojoguë caja'guë'ë: Yë'ëre ai re'oye ba'iji. Surupa. Gare se'e aon carajeiye beoye ba'ija'guë'ë yë'ë. Gare se'e gono uncuye carajeiye beoye ba'ija'guë'ë yë'ë. Ja'anna ta'yejeiye bojoguë, re'o recoyo huanoñe se'ga ba'ija'guë'ë yë'ë” ro'taguëña baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ja'nca ro'taguë ba'iguëna Riusubi baguëni caguëña: “Ro huesë ëaye ba'i hua'guë'ë më'ë. Yure ñami junni huesëja'guëta'an ba'iyë më'ë. Junni huesëguëna, më'ë re'o bonse ¿jarocuabi bëani baja'cua'ne?” caguëña Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mësacua yua ja'an ye'yo cocare achajën, ñaca ro'tajën ba'ijë'ën. A'ta bonsere bëyoni ta'yejeiye bonse ëjacua'ru ruñu cajën yo'otoca, carajeiye se'ga ba'ija'cua'ë. Riusuni yo'o conmajën, Riusu insija'yete gare coye beoye ba'ija'cua'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ja'nca cani tonni, ja'nrëbi jë'te, baguëre yo'o con hua'nani yihuoguë quëabi: —Mësacua aon ainja'ñe, mësacua caña ju'ija'ye, ja'anre ta'yejeiye ro'tamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Riusubi mësacuare ro aon aincuare re'huamaji'i. Riusubi mësacua ga'nihuëanre re'huaguë, ro caña ju'iye se'gare caguë jo'camaji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mësacua yua bi'an hua'na ba'iyete ëñani ye'yejë'ën. Ba hua'nabi gare aon tanma'icuata'an ba'iyë. Aon tëani re'huama'icuata'an ba'iyë. Bain hua'na re'huani baye'ru ba'ima'icuareta'an, Riusubi bacua aon ainjën ba'iye insiji. Ja'nca insiguë, mësacua ba'iyete quë'rë ta'yejeiye ro'taguë, mësacuani quë'rë re'oye conreba conni insiye masiji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mësacuabi ro'tajën, Quë'rë jëja yo'oni quë'rë zoa hua'guë'ru runza ro'tajën ba'icuata'an, gare porema'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ja'anre yo'oye poremajën, mësacua ¿queaca ro'tajën mësacua baja'yete ta'yejeiye cu'eye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jo'ya coro irayete ëñani ye'yejë'ën. Jo'ya coro se'gabi re'o canre tëonni ta'nëñe porema'iguëna, Riusu se'gabi jo'ya corore re'oye ëñoñe re'huaye masiji. Bain ta'yejeiye ëjaguë Salomón hue'eguë ba'isi'quëbi ai re'o caña me'najei cañare ju'ini ai re'oye ëñoguëreta'an, Riusu jo'ya coroña yua quë'rë ta'yejeiyereba ai re'oye ëñoji. ");
INSERT INTO snnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jo'ya coroña yua rëño ñësebë se'ga ba'iguë, ja'nrëbi te'e jëana junni huesëguëna, Riusubi ja'an coroñare ai re'oye re'huani jo'caji. Ja'nca re'oye re'huani jo'caye masiguëbi mësacuare'ga quë'rë ta'yejeiyereba ai re'oye conreba coñe masiji. ");
INSERT INTO snnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ja'nca masiguë sëani, mësacua yua ¿Queaca aon coni aiñe'ne? ¿Queaca gonore coni uncuye'ne? ja'anre ta'yejeiye ro'tamajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ro ën yija bainbi ja'an se'gare ai ro'tajën ba'icuata'an, mësacua Taita Riusu insiyete si'a recoyoreba ro'tajën ba'ijë'ën, mësacua carayete ai masiguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Riusu ba'i jobore ru'ru ro'tajën, Riusu yo'o coñe se'gare ro'tajënna, Riusubi si'a ën yija carayete mësacuana insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mësacua yua yë'ë bainreba ai yësi'cua sëani, gare huaji yëye beoye ba'ijë'ën. Mai Taita Riusubi mësacuani ai bojoguë, baguë ba'i jobo ba'ija'yete mësacuana ai insireba insija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ja'nca sëani, mësacua bonsere bendieni, bonse beo hua'nana ro insijë'ën. Ja'nca yo'onica, mësacua yua gare carajeiye beoye quë'rë ta'yejeiye coni baja'cua'ë. Riusu naconi guënamë re'otore ba'ijën, baguë insija'yete gare caraye beoye coni baja'cua sëani, ja'an se'gare ro'tajën ba'ijë'ën. Ja'anre bajënna, gare huesëni si'aye beoye ba'ija'guë'bi. Gare pu'ncaye beoye ba'ija'guë'bi. Gare jian güeseye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Riusu insija'yete coni baja'cua sëani, recoyo bojoreba bojojën ba'ijë'ën. Ro ën yija bonse se'gare ba ëaye ro'tatoca, rëño ñësebë se'ga bojojën, Riusu insija'yete gare coye beoye ba'ija'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Riusu cuencuesi umuguse yua te'e jëana ti'anja'ñeta'an ba'iguë sëani, mësacua te'e jëana sani ba'ija'yete re'oye ëñajën ëjojën ba'ijë'ën. Guëon ju'i corore sa'yeni, Majahuëre zëonni saiñu cajën ba'iye'ru ëñajën ëjojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ëja bainguë yo'o concua ëñajën ëjojën ba'iye'ru ba'ijë'ën. Bacua ëjaguëbi hueja fiestana saisi'quë ba'iguëna, Baguë yua joë ba'irën ti'anma'ija'guë cajën, baguë anto sa'rore ancoja'yete ëjojën bateña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ja'nca ëjojën ba'icuana ti'anni, bacuani ai bojoguë, bacuani ai re'oye conreba conguëña. Ja'an ëjaguëbi bacuani bëa güeseni, bacuani re'o aon cuiraguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Quë'rë ñami jobo ba'iye'ru ti'anni, baguëre yo'o concua ëjojën ba'icuare ëñani, bacuani ai ta'yejeiye ai insireba insiguë bojoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mësacua yua ën cocare'ga achani te'e ruiñe ro'taye ye'yejë'ën. Huë'e ëjaguëbi bonse jianguë rairën masinica, baguë ti'anja'ñete ëñaguë ëjoguë, baguë huë'ere jian güesema'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mësacua'ga yë'ë in rai umugusere ëñajën ëjojën ba'ijë'ën. Yë'ë ti'anja'ñete ta'yejeiye ro'tama'ijënna, yë'ë, Riusu Raosi'quëreba ba'iguëbi te'e jëana ti'anja'guëta'an ba'iyë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Caguëna, ja'nrëbi Pedrobi baguëni senni achabi: —Ëjaguë, ën cocare ye'yoguë caguë, ¿yëquëna hua'na se'gani yihuoguë, o si'a bainni yihuoguë caguë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Senni achaguëna, Jesús sehuobi: —Ëja bainguëre yo'o concua yo'ose'ere ro'tani masijë'ën. Baguëre yo'o conguë te'eguëbi te'e ruiñe recoyo ro'taguëna, baguë ëjaguëbi so'o sai bi'raguë, baguë huë'ere baguëna jo'caguë guanseguëña: “Yë'ëre yo'o con hua'nare bacua yo'o yo'oye guanseguë ba'ijë'ën. Bacuare aon cuiraye guanseguë ba'ijë'ën” cani tonni saquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sani, ja'nrëbi zoe ba'irën se'e rani ëñato, baguëre yo'o con hua'guëbi baguë huë'e ba'iyete ai re'oye cuiraguë baquëña. Ja'nca ba'iguëna, baguëni ai bojoguë, baguëni ai re'oye conguë ëñaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Baguë huë'e, baguë yija, baguë bonse, si'ayete baguëna jo'cani, baguë bain ëjaguëre baguëre re'huani, baguëni ai bojoreba bojoguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yequë yo'o con hua'guë'ga baquëña. Baguë ëjaguëbi so'o saisi'quë ba'iguëna, yo'o con hua'guëbi ro'taguë, Yë'ë ëjaguëbi zoe raima'iji caguë, baguë gaje yo'o concuani ai je'o baguë, baguë ëjaguë aonre a'ta ainguë, baguë jo'chare uncuni güebeguë, ");
INSERT INTO snnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yë'ë ëjaguëbi raima'iji caguëna, baguë ëjaguëbi te'e jëana ti'an rani, baguë gu'aye yo'ose'ere ëñani, baguëni zeanni, baguëni ai ta'yejeiye bënni senjoni, achaye güecua ba'iruna senjoni saoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ja'nca ba'ise'e sëani, mësacua ro'tani masijë'ën. Ëjaguëre yo'o conguëbi baguë ëjaguë guansese'ere achani, baguë yo'o yo'oye masiguë, ja'nrëbi baguë guansese'ere yo'oma'itoca, ëjaguëbi baguëni ai ta'yejeiye bënni senjoja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yequë yo'o conguëbi baguë ëjaguë guansese'ere huesëguë, ja'nrëbi baguë yo'o guansese'ere re'oye yo'oma'itoca, ëjaguëbi baguëni ta'yejeiye bëinma'ija'guë'bi. Güina'ru, mësacuani ai ta'yejeiye insini, ai ta'yejeiye masi güesetoca, mësacua yua quë'rë ta'yejeiye te'e ruiñe yo'o coñe bayë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yë'ëbi ën yijana raiguë, bainni ai yo'o güeseguë raë'ë, jai toa zëonse'e ba'iye'ru. Yuta toa zëoñe'ru yo'oma'iguë, te'e jëana zëonni, jai toa re'huaye'ru yo'oye ro'taguë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taita Riusubi ja'an toabi yë'ëni bautizaye ro'taguëna, ja'an bautizaja'ye tëca ai recoyo ja'siyereba ja'siguë ba'ija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mësacua yua yë'ë ba'iyete ro'tajën, ¿Bainni bojo güeseguë raisi'quë'bi ro'tajën ba'ima'iñe mësacua? Gare banhuë. Bainni sa'ñeña hua güeseguë raisi'quë'ë yë'ë. Sa'ñeña bëin güeseguë raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yureñabi te'e huë'e bain ba'icua, te'e ëntë sara ba'icua ba'ijën, si'a jubëbi sa'ñeña je'o bajën, sa'ñeña huaye se'ga ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pë'caguëbi baguë mamaquëni je'o baguëna, mamaquëbi baguë pë'caguëni je'o baja'guë'bi. Pë'cago'ga bago mamaconi je'o bagona, mamacobi bago pë'cagoni je'o baja'go'go. Romi huacua banica, sa'ñeña ai je'o bajën ba'ija'cua'ë. Ja'nca sa'ñeña hua güeseguë raisi'quë'ë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ja'nca cani tonni, ja'nrëbi, si'a bainni quëani achoguë cabi: —Mësacua yua ënsëguë ruajai ca'ncona ëñani, oco pico ba'itoca, Oco ca'niji cayë mësacua. Ja'nca cajënna, mësacua case'e'ru oco raji. ");
INSERT INTO snnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja'nrëbi, sëribë ca'ncobi tutu ratoca, mësacuabi, Ja'su umuguse ba'ija'guë'bi cayë. Cajënna, mësacua case'e'ru ja'su umuguse ruinji. ");
INSERT INTO snnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mësacua yua oco raja'ye, ja'su umuguse ruinja'ñe. ja'anre ai masiye quëacuata'an, ¿mësacua queaca ro'tajën, Riusu yureña yo'oja'yete ro huesë ëaye ba'iye'ne? Mësacua yua re'o bain ëñocuata'an, ro coquejën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Mësacua queaca ro'tajën, te'e ruiñe yo'oyete cani yo'oma'iñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yequëbi më'ëni preso zeanni ëja bain guanse huë'ena sa bi'ratoca, ru'ru më'ë porese'e'ru baguë naconi ro'i cocare cani tonjë'ën. Ëjaguë ba'iruna yë'ëre rërëni sama'iguë caguë, ja'nca baguëni cani tonjë'ën. Ja'anruna satoca, ëjaguëbi më'ëre ëñani, soldado hua'nana insiguëna, ya'o huë'ena guaoni baja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Më'ëre ja'nca guaoni batoca, më'ë curi beoru ro'iye tëca, ya'o huë'ebi gare etaye porema'ija'guë'ë më'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Caguëna, bain jubë ba'icuabi Jesusni coca quëahuë: —Ëjaguë, Galilea bainbi Jerusalén huë'e jobona ti'anni, Riusuni bojoñu cajën, bacua jo'ya hua'nare huani, misabëna tëoni ëo bi'rahuë. Ëo bi'rajënna, bain ëjaguë Pilatobi bacuare zeanni, bacuani huani senjoni, bacua zie yua bacua jo'ya hua'na zie naconi ja'meni jo'cabi quëahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Quëajënna, Jesús sehuobi: —Ja'nca huani senjosi'cua ba'ijënna, ¿Mësacua queaca ro'taye'ne? Mësacua yequërë ro'tajën, Ja'an Galilea bain yua bacua yija ba'icua'ru quë'rë gu'aye yo'ojën ba'isi'cua ba'imate, ro'tama'iñe mësacua? ");
INSERT INTO snnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bañë. Te'e ruiñe ro'tama'iñë mësacua. Mësacua'ga mësacua gu'a jucha yo'ojën ba'ise'ere gare jo'cani senjoma'itoca, mësacua'ga güina'ru carajeija'cuata'an ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yequëcua ëmë huë'e quëonsi'cuare'ga ro'tajë'ën. Ëmë huë'e Siloere ba'iguë, ñañani taonni, ja'an dieciocho bain hua'nana quëonguëna, huajë junni huesëhuë. Ja'nca quëonni huesësi'cua ba'ijënna, mësacua ¿queaca ro'taye'ne? Si'a Jerusalén bain ba'iye'ru quë'rë gu'aye yo'ojën ba'isi'cua ba'imate, ro'tama'iñe mësacua? ");
INSERT INTO snnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gare banhuë. Mësacua'ga mësacua gu'a jucha yo'ojën ba'ise'ere gare jo'cani senjoma'itoca, mësacua'ga güina'ru carajeija'cuata'an ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ja'nca cani, ja'nrëbi ye'yo cocare caguë, bainni quëani achobi: —Ën cocare achani, mësacua gu'a jucha jo'cani senjoñete te'e ruiñe ro'tajë'ën. Yequë ëjaguëbi higo sunquiñëte baguë ziona tanni, samute tëcahuëan ëjoni ëñato, higo uncuere gare quëinma'iñe baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ja'nca quëinma'iguëna, ëjaguëbi baguë zio cuiraguëni cabi: “Ja'an sunquiñë gu'a sunquiñë'ë. Higo uncuere tëani uncueja'ma caguë, ro cu'eni jëhuahuë yë'ë. Cueni taonni senjojë'ën, ro irani ba'iñëre sëani” cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Caguëna, zio cuiraguëbi sehuobi: “Banji. Cueni senjoma'iñu. Se'e yequë tëcahuë ëjona'a, ëjaguë. Bañë yijare re'oye mo'gani, re'o yijare pë'npëni uanni, re'oye re'huazaniñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja'nca re'huani ëjoguëna, ja'nrëbi yequë tëcahuë uncuere quëinma'itoca, cueni senjoñu” cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ja'nrëbi, yequë umuguse yo'o yo'oma'i umuguse ba'iguëna, Jesús yua bain ñë'ca huë'ena cacani, bainre coca ye'yoguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","romi hua'gobi me gurubë garani ju'ingo baco'ë. Dieciocho tëcahuëan gu'a huati cacasi'cobi te'e ruiñe nëcaye porema'i hua'go baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ja'nca ba'igona, Jesusbi ëñani, bagoni choini, ja'nrëbi bagoni quëabi: —Yë'ë baingo, më'ë rau beo hua'go ba'ijë'ën. Huati beogo, huajë hua'go ba'ijë'ën, caguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ja'nca quëani, baguë ëntë sarañabi bagona pa'roguëna, ja'ansirën te'e ruiñe nëcani, Riusuni ai bojoreba bojogo ca bi'rago. ");
INSERT INTO snnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ja'nca huajëni bojogona, ñë'ca huë'e ëjaguëbi baguë yo'o yo'oma'i umuguse huachose'ere ëñani, ai bëinreba bëinguë, bainni cabi: —Te'e ëntë sara te'e umuguseña yo'o yo'o umuguseña ba'iguëna, ja'an umuguseña se'gare rani huacho güesejë'ën. Yo'o yo'oma'i umuguse ba'itoca, huacho güeseye beoye ba'ijë'ën, bëinguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Caguëna, Jesusbi sehuobi: —Mësacua judío ëja bainbi Riusu cocare te'e ruiñe yo'oñu cajën ro coqueyë. Mësacua jo'ya hua'na, toro, burro, ja'an hua'na ba'iyete ëñajë'ën. ¿Yo'o yo'oma'i umuguse ba'iguëna, mësacua yua bacuare jo'chini, oco uncuruna sani, ocore uncu güesema'iñe? Aito. ");
INSERT INTO snnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ja'nca yo'ojën ba'icua sëani, ¿mësacua guere yo'ojën, bago huachoyete ënseye caye'ne? Ira taita Abraham baingorebare sëani, dieciocho tëcahuëan zupai huati cacani ba'iguëna, bagore yo'o yo'oma'i umugusebi huachoye ënsema'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja'nca caguëna, Jesusni se'e je'o ëñamajën, ro gati ëaye yo'o bi'rahuë. Bain hua'naca Jesús ta'yejeiye yo'o conse'ere ëñani, ai bojoreba bojojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ja'nrëbi, Jesús yua ye'yo cocare cabi: —Mësacua yua Riusu bainreba ba'i jubë re'huani baja'ye, ja'anre ye'yejë'ën caguë, ¿queaca mësacuani quëaye'ne yë'ë? ");
INSERT INTO snnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostazara'carë ba'iyete ro'tani ye'yejë'ën. Ai zinra'carë ba'iguëna, yijana tantoca, ai jai sunquiñë runni, jai cabëan quënquëna, ca hua'i hua'nabi ja'añëna ti'anni, bacua ziaroanre suayë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mësacua yua ën cocare'ga achani, Riusu bain re'huani baja'yete ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Romi hua'gobi bago jo'jo aonbëanre yo'ogo, aon huo'coyete inni, harinabë naconi ja'mego. Ja'nca ja'megona, si'a harinabëbi ta'yejeiye huo'coni, ai jaibë'ru ruinji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Cani tonni, ja'nrëbi se'e sani, Jerusalén huë'e jobona ti'añe tëca si'a bain huë'e jo'borëanna bonëni, bainre ye'yoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ye'yoguë ba'iguëna, yequëbi baguëni coca senni achabi: —Ëjaguë, ¿më'ë bain ba'ija'cua, Riusu bënni senjoñe jëaja'cua, rëño jubë se'ga ba'ija'cua'ne? caguë senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Senni achaguëna, Jesús sehuobi: —Mësacua yua Riusu ba'i jobona ti'añe ro'tanica, ja'an rëño sa'ro se'gabi cacani ba'ijë'ën. Ai jai jubë bainbi ja'an sa'robi cacaye güejën, Riusu ba'i jobona ti'añe gare porema'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Riusu cuencuesirën ti'anguëna, Riusubi ja'an sa'rore gare ta'piguëna, ai bain hua'nabi hue'se ca'ncore nëcajën, ja'an sa'rona je'njuni achojën caja'cua'ë: “Ëjaguë, yëquëna hua'nare ancojë'ën. Cacaye yëyë yëquëna” cajënna, baguëbi senni achaja'guë'bi: “Mësacua ¿jaro bain'ne?” senni achaguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","bacua sehuoja'cua'ë: “Më'ë bain'ë yëquëna. Më'ëbi yëquëna huë'e jobona ye'yo raiguëna, më'ë naconi te'e aon ainjën, gono uncujën baë'ë yëquëna” sehuoja'cua'ë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ja'nca sehuojënna, yë'ëbi bacuani quëaja'guë'ë: “Bañë. Mësacua yua yë'ë bain beojën, ro tin hua'na ba'icua'ë. Yë'ëni gu'aye yo'ojën ba'isi'cua sëani, gare saijë'ën” quëaja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Quëaguëna, ba hua'nabi ai oijën, recoyo ai ta'yejeiye sa'ntijën, ai yo'ojën, bacua zemeñoan cuncujën nëcaja'cua'ë. Ja'nca nëcajën, Riusu bainreba jubëte ëñajën, mësacua ira bain ba'isi'cuare ëñajënna, Abraham, Isaac, Jacob, si'a Riusu bain zoe re'huani raosi'cua ba'ijënna, mësacua yua ro hue'se ca'ncona jo'cani senjosi'cua ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja'nrëbi mësacuabi se'e ëñato, judío bain jubë ba'ima'icua'ga si'a ca'ncoñabi ti'an rani, Riusu ba'i jobona cacani ba'ija'cua'ë. Cacani, Riusu naconi te'e bëani, baguë guënamë re'oto aonre ainjën bojoja'cua'ë. Ja'nca ba'ijënna, hue'se ca'ncore nëcacuabi ai oireba oijën ëñaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ja'nca ëñaja'cua ba'ijënna, ën yija ba'icua quë'rë ta'yejeiye beoye ba'icua ba'ijënna, Riusubi bacuare ëñani, baguë bainre quë'rë ta'yejeiye ëjacuare re'huani baja'guë'bi. Yequëcua ën yijare ba'icua'ga quë'rë ta'yejeiye ba'icua ba'ijënna, Riusubi bacuare ëñani, quë'rë ta'yejeiye beoye ba'i hua'nare bacuare re'huani jo'caja'guë'bi, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Quëaguëna, ja'ansi umuguse fariseo bainbi ti'an rani, Jesusni quëahuë: —Achajë'ën. Herodesbi më'ëni huani senjojaza caguëna, besa gatini saijë'ën, quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Quëajënna, Jesús sehuobi: —Bañë. Mësacua yua ja'an ro ca huatina go'ini quëajaijë'ën: “Yë'ëbi yure umuguse, miato, ja'an umuguseñabi huati hua'ire etoni saoguë, bain hua'nare huachoguë ba'ija'guë'ë yë'ë. Ja'nrëbi que miato yë'ë yo'ore yo'oni tëjija'guë'ë yë'ë” ja'an cocare baguëni quëajaijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ja'nca quëajaijë'ën caguë, ja'an samute umuguseña yë'ë yo'ore yo'oguë, Jerusalenna ti'anja'guë'ë yë'ë. Ja'nca ti'anni, Riusu bain raosi'cua yua Jerusalén huë'e jobo se'gare ba'ijën, huani senjosi'cua ba'ijënna, yë'ë'ga ja'an huë'e jobona sani, güina'ru junni tonja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ja'an ba'ija'yete ro'taguë, Jerusalén huë'e jobo bain gu'aye yo'oyete ro'taguë, ai oireba oiyë yë'ë. Riusubi baguë bainre re'huani baguë coca quëani achocuare re'huani raoguëna, Jerusalén bainbi ro cue'yoni, bacuani huani senjoñu cajën, bacua gatabëanre inni, bacuani huani senjojën ba'icua'ë. Ja'nca yo'ojënna, bacuani ai zoe choini jëhuahuë yë'ë. Cura hua'gobi bago zin hua'nare choini, bago ganhua cabëan yijacuana jëoni guëoye'ru, yë'ë'ga ja'an bainni güina'ru cuirani baza caguë choiguëna, bacuabi ro cue'yoni yë'ëre gu'a güejën senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ja'nca senjojënna, bacuani ai bëinguë cani jo'cayë yë'ë. “Mësacua jubë si'acuare jo'cani senjoguëna, yë'ë bain ba'iye gare porema'ija'cua'ë. Yë'ë cuencuesi umuguse ti'añe tëca mësacua gare se'e yë'ëni ëñama'ija'cua'ë. Ja'an umuguse ti'anguëna, mësacuabi yë'ëre se'e ëñajën, yë'ë ta'yejeiye ba'iyete te'e ruiñe masijën, yë'ëre caja'cua'ë: Riusu Raosi'quëreba ba'iguëbi ti'an raiguëna, baguëni bojoreba bojojën cani achoja'ma, yë'ëre cajën ëñaja'cua'ë” caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Quëani ja'nrëbi, yequë umuguse yo'o yo'oma'i umuguse ba'iguëna, fariseo ëja bainguëbi baguëni aon choiguëna, baguë huë'ena sani ëñato, fariseo bain hua'nabi baguë yo'oja'yete ro yahue ëñañu cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yequë'ga baji'i. Rauna ju'inguë, ëntë sara ai ri'risi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ja'nca ba'iguëna, Jesusbi ja'an fariseo bain, ira coca cani jo'case'ere te'e ruiñe masicua, ja'an si'acuani senni achabi: —Mësacua ¿queaca ro'taye'ne? ¿Mai ira coca cani jo'case'e'ru yo'otoca, yo'o yo'oma'i umugusebi bainre huachoye poreye mai? senni achabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Senni achaguëna, ba hua'na yua ro sehuoye beoye achahuë. Ja'nca sehuomajënna, Jesús yua ju'in hua'guëna bonëni, baguëte huachoni saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Saoni ja'nrëbi, fariseo bainni cabi: —¡Mësacuabi yë'ë yure yo'ose'ere bëinjën ëñajën, ro gu'aye ro'tayë! Mësacua jo'ya hua'na, burro, toro, ja'an hua'na ba'iyete ro'tani, yë'ë re'oye yo'ose'ere masiye ro'tajën ba'ijë'ën. Mësacua jo'ya hua'guëbi yo'o yo'oma'i umugusebi gojena gurujani to'intoca, mësacua yua ja'ansirën baguëte conjën rutayë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Caguëna, ba hua'nabi achani, ro sehuoye poremajën, baguëni ro ëñajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja'nrëbi ja'an bain hua'nabi ti'anni, aon ainruna bëa bi'rajën, ëja bain ñu'i seihuëan se'gare ëñani bëahuë. Ja'nca ëñani bëajënna, Jesusbi bacuani yihuoguë quëabi: ");
INSERT INTO snnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mësacua yua huejaja'cua aon ainruna choisi'cua banica, quë'rë jëja bain ñu'i seihuëanre cu'ema'ijë'ën. Ja'anruna bëatoca, yequërë më'ë'ru quë'rë ta'yejeiye ëjaguëbi ti'anguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","huejaja'guëbi më'ëna ti'anni, më'ëni coca cama'iguë: “Ën ñu'i seihuë, ën ëjaguë ñu'i seihuë'ë” caguë ënsetoca, më'ë yua ro huaji yaye ba'iguëbi quë'rë yo'je ñu'i seihuëna bëaye bayë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ja'anre ro'tajë'ën. Huejaja'cua aon aiñe choisi'quë ba'itoca, quë'rë ta'yejeiye beo hua'na ñu'i seihuëna bëajë'ën. Ja'nca bëasi'quëreta'an, yequërë huejaja'guëbi rani, më'ëni cama'iguë: “Raijë'ën, ja'yë. Quë'rë ta'yejeiye ëja bainguë ñu'i seihuëna bëajë'ën.” Ja'anre catoca, yequëcua baruna choisi'cuabi më'ëni ai re'oye ëñañë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Më'ëbi yua quë'rë ta'yejeiye ëja bainguë runza caguë yo'otoca, ta'yejeiye beo hua'guëre re'huasi'quë ba'ija'guë'ë më'ë. Më'ëbi yua ta'yejeiye beo hua'guë runza caguë yo'otoca, ai ta'yejeiye ëjaguëre re'huasi'quë ba'ija'guë'ë më'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cani ja'nrëbi, ja'an aon choisi'quëna bonëni cabi: —Më'ëbi aon re'huani bainre choi bi'raguë, më'ë bain hua'na, më'ë gaje hua'na, yequëcua bonse ëjacua, ja'ancuare choima'ijë'ën. Choiguëna, bacua'ga aon re'huani, më'ëre'ga güina'ru aon choija'cua'ë. Ja'nca më'ëre choijën, më'ë aon re'huani choise'ere güina'ru go'yaja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ja'nca sëani, më'ëbi aon re'huani bainre choi bi'raguë, bonse beocua, guëon garasi'cua, ca'jacua, ñaco ëñama'icua, ja'ancuare aon choijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ja'nca choitoca, Riusubi më'ëna ta'yejeiye ai insireba insija'guë'bi. Bacuabi më'ëni sa'ñejën choiye porema'icua sëani, Riusu bainreba go'ya rai umuguse ti'anguëna, më'ëbi bacua naconi Riusu ba'i jobona sani ba'iguëna, Riusubi baguë ba'iyete më'ëna ta'yejeiye ai insireba insija'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Caguëna, yequëbi mesa ca'ncore ñu'iguëbi Jesusni cabi: Riusu bainreba baguë naconi te'e zi'inni aon ainjën ba'icua, ja'ancuabi ai bojoreba bojojën ba'ija'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Caguëna, Jesusbi baguëni cabi: —Yë'ëbi ye'yo cocare caguëna, achajë'ën. Yequë ëja bainguë baquëña. Ai re'o aonre re'huani, ai jai jubë bainni choquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Choni ja'nrëbi, aonre re'huani tëjini, baguëre yo'o con hua'guëni guanseguëña: “Yë'ë bain choisi'cuana sani quëajaijë'ën. Yua'ë. Mësacua raijë'ën. Aonre re'huani tëjihuë quëajaijë'ën” caguë guanseni saoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Saoguëna, yo'o con hua'guëbi sani quëaguëna, si'a hua'na te'ena, te'ena, “Aon ainguë saiye porema'iñë yë'ë. Yequë umuguse conja'guë'ë yë'ë” ca bi'rareña. Yequëbi “Mame zio yijare yure cohuë yë'ë. Ja'an yijana sani ëñañe bayë. Aon aiñe conguë saiye porema'iñë yë'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yequë'ga “Toro hua'na si'a saracuare yure cohuë yë'ë. Bacua rërëye poreyete masiye bayë yë'ë. Ja'an yo'oja'guë sëani, conguë saiye porema'iñë yë'ë” sehuoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yequë'ga “Yureta'an romi hua'goni huejani bayë yë'ë. Më'ë ëjaguëre aon aiñe coñe porema'iñë” sehuoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ja'nca sehuojënna, yo'o con hua'guëbi go'ini, baguë ëjaguëni quëaguëña. Quëaguëna, ëjaguëbi ai bëinreba bëinguë, baguëre yo'o con hua'guëni caguëña: “Ja'nca raiye güesi'cua sëani, si'a huë'e jobona sani, bonse beo hua'na, guëon garasi hua'na, ca'ja hua'na, ñaco ëñama'i hua'na, ja'an hua'nani choijani rajë'ën” guanseguë caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Caguëna, yo'o con hua'guëbi choijani rani, baguë ëjaguëni quëaguëña: “Bainre choni rahuë, ëjaguë. Bacuare rani bëa güeseguëna, yequëcua raitoca, bëani aon aiñe ti'anji” quëaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Quëaguëna, ëjaguëbi caguëña: “Ja'nca ba'itoca, huë'e jobo ca'ncoña ma'añaja'an saiguë, si'a hua'na so'o ba'icuani choijani rajë'ën. Yë'ë aon ain huë'e bu'iye tëca ja'an bainni bëa güesejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yë'ë bain ru'ru choisi'cuabi cue'yoni saisi'cua sëani, yë'ë aonre conni aiñe gare porema'ija'cua'ë” bëinguë caguëña, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yureca quë'rë jai jubëan bainbi Jesusni conñu cajën, baguëni be'tejaijënna, Jesusbi bacuana bonëni quëabi: ");
INSERT INTO snnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mësacua yua yë'ëre yo'o concua ba'iye yënica, mësacua yo'ojën ba'iye si'aye gare jo'cajë'ën. Pë'caguë, pë'cago, rënjo hua'go, zin hua'na, ma'yë hua'na, yo'je hua'na, mësacua bain si'acuare ta'yejeiye ëñamajën, yë'ëre con raijë'ën. Mësacua yëse'e'ga gare se'e yo'oye ro'tamajën, yë'ë yëye se'gare yo'ojën ba'ijë'ën. Ja'nca yo'oma'itoca, yë'ëre yo'o con hua'na ba'iye gare porema'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yë'ë ai yo'oguë ba'iye'ru güina'ru ai yo'oye yëmanica, yë'ëni con raima'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jai huë'ere yo'oja'guëni ro'tani ye'yejë'ën. Jai huë'ere yo'oza caguëbi ru'ru ¿Guebi ro'ija'guë'ne yë'ë? caguë, ja'an ro'ija'yete si'aye cuencueni masini, ja'nrëbi huë'ere yo'o bi'raguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ja'an ro'ija'yete cuencuemani'ga huë'ere ro ro'taguë yo'o bi'rani, ja'nrëbi se'nquehuë se'gare yo'oni, curi carajeiguëna, baguë bainbi ti'anni, ja'an huë'e tëjima'ise'ere ëñani, baguëre ai jayajën caja'cuayeña: ");
INSERT INTO snnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ja'anguëbi jai huë'ere yo'oza casi'quëta'an, yo'oni tëjiye ti'anmaji'i” jayajën caja'cuayeña. ");
INSERT INTO snnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bain ta'yejeiye ëjaguë guerra huaja'yete ro'taguëna, mësacua achani ye'yejë'ën. Yequë ëjaguëbi je'o baguë, veinte mil soldado hua'na naconi ti'an rai bi'raguëna, baguë jëja bayete cuencueni ro'taguëña baguë. Baguë soldado hua'na naconi, diez mil ba'icua naconi quë'rë ta'yejeiye guerra huani, je'o baguëni saoni senjoñe porema'itoca, ");
INSERT INTO snnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","je'o baguëbi yuta so'o ba'iguëna, baguëni coca saoguë, Huaye beoye ba'ina'a. ¿Guere më'ëna insiye'ne yë'ë? senni achaguë saoja'guëguëña baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mësacua yua ja'anre ro'tajën, mësacua yo'o conja'ñete re'oye ro'tajë'ën. Yë'ëni yo'o coñe yëtoca, ru'ru mësacua baye si'ayete gare jo'cani, yë'ë yëyete yo'ojën ba'ijë'ën. Ja'nca yo'oye yëma'itoca, yë'ëni yo'o coñe gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mësacua yua yë'ë bain ba'iye yënica, mësacua onhua ba'iye'ru ëñani ye'yejë'ën. Re'o onhua ba'iguëna, ai re'o huanoji maire. Re'o huanoñe carajeitoca, re'o onhua ba'iye gare se'e re'huaye porema'iñë mai. ");
INSERT INTO snnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gu'a onhua ba'itoca, yija tanse'ena pë'npëni, ja'anruna tanni, re'oye iroye porema'iñë. Abono pëbë naconi ja'metoca, gu'aji. Ja'an gu'a onhuare senjoñe se'ga ba'iji. Mësacua yua ganjo banica, achani ye'yejë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Caguëna, ja'nrëbi impuesto curi cocua, gu'a bain, ja'an si'acuabi Jesusna ti'anni, Baguë coca caguëna achani masiñu cajënna, ");
INSERT INTO snnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","fariseo bain, ira coca cani jo'case'ere masicuabi Jesusre ai bëinjën cahuë: —Gu'a bainbi raijënna, baguë yua ro bacuani bojoguë, bacua naconi te'e aon ain'te, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ja'nca cajënna, Jesusbi ye'yo cocare bacuani quëabi: ");
INSERT INTO snnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mësacua yua oveja jo'ya hua'na cuiraguë yo'ose'ere achani ye'yejë'ën. Cien oveja hua'nare baguëna, te'eguëbi quëñëni sani huesëtoca, ¿guere yo'oja'guë'ne baguë? Mësacua yua masiyë. Baguë jubë ba'icua, noventa y nueve ba'icuare bacua aon ain yijana jo'cani, huesësi'quëni oiguë, baguëni cu'ejaquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cu'ejani, tinjani ëñani, ai ëama'iñereba bojoguëña. Ja'nca bojoguëbi baguë oveja hua'guëre zeanni, baguë tanta cubëna tëoni, hue'oni, ");
INSERT INTO snnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","baguë huë'ena ti'anni, baguë gaje bainre choini quëaguëña: “Yë'ë naconi te'e bojojën ba'ijë'ën. Yë'ë oveja hua'guëbi sani huesësi'quëreta'an ba'iguëna, baguëre tinjani rahuë yë'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ja'nca bojoguë caguëna, Riusu guënamë re'oto ba'icuabi gu'a jucha yo'osi'quë mame recoyo re'huase'ere ëñani, güina'ru ai bojojën ba'iyë. Te'e gu'aye yo'osi'quë se'gabi mame recoyo re'huaguëna, bacuabi ja'an hua'guëre ëñani, noventa y nueve re'o bainni bojoye'ru baguëni quë'rë ta'yejeiye ai bojoreba bojojën ba'iyë. Ja'an re'o bain cacuabi “Gu'a jucha yo'oma'isi'quë'ë yë'ë. ¿Queaca yo'oguë, mame recoyo re'huaye'ne yë'ë?” ja'an cacua ba'ijënna, bacuare ta'yejeiye bojoma'iñë Riusu guënamë re'oto ba'icua. ");
INSERT INTO snnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Romi hua'go curi so'corë huesosi'core'ga achani ye'yejë'ën. Ba hua'gobi si'a sara so'corëanre bani, te'e so'corëte huesogoña. ¿Ja'nca huesoni, guere yo'ogo'ne? Mësacua yua masiyë. Majahuëte zëonni, bago huë'ere yuago, ba so'corë tinjañe tëca si'a ca'ncoña ëñago cu'ego yuagoña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja'nca yuani tinjani, ai bojo hua'gobi si'a bago gaje bainre choini quëagoña: “Yë'ë naconi te'e bojojën ba'ijë'ën. Yë'ë curi so'corë huesësi'quëreta'an ba'iguëna, tinjani bayë yë'ë” cago bojogoña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ja'nca bojogo cagona, Riusu guënamë re'oto yo'o con hua'na'ga gu'a jucha yo'osi'quë mame recoyo re'huase'ere ëñani, güina'ru ai bojojën ba'iyë. Te'e gu'aye yo'osi'quë se'gabi mame recoyo re'huaguëna, bacuabi ai ta'yejeiye bojoreba bojojën ba'iyë, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ja'an ye'yo cocare cani, ën cocare'ga ye'yoguë cabi Jesús: —Yequë bainguëbi samu mamacuare baguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ja'nca baguëna, ba yo'jeguëbi caguëña: “Taita, yë'ëre insija'yete si'aye cuencueni te'e jëana yë'ëna insijë'ën” caguëña. Caguëna, pë'caguëbi si'aye cuencueni, baguë samu mamacua si'acuana huo'hueni insiguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Insiguëna, yequë umuguseña ba'iguëna, ba yo'jeguëbi baguë baye si'ayete re'huani, ja'nrëbi so'o yijana saquëña. Sani ba'iguëbi baguë curi carajeiye tëca ro a'ta gu'aye yo'oguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ja'nca curi si'aguëna, ja'an yija aon carajei bi'raguëna, ba hua'guë yua aon gu'ana ju'in bi'raguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ju'in bi'raguëbi ja'an yija ëjaguëna sani, baguëni yo'o yo'oye senquëña. Senguëna, baguë cuchi hua'nare cuiraye saoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Saoguëna, cuiraguë ba'iguëbi cuchi aon, aon hui'ya ga'ni, ja'anre ainja'ma caguëreta'an, ja'anru bainbi baguëna gare insimateña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Insimatena, ba hua'guë ja'ansi'quë ro'taguëña: “Ai yo'oyë yë'ë hua'guë. Yë'ë taita yo'o con hua'nabi ai aonre anni jëhuajënna, yë'ë hua'guë ro aon gu'ana ju'iñë. ");
INSERT INTO snnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ja'nca ju'inguë, yë'ë taitana go'ini, baguëni caja'guë'ë yë'ë: Taita, Riusure, më'ëre ai gu'aye yo'ohuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Më'ë zin beoguë'ru huë'ena ti'anhuë yë'ë. Ro më'ë yo'o con hua'guëre re'huani yë'ëni bajë'ën, taitani caja'guë'ë yë'ë” ro'taguë ñuquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ja'nca ro'tani, baguë yua huëni, pë'caguë huë'ena go'i bi'raguëña. Go'i bi'rani, yuta so'orë raiguëna, pë'caguëbi baguëni ëñaguëña. Ëñani, baguëni recoyo ai oire baguë, yua baguëna huë'huëni tëhuojaquëña. Tëhuojani, baguëre su'ncareba su'ncani muchaguë bojoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja'nca bojoguëna, mamaquëbi caguëña: “Taita, Riusure, më'ëre, ai gu'aye yo'ohuë yë'ë. Më'ë zin beoguë'ru huë'ena ti'anhuë yë'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Caguëna, pë'caguëbi baguëre yo'o con hua'nare choini, bacuani guanseguë caguëña: “Besa, re'o canre inni, baguëni sa'yejë'ën. Sutijei ga'huare inni, baguë mëoñona jëojë'ën. Guëon ju'i corore inni, baguëni sa'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ja'nrëbi ja'an toro bonsëguë jujusi'quëre zeanni huaijë'ën. Ai re'o aonre re'huani te'e ainjën bojoñuni. ");
INSERT INTO snnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yë'ë mamaquë junni senjose'e'ru ba'iguëbi go'ya raji'i. Sani huesësi'quëbi maina ti'an raji'i” caguë bojoguëña. Ja'nrëbi si'a hua'nabi aonre re'huani, sa'ñeña bojo bi'rareña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ja'nca bojojënna, yequë mamaquë ma'yë ba'iguëbi ziona saisi'quëbi huë'ena goquëña. Go'ini, huë'ena ti'anni achato, bain hua'nabi música huaijën, pairajën bojoreña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ja'nca yo'ojënna, ba hua'guë yua yo'o con hua'guëre choini, “¿Guere bojoye'ne raijeiye?” senni achaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Senni achaguëna, “Më'ë yo'jeguëbi ti'anguëna, ëjaguëbi toro bonsëguëre huani ainguë bojo güeseguëña, huajëguë ti'anse'ere bojoguë sëani” sehuoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sehuoguëna, ba ma'yëbi bëinreba bënquëña. Huë'e cacaye güeguëña. Güeguëna, pë'caguëbi etani, baguëni “Cacani bojoguë rani te'e conjë'ën” caguë, baguëni senreba senquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Senguëna, sehuoguëña baguë: “Bañë. Ai zoe ba'irën më'ë naconi ai jëja yo'o yo'oguë ba'iguë, më'ë yo'ore guanseguëna, gare go'iye sehuoma'iguë baë'ë yë'ë. Ja'nca ba'iguë, yë'ë gaje hua'na naconi ñë'cani te'e bojoza caguëreta'an, ro chivo bonsëguë se'gare yë'ëna gue insiye beoye baë'ë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ja'an hua'guë'ga, më'ë mamaquë caguë, më'ë baye beoru ro coni sani, ro a'ta yo'oni, gu'a romi hua'nana ro insini senjosi'quë'bi. Ja'nca yo'oni se'e raquëna, më'ë yua ja'an toro bonsëguë jujusi'quëre ro huaicaë'ë baguëre” bëinguë caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Caguëna, pë'caguëbi sehuoguëña: “Mami, yë'ë naconi si'arën ba'iyë më'ë. Yë'ë bayere'ga më'ë'ga te'e bayë. ");
INSERT INTO snnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ja'nca masiguëta'an, yureña re'o aonre re'huani sa'ñeña te'e bojoñu cajën, tin yo'oye porema'iñë mai. Më'ë yo'jeguë junni senjose'e'ru ba'iguëbi go'ya raji'i. Huesësi'quë ba'iguëbi yua huajë hua'guë maina ti'an raji'i” caguë sehuoguëña. Ja'an ye'yo cocare fariseo bainni quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ja'nrëbi, Jesús yua baguëre yo'o con hua'nani ye'yo cocare yihuoguë cabi: —Yequë ëjaguë ta'yejeiye bonse ëjaguë baquëña. Ja'nca ba'iguëbi yequëre baguë bonse re'huaguëte cuencueni baguëña. Baguëna, baguë bainbi baguëna ti'an rani quëareña: “Më'ë bonse re'huaguëbi më'ë curi carajeiye tëca ro insini senjoji” quëareña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Quëarena, ba hua'guëre choini, baguëni bëinguë senni achaguëña: “Më'ë ¿guere yo'oguë, yë'ë bonsere te'e ruiñe re'huama'iguë'ne? Yureca yë'ë bonse re'huase'e, më'ë yo'ose'e beoru cuencueni toyani, yë'ëna rani ëñojë'ën. Yë'ë bonsere quë'rë se'e re'huaye porema'iñë më'ë. Më'ëre gare etoza caguë yo'oyë yë'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ja'nca caguëna, ba hua'guëbi ja'ansi'quë ro'taguëña: “Yë'ë ëjaguëbi yë'ëre gare etotoca, ¿yë'ë guere yo'oye'ne? Yijana no'añe, ja'an yo'o yo'oye jëja beoyë yë'ë. Yequëcuani curi señe huaji yaye'ë yë'ëre. ");
INSERT INTO snnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yua yë'ë yo'oja'yete ro'tahuë. Yë'ë ëjaguëni ro'ija'cuare yë'ë gaje hua'nare re'huaza cayë yë'ë. Ja'nca re'huani, ëjaguëbi yë'ëre etoguëna, yë'ë yua bacua huë'ena ti'anguëna, yë'ëre bëa güeseja'cua'ë” ro'taguëña baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ja'nca ro'tani, ja'nrëbi baguë ëjaguëni ro'ija'cuare te'enate, te'enate choi bi'raguëña. Choni, ru'ru ba'iguëbi ti'anguëna, “¿Yë'ë ëjaguëni quejeiye ro'iye baguë'ne më'ë?” senni achaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Senni achaguëna, sehuoguëña: “Olivo hui'yabe cien ro'rohuëanre ro'iye bayë yë'ë” sehuoguëña. Sehuoguëna, “Më'ë ro'iye cuencuesi ja'ohuare inni, besa cincuenta ro'rohuëan ro'iye toyajë'ën” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cani tonni, ja'nrëbi yequëbi ti'anguëna, “Yë'ë ëjaguëni ¿quejeiye ro'iye baguë'ne më'ë?” senni achaguëña. Senni achaguëna, “Trigo aon cien ro'rohuëan ro'iye bayë yë'ë” sehuoguëña. Sehuoguëna, “Më'ë ro'iye cuencuesi ja'ohuare inni, ochenta ro'rohuëan ro'iye toyajë'ën” caguëña. Bacua ro'ija'yete gachoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gachoguëna, ja'nrëbi baguë ëjaguëbi ja'an cuencuesi ja'orëanre ëñani ro'tani, ja'ansi'quë caguëña: “Ai masiye coquebi yë'ëre” caguëña. Aito. Ën yijare ba'iye ye'yesi'cuabi yua Riusu bainreba ba'iye'ru quë'rë ta'yejeiye masiye ro'tani yo'ocua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ja'nca masiye yo'ocua ba'ijënna, bacua ba'iyete ro'tajën, mësacua'ga ën yija bonsere bajën, ën yija gaje bainre re'huañu cajën, ja'an bonsere bacuana huo'huejën ro insijën ba'ijë'ën. Ja'nca ro insijën ba'icuabi ën yija bonse carajeiyete ëñani, Riusu guënamë re'totona ti'anni ëñato, ai bain gajecuabi mësacuani bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mësacua'ga rëño bonse ma'carëan se'ga bajën te'e ruiñe yo'ojën banica, ai bonsere bani'ga, güina'ru te'e ruiñe yo'oja'cua'ë. Rëño bonse ma'carëan bajën, coquejën yo'ojën banica, ai bonse bani'ga güina'ru coquejën yo'oja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mësacua'ga ën yija bonsere bajën, te'e ruiñe yo'oma'itoca, Riusubi baguë guënamë baye ¿queaca mësacuana jo'caja'guëguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yequëcua bonsere re'huacaijën, te'e ruiñe yo'oma'itoca, Riusubi baguë guënamë bayete mësacuana gare jo'caye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yo'o con hua'guëbi samu ëjacuani bani, bacuani te'e coñe gare porema'iji. Ja'nca contoca, yequëni je'o baguë, yequëni ai yëreba yëji. Yequëni te'e ruiñe yo'o conguë, yequëni yo'o coñe güeji. Güina'ru, Riusuni yëreba yëjën coñe yënica, mësacua bonsere te'e yëye gare porema'iñë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Caguëna, fariseo bainbi Jesús quëase'e si'aye achani, bonsere baye ai yëcua sëani, baguëni ai jayajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jayajën cajënna, Jesús sehuobi: —Mësacua yua ëmëje'en ca'nco se'gare re'o bain ba'iye ro coquejën ëñojënna, bain hua'nabi mësacuare re'oye ëñajën bojoyë. Riusu'ga mësacuare re'oye ëñama'iji. Mësacua gu'a recoyore ëñani, mësacua gu'aye yo'ojën ba'iyete masiji. Bain hua'nabi yequëcua ta'yejeiye ba'iye'ru ba'iyete re'oye ëñani bojojënna, Riusu'ga tin ro'taguë, ja'an bojoma'iji. Gu'aye se'ga ba'iji caji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ru'ru, Moisesbi Riusu ira coca cani jo'case'ere bainna toyani jo'caguëna, ja'nrëbi jë'te, Riusu ira bain raosi'cuabi coca toyani jo'cajënna, bain hua'nabi si'aye achani ye'yesi'cua baë'ë. Juan Bautizaguë ba'irën tëca achani ye'yesi'cua ba'ijënna, ja'nrëbi Riusubi baguë bojo güese coca, mame recoyo re'huani baguëna zi'inni bojojën ba'i coca ja'an cocare cani acho bi'raguëna, si'a bainbi Riusuna ti'anni recoyo zi'inni ba'iñu cajën, baguë cocare si'a recoyo achani yo'o bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ja'nca ba'icuata'an, Riusu ira coca cani jo'case'ere gare carajei güeseye beoye jo'cabi Riusu. Guënamë re'oto, yija re'oto, ja'anbi ru'ru carajeija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bainguëbi baguë rënjo hua'gore jo'cani senjoni, ja'nrëbi yeconi huejani batoca, ro gu'aye yo'oye se'ga rëinji baguëre. Romigo jo'cani senjosi'coni huejani batoca, güina'ru ro gu'aye yo'oye se'ga rëinji. ");
INSERT INTO snnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mësacua yua ën cocare achani, Riusu yo'oguë ba'ija'yete masijë'ën. Yequë bonse ëjaguë baquëña. Si'a umuguseña ai re'o caña me'najei cañare sa'yeguë, ai re'o aon se'gare caraye beoye ainguë bojoguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yequë'ga Lázaro hue'eguëbi bonse beo hua'guë si'a ga'nihuë ca'mi bu'isi'quë ba'iguë, yequëcuabi cuanni rajënna, bonse ëjaguë caca sa'ro ca'ncona bëani ëjoguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ëja bainguë aon zi'nga mesabi to'inguëna, porenica ja'anre coni anza caguë ro'taguë ñu'iguëna, yai hua'na'ga rani, baguë ca'mire ne'nejën bateña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ja'nca ba'iguëbi ai yo'oguë, yequë umuguse junni huesëguëna, Riusu guënamë re'oto yo'o con hua'nabi gaje meni, baguëte cuanni, Riusu guënamë re'otona mëani, Riusu aon choisiruna bëa güesereña, Taita Abraham ca'ncona. Ja'nrëbi bonse ëjaguë'ga junni huesëguëna, baguë bainbi baguëte tanreña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tanrena, ba hua'guë yua ja'an gu'aruna ti'anni, ai ja'sireba uguë baguëña. Ja'nca ba'iguëbi mëiñe ëñato, Taita Abraham baquëña. Lázaro'ga baguë ca'ncore ñuquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ja'nca ñu'ijën ba'ijënna, bonse ëjaguëbi güiguë caguëña: “Taita Abraham, yë'ë hua'guëre oire bajë'ën. Ën toare ai ja'sireba uguëna, Lázarote yë'ëna raojë'ën. Baguë mëoñobi yua ocona tanni, yë'ë zemeñona ti'ntini sësaye se'ga yo'oja'guë” güiguë caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Caguëna, Abrahambi sehuoguëña: “Më'ë yija ba'iguë ba'ise'ere ro'tajë'ën, mami. Më'ëbi ai re'oye ba'isi'quëbi me'najeiñe se'ga ba'iguëna, Lázarobi ai yo'oguë ba'isi hua'guëbi baji'i. Yureca, Riusubi baguëni oire bani conni bojo güeseguëna, më'ëreca uye se'ga ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mai sa'ñeña ëñañe ai rëi yorobë ba'iguëna, më'ë ba'iruna saiye beoji ënjo'onbi. Güina'ru, më'ë ba'irubi etani ënjo'ona raiye gare porema'iñë” sehuoguëña Abraham. ");
INSERT INTO snnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sehuoguëna, bonse ëjaguë ba'isi'quëbi caguëña: “Ja'nca porema'itoca, ën cocare më'ëni senreba señë yë'ë. Lázarote cuencueni, yë'ë bain huë'ena saojë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yë'ë yo'je hua'na te'e ëntë sara hua'na ba'ijënna, bacuana sani, bacua gu'a juchare jo'cani senjojë'ën caguë quëaja'guë. Yë'ë ai yo'oguë ba'i re'otona raima'ija'bë caguë, bacuani coca yihuoguëte saojë'ën, taita” caguë senquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Senguëna, Abraham sehuoguëña: “Saoye porema'iñë. Më'ë bainbi Riusu coca, Moisés toyani jo'case'e, Riusu ira raosi'cua toyani jo'case'e, ja'an cocare bacua sëani, ja'an cocare ëñajën ye'yeja'bë. Ye'yetoca, bacua gu'a juchare jo'cani senjoma'iñe yequërë” caguë sehuoguëña Abraham. ");
INSERT INTO snnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sehuoguëna, baguë caguëña: “Bañë. Ira coca case'ere achama'iñë, taita. Ju'insi'quëbi etani sani, bacuani quëatoca, bacuabi achani mame recoyo re'huaja'cua'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Caguëna, Abraham sehuoguëña: “Bañë. Moisés coca toyani jo'case'e, Riusu ira raosi'cua toyani jo'case'e, ja'anre ro achajën, te'e ruiñe yo'oye güetoca, ju'insi'quë etani sani quëaye'ga güina'ru ro achajën te'e ruiñe yo'oye güeja'cua'ë bacua” sehuoguë, baguëni coca cani tonguëña Abraham, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ja'nca cani, ja'nrëbi baguëre yo'o con hua'nani yihuoguë cabi: —Bain hua'nabi yequëcuani gu'a jucha yo'o güesejën, gare carajeiye beoye gu'aye yo'ojën ba'icua'ë. Ja'nca ba'icuabi bënni senjoja'ñe se'ga ba'iji bacuare. ");
INSERT INTO snnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ëncua zin hua'nani iracuabi te'eguë se'gani gu'aye yo'oye ye'yoto, bacuare quë'rë ta'yejeiye bënni senjose'e ba'ija'guë'bi. Jai to'obëbi bacua ñaje tëcana gueonni, jai ziayana senjoni rëoto'ga, bacuare bënni senjoñe ti'anma'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ja'nca sëani, mësacua'ga ëñare bajën, gare gu'aye yo'oye beoye ba'ijë'ën. Yureca më'ë yo'je hua'guëbi më'ëni gu'aye yo'otoca, baguëni bojora'rë bëin coca yihuoguë cajë'ën. Ja'nca caguëna, baguëbi mame recoyo re'huani, baguë gu'a jucha yo'ose'ere jo'cani, më'ë huanë yeni ro'tama'iñete sentoca, baguë gu'a juchare huanë yeni baguëni te'e bojoguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ja'ansi umuguse te'e ëntë sara samu ba'iye më'ëni gu'aye yo'oni, ja'nrëbi më'ëni senni achaguë, Gu'aye yo'ohuë yë'ë. Se'e ro'tama'ijë'ën quëani sentoca, baguë gu'a jucha yo'ose'ere caraye beoye huanë yeyete sehuoni re'huani, baguëni bojoguë ba'ijë'ën, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Caguëna, ja'nrëbi baguëre ta'yejeiye yo'o concuabi baguëna ti'an rani, baguëni senni achahuë: —Yëquënani quë'rë ta'yejeiye recoyo ro'taye conjë'ën, sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Senjënna, sehuobi: —Recoyo ta'yejeiye ro'taye yëtoca, mostazara'carëte ro'tani masijë'ën. Ai zinra'carëte sëani, ta'yejeiye irani, jai sunquiñë ruinji. Mësacua'ga güina'ru ta'yejeiye recoyo ro'tajën ba'itoca, ai ta'yejeiye yo'oye porëyë mësacua. Ën sunquiñë sicómoroñëna coca cani guanseye poreyë: “Ja'ansi sunquiñë si'a seihuë tëtëni, huëni, jai ziayana sani tonni ruijë'ën” ja'an cocare cani guansetoca, bañë se'gabi achani ja'anse'e yo'oji. ");
INSERT INTO snnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mësacua yua yo'o con hua'na yo'oye bayete ro'tani masijë'ën. Ëja bainguëre yo'o con hua'guëbi baguë yo'ore yo'oguë, zio yijare re'huani, oveja jo'yare cuirani, ja'an yo'ore yo'oni na'ijani, ja'nrëbi huë'ena go'ini ba'iguëna, ba ëjaguë ¿gue coca baguëre caguë'ne? “¿Besa rani, më'ë aonre ainjë'ën” caguë? ");
INSERT INTO snnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Banji. “Besa, yë'ë aonre re'huani, yë'ëre aonjë'ën. Yë'ë aonre ainguë, yë'ë gonore uncuguë ba'iguëna, më'ë yua yë'ë yëyete injani rani insijë'ën. Yë'ë aon anni tëjiguëna, ja'nrëbi yo'je, më'ëbi aiñe poreyë” ja'anre guanseguë caji ëja bainguë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ëja bainguëbi guanseguëna, yo'o con hua'guëbi si'aye te'e ruiñe yo'oni tëjiguëna, ëjaguëbi ¿guere caguë'ne? “Surupa. Ai re'oye yo'ohuë më'ë” gare caye beoye ba'iji bain ëjaguë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ja'nca ba'iguëna, mësacua'ga Riusu yo'ore yo'o conjën, si'aye yo'oni tëjini, ñaca cajën ba'ijë'ën: “Yëquëna hua'nare yua Riusu yo'o con hua'na se'ga ba'ijën, gare ta'yejeiye beoye ba'icua'ë” cajën ba'ijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ja'nrëbi Jesusbi se'e sai bi'raguë, Samaria, Galilea, ja'an yijañabi saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sani, yequë huë'e jo'borëna ti'anni ëñato, ira ca'mi rauna ju'incua si'a saracuabi baguëna tëhuo raë'ë. Tëhuo rani, so'orëbi ëñajën, ");
INSERT INTO snnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","baguëni si'a jëja güijën cahuë: —Ëjaguë Jesús, yëquënani oireba oiguë conjë'ën güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja'nca cajënna, Jesusbi sehuobi: —Mësacua yua pairi hua'na quë'rona sani, pairini ëñojë'ën, caguë sehuobi Jesús. Sehuoguëna, bacuabi sai bi'rajën, ma'aja'an saijën, ëñatoca, yua ja'si tënosi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tënosi'cua ba'ijënna, bacua jubë te'eguëbi Jesusna bonëni raiguë, Riusuni ta'yejeiyereba bojoguë güiguë quëaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ja'nca quëaguë ba'iguë, Jesús ba'iruna ti'anni, baguë guëon na'mi ca'ncona gugurini, meñe rëanni Jesusni bojoguë, Surupa caguë baji'i. Ja'an ba'iguëbi Samaria yija bainguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja'nca bojoguë caguëna, Jesús yua bain jubëni cabi: —Ira ca'mi rauna ju'incua si'a saracua ba'icuani huachohuë yë'ë. ¿Yequëcua nuevecua guere yo'ojën surupa cajën raimate'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ën hua'guë se'ga, tin yija bainguë ba'iguëbi Riusuni surupa caguë, Riusuni bojoguë raji'i. Yequëcua'ga raimaë'ë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cani, ja'nrëbi huachosi'quëni cabi: —Yua huëni saijë'ën. Më'ëbi yë'ëni si'a recoyo ro'tasi'quë sëani, huajë raisi'quë'ë më'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Caguëna, fariseo bainbi baguëna ti'anni, baguëni senni achahuë: —Riusu bainreba mame re'huani baja'ye ¿quejeito ti'anguë'ne? senni achahuë. Senni achajënna, Jesús sehuobi: —Ja'anrën ti'anguëna, bain hua'nabi ëñañe porema'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja'anrën ti'anguëna, bain hua'nabi Riusu ba'iyete recoyo huanoñe ba'ija'cua'ë. Ja'nca sëani, yequëcuabi ro ro'tajën, “Ënjo'ona ti'anni ba'iji Riusu” cajën, o “Ja'anruna ti'anni ba'iji Riusu” cajën, ja'an cocare caja'cuabi ro huacha caja'cua'ë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ja'nca sehuoni ja'nrëbi, baguëre yo'o concuani yihuoguë quëabi: —Mësacua yua yë'ë, Riusu Raosi'quëreba ba'iguë, yë'ë gaje rairënre ëñajën ëjojën, ja'an umuguse raija'yete ai cu'e ëaye ba'ija'cuareta'an, yë'ë ti'an raiye yuta caraguë ba'ija'guë'bi mësacuare. ");
INSERT INTO snnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ja'nca ba'iguëna, yequëcuabi rani, mësacuani coquejën caja'cua'ë: “Riusu Raosi'quëbi ti'anbi. Ënjo'on ba'iji” catoca, o “Ja'anruna sani ëñañu” catoca, mësacua yua gare achamajën, bacua cayete yo'omajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yë'ë yua Riusu Raosi'quëreba ba'iguëbi ti'an rai bi'raguë, te'e jëana gaje raiguëna, si'a bainbi ëñañe poreja'cua'ë. Mëjo jue'neni si'a guënamë re'oto miañete ro'tani, yë'ë ti'an raija'yete masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ja'nca ti'an raija'guë'ga yureca ta'yejeiye ai yo'oguë ba'ija'guë'ë yë'ë. Yureña bainbi yë'ëre gu'a güejën senjojënna, ai yo'oguë ba'ija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yureca, yë'ë ti'an rai umuguse yua Noé ba'isi umuguseña'ru güina'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bain hua'nabi bacua aonre ainjën, bacua gonore uncujën, romi huejajën, ro bacua yëse'e yo'ojënna, ja'nrëbi Noé yoguna cacajën ba'i umuguse te'e jëana ti'anbi. Cacani ba'iguëna, ja'nrëbi ziaya co'je raguëna, ja'an bain hua'na si'a hua'nabi rucani carajaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yë'ë ti'an rai umuguse ba'ija'yete masiye yënica, Lot ba'isi umuguseñare'ga ro'tajë'ën. Ja'anrën bain'ga bacua aonre ainjën, bacua gonore uncujën, bonsere coni bajën, bonsere bendiejën, bacua zioñare tanjën, bacua huë'eñare yo'ojën, ro bacua yëse'e yo'ojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yo'ojën ba'ijënna, Lotbi Sodoma huë'e jobobi gare saiguëna, ja'ansi umuguse Riusu toabi bacuana joë ba'irënbi tonni ëobi. Toa zi'nga, toa gata, ju'ju sëñe ba'iguë guënamë re'otobi ai ja'suye tonni, si'a bainre joë ba'irën gare carajei güesebi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja'nca ba'iguëna, yë'ë'ga bainna ti'an rai bi'raguë, güina'ru joë ba'irën ti'anja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ja'nca ti'an raiguëna, huë'e hue'se ca'ncore ñu'ijën ba'icua'ga bacua bonsere cacani inma'ija'bë. Ziore ba'icua'ga güina'ru huë'ena go'ima'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot rënjo yo'ogo ba'ise'ere ro'tani, bago yo'ose'ere yo'oma'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mësacua se'gabi re'oye baza cajën ro'tajën ba'icua'ga ro huesëni carajeija'cua'ë. Mësacua ba'iyete ro'tamajën, Riusuni coñe se'gare yo'oza cajën ro'tajën ba'icuabi gare carajeiye beoye ba'ija'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yë'ë ti'an rai umugusere cato, ja'ansi ñami samucuabi te'e camana cainjën ba'ijënna, te'eguëte in rani saja'guë'ë yë'ë. Yequëre jo'caja'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Romi hua'na samucuabi te'erute ba'ijën hueare toajënna, te'egore in rani saja'guë'ë. Yecore jo'caja'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ëmëcua samucuabi ziore ba'ijën te'e yo'ore yo'ojënna, te'eguëre in rani saja'guë'ë. Yequëre jo'caja'guë'ë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Quëaguëna, bacuabi achani, baguëni senni achahuë: —¿Ja'an ba'ija'yete cato jarona ti'anja'guë'ne më'ë, Ëjaguë? senni achahuë. Senni achajënna, sehuobi: —Huayo hua'na ñë'ca raiye'ru ba'ija'guë'bi. Ga'nihuëbi pu'ncaguë uinguëna, ba hua'nabi ñë'ca raiyë. Güina'ru, gu'a jucha jo'caye beoye yo'ojën ba'icua ba'ijënna, Riusubi yua te'e jëana bënni senjoguë raija'guë'bi, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sehuoni ja'nrëbi bacuani ye'yo cocare quëabi: —Mësacua yua Taita Riusuni ujajën, gare jo'caye beoye baguëni senreba senni achajën ba'ijë'ën. Ja'anre te'e ruiñe yo'ojën ba'ijë'ën caguë, ën cocare quëani achoguëna, achani yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yequë huë'e jobo ëjaguë baquëña. Ja'nca ba'iguëbi Riusuni re'oye ëñama'iguë baquëña. Bain hua'nare'ga re'oye ëñama'iguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hua'je hua'go'ga ja'an jobore ba'igobi, yequëbi bagoni ai je'o baguëna, ja'an ëjaguëna sani, baguë coñete senreba senni achago bacoña. ");
INSERT INTO snnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jo'caye beoye si'a umuguseña senni achago ba'igona, ëjaguëbi coñe güeguë ba'isi'quëbi bago señete ya'jani, ja'ansi'quë ro'taguëña: “Yë'ë yua Riusuni re'oye ro'tama'iguë, bainre'ga re'oye ëñama'iguëta'an, ");
INSERT INTO snnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ja'an hua'je hua'gobi yë'ëni ai raijera senni achago raigona, ai ya'jahuë yë'ë. Bago yua se'e hui'ya senni achago raima'ija'go caguë, bago sense'e'ru conja'guë'ë yë'ë” cani conguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Gu'a ëjaguëbi ja'nca bagoni conguëna, mësacua'ga Riusu coñete ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mësacua yua Riusu bainreba cuencuesi'cua ba'ijën, baguëni na'ijani ñatajani senreba senni achajën ba'ijënna, mësacuani gare ëjoye beoye conreba conguë ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aito. Mësacuani te'e jëana conja'guë'bi Riusu. Ja'nca conguë ba'ija'guëta'an, yë'ë, Riusu Raosi'quëreba ba'iguëbi se'e raiguëna, ¿jarocuabi Riusuni si'a recoyo ro'tajën, baguëni jo'caye beoye coca senni achajën ba'ija'cua'ne? ¿Yequërë yë'ëni recoyo ro'tajën ujacuabi carajeima'ija'cua'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Caguëna, ja'nrëbi yequëcua re'o bain ba'iye cacuabi ti'anhuë. Ti'ancuabi yequëcua ba'iyete gu'aye cacua baë'ë. Ja'nca ba'icuabi ti'anjënna, Jesusbi ye'yo cocare bacuani cani achobi: ");
INSERT INTO snnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Samu bain hua'na ëmëcuabi Riusu huë'ena cacani, Riusuni ujareña. Te'eguë yua fariseo ba'iguëna, yequë yua impuesto curi ro'iye coguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ja'an fariseo hua'guëbi cacani nëcaguë, ñaca ujaguëña: “Ah, Taita Riusu, më'ëni ai bojoguë, më'ëni surupa cayë yë'ë. Yequëcua gu'a bain, bonse jiancua, ro coquecua, romicua ëmëcua sa'ñeña ro a'ta yo'o ëaye ba'icua, bacua yo'ojën ba'iye'ru yo'oma'iguë'ë yë'ë. Ënquë'ga impuesto curi ro'iye co hua'guë, baguë gu'aye yo'oguë ba'iye'ru gare gu'aye yo'oma'iguë'ë yë'ë, re'o bainguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yë'ë re'oye yo'oguë ba'iyete cato, ga semana ba'iye samu umuguseña aon aiñe jo'caguë, si'a yë'ë curi coni base'ere ëñani, décima parte ñë'serë ba'iyete cuencueni më'ëna ro insiguë yo'oyë yë'ë” ujaguë caguëña fariseo hua'guë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Caguëna, impuesto curi ro'iye coguëbi ca'nco se'gare ba'iguë, Riusu ta'yejeiyereba ba'iyete te'e ruiñereba ro'taguë, yija se'gare ëñaguë, baguë coribana ai sa'ntiguë huaiguë, Riusuni ujaguë caguëña: “Ja'quë Riusu, yë'ë hua'guë ro gu'a hua'guë se'ga ba'iguëreta'an, yë'ëni oire baguë conjë'ën” ujaguë caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ja'nca ujajën cajënna, mësacuani yihuoguë quëayë yë'ë. Ba samucua si'a jubëbi huëni huë'ena go'ijënna, Riusubi ja'an impuesto curi ro'iye coguë se'gani re'oye ëñaguë bojo güesebi. Fariseo hua'guëca banbi. Si'a bain re'o bain ba'iye ta'yejeiye cacua ba'ijënna, Riusubi bacuare ëñani, ta'yejeiye beo hua'nare bacuare re'huani jo'caji. Si'a bain Ro ta'yejeiye beo hua'guë'ë yë'ë cajën ba'ijënna, Riusubi bacuare ëñani, baguë ta'yejeiye re'o bainre bacuare re'huani baji, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ja'nrëbi bain hua'nabi bacua zin hua'nare Jesusna sani, Bacuani re'oye pa'roja'guë cajën, ti'an bi'rajënna, Jesusre yo'o con hua'nabi bainni bëin coca cajën, bacuani ënsehuë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ënsejënna, Jesusbi bain hua'na raiye choiguë, baguëre yo'o con hua'nani cabi: —Zin hua'nabi yë'ëna raijënna, ënseye beoye ba'ijë'ën. Riusu ba'i jobo ba'ija'yete ëñato, ëncua zin hua'na ba'iye'ru si'a jubë ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ja'nca sëani, mësacua re'oye ro'tajën yë'ë bainreba ba'ija'yete masijë'ën. Riusu bainreba ba'iye yëcuabi zin hua'na ro'tajën ti'anja'ñe'ru güina'ru te'e ruiñe ro'tajën ti'anma'itoca, Riusu ba'i jobona ti'añe gare porema'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ja'nrëbi judío ëja bainguëbi ti'anni, Jesusni senni achabi: —Ëjaguë, më'ëbi re'o bainguë sëani, yë'ë senni achayete quëajë'ën. Yë'ë'ga Riusu bainguë runni baguë naconi carajeiye beoye ba'ijaza caguë, ¿gue yo'ore yo'oye baye'ne yë'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Senni achaguëna, Jesús sehuobi: —¿Më'ë queaca ro'taguë, yë'ëre re'o bainguë ba'iye caguë'ne? Riusu se'gabi re'oguë ba'iguë'bi. Yequëcua bañë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ja'nca sëani, Riusu coca guanseni jo'case'ere ro'taguë, ja'anre te'e ruiñe yo'oguë ba'ijë'ën: “Romini yahue bani a'ta yo'oma'iñe, bainni huani senjoma'iñe, bonsere jianma'iñe, bain ba'iyete ro coquejën cama'iñe, pë'caguë sanhuëni te'e ruiñe ëñañe” ja'anre te'e ruiñe yo'oguë ba'ijë'ën më'ë'ga, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Caguëna, ba hua'guë sehuobi: —Ja'anre yë'ë zinrënna caraye beoye yo'oguë ba'iyë yë'ë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sehuoguëna, Jesusbi achani, baguëni cabi: —Ja'nca yo'oguëta'an, yeque yo'o yo'oye se'ga caraji më'ëre. Më'ë bonse beoru insini, curi coni, bonse beo hua'nana ro insijë'ën. Ro insiguëna, Riusubi baguë guënamë re'oto bayete më'ëna ai insireba insija'guë'bi. Më'ë ën yija bonsere ja'nca gare insini jo'cani, ja'nrëbi yë'ëni te'e conguë raijë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Caguëna, baguëbi achani, ai bonse baguë sëani, ro sa'nti hua'guë runji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja'nca ruinguëna, Jesusbi cabi: —Yua ai bonse bacuabi Riusu ba'i jobona ti'anni ba'i ëaye yo'ojën, ai guaja yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camello hua'nabi guëna miu gojena cacani etajei ëaye yo'oto, ai guaja yo'oyë. Bonse bacua'ga Riusu ba'i jobona ti'anni ba'i ëaye yo'oto, quë'rë ta'yejeiye guaja yo'oyë bacua, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Caguëna, ja'anre achacuabi baguëni cajën senni achahuë: —Ja'nca ba'itoca, ¿jarocuabi Riusu ba'i jobona ti'añe poreye'ne? cajën senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Senni achajënna, Jesús sehuobi: —Bain hua'nabi ro yo'ojën, ta'yejeiye yo'oye porema'icuata'an, Riusubi si'aye ai ta'yejeiyereba yo'oye poreji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Caguë sehuoguëna, ja'nrëbi Pedrobi cabi: —Ëjaguë, yëquënabi si'aye gare jo'cani, më'ëni yo'o conjën, recoyo te'e zi'inhuë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Caguëna, Jesús sehuobi: —Mësacuani ganreba caguë quëayë yë'ë. Bain hua'nabi Riusu yo'o case'e se'gare yo'oza cajën, bacua baye si'aye gare jo'cajën, bacua huë'e, pë'caguë sanhuë, ma'yë sanhuë, yo'je hua'na, rënjo hua'go, zin hua'na, ja'an si'ayete gare cu'e ëaye beoye jo'catoca, ");
INSERT INTO snnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Riusubi quë'rë ta'yejeiye ai insireba insija'guë'bi. Ën yija baye, guënamë re'oto baja'ye, ja'anre quë'rë ta'yejeiye ai insireba insiguë, bacuani baguë naconi gare carajeiye beoye ba'i güeseja'guë'bi Riusu, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ja'nca cani, ja'nrëbi baguëre yo'o concuare ca'ncona sani, bacuani quëabi: —Yureca mai hua'nabi Jerusalén huë'e jobona saiyë. Ja'nca sani, ti'anni ba'ijënna, ja'an bain hua'nabi yë'ëni ai yo'o güeseja'cua'ë. Riusu ira bain raosi'cua toyani jo'case'e si'aye cani jo'case'e'ru güina'ru yo'ojën, yë'ëre Riusu Raosi'quëreba ba'iguëre ai yo'o güeseja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yë'ëre zeanni, judío bain jubë ba'ima'icuana insini senjojënna, bacuabi yë'ëni jayajën, yë'ëre ai gu'aye yo'ojën, yë'ëre go tutujën yo'oja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ja'nca yo'oni, ja'nrëbi ga'ni za'zabobi inni, yë'ëre si'nseni tëjini, ja'nrëbi yë'ëre huani senjoja'cua'ë. Huani senjojënna, samute umuguseña ba'ini, ja'nrëbi go'ya raija'guë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Caguëna, ba hua'nabi ro huesë ëaye achahuë. Tin acho coca caguëre sëani, gare masiye porema'iñë mai, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ja'nca cajën, Jericó huë'e jobona ti'an bi'rajënna, ñaco ëñama'iguëbi bacua ma'a yëruhuare ba'iguë, bain hua'nani curi so'corëanre senni achaguë ñuji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ja'nca ñu'iguëbi achaguë, ai jai jubë bain saijënna, bacuani ¿Mësacua guere ëñajën saiye'ne? senni achaguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jesús Nazarenobi raiji sehuojënna, ");
INSERT INTO snnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ba hua'guë yua, ai jëja güiguë cabi: —Yë'ë bainguë Jesús, David yo'je raisi'quë, yë'ë hua'guëre oireba oiguë conjë'ën ai jëja güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ja'nca güiguëna, Jesús ru'ru saicuabi baguëni bëinjën, Güiye beoye ba'ijë'ën cahuë. Cacuata'an, ba hua'guë yua quë'rë ta'yejeiye güiguë cabi: —David bainguë yo'je raisi'quë, yë'ë hua'guëre oireba oiguë conjë'ën, güiguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ja'nca güiguë caguëna, Jesusbi nëcajani, Ja'an hua'guëre yë'ëna rajë'ën caguëna, baguëre cuanni rahuë. Rajënna, Jesusbi baguëni senni achabi: ");
INSERT INTO snnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Guere yë'ëre senni achaguë'ne më'ë? senni achabi. Senni achaguëna, sehuobi: —Ëjaguë, yë'ëre ñaco ëña ëaji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sehuoguëna, Jesús cabi: —Më'ë ñaco ëñaguë ba'ijë'ën. Yë'ëni si'a recoyo ro'taguë sëani, huajë raë'ë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Caguëna, ja'ansirën ñaco sëtani ëñabi. Riusuni ai bojoguë, surupa caguë, Jesusni te'e conguë saji'i. Ja'nca bojoguëna, bain hua'na'ga baguë ñaco sëtase'ere ëñani, Riusuni ai ta'yejeiye bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ja'nrëbi, Jesusbi se'e sani, Jericó huë'e jobona ti'anni, yequë ca'ncobi etani sai bi'raguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ai bonse ëja bainguë Zaqueo hue'eguëbi baji'i. Impuesto curi ro'iye cocua, bacua ëjaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja'nca ba'iguëbi Jesusni ëñani masiza caguë, bë'je hua'guë sëani, bain ñë'casi jubë ba'ijënna, ti'anni ëñañe gare poremaquë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ja'nca ëñañe porema'iguëbi quë'rë ru'ru huë'huëni, sicómoro sunquiñë Jesús rai ma'a yëruhua ba'iguëna, tinja mëni ëjobi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ëjoguë tuiguëna, Jesusbi ti'anni, ñaco mëñe, Zaqueoni ëñani cabi: —Zaqueo, besa gajeni, yë'ë naconi raijë'ën. Yure umuguse më'ë huë'ena bëaye bayë yë'ë, caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Caguë choiguëna, Zaqueobi querë gajeni, Jesusni ai bojoguë, baguë huë'ena sabi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja'nca saguëna, bain hua'nabi ai bëinjën ëñajën, sa'ñeña cahuë: —Ro gu'a bainguë huë'ena cacani bëaza caguë yo'oji baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ja'nrëbi, Zaqueobi baguë huë'ere ba'iguë, Jesusni te'e ruiñe ro'taguë cabi: —Ëjaguë, yë'ë bonse, jobo ba'iye quëñoni, bonse beo hua'nana ro insija'guë'ë yë'ë. Yequëcuare'ga, yë'ë coqueguë tëtesi'cua ba'icuare'ga, gajese'ga ba'iye bacua curire quë'rë se'e ba'iye go'yaja'guë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Caguëna, Jesusbi quëabi: —Ënquë yua Taita Abraham bainguërebare sëani, Riusubi baguë recoyo ro'tayete ëñani, baguë bainguëre re'huani babi yure umuguse. ");
INSERT INTO snnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yë'ë yua Riusu Raosi'quëreba ba'iguëbi bain hua'na so'ona sani huesësi'cuani cu'eza caguë, bacuare tëani baye ro'taguë raisi'quë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ja'nrëbi, Jesusbi se'e sani, Jerusalén huë'e jobo tëca sani ti'an bi'raguëna, baguë naconi saicua, Zaqueoni coca case'ere achasi'cuabi ro'tajën, “Riusu ba'i jobo yua te'e jëana ëñaja'ñeta'an ba'iji maire” ro'tajën ba'ijënna, Jesusbi bacuani ye'yo cocare ");
INSERT INTO snnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","quëa bi'rabi: —Yequë bainguë, ta'yejeiye ëja bain jubë ba'iguëbi baquëña. Ja'nca ba'iguëbi ja'ansi'quë ro'taguë, “Quë'rë ta'yejeiye ëja bain huë'e jobona sani, ënjo'on bain ta'yejeiye ëjaguë runni, ja'nrëbi rani bainni guanse bi'raja'guë'ë yë'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ja'nca cani, sai bi'raguë, baguëre yo'o concua si'a saracuare choiguëna, rateña. Ratena, ga bainguëna curi so'cohua ai ro'i so'cohuare insini, bacuani yihuoguë caguëña: “Mësacua curi so'cohuare sani, bonsere coni bendiejën, Curi so'cohua quë'rë jaijeija'guë cajën, yë'ë se'e raiye tëca quë'rë beyojën ba'ijë'ën” cani tonni, ja'nrëbi bacuare jo'cani saquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Saquëna, baguë yija bain ai jai jubëbi baguëni gu'a güejën, bacua bain hua'na rëño jurëte cuencueni, ëjaguë saijai jobona saojën, ta'yejeiye ëja bainni quëa güesereña: “Ja'an saiguëni gu'a güecua sëani, yëquëna ta'yejeiye ëjaguëte baguëre re'huama'ijë'ën” cajën saoreña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ja'nca cajën saocuareta'an, bacua ta'yejeiye ëjaguëre re'huasi'quë ba'iguëna, baguë yijana goquëña. Go'ini, ti'anni, ja'nrëbi baguëre yo'o concuare, baguë curi so'coñare insisi'cuare choiguë, bacua curi jaijeise'ere achani masiza caguë choquëña bacuare. ");
INSERT INTO snnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Choiguëna, ru'ru ba'iguëbi ti'anni quëaguëña: “Ëjaguë, më'ë curi so'cohua naconi bonse cojani bendieni, si'a sara so'coñare se'e coni bahuë yë'ë” quëaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Quëaguëna, ëjaguëbi sehuoguëña: “Ai re'oye yo'oguë, curi jaijei güesehuë më'ë. Yë'ë choa so'cohua se'ga naconi ai jaijei güesesi'quëre sëani, si'a sara huë'e joboñare më'ëna jo'caja'guë'ë yë'ë. Jo'caguëna, ja'an bainni ëñaguë guanseguë ba'ijë'ën” cani, baguëre saoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Saoguëna, samu ba'iguëbi ti'anni quëaguëña: “Ëjaguë, më'ë curi so'cohua naconi bonse cojani bendieni, te'e ëntë sara so'coñare se'e jaijeini coni bahuë yë'ë” quëaguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Quëaguëna, ëjaguëbi sehuoguëña: “Re'oji. Ja'nca jaijei güesesi'quëre sëani, te'e ëntë sara huë'e joboñare më'ëna jo'caja'guë'ë yë'ë. Ja'an bainni ëñaguë guanseguë ba'ijë'ën” caguë, baguëre saoguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Saoguëna, ja'nrëbi yequë yo'o con hua'guëbi ti'an rani quëaguëña: “Ëjaguë, më'ë curi so'cohua insise'e, ja'ansi so'cohuare coni bajë'ën. Can të'tërëna reani gueonni re'huani bacaë'ë yë'ë. Ja'ansi so'cohuare më'ëna go'yayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Më'ë yua ai huaji yaguë ëjaguëre sëani, më'ë curi insise'ere jaijei güeseye ai huaji yëguë baë'ë yë'ë. Më'ëbi ai jëja guanseguë sëani, yequëcua yo'o yo'ose'ere tëani bayë më'ë. Yequëcua tanse'ere'ga tëani bayë më'ë” caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Caguëna, ëjaguëbi ai bëinguë sehuoguëña: “Ai gu'aye yo'oguë, yë'ëre re'oye conmaë'ë më'ë. Më'ë coca case'e se'gare achani, më'ëre bënni senjoñe bayë yë'ë. Më'ë yua yë'ë ba'iyete ja'nca masiguë, Ai jëja guanseguë yequëcua yo'o yo'ose'ere tëani bayë yë'ë caguë, ");
INSERT INTO snnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","më'ë ¿queaca yo'oguë, yë'ë curi insise'ere curi re'hua huë'ena jo'camaquë'ne? Jo'catoca, yë'ëbi raiguëna, ja'an curi quë'rë jaijeiguëna, coni bare'ahuë yë'ë” bëinguë caguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cani, ja'nrëbi baguë bain ja'anrute nëcacuani guanseguëña: “Baguë curi so'cohuate tëani, si'a sara so'coña baguëna insijë'ën” caguë guanseguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Guanseguëna, ba hua'nabi sehuojën senni achareña: “Ëjaguë, më'ë ¿queaca ro'taguë, si'a sara so'coña baguëna quë'rë ta'yejeiye insiye ro'taguë'ne?” senreña. ");
INSERT INTO snnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Senjënna, sehuoguëña: “Mësacuani ganreba quëayë yë'ë. Ai jaijeiye re'huani baguëna quë'rë se'e ai insise'e ba'ija'guë'bi. Choa ma'carë se'gare baguëna, baguë baye si'ayete tëase'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yureca yë'ëni gu'a güesi'cuare te'e jëana zeanjani rajë'ën. Bacuabi yë'ëre gu'a güejën, bacua ta'yejeiye ëjaguë ba'ima'ija'guë casi'cuare yë'ë ba'iruna rani, bacuani huani senjojë'ën” caguë guanseguëña, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja'nca quëani, Jerusalén ma'aja'an se'e sani ti'an bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti'an bi'raguëbi baru so'o ca'ncoñare ëñato, Betfagé, Betania, ja'an huë'e jo'borëan baji'i. Olivo cubë casirute ba'iguëna, baguëre yo'o concua samucuare choini, ");
INSERT INTO snnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","bacuani quëabi: —Mësacua yua ja'an huë'e jo'borëna saijë'ën. Sani ti'anni, burro hua'guë bonsëguë yoni rëonsi'quëni ëñaja'cua'ë. Yuta bain tuama'iguë, ja'anguëni ëñani jo'chini rajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja'nca jo'chi bi'rajënna, yequëcuabi “¿Mësacua guere yo'ojën, baguëte jo'chini saye'ne?” Ja'nca senni achatoca, “Mai Ëjaguëbi baguëte yëji” cajën sehuojë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Caguëna, bacuabi sani ëñato, Jesús quëase'e'ru güina'ru baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja'nca ba'iguëna, burro hua'guëre jo'chijënna, ba burro bacuabi senni achahuë: —¿Mësacua guere yo'ojën, burro hua'guëre jo'chiye'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Senni achajënna: —Mai Ëjaguëbi baguëte yëji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ja'nca sehuoni, burro hua'guëre sani, Jesusna ti'anni insihuë. Insini, bacua guayoni se canre burro guërëbëna tëoni, ja'nrëbi Jesusni tua güesehuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tua güeseni, Jesús yua Jerusalén ti'añe cueñe saiguëna, bacua guayoni se cañare baguë ru'ru sai ma'ana jaoni uan bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Uan bi'rajënna, ja'nrëbi Jerusalenna ti'anni, Olivo cubë jaba ba'irute ba'iguëna, baguëre yo'o con hua'na te'e ai jai jubë ba'icua baguëre concuabi Taita Riusuni ai bojoreba bojojën, Cristo ta'yejeiye yo'oguë ba'ise'ere quëajën, ");
INSERT INTO snnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","si'a jëja güini achohuë: —Riusubi bojoguë raoguëna, mai ta'yejeiyereba ëjaguëbi maina ti'an raji'i. Ja'nca sëani, guënamë re'oto ba'icua si'acua ai bojoreba bojojën bañuni. Mai ta'yejeiyereba ëjaguë Riusuni ai ëama'iñereba bojojën cañuni, güireba güijën cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cajënna, fariseo hua'na, bain jubë naconi saicuabi Jesusni bëinjën cahuë: —Ëjaguë, më'ëre concuani bëinguë cani, bacua cayete ënsejë'ën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Cajënna, sehuobi: —Bañë. Ba hua'nabi caye beoye ba'itoca, ën gatabëan ja'anse'ebi huëni güina'ru te'e güire'abi, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cani, Jerusalén huë'e jobona ti'an bi'rani, si'a jobore ro'tani oji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Oiguë, ja'an huë'e jobo bainre ro'taguë cabi: —Yure umuguse yë'ë yua mësacuani ta'yejeiye bojo güeseguë raisi'quëreta'an, mësacua achaye güehuë. Riusubi yë'ëre raoguëna, mësacua ñacobi ëñani masiye gare porema'icua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ja'nca porema'icuare sëani, ai yo'ojën ba'ija'cua'ë mësacua. Mësacuare je'o bacuabi ti'an rani si'a huë'e jobo të'ijeiye nëcajën, etaye yëcuare ënsejën, mësacuare si'a ca'ncoñabi ai ta'yejeiye huajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ja'nca ba'icuabi mësacuani gare carajei güesejën, mësacua huë'e jobo tu'ahuëte gare ñañoni taonni, si'ayerebare gare ñu'ñujei güesejën, mësacuani ai ta'yejeiye huaja'cua'ë. Mësacua yua Riusu ëñaguë raisi umugusere gare ro'tamajën huesëcuare sëani, je'o bacuabi ja'nca carajei güeseja'cua'ë, cani tonbi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cani tonni, ja'nrëbi Riusu uja huë'ena cacani, bonse bendiecuare gare etoni saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Saoguë, bacuani cabi: —Mësacua yua Riusu coca toyani jo'case'e ën cocare ro'tajë'ën: “Yë'ë huë'e yua bain uja huë'e'ë” toyani jo'case'eta'an, mësacuabi ti'anni, ro gu'a huë'e, jian hua'na gati huë'ere ro re'huani jo'cahuë mësacua, caguë, bacuare etoni saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ja'nrëbi, Jesús yua si'a umuguseña Riusu uja huë'ena cacani, bainni ye'yoguë baji'i. Ye'yoguë ba'iguëna, pairi ëjacua, ira coca ye'yocua, bain ëjacua, bacuabi Jesusni ai je'o bajën, sa'ñeña senni achajën, “¿Queaca baguëni huani senjoñe'ne mai?” cajën ba'icuata'an, ");
INSERT INTO snnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bain hua'nabi baguë cocare ai re'oye achajën ba'ijënna, baguëni huani senjoñe poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ja'nrëbi, yequë umuguse ba'iguëna, Jesús yua Riusu huë'ere ba'iguë, bainbi achajënna, bacuani ye'yoguë, Riusu bainreba mame recoyo re'huani baja'yete quëani achoguëna, pairi ëjacua, ira coca ye'yocua, ira bain ëjacua, bacuabi ti'anni, ");
INSERT INTO snnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","baguëni senni achahuë: —¿Më'ë queaca ro'taguë, ënjo'ona rani, ëjaguë yo'oye'ru yo'oguë'ne? ¿Jaro ëjaguëbi më'ëre ta'yejeiye caye guanseni raoguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Senni achajënna, sehuobi: —Ru'ru, mësacuani senni achaza. Quëajë'ën yë'ëre. ");
INSERT INTO snnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jaro ëjaguëbi Juanre bain bautizaguëre re'huani raoguë'ne? ¿Riusu re'huani raosi'quë, o bain re'huani raosi'quë baquë baguë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Senni achaguëna, bacua jubë se'ga sa'ñeña senni achajën, coca cajën baë'ë: —¿Queaca sehuoye'ne mai? “Riusu raosi'quë baji'i” catoca, baguë yua “¿Mësacua queaca ro'tajën, Juan cani jo'case'ere recoyo ro'tamate'ne?” cama'iguë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Bain raosi'quë baji'i” catoca, si'a bain jubëbi huëni, maini gatabi senjojën huaiyë, bacua yua Riusu raosi'quë ba'iye ro'tacua sëani, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ja'nca cani, ja'nrëbi Jesusna bonëni sehuohuë: —Juan re'huani raosi'quëre huesëyë yëquëna, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sehuojënna, Jesús cabi: —Mësacua ja'nca sehuocuare sëani, yë'ëre re'huani raosi'quëre mësacuani gare quëama'iñë yë'ë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cani ja'nrëbi se'e yeque ye'yo cocare ja'an bainni quëabi: —Zio ëjaguë baquëña. Bisi ëye ziore tanni, ja'nrëbi yequëcua zio cuiracuana jo'cani, yequë so'o yijana sani zoe baquëña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sani ba'iguëbi, bisi ëye tëarën ti'anguëna, baguëre yo'o conguëte choini, zio cuiracuana saoguëña, ëye tëase'ere coni raja'guëte. Saoguëna, ti'anguëna, zio cuiracuabi ba yo'o conguë raosi'quëre zeanni ro ja'si yo'oni ëye beo hua'guëre go'yareña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Go'yarena, baguë ëjaguëna ti'anguëna, zio ëjaguëbi se'e yequë yo'o con hua'guëre saoguëña. Saoguëna, baguëre'ga güina'ru, gu'aye yo'oni, ro ja'si yo'oni, ëye beo hua'guëre'ga go'yareña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Go'yarena, se'e yequë yo'o con hua'guëre saoguëna, bacua'ga güina'ru ja'si yo'oni, baguëte ro senjoni go'yareña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ja'nca yo'orena, ëjaguëbi ro'tani, ja'ansi'quë caguëña: “¿Queaca yo'oye'ne yë'ë? Yë'ë zin hua'guë ai yësi'quëre bacuana saotoca, yequërë baguëni te'e ruiñe ëñani re'oye yo'oma'iñe bacua” ro'taguëña baguë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ja'nca ro'tani, baguë zin hua'guëre saoguëña. Saoguëna, zio cuiracuabi baguëni ëñani, sa'ñeña careña: “Ëñajë'ën. Zio ëjaguë bayete coni baja'guë'bi rai'te. Ja'nca sëani, baguëni huani senjoñu. Junni huesësi'quë ba'iguëna, mai hua'nabi zio ëjacua ruinja'cua'ë” cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ja'nca cani, baguëni zeanni bani, zio ca'ncona sani, huani senjoreña, cabi. Ja'nca cani, bain achacuani senni achabi Jesús: —¿Mësacua queaca ro'taye'ne? ¿Zio ëjaguë queaca yo'oja'guëguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ba hua'guë yua te'e jëana sani, zio cuiracuani huani senjoni, ja'nrëbi yequëcuare baguë zio cuiracuare re'huani jo'caja'guë'bi, quëabi Jesús. Quëaguëna, bain hua'nabi achani cahuë: —Ai Riusume. Ja'nca yo'oma'ija'guë cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Cajënna, Jesús yua bacuani ëñani cabi: —Mësacua ja'nca cajën, Riusu coca toyani jo'case'e ën ca'nco toyani jo'case'ere ëñani ye'yejë'ën: Judío bain ëjacua Riusu bainre ye'yojën ba'icuabi Riusu cuencueni raoja'guëre gu'a güejën senjoja'cuata'an, Riusubi baguë bain quë'rë ta'yejeiye ëjaguëre re'huaja'guë'bi, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ja'nca sëani, Riusu Raosi'quëreba ba'iguëbi ti'an raiguëna, yë'ëre gu'a güeye beoye ëñajë'ën. Yë'ëre gu'a güeni senjotoca, carajeiye se'ga ba'iji mësacuare. Ja'nrëbi, yë'ëbi se'e ti'an raiguë, yë'ë güeni senjosi'cuare gare bënni senjo güeseja'guë'ë yë'ë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Quëaguëna, pairi ëjacua, ira coca masiye ye'yocua, bacuabi achani, sa'ñeña cahuë: —Maire gu'aye caguëre te'e jëana zeanni bañu cajën ba'icuata'an, bain jubëni huaji yëjën, Jesusre zeanmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ja'nca yo'omajën, Baguëre zeañe ti'anguëna, ëñajën ëjojën ba'ina'a cajën, bacua gu'a gajecuare choini, bacuani cahuë: —Mësacua yua baguëni te'e ruiñe coca senni achaye'ru cajën, baguëni huacha sehuo güesejë'ën bacuani cani saohuë. Huacha sehuotoca, baguëni zeanni, bain ta'yejeiye ëjaguëna insiye ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja'nca ro'tajën, bacua gu'a gajecuare saojënna, Jesusna ti'anni ñaca senni achahuë: —Ëjaguë, më'ëbi te'e ruiñe masiye ye'yoguëna, achani bojoyë yëquëna. Më'ë yua bain hua'na ro ëmëje'en yo'oni ëñoñete ro'tama'iguë, yua Riusu te'e ruiñe yo'oye yëyete ye'yoguë ba'iyë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ja'nca ba'iguë, yua yëquënabi coca senni achajënna, te'e ruiñe sehuojë'ën. ¿Romano bain ta'yejeiye ëjaguëni impuesto curi ro'iye baye yëquëna? ¿Baguëni ro'iye, o ro'ima'iñe yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Senni achajënna, Jesús yua bacua coquejën senni achase'ere masini, bacuani sehuobi: —Mësacua ¿queaca ro'tajën, ro coquejën yë'ëre senni achaye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Curi so'corëte inni, yë'ëni ëñojë'ën cabi. Caguëna, so'corëte inni rani ëñohuë. Ëñojënna, Jesusbi senni achabi: —Ën so'co bainguë, baguë mami toyase'e ¿gue bainguëbi së'iguë'ne? senni achabi. Senni achaguëna: —Bain ta'yejeiye ëjaguë'bi së'iji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sehuojënna, Jesús cabi: —Ja'nca ba'iguëna, bain ëjaguë re'huani jo'case'ere bain ëjaguëna insijë'ën. Ëjaguë Riusu re'huani jo'cose'ere Riusuna insijë'ën, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ja'nca sehuoguëna, bain hua'nabi achajënna, baguëni huacha sehuo güeseye poremaë'ë. Ja'nca porema'icuabi baguë coca sehuose'ere ai ta'yejeiye ro'tajën, gare caye beoye baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ja'nrëbi, yequëcua, saduceo bainbi Jesusni ëñajën saë'ë. Bacua yua ju'insi'cua se'e go'ya raima'iñë cajën ba'icua'ë. Baguëna sani ti'anni, baguëni senni achahuë: ");
INSERT INTO snnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ëjaguë, Moisés coca toyani jo'case'ere ro'tajë'ën. Ñaca caji: Bainguëbi zin beo hua'guë junni huesëtoca, baguë yo'jeguëbi baguë jo'casi rënjoni huejani bani, baguë ma'yë ju'insi'quëre zin cu'ecaija'guë, toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ja'nca ba'iguëna, yequëbi baguë yo'je hua'na naconi te'e ëntë sara samu hua'na bateña. Ma'yëbi huejani yuta zin beoguë junni huesëguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Junni huesëguëna, samu ba'iguëbi baguë jo'casi rënjoni huejani, baguë'ga zin beoguë junni huesëguëña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Junni huesëguëna, yequëcua'ga, te'ena, te'ena, güina'ru bagoni huejani, si'acuabi zin beojën junni huesëreña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Junni huesëjënna, ja'nrëbi yo'je, ba hua'go'ga junni huesëgoña. ");
INSERT INTO snnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ja'nca ba'ini tonjënna, yua go'ya rai umuguse ti'anguëna, ¿jaroguë rënjo ba'ija'gogo'ne? ¿Si'acua, te'e ëntë sara samucuabi bagoni basi'cua sëani, queaca sehuoguë'ne më'ë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Senni achajënna, Jesusbi sehuobi: —Ën yija bain, ëmëcua, romicua, bacuabi huejani bajën ba'icuata'an, ju'insi'cua go'ya raija'cua, yë'ë bainreba ba'ija'cua, ");
INSERT INTO snnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ja'ancuabi Riusu guënamë re'otona ti'anni, gare huejaye beoye ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Riusu guënamë re'oto yo'o con hua'na ba'iye'ru ba'ija'cua sëani, gare huejama'icua ba'ija'cua'ë. Ju'insi'cua go'ya raisi'cua sëani, Riusu mamacuareba ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ja'an Moises'ga yequë ca'ncore maina toyani jo'cabi. Zëinsi sahua quë'rona toyani jo'caguëna, Mai Ëjaguëreba Riusu, gaña Riusu ba'iguëna, Abraham, Isaac, Jacob, bacuabi baguëni te'e zi'inni ujajën ba'icua baë'ë, toyani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja'nca toyani jo'caguëna, mai Ëjaguë Riusubi baguë bain huajëcua se'gare conji. Gare junni huesësi'cuare ro'tama'iji. Riusubi ro'taguëna, baguë bainreba si'acuabi huajë hua'na se'ga ba'iyë, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ja'nca caguë sehuoguëna, yequëcua, ira coca te'e ruiñe masicuabi cahuë: —Ai re'oye sehuohuë më'ë, Ëjaguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cani, Jesusni se'e senni achaye huaji yëjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ja'nrëbi, Jesús yua bain hua'nani senni achaguë, ro'ta güesebi: —¿Mësacua queaca ro'tajën, Cristo raosi'quë yua ira ëjaguë ba'isi'quë David mamaquë ba'iji cajën, huacha ro'taye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mësacua yua Salmo quë'rona ëñajë'ën. Ira ëjaguë ba'isi'quë David'ga ñaca toyani jo'cabi: Riusubi yë'ë Ëjaguë raija'guëni cabi: “Yë'ë jëja ca'ncona bëani, quë'rë ta'yejeiye ëjaguë ba'ijë'ën, ");
INSERT INTO snnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Më'ë je'o bacua carajei ñësebë tëca” cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ja'nca toyani jo'caguë Cristo raosi'quëre baguë mamaquë ba'iye caye gare poremaji'i David, baguëre Ëjaguë casi'quë sëani, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Cani, si'a bain hua'nabi achajënna, baguëre yo'o concuana bonëni, yihuoguë quëabi: ");
INSERT INTO snnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ira coca toyani jo'case'ere ai masicua, bacua yo'ojën ba'iyete ëñare bajën, bacua ye'yoni yo'oye'ru yo'omajën ba'ijë'ën. Ro ëja bain ba'iye se'ga ëñoñe yëyë bacua. Zoa can re'o canre sayani, huë'e jobo si'a ca'ncoña ganini, ba huë'e joborebana ti'añë. Ti'anni, ta'yejeiye ëja bain ba'iye ëñojën, bain re'oye ëñajën saludayete ëjojën, ja'nrëbi bain ñë'ca huë'ena cacani, ëja bain ñu'i seihuëanre cu'eni bëayë. Aon choisi'cua ba'ito, quë'rë re'oruan se'gare cu'eni bëayë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ja'nca yo'ocua sëani, hua'je hua'nani ro coquejën, bacua huë'ere ro tëteni bacua'ë. Riusuni ujato, ai zoe ujajën, bain ëñajën achaja'bë cajën, Riusuni ro ujacua'ë. Ja'nca yo'ojën ba'ijënna, Riusubi ja'ancuani ëñani, bacuani quë'rë ta'yejeiye bënni senjoguë ba'ija'guë'bi, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Quëani ja'nrëbi, bonëni ëñato, curi ëjacuabi bacua curire Riusu huë'e curi gajonguna ayajën, Riusuna insijën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Insijën ba'ijënna, hua'je hua'go bonse beoreba beogo ba'i hua'gobi ti'anni, samu curi so'corëanre ayago. ");
INSERT INTO snnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ayagona, Jesús cabi: —Mësacuani ganreba caguë quëayë yë'ë. Ja'an hua'go, hua'je hua'go bonse beo hua'gota'an, yequëcua ayani insise'e'ru quë'rë ta'yejeiye Riusuna insigo bago. ");
INSERT INTO snnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ja'ancua yua bacua curi bani jëhuase'e se'gare rani ayani insijënna, bago chao hua'gobi bago aon co curire rani, beoru ayani insigo, Riusure bojogo sëani, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Caguëna, yequëcuabi Riusu huë'e ba'iyete cajën, Ai re'o gatabi yo'ose'e sëani, ai re'o huë'e bëaji cajën, Riusuna ro insise'ere bojojën cahuë. Cajënna, ja'nrëbi Jesusbi bacuani cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mësacua yua ën huë'e jai huë'ere ëñajën, re'oye cajënna, yequë umuguseñabi si'aye gare taonni senjose'e ba'ija'guë'bi. Gare te'e gatabë tuiye beoye ba'ija'guë'bi, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Caguëna, Bacuabi baguëni senni achahuë: —Ëjaguë, ¿quejeito ja'an ba'ija'guëguë'ne? ¿Ja'an ba'ija'ye queaca masija'cua'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Senni achajënna, Jesús yihuoguë cabi: —Mësacua ëñare bajën, coquejën cacuare achamajën ba'ijë'ën. Ai bainbi yë'ë ba'iyete coquejën, “Yë'ë yua Riusu raosi'quë'ë” cajënna, yequëcuabi “Carajei umuguse ti'anbi. Yua'ë” cajënna, bacua coquejën case'ere achama'ijë'ën. Bacua naconi te'e saima'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yequëcua'ga guerra huayete cato, ëja bainre etoni senjoñe cato, mësacua yua ja'anre achajën, gare huaji yëye beoye ba'ijë'ën. Ja'an si'aye ru'ru ba'iguëna, carajei umuguseña jë'te ti'anja'guë'bi cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ja'nca cani, ja'nrëbi bacuani se'e yihuoguë quëabi: —Te'e yijaña bainbi yequë yijaña bainni guerra huajën, ai yo'o güesejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yija ñu'cueye'ga ai raijeija'guë'bi. Bain hua'nabi ja'an ro'ina ai yo'ojën, aon gu'ana ju'injën, si'a rau neni ju'injën, ja'an ba'ija'cua'ë si'a ën yija bain. Ja'nrëbi, guënamë re'otona bain gare ëñama'ise'ere ëñajën, ai quëquëjën, ai huaji yëjën, ro rënni ganocua se'ga ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ja'nca ba'iguëna, ru'ru, mësacuani preso zeanni, mësacuani je'o bajën, bain ñë'caruanna sani, mësacuare si'nseye cajën, ya'o huë'ena guaojën ba'ija'cua'ë. Mësacuabi yë'ë bainrebare sëani, mësacuare zeanni, bain ta'yejeiye ëjacuana nëconi, mësacuani coca sehuo güeseja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja'nca yo'ojënna, mësacuabi yë'ë ba'iyete te'e ruiñe cani achoye poreja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ja'nca cani achoye porejën, mësacua jëa coca sehuoye, ru'ru gare ro'taye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yë'ë se'gabi mësacuani te'e ruiñe masi güeseguëna, mësacuabi ja'anre sehuojënna, mësacua je'o bacuabi achani, ro sehuoye beoye ba'icuareba ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ja'nrëbi mësacua te'e bainbi mësacuani gu'aye yo'oja'cua'ë. Mësacua pë'caguë sanhuë, yo'je sanhuë, bain hua'na, gaje hua'na, bacuabi mësacuare preso zeanni, yequë bainna insini senjojënna, mësacua jubëre ba'icuani, te'ecuani huani senjoja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mësacua yë'ë yo'ore yo'ocuare sëani, si'a bainbi mësacuani je'o bajën mësacuani ai gu'a güejën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ja'nca ba'ija'yeta'an, mësacua yua gare ja'si neñe beoye ba'ija'cua'ë. Huajë hua'na se'gabi etajeijën, gare te'e rañarëte huesoye beoye ba'ija'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ja'nca sëani, mësacuabi gare jo'caye beoye si'a jëja recoyo ro'tajën ba'itoca, yë'ë naconi te'e bojojën gare carajeiye beoye ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ja'nrëbi jai soldado jubëan guerra huajën raisi'cuabi Jerusalén huë'e jobo të'ijeiye nëcajënna, mësacuabi ëñani, ja'an huë'e jobo taonni carajeija'yeta'an ba'iyete masija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ja'nca carajei güese bi'rajënna, Judea yija ba'icuabi cu re'otona te'e jëana sani gatija'bë. Jerusalén huë'e jobo ba'icua'ga te'e jëana etani saija'bë. Zio re'otore ba'icuabi Jerusalenna go'iye beoye ba'ija'bë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ja'an umuguseña ti'anguëna, Riusu bënni senjo umuguseña ba'ija'guë'bi. Baguë coca toyani jo'case'e'ru ba'iye, güina'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ja'anrën ti'anguëna, romi hua'na zinbë ba'icua, yequëcua zin chuchacua, ja'ancuabi jëja beocua sëani, ai yo'ojën ba'ija'cua'ë. Riusubi bainre ai bënni senjo bi'raguëna, si'a ën yija bainbi ai ja'sireba ja'siye ba'ijën, ai yo'oreba yo'oja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ai yo'ojën ba'ijënna, je'o bacuabi ti'anni, te'ecuani guerra hua hua'tiñabi huani senjoja'cua'ë. Yequëcuani zeanni, tin yijañana sajënna, tin yijaña gu'a bain'ga ti'anni, Jerusalén huë'e jobore taonni senjojën, si'a bonsere za'nguni si'ajën, ai gu'aye yo'ojën, Riusu etoni saoye ba'irën tëca yo'ojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ja'nrëbi, ënsëguë, ñañaguë, ma'choco hua'i, ja'anre ëñato, ai ba'iye ai huaji yaye yo'ose'e ba'ija'guë'bi. Si'a yijaña bainbi ta'yejeiye ai huaji yëjën, jai ziaya ai achoreba achoye, ziaya të'a ai jai të'a huëiguëna, ba hua'nabi ai quëquëreba quëquëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ja'nrëbi ën yijare ai huaji yaye ba'ija'yete ro'tajën, bacuabi ai ta'yejeiye ai huaji yëjën, guënamë re'oto'ga ai ta'yejeiye ñu'cueguëna, ai huaji yëjën, quëquëreba quëquëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja'nca ba'irënbi guënamë pico re'otona ëñato, yë'ë, Riusu Raosi'quëreba ba'iguëbi ai ta'yejeiyereba ñatani saoye'ru gaje meni raija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja'nca sëani, ën yija bainbi ta'yejeiye ai yo'o bi'rajënna, yë'ë yure case'e si'aye ba'iguëna, ja'anrën ti'anguëna, mësacua yua bojoreba bojojën, Mai ëjaguë yuara ti'an raija'guëta'an ba'iji cajën, mësacua etajeiyete ëñajën ëjojën ba'ijë'ën, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ja'nca quëani, bacuani se'e ye'yo cocare yihuoguë quëabi: —Mësacua yureca higo sunquiñë, yequë sunqui'ga ëñani Riusu ba'i jobo ti'anja'ñete masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sunquiñëbi ja'o sari bi'raguëna, mësacuabi ëñani ënsërën ba'iyete masiyë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Güina'ru, yë'ë yure case'e, ai huaji yaye yo'oja'ye, ja'an ba'iguëna, Riusu ba'i jobo te'e jëana ti'anja'ñete masija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mësacuani ganreba yihuoguë quëayë yë'ë. Yureña bainbi yuta junni huesëma'ijënna, yë'ë yure quëase'e si'aye yua ru'ru ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Guënamë re'oto, yija re'oto, ja'an si'aye gare carajeija'guëta'an, yë'ë coca cani jo'case'e gare carajeiye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yë'ë ti'anjai umugusere gare huanë yema'iñe cajën, mësacua ëñare bajën, gu'aye yo'omajën ba'ijë'ën. Riusuni gu'a güeni senjoma'iñe cajën, ro a'ta yo'oye, jo'chana güebeye, ën yija ba'iye, ja'anre recoyo huacha ro'tamajën ba'ijë'ën. Ja'an se'gare ro'tatoca, yë'ëbi te'e jëana ti'an raiguëna, bain hua'nabi gue ro'taye beoye ba'ijën, ro gati ëaye ba'ijën quëquëja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Taongu quëoñe'ru ba'ija'guë'bi bacuare, si'a ën yija re'oto bainre. ");
INSERT INTO snnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ja'nca ba'ija'guë sëani, mësacua'ga ëñare bajën, gare jo'caye beoye ujajën ba'ijën, yë'ë in raiye tëca ëñajën ëjojën ba'ijë'ën. Ja'an ba'ija'ye, Riusu bënni senjoja'ñe, ja'anre jëani, yë'ë, Riusu Raosi'quëreba ba'iguëni bojojën tëhuojaiñu cajën, gare jo'caye beoye ujajën ba'ijë'ën, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ja'nca quëaguë, si'a umuguse bain hua'nabi ñë'ca raijënna, bacuani ye'yoguë na'ijani, ja'nrëbi Olivo cubëna sani bëani ñatajaji'i. Ñatajani, yequë umuguse güina'ru Riusu huë'ena ti'an raiguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","si'a bain hua'nabi baguëre achajaiñu cajën, zijeirën ti'an bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yureca, judío bain pascua umuguse, bacua aonbëan huo'coma'ise'ere anni Riusuni bojoñu cajënna, ja'an umuguse ti'añe choa ma'carë se'ga carabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ja'nca ba'iguëna, pairi ëjacua, ira coca re'oye masicua, bacuabi Jesusni huani senjoja'ma cajën, bain hua'nani huaji yëjën, yuta yo'omaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ja'nrëbi, zupai huatibi Judas Iscariote hue'eguë, Jesús bainreba jubë, si'a sara samucua ba'i jubë ba'iguëna ti'an rani, baguë recoyona cacani bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ja'nca bëani ba'iguëbi Judasni ta'nhue güeseguëna, ba hua'guëbi pairi ëjacua, Riusu huë'e ëjacua, bacuana sani, bacua naconi Jesusre insijai cocare cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ja'nca cani achoguëna, bacuabi ai bojojën, baguëni curi ro'ija'yete cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cajënna, Judasbi Re'oji sehuoni, ja'nrëbi Jesusre yahue insini senjoñe ro'ta bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ja'nrëbi judío bain ta'yejeiye ba'i umuguse ti'anguëna, Aon huo'coma'ise'ere anni Riusuni bojoñu cajën yo'o bi'rahuë. Ja'nca yo'o bi'rajën, ru'ru bacua oveja bonsëguëre huani Riusuna boni mëoñe, ja'anre yo'o bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ja'nca yo'o bi'rajënna, Jesusbi Pedro, Juan, bacuare choini, guanseguë cabi: —Mësacua sani, mai pascua aon ainja'ñete re'hua bi'rajë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Caguëna, bacuabi senni achahuë: —¿Jarona sani re'huaja'ye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Senni achajënna, sehuobi Jesús: —Mësacua yua jai huë'e jobona saijë'ën. Sani ti'anni, ja'nrëbi ocobë tuiguë saiguëni tëhuoja'cua'ë. Tëhuoni, ja'an hua'guëna be'teni, baguë cacajai huë'ena cacajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cacani, ja'an huë'e ëjaguëni senni achajë'ën: “Mai ëjaguëbi më'ëni senni achaguë raobi: ¿Yë'ëre concua naconi pascua aon ainru, jaro sonohuë'ne?” ja'anre ja'an huë'e ëjaguëni senni achajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Senni achajënna, ba hua'guëbi mësacuare ëmëje'en ba'iruna mëani, jai sonohuë re'oye re'huase'ere ëñoja'guë'bi. Ja'nca ëñoguëna, ja'anruna cacani, mai pascua aon ainja'ñete re'huajë'ën cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Caguëna, ba hua'nabi sani, Jesús case'e'ru güinareba'ru ba'iguëna, bacua pascua aon ainja'ñete re'huahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Re'huajënna, ja'nrëbi pascua aon ainrën ti'anguëna, Jesusbi baguëre yo'o concua naconi sani, ja'an ñu'i seihuëanna bëani, ");
INSERT INTO snnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ja'nrëbi ba hua'guë yua si'a jubëni quëabi: —Yë'ë junni tonja'ñe yuara ti'an bi'raguëna, mësacua naconi pascua aon aiñete ai ro'taguë ba'isi'quëbi mësacua naconi aon anni tëjiza caguë quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ja'nca quëaguëbi Riusu ba'i jobona ti'anni ja'anru aon aiñe tëca, pascua aonre gare se'e ainma'ija'guë'ë yë'ë ënjo'on, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Cani ja'nrëbi, baguë uncu ro'rohuëre inni, Riusuni Surupa cani, baguëre concuani ëñani cabi: —Mësacua yua ën ro'rohuëre coni, sa'ñeña huo'hueni uncujë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mësacua achareba achajë'ën. Riusu ba'i jobo ti'añe tëca, ën jo'cha, bisi ëye su'rise'ere se'e uncuye beoye ba'ija'guë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cani ja'nrëbi, jo'jo aonbëte inni, Riusuni Surupa cani, aonbëte jë'yeni, bacuana insini cabi: —Yë'ë ga'nihuë'ë. Mësacua gu'a jucha senjoja'ñe ro'ire Riusuna insija'ye'ë. Ja'an aonre jo'caye beoye ainjën, yë'ëre ro'tajën ba'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cani, aon anni tëjijënna, uncu ro'rohuëte inni, bacuana güina'ru insini cabi: —Mësacua yua ën ro'rohuëte ëñani, Riusu mame cani jo'case'ere ro'tajën ba'ijë'ën. Yë'ë zie, mësacua gu'a jucha senjoja'ñe ro'ire jañuni tonguëna, Riusubi mame cocare cani, mësacuana jo'caja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ja'nca jo'caguëna, yë'ëre insini senjoja'guëbi yurera'rë mai naconi ënjo'onre ñu'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yureca yë'ë, Riusu Raosi'quëreba ba'iguëbi Riusu cuencuese'e'ru junni tonguë saiyë yë'ë. Saiguëta'an, yë'ëre insini senjoja'guëte ai bënni senjoguë ba'ija'guë'bi Riusu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Caguëna, ba hua'nabi sa'ñeña senni acha bi'rahuë: “¿Mai jubë ba'icua, jaroguëbi insini senjoja'guëguë'ne?” quëquëni, sa'ñeña senni achajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ja'nrëbi yo'je ba hua'nabi sa'ñeña coca cajën, “Mai jubë ba'iguë ¿jaroguëbi quë'rë ta'yejeiye ëjaguë ba'iguë'ne?” sa'ñeña senni achajënna, ");
INSERT INTO snnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesusbi bacuani cabi: —Ën yija bain ta'yejeiye ëjacuabi bacua bainni ai jëja guansejënna, bain hua'nabi bacuani ëñajën, “Maini conreba concua'ë” bacuare cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ja'nca ba'iyeta'an, mësacuabi bacua jëja guanseye'ru guansemajën ba'ijë'ën. Mësacua jubë quë'rë ta'yejeiye ëjaguë ba'iguëbi quë'rë ta'yejeiye beo hua'guë'ru ba'ijë'ën. Quë'rë ta'yejeiye guanseguë ba'iguëbi bain hua'nani quë'rë ta'yejeiye conreba conguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Te'eguëbi aon ainguë ñu'iguëna, yequëbi baguë aonre aonguëna, ja'anre ro'tani, ¿jaroguëbi quë'rë ta'yejeiye ëjaguëguë'ne? Aon ainguë ñu'iguëbi quë'rë ta'yejeiye ëjaguë ba'iji, cayë yë'ë. Ja'nca caguëta'an, yë'ë yua mësacua naconi ba'iguë, mësacuani yo'o conguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yureca, mësacua yua yë'ë naconi jo'caye beoye te'e ba'ijën, yë'ë naconi te'e oijën, ai yo'ojënna, ");
INSERT INTO snnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","mësacuare ta'yejeiye ëjacuare re'huaja'guë'ë yë'ë. Yë'ë Taita Riusubi yë'ëre ëjaguëre re'huani jo'caguëna, mësacuare'ga güina'ru ëjacuare re'huani jo'caja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ja'nca re'huani jo'caguëna, mësacuabi Riusu ba'i jobona ti'anni, yë'ë naconi te'e ñu'ijën, aon ainjën, gono uncujën ba'ija'cua'ë. Ja'nca ba'ijën, mësacua yua ëja bain ñu'i seihuëan guëna seihuëan si'a sara samuhuëanre ñu'ijën, Israel bain jubëan si'a sara samubëan bainni guansejën ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ja'nca cani, ja'nrëbi Pedroni quëabi: —Simón, Simón, zupai huatibi Riusuni ai senji: Mësacua si'acuani tëani baza caguë, mësacuani ai yo'o güeseye yëji. Trigo aon jë'jebë suni toñe'ru mësacuare senjo güeseza caji. ");
INSERT INTO snnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ja'nca caguëta'an, yë'ë yua më'ë ba'iyete ai senreba senni achaguë ba'iyë yë'ë. Më'ë gare caraye beoye si'a recoyo ro'taguë ba'ija'guë caguë, më'ë ba'iyete Riusuni senni achaguë ba'iyë yë'ë. Ja'nca senni achaguëna, më'ë yua gu'a jucha yo'oja'yete senjoni, ja'nrëbi më'ë bain concuare oiguë conguë, bacuani jëja recoyo bacuare re'huajë'ën, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Caguëna, Simón cabi: —Ëjaguë, je'o bacuabi më'ëni zeanni, ya'o huë'ena guaoni, më'ëni huani senjotoca, yë'ë'ga më'ë naconi te'e sani, më'ëre te'e conguë junni tonjaza caguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Caguëna, Jesús sehuobi: —Pedro, më'ëni ganreba quëayë yë'ë. Yure ñami, cura yu'ima'i ñësebë, më'ëbi yua yë'ëre huesëye samute ba'iye caja'guë'ë më'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Quëani, ja'nrëbi si'a hua'nani senni achabi: —Mësacuare cuencueni bainna saosirënre ro'tajë'ën. Turubëan beo hua'na, curi ayahuë beo hua'na, guëon ju'i coro beo hua'na, ja'nca ba'ijën saisi'cuabi ¿guere carajën bate'ne mësacua? senni achabi. Senni achaguëna: —Banhuë. Bonse caraye beoye gare baë'ë yëquëna, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sehuojënna, baguë cabi: —Ja'nca ba'isi'cuata'an, yureca tin yo'ojën ba'ijë'ën. Mësacua yua turubë, curi ayahuë, ja'anre batoca, inni sajë'ën. Guerra hua hua'ti beotoca, mësacua guayoni se canre bendieni, hua'tire coni sajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Riusu coca toyani jo'case'ere ëñani, yë'ë ba'ija'yete masijë'ën. “Gu'a bain naconi huani senjosi'quë ba'ija'guë'bi” caguë, yë'ë ba'ija'yete cani jo'case'e sëani, güina'ru huani senjosi'quë ba'ija'guë'ë yë'ë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Quëaguëna, bacuabi cahuë: —Ëñajë'ën, Ëjaguë. Samu hua'tiña ba'iji cahuë. Cajënna, —Yua'ë, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sehuoni ja'nrëbi, ja'an huë'ebi etani sani, baguë yo'oguë ba'ise'e'ru yo'oguë, Olivo cubëna mëni bëabi, baguëre yo'o concuabi conjënna. ");
INSERT INTO snnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ja'nca ti'anni, bacuani yihuoguë quëabi: —Mësacuabi gu'aye yo'o ëaye beoye ba'ijë'ën caguë, Riusuni ujajën ba'ijë'ën quëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Quëani, ja'nrëbi bacuare jo'cani, so'orë ba'iye sani, gugurini rëanni, Riusuni ujaguë cabi: ");
INSERT INTO snnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Taita, më'ëbi yëtoca, yë'ëni ai yo'o güesema'ijë'ën caguëta'an, ro yë'ë yëse'e se'gare yo'oma'ijë'ën. Më'ë yëye se'gare yo'ojë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Caguëna, Riusu guënamë re'oto yo'o con hua'guëbi Jesusna gaje meni, baguëni jëja recoyo re'hua güesebi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Re'hua güeseguëna, Jesús yua ai ta'yejeiye ai yo'oguë, quë'rë si'a jëja ujabi. Ja'nca ujaguëna, baguë të'ribë ja'su yajiye yua zie co'yohuëan jai co'yohuëan'ru ba'iye yijana meni tonji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ja'nrëbi, ujani tëjini, baguë yua huëni, baguëre yo'o concua ba'iruna go'ini ëñato, yua cainsi hua'na uën'ë, ai sa'ntijën oijën ba'isi'cua sëani. ");
INSERT INTO snnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ja'nca ba'ijënna, bacuani cabi Jesús: —¿Mësacua guere yo'ojën, cainsi hua'na uiñe'ne? Huëni, gu'aye yo'o ëaye beoye ba'ijë'ën caguë, Riusuni ujajën ba'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ja'nca caguë, yuta cani tëjima'iguëna, ai jai jubë bainbi raë'ë. Raijënna, Judas, Jesús bainguë cuencueni re'huasi'quë, baguë bain si'a sara samucua naconi te'e ba'isi'quëbi bacua rai ma'are ëñoguë raji'i. Rani, Jesusni muchaguë saludaza casi'quë ba'iguëbi Jesusna ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ti'anguëna, Jesús cabi: —Judas, yë'ëre, Riusu Raosi'quërebare ro coqueguë muchaguë, yë'ëre ro insini senjoza caguë ro'taguë raquë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Senni achaguëna, Jesusre concua baru ba'icuabi baguëni zeanja'ñete ëñani, Jesusni cahuë: —Ëjaguë, guerra hua hua'tiñabi zeanni, bacuani huani saoñu cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cajënna, te'eguëbi hua'tibi inni huani, pairi ta'yejeiye ëjaguëre yo'o con hua'guëni, baguë jëja ganjorote te'ntoni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Te'ntoni tonguëna, Jesús cabi: —Se'e yo'oma'ijë'ën, cabi. Cani, baguë ganjorote pa'roni, baguëni huachobi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Huachoni ja'nrëbi, pairi ëjacua, Riusu huë'e ëjacua, bain iracua, ja'ancua, baguëni preso zeanjën raisi'cuani cabi Jesús: —¿Mësacua queaca ro'tajën, guerra hua hua'tiña, huai cabëan, ja'an naconi rani, jian hua'guëre'ru yë'ëni zeanjën rate'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Si'a umuguseña mësacua naconi Riusu huë'ere ba'iguëna, yë'ëre gare zeanmaë'ë mësacua. Ja'nca yo'oma'isi'cuata'an, yure'ga mësacua yua zijei re'otore ba'ijën zemosi'cua sëani, mësacua gu'aye yo'o yo'oye porecua'ë cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Caguëna, ja'nrëbi Jesusre zeanni, pairi ta'yejeiye ëjaguë huë'ena sahuë. Sajënna, Pedro yua bacuani so'orëbi be'tebi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Be'teni ti'anni, ja'an huë'e quë'ro ba'iruna toa suase'e ba'iguëna, ja'anru bain hua'nabi toa të'ijeiye ñu'ijënna, Pedrobi bacua naconi te'e bëani toare cunji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cu'inguëna, ja'anru romi zingo yo'o con hua'gobi baguëni ëñareba ëñani, bago gaje bainni cago: —Ja'anguë'ga Jesús naconi te'e ba'isi'quë'bi cago. ");
INSERT INTO snnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Cagona, Pedro sehuobi: —Bañë. Baguëre huesëguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sehuoguëna, ja'nrëbi jë'te, yequëbi baguëni ëñani cabi: —Më'ë'ga bacua jubë te'e ba'iguë'ë cabi. Caguëna, Pedro sehuobi: —Bañë. Bacua jubë ba'ima'iguë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Caguëna, ja'nrëbi, te'e hora ba'iye ba'iguëna, yequëbi ti'anni, ai jëja caguë quëabi: —Aito. Ën hua'guëbi Jesús naconi te'e ba'isi'quë'bi, Galilea bainguë sëani, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Caguëna, Pedro cabi: —Më'ë coca caye, yë'ë gare huesëguë'ë, cabi. Caguëna, ja'ansirën, Pedrobi coca cani tëjima'iguëna, cura hua'guëbi yuji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yu'iguëna, mai ëjaguëbi bonëni, Pedroni ëñaguëna, Pedrobi baguë coca case'ere ro'tabi. “Yure ñami, cura hua'guëbi yuta yu'ima'iguëna, më'ëbi yua yë'ëre huesëyete samute ba'iye caja'guë'ë” ja'an coca quëase'ere ro'tani, ");
INSERT INTO snnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ba hua'guëbi etani sani, ai sa'ntiguë oji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja'nrëbi, Jesusre zeanni bajën, baguëni ëñajën bacuabi baguëni jayajën hua bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Huani, baguë ñacore can të'ntëbi ta'pini gueonni, ja'nrëbi baguë ziana huaijën, baguëni senni achahuë: —¿Nebi më'ëre huate'ne? Më'ë ñacobi ëñani masini quëajë'ën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ja'nca cajën, baguëni ai hui'ya jayajën, baguëni ai gu'aye yo'ohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ja'nca yo'ojënna, ja'nrëbi ñataguëna, judío bain iracua, pairi ëjacua, ira coca ai masicua, si'a jubëbi ñë'ca raijën, Jesusre zeanni, bacua ta'yejeiye ëja bain jobona nëconi, baguëni coca senni achahuë: ");
INSERT INTO snnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Më'ë yua Riusu Raosi'quë'guë? Quëajë'ën yëquënani, cahuë. Cajënna, baguë sehuobi: —Yë'ëbi quëatoca, yë'ëre te'e ruiñe achama'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yë'ë yua mësacuare'ga coca senni achatoca, yë'ëre sehuoma'iñë. Ja'nca sehuomajën, yë'ëre etoni saoma'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ja'nca yo'oma'ijënna, yë'ë, Riusu Raosi'quëreba ba'iguëbi yua Ta'yejeiye Ëjaguë Riusuna go'ini, baguë jëja ca'ncona bëani ta'yejeiguë ba'ija'guë'ë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Caguë quëaguëna, ba hua'nabi baguëni senni achahuë: —Ja'nca ba'ija'guë ba'itoca, ¿më'ë yua Riusu Zin ba'iguë? senni achahuë. Senni achajënna: —Ja'nca ba'iguë'ë yë'ë. Mësacua caye'ru ba'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sehuoguëna, bacuabi bëinjën cahuë: —Achajë'ën. Baguë se'gabi Riusure gu'aye caguëna, achahuë mai. Ja'nca casi'quëre sëani, baguë gu'aye case'ere achasi'cuani se'e ëjoma'ina'a, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ja'nca cani, ja'nrëbi Jesusre se'e zeanni, romano ëjaguë Pilatona sani nëcohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nëconi, baguëre gu'aye cahuë: —Ënquëni ëñajë'ën, ëjaguë. Yëquëna bainni ai hui'ya coqueguë ye'yoguë, yëquëna bainre gu'aye yo'ocuare re'hua bi'rabi. Bain ta'yejeiye ëjaguëni impuesto curire ro'ima'ijë'ën quëabi baguë. Riusu Raosi'quëreba ba'iguë'ë yë'ë caguë, Ta'yejeiye ëjaguë runza caguë, maire ai hui'ya ye'yoguë caguëna, yëquënabi baguëni zeanni, më'ëna rahuë, ëjaguë, cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ja'nca cajënna, Pilatobi Jesusni senni achabi: —¿Më'ë yua judío bain ta'yejeiye ëjaguë'guë? senni achabi. Senni achaguëna, Jesús sehuobi: —Ja'nca ba'iguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ja'nca sehuoguëna, Pilato yua pairi ëjacua, si'a bain hua'na, bacuani cabi: —Ënquëbi gare gu'aye yo'oma'iguë ba'iji. Si'nseye beoye ba'iji baguëre, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ja'nca caguëna, bacua yua quë'rë jëja achoni quëahuë: —Banji. Bain hua'nani coqueguë ye'yoguë, bainre gu'aye yo'ocuare re'hua bi'rabi. Galilea yijare ru'ru ye'yoni, si'a Judea yijana ye'yoguë, ja'nrëbi ënjo'ona ti'anni, ai hui'ya caji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cajënna, Pilatobi ¿Galilea bainguë'guë? senni achaguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ba'iji sehuohuë bacua. Sehuojënna, Herodes hue'eguë, Galilea yija ëjaguë Jerusalenre yure ba'iguëna, Pilatobi Jesusre baguëna saobi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Saoguëna, Herodesbi baguëni ëñani, ai bojoguë ro'tabi. Yequëcuabi Jesús ba'iyete ai quëajënna, ai ba'irën baguëni ëña ëaguëna, bojoguë ëñabi. Ja'nca ëñaguë, Ta'yejeiye yo'ore yo'oni ëñojë'ën. Ëñaza cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ja'nca caguë baguëni ai zoe senni achaguëreta'an, gare sehuoye beoye nëcabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nëcaguëna, pairi ëjacua, ira coca ai masicua, bacuabi huëni, Jesusre ai gu'aye cajën, si'a jëja quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Quëajënna, Herodes, baguë soldado hua'na naconi, bacuabi Jesusni ai hui'ya jayajën, baguëni ai gu'aye cahuë. Cani ja'nrëbi, ai re'o caña ëja bain cañare inni baguëni jayaye'ru sa'yeni, baguëte Pilatona se'e go'yahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ja'nca go'yajënna, Pilato, Herodes, bacua yua sa'ñeña ai je'o basi'cua ba'ijën, ja'ansi umuguse sa'ñeña bojojën, te'e gaje hua'na ruën'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ja'nrëbi, Pilatona go'yasi'quëbi ti'anguëna, Pilatobi pairi ëjacua, bain ëjacua, si'a bain hua'nare ñë'coni, ");
INSERT INTO snnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bacuani cabi: —Mësacua yua ënquëre yë'ëna rani, Bainre gu'aye ye'yoguë ba'iji cahuë. Cajënna, yë'ëbi baguëni senni achaguë, baguë ba'iyete masiguë, mësacua gu'aye case'e'ru ba'iye gare yo'oma'isi'quë'bi cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes'ga baguëni senni achani baguë ba'iyete masiguë, baguëte go'ya raoguë sëani, gu'aye yo'oma'iguë'bi ba'iji cabi baguë. Ja'nca gu'aye yo'oma'isi'quëre sëani, baguëni huani senjo güeseye gare porema'iñë mai. ");
INSERT INTO snnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ja'nca porema'icua sëani, ga'ni za'zabobi baguëni si'nse güeseni, baguëni etoja'guë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yureca pascua umuguseña ba'irën ba'iguëna, Pilato yo'oguë ba'ise'e'ru si'a tëcahuëan preso zeanni basi'quë te'eguëte etoni bainna go'yaguë ba'ise'e'ru yo'oguë baji'i Pilato. Ja'nca yo'oguë ba'isi'quëbi Jesusre etoye caguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","si'a jubë bainbi ai güireba güijën, te'e cahuë: —Baguëni huani senjojë'ën. Barrabás hue'eguëte etoni yëquënani jo'cajë'ën güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Güijën cacuabi Barrabasre senni achajënna, ai gu'a bainguë baji'i. Bain hua'nare huëoguë, Ëja bainni huani senjoñu caguë yo'oguëna, baguëni zeanni, ya'o huë'ena guaoni bahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Guaoni bajënna, Pilatobi Jesusre etojaza caguë, baguë etojaiyete bain jubëni caguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ba hua'nabi quë'rë si'a jëja güireba güijën cahuë: —Crusu sa'cahuëna quenni reojë'ën. Crusu sa'cahuëna quenni reojë'ën cajën, si'a jëja te'e güijën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Güijën ba'ijënna, Pilatobi samute ba'iye bacuani se'e cabi: —Gare gu'aye yo'oma'isi'quëre sëani, mësacua ¿guere güiye'ne? Baguëni huani senjoñe porema'iñë mai. Ga'ni za'zabobi huai güeseni, baguëni etoja'guë'ë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Caguëna, bacua yua quë'rë si'a jëja jo'caye beoye güijën, Crusu sa'cahuëna quenni reojë'ën cajënna, ");
INSERT INTO snnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatobi se'e caye jo'caguë, bacua sense'e, pairi ëjacuabi sen güesejënna, ja'anre achani yo'o bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ja'an gu'a bainguë preso zeansi'quëre senni achajënna, Pilatobi baguëte etoni saobi. Etoni saoni ja'nrëbi, Jesusre bacuana jo'cani, Mësacua yua ënquëni bajën, mësacua yëse'e'ru baguëre bain be'rujën ba'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Caguëna, ba hua'nabi Jesusre zeanni, Crusu sa'cahuëna quenni reojaiñu cajën, baguëre sahuë. Sani ëñato, Simón hue'eguë, Cirene bainguë, zio re'otona saisi'quëbi huë'e jobona raiguë baji'i. Raiguëna, baguëni tëhuoni zeanni, Jesús crusu sa'cahuëte baguë tanta cubëna tëoni, Jesús yo'je hue'eguë sajë'ën cajënna, ja'nca yo'obi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ja'nca hue'eguëna, ai jai jubë bainbi Jesusni be'tejën saë'ë. Yequëcua romi hua'nabi baguëte ai jëja ota oijën be'tejën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Be'tejën saijënna, Jesusbi bacuana bonëni cabi: —Mësacua Jerusalén romicua, yë'ëre oimajën ba'ijë'ën. Mësacua ba'iye, mësacua zin hua'na ba'iye, ja'an se'gare ro'tani oijën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mësacua ai yo'ojën ba'ija'yete ro'tajë'ën. Ja'an umuguseña ti'anguëna, bain hua'nabi mësacua ai yo'ojën ba'ija'yete ëñajën, ñaca caja'cua'ë: “Romi hua'na zin beo hua'na, zin të'ya raima'isi hua'na, zin chuchama'i hua'na, ja'an hua'na ba'itoca, ai bojojën ba'ija'bë” cajën ba'ija'cua'ë bain hua'na. ");
INSERT INTO snnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ja'anrën ti'anguëna, bain hua'nabi cu re'otona gati ëaye yo'ojën saijën, ai yo'ojën, cubëanna caja'cua'ë: “Cubëan ñañani, yëquënani te'e jëana ta'pini pë'npëja'guë” caja'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yureñabi juinja sunqui ba'irënbi ai gu'aye yo'ojën ba'itoca, ju'insi sunqui ba'irën ti'anguëna, quë'rë ta'yejeiye gu'aye yo'ojën ba'ija'cua'ë bain hua'na. Gu'aye yo'oma'isi'quëni yure gu'aye yo'otoca, yequëcua gu'aye yo'osi'cuani quë'rë ta'yejeiye gu'aye yo'ojën ba'ija'cua'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Caguëna, yequëcua samucua gu'aye yo'osi hua'nare zeanni, Jesús naconi huani senjojën sahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sani, sinjo gu'anbë casi cubëna ti'anni, Jesusre crusu sa'cahuëna quenni reohuë. Gu'aye yo'osi hua'nare'ga bacua crusu sa'cahuëanre reojën, te'eguëte Jesús jëja ca'ncona reohuë. Yequëre Jesús ari ca'ncona reohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesusre quenni reojënna. Jesusbi ujaguë cabi: —Taita, bacua gu'a juchare huanë yeni ro'tama'ijë'ën, bacua gu'aye yo'ose'ere huesëcuare sëani, ujaguë cabi. Caguëna, soldado hua'nabi, Baguë cañare tëani huo'hueni bañu cajën, gata toyasira'carëanre sa'ñeña senjajën ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ëñajënna, bain hua'nabi baguëni ëñajën nëcajënna, judío bain ëjacuabi baguëte ai jayajën cahuë: —Yequëcuani jëa güesesi'quëta'an, ja'ansi'quë jëaye porema'iji. Riusu cuencueni Raosi'quëreba banica, ja'nca yo'oja'guë, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Cajënna, soldado hua'na'ga baguëni jayajën, sënje jo'chare baguëni uncuani, ");
INSERT INTO snnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","baguëni cahuë: —Më'ëbi judío bain ta'yejeiye ëjaguë banica, ja'ansi'quë jëajë'ën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ja'nrëbi yequëcuabi cocare toyani, baguë sinjobë ëmëje'en ca'ncona sëohuë. Griego coca, romano coca, hebreo coca, ja'anbi toyahuë: “Ënquëbi judío bain ta'yejeiye ëjaguë ba'iji” toyani sëohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yequë, gu'aye yo'osi'quë cueñe reosi'quëbi baguëni hui'ya cabi: —Më'ë yua Riusu Raosi'quë, ja'an Cristo banica, ja'ansi'quë jëani, yëquënare'ga tëani sajë'ën, güiguë reji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Güiguë reguëna, yequë reosi'quëbi baguë gajeguëni bëinguë sehuobi: —¿Më'ë guere yo'oguë, Riusu bënni senjoñete huaji yëma'iguë'ne? Mai samutecuabi te'e reoni senjosi'cua ba'icuata'an, ");
INSERT INTO snnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","mai samucua se'gare mai gu'aye yo'ose'ere masini, maire reoni senjoñë. Ja'anguë'ga, gare gu'aye yo'oma'isi'quë ba'iji cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cani, yua Jesusni ëñani, baguëni senni achabi: —Jesús, më'ë ba'i jobona ti'anni, yë'ë ba'iyete re'oye ro'taguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Caguëna, Jesús sehuobi: —Ganreba më'ëni quëayë yë'ë. Yure umugusebi yë'ë naconi Riusu bojo güese re'oto, Riusu jo'ya re'ohuë, ja'anruna ti'anja'guë'ë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ja'nrëbi, mëñereba ba'iguëna, si'a re'oto zijei re'oto'ru runji'i, samute hora ba'i ñësebë tëca. ");
INSERT INTO snnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ruinguëna, ënsëguë na'ini huesëguëna, Riusu huë'e tëhuosi can yua jobora ye'reni saise'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja'nrëbi, Jesusbi ai jëja güiguë cabi: —Taita, yë'ë recoyore coni bajë'ën, cabi. Ja'nca cani, ja'nrëbi junni reabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Junni reaguëna, romano bainguë soldado ëjaguëbi si'aye ëñani, Riusuni bojoguë cabi: —Aito. Ja'anguëbi te'e ruiñereba yo'oguë ba'isi'quë'bi, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Caguëna, bain hua'nabi Jesús junni tonse'ere ëñajën raisi'cuabi ai oijën, bacua coribare je'njujën, Ai gu'aye yo'ohuë cajën, bacua huë'eñana sa'ntijën goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Go'ijënna, si'acua, Jesusni masijën ba'icua, romi hua'na Galileabi be'tejën raisi'cua naconi, bacuabi so'orëbi ëñajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ja'nrëbi, yequë, re'o bainguë, José hue'eguë, Arimatea huë'e jobo bainguë, baguëbi te'e ruiñe yo'oguë ba'iguëna, bainbi baguëni te'e ruiñe ëñajën baë'ë. Judío bain ta'yejeiye ëjacua jubë bainguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ja'nca ba'iguëbi Riusu bainrebare mame re'huaja'yete ëñaguë ëjoguë baji'i. Judío ëja bain gajecua ro'tajën ba'iye'ru te'e ro'tama'iguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja'nca ba'iguëbi yua Pilatona ti'anni, Jesús ga'nihuëre senji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ja'nca senni, Pilatobi insi güeseguëna, Jesús ga'nihuëre gachoni, pojei canbi ga'nebi. Ga'neni ja'nrëbi, mame tan goje, gata të'ntëbana te'ntosi goje ba'iguëna, ja'anruna sani, re'oye uanni, jai gatabëre bonani, ja'an gojere ta'pibi. ");
INSERT INTO snnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja'an umuguse sábado ja'anrë umuguse ba'iguëna, yo'o yo'oma'i umuguse yuara ti'anguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ja'nca uanni ta'piguëna, romi hua'na, Galilea yijabi Jesús naconi raisi'cuabi yua Josena be'teni, ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ëñani ja'nrëbi, huë'ena go'ini, ma'ña sëñete baguë ga'nihuëre so'onja'ñete re'huahuë. Ja'nca re'huani, yequë umuguse yo'o yo'oma'i umuguse ba'iguëna, ira coca toyani jo'case'e'ru ba'iye bëani huajëhuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ja'nrëbi, semana ja'anrë umuguse ñataguëna, zijeirën ba'iye cato, romi hua'nabi huëni, ma'ña sëñe re'huase'ere inni, Jesusre tansi gojena saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sani ti'anni, gatabë goje ta'pisibëbi quëñose'e ba'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","bacua yua ja'an gojena cacani ëñato, Ëjaguë Jesús ga'nihuë beobi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Beoguëna, bacua yua huaji yëjën, gue ro'taye beoye ba'ijënna, samucua go'sijei cañare ju'icuabi te'e jëana bacua ca'ncona eta rani nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nëcajënna, bacuabi ai quëquëjën, yijana ëñañe se'ga baë'ë. Ba'ijënna, bacuabi cahuë: —Jesucristobi go'ya raisi'quë ba'iguëna, ¿mësacua guere yo'ojën ju'insi'cua ba'iruna baguëte cu'eye'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ënjo'onre beoji. Go'ya rani yua saisi'quë'bi. Baguë Galilea yija ba'isirën quëase'ere ro'tajë'ën: ");
INSERT INTO snnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yë'ë, Riusu Raosi'quëreba ba'iguëte zeanni, gu'a bainna insijënna, yë'ëre crusu sa'cahuëna quenni reoni, huani senjojënna, samute ba'i umuguse go'ya raija'guë'ë yë'ë” quëabi baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Cajënna, bacuabi Jesús coca case'ere ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ro'tani, baguëre tansi gojebi etani, Jesusre conjën ba'isi'cua, ja'an oncecua, bacua ba'iruna go'ini, yequëcua'ga ba'ijënna, bacuani si'aye beoru quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ja'an quëacua romi hua'nabi bacua mami hue'ecua yua María Magdalena, Juana, María Santiago pë'cago baë'ë. Yequë romi hua'na'ga bacua naconi baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ja'nca quëajënna, Jesusre conjën ba'isi'cuabi ro achajën, bacua quëase'ere ro'taye güehuë. “Ro cayë bacua” ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ja'nca ro'tacuata'an, Pedrobi huëni, Jesusre tansiruna huë'huëguë saji'i. Sani ti'anni, rëanni, cacani ëñato, baguë ga'nihuë ga'nesi caña se'gabi ca'ncorëte unji'i. Ja'nca ëñani, gue ro'taye beoye huëni, baguë ba'i huë'ena bonëni goji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja'nrëbi, ja'ansi umuguse, Jesusre conjën ba'isi jubë ba'icua samucuabi Emaús huë'e jobo tëca ganijën saë'ë. Jerusalenbi sani, once kilómetro ba'iye ganiñe baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ja'nca sani, sa'ñeña cajën, yure umuguseña ba'ise'e si'aye senni achajën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ja'nca cajënna, Jesusbi ti'anni, bacua naconi achaguë, te'e gani bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Achaguë conguë ganiguëna, baguëte ëñacuata'an, baguëni masimaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Masimajënna, baguë yua bacuani senni achabi: —¿Mësacua gue cocare sa'ñeña cajën ganiñe'ne? ¿Mësacua guere sa'ntiye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Senni achaguëna, te'eguë Cleofas hue'eguëbi sehuobi: —Yure umuguseña ba'ise'ere achamaquë më'ë? Si'a ënjo'on bainbi ja'anre masiyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Caguëna: —¿Gue ba'ise'ere caguë'ne më'ë? senni achabi Jesús. Senni achaguëna, sehuobi: —Jesús Nazarenoni gu'aye yo'ojën ba'ise'ere cayë. Riusu coca quëaguë raosi'quë ba'iguëna, Riusubi baguëni ai bojoguë ëñabi. Bain hua'na'ga baguëni ai bojojën ëñajënna, baguë yua ai ta'yejeiyereba yo'oni, bain gare ëñama'ise'ere yo'oni ëñoni, te'e ruiñereba quëani achoguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","yëquëna ëja bainbi pairi ëjacua naconi baguëte preso zeanni, baguëni huani senjo güesehuë. Baguëni crusu sa'cahuëna quenni reoni senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yëquëna hua'nabi ro'tajën, “Israel bain zemosi'cuare etojani ëja bainre re'huaja'guë” cajën, baguë ja'an yo'oja'yete ëñajën ëjojën baë'ë. Ëjojën ba'ijënna, yure umuguse samute umuguseña junni tonse'e ba'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","yëquëna jubë ba'icua romi hua'nabi coca quëajënna, gue ro'taye beoye achahuë yëquëna. Yure zijeirën bacua yua Jesusre tansiruna sani ëñato, ");
INSERT INTO snnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesús ga'nihuë beoguëña. Ja'nca ëñani, se'e rani, Riusu guënamë re'oto yo'o concuabi toyare ëñojënna, bacuabi ëñani rani quëahuë: “Go'ya raji'i baguë. Riusu toyare ëñani masihuë yëquëna” quëajën raë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Quëajën raijënna, yequëcua yëquëna jubë ba'icuabi baguëre tansiruna sani ëñato, romi hua'na quëase'e'ru güina'ru baquëña. Ba'iguëna, Jesusni gare ëñamateña, baguëni sehuojën quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Quëajënna, ja'nrëbi, Jesusbi baguë te'e conni ganicuani sehuobi: —Jesucristo ba'iyete ye'yeye ai caraji mësacuare. Riusu ira bain raosi'cua toyani jo'case'ere ëñajën, mësacua ¿guere yo'ojën, si'a recoyo ro'tama'iñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Riusu raosi'quëbi yua ai ja'siye ai yo'oye babi. Baguëna, ja'nrëbi jë'te, go'ya raija'guë baji'i. ¿Ja'an coca toyani jo'case'ere, guere ye'yemate'ne mësacua? cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Cani ja'nrëbi, Riusu coca toyani jo'case'ere bacuani ëñoni, si'a ca'ncoñare ëñoni, baguë ba'ija'ye toyani jo'case'ere te'e ruiñe bacuani masi güesebi. Ru'ru, Moisés coca toyani jo'case'ere ëñoni, ja'nrëbi Riusu ira bain raosi'cua si'acua bacua toyani jo'case'ere ëñoni, baguë ba'ija'yete bacuani te'e ruiñe masi güesebi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ja'an cocare masi güeseguëna, ja'nrëbi bacua sai jobona ti'anjënna, Jesusbi se'e saiye ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ja'nca ëñoguëna, bacuabi ënsejën, baguëni choë'ë: —Yëquëna naconi te'e bëani ba'ijë'ën. Ai na'iji cahuë. Cajënna, bacua naconi cacani te'e bëabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bëani ba'iguëbi bacua naconi bëani aonre ain bi'raguë, bacua jo'jo aonbëanre inni, Riusuni bojoguë cani, aonbëanre jë'yeni, bacuana huo'hueni insibi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Insiguëna, ja'ansirën baguëni ëñani masihuë. Masini, ja'nrëbi baguëni se'e ëña bi'rato, gare beobi. Querë huesëbi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Huesëguëna, sa'ñeña coca cahuë: —Ëñajë'ën, maire Riusu yo'ose'e, maibi baguë naconi te'e ganijën, baguë yua Riusu cocare quëani achoguëna, maibi achajënna, bojo recoyora ai re'o huanobi maire. Ja'anre ro'tana'a, cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Cani, bacua yua ja'ansirën huëni, besa sani, Jerusalenna goë'ë. Go'ini ti'anni, Jesusre yo'o conjën ba'isi'cua, baguë bain si'a sara te'ecua naconi ba'icua, ja'ancuare tëhuohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tëhuojënna, bacua ja'ansirën quëani achohuë: —Mësacua achare bajë'ën. Mai Ëjaguëbi go'ya raji'i. Simonbi baguëni ëñabi, si'a jëja quëani achohuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Quëani achojënna, ja'nrëbi bacua ma'a ganijën tëhuose'ere quëahuë. Ja'nrëbi baguë yua jo'jo aonbëan jë'yeni huo'hueguëna, ja'nrëbi bacua masise'ere quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba hua'na yuta sa'ñeña cani tëjima'ijënna, Jesusbi te'e jëana bacua joborana gaje meni ëñobi. Ëñoni, bacuani saludaguë cabi: —Mësacua bojo recoyo huanoñe ba'ijë'ën cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Caguëna, bacuabi na'oñe tëca quëquëjën, Huatibi raiji cajën ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ro'tajënna, baguë cabi: —¿Mësacua guere yo'ojën quëquëye'ne? Ro huacha ro'taye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yë'ë ëntë saraña, yë'ë guëoña, ja'anre ëñani, yë'ëreba ba'iyete masijë'ën. Yë'ëni pa'roni, yë'ë ba'iyete masijë'ën. Hua'i, gu'an, ja'an bayë yë'ë. Huati banica, ja'anre beore'ahuë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cani ja'nrëbi, baguë ëntë saraña, baguë guëoña, ja'anre bacuani ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ëñoguëna, ru'ru bojojën, ja'nrëbi huaji yëjën, yuta baguë ba'iyete recoyo ro'taye poremaë'ë. Poremajënna, baguë yua coca senni achabi: —¿Mësacua gue aon baye'ne? caguë, senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Senni achaguëna, ziaya hua'i bosi ma'carë, o'a baya, ja'anre inni, rani, baguëna insini ëñato, ");
INSERT INTO snnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","baguë yua coni, si'aye anji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Anni ja'nrëbi bacuani cabi: —Mësacua naconi ba'isirënbi mësacuani coca quëaguë ba'nhuë yë'ë. Quëaguë ba'iguëna, si'aye güinareba'ru yë'ëre yo'ose'e baji'i. Riusu coca, Moisés toyani jo'case'e, Riusu ira bain raosi'cua toyani jo'case'e, ja'anre ëñato, yë'ë ba'ija'yete cani jo'case'e ba'iji. Ja'nca cani jo'case'e ba'iguëna, si'aye güina'ru baji'i yë'ëre. Salmo coca cani jo'case'ere'ga güina'ru baji'i yë'ëre, Riusu cuencueni jo'case'e sëani, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ja'nca cani ja'nrëbi, Riusu coca toyani ja'case'ere bacuani te'e ruiñe masi güeseza caguë yo'oguë, ");
INSERT INTO snnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","bacuani quëani achobi: —Ñaca toyani jo'cabi Riusu: Baguë Raosi'quë, Cristo hue'eguëbi ai ja'siye ai yo'oguëna, ja'nrëbi samute umuguseña ba'ini, junni tonsi'quëbi go'ya raija'guë'bi, cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Go'ya raiguëna, ja'nrëbi, baguë bainreba ba'icuabi ru'ru Jerusalén bainna sani, ja'nrëbi si'a yijaña bainna sani, Riusu cocareba, gu'a jucha jo'cani senjoñe, mame recoyo re'huaye, ja'anre si'a bainni quëani achoja'cua'ë mësacua, cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mësacua yua yë'ë yo'oguë ba'ise'ere ëñani masicua sëani, si'a bainni quëani achocuare mësacuare re'huahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yë'ë Taita cani jo'case'ere ro'tani, baguë Espíritu raoja'yete cato, yë'ë se'gabi Espíritute mësacuana ti'an güeseni jo'caja'guë'ë yë'ë. Ru'ru, guënamëbi raoni jo'cani, mësacuani ai ta'yejeiye yo'ore yo'o güeseja'guë'bi. Ja'anrën ti'añe tëca ënjo'on ba'i huë'e jobore ba'ijën ëjojë'ën, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Quëani ja'nrëbi, baguë bain cuencuesi'cuare sani, huë'e jobo ca'ncona sabi, Betaniana ti'añe tëca. Ti'anni, baguë ëntë sarañare mëiñe huëani, bacuani re'o coca cani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ja'nca cani jo'caguë, guënamë re'otona huahua mëni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mëni saiguëna, ba hua'nabi baguëni ai bojojën, baguëni gugurini rëanni, baguëni ai ta'yejeiye coca cani achohuë. Ja'anre yo'oni, ja'nrëbi ai bojo recoyo re'huasi'cuabi Jerusalenna goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Go'ini ti'anni, ba hua'na yua Riusu huë'ena cacani ba'ijën, Riusuni bojoreba bojojën, Riusuni gugurini rëanjën, baguëni surupa cajën, jo'caye beoye ja'nca yo'ojën baë'ë. Ja'nca raë'ë. Amén.");
INSERT INTO snnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ru'rureba ba'ijën ba'isirën Riusu cocareba quëani achoguëbi baji'i. Riusu naconi baji'i. Ja'an cocareba quëani achoguë, Jesucristo hue'eguë, ja'ansi'quë yua Riusureba baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ru'rureba ba'isirën, ja'anguëbi yua Riusuni te'ereba conguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ja'nca ba'iguëbi, Riusubi ro'tani ëñoguëna, si'aye beoru re'huani jo'cabi. Yequëcuabi re'huaye beoye baë'ë. Baguë se'gabi si'aye re'huani jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Re'huani jo'caguë, ta'yejeiyereba huajë güeseguebi, si'a hua'nare huajë hua'nare jo'cabi. Ja'nca jo'caguëbi yua mia re'oto ñatani saoye'ru baguë te'e ruiñe ba'iyete bainni masi güeseni jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Masi güeseni jo'caguëna, zijei re'oto ba'iguëna, zijei re'oto ba'iguë, zupai huati caguëbi yua baguë te'e ruiñe ba'iyete quëñoni senjoñe porema'iji. Mia re'oto ñatani saoye'ru ba'iguëna, zijei re'oto ëjaguëbi gare yayoye porema'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yequë bainguë, Juan hue'eguë, Riusu raosi'quë, baguë yua bainna ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ti'anni, mia re'oto ñatani saoye ba'iguëte bainni quëani acho bi'rabi. Ja'an cocarebare quëani achoye raosi'quë baji'i. Bainbi achani, Ja'an ba'iguëni si'a recoyo ro'taja'bë caguë, mia re'oto ñatani saoyebi ba'iguë, baguë cocarebare quëani achoguë raji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ja'nca raiguë, ja'ansi'quë yua mia porema'iji. Mia re'oto ñatani saoye'ru ba'iguëna, zijei re'oto ëjaguëbi gare yayoye porema re'oto ñatani saoye poreguëbi beobi. Baguë ba'iye quëani achoguë se'ga baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ba'iguëna, mia re'oto ñatani saoye poreguë, te'e ruiñereba ba'iguë, ja'anguëbi yuara bainna ti'an rani, baguë ba'iye, baguë cocareba, ja'anre si'acuani te'e ruiñe masi güeseguë raiguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ja'nca raiguë yua si'a re'oto re'huani jo'caguëbi ti'anni baji'i. Ba'iguëreta'an, bainbi baguë ba'iyete ëñani, baguëte ro huesëjën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ja'nca ba'ijënna, baguë te'e bain ba'iruna sani ba'iguëna, baguë te'e bainbi baguëte te'e ruiñe ëñamajën, baguëte bojomaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bojomajënna, si'a bain baguëni te'e ruiñe ëñani bojojën ba'icua, baguë ba'iyete si'a recoyo ro'tajën ba'icua, ja'ancuani: Yë'ëna rani, yë'ë naconi te'e ba'ijë'ën caguë, Riusu mamacuare bacuare re'huani babi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ro bain mamacua ba'iye'ru bacuare re'huamaji'i. Ro bain mamacua bayete cato, pë'caguë sanhuëbi, Zinre bañu cajën, zinre cu'ejënna, pë'cagobi zinre nëcani, zinre të'ya raigo. Riusu mamacua bayete cato, ja'nca ba'iye'ru baguë mamacuare re'huama'iji. Baguë se'gabi mame re'huaguëna, baguë mamacua ruiñë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yureca, Riusu cocareba quëani achoguë, baguë ba'iyete cato, baingobi të'ya raigona, bainguë runji'i baguë. Ja'nca ruinguëbi mai naconi ba'iguë, maini ai yëreba yëguë, te'e ruiñe ba'i coca se'gare maini quëani achoreba achoguë baji'i. Ja'nca ba'iguëna, baguë ta'yejeiye ba'iyete ëñani masihuë yëquëna. Ëñani masijën, Taita Riusu te'eguë Zin sëani, ai ta'yejeiyereba Ëjaguë ba'iji. Ba'iguëna, baguëni ëñajën bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja'nca ba'iguëna, Juan'ga baguëni ëñani, baguë ba'iyete jëja quëani achobi: —Ja'anguëbi ba'iji. Yë'ëbi coca quëani achoguë, baguë ba'iyete yua quëahuë yë'ë: Yë'ë jë'te raiguëbi yë'ë ba'iye'ru quë'rë ta'yejeiye Ëjaguëbi ba'iji, yë'ë'ru quë'rë ru'ru ba'isi'quë sëani, quëani achobi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ja'an Ëjaguë yua maini ai ba'iye ai yëguë ba'iji. Baguë baye si'aye carajeiye beoyete maina insireba insiji. ");
INSERT INTO snnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Riusubi baguë ira coca guansese'ere Moisesni toya güeseni, maina jo'caguë ba'nji. Yureca, Riusubi baguë te'e ruiñe ba'i cocare maina jo'caye yëguë, Jesucristo hue'eguë naconi maina raoni, baguë yëguë ba'iyete maini masi güesebi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Bainbi Riusuni ëñañe yëcuata'an, gare ëñañe porema'iñë. Porema'ijënna, baguë te'eguë Zin, baguë naconi te'e recoyo ba'iguë, ja'anguëbi Riusu ba'iyete maini ye'yoni masi guesebi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yureca, Juanbi Riusu cocarebare quëani achoguëna, judío bain Jerusalén huë'e jobo ba'icuabi Juan ba'iyete senni achaye saoñu cajën, bacua pairi bain, levita bain pairite concua, bacuare Juan ba'iruna guanse saohuë. Saojënna, bacuabi sani, baguë ba'iyete senni achajënna, ");
INSERT INTO snnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","sehuoni, coca bacuani te'e ruiñe quëabi Juan: —Ba Cristo raija'guë, ja'anguë beoyë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sehuoguëna, bacua yua se'e baguëni senni achahuë: —Ja'nca ba'itoca, ¿gueguëguë'ne më'ë? ¿Riusu ira bainguë raosi'quë Elías hue'eguëma'iguë? senni achahuë. Senni achajënna, Juanbi: —Bañë, sehuobi. Sehuoguëna: —Ja'nca ba'itoca, Riusu coca quëani achocaija'guë, ¿ja'anguë ba'ima'iguë më'ë? senni achahuë. Senni achajënna, —Bañë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ja'nca sehuoguëna, bacuabi senreba senni achahuë: —Yureca më'ë ba'iyete yëquënani te'e ruiñereba quëajë'ën. Yëquëna ëja bainbi raojënna, bacuana go'ini më'ë ba'iyete quëaye bayë yëquëna. Ja'nca sëani, më'ë ba'iyete quëato, ¿gue coca yëquënani quëaguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Senni achajënna, sehuobi: —Yë'ë yua bain beo re'otona rani, cocare jëja quëani achoguë, ja'an ba'iguë'ë yë'ë. Riusu ira bainguë raosi'quë, Isaías hue'eguë, baguë coca cani jo'case'e'ru ba'iguë'ë yë'ë. “Mai Ëjaguë raija'guë sëani, mësacua recoyo ro'tayete mame re'huajë'ën” cani jo'caguë ba'iguëna, ja'an ba'iguë'ë yë'ë, sehuobi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sehuoguëna, bacuabi, fariseo bain raosi'cua ba'ijën, ");
INSERT INTO snnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","se'e Juanni senni achahuë: —Yureca, Cristo, Elías, Riusu coca quëani achocaija'guë, ja'ancua beoyë më'ë. Ja'nca beotoca, ¿më'ë queaca ro'taguë, bainni bautizaguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Senni achajënna, Juanbi sehuobi: —Yë'ëbi oco se'gabi bainni bautizayë. Bautizaguëna, yequëbi mësacua jubë naconi ba'iguëna, baguëni huesëyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yë'ë jë'te raiguëbi yë'ë'ru quë'rë ta'yejeiye Ëjaguë ba'iji. Ro yë'ë hua'guëbi gugurini rëanni, baguë guëon ju'iyete ti'jeye ti'añe porema'iñë, caguë sehuobi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juanbi Betania casirute bautizaguë ba'iguëna, baguëni senni achajën raë'ë. Jordán ziaya que ca'nco, ënsëguë eta rai ca'nco, ja'anru baji'i ba huë'e jobo. ");
INSERT INTO snnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ba'iguëna, ja'nrëbi, yequë umugusebi Juanbi Jesusni ti'an raiguëna, ëñani quëabi: —Mësacua ja'anguëni ëñajë'ën. Riusu Raosi'quë'bi. Si'a bain gu'a jucha quëñoni senjoñe ro'ire, oveja huani insiye'ru huani senjosi'quë ba'ija'guë'bi baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yë'ëbi baguë ba'iyete ru'ru quëahuë. “Yë'ë'ru quë'rë ta'yejeiye Ëjaguë, yë'ë'ru quë'rë ru'ru ba'iguëbi yë'ë yo'je raiji” quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yë'ë se'gabi baguë ba'iyete huesëguë ba'iguëta'an, Israel bainbi baguëni ye'yeni masija'bë caguë, oco bautizaguë raë'ë yë'ë, quëabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Quëaguë, ja'nrëbi, se'e yeque coca quëabi: —Yureca, Riusu Espíritubi ju'ncubo'ru gaje meni, baguëna tua raiguëna, ëñahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yuta baguë ba'iyete huesëguë, Riusu coca quëase'ere ro'tahuë yë'ë. Yë'ëre oco bautizaye raoguë, ñaca yë'ëni quëabi Riusu: “Yë'ë bainguëte më'ëna saoguëna, yë'ë Espíritubi baguëna gaje meni, baguëna tuani ba'ija'guë'bi. Ja'anre ëñani, yë'ë Espíritu naconi bautizaja'guëte masijë'ën” yë'ëni quëabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Quëaguëna, Riusu quëase'e'ru güina'ru ba'iguëna, ëñahuë yë'ë. Ja'nca ëñaguë, yua ñaca te'e ruiñe quëani achoyë yë'ë: Ja'anguëbi Riusu Zin ba'iji caguë quëayë yë'ë, cabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ja'nca caguëbi, yua se'e yequë umuguse ba'iguëna, baguë bain concua samucua naconi ba'iguë, ");
INSERT INTO snnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yua se'e Jesusni ëñabi Juan. Jesús yua baru cueñe ganiguëna, Juanbi ëñani quëani achobi: —Ëñajë'ën. Riusu Raosi'quëbi ba'iji. Bain jucha ro'ire oveja misabëna huani boye'ru ba'iye ba'ija'guë'bi, quëani achobi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ja'nca quëani achoguëna, Juanre concua ba samucuabi achani, Jesusna be'tehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Be'tejënna, Jesusbi go'iye bonëni ëñani, bacuani senni achabi: —¿Mësacua guere cu'eye'ne? senni achabi. Senni achaguëna, bacuabi sehuoni senni achahuë: —Ëjaguë, ¿më'ë jaro huë'ere ba'iguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Senni achajënna, —Rani ëñajë'ën, sehuobi. Sehuoguëna, bacuabi baguë naconi sani, baguë ba'i huë'ere ëñani, a las cuatro ba'iye'ru ba'iguëna, baguë naconi bëani ba'ijën na'ijaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ja'ancua samucua, Juan quëani achose'ere achani Jesusni be'tesi'cuare cato, te'eguë yua Andrés hue'eguë baji'i. Simón Pedro yo'jeguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ja'nca ba'iguëbi Jesusni ëñani tëjini, besa huëni baguë ma'yë Simonni cu'ejaji'i. Cu'ejani, tinjani, baguëni quëabi: —Cristo hue'eguëte tinjahuë yëquëna, cabi. Bain cocabi cato, Riusu Raosi'quërebare quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Quëani ja'nrëbi, Simonre Jesusna sani ëñobi Andrés. Sani ëñoguëna, Jesusbi baguëni ëñani, baguëni coca cabi: —Më'ë yua Simón hue'eguë, Juan mamaquë ba'iguëna, më'ëni yua Cefas hue'yoyë yë'ë, cabi. Judío bainbi ja'anre cajënna, yequëcuabi Pedro cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ja'nrëbi, yequë umuguse ñataguëna, Jesusbi Galilea yijana sani, Felipeni tinjani, cabi: —Yë'ëni te'e conguë raijë'ën, caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe yua Betsaida huë'e jobo bainguë baji'i, Andrés, Pedro, bacua ba'i jobo. ");
INSERT INTO snnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ja'nca ba'iguëbi Jesusni conguë saji'i. Ja'nca saiguëbi yua Natanaelni tëhuobi. Tëhuoni, baguëni coca quëabi: —Riusu Raosi'quërebare tinjahuë yëquëna. Moisés, Riusu ira bain raosi'cua, bacuabi baguë ba'iyete toyani jo'cajënna, baguëte tinjahuë yëquëna. Jesús Nazareno hue'eji. José mamaquë'bi baguë, quëabi Felipe. ");
INSERT INTO snnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Quëaguëna, Natanaelbi sehuoguë cabi: —Ro huere coca cayë më'ë. Nazaret huë'e jobona cu'eto, re'o bain beoyë, cabi. Caguëna, Felipe sehuoguë cabi: —Rani ëñajë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Caguëna, sani ti'anjënna, Natanaelbi ti'an raiguëna, Jesusbi baguëte quëabi: —Ëñajë'ën. Israel bainguë te'e ruin recoyo baguëbi raiji. Gare coca coqueye beoye ba'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Caguëna, Natanaelbi: —¿Queaca masiguë'ne më'ë, yë'ë ba'iyete? senni achabi. Senni achaguëna, Jesús sehuobi: —Më'ëbi higo sunquiñëte ñu'iguëna, Felipe yuta më'ëre choimaquëna, më'ë recoyona ëñani masihuë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sehuoguëna, Natanaelbi baguëni quëabi: —Ëjaguë, më'ë yua Riusu Mamaquë ba'iguë'ë. Më'ëbi quë'rë ta'yejeiye Ëjaguë ba'iguë sëani, si'a Israel bainbi më'ëni sehuoye bayë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quëaguëna, Jesusbi baguëni quëabi: —Yë'ëbi më'ëni coca quëaguë: Higo sunquiñë ñu'iguëna, më'ëni ëñahuë yë'ë, ja'an cocare më'ëni quëaguëna, ¿yë'ëni si'a recoyo ro'taguë më'ë? Yë'ë ta'yejeiye masise'ere ëñoguëta'an, më'ëbi yuta quë'rë se'e ta'yejeiye yo'ore ëñaja'guë'ë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Quëani, ja'nrëbi, se'e baguëni coca yihuoguë quëabi: —Mësacuani ganreba yihuoyë yë'ë: Guënamë re'oto anconi saose'e ba'iguëna, Riusu guënamë re'oto yo'o concuabi yë'ëna gajejën, guënamëna mëijën yo'ojënna, ja'anre mësacuabi ëñajën ba'ija'cua'ë, Bainguë'ru Raosi'quërebare sëani, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ja'nrëbi, samute umuguseña ba'iguëna, yequëcuabi huejajënna, Galilea yija bain Caná huë'e jobo ba'icuabi fiestare yo'ojën, Jesús pë'cagote choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Choni, Jesús, baguëre conjën ba'icua naconi, bacuare'ga choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Choisi'cuabi ti'anni ba'ijënna, bisi ëye jo'cha carajeijaquëna, Jesús pë'cagobi baguëni quëago: —Jo'cha si'abi, quëago. ");
INSERT INTO snnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Quëagona, Jesusbi sehuobi: —Mamá, ¿queaca ro'tago, yë'ëre ja'an cago'ne? Bainre yë'ë masiye ëñojaiñe yuta yë'ëre ti'anma'iji, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sehuoguëna, bago yua fiesta aon tëocuani guansego: —Mësacua yua Jesús guanseyete achani yo'ojë'ën, cago. ");
INSERT INTO snnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Cagona, ca'ncorë ëñato, gata ocobëan, te'e ëntë sarabëan, yequë sara te'ebë baji'i. Judío bainbi mame tëno güesejën, ja'anbëanbi oco rutani zoacua'ë. Ochenta litro, cien litro, ja'an ba'ibëan baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ba'iguëna, Jesusbi fiesta aon tëocuani guanseguë cabi: —Que ocobëanna oco buni jo'cajë'ën, cabi. Caguëna, ai bu'iye queoni jo'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jo'cajënna, Jesusbi se'e bacuani guanseguë cabi: —Yua ocobëan re'core eani, fiesta ëjaguëna sani insijë'ën, cabi. Caguëna, ja'nca eani sani insijënna, ");
INSERT INTO snnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","fiesta ëjaguëbi coni na'guni masibi. Bisi ëye jo'cha baji'i. Oco se'gabi jo'cha'ru runquëna, huesëbi. Fiesta aon tëocua oco easi'cua sëani, bacua se'gabi masihuë. Ja'nrëbi, fiesta ëjaguëbi ba huejaguëni choini ");
INSERT INTO snnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","baguëni cabi: —¿Më'ë queaca ro'taguë, quë'rë re'o jo'chare yo'je uncua güeseguë'ne? Fiesta yo'ocuabi ru'ru quë'rë re'o jo'chare uncuayë. Ja'nrëbi, yo'je, bainbi ai jo'chare uncurena, gue gu'a jo'chare uncuayë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yureca, Jesusbi ai ta'yejeiye masiye yo'oni ru'ru ëñoguë, Caná huë'e jobo Galilea yija ba'i jobo ba'iguë ëñoguëna, baguëre conjën ba'icuabi baguë ta'yejeiye ba'iyete ëñani, baguëni si'a recoyoreba ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ro'tajënna, ja'nrëbi, Jesús yua Capernaum huë'e jobona saji'i. Baguë pë'cago, baguë yo'jecua, baguëre conjën ba'icua, bacuabi conjënna, saji'i. Sani, bëani, rëño ba'i umuguseña barute baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ja'nrëbi, judío bain pascua umuguseña ba'iguëna, Jesusbi Jerusalén huë'e jobona saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sani, Riusu huë'ena cacani ëñato, bainbi bonsere negociajën baë'ë. Huaca, oveja, ju'ncubo, ja'anre insijën, curi cojën baë'ë. Curi sa'ñejën cocua'ga baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ja'nca ba'ijënna, Jesusbi bisi za'zabobi re'huani, si'a jubëte si'nseni, Riusu huë'e hue'sena etobi. Etoni, curi sa'ñecua curi so'coñare senjoni saoni, bacua mesañare bo'neni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tonni ja'nrëbi, ju'ncubo insicuani bëinguë cabi: —Ëñe beoru chiani quë'ñejë'ën. Yë'ë Taita huë'ere ro bonse insi huë'ere re'huaye beoye ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ja'nca caguëna, baguë conjën ba'icuabi Riusu coca toyani jo'case'ere ro'tato, ñaca baji'i: “Riusu ba'i huë'ere yua re'o uja huë'ere te'e ruiñe ëñaja'bë caguëna, bacuabi yë'ëni ai bëinja'cua'ë.” Ja'an cocare ro'tahuë, Jesusbi gu'ayete etoguëna. ");
INSERT INTO snnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ja'nrëbi, judío ëja bainbi Jesusna rani, baguëni ai bëinjën, senni achahuë: —¿Më'ë queaca ro'taguë, jo'ya hua'na insicuare etoni saoguë'ne? ¿Nebi më'ëre guanse raore'ne? Riusubi guanseni raotoca, gue yo'o, më'ë ta'yejeiye yo'ore yo'oni yëquënani ëñojë'ën. Ëñotoca, më'ë raosi'quë ba'iyete masiyë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Cajënna, Jesús sehuobi: —Mësacuabi ën huë'e Riusu huë'ere taonni senjotoca, samute umuguseñabi mame huë'ere nëcoyë yë'ë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Caguëna, judío bainbi bëinjën cahuë: —Ën huë'e Riusu jai huë'e yo'ose'ere ro'tato, cuarenta y seis tëcahuëan ba'iguëna, bainbi yo'oni tëjihuë. Ja'nca yo'orena, ¿më'ë queaca samute umuguseña se'gabi nëcoye ro'taguë'ne? cajën sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sehuojënna, Jesusbi ba gata huë'ere ro'tamaji'i. Baguë ga'nihuëte ro'taguë, Riusu huë'e ba'iye'ru ro'taguë, bacuani coca cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja'nca casi'quë sëani, baguë junni tonse'ebi go'ya raiguëna, ja'anrën ti'anguëna, baguëre conjën ba'icuabi baguë yure case'ere ro'tani, Riusu cocareba, Jesús coca cani jo'case'e, si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yureca, Jesusbi Jerusalén huë'e jobore ba'iguë, judío bain naconi pascua umuguseña ro'tani fiesta yo'oguëna, ai jai jubë bainbi baguë ta'yejeiye yo'oni ëñose'ere ëñani, baguëni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ja'nca ro'tacuareta'an, Jesusbi baguë recoyo ro'tayete bacuani masi güesemaji'i, si'a bainni te'e ruiñe masiguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yequëcua bain ba'iye masini quëacuani senni achama'iguë baji'i Jesús. Baguë se'gabi baguë ñacobi ëñani, bain recoyoreba ro'tajën ba'iyete te'e ruiñe masiguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ja'nrëbi, fariseo bainguë Nicodemo hue'eguë, judío bain ëjaguë ba'iguë, ");
INSERT INTO snnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ja'anguëbi huëni, ñamibi Jesusna sani, coca cabi: —Ëjaguë, Riusubi raoguëna, më'ëbi maini ye'yoguë raisi'quë'ë. Raisi'quëbi yua ai ta'yejeiye yo'oni ëñoñë më'ë. Riusubi conma'itoca, ja'anre yo'oni ëñoñe gare porema'ire'ahuë më'ë. Ja'anre ruiñe masiyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Caguëna, Jesusbi sehuobi: —Më'ëni ën cocare ganreba yihuoguë quëayë yë'ë. Bainbi zin hua'na mame të'ya raisi hua'na ba'iye'ru ba'ima'itoca, Riusuni te'e zi'inni ba'iye gare porema'iñë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Caguëna, Nicodemobi coca senni achabi: —Ira hua'guë ba'itoca, ¿queaca se'e mame të'ya raisi hua'guë ruinguë'ne? Baguë mamá guëtabëna se'e cacani, mame të'ya raisi'quë'ru etaye gare porema'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Caguëna, Jesús sehuobi: —Më'ëni ganreba yihuoguë quëayë yë'ë. Bainbi zin hua'na mame të'ya raisi hua'na ba'iye'ru ba'iye yëtoca, oco zoaye'ru Espíritu gaje meñe, ja'anbi mame re'huasi'cua ba'iye bayë. Ja'nca ba'ima'itoca, Riusuni te'e zi'inni ba'iye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bain se'gabi të'ya raitoca, ro bain recoyo ro'taye'ru ro'tajën ba'iyë. Riusu Espíritu gaje meñebi mame të'ya raisi'cua ba'iye'ru ba'itoca, Riusu recoyo ro'taye'ru ro'tajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ja'nca sëani, yë'ë coca yihuose'e: “Zin hua'na mame të'ya raisi hua'na ba'iye'ru mame të'ya raisi'quë ba'ijë'ën” yihuoguë caguëna, ro huesë ëaye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tutubi raiguë, ja'anse'ebi tutuguëna, më'ëbi ba tutu jubëte achayë. Ja'nca achaguëta'an, ba tutu raisirute huesëyë. Ba tutu saisirure'ga huesëyë më'ë. Ja'nca ba'iguëna, Riusu Espíritu gaje meñebi mame të'ya raisi'cua yua tutu ba'iye'ru güina'ru ba'iyë, Nicodemoni yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Caguëna, Nicodemobi se'e senni achabi: —¿Queaca ja'an ba'iye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Senni achaguëna, Jesús sehuobi: —Më'ë yua Israel bain ta'yejeiye ye'yoguë ba'iguëta'an, yë'ë yure yihuose'ere yua ¿guere ye'yemaquë'ne më'ë? ");
INSERT INTO snnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Më'ëni ganreba yihuoguë quëayë yë'ë. Yëquëna achani ye'yese'ere bainni güina'ru quëajën ba'iyë. Yëquëna ëñase'ere bainni güina'ru quëani achoyë. Quëani achojënna, mësacuabi achaye güejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yë'ëbi ën yija re'huani jo'case'e, ja'an ba'iyete mësacuani quëaguëna, mësacuabi yë'ëre ro'tamaë'ë. Ja'nca ro'tama'icuabi, mësacuani Riusu ba'i jobo ba'iyete quëatoca, quë'rë se'e yë'ëni ro'taye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bainbi yua Riusu ba'i jobore huesëcua'ë. Baruna sani ëñacuare cu'eto, gare beoyë. Yë'ë se'ga masiyë, ba jobore. Bainguë'ru Raosi'quëbi Riusu ba'i jobobi gaje rani, baru ba'iyete quëaye poreyë yë'ë, yë'ë ba'i jobo sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ira bainguë ba'isi'quë Moisés hue'eguëbi yua beo re'otore ba'iguë, baguë aña yo'oni te'ntose'ere ëmë tubëna reoni ëñoguë ba'nji. Ja'nca ëñoguëna, yë'ë'ga Bainguë'ru Raosi'quë yua güina'ru ëmëna reosi'quë ba'ija'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ja'nca ba'ija'guëna, si'a bain yë'ëni si'a recoyo ro'tacuabi yua si'arën ba'ijën, gare ju'iñe beoye ba'ija'cua'ë, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yureca, Riusubi si'a bainni ai ba'iye ai yëguë ba'iji. Ja'nca yëguë ba'iguëbi baguë Zin gaña hua'guëre maina raoni jo'cabi. Si'a bain baguë Zinni recoyo ro'tacua, ja'ancuabi huesëni si'ama'iñe caguë, si'arën ba'ijën ju'iñe beoye ba'ija'bë caguë, baguë Zinre ja'nca maina ro'taguë raobi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Raoni, bainre si'nseguëte baguë Zinre re'huamaji'i Riusu. Baguë bainre tëani baja'guë caguë, baguëte re'huani, maina raobi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Riusu Zinni si'a recoyo ro'tatoca, maire bënni senjoñe beoye ba'iji. Ro'tama'itoca, bënni senjoñe se'ga ba'iji, Riusu Zin gaña hua'guëni si'a recoyo ro'tama'icuare sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yureca, Riusu cocarebare quëani achoguëbi mia re'oto ñatani saoye'ru bainna ti'anbi. Ti'anguëna, bainbi mia re'otore ba'iye yëma'iñë. Te'e ruiñe ba'i cocare achaye yëma'iñë. Zijei re'otore ba'iye quë'rë cu'eyë, gu'aye yo'ojën ba'icua sëani. Ja'nca miañe ëñotoca, gu'a recoyo ro'tajën ba'icuare masiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gu'aye yo'ocuabi yua mia re'otona ti'añe güeyë. Bacua yo'ojën ba'ise'ere ëñoñe güejën, gati ëaye se'ga ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te'e ruiñe ba'i cocare achani yo'ojën ba'icua'ga yua Riusu conguë yo'ose'e se'ga ba'iji cajën, mia re'otona ti'anni bacua yo'ojën ba'ise'ere masi güeseye yëyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ja'nrëbi, ba'iguë ba'iguëna, Jesusbi baguëre conjën ba'icua naconi sani, Judea yijana ti'anni bëahuë. Ja'nca bëajën, bainre bautizajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ba'ijënna, Juan'ga Enón casirute ba'iguë, bainbi raijënna, bacuare bautizaguë baji'i, ai oco ba'iru, Salim cueñe ba'irute. ");
INSERT INTO snnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yuta Juanni preso guaomatena, ja'nca bautizaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ja'nca ba'iguëna, baguëre conjën ba'icuabi judío bain naconi bain tëno cocare bëiñe cani, ");
INSERT INTO snnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","yua Juanna sani, baguëni coca bëiñe cahuë: —Më'ë naconi Jordaña que ca'nco ba'isi'quë, ja'an Jesús hue'eguëte ro'tajë'ën. Më'ëbi baguë ba'iyete te'e ruiñe quëani achoguëna, baguë yua bainre bautizaguë ba'iji. Si'a bainbi bonëni baguëna sani, bautiza güesejën ba'iyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Cajënna, Juanbi sehuobi: —Riusubi insima'itoca, bainbi coni baye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yë'ë quëani achose'ere achani masiyë mësacua. “Ba Cristo raija'guë, ja'anguë beoyë yë'ë” quëani achoguë baë'ë yë'ë. Ja'nca ba'iguëbi baguë ru'ru raosi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mësacua yua huejaja'guë ba'iyete ro'tani ye'yejë'ën. Baguë se'gabi ba huejaja'coni baji. Baguë gajeguë consi'quëbi banji. Gajeguëbi yua ca'nco nëcani, huejaja'guë coca bagoni cayete ai bojoguë achaji. Ja'nca ba'iguëna, yë'ë'ga güina'ru ba'iguë, bainbi Jesús naconi saijënna, ai bojoreba bojoyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Baguë se'gabi quë'rë ta'yejeiye Ëjaguë'ru te'e ruiñe baji. Yë'ëca re'hue ba'iguë'ru ruiñe bayë, sehuoguë cabi Juan. ");
INSERT INTO snnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yureca guënamë re'otobi raisi'quëbi quë'rë ta'yejeiye Ëjaguë ba'iji. Yija ba'icuaca yija ba'iye se'gare masijën, ja'an se'gare coca cajën ba'iyë. Guënamë re'oto ba'iguëca quë'rë ta'yejeiyereba Ëjaguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja'nca ba'iguëbi baguë ñacobi ëñase'e, baguë ganjobi achase'e, ja'anre te'e ruiñereba quëani achoji. Quëani achoguëna, si'a bainbi baguë cocare ro achajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Baguë cocarebare achani recoyo ro'tatoca, Riusu yua te'e ruiñe ba'iguë'bi ba'iji cajën, bainni masi güesejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yureca, Riusu Raosi'quëreba ba'iguë, Jesús hue'eguë, baguëbi Riusu cocarebare quëani achoji. Riusu Espíritu ta'yejeiye ba'iyete baguë naconi caraye beoye ba'iguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taita Riusubi baguë Mamaquëni ai yëguë ba'iguë, baguë baye si'ayete baguë Mamaquëna ro insini jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ja'nca sëani, Riusu Zinni recoyo ro'tacuabi si'arën ba'ijën, gare ju'iñe beoye ba'icua'ë. Riusu Zinni achaye güecuabi Riusu naconi si'arën ba'iye gare porema'iñë. Riusu bënni senjose'e se'ga ba'iji bacuare. ");
INSERT INTO snnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ja'nrëbi re'hue, fariseo bainbi achato, Jesusre concua yua Juanre concua'ru quë'rë jai jubëte re'huani babi. Jesusbi yua Juan bautizaye'ru quë'rë jai jubë concuani bautizabi. Ja'anre case'e ba'iguëna, fariseo bainbi achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesusbi bainre bautizamaji'i. Baguëre concua se'gabi bainre bautizajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo bainbi ja'an case'ere achajënna, Jesusbi masibi. Masini, Judea yijabi sani, Galilea yija sai ma'aja'an ganijaji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ja'nca ganijani, Samaria yijabi saiye babi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ja'nca saiguë, ja'nrëbi, Samaria yija huë'e jobo, Sicar casi jobona ti'anbi. Mai ira bainguë ba'isi'quë Jacob hue'esi'quë, baguë yija baguë zin Josena insise'e, ja'an ba'isi yija yua cueñe baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti'anni ëñato, ba oco uncu goje Jacob no'ani jo'casi goje baji'i. Ba'iguëna, Jesusbi ganiguë guajabi. Ënsëguë mëñera së'irën ba'iguëna, ba goje yëruhuana bëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Bëaguëna, baguëre concuabi huë'e jobona aon cojën saisi'cua ba'ijënna, joë ba'irënbi Samaria baingobi oco eago raco'ë. Raigona, Jesusbi: —Oco uncuajë'ën yë'ëre, senji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Senguëna, sehuogo senni achago: —Më'ë judío bainguë sëani, ¿queaca ro'taguë, yë'ë, Samaria baingote oco senguë'ne? cago sehuogo. Judío bainbi Samaria bainni güecuare sëani, ja'nca senni achago bago. ");
INSERT INTO snnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Senni achagona, Jesús sehuobi: —Më'ëbi Riusu re'huani raosi'quërebare masitoca, yë'ëre, oco senguëte masitoca, më'ëbi güina'ru yë'ëni senre'ahuë. Sentoca, bain huajë ocore më'ëna uncuare'ahuë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sehuoguëna, bago cago: —Më'ëbi oco ea maca beoyë. Ai rëi goje sëani, ¿më'ë bain huajë ocore jarona eaguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mai ira bainguë ba'isi'quë Jacobi ën gojere no'ani, yëquënana jo'caguë ba'nquëña. Baguë, baguë mamacua, baguë jo'ya hua'na, si'acuabi ën gojebi eani uncujën ba'ñeña. ¿Ja'nca ba'iguë'ru quë'rë ta'yejeiguë ba'iguë më'ë? cago sehuogo bago. ");
INSERT INTO snnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Cagona, Jesús sehuobi: —Ën gojena eani uncucuabi se'e oco ëaye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yë'ë oco uncuayete coni uncucuabi gare se'e oco ëaye beoye ba'iyë. Yë'ë oco uncuayete coni uncutoca, bacua sanjeiñe yacahuë ba'iye re'huaji bacuare. Bain huajë oco sëani, oco carajeiye beoye ba'iye'ru ba'iguëna, si'arën ba'ijën, ju'iñe beoye ba'iyë bacua, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sehuoguëna, bagobi cago: —Ja'nca ba'itoca, më'ë oco cayere yë'ëna uncuajë'ën. Uncuza. Se'e oco ëama'iñe cago, se'e ën gojena ea raimaco ba'iye, cago. ");
INSERT INTO snnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Cagona, Jesusbi: —Ru'ru, më'ë ënjëre choijani raigo rajë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Caguëna: —Ëmë beogo'ë yë'ë, sehuogo. Ja'nca sehuogona, Jesús cabi: —Te'e ruiñe quëahuë më'ë, Ëmë beogo'ë casi'co sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Më'ë yua te'e ëntë sara ënjë sanhuëni basi'co ba'igona, më'ë yure ëmëguë baguë yua më'ë ënjëre'ru ro'tama'ijë'ën. Ja'nca sëani, te'e ruiñe quëahuë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Caguëna, bagobi quëquëni achago rëingo sehuogo: —Më'ëbi Riusu coca masini quëacaiye'ru ba'iye yë'ëre ëñoñë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yëquëna ira bain ba'isi'cuabi yua ën cubëna mëni, Riusuni gugurini rëanjën ba'nhuë. Më'ë bainbi, Riusuni gugurini rëañe yëtoca, Jerusalén huë'e jobo se'gana saiye poreyë, cayë, cago bago. ");
INSERT INTO snnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Cagona, Jesús yua bagoni yihuoguë cabi: —Yë'ëbi coca yihuoguëna, ro'tago ba'ijë'ën. Yurera, bainbi Taita Riusuni gugurini rëañe yëjën, ën cubëna mëima'iñë. Jerusalenna saima'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Më'ë bainbi gugurini rëanjën, bacuabi Riusuni ro'taye huesëyë. Yë'ë bainca Riusuni ro'taye masiyë. Riusubi judío bainre cuencueni, baguë tëani baja'guëre bacua jubë ba'iguëte cuencueni re'huabi. Ja'nca sëani, judío bainbi Riusuni te'e ruiñe ro'taye masiyë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ja'nca ba'iyeta'an, yurera, bainbi Taita Riusuni gugurini rëañe yëtoca, gugurini rëanrute cu'ema'iñë. Baguëni si'a recoyo ro'tajën, baguëni te'e ruiñe recoyo bojojën ba'iye bayë. Ja'nca baguëni ro'tajën bojocuare cu'eji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Riusubi yua ro bain ga'nihuë beoguëna, baguëni ëñañe porema'iñë mai. Ja'nca sëani, baguëni bojojën catoca, baguëni si'a recoyo ro'tajën, baguëni te'e ruiñe recoyo bojojën ba'iye bayë, caguë yihuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yihuoguëna, bagobi cago: —Riusu Raosi'quëreba, Cristo hue'eguë, ja'anguëbi maina raiye ba'iji. Ja'anre masiyë yë'ë. Ja'nca rani, maini si'ayete masi güeseja'guë'bi, cago sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sehuogona, Jesusbi quëabi: —Yë'ë yua ba Cristo ba'iguë'ë. Më'ë naconi coca caguëbi ja'nca hue'eyë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Quëaguëna, ja'ansirën Jesusre concuabi raë'ë. Rani, romigo naconi coca caguëna, bacuabi ëñajën rën'ë. Ëñajën rëincuabi bacuani coca senni achaye huaji yëhuë. Bagoni, ¿më'ë gue raco'ne? senmaë'ë. Baguëni, ¿gue coca bago naconi caguë'ne më'ë? senmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ja'nca cama'ijënna, bago yua bago ocobëte ro jo'cani senjoni ñoni, huë'e jobona goco'ë. Go'ini, baru bainni quëago: ");
INSERT INTO snnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Raijë'ën. Saiñu. Masi Ëjaguëte ëñajaiñu. Yë'ë yo'ogo ba'ise'e si'ayete masini, yë'ëni te'e ruiñe quëabi. Ja'nca ba'iguëbi ¿Riusu Raosi'quëma'iguë yequërë? cago quëago. ");
INSERT INTO snnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Cago quëagona, huë'e jobo bainbi Jesusni ëñajën sai bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ja'nrëbi, Jesusre concuabi baguëni coca guansejën baë'ë: —Aonre inni ainjë'ën, Ëjaguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Cajënna, baguëbi sehuobi: —Yeque aon bayë yë'ë. Mësacuabi ja'an aonre huesëyë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sehuoguëna, sa'ñeña senni acha bi'rahuë: —¿Queaca? ¿Yequëcuabi rani, aon insimate baguëna? sa'ñeña senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Senni achajënna, Jesusbi coca quëabi: —Banhuë. Riusu aonre cayë. Baguë yëye'ru yo'oye yë'ëre raobi. Raoguëna, baguë yo'o guansese'ere beoru yo'oguë, ai ba'iye ai recoyo bojoyë yë'ë. Ja'nca sëani, aon anni yajiye'ru ba'iji yë'ë recoyote. ");
INSERT INTO snnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yureca, mësacua bain coca cani jo'case'ere ro'tato, ñaca cajën ba'iyë: “Gajese'ga ñañaguëan bani, aon tëarënbi ti'anji” cajën ba'iyë. Cajën ba'ijënna, yë'ëca yeque cocare yihuoguë quëayë: Mësacua yua querure ëñajë'ën. Queru aon tanse'ebi yuara ya'jise'e sëani, yua tëaye ba'iji. Riusu ba'i jobo cu'ecuare tëani bayë cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zio ëjaguëte tëacaicuabi baguë ro'ise'ere coni bayë. Güina'ru, yë'ëre concuabi, bainbi si'arën ba'ijën, ju'iñe beoye ba'ija'bë cajën, bainni yë'ë ba'i jobore cu'e güesejënna, yë'ëre concuani premiote ro'iyë yë'ë. Ja'nca si'arën ba'ijënna, yë'ë aon tansi'cua, yë'ë aon tëasi'cua, yë'ëre conjën ba'icua caguë, si'acuabi ñë'cani, yë'ë ba'i jobona ti'ansi'cuare ëñani, te'e bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ja'nca sëani, te'e ruiñe cani jo'case'e ba'iji: “Yequëbi aonre tanguëna, yequëbi tëaji” cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mësacuabi bainni ru'ru ye'yoma'isi'cuata'an, bain recoyo ro'tayete ru'ru conjën ba'iyë mësacua, caguë yihuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ja'nrëbi, Samaria baingobi bago bainni coca quëani achogo: “Yë'ë yo'ogo ba'ise'e si'ayete masini yë'ëni te'e ruiñe quëabi” ja'anre quëani achogona, ai jai jubë bain ba Samaria huë'e jobo ba'icuabi Jesusni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ja'nca ro'tajën, baguëna sani, Yëquëna naconi bëani ba'ijë'ën, cajën choë'ë. Choijënna, samu umuguseña bacua naconi bëani baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ja'nca ba'iguëbi baguë cocarebare quëani achoguëna, yequëcua'ga ai jai jubëbi achani baguëni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ja'nca ro'tajën, ba romigoni cahuë: —Yua baguëni si'a recoyo ro'tajën bojoyë yëquëna. Më'ë cocare achani baguëni si'a recoyo ro'tasi'cuata'an, yureca ja'ansi'quëbi baguë cocarebare quëani achoguëna, yëquënabi achajën, baguëni si'a recoyo ro'tajën, quë'rë ai ta'yejeiye bojojën ba'iyë. Baguë ba'iyete ai bojojën ba'iyë. Baguë ba'iyete masini, Bain tëani baguëreba ba'iji cajën, bojojën ba'iyë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ja'nrëbi, samu umuguseña ba'ini, Jesusbi Galilea yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Riusu raosi'cuabi bacua bain quë'rona saitoca, bacua bainbi bacuani te'e ruiñe ëñama'iñë, case'e baji'i. Jesús yua ja'ansi'quëbi ja'an cocare caguë baji'i. Ja'nca sëani, Galilea yijana saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sani ti'anguëna, Galilea bainbi baguëni ai bojohuë, Jerusalén huë'e jobo fiesta yo'ojën saisi'cua sëani, Jesús yo'oguë ba'ise'ere, ja'anrute ba'ijën, ëñani bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ja'nrëbi, se'e sani, Caná huë'e jobona ti'anbi, Galilea yija huë'e jobo. Oco se'gabi bisi ëye jo'chare re'huabi ja'anru. Ti'anni ba'iguëna, yequë huë'e jobo bainguë, Capernaum casiru, baru ba'i ëjaguëbi baji'i. Ja'nca ba'iguëbi, baguë mamaquëbi rau neni ju'inguëna, ");
INSERT INTO snnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús ti'anni ba'iyete achabi. Judea yijabi rani, Galileana ti'anni ba'iyete achani, yua Jesusni ëñaguë saji'i. Sani, baguë zinre rani huachoye senji'i, ai ju'in hua'guëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Senguëna, Jesusbi baguëni sehuobi: —Yë'ëbi ta'yejeiye yo'oni ëñoma'itoca, mësacuabi yë'ëni te'e ruiñe recoyo ro'tama'iñë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sehuoguëna, ba ëjaguëbi jëja senji'i: —Besa rani conjë'ën, Ëjaguë. Yë'ë zinbi yuara junni huesëguë ba'iji, caguë senji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Senguëna, Jesús yua baguëni quëabi: —Yua më'ë huë'ena go'ijë'ën. Më'ë zinbi huajëji, caguë quëabi. Quëaguëna, baguëbi achani, Jesús coca quëase'ere recoyo ro'tani goji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Go'ini ti'anguëna, baguëre yo'o concuabi baguëni tëhuojën raë'ë. Rani: —Më'ë zinbi huajë raji'i, cajën quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Quëajënna, baguë hora huajë bi'rase'ere senni achabi. Senni achaguëna, sehuohuë: —Na'itë, mëñera ënsëguë së'irën ba'iguë, se'e te'e hora cuencuejënna, baguë rau jayoye tëji'i, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ja'nca sehuojënna, ëjaguëbi ba horate ro'tani, Jesús quëase'e: “Më'ë zinbi huajëji” ja'an coca ja'ansi hora Jesús quëase'e sëani, ai ro'tani bojobi baguë. Ja'nca ba'iguëna, baguë, baguë huë'e bain, si'acuabi Jesusni si'a recoyo ro'tajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja'nca baguëte huachobi Jesús. Judeabi sani Galileana rani ba'iguëbi ta'yejeiye yo'ore yo'oni ëñoguë, ba huachose'e yua baguë samu ba'i yo'o baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ja'nrëbi, jë'te, judío bainbi se'e fiesta yo'ojënna, Jesusbi Jerusalenna saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yua Jerusalén huë'e jobo anto sa'ro, Oveja casi sa'arobi cacani ëñato, oco goje, bain abu goje ba'iji. Hebreo cocabi cato, Betzata casiru ba'iji. Te'e ëntë sara huë'erëan ba goje yëruhua të'ijeiye nëcosi huë'erëan ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ja'nca ba'iguëna, ai jai jubë bain rauna ju'incuabi ba huë'erëanre uinjën baë'ë. Yequëcuabi ñaco ëñama'icua baë'ë. Yequëcuabi ca'jacua baë'ë. Yequëcuabi guë'nguë rauna ju'injën baë'ë. Ja'nca ba'icuabi oco somoja'ñete ëñajën ëjohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Riusu anjebi somo güeseguëña. Anje yësirënbi gajeni, oco somo güeseguëña. Somo güeseguëna, oco gojena ru'rureba cacaguëbi yua baguë gue gu'a rau tëcani huajë raiguëña. ");
INSERT INTO snnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ja'nca ba'iguëna, yequë bainguë treinta y ocho tëcahuëan ju'inguë ba'i hua'guëbi barute ëjobi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ëjoguëna, Jesusbi ti'anni, baguëte ëñabi. Ëñani, Chao hua'guë ai zoe ju'inguëbi uinji caguë, baguëni coca senni achabi: —¿Huajëguë ruiñe yëguë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Senni achaguëna, ju'inguëbi sehuobi: —Oco gojena besa cacaye porema'iñë yë'ë hua'guë. Ocobi somoguëna, yë'ëre cacaye conguëbi beoji. Beoguëna, caca ëaye ba'iguëta'an, yequëbi ru'ru ti'anni cacaji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sehuoguëna, Jesusbi coca guansebi: —Yua huëni nëcajë'ën. Më'ë camabëte inni saijë'ën, guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Caguëna, ja'ansirën huajë raji'i baguë. Huajë rani, baguë camabëte inni huëni saji'i. Judío bain yo'o yo'oma'i umuguse baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Saiguëna, judío ëja bainbi huajë raisi'quëni tëhuoni, baguëni bëin coca cahuë: —Yo'o yo'oma'i umuguse ba'iguëna, më'ë camabëte cuanma'ijë'ën, ira coca ënseye case'e sëani, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cajënna, sehuobi: —Yequë bainguëbi yë'ëre huachoni, “Më'ë camabëte inni saijë'ën” caguë guanseguëna, raiyë yë'ë, sehuobi baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sehuoguëna, baguëni senni achahuë: —¿Jaro bainguëbi më'ëni ja'nca guanseguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Senni achajënna, sehuoye poremaji'i. Baguë rau huachosi'quëre huesëbi. Ai jai jubë bain ba'ijënna, Jesusbi yequëruna quëñëni saisi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Saisi'quëbi jë'te rani, Riusu huë'ena cacani, ba huajë raisi'quëni tëhuobi. Tëhuoni, baguëni coca yihuoguë cabi: —Yua huajë raisi'quë ba'iyë më'ë. Ja'nca ba'iguë, yua se'e gu'aye yo'oye beoye ba'ijë'ën. Gu'aye yo'otoca, yequërë ru'ru ba'ise'e'ru quë'rë ai ja'si yo'oguë'ru ruinma'iñe, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Caguëna, baguë yua judío ëja bainna sani quëajaji'i. Jesús hue'eji baguë, yë'ëre huachosi'quë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ja'nca quëaguëna, judío ëja bainbi bëinjën, Yo'o yo'oma'i umugusebi baguë yo'o yo'oguëna, baguëni je'o ba bi'rahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Je'o ba bi'rajënna, Jesusbi bacuani coca quëabi: —Yë'ë Taitabi yurerën tëca baguë yo'ore yo'oguë ba'iji. Güina'ru yë'ë'ga yë'ë yo'ore yo'oguë ba'iyë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja'nca quëaguëna, judío ëja bainbi quë'rë bëinjën, baguëni huani senjo ëayete quë'rë yëhuë. Bacua yo'o yo'oma'i umugusebi yo'oye porema'iñete tin yo'oguëna, baguëni ai je'o bahuë. Baguë coca case'ere'ga achani, quë'rë se'e baguëni je'o bahuë. Baguë yua Riusubi yë'ë Taita ba'iji caguëna, bacuabi bëinjën, Riusu ba'iye'ru te'e ba'iyë catoca, ai gu'aye caji baguë, ro'tajën achani bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bëinjënna, Jesusbi bacuani sehuoguë quëabi: —Mësacuani ganreba quëayë yë'ë. Yë'ë yua Riusu Zin ba'iguëbi ro yë'ë yëse'e yo'oma'iguë'ë. Yë'ë Taitabi yo'o yo'oguëna, ja'anre ëñani, ja'an yo'o se'gare yo'oyë yë'ë. Baguë Zin sëani, baguë yo'o yo'oye güina'ru yo'oguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Baguë Zinre sëani, yë'ë Taitabi yë'ëni ai yëguë, yë'ëni bojoguë, baguë yo'o yo'oye si'ayete yë'ëni ëñoji. Ja'nca ëñoni, yë'ëbi ta'yejeiye yo'ore yo'oni ëñoguëna, baguë yua quë'rë se'e quë'rë ta'yejeiye yo'ore yë'ëni ëñoji. Mësacuabi jai ñacobi ëñajën rëinjën ba'ijë'ën caguë, ja'nca yë'ëni ëñoji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yë'ë Taitabi bain junni huesësi'cuare huajëcuare mame re'huaguë sëani, yë'ë'ga yë'ë yëye'ru bainre güina'ru huajëcuare mame re'huaye poreyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yë'ë Taita se'gabi bain gu'a jucha yo'ojën ba'ise'ere bacuani sehuo güesema'iji. Ja'an sehuo güeseye si'aye yë'ëna jo'cabi, yë'ë yua baguë Zinre sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Si'a bainbi yë'ë Zinni te'e ruiñe ëñajën ba'ija'bë caguë jo'cabi baguë. Taitani te'e ruiñe ëñajën ba'iye'ru, yë'ë Zinni güina'ru te'e ruiñe ëñajën ba'ija'bë caji. Yë'ëni te'e ruiñe ëñama'itoca, yë'ë Taitani güina'ru te'e ruiñe ëñamajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mësacuani ganreba caguë quëayë yë'ë. Yë'ë cocarebare achani yë'ëre raosi'quë ba'iyete ro'tacua, ja'ancuabi si'arën ba'ijën, gare ju'iñe beoye ba'iyë. Gare bënni senjoñe beoye ba'iji bacuare. Riusu naconi ba'ijën, carajeiye beoye huajëcua se'ga ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mësacuani ganreba quëayë yë'ë. Yë'ë bain choirënbi yuara ti'anja'ñeta'an ba'iji. Ja'nca choiguë, Bainguë'ru Raosi'quëre sëani, bainbi recoyo ju'inse'e'ru ba'icuata'an, yë'ë choiyete achayë. Achatoca, recoyo mame huajë rani ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yë'ë Taita ja'ansi'quëbi si'arën ba'iguë, bain si'arën ba'iye re'huaye masiji. Yë'ë'ga baguë Zin sëani, si'arën ba'iguë, bain si'arën ba'iye re'huaye masiyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ja'nca ba'iguë yë'ë Taitabi cuencueni raoguëna, yë'ë, Bainguë'ru Raosi'quëbi bain juchare ëñani, bacuani sehuoye senja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ja'nca ba'iguëna, mësacua yua yë'ë cocare achajën rëinma'ijë'ën. Yurera bain ju'insi'cua tan gojeñana tansi'cua, ja'ancuani choiguëna, bacuabi rani, yë'ëni achajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Achani, yë'ëna rani nëcaja'cua'ë. Re'oye yo'ojën ba'isi'cuabi go'ya rani, se'e ju'iñe beoye ba'ijën, Riusu naconi si'arën ba'ija'cua'ë. Gu'aye yo'ojën ba'isi'cuabi go'ya rani, Riusu bënni senjoruna sani, ai yo'ojën, ja'anrute si'arën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yë'ë se'gabi guanseza catoca, guanseye gare porema'iñë yë'ë. Yë'ë Taitabi guanseguëna, baguë cocare achani baguë cuencuese'e'ru güina'ru bainni masi güeseyë. Ja'nca masi güeseguë, bain juchare te'e ruiñe masini bacuare bënni senjoja'ñete te'e ruiñe cayë yë'ë. Yë'ë yëye se'ga yo'oye ro'tama'iñë. Yë'ë Taitabi yë'ëre raosi'quë sëani, baguë yëye se'gare yo'oye ro'tayë yë'ë. Ja'nca sëani, bainre bënni senjoja'ñete te'e ruiñe cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yë'ë se'gabi yë'ë ba'iyete quëani achotoca, yë'ë guanseye poreyete te'e ruiñe masi güesema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yequë'ga yë'ë ba'iyete quëani achoji. Ja'an quëani achoguëbi, yë'ë guanseye poreyete yë'ëre te'e ruiñe masi güeseji. Ja'anguëbi yua yë'ë Taita ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mësacua yua Juanna coca saoni senni achajënna, baguë yua te'e ruin cocare masini, te'e ruiñe quëani achoguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ja'nca sehuoguëna, ro bain quëani achose'e se'gare ro'tama'iñë yë'ë. Ro'tama'iguëta'an, mësacua mame recoyo re'huasi'cua ba'ijë'ën caguë, Juan quëani achose'ere mësacuani yihuoguë quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan yua majahuë re'oye miañe'ru, mësacua te'e ruiñe sai ma'are ëñoguëna, baguë ëñose'ere ëñajën, rëño ba'irën bojojën achahuë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bojojën achajënna, yë'ë ta'yejeiye yo'oni ëñoguë, Juan coca case'ebi ëñoñe'ru yë'ë ba'iyete quë'rë te'e ruiñe ëñoni, yë'ë guanseye poreyete masi güeseyë yë'ë. Yë'ë ta'yejeiye yo'oni ëñoguë, yë'ë Taitabi yo'o güeseguëna, ja'nca yo'oni ëñoñë yë'ë. Ja'nca yo'oni ëñoguëna, bainbi yë'ë Taita Raosi'quërebare yë'ëre masiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yë'ë Taita'ga yë'ëre raoni, yë'ë ba'iyete te'e ruiñereba ëñoguë baji'i. Baguëbi coca quëani achoguëna, mësacuabi baguëte gare achama'icua'ë. Baguë ba'iyete gare ëñama'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yë'ë yua Riusu Raosi'quë ba'iguëna, yë'ë cocare recoyo ro'tamajën ba'icua'ë mësacua. Ja'nca sëani, baguë cocarebare yua mësacua recoñoa re'huaye beoye ba'icua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Baguë cocareba toyani jo'case'ere bojora'rë ëñajën, Riusu naconi si'arën ba'iñu cajën, ba coca se'gare ai ba'iye ai ye'yeyë mësacua. Ye'yecuata'an, yë'ë ba'iyete baru te'e ruiñe ëñose'ere gare ye'yema'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yë'ë ba'iyete ye'yeye porecuata'an, yë'ëna rani recoyo ro'taye gu'a güeyë mësacua. Rani recoyo ro'tatoca, Riusu naconi si'arën ba'ire'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Re'o coca yë'ëre quëani achocua, ja'ancuani yëma'iñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mësacua recoyo ro'tayete masiyë yë'ë. Masiguëna, mësacua se'gabi Riusuni ai yëmajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yë'ë Taitabi yë'ëre cuencueni raoguëna, yë'ëni te'e ruiñe ëñamajën, bojomajën ba'iyë mësacua. Ro yequë se'gabi rani, mësacua ta'yejeiye ëjaguë'ë yë'ë catoca, ja'anguëni te'e ruiñe ëñajën bojojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mësacua sa'ñeña se'ga te'e ruiñe ëñajën bojocuabi Riusu ta'yejeiye ba'iyete cu'eye beoye ba'iyë. Ja'nca sëani, yë'ëni recoyo ro'taye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","¿Mësacua guere ro'taye'ne? ¿Yë'ëbi Taita Riusu naconi coca caguë, mësacua gu'aye yo'oyete quëani, mësacuare bënni senjoja'ñe, Riusuni señe, ja'anre ro'taye mësacua? Bañë. Mësacuabi ñaca cacua'ë, Ira taita ba'isi'quë Moisés, baguë coca toyani jo'case'ere te'e ruiñe yo'ocua sëani, Riusu naconi si'arën ba'ija'cua'ë cayë mësacua. Ja'nca cacuata'an, Moisés se'gabi mësacua gu'aye yo'oyete Riusuni quëani, mësacuare bënni senjoja'ñe senji. ");
INSERT INTO snnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mësacua yua Moisés coca toyani jo'case'ere ëñajën, te'e ruiñe ye'yemaë'ë. Te'e ruiñe ye'yeni, baguë quëani jo'case'ere recoyo ro'tanica, yë'ë coca te'e ruiñe quëani achose'ere ro'tajën ba'ire'ahuë, yë'ë ba'iyete quëasi'quë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moisés coca toyani jo'case'ere ro achani recoyo ro'tama'icua sëani, yë'ë coca yure quëani achoguëna, ja'an cocare quë'rë ai ba'iye recoyo ro'tama'iñë mësacua, bacuani yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ja'nrëbi, Galilea zitara, Tiberias zitara'ga hue'eguëna, ja'anruna saisi'quë ba'iguë, yua que të'huina jenni saji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Saiguëna, ai jai jubë bainbi, Jesús ta'yejeiye yo'oni ëñose'e, rau ju'incuare huachose'e, ja'anre ëñasi'cua sëani, Jesusni be'tejaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Be'tejaijënna, Jesús yua baguëre conjën ba'icua naconi cu re'otona saisi'quëbi bacua naconi baruna bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judío bain pascua umuguseña fiesta yo'oye baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bëani ba'iguë, so'ona ëñato, bain jubëbi raë'ë. Raijënna, Jesús yua Felipeni coca senni achabi: —¿Queaca aon coni, ja'an bain jubëni aon aoñe'ne mai? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Senni achaguë, ¿Felipe queaca sehuoja'guë'ne baguë? caguë, ja'an cocare senni achabi Jesús. Baguë yo'oja'yete yua ro'tasi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Senni achaguëna, Felipe sehuobi: —Aon coni aoñe ti'anma'iji maire. Curi so'co samu cien ro'iye coni huo'huetoca, ga bainguëbi choa zi'nga se'gare coji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sehuoguëna, ja'nrëbi, Andrés hue'eguëbi baji'i. Jesusni conguë ba'iguë yua Simón Pedro yo'jeguë baji'i. Ja'anguëbi coca quëabi: ");
INSERT INTO snnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ënjo'on ba'iji zin hua'guë. Te'e ëntë sara jo'jo aonbëan cebadabëan, samu ziaya hua'i, ja'anre baji baguë. Ja'nca ba'iguëta'an, ¿queaca ja'an se'gabi si'a jai jubëre aon aoñe'ne? senji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Senguëna, Jesusbi: —Bainni bëa güesejë'ën, cabi. Caguëna, taya re'oto ai ba'iye sëani, bëa güesejënna, si'acuabi bëahuë. Ëmëcua se'gare cuencueto, cinco mil ba'icua'ru baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bëajënna, ja'nrëbi, Jesús yua ba cebadabëanre inni, Riusuni surupa cani, baguëre concuana insiguëna, bainna huo'huehuë. Ziaya hua'ire'ga inni güina'ru huo'hue güeseguëna, bacua yëse'e aën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Anni yajijënna, Jesús yua baguëre concuani coca guansebi: —Aon anni jëhuase'ere chiani re'huajë'ën. Jo'cani senjoñe beoye ba'ijë'ën, guanseguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Caguëna, cebada aon anni jëhuasi mi'chirëanre chiani, doce jë'eña bu'iye ayahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ja'nca ayajënna, bainbi Jesús ta'yejeiye yo'oni ëñose'ere ai ëñajën rëinjën, sa'ñeña cahuë: —Riusu bainguë maina raoja'ye cani jo'case'e ba'iguëna, yureca maina ti'ansi'quë ba'iji, cajën ëñajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ëñajën rëinjën, sa'ñeña coca cajën, baguëni zeanni sani, mai ta'yejeiye ëjaguëre baguëte re'huani bañu cajënna, Jesusbi masini, cu re'otona quëñëni, te'e hua'guë ba'iguëbi ganini saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Saiguëna, ja'nrëbi, ënsëguë ruajairën ba'iguëna, Jesusre concuabi zitara yëruhuana gajehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Gajeni, Jesús yuta raimaquëna, Capernaum huë'e jobona go'iñu cajën, yoguna cacani, zitara je'en bi'rahuë, ñamibi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Je'en bi'rajënna, ja'nrëbi, ai jëja tutuni, të'a huëji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Huëiguëna, cinco o seis kilómetro ba'iye ro'ani ëñato, Jesusbi zitara canja'an ganiguë raji'i. Ja'nca raiguëna, ai quëquëni huesëni ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Huesëni ëñajënna, baguë cabi: —Mësacua quëquëma'ijë'ën. Yë'ë yua Jesus'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Caguëna, ja'nrëbi, bacuabi ai bojojën, baguëni yua yoguna guaoni bahuë. Guaoni bajënna, ja'ansirën bacua yija sairuna ti'ansi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ja'nca ba'ijënna, yequë umuguse ñataguëna, bain jubëbi yuta que të'hui baë'ë. Jesús aon aonsiru, surupa cani aon huo'huesiru, ja'anrute baë'ë. Ba'ijën, zitara yëruhuana gajeni ëñato, Jesusre concua yua bacua yogubi saisi'cua baë'ë. Bacua se'gabi saijënna, Jesusbi bacua naconi saimaji'i cajën, gue ro'taye beoye baë'ë. Ba'ijënna, yequë bain Tiberias huë'e jobobi rani ba'ijënna, ");
INSERT INTO snnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesús, baguëre concua, bacua yua beoyë cajën, ba bain naconi yobi saë'ë. Capernaum huë'e jobona jenni, Jesusre cu'ejaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cu'ejani, je'ensi'quëre tinjahuë. Tinjani, baguëni senni achahuë: —Ëjaguë, ¿quejeito më'ë raquë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Senni achajënna, sehuobi: —Mësacuani ganreba quëayë. Yë'ë ta'yejeiye yo'oni ëñose'ere ro'taye beoye ba'iyë mësacua. Ro mësacua aon anni yajise'e se'gare ro'tani, yë'ëre cu'ehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mësacua aon coye ro'ire jëja yo'o yo'oye beoye ba'ijë'ën, besa carajeiye sëani. Yë'ë aon insiye, ja'anre ro'tani, yo'o yo'oni cojë'ën. Coni aintoca, si'arën ba'ijën, huajëreba huajëjën ba'iyë mësacua. Yë'ë yua Bainguë'ru Raosi'quërebare sëani, Taita Riusubi yë'ë ta'yejeiye yo'oye conji, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sehuoguëna, baguëni senni achahuë: —Riusu yo'o guansese'ere yo'oye yëtoca, ¿queaca yo'oye'ne yëquëna? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Senni achajënna, Jesús sehuobi: —Riusu yo'o guansese'e yua ëñe ba'iji. Yë'ë yua baguë raosi'quërebare sëani, yë'ëni si'a recoyo ro'tajën ba'ijë'ën, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sehuoguëna, baguëni senni achahuë: —Ja'nca ba'itoca, më'ë ta'yejeiye yo'ore yo'oni, yëquënani ëñojë'ën. Më'ë poreyete ëñañu cayë. Ëñani, ja'nrëbi, më'ëni recoyo ro'tayë yëquëna. ¿Gue yo'ore yo'oni ëñoguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mai ira bain ba'isi'cuabi beo re'otore ba'ijën, ba maná aonre ainjën ba'ñeña. Riusu coca toyani jo'case'e'ru ba'iye: Guënamë re'otobi aon tonni, bacuani aon aonguë baji'i Riusu, case'e sëani, më'ë'ga ¿gue yo'ore yo'oni ëñoguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Senni achajënna, Jesusbi bacuani yihuoguë quëabi: —Mësacuani ganreba yihuoguë quëayë yë'ë. Moisés aon guënamëbi to'inse'ere aintoca, bainbi huajëreba huajëmaë'ë. Yë'ë Taita se'gabi te'e ruiñe ba'i aonre insiji. ");
INSERT INTO snnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yë'ë Taitabi baguë aonre guënamë re'otobi raoni jo'cabi. Raoni jo'caguëna, bainbi coni aintoca, huajëreba huajëyë bacua, yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Quëaguëna, bacua senni achahuë: —Ëjaguë, ja'an aonre yëquënana jo'caye beoye insireba insijë'ën, senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Senni achajënna, sehuobi: —Yë'ëbi yua ja'an aon ba'iyë. Yë'ëna rani aintoca, aon gu'aye beoye ba'iye'ru ba'iyë. Yë'ëni si'a recoyo ro'tatoca, oco ëaye beoye ba'iye'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yureca, mësacuani ëñere quëahuë. Yë'ëni ëñasi'cuata'an, yë'ëni recoyo ro'tama'iñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yë'ë Taita bain cuencuesi'cuare si'acuare yë'ëna raoguëna, si'acuabi yë'ëna raiyë. Raijënna, yë'ëbi bacuani bani, bacuare gare senjoñe beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yë'ë yua guënamë re'otobi raiguë, yë'ë yëye se'ga yo'oza camaë'ë. Yë'ëre raosi'quë, baguë yëye se'gare yo'oza caguë raë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yë'ëre raosi'quë, baguë yëyete cato, ëñe ba'iji: Baguë bain cuencuesi'cuare yë'ëna raoguëna, te'e bain hua'guëreta'an gare huesoye beoye ba'iyë. Ja'nca ba'iguëbi, ën yija carajei umuguseña ti'anguëna, si'acua ju'insi'cuare mame go'ya rai güeseja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yë'ë Taita yëyete cato, ëñe ba'iji: Yë'ëbi baguë Zin sëani, si'a bain yë'ëni recoyo ro'tajën ba'icuabi si'arën ba'ijën, ai huajëreba huajëjën ba'ija'cua'ë. Ën yija carajei umuguseña ti'anguëna, bacuare mame go'ya rai güeseja'guë'ë yë'ë, caguë sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Caguë sehuoguëna, judío ëja bainbi baguë coca case'e: “Yë'ë yua guënamë re'otobi raisi'quë'ë. Si'a bain aon ba'iyë yë'ë” ja'an case'ere achani, baguëte sa'ñeña ai ");
INSERT INTO snnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","bëinjën cahuë: —¿Queaca ro'taguë caguë'ne baguë? Ba hua'guë Jesús hue'eguë yua José mamaquë se'ga ba'iji. Baguë taita, baguë mamá, bacuare masiyë mai. Ja'nca sëani, ¿queaca ro'taguë, Guënamë re'otobi raisi'quë'ë yë'ë caguë'ne? bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Cajënna, Jesusbi cabi: —Mësacua sa'ñeña cajën, yë'ëre bëin coca caye jo'cajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ro bain se'gabi yë'ëna rani recoyo ro'taye porema'iñë. Yë'ë Taitabi yë'ë ba'iyete ëñoguëna, bainbi yë'ëna raiye poreyë. Raijënna, yua ën yija carajei umuguseña ti'anguëna, yë'ëbi yë'ë bainrebare mame go'ya rai güeseja'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Riusu ira bain raosi'cua toyani jo'case'ere ro'tajë'ën. “Riusubi si'a bainni cocare ye'yoji.” Ja'nca toyani jo'case'e sëani, si'acua Riusu ye'yose'ere achani ye'yecuabi yë'ëna raiyë. Raijënna, yë'ë bainrebare re'huani ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bainbi Taita Riusure gare ëñama'isi'cua ba'iyë. Yë'ë se'ga baguë ba'irubi raisi'quëbi yë'ë Taitare ëñasi'quë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ganreba caguë, mësacuare quëayë yë'ë. Yë'ëni recoyo ro'tacua, ja'ancuabi yë'ë naconi si'arën ba'ijën, huajëreba huajëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yë'ë yua bain aon ba'iguëbi bacuani huajëreba huajë güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mësacua ira bain ba'isi'cuabi beo re'otore ba'ijën, maná aonre ainjën baë'ë. Ba'icuabi ja'an aonre ainsi'cuata'an, yurera junni huesësi'cua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yequë aonre cayë yë'ë. Ja'an aonre guënamë re'oto raose'e ba'iguëna, bainbi aintoca, ju'iñe beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yë'ë yua ja'an aon ba'iyë. Huajëreba huajë güeseyë yë'ë. Bainbi ja'an aonre aintoca, si'arën ba'ijën, huajëreba huajëjën ba'ija'bë caguë, yë'ë ga'nihuëte insini jo'cayë yë'ë, yihuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Caguëna, judío ëja bainbi bëinjën, sa'ñeña coca senni achahuë: —¿Baguë ga'nihuë mai aon aoñe caguë, queaca maina insiye poreguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Senni achajënna, Jesús yua se'e bacuani quëabi: —Ganreba mësacuani yihuoguë quëayë yë'ë. Yë'ë yua Bainguë'ru Raosi'quë ba'iguëna, yë'ë ga'nihuëte ainjën ba'ijë'ën. Yë'ë ziere uncujën ba'ijë'ën. Ja'nca yo'oma'itoca, mësacua recoyo huajëye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yë'ë ga'nihuë aiñe, yë'ë zie uncuye, ja'anre yo'ocuabi si'arën ba'ijën, huajëreba huajëjën ba'iyë. Ba'ijënna, ën yija carajei umuguseña ti'anguëna, bacuare go'ya rai güeseja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yë'ë ga'nihuë yua bain aonreba re'huase'e ba'iji. Yë'ë zie yua bain gonoreba re'huase'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yë'ë ga'nihuë aiñe, yë'ë zie uncuye, ja'anre yo'ocuabi yë'ë naconi te'e recoyo ba'icua'ru bojojën ba'iyë. Yë'ë'ga bacua naconi te'e recoyo ba'iguë'ru bojoguë ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yë'ë Taita huajëreba huajëguëbi yë'ëre raosi'quë sëani, yë'ë'ga güina'ru huajëreba huajëyë. Ja'nca ba'iguë, yë'ëna aincuani huajëreba huajë güeseyë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Riusu aon guënamë re'otobi raose'e, ja'an aonre cayë yë'ë. Ira bain ba'isi'cua ainse'ere cama'iñë, ju'insi'cuare sëani. Yë'ëna aincuabi si'arën ba'ijën, huajëreba huajëjën ba'iyë, yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ja'nca coca yihuoguë, judío bain ñë'ca huë'e Capernaum huë'e jobore ye'yoguë baji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja'an cocare quëani achoguëna, baguëre concuabi achani, yequëcuabi gue ro'taye beoye ba'ijënna, bacuabi ja'anre sa'ñeña cahuë: —Ja'an coca ro'taye ai jëjaji. Achaye porema'iñë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Cajënna, Jesusbi baguëre concua cayete masini, bacuani yihuoguë cabi: —¿Mësacua queaca ro'tajën, yë'ë coca case'ere bëinjën achaye'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yë'ë yua Bainguë'ru Raosi'quë ba'iguëbi yë'ë quë'ro raisiruna se'e mëiguë go'iguëna, ja'anre ëñatoca, ¿mësacua queaca ro'tajën ba'ija'cua'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Riusu Espíritu se'gabi bainni huajë güeseji. Recoyo beotoca, bain ga'nihuë se'gabi huajëye porema'iji. Yë'ë coca mësacuani quëani achoguë, bain recoyo huajë coca, ja'anre quëani achoguë, te'e ruiñereba ba'i coca'ë, caguë quëayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ja'nca quëani achoguëna, yequëcua mësacua naconi ba'icuabi yë'ëni recoyo ro'tama'iñë, cabi Jesús. Jesús yua baguëni recoyo ro'tama'icuare si'arën masiguë baji'i. Baguëni insini senjoja'guëre'ga masiguë baji'i. Ja'nca masiguëbi baguë yure case'ere quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Quëani ja'nrëbi, se'e coca cabi: —Ja'nca ro'tama'icua ba'ijënna, yë'ë coca quëase'e: Yë'ë Taitabi yë'ë ba'iyete ëñoma'itoca, bainbi yë'ëna ti'añe porema'iñe mësacuani quëahuë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ja'nca caguëna, baguëte conjën ba'icua ai jai jubëbi baguëni coñe jo'cani quëñëhuë. Baguë naconi se'e saimaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Saima'ijënna, baguëre concua, si'a sara samucua ba'icuani senni achabi: —¿Mësacua'ga yë'ëre jo'cani saiye ro'taye? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Senni achaguëna, Simón Pedrobi sehuobi: —Bañë. Yëquënabi sani, yequëni ye'yetoca, bain huajë cocare ye'yoguëbi beoji. Më'ë se'gabi ja'an cocare ye'yoguëna, yëquënabi ye'yeni si'arën ba'ijën, huajëreba huajëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ja'nca sëani, më'ëni si'a recoyo ro'tahuë yëquëna. Më'ë yua mai Ta'yejeiyereba Ëjaguë Riusu Zin, ba Cristo ba'iguëna, yëquënabi më'ë ba'iyete ye'yeni masihuë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Caguëna, Jesusbi bacuani quëabi: —Mësacua si'a sara samucuare cuencueni yë'ëre conjën ba'icuare re'huahuë. Ja'nca re'huaguëta'an, mësacua jubë ba'iguë, te'eguë yua huati bainguë ba'iji, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariote, Simón mamaquë, ja'anguëte quëabi Jesús. Baguëte conjën ba'icua, si'a sara samu ba'icua, bacua naconi cuencuesi'quëta'an, Jesusre insini senjoja'guëta'an ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ja'nca ba'iguëna, Jesús yua Galilea yija se'gare baji'i. Judío ëja bainbi baguëte huani senjoñe yëjënna, Judea yijana saimaji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Saima'iguëna, ja'nrëbi judío bain aon tëase'ere bojojën, fiesta yo'oye baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ja'nca ba'ijënna, baguë yo'jecuabi baguëni coca yihuo bi'rahuë: —Ënjo'onbi sani, Judeana saijë'ën. Sani, më'ë ta'yejeiye yo'oni ëñoguëna, më'ëre concua baru ba'icuabi ëñañe poreyë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Më'ë yua ënjo'onre ba'iguë, më'ë yo'ore ro yahuera'rë yo'oguë ba'iyë. Ta'yejeiye yo'oni ëñocuabi ja'nca yo'oma'iñë. Si'a bainbi ëñani masija'bë cajën, bain jubëan ba'iruanna sani, bacua yo'o yo'oni ëñoñë. Ja'nca sëani, më'ë'ga më'ë ta'yejeiye yo'oyete si'a bainni ëñojaijë'ën, yihuojën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ja'nca cajën, bacua'ga baguëni recoyo ro'tamajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ba'ijënna, Jesusbi bacuani sehuoguë cabi: —Yë'ë fiesta sairën yuta ti'anma'iji. Mësacua fiestana saiye yëjën, mësacua yësirën saiye poreyë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bainbi mësacuani je'o baye beoye ba'iyë. Yë'ëca bain gu'a juchare masi güeseguë sëani, yë'ëni je'o bajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mësacua se'ga yua fiestana sani ba'ijë'ën. Yë'ëca bañë. Yë'ë fiesta sairën yuta ti'anma'iji, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ja'nca caguë, yua Galilea yijana bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ba'iguëna, baguë yo'jecuabi fiestana saë'ë. Satena, Jesus'ga yahuera'rë saji'i. Bainni ëñoma'iguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sani ti'anguëna, judío ëja bainbi baguëni cu'eni ganojën, sa'ñeña senni achajën baë'ë: —¿Jarote ba'iguë'ne baguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bain hua'na'ga baguë ba'iyete sa'ñeña coca cajën baë'ë. Yequëcuabi: “Re'o bainguë'bi” cajënna, yequëcuabi: “Banji. Bainni ro coqueguë yihuo'te” cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yahue caye se'ga baë'ë. Judío ëja bainni huaji yëhuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta yo'ojënna, jobo ba'i umuguseña ba'iguëna, Jesusbi Riusu huë'ena cacani, bainni ye'yo bi'rabi. ");
INSERT INTO snnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ye'yo bi'raguëna, judío bainbi achajën rëinjën, sa'ñeña coca cahuë: —Aiguë yua uti ye'yema'isi'quëta'an, ¿queaca baguë masiyera masiguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Senni achajënna, bacuani sehuobi Jesús: —Yë'ë masiye se'gare ye'yoma'iñë yë'ë. Yë'ë Taitabi yë'ëre raoguëna, baguë masiye se'gare ye'yoguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yë'ë Taita yëye'ru yo'oye ro'tacuabi yë'ë ye'yoyete achani masiyë. Yë'ë Taita coca ba'itoca, masiyë. Yë'ë coca se'ga ba'itoca, masiyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yequëcuabi ro bacua coca se'gare quëani achotoca, ro bacua ta'yejeiye ba'iyete yëyë. Yë'ëca bañë. Yë'ë Taitabi yë'ëre raoguëna, baguë ta'yejeiye ba'iye se'gare yëyë yë'ë. Ja'nca yëguëbi te'e ruiñe ye'yoguë ba'iyë. Yë'ë Taitabi coqueye beoye ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisesbi Riusu ira coca guansese'ere toyani, mësacuana jo'caguë ba'nji. Ja'anre mësacua masiyë. Masicuata'an, ba coca guanseni jo'case'ere yo'oye ro gu'a güeyë mësacua. Ja'nca yo'oye güecuabi ¿queaca ro'tajën, yë'ëni huani senjoñe ro'taye'ne? cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Caguëna, bainbi sehuohuë: —Bañë. Më'ëni huani senjoñe ro'tama'icua'ë yëquëna. Gu'a huati baguë sëani, güebe nesi'quë'ru caguë cayë më'ë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sehuojënna, Jesús cabi: —Yo'o yo'oma'i umuguse ba'iguëna, yë'ëbi ta'yejeiye yo'o, te'e yo'o se'gare yo'oni ëñoguëna, mësacua si'acuabi ëñajën rën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés yua bain go neño ga'nihuë tëyoye, ja'anre ye'yoni jo'caguë ba'nji, Moisesbi ye'yoni jo'caguëta'an, baguë ira bain ba'isi'cua, bacuabi ru'ru bacua zin hua'nani go neño ga'nihuëte tëyojën ba'nhuë. Ja'nca ye'yoni jo'caguëna, yureñabi mësacuabi yo'o yo'oma'i umuguse ba'iguëta'an, zin hua'guëni go neño ga'nire tëyoyë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés coca guanseni jo'case'ere'ru güina'ru yo'oñu cajën, baguë go neño ga'nire tëyoyë. Ja'nca ba'iyeta'an, yo'o yo'oma'i umuguse ba'iguëna, yë'ë yua bain raure huachoye ro'taguë, si'a ga'nihuë huajë ga'nihuëte mame re'huaguëna, ¿mësacua queaca ro'tajën yë'ëni bëiñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mësacuabi bain gu'aye yo'ose'ere caye ro'tatoca, ru'ru bacua gu'aye yo'ose'ere te'e ruiñe masini, te'e ruiñe cuencueni gu'aye cajë'ën. Bain yo'ose'ere ro besa ëñani, gu'aye yo'ose'e'ë catoca, ro gu'aye cayë mësacua, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ja'nca caguëna, yequëcua Jerusalén ba'icuabi sa'ñeña ca bi'rahuë: —¿Judío ëja bain yua aiguëni huani senjoñe ro'taye? ");
INSERT INTO snnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ja'nca ro'tacuata'an, si'a bain naconi ba'iguë, bacuani caraye beoye ye'yoguë ba'iji. Ba'iguëna, judío ëja bainbi ënsema'iñë. ¿Yequërë ëja bainbi baguë Cristo ba'iyete masima'iñe? ¿Riusu Raosi'quë'bi cama'iñe? ");
INSERT INTO snnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ja'nca ba'iyeta'an, baguë quë'ro raisirute masiyë mai. Ba Cristo Raosi'quëbi maini ëñoguëna, baguë quë'ro raisirute masiye porema'iñë mai, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cajënna, Jesusbi Riusu huë'ere ba'iguë, bainre ye'yoguë, si'a jëja ñaca quëani achobi: —¿Yë'ë ba'iye, yë'ë quë'ro raisirute ja'anre masiye ro'taye mësacua? Yë'ë se'gabi ro ro'taguë raimaë'ë. Yequë, te'e ruiñe ba'iguëbi yë'ëre raobi. Ja'anguëni huesëyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yë'ë'ga baguëre masiyë, baguë naconi te'e ba'iguë sëani. Baguëbi yë'ëre raoguëna, yë'ë raisi'quë'ë, quëani achobi. ");
INSERT INTO snnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Quëani achoguëna, baguëni preso zean ëaye baë'ë. Ba'icuata'an, baguëte zeanjai umuguse ti'anma'iñe sëani, baguëte zeanmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yequëcuaca ai jai jubëbi baguëni si'a recoyo ro'tani, sa'ñeña cahuë: —Baguë se'gabi ba Cristo, ba Riusu Raosi'quëreba ba'iji. Baguë ta'yejeiye yo'oni ëñose'ere ro'tato, quë'rë ta'yejeiye yo'oni ëñoguëte cu'eto, yequëbi beoji, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ja'nca sa'ñeña cajënna, fariseo bainbi achani, pairi ëjacua naconi ñë'cani, Jesusre preso zeanjaijë'ën, soldado ëjacuani guanseni saomate. ");
INSERT INTO snnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Saojënna, Jesusna ti'anjënna, Jesusbi bacuani quëabi: —Mësacua naconi yuta rëño ñësebë se'ga ba'iyë. Ba'ini, ja'nrëbi, yë'ëre raosi'quëna go'ija'guë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Go'iguëna, mësacuabi yë'ëre cu'eja'cua'ë. Cu'eja'cuata'an, yë'ëre tinjañe porema'ija'cua'ë. Yë'ë quë'ro ba'ija'runa ti'añe porema'ija'cua'ë mësacua, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Quëaguëna, judío ëja bainbi sa'ñeña ca bi'rahuë: —¿Jarona saiye ro'taguë'ne baguë? Baguëni tinjañe porema'iñe caguë, ¿gue quë'rore caguë'ne? Yequërë mai te'e jubë bain saoni senjosiruan, ja'anruan griego bain ba'iruanna sani, ba griego bainni ye'yoye ro'taguë cama'iguë baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Baguë coca case'ere achama'iñë mai. “Mësacuabi yë'ëre cu'ecuata'an, yë'ëre tinjañe porema'ija'cua'ë. Yë'ë quë'rona go'iguëna, më'ë sacuabi ti'añe porema'ija'cua'ë” caguëna, maibi achama'iñë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ja'nrëbi, fiesta umuguseña si'a bi'raguëna, quë'rë ta'yejei umuguse ba'iguëna, Jesusbi nëcani, bainni si'a jëja quëani achoguë cabi: —Mësacua yua huajë oco ëaye ba'itoca, yë'ëna rani, yë'ëna coni uncuye'ru yë'ë ba'iyete ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yë'ëni recoyo ro'tatoca, Riusu coca toyani jo'case'e'ru ba'iye mësacuare güina'ru mame re'huaja'guë'ë yë'ë. Mësacua recoñoa ai bojo huanoñe'ru ba'iguëna, bain huajë oco yua carajeiye beoye ba'iye'ru mësacuare re'huaja'guë'ë yë'ë. Re'huaguëna, mësacuabi ai jai jubë bainni huajë güeseyete ëñoja'cua'ë, yë'ëni si'a recoyo ro'tajën ba'itoca, quëani achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ja'nca quëani achoguë, Riusu Espíritu huanoñete cabi. Baguëni recoyo ro'tacuani Espíritu gaje meni ba'ija'ye, ja'anre quëabi. Jesús yuta junni tonni go'ya raima'iguë sëani, Espíritu gaje meni, baguë bainni baja'ye carabi. ");
INSERT INTO snnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ja'nca quëani achoguëna, bainbi baguë cocare achani, yequëcuabi cahuë: —Riusu coca quëani achocaiguë, Moisés quëasi'quë, ja'anguë ba'iji baguë. Riusubi baguë raija'yete zoe quëaguëna, yua maina ti'anni ba'iji baguë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Cajënna, yequëcuabi: —Riusu Raosi'quëreba, ba Cristo hue'eguë ba'iji, cahuë. Cajënna, yequëcuabi sehuohuë: —Banji. Ba Cristo hue'eguëbi Galilea yijabi raima'iguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Riusu coca toyani jo'case'ere ëñato, ba Cristo yua ira ëjaguë ba'isi'quë David bainguë, Belén huë'e jobo bainguë, ja'an ba'iji, David huë'e jobo sëani. Ja'anre quëaji Riusu coca, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ja'nca cacua sëani, Jesús ba'iyete ro'tato, bainbi te'e ro'tamaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yequëcuabi baguëni preso zeañe yëcuata'an, baguëni zeanmaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ja'nrëbi, soldado ëjacuabi baguëni preso zeanmajën, pairi ëjacua, fariseo bain, ja'ancuana goë'ë. Go'ijënna, bacuabi bëinjën, coca senni achahuë: —¿Mësacua guere yo'ojën, baguëte zeanni ramate'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Senni achajënna, soldado ëjacuabi sehuohuë: —Baguë ta'yejeiye ye'yose'ere quëani achoto, yequëcua coca ye'yocuabi ja'ncara'ru masiye ye'yoye beocua ba'iyë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sehuojënna, fariseo bainbi bëinjën cahuë: —Mësacua'ga ro coque güesehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ëja bain, fariseo bain, ja'ancuare cu'etoca, baguëni recoyo ro'tacua gare beoyë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bain jubëca Riusu coca huesëcuabi yua baguë cocare achajënna, Riusu bënni senjosi'cua ba'ija'cua se'ga ba'iyë, bëinjën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Cajënna, Nicodemo hue'eguë, bacua jubë ba'iguë, Jesusni ja'anrë ñamibi ëñaguë saisi'quë, baguë yua bacuani cabi: ");
INSERT INTO snnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Riusu coca maina jo'case'ere ëñato, bainguë gu'aye yo'ose'ere case'e bani'ga, Baguëni te'e jëana si'nsema'ijë'ën caji. Ru'ru, baguë coca sehuoni quëayete te'e ruiñe achani masiye bayë caji, cabi baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Caguëna, fariseo bainbi sehuohuë: —Më'ë'ga ro Galilea bainguë'ru huesëguë cayë. Riusu coca toyani jo'case'ere ëñani masijë'ën. Riusu bain raoja'cua yua Galilea yijabi raicua beoyë caji. Ja'anre ëñani masijë'ën, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ja'nca cajënna, ja'nrëbi, si'acuabi bacua huë'ena go'imate. ");
INSERT INTO snnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Go'ijënna, Jesusbi Olivo casi cubëna sani mëji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mëni, ja'nrëbi ñataguëna, Riusu huë'ena goji'i. Goni, si'a bainbi baguëna raijënna, baguë yua bëani, bacuani coca ye'yoguë yihuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yihuoguëna, ja'nrëbi, Riusu ira coca ye'yocua, fariseo bain bacuabi romigote rani bacua jobona nëconi, Jesusni ëñohuë. Gu'a romigo yequëni yahue bago ba'igoni, zeanni rahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ja'nca rani, Jesusni quëahuë: —Ëjaguë, ëncobi yequë naconi yahue ba'igo, gu'aye yo'ogo ba'igona, bagote preso zeanni rahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés coca toyani jo'case'ere ëñato, ñaca guanseguë ba'nji: Ja'nca gu'aye yo'otoca, gatabi inni huani senjojë'ën, guanseguë ba'nji. Ja'nca guanseguë ba'iguëna, ¿më'ë'ga guere bagote caguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baguë sehuoyete masiñu cajën, ja'nca Jesusni senni achahuë. Gu'aye sehuotoca, baguëni preso zeañu cajën, ja'nca baguëni senni achahuë. Senni achajënna, Jesús yua rëanni, baguë mëoñobi yijana coca toyabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Toyaguëna, bacuabi yua quë'rë se'e ja'an cocare baguëni senni jëhuahuë. Senni jëhuajënna, baguë yua nëcani, bacuani cabi: —Mësacua jubë ba'iguë, gu'a jucha yo'oye beoye ba'iguë ba'itoca, ja'anguëbi bagoni gata ru'ru senjoja'guë. Ja'nrëbi, yequëcuabi gata senjoñe poreyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cani ja'nrëbi, se'e rëanni, yijana toyabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Toyaguëna, bacuabi baguë cocare achani, gu'a recoyo huanoñe'ru baë'ë. Ja'nca ba'icuabi, te'ena, te'ena quë'ñeni saë'ë. Quë'rë iracuabi ru'ru saë'ë. Saijënna, Jesusbi nëcani ëñato, ba romigo se'gabi te'e hua'go nëcago baco'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ba'igona, yequëcuabi quë'ñesi'cua ba'ijënna, Jesusbi bagoni ëñani bagoni senni achabi: —¿Më'ëre gu'aye cacua jarona sate'ne? ¿Më'ëni bënni senjoja'cua beoye? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Senni achaguëna, sehuogo: —Beoyë, Ëjaguë, sehuogo. Sehuogona, Jesús cabi: —Yë'ë'ga më'ëni si'nseye beoye ba'iyë. Se'e gu'aye yo'oma'igo saijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ja'anrëbi, jë'te, Jesús yua bain ñëcasi'cuani se'e coca quëani achobi: —Yë'ë yua si'a bain recoñoa miaguë, yë'ë cocare ye'yoguë masi güeseyë. Ja'nca masi güeseguëna, yë'ëni recoyo ro'tacuabi yë'ë ba'iyete te'e ruiñe ye'yeni, mia re'oto ñatani saoye ba'iruna ganijën ba'iyë. Gu'aye yo'oye gare jo'cajën, zijei re'otona gare se'e ganiñe beoye ba'iyë, quëani achoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Caguëna, fariseo bainbi cahuë: —Ro më'ë ba'iye se'gare quëani achoyë më'ë. Ja'nca sëani, te'e ruiñe quëama'iguë, ro coqueguë ba'iyë më'ë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Cajënna, sehuobi: —Bañë. Te'e ruiñe quëayë yë'ë. Yë'ë ba'iyete quëani achoguëta'an, te'e ruiñe caye se'ga ba'iyë yë'ë. Yë'ë quë'ro raise'ere masiyë. Baruna go'iye'ga masiyë yë'ë. Mësacuaca ja'anre huesëcua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mësacua yua ro bain ro'taye'ru ro'tajën, bainre gu'aye cajën ba'iyë. Yë'ëca bainre ja'nca cama'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bain ba'iyete masini caguë, te'e ruiñe se'ga cayë yë'ë. Yë'ë se'gabi bain ba'iyete masini cama'iñë. Yë'ë Taitabi yë'ëre raoguë, ja'an masini cayete yë'ëni ëñoji. ");
INSERT INTO snnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mësacua ira coca toyani jo'case'ere ëñato, ñaca caji: Samucuabi te'e quëatoca, te'e ruiñe quëayë bacua, caji. ");
INSERT INTO snnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ja'nca caguëna, yë'ë ba'iyete quëacua yua samucua ba'iyë. Yë'ëbi yë'ë ba'iyete quëani achoyë. Yë'ë Taita yë'ëre raosi'quë, baguë'ga yë'ë ba'iyete quëani achoji. Ja'nca sëani, te'e ruiñe quëase'e ba'iji, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Caguëna, bacuabi baguëni senni achahuë: —¿Më'ë Taita jarote ba'iguë'ne? senni achahuë. Senni achajënna, sehuobi: —Mësacua yua yë'ëre huesëcua'ë. Yë'ë Taitare'ga huesëcua'ë. Yë'ëre masinica, yë'ë Taitare'ga masijën ba'ire'ahuë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ja'an sehuoguë, Riusu huë'e curi gajongu ba'irute ba'iguë, bainni ye'yoguë baji'i. Ja'nca ye'yoguëna, baguëni preso zeañe beoye baë'ë, baguëte zeanjairën yuta ti'anma'ise'e sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ja'nrëbi, Jesús yua se'e bacuani quëabi: —Ënjo'onbi gare saiyë yë'ë. Saiguëna, mësacuabi yë'ëre cu'eni, yë'ëre tinjama'ija'cua'ë. Ro gu'a jucha tënoma'isi'cuabi junni huesëye se'ga ba'iyë. Yë'ë go'ija'runa go'iguëna, mësacuabi be'teni saiye porema'iñë, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Quëaguëna, judío bainbi sa'ñeña cahuë: —Ja'ansi'quëre huani huesë ëaye caji. Ja'nca sëani, baguë go'ija'runa saiye porema'iñë mai caji, jayaye'ru cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Cajënna, bacuani quëabi: —Mësacuabi ro bain ro'taye'ru ro ro'tajën ba'iyë. Yë'ëca Riusu ro'taye'ru ro'taguë ba'iyë. Mësacuabi ën re'oto ba'icua se'ga ba'iyë. Yë'ëca bañë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mësacua ro gu'a jucha tënoma'isi'cuabi junni huesëye se'ga ba'iyë, quëani achohuë yë'ë. Yë'ë, Riusu Raosi'quëreba ba'iguë, ja'an ba'iyete recoyo ro'tama'itoca, ja'nca junni huesëyë mësacua, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Quëaguëna, bacuabi baguëni senni achahuë: —¿Gueguëguë'ne më'ë? senni achahuë. Senni achajënna, sehuobi: —Yua yë'ë ba'iyete mësacuani ai quëani jëhuahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mësacua ba'ijën yo'ose'ere quëaguë, mësacua gu'a jucha yo'ojën ba'ise'ere masijë'ën caguë, ja'anre caye ai ba'iye caraji yë'ëre. Yë'ë raosi'quë yua te'e ruiñe ba'iguëbi yë'ëni te'e ruiñe quëaguëna, yë'ëbi si'ayete bainni quëani achoguë ba'iyë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Taita Riusure cabi Jesús. Ja'nca caguëna, bacuabi ro huesë ëaye achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ja'nca huesëjënna, bacuani quëabi: —Mësacuabi yë'ë, Bainguë'ru Raosi'quëreba ba'iguëte ëmëna reoni senjoja'cua'ë. Senjoni, ja'nrëbi, yë'ë ba'iyete te'e ruiñe masija'cua'ë. Yë'ë case'e'ru ba'iye masija'cua'ë. Yë'ë se'gabi ro yë'ë cocare quëani achoye beoye ba'iguë, yë'ë Taita ye'yoni ëñose'e se'gare quëani achoyë. Ja'anre ëñani masija'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yë'ë Taitabi yë'ëre raoguë, yua yë'ë naconi te'e ba'iji. Yë'ëre te'e hua'guëre jo'cama'iji. Jo'cama'iguëna, yë'ëbi baguë yëyete jo'caye beoye yo'oguëna, yë'ëni bojoji baguë, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja'nca quëaguëna, ai jai jubë bainbi achani, baguëni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ja'nca recoyo ro'tajënna, Jesusbi bacua, judío bain ba'icuani yihuoguë cabi: —Yë'ë cocarebare achani, jo'caye beoye si'a recoyo ro'tajën ba'itoca, yë'ë bainreba ruiñë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ja'nca ruinjën, si'ayete te'e ruiñe masiyereba masiyë. Ja'nca masijën, mësacua yua gu'a juchana zemoni basi'cua ba'ijënna, mësacuani etoyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Caguëna, bacuabi sehuohuë: —Yëquëna yua ira taita ba'isi'quë Abraham, baguë mamacua sëani, yequëcuabi yëquënani zemomaë'ë. ¿Më'ë guere ro'taguë, yëquënare etoyete caguë'ne? sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sehuojënna, Jesús cabi: —Mësacuani ganreba quëayë yë'ë. Gu'a jucha yo'ocuabi yua gu'a juchana zemosi'cua'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gu'a jucha zemosi'cuabi si'arën ba'ima'iñë. Riusu bainreba se'gabi si'arën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yë'ë yua Riusu Zin sëani, mësacua zemosi'cuare etoye poreyë. Ja'nca etotoca, gare se'e zemosi'cua ruiñe beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mësacua yua Abraham mamacua ba'iyete masiyë yë'ë. Ja'nca ba'icuata'an, yë'ë cocarebare achaye gu'a güecua sëani, yë'ëni huani senjoñe yëyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yë'ë Taita naconi ba'iguë, baguë ëñoñete quëani achoguë ba'iyë yë'ë. Mësacua taita zupai huatibi guanseguëna, mësacuabi achajën yo'ojën ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Caguëna, baguëni sehuohuë: —Abraham yua yëquëna taita ba'iji. Yëquëna yua Israel bain sëani, re'o bain ba'iyë, cahuë. Cajënna, Jesús cabi: —Mësacua yua Abraham mamacuareba ba'itoca, Abraham yo'oguë ba'ise'e'ru güina'ru yo'ojën ba'ire'ahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yureca yë'ëni huani senjo ëaye ba'iji mësacuare. Yë'ëbi Riusu te'e ruiñe ba'i cocarebare achani, mësacuani güina'ru quëani achoguëna, yë'ëni huani senjoñe yëyë. ¡Ja'nca yo'oma'iguë baji'i Abraham! ");
INSERT INTO snnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ro mësacua taita yo'oye'ru yo'ojën ba'iyë, cabi. Caguëna, bacua yua baguëni bëinjën cahuë: —Yëquëna yua huacha zinma'icua'ë. Riusu se'gabi yëquëna Taita ba'iji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Cajënna, Jesús cabi: —Riusubi mësacua Taita banica, yë'ëni ai yëjën ba'ire'ahuë mësacua. Yë'ë yua Riusu ba'irute ba'iguëbi raë'ë. Yë'ë se'gabi raiye ro'tamaë'ë. Baguëbi yë'ëre raoguëna, raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Mësacua queaca ro'tajën, yë'ë coca quëayete achama'iñe'ne? Yë'ëbi coca quëani achoguëna, mësacuabi achaye gu'a güejën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mësacua taita yua zupai huati se'ga ba'iji. Ja'nca sëani, zupai yëye se'gare yo'oye ro'tajën ba'iyë mësacua. Ru'rureba ba'isirënbi bainni huani senjoñe yo'oguë ba'iji. Te'e ruiñe ba'i cocare achaye beoye ba'iji, te'e ruiñe ba'iyete ro'tama'iguë sëani. Baguë ro'tayete cato, coqueye se'ga ba'iji. Coque huati sëani, si'acuani coque güeseji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yureca, yë'ëbi mësacuani te'e ruiñe quëaguëna, yë'ëni achaye gu'a güeyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mësacua jubë ba'icua, ¿gueguëbi yë'ë juchare ëñoñe poreguë'ne? Beoji. Mësacuani te'e ruiñete quëaguëna, ¿queaca ro'tajën, yë'ë cocare ro'tama'iñe'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Riusu bainbi Riusu naconi te'e ba'ijën, baguë cocarebare achayë. Mësacua yua Riusu bain beocua sëani, baguë cocarebare achaye gu'a güejën ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Caguëna, judío bainbi sehuohuë: —Yua më'ë ba'iyete masini, te'e ruiñe quëayë yëquëna. Ro gu'a bainguë, Samaria yija bainguë'ë më'ë. Gu'a huati re'osi'quë'ë më'ë, sehuojën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Cajënna, Jesús cabi: —Bañë. Huati re'oma'isi'quë'ë yë'ë. Yë'ëbi yë'ë Taitani te'e ruiñe ëñaguëna, mësacua yua yë'ëni te'e ruiñe ëñamajën, yë'ëni gu'aye cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ja'nca ba'icuata'an, bain te'e ruiñe ëñañete cu'ema'iñë yë'ë. Bain recoyo ro'tayete masiguë, ja'anguëbi Taita Riusu sëani, yë'ëre te'e ruiñe ëñañete cu'eji. Ja'anguëbi bain juchare masini ëñoji. ");
INSERT INTO snnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mësacuani ganreba quëayë yë'ë. Yë'ë cocarebare achani yo'ocua, ja'ancuabi gare junni huesëye beoye ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Caguëna, judío bainbi sehuohuë: —Yua më'ë gu'a huati re'osi'quë ba'iyete te'e ruiñe masiyë yëquëna. Abraham yua junni huesësi'quë ba'iji. Riusu ira bain raosi'cua si'acuabi junni huesësi'cua ba'iyë. Ja'nca ba'icua sëani, më'ë coca achani yo'ocuabi gare junni huesëye beoye ba'iyë caguë, ro huacha ro'taguë cayë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yëquëna taita Abraham ba'iye'ru quë'rë ta'yejeiye ëjaguë ba'iye catoca, ro coqueyë më'ë. Baguë yua ju'insi'quë ba'iji. Riusu ira bain raosi'cua'ga ju'insi'cua ba'iyë. Më'ë ba'iyete caguë, ¿queacara ro'taguë quëaguë'ne? jayaye'ru senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Senni achajënna, Jesús sehuobi: —Yë'ë se'gabi yë'ë ta'yejeiye ba'iyete ëñotoca, ta'yejeiye beoye ba'ire'ahuë yë'ë. Yë'ë Taita se'gabi yë'ë ta'yejeiyete ëñoguë ba'iji. Mësacuaca baguëte cajën, yëquëna Riusu ba'iji quëayë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ja'nca quëacuata'an, mësacua yua baguëni huesëcua'ë. Yë'ëca baguëni masiyë. Yë'ëbi baguëni huesëye catoca, mësacua ro coqueye'ru, coqueguë ba'ire'ahuë yë'ë. Yë'ëbi baguëni masiguë, baguë cocarebare achani yo'oguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mësacua taita Abrahambi yë'ë raija'yete masini, yë'ëni ai bojoreba bojoguë baji'i, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sehuoguëna, judío bainbi cahuë: —Më'ë yuta cincuenta tëcahuëan beoyë. ¿Queaca Abrahamni ëñañe poreguë'ne më'ë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Senni achajënna, Jesusbi sehuobi: —Mësacuani ganreba quëaguë'ë yë'ë. Abraham ba'ise'e'ru quë'rë ru'ru ba'iyë yë'ë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Caguëna, bacuabi yua gatare chiani, baguëni senjoni huai ëaye yo'ohuë. Yo'ojënna, Jesusbi gatini, Riusu huë'ebi etani, bain jubëna huesoni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja'nca sani, ja'nrëbi, ñaco ëñama'iguëni ëñabi Jesús. Baguë zinrënna ñaco beora'bërë të'ya raisi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ja'nca ba'iguëna, Jesusre conjën ba'icuabi Jesusni senni achahuë: —Ëjaguë, ¿baguë gue jucha ro'ire ñaco ëñama'iguë të'ya raisi'quë ba'iguë'ne? ¿Baguë jucha ro'ire o baguë pë'caguë sanhuë jucha ro'ire ñaco beoguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Senni achajënna, Jesús sehuobi: —Banbi. Baguë jucha, baguë pë'caguë sanhuë jucha, ja'an ro'ire beobi. Riusu ta'yejeiye yo'oni ëñoñe, ja'anna ñaco ëñama'iguë ba'iji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Umuguse carajeiye tëca bainbi bacua yo'o yo'oye poreyë. Ñami ti'anguëna, yo'o yo'oye gare porema'iñë. Yë'ë Taitabi yë'ëre raoguëna, baguë yo'o guansese'e yureña yo'oye bayë mai. Yë'ë yo'o yo'oye poreye ba'irënbi carajeiguëna, yë'ë Taita yo'o guansese'ere yo'oye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ja'anrën carajeiye tëca, yë'ë yua umuguse ñatani saoye'ru bain recoñoa miañe ëñoguë'ë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cani ja'nrëbi, gore raoni, yijana tonni, ya'ora'bërëte re'huani, ñaco ëñama'iguëna sani, ja'an ya'obi baguë ñacona së'quëbi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Së'quëni ja'nrëbi, baguëni guanseguë cabi: —Më'ë yua Siloé casiru, ba oco goje ba'iruna sani, më'ë ñacore zoajë'ën, cani saobi. Bain cocabi cato, Oco Raose'e hue'eji. Ja'nca cani saoguëna, ñaco ëñama'iguëbi sani, ñacore zoani, ñaco ëñaguëbi raji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Raiguëna, baru bain baguëni ja'anrë masicuabi yua baguëni ëñani, sa'ñeña coca senhuë. Yequëcuabi: —¿Aiguë yua curi senguë ñu'iguë ba'isi'quëma'iguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yequëcuabi: —Baguë'bi, sehuohuë. Yequëcuaca: —Banji. Tinguëta'an, baguëra'ru ëñoji, sehuohuë. Sehuojënna, baguëca: —Baguë'ë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Quëaguëna, bacuabi baguëni senni achahuë: —Ja'nca ba'itoca, ¿queaca më'ë ñaco sëtani ëñaguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Senni achajënna, sehuobi: —Ba bainguë Jesús hue'eguëbi ya'obi re'huani, yë'ë ñacona së'queni, yë'ëni coca guansebi: “Siloena sani, ñaco zoajë'ën” caguë saobi. Ja'nca cani saoguëna, yë'ëbi sani, ñaco zoani, ñaco sëtani ëñahuë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Quëaguëna, bacuabi senni achahuë: —¿Ja'an bainguë jarona saquë'ne? senni achahuë. Senni achajënna: —Huesëyë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sehuoguëna, bacuabi baguëte sani, fariseo bainni nëconi ëñohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ja'an umuguse, Jesusbi ya'o së'queni ñaco ëñama'iguëte huachoguëna, judío bain yo'o yo'oma'i umuguse baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ja'nca ba'iguëna, fariseo bainbi ñaco sëtasi'quëni baguë ñaco ëñase'ere senni achahuë. Senni achajënna, baguë sehuobi: —Baguë yua ya'obi re'huani, yë'ë ñacona së'queguëna, zoajani ñaco ëñahuë yë'ë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Quëaguëna, fariseo jubë ba'icua yequëcuabi cahuë: —Ba bainguë Jesús hue'eguë, baguë ba'iyete cato, Riusubi baguëte raomaji'i. Yo'o yo'oma'i umugusebi yo'o yo'oguë, mai ira coca guanseni jo'case'e'ru tin yo'oji baguë, bëinjën cahuë. Cajënna, yequëcuabi sehuohuë: —Banji. Gu'a bainguë beoji. Gu'a bainguë ba'itoca, baguë ta'yejeiye yo'oni ëñoñe porema'ire'abi, sehuohuë. Sa'ñeña bëiñe cajën sehuojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ja'nca cajën, ñaco beosi'quëni se'e senni achahuë: —Më'ë'ga baguë ba'iyete ro'taguë, ¿guere caguë'ne? senni achahuë. Senni achajënna: —Riusubi baguë coca quëacaiguëte re'huani baguëte raobi, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ja'nca ba'iguëna, judío bainbi ba ñaco sëtasi'quëni ëñani, baguë ñaco ëñama'ise'e, baguë ñaco huachose'e, ja'anre ro'taye güehuë. Ja'nca ro'taye güecuabi baguë pë'caguë sanhuëni choë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Choni, bacuani senni achahuë: —¿Ënquë yua mësacua zin'guë? ¿Baguë të'ya raisirënbi ñaco beoguë baquë? Ja'nca ba'itoca, ¿queaca yo'oguë ñaco ëñaguë ba'iguë'ne? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Senni achajënna, pë'caguë sanhuëbi sehuohuë: —Yëquëna zin hua'guë'bi ba'iji. Baguë të'ya raisirënbi ñaco ëñama'iguë'bi baji'i. Ja'anre masiyë yëquëna. ");
INSERT INTO snnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ja'nca masicuata'an, baguë ñaco yure ëñaguë ba'iyete huesëyë. Baguëni ñaco huachosi'quëre'ga huesëyë yëquëna. Yëquëna zinni senni achajë'ën. Ira hua'guë sëani, baguë se'gabi sehuoye masiji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judío ëja bainni huaji yëcua sëani, ja'nca bacuani sehuohuë. Judío ëja bain yua ën cocare te'e cajën baë'ë: Jesús yua Riusu Raosi'quëreba ba'iyete quëacua, ja'anre quëacua ba'itoca, bacuare mai ba'i jubëbi quëñoni senjoñu cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja'nca sëani, baguë pë'caguë sanhuëbi, “Yëquëna zinni senni achajë'ën, ira hua'guë sëani” sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sehuojënna, ja'nrëbi, judío ëja bainbi ñaco ëñama'iguë ba'isi'quëre se'e choni, se'e cahuë: —Riusuni te'e ruiñe ëñani, coqueye beoye quëajë'ën. Baguë gu'a jucha yo'oguë ba'iyete masiyë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Cajënna, baguë sehuobi: —Gu'a jucha yo'oyete huesëyë yë'ë. Ëñe se'gare masiyë yë'ë. Yë'ëbi ja'anrë ñaco ëñama'iguë ba'isi'quëta'an, yure ñaco ëñañe poreyë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sehuoguëna, baguëni se'e senni achahuë: —¿Guere më'ëni yo'oguë'ne baguë? ¿Queaca më'ë ñacore sëtoguë'ne baguë? Quëajë'ën yëquënani, senreba sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Senjënna, sehuobi: —Mësacuani yuara quëahuë yë'ë. Quëaguëna, mësacuabi achaye güehuë. ¿Mësacua queaca ro'tajën, ba cocare se'e achaye yëye'ne? ¿Mësacua'ga baguëre conjën ba'icua ruiñe yëye? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ja'nca senni achaguëna, baguëni ai bëinreba bëinjën sehuohuë: —Bañë. Më'ë se'gabi baguëre conguë ba'iguë ruën'ë. Yëquënabi Moisesni conjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Riusubi Moisesni coca guanseni jo'caguëna, yëquënabi masiyë. Ja'anguëta'an, gu'aye se'ga ba'iji. Baguë raosi'quëre huesëyë yëquëna, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sehuojënna, ñaco sëtasi'quëbi cabi: —¿Mësacua yua baguë raosi'quëre huesëye caye? ¿Mësacua ro huesë ëaye caye? Ja'anre huesëcuata'an, baguëbi yë'ë ñacore huachoni sëtobi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Riusubi gu'a bain ujayete achama'iji. Ja'an coca yua te'e ruin coca ba'iyete masiyë mai. Riusuni recoyo te'e ruiñe bojocua, bacua ujayete achaji. Baguëni te'e ruiñe ro'tajën, baguëni gugurini rëinjën, baguë yëye'ru yo'ojën ba'icua sëani, bacua ujayete achani conji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ñaco ëñama'iguë, baguë të'ya raisirën ñaco beoguë ba'itoca, ¿jarocuabi baguëni huachore'ne? Ja'an yo'oye porecua gare beocua ba'iyë. Ja'anguë se'gabi porebi, Riusu raosi'quë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Riusubi raoma'itoca, huachoye beoye ba'ire'abi, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Caguëna, baguëni bëinjën sehuohuë: —¿Më'ë queaca ro'taguë, yëquënani coca ye'yoguë'ne? Më'ë zinrënna gu'a juchana gare zemosi'quë'ë më'ë, cahuë. Cani, bacua ba'i jubëbi baguëte quëñoni senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Quëñoni senjorena, Jesusbi achani, baguëte cu'ejani, baguëte tinjani, baguëni coca senni achabi: —¿Bainguë'ru Raosi'quëreba ba'iguëni si'a recoyo ro'taguë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Senni achaguëna, sehuoye senji'i baguë: —¿Jaroguë'ne baguë? Yë'ëni quëajë'ën. Baguëni si'a recoyo ro'taza, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Caguëna, Jesusbi quëabi: —Më'ë yua baguëni ëñahuë. Yë'ëbi yua Bainguë'ru Raosi'quëreba ba'iguë'ë. Më'ë naconi coca caguëbi yua ba Cristo ba'iguë'ë yë'ë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Quëaguëna, cabi: —Ëjaguë, më'ëni si'a recoyo ro'tayë yë'ë, caguë, Jesusni gugurini rëanbi. ");
INSERT INTO snnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Gugurini rëanguëna, ja'nrëbi Jesusbi quëabi: —Gu'a bain ba'iye, re'o bain ba'iye, ja'anre masiza caguë, ën yijana raë'ë yë'ë. Bainbi, Riusuni ye'yeye caraji yë'ëre, catoca, ja'anre cacua, ñaco beocua ba'icua sëani, bacua ñaco sëtoni huachoye'ru yo'oguë, bacua ye'yeyete coñë yë'ë. Yequëcua, Riusuni ye'yesi'quë'ë yë'ë cajënna, yë'ëbi, ja'ancua yua yë'ë ba'iyete ye'yema'ija'bë caguë, ñaco ëñama'icuare'ru bacuare re'huayë yë'ë, caguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Quëaguëna, yequëcua fariseo bain jubë ba'icuabi ca'ncore achajën nëcajën, Jesusni senni achahuë: —Yëquëna'ga ¿ñaco ëñama'icua ba'iye caguë më'ë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Senni achajënna, Jesús sehuobi: —Mësacuabi: ñaco beocua'ë catoca, jucha beoye ba'ire'ahuë. Ñaco ëñañe poreyë cacua sëani, gu'a jucha yuta bayë mësacua, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ja'nca sehuoni, ja'nrëbi, bacuani ye'yo coca quëabi: —Ganreba mësacuani quëayë yë'ë. Oveja jiancuare ro'tani ye'yejë'ën. Bacuabi oveja guaosiruna cacaye yëtoca, anto sa'robi cacama'iñë. Yo'je ca'ncobi yahue mëni cacayë, bacua yua oveja hua'nare jian ëaye ro'tacua sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ovejani ba ëjaguëca banji. Ja'anguëbi anto sa'arobi cacaji. ");
INSERT INTO snnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Anto sa'rona choiguëna, oveja cuiracaiguëbi baguëna ancoji. Ancoguëna, jo'ya ba ëjaguëbi baguë oveja jo'ya hua'nare, ga mami hue'eguëte choiguëna, oveja hua'nabi achani, baguë naconi hue'se ca'ncona saiyë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bacua ëjaguë cayete achani masicuabi baguëna së'ajën, baguëni te'e conjën saiyë. Saijënna, bacua ru'runa saiguë, baguë jo'ya jubë si'acuare etoni saji. ");
INSERT INTO snnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yequëbi choitoca, ja'anguë cayete huesë ëaye achajën, baguëna së'ama'iñë. Baguë choiyete achani, quëñëni gatiyë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ye'yo cocabi quëaguëna, bacuabi ro huesë ëaye se'ga achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Huesë ëaye achajënna, Jesusbi bacuani se'e yihuoguë quëabi: —Ganreba mësacuani quëayë yë'ë. Yë'ë yua oveja guaosiru anto sa'ro ba'iye'ru ba'iyë yë'ë. Oveja hua'nabi ba anto sa'ro se'gabi etani cacayë. Güina'ru, bainbi Riusu ba'i jobona ti'añe yëtoca, yë'ë se'gani si'a recoyo ro'taye bayë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yequëcua, yë'ë ja'anrë raisi'cua, bainni coquejën ye'yocua ba'ijën, oveja jiancua'ru baë'ë. Bacuabi coqueye ye'yojënna, yë'ë bainbi bacua choise'ere huesëjën, bacuana së'amaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Oveja guaosiru anto sa'ro ba'iye'ru ba'iyë yë'ë. Bainbi yë'ëni si'a recoyo ro'tatoca, bacuani tëani bayë yë'ë. Tëani baguëna, bacuabi bojojën, huaji yëye beoye ba'ijën, yë'ë bayete ai coreba cojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oveja jiancuabi oveja hua'nare jianni, huani si'aye, ja'an se'gare ro'tajën raiyë. Ye'yo cocare coquejën quëacuabi güina'ru ro'tajën ba'iyë. Yë'ëca huajëreba huajë güeseguë raisi'quë'ë. Huajë güeseguëna, bainbi bojo huanoñe se'ga huajëreba huajëjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jo'ya ëjaguë bani cuiraye'ru, yë'ë bainrebare bani, bacuani conreba coñë yë'ë. Bacuabi carajeima'iñe caguë, bacua ro'ire junni tonza ro'taguë raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Jo'ya ëjaguëbi yo'o conguë naconi jo'yare jo'catoca, ja'nca'ru bacuani conni cuirama'iji. Airu yaibi zeanguë raiguëna, yo'o conguë yua baguë ëjaguë oiye'ru jo'yani oiye beoguëbi ro huaji yëguë gatini saiji. Gatini saiguëna, airu yaibi oveja jubëna ti'anni, bacuani zeanni saoni senjoji. ");
INSERT INTO snnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jo'ya ëjaguë oiguë baye'ru, yë'ë bainrebani oiye bayë yë'ë. Bacuani te'e ruiñe masiyë yë'ë. Masiguëna, bacuabi yë'ëre te'e ruiñe masiyë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Güina'ru, yë'ë Taitabi yë'ëni te'e ruiñe masiguëna, yë'ëbi baguëni te'e ruiñe masiyë yë'ë. Ja'nca masiguëbi yë'ë bainrebani oiguë bani, bacua ro'ire junni tonza caguë raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yequë jubë bain, Israel bain jubë ba'ima'icua, ja'ancuare'ga bayë yë'ë. Bacuare'ga choiguëna, bacuabi yë'ë cocare achani, ñë'cajën raija'cua'ë. Ñë'cajën raijënna, si'acuani te'e jubëni baja'guë'ë yë'ë. Bacua ëjaguë te'e ëjaguë ba'ija'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yë'ë bain ro'ire junni tonni, ja'nrëbi se'e go'ya raija'guë'ë yë'ë. Ja'nca sëani, yë'ë Taitabi yë'ëni ai yëguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yë'ëbi Jaë'ë cama'itoca, yequëcuabi yë'ëni huani senjoñe porema'iñë. Yë'ë se'gabi bain ro'ire junni toñe poreguë'ë. Junni tonni, yë'ë se'gabi se'e go'ya raiye poreguë'ë. Yë'ë Taitabi yë'ëre cuencueni raoguëna, ja'anre yo'oye poreguë'ë yë'ë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yihuoguë quëaguëna, judío bainbi achani, sa'ñeña coca bëinjën cajën, te'e ro'tamaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yequëcuabi ñaca cajën baë'ë: —Huati re'osi'quëbi ba'iji baguë. Ja'nca sëani, güebe nesi'quë'ru ro caguëna, baguë cocare achaye beoye bañu, cajën bën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bëinjënna, yequëcuabi ñaca sehuojën baë'ë: —Banji. Huati re'osi'quë ba'itoca, baguë cocareba case'e'ru ro'tani caye porema'ire'abi. Huati hua'ibi ñaco ëñama'icuani huachoni sëtoye gare porema'icua'ë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ja'nrëbi jë'te, judío bain fiesta umuguseña, Riusu huë'e mame re'huase'ere ro'tañu cajën, fiestare yo'ojënna, Jesusbi Riusu huë'ere baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sësë ocoye ba'irën ba'iguëna, Jesusbi huë'e tubëan ba'iru Salomón casirute ganiguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ba'iguëna, judío bainbi baguëna tëhuoni, baguë bonëjeiñe ñë'cani, baguëni senni achahuë: —¿Më'ë quejeito më'ë ba'iyete yëquënani te'e ruiñe masi güeseye ro'taguë'ne? Më'ëbi Riusu Raosi'quëreba, ba Cristo hue'eguë ba'itoca, yurera'rë yëquënani te'e ruiñe quëajë'ën. Ja'anre achaye ai ëjoni jëhuahuë yëquëna, senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Senni achajënna, Jesús sehuobi: —Mësacuani yë'ë ba'iyete yua ai quëani jëhuahuë yë'ë. Quëani jëhuaguëna, mësacuabi yë'ëni recoyo ro'tamaë'ë. Yë'ë Taitabi yë'ëre cuencueni raoguëna, baguë ta'yejeiye yo'oni ëñoguë ba'iyë yë'ë. Ja'nca yo'oni ëñoguëna, yë'ë ba'iyete masiye poreyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ja'nca masiye porecuata'an, mësacuabi yë'ë bainreba beocua sëani, yë'ëni recoyo ro'tama'icua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yë'ë bainreba ba'icuabi yua yë'ë cocare achani, yë'ëna te'e conni zi'iñë. Bacuani te'e ruiñe masiguë sëani, ");
INSERT INTO snnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","bacuani huajëreba huajë güeseyë yë'ë. Huajë güeseguëna, bacuabi carajeiye beoye ba'ijën, yë'ë naconi si'arën ba'ijën, gare junni huesëye beoye ba'iyë. Ja'nca ba'ijënna, bacuani senjoñe beoye ba'iguë, bacuani bayë yë'ë. Baguëna, yequëcuabi bacuani tëani baye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yë'ë Taita yua quë'rë Ta'yejeiyereba Ëjaguë ba'iguëbi bacuare yë'ëna insini jo'cabi. Insini jo'caguëna, yequëcuabi baguë bainrebare tëani baye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yë'ë Taita ba'iye'ru, yë'ë'ga güina'ru te'e ba'iyë, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sehuoguë caguëna, judío bainbi bëinjën, se'e gatare chiani, Jesusni senjoni huai ëaye ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ja'nca ro'tajënna, Jesusbi bacuani coca senni achabi: —Yë'ë Taitabi cuencueni raoguëna, baguë ta'yejeiye yo'o, re'o yo'ore ai ta'yejeiye yo'oni ëñohuë yë'ë. Ja'nca ëñoguëna, ¿mësacua gue re'o yo'o yo'ose'ere ro'tajën, yë'ëni gata senjoni huaiye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Senni achaguëna, bacuabi sehuohuë: —Më'ë re'o yo'o yo'ose'e ro'ire më'ëni gata senjoma'iñë yëquëna. Riusuni ai gu'aye casi'quëre sëani, më'ëni gata senjoni huaiyë. Ro bainguë ba'iguëbi Riusu ba'iye'ru te'e ba'iyë, cahuë më'ë. Ja'nca casi'quë sëani, ai gu'aye yo'oyë më'ë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sehuojënna, Jesusbi bacuani quëabi: —Mësacuabi ira coca toyani jo'case'e, mësacua ai yëse'e, ja'anre ëñatoca, ñaca caji: “Mësacua yua riusu sanhuë'ru te'e ba'iyë” cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Riusureba coca sëani, yequëcuabi quëñoni senjoñe porema'iñë. Baguë bain cuencuesi'cua, baguë cocarebare achani re'huasi'cua, ja'ancuare ja'nca quëani jo'casi'quë sëani, ");
INSERT INTO snnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿mësacua guere ro'tajën, yë'ë, Riusu cuencueni raosi'quë ba'iguëte Riusuni gu'aye caguë ba'iyete caye'ne? Yë'ëbi yua Riusu Zin ba'iyë caguëna, yë'ëre gu'aye cahuë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mësacuabi yë'ë Taita yo'ore yo'oma'iñë yë'ë, ro'tatoca, yua yë'ë cocarebare ro'tama'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ja'nca ro'tama'icuabi yë'ë yo'o yo'oni ëñose'e se'gare ro'tani, ñaca ye'yejë'ën: Yë'ë Taita yua yë'ë naconi te'e ba'iguëna, baguë naconi te'e ba'iyë yë'ë. Ja'anre ye'yeni masijë'ën, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Quëaguëna, bacuabi se'e baguëni preso zean ëaye yo'ojënna, baguëbi ro quëñëni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sani ja'nrëbi, Jordaña que ca'nco, ënsëguë etajei ca'ncona sani bëabi. Juan ru'ru bautizaguë ba'isiru ba'iguëna, bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ba'iguëna, ai jai jubë bainbi baguëni ëñajën saë'ë. Sani, ëñani, sa'ñeña coca cahuë: —Juan yua ta'yejeiye yo'oni ëñoma'iguëbi te'e ruiñe quëani achoguë baji'i. Ënquë ba'iye, ja'anre quëani achoguëna, te'e ruiñe se'ga baji'i baguë coca, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja'nrëbi, bainbi ja'anrute ba'ijën, ai jai jubëbi Jesusni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ja'nrëbi, yequë bainguë Lázaro hue'eguë, Betania huë'e jobo ba'iguëbi yua rau neni ju'inguë baji'i. María, Marta, bacua ma'yë ba'iguëbi bacua naconi te'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ja'an María hue'egobi ma'ña re'cobi jañuni, mai Ëjaguë guëonna tonni zoani, bago rañababi cuenago ba'ija'go baco'ë. Ja'nca ba'igo, yurera bago ma'yë Lázarobi rau neni ju'inguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ja'nca ba'iguëna, baguë romi yo'jecuabi cocare Jesusna saoni quëahuë: —Ëjaguë, më'ë gajeguë ai yësi'quëbi ju'inji, cocare cani saohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Saojënna, Jesusbi bacua cocare achani, baguë naconi ba'icuani cabi: —Ja'nca ju'inguë ba'iguëta'an, gare junni huesëma'iji. Go'ya raija'guëta'an ba'iji baguë. Go'ya raiguëna, bainbi Riusu ta'yejeiye ba'iyete ëñani masija'cua'ë. Yë'ë, Riusu Zin ba'iguëbi, Lázarobi go'ya raija'guëna, yë'ë ta'yejeiye ba'iyete bainni masi güeseyë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ja'nca caguëbi yua Marta, María, Lázaro, ja'ancuani ai yëguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ja'nca ba'iguëbi baguë ju'iñete achani, yuta se'e samu umuguseña baguë ba'irute ba'iguë ëjobi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ja'nca ëjoni ja'nrëbi, baguëre concuani cabi: —Raijë'ën. Judea yijana go'iñu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Caguëna, bacuabi sehuohuë: —Ëjaguë, ¿më'ë queaca ro'taguë, ja'anruna go'iguë'ne? Yurera judío bain ja'anru ba'icuabi më'ëni gatabi huani senjo ëaye yo'ohuë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sehuojënna, bacuani ye'yo cocabi yihuoguë quëabi: —Huaji yëma'ijë'ën. Umugusebi ënsëguë yua si'a sara samu hora miaji. Mia re'oto ba'iguëna, maibi ma'aja'an ganijën, gurujaiye beoye ba'iyë, re'oye ëñañe porecua sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ñamibi ganito'ga, gurujani taiñe se'ga ba'iyë, mia re'oto carajeise'e sëani, yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesús junni tonjairën yuta ti'anma'iguë sëani, ja'an cocare bacuani quëani achobi. Ja'nrëbi, se'e bacuani quëabi: —Mai gajeguë Lázaro yua cainsi'quë ba'iguëna, baguëni sëtojaza, caguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Quëaguëna, baguëre concuabi cahuë: —Ëjaguë, cainsi'quë ba'itoca, re'oji. Huajë raiye ba'iji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ja'nca cajën, huacha achasi'cua baë'ë. Jesusbi Lázaro junni huesëse'ere quëaguëna, baguë canni huajëye ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ja'nca ro'tajënna, Jesusbi bacuani te'e ruiñe quëabi: —Lázaro yua ju'insi'quë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mësacua yua yë'ëni si'a recoyo ro'taja'bë caguë, Lázaro ba'iruna yuta saimaë'ë. Ja'nca saima'iguëbi mësacua recoyo ro'taja'yete bojoguë, yuara baguëna saiñu, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Caguëna, Tomás hue'eguëbi yequë baguëre concuani cabi: —Mai'ga saiñu. Mai Ëjaguë naconi te'e junni huesëjaiñu, cabi. Ja'nca caguëbi yequë mami Te'e Të'ya Raisi Hua'na hue'eguë baji'i, yequë naconi te'e të'ya raisi'quë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ja'nrëbi, Jesús yua Lázaro ba'iruna sani ti'anni ëñato, gajese'ga umuguseña yua ju'insi'quëni tansi'quë baji'i, ");
INSERT INTO snnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania huë'e jobore, Jerusalén cueñe jai jobore. Samu kilómetro jobo ba'iye saito, ti'añë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Cueñe ba'iguëna, judío bain ai jai jubëbi Marta, María, bacua ma'yë junni huesëse'ere oijën, bacuani conjën raisi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ja'nrëbi, Martabi yua Jesús ti'anse'ere achani, baguëna tëhuojaco'ë, Maríabi huë'ere ba'igona. ");
INSERT INTO snnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tëhuojani, baguëni cago: —Ëjaguë, më'ëbi ënjo'onre ba'isi'quë ba'itoca, yë'ë ja'yëbi junni huesëma'ire'abi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ja'nca ba'iguëta'an, yurera ëñere masiyë yë'ë. Më'ëbi Riusuni sentoca, Riusubi më'ëna si'aye insini conji, cago. ");
INSERT INTO snnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Cagona, Jesús quëabi: —Më'ë ja'yëbi go'ya raija'guëta'an ba'iji, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Caguëna, bago sehuogo: —Aito. Ja'nca go'ya raija'guë'bi. Carajei umuguse ti'anguëna, ju'insi'cuabi go'ya rani huajëja'cua'ë, sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ja'nca sehuogona, Jesusbi bagoni quëabi: —Yë'ëbi yua bain ju'insi'cuare mame go'ya rai güeseye poreguë ba'iguë'ë. Huajëreba huajë güeseguë ba'iguë'ë yë'ë. Yë'ëni si'a recoyo ro'tacua, junni huesëye ba'icuata'an, ja'ancuabi huajëreba huajëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yë'ëni si'a recoyo ro'tajën ba'icuabi yua yë'ë naconi si'arën ba'ijën, gare junni huesëye beoye ba'ija'cua'ë. ¿Më'ë yua ja'anre si'a recoyo ro'tago? caguë senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Senni achaguëna, sehuogo: —Aito. Ro'tani, Ëjaguë. Më'ë yua Riusu Raosi'quëreba ba'iguë'ë. Riusu Zin ba'iguë'ë më'ë. Më'ë raija'yete ai zoe quëani achose'e ba'iguëna, yurera bainna raë'ë më'ë, sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja'nca sehuogo, ja'nrëbi, bago yo'jego Maríana go'ini, bagote choini, yahue quëago: —Mai Ëjaguëbi ti'anbi. Më'ëni choiji, quëago. ");
INSERT INTO snnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Quëagona, ja'ansirën huëni, etani, Jesús ëjoguë ba'iruna besa ëñago saco'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús yuta huë'e jobona ti'anmaji'i. Marta tëhuogo ba'isiru se'gare ëjoguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ja'nca etani saigona, judío bainbi bagote oijën conjën, bago etase'ere ëñani, Yequërë tansiruna oigo saigo cajën, bagoni yo'je be'tehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja'nrëbi, María yua Jesusna sani ti'anni, baguë guëon na'mina gugurini, baguëni cago: —Ëjaguë, më'ëbi ënjo'onre ba'isi'quë ba'itoca yë'ë ja'yëbi junni huesëma'ire'abi, cago oco'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ja'nca oigona, judío bain concua'ga be'teni oijënna, Jesusbi ëñani, baguë recoyo oiguë, ai sa'ntiguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ja'nca ba'iguë, bacuani senni achabi: —¿Mësacua jarona baguëte tanre'ne? senni achabi. Senni achaguëna: —Ëjaguë, rani ëñajë'ën, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sehuojënna, Jesusbi oji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ja'nca oiguëna, judío bainbi ëñani cahuë: —Lázaroni ai ba'iye ai oiguë, ai yëguë ba'iji, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Cajënna, yequëcua bacua jubë ba'icuabi cahuë: —Baguë yua ñaco ëñama'icuare huachosi'quë sëani, ¿queaca ro'taguë, Lázaroni huachomaquë'ne baguë? cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Cajënna, Jesusbi se'e recoyo ai sa'ntiguë oji'i. Oiguë, Lázaro tansiruna saji'i. Gata të'ntëba te'ntosi goje ba'iguë, gatabëbi ta'pini quëonse'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ba'iguëna, Jesusbi: —Gatabëte otani quëñojë'ën, cabi. Caguëna, ja'nrëbi, Marta, ba ju'insi'quë yo'jegobi Jesusni cago: —Ëjaguë, gajese'ga umuguseña ju'insi'quë sëani, otatoca, ai ëto sëñe ba'iji, cago. ");
INSERT INTO snnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Cagona, Jesusbi sehuobi: —Marta, yë'ë quëase'ere ro'tajë'ën. Më'ëbi yë'ëni si'a recoyo ro'tatoca, Riusu ta'yejeiyereba ba'iyete ëñañë më'ë, quëahuë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sehuoguëna, gatabëte otani quëñohuë. Quëñojënna, Jesusbi mëiñe ëñani, Riusuni coca cani achobi: —Taita, më'ëbi yë'ë cocare achaguëna, më'ëni ai bojoguë, surupa cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Më'ëbi yë'ë cocare jo'caye beoye achaguëna, yë'ëbi masini bojoyë. Yureca, ënjo'on bain nëcacuare ro'taguë, yë'ë cocare më'ëni caguë ba'iyë yë'ë. Më'ëbi yua yë'ëre cuencueni raose'e, ja'anre si'a recoyo ro'taja'bë caguë, më'ëni ën cocare caguë ba'iyë yë'ë, cani achobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cani achoni ja'nrëbi, ai jëja güiguë cabi: —¡Lázaro, huëni raijë'ën! caguë choji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Choiguëna, ju'insi'quëbi huajëni, huëni raji'i. Ja'nca raiguë, baguë ëntë sara, baguë guëon, baguë zia yua canbi re'o jobë huensi'quë baji'i. Ba'iguëna, Jesusbi guanseguë cabi: —Baguë canre jo'chijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ja'nca yo'oguëna, judío bain María naconi rani baguë yo'ose'ere ëñasi'cua, ai jai jubëbi baguëni si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yequëcuata'an, Jesusni recoyo ro'tamaë'ë. Ro'tama'icuabi yua fariseo bainna sani Jesús yo'ose'ere quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ja'nca quëajënna, pairi ëja bain, fariseo bain, bacuabi ñë'cani sa'ñeña coca cahuë: —Baguë yua ai ta'yejeiye yo'oni ëñoguëna, ¿queaca baguëni ënseye'ne mai? ");
INSERT INTO snnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ënsema'itoca, quë'rë ai jai jubë bainbi baguëni recoyo ro'tayë. Ja'nca ro'tani bacua ëjaguëre baguëte re'huajënna, romano ëja bainbi rani, mai uja huë'e, Riusu huë'ere taonni senjoñë. Maini ai huajënna, maibi carajeiyë, sa'ñeña cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Cajënna, yequë bacua jubë ba'iguë, Caifás hue'eguë, yua ja'an tëcahuë pairi ta'yejeiye ëjaguë baji'i. Ja'nca ba'iguëbi bacuani coca cabi: —Mësacua yua ro huesë ëaye cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Si'a jubë bainbi carajeima'iñe cajën, te'eguë se'gabi junni huesëja'guë cayë mai. Ja'an ba'ija'ye yua quë'rë re'oye ba'iye ba'iji maire. Ja'anre caguë mësacua huesë ëaye cacuare quëani achoyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás se'gabi ja'an cocare ro'tamaji'i. Ja'an tëcahuë pairi ta'yejeiye ëjaguëte sëani, Riusubi ja'an cocare baguëni ro'ta güeseguëna, Riusu ëñose'e yuta ti'anma'iguëna, quëani achobi baguë. Jesús junni huesëja'ye, Israel bain ro'ire junni huesëja'ye baji'i, quëani achobi baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Israel bain ro'i se'gare Jesusni cuencuemaji'i Riusu. Si'a re'oto bain saoni senjosi'cua, Riusu mamacua ba'icuare cu'eni, te'e jai jubëna choini ñë'coye ro'tabi Riusu. Ja'nca sëani, si'a bain ro'ire Jesús junni huesëja'yete cuencueni, Caifasni ro'ta güesebi Riusu, ");
INSERT INTO snnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ja'nca sëani, judío ëja bainbi ja'an umugusebi Jesusni huani senjoñe ro'tajën, sa'ñeña coca cajën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ja'nca cajën ba'ijënna, Jesusbi judío bain jubëan naconi se'e ganimaji'i. Yequëru, beo re'oto ba'iguëna, ja'anruna sani, Efraín casi jobona ti'anni, baguëre concua naconi bëani baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja'nrëbi, judío bain pascua umuguseñabi ti'añe ba'iguëna, ai jai jubë bainbi Jerusalenna sai bi'rahuë. Riusubi maini te'e ruiñe ëñani bojoja'guë cajën, Riusu huë'ena cacani, bacua ira bain ba'isi'cua yo'ojën ba'ise'e'ru tëno güesehuë. Ja'nrëbi, pascuabi ti'anguëna, fiestare yo'oye ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Riusu huë'ere ba'icuabi yua Jesusni cu'ejën, sa'ñeña senni acha bi'rahuë: —¿Mësacua guere ro'taye'ne? ¿Fiestana raima'iguë baguë? senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo bain, pairi ëja bain, bacuabi yua guanse cocare toyani jo'cajën cahuë: Jesús ba'iyete masitoca, yëquënani quëani achojë'ën. Quëani achojënna, baguëni preso zeañë yëquëna, guansejën cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ja'nrëbi, pascua umuguseña ti'añe, te'e ëntë sara te'e umuguseña caraguëna, Jesusbi Betania huë'e jobona saji'i. Lázaro yua junni huesëni go'ya raisi'quë ba'iguëna, baguëna ëñaguë saji'i Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sani ti'anguëna, baru bainbi baguëni bojojën, aonre re'huacaë'ë. Martabi aon cuiragona, Lázarobi baguë naconi aon ainguë ñuji'i, yequëcuabi conjënna. ");
INSERT INTO snnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ja'nca aon ainjënna, Maríabi ma'ña re'co jobo litro ba'iyete inni rago. Nardo casi ma'ña se'gabi re'huase'e sëani, ai ba'iye ai roji'i. Ja'an re'core rani, Jesús guëonna jañuni tonni zoago. Zoani, bago rañababi cuenagona, si'a huë'e ca'ncona ma'ña sën re'otora runji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ja'nca ruinguëna, ja'nrëbi, Judas Iscariote hue'eguë, Jesusre concua jubë ba'iguë, Jesusre insini senjoja'guë, ja'anguëbi bëin coca cabi: ");
INSERT INTO snnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Queaca ro'tago, ma'ñare jañuni senjogo'ne? Bonse cocuana insitoca, samute cien denario so'core coni, bonse beo hua'nana insiye porere'ahuë mai, bëinguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bonse beo hua'nani gare oiye beoye baji'i baguë. Jian huati sëani, ja'nca cabi. Bacua curi re'huacai ëjaguë ba'iguë, ba curire yua yahue insi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Caguëna, ja'nrëbi, Jesusbi sehuobi: —Bagote ënsema'ijë'ën. Yë'ëre tanjai umugusere ro'tago yo'ogo. ");
INSERT INTO snnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bonse beo hua'nabi si'arën mësacua naconi ba'icuata'an, yë'ëca banguë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ja'nrëbi, judío bain ai jai jubëbi, Jesusbi Betania ba'iguëna, achani, ëñajën saë'ë. Jesús se'gare ëñañe ro'tamaë'ë. Lázarore'ga ëñañe ro'tahuë, junni huesëni go'ya raisi'quëre sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ja'nca ëñañe ro'tajën, ai jai jubë judío bainbi Lázaroni ëñani, Jesusni si'a recoyo ro'tajën, bacua pairi coca ye'yose'ere jo'cani senjo bi'rahuë. Ja'nca sëani, pairi ëja bainbi Lázarore'ga huani senjoñe ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ja'nrëbi, yequë umuguse ñataguëna, ai jai jubë bainbi Jerusalenna fiesta yo'ojën ti'anjën, Jesús raiyete achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ja'nca achani, ju'care tëyoni, Jesusni tëhuojaë'ë. Tëhuojaijën, baguëni bojojën, ai jëja cani achohuë: —¡Riusubi ai Ta'yejeiye Ëjaguërebabi ba'iji! ¡Baguë cuencueni raosi'quëbi maina ti'anguëna, baguëni bojoreba bojojën bañuni! ¡Israel bain ta'yejeiye ëjaguëre sëani, baguëni bojojën bañuni! jëja cajën baë'ë bain jubë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ja'nrëbi, Jesús yua burro hua'guë bonsëguëte tinjani tuabi. Riusu ira coca toyani jo'case'e'ru güina'ru yo'obi, ën coca jo'case'ere'ru: ");
INSERT INTO snnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mësacua Jerusalén huë'e jobore ba'icua yua huaji yëye beoye ba'ijë'ën. Mësacua Ëjaguë raiyete ëñani, baguëni masijë'ën. Burro hua'guë bonsëguëte tuiguë raiji, cani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ja'nca ba'iguëna, Jesusre concuabi ja'an cocare ru'ru achaye huesëhuë. Ja'nrëbi yo'je, Jesús ta'yejeiye ëño umugusebi ti'anguëna, bacuabi yua Riusu coca toyani jo'case'ere ro'tani, ja'an cocabi Jesús yo'oja'yete quëani jo'case'e ba'iguëna, ro'tani masihuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ja'nrëbi, yequëcua Lázaro go'ya raise'ere ëñasi'cua baë'ë. Jesusbi Lázaroni raiye choni, baguëni go'ya raiye huëaguëna, bacuabi ëñani, yurera si'a bainni quëani achojën baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ja'nca quëani achojënna, bainbi achani, si'a jubëbi baguë ta'yejeiye yo'oni ëñose'ere masini, ja'anre ro'tani, baguëna tëhuojën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tëhuojën saijënna, fariseo bainbi sa'ñeña cahuë: —Yua si'a bainbi baguëni conjën saiyë. Ja'nca sëani, mësacuabi ënseye beoye ba'iyë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yureca, yequëru bain, Jerusalenna fiesta yo'ojën saisi'cua, griego bain baë'ë. Riusuni gugurini rëañu cajën saisi'cua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ja'nca ba'icuabi Felipe hue'eguë, Betsaida huë'e jobo bainguë, Galilea yijabi raisi'quë, ja'anguëna sani, baguëni coca senni achahuë: —Jesús naconi coca caye yëyë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Cajënna, Felipebi Andresna sani quëabi. Quëaguëna, ba samucuabi jubë sani Jesusni quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Quëajënna, Jesusbi sehuobi: —Yë'ë yua si'a bainna Raosi'quëreba sëani, yë'ë ta'yejeiye ba'iyete ëñojairën yuara ti'añe ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ganreba mësacuani yihuoguë quëayë yë'ë. Aonra'carëte yijana tanni pu'ncani si'ara'carëte jo'cama'itoca, aon sahuabi irama'iji. Ai ba'iye ai aon quëinma'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ja'nca ba'iguëna, bain ba'iyete ro'tato, güina'ru ba'iyë. Ro bacua ba'iye se'gare'ru huanotoca, ro huesëni carajeiyë. Bacua yure ba'iyete jo'cani senjotoca, Riusu ba'i jobona ti'anni, huajëreba huajëjën, gare carajeiye beoye ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yë'ë yo'ore coñe yëtoca, yë'ë cocarebare te'e ruiñe achani caraye beoye yo'ojën ba'ijë'ën. Yë'ë yo'ore te'e contoca, yë'ë naconi Riusu ba'i jobore te'ereba ba'ija'cua'ë. Yë'ë yo'ore te'e ruiñe concua, ja'ancuare te'e ruiñe ëñani bojoji yë'ë Taitabi, sehuoguë cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Cani ja'nrëbi, baguë junni huesëja'yete quëabi: —Yureca, si'a recoyo ai sa'ntiguë ba'iyë yë'ë. Ja'nca ba'iguë, ¿gue cocare caye'ne yë'ë? “¿Taita, yë'ë ai yo'oguë junni huesëyete yë'ëre jo'cama'ijë'ën” caguë? Bañë. Junni huesëguë raisi'quë'ë yë'ë, ën yijana. ");
INSERT INTO snnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taita, më'ë ta'yejeiye ba'iyete yurera ëñojë'ën, ujaguë cabi. Caguëna, ja'nrëbi, guënamë re'otobi coca cani achobi: —Yë'ë ta'yejeiye ba'iyete yuareba bainre masi güesehuë yë'ë. Ja'nca masi güeseni, se'e masi güeseja'guë'ë yë'ë, cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Cani achoguëna, bain jubëbi barute nëcajën achahuë. Achani, yequëcuabi mëjo guruye'ru achoye quëahuë. Yequëcuabi: —Anje hua'guëbi baguëni coca cabi, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Cajënna, Jesusbi quëabi: —Riusubi yuara mësacua achaye se'gare ba'ijë'ën caguë, guënamë re'otobi coca cani achobi. Yë'ë se'ga achaye ro'tamaji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yureca Riusu bënni senjorën yua ti'anja'ñeta'an ba'iji. Gu'a bainni bënni senjoñe ba'iji. Zupai huati'ga bain recoyo ëjaguë ba'iguëna, Riusubi ja'anguëte saoni senjoñe ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ja'nrëbi, gu'a bainbi yë'ëni crusu sa'cahuëna reojënna, yë'ëbi yua yë'ë bainreba si'acuani choni ñë'coni bayë, caguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ja'nca quëaguë, baguë crusu sa'cahuë junni tonja'ñete masi güesebi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Masi güeseguëna, bain jubë ba'icuabi sehuohuë: —Yëquënabi Riusu coca toyani jo'case'ere ëñajën, Cristo carajeiye beoye ba'iye ye'yehuë. Ja'nca sëani, huacha cahuë më'ë. ¿Queaca ro'taguë më'ë, bainna Raosi'quërebabi crusu sa'cahuëna junni toñe ba'iji caguë'ne? ¿Bainna Raosi'quëreba hue'eguë, jaroguëguë'ne? sehuojën senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Senni achajënna, Jesusbi quëabi: —Mësacua recoñoana miaguë, yuta rëño ñësebë ba'irënbi yë'ë cocare mësacuani ye'yoguë masi güeseye ba'iyë yë'ë. Ja'nca ye'yoguë masi güeseguëna, mësacua te'e ruiñe ye'yejën, re'o ma'ana ganijën ba'ijë'ën. Zijei re'otona ganima'iñe cajën, re'o ma'aja'an ganijën ba'ijë'ën. Zijei re'otona ganicuabi ro huesëjën, bacua carajeiyete ëñama'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ja'nca sëani, mësacuabi yë'ëni si'a recoyo ro'tajën ba'ijë'ën. Yë'ë yua bain recoñoana miañe ëño cocare recoñoa re'huani bajën, yë'ë bainreba ruinjë'ën, yihuoguë quëabi Jesús. Quëani tëjini, ja'nrëbi, bain jubë ba'irubi quëñëni gatibi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yuara Jesusbi ai ba'iye ai ta'yejeiye yo'oni, bainni ëñoguëta'an, baguëni recoyo ro'taye gu'a güehuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Riusu ira bainguë raosi'quë Isaías hue'eguë, baguë coca cani jo'case'e'ru güina'ru yo'ohuë. Riusu zoe ba'irën quëani jo'case'e'ru güina'ru yo'ohuë bacua: Ëjaguë, mai cocareba te'e ruiñe quëani achose'eta'an, recoyo quëani achose'eta'an, recoyo ro'tacuabi beoyë. Riusu ta'yejeiye yo'oni ëñose'eta'an, ëñañe güecua se'ga ba'iyë, cani jo'cabi Isaías. ");
INSERT INTO snnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ja'nca cani jo'case'e sëani, yureña bain'ga recoyo ro'taye beoye ba'iyë. Ja'nrëbi, Isaías yua se'e yeque cocare cani jo'caguë ba'nji: ");
INSERT INTO snnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Riusubi coca caguëna, recoyo ro'taye gu'a güecua'ru saë'ë bacua. Ñaco ëñama'icua ba'iye'ru ye'yeye beocua saë'ë bacua. Bacua ñacobi ëñañe güejën, bacua recoñoabi ro'tani yë'ëni ye'yeye gu'a güecua, ja'an'ru ba'icua sëani, yë'ëna bonëni huajë raiye beoyë bacua, cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaíasbi yua Riusu Raoja'guëreba ba'iguë, baguë ta'yejeiye ba'iyete ëñasi'quë sëani, ja'an coca Jesús ba'ija'yete cani, maina jo'caguë ba'nji. ");
INSERT INTO snnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ja'an bainbi Jesusni recoyo ro'taye güecuata'an, yequëcuabi Jesusni si'a recoyo ro'tahuë. Ëja bain'ga choa jurë baguëni recoyo ro'tahuë. Recoyo ro'tacuata'an, fariseo bainni huaji yëjën, bacua recoyo ro'tayete quëani achomaë'ë. Fariseo bainbi bacuani bacua jubë ñë'caye ënsema'iñe cajën, bacuabi huaji yëjën, bainre quëani achomaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ja'nca quëani achoma'icuabi Riusu te'e ruiñe ëñañete cu'eye ro'tajën ba'icuata'an, ro bain ruiñe ëñañete quë'rë cu'ehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ja'nrëbi, Jesusbi bainni si'a jëja cani achobi: —Yë'ë yua yë'ë Taita cuencueni raosi'quëre si'a recoyo ro'tacuabi yua yë'ë Taitare'ga si'a recoyo ro'tayë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yë'ëni ëñani masicuabi yua yë'ë Taitare'ga, yë'ëre cuencueni raosi'quëre ëñani masiyë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja'nca yë'ëre raoguëna, si'a bainna yë'ëre cuencueni raosi'quëre ëñoguë raisi'quë'ë yë'ë. Mia re'oto ñatani saoye'ru bain recoñoana ëñoguë raisi'quë'ë yë'ë. Yë'ëni si'a recoyo ro'tacuabi zijei re'otona ro huesë hua'na'ru ganima'ija'bë caguë, bainni ëñoguë raisi'quë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bainbi yë'ë cocarebare ro achani, yë'ëni recoyo ro'taye güetoca, yë'ëbi bacua bënni senjoja'ñete cani jo'cama'iñë. Bainre bënni senjoja'ñete cani jo'caguë raimaë'ë yë'ë. Bain zemosi'cuare tëani baza caguë raisi'quë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bainbi yë'ë cocarebare ro achani, yë'ëni recoyo ro'taye güetoca, yequëbi bacuare bënni senjoja'ñete bacuani masi güeseji. Ja'nca masi güeseguëbi yë'ë cocarebare cani jo'case'ere bacuani ro'ta güeseguëna, bacua bënni senjoja'ñete masiyë bacua, carajei umugusebi ti'anguëna. ");
INSERT INTO snnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yë'ë se'gabi ja'an cocare ro'tani quëama'iñë yë'ë. Yë'ë Taita, yë'ëre cuencueni raosi'quë, ja'ansi'quëbi yë'ë coca te'e ruiñe caye, ja'anre guanseni, yë'ëna jo'cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yë'ë Taitabi coca guanseguëna, te'e ruiñe achani yo'ojën ba'ijë'ën. Ja'nca yo'otoca, baguë naconi te'e ba'ijën, gare junni huesëye beoye ba'iyë. Ja'nca sëani, yë'ë Taitabi guanseguëna, baguë coca se'gare'ru güina'ru quëani achoguë ba'iyë yë'ë, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ja'nrëbi, pascua aon fiesta ja'anrë ba'i umuguse ti'anguëna, Jesusbi baguë Taitana yuara go'iye ro'taguë, ën yijare gare jo'cani go'iye, ja'anre masibi. Ja'nca masiguëbi baguë bainreba ën yijare ba'icuani ai oiguë bani, bacuani caraye beoye quë'rë ai yëguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ja'nrëbi, pascua aon fiesta ba'iguëna, Jesús yua baguëre concua naconi, bacuabi aon ainjën ñuë'ë. Ñu'ijënna, zupai huatibi Judas Iscariote hue'eguë, Simón mamaquë casi'quë, ja'anguëni yuara gu'aye yo'oye ro'ta güesebi. Jesusre insini senjoñe baguëni ro'ta güesebi zupai. ");
INSERT INTO snnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ja'nca ba'iguëna, Jesusbi baguë Taita baye si'aye baguë Taitana cosi'quë baji'i. Baguë Taita cuencueni raosi'quëbi yua baguë Taitana go'iye baji'i. Ja'anre masibi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ja'nca masiguëbi yua huëni nëcani, baguë ju'i canre rutani, toallare inni tëanbi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tëanni ja'nrëbi, ocobi guëna ro'rohuëna queoni, baguëre concua guëonre zoani, baguë toalla tëinbëbi cuenabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ja'nca zoaguëbi yua Simón Pedro ba'iruna ti'anguëna, baguëbi yua coca senni achabi: —Ëjaguë, ¿Yë'ë guëoñare zoaye ro'taguë më'ë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Senni achaguëna, Jesús sehuobi: —Më'ë guëoñare zoaguëna, më'ëbi yureña ro huesë ëaye ëñañë. Jë'te, më'ëbi ro'tani masiyë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Quëaguëna, Pedro yua ënseye cabi: —Yë'ë guëoñare gare zoama'ijë'ën, cabi. Caguëna, Jesús cabi: —Më'ë guëoñare zoama'itoca, yë'ë naconi te'e ba'iye gare porema'iñë më'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Caguëna, Simón Pedrobi sehuobi: —Ëjaguë, ja'nca ba'itoca, yë'ë guëoña, yë'ë ëntë saraña, yë'ë sinjobë, si'aye zoajë'ën, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Caguëna, Jesusbi yihuoguë quëabi: —Abusi'cuabi yua si'a ga'nihuë tënosi'cua sëani, se'e zoaye bañë. Guëoña se'gare zoaye bayë. Mësacua yua recoyo tënosi'cua ba'iyë. Te'eguë se'ga gu'a recoyo baguëbi ba'iji, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Baguë insini senjoja'guëte masiguë sëani, “Te'eguë se'ga gu'a recoyo baguëbi ba'iji” cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ja'nrëbi, bacua guëoñare zoani tëjini, baguë ju'i canre se'e sayani, se'e ñu'i seihuëna bëani, bacuani yihuoguë cabi: —Yureca, mësacua guëoña zoase'ere ro'tani ye'yejë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mësacuabi Masiguë, Ëjaguë, ja'anre yë'ëni cajën, te'e ruiñe cayë, mësacua Ëjaguëte sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mësacua Ëjaguë ba'iguëbi mësacua guëoñare zoasi'quë sëani, mësacua'ga sa'ñeña guëoña zoajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yë'ë zoase'ere ro'tani ye'yejë'ën. Ro yo'o concua yo'oye'ru mësacuani güina'ru yo'ohuë yë'ë. Mësacua'ga güina'ru sa'ñeña yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mësacuani ganreba quëani achoyë yë'ë. Yo'o concuabi bacua ëjacua'ru quë'rë ta'yejeiye beoyë. Güina'ru, mësacua yua yë'ë yo'o coñe raosi'cua sëani, yë'ë'ru quë'rë ta'yejeiye beoyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mësacuabi ja'anre ye'yeni masitoca, ja'anre te'e ruiñe yo'ojën ba'ijë'ën. Ja'nca ba'itoca, ai bojoreba bojojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mësacuani yihuoguë, mësacua jubë ba'iguë te'eguëni ja'nca yihuoma'iñë yë'ë. Ja'anguëte masiye cuencueni re'huahuë yë'ë. Riusu coca toyani jo'case'e'ru: “Yë'ë naconi te'e aon ainguëbi yë'ëni je'o eñabi” ja'an coca toyani jo'case'e'ru, güina'ru ba'ija'guë caguë, baguëte cuencuehuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ja'an ba'iye yuta ti'anma'iguëna, mësacuani quëahuë yë'ë. Ja'an ba'iye ti'anguëna, mësacuabi ëñani, yë'ë yua Riusu Raosi'quëreba ba'iguëte te'e ruiñe masiyë. Ja'nca sëani, yureña mësacuani quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mësacuani ganreba quëani achoyë yë'ë. Yë'ë cuencueni raosi'cuani te'e ruiñe ëñacuabi yë'ëre'ga te'e ruiñe ëñacua ba'iyë. Yë'ëni te'e ruiñe ëñacuabi güina'ru yë'ëre raosi'quëni te'e ruiñe ëñacua ba'iyë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja'nca quëani ja'nrëbi, Jesús yua recoyo ai sa'ntiguë, ai oiguë quëabi: —Mësacuani ganreba quëayë yë'ë. Mësacua jubë ba'iguë, te'eguëbi yë'ëre coqueguë, yë'ëre insini senjoja'guë'bi, caguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Caguëna, ja'nrëbi, bacuabi sa'ñeña ëñajën, baguë casi'quëre huesë ëaye cu'ehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ja'nca cu'ejënna, yequë bacua jubë ba'iguë Jesús ai yësi'quë, ja'anguëbi Jesús ca'ncore cueñe ñu'iguëna, ");
INSERT INTO snnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedrobi baguë ëntë sarabi ña'queni, Baguë casi'quëre senni achani, yëquënani quëajë'ën, senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Senni achaguëna, Jesús ai yësi'quëbi yua Jesús ca'ncore cueñe ñu'iguë, Jesusni senni achabi: —Ëjaguë, ¿jaroguëbi më'ëre insini senjoja'guëguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Senni achaguëna, Jesús sehuobi: —Yureca ën aon ma'carëte yë'ë aon ro'rohuëna tanni, yequëna insiyë yë'ë. Insiguëna, ja'an coguëbi yë'ëre insini senjoja'guë'bi ba'iji, quëabi. Quëani, ba aon ma'carëte baguë ro'rohuëna tanni, ja'nrëbi Judas, Simón Iscariote mamaquë, ja'anguëna insibi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Insiguëna, Judasbi coguëna, ja'nrëbi, zupai huatibi baguë recoyona cacani bëasi'quë baji'i. Ba'iguëna, Jesús yua Judasni cabi: —Më'ë yo'o cuencuese'e yua besa sani yo'ojaijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Caguëna, yequëcua aon ainjën ñu'icuabi baguë cocare ro huesë ëaye achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas yua bacua curi re'huacaiguë sëani, yequëcuabi Jesús case'ere ro'tajën, Fiesta yo'o ma'carëanre cojaijë'ën cabi baguë, ro'tajën achahuë. Yequëcuabi, Bonse beo hua'nana curi insijë'ën cabi baguë, ro'tajën achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ja'nrëbi, Judas yua Jesús aon ma'carëte cosi'quëbi ja'ansirën, ñami ba'iguëna, etani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ja'nca saquëna, Jesusbi coca yihuo bi'rabi: —Yureca, yë'ë, Bainguë'ru Raosi'quëreba ba'iguë, yë'ë ta'yejeiyereba ba'iyete yurera bainni ëñoja'ñe ba'iji. Ja'nca ba'iguë, Riusu ta'yejeiyereba ba'iyere'ga bainni ëñoñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yë'ë yua Riusu ta'yejeiyereba ba'iyete bainni ëñoguëna, Riusu'ga güina'ru yë'ë ta'yejeiyereba ba'iyete bainni ëñoji. Yurera ja'ansirën ja'nca ëñoji Riusu. ");
INSERT INTO snnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yureca, mami sanhuë, yuta rëño ñësebë se'ga mësacua naconi ba'iguë, ja'nrëbi, gare saiyë yë'ë. Saiguëna, mësacuabi yë'ëre cu'ejën ba'ija'cua'ë. Judío bainni quëase'e'ru mësacuani güina'ru quëayë yë'ë: Yë'ë saija'runa ti'añe porema'iñë mësacua, quëayë. ");
INSERT INTO snnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ja'nca sëani, mame guanse cocare mësacuani cani jo'cayë yë'ë. Sa'ñeña ai yëjën ba'ijë'ën. Yë'ë yua mësacuani ai yëguë ba'ise'e'ru, güina'ru sa'ñeña ai yëjën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ja'nca sa'ñeña ai yëjën ba'itoca, si'a bainbi ëñani, yë'ë bainreba concua ba'iyete masiyë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Quëaguëna, ja'nrëbi, Simón Pedrobi baguëni cabi: —Ëjaguë, ¿jarona saiye ro'taguë'ne? caguë senni achabi. Senni achaguëna, sehuobi: —Yë'ë saija'runa yure conguë saiye porema'iñë më'ë. Jë'te, më'ëbi conguë saiye poreyë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Caguëna, Pedrobi baguëni senni achabi: —Ëjaguë, ¿më'ë queaca ro'taguë, yure më'ëre conguë saiye porema'iñe caguë'ne? Më'ëbi junni huesëye ba'itoca, yë'ë'ga më'ë naconi te'e ju'injaza, caguë cayë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Caguëna, Jesús sehuobi: —¿Yë'ë ro'ire ju'iñe ro'taguë më'ë? Më'ëni ganreba caguë quëayë yë'ë. Cura yu'irën yuta ti'anma'iguëna, më'ëbi samute ba'iye yë'ëre ëñama'iñe caguë coqueja'guë'ë më'ë, sehuobi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sehuoni, ja'nrëbi, se'e bacuani coca yihuobi: —Mësacua recoyo sa'ntiye beoye ba'ijë'ën. Riusuni si'a recoyo ro'tajën ba'ijë'ën. Güina'ru, yë'ëni si'a recoyo ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yë'ë Taita ba'i jobore quëato, ai jai jobo ba'iji. Ja'nca ba'iguëna, mësacuani te'e ruiñe quëahuë. Coqueye beoye quëaguë, mësacua ba'ija'rute re'huacaiguë saiye quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mësacua ba'ija'rute re'huacani, ja'nrëbi, mësacuare se'e inguë raiyë yë'ë. Mësacua'ga yë'ë naconi te'e ba'ijë'ën caguë, mësacuare inguë raiyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yë'ë sai ma'are yuareba masiyë mësacua, yihuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Quëaguëna, Tomasbi baguëni senni achabi: —Ëjaguë, më'ë saija'rute huesëyë yëquëna. Ja'nca huesëcua sëani, ¿queaca ba ma'are masiye poreye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Senni achaguëna, Jesús sehuobi: —Riusu ba'i jobona saiye yëtoca, yë'ë ba'iye se'gare ye'yeni, ba ma'a masijë'ën. Te'e ruiñe ba'iyete masiye yëtoca, yë'ë ba'iye se'gare ye'yejë'ën. Huajëreba huajëye yëtoca, yë'ë se'gabi bainni huajë güeseyë. Riusuna ti'añe yëjënna, yë'ë se'gabi ba ma'are ëñoñë. Yequëcua ba ma'a ëñocua beoyë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mësacuabi yë'ëni masijën ba'isi'cua ba'ijënna, mësacua yua yë'ë Taitare'ga masijën ba'iyë. Yë'ë Taitare yure ëñani masihuë mësacua, sehuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Quëaguëna, Felipebi baguëni cabi: —Ëjaguë, Taita Riusure yëquënani ëñojë'ën. Ëñoguëna, yëquënabi ëñani, bojoye se'ga ba'iyë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Caguëna, Jesús sehuobi: —Felipe, yë'ë yua më'ë naconi zoe ba'iguëna, ¿më'ë queaca ro'taguë, yë'ëni masima'iguë'ne? Yë'ëni ëñani masicuabi Taita Riusure'ga ëñani masicua ba'iyë. Ja'nca sëani, ¿më'ë queaca ro'taguë, Taita Riusure yëquënani ëñojë'ën caguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yë'ë yua Taita Riusu naconi te'e ba'iyë. Taita Riusu'ga yë'ë naconi te'e ba'iji. ¿Ja'anre recoyo ro'tama'iñe mësacua? Yë'ëbi coca yihuoguë, ro yë'ë se'gabi ba yihuo cocare ro'tama'iñë. Yë'ë Taita yë'ë naconi te'e ba'iguë, baguëbi yë'ëni yihuo cocare ro'ta güeseji. Baguëbi baguë yo'ore yë'ëni yo'o güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yë'ë yua Taita Riusu naconi te'e ba'iguë, ja'anre quëaguëna, mësacua yua ja'anre si'a recoyo ro'tajën ba'ijë'ën. Ja'anre ro'tama'itoca, yë'ë Taita yo'o yo'oni ëñose'e se'gare ëñani, si'a recoyo ro'tajën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mësacuani ganreba caguë quëayë yë'ë. Yë'ëni recoyo te'e ruiñe ro'tajën ba'icuabi yë'ë yo'o yo'oye poreye'ru güina'ru yo'oye poreyë. Ja'nrëbi, yë'ëbi Taita Riusuna go'iguë sëani, quë'rë ta'yejeiye yo'o yo'oye poreja'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yë'ëni si'a recoyo ro'tajën, yë'ë yo'oyete yë'ëni senni achajën ba'ijë'ën. Ja'nca senni achatoca, mësacua señete si'aye yo'oyë yë'ë. Ja'nca yo'oguë, Taita Riusu ta'yejeiyereba ba'iyete bainni ëñoñë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yë'ëni si'a recoyo ro'tajën sentoca, si'aye yo'oguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mësacuabi yë'ëni ai yëjën ba'itoca, yë'ë coca guanseni jo'case'ere yo'ojën ba'iyë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ja'nca yo'ojën ba'itoca, yë'ëbi yë'ë Taitani ujaguë, yequë yihuoguë conguëte mësacuana raoye señë, mësacua naconi jo'caye beoye conguëte. ");
INSERT INTO snnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja'anguëbi yua Riusu Espíritu sëani, Riusu te'e ruiñe ba'iyete mësacuani masi güeseji. Ro bain hua'nabi baguëte huesëjën, baguëni baye porema'iñë. Baguëni ëñani masiye gare porema'iñë. Mësacua recoñoare ba'ija'guë sëani, mësacuabi baguëni masijënna, mësacuare jo'caye beoye conreba conji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mësacuare yëhui hua'nare'ru ro jo'cani senjoñe beoye ba'iyë yë'ë. Jë'te, mësacuare conguë raiyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yua rëño ñësebë ba'iguëna, ro bain hua'na yë'ëni recoyo ro'tama'icuabi yë'ëni se'e ëñama'iñë. Mësacuaca yë'ëni ëñaja'cua'ë. Yë'ëbi huajëguë ba'ija'guë sëani, mësacua'ga huajëreba huajëjën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Riusu Espíritu rai umuguse ti'anguëna, yë'ë yua yë'ë Taita naconi te'e ba'ija'guë'ë. Güina'ru mësacuabi yë'ë naconi te'e ba'ijënna, yë'ë yua mësacua naconi te'e ba'ija'guë'ë. Ja'anre te'e ruiñe masija'cua'ë mësacua. ");
INSERT INTO snnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yë'ë coca guanseni jo'case'ere achani yo'ocua, ja'ancuabi yë'ëni ai yëjën ba'iyë. Yë'ëni ai yëcua, ja'ancuani yë'ë Taitabi ai yëguë ba'iji. Yë'ë'ga ja'ancuani ai yëguë ba'iguë, yë'ë ba'iyete bacua recoñoa huanoñe'ru bacuani ëñoñë yë'ë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Quëaguëna, yequë Judas, Iscariote hue'ema'iguë, baguëbi coca senni achabi: —Ëjaguë, më'ëbi yëquënani ëñoguë, ro bain më'ëni recoyo ro'tama'icuani ëñoma'iñe cahuë më'ë. ¿Më'ë guere ja'an yo'oguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Senni achaguëna, Jesús sehuobi: —Yë'ëni ai yëjën ba'icua, yë'ë cocarebare achani yo'ojën ba'icua, ja'ancuani ëñoja'guë'ë yë'ë. Yë'ë Taitabi bacuani ai yëguë ba'iji. Ja'nrëbi, yëquëna samucuabi bacuana ti'anni, bacua recoñoare te'e ba'ijën, bacuare gare jo'caye beoye ba'ija'cua'ë yëquëna. ");
INSERT INTO snnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yequëcua yë'ëni yëma'icua, ja'ancuabi yë'ë cocarebare ro achajën, ro yo'omajën ba'iyë. Ro yë'ë se'gabi ba cocarebare ro'tama'iñë. Yë'ë Taita yë'ë cuencueni raosi'quëbi yë'ëni ro'ta güeseguëna, ba cocarebare mësacuani quëani achoyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yë'ëbi mësacua naconi yuta ba'iguë, yua ja'an cocare mësacuani yihuoguë quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Riusu Espírituca yua mësacuana ti'anni, si'aye mësacuani ye'yoni masi güeseji. Yë'ëbi caguëna, Taita Riusubi baguë Espíritute mësacuana raoji. Raoguëna, Espíritubi yua mësacuani jo'caye beoye yihuoguë, te'e conguë ba'iji. Ba'iguë, yua yë'ë cocareba quëase'e si'ayete mësacuani ro'ta güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yureca, mësacuare jo'cani saiguë, mësacua recoñoa bojo huano güeseyë yë'ë. Yë'ë se'gabi ja'nca bojo güeseye poreyë. Ro bain se'gabi bojo güeseye porema'iñë. Ja'nca sëani, recoyo sa'ntiye beoye ba'ijë'ën. Recoyo huaji yëye beoye ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yua yë'ë coca ja'anrë quëase'ere achahuë mësacua: Yë'ëbi gare go'iyë. Go'ini, ja'nrëbi jë'te, mësacuani ëñaguë raija'guë'ë. Ja'nca quëaguëna, achahuë mësacua. Mësacuabi yë'ëni ai yëjën ba'itoca, mësacua yua yë'ë Taitana go'iyete achani, ai bojojën ba'ire'ahuë, yë'ë Taita yua yë'ë'ru quë'rë ta'yejeiye Ëjaguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yureca, yë'ë go'irën yuta ti'anma'iguëna, mësacuani quëahuë. Mësacuabi yë'ë coca quëase'ere ro'tani, yë'ëbi goquëna, yë'ëni si'a recoyo ro'tajën ba'ijë'ën caguë, ja'nca yure quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gu'a bain ëjaguë, zupai huati, ja'anguëbi raiguëna, yua rëño ñësebë se'ga mësacua naconi coca caguë ba'iyë yë'ë. Zupaibi yua yë'ëni ënseye porema'iguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yë'ë Taita guansese'e se'ga'ru güina'ru yo'oguë ba'iyë. Yë'ë Taitani ai yëguë ba'iguëna, si'a bainbi ëñani yë'ë Taita ai yëguë ba'iyete masija'bë caguë, baguë guansese'e'ru yo'oguë ba'iyë yë'ë. Yureca raijë'ën. Saiñu, cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Cani ja'nrëbi, ye'yo cocare yihuoguë quëabi: —Bisi ëye sahua, te'e ruiñe ba'i sahua'ru ba'iyë yë'ë. Ba'iguëna, yë'ë Taitabi, ëye zio ëjaguë'ru ba'iguë, yë'ëre conni cuiraguë ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yë'ë bain cuencuesi'cua yua ëye sahua cabëan'ru ba'iyë. Gue cabëbi ëyere quëinma'iguëna, yë'ë Taitabi ëñani, Gu'aji caguë, ba cabëte të'ntani senjoji. Gue cabëbi ëyere quëinguëna, yë'ë Taitabi ëñani, Quë'rë se'e quëinja'guë caguë, ba cabëte re'oye të'cani cuiraji. Zio ëjaguëbi baguë ëye sahuaña të'cani cuiraye'ru, yë'ë'ga yë'ë bainrebare conni cuiraguë, quë'rë re'oye yo'o yo'oye concuare bacuare re'huayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mësacuaca yua yë'ë cocareba quëani achose'ere ye'yeni, si'a recoñoa tënosi'cua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ja'nca sëani, yë'ëre zi'inni ba'ijën, yë'ë naconi recoyo te'e ba'ijë'ën. Yë'ë'ga mësacua naconi recoyo te'e ba'iyë. Ja'nca ba'ima'itoca, mësacuabi yë'ë Taita yëye'ru yo'oye gare porema'iñë. Ëye cabëbi ëye sahuate zi'inni ba'ima'itoca, ja'anse'ebi ëyere quëiñe porema'iji. Ja'nca quëiñe porema'iguëna, güina'ru mësacuabi yë'ëre zi'inni ba'ima'itoca, mësacua ja'ansi'cuabi yë'ë Taita yëye'ru yo'oye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Bisi ëye sahua ba'iye'ru ba'iyë yë'ë. Mësacua yua ëye cabëan'ru ba'iyë. Ëye cabëanbi ëye sahuate zi'iñe'ru güina'ru yë'ëre zi'injën, yë'ë naconi recoyo te'e ba'ijë'ën. Ja'nca ba'ijën, yë'ë'ga mësacua naconi recoyo te'e ba'iguëna, mësacuabi yë'ë Taita yëye'ru ai ba'iye yo'oye poreyë. Ai ba'iye ai ëye quëiñe'ru ba'iji mësacuare. ");
INSERT INTO snnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bainbi yë'ëna zi'inma'itoca, quëñoni senjoñe se'ga ba'iji bacuare. Ëye cabëan quëinma'iñe'ru ba'iyë. Ba cabëan yua gu'a cabëan sëani, zio ëjaguëbi tën'toni senjoji. Senjoni, ja'nrëbi cueneguëna, chiani toana senjoni ëoji. ");
INSERT INTO snnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ja'nca sëani, yë'ëna zi'inni ba'ijë'ën. Yë'ë naconi recoyo te'e ba'ijë'ën. Ja'nca ba'ijën, yë'ë cocareba quëani achose'ere ro'tani, recoñoa re'huani batoca, mësacua yëye'ru senni achajën ujajën ba'ijë'ën. Ja'nca ba'ijënna, mësacua señe si'aye mësacuare re'huacaise'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ja'nca ba'iguëna, mësacua yua ai ba'iye ëye quëiñe'ru Taita Riusu yo'ore yo'oreba yo'ojën ba'ijë'ën. Ja'nca ba'ijënna, si'acuabi Taita Riusu ta'yejeiye ba'iyete ëñani masiye poreyë. Ja'nca ëñajën, Cristoni te'e ruiñe conjën ba'iyë, mësacuare cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yë'ë Taita yua yë'ëni ai yëguë ba'iye'ru, güina'ru mësacuani ai yëguë ba'iyë yë'ë. Yëguë ba'iguëna, yë'ë naconi recoyo te'e bojojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yë'ë'ga yë'ë Taita guanse cocare yo'oguë, baguë yëguë ba'iyete masiguë bojoguë ba'iyë. Güina'ru mësacuabi yë'ë guanse coca cani jo'case'ere yo'ojën ba'itoca, yë'ë yëguë ba'iyete masijën bojojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yë'ëbi bojo güeseguëna, mësacua yua ai ba'iye ai bojojën ba'ijë'ën caguë, ja'an cocare mësacuani ja'nca yihuoguë quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yë'ë guanse cocare cato, yua ñaca ba'iji: Mësacua yua sa'ñeña ai yëjën ba'ijë'ën. Yë'ëbi mësacuani yëse'e'ru güina'ru sa'ñeña ai yëjën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bainguëbi baguë gajecua ro'ire junni tontoca, bacuani ai ba'iye ai yëguë ba'iji. Quë'rë ta'yejeiye yëguë ba'iye beoji. ");
INSERT INTO snnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mësacua yua yë'ë guanse cocare te'e ruiñe yo'otoca, yë'ë gajecua'ë cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yë'ëre yo'o conjën ba'icua mësacuare se'e cama'iñë. Yo'o conguëbi baguë ëjaguë yo'o yo'oyete huesëji. Yë'ëca yë'ë Taita cocareba masi güesese'e si'aye mësacuani quëahuë. Ja'nca sëani, mësacua yë'ë gajecua'ë cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mësacua yua yë'ëna zi'inni ba'iye ro'tamaë'ë. Yë'ëbi mësacuani cu'ejani cuencueni, yë'ë bainrebare re'huani bahuë. Mësacua yua yë'ë re'o yo'ore te'e ruiñe yo'oreba yo'ojë'ën caguë, yua mësacuare cuencueni jo'cahuë. Ai ba'iye ëye quëiñe'ru mësacuabi yë'ë re'o yo'o yo'oreba yo'otoca, mësacuabi guajaye beoye yo'ojën ba'iyë. Ja'nca ba'ijën, yë'ëni si'a recoyo ro'tajën, mësacua yëyete yë'ë Taitani senjë'ën. Senjënna, si'aye mësacuana ënseye beoye insiji. ");
INSERT INTO snnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yë'ë coca guansese'e: mësacua yua sa'ñeña ai yëjën ba'ijë'ën, ja'anre ro'tani yo'ojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ro bainbi yua mësacuani je'o batoca, sa'ntiye beoye ba'ijë'ën. Yë'ëni ru'ru je'o base'ere ro'tajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mësacua yua ro bain jubë ba'icua ba'itoca, ro bainbi mësacuani ai yëjën ba'ire'ahuë. Ro bain jubë beocua, yë'ë bainreba cuencuesi'cua, ja'an ba'icuare sëani, ro bainbi mësacuani je'o bayë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yë'ë coca quëase'e: “Yo'o concuabi bacua ëjacua'ru quë'rë ta'yejeiye beoyë” ja'an cocare ro'tajë'ën. Ro bainbi yë'ëni ai gu'aye huaitoca, güina'ru mësacuare'ga ai gu'aye huaiyë. Yë'ë coca quëani achose'ere achani yo'otoca, güina'ru mësacua coca quëani achoyete achani yo'oyë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mësacua yua yë'ë bainrebare sëani, bacuabi yë'ë Taita yë'ëre cuencueni raosi'quëre ro huesëjën, mësacuani gu'aye yo'ojën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yë'ëbi bacuani coca quëani achoguë raima'itoca, bacua gu'a juchare huesëjën ba'ire'ahuë. Yua bacuani quëani achoguë raisi'quë sëani, bacua gu'a juchare masijën, yua sehuo cocare caye porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yë'ëni je'o bacuabi yë'ë Taitare'ga je'o bayë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yë'ëbi yua ta'yejeiye yo'o, yequëcua yo'oye porema'iñe yo'o, ja'anre yo'oni bacuani ëñoma'itoca, bacua gu'a juchare sehuoye senma'ire'ahuë yë'ë. Ja'an yo'ore ëñasi'cuata'an, bacuabi yua yë'ë, yë'ë Taita, yëquëna samucuani je'o bahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bacua ira coca toyani jo'case'e: “Ro ro'tajën, yë'ëni ro je'o bahuë” ja'an coca toyani jo'case'e'ru güinareba'ru yure yo'ohuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yureca, yë'ë Taitana go'iguë, baguë Espíritu, ba te'e ruiñe quëani masi güeseguë, ja'anguëte mësacuani yihuoguë conreba conguë, yë'ë ba'iyete te'e ruiñe quëani masi güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mësacua'ga yë'ë naconi si'arën ba'isi'cuabi yë'ë ba'iyete te'e ruiñe quëani achojën ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mësacuabi yë'ëre jo'cani senjoma'iñe caguë, ja'an cocare mësacuani yihuoguë quëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mësacua yua yë'ë bainreba sëani, yua bacua jubëanna ñë'cajënna, mësacuani saoni senjoñë. Yurera bacua gu'aye yo'ojairënbi ti'anji. Riusu yo'ore conjën ba'iñu cajën, mësacuani huani senjo ëaye yo'oyë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yë'ë, yë'ë Taita, yëquënani gare huesëcua sëani, ja'nca yo'oni jëhuajën ba'iyë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yureca, ja'nca mësacuani quëani achohuë yë'ë. Bacua gu'aye yo'ojairënbi ti'anguëna, bacua gu'aye yo'oyete ëñani, yë'ë güina'ru quëase'ere ro'tajë'ën. Yurera, ja'an cocare mësacuani quëahuë yë'ë. Mësacua yë'ë naconi ba'icuare sëani, ja'anrë mësacuani quëamaë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yurera, yë'ë raosi'quëna go'iguëbi ja'an cocare mësacuani quëahuë yë'ë. Go'iguëna, mësacuabi ¿Jarona saiguë'ne më'ë? yë'ëni senma'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ja'an cocare mësacuani quëaguëna, mësacua yua recoñoa ai sa'ntijën ai oiyë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Oicuareta'an, yë'ë yua mësacuani te'e ruiñe coca quëaguëbi gare saiguëna, ai re'oye ba'iji mësacuare. Saima'itoca, Riusu Espíritubi mësacuani yihuoguë conguë raima'iji. Saiguëca baguëte mësacuana raoyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Raoguëna, baguëbi rani si'a bain gu'a jucha, bacua re'oye yo'oye caraye, Riusu bënni senjoja'ñe, ja'anre bainni ëñoni masi güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yë'ëni recoyo ro'taye güecua sëani, bacua gu'a juchare ëñoni masi güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yë'ë yua se'e ëñoma'iguëbi yë'ë Taitana go'iguë sëani, re'oye ba'iyete bainni ëñoni masi güeseji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Zupai huati ro gu'a bain ëjaguë bënni senjosi'quë ba'ija'guë sëani, Riusu bënni senjoja'ñete bainni ëñoni masi güeseji Riusu Espíritu. ");
INSERT INTO snnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yuta mësacuani coca yihuoguë quëaye ai caraguëna, yë'ëbi mësacuani yure quëama'iñë, mësacua te'e ruiñe achajairën yuta ti'anma'iguë sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Riusu Espíritu rairën ti'anguëna, baguëbi yua Riusu te'e ruiñe ba'i cocare mësacuani caraye beoye ëñoni masi güeseji. ");
INSERT INTO snnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ja'nca quëani achoguë, yë'ë ta'yejeiye ba'iyete ai ba'iye ai ëñoji baguë. Bainbi yë'ëni gugurini rëanni bojoja'bë caguë ëñoji. Yë'ë te'e ruiñe ba'iyete mësacuani ëñoni masi güeseji baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yë'ë Taita ba'iye'ru güinareba'ru ba'iyë yë'ë'ga. Ja'nca sëani, Riusu Espíritubi yë'ë te'e ruiñe ba'iyete mësacuani ëñoni masi güeseye, ja'anre mësacuani quëahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yureca, rëño ñëserë ba'iguëna, mësacuabi yë'ëre ëñañe beoye ba'iyë. Ja'nca ba'ini, ja'nrëbi se'e rëño ñëserë ba'iguëna, yë'ëre se'e ëñañë, quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Quëaguëna, baguëre conjën ba'icua yequëcuabi sa'ñeña coca senni achahuë: —¿Baguë queaca ro'taguë, ja'an cocare quëaguë'ne? Rëño ñëserë ba'iguëna, yë'ëre ëñañe beoye ba'iyë. Ja'nrëbi se'e rëño ñëserë ba'iguëna, yë'ëre se'e ëñañë, caji baguë. Cani, Yë'ë Taitana go'iguë sëani, ja'an case'ere'ga quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Rëño ñëserë caguëna, maibi baguë cocare ro huesë ëaye achayë, sa'ñeña senni achahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Senni achajënna, Jesusbi bacua cocare masiguë, baguëni senni achaye yëyete masiguë baji'i. Ja'nca sëani, Jesusbi bacuani coca senni achabi: —Yë'ëbi coca caguë: Rëño ñëserë ba'iguëna, yë'ëre ëñañe beoye ba'iyë. Ja'nrëbi, se'e rëño ñëserë ba'iguëna yë'ëre se'e ëñañe, ja'an cocare caguëna, mësacuabi ro huesë ëaye achajën, ¿ja'anre sa'ñeña senni achaye mësacua? ");
INSERT INTO snnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yureca, mësacuani ganreba yihuoguë quëayë yë'ë: Mësacuabi ai oijën ai sa'ntireba sa'ntijënna, gu'a bain si'acuabi bojora bojojën ba'ija'cua'ë. Ja'nca ba'iyeta'an, mësacua yua sa'nti hua'na ba'icuabi yuara ai bojoreba bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Romigobi zinre të'ya rai bi'ragona, ai ba'iye ai ja'sina ju'ingobi sa'nti hua'go se'ga ba'igo, bago të'ya rairën ti'anse'e sëani. Ja'nrëbi të'ya rani tëjini, bago zinni ëñani ai bojoreba bojogo. Bago sa'ntise'ere ro'tama'igo bojogo. ");
INSERT INTO snnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Güina'ru, mësacuabi yureña ai sa'nti hua'na ba'iyë. Ja'nca ba'icuata'an, yë'ëbi se'e mësacuani ëñaguë raiguëna, mësacuabi recoñoa ai bojoreba bojoja'cua'ë. Ja'nca bojojënna, yequëcuabi mësacuani se'e sa'nti güeseye gare porema'iñë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja'anrën ti'anguëna, mësacua si'aye te'e ruiñe masijën, yua yë'ëni coca senni achaye beoye ba'ija'cua'ë. Ganreba mësacuani yihuoguë quëayë yë'ë. Mësacuabi yë'ëni si'a recoyo ro'tajën, Taita Riusuni baguë bayete sentoca, mësacuani caraye beoye insireba insise'e ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yure tëca mësacuabi yë'ëni si'a recoyo ro'tajën, yë'ë bayete gare señe beoye ba'icua'ë. Yureca, yë'ë bayete Taita Riusuni senjë'ën. Ja'nca sentoca, mësacuabi ai ta'yejeiye coreba cojën, ai recoyo bojojën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yureca, mësacuani coca yihuoguë, ye'yo coca se'gabi quëahuë yë'ë. Ja'nca quëaguë, mësacuani Taita Riusu ba'iyete ai ruiñe quëajairën ti'anji. Mësacuani ye'yo cocabi se'e quëaye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ja'anrën ti'anguëna, mësacua yëye'ru senni achaguëna, yë'ëbi Taita Riusuni mësacuare sencaiye beoye ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taita Riusubi mësacuani, yë'ëni ai yëjën ba'icua sëani, mësacuani ai yëguë ba'iji. Mësacuabi yua yë'ë Taita raosi'quë ba'iyete si'a recoyo ro'tajën, yë'ëni ai yëjën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yë'ë Taitabi yë'ëre raoguëna, bainna ëñaguë raisi'quë'ë yë'ë. Ja'nca raisi'quëbi yuara bainre jo'cani, yë'ë Taitana go'iyë, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Quëaguëna, baguëre concuabi cahuë: —Yurera më'ëbi yëquënani ro ye'yo cocabi quëama'iñë. Te'e ruiñe ba'i cocabi quëaguëna, achayë yëquëna. ");
INSERT INTO snnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Më'ëbi yua si'aye te'e ruiñe masiguëna, yëquënabi ro huesë ëaye beoye achayë. Ja'nca masiguëna, yëquënabi më'ëre, Riusu Raosi'quë ba'iyete si'a recoyo ro'tayë, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Cajënna, Jesusbi sehuobi: —¿Mësacuabi yë'ë ba'iyete si'a recoyo ro'taye caye? ");
INSERT INTO snnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yurera ba'iguëna, yequëcuabi saoni senjojënna, mësacua si'a jubëbi yë'ëre jo'cani senjoni, mësacua huë'eñana gare go'iyë. Ja'nca go'ijën, yë'ëre te'e hua'guëre jo'cani senjoñë mësacua. Ja'nca jo'cani senjocuata'an, yë'ë yua te'e hua'guë beoyë, yë'ë Taitabi coñe sëani. ");
INSERT INTO snnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yureca, mësacuabi yë'ëni si'a recoyo ro'tajën, recoyo bojo huanoñe ba'ijë'ën caguë, ja'an cocare mësacuani quëahuë yë'ë. Mësacuabi ën yijare ba'ijënna, zupaire concuabi mësacuani ai je'o baja'cua'ë. Ja'nca bacuata'an, mësacua yua recoñoa bojoye se'gare re'huani ba'ijë'ën. Yë'ëbi zupaire concuare ënseye poreguë sëani, recoyo bojoye se'ga ba'ijë'ën, yihuoguë quëabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ja'nca yihuoguë quëani tëjini, Jesusbi mëiñe ëñani, Riusuni ujaguë ca bi'rabi: —Taita, yureca më'ë casirën ti'anbi. Ja'nca ti'anguëna, yë'ë ta'yejeiye ba'iyete bainni ëñojë'ën. Ëñoguëna, yë'ë'ga më'ë ta'yejeiye ba'iyete bainni ëñoñë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Më'ëbi yë'ëre si'a bain Ëjaguëre re'huaguëna, yë'ëbi më'ë cuencueni raosi'cuare bani, bacuare si'arën huajëreba huajëcuare re'huayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Më'ëbi te'e ruiñereba ba'iguë'ë. Yequë riusu beoji. Yë'ë'ga Jesucristo hue'eguëbi më'ë raosi'quëreba ba'iguë'ë. Ja'nca ba'iyë mai. Ja'nca ba'ijënna, maini si'a recoyo ro'tacuani si'arën huajëreba huajëcua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yë'ëbi ën yijana rani, më'ë yo'o case'ere yo'oni tëjihuë. Ja'nca yo'oguë, më'ë ta'yejeiye ba'iyete bainni ëñohuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja'nca ëñosi'quëbi më'ëna go'iyë yë'ë. Go'iguëna, yë'ëre më'ë naconi ta'yejeiye Ëjaguëre se'e re'huani, yë'ëre bajë'ën. Ën yija re'huani jo'casirën, quë'rë ja'anrë ëjaguë ba'ise'e'ru se'e yë'ëre re'huani bajë'ën, Taita. ");
INSERT INTO snnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yua më'ë ta'yejeiye ba'iyete më'ë bainreba cuencueni raosi'cuani ëñohuë yë'ë. Më'ëbi si'a bainre ëñani, më'ë bainreba se'gani tëani bani, yë'ëna raoni jo'caguëna, më'ë bainreba sëani, yë'ëbi bacuani bani, më'ë cocarebare bacuani te'e ruiñe quëani achohuë yë'ë. Quëani achoguëna, bacuabi achani si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ja'nca recoyo ro'tajën, yë'ë cocarebare achajën, si'aye më'ë cocareba ba'iye masijën, Te'e ruiñe caji Riusu cajën ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yë'ëbi më'ë coca quëani achose'ere bacuani te'e ruiñe cani achoguëna, bacuabi te'e ruiñe achani, yë'ë yua më'ë raosi'quë ba'iyete te'e ruiñe masini, ja'anre te'e ruiñe recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ja'nca sëani, bacua ba'iyete ro'taguë, më'ëni ujaguë ba'iyë yë'ë. Si'a bainre ro'tama'iñë yë'ë. Bacua se'gare më'ë bainreba ba'ijënna, yë'ëna raosi'cuare sëani, bacuare ro'taguë, më'ëni ujayë, Taita. ");
INSERT INTO snnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Më'ë bainrebare yë'ëna raoguëna, yë'ëbi bacuani bani bojoguëna, yë'ëni si'a recoyo ro'tahuë. Ja'nca ro'tajënna, bainbi bacua ba'iyete ëñani, yë'ë ta'yejeiye ba'iyete re'oye cajën ba'ija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yureca, yë'ëbi ën yijana se'e bëama'iñë. Bacua se'ga bëayë. Bëajënna, yë'ëbi më'ëna go'iyë. Go'iguëna, më'ë yua jucha beoguë, më'ë ta'yejeiye yo'oni ëñoguë, bacuani conguë ba'ijë'ën, Taita. Bacuare yë'ëna raoni jo'caguë, yua mai recoyo te'e zi'inni ba'iye'ru bacua, bacuare'ga recoyo te'e zi'inni ba'icuare re'huajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yë'ëbi bacua naconi ba'iguë, më'ë raosi'cuare sëani, më'ëbi ta'yejeiye yo'oni conguëna, bacuare conni re'huani bahuë yë'ë. Ja'nca conni baguëna, gu'a juchana bonëñe beoye baë'ë. Te'eguë se'ga, gu'a juchana bonëni huesëja'guë, ja'anguë se'gabi gu'a juchana tonni huesëjaji'i. Më'ë cocareba toyani jo'case'e'ru güina'ru ba'ija'ye caguë, më'ë cuencueni jo'case'e'ru güina'ru baji'i baguëre. ");
INSERT INTO snnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yureca, më'ëna go'iyë yë'ë. Ja'nca go'iye ro'taguë, bacua yua yë'ë recoyo bojoye'ru güina'ru caraye beoye bojoreba bojoja'bë caguë, yë'ë coca yure ujaguë cayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yua më'ë cocarebare bacuani quëani achoni jo'cahuë yë'ë. Ro bain ba'iye'ru tin ba'icua sëani, ro bain ba'icuabi bacuani je'o bayë. Yë'ë yua ro bain ba'iye'ru tin ba'iguëna, bacua'ga güina'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bacua ba'iyete ro'taguë, më'ëni ujayë yë'ë. Ro bain ba'irubi quëñoni bajë'ën senma'iñë yë'ë. Zupai huatibi bacuani coquema'ija'guë caguë, bacuani ëñaguë conguë ba'ijë'ën. Ja'anre ujaguë señë yë'ë, Taita. ");
INSERT INTO snnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bacuabi yua ro bain ba'iye'ru tin ba'iyë. Yë'ë yua ro bain ba'iye'ru tin ba'iguëna, bacua'ga güina'ru ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Te'e ruiñe ba'i recoñoa bacuare re'huani bajë'ën. Më'ë cocareba yua te'e ruiñe ba'i coca sëani, ja'anbi bacuare te'e ruiñe ba'i recoñoa bacuare re'huani bajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Më'ë yua yë'ëre bainna raoguëna, yë'ëbi güina'ru bacuare bainna saohuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bacua yua më'ë cuencueni ëñose'e'ru më'ë yo'ore sani te'e ruiñe yo'ojën ba'ija'bë caguë, yë'ë'ga më'ë cuencuese'e'ru junni tonguë saiyë, Taita. ");
INSERT INTO snnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yureca, bacuare ujaguëna, yequëcuabi bacua cocare achani yë'ëni si'a recoyo ro'tajënna, ja'ancuare'ga ujaguë ba'iyë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Si'a jubëbi recoyo te'e ro'tajën ba'ija'bë caguë ujayë yë'ë. Më'ë yua yë'ë naconi te'e recoyo ba'iguëna, yë'ë'ga më'ë naconi te'e recoyo ba'iyë. Bacua'ga güina'ru mai naconi te'e recoyo ba'ija'bë caguë ujayë, Taita. Ja'nca te'e recoyo ba'ijënna, si'a bainbi ëñani, yë'ë yua më'ë raosi'quë ba'iyete si'a recoyo ro'taja'bë caguë ujayë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Më'ëbi yua më'ë ta'yejeiye ba'iyete yë'ëna jo'caguëna, yë'ë'ga më'ë ta'yejeiye ba'iyete bacuana jo'cahuë. Mai ba'iye'ru recoyo te'e ba'ija'bë caguë, ja'nca jo'cahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yë'ë yua bacua naconi recoyo te'e ba'iguëna, më'ëbi yë'ë naconi recoyo te'e ba'iyë. Ja'nca ba'ijënna, bacua yua mai te'e ruiñe ba'iye'ru recoyo te'e ba'ija'bë cayë. Ja'nca ba'ijënna, si'a bainbi bacua ba'iyete ëñani, yë'ë yua më'ë raosi'quë ba'iye, ja'anre masija'bë cayë. Më'ë yua yë'ëni ai yëguë, bacuare'ga güina'ru ai yëguë ba'iyë më'ë. Si'a bainbi bacua ba'iyete ëñani, ja'anre masija'bë cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taita, ru'rureba ba'isirën, ën yijare yuta re'huama'irën, më'ë ta'yejeiye ba'iyete yë'ëna jo'cahuë më'ë. Ja'nca jo'caguëna, yë'ëbi më'ëni ëñere señë: Bacua'ga yë'ë go'ija'runa saiye señë. Sani, yë'ë ta'yejeiye ba'iye, më'ë jo'case'ere ëñani masija'bë cayë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yë'ë Taita, më'ë se'gabi recoyo re'oye ro'tani conguëna, më'ë ba'iyete masini bojoyë yë'ë. Bacua'ga yë'ë ba'iye, më'ë raosi'quë ba'iye, ja'anre masini bojoyë. Ro ba'icuaca më'ë ba'iyete huesëcua'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Më'ëbi yë'ëni ai yëguëna, më'ë bain cuencuesi'cuabi güina'ru yequëcuani ai yëjën ba'ija'bë caguë, më'ë ta'yejeiye ba'iyete bacuani ëñohuë yë'ë. Ja'nca ëñoguë, bacuani quë'rë se'e eñoguë ba'ija'guë'ë yë'ë, ujaguë cani tonbi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ja'nca ujani tonni, baguëre conjën ba'icua naconi huëni, Cedrón casi yorobëte je'enni, jo'ya re'ohuëna ti'anni, baguëre concua naconi bëahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ja'an bëani ba'irute masibi Judas, Jesusre insini senjosi'quë hue'eguë. Jesús yua baguëre concua naconi bëani coca caguë ba'isiru sëani, ");
INSERT INTO snnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judasbi masini, pairi ëjacua, fariseo bain, ja'ancuana sani, soldado jubë, bacua coñete senji'i. Senguëna, baguëni coñe saohuë. Saojënna, majahuëan, sunqui cabëan toa zëinse'e, guerra hua cabëan, ja'anre inni, Judas naconi sani, Jesús ba'iruna ti'anhuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ti'anjënna, Jesusbi bacua preso zeanja'ñete masiguë, bacuana tëhuoni senni achabi: —¿Mësacua gueguëni cu'ejën rate'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Senni achaguëna, bacuabi sehuohuë: —Jesús Nazarenoni cu'ejën raë'ë, sehuohuë. Senhuojënna: —Yë'ë'ë, quëabi. Quëaguëna, Judas hue'eguë, Jesusre insini senjoguëbi bacua naconi tinja nëcaguë ëñabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nëcaguë ëñaguëna, Jesusbi, “Yë'ë'ë” caguëna, bacuabi yo'jena go'iye taën'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tantena, Jesús yua bacuani se'e senni achabi: —¿Mësacua gueguëni cu'ejën rate'ne? senni achabi. Senni achaguëna, —Jesús Nazarenoni cu'ejën raë'ë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sehuojënna, Jesusbi cabi: —Yë'ë'ë. Mësacua cu'eguë'ë, cahuë yë'ë. Yë'ëni cu'ejën raitoca, yë'ë bain concuare zeanma'ijë'ën. Bacuabi quëñëja'bë cayë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesús coca ja'anrë case'e: “Më'ë bain yë'ëna raosi'cua, bacua gare huesoye beoye re'huani bahuë” ja'an coca case'e'ru güina'ru ba'ija'guë caguë, Bacuabi quëñëja'bë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Caguëna, ja'nrëbi, Simón Pedro yua guerra hua hua'tire baguëbi yua ja'an hua'tibi rutani, pairi ta'yejeiye ëjaguëre yo'o conguëni huani, baguë jëja ganjorote cue'reni tonbi. Malco hue'ebi ba yo'o conguë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Cue'reni tonguëna, Jesusbi Pedroni cabi: —Yo'oma'ijë'ën. Më'ë hua'tire hua'ti aya corohuëna jëojë'ën. Yë'ë Taitabi cuencueni guanseguëna, baguë yo'ore ai yo'oguë saiye bayë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ja'nrëbi, soldado jubë, bacua ëjaguë, judío ëja bain naconi, bacuabi Jesusre preso zeanni, guënameanbi huenhuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Huenni, ru'ru baguëte Anás hue'eguëna sani ëñohuë. Anás yua Caifás huaguë ba'iguëna, Caifás yua ja'an tëcahuë pairi quë'rë ta'yejeiye ëjaguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás yua judío ëjacuani yihuoguë: “Te'eguë se'gabi bain ro'ire junni huesëtoca, quë'rë re'oye ba'iye ba'iji” ja'anre ja'anrë yihuosi'quë baji'i baguë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ja'nrëbi, Simón Pedrobi, yua yequë Jesusre conguë naconi, Jesusre be'tebi. Be'teguëna, ba yequë conguë yua pairi quë'rë ta'yejeiye ëjaguë Caifasre masiguëbi, Caifás huë'ena cacabi. Jesusre be'teguë cacaguë, ");
INSERT INTO snnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrote, hue'se ca'nco nëcaguëna, jo'cabi. Ja'nca jo'cani, Caifasbi ba yequë conguëte masiguë sëani, ba yequë conguëbi anto sa'ro cuirago naconi coca cani, anto sa'rore anconi, Pedroni caca güesebi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Caca güeseguëna, anto sa'ro cuirago, ba huë'e yo'o congobi Pedroni cago: —¿Më'ë yua ba bainguë Jesús, baguëte consi'quëma'iguë? senni achago. Senni achagona, Pedrobi: —Bañë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yureca, ai sësëguëna, ba huë'e yo'o concua, soldado ëjacua naconi, bacuabi neo tëcabi toare zëonni, të'ijeiye nëcajën cuin'ë. Pedro'ga bacua naconi te'e toa cunji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ja'nrëbi, Jesusre pairi quë'rë ta'yejeiye ëjaguë ba'iruna nëcojënna, pairi quë'rë ta'yejeiye ëjaguëbi baguëni coca senni achabi. Baguëre concua ba'iye, baguë coca ye'yoye, ja'anre senni achaguëna, ");
INSERT INTO snnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús sehuobi: —Si'a bainbi yë'ë coca ye'yoyete achani masija'bë caguë, bain ñë'ca huë'eña, Riusu huë'e judío bain ñë'cani ye'yo coca achajën ba'iruan, ja'anruanna sani, yë'ë cocare ye'yoguë baë'ë yë'ë. Gare yahueye beoye te'e ruiñe ye'yoguë baë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ja'nca sëani, ¿mësacua queaca ro'tajën, yë'ëni ja'an coca senni achaye'ne? Yë'ë achasi'cuana sani, bacuani senni achajë'ën. Bacuabi yë'ë coca ye'yose'ere masiyë, sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ja'nca caguëna, soldado ëjaguë Jesús ca'ncore nëcaguëbi yua baguë ëntë abëbi Jesús ziana cueni, baguëni bëinguë cabi: —¿Më'ë queaca ro'taguë, pairi quë'rë ta'yejeiye ëjaguëni ja'an cocabi sehuoguë'ne? cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Caguëna, Jesús sehuobi: —Yë'ë yua gu'a cocabi sehuotoca, ¿gue gu'a cocare caye'ne yë'ë? Re'o cocabi sehuotoca, ¿më'ë queaca ro'taguë, yë'ëni cueguë'ne? sehuoguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Caguëna, Anasbi Jesusre preso huensi'quëre ta'yejeiye ëjaguë Caifasna saobi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ja'ansirënbi, Pedro yua hue'se ca'ncore cuinguë nëcaguëna, yequëcuabi baguëni senni achahuë: —¿Më'ë yua ba bainguë consi'quëma'iguë? senni achahuë. Senni achajënna, Pedrobi ëñama'iñe caguë: —Bañë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sehuoguëna, yequë pairi ta'yejeiye ëjaguëre yo'o conguëbi coca cabi. Pedro yua yequë bainguë ganjoro cue'reni tonsi'quë, ja'anguë yua ënquë te'e ba'isi'quë baji'i. Ja'nca ba'iguëbi Pedroni coca cabi: —Më'ë yua Jesús naconi jo'ya re'ohuëte baë'ë. Ja'nca ba'iguëna, më'ëni ëñahuë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Caguëna, Pedrobi se'e Bañë sehuobi. Ja'nca sehuoguëna, ja'ansirën curabi yuji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ja'nrëbi, Jesusre zeanni, zijeirën ba'iguëna, Caifás huë'ebi bain ta'yejeiye ëjaguë huë'ena sahuë. Bacua yua judío bain sëani, Gu'ana pa'roma'iñu cajën, bain ta'yejeiye ëjaguëna cacamaë'ë. Bacua pascua aonre aiñe yëcuabi gu'ana pa'roye poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ja'nca sëani, bain ta'yejeiye ëjaguë, Pilato hue'eguëbi bacuana etani, coca senni achabi: —¿Ënquë gue juchare yo'oguëna, mësacua caye'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Senni achaguëna, sehuohuë: —Gu'aye yo'osi'quë ba'ima'itoca, baguëte më'ëna insima'ire'ahuë yëquëna, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sehuojënna, Pilato cabi: —Mësacua se'gabi baguëte sani, mësacua ira bain coca toyani jo'case'e caye'ru, baguëni si'nsejë'ën, cabi. Caguëna, judío bainbi cahuë: —Yëquëna ira bain coca toyani jo'case'ere ëñato, yua Bainni huani senjoma'ijë'ën caguëna, baguëni te'e ruiñe si'nseñe porema'iñë yëquëna, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ja'nca cahuë. Jesús coca ja'anrë caguë ba'ise'e, baguë crusu sa'cahuëna junni huesëja'ye, ja'an coca case'e'ru güina'ru ba'ija'guë caguëna, ja'nca cahuë bacua. ");
INSERT INTO snnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Cajënna, Pilatobi baguë huë'ena go'iye cacani, Jesusre choni, baguëni coca senni achabi: —¿Më'ë yua judío bain ta'yejeiye ëjaguë'guë? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Senni achaguëna, Jesusbi sehuobi: —¿Më'ë se'gabi ja'anre ro'tani yë'ëni senni achaguë? ¿yequëcuabi ja'anre më'ëni quëare? sehuoguë senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Senni achaguëna, Pilatobi sehuobi: —¿Më'ë queaca ro'taguë, ja'an senni achaguë'ne? Yë'ë yua judío bainguë ba'ima'iñë. Më'ë bain, judío bain pairi ëjacuabi më'ëre preso zeanni, yë'ëna rani nëcohuë. ¿Më'ë gue gu'aye yo'osi'quëguë'ne? senni achabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Senni achaguëna, Jesús sehuobi: —Yë'ë yua ta'yejeiye ëjaguëta'an, ën yija bainre guansema'iñë yë'ë. Ja'nca guanseguë ba'itoca, yë'ëre concuabi yure guerra huajën, judío bain yë'ëre preso zeañe ënsejën ba'ire'ahuë. Yequë jobo Ëjaguë sëani, yë'ëre concuabi guerra huama'iñë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Quëaguëna, Pilatobi senni achabi: —Ja'nca ba'itoca, ¿më'ë yua bain ta'yejeiye ëjaguë'guë? senni achabi. Senni achaguëna, Jesús sehuobi: —Ja'nca ba'iyë yë'ë. Ja'anna të'ya raisi'quë baë'ë yë'ë. Te'e ruiñe ba'i cocare quëani achoguë raisi'quë'ë ën yijana. Te'e ruiñe ba'iye ye'yeye yëcua, si'acuabi yë'ë cocare achayë, sehuoguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Quëaguëna, Pilatobi: —¿Te'e ruiñe ba'iyete queaca masiye'ne? senni achabi. Ja'nca senni achani ja'nrëbi, se'e judío bainna etani, bacuani cabi: —Baguë yua gu'aye yo'osi'quë ba'iye huanoma'iji yë'ëre. ");
INSERT INTO snnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ja'nca ba'iguëna, mësacua ira bain senni achajën ba'ise'e'ru yure tëcahuë'ga güina'ru yo'oye ro'tayë yë'ë. Mësacua pascua umuguseña sëani, ¿mësacua jaro bainguë preso zeansi'quëre etoye señe'ne? ¿Ënquë, mësacua ta'yejeiye ëjaguëte etoye yëye? senni achaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Caguëna, bacuabi yua si'a jëja cani achojën baë'ë: —¡Bañë! ¡Yequë, Barrabás hue'eguë, ja'anguëni etojë'ën! güijën cahuë. Ja'an Barrabás hue'eguë yua bainre huani jian huati baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ja'nca cajënna, Pilatobi Jesusre sani, baguëte ga'ni za'zabobi si'nseye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ja'nrëbi, soldado hua'nabi miu ma ga'huare baguëte tëonni, baguë sinjobëna tëohuë. Ja'nrëbi, bajacu can ëjaguë canre inni, baguëna sayani, ");
INSERT INTO snnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ja'nrëbi, baguëna ñë'ca rani jayajën cahuë: —¡Ai zoe ba'irën huajëni ba'ijë'ën, judío bain ta'yejeiye ëjaguë! cahuë. Ja'nca cajën, bacua ëntë abëanbi baguëna cuehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ja'nrëbi, Pilato yua se'e etani, judío bainni cabi: —Ëñajë'ën. Baguëte mësacuani ëñoguë rahuë. Gu'aye yo'osi'quë ba'iye huanoma'iji yë'ëre. Ja'anre achani masijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Caguëna, Jesús yua miu ma ga'hua, bajacu can, ja'anre sayasi'quëbi etani nëcabi. Etani nëcaguëna, Pilatobi bacuani quëabi: —Yureca ëñajë'ën. Bainguëbi nëcaji, quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quëaguëna, pairi ëjacua, soldado ëjacua, bacuabi ëñani, si'a jëja achoye cahuë: —¡Crusu sa'cahuëna quenni reojë'ën! ¡Crusu sa'cahuëna quenni reojë'ën! güijën cahuë. Cajënna, Pilatobi cabi: —Mësacua se'gabi baguëte crusu sa'cahuëna quenni reojë'ën. Gu'aye yo'osi'quë ba'iye gare huanoma'iji yë'ëre, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Caguëna, judío bainbi sehuohuë: —Riusu guanseni jo'case'ere ëñato, Riusuni jayajën cacuare huani senjojë'ën guanseni jo'cabi Riusu. Ja'nca sëani, baguë yua Riusu Zin ba'iye caguëna, baguëni huani senjoñe bayë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja'nca sehuojënna, Pilatobi achani, quë'rë ai huaji yëguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ja'nrëbi, baguë huë'ena go'iye cacani, Jesusni se'e senni achabi: —¿Më'ë jarobi raquë'ne? senni achabi. Senni achaguëna, Jesusbi ro caye beoye nëcabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nëcaguëna, Pilato cabi: —¿Më'ë guere yo'oguë sehuoma'iguë'ne? Yë'ë yua bain ëjaguë sëani, më'ëni etoye poreyë yë'ë. Më'ëni crusu sa'cahuëna quenni reoye'ga poreyë yë'ë. ¿Ja'anre masima'iguë më'ë? cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Caguëna, Jesús sehuobi: —Taita Riusu, guënamë re'oto ba'iguëbi më'ëre bain ëjaguëre re'huama'itoca, yë'ëre guanseye gare porema'ire'ahuë më'ë. Ja'nca sëani, yë'ëre preso zeanni më'ëna insisi'quë, ja'anguëbi quë'rë ai ba'iye jucha baji, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja'nca sehuoguëna, Pilatobi Jesusre etoye coca caguë baji'i. Ba'iguëna, judío bainbi si'a jëja güihuë: —¡Baguëte etotoca, më'ë ta'yejeiye ëjaguëbi bëinji! ¡Bain ta'yejeiye ëjaguë casi'quë sëani, romano bain ta'yejeiye ëjaguëni gu'aye casi'quë ba'iji! güijën cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ja'nca cajënna, Pilatobi achani, Jesusre huë'ebi etoni, bainni baguëte ëñobi. Ëñoni ja'nrëbi, baguë jëja ñu'i seihuë, gata pë'npësiru, hebreo cocabi Gabata casiru, ja'anruna bëani, Justicia yo'oza caguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ja'an umuguse yua judío bain pascua aon ain umuguse ja'anrë ba'i umuguse ba'iguëna, ja'an aonre re'huaye bahuë. Mëñera së'irën ba'iguëna, Pilatobi judío bainni cabi: —¡Yureca, mësacua ta'yejeiye ëjaguëte ëñajë'ën! cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Caguëna, bacuabi si'a jëja güihuë: —¡Baguëni huani senjojë'ën! ¡Baguëni huani senjojë'ën! ¡Baguëte crusu sa'cahuëna quenni reoni senjojë'ën! güijën cahuë. Cajënna, Pilatobi coca senni achabi: —Mësacua ta'yejeiye ëjaguëte sëani, ¿baguëni crusu sa'cahuëna reoye caye? senni achabi. Senni achaguëna, pairi ëjacuabi sehuohuë: —Yëquëna ta'yejeiye ëjaguë beoji baguë. Romano bain ta'yejeiye ëjaguë se'gabi yëquëna ëjaguëreba ba'iji, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ja'nca sehuojënna, Pilatobi baguëte crusu sa'cahuëna quenni reoye soldado hua'nana insibi. Insiguëna, Jesusre sahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ja'nca sajën, crusu sa'cahuëna reoru, sinjo gu'an casiru, hebreo cocabi Gólgota casiru, ja'anruna Jesusre sahuë. Baguë crusu sa'cahuëte baguëni cuan güesehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sani ti'anni, baguëte crusu sa'cahuëna reohuë. Yequëcuare'ga, samucuare baguë naconi te'e reohuë. Te'eguëte baguë jëja ca'ncona reohuë. Te'eguëte baguë ari ca'ncona reohuë. Baguëte yua bacua joborana reohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Reojënna, Pilatobi baguë gu'aye yo'ose'ere ro'tani, “Jesús Nazareno, judío bain ta'yejeiye ëjaguë'bi baji'i” ja'anre toyani, Jesús crusuna sëoye guansebi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sëoye guanseguëna, judío bain ai ba'i jubëbi ja'an coca toyani sëose'ere ëñahuë, huë'e jobo cueñe ba'iruna reosi'quëre sëani. Hebreo coca, latín coca, griego coca, ja'an cocabi toyani sëose'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ba'iguëna, ja'nrëbi, judío bain pairi ëjacuabi Pilatona sani, baguëni coca cahuë: —¿Më'ë queaca ro'taguë, “Judío bain ta'yejeiye ëjaguë'bi ba'iji” toyaguë'ne? Ja'anre tënoni, “Judío bain ta'yejeiye ëjaguëguëña” ja'anre toyani sëojë'ën, cahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Cajënna, Pilatobi sehuobi: —Bañë. Yë'ë coca toyani sëose'ere gare tënoñe beoye ba'iyë yë'ë, sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ja'nrëbi, soldado hua'nabi baguëte quenni reojën, baguë cañare inni bahuë. Gajese'gacua sëani, ga soldado hua'guëbi te'e canre babi. Jesús ju'i can se'gabi jëhuabi. Ta'nësiruan beoguë, ëmëje'en ca'ncobi yijacua ca'nco tëca, si'a can yua te'e jai can ganosi can baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ja'nca ba'iguëna, soldado hua'nabi sa'ñeña cahuë: —Ën canre ye'rema'iñu. Te'eguë se'gabi baja'guë cajën, Gata toyasira'carëanre senjoni ëñani, can coja'guëte masiñu, cahuë. Ja'nca yo'ojënna, Riusu coca toyani jo'case'e: “Yë'ë cañate sa'ñeña huo'huejën, gata toyasira'carëanre senjoni ëñajën cohuë” ja'an coca toyani jo'case'e'ru güina'ru baji'i. Ja'nca yo'ohuë ba soldado hua'na. ");
INSERT INTO snnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yureca, romi hua'nabi Jesús reosirute ëñajën nëcahuë. Jesús pë'cago, yeco bago yo'jego, yeco María'ga hue'ego Cleofas rënjo, yeco María Magdalena, ja'an hue'ecuabi ëñajën nëcahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ja'nca nëcajënna, Jesusbi baguë pë'cagoni ëñani, ja'nrëbi baguëre conguë ai yësi'quëre'ga ëñani, baguë yua baguë pë'cagoni cabi: —Mamá, yë'ë conguëte sani, më'ë zinrebare baguëte re'huani bajë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cani ja'nrëbi, baguëre conguëni cabi: —Yë'ë pë'cagote sani, më'ë pë'cagore bagote re'huani bajë'ën, cabi. Ja'nca caguëna, ja'nrëbi, ba conguëbi Jesús pë'cagote baguë huë'ena sani, baguë pë'cagore re'huani bani cuiraguë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja'nrëbi, Jesús yua baguë yo'o yo'oni tëjise'ere masiguë, Riusu coca toyani jo'case'e'ru güina'ru ba'ija'guë caguë, ñaca cani achobi: —Oco ëaji, cani achobi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Cani achoguëna, vino jo'cha sënje jo'cha ba'iguëna, baru ba'icuabi sayabëbi inni, tëcabëna jëoni, sënje jo'cha ro'rohuëna ayani, baguë yi'obona mëani rurahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Rurajënna, Jesusbi uncuni, ja'nrëbi ñaca cani achobi: —Yua yë'ë yo'o yo'oni tëjise'e ba'iji. Cani achoni, ja'nrëbi, baguë sinjobëte meñe reani junni tonbi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Junni tonguëna, judío bain yo'o yo'oma'i umuguse ja'anrë ba'i umuguse ba'iguëna, judío bainbi ju'insi'cua ga'nihuëanre crusu sa'cahuëanna jo'caye güehuë. Yo'o yo'oma'i umuguse yua ai ta'yejeiye ba'i umuguse sëani, ja'nca jo'caye güejën, Pilatona sani, ba reosi'cua guëoñare hua'huani, bacuare sani tañe sen'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ja'nca senni achajënna, soldado hua'nabi sani, Jesús naconi reosi'cua, bacua guëoñare ru'ru cueni jë'yehuë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cueni jë'yeni ja'nrëbi, Jesusre ëñani, yua ju'insi'quëre sëani, baguë guëoñare cueni jë'yemaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Cueni je'yema'ijënna, te'e soldado hua'guëbi Jesús coribana baguë cuain perebëbi totabi. Totaguëna, ja'ansirën zie, oco, ja'anbi etabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Etaguëna, yë'ë yua ën cocare toyaguëbi ja'anre ëñahuë. Ja'anre ëñasi'quëbi masini, yua te'e ruiñe quëaye se'ga ba'iyë. Mësacuabi achani, Jesusni si'a recoyo ro'tajë'ën caguë, ja'anre ëñani, te'e ruiñe toyani jo'cahuë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Riusu coca toyani jo'case'e: “Baguë gu'anre gare cueni jë'yeye beoye ba'ija'cua'ë” ja'an coca toyani jo'case'e'ru güina'ru ba'ija'guë caguë, ja'nca baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Riusu coca toyani jo'case'ere ëñato, yequë quë'ro'ga ñaca caji: “Bacua totasi'quëni ëñaja'cua'ë” toyani jo'case'e ba'iji. ");
INSERT INTO snnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ja'nrëbi, Jesusbi junni huesëguëna, yequë Jesusre conguë, José hue'eguë, Arimatea huë'e jobo bainguë, ja'anguë yua judío ëja bainni huaji yëguë, Jesusni yahue conguë se'ga baji'i. Ja'nca ba'iguëbi Pilatona sani, Jesús ga'nihuëte sani tañe senji'i. Senguëna, Pilatobi Jaë'ë cabi. Caguëna, Jesús ga'nihuëte inni sabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Saguëna, Nicodemo hue'eguë, ñamibi Jesusni ëñaguë saisi'quë, ja'anguëbi Joséni conbi. Ja'nca conguë, ma'ña, mirra, áloes, ja'an ma'ña ja'mese'e, treinta kilo ba'iyete inni rabi. ");
INSERT INTO snnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Raguëna, bacuabi Jesús ga'nihuëte ba ma'ña naconi yu'yujën, canbi ganoni tunahuë. Judío bainbi ja'nca bainre re'huani tañë. ");
INSERT INTO snnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ja'nrëbi, jo'ya re'ohuë yua baguë crusu reosiru cueñe baji'i. Ja'anruna ëñato, bain tan goje yurera gata të'ntëbana te'ntose'e baji'i. Yuta bain tanma'i goje baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ja'nca cueñe ba'iguëna, judío bain yo'o yo'oma'i umuguse yuara ti'añe sëani, ja'an gojena ayani ta'pini tanhuë. ");
INSERT INTO snnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ja'nrëbi, semana ja'anrë ba'i umuguse ti'anguëna, María Magdalenabi ñata ñamibi huëni, Jesús tansiruna saco'ë. Yuta zijei re'oto se'ga baji'i. Sani ëñato, yua gata ta'pisibë yua tansi gojebi otani saose'e baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ja'nca ba'iguëna, bagobi huë'huëni saco'ë. Simón Pedro, yequë Jesusre conguë ai yësi'quë, bacua ba'iruna huë'huëni quëajaco'ë: —Yequëcuabi mai Ëjaguë tansi gojere otani baguëte samate. Sarena, bacua sasirute huesëyë mai, quëago. ");
INSERT INTO snnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Quëagona, Pedro yua ba yequë conguë naconi, bacuabi ba tansi goje tëca ëñajën saë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jëja huë'huëjën saë'ë. Ja'nca saijënna, ba yequë conguëbi Pedro'ru quë'rë jëja huë'huëni, tan gojena ru'ru ti'anbi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ti'anni ja'nrëbi, rëanni, sa'nahuëna ëñato, Jesús can ganoni tunase'ebi unji'i. Ja'anre ëñaguë, sa'nahuëna cacamaji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ja'nrëbi, Simón Pedrobi baguë yo'jena ti'an rani, tansi gojena cacabi. Cacani ëñato, Jesús can ganoni tunase'ebi unji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Baguë sinjo ba'isi can'ga yequë can naconi baji'i. Ja'an can se'gabi re'oye re'huase'e ba'iguë, yua ca'ncorëte unji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ja'nca ba'iguëna, ba yequë conguë ru'ru ti'ansi'quëbi tan gojena cacani, ja'anre ëñani, Jesús go'ya raise'ere si'a recoyo ro'tabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Riusu coca toyani jo'case'e, Jesús go'ya raija'ye, ja'an cocare yuta huesëjën, yurera Jesús go'ya raise'ere si'a recoyo ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ja'nrëbi, ja'anre ëñani tëjini, bacua huë'ena goë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Go'ijënna, María Magdalenabi tansi goje hue'se ca'ncore nëcago oco'ë. Ja'nca oigobi rëanni, tansi goje sa'nahuëna ëñato, ");
INSERT INTO snnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","anje sanhuë samucua, pojei caña ju'icuabi yua Jesús ga'nihuë uinsirute ñuë'ë. Yequëbi guëoña ba'isirute ñuji'i. Yequëbi sinjobë ba'isirute ñuji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ja'nca ñu'icuabi Maríani: —¿Më'ë guere oigo'ne? senni achahuë. Senni achajënna, sehuogo: —Yequëcuabi yë'ë Ëjaguëte sarena, baguë sasirute huesëyë yë'ë, sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sehuoni, ja'nrëbi bonëni ëñato, Jesusbi nëcabi. Nëcaguëna, baguëte huesëgo. ");
INSERT INTO snnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Huesëgona, Jesús yua bagoni senni achabi: —¿Më'ë guere oigo'ne? ¿Neni cu'ego'ne? senni achabi. Senni achaguëna, bago yua jo'ya re'ohuë cuiraguë ba'iyete ro'tago, baguëni sehuogo: —Më'ëbi baguë ga'nihuëte yequëruna sani jo'catoca, baguë jo'casirute quëajë'ën. Baguëte injaza, cago sehuogo. ");
INSERT INTO snnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sehuogona, ja'nrëbi, Jesusbi: —¡María! cabi. Caguëna, bago yua bonëni, hebreo cocabi baguëni: —¡Rabuni! cago. Bain cocabi, Ye'yoguë, cago. ");
INSERT INTO snnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Cagona, Jesús cabi: —Yë'ëre su'ncama'ijë'ën. Yuta yë'ë Taitare mëni go'imaë'ë yë'ë. Yë'ë bainrebana sani, ñaca quëajë'ën: Yë'ë Taita Riusu yua mësacua Taita Riusu ba'iguëna, baguëna se'e go'iye bayë. Ja'anre bacuani quëajaijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Caguëna, María Magdalenabi Jesusre conjën ba'icuana sani, “Mai Ëjaguëni ëñahuë yë'ë” cago quëago. Baguë coca case'ere bacuani quëago. ");
INSERT INTO snnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ja'nrëbi, ja'an umuguse semana ja'anrë umugusebi na'iguëna, Jesusre concuabi, judío ëja bainni huaji yëcua sëani, bacua huë'ere ñë'cani, anto sa'roña ta'pini baë'ë. Ba'ijënna, Jesusbi bacua jobona joë ba'irubi eta rani nëcabi. Nëcani cabi: —Mësacua bojo recoyo huanoñe ba'ijë'ën, saludaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja'nca saludani ja'nrëbi, baguë ëntë saraña, baguë coriba, ja'anre bacuani ëñobi. Ëñoguëna, bacua Ëjaguë ba'iyete ëñani, ai bojohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bojojënna, Jesusbi se'e cabi: —Mësacua bojo recoyo huanoñe ba'ijë'ën. Yë'ë Taitabi yë'ëre cuencueni raoguëna, güina'ru mësacuare cuencueni, bainna saoyë yë'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja'nca cani ja'nrëbi, bacuani sëconi saoguë cabi: —Mësacua yua Riusu Espíritute coni bajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yequëcuabi bacua gu'a juchare jo'cani senjotoca, mësacua yua bacua juchare huanë yeye cajë'ën. Catoca, ja'ancuabi yua gu'a jucha beoyë. Yequëcuabi bacua gu'a juchare jo'cani senjoma'itoca, mësacuabi yua bacua juchare huanë yema'iñe cajë'ën. Catoca, ja'ancuabi yua gu'a jucha bayë, caguë quëani saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yureca, Jesusre conguë Tomás hue'eguë, yequë mami Te'e Jubë Hua'guë casi'quë baji'i, yequë naconi jubë të'ya raisi'quë sëani. Ja'anguëbi, Jesús eta raisirën, bacua naconi beobi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Beoguëna, Jesusre concuabi jë'te baguëni: —Mai Ëjaguëni yua ëñahuë yëquëna, quëahuë. Quëajënna, baguë sehuobi: —Baguë go'ya raise'ere ro'tama'iñë yë'ë. Ru'ru baguë ëntë saraña quensiruanre ëñaza. Baguë ëntë saraña quensiruan, baguë coriba totasiru, ja'anre pa'roye porenica, baguë go'ya raise'ere ro'tayë yë'ë. Pa'roye poremanica, ro'tama'iñë yë'ë, caguë sehuobi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ja'nrëbi, ocho umuguseña ba'iguëna, Jesusre concua yua Tomás naconi ba huë'ere ñë'casi'cua ba'ijënna, anto sa'roña yua ta'pise'e baji'i. Ja'nrëbi, Jesús yua bacua jobona eta rani nëcani: —Mësacua bojo recoyo huanoñe ba'ijë'ën, saludaguë cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Cani ja'nrëbi, Tomasni cabi: —Yë'ë ëntë sarañare ëñajë'ën. Më'ë ëntë sara mëoñoare mi'nani, më'ë mëoñobi yë'ë ëntë sarañare pa'rojë'ën. Ja'nrëbi, më'ë ëntë sara mëoñoare mi'nani, yë'ë coriba totasi gojena sa'nsuni ëñajë'ën. Se'e ro'tama'iñe beoye ba'ijë'ën. Yë'ëni si'a recoyo ro'tajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Caguëna, Tomasbi baguëni ëñani cabi: —Yë'ë Ëjaguë, yë'ë Riusureba ba'iyë më'ë, caguë quëabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Quëaguëna, Jesús cabi: —Më'ë yua yë'ëni ëñani, yë'ëni si'a recoyo ro'tahuë. Yequëcua yë'ëre ëñama'icuata'an, yë'ëni si'a recoyo ro'tajën, yua ai ta'yejeiye recoyo bojojën ba'ija'cua'ë, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yureca, Jesús yua baguëre concua naconi ba'iguë, ai ba'iye ai ta'yejeiye yo'oni ëñobi. Si'aye ën pëbëna toyani jo'caye carabi. ");
INSERT INTO snnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ën pëbë toyase'e se'gare mësacuana jo'cahuë yë'ë. Mësacua yua Jesús, ba Cristo ba'iye, Riusu Zin Raosi'quëreba ba'iye, ja'anre recoyo ro'tajë'ën caguë, ën pëbëte toyani jo'cahuë. Baguëbi conguëna, huajëreba huajëjën ba'ijën ba'ijë'ën cajën, Jesusni si'a recoyo ro'tajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ja'nrëbi jë'te, Jesusre concuabi Tiberio zitara yëruhuate ba'ijënna, Jesusbi bacuani ñaca'ru ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro, yequë Tomás, Te'e Ju Hua'guë casi'quë, yequë Nataniel, Caná huë'e jobo Galilea yija huë'e jobo bainguë, yequëcua Zebedeo mamacua, yequëcua samucua, ja'ancua yua ñë'cani baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ba'ijënna, Simón Pedrobi: —Hua'ire yojaza, cabi. Caguëna, ba yequëcuabi: —Yëquëna'ga më'ë naconi te'e saiyë, cahuë. Ja'nrëbi, yogubi cacani sani, hua'ire yojën ñatajaicuata'an, hua'i tinjama'icua baë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ja'nrëbi, ñata bi'raguëna, Jesusbi zitara yëruhuate nëcaguëna, baguëre concuabi baguëte huesëhuë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Huesëjënna, bacuani caguë senni achabi: —Mami sanhuë, ¿mësacua hua'i yore? senni achabi. Senni achaguëna: —Banhuë, sehuohuë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sehuojënna, bacuani cabi: —Mësacua huanterëte jëja ca'ncona senjojë'ën. Ja'nca senjotoca, hua'i yoyë, cabi. Caguëna, ja'nca senjohuë. Senjoni ja'nrëbi, ai ba'iye ai hua'i yojën, huanterë rëquëguëna mëañe poremaë'ë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ja'nrëbi, Jesusre conguë ai yësi'quëbi Pedroni: —Mai Ëjaguëbi querë ba'iji, cabi. Ja'nca caguëna, Simón Pedrobi achani, baguë caña yo'o yo'oguë rutase'ere besa sayani, zitarana chani, yëruhuana yi'huaguë saji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Saiguëna, ba yequë concuabi yogute ba'ijën, ba huanterë hua'i bu'isirëte rërëni sani je'ë. Zitara yëruhua yua so'o ba'imaji'i. Cien metro ba'iye cueñe'ru baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jeni, ja'nrëbi ëñato, toa yua neo tëca zëinse'e baji'i. Zëinse'e ba'iguëna, ziaya hua'i hua'guë te'eguë, aonbëan naconi, ja'anbi boguëna, ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ëñajënna, Jesús cabi: —Ba hua'i yose'e, samu hua'nare injaijë'ën. Boni aiñu, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Caguëna, Simón Pedrobi yoguna cacani, huanterëte zeanni, yëruhuana rërëni mëabi. Mëani, ai ba'iye ai ziaya hua'i, jaina ba'ijënna, huanterëte ai bu'iguëna, cuencueni ëñato, ciento cincuenta y tres baë'ë. Ai ba'iye ai ba'icuata'an, huanterëbi ye'remaji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ja'nrëbi, Jesusbi: —Raijë'ën. Desayunote aiñu, cabi. Caguëna, bacuabi yua baguë ba'iyete senni achaye huaji yëhuë. Mai Ëjaguë ba'iyete masihuë. ");
INSERT INTO snnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ja'nrëbi, Jesús yua ba aonbëan bose'ere inni, bacuana huo'hueni insibi. Ziaya hua'ire'ga güina'ru inni insibi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ja'nca bacuani ëñobi Jesús. Baguë go'ya raisirënbi bacuani ëñoguë, yureca baguë samute viaje eta rani ëñobi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ja'nrëbi, desayunote anni tëjihuë. Tëjini, Jesús yua Simón Pedroni senni achabi: —Simón, Juan mamaquë, më'ëbi ëñere ai yëguë, ¿yë'ëni quë'rë yëguë? senni achabi. Senni achaguëna, sehuobi: —Aito, Ëjaguë. Më'ëni ai yëguë ba'iyë yë'ë. Ja'anre masiyë më'ë, sehuobi. Sehuoguëna, Jesusbi baguëni cabi: —Ja'nca ba'itoca, oveja zin hua'nani aon cuiraye'ru, yë'ë bainni yë'ë cocarebare ye'yoguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Cani ja'nrëbi, baguëni samu ba'iye senni achabi: —Simón, Juan mamaquë, ¿yë'ëni ai yëguë më'ë? senni achabi. Senni achaguëna, sehuobi: —Aito, Ëjaguë, Më'ëni ai yëguë ba'iyë yë'ë. Ja'anre masiyë më'ë, sehuobi. Sehuoguëna, Jesusbi baguëni cabi: —Ja'nca ba'itoca, jo'ya baguëbi baguë oveja hua'nani cuiraye'ru, më'ë yua yë'ë bainre cuirani conguë ba'ijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Cani ja'nrëbi, baguëni samute ba'iye senni achabi: —Simón, Juan mamaquë, ¿yë'ëni ai yëguë më'ë? senni achabi. Ja'nca samute ba'iye senni achaguë, “¿yë'ëni ai yëguë më'ë?” senni achaguëna, Pedrobi sa'nti hua'guë runni, baguëni sehuobi: —Ëjaguë, më'ëbi si'aye masiguë sëani, yë'ë yëguë ba'iyete masiyë më'ë, sehuobi. Sehuoguëna, Jesusbi baguëni cabi: —Ja'nca ba'itoca, jo'ya baguëbi baguë oveja hua'nani cuiraye'ru, më'ë yua yë'ë bainre cuirani conguë ba'ijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Më'ëni ganreba yihuoguë quëayë yë'ë. Më'ë bonsëguë ba'isirënbi më'ëbi më'ë cañate sayani, më'ë yësiruanna saiguë ba'nhuë. Ja'nca ba'iguëta'an, më'ëbi ira hua'guë ruinguëna, yequëbi më'ë ëntë saraña mi'nañe guanseni, më'ë cañate më'ëna sayani, më'ë yëma'iruna më'ëre saja'guë'bi, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ja'nca caguë, Pedro junni huesëja'yete quëani achobi Cristo. Riusu ta'yejeiye ba'iyete bainni masi güeseguë, ja'nca junni huesëja'guë'bi. Ja'nrëbi jë'te, Jesusbi Pedroni: —Më'ë yua yë'ëni te'e conguë raijë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Caguëna, Pedrobi bonëni ëñato, ba conguë Jesús ai yësi'quëbi be'teguë raji'i. Ja'an raiguëbi yua pascua aon ainsirënbi Jesús ca'ncore te'e ñu'isi'quë baji'i. “Ëjaguë, ¿gueguëbi më'ëre insini senjoja'guë'ne?” ja'anre senni achasi'quë baji'i. ");
INSERT INTO snnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ja'an ba'iguëbi raiguëna, Pedrobi baguëte ëñani, Jesusni senni achabi: —Ëjaguë, ¿ja'anguë ba'iyete më'ë guere caguë'ne? senni achabi: ");
INSERT INTO snnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Senni achaguëna, Jesús sehuobi: —Yë'ë in rai umuguse tëca ba'ija'guë catoca, ja'anre ro'ta ëaye beoye ba'ijë'ën. Më'ë yua yë'ëni te'e conguë raiye ro'taguë yo'ojë'ën, cabi. ");
INSERT INTO snnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ja'nca caguëna, ja'nrëbi, Jesusre conjën ba'i jubëbi, Ja'an conguëbi junni huesëma'ija'guë'bi, sa'ñeña cani achohuë. Jesús yua baguë junni huesëma'ija'ñete camaji'i. “Yë'ë in rai umuguse tëca ba'ija'guë catoca, ja'anre ro'ta ëaye beoye ba'ijë'ën” ja'an se'gare cani jo'cabi Jesús. ");
INSERT INTO snnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ja'an conguë yua yë'ë'ë. Yë'ë yua ën pëbë toyase'ere ëñasi'quë sëani, mësacuani toyani jo'cahuë yë'ë. Te'e ruiñe ba'i coca se'gare toyani jo'cahuë yë'ë. Ja'anre masiyë mai. ");
INSERT INTO snnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusbi yeque yo'o ai ba'iye yo'oni ëñoguëna, ën pëbëna toyaye carabi. Si'ayete toyani jo'catoca, ja'an uti pëbëan toyani jo'case'e ai ba'iye sëani, ën yijana jo'caye ti'anma'iji, ro'tayë yë'ë.");
INSERT INTO snnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yë'ë bainguë Teófilo, yë'ë ja'anrë toyani saose'e, Jesucristo ën yija ba'iguë yo'ose'e beoru toyani jo'caguë, më'ëni quëahuë yë'ë. Baguë yo'oguë ba'ise'e, baguë coca ye'yoni jo'case'e, si'aye, ");
INSERT INTO snnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","baguë guënamë re'oto go'isirën tëca yo'oni jo'case'e më'ëre quëani jo'cahuë yë'ë, ëjaguë. Ja'nca yo'oni jo'casi'quëbi yuta go'ima'iguë, ru'ru baguëre ta'yejeiye yo'ore concuani cuencueni jo'caguëña. Cuencueni jo'caguë, Riusu Espíritubi masi güeseguëna, bacuani yihuo coca quëani jo'caguëña, bacua yo'ojën ba'ija'ye'te. ");
INSERT INTO snnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Quëani jo'cani, ja'nrëbi junni tonni, go'ya rani, bacuani se'e ëñoguëña. Ëñoni, cuarenta umuguseña bacua naconi te'e ba'iguë, baguë huajë rani ba'iyete bacuani te'e ruiñe masi güeseguë, Riusu ta'yejeiye ba'i jobore bacuani quëaguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja'nca ba'iguëbi baguëre ta'yejeiye yo'o concuani si'a jëja yihuoguë quëani jo'caguë baquëña: —Mësacua yua Jerusalén huë'e jobona bëani ba'ijë'ën. Yë'ë Taita Riusu cani jo'case'e'ru ba'ija'ye tëca ëjojën ba'ijë'ën. Yë'ë'ga mësacuani cani jo'cahuë. ");
INSERT INTO snnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juanbi bainre oco naconi bautizaguë ba'isi'quëta'an, Riusu mame bautizaja'yeta'an te'e jëana ba'ija'guë'bi mësacuare. Yureña ba'i umuguseñabi Riusu Espíritubi mësacuana gaje meni baja'guë'bi, quëani jo'caguëña Jesucristo. ");
INSERT INTO snnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cani jo'caguëna, ja'nrëbi ba hua'nabi baguë naconi te'e ba'ijën, baguëni senni achareña: —Ëjaguë, Israel bain ba'i yija tëani quëñose'e, ¿ja'an yijare bacuana go'ya güeseye ro'taguë më'ë, yureña? senni achareña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Senni achajënna, sehuoguëña baguë: —Mai Taita Riusu yo'oja'yete mësacuani gare masi güesema'iji. Baguë se'gabi baguë yo'oja'rënre masiji. ");
INSERT INTO snnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Baguë Espírituca mësacuana gaje meni baguëna, mësacuabi ai ta'yejeiyereba yo'oye poreja'cua'ë. Ja'nca porecuabi yë'ë ba'iyete si'a bainni te'e ruiñe quëani achoja'cua'ë. Ru'ru, Jerusalén bain, ja'nrëbi Judea yija bain, Samaria yija bain, ja'nrëbi si'a ën yija re'oto bain so'o ba'icuani yë'ë junni tonni go'ya raise'ere te'e ruiñe quëani achojën ba'ija'cua'ë mësacua, sehuoguëña Jesucristo. ");
INSERT INTO snnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sehuoni tëjini, bacuabi ëñajënna, guënamë re'otona huahua mëiguë, pico re'otona huesëguëna, ba hua'nabi gue ro'taye beoye ëñareña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ja'nca mëiñe ëñajën nëcajënna, yequëcua, samucua, pojei canre ju'icuabi bacuana ti'an rani, ");
INSERT INTO snnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bacuani senni achareña: —Mësacua Galilea yija bain, ¿guere ro'tajën guënamë re'otona ro mëiñe ëñajën nëcaye'ne? Ja'an mëni saisi'quë, Jesús hue'eguëbi baguë sani huesëse'e'ru güina'ru se'e gaje meni raija'guë'bi. Mësacua yure ëñase'e'ru baguëni se'e ëñaja'cua'ë, quëani, ja'nrëbi sateña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Satena, ja'nrëbi, Cristore concuabi yua Olivo casi cubëte ba'ijën, Jerusalén huë'e jobona te'e jëana goteña. Cueñe ba'iruna go'ijën, yo'o yo'oma'i umuguse ganiñe poreye'ru, te'e kilómetro ba'iye ganini ti'anreña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti'anni, bacua ba'i huë'ena cacani, ëmëje'en ba'i sonohuëna mëni bateña. Ja'nca ba'icuabi ñaca hue'ecua bateña: Pedro, Santiago, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo mamaquë Santiago, Simón hue'eguë cananista jubë ba'iguë, Santiago bainguë Judas hue'eguë, ja'an hue'ecua bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ja'ancua si'a jubëbi Riusuni ujañu cajën, Jesús yo'jecua, Jesús pë'cago María, yequëcua romi hua'na, bacua naconi ñë'cani, si'a umuguseña Riusuni ujajën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja'nca ujajën ñë'cajën, ja'an umuguseñabi Pedrobi baguë bainre coca cani achoza caguë, ja'an jubë ciento veinte ba'icua, bacua jobona nëcani, coca ca bi'raguëña: ");
INSERT INTO snnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yo'je sanhuë, Riusu Espíritubi cani jo'ca güeseguëna, mai ira bainguë ba'isi'quë David hue'eguë ba'isi'quëbi toyani jo'caguëna, yureña Riusu cocarebana toyani jo'case'e ba'iji. Ja'an coca toyani jo'case'ere ro'tato, Riusubi yureñabi mai jobona te'e ruiñe yo'o güesebi. Davidbi cani jo'caguëna, ");
INSERT INTO snnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","mai jubë bainguë ba'isi'quë Judas hue'eguëbi güina'ru yureña yo'obi. Yequëcuabi Jesusre preso zeanni bañu cajënna, Judasbi Jesús ba'irute bacuare ëñoni conbi. Mai jubëre ba'iguë, Jesusre yo'o conguë ba'isi'quëta'an, Jesusre je'o bacuani ro yahue conbi. ");
INSERT INTO snnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Conguëna, ba hua'nabi baguëni ro'ijënna, baguë gu'a curi naconi inni, yijare coni babi. Ja'nca coni baguëbi huajë junni, baguë sinjobëna tonquëna, baguë guëtabëbi juejueguëna, baguë guëta tu'u beoru runi tonni saji'i. ");
INSERT INTO snnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ja'nca huajë junquëna, si'a Jerusalén bainbi achani, ba yijare bacua cocabi Acéldama hue'yohuë. Zie yija hue'yosiru baji'i. ");
INSERT INTO snnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judas gu'aye yo'ose'ere quë'rë te'e ruiñe masiye yëtoca, Salmo casi uti pëbëna ëñani masijë'ën. Ñaca caji: Baguë huë'e yua bain senjosi huë'e'ru ruinja'guë. Bain beo huë'e ba'ija'guë. Se'e yequë quë'rona ëñani, ën cocare masijë'ën: Yequëbi baguë yo'ore yo'oye cuencuesi'quë ba'ija'guë. ");
INSERT INTO snnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ja'nca toyani jo'case'e sëani, Riusu coca toyani jo'case'e'ru güina'ru yo'ona'a. Mai jubë ba'icuare cu'eto, si'a Jesucristo ën yija ba'iguë ba'ise'ere ëñasi'cua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan bautiza güesesirënbi guënamë re'otona mëni saisirën tëca baguë naconi te'e conjën ba'isi'cuare sëani, te'eguëte cuencueni, mai naconi te'e yo'o con güeseñu. Jesucristo go'ya rani huahua mëise'ere ëñasi'quëre cuencueni, ja'an ëñase'ere quëani achoja'guë cajën, mai jubë naconi te'e ba'i güeseñu, cani tonguëña Pedro. ");
INSERT INTO snnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Cani tonguëna, ja'nrëbi si'a jubëre ëñani, samucuare cuencueni nëcoreña. Te'eguë, José hue'eguë, yequë mami Barsabás hue'eguë, Justo'ga hue'eguë, ja'anguëte cuencueni nëcoreña. Yequëre'ga Matías hue'eguëre cuencueni nëcoreña. ");
INSERT INTO snnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ja'nca cuencueni nëconi, Riusuni senni achareña: —Ëjaguë Riusu, më'ëbi si'a bain recoyo ro'tayete masiguë sëani, ëncua samucua, yëquëna cuencueni nëcosi'cuare ëñani, ¿Jaroguëni më'ë ta'yejeiye yo'ore yo'oye re'huani jo'caguë'ne? ");
INSERT INTO snnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas yo'ore jo'cani senjose'ere ro'taguë, ¿jaroguëni mame re'huani jo'caja'guë'ne? Judasbi gu'aye yo'oni, baguë gu'a jucha ro'ire junni tonni, baguë bënni senjoja'runa saosi'quë sëani, yëquëna bain cuencueni nëcosi'cuare ëñani, te'eguëni ja'an yo'ore yo'o güesejë'ën, Ëjaguë, cajën, Riusuni senni achareña bacua. ");
INSERT INTO snnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Senni achani tëjini, ja'nrëbi yahueni toyasi gatagate uanreña. Uanni ëñato, Matías yua Riusu ta'yejeiye yo'o cuencuesi'quë baquëña. Yequëcua oncecua naconi te'e zi'inni baquëña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ja'nrëbi Riusu jëja umuguse Pentecostés casi umuguse, judío bain ru'ru tëasi aon umugusebi ti'anguëna, Riusu bain si'acuabi te'eruna ñë'cani bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba'ijënna, te'e jëana guënamë re'otobi ai jëja achoguëña. Ai jëja tutu raye'ru achoni, bacua ñu'ijën ba'i huë'e beoru ai achoreba achoguëña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ja'nca achoguëna, ba hua'nabi mëiñe ëñato, toa zemeñoa ba'iye'ru huahua meni tonquëña. Ga bainguëna huo'hueni te'e toa zemeño tuaguëña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tua mequëna, Riusu bain si'acua yua Riusu Espírituni si'a recoyoreba bani, bojo hua'na re'huani, ja'nrëbi Riusu Espíritubi ca güeseguëna, tin bain cocare ca bi'rareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ja'ansi umuguseñabi judío bain, Riusuni ai yëjën bojocua, si'a ën yija re'otobi raisi'cuabi yua Jerusalén huë'e jobona ti'an raisi'cua bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ja'nca ba'icuabi Riusu bain tin coca cayete achani, ai jai jubë bainbi ñë'cani, gue ro'taye beoye achareña. Ga bainguëbi baguë cocare achani, Yë'ë cocare queaca masiye caye'ne cajën, ai bojojën achareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gue ro'taye beoye achajën, sa'ñeña bojojën, sa'ñeña ca bi'rareña: —Ja'an hua'na si'a hua'na ro Galilea bain ye'yema'isi'cua sëani, ¿queaca yë'ë cocare caye poreye'ne? ");
INSERT INTO snnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yë'ë yija bain coca ¿queaca caye masiye'ne bacua? sa'ñeña senni achajën, gue ro'taye beoye nëcareña si'acua. ");
INSERT INTO snnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ja'an bain achacuare ëñato, si'a hua'nabi tin yijañabi raisi'cua bateña. Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO snnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, Cirene que ca'ncoña yijaruan, Africa ba'iruan, ja'anruan bainbi raisi'cua bateña. Romabi rani ba'icua'ga bateña. Yequëcuabi judío bainreba bateña. Yequëcuabi tin yijañabi rani, judío bain ujayete ye'yesi'cua bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yequëcua'ga Creta, Arabia, ja'an yijañabi raisi'cua ba'ijën, ga bainguë baguë yija cocare achato, Riusu bainbi Riusu ta'yejeiye ba'iyete cani achojën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ja'nca cani achojënna, ja'an bain ñë'casi'cuabi gue ro'taye beoye achajën, sa'ñeña senni achajën bateña: —¿Gue'ne yureca? ¿Queaca maire yo'oguë'ne Riusu? senni achareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Senni achajënna, yequëcua'ga Jesucristore yo'o concuani ëñajën, bacuare ro jayajën careña: —Ro güebe neni, ro coca cayë bacua, careña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Cajënna, Pedro yua Riusu ta'yejeiye yo'o concua oncecua naconi ba'iguëbi nëcani, bainni si'a jëja coca ca bi'raguëña: —Mësacua judío bain, si'a Jerusalén huë'e jobo ba'icua, yë'ëbi coca caguëna, te'e ruiñe achajë'ën. ");
INSERT INTO snnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ëncua yë'ë bain concuabi güebema'iñë. Ënsëguë yuta zijeirën së'iguë sëani, mësacua yua huacha ro'tahuë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Riusu yo'oja'yete cani jo'case'e'ru yureña maini yo'oni jo'caji baguë. Riusu ira bainguë cuencuesi'quë Joel hue'eguëbi toyani jo'caguëna, mësacua achani masijë'ën: ");
INSERT INTO snnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ën yija carajei umuguseña ti'anguëna, ën yo'ore yo'oja'guë'ë yë'ë, caji Riusu. Yë'ë Espíritute si'a bainna gacho meni tonguëna, ai recoyo bojojën ba'ija'cua'ë bacua. Ja'nca bojojën, mësacua mamacua, ëmëcua, romi zincua, si'acuabi yë'ë cocare masini cani achoja'cua'ë. Mësacua bain bonsëcuabi Riusu guënamë toyare ëñani masija'cua'ë. Mësacua bain iracuabi Riusu ëo cainruna ëñani masija'cua'ë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja'an umuguseñabi ti'anguëna, yë'ë Espíritute gacho meni, yë'ë bain yë'ëre yo'o concuani tonni baja'guë'ë yë'ë. Ja'nca tonni baguëna, yë'ë ba'iyete bainna quëani achoja'cua'ë bacua. ");
INSERT INTO snnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ja'ansi umuguseñabi yë'ë yua ai ta'yejeiye yo'oni, guënamë re'otona ëñoja'guë'ë. Yija re'oto'ga ëñoja'guë'ë yë'ë. Zie, toa, ai rëiye toa pico, ja'anre ëñoja'guë'ë yë'ë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ja'an umuguse Riusu ta'yejeiye ba'i umuguse, Jesucristo ti'an rai umuguse yuta ti'anma'iguëna, ënsëguëbi zijei re'oto na'ini huesëja'guë'bi. Ñañaguë'ga yua zie'ru majequë ruinja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ja'nca ba'iguëna, bain hua'nabi Riusu ba'i jobona ti'anni si'arën ba'iye yënica, Jesucristo ta'yejeiye coñete te'e ruiñe senreba senjë'ën, cani jo'cabi Riusu. ");
INSERT INTO snnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ja'nca toyani jo'case'e sëani, mësacua Israel bain, yë'ëbi yëhuo cocare mësacuani quëani achoguëna, te'e ruiñe achani masijë'ën: Riusubi baguë Zin Jesucristore cuencueni, mësacuana raoguëna, ai ta'yejeiyereba yo'oni mësacuani ëñoguëna, mësacuabi ëñani, baguë ta'yejeiye ba'iyete masihuë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ja'nca masicuata'an, mësacua yua Riusu cuencueni jo'case'e'ru yo'ojën, Jesucristore preso zeanni, gu'a bain naconi crusu sa'cahuëna te'e reoni, baguëni ro huani senjohuë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Huani senjosi'quëreta'an, Riusubi ai ta'yejeiye Ëjaguë sëani, baguëte go'ya rai güesebi. Mai ta'yejeiye Ëjaguëre sëani, ju'insi'quëre gare jo'cani senjoñe poremaji'i. ");
INSERT INTO snnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mai ira Ëjaguë ba'isi'quë David'ga Jesús ba'ija'yete toyani jo'caguëña. Ën cocare toyani maina jo'caguëña: Yë'ë ëjaguëbi yë'ë naconi te'e ba'iguëna, gare jo'caye beoye baguëni ëñañe poreyë yë'ë. Yë'ë yua ñañaja'runa to'inma'iñe caguë, yë'ë jëja ca'ncona nëcani, yë'ëre baji. ");
INSERT INTO snnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja'nca sëani, yë'ë yua ai bojo recoyo re'huani baguëni ai bojoreba bojoguë cani achoyë yë'ë. Baguëbi yë'ëni masi güeseguëna, yë'ë junni tonja'rën ti'anguëna, yë'ë ga'nihuëbi gare pu'ncaye beoye ba'ija'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yë'ë recoyote gare jo'cani senjoma'ija'guë sëani, yë'ë yua më'ëre yo'o con hua'guë ba'iguëna, yë'ë ga'nihuëte gare pu'nca güeseye beoye ba'ija'guë'ë më'ë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yë'ë yua se'e go'ya raija'guëre sëani, më'ëbi yë'ëni ja'anre masi güeseguëna, yë'ëbi më'ëni ëñani, ai ta'yejeiyereba bojoguë ba'ija'guë'ë yë'ë, toyani jo'caguëña David. ");
INSERT INTO snnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ja'nca sëani, yo'je sanhuë, David coca toyani jo'case'ere ro'tani ye'yejë'ën. Mai ira ëjaguë ba'isi'quë Davidbi ja'an cocare toyani jo'cani, ja'nrëbi junni tonguëna, baguë bainbi baguëte tanni jo'careña. Jo'carena, baguë ga'nihuëbi pu'ncani carajaquëña. Baguë tansiru yuta mai naconi ba'iguëna, ëñani masijë'ën. ");
INSERT INTO snnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ja'nca pu'ncani huesësi'quëta'an, Riusu ta'yejeiye yo'oja'yete quëaguë ba'nquëña. Riusubi ën cocare quëani jo'caguëna, te'e ruiñe ro'taguëña baguë: Te'e ruiñereba quëani jo'cayë yë'ë. Më'ë bainguë jë'te raija'guëre cuencueni raoguëna, më'ë ta'yejeiye Ëjaguë ba'iye'ru ai ta'yejeiye Ëjaguë ba'ija'guë'bi, quëani jo'caguëña Riusu, baguë Zin Jesucristore. ");
INSERT INTO snnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ja'nca quëani jo'caguëna, mai ira ëjaguë ba'isi'quë Davidbi achani, te'e ruiñe recoyo ro'tani, Cristo raija'yete masiguëña. Masini, Cristo junni tonni go'ya raija'yete toyani jo'caguëña. Yë'ë recoyote gare jo'cani senjoma'ija'guë caguë, Yë'ë ga'nihuëte gare pu'nca güeseye beoye ba'ija'guë caguë, Jesucristo ba'ija'yete toyani jo'caguëña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ja'nca toyani jo'case'e ba'iguëna, Riusubi baguë Zin raosi'quëre, ja'ansi'quëre go'ya rai güesebi. Go'ya rai güeseguëna, yëquëna hua'nabi ëñasi'cua ba'iyë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ja'nca go'ya rai güeseni, baguë jëja ca'ncona mëani baji. Ja'nca bani, baguë Espíritute baguëna jo'cani, baguë ta'yejeiyereba conguëte re'huani baji. Riusu ru'ruña quëani jo'case'e'ru te'e ruiñe yo'obi. Ja'nca yo'oguëna, mësacua'ga yure umuguse Riusu ta'yejeiye yo'ose'ere achani ëñahuë. ");
INSERT INTO snnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ja'nca sëani, Davidbi guënamë re'otona go'ya rani mëimaquëña. Baguëbi ën coca se'gare toyani jo'caguëña: Riusubi yë'ë Ëjaguëni cabi: “Yë'ë jëja ca'ncona bëani ba'ijë'ën, ");
INSERT INTO snnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","më'ë je'o bacuani më'ë guëon na'mina ti'anni carajei güeseye tëca” toyani jo'caguëña David. ");
INSERT INTO snnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja'nca toyani jo'case'e sëani, Israel bain si'acuabi te'e ruiñereba achani masijë'ën: Mësacuabi ja'an Jesucristorebare crusu sa'cahuëna reoni, huani senjosi'cuata'an, Riusubi ta'yejeiyereba yo'oni, baguëni go'ya rai güeseni, baguë ta'yejeiyereba conguëte re'huani, mai Ëjaguërebare maire ëñobi, cani achoguëña Pedro. ");
INSERT INTO snnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cani achoguëna, bain hua'nabi achani, ai recoyo oijën, Pedroni, yequëcua Riusure ta'yejeiye yo'o concua, si'acuani senni achareña: —Ja'yë sanhuë, ¿queaca yo'oja'cua'ne yëquëna? senni achareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Senni acharena, Pedrobi sehuoguëña: —Mësacua yua Riusuna ti'anni quëajë'ën. Mësacua gu'a jucha yo'ojën ba'ise'e beoru gare jo'cani, Yë'ë gu'a juchare gare se'e ro'tama'ijë'ën cajën, Jesucristo ta'yejeiye ba'iyete si'a recoyo ro'tajën, ocona bautiza güesejën ba'ijë'ën. Ja'nca yo'onica, Riusubi baguë Espíritute mësacuana gacho meni ton güeseja'guë'bi. ");
INSERT INTO snnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ja'nca cani jo'casi'quë sëani, mësacua, mësacua mamacua raija'cua, so'o yijañare ba'icua, si'acua baguë bain cuencuesi'cuani baguë Espíritute insini, si'acuani baguë bainre re'huani baja'guë'bi Riusu, sehuoguë quëaguëña Pedro. ");
INSERT INTO snnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ja'nca quëani, se'e yeque cocare yihuoguë cani achoguëña: —Ën yija bain gu'ayereba yo'ojën ba'icuabi gare huesëni carajeija'cua sëani, bacua jobobi gare quëñëni, Riusuni recoyo te'e zi'nzini, baguë bainreba ba'ijë'ën, cani achoguëña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ja'nca cani achoguëna, bain hua'nabi te'e ruiñe achani, baguë case'e'ru yo'o bi'rareña. Jesucristoni recoyo te'e zi'nzini ocona bautiza güesereña. Ja'nca yo'ojën, ja'ansi umuguse samute mil bainbi Jesucristoni si'a recoyo ro'tareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ja'nca ro'tani, Riusure ta'yejeiye yo'o concuabi ye'yojënna, te'e ruiñe achani, gare jo'caye beoye Riusu yëye'ru yo'ojën bateña. Si'a jubëbi sa'ñeña recoyo te'e zi'nzini, sa'ñeña bojojën, Riusuni te'e ujajën, Riusu naconi te'e zi'nzini aon huo'huejën, te'e ainjën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ja'nca ba'ijën, Riusure ta'yejeiye yo'o concuabi ai ta'yejeiye yo'ore yo'oni jo'cajënna, bain hua'nabi te'e ruiñe ëñajën, ai ro'tajën, Riusu yëye'ru te'e ruiñe yo'oñu cajën yo'o bi'rareña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Si'acua, Jesucristo naconi recoyo te'e zi'nzini ba'icuabi bacua bonsere inni, sa'ñeña huo'huejën, ro insijën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bacua jubë ba'icua yequëcuabi ai bonsere bajën, bacua bonsere insini curi coni, Cristo bain bonse carajën ba'icuana ro insijën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Si'a umuguseña bacuabi Riusu uja huë'ena ñë'cani ujani, ja'nrëbi jurëanbi bain huë'eñana ñë'cani, Riusu naconi te'e aonre ainjën, Riusuni Surupa cajën, recoyo te'e bojoreba bojojën bateña. ");
INSERT INTO snnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Riusuni cajën, Ai ta'yejeiyereba Ëjaguë ba'iguë'ë më'ë, cajënna, si'a bainbi bacuani te'e ruiñe ëñajën bateña. Riusu bainbi ja'nca ai bojojën ba'ijënna, Riusubi se'e yequë bainre si'a umuguseña cuencueni, bacuani mame recoyo re'huani, baguë bain jubëna ñë'ca güeseguë baquëña. ");
INSERT INTO snnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ja'nrëbi, yequë umuguse, ënsëguëbi a las tres ba'iye'ru së'iguëna, Riusu bain ujajën ñë'cajairën sëani, Pedro, Juan, bacuabi Riusu uja huë'ena mëi bi'