﻿USE sofia;
DROP TABLE IF EXISTS sofia.snf_vpl;
CREATE TABLE snf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snf_vpl WRITE;
INSERT INTO snf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Níilii caasamuncii Yéesu Kiristaa, kucaasamunkii Dëwít, ee Dëwít yiima en kucaasamun Abarahamɗa, wërí wii: ");
INSERT INTO snf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraham límmba Ísaak. Ísaak límmba Yakoop. Yakoop límmba Yúdaa, ya na ɓikëmëeŋkíci ");
INSERT INTO snf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yúdaa límmba Farees na Sara, eewɓa teeksee Tamaꞌ. Farees límmba Esarom. Esarom límmba Aram. ");
INSERT INTO snf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram límmba Amínadap. Amínadap límmba Naason. Naason límmba Salmoon. ");
INSERT INTO snf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoon laakka na Rahap Boos. Boos laakka na Rut Yobet. Yobet límmba Yesee. ");
INSERT INTO snf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesee límmba buuꞌ Dëwít. Dëwít laakka na ɓeti Úríꞌ Salmoon. ");
INSERT INTO snf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salmoon límmba Robowaan. Robowaan límmba Abíyaa. Abíyaa límmba Asaf. ");
INSERT INTO snf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf límmba Yosafat. Yosafat límmba Yoraam. Yoraam límmba Osiyaas. ");
INSERT INTO snf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyaas límmba Yotaam. Yotaam límmba Akaas. Akaas límmba Esekíyaas. ");
INSERT INTO snf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekíyaas límmba Manasee. Manasee límmba Amoos. Amoos límmba Yosiyaas. ");
INSERT INTO snf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyaas límmba Yekoñaas na ɓikëmëeŋkíci ga jamaanaa ɓu-Isarayeel toolohu na dooli ga kúlkaa Babíloonɗa. ");
INSERT INTO snf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ga waa ɓu-Isarayeel toolu Babíloonɗa, Yekoñaas límmba Salaceel. Salaceel límmba Sorobabeel. ");
INSERT INTO snf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabeel límmba Abíyút. Abíyút límmba Elíyakím. Elíyakím límmba Aasooꞌ. ");
INSERT INTO snf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aasooꞌ límmba Sadok. Sadok límmba Akím. Akím límmba Elíyút. ");
INSERT INTO snf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elíyút límmba Eleyasaaꞌ. Eleyasaaꞌ límmba Matan. Matan límmba Yakoop. ");
INSERT INTO snf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoop límmba Yoseef, ƴaal Mariyaama, yaa en eew Yéesu yii ɓaysi Kiristaaniiɗa. ");
INSERT INTO snf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iñaa aboh ga Abaraham bi ga buuꞌ Dëwít, laakin kon jamaanu-ɓoꞌ cidaaŋkaah na cinikiis; lëehíꞌta iñaa aboh ga buuꞌ Dëwít bi ga daa ɓu-Isarayeel toolohu na dooli ga kúlkaa Babíloonɗa laakin jamaanu-ɓoꞌ cidaaŋkaah na cinikiis, ee ɓaawaagaɓa ga kúlkaa Babíloon bi ga kilímukkaa Kiristaanii, laakin jamaanu-ɓoꞌ cidaaŋkaah na cinikiis. ");
INSERT INTO snf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kilímukkaa Yéesu Kiristaa laakoh anee: Eeci Mariyaama enee jowu Yoseef. Ee balaa ɓa bok túuyaa, Mariyaama ennda na look ga tumeenaa Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoseef fiilaagari enee ɓoꞌ yijúwíꞌ, ee iñaama tah ya waaréeríiri kiwíiñ ga fíkíi ɓuwaa, ya nammbari kiheel kifoñ ee ken yéegoo. ");
INSERT INTO snf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lak ya yaa lís kihalaat ga iñaama, dalla kilaak malaakaaHaꞌmudii, yaa feeñukki ga ɗuuƴ heeƴ, woꞌꞌari an: - Yoseef, kucaasamunkii Dëwít, kaa niik kiɓeɓ Mariyaama ya en ɓetifu ndaga lookaa ya ɓayɗa meyoh ga tumeenaa Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ya hay kilaak kowu kiƴaal, ee fu teekanka Yéesu, ndaga yërí ƴah kimúsal ɓuwiigari ga baakaaꞌciigaɓa. ");
INSERT INTO snf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tóoh iñcaama laakka doonaa iñaa Haꞌmudii, woꞌee kooroh ga kúuwkaa sëldíiga-Koohaaɗa mat. ");
INSERT INTO snf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ya woꞌee an: «Oomaa-jowaa ínohoo ƴaal hay kiꞌen na look, ya laak kowu kiƴaal kaa ƴah kiteeku Emanuweel.» Teekaama wërí en “Kooh yii naruu.” ");
INSERT INTO snf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ga waa Yoseef yúudukɗa, ya tummba fodaa daa malaakaa Haꞌmudii nakeerikaɗa: ya haydohha ɓetici Mariyaama kaanci. ");
INSERT INTO snf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wayee ya ínohhiiri bi ga daa Mariyaama laak kowu kiƴaalɗa, ya teekkaka Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ga waa Yéesu límu ga teeraa Betleeꞌem ga kúlkaa Yúudée, lakanaa Eroot en buuꞌ daamaɗa, laakka ɓiɓoꞌ ɓilëekíꞌ-hamham ga loo ol, ɓa meyoh Peŋku hayussa Yéerúsaleem, ");
INSERT INTO snf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ɓa meekisohha an: - Yada buurii yaawúuꞌcii han kilímuɗa? Ɗí hotin kuꞌolkaagari ga Peŋku ee ɗí hay kijaamukki. ");
INSERT INTO snf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ga waa Eroot buuraa kelohkaɗa, ya jaahliꞌꞌa lool, ya na ɓu-Yéerúsaleem ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ya hídírohha sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa ɓu-dëkaa. Ya meekissaɓa ɗekataa Kiristaanaa jom kilímohuɗa. ");
INSERT INTO snf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓa taassari an: - Ya jom kilímohu Betleeꞌem ga kúlkaa Yúudée, ndaga iñii yii yërí sëldíiga-Koohaa bídee: ");
INSERT INTO snf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«Ee fu, Betleeꞌem, ga kúlkii Yúudée, enndii an kay fu wëñ kijutuut ga dëkcii Yúudée, ndaga haꞌ-kúlkii ƴah kiníiꞌ ɓu-Isarayeel, heetiigooɗa, meyohan garaa.» ");
INSERT INTO snf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Waa ennda ɗa, Eroot ɓayya haꞌ-hamhamcaa ga pet, meekissaɓa wahtaa olaa meƴ siiƴɗa. ");
INSERT INTO snf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lëehíꞌta, ya wossaɓa Betleeꞌem, woꞌꞌaɓa an: - Karat, ɗú meekisoh dijófíꞌ ga loo kuꞌoomaakaa. Ɗú hotjanaa, yéegalattoo doonaa mi ɓan mi kaꞌja kijaamuknee. ");
INSERT INTO snf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ga waa buuraa woꞌꞌa naɓa bi lëehíꞌta, ɓa ammba waas. Ee ga waa ɓa en ga waasɗa, ɓa hotissa kuꞌolkaa ɓa séenee ga Peŋkuɗa. Daa ɓa hotja hen keeñɓa soossa lool. Kuꞌolkaa kuliyukka ga fíkíiɓa bi ga ɗekataa oomaanaa enohɗa, ja tuukka da. ");
INSERT INTO snf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Fodaama, ɓa aassa ɗuuƴ kaanfaa. Ɓa hotta kuꞌoomaakaa na eeci, Mariyaama. Ɓa ƴíꞌꞌa, jaamukussa kuꞌoomaakaa. Lëehíꞌta ɓa pëkíssa hëmbúcaagaɓa, ɓa eꞌtari cikëñíꞌcaa: enee wúrúus, cúuraay, na míiꞌ. ");
INSERT INTO snf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Waa ennda ɗa, Kooh yéegallaɓa ga heeƴ an ɓa hanat kiɓoyukoh ga Eroot. Ɓa ɓoƴkohha waas wiliis ɓaa ƴah kúlɓa. ");
INSERT INTO snf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Laakka malaakaaHaꞌmudii feeñuk Yoseef ga heeƴ, lak haꞌ-hamhamcaa karuunun, woꞌꞌari an: - Kolka, ɓewaa oomaanii na eeci, núpaa kúlkaa Esípti, ndaga buuꞌ Eroot hay kiraasluk oomaanii kiꞌaplukki. Tesaa daama bi ga daa mi woꞌsanndaa yen yiliis. ");
INSERT INTO snf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yoseef kolukka ga wek, ɓeɓpa oomaanaa na eeci, kaꞌneera naɓa kúlkaa Esípti. ");
INSERT INTO snf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya tessa daama bi ga daa Eroot kaanɗa. Fodaama iñaa Haꞌmudii woꞌee, koorohha ga kúuwkaa sëldíiga-Koohaaɗa matta. Ya woꞌee an: «Mi ɓayya kowukaagoo ka meyoh kúlkaa Esípti.» ");
INSERT INTO snf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eroot ínohha an ɓuwaa ɓilëekíꞌ-hamhamɓaa ga loo olɗa ɗúkuununndi, ya aylukka lool. Ya dalla kiꞌebil ɓisoldaaꞌ Betleeꞌem na dëkcaa wíilwaɗa, ɓa ap ɓéeɓ tuꞌoomaa-ƴaaltaa laakin tíkíis tanak aawwa taahay. Ndaga tíkíistaama méeŋngoh na jamaanaa haꞌ-hamhamcaama woꞌseeriɗa. ");
INSERT INTO snf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Fodaama, iñii yii ee Yérémíi sëldíiga-Koohaa woꞌeeɗa matta. Ya woꞌee an: ");
INSERT INTO snf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Laakin koonaakaa kelohuk ga teeraa Ramaa, tikodukoh na tilooyoh timéeskíꞌ taa da. Rasel yërí en na kikoduk towutaagari, ee ya waaꞌtii ken ɗékóhíꞌti, ndaga ta lísissii.» ");
INSERT INTO snf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Waama, lak buuꞌ Eroot kaanin. Laakka malaakaa Haꞌmudii feeñuk Yoseef ga heeƴ, ga kúlkaa Esípti, ");
INSERT INTO snf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","woꞌꞌari an: - Ɓuwaa heelsee kiꞌap oomaaniiɗa kaanuunun. Kolka, ɓewaa oomaanii na eeci, ɓoƴkaa kúlkaa Isarayeel. ");
INSERT INTO snf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoseef kolukka, ɓeɓpa oomaanaa na eeci, ya ɓoyukka kúlkaa Isarayeel. ");
INSERT INTO snf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ee daa Yoseef kelohee an Arkelawoos yërí lam Eroot, paamci ga kibuuꞌkaa kúlkaa Yúudée, ya niikka da kikaꞌ. Kooh woꞌꞌa nari ga heeƴ, ya kaꞌneera gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ya dëkka ga teeraa woꞌu Nasareetɗa. Fodaama iñaa sëldíiga-Koohcaa woꞌee ga Kiristaaniiɗa matta. Ɓa woꞌee an: «Ya dakantilohsan ga Nasareet.» ");
INSERT INTO snf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ga jamaanaama, Saŋ-Bëtís hayya ga, ya yaa jangat ga ɗuuƴ ëgíꞌ-dúndagaa kúlkaa Yúudée an: ");
INSERT INTO snf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","- Súpítat kipeskiigarúu, ndaga Nguurii ga ɗookɗa deeyin! ");
INSERT INTO snf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Saŋ yërí en ɓaa Ísayíisëldíiga-Koohaa woꞌee gari an: «Laakin koonaa-ɓoꞌ, kaa en na kiwoꞌ didóolíꞌ ga ëgíꞌ-dúndagaa an: “Waayukɗat Haꞌmudii waasii, júwíꞌɗatti tuwaas-waastii!”» ");
INSERT INTO snf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Saŋ ekukee kúltífaa terohu na fënúf geeleem, ya pëkírukka liiɓ-on ga kenohkaa. Ya daanee kiñam paƴ na kúum. ");
INSERT INTO snf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓuwaa ɓaa meyoh Yéerúsaleem, na ɓéeɓ kúlkaa Yúudée na ɓéeɓ dëkcaa deeƴ húlúwaa Yúrdeŋɗa, ɓaa hay gari. ");
INSERT INTO snf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓa ɓaa récuk baakaaꞌcaagaɓa ga fíkíi ɓéeɓ ee Saŋ yaa bëtísiꞌɓa ga húlúwaa Yúrdeŋ. ");
INSERT INTO snf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Daa Saŋ hotee ɓiFërísiyeeŋ na ɓiSaduseyeeŋ ɓiyewin ɓaa hay gari kibëtísiꞌuk, ya woꞌꞌaɓa an: - Heet goŋ-saamaancii, ɓii lëdíꞌtúu ɓa iñaa tahanndúu kirëc ga aylukaa Kooh ƴah kihayɗa? ");
INSERT INTO snf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kon tumat iñcaa teewohin an ɗú récukin baakaaꞌciigarúu. ");
INSERT INTO snf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ee kaa abat ga hellúu an: “Abaraham en caasammbíi”. Ndaga mi woꞌꞌúu man Kooh mínin kiɓeɓ atohcii cii, ya meƴdoh ga tucaasamun Abaraham! ");
INSERT INTO snf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Diima deŋ këkúsaa tíimin boscaa tediktaa, kigúꞌ níilcaa. Kon kedikkaa límmbii towu tijófíꞌ tóoh, gúru, jafu ga kiwii. ");
INSERT INTO snf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi, mi bëtísiꞌꞌúu ga músú kiteewoh an ɗú súpítin kipeskiigarúu. Wayee ɓaa en na kihay ga fenoorooɗa ƴahhúu kibëtísiꞌ na Helaa yiselaꞌíꞌyaa na ga kiwii. Yërí wëñnjoo kimat: mi jutuutin ga kiɗol ñafaꞌcaagari. ");
INSERT INTO snf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kankaa kaa ga yahci ee ya ƴah kifaaꞌ yoonaagari, ya ek tohootaagari ga dapaa; wayee fekiꞌfaa, ya hayfa kitëkíꞌ ga kiwiikaa ƴímoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Waa ennda ɗa, Yéesu kúlkohha Gëlílée hayya kibëtísiꞌuknee ga Saŋ ga húlúwaa Yúrdeŋ. ");
INSERT INTO snf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wayee Saŋ tookkii, ya woꞌꞌa Yéesu an: - Mi yërí sooluk kihay garaa fu bëtísiꞌꞌoo, fu nammba garoo kihay! ");
INSERT INTO snf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wayee Yéesu loffari an: - Tookaa hen rek, ndaga ɗu jomin kimëtíꞌ iñaa Kooh waaꞌɗa. Waa ennda ɗa, Saŋ tookka. ");
INSERT INTO snf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Daa Yéesu bëtísiꞌsee bi lëehíꞌta, ya meƴca músúmaa. Ga saasi asamaanaa lëgísukka, ya hotta Helaa Kooh yaa yoosuk ga ɗookci en fan hoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Laakka koonaakaa meyoh ɗook woꞌꞌa an: - Ɓii yii yërí en Kowukiigoo mi keeñukɗa, keeñnjoo soosin gari! ");
INSERT INTO snf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Waa ennda ɗa, Helaa yiselaꞌíꞌyaa woocca Yéesu, ɓayyari ga ɗekat, ëgíꞌ-dúndaŋ doonaa Seytaani fíꞌti. ");
INSERT INTO snf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ga waa Yéesu ooꞌta noh-noh cidaaŋkaah-nikiis na wekcaagaca, faf kiyaaɓ ammbari. ");
INSERT INTO snf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Waa ennda ɗa, Seytaani deeƴca Yéesu kifíꞌti. Ya woꞌꞌari an: - En lak fu yërí en Kowukii Koohaa, nakaa atohcii ca súpítuk mbúurú. ");
INSERT INTO snf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wayee Yéesu loffari an: - Këyítfaa woꞌ an: «Ɓoꞌ pesohanndii na mbúurú doŋ, wayee ɓan, na tóoh woꞌeenaa meyohin ga kúuw Kooh.» ");
INSERT INTO snf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Waa ennda ɗa, Seytaani ɓayyari Yéerúsaleem, teeraa wiselaꞌíꞌwaa, yíppari ga ɗook Kaanfaa Kooh, ");
INSERT INTO snf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","woꞌꞌari an: - En lak fu yërí en Kowukii Koohaa, yípukaa kakay, ndaga Këyítfaa woꞌ an: «Kooh hayyaa kinakiꞌ malaakacaagari, ɓa teeŋngaa ga yahcaagaɓa, doonaa kotfu këftukoo ga atoh.» ");
INSERT INTO snf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yéesu loffari an: - Bíduunun ɓan an: «Kaa jéematuk Haꞌmudii, Koohyiigaraa.» ");
INSERT INTO snf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Waa ennda ɗa, Seytaani ɓayissa Yéesu ga ɗook jaŋjaŋ wihóoríꞌ, ya teeɓpari dëkcii ga ëldúnaɗa tóoh na ndamaa nguuraagaca, ");
INSERT INTO snf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","woꞌꞌari an: - Mi hayyaa kiꞌon iñcuma tóohca binaa fu ƴíꞌ ga fíkíiroo, fu jaamukkoonaa. ");
INSERT INTO snf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wayee Yéesu woꞌꞌari an: - Nískaa dii Seytaani! Ndaga Këyítfaa woꞌ an: «Fu ƴíꞌɗan Haꞌmudii, Koohyiigaraa ee fu jaamukanndi ya doŋ.» ");
INSERT INTO snf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Waa ennda ɗa, Seytaani hannda Yéesu kiꞌíis kimma, laakka malaakacaa Kooh hayu ga Yéesu ɓa ɓaa toputuꞌꞌi. ");
INSERT INTO snf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ga waa Yéesu kelohha an Saŋ-Bëtís abuunun ga kasu, ya kaꞌta gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya yuŋngii ga Nasareet, ya kaꞌta kidëknee ga teeraa Kafarnawom en ga gohaa Sabulon na Neftalíi. Teeraama en ga yahaa giiyaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iñaama laakka fodaama doonaa iñaa Ísayíi, sëldíiga-Koohaa woꞌeeɗa mat. Ya woꞌee an: ");
INSERT INTO snf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ɗú ɓu-Sabulon, ɗú ɓu-Neftalíi; Gohcii deeƴ ga giiyii bi ga ɓakaa hanoh húlúwaa Yúrdeŋ gaaɗa; Fu Gëlílée, kúlkii ɓuwii enussii yaawúuꞌ dëkohɗa! ");
INSERT INTO snf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Heetii dëkee ga ñúusɗa, hotin leeꞌlaat wiyaak, ɓuwaa dëk ga kúlkaa kiñúusíꞌkaa kikaan enohɗa, leeꞌlaat hayin gaɓa!» ");
INSERT INTO snf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Waa ennda ɗa, Yéesu aawwa kijangat an: - Súpítat kipeskiigarúu, ndaga Nguurii ga ɗookɗa deeyin! ");
INSERT INTO snf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yéesu enee na kitíidisuk ga seereenaa giiyaa Gëlílée. Ya hotta ɓoꞌ ɓanak ɓaa bokoh. Enee Simoŋ yaa teeku Peeꞌɗa na Andari këmëeŋkíci. Ɓa ɓaa wees mbaal ga giiyaa Gëlílée. Ɓa enee ɓimbaaloh jën. ");
INSERT INTO snf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yéesu woꞌꞌaɓa an: - Taabukattoo, mi hayyúu kitum ɓimbaaloh ɓoꞌ! ");
INSERT INTO snf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ga saasi ɓa foñnja mbaalcaagaɓa, ɓaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ga waa Yéesu kaꞌta bi ga fíkíi, ya hotta ɓoꞌ ɓanak ɓiliis ɓaa bokoh. Enee towutaa Sebedee: Saak na këmëeŋkíci Saŋ. Ɓa enee ga ɗuuƴ gaal-loocaa na Sebedee paamɓa, ɓaa hëwíraat mbaalcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yéesu ɓayyaɓa; ga saasi, ɓa foñnja paamɓa na gaal-loocaa, ɓaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yéesu yaa wíil gohaa Gëlílée ɓéeɓwa, yaa jëgíroh ga jaangu-yaawúuꞌcaa, yaa yéegaloh Hewhewii winéwíꞌwii woꞌ ga loo Nguuraa ga ɗookɗa, ee ya yaa wëkíꞌ ɗúukoolcaa ɓuwaa ɓéeɓca na ɓéeɓ iñcaa mesik ɓuwaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Teekaagari síwwa ga ɓéeɓ kúlkaa Síríi. Ya yaa komu ɓéeɓ ɓuwaa ɗúukool, ee ɗúukoolcaagaɓa na mesiklaatcaagaɓa bokkii. Ennda ɓuwaa raɓ abee na ɓaa laakee cikeen-keen, na lafañcaa, ya yaa wëkíꞌɓa. ");
INSERT INTO snf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mbooloo wiyaak waa taabukki: ɓuwaa meyohee gohaa Gëlílée na gohaa Teerucaa Cidaaŋkaahcaa, na teeraa Yéerúsaleem, na gohaa Yúudée, na gohaa hanoh húlúwaa Yúrdeŋ gaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Daa Yéesu hotee mbooloomaa, ya lappa ɗook jaŋjagaa, ya yuŋnga, tëelíbéecaagari hayussa ga yahaaci. ");
INSERT INTO snf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ya aawwaɓa kijëgíꞌ woꞌeencii cii: ");
INSERT INTO snf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","- Ɓa yewinin múuꞌ, ɓuwii tookuunun ga keeñɓa kinduulkaagaɓa ga fíkíi Koohɗa, ndaga Nguuraa ga ɗookɗa wuuɓa! ");
INSERT INTO snf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɓa yewinin múuꞌ, ɓuwii en na kikoduk watiɗa, ndaga Kooh hayɓa kiɗékóhíꞌ! ");
INSERT INTO snf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɓa yewinin múuꞌ, ɓuwii yewinin jamɗa, ndaga ɓërí ƴah kilam ëldúna! ");
INSERT INTO snf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɓa yewinin múuꞌ, ɓuwii ɗíibuk kipes ga iñaa Kooh nakohɗa, ndaga Kooh hayɓaka kitumiꞌ! ");
INSERT INTO snf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɓa yewinin múuꞌ, ɓuwii laakin yërmaandi ga mooroomɓaɗa, ndaga Kooh hay kilaak yërmaandi gaɓa! ");
INSERT INTO snf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɓa yewinin múuꞌ, ɓuwii setin keeñɗa, ndaga ɓa hay kihot Kooh! ");
INSERT INTO snf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓa yewinin múuꞌ, ɓuwii saki jam daa ɓa enoh tóohɗa, ndaga ɓa hay kiɓayu ɓitowu Kooh! ");
INSERT INTO snf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɓa yewinin múuꞌ, ɓuwii hatalu ga kipesɓa, ndaga kitum iñaa Kooh nakohɗa; Nguuraa ga ɗookɗa wuuɓa! ");
INSERT INTO snf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ɗú yewinin múuꞌ, binaa mi tah ɗú ɓassi, ɗú hatalsi ga kipessúu, ɗú woꞌɗusi enaama yibóníꞌ yaa en ɓéeɓ ee saboh! ");
INSERT INTO snf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Leenaa keeñnjúu soosat, ɗú neɓluki, ndaga neehalaagarúu ga ɗookɗa hay kiyak. En kiꞌenaa, sëldíiga-Koohcaa ɗeɓpúu kihayɗa hatalsee ga kipesɓa fodaama. ");
INSERT INTO snf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","- Ɗú ɓërí en maraamii ëldúna. Binaa maraa safissiinaa, ma ɗaanohsan na ya? Ma laaksisoo jeriñ, ma aamsan ga lëedúu, ɓuwaa togisohma. ");
INSERT INTO snf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ɗú ɓërí en leeꞌlaatii ëldúna. Teeraa tawahu ga ɗook tëgël mínoo kiɗaakuk. ");
INSERT INTO snf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ken taaloo lampu líꞌ kanu ga ɗookgaanaa. Wayee fu líkanwa hen doonaa wa mín kileeꞌ ga ɓéeɓ ɓuwaa enu ga túuyaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kon leeꞌlaatii en garúuɗa jom kimelic fodaama ga fíkíi ɓuwii. Doonaa ɓa mín kihot tumeencaagarúu cijófíꞌcaa, ee ɓa mín kikañ Paammbúu yii en ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","- Kaa foogat an mi hay kinís Waasii Móyíis wala iñii sëldíiga-Koohcii jëgírohɗa. Kinísca haydohhiiroo, wayee mi hayca kimëtíꞌsiꞌ. ");
INSERT INTO snf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mi woꞌꞌúuka ee kayoh; en an asamaanii na kakayfii cii lís diinaa, kuꞌoc jíinoo wala kufíiskaa wëñ kijutuut ga Bíncii Waasii nískoo ga, bi ga daa tóoh laakan. ");
INSERT INTO snf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kërí tah, ɓaa fu foñ enaama yíinoo doŋ yaa wëñ kijutuut ga iñcii nakohu kitumɗa, fu jëgíꞌ ɓuwaa kitum fodaamanaa, fu tíksan ɓaa wëñ kijutuut ga Nguurii yii ga ɗookɗa. Wayee ɓaa fu taabukca, fu jëgíꞌ ɓuwaa kitum fodaamanaa, fu tíksan ɓoꞌ yiyaak ga Nguurii yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mi woꞌꞌúu man: jëgíroh-waascii na Fërísiyeeŋcii, binaa ɗú wëñnjiiɓa kitaabuk iñaa Kooh nakohɗanaa, ɗú aasoo ga Nguurii yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","- Ɗú kelohin an woꞌsee caasamuncaa an: «Kaa laŋ kumuun ɓoꞌ. Ɓaa laŋ kumuun ɓoꞌ ɓéeɓ hay kiɓayu ga waas.» ");
INSERT INTO snf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ee mi woꞌꞌúu man: Ɓaa ayluk mooroomcinaa, gënin gari ya ɓayu waas. Ɓaa ɓas mooroomci an “Fu enndii dara” ɓéeɓ, gënin gari ya ɓayu ga fíkíi paanaa yaawúuꞌcaa wiyaakwaa. Ɓaa woꞌꞌi an “Hafiigaraa líiffii” ɓéeɓ, gënin gari ya jafu ga kiwiikaa safara. ");
INSERT INTO snf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Binaa book, ɓaa fu tuuk kiꞌeꞌ Kooh sarah ga loteelaa, ee daama fu níindísuk an mooroomfu amɗinndaa aylookaa, ");
INSERT INTO snf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","foñaa sarahaa daama ga loteelaa. Kara, fu júwohnee na mooroomfu paaƴ. Lëehíraa, ɓoƴka, fu eroh sarahaagaraa. ");
INSERT INTO snf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Binaa fu laakoh na ɓoꞌ, ɗú taam kilayohneenaa, gaawaa nari kijúwoh ga waasaa. En ɗanaa ya tíkooraa ga yah attiꞌohaa, yaama tíkkaa ga yah ëlkëetaa, fu tëcu ga kasu. ");
INSERT INTO snf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mi woꞌꞌúuka ee kayoh; fu meyohoo daama ee fu fayyii iñaa fu laakiꞌtiɗa bi ga fíftínaa mëeñjohɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","- Ɗú kelohin an woꞌsee an: «Kaa ɗúk ƴaalfu wala ɓetifu, fu faanuk na ɓoꞌ yiliis.» ");
INSERT INTO snf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ee mi, mi woꞌꞌúu man: ɓaa fu malak ɓeti mooroomfu bi helfu tes garinaa, fu ɗúkin ɓetifu, fu faanukka na ɓetifaama ga helfu. ");
INSERT INTO snf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Binaa en lak kuhaskaagaraa ñaabaa tahhaa kitum baakaaraa, lukitaaja fu jafja diꞌúsaayíꞌ. Iñaa gën garaaɗa wërí en kiñak ɓak wíinoo ga faanfiigaraa loo faanfiigaraa tóohfa jafu ga safara. ");
INSERT INTO snf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ee en lak yah-ñaabaagaraa tahhaa kitum baakaaraa, gúraawa, fu jafwa diꞌúsaayíꞌ. Iñaa gën garaaɗa wërí en kiñak ɓak wíinoo ga faanfiigaraa loo faanfiigaraa tóohfa jafu ga safara. ");
INSERT INTO snf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","- Laakin iñaa woꞌsee an: «ɓaa fu foñ ɓetifunaa, eraari jikëyítjaa teewoh an fu fasiꞌinndi.» ");
INSERT INTO snf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wayee mi woꞌꞌúu an: ɓéeɓ ɓaa fu foñ ɓetifu, ee enndii an ya ɗúkkaa hen faanukka na ƴaal yiliisaa, fu ekki ga kifaanuk na ɓoꞌ yiliis. Ee ɓaa fu pañ ɓetifaa fasiꞌu henaa, iñaa kiɗúk ɓetifu fu faanuk na ɓeti filiis. ");
INSERT INTO snf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","- Ɗú kelohin ɓan an woꞌsee caasamuncaa an: «Kaa waatuk sooƴ, wayee iñaa fu waatukin kitum ga fíkíi Haꞌmudiinaa, tumaari»; ");
INSERT INTO snf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","wayee mi, mi woꞌꞌúu man: Kaa waatat hen dara. Enndii ga teekii ɗook-Kooh, ndaga Kooh yuŋ daama kinguuruk. ");
INSERT INTO snf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Enndii ga teekii kakayfii ndaga Kooh tum da ditogaaꞌ kotci. Enndii ga teekii Yéerúsaleem, ndaga daama en teeraa buurii yiyaakyii. ");
INSERT INTO snf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kaa waatuk ga hafiigaraa ndaga fu mínoo kiyaanaawiꞌ wala kisúusúusíꞌ kufen jíinoo ga. ");
INSERT INTO snf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Woꞌeenndúu en “Eheenaa”, enat “Ehee”. En óꞌóonaa enat “óꞌóo”. Iñaa ɓaatuk ga ɓéeɓ, meyoh ga Seytaani. ");
INSERT INTO snf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","- Ɗú kelohin woꞌu an: “Kobot baam fayohsi baam”; ");
INSERT INTO snf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","wayee mi, woꞌꞌúu an: ɓoꞌ tummbúu iñaa meskinaa, kaa ëldúkat. Binaa ɓoꞌ múttaa paꞌ ga ŋaamaagaraa ñaabaanaa, eraari wíinoowaa ɓan. ");
INSERT INTO snf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Binaa ɓoꞌ waaꞌtaa kiɓay waas kiteꞌ túrkaagaraanaa, íisɗaari ɓan sibidooraa. ");
INSERT INTO snf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Binaa ɓoꞌ gítínndaa kitíin gaaf cijúnninaa, tíidaa nari cijúnni-kanak. ");
INSERT INTO snf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɓoꞌ kíimmbaanaa onaari, ee kaa saŋ kilúun ɓaa hayinndaa kilúuduk. ");
INSERT INTO snf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","- Ɗú kelohin woꞌu an: «Waaraa ɓaa en fiiliifu, fu saŋ ɓaa waaꞌtii garaa kihot»; ");
INSERT INTO snf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","wayee mi, mi woꞌꞌúu an: Waarat ɓuwii waarussii garúu kihotɗa ee ɓuwii hatallúu ga kipesɗa, ɗú kíimɗiɓa Kooh. ");
INSERT INTO snf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɗú tumkanaa, ɗú hay kiꞌen towutii Paamudiigarúu en ga ɗookɗa. Ndaga nohiigari ya oninwa ɓuwii joffii na ɓuwii jofinɗa. Ya towi ga ɗook ɓuwii júwinɗa na ɓuwii júɓpiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Binaa en lak ɗú waaꞌ ɓuwii waaꞌtúuɗa rekaa, neehalii wiida wërí ɗú laakan ga iñaama? Iñaama, bi ga juuticii sah tumsinndi. ");
INSERT INTO snf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","En lak ɗú këñɗohi na ɓoꞌꞌúu dogaa, ɗú tum ya daama yiyëkíꞌ? Iñaama, bi ga yiifaꞌcii tumsinndi. ");
INSERT INTO snf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kon enat ɓuwaa matin, fodii dii Paammbúu yii ga ɗook matɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","- Binaa ɗú en na kitum iñii Kooh nakohɗanaa, abukat ga kiheel kihotuk bi tah ɗú tumika ga fíkíi ɓuwii ɓéeɓ. Enndiikanaa, ɗú laakanndii neehal wíinoo ga Paammbúu yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kon binaa fu en na kisarah ɓaa laakoonaa kaa típ han, kiwaaꞌ kiyéeguk, fodaa daa ɓuwaa ɓíinoo jófjófɗuki tumsi ga ɗuuƴ jaangu-yaawúuꞌcaa na mbedicaa, kiheel ɓuwaa ndamɓa. Mi woꞌꞌúuka ee kayoh; ɓa laasin neehalaagaɓa kumëeñíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wayee fu, binaa fu en na kisarah ɓaa laakoonaa, yah-segaagaraa hanat kiꞌínoh iñaa yah-ñaabaagaraa tumɗa, ");
INSERT INTO snf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","doonaa sarahaagaraa ɗaakuk, ee paamfu yii hotin ga iñaa ɗaakukinɗa, hayyaaka kiꞌík. ");
INSERT INTO snf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ee binaa ɗú en na kikíim Koohaa, kaa madat na ɓuwii ɓíinoo jófjófɗukiɗa. Ɓa waari kituuk ɓa kíimi Kooh ga ɗuuƴ jaangu-yaawúuꞌcii na sal-waascii doonaa ɓéeɓ hotɓa. Mi woꞌꞌúuka ee kayoh; ɓa laasin neehalaagaɓa kumëeñíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wayee fu, fu en na kikíim Koohaa, aasaa túuyaagaraa wëñ kiɗaakuk ga kaanfuɗa, fu laŋ halaa, fu kíim Paamudiigaraa. Ya yaa da, ga ɗekataa wiɗaakukíꞌwaama. En ɗanaa, Paamudiigaraa hotin ga iñaa ɗaakukinɗa hayyaaka kiꞌík. ");
INSERT INTO snf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","- Binaa ɗú en na kikíim Koohaa kaa madat na yiifaꞌcii, ɗú am ga kiwoꞌ rek ɗú ínohoo kilëehíꞌ. Ɓa fooŋ an ɓa yewin tiwoꞌaa Kooh tumiꞌɓa iñaa ɓa kíimɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kaa ëldúkohatɓa. Iñaa ɗú sooluk, balaa sah ɗú kíimmbi Kooh, Paamudiigarúunaa, lak ya ínohinndi haat. ");
INSERT INTO snf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kon ɗú jom kikíim Kooh anee: «Paammbíi yii ga ɗookɗa, ɓéeɓ ɓuwii ínohat kiselaꞌkii teekiigaraa, ");
INSERT INTO snf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nguuriigaraa leꞌat dii, Iñaa fu waaꞌɗa laakat ga kakay, fodaa ka laak ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Onaaríi iñaa ɗí jom kiñam ga besii watiɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bayalaaríi baakaaꞌcii ɗí tumiɗa, fodaa ɗí ɓan, ɗí bayalin ɓuwaa tooñnjíiɗa. ");
INSERT INTO snf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ee kaa íissíi ɗí keen ga fíꞌ Seytaani, wayee músalaaríi ga sépíꞌíꞌ-ga-nofii, ndaga fu yërí laak kinguuruk, fu yërí laak kimín, fu yërí laak ndam, bi taaꞌ. Aameen.» ");
INSERT INTO snf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","En kiꞌenaa, binaa ɗú bayal ɓuwii iñcii ɓa tooñirúuɗanaa, Paammbúu yii ga ɗookɗa hayyúu kibayal ɓan. ");
INSERT INTO snf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wayee binaa ɗú bayallii ɓuwiinaa, Paammbúu yii ga ɗookɗa ɓan bayaloorúu baakaaꞌciigarúu. ");
INSERT INTO snf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","- Binaa ɗú en na kiꞌooraa, kaa súuñɗukat fodii dii ɓuwii jófjófɗuki tumsiɗa: ɓa api faancaagaɓa kiteeɓ ɓuwaa ɓéeɓ an ɓa oorin. Mi woꞌꞌúuka ee kayoh; ɓa laasin neehalaagaɓa kumëeñíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wayee fu, binaa fu en na kiꞌooraa, sëmúluka bi set, fu laꞌkoleñ hafaagaraa, ");
INSERT INTO snf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","doonaa fu teewoo ɓuwaa an fu en na kiꞌooꞌ. Paamudiigaraa hotin ga iñaa ɗaakukinɗa doŋ ínohanka. Ee Paamudiigaraa hotin ga iñaa ɗaakukinɗa hayyaaka kiꞌík. ");
INSERT INTO snf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","- Kaa nëgírohɗat haffúu alal ga ëldúna. Dii, maasoh na homaak míninwa kilaas, yasohwa, ee lokcii mínin kihay pook kaan, ɓayuwa. ");
INSERT INTO snf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Namat kinëgírohiꞌ haffúu alal ga ɗook, daa maasoh na homaak mínsoowa kiyasoh ee lokcii mínsoo kihay, pooku kaan, ɓa ɓaywa. ");
INSERT INTO snf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","En kiꞌenaa, daa alalfu enoh ɓéeɓ, keeñfu waa da ɓan. ");
INSERT INTO snf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","- Kuhas kërí en lampii faanfii. Kon binaa dara enndii na kuhasfunaa, faanfaagaraa tóohfa ƴah ga leeꞌlaat. ");
INSERT INTO snf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wayee binaa tuhastaagaraa mesikaa, faanfaagaraa ɓéeɓfa en ga ñúus. Kon binaa leeꞌlaatii en garaaɗa ñúusaa, waama ñúus hídan na kitërúus! ");
INSERT INTO snf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","- Ken mínoo kisúrgaꞌuk ga haꞌ-kaan ɓanak. Faw fu saŋ yíinoo, fu waaꞌ yaa tesɗa; wala fu taabuk yíinoo, fu foñluk yaa tesɗa. Ɗú mínoo kiꞌatukoh kitop Kooh na kitop hëelís. ");
INSERT INTO snf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","- Iñaama tah mi woꞌꞌúu an: kaa ɓítukat ga ñamahaa wala anahaa ɗú laakan sooli kipesoh wala yëerícaa ɗú laak sooli kiꞌekuk ga faanndúuɗa. Ndaga kipes kërí wëñ kilaak solu ñamah ee faan fërí wëñ yëerí kilaak solu. Enndii ɗee? ");
INSERT INTO snf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Malkat ga selii púdiɗa. Ɓa sokoo, ɓa píikoo, ɓa laakoo dap, ee Paammbúu yii ga ɗookɗa yii ñëmíꞌɓa. Enndii ɗú wëñ selii púdiɗa kilaak solu fúufe? ");
INSERT INTO snf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɓii yiida garúu mín kiɓaat iñaa hín na siñdaa jokon ga kipesci, bi ya ɓítuki ga coonucaagari? ");
INSERT INTO snf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kon iñii tahhúu kiɓítuk ya ga iñcaa ɗú ekukan? Malkat ga pëegíi-nduhumfii fimóríꞌfii ga ëgíriiɗa na ga dii fa kolukiɗa: fa lëgëyoo, fa foliloo. ");
INSERT INTO snf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wayee mi woꞌꞌúuka, bi ga buuꞌ Salomon na alalaagari tóoh, ya ekukkii kúltícaa hín kimoꞌ na wíinoo ga pëegíi-nduhumcii. ");
INSERT INTO snf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","En lak Kooh yërí móríꞌ fodaama pëegíi-nduhumfii fimóríꞌfii ga ëgírii wati, ee kuwisaa fa ƴah kijafu ga kiwii doŋɗanaa, wëñaa ga, ɗú ga kihaffúu, ya ekoorúu bi jofe? Ngëmiigarúu daal dooyyii! ");
INSERT INTO snf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kon kaa ɓítukat rek ga kiheel iñaa ɗú ñaman, na iñaa ɗú anan, na iñaa ɗú ekukan. ");
INSERT INTO snf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ɓéeɓ iñcuma ɓuwii ga ëldúna ee ínohsoo Koohɗa ɓërí tumi lëgëy kiheelca. Wayee, Paammbúu yii ga ɗookɗa ínohin an ɗú laakin sooli gaca. ");
INSERT INTO snf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Namat kiɗeɓ kiheel Nguurii Kooh na kitum iñaa ya nakohɗa. Ee iñaa tes ɗú laak sooli gaɗa, Kooh hayyúuri kiꞌeꞌ. ");
INSERT INTO snf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kuwis hanattúu kiɓít. Kuwis hay kihëwíꞌ hafwa, ndaga besaa en ɓéeɓ coonufaa gaɗa dooyin ga. ");
INSERT INTO snf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","- Kaa attiꞌat ken, en ɗanaa Kooh attiꞌoorúu. ");
INSERT INTO snf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","En kiꞌenaa, Kooh attiꞌanndúu fodaa ɗú attiꞌi ɓimooroommbúuɗa. Ee nataa ɗú natoh ɓuwiiɗa, wërí ɗú natohohsan. ");
INSERT INTO snf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iñii tah ya fu malaki ɓolaa en ga kuhaskaa mooroomfu, ee fu mínoo sah kimalaksukoh dúuñii ga kuhaskiigaraaɗa. ");
INSERT INTO snf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fu yii fu ɓay dúuñ ga kuhaskiigaraaɗa, fu mín na kiwoꞌ mooroomfu an: «Íisa mi nísíꞌtaa ɓolii en ga kuhaskiigaraaɗa»? ");
INSERT INTO snf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fu yii fu jófjófɗuki ga fíkíi ɓuwiiɗa, ɗewaa kinís dúuñii ga kuhaskiigaraaɗa, en ɗanaa fu hay kihot dijófíꞌ bi fu mín kinís ɓolaa ga kuhaskaa mooroomfuɗa. ");
INSERT INTO snf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kaa jafɗat baaycaa iñaa setin ga fíkíi Kooh enndiikanaa ɓa mínin kimëeñsuk ga ɗookkúu ɗowussúu. Ee ɓan kaa weesat siimii-pemiciigarúu ga fíkíi mbaamcii, enndiikanaa, ɓa ƴahca kitogisoh doŋ. ");
INSERT INTO snf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","- Kíimat, Kooh hayyúu kiꞌon. Heelat, ɗú hay kihot. Fëekírat, ɗú hay kilëgísɗu. ");
INSERT INTO snf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","En kiꞌenaa, ɓaa kíim ɓéeɓ, onu; ɓaa heel ɓéeɓ, hot; ee ɓaa fëekíꞌ ɓéeɓ, hay kilëgísɗu. ");
INSERT INTO snf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ɓii yiida garúu eran kowukaagari atoh binaa ka kíimmbi mbúurúnaa? ");
INSERT INTO snf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wala ya eꞌka goŋ binaa ka kíimmbi jënaa? ");
INSERT INTO snf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kon dii ɗú hín kibonɗa, en lak ɗú ɓërí mín kiꞌon towutaagarúu enaama cijófíraa, wëñaa ga Paammbúu yii ga ɗookɗa. Ɓuwaa kíimmbi enaama cijófíꞌɗa, ya onooɓacane? ");
INSERT INTO snf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kon ɓéeɓ iñaa ɗú waaꞌ ɓimooroommbúu tumiꞌtúunaa, ɗú ɓan tumɗatɓari. Waasii Móyíis na iñcaa sëldíiga-Koohcaa woꞌɗa, nakohu iñaama. ");
INSERT INTO snf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","- Aasohat halaa wiƴínwaa. En kiꞌenaa, halaa ëewdoh ɓoꞌ ga kisaŋkuꞌɗa agin, ee waasaa aaw gaɗa newin kitaaboh. Yewinin ɓuwaa taam ga waasaama. ");
INSERT INTO snf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wayee halaa ëewdoh ɓoꞌ ga kipeskaa leehoo taaꞌɗa hatin, ee waasaa aaw gaɗa newoo kitaaboh. Yewinndii ɓuwaa mínwa kihot. ");
INSERT INTO snf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","- Watukat haffúu ga ɓuwii tík hafɓa ɓisëldíiga-Kooh ee lak sabohɗa. Ɓa hay garúunaa, ɓa teewoh kiɗooy en fan baal, ee lak ga ɗuuƴ keeñcaagaɓa, ɓa iñcaa ɓigumuu ɓisóotíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ɗú ínohsohanɓa ga tumeencaagaɓa. Ɓoꞌ mínan na kiɓeen kowu reseŋ ga pëegíi-ñaawaaɓ wala kowu een ga kaꞌkaꞌ? ");
INSERT INTO snf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kedik kijófíꞌkaa en ɓéeɓ lími towu timóríꞌ, wayee kedikkaa ɗúukoolin lími towutaa moroo. ");
INSERT INTO snf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kedikkaa jofin mínoo kilím towutaa moroo, ee kedikkaa ɗúukoolin mínoo kilím towu timóríꞌ. ");
INSERT INTO snf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kedikkaa límmbii towu tijófíꞌ ɓéeɓ, hay kigúru, jafu ga kiwii. ");
INSERT INTO snf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kon fodaama, ɓuwaa tík hafɓa ɓisëldíiga-Kooh ee lak sabohɗa, ɗú ínohsohanɓa ga tumeencaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","- Enndii an ɓéeɓ ɓuwii ɓayiroo «*Haꞌmudii, Haꞌmudiiɗa» ɓërí aasan ga Nguuraa Kooh ga ɗookɗa; ɓii tumi iñii Paammboo yii ga ɗook waaꞌɗa ɓërí ƴah kiꞌaas. ");
INSERT INTO snf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Besaa Kooh ƴah kiꞌattiꞌoh ɓuwii leꞌ bëríinaa, hay kiyewin ɓuwaa woꞌanndoo an: «Haꞌmudii, Haꞌmudii, man ɗí yéegalohee woꞌeenaa Kooh ga teekiigaraa. Ɗí kaalla raɓcaa abee ɓuwaaɗa ga teekiigaraa. Ɗí tummba kíntaan ciyewin ga teekiigaraa!» ");
INSERT INTO snf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wayee mi hayɓa kilof an: - Mi mosoorúu kiꞌínoh, úsaayattoo, ɗú ɓii ɗú meerin kitum iñaa joffiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","- Kon ɓéeɓ ɓaa keloh woꞌeenii mi meyoh kiwoꞌɗa, ee ya taabukiwa ga tumeencaagarinaa, hay kimëdírohu na ɓoꞌ yiñëeñíꞌ yaa tawah kaanci ga atoh. ");
INSERT INTO snf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Toɓ wiyewin keennda bi ɓaalcaa líiffa. Wambalaa na uurisaa tapukka ga kaanfaama, fa ɓúꞌtii ndaga fa yípsee ga atoh. ");
INSERT INTO snf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wayee ɓéeɓ ɓaa keloh woꞌeenii mi meyoh kiwoꞌɗa, ee ya taabukkiiwa ga tumeencaagarinaa, hay kimëdírohu na ɓoꞌ yiñëkíꞌ-hel yaa tawah kaanci ga ɗook koleñ. ");
INSERT INTO snf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Toɓ wiyewin keennda bi ɓaalcaa líiffa, wambalaa na uurisaa tapukka ga kaanfaama, fa ɓúꞌta, ɓéeɓfa tassa tasar. ");
INSERT INTO snf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ga waa Yéesu lëehíꞌta kiwoꞌ iñcaama, ɓéeɓ ɓuwaa waaruꞌussa ga jëgírohaagari. ");
INSERT INTO snf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","En kiꞌenaa, ya madéeríi na jëgíroh-waascaa. Ndaga ya en kijëgírohaa, ya yërëmoo woꞌeenci. ");
INSERT INTO snf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Daa Yéesu yoosukee jaŋjagaa, mbooloo wiyaak taabukkari. ");
INSERT INTO snf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Laakka ɓaa ɓay ɗúukool-gaana, ya deeƴca gari, ƴíꞌꞌa ga fíkíici, woꞌꞌari an: - Haꞌmudii, fu waaꞌkanaa, fu míninndoo kiwëkíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yéesu lëríssa yahaagari, leꞌꞌa ga ɓaa, woꞌꞌari an: - Mi waarinka, waka! Ga saasi, ɓaa wakka ga ɗúukool-gaanaa. ");
INSERT INTO snf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lëehíꞌta Yéesu woꞌꞌari an: - Abukaa ga kiwoꞌ ɓoꞌ iñii mi tumiꞌtaaɗa, wayee kara, fu teewohnee haffu ga sarahohaa, ee fu tum sarahaa Móyíis nakoh ga kisetkiigaraaɗa. En ɗanaa, iñaama hay kiteeɓ ɓéeɓ an fu setin. ");
INSERT INTO snf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lak Yéesu yaa aas teeraa Kafarnawom, soldaaꞌ, yaa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñ, deeƴca gari, kíimmbari ");
INSERT INTO snf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","an: - Kiyaakii, súrgaagoo ɗúukoolin bi mínoo kikoluk, yaa faanukka ga kaan ee sodin lool. ");
INSERT INTO snf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yéesu woꞌꞌari an: - Mi hay kikaꞌ, mi wëkíꞌti. ");
INSERT INTO snf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɓaa woꞌꞌa Yéesu an: - Haꞌmudii, joobinndoo fu aas Kaanndoo, wayee woꞌaa woꞌeen wíinoo rek, súrgaagoo wak. ");
INSERT INTO snf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mi ga kihaffoo, mi laakin ɓuwaa hanohhoo ɗook, ee mi laakin soldaaꞌcaa hanohussoo kakay. Binaa mi woꞌ yii an karanaa, ya kaꞌ; mi woꞌ yíinoo an hayanaa, ya hay; ee binaa mi woꞌ súrgaagoo an tumaa iñii yiinaa, ya tummbi. ");
INSERT INTO snf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Daa Yéesu kelohee woꞌeencaama, ya waaruꞌꞌa ga soldaaraa yiyaakyaa. Ya woꞌꞌa ɓuwaa taabukeeriɗa an: - Mi woꞌꞌúuka ee kayoh; ga ɓu-Isarayeel, mi mossii kihot ken ɓaa laak ngëmaa hín na wii garoo. ");
INSERT INTO snf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ee mi woꞌꞌúu an ɓoꞌ ɓiyewin hay kimeyohu meyaaꞌ-noh na aasaaꞌ-noh, ɓa bok kanu na Abaraham, Ísaak na Yakoop ga Nguurii yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wayee ɓuwaa jomee kiꞌaas ga Nguurii yii ga ɗookɗa hay kijafu ga fooh ga ñúusaa, daa kikodukoh na kiꞌúñoh sís ƴah kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lëehíꞌta Yéesu woꞌꞌa soldaaraa yiyaakyaa an: - Tíida fu ƴee kaanfu, ka laakohat fodum fu gëmkaɗa. Ga wahtaama siiƴ, súrgaa soldaaraa wakka peleŋ. ");
INSERT INTO snf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Waa ennda ɗa, Yéesu kaꞌta kaan Peeꞌ, ya laak payam Peeꞌ yiɓeti yii ga ɗook fayaaŋ, ɗúukoolin ee faanfaa tamin jír. ");
INSERT INTO snf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yéesu ammbari ga yah, tamohlaataa faanfaa dalla kiƴím, lëehíꞌta ya kolukka, ya aawwa kitoputuꞌ Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ga noh-soosaa, Yéesu haydohɗussa ɓiɓoꞌ ɓiyewin ɓaa raɓ am. Ya kaalla raɓcaa na doolaa woꞌeenaagari ee ya wëkíꞌta ɗúukoolíꞌcaa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fodaama, iñaa Ísayíi, sëldíiga-Koohaa woꞌeeɗa matta. Ya woꞌee an: «Ya ɓewin ga hafci coonuciigaruu, ya koorukin ɗúukoolciigaruu.» ");
INSERT INTO snf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Daa Yéesu hotee mbooloomaa wíilinndi, ya ebilla tëelíbéecaagari an: - Ɗu paafat ɓakii giiyii hanoh gaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Laakka jëgíroh-waasaa deeƴ gari, woꞌꞌari an: - Jëgírohii, daa fu ƴah tóoh, mi hayyaa kitaabuk. ");
INSERT INTO snf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yéesu woꞌꞌari an: - Tílcii laakuunun ɗúl ee selcii ga asamaanɗa laakuunun taal, wayee Kowukii ɓii laakoo daa ka leeman hafiigari. ");
INSERT INTO snf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɓoꞌ yiliis ga tëelíbéecaagari woꞌꞌari an: - Haꞌmudii, onaaroo paaƴ mi kaꞌ kiꞌacnee paammboo. ");
INSERT INTO snf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wayee Yéesu woꞌꞌari an: - Taabukaaroo, fu íis ɓuwaa kaaninɗa ɓa ac ɓuwaagaɓa kaanɗa. ");
INSERT INTO snf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lëehíꞌta Yéesu aassa ga gaal-loocaa, tëelíbéecaagari taabussa nari. ");
INSERT INTO snf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Uuris wiyaak dalla kiyíp ga giiyaa bi dúuscaa caa ƴah kiꞌúul gaal-loocaa. Wiima lak Yéesu yii neeh. ");
INSERT INTO snf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tëelíbéecaa hayussa gari, yúudussari na tifiip an: - Haꞌmudii, somaaríi, kikaankii kii hayyuu! ");
INSERT INTO snf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yéesu woꞌꞌaɓa an: - Iñii tahhúu ya kiniik hínɗa? Ɗú daal ngëmiigarúu yëgíssii! Waa ennda ɗa, ya kolukka, gëtta uurisaa na giiyaa, tóoh ennda selew. ");
INSERT INTO snf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓa jaahliꞌꞌa lool, ɓa ɓaa woꞌ an: - Moo ɓii yii yërí en ɓa bi uurisii sah na giiyii tumsi ga iñaa ya nakohɗa? ");
INSERT INTO snf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ga waa Yéesu leꞌꞌa ɓakaa giiyaa Gëlílée hanoh gaa, ga kúlkaa Gadaraaɗa, ɓoꞌ ɓanak ɓaa raɓ am, meyohussa ga loycaa, gúꞌɗukohussari. Ɓuwaama namee kisoot hen bi ken kaañéeríi kikooroh waasaa waama. ");
INSERT INTO snf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓa aawwa kifiip an: - Fu naríi ya, fu Kowukii Kooh! Kitummbíi iñaa meskin haydohhaa dii ee wahtii leꞌꞌii duume? ");
INSERT INTO snf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wiima lak ga disam diꞌúsaayíꞌ laakin yop-mbaam-parki wiyaak waa en na kiníiru daama. ");
INSERT INTO snf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Raɓcaa am ɓuwaaɗa kíimussa Yéesu an: - En an fu ƴahhíi kikaal ɗí meyoh ga ɓuwii ɓiinaa, ekaaríi ga yop-mbaamaa wúunee! ");
INSERT INTO snf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yéesu woꞌꞌaɓa an: - Tíidat ɗú aas gaɓa! Raɓcaa meyohussa ga ɓuwaa, aasussa ga mbaamcaa. Ga saasi ɓéeɓ yopaa írkísukohha ɗook jaŋjagaa, wa keennda ga giiyaa, wa muuꞌta. ");
INSERT INTO snf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɓuwaa níiꞌsee yopaaɗa núpussa, aasussa teeraa, ɓa ɓéestíꞌta tóoh iñaa laakɗa, na iñaa dal ɓuwaa ɓanakɓaa raɓcaa abeeɗa. ");
INSERT INTO snf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Waa ennda ɗa, ɓéeɓ ɓu-teeraa meyussa kigúꞌɗukohnee Yéesu. Daa ɓa hoteeri, ɓa kíimmbari ya meƴ gohaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Waa ennda ɗa, Yéesu aassa gaal-loocaa, ya húusissa giiyaa Gëlílée, ya ɓoyukka teeraa ya dëkohɗa. ");
INSERT INTO snf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Daama ya haydohɗussa ɓaa lafañin ee faanuk ga ɗook gatan. Daa Yéesu hotee ngëmaagaɓa waama, ya woꞌꞌa lafañaa an: - Ƴaal, helfu dalat, baakaaꞌcumgaraa bayaluununndaa. ");
INSERT INTO snf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jëgíroh-waascaa ɓaa woꞌ ga ɗuuƴɓa an: - Ɓii yii ɓasin Kooh! ");
INSERT INTO snf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wayee Yéesu ínohha iñaa en ga helcaagaɓa, woꞌꞌaɓa an: - Iñii tah ya ɗú laak halaatcum cibóníꞌcuma ga helciigarúu? ");
INSERT INTO snf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kon iñii yiida wëñ kiyooɓ kiwoꞌ lafañii? Kiwoꞌꞌi an «Baakaaꞌcumgaraa bayaluununndaanoo», kiwoꞌꞌi an «Kolka fu tíin»? ");
INSERT INTO snf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wayee bi ɗú ínoh an ga ëldúna Kowukii ɓii onuunun kibayal baakaaraa, malkat: Ya woꞌꞌa lafañaa an: - Kolka, ɓewaa gataniigaraa, fu ƴee kaanfu! ");
INSERT INTO snf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɓaa kolukka, yaa ƴah kaanci. ");
INSERT INTO snf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Daa ɓuwaa hotee iñaama, ɓa dalla kitíit, ɓa ɓaa ndam Koohyii on ɓoꞌ-súusúus kimín kitum iñaa hínɗa kiyakɗa. ");
INSERT INTO snf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yéesu meƴca, yaa ƴah. Ya hotta ɓaa teeku Mëccëe, yugin ga daa ɓuwaa fayohi juutiɗa. Yéesu woꞌꞌari an: - Taabukaaroo! Mëccëe kolukka yaa taabuk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Laakka bes, Yéesu yuŋnga kiñam ga kaan Mëccëe. Juuti ɓiyewin na ɓiɓoꞌ ɓiliis ɓibóníꞌ, hayussa, bokussa na Yéesu kanu, ya na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fërísiyeeŋcaa hotussa iñaama, woꞌussa tëelíbéecaa Yéesu an: - Iñii tah ya jëgírohiirúu bok kiñam na juuticii na ɓuwii ɓibóníꞌɓii ɓii? ");
INSERT INTO snf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wayee Yéesu kelohhaɓa, loffaɓa an: - Ɓuwii dara gaa naɓaɗa enndii ɓa laak sooli ga payoh, wayee ɓuwii ɗúukoolɗa ɓërí laak sooli ga. ");
INSERT INTO snf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Karat, ɗú heel kiꞌínoh iñaa woꞌeenii wii waaꞌ kiwoꞌɗa: «yërmaandi wëñnjoo kineɓloh kisarahoh júuꞌ», ndaga mi hayyii ëldúna kiɓay ɓuwii tík hafɓa ɓiɓoꞌ ɓijúwíꞌɗa, wayee mi hay kiɓay haꞌ-baakaaꞌcii. ");
INSERT INTO snf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Waa ennda ɗa, tëelíbéecaa Saŋ hayussa ga Yéesu, ɓa meekissari an: - Iñii tah ya ɗí na Fërísiyeeŋcii ɗí oori ee tëelíbéeciigaraa ooꞌsoo? ");
INSERT INTO snf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yéesu loffaɓa an: - Ɓedohcaa haꞌ-kílookkaa, mínan na kiꞌen keeñɓa newoo ee lak haꞌ-kílookkaa yaa naɓa? Wayee bes waa hay, waa haꞌ-kílookkaa hay kiɓewohu ga leelooɓa; leꞌ bëríinaa, tëelíbéeciigoo hay kidalu kiꞌooꞌ. ");
INSERT INTO snf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ken daafoo píis wiꞌas ga líil-kúltí, ndaga píisaa wiꞌaswaa hay kiɓaydoh yen ga líil-kúltaa, wa tum ɗaraa wëñ kiyak. ");
INSERT INTO snf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ee ken tumoo biiñ wiꞌas ga mbúus-oncaa maañin. Enndiikanaa biiñaa lúudaa, mbúuscaa pook, biiñaa aamuk, mbúuscaa yasukoh. Biiñ wiꞌas kay tumsi ga mbúus-on ciꞌas, en ɗanaa ca ɓéeɓca ca mín kimaañ. ");
INSERT INTO snf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lak Yéesu yaa lís kiwoꞌ fodaama, ɓoꞌ yaa kuliyuk ga yaawúuꞌcaa hayya, ƴíꞌꞌa ga fíkíici, woꞌꞌari an: - Kowuroo kiɓeti han kikaan diima-diima, wayee hay fu tíkki yahciigaraa ee ka hay kipesis. ");
INSERT INTO snf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yéesu kolukka, yaa ƴah na ɓaa, ya taammba na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Laakka ɓetifaa daanee kimeƴdoh ñíf rek iñaa leꞌin tíkíis tidaaŋkaah na tanak; fa koorohha fenoo, leꞌꞌa ga pawaa kúltífaa Yéesu, ");
INSERT INTO snf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ndaga fa woꞌee ga helci an: «Binaa mi leꞌ rek ga kúltífaagarinaa, mi hay kiwak.» ");
INSERT INTO snf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yéesu heelukka, hottari, woꞌꞌari an: - Jowu, helfu dalat, ndaga ngëmumgaraa wëkɗinndaa. Ga wahtaama siiꞌ ɓetifaa wakka. ");
INSERT INTO snf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yéesu leꞌꞌa kaan ɓaa yaama kuliyuk ga yaawúuꞌcaaɗa, ya hotta mbiiwohcaa, ee lak coowaa ɓan ɗúukin pút ga mbooloomaa, ya woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","- Meyat fooh! Kuꞌoomaa-jowukii kaanndii, ja en na kineeh rek. Daama, ɓuwaa ɓaa ciiɓsukki. ");
INSERT INTO snf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ɓuwaa meƴdohussa fooh, lëehíꞌta Yéesu aassa túuyaa. Ya ammba yahaa kuꞌoomaa-jowukaa, ja kolukka. ");
INSERT INTO snf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iñaa hew yaama síwwa ga ɗuuƴ gohaama ɓéeɓwa. ");
INSERT INTO snf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yéesu meyohha daama, ya yaa ƴah. Laakka búumíꞌ ɓanak ɓaa taabukki ee ɓa ɓaa fiip an: - Kucaasamunkii Dëwít, yërëmaaríi! ");
INSERT INTO snf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga waa Yéesu leꞌꞌa kaanfaa, búumíꞌcaa hayussa gari, ya meekissaɓa an: - Ɗú gëmin an mi mínin kitum iñii ɗú kíimmbooɗane? Ɓa taassa an: - Ee, Haꞌmudii, fu míninka. ");
INSERT INTO snf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yéesu dalla kileꞌ ga tuhastaagaɓa, woꞌꞌa an: - Iñii ɗú kíimɗa laakat fodii ɗú gëmkaɗa. ");
INSERT INTO snf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tuhastaagaɓa dalla kilëgísuk, ɓa ɓaa hot. Lëehíꞌta Yéesu gëttaɓa, woꞌꞌaɓa an: - Watukat! Ken hanatka kiyéeŋ! ");
INSERT INTO snf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wayee daa ɓuwaa meyee, ɓa síwiꞌta teekaa Yéesu ga gohaama ɓéeɓwa. ");
INSERT INTO snf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ga wahtaa búumíꞌcaama meyu kiƴahɗa, Yéesu haydohɗussa ɓaa raɓ am, luuɓlukohhari. ");
INSERT INTO snf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yéesu kaalla rawaa, luuwaa aawwa kiwoꞌ. Ɓuwaa waaruꞌꞌa ga lool, ɓa ɓaa woꞌ an: - Iñaa man na yii, ken mosoori kihot ga Isarayeel. ");
INSERT INTO snf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wayee Fërísiyeeŋcaa ɓa woꞌee an: - Buurii raɓcii, yërí onndi dooli kikaal raɓcii ga ɓuwii. ");
INSERT INTO snf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yéesu yaa wíil ɓéeɓ teerucaa na dëk-kawcaa, ya yaa jëgíroh ga jaangu-yaawúuꞌcaa, ya yaa jangat ga loo Hewhewii winéwíꞌwii woꞌ ga loo Nguuraa Koohɗa. Ya yaa wëkíꞌ ɗúukoolcaa ɓuwaa ɓéeɓca na ɓéeɓ iñcaa mesik ɓuwaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Daa Yéesu hotee mbooloomaa enin nërëm ndaga coonu en fan baalcaa laaksoo níiroh, ya laakka yërmaandi wiyaak gaɓa. ");
INSERT INTO snf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ya dalla kiwoꞌ tëelíbéecaagari an: - Píikii yewinin ee píikohcii caakussii. ");
INSERT INTO snf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kon kíimat haꞌ-píikii ya ɓaat kiwosoh ɓilëgëyoh ga píikiigari. ");
INSERT INTO snf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Waa ennda ɗa, Yéesu ɓayya tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa, ya onndaɓa dooli kimín kikaal raɓ ga ɓuwaa na kiwëkíꞌ ɗúukoolcaa ɓuwaa ɓéeɓca na ɓéeɓ iñaa mesik ɓuwaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Teekcii apotaaꞌcii ɓidaaŋkaah na ɓanakɓii cërí cii: yaa ɗeɓɗa, Simoŋ yaa ɓaysi Peeꞌɗa, na Andari këmëeŋkíci, towutaa Sebedee: Saak na Saŋ këmëeŋkíci, ");
INSERT INTO snf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiip na Bartulëmíi, Toomaa na Mëccëe juutaa, Saak kowukaa Alfee, na Tadee, ");
INSERT INTO snf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ selootaa, na Yúdaa Iskariyot yaa onan Yéesu bíiŋɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɓuwaa ɓidaaŋkaah na ɓanakɓaama ɓërí Yéesu wosee, ya dígallaɓa an: - Kaa karat gohcaa ɓuwaa enussii yaawúuꞌ dëkohɗa ee kaa aasat teerucaa ga kúlkaa Samaríiɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Namat kikaꞌ ga ɓuwaa ga heetaa Isarayeel múuyuunun fodii ɓibaalɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Daa ɗú kooroh ɓéeɓ, yéegalohat an: «*Nguurii yii ga ɗookɗa deeyin, wii dii!» ");
INSERT INTO snf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wëkɗat ɗúukoolíꞌcaa, mílísɗat ɓuwaa kaaninɗa, sétírat ɓuwaa gaanaꞌinɗa, kaalat raɓcaa ga ɓuwaa. Ɗú onuunun ee ɗú meekisohussii dara ga, onohat ɓan ee kaa meekisohat dara ga. ");
INSERT INTO snf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kaa ɓaydohat dara ga poossúu, enndii wúrúus, enndii hëelís, enndii përëm. ");
INSERT INTO snf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kaa ɓaydohat dara ga ɓaawaagarúu, enndii hëmbu, enndii kúltí fisúmíyukaah, enndii ñafaꞌ, enndii dooꞌ, ndaga lëgëyohaa en ɓéeɓ jomin kiñam. ");
INSERT INTO snf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dëk-teeru wala dëk-kawaa ɗú mín kiꞌaas ɓéeɓ, meekisohat ati laakin ɓoꞌ yilëekíꞌ-haf yaa mínndúu kitook ga kaanci; ɗú dal ga kaanfaama bi ga daa ɗú kolukohan da. ");
INSERT INTO snf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɗú en na kiꞌaas kaanfaanaa, këñɗat ɓu-kaanfaa an: «Jam namohat narúu!» ");
INSERT INTO snf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Binaa ɓuwaa dëk ga kaanfaama tookussúunaa, jamaa ɗú kíimɗa yoosukat gaɓa, wayee ɓa tookkiirúunaa jamaa ɗú kíimɗa ɓoƴkat garúu. ");
INSERT INTO snf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ee kaan wala teeraa ɗú aasoh, binaa ɗú tookussii da ee woꞌeenndúu súkúrukussiinaa, meyohat kaanfaama wala teeraama, ɗú përtuk pëndëlaa ga kotcaagarúuɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mi woꞌꞌúuka ee kayoh; besaa ƴah kiꞌattiꞌohuɗa leꞌaa, ɓu-dëkaa Sodom na Gomooꞌ ɓërí taniꞌan ɓu-dëkaawaama attiꞌ. ");
INSERT INTO snf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","- Súkúrukat, mi yii wossúu fodii ɓibaal ga leeloo ɓigumuu. Kon taabat na kiteey fodii goŋ ee ɗú lewet fodii hoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Watukat haffúu ga ɓoꞌ-súusúus, ndaga ɓa hayyúu kiɓay paancaa ee ɓa hayyúu kitíp laawoo ga ɗuuƴ jaangucaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɗú hay kiɓayu ga fíkíi gúwernëeꞌcaa na ga fíkíi buuꞌcaa ndaga teekiigoo. En ɗanaa, ɗú en seedi ga fíkíiɓa na fíkíi ɓéeɓ heetcii ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Binaa ɗú ɓayu paancaanaa, helciigarúu dalat ga daa ɗú woꞌanɗa na iñaa ɗú ƴah kiwoꞌɗa. Iñcaa ɗú ƴah kiwoꞌɗa, ɗú eꞌsanca ga wahtaama siiƴ. ");
INSERT INTO snf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","En kiꞌenaa, enndii ɗú ɓërí ƴah kiwoꞌ wayee Helii meyoh ga Paammbúuɗa yërí ƴah kiwoꞌ kooroh túuwtiigarúu. ");
INSERT INTO snf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yaakmun hay kiꞌeroh këmëeŋkíci ya tíku kikaan. Paamun hay kiꞌeroh kowuci ka tíku kikaan. Oomaacaa hay kiɓeɓku keenu ga ɗook paamɓa na eewɓa, aplukɓa. ");
INSERT INTO snf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mi hay kitah bi ɓoꞌ ɓiyewin hayyúu kisagu. Wayee ɓaa fu guuꞌguuluk bi ga daa tóoh leehanaa, fu yaama fu hay kimúc. ");
INSERT INTO snf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Teeraa ɗú kaꞌ, ɗú hatalu ga kipessúu daamanaa, núpat, ɗú kaꞌ teeru wiliis. Mi woꞌꞌúuka ee kayoh; ɗú lëehɗoo kiwíil teerucii ga Isarayeelɗa ee Kowukii ɓii hayyii. ");
INSERT INTO snf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tëelíbée mínoo kipaaf ɓaa jëgíꞌtiɗa ee súrga mínoo kipaaf haꞌ-kaanci. ");
INSERT INTO snf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tëelíbée heelat kiman na ɓaa jëgíꞌtiɗa rek ee súrga heelat kiman na haꞌ-kaanci rek. En lak haꞌ-kaadii yërí ɓa ɓay Belsebulaa, wëñaa ga ɓu-kaanci, ɓa ɓaysan na? ");
INSERT INTO snf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","- Kon kaa niikat ken. Ndaga laakkii iñaa mín kiɗaakuk bi hotukoo ee laakkii iñaa ɓoꞌ mín kiɗaak bi meƴdohsoo faŋ. ");
INSERT INTO snf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iñaa mi woꞌꞌúu ga wek, ɓéestíratti ga noh taŋ ee iñaa ɗú mëedíru, yéegalohatti ga leeloo paancaa. ");
INSERT INTO snf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kaa niikat ɓuwaa mínu kiꞌap faan ee mínsoo kiꞌap fítɗa. Namat kiniik ɓaa mín kisaŋkuꞌ faan na fít ga safaraɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tudiindiiꞌ tanak toonohsirii dërëme? Moona déy, jíinoo gata keenoo kakay ee neɓpii Paamudiigarúu. ");
INSERT INTO snf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wayee ɗú, bi ga fenfii hafciigarúu sah, tóohfa kíduunun. ");
INSERT INTO snf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kon kaa niikat dara, ndaga ɗú, ɗú ɓërí wëñ solu tóoh diindiiꞌcii. ");
INSERT INTO snf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","- Ɓaa fu tookkoo ga fíkíi ɓuwiinaa, mi ɓan mi hayyaa kitook ga fíkíi Paammboo yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wayee ɓaa taasukkoo ga fíkíi ɓuwiinaa, mi ɓan, mi hayyaa kitaasuk ga fíkíi Paammboo yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","- Kaa foogat an mi haydoh jam ga ëldúna. Mi haydohhii jam wayee mi haydoh kihëgískoh. ");
INSERT INTO snf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi haydoh kihëgískoh ga díkaanti kowu kiƴaal na paamci, díkaanti kowu kiɓeti na eeci, díkaanti ɓeti na payamci yiɓeti. ");
INSERT INTO snf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɓoꞌ, ɓuwaa waaranndii gari kihotɗa, ƴah ɓu-kaanci. Yéesu woꞌꞌa tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","- Ɓaa wëñ kiwaaꞌ paamci wala eeci loo mi, ɓaama joobinndi ya en tëelíbéeroo. Ɓaa wëñ kiwaaꞌ kowuci kiƴaal wala kiɓeti loo mi, ɓaama joobinndi ya en tëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɓaa koorukkii kuraanaagari taabukiroonaa, ɓaama joobinndi ya en tëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɓaa fu waa kisom kumuunfunaa, fu hayka kiñak bi taaꞌ. Wayee ɓaa mi tahhaa kiñak kumuunfunaa, fu hayka kilaakis. ");
INSERT INTO snf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","- Ɓaa teꞌꞌúu ga kaancinaa lakanaa teꞌꞌoo, ee ɓaa teꞌꞌoo ga kaancinaa, teꞌ ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɓaa teꞌ sëldíiga-Kooh ga kaanci, ndaga kiꞌen sëldíiga-Koohkaa yaamanaa, ya hay kilaas neehalaa sëldíiga-Kooh jom kilaasɗa. Ee ɓaa teꞌ ɓoꞌ yijúwíꞌ ga kaanci ndaga kijúɓkaa yaamanaa, ya hay kilaas neehalaa ɓaa yijúwíꞌyaa jom kilaasɗa. ");
INSERT INTO snf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Luu enee kaas-músú wisóosíꞌ wíinoo doŋ, ɓaa fu onwa ɓoꞌ yíinoo ga tëelíbéeciigoo, yaa ínohoo dara, ndaga dii ya en tëelíbéerooɗanaa, mi woꞌꞌúuka ee kayoh, fu hay kilaas neehalaagaraa. ");
INSERT INTO snf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ga waa Yéesu lëehíꞌta kiwoꞌ tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa iñcaa ya nakɓa kitumɗa, ya kolukohha daama, yaa ƴah ga teerucaa ga gohaaɗa kijëgíroh na kiyéegaloh Hewhewaa winéwíꞌwaa. ");
INSERT INTO snf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ga waa Saŋ kelohha ga ɗuuƴ kasaa iñaa Kiristaa tumɗa, ya wossa ga tëelíbéecaagari, ");
INSERT INTO snf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kimeekis Yéesu an: - Fu yërí en ɓaa jom kihayɗanoo, ɗí sekan ɓoꞌ yiliis? ");
INSERT INTO snf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yéesu dalla ɓuwaa kitaas an: - Karat, ɗú ɓéestíꞌnee Saŋ iñcii ɗú kelohɗa na iñcii ɗú hotɗa: ");
INSERT INTO snf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","búumíꞌcii ɓii hot, lafañcii ɓii tíin dijófíꞌ, gaanacii ɓii sétíru, ɗekcii ɓii keloh, faraafcii cii mílís, ee nduulcii ɓii yéegalu Hewhewii winéwíꞌwii. ");
INSERT INTO snf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɓaa mi tahhiiraa kisoof fenoo ga ngëmaagaraanaa, fu yewinin múuꞌ! ");
INSERT INTO snf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tëelíbéecaa ɓanakɓaa, daa ɓa soofee, Yéesu aawwa ɓuwaa kiwoꞌ ga loo Saŋ, an: - Ɗú karee kimalaknee ya ga ëgíꞌ-dúndagaa? Pëegíi-përúudúufaa en na kiꞌeguk ga uurisaane? ");
INSERT INTO snf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Enndiikanaa, ɗú karee ya kimalaknee? Ɓoꞌ yaa ekuk kúltí cimóríre? Ee sah ɓuwii ekuk kúltí cimóríꞌɗa ɓii ga kaancii buuꞌcii. ");
INSERT INTO snf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kon ɗú karee kimalaknee ya daama? Sëldíiga-Koohe? Ee! Mi woꞌꞌúuka, ɓaama paafin sah sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Saŋ yërí en ɓaa woꞌu ga Këyítfaaɗa an: «Mi yii wos ɓoꞌꞌoo, yaa ɗëwrukanndaa, kiwaayukiꞌtaa waasum.» ");
INSERT INTO snf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mi woꞌꞌúuka ee kayoh; ga ɓuwii límukoh ga ɓetiɗa ɓéeɓɓa, mossii ga kilaak yíinoo yaa wëñ Saŋ-Bëtís kiyak; ee moona déy, ɓaa wëñ kijutuut ga Nguuraa yii ga ɗookɗa, yërí wëñ Saŋ-Bëtís kiyak. ");
INSERT INTO snf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Iñaa aboh ga jamaanaa Saŋ-Bëtís hayohɗa bi diima, Nguurii yii ga ɗookɗa wii soogu na dooli ee ɓuwii meeri kiꞌek dooli ga iñaa en ɓéeɓɗa ɓërí heelwa kiteꞌ, ɓa laakwa. ");
INSERT INTO snf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","En kiꞌenaa, ɓéeɓ sëldíiga-Koohcaa na Waasii Móyíis yéegalohseera Nguuriima bi ga daa Saŋ hayoh. ");
INSERT INTO snf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","En lak ɗú mínka kitookaa mi woꞌꞌúu man Saŋ yaama yërí en Ili, sëldíiga-Koohaa jomee kihayisɗa. ");
INSERT INTO snf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɓaa fu laakin nof kikelohaa súkúruka. ");
INSERT INTO snf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ɓuwii jamaanii wati, mi mëdírohanɓa naɓa? Ɓa man na oomaacaa yugu ga paanaa dëkaa ee ɓa woꞌ mooroomɓa an: ");
INSERT INTO snf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«Ɗí mbiiɓɗinndúu ee ɗú hammbii! Ɗí helemin ee ɗú dayukkii.» ");
INSERT INTO snf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","En kiꞌenaa, Saŋ-Bëtís hayin, ya ñamoo ee anoo fodii ɓuwii, ee ɗú woꞌ an: «Ya laak raɓ». ");
INSERT INTO snf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kowukii ɓii hayin, kii ñam, kii an, ee ɓa woꞌ an: «Malkat ɓii yii halaat kiñam doŋ na kiꞌan biiñ ee ya fiiliimunoh na juuticii na tumoh-baakaaꞌcii.» Wayee iñii kiñaañkii Kooh límiɗa, wërí teewohi an ka júwin. ");
INSERT INTO snf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Waa ennda ɗa, Yéesu keennda ga ɗook teerucaa ya wëñee kitumoh kíntaan ee ɓuwaa súpítséeríi kipeskaagaɓaɗa, ya yaa ñaꞌɓa an: ");
INSERT INTO snf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","- Massa ɗú ɓu-Korasee! Massa ɗú ɓu-Betsaydaa! Ndaga kíntaancii tumsee ga ɗuuƴcúuɗa, tumsee ga ɗuuƴ dëkaa Tíiꞌ na waa Sídoŋaa, eneenaa kumëeñíꞌ ɓa koorin ga saaku na wet kiteewoh an ɓa récukin baakaaꞌciigaɓa. ");
INSERT INTO snf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kërí tah mi woꞌꞌúu an besaa attiꞌohsanɗa leꞌaa, ɓu-Tíiꞌ na ɓu-Sídoŋ ɓërí taniꞌanndúu attiꞌ. ");
INSERT INTO snf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ee ɗú, ɓu-teerii Kafarnawom, ɗú yaakaaꞌ an ɗú hay kiɓëwíru bi ga ɗook-Koohe? Óꞌóo, ɗú ƴah kiyóoskíru bi ga ɓu-baam. En kiꞌenaa, kíntaancii tumu ga ɗuuƴcúuɗa, tumsee ga teeraa Sodomaa eneenaa wa wii lís bi wati. ");
INSERT INTO snf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kërí tah mi woꞌꞌúuka, besaa attiꞌohsanɗa leꞌaa, teeraa Sodom wërí taniꞌanndúu attiꞌ. ");
INSERT INTO snf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ga wahtaama, Yéesu woꞌꞌa an: - Buba, mi yii gërëmmbaa, fu, Haꞌmudii ɗook na kakay, ndaga iñaa fu ɗaak haꞌ-hamhamcii na ɓuwii jaginɗa, fu teewinwa oomaacii. ");
INSERT INTO snf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kayoh buba, iñaama laakohɗa, ndaga iñaama yërí fu waaꞌ ya laak. ");
INSERT INTO snf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Paammboo tíkin tóoh ga yahhoo. Ken ínohoo Kowukii enndii Paamudiinaa, ee ken ínohoo Paamudii enndii Kowukii na ɓuwaa Kowukii waaꞌɓari kiteeɓɗa naa. ");
INSERT INTO snf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hayat garoo ɓéeɓpúu ɗú ɓii ɗú sodin ee ɗú ɓítukohinɗa, mi onndúu íikaꞌ. ");
INSERT INTO snf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Koorukat iñii mi gallúuɗa, ɗú yoon garoo, ndaga mi yewinin jam ee mi yóoskírin haffoo, en ɗanaa fítciirúu laak íikaꞌ. ");
INSERT INTO snf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","En kiꞌenaa, iñii mi gallúuɗa yoowin ee ɗofiigoo mi kooꞌtúuɗa erefin. ");
INSERT INTO snf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ga bescaama, hídukoh ga bes Sabat, Yéesu kooree ga ɗuuƴ yooncaa lúudin. Lakanaa tëelíbéecaagari yaawuunun, ɓa aawwa kiweel ga boŋcaa, ɓa ɓaa ñam towutaa. ");
INSERT INTO snf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Laakka Fërísiyeeŋcaa hot iñaama, ɓa woꞌꞌa Yéesu an: - Malkaa tëelíbéeciigaraa! Ɓa ɓii tum iñaa Waasii kokohin kitum ga bes Sabat. ");
INSERT INTO snf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yéesu dallaɓa kilof an: - Hanaa ɗú jaŋngii iñaa buuꞌ Dëwít tumee bëríi lak ya yaawin ya na ɓuwaa taabee nariɗa? ");
INSERT INTO snf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ya aassa taalaa Kooh, ya ñammba naɓa ga mbúurúcaa meƴdohɗusee Koohɗa. Moona déy, ya na ɓuwaa taamsee nariɗa, waas onéeríi yíinoo gaɓa kiñam ga mbúurúcaama, sarahohcaa doŋ onuca kiñam. ");
INSERT INTO snf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wala book, hanaa ɗú jaŋngii ga Këyítfaa Waasaa Móyíis an, en ga bes Sabataa sarahohcaa hëyrohu kilëgëy ga Kaanfaa Koohɗa tumu iñaa hoonohu kitum ga besaamaɗa ee iñaama enoo tooñ gaɓa. ");
INSERT INTO snf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Moona mi woꞌꞌúu man laakin dii ɓaa wëñ Kaanfaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bíduunun ga Këyítfaa an: «Yërmaandi wëñnjoo kineɓloh kisarahoh júuꞌ». Binaa ɗú ínohee iñii woꞌeenuma waaꞌ kiwoꞌɗanaa, eneenaa ɗú daloo ga ɗook ɓuwaa tummbii dara yibóníꞌ. ");
INSERT INTO snf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","En kiꞌenaa, Kowukii ɓii kërí laak bes Sabat. ");
INSERT INTO snf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yéesu meyohha daama, aassa jaangu-yaawúuraagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wiima lak laakin daama ɓoꞌ yaa yahaa ɗooƴkin. Fërísiyeeŋcaa enee daamaɗa meekisohha Yéesu an: - Waasiigaruu onohin kiwëkíꞌ ɓoꞌ ga bes Sabate? Fodaama ɓa waaree iñaa ɓa yabohanndi. ");
INSERT INTO snf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yéesu taassaɓa an: - Yiida garúu, binaa ya laak baal yíinoo doŋ, ee baalaa keen ga noŋ wihóotíꞌ ga bes Sabataa, ya karoori kiꞌam meƴdohhi? ");
INSERT INTO snf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ee ɓoꞌ wëñ baal kilaak solu fúuf. Kon Waasii onohin kitumiꞌ ɓoꞌ iñaa jofin ga bes Sabat. ");
INSERT INTO snf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Waa ennda ɗa, Yéesu woꞌꞌa ɓaa yahaa ɗooƴkinɗa an: - Lërísaa yahiigaraa! Ɓaa lëríssa yahaagari, wa wakka, mannda na wíinoowaa. ");
INSERT INTO snf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fërísiyeeŋcaa dalla kimeyu, ɓa hídohha kimalak ga daa ɓa tuman bi ɓa apluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ga waa Yéesu ínohha an Fërísiyeeŋcaa ɓaa heelli kiꞌap, ya kolukohha daama. Mbooloo wiyaak taabukkari ee ya wëkíꞌta ɓéeɓ ɓuwaa ɗúukool gaɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wayee ya ɗíŋngaɓa na woꞌeen, kihoonohɓa kiwoꞌ ɓaa ya enɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iñaa laakohhaɗa, doonaa iñaa Ísayíi, sëldíiga-Koohaa woꞌeeɗa mat, ya woꞌee an: «Kooh woꞌ an: ");
INSERT INTO snf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","- Súrgiigoo mi tanukɗa yeema. Yii mi keeñuk ee yërí soos keeñnjooɗa. Mi hay kiyóoskíꞌ Heliigoo ga ɗookci, ee ya hay kiteeɓ heetcii ɓéeɓca iñaa en kijúɓɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ya heelanndii ñaroh na ken, ee ken kelohanndii koonaaci ga mbedicii. ");
INSERT INTO snf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ya weelanndii pëegíi-përúudúufaa leemukin, ee ya ƴímanndii kiwiikaa en na kiɗúuk. Ya tuman fodaama bi ga daa kijúɓ laakohan ndam ga ɗook ëldúna, ");
INSERT INTO snf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ee ɓéeɓ heetcii tíksan yaakaaꞌ gari.» ");
INSERT INTO snf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Waa ennda ɗa, Yéesu haydohɗussa ɓaa raɓ am, búumíꞌtari, luuɓlukohhari, Yéesu wëkíꞌtari bi ɓaa mínissa kiwoꞌ na kihot. ");
INSERT INTO snf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mbooloomaa waaruꞌꞌa ee ɓéeɓ ɓuwaa ɓaa woꞌ an: - Ɓii yii enndii kucaasamunkii Dëwít woꞌuɗane? ");
INSERT INTO snf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Daa Fërísiyeeŋcaa kelohsee iñaa woꞌu yaama, ɓa woꞌꞌa an: - Doolii Belsebul, buurii raɓcii, eꞌ ɓii yiiɗa, wërí onndi kimín kikaali raɓ ga ɓuwii. ");
INSERT INTO snf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yéesu ínohha iñaa en ga helɓaɗa, ya dallaɓa kiwoꞌ an: - Kúlkaa hëgískoh ga ɗuuƴka ɓéeɓ aaw ga kiɗúm. Teeru wala kaan hëgískoh ga ɗuuƴcinaa mínoo kituuk. ");
INSERT INTO snf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kon binaa Seytaani kaal Seytaaninaa, ya hëgískohin ga ɗuuƴci. Haa baanaa nguuraagari mínan na kituuk? ");
INSERT INTO snf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ee en an mi, Belsebul yërí onndoo dooli kikaal rawaa, haa ɓii on ɓuwiigarúu dooli kikaal raɓ ɓa? Kon ɓuwumgarúu, ga kihafɓa, ɓërí attiꞌanndúu. ");
INSERT INTO snf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","En kiꞌenaa, en an mi kaali raɓcii na Helii meyoh ga Koohɗanaa, kon Nguurii Kooh leꞌin bi garúu. ");
INSERT INTO snf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wala ɓan, ɓoꞌ mínan na kiꞌaas kaan ɓaa yaa na doolaagari gík, ya ɓeɓ iñaa yaama laakɗa ee ya ɗewohhii ga kiɓaŋngi paaƴ, doonaa ya han kimín kipook kaanfaa? ");
INSERT INTO snf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɓaa faꞌtii naroonaa, heñoh naroo, ee ɓaa nëgírohhii naroonaa, yii tasarsoh. ");
INSERT INTO snf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kërí tah mi woꞌꞌúuka, baakaaraa ɓoꞌ mín kitum tóoh na ɓaseenaa ɓoꞌ mín kiɓas Kooh tóoh, ya míninca kibayalu, wayee ɓaa fu ɓas Helaa yiselaꞌíꞌyaa ɓéeɓ, fu bayalsooka. ");
INSERT INTO snf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɓaa fu woꞌ iñaa moroo ga Kowukii ɓiinaa, fu míninka kibayalu, wayee ɓaa fu ɓas Helii yiselaꞌíꞌyii ɓéeɓ, fu bayalsooka bi taaꞌ: enndii dii ga ëldúnanii wii, enndii ga waa en na kihayɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","- Abat an kedik jofaa, líman towu tijófíꞌ, kedik ɗúukoolaa líman ɓan towutaa moroo. Kedik ínohohsan ga kowukaa ka límɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Túuk goŋ-saamaancii! Dii ɗú bonɗa moos, ɗú mínan na kiwoꞌ yijófíꞌ? En kiꞌenaa, iñaa meyi ga kúuw yërí líif ga keeñ haꞌci. ");
INSERT INTO snf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɓoꞌ yijófíꞌ meƴdohi enaama cijófíꞌ rek ga keeñaagari líif na yijófíꞌɗa; ee ɓoꞌ yibóníꞌ meƴdohi enaama cibóníꞌ rek ga keeñaagari líif na yibóníꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi woꞌꞌúu an: besaa attiꞌohsanɗa leꞌaa, ɓéeɓ ɓuwii hay kituuk kilayoh na Kooh ga ɓéeɓ woꞌeenaa ɓa mosin kiwoꞌ ee laakoo hafɗa. ");
INSERT INTO snf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","En kiꞌenaa, ɓaa en ɓéeɓ, ga woꞌeencaagaraa, fu eꞌsan kayoh ga wala fu tíku saboh. ");
INSERT INTO snf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Waa ennda ɗa, Laakka ɓijëgíroh-waas na ɓiFërísiyeeŋ ɓaa meekis Yéesu an: - Jëgírohii, ɗí waaꞌ kihot fu teeɓpíi kíntaanaa teewoh an fu meyoh ga Kooh! ");
INSERT INTO snf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yéesu taassaɓa an: - Ɓuwii jamaanii wati ɓibóníꞌɓii ee ooruunun Koohɗa, ɓa waaꞌ kihot kíntaan. Wayee kíntaan wíinoo tookɗusanndiiɓa enndii waa Sonaas, sëldíiga-Koohaanaa. ");
INSERT INTO snf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","En kiꞌenaa, fodaa daa Sonaas enee noh-noh kaahay na wek-wek kaahay ga lookaa jënaa yiyaakyaaɗa, fodaama Kowukii ɓii hay kiꞌen ga bos kakay noh-noh kaahay na wek-wek kaahay. ");
INSERT INTO snf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Besaa attiꞌohsanɗa leꞌ bëríinaa, ɓu-teeraa Níníf hay kituuku ga fíkíi ɓuwii jamaanii wati, ɓa ɓúlɓa, ndaga ɓu-Níníf súpítseera kipeskaagaɓa ga waa ɓa keloh jangataa Sonaasɗa; ee malkat, laakin dii ɓaa wëñ Sonaas. ");
INSERT INTO snf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Besaa attiꞌohsanɗa leꞌ bëríinaa, buuraa yiɓetiyaa kúlkoh iñaa hanoh meyaaꞌ-noh ñaamɗa hay kituuk ga fíkíi ɓuwii jamaanii wati, ya ɓúlɓa. Ndaga ya meyohee gohcaa ëldúna wëñ kiꞌúsaayɗa kisúkúruknee woꞌeencaa buuꞌ Salomon líif na hamhamɗa. Ee malkat, laakin dii ɓaa wëñ Salomon. ");
INSERT INTO snf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","- Binaa raɓ meyoh ga ɓoꞌaa, ya túuti ga ëgíraa ya heeli daa ya íikarukan, wayee waa ya hottii daa ya aasan, ");
INSERT INTO snf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ya woꞌ ga helci an: «Mi naman kiɓoyuk kaanfaagoo mi meyoheeɗa.» Binaa ya leꞌ danaa nak, ya laak kaanfaa lak ken gaa ga, paruunun bi setin, hëwíruunun bi jekin. ");
INSERT INTO snf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Fodaama, ya ƴee kikooꞌnee raɓ ɓiyitnaɓanak ɓiliis ɓaa wëñnji kisoot, ɓa aas ga kaanfaa, ɓa dëk ga. Faf ɓaa yaama, ga daa ya madee kuɗewaaɗa, wëñisɗa kiyiis. Ee ƴah kiman fodaama deŋ ga ɓuwii ɓibóníꞌ ɓii jamaanii wati. ");
INSERT INTO snf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lak Yéesu yaa lís kiwoꞌ na mbooloomaa, eeci na ɓikëmëeŋkíci leꞌussa, ɓa eemmba fooh ee ɓa soolukeeri.  ");
INSERT INTO snf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Laakka ɓaa yéegal Yéesu an: - Taasa, eefu na ɓikëmëeŋkífu ɓaa day ga fooh, soolukussaa. ");
INSERT INTO snf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yéesu taassa ɓaa an: - Ɓii yiida en eewwoo? Ɓuwii ɓiida en ɓikëmëeŋkíroo? ");
INSERT INTO snf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ya noonnda, kiteewoh tëelíbéecaagari, woꞌꞌa an: - Malkat, eewwoo na ɓikëmëeŋkíroo ɓeema. ");
INSERT INTO snf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ɓaa tumi iñaa Paammboo yii ga ɗook waaꞌɗa, ɓaa yaama yërí en këmëeŋkíroo yiƴaal wala yiɓeti wala eewwoo. ");
INSERT INTO snf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ga besaa bëríi, Yéesu meyohha kaanfaa ya enoheeɗa, kaꞌta yuŋneera ga seereenaa giiyaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mbooloo wiyaak wíillari bi faf ya nammba kiꞌaas ga gaal-looci ga ɗuuƴ giiyaa, ya yuŋnga ga. Ɓéeɓ mbooloomaa tuukka ga tewisaa. ");
INSERT INTO snf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ya woꞌꞌa naɓa enaama ciyewin ga liiwuk fodii liiwukii wii, an: - Enee línoh, ya kolukka yaa ƴah kisoknee. ");
INSERT INTO snf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ga daa ya en na kisokɗa, laakka tesohtaa keen ga yahaanaa waasaa: selcaa hayussa, ñamussata say. ");
INSERT INTO snf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Laakka tesohtaa keen ga ɗekataa yewinin atoh, daa yewinndii kakay. Tesohtaa gaawwa kipaal ndaga lak kakayfaa yewinndii daama. ");
INSERT INTO snf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wayee daa nohaa tamee, iñcaa paleeɗa neewwa, ca súɓpa ndaga níilcaagaca abéeríi. ");
INSERT INTO snf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Laakka tesoh tiliis taa keen ga ƴówée-lúp, ta paalla da. Lúpcaa yakka, onndata. ");
INSERT INTO snf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ee laakka tesohtaa keen ga ɗekataa laakin dooli. Ta ɓíríssa boŋ. Cii erohha iñaa leꞌin waas citéeméeꞌ ga tesohtaa sokseeɗa, cii cidaaŋkaah-yitniinoo, cii cidaaŋkaah-kaahay. ");
INSERT INTO snf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lëehíꞌta Yéesu tíkka ga an: - Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tëelíbéecaa deeyussa ga Yéesu, ɓa meekissari an: - Iñii tah ya fu woꞌꞌa na ɓuwaa ga liiwuk? ");
INSERT INTO snf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yéesu taassaɓa an: - Ɗú ɓërí eꞌsee kiꞌínoh kúmpacaa Nguuraa yii ga ɗookɗa. Wayee ɓa, ɓa erussiika. ");
INSERT INTO snf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","En kiꞌenaa, ɓaa laakin, hay kiɓaatɗu bi ya dóoyíꞌ sëk. Wayee ɓaa laakoo, kiꞌiñkaa ya ɓayɗa sah, hay kiteꞌu. ");
INSERT INTO snf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iñii yii yërí tah mi woꞌi naɓa ga liiwuk: ɓa malakin ee ɓa hotoo, ɓa súkúrukin ee ɓa kelohoo, ɓa ínohoo. ");
INSERT INTO snf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fodaama iñaa Ísayíi, sëldíiga-Koohaa woꞌeeɗa matta gaɓa. Ya woꞌee an: «Ɗú hay kikeloh dijófíꞌ wayee ɗú ínohanndii dara. Ɗú hay kimalak dijófíꞌ wayee ɗú hotanndii dara. ");
INSERT INTO snf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","En kiꞌenaa, heetii wii súwin ga keeñ, ɓa lagin nofciigaɓa paraas, ɓa ɗúugin nap, en ɗanaa hasɓa hotoo, nofɓa kelohoo, ee helɓa aboo dara, bi ɓa súpít kipeskiigaɓanaa, mi wëkíꞌɓa.» ");
INSERT INTO snf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wayee ɗú, ɗú ɓërí yewin múuꞌ: hasciigarúu hotin ee nofciigarúu kelohin! ");
INSERT INTO snf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mi woꞌꞌúuka ee kayoh; yewinin ɓisëldíiga-Kooh na ɓiɓoꞌ ɓijúwíꞌ, ɓaa waaꞌseera lool kihot iñcii ɗú hotɗa ee hotussiica. Ɓa waareera kikeloh iñcii ɗú kelohɗa ee kelohussiica. ");
INSERT INTO snf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yéesu woꞌꞌa an:- Kon ɗú, súkúrukat iñii liiwukii sokohii waaꞌ kiwoꞌɗa: ");
INSERT INTO snf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɓuwii kelohin loo Nguurii Kooh ee ínohsooɗa madu na seereenaa waasaa tesohtaa sokohuɗa: sépíꞌíꞌ-ga-nofaa hayaa nís Woꞌeenaa soku ga keeñɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɓíinoo madu na ɗekataa yewinin atoh pesohpaa sokohuɗa: ɓa keloh Woꞌeenii Koohaa, ɓa dallawa kiteꞌ na keeñ wisóosíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wayee ɓa úsaayoo ga ndaga Woꞌeenaa Kooh yíppii níil ga keeñcaagaɓa. Fodaama, binaa ɓa en ga coonu wala ɓa sodalu ga kipesɓa ndaga Woꞌeenii Koohaa, ɓa gaaw kigúroh nawa. ");
INSERT INTO snf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɓíinoo ɓan madu na ƴówée-lúpaa pesohpaa sokohuɗa: ɓa kelohin Woꞌeenii Kooh, wayee halaat ëldúna na kiwaaꞌ kihëpíꞌkaa aaw ga alal on Woꞌeenii Kooh bi wa mínoo kilím yen. ");
INSERT INTO snf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓuwii ɓíinoo tesɗa madu na ɗekataa kakayfaa laakin dooli pesohpaa sokohuɗa: ɓa keloh Woꞌeenii Koohaa, ɓa ínoh iñaa wa waaꞌ kiwoꞌɗa. Ɓa límíꞌ Kooh jeriñ, ɓa tum bi pesohpaa meƴdoh: pii towu titéeméeꞌ, pii towu tidaaŋkaah-yitniinoo, pii towu tidaaŋkaah-kaahay. ");
INSERT INTO snf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yéesu woꞌissaɓa liiwuk wiliis an: - Nguurii ga ɗookɗa man anee: Enee ɓoꞌ, ya sokka pesoh pijófíꞌ ga yoonci. ");
INSERT INTO snf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Laakka ɓaa waaꞌtii gari kihot hayya ga wek, lak ɓéeɓ ɓuwaa neehuunun, ya sokka pëegíi-jëm ga yoon-tohoonaa, yaa paaf kotci. ");
INSERT INTO snf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Daa tohootaa kolukee bi ta ɓíríssa, jëmfaa ɓan hannda kihotuk. ");
INSERT INTO snf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Daa súrgacaa hotee pëegíi-jëmfaa, ɓa kaꞌta ga haꞌ-yoonaa, ɓa woꞌꞌari an: «Kiyaakii, hanaa fu sokéeríi pesoh pijófíꞌ ga yoonfu? Kon tum na pëegíi-jëmfii en ga ɗuuƴgii?» ");
INSERT INTO snf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Haꞌ-yoonaa taassaɓa an: «Ɓaa waaꞌtii garoo kihot yërí tum iñaama.» Súrgacaa meekisussari an: «Eneenaa ɗí karoo ɗí ɗoffane?» ");
INSERT INTO snf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Haꞌ-yoonaa taassaɓa an: «Óꞌóo, mi niik ɗú en na kiɗof jëmfaanaa, ɗú kiɓaydoh tohootaa ga. ");
INSERT INTO snf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Íisatca bi kipíik leꞌ. Kipíik leꞌaa, mi hay kiwoꞌ píikohcaa an: ɗewat kiɗof jëmfum, ɗú pokfa ɗof, ɗú tëkíꞌfa. Lëehíraa ɗú ɗapiꞌtoo tohootum ga dapaagoo.» ");
INSERT INTO snf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yéesu woꞌissaɓa liiwuk wiliis an: - Nguurii ga ɗookɗa man na kowu fúdan, kaa ɓoꞌ ɓeɓ sokkaka ga yoonci. ");
INSERT INTO snf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kërí wëñ kijutuut ga tesohtii, wayee ka paalaa, kërí wëñ kiyaak ga tediktii línsi ga dëꞌɗa. Ka en kedik bi selcaa hayaa taal ga toytaa ka laakɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yéesu woꞌissaɓa liiwuk wiliis an: - Nguurii ga ɗookɗa man na moloŋ-kuunaa kaañohin, ɓeti ɓeɓ, tumwa ga ɗuuƴ kanu kuun, íiswa ga bi ga daa kuuncaa ɓéeɓ kaañohan. ");
INSERT INTO snf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iñcaama ɓéeɓca Yéesu woꞌꞌaca mbooloomaa ga kiliiwuk. Ya woꞌéeríi na ɓuwaa ga iñaa enndii liiwuk. ");
INSERT INTO snf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","En ɗanaa, iñaa sëldíiga-Koohaa woꞌeeɗa mat. Ya woꞌee an: «Mi woꞌan naɓa ga liiwuk na liiwuk. Mi hayɓa kiyéegal iñcaa ɗaaku, ga iñaa ëldúna saksee bi wati.» ");
INSERT INTO snf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Waa ennda ɗa, Yéesu tagohha na mbooloomaa, ya ɓoyukka kaan. Daama, tëelíbéecaagari hayussa gari, woꞌussari an: - Lëegísohɗaaríi liiwukaa woꞌ ga loo pëegíi-jëmfaa ga yoonaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yéesu taassaɓa an: - Ɓaa sok pesohpaa pijófíꞌpaaɗa yërí en Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yoonaa wërí en ëldúna. Pesohpaa pijófíꞌpaa ɓërí en ɓuwii boku ga Nguuraa Koohɗa. Pëegíi-jëmfaa fërí en ɓuwii taam na sépíꞌíꞌ-ga-nofiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɓaa waaꞌtii kihot ga haꞌ-yoonaa ee sok pëegíi-jëmfaaɗa, yërí en Seytaani. Píikaa wërí en túkiꞌaa ëldúna, ee píikohcaa ɓërí en malaakacaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Fodaa daa jëmfaa ɗofu, jafussa ga kiwiikaaɗa, ëldúna túkiꞌaa ƴah kiman fodaama. ");
INSERT INTO snf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ee bëríinaa, Kowukii ɓii hay kiwos malaakacaagari ɓa meƴdoh ga Nguuriigari ɓéeɓ ɓuwii eki ɓimooroomɓa ga kitum baakaaꞌɗa na ɓuwii meeruunun kitum iñaa joffiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Lëehíraa ɓa jafɓa ga kiwiikaa safara, daa kikodukoh na kiꞌúñoh sís ƴah kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wayee ɓuwii júwinɗa, hay kimelicu fodii nohii ga ɗuuƴ Nguuraa Paamɓa. Ɓaa fu laakin noh kikelohaa, súkúruka. ");
INSERT INTO snf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","- Nguurii ga ɗookɗa man anee: fodii ɓoꞌ yaa hot alalaa ɗaaku ga ɗuuƴ yoon; ya ɓeɓpawa, ɗaakissawa. Keeñci soossa ga bi, ya kaꞌta, toonneera iñaa ya laak ga alalɗa tóoh, ya lommba yoonaama. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","- Ee ɓan, Nguurii ga ɗookɗa man anee: fodii toonohaa raas pemi cimóríꞌ. ");
INSERT INTO snf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Daa ya hotee yarak pemi wiséeríꞌ, ya kaꞌta toonneera iñaa ya laak ga alalɗa tóoh, ya lommba yarak pemaama. ");
INSERT INTO snf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","- Ee ɓan, Nguurii ga ɗookɗa man anee: fodii mbaal-jënaa weesu ga giiƴ, waa am heet jënaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Binaa mbaalaa líifaa, mbaalohcaa nookwa tewisaa, ɓa yuŋ, tanu jëncaa: ɓa nëgíroh jëncaa cijófíꞌcaa ga pañi ee ɓa jaf caa laakoo jeriñɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bëríinaa ëldúna túkiꞌanɗa leꞌaa, ƴah kiman fodaama deŋ: malaakacaa Kooh hay kihayu, ɓa hëgísoh ɓuwii joffiiɗa ga ɓuwii júwinɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓuwii joffiiɗa, ɓa jafu ga kiwiikaa safara, daa kikodukoh na kiꞌúñoh sís ƴah kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iñcuma tóohca leerin ga hafcumgarúune? Tëelíbéecaa taassa an: - Ee, leerin! ");
INSERT INTO snf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yéesu tíkíꞌtaɓa ga an: - Kërí tah ɓéeɓ jëgíroh-waas, yaa en tëelíbée ga Nguurii yii ga ɗookɗa, man na haꞌ-kaadaa meƴdohi ga ɗaakaaꞌ alalaagari enaama ciꞌas na enaama cimëeñíꞌ, ya onoh. ");
INSERT INTO snf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ga waa Yéesu lëehíꞌta kiwoꞌ liiwukcaa caama, ya meyohha daama, ");
INSERT INTO snf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ya kaꞌta teeraa ya dëkohɗa, ya yaa jëgíꞌ ɓuwaa ga jaangu-yaawúuraa daamaɗa. Ɓéeɓ ɓuwaa súkúrukeeriɗa jaahliꞌussa ga lool bi ɓaa woꞌ an: - Ya ɓewohnee hamhamii wii na kíntaancii ya tumiɗa gada? ");
INSERT INTO snf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hanaa enndii kowukii daayoh-haŋngii? Ati enndii Mariyaama en eeci ee Saak, Yoseef, Simoŋ na Yúdaa enu ɓikëmëeŋkíci? ");
INSERT INTO snf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ee ɓikëmëeŋkíci ɓiɓeti enussii ɓéeɓɓa ga ɗuuƴcuune? Iñcii ya mín cii tóohca ya ɓewohca gada? ");
INSERT INTO snf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Fodaama ɓa eewwari bi ɓa gëmmbii gari. Yéesu nak woꞌꞌaɓa an: - Sëldíiga-Kooh waaruunun ga daa en ɓéeɓ bi tessa dëkaa ya meyohɗa, na mbokcaagari. ");
INSERT INTO snf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yéesu tummbii kíntaan ciyewin daama ndaga daa ɓa gëmmbii gariɗa. ");
INSERT INTO snf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Waama, Eroot, buuraa gohaa Gëlílée kelohha iñaa woꞌu ga Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ya woꞌꞌa súrgacaagari an: - Ɓaa yaama, Saŋ-Bëtís yërí. Ya mílís hen ga ɓuwaa kaaninɗa, iñaama yërí onndi dooli kimín kitum kíntaan. ");
INSERT INTO snf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","En kiꞌenaa, Eroot yërí amlukee Saŋ-Bëtís, ɓaŋlukkari, laŋngari ga kasu. Ee Erojaas, ɓeti këmëeŋkíci Filiip, yërí tahee Eroot kitum iñaama. ");
INSERT INTO snf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Saŋ nak woꞌeeri an: - Waas onndiiraa kiɓeɓ Erojaas ya en ɓetifu! ");
INSERT INTO snf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroot waaꞌta kiꞌapluk Saŋ-Bëtís, wayee ya niikka mbooloomaa, ndaga ɓa tíkee Saŋ sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bëríi lak Eroot en na kihúmbal besaa ya límohuɗa. Kowukaa Erojaas kiɓetikaa hammba ga fíkíi sagaccaa. Hamaa neɓpa Eroot lool ");
INSERT INTO snf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","bi tahha ya waatta an iñaa oomaanaa kíimmbi ɓéeɓ, ya hayyiri kiꞌon. ");
INSERT INTO snf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oomaanaa nak, eeci dígallari, ya meekissa buuꞌ Eroot an: - Haydohɗaaroo hafaa Saŋ-Bëtís dii ga ɗook palaat! ");
INSERT INTO snf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Keeñaa buuraa leehha tak ga iñaama. Wayee waa ya laasinka kiwoꞌ ga fíkíi ɓuwaa ya nakee hewaaɗa, ee ya waatinkaɗa, ya nakohha an wa eꞌsat oomaanaa. ");
INSERT INTO snf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ya wossa ɓoꞌ kasaa kigúꞌnee hafaa Saŋ. ");
INSERT INTO snf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hafaa Saŋ haydohussa ga palaat, wa erussa oomaanaa, yaama ɓayneerawa ga eeci. ");
INSERT INTO snf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Waa ennda ɗa, tëelíbéecaa Saŋ-Bëtís hayussa kiɓeɓ faraaffaagari, acsuneerafa, lëehíꞌta ɓa kaꞌta, ɓa woꞌneera Yéesu iñaa laakɗa. ");
INSERT INTO snf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Daa Yéesu yéegee kaanaa Saŋ-Bëtís, ya kolkohha daama, ya aassa ga gaal-looci, yaa ƴah daa wéetin. Ɓuwaa yéeŋngaka. Ɓa ɓaa meyoh ga dëkcaa ga yahaanaaɗa, ɓa taabohha na seereenaa giiyaa, ɓaa taabukki na kot. ");
INSERT INTO snf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Daa Yéesu yoosukee ga gaal-loocaa, ya hotta mbooloo wiyaak, ya laakka yërmaandi gaɓa, ya aawwa kiwëkíꞌ ɗúukoolíꞌcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ga waa nohaa soossa, tëelíbéecaa deeyussa gari, woꞌussari an: - Ɗekatii laakoo dara ee Kooh hoowin. Íisaa ɓuwii ɓa aas dëk-kawcii ɓa lomnee iñaa ɓa ñaman. ");
INSERT INTO snf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wayee Yéesu woꞌꞌaɓa an: - Calooɓa kikaꞌ, eratɓa na kihaffúu iñaa ɓa ñaman! ");
INSERT INTO snf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓa woꞌꞌari an: - Ɗí laak mbúurú ciyëtúus na jën kanak doŋ dii. Yéesu woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","- Haydohɗattooca gii. ");
INSERT INTO snf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Waa ennda ɗa, Yéesu woꞌꞌa ɓuwaa ɓa yuŋ kakay ga pëegíifaa. Ya ɓeɓpa mbúurúcaa ciyëtúuscaa na jëncaa kanakcaa, ya taaginukka ɗook, ya gërëmmba Kooh gaca. Lëehíꞌta ya gúꞌsohhaca, ya eꞌta tëelíbéecaa ɓa waroh ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓuwaa ɓéeɓɓa ñammba bi ɓa kappa pút, ee iñaa teseeɗa ɓa líifíꞌta ga pañi cidaaŋkaah na kanak. ");
INSERT INTO snf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓuwaa ñameeɗa leꞌin ƴaal ɓijúnni-yëtúus ee ɓeticaa na oomaacaa kídussii ga. ");
INSERT INTO snf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ga waa iñaama paaffa, Yéesu dalla kituukuk tëelíbéecaa ɓa aas ga gaal-loocaa, ɓa ɗëwírukki ɓakaa giiyaa hanoh gaaɗa; hídinaa, ya ga kihafci ya tagoh na mbooloomaa. ");
INSERT INTO snf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Waa ya tagohha na mbooloomaa, ya lappa ɗook jaŋjagaa, ya wéetta da, yaa kíim Kooh. Wekaa laakki ya tes haŋci daama. ");
INSERT INTO snf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wahtaama, lak gaal-loocaa tëelíbéecaa úsaayin ga ɗuuƴ giiyaa. Wa mínsiséeríi kiꞌaaw fíkíi ndaga dúuscaa giiyaa tapukee gawaɗa, ee wa jaanohee na uurisaa. ");
INSERT INTO snf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lak leeloo wek paafin ee Kooh wíissii duum, Yéesu yaa tíin ga ɗook músúmaa giiyaa, yaa hay gaɓa. ");
INSERT INTO snf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Daa tëelíbéecaa hoteeri yaa tíin ga giiyaa, ɓa tíitta lool. Ɓa ɓaa woꞌ an: - Iñii jíni! Ɓa niikka, ɓa ɓaa fiipoh. ");
INSERT INTO snf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yéesu nak gaawwa naɓa kiwoꞌ an: - Yëgísɗat fítciigarúu. Ɓii mi, kaa niikat! ");
INSERT INTO snf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Waa ennda ɗa, Peeꞌ woꞌꞌari an: - Haꞌmudii, en lak fu yërí kayoh-kayohaa, nakaaroo mi tíin ga ɗook músúmii, mi hay garaa. ");
INSERT INTO snf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yéesu woꞌꞌari an: - Hay! Peeꞌ dalla kiyoosuk ga gaal-loocaa, ya yaa tíin ga ɗook músúmaa, yaa ƴah ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wayee daa Peeꞌ hotee doolaa uurisaa, ya niikka. Faf ya yaa muuꞌ, ya fiippa an: - Haꞌmudii, foola! ");
INSERT INTO snf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yéesu gaawwa kilërís yah, ammbari, woꞌꞌari an: - Ngëmiigaraa daal dooyyii! Iñii tahhaa kilaak hel kanak ya? ");
INSERT INTO snf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lëehíꞌta, ɓa aassa ɓa ɓanak ga gaal-loocaa, uurisaa dalla kituuk. ");
INSERT INTO snf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tëelíbéecaa enee ga gaal-loocaaɗa ƴíꞌussa ga fíkíi Yéesu, woꞌussari an: - Fu yërí en Kowukii Kooh kayoh-kayohɗa. ");
INSERT INTO snf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waa ennda ɗa,Yéesu na tëelíbéecaagari lëehɗussa kihúus giiyaa na gaal-looci, ɓa teeꞌta ga kúlkaa Genesareet. ");
INSERT INTO snf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓuwaa dëk daamaɗa ínohsohussa Yéesu, ɓa yéegalohha hayaagari ga iñaa wíil gohaama tóohɗa, ee ya haydohɗussa ɓéeɓ ɓuwaa ɗúukool gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓa ɓaa kíimmbi ɓan ya onɓa ɓa mín kileꞌ rek ga pawaa kúltífaagari. Fodaama, ɓéeɓ ɓuwaa leꞌseera gariɗa tóoh, wakussa. ");
INSERT INTO snf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Waa ennda ɗa ɓiFërísiyeeŋ na ɓijëgíroh-waas meyohussa Yéerúsaleem, hayussa ga Yéesu, meekisohussari an: ");
INSERT INTO snf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","- Iñii tah ya tëelíbéeciigaraa taabuksoo baahcii caasamuncii? Ndaga ɓa ƴah kiñamaa ɓa tísoo yahciigaɓa fodii dii baahcii nakohkaɗa. ");
INSERT INTO snf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wayee Yéesu loffaɓa an: - Haa ɗú, iñii tah ya ɗú taabukoo iñii Kooh nakohɗa? Ɗú am ga baahciigarúu? ");
INSERT INTO snf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","En kiꞌenaa, Kooh woꞌ an: «Kelohɗaa paapu na eefu.» Na ɓan an: «Ɓaa fu ɓas paapu wala eefunaa, fu jom kiꞌapu hen.» ");
INSERT INTO snf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wayee ɗú, ɗú jëgíroh an ɓoꞌ mínin kiwoꞌ paamci wala eeci an: «Iñaa mi jomeerúu kitoputuꞌohɗa, mi faanɗinwa Kooh sarah.» ");
INSERT INTO snf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɓaa tum iñaamanaa wacin ga iñaa waꞌti ga paamci wala eeciɗa. Ee fodaama ɗú nís iñaa woꞌeenaa Kooh nakohɗa, ɗú taabukka kesi baahciigarúu! ");
INSERT INTO snf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɗú, ɗú jófjófɗuk ga hascii ɓuwii. Ísayíi, sëldíiga-Koohaa, hoteerúu moos ee ya woꞌee kayoh ga waa ya woꞌ ga teek Kooh an: ");
INSERT INTO snf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Ɓuwii ɓii, kañii ɓa kañirooɗa eem túuwtii doŋ, ɓa ekkiiroo ga keeñɓa dara dara. ");
INSERT INTO snf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɓa ɓay teekkoo sooƴ, ndaga iñcii ɓa jëgíroh ga teekiigooɗa meyoh ga iñaa ɓoꞌ nakoh». ");
INSERT INTO snf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Waa ennda ɗa, Yéesu ɓayya ɓuwaa, woꞌꞌaɓa an: - Súkúꞌkattoo ee ɗú ínoh iñii yii bi jof. ");
INSERT INTO snf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Enndii iñaa aasi ga kúuw ɓoꞌ yërí tahiri kilíiɓ ga fíkíi Kooh, wayee iñaa meyohi ga kúuwciɗa yërí tahiri kilíiɓ. ");
INSERT INTO snf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tëelíbéecaa nak deeyussa gari woꞌussari an: - Iñaa Fërísiyeeŋcaa keloh fu woꞌ yaama, fu ínohin an neɓpiiɓa ga keeñe? ");
INSERT INTO snf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yéesu taassaɓa an: - Ɓéeɓ kedik, kaa Paammboo yii ga ɗookɗa yíppii, ka hay kiɗofu. ");
INSERT INTO snf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Íisatɓa, ɓa ɓibúumíꞌ, ɓaa en na kinook ɓibúumíꞌ mooroomɓa. Binaa búumíꞌ nook búumíꞌ mooroomcinaa, ɓa ɓanak ɓéeɓɓa ɓa hay kikeen ga noŋ. ");
INSERT INTO snf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peeꞌ woꞌꞌa Yéesu an: - Lëegísohɗaaríi woꞌeenaa fu nataal karamɗa. ");
INSERT INTO snf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yéesu woꞌꞌa an: - Ɗú ɓan, bi wati ɗú laakoo hele? ");
INSERT INTO snf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɗú ínohoo an iñaa aas ga kúuw ɓéeɓ paafi ga look, lëehíraa wa kaꞌ fenoo kaan? ");
INSERT INTO snf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wayee iñaa meƴ ga kúuw ɓoꞌ ɓéeɓ meyoh ga keeñaa ee iñaama yërí tahi ɓoꞌ kilíiɓ ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","En kiꞌenaa, halaat cibóníꞌ, kilaŋ kumuun ɓoꞌ, kiɗúk ƴaalfu wala ɓetifu fu faanuk na ɓoꞌ yiliis, kifaanuk na ɓaa en ɓéeɓ, kilok, kipok kiwoꞌ, kiyah teek ɓoꞌ, ca meyohi ga keeñ. ");
INSERT INTO snf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iñcuma cërí líiɓɗi ɓoꞌ ga fíkíi Kooh, wayee kiñam ee fu tíssii yah fodaa daa baahcaa nakohkaɗa tahoo ɓoꞌ kilíiɓ ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Waa ennda ɗa Yéesu meyohha daama, kaꞌta ɓak dëkaa Tíiꞌ na waa Sídoŋ. ");
INSERT INTO snf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Laakka ɓetifaa hay gari. Ɓetifaama bok ga ɓu-Kanaa ee fa dëk gohaama. Fa faa fiip an: - Éeƴ Kiyaakii, kucaasamunkii Dëwít, yërëmaaroo! Kowukaagoo kiɓetikaa, laak rawaa amka ee sodalinka lool! ");
INSERT INTO snf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wayee Yéesu nammbiiri sah kitaas hen. Tëelíbéecaagari deeyussa gari, kíimussari an: - Fu ɓëgíssinaa en na, ya ƴee? Ya yii taabukkuu, ya fiipi rek! ");
INSERT INTO snf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yéesu taassa an: - Mi wosu kiꞌeem ga baalcii Kooh ga ɓu-Isarayeel múuƴɗa. ");
INSERT INTO snf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wayee ɓetifaa hayya, ƴíꞌꞌa ga fíkíi Yéesu, woꞌꞌari an: - Kiyaakii, hay dímalaaroo! ");
INSERT INTO snf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yéesu loffari an: - Kiɓeɓ ñamah oomaa, fu jafiꞌ tubaaytaa, iñaama moroo. ");
INSERT INTO snf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɓetifaa woꞌꞌari an: - Fu woꞌ kayoh, Haꞌmudii. Wayee tubaaytaa mínin kiñam wúunéecaa keeni ga kanukaa haꞌmuncaagaɓa ñamohiɗa. ");
INSERT INTO snf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ga ɗekataama, Yéesu woꞌꞌa ɓetifaa an: - Ngëmiigaraa yakin, fu ɓetifii fii! Iñum fu waaꞌɗa, Kooh tumɗattaari. Ee kowukaagari dalla kiwak ga wahtaama. ");
INSERT INTO snf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Waa ennda ɗa, Yéesu kolkohha ɗekataama kaꞌta seereenaa giiyaa Gëlílée. Ya lappa ga ɗook jaŋjagaa daama, ya yuŋnga da. ");
INSERT INTO snf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɓiɓoꞌ ɓiyewin hayussa gari, haydohɗussari ɓiɓéedúkíꞌ, ɓibúumíꞌ, ɓilafañ, ɓiluuɓ na ɓoꞌ ɓiyewin ɓiliis ɓaa ɗúukool hen. Ɓa faanndaɓa kakay ga kotcaa Yéesu, ya wëkíꞌtaɓa. ");
INSERT INTO snf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɓéeɓ ɓuwaa waaruꞌussa ga waa ɓa hot luuɓcaa ɓaa woꞌ, lafañcaa ɓaa tuuk na kotcaagaɓa, ɓéedúkíꞌcaa ɓaa tíin dijófíꞌ, búumíꞌcaa ɓaa hot, ee ɓéeɓ aawwa kindam Koohyii ɓu-Isarayeel. ");
INSERT INTO snf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Waa ennda ɗa, Yéesu ɓayya tëelíbéecaagari, woꞌꞌaɓa an: - Mi laakin yërmaandi wiyaak ga mbooloomii, ndaga malkat, bes kaahay cee, caa wëeꞌtaa ga an cii, ɓa ɓii naroo, ee diima deŋ ɓa laakoo iñaa ɓa ñaman. Mi waaꞌtiiɓa kiwoꞌ ɓa ɓoyuk kaanɓa na kiyaaɓ, mi saŋ ɓa tëhlí ga waas. ");
INSERT INTO snf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tëelíbéecaa woꞌussari an: - Ñamahaa ƴah kikëpíꞌ ɓuwii ɓii, ɗí ɓewohanwa gada, ga ɗekatii wii laakoo daraɗa? ");
INSERT INTO snf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yéesu meekissaɓa an: - Ɗú laak mbúurú cera dii? Ɓa taassa an: - Ciyitnakanak na tujëntaa yewinndii. ");
INSERT INTO snf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Waa ennda ɗa, ya nakka ɓuwaa ɓa yuŋ kakay. ");
INSERT INTO snf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ya ɓeɓpa mbúurúcaa ciyitnakanakcaa na jëncaa, ya gërëmmba Kooh, ya weellaca, ya eꞌta tëelíbéecaagari, ɓaama warohhaca ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓaa en ɓéeɓ ñammba bi kappa pút, bi tessa. Iñaa teseeɗa ɓa wookkari: ennda ɗaba ciyitnakanak caa líifin muut ga mbúurú na jën. ");
INSERT INTO snf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓuwaa ñameeɗa enee ɓoꞌ ɓijúnni-nikiis (4.000) ee ɓeticaa na oomaacaa kídussii ga. ");
INSERT INTO snf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lëehíꞌta Yéesu tagohha na ɓuwaa, ya aassa gaal-looci, yaa ƴah ɓak gohaa Magadaan. ");
INSERT INTO snf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Laakka ɓiFërísiyeeŋ na ɓiSaduseyeeŋ ɓaa hay ga Yéesu, kifíꞌti. Ɓa meekissari ya tumiꞌɓa kíntaanaa teewoh an ya meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yéesu loffaɓa an: - Noh ƴah kiꞌaas, ɗú hot asamaanaa setaa, ɗú woꞌi an: «Kuwis, Kooh hay kitam noh.»  ");
INSERT INTO snf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","En na kím, ɗú hot asamaanii kúnukaa, ɗú woꞌi an: «wati, Kooh hay kitoɓ.» Fodaama ɗú mínin kimalaksukoh dii asamaanii madiɗa wayee ɗú mínoo kimalaksukoh iñcii Kooh en na kitum ga wati. ");
INSERT INTO snf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɓuwii jamaanii wati ɓibóníꞌɓii ee ooruunun Koohɗa, ɓa waaꞌ kihot kíntaan. Wayee kíntaan wíinoo tookɗusanndiiɓa, enndii waa Sonaasaa. Lëehíꞌta Yéesu foñnjaɓa daama, ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tëelíbéecaa Yéesu paafussa giiyaa ɓakaa hanoh gaaɗa, ɓa alukka kiɓaydoh mbúurú. ");
INSERT INTO snf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yéesu woꞌꞌaɓa an: - Watukat, ee abukat ga lëwíiraa Fërísiyeeŋcaa na waa Saduseyeeŋcaa! ");
INSERT INTO snf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tëelíbéecaa enussa kiwoꞌ ga díkaantiɓa an: - Dii ɗu ɓaydohhii mbúurúɗa, kërí tah ya woꞌ iñaama. ");
INSERT INTO snf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yéesu ínohha iñaa ɓa en kiwoꞌ ga díkaantiɓaɗa, woꞌꞌaɓa an: - Iñii tah ya ɗú woꞌ ga díkaantirúu an dii ɗú ɓaydohhii mbúurúɗa tah. Ngëmiigarúu daal dooyyii! ");
INSERT INTO snf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Helciirúu hayyii bi watine? Hanaa ɗú níindísukkii mbúurúcaa ciyëtúuscaa warohsee ɓuwaa ɓijúnni-yëtúusɓaaɗa (5.000)? Pañi cera cërí ɗú wookee ga iñaa teseeɗa? ");
INSERT INTO snf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Haa mbúurúcaa ciyitnakanakcaa warohsee ɓuwaa ɓijúnni-nikiisɓaaɗa (4.000), ɗaba cera cërí ɗú wookee ga iñaa teseeɗa? ");
INSERT INTO snf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tum na ɗú ínohoo an mi woꞌꞌiirúu mbúurú kiñam ga wii mi woꞌꞌúu an «Abukat ga lëwíiraa Fërísiyeeŋcaa na waa Saduseyeeŋcaa»? ");
INSERT INTO snf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Fodaama, tëelíbéecaa ɓaa han kiꞌínoh an Yéesu woꞌꞌiiɓa kiꞌabuk ga lëwíiraa tumsi ga mbúurúɗa, wayee ya woꞌɓa kiꞌabuk ga iñcaa Fërísiyeeŋcaa na Saduseyeeŋcaa jëgírohiɗa. ");
INSERT INTO snf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yéesu kaꞌta bi ga ɓak teeraa Sesaree-Filiip. Daama, ya meekissa tëelíbéecaagari an: - Ɓuwii woꞌu an mi, Kowukii ɓii, mi yërí en ɓa? ");
INSERT INTO snf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓa taassari an: - Laakin ɓuwaa woꞌ an fu yërí en Saŋ-Bëtís. Ɓíinoo an fu yërí en sëldíiga-Kooh Ili. Ɓíinooɓaa an fu yërí en sëldíiga-Kooh Yérémíi wala yíinoo ga sëldíiga-Koohcii. ");
INSERT INTO snf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yéesu meekissaɓa an: - Haa ɗú, ɗú woꞌ an mi yërí en ɓa? ");
INSERT INTO snf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoŋ-Peeꞌ taassa an: - Fu yërí en Kiristaanii, Kowukii Koohyii en na kipesɗa. ");
INSERT INTO snf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Waa ennda ɗa Yéesu woꞌꞌari an: - Fu yewinin múuꞌ Simoŋ, kowu Saŋ, ndaga enndii ɓoꞌ-súusúus onndaa kiꞌínoh iñuma, wayee Paammboo yii ga ɗookɗa yërí. ");
INSERT INTO snf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ee mi, mi woꞌꞌaa man: fu yërí en Peeꞌ -- waaꞌ kiwoꞌ atoh -- ee ga ɗook atohuma mi tawahan Jaangiigoo ga. Ee kikaan mínanndiiwa kitëhdoh. ");
INSERT INTO snf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi hayyaa kiꞌeꞌ tucëwítaa Nguuraa yii ga ɗookɗa: iñaa fu kokoh ga ëldúna ɓéeɓ, hay kikokohu ga ɗook; ee iñaa fu took ga ëldúna ɓéeɓ, hay kitooku ga ɗook. ");
INSERT INTO snf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lëehíꞌta Yéesu ɗíŋngaɓa na woꞌeen ciyëgísíꞌ, an ɓa hanat kiwoꞌ ken an yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kolkohha daama, Yéesu aawwa kiwoꞌ tëelíbéecaagari faŋ an: - Mi jomin kikaꞌ Yéerúsaleem. Daama, haꞌ-kaancaa na sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa tíkussoo mesiklaat ciyewin. Mi hay kiꞌapu ee besaa wukaahaywaa tíkan gaɗa, mi hay kimílís. ");
INSERT INTO snf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Waa ennda ɗa, Peeꞌ nookka Yéesu ga yahaanaa, yaa ñaꞌti: - Múk Haꞌmudii, iñaama Kooh tumoori! ");
INSERT INTO snf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wayee Yéesu mëeñsukka, gëtta Peeꞌ an: - Úsaayaaroo, Seytaani! Halaatciigaraa enndii halaatcaa meyoh ga Kooh wayee ca meyoh ga ɓoꞌ. Fu, fu waaꞌtoo kikëfít! ");
INSERT INTO snf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lëehíꞌta Yéesu woꞌꞌa tëelíbéecaagari an: - Binaa ɓoꞌ waaꞌ kitaam ga fenooroonaa, ya alat hafci, ya kooruk kuraanaagari, ya taabukkoo. ");
INSERT INTO snf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","En kiꞌenaa, ɓaa fu waaꞌ kisom kumuunfunaa, fu hayka kiñak bi taaꞌ. Wayee ɓaa mi tahhaa kiñak kumuunfunaa, fu hayka kilaakis. ");
INSERT INTO snf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ee ɓoꞌ enoh kilaak iñcii ga ëldúna tóohɗa ya, binaa ya naꞌ kiñak kipesci bi taaraa? Ati laakin iñaa ɓoꞌ mín nawa kilaasoh kipeskaagari? ");
INSERT INTO snf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kowukii ɓii nak hay kihay ga ndamaa Paamci, ya taam na malaakacaagari. Bëríinaa, ɓaa en ɓéeɓ, ya hayyi kifay iñaa ya tumɗa. ");
INSERT INTO snf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mi woꞌꞌúuka ee kayoh, ɓiɓoꞌ ga ɓuwii ɓii kaansoo ee ɓa hottii Kowukii ɓii hay ga Nguuraagari. ");
INSERT INTO snf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tíkka ga bes ciyitniinoo, Yéesu taammba na Peeꞌ na Saak na Saŋ këmëeŋkí Saak, ya ɓayyaɓa, ɓa rek daa wéetin, ga ɗook jaŋjaŋ wiyaak. ");
INSERT INTO snf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Daama, jëmmaagari súpítukka ga fíkíiɓa. Fíkíifaagari faa melic en fan noh, kúltícaagari yaanaawwa ɗer fodii leeꞌlaat. ");
INSERT INTO snf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ga ɗekatcaama, tëelíbéecaa ɓaahayɓaa hotussa Móyíis na Ili meyussa ga fíkíiɓa, ɓa ɓaa saawal na Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peeꞌ dalla kiwoꞌ Yéesu an: - Haꞌmudii, dii newin garuu! Fu waaꞌkanaa, mi yíp taal kaahay dii: wíinoo wuufu, wíinoo wuu Móyíis ee wíinoo wuu Ili. ");
INSERT INTO snf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lak Peeꞌ yaa lís kiwoꞌ fodaama, laakka yaayeel wimélícíꞌ waa hay, úullaɓa. Ee ga ɗuuƴ yaayeelaa, laakka koonaakaa woꞌ an: - Ɓii yii yërí en Kowukiigoo mi keeñukɗa, keeñnjoo soosin gari, súkúrukatti! ");
INSERT INTO snf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Daa tëelíbéecaa kelohsee koonaakaa kaama, ɓa ennda nërëm ga kakay, ɓa tíitta lool. ");
INSERT INTO snf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wayee Yéesu deeƴca, leꞌꞌa gaɓa, woꞌꞌaɓa an: - Kolkat, kaa tíitat! ");
INSERT INTO snf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Waa ennda ɗa, ɓa ɓëwíꞌta haf, ɓa hotissii ken enndii Yéesu haŋcinaa. ");
INSERT INTO snf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Daa ɓa enee na kiyoosuk jaŋjagaaɗa, Yéesu: woꞌꞌa tëelíbéecaa kiɗíŋɓa an: - Kaa ɓéestírat ken iñii ɗú hot feeñuk garúuɗa, bi ga daa Kowukii ɓii mílísan ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lëehíꞌta tëelíbéecaa meekissa Yéesu an: - Iñii tah ya jëgíroh-waascii woꞌu an Ili yërí ɗewan kihay paaƴ? ");
INSERT INTO snf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yéesu taassaɓa an: - Ee kayoh! Ili ɗewan kihay, ya hëwíraat iñaa en tóoh bi jek. ");
INSERT INTO snf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wayee mi woꞌꞌúu an Ili hayin kumëeñíꞌ ee ɓuwii ínohsohussiiri, wayee ɓa tummbari iñaa neɓɓa. Fodaama Kowukii ɓii ɓan, ɓa ƴahka ɗa kitum. ");
INSERT INTO snf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Waa ennda ɗa, tëelíbéecaa ɓaa han kiꞌínoh an Saŋ-Bëtís yërí ya woꞌeeɓa. ");
INSERT INTO snf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ga waa Yéesu na tëelíbéecaagari yoosuku jaŋjagaa ɓa hayya bi ga daa mbooloomaa enɗa, laakka ɓaa hay, ƴíꞌꞌa ga fíkíi Yéesu, ");
INSERT INTO snf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","woꞌꞌari an: - Kiyaakii, yërëmaa kowukiigoo, ya ɓay cikeen-keen ee mesikin gari lool. Leekleek ya keen ga kiwii wala ya keen ga músú. ");
INSERT INTO snf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi haydohinndi ga tëelíbéeciigaraa wayee ɓa mínndiiri kiwëkíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yéesu woꞌꞌari an: - Cëeƴ, ɗú ɓuwii wati, ɗú laakoo ngëm ee ɗú tumi iñaa joffii. Mi enan narúu bi kera? Mi múuñɗanndúu bi kera? Haydohɗattoo oomaanaa gii. ");
INSERT INTO snf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yéesu gëtta rawaa ya meyoh ga oomaanaa. Rawaa meƴca, oomaanaa dalla kiwak. ");
INSERT INTO snf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lëehíꞌta, ga waa ɓa tessa haŋɓaɗa, tëelíbéecaa deeyussa ga Yéesu, meekisussari an: - Iñii tah ya ɗí, ɗí mínndii kikaal rawaama ga oomaanaa? ");
INSERT INTO snf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yéesu woꞌꞌaɓa an: - Ga dii ɗú yewinndii ngëmɗa, kërí tah. En kiꞌenaa, mi woꞌꞌúuka ee kayoh; binaa ɗú laakee ngëmaa hín na kowu fúdan kijutuutaa, eneenaa ɗú woꞌ jaŋjagii wii an Kolkohaa dii fu léeruk dúuneenaa, wa tumka. Ee eneenaa dara wooñoorúu.  ");
INSERT INTO snf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wayee kikíim Kooh na kiꞌooꞌ kërí doŋ mín kiméyíꞌ raɓcaa man ɗa ga ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wiima lak tëelíbéecaa Yéesu ɓéeɓɓa ɓaa ga gohaa Gëlílée, Yéesu woꞌꞌaɓa an: - Kowukii ɓii hay kitíku ga yah ɓuwii. ");
INSERT INTO snf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɓa hayyi kiꞌap wayee ga besaa wukaahaywaa tíkan gaɗa, ya hay kimílís. Tëelíbéecaa nak, keeñcaagaɓa leehha tak ga iñaa ɓa keloh yaama. ");
INSERT INTO snf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yéesu na tëelíbéecaagari hayussa Kafarnawom. Daa ɓa leꞌee, ɓuwaa fayuki lempaaKaanfaa Koohɗa, hayussa ga Peeꞌ, meekisohussari an: - Jëgírohiigarúu fayoo lempaa Kaanfii Koohe? Peeꞌ taassa an: ");
INSERT INTO snf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","- Ahaŋ kay, hayaa fayin! Lëehíꞌta Peeꞌ aassa kaanfaa, daa ya leꞌee Yéesu ɗëwírukkari meekissari an: - Ya Simoŋ, fu ínoh ya ga iñii yii? Ɓuwii ɓiida jom kifay buuꞌcii ga ëldúnaɗa lempu wala juuti? Ɓuwii dëku ga kúlkiiɗanoo ɓii en sagacɗa? ");
INSERT INTO snf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peeꞌ taassa an: - Hanaa sagaccii. Yéesu nak woꞌꞌa Peeꞌ an: - Kon ɓuwii dëku ga kúlkiiɗa jomoo dara kifay. ");
INSERT INTO snf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wayee waa ɗu waaꞌtii kiyëngël keeñcaagaɓa, karaa giiyaa fu wees yoos. Jënaa fu ɗewan kiꞌamɗa, ŋëegísaa kúuwkaa: fu hay ga kihot hanjaꞌ-hëelís wíinoo. Ɓewaawa, fu fayɓa lempiigoo ga na wiigaraa. ");
INSERT INTO snf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ga wahtaama, tëelíbéecaa deeyussa ga Yéesu, ɓa meekissari an: - Ɓii yiida wëñ kiyak ga Nguuraa yii ga ɗookɗa? ");
INSERT INTO snf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yéesu ɓayya kuꞌoomaa, tuukiꞌtaja ga leelooɓa, ");
INSERT INTO snf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ya woꞌꞌaɓa an: - Mi woꞌꞌúuka ee kayoh; ɗú súpíttii kipeskaagarúu bi ɗú man na tuꞌoomaanaa, ɗú aasoo ga Nguurii yii ga ɗookɗa taaꞌ. ");
INSERT INTO snf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɓaa wëñ kiyak ga Nguurii yii ga ɗookɗa yërí en ɓaa yóoskírin hafci bi madin na kuꞌoomaakii jii. ");
INSERT INTO snf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɓaa fu teꞌ ga keeñfu oomaanaa fodii yii ndaga teekiigoonaa, lakanaa fu teꞌꞌoo mi ga kihaffoo. ");
INSERT INTO snf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yéesu tíkka ga an: - Ɓéeɓ ɓaa fu baakaaꞌlukoh yíinoo ga tuꞌoomaatii tii ee gëmu garooɗanaa, iñaa gën garaaɗa wërí en fu pokɗu atoh wiyaak ga koonaakaagaraa, fu jafu ga ɗuuƴ giiyaa. ");
INSERT INTO snf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Massa fu ëldúna, ndaga yewinin garaa iñcaa eki ɓoꞌ ga kitum baakaaꞌ. En kiꞌenaa, mosanndii ga kiñak, wayee massa ɓaa iñcaama koorohan gariɗa! ");
INSERT INTO snf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɓaa en lak yahaagaraa, wala kotaagaraa wërí tahhaa kitum baakaaraa, gúraawa fu jaf diꞌúsaayíꞌ. Iñaa gën garaaɗa wërí en fu aas ga kipeskaa leehoo taaꞌɗa na yah wíinoo wala kot wíinoo, loo kilaak yah kanak wala kot kanak ee fu jafu ga kiwiikaa ƴímoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɓaa kuhaskaagaraa tahhaa kitum baakaaraa, nísaaja. Iñaa gën garaaɗa wërí en fu aas ga kipeskaa leehoo taaꞌɗa na kuhas kíinoo loo kilaak tuhas tanak ee fu jafu ga kiwiikaa safara. ");
INSERT INTO snf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kaa eewat yíinoo ga tuꞌoomaatii tii. En kiꞌenaa, mi woꞌꞌúuka, malaakacaagaɓa ga ɗookɗa, besaa en ɓéeɓ ɓa hídoh na Paammboo yii ga ɗookɗa.  ");
INSERT INTO snf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","En kiꞌenaa, Kowukii ɓii hayin ëldúna kimúsal ɓuwii múuƴɗa. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","- Ɗú ínoh ya ga iñii yii? Binaa ɓoꞌ laak baal ɓitéeméeꞌ ee ya múuƴluk ga yíinoonaa, ya foñanndii ɓidaaŋkaah-yitnanikiis na ɓiyitnanikiisɓaa ga ɗook jaŋjagaa ɓa níirohuɗa, ya ƴee kiraasnee yaa múuƴɗane? ");
INSERT INTO snf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi woꞌꞌúuka ee kayoh; binaa ya hottinaa, neɓlukaa ya neɓlukan ga yíinoo yaamaɗa, hay kiwëñ kiyak waa ya laakan ga ɓidaaŋkaah-yitnanikiis na ɓiyitnanikiisɓaa múuyussiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ee Fodaama, Paammbúu yii ga ɗookɗa waaꞌtii yíinoo múuƴ ga tuꞌoomaatii tii. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","- Binaa mbokfu kerceen tooñnjaanaa, kara, fu wéet nari ɗú ɓanak doŋ, fu ñaꞌti. Binaa ya tookkaa kisúkúrukaa, lak fu laasinndi. ");
INSERT INTO snf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wayee binaa ya tookkiiraa kisúkúrukaa, taabaa na ɓoꞌ yíinoo wala ɓoꞌ ɓanak, fu karis gari. Ndaga fodaa daa Këyítfaa woꞌɗa, ga iñaa en ɓéeɓ jomin kilaak ɓoꞌ ɓanak wala ɓaahay ɓaa en seedi ga. ");
INSERT INTO snf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wayee binaa ya tookkii kikeloh iñaa ɓa woꞌɗanaa, woꞌaaka ɓu-jaangaa. Binaa ya saŋ ɓan kikeloh iñaa ɓu-jaangaa woꞌɗanaa, abohaari fodii yiifaꞌ wala fodii juuti. ");
INSERT INTO snf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yéesu tíkka ga an: - Mi woꞌꞌúuka ee kayoh; ɓéeɓ iñaa ɗú kokoh ga ëldúna, hay kikokohu ga ɗook; ee ɓéeɓ iñaa ɗú took ga ëldúna, hay kitooku ga ɗook ɓan. ");
INSERT INTO snf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tíkissa ga, mi woꞌꞌúu an binaa ɓoꞌ ɓanak garúu, dii ga ëldúna, júwohu ga kikíim Kooh ga iñaa mín kiꞌen ɓéeɓ, Paammboo yii ga ɗookɗa hayɓari kiꞌon. ");
INSERT INTO snf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","En kiꞌenaa, daa ɓoꞌ ɓanak wala ɓaahay hídírukoh ga teekiigoo ɓéeɓ, mi yaa ga leelooɓa. ");
INSERT INTO snf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Waa ennda ɗa, Peeꞌ deeƴca ga Yéesu, meekissari an: - Haꞌmudii, mbokkoo yaa dëkkoo kitooñ, mi jommbi kibayal waas cera? Karat bi en waas ciyitnakanake? ");
INSERT INTO snf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yéesu taassa Peeꞌ an: - Mi woꞌꞌiiraa waas ciyitnakanak doŋ sah, wayee bayalaari waas cidaaŋkaah-yitnakanak bi en waas ciyitnakanak. Yéesu tíkissa ga, liiwukkaɓa an: ");
INSERT INTO snf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","- Kërí tah Nguurii ga ɗookɗa mëdírohu anee: Enee buuꞌ, ya waaree súrgacaagari kínɗussi alalaagari ya laakɗa. ");
INSERT INTO snf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Daa ya dalee kikín, ya haydohɗussa yíinoo yaa ɓayiꞌti cadam fay ɓoꞌ ɓijúnni-daaŋkaah ga noh-noh wíinoo. ");
INSERT INTO snf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɓaa yaama mínndii kifay iñaa ya laakiꞌ buuraaɗa. Buuraa dalla kinakoh ya toonu ñaam ya na ɓetici na towutaagari na tóoh iñaa ya laakɗa. En ɗanaa kobotkaa ëlídu. ");
INSERT INTO snf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Súrgaa dalla kiƴíꞌ kúrúk ga fíkíi buuraa, kíimmbari an: «Múuñɗaaroo bi ga fíkíi, mi hayyaa kifay tóoh.» ");
INSERT INTO snf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Buuraa laakka yërmaandi gari, múuñiꞌtari kobotkaa, íissari, ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Súrgaa meƴca yaa ƴah. Ya hídohha na húnísci súrga, yaa laakɗeeri cadam fay ɓoꞌ yíinoo ga noh-noh. Ya ŋooyya yaama ga koonaa, yaa booƴ, woꞌꞌari an: «Fayaaroo iñii fu ɓayiꞌtooɗa.» ");
INSERT INTO snf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Húnísmunaa ƴíꞌꞌa kúrúk ga kotcaagari, kíimmbari an: «Múuñɗaaroo bi ga fíkíi, mi hayyaa kifay»; ");
INSERT INTO snf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","wayee ya saŋnga. Ya nammbari kiɓay hen, laŋlukkari ga kasu bi ga daa yaama fayanndi iñaa ya laakiꞌtiɗa. ");
INSERT INTO snf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Daa súrga mooroomuncaagari hotsee iñaa laakee yaama, keeñɓa leehha ga tak. Ɓa kaꞌta, ɓa ɓéestíꞌta buuraa tóoh iñaa hewee yaama. ");
INSERT INTO snf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Waa ennda ɗa, buuraa ɓaylukka súrgaama, woꞌꞌari an: «Fu súrga yisóotíꞌ! Fu ƴíꞌꞌii hen ga fíkíiroo, mi múuñiꞌtaraa kobotkaagaraa ɓéeɓkane? ");
INSERT INTO snf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fu ɓan, fu mínéeríi kilaak yërmaandi ga mooroomfu yaama fodaa daa mi laakee yërmaandi garaaɗane?». ");
INSERT INTO snf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Keeñaa buuraa tammba lool. Ya laŋnga súrgaa ga kasu, ya fítísohu bi ga daa ya fayan kobotkaagari ɓéeɓka. ");
INSERT INTO snf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yéesu tíkka ga an: - Paammboo yii ga ɗookɗa ƴah narúu kitum fodaama, binaa yaa en ɓéeɓ garúu bayallii mooroomci na keeñaagari ɓéeɓwanaa. ");
INSERT INTO snf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ga waa Yéesu lëehíꞌta kijëgíroh iñcaama, ya kolkohha gohaa Gëlílée, ya yaa ƴah dëkcaa bok ga gohaa Yúudée ee hanoh húlúwaa Yúrdeŋ gaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mbooloo wiyaak taabukkari daama ee ya yaa wëkíꞌ ɓuwaa ɗúukool gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Laakka Fërísiyeeŋcaa hayu bi gari kifíꞌti, ɓa meekissari an: - Waasiiruu onin ƴaal kifasiꞌ ɓetici ga iñaa ɓa mín kilaakoh tóohe? ");
INSERT INTO snf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yéesu meekissaɓa an: - Hanaa ɗú jaŋngii iñaa bídu ga Këyítfaa Koohɗa: «Ga dalaaraa yii sak tóohɗa tummbaɓa ƴaal na ɓeti», ");
INSERT INTO snf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ee Kooh woꞌꞌa an: «Kërí tah bi ƴaal hay kifoñ paamci na eeci, ya aboh na ɓetici ee ɓa ɓanak, ɓa en ɓoꞌ yíinoo.» ");
INSERT INTO snf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Fodaama ɓa enissii ɓanak, wayee ɓa en yíinoo. Kon ɓoꞌ hanat kihëgísoh iñaa Kooh akitohin. ");
INSERT INTO snf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fërísiyeeŋcaa meekisohussari an: - Kon iñii tah ya Móyíis nakoh an binaa ɓoꞌ ƴah kifoñ ɓeticinaa, ya onuunun kibín këyít ya eꞌtija kiteewoh an sëyaa tasin? ");
INSERT INTO snf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yéesu taassaɓa an: - Móyíis onndarúu kifasiꞌ ɓeticiigarúu ndaga dii ɗú súɓ ga keeñɗa, wayee enéeríiɗa kuɗewaa. ");
INSERT INTO snf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mi woꞌꞌúu an: «Binaa ɓoꞌ kaal ɓetici, pañ ɓeti yiliis ee lakanaa enndii an ɓetifaagari ɗúkki hen faanukka na ƴaal yiliisaa, iñaama kiɗúk ɓetici, ya faanuk na ɓeti filiis.» ");
INSERT INTO snf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tëelíbéecaa woꞌussari an: - Binaa en an iñaama yërí laak ga díkaanti ƴaal na ɓetinaa, caloo kipañ. ");
INSERT INTO snf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yéesu taassaɓa an: - Enndii an ɓuwii ɓéeɓɓa ɓërí mín kiꞌínoh iñii woꞌu yii. Ɓuwaa Kooh onɓakaɗa doŋ ɓërí mínka. ");
INSERT INTO snf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","En kiꞌenaa, laakin enaama ciyewin caa mín ɓoꞌ kihoonoh kipañ, laakin ɓuwaa mínsooka ga kiꞌoomaaɓa, ɓíinoo ɓoꞌ tíkɓaka, ɓíinoo ɓan waarussii ndaga ɓa tanuk Nguuraa Kooh. Jëgíruma ɓaa fu mínwa kitookaa, tooka. ");
INSERT INTO snf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Waa ennda ɗa, ɓiɓoꞌ haydohɗussa Yéesu tuꞌoomaa, ya tík yahcaagari ga ɗookɓa, ya kíimiꞌɓa Kooh. Wayee tëelíbéecaa ɓaa ñaꞌ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yéesu woꞌꞌaɓa an: - Íisat tuꞌoomaatii ta hay garoo, kaa hoonohatɓa ndaga Nguurii yii ga ɗookɗa wuu ɓuwii man naɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Waa ennda ɗa ya tíkkaɓa yahcaagari, lëehíꞌta ya kolkohha daama ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Laakka ɓoꞌ yaa deeƴ ga Yéesu meekissari an: - Jëgírohii, mi mín ya kitum yijófíꞌ bi mi laas ga kipeskaa leehoo taaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yéesu taassari an: - Iñii tah yah fu meekissoo ga loo yijófíꞌyaa fu mín kitumɗa? Ɓoꞌ yíinoo doŋ yërí jof. Fu waaꞌ kiꞌaas ga kipeskaa leehoo taaꞌɗanaa, tumaa iñcii Waasii Móyíis nakoh kitumɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɓaa meekissa Yéesu an: - Iñcii ciida nakohu kitum? Yéesu taassa an: - Kaa laŋ kumuun ɓoꞌ; kaa ɗúk ɓetifu wala ƴaalfu, fu faanuk na ɓoꞌ yiliis; kaa lok; kaa seediꞌ saboh. ");
INSERT INTO snf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kelohɗaa paamfu na eefu; fu waaꞌ mooroomfu fodaa daa fu waaꞌ haffuɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Oomaa-fiilaa woꞌꞌa Yéesu an: - Mi tumin iñcuma tóohca, iñii yiida tessoo kitum? ");
INSERT INTO snf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yéesu woꞌꞌari an: - Fu waaꞌ kimëtíraa, kara, fu toon iñaa fu laakɗa tóoh, fu waroh koparaama nduulcii, fodaama fu hay kilaak alalaa leehoo taaꞌ ga ɗook, lëehíraa fu hay, fu taabukkoo. ");
INSERT INTO snf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Daa oomaa-fiilaa kelohee woꞌeenaama, keeñci leehha tak, ya yaa ƴah, ndaga ya enee ɓaa yewinin alal. ");
INSERT INTO snf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yéesu dalla kiwoꞌ tëelíbéecaa an: - Mi woꞌꞌúuka ee kayoh; kiꞌaaskaa haꞌ-alal ga Nguurii yii ga ɗookɗa daal yooɓpii. ");
INSERT INTO snf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi woꞌissúu ɓan an, geeleem paaf ga noŋ kúuc kërí wëñ kiyooɓ daa haꞌ-alal aasan ga Nguurii Kooh. ");
INSERT INTO snf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Daa tëelíbéecaa kelohee woꞌeenaama, ɓa waaruꞌꞌa lool, ɓa woꞌꞌa an: - Kon baanaa, ɓii mín kimúc ɓa? ");
INSERT INTO snf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yéesu malakkaɓa, woꞌꞌaɓa an: - Iñaama wooñ ɓoꞌ wayee wooñnjii Kooh. ");
INSERT INTO snf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Waa ennda ɗa, Peeꞌ dallari kiwoꞌ an: - Malkaa, ɗí, ɗí foñin tóoh, ɗí taabukinndaa, kon ɗí ƴah ya kilaak? ");
INSERT INTO snf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yéesu taassa an: - Mi woꞌꞌúuka ee kayoh; bëríinaa Kooh tuukiran ëldúna wiliis wiꞌas bi Kowukii ɓii yuŋ kinguuruk ga ndamaagarinaa, ɗú ɓii ɗú ɓidaaŋkaah na kanakɓii taabukkooɗa, ɗú hay kiyuŋ ɓan ga baŋ-buuꞌ, ɗú attiꞌ níilcaa Isarayeel cidaaŋkaah na kanakcaa. ");
INSERT INTO snf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ee ɓéeɓ ɓuwaa foñ kaanɓa, na ɓiyaakɓa ɓiƴaal na ɓiɓeti, paamɓa, eewɓa, towutaagaɓa wala yooncaagaɓa ndaga teekiigoonaa, ɓa hay kilaasis iñaa wëñɗa waas citéeméeꞌ ee ɓa hay kilaak kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɓiyewin ga ɓuwii ɗeɓ watiɗa ɓërí mëeñjohan ee ɓiyewin ga ɓuwii mëeñjohɗa ɓërí ɗewan. ");
INSERT INTO snf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","- Nguurii ga ɗookɗa nak mëdírohu anee: Enee haꞌ-kaan, ya koluka ga kímaa teel, ya ɓeɓneera ɓiɓoꞌ, ɓaa lëgëyɗanndi ga yoon-biiñaagari. ");
INSERT INTO snf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ya júwohha naɓa ga kiꞌeꞌɓa iñaa faysi ga noh-noh wíinooɗa. Lëehíꞌta ya ebillaɓa yoonaagari. ");
INSERT INTO snf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ya meyissa ga ɓak wahtu yooꞌ-yooꞌ, ya hotta ɓiɓoꞌ ɓiliis, ɓaa yugu ga paanaa dëkaa, tumussii dara. ");
INSERT INTO snf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ya woꞌꞌaɓa an: «ɗú ɓan, karat, ɗú lëgëynee ga yoon-biiñaagoo. Mi hayyúu kifay iñaa waꞌ.» ");
INSERT INTO snf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓaama karussa. Haꞌ-yoonaa meƴsissa ga ɓak wahtu cuunoh na ɓan ga wahtu kigoonaluk, ya tumissa fodaama. ");
INSERT INTO snf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ya meƴsissa lak nohaa waa soos, ya hotta ɓiɓoꞌ ɓiliis daama, ga paanaa, ya meekissaɓa an: «Ɗú yugoh ya dii noh-noh, ɗú tummbii dara?» ");
INSERT INTO snf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓa taassari an: «Ken ɓeɓpiiríi kilëgëy hen.» Ya woꞌꞌaɓa an: «Kon ɗú ɓan, karat, ɗú lëgëynee ga yoonaagoo.» ");
INSERT INTO snf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ga wahtu kiƴút, haꞌ-yoonaa woꞌꞌa ɓaa tuukuk lëgëyaaɗa an: «Ɓayaa lëgëyohcum, fu fayɓa. Dalohaa ga ɓuwum mi mëeñjoh kiɓeɓɗa, fu lëehíroh ga ɓuwum mi ɗeɓ kiɓeɓɗa.» ");
INSERT INTO snf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Waa ennda ɗa, lëgëyohcaa ɓeɓsee lak nohaa soosinɗa, hayussa. Ɓa fayussa yaa en ɓéeɓ noh-nohaagari wíinoowaa. ");
INSERT INTO snf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lëgëyohcaa ɗeɓsee kiɓewuɗa nak, daa ɓa hayee kifayuk, ɓa fooŋnga an ɓa hay kilaas iñaa wëñ. Wayee ɓa ɓan, ɓa fayussa yaa en ɓéeɓ noh-nohaagari. ");
INSERT INTO snf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Daa ɓa laasee ga, ɓa aawwa kiñaꞌ iñaama ga fíkíi haꞌ-yoonaa, ");
INSERT INTO snf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ɓa woꞌꞌari an: «Ɓuwii ɓii mëeñjoh kiɓewuɗa lëgëyu wahtu wíinoo doŋ ee fu hídíꞌɓa naríi, ɗí ɓii ɗí kooruk coonufii lëgëyii na taangaayii noh-nohɗa!» ");
INSERT INTO snf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wayee haꞌ-yoonaa taassa yíinoo gaɓa an: «Ƴaal, mi tooñnjiiraa kat. Man ɗu júwohee ga cadam noh-noh wíinoo? ");
INSERT INTO snf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kon ɓewaa iñii fu laakɗa, fu ƴee. Mi waaꞌ kiꞌeꞌ ɓii yii mëeñjoh kiɓewuɗa ya hídíꞌ naraa. ");
INSERT INTO snf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mi laak alaliigoo, mi mínoo ga kitum iñaa neɓpoone? Wala ati keeñfu mesik ga dii mi jofɗa hen?» ");
INSERT INTO snf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Waa ennda ɗa, Yéesu tíkka ga an: - Fodaama, ɓuwii mëeñjohɗa ɓërí ɗewan, ɓuwii ɗeɓɗa ɓërí mëeñjohan. ");
INSERT INTO snf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Waa ennda ɗa, Yéesu enee ga waas Yéerúsaleem, ya na tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa, ya ɓayyaɓa haŋ, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","- Súkúrukat, ɗu ɓii ƴah Yéerúsaleem ee Kowukii ɓii hay kitíku ga yah sarahohcaa ɓiyaakɓaa, na jëgíroh-waascaa, ee ɓa hayyi kiꞌattiꞌ kikaan, ");
INSERT INTO snf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ɓa tíkki ga yah yiifaꞌcaa, ɓaama ñaawalsohhi, ɓa típpi laawoo, lëehíraa ɓa daaƴci ga kuraa. Ee ga besaa wukaahaywaa tíkan gaɗa, ya hay kimílís. ");
INSERT INTO snf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Waa ennda ɗa, towutaa Sebedee tanaktaa, eewɓa hayya ga Yéesu, ya taam na oomaacaagari, ya ƴíꞌꞌa ga fíkíici kikíimmbi yen. ");
INSERT INTO snf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yéesu meekissari an: - Fu waaꞌ ya? Ya taassa an: - Dígaaroo an binaa fu yuŋ ga Nguuraagaraanaa, oomaciigoo ɓii, yii yugan ga yahfu ñaam, yíinoo ga yahfu seŋ. ");
INSERT INTO snf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yéesu taassaɓa an: - Ɗú ínohoo iñii ɗú kíimɗa. Ɗú mínin kiꞌan kaas-coonii mi ƴah kiꞌanɗane? Ɓa taassari an: - Ɗí mínin. ");
INSERT INTO snf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ya woꞌꞌaɓa an: - En kiꞌenaa, ɗú hay kiꞌan ga kaasii mi ƴah kiꞌanɗa, wayee en iñaa aaw ga kiyuŋ ga yahhoo ñaam wala ga yahhoo segaa, enndii mi jomka kiwoꞌ. Ɓuwaa Paammboo waayukiꞌ ɓakcaamaɗa ɓërí ƴahca kiꞌeru. ");
INSERT INTO snf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Daa tëelíbéecaa ɓidaaŋkaahɓaa tesɗa kelohee iñaama, ɓa aylukka tëelíbéecaa ɓanakɓaa bokohɗa. ");
INSERT INTO snf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Waa ennda ɗa, Yéesu ɓayyaɓa, woꞌꞌaɓa an: - Ɗú ínohin an ɓuwii en haꞌ-kúl ga ëldúnaɗa, ɓa teewi ɓuwii an ɓa hanoh ɓéeɓ ɗook ee haꞌ-doolicii tumlukohi ɓuwii ga iñaa neɓɓa. ");
INSERT INTO snf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iñaa manɗa ƴahhiiɗa kilaak ga ɗuuƴcúu. Wayee laak ɓaa waaꞌ kiꞌen ɓoꞌ yiyaak ga ɗuuƴcúunaa, ya joman kiꞌen súrgarúu, ");
INSERT INTO snf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ee ɓaa waaꞌ garúu kikuliyukaa, ya joman kiꞌen ñaammbúu. ");
INSERT INTO snf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Fodaama, kiheel súrga tahhii Kowukii ɓii kihay, wayee ka hay kiꞌen súrga ɓuwii na kiꞌeroh kumuunci doo ya laas tumuun ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Daa Yéesu na tëelíbéecaa meƴsee teeraa Yéríkóo, mbooloo wiyaak taabukkari. ");
INSERT INTO snf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lak laakin búumíꞌ ɓanak ɓaa yuŋ ga yahaa waasaa, ɓaa sarahtuk. Daa ɓa kelohee an Yéesu yërí en na kipaaf, ɓa aawwa kifiip an: - Haꞌmudii, kucaasamunkii Dëwít yërëmaaríi! ");
INSERT INTO snf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɓuwaa ɓaa ñaꞌɓa doo ɓa ɗekoh, wayee ɓa ɓaa wëñ kifiip an: - Haꞌmudii, kucaasamunkii Dëwít yërëmaaríi! ");
INSERT INTO snf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yéesu tuukka, ɓayyaɓa, woꞌꞌaɓa an: - Ɗú waaꞌ ya mi tumiꞌtúu? ");
INSERT INTO snf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓa taassari an: - Haꞌmudii, tumɗaaríi bi ɗí mín kihotsis. ");
INSERT INTO snf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yéesu laakka yërmaandi wiyaak gaɓa, leꞌꞌa ga tuhastaagaɓa. Ga saasi ɓa malakka, ɓa ɓaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yéesu na tëelíbéecaagari hayussa bi ɓa deeƴca teeraa Yéerúsaleem, ga yahaa dëkaa Betfasee en ga ɓak tëgëlaa Ólíwíyéecaaɗa. Daama Yéesu wossa ga tëelíbéecaagari ɓanak, ");
INSERT INTO snf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ya woꞌꞌaɓa an: - Karat dëk-kawum en ga fíkíirúuɗa. Binaa ɗú leꞌ danaa, ɗú hay kihot baam yileɓ yaa pokuunun, taam na cúmbúꞌ, pëkísatɓa, ɗú haydohiꞌtooɓa. ");
INSERT INTO snf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ee binaa ɓoꞌ woꞌ yen ganaa, taasatti an: «*Haꞌmudii laak sooli ga». Ee ga saasi ya hayyúu kiꞌíis ɗú haydohɓa. ");
INSERT INTO snf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iñaama laakka doonaa iñaa sëldíiga-Koohaa woꞌeeɗa mat. Ya woꞌee an: ");
INSERT INTO snf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Woꞌat ɓu-teeraa Síyoŋ an: - Malkat, buuriigarúu yeema hayi garúu. Ya, ya tíitarukkii ee ya lap ga baam yileɓ, na ga ɗook cúmbúꞌ, kowu baam.» ");
INSERT INTO snf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tëelíbéecaa ɓanakɓaa karussa, ɓa tummba fodaa daa Yéesu nakeeɓakaɗa. ");
INSERT INTO snf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓa haydohha baamaa yileɓyaa na cúmbúraa. Ɓa laꞌta paltucaagaɓa ga ɗook baamcaa, Yéesu lappa ga ɗookgaa. ");
INSERT INTO snf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɓoꞌ ɓiyewin ga mbooloomaa larussa paltucaagaɓa ga waasaa. Ɓuwaa ɓíinoo ɓaa gúꞌ toytaa tediktaa, ɓaa ɓool tuuꞌtaa, ɓaa laꞌta ga waasaa. ");
INSERT INTO snf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɓuwaa hanohee Yéesu fíkíi na ɓuwaa taamsee ga fenoociɗa, ɓéeɓɓa ɓaa woꞌ didóolíꞌ an: - Óosaanaa! Ndam aawat ga kucaasamunkii Dëwít! Kooh barkeelat yii hay ga teekii Haꞌmudiiɗa! Óosaanaa aaw ga ɗookaa-ɗook. ");
INSERT INTO snf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Daa Yéesu aasee Yéerúsaleem, tóoh dëkaa yëngëlukka, ɓuwaa ɓaa meekisoh an: - Ɓii yii, ya ɓa? ");
INSERT INTO snf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mbooloomaa taassa an: - Sëldíiga-Kooh Yéesu yërí, yii meyoh Nasareet ga gohaa Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yéesu aassa Kaanfaa Kooh, ya kaalla ɓéeɓ ɓuwaa enee na kitoon na ɓuwaa enee na kilom daamaɗa. Ya yaa ɓúuk taabulcaa weciꞌoh-kopaꞌcaa na yugaahcaa toonoh-hoꞌcaa. ");
INSERT INTO snf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Lëehíꞌta, ya woꞌꞌaɓa an: - Bíduunun ga Këyítfaa an: «Kaanndoo ƴah kiꞌen kaanfaa kíimohohsan Kooh», wayee ɗú, ɗú tumfa ɗaakkaaꞌ lok. ");
INSERT INTO snf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Laakka búumíꞌ, na ɓéedúkíꞌcaa hay ga Yéesu ga Kaanfaa Kooh, ya wëkíꞌtaɓa. ");
INSERT INTO snf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa aylukussa ga waa ɓa hot enaamacaa cidóoyíꞌ-waaꞌcaa ya tumɗa, ee ɓa hotta ɓan oomaacaa ɓaa fiip ga Kaanfaa Kooh an: «Ndam aawat ga kucaasamunkii Dëwít!» ");
INSERT INTO snf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɓa dalla Yéesu kiwoꞌ an: - Fu kelohin iñii oomaacii woꞌɗane? Yéesu taassaɓa an: - Ee mi keloh ga. Hanaa ɗú mosoo kijaŋ iñii bídu yii an: «Ga túuwtii oomaacii na tii liiꞌcii, fu meƴdohɗin haffu ga ƴeek-kañ»? ");
INSERT INTO snf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lëehíꞌta Yéesu foñnjaɓa daama, ya meƴca teeraa, yaa ƴah Bétaníi, ya neehneera daama bi Kooh wíissa. ");
INSERT INTO snf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ga kooh-wíisfaa, Yéesu enee na kiɓoyuk teeraa ee lak ya yaawin. ");
INSERT INTO snf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ya hotta bos een ga yahaa waasaa, ya kaꞌta bi ga bosaa, ee ya hottii dara ga, enndii tuuꞌtaanaa. Waa ennda ɗa, ya woꞌꞌa kedikkaa an: - Fu límsisoo kowu bi taaꞌ! Ga saasi, eenaa súɓpa kaw. ");
INSERT INTO snf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Daa tëelíbéecaa hotee iñaama, ɓa jaahliꞌꞌa lool, ɓa meekissa Yéesu an: - Tum na kedikkii súɓ ga saasi? ");
INSERT INTO snf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yéesu taassaɓa an: - Mi woꞌꞌúuka ee kayoh; binaa ɗú laak ngëm ee ɗú laakkii hel kanak ganaa, ɗú eemoo ga kitum iñii dal kedikkii kiiɗa doŋ, wayee ɗú woꞌ sah jaŋjagii wii an: «Kolkaa dii fu jafsunee ga giiyaa!» Iñaama laak. ");
INSERT INTO snf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Binaa ɗú kíim Kooh ee taam na ngëmaa, ɓéeɓ iñaa ɗú meekisohaa, ɗú laakki. ");
INSERT INTO snf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yéesu aassa Kaanfaa Kooh, ya yaa jëgíroh. Sarahohcaa ɓiyaakɓaa na yaakcaa dëkaa hayussa, ɓa meekissari an: - Iñcii fu tumɗa, fu aƴka gada? Ɓii onndaaca kitumɓa? ");
INSERT INTO snf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yéesu taassaɓa an: - Mi ɓan, mi ƴahhúu kimeekis enaama yíinoo doŋ, binaa ɗú taassoo ganaa, mi woꞌꞌúu ɓan iñcii mi tumɗa ati mi aƴka gada? ");
INSERT INTO snf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Saŋ-Bëtís, ɓii yiida woseeri kibëtísiꞌ ɓuwaa? Kooh wala ɓoꞌ-súusúus? Ɓa ɓaa woꞌ ga díkaantiɓa an: «Binaa ɗu woꞌ an Kooh yërí woseerinaa, ya hayyuu kilof an: iñii tah ya ɗú gëmmbii ga Saŋ? ");
INSERT INTO snf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ee ɗu woꞌ an ɓuwii ɓërí woseerinaa, ɗu jomin kiniik mbooloomii ga iñaama ndaga ɓa tookin an Saŋ sëldíiga-Kooh.» ");
INSERT INTO snf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɓa dalla kitaas Yéesu an: - Ɗí ínohoo! Yéesu loffaɓa an: - Kon baanaa mi ɓan, mi woꞌanndiirúu iñcii mi tumiɗa ati mi aƴka gada. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","- Ɗú ínoh ya ga iñii yii? Enee ɓoꞌ, ya laakee towu tanak. Ya hayya ga yíinooyaa woꞌꞌari an: «Kowuroo, wati, leenaa kara, fu lëgëynee ga yoon-biiñaagaruu.» ");
INSERT INTO snf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kowukaa taassari an: «Mi ƴahhii». Wayee ennda kiis, ya récukka, ya kaꞌta yoon. ");
INSERT INTO snf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Paamudaa hayya ga yukanakyaa ɓan, woꞌꞌari iñaa ya nakee yuɗewaayaaɗa. Kowukaa kukanakkaa woꞌꞌa paamudaa an: «Ee, mi yii ƴah buba!» Wayee ya kaꞌtii. ");
INSERT INTO snf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yéesu meekissaɓa an: - Yiida ga towutaa tanaktaa tum iñaa paamci waaꞌɗa? Ɓa taassa an: - Yaa ya ɗewohɗa yërí. Yéesu dallaɓa kiwoꞌ an: - Mi woꞌꞌúuka ee kayoh; juuticii na faankoh-pakaƴcii ɓërí ɗewanndúu kiꞌaas ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","En kiꞌenaa, Saŋ hayin garúu. Ya teeɓparúu waasii wijúwíꞌ wii ee ɗú gëmmbii iñaa ya woꞌɗa. Wayee juuticii na faankoh-pakaƴcii gëmussari. Ee ga iñaa ɗú hot yaama tóoh, tahhii bi ɗú récukka, ɗú gëmmba iñaa ya woꞌɗa. Yéesu woꞌꞌa ɓuwaa an: ");
INSERT INTO snf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","- Súkúrukat, mi woꞌꞌúu liiwuk wiliis: Enee haꞌ-yoon, ya yíppa tedik-reseŋ ga yoonci. Ya ɗíŋnga yoonaa, ya acca noŋ ga yoonaa daa towu-reseŋtaa seesohsan. Ya tawahha daa ɓoꞌ mínan kituukoh, tíim yoonaa malaki ga. Lëehíꞌta ya sassa ɓilëgëyoh ga yoonaa, ya yaa ƴah kiɓaaɓ. ");
INSERT INTO snf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ga waa wahtu kiɓeen yoonaa leꞌɗa, ya wossa súrgacaagari ga lëgëyohcaa ga yoonaaɗa, ɓa eꞌti iñaa ya laak ga iñaa yoonaa meƴdohɗa. ");
INSERT INTO snf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wayee lëgëyohcaa abussa súrgacaa, ɓa feekka yii, ɓa appa yíinooyaa. Yaa tesɗa, ɓa tapisohhari na atoh bi kaannda. ");
INSERT INTO snf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Haꞌ-yoonaa wosissa súrga ɓiliis, ɓaa wëñ kiyewin ɓaa ya ɗewee kiwosɗa. Wayee lëgëyohcaa tumussa ɓuwaama fodaa ɓu-ɗewaaɓaa. ");
INSERT INTO snf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Haꞌ-yoonaa mëeñjohha kiwos kowukaagari ga lëgëyohcaa. Ya abee ga helci an: «Hanaa ɓa hay kiꞌon kowukiigoo céeꞌ.» ");
INSERT INTO snf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wayee lëgëyohcaa, daa ɓa hotee kowukaa haꞌ-kaadaa, ɓa woꞌꞌa ga díkaantiɓa an: «Yii ƴah kilamɗa yeema, ɗu apatti, ɗu ɓeɓ iñii ya jomee kilamɗa.» ");
INSERT INTO snf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɓa dallari kiꞌam, ɓa fassari bi meƴca yoonaa, ɓa appari daama. ");
INSERT INTO snf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yéesu meekissa ɓuwaa an: - Binaa haꞌ-yoonaa hayaa, ya ƴah lëgëyohcaama na kitum? ");
INSERT INTO snf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓa taassari an: - Haꞌ-yoonaa hayaa, hay kiꞌap lëgëyohcaa ɓisóotíꞌɓaa ɓaama, ap wibóníꞌ. Lëehíraa ya ɓeɓ yoonaa, ya eꞌwa ɓilëgëyoh ɓiliis, ɓaa, binaa kiɓeen leꞌaa, ɓa eꞌti iñaa yoonaa meƴdohanɗa. ");
INSERT INTO snf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yéesu woꞌꞌaɓa an: - Hanaa ɗú mosoo kijaŋ iñaa bídu ga Këyítfaa an: «Atohaa tawahohcaa jafeeɗa, atohaama enin atoh-koñ. Iñaama yërí Haꞌmudii tum, ee enin kíntaan ga hasciiruu.» ");
INSERT INTO snf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yéesu tíkka ga an: - Kërí tah mi woꞌꞌúu man: Nguurii Kooh hay kiteꞌu ga yahhúu, wa tíku ga yah heet wiliis, waa ƴahwa kilëgëy, meƴdoh jeriñ ga. ");
INSERT INTO snf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɓaa keen ga ɗook atohaamanaa hay kiweelsukoh ee ɓaa wa keen ga ɗookcinaa, wa hayyi kinapañsoh. ");
INSERT INTO snf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Daa Sarahohcaa ɓiyaakɓaa na Fërísiyeeŋcaa kelohsee liiwukcaa Yéesu caama, ɓa ínohha an Yéesu woꞌ naɓa. ");
INSERT INTO snf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓa ɓaa heel kiꞌamluk Yéesu, wayee ɓa niikka mbooloomaa ndaga ɓéeɓ ɓuwaa tookin an Yéesu sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Waa ennda ɗa, Yéesu liiwukissa ɓuwaa an: ");
INSERT INTO snf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","- Nguurii ga ɗookɗa mëdírohu anee: Enee buuꞌ, ya tíklukka cuunoh ga sëycaa kowukaagari. ");
INSERT INTO snf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya wossa súrgacaagari kiɓaynee ɓuwaa ya nakee sëgílookfaaɗa. Wayee ɓaama waarussii kihay. ");
INSERT INTO snf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Buuraa wosissa súrga ɓiliis ga ɓuwaa ya nakee sëgílookfaaɗa an: «Woꞌat ɓuwaa an: ñamahii tíkuunun, mi apin naalciigoo na júuꞌ ɓidúufíꞌ. Tóoh sekɓa, ɓa hayat, ɓa ñam!» ");
INSERT INTO snf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wayee ɓuwaa naksee ɓaama abussii faali ga ɓëytohaa. Yaa en ɓéeɓ yaa ƴah soolici: yii ga yoonci, yii ga toonaagari. ");
INSERT INTO snf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓaa tesɗa abussa súrgacaa buuraa, tóróhírussaɓa, apussaɓa. ");
INSERT INTO snf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Buuraa kelohhaka, dalla kiꞌayluk. Ya ebilla soldaaꞌcaagari ɓa apnee lagoh-kumuuncaa ɓaama, ɓa tëkíꞌ teeraa ɓa dëkohɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lëehíꞌta ya woꞌꞌa súrgacaagari an: «ñamahii sëgílookfii pariꞌin, wayee fa joobeera ɓuwaa nakseefaɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kon nak karat ga mbedicii ga dëkiiɗa, ee ɓaa ɗú hot ɓéeɓ, nakatti ya hay ga sëgílookfii.» ");
INSERT INTO snf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Súrgacaa karussa ga mbedicaa. Ɓaa ɓa hotin ɓéeɓ, ennda yijófíꞌ ennda yibóníꞌ, ɓa woꞌꞌari. Ɓa nëgírohhaɓa, bi túuyaa ñamahaa tofohuɗa líiffa muut na ɓiɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Buuraa aassa túuyaa kihëeɓɗúk ɓuwaa en na kiñamɗa. Ya hotta daama ɓoꞌ, yaa ɓayyii kúltí feet. ");
INSERT INTO snf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ya meekissari an: «Ƴaal, tum na fu aassa dii ee fu ɓayyii kúltí hew»? Wayee ɓaa laakkii iñaa ya woꞌan. ");
INSERT INTO snf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Waa ennda ɗa, buuraa woꞌꞌa súrgacaagari an: «Ɓaa yay, ɓagat yahcaagari na kotcaa, ɗú jaffi ga ñúusaa ga foohɗa: daama kikodukoh na kiꞌúñoh sís ƴah da kilaak.» ");
INSERT INTO snf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yéesu tíkka ga an: - En kiꞌenaa, ɓuwii ɓayuɗa yewinin, wayee ɓuwii tanuɗa caakkii. ");
INSERT INTO snf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Waa ennda ɗa, Fërísiyeeŋcaa karussa kihotoh ga ɗuuƴɓa, kimalak daa ɓa tuman bi ɓa fíꞌ Yéesu ga ɗuuƴ woꞌeen. ");
INSERT INTO snf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Lëehíꞌta, ɓa wossa ɓiɓoꞌ ga tëelíbéecaagaɓa, ɓa taammba na ɓiɓoꞌ ɓan ga ɓuwaa faꞌ na buuꞌ Erootɗa, kimeekis Yéesu an: - Jëgírohii, ɗí ínohin an fu woꞌi kayoh: fu jëgíroh iñaa Kooh nakoh kayoh-kayohɗa. Fu niikkii ken, ee fu malkirii ɓoꞌ ga daa ya man ga hascii ɓuwiiɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kërí tah, woꞌaaríi halaatfu ga iñii yii: Waasii onohin kifay lempaa Sesaaꞌ, buuraa yiyaakyaa ga Roomɗanoo, onohhii ka? ");
INSERT INTO snf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wayee Yéesu ínohha nof-moroonaa ɓa naꞌɗa, ya woꞌꞌaɓa an: - Ɗú ɓii ɗú jófjófɗuki ga fíkíi ɓuwiiɗa! Iñii tah ya ɗú heelloo kifíꞌ? ");
INSERT INTO snf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Teewattoo hanjaꞌ wíinoo ga koparum fayohsi lempuɗa. Ɓa haydohiꞌtari hanjaꞌ wíinoo. ");
INSERT INTO snf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yéesu nak meekissaɓa an: - Nataalii wii wuu ɓa na teekii en gaɗa? ");
INSERT INTO snf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓa taassa an: - Cuu Sesaaꞌ, buuraa yiyaakyaa. Daama Yéesu woꞌꞌaɓa an: - Kon erat Sesaaꞌ iñaa en yuu Sesaaꞌ ee erat Kooh iñaa en yuu Kooh. ");
INSERT INTO snf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Daa ɓa kelohee iñaa Yéesu lofɓa yaama, ɓa waaruꞌꞌa lool, ɓa foñnjari da, ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ga besaa bëríi, laakka Saduseyeeŋcaa hayu ga Yéesu. Ɓa nak, ɓa gëm an kimílís laakoo. ");
INSERT INTO snf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓa meekissa Yéesu an: - Jëgírohii, Móyíis woꞌ an: «Binaa ɓoꞌ kaan ee laakkii kowu na ɓeticinaa, këmëeŋkíci jomin kilam ɓetifaama, ya laakiꞌ yaakci kowu ga». ");
INSERT INTO snf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Waama, laakee dii garíi ƴaal ɓiyitnaɓanak ɓaa bok paamun na eemun. Yaakkaa pañnja ɓeti, ya kaannda ee laakkii kowu. Ee fodaama këmëeŋkímunaa lammba ɓetifaa. ");
INSERT INTO snf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ennda ɗa ga yukanakyaa, na yukaahayyaa bi ga yuyitnakanakyaa. ");
INSERT INTO snf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga waa ɓa kaannda ɓéeɓɓa, ɓetifaa ɓan tíkka ga. ");
INSERT INTO snf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Diimaɗa woꞌaaríi bëríinaa ɓuwii mílísan ga kikaanɗa, ɓetifaama ƴah kiꞌen yuuɓa ga ɓiyitnaɓanakɓaa? Ndaga yaa en ɓéeɓ ga ɓiyitnaɓanakɓaa ɓeweerari ɓeti! ");
INSERT INTO snf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yéesu taassaɓa an: - Ɗú woꞌin kimúuƴcúu, ndaga ɗú ínohoo iñaa bídu ga Këyítfaaɗa ee ɗú ínohoo daa doolaa Kooh hín kiyakɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Binaa ɓuwaa kaanɗa mílísunaa, ƴaal pajoo ee ɓeti pajukoo, wayee ɓa pesan madu na malaakacii Kooh enu ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","En iñaa aaw ga kimílískaa ɓuwaa kaanɗanaa, hanaa ɗú mosoo kijaŋ ga Këyítfaa iñaa Kooh woꞌeerúu an: ");
INSERT INTO snf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Mi yërí en Koohyii Abaraham, Koohyii Ísaak, Koohyii Yakoop». Yéesu tíkka ga an: - Kooh yuu ɓuwaa en na kipesɗa, enndii yuu ɓuwaa kaanɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓéeɓ ɓuwaa kelohsee iñcaa ya woꞌ caama, waaruꞌussa ga jëgírohaagari. ");
INSERT INTO snf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Daa Fërísiyeeŋcaa yéegee an Yéesu ɓúlin Saduseyeeŋcaa, ɓa dalla kihídoh ga ɗekataama. ");
INSERT INTO snf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Laakka jëgíroh-waasaa bok gaɓa, ya waaree kimalaksukoh Yéesu, ya meekissari an: ");
INSERT INTO snf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","- Jëgírohii, iñii yiida kuliyuk ga iñcii Waasii Móyíis nakohɗa? ");
INSERT INTO snf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yéesu taassari an: - «Fu waaran Haꞌmudii, Koohyiigaraa na keeñaagaraa tóoh, na kipeskaagaraa tóoh, na helaagaraa tóohwa.» ");
INSERT INTO snf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wuma wërí wëñ kiyak ee wërí kuliyuk ga iñcii Kooh nakohɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ee wii wërí en wukanakwii man nawaɗa: «Fu waaran mooroomfu fodaa daa fu waaꞌ haffuɗa.» ");
INSERT INTO snf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ɓéeɓ Waasaa Móyíis na ɓéeɓ iñcaa sëldíiga-Koohcaa jëgírohɗa kúꞌuk ga iñcii kanakcii cii nakohuɗa. ");
INSERT INTO snf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wiima lak Fërísiyeeŋcaa hídírukohuunun daama, Yéesu meekissaɓa an: - Ɗú ínoh ya ga Kiristaanii? Ya kucaasamun ɓa? ");
INSERT INTO snf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ɓa taassa an: - Ya kucaasamun buuꞌ Dëwít! ");
INSERT INTO snf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yéesu woꞌꞌaɓa an: - Kon tum na Dëwít, ga waa ya líif na Helaa yiselaꞌíꞌyaaɗa, ɓayyari “Haꞌmudii”? En kiꞌenaa, Dëwít ga kihafci woꞌin an: ");
INSERT INTO snf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Kooh, Haꞌmudii woꞌꞌa Haꞌmudiigoo an: “Yugohaaroo yah-ñaam bi ga daa mi tuman ɓuwii saŋngaaɗa ditogaaꞌ kotfu”.» ");
INSERT INTO snf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Waa Dëwít ɓay Kiristaanii “Haꞌmudii”, kon tum na bi Kiristaanii mín kiꞌen kucaasamun Dëwít? ");
INSERT INTO snf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Laakkii gaɓa yíinoo yaa mínndi kitaas woꞌeen wíinoo sah. Ee aboh ga besaa bëríi, ken kaañissiiri kimeekisohis yen. ");
INSERT INTO snf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Waa ennda ɗa, Yéesu woꞌꞌa mbooloomaa na tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","- Jëgíroh-waascii na Fërísiyeeŋcii ɓërí tuuk ga kotcaa Móyíis, kijëgíroh na kiteewoh iñii nakohu kitumɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kon nak, ɓéeɓ iñaa ɓa woꞌꞌúunaa, tumatti, ɗú taabukki. Wayee kaa ëldúkohatɓa ga iñcii ɓa tumiɗa. En kiꞌenaa, ɓa woꞌi hen ee ɓa tumoo. ");
INSERT INTO snf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓa poki ɗof ciɓítíꞌ caa ken hatinoo, ɓa sëfca ga yúukcii ɓuwii ee ɓa ga kihafɓa, ɓa tookoo jokonɓa yëngëluk ga kiꞌamɗohɓaca. ");
INSERT INTO snf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Iñaa ɓa tum tóoh ɓa heeli ɓuwii hotɓa. Fodaama, ɗaakaaꞌ-këyítcaa pokkusi, kiteewoh an ɓa abin Koohɗa, ɓa tumica ca en ciyaak. Ee símbaꞌcaa ga kúltícaagaɓaɗa, ɓa tumica ca en cihooꞌta. ");
INSERT INTO snf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","En ga hewaa, ɓa waari kihanoh fíkíi, ee ga ɗuuƴ jaanguciiruu, ɓa heeli kiyuŋ ga fíkíi. ");
INSERT INTO snf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓa en ga paancaanaa, ɓa waari kikëñɗu yah kanak ee ɓa waari ɓuwii ɓayiɓa «Jëgírohii». ");
INSERT INTO snf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wayee ɗú, kaa heelat kiɓayu «Jëgírohii.» Ɗú laak jëgíroh yíinoo doŋ ee ɓéeɓpúu, ɗú ɓimbok. ");
INSERT INTO snf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dii ga ëldúna, kaa ɓayat ken «Paamudii». Paamudiigarúu ya yíinoo doŋ ee yërí en yii ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ee ɓan kaa heelat kiɓayu «Haꞌ-kaadii». Ɗú laak haꞌ-kaan yíinoo doŋ ee yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yaa wëñ garúu kiyakɗa, enat súrgarúu. ");
INSERT INTO snf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɓéeɓ ɓaa ɓëwíꞌ hafcinaa, hay kiyóoskíɗu, ee ɓaa yóoskíꞌ hafcinaa, hay kiɓëwíru. ");
INSERT INTO snf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yéesu woꞌꞌa an: - Massa, ɗú jëgíroh-waascii na ɗú Fërísiyeeŋcii jófjófɗukiɗa! Ɗú ɓii laŋ halii Nguurii yii ga ɗookɗa, ɗú hoonoh ɓuwii kiꞌas. Ɗú ga kihaffúu, ɗú aasanndii ee ɗú íisanndii ɓuwii waaꞌ kiꞌaasɗa ɓa aas.  ");
INSERT INTO snf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Massa, ɗú jëgíroh-waascii na ɗú Fërísiyeeŋcii jófjófɗukiɗa! Ɗú teꞌin iñaa laak ga kaan ɓeticaa ƴaalcaagaɓa lísussiiɗa ee ɗú taabi ga na kikíim-Koohkaa ínohoo kileeh, an doonaa ɗú tíku ɓiɓoꞌ ɓijófíꞌ. Kërí tah attiꞌaa Kooh ƴahhúu kiꞌattiꞌɗa wërí wëñan kimesik. ");
INSERT INTO snf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Massa, ɗú jëgíroh-waascii na ɗú Fërísiyeeŋcii jófjófɗukiɗa. Ɗú ɓii wíil daa en tóoh ga ɗook kakay na ɗuuƴ giiƴ, kiheel kilaak luu enee tëelíbée yíinoo, yaa gëm fodii garúu. Ee ɗú laassi kilaakaa, ɗú tummbi ɓoꞌ safara yaa wëñnjúu kibon waas kanak. ");
INSERT INTO snf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Massa ɗú ɓii ɗú waaꞌ kikuliyuk ee ɗú búuminɗa! Ɗú woꞌ an «Binaa ɓoꞌ waat ga Kaanfaa Koohaa, waatukaama taabukoori, wayee binaa ya waat ga wúrúusaa en ga Kaanfaa Koohɗanaa, wa taabukki.» ");
INSERT INTO snf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɗú dofin, ɗú búumin. Iñii wëñ kilaak solu ya? Wúrúusaa en ga Kaanfaa Koohɗanoo Kaanfaa Kooh tah wúrúusaa kiselaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ee ɓan, ɗú woꞌ an: «Binaa ɓoꞌ waat ga loteelaa ga ɗuuƴ Kaanfaa Koohɗanaa, waatukaama taabukoori, wayee binaa ya waat ga sarahcaa ga loteelaa ga Kaanfaa Koohɗanaa, wa taabukki.» ");
INSERT INTO snf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Búumíꞌcii! Iñii wëñ kilaak solu ya: Sarahcaanoo loteelaa tah sarahaa kiselaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɓaa waat ga teekaa loteelaanaa, ya waatin ga loteelaa ee ya waatin ɓan ga tóoh sarahcaa en ga ɗookgaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ɓaa waat ga teekaa Kaanfaa Koohaa, ya waatin ga Kaanfaa Kooh ee ya waatin ɓan ga Kooh yaa dëk daɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɓaa waat ga teekii asamaaniinaa, ya waatin ga baŋ-buuraa Kooh ee ya waatin ɓan ga Kooh yaa yuŋ gaɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Massa ɗú, Jëgíroh-waascii na ɗú, Fërísiyeeŋcii jófjófɗukiɗa. Ɗú meƴdohɗi Kooh sarah bi ga sah ɓakaa wudaaŋkaahwaa ga iñcii línsi fodii naanaa, basaaɓ na saaɓsaaɓ, wayee ɗú saganohin iñcii jëgírohu ee cërí wëñ kilaak solu ga Waasii Móyíisɗa: ennda kijúɓ, kiyewin yërmaandi na kitaabuk Kooh. Iñcaama cërí ɗú jomee kitum ee iñcaa cíinoo hanat kisaganohu. ");
INSERT INTO snf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɗú ɓii ɗú waaꞌ kikuliyuk ee ɗú búuminɗa, ɗú síri capalaƴ ee ɗú oni geeleem. ");
INSERT INTO snf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Massa ɗú, Jëgíroh-waascii na ɗú, Fërísiyeeŋcii jófjófɗukiɗa! Ɗú tísi bi ga bíiŋcii kaascii na cii tanutii wayee ga ɗuuƴgii ɗú líifíꞌca na halaat kilok na halaatciigarúu cibóníꞌcii. ");
INSERT INTO snf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɗú Fërísiyeeŋcii ɓibúumíꞌɓii! Ɗewat kitís ɗuuƴgii kaascii ee fodaama bíiŋcaa hay kiset ɓan. ");
INSERT INTO snf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Massa ɗú, Jëgíroh-waascii na ɗú, Fërísiyeeŋcii jófjófɗukiɗa. Ɗú man na loycaa yaanaawɗu hen. Ca morin ga fooh ee lakanaa ɗuuƴgaanaa líif na ƴoh ɓoꞌ ɓikëeníꞌ na nopilaat. ");
INSERT INTO snf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Fodaama ɓuwii hoti garúu ɓiɓoꞌ ɓijúwíꞌ ee lakanaa ga ɗuuƴ keeñciigarúu, ɗú líif na kijófjófɗuk na kibon. ");
INSERT INTO snf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Massa ɗú, Jëgíroh-waascii na ɗú, Fërísiyeeŋcii jófjófɗukiɗa. Ɗú hayyanaa, ɗú tawahi loycii sëldíiga-Koohcii, ɗú móríꞌ loycii ɓuwii ɓijúwíꞌɓii, ");
INSERT INTO snf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ee ɗú woꞌi an: «Ɗí maasohee jamaanaa ɓicaasammbíinaa, ɗí taaboo naɓa ga daa ɓa ap sëldíiga-Koohcaaɗa.» ");
INSERT INTO snf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɗú woꞌ iñaamanaa, kon ɗú tookin an ɗú ɓërí en tucaasamuntii ɓuwaa apsee sëldíiga-Koohcaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kon nak iñcaa ɓicaasammbúu daleeɗa, ɗíidohatca bi mat. ");
INSERT INTO snf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Goŋcii! Heet goŋ-saamaancii! Tum na ɗú halaat kirëc ga safara? ");
INSERT INTO snf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kërí tah, súkúrukat, mi hay garúu kiwosoh ɓisëldíiga-Kooh, ɓihaꞌ-hamham na ɓuwaa ínohuunun Këyítfii. Ɗú hay kiꞌap ɓii, ɗú daaƴ ɓíinoo ga kuraa, ɗú típ ɓíinooɓaa laawoo ga jaangu-yaawúuꞌcaagarúu, ɗú sodaliɓa teeru bi ga teeru. ");
INSERT INTO snf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Fodaama ñífaa ɓuwaa ɓijúwíꞌɓaa apseeɗa hay kikípuk ga ɗookkúu, aboh ga ñífaa Abeel yijúwíꞌyaa bi ga ñífaa Sakarí kowukaa Barakíi, kaa ɗú apee ga díkaanti ɗekataa wiselaꞌíꞌwaa na daa sarahcaa tëkíꞌsiɗa. ");
INSERT INTO snf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mi woꞌꞌúuka ee kayoh; iñaa laakee yaama hay kikípuk ga hafcii ɓuwii jamaanii wati. ");
INSERT INTO snf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","- Éeƴ, ɗú ɓu-Yéerúsaleem, ɗú ɓii ɗú lagi tumuuntii sëldíiga-Koohcii, ee ɗú tapisohi na atoh bi ɗú ap ɓuwii Kooh wos garúuɗa! Waas cera cërí mi heellúu kinëgíroh fodaa daa pabu nëgírohi towutaagari ga fíldoo paɓcaagariɗa, ee ɗú tookkiika? ");
INSERT INTO snf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kon nak, kaanfiigarúu hay ɗa kifoñu ɗúŋ. ");
INSERT INTO snf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","En kiꞌenaa, mi woꞌꞌúu man aboh ga diima ɗú hotsisanndiiroo bi ga daa ɗú woꞌan an: «Kooh barkeelat yii hay ga teekii Haꞌmudiiɗa!» ");
INSERT INTO snf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yéesu meƴca Kaanfaa Kooh, ee ga daa ya enee na kiƴahɗa, tëelíbéecaagari deeyussa gari kiteeɓpi tawahcaa Kaanfaa Kooh ga daa ca hín kimoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yéesu woꞌꞌaɓa an: - Man ɗú hotin ga iñciima tóohca! Mi woꞌꞌúuka ee kayoh; tesanndii dii sah atoh wíinoo waa tíkískohan na mooroomwa, tóoh hay kiɓúꞌ. ");
INSERT INTO snf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wiima lak Yéesu yugin ga ɗook tëgëlaa Ólíwíyéecaa, tëelíbéecaagari hayussa gari ɓa haŋɓa, meekisohussari an: - Woꞌaaríi, iñcuma ƴah kilaak kera, ee mandargii wiida ƴah kiteewoh kihayiskaagaraa na kitúkíꞌkaa ëldúna? ");
INSERT INTO snf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yéesu taassaɓa an: - Watukat, ken hanattúu kiɗúk. ");
INSERT INTO snf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","En kiꞌenaa, ɓoꞌ ɓiyewin hay kihayohu teekiigoo, ɓa woꞌi an: «Mi yërí en Kiristaanii», ee ɓa hay kiɗúk ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɗú hay kikeloh yëngël heñ, wala an heñ laakin ga ɗekat. Leenaa kaa tíitat ndaga iñcaama jomin kilaak, wayee enndii an ëldúna leꞌin kitúkíꞌ. ");
INSERT INTO snf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","En kiꞌenaa, kúl hay kiɓewuk, keen ga ɗook kúl mooroomci, ee nguuꞌ hay kiɓewuk, keen ga ɗook nguuꞌ mooroomci; aꞌ hay kilaak ee kakayfii hay kiyëngëluk ga ɗekat ciyewin. ");
INSERT INTO snf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iñcaama tóoh ƴah kiman na dalaaraa mesiklaatcaa ga kimatuk ɓetiɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Fodaama ɓiɓoꞌ hayyúu kitík ga yah buuꞌ, doonaa ɗú sodalu ga kipessúu, ee ɗú hay kiꞌapu. Heetcii ga ëldúnaɗa tóohca hayyúu kisagu ndaga teekiigoo. ");
INSERT INTO snf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ga jamaanaama, ɓoꞌ ɓiyewin hay kifoñu ngëmaagaɓa, ɓa toonohi ga díkaantiɓa ee ɓa sagohi. ");
INSERT INTO snf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hay kilaak ɓoꞌ ɓiyewin ɓaa tíkan hafɓa ɓisëldíiga-Kooh ee lak saboh. Ɓa hay, ɓa ɗúk ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yibóníꞌ hay kiwëñ kisíw tah bi kiwaaroh nëewísuk ga keeñ ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wayee ɓaa fu guuꞌguuluk bi ga daa tóoh leehanaa, fu yaama fu hay kimúc. ");
INSERT INTO snf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hewhewii winéwíꞌwii wii woꞌ ga Nguurii Koohɗa hay kiyéegalohu ga ëldúna tóoh doonaa heetcii ɓéeɓ laasu ga. Lëehíraa ëldúna han kitúkíꞌ. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","- Binaa ɗú hot ɓaa Dañeel, sëldíiga-Koohaa yéegalohee ee woꞌu «yiꞌaraamíꞌyaa pooki kúlɗa», ya tuuk ga ɗekataa wiselaꞌíꞌwaa ga Kaanfaa Koohɗa -- ee ɓaa fu jaŋ iñii yiinaa, ínohaaka ga!-- ");
INSERT INTO snf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ɓuwaa iñaama laakan gohaa Yúudéeɗa, ɓa núpat, ɓa ƴee ɗook jaŋjaŋcaa. ");
INSERT INTO snf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɓaa iñaama laakanndi yugin kiꞌíikaruk ga ɗook taahaagariɗa, hanat kisek kiyoosuk kiɓeɓ yen ga ɗuuƴ túuƴci. ");
INSERT INTO snf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ee ɓaa iñaama laakanndi yooncaaɗa, hanat kiɓoyuk kaan kiɓeɓnee kúltífaagari. ");
INSERT INTO snf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Massa ɓeticaa, bescaama laakanɓa na look, na ɓaa ensan na kiɓëpíꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kíimat Kooh, ati iñcaama hídohoo ga wahtu ñiin wiméeskíꞌ wala ga bes Sabat; ");
INSERT INTO snf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ndaga meskilaatcaa dalan ɓuwaaɗa hay kiyak yakaa wëeꞌtaa ga wii, mossii kilaak iñaa manɗa aboh ga waa Kooh sak ëldúnaɗa bi wati. Ee iñaa madan ɗa laaksisanndii bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ee binaa newéeríi Kooh ya nëewís bescaa caamanaa, enaa ken múcoo. Wayee ɓuwii ya tanukɗa tah bi ya hayca kinëewís. ");
INSERT INTO snf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kon binaa ɓoꞌ woꞌꞌúu an: «Malkat, Kiristaanii yii dii!» wala «Malkat ya yaa daa!» Kaa gëmat. ");
INSERT INTO snf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","En kiꞌenaa, ɓiɓoꞌ hay kikoluk, ɓa tík hafɓa Kiristaa na ɓisëldíiga-Kooh ee lak saboh. Ɓa tumi kíntaan na enaama cidóoyíꞌ-waaꞌ kiɗúk sah, enee an mínukinaa, ɓuwaa Kooh tanukɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mi yéegallúu diimaɗa balaa dara hewanaa. ");
INSERT INTO snf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kon binaa ɓoꞌ woꞌꞌúu an: «Malaknat, Kiristaanaa yaa ga ëgíꞌ-dúndagaa!» Kaa karat da. Wala «Malkat yeema ɗaakukka!» Kaa gëmat. ");
INSERT INTO snf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","En kiꞌenaa, fodaa melic eni mareet aboh meyaaꞌ-noh bi ga aasaaꞌ-nohɗa, fodaama kihaykii Kowukii ɓii ƴahɗa kiman. ");
INSERT INTO snf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Daa mídi enoh, suulcaa hídohsan da. ");
INSERT INTO snf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","- Coonucaa ga bescaamaɗa paafaa, nohii dal kiñúusíꞌ, ñiidii íis kileeꞌ, ee olcii hay kiɗëegískoh ɗook-Kooh ca keen ee iñcaa en ga asamaanɗa tóoh hícukoh. ");
INSERT INTO snf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Fodaama, mandargaa Kowukii ɓii hay kihotuk ga asamaan, ee ɓéeɓ heetcii ga ëldúnaɗa kodukohi; ɓa hay kihot Kowukii ɓii ga ɗuuƴ yaayeelcii, ka yoosuki, taam na dooli na ndam wiyaak. ");
INSERT INTO snf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mbiiwaa wiyaakwaa hay kitípu, Kowukii ɓii wos malaakacaagari ɓa hídíroh ɓuwaagari ya tanuk ee enu ga topaaꞌcii ëldúna cinikiisciiɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","- Malkat iñii een jëgíꞌtúu ga iñaamaɗa. Binaa toytaa kedikkaa neꞌ kineꞌ bi, ee tuuꞌtaa dal kitapisaa, ɗú ínoh an lah deeyin. ");
INSERT INTO snf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Fodaama ɓan, binaa ɗú hot iñcaama tóohaa, ínohat an Kowukii ɓii deeyin, ya leꞌin halii. ");
INSERT INTO snf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mi woꞌꞌúuka ee kayoh; bi ɓuwii wati kaanu ɓéeɓɓanaa, iñcaama tóoh hay kilaak. ");
INSERT INTO snf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Asamaanii na kakayfii hay kifaay wayee woꞌeenndoo faayoo múk. ");
INSERT INTO snf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","- En loo iñaa aaw ga besaa wala wahtaa iñaama laakohanɗa, ken ínohoowa. Enndii malaakacaa ga asamaanɗa, ee enndii sah Kowukii. Paamudii doŋ ínohwa. ");
INSERT INTO snf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iñaa laakee ga jamaanaa Noweeɗa hay kilaakis fodaama ga hayii Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndaga balaa músúmaa miyewinmaa Kooh towee, ma úulla ɓuwaa ga jamaanaa Noweeɗa, ɓuwaa enee ga kiñam na kiꞌan, ɓa pajohi, ɓa onohi towutaagaɓa kipañ bi ga besaa Nowee aas gaalaa wiyaakwaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓuwaa, helɓa mossii ga kikaꞌ bi ga daa Kooh towoh músúmaa miyewinmaa úulee ɓuwaaɗa, ma ɓayyaɓa ɓéeɓɓa. Fodaama ɓan hayii Kowukii ɓii ƴahɗa kiman. ");
INSERT INTO snf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Leꞌ bëríinaa, ƴaal ɓanak ɓaa enu ga yooncaa, yíinoo hay kiɓewu, yíinooyaa foñu. ");
INSERT INTO snf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɓeti ɓanak ɓaa en na kiꞌoꞌ ga oraaraa, yíinoo hay kiɓewu, yíinooyaa foñu. ");
INSERT INTO snf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kon kaa neehat, ndaga ɗú ínohoo besaa Haꞌmudiigarúu ƴah kihayɗa. ");
INSERT INTO snf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ínohat iñii yii bi jof: binaa Haꞌ-kaan ínohee wahtaa lok ƴah kihay kaanci ga wekɗanaa, eneenaa ya neehoo, ya íis kaanci fa pooku. ");
INSERT INTO snf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kërí tah, ɗú ɓan, waayukat, ndaga Kowukii ɓii hayan ga wahtaa ɗú fooganndii. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","- Kon ɓii yiida en súrgaa tookɗin haꞌ-kaanci ee ya ñaañin? Yërí en yaa haꞌ-kaanci tíkan ga fíkíi súrgacaagari, doo ya eꞌɓa yaa en ɓéeɓ iñaa ya jom kiñamɗa binaa wahtaa leꞌaa. ");
INSERT INTO snf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ya yewinin múuꞌ, súrgaama, binaa haꞌ-kaadaagari ɓoyuk, laakki ga lëgëyaamanaa. ");
INSERT INTO snf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mi woꞌꞌúuka ee kayoh; haꞌ-kaanci hayyi kitík ga ɗook iñcaa ya laakɗa tóoh. ");
INSERT INTO snf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wayee binaa súrgaa yibóníꞌyaama woꞌ ga helaagari an: «Haꞌ-kaanndoo kolukkii kihay», ");
INSERT INTO snf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bi tah, ya en ga kifeek ɓimooroomci súrga, ya en ga kiñam na kilaal rek na anoh-anohcaanaa, ");
INSERT INTO snf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","haꞌ-kaadaa súrgaama hay kihay ga besaa ya fooganndii na wahtaa ya ínohanndii. ");
INSERT INTO snf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Haꞌ-kaadaa hayyi kifeek dooꞌ ciméeskíꞌ, ya waꞌti iñaa sek ɓuwaa jófjófɗukiɗa, daa kikodukoh na kiꞌúñoh sís ƴah kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","- Kon Nguurii Kooh ga ɗookɗa ƴah kimëdírohu anee: enee oomaa-jowu ɓidaaŋkaah, ɓa ɓeɓpa lampucaagaɓa, ɓa kaꞌta kitëebíluknee haꞌ-kílookkaa. ");
INSERT INTO snf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ga oomaa-jowucaama, ɓiyëtúusɓaa enussa ɓiɓoꞌ ɓilóhóyíꞌ-hel, ɓiyëtúusɓaa tesɗa enussa ɓilëekíꞌ-hel. ");
INSERT INTO snf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓaa lohoyin helɗa ɓewussa lampucaagaɓa ee ɓa halaattii kiɓaydoh dúuleen. ");
INSERT INTO snf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wayee ɓaa laakin helɗa sorussa dúuleen ga bíteel, ɓa ɓaydohha na lampucaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Haꞌ-kílookkaa hëewíꞌta kihay, faf ɓéeɓɓa ɓa pëníꞌukka, ɓa aawwa kineeh. ");
INSERT INTO snf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ga leeloo wek, laakka koonaakaa kelohuk didóolíꞌ an: «Haꞌ-kílookkii hayin, meyat ɗú tëebílukki!» ");
INSERT INTO snf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ɓéeɓ oomaa-jowucaama dalla kiyúuduku, ɓa ɓaa waayuk lampucaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oomaa-jowucaa ɓilóhóyíꞌ-helɓaa woꞌussa ɓilëekíꞌ-helɓaa an: «Lampuciigaríi cii ƴím, onattíi ga dúuleeniigarúu.» ");
INSERT INTO snf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ɓilëekíꞌ-helɓaa taasussaɓa an: «Óꞌóo, mínukoo; iñii ɗí ɓayɗa dooyooríi narúu. Namat kikaꞌ ga toonohaa, ɗú lomiꞌnee haffúu.» ");
INSERT INTO snf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ɓaama nak karussa kilomnee dúuleen, haꞌ-kílookkaa hayohhaɓa fenoo. Oomaa-jowucaa pariꞌeeɗa taabussa na haꞌ-kílookkaa, ɓa aassa túuyaa cuuníin sëgílookfaa tofohuɗa, halaa lagussa. ");
INSERT INTO snf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ennda kiis, oomaa-jowucaa ɓíinooɓaa leꞌussa, ɓa ɓaa ɓëytoh an: «Kiyaakii, kiyaakii, lëgísɗaaríi!» ");
INSERT INTO snf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wayee haꞌ-kílookkaa taassaɓa an: «Mi woꞌꞌúuka ee kayoh; mi ínohoorúu!» ");
INSERT INTO snf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yéesu tíkka ga an: - Kon kaa neehat, ndaga ɗú ínohoo besaa ee ɗú ínohoo wahtaa Kowukii ɓii hayanɗa. Yéesu liiwukissa an: ");
INSERT INTO snf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","- Ee ɓan Nguurii Kooh ƴah kimëdírohu na ɓoꞌ, yaa enee na kiƴah kiɓaaɓ. Ya ɓayya súrgacaagari, ya díŋkaanndaɓa alalaagari, ");
INSERT INTO snf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","yaa en ɓéeɓ iñaa ya hatinɗa: yíinoo ya eꞌtari hanjaꞌ-wúrúus ciyëtúus; yaa tík gaɗa, kanak; yukaahayyaa, wíinoo. Ya yaa ƴah kiɓaaɓ. ");
INSERT INTO snf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yaa eꞌsee hanjaꞌ-wúrúuscaa ciyëtúuscaaɗa dalla kikaꞌ, lëgëyya ga koparaa bi ya laakka hanjaꞌ-wúrúus ciyëtúus ciliis. ");
INSERT INTO snf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yaa eꞌsee kanakcaaɗa, kaꞌta, tummba fodaama ya laakka kanak ciliis. ");
INSERT INTO snf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wayee yaa eꞌsee hanjaꞌ wíinoo doŋɗa, kaꞌta acca noŋ ga kakay ɗaakka koparaa haꞌ-kaanci ga. ");
INSERT INTO snf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tíkka ga iñaa maañ, haꞌ-kaadaa súrgacaa meyohha kiɓaaɓ. Ya ɓaylukkaɓa kiꞌínoh yaa en ɓéeɓ iñaa ya tum ga koparaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Súrgaa eꞌsee hanjaꞌ-wúrúuscaa ciyëtúuscaaɗa hayya, deeƴca, meƴdohha hanjaꞌ-wúrúus ciyëtúus ciliis, woꞌꞌa an: «Kiyaakii, fu ereeroo hanjaꞌ-wúrúus ciyëtúus. Mi lëgëyya ga. Uuna, ciyëtúus ciliis cee.» ");
INSERT INTO snf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Haꞌ-kaadaagari woꞌꞌari an: «Waw guureway, fu súrga yijófíꞌ ee fu goꞌ. Fu enin goꞌ ga iñaa yewinndii, mi hayyaa kiꞌeꞌ fu kuliyuk ga yiyewin. Hay fu bok kineɓluk na haꞌ-kaanfu.» ");
INSERT INTO snf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Súrgaa eꞌsee hanjaꞌ-wúrúus kanakɗa hayya, deeƴca meƴdohha kanak ciliis, woꞌꞌa an: «Kiyaakii, fu ereeroo hanjaꞌ-wúrúus kanak. Mi lëgëyya ga. Uuna, kanak ciliis cee.» ");
INSERT INTO snf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Haꞌ-kaadaagari woꞌꞌari an: «Waw guureway fu súrga yijófíꞌ ee fu goꞌ. Fu enin goꞌ ga iñaa yewinndii, mi hayyaa kiꞌeꞌ fu kuliyuk ga yiyewin. Hay fu bok kineɓluk na haꞌ-kaanfu.» ");
INSERT INTO snf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Lëehíꞌta súrgaa eꞌsee hanjaꞌ-wúrúus wíinoo doŋɗa hayya, deeƴca woꞌꞌa an: «Kiyaakii, mi ínoheera an fu ɓoꞌ yisúwíꞌ ga keeñ: fu píiki daa fu sokkii ee fu nëgírohi daa fu faaꞌtii. ");
INSERT INTO snf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mi niikee hen, kërí tah mi acca ga kakay mi ɗaakka kopariigaraa ga. Uuna, fu laasin yenfu.» ");
INSERT INTO snf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Haꞌ-kaanci taassari an: «Fu súrga yibóníꞌ ee fu sagoh-coonu. Fu ínoheera an mi píiki daa mi sokkii ee mi nëgírohi daa mi faaꞌtii. ");
INSERT INTO snf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Fu jomee kiwútíroh hëelísiigoo hen. Eneenaa mi hayaa, mi laaswa na iñaa wa límɗa.» ");
INSERT INTO snf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haꞌ-kaadaa woꞌꞌa súrgacaagari an: «Diima, teꞌat hanjaꞌ-wúrúusumgari ɗú eꞌwa yum ɓay cidaaŋkaahɗa. ");
INSERT INTO snf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","En kiꞌenaa, ɓaa laakin hay kiɓaatɗu bi ya dóoyíꞌ sëk, wayee ɓaa laakoo, kiꞌiñkaa ya ɓayɗa sah hay kiteꞌu. ");
INSERT INTO snf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Súrguma laakoo jeriñɗa jafatti ga fooh, ga ñúusaa, daa kikodukoh na kiꞌúñoh sís ƴah kilaakɗa.» Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","- Bëríinaa Kowukii ɓii taaban na malaakacaagari ɓéeɓɓa, ya hay ga ɗuuƴ ndamaagarinaa, ya hay kiyuŋ ga baŋ-buuraagari. ");
INSERT INTO snf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɓéeɓ heetcii hay kihídírukohu ga fíkíici. Lëehíraa, ya hëgísoh ɓuwii kom kanak fodaa daa níiroh hëgísohi baal na peꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɓuwii júwinɗa, ya hanohiꞌɓa yah-ñaabaagari ee ɓii júwussiiɗa ya hanohiꞌɓa yah-segaagari. ");
INSERT INTO snf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Fodaama, Buuraa hay kiwoꞌ ɓuwaa hanohhi yah-ñaamɗa an: «Ɗú ɓii Paammboo barkeelinɗa, hayat ɗú ɓeɓ iñii ɗú jom kilam ga nguurii waayukɗuseerúu ga iñaa ëldúna saksee bi watiɗa. ");
INSERT INTO snf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mi yaaweera, ɗú onndaroo mi ñammba. Mi píleera, ɗú onndaroo mi annda. Mi eneera sagac, ɗú ɗapparoo. ");
INSERT INTO snf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi teseeɗa dúŋ, ɗú ekkaroo kúltí. Mi ɗúukooleera, ɗú hayyaroo kihaltuk. Mi laŋseera ga kasu, ɗú hayyaroo kiwaak.» ");
INSERT INTO snf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Fodaama ɓuwaa ɓijúwíꞌɓaa hayyi kitaas an: «*Haꞌmudii, ɗí hoteeraa kera lak fu yaawin, ɗí onndaraa fu ñam? Ɗí hoteeraa kera lak fu pílin, ɗí onndaraa fu an? ");
INSERT INTO snf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɗí hoteeraa kera lak fu sagac, ɗí ɗapparaa? Ɗí hoteeraa kera lak fu tesin dúŋ, ɗí ekkaraa kúltí? ");
INSERT INTO snf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɗí hoteeraa kera lak fu ɗúukoolin wala fu laguunun ga kasu, ɗí hayyaraa kiwaak?» ");
INSERT INTO snf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Buuraa hayɓa kitaas an: «Mi woꞌꞌúuka ee kayoh; kotaa en ɓéeɓ, waa ɗú moseera kidímal yíinoo ga ɓuwiigoo ɓii wëñ kijutuutɗa, mi yërí ɗú tumɗeeka.» ");
INSERT INTO snf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Lëehíraa Buuraa hay kiwoꞌ ɓuwaa hanohhi yah-seŋɗa an: «Úsaayattoo, ɗú ɓii Kooh cojinɗa. Aawat kiwiikaa ƴímoo taaꞌ fetɗusee Seytaani ya na malaakacaagariɗa! ");
INSERT INTO snf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mi yaaweera ee ɗú onndiiroo mi ñam. Mi píleera ee ɗú onndiiroo mi an. ");
INSERT INTO snf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi eneera sagac ee ɗú ɗappiiroo. Mi teseeɗa dúŋ ee ɗú ekkiiroo kúltí. Mi ɗúukooleera, mi laŋseera ga kasu ee ɗú haltukkiiroo.» ");
INSERT INTO snf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ɓaama ɓan, hayyi kitaas an: «Haꞌmudii, ɗí hoteera kera lak fu yaawin wala lak fu pílin, wala lak fu sagac, wala lak fu tesɗa dúŋ, wala lak fu ɗúukoolin, wala lak fu laguunun ga kasu ee ɗí dímalliiraa?» ");
INSERT INTO snf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Buuraa hayɓa kitaas an: «Mi woꞌꞌúuka ee kayoh; kotaa en ɓéeɓ, waa ɗú sageera kidímal yíinoo ga ɓuwii ɓii wëñ kijutuutɗa, mi yërí ɗú saŋɗeeka kitumiꞌ ɓan.» ");
INSERT INTO snf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Fodaama, ɓuwaa ɓaama hay kiɓayu ga ngeeꞌcaa leehoo taaꞌɗa, ee ɓuwaa júwinɗa ɓayu ga kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ga waa Yéesu lëehíꞌta kiwoꞌ iñcaa ya waaree ɓuwaa kelohɗa, ya woꞌꞌa tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","- Ɗú ínohin an tes ga bes kanak feetii Paakii leꞌ, ee Kowukii ɓii hay kitíku ga yah ɓuwii sagoh nariɗa, ka daayu ga kuraa. ");
INSERT INTO snf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wiima lak Sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa hídírukohuunun ga kaan Kayíf, haꞌ-kaadaa sarahohcaa ɓiyaakɓaa, ");
INSERT INTO snf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ɓa júwohha ga kiꞌam Yéesu ndaŋ, ee ken yéegoo, ɓa aplukki. ");
INSERT INTO snf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɓa woꞌꞌa nak an: - Ɗu hanatka kitum ga besaa feetaa, enndiikanaa iñaama hay kihaydoh coow wiyaak ga ɗuuƴ ɓuwii. ");
INSERT INTO snf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Daa Yéesu enee ga dëkaa Bétaníi ga kaan Simoŋ yaa gaanaꞌeeɗa, ");
INSERT INTO snf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","laakka ɓetifaa hay gari, ɓay kujúlúŋkaa hëwrohu atohaa woꞌu Albataaꞌ ee ja líifin na laꞌkoleñ wiséeríꞌ. Ɓetifaa íiffa laꞌkoleñaa ga hafaa Yéesu, lak yaama yaa ñam. ");
INSERT INTO snf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Daa tëelíbéecaa hotee iñaama, ɓa aylukka, ɓa ɓaa woꞌ an: - Kiyasohkuma jeriñ ya? ");
INSERT INTO snf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɓoꞌ míneerawa moos kitoon kopaꞌ wiyewin, wa dímalohu nduulcii! ");
INSERT INTO snf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yéesu ínohha iñaa ɓa woꞌɗa, ya woꞌꞌaɓa an: - Ɗú sodaloh ɓetifii ya? Iñii ya tumiꞌtooɗa jekin. ");
INSERT INTO snf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nduulcii, ɗú ɓii naɓa besaa en ɓéeɓ, wayee mi, mi ƴahhii narúu kiꞌen dii besaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ɓetifii leef laꞌkoleñ ga faanfiigoonaa, ya tumka kiwaayuk loyaagoo. ");
INSERT INTO snf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mi woꞌꞌúuka ee kayoh; ga daa Hewhewii winéwíꞌwii wii mín kiyéegalohu ga ëldúna tóoh, iñii ɓetifii fii tumɗa hay kiɓéestíru, ee ɓuwaa hayyika kiníindísukoh. ");
INSERT INTO snf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Waa ennda ɗa, yíinoo ga ɓidaaŋkaah na ɓanakɓaa, ee ya teeku Yúdaa Iskariyot, kaꞌta ga sarahohcaa ɓiyaakɓaa, ");
INSERT INTO snf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ya woꞌꞌaɓa an: - Mi tík Yéesu ga yahhúunaa ɗú fayanndoo hín na? Sarahohcaa ɓiyaakɓaa kídussa hanjaꞌ-hëelís cidaaŋkaah-kaahay, ɓa eꞌtari. ");
INSERT INTO snf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iñaa aboh ga wahtaama, Yúdaa yaa heel besaa ya jekelukan bi ya mín kitík Yéesu ga yahɓa. ");
INSERT INTO snf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ga besaa ɗeɓ ga feetaa ñamsi mbúurúcaa laakoo lëwíiꞌɗa, tëelíbéecaa Yéesu hayussa, ɓa meekissari an: - Fu waaꞌ gada ɗí waayukɗineeraa ñamahii Paakii? ");
INSERT INTO snf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yéesu taassaɓa an: - Karat teeraa ga díw, ɗú woꞌꞌi an: «Jëgírohii woꞌ an: “Wahtiigoo leꞌin ee mi ƴah kipaakoh kaanfu, mi na tëelíbéeciigoo”.» ");
INSERT INTO snf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tëelíbéecaa tumussa iñaa Yéesu nakeeɓaɗa, ɓa waayukka Paakaa. ");
INSERT INTO snf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ga noh-soosaa, Yéesu yuŋnga kiñam na tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa. ");
INSERT INTO snf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lak ɓa ɓaa ñam, ya woꞌꞌaɓa an: - Mi woꞌꞌúuka ee kayoh; yíinoo garúu hayyoo kitoon. ");
INSERT INTO snf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tëelíbéecaa, keeñɓa leehha ga tak, ɓa ɓaa meekissi yíinoo yíinoo an: - Haꞌmudii, mi yëríne? ");
INSERT INTO snf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yéesu taassa an: - Yii bok naroo kiꞌek yah ga kankiiɗa, yërí ƴahhoo kitoon. ");
INSERT INTO snf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kowukii ɓii kii ga waas kikaan fodaa daa Këyítfaa woꞌka gariɗa, wayee massa ɓaa yaama ƴah kitoon Kowukii ɓiiɗa. Ɓaama límséeríinaa, iñaama gënee gari. ");
INSERT INTO snf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yúdaa, yii toon Yéesuɗa meekissari an: - Jëgírohii, mi yëríne? Yéesu taassari an: - Fu woꞌinka! ");
INSERT INTO snf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yéesu ɓeɓpa mbúurú lak ɓa ɓaa ñam, ya gërëmmba Kooh, lëehíꞌta ya weellawa, eꞌtawa tëelíbéecaa, woꞌꞌaɓa an: - Ɓewat ɗú ñam, iñii yii faanfiigoo fërí! ");
INSERT INTO snf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lëehíꞌta ya ɓeɓpa kaas-biiñ, ya gërëmmba Kooh, lëehíꞌta ya eꞌtawa tëelíbéecaa, woꞌꞌaɓa an: - Anat ga ɗú ɓéeɓpúu, ");
INSERT INTO snf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ndaga iñii yii ñífiigoo wërí, ñífii pok kifiiliimunkiigarúu na Koohɗa, ee wa aamɗu ɓoꞌ ɓiyewin doonaa ɓa bayalu baakaaꞌcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi woꞌꞌúuka, aboh ga wati, mi ansisoo anahii wii meyoh ga kedik-biiñɗa bi ga besaa mi anan narúu biiñaa wiꞌaswaa ga Nguuraa Paammbooɗa. ");
INSERT INTO snf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Waa ennda ɗa, ɓa ƴeekka ƴeek-Kañcaa, lëehíꞌta ɓa kaꞌta tëgëlaa Ólíwíyéecaa. ");
INSERT INTO snf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Waa ennda ɗa, Yéesu woꞌꞌa tëelíbéecaagari an: - Ga wekii wati, ɓéeɓpúu ɗú hay kinúp ɗú foñnjoo. En kiꞌenaa, bíduunun ga Këyítfaa an: «Mi hay kiꞌap níirohaa, ee baalcaa yopaa hay kitasaarukohu.» ");
INSERT INTO snf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yéesu tíkka ga an: - Wayee binaa mi mílísaa, mi hayyúu kiɗëwíruk Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peeꞌ dallari kiwoꞌ an: - Luu enee an ɓuwii tesɗa tóoh hay kinúpu foñussa, mi, mi núpoo mi foñnjaa. ");
INSERT INTO snf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yéesu taassari an: - Mi woꞌꞌaaka ee kayoh, ga wekii wati doŋ sah, bi siik-pabu kodaa, fu hayyoo kitaasuk waas kaahay. ");
INSERT INTO snf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wayee Peeꞌ woꞌꞌari an: - Mi taasukooraa múk, luu enee an mi joman kikaan naraa. Tëelíbéecaa ɓéeɓɓa dalla kiwoꞌ fodaama. ");
INSERT INTO snf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wa ennda ɗa, Yéesu na tëelíbéecaagari karussa ɗekataa woꞌu Getsemanee, ya woꞌꞌa tëelíbéecaagari an: - Yugat dii, mi paaf fíkíi kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya ɓayya Peeꞌ na towutaa Sebedee tanaktaa, ɓa taam nari. Keeñci dalla kileeh, ya yëecírukka fíw. ");
INSERT INTO snf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ya dallaɓa kiwoꞌ an: - Keeñnjoo leehin bi mi yii kaanan. Tesat dii naroo ee kaa neehat. ");
INSERT INTO snf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya kaꞌta bi ga fíkíi, ya ƴíꞌꞌa, yíppa púk kakay, yaa kíim Kooh an: «Buba, en lak mínukinaa, úsaayɗaa kaas-coonii wii garoo. Wayee hanat kiꞌen fodaa daa mi waaꞌɗa wayee enat fodaa daa fu waaꞌɗa.» ");
INSERT INTO snf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ya sooffa ga tëelíbéecaa ɓaahayɓaa, ya laakkaɓa ɓaa neeh, ya woꞌꞌa Peeꞌ an: - Kon ɗú mínndii kiwíisoh luu enee sah wahtu wíinoo, waa ɗú yugan naroone? ");
INSERT INTO snf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kaa neehat ee kíimat Kooh doonaa ɗú keenoo ga fíraa Seytaani. Ɓoꞌ daal, keeñaa waarin wayee faanfaa tookkii. ");
INSERT INTO snf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya úsaaysissaɓa kotaa kukanakkaa, ya yaa kíim Kooh anee: «Buba, en lak kaas-coonii wii mínoo kipaaf, ee an mi jomwa kiꞌan henaa, kon iñaa fu waaꞌɗa laakat.» ");
INSERT INTO snf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya soofissa gaɓa, ya laakkaɓa ɓaa neeh ndaga lak hascaagaɓa abin pëní. ");
INSERT INTO snf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ya foñissaɓa daama, ya úsaayissa daa karam, ee kotaa kukaahaykaama, ya yaa kíim na woꞌeencaa caca. ");
INSERT INTO snf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Waa ennda ɗa, ya soofissa ga tëelíbéecaa, ya woꞌꞌaɓa an: - Ɗú ɓii lís kineeh na kiꞌíikaruke? Wahtii leꞌin kimma, Kowukii ɓii kii ƴah kitíku ga yah tumoh-baakaaꞌcii. ");
INSERT INTO snf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kolkat, ɗu ƴee! Malkat yii ƴahhoo kitoonɗa yii deeƴ. ");
INSERT INTO snf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lak Yéesu yaa lís kiwoꞌ, Yúdaa Iskariyot yaa bok ga tëelíbéecaa ɓidaaŋkaah na ɓanakɓaaɗa dalla kileꞌ. Laakka ɓoꞌ ɓiyewin ɓaa taam nari, ɓayuunun kalaɓ, na dooꞌ. Sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa ɓërí woseeɓa. ");
INSERT INTO snf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yii on Yéesu bíiŋɗa eree ɓuwaa lëdíꞌ an: «Ɓaa mi ƴah kifuunɗa yërí ya, abatti.» ");
INSERT INTO snf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Daa Yúdaa leꞌee, ya dalla kideeƴ ga Yéesu woꞌꞌari an: - Hóowíra Haꞌmudii! Ya dalla kifuun Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yéesu loffari an: - Fiilii! Iñii haydohhaaɗa tumaari. Waa ennda ɗa, ɓuwaa taam na Yúdaaɗa deeyussa, tíkussa yah ga Yéesu, abussari. ");
INSERT INTO snf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ga ɗekataama, ga ɓuwaa taabee na Yéesuɗa, yíinoo dalla kiɗol kalaɓfaagari, típpafa súrgaa haꞌ-kaadaa sarahohcaa ɓiyaakɓaa, ɓaydohha nofaa. ");
INSERT INTO snf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wayee Yéesu woꞌꞌari an: - Íkaa kalaɓfiigaraa ga huuwii, ndaga ɓaa fu dëk ga kiɓewiꞌ ɓoꞌ kalaɓ ɓéeɓ kalaɓ apanndaa. ");
INSERT INTO snf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hanaa fu ínohoo an mi mínin kikíim Paammboo dímal ee ga saasi ya wosohhoo malaakacaa wëñ ɓijúnni-daaŋkaah-kanak (20.000), ɓa heñohiꞌtoone? ");
INSERT INTO snf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wayee baanaa iñaa bídu ga Këyítfaaɗa tuman na bi wa mat? En kiꞌenaa, fa woꞌin an tóoh jomɗa kilaakoh. ");
INSERT INTO snf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Waa ennda ɗa, Yéesu woꞌꞌa mbooloomaa an: - Mateera ga ɗú hayyoo kiꞌam, ɗú taam na kalaɓcii na dooꞌcii, man na ɓuwaa dawuk tumoh-kofeele? Mi enee ga Kaanfaa Kooh besaa en ɓéeɓ, mi jëgírohi ee ɗú mossiiroo kiꞌam. ");
INSERT INTO snf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wayee iñii yii ɓéeɓ laakin doonaa iñaa sëldíiga-Koohcaa woꞌee, bídussa ga Këyítfaaɗa, mat. Waa ennda ɗa, tëelíbéecaa ɓéeɓɓa foñussari ɓaa núp. ");
INSERT INTO snf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓuwaa abee Yéesuɗa ɓayussari kaan Kayíf, haꞌ-kaadaa sarahohcaa ɓiyaakɓaa, ga daa jëgíroh-waascaa na yaakcaa hídírukohseeɗa. ");
INSERT INTO snf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peeꞌ yaa taabukki diꞌúsaayíꞌ bi ga hëtaa kaanfaa sarahohaa yiyaakyaa kuliyukɗa. Ya aassa bi ga ɗuuƴ, ya yuŋnga na súrgacaa kiꞌínoh daa iñaama mëeñjohanɗa. ");
INSERT INTO snf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sarahohcaa ɓiyaakɓaa na ɓéeɓ ɓuwaa bok ga paanaa yaawúuꞌcaa wiyaakwaaɗa, ɓaa heel woꞌeenaa ɓa pokɗan Yéesu bi ɓa mínndi kiꞌapluk. ");
INSERT INTO snf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wayee ɓa hottii, hídaa daa ɓoꞌ ɓiyewin hayseera daama kipokiꞌti kiwoꞌɗa. Ɓoꞌ ɓanak mëeñjohha kihay, ");
INSERT INTO snf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","woꞌussa an: - Ɓii yii woꞌ an: «Mi mínin kipook Kaanfaa Kooh, mi tuukirisfa ga bes kaahay.» ");
INSERT INTO snf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Haꞌ-kaadaa sarahohcaa kolukka woꞌꞌa Yéesu an: - Fu taasoo dara ga iñii ɓuwii ɓii yammbaaɗane? ");
INSERT INTO snf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wayee Yéesu taassii. Haꞌ-kaadaa sarahohcaa meekissari an: - Ga Kooh yii laak kipesɗa, woꞌꞌaaríi ati fu yërí en Kiristaanii, Kowukii Kooh. ");
INSERT INTO snf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yéesu taassari an: - Fu woꞌinka. Ee sah mi woꞌꞌúu an, iñaa aboh diima, ɗú hay kihot Kowukii ɓii yuŋ, hanoh yah-ñaabaa Kooh yii wëñ ɓéeɓ dooliɗa, ee ɗú hayyi kihot ga ɗuuƴ yaayeelcii asamaan, ya yoosuki. ");
INSERT INTO snf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Daama, Haꞌ-kaadaa sarahohcaa ɗaꞌta kúltícaagari ndaga kiꞌayluk, ya woꞌꞌa an: - Ɓasin Kooh! Ɗu enohis seedi ya? Ɓéeɓpúu ɗú keloh ga, ɓasin Kooh. ");
INSERT INTO snf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɗú ínoh ya ga? Ɓa taassa an: - Yii kay, jom kiꞌapu hen! ");
INSERT INTO snf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Waa ennda ɗa, ɓa aawwari kitoos ga fíkíi, ɓa ɓaa dúukisohhi, ɓíinoo ɓaa mútti paꞌcaa, ");
INSERT INTO snf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɓa ɓaa woꞌꞌi an: - Fu Kiristaanii, líiruka, woꞌaaríi ɓii feekkaaɗa? ");
INSERT INTO snf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peeꞌ nak, lak ya yuŋnga ga fooh, ga hëtaa kaanfaa haꞌ-kaadaa sarahohcaa, laakka súrga yiɓeti yaa deeƴ gari, woꞌꞌari an: - Fu ɓan fu enee na Yéesu, ɓaama dëk Gëlíléeɗa! ");
INSERT INTO snf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wayee Peeꞌ taasukka ga fíkíi ɓéeɓ, woꞌꞌa an: - Mi ínohoo iñii fu waaꞌ kiwoꞌɗa! ");
INSERT INTO snf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lëehíꞌta, ya kolukka yaa ƴah ɓak hal-kaadaa. Laakka súrga yiliis yiɓeti yaa hotti, woꞌꞌa ɓuwaa enee daamaɗa an: - Ɓii yii enee na Yéesu Nasareet! ");
INSERT INTO snf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peeꞌ waatukka, taasukissa an: - Mi ínohoo ɓaa yaama! ");
INSERT INTO snf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ennda kiis, ɓuwaa enee daamaɗa deeyussa gari, woꞌussari an: - Fu ɓan, fu joman kibok gaɓa, ndaga dii fu woꞌiɗa teewohin ga dii fu meyohɗa. ");
INSERT INTO snf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Daama, Peeꞌ ennda ga kicojuk na kiwaatuk, ya taasuuka an: - Mi ínohoo ɓaa yaama! Ga saasi siik-pabaa konnda. ");
INSERT INTO snf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peeꞌ níindísukka iñaa Yéesu woꞌeeri an: «Bi siik-pabu kodaa, fu hayyoo kitaasuk waas kaahay.» Peeꞌ dalla kimeƴ yaa koduk mooncaa leehoo. ");
INSERT INTO snf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ga kímaa cuut, sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa, ɓéeɓɓa hídohussa kimalak daa ɓa tuman bi ɓa apluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓa ɓaŋlukkari, ɓa ɓayyari, ɓa tíkkari ga yah Pílaat gúwernëeraa. ");
INSERT INTO snf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ga waa Yúdaa, yaa toonee Yéesuɗa, ínohha an Yéesu tíkuunun kikaan, ya récukka iñaa ya tumeeɗa, ya kaꞌta ga sarahohcaa ɓiyaakɓaa na yaakcaa dëkaa kiꞌíkɓa hanjaꞌ hëelíscaa cidaaŋkaah-kaahaycaa ɓa fayeeriɗa. ");
INSERT INTO snf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya woꞌꞌaɓa an: - Mi tumin baakaaꞌ ndaga mi erohin ɓaa tummbii dara, ya apunee. Ɓa taassari an: - Waassíi wíinoo gaa ga! Fu yërí ínoh! ");
INSERT INTO snf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yúdaa jaffa koparaa ga ɗuuƴ Kaanfaa Kooh, ya meƴca, ya kaꞌta kipokuk níꞌ ga koonaakaa ya harukka. ");
INSERT INTO snf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sarahohcaa ɓiyaakɓaa balawussa koparaa, ɓa woꞌꞌa an: - Koparii wii jomoo kiꞌatukohu na wii Kaanfii Kooh ndaga wa lomohsee ñíf ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɓa hídohha, ɓa júwohha ga kiɓeɓ koparaa, ɓa lomohwa yoonaa «hëwíroh-kataanaa.» Ga yoonaama, ɓa enohwa kimín kiꞌac ɓuwaa en sagac ga dëkaaɗa, binaa ɓoꞌ kaan gaɓanaa. ");
INSERT INTO snf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kërí tah bi ga wati yoonaama ɓaysi “yoonaa ñífaa”. ");
INSERT INTO snf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Fodaama iñaa Yérémíi, sëldíiga-Koohaa woꞌeeɗa matta. Ya woꞌee an: «Ɓa ɓeɓpa hanjaꞌ-hëelíscaa cidaaŋkaah-kaahaycaa, ee wërí en cadamfaa ɓu-Isarayeel tookee kifay gariɗa, ");
INSERT INTO snf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓa ekkaca ga kilom yoonaa “hëwíroh-kataanaa” fodaa daa Haꞌmudii nakeerookaɗa.» ");
INSERT INTO snf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Waa ennda ɗa, Yéesu ɓayussa ga fíkíi gúwernëeraa, yaama meekissari an: - Fu yërí en buurii yaawúuꞌciine? Yéesu taassari an: - Fu yii woꞌka. ");
INSERT INTO snf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wayee ya taassii dara ga iñcaa sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa yabeeriɗa. ");
INSERT INTO snf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pílaat woꞌꞌari an: - Iñcii fu yabu ɓéeɓcaɗa, fu kelohincane? ");
INSERT INTO snf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wayee Yéesu taassiiri ga wíinoo gaca. Iñaama jaahalla gúwernëeraa lool. ");
INSERT INTO snf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ga feet Paakaa en ɓéeɓ gúwernëeraa méyíꞌɓa ɓoꞌ yíinoo ga ɓuwaa abu ga kasuɗa, yaa mbooloomaa waaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Waama lak laakin ɓaa abu ga kasu, ya teeku Barabaas ee ɓéeɓ ínohinndi. ");
INSERT INTO snf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pílaat meekissa mbooloomaa hídírukohee daamaɗa an: - Ɗú waaꞌ mi méyíꞌtúu Barabaasoo Yéesu yii teeku Kiristaaniiɗa? ");
INSERT INTO snf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","En kiꞌenaa, Pílaat ínoheera an kiꞌiñaan tah ɓa haydohha Yéesu gari. ");
INSERT INTO snf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɓetici wosohha gari, wiima lak ya yii yuŋnga ga daa attiꞌohsiɗa, kiwoꞌꞌi an: «Watukaa kiꞌek haffu ga loo ɓuyum yijófíꞌyuma, ndaga wekama mi heeyin gari ee mi sodeera lool ga heeyaa.» ");
INSERT INTO snf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa sorussa ɓuwaa nof, ɓa meekis Pílaat ya meƴdohiꞌɓa Barabaas ee ya apluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wayee Pílaat meekissa mbooloomaa an: - Yiida ga ɓuwii ɓanakɓii ɓii yërí ɗú waaꞌ mi méyíꞌtúu? Ɓa taassa an: - Barabaas! ");
INSERT INTO snf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pílaat meekissaɓa an: - Kon Yéesu yii teeku Kiristaaniiɗa mi tumanndi na? Ɓéeɓɓa taassa an: - Daayaari ga kuraa! ");
INSERT INTO snf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wayee Pílaat meekisissaɓa an: - Ya tum ya yibóníꞌ? Wayee ɓa ɓaa wëñ kifiip didóolíꞌ an: - Daayaari ga kuraa! ");
INSERT INTO snf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ga waa Pílaat ínoh an ya mínoo dara ga, ndaga coowaa waa wëñ kiɓaatuk, ya heella músú, ɓuuñukka ga fíkíi mbooloomaa, ya woꞌꞌa an: - Duuroo wíinoo gaa ga ñífii ɓii yii; ɗú ɓërí ínoh. ");
INSERT INTO snf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓéeɓ mbooloomaa taassa an: - Ee laa wa kípukat ga haffíi na ɗook towutiigaríi. ");
INSERT INTO snf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Waa ennda ɗa, Pílaat méyíꞌtaɓa Barabaas, lëehíꞌta ya ríplukka Yéesu, ya erohhari kidaayunee ga kuraa. ");
INSERT INTO snf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Waa ennda ɗa soldaaꞌcaa gúwernëeraa paafdohha Yéesu ɗuuƴ kaanfaa gúwernëeraa, ɓa nëgírohha soldaaꞌcaa fodaa gaɓaɗa ɓéeɓɓa, ɓa wíillari. ");
INSERT INTO snf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓa ɗolla kúltícaagari, ɓa ekkari kúltí filiis fiyoꞌoh cor. ");
INSERT INTO snf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓa teꞌta iñaa man na baanu-buuꞌ ee teru na lúp, ɓa ekkariwa ga hafaa. Ɓa eꞌtari dooꞌ-barah ya ammba ga yahaa ñaabaa, lëehíꞌta ɓa ƴíꞌꞌa ga fíkíici, ɓaa ñaawalsohhi: - Pesa buurii yaawúuꞌcii! ");
INSERT INTO snf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓa ɓaa toossi, ɓa teꞌꞌa dooꞌ-barahaa, ɓa ɓaa feekkiwa ga haf. ");
INSERT INTO snf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ga waa ɓa lëehíꞌtari kiñaawalsoh, ɓa ɗolla kúltífaa fiyoꞌohfaa, ɓa ekissari kúltícaagari, lëehíꞌta ɓa ɓayyari kidaaƴnee ga kuraa. ");
INSERT INTO snf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ga waa ɓa en na kiƴahɗa, ɓa hídukohha na ɓoꞌ yiƴaal yaa dëk teeraa Síreen ee teeku Simoŋ. Ɓa gítínndari kiníkuk kuraanaa Yéesu ƴah kidaayohuɗa. ");
INSERT INTO snf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓa kaꞌta bi ga ɗekataa woꞌu Golgotaa, wërí en «loon-haf». ");
INSERT INTO snf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɓa eꞌta Yéesu biiñaa atukohu na enaama yiꞌëeyíꞌ en fan gít. Daa ya ƴoohee biiñaa, ya saŋngawa kiꞌan. ");
INSERT INTO snf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɓa daaƴcari ga kuraa, ɓa yípohha tidooꞌ kiwaroh kúltícaagari. ");
INSERT INTO snf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lëehíꞌta ɓa yuŋnga daama, ɓa ɓaa watukki. ");
INSERT INTO snf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓa daaƴca kuhaanga tíimmba hafaa Yéesu kiteewoh iñaa tah ya apuɗa. Ɓa bínnda ga an: «Ɓii yii yërí en Yéesu buurii yaawúuꞌcii.» ");
INSERT INTO snf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɓa daaƴca ɓan ga yahaaci tumoh-kofeel ɓanak: yii hanohhari yah-ñaam, yíinoo ga yah-seŋ. ");
INSERT INTO snf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓuwaa kooree daama ɓaa paafɗa, ɓaa këkít haf, ");
INSERT INTO snf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɓa ɓaa ɓassi an: - Aca! Fu yii fu woꞌ an fu ƴah kipook Kaanfaa Kooh ee fu tawahisfa ga bes kaahayɗa, somaa haffu. En lak fu en Kowukii Koohaa, yoosukaa ga kuraanii! ");
INSERT INTO snf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa na yaakcaa yaawúuꞌcaa ɓan, ɓaa ñaawalsohhi, ɓaa woꞌ an: ");
INSERT INTO snf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","- Ya somin ɓuwaa ɓíinoo ee ya mínoo hafci kisom. An yërí en buurii ɓu-Isarayeele? Kon ya yoosukat diima-diima ga kuraanii ɗí hot, ɗí gëm gari. ");
INSERT INTO snf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ya tíkee yaakaaꞌci ga Kooh. En lak Kooh keeñukinndinaa, ya músalatti diima ndaga yërí woꞌ an ya Kowu Kooh. ");
INSERT INTO snf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bi ga tumoh-kofeelcaa ɓanakɓaa daaƴsee ga kuraanaa fodaa gariɗa ɓaa ɓassi fodaama ɓan. ");
INSERT INTO snf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ga wahtaa nohaa tuuk ga ɗookɗa, bi ga wahtu kigoonaluk, Kooh ñúussa kërúus ga kúlkaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ee ga wahtu kigoonaluk, Yéesu lessa koonaa kiyaak an: - Élí, Élí, lema sabaktani? (Wërí en an: «Koohyiigoo, Koohyiigoo, iñii tah ya fu foñnjoo?») ");
INSERT INTO snf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ga ɓuwaa enee daamaɗa, laakka ɓuwaa daa ɓa keloheeri, ɓa dalla kiwoꞌ an: - Ya yii ɓay Ili! ");
INSERT INTO snf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yíinoo gaɓa dalla kifool, ɓeɓpa epoos, pokkawa ga siñdaa dooꞌ, ñoonndawa ga biniigaꞌ, eꞌta Yéesu ya ɗuuƴwa. ");
INSERT INTO snf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɓuwaa ɓíinoo nak ɓaa woꞌ an: - Íisat rek ɗu malak ati Ili hayyi kihay kisom ati na! ");
INSERT INTO snf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wayee Yéesu lesissa koonaa kiyaak, ya lëehɗukka. ");
INSERT INTO snf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ga wahtaama, rídóonaa wiyaakwaa poksee ga Kaanfaa Kooh, kún ɗekataa wëñ kiselaꞌɗa dalla kiɗaꞌ kom kanak, aboh ɗook bi ga kakay. Kakayfaa faa yëngëluk, atohcaa caa ɓëlgískoh. ");
INSERT INTO snf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Loy ciyewin lëgísukka, faraaf ɓoꞌ-Kooh ciyewin mílíssa ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓa tessa da bi ga daa Yéesu mílísohɗa, ɓa ɓaa han kiꞌaas Yéerúsaleem, teeraa wiselaꞌíꞌwaa, ɓa feeñukka ga ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldaaraa kuliyuk ga ɓoꞌ ɓitéeméeꞌ ga heñɗa, na ɓuwaa taabee nari kiwatuk Yéesuɗa hotussa daa kakayfaa yëngëluɗa na iñcaa laak caama, ɓa tíitta lool, ɓa ɓaa woꞌ an: «Kayoh-kayohɗa, ɓii yii enee Kowu Kooh!» ");
INSERT INTO snf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Ɓeti ɓiyewin enee daama, ceelussa palah ɓaa malak. Mërí-Malleen, Mërí eew Saak na Yoseef na eew towutaa Sebedee. Ɓeticaama ɓërí meyohee na Yéesu gohaa Gëlílée ee ɓa toputuꞌiri. ");
INSERT INTO snf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ga noh-soosaa ɓoꞌ yilëekíꞌ-alal, yaa dëk Arímatee ee teeku Yoseef, hayya. Ya bokee ga tëelíbéecaa Yéesu ɓan. ");
INSERT INTO snf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ya kaꞌta ga Pílaat, ya meekissari faraaffaa Yéesu. Pílaat nakohha ya erufa. ");
INSERT INTO snf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yoseef ɓeɓpa faraaffaa, múullafa ga píis perkaal wiꞌas mac. ");
INSERT INTO snf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ya faanneerafa ga loy wiꞌas waa ya yotɗee hafci ga atoh, ya pírgínnda atoh wiyaak ga kúuwkaa loyaa, ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mërí-Malleen na Mërí yaa yíinooyaa lak ɓa yugin, jaanohuunun na loyaa. ");
INSERT INTO snf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ga kooh-wíisfaa tík ga besaa waayukaa Sabatɗa, sarahohcaa ɓiyaakɓaa na Fërísiyeeŋcaa hayussa ga Pílaat. ");
INSERT INTO snf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɓa woꞌꞌari an: - Kiyaakii, ɗí níindísukin an ɓaa yaama woꞌoo kayohɗa, woꞌeera lak ya yaa lís kipes an: «Tík ga bes kaahayaa mi hay kimílís», ");
INSERT INTO snf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","kon ebilaa ɓiɓoꞌ ɓa watuk loyaa dii bi ga bes kaahay. Enndiikanaa tëelíbéecaagari mínin kikaru ɓa lok faraaffaa, ɓa woꞌ ɓuwii an: «Ya mílísin ga ɓuwaa kaaninɗa.» Ee baanaa sabohfii tíkan gaɗa wëñan fiɗewaafaa kiyak. ");
INSERT INTO snf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pílaat taassaɓa an: - Soldaaꞌcum ɓooma, ɓayatɓa, ɗú watukiꞌ haffúu loyaa daa ɗú waaꞌ. ");
INSERT INTO snf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓa kaꞌta kimalak ga daa loyaa manɗa, ɓa tummba lëdíꞌ ga atohaa laŋwaɗa doonaa ɓaa leꞌ ga tóoh ɓoꞌ ínoh. Ɓa foñnja soldaaꞌcaa daama, ɓaa watukwa. ");
INSERT INTO snf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Teel ga kímaa dímaasaa, lak besaa Sabat paafin, Mërí yaa dëk Makdalaaɗa na Mërí yaa yíinooyaa, karussa kimalaknee loyaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kakayfaa dalla kiyëngëluk didóolíꞌ, laakka malaakaa Kooh yoosukoh asamaan, ya pírgínnda atohaa wiyaakwaa lagohsee loyaaɗa, ya yuŋnga ga ɗook gaa. ");
INSERT INTO snf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya mannda na melic kileeꞌ, kúltífaagari yaanaawwa ɗer fan perkaal. ");
INSERT INTO snf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɓuwaa watukee loyaaɗa, tíitussa bi ɓaa kaanan. ");
INSERT INTO snf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wayee malaakaa woꞌꞌa ɓeticaa an: - Kaa tíitat, mi ínohin an ɗú raas Yéesu yaa daaƴsee ga kuraanaaɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ya enissii dii. Ya mílísin fodaa ya woꞌeekaɗa. Hayat gii, ɗú malak dii ya faanseeɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gaawat kikaꞌ, ɗú woꞌnee tëelíbéecaagari an: Yéesu mílísin ga ɓuwaa kaaninɗa. Ya ɗëwírukinndúu Gëlílée, ɗú hotohnanndi daama. Kon iñuma yërí mi ƴaheerúu kiwoꞌ. ");
INSERT INTO snf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɓeticaa gaawussa kimeƴ loyaa. Ɓa tíiteera wayee keeñɓa sooseera lool ɓan. Ɓa ɓaa fool kiyéegal tëelíbéecaa Yéesu iñaa hewɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Balaa ɓa leꞌanaa, Yéesu hídohha naɓa, woꞌꞌaɓa an: - Mi yii këñíꞌtúu. Ɓeticaa deeyussa gari, ŋuluucukussa ga kotcaa, ɓaa jaamukki. ");
INSERT INTO snf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Waa ennda ɗa Yéesu woꞌꞌaɓa an: - Kaa tíitat! Karat, ɗú woꞌnee tëelíbéecaagoo an ɓa karat Gëlílée: ɓa hotohnanndoo daama. ");
INSERT INTO snf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ga wii ɓeticaa en na kiƴahuɗa, ga soldaaꞌcaa naksee kiwatuk loyaa Yéesu acohseeɗa, laakka gaɓa ɓaa ɓoyuk teeraa, ɓa ɓéestíꞌta sarahohcaa ɓiyaakɓaa tóoh iñcaa laakeeɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sarahohcaa ɓiyaakɓaa dalla kihídírukohu na yaakcaa yaawúuꞌcaa, ɓa júwohha ga kiꞌeꞌ soldaaꞌcaama hëelís wiyewin, ");
INSERT INTO snf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɓa woꞌꞌaɓa an: - Ɗú karaa, woꞌat an tëelíbéecaa ɓaa yaama ɓërí hay ga wek, ɓa lokka faraaffaagari lak ɗí ɓaa neeh. ");
INSERT INTO snf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","En ɗanaa gúwernëerii yéeŋkanaa ɗí hay nari kimín kiwoꞌ bi dara hokoorúu ga. ");
INSERT INTO snf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldaaꞌcaa ɓewussa koparaa, ɓa tummba fodaa daa ɓa woꞌseeɗa. Fodaama, ɓéestíraama síwwa ga ɗuuƴ yaawúuꞌcaa ee bi wati ka kii lís kiwoꞌu. ");
INSERT INTO snf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Waa ennda ɗa, tëelíbéecaa Yéesu ɓidaaŋkaahɓaa na yíinooyaa karussa Gëlílée, ga jaŋjagaa Yéesu ebileeɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Daa ɓa hotee Yéesu, ɓa ƴíꞌꞌa, ɓa ɓaa jaamukki. Wayee laakka gaɓa ɓuwaa laak hel kanak ga iñaa ɓa hotɗa. ");
INSERT INTO snf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yéesu deeƴca gaɓa, woꞌꞌaɓa an: - Ga ɗook na dii ga kakay, Paammboo erinndoo dooli ga tóoh. ");
INSERT INTO snf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kon karat ga ɓéeɓ heetcii ga ëldúnaɗa, ɗú tumɓa ɓitëelíbéeroo. Bëtísiꞌatɓa ga teekii Paamudii, wii Kowukii na wii Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yëedíratɓa kitaabuk ɓéeɓ iñcii mi nakkúu kitumɗa. Ee mi, mi yii narúu besaa en ɓéeɓ, bi ga daa ëldúna túkiꞌan.");
INSERT INTO snf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","*Hewhewii winéwíꞌwii woꞌ ga loo Yéesu Kiristaa, Kowukii Koohɗa, daloh anee: ");
INSERT INTO snf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Fodaa daa Ísayíi, sëldíiga-Koohaa bín ga Këyítfaaɗa; Kooh woꞌ da an: «Mi yii wos ɓoꞌꞌoo, yaa ɗëwrukanndaa, kiwaayuk waasumgaraa. ");
INSERT INTO snf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Laakin koonaa-ɓoꞌ, kaa en na kiwoꞌ didóolíꞌ ga ɗuuƴ ëgíꞌ-dúndagaa an: Waayukɗat Haꞌmudii waasii, júwíꞌɗatti tuwaas-waastii!» ");
INSERT INTO snf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɓaama ennda Saŋ. Ya hayya, yaa bëtísiꞌ ɓuwaa ga ëgíꞌ-dúndagaa. Ya yaa jangat an ɓuwaa súpítat kipeskaagaɓa, ɓa bëtísiꞌu, en ɗanaa baakaaꞌcaagaɓa bayalu. ");
INSERT INTO snf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kúlkaa Yúudée tóoh na ɓuwaa dëk Yéerúsaleemɗa ɓaa meƴ ɓaa aaw gari. Ɓa ɓaa récuk baakaaꞌcaagaɓa ga fíkíi ɓéeɓ ee Saŋ yaa bëtísiꞌɓa ga húlúwaa Yúrdeŋ. ");
INSERT INTO snf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Saŋ ekukee kúltífaa terohu na fënúf geeleem, ya pokukka liiɓ-on ga kenohkaa. Ya daanee kiñam paƴ na kúum. ");
INSERT INTO snf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ya jangatee an: - Laakin ɓaa en na kihay ga fenooroo ee yërí wëñnjoo kiyak fúuf. Mi jutuutin sah ga kiɗaal kipëkís liiɓcaa ñafaꞌcaagari. ");
INSERT INTO snf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi, mi bëtísiꞌinndúu ga músú; ya nak, ya bëtísiꞌanndúu ga Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Waa ennda ɗa, Yéesu meyohha dëkaa Nasareet ga gohaa Gëlílée, ya hayya, Saŋ bëtísiꞌꞌari ga húlúwaa Yúrdeŋ. ");
INSERT INTO snf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ga daa Yéesu en na kimeƴ ga músúmaaɗa, ya hotta asamaan lëgísukka. Helaa Kooh, fodii hoꞌ, yaa yoosuk ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Laakka koonaakaa meyoh ɗook Kooh, woꞌꞌa an: - Fu yërí en Kowukiigoo mi keeñukɗa. Keeñnjoo soosin garaa. ");
INSERT INTO snf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga saasi, Helaa yiselaꞌíꞌyaa woocca Yéesu, ɓayyari ɗekat, ëgíꞌ-dúndaŋ. Ya ennda da bes cidaaŋkaah-nikiis. ");
INSERT INTO snf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Waa ya en daama, Seytaani íiséeríiri kifíꞌ. Yéesu enee daama na rapcaa ee malaakacaa ɓaa toputuꞌꞌi. ");
INSERT INTO snf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yéesu kaꞌta gohaa Gëlílée, wiima lak Saŋ abuunun ga kasu. Ya yaa jangat ga gohaama Hewhewaa winéwíꞌwaa meyoh ga Koohɗa. ");
INSERT INTO snf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ya woꞌee an: - Wahtii leꞌin ee Nguuraa Kooh deeyin. Súpítat kipeskiigarúu, ɗú gëm Hewhewii winéwíꞌwii! ");
INSERT INTO snf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Daa Yéesu kooree ga seereenaa giiyaa Gëlíléeɗa, ya hotta mbaaloh ɓanak: Simoŋ na Andari këmëeŋkíci, ɓa ɓaa wees mbaal ga giiyaa. ");
INSERT INTO snf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yéesu woꞌꞌaɓa an: - Taabukattoo, mi hayyúu kitum ɓimbaaloh ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ga saasi, ɓa foñnja mbaalcaagaɓa, ɓa ɓaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ya kaꞌta bi ga fíkíi, ya hotta towutaa Sebedee: Saak na Saŋ, këmëeŋkíci. Ɓa enee ga gaal-loocaagaɓa, ɓaa hëwíraat mbaalcaa. ");
INSERT INTO snf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yéesu dallaɓa kiɓay; ɓa foñnja Sebedee, paamɓa na lëgëyohcaa ga gaal-loocaa, ɓaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yéesu na tëelíbéecaagari leꞌussa dëkaa Kafarnawom. Ga besaa Sabat, Yéesu aassa jaangu-yaawúuraa, ya aawwa kijëgíroh. ");
INSERT INTO snf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɓuwaa waaruꞌseera lool ga jëgírohaagari, ndaga ya en na kijëgírohaa, ya yërëmoo woꞌeenci fodaa jëgíroh-waascaa. ");
INSERT INTO snf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bëríi, laakka ɓaa aas jaangu-yaawúuraagaɓa, ee enee ɓaa laak raɓ. Ya yaa fiip an: ");
INSERT INTO snf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","- Yéesu Nasareet, fu naríi ya? Fu hayyíi kiɗúbíre? Mi ínohin ɓii fu enɗa. Fu yërí en ɓii yiselaꞌíꞌyii meyoh ga Koohɗa! ");
INSERT INTO snf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yéesu gëtta rawaa, woꞌꞌari an: - Ɗekoha, fu meyoh ga ɓii! ");
INSERT INTO snf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Fodaama, rawaa saylukohha ɓaa saylukoh ciméeskíꞌ, lessa koonaa kiyaak, meyohha gari. ");
INSERT INTO snf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɓuwaa enee daamaɗa ɓéeɓɓa jaahliꞌussa ga iñaama, bi ɓa ɓaa woꞌ ga díkaantiɓa an: - Iñii yii man na? Ati jëgíroh wiꞌas! Ɓii yii woꞌi woꞌeen wíinoo, ee bi ga raɓcii sah tumsi iñaa ya nakohɗa! ");
INSERT INTO snf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Meyohha da, teekaa Yéesu dalla kisíw daa en ɓéeɓ ga gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Waa ɓa meyoh jaangu-yaawúuraa, ɓa kaꞌta kaan ɓiSimoŋ na Andari, taabussa na Saak na Saŋ. ");
INSERT INTO snf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lak payam Simoŋ yiɓeti faanukin, tamoh hen. Yéesu dallaka kiyéegalu. ");
INSERT INTO snf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Daa ya leꞌ bi gari, ya ammba yahaa, ɓëwíꞌtari. Ga ɗekataama faanfaa ƴímmba. Lëehíꞌta ya yaa toputuꞌɓa. ");
INSERT INTO snf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga noh-soosaa lak nohaa aasin, Yéesu haydohɗussa ɗúukoolíꞌcaa tóoh na haꞌ-raɓcaa. ");
INSERT INTO snf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ee ɓu-dëkaa tóoh nëgírukohusee ga hal-kaanfaama. ");
INSERT INTO snf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ya wëkíꞌta ɓoꞌ ɓiyewin ɓaa laakin ɗúukoolcaa bokkii. Ya kaalla ɓan raɓ ɓiyewin ga ɓuwaa, ee ya onéeríi raɓcaama kiwoꞌ yen ndaga ɓa ínoheera ɓaa ya enɗa. ");
INSERT INTO snf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga kímaa cuut, lak Kooh lís kiñúus, Yéesu kolukka, ya meƴca yaa ƴah daa wéetin. Daama, yaa kíim Kooh. ");
INSERT INTO snf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoŋ na ɓuwaa ensee nariɗa ɓaa raasussi. ");
INSERT INTO snf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Daa ɓa hoteeri, ɓa woꞌꞌari an: - Ɓéeɓ ɓuwii ɓii raassaa. ");
INSERT INTO snf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ya taassaɓa an: - Ɗu ƴahat ɗekat wiliis, ga dëkcii ga yahaaniiɗa, doonaa mi mín kijangatnee ɓuwaa daamaɗa ɓan. Iñaama yërí tahhoo dii kimeƴ. ");
INSERT INTO snf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Fodaama, ya wíilla Gëlílée tóoh, yaa jangat ɓuwaa ga jaangu-yaawúuꞌcaa, ee yaa kaal raɓcaa ga ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Laakka ɓoꞌ yaa ɓay ɗúukool-gaana hayya ga Yéesu, ƴíꞌꞌa ga fíkíici, yaa kíimmbi an: - Fu waaꞌkanaa, fu míninndoo kiwëkíꞌ. ");
INSERT INTO snf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yéesu laakka yërmaandi wiyaak gari. Ya lëríssa yahaagari, leꞌꞌa ga ɓaa, woꞌꞌari an: - Mi waarinka, waka! ");
INSERT INTO snf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ga saasi, ɗúukool-gaanaa meyohha ga ɓaa, ɓaa wakka. ");
INSERT INTO snf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lëehíꞌta Yéesu dallari kiꞌebil, ɗíŋngari na woꞌeen ciyëgísíꞌ ");
INSERT INTO snf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","an: - Abukaa ga kiwoꞌ ɓoꞌ iñii mi tumiꞌtaaɗa, wayee kara, fu teewohnee haffu ga sarahohaa ee fu tum sarahaa Móyíis nakoh ga kisetkiigaraaɗa. En ɗanaa iñaama hay kiteeɓ ɓéeɓ an fu setin. ");
INSERT INTO snf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɓaa nak meyohha daama, ya ennda ga kiɓéestíꞌ na kilíbaacoh iñaa laakee yaama. Iñaama tahha bi Yéesu mínséeríi kiꞌaas dëk wíinoo ga fíkíi ɓéeɓ; ya nammba kites ga fooh, ga ɗekatcaa laakoo ken, wayee ɓuwaa ɓaa meyoh daa en ɓéeɓ ɓaa hay gari daama. ");
INSERT INTO snf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bes cera tíkka ga, Yéesu sooffa Kafarnawom. Ɓuwaa yéeŋnga an ya yaa ga kaanfaa. ");
INSERT INTO snf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɓoꞌ ɓiyewin nëgírukohussa ga ɗuuƴ kaanfaa, bi laakissii daa ɓoꞌ tuukan, enndii sah ga fíkíi hal-kaadaa. Ya yaa yéegalɓa woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɓiɓoꞌ hayussa gari, haydohɗussi ɓaa lafañin. Ƴaal ɓinikiis ɓërí teembeelussi. ");
INSERT INTO snf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga daa ɓa mínndii gari kideeƴ ndaga mbooloomaa, ɓa nammba kiheel gúl ga cakaraa túuyaa, tíimmba Yéesu ga daa ya eneeɗa. Ɓa yóoskíꞌta gatanaa lafañaa faankohɗa ga gúlaama. ");
INSERT INTO snf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Daa Yéesu hotee ngëmaagaɓa waama, woꞌꞌa lafañaa an: - Ƴaal, baakaaꞌcumgaraa bayaluununndaa. ");
INSERT INTO snf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wiima lak laakin jëgíroh-waascaa yuŋ daama. Ɓaa halaat an: ");
INSERT INTO snf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Iñii tah ɓii yii kiwoꞌ iñaama ya? Ɓasin Kooh! Ɓii mín kibayal baakaaꞌ ɓa, enndii Kooh dogaa?» ");
INSERT INTO snf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yéesu ínohha haat ga helaagari iñaa ɓuwaama halaatɗa. Ya woꞌꞌaɓa an: - Iñii tah ya ɗú halaat iñuma ga helciigarúu? ");
INSERT INTO snf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kon iñii yiida wëñ kiyooɓ kiwoꞌ lafañii: kiwoꞌꞌi an «Baakaaꞌcumgaraa bayaluununndaanoo», kiwoꞌꞌi an «Koluka fu tíin»? ");
INSERT INTO snf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wayee bi ɗú ínoh an ga ëldúna, Kowukii ɓii onuunun kibayal baakaaraa, malkat! Ya woꞌꞌa lafañaa an: ");
INSERT INTO snf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","- Mi woꞌꞌaaka, kolka, ɓewaa gataniigaraa, fu ƴee kaanfu! ");
INSERT INTO snf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Daama lafañaa dalla kikoluk, ɓeɓpa gatanaagari, yaa meƴ ga fíkíi ɓéeɓ. Fodaama ɓuwaa tóoh jaahliꞌussa ga iñaama, ɓa ɓaa ndam Kooh anee: - Iñaa man na iñii yii, ɗí mosoori kihot! ");
INSERT INTO snf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yéesu meyissa ga ɓak giiyaa Gëlílée, ɓoꞌ ɓiyewin ɓaa hay gari, ya yaa jëgíꞌɓa. ");
INSERT INTO snf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ya enee na kipaaf, ya hotta Léwí, kowu Alfee, yugin ga ɗekataa fayukohsi juutiɗa. Yéesu woꞌꞌari an: - Taabukaaroo! Léwí kolukka, yaa taabukki. ");
INSERT INTO snf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lëehíꞌta, Yéesu enee na kiñam ga kaan Léwí, ee juuti ɓiyewin, na ɓuwaa júwussii boksee nari kiñam ɓan, ya na tëelíbéecaagari. Ga ɓuwaa taabukussiɗa, yewneera ɓuwaa man ɗa. ");
INSERT INTO snf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga daa jëgíroh-waascaa faꞌ na Fërísiyeeŋcaa hotussi yaa bok kiñam na juuticaa na ɓuwaa júwussiiɗa ɓan, ɓa meekissa tëelíbéecaagari an: - Iñii tah ya, ya bok kiñam na juuticii na ɓuwii júwussiiɗa? ");
INSERT INTO snf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Daa Yéesu kelohee iñaama, ya woꞌꞌaɓa an: - Ɓuwaa dara gaa naɓa laakussii sooli ga payoh, wayee ɗúukoolíꞌcii ɓërí laak sooli ga. Mi hayyii ëldúna kiɓay ɓuwii júwinɗa, wayee mi hay kiɓay haꞌ-baakaaꞌcii. ");
INSERT INTO snf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Laakka bes, tëelíbéecaa Saŋ na ɓaa Fërísiyeeŋcaa ɓaa ooꞌ. Ɓiɓoꞌ hayya ga Yéesu kimeekissi an: - Iñii tah ya tëelíbéecii Saŋ na ɓii Fërísiyeeŋcii ɓii ooꞌ, ee tëelíbéeciigaraa ooꞌsoo? ");
INSERT INTO snf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yéesu taassaɓa an: - Ɓedohcaa haꞌ-kílookkaa mínin kiꞌooru ee lak haꞌ-kílookkaa yaa naɓane? En lakanaa haꞌ-kílookkaa kaa lís naɓa kiꞌen, ɓa mínoo kiꞌooꞌ. ");
INSERT INTO snf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wayee bes waa hay, waa haꞌ-kílookkaa hay kiɓewohu ga leelooɓa, bëríinaama nak, ɓa hay kiꞌooꞌ. ");
INSERT INTO snf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ken ɓewoo píis wiꞌas daafwa ga líil-kúltí. Enndiikanaa píisaa wiꞌaswaa hay kiɓaydoh yen ga líil-kúltaa, wa tum ɗaraa wëñ kiyak. ");
INSERT INTO snf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Fodaama, ken tumoo biiñ wiꞌas ga mbúus-oncaa maañin. Enndiikanaa biiñaa lúudaa, pook mbúuscaa: biiñaa aamuk mbúuscaa yasukoh. Kon biiñ wiꞌas jom kiꞌeku ga mbúus-on ciꞌas! ");
INSERT INTO snf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Enee ga bes Sabat, bëríi Yéesu kooree ga ɗuuƴ yooncaa lúudin. Ga daa ɓa kooroheeɗa tëelíbéecaagari dalussa kiweel ga boŋcaa. ");
INSERT INTO snf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Laakka Fërísiyeeŋcaa woꞌu Yéesu an: - Malka! Iñii tahɓa kitum ya iñaa Waasii kokohin kitum ga bes Sabatɗa? ");
INSERT INTO snf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yéesu woꞌꞌaɓa an: - Hanaa ɗú jaŋngii iñaa buuꞌ Dëwít tumee bëríi lak ya yaawin ee ya laakoo iñaa ya ñaman, ya na ɓuwaa taabee nariɗa? ");
INSERT INTO snf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ya aassa taalaa Kooh, waama lak Abíyataaꞌ yërí enee haꞌ-kaadaa sarahohcaa, ya ñammba mbúurúcaa meƴdohɗusee Koohɗa, ya eꞌta ɓuwaa taamsee nariɗa ga ɓan. Ee mbúurúcaama, sarahohcaa doŋ onuca kiñam. ");
INSERT INTO snf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yéesu tíkiꞌtaɓa ga an: - Ɓoꞌ yërí tah bes Sabat kitumu, enndii bes Sabat tah ɓoꞌ kisaku. ");
INSERT INTO snf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iñaama tah kon, bi Kowukii ɓii kërí laak bes Sabat ɓan. ");
INSERT INTO snf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Laakka bes, Yéesu karissa jaangu-yaawúuraa. Lak laakin ɓaa en daama, ɓay yahaa ɗooƴkin. ");
INSERT INTO snf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓuwaa ensee daɗa ɓaa malak ga Yéesu, ati ya hay kiwëkíꞌ ɓoꞌ ga bes Sabat, doonaa ɓa mínndi kiyam. ");
INSERT INTO snf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yéesu woꞌꞌa ɓaa laak yahaa ɗooƴkinɗa an: - Kolka! Hayaa dii ga fíkíi ɓéeɓ! ");
INSERT INTO snf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lëehíꞌta ya woꞌꞌa ɓuwaa ensee daɗa an: - Iñii onohu kitum ga bes Sabat ya? Iñaa jofin wala iñaa moroo? Kisom kumuun ɓoꞌ wala kilaŋ kumuun? Ɓa ennda tiiꞌ. ");
INSERT INTO snf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yéesu malakkaɓa ɓéeɓɓa na keeñ-tam, iñaama mesikkari ga daa ɓa súɓ ga keeñɗa. Ya woꞌꞌa haꞌ-yahaa an: - Lërísaa yahii! Ɓaa lëríssa, yahaa wakka, mannda ga daa wa eneeɗa. ");
INSERT INTO snf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fërísiyeeŋcaa meyussa, ɓa dalla kihídoh na ɓuwaa faꞌ na buuꞌ Erootɗa, kimalak ga daa ɓa tuman bi ɓa apluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yéesu aawwa ɓak giiyaa Gëlílée na tëelíbéecaagari. Mbooloomaa waa meyoh gohaa Gëlílée na waa Yúudée, wa waa taabukki. ");
INSERT INTO snf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ɓoꞌ ɓiyewin ɓiliis, daa ɓa kelohsee iñaa ya tumɗa, ɓa ɓaa hay gari ɓan; ɓa meyohsee gohaa Yúudée na dëkaa Yéerúsaleem, na gohaa Ídúmée, na gohcaa hanoh húlúwaa Yúrdeŋ gaaɗa, na iñaa wíil dëkcaa Tíiꞌ na Sídoŋ. ");
INSERT INTO snf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ya woꞌꞌa tëelíbéecaagari ɓa heeliꞌti gaal-looci en ɗanaa ya míni ga kiꞌaas, doonaa ɓuwaa ñaakoo ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","En kiꞌenaa, daa ya enee na kiwëkíꞌ ɓoꞌ ɓiyewinɗa tahha ɓéeɓ ɓaa ɗúukoolin yaa ɓociroh kiꞌam gari. ");
INSERT INTO snf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ee daa raɓcaa hotohussi ɓéeɓ, ɓa ƴíꞌɗiri, ɓa fiipi an: «Fu yërí en Kowukii Kooh.» ");
INSERT INTO snf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wayee Yéesu ɗígiɓa na woꞌeen ciyëgísíꞌ, kihoonohɓa kiwoꞌ ɓaa ya enɗa. ");
INSERT INTO snf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lëehíꞌta, Yéesu lappa ga ɗook jaŋjagaa, ya ɓayya ɓuwaa ya waaꞌɗa; ɓa hayya gari. ");
INSERT INTO snf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ya tanukka ɓidaaŋkaah na ɓanak, ɓaa ya teek apotaaꞌ: ɓa tes nari ee ya wosiɓa kijangatnee; ");
INSERT INTO snf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ya eꞌdohhaɓa dooli kikaal raɓ ga ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɓuwii ɓii ɓërí en ɓidaaŋkaah na ɓanakɓii ya falɗa: Simoŋ (yërí ya teek Peeꞌ); ");
INSERT INTO snf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saak na këmëeŋkíci Saŋ, towu Sebedee, (ɓaa ya eꞌ teek Boanergesɗa, wërí en «towu íníŋ»); ");
INSERT INTO snf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andari; Filiip; Bartulëmíi; Mëccëe; Toomaa; Saak, kowu Alfee; Tadee; Simoŋ selootaa, ");
INSERT INTO snf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yúdaa Iskariyot ennda yaa toonan Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yéesu ɓoyukka kaan. Ɓoꞌ ɓiyewin nëgírukohissa daama, bi tahha Yéesu na tëelíbéecaagari mínséeríi sah kiñam. ");
INSERT INTO snf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mbokcaa Yéesu kelohuka hen, ɓa ɓaa hayyi kiꞌamnee, ndaga ɓa woꞌee an hafaagari múuyin. ");
INSERT INTO snf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Laakka jëgíroh-waascaa meyohsee Yéerúsaleem, ɓaa woꞌ an: - Belsebul, buurii raɓcii yërí nari! Doolii buurii raɓcii eꞌtiɗa, wërí tahhi kimín kikaal raɓcii ga ɓuwii! ");
INSERT INTO snf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yéesu ɓayyaɓa, liiwukkaɓa anee: - Seytaani mín na kikaal Seytaani? ");
INSERT INTO snf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Binaa nguuꞌ hëgískoh ga ɗuuƴwanaa, nguuraama mínoo kituuk. ");
INSERT INTO snf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ee binaa kaan hëgískoh ga ɗuuƴfanaa, kaanfaama mínoo kituuk. ");
INSERT INTO snf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kon binaa Seytaani heñoh na hafci, ee ya hëgískohaa, ya mínoo kilís, ya dal kiɗúm. ");
INSERT INTO snf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Binaa ɓoꞌ hay kiꞌaas ga kaan ɓaa yaa na doolaagari gík, ya ɓeɓ iñaa yaama laakɗanaa, ya jommbi kiɓaŋ hen paaƴ, doonaa ya han kimín kipook kaanfaa. ");
INSERT INTO snf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mi woꞌꞌúuka ee kayoh; ɓoꞌ mínin kibayalu iñaa en tóoh: baakaaꞌcaagari na woꞌeen-ɓaseecaa ya mínin kiꞌek Kooh tóoh. ");
INSERT INTO snf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wayee ɓaa fu woꞌ iñaa moroo ga Helaa yiselaꞌíꞌyaa ɓéeɓ, fu bayalsoo bi taaꞌ, fu koorukan baakaaraama bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yéesu woꞌeeɓa fodaama, ndaga ɓa woꞌee gari an raɓ nari. ");
INSERT INTO snf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eew Yéesu na ɓikëmëeŋkíci leꞌussa. Ɓa eemmba fooh, ɓa wosohha kiɓaynee Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lak ɓoꞌ ɓiyewin yuguunun daama, wíiluununndi. Ɓa woꞌꞌari an: - Taasa, eefu na ɓikëmëeŋkífu ɓaa day ga fooh, soolukussaa. ");
INSERT INTO snf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ya taassa an: - Ɓii en eewwoo ɓa? Ɓuwii en ɓikëmëeŋkírooɗa ɓa? ");
INSERT INTO snf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ya weessa has ga ɓuwaa wíilliɗa, ya ennda an: - Malkat, eewwoo na ɓikëmëeŋkíroo ɓeema. ");
INSERT INTO snf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɓaa tumi iñaa Kooh waaꞌɗa, ɓaama yërí en këmëeŋkíroo yiƴaal wala yiɓeti, wala eewwoo. ");
INSERT INTO snf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Laakka bes Yéesu enissa ga kijangat ga seereenaa giiyaa Gëlílée. Mbooloo wiyaak wíillari bi faf ya nammba kiꞌaas ga looci ga ɗuuƴ giiyaa, ya yuŋnga ga. Mbooloomaa tessa ga tewisaa. ");
INSERT INTO snf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ya jëgíꞌtaɓa enaama ciyewin caa taam na liiwuk. Ya woꞌeeɓa ga jëgírohaagari an: ");
INSERT INTO snf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","- Súkúrukat! Enee línoh, ya kolukka yaa ƴah kisoknee. ");
INSERT INTO snf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ga daa ya en na kisokɗa, laakka tesohtaa keen ga yahaanaa waasaa, selcaa hayussa, ñamussata. ");
INSERT INTO snf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Laakka tesohtaa keen ga ɗekataa yewinin atoh, daa yewinndii kakay. Tesohtaa gaawwa kipaal ndaga lak kakayfaa yewinndii. ");
INSERT INTO snf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ee daa nohaa koluk ga ɗook hen, tëkíꞌta iñcaa paaleeɗa, ca súɓpa ndaga níilcaagaca abéeríi. ");
INSERT INTO snf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Laakka tesohtaa keen ga ƴówée-lúp, ta paalla da. Lúpcaa yakka, dallata kiꞌon bi ta mínndii kimeƴdoh boŋ. ");
INSERT INTO snf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Laakka tesohtaa keen ga kakayfaa laakin dooli, ta paalla, ta yakka bi ta ɓíríssa, tummba towu: tii haydohha iñaa leꞌin waas cidaaŋkaah-kaahay ga tesohtaa sokseeɗa, tii cidaaŋkaah-yitniinoo, tii citéeméeꞌ. ");
INSERT INTO snf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lëehíꞌta ya tíkka ga an: - Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Daa ya úsaayee mbooloomaa, ɓidaaŋkaah na ɓanakɓaa na ɓuwaa daansee nari kitaamɗa meekissari ga loo liiwukcaama. ");
INSERT INTO snf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yéesu taassaɓa an: - Ɗú ɓërí Kooh eree kiꞌínoh kúmpafaa Nguuraagari, ee ɓuwii tes ga foohɗa, ɓa kelohan ga liiwuk na liiwuk. ");
INSERT INTO snf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Doonaa, «Ɓa mín kimalak bi jof ee ɓa hotoo dara, ɓa mín kikeloh bi jof ee ɓa ínohoo dara, en ɗanaa ɓa récukoo baakaaꞌciigaɓa bi Kooh bayalɓa!» ");
INSERT INTO snf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yéesu woꞌsissaɓa an: - Binaa ɗú ínohhii iñii liiwukii wii waaꞌ kiwoꞌɗanaa, ɗú mínan na kiꞌínoh iñii liiwukcii tesɗa waaꞌ kiwoꞌɗa? ");
INSERT INTO snf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sokohaa sok woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓíinoo mëdírohu na ɗekataa ga yahaanaa waasaaɗa, ee sokohaa sok woꞌeenaa ga ɗuuƴɓa. Bi ɓa laasan kikeloh woꞌeenaanaa, Seytaani hay, nís woꞌeenaa ɓa sokɗusee ga keeñcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓíinoo mëdírohu na ɗekataa sokuunun ee yewinin atoh. Ɓa keloh woꞌeenaa Koohaa, haat ɓa safaꞌ gawa kiteꞌ. ");
INSERT INTO snf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wayee ɓa úsaayoo ga, ndaga woꞌeenaa Kooh huuttii ga keeñcaagaɓa. Fodaama, binaa woꞌeenaa Kooh tahɓa kiꞌen ga iñaa newoo, wala ɓa tumu iñaa meskinaa, ɓa gaaw nawa kigúroh. ");
INSERT INTO snf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓíinoo ɓaa mëdírohu na ƴówée-lúpaa sokuunun. Ɓa hay kikeloh woꞌeenaa Kooh, ");
INSERT INTO snf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wayee halaat ëldúna na kiwaaꞌ kihëpíꞌkaa aaw ga alal na waareen ciliis abuɓa; iñcaama on woꞌeenaa Kooh bi tah wa mínoo kilím yen. ");
INSERT INTO snf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓíinoo mëdírohu na kakayfaa laakin dooli, soku. Ɓa keloh woꞌeenaa Koohaa, ɓa teꞌwa, ee ɓa laakiꞌ Kooh jeriñ. Ɓii haydoh iñaa leꞌin waas cidaaŋkaah-kaahay ga iñaa sokseeɗa, ɓii cidaaŋkaah-yitniinoo, ɓii citéeméeꞌ. ");
INSERT INTO snf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yéesu woꞌissaɓa an: - Ɓoꞌ haydohin lampu líꞌ kanu gane? Wala ekwa ga fíldoo fayaage? Man lampu líksi hen. ");
INSERT INTO snf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Laakkii iñaa mín kiɗaakuk bi hotukoo. Ee laakkii iñaa ɓoꞌ mín kiɗaak bi meƴdohsoo faŋ. ");
INSERT INTO snf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ya woꞌsissaɓa an: - Malaksukohat iñcii ɗú kelohiɗa. Nataa ɗú natoh ɓuwiiɗa wërí ɗú natohohsan ee ɗú ɓaatɗu ga. ");
INSERT INTO snf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","En kiꞌenaa, ɓaa laakin, hay kiɓaatɗu; wayee ɓaa laakoo, kiꞌiñkaa ya ɓayɗa sah hay kiteꞌu. ");
INSERT INTO snf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yéesu tíkissa ga an: - Nguuraa Kooh man na fodii ɓaa sok yoon. ");
INSERT INTO snf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ya enat ga kineehi, ya yúuduki, wekoo nohoo, wayee tesohtaa taa paal, taa yak. Ee ya yéegoo dara ga. ");
INSERT INTO snf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kakay fërí yëkɗi iñaa paal gari tóoh. Aboh ga daa wa paalan, lëehíraa wa ɓírís boŋ, tum towu. ");
INSERT INTO snf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yoonaa súwinaa ya aasi ga na kupíikaaꞌkaagari; ndaga lak kipíik leꞌin. ");
INSERT INTO snf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yéesu woꞌissa an: - Iñii ɗu mín kimëdíroh Nguurii Kooh nawaɗa ya? Wala liiwukii wiida mínwa kiteewoh? ");
INSERT INTO snf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wa man na kowu-kedik fodii kowu-fúdan, binaa sokunaa, kërí wëñ kijutuut ga tesohtii tóoh en ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wayee ka laas kisokunaa, kedik-fúdankaa koluk bi wëñ kiyak iñcii línsiɗa, ee ka laak toy tiyaak taa wëeꞌtaa ga an tii selcii Kooh mínu kitaal ga ɗuuƴ tuuꞌtaagaca. ");
INSERT INTO snf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ya daanee kiyéegaloh woꞌeenaa Kooh na liiwuk ciyewin caa manɗa; hínnda na fodaa daa ɓuwaa mín kiꞌam ga helcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ya woꞌéeríi iñaa enndii liiwuk na ɓuwaa; ee ya wéetta na tëelíbéecaagarinaa, ya ɓëgísiɓa ga liiwukcaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Besaa bëríi, lak Kooh yaa hooɓ, Yéesu woꞌꞌa tëelíbéecaagari an: - Ɗu paafat giiyii ɓakaa hanoh gaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Waa ɓa tagohha na mbooloomaa, ɓa ɓayya Yéesu ga loocaa ya enoheeɗa. Laakeera ɓan looci ciliis caa taamsee nari. ");
INSERT INTO snf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uuris wiyaak dalla kiyíp, dúusaa ɓewukka, waa weesuk ga ɗuuƴ loocaa bi haat waa líif na músú. ");
INSERT INTO snf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lak Yéesu yaa neeh ga ɓakaa hanoh bosaa loocaaɗa, tígínkin. Tëelíbéecaagari yúudussari, ɓaa woꞌꞌi an: - Jëgírohii! Tumuuntii ɓuwii ɓíttiiraane? ");
INSERT INTO snf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ya yúudukka, ya gëtta uurisaa, ya woꞌꞌa giiyaa an: - Ɗekoha, fu yeewuk! Uurisaa tuukka, ɗekataa ennda cel. ");
INSERT INTO snf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lëehíꞌta ya woꞌꞌa ɓuwaa an: - Iñii tahhúu kiniik ya? Ɗú gëmmbii garoo bi watine? ");
INSERT INTO snf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓa tíitta lool ga iñaama ee ɓa ɓaa meekisoh ga leelooɓa an: - Kon ɓii yii yërí en ɓa, bi uurisii sah na giiyii tumsi ga iñaa ya nakohɗa? ");
INSERT INTO snf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɓa leꞌꞌa tewisaa giiyaa Gëlílée wíinoowaa, ga kúlkaa Gerasaa. ");
INSERT INTO snf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yéesu yaa yoosuk ga loocaa, laakka ɓaa raɓ am, meyohha ga ɗuuƴ loycaa, yaa gúꞌɗukohhi. ");
INSERT INTO snf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ya dëkee ga loycaa ee ken mínsiséeríiri kipok, luu enee na ceen. ");
INSERT INTO snf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Leekleek ya jëengíseera kotcaa, yahcaa poku na ceen, wayee ya gúꞌ ceencaa, ya weel jéeŋcaa. Ken laakéeríi dooli kiꞌammbi. ");
INSERT INTO snf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wekoo nohoo, ya enee ga ɗuuƴ loycaa na ga jaŋjaŋcaa; ya weleluki, ya gaañi hafci na atoh. ");
INSERT INTO snf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Daa ya séenee Yéesu, ya yaa fool, ya ƴíꞌꞌa ga fíkíici, ");
INSERT INTO snf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yéesu woꞌꞌari an: - Hel wibóníꞌ, meyohaa ga ɓii! Ɓaa ennda ga kifiip didóolíꞌ an: - Yéesu, fu naroo ya, fu Kowukii Kooh yii ga ɗookaa-ɗookɗa? Mi yii kíimmbaa ga teekii Kooh, kaa tummboo iñaa meskin! ");
INSERT INTO snf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yéesu meekissari an: - Fu teeku na? Ɓaa taassa an: - Mi teeku coogeel, ndaga ɗí yewinin. ");
INSERT INTO snf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Helaa wibóníꞌwaa kíimee Yéesu doonaa ya meƴdohoori ga kúlkaa. ");
INSERT INTO snf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lakanaa laakin yop-mbaam-parki wiyaak waa na kiníiru ga ɓak jaŋjagaa. ");
INSERT INTO snf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Raɓcaa kíimmba Yéesu an: - Ëewdohaaríi ga mbaamcii, fu ekkíi gaɓa! ");
INSERT INTO snf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ya onndaɓa iñaama. Raɓcaa meyussa ga ɓaa, aasussa ga mbaamcaa; yopaa írkísukka tëgël-tëgëlaa, keennda ga giiyaa: mbaamcaa leꞌin ɓijúnni-kanak, muurussa ga giiyaa. ");
INSERT INTO snf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Níirohcaagaɓa núpussa, ɓa woꞌneera iñaa hewɗa ga teeraa na dëkcaa cíinoo. Ɓuwaa ɓaa hay kimalak iñaa hewɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓa hayya bi ga Yéesu, ɓa hotta haꞌ-rawaa ɓayee coogeelaaɗa yugin, ekkin kúltí, taammba na sagaagari. Ɓa dalla kiniik. ");
INSERT INTO snf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓuwaa maasohsee iñaa dalee haꞌ-rawaa na mbaamcaaɗa, ɓéestírussaɓa iñaa laakeeɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Waa ennda ɗa, ɓuwaa dalla kikíim Yéesu ya meyoh gohaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Daa Yéesu en na kiꞌaas loocaa, ɓaa raɓcaa abeeɗa kíimmbari ya onndi kites nari. ");
INSERT INTO snf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yéesu onndiirika, wayee woꞌꞌari an: - Ɓoƴkaa kaanfu, ga ɓu-kaanfu, fu ɓéestíꞌɓa tóoh iñii Haꞌmudii tumiꞌtaa ga yërmaandii ya laak garaaɗa! ");
INSERT INTO snf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɓaa kaꞌta, dalla kiyéegaloh ga gohaa «Teerucaa cidaaŋkaahcaa» iñaa Yéesu tumɗeeri tóohɗa; ee ɓuwaa ɓéeɓɓa jaahliꞌussa ga. ");
INSERT INTO snf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Daa Yéesu soofisee na looci ga tewisaa wíinoowaa, mbooloo wiyaak nëgírukohha ga yahaaci, ga daa ya enee ga tewisaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Laakka ɓoꞌ, bok ga ɓuwaa kuliyuk ga jaangu-yaawúuraa, ee teeku Yayros; daa ya hot Yéesu hen, ya ƴíꞌꞌa ga kotcaagari. ");
INSERT INTO snf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya yaa kíimmbi an: - Kowukaagoo kiɓetikaa kiƴínkaa kaa ƴah kilëehɗuk; hay tíkaari yahciigaraa doonaa ya wak ee ya pes! ");
INSERT INTO snf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yéesu yaa ƴah nari. Ee ɓoꞌ ɓiyewin ɓaa taabukki, ɓaa ñaak ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Daama nak, laakeera ɓetifaa daanee kimeƴdoh ñíf rek, iñaa leꞌin tíkíis tidaaŋkaah na tanak. ");
INSERT INTO snf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ya sodeera lool ga yah payoh ɓiyewin ee iñaa ya laakeeɗa tóoh eemmba ga, wayee onndiiri kitani; hanaa kay ya ɓaatee kikeen. ");
INSERT INTO snf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Daa ya kelohee loo Yéesu, ya aassa ga mbooloomaa, ga fenooci, ya leꞌꞌa ga kúltífaagari, ");
INSERT INTO snf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ndaga ya woꞌee ga ɗuuƴci an: «Binaa mi mínee kileꞌ rek ga kúltíciigarinaa, mi hay kiwak.» ");
INSERT INTO snf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ga ɗekataama ñífaa íissa kimeƴ gari, ee ya yéeŋnga ga faanci an ya wakin. ");
INSERT INTO snf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yéesu dalla kiyéeŋ ga hafci an laakin doolaa meyoh gari. Ya móoñsúkka ga leeloo mbooloomaa, meekisohha an: - Ɓii leꞌ ga kúltíciigoo ɓa? ");
INSERT INTO snf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tëelíbéecaagari woꞌussari an: - Fu hot ga dii mbooloomii ñaak ga ɗookfuɗa, an fu woꞌ an: Ɓii leꞌ garoo ɓa? ");
INSERT INTO snf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wayee Yéesu yaa malak iñaa wíilliɗa, kihot ɓaa tumee iñaamaɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɓetifaa tíitta bi yaa saak, ndaga ya ínohin iñaa daleeriɗa. Ya hayya, keennda ga kotcaa Yéesu, woꞌꞌari kayohfaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yéesu woꞌꞌari an: - Jowu, ngëmumgaraa wëkɗinndaa. Karaa na jam ee wakaa ga iñum mesikkaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lak Yéesu yaa lís kiwoꞌ fodaama, ɓiɓoꞌ meyohussa kaan ɓaa kuliyuk ga jaangu-yaawúuraaɗa, kiwoꞌꞌi an: - Kowukaagaraa kaanin. Iñii fu ƴah Jëgírohii kisonlukohis gaɗa ya? ");
INSERT INTO snf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Daa Yéesu kelohee woꞌeenaagaɓa, woꞌꞌa ɓaa kuliyuk ga jaangu-yaawúuraaɗa an: - Kaa niik dara, gëmaa hen rek! ");
INSERT INTO snf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya tookkii ken taam nari, enndii Peeꞌ, na Saak na Saŋ, këmëeŋkícinaa. ");
INSERT INTO snf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓa leꞌ kaan Yayros hen, Yéesu hotta an coowaa yakin, ee ɓuwaa ɓaa looyoh, ɓaa fiipoh didóolíꞌ. ");
INSERT INTO snf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya aassa, woꞌꞌaɓa an: - Coowiigarúu wa yak na ɗa? Ɗú looyoh ya? Oomaanii kaanndii, en na kineeh. ");
INSERT INTO snf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓa ɓaa ciiɓsukki. Waa ennda ɗa, ya méyíꞌtaɓa tóoh ga fooh, ee ya ɓayya paam oomaanaa na eeci na ɓuwaa ɓenseeriɗa. Ya aassa ga daa oomaanaa enoheeɗa. ");
INSERT INTO snf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ya ammba oomaanaa ga yahaa, ya woꞌꞌa an: - Talita kúm! (Wërí en: «Kuꞌoomaa-jowu, mi woꞌꞌaa, kolka!») ");
INSERT INTO snf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kuꞌoomaa-jowukaa dalla kikoluk, ja laakee tíkíis tidaaŋkaah na tanak. Ja jaa tíin. Ɓuwaa jaahliꞌussa lool ga iñaama. ");
INSERT INTO snf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yéesu ɗíŋngaɓa na woꞌeen ciyëgísíꞌ an ken jomooka kiyéeŋ. Lëehíꞌta ya woꞌꞌa an kuꞌoomaakaa onsat ñamah. ");
INSERT INTO snf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yéesu meyohha daama kaꞌta teeraa ya dëkohɗa. Tëelíbéecaagari taabukussari. ");
INSERT INTO snf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bes Sabat hayya, ya yaa jëgíroh ga jaangu-yaawúuraa. Ɓoꞌ ɓiyewin daa ɓa súkúrukeeri, jaahliꞌussa, ɓa ɓaa woꞌ an: - Ya ɓewohnee iñcii cii gada? Hamhamii ya ɓay wii, wa man na? Ee tum na kíntaancaa man na cii mín kimeyoh gari? ");
INSERT INTO snf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hanaa enndii daayoh haangii, kowukii Mariyaama, yaak ɓiSaak, Yosee, Yúdaa na Simoŋ? Ee ɓikëmëeŋkíci ɓiɓeti enu dii ga ɗuuƴcuune? Fodaama keeñcaagaɓa caa tak gari. ");
INSERT INTO snf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wayee Yéesu woꞌꞌaɓa an: - Sëldíiga-Kooh waaruunun ga daa en ɓéeɓ, bi tessa dëkaa ya meyohɗa, na mbokcaagari, na ɓu-kaanci. ");
INSERT INTO snf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ya mínndii kitum daama kíntaan wíinoo enndii rek ɓiɗúukooliꞌ ɓaa ya tík yah, ee ɓa wakkaɗanaa. ");
INSERT INTO snf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ya jaahliꞌꞌa ga daa ɓa tookkii kigëmɗa. Lëehíꞌta Yéesu yaa wíil ga dëkcaa deeƴ daamaɗa, ya yaa jëgíroh. ");
INSERT INTO snf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Waa ennda ɗa, ya ɓayya apotaaꞌcaa ɓidaaŋkaah na ɓanakɓaa, ya yaa wosɓa, ɓa taam ɓanak ɓanak. Ya eꞌtaɓa dooli kikaal raɓ ga ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ya kokohhaɓa an ɓa hanat kiɓaydoh dara ga ɓaawaa, enndii dooꞌ rekaa. Ya woꞌeeɓa an: - Kaa ɓayat dara: enndii mbúurú, enndii hëmbu, ee kaa loyukat kopaꞌ ga kenohhúu. ");
INSERT INTO snf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wayee ekkat ñafaꞌ ee kaa ɓayat kúltí kanak. ");
INSERT INTO snf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Lëehíꞌta ya woꞌissaɓa an: - Daa ɗú leꞌ ɓéeɓ, tesat ga kaanfaa ɗú eksanɗa bi ga daa ɗú kolkohan ɗekataama. ");
INSERT INTO snf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ee ga ɗekataa ɗú leꞌ ɓéeɓ, binaa ɓuwaa tookkiirúu ga kaanɓa ee ɓa saŋngúu kisúkúrukaa, leenaa përtukat pëndëlaa en ga kotcaagarúuɗa ɗú meyoh daama: iñaama hay kiteewoh kimúuƴkaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Waa ennda ɗa, apotaaꞌcaa karussa, ɓa ɓaa jangat an ɓuwaa súpítat kipeskaagaɓa. ");
INSERT INTO snf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓa ɓaa kaal raɓ ɓiyewin ga ɓuwaa ee ɓa ɓaa leef dúuleen ga hafcaa ɗúukoolíꞌ ɓiyewin ee ɓa ɓaa wëkíꞌɓa. ");
INSERT INTO snf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eroot buuraa kelohha iñaa woꞌu ga Yéesuɗa, ndaga lak teekaagari síwin daa en ɓéeɓ. Ɓuwaa woꞌee an: - Saŋ yaa bëtísiꞌee ɓuwaa ga músúɗa yërí mílís ga ɓuwaa kaaninɗa. Iñaama yërí onndi dooli kimín kitum kíntaan. ");
INSERT INTO snf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɓíinoo woꞌsee an: - Ɓaa Ili. Ee ɓíinooɓaa an: - Ɓaa, iñaa sëldíiga-Kooh fodii sëldíigacaa múus. ");
INSERT INTO snf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wayee Eroot, daa ya keloheeka, woꞌꞌa an: - Saŋ-Bëtís yaa mi gúꞌlukee hafaaɗa yërí mílís! ");
INSERT INTO snf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eroot yaama, ga kihafci, yërí nakohee kiꞌamluk Saŋ-Bëtís, ya ɓaŋlukkari, laŋngari ga kasu. Erojaas, ɓeti këmëeŋkíci Filiip, yaa ya teꞌ ya pañnjariɗa, yërí tahee Eroot kitum iñaama. ");
INSERT INTO snf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Lak Saŋ-Bëtís woꞌee Eroot an: «Waas onndiiraa kifaan ɓeti këmëeŋkífu ya en ɓetifu!» ");
INSERT INTO snf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kërí tah Erojaas ammba Saŋ-Bëtís ayluk, waaꞌtari kiꞌapluk. Wayee ya mínéeríika, ");
INSERT INTO snf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ndaga Eroot niikeera Saŋ-Bëtís, lak ya ínohin an Saŋ-Bëtís enin ɓaa júwin ee selaꞌin. Kërí tah ya somiri ee besaa ya keloh woꞌeenaagari ɓéeɓ, helaagari yëngëluk ee kokohhii ɓan bi hayaa ya safaꞌ ga kisúkúrukki. ");
INSERT INTO snf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erojaas laakka besci, bëríi lak Eroot en na kihúmbal besaa ya límohuɗa. Eroot nakka ɓuwaa ɓiyaakɓaa en nari ga jalaaɗa, ɓuwaa kuliyuk ga soldaaꞌcaagariɗa na lamancaa ga Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kowukaa kiɓetikaa Erojaas aassa kaa ham; hamaa neɓpa Eroot lool, na ɓuwaa ya nakee hewaaɗa. Buuraa woꞌꞌa oomaa-jowaa an: - Meekisohaaroo iñaa neɓpaa, mi hayyaari kiꞌeꞌ. ");
INSERT INTO snf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya waatta ga fíkíici an: - Iñaa fu meekisohoo ɓéeɓ mi eꞌtaari, luu enee kiɗaꞌ kúlkiigoo ga leꞌnii mi eꞌtaa ɓakii wíinoowii. ");
INSERT INTO snf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oomaanaa meƴca, meekisneera eeci an: - Mi kíimanndi ya? Yaama taassari an: - Hafaa Saŋ-Bëtís. ");
INSERT INTO snf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ya gaawwa kisoof ga buuraa kiwoꞌꞌi an: - Eraaroo diima-diima hafaa Saŋ-Bëtís ga ɗook palaat. ");
INSERT INTO snf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Keeñaa buuraa leehha tak ga iñaama. Ya mínndii oomaanaaka kisagiꞌ, ndaga daa ya woꞌeeka ga fíkíi ɓuwaa ya nakee hewaaɗa, ee na daa ya laasinka kiwaatɗa. ");
INSERT INTO snf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ya dalla kiwos soldaaꞌ yíinoo, nakkari kihaydoh hafaa Saŋ-Bëtís. Soldaaraa kaꞌta, gúꞌneera hafaa Saŋ-Bëtís ga kasaa, ");
INSERT INTO snf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ya haydohiꞌtariwa ga palaat. Ya eꞌtawa oomaa-jowaa ee oomaa-jowaa eꞌneerawa eeci. ");
INSERT INTO snf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Daa tëelíbéecaa Saŋ-Bëtís kelohsee iñaama, ɓa hayya kiɓeɓ faraaffaagari, acsuneerafa ga loycaa. ");
INSERT INTO snf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apotaaꞌcaa Yéesu nëgírukohussa ga yahaaci, ɓaa ɓéestíꞌti iñaa ɓa tumeeɗa na iñcaa ɓa jëgíroheeɗa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yéesu woꞌꞌaɓa an: - Hayat gii ɗu ƴee daa wéetin, ɗú íikaruk jutuut. Yéesu woꞌeeɗa ndaga lak ɓuwaa yewneera kikaꞌ na kihay gaɓa bi sah ɓa laakéeríi jot kiñam. ");
INSERT INTO snf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓa aassa kon ga gaal-loocaa ɓa haŋɓa, kikaꞌ daa wéetin. ");
INSERT INTO snf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɓoꞌ ɓiyewin hotuɓa daa ɓa na kiƴahɗa, ínohsohussaɓa. Ee ɓuwaa ɓaa meyoh ga dëkcaa tóoh, ɓaa fool na kot kiɗëwírukɓa ga daa ɓa aawɗa. ");
INSERT INTO snf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Daa Yéesu yoosukee ga gaal-loocaa, ya hotta mbooloo wiyaak, ya laakka yërmaandi gaɓa ndaga ɓa madee na baalcaa laakoo níiroh. Ya ennda ga kijëgíꞌɓa enaama ciyewin. ");
INSERT INTO snf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tëelíbéecaa hayussa ga Yéesu lak nohaa waa soos, kiwoꞌꞌi an: - Ɗekatii laakoo dara ee nohii wii soos, ");
INSERT INTO snf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Íisaa ɓuwii ɓa aas yopcii na dëk-kawcii ga yahaaniiɗa, ɓa lomnee iñaa ɓa ñaman. ");
INSERT INTO snf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yéesu taassaɓa an: - Eratɓa na kihaffúu iñaa ɓa ñaman. Wayee ɓa woꞌꞌari an: - Ɗí karat kilomnee mbúurú iñaa leꞌ denariyon citéeméeꞌ-kanak, ee ɗí eꞌɓa ɓa ñame? ");
INSERT INTO snf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yéesu meekissaɓa an: - Ɗú ɓay mbúurú cera? Malaknat! Ɓa laakka iñaa leeꞌɓa ga, ɓa hayya, ɓa woꞌꞌari an: - Mbúurú ciyëtúus na jën kanak cërí ɗí laak. ");
INSERT INTO snf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Fodaama, ya nakkaɓa kiyugiꞌ mbooloomaa kakay ga pëegíifaa fihiiliifaa; ɓa nëgírukoh kom kom. ");
INSERT INTO snf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓa yuŋnga, ɓa warukohha waaꞌ, cii ɓoꞌ ɓitéeméeꞌ, cii ɓoꞌ ɓidaaŋkaah-yëtúus. ");
INSERT INTO snf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ya ɓeɓpa mbúurúcaa ciyëtúuscaa na jëncaa kanakcaa, ya taaginukka ɗook, ya gërëmmba Kooh gaca. Lëehíꞌta ya gúꞌsohhaca, ya eꞌta tëelíbéecaa ɓa waroh ɓuwaa. Fodaama ɓan ya warohha jëncaa kanakcaa ga ɓuwaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓuwaa ɓéeɓɓa ñammba bi ɓa kappa pút, ");
INSERT INTO snf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ee pañi cidaaŋkaah na kanak líifɗussa ga na iñaa tesee ga mbúurú na jënɗa. ");
INSERT INTO snf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ga ɓuwaa bokee kiñam mbúurúcaaɗa laakeera ƴaal ɓijúnni-yëtúus. ");
INSERT INTO snf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga waa iñaama paaffa, Yéesu dalla kituukuk tëelíbéecaagari ɓa aas ga gaal-loocaa, ɓa ɗëwírukki ɓakaa giiyaa hanoh gaa, ga ɓak dëkaa Betsaydaa; hídinaa, ya ga kihafci ya tagoh na mbooloomaa. ");
INSERT INTO snf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Waa ya tagohha naɓa bi lëehíꞌta, ya lappa ɗook tëgëlaa, yaa kíim Kooh. ");
INSERT INTO snf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ga waa wekaa leꞌꞌa, lak loocaa tëelíbéecaa waa ga leeloo giiyaa, Yéesu tesee haŋci doŋ ga tewisaa. ");
INSERT INTO snf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yéesu hotta an tëelíbéecaa laakseera coonu kitíidiꞌ loocaa ndaga ɓa jaanohee na uurisaa. Waa Kooh wíisanaa, ya kolukka yaa ƴah gaɓa, tíin hen ga ɗook giiyaa. Ya kaꞌta bi ya yaa waaꞌɓa kipaaf. ");
INSERT INTO snf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Daa ɓa hotti yaa tíin ga ɗook giiyaa, ɓa fooŋnga an iñaa enndii ɓoꞌ. Ɓa ɓaa fiipoh. ");
INSERT INTO snf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɓéeɓɓa hotsee gari ee ɓa tíitta lool. Ga ɗekataama, Yéesu dalla naɓa kiwoꞌ an: - Yëgísɗat fítciigarúu, ɓii mi, kaa niikat. ");
INSERT INTO snf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lëehíꞌta ya yaa ƴah gaɓa, aassa gaɓa ga loocaa. Uurisaa tuukka. Ɓa, ga kihafɓa waaruꞌussa lool ga iñaama, ");
INSERT INTO snf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ndaga en kiꞌenaa ɓa mínéeríi kiꞌínoh iñaa kíntaanaa ga mbúurúcaa waaꞌ kiwoꞌɗa, ndaga daa ɓa yëgísíꞌ keeñcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waa ennda ɗa,Yéesu na tëelíbéecaagari lëehɗussa kihúus giiyaa na gaal-looci, ɓa teeꞌta ga kúlkaa Genesareet; daama ɓa yóoskíꞌta loocaa. ");
INSERT INTO snf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɓa ɓaa meƴ ga loocaa rek ɓuwaa ɓaa ínohsoh Yéesu; ");
INSERT INTO snf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ɓuwaa wíilla gohaama tóoh ee ga ɗekataa ɓa keloh an ya yaa da ɓéeɓ, ɓa ennda ga kiɓeɓ ɗúukoolíꞌcaa ga gatancaa, kiɓay daama. ");
INSERT INTO snf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ga daa ya aasoh ɓéeɓ, ennda ga dëkcaa ga kawaa, ga teeraa wala ga tukaantaa en ga ëgíraaɗa, ɓuwaa faansi ɗúukoolíꞌcaa ga paancaagaɓa. Ee ɓaa kíimmbi ya onɓa ɓa mín kileꞌ rek ga pawaa kúltífaagari. Fodaama ɓuwaa leꞌee gariɗa tóoh, wakussa. ");
INSERT INTO snf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fërísiyeeŋcaa na ɓijëgíroh-waas, ɓaa meyoh Yéerúsaleem, ɓa hídírukohha ga yahaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓa hotta ga tëelíbéecaagari ɓaa en na kiñam na yahcaa settii, waaꞌ kiwoꞌ an ɓa tísukkii fodaa daa baahcaagaɓa nakohkaɗa. ");
INSERT INTO snf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Waama Fërísiyeeŋcaa na iñaa enin yaawúuꞌ ɓéeɓ, ɓa ñamoo ee ɓa tíssii yahcaa bi jof, fodaama ɓa taabukee baahcaa caasamuncaa. ");
INSERT INTO snf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ee binaa ɓa meyoh toonaaraanaa, ɓa ñamoo ee ɓa tísukkii paaƴ. Ɓa laakin ɓan baah ciliis caa ɓa taabuk fodii tísaa kaascaa, na tataataa, na këwdíiꞌcaa. ");
INSERT INTO snf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fodaama, Fërísiyeeŋcaa na jëgíroh-waascaa meekisohussari an: - Iñii tah ya tëelíbéeciigaraa taabukussii baahcii caasamuncii, ɓa ñami na yahcaa settii? ");
INSERT INTO snf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yéesu taassaɓa an: - Ɗú, ɗú jófjófɗuk ga hascii ɓuwii! Ísayíi, sëldíiga-Koohaa hoteerúu moos ee ya woꞌee kayoh ga waa ya bín ga teek Kooh an: «Ɓuwii ɓii, kañii ɓa kañirooɗa, eem túuwtii doŋ, ɓa ekkiiroo ga keeñɓa. ");
INSERT INTO snf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɓa ɓay teekkoo sooƴ ndaga iñcii ɓa jëgíroh ga teekiigooɗa meyoh ga iñaa ɓoꞌ nakoh.» ");
INSERT INTO snf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lëehíꞌta, ya tíkka ga an: - Ɗú íisin kitum iñaa Kooh nakoh, ɗú taabuk baah ɓoꞌ! ");
INSERT INTO snf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ya enissa an: - Ɗú laakin hel ga kikoom day iñaa Kooh nakoh ee ɗú taabuki baahciigarúu. ");
INSERT INTO snf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ndaga Móyíis woꞌee an: «Kelohɗaa paapu na eefu.» Ya tíkka ga an: «Ɓaa fu ɓas paapu wala eefunaa, fu jom kiꞌapu hen.» ");
INSERT INTO snf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wayee ɗú, ɗú jëgíroh an binaa ɓoꞌ woꞌ paamci wala eeci an «Iñaa mi jomeerúu kitoputuꞌohɗa enin Korban» (wërí en an wa sarahuunun Kooh), ");
INSERT INTO snf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ɗú nak ɓaama kitumɗoo paamci dara, wala eeci. ");
INSERT INTO snf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Fodaama, baahciigarúu ɗú lamɗa cërí níslukohhúu woꞌeenaa Kooh. Ee yewinin iñcaa ɗú tumi man fodaama. ");
INSERT INTO snf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Waa ennda ɗa, Yéesu ɓaysissa ɓuwaa, ya woꞌꞌaɓa an: - Súkúꞌkattoo ɓéeɓpúu, ee ɗú ínoh iñii yii bi jof: ");
INSERT INTO snf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","laakkii iñaa kúlkoh fooh, aas ga ɓoꞌ, bi tah ya líiɓ ga fíkíi Kooh, wayee iñaa meyoh ga keeñci yërí líiɓɗi ɓoꞌ.  ");
INSERT INTO snf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ya foñnja ɓuwaa, ya aassa kaan. Tëelíbéecaagari meekisohussari ya lëegísohɓa woꞌeenaa ya nataal waama. ");
INSERT INTO snf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ya woꞌꞌaɓa an: - Ɗú ɓan, ɗú laakoo hel hene? Ɗú ínohoo an laakkii iñaa kúlkoh fooh, aas ga ɓoꞌ, bi tah ya líiɓ ga fíkíi Kooh? ");
INSERT INTO snf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ndaga fu ñam yenaa iñaama aasirii ga keeñaagaraa, wayee aawi ɗuuƴ lookaagaraa, lëehíraa, wa kaꞌ fenoo kaan. (Fodaama, Yéesu teewohee an ñamahaa en ɓéeɓ onohuunun kiñam.) ");
INSERT INTO snf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ya woꞌissa an: - Iñaa meyoh ga keeñ yërí tah ɓoꞌ kilíiɓ ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Halaatcii cibóníꞌcii meyoh ɗuuƴ, ga keeñ ɓoꞌ: cërí haydoh kifaanuk na ɓaa en ɓéeɓ, kilok, kiꞌap ɓoꞌ, ");
INSERT INTO snf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kiɗúk ƴaalfu wala ɓetifu fu faanuk na ɓoꞌ yiliis, kiwaaꞌ kihëpíꞌ, kiɓay nof-moroo, kiñaañukoh mooroomfu, kiŋalaañuk, kiꞌiñaan, kiɗooɓ ɓoꞌ, kimaruk na kidófdófɗuk. ");
INSERT INTO snf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iñcii cimoroocii ciima tóoh kúlkoh ɗuuƴ ɓoꞌ, ee cërí tah ɓoꞌ kilíiɓ ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yéesu meyohha daama, kaꞌta ɓak dëkaa Tíiꞌ. Ya ennda ga kaan fíinoo daama, ee ya waaréeríi ɓoꞌ yéeŋka. Wayee ya mínéeríi kiɗaakuk iñaa maañ. ");
INSERT INTO snf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Laakka ɓoꞌ yiɓeti, kowukaagari kiɓetikaa laakee raɓ. Daa ya kelohha ɓuwaa ɓaa woꞌ ga loo Yéesu, ya yaa hay, ya leꞌꞌa, keennda ga kotcaagari. ");
INSERT INTO snf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɓetifaa faama enee Gerek, baahkohee Fenísíi ga Síríi. Ya kíimmba Yéesu ya meƴdoh rawaa ga kowukaagari. ");
INSERT INTO snf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yéesu woꞌꞌari: - Íisa paaƴ bi oomaacaa kapu. Kiɓeɓ ñamah oomaa, fu jafiꞌ tubaaytaa,iñaama moroo. ");
INSERT INTO snf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɓetifaa taassari an: - Iñaama kayoh, Haꞌmudii. Wayee tubaaytaa ga yahaa kankaaɗa, ɓa ñam wúunée-mbúurúcaa oomaacaa ɓúukɗa. ");
INSERT INTO snf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Waa ennda ɗa, Yéesu woꞌꞌari an: - Woꞌeenum fu woꞌ wuma tahin bi, kara, rawaa meyohin ga kowukaagaraa. ");
INSERT INTO snf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ee ga waa ya leꞌꞌa kaanci, ya laakka oomaanaa leemukin ga ɗook fayaaŋfaa, rawaa meyohin gari. ");
INSERT INTO snf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yéesu kolkohha ɓak dëkaa Tíiꞌ, meƴca dëkaa Sídoŋ. Ya koorohha ga ɗuuƴ gohaa teerucaa cidaaŋkaahcaa, ya sooffa ɓak giiyaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya haydohɗussa ɓaa ɗekin ee luuwin. Ɓuwaa kíimmbari ya tíkki yahcaagari. ");
INSERT INTO snf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ya wéetneera nari, úsaayya ɓuwaa, ya ekka tujokontaagari ga ɗuuƴ nofcaa ɓaa, ya toossa, tumiꞌtari mitoosmaa ga perimpaa. ");
INSERT INTO snf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lëehíꞌta ya taaginukka ɗook, ya údíꞌta yen ga kakay, ya woꞌꞌa an: - Effata! (wërí en: «Lëgíska!») ");
INSERT INTO snf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Haat nofcaa ɓaa lëgísukka, perimpaa lógískohha, ya yaa woꞌ dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yéesu ɗíŋnga ɓuwaa an ɓa hanatka kiɓéestíroh. Wayee ya wëñi ɓuwaa kiɗígaa, ɓuwaa wëñi ɗa kiyéegaloh. ");
INSERT INTO snf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓuwaa waaruꞌseera bi hëppa ee ɓaa woꞌ an: - Iñaa ya tum ɓéeɓ jekin, ee ya onin sah ɗekcii kikeloh na luuɓcii, ɓa woꞌ! ");
INSERT INTO snf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Waama ɓoꞌ ɓiyewin nëgírukohisee daama ee ɓa laakéeríi iñaa ɓa ñaman. Yéesu ɓayya tëelíbéecaagari, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","- Mi laakin yërmaandi wiyaak ga mbooloomii, ndaga malkat, bes kaahay cee, caa wëeꞌtaa ga an cii, ɓa ɓii naroo, ee diima deŋ ɓa laakoo iñaa ɓa ñaman. ");
INSERT INTO snf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Binaa mi woꞌɓa ɓa ɓoyuk kaanɓa na kiyaawaa, ɓa mínin kitëehlíꞌ ga waas, ndaga ɓíinoo, dii ɓa meyohɗa úsaayin. ");
INSERT INTO snf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tëelíbéecaagari taasussari an: - Mbúurúcaa ƴah kikëpíꞌ ɓuwii ɓii meyohan gada, ga ɗekatii wii laakoo daraɗa? ");
INSERT INTO snf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yéesu meekissaɓa an: - Ɗú laak mbúurú cera? Ɓa taassa an: - Ciyitnakanak. ");
INSERT INTO snf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Waa ennda ɗa, ya nakka ɓuwaa kiyuŋ kakay. Ya ɓeɓpa mbúurúcaa ciyitnakanakcaa. Ya gërëmmba Kooh, ya weellaca, ya eꞌta tëelíbéecaagari ɓa warohca ɓuwaa. Ɓa warohhaca ɓuwaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓa laakeera ɓan tujën. Ya gërëmmba Kooh gaca, lëehíꞌta ya nakohhaca kiwaroh ɓan. ");
INSERT INTO snf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓaa en ɓéeɓ ñammba bi kappa pút, bi tessa. Iñaa teseeɗa ɓa wookkari: ennda ɗaba ciyitnakanak ga mbúurú na jën. ");
INSERT INTO snf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓuwaa leꞌseera ɓijúnni-nikiis (4.000). Ga waa iñaama leehha, Yéesu tagohha naɓa. ");
INSERT INTO snf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ya dalla kiꞌaas ga loocaa na tëelíbéecaagari, ɓa ɓaa ƴah ɓak gohaa Dalmanutaa. ");
INSERT INTO snf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fërísiyeeŋcaa leꞌussa, ɓa ɓaa coowoh na Yéesu. Ɓa eneeri na kifíꞌ. Ɓa meekissari ya tumiꞌɓa kíntaanaa teewoh an ya meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yéesu íikka hëes, woꞌꞌa an: - Iñii tah ya ɓuwii wati waaru kihot kíntaan? Mi woꞌꞌúuka ee kayoh; ɓuwii wati, ken teewooɓa kíntaan. ");
INSERT INTO snf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Lëehíꞌta Yéesu tagohha naɓa, yaa ƴah. Ya aasissa loocaa kipaaf ɓakaa giiyaa wíinoowaa. ");
INSERT INTO snf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tëelíbéecaa Yéesu alussa kiɓaydohu mbúurú. Ɓa laakee mbúurú wíinoo doŋ naɓa, ga loocaa. ");
INSERT INTO snf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yéesu ɗíŋngaɓa an: - Watukat, ee abukat ga lëwíiraa Fërísiyeeŋcaa na caa ɓuwaa faꞌ na Erootɗa! ");
INSERT INTO snf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tëelíbéecaa enussa ga kiwoꞌ ga díkaantiɓa an: - Dii ɗu laakoo mbúurúɗa kërí tah ya woꞌ iñaama. ");
INSERT INTO snf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yéesu ínohha iñaa ɓa en kiwoꞌ ga díkaantiɓaɗa, woꞌꞌaɓa an: - Iñii tah ya ɗú woꞌ an: dii ɗú laakoo mbúurúɗa kërí tah? Bi wati helciirúu hayyiine? Helciirúu aboo darane? Ɗú yëgísíꞌ keeñciirúu ya? ");
INSERT INTO snf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Man ɗú laakin has, ati ɗú hotoo? Ɗú laakin nof, ati ɗú kelohoo? Ee hanaa ɗú níindísukoo: ");
INSERT INTO snf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ga waa mi weeliꞌ ɓuwaa ɓijúnni-yëtúusɓaa mbúurúcaa ciyëtúuscaaɗa, ɗú wookee pañi cera, caa ɗú líifɗee na mbúurúcaa teseeɗa? Ɓa taassa an: - Cidaaŋkaah na kanak. ");
INSERT INTO snf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yéesu meekisissaɓa an: - Haa ga waa mi weeliꞌ ɓuwaa ɓijúnni-nikiisɓaa (4.000) mbúurúcaa ciyitnakanakcaaɗa, ɗú wookee ɗaba cera, caa ɗú líifɗee na mbúurúcaa teseeɗa? Ɓa taassa an: - Ciyitnakanak. ");
INSERT INTO snf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ya woꞌꞌaɓa an: - Ee helciirúu hayyii bi watine? ");
INSERT INTO snf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yéesu na tëelíbéecaagari karussa Betsaydaa. Ɓuwaa haydohha búumíꞌ ga Yéesu, ɓa kíimmbari kileꞌ ga ɓaa. ");
INSERT INTO snf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yéesu ammba búumíraa ga yahaa, ya meƴca dëkaa nari. Lëehíꞌta ya tumiꞌtari mitoos ga hascaa, ya tíkkari yahcaagari, ya meekissari an: - Fu yii hot yene? ");
INSERT INTO snf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ɓaa malakka hascaa, woꞌꞌa an: - Mi hot ɓiɓoꞌ; iñcii man na tedik, ee cii tíin. ");
INSERT INTO snf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yéesu leꞌissa yahaagari ga hascaa ɓaa. Búumíraa malakka ƴiic, ya wakka, ya yaa hot weceŋ. ");
INSERT INTO snf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Waa ennda ɗa, Yéesu ebilla ɓaa kaanci, ya woꞌꞌari an: - Kaa aas sah dëkii. ");
INSERT INTO snf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yéesu kaꞌta na tëelíbéecaagari ga dëkcaa wíil teeraa Sesaree-Filiipɗa. Ga waasaa, ya meekissa tëelíbéecaa an: - Ɓuwii woꞌu an mi yërí en ɓa? ");
INSERT INTO snf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓa taassari an: - Laakin ɓuwaa woꞌ an fu yërí en Saŋ-Bëtís. Ɓíinoo an fu yërí en sëldíiga Ili. Ɓíinooɓaa an fu bok ga sëldíiga-Koohcii . ");
INSERT INTO snf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ya meekissaɓa an: - Haa ɗú, ɗú woꞌ an mi yërí en ɓa? Peeꞌ taassari an: - Fu yërí en Kiristaanii . ");
INSERT INTO snf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yéesu ɗíŋngaɓa na woꞌeen ciyëgísíꞌ an ɓa hanat kiwoꞌ na ken ga loo iñaa aaw gari. ");
INSERT INTO snf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lëehíꞌta Yéesu yaa ínohlukohɓa an: - Kowukii ɓii jom kikooroh ga mesiklaat ciyewin. Haꞌ-kaancaa, sarahohcaa ɓiyaakɓaa, na jëgíroh-waascaa waaꞌsanndii kihotu gari. Ya hay kiꞌapu ee bes kaahay tík ganaa, ya hay kimílís. ");
INSERT INTO snf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iñaama Yéesu woꞌeeri faŋ, ɗaakéeríi dara ga. Peeꞌ nak nookka Yéesu ga yahaanaa, ya yaa ñaꞌti. ");
INSERT INTO snf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wayee Yéesu mëeñsukka, malakka tëelíbéecaagari, gëtta Peeꞌ an: - Úsaayaaroo, Seytaani! Halaatciigaraa enndii halaatcaa meyoh ga Kooh wayee ca meyoh ga ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lëehíꞌta, Yéesu ɓayya mbooloomaa na tëelíbéecaagari, woꞌꞌaɓa an: - Ɓaa waaꞌ kitaam ga fenooroonaa, ya alat hafci, ya tíkat hafci kuraanaagari, ya taabukkoo. ");
INSERT INTO snf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndaga ɓaa fu waaꞌ kisom kumuunfunaa, fu hayka kiñak, wayee ɓaa mi tahhaa kiñak kumuunfu ga ëldúna, mi na Hewhewii winéwíꞌwiinaa, fu hay kipes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɓoꞌ enoh kilaak iñcii ga ëldúna tóohɗa ya, binaa ya naꞌ kiñak kipesci bi taaraa? ");
INSERT INTO snf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ati laakin iñaa ɓoꞌ mín nawa kilaasoh kipeskaagari? ");
INSERT INTO snf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɓuwii wati dëku ga kiꞌooꞌ Kooh na kitum baakaaꞌ. Ga ɗuuƴɓa, ɓaa mi enndaa kaci ga, mi na woꞌeenndoonaa, fu hay kiꞌen kaci ɓan ga Kowukii ɓii, besaa ya hayan bëríi ga ndamaa Paamci, ya na malaakacaa ɓiselaꞌíꞌɓaa. ");
INSERT INTO snf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yéesu woꞌissaɓa an: - Mi woꞌꞌúuka ee kayoh; ɓiɓoꞌ ga ɓuwii ɓii kaansoo ee ɓa hottii Nguuraa Kooh yoosuk, taam na doolaagari. ");
INSERT INTO snf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tíkka ga bes ciyitniinoo, Yéesu taammba na Peeꞌ, Saak na Saŋ, ya ɓayyaɓa, ɓa rek daa wéetin, ga ɗook jaŋjaŋ wiyaak. Daama jëmmaagari súpítukka ga fíkíiɓa. ");
INSERT INTO snf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kúltícaagari yaanaawwa ɗer bi caa melic, yaanaawlaataa wëeꞌtaa ga an wii laakkii naawohaa en ga ëldúna mín ɗa kisétíꞌ kúltí. ");
INSERT INTO snf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tëelíbéecaa hotussa Ili na Móyíis meyussa ga fíkíiɓa, ɓa ɓaa saawal na Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peeꞌ dalla kiwoꞌ Yéesu an: - Jëgírohii, dii newin garuu. Eneenaa ɗí hëwíꞌ mbaaꞌ kaahay dii: wíinoo wuufu, wíinoo wuu Móyíis, ee wíinoo wuu Ili. ");
INSERT INTO snf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peeꞌ ínohéeríi sah iñaa ya woꞌanɗa ndaga kitíit kihëpíꞌ, ya na tëelíbéecaa tesɗa. ");
INSERT INTO snf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Laakka yaayeelaa hay, úullaɓa. Ee ga ɗuuƴ yaayeelaama, laakka koonaakaa koluk an: - Ɓii yii yërí en Kowukiigoo mi keeñukɗa, súkúrukatti! ");
INSERT INTO snf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga saasi, ga daa tëelíbéecaa malaku iñaa wíilɓaɗa, ɓa hotsissii ken naɓa, enndii Yéesu dogaa. ");
INSERT INTO snf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Daa ɓa enee na kiyoosuk ga jaŋjagaaɗa, Yéesu ɗíŋnga tëelíbéecaa an: - Kaa ɓéestírat ken iñii ɗú hotɗa, bi ga daa Kowukii ɓii mílísan ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tëelíɓéecaa abussa woꞌeenaama, ee ɓa ɓaa woꞌ ga díkaantiɓa an: - Iñii ya waaꞌ kiwoꞌ ga «kimílís ga ɓuwaa kaaninɗa» ya? ");
INSERT INTO snf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lëehíꞌta ɓa meekissa Yéesu an: - Iñii tah ya jëgíroh-waascii woꞌu an Ili yërí ɗewan kihay paaƴ? ");
INSERT INTO snf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya taassaɓa an: - Ee, Ili ɗewan kihay, ya hëwíraat iñaa en tóoh bi jek. Wayee iñii tah ya, Këyítfaa Kooh woꞌ ɓan an Kowukii ɓii hay kikooroh ga mesiklaat ciyewin, ee ya hay kisagu? ");
INSERT INTO snf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mi nak, mi woꞌꞌúu man Ili hayin kumëeñíꞌ. Ɓuwii tumuununndi iñaa neɓɓaɗa, fodaa daa Këyítfaa Kooh bín ga iñaa aaw gariɗa. ");
INSERT INTO snf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waa ɓiYéesu soofussa ga tëelíbéecaa ɓíinoo, ɓa hotta ɓiɓoꞌ ɓiyewin wíiluununɓa ee jëgíroh-waascaa ɓaa coowoh naɓa. ");
INSERT INTO snf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Daa mbooloomaa hotee Yéesu, iñaama bettaɓa. Ɓa ɓaa fool gari kikëñíꞌti. ");
INSERT INTO snf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ya meekissaɓa an: - Ɗú en na kiwoꞌ ya naɓa? ");
INSERT INTO snf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Laakka ɓoꞌ yiƴaal meƴca ga ɓuwaa, woꞌꞌa Yéesu an: - Jëgírohii, mi haydohɗeeraa kowuroo kiƴaal, raɓ nari. Rawii luuɓlukohi hen. ");
INSERT INTO snf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga daa oomaanaa mín kiꞌenoh tóoh, ya mínndi da kiɓúuk. Ya fetalli kakay dal, kúuwkaa oomaanaa kúuwi, ya úñohi síscaa, ya súwoh kas. Mi kíimin tëelíbéeciigaraa ɓa kaal rawii ga oomaanii ee ɓa mínndiika. ");
INSERT INTO snf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yéesu woꞌꞌaɓa an: - Cëeƴ, ɗú ɓuwii wati ee ɗú laakoo ngëmɗa, mi enan narúu bi kera? Mi múuñɗanndúu bi kera? Haydohɗattoo oomaanaa. Ya haydohɗussari. ");
INSERT INTO snf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Oomaanaa yaa hot Yéesu rek, rawaa ga ɗuuƴciɗa yaa saylukohhi didóolíꞌ, oomaanaa dalla kikeen, yaa pírgínuk ga kakayfaa, kúuwkaa kaa kúuw. ");
INSERT INTO snf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yéesu meekissa paamunaa an: - Iñii yii ammbi kera? Paamunaa taassa an: - Ammbi ga waa ya en oomaaɗa bi wati. ");
INSERT INTO snf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ee leekleek rawum ɓúukki ga ɗuuƴ kiwii na ga ɗuuƴ músú, ya waariri kiꞌap. Wayee en lak fu mínin yen ganaa, yërëmaaríi, fu amɗohhíi! ");
INSERT INTO snf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yéesu taassari an: - An fu woꞌ an «En lak fu míninaa?» Iñaa en ɓéeɓ mínukin ga ɓaa fu gëm ga Kooh. ");
INSERT INTO snf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ga saasi paam oomaanaa dalla kiwoꞌ didóolíꞌ an: - Mi gëmin! Amɗohaaroo ga dii ngëmiigoo dooyyiiɗa. ");
INSERT INTO snf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yéesu hotta ga daa ɓuwaa ɓaa fool kihay kilaaƴɗa, ya gëtta rawaa an: - Fu rawii, fu yii fu haydoh kiɗek na kiluuɓɗa, mi nakkaa, meyohaa ga oomaanii ee kaa leꞌis gari bi taaꞌ! ");
INSERT INTO snf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Rawaa meƴca ga oomaanaa na tiweeleeluk, ya yaa saylukohhi didóolíꞌ. Oomaanaa mannda na ɓaa kaan hen, bi ɓoꞌ ɓiyewin daama ɓaa woꞌ an: «Kaanin». ");
INSERT INTO snf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wayee Yéesu ammbari ga yahaa, kolukiꞌtari, oomaanaa tuukka. ");
INSERT INTO snf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lëehíꞌta Yéesu aassa kaan. Lak tëelíbéecaagari doŋ enu nari, ɓa meekissari an: - Iñii tah ya ɗí, ɗí mínéeríi kikaal rawaama ga oomaanaa? ");
INSERT INTO snf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yéesu taassaɓa an: - Kikíim Kooh kërí doŋ mín kiméyíꞌ raɓcaa manɗa ga ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yéesu na tëelíbéecaagari meyohussa daama, ɓa koorohha ɗuuƴ gohaa Gëlílée. Yéesu waaréeríi ɓoꞌ yéeŋ daa ya enohɗa, ");
INSERT INTO snf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ndaga ya enee na kijëgíꞌ tëelíbéecaagari. Ya woꞌeeɓa an: - Kowukii ɓii hay kitíku ga yah ɓuwii. Ɓa hayyi kiꞌap wayee ya kaan bi tík ga bes kaahayaa, ya hay kimílís. ");
INSERT INTO snf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wayee tëelíbéecaa ínohséeríi iñaa woꞌeenaama waaꞌ kiwoꞌɗa, ee ɓa kaañéeríirika kimeekisoh. ");
INSERT INTO snf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yéesu na tëelíbéecaagari leꞌussa Kafarnawom. Ga ɗuuƴ kaanfaa, Yéesu meekissa tëelíbéecaa an: - Ɗú nookohee ya ga waasii? ");
INSERT INTO snf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɓa ɗekka, ndaga ga waasaa, ɓa enee na kinookoh an yaa wëñ kiyak gaɓaɗa, ɓa? ");
INSERT INTO snf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Waa ennda ɗa, Yéesu yuŋnga, ya ɓayya ɓidaaŋkaah na ɓanakɓaa, ya woꞌꞌaɓa an: - Binaa ɓoꞌ, fu waaꞌ kikuliyuk ga yenaa, fu jom kiꞌen ga fenoo ɓéeɓ, fu en súrga ɓuwaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lëehíꞌta ya ɓeɓpa kuꞌoomaa, tuukiꞌtaja ga leelooɓa. Ya ɓeɓpaja, yugiꞌtaja ga kotcaagari, ya woꞌꞌa an: ");
INSERT INTO snf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","- Ɓaa fu teꞌ ga keeñfu oomaanii fodii yii ndaga teekiigoonaa, lakanaa fu teꞌꞌoo, mi ga kihaffoo. Ee ɓaa fu teꞌꞌoonaa, fu teꞌꞌiiroo mi yii yii rek, wayee fu teꞌ ɓan ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Saŋ woꞌꞌa Yéesu an: - Jëgírohii, ɗí hotin ɓaa en na kikaal raɓ ga ɓuwaa ee ga teekfu. Ɗí waaꞌtarika kihoonoh ndaga ya bokkii garuu. ");
INSERT INTO snf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yéesu loffari an: - Kaa hoonohattika, ndaga laakkii ɓaa mín kitum kíntaan ga teekkoo, ee ga saasi ya aaw kiwoꞌ iñaa moroo garoo. ");
INSERT INTO snf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɓaa lebirohhii naruu, faꞌ naruu. ");
INSERT INTO snf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mi woꞌꞌúuka ee kayoh; ɓéeɓ ɓaa onndúu kaas-músú kiꞌan ga teekiigoo ndaga dii ɗú en ɓuuroo mi Kiristaaniiɗanaa, ɓaama ñakoo fayaagari. Yéesu woꞌissa an: ");
INSERT INTO snf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","- Wayee ɓaa baakaaꞌlukoh tuꞌoomaatii tii gëmu garooɗanaa, iñaa gën ga ɓaamaɗa wërí en ya pokɗu atoh wiyaak ga koonaakaa, ya jafu ga ɗuuƴ giiyaa. ");
INSERT INTO snf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɓaa en lak yahaagaraa wërí tahhaa kitum baakaaraa, gúraawa. Iñaa gën garaaɗa wërí en fu aas ga kipeskaa leehoo taaꞌɗa na yah wíinoo, loo kilaak yah kanak ee fu kaꞌ safara, ga kiwiikaa ƴímooɗa.  ");
INSERT INTO snf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ɓaa en lak kotaagaraa wërí tahhaa kitum baakaaraa, gúraawa. Iñaa gën garaaɗa wërí en fu aas ga kipeskaa leehoo taaꞌɗa na kot wíinoo loo kilaak kot kanak ee fu jafu ga safara.  ");
INSERT INTO snf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ee binaa ɓaa en lak kuhaskaagaraa kërí tahhaa kitum baakaaraa, nísaaja. Iñaa gën garaaɗa wërí en fu aas ga Nguuraa Kooh na kuhas kíinoo loo kilaak tuhas tanak ee fu jafu ga safara. ");
INSERT INTO snf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Daama «cëgíncaa ñamsi faanɗa kaansoo ee kiwiikaa ƴímoo taaꞌ.» ");
INSERT INTO snf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","En kiꞌenaa, ɓaa en ɓéeɓ hay kiɗaanu na kiwii. ");
INSERT INTO snf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maraa jofin, wayee binaa maraa safissiinaa, ma ɗaanohsan na ya? Madat na maraa ga ɓimooroommbúu. Laakat jam ga díkaantirúu. ");
INSERT INTO snf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yéesu meyohha daama, aawwa dëkcaa bok ga gohaa Yúudée ee hanoh húlúwaa Yúrdeŋɗa gaaɗa. Ɓuwaa ɓiyewin haysissa, nëgírukohussa ga yahaaci. Ee ya enissaɓa kijëgíꞌ fodaa ya meereeka kitumɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Laakka Fërísiyeeŋcaa hayu bi gari kifíꞌti, ɓa meekissari an: - Waasiiruu onin ƴaal kifasiꞌ ɓeticine? ");
INSERT INTO snf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yéesu meekissaɓa ɓan an: - Móyíis nakeerúu ya kitum? ");
INSERT INTO snf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓa taassa an: - Móyíis oneera ƴaal kibín këyít kiteewoh an sëyaa tasin ee ya foñ ɓetici. ");
INSERT INTO snf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yéesu nak woꞌꞌaɓa an: - Móyíis bínɗinndúu iñaa ya nakkúu yaama ndaga dii ɗú súɓ ga keeñɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wayee ga kiɗewaa, ga waa Kooh sak ëldúnaɗa «Ya tummba ɓoꞌ, ƴaal na ɓeti. ");
INSERT INTO snf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kërí tah bi ƴaal hay kifoñ paamci na eeci, ya aboh na ɓetici, ");
INSERT INTO snf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ee ɓa ɓanak, ɓa en ɓoꞌ yíinoo». Fodaama ɓa enissii ɓanak, wayee ɓa en yíinoo. ");
INSERT INTO snf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kon ɓoꞌ hanat kihëgísoh iñaa Kooh akitohin. ");
INSERT INTO snf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Waa ɓa leꞌꞌa kaan, tëelíbéecaa meekisussa Yéesu iñaa aaw ga iñaama. ");
INSERT INTO snf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya taassaɓa an: - Binaa ɓoꞌ kaal ɓetici, pañ ɓeti yiliisaa, ya ɗúkin ɓetifaagari fiɗewaafaa, ya faanukka na ɓeti filiis. ");
INSERT INTO snf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Fodaama ɓan, binaa ɓeti foñ ƴaalci, pajuk ga ƴaal yiliisaa, ya ɗúkin ƴaalaagari yiɗewaayaa, ya faanukka na ƴaal yiliis. ");
INSERT INTO snf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓiɓoꞌ haydohɗussa Yéesu tuꞌoomaa, ya tík yahcaagari ga ɗookɓa. Wayee tëelíbéecaa ɓaa ñaꞌ ɓuwaama. ");
INSERT INTO snf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Daa Yéesu hotee iñaama, keeñci tammba ga, ya woꞌꞌa tëelíbéecaa an: - Íisat tuꞌoomaatii, ta hay garoo! Kaa hoonohatɓa ndaga Nguurii Kooh wuu ɓuwii man naɓaɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mi woꞌꞌúuka ee kayoh; ɓaa fu tookkii Nguurii Kooh fodii kuꞌoomaanaa, fu aasoo ga. ");
INSERT INTO snf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lëehíꞌta ya ɓeɓpa oomaacaa, ya tíkka yaa en ɓéeɓ yah, barkeellaɓa. ");
INSERT INTO snf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Daa Yéesu enee na kimeƴ kiƴahɗa, laakka ɓoꞌ yiƴaal yaa hay gari na jaaꞌ, ya ƴíꞌꞌa ga fíkíici, meekissari an: - Jëgírohii yijófíꞌyii, mi tuman na bi mi laak ɓakkoo ga kipeskaa leehoo taaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yéesu woꞌꞌari an: - Iñii tah ya fu woꞌ kijof garoo? Ken joffii, enndii Kooh rekaa. ");
INSERT INTO snf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fu ínohin iñii Waasii Móyíis nakoh kitumɗa: «Kaa laŋ kumuun ɓoꞌ; kaa ɗúk ɓetifu wala ƴaalfu, fu faanuk na ɓoꞌ yiliis; kaa lok; kaa seediꞌ saboh; kaa tooñ mooroomfu; kelohɗaa paamfu na eefu.» ");
INSERT INTO snf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɓaa taassari an: - Jëgírohii, mi taabukin iñciima tóoh ga kiꞌoomaaroo bi wati. ");
INSERT INTO snf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yéesu malakka ɓaa, waaꞌtari. Ya woꞌꞌari an: - Laakin iñaa tesohhaa kitum: kara, toonnaa iñaa fu laakɗa tóoh, fu onwa nduulcii. Fodaama fu hay kilaak alal ga ɗook. Lëehíraa haya, fu taabukkoo. ");
INSERT INTO snf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɓaa nak enee ɓoꞌ yiyéwíníꞌ alal, ee daa ya kelohee woꞌeenaama, ya súuñɗukka lool, keeñci leehha ga tak, ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yéesu malakka ɓuwaa wíilliɗa, woꞌꞌa tëelíbéecaagari an: - Kiꞌaaskaa haꞌ-alal ga Nguurii Kooh daal, yoowanndii! ");
INSERT INTO snf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tëelíbéecaa Yéesu waaruꞌussa lool ga woꞌeencaagari. Ee ya tíkissa ga an: - Ɓiƴaay, kiꞌaas ga Nguurii Kooh daal yooɓpii! ");
INSERT INTO snf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Geeleem paaf ga noŋ kúuc, kërí wëñ kiyooɓ daa haꞌ-alal aasan ga Nguurii Kooh. ");
INSERT INTO snf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tëelíbéecaa wëñussa kiwaaruꞌu. Ɓa ɓaa meekisoh ga díkaantiɓa an: - Kon baanaa, ɓii mín kimúc ɓa? ");
INSERT INTO snf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yéesu malakkaɓa, woꞌꞌa an: - Iñaama wooñ ɓoꞌ, wayee wooñnjii Kooh, ndaga iñaa en ɓéeɓ mínkin ga Kooh. ");
INSERT INTO snf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peeꞌ nak dalla kiwoꞌ an: - Malka, ɗí, ɗí foñin tóoh, ɗí taabukinndaa. ");
INSERT INTO snf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yéesu taassari an: - Mi woꞌꞌúuka ee kayoh; ɓaa mi tahhaa kifoñ, mi na Hewhewii winéwíꞌwii, kaan wala ɓikëmëeŋkímun ɓiƴaal na ɓiɓeti, wala ɓiyaakmun ɓiƴaal na ɓiɓeti, eemun wala paamun wala towu, wala yoon, ");
INSERT INTO snf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","fu hay kilaak dii, iñaa wëñ iñcaama bes citéeméeꞌ: kaan ciyewin, na ɓikëmëeŋkímun ɓiƴaal na ɓiɓeti na ɓiyaakmun ɓiƴaal na ɓiɓeti, ɓiꞌeemun, towu na yoon ciyewin. Iñcaama taaban na kihatalu ga ngëm; ee fayuraa fu laak kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɓiyewin ga ɓuwii ɗeɓ watiɗa ɓërí mëeñjohan ee ɓiyewin ga ɓuwii mëeñjohɗa ɓërí ɗewan. ");
INSERT INTO snf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Waa ennda ɗa, ɓa ammba waasaa aaw Yéerúsaleemɗa. Yéesu hanohee fíkíi. Tëelíbéecaagari, helcaagaɓa daléeríi dara ee ɓuwaa ɓíinoo taamsee ga fenoociɗa niikussa. Yéesu ɓaysissa ɓidaaŋkaah na ɓanakɓaa haŋ, ya yaa woꞌɓa iñaa ƴahanndi kidalɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ya woꞌeeɓa an: - Súkúrukat, ɗu ɓii ƴah Yéerúsaleem, ee Kowukii ɓii hay kitíku ga yah sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa. Ɓa hayyi kiꞌattiꞌ kikaan, ɓa tíkki ga yah yiifaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓaama hayyi kiñaawalsoh, ɓa toossohhi, ɓa típpi laawoo, ɓa appi. Lëehíraa, bes kaahay tík ganaa ya mílís. ");
INSERT INTO snf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Saak na Saŋ, towutaa Sebedee, deeyussa ga Yéesu, woꞌussari an: - Jëgírohii, ɗí waaꞌ fu tumiꞌtíi iñii ɗí ƴahhaa kikíimɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yéesu meekissaɓa an: - Ɗú waaꞌ ya mi tumiꞌtúu? ");
INSERT INTO snf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓa taassa an: - Binaa fu en ga ndamaagaraanaa, onaaríi ɗí mín kiyuŋ ga yahaafu, yii hanoh yahfu ñaam, yíinoo hanoh yahfu seŋ. ");
INSERT INTO snf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yéesu woꞌꞌaɓa an: - Ɗú ínohoo iñii ɗú meekisohɗa. Ɗú mínin kiꞌan ga kaas-coonii mi ƴah kiꞌanɗane, wala kibëtísiꞌuk ga mesiklaat fodii dii mi ƴah kibëtísiꞌukɗane? ");
INSERT INTO snf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓa taassa an: - Ee ɗí míninka. Yéesu woꞌꞌaɓa an: - En kiꞌenaa, ɗú hay kiꞌan ga kaasii mi ƴah kiꞌanɗa ee ɗú hay kibëtísiꞌuk ga mesiklaat fodii dii mi ƴah ga kibëtísiꞌukɗa. ");
INSERT INTO snf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wayee en iñaa aaw ga kiyuŋ ga yahhoo ñaam wala ga yahhoo segaa, enndii mi jomka kiwoꞌ. Ɓuwaa Kooh waayukiꞌ ɓakcaamaɗa ɓërí ƴahca kiꞌeru. ");
INSERT INTO snf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Daa tëelíbéecaa tesɗa kelohsee iñaama, ɓa dalla kiꞌayluk Saak na Saŋ. ");
INSERT INTO snf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yéesu dallaɓa kiɓay, woꞌꞌaɓa an: - Ɗú ínohin an, ɓuwii tíku haꞌ-kúl ga ëldúnaɗa, ɓërí teewi ɓuwii an ɓa hanoh ɓéeɓ ɗook , ee haꞌ-doolicii tumlukohi ɓuwii ga iñaa neɓɓa. ");
INSERT INTO snf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Iñaa manɗa hanat ɗa kilaak ga ɗuuƴcúu. Wayee laak ɓaa waaꞌ kiꞌen ɓoꞌ yiyaak ga ɗuuƴcúunaa, ya joman kiꞌen súrgarúu, ");
INSERT INTO snf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ee ɓaa waaꞌ garúu kikuliyukaa, ya joman kiꞌen ñaam ɓuwaa tóohɓa. ");
INSERT INTO snf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","En kiꞌenaa, kiheel súrga tahhii Kowukii ɓii kihay, wayee ka hay kiꞌen súrga ɓuwii, na kiꞌeroh kumuunci doo ya laas tumuun ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yéesu na tëelíbéecaagari leꞌussa Yéríkóo. Waa ɓa meyoh ga teeraama na ɓiɓoꞌ ɓicaakíꞌ, laakka búumíraa teeku Bartímée, kowu Tímée, yugin ga yahaanaa waasaa, yaa sarahtuk. ");
INSERT INTO snf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Daa ya kelohee an Yéesu Nasareet yaa hay, ya yaa fiip an: - Yéesu, kucaasamunkii Dëwít, yërëmaaroo! ");
INSERT INTO snf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓuwaa ɓaa ñaꞌti, an doo ya ɗekoh. Wayee ya yaa wëñ kifiip an: - Kucaasamunkii Dëwítóo, yërëmaaroo! ");
INSERT INTO snf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yéesu tuukka, woꞌꞌa an: - Ɓayatti. Ɓuwaa ɓayya búumíraa, ɓa ɓaa woꞌꞌi an: - Dëlɗaa heliigaraa, kolka, ya yii ɓayyaa. ");
INSERT INTO snf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Búumíraa dalla kijaf paltaagari, ya kolukka bërít, yaa hay ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yéesu meekissari an: - Fu waaꞌ ya mi tumiꞌtaa? Búumíraa taassari an: - Jëgírohii, tumɗaaroo bi mi mín kihot. ");
INSERT INTO snf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yéesu woꞌꞌari an: - Tíida, ngëmiigaraa wëkɗinndaa. Ga saasi búumíraa mínnda kihot, lëehíꞌta ya yaa taabuk Yéesu ga waasaa ya am kiƴahɗa. ");
INSERT INTO snf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Waa Yéesu na tëelíbéecaagari deeyussa Yéerúsaleem, ɓa enee ga yahaa dëkaa Betfasee na waa Bétaníi, en ga ɓak tëgëlaa Ólíwíyéecaaɗa, Yéesu wossa ɓoꞌ ɓanak ga tëelíbéecaagari, ");
INSERT INTO snf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","woꞌꞌaɓa an: - Karat dëkum en ga fíkíirúuɗa. Ɗú aasi danaa, ɗú hoti cúmbúꞌ-baamaa ɓoꞌ lappii duum, pokuunun daama. Pëkísatti, ɗú haydohhi dii. ");
INSERT INTO snf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ee binaa ɓoꞌ meekissúu an: «Iñum ɗú tum yuma ya?», Taasatti an: «*Haꞌmudii yërí laak sooli ga. Ee ya hayyi kiwosoh dii diima-diima.» ");
INSERT INTO snf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tëelíbéecaa karussa, ɓa laakka cúmbúꞌ-baam ga mbedaa, pokuunun ga fooh ga yahaa hal-kaan daama. Ɓa pëkíssari. ");
INSERT INTO snf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓiɓoꞌ ga ɓuwaa ensee daamaɗa woꞌussa tëelíbéecaa an: - Ɗú tum ya yuma? Iñii tah ya ɗú pëkís cúmbúrii? ");
INSERT INTO snf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓa taassa ɓuwaa fodaa daa Yéesu nakeeɓaɗa. Ɓuwaa íisussaɓa, ɓa ɓaa hay. ");
INSERT INTO snf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓa haydohiꞌta Yéesu cúmbúraa, ɓa tíkka paltucaagaɓa ga ɗookgaa, Yéesu lappa. ");
INSERT INTO snf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓiɓoꞌ ɓiyewin ɓewussa paltucaagaɓa, larussaca ga ɗook waasaa. Ɓíinoo, ɓaa gúꞌ toy ga tediktaa ga yooncaaɗa, ɓa ɓaa ɓool tuuꞌtaa, ɓaa laꞌta ga waasaa. ");
INSERT INTO snf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓuwaa hanohsee Yéesu fíkíi na ɓuwaa taamsee ga fenoociɗa, ɓéeɓɓa ɓaa woꞌ didóolíꞌ an: - Óosaanaa! Kooh barkeelat yii hay ga teekii Haꞌmudiiɗa! ");
INSERT INTO snf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kooh barkeelat Nguurii en na kihayɗa, Nguurii caasammbíi Dëwít! Óosaanaa aaw ga ɗookaa-ɗook! ");
INSERT INTO snf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yéesu leꞌꞌa Yéerúsaleem, ya aassa Kaanfaa Kooh. Ga waa ya malakka bi jof, tóoh iñaa laak daamaɗa, ya yaa ƴah Bétaníi na tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa, lak Kooh yaa hooɓ. ");
INSERT INTO snf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga kooh-wíisfaa, Yéesu na tëelíbéecaa meyohussa Bétaníi, laak Yéesu yaawin. ");
INSERT INTO snf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ya séennda diꞌúsaayíꞌ eenaa kífin. Ya kaꞌta kimalak ati ya hay kihot towu ga. Wayee waa ya deeƴca kedikkaa, ya hottii dara ga, enndii tuuꞌtaanaa. Waama lak ñiidaa een laaki towuɗa leꞌꞌii. ");
INSERT INTO snf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Waa ennda ɗa, Yéesu woꞌꞌa kedikkaa an: - Ken ñamsisoo kowukaa meyoh garaa, bi taaꞌ! Tëelíbéecaa kelohussa ga iñaama. ");
INSERT INTO snf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yéesu na tëelíbéecaagari leꞌussa Yéerúsaleem. Daa Yéesu aasee Kaanfaa Kooh, ya yaa kaal ɓuwaa ensee na kitoon na ɓuwaa ensee na kilom daamaɗa. Ya yaa ɓúuk taabulcaa weciꞌoh-kopaꞌcaa, na yugaahcaa toonoh-hoꞌcaa. ");
INSERT INTO snf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ee ya íiséeríi ken kiɓay yen na kikooroh nawa ga ɗuuƴ Kaanfaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lëehíꞌta ya yaa jëgíꞌɓa fodii dii: - Bíduunun ga Këyítfaa Kooh an: «Kaanndoo teeksan kaanfaa heetcii tóoh kíimohohsan Kooh»? Wayee ɗú, ɗú tumwa ɗaakkaaꞌ lok! ");
INSERT INTO snf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Daa sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa yéeŋsee iñaa laakee yaama, ɓa niikkari ndaga lak ɓuwaa tóoh waaruꞌuunun ga jëgírohaagari. Fodaama, ɓa ɓaa heel daa ɓa tuman bi ɓa apluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga waa nohaa soossa, Yéesu na tëelíbéecaagari meyohussa teeraa. ");
INSERT INTO snf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga daa Yéesu na tëelíbéecaagari koorohsee ga kímaa cuutɗa, ɓa hotta eenaa Yéesu cojeeɗa súwin kaw bi ga níilcaa. ");
INSERT INTO snf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peeꞌ níindísukka iñaa laakeeɗa, ya woꞌꞌa Yéesu an: - Jëgírohii, malka, eenii fu cojeeɗa súwin. ");
INSERT INTO snf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yéesu woꞌꞌaɓa an: - Gëmat ga Kooh. ");
INSERT INTO snf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mi woꞌꞌúuka ee kayoh; Binaa ɓoꞌ woꞌ jaŋjagii wii an: «Kolkohaa dii, fu jafuk ga ɗuuƴ giiƴ», ya hay kitookɗu iñaama, binaa ya laakkii hel kanak ga, ee ya gëm an iñaa ya woꞌɗa hay kilaakaa. ");
INSERT INTO snf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kërí tah mi woꞌꞌúu man: Ɗú en ga kikíim Kooh ya onndúu yenaa, gëmat an ɗú laasin ga, en ɗanaa ɗú hay kitookɗu iñaa ɗú kíimɗa. ");
INSERT INTO snf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ee bëríinaa ɗú tuuk kikíim Kooh ɓéeɓ, en lak ɗú abin mooroommbúu aylukaa, bayalatti, doonaa Paammbúu yii ga ɗookɗa bayallúu ɓan tooñciigarúu.  ");
INSERT INTO snf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yéesu na tëelíbéecaa soofussa Yéerúsaleem. Ee ga daa Yéesu enee na kitíidisuk ga Kaanfaa Koohɗa, sarahohcaa ɓiyaakɓaa, jëgíroh-waascaa na yaakcaa hayussa gari. ");
INSERT INTO snf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɓa meekissari an: - Iñcii fu tumɗa, fu aƴca ga ɓa? Ɓii onndaa dooli kimínca kitum ɓa? ");
INSERT INTO snf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yéesu taassaɓa an: - Mi hayyúu kimeekisoh enaama yíinoo ɓan. Ɗú taassoo ganaa, mi woꞌꞌúu iñcii mi tumɗa ati mi aƴca ga ɓa? ");
INSERT INTO snf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɓii yiida wosee Saŋ kibëtísiꞌ ɓuwaa? Kooh wala ɓoꞌ-súusúus? Taasattoo? ");
INSERT INTO snf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wayee ɓa ennda ga kiwoꞌ ga díkaantiɓa an: - Binaa ɗu taas an Kooh yërí woseerinaa, ya hay kiwoꞌ an «Iñii tah ya ɗú gëmmbii ga Saŋ?» ");
INSERT INTO snf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ee binaa ɗu woꞌ an ɓuwii ɓërí woseerinaa… Ɓa niikeera mbooloomaa ndaga ɓéeɓɓa tíksee Saŋ sëldíigaa Kooh. ");
INSERT INTO snf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Waa ennda ɗa, ɓa taassa Yéesu an: - Ɗí ínohoo. Yéesu woꞌꞌaɓa an: - Haa, mi ɓan, mi woꞌoorúu iñcii mi tumiɗa ati mi aƴca ga ɓa? ");
INSERT INTO snf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lëehíꞌta Yéesu yaa liiwukɓa an: - Enee ɓoꞌ, ya yíppa tedik-reseŋ ga yoonci. Ya ɗíŋnga yoonaa, ya acca nogaa towu-reseŋtaa seesohsan. Ya tawahha daa ɓoꞌ mínan kituukoh, tíim yoonaa, malaki ga. Lëehíꞌta ya ɓeɓpa ɓilínoh, sassaɓa kilëgëy ga yoonaa, ya yaa ƴah kiɓaaɓ. ");
INSERT INTO snf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ga waa kiɓeen leꞌꞌa, ya wossa súrga ga línohcaa ga yoonaaɗa, ɓa kommbi ɓakci ga iñaa ɓa ɓeenɗa. ");
INSERT INTO snf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wayee ɓa ammba súrgaa, ɓa feekkari, ɓa kaallari yah ɓuucuuc. ");
INSERT INTO snf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Haꞌ-yoonaa wosissa súrga yiliis gaɓa. Ɓa feekkari ga haf, ɓa ɓaa ɓassohhi. ");
INSERT INTO snf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Haꞌ-yoonaa wossissa yukaahay, ɓa appari, ee ɓa tummba fodaama súrga ɓiyewin ɓiliis: ɓa feekka ɓii, ɓa appa ɓii. ");
INSERT INTO snf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Haꞌ-yoonaa tesoheeri kowuci kíinoo, kaa ya waarin lool. Ya mëeñdohhari kiwos gaɓa, ee ya halaatta an: «Hanaa ɓa hay kiꞌon kowuroo céeꞌ.» ");
INSERT INTO snf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wayee línohcaama ɓaa woꞌ ga leelooɓa an: «Yii ƴah kilamɗa yeema, hayat ɗu appi ee ɗu lam yoonii.» ");
INSERT INTO snf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓa ammba kowukaa, ɓa appaka, ɓa jaffa faraaffaa ga fenoo yoon-biiñaa. ");
INSERT INTO snf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yéesu meekissa ɓuwaa an: - Haa haꞌ-yoonaa tuman na? Ya hay kihay, ya ap línohcaa, ya ek ɓiɓoꞌ ɓiliis ga yoonaa. ");
INSERT INTO snf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Man ɗú jagin woꞌeenaa Kooh bídu ga Këyítfaa an: «Atohaa tawahohcaa jafeeɗa, atohaama enin atoh-koñ. ");
INSERT INTO snf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iñaama yërí Haꞌmudii tum ee enin kíntaan ga hasciiruu!» ");
INSERT INTO snf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓaa heel kiꞌam Yéesu ndaga ɓa ínohha an Yéesu liiwukeeɓa ga woꞌeenaama. Wayee ɓa kaañéeríi mbooloomaa; ɓa íissari, ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Laakka Fërísiyeeŋcaa ebilu na ɓuwaa faꞌ na Erootɗa ga Yéesu, kifíꞌti ga ɗuuƴ woꞌeen. ");
INSERT INTO snf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓa hayyari kiwoꞌ an: - Jëgírohii, ɗí ínohin an fu woꞌ kayoh, ee fu niikkii ken, ndaga fu malkirii ɓoꞌ ga jëmmaagari, wayee fu jëgíroh Waas-Kooh kayoh-kayohɗa. Woꞌaaríi, waasii onohin kifay buuꞌ Sesaaꞌ lempune? Ɗí jomin kifay wala ɗí jomoo kifay? ");
INSERT INTO snf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wayee Yéesu ínohha helaagaɓa ɓa ɗaakɗa, ya woꞌꞌaɓa an: - Iñii tah ya ɗú waaꞌtoo kifíꞌ? Haydohɗattoo hëelís denariyon wíinoo, mi malak. ");
INSERT INTO snf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓa haydohha ga wíinoo. Yéesu meekissaɓa an: - Nataalii wii wuu ɓa, na teekii en gaɗa? Ɓa taassa an: - Cuu Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Daama, Yéesu woꞌꞌaɓa an: - Kon erat Sesaaꞌ iñaa Sesaaꞌ laak, ɗú eꞌ Kooh iñaa Kooh laak. Ɓa waaruꞌꞌa lool ga iñaa Yéesu taasɓa yaama. ");
INSERT INTO snf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Laakka Saduseyeeŋcaa hayu ga Yéesu. Ɓa nak, ɓa woꞌ an kimílís laakoo ga ɓuwaa kaanɗa. Ɓa meekissa Yéesu anee: ");
INSERT INTO snf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","- Jëgírohii, Móyíis nakeeruu kitum iñii yii: «Binaa ɓoꞌ, yaakci kaan ee lak foñnjii ɓetici na kowaa, ya jomin kilam ɓetifaama ee ya laakiꞌ yaakci kowu ga.» ");
INSERT INTO snf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waama, laakee ƴaal ɓiyitnaɓanak ɓaa bok paamun na eemun. Yaakkaa pañnja, kaannda ee ya laakkii kowu. ");
INSERT INTO snf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yukanakyaa pañnja ɓetifaa ee laakkii nari kowu, ya kaannda. Yukaahayyaa ennda ɗa. ");
INSERT INTO snf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ee ɓiyitnaɓanakɓaa ɓéeɓɓa faanussari ɓeti ee laakkii ken gaɓa yaa foñ kowu nari. Ga waa ɓa kaannda ɓéeɓɓa, ɓetifaa ɓan tíkka ga. ");
INSERT INTO snf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Diimaɗa woꞌaaríi, bëríinaa ɓuwii mílísan ga kikaanɗa, ɓetifaama ƴah kiꞌen yuuɓa? Ndaga yaa en ga ɓéeɓ ga ɓiyitnaɓanakɓaa tumeerari ɓeti. ");
INSERT INTO snf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yéesu taassaɓa an: - Ɗú woꞌin kimúuƴcúu ee iñaa tahkaɗa, dii ɗú ínohoo iñaa bídu ga Këyítfaaɗa ee ɗú ínohoo daa doolaa Kooh hín kiyakɗa. ");
INSERT INTO snf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Binaa ɓuwaa kaanɗa mílísunaa, ƴaal pajoo ee ɓeti pajukoo, wayee ɓa pesan madu na malaakacii Kooh enu ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","En iñaa aaw ga kimílískaa ɓuwaa kaanɗanaa, hanaa ɗú mosoo kijaŋ këyítfaa Móyíis bín ga daa ya woꞌ ga loo bos-dútúkaa abee kiwiiɗa? Kooh woꞌ Móyíis an: «Mi yërí en Koohyii Abaraham, Koohyii Ísaak na Koohyii Yakoop». Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kooh enndii yuu ɓuwaa ƴah kikaanɗa wayee yuu ɓuwaa ƴah kipesɗa. Ɗú ɓii ga kimúuƴ kiyaak. ");
INSERT INTO snf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Laakka jëgíroh-waasaa keloh ga daa ɓa en na kiwoꞌɗa, ya hotta an taasaa Yéesu taas Saduseyeeŋcaaɗa júwin, ya deeƴca gari, meekissari an: - Iñii yiida kuliyuk ga iñcii nakohu kitumɗa? ");
INSERT INTO snf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yéesu taassari an: - Wii wërí ɗeɓ: «*Ɓu-Isarayeelóo súkúrukat! Haꞌmudii, Koohyiigaruu, yërí rek en Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Fu waaran Haꞌmudii, Koohyiigaraa na keeñaagaraa tóoh, na kipeskaagaraa tóoh na helaagaraa tóoh, ee na doolaagaraa tóoh.» ");
INSERT INTO snf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ee wii wërí en wukanakwii. «Fu waaran mooroomfu fodaa daa fu waaꞌ haffuɗa.» Laakoo iñaa nakohu, ee wëñ kanakcuma kiyak. ");
INSERT INTO snf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jëgíroh-waasaa woꞌꞌa Yéesu an: - Jofin, Jëgírohii! Iñii fu woꞌɗa, kayoh: Haꞌmudii yërí rek en Kooh, ee laakoo Kooh yiliis enndiirinaa. ");
INSERT INTO snf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kiwaaꞌ Kooh na keeñaagaraa tóoh na helaagaraa tóoh na doolaagaraa tóoh, ee ɓan kiwaaꞌ mooroomfu fodaa daa fu waaꞌ haffuɗa, wërí wëñ kiyak júuraa hoosu, tëkíꞌɗu Kooh, na kitumiꞌ Kooh sarahaa mín kiꞌen ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yéesu hotta an ɓaa taasohin na hel, ya woꞌꞌari an: - Fu úsaayyii ga Nguurii Kooh. Waa ennda ɗa, ken kaañissiiri kimeekisis yen. ");
INSERT INTO snf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga daa Yéesu jëgírohee ga ɗuuƴ Kaanfaa Koohɗa, ya meekisohee an: - Jëgíroh-waascii mín na kiwoꞌu an Kiristaanii kucaasamun Dëwít? ");
INSERT INTO snf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ndaga Dëwít ga kihafci, ga waa ya líif na Helaa yiselaꞌíꞌyaaɗa, ya woꞌin an: «Kooh, Haꞌmudii woꞌꞌa Haꞌmudiigoo an: Yugohaaroo yah-ñaam, bi ga daa mi tuman ɓuwii saŋngaaɗa ditogaaꞌ kotfu». ");
INSERT INTO snf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dëwít, ga kihafci, ɓay ɓaama «Haꞌmudii»: Kon tum na bi Kiristaanii mín kiꞌen kucaasamun rek ga Dëwít? Mbooloo wiyaak waa súkúruk Yéesu ee iñaama neɓpaɓa ga keeñ. ");
INSERT INTO snf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yéesu jëgíreeɓa an: - Abukat ga kitum fodii jëgíroh-waascii. Ɓa waari kitíidisuk na kúltí ciyaak. Ɓa en ga paancaanaa, ɓa waari kikëñɗu yah kanak. ");
INSERT INTO snf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga ɗuuƴ jaangu-yaawúuꞌcaa, ɓa heeli kiyuŋ ga fíkíi; ee en ga hewaa, ɓa waari kihanoh fíkíi. ");
INSERT INTO snf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓa teꞌi iñaa laak ga kaan ɓeticaa ƴaalcaagaɓa lísussiiɗa; ee ɓa maañi ga kikíim Kooh, an doo ɓuwaa fooŋ an ɓa júwin. Attiꞌaa Kooh attiꞌanɓaɗa wërí wëñan kimesik. ");
INSERT INTO snf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lëehíꞌta Yéesu yuŋnga, ëewrukohha na iñaa sarahcaa teꞌohsi ga Kaanfaa Koohɗa. Ya malakee ga daa ɓuwaa enee na kiɓúuk kopaꞌcaa ga ɗuuƴgaaɗa. Haꞌ-alal ɓiyewin ɓaa ɓúuk da kopaꞌ ciyewin. ");
INSERT INTO snf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Laakka ɓan ɓetifaa hay, laakoo dara ee ƴaalci kaanin. Ya ekka daama tuhanjaꞌ-hëelís tanak, taa leꞌoo dërëm. ");
INSERT INTO snf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yéesu ɓayya tëelíbéecaagari, woꞌꞌaɓa an: - Mi woꞌꞌúuka ee kayoh; ɓetifii laakoo dara fii erohin iñaa ken ɓúukkiiri ga teꞌaaꞌ-sarahii. ");
INSERT INTO snf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndaga ɓéeɓɓa onoh ga iñaa ɓa wëñíꞌɗa, wayee ya, ga kinduulci, ya erohin tóoh iñaa ya laakeeɗa, tóoh iñaa ya jomee kipesohɗa. ");
INSERT INTO snf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yéesu enee na kimeƴ Kaanfaa Koohɗa, laakka ga tëelíbéecaagari yaa woꞌꞌi an: - Jëgírohii, malkaa dii atohcii moꞌɗa, na dii tawahcii yakɗa! ");
INSERT INTO snf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yéesu taassari an: - Fu hotin ga tawahcii ciyaakcii ciine? Tesohanndii dii sah atoh wíinoo waa tíkiskohan na mooroomwa, tóoh hay kiɓúꞌ. ");
INSERT INTO snf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yéesu yuŋnga ga ɗook tëgëlaa Ólíwíyéecaa, óowrúkohha na Kaanfaa Kooh. Ga daa ɓa wéetee nari daamaɗa, Peeꞌ, Saak, Saŋ na Andari meekisohussari an: ");
INSERT INTO snf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","- Woꞌaaríi, iñaama laakan kera, ee mandargii wiida teewohan an iñcii cii ɓéeɓca jomin kilaak? ");
INSERT INTO snf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yéesu kon yaa woꞌɓa an: - Tumat ndaŋ doo ken ɗúkoorúu. ");
INSERT INTO snf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɓiɓoꞌ ɓiyewin hay kikoorohu teekkoo, ɓa woꞌi an: «Mi yërí en Kiristaanii!» Ee ɓa hay kiɗúk ɓoꞌ ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Binaa ɗú keloh yëngël heñ wala an heñ laakin ga ɗekataa, kaa tíitat, ndaga iñcaama jomin kilaak, wayee lak ëldúna leꞌꞌii kitúkíꞌ duum. ");
INSERT INTO snf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","En kiꞌenaa, kúl hay kiɓewuk, keen ga ɗook kúl mooroomci, ee nguuꞌ hay kiɓewuk, keen ga ɗook nguuꞌ mooroomci; kakayfii hay kiyëngëluk ga ɗekat ciyewin ee aꞌ hay kilaak. Iñaama ƴah kiman na dalaaraa mesiklaatcaa ga kimatuk ɓetiɗa. ");
INSERT INTO snf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Wayee ɗú, tumat ndaŋ ga haffúu. Ɗú hay kiɓayu paancaa yaawúuꞌcaa, ɗú hay kirípu na ngeeꞌ ga ɗuuƴ jaangu-yaawúuꞌcaa. Mi hay kitah bi ɗú hay kituukɗu ga fíkíi haꞌ-nguuꞌcii na ga fíkíi buuꞌcii, doonaa ɗú tuukuk Hewhewii winéwíꞌwii ga fíkíiɓa. ");
INSERT INTO snf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hewhewii winéwíꞌwii jomin kiyéegalohu paaƴ ga heetcii tóoh. ");
INSERT INTO snf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Binaa ɗú abu kiɓayunaa, helciirúu dalat ga iñaa ɗú joman kiwoꞌɗa, ee woꞌat rek iñaa Kooh onanndúu kiwoꞌ ga wahtaama siiꞌɗa, ndaga enndii ɗú ƴah kiwoꞌ, wayee Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yaakmun hay kiꞌeroh këmëeŋkíci ya tíku kikaan. Paamun hay kiꞌeroh kowuci ka tíku kikaan. Oomaacaa hay kiɓeɓku, keenu ga ɗook paamɓa na eewɓa, aplukɓa. ");
INSERT INTO snf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi hay kitah bi ɓoꞌ ɓiyewin hayyúu kisagu. Wayee ɓaa fu guuꞌguuluk bi ga daa tóoh leehanaa, fu yaama fu hay kimúc. ");
INSERT INTO snf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","- Bëríinaa ɗú hotan ɓaa woꞌu “yiꞌaraamíꞌyaa pooki kúlɗa” aas ga daa ya jomoo kiꞌaasɗanaa -- ee ɓaa fu jaŋ iñii yiinaa, tumaa ndaŋ!-- Ɓuwaa iñaama laakan Yúudéeɗa, ɓa núpat ɓa aaw jaŋjaŋcaa. ");
INSERT INTO snf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɓaa iñaama laakanndi yugin kiꞌíikaruk ga ɗook taahaagariɗa, hanat kisek kiyoosuk kiɓeɓ yen ga ɗuuƴ túuƴci, ");
INSERT INTO snf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ee ɓaa iñaama laakan yooncaaɗa, hanat kiɓoyuk kaan kiɓeɓnee kúltífaagari. ");
INSERT INTO snf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Massa ɓeticaa bescaama laakanɓa na look, na ɓaa ensan na kiɓëpíꞌɗa! ");
INSERT INTO snf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kíimat Kooh ati iñcaama hídohoo ga wahtu ñiin wiméeskíꞌ. ");
INSERT INTO snf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ndaga ga bescaama, mesiklaatcaa dalan ɓuwaaɗa hay kiyak yakaa wëeꞌtaa ga an wii, mossii kilaak iñaa man ɗa, aboh ga waa Kooh ɗeɓ kisak ëldúnaɗa bi wati, ee iñaa madan ɗa laakisanndii bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ee binaa newéeríi Haꞌmudii ya nëewís bescaamanaa, eneenaa ken múcoo, wayee ɓuwaa ya tanɗa tahha bi ya nëewíssaca. ");
INSERT INTO snf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kon binaa ɓoꞌ woꞌꞌúu an: «Malkat, Kiristaanii yii dii!» wala «Malkat, ya yaa daa!» Kaa gëmat. ");
INSERT INTO snf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","En kiꞌenaa, ɓiɓoꞌ hay kikoluk, ɓa tík hafɓa Kiristaa na ɓisëldíiga-Kooh ee lak saboh. Ɓa tumi kíntaan na enaama cidóoyíꞌ-waaꞌ kiɗúk sah, enee an mínukinaa, ɓuwaa Kooh tanukɗa. ");
INSERT INTO snf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Watukat haffúu, mi yéegalinndúu tóoh balaa dara hewanaa. ");
INSERT INTO snf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","- Wayee ga bescaama, lak coonucaa ɓuwaa dayanɗa paafin, nohii dal kiñúusíꞌ, ñiidii íis kileeꞌ, ");
INSERT INTO snf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tuꞌoltaa hay ɗëegískoh asamaan ta keen, ee tóoh iñcii en ga asamaaniiɗa hícukoh. ");
INSERT INTO snf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Fodaama Kowukii ɓii hay kihotu ga ɗuuƴ yaayeelcii, ka yoosuki ee ka taam na dooli wiyaak na ndam. ");
INSERT INTO snf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ya hay kiwos malaakacaa ɓa nëgíroh ɓuwaa ya tan, enu ga ɓakcii cinikiiscii ga ëldúnaɗa, aboh ga dii kakayfii dalohɗa bi ga daa fa eemoh. ");
INSERT INTO snf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","- Malkat iñii een jëgíꞌtúu ga iñaamaɗa. Binaa toytaa kedikkaa neꞌ kineꞌ bi, ee tuuꞌtaa dal kitapisaa, ɗú ínoh an lah deeyin. ");
INSERT INTO snf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Fodaama ɓan, binaa ɗú hot iñcaama ca laakaa, ínohat an Kowukii ɓii deeyin, ya leꞌin halii. ");
INSERT INTO snf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mi woꞌꞌúuka ee kayoh; bi ɓuwii wati kaanu ɓéeɓɓanaa, iñcaama tóoh hay kilaak. ");
INSERT INTO snf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asamaanii na kakayfii hay kifaay wayee woꞌeenndoo faayoo múk. ");
INSERT INTO snf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","- En loo iñaa aaw ga besaa wala wahtaa iñaama laakohanɗa, ken ínohoowa. Enndii malaakacaa ga asamaanɗa, ee enndii sah Kowukii. Paamudii doŋ ínohwa. ");
INSERT INTO snf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Watukat, kaa neehat ndaga ɗú ínohoo wahtaa Kowukii ɓii ƴah kihayɗa. ");
INSERT INTO snf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iñaama madan na fodii ɓoꞌ yaa en na kiƴah kiɓaaɓ: Ya meƴ kaanci, ya tíkfa ga yah súrgacaagari. Ya eꞌ yaa en ɓéeɓ iñaa ya jom kilëgëyɗa. Ya nak ɓaa ƴah kituuk ga hal-kaadaaɗa kineeh kiwatuk. ");
INSERT INTO snf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kon kaa neehat ndaga ɗú ínohoo ati haꞌ-kaanfii hayan kera. Ati ƴah lak Kooh hoowin, ati ga leeloo wek, ati lak siikaa kodin, ati ga kím. ");
INSERT INTO snf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Binaa ya en jalañ ga fíkíirúunaa, ya hanattúu kibet lak ɗú ɓii neeh. ");
INSERT INTO snf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iñii mi woꞌꞌúu yii, mi woꞌka ɓaa en ɓéeɓ, kaa neehat! ");
INSERT INTO snf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bes kanak tesee ga, balaa feetaa Paak leꞌ na feetaa ɓuwaa ñami mbúurúcaa laakoo lëwíiꞌɗa. Sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa ɓaa heel daa ɓa tuman bi ɓa am Yéesu ndaŋ ee ken yéegoo, ɓa aplukki; ");
INSERT INTO snf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ndaga ɓa woꞌee an: - Ɗu hanatka kitum ga besaa feetaa, enndiikanaa hay kihaydoh coow wiyaak ga ɗuuƴ ɓuwii. ");
INSERT INTO snf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Daa Yéesu enee ga Bétaníi, ga kaan Simoŋ yaa gaanaꞌeeɗa, laakka ɓetifaa aas gaɓa, lak ɓaa ñam. Ɓetifaa ɓayee kujúlúŋkaa hëwrohu na atohaa woꞌu albataaꞌ. Kujúlúŋkaa tum laꞌkoleñ wiséeríꞌ, waa koocussii ee hëwrohu na kedikkaa woꞌu naaꞌ. Daa ya pookee kúuwkaa kujúlúŋkaa, ya aammba laꞌkoleñaa ga hafaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ga ɓuwaa en daamaɗa, laakka ɓuwaa ayluk ga iñaama, ɓa ɓaa woꞌ ga díkaantiɓa an: - Laak ya jeriñ kiyasoh laꞌkoleñii wii foduma? ");
INSERT INTO snf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ɓoꞌ míneerawa kitoon iñaa wëñ denariyon citéeméeꞌ-kaahay, ee kopaꞌcaama eru nduulcii! Ɓa ɓaa coow ga ɗook ɓetifaa. ");
INSERT INTO snf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wayee Yéesu woꞌꞌa an: - Íisatti yas. Ɗú sodalohhi ya? Iñii ya tumiꞌtooɗa jekin. ");
INSERT INTO snf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndaga nduulcii, ɗú ɓii naɓa besaa en ɓéeɓ, ee ɗú mínɓa kitumiꞌ iñaa jekin wahtaa ɗú waaꞌka ɓéeɓ, wayee mi ƴahhii narúu kiꞌen dii besaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɓetifii tumin iñaa ya mínɗa: Ya ɗëwírukin kileef laꞌkoleñ ga faanfiigoo, en waayukaa loyaagoo. ");
INSERT INTO snf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mi woꞌꞌúuka ee kayoh; ga daa Hewhewii winéwíꞌwii wii mín kiyéegalohu ɓéeɓ, ga ëldúna, iñii ɓetifii yii tumɗa hay kiɓéestíru ee ɓuwaa hayyika kiníindísukoh. ");
INSERT INTO snf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Waa ennda ɗa, yíinoo ga ɓidaaŋkaah na ɓanakɓaa, Yúdaa Iskariyot, kaꞌta ga sarahohcaa ɓiyaakɓaa kiwoꞌɓa kitoon Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Daa ɓa kelohee iñaa ya woꞌɗa, keeñcaagaɓa soossa ga, bi ɓa díŋngari hëelís. Yúdaa yaa heel besaa ya jekelukan bi ya mín kitík Yéesu ga yahɓa. ");
INSERT INTO snf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ga besaa ɗeɓ ga feetaa ñamsi mbúurúcaa laakoo lëwíiꞌɗa ee bëríi tubaaltaa hoossi fodii sarah Paakɗa, tëelíbéecaa Yéesu meekisohussari an: - Fu waaꞌ gada ɗí kaꞌtaa kiwaayukiꞌ ñamahii Paak? ");
INSERT INTO snf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yéesu ɓayya ɓoꞌ ɓanak ga tëelíbéecaagari, wossaɓa an: - Karat teeraa, ɗú hay kihídoh na ɓaa koorukin kujataa músú, laa taabukatti, ");
INSERT INTO snf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ee daa ya ƴah kiꞌaasohɗa, woꞌat haꞌ-kaanfaa an: «*Haꞌmudii meekisoh an: Túuyii mi ƴah kiñamoh Paakɗa wada, mi na tëelíbéeciigoo?» ");
INSERT INTO snf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ee ya hayyúu kiteeɓ túuƴ wiyaak waa hanoh ɗook, waa hëwruunun bi tóoh jekin. Ɗú waayukan ñamahcaa ɗu ñamanɗa ga ɗekataama. ");
INSERT INTO snf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tëelíbéecaa karussa, leꞌussa teeraa, ɓa laakka tóoh fodaa daa Yéesu woꞌeeɓakaɗa. Ɓa hëwíꞌta ñamahaa Paak. ");
INSERT INTO snf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga noh-soosaa, Yéesu leꞌꞌa na ɓidaaŋkaah na ɓanakɓaa. ");
INSERT INTO snf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Daa ɓa yugee daama ɓaa ñamɗa, Yéesu woꞌꞌa an: - Mi woꞌꞌúuka ee kayoh; yíinoo garúu ee yii ñam naroo, hayyoo kitoon. ");
INSERT INTO snf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tëelíbéecaa, keeñɓa leehha ga iñaama ee ɓa ɓaa meekissi yíinoo yíinoo an: - Mi yëríne? ");
INSERT INTO snf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yéesu taassaɓa an: - Yíinoo garúu ɗú ɓidaaŋkaah na ɓanakɓii, ee bok naroo kiꞌek yah ga kankiiɗa, yërí ya. ");
INSERT INTO snf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","En kiꞌenaa, Kowukii ɓii, kii ga waas kikaan fodaa daa Këyítfaa woꞌka gariɗa, wayee massa ɓaa yaama ƴah kitoon Kowukii ɓiiɗa! Ɓaama límséeríinaa, iñaama gënee gari! ");
INSERT INTO snf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lakanaa ɓaa ñam, Yéesu ɓeɓpa mbúurú, ya gërëmmba Kooh, lëehíꞌta ya weellawa, ya eꞌtawa tëelíbéecaa, woꞌꞌaɓa an: - Uunat, faanfiigoo fërí fa. ");
INSERT INTO snf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lëehíꞌta ya ɓeɓpa kaas-biiñ, ya gërëmmba Kooh, lëehíꞌta ya eꞌtaɓawa, ɓéeɓɓa annda ga. ");
INSERT INTO snf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya woꞌꞌaɓa an: - Ñífiigoo wërí wa, ñífii pok kifiiliimuukiigarúu na Kooh, ee wa aamɗu ɓoꞌ ɓiyewinɗa. ");
INSERT INTO snf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mi woꞌꞌúuka ee kayoh; mi ƴahissii múk kiꞌanis anahaa meyoh ga kedik-reseŋ bi ga besaa mi anan biiñaa wiꞌaswaa ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Waa ennda ɗa, ɓa ƴeekka ƴeek-Kañcaa, lëehíꞌta ɓa kaꞌta tëgëlaa Ólíwíyéecaa. ");
INSERT INTO snf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yéesu woꞌꞌa tëelíbéecaagari an: - Ɓéeɓpúu, ɗú hay kinúp ɗú foñnjoo, ndaga bíduunun ga Këyítfaa an: «Mi hay kiꞌap níirohaa, ee baalcaa tasarsukohu.» ");
INSERT INTO snf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yéesu tíkka ga an: - Wayee binaa mi mílísaa, mi hayyúu kiɗëwíruk Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peeꞌ woꞌꞌari an: - Luu enee an ɓuwii tesɗa tóoh hay kinúpu, foñussaa, mi, mi núpoo mi foñnjaa. ");
INSERT INTO snf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yéesu taassari an: - Fu, mi woꞌꞌaaka ee kayoh, ga wekii wati doŋ sah, bi siik pabu kon bes kanakaa, fu hayyoo kitaasuk waas kaahay. ");
INSERT INTO snf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wayee Peeꞌ ɓewissa didóolíꞌ an: - Mi taasukooraa múk, luu enee an mi joman kikaan naraa. Ee tëelíbéecaa ɓéeɓɓa ɓaa woꞌ fodaama. ");
INSERT INTO snf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lëehíꞌta Yéesu na tëelíbéecaa karussa ɗekataa woꞌu Getsemanee, ee ya woꞌꞌa tëelíbéecaagari an: - Yugat dii, mi kaꞌ kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya ɓayya Peeꞌ, Saak na Saŋ, ɓa taam nari. Faanfaagari faa dal kinúp, ya yëecírukka, ");
INSERT INTO snf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ya woꞌꞌaɓa an: - Keeñnjoo leehin bi mi yii kaanan. Tesat dii ee kaa neehat. ");
INSERT INTO snf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ya kaꞌta bi ga ɓak fíkíi, ya leꞌꞌa kakay, yaa kíim an wahtaama úsaayyi, enee an mínkinaa. ");
INSERT INTO snf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ya woꞌee an: - Abaa Buba, iñaa en ɓéeɓ mínkin garaa, úsaayɗaa kaas-coonii wii garoo! Wayee hanat kiꞌen iñaa mi waaꞌ wayee iñaa fu waaꞌɗa laakat. ");
INSERT INTO snf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya sooffa ga tëelíbéecaa, ya laakkaɓa ɓaa neeh, ya woꞌꞌa Peeꞌ an: - Simoŋ, fu yii neehe? Fu mínndii kiwíisoh luu enee sah wahtu wíinoone? ");
INSERT INTO snf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kaa neehat ee kíimat Kooh doonaa ɗú keenoo ga fíraa Seytaani. Ɓoꞌ daal keeñaa waarin wayee faanfaa tookkii. ");
INSERT INTO snf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ya úsaaysissaɓa daa karam, yaa kíim na woꞌeencaa caca. ");
INSERT INTO snf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ya soofissa gaɓa, ya laakkaɓa ɓaa neeh ndaga lak hascaagaɓa abin pëní. Ee ɓa ínohéeríi iñaa ɓa woꞌanndi. ");
INSERT INTO snf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga waa ya soofis ga waasaa wukaahaywaaɗa, ya woꞌꞌaɓa an: - Ɗú ɓii lís kineeh na kiꞌíikaruke? Dooyin! Wahtii leꞌin. Malkat, Kowukii ɓii kii ƴah kitíku ga yah ɓuwii waaꞌtii Koohɗa. ");
INSERT INTO snf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kolkat, ɗu ƴee! Malkat, yii ƴahhoo kitoonɗa, yii deeƴ. ");
INSERT INTO snf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ga saasi, lak Yéesu yaa lís kiwoꞌ, Yúdaa Iskariyot, yaa bok ga ɓidaaŋkaah na ɓanakɓaaɗa leꞌꞌa. Laakka ɓuwaa taabu nari, ɓayuunun kalaɓ na dooꞌ. Sarahohcaa ɓiyaakɓaa, jëgíroh-waascaa na yaakcaa yaawúuꞌcaa ɓërí woseeɓa. ");
INSERT INTO snf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yii on Yéesu bíiŋɗa eree ɓuwaa lëdíꞌ mandarga an: «Ɓaa mi ƴah kifuunɗa, yërí ya. Abatti, ɗú ɓayyi ee ɗú watukki bi jof.» ");
INSERT INTO snf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Daa Yúdaa leꞌ hen, ya deeƴca ga Yéesu, woꞌꞌa an: - Jëgírohii! Lëehíꞌta ya fuunnda Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Fodaama, ɓuwaa ɓíinoo tíkussa yah ga Yéesu, abussari. ");
INSERT INTO snf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɓoꞌ ga ɓuwaa enee daamaɗa ɗolla kalaɓfaagari, típpafa súrgaa haꞌ-kaadaa sarahohcaa, gúꞌta nofaa. ");
INSERT INTO snf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yéesu woꞌꞌaɓa an: - Mateera ga ɗú hayyoo kiꞌam, ɗú taam na kalaɓcii na dooꞌcii, man na ɓuwaa dawuk tumoh-kofeele? ");
INSERT INTO snf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mi enee ga ɗuuƴcúu besaa en ɓéeɓ, mi jëgírohee ga ɗuuƴ Kaanfaa Kooh, ee ɗú mossiiroo kiꞌam. Wayee iñii yii laak, doonaa iñaa Këyítfaa woꞌeeɗa mat. ");
INSERT INTO snf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Waa ennda ɗa, tëelíbéecaa ɓéeɓɓa foñussari ɓaa núp. ");
INSERT INTO snf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Laakka oomaa-fiilaa taabukki, ɓayee úuf rek ga faanci. Ɓuwaa ɓaa heelli kiꞌam, ");
INSERT INTO snf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ya foñnja úufaa naɓa, ya yaa saan faan ɓuucuuc. ");
INSERT INTO snf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓuwaa ɓayya Yéesu ga haꞌ-kaadaa sarahohcaa, ga daa sarahohcaa ɓiyaakɓaa, haꞌ-kaancaa na jëgíroh-waascaa hídohseeɗa. ");
INSERT INTO snf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peeꞌ yaa taabukki diꞌúsaayíꞌ bi ga ɗuuƴ hëtaa kaanfaa haꞌ-kaadaa sarahohcaa. Daama, ya yuŋnga na súrgacaa, yaa yoonuk. ");
INSERT INTO snf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sarahohcaa ɓiyaakɓaa na ɓuwaa bok ga paanaa yaawúuꞌcaa wiyaakwaaɗa tóoh ɓaa heel woꞌeenaa ɓa pokɗan Yéesu bi ɓa mínndi kiꞌapluk wayee ɓa hottii. ");
INSERT INTO snf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","En kiꞌenaa, ɓoꞌ ɓiyewin pokɗuseerari woꞌeen, wayee iñcaa ɓa woꞌeeɗa taabéeríi. ");
INSERT INTO snf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Laakka ɓuwaa koluk kipokiꞌti iñii wii: ");
INSERT INTO snf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","- Ɗí kelohin yaa woꞌ an: «Mi hay kipook Kaanfii Kooh, fii hëwrohu na yah ɓoꞌɗa, ee mi tawah filiis ga bes kaahay, faa hëwrohsanndii na yah ɓoꞌ.» ");
INSERT INTO snf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wayee ga iñaama sah woꞌeencaagaɓa taabéeríi. ");
INSERT INTO snf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Waa ennda ɗa, haꞌ-kaadaa sarahohcaa kolukka ga fíkíi ɓéeɓ, meekissa Yéesu an: - Fu taasoo dara ga iñii ɓuwii ɓii yammbaaɗane? ");
INSERT INTO snf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wayee Yéesu taassii, ɗekohha cel. Haꞌ-kaadaa sarahohcaa meekisissari an: - Fu yërí en Kiristaaniine, Kowukii Kooh yii laak ndamɗane? ");
INSERT INTO snf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yéesu taassa an: - Ee, mi yërí ya, ee ɗú hay kihot Kowukii ɓii yuŋ, hanoh yah-ñaabaa Kooh yii wëñ ɓéeɓ dooliɗa, ee ɗú hayyi kihot ya taam na yaayeelcii asamaan ya yoosuki. ");
INSERT INTO snf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Daama, haꞌ-kaadaa sarahohcaa ɗaꞌta kúltífaagari ndaga kiꞌayluk, ya woꞌꞌa an: - Ɗu laakis ya sooli ga woꞌeen seedi? ");
INSERT INTO snf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɓéeɓpúu ɗú keloh ga, ɓasin Kooh. Ɗú ínoh ya ga? Ɓuwaa ɓéeɓ tíkussa Yéesu saboh ee ɓa woꞌꞌa an ya jomin kiꞌapu. ");
INSERT INTO snf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Laakka ɓuwaa dalu kitoos ga ɗook Yéesu, ɓa kúnnda fíkíifaanaa, ɓa dúukiri ee ɓa woꞌiri an: - Líiruka, woꞌaa ɓii feekkaaɗa? Ee súrgacaa abussari, ɓaa mútisohhi na paꞌcaa. ");
INSERT INTO snf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Daa Peeꞌ enee ga hëtaa ga kakayɗa, laakka mbíndaanaa hay, bok ga ɓuwaa lëgëyiꞌ haꞌ-kaadaa sarahohcaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ya hotta Peeꞌ yaa yoonuk, ya malakkari, woꞌꞌa an: - Fu ɓan, fu enee na Yéesu Nasareet . ");
INSERT INTO snf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wayee Peeꞌ taasukka an: - Fu woꞌ ya? Mi ínohoo iñii fu waaꞌ kiwoꞌɗa. Lëehíꞌta ya kolukka, meyohha hëtaa, yaa aaw ɓak halaa. Siik-pabu konnda. ");
INSERT INTO snf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wayee mbíndaanaa hottari, dalissa kiwoꞌ ɓuwaa enee daamaɗa an: - Ɓii yii bok gaɓa! ");
INSERT INTO snf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peeꞌ taasukissa. Ga fíkíi jutuut, ɓuwaa enee daamaɗa woꞌsissa Peeꞌ an: - Fu jom kibok gaɓa, ndaga fu ɓan, fu kúlkoh Gëlílée. ");
INSERT INTO snf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Daama Peeꞌ yaa en ga kicojuk na kiwaat an: - Mi ínohoo ɓaa ɗú woꞌꞌoo yaama. ");
INSERT INTO snf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ga ɗekataama, siik-pabu konnda kodaa wukanakwaa. Peeꞌ níindísukka iñaa Yéesu woꞌeeriɗa, an: «Balaa siik pabu kon bes kanakaa, fu hayyoo kitaasuk waas kaahay.» Peeꞌ ennda ga kikoduk. ");
INSERT INTO snf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga kímaa cuut, sarahohcaa ɓiyaakɓaa, yaakcaa yaawúuꞌcaa, jëgíroh-waascaa na ɓuwaa tes boku ga paanaa yaawúuꞌcaa wiyaakwaaɗa, hídohussa kituukiꞌ yen ga iñaa aaw ga Yéesu. Ɓa poklukkari, ɓa ɓayyari, tíkussari ga yah Pílaat. ");
INSERT INTO snf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pílaat meekissa Yéesu an: - Fu Yërí en buurii yaawúuꞌciine? Yéesu taassari an: - Fu yii woꞌka. ");
INSERT INTO snf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sarahohcaa ɓiyaakɓaa yabussa Yéesu ga enaama ciyewin. ");
INSERT INTO snf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pílaat meekisissa Yéesu an: - Fu taasoone? Man fu keloh ga iñcii ɓa yammbaaɗa! ");
INSERT INTO snf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wayee Yéesu taasissii, iñaama jaahalla Pílaat. ");
INSERT INTO snf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ga feet Paakaa en ɓéeɓ, Pílaat méyíꞌɓa ɓoꞌ yíinoo ga ɓuwaa abu ga kasuɗa, yaa mbooloomaa waaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Waama, lak laakin ɓaa en ga kasu, teeku Barabaas, ya na ɓuwaa taabee nariɗa. Ɓa apee ɓoꞌ ga heñaagaɓa na nguuraa Roomɗa. ");
INSERT INTO snf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbooloomaa lappa bi ga kaan Pílaat, ɓa meekissari ya tumiꞌɓa iñaa ya meereeɓa kitumiꞌɗa. ");
INSERT INTO snf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pílaat meekissaɓa an: - Ɗú waaꞌ mi méyíꞌtúu buurum yaawúuꞌciine? ");
INSERT INTO snf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ya woꞌee iñaama ndaga ya ínoheera an kisootukoh Yéesu tahee bi sarahohcaa ɓiyaakɓaa tíkussari ga yahci. ");
INSERT INTO snf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wayee sarahohcaa ɓiyaakɓaa ɓaa obis ɓuwaa ɓa woꞌ Pílaat ya namiꞌɓa kiméyíꞌ Barabaas. ");
INSERT INTO snf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pílaat ɓeɓsissa daa karam an: - Kon mi tuman na, na ɓii ɗú teek buurii yaawúuꞌciiɗa? ");
INSERT INTO snf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓa ɓaa fiipis an: - Daayaari ga kuraa! ");
INSERT INTO snf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pílaat meekissaɓa an: - Iñii yibóníꞌyii ya tumɗa ya? Wayee ɓa ɓaa wëñ kifiip didóolíꞌ an: - Daayaari ga kuraa! ");
INSERT INTO snf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pílaat waaree kisóosíꞌ keeñcaa ɓuwaa, ya méyíꞌtaɓa Barabaas; lëehíꞌta ya feeklukka Yéesu na karawaas, ya erohhari kidaaƴsunee ga kuraa. ");
INSERT INTO snf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldaaꞌcaa ɓayussa Yéesu ga ɗuuƴ kaanfaa haꞌ-kúlkaa (wërí en ga Peretuwaaraa), ɓa nëgírohha soldaaꞌcaa fodaa gaɓaɗa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓa ekka Yéesu kúltí fiyoꞌoh cor, ee ɓa tíkíꞌtari ga hafaa iñaa fodii baanu-buuꞌ, terohu na lúp, wíillawa. ");
INSERT INTO snf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lëehíꞌta ɓa ɓaa këñíꞌti an: - Pesa, buurii yaawúuꞌcii! ");
INSERT INTO snf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ee ɓa feekiri ga haf na dooꞌ, ɓa toosi ga ɗookci, ee ɓa ƴíꞌi ga fíkíici fodii ɓaa ɓa eꞌ céeꞌ. ");
INSERT INTO snf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Waa ɓa lëehíꞌtari kiñaawalsoh fodaama, ɓa nísíꞌtari kúltífaa fiyoꞌohfaa, ɓa ekissari kúltícaagari. Lëehíꞌta ɓa ɓayyari fooh, kidaaƴneeri ga kuraa. ");
INSERT INTO snf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Soldaaꞌcaa gítínussa ɓaa woꞌu Simoŋ ee dëk Síreen, paam ɓiꞌËlíksaan na Rufus, kiníkuk kuraanaa Yéesu. Lak ya en na kipaaf, ya meyoh yooncaa. ");
INSERT INTO snf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓa ɓayya Yéesu bi ga ɗekataa woꞌu Golgotaa, wërí en «Loon-haf». ");
INSERT INTO snf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓa eꞌtari biiñaa atukohu na mëkín kedikkaa woꞌu míiꞌɗa, wayee ya saŋnga. ");
INSERT INTO snf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɓa daaƴcari ga kuraanaa, ɓa warohha kúltícaagari, ɓa yípee tukiisii kiꞌínoh iñaa ɓaa en ɓéeɓ laakanɗa. ");
INSERT INTO snf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Enee ga wahtu yooꞌ-yooꞌ ga waa ɓa daaƴci ga kuraanaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iñaa bínsee ga ɗook kuraanaa ee ɓéestíꞌ iñaa tahhi kiꞌapuɗa enee: «Buurii yaawúuꞌcii». ");
INSERT INTO snf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓa daaƴca ga kuraa fodaagari tumoh-kofeel ɓanak, yii ga yahci ñaam, yíinoo ga yahci seŋ.  ");
INSERT INTO snf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓuwaa kooree daama ɓaa paafɗa, ɓaa këkít haf, ɓaa ɓassi an: - Aca! Fu yii fu woꞌ an fu ƴah kipook Kaanfaa Kooh ee fu tawahisfa ga bes kaahayɗa, ");
INSERT INTO snf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","somaa haffu, fu yoosuk ga kuraanii! ");
INSERT INTO snf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sarahohcaa ɓiyaakɓaa ɓan na jëgíroh-waascaa, ga ɗuuƴɓa, ɓaa ñaawalsoh Yéesu an: - Ya músalin ɓuwii ɓíinoo ee ya mínoo hafci kimúsal! ");
INSERT INTO snf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ya Kiristaanii, buurii ɓu-Isarayeel, ya yoosukat kimma ga kuraanii ati ɗí mín kihot ee ɗí gëm! Ɓuwaa daaƴsee ga kuraa fodaa Yéesuɗa, ɓaa ɓassi ɓan. ");
INSERT INTO snf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ga wahtaa nohaa tuuk ga ɗookɗa, bi ga wahtu kigoonaluk, Kooh ñúussa kërúus ga kúlkaa tóoh. ");
INSERT INTO snf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ee ga wahtu kigoonaluk, Yéesu lessa koonaa didóolíꞌ an: - Élóyí, Élóyí, lema sabaktani? (Wërí en: «Koohyiigoo, Koohyiigoo, iñii tah ya fu foñnjoo?») ");
INSERT INTO snf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga ɓuwaa enee daamaɗa, laakka ɓuwaa, daa ɓa keloheeri ɓa dalla kiwoꞌ an: - Súkúrukat, yii ɓay Ili! ");
INSERT INTO snf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yíinoo gaɓa foolla, ɓeɓpa epoos, ñoonndawa ga biniigaꞌ, ya pokkawa ga siñdaa dooꞌ, lëehíꞌta ya noonndawa Yéesu ya ɗuuƴwa, ee yaa woꞌ an: - Íisat rek ɗu malak ati Ili hayyi kihay kiyóosíꞌ ati na! ");
INSERT INTO snf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wayee Yéesu lessa koonaa kiyaak, lëehɗukka. ");
INSERT INTO snf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rídóonaa wiyaakwaa poksee ga ɗuuƴ Kaanfaa Kooh, kún ɗekataa wëñ kiselaꞌɗa dalla kiɗaꞌ kom kanak, aboh ga ɗook bi ga kakay. ");
INSERT INTO snf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldaaraa yiyaakyaa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa ee tuukee ga fíkíi Yéesuɗa, daa ya hotee ga kaanaa Yéesu waama, woꞌꞌa an: - Kayoh-kayohɗa, ɓii yii enee Kowu Kooh! ");
INSERT INTO snf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Laakeera ɓan ɓeticaa ensee diꞌúsaayíꞌ, ɓaa malak ga. Mërí-Malleen bokee gaɓa, na Salomee na Mërí eew ɓiSaak yijutuut na Yosee. ");
INSERT INTO snf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓeticaama ɓërí taamsee na Yéesu ee ɓaa toputuꞌussi ga waa ya en ga Gëlíléeɗa. Laakeera daama ɓan ɓeti ɓiyewin ɓiliis ɓaa taamsee nari Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ga besaa waayukaa feetaa, ennda goonataa besaa Sabat, lak Kooh yaa hooɓ, ");
INSERT INTO snf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yoseef ee dëk teeraa Arímatee, hayya. Iñaa ɓoꞌ yiyaak ga ɓuwaa bok ga paanaa yaawúuꞌcaa wiyaakwaaɗa. Ee ya ɓan ya sekee Nguuraa Kooh. Ya laakka fít kikaꞌ ga Pílaat kimeekisohhi faraaffaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kiteel kikaankaa Yéesu betta Pílaat. Ya ɓaylukka kon soldaaraa yiyaakyaa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa, kimeekissi ati Yéesu maañin kikaan. ");
INSERT INTO snf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Daa soldaaraa taaseeri ga iñaama, ya onnda Yoseef kiɓeɓ faraaffaa. ");
INSERT INTO snf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoseef lommba píis fodii mëlíkaan, yóoskíꞌta Yéesu ga kuraanaa, múullari ga píisaa, lëehíꞌta faanneerari ga noŋ-loyaa yotu ga atoh. Lëehíꞌta ya pírgínnda atoh wiyaak, laŋnga halaa loyaa. ");
INSERT INTO snf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mërí-Malleen na Mërí eew ɓiYoosee ɓaa malak ga daa Yéesu ekohuɗa. ");
INSERT INTO snf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga waa besaa Sabat paaffa, Mërí-Malleen, Salomee na Mërí eew Saak lomussa laꞌkoleñ kiꞌéeñíꞌnee faraaffaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cuut ga kímaa besaa ɗeɓ ga siminaaɗa, lak nohaa waa meƴ, ɓa ɓaa ƴah loycaa. ");
INSERT INTO snf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓa ɓaa woꞌ ga díkaantiɓa an: - Ati ɓii ƴahhuu kipírgíniꞌ atohaa ga halaa loyaa, bi úsaayɗa ɓa? ");
INSERT INTO snf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wayee daa ɓa malak hen, ɓa hotta an atohaa enee wiyaakaa-yaak waama, pírgínuunun bi hanohin yahaa. ");
INSERT INTO snf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɓa aassa loyaa Yéesu. Ɓa hotta oomaa-fiilaa ekuk kúltí fihooꞌta ee fiyaanaaw ɗer, yugin ga ɓakaa hanoh yah-ñaamɗa. Ɓa tíitta. ");
INSERT INTO snf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wayee oomaa-fiilaa woꞌꞌaɓa an: - Kaa tíitat. Ɗú heel Yéesu Nasareet, ɓaa daaƴsee ga kuraanaaɗa. Mílísin! Ya gaa dii. Malkat, ɗekatii ya faanohseeɗa weema. ");
INSERT INTO snf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wayee karat, ɗú woꞌnee Peeꞌ na tëelíbéecaa tesɗa an ya ɗëwírukinndúu Gëlílée, ɗú hotnanndi daama, fodaa daa ya woꞌeerúukaɗa. ");
INSERT INTO snf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɓeticaa meƴca loyaa, ɓaa núp. Ɓaa saak ndaga kitíit. Ee ɓa woꞌꞌii ken dara ndaga kiniik.  ");
INSERT INTO snf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Waa Yéesu mílíssa ga kímaa besaa ɗeɓ ga siminaaɗa, ya ɗeɓpa kiteewukoh ga Mërí-Malleen yaa ya nísee gari raɓcaa ɓiyitnaɓanakɓaaɗa. ");
INSERT INTO snf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mërí-Malleen yaama kaꞌtaka kiɓéestíꞌ ɓuwaa enee nariɗa, ya laakkaɓa ɓaa feekoh haf, ɓa ɓaa looyoh. ");
INSERT INTO snf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Waa ɓuwaama kelohu an Yéesu yaa pes ee Mërí-Malleen hotinndiɗa, ɓa gëmmbiiri. ");
INSERT INTO snf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tíkíssa ga, Yéesu teewukohha ga ɓoꞌ ɓanak ga tëelíbéecaa, na jëmma wiliis, lak ɓa meyin dëkaa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓa ɓoyukka kiyéegalka tëelíbéecaa tesɗa, wayee ɓa gëmmbiiɓa ɓan. ");
INSERT INTO snf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yéesu mëeñdohha kiteewukoh ga tëelíbéecaa ɓidaaŋkaahɓaa na yíinooyaa, lak ɓa en na kiñam. Yéesu ñaꞌtaɓa ga daa ɓa gëmmbiiɗa, na daa ɓa yëgís ga keeñ bi ɓa tookkii kigëm woꞌeencaa ɓuwaa hotti, lak ya mílísinɗa. ");
INSERT INTO snf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lëehíꞌta ya woꞌꞌaɓa an: - Wíilat ëldúna tóoh, ɗú jangatnee Hewhewii winéwíꞌwii ga ɓuwii ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɓaa gëm garoo ee ya bëtísiꞌunaa, hay kimúc, wayee ɓaa gëmmbiinaa hay kiꞌattiꞌu kikaan. ");
INSERT INTO snf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ee kíntaancii cii cërí taabukan ɓuwii gëmanɗa: ga teekkoo, ɓa hay kikaal raɓcaa ga ɓuwaa, ɓa hay kiwoꞌ lak ciꞌas. ");
INSERT INTO snf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Luu ɓa abee goŋ ga yahcaagaɓa, ɓa an ndom, dara dalooɓa. Ɓa hay kitík yahcaagaɓa ga ɗúukoolíꞌcaa, ee ɓaama hay kiwak. ");
INSERT INTO snf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Waa Yéesu, Haꞌmudii, lëehíꞌta kiwoꞌ naɓa fodaama, ya ɓëwírussa, aawwa asamaan, ee ya yugohneera Kooh ga yah-ñaabaagari. ");
INSERT INTO snf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tëelíbéecaa karussa daa en ɓéeɓ kijangatnee Hewhewaa winéwíꞌwaa. Haꞌmudii yaa lëgëy naɓa ee teewohha na kíntaancaa taam gaɗa, an woꞌeenaa Kooh kayoh. Aameen.");
INSERT INTO snf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fiilii Tewoofíil, Ɓoꞌ ɓiyewin daluunun kibín tóoh iñaa laakee dii ga ɗuuƴcíiɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɓa ɓéestíꞌka fodaa daa ɓuwaa maasohsee iñaama woꞌseeka na kúuwɓaɗa, ga waa iñaama dal, ee ɓa enee yéegalohcaa woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kërí tah, Kiyaakii, mi ɓan waa mi heella bi jof wëeꞌwëeraa ga iñaa laakeeɗa tóoh, aboh ga dalaaraa, helloo kaꞌta ga kiɓéestíꞌtaaca ga bín wíinoo wíinoo. ");
INSERT INTO snf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Fodaama fu ínoh bi jof an iñii fu jëgíruɗa, kayoh fiyaak. ");
INSERT INTO snf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Waama lak Eroot en buuꞌ ga kúlkaa Yúudée. Laakka sarahohaa teeku Sakarí, bokee ga lagaa sarahohcaa ensee na Abíyaaɗa. Ɓetici teeksee Ilisabeet ee bokee ga gíiraa Aaron. ");
INSERT INTO snf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakarí na ɓetici Ilisabeet júɓseera ɓéeɓɓa ga fíkíi Kooh, ɓa taabuki ga daa gënɗa Waas-Kooh na iñaa ya nakohɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wayee ɓa laakéeríi kowu ndaga Ilisabeet mínéeríi kilaak, ee ɓa ɓanak, ɓa ensee yaak. ");
INSERT INTO snf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laakka bes, Sakarí enee na kitum lëgëy-sarahohaagari ga fíkíi Kooh, lak ɓuwaa ya bok naɓaɗa, ɓërí hëyrohee kitum bëríi. ");
INSERT INTO snf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ga baahaa sarahohcaa, ɓa daani kiyíp tudooꞌ kiꞌínoh ɓaa iñaama hídan gariɗa. Iñaa hínnda ga Sakarí, ya jommba kiꞌaas ɗuuƴ Kaanfaa Kooh ga ɗekataa wëñ kiselaꞌɗa, kitëkíꞌ cúuraayaa. ");
INSERT INTO snf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ɓiɓoꞌ ɓiyewin enussa ga fooh, ɓaa kíim Kooh daama ga wahtaa cúuraayaa taaluɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Waa ennda ɗa, laakka malaakaa Kooh meƴ ga fíkíi Sakarí, tuukohha iñaa hanoh yah ñaabaa ɗekataa tëkírohsi cúuraayɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Daa Sakarí hoteeri hen, fítaagari tuukka tek, ya tíitta tír. ");
INSERT INTO snf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wayee malaakaa woꞌꞌari an: - Kaa niik dara Sakarí, iñaa fu kíimɗa Kooh tookɗinndaari: Ɓetifu Ilisabeet hayyaa kilaakiꞌ kowu kiƴaal, ee fu teekanka Saŋ. ");
INSERT INTO snf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Keeñfu hay kisoos gari lool, ee ɓoꞌ ɓiyewin hay kineɓluku ga kilímukkaagari. ");
INSERT INTO snf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ndaga ya hay kiꞌen ɓoꞌ yiyaak ga fíkíi Haꞌmudii. Ya ƴahhii anoh, enndii biiñ enndii anahaa laallukohi ɓoꞌ, ee aboh ga daa ya enan sah ga lookaa eeciɗa, ya hay kilíif na doolaa Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ya hay kitah bi ɓu-Isarayeel ɓiyewin gëmaatu ga Haꞌmudii en Koohyiigaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ya hay kitíin ga fíkíi Kooh, líif na hel na doolaa sëldíiga Ili ɓayeeɗa. Ya júwohíꞌ paamuncaa na towutaa, ya haydoh keeñ sagoh-taycii ga halaat cijúwíꞌ; fodaama ya waayukiꞌ Haꞌmudii ɓuwaa sekanndiɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakarí loffa malaakaa an: - Mi ínohan iñaama na? Ndaga mi guꞌgi, ee ɓetiroo ɓan yakakin. ");
INSERT INTO snf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaakaa taassari an: - Mi yërí en Gëbíríyeel. Mi en ga fíkíi Kooh, kitum iñaa ya nakohɗa. Ya woseeroo kiwoꞌꞌaa na kiyéegallaa Hewhewii winéwíꞌwii wii. ");
INSERT INTO snf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Diima fu hay kiluuɓ, fu mínanndii kiwoꞌ bi ga daa iñii mi woꞌɗa laakan, ndaga fu gëmmbii woꞌeeniigoo ƴah kilaakoh ga wahtaagawaɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Waama, lak ɓuwaa ensee na kikíim Kooh ga foohɗa ɓaa sek Sakarí daama. Ɓa jaahliꞌꞌa ga daa ya tes iñaa maañin ga ɗekataa wiselaꞌíꞌwaa ga ɗuuƴ Kaanfaa Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ga waa ya meƴca, ya mínndii naɓa kiwoꞌ ee ɓa ínohha an ya hot yen ga ɗekataa wiselaꞌíꞌwaa. Ya tessa luuɓ, ee ya woꞌi naɓa na yahcaa. ");
INSERT INTO snf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Waa bescaa Sakarí jomee kihëyroh ga Kaanfaa Koohɗa leehha, ya ɓoyukka kaanci. ");
INSERT INTO snf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bes cera tíkka ga, ɓetici Ilisabeet ennda na look. Ya ɗaakukka ñiin ciyëtúus ga kaanci. Ya woꞌee ga ɗuuƴci an: ");
INSERT INTO snf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Iñii yii, Kooh tumiꞌtoori: Ya malkinndoo bi ya nísinndoo ga iñaa enee kaciroo ga ɗuuƴ ɓuwiiɗa.» ");
INSERT INTO snf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Waa lookaa Ilisabeet laak ñiin ciyitniinooɗa, Kooh wossa malaaka Gëbíríyeel ga teeraa Nasareet, ga gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ya wossari ga oomaa-jowaa onohu kipañ ga oomaa-fiilaa teeku Yoseef, kucaasamun Dëwít. Oomaa-jowaa teeku Mariyaama. ");
INSERT INTO snf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaakaa aassa kaan Mariyaama, woꞌꞌari an: - Jam namohat naraa, fu yii Haꞌmudii teeɓ kijofkiigariɗa! Ya yii naraa. ");
INSERT INTO snf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Daa Mariyaama kelohee iñaa malaakaa woꞌ yaama, fítaagari tuukka tek. Ya yaa woꞌ ga helaagari an: «Këñɗohuma waaꞌ yee kiwoꞌe?» ");
INSERT INTO snf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaakaa woꞌꞌari an: - Mariyaama, kaa niik, fu newin Kooh. ");
INSERT INTO snf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Diima, fu hay kiꞌen na look, fu laak kowu kiƴaal, fu teekka Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ya hay kiyak ga fíkíi ɓuwii ee ya teeksan Kowukii yii ga ɗookaa-ɗookɗa. Haꞌmudii en Koohɗa hayyi kitum buuꞌ fodaa caasamci Dëwít. ");
INSERT INTO snf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ya ƴah buurii ɓu-kaan Yakoop bi taaꞌ ee nguuraagari leehoo taaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyaama loffa malaakaa an: - Iñaama mínan na kiꞌen? Mi ínohoo ƴaal. ");
INSERT INTO snf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaakaa taassari an: - Helii yiselaꞌíꞌyii hay kiyoosuk ga ɗookfu ee doolaa meyoh ga Kooh yii ga ɗookaa-ɗookɗa úullaa fodii sëegúu. Kërí tah oomaanii ƴah kilímuɗa ƴah kiɓayu yiselaꞌíꞌyii, Kowukii Kooh. ");
INSERT INTO snf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Malka, mbokfu Ilisabeet, ya ɓan, yaa na look, kowu kiƴaal, ga kiyaꞌɓuci. Ɓaa woꞌsee an mínoo kilaak kowuɗa, yaa ga ñiin ciyitniinoo wati. ");
INSERT INTO snf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ndaga dara wooñnjii Kooh. ");
INSERT INTO snf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyaama woꞌꞌa an: - Mi en ñaamii Haꞌmudii. Iñii fu woꞌ garooɗa, laakohat ɗa. Malaakaa tagohha nari, yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ga wahtaama, Mariyaama ɓewukka, yaa gaaw kiƴah ga ɓak gohaa Yúudée wiyéwníꞌ jaŋjaŋwaa, ga teeru wíinoo daama. ");
INSERT INTO snf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ya aassa kaan Sakarí, ya këñíꞌta Ilisabeet. ");
INSERT INTO snf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kowukaa ga lookaa Ilisabeetɗa yëngëlukka ga ɗuuƴci ga wahtaa Ilisabeet keloh këñɗohaa Mariyaama. Ilisabeet líiffa na Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ee ya yaa woꞌ didóolíꞌ an: - Kooh wëñnjaa kibarkeel ga ɓeticii ɓéeɓɓa ee ya barkeelin kowukii fu ƴah kilaakɗa! ");
INSERT INTO snf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mi yërí en ɓa, bi eew Haꞌmudiigoo, hay kaanndoo? ");
INSERT INTO snf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndaga malka, daa mi kelohee këñɗohiigaraa hen rek, kowukii dalla kiyëngëluk ga lookiigoo ndaga kisafaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fu yewinin múuꞌ, fu yii fu gëmin an iñaa yéegalohu ga teekaa Haꞌmudiiɗa, hay ɗa kilaakoh. ");
INSERT INTO snf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyaama dalla kiwoꞌ an: - Fítiigoo ɓéeɓwa wii kañ kiyakkii Haꞌmudii, ");
INSERT INTO snf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ee keeñnjoo soosin ga Kooh, Músalkaatiigoo. ");
INSERT INTO snf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ndaga ya malkinndoo, mi ñaamiigari ee mi enndii daraɗa. Aboh ga diima, ɓuwii wati na ɓaa hayanɗa, bi taaꞌ woꞌsan garoo ɓaa yewinin múuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ndaga Kooh yii laak dooliɗa tumɗinndoo enaama yiyaak. Teekiigari selaꞌin. ");
INSERT INTO snf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ee ya hay kiyërëm ɓuwaa niikussi fodii Koohɗa, bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ya tumin enaama ciyaak na dooli yahci: ya aañin ɓuwaa tíku hafɓa ga ɗookɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ya kaalin buuꞌcaa ga nguuraa ɓa enohɗa, ee ya ɓëwíꞌta ɓuwaa enussii daraɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ya erin ɓuwaa yaaɓɗa enaama cinéwíꞌ bi dooyin, ee ya ɓoƴkidohin haꞌ-alalcaa yah ɓuucuuc. ");
INSERT INTO snf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ya hayin kiꞌamɗoh ɓu-Isarayeel, súrgaciigari: ya allii múk kiteewoh yërmaandaagari ga Abaraham na ɓuwaa meyoh gariɗa bi taaꞌa fodaa daa ya dígeeka caasamuncaagaruuɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyaama tessa na Ilisabeet iñaa leꞌin ñiin kaahay, lëehíꞌta ya ɓoyukka kaanci. ");
INSERT INTO snf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wahtaa Ilisabeet jomee kilaakoh kowuɗa leꞌꞌa, ya laakka kowu kiƴaal. ");
INSERT INTO snf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɓuwaa dëk nariɗa na mbokcaagari yéegussa an Haꞌmudii, teewinndi yërmaandi wiyaak, ee ɓéeɓɓa ɓaa neɓluk ga iñaama nari. ");
INSERT INTO snf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Waa kuꞌoomaakaa límukka bi laakka bes ciyitnakaahay, ɓuwaa hayyaja kigúꞌ. Ɓa waareeja kiꞌeꞌ teekaa paamci, Sakarí. ");
INSERT INTO snf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wayee eemunaa loffa an: - Óꞌóo, ja teeksan Saŋ. ");
INSERT INTO snf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓa woꞌꞌari an: - Man laakoo mbokfu yaa ɓay teekuma! ");
INSERT INTO snf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓuwaa meekisohha paamunaa na yahcaagaɓa, ya woꞌɓa daa ya waaꞌ kiteek kowukaagariɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarí nakka ɓuwaa, ɓa haydohiꞌti haanga wibídaah, ya bínnda an: «Teeku Saŋ.» Ɓuwaa ɓéeɓɓa jaahliꞌussa ga iñaama. ");
INSERT INTO snf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ga ɗekataama, perimpaa Sakarí lógísukka, ya mínnda kiwoꞌ fodaa múus, ya yaa kañ Kooh. ");
INSERT INTO snf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɓuwaa dëk nari ga dëkaaɗa tíitussa ga iñaama, ee ɓuwaa ɓaa ɓéestíroh iñaa laakee yaama ga ɗuuƴ jaŋjaŋcaa ga gohaa Yúudée tóohɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓaa iñaama aasin nofci ɓéeɓ, ammbaka ga helci ee ya yaa woꞌ an: - Kuꞌoomaakii jii ƴah ɓee? En kiꞌenaa, doolaa Haꞌmudii, enee nari. ");
INSERT INTO snf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakarí, paam kuꞌoomaakaa líiffa na Helaa yiselaꞌíꞌyaa. Ya yaa jangat fodii sëldíiga-Kooh an: ");
INSERT INTO snf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","- Haꞌmudii, Koohyii ɓu-Isarayeel, kañsat, ndaga ya hayin kiɓaaɓ na kilaassuu, ɗu ɓuwiigari. ");
INSERT INTO snf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ya wosinnduu Músalkaat yiyaak, yaa bok ga níilaa buuꞌ Dëwít, súrgaagari. ");
INSERT INTO snf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ya yéegaloheera iñaama kimëeñíꞌ, koorohhawa ga túuwtaa sëldíigacaagari ɓiselaꞌíꞌɓaa ensee waamaɗa: ");
INSERT INTO snf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ya dígohee an ya hayyuu kimúsal ga ɓuwii sagoh naruuɗa na ga yah ɓuwii waarussii garuu kihotɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Fodaama ya teeɓ caasamuncaaruu yërmaandaagari, ee ya allii kifiiliimunkaagari kiselaꞌíꞌkaa na ɓuunciɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kooh dígee caasammbuu Abaraham, ");
INSERT INTO snf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","an ya hayyuu kimeƴdoh ga yah ɓuwii enu naruu kilebirohɗa, doonaa ɗu mínndi kijaamuk fodaama, na fít wiyëgísíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Doonaa ɗu selaꞌ ee ɗu júɓ ga fíkíici besaa Kooh onnduu kipes ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Fu nak, kowuroo, fu ƴah sëldíigii Koohyii ga ɗookaa-ɗookɗa, ndaga fu ƴah kiɗëwíruk Haꞌmudii, fu waayukiꞌti waasiigari ya ƴah kihayohɗa, ");
INSERT INTO snf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na kiꞌínohlukoh ɓuwiigari an waasaa ƴahɓa kimúsalɗa kooroh ga kibayalkaa ɓa bayalsan baakaaꞌcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Koohyiiruu yewinin yërmaandi, kërí tah bi ya hay kiyóoskíꞌ ga ɗookkuu leeꞌlaataa meyoh ɗook man na leeꞌlaataa nohaa en na kimeƴ. ");
INSERT INTO snf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","En ɗanaa ya léeríꞌ ɓuwaa tesu ga ñúusii ee ɓa dëk ga kinúp kikaanɗa, ya níiꞌ kotcaagaɓa, ëewdohca ga waas jam. ");
INSERT INTO snf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oomaanaa yaa yak ga faan na hel. Ya tessa ga ɗekat, ga ëgíraa, bi ga daa ya meƴ, ya teewukohha ga fíkíi ɓu-Isarayeel. ");
INSERT INTO snf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ga waama, buuraa yiyaakyaa woꞌu Ógís nakohha an ɓuwaa en ga kúlkaagari tóohɗa, ɓa bídukat bi ya ínoh ga daa ɓa hínɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bídukaama wërí ɗeɓ kilaak ee wa enee ga waa Kíríñús nguurukee ga gohaa Síríiɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓaa en ɓéeɓ yaa ƴah kibíduknee ga teeraa ya meyohɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoseef ɓan ɓeɓkohha ga teeraa Nasareet ga gohaa Gëlílée, ya yaa ƴah Betleeꞌem, teeraa buuꞌ Dëwít límohuɗa, ga gohaa Yúudée. Iñaa tahkaɗa, ya Yoseef, ya bok ga níilaa buuꞌ Dëwít. ");
INSERT INTO snf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ya kaꞌta daama kibíduknee, ya taammba na jowujaagari, Mariyaama, lak na look. ");
INSERT INTO snf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wahtaa Mariyaama jomee kilaak kowuɗa leꞌꞌa lak ɓa ɓaa ga Betleeꞌem. ");
INSERT INTO snf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ya laakka kowu kiƴaal, ennda saawaagari. Ya múulla kuliiꞌkaa, faanndaja ga ɗuuƴ mbalka ndaga lak ga daa ɓuwaa yuŋɗusee ga kaancaaɗa líifin, ee ɓa laakéeríi daa ɓa enan. ");
INSERT INTO snf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ga ëgíraama, laakeera níirohcaa neehsee ga yopcaa. ");
INSERT INTO snf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Laakka malaakaa Kooh meƴ gaɓa. Ndamaa Kooh yoosukka ga ɗookɓa, ennda fodii melic, wíillaɓa. Ɓa tíitta tír. ");
INSERT INTO snf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wayee malaakaa woꞌꞌaɓa an: - Kaa niikat, ndaga mi haydohiꞌtúu Hewhew wijófíꞌ waa ƴah kiꞌen neɓlaat ga ɓuwii ɓéeɓɓa: ");
INSERT INTO snf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","wati, ga teeraa buuꞌ Dëwít límohuɗa, laakin Músalkaataa límukiꞌtúu, yërí en Kiristaanii, Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ee ɗú ínohsohanndi ga mandargii wii: ɗú hay kilaak daama kuliiꞌkaa múuluunun, faanu ga ɗuuƴ mbalka. ");
INSERT INTO snf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ga ɗekataama, laakka malaaka ɓiyewin ɓaa meyoh ɗook hayussa ga yaama, ɓa taammba ɓéeɓɓa, ɓaa kañ Kooh anee: ");
INSERT INTO snf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ndam aawat ga Kooh ga ɗookaa-ɗook, ee ga kakay jamaagari enat na ɓuwaa ya tanɗa!» ");
INSERT INTO snf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Waa ennda ɗa, malaakacaa tagohussa na níirohcaa, ɓaa ɓoyuk ɗook-Kooh. Níirohcaa ɓaa woꞌ ga díkaantiɓa an: - Ɗu ƴahat kon bi ga Betleeꞌem, ɗu hot iñaa laak daama ee Haꞌmudii, hayeeruuka kiyéegalɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓa gaawwa da kikaꞌ, laakussa Mariyaama na Yoseef daama ee kuliiꞌkaa faanuunun ga mbalkaa. ");
INSERT INTO snf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waa ɓa hottaja, ɓa hannda kiɓéestíꞌ iñaa malaakaa woꞌeeɓa aaw ga kuꞌoomaakaaɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɓéeɓ ɓuwaa kelohsee iñaa níirohcaa ɓéestíꞌseeɗa, jaahliꞌussa ga. ");
INSERT INTO snf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariyaama nak ammba iñcaama tóoh ga helaagari ee ya yaa halaat ga. ");
INSERT INTO snf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lëehíꞌta níirohcaa ɓoƴkussa yopcaa, ɓaa ndam Kooh, ɓaa kañnji ndaga iñaa ɓa kelohɗa, na iñaa ɓa hotɗa. Iñcaama tóoh laakee fodaa daa malaakaa woꞌeeɓakaɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Waa kuꞌoomaakaa límussa bi laakka bes ciyitnakaahay, ja gúrussa, ɓa eꞌtari teekaa Yéesu. Teekaa waama wërí malaakaa erohee lak Mariyaama enndii na look duum. ");
INSERT INTO snf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Besaa kisétíꞌsirukkaa Mariyaama leꞌꞌa fodaa daa Waasaa Móyíis nakohkaɗa, Yoseef nari ɓayussa kuꞌoomaakaa teeraa Yéerúsaleem ga Kaanfaa Kooh, kiteewohhi ga Haꞌmudii; ");
INSERT INTO snf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ndaga bídu ga Waasaa Haꞌmudii, an: «Kowu kisaaw kiƴaal kaa límu ɓéeɓ faanɗusat Kooh.» ");
INSERT INTO snf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓa tummba sarah ɓan fodaa iñaa Waasaama nakohɗa: «Hoꞌ-mbarfat ɓanak wala hoꞌ-húul ɓanak ɓiƴín.» ");
INSERT INTO snf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Laakeera waama ga Yéerúsaleem, ɓaa teeku Simewoŋ. Ɓaa yaama júweera ee kelohɗeera Kooh ee ya sekee ɓaa ƴah kihay kinaas coonucaa ɓu-Isarayeelɗa. Helaa yiselaꞌíꞌyaa taabee nari ");
INSERT INTO snf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ee ya ínohlukoheerari ga heeƴ an ya kaanoo ee ya hottii Kiristaanaa Haꞌmudii, wosohɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Helaa yiselaꞌíꞌyaa ɓayyari bi ga Kaanfaa Kooh, hídohha lak paam Yéesu na eeci haydohuununndi daama kitum iñaa Waasaa nakoh gariɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simewoŋ ɓeɓpari ga yahcaagari, ya yaa kañ Kooh an: ");
INSERT INTO snf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","- Cic Kooh, diima iñaa fu dígoheeɗa laakin. Fu mínin kiꞌíis súrgiigaraa ya kaan na jam. ");
INSERT INTO snf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ndaga mi hotin na tuhastiigoo kimúckii meyoh garaaɗa, ");
INSERT INTO snf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ee kimúckiima, fu waayukka ga fíkíi ɓuwii ɓéeɓɓa: ");
INSERT INTO snf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kërí en leeꞌlaataa tahanndaa kiꞌínohuk ga ɓuwii ga ëldúnaɗa tóoh, ee kërí onan ndam ɓu-kaanfu, Isarayeel. ");
INSERT INTO snf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Paam Yéesu na eew Yéesu jaahliꞌussa ga iñaa Simewoŋ woꞌee ga oomaanaaɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simewoŋ barkeellaɓa, woꞌꞌa Mariyaama eew Yéesu an: - Malka, ɓii yii hay kitah ɓiɓoꞌ ɓiyewin ga Isarayeel sooyu ga fíkíi Kooh ee ɓoꞌ ɓiyewin hay kimúcu. Ya hay kiꞌen mandargaa Kooh teewoh ee ya hay kisagu ga ɗuuƴ ɓuwii. ");
INSERT INTO snf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ee fodaama, ya hay kiméyíꞌ halaatcaa ɗaakuk ga keeñcaa ɓiɓoꞌ ɓiyewin. Fu nak, Mariyaama, fu hay kilaak mesiklaat ciyaak ga keeñfu bi man na jípíl maaŋngaa. ");
INSERT INTO snf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Laakeera ɓan sëldíiga-Kooh yiɓeti, yaa teeku Aana. Paamci teeksee Fanuwel ee bok ga níilaa ɓu-kaan Aseeꞌ. Ya yaꞌɓuꞌeera lool. Ya enin tíkíis tiyitnatanak na ƴaalaa ya pajukee gari ga kiꞌoomaa-jowuciɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Lëehíꞌta, waa ƴaalaa kaannda, ya pajukissii. Ya tessa ɗa bi ga tíkíistaa tidaaŋkaah-yitnataahay na tinikiistaa ya laakɗa. Aana tagohéeríi Kaanfaa Kooh. Wekoo nohoo, ya enee ga kijaamuk Kooh: ya oori, ya kíimi Kooh. ");
INSERT INTO snf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Daa ya hídukohee ga iñaama, ya yaa gërëm Kooh ga kuꞌoomaakaa. Ee ya yaa ɓéestírukoh kuꞌoomaakaa ga ɓéeɓ ɓuwaa seku daa Kooh laasohan ɓu-Yéerúsaleemɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Paam Yéesu na eew Yéesu mëtírussa kitum iñcaa Waasaa Haꞌmudii, nakohɗa, lëehíꞌta ɓa sooffa Nasareet, teeraa ɓa dëkohɗa ga gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kuꞌoomaakaa nak, jaa yak, jaa wëñ kilaak hel, ja jaa yewin hamham ee jaa neɓloh Kooh. ");
INSERT INTO snf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kíiskaa en ɓéeɓ, paam Yéesu na eew Yéesu daansee kikaru Yéerúsaleem ga feetaa Paak. ");
INSERT INTO snf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ga waa Yéesu laakka tíkíis tidaaŋkaah na tanak, ɓa kaꞌta nari feetaa fodaa daa baahaa nakohkaɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ga waa feetaa leehha, ɓa ɓaa ɓoyuk, wayee Yéesu, kuꞌoomaa-ƴaalkaa, tessa ga Yéerúsaleem ee paamci na eeci ínohussii dara ga. ");
INSERT INTO snf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓa tíinnda iñaa hín na noh-noh wíinoo ee ɓa fooŋnga rek an Yéesu yii ga ɗuuƴ ɓuwii ɓa taam naɓaɗa. Lëehíꞌta ɓa ɓaa en ga kiraassi ga ɗuuƴ ɓuwaa bokoh naɓaɗa na ɓuwaa ɓa ínohɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wayee ɓa hottiiri. Ɓa ɓoyukka kon kiraassi bi ga Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ga besaa wukaahaywaa, ɓa hottari ga ɗuuƴ Kaanfaa Kooh: ya yugin ga leeloo jëgíroh yaawúuꞌcaa, ya yaa súkúrukɓa ee ya yaa meekisɓa. ");
INSERT INTO snf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓéeɓ ɓuwaa súkúrukseeriɗa lëƴseera ga kiñaañkaagari na iñcaa ya taaseeɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Paamci na eeci hotussi hen, ɓa waaruꞌꞌa; eeci meekissari an: - Kowuroo, iñii tah ya fu tummbíi iñii yii? Mi na paapu ɗí jaahliꞌeera lool ga dii ɗí eneeraa na kiraasɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ya loffaɓa an: - Ɗú raaseeroo doo ya? Ɗú ínohéeríi an mi jom kiꞌen ga kaanfii Paammboo hene? ");
INSERT INTO snf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wayee ɓa ínohhii iñaa ya waareeɓa kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lëehíꞌta Yéesu sooffa naɓa Nasareet ee ya yaa kelohiꞌɓa. Eeci ammba iñcaama tóoh ga helaagari ee ya yaa halaat ga. ");
INSERT INTO snf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yéesu nak yaa en yaak, hamhamaagari waa ɓaatuk, ee ya yaa wëñ kineɓloh Kooh na ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iñii yii laakee ga kíiskaa kudaaŋkaah na kuyëtúuskaa ga nguuraa buuraa yiyaakyaa teeku Tíbeeꞌɗa. Lak Poos-Pílaat yaa nguuruk ga kúlkaa Yúudée, ee Eroot nguurukee ga gohaa Gëlílée, ee këmëeŋkíci Filiip nguurukee ga gohaa Ítúrée na waa Tarakonit, Lisañas nguurukee ga Abíleen. ");
INSERT INTO snf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ee ɓan lak Aan na Kayíf ɓërí kuliyukee ga sarahohcaa ɓiyaakɓaa. Waama Kooh woꞌꞌa na Saŋ, kowukaa Sakarí, ga ɗuuƴ ëgíraa. ");
INSERT INTO snf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Waa ennda ɗa, Saŋ kaꞌta ga dëkcaa wíil húlúwaa Yúrdeŋɗa tóohca. Ya yaa jangat an ɓuwaa súpítat kipeskaagaɓa, ɓa bëtísiꞌu, en ɗanaa baakaaꞌcaagaɓa bayalu. ");
INSERT INTO snf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fodaama, iñaa bínsee ga këyítfaa Ísayíi, sëldíiga-Koohɗa laakka, ndaga ya woꞌee an: «Laakin koonaa-ɓoꞌ kaa en na kiwoꞌ didóolíꞌ ga ɗuuƴ ëgíꞌ-dúndagaa an: Waayukɗat Haꞌmudii waasii, júwíꞌɗatti tuwaas-waastii! ");
INSERT INTO snf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Cúl-cúl hay kiꞌúubu, jaŋjaŋ na tëgël hay kihídírohu; waascii ɗeegiskohɗa hay kiyólóhɗu, waascii na ƴëltí-ƴëltíciiɗa hay kileeñu. ");
INSERT INTO snf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","En ɗanaa, ɓaa en ɓéeɓ hay kihot kimúckaa meyoh ga Koohɗa.» ");
INSERT INTO snf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɓuwaa ɓaa hay ga Saŋ doo ya bëtísiꞌɓa. Ya yaa woꞌɓa an: - Heet goŋ-saamaancii, ɓii lëdíꞌtúu ɓa iñaa tahanndúu kirëc ga aylukaa Kooh ƴah kihayɗa? ");
INSERT INTO snf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kon tumat iñcaa teewohin an ɗú récukin baakaaꞌciigarúu, ee kaa dalat kiwoꞌ an: «*Abaraham en caasammbíi.» Ndaga mi woꞌꞌúu man Kooh mínin kiɓeɓ atohcii cii ya meƴdoh ga tucaasamun Abaraham! ");
INSERT INTO snf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Diima deŋ ɓan këkúsaa tíimin boscaa tediktaa, kigúꞌ níilcaa. Kon kedikkaa límmbii towu tijófíꞌ tóoh, gúru, jafu ga kiwii. ");
INSERT INTO snf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mbooloomaa meekissari an: - Kon ɗí jom ya kitum? ");
INSERT INTO snf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ya loffaɓa an: - Ɓaa fu laak kúltí kanakaa, laa warohaa na ɓaa laakoo, ee ɓaa fu laak iñaa fu ñamanaa, tumaa fodaama. ");
INSERT INTO snf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Juuticaa hayussa ɓan kibëtísiꞌu, ɓa meekissa Saŋ an: - Jëgírohii, ɗí jom ya kitum? ");
INSERT INTO snf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ya loffaɓa an: - Kaa meekisohat ɓuwii iñaa wëñ iñaa nguuraa nakohɗa. ");
INSERT INTO snf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Laakka ɓan soldaaꞌcaa meekissi an: - Ɗí ɓan, ɗí jom ya kitum? Ya woꞌꞌaɓa an: - Kaa teꞌat hëelís ken na dooli wala ga pokiꞌ ɓoꞌ iñcaa laakkii, wayee eemat ga fayaagarúu. ");
INSERT INTO snf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓuwaa ɓaa sek ga Saŋ, ndaga ɓaa en ɓéeɓ foogee an heƴna Saŋ yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wayee Saŋ woꞌꞌa ɓuwaa ɓéeɓɓa an: - Mi, mi bëtísiꞌꞌúu ga músú, wayee ɓaa wëñnjoo kiyak fúuf yaa hay: mi jutuutin sah ga kipëkís liiɓcaa ñafaꞌcaagari. Ya bëtísiꞌanndúu ga Helaa yiselaꞌíꞌyaa na ga kiwii. ");
INSERT INTO snf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kankaa kaa ga yahci, kifaaꞌ yoonaagari, ya ek tohootaa ga dapaagari; wayee fekiꞌfaa, ya hayfa kitëkíꞌ ga kiwiikaa ƴímoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Fodaama, na jëgíroh ciyewin ciliis caa manɗa, Saŋ yaa yéegal ɓuwaa Hewhewaa winéwíꞌwaa. ");
INSERT INTO snf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wayee Eroot buuraa Gëlílée, ga waa ya teꞌ Erojaas ɓeti këmëeŋkíci, ya pokkariɗa, Saŋ ñaꞌtari ga na enaama cibóníꞌ ciyewin ciliis caa buuraa tumee. ");
INSERT INTO snf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wayee Eroot ɓaatissa kitum iñaa wëñ kisepiꞌ: ya amlukka Saŋ ga kasu. ");
INSERT INTO snf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ga waa ɓuwaa ɓéeɓɓa ñoodussa ga músúmaa, Yéesu ñoodussa ga ɓan. Waa ya ñoodussa bi ya meƴca, ya yaa kíim Kooh. Ga wahtaama, ɗook-Kooh lëgísukka. ");
INSERT INTO snf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Helaa yiselaꞌíꞌyaa yoosukka ga ɗookci fodii iñaa man na hoꞌ. Laakka koonaakaa kelohuk, meyoh ɗook-Kooh an: «Fu yërí en kowuroo ee mi waarinndaa. Keeñnjoo soosin garaa.» ");
INSERT INTO snf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ga waa Yéesu dal kimeƴ ga fíkíi ɓuwaa, ya laakeera tíkíistaa leꞌ tidaaŋkaah-kaahay. Ɓuwaa abee an yërí en kowu Yoseef yaa enee kowu Helíɗa. ");
INSERT INTO snf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helí ennda kowu Mataat, Mataat kowu Léwí, Léwí kowu Melki, Melki kowu Yanay, Yanay kowu Yoseef, ");
INSERT INTO snf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoseef kowu Matacas, Matacas kowu Amoos, Amoos kowu Nahum, Nahum kowu Esli, Esli kowu Nagay, ");
INSERT INTO snf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay kowu Maat, Maat kowu Matacas, Matacas kowu Simiꞌ, Simiꞌ kowu Yooseek, Yooseek kowu Yoodaa, ");
INSERT INTO snf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoodaa kowu Yohanan, Yohanan kowu Resa, Resa kowu Sorobabeel, Sorobabeel kowu Salceel, Salceel kowu Nérí, ");
INSERT INTO snf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérí kowu Melki, Melki kowu Adi, Adi kowu Kosam, Kosam kowu Elmadam, Elmadam kowu Eeꞌ, ");
INSERT INTO snf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eeꞌ kowu Yéesu, Yéesu kowu Eliyeseeꞌ, Eliyeseeꞌ kowu Yoorim, Yoorim kowu Mataat, Mataat kowu Léwí, ");
INSERT INTO snf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Léwí kowu Simewoŋ, Simewoŋ kowu Yúdaa, Yúdaa kowu Yoseef, Yoseef kowu Yonam, Yonam kowu Elíyakím, ");
INSERT INTO snf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elíyakím kowu Meleyaa, Meleyaa kowu Menna, Menna kowu Matata, Matata kowu Natan, Natan kowu Dëwít, ");
INSERT INTO snf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dëwít kowu Yesee, Yesee kowu Yobet, Yobet kowu Boas, Boas kowu Sala, Sala kowu Naason, ");
INSERT INTO snf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason kowu Amínadap, Amínadap kowu Atmin, Atmin kowu Arni, Arni kowu Esarom, Esarom kowu Peres, Peres kowu Yúdaa, ");
INSERT INTO snf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yúdaa kowu Yakoop, Yakoop kowu Ísaak, Ísaak kowu Abaraham, Abaraham kowu Tera, Tera kowu Nakooꞌ, ");
INSERT INTO snf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakooꞌ kowu Sérúk, Sérúk kowu Rewu, Rewu kowu Pelek, Pelek kowu Ebeeꞌ, Ebeeꞌ kowu Sala, ");
INSERT INTO snf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala kowu Kaynam, Kaynam kowu Arapaksat, Arapaksat kowu Seem, Seem kowu Nowee, Nowee kowu Lamek, ");
INSERT INTO snf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek kowu Metusela, Metusela kowu Henok, Henok kowu Yaret, Yaret kowu Mahalaleel, Mahalaleel kowu Kaynam, ");
INSERT INTO snf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam kowu Enos, Enos kowu Set, Set kowu Aadama, Aadama kowu Kooh. ");
INSERT INTO snf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ga waa Yéesu líiffa na Helaa yiselaꞌíꞌyaa, ya meyohha húlúwaa Yúrdeŋ. Helaa yiselaꞌíꞌyaa wooccari, ɓayyari ga ɗekat, ëgíꞌ-dúndaŋ. ");
INSERT INTO snf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Daama ya ennda da bes cidaaŋkaah-nikiis, caa wëeꞌtaa ga an cii, Seytaani yaa fíꞌti. Ya ñammbii dara ga ɗuuƴ bescaama. Ga waa bescaama paaffa, kiyaaɓ ammbari. ");
INSERT INTO snf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Waa ennda ɗa, Seytaani woꞌꞌari an: - En lak fu en Kowukii Koohaa, nakaa atohii wii wa súpítuk mbúurú, fu ñam. ");
INSERT INTO snf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yéesu loffari an: - Këyítfaa woꞌ an: «Ɓoꞌ pesohanndii na mbúurú doŋ.» ");
INSERT INTO snf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seytaani ɓayyari ga ɗekat wikëríꞌ ɗook, ya teeɓpari ga saasi dëkcii ga ëldúnaɗa tóoh. ");
INSERT INTO snf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lëehíꞌta ya woꞌꞌari an: - Mi hayyaa kiꞌon kinguuruk ga ɗook dëkciima tóoh na kilaak ndamaa nguuraagaca: mi eruunun iñaama tóoh ee mi míninwa kiꞌeꞌ ɓaa neɓpoo. ");
INSERT INTO snf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kon fu, binaa fu ƴíꞌ ga fíkíiroonaa, iñaama tóoh fu hayyi kilaak. ");
INSERT INTO snf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yéesu loffari an: - Këyítfaa woꞌ an: «Fu ƴíꞌɗan Haꞌmudii, Koohyiigaraa, ee fu jaamukanndi ya doŋ.» ");
INSERT INTO snf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lëehíꞌta Seytaani ɓayyari Yéerúsaleem, yíppari ga ɗook Kaanfaa Kooh, ya woꞌꞌari an: - En lak fu en Kowukii Koohaa yípukaa kakay; ");
INSERT INTO snf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ndaga Këyítfaa woꞌ an: «Kooh hayyaa kinakiꞌ malaakacaagari, ɓa sommbaa.» ");
INSERT INTO snf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ee ɓan: «Malaakacaa teeŋngaa ga yahcaagaɓa, doonaa kotfu këftukoo ga atoh.» ");
INSERT INTO snf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yéesu loffari an: - Këyítfaa woꞌ an: «Kaa jéematuk Haꞌmudii, Koohyiigaraa.» ");
INSERT INTO snf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ga waa Seytaani lëehíꞌta kifíꞌ Yéesu ga ɓakaa en ɓéeɓ, ya úsaayya Yéesu, ya yaa sek bes wiliis. ");
INSERT INTO snf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yéesu líiffa na Helaa yiselaꞌíꞌyaa, ɓoyukka Gëlílée. Teekaagari síwwa ga gohaama tóohwa. ");
INSERT INTO snf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ya yaa jëgíroh ga ɗuuƴ jaangu-yaawúuꞌcaa daamaɗa ee ɓuwaa ɓéeɓ ɓaa kañnji. ");
INSERT INTO snf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yéesu kaꞌta Nasareet, teeraa ya yakohɗa. Ga besaa Sabat, ya aassa jaangu-yaawúuraa fodaa daa ya meereeka kitumɗa. Ya kolukka kijaŋ Këyítfaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ya erussa Këyítfaa sëldíiga Ísayíi. Ya lëríssafa, ya leꞌꞌa bi ga ɗekataa bídu an: ");
INSERT INTO snf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Helii meyoh ga Haꞌmudiiɗa, wii ga ɗookkoo ndaga ya tanukinndoo kihaydoh Hewhewii winéwíꞌwii ga ɓuwii laakooɗa. Ya wosinndoo kiyéegal ɓuwii abuɗa an ɓa hay kirëc na kiwoꞌ ɓuwii hascii búumɗa an ɓa hay kihotis, ɓuwii en na kitogisohuɗa an ɓa hay kilaak hafɓa; ");
INSERT INTO snf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ya nakinndoo kiyéegaloh kíiskii Haꞌmudii ƴah kiteewoh an ɓuwaa neɓlohinndi.» ");
INSERT INTO snf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lëehíꞌta Yéesu ponnda Këyítfaa, ya íkkafa ɓaa ɗaakifaɗa, ya yuŋnga. Ɓuwaa enee ga jaangaaɗa ɓéeɓɓa yípussari hascaa. ");
INSERT INTO snf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Daama, ya yaa woꞌɓa an: - Wati, woꞌeenii ga Këyítfii ɗú han kikelohɗa laakohin ga dii wa woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓaa en ɓéeɓ yaa woꞌ iñaa morin ga Yéesu, ee ɓa jaahliꞌꞌa ga woꞌeencaa cinéwíꞌcaa ya meƴdoh ga kúuwkaagariɗa. Ɓa ɓaa woꞌ an: - Ɓii enndii kowu Yoseefe? ");
INSERT INTO snf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yéesu woꞌꞌaɓa an: - Wóorinndoo an ɗú hayyoo kicah an: «Payohii, wëkíraa haffu!» Ɗú hayyoo kiwoꞌ ɓan an: «Ɗí yéegin iñcaa fu tum ga Kafarnawomɗa tóohca; tumaa caa manɗa dii ga dëkii fu meyohɗa.» ");
INSERT INTO snf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Lëehíꞌta, ya ɓaatta ga an: - Mi woꞌꞌúuka ee kayoh; laakkii sëldíiga-Kooh yaa teꞌu ga dëkaa ya meyohɗa. ");
INSERT INTO snf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ee mi yii woꞌissúu ɓan kayoh-kayohɗa: níindískat iñaa laakee waama ga jamaanaa sëldíiga Ili, lak Kooh enin karaŋ iñaa leꞌin tíkíis taahay na caban ee aꞌ wiyaak laakka ga kúlkaa tóoh, mi woꞌꞌúuka laakka waama ga kúlkaa Isarayeel ɓeti ɓiyewin ɓaa ƴaalcaagaɓa kaanin; ");
INSERT INTO snf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wayee Kooh ebillii Ili ga yíinoo gaɓa, ya dímalɓa. Ya nammbari kiꞌebil ga yíinoo yaa enndii yaawúuꞌ ee dëk teeraa Sareptaa ga gohaa Sídoŋɗa. ");
INSERT INTO snf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ga Isarayeel ɓan, ga jamaanaa sëldíiga Ilisee, laakeera gaana ɓiyewin, wayee yíinoo gaɓa wëkɗuséeríi, enndii Naamaan yaama dëk Síríiɗanaa. Ya enndii yaawúuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ɓuwaa enee ga ɗuuƴ jaangaaɗa ɓéeɓɓa, daa ɓa kelohee woꞌeencaama, keeñcaagaɓa tammba lool. ");
INSERT INTO snf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓa kolukka, ɓa meƴdohhari teeraa, ɓa jíitallari bi ga ɗook jaŋjagaa, ga daa teeraa Nasareet yípohseeɗa, doo ɓa yeꞌꞌi ga írkísaa, ya keen kakay. ");
INSERT INTO snf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wayee Yéesu kooꞌta ga leelooɓa, ya yaa paaf. ");
INSERT INTO snf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yéesu kaꞌta teeraa Kafarnawom ga gohaa Gëlílée. Ga bes Sabat ya yaa jëgíꞌ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓuwaa waaruꞌseera lool ga jëgírohaagari ndaga ya yërëméeríi woꞌeenci. ");
INSERT INTO snf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ga ɗuuƴ jaangu-yaawúuraa, laakeera ɓaa raɓ yisóotíꞌ am enee daama, ya yaa les koonaa kiyaak an: ");
INSERT INTO snf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","- Éeƴ! Yéesu-Nasareet, fu naríi ya? Kiɗúmíꞌtíi kërí haydohhane? Mi ínohin ɓii fu enɗa: fu yërí en ɓii yiselaꞌíꞌyii meyoh ga Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yéesu gëtta rawaa, woꞌꞌari an: - Ɗekoha, fu meyoh ga ɓii. Daama, rawaa ɓúukka ɓaa kakay, ga leeloo ɓuwaa ɓéeɓɓa, ya meƴca gari ee tummbiiri dara iñaa meskin. ");
INSERT INTO snf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɓuwaa ɓéeɓɓa jaahliꞌussa, ɓa ɓaa woꞌ ga díkaantiɓa an: «Cii woꞌeen ca yee? Ɓii laakin dooli kinak raɓcii ɓa meyoh ga ɓuwaa ee na woꞌeen wíinoo rek ɓa meƴ.» ");
INSERT INTO snf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Fodaama teekaa Yéesu waa síw ga gohaama tóohwa. ");
INSERT INTO snf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yéesu kolkohha jaangu-yaawúuraa, ya kaꞌta kaan Simoŋ. Lak payam Simoŋ yiɓeti ɗúukoolin bi faanfaa tamin jír. Ɓa kíimmba Yéesu ya dímalɓa ga. ");
INSERT INTO snf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ya híilla ga ɗookci, ya gëtta tamohlaataa faanfaa; tamohlaataa meƴca, ga saasi ya kolukka, ya aawwaɓa kitoputuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ga waa nohaa aassa, ɓaa laakin ɗúukoolíꞌ ɓéeɓ ee ga daa ya mín kiman tóoh, haydohhari ga Yéesu. Ya tíkka yahcaagari ga ɗook yaa en ɓéeɓ gaɓa, ee ya wëkíꞌtaɓa. ");
INSERT INTO snf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Raɓcaa ɓan ɓaa meyoh ga ɗúukoolíꞌ ɓiyewin na tifiip an: - Fu yërí en Kowukii Kooh. Wayee yaa gëtɓa, ya hoonohhaɓa kiwoꞌ iñaa aaw gari, ndaga lak ɓa ínoheera an yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kooh yaa wíis, Yéesu yaa meƴ teeraa Kafarnawom yaa ƴah ga daa wéetin. Mbooloomaa waa raassi. Waa ɓa leꞌꞌa bi gari, ɓa waaꞌtari kitëhdoh doo ya tagohoo naɓa. ");
INSERT INTO snf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wayee Yéesu woꞌꞌaɓa an: - Mi jomin kiyéegaloh ɓan ga teerucii cíinoo Hewhewii winéwíꞌwii Nguurii Kooh, ndaga iñaama yërí tah Kooh wossaroo ga ëldúna. ");
INSERT INTO snf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Fodaama, Yéesu ennda ga kiyéegaloh Hewhewaa winéwíꞌwaa ga ɗuuƴ jaangu-yaawúuꞌcaa en ga kúlkaa Yúudéeɗa. ");
INSERT INTO snf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laakka bes lak Yéesu yaa ga seereenaa giiyaa Senesareet, mbooloomaa wíillari bi wa waa ñaak ga ɗookci ndaga kisúkúruk woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ya hotta ga seereenaa giiyaa gaal-looci kanak; laakka mbaalohcaa yoosukoh gaca, ɓa ɓaa tís mbaalcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ya aassa ga gaal-loocaa wíinoowaa en wuu Simoŋɗa; Yéesu woꞌꞌari kiɓay gaal-loocaa wa úsaay seereenaa giiyaa jutuut. Yéesu yuŋnga ga loocaa ya yaa jëgíꞌ mbooloomaa. ");
INSERT INTO snf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ga waa ya lëehíꞌta kijëgíroh, ya woꞌꞌa Simoŋ an: - Ɓayaa loocii bi ga ɗekataa músúmaa huutin, ɗú wees mbaalii, ɗú aaw kimbaal. ");
INSERT INTO snf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoŋ taassari an: - Kiyaakii, ɗí lëgëyin wekii ɓéeɓwa ee ɗí ammbii dara, wayee ga woꞌeenfu mi haywa kiwees. ");
INSERT INTO snf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɓa weessa mbaalaa, ɓa ammba jën ciyewin bi mbaalaa waa ɗaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Waa ennda ɗa, ɓa ɓaa kalay ɓuwaa taam naɓa ee ɓa enee ga loocaa wíinoowaaɗa, ɓa hayɓa kidímal. Ɓaama hayussa, ɓa líifíꞌta loocicaa kanakcaa na jën bi ca caa waaꞌ kinuuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Daa Simoŋ-Peeꞌ hotee iñaama, ya ƴíꞌꞌa ga fíkíi Yéesu, ya woꞌꞌa an: - Haꞌmudii, meyaa garoo ndaga mi iñii haꞌ-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoŋ woꞌee fodaama ndaga ya na ɓuwaa taabee nariɗa jaahliꞌseera lool ga jëncaa ciyewincaa ɓa amɗa. ");
INSERT INTO snf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bi ga Saak na Saŋ, towutaa Sebedee boku na Simoŋ lëgëyaaɗa jaahliꞌseera ga ɓan. Wayee Yéesu woꞌꞌa Simoŋ an: - Kaa niik dara. Kimma, ɓiɓoꞌ ɓërí fu mbaalan. ");
INSERT INTO snf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Waa ennda ɗa, ɓa soofdohha gaal-loocicaagaɓa tewisaa, ɓa foñnja tóoh, ɓa ɓaa taabuk Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Laakka bes lak Yéesu yaa ga teeru wíinoo ga gohaa Gëlílée, ɓaa gaanaꞌin bi faanfaa gomin hayya. Daa ya hotee Yéesu, ya líꞌukka ga fíkíici, ya kíimmbari an: - Kiyaakii, fu waaꞌkanaa fu míninndoo kiwëkíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yéesu lëríssa yahaagari, leꞌꞌa ga ɓaa, woꞌꞌari an: - Mi waarinka, waka. Ga saasi ɗúukool-gaanaa nísukka ga ɓaa. ");
INSERT INTO snf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lëehíꞌta Yéesu hoonohhari kiwoꞌ ɓoꞌ iñaa aaw gari. Ee ya woꞌꞌari an: - Kara, fu teewukohnee ga sarahohaa, fu tum sarah ga kisetkiigaraa fodaa daa Móyíis nakohkaɗa, en ɗanaa, iñaama hay kiteeɓ ɓéeɓ an fu setin. ");
INSERT INTO snf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wayee iñaama kokohhii bi teekaa Yéesu waa wëñ kisíw. Ɓiɓoꞌ ɓiyewin ɓaa nëgírukoh ga yahaaci, kisúkúruk woꞌeencaagari ee ya wëkíꞌɓa ga ɗúukoolcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ee Yéesu kaꞌta daa wéetinaa, ya kíimi Kooh da. ");
INSERT INTO snf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Laakka bes, Yéesu enee na kijëgíroh. ƁiFërísiyeeŋ na ɓijëgíroh-waas ee meyohu dëk-kawcaa ga gohaa Gëlílée, na ga gohaa Yúudée na teeraa Yéerúsaleem ensee daama, yuguunun ga yahaaci. Doolaa Kooh, Haꞌmudii, taabee na Yéesuɗa, waa onndi kiwëkíꞌ ɗúukoolíꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɓiɓoꞌ leꞌꞌa, haydohu ga ɗook gatan ɓaa lafañin, ee ɓa ɓaa heelli kiꞌek ga ɗuuƴ kaanfaa bi Yéesu hotti. ");
INSERT INTO snf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wayee ɓa hottii ga daa ɓa paafdohanndi ndaga mbooloomaa wiyewinwaa. Ɓa lappa nari ga ɗook túuyaa, ɓa heella gúl ga cakaraa, ɓa yóoskíꞌtari na gatanaagari ga leeloo ɓuwaa ga fíkíi Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Daa Yéesu hotee ngëmaagaɓa waama, ya woꞌꞌa lafañaa an: - Ƴaal, baakaaꞌcumgaraa bayaluununndaa. ");
INSERT INTO snf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jëgíroh-waascaa na Fërísiyeeŋcaa ɓaa halaat ga ɗuuƴɓa, ɓaa woꞌ an: «Ɓii yii ya ɓa, ya ɓasi Kooh? Ɓii mín kibaal baakaaꞌ ɓa, enndii Koohaa?» ");
INSERT INTO snf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wayee Yéesu ínohha halaatcaagaɓa, woꞌꞌaɓa an: - Iñii tah ya ɗú laak halaatcuma ga helciigarúu? ");
INSERT INTO snf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kon iñii yiida wëñ kiyooɓ kiwoꞌ lafañii: kiwoꞌꞌi «Baakaaꞌcumgaraa bayaluununndaanoo», kiwoꞌ an: «Koluka, fu tíin»? ");
INSERT INTO snf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wayee bi ɗú ínoh an ga ëldúna, Kowukii ɓii onuunun kibayal baakaaraa -- ya woꞌꞌa lafañaa an: -- Mi woꞌꞌaaka, kolka, ɓewaa gataniigaraa fu ƴee kaanfu! ");
INSERT INTO snf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ga saasi lafañaa kolukka ga fíkíi ɓuwaa ɓéeɓɓa, ɓeɓpa gatanaa ya faankoheeɗa, yaa ndam Kooh, ya yaa ƴah kaanci. ");
INSERT INTO snf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓéeɓ ɓuwaa waaruꞌussa, ɓaa ndam Kooh, ɓa jaahliꞌꞌa bi ɓaa woꞌ an: «Ɗí hotin wati iñaa mosoo kilaak ga fen.» ");
INSERT INTO snf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lëehíꞌta, Yéesu meƴca, ya hotta juuti, yaa teeku Léwí, yugin ga ɗekataa fayohsi juutiɗa. Ya woꞌꞌari an: - Taabukaaroo! ");
INSERT INTO snf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Léwí íissa tóoh, kolukka yaa taabukki. ");
INSERT INTO snf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Léwí tíkɗee Yéesu ñamah cijófíꞌ ga kaanci. Juuti ɓiyewin na ɓiɓoꞌ ɓiliis bokussa naɓa kanu. ");
INSERT INTO snf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fërísiyeeŋcaa na jëgíroh-waascaa faꞌ naɓaɗa ɓaa ñaꞌsukoh, ɓa woꞌꞌa tëelíbéecaa Yéesu an: - Iñii tah ya ɗú bok kiñam na kiꞌan na juuticii na ɓuwii júwussiiɗa? ");
INSERT INTO snf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yéesu kelohhaɓa, loffaɓa an: - Ɓuwaa dara gaa naɓa laakussii sooli ga payoh, wayee ɓuwaa ɗúukoolin ɓërí laak sooli ga. ");
INSERT INTO snf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi hayyii ga ëldúna kiɓay ɓuwii júwinɗa wayee mi hay kiɓay haꞌ-baakaaꞌcii doo ɓa súpít kipeskiigaɓa. ");
INSERT INTO snf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓiɓoꞌ woꞌussa Yéesu an: - Tëelíbéecii Saŋ na ɓii Fërísiyeeŋcii ooꞌsi leekleek ee ɓa kíimi Kooh, wayee ɓiigaraa ñami hen, ɓa ani. ");
INSERT INTO snf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yéesu loffaɓa an: - Ɗú mínin kiꞌooꞌlukoh ɓedohcii haꞌ-kílookkii lakanaa haꞌ-kílookkii yii naɓane? ");
INSERT INTO snf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wayee bes hay kihay, haꞌ-kílookkaa hay kiɓewohu ga díkaantiɓa, bescaama nak ɓa hay kiꞌooꞌ. ");
INSERT INTO snf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yéesu liiwukkaɓa ɓan: - Ken ɗaroo píis ga kúltí fiꞌas, daafwa ga líil-kúltí. Fu tumkanaa, fu hay kiɗaꞌ kúltífaa fiꞌasfaa ee píisaa wiꞌaswaa nísohu gafaɗa taabohanndii na líil-kúltífaa. ");
INSERT INTO snf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Fodaama, ken tumoo biiñ wiꞌas, waa dal kilúun, ga mbúus-oncaa maañin. Fu tumkanaa, biiñaa pook mbúus-oncaa: biiñaa aamuk, ee mbúuscaa yasukoh. ");
INSERT INTO snf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kon biiñ wiꞌas jom kitumu ga mbúus-on ciꞌas! ");
INSERT INTO snf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ee ken waaroo kiꞌan biiñ wiꞌas binaa ya meyoh kiꞌan ga wimëeñíꞌwaanaa; ndaga ya woꞌi an wimëeñíꞌwaa wërí wëñ kineɓ. ");
INSERT INTO snf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Laakka bes Sabat, Yéesu koorohee ga ɗuuƴ yoonaa lúudin. Tëelíbéecaagari ɓaa weel ga boŋcaa, ɓaa ɓoliñ towutaa ga yahcaagaɓa, ɓaa ñam. ");
INSERT INTO snf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Laakka Fërísiyeeŋcaa woꞌuɓa an: - Iñii tah ya ɗú tum iñii Waasii kokohin kitum ga bes Sabat? ");
INSERT INTO snf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yéesu loffaɓa an: - Hanaa ɗú jaŋngii iñaa Dëwít tumee ga waa ya yaaɓ, ya na ɓuwaa taabee nariɗa? ");
INSERT INTO snf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ya aassa ga taalaa Kooh, ya ɓeɓpa ga mbúurúcaa meƴdohɗusee Koohɗa, ya ñammba ga, ya eꞌta ɓuwaa taamsee nariɗa ga. Ee mbúurúcaama sarahohcaa doŋ onuca kiñam. ");
INSERT INTO snf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Lëehíꞌta Yéesu woꞌissaɓa an: - Kowukii ɓii kërí laak bes Sabat. ");
INSERT INTO snf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Laakissa bes Sabat, Yéesu kaꞌta jaangu-yaawúuraa, ya yaa jëgíroh. Laakka daama ɓoꞌ, yaa yahaa ñaabaa ɗooƴkin. ");
INSERT INTO snf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jëgíroh-waascaa na Fërísiyeeŋcaa ɓaa malak ga Yéesu, ati ɓa hayyi kihot ya wëkíꞌ ɓoꞌ ga bes Sabat, doonaa ɓa laak iñaa ɓa yabohanndi. ");
INSERT INTO snf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wayee Yéesu ínohha halaatcaagaɓa, ya woꞌꞌa ɓaa yahaa ɗooƴkinɗa an: - Kolka, fu tuuk dii ga fíkíi ɓéeɓ! Ɓaa kolukka, tuukka. ");
INSERT INTO snf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lëehíꞌta, Yéesu woꞌꞌa ɓuwaa an: - Mi meekissúu ati ga bes Sabat Waas onoh kitum iñaa jofin wala iñaa moroo, kisom kumuun ɓoꞌ wala kilaŋ kumuun? ");
INSERT INTO snf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ya malakka ɓéeɓ ɓuwaa wíilliɗa, ya woꞌꞌa haꞌ-yahaa an: - Lërísaa yahiigaraa! Ɓaa lëríssa, yahaa dalla kiwak, mannda ga daa wa eneeɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wayee ɓuwaa ɓíinoo ensee daɗa líifussa muut na tam-keeñ, ɓa ɓaa malak ga díkaantiɓa iñaa ɓa tuman Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ga bescaama, Yéesu kaꞌta jaŋjaŋcaa kikíim Kooh, ya tessa wekaa ɓéeɓwa kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ga waa Kooh wíissa, ya ɓayya tëelíbéecaagari, ya tanukka ga ɓoꞌ ɓidaaŋkaah na ɓanak, ya teekkaɓa ɓiꞌapotaaꞌ: ");
INSERT INTO snf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoŋ (yaa ya teek Peeꞌɗa) na këmëeŋkíci Andari, Saak na Saŋ, Filiip na Bartulëmíi, ");
INSERT INTO snf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mëccëe na Toomaa, Saak kowu Alfee na Simoŋ selootaa, ");
INSERT INTO snf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yúdaa kowu Saak na Yúdaa Iskariyot, yaa onan Yéesu bíiŋɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yéesu yoosukka jaŋjagaa na apotaaꞌcaagari bi ga ndëneeraa, ga daa ɓoꞌ ɓiyewin ga tëelíbéecaagari enoheeɗa. Laakeera daama ɓan mbooloo wiyaak waa meyohee kúlkaa Yúudée na teeraa Yéerúsaleem, na gohcaa ɓopukoh na giiyaaɗa: Tíiꞌ na Sídoŋ. ");
INSERT INTO snf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓa hayeeri kisúkúruk, ee ya wëkíꞌɓa ga ɗúukoolcaagaɓa. Ɓuwaa raɓ amɗa wëkɗussa. ");
INSERT INTO snf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓaa en ɓéeɓ yaa heel kileꞌ gari, ndaga dooli meyohi gari, wa wëkɗiɓa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Lëehíꞌta Yéesu malakka tëelíbéecaagari, ya woꞌꞌa an: - Ɗú yewinin múuꞌ, ɗú nduulcii ndaga Nguuraa Kooh wuurúu. ");
INSERT INTO snf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɗú yewinin múuꞌ, ɗú ɓii ɗú yaaɓ watiɗa ndaga ɗú hay kikap. Ɗú yewinin múuꞌ, ɗú ɓii ɗú koduk watiɗa ndaga ɗú hay kiƴen. ");
INSERT INTO snf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ɗú yewinin múuꞌ moos, binaa Kowukii ɓii tah bi ɓuwii sagussúu, ɓa kaallúu ga ɗuuƴɓa ɓa ɓassúu, ɓa taasuk teekcaagarúu. ");
INSERT INTO snf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iñaama laakaa, laa neɓlukat, ɗú koltuki, ɗú hami ndaga neehal wiyaak waa sekkúu ga ɗook-Kooh. Ɓicaasamɓa sodalsee sëldíiga-Koohcaa fodaama. ");
INSERT INTO snf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wayee nak, massa ɗú, haꞌ-alalcii ndaga ɗú laasin ɓakkúu. ");
INSERT INTO snf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Massa ɗú ɓii ɗú kapin watiɗa ndaga ɗú hay kiyaaɓ. Massa ɗú ɓii ɗú ƴen watiɗa, ndaga ɗú hay kiꞌen ga coonu ee ɗú hay kikoduk. ");
INSERT INTO snf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Massa way, binaa ɓuwii woꞌ garúu iñaa jofinaa, ndaga ɓicaasamɓa tumsee fodaama na ɓuwaa tíkee hafɓa ɓisëldíiga-Koohɗa ee lak sabohɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yéesu tíkka ga an: - Wayee ɗú ɓii ɗú súkúrukkooɗa, mi woꞌꞌúu an: waarat ɓuwii heñohsirúuɗa, tumɗat ɓuwii saŋngúuɗa iñaa jofin. ");
INSERT INTO snf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kíimat Kooh ya barkeel ɓuwii cojirúuɗa ee kíimɗat ɓuwii sodalirúuɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Binaa ɓoꞌ feekkaa ga ŋaamaa, eraari wíinoowaa ɓan. Binaa ɓoꞌ teꞌ sabadooraagaraanaa, kaa sagiꞌti túrkaa ɓan. ");
INSERT INTO snf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɓaa kíimmbaa yen ɓéeɓ, laa onaari; ee ɓaa teꞌ iñaa en yuufunaa, kaa teꞌsiswa. ");
INSERT INTO snf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fodaa daa ɗú waaꞌ ɓimooroommbúu tumiꞌtúuɗa, laa tumɗatɓa iñaa manɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Binaa en lak ɗú waaꞌ ɓuwii waaꞌtúuɗa rekaa, ndamii wiida wërí ɗú laakan ga iñaama? Bi ga ɓuwii júwussiiɗa sah waaꞌsin ɓuwaa waaꞌɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ee binaa en lak ɓuwii tumɗirúu yijófíꞌɗa ɓërí rek ɗú íkiꞌ iñaa jofinaa, ndamii wiida wërí ɗú laakan ga iñaama? Bi ga ɓuwii júwussiiɗa sah tumsinka. ");
INSERT INTO snf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ee binaa en lak ɓuwaa ɗú yaakaaꞌ an ɓa hayyúu kifayɗa ɓërí rek ɗú wútíranaa, ndamii wiida wërí ɗú laakan ga iñaama? Bi ga ɓuwii júwussiiɗa sah wútíꞌsin ɓuwaa man naɓaɗa, lëehíraa ɓa laas iñaa hín na iñaa ɓa wútírohɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kon waarat ɓuwii saŋngúuɗa, tumɗatɓa yijófíꞌ, erohat ee kaa séentukat dara ga, en ɗanaa neehalaagarúu hay kiyak ee ɗú ƴah towutii Kooh yii ga ɗookaa-ɗookɗa, ndaga Kooh jofin ga ɓuwii tookkiiri kigërëm ga iñcaa ya tumiꞌɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Líifat na yërmaandi fodii dii Paammbúu Kooh líif na yërmaandiɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yéesu tíkka ga an: - Kaa attiꞌat ken, en ɗanaa Kooh attiꞌoorúu. Kaa tamat ken, en ɗanaa Kooh tamoorúu. Bayalat ɓimooroommbúu en ɗanaa Kooh hayyúu kibayal. ");
INSERT INTO snf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Onohat en ɗanaa Kooh hayyúu kiꞌon: ɗú hay kinatɗu yen, ɗú goꞌɗu yewin, yëngëlu bi ɗeguk, líif bi aamuki, ndaga nataa ɗú natoh ɓuwiiɗa wërí ɗú natohohsan. ");
INSERT INTO snf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lëehíꞌta, Yéesu liiwukkaɓa anee ɓan: - Búumíꞌ mín kinook búumíꞌ mooroomcine? Baanaa ɓéeɓɓa ɓa ɓanak, ɓa keenanndii ga noge? ");
INSERT INTO snf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tëelíbée mínoo kipaaf ɓaa jëgíꞌtiɗa, wayee tëelíbéenaa mat ga jagaagarinaa hay kileꞌ ga jëgírohaagari. ");
INSERT INTO snf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Iñii tah ya fu malaki ɓolaa en ga kuhaskaa mooroomfu, ee fu mínoo sah kimalaksukoh dúuñii en ga kuhaskiigaraaɗa? ");
INSERT INTO snf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fu yii fu hottii dúuñii en ga kuhaskiigaraaɗa, fu mínan na kiwoꞌ mooroomfu an: «Fiilii, íisa mi nísíꞌtaa ɓolii en ga kuhaskiigaraa»? Fu yii fu jófjófɗuki ga fíkíi ɓuwiiɗa, ɗewaa kinís dúuñii en ga kuhaskiigaraaɗa, en ɗanaa fu hay kihot dijófíꞌ bi fu mín kinís ɓolaa en ga kuhaskaa mooroomfuɗa. ");
INSERT INTO snf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yéesu tíkka ga an: - Kedik kijófíꞌ límoo kowukaa moroo ee kedikkaa ɗúukoolin límoo kowukaa morin. ");
INSERT INTO snf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kedikkaa en ɓéeɓ ínohohsan ga towutaa ya laakɗa: ken ɓeenoo towu een ga kaꞌkaꞌ ee ken ɓeenoo towu reseŋ ga pëegíi-ñaawaaɓ. ");
INSERT INTO snf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɓoꞌ yijófíꞌ tumi iñaa jofin, ndaga iñaama rek yërí ya ɗaak ga keeñaagari. Ɓoꞌ yibóníꞌ tumi iñaa bonin ndaga iñaama rek yërí ya ɗaak ga keeñaagari. Ee ɓoꞌ, iñaa ya meƴdohi ga kúuwciɗa, wërí líif ga keeñci. ");
INSERT INTO snf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yéesu tíkka ga an: - Ɗú ɓayohhoo ya «*Haꞌmudii, Haꞌmudii» ee iñii mi nakirúuɗa ɗú tumoori? ");
INSERT INTO snf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɓaa hay garoo ɓéeɓ ee ya súkúruki woꞌeenciigoo ee ya taabukica ga tumeenaagari, mi hayyúu kiwoꞌ ɓaa ya mëdírohu nariɗa: ");
INSERT INTO snf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɓaa yaama mëdírohu na ɓaa enee na kitawah kaan; ya acca bi huutta, ya daɓpa atoh, ya yíppa kaanfaa ga ɗookgaa. Toɓ wiyewin keennda bi ɓaalaa líiffa, wambalaa tapukka ga kaanfaa ee mínndiifa kiɓúuk ndaga tawahaa kaanfaa yëgíseera. ");
INSERT INTO snf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wayee ɓaa keloh ee taabukkii woꞌeenciigoo ga tumeenaagari, ɓaa yaama mëdírohu na ɓaa tawah kaan, yíppafa ga ɗook kakay ee accii dara. Waa wambalaa tapukka ga kaanfaa faama, ga saasi, fa ɓúꞌta ee kaanfaa ɓéeɓ yasukohha. ");
INSERT INTO snf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ga waa Yéesu lëehíꞌta kiwoꞌ iñcaa ya waaree ɓuwaa kelohɗa, ya kaꞌta teeraa Kafarnawom. ");
INSERT INTO snf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Daama laakeera soldaaraa yiyaakyaa kuliyuki ga heñɗa. Ɓaa yaama laakeera súrga, yaa ya keeñukin, lakanaa súrgaa ɗúukoolin bi yaa ƴah kilëehɗuk. ");
INSERT INTO snf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ga daa soldaaraama kelohee iñaa woꞌu ga loo Yéesuɗa, ya wossa ga yaakcaa yaawúuꞌcaa kikíimmbi ya hay kiwëkíꞌ súrgaagari. ");
INSERT INTO snf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓuwaa wosseeɗa hayussa ga Yéesu, ɓa tuukkiꞌtari tek, ɓa woꞌꞌari an: - Ɓii wossíi garaaɗa, calin kidímal, ");
INSERT INTO snf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ndaga ya waarin ɓu-dëkiigaríi, ee yërí tawah jaangu-yaawúuraagaríi. ");
INSERT INTO snf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Waa ennda ɗa Yéesu yaa ƴah naɓa. Ga waa ɓa deeƴca kaanfaa, soldaaraa yiyaakyaa wosissa ga fiiliimuncaagari, ɓa woꞌ Yéesu an: - Kiyaakii, kaa sodal haffu, ndaga joobinndoo fu aas kaanndoo, ");
INSERT INTO snf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","iñaama yërí tah bi mi woꞌ an joobinndoo mi hay na kihaffoo kihídohnee naraa. Wayee woꞌaa woꞌeen wíinoo rek, súrgiigoo wak. ");
INSERT INTO snf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndaga mi ga kihaffoo, mi laakin ɓuwaa hanohhoo ɗook ee mi laakin soldaaꞌcaa hanohussoo kakay. Binaa mi woꞌ yii an karanaa, ya kaꞌ; mi woꞌ yíinoo an hayanaa, ya hay; ee binaa mi woꞌ súrgaagoo an tumaa iñii yiinaa, ya tummbi. ");
INSERT INTO snf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Daa Yéesu kelohee woꞌeencaama, ya waaruꞌꞌa ga soldaaraa yiyaakyaa. Ya mëeñsukka ga mbooloomaa taabukeeriɗa, ya woꞌꞌa ɓuwaa an: - Mi woꞌꞌúu man, bi ga ɗuuƴ Isarayeel sah mi mossii kihot ɓaa laak ngëmaa hín na wii garoo. ");
INSERT INTO snf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lëehíꞌta ɓuwaa soldaaraa woseeɗa ɓoyukussa kaanfaa. Ɓa laakka súrgaa ɗúukooleeɗa wakin peleŋ. ");
INSERT INTO snf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lëehíꞌta Yéesu kaꞌta teeraa woꞌsi Nayinɗa. Tëelíbéecaagari na ɓoꞌ ɓiyewin taamsee nari. ");
INSERT INTO snf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ga waa ɓa deeƴca aasaaraa dëkaa, ya hotta ɓuwaa ɓaa ƴah kiꞌacnee faraaf. Ɓaa kaanɗa, enee kowu kíinoo ga eeci; ee eemunaa, ƴaalaa kaanin. Laakeera ɓoꞌ ɓiyewin ga dëkaa, ɓaa taam na ɓetifaa ga waas acaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Daa Yéesu Haꞌmudii hotee eemunaa, ya laakka yërmaandi wiyaak gari, ya woꞌꞌari an: - Kaa koduk! ");
INSERT INTO snf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lëehíꞌta, Yéesu deeƴca, leꞌꞌa ga ñoyaa ɓuwaa abohɗa, ɓa tuukka. Yéesu woꞌꞌa an: - Oomaa-fiilii, mi nakkaa, kolka! ");
INSERT INTO snf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɓaa kaaneeɗa kolukka, yuŋnga yaa aaw kiwoꞌ. Yéesu íkkari eemunaa. ");
INSERT INTO snf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓuwaa ɓéeɓɓa tíitussa ga iñaama ee ɓa ɓaa kañ Kooh, ɓa ɓaa woꞌ an: - Sëldíiga-Kooh yiyaak hotukin ga ɗuuƴcuu, ee Kooh hayin kiɓaaɓ ɓu-kaanci. ");
INSERT INTO snf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iñaa aaw ga Yéesu yaa ɓéestírukohu ga kúlkaa Yúudée ɓéeɓ na iñaa wíilwaɗa. ");
INSERT INTO snf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tëelíbéecaa Saŋ ɓéestírussari iñcaa Yéesu tumeeɗa tóohca. Ya ɓayya ɓanak gaɓa, ");
INSERT INTO snf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ya wossaɓa ga Yéesu, Haꞌmudii, kimeekissi an: «Fu yërí en ɓaa jom kihayɗanoo ɗí sekan ɓoꞌ yiliis?» ");
INSERT INTO snf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ga waa ɓa kaꞌta bi ga Yéesu, ɓa woꞌꞌari an: - Saŋ-Bëtís yërí wossíi garaa kimeekissaa ati fu yërí en ɓaa jom kihayɗa wala ɗí sekan ɓoꞌ yiliis. ");
INSERT INTO snf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ga wahtaama siiꞌ, Yéesu wëkíꞌta ɓoꞌ ɓiyewin ga ɗúukoolcaagaɓa, na ga iñaa mesikɓaɗa, ya kaalla raɓcaa ga ɓuwaa ee búumíꞌ ɓiyewin, ya onndaɓa kihot. ");
INSERT INTO snf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ya dalla ɓuwaa kitaas an: - Karat ɗú ɓéestíꞌnee Saŋ iñcii ɗú hotɗa, na iñcii ɗú kelohɗa: búumíꞌcii ɓii hot, lafañcii ɓii tíin dijófíꞌ, gaanacii ɓii sétíru, ɗekcii ɓii keloh, faraafcii cii mílís, nduulcii ɓii yéegalu Hewhewii winéwíꞌwii. ");
INSERT INTO snf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɓaa mi tahhiiraa kisoof fenoo ga ngëmaagaraanaa, fu yewinin múuꞌ! ");
INSERT INTO snf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ga waa ɓuwaa Saŋ woseeɗa karussa, Yéesu aawwa kiwoꞌ mbooloomaa iñaa aaw ga Saŋ, an: - Ɗú karee kimalaknee ya ga ëgíꞌ-dúndagaa? Pëegíi-përúudúufaa en na kiꞌeguk ga uurisaane? ");
INSERT INTO snf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Enndiikanaa ɗú karee ya kimalaknee? Ɓoꞌ yaa ekuk kúltí cimóríre? En kiꞌenaa, ɓuwii ekuk kúltí cimóríꞌ ee dëku ga iñaa newinɗa, ɓii ga kaancii buuꞌcii. ");
INSERT INTO snf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kon ɗú karee kimalaknee ya daama? Sëldíiga-Koohe? Ee! Mi woꞌꞌúuka, ɓaama paafin sah sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Saŋ yërí en ɓaa woꞌu ga Këyítfaaɗa an: «Mi yii wos ɓoꞌꞌoo, yaa ɗëwrukanndaa, kiwaayukiꞌtaa waasum.» ");
INSERT INTO snf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yéesu tíkka ga an: - Mi woꞌꞌúuka, ga ɓuwii límukoh ga ɓetiɗa ɓéeɓɓa, laakkii ga yaa wëñ Saŋ kiyak, wayee ɓaa wëñ kijutuut ga Nguuraa Koohɗa yërí wëñ Saŋ kiyak. ");
INSERT INTO snf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓéeɓ ɓuwaa súkúrukeeriɗa, bi ga juuticaa tookussa an Kooh júwin, ee Saŋ bëtísiꞌꞌaɓa. ");
INSERT INTO snf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wayee Fërísiyeeŋcaa na jëgíroh-waascaa sagussa Saŋ bëtísiꞌɓa, fodaama ɓa teewohee an ɓa faaliꞌꞌii iñaa Kooh waariꞌɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yéesu tíkka ga an: - Kon ɓuwii jamaanii wati, mi mëdírohanɓa na ɓa? Ɓa man na ɓa? ");
INSERT INTO snf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓa man na oomaacaa yugu ga paanaa dëkaa, ɓíinoo ɓaa woꞌ ɓimooroomɓa an: «Ɗí mbiiɓɗinndúu ee ɗú hammbii! Ɗí helemin ee ɗú kodukkii!» ");
INSERT INTO snf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ndaga Saŋ-Bëtís hayin, ya ñamoo ee anoo fodii ɓuwii, ee ɗú woꞌ an: «Ya laak raɓ». ");
INSERT INTO snf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kowukii ɓii hayin, kii ñam, kii an, ee ɗú woꞌ an: «Malkat ɓii yii halaat kiñam doŋ na kiꞌan biiñ ee ya fiiliimunoh na juuticii na tumoh-baakaaꞌcii.» ");
INSERT INTO snf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wayee ɓéeɓ ɓuwii took kiñaañkii Koohɗa ínohuunun an ka júwin. ");
INSERT INTO snf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Laakka Fërísiyeegaa ɓay Yéesu kiñamnee nari. Yéesu kaꞌta kaanfaa Fërísiyeegaa, ya yuŋnga kiñam. ");
INSERT INTO snf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lak laakin ga teeraa ɓeti, yaa júɓpii. Daa ya yéegee an Yéesu yaa ñam ga kaanfaa Fërísiyeegaa, ya haydohha kujúlúŋkaa líifin na laꞌkoleñ, jaa hëwrohu na atohaa woꞌu albataaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya tuukohha Yéesu fenoo, ga kotcaagari. Ya yaa koduk bi yaa tóoyíꞌ kotcaa Yéesu na mooncaagari. Lëehíꞌta, ya yaa moos kotcaa na fenfaagari, ya yaa fuunca, ee ya yaa leefca laꞌkoleñ. ");
INSERT INTO snf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Daa Fërísiyeegaa ɓayee Yéesu kiñamɗa hotee iñaama, ya yaa woꞌ ga helci an: «Ɓii yii enee sëldíiga-Koohaa, eneenaa ya hay kiꞌínoh ɓii en ɓetifii leꞌ gariɗa ati ya ɓa: eneenaa ya hay kiꞌínoh an ɓii yii ɓetifaa júɓpii.» ");
INSERT INTO snf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yéesu taassa woꞌꞌa Fërísiyeegaa an: - Simoŋ, laakin iñaa mi waaꞌtaa kiwoꞌ. Simoŋ taassa an: - Jëgírohii, woꞌa! ");
INSERT INTO snf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yéesu woꞌꞌa an: - Enee ɓoꞌ ɓanak, ɓaa laakiꞌ ɓoꞌ kobot: yíinoo ɓayɗeeri denariyon citéeméeꞌ-yëtúus, yíinooyaa cidaaŋkaah-yëtúus. ");
INSERT INTO snf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ya múuñíꞌtaɓa ɓéeɓɓa ɓanakɓaa ndaga lak ɓa mínéeríiri kifay. Kon yiida wëñanndi kiwaaꞌ ga ɓuwaa ɓanakɓaama? ");
INSERT INTO snf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoŋ taassa an: - Mi fooŋ man yaa múuñɗu kobotfaa wëñ kiyakɗa, yërí. Yéesu woꞌꞌari an: - Fu woꞌin kayoh. ");
INSERT INTO snf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lëehíꞌta Yéesu mëeñsukka ga ɓetifaa, woꞌꞌa Simoŋ an: - Fu hotin ɓetifii fiine? Ya tísɗinndoo kotciigoo na moonciigari, ya moosɗinndooca na fenfiigari. Wayee fu, mi aasin kaanfu ee fu eꞌtiiroo músú kitís kotciigoo. ");
INSERT INTO snf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fu gatanukkiiroo fu fuunndoo, wayee iñaa mi aasee dii, ya íissii kifuun kotciigoo. ");
INSERT INTO snf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fu leeffii sah dúuleen wiꞌéeñíꞌ ga hafiigoo, wayee ya, ya leefin laꞌkoleñ ga kotciigoo. ");
INSERT INTO snf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kërí tah mi woꞌꞌaa man kiwaaꞌkii kiyaakkii en gariɗa kërí teewoh an baakaaꞌciigari ciyewincii bayaluunun. Wayee ɓoꞌ, kiwaaꞌkaagari jutuutaa, lakanaa bayalu jutuut. ");
INSERT INTO snf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Waa ennda ɗa, Yéesu woꞌꞌa ɓetifaa an: - Baakaaꞌcumgaraa bayaluunun. ");
INSERT INTO snf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓuwaa boksee nari kanuɗa ɓaa woꞌ ga helcaagaɓa an: «Ɓii yii ya ɓa, bi ya bayalli sah baakaaꞌ?» ");
INSERT INTO snf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wayee Yéesu woꞌissa ɓetifaa an: - Ngëmumgaraa músalinndaa, karaa na jam. ");
INSERT INTO snf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lëehíꞌta, Yéesu yaa kaꞌ ga dëk-teerucaa na dëk-kawcaa, yaa jangat ee yaa yéegaloh Hewhewaa winéwíꞌwaa Nguuraa Kooh. Tëelíbéecaagari ɓidaaŋkaah na ɓanakɓaa taamsee nari, ");
INSERT INTO snf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na ɓiɓeti, ɓaa wëkɗusee ga raɓ na ɗúukool ciliis: enee Mërí ee ɓaysi Mërí Makdalaa, yaa raɓ ɓiyitnaɓanak meƴdohsee gariɗa; ");
INSERT INTO snf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Saan, ɓeti Húusas tuukkoh-alalaa buuꞌ Eroot; Súsaan na ɓeti ɓiyewin ɓiliis ɓaa dímalsee Yéesu na tëelíbéecaagari ga iñaa ɓa laakɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mbooloo wiyaak hídírukohha ee ga dëk-teeraa en ɓéeɓ ɓuwaa ɓaa meyoh ga kihay ga Yéesu, ya woꞌꞌa liiwukii wii: ");
INSERT INTO snf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","- Enee línoh, ya kaꞌta kisoknee tesohtaagari. Ga daa ya en na kisokɗa laakka tesohtaa keen ga ɗook waasaa, kotcaa togisohhata, selcaa ñammbata. ");
INSERT INTO snf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Laakka tesohtaa keen ga ɗekataa yewinin atoh, ta taa paal, ta súɓpa ndaga ta laakéeríi tooylaat. ");
INSERT INTO snf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Laakka tesoh tiliis taa keen ga ɗook ƴówée-lúp, ta paaldohha na lúpcaa, lúpcaa onndata. ");
INSERT INTO snf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ee laakka tesohtaa keen ga kakayfaa laakin dooli, ta paalla, ta yakka, ta meƴdohha boŋ. Bogaa en ɓéeɓ towu titéeméeꞌ. Waa ya lëehíꞌta kiliiwuk fodaama, ya woꞌꞌa ga ɗook an: - Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tëelíbéecaa Yéesu meekissari iñaa liiwukaama waaꞌ kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ya taassaɓa an: - Ɗú ɓërí eꞌsee kiꞌínoh kúmpacaa Nguuraa Kooh. Wayee ɓuwii tesɗa ɓa kelohan ga liiwuk na liiwuk, doonaa «ɓa mín kimalak ee ɓa hotoo dara, ɓa mín kikeloh ee ɓa ínohoo dara.» ");
INSERT INTO snf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yéesu woꞌꞌaɓa an: - Iñii yii yërí liiwukii waaꞌ kiwoꞌ: pesohpaa përí en woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɓuwii ɓíinoo madu na ɗookgaanaa waasaa tesohtaa keenohɗa. Ɓa kelohin woꞌeenii Kooh, wayee Seytaani hayinaa, nísiwa ga keeñcaagaɓa doo ɓa gëmoo bi ɓa mín kimúc. ");
INSERT INTO snf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ɓíinoo madu na ɗekataa yewinin atohɗa, ɓërí en ɓuwaa, binaa ɓa keloh woꞌeenaa Koohaa, ɓa safaꞌ gawa kiteꞌ, wayee ɓa íisoo woꞌeenaa yíp níil ga keeñcaagaɓa; ngëmaagaɓa maañoo, ee Seytaani jéematukiɓanaa, ɓa tagohi nawa. ");
INSERT INTO snf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tesohtaa keen ga ƴówée-lúpcaaɗa, teewoh ɓuwaa kelohsin woꞌeenaa Kooh, wayee halaat na alal na neɓlaat ëldúna abuɓa ga kipesɓa; iñcaama on woꞌeenaa Kooh bi ɓa mínoo kimat fodii pohoopaa ɓay bogaa lúudin. ");
INSERT INTO snf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tesohtaa keen ga kakayfaa laakin dooliɗa, teewoh ɓuwaa keloh woꞌeenaa Kooh ee ɓa amwa na keeñ wijófíꞌ, wijúwíꞌ ee ɓa yëgís ga bi ɓa tumi fodaa pohoopaa ɓay boŋ wijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yéesu woꞌꞌa an: - Ken taaloo lampu, líꞌ kanu ga, wala tofwa ga fíldoo fayaaŋ, wayee fu líkanwa hen doonaa ɓuwaa aas túuyaaɗa, hot leeꞌlaataa. ");
INSERT INTO snf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iñaa ɗaakuk ɓéeɓ hay kihotuk ee iñaa apoh kúmpa ɓéeɓ hay kiꞌínohu ee hay kimeƴdohu faŋ. ");
INSERT INTO snf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Malaksukohat book ga dum ɗú súkúrukiɗa, ndaga ɓaa laakin hay kiɓaatɗu; wayee ɓaa laakoo, iñaa ya fooŋ an ya laakinɗa sah hay kiteꞌu gari. ");
INSERT INTO snf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eew Yéesu na ɓikëmëeŋkí Yéesu hayussari kimalaknee. Wayee ɓa mínndii kileꞌ bi gari ndaga mbooloomaa. ");
INSERT INTO snf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Laakka ɓaa yéegal Yéesu an: - Eefu na ɓikëmëeŋkífu ɓaa day, ga fooh, ɓa waaꞌtaa kihot. ");
INSERT INTO snf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wayee Yéesu taassaɓa ɓéeɓɓa an: - Eewwoo na ɓikëmëeŋkíroo ɓërí en ɓuwaa súkúruki woꞌeenii Kooh ee ɓa taabukiwa ga tumeencaagaɓa. ");
INSERT INTO snf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Laakka bes Yéesu aassa na tëelíbéecaagari ga gaal-looci, ya woꞌꞌaɓa an: - Ɗu paafat giiyii ɓakaa hanoh gaaɗa. Ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yéesu neehha lak ɓa ɓaa ƴah ga ɗuuƴ giiyaa. Uuris wiyaak dalla kiyíp ga giiyaa, músúmaa maa soruk ga loocaa bi waa waaꞌ kilíif ee tumuuntaagaɓa taa waaꞌ ga kiꞌeem. ");
INSERT INTO snf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓa deeƴca ga Yéesu, ɓa yúunndari an: - Jëgírohii, Jëgírohii, kikaankii kii hayyuu! Yéesu yúudukka, gëtta uurisaa na dúuscaa, ca seemmba, ɗekataa ennda cel. ");
INSERT INTO snf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lëehíꞌta Yéesu woꞌꞌa tëelíbéecaagari an: - Ngëmumgarúu narooɗa wada? Wayee ɓa tíitta, ɓa waaruꞌꞌa lool, ɓa ɓaa woꞌ ga díkaantiɓa an: - Moo, ɓii yii ya ɓa? Ya ebili sah uurisii na músúmii ee ca kelohɗiri! ");
INSERT INTO snf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yéesu na tëelíbéecaagari teerussa ga gohaa Gerasaa ëewrukoh na gohaa Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yéesu yaa yoosuk ga gaal-loocaa, laak ɓoꞌ yaa dëk-teeraa, yaa gúꞌɗukohhi. Ɓaama enee haꞌ-raɓ. Iñaa ya gëƴ kiꞌekuk kúltí maañin lool ee ya dëkéeríi ga kaan, ya dëkee ga loycaa. ");
INSERT INTO snf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Daa ya hotee Yéesu hen, ya fiippa, ya jafukka ga kotcaa Yéesu, ya woꞌꞌa didóolíꞌ an: - Fu naroo ya, Yéesu, fu Kowukii Kooh yii ga ɗookaa-ɗookɗa? Mi kíimmbaa hen, kaa tummboo iñaa meskin. ");
INSERT INTO snf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iñaama, ɓaa woꞌeeri ndaga Yéesu ebilee rawaa kimeyoh gari. Rawaama yewneerari kiɓúuki, en ɗanaa ɓuwaa tëhdohiri, yahcaa poku na ceen, ɓa jëengí kotcaa. Wayee ya gúꞌ ceencaa, ya weel jéeŋcaa ee rawaa ëewdohiri ëgíraa. ");
INSERT INTO snf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yéesu meekissari an: - Fu teeku na? Ya taassa an: - Mi teeku coogeel. Ya woꞌee iñaama ndaga raɓ ɓiyewin ɓërí abeeri. ");
INSERT INTO snf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Raɓcaa ɓaa kíim Yéesu an ya hanatɓa kiyeꞌ ga ɓu-baam. ");
INSERT INTO snf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lakanaa laakin yop-mbaam-parki wiyaak waa en na kiníiru daama ga jaŋjagaa. Raɓcaa kíimussa Yéesu ya onɓa kiꞌaas ga mbaamcaama. Ya onndaɓa iñaama. ");
INSERT INTO snf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Raɓcaa meyussa ga ɓaa, aasussa ga mbaamcaa. Yop-mbaamaa írkísukohha jaŋjagaa, keennda ga giiyaa, wa muuꞌta. ");
INSERT INTO snf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Daa níirohcaa hotee iñaa laak yaama, ɓa núppa, ɓaa ɓéestíꞌ iñaa hewɗa ga teeraa na dëk-kawcaa. ");
INSERT INTO snf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓuwaa karussa kimalaknee iñaa hewɗa. Ɓa kaꞌta bi ga Yéesu, ɓa laak ɓaa raɓcaa meyoh gariɗa yugin kakay ga kotcaa Yéesu, ekukin kúltí, taabin na sagaagari. Ɓa dalla kiniik. ");
INSERT INTO snf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓuwaa hotee iñaa laakɗa ɓaa ɓéestíꞌɓa ga daa haꞌ-rawaa wëkɗuseeɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Waa ennda ɗa ɓéeɓ ɓuwaa en ga gohaa Gerasaaɗa kíimussa Yéesu ya úsaayɓa ndaga lak ɓa tíitin lool. Yéesu aasissa ga gaal-loocaa kiƴah. ");
INSERT INTO snf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɓaa raɓcaa meyohee gariɗa kíimmba Yéesu kiꞌíissi ya taam nari. Wayee Yéesu onndiirika, ya woꞌꞌari an: - Ɓoƴkaa kaanfu ee fu ɓéestíꞌ tóoh iñaa Kooh tumiꞌtaaɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ɓaa kaꞌta ga ɗuuƴ teeraa tóoh kiyéegalohnee iñaa Yéesu tumiꞌtiɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yéesu ɓoyukka tewisaa wíinoo, mbooloomaa tëebílukkari, ndaga ɓéeɓ sekeeri. ");
INSERT INTO snf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Daama, laakka ɓaa hay gari. Ya teeku Yayros ee kuliyukee ga jaangu-yaawúuꞌcaa. Ya ƴíꞌꞌa ga kotcaa Yéesu, ya kíimmba Yéesu ya hay kaanci, ");
INSERT INTO snf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ndaga kowukaagari kiɓetikaa ka kíinoo doŋ ya laakɗa kaa ƴah kilëehɗuk. Ka jom kilaak tíkíis tidaaŋkaah na tanak. Ga daa Yéesu enee na kiƴahɗa, ɓuwaa ɓaa ñuupuk gari bi ya yaa ƴah kipaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Laakeera daama ɓetifaa meƴdohee ñíf iñaa leꞌin tíkíis tidaaŋkaah na tanak. Iñaa ya laakeeɗa tóoh leehha ga payohcaa ee yíinoo gaɓa mínndiiri kiwëkíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ya koorohha fenoo, leꞌꞌa ga pawaa kúltífaa Yéesu: Ga saasi ñífaa aamki gariɗa gúꞌta. ");
INSERT INTO snf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Daama Yéesu meekisohha an: - Ɓii leꞌ garoo ɓa? Waa ɓaa en ɓéeɓ yaa taasuk, Peeꞌ woꞌꞌari an: - Jëgírohii, man ɓuwii wíiluununndaa ee ɓii ñuupuk garaa! ");
INSERT INTO snf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wayee Yéesu tíkka ga an: - Ɓoꞌ leꞌin garoo kay, ndaga mi yéegin an laakin doolaa meyohee garoo. ");
INSERT INTO snf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ga waa ɓetifaa ínohha an ya mínsiséeríi kiɗaakuk, ya yaa saak, yaa hay. Ya jafukneera ga kotcaa Yéesu. Ya ɓéestíꞌta ga fíkíi ɓuwaa ɓéeɓɓa iñaa tahee bi ya leꞌꞌa ga kúltífaa Yéesuɗa na daa ya wak ga saasiɗa. ");
INSERT INTO snf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yéesu woꞌꞌari an: - Jowu, ngëmumgaraa músalinndaa. Karaa na jam. ");
INSERT INTO snf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lak Yéesu yaa lís kiwoꞌ fodaama, laakka ɓaa meyoh kaanfaa Yayros, woꞌꞌa yaama an: - Kowukaagaraa kiɓetikaa kaanin, calissiiraa kisonlukohis Jëgírohii ga. ");
INSERT INTO snf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wayee Yéesu, daa ya kelohee iñaama, woꞌꞌa Yayros an: - Kaa niik dara, gëmaa hen rek ee ka hay kipes. ");
INSERT INTO snf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ga waa Yéesu leꞌꞌa kaanfaa, enndii Peeꞌ, Saŋ, Saak, eew kuꞌoomaakaa na paamunaanaa, ya tookkii ɓoꞌ yiliis aas nari. ");
INSERT INTO snf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓuwaa ɓéeɓɓa ɓaa looyoh, ɓaa fiipoh didóolíꞌ ndaga kuꞌoomaakaa. Yéesu nak woꞌꞌaɓa an: - Íisat kodukeenii, oomaanii kaanndii wayee ya en na kineeh. ");
INSERT INTO snf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Daama ɓuwaa ɓaa ciiɓsukki ndaga ɓa ínoheera an oomaanaa kaanin. ");
INSERT INTO snf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wayee Yéesu ammbari ga yahaa, lëehíꞌta ya woꞌꞌa didóolíꞌ an: - Oomaanii, koluka! ");
INSERT INTO snf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Fodaama fítaa kuꞌoomaakaa íkukka ga, ya kolukka ga saasi. Lëehíꞌta, Yéesu nakohha oomaanaa eru ñamah. ");
INSERT INTO snf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Paam kuꞌoomaakaa na eeci waaruꞌussa lool, wayee Yéesu ɗíŋngaɓa an ken hanat ɓoꞌ kiwoꞌ iñaa laakee yaama. ");
INSERT INTO snf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yéesu nëgírohha tëelíbéecaa ɓidaaŋkaah na ɓanakɓaa, ya eꞌtaɓa dooli na kimín kikaal raɓcaa ɓéeɓɓa ga ɓuwaa, na kiwëkíꞌ ɗúukoolíꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lëehíꞌta ya wossaɓa kiyéegaloh Nguuraa Kooh na kiwëkíꞌ ɗúukoolíꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ya woꞌꞌaɓa an: - Ɗú en na kiƴahaa, kaa ɓaydohat dara; hanat kiꞌen dooꞌ wala hëmbu, wala ñamah, wala kopaꞌ. Ee kaa ɓayat yaa en ɓéeɓ kúltí kanak. ");
INSERT INTO snf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Túuyaa ɗú aasoh ɓéeɓ, tesat da bi ga daa ɗú kolkohan daama. ");
INSERT INTO snf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ee binaa ɓuwaa sagussúu kitook ga kaancaagaɓanaa, meyat dëkaa waama, yëekírukat pëndëlaa ga kotcaagarúuɗa. Iñaama hay kiteewoh kimúuƴkaagaɓa. ");
INSERT INTO snf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tëelíbéecaa karussa, ɓa kooꞌta ga dëk na dëk, ɓa ɓaa yéegaloh Hewhewaa winéwíꞌwaa ee ɓaa wëkíꞌ ɗúukoolíꞌcaa ga daa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eroot, buuraa gohaa Gëlílée, yéeŋnga iñaa heweeɗa tóoh. Ya jaahliꞌꞌa ga ndaga laakeera ɓuwaa woꞌee an: - Saŋ yërí mílís ga ɓuwaa kaanɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɓíinoo an: - Ili yërí hay. Ɓíinooɓaa an: - Yíinoo ga sëldíiga-Koohcaa waama yërí mílís. ");
INSERT INTO snf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wayee Eroot woꞌꞌa an: - Saŋ, mi gúꞌlukka hafaa. Kon ɓii mi keloh ya woꞌɗu iñcuma ɓéeɓcaɗa ya ɓa? Ga iñaama ya aawwa kiheel kihot Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apotaaꞌcaa ɓoƴkussa, ɓa ɓéestíꞌta Yéesu tóoh iñcaa ɓa tumeeɗa. Ya woꞌꞌaɓa ɓa taam nari, ya kaꞌta naɓa daa wéetin, ga ɓak teeraa woꞌu Betsaydaa. ");
INSERT INTO snf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Daa ɓuwaa yéegeeka, ɓa taabukkari. Yéesu íissaɓa ɓa hay, lëehíꞌta ya yaa woꞌɓa ga iñaa aaw ga Nguuraa Kooh, ee ya yaa wëkíꞌ ɓuwaa sooluk kipayuɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tëelíbéecaa ɓidaaŋkaah na ɓanakɓaa deeyussa ga Yéesu lak Kooh yaa hooɓ, woꞌussari an: - Íisaa ɓuwii ɓa aas dëk-kawcii na yopcii ga yahaaniiɗa, ɓa heelnee daa ɓa neehan na iñaa ɓa ñaman ndaga ɗekatii ɗu enohɗa laakoo dara. ");
INSERT INTO snf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wayee Yéesu loffaɓa an: - Eratɓa na kihaffúu iñaa ɓa ñaman. Wayee ɓa taassa an: - Ɗí laakkii iñaa wëñ mbúurú ciyëtúus na jën kanak. Hanaa ɗí kaꞌ kilomnee ñamahcaa kap ɓuwii ɓii ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","En kiꞌenaa, laakeera daama iñaa leꞌ ƴaal ɓijúnni-yëtúus. Yéesu woꞌꞌa tëelíbéecaagari an: - Yuŋɗatɓa, ɓa nëgírukoh kom kom, ɓuwaa leꞌ ɓidaaŋkaah-yëtúus. ");
INSERT INTO snf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓa tummba fodaama. Ɓa yugiꞌtaɓa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yéesu ɓeɓpa mbúurúcaa ciyëtúuscaa na jëncaa kanakcaa, ya taaginukka ɗook, ya gërëmmba Kooh gaca. Lëehíꞌta ya gúꞌsohhaca, ya eꞌta tëelíbéecaa ɓa waroh ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓuwaa ɓéeɓɓa ñammba bi ɓa kappa pút, ee pañi cidaaŋkaah na kanak wookussa ga iñaa teseeɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Laakka bes, lak Yéesu enee na kikíim Kooh haŋci ee tëelíbéecaagari ensee nari daama. Ya meekissaɓa an: - Ɓuwii woꞌu an mi yërí en ɓa? ");
INSERT INTO snf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓa taassa an: - Laakin ɓuwaa woꞌ an fu yërí en Saŋ-Bëtís, ɓíinoo an fu yërí en Ili, ɓíinooɓaa ɓan an fu sëldíigaa mílís hen ee bok ga sëldíiga-Koohcaa waama. ");
INSERT INTO snf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ya meekissaɓa an: - Haa ɗú, ɗú woꞌ an mi yërí en ɓa? Peeꞌ taassa an: - Fu yërí en Kiristaanii Kooh wosɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yéesu ɗíŋngaɓa na woꞌeen ciyëgísíꞌ an ken hanat kiwoꞌ iñaa aaw ga. ");
INSERT INTO snf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Doo ya hanndaɓa kiwoꞌ an: - Kowukii ɓii jomin kikooroh ga mesiklaat ciyewin. Haꞌ-kaancaa, sarahohcaa ɓiyaakɓaa, na jëgíroh-waascaa waaꞌsanndii gari kihot, ya hay kiꞌapu ee besaa wukaahaywaa tíkan ga kikaankaagariɗa, ya hay kimílís. ");
INSERT INTO snf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lëehíꞌta Yéesu woꞌꞌa ɓuwaa ɓéeɓɓa an: - Binaa ɓoꞌ waaꞌ kitaam ga fenooroonaa, ya alat hafci, ya kooruk kuraanaagari besaa en ɓéeɓ, ya taabukkoo. ");
INSERT INTO snf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ndaga ɓaa fu waaꞌ kisom kumuunfunaa fu hayka kiñak bi taaꞌ; wayee ɓaa mi tahhaa kiñak kumuunfunaa, fu hay kipes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ee kilaak iñcii ga ëldúnaɗa tóoh jeriñan ɓoꞌ ya, en lak ya ñak hafcinaa wala ya saŋkuꞌaa? ");
INSERT INTO snf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ndaga ɓaa mi enndaa kaci mi na woꞌeeniigoonaa, fu hay kiꞌen kaci ga Kowukii ɓii bëríinaa ya hayan ga ndamaagari na waa paamci na waa malaakacaa ɓiselaꞌíꞌɓaa. ");
INSERT INTO snf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mi woꞌꞌúuka ee kayoh; ɓiɓoꞌ ga ɓuwii ɓii kaansoo ee ɓa hottii Nguurii Kooh. ");
INSERT INTO snf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ga waa Yéesu woꞌꞌa woꞌeencaama bi tíkka ga iñaa leꞌ bes ciyitnakaahay, ya woꞌꞌa Peeꞌ, Saŋ na Saak ɓa taam nari, ya lappa naɓa ga ɗook jaŋjagaa kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ga daa Yéesu enee na kikíim Koohɗa, fíkíifaagari ennda filiis ee kúltícaagari yaanaawwa ɗer bi caa melic. ");
INSERT INTO snf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ga ɗekataama, laakka ɓoꞌ ɓanak ɓaa meƴ ga ɗuuƴ ndamaa Kooh ee ɓa ɓaa saawal nari: enee Móyíis na Ili. ");
INSERT INTO snf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓa ɓaa saawal nari ga iñaa aaw ga kikaankaagari ƴah kilaak ga Yéerúsaleemɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lak Peeꞌ na ɓuwaa ya taam naɓaɗa ɓaa ga pëní fiyaak. Wayee ga waa ɓa yúudukɗa, ɓa hotta ndamaa Yéesu na ɓuwaa ɓanakɓaa tuuksee nariɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ga wahtaa ɓuwaama enu na kitagohu na Yéesuɗa, Peeꞌ woꞌꞌa Yéesu an: - Jëgírohii, dii newin garuu. Ɗu yípat dii taal kaahay: wíinoo wuufu, wíinoo wuu Móyíis ee wíinoo wuu Ili. Peeꞌ ínohéeríi iñcaa ya woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lak Peeꞌ yaa lís kiwoꞌ fodaama, laakka yaayeelaa hay, úullaɓa. Tëelíbéecaa tíitussa ga waa ɓa en na kiꞌaas ga ɗuuƴ yaayeelaaɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ee ga ɗuuƴ yaayeelaa laakka koonaakaa woꞌ an: - Ɓii yii yërí en Kowukiigoo mi tanukɗa. Súkúrukatti. ");
INSERT INTO snf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ga waa koonaakaa lëehíꞌ kiwoꞌɗa, tëelíbéecaa hotsee Yéesu rek daama. Ɓa ɗekohussa na iñaama, ee ga wahtaama ɓa ɓéestíꞌtii ken iñaa ɓa hoteeɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ga besaa tík gaɗa, Yéesu na tëelíbéecaa yoosukussa ga jaŋjagaa, mbooloo wiyaak hayyari kitëebíluknee. ");
INSERT INTO snf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ga ɗuuƴ mbooloomaa laakka ɓaa en na kifiip an: - Kiyaakii, mi kíimmbaa, malakɗaaroo kowukiigoo ndaga mi laakka doŋ! ");
INSERT INTO snf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Leekleek raɓ ɓúukki, ya aawi kifiip. Rawii saylukohiri, kúuwkaa kúuwi; ya sodalli lool ee ya gaawoori kiꞌíis. ");
INSERT INTO snf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi kíimin tëelíbéeciigaraa ɓa kaal rawii wayee ɓa mínndii. ");
INSERT INTO snf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yéesu taassa an: - Ɗú, ɓuwii wati, ɗú ɓii ɗú laakoo ngëm ee ɗú tumi iñaa joffiiɗa, mi enan narúu bi kera? Mi múuñɗanndúu bi kera? Haydohaa kowukiigaraa dii. ");
INSERT INTO snf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Daa oomaanaa deeyee, rawaa fetallari kakay, yaa saylukohhi didóolíꞌ. Wayee Yéesu gëtta rawaa, wëkíꞌta oomaanaa. Lëehíꞌta ya íkkari paamci. ");
INSERT INTO snf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɓéeɓ ɓuwaa waaruꞌussa ga yaklaataa doolaa Kooh. Ɓuwaa ɓéeɓ waaruꞌussa ga tóoh iñcaa Yéesu tumeeɗa, ya woꞌꞌa tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","- Súkúrukat dijófíꞌ iñii mi ƴahhúu kiwoꞌ yii: Kowukii ɓii hay kitíku ga yah ɓuwii. ");
INSERT INTO snf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wayee ɓa ínohhii iñaa woꞌeenaama waaꞌ kiwoꞌɗa, ndaga woꞌeenaa man na cah gaɓa, bi ɓa mínndii kiꞌínoh iñaa wa waaꞌ kiwoꞌɗa ee ɓa kaañnjiiri kimeekisoh iñaa aaw ga woꞌeenaama. ");
INSERT INTO snf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tëelíbéecaa Yéesu enussa ga kinookoh ga ɗuuƴɓa kiꞌínoh ɓaa wëñ kiyak gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yéesu ínohha iñaa ɓa halaatɗa, ya ɓeɓpa kuꞌoomaa, tuukiꞌtaja ga yahaaci. ");
INSERT INTO snf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lëehíꞌta ya woꞌꞌaɓa an: - Ɓaa fu teꞌ oomaanii yii ga teekiigoonaa, lakanaa fu teꞌꞌoo, mi ga kihaffoo; ee ɓaa fu teꞌꞌoonaa, fu teꞌ ɓaa wossooɗa ɓan; ndaga ɓaa wëñ garúu kijutuut ɓéeɓpúuɗa yërí en yaa wëñ kiyakɗa. ");
INSERT INTO snf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Saŋ ɓeɓpa woꞌeenaa, woꞌꞌa an: - Kiyaakii, ɗí hotin ɓaa enee na kikaal raɓ ga ɓuwii ga teekiigaraa ee ɗí waaꞌtarika kihoonoh ndaga ya bokkii garuu. ");
INSERT INTO snf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yéesu loffari an: - Kaa hoonohattika, ndaga ɓaa lebirohhii naruunaa, faꞌ naruu. ");
INSERT INTO snf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ga waa wahtaa Yéesu jomee kikolkoh ëldúna, ya lap ɗook-Kooh leꞌꞌa, ya tuukka tek ga kikaꞌ Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ya wossa ɓiɓoꞌ ɓa ɗëwírukki. Ga waa ɓuwaa karussa, ɓa aassa dëk-kaw ga gohaa Samaríi, kiheeliꞌ Yéesu ga daa ya dalan. ");
INSERT INTO snf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wayee ɓu-dëkaa sagussa Yéesu aas da, ndaga ya aawee Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Daa tëelíbéecaa Yéesu, Saak na Saŋ hotee iñaama ɓa woꞌꞌa an: - Haꞌmudii, fu waarin ɗí nak kiwii, ka yoosuk asamaan, ka ɗúbíꞌɓane? ");
INSERT INTO snf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wayee Yéesu mëeñsukka gaɓa, yaa ñaꞌɓa. ");
INSERT INTO snf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lëehíꞌta ɓa ɓaa ƴah dëk-kaw wiliis. ");
INSERT INTO snf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yéesu na tëelíbéecaagari ensee ga waas, laakka ɓaa woꞌꞌi an: - Daa fu ƴah tóoh, mi hayyaa kitaabuk. ");
INSERT INTO snf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yéesu woꞌꞌari an: - Tílcii laakuunun ɗúl ee selcii ga asamaanɗa laakuunun taal, wayee Kowukii ɓii laakoo daa ka leeman hafiigari. ");
INSERT INTO snf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yéesu woꞌꞌa ɓoꞌ yiliis an: - Taabukaaroo. Yaama taassari an: - Haꞌmudii, onaaroo paaƴ mi acnee paammboo. ");
INSERT INTO snf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wayee Yéesu woꞌꞌari an: - Íisaa ɓuwaa kaaninɗa ɓa ac ɓuwaagaɓa kaanɗa, ee fu, tíida fu yéegalohnee Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɓoꞌ yiliis woꞌissari an: - Haꞌmudii, mi hayyaa kitaabuk, wayee onaaroo paaƴ mi taŋkohnee na ɓu-kaanndoo. ");
INSERT INTO snf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yéesu loffari an: - Ɓaa en na kilín, am mësíin, heeluki fenoocinaa, ɓaa yaama mínoo kilëgëy ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ga waa iñaama paaffa, Yéesu tannda ɓoꞌ ɓidaaŋkaah-yitnaɓanak na ɓanak ɓiliis ee ya wossaɓa ɓanak ɓanak, ɓa kuliyukki ga teerucaa ɓéeɓca na ɗekatcaa ya jomee kikaꞌ na kihafciɗa tóohca. ");
INSERT INTO snf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ya woꞌꞌaɓa an: - Píikii yewinin ee píikohcii caakussii. Kon, kíimat haꞌ-píikii ya ɓaat kiwosoh ɓilëgëyoh ga píikiigari. ");
INSERT INTO snf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tíidat! Mi yii wossúu fodii tupeꞌ ga ɗuuƴ ɓigumuu. ");
INSERT INTO snf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kaa ɓaydohat kopaꞌ, hëmbu wala ñafaꞌ ee kikëñɗoh hanattúu kifaan ga waas. ");
INSERT INTO snf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kaanfaa ɗú mín kiꞌaas ɓéeɓ, këñɗohat paaƴ an: «Jam namohat narúu!». ");
INSERT INTO snf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Binaa ɓoꞌ jam en daamanaa, jamaa ɗú kíimiꞌtiɗa hay kiyoosuk gari; ee ɓoꞌ jam enndii danaa, jamaa aaw garúu. ");
INSERT INTO snf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yugat ga kaanfaa faama, ɗú ñami ɗú ani iñcaa ɗú eꞌsanɗa ndaga lëgëyohaa en ɓéeɓ jomin kifayu. Kaa taabat kaan na kaan. ");
INSERT INTO snf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Teeraa ɗú aasoh ɓéeɓ ee ɓuwaa tookussúu danaa, ñamat iñcaa ɗú teeɓsanɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wëkírat ɗúukoolíꞌcaa enu ga teeraamaɗa, ɗú woꞌ ɓu-dëkaa an: «*Nguurii Kooh deeyinndúu». ");
INSERT INTO snf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wayee teeraa ɗú aasoh ee ɗú tookussii danaa, meyat ga mbedicaa ɗú woꞌ an: ");
INSERT INTO snf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Ɗí ɓii përtuk sah kiꞌíkkúu pëndëlii dëkiigarúu ñaak ga kotciigaríiɗa, wayee ínohat gaka an Nguurii Kooh deeyinndúu.» ");
INSERT INTO snf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lëehíꞌta Yéesu tíkka ga an: Mi woꞌꞌúuka, besaa ƴah kiꞌattiꞌohuɗa leꞌaa, ɓu-Sodom ɓërí taniꞌan ɓu-dëkaa waama. ");
INSERT INTO snf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","- Massa ɗú, ɓu-Korasee! Massa ɗú, ɓu-Betsaydaa! Ndaga kíntaancii tumsee ga ɗuuƴcúuɗa tumsee ga ɗuuƴ dëkaa Tíiꞌ na waa Sídoŋaa eneenaa kumëeñíꞌ ɓa ekukin saaku, ɓa yuŋ ga wet kiteewoh an ɓa récukin baakaaꞌciigaɓa. ");
INSERT INTO snf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kërí tah besaa attiꞌohsanɗa leꞌaa, ɓu-Tíiꞌ na ɓu-Sídoŋ ɓërí taniꞌanndúu attiꞌ. ");
INSERT INTO snf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɗú, ɓu-Kafarnawom, ɗú yaakaaꞌ an ɗú hay kiɓëwíru bi ga ɗook-Koohe? Óꞌóo, ɗú ƴah kiyóoskíɗu bi ga ɓu-baam. ");
INSERT INTO snf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ya woꞌissa tëelíbéecaagari an: - Ɓaa súkúrukkúunaa lak súkúrukkoo ee ɓaa saŋngúu kiteꞌaa lakanaa saŋngoo kiteꞌ. Ee ɓaa saŋngoo kiteꞌaa lakanaa saŋ kiteꞌ ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tëelíbéecaa ɓidaaŋkaah-yitnaɓanak na ɓanakɓaa ɓoƴkussa lak keeñɓa soosin seɓ, ɓa woꞌꞌa an: - Haꞌmudii, ga teekiigaraa, bi ga raɓcaa tookɗuununndíi! ");
INSERT INTO snf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yéesu woꞌꞌaɓa an: - Mi hotee ga Seytaani ga waa ya ɗëegískoh ɗook en fan melicɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Malkat! Mi oninndúu dooli kikooꞌ ga ɗook goŋcii na dagalcii, na kinapañsoh dooli Seytaani ee dara mínoo yen garúu. ");
INSERT INTO snf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ga iñaama kaa neɓlukat ga dii raɓcii tookɗuununndúuɗa wayee neɓlukat ga dii teekciigarúu bíduunun ga ɗook-Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ga saasi, ga tumeenaa Helaa yiselaꞌíꞌyaa, Yéesu líiffa na keeñ wisóosíꞌ, ya ndammba Kooh Paamci an: - Buba, Haꞌmudii ɗook na kakay, mi yii gërëmmbaa ga dii fu teewin ɓuwii ínohsoo daraɗa iñaa fu ɗaak haꞌ-hamhamcii na ɓuwii jaginɗa. Ee, Buba, iñaama laakohɗa ndaga neɓpaa hen fu waaꞌtaka. ");
INSERT INTO snf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Paammboo erinndoo iñaa en ɓéeɓ. Ken ínohoo Kowukii enndii Paamudiinaa; ee ken ínohoo Paamudii enndii Kowukii na ɓuwaa Kowukii waaꞌɓari kiteewaa. ");
INSERT INTO snf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lëehíꞌta ya mëeñsukka ga tëelíbéecaagari ya woꞌꞌaɓa haŋɓa doŋ an: - Ɓa yewinin múuꞌ ɓuwii hasciigaɓa hot iñcii ɗú hotɗa, ");
INSERT INTO snf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ndaga mi woꞌꞌúu man sëldíiga-Kooh na buuꞌ ɓiyewin waaruunun kihot iñcii ɗú hotɗa na kikeloh iñcii ɗú kelohɗa wayee ɓa hottiica ee ɓa kelohhiica. ");
INSERT INTO snf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laakka jëgíroh-waas yaa waaree kimalaksukoh Yéesu, ya kolukka, meekissari an: - Jëgírohii, iñii yiida mi jom kitum bi mi laas ɓakkoo ga kipeskaa leehoo taaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yéesu loffari an: - Iñii yiida bídu ga Waasiiruu? Fu am ya ga iñaa fu jaŋ gaɗa? ");
INSERT INTO snf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɓaa taassa an: - Fu waaran Haꞌmudii Koohyiigaraa, na keeñaagaraa tóoh na kipeskaagaraa tóoh na doolaagaraa tóoh na helaagaraa tóoh ee ɓan fu waaran mooroomfu fodaa daa fu waaꞌ haffuɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yéesu woꞌꞌari nak an: - Ee, iñum fu taasɗa júwin. Tumaa iñaama, fu pes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wayee jëgíroh-waasaa waaree kilaak kayoh, ya dalla kimeekis Yéesu an: - Ɓii yiida en mooroommboo? ");
INSERT INTO snf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Daama Yéesu loffari an: - Laakee ƴaalaa meyohee teeraa Yéerúsaleem, yaa ƴah teeraa Yéríkóo. Ya hídukohha ga ɓigúroh-waas. Ɓa teꞌꞌa iñaa ya ɓayeeɗa tóoh, ɓa feekkari bi yaa ƴah kikaan, ɓa foñnjari ɗa, ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Laakka sarahohaa kooroh waasaama. Daa ya hotee ɓaa, ya ɗeeŋnga diꞌúsaayíꞌ, yaa ƴah kotci. ");
INSERT INTO snf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Laakka ɓan ɓoꞌ, ee iñaa Léwít, leꞌꞌa daama. Daa ya hotee ɓaa, ya ɗeeŋnga diꞌúsaayíꞌ, yaa ƴah kotci. ");
INSERT INTO snf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wayee laakka ɓaa dëk kúlkaa Samaríi, yaa enee ga waas kiɓaaɓ, ya hayya bi ga yahaa ɓaa, ya laakka yërmaandi wiyaak gari, ga waa ya hottiɗa. ");
INSERT INTO snf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ya ɓaatta kideeƴ ga ɓaa, tummba dúuleen na biiñ ga gaañcaa, ya múullaca. Ya tíkkari ga baamaagari ya lapeeɗa, ɓayyari ga ɗekataa sagac daliɗa ee ya toputuꞌꞌari dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ga kooh-wíisfaa, ya meƴdohha hëelís denariyon kanak, eꞌta haꞌ-ɗekataa, woꞌꞌari an: - Mi yii ƴah ee toputuꞌaari dijófíꞌ. Binaa fu tum gari iñaa wëñɗanaa, mi yërí ƴahhaawa kiꞌík mi ɓoƴkoh diinaa. ");
INSERT INTO snf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yéesu meekissa jëgíroh-waasaa an: - Ga ɓuwaa ɓaahayɓaa ɓaama, yiida gaɓa teewoh kiꞌen mooroom ɓaa gúroh-waascaa feekeeɗa? ");
INSERT INTO snf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jëgíroh-waasaa taassa an: - Yaa teewoh kilaak yërmaandi gariɗa, yërí. Yéesu nak woꞌꞌari an: - Tíida, ee fu ɓan, tumaa fodaama. ");
INSERT INTO snf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lak Yéesu yaa ga waas na tëelíbéecaagari, ya aassa dëk-kaw. Daama, laakka ɓetifaa teeku Marta, ɓayya Yéesu kaanci. ");
INSERT INTO snf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta laakeera këmëeŋkímun, yaa teeku Mërí. Yaama yugee ga kotcaa Haꞌmudii, yaa súkúruk jëgírohaagari. ");
INSERT INTO snf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta nak, lak lëgëycaa ɗuuƴ waañaa hëpin gari, ya hayya ga Yéesu, woꞌꞌari an: - Haꞌmudii, dii Mërí foñnjoo na lëgëyii tóohɗa, enndiiraa darane? Woꞌaari kay ya amɗohhoo! ");
INSERT INTO snf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Haꞌmudii taassari an: - Wari fu ɓan Marta, fu ɓítukin lool ga enaama ciyewin. ");
INSERT INTO snf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wayee yen yíinoo doŋ yërí laak solu. Mërí tanukin ɓakaa gënɗa ee ken teꞌoowa gari. ");
INSERT INTO snf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Laakka bes, Yéesu enee na kikíim Kooh ga ɗekat. Ga waa ya lëehíꞌta, yíinoo ga tëelíbéecaagari woꞌꞌari an: - Haꞌmudii, yëedíraaríi kikíim Kooh fodaa Saŋ yëedíreeka tëelíbéecaagariɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yéesu woꞌꞌaɓa an: - Binaa ɗú en na kikíimaa, woꞌat anee: «Buba, ɓéeɓ ínohat kiselaꞌkii teekiigaraa; Nguuriigaraa leꞌat dii. ");
INSERT INTO snf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Onaaríi besaa en ɓéeɓ iñaa ɗí jom kiñamɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bayalaaríi baakaaꞌciigaríi, ndaga ɗí, ga kihaffíi, ɗí bayalin ɓuwaa tooñnjíiɗa. Ee kaa íissíi ɗí keen ga fíꞌ Seytaani.» ");
INSERT INTO snf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yéesu woꞌissaɓa an: - Enee an yíinoo garúu laak fiiliimun, ya kaꞌ gari ga leeloo wek kiwoꞌꞌi an: «Fiilii, lúudaaroo mbúurú kaahay. ");
INSERT INTO snf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Laak fiiliiroo yíinoo yaa hay kiɓaaɓ ga kaanndoo ee mi laakoo dara iñaa mi eranndi.» ");
INSERT INTO snf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ee yaama taassi ga ɗuuƴ túuyaagari an: «Kaa tangalloo! Diima deŋ ɗí tëckin ee mi na ɓu-kaanndoo ɗí faanukin. Mi mínissii kikoluk kiꞌeꞌtaa mbúurú.» ");
INSERT INTO snf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mi woꞌꞌúu man, luu enee an ya kolukkii eꞌti mbúurú ndaga daa ɓa en ɓifíiliimunɗa, ennaa ya hay kikoluk eꞌti iñaa ya soolukɗa tóoh ndaga daa yaama ɗuucuk ga kikíimkaaɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mi nak, mi woꞌꞌúu an: kíimat, Kooh hayyúu kiꞌon. Heelat, ɗú hay kihot. Fëekírat, ɗú hay kilëgísɗu. ");
INSERT INTO snf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","En kiꞌenaa, ɓaa kíim ɓéeɓ, onu; ɓaa heel ɓéeɓ, hot; ee ɓaa fëekíꞌ ɓéeɓ, hay kilëgísɗu. ");
INSERT INTO snf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Paamudii yiida garúu eran kowuci goŋ binaa ka kíimmbi jënaa? ");
INSERT INTO snf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wala ya eꞌka dagal binaa ka kíimmbi wakaa? ");
INSERT INTO snf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kon ga dii ɗú hín kibonɗa, en lak ɗú ɓërí mín kiꞌon towutaagarúu enaama cijófíraa, wëñaa ga Paamudii ga ɗookɗa. Ɓuwaa kíimmbi Helaa yiselaꞌíꞌyaaɗa, ya onooɓayane? ");
INSERT INTO snf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Laakka bes, Yéesu enee na kimeƴdoh ga ɓoꞌ rawaa luuɓlukohhi. Daa rawaa meyee, luuwaa aawwa kiwoꞌ ee ɓuwaa waaruꞌussa. ");
INSERT INTO snf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wayee laakka gaɓa ɓuwaa woꞌ an: - Belsebul, buurii raɓcii, yërí onndi dooli kikaal raɓcii ga ɓuwii. ");
INSERT INTO snf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Laakka ɓoꞌ ɓiliis ɓaa waareeri kimalaksukoh. Ɓa meekissari ya tumiꞌɓa kíntaanaa teewoh an ya meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wayee Yéesu ínohha halaatcaagaɓa ya woꞌꞌaɓa an: - Kúlkaa hëgískoh ga ɗuuƴka ɓéeɓ, aaw ga kifaay. Túuƴcaa ɓúꞌsukoh waa en ɓéeɓ ga ɗook mooroomci. ");
INSERT INTO snf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kon binaa Seytaani hëgískoh ga ɗuuƴcinaa, nguuraagari tuman na bi wa lísi kituuk? Ndaga ɗú woꞌ an Belsebul yërí onndoo dooli kikaal raɓ ga ɓuwii. ");
INSERT INTO snf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","En lak an mi, Belsebul yërí onndoo dooli kikaal rawaa, haa ɓii on ɓuwiigarúu dooli kikaal raɓ ɓa? Kon ɓuwumgarúu, ga kihafɓa, ɓërí attiꞌanndúu. ");
INSERT INTO snf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","En kiꞌenaa, en an mi kaali raɓcii na doolii Koohaa, kon Nguurii Kooh leꞌin bi garúu. ");
INSERT INTO snf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Binaa ɓaa laakin dooli ee ɓayin ganaay watuk kaancinaa, lak alalaagari ɓéeɓ lewin. ");
INSERT INTO snf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wayee ɓaa wëñnji kilaak dooli hayaa, sooŋngi, mínndi, teꞌ ganaaycaa ya yaakaaꞌlukeeɗa tóoh, waroh iñcaa ya ɓewoh gariɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɓaa faꞌtii naroonaa, heñoh naroo; ee ɓaa nëgírohhii naroonaa, yii tasarsoh. ");
INSERT INTO snf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","- Binaa raɓ meyoh ga ɓoꞌaa, ya túuti ga ëgíraa, ya heeli daa ya íikarukan, wayee waa ya hottii daa ya aasan, ya woꞌ ga helci an: «Mi naman kiɓoyuk kaanfaagoo mi meyoheeɗa.» ");
INSERT INTO snf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Binaa ya leꞌ danaa nak ya laak kaanfaa paruunun bi setin, hëwíruunun bi jekin. ");
INSERT INTO snf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Fodaama ya ƴee kikooꞌnee raɓ ɓiyitnaɓanak ɓiliis ɓaa wëñnji kisoot; ɓa aas ga kaanfaa, ɓa dëk ga. Faf ɓaa yaama, ga daa ya madee kuɗewaaɗa, wëñisɗa kiyiis. ");
INSERT INTO snf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laak Yéesu yaa woꞌ fodaama, laakka ga ɗuuƴ mbooloomaa ɓetifaa woꞌ ga ɗook an: - Ɓetifaa ɓayeeraa ga lookaagari, ɓëpíꞌtaraa ga ɓíiɓcaagariɗa yewinin múuꞌ! ");
INSERT INTO snf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wayee Yéesu taassari an: - Woꞌaa kay an ɓuwaa súkúruki woꞌeenaa Kooh ee ɓa taabukiwaɗa, ɓërí yewin múuꞌ! ");
INSERT INTO snf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lak ɓoꞌ ɓiyewin nëgírukohuunun ga yahaa Yéesu, ya aawwa kiwoꞌ an: - Ɓuwii jamaanii wati, ɓiɓoꞌ ɓibóníꞌ. Ɓa waaꞌ kihot kíntaan, wayee kíntaan wíinoo tookɗusanndiiɓa, enndii waa Sonaasaa. ");
INSERT INTO snf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ndaga fodaa daa Sonaas enee mandarga ga ɓu-Nínífɗa, fodaama ɓan Kowukii ɓii ƴah mandarga ga ɓuwii wati. ");
INSERT INTO snf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Besaa attiꞌohsanɗa leꞌ bëríinaa, buuraa yiɓetiyaa kúlkoh iñaa hanoh meyaaꞌ-noh ñaamɗa hay kituuk ga fíkíi ɓuwii jamaanii wati, ya ɓúlɓa. Ndaga ya meyohee gohcaa ëldúna wëñ kiꞌúsaayɗa kisúkúruknee woꞌeencaa buuꞌ Salomon líif na hamhamɗa. Ee malkat, laakin dii ɓaa wëñ Salomon! ");
INSERT INTO snf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Besaa attiꞌohsanɗa leꞌ bëríinaa, ɓu-teeraa Níníf hay kituuku ga fíkíi ɓuwii jamaanii wati, ɓa ɓúlɓa ndaga ɓu-Níníf súpítseera kipeskaagaɓa ga waa ɓa keloh jangataa Sonaasɗa; ee malkat laakin dii ɓaa wëñ Sonaas. ");
INSERT INTO snf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yéesu liiwukka anee: - Ken taaloo lampu, faanwa ga daa ɗaakukin, wala líꞌ kanu ga ɗookgaa, wayee fu líkanwa ga ɗook doonaa ɓuwaa aasɗa hotu leeꞌlaataa. ");
INSERT INTO snf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kuhaskiigaraa kërí en lampii faanfiigaraa. Binaa dara enndii na kuhasfunaa, faanfaagaraa tóohfa eni ga leeꞌlaat. Wayee binaa kuhasfu wakkiinaa, faanfaagaraa eni ga ñúus ɓan. ");
INSERT INTO snf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kon watukaa leeꞌlaatum en ga ɗuuƴfuɗa, wa ñúusíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kon binaa faanfu tóohfa en ga leeꞌlaat ee laakkii ɓak wíinoo waa en ga ñúusaa, ɓéeɓfa ƴah kiꞌen ga leeꞌlaat, man na fodaa daa lampu léeꞌɗíraa lañɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ga waa Yéesu woꞌꞌa bi lëehíꞌta, laakka Fërísiyeegaa ɓayyi kicuunohuk ga kaanci. Yéesu aassa, yuŋnga kiñam. ");
INSERT INTO snf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fërísiyeegaa waaruꞌꞌa ga waa ya hot Yéesu yuŋnga kiñam ee tísukkii paaƴɗa. ");
INSERT INTO snf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wayee Yéesu Haꞌmudii woꞌꞌari an: - Ɗú, Fërísiyeeŋcii, ɗú man anee, ɗú tísi bi ga bíiŋcaa kaascii na tanutii, wayee ɗuuƴcúu líif na halaat kilok na halaat cibóníꞌ. ");
INSERT INTO snf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɗú ɓërí lohoƴ hel! Kooh yaa hëwíꞌ iñaa hanoh foohɗa, enndii ya hëwíꞌ iñaa hanoh ɗuuƴɗa ɓane? ");
INSERT INTO snf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sarahohat iñaa en ga keeñnjúuɗa, en ɗanaa iñaa en ɓéeɓ hay garúu kiset. ");
INSERT INTO snf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Massa ɗú, Fërísiyeeŋcii! Ɗú tumi sah sarah fodii ɓakaa wudaaŋkaahwaa ga naana na nduuꞌ, ee ɓan ga iñcii tóoh línsi ga dëꞌɗa, wayee ɗu saganohin kijúɓ na kiwaaꞌ Kooh: iñiima yërí ɗú jomee kitum ee iñcaa cíinoo hanat kisaganohu. ");
INSERT INTO snf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Massa ɗú, Fërísiyeeŋcii! Ndaga ɗú waari kiyuŋ ga fíkíi ga ɗuuƴ jaangu-yaawúuꞌcaa ee ɗú waari kikëñɗu yah kanak ga paancaa. ");
INSERT INTO snf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Massa ɗú! Ndaga ɗú man na loyaa ken tummbii mandarga ga, ɓuwaa tíinsi ga ɗook gaa, ee ínohsoo gaka bi tahɓa kilíiɓ ga fíkíi Kooh! ");
INSERT INTO snf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Laakka jëgíroh-waas yíinoo yaa woꞌꞌi an: - Jëgírohii, binaa fu woꞌ ɗanaa, fu ɓassíi ɓan! ");
INSERT INTO snf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yéesu loffari an: - Massa ɗú, jëgíroh-waascii! Ɗú ɓan, ɗú koori ɓuwii ɗofcaa ɓa hatinoo, ee ɗú tookoo jokonndúu jíinoo leꞌ ga. ");
INSERT INTO snf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Massa ɗú! Ɗú hayaa ɗú móꞌɗi loycii sëldíiga-Koohcii, ee ɓipaammbúu apeeɓa. ");
INSERT INTO snf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fodaama ɗú teewohin an ɗú taabin ga iñcaa ɓicaasammbúu tumeeɗa, ndaga ɓa apin sëldíiga-Koohcaa, ee ɗú ɓii móríꞌ loyciigaɓa! ");
INSERT INTO snf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kërí tah Kooh ga hamhamaagari, woꞌꞌa an: «Mi hay gaɓa kiwosoh ɓisëldíiga-Kooh na ɓiyéegaloh; ɓa hay kiꞌap ɓíinoo, ɓa hatal ɓíinooɓaa ga kipesɓa.» ");
INSERT INTO snf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iñaama yërí tahan bi ñífaa sëldíiga-Koohcaa ɓéeɓ aamsee ga waa ëldúna saku bi watiɗa hay kikípuk ga hafcii ɓuwii wati, ");
INSERT INTO snf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","aboh ga ñífaa Abeel bi ga ñífaa Sakarí yaa apsee ga díkaanti daa sarahcaa tëkíꞌsiɗa na ɗekataa wiselaꞌíꞌwaa. Ee mi yërí woꞌꞌúuka, iñaa laakee yaama hay kikípuk ga hafcii ɓuwii wati! ");
INSERT INTO snf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Massa ɗú, jëgíroh-waascii, ɗú nísin kucëwíikaa lëgísi halaa tahi ɓoꞌ kiꞌínohɗa: ɗú, ga kihaffúu, ɗú aasoo ee ɓaa waaꞌ kiꞌaas ɓéeɓ ɗú kokohhi. ");
INSERT INTO snf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ga waa Yéesu meyoh daamaɗa, jëgíroh-waascaa na Fërísiyeeŋcaa ɓaa tamoh ga ɗookci ee ɓa ɓaa meekissi iñaa en tóoh: ");
INSERT INTO snf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ɓa ɓaa heelli kifíꞌ doonaa ya ëldoh bi ɓa balaɓ yen ga woꞌeenaagari. ");
INSERT INTO snf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lak waama, ɓuwaa nëgírukohsee iñaa leꞌin ɓoꞌ ɓijúnni ciyewin bi ɓíinoo ɓaa toŋ ga ɓimooroomɓa. Yéesu woꞌꞌa paaƴ na tëelíbéecaagari an: - Abukat ga jíkii Fërísiyeeŋcii en kijófjófɗuk en fan kuuncaa kaañohinɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Laakkii iñaa mín kiɗaakuk bi hotukoo ee laakkii iñaa ɓoꞌ mín kiɗaak bi meƴdohsoo faŋ. ");
INSERT INTO snf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kërí tah iñaa ɗú mín kiwoꞌ na wek ɓéeɓ, hay kikelohuk ga noh taŋ, ee iñaa ɗú mín kimëedíroh ga ɗuuƴ túuyaa ɗaakukin ɓéeɓ, hay kiyéegalohu ga leeloo paancaa. ");
INSERT INTO snf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yéesu woꞌissa an: - Mi woꞌ narúu, ɗú ɓii ɗú en fiiliimunciigooɗa: kaa niikat ɓuwii api faanfii ee paaf iñaamanaa, ɓa mínsoo kitumis dara yiliis. ");
INSERT INTO snf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi hayyúu kiwoꞌ ɓaa ɗú jom kiniikɗa: niikat ɓaa wëeꞌtaa ga an yii, ap bi lëehíraa, mín kijaf ga safara. Ee, mi woꞌꞌúuka ɓaa yaama yërí ɗú jom kiniik! ");
INSERT INTO snf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Tudiindiiꞌ tiyëtúus toonohsirii dërëm kanake? Moona déy, Kooh alukkii jíinoo gata. ");
INSERT INTO snf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bi ga fenfii ga hafciigarúuɗa sah, tóohfa kíduunun. Kon kaa niikat dara, ndaga ɗú wëñ solu tóoh diindiiꞌcii. ");
INSERT INTO snf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yéesu tíkka ga an: - Mi woꞌꞌúuka: ɓéeɓ ɓaa fu tookkoo ga fíkíi ɓuwiinaa, mi Kowukii ɓii, mi hayyaa kitook ga fíkíi malaakacaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wayee ɓaa fu taasukkoonaa, fu hay kitaasku ga fíkíi malaakacaa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɓéeɓ ɓaa fu woꞌ iñaa moroo ga Kowukii ɓiinaa, fu hay kibayalu, wayee ɓaa fu ɓas Helaa yiselaꞌíꞌyaa ɓéeɓ, fu bayalsooka. ");
INSERT INTO snf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Binaa ɗú ɓayu kiꞌattiꞌu ga jaangu-yaawúuꞌcaa wala ga fíkíi attiꞌohcaa na ga fíkíi ɓuwaa kuliyuki ga nguuraaɗanaa, helciigarúu dalat ga daa ɗú taasan ga iñaa ɗú yabuɗa na iñaa ɗú woꞌanɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ndaga Helaa yiselaꞌíꞌyaa, ga wahtaama, hay kiꞌek garúu iñaa ɗú joman kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Laakka ga mbooloomaa ɓaa woꞌ Yéesu an: - Jëgírohii, woꞌaa yaakkoo ya waroh naroo iñaa ɗí lamɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yéesu taassari an: - Moo ƴaalii yii, ɓii yiida falloo kiꞌattiꞌꞌúu wala kiwarohhúu alalaagarúu? ");
INSERT INTO snf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lëehíꞌta ya woꞌꞌa ɓuwaa an: - Watukat ee abukat ga kiwaaꞌ kilaak, ndaga kilaak alal ɓayyii kipes ɓoꞌ luu alalaa yewin yewin. ");
INSERT INTO snf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ya woꞌꞌaɓa kon liiwukii wii: - Enee ɓoꞌ yaa laakin alal, ya laakka yoon ee yooncaa laaɓpa lool. ");
INSERT INTO snf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ya yaa halaat ga helaagari an: «Mi tuman na ee mi laakoo daa mi ɗapan iñcii mi píikɗa?» ");
INSERT INTO snf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lëehíꞌta ya woꞌꞌa an: «Iñii yii yërí mi tuman: mi ɓúran dapciigoo henaa, mi tawah ciliis, caa wëñ kiyak, en ɗanaa mi nëgíroh tohootiigoo ga tóoh na iñcii mi laakɗa tóohca. ");
INSERT INTO snf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lëehíraa, mi woꞌ haffoo an: Mbëꞌ, fu laakin alal wiyewin waa míninndaa kiɓay tíkíis tiyewin. Íikaraa faanfiigaraa, fu ñami, fu ani, fu mbúumbaayuki.» ");
INSERT INTO snf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wayee Kooh woꞌꞌari an: «Fu yërí lohoƴ hel! Ga wekii wati sah sah kipesfu hay kileeh. Kon iñcii fu waayukɗee haffuɗa tóohca, ɓii ƴahca kilaak ɓa?» ");
INSERT INTO snf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yéesu tíkka ga an: - Iñaama yërí dalan ɓaa fu nëgírohiꞌ haffu alal ee Kooh hottii kilaak-alalfu. ");
INSERT INTO snf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Lëehíꞌta Yéesu woꞌꞌa tëelíbéecaagari an: - Iñaama tah mi woꞌꞌúu an: Kaa halaatat ga ñamahaa ɗú laakan sooli ga kipesohɗa wala yëerícaa ɗú laak sooli kiꞌekuk ga faanndúuɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndaga kipes kërí wëñ kilaak solu ñamah ee faan fërí wëñ kilaak solu yëerí. ");
INSERT INTO snf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Malkat ga hëekërúucii, ɓa sokoo, ɓa píikoo, ɓa laakoo dap-kaan, ɓa laakoo dap fenoo kaan wayee Kooh yaa ñëmíꞌɓa. Ee ɗú wëñ selii solu fúuf! ");
INSERT INTO snf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɓii yiida garúu mín kiɓaat iñaa hín na siñdaa jokon ga kipesci bi ya ɓítuki ga coonucaagari? ");
INSERT INTO snf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","En lakanaa iñaama doŋ ɗú mínoo kitum dara ganaa, ɗú ƴah ya kihalaat ga iñcaa cíinoo? ");
INSERT INTO snf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Malkat ga pëegíi-nduhumfii fimóríꞌfii ga ëgíriiɗa: fa lëgëyoo ee fa foliloo. Wayee mi woꞌꞌúuka, bi ga buuꞌ Salomon na alalaagari tóoh ekukkii kúltícaa hín kimoꞌ na wíinoo ga pëegíi nduhumcii. ");
INSERT INTO snf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","En lakanaa Kooh yërí móríꞌ fodaama pëegíi-nduhumfii fimóríꞌfii ga ëgírii wati, ee kuwisaa fa ƴah kijafu ga kiwii doŋɗanaa, wëñaa ga, ɗú ga kihaffúu, ya ekoorúu bi jofe? Ngëmiigarúu daal dooyyii! ");
INSERT INTO snf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kaa halaatat rek ga kiheel iñaa ɗú ñaman na iñaa ɗú anan. ");
INSERT INTO snf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Iñciima tóohca ɓuwii ga ëldúna ee ínohsoo Koohɗa ɓërí tumi lëgëy kiheelca, wayee ɗú, Paammbúu yii ga ɗookɗa ínohin an ɗú laakin sooli ga. ");
INSERT INTO snf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Namat kiheel Nguuraa Kooh, iñaa tes ɗú laak sooli gaɗa, Kooh hayyúuri kiꞌeꞌ. ");
INSERT INTO snf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yéesu woꞌissa an: - Ɗú, yopiigoo wiƴínwii, kaa niikat ndaga newin Paammbúu ya bokdohhúu ga Nguuraagari . ");
INSERT INTO snf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Toonat iñum ɗú laakɗa, ɗú erohwa sarah. Heelɗat haffúu nafaꞌcaa magatoo, alalaa leehoo taaꞌ ga ɗook-Kooh: daama lok mínoo gaca kilaas ee maasoh mínooca kiyasoh. ");
INSERT INTO snf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ndaga daa alallúu enoh ɓéeɓ, keeñnjúu waa da ɓan. ");
INSERT INTO snf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yéesu tíkíssa ga an: - Pëkírukat bi yëgís ɗíŋ, ɗú taal lampucumgarúu, ɗú seki. ");
INSERT INTO snf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ee madat na súrgacaa en na kiseku haꞌ-kaanɓa, yaa ƴah kimeyoh cikílook, bi ɓa mínndi kilëgísiꞌ, ya leꞌi ee fëekíri halaanaa. ");
INSERT INTO snf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɓa yewinin múuꞌ súrgacaama, binaa haꞌ-kaanfaagaɓa hayaa, laakanɓa lak ɓaa lís kineeh kimalak! Mi woꞌꞌúuka ee kayoh; ya hay kipëkíruk, ya yugiꞌɓa kiñam ee ya taam gaɓa ya noriꞌɓa ɓa ñam. ");
INSERT INTO snf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Luu ya hayee ga leeloo wek wala iñaa paafɗa sah, binaa ya laakɓa lak neehussii ɓéeɓ, ɓa yewinin múuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ínohat iñii yii bi jof: binaa haꞌ-kaan ínohee wahtaa lokaa hayanɗanaa, eneenaa ya hay kiwatuk ee íisoo kaanfaagari fa pooku. ");
INSERT INTO snf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɗú ɓan, waayukat, ndaga Kowukii ɓii hayan ga wahtaa ɗú fooganndii. ");
INSERT INTO snf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peeꞌ dalla kimeekis Yéesu an: - Haꞌmudii, fu woꞌ naríi ga liiwukumanoo, fu woꞌ na ɓuwii ɓéeɓɓa ɓan? ");
INSERT INTO snf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Haꞌmudii taassari an: - Kon ɓii yiida yërí en súrgaa tookɗin haꞌ-kaanci ee teeyin? Yërí en yaa haꞌ-kaanci tíkan ga fíkíi súrgacaagari, doo ya eꞌɓa yaa en ɓéeɓ iñaa ya jom kiñamɗa, binaa wahtaa leꞌaa. ");
INSERT INTO snf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ya yewinin múuꞌ, súrgaama, binaa haꞌ-kaadaagari ɓoyuk, laakki ga lëgëyaamanaa. ");
INSERT INTO snf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mi woꞌꞌúuka ee kayoh; haꞌ-kaanci hayyi kitík ga ɗook iñcaa ya laakɗa tóoh. ");
INSERT INTO snf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wayee binaa súrgaama woꞌ ga helaagari an: «Haꞌ-kaanndoo kolukkii kihay», bi tah ya en ga kifeek súrgacaa ɓiƴaalɓaa na ɓiɓetiɓaa, ya en ga kiñam na kiꞌan na kilaal rek, ");
INSERT INTO snf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","haꞌ-kaadaa súrgaama hay kihay ga besaa ya fooganndii na wahtaa ya ínohanndii: ya hayyi kifeek dooꞌ ciméeskíꞌ, ya waꞌti iñaa sek ɓuwaa saŋ kigëmu Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Súrgaa ínohin iñaa haꞌ-kaanci waaꞌɗa ee ya saŋ kipariꞌ, ya tum iñaa ya nakuɗanaa, ya hay kirípu ngeeꞌ ciyewin. ");
INSERT INTO snf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wayee súrgaa ínohoo iñaa haꞌ-kaanci waaꞌɗa ee tumi iñaa tahanndi kifeeku, yaama súrga feeksan ngeeꞌ cijutuut. Ɓaa onu yewin ɓéeɓ hay kimeekisohu yewin, ee ɓaa eru kiɗaak iñaa yewinin ɓéeɓ hay kimeekisohu iñaa yewinin. ");
INSERT INTO snf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yéesu tíkka ga an: - Kiwii kërí mi hayee kihaydoh ga ëldúna, ee dii mi waaree ka am kimëeñíꞌɗa! ");
INSERT INTO snf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wayee mi jomin kiñooduk ga mesiklaat, ee ka ɓítinndoo moos bi ga daa iñaama laakohanɗa! ");
INSERT INTO snf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ati ɗú fooŋ an mi haydoh jam ga ëldúna? Óꞌóo, mi woꞌꞌúuka, mi haydoh kihëgískoh. ");
INSERT INTO snf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Diima deŋ ɓoꞌ ɓiyëtúus ɓaa bok hal hay kihëgískohu, ɓaahayɓaa keenu ga ɗook ɓanakɓaa tesɗa ee ɓanakɓaama keenu ga ɗook ɓaahayɓaa. ");
INSERT INTO snf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɓuwaa hay kihëgískohu: paamun keen ga ɗook kowuci kiƴaal ee kowukaagari kiƴaalkaa keen ga ɗookci, eemun keen ga ɗook kowuci kiɓeti ee kowukaagari kiɓetikaa keen ga ɗookci, payamun yiɓeti keen ga ɗook ɓeti kowuci ee ɓetifaa kowukaagari keen ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yéesu woꞌee mbooloomaa ɓan an: - Binaa ɗú hot húy kolukoh aasaaꞌ-nohaa, ɗú aawi kiwoꞌ an: «Kooh hay kitoɓ», ee iñaama laak. ");
INSERT INTO snf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ee binaa ɗú yéeŋ uuris wëpoh ɓakii hanoh meyaaꞌ-noh yah-seŋɗanaa, ɗú aawi kiwoꞌ an: «wati Kooh hay kitam noh», ee kërí laaki. ");
INSERT INTO snf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɗú, ɓii ɗú jófjófɗuki ga fíkíi ɓuwiiɗa! Ɗú mínin kimalaksukoh iñcii meyi ga asamaan na ga kakayɗanaa; haa tum na ɗú mínoo kimalaksukoh iñii hew watiɗa? ");
INSERT INTO snf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yéesu woꞌissa an: - Iñii tah ya ɓan ɗú malaksukohoo na kihaffúu iñaa júwin? ");
INSERT INTO snf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Binaa fu laakoh na ɓoꞌ bi ɗú taam kiƴee ga buuraa, leenaa gaawaa nari kiɓëgískoh ga waasaa, fodaama ya leꞌnoo naraa ga attiꞌohaa, yaama tíkkaa ga yah ëlkëetaa ee ëlkëetaa tëccaa ga kasu. ");
INSERT INTO snf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi yéegallaa man, fu meyohoo daama ee fu fayyii iñaa fu laakiꞌtiɗa tóoh, bi ga fíftínaa mëeñdohɗa. ");
INSERT INTO snf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ga wahtaama, laakka ɓuwaa hay ga Yéesu kiɓéestíꞌti ɓuwaa Pílaat aplukee ee boksee ga ɓu-Gëlílée, lak ɓa en na kitumiꞌ Kooh sarahɗa. ");
INSERT INTO snf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yéesu taassaɓa an: - Ɗú fooŋ an binaa ɓuwaa bok ga Gëlílée ɓaama apu fodaamanaa, iñaama waaꞌ kiteewoh an ɓa enee haꞌ-baakaaꞌcaa wëñ kiyak ga ɓu-Gëlíléeɗa tóohe? ");
INSERT INTO snf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mi woꞌꞌúu man óꞌóo. Wayee binaa ɗú súpíttii kipeskiigarúunaa, ɗú hay kisaŋkuꞌ ɓéeɓpúu fodaama. ");
INSERT INTO snf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Haa ɓuwaa ɓidaaŋkaah na ɓiyitnaɓaahayɓaa tawahaa wihooꞌtawaa ga Sílowee keenee ga ɗookɓa, appaɓaɗa; ɗú fooŋ an ɓërí wëñee kitum baakaaꞌ ga ɓu-Yéerúsaleem ɓéeɓɓane? ");
INSERT INTO snf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mi woꞌꞌúu man óꞌóo. Wayee, binaa ɗú súpíttii kipeskiigarúunaa, ɓéeɓpúu ɗú hay kisaŋkuꞌ fodaama. ");
INSERT INTO snf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lëehíꞌta Yéesu woꞌꞌaɓa liiwukii wii: - Enee ɓoꞌ, yaa laakee bos een ga ɗuuƴ yoonci. Ya kaꞌta kiɓeennee ga towutaa, wayee ya hottii dara ga. ");
INSERT INTO snf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ya woꞌꞌa súrgaagari an: «Tíkíis taahay tee, taa mi hayi kiheel towu ga eenii wii, ee mi hotoo dara ga. Gúraawa! Iñii tahan ya wa ñami kakayfii sooƴ?» ");
INSERT INTO snf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wayee súrgaa woꞌꞌari an: «Kiyaakii, íissisaawa kíiskii wíis bi mi ac bosii bi wíil, lëehíraa mi tum kotol ga. ");
INSERT INTO snf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Heƴna fayuuraa wa hay kitum towu. Límmbiinaa, fu gúꞌlukwa.» ");
INSERT INTO snf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ga bes Sabat, Yéesu enee na kijëgíroh ga ɗuuƴ jaangu-yaawúuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Laakeera daama ɓetifaa raɓ am, ekkari ɗúukool iñaa leꞌ tíkíis tidaaŋkaah na tiyitnataahay; ya ñogukka ee mínissii kiyoloh. ");
INSERT INTO snf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Daa Yéesu hotee ɓetifaa, ya ɓayyari, woꞌꞌari an: - Ɓetifii, fu múcin ga ɗúukooliigaraa. ");
INSERT INTO snf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lëehíꞌta, Yéesu tíkka ɓetifaa yahcaagari; ga saasi ɓetifaa yolohha, ee ya ennda ga kikañ Kooh. ");
INSERT INTO snf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wayee, ɓaa kuliyuk ga jaangu-yaawúuraaɗa, keeñci tammba lool ga daa Yéesu wëkíree ɓoꞌ ga bes Sabatɗa, ya dalla ɓuwaa kiwoꞌ an: - Bes ciyitniinoo cii ga, caa ɓoꞌ jom ga kilëgëy. Hayat kon kiwëkɗu ga bescaama wayee hanat kiꞌen ga bes Sabat! ");
INSERT INTO snf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Haꞌmudii loffari an: - Ɗú jófjófɗuki hen ga fíkíi ɓuwii! Ɓii yiida garúu, en ga bes Sabataa, pëkísoo enohfaagari wala baamaagari ga daa ya sawoheeriɗa, ya ɓayyi kiꞌëníꞌnee? ");
INSERT INTO snf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haa ɓetifii fii bok ga níilaa Abaraham ee Seytaani ɓageeri iñaa leꞌin tíkíis tidaaŋkaah na tiyitnataahayɗa, ya joméeríi kiɓëgísu ga bes Sabat hene? ");
INSERT INTO snf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Daa Yéesu woꞌee fodaama, ɓuwaa eneeri na kiheñohɗa líifussa na kaci. Wayee mbooloomaa ɓéeɓwa neɓlukka lool ga tumeencaa Yéesu laakoo ga fenɗa. ");
INSERT INTO snf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yéesu woꞌꞌa an: - Iñii Nguurii Kooh man nawaɗa ya? Iñii mi mín nawa kimëdírohɗa ya? ");
INSERT INTO snf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wa man na kowu-fúdankaa ɓoꞌ ɓeɓ, sokka ga dëraagari; ka paalla, ka ennda kedik kiyaak bi selcaa taalussa ga toytaa ka laakɗa. ");
INSERT INTO snf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yéesu woꞌissaɓa an: - Iñii mi mëdírohan Nguurii Kooh nawaɗa ya? ");
INSERT INTO snf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wa man na moloŋ-kuunaa ɓeti ɓeɓ, tumwa ga ɗuuƴ kanu kuun, íiswa ga bi ga daa kuuncaa ɓéeɓ kaañohan. ");
INSERT INTO snf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yéesu kooree ga dëk-teerucaa na ga dëk-kawcaa, ya jëgírohi, lak ya aawee ɓak Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Laakka ɓaa meekissi an: - Kiyaakii, ɓoꞌ ɓijutuut rek ɓërí ƴah kimúc ga ɓuwiine? Yéesu taassari an: ");
INSERT INTO snf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","- Guuꞌguulukat, ɗú aasoh halaa wiƴínwaa, ndaga mi woꞌꞌúuka, ɓiɓoꞌ ɓiyewin hay kiheelu kiꞌaas ee mínsanndiika. ");
INSERT INTO snf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bëríinaa haꞌ-kaanfii kolukan, ya laŋ halaagari ee ɗú en ga fooh, ɗú aaw kifëekíꞌ halaa na kiwoꞌ an: «Kiyaakii, lëgísɗaaríi.» Ya hayyúu kitaas an: «Mi ínohoo dii ɗú meyohɗa!» ");
INSERT INTO snf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Daama, ɗú hayyi kiwoꞌ an: «Ɗí bokin naraa kiñam na kiꞌan ee fu jëgírohin ga mbedicaa teerucaagaríi.» ");
INSERT INTO snf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wayee ya hayyúu kiwoꞌis an: «Mi ínohoo dii ɗú meyohɗa. Úsaayattoo ɓéeɓpúu, ɗú ɓii, ɗú meerin kitum iñaa joffiiɗa!» ");
INSERT INTO snf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Daama kikodukoh na kiꞌúñoh sís ƴah kilaak. Ɗú hot Abaraham na Ísaak na Yakoop na sëldíiga-Koohcaa ɓéeɓɓa ga ɗuuƴ Nguuraa Kooh, ee lak ɗú faanuunun ga fooh. ");
INSERT INTO snf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓiɓoꞌ hay kimeyohu ga ɓakcii ga ëldúnaɗa tóoh, ɓa bok kanu ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ee fodaama, ɓíinoo ga ɓuwii mëeñdohu watiɗa, ƴahu ga fíkíi ee ɓuwii ɓíinoo kuliyuku watiɗa, ƴahu ga fenoo. ");
INSERT INTO snf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ga wahtaama, laakka Fërísiyeeŋcaa hayu ga Yéesu woꞌussari an: - Kolkohaa dii fu ƴee ɗekat wiliis ndaga buuꞌ Eroot waaꞌtaa kiꞌapluk. ");
INSERT INTO snf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ya taassaɓa an: - Tíidat, ɗú woꞌ ɓaama ñaañ bi fan bodaaɗa an: «Mi yii ga kikaal raɓ ga ɓuwii na kiwëkíꞌ ɗúukoolíꞌ wati na kuwis ee besaa wukaahaywaanaa, mi hay kilëehíꞌ.» ");
INSERT INTO snf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wayee mi jomin kitíin waasiigoo wati, kuwis na paaf-kuwis, ndaga sëldíiga-Kooh jomoo kiꞌapu ga daa enndii Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","- Éeƴ, ɗú ɓu-Yéerúsaleem, ɗú ɓii ɗú lagi tumuuntii sëldíiga-Koohcii, ee ɗú tapisohi na atoh bi ɗú ap ɓuwii Kooh wos garúuɗa! Waas cera cërí mi heellúu kinëgíroh fodaa daa pabu nëgírohi towutaagari ga fíldoo paɓcaagariɗa, ee ɗú tookkiika? ");
INSERT INTO snf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kon nak, Kooh hay kifoñluk dëkumgarúu. Ee mi woꞌꞌúu man ɗú hotsisanndiiroo bi ga besaa bëríi ɗú woꞌan: «Fu yii fu hay ga teekii Haꞌmudiiɗa, fu barkeelin.» ");
INSERT INTO snf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ga bes Sabat, bëríi Yéesu karee kiñam ga kaan ɓoꞌ yíinoo ga ɓuwaa kuliyuk ga Fërísiyeeŋcaaɗa. Ɓuwaa ensee daamaɗa enussa yëŋ gari. ");
INSERT INTO snf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Laakka ɓaa tuuk ga fíkíici ɓay ɗúukool soonuk. ");
INSERT INTO snf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yéesu dalla kimeekis jëgíroh-waascaa na Fërísiyeeŋcaa an: - Waasiiruu onohin kiwëkíꞌ ɓoꞌ ga bes Sabat wala onohhiika? ");
INSERT INTO snf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɓuwaa ɗekohussa cel. Yéesu dalla kileꞌ ga ɓaa, wëkíꞌtari. Lëehíꞌta Yéesu íissari yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Waa ennda ɗa, Yéesu woꞌꞌaɓa an: - Yiida garúu, binaa kowuci wala enohci keen ga ɗuuƴ neꞌaa, ya gaawoori kimeƴdoh, luu enee ga bes Sabat? ");
INSERT INTO snf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɓa laakkii iñaa ɓa lofanndi ga woꞌeenaama. ");
INSERT INTO snf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yéesu malaksukohha ga daa sagaccaa heelsee rek kihanoh fíkíiɗa, ya liiwukkaɓa an: ");
INSERT INTO snf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","- Binaa fu ɓayu kiñam ga hewaa, kaa kaꞌ fu yugohnee fíkíi. Ndaga mín kiꞌen ɓaa wëñnjaa teek ɓayuunun da. ");
INSERT INTO snf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ee ɓaa ɓayyúu kiñam, ɗú ɓanakɗa, mínin kihay woꞌꞌaa an: «Íisɗaari ɗekatum.» Fodaama, fu hay kikaꞌ na kaci, fu yugohnee fenoo. ");
INSERT INTO snf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wayee binaa fu ɓayu kiñam ga hewaa, kara, fu yugohnee fenoo doonaa ɓaa nakkaa hewaaɗa hayaa, woꞌꞌaa an: «Fiilii, yugohaa fíkíi.» En ɗanaa iñaama hay kiꞌen ndam ga fíkíi ɓéeɓ ɓuwaa fu bok naɓa kiñamɗa. ");
INSERT INTO snf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ndaga ɓéeɓ ɓaa fu ɓëwíꞌ haffunaa, fu hay kiyóoskíɗu, ee ɓaa fu yóoskíꞌ haffunaa, fu hay kiɓëwíru. ");
INSERT INTO snf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lëehíꞌta Yéesu woꞌꞌa ɓaa ɓayeeri kiñamɗa ɓan an: - Binaa fu ɓëytoh cuunoh wala cuuníinaa, kaa ɓay fiiliimuncaagaraa wala ɓikëmëeŋkífu wala ɓuunfu, wala ɓuwaa dëk naraa ee laakuunun alalɗa; enndiikanaa, ɓa ga kihafɓa, ɓa mínndaa kiɓay kiñam ɓan, ee fodaama fu ëlídu iñaa fu tumee gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wayee binaa fu ɓëytoh kiñam jamaa, namaa kiɓay nduulcaa na ɓuwaa Kooh nëeɓsinɗa na lafañcaa na búumíꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Fu tumkanaa keeñfu hay ga kisoos, ndaga iñaama, ɓa mínooraari kiꞌëlín. Kooh hayyaari kiꞌëlín bëríinaa kimílískaa ɓuwii júwinɗa. ");
INSERT INTO snf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Laakka yíinoo ga sagaccaa ensee daamaɗa, ga waa ya kelohha woꞌeencaa caama, ya woꞌꞌa Yéesu an: - Ɓaa yaama ƴah kibok kiñam ga Nguuraa Koohɗa, yewinin múuꞌ! ");
INSERT INTO snf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yéesu liiwukkari an: - Enee ɓoꞌ, ya tíklukka cuunoh fiyaak, ɓaylukka ɓiɓoꞌ ɓiyewin ɓa hay kiñam. ");
INSERT INTO snf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ga waa cuunohfaa pariꞌɗa, ya wossa súrgaagari kiɓaynee ɓuwaa nakseeɗa an: «Hayat gii, cuunohfaa pariꞌin diima.» ");
INSERT INTO snf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wayee yaa en ɓéeɓ yaa tok sooli fodaa mooroomci. Yaa súrgaa ɗewohɗa woꞌꞌa an: «Mi lom yoon ee mi jominwa kimalaknee. Mi kíimmbaa hen fu bayalloo ga.» ");
INSERT INTO snf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yaa tík gaɗa woꞌissari an: «Mi lom naal ɓidaaŋkaah ee mi jominɓa kitagatnee. Mi kíimmbaa hen fu bayalloo ga.» ");
INSERT INTO snf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yiliis ɓan woꞌissari an: «Mi han kipañ ɓeti, kërí tah mi mínanndii kihay.» ");
INSERT INTO snf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Súrgaa ɓoyukka, woꞌꞌa haꞌ-kaanci iñaa ya taasuɗa. Haꞌ-kaanfaa aylukka, woꞌꞌa súrgaa an: «Karaa diima-diima ga paancii na mbedicii ga teeriiɗa fu haydoh nduulcii na ɓuwaa Kooh nëewísinɗa, búumíꞌcii na lafañcii.» ");
INSERT INTO snf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ennda kiis, súrgaa hayya, woꞌꞌari an: «Kiyaakii, iñaa fu nakoheeɗa tumuunun wayee daa ɓoꞌ mín kiyuŋ lís kilaak.» ");
INSERT INTO snf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Haꞌ-kaanfaa woꞌsissa súrgaa an: «Meyaa dëkii, fu kaꞌ ga waascii, na ga ɗíŋ-ɗíŋcii, fu gagal ɓuwaa ɓa hay doo kaanndoo líif.» ");
INSERT INTO snf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mi woꞌꞌúuka, yíinoo ga ɓuwaa mi ɗewee kiɓay kiñamɗa ƴoohoo ga cuunohfiigoo! ");
INSERT INTO snf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mbooloo wiyaak taabee na Yéesu. Yéesu mëeñsukka ga ɓuwaa, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","- Binaa ɓoꞌ hay garoo ee mi gënëlliiri paamci wala eeci, ɓetici wala towutaagari, ɓiyaakci na ɓikëmëeŋkíci ɓiƴaal wala ɓiɓeti, wala hafci sahaa, ɓaa yaama mínoo kiꞌen tëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɓaa fu koorukkii kuraanaagaraa, fu taabukkoonaa, fu mínoo kiꞌen tëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","En kiꞌenaa, yiida garúu, binaa ya waaꞌ kihëwíꞌ tawah wihooꞌtanaa, ɗewoo kiyuŋ paaƴ, ya malak iñaa jom kikaꞌ ga tawahaaɗa tóoh, doo ya ínoh ati iñaa ya laakɗa hay kidooy kimëtíꞌ lëgëyaa? ");
INSERT INTO snf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Enndiikanaa, binaa ya dal kiyíp tawah ee ya mínndiiwa kilëestíraa, ɓéeɓ ɓuwaa hotanwaɗa hay kiꞌenu ga kiñaawalli ");
INSERT INTO snf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","an: «Malkat ɓii yii dalin kitawah ee mínndiiwa kilëestíꞌ.» ");
INSERT INTO snf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ee ɓan buurii yiida, binaa ya ƴah kiheñohnee na buuꞌ yiliisaa, ɗewoo kiyuŋ paaƴ, ya malak ati ya hay kimín, na ɓoꞌ ɓijúnni-daaŋkaah, kileŋkoh na buuraa taam na ɓiɓoꞌ ɓijúnni-daaŋkaah-kanak? ");
INSERT INTO snf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ya mínndiinaa, ya wos ɓoꞌ ga buuraama, en lak ya lís nari kiꞌúsaayohaa, kimeekissi iñaa ya tuman bi ɓa mín kijúwohɗa. ");
INSERT INTO snf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Fodaama deŋ, ɓaa en ɓéeɓ garúu, fu mínndii kifoñ tóoh iñaa fu laakɗa fu taabukkoonaa, fu yaama, fu mínoo kiꞌen tëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yéesu tíkka ga an: - Maraa jofin. Wayee binaa maraa safissiinaa, ma ɗaanohsan na ya? ");
INSERT INTO snf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma laaksisoo jeriñ ga kakayfii, ma mínoo kiꞌen kotol. Ma jafsan ga lëedúu. Ɓaa fu laakin nof kikelohaa, súkúruka! ");
INSERT INTO snf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Juuticaa na ɓuwaa ɓíinoo júwussiiɗa deeyussa ɓéeɓɓa ga Yéesu kisúkúrukki. ");
INSERT INTO snf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fërísiyeeŋcaa na jëgíroh-waascaa ɓaa jambat ga díkaantiɓa an: - Ɓii yii tookin kiyuŋ na ɓuwii júwussiiɗa ee ya ñami naɓa! ");
INSERT INTO snf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ga ɗekataama, Yéesu liiwukkaɓa an: ");
INSERT INTO snf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","- Yiida garúu binaa ya laak baal ɓitéeméeꞌ, ee ya múuƴluk yíinoo ganaa, ya foñoo ɓidaaŋkaah-yitnanikiis na ɓiyitnanikiisɓaa, ɓa tes ga ëgíraa? Lëehíraa ya kaꞌ kitëebíꞌnee yaa múuƴɗa, bi ga daa ya hotanndine. ");
INSERT INTO snf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ee binaa ya hottinaa, ya túŋkulukki na keeñ wisóosíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ee ya leꞌ kaancinaa, ya ɓay fiiliimuncaagari na ɓuwaa dëk nariɗa, ya woꞌɓa an: «Neɓlukat naroo, ndaga mi hotin baalaagoo, yaa múuyeeɗa.» ");
INSERT INTO snf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Fodaama, mi woꞌꞌúuka, binaa haꞌ-baakaaꞌ yíinoo récuk baakaaꞌcaagarinaa, ga iñaama, ɗook-Kooh hay kiwëñ kiꞌen ga húmbal loo ɓiɓoꞌ ɓidaaŋkaah-yitnanikiis na ɓiyitnanikiis ɓaa júwin ee laakussii sooli ga kirécuk baakaaꞌcaagaɓa. Mi woꞌꞌúuka, malaakacaa Kooh hay kiwëñ kineɓluku binaa haꞌ-baakaaꞌ yíinoo rek récuk baakaaꞌcaagarinaa loo ɓoꞌ ɓidaaŋkaah-yitnanikiis na ɓiyitnanikiis ɓaa júwin ee laaksoo sooli ga kirécuk baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yéesu tíkka ga an: - Wala ɓetifii fiida ɓan, binaa ya laak hëelís cidaaŋkaah ee múuƴluk wíinoo ganaa, taaloo lampu, ya paruki, raasi dijófíꞌ bi ga daa ya hotanwa? ");
INSERT INTO snf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Binaa ya hotwanaa, ya ɓay húnísmuncaagari na ɓeticaa dëku nariɗa, ya woꞌɓa an: «Neɓlukat naroo ndaga mi hotin hëelísaagoo múuyeerooɗa.» ");
INSERT INTO snf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","En fodaamanaa mi woꞌꞌúuka man, malaakacaa Kooh hay kineɓluku ga daa haꞌ-baakaaꞌ yíinoo rek récukin baakaaꞌcaagariɗa. ");
INSERT INTO snf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yéesu woꞌissa an: - Enee ɓoꞌ yaa laak towu tanak tiƴaal. ");
INSERT INTO snf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yaa wëñ kiꞌen oomaaɗa woꞌꞌa paamci an: «Buba, eraaroo iñii mi joman kilaak ga alaliigaraaɗa.» Waa ennda ɗa, paamudaa warohha towutaa tanaktaa alalaagari. ");
INSERT INTO snf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tíkka ga bes cera, kowukaa kiƴínkaa toonnda iñcaa ya eꞌseeɗa tóohca, yaa ƴah kúl kiꞌúsaayíꞌ. Daama ya enukohha ga iñaa neɓpi bi ya yasohha hëelísaa tóohwa. ");
INSERT INTO snf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ga waa ya yasohha iñaa ya laakeeɗa tóohwa, aꞌ wiyaak laakka ga kúlkaa kaama, ee kibúŋ kiméeskíꞌ daɓpari. ");
INSERT INTO snf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya kaꞌta kisúrgaꞌuk ga ɓoꞌ ga gohaama. Yaama nakkari kiníiꞌ mbaam-parki ga yooncaa. ");
INSERT INTO snf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Helci eneera ga kiñam ga yiikcaa mbaamcaa eꞌsiɗa wayee ken onéeríiri ga. ");
INSERT INTO snf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Daama, ya malakka helci, ya woꞌꞌa an: «Ɓilëgëyoh ɓera ɓërí enu ga kaan paammboo, ɓa ñami bi ɓa tésɗíꞌ, ee mi en dii, mi kaani na aꞌ! ");
INSERT INTO snf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi hay kikoluk, mi ɓoyuk ga buba, mi woꞌꞌi an: Buba, mi baakaarin ga fíkíi Kooh ee mi tooñinndaa. ");
INSERT INTO snf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mi jomissii kiɓayu kowufu. Kon abohaaroo fodii yaa en ɓéeɓ ga lëgëyohciigaraa.» ");
INSERT INTO snf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ya kolukka, yaa ɓoyuk kaan paamci. Ga daa ya enee na kihay diꞌúsaayíꞌɗa, paamudaa séenndari, laakka yërmaandi wiyaak gari, ya yaa fool kihídohnee nari, gatawukkari, fuunndari. ");
INSERT INTO snf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kowukaa dallari kiwoꞌ an: «Buba, mi baakaarin ga fíkíi Kooh ee mi tooñinndaa, mi jomissii kiɓayu kowufu.» ");
INSERT INTO snf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wayee paamudaa woꞌꞌa súrgacaagari an: «Gaawat kihaydoh sibidooraa wëñ kimoꞌɗa, ɗú ekkiwa, ekatti kipii ga jokon na ñafaꞌ ga kotcii. ");
INSERT INTO snf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Haydohat ɗoonaa ɗú yafaleeɗa, ɗú appi, ɗu aaw kiñam na kimbúumbaayuk, ");
INSERT INTO snf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ndaga kowukiigoo ɗú hot kii kaaneera ee soofsin ga kipes, ka múuyeera ee ka hotukin.» Fodaama, ɓa dalla kimbúumbaayuk. ");
INSERT INTO snf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Waama lak kowukaa ɓaa kisaawkaa kaa ga yooncaa. Daa ka hayee bi ka deeƴca kaanfaa, ka kelohha típcaa na tiƴeektaa. ");
INSERT INTO snf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ka ɓayya yíinoo ga súrgacaa, meekissari iñaa hewɗa. ");
INSERT INTO snf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yaama woꞌꞌari an: «këmëeŋkífu yërí hay, ee paapu apɗinndi ɗoonaa yafalseeɗa, ndaga daa ya hotsinndi na jamɗa.» ");
INSERT INTO snf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kowukaa kisaawkaa dalla kiꞌayluk, saŋnga kiꞌaas kaanfaa. Paamci meƴca, kíimmbari ya aas. ");
INSERT INTO snf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wayee kowukaa woꞌꞌa paamci an: «Malka, tíkíis tiyewin tee, taa mi lëgëyiꞌtaa, mi mosoo kikëldúk woꞌeenfu ee fu mosooroo sah kiꞌon kupeꞌ, mi mbúumbaayuk na fiiliimunciigoo. ");
INSERT INTO snf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wayee kowukiigaraa kii, ga wii ka hayɗa, ya yii ya yasohin alalaagaraa na cagacaaɗa, fu apɗinndi ɗoonaa yafalseeɗa.» ");
INSERT INTO snf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Paamudaa dalla kitaas an: «Kowuroo, fu yii naroo besaa en ɓéeɓ, ee iñaa mi laak tóoh yuufu. ");
INSERT INTO snf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wayee ɗí jomee kimbúumbaayuk hen na kineɓluk ndaga këmëeŋkífu yii yii kaaneera ee soofsin ga kipes, ya múuyeera ee ya hotukin.» ");
INSERT INTO snf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yéesu woꞌissa tëelíbéecaagari an: - Enee haꞌ-alalaa laakee ɓaa tuukɗiri ga iñaa ya laakɗa. Tuukukohaama ëpírohussa ga haꞌ-alalaa an ya yaa yasoh alalaagari. ");
INSERT INTO snf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Haꞌ-alalaa ɓaylukka tuukkohaagari, woꞌꞌari an: «Iñii mi keloh woꞌu garaaɗa ya ya? Teewaaroo iñum fu tum ga lëgëyiigaraaɗa, ndaga diimaɗa, fu ƴahissii kituukuk alaliigoo.» ");
INSERT INTO snf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tuukukohaa woꞌꞌa ga helci an: «Mi tuman na ga dii kiyaakii ƴahhoo kinís ga kituukuk alaliigariɗa? Hanaa kilín kakayfii, wayee mi laakoo doolaa gawa, ee kisarahtuk, mi rúusinka. ");
INSERT INTO snf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mi ínohin iñaa mi ƴah kitum bi laak ɓuwaa ɓewussoo ga kaanɓa, binaa mi kaalu ga lëgëyiigoonaa!» ");
INSERT INTO snf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Waa ennda ɗa, ya ɓaylukka yíinoo yíinoo, ɓéeɓ ɓuwaa ɓayɗee haꞌ-kaanci kobotɗa. Ya woꞌꞌa yaa ɗeɓɗa an: «Fu laakiꞌ haꞌ-kaanndoo hín na?» ");
INSERT INTO snf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yaama taassa an: «Hëndíraan dúuleen citéeméeꞌ.» Ya woꞌꞌari an: «Ɓewaa këyít-kobotfiigaraa, fu gaaw kiyuŋ, fu bín cidaaŋkaah-yëtúus.» ");
INSERT INTO snf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lëehíꞌta ya woꞌꞌa yaa tík gaɗa an: «Haa fu, fu laakiꞌ haꞌ-kaanndoo hín na?» Yaama taassa an: «Saaku citéeméeꞌ ga beli.» Tuukukohaa woꞌꞌari an: «Këyít-kobotfiigaraa fee, bídaa cidaaŋkaah-yitnakaahay.» ");
INSERT INTO snf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Haꞌ-alalaa kañnja tuukukohaagari júɓpiiɗa ndaga kiñaañkaa ya tumɗa. Ndaga ɓuwii waaꞌ ëldúna doŋɗa wëñ kiyúuduku ga iñcaa ɓa tumi ga díkaantiɓaɗa loo ɓuwii boku ga leeꞌlaataa meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yéesu tíkka ga an: - Ee mi, mi woꞌꞌúu an: pokat kifiiliimun na alal ëldúna, en ɗanaa, bëríinaa ɗú laakissii daranaa, ɗú ɗapu ga kaancaa dëkohsan bi taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɓaa fu en goꞌ ga enaama cijutuut, fu hay kiꞌen goꞌ ɓan ga enaama ciyewin; ee ɓaa fu júɓpii ga enaama cijutuut, fu júwoo ɓan ga enaama ciyewin. ");
INSERT INTO snf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kon binaa ɗú júɓpii ga kituukuk alal ëldúnanaa, ɓii díŋkaananndúu alalaa wiwóoríꞌwaa ɓa? ");
INSERT INTO snf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ee binaa ɗú enndii goꞌ ga iñaa enndii yuurúunaa, ɓii ƴahhúu kiꞌeꞌ iñaa en yuurúu ɓa? ");
INSERT INTO snf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ken mínoo kiꞌen súrga haꞌ-kaan ɓanak. Faw fu saŋ yíinoo, fu waaꞌ yaa tesɗa; fu taabuk yíinoo, fu foñluk yaa tesɗa. Ɗú mínoo kiꞌatukoh kitop Kooh na kitop hëelís. ");
INSERT INTO snf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fërísiyeeŋcaa, na waareen hëelísaagaɓa, súkúrukussa tóoh iñcaa Yéesu woꞌɗa, ee ɓa ɓaa ƴensirukohhi. ");
INSERT INTO snf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yéesu woꞌꞌaɓa an: - Ɗú ɓërí en ɓuwii tíksi hafɓa ɓiɓoꞌ ɓijúwíꞌ ga hascii ɓuwiiɗa, wayee Kooh ínohin iñii en ga keeñciigarúuɗa. Ndaga iñcii ɓuwii tík fodii iñaa yakinɗa, sepiꞌin ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Móyíis na këyítcaa sëldíiga-Koohcaa bínseeɗa cërí teewohee Waasaa Kooh bi ga jamaanaa Saŋ hayohɗa. Iñaa aboh ga hayaa Saŋ waama, Hewhewii winéwíꞌwii woꞌ ga loo Nguurii Koohɗa yéegalohuunun, ee ɓaa en ɓéeɓ yaa tum doolici ga kiheel kiꞌaas ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ee kiɓewoh dii asamaanii na kakayfii wëñ kiyooɓ kinís kufíis jíinoo rek ga Bíncii Waasii. ");
INSERT INTO snf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ɓéeɓ ɓaa fu kaal ɓetifu, fu pañ ɓeti filiisaa, fu ɗeegin waas fu yaa faanuk na ɓeti filiis, ee ɓaa fu pañ ɓetifaa ƴaalaa kaalli henaa, fu ɗeegin waas fu yaa faanuk na ɓeti mooroomfu. ");
INSERT INTO snf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Enee ɓoꞌ yilëekíꞌ-alal, yaa daanee kiꞌekuk kúltí cimóríꞌ caa seerin, ee besaa en ɓéeɓ ya tumi ga kaanci mbúumbaay ciyaak. ");
INSERT INTO snf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Laakeera ɓoꞌ, enee nduul ee teeksee Lasaaꞌ, ya daanee kifaanuk ga hal-kaadaa haꞌ-alalaa, faanfaagari tóoh líifee na puus. ");
INSERT INTO snf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Helci teseera lool ga kiñam iñcaa wúunee ga kankaa haꞌ-alalaa ñamoheeɗa; ee wëñaa ga baaycaa hayunaa ɗeewsi puuscaagari. ");
INSERT INTO snf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ga waa nduulaa kaannda, malaakacaa Kooh ɓayussari ga yahaa Abaraham. Haꞌ-alalaa ɓan kaannda, acussa. ");
INSERT INTO snf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Haꞌ-alalaa enee ga coonu ciyaak ga ɗekataa ɓuwaa kaanin ɗaakuɗa. Ya ɓëwíꞌta hascaagari, ya hotta Abaraham diꞌúsaayíꞌ na Lasaaꞌ ga yahaaci. ");
INSERT INTO snf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ya yaa ɓayyi didóolíꞌ an: «Cica Abaraham, yërëmaaroo, fu wos Lasaaꞌ ya ñoon siñdaa jokonjiigari ga músú ee ya tóoyíriꞌtoo perimpiigoo ndaga mi yii kaanan ga kiwiikii.» ");
INSERT INTO snf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wayee Abaraham taassari an: «Kowuroo, níindískaa an fu laasin neɓlaatfu ga kipeskaagaraa ga ëldúnaɗa ee Lasaaꞌ enee ga iñaa meskin ɓan. Diimaɗa nak, ya yii dii kilaas jamiigari, wayee fu, fu yii ga coonu. ");
INSERT INTO snf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ee ɓaatta ga, ga díkaantiríi narúu laakin noŋ wiyaak, doonaa fodaama, ɓuwaa waaran kikolkoh dii karu garúu mínsanndiika ee ɓan ken mínoo kikolkoh garúu hay dii.» ");
INSERT INTO snf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Haꞌ-alalaa woꞌꞌari an: «Kon, mi kíimmbaa, cica Abaraham, fu wos Lasaaꞌ kaan paammboo, ");
INSERT INTO snf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ndaga mi laakin këmëeŋkímun ɓiyëtúus. Eneenaa ya karaa, ya woꞌɓa an ɓa hanat kiman ga daa mi madeeɗa, en ɗanaa ɓa ɓan, ɓa hayoo ga ɗekatii wii líif na coonuɗa.» ");
INSERT INTO snf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abaraham taassari an: «woꞌeencaa Móyíis na caa sëldíiga-Koohcaa caa na këmëeŋkímuncaagaraa, ɓa súkúrukatca!» ");
INSERT INTO snf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Haꞌ-alalaa woꞌꞌari an: «Iñaama dooyoo, cica Abaraham. Wayee binaa enee an ɓaa mílís ga kikaan yërí kaꞌ gaɓanaa, eneenaa ɓa hay kisúpít kipeskaagaɓa.» ");
INSERT INTO snf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wayee Abaraham loffari an: «Binaa ɓa súkúrukkii Móyíis na sëldíiga-Koohcaanaa, luu enee an ɓaa mílís ga kikaan yërí kaꞌ gaɓa, tahoo bi ɓa took iñaa yaama woꞌanɓaɗa.» ");
INSERT INTO snf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yéesu woꞌꞌa tëelíbéecaagari an: - Iñaa ekan ɓoꞌ ga kitum baakaaꞌ ñakanndii, wayee massa ɓaa iñaama koorohan gariɗa! ");
INSERT INTO snf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kipoku atoh wiyaak ga koonaa ya jafu ga giiyaa, kërí gën gari loo ya tah bi jíinoo ga tuꞌoomaatii tii keen ga baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kon watukat haffúu! Binaa mbokfu tooñaa, ñaraari ee binaa ya récukkanaa, bayalaari. ");
INSERT INTO snf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Binaa ya tooñnjaa waas ciyitnakanak ga bes wíinoo ee kotaa en ɓéeɓ ya hayyaa kiwoꞌ an: «Mi récukinka», leenaa bayalaari. ");
INSERT INTO snf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apotaaꞌcaa Yéesu woꞌussa Haꞌmudii an: - Ɓaataaríi ngëm. ");
INSERT INTO snf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Haꞌmudii woꞌꞌa an: - Binaa ɗú laakee ngëmaa hín na kowu fúdan dogaa, eneenaa ɗú hay kimín kiwoꞌ kedikkii kii an: «Ɗofuka, fu yípuknee ga giiyaa!» ee eneenaa ka tum iñaa ɗú woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yéesu woꞌsissa an: - Ɓii yiida garúu, binaa ya laak súrgaa línɗiri wala yaa níiꞌɗiri, ee súrgaa meyoh yooncaanaa ya woꞌꞌi an: «Deeya, fu yuŋ kiñam»? ");
INSERT INTO snf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Man ya namiri kiwoꞌ an: «Tíkɗaaroo cuuníin, fu pëkíruk, fu tumiꞌtoo mi ñam, mi an, bi mi lëehíraa fu ga kihaffu, fu han kiñam, fu an.» ");
INSERT INTO snf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Haꞌ-kaadaa laakɗin súrgaagari gërëm ndaga daa ya tum iñaa en lëgëyciɗane? ");
INSERT INTO snf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɗú ɓan, binaa ɗú tum iñaa en lëgëyyúuɗanaa, leenaa woꞌat an: «Ɗí ɓisúrga doŋ, ɗí tum iñaa ɗí jomee kitumɗa.» ");
INSERT INTO snf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lakanaa Yéesu enee na kiƴah Yéerúsaleem, ya koorohha díkaanti gohaa Samaríi na waa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Daa ya enee na kiꞌaas ga dëk-kaw wíinoo daamaɗa, laakka ɓoꞌ ɓidaaŋkaah ɓaa gaanaꞌin, hayussa ga fíkíici. Ɓa ceella palah. ");
INSERT INTO snf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ɓa ɓaa woꞌꞌi didóolíꞌ an: - Yéesu, kiyaakii, yërëmaaríi! ");
INSERT INTO snf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Daa Yéesu hoteeɓa, woꞌꞌaɓa an: - Karat, ɗú teewohnee haffúu ga sarahohcaa. Ga wii ɓa en na kiƴahɗa, ɓa wakka ga waas. ");
INSERT INTO snf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yíinoo gaɓa, daa ya hotee an ya wakin, ya yaa ɓoyuk ga kotcaagari, yaa ndam Kooh didóolíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya keennda ga kotcaa Yéesu, yíppa púkaa kakay, yaa gërëm Yéesu. Ɓaa yaama dëkee kúlkaa Samaríi. ");
INSERT INTO snf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yéesu woꞌꞌari an: - Enndii ɓidaaŋkaahɓaa ɓéeɓɓa ɓërí wak hanaa? Haa ɓiyitnanikiisɓaa ɓíinoo ɓada? ");
INSERT INTO snf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ɗal ɓii yii ee enndii yaawúuꞌɗanaa, laakkii yíinoo gaɓa yaa ɓoyuk kigërëm Kooh! ");
INSERT INTO snf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lëehíꞌta Yéesu woꞌꞌa ɓaa an: - Kolka fu ƴee, ngëmumgaraa músalinndaa. ");
INSERT INTO snf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fërísiyeeŋcaa meekissa Yéesu besaa Nguurii Kooh ƴah kihayɗa. Yéesu taassaɓa an: - Nguurii Kooh ƴahhii kihay fodii iñaa ɓaa en ɓéeɓ hotan wa hayi, bi leꞌ. ");
INSERT INTO snf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ken woꞌanndii an: «Malkat, weema!» wala «Wa wúunee!» ndaga ínohat an Nguurii Kooh wii ga leeloorúu. ");
INSERT INTO snf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lëehíꞌta Yéesu woꞌꞌa tëelíbéecaagari an: - Bes hay kihay, ɗú hay kiwaaꞌ kimaasoh luu enan bes wíinoo ga bescaa hayaa Kowukii ɓii, wayee ɗú maasohanndiiwa. ");
INSERT INTO snf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ee ɗú hay kiwoꞌu an: «Ya yaa dúunee wala ya yii dii!». Kaa karat ee kaa foolat da. ");
INSERT INTO snf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ndaga fodii dii melic eni tareet, léeríꞌ asamaan, aboh ɓakii wii, top ga ɓakaa wíinoowaaɗa, Kowukii ɓii madan ɗa bëríinaa ya haysanaa. ");
INSERT INTO snf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wayee Kowukii ɓii jom kiɗeɓ kison hen paaƴ, ee ya sagu ga ɓuwii wati. ");
INSERT INTO snf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Iñaa laakee ga jamaanaa Noweeɗa hay kilaaksis fodaama ga jamaanii hayii Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓuwaa ensee ga kiñam na kiꞌan, kipañ na kipajuk bi ga besaa bëríi Nowee aasoh ga gaal-giiyaa wiyaakwaaɗa: Kooh hannda kitoɓ músú miyewin, ma taakka ga kakayfii tóoh bi onnda ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Fodaama ɓan, ƴah kiman na iñaa hewee ga jamaanaa Lotɗa: ɓuwaa ensee ga kiñam na kiꞌan, kilom na kitoon, kilín na kitawah. ");
INSERT INTO snf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wayee besaa bëríi Lot meƴ dëkaa Sodomɗa, Kooh toɓpa kiwii na atohcaa tamin ga ɗook dëkaa, tëkíꞌtaɓa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iñaa manɗa yërí laakan bëríinaa Kowukii ɓii teewukohsisan ga ɓuwiiɗa. ");
INSERT INTO snf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Besaa bëríi, ɓaa fu en ga ɗook cakaraa túuyaagaraa ee fu laak yen ga ɗuuƴ túuyaanaa, kaa yoosuk kiɓeɓneeca. Fodaama ɓan ɓaa fu en na kilëgëy ga yooncaanaa, kaa ɓoyuk kaan. ");
INSERT INTO snf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Níindísukat iñaa dalee ɓeti Lotɗa! ");
INSERT INTO snf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɓaa fu heel kisom kipesfunaa, fu hayka kiñak, wayee ɓaa fu ñakkanaa, fu hayka kilaas. ");
INSERT INTO snf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi woꞌꞌúuka, wekaa bëríi, ɓoꞌ ɓanak ɓaa bok fayaaŋ: yíinoo hay kiɓewu, yíinooyaa foñu. ");
INSERT INTO snf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","En ɓeti ɓanak ɓaa bok kiꞌoꞌ: yíinoo hay kiɓewu, yíinooyaa foñu.  ");
INSERT INTO snf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tëelíbéecaa meekissari an: - Haꞌmudii, iñaama ƴah gada kilaakoh? Yéesu taassaɓa an: - Daa mídi enoh, daama ɓan suulcaa hídohsan da. ");
INSERT INTO snf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yéesu woꞌissaɓa liiwukii wii, kiteeɓɓa an ɓa jom kidëk ga kikíim Kooh ee ɓa hanat kisoof fenoo ga: ");
INSERT INTO snf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","- Enee attiꞌoh ga dëk-teeru, yaa niikéeríi Kooh ee ya yéegéeríi ken. ");
INSERT INTO snf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Laakeera ɓan ga dëk-teeraama ɓetifaa ƴaalci kaanin. Fa hayee leekleek ga attiꞌohaa kiwoꞌꞌi an: «Eraaroo kayoh ga ɗook ɓii tooñnjooɗa.» ");
INSERT INTO snf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Attiꞌohaa saŋnga iñaa maañ. Lëehíꞌta ya woꞌꞌa ga helci an: «Luu enee an mi niikkii Kooh ee mi yéeŋngii ɓoꞌ, ");
INSERT INTO snf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ga dii ɓetifii fii onndiiroo jamɗa, mi namanndi kiꞌeꞌ kayoh. Enndiikanaa, ya hay kilísi kihay bi faf mi kap ga.» ");
INSERT INTO snf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Haꞌmudii tíkka ga an: - Ɗú kelohin iñaa attiꞌohaa yibóníꞌyaa woꞌ yaamaɗa! ");
INSERT INTO snf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Haa Kooh eranndii ɓuwaa ya tanukɗa kayoh, ɓa ɓaa ɓa fiipi dímal gari wekoo nohooɗane? Ya hayɓa kiseklukohe? ");
INSERT INTO snf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi woꞌꞌúuka, ya hayɓa kigaaw kiꞌeꞌ kayoh. Wayee binaa Kowukii ɓii hayisaa, ya hay kilaak ga ëldúna ɓuwaa gëm garine? ");
INSERT INTO snf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yéesu woꞌissa liiwukii wii, ëewdohhawa ga ɓuwaa tíksee hafɓa ɓiɓoꞌ ɓijúwíꞌ ga fíkíi Kooh ee ɓa tíkkii ken ɓoꞌ: ");
INSERT INTO snf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","- Enee ɓoꞌ ɓanak, ɓa kaꞌta Kaanfaa Kooh kikíimnee Kooh; yíinoo enee Fërísiyeeŋ, yíinooyaa enee juuti. ");
INSERT INTO snf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fërísiyeegaa tuukka, yaa kíim Kooh ga ɗuuƴci anee: «Fu Kooh, mi gërëminndaa ga dii fu tummbiiroo mi man na ɓuwii ɓíinoo loksi, tumsi iñaa júɓpii, faanuksi na ɓeti jaambuuꞌ, wala ɓan fodii juutii yii. ");
INSERT INTO snf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Siminaa en ɓéeɓ, mi oori ga bes kanak, ee iñaa mi laak ɓéeɓ, ɓakaa wudaaŋkaahwaa mi tumwa sarah.» ");
INSERT INTO snf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Juutaa nak ceella palah ee kaañéeríi sah kihíilsuk kimalak ɗook-Kooh, wayee ya yaa típ keeñaa ndaga kirécuk, ee yaa woꞌ an: «Cëy Kooh, yërëmaaroo, mi haꞌ-baakaaꞌ.» Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","- Mi woꞌꞌúuka, ga waa ɓaa yaama soof kaanciɗa, Kooh tookeera an ya júwin, wayee Kooh tookkii Fërísiyeegaa. Ndaga ɓéeɓ ɓaa fu ɓëwíꞌ haffunaa, fu hay kiyóoskíru; ee ɓaa fu yóoskíꞌ haffunaa, fu hay kiɓëwíru. ");
INSERT INTO snf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓiɓoꞌ haydohɗussa Yéesu tuꞌoomaa, ya tík yahcaagari ga ɗookta. Daa tëelíbéecaa hotsee iñaama, ɓa ɓaa ñaꞌ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wayee Yéesu haydohlukka tuꞌoomaataa, woꞌꞌa an: - Íisat oomaacii ɓa hay garoo! Kaa hoonohatɓa ndaga Nguurii Kooh wuu ɓuwii man naɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mi woꞌꞌúuka ee kayoh; ɓaa fu tookkii Nguuraa Kooh fodii kuꞌoomaanaa, fu aasoo ga. ");
INSERT INTO snf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Laakka ɓoꞌ yaa kuliyuk ga yaawúuꞌcaa, meekissa Yéesu an: Jëgírohii yijófíꞌyii, mi tuman na bi mi laak ɓakkoo ga kipeskaa leehoo taaꞌɗa? ");
INSERT INTO snf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yéesu woꞌꞌari an: - Iñii tah ya fu woꞌ kijof garoo? Ken joffii, enndii Kooh rekaa. ");
INSERT INTO snf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fu ínohin iñii Waasii Móyíis nakoh kitumɗa: «Kaa ɗúk ɓetifu wala ƴaalfu, fu faanuk na ɓoꞌ yiliis, kaa laŋ kumuun ɓoꞌ, kaa lok, kaa seediꞌ saboh, kelohɗaa paamfu na eefu.» ");
INSERT INTO snf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɓaa taassari an: - Mi taabukin iñcuma tóoh, ga kiꞌoomaaroo bi wati. ");
INSERT INTO snf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga waa Yéesu kelohha iñaama, ya woꞌꞌari an: - Laakin iñaa tesohhaa. Toonaa iñcaa fu laakɗa tóoh, fu waroh nduulcii koparaama, fodaama fu hay kilaak alalaa leehoo taaꞌ ga ɗook-Kooh, lëehíraa fu hay, fu taabukkoo. ");
INSERT INTO snf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Daa ɓaa kelohee woꞌeencaama, keeñci leehha lool ndaga ya enee haꞌ-alal yiyaak. ");
INSERT INTO snf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yéesu hottari ya safarissii dara, woꞌꞌa an: - Kiꞌaas haꞌ-alal ga Nguuraa Kooh daal yooɓpii. ");
INSERT INTO snf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Geeleem paaf ga noŋ kúuc kërí wëñ kiyooɓ kiꞌaaskaa haꞌ-alal ga Nguurii Kooh. ");
INSERT INTO snf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓuwaa súkúrukeeriɗa woꞌussa an: - Kon baanaa ɓii mín kimúc ɓa? ");
INSERT INTO snf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yéesu woꞌꞌaɓa an: - Iñaa wooñ ɓoꞌ wooñnjii Kooh. ");
INSERT INTO snf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peeꞌ dalla kiwoꞌ an: - Malka, ɗí, ɗí foñin tóoh, iñaa ɗí laakeeɗa, ɗí taabukinndaa. ");
INSERT INTO snf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yéesu loffaɓa an: - Mi woꞌꞌúuka ee kayoh; ɓaa Nguurii Kooh tahhaa kifoñ kaanfu, ɓetifu, ɓikëmëeŋkífu wala ɓiyaakfu, eefu wala paapu wala towutaagaraanaa, ");
INSERT INTO snf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","fu hay kilaak yewin ga ëldúnaanii wati ee kuwisaa fu laak kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yéesu ɓayya tëelíbéecaa ɓidaaŋkaah na ɓanakɓaa haŋ, woꞌꞌaɓa an: - Malkat, ɗu ɓii ƴah Yéerúsaleem, ga daa wëeꞌtaa ga dii tóoh iñaa sëldíiga-Koohcii bínsee ga loo Kowukii ɓiiɗa laakohan. ");
INSERT INTO snf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ndaga ya hay kitíku ga yah yiifaꞌcaa gëmussii ga Koohɗa, ɓa ñaawalsohiri, ɓa ɓasiri, ɓa toossohiri. ");
INSERT INTO snf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ɓa hayyi kitíp laawoo, ɓa lëehíraa, ɓa appi. Ee bes kaahay tík ganaa, ya mílís. ");
INSERT INTO snf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wayee tëelíbéecaa ínohussii dara ga iñaama, ndaga iñaa woꞌeencaagari waaree kiwoꞌɗa ɗaakkee gaɓa hen, ee ɓa ínohéeríi iñaa Yéesu enee na kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Daa Yéesu hayee bi deeƴca Yéríkóo, laakka búumíraa yuŋ ga yahaanaa waasaa, yaa sarahtuk. ");
INSERT INTO snf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ya kelohha coowaa mbooloomaa enee na kipaafɗa, ya meekisohha iñaa hewɗa. ");
INSERT INTO snf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ya yéegalussa an Yéesu Nasareet yërí en na kipaaf. ");
INSERT INTO snf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Daama, ya yaa fiip an: - Éeƴ Yéesu, kucaasamunkii Dëwít, yërëmaaroo! ");
INSERT INTO snf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓuwaa hanohsee fíkíi mbooloomaaɗa ɓaa ñaꞌti, wayee ya yaa wëñ kifiip an: - Kucaasamunkii Dëwítóo, yërëmaaroo! ");
INSERT INTO snf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yéesu tuukka, nakohha an ya haydohɗussi. Ga waa búumíraa hayya bi gari, ");
INSERT INTO snf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Yéesu meekissari an: - Fu waaꞌ ya mi tumiꞌtaa? Búumíraa taassari an: - Haꞌmudii, tumɗaaroo bi mi mín kihotsis. ");
INSERT INTO snf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Waa ennda ɗa Yéesu woꞌꞌari an: - Mínsisaa kihot! Ngëmiigaraa músalinndaa. ");
INSERT INTO snf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ga saasi, búumíraa mínnda kihot, ee ya yaa taabuk Yéesu, ya yaa ndam Kooh. Daa ɓuwaa hotee iñaama, ɓéeɓɓa ɓaa ndam Kooh ɓan. ");
INSERT INTO snf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yéesu aassa Yéríkóo, ya koorohha ɗuuƴ teeraa yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Laakeera daama ɓaa teeku Sakee, yërí kuliyukee ga juuticaa, ee ya laakeera alal wiyewin. ");
INSERT INTO snf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ya heella kihot ɓaa en Yéesuɗa, ya mínndiika ga mbooloomaa ndaga ya enee ɓoꞌ yilohoƴ. ");
INSERT INTO snf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Fodaama ya foolla, kuliyukka ga fíkíi, lappa ga kedik kiyaak, en ɗanaa ya hot Yéesu ndaga ya jomee kikooroh daama. ");
INSERT INTO snf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ga waa Yéesu hayya bi leꞌꞌa daama, ya taaginukka, woꞌꞌari an: - Sakee, yoosuka gaaw, ndaga wati mi ƴah kidal ga kaanfu. ");
INSERT INTO snf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakee gaawwa kiyoosuk, safaꞌta lool ga kiꞌek Yéesu kaanci. ");
INSERT INTO snf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wayee ɓéeɓ ɓuwaa hotee iñaamaɗa ɓaa jambat an: - Malkat, Yéesu kaꞌ kisagacuknee ga kaan ɓaa júɓpii! ");
INSERT INTO snf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakee nak kolukka, woꞌꞌa Haꞌmudii an: - Haꞌmudii, malka, mi hay kiwaroh nduulcii ɓakii alaliigoo wíinoowii, ee en lakanaa mi ɗúkeera ɓoꞌ mi ñammba hëelíscinaa, mi hayyi kiꞌík iñaa hín ɗa waas cinikiis. ");
INSERT INTO snf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yéesu woꞌꞌa gari an: - Ɓu-kaanfii fii músaluunun wati, ndaga ɓii yii ɓan kucaasamun Abaraham. ");
INSERT INTO snf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","En kiꞌenaa, Kowukii ɓii hay dii kiɓay na kimúsal ɓuwii múuƴɗa. ");
INSERT INTO snf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yéesu woꞌissa na ɓuwaa súkúrukee woꞌeencaamaɗa. Lak ya deeyin Yéerúsaleem ee ɓaa en ɓéeɓ foogee an Nguuraa Kooh ƴah kiyoosuk ga wahtaamaa. ");
INSERT INTO snf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yéesu liiwukkaɓa, dallaɓa kiwoꞌ an: - Enee ɓoꞌ yilëekíꞌ-teek, ya enee na kiƴah kiɓaaɓ ga kúl kiꞌúsaayíꞌ, kifalu buuꞌ daama. Lëehíraa, ya ɓoyuk kúlɓa. ");
INSERT INTO snf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Balaa ya karaa, ya ɓayya ga súrgacaagari ɓidaaŋkaah, ya warohhaɓa hanjaꞌ-wúrúus cidaaŋkaah, yaa en ɓéeɓ wíinoo, ya woꞌꞌaɓa an: «Lëgëyat ga koparum bi ga daa mi hayan.» ");
INSERT INTO snf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wayee ɓu-kúlkaagari waaꞌséeríi gari kihot, ɓa wossa ɓiɓoꞌ ga fenooci, kiwoꞌ an: «Ɗí waaꞌtii ɓuum yuma buuꞌ.» ");
INSERT INTO snf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wayee ya falussa buuꞌ, ya ɓoyukka kúlɓa. Ya ɓaylukka súrgacaa ya foñɗee kopaꞌɗa, kiꞌínoh yaa en ɓéeɓ iñaa ya laakɗa. ");
INSERT INTO snf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yaa ɗeɓ kihayɗa woꞌꞌa an: «Kiyaakii, hanjaꞌ-wúrúusaa fu ereerooɗa, límin cidaaŋkaah ciliis.» ");
INSERT INTO snf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Buuraa woꞌꞌari an: «Waaw guureway, waa fu enin goꞌ ga iñaa yewinndii, mi hayyaa kiꞌeꞌ fu kuliyuk ga teeru cidaaŋkaah.» ");
INSERT INTO snf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lëehíꞌta yukanakyaa hayya, woꞌꞌa an: «Kiyaakii, hanjaꞌ-wúrúusaa fu ereerooɗa límin ciyëtúus.» Buuraa woꞌꞌa yaama an: ");
INSERT INTO snf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Fu ɓan mi hayyaa kiꞌeꞌ fu kuliyuk ga teeru ciyëtúus.» ");
INSERT INTO snf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lëehíꞌta, súrga yiliis hayya, woꞌꞌa an: «Kiyaakii, hanjaꞌ-wúrúusiigaraa wee, mi loyeewa hen ga líil, mi ɗaakka. ");
INSERT INTO snf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mi niikeeraa hen ndaga fu ɓoꞌ yisúwíꞌ ga keeñ, fu ɓewi iñaa fu faanndii ee fu píiki iñaa fu sokkii.» ");
INSERT INTO snf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Buuraa woꞌꞌari an: «Súrgii yibóníꞌyii, mi hayyaa kiꞌattiꞌ ga woꞌeenciigaraa. Fu ínoheera an mi súwin ga keeñ, mi ɓewi iñaa mi faanndii, mi píiki iñaa mi sokkii. ");
INSERT INTO snf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kon iñii tah ya fu wútírohiꞌtiiroo hëelísiigoo? Eneenaa mi ɓoyukaa, mi mínwa kilaas na iñaa wa límɗa.» ");
INSERT INTO snf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Lëehíꞌta ya woꞌꞌa ɓuwaa enee daamaɗa an: «Teꞌat hanjaꞌ-wúrúusumgari, ɗú eꞌwa yum ɓay cidaaŋkaahcumɗa.» ");
INSERT INTO snf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓuwaa woꞌꞌari an: «Kiyaakii, man ya yii na hanjaꞌ-wúrúus cidaaŋkaah.» ");
INSERT INTO snf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ya taassa an: «Mi woꞌꞌúuka, ɓaa laakin hay kiɓaatɗu, wayee ɓaa laakoo, kiꞌiñkaa ya ɓayɗa sah hay kiteꞌu. ");
INSERT INTO snf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ee nak ɓuwii sagohee naroo ee waaꞌséeríi mi en buuꞌɓaɗa, haydohatɓa dii, ɗú apɓa ga fíkíiroo.» ");
INSERT INTO snf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ga waa Yéesu woꞌꞌa fodaama, ya kuliyukka ga fíkíi mbooloomaa kiƴah Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ga waa ya deeƴca dëkaa Betfasee na waa Bétaníi ga ɓak tëgëlaa woꞌu tëgëlaa Ólíwíyéecaaɗa, ya wossa ɓanak ga tëelíbéecaagari, ya woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","- Karat dëk-kawum ga fíkíirúuɗa. Binaa ɗú leꞌ danaa, ɗú hay da kilaak cúmbúꞌ-baamaa pokuunun, ee ken mosoori kilap. Pëkísatti, ɗú haydohhi dii. ");
INSERT INTO snf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ee binaa ɓoꞌ meekissúu an: «Ɗú pëkísohhi ya?» Taasatti an: «Haꞌmudii yërí laak sooli ga.» ");
INSERT INTO snf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɓuwaa wosseeɗa karussa, ɓa laakka da tóoh fodaa daa Yéesu woꞌeeɓakaɗa. ");
INSERT INTO snf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lakanaa ɓa ɓaa pëkís cúmbúꞌ-baamaa, haꞌmuncaa woꞌussaɓa an: - Ɗú pëkísoh cúmbúrii ya? ");
INSERT INTO snf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓa taassa an: - Haꞌmudii laak sooli ga. ");
INSERT INTO snf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Waa ennda ɗa, ɓa haydohiꞌta Yéesu cúmbúraa, ɓa laꞌta paltucaagaɓa ga ɗook cúmbúraa, ɓa lëpíꞌta Yéesu ga. ");
INSERT INTO snf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ga daa ya enee na kiƴahɗa, ɓuwaa ɓaa laꞌ paltucaagaɓa ga ɗook waasaa. ");
INSERT INTO snf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ga wii ɓa yoosuk írkísaa tëgëlaa Ólíwíyéecaa bi ɓa ɓaa deeƴ Yéerúsaleemɗa, iñaa en tëelíbée tóoh yaa kañ Kooh didóolíꞌ, na keeñ wisóosíꞌ ndaga tóoh kíntaancaa ɓa hot Yéesu tumɗa. ");
INSERT INTO snf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɓa ɓaa woꞌ an: «Haꞌmudii barkeelat buurii hay ga teekiigariɗa! Jam laakat ga ɗook-Kooh ee ndam aawat ga Yaa ga ɗookaa-ɗookɗa!» ");
INSERT INTO snf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Laakka Fërísiyeeŋcaa ensee ga mbooloomaa, woꞌussa Yéesu an: - Jëgírohii, ɗekohɗaa tëelíbéeciigaraa. ");
INSERT INTO snf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yéesu taassaɓa an: - Mi woꞌꞌúuka, binaa ɓa ɗekohaa, atohcii cërí ƴah kitum coow! ");
INSERT INTO snf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ga waa Yéesu hayya bi deeƴca teeraa Yéerúsaleem, ee ya tíkka kuhasci gawa, ya yaa kodukiꞌ ɓu-dëkaa ");
INSERT INTO snf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","an: - Ɗú ɓan, enee an sah ɗú ínohee wati iñii mínndúu kiꞌon jamɗanaa! Wayee diima deŋ, iñaama ɗaakukin ga hasciigarúu, ɗú mínoori kihot. ");
INSERT INTO snf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ndaga bessúu waa hay, waa ɓuwii sagoh narúuɗa gúranndúu, ɓa gekkúu, ɓa sooŋngúu ga ɓakaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓa hayyúu kiɗúbíꞌ, ɗú na dëkumgarúu, ɓa foñɗoorúu sah atoh wíinoo waa tíkuk ga mooroomwa, ndaga jamaanii Kooh hayyúu kiɓaaɓɗa, ɗú ínohhiiwa! ");
INSERT INTO snf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yéesu aassa Kaanfaa Kooh ee ya yaa kaal toonohcaa en daamaɗa, ");
INSERT INTO snf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ya woꞌꞌaɓa an: - Bídu ga Këyítfaa Kooh an: «Kaanndoo ƴah kiꞌen kaanfaa kíimohohsan Kooh.» Wayee ɗú, ɗú tumfa ɗaakkaaꞌ lok. ");
INSERT INTO snf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yéesu enee ga kijëgíroh besaa en ɓéeɓ ga Kaanfaa Kooh. Ɓuwaa kuliyuk ga sarahohcaaɗa, jëgíroh-waascaa, bi ga ɓuwaa ɓiyaakɓaa ga dëkaaɗa heelseeri kiꞌap. ");
INSERT INTO snf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wayee ɓa hotéeríi daa ɓa tuman, ndaga daa ɓuwaa ɓéeɓ líksee helɓa ga Yéesu, ɓa ɓaa súkúrukkiɗa. ");
INSERT INTO snf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Laakka bes, ga daa Yéesu enee na kijëgíꞌ ɓuwaa ga ɗuuƴ Kaanfaa Kooh, na kiyéegaloh Hewhewaa winéwíꞌwaaɗa, sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa, na yaakcaa hayussa, ");
INSERT INTO snf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɓa meekissari an: - Woꞌaaríi iñcum fu tumɗa fu aƴca ga ɓa? Ɓii onndaaca kitum ɓa? ");
INSERT INTO snf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yéesu taassaɓa an: - Mi ɓan, mi hayyúu kimeekis yen yíinoo. Woꞌattoo: ");
INSERT INTO snf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bëtísaa Saŋ tumeeɗa, meyohee ga Kooh wala ga ɓoꞌ-súusúus? ");
INSERT INTO snf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wayee ɓa ɓaa woꞌ ga díkaantiɓa an: - Binaa ɗu taas an: «Meyohee ga Koohaa», ya hayyuu kilof an: «Iñii tah ya ɗú gëmmbii ga Saŋ?» ");
INSERT INTO snf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ee ɗu woꞌ an: «Meyohee ga ɓoꞌ-súusúusaa», ɓuwii ɓéeɓɓa hayyuu kitapisoh na atoh bi ɗu kaan ndaga wóorinɓa an Saŋ enee sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɓa taassari an: - Ɗí ínohoo ɓaa wa meyohee gariɗa. ");
INSERT INTO snf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yéesu loffaɓa an: - Kon baanaa, mi ɓan, mi woꞌanndiirúu iñcii mi tumɗa ati mi aƴca gaɓa. ");
INSERT INTO snf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lëehíꞌta, Yéesu yaa liiwuk ɓuwaa anee: - Enee ɓoꞌ, yíppa tedik-reseŋ ga yoonci. Ya ɓeɓpa ɓilínoh, sassaɓa kilëgëy yoonaa. Ya kaꞌta kiɓaaɓ iñaa maañin ga ín. ");
INSERT INTO snf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ga waa yoonaa lúunɗa, ya wossa súrga ga línohcaa ɓa eꞌti ɓakci ga iñaa yoonaa meƴdohɗa. Wayee línohcaa feekussa súrgaa, kaalussari yah ɓuucuuc. ");
INSERT INTO snf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Haꞌ-yoonaa wosissa súrga yiliis. Yaama ɓan, línohcaa feekussari, ɓasussari, kaalussari yah ɓuucuuc. ");
INSERT INTO snf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ya wossissa súrga yukaahay; yaama ɓan, ɓa gaañsohhari, jafussari ga fooh. ");
INSERT INTO snf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Haꞌ-yoonaa woꞌꞌa ga helci an: «Moo, mi tuman na? Hanaa mi wosan kowukiigoo mi keeñukɗa, heƴna ɓa hayyi kiꞌon céeꞌ.» ");
INSERT INTO snf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wayee ga waa línohcaa hotussa kowukaa kaa hay, ɓa ɓaa woꞌ ga díkaantiɓa an: «Yii jom kilamɗa yeema hayi; ɗu apatti, en ɗanaa ɗu lam yoonaa.» ");
INSERT INTO snf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɓa meƴdohhari yoonaa, ɓa appari. Yéesu meekissaɓa an: - Haa haꞌ-yoonaa tuman ɓuwaama na? ");
INSERT INTO snf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ya hay kihay, ya ap línohcaa, ya ek ɓiɓoꞌ ɓiliis ga yoonaa. Daa ɓuwaa kelohee woꞌeencaa Yéesu caama, ɓa woꞌꞌa an: - Taris! Iñaama hanat kilaak múk! ");
INSERT INTO snf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wayee Yéesu yíppaɓa has, woꞌꞌaɓa an: - Kon woꞌeenii wii bídu ga Këyítfaa Koohɗa, wa waaꞌ ya kiwoꞌ: «Atohaa tawahohcaa jafeeɗa, atohaa waama, enin atoh-koñ!» ");
INSERT INTO snf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɓaa keen ga ɗook atohaamanaa hay kiweelsukoh ee ɓaa wa keen ga ɗookcinaa, wa hayyi kinapañsoh. ");
INSERT INTO snf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ga wahtaama, jëgíroh-waascaa na sarahohcaa ɓiyaakɓaa ɓaa heel kitík yah ga Yéesu, ndaga ɓa ínoheera an ya woꞌee naɓa ga liiwukaagari, wayee ɓa niikka ndaga ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Waa ennda ɗa, ɓa ɓeɓpa ɓiɓoꞌ, ebilussaɓa ga Yéesu ee ɓa ɓaa malak gari. Ɓuwaama tumussa hafɓa fodii ɓuwaa júwin doonaa ɓa mín kifíꞌ Yéesu ga woꞌeen, fodaama ɓa on ɓuwaa wosseeɓaɗa iñaa ɓa ɓayohan Yéesu ga waas, buuꞌ tík yah gari. ");
INSERT INTO snf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓuwaama woꞌussa Yéesu an: - Jëgírohii, ɗí ínohin an iñcii fu woꞌɗa na iñcii fu jëgírohɗa júwin, ee fu faꞌtii na ken wayee fu jëgíroh kayoh ga iñaa Waas-Kooh nakohɗa. ");
INSERT INTO snf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Woꞌaaríi, ɗí jomin kifay Sesaaꞌ, buuraa yiyaakyaa lempu wala ɗí jomoo? ");
INSERT INTO snf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wayee Yéesu ínohha iñaa ɓa heelɗa, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","- Teewattoo hëelís denariyon wíinoo, Nataalii wii na teekii en gaɗa cuuɓa? Ɓa taassari an: - Cuu buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Daama Yéesu taassaɓa an: - Kon en ɗanaa, erat Sesaaꞌ iñaa Sesaaꞌ laak, ɗú eꞌ Kooh iñaa Kooh laak. ");
INSERT INTO snf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓa mínndiiri kifíꞌ ga woꞌeen ga fíkíi ɓuwaa. Hanaa kay lofaa Yéesu lofɓaɗa nammbaɓa kibet, ɓa ennda tiiꞌ. ");
INSERT INTO snf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Laakka Saduseyeeŋcaa hayu ga Yéesu. Ɓa ɓaa, ɓa sagin an laakin kimílís ga ɓuwaa kaanɗa. Ɓa meekissari ");
INSERT INTO snf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","an: - Jëgírohii, Móyíis nakeeruu kitum iñii yii: «Binaa ɓoꞌ, yaa pajin ee laakin këmëeŋkímun, kaan ee lak foñnjii ɓetici na kowaa, këmëeŋkímunaa jomin kilam ɓetifaama, ya laakiꞌ yaakci kowu ga.» ");
INSERT INTO snf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Waama laakee ƴaal ɓiyitnaɓanak, ɓaa bokee paamun na eemun. Yaakkaa pañnja ɓeti, kaannda ee laakkii kowu. ");
INSERT INTO snf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yukanakyaa pañnja ɓetifaa, ");
INSERT INTO snf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","lëehíꞌta, yukaahayyaa tíkka ga. Ennda ɗa ga ɓiyitnaɓanakɓaa ɓéeɓɓa. Ɓa kaannda ee ken foñnjii kowu. ");
INSERT INTO snf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ga waa ɓéeɓɓa leehha, ɓetifaa kaannda ɓan. ");
INSERT INTO snf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kon bëríinaa ɓuwii mílísan ga kikaanaa ɓetifaama ƴah yuu ɓa? Ndaga yaa en ɓéeɓ ga ɓiyitnaɓanakɓaa tumeerari ɓeti. ");
INSERT INTO snf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yéesu taassaɓa an: - Ɓuwii ga jamaanii watiɗa pañsin ee pajuksin. ");
INSERT INTO snf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wayee ɓuwaa joommbiiɓa kibok ga ɓuwaa ƴah kimílísɗa, na kipes ga jamaanii hayanɗa pañsoo ee pajuksoo. ");
INSERT INTO snf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓa mínsisanndii kikaan ee ɓa pesan madu na malaakacaa, ɓa ɓitowu Kooh ndaga ɓa límuk ga kikaan. ");
INSERT INTO snf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Móyíis ga kihafci teewohin an ɓuwaa kaanɗa hay kimílísu. Ga jangataa woꞌ ga loo pëegíifaa abee kiwiiɗa ya ɓay Haꞌmudii «Koohyii Abaraham, Koohyii Ísaak na Koohyii Yakoop». Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kon nak Kooh enndii yuu ɓuwaa kaanɗa wayee yuu ɓuwaa pesɗa, ndaga ga Kooh kipeskaa kaa ga ɓaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Waa ennda ɗa, laakka jëgíroh-waascaa woꞌ Yéesu an: - En kiꞌenaa, Jëgírohii, iñii fu woꞌɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɓa woꞌee iñaama ndaga ɓa kaañsiséeríiri kimeekisohis dara. ");
INSERT INTO snf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yéesu woꞌissaɓa an: - Ɓuwii mín na kiwoꞌu an Kiristaanii kucaasamun Dëwít? ");
INSERT INTO snf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ndaga Dëwít ga kihafci woꞌin ga Këyítfaa Kañcaa an: «Kooh woꞌꞌa Haꞌmudiigoo an: Yugohaaroo yah-ñaam, ");
INSERT INTO snf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bi ga daa mi tuman ɓuwii saŋngaaɗa ditogaaꞌ kotfu.» ");
INSERT INTO snf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Fodaama Dëwít ɓayyi «Haꞌmudii». Kon Kiristaanii mín na kiꞌen ɓan kucaasamun Dëwít? ");
INSERT INTO snf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lak ɓuwaa ɓéeɓ ɓaa súkúruk Yéesu, ya woꞌꞌa tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","- Abukat ga kiman na jëgíroh-waascii safaru ga kitíidisuk na kúltí ciyaak, na kikëñɗu yah kanak ga paancaa; ɓa heeli kiyugoh fíkíi ga ɗuuƴ jaangu-yaawúuꞌcaa, na kiyugoh fíkíi en ga hewaa. ");
INSERT INTO snf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓa ɗúuri alalcaa ɓeticaa ƴaalcaagaɓa lísussiiɗa, ee ɓa kíimi kíim-Koohaa ínohoo kileeh, doo ɓuwaa fooŋ an ɓa ɓiɓoꞌ ɓijúwíꞌ. Attiꞌaagaɓa wëñan kimesik! ");
INSERT INTO snf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yéesu ɓëwíꞌ hascaagari hen, ya hotta haꞌ-alalcaa ɓaa ek sarahcaagaɓa ga iñaa sarahcaa teꞌohsi ga Kaanfaa Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ya hotta ɓan ɓetifaa laakoo ee ƴaalci kaanin, yaa ek ga ɗuuƴgaa tudërëm tanak. ");
INSERT INTO snf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yéesu dalla kiwoꞌ an: - Mi woꞌꞌúuka ee kayoh; en kiꞌenaa ɓetifii laakoo fii ee ƴaalci kaaninɗa ekin iñaa wëñ iñii ɓuwiima ɓéeɓɓa ekɗa. ");
INSERT INTO snf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ndaga ɓuwiima ɓéeɓɓa tumu sarah ga iñaa ɓa wëñíꞌɗa, wayee ɓetifii fii ga kinduulci, ya erohin tóoh iñaa ya jomee kipesohɗa. ");
INSERT INTO snf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Laakka ɓiɓoꞌ ɓaa enee na kiwoꞌ ga loo Kaanfaa Kooh. Ɓa woꞌee an fa morin lool, na atohcaagari cimóríꞌcaa, na moꞌlaatcaa tumɗu Kooh daɗa. Wayee Yéesu woꞌꞌa an: ");
INSERT INTO snf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","- Bes waa hay, iñii ɗú niiruk yii tesanndii atoh wíinoo waa tíkískoh na mooroomwa; tóoh hay kiɓúꞌ. ");
INSERT INTO snf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɓuwaa meekisussa Yéesu an: - Jëgírohii, iñcaama ƴah kilaak kera? Mandargii wiida teewohan an iñcii cii jomin kilaak? ");
INSERT INTO snf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yéesu loffaɓa an: - Watukat kiɗúku ndaga ɓoꞌ ɓiyewin hay kihayohu teekkoo, ɓa woꞌi an: «Mi yërí en Kiristaanii na: «Wahtii deeyin» wayee kaa taabukatɓa. ");
INSERT INTO snf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Binaa ɗú keloh yëngël heñ wala an ɓiɓoꞌ ɓaa heñoh kilaak hafɓanaa, kaa tíitat. Ndaga iñcaama jomin kilaak paaƴ, wayee enndii an ëldúna ƴah kitúkíꞌ ga saasi-saasi. ");
INSERT INTO snf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lëehíꞌta ya tíkka ga an: - Kúl hay kikoluk, keen ga ɗook kúl mooroomci, ee nguuꞌ hay kiɓewuk keen ga ɗook nguuꞌ mooroomci. ");
INSERT INTO snf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kakayfii hay kiyëngëluk, yëngël wiyaak ee ga ɗekat ciyewin, aꞌ na ɗúukoolcaa karohin hay kilaak. Ee ɓan yen ciyewin caa tíitalohin hay kilaak, mandarga cidóoyíꞌ-waaꞌ hay kimeyoh ga ɗook asamaan. ");
INSERT INTO snf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wayee balaa iñcaama tóoh laakaa, ɓuwii hay kitíku yah garúu, ɗú hatalu ga kipessúu, ɗú ɓayu kiꞌattiꞌu ga jaangu-yaawúuꞌcaa, ee ɗú hay kitëcu ga kasu. Ɗú hay kiɓayu ga fíkíi buuꞌcaa na ɓuwaa laak nguuraaɗa ndaga teekiigoo. ");
INSERT INTO snf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iñaama hayyúu kimín kiꞌon kituukukkoo. ");
INSERT INTO snf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tumat ga helciirúu an ɗú jomoo kihalaat ga iñaa ɗú woꞌan ga fíkíi ɓuwaa yabussúuɗa, ");
INSERT INTO snf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ndaga mi hayyúu kiꞌeꞌ kiñaañ na woꞌeencaa wëeꞌtaa ga an cii yíinoo ga ɓuwaa heñohussúuɗa mínanndii yen ga, wala ɓa mín kisaŋ iñcaa ɗú woꞌanɗa. ");
INSERT INTO snf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bi ga ɓuwaa límmbúuɗa, na ɓuwaa ɗú bok naɓa eemun na paamunɗa, mbokcaagarúu na fiiliimuncaagarúu hayyúu kitoonu ga buuraa, ee ɓíinoo garúu hay kitíku kikaan. ");
INSERT INTO snf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓéeɓ ɓuwii waaꞌsanndii garúu kihot ndaga teekiigoo. ");
INSERT INTO snf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wayee kufen jíinoo ɓooyukanndii ga hafciigarúu. ");
INSERT INTO snf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kiguuꞌguuluk kërí tahanndúu kipes. ");
INSERT INTO snf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","- Binaa ɗu hot ɓisoldaaꞌ wíil Yéerúsaleem kúrkúndúlaa, ɗu hay kiꞌínoh an waa ƴah kipookisohu. ");
INSERT INTO snf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Leꞌ bëríinaa, ɓuwaa iñaama laakan gohaa Yúudéeɗa, ɓa núpat ɓa ƴee ɓak jaŋjaŋcaa; ɓuwaa iñaama laakan ɗuuƴ Yéerúsaleemɗa, ɓa úsaayat daama, ee ɓuwaa iñaama laakan dëk-kawcaaɗa ɓa hanat kiꞌaas teeraa. ");
INSERT INTO snf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ndaga bescaa ciméeskíꞌcaa caama cërí Kooh ƴah kikoroh ɓu-Isarayeel doonaa tóoh iñcaa bínsee ga Këyítfaaɗa laak. ");
INSERT INTO snf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Massa ɓeticaa bescaama laakanɓa na look, na ɓaa ensan na kiɓëpíꞌɗa, ndaga ɓu-dëkaama hay kiꞌenu ga coonu fiyaak ee aylukaa Kooh hay kiyoosuk ga ɗook ɓuwaama. ");
INSERT INTO snf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓa hay kiꞌapu na kalaɓ, ɓa abu ñaam ga leeloo heetcii ga ëldúnaɗa tóoh, ee yiifaꞌcaa hay kimókíꞌ Yéerúsaleem bi daa nguuraagaɓa daamaɗa leehan. ");
INSERT INTO snf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yéesu tíkka ga an: - Hay kilaak mandargacaa hotuk ga nohii, ga ñiidii, na ga olcii. Ga kakayfii, ɓuwii hay kilëyu lool ndaga kitíit ga yëngëlaa giiyii na dúusciigari. ");
INSERT INTO snf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓiɓoꞌ hay kikaanu na kitíit ndaga kihalaat ga iñaa ƴah kidal ëldúnaɗa, ndaga iñcii laak ga ɗook asamaanɗa tóohca hay kihíciskoh. ");
INSERT INTO snf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Fodaama, Kowukii ɓii hay kihotu, ka yoosuki ga ɗuuƴ yaayeelcii ee ka taam na dooli na ndam wiyaak. ");
INSERT INTO snf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Binaa iñcuma dal kilaakaa, leenaa yolohat, ɗú taaginuk ɗook, ndaga lak ɗú hayin kimúsalu. ");
INSERT INTO snf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yéesu liiwukissa ɓuwaa anee: Malkat ga een na tediktii tíinoo: ");
INSERT INTO snf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Binaa ɗú hot ca dal kitapisaa, ɗú ga kihaffúu, ɗú ínoh an lahum deeyin. ");
INSERT INTO snf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Fodaama ɓan, binaa ɗú hot iñcaama ca laakaa, ínohat an Nguurii Kooh deeyin. ");
INSERT INTO snf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mi woꞌꞌúuka ee kayoh; bi ɓuwii wati kaanu ɓéeɓɓanaa, iñcaama tóoh hay kilaak. ");
INSERT INTO snf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Asamaanii na kakayfii hay kifaay wayee woꞌeenndoo faayoo múk. ");
INSERT INTO snf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","- Watukat haffúu; kaa líkat helciigarúu ga kiñam na kiꞌan kihëpíꞌ na halaat ëldúna, enndiikanaa besaa bëríi hayyúu kibet lool, ");
INSERT INTO snf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","fodii mbëp; wa hayan ɗa ga ɗook ɓuwii tóoh enu ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kon kaa neehat, ɗú kíimi Kooh wahtaa en ɓéeɓ, doonaa ɗú laak dooli kisaan ga iñcaa ƴah kihay caama, ee ɗú mín kituuk ga fíkíi Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","En na nohaa, Yéesu jëgírohi ga ɗuuƴ Kaanfaa Kooh, wayee wekaa leꞌaa ya ƴee kineehnee ga tëgëlaa woꞌu tëgëlaa Ólíwíyéecaa. ");
INSERT INTO snf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ee ga kím cuut ɓuwaa ɓéeɓ hayya gari ga Kaanfaa Kooh kisúkúrukki. ");
INSERT INTO snf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lak feetaa Paak ee ñamohsi mbúurúcaa tumoo lëwíiꞌɗa deeyin. ");
INSERT INTO snf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa ɓaa heel daa ɓa tuman bi ɓa apluk Yéesu ee ken yéegoo ndaga ɓa kaañéeríi ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Fodaama Seytaani aassa Yúdaa, yaa ɓaysi Iskariyotɗa ee bokee ga tëelíbéecaa ɓidaaŋkaah na ɓanakɓaa. ");
INSERT INTO snf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yúdaa kaꞌta, hotohneera na sarahohcaa ɓiyaakɓaa na ɓuwaa kuliyuk ga pokkoh-liiɓcaa ga Kaanfaa Koohɗa, ga daa ya tuman bi ya tík Yéesu ga yahɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Keeñɓa soossa ga bi ɓa díŋngari kopaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yúdaa tookka, yaa heel besaa ya jekalukan, ya tík Yéesu ga yahɓa ee mbooloomaa yéegooka. ");
INSERT INTO snf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Besaa hewaa mbúurúcaa tumoo lëwíiꞌɗa ee tubaaltaa apsi ga kitík cuuníinfaa ñamsi ga Paakɗa leꞌꞌa, ");
INSERT INTO snf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yéesu wossa Peeꞌ na Saŋ, woꞌꞌaɓa an: - Karat, ɗú waayukɗinee haffuu cuuníinfii Paak. ");
INSERT INTO snf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓa meekissa Yéesu an: - Fu waaꞌ ɗí waayukneefa gada? ");
INSERT INTO snf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yéesu taassaɓa an: - Súkúrukat, binaa ɗú aas teeraanaa, hay kilaak ƴaalaa hídukoh narúu, kooruk kujataa músú. Taabukatti bi ga ɗuuƴ kaanfaa ya aasanɗa, ");
INSERT INTO snf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ee ɗú woꞌ haꞌ-kaanfaama an: Jëgírohii meekisoh an túuyaa ya ñamohan Paak, ya na tëelíbéecaagariɗa wada? ");
INSERT INTO snf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Fodaama, ya hayyúu kiteeɓ túuƴ wiyaak waa hanoh ɗook ee hëwíruunun bi jekin; ɗú waayukan ñamahcaa ga ɗekataama. ");
INSERT INTO snf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓa kaꞌta, ɓa laakka tóoh fodaa daa Yéesu woꞌeeɓakaɗa, ɓa aawwa kon kiwaayuk ñamahaa Paak. ");
INSERT INTO snf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Waa wahtaa leꞌꞌa, Yéesu yuŋnga kiñam na apotaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ya woꞌꞌaɓa an: - Helloo teseera lool ga kibok narúu kiñam cuuníinfii Paakii wii balaa mi sodalunaa! ");
INSERT INTO snf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndaga mi woꞌꞌúuka; mi ƴahissiifa múk kiñamis bi ga daa iñaa fa waaꞌ kiwoꞌɗa matan bëríinaa Kooh tuukiran Nguuraagariɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Waa ennda ɗa, ya ɓeɓpa kaas-biiñ, gërëmmba Kooh ga, lëehíꞌta ya woꞌꞌa an: - Uunat, ɗú warohwa, ");
INSERT INTO snf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ndaga mi woꞌꞌúuka, aboh ga wati mi ansisoo anahaa meyoh ga kowu reseŋ bi ga daa Kooh tuukiran Nguuraagari. ");
INSERT INTO snf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lëehíꞌta ya ɓeɓpa mbúurú, ya gërëmmba Kooh ga, ya weelsohhawa, ya eꞌtaɓawa an: - Iñii yii faanfiigoo, mi eroh ndaga ɗú. Tumat iñii yii, ɗú níindísukohiroo. ");
INSERT INTO snf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Waa ɓa lëehíꞌta kiñamɗa ya ɓeɓpa kaas-biiñ, tummba fodaama an: - Iñii yii, kifiiliimunkii kiꞌaskii Kooh narúu ee poku na ñífiigoo aamɗussúuɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wayee malkat ɓii ƴahhoo kitoonɗa yii ekoh naroo yah dii. ");
INSERT INTO snf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","En kiꞌenaa, Kowukii ɓii hay kikaan fodaa daa Kooh naꞌ gakaɗa, wayee massa ɓaa toonndi yaama! ");
INSERT INTO snf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Waa ennda ɗa, apotaaꞌcaa ɓaa heel kiꞌínoh ga ɗuuƴɓa, ɓaa ƴah kitum iñaamaɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Laakka daama nookoh ga díkaanti apotaaꞌcaa kiꞌínoh yaa ɓa halaat an yërí wëñ kiyak gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yéesu woꞌꞌa an: - Buuꞌcii ga ëldúnaɗa nguuruksi ga ɗook ɓuwaa ɓa laakɗa, ee ɓuwaa tíki yah ga ɗook ɓuwaamaɗa waaꞌsi kiɓayu «ɓuwaa tumsi yijófíꞌ rek.» ");
INSERT INTO snf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wayee iñaama enndii ɗa garúu. Hanaa kay yaa wëñ kiꞌen yaak garúuɗa joman kiman na yërí wëñ kiꞌen oomaa; ee yaa en ga fíkíinaa joman kiman na súrga. ");
INSERT INTO snf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","En kiꞌenaa, yaa yuŋ ga kankaa kiñamɗa, na yaa enndi na kinoriꞌɗa; ɓanakɓaama, yiida wëñ ga kiyak? Man yaa yuŋ ga kankaa kiñamɗa yërí ya, enndii ɗane? Mi nak, mi yii ga díkaantirúu fodii súrga. ");
INSERT INTO snf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɗú, ɗú ɓërí en ɓuwaa dëkee kitaam naroo ga coonucii mi dayeeɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ee fodaa daa paammboo onndoo kinguurukɗa, mi oninndúu kinguuruk naroo fodaama. ");
INSERT INTO snf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Fodaama ɗú bokan naroo kiñam na kiꞌan ga daa mi ƴah kinguurukɗa ee ɗú yugan ga paancaa kiꞌattiꞌ níilcaa ɓu-Isarayeel cidaaŋkaah na kanakcaa. ");
INSERT INTO snf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yéesu woꞌꞌa an: - Simoŋ, Simoŋ! Malka: Seytaani kíim an ɗú onussi ya lassúu fodii ɓaa las tohoo. ");
INSERT INTO snf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wayee mi kíimɗinndaa Kooh doonaa ngëmum fu laak garooɗa leehoo. Ee binaa fu ɓoƴkis garoonaa, leenaa ɓaataa dooli ɓuwaa fu bok naɓa ngëmɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peeꞌ woꞌꞌari an: - Haꞌmudii, mi pariꞌin kiꞌen naraa bi ga kitëcu ga kasu wala kiꞌapu. ");
INSERT INTO snf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yéesu taassari an: - Peeꞌ, mi woꞌꞌaa an bi siik-pabu kon watinaa fu hay kitaasuk kiꞌínohhoo bi en waas kaahay. ");
INSERT INTO snf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Lëehíꞌta Yéesu woꞌꞌaɓa an: - Ga waa mi wossúu ee ɗú ɓaydohhii kopaꞌ, hëmbu wala ñafaꞌɗa, ɗú ñakeera yene? Ɓa taassa an: - Ɗí ñakéeríi dara. ");
INSERT INTO snf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ya woꞌissa an: - Diimaɗa nak, ɓéeɓ ɓaa fu laakin hëelísaa, ɓewaawa, ee ɓaa fu laakin hëmbaa ɓewaawa ɓan; ee ɓaa fu laakoo kalawaa, toonaa paltufaagaraa fu lom kalaɓ. ");
INSERT INTO snf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndaga mi woꞌꞌúuka, iñaa woꞌu ga Këyítfaa an: «Ya kíduunun ga tumoh-kofeelciiɗa» hay kilaak garoo. Ee iñaa woꞌu aaw garoo yaama yii ƴah kilaak. ");
INSERT INTO snf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tëelíbéecaa woꞌussari an: - Haꞌmudii, kalaɓ kanak cee. Ya loffaɓa an: - Dooyin ɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yéesu meƴca teeraa, ya kaꞌta tëgëlaa Ólíwíyéecaa, fodaa daa ya meereeka kitumɗa. Tëelíbéecaagari taabussa nari. ");
INSERT INTO snf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ga waa ya leꞌꞌa ɗekataa, ya woꞌꞌaɓa an: - Kíimat Kooh doonaa ɗú keenoo ga fíraa Seytaani. ");
INSERT INTO snf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lëehíꞌta ya úsaayya iñaa hín na wéesée-atoh, ya ƴíꞌꞌa, yaa kíim Kooh ");
INSERT INTO snf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","an: - Buba, en lak fu waarinkanaa, úsaayɗaa kaas-coonufii fii garoo. Wayee hanat kiꞌen iñaa mi waaꞌɗa wayee iñaa fu waaꞌɗa laakat.  ");
INSERT INTO snf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Waa ennda ɗa, laakka malaakaa Kooh meƴ gari, ɓaattari dooli. ");
INSERT INTO snf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hídaa ga daa keeñci leehɗa tóoh, Yéesu yaa ɓaat kiwëñ kikíim Kooh. Anagaagari mannda na ñífaa en na kisíit kakay. ");
INSERT INTO snf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Waa ya kíimmba Kooh bi ya lëehíꞌtaɗa, ya kolukka, ya ɓoyukka ga tëelíbéecaagari. Ya laakɓa ɓaa neeh ndaga lak keeñɓa neɓpii. ");
INSERT INTO snf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ya woꞌꞌaɓa an: - Ɗú neeh ya? Kolkat, ɗú aaw kikíim Kooh doonaa ɗú keenoo ga fíraa Seytaani. ");
INSERT INTO snf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lak Yéesu yaa lís kiwoꞌ, ɓoꞌ ɓiyewin meƴca jalañ. Yúdaa yaa bok ga tëelíbéecaa ɓidaaŋkaah na ɓanakɓaaɗa, hanohee fíkíi. Ya hayya ga Yéesu kifuunndi. ");
INSERT INTO snf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Daama, Yéesu woꞌꞌari an: - Yúdaa, fu toon Kowukii ɓii na kifuunndine? ");
INSERT INTO snf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ga waa ɓuwaa taabee na Yéesuɗa hotussa iñaa ƴah kilaakɗa, ɓa meekissari an: - Haꞌmudii, ɗí ƴoɓsohatɓa na kalawe? ");
INSERT INTO snf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yíinoo gaɓa meƴdohha kalaɓfaagari, ƴoɓpa súrgaa ɓaa kuliyukee ga sarahohcaa ɓiyaakɓaaɗa, gúꞌta nofaa ñaabaa. ");
INSERT INTO snf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wayee Yéesu woꞌꞌaɓa an: - Íisat, dooyin. Ya leꞌꞌa ga nofaa ɓaa, wa íkukka ga daa wa eneeɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lëehíꞌta Yéesu woꞌꞌa sarahohcaa ɓiyaakɓaa, na ɓuwaa kuliyuk ga soldaaꞌcaa ga Kaanfaa Koohɗa na yaakcaa yaawúuꞌcaa hayseeri kiꞌamɗa an: - Mateerarúu kihay na kalaɓ na dooꞌ fodii ɓuwaa dawuk tumoh-kofeele? ");
INSERT INTO snf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mi enéeríi narúu besaa en ɓéeɓ ga ɗuuƴ Kaanfaa Koohe? Ee ɗú tíkkii yah garoo. Wayee wahtii wii wuurúu, ɗú na doolii laak wekɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɓa ammba Yéesu, ɓa ɓayyari kaanfaa sarahohaa kuliyuk ga sarahohcaa ɓiyaakɓaaɗa. Peeꞌ yaa taabukɓa diꞌúsaayíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kiwii taalseera ga leeloo hëtaa kaanfaa, Peeꞌ hayya, yuŋnga ga ɗuuƴ ɓuwaa wíilkaɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Laakka súrga yiɓeti yaa hot Peeꞌ ga leeꞌlaataa kiwiikaa. Ya yíppari hascaa, woꞌꞌa an: - Ɓii yii ɓan enee nari! ");
INSERT INTO snf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wayee Peeꞌ taasukka an: - Mi ínohoori de, ɓetifii fii! ");
INSERT INTO snf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ennda kiis, laakka ɓoꞌ yiliis yaa hotti, woꞌꞌari an: - Fu ɓan fu bok gaɓa! Wayee Peeꞌ taassa ɓaama an: - Mi bokkii gaɓa de, ƴaalii yii! ");
INSERT INTO snf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tíkka ga iñaa leꞌ wahtu, ɓoꞌ yiliis yëgíssa ga woꞌeenaagari an: - Wóorin an ɓii yii enee nari, ndaga ya kúlkoh Gëlílée. ");
INSERT INTO snf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wayee Peeꞌ loffari an: - Mi ínohoo iñum fu waaꞌ kiwoꞌɗa, ƴaalii yii. Ga ɗekataama, wii ya lëehɗan kiwoꞌaa, siik-pabu konnda. ");
INSERT INTO snf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Haꞌmudii heelukka, yíppa Peeꞌ hascaa. Peeꞌ níindísukka iñaa Haꞌmudii woꞌeeriɗa an: «Bi siik-pabu kon watinaa, fu hayyoo kitaasuk waas kaahay.» ");
INSERT INTO snf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ya meƴca kaanfaa, yaa koduk mooncaa leehoo. ");
INSERT INTO snf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Waa ennda ɗa, ɓuwaa ensee na kiwatuk Yéesuɗa, ɓaa ñaawalli, ɓaa feekki. ");
INSERT INTO snf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓa pokka hascaagarinaa, ɓa meekisiri an: - Líiruka, ɓii feekkaaɗa ɓa? ");
INSERT INTO snf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓa ɓaa íifi woꞌeen ciliis cisépíꞌíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ga waa Kooh wíisɗa, yaakcaa yaawúuꞌcaa na sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa hídohussa. Ɓa ɓaylukka Yéesu ga fíkíi paanaa wiyaakwaama. ");
INSERT INTO snf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɓa meekissari an: - Fu yërí en Músalkaatiine? Woꞌaaríi! Yéesu loffaɓa an: - Binaa mi woꞌꞌúukanaa, ɗú gëmanndiiroo, ");
INSERT INTO snf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ee binaa mi meekissúu yenaa, ɗú taasanndiiroo ga. ");
INSERT INTO snf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wayee iñaa aboh diima, Kowukii ɓii ƴah kiyuŋ ga yah-ñaabaa Kooh yaa wëñ ɓéeɓ dooliɗa. ");
INSERT INTO snf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɓuwaa ɓéeɓ meekisohussari an: - Kon fu yërí en Kowukii Koohe? Ya taassaɓa an: - Ɗú woꞌinka an mi yërí. ");
INSERT INTO snf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɓa dalla kiwoꞌ an: - Ɗu laakis ya sooli ga woꞌeen seedi? Ɗu kelohin ga kúuwci na kihaffuu! ");
INSERT INTO snf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Waa ennda ɗa, ɓu-paanaa ɓéeɓɓa kolukussa, ɓayussa Yéesu ga Pílaat. ");
INSERT INTO snf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Daama, ɓa ennda ga kipokiꞌti woꞌeencaa an: - Ɗí laak ɓii yii, yii hícísoh kúlkii: ya hoonohi ɓuwii kifay buuꞌ Sesaaꞌ lempu, ee ya woꞌ an ya en Kiristaa, buuꞌ. ");
INSERT INTO snf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pílaat meekissa Yéesu an: - Fu yërí en buurii yaawúuꞌciine? Yéesu taassari an: - Fu woꞌinka. ");
INSERT INTO snf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pílaat woꞌꞌa sarahohcaa ɓiyaakɓaa na mbooloomaa an: - Mi hottii iñaa ɓii yii tum bi cal buuꞌ tík yah gari. ");
INSERT INTO snf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wayee ɓa wëñnja kiyëgís ga woꞌeenaagaɓa an: - Ya yii yëngël ɓu-dëkii na iñcii ya en na kijëgírohɗa ga ɗuuƴ kúlkii Yúudée. Ya dalohnee gohaa Gëlílée, ya hayin bi dii. ");
INSERT INTO snf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Daa Pílaat kelohee woꞌeencaama, ya meekisohha an: - Ɓii yii dëk Gëlíléene? ");
INSERT INTO snf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ee waa ya ínohha an Yéesu meyoh gohaa Eroot en buuꞌ gaɗa, ya ebilohha kiɓay Yéesu ga Eroot, lak Eroot yaa ga Yéerúsaleem ga bescaama. ");
INSERT INTO snf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Daa Eroot hotee Yéesu, ya safaꞌta lool; ndaga ya waareera kihot Yéesu kimëeñíꞌ ndaga iñcaa ya kelohee ɓuwaa woꞌee ga Yéesuɗa, ee ya waareera kihot Yéesu tum kíntaan. ");
INSERT INTO snf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ya meekissari yen ciyewin, wayee Yéesu taassiiri. ");
INSERT INTO snf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sarahohcaa ɓiyaakɓaa na jëgíroh-waascaa ensee daama, ɓaa pokiꞌ Yéesu kiwoꞌ ga daa ɓa wëñ kimín. ");
INSERT INTO snf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eroot na soldaaꞌcaagari tíkussii Yéesu ɓoꞌ, ee ɓaa ñaawalsohhi, lëehíꞌta Eroot nakohha kiꞌek Yéesu kúltí fimóríꞌ, ya ebilohha kiɓoyukidoh Yéesu ga Pílaat. ");
INSERT INTO snf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eroot na Pílaat ga daa ɓa sagoheeɗa tóoh, enussa ɓifiiliimun bëríi. ");
INSERT INTO snf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pílaat hídírohha sarahohcaa ɓiyaakɓaa, na ɓuwaa kuliyuk ga yaawúuꞌcaaɗa, na iñaa en yaawúuꞌ tóoh, ");
INSERT INTO snf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ya woꞌꞌaɓa an: - Ɗú ɓërí haydoh ɓii yii garoo, ɗú woꞌ an ya en na kihícisoh kúlkii. Mi meekisinndi ga fíkíirúu ee mi hottii gari yen yíinoo ga iñcii ɗú yammbiɗa. ");
INSERT INTO snf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ee Eroot ɓan hottii dara gari, ndaga ya íkinnduuri. Kon ɓii yii tummbii yen yíinoo yaa cal ya tíku kikaan. ");
INSERT INTO snf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mi hay kitëmóhíꞌ faanci, mi íissi ya ƴee.  ");
INSERT INTO snf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wayee ɓuwaa ɓéeɓɓa bokussa kifiip an: - Apaa ɓuum yuma, ee fu lëgísiꞌtíi Barabaas! ");
INSERT INTO snf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabaas tëcsee ga kasu ndaga ya bokee ga heñaa na nguuraa Room laakee ga teeraaɗa ee ya apee ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pílaat ɓaatta kiwoꞌis na ɓuwaa ndaga ya waaree kiꞌíis Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wayee ɓaa fiip didóolíꞌ an: - Daayaari ga kuraa! Daayaari ga kuraa! ");
INSERT INTO snf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pílaat woꞌissa naɓa kotaa kukaahaykaa an: - Ɓii yii tum ya yibóníꞌ? Mi hottii dara gari iñaa tahan kumuunci hín ga. Kon mi hay kitëmóhíꞌ faanci, mi íissi ya ƴee! ");
INSERT INTO snf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wayee ɓa súɓpa ga rek, ɓa ɓaa fiip ga daa ɓa wëñ kimín an Yéesu daaƴsat ga kuraa. Tifiiptaa ɓuwaa wëñnja dooli: ");
INSERT INTO snf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pílaat dalla kiwoꞌ an ya hayɓa kitumiꞌ iñaa ɓa meekisohɗa. ");
INSERT INTO snf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ya méyíꞌtaɓa ɓaa ɓa meekisohee ee tëcsee ga kasu ndaga kiheñoh nguuraa Room na kiꞌap ɓoꞌɗa. Lëehíꞌta, ya tíkka Yéesu ga yahɓa, ɓa tum gari iñaa ɓa waaꞌ. ");
INSERT INTO snf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ga daa ɓa enee na kiɓay Yéesuɗa, ɓa hídohha na ɓoꞌ yiƴaal yaa meyoh yooncaa, teeku Simoŋ ee dëk Síreen. Ɓa ammbari, ɓa tíkkari kuraanaa, ya taam ga fenoo Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mbooloo wiyaak ga ɓu-dëkaa taabussa ga fenoo Yéesu, na ɓan ɓiɓeti ɓaa ensee ga kilooyoh, ɓaa fiipoh ndaga Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yéesu mëeñsukka gaɓa woꞌꞌaɓa an: - Ɗú, ɓeticii ɓu-Yéerúsaleem, kaa kodukattoo! Kodukat haffúu na towutiigarúu! ");
INSERT INTO snf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ndaga bes waa hay, waa ɓuwii woꞌan an: «Ɓeticii mínsoo kilaak kowu na ɓii mosoo kiꞌen na look ee mosoo kiɓëpíꞌɗa déy, yewinuunun múuꞌ!». ");
INSERT INTO snf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Leꞌ bëríinaa, ɓuwii hay kiwoꞌ jaŋjaŋcaa an: «Ɓúrat ga ɗookkíi!» ɓa woꞌ tëgëlcaa an: «Úubattíi!» ");
INSERT INTO snf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kon, en lak kedik kiꞌiilii kërí tumu aneenaa, haa kisúwíꞌkaa ƴah na kitumu? ");
INSERT INTO snf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓa ɓaydoheera tumoh-kofeel ɓanak ɓaa jomee kidaayu ga kuraa fodaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ga waa ɓa leꞌꞌa bi ga ɗekataa teeku «Loon-hafɗa», ɓa daaƴca Yéesu ga kuraa daama, ɓa daaƴca ɓan tumoh-kofeelcaa ɓanakɓaa, yaa en ɓéeɓ ga kuraa; yii hanohha Yéesu yah-ñaam, yíinoo hanohhari yah-seŋ. ");
INSERT INTO snf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yéesu woꞌꞌa an: - Buba, bayalaaɓa ga ndaga ɓa ínohoo iñii ɓa tumɗa. Ɓa yípohha tudooꞌ kiwaroh kúltícaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbooloomaa tuukka waa malak. Ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓaa ñaawalsoh Yéesu an: - Ya músalin ɓiɓoꞌ, kon ya músalat hafci en lakanaa yërí en Músalkaatii, yii Kooh tanɗanaa! ");
INSERT INTO snf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaaꞌcaa ɓan ɓaa ñaawalsohhi; ɓa deeƴca gari, ɓa eꞌtari biiñ wipiriikiꞌ, ");
INSERT INTO snf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ɓa woꞌꞌari an: - En lak fu yërí en buurii yaawúuꞌciinaa, somaa haffu! ");
INSERT INTO snf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Laakka ɓan iñaa bídu ga kuraanaa, tíimmba hafaa Yéesu an: «Ɓii yii yërí en buurii yaawúuꞌcii.» ");
INSERT INTO snf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yíinoo ga tumoh-kofeelcaa daayu ga kuraanaaɗa, yaa ɓas Yéesu, yaa woꞌꞌi an: - Hanaa enndii fu en Kiristaanii? Somaa haffu, fu sommbíi ɓan! ");
INSERT INTO snf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wayee yíinooyaa, yaa ñaꞌti, yaa woꞌꞌi an: - Hanaa fu niikkii Kooh, fu yii fu tíku kikaankii ya tíkuɗa? ");
INSERT INTO snf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kikaankii ɗu tíkuɗa kooꞌ ga waas, ndaga ɗu fayu iñcaa cibóníꞌcaa ɗu tumeeɗa, wayee ya, ya tummbii dara iñaa bonin. ");
INSERT INTO snf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lëehíꞌta ya woꞌꞌa Yéesu an: - Yéesu, leenaa níindísukaaroo, bëríinaa fu hayan ga nguuriigaraanaa. ");
INSERT INTO snf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yéesu taassari an: - Mi woꞌꞌaaka ee kayoh: wati fu ƴah kiꞌen naroo ga aljana. ");
INSERT INTO snf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ga ɓak mídí, nohaa ɗaakukka, ñúus wiyaak laakka ga ɗuuƴ kúlkaa ɓéeɓ, abohha ga wahtaama bi ga wahtu kigoonaluk. Rídóonaa ɗaak ɗekataa wiselaꞌíꞌwaa ga Kaanfaa Koohɗa, ɗaꞌta ga leꞌnaa. ");
INSERT INTO snf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yéesu fiippa didóolíꞌ an: - Buba, mi yii tík fítiigoo ga yahfu. Daa Yéesu woꞌee woꞌeencaama, ya lëehɗukka. ");
INSERT INTO snf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldaaraa yiyaakyaa kuliyuki ga heñɗa hotta iñcaa heweeɗa, yaa kañ Kooh an: - Wóorin an ɓii yii enee ɓoꞌ yijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɓéeɓ ɓuwaa hayee ga mbooloo wiyaak kilaaƴ ga iñaa heweeɗa, ga waa ɓa hotta iñaa laakɗa, keeñɓa leehha ga, ɓa ɓaa típ keeñcaa, ɓa ɓaa ɓoyuk kaanɓa. ");
INSERT INTO snf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Fiiliimuncaa Yéesu, na ɓeticaa meyohee nari gohaa Gëlílée bi daamaɗa, ceelussa palah, ɓaa malak ga iñaa hewɗa. ");
INSERT INTO snf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Laakeera daama ɓaa teeku Yoseef, ya dëkee Arímatee, teeru yaawúuꞌ. Ɓaa yaama enee ɓoꞌ yijófíꞌ, ɓoꞌ yijúwíꞌ ee ya abeera yaakaaꞌ lool ga kihaykaa Nguuraa Kooh. Ya bokee ga paanaa attiꞌohcaa wiyaakwaa, wayee ya júwohéeríi na attiꞌohcaa ga iñcaa ɓa abee kitum na iñcaa ɓa tumeeɗa. ");
INSERT INTO snf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ya kaꞌta ga Pílaat, ya meekissari faraaffaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Fodaama, ya yóoskíꞌta faraaffaa ga kuraanaa, ya múullafa ga píis fodii mëlíkaan, lëehíꞌta ya faanndafa ga noŋ-loyaa yotu ga atoh wiyaak, daa ken mossii ga kifaanu. ");
INSERT INTO snf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iñaama enee ga besaa waayukaa feetaa, lak Sabat waa ƴah kidal. ");
INSERT INTO snf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓeticaa daansee kitaam na Yéesu, iñaa aboh ga gohaa Gëlílée bi daamaɗa, taabukussa Yoseef; ɓa malakka loyaa, na daa faraaffaa Yéesu faanu gaɗa. ");
INSERT INTO snf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lëehíꞌta ɓa sooffa kihëwíꞌnee cúuraaycaa na laꞌkoleñcaa tumsan ga faraaffaa Yéesuɗa. Ga ɗuuƴ besaa Sabat, ɓa íikarukka fodaa daa Móyíis nakohkaɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Teel ga kímaa besaa tík ga besaa Sabatɗa, ɓeticaa karussa loycaa, ɓa ɓaydohha cúuraaycaa na laꞌkoleñcaa ɓa hëwíreeɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓa laak atohaa lagohsee loyaaɗa pírgínuunun diꞌúsaayíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɓa aassa ɗuuƴ loyaa wayee ɓa laakkii faraaffaa Yéesu, Haꞌmudii, daama. ");
INSERT INTO snf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ga dii ɓa enee daama na kijaahliꞌɓaɗa, laakka ƴaal ɓanak ɓaa ekuk kúltí cimélícíꞌ, meyussa gaɓa jalañ. ");
INSERT INTO snf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓeticaa tíitussa lool, híilussa kakay. Ɓuwaa ɓanak ɓaa woꞌussaɓa an: - Ɗú raas ɓaa en na kipes ya ga leeloo ɓuwaa kaaninɗa? ");
INSERT INTO snf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ya gaa dii; mílísin. Níindísukat iñaa ya woꞌeerúu lak ya lís ga Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ya woꞌeerarúu an: «*Kowukii ɓii, jomin tíku ga yah haꞌ-baakaaꞌcaa, ya daayu ga kuraa, ya kaan, ya mílís ga besaa wukaahaywaa.» ");
INSERT INTO snf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Daama, ɓa níindísukka woꞌeencaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓa kolkohha loycaa, ɓa ɓéestíꞌneera tóoh iñaama tëelíbéecaa ɓidaaŋkaah na yíinooyaa, na ɓéeɓ ɓuwaa tesɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓeticaa ensee Mërí yaa dëk Makdalaaɗa, Saan na Mërí eew Saak. Ɓeticaa ɓíinoo taamsee naɓaɗa ɓéestírussa apotaaꞌcaa fodaama ɓan. ");
INSERT INTO snf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wayee ɓa ammba woꞌeencaama fodii woꞌeen heeyoh, ee ɓa saŋnga kigëm iñaa ɓeticaa woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peeꞌ nak, kolukka yaa fool bi ga loyaa; ga waa ya leꞌꞌa, ya hëeɓɗukka, ya hotta daama lëmíicaa múulsee ga faraaffaaɗa. Ya jaahliꞌꞌa ga iñaa laakee yaama, ya yaa ɓoyuk kaanci. ");
INSERT INTO snf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ga besaa bëríi, laakka ɓoꞌ ɓanak ga tëelíbéecaa Yéesu ɓaa enee na kiƴah dëk-kawaa teeku Emayus. Wa úsaayohin na Yéerúsaleem iñaa hín na wahtu kanak ga kitíin. ");
INSERT INTO snf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɓa ɓaa saawal ga loo ɓéeɓ iñcaa laakee ga bescaamaɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ee ga dii ɓa enee na kiwoꞌ, na kisaawalɗa, Yéesu sah-sah daɓpaɓa, taammba naɓa. ");
INSERT INTO snf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wayee ɓa ínohsohhiiri ndaga lak man na hascaagaɓa kúnuk hen. ");
INSERT INTO snf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yéesu meekissaɓa an: - Ɗú en na kisaawalukoh ya ga waasii? Daama ɓa tuukka, keeñɓa leehha tak. ");
INSERT INTO snf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yíinoo gaɓa ee teeku Kelewopaas, loffari an: - Hanaa fu doŋ fu dëk Yéerúsaleem ee fu yéeŋngii iñcii hewee ga bescii ciiɗa! ");
INSERT INTO snf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yéesu meekissaɓa an: - Iñii hewee ya? Ɓa taassari an: - Hanaa iñaa aaw ga Yéesu Nasareet! Ya enee sëldíiga-Kooh yiyaak ga fíkíi Kooh na ga fíkíi ɓuwii ɓéeɓɓa: tumeencaagari yakeera ee woꞌeencaagari laakeera dooli. ");
INSERT INTO snf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wayee sarahohciigaríi ɓiyaakɓii na ɓuwii kuliyuk garíiɗa ɓayussari waas doo ya attiꞌu kikaan, ee ɓa daayinndi ga kuraa. ");
INSERT INTO snf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɗí yaakaareera an yërí en ɓaa ƴah kilaas ɓu-Isarayeelɗa. Wayee ɓaatta ga iñaama, wati wërí en besii wukaahaywii, iñaa iñcaama laakee bi wati. ");
INSERT INTO snf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","En kiꞌenaa, laakin ɓeticaa boku garíi, ee ɓa tahin hafciigaríi kikúnuk. Ga kím cuut, ɓa karin bi ga loyaa ");
INSERT INTO snf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ee ɓa hottii faraaffaa Yéesu daama. Ɓa ɓoyukka, kiwoꞌꞌíi an ɓa hotin sah malaakacaa feeñukɓa, woꞌussaɓa an Yéesu yaa pes. ");
INSERT INTO snf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Laakka ɓiɓoꞌ ga ɓuwaa ensee naríiɗa ɓaa kaꞌ bi ga loyaa, ɓa laakka tóoh fodaa daa ɓeticaa woꞌeekaɗa, wayee Yéesu ga kihafci, ɓa hottiiri. ");
INSERT INTO snf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yéesu dallaɓa kiwoꞌ an: - Ɗú daal, ɗú ɓërí lohoƴ hel ee ɗú ɓërí yéeh ga kigëm iñcaa sëldíiga-Koohcaa yéegaloheeɗa! ");
INSERT INTO snf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hanaa Kiristaanii joméeríiɗa kison, balaa ya aas ga ndamaagarine? ");
INSERT INTO snf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lëehíꞌta, Yéesu lëegísohiꞌtaɓa iñaa woꞌsee gari ga Këyítfaaɗa tóoh, daloh ga këyítcaa Móyíis bídeeɗa bi ga caa sëldíiga-Koohcaa ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ga waa ɓa hayya bi ɓa deeƴca dëkaa ɓa ƴahoheeɗa, Yéesu tummba en fan ɓaa ƴah kipaaf fíkíi. ");
INSERT INTO snf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wayee ɓa tëhdohhari, ɓa woꞌꞌari an: - Tesaa naríi ndaga nohii soosin ee wekii wii hay. Ya aassa kon, ya tessa naɓa. ");
INSERT INTO snf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ya yuŋnga naɓa kiñam, ya ɓeɓpa mbúuraa, ya gërëmmba Kooh ga; lëehíꞌta, ya weellawa, eꞌtaɓawa. ");
INSERT INTO snf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Waa ennda ɗa, hascaagaɓa kúnísukka, ɓa hanndari kiꞌínohsoh; wayee ga saasi, Yéesu ennda meles ga fíkíiɓa, ɓa hotissiiri. ");
INSERT INTO snf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɓa ɓaa woꞌ kon ga díkaantiɓa an: - Laakéeríi fodii keeñ-soos wiyaak ga ɗuuƴcuu, ga wii ya en na kiwoꞌ naruu ga waasaaɗa, ee ya yaa lëegísohiꞌtuu iñcaa bídu ga Këyítfaaɗane? ");
INSERT INTO snf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɓa dalla kikoluk, ɓaa soof Yéerúsaleem. Ɓa laakka daama tëelíbéecaa ɓidaaŋkaahɓaa na yíinooyaa, lakanaa hídírukohuunun na ɓuwaa ɓíinoo taamsee naɓaɗa, ɓaa woꞌɓa an: ");
INSERT INTO snf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","- Haꞌmudii mílísin kayoh-kayohɗa! Simoŋ hotinndi! ");
INSERT INTO snf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ee tëelíbéecaa ɓanakɓaa ɓaa ɓéestíꞌ ɓuwaa iñaa hewee ga waasaaɗa na daa ɓa ínohsohee Yéesu ga waa ya weel mbúuraa kiñamɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lak ɓa ɓaa lís kiwoꞌ, Yéesu ga kihafci meƴca jalañ ga leelooɓa, këñíꞌtaɓa an: - Jam enat narúu. ");
INSERT INTO snf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɓa yëecírukka, tíitussa lool ndaga ɓa foogee an ɓa hot raɓ. ");
INSERT INTO snf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wayee Yéesu woꞌꞌaɓa an: - Iñii tah hafciirúu kimúuƴ ya bi ɗú laaki hel kanak ga iñii ɗú hotɗa? ");
INSERT INTO snf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Malkat yahciigoo na kotciigoo: ɓii mi sah-sah! Leꞌat garoo ɗú malak, ndaga raɓ ɓayoo faan ɓayoo ƴoh fodii dii ɗú hot mi ɓayɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ga waa ya woꞌꞌa iñaama, ya teeɓpaɓa kotcaagari na yahcaa. ");
INSERT INTO snf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wayee ga daa keeñɓa sooseeɗa ee ɓa jaahliꞌaɗa ammbaɓa bi ɓa mínndii kigëm bi wati. Yéesu meekissaɓa an: - Ɗú laakin iñaa ɓoꞌ ñaman diine? ");
INSERT INTO snf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓa eꞌtari jën wiꞌútu ");
INSERT INTO snf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ya ɓeɓpawa, ñammbawa ga fíkíiɓa. ");
INSERT INTO snf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lëehíꞌta ya woꞌꞌaɓa an: - Ga wii mi en narúuɗa, mi woꞌeerúu an ɓéeɓ iñaa woꞌuunun garoo ee bíduunun ga këyítfaa Waasaa Móyíis, na këyítfaa sëldíiga-Koohcaa, na këyítfaa Kañcaa jomeera kilaak. ");
INSERT INTO snf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Waa ennda ɗa, Yéesu lëgísiꞌtaɓa helcaagaɓa doonaa ɓa ínoh iñaa bídu ga Këyítfaaɗa, ");
INSERT INTO snf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ya woꞌꞌa ɓa an: - Iñii yii yërí bídu: Kiristaanii hay kiꞌen ga coonu, lëehíraa ya mílís ga ɓuwaa kaanɗa, ga besaa wukaahaywaa, ");
INSERT INTO snf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ee daloh ga Yéerúsaleem, ɓuwii ga ëldúnaɗa tóoh jomin kijangatu, bi ɓa súpít kipeskaagaɓa, ɓa bayalu baakaaꞌcaagaɓa ga teekii Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɗú ɓërí en seedi ga iñcuma ɓéeɓca. ");
INSERT INTO snf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ee mi, mi hay kiwosoh garúu iñaa Paammboo dígoheeɗa; wayee ɗú, tesat ga dëkii bi ga daa ɗú úulsan na doolaa meyoh ɗook-Koohɗa. ");
INSERT INTO snf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lëehíꞌta Yéesu meƴdohha tëelíbéecaagari teeraa, ɓa kaꞌta bi ga ɓak dëkaa Bétaníi. Daama, ya ɓëwíꞌta yahcaagari, ya barkeellaɓa. ");
INSERT INTO snf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ee ga dii ya enee naɓa kibarkeelɗa, ya yaa tagoh naɓa, ya ɓëwírussa aawwa ɗook-Kooh. ");
INSERT INTO snf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tëelíbéecaa nak, ƴíꞌussa ga fíkíici ɓaa gërëm Kooh, lëehíꞌta ɓa ɓoyukka Yéerúsaleem na keeñ wisóosíꞌ. ");
INSERT INTO snf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ee besaa en ɓéeɓ, ɓa eni ga Kaanfaa Kooh, ɓa kañi Kooh.");
INSERT INTO snf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ga dalaaraa ëldúna, Woꞌeenaa eneera; ee ɓaa en Woꞌeenaaɗa enee na Kooh ee ya en Kooh. ");
INSERT INTO snf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ya enee na Kooh ga dalaaraa. ");
INSERT INTO snf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iñaa Kooh tum tóoh, kooroh gari. Laakkii iñaa en ee koorohhii gari. ");
INSERT INTO snf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kipes meyoh gari ee kipeskaa kërí enee leeꞌlaatii ɓuwii. ");
INSERT INTO snf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Leeꞌlaataa melicin ga ɗuuƴ ñúusii, ee ñúusii teꞌꞌiiwa. ");
INSERT INTO snf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Laakka ɓaa Kooh wos, ya teeksee Saŋ. ");
INSERT INTO snf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ya hayya fodii seedi, kiwoꞌ iñaa ya ínoh ga leeꞌlaataaɗa, en ɗanaa ya tah ɓéeɓ kigëm. ");
INSERT INTO snf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɓaa yaama enndii yërí en leeꞌlaatii wayee ya jomee kiseediꞌ leeꞌlaatii. ");
INSERT INTO snf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Leeꞌlaataama wërí en leeꞌlaatii wikayohwii, wa hay ëldúna kiléeríꞌ ɓaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɓaa en Woꞌeeniiɗa enee ga ëldúna; ee Kooh hëwíꞌta ëldúna koorohha gari; wayee ɓu-ëldúna ínohsohhiiri. ");
INSERT INTO snf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ya hayin ga ɓuunci, wayee ɓa tookkiiri. ");
INSERT INTO snf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wayee ɓuwii tookkiɗa, ɓii gëm ga teekiigariɗa, ya oninɓa kiꞌen ɓitowu Kooh. ");
INSERT INTO snf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓa enin ɓitowu Kooh, enndii fodii ɓaa límuk ga ɓoꞌ, wayee Kooh yërí onɓa kipeskaa kiꞌaskaama. ");
INSERT INTO snf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Woꞌeenaa ennda ɓoꞌ, ya hayya dëkka naruu, líiffa na ndam na kayoh. Ɗu hotin ndamiigari, ee ndamaama wërí en ndamaa, ya, Kowu kíinoo ga Paamudii, ya ɓewoh ga paamciɗa. ");
INSERT INTO snf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Saŋ seediꞌꞌari, yéegalohha iñii yii didóolíꞌ an: - Yërí mi woꞌeerúu ga waa mi woꞌ an: «ga fenooroo laakin ɓaa en na kihay ee yërí wëñnjoo kilaak solu, ndaga balaa minaa, lak ya enin.» ");
INSERT INTO snf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɓéeɓpúu ɗú laasin ga yërmaandiigari leehooɗa, ɗú ɓii barkeeluk ga rek. ");
INSERT INTO snf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Iñcii Kooh nakoh kitumɗa, koorohca ga Móyíis, wayee yërmaandii na kayohfiigari, Yéesu Kiristaa haydohca. ");
INSERT INTO snf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ken mosoo kihot Kooh, wayee Kowukii Kooh laak doŋ ee en Kooh, ee en ga yahaa Paamudiiɗa, teewinnduuri. ");
INSERT INTO snf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yaawúuꞌcaa ga Yéerúsaleemɗa wosussa ɓisarahoh na ɓiLéwít kimeekis Saŋ-Bëtís an: - Fu yërí en ɓa? Iñii yii yërí Saŋ seediꞌ. ");
INSERT INTO snf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ya woꞌꞌa faŋ ee ɗaakkii dara ga, ya woꞌꞌa ga fíkíi ɓéeɓ an: - Mi enndii Kiristaanii . ");
INSERT INTO snf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓa meekissari an: - Kon fu yërí en ɓa? Fu yërí en Ili, sëldíiga-Koohaane? Saŋ taassaɓa an: - Óꞌóo, mi enndiiri. Ɓa meekissari an: - Fu yërí en sëldíiga-Koohii jom kihayɗane? Saŋ taassaɓa an: - Óꞌóo. ");
INSERT INTO snf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Waa ennda ɗa, ɓa woꞌꞌari an: - Kon woꞌaaríi ɓii fu enɗa, ndaga ɓuwaa wossíiɗa, ɗí jomin kilaak iñaa ɗí woꞌanɓa. Fu woꞌ ya ga haffu? ");
INSERT INTO snf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saŋ taassaɓa an: - Mi yërí en koonaakii ɓii en na kiwoꞌ didóolíꞌ ga ɗuuƴ ëgíꞌ-dúndagii an: Yólóhɗat waasii Haꞌmudii ƴah kikoorohɗa! Iñaama yërí Ísayíi, sëldíiga-Koohaa woꞌee. ");
INSERT INTO snf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Laakeera ɓiFërísiyeeŋ ga ɓuwaa wossee ga Saŋɗa. ");
INSERT INTO snf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓa meekissari an: - Waa fu enndii Kiristaanii, fu enndii Ili, fu enndii sëldíiga-Koohii jom kihayɗa, kon iñii tah ya fu bëtísiꞌi ɓuwii? ");
INSERT INTO snf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Saŋ taassaɓa an: - Mi, mi bëtísiꞌꞌúu ga músú, wayee laakin ɓaa en ga ɗuuƴcúu, yaa ɗú ínohoo. ");
INSERT INTO snf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ya hay ga fenooroo ee joobinndoo sah kipëkís liiwaa ñafaraagari. ");
INSERT INTO snf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iñii laak yii hewee ga dëk-kawaa Bétaníi hanoh húlúwaa Yúrdeŋ gaa, ga ɗekataa Saŋ bëtísiꞌohee ɓuwaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ga kooh-wíisfaa, Saŋ hotta Yéesu yaa hay gari, ya woꞌꞌa ɓuwaa an: - Kubaalkii Kooh jee, yii hay kinís baakaaꞌcii ɓuwii ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yërí en ɓaa mi woꞌeeɗa. Mi woꞌee gari an: «Ga fenooroo, laakin ɓaa en na kihay ee yërí wëñnjoo kilaak solu, ndaga balaa minaa, lak ya enin. ");
INSERT INTO snf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi ga kihaffoo, mi ínohéeríi ɓaa enndiɗa, wayee mi hayin ëldúna kibëtísiꞌ ga músú doonaa ya ínohuk ga ɓu-Isarayeel .» ");
INSERT INTO snf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ga iñaama, Saŋ seediꞌꞌa an: - Mi hotin Helaa yiselaꞌíꞌyaa yoosukohha asamaan en fan hoꞌ, yammba ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi ínohéeríi ɓaa enndiɗa, wayee Kooh yaa wossoo kibëtísiꞌ ga músúɗa, yërí woꞌeeroo an: «Fu hay kihot Helaa yiselaꞌíꞌyaa yoosukoh asamaan yam ga ɗook ɓoꞌ. Ɓaa yaama yërí ƴah kibëtísiꞌ ga Helaa yiselaꞌíꞌyaa.» ");
INSERT INTO snf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Saŋ tíkka ga an: - Iñaama mi hotinndi, ee mi seediꞌ an ɓii yii yërí en Kowukii Kooh. ");
INSERT INTO snf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ga kooh-wíisfaa, Saŋ enissa daama, ya na tëelíbée ɓanak ga ɓaagari. ");
INSERT INTO snf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Daa ya hotee Yéesu yaa paaf, ya malakkari bi maañnja, ya woꞌꞌa an: - Malkat, yii en Kubaalkii Koohɗa, yeema! ");
INSERT INTO snf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tëelíbéecaa Saŋ ɓanakɓaa kelohussa woꞌeenaama, ɓa taabukka Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yéesu heelukka, ya hotta an ɓa ɓaa taabukki, ya meekissaɓa an: - Ɗú heel ya? Ɓa woꞌꞌari an: - Rabí, fu dëk gada? «Rabí» wërí en «Jëgírohii». ");
INSERT INTO snf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yéesu taassaɓa an: - Hayat, ɗú hot. Waa ennda ɗa, ɓa kaꞌta, ɓa hotta daa ya dëkɗa. Enee ga ɓak wahtu kilaagis na noh-soos. Ɓa ennda nari iñaa tes ga besaa bëríiɗa. ");
INSERT INTO snf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yíinoo ga ɓuwaa ɓanakɓaa kelohsee woꞌeenaa Saŋ, taabukussa Yéesuɗa, enee Andari, këmëeŋkí Simoŋ-Peeꞌ. ");
INSERT INTO snf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andari ɗeɓpa kikaꞌ ga Simoŋ, yaakci sah-sah, woꞌꞌari an: - Ɗí hotin Mesíinii. «Mesíi» wërí en «Músalkaataa Kooh falɗa»: Kiristaanii . ");
INSERT INTO snf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Waa ennda ɗa, ya ɓayya Simoŋ ga Yéesu. Yéesu malakka Simoŋ bi maañnja, woꞌꞌari an: - Fu en Simoŋ, kowu Saŋ. Fu teeksan Kefaas. «Kefaas» ga kiꞌArameyee wërí en «Peeꞌ-atoh». ");
INSERT INTO snf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ga kooh-wíisfaa, Yéesu ɓewukka kiƴah gohaa Gëlílée, ya hotta Filiip, ya woꞌꞌari an: - Taabukaaroo! ");
INSERT INTO snf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filiip kúlkohee Betsaydaa, dëkaa Andari na Peeꞌ dëkohɗa.) ");
INSERT INTO snf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lëehíꞌta, Filiip kaꞌta ga Natanayeel, woꞌꞌari an: - Ɗí hotin ɓaa woꞌsee ga Këyítfaa Waasaa Móyíisɗa, yaa sëldíiga-Koohcaa yéegaloheeɗa. Yéesu yërí, kowu Yoseef, ga teeraa Nasareet. ");
INSERT INTO snf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayeel woꞌꞌari an: - Nasareete? Enaama yijófíꞌ mínin daama kimeyohe? Filiip woꞌꞌari an: - Haya, fu hot. ");
INSERT INTO snf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yéesu hotta Natanayeel yaa hay gari, ya dalla kiwoꞌ gari an: - Kowu Isarayeel kayoh-kayohɗa yeema! Ya laakoo caahan. ");
INSERT INTO snf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayeel meekissari an: - Fu ínohohhoo gada? Yéesu taassari an: - Balaa Filiip ɓayyaanaa, mi hotee garaa lak fu yaa ga bosaa eenaa. ");
INSERT INTO snf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayeel woꞌꞌa Yéesu an: - Jëgírohii, fu yërí en Kowukii Kooh, fu yërí en buurii ɓu-Isarayeel. ");
INSERT INTO snf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yéesu loffari an: - Dii mi woꞌꞌaa an mi hotee garaa ga bosaa eenaaɗa tahhaa kigëme? Fu hay kihot enaama ciliis caa wëñ kiyak! ");
INSERT INTO snf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lëehíꞌta Yéesu tíkka ga an: - Kayoh-kayohɗa mi woꞌꞌúuka. Ɗú hay kihot asamaanii lëgísuk, malaakacaa Kooh lapi ɗook asamaan ee ɓa yoosuki kakay ga Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bes kanak tíkka ga hewhewcaama, sëgílook laakka ga teeraa Kanaa, ga gohaa Gëlílée. Eew Yéesu enee daama. ");
INSERT INTO snf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yéesu ɓan nakseera sëgílookfaa, ya na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ga ɗuuƴ hewaa, biiñaa leehha, eeci woꞌꞌari an: - Ɓa laakissii biiñ! ");
INSERT INTO snf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yéesu taassari an: - Yaꞌɓu, mi naraa ga ya, ee wahtiigoo leꞌꞌii duum? ");
INSERT INTO snf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eew Yéesu woꞌꞌa súrgacaa ga kaanfaaɗa an: - Iñaa ya woꞌꞌúunaa, tumatti! ");
INSERT INTO snf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Laakeera daama tataa-atoh tiyitniinoo tiyaak, taa yaawúuꞌcaa tumee músú ga, kisétíꞌsirukoh ga fíkíi Kooh. Ee kaa en ɓéeɓ míneera kitum iñaa leꞌ líitaꞌ citéeméeꞌ ga músú. ");
INSERT INTO snf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yéesu woꞌꞌa súrgacaa an: - Neꞌat músú ga tataatii bi ta líif! Ɓa neꞌꞌata bi ta líiffa muut. ");
INSERT INTO snf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Waa ennda ɗa, Yéesu woꞌꞌaɓa an: - Diimaɗa, hafat ɗú ɓayiꞌ ɓaa tuukuk sëgílookfiiɗa. Ɓa ɓayiꞌtari ga. ");
INSERT INTO snf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɓaa tuukuk sëgílookfaaɗa ƴoohha músúmaa súpítu biiñɗa. Ya ínohéeríi daa biiñaa meyohɗa, wayee súrgacaa hafee músúmaaɗa ínohseera iñaa laakɗa. Ɓaa tuukuk sëgílookfaaɗa ɓayya haꞌ-sëgílookfaa, ");
INSERT INTO snf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","woꞌꞌari an: - Ɓuwii ɗewi kihafoh biiñii wineɓlaatwii, binaa ɓuwaa an bi faancaa tamohaa, ɓa mëeñdoh kihafoh waa tesohin kineɓɗa. Fu nak, fu ɗaakin biiñii wëñ kineɓɗa bi ga wahtii wii. ");
INSERT INTO snf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kíntaanaama wërí Yéesu ɗeɓ kitum, ee enee ga Kanaa ga gohaa Gëlílée. Fodaama ya teewohha ndamaagari ee tëelíbéecaa gëmussa gari. ");
INSERT INTO snf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Waa ennda ɗa, Yéesu kaꞌta teeraa Kafarnawom, ya na eeci na këmëeŋkímuncaagari ɓiƴaalɓaa na tëelíbéecaagari. Ɓa tessa daama bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lakanaa Paakaa yaawúuꞌcaa deeyin, Yéesu kaꞌta Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya laakka ga ɗuuƴ Kaanfaa Kooh ɓuwaa enu na kitoon enoh, kitoon baal na kitoon hoꞌ. Ya laakka weciꞌoh-kopaꞌcaa daama ɓan, laruunun. ");
INSERT INTO snf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ya ɓeɓpa níꞌ, ya hëwíꞌta leraw ga, ya kaallaɓa ɓéeɓɓa ɓa meƴ Kaanfaa Kooh, ɓa na baalcaagaɓa na enohcaagaɓa. Ya tasarsohha koparaa weciꞌohcaa, ya petisohha laꞌcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ya woꞌꞌa toonoh hoꞌcaa an: - Meƴdohat iñcii cii dii! Kaa tumat kaanfii Paammboo ditoonaaꞌ! ");
INSERT INTO snf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tëelíbéecaagari dalla kiníindísuku iñaa bídu ga Këyítfaaɗa an: «Éeƴ Kooh, waarii mi waaꞌ kaanfiigaraaɗa. Ee kiwaaꞌkiima kii ëbíꞌtoo fodii kiwii.» ");
INSERT INTO snf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Waa ennda ɗa, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa woꞌussari an: - Tumaa Kíntaan, fu teeɓpíi an fu ga kayoh ga iñii fu tum yii! ");
INSERT INTO snf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yéesu loffaɓa an: - Ɓúrat Kaanfii Kooh, tík ga bes kaahayaa mi ɓëwíꞌfa. ");
INSERT INTO snf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yaawúuꞌcaa woꞌussari an: - Kitawah Kaanfii Kooh fii tumin tíkíis tidaaŋkaah-nikiis na tiyitniinoo ee fu, an fu ƴahfa kiɓëwíris ga bes kaahaye? ");
INSERT INTO snf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wayee nak Kaanfaa Kooh Yéesu woꞌeeɗa, faanfaagari fërí. ");
INSERT INTO snf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kërí tah ga waa Yéesu mílíssa ga ɓuwaa kaanɗa, tëelíbéecaagari níindísukussa an ya woꞌeera iñaa yaama. Ɓa gëmmba kon iñaa bídu ga Këyítfaaɗa na woꞌeencaa Yéesu woꞌeeɓaɗa. ");
INSERT INTO snf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ga feetaa Paakaa Yaawúuꞌcaa, Yéesu enee ga Yéerúsaleem. Daa ɓiɓoꞌ ɓiyewin hotsee kíntaancaa ya tumeeɗa, ɓa gëmmba gari. ");
INSERT INTO snf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wayee Yéesu, ya ga kihafci, óolukéeríiɓa ndaga ɓéeɓɓa ya ínoheeraɓa dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","En kiꞌenaa, Yéesu soolukéeríi ɓoꞌ woꞌꞌi yen ga ɓoꞌ-súusúus, ndaga ya ga kihafci, ya ínohin iñaa en ga keeñ ɓaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Laakeera ɓoꞌ yaa bokee ga Fërísiyeeŋcaa. Ya teeksee Níkodeem ee ya bokee ga ɓuwaa kuliyuk ga yaawúuꞌcaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ya hayya ga Yéesu ga wek, ya woꞌꞌari an: - Jëgírohii, ɗí ínohin an Kooh yërí wossaa kijëgíꞌtíi. En kiꞌenaa, ken mínoo kitum kíntaancii fu tumiɗa enndii an Kooh taam narinaa. ");
INSERT INTO snf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yéesu taassari an: - Kayoh-kayohɗa mi woꞌꞌaaka: Ken mínoo kihot Nguurii Kooh enndii an ya límukis henaa. ");
INSERT INTO snf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Níkodeem meekissari an: - Ɓaa kasohin límukisan na? Ya mínan na kiɓoyukis lookaa eeci, ya límukis? ");
INSERT INTO snf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yéesu taassari an: - Kayoh-kayohɗa mi woꞌꞌaaka: ɓaa fu límukkii ga músú na Helaa Koohaa, fu mínoo kiꞌaas ga Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iñaa límuk ga ɓoꞌ, iñaa ɓoꞌ ee iñaa límuk ga Helaa Kooh iñaa hel. ");
INSERT INTO snf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kaa jaahliꞌ ga dii mi woꞌꞌaa an «Ɗú jomin kilímukisɗa». ");
INSERT INTO snf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Uurisii, daa neɓwanaa wa wëp ëewruk da. Fu kelohi gawa ee fu ínohoo daa wa meyoh, fu ínohoo daa wa aaw. Man fodaama ga ɓéeɓ ɓaa límuk ga Helaa Kooh. ");
INSERT INTO snf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Waa ennda ɗa, Níkodeem meekissari an: - Iñaama mín na kiꞌen? ");
INSERT INTO snf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yéesu taassari an: - Fu, fu jëgíroh yiyaak ga ɗuuƴ heetii Isarayeel ee fu ínohoo iñcumane? ");
INSERT INTO snf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kayoh-kayohɗa mi woꞌꞌaaka: ɗí woꞌ iñaa ɗí ínoh ee ɗí ɓéestíꞌ iñaa ɗí hotin, wayee ɗú, ɗú gëmmbii iñii ɗí seediꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi woꞌ narúu ga iñaa aaw ga ëldúna, ɗú gëmmbiiroonaa, binaa mi woꞌ narúu ga iñaa aaw ga Koohaa ɗú mínanndoo na kigëm? ");
INSERT INTO snf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ken mosoo kikolkoh ëldúna ya lap asamaan, enndii Kowukii ɓii yoosukoh asamaanɗanaa. ");
INSERT INTO snf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Fodaa daa Móyíis ɓëwíree goŋ-përëmaa ga ëgíꞌ-dúndagaa doonaa ɓaa en ɓéeɓ hotwaɗa, fodaama ɓan mi, Kowukii ɓii, mi ɓëwíꞌsan ɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","En ɗanaa ɓaa gëm garoo ɓéeɓ laas ga kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ndaga Kooh waaꞌ ɓu-ëldúna hen bi, ya erohha Kowukiigari ya laak doŋɗa, doonaa ɓéeɓ ɓaa fu gëm gakanaa, fu saŋkuꞌoo, wayee fu laas ga kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","En kiꞌenaa, Kooh wossii Kowukiigari ga ëldúna kiꞌattiꞌ ɓu-ëldúna, wayee ya woska ka músal ɓu-ëldúna. ");
INSERT INTO snf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ɓaa gëm ga Kowukii, attiꞌsoo. Wayee ɓaa gëmmbii gakanaa, yaama attiꞌuunun kumëeñíꞌ ndaga ya gëmmbii ga teekii Kowukii Kooh, kii ya laak doŋɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ee ya ƴah kiꞌattiꞌu ga iñii yii: Leeꞌlaatii hayin ëldúna, wayee ɓuwii, ñúusii gënëlɓa leeꞌlaatii, ndaga ɓa tumi yibóníꞌ. ");
INSERT INTO snf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ɓaa tumi yibóníꞌ, waaꞌtii kihot ga leeꞌlaatii ee ya deeyoo ga, ndaga ya niik tumeencaagari cibóníꞌcaa wíiñuk. ");
INSERT INTO snf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wayee ɓaa tumi iñaa en kayoh, deeyi ga leeꞌlaatii. En ɗanaa, leeꞌ ga fíkíi ɓéeɓ an iñcaa ya tumɗa, ya taam ga na Kooh. ");
INSERT INTO snf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ga waa iñaama paaffa, Yéesu kaꞌta na tëelíbéecaagari gohaa Yúudée. Ya ennda naɓa daama bi sammba kimaañ, ya yaa bëtísiꞌ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saŋ-Bëtís ɓan bëtísiꞌee ga Aynoŋ, ga yahaa teeraa Salím. Ɗekataama yewineera músú ee ɓuwaa ɓaa hay gari daama, ya yaa bëtísiꞌɓa. ");
INSERT INTO snf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Waama, lak Saŋ lagussii ga kasu duum. ");
INSERT INTO snf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iñaama haydohha nookoh-woꞌeen ga díkaanti tëelíbéecaa Saŋ na yaawúuꞌ yíinoo, ga loo baah kisétíꞌsiruk ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓa kaꞌta ga Saŋ, ɓa woꞌꞌari an: - Jëgírohii, ɓaa yaama enee naraa ga ɓakaa hanoh húlúwaa Yúrdeŋ gaa, ee fu seediꞌeera yen gariɗa, diima nak ya yaa bëtísiꞌ ee ɓéeɓ ɓuwii ɓii ƴah gari. ");
INSERT INTO snf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saŋ taassaɓa an: - Ken mínoo kilaak dara, enndii an Kooh yërí onndirinaa. ");
INSERT INTO snf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɗú ga kihaffúu, ɗú míninndoo kiseediꞌ an mi woꞌeera an: «Mi enndii Kiristaanii wayee mi wosu kiɗëwírukki.» ");
INSERT INTO snf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kílook kuu haꞌ-kílook. Fiiliimunii haꞌ-kílookkii, yii deeyi ga yahaaci súkúrukiriɗa, keeñci soosin lool ga kikeloh koonaakiigari. Keeñnjoo hín ɗa kisoos, ee diimaɗa wa soosin bi matin sëk. ");
INSERT INTO snf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ya, ga kihafci, teekiigari jom kiwëñ kisíw ee wiigoo aaw kiƴím. ");
INSERT INTO snf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yii meyoh ɗookɗa yërí hanoh ɓéeɓ ɗook. Ɓaa meyoh ëldúna, bok ga ɓu-ëldúna ee ya woꞌi woꞌeen ëldúna. Ɓaa meyoh ɗook ga Kooh yërí hanoh ɓéeɓ ɗook. ");
INSERT INTO snf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ya woꞌ iñaa ya hotɗa na iñaa ya kelohɗa ee ken gëmmbii iñii ya seediꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɓaa gëm iñii ya seediꞌɗanaa, lak teewohin an Kooh woꞌi kayoh. ");
INSERT INTO snf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","En kiꞌenaa, ɓaa Kooh wosɗa, woꞌi woꞌeencaa meyoh ga Kooh, ndaga Kooh sorinndi bi líifin na Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Paamudii waarin Kowukii ee tíkin tóoh ga yahci. ");
INSERT INTO snf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ɓaa fu gëm ga Kowukiinaa fu laasin ga kipeskaa leehoo taaꞌɗa. Ee ɓaa fu saŋ kigëm ga Kowukiinaa, fu laasanndii ga kipeskaa leehoo taaꞌɗa ee aylukaa Kooh dëkan ga ɗookfu. ");
INSERT INTO snf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fërísiyeeŋcaa kelohussa ɓéestíraa an Yéesu yërí wëñíꞌ Saŋ tëelíbée, ee yërí wëñ Saŋ kibëtísiꞌ ɓiɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(En kiꞌenaa, Yéesu na kihafci bëtísiꞌéeríi ken, tëelíbéecaagari rek ɓërí bëtísiꞌee ɓuwaa). ");
INSERT INTO snf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Daa ɓéestíraama leꞌee ga Yéesu, ya kolkohha gohaa Yúudée, ya yaa ɓoyuk gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ga waa ya en na kiƴahɗa, ya húusohha gohaa Samaríi. ");
INSERT INTO snf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yéesu leꞌꞌa kon teeru wíinoo daama ga gohaa Samaríi. Teeraama teeku Síkaaꞌ ee en ga yahaa yoonaa Yakoop onee Yoseef, Kowukaagariɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Neꞌaa Yakoop enee daama. Daa Yéesu tíidee bi ya sonnda, ya dalla kiyuŋ ga píndaa neꞌaa. Enee ga ɓak mídí. ");
INSERT INTO snf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Laakka ɓetifaa dëk Samaríi hay kineꞌ ga neꞌaa. Yéesu woꞌꞌa ɓetifaa an: - Onaaroo músú, mi an! ");
INSERT INTO snf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Lakanaa tëelíbéecaa Yéesu karuunun teeraa kilomnee iñaa ɓa ñaman.) ");
INSERT INTO snf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɓetifaama ee dëk Samaríiɗa, taassa Yéesu an: - Fan na? Fu, fu Yaawúuꞌ, fu kíimmboo músú kiꞌan, mi yii mi bok ga ɓu-Samaríiɗa? (Ɓetifaa woꞌee iñaama ndaga yaawúuꞌcaa na ɓu-Samaríi haɓséeríi ga kuꞌon peꞌ.) ");
INSERT INTO snf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yéesu taassa ɓetifaa an: - Fu ínohee iñaa Kooh onohi ee fu ínohee ɓii kíimmbaa músúɗanaa, eneenaa fu ga kihaffu, fu kíimanndi, ya onndaa ga músúmaa onohi kipesɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɓetifaa woꞌꞌa Yéesu an: - Kiyaakii, fu laakoo hoc ee neꞌii huutin. Fu ɓewohan músúmaa onohi kipesɗa gaɗa? ");
INSERT INTO snf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Neꞌii wii caasammbíi Yakoop aciꞌtíiwa. Ya na kihafci, ya annda ga. Towutaagari na júuraagari anussa ga ɓan. Fu, fu halaat an fu wëñnji kilaak solune? ");
INSERT INTO snf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yéesu taassari an: - Músúmii neꞌii wii, ɓaa an ganaa hay kilís kipíl. ");
INSERT INTO snf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wayee ɓaa an ga músúmaa mi eranndiɗa, pílsisoo taaꞌ. Hanaa kay, músúmaa mi ƴahhi kiꞌonɗa ƴah kuhaalaa músú ga ɗuuƴci, kaa onohan kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɓetifaa woꞌꞌa Yéesu an: - Kiyaakii, onaaroo músúmaama, en ɗanaa mi pílsisoo ee calsisooroo kihay bi ga dii, kineꞌ músú. ");
INSERT INTO snf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yéesu woꞌꞌari an: - Kara! Ɓaynaa ƴaalfu, fu hayis dii. ");
INSERT INTO snf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɓetifaa taassa Yéesu an: - Mi laakoo ƴaal! Yéesu woꞌꞌari an: - Fu woꞌ an fu laakoo ƴaalaa, fu woꞌ kayoh. ");
INSERT INTO snf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","En kiꞌenaa, fu laakeera ƴaal ɓiyëtúus. Ee yii fu en nari diimaɗa enndii ƴaalfu. Kon iñii fu woꞌɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɓetifaa woꞌꞌa Yéesu an: - Kiyaakii, mi hotin an fu sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Woꞌaaroo ɓii en ga kayoh ɓa? Caasamunciigaríi jaamuksee Kooh ga ɗook jaŋjagii wii. Wayee ɗú, yaawúuꞌcii, ɗú woꞌ an ɗekataa jom kijaamukohu Koohɗa en ga Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yéesu woꞌꞌari an: - Ɓetifii, gëmaa iñii mi ƴahhaa kiwoꞌɗa. Wahtu waa hay, waa ɗú karoo ga jaŋjaŋ ee ɗú karoo Yéerúsaleem kijaamuk Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɗú, ɓu-Samaríi, ɗú jaamuki Kooh ee ɗú ínohoori. Ɗí yaawúuꞌcii, ɗí ínohin ɓii ɗí jaamukiɗa, ndaga kimúckii meyoh ga yaawúuꞌcii. ");
INSERT INTO snf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wayee wahtii wii hay ee weema sah. Diimaɗa ɓuwii jaamuk Paamudii kayoh-kayohɗa, jaamuksanndi ga hel na ga daa ya man kayoh-kayohɗa. En kiꞌenaa, ɓuwaa jaamuki fodaamaɗa ɓërí Paamudii heel. ");
INSERT INTO snf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kooh, Hel. Ee ɓuwii jaamukiriɗa ɓa jommbi kijaamuk na hel na ga daa ya man kayoh-kayohɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɓetifaa woꞌꞌa Yéesu an: - Mi ínohin an Músalkaataa Kooh falɗa ee ɓaysi Kiristaaɗa, hay kihay. Binaa ya hayaa, ya hayyíi kilóogísoh tóoh. ");
INSERT INTO snf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yéesu woꞌꞌari an: - Mi yërí, mi yii mi woꞌ naraaɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ga wahtaama, tëelíbéecaa Yéesu leꞌussa. Ɓa jaahliꞌꞌa lool ga daa ɓa laak Yéesu yaa saawal na ɓetiɗa. Wayee laakkii yíinoo gaɓa yaa kaañnji kimeekis an: «Fu meekisoh ya?» wala «Fu waaꞌ ya gari?» ");
INSERT INTO snf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Waa ennda ɗa, ɓetifaa foñnja kujataakaagari daama, foolla teeraa, woꞌꞌa ɓuwaa an: ");
INSERT INTO snf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","- Hayat ɗú malak! Mi hídohin na ɓoꞌ, yaa woꞌinndoo tóoh iñaa mi mosin kitum. Enndii Kiristaanii moose? ");
INSERT INTO snf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Fodaama, ɓuwaa ɓaa meyoh teeraa ɓaa hay ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tummba lak tëelíbéecaa ɓaa gítín Yéesu an: «Jëgírohii, ñama kay!» ");
INSERT INTO snf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wayee Yéesu woꞌꞌaɓa an: - Laakin ñamah waa mi ñaman, ee ɗú ínohoowa. ");
INSERT INTO snf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tëelíbéecaa ɓaa woꞌ ga díkaantiɓa an: - Hanaa laak ɓaa haydohiꞌti ñamah. ");
INSERT INTO snf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wayee Yéesu woꞌꞌaɓa an: - Ñamahhoo wërí en mi tum iñaa neɓ ɓaa wossooɗa, ee mi lëstíꞌ iñii ya nakkooɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɗú woꞌi ga kihaffúu an: «tes ga ñiin cinikiis kipíik leꞌe»? Wayee mi woꞌꞌúu an: «malkat dijófíꞌ, ndaga yooncii súwin haat ee sek píikoh. ");
INSERT INTO snf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Píikohii laasin fayaagari ee ya yii nëgíroh boŋcii en ɓuwii ƴah kipes bi taaꞌɗa. En ɗanaa ɓaa sokeeɗa na ɓii ƴah kipíikɗa boku kineɓluk.» ");
INSERT INTO snf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cahii woꞌin kayoh ga daa wa woꞌ an: «Yii sokaa, yii píik.» ");
INSERT INTO snf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi wosinndúu kipíik yoonaa ɗú línndii. Ɓiɓoꞌ ɓiliis ɓërí sodee ga ee ɗú, ɗú ñammba ga anagaagaɓa. ");
INSERT INTO snf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɓiɓoꞌ ɓiyewin ga teeraa waama ga Samaríiɗa, gëmussa ga Yéesu ndaga woꞌeenaa ɓetifaa woꞌɓa an: «Iñaa mi mosin kitum tóoh ya woꞌinndoori.» ");
INSERT INTO snf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kërí tah ɓu-teeraa Samaríi, daa ɓa hayee bi ga Yéesu, ɓa ɓaa kíimmbi, ya tes naɓa. Yéesu tessa daama bes kanak. ");
INSERT INTO snf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɓuwaa gëm ga Yéesu ndaga woꞌeencaagari ya ga kihafciɗa, wëñnja kiyewin. ");
INSERT INTO snf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓa ɓaa woꞌ ɓetifaa an: - Enndii an iñii fu woꞌꞌíiɗa tah bi ɗí gëm gari, wayee ɗí ga kihaffíi, ɗí súkúrukinndi. Ee ɗí gëmin an Yéesu yërí en Músalkaatii ëldúna sah-sah. ");
INSERT INTO snf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yéesu tummba bes kanak ga ɗekataama, lëehíꞌta ya kolkohha daama yaa ƴah gohaa Gëlílée. ");
INSERT INTO snf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","En kiꞌenaa, ya ga kihafci, ya woꞌeera an: «Laakkii sëldíiga-Kooh, yaa onu céeꞌ ga dëkaa ya meyohɗa.» ");
INSERT INTO snf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ga waa ya leꞌ Gëlíléeɗa nak, ɓuwaa teerukussari dijófíꞌ, ndaga ɓa ɓan, ɓa kareera Yéerúsaleem ga hewaa Paakaa yaawúuꞌcaa ee ɓa hotin ɓéeɓ iñcaa ya tumee daama ga feetaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Waa ennda ɗa, ya kaꞌsissa teeraa Kanaa ga gohaa Gëlílée. Daama dërí ya súpítee músúmaa ma ennda biiñ. Wiima, lak laakin ga Kafarnawom, ɓoꞌ yaa lëgëyiꞌ buuꞌ. Ɓaama, kowukaagari kiƴaalkaa kërí ɗúukoolee. ");
INSERT INTO snf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Daa ya kelohee an Yéesu meyohin gohaa Yúudée, hayin gohaa Gëlílée, ya kaꞌta gari. Ya kíimmbari ya hay Kafarnawom kiwëkíꞌ kowukaagari ɗúukoolin bi kaa ƴah kikaanɗa. ");
INSERT INTO snf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yéesu woꞌꞌari an: - Enndoo kat ɗú hottii kíntaan na mandarga cidóoyíꞌ-waaraa, ɗú gëmoo taaꞌ! ");
INSERT INTO snf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wayee ɓaa woꞌꞌari an: - Kiyaakii, hay ɗu gaaw kiƴee bi kowukaagoo kaanaa! ");
INSERT INTO snf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yéesu woꞌꞌari an: - Kara, kowukaagaraa wakin, kaa pes! Ɓaa gëmmba iñaa Yéesu woꞌꞌiɗa, ya yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ga daa ya en na kiɓoyuk kaanciɗa, súrgacaagari ɓaa hay kihídoh nari, ɓa woꞌꞌari an: - Kowukaagaraa wakin, kaa pes. ");
INSERT INTO snf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ya meekissaɓa wahtaa ɓa hotee kitani ga kowukaagariɗa. Ɓa taassari an: - Enee wútúwaa, ga wahtu cuunoh; tamohlaataa faanfaa ƴím ga. ");
INSERT INTO snf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Paam oomaa-ƴaalaa dalla kiꞌínoh an wahtaama siiƴ wërí Yéesu woꞌeeri ga an: «Kowukaagaraa wakin, kaa pes.» Meyoh daama, ya gëmmba ga Yéesu, ya na ɓu-kaanci ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wiima wërí en kíntaanii wukanakwii Yéesu tum, ga waa ya meyoh gohaa Yúudée ya kaꞌta Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ga bescaa tík gaɗa, yaawúuꞌcaa laakussa feet ee Yéesu kaꞌta Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ga teeraama nak, laakeera mbalka músú waa ɓookkohsi ga yahaa halaa teeku «halaa baalcaaɗa». Mbalkaama woꞌsi ga kiꞌEbërëe «Betsataa». Mbaaꞌ ciyëtúus cërí yípu, wíillawa. ");
INSERT INTO snf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ga fíldoo mbaaꞌcaama, ɗúukoolíꞌ ɓiyewin faanuksee daama: ɓibúumíꞌ, ɓiɓéedúkíꞌ na ɓilafañ. … ");
INSERT INTO snf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Laakeera daama ɓoꞌ yiƴaal, yaa iñaa ya ɗúukoolee tumin tíkíis tidaaŋkaah-kaahay na tiyitnataahay. ");
INSERT INTO snf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yéesu hottari lak ya faanukin ee ya ínohha an ɗúukoolaagari maañin lool, ya meekissari an: - Fu waarin kiwake? ");
INSERT INTO snf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɗúukoolíraa taassa Yéesu an: - Kiyaakii, mi laakoo ken ɓaa ekanndoo ga mbalkii binaa músúmii yëngëlukaa. Wahtaa mi jéem kiꞌaas ga tóoh, ɓoꞌ yiliis ɗeɓpoo kiꞌaas. ");
INSERT INTO snf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yéesu woꞌꞌari an: - Kolka, ɓewaa gataniigaraa fu tíin. ");
INSERT INTO snf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ga saasi ɓaa wakka. Ya ɓeɓpa gatanaagari, ya yaa tíin. Bëríinaa iñii laakohɗa nak enee bes Sabat. ");
INSERT INTO snf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yaawúuꞌcaa woꞌussa ɓaa wëkɗuseeɗa an: - Wati bes Sabat ee Waas onndiiraa kikooruk gataniigaraa! ");
INSERT INTO snf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɓaa taassaɓa an: - Aaꞌ, ɓaa wëkíꞌtooɗa kat yërí woꞌꞌoo an: «Ɓewaa gataniigaraa, fu tíin.» ");
INSERT INTO snf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓa meekissari an: - Haa, ɓaa yaama woꞌꞌaa an «ɓewaa gataniigaraa fu tíinɗa» ya ɓa? ");
INSERT INTO snf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wayee ɓaa wëkɗuseeɗa ínohéeríi ɓaa wëkíꞌtiɗa, ee lak Yéesu múuyin ga ɗuuƴ ɓuwaa enee daamaɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ga waa iñaama paaffa, Yéesu hídohha na ɓaa ya wëkɗeeɗa ga Kaanfaa Kooh, ya woꞌꞌari an: - Man diima fu wakin. Kaa tumis baakaaꞌ, doonaa iñaa wëñ yii kiyiis dalooraa. ");
INSERT INTO snf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɓaa kaꞌta, woꞌneera yaawúuꞌcaa an Yéesu yërí wëkíꞌti. ");
INSERT INTO snf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iñaama tahha bi yaawúuꞌcaa ekussa Yéesu peeꞌ ga kumuun ndaga daa ya wëkɗin ɓoꞌ ga bes Sabatɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wayee Yéesu ñaassaɓa perem an: - Paammboo yii lís kilëgëy, mi ɓan, mi yii lëgëy. ");
INSERT INTO snf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iñaa Yéesu woꞌ yaama wëñnja kitah bi yaawúuꞌcaa tuukka ga kiheelli kiꞌap. Ndaga ya eemmbii ga kikëldúk iñaa Waasaa onoh kitum ga bes Sabatɗa, wayee ya woꞌ ɓan an Kooh Paamci, ee ya tum Kooh mooroomun. ");
INSERT INTO snf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yéesu ɓaatta ga, woꞌꞌaɓa an: - Kayoh-kayohɗa mi woꞌꞌúuka: Kowukii mínoo dara kitum ka ga kihafci rek. Iñaa ka hot Paamudii tumiɗa doŋ yërí ya tumi. Ɓéeɓ iñaa Paamudii tumiɗa, Kowukii tumiri ɓan. ");
INSERT INTO snf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","En kiꞌenaa, Paamudii waarin Kowukii ee iñaa ya tum na kihafci tóoh, ya teeɓka. Ee sah, Paamudii hay kiteeɓ Kowukii enaama ciyaak ciliis caa ka ƴah kitum ee ɗú hay gaca kijaahli. ");
INSERT INTO snf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","En kiꞌenaa, fodaa daa Paamudii kolukɗi ɓuwii kaanin ee ya pésíꞌɓaɗa, fodaama deŋ Kowukii pésɗi ɓaa neɓpi. ");
INSERT INTO snf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Paamudii nak attiꞌoo ken, wayee ya erin Kowukii kiꞌattiꞌ ga tóoh. ");
INSERT INTO snf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","En ɗanaa ɓéeɓ eꞌ Kowukii céeꞌ fodaa ɓa eꞌ Paamudii céeꞌɗa. Ɓéeɓ ɓaa eꞌtii Kowukii ɓii céeraa, lak eꞌtii Paamudii wos Kowukiiɗa céeꞌ. ");
INSERT INTO snf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kayoh-kayohɗa mi woꞌꞌúuka: ɓaa súkúruk woꞌeenciigoo ee ya gëm ga ɓaa wossooɗanaa, ya laasin ga kipeskaa leehoo taaꞌɗa. Ɓaama attiꞌsoo, ya kolkohin ga kikaan ya aasin haat ga kipes. ");
INSERT INTO snf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","kayoh-kayohɗa mi woꞌꞌúuka: wahtu waa hay ee sah wa leꞌin haat. Wahtaama wërí ɓuwii kaaninɗa ƴah kikelohu koonaakii Kowukii Kooh. Ee ɓuwaa kelohankaɗa hay kipesu bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","En kiꞌenaa, fodaa daa Paamudii laak kipeskii ya ga kihafciɗa, ya erin Kowukii ka laak kipeskii ga kihafka fodaama. ");
INSERT INTO snf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ee ya onin Kowukii kimín kiꞌattiꞌ ga tóoh ndaga ka kërí en Kowukii ɓii. ");
INSERT INTO snf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dara hanattúu ga kijaahal ndaga wahtu waa hay, waa ɓéeɓ ɓuwii kaninɗa hay kikelohu koonaakaagari. ");
INSERT INTO snf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ɓa meyoh ga daa ɓa enohɗa: ɓuwaa tumee iñaa jofinɗa, mílísu, ɓa laas ga kipeskaa leehoo taaꞌɗa. Ɓuwaa tumee iñaa joffiiɗa nak, ɓa mílís, ɓa attiꞌu kikaan bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","- Mi ga kihaffoo rek, mi mínoo dara kitum. Mi attiꞌi ga dii mi hot Paamudii teewirooɗa. Ee mi attiꞌaa, júwi hen, ndaga mi heellii kitum iñaa mi waaꞌ, wayee ɓaa wossooɗa, iñaa ya waaꞌɗa yërí mi heel kitum. ");
INSERT INTO snf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yéesu tíkka ga an: - Binaa enee an mi yërí en seedi haffoonaa, eneenaa iñii mi seediꞌɗa tuukoo ga fen. ");
INSERT INTO snf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wayee laakin ɓoꞌ yiliis yaa seediꞌꞌoo ee mi ínohin an iñii ya seediꞌ garooɗa tuukin. ");
INSERT INTO snf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɗú wosin ɓiɓoꞌ ga Saŋ-Bëtís, ya seediꞌꞌa kayohfii. ");
INSERT INTO snf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mi woꞌ iñuma doonaa Kooh músallúu, ndaga mi ga kihaffoo, enndii sah an mi laakin sooli ga iñaa ɓoꞌ-súusúus seediꞌan garoo. ");
INSERT INTO snf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saŋ enee fodii lampaa taaluunun, wa leeꞌɗi, ee ɗú tookka kineɓluk jutuut ga leeꞌlaataagariɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mi nak, mi seediꞌɗuunun seedaa wëñ kiyak waa Saŋ: seedaama wërí en tumeenciigoo, cii Paamudii onndoo kitumɗa. Cërí seediꞌꞌoo ee ca teewoh an Paamudii yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ee ɓan Paamudii wossooɗa, ya ga kihafci, ya seediꞌin yen garoo. Ɗú mosoo kikeloh koonaakaagari ee ɗú mosoo kihot fíkíifaagari. ");
INSERT INTO snf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɗú ammbii woꞌeeniigari ga keeñnjúu ee iñaama yërí teewoh an ɗú gëmmbii ga ɓii ya wosɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɗú ɓii heel kiꞌínoh iñaa Bíncaa ciselaꞌíꞌcaa woꞌɗa ndaga ɗú yaakaaꞌ an cërí ƴahhúu kiꞌon kipeskaa leehoo taaꞌɗa, ee sah Bíncii ciselaꞌíꞌcii ciima, ca woꞌ iñaa aaw garoo. ");
INSERT INTO snf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Moona déy, ɗú waaꞌtii kihay garoo, ɗú laas kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi heellii kilaak ndamaa meyoh ga ɓoꞌ-súusúus. ");
INSERT INTO snf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ee sah mi ínohinndúu: kiwaaꞌ Kooh gaa ga keeñciigarúu. ");
INSERT INTO snf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi, mi hay ga teekii Paammboo ee ɗú tookkiiroo wayee ɓoꞌ yiliis hay ga teekcinaa, ɗú hayyi kitook. ");
INSERT INTO snf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɗú wëñi kiwaaꞌ kindamoh ga ɗuuƴcúu ee ɗú heeloo ndamaa meyoh ga Kooh haŋci doŋɗa. Kon ɗú mínanndoo na kigëm? ");
INSERT INTO snf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kaa foogat an mi yërí ƴahhúu kiyam yen ga fíkíi Paammboo. Móyíis yii ɗú lík yaakaaꞌtúu gariɗa yërí ƴahhúu kiyam. ");
INSERT INTO snf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","En kiꞌenaa, ɗú gëmee Móyíis kayoh-kayohɗanaa, eneenaa ɗú hayyoo kigëm ɓan, ndaga ya seediꞌin garoo ga Këyítfaa. ");
INSERT INTO snf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wayee waa ɗú gëmmbii iñaa Móyíis bín yaama ga Këyítfaaɗa, ɗú tuman na bi ɗú gëm iñcii mi woꞌɗa? ");
INSERT INTO snf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Waa ennda ɗa, Yéesu paaffa ɓakaa giiyaa Gëlílée hanoh gaaɗa. Giiyaama woꞌsi ɓan giiyaa Tíbéeríyaat. ");
INSERT INTO snf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɓoꞌ ɓiyewin taabukeeri ndaga kíntaancaa ɓa hot ya tumee ga ɗúukoolíꞌcaa, ɓa wakkaɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yéesu lappa ga ɗook jaŋjaŋ daama, ya yuŋnga da na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wiima lak feetaa Paakaa yaawúuꞌcaa deeyin. ");
INSERT INTO snf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yéesu malak hen, ya séennda mbooloo wiyaak waa hay gari. Ya meekissa Filiip an: - Mbúurúcaa mínan ɓuwii ɓii ɓéeɓ kiñëmíꞌɗa, ɗu lomohnanca gada? ");
INSERT INTO snf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yéesu woꞌee iñaama kimalaksukoh Filiip doŋ. En kiꞌenaa, ya ga kihafci, ya ínoheera iñaa ya naꞌ kitumɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filiip taassari an: - Luu enee an ɓaa en ɓéeɓ ƴaak-mbúurú wíinoo, fay ɓoꞌ ɓitéeméeꞌ-kanak ga noh-noh wíinoo mínoo kilom iñaa ñëmíꞌ ɓuwii ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Laakka ɓoꞌ yiliis ga tëelíbéecaagari, yaa teeku Andari, ee këmëeŋkí Simoŋ-Peeꞌ, woꞌꞌa Yéesu an: ");
INSERT INTO snf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Laakin kuꞌoomaa-ƴaalkaa en dii, ja ɓayin mbúurú-lorsu ciyëtúus na jën kanak. Wayee ɓuwii, dii ɓa yewinɗa, iñcaama ca paƴɓa ya? ");
INSERT INTO snf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yéesu woꞌꞌa tëelíbéecaagari an: - Woꞌatɓa, ɓa yuŋ ɓéeɓɓa. Ɗekataa paaleera pëegíi fiyewin. Ɓéeɓ ɓuwaa dalla ga kiyuŋ. Ƴaalcaa enee daamaɗa, jomin kileꞌ ɓijúnni-yëtúus (5.000). ");
INSERT INTO snf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yéesu ɓeɓpa mbúurúcaa, ya gërëmmba Kooh gaca, ya warohhaca ɓuwaa yugee daamaɗa. Ya tumissa fodaama na jëncaa, ya eꞌta yaa en ɓéeɓ iñaa ya sooluk gaɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ga waa ɓéeɓ ñammba bi kappa, Yéesu woꞌꞌa tëelíbéecaagari an: - Nëgírohat iñcii tesɗa, en ɗanaa dara aamsukohoo. ");
INSERT INTO snf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tëelíbéecaa nëgírohussa iñcaa tesɗa. Ɓa líifíꞌta pañi cidaaŋkaah na kanak ga iñaa tes ga mbúurú-lorsucaa ciyëtúuscaa ɓuwaa ñameeɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Daa ɓuwaa hotee kíntaanaa Yéesu tum waama, ɓa woꞌꞌa an: «Ɓii yii yërí en kayoh-kayohɗa sëldíiga-Koohii jomee kihay ëldúnaɗa.» ");
INSERT INTO snf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yéesu ínohha an ɓuwaa hay kihayu, abussi na dooli kifalli buuꞌ. Ya foñnjaɓa daama, ya lokukka, ɓoƴkissa haŋci jaŋjagaa. ");
INSERT INTO snf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ga waa nohaa soosɗa, tëelíbéecaa Yéesu yoosukussa jaŋjagaa bi ga seereenaa giiyaa. ");
INSERT INTO snf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓa aassa gaal-looci, ɓa ɓaa ƴah Kafarnawom ga ɓakaa giiyaa hanoh gaaɗa. Lakanaa Kooh hoowin ee Yéesu daɓpiiɓa duum. ");
INSERT INTO snf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Uuris wiyaak yíppa ga ɗook giiyaa bi dúuscaa caa koluk. ");
INSERT INTO snf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ga waa ɓa folla ga ɗuuƴ giiyaa iñaa leꞌ kíloomeet ciyëtúus aawwa ciyitniinooɗa, ɓa hotta Yéesu yaa tíin ga ɗook músúmaa, ya yaa hay gaɓa ga gaal-loocaa. Daa ɓa hotee iñaama, ɓa dalla kitíit. ");
INSERT INTO snf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yéesu nak woꞌꞌaɓa an: - Kaa tíitat, ɓii mi! ");
INSERT INTO snf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓa waaꞌta ya aas ga gaal-loocaa, wayee ga wahtaama gaal-loocaa teeꞌta ga daa ɓa waaree kiyoosukohɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ga kooh-wíisfaa, mbooloomaa tesee ga ɓakaa giiyaa hanoh gaaɗa, hotta an gaal-looci wíinoo doŋ enee daama. Ɓa ínoheera an Yéesu aassii na tëelíbéecaa ga gaal-loocaama, tëelíbéecaa kaꞌsee haŋɓa. ");
INSERT INTO snf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Laakka nak gaal-looci ciliis caa meyohee teeraa Tíbéeríyaat. Gaalcaama teeꞌta ga ɗekataa Yéesu, Haꞌmudii, gërëmohee Kooh ga mbúuraa mbooloomaa ñameeɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɓuwaa hotussa an Yéesu enissii daama naɓa ee tëelíbéecaagari ɓan enussii da. Ɓa dalla kiꞌaas ga gaal-loocicaa meyohee teeraa Tíbéeríyaatɗa, ɓa ɓaa ƴahhi kimalaknee ga teeraa Kafarnawom. ");
INSERT INTO snf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɓa laakneera Yéesu ɓakaa giiyaa hanoh gaaɗa, ɓa meekissari an: - Jëgírohii, fu hay dii kera? ");
INSERT INTO snf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yéesu taassaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: ɗú raassoonaa, enndii an ɗú ínohin kíntaancii mi tumɗa, iñii ca waaꞌ kiwoꞌɗa, wayee ɗú raassoo ndaga mbúurúcaa ɗú ñamee bi ɗú kappa pútɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kiheel ñamahaa mínin kiyasukoh hanat kiꞌen lëgëyyúu, wayee tumat lëgëy kiheel ñamahaa yasukohoo ee onohi kipeskaa leehoo taaꞌɗa. Ñamahaama nak, Kowukii ɓii kërí ƴahhúuwa kiꞌon. En kiꞌenaa, yërí Kooh, Paamudii tanuk, eꞌtari doolaa meyoh gari, ga iñaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Waa ennda ɗa, ɓa meekissari an: - Kon ɗí jom ya kitum lëgëy kimëtíꞌ iñcii Kooh sek garíiɗa? ");
INSERT INTO snf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yéesu taassaɓa an: - Iñii Kooh sek garúu ee ɗú jom kilëgëyɗa yërí en an ɗú gëm ga ɓii ya wosɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓa woꞌꞌari an: - Tumaa Kíntaan, ɗí hotwanaa ɗí gëm garaa! Iñii fu tumɗa ya? ");
INSERT INTO snf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ga ëgíꞌ-dúndagaa ɓicaasammbíi enseeɗa, ɓa ñamee ñamahaa woꞌsee maan ee Kooh toɓɗeeɓawa, fodaa daa Këyítfaa woꞌkaɗa. Fa woꞌ an: «Ya onndaɓa ñamahaa meyoh ɗook asamaan, ɓa ñammba.» ");
INSERT INTO snf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wayee Yéesu taassaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: enndii Móyíis yërí onndúu ñamahii meyohee ɗook asamaanɗa. Paammboo, ga kihafci yërí onndúu ñamahii wukayoh-kayohwii meyoh ɗook asamaanɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","En kiꞌenaa, ñamahii Kooh onohɗa wërí en wii yoosukoh ɗook asamaanɗa, ee on ɓu-ëldúna kipesɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɓa dallari kiwoꞌ an: - Kon Kiyaakii, dëkaaríi kiꞌon ga ñamahaama rek. ");
INSERT INTO snf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yéesu woꞌꞌaɓa an: - Mi yërí en ñamahii onohi kipesɗa. Ɓaa hay garoonaa, yaawanndii bi taaꞌ, ee ɓaa gëm garoonaa pílanndii bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wayee mi woꞌinndúuka: ɗú hotinndoo ee tahhii bi ɗú gëm. ");
INSERT INTO snf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓéeɓ ɓuwii Paamudii onndooɗa, hay kihayu garoo. Ee ɓaa hay garoonaa, mi kaaloori múk. ");
INSERT INTO snf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ndaga mi yoosukohhii ɗook asamaan kitum iñaa neɓpoo, wayee ɓii wossooɗa, iñaa ya waaꞌɗa yërí mi hay kitum. ");
INSERT INTO snf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ee ɓii wossooɗa iñii yii yërí ya waaꞌ wa laak: ya waaꞌ an ɓuwii ya tík ga yahhooɗa, yíinoo múuyoo ga. Ee mi mílísiꞌɓa ga besaa mëeñjohɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","En kiꞌenaa, iñii yii yërí Paamudii waaꞌ: ya waaꞌ an ɓéeɓ ɓaa hottoo, mi Kowukii ee gëm garoonaa, laas ga kipeskaa leehoo taaꞌɗa, ee mi hayyi kimílísiꞌ ga bëríinaa ëldúna túkiꞌanɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yaawúuꞌcaa nak ɓaa ñaꞌsukoh iñaa aaw ga Yéesu ndaga daa ya woꞌ an: «Mi yërí en mbúurii yoosukoh ɗook asamaanɗa.» ");
INSERT INTO snf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓa ɓaa woꞌ an: - Ɓii yii, hanaa enndii Yéesu, kowu Yoseef? Ɗu ínohoo eeci na paamci hene? Ya mín na kiwoꞌ diima an: Mi yoosukoh ɗook asamaan? ");
INSERT INTO snf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yéesu taassaɓa an: - Íisat kiñaꞌsukoh ga ɗuuƴcúu. ");
INSERT INTO snf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ken mínoo kihay garoo ee Paamudii wossooɗa híiꞌtiiri ga. Ee ɓaama, mi ga kihaffoo, mi hayyi kimílísiꞌ bëríinaa ëldúna túkiꞌanɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sëldíiga-Koohcaa bíduunun woꞌeenii wii: «Kooh hayɓa ɓéeɓ kijëgíꞌ.» Fodaama nak, ɓéeɓ ɓaa súkúruk woꞌeenii Paamudii ee teꞌwanaa, hay garoo kihay. ");
INSERT INTO snf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Enndii an laakin ɓaa mos kihot Paamudii. Yii meyoh ga Koohɗa doŋ yërí hot Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kayoh-kayohɗa mi woꞌꞌúuka, ɓaa gëm garoonaa laakin kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi, mi yërí en mbúurii onohi kipesɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ga ëgíꞌ-dúndagaa, ɓicaasammbúu ñamsee ñamahaa woꞌsee maanɗa, ee hoonohhiiɓa kikaan. ");
INSERT INTO snf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mbúurii yoosukoh ɗook asamaanɗa wërí en wii: ɓaa ñamwanaa kaananndii bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi, mi yërí en mbúurii yoosukoh ɗook asamaan ee onohi kipesɗa. Ɓaa ñam ga mbúurii wiimanaa hay kipes bi taaꞌ. Mbúurii mi ƴah kiꞌerohɗa, faanfiigoo fërí, mi erohfa doonaa ɓu-ëldúna pes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ga iñaama, yaawúuꞌcaa enussa ga nookoh witamóhíꞌ, ɓaa woꞌ an: - Ɓii yii mínannduu na kiꞌeꞌ faanfiigari kiñam? ");
INSERT INTO snf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yéesu woꞌꞌaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: binaa ɗú ñammbii faanfii Kowukii ɓii, ɗú anndii ñífiigarinaa, kipeskii enndii garúu. ");
INSERT INTO snf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɓaa ñam faanfiigoo, an ñífiigoonaa laakin kipeskaa leehoo taaꞌɗa, ee mi, mi hayyi kimílísiꞌ ga besaa mëeñjohɗa, ");
INSERT INTO snf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ndaga faanfiigoo en ñamahii wukayoh-kayohwii ee ñífiigoo wërí en anahii wukayoh-kayohwii. ");
INSERT INTO snf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɓaa ñam faanfiigoo, an ñífiigoonaa, ya yii dëkka garoo ee mi yii dëkka gari. ");
INSERT INTO snf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Paamudii wossooɗa yii pes ee mi ɓewoh kipes gari. Fodaama, ɓaa ñam faanfiigoonaa hay kiɓewoh kipes garoo. ");
INSERT INTO snf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kon mbúurii yoosukoh ɗookɗa wooma. Wa manndii na mbúuraa caasamuncaa ñameeɗa. Ɓa, ɓa kaanin, wayee ɓaa ñam mbúurii wiinaa, hay kipes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Woꞌeencii ciima cërí Yéesu woꞌee ga waa ya jëgíroh ga jaangu-yaawúuraa ga Kafarnawomɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ɓoꞌ ɓiyewin ga tëelíbéecaa Yéesu, daa ɓa kelohee iñaa ya woꞌ yaama, woꞌussa an: - Woꞌeenii wii, wa ɓít na ɗa? Ɓii mín ɓa kiyuŋ súkúrukiwa? ");
INSERT INTO snf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yéesu ínohha ga kihafci an tëelíbéecaa ɓaa ñaꞌsukoh iñaa ya woꞌ yaama, ya woꞌꞌaɓa an: - Keeñnjúu neɓpii ga iñii mi woꞌꞌúuɗa hene? ");
INSERT INTO snf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Haa binaa ɗú hot Kowukii ɓii ɓoyuk ga daa ka ɗewee kiꞌenɗanaa? ");
INSERT INTO snf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Helii meyoh ga Koohɗa wërí onohi kipes. Ɓoꞌ na kihafci mínoo dara. Woꞌeencii mi woꞌꞌúuɗa kúlkoh ga Helaa meyoh ga Koohɗa ee cërí onohi kipes. ");
INSERT INTO snf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ee bi wati, laakin ɓiɓoꞌ garúu ɓaa saŋ kigëm. En kiꞌenaa, Yéesu, ga kihafci, ga waa ya dalɗa, ya ínoheera ɓuwaa gëmmbiiɗa ee ya ínoheera yaa ƴahhi kitoonɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lëehíꞌta Yéesu tíkka ga an: - Iñaama tah mi woꞌꞌarúu an ken mínoo garoo kihay, enndii an Paamudii onndikanaa. ");
INSERT INTO snf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kolkoh daama, ɓiyewin ga tëelíbéecaa Yéesu foñussari, ɓa íissa nari taam. ");
INSERT INTO snf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Waa ennda ɗa Yéesu meekissa tëelíbéecaa ɓidaaŋkaah na ɓanakɓaa an: - Haa ɗú ɓan, ɗú waaꞌtii kiƴahe? ");
INSERT INTO snf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoŋ-Peeꞌ taassari an: - Haꞌmudii, ɗí ƴahan ga ɓa? Fu yërí ɓay Woꞌeencii onohi kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɗí, ɗí gëmin ee ɗí ínohin an fu, fu yërí en Ɓii yiselaꞌíꞌyii meyoh ga Koohɗa. ");
INSERT INTO snf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yéesu taassaɓa an: - Enndii mi tanukkúu, ɗú ɓidaaŋkaah na ɓanakɓiine? Moona déy yíinoo garúu iñii ɓoꞌ Seytaani. ");
INSERT INTO snf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yúdaa, kowukaa Simoŋ Iskariyot yërí laak woꞌeenaa Yéesu woꞌ waama. Yúdaa yiima ee bok ga tëelíbéecaa ɓidaaŋkaah na ɓanakɓaaɗa yërí ƴah kitoon Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Waa ennda ɗa, Yéesu yaa wíil gohaa Gëlílée. En kiꞌenaa, ya waaréeríi kitoŋ kotci ga kúlkaa Yúudée ndaga ɓuwaa kuliyuk ga yaawúuꞌcaaɗa heelseeri kiꞌap. ");
INSERT INTO snf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lakanaa hewaa yaawúuꞌcaa woꞌu feetaa mbaaꞌcaaɗa deeyin. ");
INSERT INTO snf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Këmëeŋkímuncaagari woꞌussari an: - Kolkaa dii hen, fu kaꞌ kúlkaa Yúudée doonaa tëelíbéecaagaraa ɓan hotu kíntaancii fu tumiɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɓoꞌ, iñaa ya tumiɗa, ya ɗaakoori en lak ya waaꞌ kisíwaa. Waa fu karin bi fu yii tum kíntaancaa hín na cii, teewukohaa hen, ɓéeɓ hottaa. ");
INSERT INTO snf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","En kiꞌenaa, ɓikëmëeŋkíci ga kihafɓa, gëmséeríi gari. ");
INSERT INTO snf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yéesu taassaɓa an: - Wahtiigoo leꞌꞌii duum, wayee en ɗúnaa, wahtaa en ɓéeɓ jofin. ");
INSERT INTO snf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɗú, ɓu-ëldúna mínoorúu kisaŋ, wayee mi, ɓa saginndoo ndaga mi woꞌ an tumeencaagaɓa joffii. ");
INSERT INTO snf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɗú, karat feetaa, mi, mi ƴahhii feetaama paaƴ ndaga wahtiigoo leꞌꞌii duum. ");
INSERT INTO snf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yéesu woꞌꞌaɓa iñaama, lëehíꞌta ya tessa ga Gëlílée. ");
INSERT INTO snf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ga waa këmëeŋkímuncaa Yéesu karussa, Yéesu ɓan lokukka, kaꞌta feetaa ee ken yéeŋngiiri. ");
INSERT INTO snf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓaa raassi ga ɗuuƴ hewaa, ɓaa meekisoh an: - Ya ya da? ");
INSERT INTO snf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ga ɗuuƴ mbooloomaa, ɓuwaa enussa ga ɗóowíꞌ iñaa aaw gari rek. Ɓii ɓaa woꞌ an: «Ɓaa ɓoꞌ yijófíꞌ» Ɓíinoo an: «Óꞌóo, ɓaa ëewdoh ɓuwii ëgíraa.» ");
INSERT INTO snf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wayee ken kaañéeríi kiwoꞌ ga ɗook iñaa aaw gari ndaga ɓéeɓ niiksee ɓuwaa kuliyuk ga yaawúuꞌcaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lakanaa feetaa karin bi leꞌin leꞌnaa, Yéesu kaꞌta Kaanfaa Kooh, ya yaa kijëgíroh. ");
INSERT INTO snf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yaawúuꞌcaa jaahliꞌussa ga iñcaa ya jëgírohɗa, ɓa ɓaa woꞌ an: - Waa ya jaŋngii, tum na bi ya ínoh iñii Këyítfii woꞌɗa fodii dii? ");
INSERT INTO snf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yéesu taassaɓa an: - Iñii mi jëgírohɗa, meyohhii garoo, wayee meyoh ga Kooh yii wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɓaa waarin kitum iñaa Kooh nakohɗa hay kiꞌínoh ati iñii mi jëgírohɗa meyoh ga Kooh ati mi hay kiwoꞌiꞌ haffoo ga teekkoo. ");
INSERT INTO snf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɓaa woꞌi hafci ga teekci ɓéeɓ, heel kilaak teek. Wayee ɓaa heel iñaa onan ɓaa wossiɗa kilaak teek, ɓaama woꞌi kayoh ee saboh gaa gari. ");
INSERT INTO snf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Enndii Móyíis yërí eꞌtúu Këyítfaa Waasaane? Ee yíinoo garúu taabukkii iñaa fa nakohɗa. Iñii tah ya ɗú heelloo kiꞌap? ");
INSERT INTO snf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɓuwaa taassari an: - Fu déy Seytaani aaskinndaa! Ɓii heellaa kiꞌap ɓa? ");
INSERT INTO snf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yéesu taassaɓa an: - Ɗú hot dii mi tum kíntaan wíinoo doŋɗa, ɓéeɓpúu iñaama meskinndúu. ");
INSERT INTO snf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Malkat, Móyíis haydohin kigúruk ga ɗuuƴcúu, enndii sah an ka kolkoh gari ndaga ka meyoh ga caasamuncaa ɓiɗewaaɓaa; ee ɗú gúrin ɓoꞌ ga bes Sabat. ");
INSERT INTO snf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","En lak ɗú mínin kigúꞌ oomaa ga bes Sabat ndaga kisaŋ kiɗeeŋ Waasii Móyíisaa, iñii tah ya ɗú aylukkoo ndaga dii mi wëkɗin ɓoꞌ ñëm ga bes Sabat? ");
INSERT INTO snf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kon íisat kiꞌattiꞌ ee ɗú malkoo bi jof, wayee attiꞌat ga kayoh. ");
INSERT INTO snf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Laakka ɓuwaa dëk Yéerúsaleem, ɓa ɓaa woꞌ iñaa aaw ga Yéesu an: - Enndii ɓii yii yërí ɓa heel kiꞌap hanaa? ");
INSERT INTO snf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Malakat, yeema woꞌi ga fíkíi ɓéeɓ, ee ken woꞌꞌiiri dara. Ɓuwii kuliyuk garuuɗa, ati kayoh-kayohɗa ɓa took hen an yërí en Kiristaanii? ");
INSERT INTO snf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","En ɓii yiinaa déy, ɗí ínohin dii ya kúlkohɗa, wayee Kiristaanii ƴah kihayaa, ken ínohanndii daa ya kúlkohanɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wiima lak Yéesu yaa jëgíroh ga ɗuuƴ Kaanfaa Kooh, ya dalla kiwoꞌ didóolíꞌ an: - Ɗú woꞌ an ɗú ínohinndoo ee ɗú ínohin daa mi kúlkohɗane? Moona déy mi hayiꞌtii haffoo, mi wosu hen, ee ɓaa wossooɗa woꞌi kayoh wayee ɗú ínohoori. ");
INSERT INTO snf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mi nak, mi ínohinndi, ndaga mi meyoh gari ee yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Waa ennda ɗa, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓaa heel kiꞌam Yéesu, wayee yíinoo gaɓa, yahci leꞌꞌii gari ndaga lak wahtaa Yéesu leꞌꞌii duum. ");
INSERT INTO snf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ee ga mbooloomaa nak, ɓoꞌ ɓiyewin gëmussa gari. Ɓa ɓaa woꞌ an: - Binaa Kiristaanii hayaa, ya hay kitum kíntaancaa paaf cii ɓii yii tumɗane? ");
INSERT INTO snf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Laakka Fërísiyeeŋcaa keloh iñaa ɗóowíꞌsee ga ɗuuƴ mbooloomaa aaw ga Yéesuɗa. Waa ennda ɗa, sarahohcaa ɓiyaakɓaa hotohussa na Fërísiyeeŋcaa, wosussa ɓiɓoꞌ ga ɓuwaa watuki Kaanfaa Koohɗa kiꞌamneeri. ");
INSERT INTO snf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yéesu dalla kiwoꞌ an: - Mi yii narúu dii ee ensoo bi maañ. Lëehíraa mi ƴee ga ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ɗú hayyoo kiraas, wayee ɗú hotanndiiroo, ee ɗú mínoo kikaꞌ ga daa mi ƴah kiꞌenɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ga iñaama, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓaa woꞌ ga díkaantiɓa an: - Ya ƴah gada kikaꞌ daa ɗu mínoori da kilaak? Ya ƴah kilaaknee yaawúuꞌcaa tasaarukoh ga ɗuuƴ Gerekcaaɗane? Ati ya ƴah kijëgíꞌnee Gerekcaa? ");
INSERT INTO snf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Woꞌeenii ya woꞌ wii an «Ɗú hayyoo kiraas wayee ɗú hotanndiiroo, ee ɗú mínoo kikaꞌ ga daa mi ƴah kiꞌenɗa», wa waa ya kiwoꞌ? ");
INSERT INTO snf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ga besaa mëeñjoh ga hewaa feetaa mbaaꞌcaa ee wërí wëñ kilaak solu ga feetaaɗa, Yéesu tuukka ga fíkíi mbooloomaa, ya woꞌꞌa ga ɗook an: - Ɓaa fu pílaa, hayaa garoo, fu an. ");
INSERT INTO snf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","«Ɓaa gëm garoo ɓéeɓ húlúɓ-músúmaa onohi kipesɗa, hay kihaal ga ɗuuƴci» fodaa daa Këyítfaa woꞌkaɗa. ");
INSERT INTO snf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ga woꞌeenaama Yéesu woꞌee Helaa yiselaꞌíꞌyaa ɓuwaa gëm gari ƴah kilaasɗa. En kiꞌenaa, ga wahtaama, lakanaa Helaa yiselaꞌíꞌyaa erohussii ndaga lak Kooh eꞌtii Yéesu ndam duum. ");
INSERT INTO snf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Laakka ɓiɓoꞌ ga mbooloomaa, daa ɓa kelohee woꞌeencaa Yéesu, ɓa woꞌꞌa an: - Ɓii yii kayoh-kayohɗa yërí en sëldíiga-Koohii sekuɗa! ");
INSERT INTO snf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓíinoo an: - Kiristaanii yërí! Wayee ɓíinooɓaa woꞌꞌa an: - Kiristaanii mínin kimeyoh Gëlíléene? ");
INSERT INTO snf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Këyítfaa woꞌꞌii an Kiristaanii jom kibok ga níilaa buuꞌ Dëwít, ee ya ƴah kilímu ga Betleeꞌem, teeraa Dëwít dëkeeɗane? ");
INSERT INTO snf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ga iñaama mbooloomaa dalla kihëgískoh ndaga Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Laakka ga ɓuwaa, ɓiɓoꞌ ɓaa waaꞌti kiꞌam. Wayee yíinoo gaɓa yahci leꞌꞌii gari. ");
INSERT INTO snf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɓuwaa watuki Kaanfaa Kooh ee ɓa wossee kiꞌam Yéesuɗa, ɓoyukussa ga sarahohcaa ɓiyaakɓaa na ga Fërísiyeeŋcaa. Daa ɓa leꞌee, ɓaama meekissaɓa an: - Iñii tah ya ɗú haydohhiiri? ");
INSERT INTO snf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɓa taassa an: - Woꞌeencaa ɓaa yaama woꞌɗa, ken mosoo kimeƴdoh woꞌeencaa manɗa ga kúuwci. ");
INSERT INTO snf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fërísiyeeŋcaa abussa yah ga kúuw, woꞌussaɓa an: - Haa bi ga ɗú ɓan, ɗú bok ga ɓuwii ëewdohu ëgíraaɗane? ");
INSERT INTO snf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɗú hotin ɓoꞌ yíinoo ga ɓuwii kuliyuk ga Waasiigaruu wala ga Fërísiyeeŋcii yaa gëm garine? ");
INSERT INTO snf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Man ɓuwii ínohsoo dara ga Waasii Móyíisɗa ɓërí gëm gari. Ɓuwaama ɓéeɓɓa, aylukaa Kooh waa ga ɗookɓa. ");
INSERT INTO snf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Waa ennda ɗa, Níkodeem, yíinoo ga Fërísiyeeŋcaa ee ya moseera kikaꞌ ga Yéesu, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","- Waasiigaruu oninnduu kitík ɓoꞌ kikaan ee lak ɗu súkúrukkiiri ee ɗu ínohoo ati ya tum ya yibóníre? ");
INSERT INTO snf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fërísiyeeŋcaa loffari an: - Fu ɓan, fu nam kidëk Gëlíléenoo ya? Malkaa Këyítcaa dijófíꞌ, fu hay kihot an sëldíiga-Kooh yíinoo meyohoo Gëlílée. ");
INSERT INTO snf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Waa ennda ɗa, ɓaa en ɓéeɓ yaa ɓoyuk kaanci. ");
INSERT INTO snf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yéesu aawwa tëgëlaa Ólíwíyéecaa. ");
INSERT INTO snf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ga kooh-wíisfaa, ga kímaa cuut, ya ɓoyukka Kaanfaa Kooh. Ɓéeɓ ɓuwaa hayussa gari, ya yuŋnga, ya yaa jëgíꞌɓa. ");
INSERT INTO snf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Daama, jëgíroh-waascaa na Fërísiyeeŋcaa haydohussa gari ɓetifaa betu lak enee na kifaanuk na ɓaa enndii ƴaalci. Ɓa tuukiꞌtari ga leeloo ɓuwaa, ");
INSERT INTO snf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ɓa woꞌꞌa Yéesu an: - Jëgírohii, ɓetifii fii betu lak yaa faanuk na ɓaa enndii ƴaalci. ");
INSERT INTO snf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ee ga Waasii, Móyíis nakoh an ɓetifaa tum iñaamanaa jom kitapu na atoh bi ya kaan. Fu nak, fu woꞌ ya ga? ");
INSERT INTO snf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iñaama ɓa woꞌeeri kifíꞌ Yéesu doonaa ɓa laak iñaa ɓa yabohanndi. Wayee Yéesu ɗëelɗukka, yaa fíis ga kakayfaa na jokonjaagari. ");
INSERT INTO snf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɓa ɓaa ɓaat kimeekisoh, Yéesu yolohha, woꞌꞌaɓa an: - Yaa en garúu ee mossii kitum baakaaꞌɗa, ɗewat kiwees ɓetifii atoh. ");
INSERT INTO snf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ya ɗëelɗukissa, ya enissa ga kifíis kakayfaa. ");
INSERT INTO snf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Daa ɓa kelohee woꞌeenaama, ɓa ɓaa ɗóokisuk yíinoo yíinoo, ɗewoh ga ɓuwaa wëñ kiꞌen yaakɗa. Tessa Yéesu na ɓetifaa, lak fa lís kituuk ga daa fa gíwohseeɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yéesu yolohha, meekissa ɓetifaa an: - Ɓetifii, ɓada ɓuwii yabeeraaɗa? Ken attiꞌꞌiiraa kikaane? ");
INSERT INTO snf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɓetifaa taassa an: - Haꞌmudii, ken attiꞌꞌiiroo kikaan. Yéesu woꞌꞌari an: - Mi ɓan mi attiꞌꞌiiraa kikaan. Tíida, ee iñaa aboh diima, kaa tumis baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yéesu ëewrukissa ga mbooloomaa, woꞌꞌa an: - Mi, mi yërí en leeꞌlaatii ëldúna. Ɓaa taabukkoonaa tíinsisoo múk ga ñúus, ee ya hay kilaas ga leeꞌlaataa onohi kipesɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fërísiyeeŋcaa dallari kiwoꞌ an: - Fu, fu en seedi haffu, kon iñii fu seediꞌɗa tuukkii fen. ");
INSERT INTO snf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yéesu loffaɓa an: - Hídaa ga dii mi seediꞌ haffooɗa tóoh, iñii mi seediꞌɗa tuukin, ndaga mi ínohin dii mi kúlkohɗa ee mi ínohin dii mi ƴahɗa; ɗú nak, ɗú ínohoo dii mi kúlkohɗa ee ɗú ínohoo dii mi ƴahɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɗú, ɗú attiꞌi attiꞌeen ɓoꞌ-súusúus, ee mi, mi attiꞌoo ken. ");
INSERT INTO snf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mi nak, mi naꞌ kiꞌattiꞌaa, attiꞌaagoo kooran ga waas ndaga mi enoo haŋngoo ga, mi ƴah ga na Paamudii wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bíduunun ga Këyítfaa Waasii an ɓoꞌ ɓanak boku woꞌeen ga kiseediꞌaa, lak iñaa ɓa seediꞌɗa tuukin. ");
INSERT INTO snf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mi nak, mi seediꞌ haffoo ee Paamudii wossooɗa ɓan seediroo. ");
INSERT INTO snf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɓa meekissari an: - Ya da Paamfu? Yéesu loffaɓa an: - Ɗú ínohoo ken garíi, enndii mi enndii Paammboo. Enee an ɗú ínohinndoonaa, ennaa ɓan ɗú ínoh Paammboo. ");
INSERT INTO snf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Woꞌeenciima Yéesu woꞌeeca lakanaa ya yaa kijëgíroh ga ɗuuƴ Kaanfaa Kooh. Ya enee ga yahaa ɗekataa ekohsi sarahcaaɗa. Ken hayyiiri kiꞌam ndaga lak wahtaagari leꞌꞌii duum. ");
INSERT INTO snf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yéesu woꞌissaɓa an: - Mi yii ƴah ee ɗú hayyoo kiraas, wayee ɗú kaanan ga kibaakaaꞌkii ɗú enukohɗa. Mi, dii mi ƴahɗa, ɗú mínoo da kikaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Waa ennda ɗa, ɓuwaa kuliyuk ga yaawúuꞌcaa ɓaa woꞌ an: - Ga dii ya woꞌan: «Mi, dii mi ƴahɗa, ɗú mínoo da kikaꞌ», mbaa enndii an ya ƴah kiharuk? ");
INSERT INTO snf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yéesu woꞌꞌaɓa an: - Ɗú, ɗú bok ga ɓu-kakay, wayee mi, mi bok ga ɓu-ɗook. Ɗú bok ga ëldúnaanii wii, wayee mi bokkii ga ëldúnaanii wii. ");
INSERT INTO snf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kërí tah, mi woꞌꞌúu man ɗú kaanan ga baakaaꞌciigarúu. En kiꞌenaa, ɗú gëmmbii an mi, mi yërí enaa, ɗú kaanan ga baakaaꞌciigarúu. ");
INSERT INTO snf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɓa meekissari an: - Fu, fu yërí en ɓa? Yéesu taassaɓa an: - Mi dëk ga kiwoꞌꞌúuka ga dalaaraa bi ga wati. ");
INSERT INTO snf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi mínin garúu kiwoꞌ enaama ciyewin ee mi mínin kiꞌattiꞌ garúu enaama ciyewin. Ee ɓaa wossooɗa ɓoꞌ-kayoh, ee mi yéegal ɓu-ëldúna iñaa mi ɓewoh gariɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓa ínohhii an Yéesu woꞌeeɓa loo Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yéesu nak woꞌꞌaɓa an: - Ɗú ɓëwíꞌ Kowukii ɓii ga ɗook bëríinaa, ɗú hay kiꞌínoh an mi, mi yërí en. Ee ɓan ɗú hay kiꞌínoh an mi tumoo dara ga kihaffoo, wayee iñii mi woꞌɗa Paamudii lëdíꞌtoori. ");
INSERT INTO snf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɓii wossooɗa, yii naroo. Ya foñnjiiroo mi tes haŋngoo ndaga mi tumi iñaa neɓpi rek. ");
INSERT INTO snf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Daa ya woꞌee fodaama, ɓoꞌ ɓiyewin gëmmba gari. ");
INSERT INTO snf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Waa ennda ɗa, Yéesu woꞌꞌa yaawúuꞌcaa gëmee gariɗa an: - Binaa ɗú dëk kitaabuk iñii mi jëgírohɗanaa, iñaama hay kiteewoh an ɗú ɓitëelíbéeroo kayoh-kayohɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Fodaama ɗú hay kiꞌínoh kayohfii ee kayohfii hayyúu kiꞌon kilaak haffúu. ");
INSERT INTO snf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓa taassari an: - Ɗí, ɗí bok ga níilaa Abaraham ee ɗí mosoo kiꞌen ñaam ken. Kon fu mínndíi na kiwoꞌ an ɗí hay kilaak haffíi? ");
INSERT INTO snf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yéesu taassaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: ɓaa fu tumin baakaaꞌ ɓéeɓ fu ñaam-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ñaam dëkoo kibok ga kaanfaa ya enohɗa, wayee kowu boki ga bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kon binaa en an Kowukii kërí onndúu kilaak haffúunaa, ɗú hay kilaak haffúu kayoh-kayohɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi ínohin an ɗú bok ga níilii Abaraham wayee ɗú manndii nari. Iñii mi jëgírohɗa ɗú tookkiiri ga keeñnjúu, kërí tah ɗú heelloo kiꞌap. ");
INSERT INTO snf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi, iñii mi hot ga Paammbooɗa yërí mi woꞌ. Ɗú nak, iñaa ɗú keloh ga paammbúuɗa yërí ɗú tumi. ");
INSERT INTO snf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓa taassari an: - Abaraham yërí en Paammbíi. Yéesu loffaɓa an: - Ɗú enee ɓitowu Abaraham kayoh-kayohɗanaa, eneenaa ɗú taaban kotcaagari. ");
INSERT INTO snf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mi, mi woꞌirúu kayohfii mi ɓewoh ga Koohɗa, ee diima ɗú heelloo kiꞌap. Abaraham mosoo kitum iñaa manɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɗú kay, ɗú taam kotcii paammbúu. Ɓa loffari an: - Ɗí enndii towutaa laaksoo paamun. Ɗí laakin Paamun yíinoo ee yërí en Kooh. ");
INSERT INTO snf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yéesu woꞌꞌaɓa an: - Binaa enee an Kooh Paammbúunaa, eneenaa ɗú waaꞌtoo, ndaga mi meyoh ga Kooh ee yërí tahhoo kihay dii. Hayiigoo diiɗa meyohhii garoo wayee yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iñii tah ya ɗú ínohoo iñii mi woꞌꞌúuɗa? Ɗú nam kimínoo kisúkúruk woꞌeenciigoo hen, kërí tah. ");
INSERT INTO snf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seytaani yërí en paammbúu, ee ɗú waaꞌ kitum iñaa neɓ paammbúu yaama. Ga dalaaraa bi wati, ya mos kiꞌen ɓaa lagi kumuun ɓoꞌ. Ya mosoo kituuk ga kayoh ndaga kayoh paallii gari. Ya en na kikaak sabohaa, madi na ya ɓapka hen, ndaga ya kaakoh-saboh ee saboh límukoh gari. ");
INSERT INTO snf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wayee mi, mi woꞌi kayoh, ee iñaama tah ɗú gëmmbiiroo. ");
INSERT INTO snf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yiida garúu mín kiseediꞌ an mi tumin baakaaꞌ? Ee en an mi woꞌ kayohaa, iñii tah ya ɗú gëmmbiiroo? ");
INSERT INTO snf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɓaa Kooh laak, súkúruki woꞌeencii Kooh. Wayee ɗú, ɗú súkúrukooca, ndaga Kooh laakkiirúu. ");
INSERT INTO snf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yaawúuꞌcaa woꞌussa Yéesu an: - Binaa ɗí woꞌ an fu samariteŋ ee fu taam na Seytaaninaa, ɗí woꞌꞌii kayohe?. ");
INSERT INTO snf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yéesu taassaɓa an: - Mi taammbii na Seytaani. Mi on Paammboo céeꞌ ee ɗú, ɗú onndiiroo céeꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi, mi heeliꞌtii haffoo ndam, ɓoꞌ yiliis yërí heeliꞌtoo iñaama ee yërí ƴah kiꞌattiꞌ. ");
INSERT INTO snf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","kayoh-kayohɗa mi woꞌꞌúuka: ɓaa fu am woꞌeenndoonaa, fu ínohanndii kikaankaa bi taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yaawúuꞌcaa dallari kiwoꞌ an: - Kimma kimma, ɗí ínohin an fu taam na Seytaani. Abaraham kaanin, sëldíiga-Koohcaa ɓan kaanuunun, ee fu, fu woꞌ an: «Ɓaa fu am woꞌeenndoonaa, fu kooroo ga kikaan bi taaꞌ.» ");
INSERT INTO snf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Paammbíi Abaraham, fu wëñnji kilaak solu hene? Ya, ya kaanin ee sëldíiga-Koohcaa ɓan kaanuunun. Fu tík haffu ɓa? ");
INSERT INTO snf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yéesu taassaɓa an: - Binaa mi heeliꞌ haffoo ndamaa, ndamaama enndii tús. Paammboo yërí ƴahhoo kiꞌeꞌ ndam, ya yii ɗú woꞌ an yërí en Koohyiigarúu. ");
INSERT INTO snf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","En kiꞌenaa, ɗú ínohoori, wayee mi, mi ínohinndi. Binaa mi woꞌee an mi ínohoorinaa, eneenaa mi ƴah kaakoh-saboh fodii garúu. Wayee mi, mi ínohinndi ee mi abin woꞌeeniigari. ");
INSERT INTO snf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Paammbúu Abaraham, keeñci soossa seɓ ga daa an ya hay kihot kihaykiigoo ëldúnaɗa. En kiꞌenaa, ya hotinka, ee ya neɓlukka ga. ");
INSERT INTO snf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yaawúuꞌcaa dallari kiwoꞌ an: - An ya? Fu laakkii sah tíkíis tidaaŋkaah-yëtúus, an fu hotin Abaraham! ");
INSERT INTO snf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yéesu taassaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: balaa Abaraham hay ëldúnanaa lak mi yërí en. ");
INSERT INTO snf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Daama, ɓa dalla kibalaɓ atoh, kitapisohhi. Wayee Yéesu múuƴca ga ɗuuƴ ɓuwaa, ya meƴca Kaanfaa Kooh. ");
INSERT INTO snf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Daa Yéesu enee na kipaaf, ya hotta ɓoꞌ yaa límu na kibúum. ");
INSERT INTO snf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tëelíbéecaagari meekisohussari an: - Jëgírohii, ɓii yii límu na kibúum. Baakaaꞌciigari kommbikanoo, caa ɓuwaa límmbiɗa? ");
INSERT INTO snf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yéesu taassaɓa an: - Enndii baakaaꞌci wala baakaaꞌ ɓuwaa límmbiɗa kommbika. Ya enin búumíꞌ doonaa Kooh mín kiteewoh tumeencaagari ga ɓii. ");
INSERT INTO snf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Waa ɗu ɓii ga noh, ɗu jomin kitum iñii ɓii wossoo nakkoo kitumɗa. Ndaga wekaa waa hay waa ken mínanndii kilëgëy dara. ");
INSERT INTO snf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","En lak mi yii lís ga ëldúnanaa, mi yërí en leeꞌlaatii ëldúna. ");
INSERT INTO snf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ga waa Yéesu lëehíꞌta kiwoꞌ fodaama, ya toossa kakay, ya tóoyíꞌta kakayfaa na mitoosmaa. Ya leeffa ga tuhastaa búumíraa, ");
INSERT INTO snf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ya woꞌꞌari an: - Kara, fu sëmúluknee ga músúmaa mbalkaa Sílowee. Woꞌeenaama waaꞌ kiwoꞌ «Wosuunun». Búumíraa kaꞌta, sëmúlukneera. Ya ɓoyukka lak hascaagari hotin say. ");
INSERT INTO snf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɓuwaa deeyoh nari kaanɗa na ɓuwaa ínoheeri ga kisarahtukɗa ɓaa woꞌ an: - Caɓ! Hanaa enndii ɓii yugee diine kisarahtukɗa kay? ");
INSERT INTO snf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɓii ɓaa woꞌ an: - Yërí sah-sah. Ɓíinoo ɓaa woꞌ an: - Óꞌóo, enndiiri, ɓa man hen. Wayee ɓaa, ga kihafci woꞌꞌa an: - Mi yërí kay! ");
INSERT INTO snf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓuwaa meekissari an: - Tum na bi fu mínnda kihot? ");
INSERT INTO snf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ya taassa an: - Ɓaa teeku Yéesu yërí tóoyíꞌ kakay, ya leeffa ga tuhastiigoo, ya woꞌꞌaroo an: «Karaa mbalkaa Sílowee, fu sëmúluknee ga músúmaa.» Mi kaꞌta, mi sëmúlukka, tuhastiigoo hotta. ");
INSERT INTO snf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓa meekissari an: - Yada ɓaa yaama? Ya taassa an: Mi ínohoo daa ya enɗa! ");
INSERT INTO snf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ɓuwaa ɓayya búumíraa wëkíruɗa ga Fërísiyeeŋcaa. ");
INSERT INTO snf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wiima, lak Yéesu tóoƴɗee kakayfaa ga bes Sabat, ya tummba bi hascaa búumíraa hotta. ");
INSERT INTO snf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iñaama tah, Fërísiyeeŋcaa ɓan meekisohussa ɓaa yaama iñaa tumsee bi ya mínnda kihotɗa. Ya woꞌꞌaɓa an: - Ya tumɗeeroo kakay fitóoyíꞌ ga hasciigoo, mi sëmúlukka, mi dalla kihot. ");
INSERT INTO snf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Laakka ga Fërísiyeeŋcaa, ɓaa woꞌ an: - Ɓii tum iñii yiiɗa, meyohhii ga Kooh, ndaga ya faaliꞌꞌii bes Sabat. Wayee ɓíinoo woꞌꞌa an: - Ɓoꞌ mín na kiteewoh mandargacaa man na cii en lak ya tumoh-baakaaraa? Kihëgískoh laakka ga díkaantiɓa. ");
INSERT INTO snf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fërísiyeeŋcaa meekisohussa ɓaa wëkíruɗa an: - Fu nak, fu ínoh ya ga ɓii tah hasciigaraa kihotɗa? Ya taassa an: - Iñaa sëldíiga-Kooh! ");
INSERT INTO snf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ɓuwaa kuliyuk ga yaawúuꞌcaaɗa tookséeríi kigëm an ɓaa ɓa hot yaama enee búumíꞌ. Ɓa ɓayneera ɓuwaa límmbiɗa, ");
INSERT INTO snf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ɓa meekissaɓa an: - Ɓii yii yërí en kowukiigarúu ɗú woꞌ an límu na kibúumɗane? Kon tum na bi ya yii mín kihot diima? ");
INSERT INTO snf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ɓuwaa lím búumíraaɗa taasussa an: - Ɗí ínohin an kowuríi ee ya límu na kibúum. ");
INSERT INTO snf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wayee daa ka en bi ya mínin kihotɗa, iñaama ɗí ínohoo dara ga. Ɓaa wëkíꞌ hasciigariɗa, ɗí ínohoori. Meekisatti: ya enin yaak, ee ya mínin hafci kiwoꞌiꞌ. ");
INSERT INTO snf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɓuwaa lím búumíraa wëkíruɗa woꞌsee iñaama kiniik ɓuwaa kuliyuk ga yaawúuꞌcaaɗa. Ndaga yaawúuꞌcaa yéegohseera ga an, ɓéeɓ ɓaa fu seediꞌ an Yéesu yërí en Kiristaaniinaa, ɓa kaallaa jaangaagaɓa. ");
INSERT INTO snf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iñaama tah ɓuwaa lím búumíraaɗa woꞌussa an «ya enin yaak, meekisatti». ");
INSERT INTO snf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fërísiyeeŋcaa ɓayussa ɓaa enee búumíꞌɗa kotaa kukanakkaa, woꞌussari an: - Woꞌɗaa Kooh rek! Ɗí ínohin an ɓaa yaama tumoh-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɓaa wëkíruɗa taassa an: - Ya en tumoh-baakaaraa, mi ínohhii dara ga. Wayee iñaa mi ínohɗa yërí en an mi búumeera ee diima mi yii hot. ");
INSERT INTO snf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Fërísiyeeŋcaa meekissari an: - Ya tumeeraa ya? Ya tumee na bi hasciigaraa mínnda kihot? ");
INSERT INTO snf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Búumíraa wëkíruɗa taassaɓa an: - Mi ɗewinndúuka kiwoꞌ ee ɗú súkúrukkiiroo. Ɗú waaꞌ ya ga kikeloh mi woꞌis? Hanaa ɗú ɓan ɗú waaꞌ kiꞌen ɓitëelíbéeci? ");
INSERT INTO snf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓa ɓaa ɓassi, woꞌussari an: - Fu yërí en tëelíbéeci kay? Wayee ɗí, ɗí tëelíbée Moyís. ");
INSERT INTO snf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɗí ínohin an Kooh woꞌin na Moyís, wayee ɓii yii, ɗí ínohoo sah dii ya meyohɗa. ");
INSERT INTO snf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɓaa taassaɓa an: - Iñaama, en kiꞌenaa dooyin waaꞌ. Ɗú ínohoo dii ya meyohɗa ee moona déy, yërí tum bi hasciigoo hotin! ");
INSERT INTO snf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ɗu ínohin an Kooh tookɗoo tumoh-baakaaꞌ. Wayee ya tookɗi ɓéeɓ ɓaa onndi céeꞌ ee tum iñaa ya waaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ken mosoo kikeloh daa ɓoꞌ wëkíꞌ ɓoꞌ, yaa límu na kibúum. ");
INSERT INTO snf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɓii yii meyohéeríi ga Koohaa eneenaa mínoo dara kitum. ");
INSERT INTO snf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓa taassari an: - Fu límu múlúŋ mút ga baakaaꞌ, an fu waaꞌtíi kijëgíꞌ! Waa ennda ɗa, ɓa kaallari fooh. ");
INSERT INTO snf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yéesu yéeŋnga an Fërísiyeeŋcaa kaaluunun ɓaa ya wëkíreeɗa fooh. Daa Yéesu hídohee nari, Yéesu meekissari an: - Fu gëmin ga Kowukii ɓiine? ");
INSERT INTO snf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɓaa taassa an: - Haꞌmudii, ɓaama ya ɓa, mi gëm gari? ");
INSERT INTO snf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yéesu woꞌꞌari an: - Kon book fu hotinndi, ndaga ɓii woꞌ naraaɗa yërí! ");
INSERT INTO snf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɓaa woꞌꞌa Yéesu an: - Haꞌmudii, mi gëmin garaa! Fodaama ya ƴíꞌꞌa ga fíkíi Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lëehíꞌta Yéesu woꞌꞌari an: - Mi hay ëldúna doonaa ëldúna laak attiꞌ: en ɗanaa búumíꞌcii hot lañ ee ɓuwii en na kihotɗa búumu tërúus. ");
INSERT INTO snf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Laakka Fërísiyeeŋcaa ensee daama nari. Daa ɓa kelohee iñaa Yéesu woꞌɗa, ɓa meekissari an: - Kon ɗí ɓan, ɗí iñcii búumíre? ");
INSERT INTO snf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yéesu taassaɓa an: - Ɗú enee ɓibúumíraa eneenaa ɗú enoo ɓitumoh-baakaaꞌ! Wayee ɗú woꞌ an: «Ɗí hotin», kërí tah ɗú tes ɓitumoh-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","- kayoh-kayohɗa mi woꞌꞌúuka: Ɓaa aas ngídii baalcii ee koorohhii halii wayee këldúkoh diliisaa, ɓaama iñaa lok, iñaa gúroh-waas. ");
INSERT INTO snf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wayee ɓaa aasoh haliiɗa, yërí en níirohii baalcii. ");
INSERT INTO snf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɓaa neehi yopaa kiwatuk baalcaaɗa hayyi kilëgísiꞌ halaa ee baalcaa kelohsin koonaaci. Ya ɓay baalcii en ɓuuciɗa, yaa en ɓéeɓ ga teekaagari, ya meƴdohɓa fooh. ");
INSERT INTO snf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Binaa ya meƴdoh baalcaagari ɓéeɓɓanaa, ya kuliyuk ga fíkíi, ɓa taabukiri ndaga ɓa ínohin koonaakaagari. ");
INSERT INTO snf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Baalcaa taabukanndii múk ɓaa ɓa ínohoo, ɓa namanndi kinúp hen kay ɓa úsaayyi ndaga ɓa ínohoo koonaakaagari. ");
INSERT INTO snf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yéesu liiwukkaɓa fodaama, wayee ɓa ínohéeríi iñaa ya waaree kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yéesu woꞌissaɓa an: - kayoh-kayohɗa mi woꞌꞌúuka: mi yërí en halii ngídii baalcii. ");
INSERT INTO snf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓuwaa ɗeɓpoo kihayɗa, ɓéeɓɓa ɓilok na ɓigúroh-waas, wayee baalcaa súkúrukussiiɓa. ");
INSERT INTO snf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi yërí en halii. Ɓaa aas, kooroh garoonaa hay kimúc. Ya hay kimín kiꞌaasi, ya meyi ee ya hay kihot iñaa ya líifɗohan lookci. ");
INSERT INTO snf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Lok nak, kilok, kiꞌap, na kiyah doŋ haydohiri. Mi nak, mi hay doonaa ɓuwii laak kipes ee ɓa laakka bi dooy sëk. Yéesu tíkíꞌta Fërísiyeeŋcaa ga an: ");
INSERT INTO snf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","- Mi yërí en níirohii yijófíꞌyii. Níiroh yijófíꞌ erohi kumuunci hen ndaga baalcaagari. ");
INSERT INTO snf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wayee ɓaa enndii níiroh, laakkii baalcaa ee kopaꞌ doŋ tahhi kiníiꞌ. Ya hoti gumuu hayinaa, ya dal kinúp, ya foñ baalcaa, gumuufaa am ga baalcaa, tasaaroh yopaa. ");
INSERT INTO snf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Níirohaama núpin ndaga kopaꞌ tahhi kiníiꞌ ee baalcaa ɓíttiiri. ");
INSERT INTO snf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mi yërí en níirohii yijófíꞌyii. Fodii dii Paamudii ínohhoo ee mi ínohinndiɗa, fodaama ɓan, mi ínohin baalciigoo, ee baalciigoo ínohinndoo. Ee ɓan, mi hay kiꞌeroh kumuunkiigoo ndaga baalciigoo. ");
INSERT INTO snf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi laakin ɓan baal ɓiliis ɓaa enussii ga ngídii wii ee mi jominɓa kihaydoh. Ɓa hay kisúkúruk iñaa mi woꞌɗa. Fodaama ɓa en yop wíinoo, níirohii en yíinoo. ");
INSERT INTO snf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Paamudii waarinndoo ndaga mi hay kiꞌeroh kumuunkiigoo, mi laasiska. ");
INSERT INTO snf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","En kiꞌenaa, ken mínoo kiɓeɓ kumuunkiigoo. Newanndoo hen mi erohka. Mi laakin dooli kiꞌeroh kumuunkiigoo na kilaasiska. Iñuma yërí Paammboo nakkoo kitum. ");
INSERT INTO snf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Woꞌeencaa Yéesu woꞌ caama haydohissa kihëgískoh ga ɗuuƴ yaawúuꞌcaa. ");
INSERT INTO snf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɓiyewin gaɓa, ɓaa woꞌ an: - Ɓii yii taam na Seytaani, ŋalaañkin! Ɗú en ya dii ɗú súkúrukiri? ");
INSERT INTO snf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wayee ɓuwaa ɓíinoo, ɓaa woꞌ an: - Ɓaa taam na Seytaani woꞌoo woꞌeencii cii de! Ee sah, Seytaani mín na kiꞌon búumíꞌ kihot? ");
INSERT INTO snf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hídukoh ga jamaanu fiyoon, laakka feet ga Yéerúsaleem waa yaawúuꞌcaa feeti kiníindísuk besaa ɓa díŋkaanee Kooh Kaanfaagariɗa. ");
INSERT INTO snf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yéesu enee ga Kaanfaa Kooh, ya yaa tíidísuk ga ɗekataa woꞌu «Ruumaa Salomonɗa.» ");
INSERT INTO snf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yaawúuꞌcaa dalla kihayu, wíilussari, ɓa woꞌꞌari an: - Fu íisanndíi ga kúmpafii bi kera? En an fu yërí en Kiristaaniinaa, woꞌaaríika bi leeꞌ lañ. ");
INSERT INTO snf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yéesu taassaɓa an: - Iñaa mi woꞌeerúuka kera? Wayee ɗú gëmmbiiroo. Iñcii mi tumi ga teekii Paammbooɗa cërí seediꞌꞌoo. ");
INSERT INTO snf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wayee ɗú gëmmbiiroo ndaga ɗú bokkii ga baalciigoo. ");
INSERT INTO snf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baalciigoo súkúruksin iñaa mi woꞌɗa. Mi ínohinɓa ee ɓa ɓii taabukkoo. ");
INSERT INTO snf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi onɓa kipeskaa leehoo taaꞌɗa, ɓa saŋkuꞌoo múk ee ken teꞌooɓa ga yahhoo. ");
INSERT INTO snf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iñii Paammboo eꞌtooɗa yërí wëñ kiyak iñaa en ɓéeɓ ee ken mínoo kiteꞌ dara ga yah Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mi na Paamudii, ɗí wíinoo. ");
INSERT INTO snf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Daama nak, yaawúuꞌcaa balawissa atoh kitapisoh Yéesu bi ya kaan. ");
INSERT INTO snf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yéesu dallaɓa kiwoꞌ an: - Mi tumin ga fíkíirúu enaama ciyewin cijófíꞌ, caa Paamudii onndoo kitum. Wiida ga tumeencaama tah bi ɗú waaꞌtoo kitapisoh atoh bi mi kaan? ");
INSERT INTO snf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yaawúuꞌcaa woꞌꞌari an: - Tumeen wijófíꞌ tahhii bi ɗí waaꞌtaa kitapisoh atoh, wayee dii fu ɓas Koohɗa tah. Ndaga fu ɓoꞌ doŋ ee fu waaꞌ haffu kitík Kooh. ");
INSERT INTO snf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yéesu taassaɓa an: - Bíduunun ga Këyítfaa waasiigarúu an Kooh woꞌin an: «Ɗú ɓikooh». ");
INSERT INTO snf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɓuwaa Kooh ëewdoh woꞌeenaama gaɓaɗa ya teekɓa ɓikooh ee iñaa Këyítfaa woꞌɗa ken mínoori kinís. ");
INSERT INTO snf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mi, Kooh yërí tanukkoo, wossaroo ëldúna. Kon ɗú mín na kiwoꞌ an mi ɓasin Kooh ga dii mi woꞌ an mi kowu Koohɗa? ");
INSERT INTO snf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","En lak mi tummbii iñcii Paammboo nakkooɗanaa, kaa gëmattoo. ");
INSERT INTO snf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wayee en lak mi tumcanaa, luu enee an ɗú waaꞌtiiroo kigëm sah, gëmat tumeenciigoo, en ɗanaa ɗú ínoh píŋ an Paamudii yii garoo ee mi yii ga Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Daama, ɓa ɓaa heelis kiꞌam Yéesu, wayee ya rëccaɓa. ");
INSERT INTO snf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Waa ennda ɗa, Yéesu karissa ɓakaa hanoh húlúwaa Yúrdeŋ gaaɗa, ga daa Saŋ bëtísiꞌohee ɓuwaaɗa, ya ennda daama. ");
INSERT INTO snf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓoꞌ ɓiyewin hayussa gari ee ɓa ɓaa woꞌ an: - Saŋ déy tummbii kíntaan wíinoo, wayee ɓéeɓ iñaa ya woꞌee ga ɓii yiiɗa enee kayoh. ");
INSERT INTO snf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Waa ennda ɗa ɓoꞌ ɓiyewin daama gëmussa ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Laakka ɓaa keen ɗúukool. Ya teeksee Lasaaꞌ ee dëkee Bétaníi, dëk-kawaa Mërí na Marta dëkohɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mërí yiima yërí en yaa leefee laꞌkoleñaa ga kotcaa Haꞌmudii, ya moossaca na fenfaagariɗa. Këmëeŋkíɓa Lasaaꞌ yërí ɗúukoolee.) ");
INSERT INTO snf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yaakmuncaa Lasaa ɓanakɓaa ɓiɓetiɓaa wosohussa ga Yéesu kiwoꞌꞌi an: - Haꞌmudii, fiiliifu ɗúukoolin. ");
INSERT INTO snf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Daa Yéesu kelohee iñaama, ya woꞌꞌa an: - Ɗúukoolaa Lasaaꞌ waama, ɓayoo kumuunci, wayee wa ƴah kiteewoh ndamii Kooh, ee doonaa Kowukii Kooh laak Ndam ga. ");
INSERT INTO snf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marta na këmëeŋkíci Mërí na Lasaaꞌ ensee ɓuwaa Yéesu waarin. ");
INSERT INTO snf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yéesu ɓaatta kiyuŋ bes kanak ga ɗekataa ya enoheeɗa ee lak ya yéegin an Lasaaꞌ ɗúukoolin. ");
INSERT INTO snf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lëehíꞌta ya woꞌꞌa tëelíbéecaagari an: - Ɗu ɓoyukat Yúudée. ");
INSERT INTO snf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tëelíbéecaagari taassari an: - Jëgírohii, maañnjii dara, yaawúuꞌcaa heelseeraa kitapisoh na atoh bi fu kaan ee an fu waaꞌ kiɓoyukis daama! ");
INSERT INTO snf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yéesu woꞌꞌaɓa an: - Hanaa noh-noh wíinoo tumirii wahtu cidaaŋkaah na wahtu kanak? Binaa ɓoꞌ tíin na nohaa, ya këftukoo, ndaga ya hoti leeꞌlaatii ga ëldúnaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wayee binaa ɓoꞌ tíin na wekaa, hay kikëftuk ndaga ya taammbii na leeꞌlaat. ");
INSERT INTO snf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lëehíꞌta, ya tíkka ga an: - Fiiliiruu Lasaaꞌ neehin, mi hay kikaꞌ, mi yúunneeri. ");
INSERT INTO snf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tëelíbéecaa taassa an: - Haꞌmudii, en lak ya neeh henaa, ya hay kitani. ");
INSERT INTO snf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yéesu woꞌee kikaankaa Lasaaꞌ, wayee tëelíbéecaagari fooŋsee an ya woꞌ pëní-fayaaŋ. ");
INSERT INTO snf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yéesu dallaɓa kiwoꞌ faŋ an: - Lasaaꞌ kaanin, ");
INSERT INTO snf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","laakkiiroo da, wayee ɗú tah ka newohharoo ɗa, en ɗanaa ɗú gëm garoo. Ɗu ƴahat kon bi gari. ");
INSERT INTO snf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Waa ennda ɗa, Toomaa yaa woꞌu Síisaaɗa, woꞌꞌa tëelíbéecaa ɓíinoo an: - Ɗu ɓan, ɗu karat na Jëgírohii, ɗu kaannee nari! ");
INSERT INTO snf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ga waa Yéesu leꞌɗa, ya laak Lasaaꞌ acuunun bi laakin bes cinikiis. ");
INSERT INTO snf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bétaníi en ga yahaa Yéerúsaleem, ee ca úsaayohin iñaa leꞌ kíloomeet kaahay. ");
INSERT INTO snf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lak yaawúuꞌ ɓiyewin hayuunun ga Marta na Mërí kicolukɓa ga këmëeŋkíɓa yaa kaanɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Daa Marta kelohee an Yéesu hayin, ya meƴca kitëebílukki, wayee Mërí yuŋnga ga kaanfaa. ");
INSERT INTO snf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta dalla kiwoꞌ Yéesu an: - Haꞌmudii, fu enee diinaa, eneenaa këmëeŋkíroo kaanoo. ");
INSERT INTO snf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wayee bi diima sah, mi ínohin an tóoh iñaa fu kíim Koohaa, onndaari. ");
INSERT INTO snf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yéesu woꞌꞌa Marta an: - Këmëeŋkífu hay kimílís. ");
INSERT INTO snf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta taassa an: - Mi ínohin an ya hay kimílís besaa ɓuwaa mílísan bëríi ga besaa mëeñjohɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yéesu woꞌꞌari an: - Mi en kimílís, mi en kipes. Ɓaa gëm garoonaa, luu ya kaanee, ya hay kipes. ");
INSERT INTO snf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ee ɓaa pes gëm garoo tóoh, kaanoo múk. Fu gëmin iñume? ");
INSERT INTO snf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta taassa an: - Ee Haꞌmudii, mi gëmin dijófíꞌ an fu yërí en Kiristaanii, Kowukii Kooh, yii jomee kihay ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Daa Marta lëehɗee kiwoꞌ fodaama, ya yaa ƴah kiɓaynee Mërí këmëeŋkíci. Ya leꞌꞌa, móodíꞌtari an: - Jëgírohii yii dii, ee ya meekisohhaa. ");
INSERT INTO snf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Daa Mërí kelohee iñaama, ya dalla kikoluk, yaa ƴah ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wiima lak Yéesu aassii dëkaa duum, wayee ya lísee kites ga ɗekataa Marta hayeeri kitëebílukɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yaawúuꞌcaa wéetalsee Mërí ga kaanfaaɗa, daa ɓa hotee Mërí kolukka, yaa íisuk fooh, ɓa ɓaa taabukki. Ɓa foogee an ya ƴah loyaa kidayuknee daama. ");
INSERT INTO snf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Daa Mërí leꞌee ɗekataa Yéesu enoheeɗa, ya hottari, ya ƴíꞌꞌa ga kotcaagari, woꞌꞌa Yéesu an: - Haꞌmudii, fu enee diinaa eneenaa këmëeŋkíroo kaanoo. ");
INSERT INTO snf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Daa Yéesu hotee Mërí yaa koduk, ya na yaawúuꞌcaa taabee nariɗa, faanci púnnda keeñci leehha, ");
INSERT INTO snf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ya meekissaɓa an: - Ɗú ac Lasaaꞌ gaɗa? Ɓa taassari an: - Haꞌmudii, haya fu hot. ");
INSERT INTO snf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Daama Yéesu kodukka. ");
INSERT INTO snf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Waa ennda ɗa, yaawúuꞌcaa ɓaa woꞌ an: - Malkat dii ya hídeeri kiwaaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wayee laakka gaɓa ɓaa woꞌ an: - Ya yii ya onee búumíraa kihotɗa, ya mínéeríi ɓan kitum bi Lasaaꞌ kaanoone? ");
INSERT INTO snf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Waa ennda ɗa, ɓaatissa ga, keeñaa Yéesu wëñnja kileeh, ya yaa ƴah loyaa. Loyaa enee nogaa yotu ga jaŋjagaa ee atoh wiyaak lagussa ga kúuwkaa. ");
INSERT INTO snf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yéesu woꞌꞌa an: - Nísat atohii! Marta, yaak yii kaanɗa, woꞌꞌari an: - Haꞌmudii, ya jomin kidal kiꞌot ndaga tumin bes cinikiis caa ya en ga ɗuuƴ loyii. ");
INSERT INTO snf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yéesu taassari an: - Mi woꞌéeríiraa an binaa fu gëmaa, fu hay kihot ndamii Koohe? ");
INSERT INTO snf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓa níssa atohaa. Yéesu ɓëwíꞌta hascaagari ɗook asamaan, woꞌꞌa an: - Paamudii, mi gërëminndaa ga dii fu súkúrukinndooɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi ínohin an fu súkúrukinndoo besaa en ɓéeɓ. Wayee ɓuwii wíilloo ɓii ɓërí tah mi woꞌ iñii yii, doonaa ɓa gëm an fu wossoo. ");
INSERT INTO snf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Daa Yéesu lëehɗee kiwoꞌ iñaama, ya fiippa koonaa ga ɗook an: - Lasaaꞌ, meyaa fooh! ");
INSERT INTO snf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasaaꞌ meƴca fooh, kotcaagari na yahcaa múuluunun na lëmíi, fíkíifaa kúnukin na úuf. Yéesu woꞌꞌa ɓuwaa an: - Múulísatti, ɗú íissi ya ƴee! ");
INSERT INTO snf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yaawúuꞌ ɓiyewin ga ɓaa hayee kaan Mërí ee hotsee iñaa Yéesu tumee yaamaɗa, gëmussa gari. ");
INSERT INTO snf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wayee laakka gaɓa ɓaa kaꞌ ga Fërísiyeeŋcaa, ɓéestíꞌtaɓa iñaa Yéesu tumeeɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Waa ennda ɗa, sarahohcaa ɓiyaakɓaa na Fërísiyeeŋcaa dalla kiɓëytoh paanaa wiyaakwaa. Ɓa woꞌꞌa an: - Ɓii yii kat, iñii ya tum ga kíntaanɗa hëpin. Ɗu tuman na? ");
INSERT INTO snf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Binaa ɗu íissi ga iñii ya enukohɗanaa, ɓéeɓ hay gari kigëm, ee baanaa ɓu-Room hay kikeenu ga ɗookkuu, ɓa pook Kaanfaa Kooh, ɓa tas heetiigaruu! ");
INSERT INTO snf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kayíf, yíinoo gaɓa ee kíisci laakki lak yërí enee haꞌ-kaadaa sarahohcaa, dalla kiwoꞌ an: - Ɗú daal, ɗú ínohoo iñii laakɗa. ");
INSERT INTO snf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ɗú hottii an iñaa gën garúuɗa yërí en ɓoꞌ yíinoo kaniꞌ ɓéeɓ kúlkiine? Fodaama heetii ɗúboo ɓéeɓwa. ");
INSERT INTO snf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","En kiꞌenaa, iñaa Kayíf woꞌ yaama meyohéeríi gari. Ya yërí enee haꞌ-kaadaa sarahohcaa kíisci, ee fodii sëldíiga-Kooh ya woꞌꞌa an Yéesu jomin kikaan ndaga heetaagari. ");
INSERT INTO snf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Enndii an Yéesu jomee kikaaniꞌ heetaagari doŋ, wayee ɓan ya jomee kikaan, doonaa ya hídíroh ɓéeɓ towutii Kooh tasarukoh ga ëldúnaɗa, ee ɓa en heet wíinoo. ");
INSERT INTO snf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aboh ga besaa bëríi, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa abussa an ɓa hay kiꞌapluk Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iñaama tahha Yéesu íissa kikari na kihayi ga ɗuuƴ yaawúuꞌcaa, ɓéeɓ hotiri. Ya nammba kikaꞌ teeraa Efarayím ga gohaa hanoh ɓak ëgíꞌ-dúndagaaɗa. Ya ennda daama na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Waama lak feetaa Paakaa Yaawúuꞌcaa deeyin, ɓoꞌ ɓiyewin meyohussa gohcaa ɓa dëkohɗa, karussa Yéerúsaleem kisétíꞌsiruk, balaa feetaanaa. ");
INSERT INTO snf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓa ɓaa raas Yéesu, ee ga ɗuuƴ Kaanfaa Kooh ɓa enoheeɗa, ɓa ɓaa meekisoh ga díkaantiɓa an: - Ɗú ínoh ya ga? Ya hayanndii feetiine? ");
INSERT INTO snf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sarahohcaa ɓiyaakɓaa na Fërísiyeeŋcaa nakohsee an laak ɓaa ínoh daa Yéesu enohɗanaa, ya leꞌdohatka gaɓa, en ɗanaa, ya abu. ");
INSERT INTO snf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yéesu kaꞌta Bétaníi, ga daa Lasaaꞌ, yaa ya mílísɗee dëkohɗa, lak tes ga bes ciyitniinoo Paakaa yaawúuꞌcaa leꞌ. ");
INSERT INTO snf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya tíkɗussa cuuníin daama. Marta yërí norohee ee Lasaaꞌ bokee ga ɓuwaa bok na Yéesu kanuɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Waa ennda ɗa, Mërí ɓeɓpa iñaa hín na leꞌ-líitaꞌ ga laꞌkoleñ wiséeríꞌ waa koocussii ee hëwrohu kedikkaa woꞌu naaꞌ. Ya íiffawa ga kotcaa Yéesu, lëehíꞌta ya yaa moosca na fenfaagari. Kaanfaa ɓéeɓ eeñnja ban na ngetaa laꞌkoleñaa. ");
INSERT INTO snf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Wayee Yúdaa Iskariyot, yíinoo ga tëelíbéecaa Yéesu ee yërí naranndi kiꞌon bíiŋɗa, woꞌꞌa an: ");
INSERT INTO snf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","- Laꞌkoleñuma mínéeríi kitoonu kopaꞌ wiyewin, wa sarahohu ɓuwii laakooɗane? ");
INSERT INTO snf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yúdaa woꞌ iñaamanaa enndii an helci karee ga ɓuwaa laakooɗa, wayee ya enee lok. Yërí ɗaakee nafa-hëelísaagaɓa ee iñaa aasi gaɗa, ya daanee ga kiloki hen. ");
INSERT INTO snf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yéesu nak woꞌꞌa an: - Íisaa haꞌci! Laꞌkoleñii wii wërí ya ɗëwíꞌ ee wa aaw besaa mi ƴah kiꞌeku ga loyaaɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɓuwii laakooɗa, ɓa ƴah narúu dii besaa en ɓéeɓ. Wayee mi, mi ƴahhii narúu kiꞌen dii bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ɓoꞌ ɓiyewin ga yaawúuꞌcaa yéegussa an Yéesu yaa ga Bétaníi, ɓa ɓaa ƴah daama. Ee en kiꞌenaa kihot Yéesu rek ɓayéeríiɓa daama, wayee ɓa waaree kihot ɓan Lasaaꞌ yaa Yéesu mílísɗeeɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sarahohcaa ɓiyaakɓaa júwohussa kon ga kiꞌapluk Lasaaꞌ ɓan, ");
INSERT INTO snf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndaga ya yërí tah yaawúuꞌ ɓiyewin foñussaɓa, gëmussa ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ga kooh-wíisfaa, ɓoꞌ ɓiyewin ga ɓaa hay feetaa Paakɗa yéegussa an Yéesu yaa hay teeraa Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓa dalla kiheel sooꞌsooꞌ, ɓa meƴca teeraa kihídohnee nari, ɓa ɓaa woꞌ didóolíꞌ an: - Óosaanaa! Kooh barkeelat ɓii hay ga teekii Haꞌmudiiɗa, buurii Isarayeel! ");
INSERT INTO snf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Fodaa daa bídu ga Këyítfaaɗa, Yéesu ɓeɓpa cúmbúꞌ-baam, ya lappa ga ɗookgaa. En kiꞌenaa, Këyítfaa woꞌ an: ");
INSERT INTO snf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Kaa tíitat ɗú, ɓu-Síyoŋ, Buuriigarúu yeema hayi, ya lap cúmbúꞌ-baam.» ");
INSERT INTO snf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ga wahtaa iñcaama laakɗa, tëelíbéecaa Yéesu ínohséeríi iñaa ca waaree kiwoꞌɗa. Wayee ga waa Kooh eꞌ Yéesu ndam ga tóohɗa, ɓa níindísukka iñcaa aaw gari, bínsee ga Këyítfaa ee ɓa ínohha an iñcaama tóoh laakin gari. ");
INSERT INTO snf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɓéeɓ ɓuwaa maasohee ga waa Yéesu woꞌ Lasaaꞌ kimeƴ loyaa, ya mílísiꞌtariɗa, seediꞌussa iñaa ɓa hoteeɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","En kiꞌenaa, lak ɓoꞌ ɓiyewin kelohuunun an Yéesu tumin kíntaanaa waama, kërí tah ɓa hayya kihídohnee nari. ");
INSERT INTO snf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fërísiyeeŋcaa nak ɓaa woꞌ ga díkaantiɓa an: - Ɗú hotine, ɗu mínoo dara ga, malkat ɓéeɓ ɓuwii ɓii taabukki. ");
INSERT INTO snf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Laakeera ɓiGerek ga ɓuwaa hayee Yéerúsaleem, ga feetaa yaawúuꞌcaa, kijaamuk Koohɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓa kaꞌta ga Filiip. Filiip yaama dëkee Betsaydaa, dëk-kaw ga gohaa Gëlílée. Ɓa woꞌꞌari an: - Kiyaakii, ɗí waaree kihot Yéesu! ");
INSERT INTO snf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filiip kaꞌta woꞌneeraka Andari. Ɓa taammba ɓa ɓanak, ɓa woꞌneera Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yéesu woꞌꞌaɓa an: - Wahtii leꞌin, wii Kowukii ɓii ƴah kilaas ga ndamiigariɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","kayoh-kayohɗa mi woꞌꞌúuka: binaa kupesoh keen ga kakay, ja kaanndiinaa, ja tesan kupesoh. Wayee binaa ja kaanaa, ja hay kilím towu tiyewin. ");
INSERT INTO snf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɓaa fu keeñuk kipesfunaa, fu hayka kiñak bi taaꞌ. Wayee ɓaa fu líkkii helfu ga kipeskiigaraa doŋ ga ëldúnaɗanaa, fu hay naka kites, fu pes bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɓaa waaꞌtoo kisúrgaꞌukaa, ya taabukattoo, ee daa mi enohɗa, súrgaagoo ɓan ƴah da. Ɓaa súrgaꞌuk garoonaa Paammboo hayyi kiꞌon céeꞌ. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","- Diima deŋ heliigoo hícukohin. Haa mi woꞌan ya? Mi woꞌan an: «Paamudii, músalaaroo ga coonucii ƴahhoo kidal ga wahtiimane?» Múk! Man kikooꞌ ga coonucii ga wahtiimaɗa tahhoo kihay. ");
INSERT INTO snf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paamudii, eraa teekiigaraa ndam! Waa ennda ɗa, laakka koonaakaa meyoh ɗook-Kooh, woꞌꞌa an: - Mi erinwa ndam kumëeñíꞌ ee mi haywa kiꞌeꞌsis ndam. ");
INSERT INTO snf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ga mbooloomaa enee daama ee kelohsee koonaakaaɗa, laakka ɓuwaa woꞌ an: - Iñaa íníŋ! Ɓíinoo an: - Malaaka woꞌ nari! ");
INSERT INTO snf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wayee Yéesu woꞌꞌaɓa an: - Enndii haffoo tah koonaakuma kikelohuk, wayee ɗú ɓërí tahka kikelohuk. ");
INSERT INTO snf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Diima deŋ wahtii ëldúna ƴah kiꞌattiꞌohuɗa leꞌin. Diimanaa buurii yibóníꞌyii tík yah ga ëldúnaɗa kaalu ga fooh. ");
INSERT INTO snf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ee mi, binaa mi ɓëwíru, mi tíim kakayfiinaa, mi hay kinook ɓuwii ɓéeɓɓa, ɓa hay garoo. ");
INSERT INTO snf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yéesu woꞌee iñaama, kiteewoh daa kikaankaagari ƴah kimanɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mbooloomaa taassari an: - Ɗí jaŋ ga Këyítfaa Waasiigaríi an Kiristaanii pesan bi taaꞌ. Kon fu mín na kiwoꞌ an Kowukii ɓii jomin kiɓëwíru ka tíim kakayfii? Ɓii en Kowukii ɓii yaama, ya ɓa? ");
INSERT INTO snf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yéesu woꞌꞌaɓa an: - Leeꞌlaatii wii lís kiꞌen narúu, wayee ƴahissii kimaañ. Tíidat, waa leeꞌlaatii wii narúu, en ɗanaa wek betoorúu, ñúus ammbúu. Ɓaa tíin ga ñúus ínohoo daa ya aawoh. ");
INSERT INTO snf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gëmat ga leeꞌlaatii waa wa wii narúu, en ɗanaa ɗú en ɓiɓoꞌ leeꞌlaat. Daa Yéesu woꞌeeɓa iñaama bi lëehíꞌta, ya kolukka yaa ƴah, ya ɗaakukkaɓa. ");
INSERT INTO snf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kíntaancaa Yéesu tum ga fíkíi yaawúuꞌcaaɗa, ga daa ca hín kiyewinɗa tóoh, tahhii bi ɓa gëmmba gari. ");
INSERT INTO snf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fodaama, iñaa Ísayíi, sëldíiga-Koohaa woꞌeeɗa matta. Ya woꞌee an: «Haꞌmudii, ɓii gëm iñii ɗu yéegalohɗa ɓa? Haꞌmudii teeɓ ɓa dooliigari?» ");
INSERT INTO snf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ee iñaa tah ɓa mínndii kigëmɗa, Ísayíi woꞌissa ga an: ");
INSERT INTO snf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Kooh búumíꞌta hascaagaɓa, ya yëgísíꞌta keeñcaagaɓa, doonaa ɓa hotoo na hasɓa, ee ɓa ínohoo ga keeñɓa.» Kooh tíkka ga an: En ɗanaa, ɓa súpítoo kipeskaagaɓa, mi wëkíꞌɓa. ");
INSERT INTO snf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ísayíi woꞌꞌa iñaama ndaga lak ya hotin ndamaa Yéesu, ee ya woꞌee iñaa aaw gari. ");
INSERT INTO snf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wiima sah, lak ga ɓuwaa kuliyuk ga yaawúuꞌcaaɗa, ɓiyewin gaɓa gëmseera ga Yéesu. Wayee ɓa kaañnjii kiseediꞌ ngëmaagaɓa ndaga Fërísiyeeŋcaa. Ɓa niikee kikaalu ga jaangu-yaawúuraa ");
INSERT INTO snf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","En kiꞌenaa, gërëmaa meyoh ga ɓoꞌ-súusúus gënëlɓa gërëmaa meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Waa ennda ɗa, Yéesu woꞌꞌa ga ɗook an: - Ɓaa gëm garoonaa, ya gëmmbii, eemmba garoo doŋ, wayee ya gëm ga ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɓaa hottoonaa, hotin ɓaa wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi en leeꞌlaat ee mi hayin ëldúna doonaa ɓéeɓ ɓaa gëm garoonaa dëksisoo ga ñúus. ");
INSERT INTO snf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɓaa keloh woꞌeenciigoo ee ya ammbiicanaa, enndii mi ƴahhi kiꞌattiꞌ. En kiꞌenaa, kiꞌattiꞌ ëldúna haydohhiiroo, wayee mi hay kimúsal ëldúna. ");
INSERT INTO snf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɓaa saŋngoo ee tookkii woꞌeenciigoonaa, attiꞌohaagari tuukin tek. Yërí en woꞌeenii mi jëgírohɗa, ee bëríinaa ëldúna túkiꞌanɗa wërí ƴahhi kiꞌattiꞌ. ");
INSERT INTO snf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ndaga mi woꞌꞌii ga teekkoo wayee Paamudii wossooɗa yërí nakkoo ga kihafci iñii mi jom kiwoꞌ na iñii mi jom kijëgírohɗa. ");
INSERT INTO snf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ee wóorinndoo hël an iñii ya nakohɗa wërí onohi kipeskaa leehoo taaꞌɗa. Kërí tah jëgírohiigoo, mi tumwa fodaa daa Paamudii nakkooka kitumɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Enee ga besaa balaa Paakaa yaawúuꞌcaa. Yéesu ínoheera an wahtaa ya jom kikolkoh ëldúna, ya ɓoyuk ga Paamciɗa leꞌin. Ya mosee kiwaaꞌ ɓuunci ga ëldúna ee ya waaꞌtaɓa bi ga daa ya kaanoh. ");
INSERT INTO snf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yéesu enee na kicuuníinuk na tëelíbéecaagari. Seytaani, lakanaa tumin kumëeñíꞌ ga keeñaa Yúdaa Iskariyot, kowukaa Simoŋ, halaat kitoon Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yéesu ínoheera an ya meyoh ga Kooh ee ya ƴah kiɓoyukis gari. Ee ɓan ya ínoheera an Kooh, Paamudii tíkin tóoh ga yahci. ");
INSERT INTO snf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Fodaama ya kolukka ga cuuníinfaa, ya ɗolla kúltífaagari hanoh ɗookɗa, ya ɓeɓpa úuf, pëkírukka. ");
INSERT INTO snf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lëehíꞌta ya íiffa músú ga kanu, ya yaa tís kotcaa tëelíbéecaagari, ee ya yaa moosca na úufaa ya pëkírukeeɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Daa ya leꞌ bi ga Simoŋ-Peeꞌ, yaama woꞌꞌari an: - Fu Haꞌmudii, fu tísiꞌtoo kotciigoone? ");
INSERT INTO snf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yéesu loffari an: - Iñii mi tum yii, fu ínohoori diimaɗa, wayee fu ínohanndi ga iñii aaw fíkíiɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peeꞌ woꞌꞌari an: - Kitísiꞌtoo kotciigoone? Múk! Yéesu loffari an: - Mi tísiꞌtiiraacanaa, fu boksisoo naroo ga dara. ");
INSERT INTO snf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoŋ-Peeꞌ woꞌꞌari an: - En ɗanaa Haꞌmudii, kaa eem ga kitís kotcii rek, wayee tísaa yahcii na hafii ɓan. ");
INSERT INTO snf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yéesu woꞌꞌari an: - Ɓaa ɓookkin, soolukkii kitísuk, enndii kotcaa rekaa, ndaga lak ya setin wic. Ɗú nak, ɗú setin wayee enndii ɓéeɓpúu. ");
INSERT INTO snf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yéesu ínoheera ɓaa ƴahhi kitoonɗa, kërí tah ya woꞌꞌa an «ɗú setin wayee enndii ɓéeɓpúu.») ");
INSERT INTO snf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ga waa ya lëehíꞌtaɓa kitísiꞌ kotcaaɗa, ya ekkissa kúltífaagari, ya yugissa kiñam, woꞌꞌaɓa an: - Iñii mi tumiꞌtúuɗa, ɗú ínohinndine? ");
INSERT INTO snf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɗú, ɗú ɓayiroo «Jëgírohii», ɗú ɓayiroo «Haꞌmudii», ee ɗú woꞌ kayoh ndaga mi yërí. ");
INSERT INTO snf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kon en lak mi Haꞌmudii, mi Jëgírohii, mi tísiꞌtúu kotaa, ɗú ga kihaffúu, yaa en ɓéeɓ ɓan jomin mooroomci kitísiꞌ kot. ");
INSERT INTO snf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mi teewinndúu waas, doonaa fodii dii mi tumiꞌtúuɗa ɗú tumɗa ɓan. ");
INSERT INTO snf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kayoh-kayohɗa mi woꞌꞌúuka: súrga wëñoo kilaak solu haꞌ-kaanci ee ɓaa wosu hen wëñoo kilaak solu ɓaa wossiɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ɗú ínohin iñaama. Kon binaa ɗú taabukkanaa, ɗú hay kiyewin múuꞌ. ");
INSERT INTO snf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yéesu woꞌꞌa tëelíbéecaagari an: - Enndii ɗú ɓéeɓpúu, ɗú tahhoo kiwoꞌ. Mi ínohin ɓuwaa mi tanukɗa. Wayee iñii Këyítfaa woꞌ yii jomin kilaak: «Ɓaa bokee naroo kanuɗa, oninndoo bíiŋ.» ");
INSERT INTO snf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi yii woꞌꞌúuka diimaɗa balaa iñaama laakaa, en ɗanaa binaa wa laakaa ɗú ínoh an “mi en ɓii mi enɗa.” ");
INSERT INTO snf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kayoh-kayohɗa mi woꞌꞌúuka: ɓaa fu took ɓaa mi wosɗanaa, fu tookkoo ɓan mi ga kihaffoo. Ee ɓaa fu tookkoonaa, fu took ɓaa wossooɗa ɓan. ");
INSERT INTO snf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ga waa Yéesu lëehíꞌta kiwoꞌ fodaama, keeñci leehha tak, ya woꞌꞌa faŋ an: - Kayoh-kayohɗa mi woꞌꞌúuka: yíinoo garúu hayyoo kitoon. ");
INSERT INTO snf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tëelíbéecaa ɓaa malakoh, ndaga ɓa ínohéeríi ɓaa Yéesu woꞌ nariɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yíinoo ga tëelíbéecaa, yaa Yéesu keeñukɗa, lak yaa ga yahaaci. ");
INSERT INTO snf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoŋ-Peeꞌ kalayyari kiwoꞌꞌi, ya meekisoh ɓaa Yéesu woꞌ nariɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tëelíbéenaa tobinukka ga Yéesu, meekissari an: - Haꞌmudii, ɓaama ya ɓa? ");
INSERT INTO snf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yéesu taassari an: - Mi hay kiñoon ƴaak-mbúurú ga ñamahii, ee ɓaa mi eranwaɗa, yërí ya. Yéesu dalla kiɓeɓ ƴaak-mbúuraa, ñoonndawa ga ñamahaa, eꞌta Yúdaa, kowukaa Simoŋ Iskariyot. ");
INSERT INTO snf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Daa Yúdaa ñam mbúuraa hen rek, Seytaani aassa gari. Yéesu woꞌꞌari an: - Iñum fu ƴah kitumɗa, gaawaa ga! ");
INSERT INTO snf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Wayee laakkii yíinoo ga ɓuwaa bokee nari kiñamɗa yaa ínoh iñaa tah Yéesu woꞌꞌikaɗa. ");
INSERT INTO snf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yúdaa yërí enee ɗaakoh-koparaagaɓa. Kërí tah, laakka tëelíbéecaa fooŋ an Yéesu wossi kilomnee iñaa ɓa sooluk ga hewaa, wala kisarahnee ɓuwaa laakoo daraɗa.) ");
INSERT INTO snf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yúdaa ɓeɓpa ƴaak-mbúuraa Yéesu ereeriɗa, ya dalla kimeƴ. Waama lak Kooh hoowin. ");
INSERT INTO snf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ga waa Yúdaa meƴca, Yéesu woꞌꞌa an: - Diima Kowukii ɓii laakin ndam ee ndamii Kooh laakɗa kooroh gari, ");
INSERT INTO snf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ee binaa ndamaa Kooh laakɗa kooroh garinaa, Kooh ɓan hayyi kindam na kihafci ee ya hayka kitum diima diima. ");
INSERT INTO snf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ɓiƴaay, kitessoo narúu maañissii. Ɗú hayyoo kiraas, wayee iñaa mi woꞌee yaawúuꞌcaaɗa yërí mi woꞌꞌúu diima: Dii mi aawɗa, ɗú mínoo da kikaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Diimaɗa, mi dígallúu iñii yiꞌasyii yii: waarohat ga díkaantirúu. Fodii dii mi waaꞌtúuɗa, ɗú ɓan, ɗú jom ɗa kiwaaroh ga díkaantirúu. ");
INSERT INTO snf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Binaa ɗú waarohaa, iñaama hay kiteeɓ ɓéeɓ an ɗú ɓitëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoŋ-Peeꞌ meekissa Yéesu an: - Haꞌmudii, fu ƴah gada? Yéesu taassari an: - Daa mi en na kiƴahɗa, fu mínooroo da kitaabuk diimaɗa, wayee paaf fíkíi, fu hayyoo da kitaabuk. ");
INSERT INTO snf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simoŋ-Peeꞌ woꞌꞌari an: - Haꞌmudii, iñii tah ya mi mínooraa kitaabuk diimaɗa? Mi tuukin tek ga kiꞌeroh kumuunkiigoo ndaga fu. ");
INSERT INTO snf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yéesu taassari an: - Fu tuukin ga kiꞌeroh kumuunkiigaraa ndaga mine? Kayoh-kayohɗa mi woꞌꞌaaka: bi siik-pabu kodaa, fu hayyoo kitaasuk waas kaahay. ");
INSERT INTO snf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kaa jaahliꞌat! Ɗú gëmin ga Kooh, gëmat garoo ɓan. ");
INSERT INTO snf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kaan Paammboo yewinin didëkaaꞌ. Ee iñaama laakéeríinaa, eneenaa mi woꞌoorúu an mi yii ƴahhúu kiwaayukɗinee daa ɗú enan. ");
INSERT INTO snf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ee mi kaꞌ mi waayukiꞌtúu ɗekataanaa, mi hay kihayis mi ɓeɓpúu ga yahaaroo, doonaa daa mi enaa, ɗú ɓan ɗú en da. ");
INSERT INTO snf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ɗú ínohin waasii ëewruk ga dii mi ƴahɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaa woꞌꞌari an: Haꞌmudii, ɗí ínohoo dii fu aawɗa, ɗí mínan na kiꞌínoh waasii? ");
INSERT INTO snf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yéesu taassari an: - Mi yërí en waasii, mi en kayoh, mi en kipeskii. Ken mínoo kikaꞌ ga Paamudii ee koorohhii garoo. ");
INSERT INTO snf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Enee an ɗú ínohinndoonaa, eneenaa ɗú ínohin Paammboo ɓan. Diima deŋ ɗú ínohinndi ee ɗú hotinndi. ");
INSERT INTO snf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filiip woꞌꞌa Yéesu an: - Haꞌmudii, teewaaríi Paamudii ee iñaama hayyíi kidooy. ");
INSERT INTO snf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yéesu taassari an: - Mi enin narúu yimëeñíꞌ, ee bi wati Filiip, fu ínohooroone? Ɓaa hotinndoonaa, hotin Paamudii. Kon iñii tah ya fu woꞌ an: «Teewaaríi Paamudii?» ");
INSERT INTO snf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fu gëmmbii an mi yii ga Paamudii ee Paamudii yii garoone? Woꞌeencii mi woꞌꞌúuɗa meyohhii garoo. Wayee Paamudii dëk garooɗa, yërí tum lëgëyiigari. ");
INSERT INTO snf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mi woꞌꞌúu man: mi yii ga Paamudii ee Paamudii yii garoonaa, gëmattoo. Luu enndii dara, ɗú gëm sah ndaga tumeencii ɗú hotɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kayoh-kayohɗa mi woꞌꞌúuka, ɓaa gëm garoonaa, ya ɓan hay kimín kitum iñcii mi tumiɗa, ya hay kitum sah caa wëñɗa, ndaga mi yii ƴah ga Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ee ɓéeɓ iñaa ɗú kíim ga teekiigoonaa mi hayyi kitum, en ɗanaa Kowukii teewoh ndamii Paamudii laakɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Binaa ɗú kíimmboo yen ga teekkoonaa, mi tummbi. Yéesu woꞌꞌa tëelíbéecaagari an: ");
INSERT INTO snf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","- Binaa ɗú waaꞌtoonaa, ɗú hay kitaabuk iñcii mi nakoh kitumɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ee mi, mi hay kikíim Paamudii ya onndúu ɓoꞌ yiliis yaa amɗohanndúu, yaa enan narúu bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ɓaa yaama, yërí en Helaa yiselaꞌíꞌyaa teewohi kayohɗa. Ɓu-ëldúna mínsoori kiteꞌ, ndaga ɓa mínoori kihot, ee ɓa ínohoori. Wayee ɗú, ɗú ínohinndi, ndaga ya dëk narúu ee ya yii garúu bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi foñanndiirúu fodii tubaayu, mi hay kiɓoyukis garúu. ");
INSERT INTO snf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tesin ga jutuut ɓu-ëldúna hotsisanndiiroo, wayee ɗú, ɗú hayyoo kihot, ndaga mi yii pes ee ɗú ɓan ɗú hay kipes. ");
INSERT INTO snf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Besaama leꞌ bëríinaa, ɗú hay kiꞌínoh an mi yii ga Paammboo, ɗú ínoh an ɗú ɓii garoo ee ɓan mi yii garúu. ");
INSERT INTO snf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ɓaa waarinndoo yërí en ɓaa am iñaa mi nakoh ee taabukiwaɗa. Ɓaa waaꞌtoonaa, Paammboo hayyi kiwaaꞌ, mi ɓan, mi hayyi kiwaaꞌ, ee mi teewoh haffoo gari. ");
INSERT INTO snf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yúdaa, ee bokkii na Yúdaa Iskariyot, woꞌꞌari an: - Haꞌmudii, mín na kiꞌen an fu ƴah kiteewoh haffu garíi ɗí haŋngíi, ee an fu ƴahhii kiteewukoh haffuu ga ɓu-ëldúna tóoh? ");
INSERT INTO snf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yéesu taassari an: - Binaa ɓoꞌ waaꞌtoonaa, hay kiꞌam ga keeñci iñaa mi woꞌ. Ee Paamnboo hayyi kiwaaꞌ, mi na Paammboo ɗí hay gari ee ɗí dëk ga kaanci. ");
INSERT INTO snf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɓaa waaꞌtiiroo, aboo iñaa mi woꞌ. Ee iñii ɗú keloh mi woꞌ yii meyohhii garoo wayee meyoh ga Paamudii wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mi woꞌinndúu iñuma, waa mi yii lís narúu kiꞌen. ");
INSERT INTO snf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lëehíraa, ɓaa ƴahhúu kiꞌamɗoh ee yërí en Helaa yiselaꞌíꞌyaa Paammboo ƴah kiwosoh ga teekiigooɗa hayyúu kijëgíꞌ tóoh ee ya hayyúu kiníindís tóoh iñcaa mi woꞌeerúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi yii foñiꞌtúu jam. Jamiigoo wërí mi onndúu. Mi onndiirúuwa fodii dii ɓu-ëldúna onohiwaɗa, kaa lëyat ee kaa niikat. ");
INSERT INTO snf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ɗú kelohin mi woꞌinndúu an: «Mi yii ƴah ee mi hay kiɓoyukis garúu.» Binaa ɗú waareeroonaa, ɗú neɓluk ga dii mi en na kiƴah ga Paamudiiɗa, ndaga Paamudii yërí wëñnjoo kiyak. ");
INSERT INTO snf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi woꞌinndúuka diimaɗa, balaa iñcaama laakaa. En ɗanaa ca laak bëríinaa, ɗú gëmmboo. ");
INSERT INTO snf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Saawalloo narúu hooꞌsanndii ndaga sépíꞌíꞌ-ga-nofii, yii tík yahci ga ëldúnaɗa, yii hay. En kiꞌenaa, ya mínoo dara garoo. ");
INSERT INTO snf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wayee mi tum fodii dii ya nakkoo kitumɗa. En ɗanaa, ɓu-ëldúna mín kiꞌínoh an mi keeñukin Paamudii, Kolkat, ɗu meyohat dii, ɗu ƴee! ");
INSERT INTO snf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","- Mi yërí en kedik-biiñkii kukayohkii, ee Paammboo yërí en yii líni kedik-biiñkiiɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Koykaa jok garoo, ee límmbii tóoh, ya hayka kigúꞌ. Wayee koykaa lím towaa, ya hayka kipaas bi set doonaa ka wëñ ɗa kilím. ");
INSERT INTO snf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɗú nak, ɗú sétíruunun haat ndaga iñcii mi jëgíꞌtúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Enat naroo wíinoo fodii dii mi en narúu wíinooɗa. Fodaa daa koy kedik, ka jokukkii ga kedikkaa, ka haŋka doŋ, ka mínoo kilím towuɗa, ɗú ɓan, ɗú madan fodaama binaa ɗú enndii wíinoo naroonaa. ");
INSERT INTO snf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi yërí en kedik-biiñkii, ɗú ɓërí en toytii. Ɓaa en wíinoo naroo ee mi en wíinoo nariɗa man na kedikkaa lím towu tiyewin; wayee ɗú enndii naroonaa ɗú mínoo dara kitum. ");
INSERT INTO snf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɓaa enndii naroo wíinoonaa, hay kijafu ga fooh fodii toy tiƴowuu, ta súɓ. Lëehíraa, ta nëgírohu, ta jafu ga kiwii, ta aaw kitak. ");
INSERT INTO snf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Binaa ɗú en wíinoo naroo ee woꞌeenciigoo yëgís ga ɗuuƴcúunaa, kíimat iñaa neɓpúu, ɗú hayyi kiꞌonu. ");
INSERT INTO snf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iñaa en ndam ga Paammbooɗa wërí en an ɗú man na kedikkaa lím towu tiyewin ee iñaama yërí teewohan an ɗú ɓitëelíbéeroo. ");
INSERT INTO snf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Fodaa daa Paammboo waaꞌtooɗa, mi ɓan mi waaꞌtúuɗa. Dëkat ga kiwaarohkii mi teeɓpúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Binaa ɗú am iñcii mi nakkúuɗanaa, ɗú hay kidëk ga kiwaarohkii mi teeɓpúuɗa, fodaa daa mi abee iñaa Paammboo nakeeroo ee mi yii dëkka ga kiwaarohkii ya teeɓpooɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi woꞌꞌúu iñcuma doonaa keeñ-soosii en narooɗa en garúu ee ɗú líif na keeñ-soos. ");
INSERT INTO snf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iñii yii yërí mi nakkúu: Waarohat ga díkaantirúu fodii dii mi waaꞌtúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Laakkii kiwaarohkaa yak bi leꞌ ga kiꞌonoh kumuunfu ndaga ɓifiiliifu. ");
INSERT INTO snf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɗú ɓifiiliiroo binaa ɗú tum iñii mi nakkúuɗanaa. ");
INSERT INTO snf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi ɓaysisoorúu ga teekii súrga, ndaga súrga ínohoo dara ga iñaa haꞌ-kaanci tumi. Mi ɓayyúu ga teekii fiilii, ndaga mi oninndúu kiꞌínoh ɓéeɓ iñaa mi ɓewoh ga Paammbooɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Enndii ɗú ɓërí tanndoo, wayee mi, mi tanndúu. Mi fallarúu, mi wossarúu ɗú kaꞌ ee ɗú tum fodii kedikkaa lími towu, towutaa leehoo. Kërí tahan bi ɓéeɓ iñaa ɗú kíim Paamudii ga teekiigoonaa, ya hayyúuri kiꞌon. ");
INSERT INTO snf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iñii mi nakkúuɗa yërí en kiwaaroh ga díkaantirúu. ");
INSERT INTO snf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yéesu tíkka ga an: - Binaa ɓu-ëldúna sagussúunaa, ínohat an ɓa saginndoo balaa ɗúnaa. ");
INSERT INTO snf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Enee an ɗú bok ga ëldúnanaa, eneenaa ëldúna hayyúu kiwaaꞌ ndaga ya waarin iñaa en yuuci. Wayee ɗú, ɗú bokkii ga ëldúna. Mi, mi tanukinndúu ga ɗuuƴɓa. Kërí tah ɓu-ëldúna saŋngúu. ");
INSERT INTO snf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Níindísukat iñii mi woꞌeerúuɗa: «Súrga wëñoo kilaak solu haꞌ-kaanci». En an mi, ɓa hatalinndoo ga kipesaa, ɗú ɓan, ɓa hayyúu kihatal ga kipes. En an ɓa abin iñii mi jëgírohɗanaa, ɓa hay kiꞌam iñcaa ɗú ƴahɓa kijëgíꞌɗa ɓan. ");
INSERT INTO snf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mi hay kitah, ɓa tíkkúu iñcuma tóoh ndaga ɓa ínohoo ɓii wossooɗa. ");
INSERT INTO snf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Enee an mi hayyii, enee an mi woꞌꞌii naɓanaa, eneenaa baakaaꞌ tíkkoo gaɓa. Wayee diima, baakaaꞌciigaɓa laakoo lay. ");
INSERT INTO snf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɓaa saŋngoonaa, sagin Paammboo ɓan. ");
INSERT INTO snf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Enee an mi tummbii ga ɗuuƴɓa iñaa ken mosoo kitumaa, eneenaa ɓa, baakaaꞌ tíkkoo gaɓa. Wayee diima, ɓa hotin iñcii mi tumɗa, ee ɓa saginndíi, mi na Paammboo. ");
INSERT INTO snf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wayee iñaama laakin ee fodaama iñii yii bídu ga Këyítfaa Waasaa Móyíisɗa matin: «Ɓa saginndoo ee ɓa tíkkiika ga fen.» ");
INSERT INTO snf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mi hayyúu kiwosoh ga teekii Paamudii ɓaa amɗohanndúu. Yërí en Helaa teewohi kayoh ee kúlkoh ga Paamudiiɗa. Ya hayaa, ya hay kiseediꞌ iñaa aaw garoo. ");
INSERT INTO snf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ee ɗú ɓan, ɗú hay kiꞌen seediroo ndaga ɗú enee naroo aboh ga dalaaraa. ");
INSERT INTO snf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yéesu tíkissa ga an: - Mi woꞌinndúu iñuma doonaa ɗú foñoo ngëmiigarúu. ");
INSERT INTO snf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɗú hay kikaalu ga jaanguciigaruu. Ee sah wahtu waa hay, waa ɓuwaa apanndúuɗa fooŋsan an ɓa en na kijaamuk Kooh ga iñaama. ");
INSERT INTO snf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iñaama ɓa hayyi kitum ndaga ɓa ínohoo ken garíi, enndii mi enndii Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi woꞌꞌúu iñuma diima doonaa wahtaama leꞌaa, ɗú níindísuk an mi woꞌeerarúuka. Yéesu ɓaatta ga woꞌꞌa tëelíbéecaagari an: - Iñuma mi woꞌꞌiirúuri ga wii ɗú dal narooɗa ndaga lak mi enee narúu. ");
INSERT INTO snf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Diimaɗa mi yii ƴah ga ɓaa wossooɗa ee yíinoo garúu meekissiiroo an: «fu ƴah gada?». ");
INSERT INTO snf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Keeñnjúu leehin tak ndaga iñii mi yéegallúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Moona mi woꞌꞌúu kayoh: iñaa gën garúu wërí en mi kaꞌ. En kiꞌenaa, mi kaꞌtiinaa, ɓaa ƴahhúu kiꞌamɗohɗa hayoo. Wayee binaa mi karaa nak, mi hayyúuri kiwosoh. ");
INSERT INTO snf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ee binaa ya hayaa, ya hay kiɓúl ɓu-ëldúna ga iñaa en baakaaꞌ, ga iñaa en kijúɓ na ga iñaa en kiꞌattiꞌkaa Koohɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ya hayɓa kiɓúl ga an ɓa ɓaa ga baakaaꞌ wiyaak ndaga dii ɓa gëmmbii garooɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ya hayɓa kiɓúl ga an mi ɓoꞌ yijúwíꞌ ndaga dii mi yii ƴah ga Paamudii ee ɗú hotsisanndiirooɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ya hayɓa kiɓúl ga an Kooh yërí laak kiꞌattiꞌ ndaga ga dii yii tík yah ga ëldúna attiꞌuunun kumëeñíꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mi lís kitesoh enaama ciyewin caa mi jommbúu kiwoꞌ, wayee ɗú hatinooca diima. ");
INSERT INTO snf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Binaa Helaa teewohi kayohɗa hayaa, ya hayyúu kiníiꞌ ga tóoh iñaa en kayoh. En kiꞌenaa, iñcaa ya ƴah kiwoꞌɗa meyohanndii gari, wayee ya woꞌanndúu ɓéeɓ iñcaa ya keloh ga Paamudiiɗa ee ya hayyúu kiyéegal iñcaa ƴah kilaak ga fíkíiɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ya hay kiteewoh ndamii mi laakɗa ndaga ya ɓewan ga iñaa mi laak, ya yéegallúuri. ");
INSERT INTO snf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ɓéeɓ iñaa Paamudii laak, yuuroo. Kërí tah mi woꞌꞌúu an Helaa yiselaꞌíꞌyaa ɓewan ga iñaa mi laak, ya yéegallúuri. ");
INSERT INTO snf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yéesu woꞌissa tëelíbéecaagari an: - Tesin ga jutuut ɗú hotsanndiiroo, ee tík ga jutuutaa ɗú hayyoo kihotis. ");
INSERT INTO snf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ga tëelíbéecaagari, laakka ɓaa dalu kiwoꞌ ga díkaantiɓa an: - Ya waaꞌtuu ya kiwoꞌ duma an: «Tesin ga jutuut ɗú hotsisanndiiroo ee tík ga jutuutaa ɗú hayyoo kihotis?» Ee ɓan ya woꞌin an: «Mi yii ƴah ga Paamudii.» ");
INSERT INTO snf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓa tíkissa ga an: «Jutuutaa ya woꞌ waama, wa ya? Iñii ya waaꞌ kiwoꞌɗa daal ɓoꞌ ínohoori.» ");
INSERT INTO snf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yéesu ínohha an ɓa waaꞌti kimeekis, ya woꞌꞌaɓa an: - Ɗú ɓii meekisoh ga díkaantirúu kiwaaꞌ kiꞌínoh iñii mi woꞌ an: «Tesin ga jutuut ɗú hotsanndiiroo ee tík ga jutuutaa ɗú hayyoo kihotis.» ");
INSERT INTO snf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kayoh-kayohɗa mi woꞌꞌúuka, ɗú hay kikoduk, ɗú fiipohi, wayee ɓu-ëldúna ƴah kineɓluku. Ɗú, keeñnjúu hay kileeh tak, wayee keeñ-leehaama hay kisúpítuk keeñ-soos. ");
INSERT INTO snf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɓeti en na kilaak kowaa keeñci leehi hen tak ndaga lak wahtu kiꞌen ga coonu leꞌin gari. Wayee binaa ya laak kowaa, ya dal kiꞌaluk mesiklaatcaa ndaga lak keeñci soosin ga daa ya haydohin ɓoꞌ-súusúus ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɗú ɓan, dii ɗú enaa dii watiɗa, keeñnjúu leehin tak, wayee mi hayyúu kihotis, ee bëríinaa, keeñnjúu hay kisoos seɓ. Keeñ-soosaama, ken mínanndiiwa kinaas garúu. ");
INSERT INTO snf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Besaama hay bëríinaa, ɗú meekisissooroo dara. Kayoh-kayohɗa mi woꞌꞌúuka, ɓéeɓ iñaa ɗú kíim Paamudii ga teekiigoonaa, ya hayyúuri kiꞌon. ");
INSERT INTO snf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bi diima, ɗú kíimmbii dara ga teekiigoo. Kíimat ee ɗú hay kiꞌonu, en ɗanaa ɗú líif na keeñ-soos. Lëehíꞌta Yéesu woꞌꞌa tëelíbéecaa an: ");
INSERT INTO snf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","- Iñcuma tóohca mi woꞌꞌúuca ga liiwuk. Wahtu waa hay, waa mi woꞌsanndii narúu ga liiwuk, wayee mi ƴah narúu kiwoꞌ bi leeꞌ lañ ga iñaa aaw ga Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Besaama hay bëríinaa, ɗú ƴah kikíim Paamudii ga teekiigoo. Ee mi woꞌꞌiirúu man mi ƴahhúu kikíimiꞌ Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","En kiꞌenaa, Paamudii ga kihafci waarinndúu ndaga ɗú waarinndoo ee ɗú gëmin an mi meyoh gari. ");
INSERT INTO snf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi meyoh ga Paamudii mi hayin ëldúna. Diimaɗa, mi yii meyoh ëldúna, mi ƴee ga Paamudii. ");
INSERT INTO snf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tëelíbéecaagari dallari kiwoꞌ an: - Malka, fu yii woꞌ naríi bi leeꞌ kimma, diima fu liiwukissii. ");
INSERT INTO snf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ɗí hotin kimma an soolukkii fu meekisu iñaa ɓoꞌ-súusúus halaat ga helci. En kiꞌenaa, fu ínohin iñaa en tóoh. Kërí tah ɗí gëmin an fu meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yéesu taassaɓa an: - Kon ɗú gëmin kimmane? ");
INSERT INTO snf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wahtii deeyin, ee wa weema sah, wii ɗú ƴah kitasaarukoh, yaa en ɓéeɓ ƴee ga kotci, ɗú foñnjoo haŋngoo. Wayee mi tessii haŋngoo ndaga Paamudii yii naroo. ");
INSERT INTO snf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi woꞌinndúu iñuma doonaa ɗú laak jamaa meyoh garoo. Ɗú hay kilaak coonu ciyaak ga ëldúna, wayee guuꞌguulukat ndaga mi laakin ndam ga ɗook ëldúna. ");
INSERT INTO snf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ga waa Yéesu lëehíꞌta kiwoꞌ fodaama, ya taaginukka ɗook-Kooh, ya woꞌꞌa an: - Paamudii wahtii leꞌin. Teewohaa ndamii Kowukiigaraa, en ɗanaa Kowukii ɓan teewoh ndamiigaraa. ");
INSERT INTO snf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ndaga fu oninndi dooli ga ɗook ɓuwii ɓéeɓɓa, doonaa ɓéeɓ ɓuwii fu tík ga yahciɗa ya onɓa kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kipeskaa leehoo taaꞌɗa kërí en an ɓa ínohhaa, fu yii fu doŋ fu en Koohyii yukayohyiiɗa ee ɓa ínoh Yéesu Kiristaa, yii fu wosɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi teewohin ndamiigaraa ga ëldúnaɗa, ee mi lëehɗin lëgëyaa fu ereeroo kitumɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Diimaɗa nak, Paamudii, eraaroo ndam ga yahaafu, waa mi laakee ga yahaafu lakanaa ëldúna sakussii duumɗa. Yéesu tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","- Ɓuwii fu ɓewoh ga ɓu-ëldúna, fu tíkkaɓa ga yahhooɗa, mi ínohlukohinɓa teekiigaraa. Ɓa enee ɓuufu, fu tíkkaɓa ga yahhoo, ee ɓa abin woꞌeenfu. ");
INSERT INTO snf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ɓa ínohin diima an iñaa fu oninndoo tóoh meyoh garaa. ");
INSERT INTO snf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Woꞌeencaa fu ereerooɗa, en kiꞌenaa mi erinɓaca ee ɓa teꞌinca. Wóorinɓa píŋ an mi kúlkoh garaa ee ɓa gëmin an fu yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi kíimiꞌɓa. Mi kíimiꞌtii ɓu-ëldúna, wayee mi kíimiꞌ ɓuwii fu tík ga yahhooɗa, ndaga ɓuufu. ");
INSERT INTO snf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɓéeɓ iñaa mi laak, yuufu ee ɓéeɓ iñaa fu laak, yuuroo, ee ndamii mi laakɗa hotukin gaɓa. ");
INSERT INTO snf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi bokissii ga ɓu-ëldúna, wayee ɓa, ɓa ɓii ga ëldúna, ee mi, mi yii hay garaa. Paamudii yiselaꞌíꞌyii, somaaɓa na doolum teekumgaraa, wum fu eꞌtooɗa, doonaa ɓa en wíinoo fodii dii mi naraa ɗu en wíinooɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ga waa mi en naɓa ga ëldúnaɗa, mi someeɓa na dooliigoo en ga teekiigaraaɗa, teekii fu onndooɗa. Mi níirin ɓuwii fu onndooɗa ee yíinoo gaɓa múuƴcii, enndii yaa jomee kisaŋkuꞌɗanaa. Fodaama iñaa Këyítfaa woꞌeeɗa matta. ");
INSERT INTO snf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ee diimaɗa, mi yii ɓoyuk garaa. Iñcuma mi woꞌca, waa mi yii lís kiꞌen ga ëldúna, doonaa mi líifíꞌɓa na keeñ wisóosíꞌ, wii meyoh garooɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi erinɓa woꞌeenciigaraa ee ɓu-ëldúna saguununɓa, ndaga ɓa bokkii ga ëldúna, fodii dii mi ɓan mi bokkii ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi kíimmbiiraa fu ɓewohɓa ëldúna, wayee mi kíimmbaa fu músalɓa ga Seytaani. ");
INSERT INTO snf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓa bokkii ga ëldúna fodii dii mi ɓan, mi bokkii ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sokaa kayohfiigaraa ga keeñciigaɓa doonaa ɓa eroh hafɓa garaa. Woꞌeeniigaraa wërí en kayoh. ");
INSERT INTO snf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Fodii dii fu woseeroo ga ëldúnaɗa, mi ɓan mi wosɓa fodaama. ");
INSERT INTO snf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ɓërí tah mi eroh haffoo garaa bi matin sëk, doonaa ɓa eroh hafɓa garaa ndaga kayohfii. ");
INSERT INTO snf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mi kíimiꞌtii doŋ tëelíbéeciigoo wati, wayee mi kíimɗin ɓan bi ga ɓuwaa ƴah garoo kigëm ndaga woꞌeencaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Paamudii, mi kíim doonaa ɓéeɓ en wíinoo. Ɓa enat wíinoo naruu fodii dii fu en wíinoo naroo ee mi en wíinoo naraaɗa. Ɓa enat wíinoo doonaa ɓu-ëldúna gëm an fu yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi erinɓa ndamii fu eꞌtooɗa, doonaa ɓa en wíinoo fodii dii ɗu en wíinooɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi en ga ɗuuƴɓa fodii dii fu en ga ɗuuƴcooɗa, doonaa ɓa en wíinoo seŋis, en ɗanaa ɓu-ëldúna ínoh an fu yërí wossoo ee fu waarinɓa fodii dii fu waaꞌtooɗa. ");
INSERT INTO snf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Paamudii, mi waaꞌ daa mi ƴahɗa, ɓuwii fu onndooɗa, ɓa en daama ɓan naroo, en ɗanaa ɓa hot ndamii mi laakɗa, wii fu eꞌtooɗa. Ndaga fu waarinndoo balaa ëldúna sakunaa. ");
INSERT INTO snf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Paamudii, fu yii fu júwinɗa, ɓu-ëldúna ínohsooraa, wayee mi, mi ínohinndaa. Ɓuwii ɓii nak ínohuunun an fu yërí wossoo. ");
INSERT INTO snf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi oninɓa kiꞌínohhaa ee mi hayyaa kiɓaat kiꞌínohlukoh gaɓa, en ɗanaa, kiwaaꞌkiigaraa narooɗa leꞌ bi gaɓa ee mi ga kihaffoo, mi en ga ɗuuƴɓa. ");
INSERT INTO snf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yéesu kíimmba Kooh fodaama bi ya lëehíꞌta, ya koolukka na tëelíbéecaagari, ɓa kaꞌta ɓakaa húlúwaa Sederon hanoh gaaɗa. Daama laakeera yoon-dëraa en da, ya aassa da na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yúdaa ɓan, yaa ƴahhi kitoonɗa lak ínohin ɗekataama ndaga Yéesu yewineera kikaꞌ daama, ya na tëelíbéecaagari. ");
INSERT INTO snf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yúdaa nak kaꞌta da, taam na ɓisoldaaꞌ na ɓiɓoꞌ ga ɓuwaa watuki ga Kaanfaa Koohɗa, ɓaa sarahohcaa na Fërísiyeeŋcaa ebilee ɓa taam nariɗa. Ɓa ɓayya ga yahɓa lúsee-kiwii, lampu, na kalaɓ. ");
INSERT INTO snf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lak Yéesu ínohin iñaa ƴahhi kidalɗa, ya hídohneera naɓa, meekissaɓa an: - Ɗú raas ɓa? ");
INSERT INTO snf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓa taassari an: - Ɗí raas Yéesu Nasareet! Yéesu woꞌꞌaɓa an: - Mi yërí en Yéesu! Wiima lak Yúdaa yii toon Yéesuɗa, yeema tuukka ɓan na soldaaꞌcii. ");
INSERT INTO snf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Daa Yéesu woꞌeeɓa an «Mi yërí», ɓa sooffa fenoo, keenussa kakay. ");
INSERT INTO snf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yéesu meekisissaɓa an: - Ɗú raasɓa? Ɓa taassa an: - Ɗí raas Yéesu Nasareet! ");
INSERT INTO snf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yéesu woꞌꞌaɓa an: - Mi woꞌinndúu an mi yërí. En lak ɗú raassoonaa íisat ɓuwii ɓii ɓa ƴee. ");
INSERT INTO snf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iñaama laakka ee fodaama iñaa Yéesu woꞌeeɗa matta. Ya woꞌee an: «Buba, yíinoo ga ɓuwii fu tík ga yahhooɗa saŋkuꞌꞌii.» ");
INSERT INTO snf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoŋ-Peeꞌ, lak ɓayin kalaɓ, ya ɗollafa, típpafa súrgaa haꞌ-kaadaa sarahohcaa, gúꞌta nofaa ñaabaa. Súrgaama teeksee Malkus. ");
INSERT INTO snf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yéesu dalla kiwoꞌ Peeꞌ an: - Íkaa kalaɓfiigaraa ga huuwii. Kaas-coonii Paamudii eꞌtooɗa mi jommbiiwa kiꞌan hene? ");
INSERT INTO snf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Waa ennda ɗa, soldaaꞌcaa na yaa kuliyuk gaɓaɗa na ɓuwaa yaawúuꞌcaa watuki Kaanfaa Koohɗa, abussa Yéesu, pokussari. ");
INSERT INTO snf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓa ɗeɓpari kiɓay kaan Aan. Aan yaama yërí en payam Kayíf. Kayíf nak, kíisci laakki lak yërí en haꞌ-kaadaa sarahohcaa. ");
INSERT INTO snf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayíf yaama nak, yërí onee yaawúuꞌcaa hel, woꞌꞌaɓa an iñaa gënɗa yërí en an ɓoꞌ yíinoo kaniꞌ ɓéeɓ kúlkii. ");
INSERT INTO snf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoŋ-Peeꞌ na ɓoꞌ yiliis ga tëelíbéecaa taabukussa Yéesu. Tëelíbéenaama, haꞌ-kaadaa sarahohcaa ínoheerari kërí tah ya mínnda kiꞌaas na Yéesu hëtaa kaanfaa haꞌ-kaadaa sarahohcaa. ");
INSERT INTO snf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wayee Peeꞌ tessa ga fooh ga yahaa hal-kaadaa. Waa ennda ɗa, tëelíbéenaama haꞌ-kaadaa sarahohcaa ínohinɗa, meƴca, kaꞌta ga ɓetifaa tuukee daama kiwatuk hal-kaadaaɗa, ya saawalla nari, ya ekka Peeꞌ ɗuuƴ. ");
INSERT INTO snf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Súrgaa yiɓetiyaa yaama tuukee kiwatuk hal-kaadaaɗa dalla kimeekis Peeꞌ an: - Fu ɓan, fu bokkii ga tëelíbéecii ɓii yiine? Peeꞌ taassari an: - Óꞌóo, mi bokkii ga de! ");
INSERT INTO snf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wiima lak Kooh soosin, kërí tah súrgacaa na ɓuwaa watuki Kaanfaa Kooh ensee daamaɗa fetussa kiwii, ɓaa yoonuk. Peeꞌ enee daama naɓa, yaa yoonuk ɓan. ");
INSERT INTO snf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Haꞌ-kaadaa sarahohcaa meekissa Yéesu ga loo tëelíbéecaagari na ga loo jëgírohaagari. ");
INSERT INTO snf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yéesu taassari an: - Mi woꞌee hen ga fíkíi ɓéeɓ. Besoo bes mi jëgírohee ga ɗuuƴ jaangu-yaawúuꞌcaa na ga ɗuuƴ Kaanfaa Kooh, ga daa yaawúuꞌcaa ɓéeɓ hídohohseeɗa. Mi mosoo kiɗaakuk mi woꞌ yen. ");
INSERT INTO snf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kon fu meekissoo ya ga iñaama? Meekisaa ɓuwaa súkúrukeerooɗa iñaa mi woꞌɓaɗa. Ɓa ga kihafɓa, ɓa ínohin dijófíꞌ iñaa mi, mi woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Daa Yéesu woꞌee iñaama, yíinoo ga ɓuwaa watuki Kaanfaa Kooh ee ensee daamaɗa leŋngari paꞌ, woꞌꞌari an: - Fu lofan sarahohii yiyaakyii fodumane? ");
INSERT INTO snf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yéesu taassari an: - En lak woꞌeeniigoo júɓpiinaa, woꞌaa iñaa júɓpii gaɗa. Wayee en an iñii mi woꞌɗa júwinaa fu feekohhoo ya? ");
INSERT INTO snf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Waa ennda ɗa, Aan nakohha Yéesu ɓayu, na ɓaŋcaa ga yahcaa, ga Kayíf, haꞌ-kaadaa sarahohcaa. ");
INSERT INTO snf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wiima lak Simoŋ-Peeꞌ yii lís diima, yii yoonuk, laakka ɓaa woꞌꞌi an: - Fu ɓan, fu bokkii ga tëelíbéecaa ɓaa yaamane? Wayee Peeꞌ taasukka an: - Múk, mi bokkii ga. ");
INSERT INTO snf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wiima ɓan, ga súrgacaa haꞌ-kaadaa sarahohcaa, laakka ga yíinoo ee bokoh na ɓaa Peeꞌ gúree nofaaɗa. Ya woꞌꞌa Peeꞌ an: - Mi hotéeríiraa nari ga ɗuuƴ yoon-dëraane? ");
INSERT INTO snf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peeꞌ dalla kitaasukis. Ya yaa lëehíꞌ kiwoꞌ rek, laakka siik-pabaa kon. ");
INSERT INTO snf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lëehíꞌta, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa ɓewohussa Yéesu ga Kayíf, ɓa ɓayyari kaanfaa gúwernëeꞌ ɓu-Room. Enee ga kím cuut. Ɓa ga kihafɓa, ɓa aassii ɗuuƴ kaanfaa doonaa, ga iñaa baahaagaɓa nakohɗa, ɓa líiwoo ee ɓa mín kibok ga hewaa feetaa Paakaagaɓa. ");
INSERT INTO snf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iñaama tah, Pílaat, gúwernëeraa nammba kimeƴ gaɓa ga fooh, meekissaɓa an: - Ɓii yii, iñii ɗú yabohhiɗa, ya ya? ");
INSERT INTO snf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓa taassari an: - Ya enéeríi tumoh-kofeelaa, ɗí haydohoori garaa. ");
INSERT INTO snf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pílaat woꞌꞌaɓa an: - Ɓayatti, ɗú attiꞌꞌi na kihaffúu, ga dii Waasiigarúu nakohɗa. Wayee yaawúuꞌcaa loffari an: - Ɗí onussii kiꞌattiꞌ ɓoꞌ kikaan! ");
INSERT INTO snf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iñaama laakka ee fodaama iñaa Yéesu woꞌee ga loo daa kikaankaagari ƴah kimanɗa jomee ɗa kilaak. Ya yéegalohee daa kikaankaagari ƴah kimanɗa. ");
INSERT INTO snf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Waa ennda ɗa, Pílaat ɓoyukka ɗuuƴ kaanfaa, ya ɓaylukka Yéesu. Ya meekissari an: - An fu yërí en buurii yaawúuꞌciine? ");
INSERT INTO snf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yéesu taassari an: - Iñum fu woꞌ yuma, fu yërí halaatiꞌ haffu kanoo ɓiɓoꞌ ɓiliis ɓërí woꞌꞌaaka garoo? ");
INSERT INTO snf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pílaat loffari an: - Mine, mi nam kiꞌen yaawúure? Heetiigaraa na sarahohcii ɓiyaakɓaa ɓërí kalaamiꞌꞌaa garoo. Fu, fu tum ya? ");
INSERT INTO snf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yéesu taassari an: - Nguuriigoo enndii nguuꞌ ëldúnanii wii. Binaa nguuriigoo enee nguuꞌ ëldúnanii wiinaa, eneenaa súrgaciigoo hay kiheñohu doonaa mi tíksoo ga yah ɓuwii kuliyuk ga yaawúuꞌciiɗa. Wayee óꞌóo, nguuriigoo enndii nguuꞌ dii, ga ëldúna. ");
INSERT INTO snf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pílaat dallari kimeekis an: - Kon fu iñii buuꞌ? Yéesu taassari an: - Fu yii woꞌka: mi iñii buuꞌ. Ee iñii tahhoo kilímu ee mi hayin ëldúnaɗa wërí en kiseediꞌ kayohfii. Ɓéeɓ ɓaa bokin ga kayohfii, súkúruk woꞌeenndoo. ");
INSERT INTO snf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pílaat woꞌꞌari an: - Kayoh, fa ya? Waa ennda ɗa, Pílaat meyissa ga yaawúuꞌcaa ga fooh, ya woꞌꞌaɓa an: - Mi ga kihaffoo, mi hottii ga ɓii yii enaama yíinoo yaa cal kiꞌattiꞌu kikaan. ");
INSERT INTO snf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Diima nak, waa enin baah garúu, ga hew Paakaa en ɓéeɓ mi lëgísiꞌtúu ɓoꞌ yíinoo ga kasu, ɗú waaꞌ mi lëgísiꞌtúu buurii yaawúuꞌciine? ");
INSERT INTO snf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Daama, ɓa enissa kifiip didóolíꞌ an: - Óꞌóo, hanat kiꞌen yuma, ɗí waaꞌ Barabaas! Barabaas yaama enee tumoh-kofeel yiyaak. ");
INSERT INTO snf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Waa ennda ɗa, Pílaat nakohha Yéesu ɓewu, ya ɓayu, ya rípu na ngeeꞌ. ");
INSERT INTO snf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldaaꞌcaa tíkiꞌta Yéesu ga haffa iñaa man na fodii baanu-buuꞌ ee terohu na lúp. Ɓa ekkari kúltí fiyoꞌoh cor. ");
INSERT INTO snf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓa deeƴca garinaa, ɓa këñɗiri an: - Pesa, buurii yaawúuꞌcii! Tíkka ga ɓa ɓaa feekki. ");
INSERT INTO snf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pílaat meyissa fooh, woꞌꞌa yaawúuꞌcaa an: - Súkúrukat! Mi hayyúuri kihaydohi fooh doonaa ɗú ínoh an mi hottii ga ɓii yii enaama yíinoo yaa cal kiꞌattiꞌu kikaan. ");
INSERT INTO snf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yéesu dalla kimeƴ fooh, ɓayin ga hafaa baanaa hëwrohu na lúpɗa ee ya ekukin kúltífaa fiyoꞌohfaa. Pílaat woꞌꞌaɓa an: - Ɓuum yooma! ");
INSERT INTO snf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ee daa sarahohcaa ɓiyaakɓaa na ɓuwaa watuki Kaanfaa Kooh hotee Yéesu rek, ɓa ɓaa fiip an: - Daayaari ga kuraa! Daayaari ga kuraa! Pílaat taassaɓa an: - Ɓayatti, ɗú daaƴci ga kuraa na kihaffúu, ndaga mi, mi hottii gari enaama yíinoo yaa cal ya attiꞌu kikaan. ");
INSERT INTO snf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yaawúuꞌcaa loffari an: - Ɗí, ɗí laakin waas, ee ga iñaa waasiima nakohɗa, ya jom kiꞌapu hen ndaga ya tík hafci Kowu Kooh. ");
INSERT INTO snf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Daa Pílaat kelohee woꞌeencaa caama, ya wëñnja da kitíit. ");
INSERT INTO snf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ya ɓoyukka ɗuuƴ kaanfaa, ya meekissa Yéesu an: - Fu kúlkoh gada? Wayee Yéesu taassiiri hen sah. ");
INSERT INTO snf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Waa ennda ɗa, Pílaat woꞌꞌari an: - Fu saŋ naroo kiwoꞌe? Hanaa fu ínohoo an mi míninndaa kiꞌíis fu ƴee, ee ɓan mi míninndaa kidaaƴluk ga kuraa? ");
INSERT INTO snf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yéesu taassari an: - Fu mínalooroo dara enndii an Kooh yërí onndaakanaa. Kërí tah ɓaa tíkkoo ga yahfuɗa yërí wëñnjaa kiyëkíꞌ baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ga ɗekataama, Pílaat yaa heel kiꞌíis Yéesu, wayee yaawúuꞌcaa ɓaa fiip didóolíꞌ an: - Binaa fu íis ɓii yii rekaa fu enndii fiiliimun buuꞌ Sesaaꞌ. Ɓaa tík hafci buuꞌ ɓéeɓ, lak sagohin na buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Daa Pílaat kelohee woꞌeencaama, ya meƴdohha Yéesu fooh, ya yuŋnga ga bagaa ya yugohi kiꞌattiꞌɗa, ga ɗekataa tawahu na atoh ciyaak ee woꞌsi ga kiꞌEbërëe “Gabata”. ");
INSERT INTO snf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Besaa bëríi enee besaa goonataa Paakaa yaawúuꞌcaa, ee enee ga ɓak mídí. Pílaat woꞌꞌa yaawúuꞌcaa an: - Buurumgarúu yooma! ");
INSERT INTO snf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wayee ɓaa fiip didóolíꞌ an: - Ya kaanat, ya kaanat! Daayaari ga kuraa! Pílaat woꞌꞌaɓa an: - Buuriigarúu, mi daayatti ga kuraane? Sarahohcaa ɓiyaakɓaa taasussa Pílaat an: - Ɗí laak buuꞌ yíinoo kep ee yërí en buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Waa ennda ɗa, Pílaat tíkka Yéesu ga yahɓa ɓa daaƴneeri ga kuraa . Soldaaꞌcaa abussa Yéesu ɓa ɓaa ƴah nari. ");
INSERT INTO snf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yéesu koorukka kuraanaagari na kihafci, meƴca teeraa kiƴah ɗekataa teeku Loon-haf ee wërí en ga kiꞌEbërëe Golgotaa. ");
INSERT INTO snf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Daama soldaaꞌcaa daayussa Yéesu ga kuraanaa. Ɓa daaƴca ɓan ɓoꞌ ɓanak ɓiliis ga yahaaci, yaa en ɓéeɓ ga Kuraa: yii hanohhari yah-ñaam, yíinoo hanohhari yah-seŋ. Yéesu ennda ga leꞌnaa. ");
INSERT INTO snf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pílaat bínlukka yen ga kuhaanga, ja daayussa ga ɗook kuraanaa Yéesu. Iñii yii yërí bínsee ga: «Yéesu Nasareet, buurii yaawúuꞌcii.» ");
INSERT INTO snf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iñaa bídu ga kuhaangakaaɗa, yaawúuꞌ ɓiyewin jagussawa ndaga ɗekataa waama Yéesu daayohu ga kuraaɗa enee ga yahaa teeraa, ee lak kaahay cërí bínsee ga kuhaangakaa: kiꞌEbërëe, kiLateŋ na kiGerek. ");
INSERT INTO snf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sarahoh-yaawúuꞌcaa ɓiyaakɓaa woꞌussa Pílaat an: - Kaa íis iñaa yaama bídu an «buurii yaawúuꞌcii», wayee bínsat an: «ɓii yii woꞌ an: Mi yërí en buurii yaawúuꞌcii.» ");
INSERT INTO snf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pílaat loffaɓa an: - Iñaa mi bínɗa, mi bídinndi. ");
INSERT INTO snf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ga waa soldaaꞌcaa lëehírussa kidaaƴ Yéesu ga kuraanaa, ɓa ɓeɓpa kúltícaagari warohussaca kom cinikiis, soldaaraa en ɓéeɓ ɓeɓpa kom wíinoo. Lëehíꞌta ɓa ɓeɓpa kúltífaagari fiyaakfaa ya tíki ga ɗookɗa. Fa ñëekírussii hen ee fa en píis wíinoo, aboh ɗook bi ga kakay. ");
INSERT INTO snf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɓa woꞌꞌa ga díkaantiɓa an: - Ɗu hanatfa kiɗaꞌ, ɗu yípohat tudooꞌ kiꞌínoh ɓaa laakanfaɗa. Iñaama laakka ee fodaama iñaa Këyítfaa woꞌeeɗa matta. Fa woꞌee an: «Ɓa warohha kúltícaagoo, ɓa yípohha tudooꞌ ga kúltífaagoo fiyaakfaa.» Ee iñaama deŋ yërí soldaaꞌcaa tum. ");
INSERT INTO snf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Eew Yéesu, ya na këmëeŋkíci yiɓeti na Mërí, ɓeti Kelewopaas na Mërí-Malleen, tuuksee ga yahaa kuraanaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Daa Yéesu hotee eeci, ee tëelíbéenaagari ya keeñukɗa tuukin ga yahaa yaama, ya woꞌꞌa eeci an: «Ɓetifii, kowukumgaraa kooma.» ");
INSERT INTO snf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Lëehíꞌta ya woꞌꞌa tëelíbéenaa an: «Eefu yooma». Aboh ga besaa bëríi, tëelíbéenaa yaama haydohha Mariyaama ya dëk nari ga kaanci. ");
INSERT INTO snf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Waa ennda ɗa, lak Yéesu ínohin an tóoh matin kimma, ya woꞌꞌa an: - Mi pílin. Fodaama iñaa bídu ga Këyítfaaɗa matta. ");
INSERT INTO snf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Laakeera daama kujataakaa líifin muut na biiñaa piriikin. Soldaaꞌcaa ɓewussa epoosaa ɓa ñoon ga biniigaꞌ, ɓa maaŋngawa ga dooraa meyoh ga kedikkaa woꞌu Isoop, ɓa tobinndawa ga kúuwkaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Daa Yéesu ɗuuyee ga biiñaa wipiriikiꞌwaa, ya woꞌꞌa an: - Tóoh matin. Lëehíꞌta ya feekka haf, kaannda. ");
INSERT INTO snf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wiima lak yaawúuꞌcaa ɓaa ga besaa waayukaa Sabat. Ɓa waaréeríi Sabataama laak faraafcaa ga kuraacaa. Wëñaa ga Sabataa waayuku waama yakeera lool gaɓa. Ɓa dalla kikaꞌ ga Pílaat ɓa kíimmbari, kotcaa ɓuwaa daayu ga kuraaɗa weelu ee faraafcaa yóoskíru. ");
INSERT INTO snf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Waa ennda ɗa soldaaꞌcaa hayussa ga ɓuwaa daayu na Yéesu ga kuraaɗa, ɓa weella kotcaa yaa ɓa ɗeɓ gari kileꞌɗa, ɓa paaffa ga yukanakyaa. ");
INSERT INTO snf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Daa ɓa leꞌee ga Yéesu, ɓa weellii kotcaagari, ndaga ɓa hotta an ya kaanin kumëeñíꞌ. ");
INSERT INTO snf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wayee laakka ga soldaaꞌcaa yíinoo yaa gúl hëbúusaa Yéesu na núɓ. Ga saasi ñíf na músú caa soon ga gaañaa. ");
INSERT INTO snf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɓii seediꞌ iñii yiiɗa tík hasci ga hen ee iñii ya seediꞌɗa kayoh. Ya ga kihafci, ya ínohin an iñaa ya woꞌɗa kayoh. Ya seediꞌinka doonaa ɗú ɓan, ɗú gëm. ");
INSERT INTO snf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iñaama laakka ee fodaama iñii bídu ga Këyítfaaɗa matta. Bídu ga an: «Wíinoo ga ƴohcaagari weelsanndii.» ");
INSERT INTO snf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ee laakin ɓan daa bídu diliis ga Këyítfaa an: «Ɓa hay kimalaki ga ɓaa ɓa gúlee hëbúusaagariɗa.» ");
INSERT INTO snf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Waa ennda ɗa, Yoseef yaa dëk teeraa Arímateeɗa, kíimmba Pílaat ya onndi kiɓeɓ faraaffaa Yéesu. Yoseef enee tëelíbée Yéesu, wayee ya ɗaakukeeka hen, ndaga ya niikee ɓuwaa kuliyuk ga yaawúuꞌcaaɗa. Pílaat onndari ya ɓeɓ faraaffaa. Ya dalla kihay, ya ɓeɓpa faraaffaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkodeem ɓan taammba na Yoseef. Níkodeem yaama yërí en ɓaa karee ga Yéesu ga wek kisaawalnee nariɗa. Ya ɓaydohha iñaa leꞌ kílóo cidaaŋkaah-kaahay ga cúuraay mún waa hícowu míiꞌ na alowees. ");
INSERT INTO snf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɓa ɓanak, ɓa ɓeɓpa faraaffaa Yéesu. Ɓa múullafa na lëmíi, ɓa tumdohha ga cúuraayaa wiꞌéeñíꞌwaama fodaa daa yaawúuꞌcaa tumi ɓa ƴah kiꞌac faraafɓanaa. ");
INSERT INTO snf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ga yahaa ɗekataa Yéesu daayohseeɗa, laakeera yoon-dëraa en daama. Ee ga ɗuuƴ yoon-dëraama laakeera loy wiꞌas waa yotu ga atoh, waa ken mosoo ga kiꞌeku. ");
INSERT INTO snf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wiima, waa lak yaawúuꞌcaa ensee ga besaa waayukaa Sabat, ee ɓan loyaa deeyeera daama, ɓa ekka faraaffaa Yéesu ga. ");
INSERT INTO snf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dímaasaa ga kímaa cuut, lak Kooh wíissii duum, Mërí-Malleen kaꞌta loyaa Yéesu. Ya hotta atohaa lagohsee loyaaɗa, nísuunun. ");
INSERT INTO snf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ya dalla kiꞌíisuk na jaaꞌ, yaa ƴah ga Simoŋ-Peeꞌ na tëelíbéenaa yíinoo Yéesu keeñukeeɗa. Ya woꞌꞌaɓa an: - Haꞌmudii ɓewohuunun ga loyaagari ee ɗí ínohoo ga daa ya ɓayuɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peeꞌ bëtta na tëelíbéenaa yíinooyaa, ɓaa fool kimalaknee loyaa. ");
INSERT INTO snf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓa ɓanak ɓéeɓɓa ɓaa fool, wayee tëelíbéenaa yíinooyaa wëñnja Peeꞌ kigaaw, ya ɗeɓpa Peeꞌ kileꞌ loyaa. ");
INSERT INTO snf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Daa ya hëeɓɗuk hen ya hotta lëmíicaa faanuunun ga kakay, wayee ya aassii. ");
INSERT INTO snf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoŋ-Peeꞌ yaa taabee ga fenoociɗa hannda kileꞌ. Daa Peeꞌ aas hen, hotta lëmíicaa faanuunun kakay, ");
INSERT INTO snf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na lëmíinaa baanuꞌsee ga hafaa Yéesuɗa. Lëmíinaama, lak atukohussii na cíinoocaa, wa ponsee hen, faanussa haŋ ga ɗekat wíinoo daama. ");
INSERT INTO snf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Waa ennda ɗa, tëelíbéenaa yíinoo yaa ɗewee kileꞌ loyaaɗa hannda kiꞌaas ɓan. Ya hotta, ya gëmmba. ");
INSERT INTO snf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","En kiꞌenaa, iñaa Këyítfaa yéegalohee an Yéesu jomin kimílís ga ɓuwaa kaaninɗa leeréeríi ga hafcaa tëelíbéecaa duum. ");
INSERT INTO snf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lëehíꞌta tëelíbéecaa ɓoƴkussa kaanɓa. ");
INSERT INTO snf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mërí nak tuukka ga yahaa loyaa ga fooh, ya yaa koduk. Daa ya enee na kikodukɗa, ya híilla kihëeɓɗúk loyaa, ");
INSERT INTO snf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ya hotta malaaka ɓanak ɓaa ekkuunun kúltí ciyaanaaw ɗer, yuguunun ga daa faraaffaa Yéesu faanseeɗa: yíinoo ga daa hafaa hanoheeɗa, yíinoo ga daa kotcaa hanoheeɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaakacaa meekissari an: - Ɓetifii, fu koduk ya? Ya taassaɓa an: - Ɓa ɓewin faraaffii Haꞌmudiigoo ee mi ínohoo ga daa ɓa faanndiɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Daa ya enee na kiwoꞌ iñaama, ya heelukka, ya hotta Yéesu tuukin, wayee ya ínohsohhiiri. ");
INSERT INTO snf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yéesu meekissari an: - Ɓetifii, fu koduk ya? Fu raas ɓa? Mërí fooŋnga an ɓaa watuki yoon-dëraaɗa yërí, ya woꞌꞌari an: - Kiyaakii, en lak fu yërí ɓeɓpinaa, woꞌaaroo ga daa fu faanndiɗa, mi kaꞌ, mi kooꞌneeri. ");
INSERT INTO snf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yéesu woꞌꞌari an: - Mërée! Mërí mëeñsukka, dalla kiwoꞌ ga kiꞌEbërëe an: - Rabúní! (Wërí en Jëgírohii). ");
INSERT INTO snf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yéesu woꞌꞌari an: - Kaa tëhdohhoo ndaga mi kaꞌtii ɗook ga Paamudii duum. Wayee kara, fu woꞌnee tëelíbéecaagoo an mi yii ƴah ɗook ga Paammboo, yii en Paammbúuɗa, ga Koohyiigoo, yii en Koohyiigarúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Waa ennda ɗa, Mërí-Malleen kaꞌta ga tëelíbéecaa, woꞌꞌaɓa an: - Mi hotin Haꞌmudii! Lëehíꞌta ya ɓéestíꞌtaɓa iñaa Yéesu woꞌeeriɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ga noh-soosaa dímaasaa ya mílíseeɗa, tëelíbéecaa tëcukussa ga túuyaa ɓa hídírukoheeɗa, ndaga ɓa niikee ɓuwaa kuliyuk ga yaawúuꞌcaaɗa. Daama, Yéesu hayya, tuukka ga leelooɓa, këñíꞌtaɓa an: - Jam namohat narúu! ");
INSERT INTO snf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ga waa ya woꞌꞌa fodaama, ya teeɓpaɓa yahcaagari na hëbúusaagari. Keeñaa tëelíbéecaa soossa bi ndaga daa ɓa hotin Haꞌmudiiɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yéesu woꞌissaɓa an: - Jam namohat narúu! Fodii dii Paamudii wossooɗa, mi ɓan mi wossúuɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ga waa ya woꞌꞌa fodaama, ya fúrissa ga ɗookɓa, woꞌꞌaɓa an: - Teꞌat Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓéeɓ ɓuwaa ɗú bayalan baakaaꞌcaagaɓaɗa, ɓa hay kibayalu; wayee ɓuwaa ɗú bayalanndii baakaaꞌcaagaɓaɗa, ɓa bayalsanndii. ");
INSERT INTO snf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toomaa, yaa ɓaysi Dídímɗa ee ya bok ga apotaaꞌcaa ɓidaaŋkaah na ɓanakɓaaɗa, maaséeríi ga waa Yéesu hay gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tëelíbéecaa tesɗa woꞌussari an: - Ɗí hotin Haꞌmudii. Wayee Toomaa loffaɓa an: - Enndii an mi tík kuhassoo ga mëegée-poontucaa ga yahcaagariɗa, ee mi jiip jokonndoo ga, mi ek yahhoo ga hëbúusaagarinaa, mi gëmoo. ");
INSERT INTO snf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tíkka ga bes ciyitnakaahay, tëelíbéecaa hídírukohissa ga ɗuuƴ kaanfaa ee Toomaa enee naɓa. Lak halcaa tëcuunun wayee Yéesu hayya tuukka ga leelooɓa këñíꞌtaɓa an: - Jam namohat narúu! ");
INSERT INTO snf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lëehíꞌta, ya woꞌꞌa Toomaa an: - Tíkaa jokonjiigaraa, dii, ga yahciigoo, fu malak. Ekaa yahiigaraa ga hëbúusiigoo. Íisaa kiwediꞌ, fu gëm! ");
INSERT INTO snf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaa dalla kiwoꞌ anee: - Haꞌmudiigoo ee Koohyiigoo! ");
INSERT INTO snf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yéesu woꞌꞌari an: - Dii fu hottooɗa tahhaa kigëm. Ɓa yewinin múuꞌ ɓuwii gëmin ee hotussiirooɗa! ");
INSERT INTO snf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yéesu tummba ga fíkíi tëelíbéecaagari kíntaan ciyewin ciliis, caa bídussii ga Këyítfii fii. ");
INSERT INTO snf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kíntaancii en ga Këyítfii fiiɗa nak, ca bídu ga doonaa ɗú gëm an Yéesu yërí en Kiristaanii, Kowukii Kooh; ee ɗú gëm garinaa, ɗú hay kilaak kipes ga teekci. ");
INSERT INTO snf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ga waa iñaama paaffa, Yéesu feeñukissa tëelíbéecaagari ga seereenaa giiyaa Tíbéeríyaat. Ya feeñukeeɓa fodii dii: ");
INSERT INTO snf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoŋ-Peeꞌ na Toomaa yaa ɓaysi Dídímɗa na Natanayeel yaa meyoh Kanaa ga gohaa Gëlíléeɗa na towutaa Sebedee na tëelíbée Yéesu ɓanak ɓiliis ensee daa díinoo. ");
INSERT INTO snf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoŋ-Peeꞌ woꞌꞌaɓa an: - Mi yii ƴah kimbaalnee jën. Ɓa taassari an: - Ɗí ɓan ɗí hay naraa kitaam. Ɓa kaꞌta, ɓa aassa ga gaal-loocaa, wayee wekaa bëríi, ɓa ammbii dara. ");
INSERT INTO snf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lak Kooh yaa ƴah kiwíis, Yéesu tuukka ga tewisaa giiyaa, wayee tëelíbéecaa ínohsohussiiri. ");
INSERT INTO snf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yéesu woꞌꞌaɓa an: - Ɓiƴaay, mbaa ɗú abin yen? Ɓa taassari an: - Óꞌóo! ");
INSERT INTO snf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ya woꞌꞌaɓa an: - Weesat mbaalii ga ɓakii hanoh gaal-loocii yah-ñaamɗa, ɗú hay kiꞌam jën. Waa ennda ɗa, ɓa weessa mbaalaa, mbaalaa líiffa muut na jën bi ɓa mínissiiwa kimeƴdoh músúmaa. ");
INSERT INTO snf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tëelíbéenaa Yéesu keeñukeeɗa, woꞌꞌa Peeꞌ an: - Haꞌmudii yërí! Daa Simoŋ-Peeꞌ kelohee woꞌeenaa an: «Haꞌmudii yërí», ya ekukka kúltífaagari ndaga ya tesee faan fút, ya jafukka ga músúmaa. ");
INSERT INTO snf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tëelíbéecaa ɓíinooɓaa ɓaa hay na gaal-loocaa, ɓaa nook mbaalaa líifin na jënɗa. Ɓa úsaayéeríi, ndaga díkaanti daa ɓa eneeɗa na tewisaa jom meetaꞌ citéeméeꞌ. ");
INSERT INTO snf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ga waa ɓa yoosukka ga tewisaaɗa, ɓa hotta daama kiwiikaa taaluunun, tíkuunun jën ga ɗookgaa, na mbúurú ga yahaanaa. ");
INSERT INTO snf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yéesu woꞌꞌaɓa an: - Haydohat ga jëncii ɗú han kiꞌamɗa. ");
INSERT INTO snf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Peeꞌ dalla kiꞌaas ga gaal-loocaa, kinook mbaalaa bi ga tewisaa, lak wa líifin na jën. Jëncaa enee citéeméeꞌ na cidaaŋkaah-yëtúus na kaahay, ciyaak. Ee ga daa jëncaa hín kiyewinɗa tóoh, mbaalaa ɗaꞌtii. ");
INSERT INTO snf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yéesu woꞌꞌaɓa an: - Deeyat ɗú ñëkítuk! Wayee yíinoo ga tëelíbéecaa kaañnjiiri kimeekis, «fu yërí en ɓa?» Ndaga ɓa ínoheera an Haꞌmudii yërí. ");
INSERT INTO snf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yéesu deeƴca, ɓeɓpa mbúuraa, warohhaɓawa. Ya tumissa fodaama na jënaa. ");
INSERT INTO snf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ennda kotaa wukaahaywaa, waa Yéesu feeñuk tëelíbéecaagari ga iñaa ya mílísee ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ga waa ɓa lëehíꞌta kiñëkítuk, Yéesu meekissa Simoŋ-Peeꞌ an: - Simoŋ, kowu Saŋ, fu wëñ ɓuwii ɓii kikeeñukkoone? Simoŋ taassari an: - Ee, Haꞌmudii, fu ínohin an mi waarinndaa. Yéesu woꞌꞌari an: - Níiraa tubaaltiigoo. ");
INSERT INTO snf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kotaa wukanakwaa, Yéesu meekissari an: - Simoŋ, kowu Saŋ, fu keeñukinndoone? Peeꞌ taassari an: - Ee, Haꞌmudii, fu ínohin an mi waarinndaa. Yéesu woꞌꞌari an: - Enaa níirohii baalciigoo. ");
INSERT INTO snf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kotaa wukaahaywaa Yéesu meekissari an: - Simoŋ, kowu Saŋ, fu waarinndoone? Keeñaa Peeꞌ neɓpii ga daa Yéesu meekissi bi ennda waas kaahay an «fu waarinndoone?» Ya taassari an: - Haꞌmudii, fu yii fu ínohin iñaa en ɓéeɓɗa, fu ínohin an mi waarinndaa! Yéesu woꞌꞌari an: - Níiraa baalciigoo. ");
INSERT INTO snf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kayoh-kayohɗa mi woꞌꞌaaka: ga kifiilfu, fu pokɗee haffu geñu, fu kari daa neɓpaa, wayee binaa fu guꞌgiꞌaa, fu hay kiɓëwíꞌ yahciigaraa, ɓoꞌ yiliis pokiꞌtaa geñu, ɓayyaa ga daa fu waaꞌtii kikaꞌ. ");
INSERT INTO snf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yéesu woꞌee iñaama kiteewoh daa kikaankaa Peeꞌ ƴah kiman, ee Kooh eru ndam gaɗa. Lëehíꞌta Yéesu woꞌꞌa Peeꞌ an: - Taabukaaroo! ");
INSERT INTO snf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peeꞌ heeluk hen, ya hotta tëelíbéenaa Yéesu keeñukɗa, yii hay ga fenooɓa. Tëelíbéenaama yërí tobinukee ga fasaafaa Yéesu, ga waa ɓa ñam cuuníinfaa fiselaꞌíꞌfaaɗa ee yërí meekiseeri an: «Haꞌmudii, ɓii ƴahhaa kiꞌon bíiŋɗa, ya ɓa?». ");
INSERT INTO snf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Daa Peeꞌ hotti hen, ya meekissa Yéesu an: - Haꞌmudii, haa yii fu ínoh ya gari? ");
INSERT INTO snf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yéesu taassari an: - Mi waaꞌ ya pes bi ga daa mi haysanaa, waasfu ya ga? Fu kay, taabukaaroo rek! ");
INSERT INTO snf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Woꞌeenaama síwwa ga ɗuuƴ ɓuwaa gëm ga Yéesuɗa an tëelíbéenaama kaananndii bi taaꞌ. En kiꞌenaa, Yéesu woꞌéeríi Peeꞌ an: «tëelíbéenaama kaananndii», wayee ya woꞌeeri an: «Mi waaꞌ ya pes bi ga daa mi haysanaa, waasfu ya ga?» ");
INSERT INTO snf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tëelíbéenaama yërí seediꞌ iñcuma, ya bínndaca, ee ɗí ínohin an iñii ya seediꞌɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yéesu tumin enaama ciyewin ciliis. Enee an ca ɓéestíru hen wíinoo wíinoo ga këyítaa, mi foogin an, eneenaa ɓéeɓ këyítcaa bínsan caama hawanndii sah ga ëldúna. ");
INSERT INTO snf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Fiilii Tewoofíil, ga këyítfaa mi ɗeɓ kibínɗa, mi ɓéestírin tóoh iñaa Yéesu tum, na iñaa ya jëgíroh aboh ga dalaaraa, ");
INSERT INTO snf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bi ga besaa Kooh ɓëwíꞌti, ya lappa asamaanɗa, lakanaa ga doolaa Helaa yisalaꞌíꞌyaa, ya nakin apotaaꞌcaa ya tanukɗa kitum iñcaa ɓa jom kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ga waa ya kolkoh ga coonucaagariɗa, ya hayya gaɓa na mandarga ciyewin caa teewoh an ya yaa pes: iñaa leꞌ bes cidaaŋkaah-nikiis, ya yaa teewukoh gaɓa ee ya yaa woꞌi naɓa ga loo Nguuraa Kooh. ");
INSERT INTO snf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Laakka bes, ya yuŋnga naɓa kiñam, ya dígallaɓa an: - Kaa úsaayat Yéerúsaleem, wayee sekat iñaa Paamudii dígohee ee ɗú keloheeka ga kúuwrooɗa. ");
INSERT INTO snf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","En kiꞌenaa, Saŋ bëtísiꞌee ga músú, wayee tes cijutuut ga fíkíi, ɗú hay bëtísiꞌu ga Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apotaaꞌcaa nak hídírukohussa daama, ɓa meekissa Yéesu an: - Haꞌmudii, fu ƴah kituukiris Nguurii Isarayeel diimaɗane? ");
INSERT INTO snf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yéesu taassaɓa an: - Ɗú onussii kiꞌínoh jamaanaa, wala wahtaa Paamudii ƴah kituukiꞌ Nguurii Isarayeelɗa. Paamudii abin wahtaama na kihafci. ");
INSERT INTO snf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wayee hay kilaak doolaa soruk garúu, waa meyoh ga Helaa yiselaꞌíꞌyaa ƴah kiyoosuk ga ɗookkúuɗa. Fodaama, ɗú en seediroo ga teeraa Yéerúsaleem, na ɓéeɓ gohaa Yúudée na waa Samaríi, bi ga topaaraa ëldúna. ");
INSERT INTO snf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ga waa Yéesu lëehíꞌta kiwoꞌ iñaamaɗa, ɓa ɓaa malak gari ya yaa ɓëwíru ɗook asamaan, laakka yaayeelaa hay, kúnndari ga hascaagaɓa. ");
INSERT INTO snf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lakanaa ɓa ɓaa lís kitaaginuk asamaan ga daa Yéesu en na kiƴahɗa, ɓoꞌ ɓanak ɓaa ekuk kúltí ciyaanaaw, meyussa jemeet ga yahaaɓa, ");
INSERT INTO snf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","woꞌussaɓa an: - Ɗú, ɓu-Gëlílée, ɗú tuukoh ya dii ɗú taaginuki asamaanii? Yéesu yiima, ɓëwíru aaw asamaanɗa haysisan fodii dii ɗú hotti yii ƴah asamaanɗa. ");
INSERT INTO snf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Waa ennda ɗa, apotaaꞌcaa meyohussa tëgëlaa woꞌu tëgëlaa Ólíwíyéecaaɗa, ɓa ɓoyukka teeraa Yéerúsaleem. Ee ɗekataama úsaayoh na Yéerúsaleem iñaa hín na tíidee ɓoꞌ ga bes Sabat. ");
INSERT INTO snf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ga waa ɓa leꞌꞌa Yéerúsaleem, ɓa lappa túuyaa hanoh ɗook ga taahaaɗa, daa ɓa meeree kihídírukohɗa. Ɓa enee Peeꞌ, Saŋ, Saak na Andari, Filiip na Toomaa, Bartulëmíi na Mëccëe, Saak kowukaa Alfee na Simoŋ selootaa na Yúdaa kowukaa Saak. ");
INSERT INTO snf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓéeɓɓa bokussa hel, ɓa ɓaa boki kikíim Kooh saycaa en tóoh: Mariyaama eew Yéesu, ɓiɓeti ɓiliis na këmëeŋkímuncaa Yéesu, ensee daama ɓan. ");
INSERT INTO snf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ga bescaama, ɓuwaa gëm ga Yéesuɗa hídírukohussa, ɓa leꞌeera ɓoꞌ ɓitéeméeꞌ na ɓoꞌ ɓidaaŋkaah-kanak. Peeꞌ kolukka ga leelooɓa, woꞌꞌa an: ");
INSERT INTO snf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","- Mbokcii, iñaa Helaa yiselaꞌíꞌyaa yéegalohee ga Këyítfaa Kooh, koorohhawa ga kúuw Dëwít, ga loo Yúdaa yaa kuliyukee ga ɓuwaa abee Yéesuɗa, yërí jomee kilaak. ");
INSERT INTO snf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yúdaa bokee garíi ee ya laakeera lëgëyci ga iñaa ɗí naksee kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yúdaa nak, koparaa ya faysee ga baakaaraa ya tumeeɗa, ya lommba yoon ga, ya keennda da, hafaa kuliyuk: ya pookka, liilcaa aamukka. ");
INSERT INTO snf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓéeɓ ɓu-Yéerúsaleem yéegussa iñaa laakeeɗa, bi tahha ɓa teekka yoonaama ga lakaagaɓa «Hakeldamak», wërí en «yoonaa ñífaa». ");
INSERT INTO snf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bíduunun fodaama ɓan ga Këyítfaa Kañcaa an: «Kaanfaagari tesat ɗa danɗaŋ ee ken hanat ga kidëk» Ee ɓan bíduunun an: «Ɓoꞌ yiliis línat sasaagari.» ");
INSERT INTO snf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Laakin ɓuwaa taabee naríi besaa en ɓéeɓ ga wii Yéesu, Haꞌmudii en na kipes ga leelooríiɗa, ");
INSERT INTO snf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","iñaa aboh ga waa Saŋ bëtísiꞌi bi ga besaa Kooh ɓewohhi ga leelooríi, ya lappa asamaanɗa, yíinoo ga ɓuwaama jomee naríi kitaam kiseediꞌ kimílískaa Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɓoꞌ ɓanak tanussa: Yoseef yaa teeku Barsabaas ee ɓaysi Yustusɗa, na Macaas. ");
INSERT INTO snf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lëehíꞌta ɓéeɓ ɓuwaa kíimmba Kooh anee: - Haꞌmudii, fu yii fu ínoh keeñcii ɓuwii ɓéeɓɓaɗa, teewaaríi ɓaa fu tanuk ga ɓuwii ɓanakɓii ɓii, ");
INSERT INTO snf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ya ɓeɓ sasaa Yúdaa foñ ga lëgëy kiꞌapotaaꞌkii ee ya kaꞌta ga ɗekataa en wuuciɗa. ");
INSERT INTO snf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Fodaama ɓa yípohhaɓa tudooꞌ kitan yíinoo gaɓa ee iñaa hínnda ga Macaas. Ya atukohussa ga apotaaꞌcaa ɓidaaŋkaah na yíinooyaa. ");
INSERT INTO snf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ga waa besaa Pantakot leꞌɗa, ɓéeɓ ɓuwaa gëminɗa hídírukohussa ga ɗekat wíinoo. ");
INSERT INTO snf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dalla kilaak ríiꞌ wiyaak waa meyoh asamaan en fan uuris wiyaak waa keen, wa líiffa muut ga kaanfaa ɓa enoheeɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Daama ɓa hotta iñcaa man na perem-kiwii meƴca ga fíkíiɓa, ca hëgískohha, ca warukohha ga ɗook yaa en ɓéeɓ gaɓa. ");
INSERT INTO snf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɓéeɓɓa líifussa na Helaa yiselaꞌíꞌyaa, ɓa aawwa kiwoꞌ lak ciliis fodaa daa Helaa yiselaꞌíꞌyaa onɓa kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wiima lak ga Yéerúsaleem, laakeera yaawúuꞌ ɓigëmíꞌ Kooh, ɓaa enee daama ee ɓa meyohee ga dëkcii tóoh en ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ga coowaa ɓa keloh waama, dëkaa tóoh hídírukohha, ɓuwaa jaahliꞌꞌa lool ndaga yaa en ɓéeɓ yaa keloh apotaaꞌcaa ɓaa woꞌ ga lakaagari ya ɓapɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɓa waaruꞌꞌa lool ee iñaa bettaɓa bi ɓa ɓaa woꞌ an: - Hanaa ɓéeɓ ɓuwii en na kiwoꞌ ɓii enussii ɓu-Gëlílée book? ");
INSERT INTO snf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tum na yaa en garuu ɓéeɓ kelohi iñii ɓa woꞌɗa ga lakaagari ya ɓapɗa? ");
INSERT INTO snf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ga ɗuuƴcuu dii, laakin ɓuwaa meyohu kúlkaa Partes, kaa Medes na kaa Elaamít. Laakin ɓuwaa dëk Mesopotamíi, gohaa Yúudée na waa Kapadoos, waa Pom na waa Aasíi, ");
INSERT INTO snf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","waa Fírígíi na waa Pamfílíi, waa Esípti, na waa Síreen en ga Líbíiɗa, na ɓuwii meyohu Room dëku diiɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ɓéeɓ, ennda Yaawúuꞌcii na ɓuwii aas ga Waasiigaɓaɗa, ɓu-Keret na Araapcii, ɗu ɓii kelohɓa ɓa ɓii yéegaloh tumeencii Kooh ciyaakcii ga lakciigaruu. ");
INSERT INTO snf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓa waaruꞌꞌa lool ee hafcaagaɓa kúnukka bi ɓa ɓaa woꞌ ga díkaantiɓa an: - Iñii yii ya yee? ");
INSERT INTO snf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ee ɓuwaa ɓíinoo ɓaa ñaawal ɓuwaa gëm ga Yéesuɗa an: - Ɓuwii ɓii kapuun biiñ! ");
INSERT INTO snf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Waa ennda ɗa, Peeꞌ kolukka na apotaaꞌcaa ɓidaaŋkaah na yíinooyaa, ya dalla kiwoꞌ na ɓuwaa ga ɗook an: - Ɗú, Yaawúuꞌcii, na ɓéeɓpúu ɗú ɓii ɗú dëk Yéerúsaleemɗa, foñat noffúu ga iñii mi ƴah kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","En kiꞌenaa, yooꞌ-yooꞌ doŋ wërí leꞌ, kon ɓuwii ɓii laalussii hen fodii dii ɗú fooŋkaɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wayee iñii laak yii, yërí Soweel, Sëldíiga-Koohaa yéegalohee an: ");
INSERT INTO snf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Kooh woꞌ an: Ga bescii ƴah kimëeñjohɗa, mi hay kisoꞌ Helii meyoh garooɗa ga ɗook ɓaa en ɓéeɓ; towutaagarúu tiƴaaltaa na tiɓetitaa hay kiꞌenu ɓisëldíigaroo, oomaacii hay mín kihot iñcaa leꞌꞌii duum ee guꞌgicii hay kilaak iñcaa feeñukɓa ga heeƴ. ");
INSERT INTO snf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee ga bescaama, mi hay kisoꞌ Helii meyoh garooɗa ga ɗook súrgacaagoo ɓiƴaalɓaa na ɓiɓetiɓaa, ee ɓa hay kiꞌenu ɓisëldíigaroo. ");
INSERT INTO snf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi hay kitum enaama cidóoyíꞌ waaꞌ ga ɗook ga asamaan na kíntaan dii ga kakay: hay kilaak fodii ñíf, na kiwii na iifiilaa ɗúuk pútúl en fan yaayeel. ");
INSERT INTO snf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nohii hay kiñúus tërúus ee ñiidii hay kiyoꞌoh fodii ñíf, balaa besii Haꞌmudii hayanɗa leꞌaa, besaa wiyaakwaama líif na ndamɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bëríinaa, ɓéeɓ ɓaa fu kíim ga teekii Haꞌmudiinaa, fu hay kimúc.» ");
INSERT INTO snf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peeꞌ tíkka ga an: - Ɗú, ɓu-Isarayeel, súkúrukat iñii mi ƴahhúu kiwoꞌɗa: Yéesu Nasareet enee ɓaa Kooh teeweerúu an ya taabee nari. En kiꞌenaa, Kooh tummba kíntaan na mandarga ci dóoyíꞌ-waaꞌ, caa kooroh gari ee tummbaca ga ɗuuƴcúu, fodii dii ɗú ínohkaɗa, ɗú ɓéeɓpúu. ");
INSERT INTO snf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɓaa yaama tíkussa ga yahhúu fodaa daa Kooh waareeka ee waayukeeka kumëeñíꞌɗa. Ɗú koorohha ga yah yiifaꞌcii, ɗú appari, ");
INSERT INTO snf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","wayee Kooh mílísiꞌtari, ɓëgíssari ga mesiklaatcaa ga kikaanɗa. En kiꞌenaa, kikaan mínéeríiri kiɓaŋ. ");
INSERT INTO snf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ee Dëwít woꞌee ga iñaa aaw ga Yéesu an: «Mi dëkee kihot Haꞌmudii ga fíkíiroo, ee ya yii ga yahaaroo doonaa ken mínooroo kiɓúuk. ");
INSERT INTO snf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kërí tah keeñnjoo soosin, ee ƴeekcii meyoh kúuwrooɗa teewohinka, ee ɓan faanfiigoo ga daa fa faanohsanɗa abin yaakaaꞌ ");
INSERT INTO snf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ndaga Haꞌmudii, fu foñanndii fítiigoo tes ga daa ɓuwaa kaanin enohɗa, ee fu íisanndii ɓiigaraa yiselaꞌíꞌyii nop ga ɗuuƴ loy. ");
INSERT INTO snf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fu teewinndoo waasaa ëewdoh ɓoꞌ ga kipesɗa, ee fu hay kisóosíꞌ keeñnjoo ndaga fu yii ga yahaaroo.» ");
INSERT INTO snf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peeꞌ tíkka ga an: - Mbokcii, mi míninndúu kiwoꞌ yiléeríꞌ ga loo caasammbuu Dëwít: ya kaanin, acuunun ee bi wati loyiigari wii lís kiꞌen dii. ");
INSERT INTO snf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Buuꞌ Dëwít nak enee sëldíiga-Kooh ee ya ínoheera an Kooh díginndi, waatta an hay kilaak ga níilaa tucaasamuntaagari yaa lamanndi ga Nguuraagari, en buuꞌ. ");
INSERT INTO snf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dëwít maañeera kiꞌínoh an Kiristaanii hay kimílís, kërí taheeri kiwoꞌ an: «Kooh foñnjiiri ga daa ɓuwaa kaanin enohɗa, ee faanfaagari noppii ga ɗuuƴ loy.» ");
INSERT INTO snf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yéesu, yaa mi woꞌꞌúu yaama, Kooh mílísɗinndi ga ɓuwaa kaaninɗa ee ɗí ɓéeɓpíi ɗí tíkin hassíi ga. ");
INSERT INTO snf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yéesu, Kooh ɓëwíꞌtari, yugiꞌtari ya hanohhi yah-ñaam, ya laassa ga Helaa yiselaꞌíꞌyaa Paamudii dígoheeɗa, ya yoosukiꞌta Helaa ga ɗookkíi ee iñaama yërí en iñii ɗú hotɗa na iñii ɗú kelohɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","En kiꞌenaa, Dëwít mosoo kilap ga Kooh ee ya ga kihafci woꞌin an: «Kooh, Haꞌmudii woꞌ Haꞌmudiigoo an: “Yugohaaroo yah-ñaam, ");
INSERT INTO snf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bi ga daa mi tuman ɓuwii saŋngaaɗa ditogaaꞌ kotfu.” » ");
INSERT INTO snf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peeꞌ enissaɓa an: - Ɓéeɓpúu, ɗú ɓu-Isarayeel ínohat gaka an: Yéesu yaa ɗú daayee ga kuraanaaɗa yërí Kooh tum Haꞌmudii na Kiristaanii! ");
INSERT INTO snf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Daa ɓuwaa kelohee jangataama, fítcaagaɓa gúꞌta kërít, ɓa meekissa Peeꞌ na apotaaꞌcaa ɓíinooɓaa an: - Mbokcii, ɗí jom ya kitum? ");
INSERT INTO snf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peeꞌ taassaɓa an: - Súpítat kipeskiigarúu, yaa en ɓéeɓ bëtísiꞌuk ga teekii Yéesu Kiristaa, doonaa ɗú bayalu baakaaꞌcumgarúu, en ɗanaa Kooh onndúu Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","En kiꞌenaa, iñaa Haꞌmudii, Koohyiigaruu dígoheeɗa aawee garúu na towutaagarúu na ɓéeɓ ɓuwaa úsaayin, ɓéeɓ ɓuwaa Kooh ƴah kinook ga hafciɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peeꞌ yaa nookɓa, yaa daasɓa na woꞌeen ciliis ciyewin an: - Tookat Kooh músallúu, ɗú meyoh ga ɓuwii ɓibóníꞌɓii ga jamaanii watiɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓéeɓ ɓuwaa took woꞌeencaa Peeꞌɗa, bëtísiꞌussa. Ga besaa bëríi, iñaa leꞌ ɓoꞌ ɓijúnni-kaahay ɓaatukka ga tëelíbéecaa. ");
INSERT INTO snf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓa tookka coonu ga kisúkúruk jëgírohcaa apotaaꞌcaa eroheeɗa, ɓa ennda wíinoo, ɓa boki ñamah na kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɓaa en ɓéeɓ, fítaa yabee hen ndaga iñcaa cidóoyíꞌ-waaꞌcaa apotaaꞌcaa tumeeɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓéeɓ ɓuwaa gëm ga Yéesuɗa enussa wíinoo, ɓa bokka ga iñaa en tóoh. ");
INSERT INTO snf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓa toonnda iñaa ɓa laakɗa, ɓa warohha ga díkaantiɓa, yaa en ɓéeɓ na iñaa ya soolukɗa. ");
INSERT INTO snf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɓa dëkee ga kihídírukoh ga Kaanfaa Kooh besaa en ɓéeɓ. Ɓërí bokee kiñam ga kaancaagaɓa, ee ñamsee ñamahcaa na keeñ wisóosíꞌ, ee na keeñ wiꞌéréfíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɓa kañi Kooh, ee ɓéeɓ ɓuwaa ɓíinoo waaꞌtaɓa. Ee besaa en ɓéeɓ Kooh yaa ɓaat ga lagaagaɓa ɓuwaa múcin. ");
INSERT INTO snf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Laakka bes Peeꞌ na Saŋ ɓaa ƴah Kaanfaa Kooh, kikíim Kooh; enee ga wahtu kigoonaluk, wahtaa ɓuwaa kíimi Koohɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Laakeera ɓoꞌ yaa límdohu na kilafañ, besaa en ɓéeɓ ya haydohu ga kúuw-halkaa Kaanfaa Kooh, woꞌsi “halaa wimóríꞌwaa”, ya yuŋ daama, ya sarahtuki ga ɓuwaa aasi Kaanfaa Koohɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Daa ya hotee Peeꞌ na Saŋ ɓaa ƴah kiꞌaas Kaanfaa Kooh, ya lëríssaɓa yah, ɓa sarahhi. ");
INSERT INTO snf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ɓa yíppari has, lëehíꞌta Peeꞌ woꞌꞌari an: - Malkaaríi! ");
INSERT INTO snf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lafañaa yaa malakɓa dijófíꞌ, ndaga ya foogee an ɓaama ƴahhi kisarah yen. ");
INSERT INTO snf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peeꞌ nak woꞌꞌari an: - Mi laakoo hëelís, mi laakoo wúrúus, wayee mi hayyaa kiꞌeꞌ iñii mi laakɗa: Ga teekii Yéesu KiristaaNasareet, koluka fu tíin! ");
INSERT INTO snf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Lëehíꞌta Peeꞌ ammbari ga yahaa ñaabaa ɓëwíꞌtari. Ga saasi kotcaa yëgíssa gík, puuguluƴcaa hatinndari. ");
INSERT INTO snf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ya ennda bërít tuukka, aawwa kitíin. Ya aassa na apotaaꞌcaa Kaanfaa Kooh, ya yaa tíin, ya yaa koltuk, ya yaa kañ Kooh. ");
INSERT INTO snf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓéeɓ ɓuwaa hottari ya yaa tíin, ya yaa kañ Kooh. ");
INSERT INTO snf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ga waa ɓa ínohsohha an yërí enee na kisarahtuk ga halaa Kaanfaa Kooh, ɓa waaruꞌꞌa ga lool. ");
INSERT INTO snf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɓaa lafañeeɗa tagohissii ga fenoo Peeꞌ na Saŋ. Ɓéeɓ ɓuwaa waaruꞌussa ga lool, ɓa ɓaa fool kilaakneeɓa ga ɗekataa teeku «Tíidískaaraa Salomonɗa». ");
INSERT INTO snf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Daa Peeꞌ hotee iñaama, ya woꞌꞌa mbooloomaa an: - Ɗú ɓu-Isarayeel, iñii han kilaak yii jaahallúu ga ya? Ɗú malkohhíi ya en fan dooliríi wala kiniik Kooh onndíi kitíinlukoh ɓii yii? ");
INSERT INTO snf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kooh yaa Abaraham, yaa Ísaak, yaa Yakoop, yaa caasamuncaarúu teewohin ndamaa Yéesu, súrgaagari. Ee ɗú ga kihaffúu ɗú ɓërí tooneeri, ɗú taasukkari ga fíkíi Pílaat ee lak sah yaama ɓeɓkinndi kiꞌíis. ");
INSERT INTO snf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɓaa yiselaꞌíꞌyaa ee yijúwíꞌyaa ɗú taasukkari, ɗú nammba kikíim Pílaat ya meƴdohiꞌtúu ga kasaa ɓaa lagi kumuun ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fodaama, ɗú aplukka ɓaa laak kipesɗa, wayee Kooh mílísiꞌtari ga leeloo ɓuwaa kaaninɗa ee iñaama ɗí enin seedi ga. ");
INSERT INTO snf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Doolaa teekaa Yéesu na gëmii ɗí gëm gariɗa wërí on ɓii yii ɗú hot ee ɗú ínohsohinɗa, dooli kituuk. Kigëm ga Yéesu onndi kiwak peleŋ fodii dii ɗú ɓéeɓpúu ɗú hotkaɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Diimaɗa mbokcii, mi ínohin an iñaa ɗú tum yaama, ɗú na ɓuwaa kuliyuk garúuɗa, kiꞌínohoo tah ɗú tummbi. ");
INSERT INTO snf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kooh nak mëtíꞌta fodaama iñaa ya yéegalohee kooroh ga kúuw sëldíigacaagariɗa. Ya woꞌee an Kiristaanaagari hay kikooꞌ ga coonu. ");
INSERT INTO snf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kon súpítat kipeskiigarúu, ɗú ɓoƴkidoh haffúu ga Kooh doonaa Kooh sétíꞌtúu ga baakaaꞌcumgarúu. ");
INSERT INTO snf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","En ɗanaa, Haꞌmudii hay kihaydoh jamaanu kiꞌíikaruk, ya wosoh Yéesu, Kiristaanii ɗú díŋsee kumëeñíꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wayee diimaɗa, Yéesu jom kites ga asamaan bi ga daa Kooh hëwíꞌsan tóoh en yiꞌas, fodaa ya yéegaloheeka kumëeñíꞌ koorohha ga túuwtaa sëldíigacaagari ɓiselaꞌíꞌɓaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ee Móyíis woꞌꞌeera an: «Haꞌmudii Koohyiigarúu hay kiwosoh garúu sëldíiga-Kooh, fodiigoo, yaa bok narúu heet. Iñaa ya woꞌꞌúu tóoh, leenaa súkúrukatti. ");
INSERT INTO snf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɓéeɓ ɓaa fu tookkii kisúkúruk sëldíiga-Koohaamanaa fu hay kimeƴdohu ga ɓuwaa Kooh, fu apu.» ");
INSERT INTO snf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ɓéeɓ sëldíiga-Koohcaa woꞌsee ga iñaamaɗa, aboh ga Samiyeel bi ga ɓíinooɓaa tík gariɗa, ɓa yéegalohee iñii hew yii diimaɗa. ");
INSERT INTO snf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iñaa Kooh dígohee koorohha ga sëldíigacaagariɗa enee wuurúu ee ɗú laakin ɓak ga kifiiliimunkaa Kooh pokee na caasamuncaagarúuɗa, ga waa ya woꞌ Abaraham an: «Mi hay kibarkeel heetcii ga ëldúnaɗa tóoh ee koorohan ga tucaasamuntaagaraa.» ");
INSERT INTO snf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Fodaama Kooh ɓeɓpa súrgaagari, wossari kibarkeellúu, ya foñlukoh ɓaa en ɓéeɓ tumeencaagari cibóníꞌcaa ya tumiɗa ee Kooh ɗeɓka garúu. ");
INSERT INTO snf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peeꞌ na Saŋ, lak ɓaa lís kiwoꞌ na ɓuwaa, laakka sarahohcaa hayu gaɓa taabu na ɓaa kuliyukee ga ɓuwaa watuksi Kaanfaa Koohɗa na Saduseyeeŋcaa. ");
INSERT INTO snf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Keeñɓa tamee ga daa ɓa hot Peeꞌ na Saŋ ɓaa jëgíꞌ ɓuwaa, ɓa ɓaa yéegalɓa an kimílískaa Yéesu tahin bi ɓuwaa kaanɗa hay kimílísu. ");
INSERT INTO snf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓa ammba Peeꞌ na Saŋ lagussaɓa ga kasu bi ga kooh-wíisfaa ndaga lak Kooh hoowin. ");
INSERT INTO snf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ɓoꞌ ɓiyewin ga ɓuwaa kelohsee woꞌeencaa apotaaꞌcaaɗa gëmussa. Fodaama ga ɓuwaa gëmɗa tóoh, ƴaalcaa jomeera kileꞌ ɓoꞌ ɓijúnni-yëtúus. ");
INSERT INTO snf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ga kooh-wíisfaa, ɓuwaa kuliyuk ga yaawúuꞌcaaɗa, yaakcaa, na jëgíroh-waascaa hídírukohussa ga Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aan, haꞌ-kaadaa sarahohcaa na Kayíf, Saŋ na Ëlíksaan, na ɓéeɓ ɓuwaa bok ga gíiraa haꞌ-kaadaa sarahohcaaɗa, ensee daama. ");
INSERT INTO snf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓa nakohha kihaydoh Apotaaꞌcaa ga fíkíiɓa, ɓa meekissaɓa an: - Ɗú kooroh ga doolii wiida wala ga teekii wiida bi ɗú mín wëkíꞌ ɓii yii? ");
INSERT INTO snf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ga ɗekataama Peeꞌ líiffa na Helaa yiselaꞌíꞌyaa, loffaɓa an: - Ɗú yaakcii, na ɓuwii kuliyuk ga heetciiɗa, ");
INSERT INTO snf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","waa ɗú ɓayyíi wati kitaas waas ga yijófíꞌyaa ɗí tumiꞌ lafañaaɗa na daa ɗí kooroh bi ya wakkaɗa, ");
INSERT INTO snf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kon ínohatka ɗú ɓéeɓpúu na ɓéeɓ heetii Isarayeel an ɗí kooroh ga teekaa Yéesu KiristaaNasareet, yaa ɗú apee ga waa ɗú daaƴci ga kuraanaa ee Kooh mílísiꞌtari ga ɓuwaa kaaninɗa. Yéesu yaama yërí tah bi ɓii yii wak ya tuuk dii ga fíkíirúu. ");
INSERT INTO snf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yéesu yërí en ɓaa Bíncaa ciselaꞌíꞌcaa woꞌ gari an: «Atohaa, tawohohcaa jafeeɗa -- ee woꞌu narúu -- mëeñjohin kiꞌen atoh-koñaa túuyaa.» ");
INSERT INTO snf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Enndii garinaa, kimúc laakoo ga fen diliis. En kiꞌenaa, laakoo teek wiliis ga ëldúna waa Kooh eꞌ ɓoꞌ-súusúus ee wa mín ɓuwii kimúsal. ");
INSERT INTO snf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɓuwaa attiꞌi ga paanaa wiyaakwaaɗa, waaruꞌussa ga daa Peeꞌ na Saŋ kaañu woꞌeencaagaɓaɗa, ee iñaama bettaɓa ndaga ɓa ínohin an Peeꞌ na saŋ jagussii. Ɓa hotta an ɓa bok ga ɓuwaa taabee na Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wayee daa ɓa hotee ɓan ɓaa wëkɗuseeɗa tuukin ga yahaa Peeꞌ na Saŋ, ɓa laakissii iñaa ɓa woꞌan. ");
INSERT INTO snf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Waa ennda ɗa, ɓa ebilla apotaaꞌcaa kimeƴ paanaa attiꞌohsiɗa paaƴ, ɓa awwa kihotoh ga díkaantiɓa. ");
INSERT INTO snf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ɓa ɓaa woꞌan: - Ɓuwii ɓii ɗu tumanɓa na? En kiꞌenaa, wóorin an ɓuwii ɓii tumuunun kíntaan wiléeríꞌ. Ɓéeɓ ɓu-Yéerúsaleem yéeguununka ee ɗu mínooka kisaŋ. ");
INSERT INTO snf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ɗu hëwëlatɓa, ɗu hoonohɓa kiwoꞌ na ɓoꞌ ga loo teekii Yéesu, en ɗanaa, iñuma wëñoo ɗa kisíw ga ɗuuƴ ɓuwum. ");
INSERT INTO snf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Waa ennda ɗa, ɓa ɓaylukka Peeꞌ na Saŋ, ɓa kokohhaɓa ɓa íis yas kiwoꞌ loo Yéesu wala kijëgíroh ga teekaagari. ");
INSERT INTO snf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wayee Peeꞌ na Saŋ loffaɓa an: - Woꞌat rek! Iñii yiida wëñ kijúɓ ga fíkíi Kooh? Kikeloh woꞌeenndúunoo, kikeloh woꞌeenci? ");
INSERT INTO snf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wayee ɗí ga kihaffíi nak, ɗí mínoo kiꞌíis kiyéegaloh iñaa ɗí hot na iñaa ɗí kelohɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Attiꞌohcaa ɓiyaakɓaa hëwëlussaɓa, ɓa íissaɓa ndaga ɓa laakéeríi daa ɓa kooran bi ɓa sodalɓa ee lak ɓuwaa ɓéeɓɓa ɓaa kañ Kooh ga iñaa laakee yaama. ");
INSERT INTO snf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɓaa Peeꞌ na Saŋ wëkɗee na kíntaanɗa wëñɗeera tíkíis tidaaŋkaah-nikiis. ");
INSERT INTO snf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ga waa Peeꞌ na Saŋ íisuɗa, ɓa ɓaa ƴah ga ɓuwaa ɓa taabi naɓaɗa, ɓa ɓéestíꞌtaɓa tóoh iñcaa sarahohcaa ɓiyaakɓaa na yaakcaa woꞌeeɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ga waa ɓuwaa súkúrukussa iñaa ɓéestíru yaama, ɓa bokka ɓéeɓɓa kikíim Kooh anee: - Cic Kooh, fu yërí sak asamaanii, na kakayfii, na giiyii na tóoh iñcii en gaɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fu yërí kooroh ga tumeencaa Helaa yiselaꞌíꞌyaa fu tummba woꞌeencii cii ga kúuwkaa caasammbíi Dëwít, súrgafu an: «Iñii tah ya coow koluk ga ɗuuƴ heetcii? Iñii tahɓa kipokoh nof ya ga iñcaa mínoo kilaak? ");
INSERT INTO snf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Buuꞌcii ga ëldúnaɗa na ɓuwii kuliyuk ga heetcii ga ëldúnaɗa ɓeɓkuunun ee ɓa enin wíinoo kiheñoh Kooh, Haꞌmudii na buuraa ya falɗa.» ");
INSERT INTO snf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","En kiꞌenaa, wëerin an Eroot na Poos-Pílaat na ɓu-Isarayeel na heet ciliis hídírukohuunun ga teerii wii kiheñoh Yéesu súrgiigaraa yiselaꞌíꞌyii fu fal buuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Fodaama ɓa mëtíꞌsiꞌꞌa tóoh iñaa fu natee kitum kumëeñíꞌ ee ga dooliigaraa fu onndawa kimín kiꞌen. ");
INSERT INTO snf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ee diimaɗa Haꞌmudii malkaa ga dii ɓa sooŋngíiɗa; onaaríi, ɗí súrgaciigaraa kiyéegaloh Woꞌeeniigaraa na fít wiyëgísíꞌ gík. ");
INSERT INTO snf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lërísaa yahiigaraa doonaa ɓiɓoꞌ wëkɗu, ee kíntaan na enaama cidóoyíꞌ-waaꞌ laak ga teekii Yéesu, súrgiigaraa yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɓuwaa ɓaa lëehíꞌ kikíim Kooh, ɗekataa ɓa eneeɗa waa yëngëluk, ɓa líiffa ɓéeɓɓa na Helaa yiselaꞌíꞌyaa, ee ɓa ɓaa yéegaloh Woꞌeenaa Kooh na fít wiyëgísíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɓéeɓ ɓuwaa gëmɗa bokussa keeñ wíinoo na hel. Yíinoo gaɓa woꞌéeríi an iñaa ya laakɗa ya eemdohwa ga hafci rek, wayee ɓéeɓ iñaa ɓa laakɗa, ɓa atukoheeri hen, en wíinoo. ");
INSERT INTO snf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apotaaꞌcaa ɓaa seediꞌ ga daa ɓa wëñ kimín kimílískaa Yéesu, Haꞌmudii ee Kooh taammba naɓa ga tóoh. ");
INSERT INTO snf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ken ñakéeríi dara gaɓa. Ɓéeɓ ɓuwaa laakee yoon wala kaanɗa, toonussaca, ɓa haydohha cadamfaa, ");
INSERT INTO snf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɓa eꞌtafa apotaaꞌcaa, lëehíraa koparaa warohu ɓuwaa, yaa en ɓéeɓ na iñaa ya soolukɗa. ");
INSERT INTO snf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Laakeera ɓan ɓaa teeku Yoseef, ya iñaa Léwít ee límohu Sipaꞌ. Ɓaa yaama apotaaꞌcaa teekeeri Barnabaas, wërí en «ɓii daasi ɓuwiiɗa». Ɓaa yaama laakeera yoon, ");
INSERT INTO snf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ya toonnda yoonci haydohha cadamfaa, ya tíkkafa ga yah apotaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Laakka nak ɓaa teeku Anañaas, ee ɓetici teeku Safíraa. Ya toonnda ga kakayfaagaɓa. ");
INSERT INTO snf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ya pokohha nof ɓan na ɓetici, ya tëhdohha ɓan ga koparaa yoonaa toonohuɗa, lëehíꞌta ya eꞌneera apotaaꞌcaa iñaa tesɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Waa ennda ɗa, Peeꞌ woꞌꞌari an: - Anañaas, iñii tah ya Seytaani teꞌ keeñfu, fu kaakin Helii yiselaꞌíꞌyii saboh ee fu tëhdohin ga koparaa fu toonoh yoonaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yoonaa tesee danaa, wa tesiꞌtiiraa dane? Waa fu toonndawa, koparaa enndii wuufune? Kon iñii fu waaꞌ kitum yii fu mínndi na kihalaat ga helfu? Fu kaakkii ɓoꞌ-súusúus saboh wayee Kooh yërí fu kaak saboh. ");
INSERT INTO snf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Daa Anañaas kelohee woꞌꞌeencaama, ya kennda kakay, ya dalla kikaan. Ɓéeɓ ɓuwaa yéeŋsee iñaamaɗa, tíitussa lool. ");
INSERT INTO snf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Oomaa-ƴaalcaa kolkussa, múulussa faraaffaa, ɓayussafa kiꞌacnee. ");
INSERT INTO snf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tíkka ga iñaa leꞌ wahtu kaahay, ɓeti Anañaas aassa, lak ya yéeŋngii dara ga iñaa laakɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peeꞌ meekissari an: - Woꞌaaroo, cadamfii yoonii ɗú tooneeɗa tóoh fërí fiine? Ɓetifaa taassari an: - Ee, enee cadamfuma. ");
INSERT INTO snf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peeꞌ woꞌꞌari an: - Ɗú mín na kipokoh nof kiheel kiɗúk Helii Haꞌmudii? Súkúruka! Ɓuwum kaꞌsee kiꞌac ƴaalfuɗa ɓooma ga halii, ee ɓa hayyaa kiɓay, fu ɓan. ");
INSERT INTO snf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ga saasi ɓetifaa keennda kakay ga kotcaa Peeꞌ, fa kaannda. Daa oomaa-ƴaalcaa aasee, ɓa laakki kaanin. Ɓa ɓayyari, acsuneerari ga yahaa ƴaalci. ");
INSERT INTO snf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ɓéeɓ ɓuwaa gëm ga Yéesuɗa, na ɓéeɓ ɓuwaa yéegee iñcaa laak caamaɗa, tíitussa lool. ");
INSERT INTO snf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apotaaꞌcaa ɓaa tum ga leeloo ɓuwaa kíntaan ciyewin na enaama cidóoyíꞌ waaꞌ. Ɓuwaa gëm ga Yéesuɗa meeꞌseera kihídírukoh ga ɗekataa teeku «Tíidískaaraa Salomonɗa». ");
INSERT INTO snf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ken ga ɓuwaa ɓíinoo tesɗa kaañéeríi kikaꞌ gaɓa, ee nak ɓéeɓ ɓuwaa woꞌee gaɓa yijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yewinnda lool ɓiƴaal na ɓiɓeti ɓaa gëm ga Haꞌmudii, ɓa ɓaatukka ga ɓuwaa gëminɗa, fodaama mbooloomaa waa wëñ kiyak. ");
INSERT INTO snf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kaꞌta bi ɗúukoolíꞌcaa ɓaa meƴdohu ga mbedicaa, ɓii faanu ga gatan wala basaŋ doonaa Peeꞌ kooroh danaa heƴna sóogúufaagari mín kiꞌúul yíinoo gaɓa, ennda ga yii wala ga yay, ɓa wak. ");
INSERT INTO snf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɓiɓoꞌ ɓiyewin ɓaa meyoh ga dëkcaa wíil Yéerúsaleemɗa, ɓaa haydoh ɓiɗúukooliꞌ na ɓuwaa raɓ am ee ɓéeɓɓa ɓaa wëkɗu. ");
INSERT INTO snf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Waa ennda ɗa, haꞌ-kaadaa sarahohcaa na ɓéeɓ ɓuwaa taam nariɗa, ennda ɓuwaa bok ga Saduseyeeŋcaa, iñaadohussa apotaaꞌcaa, ɓa kolukiꞌtaɓa. ");
INSERT INTO snf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓa amlukka apotaaꞌcaa, ɓa laŋlukkaɓa ga kasaa ɓéeɓ tëcohsiɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wayee ga wekaa, laakka malaakaa Haꞌmudii hay, lëgíssa halcaa kasaa, meƴdohhaɓa, woꞌꞌaɓa an: ");
INSERT INTO snf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","- Karat Kaanfaa Kooh, daama ɗú jangat ɓuwaa ɓéeɓ iñaa aaw ga loo kipeskii kiꞌaskiiɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apotaaꞌcaa tumussa fodaa daa ya nakohɗa. Kooh yaa wíis ga kímaa teel, ɓa aassa Kaanfaa Kooh, ɓa aawwa kijëgíroh. Haꞌ-kaadaa yaawúuꞌcaa hayya, ya na ɓuwaa taam nariɗa, ɓa ɓëytohha ɓéeɓ paanaa wiyaakwaa, waa ɓéeɓ ɓuwaa kuliyuk ga heetii ɓu-Isarayeel hídohiɗa, lëehíꞌta ɓa wosohha kikooꞌnee apotaaꞌcaa ga kasaa. ");
INSERT INTO snf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Soldaaꞌcaa karussa, wayee daa ɓa leꞌee kasaa, ɓa hottii apotaaꞌcaa ga túuƴcaa ɓa lagohseeɗa, ɓa ɓoyukka ɓa ɓéestíꞌtaɓa an: ");
INSERT INTO snf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","- Ɗí laak kasaa laguunun bi jofin, soldaaꞌcaa tuukuunun ga halcaa, wayee daa ɗí aasee, ɗí lëgíssa daa ɓa lagohseeɗa, ɗí hottii ɓoꞌ da. ");
INSERT INTO snf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yaa kuliyuk ga soldaaꞌcaa ga Kaanfaa Koohɗa na sarahohcaa ɓiyaakɓaa, daa ɓa kelohee woꞌeencaa caama, ɓa jaahliꞌꞌa lool ɓa ɓaa meekiskoh iñaa mín kidal apotaaꞌcaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Waa ennda ɗa, laakka ɓaa hay woꞌꞌaɓa an: - Ɓuwaa ɗú lagee ga kasaaɗa, man ɓaa ga ɗuuƴ Kaanfaa Kooh, ɓaa jëgíꞌ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ɓaa kuliyuk soldaaꞌcaa ga Kaanfaa Koohɗa taammba na ɓuwaagari, ɓa kooꞌneera apotaaꞌcaa ee kinookoh laakkii ga ndaga ɓa niikee ɓuwaa tapisohɓa na atoh. ");
INSERT INTO snf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ga waa ɓa haydohhaɓa, ɓa yugiꞌtaɓa ga fíkíi attiꞌohcaa ɓiyaakɓaaɗa haꞌ-kaadaa sarahohcaa meekissaɓa an: ");
INSERT INTO snf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","- Ɗí hoonohéeríirúu kijëgíroh ga teekaa ɓaa yaamane? Ee malkat, Yéerúsaleem tóoh gomin na iñcum ɗú jëgírohiɗa, ee ɗú waaꞌtíi kikooꞌ daal kikaankaa ɓaa yaama! ");
INSERT INTO snf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peeꞌ na apotaaꞌcaa tesɗa loffaɓa an: - Kooh yërí jom kitaabuku wayee enndii ɓoꞌ-súusúus. ");
INSERT INTO snf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yéesu yaa ɗú apee ga waa ɗú daaƴci ga kuraanaaɗa, Koohyii ɓicaasammbíi mílísiꞌtari. ");
INSERT INTO snf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ee yërí Kooh ɓëwíꞌ, yugiꞌtari hanohha yah-ñaabaagari, ya fallari ya en buuꞌ na Músalkaat doonaa ya on heetii ɓu-Isarayeel kimín kisúpít kipeskaagaɓa en ɗanaa ɓa bayalu baakaaꞌcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɗí ɓërí en seedi ga iñcaa laakee caama, ɗí na Helii yiselaꞌíꞌyii Kooh on ɓuwaa taabukiriɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Daa ɓu-paanaa kelohee woꞌeencaama, ɓa aylukussa bi ɓaa saak, ɓa waaꞌta kiꞌap apotaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wayee laakka Fërísiyeegaa teeku Gamaliyeel, ya enee jëgíroh-waas ee ɓéeɓ oneerari céeꞌ. Ya kolukka, ya tuukka ga leeloo paanaa, ya nakohha apotaaꞌcaa meƴdohu fooh paaƴ. ");
INSERT INTO snf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Lëehíꞌta, ya woꞌꞌa an: - Ɗú ɓu-Isarayeel, watukat iñii ɗú ƴah kitum ɓuwii ɓiiɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɗú níindísukaa ga iñaa maañnjii dara, laakeera ɓaa woꞌu Tëdaas; enee dii. Ya tíkee hafci ɓoꞌ yiyaak ee iñaa leꞌ ɓoꞌ ɓitéeméeꞌ-nikiis taabukkari. Waayee daa ya apsee, ɓéeɓ ɓuwaa taabukeeriɗa tasaarukohussa, gaama eemmba daama. ");
INSERT INTO snf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ga fenooci, ga wahtaa ɓuwii kínsee kiꞌínoh daa ɓa hídeeɗa, ɗú hotissa dii Yúdaa yaa dëkee Gëlíléeɗa. Ya nookka ɓoꞌ ɓiyewin ga fenooci. Wayee daa ya apsee, ɓéeɓ ɓuwaa taabukeeriɗa tasaarukohussa. ");
INSERT INTO snf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Diima deŋ mi woꞌꞌúu an: waassúu hanat ga ɓuwii ɓii kiꞌen. En lakanaa iñcii ɓa jëgírohɗa wala iñcii ɓa enukohɗa meyoh ga ɓoꞌ-súusúusaa, ɓa hay kitasoh. ");
INSERT INTO snf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wayee en lak ca meyoh ga Koohaa, ɗú mínooca kihoonoh kituuk. Kon kaa ekat haffúu ga kiheñoh Kooh. Ɓu-paanaa tookussa iñaa Gamaliyeel woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɓa ɓayya apotaaꞌcaa, ɓa ríplukkaɓa, lëehíꞌta ɓa hoonohhaɓa kiwoꞌ ga teekaa Yéesu, lëehíꞌta ɓa íissaɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apotaaꞌcaa meyohussa daa attiꞌohsiɗa, ɓaa ƴah na keeñ wisóosíꞌ ndaga daa Kooh attiꞌin an ɓa matin kitóróhɗu ndaga teekaa Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ee besaa en ɓéeɓ ɓa ɓaa kaꞌ Kaanfaa Kooh na ɗuuƴ kaancaa, ɓa ɓaa lís kijëgíroh na kiyéegaloh Hewhewii winéwíꞌwii woꞌ ga loo Yéesu, yii en Kiristaaniiɗa. ");
INSERT INTO snf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Waama lak tëelíbéecaa Yéesuɗa ɓaa wëñ kiɓaatuk. Yaawúuꞌcaa laksi kiGerekɗa ɓaa ñaꞌsukoh loo iñaa yaawúuꞌcaa laksi kiꞌEbërëe tumiɗa. Ɓa ñaꞌsukohee an ɓeticaa bok gaɓaɗa, ee ƴaalɓa kaaninɗa, daanee kiꞌaluku hen ga dúndaa warohsi besaa en ɓéeɓɗa. ");
INSERT INTO snf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Apotaaꞌcaa ɓidaaŋkaah na ɓanakɓaa hídírohussa ɓéeɓ tëelíbéecaa, ɓa woꞌꞌaɓa an: - Ɗí íis kiyéegaloh woꞌeenii Kooh, ɗí am ga kiwaroh ñamah enndii iñaa gën. ");
INSERT INTO snf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kërí tah, Mbokcii, namat kitan ga ɗuuƴcúu ƴaal ɓiyitnaɓanak, ɓaa ínohohu ga kijúɓ, ɓaa líifin na Helii yiselaꞌíꞌyii ee laakuunun hel, ɗí sasɓa kitum lëgëyaama. ");
INSERT INTO snf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","En ɗanaa ɗí ga kihaffíi, ɗí ëewruk ga kikíim Kooh na kiyéegaloh woꞌeeniigari. ");
INSERT INTO snf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɓéeɓ ɓuwaa gëmɗa tookussa iñaa woꞌu yaama. Waa ennda ɗa, ɓa tannda Iceen, ɓoꞌ yigëmíꞌ Kooh ee líifin na Helii yiselaꞌíꞌyii, Filiip, Porokooꞌ, Níkanooꞌ, Tímoŋ, Parminaas, na Níkulaa yaa límohu Añcoosɗa ee enee yiifaꞌ kuɗewaa, ya aassa ga waasaa yaawúuꞌcaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lëehíꞌta, ɓa haydohhaɓa ga apotaaꞌcaa. Ɓaama tíkussaɓa yah ga haf, kíimɗussaɓa Kooh. ");
INSERT INTO snf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Woꞌeenaa Kooh waa wëñ kisíw, ee ga Yéerúsaleem, tëelíbéecaa ɓaa wëñ kiɓaatuk, ee sarahoh ɓiyewin gëmussa ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kooh barkeella Iceen, líifíꞌtari na dooli, ya yaa tum enaama cidóoyíꞌ-waaꞌ na kíntaan ciyaak ga ɗuuƴ ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Laakka ɓiɓoꞌ ɓaa júwohéeríi na Iceen ee ɓa bokee ga jaangu-yaawúuraa “ñaamcaa laak hafɓaɗa”, ɓa enee ɓiyaawúuꞌ, ee ɓa meyohee Síreen, Aleksandarí, Sílísíi na Aasíi. Ɓa ɓaa tëesɗoh woꞌeen na Iceen. ");
INSERT INTO snf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wayee, ɓa mínéeríi yen ga woꞌeencaagari ndaga ya woꞌohee kiñaañkaa Helaa yiselaꞌíꞌyaa oneeriɗa. ");
INSERT INTO snf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ɓa neehalla ɓiɓoꞌ doonaa ɓaama woꞌ an: - Ɗí kelohin ya woꞌin woꞌeen cisépíꞌíꞌ ga Móyíis na ga Kooh. ");
INSERT INTO snf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Fodaama ɓa tahha bi yaakcaa dëkaa, jëgíroh-waascaa na ɓu-dëkaa, kolukussa ɓa keennda ga ɗook Iceen, ɓa ammbari, ɓayussari paanaa wiyaakwaa. ");
INSERT INTO snf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓa ɓaydohha ɓan seedicaa ƴah Iceen kipokiꞌ kiwoꞌ, woꞌussa an: - Kaanfii Kooh fiselaꞌíꞌfii na Waasii Móyíis, ɓii yii dëk kiwoꞌ woꞌeen cisépíꞌíꞌ gaca. ");
INSERT INTO snf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ɗí kelohinndi yaa woꞌ an Yéesu Nasareet hay kiɓúꞌ Kaanfii Kooh, ya súpít baahcii Móyíis foñiꞌtuuɗa. ");
INSERT INTO snf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɓéeɓ ɓuwaa enee ga paanaa wiyaakwaaɗa yípussa Iceen has, ɓa hotta fíkíifaagari faa melic en fan fíkíi malaaka. ");
INSERT INTO snf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wa ennda ɗa, haꞌ-kaadaa sarahohcaa meekissa Iceen an: - Iñcii fu woꞌɗuɗa kayohe? ");
INSERT INTO snf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Iceen taassa an: - Ɗú, mbokciigoo, súkúꞌkattoo. Koohyii laak ndamɗa feeñukka caasammbuu Abaraham ga kúlkaa Mesopotamíi lak ya kaꞌtii kidëknee teeraa Haran duum. ");
INSERT INTO snf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kooh woꞌꞌari an: «Meyohaa kúlkiigaraa, fu foñ ɓuunfu, fu kaꞌ kúlkaa mi teewanndaaɗa.» ");
INSERT INTO snf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Waa ennda ɗa, Abaraham meyohha kúlkaa ɓu-Kaldee, ya kaꞌta dëkneera teeraa Haran. Ya ennda daama bi ga daa paamci kaanoh. Kooh ɓewohhari daama, paafdohhari dii ga kúlkii ɗú dëkoh watiɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kooh onndiiri kilaak kakay fíinoo dii, enndii sah iñaa hín na pataŋ-kot, wayee ya díŋngari kilaak kúlkii, ɓu-níilaagari lamuka gari. Wiima nak lak Abaraham laakkii sah kowu. ");
INSERT INTO snf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iñii yii yërí Kooh woꞌeeri: «ɓu-níilaagaraa hay kidëku ga kúlkaa enndii kuuɓa ee daama ɓa hay kiꞌabu ñaam, ɓa sodalu iñaa leꞌ tíkíis titéeméeꞌ-nikiis.» ");
INSERT INTO snf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kooh nak tíkka ga an: «Heetaa ƴahɓa kiꞌam ñaamɗa, mi Kooh, mi haywa kiꞌatti. Lëehíraa ɓa hay kikúlkoh daama, ee ɓa ƴahhoo kijaamukoh dii ga ɗekatii wii.» ");
INSERT INTO snf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wa ennda ɗa, Kooh pokohha kifiiliimun na Abaraham ee kigúruk kërí en mandargaa kifiiliimunkaa kaama. Fodaama, ga waa kowuci Ísaak límuɗa, Abaraham gúꞌtari ga besaa wu-yitnakaahaywaa tík gaɗa. Ísaak tummba fodaama, ya gúꞌta kowuci Yakoop, Yakoop ɓan gúꞌta ɓicaasammbuu, towutaagari tidaaŋkaah na tanaktaa kuliyuk ga heetii Isarayeelɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Caasamuncaagaruu ɓaama iñaadohussa këmëeŋkíɓa Yoseef, ɓa toonndari ya ɓayu kúlkaa Esípti kiꞌen ñaam. Wayee Kooh taabee nari, ");
INSERT INTO snf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ya músallari ga coonucaagari. Kooh onndari kineɓloh Farawoŋ, buuraa Esípti, ya onndari ɓan kilaak hamham ga fíkíici. Yaama fallari kiꞌen gúwernëeraa kúlkaa Esípti na kituukuk kaanci ɓéeɓfa. ");
INSERT INTO snf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wa ennda ɗa, aꞌ wiyaak laakka ga ɓéeɓ kúlkaa Esípti na kaa Kanaa. Araa mesikka lool bi ɓicaasammbuu laakissii iñaa ɓa ñaman. ");
INSERT INTO snf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ga waa Yakoop keloh an beli laakin ga kúlkaa Esíptiɗa, ya wossa ɓicaasammbuu daama bes. ");
INSERT INTO snf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kotaa kukanakkaa ɓa kaꞌ daɗa, Yoseef tummba bi yaakmuncaagari ínohsohussari. Fodaama Farawoŋ ínohha ɓuwaa en mbokcaa Yoseefɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lëehíꞌta, Yoseef wosohha kikooꞌnee mbokcaagari ɓéeɓɓa na paamci Yakoop: ennda ɓoꞌ ɓidaaŋkaah-yitnaɓanak na ɓiyëtúus. ");
INSERT INTO snf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakoop nak toolukka kúlkaa Esípti, ya dëkka daama bi ga daa ya kaanohɗa. Ɓicaasammbuu ɓan kaanohu daama. ");
INSERT INTO snf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Faraafcaagaɓa ɓayussa Síkeem, acussa ga loyaa Abaraham lomee na kopaꞌci ga towutaa Emooꞌ ga Síkeemɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ga waa jamaanaa Kooh jomee kimëtíꞌ dígaa ya waatee díŋnga Abarahamɗa deeƴca, heetiigari ɓaatukka, waa wëñ kilaw ga kúlkaa Esípti, ");
INSERT INTO snf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","bi ga daa buuꞌ yiliis falukohɗa. Buuraama nak ínohéeríi Yoseef. ");
INSERT INTO snf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Buuraama ɗúkka heetiigaruu, ya sodalla ɓicaasammbuu, ya gítínndaɓa kijaf towutaagaɓa doonaa ta pesoo. ");
INSERT INTO snf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Móyíis límu ga jamaanaama, ja ennda kuꞌoomaakaa neɓlohin Kooh. Ja ɓayussa ga kaan paamci na eeci ñiin kaahay. ");
INSERT INTO snf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ga waa ja jafuɗa, kowukaa Farawoŋ kiɓetikaa balaɓpaja, ya koꞌtaja fodii kowuci. ");
INSERT INTO snf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Fodaama Móyíis korussa ga hamhamaa ɓu-Esípti, ee ya ennda ɓoꞌ yilëekíꞌ-solu ndaga woꞌeencaagari na tumeencaagari. ");
INSERT INTO snf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ga waa Móyíis laak tíkíis tidaaŋkaah-nikiisɗa, helci kaꞌta ga kiwaaknee ɓu-Isarayeel, mbokcaagari. ");
INSERT INTO snf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ya hotta daama ɓoꞌ ga ɓu-Esípti yaa en na kisodal ɓoꞌ yíinoo ga ɓu-Isarayeel, yaa feekki. Ya lúukiɗohhari, ya ëldúkiꞌtari, appa ɓaa bok ga ɓu-Esíptiɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ya foogee an mbokcaagari hay kiꞌínoh an Kooh waaꞌ kikooroh gari, ya músalɓa, wayee ɓaama ínohhii iñaama ga. ");
INSERT INTO snf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ga kooh-wíisfaa, ya hotta ɓoꞌ ɓanak ga ɓu-Isarayeel ɓaa enee na kiheñoh, ya waaꞌtaɓa kijúwohiꞌ, ya woꞌꞌaɓa an: «ɓiƴaay, ɗú heñoh ya, ee ɗú ɓimbok?» ");
INSERT INTO snf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yaa jekelukee mooroomciɗa nak tappa Móyíis yah wooꞌꞌari an: «Ɓii fallaa buuꞌ na attiꞌoh ga ɗookkíi ɓa? ");
INSERT INTO snf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fu waaꞌtoo kiꞌap fodaa fu apee wútúwaa ɓaa bok ga ɓu-Esíptiɗanee?» ");
INSERT INTO snf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Daa Móyíis kelohee woꞌeencaa caama, ya núppa, ya ɗaakukneera ga kúlkaa Majaan. Ya ennda da bi ya laakka towu tanak daama. ");
INSERT INTO snf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tíkka ga tíkíis tidaaŋkaah-nikiis, laakka malaakaa Kooh feeñukki ga ëgíꞌ-dúndagaa ga yahaa jaŋjagaa Sínayíiɗa, ga ɗuuƴ kiwii, kiwiikaa enee na kitak ga ɗuuƴ dútúk. ");
INSERT INTO snf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Móyíis dalla kijaahliꞌ ga iñaa ya hotɗa, ya yaa deeƴ kimalak bi jof, wayee ya kelohha koonaakaa Haꞌmudii, kaa woꞌꞌi an: ");
INSERT INTO snf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Mi yërí en Koohyii ɓicaasamfu, Koohyii Abaraham, Koohyii Ísaak, Koohyii Yakoop.» Daama, Móyíis yaa saak ndaga kitíit, ya kaañissii kiɓëwíꞌ has kimalak. ");
INSERT INTO snf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Haꞌmudii tíkka ga, woꞌꞌari an: «ɗolaa ñafaꞌciigaraa ndaga ɗekatii fu togohɗa ɗekat wiselaꞌíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi hotin coonufaa heetaagoo enukoh ga kúlkaa Esíptiɗa. Mi kelohin tiꞌíintaagaɓa, kërí tah mi yoosukin kisomɓa. Diimaɗa, hay mi wossaa kúlkaa Esípti.» ");
INSERT INTO snf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Móyíis yaama, yërí mbokcaagari taasukee, ɓa woꞌꞌari an: «ɓii fallaa buuꞌ na attiꞌoh ɓa?» Yërí Kooh wosee ya kuliyuk ga heetaa ya laasɓa, koorohha ga malaakaa Kooh feeñukee Móyíis ga dútúkaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Móyíis na kihafci, yërí meƴdoh ɓu-Isarayeel kúlkaa Esípti ya tummba enaama cidóoyíꞌ-waaꞌ na kíntaan ga kúlkaa Esípti, ga waa ɓa paaf giiyaa wiyoꞌohwaa, na ga waa ɓa kooroh ëgíꞌ-dúndagaa ɓa tummba ga iñaa leꞌin tíkíis tidaaŋkaah-niikiisɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Móyíis yërí woꞌee ɓu-Isarayeel an: «Kooh hayyúu kimeƴdohiꞌ ga heetiigarúu sëldíiga-Koohaa man naroo.» ");
INSERT INTO snf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ga waa mbooloomaa nëgírukoh ga ëgíꞌ-dúndagaaɗa, yërí enee ɓan ga díkaanti ɓicaasammbuu na malaakaa Kooh woꞌee nari ga jaŋjagaa Sínayíiɗa, ee ya laassa ga woꞌeencaa Kooh onohi kipesɗa, kiꞌeꞌtuuca. ");
INSERT INTO snf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ɓicaasammbuu sagussa kitaam ga woꞌeen Móyíis, ɓa foñnjari, helɓa ɓoyukka Esípti. ");
INSERT INTO snf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓa nakka Aaron an: «Tíɓɗaaríi koohcaa kuliyukan ga fíkíiríi, ndaga Móyíis, yaa meƴdoheeríi kúlkaa Esíptiɗa ɗí ínohoo iñaa dalliɗa.» ");
INSERT INTO snf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Waa ennda ɗa, ɓa tíɓpa ɗoon, ɓa tummba yenɓa koohɓa, ɓa tummba sarah ga nataalaama. Keeñɓa soossa lool ga iñaa ɓa tíɓ na yahɓa yaama. ");
INSERT INTO snf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kooh úsaayyaɓa, foñnjaɓa ɓaa jaamuk nohii, ñiidii na olcii ga asamaanɗa fodii koohɓa. Ee iñaama sah-sah yërí bídu ga këyítfaa sëldíiga-Koohcaa an: «Ɗú, heetii Isarayeel, ga wii ɗú tum sarah júuꞌcaa na sarah ciliis iñaa leꞌ tíkíis tidaaŋkaah-nikiis ga ëgíꞌ-ɗundagaaɗa, ɗú tumɗeeroocane? ");
INSERT INTO snf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Múk, ɗú koorukee taalaa Molok yaa ɗú tík Kooh haffúuɗa, na nataalaa kuꞌolkaa Reefaan yaa ɗú tík Koohɗa ɓan. Nataalcaama ɗú ɓërí hëwíreeca, ɗú ɓaa jaamukca. Kërí tah, mi hayyúu kitool, mi ɓayyúu daa wëñ teeraa Babíloon kiꞌúsaay.» ");
INSERT INTO snf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Iceen tíkka ga an: - Taalaa ɗaakohsee Bíncaa ciselaꞌíꞌcaa teewoh kifiiliimunkaa Kooh na ɓicaasammbúuɗa, ɓa taabee nawa ga ɗuuƴ ëgíꞌ-dúndagaa. Taalaama, Móyíis hëwíreewa fodaa daa Kooh teeweeriwaɗa: en kiꞌenaa, ya nakee Móyíis kihëwíꞌwa, ya taabuk ga daa ya hot lëdírussiɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Taalaama, ɓicaasammbuu ɓaa hayee ga fenoociɗa laasussa gawa. Ɓa taammba nawa bi ga kúlkaa ɓa teꞌee ga heetcaa Kooh kaalee ga fíkíiɓaɗa, lak Yosúwée yërí kuliyukee ga fíkíiɓa. Wa tessa daama bi ga jamaanaa Buuꞌ Dëwít. ");
INSERT INTO snf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dëwít neɓlohha Kooh, ya kíimmba Kooh kiyípiꞌti kaan daa tucaasamuntaa Yakoop jaamukohanndi. ");
INSERT INTO snf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wayee Salomon yërí mëeñjoh kitawahiꞌ Kooh kaanfaa. ");
INSERT INTO snf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Koohyii ga ɗookaa-ɗookɗa nak dëkoo ga kaanfaa ɓoꞌ hëwíꞌ na yahci. Ee fodaa daa sëldíiga-Koohaa bínkaɗa, Haꞌmudii woꞌ an: ");
INSERT INTO snf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Asamaanii wërí en baŋ-buuriigoo, kakayfii ennda ditogaaꞌ kottoo. Kon ɗú tawahɗanndoo kaan fa man na? Wala ɗú heeliꞌtoo daa mi dëkohan da man na? ");
INSERT INTO snf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iñcuma ɓéeɓca, hanaa enndii yahhoo hëwíꞌca?» ");
INSERT INTO snf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Iceen woꞌissa attiꞌohcaa an: - Ɗú ɓërí yëgís ga haf ee keeñciigarúu na nofciirúu ɗú laginca pat ga kikelohiꞌ Kooh. Besaa en ɓéeɓ ɗú en na kilebiroh Helii yiselaꞌíꞌyii, ɗú taam ɓicaasammbúu. ");
INSERT INTO snf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Laakin sëldíiga-Kooh yíinoo rek yaa ɓicaasammbúu hatallii ga kipese? Ɓa appa sëldíiga-Koohcaa ɗeɓ kiyéegaloh kihaykaa yijúwíꞌyiiɗa. Ee watifii wati ɗú onin yijúwíꞌyii bíiŋ, ɗú apinndi. ");
INSERT INTO snf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɗú laasin ga Waasii Kooh eroh, koorohha ga malaakacaaɗa, wayee ɗú taabukkiiwa. Iceen tapisohussa na atoh bi kaannda. ");
INSERT INTO snf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Daa ɓu-paanaa wiyaakwaa kelohee woꞌeencaa Iceen caama, keeñcaagaɓa caa oñ ndaga kiꞌaylukki, ɓa ɓaa ɗowuk. ");
INSERT INTO snf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wayee, Iceen ga kihafci nak, líiffa na Helaa yiselaꞌíꞌyaa; ya taaginukka asamaan, ya hotta ndamaa Kooh, ya hotta Yéesu ɓan tuukin hanohha yah-ñaabaa Kooh, ");
INSERT INTO snf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iceen woꞌꞌa an: - Malkat, mi hotin asamaanii lëgísukin, Kowukii ɓii tuukin hanoh yah-ñaabii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Daa ɓa kelohee woꞌeencaama, ɓa dalla kipookoh na tifiip, lagussa nofcaagaɓa, ɓa íisukka waas kíinoo mílíp ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɓa fassari bi ɓa meƴca nari teeraa, ɓa aawwari kitapisoh na atoh kiꞌappi. Ɓuwaa neehalsee kiꞌen seediꞌɗa, súukussa kúltícaagaɓa kakay ga kotcaa oomaa-fiilaa teeku Sóolɗa. ");
INSERT INTO snf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ga daa ɓa enee Iceen kitapisoh na atoh tóohɗa, Iceen yaa kíim Kooh an: - Yéesu, Haꞌmudii, teꞌaa fítiigoo. ");
INSERT INTO snf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lëehíꞌta, ya ƴíꞌꞌa, lessa koonaa ga ɗook an: - Haꞌmudii, kaa taabukɓa baakaarii wii! Daa ya woꞌee iñaama, ya kaannda. Kaanaa Iceen waama, Sóol fareera ga. ");
INSERT INTO snf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kaanaa Iceen waama, Sóol fareera ga. Laakka ɓiɓoꞌ ɓigëmíꞌ Kooh ɓaa ɓeɓ faraaffaa Iceen, ɓa accafa, ee ɓa kodukka lool kaanaa Iceen. Ga besaa bëríi Iceen apuɗa, ɓuwaa gëmu ga Yéesu ee enu ga Yéerúsaleemɗa dalussa kihatalu ga kipesɓa, hatal wiméeskíꞌ. Ɓéeɓ ɓuwaa gëm ga Yéesuɗa tasaarukohussa ga gohcaa Yúudée na caa Samaríi bi tessa apotaaꞌcaa doŋ. ");
INSERT INTO snf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wayee Sóol ga kihafci, keennda ga ɗook ɓuwaa gëm ga Yéesuɗa, kiꞌíslukohɓa ngëmaagaɓa. Ya yaa aas ga kaancaa, ya yaa am ɓuwaa gëminɗa, ɓetoo ƴaaloo, ya yaa laŋɓa ga kasu. ");
INSERT INTO snf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ɓéeɓ ɓuwaa tasaarukohseeɗa nak, ɓaa wíil ga ɗuuƴ kúlkaa, ɓa ɓaa yéegaloh Hewhewii winéwíꞌwii. ");
INSERT INTO snf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fodaama Filiip kaꞌta gohaa Samaríi, ga teeru wíinoo daama, ya yaa yéegaloh Hewhewii winéwíꞌwii woꞌ ga loo Kiristaa, Músalkaatii dígohseeɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɓuwaa ga dëkaaɗa tóohɓa aawussa kisúkúruk Filiip ndaga kíntaancaa ɓa keloh ee ɓa hot ya tumiɗa, ɓa gëmmbari. ");
INSERT INTO snf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","En kiꞌenaa, raɓ ɓiyewin meyohussa na tifiip tiyaak ga ɓuwaa ɗúukoolinɗa, ee lafañ ɓiyewin na ɓeedukíꞌ ɓiyewin wëkɗussa ɓan. ");
INSERT INTO snf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Fodaama keeñ-soos wiyaak laakka ga teeraama. ");
INSERT INTO snf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wiima lak ga teeraama, laakin ɓaa ɗeɓ da kiꞌen, ya teeku Simoŋ ee ya enee luhusoh. Ɓu-Samaríi waaruꞌeera ga iñcaa ya tumeeɗa. Ya tíkee hafci ɓoꞌ yilëekíꞌ-solu, ");
INSERT INTO snf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ee ɓéeɓ, oomaanoo, yaakoo súkúrukeera iñcaa ya woꞌiɗa. Ɓa woꞌee gari an: - Ɓii yii yërí en doolii Kooh, wii woꞌu an wa doŋ wa mínɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓa ɓaa súkúrukki dijófíꞌ ndaga ya maañinɓa kiwaaruꞌi ga luhuscaa ya tumiɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wayee daa Filiip yéegalohee Hewhewii winéwíꞌwii woꞌ ga loo Nguuraa Kooh na ga loo Yéesu Kiristaaɗa, ɓéeɓ ɓuwaa, ɓetoo ƴaaloo gëmmba, ɓa awwa kibëtísiꞌuk; ");
INSERT INTO snf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","bi ga Simoŋ luhusohaa sah gëmmba, ya bëtísiꞌussa. Ya aawwa kitaabuk Filiip rek. Ya waaruꞌꞌa lool ga kíntaancaa na enaamacaa cidóoyíꞌ-waaꞌcaa ya hot Filiip tumiɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apotaaꞌcaa ga Yéerúsaleemɗa nak, kelohussa an ɓu-gohaa Samaríi teꞌuunun Woꞌeenaa Kooh ga keeñɓa. Ɓa wossa Peeꞌ na Saŋ daama. ");
INSERT INTO snf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Daa Peeꞌ na Saŋ leꞌsee da, ɓa kíimiꞌta ɓuwaama Kooh, ɓa laas ga Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","En kiꞌenaa, lak Helii yiselaꞌíꞌyii yoosukkii ga yíinoo gaɓa duum, ɓa eemee ga kibëtísiꞌu ga teekii Yéesu, Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Waa ennda ɗa, Peeꞌ na Saŋ tíkussaɓa, yaa en ɓéeɓ yah ga haf, doo ɓa ɓaa han kilaas ga Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoŋ hotta an Helii yiselaꞌíꞌyii yoosukin ga ɗook ɓuwaa ga waa apotaaꞌcaa tíkɓa yah ga hafɗa. Ya waaꞌta kineehal Peeꞌ na Saŋ hëelís, ");
INSERT INTO snf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","woꞌꞌa an: - Onattoo ɓan kimín iñuma ɗú tumiɗa, doonaa ɓaa mi tík yah ga haf ɓéeɓ ya laas ga Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wayee, Peeꞌ loffari an: - Koparumgaraa saŋkuꞌat ee fu saŋkuꞌuk nawa. Iñaa Kooh onoh, fu fooŋ an fu mínndi kilom na hëelíse? ");
INSERT INTO snf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fu laakoo waꞌ na ɓak ga iñii yii ndaga keeñiigaraa júɓpii ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kon hebukaa jafaa halaatumgaraa wibóníꞌ wuma dúuƴ, fu aaw kikíim Haꞌmudii, en ɗanaa ya bayallaa halaatumgaraa wibóníꞌ wuma, en an mínukinaa! ");
INSERT INTO snf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","En kiꞌenaa, mi hotin an fu líif na kiꞌiñaan ee fu ñaam-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoŋ dalla kitaas an: - Kíimɗattoo Haꞌmudii na kihaffúu, en ɗanaa iñcii ɗú woꞌɗa wíinoo gaca dalooroo. ");
INSERT INTO snf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peeꞌ na Saŋ, ga waa ɓa seediꞌꞌa, ɓa yéegalohha Woꞌeenii Haꞌmudii bi ɓa lëehíꞌta, ɓa ɓaa ɓoyuk Yéerúsaleem; ee ga waasaa, ɓa ɓaa yéegaloh Hewhewii winéwíꞌwii ga dëk ciyewin ga gohaa Samaríi. ");
INSERT INTO snf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Laakka bes, malaakaa Haꞌmudii woꞌꞌa Filiip an: - Koluka, fu kaꞌ ɓak iñaa hanoh meyaaꞌ-noh yah-seŋɗa, fu taam waasaa meyoh Yéerúsaleem aaw Gaasaaɗa. Waasaama koorohsussii diimaɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filiip dalla kikoluk yaa ƴah. Ya hídohha na ɓoꞌ yiƴaal yaa meyoh kúlkaa Ecoopíi, ɓaa nak enee ɓaa yóomɗu hen. Ee ɓaa yërí en tuukkoh-alalaa buuraa Ecoopíi yiɓetiyaa woꞌsi Kaandaasɗa. Ya karee Yéerúsaleem kijaamuk Kooh, ");
INSERT INTO snf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ee ya enee kiɓoyuk kaanɓa. Ɓaa, lak yugin ga sareetaagari yaa jaŋ Këyítfaa Ísayíi, sëldíiga-Koohaa bínɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Helaa yiselaꞌíꞌyaa woꞌꞌa Filiip an: - Gaawaa kitíin fu daɓ sareetaa waanee. ");
INSERT INTO snf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filiip foolla, daɓpa sareetaa, ya kelohha ɓaa yaa jaŋ ga Këyítfaa Ísayíi, sëldíiga-Koohaa bínɗa, ya meekissari an: - Iñii fu jaŋɗa, fu ínohin yen ga sahe? ");
INSERT INTO snf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɓaa taassa an: - Mi laakkii ɓaa lóogísohɗanndoowanaa, mi tuman na bi mi ínoh iñii wa waaꞌ kiwoꞌɗa? Lëehíꞌta ya woꞌꞌa Filiip kilap ga sareetaa, ya yuŋ ga yahaaci. ");
INSERT INTO snf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kuɗekatkii ya enee na kijaŋ ga Këyítfaa Ísayíi, sëldíiga-Koohaaɗa enee kii: «Fodii baal, ya ɓayussa kiꞌapunee, fodii kubaalkaa fiippii ga fíkíi ɓaa enndi na kinenɗa, fodaama, ya lëgíssii kúuwci. ");
INSERT INTO snf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ya torohɗussa ee ken onndiiri kayoh. Kumuunci laguunun ee ya foñnjii lam.» ");
INSERT INTO snf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɓaa kúlkoh Ecoopíiɗa, meekissa Filiip an: - Woꞌaaroo en neɓpaanaa, sëldíiga-Koohaa woꞌ loo ɓa dii? Woꞌ na hafcinoo, woꞌ ga ɓoꞌ yiliis? ");
INSERT INTO snf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Waa ennda ɗa, Filiip ɓeɓpa woꞌeenaa, ya abohha ga iñaa Ísayíi, sëldíiga-Koohaa woꞌ yaama, ya yaa lóogísohiꞌti Hewhewii winéwíꞌwii woꞌ ga loo Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Daa ɓa en na kiƴahɗa, ɓa leꞌꞌa ga ɗekataa taakin músú, lëehíꞌta ɓaa woꞌꞌa Filiip an: - Man músú mee, iñii kokohan ya mi bëtísiꞌu?  ");
INSERT INTO snf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filiip woꞌꞌari an: - En an fu gëmin ga keeñiigaraa ɓéeɓwanaa, fu mín kibëtísiꞌu. Ɓaa woꞌꞌari an: - Mi gëmin an Yéesu Kiristaa yërí en Kowukii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ga saasi, ɓaa dalla kinakoh sareetaa tuukiru, Filiip na ɓaa yoosukussa ga ɗuuƴ músúmaa, Filiip bëtísiꞌꞌari. ");
INSERT INTO snf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Daa ɓa meƴ músúmaa hen, Helii Haꞌmudii bëffa Filiip, ɓaa kúlkoh Ecoopíiɗa hotissiiri. Wayee ɓaa yaa ƴah waasci na keeñ wisóosíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filiip nak, meƴneera teeraa Asot, ya yaa yéegaloh Hewhewii winéwíꞌwii; ya taammba teeru na teeru, bi ga daa ya leꞌoh teeraa Sesareeɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wiima lak Sóol yii lís kidíguk kiꞌap tëelíbéecaa Haꞌmudii, ya kaꞌta ga haꞌ-kaadaa sarahohcaa kikíimmbi, këyítfaa ya teewohan ga ɓuwaa kuliyuk ga jaangu-yaawúuꞌcaa ga teeraa Damaasɗa, ");
INSERT INTO snf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","en ɗanaa ɓuwaa ya laak daama ee boku ga waasii Haꞌmudiiɗa, ennda ɓeti, ennda ƴaal, ya amɓa, ya haydohɓa Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lak ya yaa ga waas Damaas, ee ya deeyin teeraa, dalla kilaak leeꞌlaataa meyoh asamaan: wa ennda mareet ga ɗookci, bi wíillari. ");
INSERT INTO snf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ya keennda kakay. Ya kelohha koonaa, kaa woꞌꞌi an: - Sóol! Sóol, iñii tah ya fu hatalloo ga kipes? ");
INSERT INTO snf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ya taassa an: - Kiyaakii, fu yërí en ɓa? Koonaakaa woꞌꞌari an: - Mi yërí en Yéesu yii fu hatal ga kipesɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wayee koluka nak, fu aas ɗuuƴ teerum. Daama, fu hay kiwoꞌu iñaa fu jom kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɓuwaa taabee nariɗa tuukussa, tíitussa bi ɓa mínoo kiwoꞌ, ɓa kelohee ga koonaakaa wayee ɓa hottii ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sóol kolukka, wayee ga daa hascaagari buulɗa tóoh, ya hotissii dara. Ɓa ammbari ga yah, kileꞌdohhi teeraa Damaas. ");
INSERT INTO snf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tummba bes kaahay, caa ya hotoo, ya ñammbii, ya anndii. ");
INSERT INTO snf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wiima, lak laakin ga teeraa Damaas tëelíbéenaa teeku Anañaas, Haꞌmudii feeñukkari ga heeƴ woꞌꞌari an: - Anañaas! Anañaas taassa an: - Mi yee, Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Haꞌmudii woꞌꞌari an: - Karaa diima-diima kaan Yúdaa, ga waasaa woꞌu waasaa wiyólóhíꞌwaaɗa, fu meekisoh ɓaa teeku Sóol ee meyoh teeraa Taarsaɗa. Ya yaa da, ee diima deŋ yaa kíim Kooh. ");
INSERT INTO snf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ya hotin ga heeƴ ɓaa teeku Anañaas, aassa gari ga kaanfaa, tíkkari yah ga haf doonaa ya hotis. ");
INSERT INTO snf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anañaas nak woꞌꞌa an: - Haꞌmudii, mi kelohin ga ɓoꞌ ɓiyewin iñcaa cibóníꞌcaa ɓaa yaama tum ɓuwaagaraa ga Yéerúsaleemɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ee sah ya hayin dii, taam na doolaa sarahohcaa ɓiyaakɓaa onndi, kiɓay ɓéeɓ ɓuwii en na kikíim ga teekfuɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wayee, Haꞌmudii woꞌꞌari an: - Karaa hen rek, ɓaa yaama mi yërí tanukki kijeriñukohhi, ya leꞌdoh teekiigoo ga fíkíi ɓuwaa enussii yaawúuꞌɗa, fíkíi buuꞌcii, na fíkíi ɓu-Isarayeel. ");
INSERT INTO snf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi hayyi kiteeɓ na kihaffoo ɓéeɓ coonucaa ya jom kidaƴ ndaga teekiigooɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Waa ennda ɗa, Anañaas kaꞌta, ya aassa kaanfaa. Ya tíkka Sóol yahcaagari, woꞌꞌari an: - Sóol, mbokiigoo, Yéesu, Haꞌmudii yaa feeñukeeraa ga waasaa fu koorohee kihay diiɗa, yërí wossoo garaa en ɗanaa fu hotis, ee fu líif na Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ga saasi, iñcaa man na wëesée-jën keenohha hascaa Sóol, ya hotissa. Waa ennda ɗa, ya kolukka bëtísiꞌukka. ");
INSERT INTO snf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Lëehíꞌta ya ñammba, ya mínnda kituuk. Waa ennda ɗa, Sóol tessa na tëelíbéecaa Yéesu ee dëku teeraa Damaasɗa, bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ya sekkii iñaa maañ, ya aawwa kijangat ga ɗuuƴ jaangu-yaawúuꞌcaa an Yéesu yërí en Kowukii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɓéeɓ ɓuwaa kelohee iñaa Sóol woꞌ yaama, waaruꞌussa bi ɓaa woꞌ an: - Caɓ! Hanaa enndii ɓii yii yërí enee ga Yéerúsaleem, yaa hatal ga kipes ɓuwii gëm ga Yéesuɗa? Enndii kiꞌam ɓuwii gëm ga Yéesu, na kiɓayɓa Yéerúsaleem ga sarahohcaa ɓiyaakɓaa haydoheeri diine? ");
INSERT INTO snf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sóol nak wëñnja ɗa kiyëgís ga jangataagari. Yaawúuꞌcaa dëku Damaasɗa, laakussii iñaa ɓa woꞌanndi ndaga ya teeweeɓa hen bi leeꞌta an Yéesu yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kaꞌta bi maañnja, yaawúuꞌcaa hotohussa ga díkaantiɓa kiꞌap Sóol, ");
INSERT INTO snf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","wayee Sóol yéeŋnga iñaa bok ga. Wekoo, nohoo ɓa ɓaa watuk, bi ga halcaa teeraa, doonaa ɓa mínndi kiꞌap. ");
INSERT INTO snf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Waa ennda ɗa, tëelíbéecaa Yéesu Sóol jëgíreeɗa ɓayussari ga wek, ɓa ekkari ga Kosu, yoolussari ga fenoo míiraa dëkaa doonaa ya mín kisaan. ");
INSERT INTO snf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sóol leꞌꞌa Yéerúsaleem, ya waaꞌta kitaam na tëelíbéecaa Yéesuɗa, wayee ɓéeɓ niikkari ndaga ɓa gëméeríi kayoh-kayohɗa an ya enin tëelíbée Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Waa ennda ɗa, Barnabaas ɓeɓpari, ɓayyari ga Apotaaꞌcaa. Ya ɓéestíꞌtaɓa daa Sóol hotee Haꞌmudii ga waasaa, ee Haꞌmudii woꞌꞌa nariɗa, na daa ya daanee kijëgíroh ga teekaa Yéesu ga Damaasɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aboh ga besaa bëríi, Sóol taammba naɓa, ɓa ɓaa kari, ɓa ɓaa hayi ga ɗuuƴ Yéerúsaleem, ɓa ɓaa jëgíroh ga teekii Haꞌmudii ga fíkíi ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ya yaa kaꞌ ga Yaawúuꞌcaa laksi kiGerekɗa, ya yaa saawal naɓa, wayee ɓaama waaꞌseeri kiꞌap. ");
INSERT INTO snf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ɓuwaa gëm ga Yéesuɗa, daa ɓa yéegeeka, ɓa ɓayya Sóol teeraa Sesaree. Ya meyohha daama, ya yaa ƴah waa Tarsa. ");
INSERT INTO snf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Fodaama, ɓuwaa gëmu ga Yéesu dëku ga gohaa Yúudée, waa Gëlílée, na waa Samaríiɗa hannda kilaaku jam. Ɓuwaa ɓaa wëñ kiyëgís ga ngëmaa, ɓa niikka Haꞌmudii ga kipesɓa, ee Helaa yiselaꞌíꞌyaa amɗohhaɓa, ɓaa wëñ kiɓaatuk. ");
INSERT INTO snf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wiima lak Peeꞌ yaa wíil daa en ɓéeɓ. Laakka bes, ya kaꞌta teeraa Lídaa, ga ɓuwaa en ɓuu Kooh daamaɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ya laakka daama ɓaa teeku Aynee. Ɓaama lak faanukin tíkíis tiyitnataahay, ndaga ya lafañee hen. ");
INSERT INTO snf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peeꞌ woꞌꞌari an: - Aynee, Yéesu Kiristaa yërí wëkíꞌtaa, koluka fu lariꞌ haffu fayaaŋfiigaraa. Ga saasi Aynee kolukka. ");
INSERT INTO snf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Daa ɓéeɓ ɓu-Lídaa na ɓéeɓ gohaa Sarom hotseeri, ɓa súpítta kipeskaagaɓa ɓa gëmmba ga Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wiima, ga teeraa Yopee, lak laakin ɓetifaa teeku Tabítaa ee fa gëmin ga Yéesu. Teekaama woꞌsi «Dorkaas» ga kiGerek: wërí en «Nuuh». Ɓetifaama dëkee ga kitum enaama yijófíꞌ na kidímal ɓuwaa laakooɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ga bescaama, ɓetifaa keennda ɗúukool, fa kaannda. Fa ɓookussa, lëehíꞌta fa faanussa ga túuyaa hanoh ɗook ga taahaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tëelíbéecaa Yéesu ee dëku Yopeeɗa, lak yéeguunun an Peeꞌ yaa ga Lídaa. Lídaa na Yopee úsaayohussii dara. Ɓa wossa ɓoꞌ ɓanak ga Peeꞌ kiwoꞌꞌi an: «Dímalaaríi, fu gaaw kihay garíi.» ");
INSERT INTO snf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peeꞌ taammba naɓa ga saasi. Daa ya leꞌee, ɓa ɓayyari túuyaa faraaffaa faanohuɗa. Ɓéeɓ ɓeticaa ɓiƴaalɓa kaanin ee ɓa ɓihúnís Tabítaaɗa, hayussa gari na tilooyoh. Ɓa ɓaa teeɓpi mariñeeꞌcaa na kúltícaa Tabítaa daanee kiñëekíꞌ ga waa ya pesohɗa. ");
INSERT INTO snf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peeꞌ meƴdohhaɓa ɓéeɓɓa fooh, ya ƴíꞌꞌa, kíimmba Kooh. Lëehíꞌta ya mëeñsukka ga faraaffaa, woꞌꞌa an: - Tabítaa, kolka! Tabítaa malakka, ee daa ya hotee Peeꞌ hen, ya kolukka, yuŋnga. ");
INSERT INTO snf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peeꞌ ammbari ga yah, dímallari ya koluk. Lëehíꞌta Peeꞌ ɓayya ɓuwaa gëmuunun Kooh enu daɗa, na ɓeticaa ɓiƴaalɓa kaaninɗa; ɓa hayya, ya teeɓpaɓa Tabítaa, lak mílísin. ");
INSERT INTO snf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iñaa hew yaama síwwa ga teeraa Yopee ee ɓoꞌ ɓiyewin gëmussa ga Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Waa ennda ɗa, Peeꞌ tessa ga Yopee bi maañnja ga kaan ɓoꞌ, yaa teeku Simoŋ ee ya iñaa tíyoh-on. ");
INSERT INTO snf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Laakeera ga teeraa Sesaree ɓaa teeku Korney. Ya kuliyuki ɓoꞌ ɓitéeméeꞌ ga lagaa soldaaꞌcaa ɓu-Room woꞌsi «Ítalíiɗa». ");
INSERT INTO snf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɓaa yaama enee ɓoꞌ yigëmíꞌ Kooh ee niikeera Kooh ya na ɓu-kaanci ɓéeɓɓa. Ya yewineera kidímal yaawúuꞌcaa laaksooɗa ee ya tagohéeríi na kikíim Kooh. ");
INSERT INTO snf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Laakka bes, ga wahtu kigoonaluk, iñaa ammbari fodii heeƴ, ya hotta faŋ malaakaa Kooh feeñukki, woꞌꞌari an: - Korney! ");
INSERT INTO snf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korney ennda hascaagari jak ga malaakaa, ya dalla kitíit, meekissari an: - Kiyaakii, iñii laak ya? Malaakaa woꞌꞌari an: - Kooh tookin iñii fu kíimmbiɗa ee ya hotin dii fu amɗohi ɓuwii laakooɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Diima nak wosaa ɓiɓoꞌ Yopee, ga ɓaa teeku Simoŋ ee ɓaysi Peeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ya yaa ga kaan ɓaa teeku Simoŋ, yaa tíyi on ee kaanci faa ga yahaa giiyaa. ");
INSERT INTO snf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ga waa malaakaa woꞌee nari kaꞌɗa, Korney ɓayya ga súrgacaagari ɓanak, na soldaaꞌ yigëmíꞌ Kooh ga ɓaa ya kuliyukɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ya ɓéestíꞌta tóoh iñaa heweeɗa, lëehíꞌta, ya wossaɓa teeraa Yopee. ");
INSERT INTO snf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ga kooh-wíisfaa, lak ɓuwaa Korney woseeɗa ɓaa ga waas ee ɓa deeyin teeraa Yopee. Wiima lak Peeꞌ lapin ɗook taahaa kaan Simoŋ, tíyoh-odaa, kikíim Kooh ga wahtu cuunoh. ");
INSERT INTO snf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kiyaaɓ daɓpari, ya waaꞌta kiñam. Lakanaa ya yaa tíkɗu cuunoh, iñaa ammbari fodii heeƴ, ");
INSERT INTO snf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ya hot Asamaan lëgískin, iñaa man na píis wiyaak, waa abu ga siñdaacaa cinikiiscaa waa yoosuk, meyoh asamaan. ");
INSERT INTO snf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ga ɗuuƴ píisaama, heet rawaa en ɓéeɓ waa ga: ennda haꞌ-kot cinikiis, ennda ɓii fasukiɗa, ennda heet selaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Laakka koonaakaa woꞌ Peeꞌ an: - Peeꞌ kolka, fu ap, fu ñam! ");
INSERT INTO snf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peeꞌ taassa an: - Múk, Haꞌmudii, mi mosoo kiñam iñaa tabin na iñaa settii ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Koonaakaa woꞌissa kotaa kukanakkaa an: - Iñaa Kooh woꞌ an setin ga fíkíici, kaa tíkwa iñaa tabin. ");
INSERT INTO snf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Iñaama, ennda ɗa waas kaahay, lëehíꞌta ga saasi píisaa lappa asamaan. ");
INSERT INTO snf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lak Peeꞌ jaahliꞌin ee yaa lís kiraas ga helci ati iñaa ya hot yaama waaꞌ ya kiwoꞌ. Wahtaama nak ɓuwaa Korney woseeɗa leꞌussa, ɓa meekisohha bi ɓa leꞌꞌa kaan Simoŋ, ɓa tuukka ga hal-kaadaa. ");
INSERT INTO snf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓa ɓëytohha, ɓa meekisohha an: - Simoŋ yii woꞌu Peeꞌɗa en ga kaanfii fiine? ");
INSERT INTO snf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peeꞌ nak, lak yaa lís kihalaat ga iñaa ya hotɗa, Helaa yiselaꞌíꞌyaa dallari kiwoꞌ an: - Ɓoꞌ ɓaahay ɓee ee soolukussaa. ");
INSERT INTO snf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kolka fu yoosuk fu taam naɓa ee kaa laak hel kanak ga, ndaga mi yërí wosɓa. ");
INSERT INTO snf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peeꞌ yoosukka, kaꞌta ga ɓuwaa, woꞌꞌaɓa an: - Mi yërí en ɓii ɗú waaꞌ kihotɗa. Iñii enee kottúu ya? ");
INSERT INTO snf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓa taassari an: - Korney, yaa kuliyuk ga soldaaꞌcaaɗa, yërí wossíi. Ya enin ɓaa júwin ee niikin Kooh, ee ɓéeɓ yaawúuꞌcii seediꞌinka gari. Laak malaakaa Kooh dígalli kiɓaylukkaa fu kaꞌ kaanci, ya súkúrukkaa ga iñaa fu jommbi kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Waa ennda ɗa, Peeꞌ paafdohhaɓa ɗuuƴ kaanfaa, ya néehíꞌtaɓa daama bi Kooh wíissa. Ga kooh-wíisfaa, Peeꞌ tíkukka ga waas, yaa ƴah naɓa. Laakeera ɓiɓoꞌ ɓaa ɓenndi ga ɓuwaa gëmu ga Yéesu ee dëku Yopeeɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ga besaa tík gaɗa, ya leꞌꞌa teeraa Sesaree. Wiima nak, lak Korney hídírohin ɓu-kaanci na fiiliimun-kumuuncaagari, ɓii sekki. ");
INSERT INTO snf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ga waa Peeꞌ en na kiꞌaas kaanfaaɗa, Korney hayya, kihídohnee nari, ya jafukka kakay ga kotcaagari, ƴíꞌꞌa ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wayee Peeꞌ ammbari, yaa ɓëwíꞌti, woꞌꞌari an: - Kolka Korney! Mi ɓan, mi ɓoꞌ doŋ fodii garaa. ");
INSERT INTO snf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Lëehíꞌta Peeꞌ yaa saawal nari bi ɓa aassa kaanfaa. Peeꞌ nak hotta ɓuwaa ga ɗuuƴ kaanfaa, hídírukohuunun ɓiyewin. ");
INSERT INTO snf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ya dalla kiwoꞌ an: - Fodii dii ɗú ínohkaɗa, ɓaa en yaawúuꞌ hoonohuunun kiꞌaboh na ɓaa enndii yaawúuꞌ ee hoonohuunun kiꞌaas kaaanci. Wayee Kooh teewinndoo, mi na kihaffoo, an Ken jomoo kiwoꞌ ɓoꞌ an kitaam nari tabin wala an ya settii. ");
INSERT INTO snf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kërí tah mi laakkii hel kanak ga kihay dii ga wii ɗú ɓaylukkooɗa. Kon diimaɗa soolii enee ya? ");
INSERT INTO snf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korney taassa an: - Laakin bes kaahay ga wati, ga wahtii ɗu kíimohi Kooh ga kigoonaluk ɗu enoh wii siiꞌɗa, mi enee dii ga kaanndoo, mi yaa kíim Kooh. Mi yéeŋngiinaa, mi hotta ɓoꞌ yaa ekukin kúltí cimélícíꞌ, meyin mël ga fíkíiroo, ");
INSERT INTO snf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ɓaa woꞌꞌaroo an: «Korney, Kooh tookɗinndaa iñaa fu kíimeeriɗa, ee ya hotin ga dii fu took kidímal ɓuwii laakooɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Diima nak, wosaa ɓiɓoꞌ teeraa Yopee, ga ɓoꞌ yaa teeku Simoŋ ee ɓaysi Peeꞌ. Ya yaa ga kaan ɓoꞌ yaa teeku Simoŋ, iñaa tíyoh-on ee kaanci faa ga yahaa giiyaa. ");
INSERT INTO snf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ga saasi mi wosohharaa kikooꞌnee, ee ga dii fu hayinɗa, iñii fu tumɗa jofin. Kon ɗí ɓéeɓpíi ɗí ɓee ga fíkíi Kooh kisúkúruk ɓéeɓ iñii Haꞌmudii nakkaa kiwoꞌꞌíiɗa.» ");
INSERT INTO snf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Waa ennda ɗa, Peeꞌ ɓeɓpa woꞌeenaa, woꞌꞌa an: - Diima, mi ínohin kayoh-kayohɗa an Kooh tík ɓuwii ɓa wíinoo ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","En kiꞌenaa, ɓéeɓ ɓaa fu niikki, ee fu tumi iñaa júwin ga fíkíicinaa, ga heetaa fu mín kibokoh ga ëldúna tóoh, fu neɓlohinndi. ");
INSERT INTO snf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ya wosohin woꞌeenaagari ga ɓu-Isarayeel, ya yéegalohha ga ɗuuƴɓa Hewhewii winéwíꞌwii haydoh jam kesiɗa, koorohha ga Yéesu Kiristaa, yii en Haꞌmudii ɓuwii ɓéeɓ ga ëldúnaɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ga iñaa tík ga waa Saŋ ɓëytoh ɓuwaa kibëtísiꞌukneeɗa, ɗú ínohin iñaa hewee, síwwa ga kúlkaa Yúudée ɓéeɓ ee dalohee gohaa Gëlíléeɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yéesu Nasareet yaama, Kooh faleeri, soꞌtari doolaa meyoh ga Helii yiselaꞌíꞌyii, ya yaa wíil daa en ɓéeɓ kitum enaama cijófíꞌ, ya yaa wëkíꞌ ɓéeɓ ɓuwaa Seytaani laakee dooli ga ɗookɓaɗa ndaga Kooh taabee nari. ");
INSERT INTO snf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɗí nak, ɗí seediꞌin ɓéeɓ iñaa ya tum ga kúlkaa yaawúuꞌcaa na ɓan ga Yéerúsaleemɗa. Ɓa appari ga waa ɓa daaƴci ga kuraanaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wayee ga besaa wukaahaywaa tík gaɗa, Kooh mílísiꞌtari, onndari kifeeñuk. ");
INSERT INTO snf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ya feeñukkii nak ga ɓuwii ɓéeɓɓa wayee enee ga ɓuwaa Kooh tanukee balaa bëríinaa, ɓa en seediɗa: ennda ɗí ɓii, ɗí bokin nari kiñam na kiꞌan ga waa ya mílís ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yéesu yaama, yërí ebillíi kijangat ga ɗuuƴ heetii yaawúuꞌcii na kiseediꞌ an Kooh yërí falli kiꞌatti ɓuwii pesɗa na ɓuwii kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sëldíiga-Koohcaa ɓéeɓɓa seediꞌuunun ga Yéesu an: ɓéeɓ ɓaa fu gëm garinaa, ga doolaa teekaagari, fu hay kibaylu baakaaꞌcaagaraa. ");
INSERT INTO snf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lakanaa Peeꞌ yaa lís kiwoꞌ fodaama, Helaa yiselaꞌíꞌyaa yoosukka ga ɗook ɓéeɓ ɓuwaa enee na kisúkúruk woꞌeenaagariɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yaawúuꞌcaa gëm ga Yéesu ee taamsee na Peeꞌɗa, jaahliꞌussa lool ga daa Helaa yiselaꞌíꞌyaa Kooh onohɗa yoosukin ɓan ga ɓuwaa enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","En kiꞌenaa, ɓa kelohee ɓuwaa ɓaa woꞌ lak ciliis ee ɓa ɓaa kañ kiyakkaa Kooh. Waa ennda ɗa, Peeꞌ dalla kiwoꞌ an: ");
INSERT INTO snf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","- Ɓoꞌ mínin ɓuwii ɓii kihoonoh kibëtísiꞌu ga músú ee lak fodii garuu, ɓa laasin ga Helii yiselaꞌíꞌyiinee? ");
INSERT INTO snf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Fodaama ya ebilohha ɓa bëtísiꞌu ga teekii Yéesu Kiristaa. Lëehíꞌta ɓa kíimmbari ya tes naɓa bi sam kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Waa ennda ɗa, apotaaꞌcaa na mbok-kerceencaa enu ga gohaa Yúudéeɗa kelohussa an bi ga ɓuwaa enussii yaawúuꞌɗa sah laasuunun ga woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ga waa Peeꞌ ɓoyuk Yéerúsaleemɗa nak, yaawúuꞌcaa gëm ga Yéesuɗa ɓaa ñaꞌti an: ");
INSERT INTO snf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","- Iñii tah ya fu aas kaancaa ɓuwaa enussii yaawúuꞌɗa bi sah fu ñam naɓa? ");
INSERT INTO snf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Daama nak Peeꞌ awwaɓa kiɓéestíꞌ wíinoo wíinoo tóoh iñaa heweeɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ya woꞌꞌaɓa an: - Laakee bes mi enee na kikíim Kooh ga teeraa Yopee, iñaa ammbaroo fodii heeƴ, mi hotta enaama waa yoosukoh asamaan, waa hay kakay mannda na píis wiyaak, waa abu ga siñdaacaa cinikiiscaa, wa hayya bi garoo. ");
INSERT INTO snf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi malakka ɗuuƴgaa dijófíꞌ mi hotta ga raɓ, haꞌ-kot nikiiscii na raɓ luufcii na ɓii fasukiɗa, na selcii. ");
INSERT INTO snf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Waa ennda ɗa, mi kelohha koonaakaa woꞌꞌoo an: «Peeꞌ kolka, fu ap, fu ñam.» ");
INSERT INTO snf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wayee mi taassa an: «Múk Haꞌmudii, ndaga iñaa tabin kiñam na iñaa settii ga fíkíifu mosoo kiꞌaas kúuwroo.» ");
INSERT INTO snf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Koonaakaa woꞌissa ga asamaan kot kukanak an: «Iñaa Kooh woꞌ an setin, kaa tíkwa iñaa tabin.» ");
INSERT INTO snf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Iñaa tummba ɗa bi ennda waas kaahay, lëehíꞌta tóoh ɓoƴkidohussa asamaan. ");
INSERT INTO snf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ga wahtaama siiƴ, laakka ɓoꞌ ɓaahay ɓaa hayu kaanfaa ɗí enoheeɗa. Ɓa meyohee teeraa Sesaree ee ɓa wossee garoo. ");
INSERT INTO snf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Helii yiselaꞌíꞌyii woꞌꞌaroo kikaꞌ naɓa ee mi hanat kilaak hel kanak ga. Fodaama mbok-kerceencii ɓiyitniinooɓii ɗú hot ɓii taabussa naroo bi ga kaan Korney. ");
INSERT INTO snf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Korney nak ɓéestíꞌtaríi an laak malaakaa Kooh hayee gari ga kaanci, woꞌꞌari an: «Wosohaa teeraa Yopee kikooꞌnee Simoŋ yaa teeku Peeꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ya hayyaa kiwoꞌ woꞌeencaa onanndaa kimúc, fu na ɓu-kaanfu ɓéeɓɓa.» ");
INSERT INTO snf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Daa mi dal naɓa kiwoꞌ hen rek, Helii yiselaꞌíꞌyii yoosukka ga ɗookɓa fodaa ya yoosukee ga ɗookkuu ga dalaaraaɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ga saasi, mi níindísukka woꞌeenaa Haꞌmudii woꞌee an: «Saŋ bëtísiꞌee ga músú, wayee ɗú, ɗú ƴah kibëtísiꞌu ga Helii yiselaꞌíꞌyii.» ");
INSERT INTO snf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kon, waa Kooh yërí onɓa Helii yiselaꞌíꞌyii fodii dii ya oneeruuwa ga waa ɗu gëm ga Yéesu Kiristaa, Haꞌmudiiɗa, mi mínee ɓa kiꞌen bi mi kokoh Kooh kitum iñaa ya waaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Daa ɓuwaa kelohee woꞌeencaama, ɓa laakissii iñaa ɓa woꞌan ee ɓa ɓaa kañ Kooh an: - Kon kay kayoh, Kooh onin bi ga ɓuwii enussii yaawúuꞌɗa kisúpít kipeskiigaɓa, doonaa ɓa laas ga kipeskii kukayohkii. ");
INSERT INTO snf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kihatal ga kipeskaa laakee, ga waa Iceen kaanɗa, tahha ɓuwaa gëm ga Yéesuɗa wesohha daa en ɓéeɓ. Ɓa kaꞌta bi ga gohaa Fenísíi na waa Sípaꞌ giiyaa wíilɗa, na waa Añcoos, ɓa ɓaa yéegaloh woꞌeenaa Kooh wayee ɓa eemdoheewa ga yaawúuꞌcaa doŋ. ");
INSERT INTO snf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wayee nak laakeera gaɓa ɓuwaa meyohsee Sípaꞌ na teeraa Síreen, ɓaa kaꞌ Añcoos kiyéegalohnee ga ɓuwaa enussii yaawúuꞌɗa Hewhewii winéwíꞌwii woꞌ ga loo Yéesu Kiristaa, Haꞌmudiiɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Doolaa Haꞌmudii taammba naɓa bi ɓoꞌ ɓiyewin gëmussa ee ɓa súpítta kipeskaagaɓa, ɓa gëmmba Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ɓuwaa gëm ga Yéesu ee dëku Yéerúsaleemɗa kelohussa iñaa laakɗa, ɓa wossa Barnabaas Añcoos. ");
INSERT INTO snf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ga waa ya leꞌɗa, ya hotta daa Kooh hín kibarkeel ɓuwaamaɗa, keeñci soossa ga lool. Ya yaa daasɓa ɓéeɓɓa ɓa taabuk ngëmaa ɓa laak ga Haꞌmudiiɗa na keeñ wiyëgísíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabaas nak enee ɓoꞌ yijófíꞌ, yaa líifin na Helii yiselaꞌíꞌyii na ngëm ɓan. Fodaama, ɓiɓoꞌ ɓigëñ gëmussa ga Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Waa ennda ɗa, Barnabaas kaꞌta teeraa Tarsa kikooꞌnee Sóol. ");
INSERT INTO snf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Daa ya hoteeri, ya haydohhari Añcoos. Ɓa ɓanak, ɓa tummba kíis kimúlúŋ ga ɗuuƴ tëelíbéecaa Yéesu ee enu ga Añcoosɗa, ee ɓa jëgíꞌta ɓoꞌ ɓigëñ. Ɓuwaa gëm ga Yéesuɗa ɗeɓ kiɓayu «ɓikerceen» ga teeraa Añcoos. ");
INSERT INTO snf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ga bescaama, laakka sëldíiga-Koohcaa meyohu Yéerúsaleem, hayussa Añcoos. ");
INSERT INTO snf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yíinoo gaɓa, ee teeku Agabus, Helii yiselaꞌíꞌyii ínohlukohhari an aꞌ wiyaak hay kilaak ga ëldúna tóoh, ya yéegalohha ka. En kiꞌenaa, araama laakka hídukoh lak buuꞌ Kólóot yërí nguurukee ga jamaanaama. ");
INSERT INTO snf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Waa ennda ɗa, mbok-kerceencaa ga Añcoosɗa júwohussa ga kiwosoh dímal ga mbok-kerceencaagaɓa enu ga gohaa Yúudéeɗa, yaa en ɓéeɓ ga iñaa ya mín kiꞌerohɗa. ");
INSERT INTO snf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ennda iñaa ɓa tumɗa: ɓa wosohha ga yaakcaa ga jaangucaa ga Yúudéeɗa iñcaa ɓa onohɗa, Barnabaas na Sóol ɓayuca. ");
INSERT INTO snf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ga jamaanaama, Eroot, buuraa ennda ga kisodal ɓiɓoꞌ ga kerceencaa. ");
INSERT INTO snf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ya gúꞌlukka na kalaɓ hafaa Saak, yaak Saŋ. ");
INSERT INTO snf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Daa ya hotee an iñaa ya tumɗa neɓlohin yaawúuꞌcaa, ya amlukka Peeꞌ ɓan. Iñaama hídukohee ga feetaa yaawúuꞌcaa ñamohi mbúurúcaa tumsoo lëwíiꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Daa ya amlukee Peeꞌ, ya laŋngari ga kasu, ya tuukiꞌta laŋ cinikiis ga soldaaꞌ, ca hëyrohhi kiwatuk: lagaa en ɓéeɓ soldaaꞌ ɓinikiis. Ya waaree Paakaa paafaa ya ɓayyi ga fíkíi ɓuwaa, ɓa attiꞌꞌi. ");
INSERT INTO snf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Fodaama, Peeꞌ yaa watuku ga kasaa ee kerceencaa enussa ga kikíimiꞌti Kooh ga daa ɓa wëñ kimínɗa. ");
INSERT INTO snf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Buuꞌ Eroot tuukee ga kiɓay Peeꞌ ga fíkíi ɓuwaa ya attiꞌu. Wayee ga wekaama ee kooh-wíisfaa ya jomee kiꞌattiꞌohuɗa, Peeꞌ enee na kineeh ga díkaanti soldaaꞌ ɓanak, ee lak yahcaagari pokuunun gaɓa na ceen kanak. Ga kúuw-halkaa kasaa, laakka soldaaꞌcaa tuuk da kiwatuk. ");
INSERT INTO snf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Laakka malaakaaHaꞌmudii meƴ mël ga fíkíici, túuyaa leeꞌta lañ. Malaakaa fëekíꞌta Peeꞌ ga hëbúusaa, yúunndari, woꞌꞌari an: - Kolka gaaw! Ceencaa poksee ga yahcaa Peeꞌɗa, keennda. ");
INSERT INTO snf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaakaa woꞌissari an: - Pëkírukka, fu ekuk ñafaꞌciigaraa. Peeꞌ tummba ɗa. Malaakaa tíkka ga an: - Ekukaa kúltífiigaraa, fu taam ga fenooroo. ");
INSERT INTO snf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peeꞌ taammba ga fenoo malaakaa, meƴca kasaa. Ya gëméeríi sah an iñaa malaakaa tum yaama laakin kayoh-kayohɗa, ya foogee an iñaa heeƴ. ");
INSERT INTO snf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Fodaama ɓa paaffa soldaaꞌcaa ɓa ɗeɓ gaɓa kileꞌɗa, ɓa paaffa ɓaa tík gaɗa, ɓa leꞌꞌa hal-pewiñaa ëewruk teeraaɗa. Halaa lëgíssa hafwa ga fíkíiɓa, ɓa meƴca, ɓa taammba mbedi ɓaa ƴah. Malaakaa ennda mes, foñnjari. ");
INSERT INTO snf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ga ɗekataama, Peeꞌ hannda kiꞌínoh iñaa laakɗa, ya woꞌꞌa an: - Mi ínohin kimma, kayoh-kayohɗa Haꞌmudii yërí wos malaakii garoo, ya músalinndoo ga yah Eroot na ɓéeɓ iñaa yaawúuꞌcaa waaree dallooɗa. ");
INSERT INTO snf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Fodaama tóoh leeꞌta ga hafaagari, ya yaa ƴah kaan Mërí, eew Saŋ yaa ɓaƴsi Markaɗa, lak laakin ɓoꞌ ɓiyewin ɓaa hídírukoh daama, ɓaa kíim Kooh. ");
INSERT INTO snf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peeꞌ fëekíꞌta ga hal-kaadaa, laakka súrga yiɓeti yaa teeku Root, hayya kimalak. ");
INSERT INTO snf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Daa ya ínohsohee koonaakaa Peeꞌ, keeñci soossa ga bi ya lëgíssii sah halaa, wayee ya nammba kifool hen kiyéegalnee ɓuwaa ga ɗuuƴɗa an: - Peeꞌ yërí, yaa tuukka ga halaa, ga fooh. ");
INSERT INTO snf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɓa woꞌꞌari an: - Hanaa fu dof hen! Wayee ya yëgíssa ga an iñaa kayoh. Ɓa dalla kiwoꞌ an: - Kon Malaakaagari yërí. ");
INSERT INTO snf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peeꞌ nak líssa kifëekíꞌ ga halaa. Daa ɓa lëgísee, ɓa hotta an yërí ya, ɓa waaruꞌꞌa. ");
INSERT INTO snf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peeꞌ múuffa yah ga kúuw kiɗékóhíꞌ ɓuwaa, ya ɓéestíꞌtaɓa daa Haꞌmudii tum bi meƴdohhari ga kasaaɗa. Lëehíꞌta ya woꞌꞌaɓa an: - Karat ɗú yéegalka Saak na mbok-kerceencaa tesɗa. Lëehíꞌta ya meƴca, yaa ƴah ɗekat wiliis. ");
INSERT INTO snf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ga waa Kooh wíisɗa, soldaaꞌcaa lëyussa lool, ɓa ɓaa meekisoh iñaa mín Peeꞌ kidalɗa. ");
INSERT INTO snf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eroot ebilohha kiraasnee Peeꞌ, wayee ken hottiiri. Ya ɓaylukka soldaaꞌcaa, ya meekissaɓa daa ɓa tumee bi Peeꞌ saanndaɗa, lëehíꞌta ya nakohhaɓa kiꞌap. Waa ennda ɗa Eroot meyohha gohaa Yúudée, kaꞌta teeraa Sesaree, ya ennda daama bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wiima lak buuꞌ Eroot aylukohin na ɓu-Tíiꞌ, na ɓu-Sídoŋ. Ɓuwaama júwohussa ga kikaꞌ, ɓa malakneeri. Ɓa ɗúkohha na Balastus, yaa tuukuk túuyaa buuraaɗa, ya dímalɓa ga. Waa ennda ɗa, ɓa kíimmba Eroot kijúwoh naɓa ndaga dúndaagaɓa tóoh meyohee kúlkaa buuraa. ");
INSERT INTO snf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ga waa besaa ɓa abeeɗa leꞌꞌa, Eroot ekukka kúltí-buuꞌfaagari, ya kerukka ga baŋ-buuraagari, ya yaa jangat ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɓuwaa ɓaa fiip an: - Laak Kooh yaa en na kiwoꞌ, enndii ɓoꞌ-súusúus doŋ woꞌ naruu! ");
INSERT INTO snf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ga wahtaama siiƴ, laakka malaakaa Haꞌmudii mík Eroot ndaga daa ya eꞌtii Kooh ndamɗa. Laakka nasucaa soogu lookaa, ɓaa ñammbi, ya kaannda. ");
INSERT INTO snf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Waa ennda ɗa woꞌeenaa Kooh waa wëñ kisíw, tëelíbéecaa ɓaa wëñ kiɓaatuk. ");
INSERT INTO snf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabaas na Sóol nak, ga waa ɓa lëehíꞌ kitum lëgëyaagaɓa ga Yéerúsaleemɗa, ɓa ɓoƴkissa ee ɓa ɓaydohha Saŋ, yaa ɓaysi Markaɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ga Añcoos nak laakeera ɓisëldíiga-Kooh na ɓijëgíroh-waas ga ɓuwaa gëmu ga Yéesu enu daamaɗa. Enee ɓuwii ɓii: Barnabaas, Simewoŋ ee ɓaysi Súusúus, Lusiyus yaa dëk teeraa Síreenɗa, Manayeen yaa bokee kikoruk na Eroot, gúwernëeraaɗa, na Sóol. ");
INSERT INTO snf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Laakka bes, ɓa enee na kijaamuk Haꞌmudii ɓa ɓaa ooꞌ, Helii yiselaꞌíꞌyii woꞌꞌaɓa an: - Faanɗattoo haŋ Barnabaas na Sóol, ɓa tum lëgëyaa tah mi ɓayohɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Waa ennda ɗa, ɓa lëestíꞌta kiꞌooꞌ na kikíim Kooh, ɓa tíkka Barnabaas na Sóol yah ga haf, ɓa íissaɓa, ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Fodaama Helaa yiselaꞌíꞌyaa wossa Barnabaas na Sóol kikaꞌ dëkaa woꞌu Selësíi, ɓa aasohha gaal-giiƴ daama, ɓa ɓaa ƴah Sípaꞌ dëkaa giiyaa wíilɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ga waa ɓa leꞌꞌa Salamín, ɓa aawwa kiyéegaloh woꞌeenaa Kooh ga ɗuuƴ jaangu-yaawúuꞌcaa. Saŋ-Marka taabee naɓa kiꞌamɗohɓa ga lëgëyaa. ");
INSERT INTO snf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɓa húussa dëkaa giiyaa wíilɗa bi ɓa meƴneeraa teeraa Paafos. Daama, ɓa hídohha na luhusohaa teeku Baaꞌ-Yéesu. Ya enee yaawúuꞌ ee tíkee hafci sëldíiga-Kooh. ");
INSERT INTO snf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ya bokee ga ɓuwaa taabi na Sersíyus Polus yaa enee gúwernëeꞌ ga teeraaɗa. Sersíyus Polus yaama nak enee ɓoꞌ yilëekíꞌ-hel. Ya ɓaylukka Barnabaas na Sóol ndaga ya waaree kikeloh woꞌeenaa Kooh. ");
INSERT INTO snf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wayee Baaꞌ-Yéesu ee ɓaysi ɓan Elímaas, luhusohaaɗa (teekaa wërí en iñaama ga kiGerek) aawwaɓa kiheñoh, yaa heel kiꞌëewdoh gúwernëeraa ga iñaa enndii kigëm ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Waa ennda ɗa, Sóol ee ɓaysi ɓan Poolɗa líiffa na Helaa yiselaꞌíꞌyaa, yíppari has, ");
INSERT INTO snf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","woꞌꞌari an: - Fu Elímaas, fu líif na saboh na kibon ee fu kowu Seytaani mat. Fu waaꞌtii kihot ga iñaa júwin. Fu íisoo Waasii Kooh wijúwíꞌwii fu kalañsohiɗane? ");
INSERT INTO snf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ínohaa an diima deŋ yahii Haꞌmudii hayin kidal ga ɗookfu. Fu hay kibúum, fu tes ɗa bi maañ, fu hotoo nohii. Ga saasi, hascaa Elímaas ñúussa, ya búummba yaa túut ga ɓakaa en ɓéeɓ kisëesíꞌ ɓaa nookanndi. ");
INSERT INTO snf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gúwernëeraa nak, daa ya hotee iñaa laak yaama, dalla kigëm ga Yéesu. En kiꞌenaa, ya waaruꞌeera lool ga iñaa ya jëgíru ga loo Haꞌmudii yaama. ");
INSERT INTO snf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Waa ennda ɗa, Pool na ɓuwaa taabee nariɗa aasohussa gaal-giiƴ ga teeraa Paafos, ɓaa ƴah teeraa Persi ga kúlkaa Pamfílíi. Saŋ-Marka nak tagohha naɓa daama, yaa ɓoyuk Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓa nak, ɓa meyohha teeraa Persi, ɓa abissa waasaagaɓa, ɓaa ƴah bi ɓa leꞌꞌa Añcoos Písídíi. Laakka bes, ɓa aassa jaangu-yaawúuraa en daamaɗa ga bes Sabat, ɓa yuŋnga. ");
INSERT INTO snf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Laakka iñaa jagu ga Këyítfaa Waasii Móyíis na faa sëldíiga-Koohcaa; lëehíꞌta ɓuwaa kuliyuk ga jaangu-yaawúuraaɗa nakka ɓiɓoꞌ kiwoꞌ Pool na Barnabaas an: - Mbokcii, en laakin iñaa ɗú waaꞌ kiwoꞌ kidaas mbooloomiinaa, ɗú míninnndi kiwoꞌ. ");
INSERT INTO snf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Waa ennda ɗa, Pool kolukka, ya ɓëwíꞌta yah, ɓuwaa een paaƴ, ya woꞌꞌa an: - Ɗú ɓu-Isarayeel na ɗú, heetcii cíinoo ee jaamuki Koohɗa, súkúꞌkattoo. ");
INSERT INTO snf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Koohyii Isarayeel heetiigaruu yërí tanukee ɓicaasammbuu. Ya tapisiꞌta heetii ga waa wa en ga ín, ga kúlkaa Esíptiɗa. Tíkka ga, ya meƴdohhawa kúlkaa Esípti na dooli yahci. ");
INSERT INTO snf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ee ga ɗuuƴ ëgíꞌ-dúndagaa ɓicaasammbuu enoheeɗa, Kooh toputuꞌꞌaɓa iñaa leꞌ tíkíis tidaaŋkaah-nikiis. ");
INSERT INTO snf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Waa ennda ɗa, ya ɗúbíꞌta heet ciyitnakanak ga kúlkaa Kanaa, ya eꞌta ɓu-Isarayeel heetiigari kúlkaama. ");
INSERT INTO snf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ee ɓa lamin ka iñaa jomin kileꞌ tíkíis titéeméeꞌ-nikiis na tidaaŋkaah-yëtúus. Tíkka ga, ya eꞌtaɓa ɓiꞌattiꞌoh ɓaa kuliyukanɓa bi ga daa Samiyeel, sëldíiga-Koohaa hayohɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Waa ennda ɗa, ɓa kíimmba Kooh ya onɓa buuꞌ. Kooh nak, onndaɓa Sawúl, kowu Kíis ee bokee ga geñaa Beesamee. Sawúl nguurukka bi ennda tíkíis tidaaŋkaah-nikiis. ");
INSERT INTO snf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lëehíꞌta, Kooh níssa Sawúl ga nguuraa, ya falla Dëwít ya en buuraa ɓicaasammbuu. Kooh seediꞌꞌa ga buuꞌ Dëwít an: «Mi hotin ga Dëwít kowu Yesee ɓaa neɓlohinndoo ee ya ƴah kimëtíꞌ ɓéeɓ iñaa mi waaꞌ.» ");
INSERT INTO snf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ee fodaama, Kooh meƴdohɗin ɓu-Isarayeel Músalkaat ga níilaa buuꞌ Dëwít fodaa ya dígoheekaɗa, ennda Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ee balaa Yéesu hayaa, Saŋ-Bëtís enee ga kijangat, ya yaa ɓëytoh ɓéeɓ ɓu-Isarayeel kisúpít kipeskiigaɓa, ɓa bëtísiꞌuk. ");
INSERT INTO snf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Bi ga daa kikaanci deeƴɗa, Saŋ lísee kiwoꞌ an: «Ɗú fooŋ an mi yërí en ɓa? Mi enndii ɓii ɗú sekɗa. Ɓaama yii hay ga fenooroo ee kipëkís liiɓcaa ñafaꞌcaagari sah joobinndoo.» ");
INSERT INTO snf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pool woꞌissa an: - Ɗú mbokciigoo, ɗú ɓii ɗú en tucaasamuntii Abaraham, na ɗú ɓii ɗú en dii ɗú jaamuki Koohɗa, woꞌeenii wii onohi kimúcɗa, ɗu ɓërí tah Kooh wosohwa. ");
INSERT INTO snf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","En kiꞌenaa, ɓu-Yéerúsaleem na ɓuwaa kuliyuk gaɓaɗa ínohséeríi ɓaa Yéesu enɗa ee woꞌeencaa sëldíiga-Koohcaa ɓa jagee ga bes Sabataa en ɓéeɓɗa ɓan, ɓa ínohéeríi iñaa ca waaꞌ kiwoꞌɗa. Ee fodaama, ga waa ɓa tíkki kikaanɗa, ɓa mëtíꞌta woꞌeencaa sëldíiga-Koohcaa. ");
INSERT INTO snf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hídaa ɓan ga daa ɓa hottii dara iñaa cal ɓa tíkki kikaanɗa, ɓa kíimmba Pílaat, ya aplukki. ");
INSERT INTO snf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ga waa ɓa mëtíꞌ kitum tóoh iñcaa Bíncaa ciselaꞌíꞌcaa woꞌ ga loo Yéesuɗa, ɓa yóoskíꞌtari ga kuraanaa, ɓa ekkari ga ɗuuƴ loyaa. ");
INSERT INTO snf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wayee Kooh mílísiꞌtari ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ɓuwaa taabee nari, aboh ga gohaa Gëlílée bi ga Yéerúsaleemɗa, ga waa ya mílísɗa ya feeñukkaɓa bes ciyewin, ee ɓéeɓ ɓuwaama wati ɓërí en seedi ga fíkíi heetii. ");
INSERT INTO snf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ee ɗí, ɗí hay kiyéegallúu Hewhewii winéwíꞌwii wii an: ");
INSERT INTO snf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Iñaa Kooh dígee ɓicaasammbuuɗa ya tumɗinnduuri, ɗu, tucaasamuntiigaɓa, ga waa ya mílísiꞌ Yéesu fodaa daa ka bídu ga Këyítfaa kañcaa fukanakfaaɗa an: «Fu yërí en Kowukiigoo, mi enin Paamfu wati. ");
INSERT INTO snf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kooh yéegaloheera an ya hay kimílísiꞌ Yéesu, ee Yéesu ɓoƴkisissoo ga loy.» Iñaama yërí ya woꞌee an: «Mi hayyúu kiꞌeꞌ iñcaa ciselaꞌíꞌcaa mi dígee Dëwít, ee ca calin kigëmɗa.» ");
INSERT INTO snf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ee ga ɗekat wiliis, ga këyítfaa, ya woꞌissa an: «Fu tookanndii ɓiigaraa yiselaꞌíꞌyii nop ga ɗuuƴ loy.» ");
INSERT INTO snf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dëwít, ga jamaanaagari, enee súrga Kooh, ya tummba iñaa Haꞌmudii waareeɗa, ya kaannda, ya acussa ga yahaa ɓicaasamci, ee faanfaagari nopin ga ɗuuƴ loy. ");
INSERT INTO snf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wayee ɓaa Kooh mílísiꞌɗa, faanfaagari noppii ga ɗuuƴ loy. ");
INSERT INTO snf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Kon mbokcii, ínohat gaka an yërí tah ɗú yéegalussa an baakaaꞌcaagarúu bayaluununndúu. Ɓéeɓ ɓaa gëm gari, Kooh hayyi kiꞌaboh ɓoꞌ yijúwíꞌ, ee iñaama Waasaa Móyíis mínoori. ");
INSERT INTO snf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kon watukat iñcaa sëldíiga-Koohcaa woꞌeeɗa keen ga ɗookkúu. ");
INSERT INTO snf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Ɗú hot gane, ɗú ɓii ɗú ɓëwíri haffúuɗa, hebukaa ɗú tíit ɗú aaw kinúp, ndaga mi hay kitum ga ɗuuƴ kipessúu iñaa wëeꞌtaa ga an yii ɗú ɓéestíruwanaa, ɗú gëmoo.» ");
INSERT INTO snf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ga waa Pool na Barnabaas meyu jaangu-yaawúuraaɗa, ɓuwaa kíimmbaɓa ɓa ɓoƴkis kijëgíroh woꞌeenaa waama ga bes Sabataa tík gaɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ga waa ɓuwaa tasohɗa, yaawúuꞌ ɓiyewin na ɓoꞌ ɓiyewin ɓiliis ɓaa niikin Kooh ɓedussa Pool na Barnabaas. Ga ɗuuƴ saawalaagaɓa, Pool na Barnabaas ɓaa daasɓa doonaa ɓa wëñ kitík yaakaaꞌɓa ga kijofkaa Kooh teeɓɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ga bes Sabataa tík gaɗa, iñaa wëñ kiyewin ga ɓu-teeraaɗa, hídírukohussa kisúkúruk Woꞌeenii Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Daa yaawúuꞌcaa hotee ɓuwaa ɓiyewinɓaa, ɓa líiffa na keeñ-tam, ɓa taammba ga iñaa Pool jëgírohɗa ɓaa nís, ɓa ɓaa ɓassi. ");
INSERT INTO snf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Waa ennda ɗa, Pool na Barnabaas laakussa fít kiwoꞌɓa an: - Ɗú ɓërí jomee kiɗeɓ kiyéegalu woꞌeenii Kooh. Waa ɗú saginwa kiteꞌ, ɗú attiꞌin haffúu an kipeskaa leehoo taaꞌɗa joobinndúu. Kërí tah ɗí ɓii ƴah ga ɓuwaa enussii yaawúuꞌɗa ");
INSERT INTO snf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","En kiꞌenaa, iñii yii yërí Yéesu, Haꞌmudii ebillíi: «Mi falinndaa kiꞌen leerii heetcii, doonaa fu leꞌdoh kimúckii bi ga daa ëldúna topohɗa.» ");
INSERT INTO snf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ɓuwaa enussii yaawúuꞌɗa safarussa ga woꞌeenaa ɓa kelohɗa, ɓa ɓaa kañ Kooh ga woꞌeencaagari ee ɓéeɓ ɓuwaa jom kilaas kipeskaa leehoo taaꞌɗa gëmussa. ");
INSERT INTO snf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Woꞌeenii Haꞌmudii waa wëñ kisíw ga ɗuuƴ kúlkaa ɓéeɓka. ");
INSERT INTO snf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wayee yaawúuꞌcaa hícísohussa helcaa ɓeticaa ɓilëekíꞌ-teekɓaa ga dëkaa ee niikuunun Koohɗa, na yaakcaa dëkaa. Ɓa sodalla Pool na Barnabaas ga kipesɓa, kaalussaɓa kúlkaa. ");
INSERT INTO snf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ɓaama përtukaɓa pëndëlaa kotcaa ga dëkaagaɓa, lëehíꞌta ɓaa ƴah Íkoñom. ");
INSERT INTO snf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tëelíbéecaa ga teeraa Añcoosɗa, keeñɓa soossa, ɓa líiffa na Helaa yiselaꞌíꞌyaa. ");
INSERT INTO snf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pool na Barnabaas tumissa ga Íkoñom fodaa ɓa tumee ga Añcoos Písídíiɗa. Laakka bes, ɓa aassa jaangu-yaawúuraa en daamaɗa, ɓa ɓaa jangat bi ɓoꞌ ɓiyewin ga yaawúuꞌcaa na ɓuwaa enussii yaawúuꞌɗa gëmussa ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wayee yaawúuꞌcaa sagu kigëm ga Yéesuɗa yasohussa helcaa ɓuwaa enussii yaawúuꞌɗa bi ɓa ekkaɓa ga kisaŋ ɓuwaa gëm ga Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hoonohhii bi Pool na Barnabaas maañussa ga Íkoñom, ɓa ɓaa jangat na fít wiyëgísíꞌ ndaga ɓa óolukeera Haꞌmudii. Ee Haꞌmudii nak onndaɓa kimín kitum kíntaan na enaama cidóoyíꞌ-waaꞌ. Fodaama, ya yaa teewoh an iñaa apotaaꞌcaa jangat aaw ga kijofkaagariɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ɓu-teeraa Íkoñom júwohsissii, ɓa hëgískohha: ɓii faꞌta na yaawúuꞌcaa, ɓíinoo farussa na apotaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yaawúuꞌcaa na ɓuwaa enussii yaawúuꞌɗa, na ɓuwaa kuliyuk gaɓaɗa tuukussa ga kisodal Pool na Barnabaas, na kitapisohɓa atoh bi ɓa kaan. ");
INSERT INTO snf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wayee daa ɓa yéegeeka, ɓa kaꞌta kisomuknee ga teerucaa ga gohaa Líkawooníiɗa, ennda Lístaꞌ, Derbe na iñaa wíil daamaɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Daama ɓan, ɓa aawwa kiyéegaloh Hewhewii winéwíꞌwii woꞌ ga loo Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Laakeera ga Lísta, ɓoꞌ yiƴaal yaa yugee daa díinoo rek mínoo kituuk, ya límdohu na kilafañ ee mosoo kitíin na kotci. ");
INSERT INTO snf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Laakka bes, ya enee na kisúkúruk jangataa Pool. Pool yíppari has, hotta an ngëmaa ɓaa laak ga Yéesuɗa míninndi kimúsal, ");
INSERT INTO snf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ya woꞌꞌari didóolíꞌ an: - Kolka, fu tuuk tek ga kotciigaraa! Ɓaa dalla kiꞌen bërít, tuukka, yaa tíin. ");
INSERT INTO snf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Daa mbooloomaa hotee iñaa Pool tum yaama, ɓa ɓaa woꞌ didóolí ga lakaa ɓu-Líkawooníi an: - Koohcii súpítukuunun ɓoꞌ, yoosukuunun garuu. ");
INSERT INTO snf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓa teekka Barnabaas Sës, ɓa teekka Pool Ermes ndaga Pool yërí laakee woꞌeenaa. ");
INSERT INTO snf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Laakeera ga yahaa halaa teeraa kaanfaa ɓa jaamukohi Sës, Koohyaagaɓa. Ɓaa tumɗi Sës sarah ga kaanfaaɗa haydohha, ga kúuw-halcaa, naal-kuuy, yaa líkuunun enaama cimóríꞌ caa taam na sapuus. Ya na mbooloomaa, naalcaama ɓa waareeɓa kiꞌap kitumiꞌ Barnabaas na Pool sarah. ");
INSERT INTO snf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Daa Barnabaas na Pool yéegee iñaama, ɓa ɗaꞌsohha kúltícaagaɓa kiteewoh an ɓa faꞌtii ga, ɓa íisukka ga mbooloomaa ɓaa fiipɓa an: ");
INSERT INTO snf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","- Héey, ɓiƴaay, ɗú ƴah ya kitum yuma? Ɗí ga kihaffíi, ɗí ɓiɓoꞌ doŋ fodii garúu. Ɗí hay dii kiyéegallúu Hewhewii winéwíꞌwii, ɗú foñ iñcii cii laakoo jeriñɗa, ɗú mëeñsuk, ɗú ëewdoh haffúu ga Koohyii en na kipesɗa, yii sak asamaanii, kakayfii, giiyii na ɓéeɓ iñcii en gaɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kuɗewaa, ya íisee heetcii, waa en tóoh waa taabuk waasaagari. ");
INSERT INTO snf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Moona déy, ya dëk ga kitum enaama cijófíꞌ, kiteewoh ɓaa ya enɗa: yërí onirúu towii meyohi asamaanɗa, ɗú laak gëñ iñaa ɗú ñaman, ya sóosíꞌ keeñnjúu. ");
INSERT INTO snf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hídaa ga iñaa ɓa woꞌɓa yaama tóoh, apotaaꞌcaa laakussa coonu fiyaak kinís mbooloomaa ga kitumiꞌɓa sarah. ");
INSERT INTO snf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Waa ennda ɗa, laakka yaawúuꞌcaa meyohu teeraa Añcoos Písídíi na waa Íkoñom, nookussa ɓuwaa ga hafɓa, lëehíꞌta ɓa tapisohha Pool na atoh kiꞌappi, ɓa fassari bi meyussa nari teeraa, ɓa foogee an ya kaanin. ");
INSERT INTO snf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wayee, ga waa ɓuwaa gëm ga Yéesu hayu, gíwussariɗa, ya kolukka, ya aassa teeraa. Ga kooh-wíisfaa, ya taammba na Barnabaas, ɓa kaꞌta teeraa Derbe. ");
INSERT INTO snf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pool na Barnabaas yéegalohussa Hewhewii winéwíꞌwii ga teeraa Derbe. Ɓa laakka tëelíbée Yéesu ɓiyewin daama. Lëehíꞌta, ɓa ɓoyukka teeraa Lístaꞌ, waa Íkoñom na waa Añcoos Písídíi. ");
INSERT INTO snf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɓa ɓaa yëgísíꞌ keeñcaa ɓuwaa gëm ga Yéesuɗa, ɓa ɓaa daasɓa ɓa yëgís ga ngëmaa. Ɓa woꞌee an: «Ɗu jomin kikooroh ga coonu ciyewin paaƴ, ɗu han kiꞌaas ga Nguuraa Kooh.» ");
INSERT INTO snf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ga jaangaa en ɓéeɓ, ɓa tannda ga ɓiɓoꞌ ɓaa kuliyukan ga ɓuwaa. Lëehíꞌta, ɓa kíimmba Kooh, ɓa ooꞌta, ɓa díŋkaanndaɓa Haꞌmudii, yii ɓa gëm gariɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ga waa ɓa meyoh daamaɗa, ɓa koorohha gohaa Písídíi, ɓa kaꞌta waa Pamfílíi. ");
INSERT INTO snf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓa yéegalohha woꞌeenii Kooh ga teeraa Persi, lëehíꞌta ɓa hayya teeraa Atalíi ga daa gaal-giiƴcaa teeriɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ɓa aassa gaal-giiƴ daama, ɓa ɓaa ɓoyuk teeraa Añcoos Síríi, daa ɓa díŋkaanohsee ga kijofkaa Kooh ɓa tum lëgëyaa ɓa meyoh kimëtíꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ga waa ɓa leꞌɗa, ɓa hídírohha ɓuwaa gëm ga Yéesuɗa, ɓa ɓéestíꞌtaɓa tóoh iñcaa Kooh tum koorohha gaɓaɗa. Ɓa ɓéestíꞌtaɓa ɓan daa ɓuwaa enussii yaawúuꞌ aasu ga ngëmaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɓa tessa na ɓuwaa gëm ga Yéesuɗa bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Laakka ɓiɓoꞌ ɓaa meyoh gohaa Yúudée hayussa Añcoos Síríi. Ɓa aawwa kijëgíꞌ ɓuwaa gëmin ga Yéesuɗa an: «Binaa ɗú gúrukkii fodaa daa Waasaa Móyíis nakohkaɗanaa, ɗú mínoo kimúc.» ");
INSERT INTO snf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pool na Barnabaas leŋkohussa naɓa, laakussa naɓa ñaroh witamóhíꞌ ga iñaama. Waa ennda ɗa, ɓuwaa gëm ga Yéesuɗa abussa an Pool na Barnabaas na ɓiɓoꞌ ɓaa bok gaɓa jomuunun kikaꞌ Yéerúsaleem ga apotaaꞌcaa na ɓuwaa kuliyuk ga jaangaa Yéesu en daamaɗa, ɓa woꞌ ga iñaama. ");
INSERT INTO snf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɓu-jaangaa Añcoos erussaɓa iñaa ɓa sooluk ga ɓaawaagaɓaɗa, ɓa ɓaa ƴah. Ɓa kooꞌta gohaa Fenísíi na waa Samaríi, ɓa ɓaa ɓéestíꞌ daa ɓuwaa enussii yaawúuꞌ aasu ga kigëm ga Yéesuɗa. Iñaa laak yaama, soossa keeñ ɓéeɓ ɓuwaa gëm ga Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ga waa ɓa leꞌ Yéerúsaleemɗa, ɓu-jaangaa na apotaaꞌcaa na ɓuwaa kuliyuk ga jaangaaɗa teerukkaɓa. Lëehíꞌta, ɓa ɓéestíꞌtaɓa tóoh iñcaa Kooh tum kooroh gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wayee, laakka ɓiɓoꞌ ga Fërísiyeeŋcaa ee gëmuunun ga Yéesu, ɓaa koluk, woꞌussa an: - Ɓuwaa enussii yaawúuꞌ ɓaama ee gëmu ga Yéesuɗa jomuunun kigúruk, ee ɓa woꞌu kitaabuk iñaa Waasii Móyíis nakoh kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apotaaꞌcaa na ɓuwaa kuliyuk ga jaangaaɗa hídírukohussa kimalak iñaama. ");
INSERT INTO snf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ga waa ɓa nookohha ga iñaama bi maañnja, Peeꞌ dalla kikoluk, woꞌꞌa an: - Mbokcii, fodii ɗú ínohkaɗa iñaa Kooh tanukeeroo ga díkaantirúu maañin. Ya tanukeeroo kiyéegal ɓuwii enussii yaawúuꞌɗa Hewhewii winéwíꞌwii, doonaa ɓa kelohwa ee ɓa gëm gari. ");
INSERT INTO snf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ee Kooh yii ínohin iñaa en ga keeñ ɓaa en ɓéeɓɗa, teewohin an ya tookinɓa ga waa ya onɓa Helii yiselaꞌíꞌyii fodaa ya oneeruuriɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ee laakkii kitansoh kíinoo kaa Kooh tum ga díkaantiruu naɓa. Ee ɓa setɗin keeñcaagaɓa ndaga ngëmaa ɓa laak gariɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kon iñii tah ya ɗú waaꞌ Kooh kitooñ ga kikooꞌ ɓuwii enussii yaawúuꞌ gëmu gariɗa ɗofcaa, ennda ɗu, ennda ɓicaasammbuu, ɗu mosooca kimín kikooruk. ");
INSERT INTO snf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ee sah, ɗu yaawúuꞌcii ɗu gëmin an ɗu múcin ndaga yërmaandaa Yéesu, ee ɓa ɓan, ɓa gëm iñaama. ");
INSERT INTO snf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Waa ennda ɗa, mbooloomaa ennda cel. Buwaa ɓaa súkúruk Pool na Barnabaas, ɓaama ɓaa ɓéestíꞌɓa kíntaancaa na enaamacaa cidóoyíꞌ-waaꞌcaa Kooh tumee, kooroh gaɓa ga leeloo ɓuwaa enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ga waa ɓa lëehíꞌ kiwoꞌɗa, Saak tíkka ga an: - Súkúrukat mbokcii! ");
INSERT INTO snf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoŋ ɓéestírinndúu daa ga dalaaraa, Kooh hayya ga ɓuwii enussii yaawúuꞌɗa, ya tanukka ga ɗuuƴɓa heetaa enan wuuci. ");
INSERT INTO snf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ee iñii ya woꞌɗa taabohin na iñaa sëldíiga-Koohcaa woꞌeeɗa ndaga bíduunun ga këyítfaa an: ");
INSERT INTO snf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Iñii yii paafaa, mi hay kihayis ee mi hay kitawahis kaanfii Dëwít, fii ɓúreeɗa, mi hay kihëwíris iñii lís ga kitesɗa, mi tuukirisfa. ");
INSERT INTO snf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Fodaama, iñii tes ɓoꞌ ga ëldúnaɗa aaw kiraas Haꞌmudii ee ɓan bi ga ɓéeɓ heetcii mi tanuk ca en cuurooɗa aawsan kiraas Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Iñaama yërí Haꞌmudii woꞌ, ee ya mëtíꞌsi iñaa ya waayukee kitum ee ínohukin kumëeñíꞌɗa.» ");
INSERT INTO snf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Saak tíkka ga an: - Tahin bi mi ga kihaffoo, mi am an ɗu hanat kisodal ɓuwaa enussii yaawúuꞌ ɓaama mëeñsukuunun ɓa ɓii gëm ga Koohɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wayee hoonohoo ɗu bínɓa ɓan, ɗu woꞌɓa an: ɓa hanat kiñam koynohkaa sarahohu ga koofcaa, ɓa abuk ga kifaanuk na ɓaa en ɓéeɓ, ɓa abuk ɓan ga kiñam koynoh júuraa apu ee ñífaa aamussii, wala kiꞌan ñíf. ");
INSERT INTO snf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","En kiꞌenaa, daloh ga cosaan bi ga wati, laakin ga teeraa en ɓéeɓ ɓiɓoꞌ, ɓaa jëgírohi iñaa Waasii Móyíis nakoh kitumɗa, bes Sabataa en ɓéeɓ ga jaangu-yaawúuꞌcii. ");
INSERT INTO snf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Waa ennda ɗa, apotaaꞌcaa na ɓuwaa kuliyuk ga jaangaa Yéerúsaleemɗa na ɓéeɓ kerceencaa daamaɗa júwohussa an ɓa hay kitan ɓiɓoꞌ ga ɗuuƴɓa, ɓa wosɓa Añcoos, ɓa taam na Pool na Barnabaas. Ɓa tannda Yúdaa ee ɓaysi Barsabaas, na Sílaas. Ɓa ɓanak ɓéeɓɓa, ɓuwaa gëm ga Yéesuɗa oneeraɓa ceeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓa eꞌtaɓa këyít, ee iñii yii yërí bídu ga an: «Ɗú mbokciigaríi dëku Añcoos, Síríi na Sílísíiɗa, ɗú ɓii ɗú enndii yaawúuꞌɗa, ɗí ɓii këñíꞌtúu ɗí apotaaꞌcii na ɓuwii kuliyuk ga jaangii Yéerúsaleemɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ɗí kelohin an laakin ɓuwaa meyohu dii, hayuunun garúu. Ɓa ɓum jaahallúu, ɓa ɓum hícoh helcumgarúu na woꞌeencumgaɓa ee ɗí nakkiiɓa ka. ");
INSERT INTO snf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kërí tah ɗí ɓéeɓpíi ɗí júwohin, ɗí tanin ɓiɓoꞌ ɓaa ɗí wos garúu. Ɗí akitohinɓa na Pool na Barnabaas, fiiliimunciigaríi, ");
INSERT INTO snf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ɓii erohin kumuunɓa ndaga teekii Yéesu Kiristaa, Haꞌmudiigaruuɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kon ɗí ɓii wosoh garúu Yúdaa na Sílaas, ɓa woꞌꞌúu iñii ɗí bín ga këyítfiiɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","En kiꞌenaa, Helii yiselaꞌíꞌyii yii naríi, ɗí waaꞌtiirúu dara kitík yiɓítíꞌ, enndii iñcii ɓoꞌ mínoo kifoñ ciinaa: ");
INSERT INTO snf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kaa ñamat koynohkaa tumu sarah ga koofcaa, kaa anat ɓan ñíf wala kiñam koynoh júuraa apu hen ee ñífaa aamussii, ee kaa faanukat na ɓaa en ɓéeɓ. Binaa ɗú watuk iñcaamanaa, ɗú hay kitum yijófíꞌ. Kijaammu-jaammu!» ");
INSERT INTO snf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Waa ennda ɗa, ɓuwaa tansee wosussaɗa ɓaa ƴah Añcoos. Ga waa ɓa leꞌɗa, ɓa hídírohha ɓéeɓ ɓuwaa gëm ga Yéesuɗa, lëehíꞌta, ɓa eꞌtaɓa këyítfaa. ");
INSERT INTO snf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Fa jagussa ee ɓuwaa ɓéeɓɓa keeñɓa soossa ga iñaa bídu ga këhítfaa yaama ee daasinɓa ga ngëmɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yúdaa na Sílaas ga kihafɓa, ensee ɓisëldíiga-Kooh. Ɓa saawalla na ɓuwaa bi maañnja, kidaasɓa na kiɓaatɓa dooli ga ngëmaagaɓa. ");
INSERT INTO snf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓa tessa daama bi sammba kimaañ, lëehíꞌta, Ɓuwaa íisussaɓa ɓa ɓoyuk na jam ga ɓuwaa woseeɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Wayee Sílaas nak ɓoyukkii, ya tessa ga Añcoos. ");
INSERT INTO snf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pool na Barnabaas ɓan tesussa ga Añcoos, ee ɓa ɓanak taabussa na ɓiɓoꞌ ɓiyewin ɓiliis, ɓaa jëgíroh, ɓaa yéegaloh Hewhewii winéwíꞌwii en woꞌeenii Haꞌmudiiɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ga besaa tík gaɗa, Pool woꞌꞌa Barnabaas an: - Ɗu kaꞌsat, ɗu wíil tóoh teerucaa ɗu yéegalohee woꞌeenii Haꞌmudii gacaɗa, ɗu waaknee mbokcaa gëmuunun ga Yéesu enu daɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabaas nak, waaꞌta kiɓaydoh Saŋ yaa ɓaysi Markaɗa, ");
INSERT INTO snf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","wayee Pool tookkii Marka taam naɓa ndaga daa yaama foñeeɓa ga teeraa Pamfílíi, taabissii naɓa ga lëgëyaa ɓa enee na kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɓa nookohha ga iñaama bi faf ɓa hëgískohha. Barnabaas taammba na Marka, ɓa aassa gaal-giiƴ, ɓaa ƴah kúlkaa Sipaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pool nak tanukka kitaam na Sílaas. Mbok-kerceencaa díŋkaanohhaɓa ga kijofkaa Haꞌmudii, ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ya wíilla gohaa Síríi na waa Sílísíi, ya yaa daas ɓuwaa gëm ga Yéesuɗa, ɓa yëgís ga ngëmaa. ");
INSERT INTO snf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Waa ennda ɗa, Pool kaꞌta Derbe, lëehíꞌta ya paaffa bi ga Lístaꞌ. Daama laakeera ɓaa gëmin ga Yéesu ee teeku Tímotée. Tímotée yaama, eeci enee yaawúuꞌ gëmmba ga Yéesu ee paamci enee Gerek. ");
INSERT INTO snf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ya nak, mbok-kerceencaa dëku Lístaꞌ na Íkoñomɗa hotsee kijúɓ gari. ");
INSERT INTO snf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool waaꞌta ya taam nari. Ya ɓayyari kon, gúꞌtari ndaga yaawúuꞌcaa dëk ga gohaamaɗa. En kiꞌenaa, ɓéeɓɓa ínohseera an paam Tímotée iñaa Gerek. ");
INSERT INTO snf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ga ɗuuƴ teerucaa ɓa kooroheeɗa, Pool na Sílaas ɓaa yéegaloh iñcaa apotaaꞌcaa na ɓuwaa kuliyuk ga jaangaa Yéerúsaleem amɗa, ɓa nakkaɓa kitaabukca. ");
INSERT INTO snf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Fodaama, kerceencaa ɓaa wëñ kiyëgís ga ngëmaa ee ɓa ɓaa wëñ kiɓaatuk besaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pool na Sílaas ɓaa wíil ga gohaa Fírígíi na waa Galaat ndaga lak Helii yiselaꞌíꞌyii hoonohinɓa kiyéegaloh woꞌeenii Kooh ga gohaa Aasíi. ");
INSERT INTO snf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ga waa ɓa kaꞌ bi ɓa deeƴca gohaa Mísíiɗa, ɓa waaꞌta kiꞌaas gohaa Bítíníi wayee Helii Yéesu onndiiɓa ka. ");
INSERT INTO snf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Waa ennda ɗa, ɓa húussa ga gohaa Mísíi, ɓaa ƴah Torowaas. ");
INSERT INTO snf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Laakka bes ga wek Pool hotta ga heeƴ ɓoꞌ yaa dëk Maseduwaan. Ɓaa tuukin ga fíkíici yaa kíimmbi an: «Hayaa Maseduwaan, fu sommbíi!» ");
INSERT INTO snf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Daa Pool hotee iñaama ga heeƴ, ga saasi ɗí tummba tóoh kikaꞌ Maseduwaan ndaga lak wëerinndíi an Kooh yërí ebillíi kiyéegalohnee Hewhewii winéwíꞌ wii daama. ");
INSERT INTO snf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Waa ennda ɗa, ɗí aassa gaal-giiƴ ga teeraa Torowaas, ɗí yolohha Samotaraas dëkaa giiyaa wíilɗa. Ga kooh-wíisfaa, ɗí kaꞌta bi ga Neyapólís. ");
INSERT INTO snf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kolkohha daama, ɗí kaꞌta Filiip, teeraa wëñ kilaak solu ga gohaa Maseduwaan ɓu-Room teꞌɗa. Ɗí yuŋnga ga teeraama bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ga besaa Sabat, ɗí meƴca teeraa, ɗí kaꞌta seereenaa húlúwaa ndaga lak ɗí foogin an daama jomin kilaak ɗekataa yaawúuꞌcaa jaamukohi Kooh. Laakeera ɓeticaa hídírukohu da, ɗí yuŋnga naɓa, ɗí saawalla naɓa. ");
INSERT INTO snf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ga ɓeticaama, laakeera yaa teeku Lídíi ee meyohee teeraa Tíyaatíiꞌ. Ya enee toonoh píis, píiscaa súupu ciyoꞌoh ee seerin, ee ya niikeera Kooh. Ya yaa súkúrukkíi dijófíꞌ ndaga lak Haꞌmudii lëgísin keeñaagari, en ɗanaa ya gëm woꞌeencaa Pool. ");
INSERT INTO snf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ya bëtísiꞌussa, ya na ɓu-kaanci, lëehíꞌta ya woꞌꞌaríi an: - Hayat, ɗú sagacukkoo ga kaanndoo en an ɗú tookin kayoh-kayohɗa an mi gëmin ga Haꞌmudiinaa. Faf ya ekkaríi ga kikaꞌ kaanci. ");
INSERT INTO snf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Laakka bes, ɗí enee na kiƴah ɗekataa kíimohsi Koohɗa, ɗí hídohha na súrga yiɓeti yaa raɓ am, onndari kimín kilíiruk. Kilíiruk kaama haydohɗeera haꞌ-kaancaagari kopaꞌ wiyewin. ");
INSERT INTO snf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ya yaa taabukkíi, mi na Pool, ya yaa fiip didóolíꞌ an: - Ɓuwii ɓii ɓërí en súrgacii Kooh yii ga ɗookaa-ɗookɗa. Ɓa hay kiyéegallúu waasii onohi kimúcɗa! ");
INSERT INTO snf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ya tummba iñaama bes ciyewin. Kaꞌta bi Pool kappa ga, ya dalla kimëeñísuk, woꞌꞌa rawaa an: - Ga teekii Yéesu Kiristaa, mi ebillaa fu meyoh ga ɓetifii! Ga saasi rawaa meƴca ga súrgaa yiɓetiyaa. ");
INSERT INTO snf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Daa haꞌ-kaancaa súrgaa yiɓetiyaa hotee an ɓa abissii yaakaaꞌ kilaakis dërëm gari, ɓa ammba Pool na Sílaas, ɓa fítísohhaɓa bi ga paanaa dëkaa ga fíkíi attiꞌohcaa. ");
INSERT INTO snf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɓa tuukiꞌtaɓa ga fíkíi ɓu-Room ɓaa kuliyuk ga dëkaaɗa, ɓa ëpírohha an: - Ɓuwii ɓii ɓiyaawúuꞌ ee ɓa ɓii hícísoh dëkiigaruu. ");
INSERT INTO snf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɓa ɓii jëgíroh dii baahcaa waasiigaruu hoonohinnduu kitook, hoonohinnduu kitaabuk, ɗu ɓu-Room. ");
INSERT INTO snf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mbooloomaa ɓan taammba naɓa ga, ɓa keennda ga ɗook Pool na Sílaas. Attiꞌohcaa nakohha kiɗol kúltícaa Pool na caa Sílaas ee ɓa rípu na ngeeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ga waa ɓa ríppaɓa na ngeeꞌ bi faancaa ílohha, ɓa laŋngaɓa ga kasaa. Ɓa woꞌꞌa ɓaa watuki kasaaɗa ya foñ helci gaɓa dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Daa ɓaa watuki kasaaɗa woꞌsee iñaama, ya laŋneeraɓa ga túuyaa hanoh ɗuuƴ ga kasaaɗa, ya ekkaɓa jéeŋ ga kotcaa. ");
INSERT INTO snf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ga ɓak leeloo wek, Pool na Sílaas ɓaa kíim Kooh, ɓaa kañnji na kiƴeek. Ɓuwaa ɓíinoo abu ga kasaa naɓaɗa ɓaa súkúrukɓa. ");
INSERT INTO snf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Waas kíinoo kakayfaa yëngëlukka bi tawahaa kasaa waa yëngëluk. Ɓéeɓ halcaa kasaa dalla kiꞌen kúpít lëgísukka, ee jéeŋcaa pokohsee ɓuwaa abu ga kasaaɗa cëpísukka. ");
INSERT INTO snf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ɓaa watuki kasaaɗa tíitta ga pëní, yúudukka; daa ya hotee halcaa kasaa lëgískin gëpít, ya dalla kiɗol kalaɓfaagari, ya yaa ƴah kiharuk, ndaga ya foogee an ɓuwaa laŋsee ga kasaaɗa ɓéeɓɓa núpuunun. ");
INSERT INTO snf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wayee Pool fiippari didóolíꞌ an: - Túuk kaa tumka; ɗí ɓéeɓpíi ɗí ɓee! ");
INSERT INTO snf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ɓaa watuki kasaaɗa dalla kimeekisoh lampu, íisukka ɗuuƴ kasaa na jaaꞌ, ya keennda kakay ga kotcaa Pool na Sílaas, ya yaa saak. ");
INSERT INTO snf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Waa ennda ɗa, ya meƴdohhaɓa kasaa, ya meekissaɓa an: - Tiyaatii, mi jom ya kitum bi mi kimúc? ");
INSERT INTO snf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pool na Sílaas taassari an: - Gëmaa ga Yéesu Haꞌmudii, fu hay kimúc, fu na ɓu-kaanfu. ");
INSERT INTO snf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pool na Sílaas nak yéegalussari woꞌeenii Haꞌmudii, ya na ɓéeɓ ɓuwaa dëk ga kaanciɗa. ");
INSERT INTO snf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ga wahtaama siiƴ ga wekaa, ɓaa watuki kasaaɗa taammba na Pool na Sílaas, ya tíssa gaañcaagaɓa, lëehíꞌta ya bëtísiꞌukka ga saasi, ya na ɓu-kaanci ɓéeɓɓa. ");
INSERT INTO snf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ya ɓayya Pool na Sílaas kaanci, tofiꞌtaɓa kanu. Keeñci soossa lool ya na ɓu-kaanci ndaga daa ɓa gëmin ga Koohɗa. ");
INSERT INTO snf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ga waa Kooh wíisɗa, attiꞌohcaa ɓu-Room ga dëkaaɗa wosussa ɓiɓoꞌ kiwoꞌ ɓaa watuki kasaaɗa, an: - Íisaa Pool na Sílaas ɓa ƴeeꞌ! ");
INSERT INTO snf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ɓaa watuki kasaaɗa yaa fool kiyéegal Pool an: - Attiꞌohcaa nakuununndoo kiꞌíissúu ɗú ƴeeꞌ. Kon diimaɗa, ɗú mínin kimeƴ ɗú ƴeeꞌ na jam. ");
INSERT INTO snf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wayee Pool woꞌꞌa ɓuwaa wosseeɗa an: - Ɓa feeklukinndíi ga fíkíi ɓéeɓ, ɗí kooꞌtii ga kiꞌattiꞌu ee ɗí bok ga ɓu-Room; lëehíꞌta, ɓa laŋngaríi ga kasu. Diimaɗa nak ɓa waaꞌ kilokuk ɓa íissíi ee ken yéegoo. Múk mínoo kiꞌen, ɓa hayat na kihafɓa ɓa meƴdohhíi! ");
INSERT INTO snf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɓuwaa wosseeɗa karussa, woꞌussa attiꞌohcaa ɓu-Room ga dëkaaɗa woꞌeenaama. Daa ɓa ínohee an Pool na Sílaas boku ga ɓu-Room, ɓa tíitta. ");
INSERT INTO snf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓa hayyaɓa kibayaluknee na kihafɓa, ɓa meƴdohhaɓa kasaa; ɓa kíimmbaɓa ɓa meƴ dëkaagaɓa. ");
INSERT INTO snf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pool na Sílaas meyussa kasaa, ɓa kaꞌta kaan Lídíi. Ɓa laak kerceencaa daama, ɓa daassaɓa ga ngëmaa, lëehíꞌta ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool na Sílaas koorussa teeraa Amfípólís na waa Apolínii, ɓa kaꞌta teeraa Tesaloník. Daama Lak yaawúuꞌcaa laakuunun jaangu da. ");
INSERT INTO snf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Fodaa ya meeree ka kitumɗa, Pool kaꞌta jaangu-yaawúuraa. Ya tíkísohha bes Sabat kaahay, caa ya saawali na ɓuwaa ga loo Bíncaa ciselaꞌíꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ya yaa lóogísohiꞌɓaca, ya yaa teeɓɓa ga iñaa Bíncaa woꞌɗa an: «*Kiristaanii jomee kikaan, tík ganaa ya mílís.» Kiristaanaama, yërí en Yéesu yii mi yéegaloh diiɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Laakka ga yaawúuꞌcaa, ɓuwaa gëm iñaa Pool na Sílaas woꞌɗa, ɓa taabukkaɓa. Fodaama ɓan, laakka ɓiGerek ɓigëñ ɓaa niikin Kooh, na ɓeti ɓilëekíꞌ-teek ɓiyewin ɓaa hay taabukussaɓa. ");
INSERT INTO snf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Waayee kisiis kiyaak ammba yaawúuꞌcaa ɓíinoo, ɓa hídírohha ga wílíilkohcaa ga mbedicaaɗa, ɓa nëgírohha mbooloo wiyaak, ɓa hícísohha teeraa, ɓa íisukka kaan Saasoon kiꞌamnee Pool na Sílaas, ɓa ɓayɓa ga fíkíi ɓu-teeraa. ");
INSERT INTO snf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ɓa hottiiɓa daama, ɓa nammba kiꞌam Saasoon na ɓimbok-kerceen ɓiliis, ɓayussaɓa ga attiꞌohcaa ga teeraaɗa, ɓa ɓaa fiip an: - Ɓuwaama hícísohuunun ëldúna tóohwa ee diima nak ɓa leꞌin dii. ");
INSERT INTO snf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Saasoon ɗapinɓa ga kaanci. Ɓa ɓéeɓɓa nak, ɓa tumi iñcii saafaadukoh na iñii buuꞌ Sesaaꞌ nakohɗa ee ɓa woꞌ an laakin buuꞌ yiliis yaa teeku Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Woꞌeencaama púdíꞌta faancaa ɓuwaa na caa attiꞌohcaa ga teeraaɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Saasoon, ya na ɓuwaa ɓaysee nariɗa, ɓa tíkussa kifay kopaꞌ doonaa ɓaa han kiꞌíisu. ");
INSERT INTO snf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Daa wekaa leꞌee, mbok-kerceencaa amɗohha Pool na Sílaas, ɓa kaꞌ teeraa Beree. Ga waa ɓa leꞌ teeraa Bereeɗa, ɓa kaꞌta jaangu-yaawúuraa. ");
INSERT INTO snf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yaawúuꞌcaa ga teeraa Bereeɗa wëñussa ɓaa ga teeraa Tesaloníkɗa kiwaaꞌ ɓoꞌ. Ɓa safaꞌta ga kiteꞌ Woꞌeenaa Kooh ga keeñɓa, ee besaa en ɓéeɓ ɓa jagi Bíncaa ciselaꞌíꞌcaa kiheel kiꞌínoh ati iñaa Pool jëgírohɗa taabin naca. ");
INSERT INTO snf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɓoꞌ ɓiyewin gaɓa gëmussa ga Yéesu, ee ga Gerekcaa laakka ɓeti ɓilëekíꞌ-teek ɓiyewin na ƴaal ɓiyewin ɓan ɓaa gëm ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Daa yaawúuꞌcaa Tesaloník kelohsee an Pool yaa yéegaloh Woꞌeenii Kooh ga teeraa Beree, ɓa kaꞌta daama ɓan, ɓa aawwa kiheel coow na kihícisoh helcaa ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ɓuwaa gëm ga Yéesuɗa gaawussa kiɓay Pool giiyaa, ya aas gaal-giiƴ daama, ya ƴeeꞌ. Sílaas na Tímotée nak tesussa ga Beree. ");
INSERT INTO snf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓuwaa naksee kiɓay Poolɗa ɓedussari bi ga Ateen, lëehíꞌta ɓaa ɓoyuk Beree. Pool ɓëyrohhaɓa kiwoꞌ Sílaas na Tímotée, ɓa dawukki ga iñaa wëñ kigaaw. ");
INSERT INTO snf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ga waa Pool en na kisek Sílaas na Tímotée ga teeraa Ateenɗa, keeñci leehha ga daa ya hot dëkaa líifin na nataalcaa ɓa tík koohɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ya kaꞌta jaangu-yaawúuraa, ya yaa saawal na yaawúuꞌcaa na ɓuwaa ɓíinoo enussii ɓiyaawúuꞌ, ee niikuunun Koohɗa. Ee besaa en ɓéeɓ, ya yaa saawal na ɓuwaa ya hídohi naɓa ga paanaa dëkaa. ");
INSERT INTO snf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Laakeera daama ɓijëgíroh ɓaa woꞌu ɓiꞌÉpíkuriyeŋ na ɓiꞌEstóyísiyeŋ, ɓaa daanee kisaawal na Pool. Ɓii woꞌee an: - Moo jawulii yii, ya waaꞌ ya kiwoꞌ? Ɓíinoo an: - Man na ya en na kiyéegaloh koohcaa ɗú ínohoo! En kiꞌenaa, Pool yéegalohee loo Hewhewii woꞌ ga loo Yéesu na loo kimílískaa ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Waa ennda ɗa, ɓa taammba nari, ɓa ɓayyari ga paanaagaɓa woꞌsi Ayeropaasɗa, ɓa woꞌꞌari an: - Ɗí waaꞌ fu woꞌꞌíi iñaa leeꞌ ga iñii yiꞌasyii fu jëgírohɗa, ");
INSERT INTO snf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ndaga fu tangalinndíi na woꞌeencaa ken ínohoo, ee ɗí waaꞌ kiꞌínoh iñii ca woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","En kiꞌenaa, ɓu-Ateen na sagaccaa dëku teeraaɗa tumsee rek lëgëy kisúkúruk na kiɓéestíꞌ hewhew. ");
INSERT INTO snf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pool nak dalla kituuk ga fíkíi ɓuwaa enee ga paanaa Ayeropaas, woꞌꞌa an: - Ɗú, ɓu-Ateen, mi hotin an en ngëmaa ɗú laakinwa lool sah. ");
INSERT INTO snf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","En kiꞌenaa, wii mi tíidísuk ga teeriigarúu, mi yaa malaksukoh iñcii ɗú jaamukiɗa, mi hotin wíinoo gaca waa bídu an: «wuu Koohyii ɗí ínohooɗa.» Iñaa ɗú jaamuki yaama ee ɗú ínohooriɗa, yërí mi hayyúu kiyéegal. ");
INSERT INTO snf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kooh yii sak ëldúnaɗa na ɓéeɓ iñcii gaɗa, yii en Haꞌmudii asamaanii na kakayfiiɗa, dëkoo ga kaanfaa yah ɓoꞌ-súusúus hëwíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ya soolukkii ɓan ɓoꞌ-súusúus tumiꞌti yen. En kiꞌenaa, yërí oni ɓéeɓ ɓuwii kumuun, kiꞌíik na ɓéeɓ iñcaa tík gaɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ya kooroh ga ɓoꞌ yíinoo, ya sakka ɓéeɓ heetcii, ya onndaɓa kidëk daa en ɓéeɓ ga ëldúna, ya hëgísohiꞌtaɓa jamaanucii laakiɗa, ya fíisiꞌtaɓa tekiꞌtii dii ɓa jom kidëkohɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ya tummba iñaama, doonaa fodii ɓaa en na kisëmëemíꞌ, ɓuwii aawwi kiheel kihot; ee en kiꞌenaa, ya úsaayyii yíinoo garuu. ");
INSERT INTO snf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","En kiꞌenaa, yërí onnduu kipes, kikaꞌ, na kihay na kiꞌen ga ëldúna, ee bídohciigaruu woꞌuunun an ɗu ɓitowuci ɓan ");
INSERT INTO snf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kon, waa ɗu ɓërí en towutiigari, ɗu jomoo kifooŋ an Kooh man na nataal wúrúus, wuhëelís, wala atoh, waa ɓoꞌ-súusúus pes bi morin ga kineɓ helci. ");
INSERT INTO snf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kooh malakissii kiñak kiꞌínohkaa ɓuwii kuɗewaa. Diimaɗa ɓaa en ɓéeɓ daa ya enoh tóoh ya yii ɓayyi, ya súpít kipeskaagari. ");
INSERT INTO snf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","En kiꞌenaa, ya abin bes, waa ya ƴah kiꞌattiꞌ ɓéeɓ ɓu-ëldúna ee kooran waas. Ya tanukin ɓaa ƴah kiꞌattiꞌɗa. Iñaama ya teewinwa ɓéeɓ ga waa ya mílísiꞌ ɓaa yaama ga kikaanɗa. ");
INSERT INTO snf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Daa ɓa kelohee Pool meƴdohha ga kúuwci loo kimílís ga kikaan, ɓa aawwari kiñaawal. Ɓíinoo woꞌussari an: - Bes kiliisaa, ɗí súkúrukkaa ga iñum fu woꞌ yuma. ");
INSERT INTO snf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Waa ennda ɗa, Pool meƴca yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Moona, laakka gaɓa ɓuwaa gëm iñaa ya woꞌɗa, ɓa taabukkari: ennda fodii Dëníis yaa bokee ga ɓu-paanaa woꞌsi Ayeropaasɗa na ɓetifaa teeku Damaríis na ɓiɓoꞌ ɓiliis ɓaa taabee naɓa. ");
INSERT INTO snf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Waa ennda ɗa, Pool kolukohha teeraa Ateen, ya kaꞌta teeraa Korenti. ");
INSERT INTO snf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ya hídohha daama na yaawúuꞌ, yaa teeku Akílaas. Akílaas límohu gohaa Pom ee lak ya hanee kimeyoh kúlkaa Ítalíi, ya na Pírísíl, ɓetici, ndaga Kólóot buuraa yiyaakyaa kúlkaa Room yërí nakohee an yaawúuꞌcaa ɓéeɓɓa meyat teeraa Room. ");
INSERT INTO snf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pool nak kaꞌta gaɓa, ee waa ya bok naɓa lëgëy kihëwíꞌ mbaaꞌ-on, ya dëkka naɓa, ɓa taammba kilëgëy. ");
INSERT INTO snf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bes Sabataa en ɓéeɓ Pool kaꞌ jaangu-yaawúuraa ya jangati, kiheel kinook yaawúuꞌcaa na ɓuwaa enussii yaawúuꞌɗa ga ngëmaa. ");
INSERT INTO snf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sílaas na Tímotée meyohussa teeraa Maseduwaan, ɓa hayya, laakussa Pool teeraa Korenti. Pool nak ëewrukka kiima ga kiyéegaloh woꞌeenii Kooh, ya yaa yéegal yaawúuꞌcaa an kayoh-kayohɗa, Yéesu yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yaawúuꞌcaa nak ɓaa heñohhi, ɓa aawwari kiɓas, Pool përtukka pëndëlaa kúltícaagari, ya woꞌꞌaɓa an: - Binaa ɗú saŋkuꞌaa, ínohat an ɗú ɓërí tík haffúuka. Mi, mi setin ga wic. Diimaɗa mi yii ƴah ga ɓuwaa enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ya kolkohha daama, ya kaꞌta kaan Títíyus Yustus, ɓoꞌ yiniikiꞌ-Kooh ee kaanfaagari deeyoh na jaangu-yaawúuraa. ");
INSERT INTO snf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kíríspus yaa kuliyuk ga jaangu-yaawúuraaɗa, gëmmba ga Haꞌmudii, ya na ɓu-kaanci ɓéeɓɓa, na ɓiɓoꞌ ɓiyewin ga ɓu-teeraa Korenti, ɓaa súkúrukee Poolɗa, gëmussa ga Yéesu ɓan, ɓa bëtísiꞌussa. ");
INSERT INTO snf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Laakka wekaa Haꞌmudii feeñuk Pool ga ɗuuƴ heeƴ, woꞌꞌari an: - Ka niik dara, woꞌa, kaa ɗekoh. ");
INSERT INTO snf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kaa niik dara ndaga mi yii naraa, ee ken mínoo kitík yahci ga ɗookfu. En kiꞌenaa, ɓoꞌ ɓiyewin dii ga teerii wii ɓuuroo. ");
INSERT INTO snf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Waa ennda ɗa, Pool yuŋnga ga teeraa Korenti kíis na caban, ya yaa jëgíroh Woꞌeenii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ga jamaanaa Galíyoŋ enoh gúwernëeꞌ ga gohaa Akayɗa, yaawúuꞌcaa ɓéeɓɓa kolukɗussa Pool, ɓa ammbari, ɓa ɓayyari daa attiꞌohsiɗa. ");
INSERT INTO snf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Daama, ɓa yammbari an: - Ɓii yii heel kiꞌek ɓuwii ga kijaamuk Kooh na kitaabuk Kooh ee iñii ya jëgírohɗa taammbii na iñii Waasii Móyíis nakohɗa. ");
INSERT INTO snf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pool waaꞌta kitaas, wayee Galíyoŋ dalla kiwoꞌ yaawúuꞌcaa an: - Súkúꞌkattoo ɗú yaawúuꞌcii! Enee an ya tum kofeel wala iñaa boninaa, eneenaa mi hayyúu kisúkúruk. ");
INSERT INTO snf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Waa ɗú nookoh loo woꞌeen, loo teek na loo waasumgarúu, gaama guurúu, mi ƴahhii ga kiꞌaas. ");
INSERT INTO snf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Waa ennda ɗa, ya meƴdohhaɓa daa attiꞌohsiɗa. ");
INSERT INTO snf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Daama nak, ɓa keennda ga ɗook Sosten, yaa kuliyuk ga jaangu-yaawúuraaɗa, ɓa ɓaa feekki ga fíkíi daa attiꞌohsiɗa, wayee iñaama dara ɓíttii Galíyoŋ ga. ");
INSERT INTO snf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Waa ennda ɗa, Pool tessa ga teeraa Korenti iñaa maañ. Lëehíꞌta, ya taŋkohha na kerceencaa daamaɗa, ya aassa gaal-giiƴ kiƴah kúlkaa Síríi, ya taammba na Pírísíl na Akílaas. Balaa ya karaa, ya nenukka hafaagari ga teeraa Keŋkeree ndaga lak iñaa ya dígohee na Kooh ya waatukkaɗa leehin. ");
INSERT INTO snf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ga waa ɓa leꞌ teeraa Efeesɗa, Pool tagohha na ɓuwaa ya taabee naɓaɗa, ya taammba haŋci. Ya kaꞌta jaangu-yaawúuraa kisaawal na yaawúuꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓaama kíimmbari kites naɓa wayee ya saŋnga. ");
INSERT INTO snf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ga wii ya taŋkoh naɓaɗa, ya woꞌꞌaɓa an: - Neɓ Koohaa, mi hay kiɓoyuk dii kiwaakneerúu. Ya aassa gaal-giiƴ ga Efees, ya kaꞌta teeraa Sesaree. ");
INSERT INTO snf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Waa ennda ɗa, ya paaffa Yéerúsaleem kikëñíꞌ kerceencaa enu daamaɗa, lëehíꞌta ya kaꞌta Añcoos Síríi. ");
INSERT INTO snf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ya ennda daama bi sammba kimaañ, lëehíꞌta yaa ƴah. Ya koorohha gohaa Galaat ya paaffa waa Fírígíi, ya yaa daas mbok-kerceencaa ɓéeɓɓa, ngëmaagaɓa wëñ kiyëgís. ");
INSERT INTO snf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Laakka yaawúuꞌ yaa teeku Apoloos ee límohu teeraa Aleksandarí, ya hayya teeraa Efees. Ya enee ɓoꞌ yiyúudúkíꞌ ee ya ínoheera Bíncaa ciselaꞌíꞌcaa dijófíꞌ ɓan. ");
INSERT INTO snf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ya jëgíꞌseera Waasii Haꞌmudii, ee ya safareera lool ga kiwoꞌ loo Yéesu. Iñaa ya jëgírohee gariɗa júweera lool, wayee ya ínohee bëtísaa Saŋ-Bëtís. ");
INSERT INTO snf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ya yaa jangat na fít wiyëgísíꞌ ga ɗuuƴ jaangu-yaawúuraa. Daa Pírísíl na Akílaas kelohsee iñaa ya jangatɗa, ɓa ɓayyari ya taam naɓa, ɓa lóogísohiꞌtari Waasii Kooh bi wëñnja gari kileeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ya nak, helci ennda ga kikaꞌ gohaa Akay. Mbok kerceencaa daamaɗa ɓaatussari kidaas ga iñaama. Ɓa bínnda ɓuwaa gëm ga Yéesu enu daamaɗa këyít kiwoꞌɓa ɓa ammbi dijófíꞌ. Daa ya leꞌee daama, Kooh amɗohhari bi ya laakiꞌta ɓuwaa gëmu ga Yéesu daamaɗa jeriñ wiyaak. ");
INSERT INTO snf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ya ɓúlla yaawúuꞌcaa ga fíkíi ɓéeɓ, ee ya koorohee ga Bíncaa ciselaꞌíꞌcaa, kiteeɓɓa an Yéesu yërí en Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wiima lak Apoloos yaa ga Korenti, Pool koorohha gohcaa kúlkaa na jaŋjaŋcaaɗa, lëehíꞌta ya hayya teeraa Efees. Ya hotta ɓimbok-kerceen daama, meekissaɓa an: ");
INSERT INTO snf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","- Ga wii ɗú gëm ga Yéesuɗa, ɗú laaseera ga Helii yiselaꞌíꞌyiine? Ɓa taassari an: - Ɗí mossii kikeloh woꞌu an Helii yiselaꞌíꞌyii yii ga. ");
INSERT INTO snf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pool meekissaɓa an: - Kon ɗú laas ga bëtísii wiida? Ɓa taassari an: - Ɗí laas ga bëtísaa Saŋ-Bëtís tumeeɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool woꞌꞌaɓa an: - Ee; Saŋ bëtísiꞌee ɓuwaa tookee kisúpít kipeskaagaɓaɗa, ee ya woꞌee ɓu-Isarayeel kigëm ga ɓaa ƴah kihay ga fenoociɗa. Ɓaama nak Yéesu yërí. ");
INSERT INTO snf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ga waa ɓa keloh woꞌeenaamaɗa, ɓa bëtísiꞌukka ga teekii Yéesu, Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pool tíkkaɓa yah ga haf ee Helii yiselaꞌíꞌyii dalla kiyoosuk ga ɗookɓa. Ɓa ɓaa woꞌ ga lak ciyewin caa bokkii, ɓa ɓaa jangat woꞌeencaa meyoh ga Kooh. ");
INSERT INTO snf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ɓuwaa enee daamaɗa jomeera kileꞌ ɓoꞌ ɓidaaŋkaah na ɓanak. ");
INSERT INTO snf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Waa ennda ɗa, Pool kaꞌta jaangu-yaawúuraa, ee daama iñaa leꞌ ñiin kaahay ya yaa jangat na fít wiyëgísíꞌ, ya woꞌee loo Nguurii Kooh, ya yaa heel kigëmlukoh ɓuwaa súkúrukeeriɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wayee laakka gaɓa ɓaa yëgís ga haf, ɓa saŋnga kigëm, ɓaa ñaawal Waasii Haꞌmudii ga fíkíi ɓuwaa ɓéeɓɓa. Waa ennda ɗa, Pool foñnjaɓa, ya ɓayya tëelíbéecaa Yéesu, ee besaa en ɓéeɓ, ya yaa jëgíꞌɓa ga ekoolaa ɓaa woꞌsi Tíranusɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pool jëgírohha da bi ennda tíkíis tanak ee fodaama ɓéeɓ ɓuwaa dëk gohaa Aasíiɗa, ennda yaawúuꞌcaa, ennda ɓuwaa enussii yaawúuꞌɗa kelohussa Woꞌeenii Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Waa ennda ɗa, Kooh yaa tum kíntaan cidóoyíꞌ-waaꞌ ga Efees koorohha ga Pool. ");
INSERT INTO snf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Fodaama ɓuwaa ɓaa ɓeɓ gúree-píis wala úuf, caa mosin kileꞌ ga faanfaa Pool, ɓa ɓaa tíkca ga ɗúukoolíꞌcaa. Ee fodaama ɓuwaa ɓaa wak, raɓcaa ɓaa meyoh gaɓa. ");
INSERT INTO snf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Laakeera yaawúuꞌcaa enee kiwíil daa en ɓéeɓ kikaal raɓ ga ɓuwaa. Fodaama, ɓa jéemmba kikooroh teekaa Yéesu, ɓa kíimiꞌ ɓuwaa raɓ amɗa. Ɓa woꞌee raɓcaa an: - Ga teekii Yéesu Pool yéegalohɗa, mi ebillúu kimeyoh ga ɓii! ");
INSERT INTO snf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iñaama, ɓaa woꞌsi Sefaa ee bokee ga sarahohcaa yaawúuꞌcaa ɓiyaakɓaaɗa, towutaagari tiyitnatanaktaa daanseeraka kitum. ");
INSERT INTO snf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wayee, ga waa ɓa tummbaka, rawaa taassaɓa an: - Mi ínohin Yéesu mi ínohin ɓaa en Poolɗa, Wayee ɗú, ɗú ɓërí en ɓa? ");
INSERT INTO snf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɓaa rawaa abeeɗa dallaɓa kisooŋ, wëñnjaɓa dooli, gaañsohhaɓa, ɗaꞌsohha kúltícaagaɓa, ɓa meƴca kaanfaa, ɓa núppa. ");
INSERT INTO snf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɓu-teeraa Efees ɓéeɓɓa yéegussa iñaa laak yaama. Yaawúuꞌcaa na ɓuwaa enussii yaawúuꞌɗa, ɓéeɓɓa tíitussa, teekaa Yéesu, Haꞌmudii erussa céeꞌ wimëtíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ɓiyewin ga ɓuwaa gëmɗa hayussa, woꞌussa faŋ ga fíkíi ɓéeɓ iñcaa ɓa enukoheeɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ɓiyewin ga ɓuwaa daanee kiluhusɗa, haydohussa këyítcaa ɓa luhusoheeɗa, ɓa nëgírohhaca jal wíinoo, ɓa tëkíꞌtaca ga fíkíi ɓéeɓ. Cadamfaa këyítcaama karin ga júnnicaa leehoo. ");
INSERT INTO snf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Fodaama, ga doolaa Haꞌmudii, woꞌeenaa Kooh waa wëñ kisíw ee doolaagawa waa wëñ kihotuk. ");
INSERT INTO snf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ga waa iñcaama paafɗa, Pool ammba ga helci kikaꞌ Yéerúsaleem, ya kooroh gohaa Maseduwaan na waa Akay. Ya woꞌee ga helci an binaa mi leꞌ daamanaa, mi jomin kikaꞌ Room ɓan. ");
INSERT INTO snf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ya wossa ɓanak ga ɓuwaa ya taabi naɓaɗa. Ɓuwaa ensee Tímotée na Erasti. Ya ga kihafci nak, ya tessa ga gohaa Aasíi bi sammba kimaañ. ");
INSERT INTO snf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jamaanaama, coow wiyaak kolukka ga Efees ndaga Waasii Haꞌmudii yéegalohu daamaɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Laakee tíwoh hëelísaa teeku Dímitiriyus, ya tíwee tunataal-hëelístaa mandarga kaanfaa ɓa jaamukohi Artémísɗa. Tunataaltaama nak, haydohɗeerari, ya na ɓuwaa lëgëy gariɗa hëelís wiyewin. ");
INSERT INTO snf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Laakka bes, ya hídírohha ɓuwaa lëgëyi gariɗa na ɓoꞌ ɓiliis ɓaa tumi lëgëy kitíɓ nataal fodaa gaɓaɗa, ya woꞌꞌaɓa an: - Ɓiƴaay, ɗú ínohin an iñii ɗú laak ga alalɗa meyoh ga lëgëyiiruu wii. ");
INSERT INTO snf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Diimaɗa nak, ɗú hotin ee ɗú kelohin iñcii Pool en na kitumɗa. Ya woꞌ an koohcaa ɓoꞌ hëwíꞌ na yahci enndii Kooh kayoh-kayoh. Ya nookin ɓoꞌ ɓiyewin ga kigëm iñaama, ee ya eemmbii naka dii ga Efees, wayee gohaa Aasíi ɓéeɓ gomin ga. ");
INSERT INTO snf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iñaama eemanndii ga kiɓúuk kitíɓ-nataalkiiruu rek, wayee mín kikaꞌ bi ga kiɓúuk teekii kaanfii Artémís, koohyii yiɓetiyii yiyaakyii. Ee koohyii yiima Aasíi ɓéeɓ na tóoh ëldúna jaamukiri. Kon nak teekiigari jomoo ɗa kiƴím. ");
INSERT INTO snf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Daa ɓuwaa kelohee woꞌeencaama, ɓa líiffa na tam-keeñ, ɓa ɓaa fiip an: - Artémísyii ɓu-Efees yakin! ");
INSERT INTO snf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Díkaantaama ɓéeɓ dëkaa hícísukohha. Ɓa ammba Gayus na Arístarka ɓaa dëk Maseduwaan ee taamsee na Poolɗa, ɓa ɓaa ƴah naɓa paanaa ɓu-teeraa. ");
INSERT INTO snf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool nak waaꞌta kimeƴ ga ɓuwaa, wayee ɓuwaa gëm ga Yéesuɗa íisussiiri ya kaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bi ga sah ɓiɓoꞌ ga fiiliimuncaagari kuliyuk ga nguuraa ga gohaa Aasíiɗa, wosohussa gari kiwoꞌꞌi ya watuk kitoŋ kotci ga paanaa ɓu-teeraa. ");
INSERT INTO snf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ga wahtaama, ɓuwaa hídírukohee daamaɗa hícísukohussa, coowaa ennda cúr ga ɗuuƴɓa. Ɓii fiipi aneenaa, ɓii fiipi an. Ɓiyewin gaɓa sah ínohséeríi iñaa tah ɓuwaa hídírukoh daamaɗa. ");
INSERT INTO snf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ëlíksaan nak, yërí yaawúuꞌcaa kuliyukɗee ga fíkíiɓa ga hídohaama. Ɓiɓoꞌ ga ɓuwaa hídírukohee daamaɗa ɓéestírussari iñaa laakɗa. Ya ɓëwíꞌta yah kiwaaꞌ kilayohiꞌ ɓuwaama ga fíkíi mbooloomaa. ");
INSERT INTO snf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wayee daa ɓa ínohee an ya iñaa yaawúuꞌ, ɓa taammba ɓéeɓɓa ɓa aawissa kifiip. Ɓa fiipin iñaa leꞌ wahtu kanak an: - Artémísyii ɓu-Efees yakin! ");
INSERT INTO snf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ɓaa dëkaa tíku ga yahciɗa yërí mëeñjoh kimín kiƴím ɓuwaa doo ɓa han kiɗekoh. Ya woꞌꞌaɓa an: - Ɗú ɓu-Efees, ɓii yiida ínohoo an kaanfii Artémís yiyaakyii en ga teeriigaruu ee nataaliigari keenoh asamaanɗa en ɓan ga teeriigaruu? ");
INSERT INTO snf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɗú ínohin an ken nookohhii iñaama. Kon enat tek, ee kaa gaawtukat bi ɗú tum iñaa bokkii ga. ");
INSERT INTO snf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɓuwii ɓii ɗú haydohinɓa dii ee moona ɓa ɓeɓpii dara ga kaanfii Artémís, ee ɓa ɓassiiri. ");
INSERT INTO snf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","En Dímitiriyus na ɓuwii taam nariɗa, ɓa laakoh na ɓoꞌaa, ɓa karat waas: Laakin bescaa tanu kiꞌatti, na ɓuwaa attiꞌi iñcaama. ");
INSERT INTO snf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","En laak enaama ciliis caa ɗú waaꞌ kipaƴɗunaa, bes kiꞌattiꞌ leꞌaa, ca malaku. ");
INSERT INTO snf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ɗu watukkiinaa, ɗu hay kitíku ɓuwaa hícísohi mbooloo ndaga iñii laak watiɗa, ee ɗu mínanndii dara kiwoꞌ ga iñaa tah coowii wii. Ga waa ya lëehíꞌta kiwoꞌ fodaama, ya wesohha ɓuwaa. ");
INSERT INTO snf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ga waa coowaa enee ga Efees seemɗa, Pool hídírohha ɓuwaa gëm ga Yéesuɗa, ya ɓaattaɓa kidaas ga ngëmaa, lëehíꞌta ya taŋkohha naɓa, yaa ƴah Maseduwaan. ");
INSERT INTO snf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ya taammba gohaama, ya daassa ɓuwaa gëm ga Yéesuɗa ga ngëmaa. ");
INSERT INTO snf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ya kolkohha daama, ya kaꞌta kúlkaa Geres, ya tummba daama ñiin kaahay. Ga waa ya ɓewuk kikaꞌ kúlkaa Síríiɗa, ya kelohha an yaawúuꞌcaa pokohuunun nof kiꞌappi, ya nammba ɓoyuk hen, ya koorohha Maseduwaan. ");
INSERT INTO snf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ɓuwaa taabee nariɗa ensee Sopateeꞌ, kowukaa Pírus ee ya meyohee Beree, Arístarka na Sokondus ɓaa meyoh Tesaloníkɗa, Gayus yaa meyoh Derbeɗa, Tímotée, Tísík na Torofím ɓaa meyohee gohaa Aasíiɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓa ɗëwírukka, ɓa sekneeraríi ga teeraa Torowaas. ");
INSERT INTO snf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ɗí nak, ga waa hewaa mbúurúcaa tumoo lëwíiꞌ paafɗa, ɗí aasohneera gaal-giiƴ teeraa Filiip, ɗí foolla ga giiƴ bes ciyëtúus, ɗí laakneeraɓa teeraa Torowaas. Ɗí tummba daama bes ciyitnakanak. ");
INSERT INTO snf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ga noh-soosaa gaawaa, ɗí hídírukohha kiñam cuuníinfaa Haꞌmudii. Pool nak jomee kikolukoh daama ga kooh-wíisfaa. Ya aawwa kijëgíꞌ ɓuwaa gëm ga Yéesuɗa, ya ammba kiwoꞌ na ɓuwaa bi ga leeloo wek. ");
INSERT INTO snf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ɗí hídírukohee ga túuyaa hanoh ɗook ga taahaaɗa, ɗí taalla lampu ciyewin. ");
INSERT INTO snf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Laakka oomaa-ƴaalaa teeku Etíkus ee ya yugee ga kímícaa falanteeraa. Ya kaꞌta hëndëŋ na pëní, wiima lak Pool yii lís kiwoꞌ. Ga ɗuuƴ pënífaa, ya dalla rëc, ɗëegískoh ɗook taahaa wukaahaywaa ɓa eneeɗa, ya keennda kakay. Ya ɓëwíru hen, lak kaanin. ");
INSERT INTO snf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pool yoosukka, híilla gari, ɓeɓpari, woꞌꞌa an: - Kaa jaahliꞌat, ya yii pes! ");
INSERT INTO snf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Waa ennda ɗa Pool lapissa, ya warohha mbúuraa, ñammba. Lëehíꞌta, ya aawissa kijangat bi ga daa Kooh wíisɗa, ya taŋkohha naɓa, yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Oomaa-ƴaalaa nak ɓedussa kaanɓa lak wíisohin weceŋ ee helcaa ɓuwaa dalla gari lool. ");
INSERT INTO snf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɗí nak, ɗí aassa gaal-giiƴ, ɗí ɗëwírukka Pool teeraa Asos, ya woꞌee an ɗí kihídohan nari daama, ɗí ɓaydohhi ndaga ya waaree kitíin hen bi daama. ");
INSERT INTO snf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ga waa ya laakkíi teeraa Asosɗa, ɗí aassa gaal-giiƴ daama, ɗí ɓaa ƴah bi ɗí leꞌꞌa teeraa Mítíleen. ");
INSERT INTO snf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ɗí ɓaa ƴahis bi ɗí laŋnga na Síyóo ga kooh-wíisfaa. Ga besaa tík gaɗa, ɗí leꞌꞌa Samoos, ee besaa tíkis gaɗa, ɗí leꞌꞌa teeraa Mílée. ");
INSERT INTO snf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pool abee an ya ƴah kiroombuk Efees hen, ya tuukoo da, en ɗanaa ya maañoo ga gohaa Aasíi ndaga ya gaawtukee kitum tóoh, en mínukaa, ya leꞌ Yéerúsaleem balaa besaa Pantakot. ");
INSERT INTO snf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ga waa ɗí teeꞌ ga Míléeɗa, Pool wosohha kiɓayluk ɓuwaa kuliyuk ga jaangaa Yéesu ga Efeesɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɓaama hayussari kitaas, ya woꞌꞌaɓa an: - Ɗú ínohin dijófíꞌ daa mi madee narúu ga wii mi en narúu, aboh ga besaa mi ɗeɓ kitoŋ kottoo ga gohii Aasíiɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi jaamukee Haꞌmudii hen taammba na kiyóoskíꞌ haffoo, taammba na kiꞌaam moon, mi daƴca ɓan coonu, caa yaawúuꞌcaa pokoheeroo nofɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mi ínohin an mi mossoorúu kiɗaak dara iñaa míninndúu kijeriñ. Mi yéegaleerúu woꞌeenii Kooh, mi jëgíꞌtarúu ga fíkíi ɓéeɓ na ga ɗuuƴ kaancii. ");
INSERT INTO snf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi mosoo kiꞌíis kiɓay yaawúuꞌcii na ɓéeɓ ɓuwii enussii yaawúuꞌɗa ɓa súpít kipesɓa, ɓa gëm ga Kooh, ɓa gëm ga Yéesu, Haꞌmudiigaruu. ");
INSERT INTO snf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Diimaɗa nak, mi yii ƴah Yéerúsaleem, Helii yiselaꞌíꞌyii yërí híiꞌtoo ga ee mi ínohoo iñaa sekkoo daɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wayee mi ínohin daal an teeraa mi aas tóoh Helii yiselaꞌíꞌyii yéegalloo an kasu na coonu caa sekkoo. ");
INSERT INTO snf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mi nak, en kipeskiigoonaa mi ɓítukkii gaka ee mi tíkkiika iñaa yakin. Lebiriigoo tóoh, wërí en kileꞌ ga dii mi aawɗa, mi mëtíꞌ sasii Yéesu, Haꞌmudii nakkooɗa, ee wërí en kiyéegaloh Hewhewii winéwíꞌwii haydoh yërmaandii Kooh laak garuuɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Diimaɗa nak, mi ínohin an ɗú ƴahissiiroo kihotis. Mi koorin garúu ɓéeɓpúu, mi yaa jangattúu loo Nguurii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kërí tah mi woꞌꞌúuka wati: ɓaa fu saŋkuꞌaa, ínohaa an fu yërí tík haffuka. ");
INSERT INTO snf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","En kiꞌenaa, mi yéegalinndúu ɓéeɓ iñaa Kooh sek garuuɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kon watukat haffúu dijófíꞌ, ɗú watuk ɓan yopii Helii yiselaꞌíꞌyii díŋkaanndúu kiníiꞌɗa. Fodii ɓiníiroh, toputuꞌat jaangii Kooh laakiꞌ hafci, koorohha ga kikaankaa Kowukaagariɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mi ínohin an mi kolukoh diinaa, hay kilaak ɓuwaa madu na gumuucaa yaawuunun, ɓa aas ga ɗuuƴcúu kitasaaroh yopii Kooh. ");
INSERT INTO snf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hay kilaak ɓuwaa boku garúu ɓa koluk, ɓa aaw kijëgíroh saboh kesi, kiheel ɓuwaa taabukanɓa. ");
INSERT INTO snf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kon watukat, ɗú níindísuk an tíkíis taahay tee, taa wekoo, nohoo mi ñari yaa en ɓéeɓ garúu bi kiꞌaam moon sah maasiroo ga. ");
INSERT INTO snf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Diimaɗa mi tíkinndúu ga yah Kooh, ya, na Woꞌeeniigari barkeellúu; yërí laak doolaa onannduu kiyëgís ga ngëmii ee ya onndúu kilam iñcii ya faaniꞌ ɓan ɓuwiigariɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi mosoo kiɗíibuk kilaak hëelís, wúrúus wala kúltí ken. ");
INSERT INTO snf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ɗú ga kihaffúu, ɗú ínohin an yahciigoo cërí onndoo kipaƴ sooliciigoo na cii ɓuwii taabi narooɗa. ");
INSERT INTO snf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi teewinndúu ga tóoh an ɗu jom kilëgëy fodaama kidímal ɓuwii laakooɗa. Ɗu níindísukat iñaa Yéesu, Haꞌmudii ga kihafci woꞌeeɗa an: «Keeñ wëñi kisoos ga kiꞌonoh loo kiteꞌ.» ");
INSERT INTO snf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ga waa Pool woꞌꞌa fodaama bi ya lëehíꞌta, ya ƴíꞌꞌa naɓa ɓéeɓɓa, ya kíimmba Kooh. ");
INSERT INTO snf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Waa ennda ɗa, ɓéeɓɓa ɓaa koduk, ɓa gatawukkari, ɓaa fuunndi. ");
INSERT INTO snf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Iñaa tahee keeñɓa kileehɗa wërí en daa Pool woꞌɓa an ɓa hotsanndiiriɗa. Lëehíꞌta, ɓa ɓedohha naríi bi ga gaal-giiyaa. ");
INSERT INTO snf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ɗí tagohha na ɓuwaa ɓedohee naríiɗa, ɗí aassa gaal-giiƴ, ɗí yolohha Koos, dëkaa giiyaa wíilɗa. Ga kooh-wíisfaa, ɗí kaꞌta gohaa Root, ɗí meyohha daama, ɗí kaꞌta teeraa Pataraa. ");
INSERT INTO snf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Daama ɗí hotta gaal-giiƴ waa aaw gohaa Fenísíi, ɗí aassa ga, ɗí ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ga waa ɗí kaꞌ bi ɗí séennda Sípaꞌɗa, ɗí koorohhawa yah-ñaam, ɗí ëewrukka ɓak gohaa Síríi. Ɗí teeꞌta ga Tíiꞌ ndaga gaalaa jomee kiyóoskíꞌ sëfaa wa ɓayeeɗa daama. ");
INSERT INTO snf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ɗí hotta daama ɓitëelíbée Yéesu, ɗí ennda naɓa bes ciyitnakanak. Helii yiselaꞌíꞌyii yéegallaɓa iñaa ƴah kihewɗa. Ɓa woꞌꞌa Pool an ya hanat kikaꞌ Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ga waa bescaa ciyitnakanakcaa matɗa, ɗí kolukissa kiƴah. Ɓuwaama ɓéeɓɓa ɓedussaríi, ɓa na ɓeticaagaɓa na towutaagaɓa bi ɗí meƴca teeraa. Daama ɗí ƴíꞌꞌa ɓéeɓpíi ga seereenaa giiyaa, ɗí kíimmba Kooh. ");
INSERT INTO snf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Lëehíꞌta, ɓéeɓpíi ɗí taŋkohha, ɗí nak, ɗí aassa ga gaal-giiyaa, ɓa, ɓa ɓaa ɓoyuk kaanɓa. ");
INSERT INTO snf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ɗí kolkohha Tíiꞌ, ɗí lëstíꞌta ɓaawaagaríi ɗí kooroh giiƴɗa ga waa ɗí leꞌ Potolemayís. Ɓuwaa enu ga teeraama gëmu ga Yéesuɗa ɗí kaꞌtaɓa kikëñíꞌnee. Ɗí hoowukka, ɗí neehha. ");
INSERT INTO snf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ga kooh-wíisfaa, ɗí kolkohha daama, ɗí kaꞌta teeraa Sesaree. Ga waa ɗí leꞌꞌa, ɗí kaꞌta kaan Filiip, ɗí dalla daama. Filiip nak enee ɓaa yéegalohi Hewhewii winéwíꞌwii ee ya bokee ga ɓuwaa ɓiyitnaɓanakɓaa tansee ga Yéerúsaleemɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ya laakeera towu tinikiis tiɓeti, taa onohussii kipañ ee Kooh oneeraɓa kiyéegaloh woꞌeenaa meyoh gari. ");
INSERT INTO snf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Lak ɗí enin daama bes ciyewin, Laakka sëldíiga-Koohaa teeku Agabus meyoh kúlkaa Yúudée. ");
INSERT INTO snf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ya hayya garíi daa ɗí eneeɗa, ya ɓeɓpa iñaa Pool pëkíruki ga kenohciɗa, ya pokukka kotcaa na yahcaa, woꞌꞌa an: - Iñii yii yërí Helii yiselaꞌíꞌyii woꞌ: «Ɓii laak pëkírukaahii-wiiɗa, yaawúuꞌcaa ga Yéerúsaleemɗa hayyi kiɓagu fodii dii, lëehíraa ɓa tíkki ga yah ɓuwaa enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ga waa ɗí keloh iñaamaɗa, ɗí na ɓuwaa enee daamaɗa ɗí sarahtukka Pool ya ool kikaꞌ Yéerúsaleem.» ");
INSERT INTO snf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wayee Pool taassaríi: - Ɗú tum ya yii, ɗú yahi keeñiigoo? Mi saŋngii kiɓagu rek, wayee mi tookin sah bi ga kikaan ga Yéerúsaleem ndaga teekii Yéesu, Haꞌmudii. ");
INSERT INTO snf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Waa ɗí mínndiiri kihoonoh kikaꞌ, ɗí íissari, ɗí woꞌꞌa an: Iñaa Haꞌmudii waaꞌɗa laakat! ");
INSERT INTO snf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɗí ennda daama bi sammba kimaañ, ɗí ɓewukka, ɗí kaꞌta Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Laakka ga tëelíbéecaa Yéesu, ɓaa dëku teeraa Sesaree, ɓa taammba naríi, ɓa ɓayussaríi kaan Monason, yaa ɗí jomee kidal ga kaanciɗa. Monason meyohee Sípaꞌ, ya bokee ga tëelíbéecaa Yéesu ɗeɓɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ga waa ɗí leꞌ Yéerúsaleemɗa, ɓéeɓ ɓuwaa gëm ga Yéesuɗa teerukussaríi na keeñ wisóosíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ga kooh-wíisfaa, Pool taammba naríi kaan Saak ee ɓéeɓ ɓuwaa kuliyuk ga jaangaa Yéerúsaleemɗa hídírukohsee daama ɓan. ");
INSERT INTO snf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pool Këñɗohha naɓa bi lëehíꞌta, ya ɓéestíꞌta wíinoo wíinoo tóoh iñcaa Kooh tum ga ɓuwaa enussii yaawúuꞌ koorohha gariɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Waa ennda ɗa, ɓuwaa súkúrukee Poolɗa ɓaa kañ Kooh. Lëehíꞌta, ɓa ɓaa woꞌ an: - Mbok, fu ínohin an yaawúuꞌ ɓiyewin ga yaawúuꞌcii gëmuunun ga Yéesu ee ɓa lís kiyëgís ga Waasii Móyíis. ");
INSERT INTO snf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓa kelohin an ɓéeɓ yaawúuꞌcii en ga ínɗa, fu jëgíriɓa kifoñ iñcii Waasii Móyíis nakohɗa, kiꞌíis kigúꞌ towutaagaɓa na kiꞌíis kitaabuk baahcii yaawúuꞌcii. ");
INSERT INTO snf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ɗu tuman na ee ɓa hay kiyéeŋ an fu hayin? ");
INSERT INTO snf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kon namaa kitum iñcii ɗí ƴahhaa kiwoꞌɗa. Laakin ga ɗuuƴcíi ɓoꞌ ɓinikiis ɓaa waatukin. ");
INSERT INTO snf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taabaa naɓa, ɗú bok naɓa kisétíꞌsiruk fodii dii Waasii Móyíis nakohkaɗa. Fu fayiꞌɓa iñaa jom kisarahohuɗa tóoh, ɓa nenuk kiteewoh an waataagaɓa leehin. Fodaama, ɓéeɓ hay kiꞌínoh an iñcii fu woꞌɗuɗa dara laakkii ga, ee ɓéeɓɓa ɓa hay kiwoꞌ an fu lís kitaabuk iñcii Waasii Móyíis nakohɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ɓuwaa enussii yaawúuꞌ ee gëmu ga Yéesuɗa ɗí ɓëyrohin gaɓa kiwoꞌɓa iñii ɗí am yii, an ɓa abuk kiñam koynohkaa tumu sarah ga koofcaa, ɓa abuk ɓan ga kiꞌan ñíf, kiñam koynoh júuraa apu ee ñífaa aamussii na kifaanuk na ɓaa en ɓéeɓ. ");
INSERT INTO snf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ga kooh-wíisfaa Pool taammba na ɓuwaa ɓinikiisɓaa, ya bokka naɓa kisétíꞌsiruk, lëehíꞌta ya aassa Kaanfaa Kooh, doonaa ya woꞌ besaa kisétíꞌsirukkaa leehanɗa, ennda fodii wahtaa ɓaa en ɓéeɓ mínan kitumɗu sarahɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lak bescaa ciyitnakanakcaa nakohu kisétíꞌsirukɗa caa ƴah kimat. Laakka yaawúuꞌcaa meyohu gohaa Aasíi, ɓa hayya Yéerúsaleem. Ɓa hotta Pool ga ɗuuƴ Kaanfaa Kooh, ɓa hícísohha ɓuwaa, ɓa ammbari, ");
INSERT INTO snf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ɓa ɓaa fiip an: - Foolat ɓu-Isarayeel! Ɓii jëgírohi daa en ɓéeɓ kiheñoh heetiigaruu, Waasii Móyíis na Kaanfii Kooh fiiɗa, yee! Ya ekin sah ɓuwii enussii yaawúuꞌɗa ga Kaanfii Kooh bi tahin ɗekataa wiselaꞌíꞌwaa kilíiɓ. ");
INSERT INTO snf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ɓa woꞌ iñaamanaa, daa ɓa hotee Pool ga teeraa, taabin na Torofím yaa meyoh teeraa Efeesɗa tah ka. Ɓa foogee nak an Pool ekinndi ga ɗuuƴ Kaanfaa Kooh. ");
INSERT INTO snf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Coowaa ennda cúr ga ɗuuƴ dëkaa, daa en tóoh ɓoꞌ yaa meyoh da. Ɓa ammba Pool, ɓa fassari bi meƴca Kaanfaa Kooh, ga saasi ɓa laŋnga halcaa. ");
INSERT INTO snf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Lak ɓa ɓaa heel kiꞌap Pool, haꞌ-kaadaa soldaaꞌcaa yéegalussa an ɓéeɓ Yéerúsaleem hícísukohin. ");
INSERT INTO snf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ga saasi, ya hídírohha soldaaꞌcaa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa na soldaaꞌcaagaɓa, ya íisukka mbooloomaa. Daa ɓuwaa hotee haꞌ-kaadaa na soldaaꞌcaa taam nariɗa, ɓa íissa kifeek Pool. ");
INSERT INTO snf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Waa ennda ɗa ya deeƴca ga Pool ammbari, ya nakohha kiɓaŋngi na ceen kanak. Lëehíꞌta ya meekisohha ɓaa ya ennda na iñaa ya tumɗa. ");
INSERT INTO snf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wayee ga ɗuuƴ mbooloomaa ɓii fiipi aneenaa, ɓii fiipi an. Faf haꞌ-kaadaa soldaaꞌcaa mínndii kiꞌínoh dara ga iñaa hewɗa ndaga coowaa. Waa ennda ɗa, ya nakohha kiɓay Pool ga ɗuuƴ kaanfaa soldaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ga waa Pool kaꞌ bi ya dalla kilap eskalicaaɗa, soldaaꞌcaa nammbari kiteembeel hen ndaga lak mílti-míltaa hëpin. ");
INSERT INTO snf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","En kiꞌenaa, mbooloomaa wërí taabukee Pool, wa waa fiip an: - Ya kaanat! ");
INSERT INTO snf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ga wahtaa Pool ƴah kiꞌeku ga Kaanfaa soldaaꞌcaaɗa, ya kíimmba haꞌ-kaadaa an: - Mi mínin naraa kiwoꞌ jutuute? Haꞌ-kaadaa taassari an: - Caɓ! Man fu lak kiGerek! ");
INSERT INTO snf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kon fu enndii ɓaa meyohee Esípti yaama hícísohee ɓuwii, ya haydohha coow wiyaak ga dëkii, ya ɓaydohha tumoh-kofeel ɓijúnni-nikiis ga ëgíꞌ-dúndagaane? ");
INSERT INTO snf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool taassari an: - Mi iñii yaawúuꞌ, mi límohu Tarsa, teeru wilëekíꞌ-teek ga gohaa Sílísíi. Mi kíimmbaa fu onndoo kiwoꞌ na ɓuwii. ");
INSERT INTO snf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Haꞌ-kaadaa soldaaꞌcaa onndari. Waa ennda ɗa, Pool tuukka ga eskalicaa, lëríssa mbooloomaa yah, ɓuwaa ennda cew; ya woꞌꞌa naɓa ga kiꞌArameyee an: ");
INSERT INTO snf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","- Ɗú, mbokciigoo, diima súkúrukat mi taassúu ga iñii ɗú yammbooɗa. ");
INSERT INTO snf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Daa ɓa kelohee Pool yaa woꞌ naɓa ga kiꞌArameyee, ɓa wëñnja ɗa kiꞌeen. Pool tíkka ga an: ");
INSERT INTO snf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","- Mi yaawúuꞌ, mi límohu Tarsa ga gohaa Sílísíi, wayee mi korukoh dii ga teerii wii. Gamaliyeel ga kihafci yërí jëgíꞌtoo bi mi ínohha ar waasii ɓicaasammbuu. Mi Safareera lool ga kitaabuk iñaa Kooh nakoh, fodii dii ɗú ɓéeɓpúu ɗú taabukika watiɗa. ");
INSERT INTO snf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ɓuwaa gëmee ga waasii Haꞌmudiiɗa, mi dëkee ga kihatalɓa ga kipes, mi kaꞌta bi mi laŋnga kumuun ga; mi abin ɓiƴaal na ɓiɓeti mi laŋngaɓa ga kasu. ");
INSERT INTO snf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Haꞌ-kaadii sarahohcii na yaakcii dëkii ɓéeɓɓa mínuunun kiseediꞌ an mi woꞌ kayoh. En kiꞌenaa, mi ɓewohee këyítcaa oneeroo kimín kikaꞌ Damaas, mi am yaawúuꞌcaa gëm ga Yéesu enu daamaɗa gaɓa, fodaama mi kaꞌ Damaasaa, mi amɓa, mi haydohɓa dii, ɓa koru. ");
INSERT INTO snf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Pool tíkka ga an: - Lak mi yaa ga waas, bi mi deeyin teeraa Damaas, ga wahtu cuunoh, dalla kilaak leeꞌlaat wiyaak waa meyoh asamaan, wa ennda mareet ga ɗookkoo bi wíillaroo. ");
INSERT INTO snf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi keennda kakay, mi kelohha koonaakaa woꞌ naroo an: «Sóol! Sóol! Iñii tah ya fu hatalloo ga kipes?» ");
INSERT INTO snf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mi meekisohha an: «Kiyaakii, fu yërí en ɓa?» Koonaakaa taassaroo an: «Mi yërí, Yéesu Nasareet, yii fu hatal ga kipesɗa.» ");
INSERT INTO snf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ɓuwaa taamsee narooɗa hotsee ga leeꞌlaataa faŋ, wayee ɓa kelohéeríi ga koonaakaa ɓaa enee naroo kiwoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mi meekisohha an: «Haꞌmudii, mi jom ya kitum?» Haꞌmudii woꞌꞌaroo an: «Koluka fu kaꞌ Damaas, fu leꞌ daamanaa, fu hay kiwoꞌu ɓéeɓ iñaa fu jom kitumɗa.» ");
INSERT INTO snf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mi hotsiséeríi ndaga lak meliclaataa leeꞌlaataa búumɗinndoo. Ɓuwaa mi taabee naɓaɗa abussaroo ga yah, ɓa ɓayyaroo Damaas. ");
INSERT INTO snf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Laakeera ga teeraa Damaas, ɓaa teeku Anañaas ee ya enee ɓoꞌ yigëmíꞌ Kooh. Ya taabukeera iñii Waasii Móyíis nakohɗa ee ɓéeɓ yaawúuꞌcaa ga teeraaɗa oneerari céeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ya hayya garoo, ya deeƴcaroo, woꞌꞌaroo an: «Sóol, mbokiigoo, hotsisa!» Ga saasi tuhastaagoo malakka, mi hottari. ");
INSERT INTO snf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ya tíkka ga an: «Koohyii ɓicaasammbuu tanukinndaa kumëeñíꞌ doonaa fu ínoh iñii ya waaꞌɗa, doonaa fu hot ɓaa en yijúwíꞌyaa ee ya haŋci doŋɗa, fu keloh konaakaagari. ");
INSERT INTO snf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Fu nak, fu yërí ƴah kiꞌen seedici ga fíkíi ɓuwii ɓéeɓ, fu yéegalɓa ɓéeɓɓa iñii fu hotɗa na iñii fu kelohɗa. ");
INSERT INTO snf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kon diimaɗa fu sekis ya? Koluka, fu bëtísiꞌuk, fu kíim Yéesu, Haꞌmudii fu set ga baakaaꞌciigaraa.» ");
INSERT INTO snf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Waa ennda ɗa, mi ɓoyukka Yéerúsaleem. Lak mi enee na kikíim Kooh ga Kaanfaa Kooh, iñaa ammbaroo fodii heeƴ. ");
INSERT INTO snf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mi hotta Haꞌmudii, ya woꞌꞌaroo an: «Gaawa, fu meƴ Yéerúsaleem diima-diima ndaga ɓu-teerii wii tooksanndii iñii fu yah garoo kiseediꞌɗa.» ");
INSERT INTO snf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mi taassari an: «Haꞌmudii, ɓa ínohin dijófíꞌ an mi taabee ga jaangu-yaawúuꞌcii, mi yaa am ɓuwii gëm garaaɗa, mi lagiɓa ga kasu, mi feekiɓa. ");
INSERT INTO snf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Iceen yaa enee seedifuɗa, apu ga fíkíiroo. Mi ga kihaffoo, mi fareera ga iñaa ɓa tumee yaama ee mi yërí amɗeeɓa kúltícaagaɓa.» ");
INSERT INTO snf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Waa ennda ɗa, Haꞌmudii woꞌꞌaroo an: «Karaa hen rek ndaga mi ƴahhaa kiwos ga ɓuwaa enussii yaawúuꞌɗa.» ");
INSERT INTO snf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɓuwaa súkúrukussa Pool bi ga daa ya woꞌoh woꞌeencaamaɗa, daama nak, ɓa aawissa kifiip didóolíꞌ an: - Yii ɓoꞌ meƴdohatti éldúnaanii wii, ya jomoo kipes! ");
INSERT INTO snf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓa ɓaa wëñ kifiip, ɓa ɓaa ɗol kúltícaagaɓa ɓaa jaf, ɓa ɓaa kësël kakayfaa ga ɗook. ");
INSERT INTO snf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Waa ennda ɗa, haꞌ-kaadaa soldaaꞌcaa nakohha Pool eku ɗuuƴ kaanfaa soldaaꞌcaa ya rípu na ngeeꞌ, bi ya woꞌ iñaa tah ɓuwaa fiipi fodaama ga fenoociɗa. ");
INSERT INTO snf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ga waa soldaaꞌcaa ɓaŋngari na liiɓ bi ɓaa ƴahhi kifeek, Pool woꞌꞌa soldaaraa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñ tuukee daamaɗa an: - Ɗú onuunun kifeek ɓa bok ga ɓu-Room ee lak ya attiꞌussii paaye? ");
INSERT INTO snf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Daa soldaaraama kelohee iñaama, ya foolla ga haꞌ-kaadaa soldaaꞌcaa, ya woꞌꞌari an: - Fu ínohin iñii fu ƴee kitumɗa sahe? Man ɓii bok ga ɓu-Room! ");
INSERT INTO snf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Haꞌ-kaadaa soldaaꞌcaa dalla kihay ga Pool, meekissari an: - Woꞌaaroo, fu bok ga ɓu-Roome? Pool taassari an: - Ee, mi bok ga! ");
INSERT INTO snf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Haꞌ-kaadaa woꞌꞌari an: - Mi ga kihaffoo, kibokkiigoo ga ɓu-Room mi lomohka yiséeríꞌ. Pool woꞌꞌari an: - Mi déy, mi límohu ga hen. ");
INSERT INTO snf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ga saasi ɓuwaa waaꞌseeri kifeek ya woꞌɗa, íisussari. Haꞌ-kaadaa soldaaꞌcaa, daa ya ínohee an ya bok ga ɓu-Room ee ya ɓaŋlukinndi na ceenɗa, ya tíitta. ");
INSERT INTO snf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ga kooh-wíisfaa, haꞌ-kaadaa soldaaꞌcaa waaꞌta kiꞌínoh iñaa leeꞌ ga iñaa yaawúuꞌcaa yam Poolɗa, ya nakohhari kiɓëgís, ya ebilohha kiɓëytoh sarahohcaa ɓiyaakɓaa na ɓéeɓ paanaa yaawúuꞌcaa wiyaakwaa, ɓa hídoh. Ya haydohlukka Pool, ya tuukiꞌtari ga fíkíiɓa. ");
INSERT INTO snf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Waa ennda ɗa, Pool yíppa ɓu-paanaa yaawúuꞌcaa has, ya woꞌꞌa an: - Ɗú mbokciigoo, dii mi kooꞌ ga kipessoo ga díkaantiroo na Koohɗa, helloo dalin ga bi ga wati. ");
INSERT INTO snf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Anañaas, haꞌ-kaadaa sarahohcaa dalla kiwoꞌ ɓuwaa tuukee ga yahaa Poolɗa ɓa këɓpi ga kúuw. ");
INSERT INTO snf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pool nak woꞌꞌari an: - Na cii fu man na míiraa yaanaawɗu henɗa, fu, Kooh ƴahhaa kifeek. Fu yuŋ dii kiꞌattiꞌꞌoo ga iñaa waas nakoh, fu nakoh mi feeku ee waas hoonohinka! ");
INSERT INTO snf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ɓuwaa enee ga yahaa Poolɗa, woꞌussari an: - Mon fu ɓasin haꞌ-kaadii sarahohcii, sarahohii-Kooh yiyaakyii! ");
INSERT INTO snf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool taassaɓa an: - Mbokcii, mi ínohéeríi an haꞌ-kaadii sarahohcii yërí. En kiꞌenaa, bíduunun ga Këyítfaa an: «Ɓaa kuliyuk ga heetiigaraa, fu jomoori kiwoꞌ yibóníꞌ.» ");
INSERT INTO snf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pool ínoheera an ɓuwaa hídírukohee daamaɗa, ɓii ensee ɓiSaduseyeeŋ, ɓíinoo ensee ɓiFërísiyeeŋ. Ya tuukka ga leeloo paanaa wiyaakwaa, ya woꞌꞌa didóolíꞌ an: - Ɗú mbokcii, mi iñii Fërísiyeeŋ ee mi kowu Fërísiyeeŋ. Dii mi abin yaakaaꞌ fodii garúu ga kimílískaa ɓuwaa kaaninɗa tah mi haydohussa dii kiꞌattiꞌu. ");
INSERT INTO snf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Daa ya woꞌee iñaama rek, nookoh dalla kilaak ga díkaanti Fërísiyeeŋcaa na Saduseyeeŋcaa, faf ɓuwaa hídírukohee daamaɗa hëgískohussa kom kanak. ");
INSERT INTO snf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","En kiꞌenaa, Saduseyeeŋcaa abu an ɓaa kaanin mílísoo, malaaka laakoo ee raɓ laakoo. Fërísiyeeŋcaa nak gëmuunun an iñcuma tóohca laakin. ");
INSERT INTO snf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Waa ennda ɗa, coowaa kolukka cúr. Laakka jëgíroh-waascaa koluk ee boku ga fërísiyeencaa, ɓa woꞌꞌa didóolíꞌ an: - Iñii ɓii yii woꞌɗa ɗí hottii yibóníꞌ ga. Mínin kiꞌen jíni wala malaaka woꞌ nari! ");
INSERT INTO snf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ñarohaa wëñnja ɗa kitamoh. Haꞌ-kaadaa soldaaꞌcaa niikka ɓuwaa seelsoh Pool, kërí tah ya ebilla soldaaꞌcaa kiyoosuk ga ɗuuƴ ɓuwaa, ɓa meƴdohhi ga leelooɓa, ɓa ɓoƴkidohhi kaanfaa soldaaꞌcaa. ");
INSERT INTO snf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ga wekaa tík gaɗa, Haꞌmudii feeñukka Pool, woꞌꞌari an: - Ɓaataa kiyëgísɗuk, fu seediꞌinndoo dii ga Yéerúsaleem ee fu jominndoo kiseediꞌ ga Room ɓan. ");
INSERT INTO snf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ga kooh-wíisfaa ga kímaa, yaawúuꞌcaa pokohussa nof kiꞌap Pool; ɓa waatta an dara aasanndii kúuwɓa, enndii an ɓa appi hen paayaa. ");
INSERT INTO snf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓuwaa waatukee iñaamaɗa wëñin ɓoꞌ ɓidaaŋkaah-nikiis. ");
INSERT INTO snf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓa kaꞌta ga sarahohcaa ɓiyaakɓaa na yaakcaa dëkaa, ɓa woꞌꞌaɓa an: - Ɗí waatin an ɗí ñamanndii, ɗí ananndii enndii an ɗí ap Pool hen paayaa. ");
INSERT INTO snf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Diima nak, ɗú, pokohat nof na ɓu-paanaa wiyaakwaa, ɗú tum fodii an ɗú waaꞌ kimalkaat iñaa aaw ga Pool bi leeꞌ lañ, ɗú kíim soldaaraa yiyaakyaa ya haydohiꞌtúuri. Ɗí ga kihaffíi nak ɗí hayyi kitërëwuk kiꞌappi bi ya leꞌ diinaa. ");
INSERT INTO snf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kutaanamunkaa Pool nak kelohha an yaawúuꞌcaa ƴah kitërëwuk Pool kiꞌappi. Ya kaꞌta kaanfaa soldaaꞌcaa, ya aassa, ya yéegallaka Pool. ");
INSERT INTO snf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pool ɓayya yíinoo ga soldaaꞌcaa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa, woꞌꞌari an: - Ɓayaa oomaa-ƴaalii yii ga haꞌ-kaadaa soldaaꞌcaa, ya laak iñaa ya ƴahhi kiwoꞌ. ");
INSERT INTO snf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Waa ennda ɗa, soldaaraa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa taammba na oomaa-ƴaalaa, ɓayyari ga haꞌ-kaadaa, ya woꞌꞌari an: - Pool yaa lagu ga kasaaɗa yërí ɓayyoo, ya woꞌꞌaroo an mi haydoh oomaa-ƴalii yii garaa, an ya laak iñaa ya ƴahhaa kiwoꞌ. ");
INSERT INTO snf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Haꞌ-kaadaa soldaaꞌcaa ammba oomaa-ƴaalaa, nookkari, ɓa úsaayya ɓuwaa, ya meekissari an: - Fu ƴahhoo ya kiwoꞌ? ");
INSERT INTO snf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kutaanamunkaa Pool woꞌꞌari an: - Yaawúuꞌcaa pokohuunun nof kikíimmbaa fu ɓay Pool paanaa wiyaakwaa. Ɓa ƴah kitum fodii ɓuwaa ƴah kimalkaat loo Pool bi leeꞌ lañ. ");
INSERT INTO snf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Fu nak kaa gëmɓa. En kiꞌenaa, iñaa wëñin ɓoꞌ ɓidaaŋkaah-nikiis gaɓa waayukuunun kitërëwuk Pool kiꞌappi. Ɓa waatukin an ɓa ñamanndii, ɓa ananndii, enndii an ɓa appi hen paayaa. Ɓa sek fu took doŋ. ");
INSERT INTO snf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Haꞌ-kaadaa soldaaꞌcaa woꞌꞌari an: - Ee, kaa woꞌ ken an fu yéegalinndoo iñaa bok ga. Lëehíꞌta ya íissa oomaa-ƴaalaa yaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Waa ennda ɗa, haꞌ-kaadaa soldaaꞌcaa ɓayya ga soldaaꞌcaagari ɓanak ɓaa kuliyuk ɓoꞌ ɓitéeméeꞌ ga heñ, ya woꞌꞌaɓa an: - Hídírohat soldaaꞌ ɓitéeméeꞌ-kanak ɗú tuuk ga kiƴah Sesaree. Ɗú taam ɓan na soldaaꞌ ɓidaaŋkaah-yitnakanak ɓaa lap pënís na soldaaꞌ ɓitéeméeꞌ-kanak ɓiliis ɓaa ɓay núɓ. Ɗú ƴah kikolkoh dii noh-soos ga wahtu cuuníin ɗú ƴeeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ɗú heeliꞌ Pool pënís ɓan, ɗú ɓayyi ga Filiksi, gúwernëeraa ee dara hanatti kiꞌoc. ");
INSERT INTO snf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ya bínnda këyít, woꞌꞌa ga an: ");
INSERT INTO snf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Filiksi, gúwernëerii yiyaakyii, mi Kolot Lísiyas mi yërí bínndaa këyítfii fii, ee mi yii këñíꞌtaa ga. ");
INSERT INTO snf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ɓii mi wosohhaa yii, yaawúuꞌcii diiɗa ɓërí abeeri ee ɓa waareeri kiꞌap. Mi sooŋngaɓa, mi na soldaaꞌcii, mi teꞌꞌari ga yahɓa ga waa mi ínoh an ya bok ga ɓu-Roomɗa. ");
INSERT INTO snf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mi waaꞌta kiꞌínoh iñaa ɓa yammbiɗa, mi ɓayyari paanaa yaawúuꞌcaa wiyaakwaa. ");
INSERT INTO snf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mi hotin nak an iñcii ɓa yammbiɗa aaw ga loo waasiigaɓa ee mi hottii dara iñaa ya tum bi cal ya tíku kikaan wala ya lagu ga kasu. ");
INSERT INTO snf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mi kelohha an yaawúuꞌcii pokohuunun nof kiꞌappi, kërí tah mi wosohhari garaa ga saasi. Ɓuwii yammbiɗa, mi woꞌinɓa ɓa hay garaa, ɓa woꞌ iñaa ɓa yammbiɗa.» ");
INSERT INTO snf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soldaaꞌcaa ɓewussa Pool, fodaa ɓa naku kaɗa, ɓa ɓayyari ga wek bi ga teeraa Antípatiriis. ");
INSERT INTO snf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ga kooh-wíisfaa, soldaaꞌcaa tíinseeɗa, ɓoƴkussa kaanfaa soldaaꞌcaa, ɓa íissa Pool na soldaaꞌcaa lapsee pënísɗa, ɓa paaf nari. ");
INSERT INTO snf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ga waa soldaaꞌcaa lap pënís leꞌu Sesareeɗa, ɓa eꞌta gúwernëeraa këyítfaa, ɓa tíkka Pool ga yahci. ");
INSERT INTO snf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gúwernëeraa jaŋnga këyítfaa, ya meekisohha gohaa Pool meyohɗa. Daa ya ínohee an ya meyoh gohaa Sílísíi, ");
INSERT INTO snf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ya woꞌꞌari an: - Bi mi meekissaa daranaa, ɓuwaa yabussaaɗa hayu. Waa ennda ɗa, ya nakohha Pool ɗaaku ga kaanfaa buuꞌ Eroot en daamaɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tíkka ga bes ciyëtúus, Anañaas, haꞌ-kaadaa sarahohcaa taammba na ɓiyaak ga yaawúuꞌcaa na Tertilus yaa tum lëgëy kilayohɗa, ya hayya teeraa Sesaree. Ɓa kaꞌta ga Filiksi gúwernëeraa kikalaami Pool. ");
INSERT INTO snf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pool ɓayussa, Tertilus dalla kiwoꞌ an: - Fu Filiksi, gúwernëerii yijófíꞌyii, dii fu tíidiꞌ dëkiiɗa na iñcii ciꞌascii fu haydoh ga nguuriigaraaɗa onin heetii kilaak jam wimëtíꞌ ee keeñnjíi soosin garaa. ");
INSERT INTO snf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ɗí hotinka ga daa en tóoh na ga iñaa en ɓéeɓ ee ɗí ɓii gërëmmbaa dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi waaꞌtiiraa kiꞌam na tiwoꞌ tihëpíꞌ kërí tah mi hay kilóhóyíꞌ woꞌeenii. Mi kíimmbaa ga kijofkiigaraa fu súkúrukkíi jutuut. ");
INSERT INTO snf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tertilus tíkka ga an: - Ɗí hotin an ɓii yii, ɓoꞌ yibóníꞌ ga ɗuuƴ ɓuwii. Ya haydoh kihëgískoh ga ɗuuƴ yaawúuꞌcii ga ëldúnaɗa tóohɓa; yërí kuliyuk ga ɓuwum taabuk iñii jëgírohu meyoh Nasareetɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Karin bi ya jéemmba kilíiwíꞌ Kaanfaa Kooh, kërí tah ɗí ammbari. Ɗí waareeri kiꞌatti, ");
INSERT INTO snf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","wayee Lísiyas, haꞌ-kaadaa soldaaꞌcaa hayya, teꞌꞌari na dooli ga yahhíi. ");
INSERT INTO snf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ya ebillaríi kihay garaa.. Binaa fu meekissinaa, fu ga kihaffu fu hay kiꞌínoh an iñii ɗí yammbiɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Waa ennda ɗa, yaawúuꞌcaa taamsee na Tertilusɗa yëgíssa ga an iñaa Pool yabuɗa kayoh. ");
INSERT INTO snf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Waa ennda ɗa, gúwernëeraa eŋnga Pool haf ya woꞌ ɓan. Pool nak dalla kiwoꞌ an: - Kiyaakii, mi ínohin an fu enin attiꞌoh ga heetiigaríi tíkíis tiyewin, kërí tah mi hay kilayiꞌ haffoo na hel widëlíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Binaa fu malaksukohaa, fu hay kihot an iñaa mi karee Yéerúsaleem kijaamuk Kooh bi ga wati, paaffii bes cidaaŋkaah na kanak. ");
INSERT INTO snf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ee ken hottii daa mi nookoh kiwoꞌ na ɓoꞌ wala kihícisoh ɓuwaa, ennda ga Kaanfaa Kooh, ga jaangu-yaawúuꞌcaa wala ga ɗuuƴ teeraa. ");
INSERT INTO snf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓuwii ɓii mínsoo kiwoꞌ dara yiléeríꞌ ga iñcii ɓa yammboo diima diimaɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Enaama yíinoo déy mi míninndi kitook ga fíkíifu: Mi, mi jaamuk Koohyii ɓicaasammbíi, mi taabukka waasii wiꞌaswii ɓa woꞌ an sabohɗa. Hoonohhii bi mi gëmin ɓan ɓéeɓ iñaa Waasii Móyíis nakohɗa na ɓéeɓ iñaa sëldíiga-Koohcaa bínɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi abin yaakaaꞌ ga Kooh ee ɓa, ɓa laakin yaakaaraama ɓan. Ee wërí en an ɓuwii ɓijúwíꞌɓii na ɓuwii júwussiiɗa tóoh hay kimílísu. ");
INSERT INTO snf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kërí tah daa mi enoh tóoh mi heel kipes na hel widëlíꞌ ga fíkíi Kooh na ga fíkíi ɓuwii. ");
INSERT INTO snf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mi enin ga ëgírii tíkíis tiyewin taa mi hayyii Yéerúsaleem. Kërí tahhoo dii kihay mi haydohi ɓu-heetiigoo dímal kopaꞌ na kitumiꞌ Kooh sarah ga kaanfaagari. ");
INSERT INTO snf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","En kiꞌenaa, mi enee ga ɗuuƴ Kaanfaa Kooh, ee lak mi en na kisétíꞌsiruk fodii dii yaawúuꞌcii tumsikaɗa. Ken enndii da ee coow kolukkii da. ");
INSERT INTO snf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Laakeera daama nak yaawúuꞌcaa meyohsee gohaa Aasíi. En kiꞌenaa, yaawúuꞌcaa ɓaama meyohsee gohaa Aasíiɗa ee hotseerooɗa, ɓërí jomee kituuk dii ga fíkíifu ɓa yammboo en lak ɓa laakin iñaa ɓa taabukohanndoonaa. ");
INSERT INTO snf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kon nak yaawúuꞌcii enu dii ee boku ga paanaa yaawúuꞌcaa wiyaakwaaɗa, ɓa woꞌat kofeelkaa mi tum ga waa mi tuukiru kiꞌattiꞌu ga paanaa wiyaakwaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɓa laakoo iñaa ɓa yabohanndoo, enndii woꞌeenii wii mi woꞌ didóolíꞌ ga fíkíiɓaɗa an: «Dii mi gëmin ga kimílískaa ɓuwaa kaaninɗa tah mi haydohu kiꞌattiꞌu ga fíkíirúu wati.» ");
INSERT INTO snf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filiksi nak, lak woꞌuunun dijófíꞌ loo waas kerceen, ya keꞌta attiꞌaa bi bes wiliis, ya woꞌꞌa an: - Binaa Lísiyas, haꞌ-kaadaa soldaaꞌcaa hayaa, mi malakis iñum akitohhúuɗa. ");
INSERT INTO snf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Waa ennda ɗa, Filiksi nakka soldaaraa kuliyuki ɓoꞌ ɓitéeméeꞌ ga heñɗa kiɗaak Pool ga kasaa, wayee ya íisu ya féeh ee fiiliimuncaagari míniri kihay kitoputuꞌ. ");
INSERT INTO snf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ga bescaa tík gaɗa, Filiksi hayya ya na ɓetici, Durusíl. Durusíl nak iñaa yaawúuꞌ. Ya ɓaylukka Pool kisúkúrukki, yaama woꞌꞌi yen ga loo kigëm ga Yéesu Kiristaa. ");
INSERT INTO snf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Wayee daa Pool woꞌee bi leꞌꞌa ga loo enukeen wijúwíꞌ na loo kimín kiꞌabuk, na loo attiꞌaa ƴah kimëeñjohɗa. Filiksi, gúwernëeraa dalla kitíit, ya íissa Pool ya woꞌꞌari an: - Diimaɗa, fu mínin kikaꞌ kimma, wati hayɗa kidooy. Mi kolukaa mi hayyaa kiɓayis. ");
INSERT INTO snf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ya foogee an Pool hayyi kiꞌeꞌ hëelís, kërí tah leekleekaa ya ɓayluk Pool kisaawal nari. ");
INSERT INTO snf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Waa ennda ɗa, tíkíis tanak tíkka ga, laakka gúwernëeꞌ yiliis yaa faluk ee teeku Poosiyus Festus. Filiksi ga kihafci, kiwaaꞌ iñaa neɓ yaawúuꞌcaa doŋ tahee bi ya íissa Pool ga kasaa. ");
INSERT INTO snf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Waa ennda ɗa, Festus, gúwernëeraa hayya gohaa ya ƴah kinguurukohɗa. Ya tummba daama bes kaahay, ya meyohha gohaa Sesaree ya kaꞌta Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Sarahohcaa ɓiyaakɓaa na ɓuwaa kuliyuk ga yaawúuꞌcaaɗa, ");
INSERT INTO snf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","hayussa kikalaamiꞌ Pool gari. Ɓa kíimmbari, ya dímalɓa, ya haydoh Pool Yéerúsaleem. En kiꞌenaa, ɓa pokohee nof kitërëwuk Pool ga waas, ɓa appi. ");
INSERT INTO snf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Wayee Festus, gúwernëeraa taassaɓa an Pool yaa lagussa ga kasaa Sesaree, ee ya ga kihafci ya en na kiɓoyuk daama ga iñaa maañnjii. ");
INSERT INTO snf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ya tíkiꞌtaɓa an: - Laakin garúu ɓuwaa mín kituukuk iñaamanaa, ɓa taabat naroo, ɓa kalaamiꞌ Pool en lak ya tumin iñaa moroonaa. ");
INSERT INTO snf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus, gúwernëeraa tum ga Yéerúsaleem bes ciyitnakaahay aawwa cidaaŋkaah doŋ, lëehíꞌta ya ɓoyukka Sesaree. Ga kooh-wíisfaa, ya kaꞌta paanaa attiꞌohsiɗa, ya nakohha kihaydoh Pool. ");
INSERT INTO snf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Daa Pool hay hen, yaawúuꞌcaa meyohee Yéerúsaleemɗa wíilussari, ɓa yammbari enaama cibóníꞌ ciyewin. Wayee ɓa mínéeríi ga kiwoꞌ iñaa leeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pool nak layohiꞌta hafci, woꞌꞌa an: - Mi tooñnjii ken: enndii ga Waasii yaawúuꞌcii; enndii ga Kaanfaa Kooh; enndii ga Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus nak waaree kitum iñaa neɓ yaawúuꞌcaa, ya dalla kiwoꞌ Pool an: - Fu waarin kiɓoyuk Yéerúsaleem fu attiꞌu ga fíkíiroo ga iñcii fu yabuɗane? ");
INSERT INTO snf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pool dallari kitaas an: - Múk, mi yii tuukka dii ga fíkíi paanii buuꞌ Sesaaꞌ jommboo kiꞌattiꞌɗa, ee mi attiꞌohsan dii. En yaawúuꞌciinaa, mi tummbiiɓa dara yibóníꞌ, ee fu ga kihaffu, fu ínohinka ga moos. ");
INSERT INTO snf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Enee an mi tooñ hen wala mi tum iñaa cal mi tíku kikaanaa, eneenaa mi sagoo kikaan. Wayee en lak iñcii ɓuwii ɓii yammbooɗa enndii kayohaa, waas onndii ken kitíkkoo ga yahɓa. Mi kíim kipaafdohu ga buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Waa ennda ɗa, Festus, gúwernëeraa kaꞌta, hotohha na ɓuwaa taabi nariɗa, lëehíꞌta ya woꞌꞌa Pool an: - Fu waaꞌ kipaafdohu ga buuꞌ Sesaaꞌ, kon fu hay kikaꞌ ga buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ga besaa tík gaɗa, buuꞌ Agírípaa na Berenís, këmëeŋkíci yiɓeti hayussa gohaa Sesaree kikëñíꞌ Festus, gúwernëeraa. ");
INSERT INTO snf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ee lak ɓa hay kiꞌen daama bes ciyewin, Festus nak ɓéestíꞌta buuraa loo Pool, woꞌꞌari an: - Laakin ɓaa en dii, gúwernëeꞌ Filiksi yërí foñeeri ga kasu. ");
INSERT INTO snf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ga waa mi kaꞌ Yéerúsaleemɗa, sarahohcaa ɓiyaakɓaa na yaakcaa yaawúuꞌcaa, hayussa kikalaamiꞌꞌi garoo, ɓa kíimmbaroo an mi tíkatti kikaan. ");
INSERT INTO snf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mi taassaɓa an kiꞌeroh ɓoꞌ ya apu ee lak ɓaa tuukkii na ɓuwaa yammbiɗa, ya layoh ga iñcaa ya yabuɗa, iñaama taammbii na iñaa ɓu-Room meeꞌ kitumɗa. ");
INSERT INTO snf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Waa ennda ɗa, ɓa taammba naroo ɗí hayya dii ga Sesaree. Mi nak, mi sekkii iñaa maañ. Kooh yaa wíis rek, mi kaꞌta paanaa attiꞌohsiɗa, mi nakohha kihaydoh ɓaa yaama abu ga kasaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ɓuwaa kalamiꞌeeriɗa, ga waa ɓa hayya, ɓa yammbiiri wíinoo ga iñcaa mi halaateeɗa. ");
INSERT INTO snf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɓa nookoh iñaa aaw ga loo waasiigaɓa na loo ɓaa teeku Yéesu ee kaaninɗa, Pool nak yëgísin ga an Yéesu yaa pes. ");
INSERT INTO snf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mi nak, mi laakkii iñaa mi woꞌan ga iñaama. Kërí tah mi woꞌꞌa Pool kikaꞌ Yéerúsaleem ya attiꞌunee daama. ");
INSERT INTO snf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wayee Pool kíimmba ya paafdohu ga buuꞌ Sesaaꞌ ndaga ya bok ga ɓu-Room. Waa ennda ɗa, mi ebilohha ya ɗaaku ga kasu bi ga daa mi mínanndi kiwosoh ga buuꞌ Sesaaꞌ. ");
INSERT INTO snf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agírípaa dalla kiwoꞌ Festus an: - Mi ɓan mi waarinndi kisúkúruk, ya woꞌ mi keloh. Festus taassari an: - Kuwis-kuwisɗa, fu hayyi kisúkúruk, ya woꞌ fu keloh. ");
INSERT INTO snf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ga kooh-wíisfaa nak, Agírípaa na Berenís, këmëeŋkíci hayussa na sañsi ciyaak, ɓa taam na ɓiɓoꞌ ɓilëekíꞌ-teek. Ɓa aassa ga taahaa attiꞌohsiɗa na soldaaꞌcaa ɓiyaakɓaa na ɓuwaa kuliyuk ga teeraaɗa. Festus ebilohha Pool haydohu. ");
INSERT INTO snf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Lëehíꞌta, Festus woꞌꞌa an: - Buuꞌ Agírípaa, na ɓéeɓpúu ɗú ɓii ɗú en diiɗa, ɓii ɗú hot yii, ɓéeɓ heetii yaawúuꞌcii hayuunun garoo kiñaꞌsukoh iñaa aaw gari. Ɓa hayin garoo ga Yéerúsaleem, ɓa hayin dii ɓan, ɓa ɓaa fiip ga ɗookkoo an ya jomissii kipes. ");
INSERT INTO snf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mi ga kihaffoo nak, mi hotin an ya tummbii enaama yíinoo yibóníꞌ, yaa cal ya tíku kikaan. Diimaɗa, ya nak ya kíim kipaafdohu ga buuraa ɓu-Room, kërí tah mi abin an mi hayyi kiwosoh gari. ");
INSERT INTO snf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mi nak mi laakkii dara yiléeríꞌ ga looci yaa mi mínan kibín buuꞌ Sesaaꞌ. Mi haydohhari ga fíkíirúu, ee wëñaa ga fíkíifu, buuꞌ Agírípaa; en ɗanaa, ya meekisunaa, heƴna mi laak kimma iñaa mi bídanndi. ");
INSERT INTO snf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","En kiꞌenaa, mi halaat an kiwosoh Room ɓaa abu ga kasu, ee ken mínoo kiwoꞌ yiléeríꞌ ga iñcaa ya yabuɗa, iñaama enndii halaat. ");
INSERT INTO snf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Waa ennda ɗa, buuꞌ Agírípaa woꞌꞌa Pool an: - Fu mínin kiwoꞌ kimma, fu layohiꞌ haffu. Pool nak lëríssa yahaagari, woꞌꞌa an: ");
INSERT INTO snf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","- Buuꞌ Agírípaa, keeñnjoo soosin wati kituuk ga fíkíifu, mi layohiꞌ haffoo ga tóoh iñcii yaawúuꞌcii yammbooɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","En kiꞌenaa, fu ínohin dijófíꞌ ɓéeɓ baahcii yaawúuꞌcii na iñcii en saawalɓaɗa. Mi kíimmbaa fu súkúrukkoo dijófíꞌ. ");
INSERT INTO snf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Yaawúuꞌcii ɓéeɓɓa ínohsin dii mi kooꞌ ga kipeskiigoo, aboh ga kiꞌoomaarooɗa. Ɓa ínohin daa mi madee kuɗewaaɗa, ennda ga ɗuuƴ heetiigoo, ennda ga Yéerúsaleem. ");
INSERT INTO snf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ɓa maañinndoo kiꞌínoh, ee ɓa mínin kiseediꞌ, ɓa tookkanaa, an mi bok ga Fërísiyeeŋcii; ee ɓuwaama, daa ɓa taabuki Waasii Móyíisɗa wëñ kiɓít. ");
INSERT INTO snf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Wati nak, mi yii attiꞌu ndaga dii mi yaakaarin an Kooh hay kimëtíꞌ iñaa ya dígee ɓicaasammbuuɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dígaama, níilcii cidaaŋkaah na kanakcii heetiigaruu yaakaaruunun kihotwa wa mat, kërí tah ɓa jaamuki Kooh wekoo nohoo. Buuꞌ Agírípaa, kiyaakaaꞌ dígaama tah yaawúuꞌcii kalaamiꞌussoo. ");
INSERT INTO snf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Iñii tah ya ɗú yaawúuꞌcii ɗú tum ga helciigarúu an Kooh mínoo kimílísiꞌ ɓuwaa kaaninɗa? ");
INSERT INTO snf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mi ga kihaffoo sah mi tumee ga helloo an daa ka mín kiman tóoh mi jomin kiheñoh teekii Yéesu Nasareet. ");
INSERT INTO snf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ee iñaama yërí mi enukohee ga Yéerúsaleem. Mi lagin ga kasu ɓoꞌ-Kooh ɓiyewin, ee sarahohcaa ɓiyaakɓaa ɓërí oneeroo kitum iñaama. Binaa ɓa ƴah kiꞌapunaa, mi fareera ga. ");
INSERT INTO snf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Leekleek, mi taabee ga jaangu-yaawúuꞌ na jaangu-yaawúuꞌ, mi feeklukiɓa kiheeliɓa kimeƴdoh ga ngëmaagaɓa ga Yéesu. Mi sageeɓa hen bi mi daaneeɓa kidawuk bi ga dëkcaa wëñ kiꞌúsaayɗa, kisodalɓa. ");
INSERT INTO snf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Fodaama, laakka bes, mi enee na kiƴah Damaas, lak sarahohcaa ɓiyaakɓaa eruununndoo dooli kiꞌam ɓuwaa gëmu ga Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Buuꞌ Agírípaa, wiima lak mi yaa ga waas Damaas. Ga ɓak mídí, mi hotta leeꞌlaat waa meyoh asamaan. Meliclaataa gawa wërí wëñ nohii kimelic, wa ennda mareet bi wíillaroo mi na ɓuwaa mi taabee naɓaɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ɗí ɓéeɓpíi, ɗí keennda kakay, mi dalla kikeloh koonaakaa woꞌ naroo ga kiꞌArameyee an: «Sóol, Sóol, iñii tah ya fu hatalloo ga kipes? Fu tum haffu, fu man na baamaa tap dooraa haꞌmudaagari feekkiɗa» Mi meekissari an: ");
INSERT INTO snf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Kiyaakii, fu yërí en ɓa?» Haꞌmudii taassaroo an: «Mi yërí en Yéesu yii fu hatal ga kipesɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Wayee kolka, fu tuuk ga kotciigaraa, mi woꞌꞌaa iñii tah mi feeñukkaaɗa. Mi tanukinndaa fu en súrgaroo, fu seediꞌꞌoo ga fíkíi ɓuwii, ga iñcii fu hot watiɗa na ciliis caa mi ƴahhaa kiteeɓ. ");
INSERT INTO snf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi hayyaa kisom ga heetii yaawúuꞌcii na ɓuwii enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mi wossaa gaɓa, fu lëgísiꞌɓa hasciigaɓa, fu ɓewohɓa ga ñúusii fu haydohɓa ga leeꞌlaatii. Fu ɓewohɓa ga yah Seytaani, fu ëewdohɓa ga Kooh, mi bayalɓa baakaaꞌciigaɓa, en ɗanaa ɓa gëm garoonaa mi waꞌ ɓa ga iñcii ɓuwii Kooh ƴah kilamɗa.» ");
INSERT INTO snf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kon nak buuꞌ Agírípaa, mi taabuk iñcii Koohyii feeñukkoo teeɓpooɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ee sah mi ɗeɓ kijëgíꞌ ɓu-teeraa Damaas na ɓu-teeraa Yéerúsaleem. Lëehíꞌta, mi paaffa ga ɓu-kúlkaa Yúudée ɓéeɓka, mi mëeñjohha ga ɓuwii enussii yaawúuꞌɗa. Mi yéegallaɓa an ɓa jomin kisúpít kipeskaagaɓa, ɓa ëewdoh hafɓa ga Kooh ee ga tumeencaagaɓa ɓa teewoh kayoh-kayohɗa an ɓa súpítin kipes. ");
INSERT INTO snf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Iñaama yërí tah yaawúuꞌcii abussaroo ga Kaanfaa Kooh, ɓa ɓaa heelloo kiꞌap. ");
INSERT INTO snf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kooh músalinndoo, mi yii lís kipes bi ga besii wati. Mi yii seediꞌ ga fíkíi ɓuwii, ennda oomaa ennda yaak. Iñcii mi jëgírohɗa ɗeeŋngii iñaa sëldíiga-Koohcaa na Móyíis yéegalohsee an ca hay kilaakɗa: ");
INSERT INTO snf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","an Kiristaanii hay kidaƴ coonu ciméeskíꞌ, ee yërí ƴah kiɗeɓ kimílís ga ɓuwaa kaaninɗa, ya yéegal heetiigaruu na heetcii cíinoo leeꞌlaatii onoh kipesɗa. ");
INSERT INTO snf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Lak Pool yaa eemmba daama ga layohaagari, Festus, gúwernëeraa dallari kifiip an: - Way way Pool fu dofin! Jagiigaraa wihëpíꞌwii mëeñísin hafiigaraa ƴaay! ");
INSERT INTO snf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pool nak taassari an: - gúwernëeꞌ Filiksi mi doffii déy. Iñii mi woꞌɗa ɓéeɓwa kayoh ee laakin haf. ");
INSERT INTO snf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Buuꞌ Agírípaa sah ínohin iñii mi woꞌɗa, kërí tah mi kaañ kituuk mi woꞌka ga fíkíici. Ɓéeɓ iñciima, wíinoo gaca appiiri kúmpa ndaga laakkii caa tumu ga rúkku. ");
INSERT INTO snf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Buuꞌ Agírípaa, fu gëmin iñaa sëldíiga-Koohcaa woꞌɗane? Ee, mi ínohin an fu gëmin ga. ");
INSERT INTO snf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Waa ennda ɗa, Agírípaa buuraa woꞌꞌa Pool an: - Tes ga jutuut fu tummboo kerceen! ");
INSERT INTO snf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool taassa an: - Yéeh, maañ, Kooh tumat, mi woꞌꞌii fu doŋ wayee bi ga ɓéeɓ ɓuwii súkúrukkooɗa, ɗú laakneeroo ga iñii mi enukohɗa bi tes kiɓagu na ceen. ");
INSERT INTO snf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Waa ennda ɗa, buuꞌ Agírípaa na Festus, gúwernëeraa na Berenís na ɓéeɓ ɓuwaa enee daamaɗa, kolkussa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ga waa ɓa en na kiƴahɗa, ɓa ɓaa woꞌ ga díkaantiɓa an: - Ɓii yii tummbii enaama yíinoo yibóníꞌ yaa cal ya tíku kikaan wala kilagu ga kasu. ");
INSERT INTO snf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Buuꞌ Agírípaa nak dalla kiwoꞌ Festus, gúwernëeraa an: - Enéeríi dii ya kíim kipaafdohu ga buuꞌ Sesaaꞌɗanaa ennaa ya mínin kiꞌíisu, ya ƴeeꞌ. ");
INSERT INTO snf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Waa ennda ɗa, ɓa ammba bes kiꞌekkíi ga gaal-giiƴ, ɗí ɓayu Kúlkaa Ítalíi. Pool na ɓoꞌ ɓiliis, ɓaa amsee ga kasu fodaa gari tíkussa ga yah Húliyus, ha-kaan ga soldaaꞌcaa ɓu-Room woꞌu «Soldaaꞌcaa buuꞌ Sesaaꞌɗa». ");
INSERT INTO snf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ɗí aassa ga gaal-giiyaa meyoh teeraa Adaramit ee wa aawee dëkcaa Aasíi en ga yahaa giiyaaɗa, ɗí ɓaa ƴah ga giiƴ. Arístarka, ee dëk teeraa Tesaloník ga gohaa Maseduwaanɗa taabee naríi. ");
INSERT INTO snf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ga kooh-wíisfaa, ɗí teeꞌneera ga teeraa Sídoŋ, Húliyus ennda ɓoꞌ yijófíꞌ ga Pool. Ya onndari kimín kikaꞌ ga fiiliimuncaagari doonaa ɓa mínndi kitoputuꞌ. ");
INSERT INTO snf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ga waa ɗí meyoh daama, ɗí taabohha na dëkaa Sípaꞌ giiyaa wíilɗa kisúnuk uurisaa ndaga lak ɗí jaanoh nawa hen. ");
INSERT INTO snf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lëehíꞌta ɗí koorohha giiyaa ga gohaa Sílísíi, aawwa waa Pamfílíi, ɗí teeꞌneera teeraa Miraa ga gohaa Lísíiɗa. ");
INSERT INTO snf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Daama, Húliyus soldaaraa yiyaakyaa hotta gaalaa meyoh Aleksandarí aaw Ítalíi, ya ekkaríi ga. ");
INSERT INTO snf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ɗí tumin ga giiƴ bes ciyewin caa gaalaa foolee ndaŋ. Ga wii ɗí kaꞌ bi ɗí laŋneera na teeraa Kímítɗa, lak ɗí dayin coonu fiméeskíꞌ, ɗí mínndii kiteeꞌ daama. Uurisaa nak onndiiríi kiꞌaaw fíkíi ga ɓakaama, ɗí nammba kikooroh Salomee en ɗanaa ɗí paafoh ɓakaa Keret súnúkin ga uurisaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ɗí taabohha giiyaa daama bi ɗí leꞌꞌa ɗekat waa woꞌsi «Diteeraaꞌ diwóoríꞌ», en ga yahaa teeraa Laseeɗa. ");
INSERT INTO snf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ga wii ɗí leꞌ daamaɗa lak ɗí maañin ga waas lool, ee kifoolis ga giiƴ wëerissii, ndaga lak ooraa yaawúuꞌcaa ga seekɗa paafin. Kërí tah, Pool woꞌꞌa na ɓuwaa, kiyéegalɓa an: ");
INSERT INTO snf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","- Ɓiƴaay, mi hotin an ɓaawiigaruu wii wëerissii, ɗu aaw fíkíinaa. Mi woꞌissiirúu an gaalii na iñii wa sëfɗa hay kiyasukoh, wayee tumuuntiiruu sah mínin ga kihín. ");
INSERT INTO snf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Wayee soldaaraa yiyaakyaa ɓu-Room ammbii faali ga iñaa Pool woꞌɗa, ya nammba kisúkúruk iñaa fóolíroh-gaalaa na haꞌ-gaalaa woꞌɗa. ");
INSERT INTO snf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɓaatta ga ɗekataa gaalaa teeroh waama newoo kiꞌenoh na lah, kërí tah iñaa wëñ kiyewin ga ɓuwaaɗa júwohussa ga kikolkoh daama, ɗí paaf, en mínukinaa, bi ga Fenísíi, ɗekat wiliis ga Keret waa ɓoꞌ mínin kiteeroh bi seek wíis. Ɗekataama nam kijaanoh na aasaaꞌ-noh. ");
INSERT INTO snf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Waa ennda ɗa, uuris wihídíꞌ, waa kolkoh yah-ñaam meyaaꞌ-noh, aawwa kiwëp, kërí tah ɓa ammba yaakaaꞌ an ɓa hay kimín kikaꞌ bi ɓa teeꞌ ga Fenísíi. Ɓa ponnda níꞌcaa pokohsee gaalaaɗa, ɓa taammba giiyaa, ɓa riisukka Keret, ɓa ɓaa ƴah. ");
INSERT INTO snf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Wayee maañnjii dara, uurisaa wiyaakwaa teeku Erakilíyoŋɗa dalla kiwëpoh tëgëlcaa Keret, wa ennda mílíp ga ɗookkíi. ");
INSERT INTO snf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Uurisaa jíitalla gaalaa, ken mínissiiwa kitëhdoh, ɗí íissawa, waa ƴah ɗuuƴ. ");
INSERT INTO snf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ɗí yolohha Kódaa, kudëk jijutuut, ja súnndaríi ga uurisaa. Fodaama, ɗí mínnda kijekeluk gaal-loocaa taamdohsi na gaal-giiyaaɗa. Ɗí lëpíꞌtawa ga gaalaa ee ɗí sonnda ga lool. ");
INSERT INTO snf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ga waa ɗí lebirohha bi ɗí lëpíꞌtawa, ɗí ŋaawwa gaalaa na níꞌ doonaa wa tasoo, lëehíꞌta ɗí yóoskíꞌta dúuñaa wiyaakwaa poksi ga fenoo gaalaaɗa kinóowís gaawlaataa ndaga ɗí niikee uurisaa yeꞌ gaalaa bi ɗí paafnee tewisaa teeraa Sírta. ");
INSERT INTO snf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ga kooh-wíisfaa lak uurisaa waa lís kiyëngël gaalaa didóolíꞌ, kërí tah ɗí aawwa kijaf iñaa gaalaa sëfeeɗa ga giiyaa. ");
INSERT INTO snf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ga besaa tík gaɗa, ɓuwaa fóolíri gaalaaɗa na kihafɓa jafussa paŋkaahcaa enee ga gaalaaɗa ga giiyaa. ");
INSERT INTO snf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ɗí tumin bes ciyewin ga giiƴ caa ɗí hottii noh, ɗí hottii ol. Uurisaa yíppa rek ínohoo kiꞌíis, kaꞌta bi ɗí abissii yaakaaꞌ kimúc. ");
INSERT INTO snf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wiima lak ɓuwaa ensee ga gaal-giiyaaɗa tumuunun iñaa maañ ee ken ekkii ñamah ga kúuwci. Pool dalla kikoluk, tuukka ga leelooɓa, woꞌꞌaɓa an: - Ɓiƴaay, ɗú súkúrukee woꞌeenndoonaa, eneenaa ɗú kolukohoo Keret ee iñcii tóoh yasukoh cii laakoo. ");
INSERT INTO snf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Wayee diimaɗa mi nakkúu kiyëgísɗuk. En kiꞌenaa, laakoo yíinoo garúu yaa kumuunci hídan ga, hanaa gaalii doŋ yahan. ");
INSERT INTO snf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","En kiꞌenaa, wekama, Koohyii laakkooɗa ee mi en súrgaciɗa wosin malaakaagari garoo, ");
INSERT INTO snf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ya woꞌꞌaroo an: «Pool kaa niik ndaga fu jomin kikaꞌ bi fu tuuk ga fíkíi buuꞌ Sesaaꞌ. Kooh oninndaa, ya hay kisom tumuuntii ɓuwii fu taam naɓaɗa ɓéeɓɓa ga giiyaa.» ");
INSERT INTO snf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kon ɓiƴaay, yëgísɗukat, mi abin yaakaaꞌ ga Kooh ee dii ya woꞌꞌookaɗa ƴahɗa kilaak deŋ. ");
INSERT INTO snf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","En kiꞌenaa, ɗu hay kihín ga dëk, waa giiyii wíil. ");
INSERT INTO snf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ga wekaa wudaaŋkaah na wu-nikiiswaa, lak uurisaa waa líssíi kimeeɓ ga ɗuuƴ giiyaa. Ga leeloo wek, ɓuwaa lëgëyi ga gaal-giiyaaɗa manɓa na ɗí deeyin kilaas kakay, ");
INSERT INTO snf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ɓa yoolla níꞌ kimalak huutlaataa, ennda meetaꞌ cidaaŋkaah-kaahay na ciyitnakanak. Ɓa kaꞌta bi ga fíkíi, ɓa yoolissa niꞌaa, ennda meetaꞌ cidaaŋkaah-kanak na ciyitnakaahay. ");
INSERT INTO snf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓa niikka gaal-giiyaa tapuk ga atoh, ɓa dalla kiwees bóoy cinikiis kidot gaal-giiyaa ga fenoo, lëehíꞌta ɓa yuŋnga ɓaa cúŋ daa Kooh wíisan. ");
INSERT INTO snf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ɓuwaa lëgëyi ga gaal-giiyaaɗa waaꞌsee kinúp ɓa foñ gaalaa, ɓa tummba fodii an ɓaa waaꞌ kidot gaal-giiyaa ga iñaa hanoh fíkíiɗa, ɓa yóoskíꞌta gaal-loocaa taamdohsi na gaal-giiyaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Wayee Pool woꞌꞌa soldaaraa yiyaak an: - Binaa ɓuwii ɓii tesussii ga gaal-giiyiinaa, ɗú múcoo. ");
INSERT INTO snf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Soldaaraa dalla kigúꞌ níꞌcaa pokohsee kiyool gaal-loocaaɗa, wa keennda ga giiyaa, dalla kinuuꞌ. ");
INSERT INTO snf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Lakanaa ɓa ɓaa sek Kooh wíis, Pool woꞌꞌa ɓuwaa an: - Laakin bes cidaaŋkaah na cinikiis ga wati caa ɗu yuŋ ɗu ñammbii dara. ");
INSERT INTO snf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kon diimaɗa mi woꞌꞌúu kiñam. En kiꞌenaa, ɗú waaꞌ kimúcaa ɗú jomin kiñam, ee mi woꞌissúu an gëmattoo: yíinoo garúu kufenci ɓooyukanndii. ");
INSERT INTO snf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ga waa ya woꞌꞌa fodaama bi ya lëehíꞌta, ya ɓeɓpa mbúurú, ya gërëmmba Kooh ga fíkíi ɓéeɓ, ya weella mbúuraa yaa ñam. ");
INSERT INTO snf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Waa ennda ɗa, ɓéeɓ ɓuwaa helcaagaɓa hannda kidal, ɓa aawwa kiñam ɓan. ");
INSERT INTO snf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ɓéeɓpíi ɗí enee ɓoꞌ ɓitéeméeꞌ-kanak na ɓidaaŋkaah-yitnaɓanak na ɓiyitniinoo ga gaalaa. ");
INSERT INTO snf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Daa ɓa ñamee bi ɓa kappa, ɓa aammba belaa gaalaa ɓayeeɗa ga giiyaa doonaa wa eref. ");
INSERT INTO snf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ga waa Kooh wíissa, ɓuwaa lëgëyi ga gaal-giiyaaɗa séennda kucolli-kakay na tewis wayee ɗekataama ɓa ínohoowa. Ɓa waaꞌta kiteeꞌnee gaalaa daama, en mínukaa. ");
INSERT INTO snf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓa pëkíssa iñcaa dotohsi gaalaaɗa, ɓa foñnjaca ga giiyaa. Ɓa gúꞌta níꞌcaa pokohsee dooraa fëeliri gaalaaɗa ɓan, ɓa lëríssa píisaa wiyaak hanohi fíkíi gaalaaɗa doonaa uurisaa mín kiyeꞌ gaalaa ɓa ƴee tewisaa. ");
INSERT INTO snf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Gaalaa nak koorohha ga daa músúcaa hídoh, wa looppa ga kakayfaa jaluk daamaɗa. Púkaa gaalaa yíppa, wa tuukka tek. Fenoogaanaa gaalaa nak aawwa kiƴëwísuk ndaga dúuscaa giiyaa tapukee ga na dooli. ");
INSERT INTO snf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Soldaaꞌcaa waarussa kiꞌap ɓuwaa amseeɗa ndaga ɓa niikee laak gaɓa ɓaa fiiy ga giiyaa, ɓa núp. ");
INSERT INTO snf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Wayee soldaaraa yiyaakyaa, lak waarin kisom Pool, ya kokohhaɓa kitum iñaa ɓa amɗa. Ya ebilla ɓuwaa mínin kifiiyɗa ɓa ɗeɓ kijafuk ga músúmaa, ɓa fiiy bi ga tewisaa. ");
INSERT INTO snf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ya woꞌꞌa ɓuwaa ɓíinoo mínsoo kifiiyɗa ɓa taam ga, ɓa ëbíluk ga haangacaa ƴëwísukoh ga gaalaaɗa wala póokéecaa gaalaa. Fodaama ɓéeɓ meƴca bi ga kakayfaa ee dara ocukkii gaɓa. ");
INSERT INTO snf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ga waa ɗí somolukohha ɓéeɓpíi ga giiyaa na jam, ɗí ɓaa han kiꞌínoh an dëkaama ɗí enoh, giiyaa wíilɗa teeku Malta. ");
INSERT INTO snf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ɓu-dëkaama teewussaríi kijof kiyaak. Ɓa fetiꞌtaríi kiwii kiyoonuk ndaga lak Kooh yaa toɓ ee fiyoonfaa yakin lool. ");
INSERT INTO snf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pool balaɓpa móofíꞌ-sookooñ kijaf ga kiwiikaa. Laakka goŋ-saamaanaa meyoh gawa ndaga tamohlaataa kiwiikaa, ñaakkari ga yah. ");
INSERT INTO snf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Daa ɓuwaa hotee gogaa yoolin ga yahaa Pool, ɓa ɓaa woꞌ ga díkaantiɓa an: - Ɓii yii jom kiꞌen apoh-ɓoꞌ sah-sah. Hídaa ga dii ya somalukohin ga kikaan ga giiyiiɗa tóoh, kikaan líssi kitaabuk. ");
INSERT INTO snf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pool nak wícca gogaa ga kiwiikaa ee dara dalliiri. ");
INSERT INTO snf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓuwaa sekka kihot ya úus bëm wala ya keen dal, ya kaan; wayee ga waa ɓa sekka bi maañnja, ee ɓa hottii dara dallii, ɓa abissa halaat wiliis, ɓa ɓaa woꞌ an: - Ɓii yii iñii Kooh! ");
INSERT INTO snf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ga yahaa daa ɗí eneeɗa, laakeera daama yoon wiyaak waa ɗíguunun, yoonaama Púbílíyus, yaa kuliyuk ga dëkaama giiyaa wíilɗa, yërí laakwa. Ya teerukkaríi ga kaanci, ya mínohharíi sagac iñaa leꞌ bes kaahay. ");
INSERT INTO snf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wiima lak paam Píbílíyus, síbíru na bíirtañi faaninndi ga fayaaŋ. Pool nak, kaꞌtari kiwaak, ya kíimmba Kooh, tíkkari yahcaagari, wëkíꞌtari. ");
INSERT INTO snf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Waa ennda ɗa, ɗúukoolíꞌcaa ɓíinoo ga dëkaama giiyaa wíilɗa hayussa ga Pool, ya wëkíꞌtaɓa ɓan. ");
INSERT INTO snf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ɓu-dëkaama giiyaa wíilɗa, iñaa en ɓéeɓ ɓa tumiꞌtaríiri, ee ga waa ɗí koluk kiƴahɗa, ɓa eewallaríi tóoh iñaa ɗí jom kisooluk ga ɓaawaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ɗí ennda ga Malta ñiin kaahay; ɗí hannda kiꞌaas gaal-giiyaa kúlkohee Aleksandarí ee wa ɓay nataalcaa Kastooꞌ na Poluksiɗa. Wa lahee ga kúlkaama giiyaa wíilɗa. ");
INSERT INTO snf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Waa ennda ɗa, ɗí teeꞌta ga teeraa Sírakus, ɗí tummba daama bes kaahay. ");
INSERT INTO snf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ɗí kolkohha daama ɗí aasissa ga gaal-giiyaa bi ɗí leꞌꞌa teeraa Resíyóo. Ga kooh-wíisfaa, uurisaa waa wëp. Ga besaa wukanakwaa tík gaɗa ɗí hannda kileꞌ Púsool. ");
INSERT INTO snf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ɗí hotta ɓuwaa gëmuunun ga Yéesu ga teeraama. Ɓa nak, ɓa kíimmbaríi kites naɓa bes ciyitnakanak. Lëehíꞌta, ɗí ammba waas Room. ");
INSERT INTO snf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kerceencaa dëku Roomɗa kelohussa an ɗí ɓaa hay, ɓa hayyaríi kitëebíluk bi ga «Marsaa Apíyus» na ɓan bi ga «Túuƴ-íikaꞌcaa kaahaycaa». Daa Pool hoteeɓa ya gërëmmba Kooh ee helci dalla. ");
INSERT INTO snf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ga waa ɗí leꞌ Roomɗa, Pool onussa kidëk ga kaan haŋci ya na soldaaꞌ yíinoo yaa watukanndi. ");
INSERT INTO snf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tíkka ga bes kaahay Pool ɓaylukka ɓuwaa kuliyuk ga yaawúuꞌcaa dëku Roomɗa. Daa ɓa hídírukohee, ya woꞌꞌaɓa an: - Mbokcii, mi abuunun ga teeraa Yéerúsaleem, mi tíkussa ga yah ɓu-Room, ɓaa kuliyuk ga dëkaaɗa ee lak mi laakohhii dara na heetiigaruu ee mi ɗeeŋngii baahcii ɓicaasammbuu. ");
INSERT INTO snf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ga waa ɓa meekissaroo kiꞌínoh kayohfaaɗa, ɓa waaꞌtaroo kiꞌíis ndaga ɓa hottii dara iñaa mi tum bi cal mi tíku kikaan. ");
INSERT INTO snf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Wayee yaawúuꞌcaa sagussa. Mi nak, mi kíimmba kipaafdohu ga Sesaaꞌ, buurii ɓu-Room, ya attiꞌꞌoo. Mi waaꞌtii kiyam heetiigoo ga dara. ");
INSERT INTO snf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Iñaama tah mi kíimmba kihotoh narúu bi mi saawal narúu. En kiꞌenaa, ɗu ɓu-Isarayeel, iñii ɗu am yaakaaꞌ gariɗa yërí tahhoo kiɓagu na ceen. ");
INSERT INTO snf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓuwaa taassari an: - Ɗí ga kihaffíi, ɗí laassii këyít fíinoo faa meyoh kúlkaa Yúudée woꞌ ga loofu ee laakkii yíinoo ga mbokcaagaríi daama, yaa hay dii kiɓéestí yibóníꞌ garaa. ");
INSERT INTO snf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ɗí nak, ɗí waarinndaa kisúkúruk, fu woꞌꞌíi iñum fu halaatɗa. En kiꞌenaa, ɗí ínohin an waasum fu taabukɗa yewinin ɓuwaa woꞌi yibóníꞌ gawa. ");
INSERT INTO snf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ɓa ammba bes wiliis waa ɓa hídohan. Besaa bëríi, ɓa hayya ɓiyewin bi ɓa wëñnja ga waa ɓa ɗeɓ kihayɗa. Saawalaagaɓa daloh ga kímaa bi ga noh-soosaa. Pool woꞌꞌaɓa iñaa ya gëmɗa, ya yéegallaɓa Nguuraa Kooh, ya koorohha ga iñaa bídu ga Këhítfaa Waasii Móyíisɗa na caa woꞌeencaa sëldíiga-Koohcaa, ya yaa heelɓa kiɓúl, ɓa gëm ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ɓii gëmussa iñaa Pool woꞌɗa, ɓíinoo sagussa kigëm. ");
INSERT INTO snf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ga waa ɓa waaꞌ kitagoh na Poolɗa, lakanaa ɓa júwohhii ga ɗuuƴɓa bi wati. Pool nak tíkka ga woꞌꞌaɓa an: - Helii yiselaꞌíꞌyii daal woꞌee na ɓicaasammbúu kayoh ga waa ya woꞌ koorohha ga kúuwkaa Ísayíi, sëldíiga-Koohaaɗa. ");
INSERT INTO snf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ya woꞌee an: «Karaa ga heetaama, fu woꞌɓa an: Ɗú hay kisúkúruk dijófíꞌ wayee ɗú ínohanndii dara. Ɗú hay kimalak dijófíꞌ wayee ɗú hotanndii dara, ");
INSERT INTO snf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","En kiꞌenaa, heetii wii nam kitúl keeñ hen. Ɓa lagin nofciigaɓa, ɓa ɗúugin hasciigaɓa, doonaa ɓa hotoo na hasɓa, ɓa kelohoo na nofɓa, Ee ɓan ɓa ínohoo ga keeñɓa En ɗanaa, ɓa ëewrukoo garoo, mi Kooh, bi mi wëkíꞌɓa.» ");
INSERT INTO snf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pool tíkka ga an: - Ínohat gaka an Hewhewii winéwíꞌwii onohi kipesɗa yéegalohuunun bi ga ɓuwii enussii yaawúuꞌɗa ee ɓa, ɓa hay kisúkúruk.  ");
INSERT INTO snf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ga waa Pool woꞌ woꞌeencaama bi ya lëehíꞌtaɗa, yaawúuꞌcaa ɓaa ƴah, ɓa ɓaa weeraanti ga ɗuuƴɓa. ");
INSERT INTO snf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Iñaa leꞌ tíkíis tanak Pool eninta ga kaanfaa ya fayi faama ee ɓéeɓ ɓuwaa hayeeri kiwaakɗa laakeeri daama. ");
INSERT INTO snf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ya yaa yéegaloh Nguurii Kooh, ya yaa jëgíroh loo Yéesu Kiristaa, Haꞌmudii na fít wiyëgísíꞌ ee ken mossiirika kihoonoh. ");
INSERT INTO snf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mi Pool, mi súrga Yéesu Kiristaa, mi yërí bínndúu këyítfii fii ɗú ɓu-Room. Kooh yërí ɓayyoo kiꞌen apotaaꞌci, mi faanɗussari haŋ kiyéegalohnee Hewhewii winéwíꞌwii. ");
INSERT INTO snf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Hewhewii winéwíꞌ wiima nak, Kooh dígoheerawa kumëeñíꞌ ga Këyítfaa ee koorohee ga túuwtaa sëldíigacaagari. ");
INSERT INTO snf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Wa woꞌ loo Kowukiigari, Yéesu Kiristaa, Haꞌmudiigaruu. Ga kiɓoꞌ-súusúuskaagari, ya límukoh ga níilaa buuꞌ Dëwít, ee ga Helaa yiselaꞌíꞌyaa, Kooh ga doolaagari teewohha an ya Kowuci ga waa ya mílísɗu ga ɓuwaa kaaninɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kooroh gari nak, Kooh onndaroo kiꞌen apotaaꞌ, doonaa ga teekii Kiristaanii mi nook heetcii ga ëldúnaɗa tóohca, ca gëm gari, ca taabuk iñaa nakohu kitumɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Dú ɓu-Room, ɗú bok ga, ndaga Kooh ɓayinndúu kibok na Yéesu Kiristaa. ");
INSERT INTO snf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kon mi bínndúu këyítfii fii ɗú ɓéeɓpúu. Ínohat an ɗú neɓlohin Kooh ee ya ɓayinndúu ɗú en ɓuuci. Kooh, Paamudiigaruu na Yéesu Kiristaa, Haꞌmudii barkeelattúu ee ɓa onndúu jam. ");
INSERT INTO snf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kon bi mi dalaa, mi ɗewan kigërëm Koohyiigoo garúu ɓéeɓpúu paaƴ, ee kooroh ga Yéesu Kiristaa ndaga síwin daa en ɓéeɓ ga ëldúna an ɗú gëmin gari. ");
INSERT INTO snf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kooh ínohin an mi woꞌ kayoh, ya yii mi jaamuki ga keeñnjoo ga kiyéegaloh Hewhewii winéwíꞌ wii woꞌ ga loo Kowukiigariɗa. Ya ínohin an wahtaa en tóoh helloo kaꞌ garúu. ");
INSERT INTO snf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ee mi dëk ga kikíimmbi ya onndoo hal en neɓpinaa, mi mínndúu kihay kiwaaknee. ");
INSERT INTO snf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","En kiꞌenaa, mi waarin garúu kihay lool bi mi leꞌdoh garúu barkicii Helii yiselaꞌíꞌyii onohiɗa, en ɗanaa ngëmiigarúu wëñ kiyëgís. ");
INSERT INTO snf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mi waaꞌ kiwoꞌ sah man, ɗu ɓéeɓpuu, ɗu daasoh ga ngëmii ɗu bok kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mbokciigoo, ínohat an bes ciyewin mi abinndúu kihay kiwaaknee, wayee bi wati mi laakkii hal. Mi waarin nak kihay kilëgëy ga ɗuuƴcúu, bi jeriñ meƴ ga, fodaa daa mi tum ga ɗuuƴ ɓuwaa ga dëkcaa cíinooɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kooh sasinndoo kilëgëy, kon mi jomin kiyéegaloh Hewhewii winéwíꞌwii ga ɓéeɓ ɓuwii. Mi haywa kiyéegalohnee ga ɓuwaa helcaa yúudukin ga ëldúnaɗa, bi ga ɓaa helcaa yúudukkiiɗa. Mi haywa kiyéegalohnee ga ɓuwaa jaginɗa na ɓuwaa jagussiiɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Iñaama tah mi waarin lool kihay kiyéegalohwa garúu ɓan, ɗú ɓii ɗú en ga Roomɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","En kiꞌenaa, mi safarin ga kiyéegaloh Hewhewii winéwíꞌwii. Doolii Kooh wërí en ga ɗuuƴwa, wa músali ɓéeɓ ɓuwii gëm ga Yéesu Kiristaaɗa, ennda yaawúuꞌcii ga iñaa ɗeɓɗa, tíkka ga ɓii enndii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Hewhewii winéwíꞌwii wiima teewoh daa Kooh tíki ɓiɓoꞌ, ɓaa gëm kesi ga Yéesu Kiristaa, ɓa en ɓiɓoꞌ ɓijúwí ga fíkíiciɗa. Iñaama waaꞌ kiwoꞌ an waas wiliis laakoo. Ee fodaama, ka bídu ga Këyítfaa an: «Ɓaa gëmaa, Kooh hayyi kiꞌaboh fodii ɓoꞌ yijúwíꞌ ga fíkíici, ee ya pesan kayoh-kayohɗa.» ");
INSERT INTO snf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","En kiꞌenaa, Kooh teewohin bi leerin, aboh ga ɗook an ya aylukin ndaga ɓuwii faaliꞌiiri ee ɓa júɓpii. Ɓa úubin kayohfii na kijúɓpiikiigaɓa. ");
INSERT INTO snf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kooh hayɓa kiꞌattiꞌ ndaga waasii ɓa jom kikooroh bi ɓa ínoh Koohɗa leerin ga hafɓa, Kooh teewinɓawa bi leerin lañ. ");
INSERT INTO snf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","En kiꞌenaa, doolii Kooh leehoo taaꞌɗa na dii ya manɗa nam kiꞌen iñcaa hotukoo na kuhas. Wayee ga iñaa ya sakee ëldúna bi wati, fu malak ga iñcii ya sakɗanaa, hel míninndaaca kiteeɓ. Kon nak ɓuwii laakoo lay ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ɓuwii ínohuunun Kooh ee ɓa erussiiri ndam ee ɓa gërëmmbiiri fodaa daa ɓa jommbika kitumiꞌɗa. Iñcii ɓa halaati ëewdohɓa ëgíraaɗa cërí múuyíꞌɓa ee keeñciigaɓa búumin, ɓa enin ga ñúus. ");
INSERT INTO snf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ɓa tík hafɓa ɓuwaa ñaañuunun ee ɓa ɓidof kesi. ");
INSERT INTO snf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ɓa aawwii kijaamuk Kooh yii laak ndam ee kaanooɗa, ɓa nammba kiꞌaaw kijaamuk nataal ɓoꞌ-súusúus yii kaaninɗa, sel, júuꞌ, na fasukohcii. ");
INSERT INTO snf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kërí tah, Kooh foñinɓa ga iñaa neɓɓa, ɓa enukohin ga iñcaa moroo, ɓa ɓii tum ga faanciigaɓa iñcaa apohin kaci. ");
INSERT INTO snf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓa jafin kayohfii Kooh, ɓa taabuk saboh. Ɓa aawin kijaamuk na kitaabuk iñcii Kooh sakɗa, ɓa foñnja Kooh yii sak tóohɗa. Ya kañsat bi taaꞌ! Aameen. ");
INSERT INTO snf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kërí tah Kooh foñohinɓa ga tumeencumgaɓa ciꞌapohíꞌ kacicaa ɓa ɗuucukohɗa. Ɓeticiigaɓa foñuunun ƴaalcii, ɓa faanuki kiƴaal na ɓeti ga díkaantiɓa. ");
INSERT INTO snf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ƴaalcii ɓan tumsin fodaama, ɓa faanuki kiɓeti na ƴaal ga díkaantiɓa, ee faanɓa tamoh rek kifaanuk na ɓimooroomɓa. Ƴaal tumi na ƴaal mooroomci iñaa joffii, fodaama ɓa nooki ga ɗookɓa fayaa gën ga kimúuƴkaagaɓa kaamaɗa. ");
INSERT INTO snf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Waa ɓa tookkii kiꞌínoh Kooh, Kooh foñohinɓa na hel-ŋalaañukohaagaɓa waama ee ɓa dëk ga kitum iñaa tumkoo. ");
INSERT INTO snf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Keeñɓa líif na kijúɓpii, kibon, kiwaaꞌ kihëpíꞌ na kisoot. Ɓa halaati kiꞌiñaan doŋ, kiꞌap ɓoꞌ, kiñaroh, kiñaañukoh ɓoꞌ, kiꞌóolukoo ken, kiɗooɓ ɓoꞌ, ");
INSERT INTO snf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","kiyah teek ɓoꞌ, kisagoh na Kooh, kiñak kikoruk, kiɓëwíꞌ hafɓa, kindamuk, kimoroo ga nof, kitookoo kikelohiꞌ paamun na eemun. ");
INSERT INTO snf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ɓa laakoo hel, ɓa enndii goꞌ, ɓa waaꞌtii ken, ɓa laakoo yërmaandi ga ken. ");
INSERT INTO snf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ɓa ínohin dijófíꞌ daa Kooh ƴah kitum ɓuwaa man fodaamaɗa. Ɓuwaa tumi iñcaamaɗa, Kooh hayɓa kiꞌattiꞌ kikaan ee hoonohhii bi wati ɓa dëk ga kitum iñcaa. Ɓaatta ga, ɓa faꞌ na ɓuwaa tumi iñcaamaɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kon nak, fu yii fu attiꞌi mooroomfuɗa, na ɓaa fu mín kiꞌen tóoh, ínohaa an fu laakoo lay ga fíkíi Kooh. Ndaga iñaa fu attiꞌoh mooroomfu an ya tummbiɗa, fu ɓan fu tumiri. Kon nak fu ɓúukin haffu, fu yii fu attiꞌ mooroomfuɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ɗu ínohin ɓéeɓpuu an attiꞌaa Kooh attiꞌ ɓuwaa tumi iñcaamaɗa kooꞌ ga waas. ");
INSERT INTO snf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Fu yii fu attiꞌi mooroomfu ga iñcaa ya tumiɗa, ee fu ga kihaffu fu tumicaɗa, fu fooŋ an Kooh abohanndiiraakane? ");
INSERT INTO snf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Mín kiꞌen sah an fu faaliꞌoo Kooh ndaga daa ya jofin lool, ee ya míninndaa kimúuñiꞌ ee ya gaawtukoo. Fu ínohoo moos an ya teeɓpaa kijofaa, ya waaꞌ fu hot iñaama, fu súpít kipesfune? ");
INSERT INTO snf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Wayee fu yaama fu yëgís ga haf kak, fu saŋ kisúpít kipeskaagaraaɗa, fu yaa nëgíroh ga ɗookfu aylukaa Kooh bi ga besaa ya ƴah kiꞌattiꞌ ɓéeɓɗa, ee kooran ga waas. ");
INSERT INTO snf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Leꞌ bëríinaa, ɓaa en ɓéeɓ Kooh hayyi kifay iñaa ya lëgëyɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ɓuwii taabuk kitum yijófíꞌɗa, ɓa waaꞌ kilaas ndamaa meyoh ga Koohɗa, ɓa neɓloh Kooh, kipesɓa leehoo ee fodaama Kooh hayɓa kiꞌon ɓa pes nari bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Wayee ɓuwaa ɓíinoo, ga kiwaaꞌti kiheñoh rek, ɓa onnda kayohfaa bíiŋ, ɓa ɓaa tumi ga iñaa joffii. Ɓuwaama nak, Kooh hayɓa kiꞌayluk, saŋkuꞌɓa. ");
INSERT INTO snf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ɓéeɓ ɓuwii tumi yibóníꞌɗa hay kikeenu ga coonu ciméeskíꞌ ee ɗewohan ga yaawúuꞌcii, tík ga ɓuwii enussii yaawúuꞌɗa ɓan. ");
INSERT INTO snf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Wayee ɓuwii tumi yijófíꞌɗa Kooh hayɓa kiꞌon ndam, ya hay kiwoꞌ yijófíꞌ gaɓa, ya hayɓa kiꞌon jam. Ya hay kitum fodaama, ɗewoh ga yaawúuꞌciinaa, tík ga ɓuwii enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ɓuwii ɓéeɓ ɓa wíinoo ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ɓuwii enussii yaawúuꞌɗa ínohsoo iñii Waasii Móyíis nakoh kitumɗa. Ɓa keeni ga kitum iñaa joffii anee rek. Ɓa nak, ɓa hay kiꞌattiꞌu ɓa saŋkuꞌuk, wayee attiꞌaagaɓa ayukanndii ga Waasii Móyíis. Ɓuwii ínohu iñii Waasii Móyíis nakoh ee ɓa këldúkiwaɗa, attiꞌaagaɓa ayukan ga Waasii Móyíis. ");
INSERT INTO snf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kooh ƴahhii ken kiꞌaboh ɓoꞌ yijúwíꞌ ga fíkíici ndaga daa ɓaama eem rek ga kisúkúruk iñaa Waasii Móyíis nakoh kitumɗa. Ɓaa taabukin iñcii Waasii Móyíis nakoh kitumɗa, yërí Kooh ƴah kiꞌaboh fodii ɓoꞌ yijúwíꞌ ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","En kiꞌenaa, ɓuwii enussii yaawúuꞌ ee ínohsoo Waasii Móyíisɗa, binaa ɓa tum iñcii Waasii Móyíis nakohɗanaa, man na ɓa laakca ga ɗuuƴɓa luu enee an ɓa hottiica. ");
INSERT INTO snf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Fodaama ɓa teewohin an iñcaa ɓa tumi ee Waasaa nakohɗa bídu ga keeñcaagaɓa. Helɓa tookin iñaama ee ɓan halaatcaagaɓa, cíinoo hayaa yabiɓa ga yen, wala somiɓaɗa, teewohinka. ");
INSERT INTO snf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Bes waa hay, halaatcii ɗaakuk ga ɗuuƴ keeñciiɗa hay kimeƴdohu faŋ ee Kooh hay kiꞌattiꞌ ɓuwii kooroh ga Yéesu Kiristaa. Iñaama, Hewhewii winéwíꞌwii mi yéegalohɗa, wërí woꞌka. ");
INSERT INTO snf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Fu nak, fu yii fu taas ga teekii yaawúuꞌɗa, fu ayuk ga Waasii Móyíis, fu maruki ga iñaama an fu ɓoꞌ Kooh. ");
INSERT INTO snf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Kon fu ínohin iñaa Kooh waaꞌɗa, ee Waasii Móyíis jëgírinndaa tóoh iñaa laakin solu. ");
INSERT INTO snf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Fu fooŋ an fu ɓayin tuhas ee fu yërí ƴah kinook búumíꞌcii. Fu fooŋ an fu yërí en leeꞌlaatii ɓuwii enu ga ñúusɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Fu fooŋ an fu yërí jom kijëgíꞌ ɓuwii ínohsoo daraɗane? Fu fooŋnga ɓan an fu yërí jom kijëgíꞌ ɓéeɓ ɓuwii han kiꞌaas ga ngëmiiɗa, ndaga fu yaakaaꞌ an waasii oninndaa kilaak kayoh ga tóoh na kiꞌínoh tóohe?. ");
INSERT INTO snf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kon fu yii fu jëgíri ɓuwii ɓíinooɗa, iñii tah ya fu jëgíroo haffu? Fu jaŋngati ɓuwii ɓíinoo an ɓa hanat kilok. Kon iñii tah ya fu loki?. ");
INSERT INTO snf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Fu woꞌi ɓuwii an ken hanat kiɗúk ɓetici wala ƴaalci, ya faanuk na ɓoꞌ yiliis. Kon iñii tah ya fu tumika? Fu woꞌ an fu gëmmbii ga koof, kon iñii tah ya fu kolukaa fu loki iñcaa ɓuwaa sarahohi ga koofcaaɗa? ");
INSERT INTO snf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Fu ndamuk kiꞌínoh iñii Waasii Móyíis nakoh kitumɗa, wayee fu tooñ Kooh, ndaga iñcii fu tumiɗa taammbii ga iñaa Waasaama nakohɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","En kiꞌenaa, bíduunun ga Këyítfaa fodaama an: «Ɗú yaawúuꞌcii, ɗú ɓërí tah ɓuwii enussii yaawúuꞌɗa woꞌsi ga teekii Kooh iñaa joffii». ");
INSERT INTO snf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","En kiꞌenaa, kigúruk jofin en lak fu taabukin iñii Waasii Móyíis nakohɗanaa. Wayee fu taammbii ga iñii Waasiima nakohɗanaa kigúrukkaagaraa laakoo jeriñ. ");
INSERT INTO snf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ɓaa gúrukkii, binaa taabuk iñii Waasii Móyíis nakoh kitumɗanaa, hídaa ga daa ya gúrukkiiɗa tóoh, Kooh hayyi kikíndoh ga ɓuwaagari. ");
INSERT INTO snf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ínohaa an ɓaa gúrukkii ee ya taabuki dijófíꞌ iñii Waasii nakohɗa, hayyaa kiꞌattiꞌ fu yii fu en yaawúuꞌ, fu gúrukin, fu laasin ga iñcaa këyítcaa Waasii Móyíis nakoh ee fu taabukoocaɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","En kiꞌenaa, kiꞌen yaawúuꞌ enndii iñaa hotuki ga ɓoꞌ ee kigúruk kayoh-kayohɗa enndii mandargaa hotuki ga faanɗa. ");
INSERT INTO snf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kiꞌen yaawúuꞌ kayoh-kayohɗa, eni ga ɗuuƴ keeñ, ee kigúruk kayoh-kayohɗa, kërí en kigúrukkaa Helii yiselaꞌíꞌyii tumi ga keeñɗa, enndii kigúrukkaa bídu ga këyítɗa rek. Yaawúuꞌ, yaa man fodaama, Kooh yërí ƴahhi kindam wayee enndii ɓoꞌ-súusúus. ");
INSERT INTO snf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","En fodaamanaa, kon kiꞌen yaawúuꞌ ɓaat ya ga ɓoꞌ? Kigúruk laakiꞌ ɓoꞌ ya jeriñ? ");
INSERT INTO snf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Daa mín kiꞌen tóoh, jeriñaa gaɗa yakin. Ee waa kuliyuk gaɗa, wërí en ga dii woꞌeenii Kooh ɗewee kiwosohu gaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","En kiꞌenaa, laakin gaɓa, ɓaa enndii goꞌ. Diima nak ya? Kiꞌenndii-goꞌkaagaɓa kaama mín kihoonoh Kooh kiꞌen gore? ");
INSERT INTO snf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Múk, iñaa ɓoꞌ jom kiꞌamɗa kay, wërí en an Kooh dëk ga kayoh ee ɓoꞌ-súusúus dëk na saboh. Fodaama, ka bídu ga Këyítfaa an: «Kijúɓkiigaraa hotukan ga woꞌeencii fu meƴdoh kiꞌattiꞌ ɓuwiiɗa, ee ɓaa fu attiꞌ ɓéeɓ, fu laak kayoh ga ɗookci». ");
INSERT INTO snf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","En an kijúɓpiikiigaruu teewohi an Kooh júwinaa, ɗú woꞌ ya ga iñaama? Ɗú woꞌ an, binaa Kooh íif aylukaagari ga ɗookkuunaa lak ya júɓpii hene? En kiꞌenaa, iñii yii mi woꞌꞌi fodii ɓuwii woꞌikaɗa. ");
INSERT INTO snf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Múk, iñaama mínukoo. Haa en an Kooh júɓpiinaa ya mínan na kiꞌattiꞌ ɓu-ëldúna? ");
INSERT INTO snf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Hay kilaak ɓuwaa woꞌ an, «En sabohfiigoo on kayohfii Kooh kiwëñ kisíw na kilaak ndamaa, iñii tah ya mi lísi kitíku tumoh-baakaaꞌ?» ");
INSERT INTO snf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ɓíinoo hay kikaꞌ bi ɓa woꞌ an: «Ɗu tumat yibóníꞌ en ɗanaa yijófíꞌ mín ga kimeƴ.» Laakin ɓuwaa pokiꞌtíi kiwoꞌ an ɗí jëgíroh iñaama. Ɓuwaa woꞌ iñaamaɗa, Kooh hayɓa kiꞌattiꞌ ee kooran ga waas. ");
INSERT INTO snf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kon, ɗu jom ya kiwoꞌ? Ɗu yaawúuꞌcii ɗu ɓërí gën ɓuwii enussii yaawúuꞌɗa ga fíkíi Koohe? Múk! En kiꞌenaa, ɗu teewohin an yaawúuꞌcii na ɓuwii enussii yaawúuꞌɗa tóoh, ɓéeɓɓa ɓiñaam-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Iñii yii yërí bídu ga Këyítfaa an: «Laakoo ɓoꞌ yijúwíꞌ, enndii sah yíinoo ");
INSERT INTO snf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Laakoo ɓaa laak hel, yíinoo heellii kiꞌínoh Kooh, ");
INSERT INTO snf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ɓéeɓɓa foñuunun Waasii Kooh, ɓéeɓɓa sooyuunun. Laakoo ɓoꞌ yaa tumi yijófíꞌ, enndii sah yíinoo. ");
INSERT INTO snf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Golgolciigaɓa en fan loyaa úbísukin, peremciigaɓa ɓeedukin ga kiɗúk ɓoꞌ, woꞌeencii meyi ga kúuwɓaɗa soot fan daŋaꞌ goŋ. ");
INSERT INTO snf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Túuwtiigaɓa líif na coñ na woꞌeen cibóníꞌ doŋ. ");
INSERT INTO snf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Kotɓa gaaw ga kiꞌapnee ɓoꞌ rek. ");
INSERT INTO snf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Daa ɓa kooroh tóoh, ɓuwaa fiipohi. Ɓa soki kofeel. ");
INSERT INTO snf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ɓa ínohoo waasaa haydohi jam. ");
INSERT INTO snf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kiniik Kooh paallii fen ga keeñɓa.» ");
INSERT INTO snf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ɗu ínohin an tóoh iñaa Waasii Móyíis woꞌin, woꞌ aaw ga ɓuwii jomwa kitaabukɗa. En ɗanaa ken laakoo iñaa ya woꞌan, ee ken ga ëldúna laakoo lay ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kërí tah laakanndii ken ɓaa abohsan ɓoꞌ yijúwíꞌ ga fíkíi Kooh ga kitaabuk Waasii Móyíis. Waasii Móyíis, en kiꞌenaa, on ɓuwii kiꞌínoh rek an ɓa tumin baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Diimaɗa nak, Kooh teewin ɓuwii daa ɓa jom kikooroh bi ɓa abohu ɓiɓoꞌ ɓijúwíꞌ ga fíkíici ee enoo ga Waasii Móyíis. Iñaama, Waasii Móyíis na sëldíiga-Koohcaa teewohseeraka. ");
INSERT INTO snf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Kooh aboh ɓuwii ɓiɓoꞌ ɓijúwíꞌ ga fíkíici ndaga ga dii ɓa gëm ga Yéesu Kiristaaɗa. Ɓéeɓ ɓuwii gëmɗa ya abohɓaɗa, ndaga ɓuwii ɓéeɓ, ɓa wíinoo ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","En kiꞌenaa, ɓéeɓ ɓuwii ɓërí tum baakaaꞌ, ee ɓa meƴdohin hafɓa ga ndamaa Kooh. ");
INSERT INTO snf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Wayee Kooh, ga yërmaandaagari, onndaɓa kiꞌen ɓiɓoꞌ ɓijúwíꞌ, ee ya meekissiiɓa dara ga. Ya koorohhaka ga Yéesu Kiristaa, yaa ɓëgísɓa ga baakaaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kooh erohhi fodii sarah júwohiꞌtuu na hafci, ya sétíꞌ na ñífaa ya aamɗa baakaaꞌcii ɓuwii gëminɗa. Sarahaama teewoh an Kooh mos kijúɓ. Ya taabukéeríi ɓuwaa baakaaꞌcaa ɓa tumee kuɗewaaɗa, ");
INSERT INTO snf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ndaga ya gaawtukéeríi dara ga. Diima nak ya teewohin bi leerin an ya júwin ee ɓaa gëm ga Yéesunaa, ya hayyaa kiꞌaboh ɓoꞌ yijúwíꞌ ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kon laakin iñaa ɓoꞌ bakukohan ga fíkíi Koohe? Dara! Haa iñii tahkaɗa ya? Iñaa tahkaɗa wërí en an iñaa wëñ kilaak soluɗa enndii iñcii ɗu tumi fodaa waas nakohkaɗa, wayee kigëm ga Yéesu. ");
INSERT INTO snf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","En kiꞌenaa, Ɗu mínin kiwoꞌ an Kooh abinnduu ɓoꞌ ɓijúwíꞌ ga dii ɗu gëmin ga Yéesuɗa, wayee ya abohhiiruu ɓoꞌ ɓijúwíꞌ ndaga dii ɗu tumin iñaa Waasaa Móyíis nakohɗa. ");
INSERT INTO snf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Wala book Kooh nam kiꞌen Kooh yuu yaawúuꞌcii doge? Kooh enndii Kooh yuu ɓuwii enussii yaawúuꞌɗa hene? Ahaŋ kay, Kooh yuu ɓuwii enussii yaawúuꞌɗa ɓan! ");
INSERT INTO snf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kooh yíinoo doŋ yërí laak, ee ya yërí abohi yaawúuꞌcii ɓiɓoꞌ ɓijúwí ga fíkíici ndaga ngëmaa ɓa ɓayɗa, ee ya aboh ɓuwii enussii yaawúuꞌɗa ɓiɓoꞌ ɓijúwíꞌ ga fíkíici ndaga ngëmaa ɓa ɓayɗa ɓan. ");
INSERT INTO snf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ngëmii ɗu laak ga Yéesuɗa nëewís Waasii Móyíis hene? Múk, hanaa kay ɗu namwa kiyëgísíꞌ ga iñaa wa enɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kon, ɗu ɓeɓ caasammbuu Abarahamaa, ga kiɓoꞌkaagari, iñii yiida yërí ɗú mín kiwoꞌ ga looci? ");
INSERT INTO snf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Enee an Kooh abeeri ɓoꞌ yijúwíꞌ ndaga iñcaa ya tumeeɗanaa, eneenaa Abaraham mín kilaak iñaa ya ndamukan ga. Wayee ya mínéeríi kindamuk ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","En kiꞌenaa, bídu ga Këyítfaa an: «Abaraham gëmmba ga Kooh, ee ga iñaama Kooh abohhari ɓoꞌ yijúwíꞌ.» ");
INSERT INTO snf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mon ɗú ínohin an ɓaa lëgëyaa laas fayaagari. Iñaa ya fayu yaama enndii iñaa ya onu hen, wayee ya laas anagaagari. ");
INSERT INTO snf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ɓoꞌ yaa ga, ya tíkkii yaakaaꞌci ga kitum iñaa júwin wala iñaa júɓpii, wayee ya gëmin ga Kooh, yii mín kiꞌaboh ɓoꞌ, yaa faaliꞌii Kooh fodii ɓoꞌ yijúwíꞌ ga fíkíiciɗa. Ngëmaagari waama hay kitah bi Kooh abohhi ɓoꞌ yijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dëwít ɓan woꞌee iñaama ga loo daa Kooh abohi ɓoꞌ, ɓoꞌ yijúwíꞌ ga fíkíici ee ya malakoo ga iñcaa ɓaa tumiɗa: ɓaa manɗa, yewinuunun múuꞌ. ");
INSERT INTO snf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ya woꞌee an: Yewinin múuꞌ ɓuwaa Kooh bayal tooñcaagaɓa ee nísin baakaaꞌcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Yewinin múuꞌ ɓuwaa Kooh malakkii baakaaꞌcaagaɓaɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kiyewin-múuꞌkaama, Dëwít woꞌeeɗa, kuu ɓuwii gúrukɗa ɓa haŋɓane? Ɓuwii gúrukussiiɗa bokussii gane? Ahaŋ kay, ɗu han kiwoꞌ karam an Kooh abohha Abaraham ɓoꞌ yijúwíꞌ ndaga Abaraham gëmee gari hen. ");
INSERT INTO snf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kon ga waa Kooh aboh Abaraham ɓoꞌ yijúwíꞌɗa, laak Abaraham gúrukinoo, gúrukkii? Mon lakanaa ya gúrukkii duum. ");
INSERT INTO snf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kigúrukkaa Abaraham tumeeɗa enee mandargaa teewoh an ya gëmin ga Kooh kumëeñíꞌ ee Kooh abohinndi ɓoꞌ yijúwíꞌ kumëeñíꞌ. Iñaama nak yërí tah Abaraham en caasamunii ɓuwii gúrukkii ɓéeɓɓa ee gëmuunun ga Koohɗa. Ee fodaa Abaraham, Kooh abohin ɓuwii ɓiɓoꞌ ɓijúwíꞌ ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ee ɓan Abaraham, caasamun ga ɓuwii gúrukuunun ee ɓa eemmbii ga kigúruk doŋɗa. Ee ɓa gëmin ɓan fodaa daa Abaraham gëmee kuɗewaa lak ya gúrukkii duumɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kuɗewaa Kooh díŋnga Abaraham na tucaasamuntaagari an ya hayɓa kiꞌon ɓa lam ëldúna. Iñaama Kooh dígohéeríiri ndaga Abaraham taabukee Waasii Móyíis, wayee dígohhi daa Abaraham gëmin gari ee ya Kooh abohinndi ɓoꞌ yijúwíꞌ ga fíkíiciɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Enee an ɓuwii taabuk iñcii Waasii Móyíis nakohɗa ɓërí ƴah kilaas ga iñaa Kooh dígohɗanaa, kon eneenaa ɓuwii gëm ga Koohɗa, gëmsan sooƴ ee eneenaa iñaa Kooh dígohɗa enan sooƴ ɓan. ");
INSERT INTO snf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","En kiꞌenaa, waasii wërí fet aylukaa Kooh ga ɗook ɓuwii taabuksoo iñaa wa nakoh kitumɗa. Ee daa waas gaa ga, kiɗeeŋ waas laakoo daama. ");
INSERT INTO snf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Fodaama iñaa Kooh dígohɗa, kigëm doŋ kërí onohiwa. Kooh yërí onoh iñaama ee ya sekkii fay ga. Iñaa dígohu yaama ɓéeɓ tucaasamuntii Abaraham tërí laakwa. Eemmbii ga ɓuwii taabuk iñii Waasii Móyíis nakohɗa doŋ, wayee leꞌin bi ga ɓuwii ɓíinoo gëmu ga Kooh, fodaa caasammbuu Abaraham gëmeeɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Fodaama, bíduunun ga Këyítfaa, Kooh woꞌꞌa (Abaraham) an: «Mi tuminndaa caasamun heet ciyewin.» Yërí en caasammbuu ga fíkíi Kooh, yii ya gëm gari, ya yii mílísɗi ɓuwii kaaninɗa ee saki iñaa mosoo kilaakɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abaraham gëmmba ga Kooh, ammba yaakaaꞌ gari ee lak sah ɓuwii ɓíinoo foogu an yaakaaꞌ leehin. Ee fodaama ya ennda caasamunii heet ciyewin fodaa Kooh woꞌeerikaɗa an: «Tucaasamuntiigaraa hínsan anee kiyewin.» ");
INSERT INTO snf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ee ga wahtaa Kooh woꞌohhi iñaamaɗa, lak Abaraham deeyin kilaak tíkíis titéeméeꞌ. Ya ínoheera an ya kasohin ee Saaraa ɓetici mínoo kilaak kowu, wayee ya líssa kiꞌam yaakaaꞌ ga Kooh an yaama hay kitum iñaa ya díŋngiɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ya ínoheera an ya hay kilaas ga iñaa Kooh díŋngiɗa ee ya laakkii hel kanak ga iñaama. Ngëmaagari nammbari kiɓaat sah dooli ga waas Kooh ee ya yaa kañi Kooh. ");
INSERT INTO snf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Wóoreerari an Kooh laakin dooli kitum iñaa ya díŋngiɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Iñaama tah Kooh abohhari ɓoꞌ yijúwíꞌ ga fikíici. ");
INSERT INTO snf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Wayee woꞌeenaama bídu ga këyítfaa an: «Ya abohussa ɓoꞌ yijúwíꞌɗa», bídussii wa eemmba gari. ");
INSERT INTO snf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wa bíduunun, paaffa bi garuu, ɗu ɓii ɗu gëmin ga Kooh yii mílísiꞌ Yéesu, Haꞌmudiigaruu ga kikaanɗa. ");
INSERT INTO snf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yéesu yaama erohsee ya apussa ndaga baakaaꞌciigaruu. Lëehíꞌta Kooh mílísiꞌtari en ɗanaa Kooh abohhuu ɓoꞌ ɓijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kon nak Kooh abohinnduu ɓiɓoꞌ ɓijúwíꞌ, ndaga ngëmii ɗu laakɗa. Diimaɗa, ɗu laakin nari jam ee kooroh ga Yéesu Kiristaa, Haꞌmudiigaruu. ");
INSERT INTO snf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yërí onnduu kilaas ga yërmaandii Kooh ɗu enoh wati, ee kooroh ga ngëmii ɗu laakɗa. Yërmaandaa waama ɗu aasin ga ee keeñnjuu soosin ga ndaga ɗu yaakaarin kibok ga ndamaa Kooh. ");
INSERT INTO snf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Eemmbii ga iñaama doŋ: luu ɗu enee ga coonu, keeñnjuu soosin ndaga ɗu ínohin an coonu fërí tíwi kilaak keeñ ga ɓoꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Kilaak keeñ kërí oni ɓoꞌ kimín kiyëgís ngëm ga fíkíi coonu. Kiyëgís ngëm ga fíkíi coonu kërí ɓaati yaakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ee yaakaaraagaruu waama tasoo múk, ndaga kiwaaꞌkaa Kooh tum ga keeñciigaruu, koorohha ga Helii yiselaꞌíꞌyii, ya onnduuɗa. ");
INSERT INTO snf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","En kiꞌenaa, kuɗewaa, ga wii ɗu míniꞌtii haffuu daraɗa, Kiristaanii hayya ga wahtaa Kooh waaroheekaɗa, kaaniꞌtaruu, ɗu ɓii ɗu faaliꞌꞌiiriɗa. ");
INSERT INTO snf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","En kiꞌenaa, wóoꞌtii an ɓoꞌ tookin kiꞌeroh kumuunkaagari ndaga mooroomci yiliis, luu enee an ya ɓoꞌ yijúwíꞌ. Heƴna, enee an ɓaa jofin díiraa mínin kitah ɓoꞌ waaꞌ kiꞌeroh kumuunci. ");
INSERT INTO snf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kooh nak teewohin an ya waarinnduu fodii dii: Kiristaanii erohin kumuunci ndaga haffuu, ee wiima lak ɗu lís ɓitumoh-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Waa Kiristaanii yërí aam ñífaagari fodii sarah ee fodaama Kooh abohinnduu ɓiɓoꞌ ɓijúwíꞌ ga fíkíici, wëñaa ga aylukaa Kooh hayanɗa, Kiristaanii músalooruu gawa moose? ");
INSERT INTO snf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ee ga wii ɗu en ɓuwaa sagoh na Koohɗa, Kooh júwohiꞌtaruu na hafci, koorohha ga kikaankaa Kowukaagari. Wëñaa ga, waa ɗu júwohin nari diimaɗa, kipeskaa Kowukaagari onooruu kimúce? Ahaŋ kay. ");
INSERT INTO snf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ee ɓaatta ga iñaama, ɗu mínin kimaꞌkoh Kooh kooroh ga Yéesu, Haꞌmudiigaruu, ndaga ya yërí onnduu kijúwoh diima na Kooh. ");
INSERT INTO snf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ɓoꞌ yíinoo doŋ yërí haydoh baakaaꞌ ga ëldúna ee Aadama yërí. Baakaaꞌ nak wërí haydoh kikaan. Fodaama kikaan tíkukka ga ɓaa en ɓéeɓ, ndaga ɓéeɓ ɓuwii tumin baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","En kiꞌenaa, baakaaꞌ enee ga ëldúna, lakanaa Kooh yóoskíꞌtii Waasii Móyíis duum. Ga jamaanaa Móyíis, Kooh abohéeríi ɓuwaa baakaaꞌcaagaɓa. ");
INSERT INTO snf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Moona déy iñaa aboh ga jamaanaa Aadama bi ga jamaanaa Móyíis, kikaan tíkukee ga ɗook ɓéeɓ, bi ga sah ɓuwaa baakaarussii fodaa Aadama yaa sagee kitum iñaa Kooh nakoheeɗa. Aadama nak enee lëdíꞌ ga ɓaa jomee kihayɗa, ");
INSERT INTO snf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","wayee yërmaandaa Kooh onnduuɗa wóotírohin na baakaaraa Aadama tumɗa. En an baakaaraa ɓaa yaama, ya doŋ ya tumɗa tahin ɓoꞌ ɓiyewin kikaanaa, wëñaa ga yërmaandaa Kooh, na iñaa ya onoh ee meekisohhii dara ga, koorohha ga ɓoꞌ yíinoo doŋ, ennda Yéesu Kiristaaɗa, leꞌanndii bi dooy ga ɓiɓoꞌ ɓiyewine? ");
INSERT INTO snf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Iñii Kooh onohɗa wóotírohin na iñcii límuk ga baakaaraa waama ɓoꞌ yíinoo doŋ tumɗa. En kiꞌenaa, baakaaraa wíinoo waama Aadama tumɗa, attiꞌaa límuk gaɗa lëgíssa kisaŋkuꞌ ga ɓéeɓ. Wayee hídaa ga dii baakaaꞌcii ɓuwii hín kiyewinɗa tóoh, Kooh, ga yërmaandaagari, onohin kijúɓ ga fíkíici. ");
INSERT INTO snf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","En kiꞌenaa, ga baakaaraa ɓoꞌ yíinoo doŋ tumɗa, kikaan laakin dooli ga ɓuwii ndaga iñaa ya tum yaama. Wayee ga Yéesu Kiristaa doŋ, ɓuwii laakin yewin ga Kooh: ya teeɓɓa yërmaandi widóoyíꞌ, ya onɓa kijúɓ ga fíkíici. Ga Yéesu kon, ɓa pesan ee ɓa ƴah ɓibuuꞌ nari. ");
INSERT INTO snf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Fodaama, ga baakaaraa ɓoꞌ yíinoo doŋ tum, kikaan tíkukka ɓéeɓ ɓuwiiɗa, fodaama ɓan, enaama yíinoo yijúwíꞌ yërí ɓoꞌ tum, ya ɓëgíssa ɓuwii ga kikaankaa ɓageeɓaɗa, ya onndaɓa kipes. ");
INSERT INTO snf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Fodaama daa Aadama rek saŋɗee Kooh bi tahin ɓéeɓ enuunun ɓitumoh-baakaaꞌɗa, fodaama Yéesu Kiristaa kelohɗin Kooh bi tahin Kooh hay kiꞌaboh ɓoꞌ ɓiyewin ɓiɓoꞌ ɓijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Waasaa Móyíis hayya, en ɗanaa, baakaaꞌ mín kiyewin, ee daa baakaaꞌ yewinoh tóoh, yërmaandaa Kooh wëñ ɗa kihoom ɓan. ");
INSERT INTO snf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ee fodaa daa baakaaꞌ haydohee kikaan, ka tíkukka ga ɗook ɓuwiiɗa, fodaama yërmaandaa Kooh hay kitíkuk ga ɓéeɓ ɓuwii onɓa kijúɓ ga fíkíici, ee fodaama ɗu laas ga kipeskaa leehoo taaꞌɗa, kooroh ga Yéesu Kiristaa, Haꞌmudiigaruu. ");
INSERT INTO snf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Kon ɗu woꞌan ya diima? Ɗu enukohan ga kibaakaaꞌ doonaa yijófíꞌyaa Kooh waariꞌtuuɗa wëñ kiꞌaamuk ga ɗuuƴcuune? ");
INSERT INTO snf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Mínoo kiꞌen kay! Ɗu man na ɓuwaa kaanin ee baakaaꞌ laakissii dooli ga ɗookɓa. Kon mínan na kiꞌen baakaaꞌ lísi kikuliyuk ga kipessuu? ");
INSERT INTO snf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ɗú ínohin moos an ga waa ɗú bëtísiꞌu, ɗú ennda wíinoo na Yéesu Kiristaaɗa, ɗú teewohee ɓan an ɗú bokin nari kikaan. ");
INSERT INTO snf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kon kooroh ga bëtísaama, ɗu enin ɓuwaa kaanin nari, ɗu acdohussa nari, doonaa Kooh Paamudii mílísiꞌtuu ga kikaan fodaa ya mílísiꞌ Kiristaa ga dooli ndamciɗa. Ee fodaama ɗu ɓan, ɗu laak kipes kiꞌas, kaa ɗu aasohan. ");
INSERT INTO snf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ee waa ɗu enin wíinoo na Kiristaanii ga waa ɗu kaan nariɗa, ɗu hay kiꞌen nari wíinoo ɓan ga kimílískaagaari. ");
INSERT INTO snf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ínohat an daa ɗu madee ga kipessuu kuɗewaaɗa, Kooh daaƴdohinwa na Yéesu Kiristaa ga kuraanaa ya kaanohɗa, doonaa ya ɗúbíꞌdoh faan-baakaaꞌfaa ɗu ɓayeeɗa, ee fodaama ɗu ensisoo ñaam-baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ndaga ɓaa kaanin, baakaaꞌ laakissii dooli ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Waa ɗu kaanin na Kiristaanii, ɗu gëmat ɓan an ɗu hay kipes nari. ");
INSERT INTO snf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","En kiꞌenaa, ɗu ínohin an Yéesu Kiristaa mílísin ga kikaan, ya ƴahissii kikaan. Ee kikaan ga kihafci laakissii dooli ga ɗookci. ");
INSERT INTO snf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ya hëgískohin na baakaaꞌ bi leehha ga waa ya kaanɗa. Diimaɗa ya yii pes ee ya pesiꞌ Kooh bi taaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ee fodaama ɗú ɓan, abat an ɗú man na ɓuwaa kaanin ee baakaaꞌ laakissii dooli ga ɗookkúu, ɗú ínoh ɓan an ɗú ɓii pesiꞌ Kooh bi taaꞌ, ndaga ɗú en wíinoo na Yéesu Kiristaa. ");
INSERT INTO snf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kon, kaa tooksat kiꞌen ñaam-baakaaꞌ, sagat kikeen ga iñcii cibóníꞌcii faanciigarúu aaw kikaan meekisohiɗa. ");
INSERT INTO snf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kaa tooksat kilëgísiꞌ baakaaꞌ hal ga haffúu, waa tumlukohirúu iñaa joffii. Namat kiꞌeroh haffúu ga Kooh, waa ɗú enin ɓuwaa kaanin bi mílísuunun. Erohat haffúu bi leeh tak gari, en ɗanaa, ya ëewdohhúu ga kitum yijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","En kiꞌenaa, baakaaꞌ laaksisoo dooli ga ɗookkúu ndaga ɗú ayukissii ga iñaa Waasii Móyíis nakohɗa, wayee ɗú ayuk ga yërmaandaa Kooh. ");
INSERT INTO snf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Kon diimaɗa ɗu jom ya kiwoꞌ? Ɗu woꞌat an ɗu ayukissii ga Waasii Móyíis, wayee ɗu ayuk ga yërmaandaa Kooh. Kon luu ɗu baakaaree, iñaama enoo darane? Óꞌóo kay! ");
INSERT INTO snf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mon ɗú ínohin an binaa ɗú eꞌ ɓoꞌ haffúunaa, ɗú abi an ɗú hayyi kitaabuk, ee fodaama ɗú en ñaamci. Kon binaa baakaaꞌ wëñnjúu doolinaa, lak ɗú enin ñaam gawa, ee fodaama wa ëewdohhúu ga kikaan. Ee, en an Kooh yërí ɗú taabukaa ɗú enan ñaamci ee ya hayyúu kiꞌaboh ɓiɓoꞌ ɓijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mon kuɗewaa ɗú enee ñaam-baakaaꞌ, ee diimaɗa ɗú namin kitaabuk Kooh. Fodaama ɗú ɗaakin ga keeñnjúu kayohfii ɗú jëgíruɗa. Ɗu gërëmat Kooh ga iñaama. ");
INSERT INTO snf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Kooh nísinndúu ga kiñaam-baakaaꞌkaa ɗú enoheeɗa ee ɗú enin ñaamci doonaa kipessúu en kipes kijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Iñii yii, mi woꞌꞌi man na dii ɓuwii woꞌiɗa ndaga helciigarúu gaawoo kiꞌam yen. Kuɗewaa, ɗú erohee faanciigarúu hen, ca ennda ñaam iñaa moroo na iñaa júɓpii ee límíꞌtarúu kesi iñaa joffii. Kon diimaɗa, erohat faanciigarúu, ca en ñaam iñaa júwin, doonaa kipessúu en iñaa selaꞌin. ");
INSERT INTO snf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kuɗewaa, ga waa ɗú lís kiꞌen ñaam-baakaaꞌɗa, waassúu enéeríi ga kitaabuk yijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ɗú laak ya ga iñcaa cibóníꞌcaa ɗú tumee kuɗewaaɗa ee wati ca enin kaci garúu? Iñcaama déy, kikaan doŋ kërí ca haydohi. ");
INSERT INTO snf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Diimaɗa nak Kooh ɓëgísinndúu ga kiꞌen ñaam-baakaaꞌ ee ɗú enin ɓiñaamci. Kon neehalaa ɗú laas ga iñaamaɗa wërí en an ɗú selaꞌíꞌ kipeskiigarúu, ee mëeñjohaa, ɗú laas ga kipeskaa leehoo taaꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Fayaa baakaaꞌ wërí en kikaan; Kooh nak, iñaa ya onoh ee meekissii ken dara gaɗa wërí en kipeskaa leehoo taaꞌ ga Yéesu Kiristaa, Haꞌmudiigaruu. ");
INSERT INTO snf_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Mbokcii, ɗú ínohin iñii mi ƴahhúu kiwoꞌɗa. Ɗú ínohin dijófíꞌ an waas tíkuki ɓoꞌ lakanaa ya yaa lís kipes. ");
INSERT INTO snf_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Malkat ga ɓetifaa en na kipajuk: en an ƴaalci yaa lís kipesaa, waas ebilli kites nari bi ga daa yaama kaanan. Wayee binaa ƴaalaa kaanaa, lak ya ɓëgísukin ga waasaa ebileeri kites nariɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Kon ya aboh na ƴaal yiliis, ee lak ƴaalci ya lís kipesaa, ya hay kitíku ɓetifaa ɗúki ƴaalci, faanuki na ɓoꞌ yiliis. Wayee binaa ƴaalci kaanaa, lak ya ɓëgísukin ga waasaama; ya mínin kiꞌaboh na ƴaal yiliis ee ya tíksoo ɓetifaa ɗúk ƴaalci, faanuk na ƴaal yiliis. ");
INSERT INTO snf_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","En garúu fodaama ɓan mbokci: kooroh ga kikaankaa Kiristaanii, ɗú kaandohha nari, kon Waas tíkukissiirúu. Ɗú ɓuu ɓoꞌ yiliis, ee ɓaama yërí mílís ga kikaankaa doonaa kipeskiigaruu límíꞌ Kooh jeriñ. ");
INSERT INTO snf_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kuɗewaa, ga wii ɗu en na kipes ga rek iñaa neɓ kumuunnduuɗa, iñcii cibóníꞌcii Waasii Móyíis yúun garuuɗa cërí yëngëlee faanciiruu ee ca límíꞌtaruu kikaan. ");
INSERT INTO snf_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kuɗewaa, Waasii Móyíis abeeruu fodii ñaam, diimaɗa ɗu man na ɓuwaa kaanin gawa, wa tíkukissiiruu. Diimaɗa nak ɗu taabuk kijaamuk-Kooh kiꞌas fodii dii Helii yiselaꞌíꞌyii teeɓpuukaɗa, wayee enissii fodaa daa, kuɗewaa, Waasii Móyíis nakoheekaɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Kon ɗu jom ya kiwoꞌ? An Waasii Móyíis wërí haydoh baakaare? Múk! Wayee Waasii Móyíis wërí onndoo kiꞌínoh iñii en baakaaꞌɗa. En kiꞌenaa, Waasii Móyíis woꞌéeríi an: «Kaa ɗíibuk kilaas enaama mooroomfunaa», eneenaa mi ínohoo baakaaraa en ga kiɗíibuk enaama ɓoꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Baakaaꞌ nak heel hal ga iñaama Kooh nakoh kitumɗa, wa hayya ga ɗuuƴ keeñiigoo, wa yúunnda ga ɗuuƴcoo halaat kiɗíibuk kilaas tóoh iñaa neɓ kumuun ɓoꞌ. En kiꞌenaa, waas laakéeríinaa, eneenaa baakaaꞌ enoo. ");
INSERT INTO snf_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kuɗewaa, mi, ga wii mi ínohéeríi iñii nakohu kitumɗa, mi yërí enee na kipes; wii mi ínohha iñcii Móyíis nakohɗa nak, baakaaꞌ wërí ɓewee kipes ga ɗookkoo, ");
INSERT INTO snf_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ee mi nammba kikaan. Fodaama iñaa nakohu kitum ee jomeeroo kiꞌon kipesɗa, ekkaroo kikaan. ");
INSERT INTO snf_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","En kiꞌenaa, baakaaꞌ heella hal ga iñaa Kooh nakoh kitumɗa, ɗúkkaroo ee apparoo kooroh ga iñaama nakohu kitumɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kon Waasii Móyíis selaꞌin ee iñaa Kooh nakohɗa selaꞌin, júwin, jofin. ");
INSERT INTO snf_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kon iñaa yijófíꞌyaa yaama ekkoo ga kikaane? Múk! Baakaaꞌ kay wërí tumka, doonaa daa wa manɗa mín kihotuk. Wa kooroh ga iñaa yijófíꞌyaa yaama, wa ekkaroo kikaan. Fodaama wa kooroh ga iñaa nakohu kitumɗa, wa wëñnja ɗa kibon. ");
INSERT INTO snf_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ɗu ínohin an Waasii Móyíis meyoh ga Kooh. Mi nak, mi ɓoꞌ-súusúus, mi toonuunun fodii ñaam ga baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mi ínohoo dara ga iñcii mi tumiɗa. En kiꞌenaa, mi tumoo iñcii mi waari kitumɗa, mi nami kitum cii mi waaroo kitumɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Waa iñcii mi tumiɗa, mi waaꞌtiica, kon mi tookin an Waasii Móyíis jofin. ");
INSERT INTO snf_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Kon binaa mi tum iñaa mi waaꞌtii kitumaa, enndii mi tayka, wayee baakaarii en ga ɗuuƴcooɗa wërí tumlukohhoo ka. ");
INSERT INTO snf_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mi ínohin an enaama yijófíꞌ laakoo ga ɗuuƴcoo, mi waaꞌ kiwoꞌ ga kipes faanndoo. En kiꞌenaa, kiwaaꞌ kitum yijófíꞌ kii garoo, wayee mi mínooka kimëtíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi tumoo yijófíꞌyii mi waari kitumɗa, wayee mi tumi yibóníꞌyii mi waaꞌtiiɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Binaa mi tum iñaa mi waaꞌtii kitumaa, enndii mi tumlukoh haffooka, wayee baakaarii en ga ɗuuƴcooɗa wërí ekkoo ga. ");
INSERT INTO snf_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Iñii yii yërí mi hot ga haffoo: wahtaa mi waaꞌ kitum iñaa jofin tóoh, yibóníꞌ yërí tuukukiroo tek. ");
INSERT INTO snf_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Waasii Kooh newinndoo lool ga ɗuuƴcoo. ");
INSERT INTO snf_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Wayee mi hotin an laakin waas wiliis waa en ga faanndoo ee wërí lebirohi na iñii heliigoo teeɓpooɗa. Wa tummboo ñaam ga waas baakaaꞌ, wii en ga faanndooɗa. ");
INSERT INTO snf_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","En kiꞌenaa, massa mi! Ɓii músalanndoo ga faanfiigoo fii ëewdohhoo ga kikaanɗa ɓa? ");
INSERT INTO snf_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mi yii gërëm Kooh ndaga mi laakin ɓaa músalanndoo ee yërí en Yéesu Kiristaa, Haꞌmudiigaruu. Ga helloo mi abin an mi tookin Waasii Kooh, wayee ga kiɓoꞌ-súusúussoo mi taabuk waas baakaaꞌ. ");
INSERT INTO snf_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kon diimaɗa, ɓuwii en wíinoo na Yéesu Kiristaaɗa, attiꞌsoo kikaan. ");
INSERT INTO snf_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","En kiꞌenaa, Waasii Helii yiselaꞌíꞌyii oniraa kipes ga kiꞌenfu wíinoo na Yéesu Kiristaaɗa ɓëgísinndaa ga waas baakaaꞌ na kikaan. ");
INSERT INTO snf_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Iñaa Waasii Móyíis mínéeríi kitum, ndaga dii ɓoꞌ-súusúus laakoo dooli tah wa mínéeríikaɗa, Kooh tuminndi. Ya tumwa ga waa ya wos Kowukaagari ëldúna, ka ɓayya faanciigaruu, ɗu, tumoh-baakaaꞌcii, doonaa ka nísíꞌtuu baakaaꞌciigaruuɗa. Fodaama, Kooh attiꞌꞌa kikaan baakaaraa en ga ɓoꞌ-súusúusɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ya tuminka doonaa kooroh ga iñaamanaa, ɗu tum bi mat iñaa Waasiigari nakohɗa, ɗu íis kon kitaabuk waasaa ɗu sak na kihaffuuɗu wayee ɗu taam ga Waasii Helii yiselaꞌíꞌyii. ");
INSERT INTO snf_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ɓuwii pesi ga iñaa neɓ faanɗa taabuksi neɓlaat-kumuunɓa doŋ, wayee ɓuwii pesi ga iñaa neɓ Helii yiselaꞌíꞌyiiɗa taabuksi Helii yiselaꞌíꞌyii rek. ");
INSERT INTO snf_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kidëk ga kitaabuk neɓlaat-kumuun, ëewdohi ɓoꞌ ga kikaan doŋ, ee kidëk ga kitaabuk iñaa neɓ Helii yiselaꞌíꞌyii onohi kilaas ga kipeskii kukayohkii na kiꞌen ga jam. ");
INSERT INTO snf_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ɓuwii tíku helɓa ga kitaabuk neɓlaat-kumuunɓaɗa sagohuunun na Kooh. Ɓa tookoo kitum iñaa Kooh nakoh ee ɓa mínooka hen sah. ");
INSERT INTO snf_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ɓuwii taabuk neɓlaat-kumuunɓaɗa mínsoo Kooh kineɓloh. ");
INSERT INTO snf_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ɗú nak, ɗú pesissii ga kitaabuk neɓlaat-kumuunndúu, ɗú pes ga kitaabuk Helii yiselaꞌíꞌyii, ndaga Heliima wii dëkka ga ɗuuƴ keeñciigaruu. Ɓaa laakkii Helii Kiristaanii ga ɗuuƴ keeñaagarinaa, enndii yuu Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ee binaa en an Kiristaanii yii ga keeñnjúunaa, kayoh faanciigarúu aawan ga kikaan rek ndaga dii ɗú tumin baakaaꞌɗa, wayee Heliigari oninndúu kipes ndaga dii ɗú abohuunun ɓoꞌ yijúwíꞌ ga fíkíiciɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ee ɓan, waa Helii Kooh mílísiꞌ Yéesu Kiristaa ga kikaanɗa, ɗú dëkɗinwa ga keeñnjúu kayoh-kayohɗa, wóorin an Kooh yiima hay kimílísiꞌ faanciirúu kaaninɗa ɓan kooroh ga doolii Heliigari dëk ga ɗuuƴcúuɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Kon, waa en fodaama, ɗú mbokciigoo, laakin iñaa waꞌtuu, wayee enndii ga iñaa neɓ faan bi ɗu pesi ga iñaa neɓ kumuunnduu. ");
INSERT INTO snf_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Binaa ɗú pes ga kitaabuk iñaa neɓ faanaa, ɗú hay kikaan. Wayee binaa ɗú lëgísiꞌ Helii yiselaꞌíꞌyii hal ga haffúunaa, ɗú hay kitagoh na kitum iñcii cibóníꞌcii ɗú tumiɗa, ee fodaama ɗú laas ga kipeskii kukayohkii. ");
INSERT INTO snf_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ɓéeɓ ɓuwii Helii Kooh níiꞌɗa, ɓa ɓitowu Kooh. ");
INSERT INTO snf_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Heliima Kooh onndúuɗa tumoorúu ñaam, ee wa hay kitah ɗú niiksoo dara, wa ƴahhúu kitum ɓitowu Kooh. Wa hayyúu kimín kiꞌon kiɓay Kooh: «*Abaa, Paammboo!» ");
INSERT INTO snf_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Helii Kooh wiima wërí oniruu kiꞌínoh ga keeñnjuu kayoh-kayohɗa an ɗu ɓitowu Kooh. ");
INSERT INTO snf_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ee waa ɗu ɓitowu Kooh, ɗu hay kilam ga iñcaa cijófíꞌcaa ya faaniꞌtuuɗa; ee iñcaama, ɗu na Kiristaanii ɗu hayca kilam. En an ɗu bok nari kidaƴ coonunaa ɗu bokan nari ɓan ga ndamaa ya laakɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mi foogin an coonucii ɗu en na kidaƴ watiɗa, enndii dara ga fíkíi ndamaa Kooh ƴahhuu kiꞌon kuwisɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","En kiꞌenaa, ëldúnaanii Kooh sakɗa, besoo bes, wa wii sek Kooh teewoh ndamii towutiigari. ");
INSERT INTO snf_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ëldúnaaniima Kooh sakɗa, wii taabuk waasaa ëewdohwa ídaa ee wa tayyiika. Kooh yërí tíkwa iñaama, wayee hoonohhii wa abin yaakaaꞌ, ");
INSERT INTO snf_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ndaga bes waa hay, Kooh hay kiɓëgís ëldúnanii ya sakɗa ga doolii saŋkuꞌwa, ammbawa ñaamɗa. Ee fodaama wa laak hafwa, wa eku ɓan ga ndamaa towutii Kooh. ");
INSERT INTO snf_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","En kiꞌenaa, ɗú ínohin an bi wati, ëldúnaanii Kooh sakɗa lís ga mesiklaat fodii ɓetifaa en na kiꞌíin ndaga coonucaa ga kilaak kowuɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mesiklaataama keenndii rek ga ëldúnaanii kesi, wa keenin bi ga ɗookkuu ɗu ɓii ɗu laasin ga Helii yiselaꞌíꞌyii, ennda iñaa ya ɗeɓ kiꞌonohɗa; ɗu ɓii íin ga keeñciiruu ee ɗu ɓii ga kisek besaa Kooh ƴahhuu kitum ɓitowuciɗa ee ya ɓëgísannduu ga kikaanɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","En kiꞌenaa, Kooh músalinnduu wayee ɗu taam ga na kiꞌam yaakaaꞌ. Ee fu hot iñaa fu yaakaaraa, iñaama ensisoo yaakaaꞌ. Iñaa fu hotin, fu lísan na kiyaakaaꞌ gari? ");
INSERT INTO snf_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Wayee waa iñaa ɗu yaakaaꞌɗa ɗu hottiiri duum, kon ɗu jommbi kisek hen, ɗu guuꞌguuluk ga iñaama. ");
INSERT INTO snf_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Fodaama ɓan, Helii yiselaꞌíꞌyii hayinnduu kiꞌamɗoh ndaga ɗu laakoo dooli. En kiꞌenaa, ɗu ínohoo daa kikíim Kooh eniɗa. Helii ga kihafci kíimiꞌtuu Kooh ga ɗuuƴci, fodii ɓaa en na kiꞌíin woꞌeenaa woꞌkoo na kúuw. ");
INSERT INTO snf_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Kooh yii ínohin iñaa en ga keeñ ɓaa en ɓéeɓɗa, ínohin ɓan iñaa Helii yiselaꞌíꞌyii meekisohɗa, ndaga wa kíimɗi ɓuwii en ɓuu Koohɗa daa Kooh waarohkaɗa. ");
INSERT INTO snf_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ɗu ínohin an ɓuwii waaꞌ Koohɗa, ennda ɓuwii ya nook ga hafci kitaabuk iñaa ya nakohɗa, iñaa hew gaɓa tóoh Kooh hay kiꞌek yahci ga bi ɓa ɓewoh yijófíꞌ ga. ");
INSERT INTO snf_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","En kiꞌenaa, ɓuwaa ya tanuk kumëeñíꞌɗa, ya ɗaakɗin hafciɓa, doonaa ɓa en fodii Kowukiigari, ee fodaama, ka en saawii ɓoꞌ ɓiyewin ga oomaacii. ");
INSERT INTO snf_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ɓuwaama ya ɗaakiꞌ hafciɗa, ya nookinɓa ɓan ɓa hay gari; ee ɓuwaa ya nook ɓa hay gariɗa, ya abohinɓa ɓan fodii ɓiɓoꞌ ɓijúwíꞌ ga fíkíici; ee ɓuwaa ya aboh fodii ɓiɓoꞌ ɓijúwíꞌɗa, ya erinɓa ndam ɓan. ");
INSERT INTO snf_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kon waa enin ɗa, ɗu ƴah ya kiwoꞌ yiliis? Waa Kooh taam naruu, ɓii yiida mín yen garuu? ");
INSERT INTO snf_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ya yaa, ya saŋngii Kowukaagari ka kooꞌ ga coonu ndaga ɗu ɓéeɓpuu ɗu tah ya erohhakaɗa, kon ya na Kowukaagari, ya tumɗooruu iñaa en tóohe? ");
INSERT INTO snf_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ɓuwaa Kooh tanuk ga hafciɗa, ɓii yiida mínan ɓuwaama kiyam yen? Kooh yërí abohɓa ɓiɓoꞌ ɓijúwíꞌ. ");
INSERT INTO snf_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ɓii yiida mínɓa kiꞌattiꞌ kikaan? Kiristaanii, ga kihafci, kaanin, wëñaa ga Kooh mílísɗinndi; ya yugin, hanohin Kooh yah-ñaabaagari ee ya yaa kíimiꞌtuu Kooh. ");
INSERT INTO snf_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ee ɓii mínan kiꞌaas ga díkaantiruu na Kiristaanii bi hëgísohhuu na kiwaaꞌkiigariɗa ɓa? Ƴah coonu ciméeskíroo ƴah kitíit, ati kihatalluu ga kipes, wala aꞌ, kinduul wala iñaa mín kihídíꞌ kumuun ɓoꞌ ga, wala kikaan? ");
INSERT INTO snf_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","En kiꞌenaa, iñii daliruuɗa yërí bídu ga Këyítfaa an: «Kím bi noh aas, ɗí ɓii apu ndaga fu, ɗí ɓii malaku fodii baalcaa ëewdohu kihoossunee.» ");
INSERT INTO snf_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Wayee ga iñaa dalluu tóoh, yiima waarinnduuɗa tum bi ɗu meƴ ga na ndam wiyaak. ");
INSERT INTO snf_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","En kiꞌenaa, wëerinndoo an enndii kikaan, enndii kipes, enndii malaakacii, enndii cii na kinguurukɗa, enndii wati, enndii kuwis, enndii haꞌ-dooli, ");
INSERT INTO snf_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","enndii doolaa en ga ɗook, enndii waa en ga kakayɗa, wala yen yiliis yaa saku hen, laakoo dara iñaa mínnduu kihëgísoh na kiwaaꞌkii Kooh teeɓpuu ga Yéesu Kiristaa, Haꞌmudiigaruuɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ga dii mi en wíinoo na Kiristaaniiɗa, iñii mi woꞌɗa kayoh fiwóoríꞌ, mi woꞌꞌii saboh. Heliigoo taaboh na Helii yiselaꞌíꞌyiiɗa teewinndoo an mi woꞌ kayoh. ");
INSERT INTO snf_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Keeñnjoo leehin tak ee mi korukin coonucaa leehoo. ");
INSERT INTO snf_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Calalinndoo sah Kooh coñnjoo mi hëgískoh, mi ga kihaffoo, na Kiristaanii, en ɗanaa mbokciigoo mi bok naɓa heetɗa múcu. ");
INSERT INTO snf_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ɓuwaama ɓërí en ɓu-Isarayeel ee Kooh tuminɓa ɓitowuci, ya teewinɓa ndamiigari, ya pokohin naɓa kifiiliimun, ya erinɓa Waasii Móyíis, ya teewinɓa dii ya jom kijaamukuɗa, ee ya díginɓa. ");
INSERT INTO snf_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ɓa límukoh ga caasamuncaagaɓa meyoh ga níilaa Abarahamɗa; ee Kiristaanii, ga kiɓoꞌkaagari, límuk ga ɓuwaama, ya yii ya en Koohyii hanoh ɓéeɓ ɗookɗa. Ndam aawat gari bi taaꞌ. Aameen. ");
INSERT INTO snf_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mi waaꞌtii kiwoꞌ an iñaa Kooh dígee ɓu-Isarayeelɗa, ya tummbiiri. En kiꞌenaa, enndii an towutaa Isarayeel ɓéeɓta boku ga heetaa Kooh tanukɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ee ɓan, enndii an ɓéeɓ ɓuwaa bok ga níilaa Abarahamɗa, ɓitowuci. En kiꞌenaa, Kooh woꞌee Abaraham an: «Tucaasamuntaa mi dígeeraaɗa meyohsan ga geñaa Ísaak.» ");
INSERT INTO snf_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Iñaama waaꞌ kiwoꞌ an, towutaa límukoh ga ɓoꞌ rek tahhii ta en towu Kooh. Towutaa en tuu Koohɗa, tërí en taa límukoh ga dígaa Kooh dígee Abarahamɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Iñii yii nak yërí Kooh dígee Abaraham, an: «Wahtii wii gaac, mi hay garaa kihayis ee laakan ɓetifu Saaraa laakin kowu kiƴaal.» ");
INSERT INTO snf_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ee eemmbii ɗa; enissa fodaama na Rebekaa. Ya laakka na caasammbuu Ísaak síis, ɓaa bok paamun yíinoo. ");
INSERT INTO snf_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Kooh woꞌꞌari an: «yaakkaa hay kisúrgaꞌuk ga këmëeŋkímunaa.» Wii Kooh woꞌ iñaama lakanaa ɓa límussii ee ɓa tummbii yibóníꞌ, ɓa tummbii yijófíꞌ duum. Iñaama Kooh tummbari kimëtí iñaa ya natin kitum, ya teewohha an ya tanuki ga daa neɓpi, ee ya malakoo ga iñcaa cijófíꞌcaa ɓoꞌ tumi wayee ga ɓayaa ya ɓayyiɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Iñaama yërí bídu ga Këyítfaa, Kooh woꞌ an: «Mi tanukka Yakoop, mi sagiꞌta Esawuu.» ");
INSERT INTO snf_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ɗu ƴah ya kiwoꞌ ga iñaama? Ɗu woꞌan an iñaa Kooh tumɗa júɓpiine? Mínoo ɗa kiꞌen. ");
INSERT INTO snf_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","En kiꞌenaa, Kooh woꞌee Móyíis an: «Mi laakan yërmaandi ga ɓaa mi waaꞌ kiyërëm, mi jofan ga ɓaa mi waaꞌ kijof gari.» ");
INSERT INTO snf_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kooh tanuk ɓoꞌaa, enndii an ɓaa yërí waarika wala yërí lëgëyika, wayee Kooh ga kihafci yërí laaki yërmaandi gari. ");
INSERT INTO snf_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ndaga bidu ga Këyítfaa an Kooh woꞌ buuraa ɓu-Esípti an «Mi falinndaa buuꞌ doonaa kooroh garaanaa, mi teewoh kiyakkiigoo ee teekiigoo síw daa en tóoh ga ëldúna.» ");
INSERT INTO snf_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Fodaama, Kooh laaki yërmaandi ga ɓaa neɓpi ee ya yëgísɗi keeñ ɓaa neɓpi. ");
INSERT INTO snf_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ɓoꞌ hayyoo kimeekis an: «Waa ken mínoo dara ga iñaa Kooh waaꞌ, kon ya na ɓuwii ga ya?» ");
INSERT INTO snf_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Mi nak, mi woꞌ an fu, ɓoꞌ-súusúus, fu nam kiꞌen ɓa bi fu weeraantiꞌi na Kooh? Kataa mín kiwoꞌ ɓaa tawahkaɗa an: «Iñii tah ya fu tawahhoo fodii dii»? ");
INSERT INTO snf_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Man tawahoh kataa mínin kitum ga ban iñaa neɓpi: ga ƴooŋ-banaa wa wíinoo, ya mínin ga kihëwíꞌ kataa-túuƴ kimoꞌta na ɓan kataakaa foñsi ga fooh. ");
INSERT INTO snf_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","En an Kooh waaree kiteewoh aylukaagari na doolaagari, ya tookka kon kimúuñiꞌ iñaa maañ, ɓuwii tahee aylukaagari, ee kisaŋkuꞌ jomeeɓa ga kilaakɗa; ");
INSERT INTO snf_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ee ɓan, en an ya waaree kiteewoh daa ndamaagari hín kiyak ga ɗookkuu, ɗu ɓuwii ya laakin yërmaandi gaɓa, ee ya waayukiꞌɓa kilaas ga ndamaagariɗa, ");
INSERT INTO snf_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ɗu ɓéeɓpuu, ɗu ɓërí Kooh nook ga hafci. Ya eemmbii ga kinook yaawúuꞌcii doŋ ga hafci, wayee ɓan ɓuwii enussii yaawúuꞌɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Fodaama, ya woꞌꞌaka ga Këyítfaa Osee, sëldíiga-Koohaa an: «Ɓuwaa kuɗewaa enéeríi ɓuurooɗa, mi hayɓa kiwoꞌ ɓuunndoo. Heetaa kuɗewaa soosɗéeríi keeñnjooɗa, mi haywa kiwoꞌ heetii soos keeñnjooɗa. ");
INSERT INTO snf_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Daa ɓa woꞌohseera an ɓa enndii heetiigoo tóoh, ɓa hay da kiwoꞌu towutii Kooh yii en na kipesɗa.» ");
INSERT INTO snf_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ísayíi, sëldíiga-Koohaa, ga ɓakci, yéegaloheera ga looɓa an: «Luu enee an ɓu-Isarayeel, ɓa yewin hen bi ɓa hídin na tukakaytaa en ga giiyaaɗa, ɓijutuut gaɓa, ɓërí ƴah ga kimúc. ");
INSERT INTO snf_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","En kiꞌenaa, Haꞌmudii hay kitum bi mat, ga ëldúna, iñaa ya woꞌɗa ee yah kigaaw hen.» ");
INSERT INTO snf_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ee fodaa Ísayíi yaama woꞌeeka kumëeñíꞌɗa an: «Binaa Kooh, yii hanoh ɗookɗa múuñɗéeríi ɓiɓoꞌ ga heetiigaruunaa, ennaa ɗu ɗúbin fodaa ɓu-teeraa Sodom, ɗu man na ɓu-teeraa Gomooꞌ.» ");
INSERT INTO snf_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Kon ɗu aban ya kimma? Iñii yii: ɓuwii enussii yaawúuꞌ heelséeríi Kooh abohɓa ɓiɓoꞌ ɓijúwíꞌɗa, Kooh abohhaɓa ɓiɓoꞌ ɓijúwíꞌ. Ee ngëmaa ɓa laak ga Kiristaaniiɗa onɓaka. ");
INSERT INTO snf_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Wayee ɓu-Isarayeelɓaa heelee Kooh abohɓa ɓiɓoꞌ ɓijúwíꞌ ga daa ɓa taabuk Waasiiɗa, laakussii iñaama ga. ");
INSERT INTO snf_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Iñii tah ya ɓa laakkiika? Ɓa tíkee yaakaaꞌɓa ga tumeencaagaɓa, ɓa saŋnga kigëm ga Kooh. Ɓa tapukka ga atohaa këfíti ɓoꞌɗa, ");
INSERT INTO snf_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","fodaama, Kooh woꞌ ga Këyítfaa an: «Mi hay kiyíp ga teeraa Síyoŋ atohaa ɓuwaa këfítukohan, ee wërí ɓúukanɓa. Wayee ɓaa fu gëm gawanaa, yaakaaraagaraa tasoo múk». ");
INSERT INTO snf_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Mbokcii, iñii mi waaꞌ ga keeñnjoo ee mi kíim Kooh gaɗa, wërí en an ɓuwii mi bok naɓa heetɗa, ɓa múc. ");
INSERT INTO snf_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Kayoh, mi mínin kiseediꞌ an ɓa kaantukohin ga kijaamuk Kooh, wayee kikaantukohkiigaɓa, ɓa taammbii ga na hel. ");
INSERT INTO snf_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓa ínohoo daa koorohsi bi ɓoꞌ mín kijúɓ ga fíkíi Koohɗa, ɓa heella kituukiꞌ waas waa ɓa koorohan ga kihafɓa. Ga iñaama, ɓa tookiꞌtii Kooh ga iñaa ya tum kijúwíꞌɓaɗa. ");
INSERT INTO snf_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","En kiꞌenaa, Waasii Móyíis top ga wii Kiristaa hayɗa; en ɗanaa ɓéeɓ ɓaa gëmin mín kiꞌabohu ɓoꞌ yijúwíꞌ ga fíkíi Kooh. ");
INSERT INTO snf_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Iñii yii yërí Móyíis bín ga loo iñaa tahi Kooh kiꞌaboh ɓuwii ɓiɓoꞌ ɓijúwíꞌ, ee kooroh ga Waasii Móyíisɗa. Ya bín an: «Ɓaa taabuk Waasii ga ɓéeɓ iñii wa nakohɗanaa, pesan gawa.» ");
INSERT INTO snf_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Wayee ga daa kigëm ga Kiristaa onohi kijúɓ ga fíkíi Koohɗa, iñii yii yërí woꞌu ga an: «Kaa woꞌ ga helfu an: Ɓii yiida ƴah kilap ɗook asamaan?» Waaꞌ kiwoꞌ: kiɓewohnee da Kiristaanii, ya yoosuk? ");
INSERT INTO snf_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Kaa woꞌ ɓan an: «Ɓii yiida ƴah kiyoosuk daa ɓuwaa kaanin enohɗa?» Waaꞌ kiwoꞌ: kikólkíꞌ Kiristaanii ga ɓuwaa kaninɗa, ya hay? ");
INSERT INTO snf_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Këyítfaa woꞌ ya kon ga kijúɓ? Iñii yii: «Woꞌeenii Kooh, wii ga yahaafu, wa wii ga kúuwkiigaraa na ga keeñiigaraa». Woꞌeenii wiima wërí en wii ɗí yéegal ɓuwii an ɓa gëmat ga Yéesuɗa. ");
INSERT INTO snf_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ɓéeɓ ɓaa fu woꞌ ga kúuwfu, ga fíkíi ɓuwii, an Yéesu yërí en Haꞌmudii, ee fu gëm ga keeñaagaraa an Kooh mílísɗinndinaa, Kooh hayyaa kimúsal. ");
INSERT INTO snf_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","En kiꞌenaa, ɓaa gëm ga Yéesu ga keeñaagarinaa, Kooh hayyi kiꞌaboh ɓoꞌ yijúwíꞌ ga fíkíici; ee ɓaa woꞌ ga kúuwci an Yéesu yërí en Haꞌmudiinaa, Kooh hayyi kimúsal. ");
INSERT INTO snf_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Iñaama yërí Këyítfaa woꞌ an: «Ɓéeɓ ɓaa fu gëm garinaa, ya oorooraa múk.» ");
INSERT INTO snf_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Fodaama laakoo kigënantiloh an, yii yaawúuꞌ, yii enndii yaawúuꞌ. Ɗu ɓéeɓpuu, ɗu bok ga Haꞌmudii, ee ya tumɗi bi dooy ɓéeɓ ɓuwii kíimiri dímalɗa. ");
INSERT INTO snf_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Bíduunun ga Këyítfaa an: «Ɓéeɓ ɓaa fu ɓay Haꞌmudii kikíim dímalaa, ya hayyaa kimúsal.» ");
INSERT INTO snf_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Iñaama yërí laak. En kiꞌenaa, binaa ɓuwii gëmussii garinaa, ɓa kooran gada bi ɓa mín kifool gari kikíim dímal? Ɓa tuman na bi ɓa mín kigëm gari, ee ɓa kelohhii teekiigari woꞌu? Ɓa tuman na bi ɓa keloh teekiigari, ee laakkii ɓaa yéegalohwa? ");
INSERT INTO snf_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kon ɓuwaa yéegalohan teekiigari meyohan gada, ee laakkii ɓuwaa wosu. Moona Këyítfaa woꞌin an: «Malkat ga dii keeñcii ɓuwii soos ga hayii ɓuwii hay kiyéegaloh Hewhew cinéwíꞌɗa.» ");
INSERT INTO snf_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Wayee nak enndii ɓuwii ɓéeɓɓa ɓërí keloh Hewhewii winéwíꞌwii, taabukussawa. Ísayíi, sëldíiga-Koohaa woꞌ an: «Haꞌmudii, moo ɓii yiida gëm ga iñii ɗu yéegalohɗa?» ");
INSERT INTO snf_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Kon kigëm meyoh ga kisúkúruk Hewhewii winéwíꞌwii yéegalohuɗa ee Hewhewaama en Woꞌeenaa Kiristaanii. ");
INSERT INTO snf_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Wayee mi woꞌ an ɓa kelohhii Hewhewii winéwíꞌwii hene? Ahaŋ kay! Ɓa kelohinwa dijófíꞌ. En kiꞌenaa, Këyítcaa woꞌin an: «Toonaataagaɓa kelohukin daa en ɓéeɓ ga ëldúna ee woꞌeenɓa leꞌin bi ga topaaraa ëldúna.» ");
INSERT INTO snf_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Kon mi meekisohis an ɓu-Isarayeel ínohsoo kayoh-kayohɗane? Ahaŋ kay! Kooh ɗeweera kiwoꞌ, koorohha ga kúuwkaa Móyíis, an: «Mi hay kitum bi, ɗú siisoh ɓuwaa enussii heet duumɗa, mi obis aylukkúu ga ɓiɓoꞌ ɓiliis ɓaa laakoo hel.» ");
INSERT INTO snf_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ísayíi, sëldíiga-Koohaa kaañnja kiwoꞌ ga iñaa Kooh nakki kiwoꞌɗa an: «Ɓuwaa heelséeríiroo kihotɗa, hotuununndoo. Ee mi teewohin haffoo ga ɓuwaa tíkséeríi helɓa garooɗa.» ");
INSERT INTO snf_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Wayee ga iñaa aaw ga loo ɓu-Isarayeel, Kooh woꞌ an: «Noh noh, mi yii lërís yahiigoo heetaa wëeꞌtaa ga an wii, wa kelohoo kiwoꞌ ee wa yëgísin ga haf.» ");
INSERT INTO snf_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Kon mi meekisoh an, ati Kooh foñin heetiigari? Mínoo ɗa kiꞌen! En kiꞌenaa, mi ga kihaffoo, mi bok ga ɓu-Isarayeel, kucaasamun Abaraham, ga geñaa Beesamee. ");
INSERT INTO snf_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Kooh foñnjii heetiigari ya tanukee kumëeñíꞌɗa. Mon ɗú ínohin iñaa bidu ga Këyítfaa, ga loo Ili, sëldíiga-Koohaaɗa. Ya ñaꞌsukohee ga fíkíi Kooh loo ɓu-Isarayeel. Ya woꞌee an: ");
INSERT INTO snf_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«*Haꞌmudii, ɓuwii ɓii apuunun sëldíiga-Koohciigaraa, ɓa pookin loteelcaa ɗí tumohɗeeraa sarahɗa. Diimaɗa, mi doŋ mi tes ɓaa taabukkaa ee ɓa waaꞌtoo kiꞌap ɓan.» ");
INSERT INTO snf_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kooh ga kihafci woꞌꞌari an: «Fu tessii haŋfu, mi faanɗin haffoo ɓoꞌ ɓijúnni-yitnaɓanak ɓaa jaamukussii Baal». ");
INSERT INTO snf_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Wati, iñaama ɓan man fodaama garuu. Ɓiɓoꞌ ɓii ga, ɓaa tesin, ee Kooh tanukɓa ga yërmaandaagari. ");
INSERT INTO snf_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ee en Kooh waaꞌɓa hen, tanukkaɓanaa, kon enndii an, ga iñaa ɓa tumɗa tah ya tanukkaɓa. Enee an Kooh tanuki ɓuwii ga iñaa ɓa lëgëyɗanaa, eneenaa kiwaaꞌkii ya waari ɓoꞌɗa ensisoo ga yërmaandi. ");
INSERT INTO snf_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Kon ɗu woꞌat an ɓu-Isarayeel hotussii iñii ɓa heelɗa, wayee ɓiɓoꞌ ga ɗuuƴɓa ɓaa Kooh tanuk, hotuununwa. Ɓaa tesɗa nak enussa ɓuwaa yëgísuunun ga keeñ. ");
INSERT INTO snf_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Fodaa ka bídu ga Këyítfaa an: «Kooh nëenɗin helciigaɓa, kúnin hasciigaɓa, lagin nofciigaɓa ee iñaama bi ga wati.» ");
INSERT INTO snf_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dëwít ɓan cojeeraɓa an: «Ñamahcii ɓa ñamiɗa abatɓa fodii dii fíꞌ abi júuꞌɗa. Ɓa ñafukat kakay ee Kooh íifɓa mesiklaat. ");
INSERT INTO snf_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kooh búumɗatɓa, ɓa hotsisoo, ɓa dëkat ga mesiklaat bi bíiŋciigaɓa daaꞌ kakay bi taaꞌ». ");
INSERT INTO snf_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Kon mi meekisohis an, ga wii yaawúuꞌcii këfítukuɗa, ɓa keeneera bi ɓa leꞌꞌa kakaye? Mínoo ɗa kiꞌen! Keenii ɓa keenɗa nak lëgísiꞌ ɓuwii enussii yaawúuꞌɗa hal bi ɓa mín kimúc. Ee fodaama, iñaama tahin yaawúuꞌcii kisiis. ");
INSERT INTO snf_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ee en an ɓa lëgísɗin ɓu-ëldúna hal ga Kooh ee dii ɓa keeninɗa laakɗin ɓuwii ɓíinoo enussii yaawúuꞌɗa jeriñaa, haa bëríinaa ɓéeɓ ɓu-Isarayeel ɓoƴkidohan hafɓa ga Koohaa, jeriñaa hídan na kiyak? ");
INSERT INTO snf_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ɗú ɓii ɗú enndii yaawúuꞌɗa, mi woꞌ narúu kimma. Mi yërí en ɓii Kooh wos ee ya ebilli ga ɓuwii enussii yaawúuꞌɗa. Kon mi am an lëgëyii ya sassoo kitumɗa laakin solu lool garoo. ");
INSERT INTO snf_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mi yii tumwa nak, doonaa kisiis am ɓuwii mi heetukoh naɓaɗa, ee heƴna fodaama, laak ɓuwaa hay, Kooh músalɓa. ");
INSERT INTO snf_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ga waa Kooh foñ yaawúuꞌciiɗa, ya lëgíssa hal fodaama, doonaa heetcii ga ëldúnaɗa tóoh júwoh nari. Kon binaa ya haydohis ɓu-Isarayeelaa, iñaama moos madanndii na kimílískaa ɓuwaa kaaninɗane? ");
INSERT INTO snf_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","En kiꞌenaa, fu gúꞌ ga mbúuraa, fu faaniꞌ Koohwa sarahaa, iñaa tes ga mbúuraaɗa tóoh enin yuu Kooh. Ee fodaama ɓan, binaa fu eꞌ Kooh níil kedikkaa, toytaa tóoh enin tuuci ɓan. ");
INSERT INTO snf_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Heetii Isarayeel man na kedik-ólíwíyéekaa yípu hen, ee laakka toytaa ɓëjísu ga. Fu nak ga dii fu enndii yaawúuꞌɗa, fu man na koy kedik-ólíwíyéekaa ɓaɓ ga ëgíraa; ka jokussa daa toytaa ɓëjísohuɗa, ee fodaama fu mínin kiñam na toytaagaka ga muluƴmaa níilaa kedikkaa haydohɗa. ");
INSERT INTO snf_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kon kaa ndamuk ga fíkíi toytaa kedikkaama Kooh ɓëjísɗa. Ee luu enee an helfu waa ga kindamuk, kaa al múk an enndii fu ɓay níilaa, wayee níilaa wërí ɓayyaa. ");
INSERT INTO snf_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Fu nak, fu hay kiwoꞌ an: «Toytaama ta ɓëjísu hen, mi, mi jokussa ga daa ta eneeɗa.» ");
INSERT INTO snf_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Kayoh, Kooh foñnja yaawúuꞌcii en toytaa ƴowu taamaɗa, ndaga ɓa gëmmbii gari. Fu nak, ya tummbaraa ga ɓakaa yaawúuꞌcaa ndaga fu gëmin gari. Wayee nak, kaa ɓëwíꞌ haffu ndaga iñaama. Namaa kiniik Kooh. ");
INSERT INTO snf_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","En an Kooh yërí múuñíꞌtii yaawúuꞌcaama en toytaa kedikkaa ƴowuɗanaa, fu fooŋ an ya hayyaa kimúuñiꞌ, fu yii fu enndii yaawúuꞌ ee fu yërí en koykii joku ga kedikkiiɗane? ");
INSERT INTO snf_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kon fu hotin ga dii Kooh hín kijof na dii aylukiigari manɗa. Buwii këfítuk, keenussaɗa, ya tamohin ga ɗookɓa. Fu nak, ya teeɓparaa kijof. Kon dëkaa ga kijofkiigari, enndiikanaa ya hayyaa kiɓëjís fodii koy kedik. ");
INSERT INTO snf_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ee yaawúuꞌcii, ɓa took kigëm ga Koohaa, Kooh hayɓa kijokis ga daa ɓa enee kuɗewaa, ga kedikkaaɗa. Kooh míninɓa da kijokis. ");
INSERT INTO snf_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Wayee fu yii fu enndii yaawúuꞌɗa, fu madee na koy kedik-ólíwíyéekaa paɓ ga ëgíraaɗa. Ka ƴowussa, ka jokussa ga kedik-ólíwíyéekaa yípu henɗa. Fu ínohin an iñaama yooɓpii kilaak. Yaawúuꞌcii nak ɓërí en toytii kedik-ólíwíyéekii yípu henɗa. Kon wëñan kiyooɓ ga Kooh, ya ɓewista, ya jokista ga kedik-ólíwíyéekaa kaama yípu hen ta ɓëjísohseeɗa. ");
INSERT INTO snf_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Mbokcii, laakin iñaa en kúmpa garúu ee mi jominndúuri kiwoꞌ, doonaa ɗú íis haffúu kitík ɓuwaa ínohin iñaa en tóoh. Laakin ga ɓu-Isarayeel ɓuwaa bi wati saguunun kigëm ga Kooh. Iñaama hay kilaak bi ga bëríinaa ɓéeɓ ɓuwii enussii yaawúuꞌ, Kooh tanukɗa, aassan ga ngëmii. ");
INSERT INTO snf_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Daama nak, Kooh hay kimúsal ɓéeɓ heetii Isarayeel. Iñaama, yërí bídu ga Këyítfaa an: «Ɓaa ƴah kiɓëgís ɓuwiiɗa, meyohan Síyoŋ, ya hay kitum bi, ga kaan Yakoop, laakanndii ɓaa saŋ kijaamuk Kooh.» ");
INSERT INTO snf_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Kooh woꞌꞌa an: «Mi hayɓa kibayal baakaaꞌcaagaɓa, ee iñaama yërí teewohan kifiiliimunkaa mi pokoh naɓaɗa.» ");
INSERT INTO snf_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Binaa ɗu ɓeɓ loo Hewhewii winéwíꞌwiinaa, yaawúuꞌcii saguununwa kiteꞌ, ee fodaama ɓa ennda ɓuwaa sagohin na Kooh. Iñaama lëgísiꞌtarúu hal ga Kooh. Ɗu woꞌ ga kitanukkii Kooh tanuk yaawúuꞌciiɗanaa, ɓa en ɓuwaa ya keeñukin ndaga caasamuncaagaɓa. ");
INSERT INTO snf_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ɓéeɓ ɓaa Kooh tanuk, barkeellari, ya laakoo hel kanak ga ɓaa yaama. ");
INSERT INTO snf_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","En kiꞌenaa, ɗú ɓuwii enussii yaawúuꞌɗa, kuɗewaa, ɗú saŋnga kitaabuk Kooh, wayee diima, ga dii yaawúuꞌcii sagu kitaabuk Koohɗa, oninndúu kilaas ga yërmaandii Kooh. ");
INSERT INTO snf_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ƴah ɓan fodaama naɓa. Diima deŋ, ɓa sagin kitaabuk Kooh ga dii ya laak yërmaandi garúuɗa, en ɗanaa, ɓa ɓan, ɓa mín kilaas kimma ga yërmaandaagari.