﻿USE sofia;
DROP TABLE IF EXISTS sofia.snc_vpl;
CREATE TABLE snc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snc_vpl WRITE;
INSERT INTO snc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Iesu Keriso emaḡurito, tubuna ḡatana ḡerina eiaḡomato varina tu maiḡa: Iesu tu Davida garakana, Davida tu Aberahamo garakana. ");
INSERT INTO snc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahamo tu Isako tamana; Isako tu Iakobo tamana; Iakobo tu Iuda ma kakana ema tarina merori ḡesi tamari; ");
INSERT INTO snc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda tu Perese e Sera tamari, sinari tu Tamar; Perese tu Hesron tamana; Hesron tu Ram tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram tu Aminadab tamana; Aminadab tu Nasona tamana; Nasona tu Salmon tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon tu Boas tamana, Boas sinana tu Rahaba; Boas tu Obed tamana, Obed sinana tu Ruta; Obed tu Iese tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese tu Kini Davida tamana. Davida tu Solomona tamana. Solomona tu Uria ḡaraḡona ḡenana emaḡurito, (Uria ḡaraḡona etava-verariato murinai); ");
INSERT INTO snc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona tu Rehoboam tamana; Rehoboam tu Abia tamana; Abia tu Asa tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tu Iehosafat tamana; Iehosafat tu Ioram tamana; Ioram tu Usia tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia tu Iotam tamana; Iotam tu Ahasa tamana; Ahasa tu Hesekia tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia tu Manase tamana; Manase tu Amon tamana; Amon tu Iosia tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia tu Iekonia ma tarina merori ḡesi tamari. Mo ḡaro ai Babulona tarimari na Isaraela tarimari ḡeḡabi-iaḡorito Babulona ḡana. ");
INSERT INTO snc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babulona ḡana ḡeḡabi-iaḡorito murinai, Iesu eiaḡomato besena ema ḡemaḡurito varina tu maiḡa: Iekonia tu Sealtiele tamana; Sealtiele tu Serubabele tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabele tu Abiud tamana; Abiud tu Eliakim tamana; Eliakim tu Asoro tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro tu Sadok tamana; Sadok tu Akim tamana; Akim tu Eliud tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tu Eleasara tamana; Eleasara tu Matan tamana; Matan tu Iakobo tamana; ");
INSERT INTO snc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo tu Iosefa tamana, Iosefa ḡaraḡona tu Maria. Maria ḡenana Iesu emaḡurito; Iesu arana ḡekiraḡiani Keriso ḡetoni. (Keriso anina tu Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ḡuru mabarari Aberahamo ḡenana eiaḡomato mo Kini Davida tu ḡuru gabanana vasivasi (14), e Davida ḡenana eiaḡomato mo Babulona ḡana ḡeḡabi-iaḡorito tu ḡuru gabanana vasivasi (14), ema Babulona ḡana ḡeḡabi-iaḡorito negana na eiaḡomato mo Keriso tu ḡuru gabanana vasivasi (14). ");
INSERT INTO snc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso tu maiḡesi eḡorato: Ḡia sinana Maria tu Iosefa kirakauna, senaḡi ḡia tauri ruarua tu roḡosi roḡo beḡene veḡaraḡo nuḡanai, Iauka Veaḡa na mero evaḡa-ḡoraiato Maria diana nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosefa, Maria ḡaraḡona, tu vei iobukaiobuka tarimana, ema asi eurato, tarimarima ḡoirari ai Maria bene vaḡa-maiakaia. Moḡesina naima ḡena ura tu, vekure-toḡai vau Maria bene dobi-kwanea etato. ");
INSERT INTO snc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ḡia moḡesi etuḡamaḡito-ḡoi nuḡanai, Vereḡauka ḡena aneru ta nuvi ai efoforito, benamo ekiraiato, ekirato, “Iosefa, Davida natuna, kirakaumu Maria ḡabiraḡena garina asi bono vei, korana ḡia tu Iauka Veaḡa na mero bevaḡa-ḡoraia ḡia diana nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ḡia na mero ta beḡabiani, arana bono vatoa Iesu, (Iesu anina tu vevaḡa-maḡuri tauna); korana ḡia na ḡena tarimarima ḡeri rakava ḡerina bevaḡa-maḡuririni.” ");
INSERT INTO snc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Maiḡeri dagara mabarari ḡeḡorato tu, Vereḡauka na peroveta tarimana muruna na ekiraḡirito guruḡari bene vaḡa-moḡoniri ḡana, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ḡoḡitaia, ḡuiato ta bekuḡani, mero ta beḡabiani, mo mero keina arana beḡe vatoani Emanuela.” Emanuela anina tu ‘Barau tu ḡita sevisevirai.’ ");
INSERT INTO snc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosefa gena na etataḡato nai tu, Vereḡauka ḡena aneru na ekiraiato veiḡari eveirito. Maria eḡabi-raḡeato, benamo eḡaraḡoato. ");
INSERT INTO snc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Senaḡi ḡia ḡesi asi ḡegena-sebonato mo, natuna eḡabiato. Benamo mero arana evatoato, Iesu. ");
INSERT INTO snc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu tu Iudea tanonai vanuḡa ta arana Betelehema ai emaḡurito. Mo tu Kini Heroda na Iudea tanona eḡitaḡauato-ḡoi neganai. Iesu emaḡurito murinai, iaunega tarimari tu ḡaro eraḡeni rekena na ḡeiaḡomato, Ierusalemai ḡema-raḡasito. ");
INSERT INTO snc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Benamo ḡevedanaḡito, ḡekirato, “Iuda tarimari ḡeri kini ta bemaḡuri ḡetoni tu ainai? Ḡia ḡena visiḡu baḡa ḡitaia ḡaro eraḡeni rekenai. Ḡai tu ḡia toma-rakariḡo vinina baḡa iaḡoma.” ");
INSERT INTO snc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kini Heroda na mo guruḡa eseḡaḡiato nai, nuḡana eketo-bokoto, ema Ierusalema tarimari mabarari maki. ");
INSERT INTO snc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Benamo ḡia na Rubu Veaḡa vereri baregori e taravatu vaḡa-riba-iaḡina tarimari mabarari evaḡa-vegogorito, benamo edanaḡirito, ekirato, “Peroveta tarimari tu kara ḡetato, Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), tu ainai bemaḡurini?” ");
INSERT INTO snc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ḡia na ḡevaḡa-veseato, ḡekirato, “Betelehema vanuḡana, mo tu Iudea tanonai, korana peroveta tarimana Mika na maiḡesi etoreato, ");
INSERT INTO snc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelehema o, Iudea tanonai otanuni vanuḡana, Iuda vanuḡari vekaravari ai ḡoi tu dia vanuḡa misina, asi arana vanuḡana ta, korana tu veḡorikau tauna ta ḡoi ḡemuna beiaḡomani, ḡia na au ḡegu Isaraela tarimari beguine-iaḡirini.’” ");
INSERT INTO snc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Benamo Heroda na iaunega tarimari vekuretoḡai ekearito, benamo edanaḡi-ginikau ginikaurito, ekirato, kamara ḡaro korikori ai visiḡu efoforito. ");
INSERT INTO snc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Benamo etuḡurito Betelehema ḡana, ekirato, “Ḡoiaḡo, mero misina boḡonoa vetau-ginikaua, boḡo doḡariani neganai, boḡonoma vaḡa-ribagu, be au maki bana iaḡo, bana toma-rakariḡo vinia.” ");
INSERT INTO snc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Heroda ḡena guruḡa ḡeseḡaḡiato murinai, ma ḡerakato dabara na. Dabara na ḡeiaḡoto-ḡoi nuḡanai, mo visiḡu, ḡaro eraḡeni rekenai ḡeḡitaiato visiḡuna, na eguine-iaḡirito mo, mero misina ḡena gena gabuna iatanai eruḡa-tarito. ");
INSERT INTO snc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ḡia na mo visiḡu ḡeḡitaiato nai, ḡeiaku-rakavato. ");
INSERT INTO snc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mo numai ḡeraka-toḡato nai, mero misina ma sinana Maria ḡesi ḡeḡitarito, benamo ḡevetui-tarito, ḡetoma-rakariḡoato. Moḡa murinai ḡeri farefare ḡeḡurarito dagarari ḡekeorito, bena ḡevarevare-viniato. Ḡevarevare-viniato dagarari tu golo, e muramura arana frenkinsens, mai tu goḡuna ma bonana namona muramurana, ema vedau muramurana arana muro. ");
INSERT INTO snc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Benamo Barau na nuvi ai evaḡa-ribarito, ekirato, “Heroda ḡenai asi boḡono ḡenoḡoi.” Moḡa lorinai dabara boruna na ḡeri tanobara e vanuḡa ḡana ḡeḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ḡia ḡerakato murinai, Vereḡauka ḡena aneru nuvi ai Iosefa ḡenai efoforito, ekirato, “Novaisiraḡe, mero misina ma sinana ḡesi Aigupito ḡana noraga-ḡori iaḡori. Monai boḡono tanu mo, au na ma bavaḡa-guruḡamuni, korana Heroda na mero misina evetauani, bene vaḡi-masea etoni.” ");
INSERT INTO snc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Benamo Iosefa evariḡisito, mero misina ma sinana ḡesi eḡabirito, boḡi nuḡanai Aigupito ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Monai ḡetanuto mo, Heroda emaseto. Moḡesina Vereḡauka na peroveta tarimana muruna na ekiraḡiato guruḡana ema moḡonito, ekirato, “Aigupito na natugu akea-rosiato.” ");
INSERT INTO snc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda eriba-maoroto, mo iaunega tarimari na ḡia tu ḡeḡofaiato nai, ebaru-rakava rakavato. Benamo vetari tarimari o soldia etuḡurito, Betelehema e rikina tanori ai mero misiri ḡeri maḡuri laḡaniri ruarua e gabivau ma ḡemaḡurito mabarari ḡevaḡi-maserito. Mo mero misiri ḡeri maḡuri laḡanina ruarua ma murinai ḡevaḡi-maserito anina tu, iaunega tarimari na visiḡu ḡeḡitaiato ḡarona na, eiaḡoto mo, Heroda eribato ḡarona tu laḡani ruarua kavana. ");
INSERT INTO snc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mo ḡaro ai Barau na peroveta tarimana Ieremia muruna na kara ekiraḡiato guruḡana tu ema moḡonito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Garo ta Rama vanuḡanai ḡeseḡaḡiato, taḡi-koḡokoḡo e taḡi-vanorovanoro tu barego, Rahela natuna taḡiri eveini, e asi eurani beḡene vaḡa-magoa, korana natuna tu beḡe mase.” ");
INSERT INTO snc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroda emaseto murinai, Vereḡauka ḡena aneru Iosefa ḡenai nuvi ai ma efoforito Aigupito ai. ");
INSERT INTO snc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Benamo mo aneru Iosefa ekiraiato, ekirato, “Novaisiraḡe, mero misina ma sinana ḡesi noḡabiri, Isaraela tanona ḡana ḡoiaḡo. Korana tu mero misina beḡene vaḡi-masea ḡetato-ḡoi tarimari tu varau beḡe mase.” ");
INSERT INTO snc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iosefa evariḡisito, benamo mero misina ma sinana ḡesi eḡoririto, Isaraela tanona ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Senaḡi Iosefa eseḡaḡito, Akelao na Iudea eḡitaḡauato-ḡoi tamana Heroda gabunai, benamo mo ḡana iaḡo tu egarito. A Barau na nuvi ai evaḡa-ribaiato ilailanai eraka-vanaḡito, eiaḡoto Galilea tanona rekena ḡana. ");
INSERT INTO snc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea tanonai vanuḡa ta arana Nasaretai etanuto. Monana Barau na peroveta tarimari ḡerina Iesu ekiraḡiato guruḡana emoḡonito, ekirato, “Ḡia tu Nasareta tarimanai beḡe kiraḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Moḡeri ḡarori ai Ioane Babatiso eiaḡomato, tano fakanai Iudea nuḡanai eḡobatato-ḡoi, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ḡemi rakava ḡerina ḡovetuḡamaḡi-kure, ema ḡoraka-kure Barau ḡenai, korana Guba Basileiana tu bevotu, (Barau ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa).” ");
INSERT INTO snc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mai Ioane maiḡa tu Isaia peroveta tarimana na ekiraḡiato-ḡoi, maiḡesi ekirato, “Tarima ta tano fakanai ekeani, ekirani, ‘Vereḡauka ḡena dabara ḡoiarevaia, ḡena iaḡoma dabarana ḡovaḡa-maoromaoroa.’” ");
INSERT INTO snc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane ḡena dabuḡa tu kamela ḡuiri na ḡeveiato, ḡena gabaḡau tu nanigosi kefina. Ḡana ḡaniḡani dagarari tu madudu e gode nanuri moḡo. ");
INSERT INTO snc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tarimarima Ierusalema na e Iudea mabarana na ema Ioridana douka vanuḡari mabarari na maki ḡeiaḡoto-ḡoi Ioane ḡenai. ");
INSERT INTO snc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ḡeri rakava ḡekiraḡi-foforirito-ḡoi vau, ebabatisorito-ḡoi Ioridana ḡarukanai. ");
INSERT INTO snc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisea e Sadukea tarimari ḡutuma maki ḡia ḡenai ḡeiaḡoto bene babatisori ḡana. Ioane na eḡitarito nai, ekirarito, ekirato, “Ḡomi mota naturi, dei na bekirami, Barau ḡena Kota baregona ḡarona ḡenana boḡo raga-maḡurini? ");
INSERT INTO snc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ḡemi rakava ḡerina boḡono vetuḡamaḡi-kure, benamo ḡemi maḡuri ai ḡwaḡwa namori boḡono vaḡa-ḡwari. ");
INSERT INTO snc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ema nuḡami ai asi boḡono kira, ‘Aberahamo tu ḡai tamama, (be Barau na beḡabi-raḡemani).’ Korana akiramini, Barau tu ma seḡukana, Aberahamo natuna tu mai fore ḡerina bevaḡa-ḡorarini!” ");
INSERT INTO snc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Toma koko tu ḡau korari ai varau beḡe toreri; moḡa lorinai ḡwaḡwa namori asi ḡevaḡa-ḡorarini ḡauri mabarari tu beḡe basirini, karavai beḡe fiu-raḡerini. ");
INSERT INTO snc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Deikara ḡena rakava ḡerina evetuḡamaḡi-kureni tarimana, au na tu nanu na ababatisoani. Senaḡi au murigu na beiaḡomani tarimana ḡena seḡuka tu lelevaḡi, au ḡegu seḡuka maki evanaḡiani, ema ḡia ḡena tamaka maki au na asi baḡwa-rakaorakaoani riba. Ḡia na tu Iauka Veaḡa e karava na bebabatisomini. ");
INSERT INTO snc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ḡia ḡimanai tu iareva-iareva dagarana, widi momona tu widi tauri ḡenana bene iareva-ḡitakauri ḡana. Benamo widi tu ḡena vaḡa-vegogo numanai bevaḡa-vegogorini, senaḡi widi momona begabuani asi ebuseni karavanai.” ");
INSERT INTO snc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Moḡa neganai Iesu tu Galilea vanuḡana na Ioridana ḡarukana ḡana eiaḡoto, Ioane na bene babatisoa ḡana. ");
INSERT INTO snc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Senaḡi Ioane na ekiraḡoiato, ekirato, “Bere namo ḡoi na au boro babatisogu. Karase nai au ḡegu ai boiaḡoma?” ");
INSERT INTO snc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Iesu na evaḡa-veseato, ekirato, “Veiḡana noveia, korana veiḡa iobukaiobuka o Barau ḡena ura veiḡari mabarari bitana korana-iaḡiri tu namo.” Benamo Ioane na Iesu ḡena ura veiḡana eveiato. ");
INSERT INTO snc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu ebabatisoato, nanu na eraka-raḡasito nuḡanai, guba evekeo-fakato, benamo ḡia na Barau Iaukana eḡitaiato, pune kavana emariḡoto ḡia iatanai. ");
INSERT INTO snc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ema garo ta guba na ekea-riḡoto, ekirato, “Mai tu au Natugu, aura-viniani; ema ḡia ḡenai aiaku-rakavani maki.” ");
INSERT INTO snc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Moḡa murinai Iauka Veaḡa na Iesu tano fakana ḡana eḡori-iaḡoato, Diabolo na bene riba-ḡania ḡana. ");
INSERT INTO snc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ḡaro e boḡi gabana vasivasi (40) nuḡari ai asi eḡaniḡanito, eḡani-veaḡato; moḡa lorinai vito na eḡabi-rakavaiato. ");
INSERT INTO snc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Benamo Veribaḡani Tarimana Diabolo ḡia ḡenai eiaḡoto, ekiraiato, ekirato, “Bema ḡoi Barau Natuna nai, mai fore nokirari, be ḡaniḡani ai ḡeiaḡo.” ");
INSERT INTO snc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A Iesu na evaḡa-veseato, ekirato, “Buka Veaḡa nuḡanai maiḡesi ekirani, ‘Tarimarima tu dia ḡaniḡani na moḡo bemaḡurini. Senaḡi Barau ḡena guruḡa beḡabi-raḡerini e bekorana-iaḡirini tarimana tu maḡuri beḡabiani.’” ");
INSERT INTO snc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Benamo Diabolo na Ierusalema, siti veaḡana, ḡana eḡori-iaḡoato, Rubu Veaḡa tuḡuna vanigerenai evaḡa-ruḡakauato. ");
INSERT INTO snc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Benamo ekirato, “Bema ḡoi Barau Natuna, mainana noburi-firiḡo, korana Buka Veaḡa nuḡanai maiḡesi ekirani, ‘Barau na ḡena aneru bevaḡa-naḡirini, benamo ḡimari na beḡe ḡobemuni, beḡe ḡabi-vaisimuni, kwakumu fore ai asi boraraiani.’” ");
INSERT INTO snc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu na ma evaḡa-veseato, ekirato, “Buka Veaḡa nuḡanai maki ekirani, ‘Vereḡauka ḡoi ḡemu Barau asi bono riba-ḡania.’” ");
INSERT INTO snc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Benamo Diabolo na Iesu eḡori-raḡeato ḡoro baregona e maukana ta tuḡunai, tanobara basileiari mabarari ma marevari namori e ma seḡukari ḡesi evaḡa-ḡitaiato, ");
INSERT INTO snc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ekirato, “Bema ḡoiragu ai bovetui-tarini e au botoma-rakarioḡo viniguni nai tu, maiḡeri mabarari au na bavinimuni.” ");
INSERT INTO snc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Benamo Iesu na ekiraiato, ekirato, “Satani, au ḡeguna noraka-veḡita. Korana Buka Veaḡa nuḡanai ekirani, ‘Vereḡauka ḡoi ḡemu Barau bono toma-rakariḡo vinia, ḡia moḡo ḡereḡana vetuḡunaḡina bono iaḡo-vini!’” ");
INSERT INTO snc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Benamo Diabolo na eraga-kwaneato. Aneru kotari Iesu ḡenai ḡeiaḡoto, ḡenariato. ");
INSERT INTO snc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu eseḡaḡito, Ioane ḡe-diburaiato, benamo Galilea tanona ḡana ma eḡenoḡoi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Senaḡi Nasareta vanuḡana ma eragakwaneato, asi etanuto, eiaḡoto, Kaperanaumai ea tanuto. Kaperanaumai tu Genesareta kouna sevina vanuḡana ta, Sebulun e Naftali tanori nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Moḡa ḡenana Isaia, peroveta tarimana, ḡena guruḡa emoḡonito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun e Naftali tanori ai ḡotanuni tarimami o, Galilea kouna rikinai ema Ioridana ḡarukana mo rekenai, irau bese tarimami, Barau asi ribami tarimami, ḡemi Galilea tu moḡa, ḡoseḡaḡi. ");
INSERT INTO snc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mukunai ḡetanuto-ḡoi tarimari tu mama barana varau ḡeḡitaiani. E mo dei mukuna furufuru tanonai ḡetanuto-ḡoi tarimari iatari ai mama varau bema fofori.” ");
INSERT INTO snc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mo negai vau Iesu na ḡena vari eḡobata-iaḡi-foforiato, ekirato, “Ḡemi rakava ḡerina ḡovetuḡamaḡi-kure, ema ḡoraka-kure Barau ḡenai, korana Guba Basileiana tu bevotu, (Barau ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa).” ");
INSERT INTO snc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Galilea kouna kone rikina na eraka-iaḡoto-ḡoi nuḡanai, tarikaka ruarua, Simona, arana ta tu Petero, ma tarina Anduru ḡesi eḡitarito, ḡeri reke kou ai ḡefiuato, korana ḡia tauri ruarua tu maina tarimari. ");
INSERT INTO snc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Ḡoiaḡoma, murigu ai ḡoma raka, be au na tu tarimarima maina viniri bana vaḡa-ribami.” ");
INSERT INTO snc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Benamo maoromaoro ḡeri reke ḡeraga-kwanerito, Iesu murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Monana ḡeraka-iaḡoto-ḡoi nai, Iesu na tarikaka ruarua ma eḡitarito, Iakobo (o Iames) Sebedaio ma tarina Ioane ḡesi; ḡeri ḡasi ai tamari Sebedaio ḡesi ḡeri reke ḡwadareri ḡeturirito. Iesu na ekearito, ");
INSERT INTO snc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","benamo maoromaoro ḡeri ḡasi e tamari ḡeraga-kwanerito, Iesu murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu Galilea tanona mabaranai erakaoto-ḡoi, Iuda tarimari ḡeri rubu nuḡari ai evevaḡa-ribato-ḡoi, e Barau ḡena Basileia, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani), varina namona eḡobata-iaḡiato-ḡoi. Ema tarimarima ḡeri keve e midigu irauirau mabarari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ḡia varina ḡefiuato, Siria tanona mabarana eḡabiato, benamo tarimarima na ḡeri keve tarimari mabarari ḡia ḡenai ḡeḡwa-iaḡorito e ḡeḡori-iaḡorito: Midigu irauirau, iauka rakavari na ḡeboroḡirito tarimari, ḡue na evaḡiani kevena, tauḡani ḡeḡoḡoḡoḡoni, e tauḡaniri tavi tari ḡemaseto tarimari, Iesu na mabarari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tarimarima ḡutuma-bara ḡia murinai ḡerakato, Galilea na, Vanuḡa Gabanana (10) na, Ierusalema na, Iudea na, ema Ioridana ḡarukana mo rekena na maki ḡia ḡekavaiato. ");
INSERT INTO snc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu na tarima ḡutuma-bara eḡitarito, benamo ḡoro tai eraḡeto, iatanai etanu-tarito. Ḡena mero ḡia ḡenai ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Benamo ḡia na evaḡa-riba matamarito, maiḡesina ekirato: ");
INSERT INTO snc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Manau tarimari, Barau ḡenai moḡo ḡevetabekauni tarimari, tu beḡene iaku, korana Barau ḡena Basileia tu ḡia ḡeri. ");
INSERT INTO snc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Deidei toma ḡenuḡa-midigu midiguni tarimari tu beḡene iaku, korana Barau na ḡeri nuḡa-midigumidigu bevaḡa-magorini. ");
INSERT INTO snc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Manau tarimari tu beḡene iaku, korana Barau na tanobara mabarana ḡia bevinirini. ");
INSERT INTO snc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Veiḡa iobukaiobuka vitona ḡevito-iaḡiani e nanumasena ḡenanumase-iaḡiani tarimari tu beḡene iaku, korana vau beḡe ḡani-maseni. ");
INSERT INTO snc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vevetuḡaḡwa tarimari tu beḡene iaku, korana Barau na ḡia maki bevetuḡa-ḡwarini. ");
INSERT INTO snc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Deidei nuḡari namo vedaurea tarimari tu beḡene iaku, korana ḡia na Barau beḡe ḡitaiani. ");
INSERT INTO snc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Deidei na toma vevaḡa-maino veiḡari ḡeveirini tarimari tu beḡene iaku, korana Barau na ḡia natunai bekiraḡirini. ");
INSERT INTO snc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Deidei na toma veiḡa iobukaiobukari ḡeveirini ḡaramanai ḡevaḡa-midigu midigurini e ḡevaḡa-rakavarini tarimari tu beḡene iaku, korana Guba Basileia tu ḡia ḡeri. ");
INSERT INTO snc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bema au murigu ai ḡorakani ḡaramanai ḡomi beḡe mugumugu-iaḡimini, beḡe vaḡa-midigu midigumini, e veiḡa rakavari irauirau ḡemi ai beḡe kiraḡirini beḡe ḡofaḡofa-iaḡimini nai, boḡono iaku. ");
INSERT INTO snc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Boḡono iaku, boḡono verere, korana Barau na voimi baregona bevinimini gubai. Maiḡesina veiḡa ilailana, ḡomi murimi tarimari, peroveta tarimari guineri, na maki moḡesi ḡevaḡa-rakavarito.” ");
INSERT INTO snc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ḡomi tu tanobara damenana. Bema damena mamina korikorina bekorini nai, kamara dabarai mamina ma beḡenoḡoini? Mai tu varau berakava, asi ḡena namo ta. Moḡa lorinai beḡe fitoḡaiani, benamo tarimarima kwakuri na ma beḡe fanafana-tariani. ");
INSERT INTO snc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ḡomi tu tanobara mamana. Ḡoro tuḡunai ḡevaḡa-ruḡaiato vanuḡana tu asi bevekuretoḡani riba. ");
INSERT INTO snc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lamefa beḡe gabuani maki, ḡuro gaburenai asi beḡe toreani, senaḡina lamefa toretorena fatana korikorinai beḡe tore-kauani. Benamo ḡia mamana na numa tarimari mabarari bevinirini. ");
INSERT INTO snc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ilailana, ḡomi ḡemi mama tarimarima ḡoirari ai moḡesi boḡono vaḡa-foforiri, be ḡemi veiḡa namori beḡene ḡitari, benamo Tamami gubai etanuni tu beḡene vaḡa-raḡea.” ");
INSERT INTO snc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Maiḡesina asi boḡono tuḡa-maḡi, au aiaḡomato tu, Mose ḡena taravatu e peroveta tarimari ḡeri guruḡa asi aniri ai bana vaḡa-iaḡori ḡana. Asiḡina. Au tu asi aiaḡomato moḡeri guruḡa asi tauri ai bana vaḡa-iaḡori ḡana, senaḡi bana vaḡa-moḡoniri e bana vaḡa-kori ginikauri uranai aiaḡomato. ");
INSERT INTO snc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Moḡoni akira-mini, guba e tanobara roḡo ḡetanuni nuḡanai, taravatu ḡena leta misina korokorona ta o ḡena koma ta asiḡina ḡinavaḡi berekwa-rekwani, beiaḡoni mo, taravatu mabarari tauri korikori beḡea ḡorani. ");
INSERT INTO snc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Moḡa lorinai, tarima ta na taravatu misina korokorona ta bekira-sirivaḡi viniani, ema ḡena ura veiḡanai tarima kotari mai veiḡa ilailana ma bea vaḡa-ribarini, ḡia tu Guba Basileiai gabi tarimanai beḡe kiraḡiani. Senaḡina tarima ta na taravatu bekorana-iaḡirini ema tarima kotari ma bea vaḡa-riba iaḡirini, ḡia tu guine tarimanai beḡe kiraḡiani Guba Basileia nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Akira-korikorimini, bema ḡomi ḡemi vei-iobukaiobuka na Farisea e taravatu ḡevevaḡa-riba iaḡiani tarimari ḡeri vei-iobukaiobuka asi bevanaḡiani nai, ḡomi tu Guba Basileia nuḡanai asi boḡo raka-toḡani, asiḡina ḡinavaḡi.” ");
INSERT INTO snc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ḡomi ma ribami, tarima guineri na taravatu guruḡari ḡeḡabirito, ḡekirato, ‘Asi bono vaḡivaḡi! A deikara na tarima ta bevaḡiani nai, ḡia tu Kota gabuna ḡana beiaḡoni.’ ");
INSERT INTO snc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Senaḡi toma au na akiramini: Tarima ta tarikakana bebaru-viniani nai, ḡia tu Kota gabunai beḡe danaḡiani. E dei na tarikakana beguruḡa-rakava viniani nai, ḡia tu Kota baranai beḡe vaḡa-ruḡaiani. Ema dei na tarikakana bekiraiani, ‘Ḡoi tu babo korikori’ betoni nai, ḡia tu asi ebuseni karavana ḡana beiaḡoni. ");
INSERT INTO snc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Moḡa lorinai, bema ḡemu varevare dagarana fata veaḡana iatanai bono torekaua, Barau bono vinia otoni nuḡanai, ḡoi tarikamu otuḡamaḡiani, ḡia ma ḡena meto ḡoi ḡemu ai, ");
INSERT INTO snc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","benamo ḡemu varevare dagarana fata veaḡana ḡoiranai noraga-kwanea, noiaḡo, tarikakamu ḡesi maino boḡono ḡabia roḡo, gabivau bono ḡenoḡoi-iaḡo, ḡemu varevare dagarana fata veaḡanai bono torea Barau ḡena. ");
INSERT INTO snc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ḡoi ebaru-vinimuni tarimana ḡesi maino boḡono raga-ḡabia, Kota gabuna ḡana roḡo mani ḡoraka-vegogoni nuḡanai. Korana ebaru-vinimuni tarimana na Kota eseḡaḡini tarimana ḡimanai bea tore-kaumuni ḡesi, ema Kota eseḡaḡini tarimana na dibura numana ḡitaḡauna tarimana ḡimanai betoremuni, benamo ḡia na dibura numana nuḡanai bebiri-ḡaumuni garina. ");
INSERT INTO snc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au na akira-korikorimuni: Monana asi roḡo boraka-rosini, beiaḡoni mo, ḡemu meto voina bodava-ḡosiani.” ");
INSERT INTO snc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ḡomi ma ribami, tarima guineri na taravatu guruḡari ḡeḡabirito, ḡekirato, ‘Asi bono veḡura-vanaḡi!’ ");
INSERT INTO snc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Senaḡi au na akiramini: Deikara na tarima ta ḡaraḡona beḡita-karakaraiani ma eurani bene ḡabia ḡia ḡena, ḡia tu nuḡana tuḡamaḡina ḡenana varau beveḡura-vanaḡi mo vavine ḡenai. ");
INSERT INTO snc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bema ḡoi matamu aroribana na evaḡa-rakavamuni nai, bono ḡibo-vaḡia, bono fitoḡaia! Korana tauḡanimu rakavana rekena berekwa-rekwani tu namo, a asi namo tauḡanimu mabarana karava asi ebuseni gabunai beḡe fiu-kauani. ");
INSERT INTO snc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma bema ḡoi ḡimamu aroribana na evaḡa-rakavamuni nai, bono basi-ḡutua, bono fitoḡaia. Veiḡa namona tu, tauḡanimu rakavana rekena bono fitoḡa-guinea, be tauḡanimu mabarana karava eḡara-vanaḡi vanaḡini gabuna ḡana asi bene iaḡo.” ");
INSERT INTO snc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tarima guineri na taravatu guruḡari ḡeḡabirito, ḡekirato, ‘Tau ta ḡaraḡona betuḡu-rakaiani nai, ḡia na veḡaraḡo ruḡaruḡana fefana bene tore-vinia.’ ");
INSERT INTO snc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Senaḡina au na akiramini: Bema tarima ta ḡaraḡona betuḡu-dobiani, senaḡi vavine tu veḡura-vanaḡi veiḡari asi eveini, mo tau na ḡaraḡona tu veḡuravanaḡi vavinenai evaḡa-iaḡoani. Ema deikara na etuḡu-rakaiato vavinena beḡaraḡoani tarimana tu, beveḡura-vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ḡita senera ḡevaḡa-ribarito guruḡari ḡomi tu ma ribami: ‘Ḡemi guruḡatore asi boḡono vaḡa-rakavaia, senaḡi Vereḡauka ḡoiranai ḡokiraḡi-toreto dagarari boḡono veiri.’ ");
INSERT INTO snc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Senaḡi au na akiramini: Asi boḡono guruḡatore veḡata! Ḡemi guruḡa vaḡa-gwaḡiḡiri ḡana guba asi boḡono kiraḡia, guba aranai asi boḡono guruḡatore, korana ḡia tu Barau ḡena terona; ");
INSERT INTO snc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o tanobara aranai maki asiḡina, korana ḡia tu Barau kwakuna ḡena fanakau dagarana; o Ierusalema aranai, korana ḡia tu Kini baregona ḡena siti. ");
INSERT INTO snc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ḡoi debamu, ḡemu maḡuri, maki asi bono kiraḡia ḡemu guruḡatore vaḡa-gwaḡiḡina ḡana, korana ḡoi na ḡuimu sebona ta asi bovaḡa-kurokuroani e asi bovaḡa-dubadubaiani riba. ");
INSERT INTO snc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Namona tu maiḡa: Ḡemu guruḡa bono kiraḡia, ‘Oi’ bene oi e ‘Asiḡina’ bene asiḡina. Moḡa moḡo, a guruḡa tari ma okiraḡirini tu Tarima Rakavana, Satani, ḡenana eiaḡomani.” ");
INSERT INTO snc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tarima guineri ḡevaḡa-ribarito guruḡari ḡomi tu ma ribami, maiḡesi ḡekirato: ‘Mata voina mata e doḡa voina doḡa.’ ");
INSERT INTO snc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Senaḡina au na akiramini, veiḡa rakavana evei-vinimuni tarimana asi bono veiḡa rakava-vinia. Bema tarima ta na taḡomu aroribana beforoani nai, taḡomu kaurina ma bono vinia maki. ");
INSERT INTO snc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","E bema tarima ta na Kotai betoremuni ḡemu sedi bene ḡabia ḡana nai, ḡemu koudi maki bono vinia. ");
INSERT INTO snc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ema tarima ta na belau-naḡimuni, kilomita sebonai bono kavaia betoni nai, kilomita ruarua ai ma bono raka ḡia ḡesi. ");
INSERT INTO snc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ema enoḡinoḡini tarimana bono vinia, e ḡemu ai bene ḡabitore etoni tarimana maki asi bono kira-sirivaḡi vinia.” ");
INSERT INTO snc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tarima guineri ḡevaḡa-ribarito taravaturi ma ribami, ḡekirato: ‘Ḡoi sevimu tarimana bono ura-vinia, a evaḡa-rakavamuni tarimana bono vaḡa-rakavaia.’ ");
INSERT INTO snc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Senaḡina au na akiramini: Ḡebaru-vinimini tarimari boḡono ura-viniri, e dei na ḡevaḡa-rakavamini tarimari maki iatari ai boḡono ḡauḡau. ");
INSERT INTO snc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Maiḡa ḡenana boḡo vaḡa-foforiani, ḡomi tu Tamami gubai etanuni na natunai evaḡa-iaḡomito. Korana ḡia na ḡaro tu veiḡa rakava tarimari e veiḡa namo tarimari iatari ai evaḡa-raḡekauani, ema ḡura maki veiḡa iobukaiobuka e veiḡa ḡeḡeva-ḡeḡeva tarimari ḡeri etuḡu-riḡoani. ");
INSERT INTO snc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bema ḡoura-vinirini tarimari tu ḡomi ḡeura-vinimini tarimari moḡo nai, kamara varevare namona boḡo ḡabiani? Takesi ḡegogoni tarimari o ḡofaḡofa tarimari na maiḡesina maki ḡeveiani. ");
INSERT INTO snc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ema tarikakami moḡo boḡo vaḡa-namorini, ḡemi namo tu kara? Barau asi ribari tarimari na maki mai veiḡa ḡeveiani. ");
INSERT INTO snc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Moḡa lorinai ḡomi tu asi vetoukaumi boḡono tanu, ḡomi Tamami gubai etanuni asi vetou-kauna kavana.” ");
INSERT INTO snc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Rorimi boḡono vetore, ḡemi veiḡa namori tarimarima ḡoirari ai asi boḡono vaḡa-foforiri, ḡia na beḡene vaḡa-raḡemi ḡana. Maiḡeri boḡo veirini nai, Tamami gubai etanuni ḡenana voimi asi boḡo ḡabini. ");
INSERT INTO snc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Moḡesi nai, ḡemu varevare rabu tarimari bovinirini nai, asi bono ḡobata-iaḡia ma kibimu ḡesi, ḡofaḡofa tarimari rubu ai e vanuḡa ḡatamanai ḡeveini kavana, tarimarima na beḡene vevato-iaḡiri ḡana. Akira-korikorimini, ḡia tu tarimarima na ḡevaḡa-raḡerini, be voiri tu varau ḡeḡabirito. ");
INSERT INTO snc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sena-ḡina ḡoi ḡemu varevare asi ḡena-ḡana tarimana novinia botoni nai, ḡimamu kaurina asi bene riba, ḡoi ḡimamu aroribana na kara eveiani. ");
INSERT INTO snc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be ḡemu varevare vekuretoḡai bono vini. Ema Tamamu na, kara eḡorani vekure-toḡai eḡitarini, ḡia na vau voimu bevinimuni.” ");
INSERT INTO snc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bema boḡo ḡauḡauni nai, ḡofaḡofa tarimari kavana asi boḡono iaḡo! Ḡia ruḡaruḡari ai ma iakuri ḡesi ḡeḡuriḡurini, rubu nuḡari ai e vanuḡa ḡatamanai ema dabarai maki, tarimarima na beḡene ḡitari ḡana. Au na akira-korikorimini, ḡia voiri varau ḡeḡabito. ");
INSERT INTO snc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A ḡoi ourani bono ḡauḡau otoni nai, ḡemu numa daiḡutuna nuḡanai bono rakatoḡa, ḡatama-boka bono biri-ḡaua, monai vau Tamamu bono noḡi-vinia, ḡia tu vekuretoḡai etanuni. Ema Tamamu na, kara eḡorani vekuretoḡai eḡitarini, ḡia na vau voimu bevinimuni. ");
INSERT INTO snc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ḡomi boḡo ḡauḡauni nai, asi boḡono kiraḡi ḡenoḡoi-ḡenoḡoi guruḡa asi aniri ḡeri ai, Barau asi ribari tarimari ḡeveini kavana. Ḡia ḡetuḡamaḡini, ḡeri guruḡa vovoka ḡekiraḡirini naima, Barau na beseḡaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ḡia kavari asi boḡono iaḡo. Korana ḡomi na kara ḡoura-vinirini, Tamami na eriba-guineani, gabivau ḡomi na ḡonoḡi-viniani. ");
INSERT INTO snc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Maiḡesina boḡono ḡuriḡuri: ‘Ḡai Tamama o, gubai otanuni; ḡoi aramu baḡana vaḡa-veaḡaia; ");
INSERT INTO snc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ḡemu Basileia bene iaḡoma; ḡemu ura tanobarai baḡana veia, gubai ḡeveiani kavana. ");
INSERT INTO snc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ḡema-ḡama toma bono vinima. ");
INSERT INTO snc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ḡema rakava notuḡamaḡi-fitoḡari, ḡai ḡevaḡa-rakavamani tarimari ḡeri rakava ḡatuḡamaḡi-fitoḡarini vaḡa-ilailana. ");
INSERT INTO snc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Veribaḡani ai asi bono ḡori-kauma, a Rakava Tarimana, Satani, ḡimana na bono vaḡa-maḡurima. Korana Basileia tu ḡoi ḡemu, seḡuka ḡoi ḡemu, mareva baregona ḡoi ḡemu, toma bene iaḡo mo vanaḡivanaḡi, Amen.’ ");
INSERT INTO snc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bema ḡomi na ḡevaḡa-rakavamini tarimari ḡeri rakava boḡo tuḡamaḡi-fitoḡarini nai, Tamami gubai etanuni na ḡemi rakava maki betuḡamaḡi-fitoḡarini. ");
INSERT INTO snc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Senaḡina, bema ḡomi na ḡevaḡa-rakavamini tarimari ḡeri rakava asi boḡo tuḡamaḡi-fitoḡarini nai, Tamami na ḡemi rakava maki asi betuḡamaḡi-fitoḡarini.” ");
INSERT INTO snc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Boḡo ḡani-veaḡani nai, asi boḡono boḡe-vetuḡa, ḡofaḡofa tarimari ḡeveini kavari. Ḡoirari ai ḡevevaḡa-fofori ḡofakauni, tarimarima na mataboru beḡene kira, ‘Ḡeḡani-veaḡani kika’ beḡene si. Akira-korikorimini, ḡia voiri tu varau ḡeḡabirito. ");
INSERT INTO snc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A ḡoi, bema bono ḡani-veaḡa botoni nai, debamu ai deoro bono tore e ḡoiramu bono ḡuriḡia, ");
INSERT INTO snc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","be tarimarima na asi beḡene ribamu, ḡoi tu oḡani-veaḡani, senaḡina Tamamu veḡuni ai moḡo bene riba. Ema Tamamu na, kara eḡorani vekuretoḡai eḡitarini, ḡia na vau voimu bevinimuni.” ");
INSERT INTO snc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ḡemi farefare tu mai tanobarai asi boḡono vaḡa-vegogo! Korana faro ema lalalala o rasta na beḡe vaḡa-rakavarini ḡesi, ema lema tarimari na numa beḡe dareani ema beḡe lemarini. ");
INSERT INTO snc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ḡemi farefare gubai boḡono vaḡa-vegogo, faro e lalalala na asi beḡe vaḡa-rakavarini, ema lema tarimari na maki numa asi beḡe dareani ema asi beḡe lemarini riba. ");
INSERT INTO snc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ḡoi ḡemu farefare ainai etanuni, ḡoi nuḡamu maki monai etanuni.” ");
INSERT INTO snc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata tu tauḡani ḡena lamefa kavana. Bema ḡoi matamu namo nai, tauḡanimu mabarana maki bemamani. ");
INSERT INTO snc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Senaḡina bema ḡoi matamu tu rakava nai, tauḡanimu mabarana maki bemukunani. A bema mama ḡoi nuḡamu ai tu mukuna nai, mai mukuna tu bebarego-vedaureani!” ");
INSERT INTO snc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tarima ta na vere ruarua vetuḡunaḡiri asi beiaḡo-vinirini riba. Korana ḡia na ta tu asi beura-viniani, a ta tu beura-viniani; ta bevaḡa-moḡoniani, a ta tu beḡofaḡofa-iaḡiani. Barau ema moni nega sebonai vetuḡunaḡiri asi boḡo iaḡo-vinirini riba.” ");
INSERT INTO snc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Moḡesi naima akiramini, ḡemi maḡuri asi boḡono tuḡamaḡiri, kara boḡo ḡanini o boḡo niuni; o tauḡanimi kara na boḡo dabuḡarini. Aiḡa tu dagara barana, maḡuri ba ḡaniḡani? E aiḡa tu dagara barana, tauḡani ba dabuḡa? ");
INSERT INTO snc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gubai ḡerovoni manuri ḡoḡitari! Ḡia tu asi ḡevarovaroni e asi ḡekwakwani, ema vamoka numari ai maki ḡaniḡani asi ḡevaḡa-vegogoni. Senaḡi Tamami gubai etanuni na eḡuburini. Ḡomi tu dagara baregomi, a manu tu kei! ");
INSERT INTO snc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ḡomi deikara onuḡa-vekwaraḡini nai, ḡemu maḡuri kota ma bovaḡa-maukaiani riba ba? ");
INSERT INTO snc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Karase dabuḡa urari ai ḡove-tuḡamaḡi-vekwaraḡini? Boḡa veraverari ḡoḡitari, aiḡesi ḡegarani. Asi ḡeḡauveini e dabuḡa asi ḡeturini. ");
INSERT INTO snc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Senaḡina akiramini, Kini Solomona ḡena vedabuḡa marevana maki ḡevanaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mai tu Barau na tano ḡauḡari evaḡa-dabuḡarini, ḡia tu toma ḡegarani, a boinani tu karavai beḡe fiu-raḡerini, Barau tu moḡesina evaḡa-dabuḡarini. Ḡia na ḡomi asi veḡatana bevaḡa-dabuḡamini, ei? Ḡomi veḡabidadama misimisi tarimami! ");
INSERT INTO snc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Moḡesi nai, asi boḡono nuḡa-vekwaraḡi, asi boḡono kira, ‘Kara toma taḡanini?’ O ‘Kara toma taniuni?’ O ‘Kara toma tariḡoni?’ ");
INSERT INTO snc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Barau asi ribari tarimari na maiḡeri dagara mabarari ḡeraga-vetaurini, a Tamami gubai etanuni tu ribana, ḡomi na maiḡeri ḡoura-vinirini. ");
INSERT INTO snc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Senaḡina giniguine ḡia ḡena Basileia ema ḡena vei-iobukaiobuka boḡono vetau-guineri, benamo maniḡeri dagara mabarari ḡomi bevinimini. ");
INSERT INTO snc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Moḡesina naima boinani ḡaro tuḡamaḡi-vekwaraḡina asi boḡono vei; boinani ḡaro ḡena vekwaraḡi tu Barau ḡimanai. Toma ḡaro ḡena vekwaraḡi iatanai meto ma boḡo torekauani nai, kamasi boḡo ḡwaiani?” ");
INSERT INTO snc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tarimarima asi boḡono vetau-viniri, be Barau na maki asi bene vetau vinimi. ");
INSERT INTO snc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Korana tu ḡomi ḡemi vetauvini ilailanai, ḡomi maki moḡesina moḡo Barau na bevetau-vinimini; ema aiḡesi ḡovevaḡa-vetovo vinirini, Barau na maki moḡesi bevevaḡa-vetovo vinimini. ");
INSERT INTO snc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Karase nai tarikakamu matanai libika oḡitaiani, senaḡi ḡau tubina ḡoi matamu nuḡanai maniḡa tu asi otuḡamaḡiani? ");
INSERT INTO snc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kamara dabarai ḡoi tarikakamu okiraiani, ‘Ḡata, au na roḡo matamu ai libika nakokia,’ senaḡina ḡoi tauḡemu matamu ai ḡau tubina ta etanuni? ");
INSERT INTO snc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ḡoi ḡofaḡofa taumu, guine tu ḡoi matamu ai ḡau tubina nokoki-vaḡia roḡo, benamo boboḡeboḡe-ginikauni vau, tarikakamu matanai libika bono ḡabi-vaḡia. ");
INSERT INTO snc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dagara veaḡari kwaiva (o kira-sirivaḡi tarimari) asi boḡono viniri, ema ḡemi aḡeva maki asi boḡono fiu-rosiri bai ḡoirari ai! Kwakuri na beḡe fana-taririni, benamo beḡe doḡe-kureni, ma beḡe dare-misi misimini garina.” ");
INSERT INTO snc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Noḡinoḡi ai Barau na bevini-mini, vetauvetau ai boḡo doḡarini, sekeseke ai ḡemi ḡatama boka bekeoani. ");
INSERT INTO snc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Korana benoḡi-noḡini tarimana tu beḡabini, bevetauni tarimana bedoḡarini, ema beseke-sekeni tarimana Barau na ḡena ḡatama-boka bekeoani. ");
INSERT INTO snc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ḡomi dei bema natumu merona ḡaniḡani benoḡini nai, ḡoi na fore boviniani? ");
INSERT INTO snc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O maḡani-kone benoḡini nai, mota boviniani? ");
INSERT INTO snc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Boḡono tuḡamaḡi, ḡomi tu rakava tarimami, senaḡi dagara namori natumi viniviniri ma ribami, moḡa lorinai ḡomi Tamami gubai etanuni, ḡia na dagara namori ḡenoḡi-viniani tarimari bevinirini veḡatana! ");
INSERT INTO snc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ḡomi kara ḡourani tarimarima na ḡemi ai beḡene veiri veiḡari, ḡia ḡeri ai maki moḡeri veiḡa boḡono veiri. Mose ḡena taravatu e peroveta ḡeri vevaḡa-riba guruḡari tauna korikorina tu moḡa.” ");
INSERT INTO snc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ḡatama-boka kibobonai boḡono rakatoḡa. A mase gabuna ḡana eiaḡoni dabarana tu baḡaka, e ḡena ḡatama-boka tu barego rakava, ema ḡutuma maki monai ḡeraka-toḡani. ");
INSERT INTO snc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Senaḡi maḡuri vanaḡivanaḡi ḡana eiaḡoni ḡatama bokana tu kibobo e dabara maki kei rakava, ema tarimarima viravira na moḡo ḡedoḡariani.” ");
INSERT INTO snc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Rorimi boḡono vetore peroveta tarimari ḡofaḡofari ḡerina. Ḡia ḡomi ḡemi ai ḡeiaḡomani tu ma mamoe dabuḡari ḡesi, senaḡina nuḡari ai ḡeri tuḡamaḡi tu boḡa kwaivari rakavari kavari. ");
INSERT INTO snc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ḡia ḡwaḡwari ai vau boḡo ribarini. Vine ḡwari (o grapes) tu ḡau ma giniri ḡerina asi ḡebokoni, ema figi ḡwari maki ḡauḡa ḡiniḡiniri ḡeri ai asi ḡeḡabini. ");
INSERT INTO snc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ḡau namona ḡenana ḡwaḡwana namona bevaḡa-ḡoraiani, a ḡau rakavana ḡenana maki ḡwaḡwana rakavana bevaḡa-ḡoraiani. ");
INSERT INTO snc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ḡau namona na ḡwaḡwa rakavana asi beḡwani riba, ilailana ḡau rakavana na ḡwaḡwa namona asi beḡwani riba. ");
INSERT INTO snc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ḡwaḡwa namori asi ḡeḡwani ḡauri tu beḡe basirini, ma karavai beḡe fiu-raḡerini. ");
INSERT INTO snc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Moḡesina ilailanai peroveta tarimari ḡofaḡofari tu ḡwaḡwari ai boḡo ribarini. ");
INSERT INTO snc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Dia ‘Vereḡauka, Vereḡauka,’ ḡetoguni tarimari mabarari tu Guba Basileiai beḡe raka-toḡani. Asiḡina. Deikara Tamagu gubai etanuni ekorana-iaḡiani e ḡena ura veiḡari eveirini tarimana ḡereḡana moḡo. ");
INSERT INTO snc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kota baregona ḡarona beraḡasini nai, tarima ḡutuma na beḡe kiraguni, beḡe kirani, ‘Vereḡauka, Vereḡauka, ḡoi aramu ai ḡaperovetato, e ḡoi aramu ai iauka rakavari ḡalai-vaḡirito, ma ḡoi aramu ai nuḡa-farevaḡi veiḡa boruri ḡutuma maki ḡaveirito.’ ");
INSERT INTO snc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Benamo au na bakirarini, bakirani, ‘Au asi ribagu ḡomi. Ḡeguna ḡoraka-veḡita, ḡomi veiḡa rakava tarimami!’” ");
INSERT INTO snc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Moḡa lorinai, tarima ta na ḡegu guruḡa maiḡeri eseḡaḡirini, ma veiḡari eveirini tu, tarima iaunegana na ḡena numa fore iatari ai evaḡa-ruḡaiato kavana. ");
INSERT INTO snc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ḡura baregona eraguto, ḡaruka mabarari ḡeḡabatarito, iavara asikeikeina eragato nai, mo numa edoriato; senaḡina asi eḡwa-lauato, korana ḡia tu fore iatanai evaḡa-ruaḡaiato nai. ");
INSERT INTO snc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A deikara na ḡegu guruḡa maiḡeri eseḡaḡirini, senaḡi veiḡari tu asi eveirini, ḡia tu tarima babona noḡa, numa eragato nai, miri iatanai moḡo evaḡa-ruḡaiato. ");
INSERT INTO snc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ḡura baregona eraguto, ḡaruka mabarari ḡeḡabatarito, iavara asikei eraḡasito, mo numa edoriato nai, eḡwa-lauato, benamo eḡwa-rovorovoto.” ");
INSERT INTO snc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu na ḡena ḡobata guruḡari maiḡeri ekiraḡi-ḡosirito nai, mai vegogo tarimari ḡutuma-bara na ḡena vevaḡa-riba guruḡari ḡeḡaba-iaḡirito. ");
INSERT INTO snc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Korana ḡena guruḡa ma seḡukana, dia ḡeri taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ḡeri guruḡa kavana. ");
INSERT INTO snc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu ḡoro tuḡuna na ma emariḡoto nai, tarima ḡutuma-bara ḡia murina na ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Benamo tarima ta ma leperana Iesu ḡenai eiaḡoto, ḡoiranai evetui-tarito, ekirato, “Vereḡauka, bema ḡoi ourani nai, moḡoni boiarevaguni, bovaḡa-namoguni riba!” ");
INSERT INTO snc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu na ḡimana eduḡi-roroḡotoato, keve tarimana eḡabi-karaiato, ekirato, “Aurani, be nonamo!” Benamo vaḡa-sebo lepera na enamoto. ");
INSERT INTO snc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iesu na evaḡa-guruḡaiato, ekirato, “Tarima ta asi bono kira-varaia. Noiaḡo, Rubu Veaḡa verena na bene ḡitamu, ema veiareva varevare dagarari Mose na ekiraḡiato ilailanai bono vinia; be tarimarima beḡene riba, ḡoi tu bonamo.” ");
INSERT INTO snc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kaperanauma ai eraḡasito nai, Roma vetari verena ta ḡia ḡenai eiaḡoto, Iesu enoḡiato, ");
INSERT INTO snc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ekirato, “Vereḡauka, ḡegu vetuḡunaḡi merona tauḡanina asi eḡarevani, be numai egena-taḡoni, ema midigu maki barego eḡanini.” ");
INSERT INTO snc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu na ekiraiato, ekirato, “Au aiaḡosini, be asi-vaḡa-namoani.” ");
INSERT INTO snc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Vetari verena na evaḡa-veseato, ekirato, “Vereḡauka, au tu asi ilaila ḡoi ḡegu numai boraḡe-kauni; senaḡi ḡoi noguruḡa moḡo, benamo au ḡegu vetuḡunaḡi merona benamoni. ");
INSERT INTO snc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au maki tarima kota ḡeri veḡitaḡau gabureri ai, ema vetari tarimari o soldia tu au gaburegu ai. Au na ta bakiraiani, ‘Noraka!’, benamo berakani, ma ta bakiraiani, ‘Noiaḡoma!’, benamo beiaḡomani. Ema au ḡegu vetuḡunaḡi merona bakiraiani, ‘Maiḡa noveia!’, benamo beveiani.” ");
INSERT INTO snc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu na ḡena guruḡa eseḡaḡiato nai, eḡaba-rakavato. Benamo ḡia murinai ḡerakato tarimari evaḡa-guruḡarito, ekirato, “Au na akira-korikorimini, Isaraela nuḡanai mai-ḡesina veḡabidadama ta roḡosi bana doḡaria. ");
INSERT INTO snc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Au na akiramini maki, tarimarima ḡutuma ḡaro-raḡe e ḡaro-riḡo rekeri na beḡe iaḡomani, Aberahamo, Isako, e Iakobo ḡesi vereko baregonai beḡe ḡani-vegogoni Guba Basileiana nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Senaḡina tovotovonai Barau na eḡabi-viriḡirito tarimari, Basileia nuḡanai beḡene tanu etato tarimari tu, Barau na befiu-rosirini murikai, mukuna furufuru nuḡanai. Monai beḡe taḡini, e gadikari maki beḡe veḡara-tarini.” ");
INSERT INTO snc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Benamo Iesu na vetari verena ekiraiato, ekirato, “Noiaḡo, ḡemu numa ḡana! Boveḡabidadama lorinai, veiḡana beḡorani.” Ḡena vetuḡunaḡi merona mo horai varau enamoto. ");
INSERT INTO snc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu Petero ḡena numai eraka-toḡato. Monai Petero ḡena taḡama vavinena ekeveto, tauḡanina eseḡukato, be egena-taḡoto-ḡoi, Iesu na eḡitaiato; ");
INSERT INTO snc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ḡimanai eḡabito, benamo ḡena keve ekorito, evaisi-raḡeto, benamo ḡia eḡubuato. ");
INSERT INTO snc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lavilavi ai iauka rakavari na ḡeboroḡirito tarimari ḡutuma Iesu ḡenai ḡeḡori-iaḡorito. Iesu na moḡeri iauka rakavari ḡena guruḡa seḡukana ḡenana moḡo elai-vaḡirito, e keve tarimari mabarari maki evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Maiḡeri veiḡa vaḡa-moḡoniri tu Isaia, peroveta tarimana, na ekiraḡiato kavana, ekirato, “Ḡia na ḡera midigumidigu eḡabi-veḡitarito, ema ḡera keve irauirau eḡwarito, evaḡa-namorito.” ");
INSERT INTO snc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu na tarimarima ḡutuma na ḡevegogo-ḡeḡeraḡiato eḡitarito, benamo ḡena mero ekirarito, ekirato, “Siveḡasi-vanaḡi, kou mo rekena ḡana.” ");
INSERT INTO snc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nuḡanai taravatu evevaḡa-riba iaḡiato-ḡoi tarimana ta Iesu ḡenai eiaḡoto, ekirato, “Vevaḡa-riba tarimamu, ḡoi aiḡana boiaḡoni nai, au ḡoi murimu ai moḡo bana raka atoni.” ");
INSERT INTO snc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu na ekiraiato, ekirato, “Boḡa kwaivari ma ḡeri kouḡa, ema manu ma ḡeri nuḡi, senaḡi Tarimarima Natuna tu asi ḡena gena gabuna.” ");
INSERT INTO snc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iesu ḡena mero ta na maki evaḡa-guruḡaiato, ekirato, “Vereḡauka, mani ḡemu veiḡa, naḡenoḡoi, be tamagu roḡo naguria.” ");
INSERT INTO snc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesu na evaḡa-veseato, ekirato, “Murigu ai noma raka, mani tu noiaḡuiri; mase tarimari (o Barau asi ḡekorana-iaḡiani tarimari) na ḡeri mase tauḡeri na beḡene guriri.” ");
INSERT INTO snc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu ḡasi ai eraḡeto nai, ḡena mero maki ḡia ḡesi ḡeraḡe-sebonato. ");
INSERT INTO snc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ḡeiaḡoto-ḡoi nai, asikauna iavara asikei kou ai eraḡasito, benamo ureure tu ḡasi nuḡanai ḡevebubu-ḡurato. A Iesu tu egenato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Benamo ḡena mero ḡeiaḡoto ma ḡevaḡoato, ḡekirato, “Vereḡauka, novaḡa-maḡurima, ḡita tu mai taburuni, dori tamaseni. ");
INSERT INTO snc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu na evaḡa-veserito, ekirato, “Karase nai ḡogarini? Veḡabidadama kei rakava tarimami!” Benamo Iesu evariḡisito, iavara ma ureurena ḡesi ekira-ḡoirito, benamo ḡedokoto, ḡemeḡomeḡo-tarito. ");
INSERT INTO snc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tarimarima mabarari ḡeḡaba-rakavato, ḡekirato, “Mai tu kamara tarima se? Iavara e ureure na maki garona ḡeseḡaḡiani!” ");
INSERT INTO snc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galilea kouna tavina rekenai, Gadara (o Gerasa) tarimari ḡeri tano ai, Iesu eraḡasito, benamo iauka rakavari na ḡeboroḡirito tarimari ruarua gara kouḡari na ḡeiaḡomato-ḡoi Iesu ḡenai. Mai tarima ruarua tu ma gariri, moḡa lorinai tarima ta mo dabara na asi eraka-vanaḡito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Benamo tauri ruarua Iesu ḡeḡaba-viniato, ḡekirato, “Barau Natuna o, kara ḡai ḡemai noveia otoni? Ḡoi boiaḡoma maiḡa tu, noma vaḡa-midiguma ḡana, ḡaro korikorina roḡosi roḡo bene raḡasi nuḡanai, ei?” ");
INSERT INTO snc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Monai, asi manaḡa lelevaḡi, bai serina ḡedokadokato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Moḡesina nai iauka rakavari na Iesu ḡenoḡiato, ḡekirato, “Bema ḡoi na ḡai bolai-vaḡimani nai, notuḡuma bai ḡeri ai, ḡia nuḡari ai ḡaraka-toḡa.” ");
INSERT INTO snc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu na ekirarito, ekirato, “Be ḡoiaḡo!” Benamo iauka rakavari mo tarima ruarua ḡerina ḡeraka-vaḡito, ḡeiaḡoto, bai ḡeri ai ḡeraka-toḡato. Benamo bai serina mabarana eḡwa-bubu-lausiato, lalaḡa na ḡekokosi-firiḡoto, kou ai ḡeveḡuḡutu-maseto. ");
INSERT INTO snc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bai ḡitaḡauri tarimari ḡeraga-kwareḡato, vanuḡa ḡana ḡeiaḡoto, vari mabarana ḡekiraḡiato, ema iauka rakavari na ḡeboroḡirito tarimari ḡeri ai kara ḡeḡorato mabarari maki ḡevaḡa-foforirito. ");
INSERT INTO snc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Benamo vanuḡa tarimari mabarari ḡeḡoto-iaḡoto, Iesu beḡene ḡitaia ḡana. Iesu ḡenai ḡeraḡasito nai, ḡenoḡiato, ḡeri tano na bene raka-veḡita. ");
INSERT INTO snc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu ḡasi tai eraḡekauto, ma eḡenoḡoito, kou na evanaḡito, ḡena vanuḡa korikori ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Monai tarima kotari na tauḡanina tavi ta emaseto tarimana ta gedai genagenanai Iesu ḡenai ḡeḡwa-iaḡoato. Iesu na ḡeri veḡabidadama vetoḡana aiḡa barana eḡitaiato, benamo keve rakava tarimana ekiraiato, ekirato, “Natugu, bono kokore, ḡemu rakava batuḡamaḡi-fitoḡari.” ");
INSERT INTO snc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Benamo taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari tauḡeri maiḡesina ḡekirato, “Mai tarima na Barau ekira-fitoḡaiani.” ");
INSERT INTO snc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu ma ribana ḡia kara ḡetuḡa-maḡirito-ḡoi nai evaḡa-guruḡarito, ekirato, “Karase nai maniḡesina tuḡamaḡi rakavari ḡoḡabini? ");
INSERT INTO snc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aiḡesina baguruḡani tu meraḡa, ‘Ḡemu rakava batuḡamaḡi-fitoḡari’ banasi, ba bara kira, ‘Noruḡa-vaisi, noraka’ barasi? ");
INSERT INTO snc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Au na navaḡa-ḡitami, Tarimarima Natuna tu ma ḡena maoro, rakava betuḡamaḡi-fitoḡarini tanobarai.” Benamo Iesu na keve rakava tarimana evaḡa-guruḡaiato, ekirato, “Novariḡisi, ḡemu geda noḡabia, be numa ḡana noiaḡo!” ");
INSERT INTO snc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Benamo mo tarima evaisiraḡeto, ḡena numa ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tarimarima na mo veiḡa ḡeḡitaiato nai, ḡegarito e Barau ḡevaḡa-raḡeato, korana seḡuka moḡesina tarimarima evinirito nai. ");
INSERT INTO snc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu monana eraka-vanaḡito nai, ḡia na tarima ta arana Mataio eḡitaiato, takesi moniri ḡeḡabito-ḡoi numanai etanu-taḡoto-ḡoi nai eḡitaiato. Benamo Iesu na ekiraiato, ekirato, “Murigu ai noma raka.” Benamo Mataio evaisiraḡeto, Iesu murina na eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesu Mataio ḡena numai eḡaniḡanito-ḡoi nai, takesi gogo tarimari vovoka e vei-rakava tarimari ḡutuma maki ḡeiaḡomato, Iesu ma ḡena mero ḡesi ḡeḡaniḡani-vegogoto. ");
INSERT INTO snc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisea tarimari kotari na ḡeḡitaiato nai, Iesu ḡena mero ḡedanaḡirito, ḡekirato, “Karase nai ḡomi ḡemi vevaḡa-riba tarimana tu takesi gogo e vei-rakava tarimari ḡesi ḡeḡaniḡani-vegogoni?” ");
INSERT INTO snc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu na mo guruḡa eseḡaḡiato, benamo evaḡa-veserito, ekirato, “Namo tarimari na doketa asi beḡe vetaurini, senaḡina keve tarimari na moḡo. ");
INSERT INTO snc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ḡoiaḡo, tauḡemi na Buka Veaḡa na ekiraḡiani guruḡana ḡoa vetaua, maiḡesina ekirani, ‘Au na dia ḡomi ḡemi ginitaḡo o boubou varevareri aura-vinirini. Au aurani ḡomi na vevetuḡaḡwa e veiau-namo boḡono vaḡa-foforiri.’ Au tu vei-iobukaiobuka tarimari keakeari asi aiaḡomato, senaḡi vei-rakava tarimari moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Moḡa murinai Ioane Babatiso ḡena mero Iesu ḡenai ḡeiaḡoto, benamo ḡedanaḡiato, ḡekirato, “Karase nai ḡai e Farisea tarimari tu ḡaḡani-veaḡani, a ḡoi ḡemu mero tu asi ḡeḡani-veaḡani?” ");
INSERT INTO snc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡotuḡamaḡini, veḡaraḡo varigu tarimana ḡatana seviri ai etanuni nuḡanai beḡe taḡini ba? Asiḡina! Ḡarona eiaḡomani, veḡaraḡo variḡu tarimana ḡatana ḡerina beḡe ḡabi-veḡitaiani, monai vau beḡe ḡani-veaḡani. ");
INSERT INTO snc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tarima ta na dabuḡa variḡuna veseana dabuḡa guinena ḡesi asi bebani-vegogoani. Bema moḡesina beveini nai, dabuḡa variḡuna na guinena bedareani, ema vedarena maki bebaregoni. ");
INSERT INTO snc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tarima ta na maki vine nanuna variḡuna nanigosi kefina guinenai asi besisiani. Bema moḡesina beveini nai, nanigosi kefina guinena bevedareni, vine nanuna bevebubuni, ema kefi maki berakavani. Senaḡina vine nanuna variḡuna nanigosi kefina variḡunai bebubu-ḡuriaiani tu namo. Benamo ruarua, vine nanuna e kefi, beḡe tanuni, asi beḡe rakavani.” ");
INSERT INTO snc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu na roḡo ḡena mero evaḡa-ribarito-ḡoi nuḡanai, vere ta eraḡasito, Iesu kwakuna koranai evetui-tarito, ekirato, “Au natugu kekenina inivau moḡo bemase. Si-iaḡo, ḡimamu iatanai bono tore-kaua, benamo natugu bemaḡurini.” ");
INSERT INTO snc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu evaisi-raḡeto, ḡia ḡesi ḡeiaḡoto. Ḡena mero maki ḡia ḡesi ḡeiaḡo-sebonato. ");
INSERT INTO snc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ḡeiaḡoto-ḡoi nuḡanai, vavine ta, ḡena keve tu rara kevena, laḡani gabanana ruarua (12) ekeve-iaḡiato, eiaḡomato Iesu murina rekena na, ma ḡena dabuḡa dudunai eveḡabikauto. ");
INSERT INTO snc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Korana tu ḡia evetuḡamaḡito, “Ḡena dabuḡai moḡo baveḡabikauni nai, banamoni.” ");
INSERT INTO snc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu eruḡa-kureto, eḡitaiato, ekirato, “Natugu, bono kokore! Ḡemu veḡabidadama na bevaḡa-namomu.” Benamo vaḡa-sebo ḡena keve enamo-ḡosito. ");
INSERT INTO snc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu tu mo vere ḡena numai eraka-toḡato. Ivirikou furufuru tarimari e taḡitaḡi tarimari ma gururi baregori ḡesi eḡitarito, ");
INSERT INTO snc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","benamo Iesu na evaḡa-guruḡarito, ekirato, “Ḡoraka-rosi. Kekeni tu asi bemase, ḡia tu egenani moḡo.” Senaḡi tarimarima na ḡerikiriki-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iesu na mo tarimarima ḡutuma etuḡu-rosirito murinai, ḡia eraka-toḡato numa nuḡanai, kekeni ḡimanai eḡabito; benamo mo kekeni evaisi-raḡeto. ");
INSERT INTO snc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mai veiḡa varina tu mo tano mabaranai ḡevarifiu-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu na mo gabu ma eraga-kwaneato. Erakato-ḡoi nai, mata-bubu tarimari ruarua murina na ḡeiaḡoto, ḡekea-viniato, ḡekirato, “Davida Natuna o, ḡai novetuḡama!” ");
INSERT INTO snc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu numai eraka-toḡato nai, mo mata-bubu tauri ruarua maki ḡeraḡe-kauto. Benamo Iesu na edanaḡirito, ekirato, “Ḡomi na ḡovaḡa-moḡoniguni, au na bavaḡa-namomini riba?” Ḡia ḡevaḡa-veseto, ḡekirato, “Vereḡauka, oi, ḡavaḡa-moḡonimuni.” ");
INSERT INTO snc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Benamo Iesu na matari eḡabi-kararito, ekirato, “Ḡemi veḡabidadama lorinai, veiḡana tu bana veia ḡemi.” ");
INSERT INTO snc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Benamo matari ḡefafato. Iesu na ma nuḡana mabarana ḡesi evaḡa-guruḡa gwaḡiḡi-rito, ekirato, “Mai veiḡa beḡora maiḡa varina tarima ta asi boḡono kira-varaia!” ");
INSERT INTO snc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Senaḡina tauri ruarua ḡeraka-rosito, ḡeiaḡoto, Iesu varina mo tano mabaranai ḡea varifiu-rovorovoato. ");
INSERT INTO snc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tauri ruarua numa na ḡeraka-rosito-ḡoi nuḡanai, tarima ta, iauka rakavana na eboroḡiato nai asi eguruḡato-ḡoi, Iesu ḡenai ḡeḡabi-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu na iauka rakavana elai-vaḡiato murinai, mo muru-bubu tarimana varau eguruḡato. Tarimarima mabarari na mai eḡorato veiḡana ḡeḡaba-iaḡiato, ḡekirato, “Maiḡesina veiḡana ta Isaraela nuḡanai roḡosi bene ḡora!” ");
INSERT INTO snc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A Farisea tarimari ḡekirato, “Mai tu iauka rakavari ḡeri vere ḡena seḡukana na iauka rakavari ḡia na elai-vaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu na vanuḡa baregori ema keiri mabarari eiaḡo-vinirito: Ḡeri rubu ai evevaḡa-ribato-ḡoi, Barau ḡena Basileia varina namona eḡobata-iaḡiato-ḡoi, ema keve e midigu-midigu tarimari mabarari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesu na mo tarimarima ḡutuma-bara eḡitarito nai evetuḡarito, korana ḡenuḡa-vekwaraḡito e asi ḡeri veduru ḡabi tarimari, vaḡa-ilailana mamoe asi ḡitaḡauri tarimana ta kavana. ");
INSERT INTO snc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Benamo Iesu na ḡena mero ekirarito, ekirato, “Makora ḡitaḡitana tu barego, senaḡina ḡauvei-iaḡina tarimari tu asi ḡutuma. ");
INSERT INTO snc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Vamoka ḡaniḡanina vinivinina Vereḡaukana boḡono noḡia, be ḡauvei tarimari bene tuḡuri, ḡena ḡaniḡani gogo vamokari ḡana.” ");
INSERT INTO snc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu na ḡena mero gabanana ruarua (12) ekearito, benamo seḡuka evinirito, iauka rakavari beḡene lai-vaḡiri, e keve ema midigu-midigu mabarari beḡene vaḡa-namori ḡana. ");
INSERT INTO snc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mai apostolo tarimari gabanana ruarua (12) arari tu maiḡeri: Giniguinena tu Simona, arana ta tu Petero, e ḡia tarina Anduru; Iakobo (o Iames), Sebedaio natuna, ma tarina Ioane ḡesi; ");
INSERT INTO snc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo e Batolomeo; Tomasi e takesi gogo tarimana Mataio; Iakobo (o Iames), Alfeo natuna, e Tadeo; ");
INSERT INTO snc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona, Selote tarimana, ema Iudas Isakariota, Iesu berevaiani tarimana. ");
INSERT INTO snc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mai tarima gabanana ruarua (12) Iesu na etuḡu-rosirito ema velaunaḡi sisibari maiḡesina evinirito, ekirato, “Irau bese tarimari ḡeri ai asi boḡono iaḡo, e Samaria vanuḡari tai maki asi boḡono raka-toḡa; ");
INSERT INTO snc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","senaḡina Isaraela besena ḡeri ai boḡono iaḡo, ḡia tu ḡerekwa-rekwato mamoeri kavana. ");
INSERT INTO snc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ḡoiaḡo, ma maiḡesi boḡono ḡobata, boḡono kira, ‘Guba Basileiana tu bevotu, (Barau ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa)!’ ");
INSERT INTO snc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Keve tarimari boḡono vaḡa-namori, mase tarimari boḡono vaḡa-maḡuriri, lepera tarimari boḡono iarevari boḡono vaḡa-namori, e iauka rakavari boḡono lai-vaḡiri! Ḡomi na ḡoḡabiato asi voina, boḡono vini maki asi voina. ");
INSERT INTO snc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ḡemi iaḡoiaḡo ai moni asi boḡono ḡabikau, golo o silva moniri o kopa moniri maki asi boḡono ḡwakau. ");
INSERT INTO snc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dura asi boḡono ḡabikau, sedi ruarua, tamaka, ema togoi maki asi boḡono ḡabi. Korana ḡauvei tarimana ḡena-ḡana tu beḡene vinia veḡata. ");
INSERT INTO snc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vanuḡa baregona tai o vanuḡa keina tai boḡo raka-toḡani nai, deikara eurani ḡena numai bene ḡabi-raḡemi etoni tarimana boḡono vetaua. Mo numai moḡo boḡono tanu, bene iaḡo mo, vanuḡa ma boḡono raga-kwanea. ");
INSERT INTO snc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Numai ḡoraka-toḡani nai, numa tarimari boḡono vaḡa-namori, boḡono kira, ‘Maino ḡomi ḡemi ai bene tanu!’ ");
INSERT INTO snc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bema mo numa tarimari na beḡe ḡabi-raḡemini nai, Barau ḡena maino ḡeri ai betanuni. Senaḡina bema ḡia na asi beḡe ḡabi-raḡemini nai, Barau ḡena maino ḡeri ai asi betanuni, ḡemi ai ma beḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kamara numai o vanuḡai tarimarima na asi beḡe ḡabi-raḡemini e ḡemi guruḡa asi beḡe seḡaḡirini nai, mo numa o vanuḡa boḡono iaḡuia, kwakumi kauri boḡono kwari-ketoketori, (ḡia ḡeri kira-sirivaḡi vaḡa-moḡoniri ḡana). ");
INSERT INTO snc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Au na akira-korikorimini, Barau ḡena Kota ḡaronai mo numa o vanuḡa ḡeri rakava voina metona tu barego lelevaḡi beḡabiani, Sodoma e Gomora ḡeri rakava voina maki bevanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ḡoseḡaḡi, au na mai atuḡumini mamoe kavana boḡa kwaivari rakavari vefakari ai. Moḡa lorinai, mota kavana boḡono iaunega ema boḡono manau pune kavana. ");
INSERT INTO snc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lorimi boḡono vetore tarimarima ḡeri ai! Korana ḡia na beḡe ḡabimini ma beḡe tuḡu-iaḡomini Iuda ḡeri kanisoro tarimari ḡeri ai, ema ḡeri rubu nuḡari ai beḡe kwarimini. ");
INSERT INTO snc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Au ḡoḡabi-raḡeguni dainai, gavana e vere barari o kini ḡeri ai roḡo beḡe ḡabi-iaḡomini, ḡia ḡoirari ai au vaḡa-moḡonigu ai boḡono iaḡo, korana irau bese tarimari maki Vari Namona beḡene ribaia. ");
INSERT INTO snc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bema Kota tarimari ḡoirari ḡana beḡe ḡabi-iaḡomini nai, kara toma boḡoa kiraḡirini o kamasi boḡo kiraḡirini guruḡari asi boḡono nuḡa-vekwaraḡi-iaḡiri. Korana mo ḡaro ai kara boḡo kiraḡirini guruḡari tu, Barau na vau bevinimini. ");
INSERT INTO snc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Dia ḡomi boḡo guruḡani, senaḡina Barau Iaukana ḡomi ḡemina beguruḡani. ");
INSERT INTO snc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kakana na tarina berevaiani bene mase ḡana, tamana na natuna maki moḡesina beveiani. Naturi na tamari sinari beḡe seḡafore-vinirini ema mase ai maki beḡe torerini. ");
INSERT INTO snc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tarimarima mabarari na beḡe iau-rakavamini, korana au ḡoḡabi-raḡeguni nai. Senaḡina deikara bevevaḡa-gwaḡiḡini mo dokona tu bemaḡurini. ");
INSERT INTO snc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vanuḡa tai beḡe vaḡa-rakavamini e beḡe laimini nai, vanuḡa ta ḡana ma boḡono raga-iaḡo. Boḡono riba-maoro, ḡegu ḡauvei asi roḡo boḡo vaḡa-koriani Isaraela vanuḡari mabarari nuḡari ai, beiaḡoni mo, Tarimarima Natuna bema-raḡasini. ");
INSERT INTO snc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Riba evetauani merona na ḡena vevaḡa-riba tarimana asi bevanaḡiani; vetuḡunaḡi tarimana na guine-iaḡina tarimana maki asi bevanaḡiani riba. ");
INSERT INTO snc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Riba evetauani merona bevevaḡa-iaḡoni ḡena vevaḡa-riba tarimana ḡesi beḡe ilailani, ema vetuḡunaḡi tarimana guine-iaḡina tarimana ḡesi maki beḡe ilailani tu namo. Boḡono tuḡamaḡia, tarimarima kotari na au tu doḡoro debana, Belsebul o Satani ḡetoni, be ḡomi, ḡegu doḡoro tarimami, maki moḡesi beḡe kiramini, ema beḡe vaḡa-metomini maki.” ");
INSERT INTO snc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Moḡa lorinai, tarimarima gariri asi boḡono vei. Vekouḡau dagarari mabarari beḡea foforini, vekuretoḡa guruḡari mabarari beḡea ribani. ");
INSERT INTO snc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Au na kara dagara akira-varamini mukunai tu, ma boḡono kiraḡi-ḡenoḡoiri laḡani matabarai, kara dagara ḡereḡami na boḡo seḡaḡia tu, numa tuḡuri na ma boḡono kiraḡi-foforia, (tarimarima mabarari na beḡene seḡaḡia ḡana). ");
INSERT INTO snc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tauḡanina beḡe vaḡiani tarimari asi boḡono gari-viniri, korana ḡia na iauka asi beḡe vaḡiani. A Barau garina neḡi boḡono gari, korana ḡia na ruarua bevaḡirini riba, tauḡanina e iauka, karava asi ebuseni gabunai. ");
INSERT INTO snc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bisini ruarua maki fene sebona na moḡo ḡevoirini, ene? Senaḡina moḡeri ta maki asi beketo-riḡo kavani tano ai, bema Tamami asi beurani nai. ");
INSERT INTO snc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A ḡomi tu debami ḡuiri maki mabarari Barau na eiavi-ginikaurito. ");
INSERT INTO snc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Be asi boḡono gari; ḡomi voimi tu varaḡe lelevaḡi, bisini ḡutuma voiri maki ḡovanaḡirito.” ");
INSERT INTO snc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Deikara na au tarimarima ḡoirari ai bekiraḡi-foforiguni, ḡia maki au na bakiraḡi-foforiani Tamagu gubai etanuni ḡoiranai. ");
INSERT INTO snc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Senaḡina au deikara na tarimarima ḡoirari ai beruḡaguni e bekira-ḡuniḡauguni, ḡia maki au na baruḡaiani e bakira-ḡuniḡauani Tamagu gubai etanuni ḡoiranai.” ");
INSERT INTO snc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Asi boḡono tuḡamaḡi, au tu maino tanobara ḡana aḡwa-iaḡomaiato. Asiḡina, au tu dia maino aḡwa-iaḡomaiato, senaḡi vetari urana na aiaḡomato. ");
INSERT INTO snc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au aiaḡomato tu, maiḡeri nama vaḡa-ruḡari ḡana: Natu tauri na tamari beḡe vevaḡi-vinirini, natu vavineri na sinari beḡe vevaḡi-vinirini, taḡama vavine keiri na ḡeri taḡama vavine barari beḡe vevaḡi-vinirini. ");
INSERT INTO snc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Numa biaguna tu tauḡena ḡena numa tarimari na moḡo beḡe iau-rakava viniani. ");
INSERT INTO snc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Deikara tamana o sinana beuravini-baregoani, a au tu betuḡamaḡi-keiguni nai, ḡia tu asi ilaila au ḡegu tarimai beḡe kiraḡiani. Ema deikara na natuna merona o kekenina beuravini-baregoani, a au beuravini-keiguni nai, ḡia tu asi ilaila au ḡegu tarimai beḡe kiraḡiani. ");
INSERT INTO snc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","E deikara tauḡena ḡena satauro asi beḡwaiani, ema murigu na asi berakani, ḡia tu asi ilaila au ḡegu tarimai beḡe kiraḡiani. ");
INSERT INTO snc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Deikara ḡena maḡuri moḡo lorina etoreani tarimana, ḡena maḡuri befitoḡaiani. A deikara au daigu ai ḡena maḡuri befitoḡaiani tarimana, ḡena maḡuri asi bevei-rekwarekwaiani.” ");
INSERT INTO snc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Dei na ḡomi eḡabi-raḡemini, au maki eḡabi-raḡeguni, ema au eḡabi-raḡeguni tarimana na au etuḡuguto Barauna maki eḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dei na peroveta tarimana ta eḡabi-raḡeani, korana ḡia tu Barau ḡena guruḡa vaḡa-foforina tauna ta, ḡia na peroveta tauna davana tu beḡabiani. Ema dei na veiḡa iobukaiobuka tarimana eḡabi-raḡeani, korana ḡia tu Barau ḡena ura ekorana-iaḡiani tauna, ḡia na vei-iobukaiobuka tarimana davana beḡabiani. ");
INSERT INTO snc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E tarima ta na mai ḡegu mero ta nanu faraka kapusi sebona ta beviniani, korana ḡia tu au ḡegu vetuḡunaḡi tarimana, akira-korikori-mini, ḡia voina tu beḡabiani veḡata.” ");
INSERT INTO snc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu na moḡeri sisiba guruḡari ḡena mero gabanana ruarua (12) ḡeri ekiraḡi-ḡosirito murinai, ḡia monana Galilea vanuḡari ḡana eiaḡoto, monai Barau ḡena guruḡa bene vevaḡa-riba iaḡia e bene ḡobata-iaḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioane Babatiso dibura numanai etanuto-ḡoi nai, Keriso ḡena ḡauvei veiḡari varina eseḡaḡiato, benamo ḡia na ḡena mero Iesu ḡenai etuḡu-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iesu ḡedanaḡiato, ḡekirato, “Barau na ekiraḡi-toreato beiaḡomani tarimana tu ḡoi, ba tarima boruna ta baḡana vaḡa-nogaia?” ");
INSERT INTO snc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Benamo Iesu na evaḡa-veserito, ekirato, “Ḡoḡenoḡoi, ḡomi na boḡo seḡaḡiri e boḡo ḡitari veiḡari Ioane boḡono kira-varaia: ");
INSERT INTO snc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mata-bubu tarimari ḡeboḡeboḡeni, kwaku rakava tarimari ḡerakani, lepera tarimari ḡenamoni, seḡa-bubu tarimari ḡeseḡaḡini, mase tarimari ḡevariḡisi-ḡenoḡoini, ema Vari Namona gara veḡubu e asi ḡeri-ḡari tarimari ḡeri eḡobata-iaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Au ḡegu ai asi ḡena daradara tarimana tu eiakuni.” ");
INSERT INTO snc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioane ḡena mero ḡerakato vau, Iesu na ḡevegogoto tarimari evaḡa-guruḡarito, Ioane varina ḡeri ekiraḡi-ato, ekirato, “Ioane ḡenai ḡoiaḡoto nai, mo tano fakanai tu kara boḡono ḡitaia ḡana? Gobu iavara na ekwari-ḡareva ḡarevaiani ḡitaḡitana ḡoiaḡoto? ");
INSERT INTO snc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bema asiḡina nai, kara boḡono ḡitaia ḡana ḡoiaḡoto? Dabuḡa namona eveiani tarimana ḡitaḡitana ḡoiaḡoto? Asiḡina. Dabuḡa namori ḡeveirini tarimari tu kini ḡeri numai ḡetanuni. ");
INSERT INTO snc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Be, kara boḡono ḡitaia ḡana ḡoiaḡoto? Peroveta tarimana dainai? Aba! Akiramini, ḡoḡitaiato tarimana tu peroveta tarimari mabarari evanaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ioane varina Buka Veaḡai maiḡesi etoreato, Barau ekirato, ‘Au na ḡegu vetuḡunaḡi tarimana tu batuḡu-guineani, ḡemu dabara ḡoiramu ai vaḡa-maḡatana.’ ");
INSERT INTO snc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Moḡoni akiramini, mai tanobarai beḡe maḡuri tarimari mabarari fakari ai Ioane Babatiso tu barego vedaurea, ta na asi bevanaḡiani. Senaḡina Guba Basileiana nuḡanai gabi tarimana na Ioane tu evanaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ioane Babatiso ḡena ḡobata evari-fiurito-ḡoi ḡenana beiaḡoma mo initoma, Barau na ḡena Basileia o veḡitaḡau seḡukana evaḡa-ruḡaiani, senaḡina tarima tari na ḡevevaḡi-viniani, ḡeri ura tu tauḡeri beḡene veḡitaḡau, a deikara Barau ḡena Basileiai neraka-toḡa etoni tarimana, ḡia na ḡekouani. (Mataio23:13). ");
INSERT INTO snc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Peroveta tarimari mabarari e Mose ḡena taravatu maki na Barau ḡena Basileia o veḡitaḡau ḡeḡobata-iaḡiato-ḡoi, eiaḡomato mo, Ioane ḡena negai. ");
INSERT INTO snc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ema ḡomi na ḡeri guruḡa boḡo ḡabi-raḡeani ba asiḡina, senaḡina Ioane tu moḡoni peroveta tarimana Elia, ḡena iaḡoma tu ḡekiraḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ma seḡana tarimana bene seḡaḡi. ");
INSERT INTO snc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Toma ḡuru tarimari tu deikara ḡesi bavaḡa-ilailarini? Ḡia tu noḡa mero keiri kavana, vanuḡa ḡatamanai ḡetanu-taḡoni, ḡeḡereni, tavi ta merori na tavi tai ḡekea-vinirini, ḡekirani, ");
INSERT INTO snc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ḡai tu veḡaraḡo vererenai gita ḡalauto-ḡoi ḡomi ḡemi, senaḡi ḡomi tu asi ḡobarato-ḡoi! Ḡai tu mase mariri ḡaḡabito-ḡoi, senaḡi ḡomi tu asi ḡotaḡito-ḡoi!’ ");
INSERT INTO snc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioane eiaḡomato, eḡani-veaḡato ema vine nanuna asi eniuato. Benamo ḡekirani, ‘Ḡia tu iauka rakavana na eboroḡiato,’ ḡetoni. ");
INSERT INTO snc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Tarimarima Natuna eiaḡomato, ḡia tu ḡaniḡani ta asi eruḡaiani. Benamo ḡekirani, ‘Ḡia tu boḡeka tarimana ema vine nanuna eniu-ḡutumani tarimana, takesi gogo tarimari e vei-rakava tarimari ḡatari!’ ḡetoni. Senaḡi Barau ḡena iaunega vaḡa-foforina e vaḡa-moḡonina tu ḡena vetoḡa namori ḡerina.” ");
INSERT INTO snc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu na ḡena seḡuka ḡauveiri vanuḡa baregori tari nuḡari ai eveirito, senaḡi ḡeri rakava ḡerina asi ḡevetuḡamaḡi-kureto-ḡoi, naima Iesu na moḡeri vanuḡa tarimari evanerito. ");
INSERT INTO snc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ekirato, “Korasini o, ḡoi ema Betesaida, vetuḡami kika! Korana nuḡa-farevaḡi veiḡa boruri ḡemi ai ḡefoforito-ḡoi tu, Taia e Sidono nuḡari ai beḡere fofori, benamo ḡia tu irau laḡani ai ḡere vetuḡamaḡi-kure, fuse rakavari ai e tauḡaniri ma gurumari ai ḡeri vetuḡamaḡi-kure ḡere vaḡa-foforia. ");
INSERT INTO snc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Senaḡina akiramini, Barau na tarimarima bekota-vinirini ḡaronai, ḡomi na boḡo doḡariani metona tu Taia e Sidono ḡeri meto bevanaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ḡoi maki, Kapera-nauma o, ḡoi ourani guba ḡana bono varaḡe otoni? Asiḡina, ḡoi tu mase gabuna ḡana boiaḡoni! Bema nuḡa-farevaḡi veiḡa boruri ḡemi ai ḡefoforito-ḡoi tu Sodoma nuḡanai beḡere fofori nai, ḡia tu roḡo bere tanu mo initoma. ");
INSERT INTO snc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Senaḡina akira-mini, Barau na tarimarima bekota-vinirini ḡaronai, ḡomi na boḡo doḡariani metona tu Sodoma ḡeri meto bevanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mo negai Iesu ekirato, “Tamagu o, guba ema tanobara Verena, avaḡa-namomuni, korana ḡoi na ma iaunegari e riba tarimari ḡeri ai okure-toḡarini dagarari tu, asi ḡeri riba tarimari ḡeri ai ovaḡa-foforirini. ");
INSERT INTO snc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aba, Tamagu, ḡemu ura tu maiḡesina bene vetore veḡata. ");
INSERT INTO snc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dagara mabarari Tamagu na eviniguto. Natuna tarima ta asi ribana, senaḡina Tamana ḡereḡana moḡo ribana, ema Tamana tarima ta asi ribana, senaḡi Natuna ḡereḡana moḡo ribana, ema Natuna na bene vaḡa-fofori vinia etoni tarimana. ");
INSERT INTO snc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Au ḡegu ai ḡoiaḡoma, ḡomi deikara maruna metori ḡoḡwani e boḡo gau tarimami mabarami, au na iaḡaraḡi banama vinimi. ");
INSERT INTO snc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Au ḡegu maruna, mai tu ḡegu veḡitaḡau namona, ḡoma ḡabi-raḡea, ma au ḡegu ai riba maki ḡoma ḡabia! Korana au na asi badori-naḡinaḡimini e asi baḡita-fitoḡamini. Au ḡegu ai iaḡaraḡi korikorina boḡo doḡariani. ");
INSERT INTO snc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Auna maruna tu meraḡa e ḡegu ḡwaḡwa iatami ai batore-kauani maki asi metona.” ");
INSERT INTO snc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mo negai Iesu tu Sabadi ai widi vamokari na eraka-vanaḡito. Ḡena mero ḡevitorito nai, widi ḡwaḡwari ḡebukito-ḡoi e ḡeḡanirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisea tarimari na ḡeḡitarito, benamo Iesu ḡekiraiato, ḡekirato, “Noḡitaia, ḡemu mero na ḡita ḡera taravatu asi ḡekorana-iaḡiani, Sabadi ai widi ḡebukini.” ");
INSERT INTO snc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu na evaḡa-veserito, ekirato, “Davida na veiḡa ta eveiato, ḡia ma karona ḡesi ḡevitorito nai, ḡomi na mai veiḡa eḡorato tu roḡosi roḡo boḡono iavia? ");
INSERT INTO snc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Barau ḡena numai eraka-toḡato, Barau ḡoiranai ḡetorerito-ḡoi beredi ḡia ma karona ḡesi ḡeḡanito. Mo beredi tu veaḡa, Rubu Veaḡa vereri moḡo ḡari, taravatu. ");
INSERT INTO snc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ema ḡomi na Mose ḡena taravatu nuḡanai mai guruḡa maki roḡosi roḡo boḡono iavia, ekirani, Sabadi ai Rubu Veaḡa vereri tu Rubu Veaḡai ḡeḡauveini. Moḡesina nai Sabadi taravatuna ḡevaḡa-rakavaiani, senaḡi ḡia tu asi ḡeri kerere? ");
INSERT INTO snc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Au na akiramini, mainai tarima ta, ḡia na Rubu Veaḡa evanaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buka Veaḡa ekirani, ‘Vevetuḡaḡwa neḡi aurani, a varevare dagarana tu asiḡi.’ Bema mai guruḡa anina ḡoro riba nai, asi ḡeri kerere tarimari ḡomi na asi ḡoro vaḡa-bade-iaḡiri. ");
INSERT INTO snc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Korana Tarimarima Natuna tu Sabadi Verena.” ");
INSERT INTO snc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu na mo gabu eiaḡuiato, ma eiaḡoto, Iuda tarimari ḡeri rubu ai eraka-toḡato, ");
INSERT INTO snc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ḡimana ebosoto tarimana ta maki monai. Benamo Farisea tarimari na Iesu beḡene ḡofaḡofa-iaḡia ḡana ḡedanaḡiato, ḡekirato, “Sabadi ai keve bita vaḡa-namorini tu ma taravatuna ba?” ");
INSERT INTO snc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Benamo Iesu na evaḡa-veserito, ekirato, “Ḡomi ta ḡena mamoe sebona kwariḡutu moḡo, Sabadi ai guri tai beketo-riḡoni nai, vaḡa-maḡurina ḡana ḡomi na asi boḡo inu-raḡeani? ");
INSERT INTO snc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Boḡono tuḡamaḡi: Tarimarima tuḡamaḡi-iaḡina tu barego vedaurea, a mamoe ḡenai tu kei! Moḡa lorinai Sabadi ai veiḡa namona veiveina tu maoro vedaurea.” ");
INSERT INTO snc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Benamo Iesu na mo ḡima boso tarimana ekiraiato, ekirato, “Ḡimamu noduḡi-roroḡotoa.” Ḡia ḡimana eduḡi-roroḡotoato, benamo mabarana enamo-ḡosito, ḡimana reke ta kavana. ");
INSERT INTO snc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Senaḡi Farisea tarimari ḡeraka-rosito, benamo ḡea boioḡa-vegogoto, kamasi Iesu beḡene vaḡi-masea dabarana ḡea vetauato. ");
INSERT INTO snc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Farisea ḡeri boioḡa Iesu na varau eriba-guineato nai, ḡia mo gabu na eraka-veḡitato. Tarimarima ḡutuma ḡia murina na ma ḡeiaḡoto, ema keve tarimari mabarari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Senaḡi eguruḡa gwaḡiḡi-vinirito, ḡia varina tarima ta maki asi beḡene vaḡa-ribaia. ");
INSERT INTO snc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Maiḡesi eguruḡato, korana Isaia peroveta tarimana muruna na eraka-rosito guruḡana bene moḡoni ḡana, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mai tu au ḡegu vetuḡunaḡi tarimana, aviriḡiato. Au na ḡia aura-viniani, e ḡia ḡenai maki aiakuni; Au Iaukagu ḡia ḡenai batoreani, e ḡia na au ḡegu guruḡa e veiḡa iobuka-iobukari beḡobata-iaḡirini bese mabarari ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ḡia asi bevanevaneni, ma asi befararani; ema ḡatamai garona maki ta na asi beseḡaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ḡia na gobulefa moirana asi betau-koruani, ema irau mo emoreni lamefana maki asi bevei-buseani, beiaḡoni mo, ḡia na guruḡa e veiḡa iobukaiobukari bea vaḡa-ruḡarini, benamo beḡe kokoreni. ");
INSERT INTO snc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ḡia ḡenai tarimarima mabarari ḡeri vetuḡamaḡikau beḡe toreani.” ");
INSERT INTO snc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Benamo kotari na iauka rakavana na eboroḡiato tarimana Iesu ḡenai ḡeḡabi-iaḡoato. Mo tarima tu matana bubu e muruna bubu. Iesu na evaḡa-namoato, benamo ma eguruḡato e eboḡeboḡeto. ");
INSERT INTO snc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tarimarima mabarari na mai veiḡa eḡorato ḡeḡaba-iaḡiato, ḡekirato, “Mai tu betaḡu Davida Natuna banaḡu, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna)?” ");
INSERT INTO snc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Senaḡi Farisea tarimari na maiḡa ḡeseḡaḡiato nai, ḡekirato, “Mai tu Belsebul, iauka rakavari ḡeri vere, na seḡuka eviniani nai, mai tarima na iauka rakavari elai-vaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu na ḡeri tuḡamaḡi varau eribarito nai, ekirarito, ekirato, “Gavamani bevetavini, tauḡena bevevaḡi-vinini nai, ḡia tu berakavani; e vanuḡa ta o doḡoro ta bevetavini, tauḡena bevevaḡi-vinini nai, asi beruḡani riba. ");
INSERT INTO snc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","E diabolo ta na diabolo ta belai-vaḡiani nai, Satani tu tauḡena bevevaḡini, moḡa anina tu, doḡoro tatai varau bevetavi nai, asi beruḡani riba? ");
INSERT INTO snc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ḡomi ḡokirani, au tu Belsebul ḡena seḡuka na iauka rakavari alai-vaḡirini, a ḡomi murimi ai ḡerakani tarimari na iauka rakavari aiḡesi ḡelai-vaḡirini? Ḡia na ḡevaḡa-moḡoniani, ḡomi ḡemi guruḡa tu kerere. ");
INSERT INTO snc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Asiḡina, dia Belsebul, senaḡina Barau Iaukana ḡena seḡukai alai-vaḡirini, naima boḡono riba, Barau ḡena Basileia tu ḡomi ḡemi ai varau beraḡasi. ");
INSERT INTO snc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tarima ta gwada tarimana ḡena numa asi bedareani riba, ma ḡena farefare beḡwa-rakarini, senaḡi ḡia na gwada tarimana varo na bebarubaruani, monai vau ḡia na ḡena numa farefareri beḡabi-rakarini. ");
INSERT INTO snc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Deikara na au asi evaḡa-kavaguni, ḡia na tu au eruḡaguni, e deikara au ḡesi asi etore-vegogoni, tarimana tu eveiari-lausilausini. ");
INSERT INTO snc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Moḡa lorinai akiramini, tarimarima rakava beḡe veini ema Barau beḡe kira-rakava viniani tarimari, ḡeri rakava mabarari Barau na betuḡamaḡi-fitoḡarini riba, senaḡi tarima ta na Iauka Veaḡa bekira-rakava viniani tarimana, ḡena rakava asi betuḡamaḡi-fitoḡaiani. ");
INSERT INTO snc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tarima ta na Tarimarima Natuna bekira-rakava viniani nai, ḡena rakava tu betuḡamaḡi-fitoḡaiani, senaḡi tarima ta na Iauka Veaḡa bekira-rakava viniani tarimana, ḡena rakava asi betuḡamaḡi-fitoḡaiani, toma mai maḡuri ai ema maḡuri gabinai maki asi betuḡamaḡi-fitoḡaiani.” ");
INSERT INTO snc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Bema ḡau namo nai tu, ḡwaḡwana maki namo, a bema ḡau rakava nai, ḡwaḡwana maki rakava. Ḡau tu ḡwaḡwana ḡenana boribaiani. ");
INSERT INTO snc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ḡomi mota naturi, ma rakavami ḡesi ḡotanuni, be guruḡa namona ta tu kamasi boḡo kiraḡiani? Korana tarima tu nuḡana na kara eiaḡomani, murunai ekiraḡirini. ");
INSERT INTO snc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tarima namona na dagara namori nuḡanai evaḡa-vegogorini dagarari bevaḡa-raka-rosirini. Tarima rakavana na dagara asi namori nuḡanai evaḡa-vegogorini dagarari bevaḡa-raka-rosirini. ");
INSERT INTO snc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Senaḡi au na akiramini, guruḡa taḡuitaḡui mabarari, tarimarima na beḡe kiraḡirini tu, Barau ḡena Kota baregona ḡaronai voiri beḡe ḡabirini. ");
INSERT INTO snc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ḡemu guruḡa ḡenana Barau na vei-iobukaiobuka tarimamu bekiraḡi-muni, o vei-rakava tarimamu bekiraḡimuni.” ");
INSERT INTO snc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Taravatu vaḡa-riba-iaḡina tarimari e Farisea tarimari kotari na Iesu ḡevaḡa-guruḡaiato, ḡekirato, “Vevaḡa-riba tarimamu, ḡai ḡaurani vetoḡa boruna ta ḡoi ḡemuna baḡana ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu na evaḡa-veserito, ekirato, “Toma ḡuru rakavana ma veḡura-vanaḡina ḡesi, (Barau ḡenana ḡeveḡitato ḡuruna), seḡuka vetoḡana ta ḡeḡita-vetauani, senaḡi vetoḡa ta asi beḡe doḡariani, Iona, peroveta tarimana, vetoḡana moḡo. ");
INSERT INTO snc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iona tu ḡaro toitoi ema boḡi toitoi maḡani-kone barana, rakana donodono diana nuḡanai etanuto, moḡesina kavana Tarimarima Natuna maki ḡaro toitoi ema boḡi toitoi tano nuḡanai betanuni. ");
INSERT INTO snc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kota baregona ḡaronai Nineva tarimari beḡe ruḡa-vaisini, toma ḡuru tarimari beḡe samanirini, korana Iona ḡena ḡobata ḡeseḡaḡiato neganai, ḡia ḡeri rakava ḡerina ḡevetuḡamaḡi-kureto, ema ḡeraka-kureto Barau ḡenai. Senaḡi ḡoḡitaia, tarima ta na Iona evanaḡiani tu maiḡa. ");
INSERT INTO snc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kota baregona ḡaronai maki, Seba vavine baregona o Kwin beruḡa-vaisini, mai ḡuru tarimari besamanirini, korana ḡia tu ḡena tanobara manaḡana na eiaḡomato, Solomona ḡena iaunega guruḡari bene seḡaḡiri ḡana. Senaḡi ḡoḡitaia, tarima ta na Solomona evanaḡiani tu maiḡa.” ");
INSERT INTO snc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Iauka rakavana ta tarima ta ḡenana eraka-vaḡito, benamo gabu kaukauri na eraka-vanaḡito, iaḡana bene ḡania etato, senaḡi iaḡaraḡi gabuna ta asi edoḡariato. ");
INSERT INTO snc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Benamo ḡia tauḡena ekirato, ‘Naḡenoḡoi, araga-kwaneato numana ḡana.’ Eḡenoḡoi-iaḡoto, numa edoḡariato. Numana tu korina, veiareva ema ḡitaḡitana namo vedaurea. ");
INSERT INTO snc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Benamo ḡia na iauka rakava kwaikwairi imaima ruarua (7) ma eḡori-iaḡorito, mabarari ḡeraka-toḡato, monai ḡetanuto. Moḡa lorinai mo tarima tu guinenai ḡena rakava tu kota misina, senaḡi dokonai ḡena rakava tu barego vedaurea. Maiḡesina toma ḡuru rakavana ḡenai beḡorani.” ");
INSERT INTO snc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu tu tarimarima roḡo evaḡa-guruḡarito-ḡoi nai, ḡia sinana e tarina doḡoro ḡeraḡasito. Numa murikanai ḡeruḡa-tarito, ḡeri ura tu Iesu beḡene vaḡa-guruḡaia. ");
INSERT INTO snc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Benamo tarima ta na ekiraiato, ekirato, “Ḡoi sinamu e tarimu merori tu numa murikanai ḡeruḡa-taḡoni, ḡevaḡa-guruḡamu ḡetoni.” ");
INSERT INTO snc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu na evaḡa-veserito, ekirato, “Au sinagu tu dei, e au tarigu merori tu deikarari?” ");
INSERT INTO snc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Benamo ḡia ḡimana na ḡena mero eduḡi-vinirito, ekirato, “Au sinagu e au tarigu merori tu maiḡeri! ");
INSERT INTO snc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Deikara na au Tamagu gubai etanuni ḡena ura veiḡari eveirini tarimana tu, au tarigu tauna, e au tarigu vavinena, ema au sinagu.” ");
INSERT INTO snc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mo ḡaro sebonai moḡo Iesu na numa eraga-kwaneato, eiaḡoto, Galilea kouna rikinai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tarimarima ḡutuma-bara na ḡevegogo-ḡeḡeraḡiato nai, ḡia tu ḡasi tai eraḡekauto, benamo etanu-tarito, a tarima mabarari tu fenu ai ḡeruḡato. ");
INSERT INTO snc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iesu na dagara ḡutuma barabore ai evaḡa-ribarito. Ekirato, “Iaraḡa tauna ta ḡena widi ḡueri varovarori eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ḡia na widi ḡueri efiu-lausilausirito-ḡoi nai, gabu irauirau ai ḡeketoto. Kotari dabarai ḡeketoto, benamo manu ḡeiaḡomato, ḡeḡani-ḡosirito. ");
INSERT INTO snc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kotari forefore gaburi ai ḡeketokauto tano maḡiḡiri ai. Asikauna ḡegarato, korana tano iatanai moḡo. ");
INSERT INTO snc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Senaḡi ḡaro eraḡekauto nai, etunurito, ema lamuri asi ḡevariḡo-ginikauto nai, asikauna ḡemaraito. ");
INSERT INTO snc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kotari tu ḡauḡa ḡiniḡiniri vefakari ai ḡeketoto. Mai ḡauḡa ḡiniḡiniri ḡetubu-baregoto nai, varovaro dagarari ḡetubu-ḡaurito. ");
INSERT INTO snc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A kotari tu tano namonai ḡeketoto, ḡwaḡwari ḡetaunato nai, kotari sinau ta (100), ma kotari gabana imaima ma gabanana (60), ema kotari tu gabana toitoi (30).” ");
INSERT INTO snc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iesu ḡena guruḡa dokonai ekirato, “Ma seḡana tarimana bene seḡaḡi!” ");
INSERT INTO snc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iesu ḡena mero ḡia ḡenai ḡe-iaḡoto, benamo ḡedanaḡiato, ḡekirato, “Kara dainai barabore ai tarimarima ovaḡa-guruḡarini?” ");
INSERT INTO snc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu na evaḡa-veserito, ekirato, “Guba Basileia ḡena riba vekuretoḡari ḡomi ḡemi ai tu fofori, senaḡi ḡia ḡeri ai tu asiḡina. ");
INSERT INTO snc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma ḡena seḡaḡi tarimana Barau na tuḡamaḡi-faka beviniani, barego vedaurea bene doḡari ḡana. Asi ḡena seḡaḡi tarimana, ḡena tuḡamaḡi-faka misina maki beḡabi-vaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Moḡesi naima au na barabore ai avaḡa-guruḡarini. Korana matari na ḡeboḡe-boḡeni, senaḡi asi ḡeḡita-maḡatani, seḡari na ḡeseḡaḡini, senaḡi asi ḡetuḡamaḡi-maoroni. ");
INSERT INTO snc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ḡia ḡeri ai Isaia ḡena peroveta guruḡana bema moḡoni, maiḡesi ekirato, ‘Ḡomi tu boḡo seḡaḡini, ma boḡo seḡaḡini, senaḡi asi boḡo riba-maoroni. Ḡomi tu boḡo ḡitani, ma boḡo ḡitani, senaḡi debami asi beḡe vekeoni. ");
INSERT INTO snc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Korana mai bese tarimari nuḡari tu gwaḡiḡi foroforo, seḡari maki bubu, matari maki ḡevekouto. Matari na beḡe ḡitani garina, seḡari na beḡe seḡaḡini, e nuḡari na beḡe riba-maoroni garina, ma au ḡegu ai beḡe vetuḡamaḡi-kureni ḡeri Barau, benamo bavaḡa-maḡuririni garina.’ ");
INSERT INTO snc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A ḡomi tu boḡono iaku, korana matami tu ḡeḡitani e seḡami tu ḡeseḡaḡini. ");
INSERT INTO snc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Au na akira-korikorimini: Peroveta tarimari vovoka ma Barau ḡena vei-iobukaiobuka tarimari ḡutuma kaiveḡata na ḡeri ura baregona tu, ḡomi na initoma kara ḡoḡitaiani beḡene ḡitaia, senaḡi asi ḡeḡitaiato, e ḡomi na kara ini ḡoseḡaḡiani beḡene seḡaḡia, senaḡi asi ḡeseḡaḡiato.” ");
INSERT INTO snc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ḡoseḡaḡi, widi fiu-rovorovona tarimana baraborena anina tu maiḡa: ");
INSERT INTO snc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tarima kotari na Barau ḡena Basileia varina ḡeseḡaḡiani, senaḡi asi ḡetuḡamaḡi-fakaiani. Benamo Satani eiaḡomani, ma mo kara ḡia nuḡari ai beḡe varo dagarari tu, ḡia na eḡabi-vaḡirini. Moḡeri tarima tu widi ḡuturi dabarai ḡeketoni kavana. ");
INSERT INTO snc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Widi ḡueri kotari forefore ai ḡeketoto, mai tu tarima kotari na Barau ḡena Vari Namona ma iakuri ḡesi ḡeseḡaḡiani e ḡeḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Senaḡina ḡia nuḡari ai asi erakatoḡa-ginikauni nai, asi etanu-maukani. Barau ḡena guruḡa dainai nega rakavari ḡeḡoitaḡoni e ḡevaḡa-midigu midigurini ḡarori ai, ḡia ḡenana ḡeraka-veḡitani. ");
INSERT INTO snc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Widi ḡueri kotari tu ḡauḡa ḡiniḡiniri vekaravari ai ḡeketoto, mainana ekiraḡiani tu, tarima kotari na Barau ḡena guruḡa ḡeseḡaḡiani, senaḡi tauḡeri ḡeri maḡuri e farefare ḡutumari ḡetuḡamaḡi-baregorini ḡerina, Barau ḡena guruḡa ḡevekouni, e ḡwaḡwana maki asi evetoreni. ");
INSERT INTO snc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A widi ḡueri kotari tu tano namonai ḡeketoto, mainana ekirarani tu, tarima kotari na Barau ḡena guruḡa ḡeseḡaḡiani, ma ḡeḡabi-raḡeani nuḡari mabarari ḡesi, ḡia ḡwaḡwari ḡevetoreni maki, kotari sinau ta (100), ma tari gabana imaima ma gabanana (60), ma kotari gabana toitoi (30).” ");
INSERT INTO snc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu na barabore ta ḡeri ma ekiraḡiato, ekirato: Guba Basileia tu tarima ta kavana, ḡue ḡuturi namori ḡena vamokai evarorito. ");
INSERT INTO snc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Benamo boḡi tai, tarimarima mabarari roḡo ḡegenato-ḡoi nai, ebaru-viniato-ḡoi tarimana eiaḡomato, ḡauḡa ḡuturi widi vekaravari ai efiurito, benamo erakato. ");
INSERT INTO snc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Widi ḡetubu-foforito, ḡegara-baregoto e ḡwaḡwari ḡeburito nai, ḡauḡa rakavari maki ḡia vefakari na ḡefoforito. ");
INSERT INTO snc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Benamo vamoka biaguna ḡena vetuḡunaḡi merori ḡia ḡenai ḡeiaḡomato, ḡekirato, ‘Vereḡauka, ḡoi ḡemu vamokai ḡue ḡuturi namori ovarorito, nene? Senaḡi mai ḡauḡa rakavari tu ainana beḡe iaḡoma?’ ");
INSERT INTO snc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ḡia na evaḡa-veserito, ekirato, ‘Ebaru-vinirani tarimana na mai veiḡa bema veia.’ Vetuḡunaḡi merori na ḡedanaḡiato, ḡekirato, ‘Bema ourani nai, ḡaiaḡo, be baḡana lauri ba?’ ");
INSERT INTO snc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ḡia evaḡa-veseto, ekirato, ‘Asiḡina, korana ḡomi na ḡauḡa boḡo laurini nai, widi maki lamuri ḡesi boḡo lau-sebonarini garina. ");
INSERT INTO snc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ḡia ruarua beḡene gara-sebona, ma beḡene tanu mo, widi ḡwaḡwana basibasina ḡarona bene raḡasi. Mo ḡaro ai au na basi-basina tarimari maiḡesina bakirarini, bakirani: Giniguine tu, ḡauḡa mabarari ḡovaḡa-vegogori, ḡobaru-sebonari, be karava na bene ḡarari, a widi ma boḡono vaḡa-vegogoa, be ḡegu ḡaniḡani vaḡa-vegogo gabunai boḡono toreri.’” ");
INSERT INTO snc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu na barabore ta ma ekira-vararito, ekirato, “Guba Basileia tu mastadi ḡauna ḡutuna kavana, tarima ta na eḡabiato, ḡena vamokai evaroato. ");
INSERT INTO snc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tanobarai varovaro dagarari ḡueri mabarari fakari ai ḡia ḡereḡana misina korokoro, senaḡi etubuni nai, varovaro dagarari mabarari fakari ai ḡia moḡo barego vedaurea. Ḡia tu ḡau ai eiaḡoni naima, rovo manuri ḡeiaḡomani, ma ḡeri nuḡi ḡeveini ḡia leganai.” ");
INSERT INTO snc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu na barabore ta ḡeri ma ekiraḡiato, ekirato, “Guba Basileia tu farao vaḡa-tubuna muramurana kavana, vavine ta na kotuna ta moḡo eḡabiato, benamo farao fuseri toitoi ḡesi egiroato, eiaḡoto mo, muramura na mabarana evaḡa-tubu baregoato.” ");
INSERT INTO snc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu na mai dagara mabarari barabore ai tarimarima evaḡa-riba iaḡirito-ḡoi. Ḡena ḡobatai barabore asi eraga-kwanerito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mai veiḡa eveiato ḡenana, peroveta tarimana ḡena guruḡa ema vaḡa-moḡoniato, ekirato, “Au na barabore ḡerina ḡia bavaḡa-guruḡarini; tanobara evesinato ḡarona na beiaḡoma mo initoma veḡuni ḡetanuni dagarari, au na ḡia ḡeri bakiraḡi-foforirini.” ");
INSERT INTO snc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu na mo tarimarima ḡutuma eraga-kwanerito, benamo numai eraka-toḡato. Ḡena mero ḡia ḡenai ḡeiaḡomato, bena ḡekiraiato, ḡekirato, “Ḡauḡa rakavari vamoka nuḡanai baraborena ḡai ḡemai nokiraḡi-maḡataia.” ");
INSERT INTO snc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu na evaḡa-veserito, ekirato, “Widi ḡueri namori evarorini tarimana tu Tarimarima Natuna. ");
INSERT INTO snc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vamoka tu tanobara, ḡue ḡuturi namori tu Barau ḡena Basileia o veḡitaḡau seḡukana gaburenai ḡetanuni tarimari; ḡauḡa rakavari tu Satani ḡena tarimarima doḡoro. ");
INSERT INTO snc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","E ḡauḡa varovarona tarimana tu Diabolo, ḡita ebaru-vinirani tarimana; kwakwa tu tanobara magona beraḡasini kavana. Ḡwaḡwana kwakwana e basibasina tu aneru na beḡe korana-iaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Vaḡa-ilailana ḡauḡa ḡevaḡa-vegogorini, ma karavai ḡegaburini, ḡeḡara-ḡosirini, tanobara bea korini nai, moḡesina kavana bevetoreni: ");
INSERT INTO snc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tarimarima Natuna na ḡena aneru tu betuḡurini, benamo tarimarima ḡeḡori-kerererini tarimari, ema veiḡa rakavari ḡeveirini tarimari mabarari, Barau ḡena Basileia ḡenana beḡe ḡabi-veḡitarini, ");
INSERT INTO snc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","e karava seḡukana ma moremorena nuḡanai beḡe fiu-toḡarini, ema monai roḡo beḡe taḡini, gadikari maki beḡe veḡara-tarini. ");
INSERT INTO snc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Moḡa ḡaronai maki Barau ḡena vei-iobukaiobuka tarimari tu, ḡaro kavana ma mamari ḡesi Tamari ḡena Basileia nuḡanai beḡe tanuni. Deikara ma seḡana tarimana, bene seḡaḡi.” ");
INSERT INTO snc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Guba Basileia tu farefare vekuretoḡana tanobarai kavana. Tarima ta na edoḡariato, benamo ma eguriguri-ḡauato. E ma iakuna ḡesi eiaḡoto, ḡena dagara mabarari ea voivoi-iaḡirito, benamo mo tano evoiato.” ");
INSERT INTO snc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Guba Basileia tu bisinesi tarimana kavana, galasi foreri davari barego dagarari evetaurini. ");
INSERT INTO snc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ḡia na voina barego lelevaḡina forena ta edoḡariato, benamo ḡena farefare mabarari evoivoi-iaḡi fitoḡarito roḡo, monai vau mo davana forena evoiato.” ");
INSERT INTO snc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Guba Basileia tu reke kavana, davarai ḡefiu-riḡoani nai, maḡani-kone irauirau nuḡanai ḡetoḡani. ");
INSERT INTO snc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Reke evonuni nai, ḡeinu-raḡeani tanobara ḡana, benamo reke tarimari ḡetanu-tarini vau, maḡani-kone reke nuḡanai moḡeri mabarari ḡeviriḡirini, namori mabarari tu baketi ai ḡeḡurarini, a rakavari tu ḡefitoḡarini. ");
INSERT INTO snc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Moḡesi vetoḡa bevetoreni, tanobara magona beraḡasini nai. Aneru beḡe iaḡomani nai, veiḡa rakava tarimari tu beḡe tore-veḡitarini veiḡa iobukaiobuka tarimari ḡerina; ");
INSERT INTO snc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","e karava more-morena nuḡanai beḡe fiu-toḡarini. Monai beḡe taḡini, gadikari maki beḡe veḡara-tarini.” ");
INSERT INTO snc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu na ḡena mero edanaḡirito, ekirato, “Mai guruḡa mabarari nuḡami ai boḡo riba-ḡitakauri ba?” Ḡia na ḡekiraiato, “Oi, Vereḡauka.” ");
INSERT INTO snc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iesu na ma ekirarito, ekirato, “Moḡesina nai, bema taravatu vaḡa-ribana tarimana ta Guba Basileia ḡena vevaḡa-riba tarimanai beiaḡoni neganai, ḡia tu numa biaguna ta kavana, ḡena farefare variḡuri ema guineri eḡabi-rosirini ḡena farefare vaḡa-vegogo numana na.” ");
INSERT INTO snc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu na maiḡeri barabore ekiraḡi-ḡosirito vau, mo gabu eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Monana vau ebaregoto vanuḡanai eraḡasito. Iuda tarimari ḡeri rubu ai evevaḡa-ribato-ḡoi nai, ḡia ḡeseḡaḡiato-ḡoi tarimari na ḡena ḡobata guruḡari ḡeḡaba-iaḡirito, ema maiḡesi ḡevedanaḡito, ḡekirato, “Mai tarima ḡena riba tu ainana eḡabito, e mai nuḡa-farevaḡi veiḡari maki kamasi eveirini? ");
INSERT INTO snc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ḡia tu kamuda tarimana natuna, ene? Ḡia sinana arana Maria ḡetoni, ene? E ḡia tarina merori arari tu Iakobo (o Iames) e Iosefa, Simona e Iudas, ene? ");
INSERT INTO snc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ema ḡia tarina vavineri mabarari maki ḡita ḡesi maiḡeri. Senaḡi mai riba ema seḡuka mabarari ne ainana eḡabito?” ");
INSERT INTO snc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Moḡesi ḡetuḡamaḡi-ḡutuma viniato nai, ḡia na asi ḡeḡabi-raḡeato. Iesu na maiḡesi ekirarito, ekirato, “Peroveta tarimana tu gabu mabarari ai beḡe gubakauani, senaḡi ḡena vanuḡa korikori ema ḡena numa tarimari na moḡo asi beḡe gubakauani.” ");
INSERT INTO snc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Monai nuḡa-farevaḡi veiḡa boruri viravira moḡo eveirito, korana asi ḡeri veḡabidadama nai. ");
INSERT INTO snc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mo negai Heroda, Galilea verena, Iesu varina eseḡaḡiato. ");
INSERT INTO snc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Benamo ḡia na ḡena vetuḡunaḡi tarimari evaḡa-guruḡarito, ekirato, “Mai tu Ioane Babatiso mase na bevaisiraḡe-ḡenoḡoi nai, seḡuka veiḡari boruri eveirini.” ");
INSERT INTO snc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroda na Ioane eḡabi-tariato ma ebarubaruato, dibura numai ekou-ḡauato. Ḡia na maiḡesina evei-viniato, korana ḡia kakana Filipo ḡaraḡona, Herodia, ḡaramanai. ");
INSERT INTO snc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ioane Babatiso na Heroda evaḡa-guruḡaiato-ḡoi, ekirato, “Ḡoi na Herodia boḡaraḡo-veraria tu asi maoro.” ");
INSERT INTO snc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroda eura-rakavato, Ioane bene vaḡia, senaḡi tarimarima gariri eveito, korana ḡia na Ioane ḡetuḡamaḡiato-ḡoi tu peroveta tarimana ta. ");
INSERT INTO snc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Senaḡi Heroda ḡena ḡora ḡaronai o betdei, Herodia natuna ḡuiatona tu varivari tarimari ḡoirari ai ebarato. Heroda maki mai bara na evaḡa-iakuato. ");
INSERT INTO snc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Moḡesina nai ḡia ma nuḡana mabarana ḡesi guruḡa gwaḡiḡinai maiḡesina bara-ḡuiatona ekiraḡitore-viniato, ekirato, “Ḡoi kara oura-viniani dagarana nokiraḡia, benamo bavinimuni.” ");
INSERT INTO snc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ḡuiato tu sinana na varau evaḡa-guruḡa guineato ema elaunaḡiato nai, ḡia maiḡesina ekirato, “Ioane Babatiso debana diḡu ai mainai noma vinigu.” ");
INSERT INTO snc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heroda nuḡana emetoto, senaḡi ḡena guruḡatore ḡuiato ḡenai varau eveiato e ḡena varivari tarimari dairi ai ekirato, beḡene vinia. ");
INSERT INTO snc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Benamo tarima debari ebasi-ḡuturito-ḡoi tarimana ta etuḡuato dibura numai, Ioane debana ebasi-ḡutuato. ");
INSERT INTO snc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ioane debana tu diḡu ai ḡeḡuraiato vau, ḡuiato ḡeviniato, benamo sinana ḡenai eḡwa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Benamo Ioane ḡena mero ḡeiaḡomato, tauḡanina ḡeḡabiato, ḡeguriato. Moḡa murinai ḡeiaḡoto Iesu ḡekira-varaiato. ");
INSERT INTO snc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu na Ioane ḡena mase varina eseḡaḡiato nai, ḡia monana eraka-ḡerevaḡito ḡasi na, asi tarimarima gabuna ḡana eiaḡoto. Senaḡi tarimarima na ḡeseḡaḡiato nai, ḡeri vanuḡa ḡeiaḡuirito, tano na kwakuri na ḡerakato, Iesu murina na ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu fenu ai edarokauto nai, ḡia na tarimarima ḡutuma-bara eḡitarito, benamo evetuḡa-rakavarito, ema ḡeri keve tarimari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lavilavi rekenai Iesu ḡena mero ḡia ḡenai ḡeiaḡoto, bena ḡekirato, “Mai tu gabu fakana, asi tarima-rimana, ḡaro varau bevariḡo naima, mai tarimarima ḡutuma-bara notuḡuri, be vanuḡai ḡari ḡaniḡani beḡenea voi.” ");
INSERT INTO snc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Iesu ekirato, “Ḡia asi beḡene raka-veḡita, ḡomi na ḡari boḡono viniri, be beḡene ḡaniri.” ");
INSERT INTO snc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ḡia na ḡekiraiato, ḡekirato, “Ḡai ḡemai tu beredi imaima (5) e maḡani-kone ruarua (2) moḡo maiḡeri.” ");
INSERT INTO snc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu na ekirarito, ekirato, “Maiḡana ḡoḡabi-iaḡomari au ḡegu ai.” ");
INSERT INTO snc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Benamo ḡia na mai ḡutuma-bara elaunaḡirito, ḡauḡa iatari ai beḡene tanutanu-tari etato, monai vau ḡia na beredi imaima e maḡani-kone ruarua eḡabirito, gubai eboḡe-raḡeto, Barau evaḡa-namoato vau, etavi-kirakirarito, ḡena mero evinirito, benamo ḡia na vau mai tarimarima ḡutuma-bara ḡevinirito. ");
INSERT INTO snc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mabarari ḡeḡani-maseto; ḡaniḡani kwari ḡevaḡa-vegogorito, boseḡa gabanana ruarua (12) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ḡeḡaniḡanito, tau moḡo, mabarari tu 5,000 kavana, senaḡi vavine ma naturi keikeiri ḡesi tu asi ḡeiavirito. ");
INSERT INTO snc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Moḡa murinai Iesu na ḡena mero evaḡa-guruḡarito, ḡasi ai beḡene raḡekau, beḡene guine, kou reke ta ḡana beḡene iaḡo etato. A ḡia tu mo tarimarima ḡutuma-bara roḡo etuḡu-rovorovorito. ");
INSERT INTO snc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mai tarimarima vovoka etuḡu-rakarito vau, ḡia ḡereḡana ḡoro ḡana evaraḡeto, bene ḡauḡau ḡana. Varau eboḡito nai, ḡia tu roḡo moḡa, ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ḡasi tu kotuna ma fakana tanobara ḡenana kou nuḡanai, e ureure na edori-ḡareva ḡarevaiato, korana iavara na ḡasi ḡena raga ḡoirana rekena na etoḡato-ḡoi nai. ");
INSERT INTO snc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Horaḡauna 3 ema 6 koloko vekaravari ai boḡiboḡi rekenai, Iesu ḡia ḡeri ai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Senaḡi ḡena mero na nanu iatana na erakato-ḡoi ḡeḡitaiato, benamo nuḡari maki ḡefare-vaḡito, ema ḡegari-rakavato, ḡekirato, “Mo tu murava ta!” Ḡegarito nai ḡeḡabato maki. ");
INSERT INTO snc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesu na asikauna evaḡa-guruḡarito, ekirato, “Ḡonuḡa-gwaḡiḡi, mai tu au; asi ḡogari.” ");
INSERT INTO snc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petero na evaḡa-veseato, ekirato, “Vereḡauka, bema moḡoni ḡoi neganai, bono launaḡigu, be nanu iatanai bana raka, ḡemu ai bana iaḡosi.” ");
INSERT INTO snc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu ekirato, “Noiaḡoma!” Benamo Petero ḡasi na eraka-riḡoto, nanu iatanai erakato, Iesu ḡenai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Senaḡi Petero na iavara (e ureure) eḡitaiato, benamo egarito, erei-riḡoto nai eḡaba-fouto, ekirato, “Vereḡauka o, noma vaḡa-maḡurigu.” ");
INSERT INTO snc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iesu asikauna ḡimana etuḡu-iaḡoato, ḡenai eveḡabikauto, ekirato, “Veḡabidadama kei tarimana, karase nai odaradarani?” ");
INSERT INTO snc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tauri ruarua ḡasi ai ḡeraḡekauto vau iavara edokoto. ");
INSERT INTO snc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ḡasi tarimari tu ḡia ḡoiranai vau ḡetoma-rakariḡoto, ḡekirato, “Moḡoni veḡata, ḡoi tu Barau Natuna.” ");
INSERT INTO snc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ḡia ḡasi na ḡevanaḡito, Genesareta tanonai ḡeraḡasito. ");
INSERT INTO snc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mo gabu tarimari na Iesu ḡea ḡita-doḡariato, benamo ḡia varina mo gabu vanuḡari mabarari ḡevaḡa-ribarito. Benamo keve tarimari ḡia ḡenai ḡeḡwa-iaḡorito, ");
INSERT INTO snc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","e ḡenoḡiato, ḡena dabuḡa dudunai moḡo maki beḡene veḡabikau. Gabivau, ḡeveḡabi-kauto tarimari mabarari varau ḡenamoto. ");
INSERT INTO snc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisea tarimari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari kotari Ierusalema na Iesu ḡenai ḡeiaḡoto, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Karase nai ḡoi ḡemu mero na ḡita senera vereri ḡeri vevaḡa-riba asi ḡeseḡaḡirini? Ḡia ḡimari maki dabara korikoriri ai asi ḡeḡuriḡirini vau ḡeḡaniḡanini!” ");
INSERT INTO snc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu na evaḡa-veserito, ekirato, “Be karase senemi vereri ḡeri vevaḡa-naḡi boḡono korana-iaḡiri urari ai, Barau ḡena taravatu guruḡari ḡoruḡarini? ");
INSERT INTO snc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Barau ekirato, ‘Tamamu e sinamu bono gubakauri,’ ema ‘Deikara ta na tamana o sinana beguruḡa-rakava viniani tarimana tu boḡono vaḡi-mase!’ ");
INSERT INTO snc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Senaḡi ḡomi ḡokirani, tarima ta na tamana o sinana bevaḡa-guruḡaiani, bekirani, ‘Au na ḡomi asi bavaḡa-kavamini, korana bara vinimi dagarana tu Barau ḡena dagara, naima ḡia aviniani.’ ");
INSERT INTO snc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Moḡesi veiḡai ḡomi na tarima ḡokouani, tamana e sinana asi bene vaḡa-kavari e asi bene gubakauri ḡana. Ḡemi sene maḡuriri maiḡesiri ḡerina Barau ḡena taravatu guruḡari asi aniri ai ḡovaḡa-iaḡorini. ");
INSERT INTO snc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ḡofaḡofa tarimami, Isaia na eperoveta-iaḡimito tu moḡoni, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mai besena tu mururi koriri ai moḡo au ḡegubakauguni ḡeri Barau, senaḡina ḡia nuḡari tu manaḡa rakava au ḡegu ai. ");
INSERT INTO snc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ḡetoma-rakariḡo vini-kavaguni, ḡeri vevaḡa-riba tu tarimarima ḡeri vevaḡa-naḡi taravaturi, a dia au ḡegu!’” ");
INSERT INTO snc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu na tarimarima ḡutuma ḡia ḡenai ekea-iaḡomarito, benamo ekirarito, ekirato, “Ḡoseḡaḡi, ema boḡono riba-maoro: ");
INSERT INTO snc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Murika na eraka-toḡani tarima murunai dagarana na ḡia asi evaḡa-rakavaiani, senaḡina kara ḡia nuḡana o loruna ḡutuna na ma muruna na eraka-rosini dagarana na ḡia evaḡa-rakavaiani.” ");
INSERT INTO snc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ḡena mero ḡia ḡenai ḡeiaḡomato, benamo ḡekiraiato, ḡekirato, “Ḡoi ribamu, Farisea tarimari tu ḡoi ḡemu guruḡa beḡe seḡaḡia nai, nuḡari beḡe midigu?” ");
INSERT INTO snc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu evaḡa-veseto, ekirato, “Tamagu gubai etanuni na ḡau asi evarorito mabarari tu beḡe raḡa-vaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ḡotuḡamaḡi-fitoḡari! Ḡia matari bubu, senaḡi ḡeurani mata-bubu tarimari beḡene ḡori-kauri. Bema mata-bubu tarimana na mata-bubu tarimana ta beḡori-kauani nai, tauri ruarua koufai beḡe keto-riḡoni.” ");
INSERT INTO snc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petero na ekiraiato, ekirato, “Mai guruḡa veabanaḡina tauna korikori novaḡa-ribama.” ");
INSERT INTO snc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu na ekirarito, ekirato, “Ḡomi maki asi ḡotuḡamaḡi-fakani tarima kotari kavana? ");
INSERT INTO snc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Asi ḡoribani maki? Dagara ta tarima muruna na eraka-toḡani, eiaḡoni sinaḡenai, monana eiaḡoni tauḡanina ḡenana ea raka-rosini. ");
INSERT INTO snc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Senaḡina muruna na ḡeraka-rosini dagarari tu nuḡana o loruna na ḡeiaḡomani naima, maiḡeri dagara na tarima ḡevaḡa-rakavaiani. ");
INSERT INTO snc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tarima nuḡana o loruna ḡenana tuḡamaḡi rakavari ḡeraḡeni nai, evaḡivaḡini, eveḡura-vanaḡini, emata-boraḡani, elemani, Kota gabunai ḡofaḡofa guruḡari ekiraḡirini, ema tarima namori arari ḡofaḡofa veiḡari ai evari-fiurini. ");
INSERT INTO snc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Maiḡeri dagara na tarima evaḡa-rakavaiani; senaḡina ḡimamu asi oḡuriḡiani vau oḡaniḡanini, monana tarima asi evaḡa-rakavaiani.” ");
INSERT INTO snc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu na mo gabu eraga-kwaneato, eraka-iaḡoto Taia e Sidono rekeri tanori ai eraḡasito. ");
INSERT INTO snc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Benamo monai etanuto-ḡoi vau, Kanana vavinena ta Iesu ḡenai eiaḡomato, eḡaba-fouto, ekirato, “Vereḡauka, Davida Natuna o, au novetuḡagu! Au natugu ḡuiatona tu iauka rakavana na beboroḡia nai, ḡena midigu initoma tu barego rakava moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Senaḡina Iesu na ḡia asi evaḡa-veseato. Benamo ḡena mero ḡia ḡenai ḡeiaḡomato, ḡenoḡiato, ḡekirato, “Notuḡu-rakaia! Ḡita murira na eiaḡomani ema guru baregona eveiani.” ");
INSERT INTO snc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu evaḡa-veseto, ekirato, “Barau na au etuḡuguto tu, rekwarekwa mamoeri, Isaraela tarimari, ḡeri moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Benamo mo vavine Iesu kwakuna koranai evetuitarito, ekirato, “Vereḡauka, novaḡa-kavagu!” ");
INSERT INTO snc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu evaḡa-veseto, ekirato, “Mero misiri ḡari ḡaniḡani bita ḡabirini, ma kwaiva bita fiu-vinirini tu asi maoro.” ");
INSERT INTO snc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vavine na evaḡa-veseato, ekirato, “Vereḡauka, mani tu moḡoni, senaḡina kwaiva na ḡaniḡani kwari ḡeketo-firiḡoni, biaguri ḡeri ḡaniḡani fatari na, maki ḡeḡanirini.” ");
INSERT INTO snc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Benamo Iesu na evaḡa-veseato, ekirato, “Veḡabidadama barego vavinemu! Kara oura-viniani veiḡana beḡorani.” Mo horai moḡo ḡia natuna ḡuiatona enamoto. ");
INSERT INTO snc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu na mo gabu eiaḡuiato, Galilea kouna sevina na eraka-vanaḡito. Benamo ḡoro tai eraḡeto, tuḡunai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tarimarima ḡutuma-bara ḡia ḡenai ḡeiaḡomato, keve irauirau tarimari ḡeḡabi-iaḡomarito, kotari kwaku rakava, mata-bubu, kobari na ḡedarato-ḡoi tarimari, muru-bubu, ema keve irauirau ḡutuma maki. Iesu kwakuna koranai ḡema tore-taririto, benamo ḡia na evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tarimarima mabarari na mai vetoḡa ḡeḡitaiato nai, ḡeḡaba-rakavato, korana mururi bubu tarimari ḡeguruḡato, ḡedarato-ḡoi tarimari tauḡaniri vinuba gaburi ai ḡevetoreto, kwaku rakava tarimari ḡerakato, mata-bubu tarimari ḡeboḡe-boḡeto. Benamo ḡia na Isaraela ḡeri Barau ḡevaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ḡena mero ḡia ḡenai ekea-iaḡomarito, ekirato, “Au na mai tarimarima avetuḡarini, korana ḡaro toitoi veḡatana au ḡesi mainai beḡe tanu, ma kara ta maki roḡosi roḡo beḡene ḡania. Ḡaniḡani ta roḡosi roḡo beḡene ḡani nuḡanai, au na asi batuḡu-rakarini, korana dabarai beḡea borimarini garina.” ");
INSERT INTO snc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ḡena mero na ḡedanaḡiato, ḡekirato, “Mai tano fakanai ḡaniḡani vovoka tu kamasi bita doḡarini vau, mai ḡutuma-bara bita ḡuburini?” ");
INSERT INTO snc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡemi ai beredi tu vira maniḡa?” Ḡia ḡekirato, “Beredi imaima ruarua (7) ḡai ḡemai maiḡa, ema maḡani-kone misiri kotari maki.” ");
INSERT INTO snc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Benamo Iesu na mai tarimarima asisebo ekirarito, tano ai ḡetanutanu-tari. ");
INSERT INTO snc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Benamo beredi imaima ruarua (7) e maḡani-kone eḡabirito, Barau evaḡa-namoato, ebuki-ḡuturito, ḡena mero evinirito, ḡia na vegogo tarimari ma ḡevinirito. ");
INSERT INTO snc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mabarari ḡeḡani-maseto murinai, Iesu ḡena mero na ḡaniḡani kwari ḡegogorito, boseḡa imaima ruarua (7) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mo ḡaniḡani ḡeḡaniato ḡenana tau moḡo mabarana tu 4,000, senaḡina vavine ma naturi ḡesi tu asi ḡeiavirito. ");
INSERT INTO snc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Benamo Iesu na mai ḡutuma-bara etuḡu-rovo rovorito, a ḡia ḡasi ai eraḡeto, Magadan tanona ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisea e Sadukea tarimari kotari Iesu ḡenai ḡeiaḡoto, benamo ḡedanaḡi-ribaḡaniato. Ḡeri ura vetoḡa ta guba na bene mariḡo, beḡene ḡitaia, ḡia tu moḡoni Barau na etuḡuato tarimana. ");
INSERT INTO snc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Senaḡi Iesu na evaḡa-veserito, ekirato, “Lavilavi ai ḡaro evariḡoni nai, ḡokirani, ‘Guba bekakakaka, be ḡura asi beraguni, ḡitaḡitana tu nega namo.’ ");
INSERT INTO snc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A boḡi-boḡi rekenai ḡokirani, ‘Toma tu ḡura ma iavarana ḡesi eiaḡomani, korana guba bekakakaka, ema ḡitaḡitana maki ma garina.’ Guba ḡoḡitaiani nai, kara boḡo kiraḡiani, nega namo o nega rakava ḡeri ai tu lorinai, senaḡina maitoma ḡaro vetoḡari tu asi ribami! ");
INSERT INTO snc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Maitoma ḡuru rakavana ma veḡura-vanaḡina ḡesi, (Barau ḡenana ḡeveḡitato ḡuruna), vetoḡa ma evetauani, senaḡina vetoḡa ta asi bavinimini, a Iona, peroveta tauna, ḡenai eḡorato vetoḡana moḡo.” Benamo Iesu na eraga-kwanerito, ḡerina eraka-veḡitato. ");
INSERT INTO snc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kou na ḡeḡasi-vanaḡito reke ta kefo ai vau, Iesu ḡena mero ḡeribato, ḡaniḡani asi ḡeḡabikauto. ");
INSERT INTO snc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Benamo Iesu na ekirarito, ekirato, “Lorimi boḡono vetore, boḡono boḡeboḡe, korana Farisea tarimari e Sadukea tarimari ḡeri farao vaḡa-tubuna mura-murana lorina boḡono torea.” ");
INSERT INTO snc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ḡia tauḡeri ḡeguruḡa-guruḡa iaḡi-vegogo-ato, ḡekirato, “Ḡia maiḡesi eguruḡani, korana beredi asi bita ḡabikau nai.” ");
INSERT INTO snc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ribana ḡia na kara ḡekiraḡiato naima, edanaḡirito, ekirato, “Karase nai ḡereḡami na beredi asi boḡo ḡabikau ḡoguruḡa-guruḡa iaḡiani? Veḡabidadama kei tarimami! ");
INSERT INTO snc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ḡomi roḡosi roḡo boḡono riba-maoro? E asi ḡotuḡamaḡiani beredi imaima (5) ḡenana tarimarima 5,000 ḡeḡaniḡanito, e beredi kwari ḡogogorito tu boseḡa vira ḡovaḡa-vonurito? ");
INSERT INTO snc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ema ta maki, farao imaima ruarua (7) ḡenana tarimarima 4,000 ḡeḡaniḡanito, e beredi kwari ḡogogorito tu boseḡa vira ḡovaḡa-vonurito? ");
INSERT INTO snc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kamasi se nuḡami asi ḡevekeoni, ma asi ḡoribani, au na tu dia beredi aguruḡa-iaḡiani? Ma nakira: Farisea tarimari e Sadukea tarimari ḡeri farao vaḡa-tubuna dagarana lorina boḡono torea!” ");
INSERT INTO snc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Benamo ḡia nuḡari ḡevekeoto, ema ḡeribato maki, Iesu na dia farao vaḡa-tubuna muramurana eguruḡa-iaḡiato, senaḡina Farisea e Sadukea tarimari ḡeri vevaḡa-riba guruḡari ḡofaḡofari rekeri ai eguruḡato. ");
INSERT INTO snc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu eiaḡoto, Kaisarea Filipi vanuḡana tanona rekenai eraḡasito. Monai vau ḡia na ḡena mero edanaḡirito, ekirato, “Tarimarima tu kara ḡetoni, Tarimarima Natuna tu deikara?” ");
INSERT INTO snc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ḡia ḡekirato, “Kotari ḡekirani, ḡoi tu Ioane Babatiso, kotari ḡekirani, Elia, ma tari ḡekirani tu, Ieremia o peroveta tarimana ta.” ");
INSERT INTO snc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iesu na ḡia edanaḡirito, ekirato, “A ḡomi tu kara ḡotoni au tu deikara?” ");
INSERT INTO snc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petero na evaḡa-veseato, ekirato, “Ḡoi tu Keriso, maḡuri Barauna Natuna.” ");
INSERT INTO snc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu na evaḡa-vese viniato, ekirato, “Simona, Ioane natuna, bono iaku ema vevaḡa-namo iatamu ai bene tanu, korana mai vevaḡa-vese moḡonina bovinia, maiḡa tu dia tarima ta ḡenana beiaḡoma, senaḡina mai tu au Tamagu gubai etanuni na ḡoi bevinimu. ");
INSERT INTO snc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Moḡa lorinai akiramuni: Ḡoi tu Petero, (anina tu fore), ema mai fore iatanai au ḡegu ekalesia bavaḡa-ruḡaiani. Mase ḡena seḡuka na maki asi bevaḡa-darereani. ");
INSERT INTO snc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Au na Guba Basileia kiri maki ḡoi bavinimuni; tanobarai bobarurini dagarari mabarari gubai maki Barau na bebarurini; e tanobarai boruḡarini dagarari mabarari gubai maki Barau na beruḡarini.” ");
INSERT INTO snc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Benamo Iesu na ḡena mero ekirarito, tarima ta asi beḡene vaḡa-ribaia ḡia tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mo nega na veḡata Iesu na ḡena mero evaḡa-riba guinerito, ekirato, “Au tu Ierusalema ḡana aiaḡoni, be Iuda vereri, e Rubu Veaḡa vereri baregori, ema taravatu vaḡa-riba-iaḡina tarimari ḡerina roḡo amidigu-lelevaḡini; ema beḡe vaḡi-maseguni maki, senaḡina ḡaro vaḡa-toitoinai vau, mase na ma bavaisiraḡe-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero na eḡori-veḡitaiato, benamo esisiba-viniato, ekirato, “Vereḡauka, dia maniḡesina; maniḡesina asi beḡe vei-vinimuni, ma asi beḡorani maki.” ");
INSERT INTO snc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Benamo Iesu eboḡe-kureto, Petero ekiraiato, ekirato, “Ḡoi Satani, ḡeguna noraka-ḡerevaḡi! Au ḡegu iaḡoiaḡo ḡoi na odiu-ḡauani, korana mai ḡemu tuḡamaḡi guruḡana tu dia Barau ḡenana eiaḡomani, senaḡina tarimarima ḡerina.” ");
INSERT INTO snc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Bema tarima ta au murigu ai bene raka etoni nai, tauḡena bene veruḡa, ḡena satauro bene ḡwaia, ma murigu ai bene raka.” ");
INSERT INTO snc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Moḡa lorinai deikara tauḡena moḡo ḡena maḡuri lorina etoreani tarimana, ḡena maḡuri befitoḡaiani. A deikara au daigu ai ḡena maḡuri befitoḡaiani tarimana, ḡena maḡuri asi bevei-rekwarekwaiani, senaḡi bedoḡariani. ");
INSERT INTO snc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tarima ta na tanobara mabarana uranai ḡena maḡuri befitoḡaiani, ḡena namo tu kara ḡia ḡenai? Korana tarima ta ḡena maḡuri efitoḡaiato nai, kara na vau ma bevoi-ḡenoḡoiani? ");
INSERT INTO snc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Korana Tarimarima Natuna tu Tamana mamana marevana e seḡuka baregona e ma ḡena aneru mabarari ḡesi beḡe iaḡomani, benamo tarimarima tata ḡeri veiḡa ilailanai voiri tu bevinirini. ");
INSERT INTO snc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Moḡoni akiramini, mai kotari ini ḡeruḡa-taḡoni maiḡeri tu asi roḡo beḡe maseni, beiaḡoni mo, Tarimarima Natuna ḡena Basileia nuḡanai beiaḡomani beḡe ḡitaiani. ");
INSERT INTO snc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ḡaro imaima sebona (6) ḡekorito murinai, Iesu na Petero, e Iakobo (o Iames), ema tarina Ioane eḡabirito, ḡoro baregona ta tuḡuna ḡana ḡevaraḡeto, monai ḡia ḡereḡari moḡo. ");
INSERT INTO snc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ḡia ḡeboḡe-taḡoto-ḡoi nuḡanai, Iesu ḡitaḡitana varau eirauto: Ḡia ḡoirana ekimore-kimoreato ḡaro noḡa, ma ḡena dabuḡa ekuro-ḡaroḡaroto. ");
INSERT INTO snc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Benamo mai mero toitoi na Mose e Elia ḡeḡitarito, Iesu ḡesi ḡeguruḡa guruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Monai Petero eguruḡa-fouto, Iesu ekiraiato, ekirato, “Vereḡauka, namo vedaurea ḡita mainai maiḡera! Be, ourani nai, fouta toitoi naragari, ta ḡoi ḡemu, ta Mose ḡena, ema ta Elia ḡena.” ");
INSERT INTO snc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ḡia roḡo eguruḡato-ḡoi, magube kuro-ḡaroḡarona na ema ḡabi-ḡaurito vau, garo ta mai magube nuḡana na ekea-rosito, ekirato, “Mai tu au Natugu, auravini-baregoani; ḡia ḡenai aiaku-rakavani. Ḡia boḡono seḡaḡi-vinia!” ");
INSERT INTO snc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesu ḡena mero toitoi na mai garo ḡeseḡaḡiato nai, tano ai ḡeketo-tarito ḡoirari maki tano ai, korana ḡegari-rakavato nai. ");
INSERT INTO snc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Benamo Iesu tu ḡia ḡeri ai eiaḡoto, tauḡaniri eḡabi-kararito, ekirato, “Ḡovaisivaisi-raḡe, asi ḡogari.” ");
INSERT INTO snc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ḡia ḡeboḡe-vaisito nai, ḡia na tarima ta asi ḡeḡitaiato ḡia ḡesi, Iesu moḡo ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mabarari ḡoro na ḡemariḡoto-ḡoi nai, Iesu na evaḡa-guruḡarito, ekirato, “Boḡo ḡita dagarari tarima ta asi boḡono vaḡa-ribaia, bene iaḡo mo, Tarimarima Natuna mase na bene variḡisi-ḡenoḡoi.” ");
INSERT INTO snc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Benamo Iesu ḡena mero na ḡedanaḡiato, ḡekirato, “Kara dainai taravatu vaḡa-riba-iaḡina tarimari ḡekirani, Elia tu beiaḡoma-guineni?” ");
INSERT INTO snc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu evaḡa-veseto, ekirato, “Moḡoni veḡata, Elia tu beiaḡoma-guineni, dagara mabarari bevaḡa-variḡu ḡenoḡoirini. ");
INSERT INTO snc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A au na akiramini, Elia tu varau eiaḡomato, senaḡi tarimarima tu asi ribari ḡia tu deikara. Ḡeri ura veiḡari ai moḡo ḡevei-viniato-ḡoi. Moḡa ilailanai Tarimarima Natuna maki beḡe vaḡa-midigu midiguani.” ");
INSERT INTO snc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mai guruḡa ḡerina Iesu ḡena mero ḡeribato, ḡia na tu Ioane Babatiso ekiraḡi-kara-viniato. ");
INSERT INTO snc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ḡia ma ḡeḡenoḡoito tarimarima ḡutuma ḡeri ai nai, tarima ta Iesu ḡenai eiaḡomato, ḡoiranai ema vetui-tarito, ");
INSERT INTO snc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ekirato, “Vereḡauka, au natugu merona novetuḡaia! Ḡia tu ḡue na evaḡiani, ema tauḡanina evaḡa-ḡoḡo-ḡogo rakavaiani. Nega ḡutuma karavai eburi-raḡeni e nanu ai eburi-reini. ");
INSERT INTO snc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ḡemu mero ḡeri ai aḡabi-iaḡoato, senaḡina vaḡa-namona ḡia tu asi ilaila.” ");
INSERT INTO snc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu evaḡa-veseto, ekirato, “Asi veḡabidadamami e kira-sirivaḡi ḡuruna! Ḡaro vira au tu sevimi ai bana tanu? Ḡaro vira bana vevaḡa-gwaḡiḡi vinimi? Mero ḡegu ai ḡoḡori-iaḡomaia!” ");
INSERT INTO snc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu na mero tauḡanina ḡenai etanuto iauka rakavana ekira-ḡoiato, benamo iauka rakavana eraka-vaḡito, ma asikauna mero enamoto. ");
INSERT INTO snc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gabivau Iesu ḡena mero ḡenai ḡeiaḡoto, vekuretoḡai ḡedanaḡiato, ḡekirato, “Karase nai ḡai na iauka rakavana asi ilaila baḡa lai-vaḡia?” ");
INSERT INTO snc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu na evaḡa-veserito, ekirato, “Korana ḡemi veḡabidadama asi ilaila naima. Akira-korikorimini, bema ḡemi veḡabidadama mastadi ḡutuna misina korokorona kavana nai, mai ḡoro boḡo kiraiani, boḡo kirani, ‘Mainana noveḡabi-vaisi, ma iomonai noa vetore!’, benamo beveḡabi-vaisini ma beiaḡoni. Veiḡa mabarari maki boḡo veirini riba. ");
INSERT INTO snc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21"," Iauka rakavari maiḡesina lailairi tu dabara irauna tai asiḡina, senaḡina ḡauḡau e ḡaniveaḡai ḡereḡana moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ḡaro ta, Iesu ma ḡena mero ḡesi Galileai ḡetanuto-ḡoi nai, Iesu na ekirarito, ekirato, “Tarimarima Natuna tu beḡe revaiani vau tarimarima ḡimari ai beḡe toreani. ");
INSERT INTO snc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Benamo beḡe vaḡi-maseani, senaḡi ḡaro vaḡa-toitoinai ma bevaisiraḡe-ḡenoḡoini.” Ḡena mero ḡeseḡaḡiato nai, nuḡari ḡemeto-rakavato. ");
INSERT INTO snc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu ma ḡena mero ḡesi Kaperanauma vanuḡanai ḡeraḡasito, benamo Rubu Veaḡa monina ḡegogoato-ḡoi tarimari ḡeiaḡomato, Petero ḡedanaḡiato, ḡekirato, “Ḡomi ḡemi vevaḡa-riba tauna Rubu Veaḡa ḡena takesi moniri tu evinini ba asiḡina?” ");
INSERT INTO snc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero na evaḡa-veseato, ekirato, “Oi, evinini.” Petero numa ḡana eḡenoḡoito nai, Iesu na edanaḡiato, ekirato, “Simona, ḡoi ḡemu tuḡamaḡi tu kamasi? Tanobara vereri o kini ḡeri takesi moniri tu deikara na beḡene viniri? Ḡia naturi na ba tarima boruri na beḡene viniri?” ");
INSERT INTO snc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero evaḡa-veseto, ekirato, “Tarima boruri na.” Iesu na ekiraiato, ekirato, “Moḡa anina, ḡia naturi tu asi beḡe vinini. ");
INSERT INTO snc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Senaḡina asi bitana vaḡa-baruri ḡana, naima noiaḡo kou ḡana. Kimai bono fiu-riḡoa, maḡani-kone giniguinena boinu-raḡeani nai, bokana bono keo-baḡakaia, silva monina ta bodoḡariani nuḡanai. Bono ḡabia, benamo bono viniri ḡita taura ruarua ḡera Rubu Veaḡa takesi monina.” ");
INSERT INTO snc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mo negai Iesu ḡena mero ḡenai ḡeiaḡoto, ḡekirato, “Deikara tu barego vedaurea Guba Basileia nuḡanai?” ");
INSERT INTO snc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A Iesu na mero misina ta ekea-iaḡomaiato, benamo vekaravari ai evaḡa-ruḡa-tariato, ");
INSERT INTO snc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ekirato, “Moḡoni veḡata, akiramini, ḡomi asi boḡo vetuḡamaḡi-kureni e mai mero misina kavana asi boḡo iaḡoni nai, ḡomi tu Guba Basileia nuḡanai asi boḡo raka-toḡani. ");
INSERT INTO snc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tarima ta tauḡena evevaḡa-manauni mai mero misina kavana, ḡia tu barego lelevaḡi Guba Basileia nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ema deikara mero misina maiḡesina kavana au aragu ai beḡabi-raḡeani tarimana na au maki eḡabi-raḡeguni.” ");
INSERT INTO snc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Senaḡina bema tarima ta na au eḡabidadama-viniguni mero misina ta ḡena veḡabidadama evaḡa-rakavaiani, ḡia tu bere namo fore barana ḡaiḡonai ḡere baru-kaua, ma davara dodokunai bere vebora-mase. ");
INSERT INTO snc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tanobara vetuḡana kekei, korana veribaḡani ḡenana tarima ḡeri veḡabi-dadama evaḡa-rakavaiani. Dagara moḡesina vanaḡivanaḡi beḡe ḡorani veḡata, senaḡina veribaḡani evaḡa-ḡoraiani tarimana neḡi, vetuḡana kekei. ");
INSERT INTO snc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bema ḡoi ḡimamu o kwakumu na rakavai etoremuni nai, bono basi-ḡutua, bena bono fitoḡaia! Ḡimamu sebonai o kwakumu sebonai maḡuri vanaḡivanaḡi bono doḡaria tu namo, a asi namo ḡimamu ruarua ma kwakumu ruarua karava eḡara-vanaḡi vanaḡini gabunai beḡe fiu-kaumuni. ");
INSERT INTO snc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bema ḡoi matamu na rakavai etoremuni nai, bono ḡibo-vaḡia, bena bono fitoḡa-kwareḡaia. Matamu sebonai maḡuri vanaḡivanaḡi bono doḡaria tu namo, a asi namo matamu ruarua karava eḡara-vanaḡi vanaḡini gabunai beḡe fiu-kaumuni.” ");
INSERT INTO snc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Lorimi boḡono vetore, mai mero misiri ta boḡo ruḡaiani ḡesi. Korana akiramini: Ḡia aneruri na au Tamagu gubai etanuni ḡoirana nega vanaḡivanaḡi ḡeḡitaiani. ");
INSERT INTO snc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11"," Tarimarima Natuna tu rekwarekwa tarimari vaḡa-maḡuriri ḡana eiaḡomato. ");
INSERT INTO snc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kamasi ḡotuḡamaḡiani? Bema tarima ta ma ḡena mamoe sinau ta (100), senaḡina sebona berekwa-rekwani nai, ḡia kara beveini? Ḡia na tu 99 ḡoro gabakanai beraga-kwane-rini, benamo beiaḡoni, rekwa-rekwa mamoena bea vetauani. ");
INSERT INTO snc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bedoḡariani nai, moḡoni akiramini, beiaku-rakavani moḡo. A ḡena mamoe 99, asi ḡedobito dagarari, maki bevanaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Moḡa ilailanai Tamami gubai etanuni asi ḡena ura, mai mero misiri ta bene rekwarekwa.” ");
INSERT INTO snc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bema ḡoi tarikakamu ta na bevei-rakava vinimuni nai, bono iaḡo, ḡena veiḡa rakavana bono vaḡa-fofori vinia. Senaḡina, vekuretoḡai mai veiḡa bono veia, ḡia ma ḡoi ḡesi moḡo. Bema ḡia na ḡoi beseḡaḡimuni ema beḡabi-raḡemuni nai, tarikakamu ḡoi ḡemu ai beḡenoḡoi. ");
INSERT INTO snc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Senaḡina bema asi beḡabi-raḡemuni nai, tarima sebona o ruarua bono ḡabiri, ḡoi ḡesi boḡono iaḡo ḡenai, benamo ‘guruḡa mabarari beḡene vaḡa-moḡoniri, seḡaḡiseḡaḡi tarimari ruarua o toitoi ḡerina,’ Buka Veaḡa ekirani kavana. ");
INSERT INTO snc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bema ḡia asi beseḡaḡirini nai, beḡe ḡora dagarari mabarari tu rubu o ekalesia vegogona bono kira-varaia. Bema ekalesia vegogona garona asi beseḡaḡiani, ḡoi na ḡia tu Barau asi ribana tarimanai ema takesi gogo o vei-rakava tarimanai bono vaḡa-iaḡoa. ");
INSERT INTO snc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Moḡoni akiramini: Tanobarai boḡo barurini dagarari mabarari gubai maki Barau na bebarurini; e tanobarai boḡo ruḡarini dagarari mabarari gubai maki Barau na beruḡarini. ");
INSERT INTO snc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Au na akira-ḡenoḡoimini: Tano-barai ḡomi tarima ruarua dagara tai nuḡami boḡo tore-sebonaiani ema boḡo ḡauḡau-iaḡiani tu, Tamagu gubai etanuni na bevinimini. ");
INSERT INTO snc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Korana au aragu ai tarima ruarua o toitoi beḡe tanu-vegogoni gaburi ai, au maki ḡia ḡesi monai.” ");
INSERT INTO snc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Benamo Petero tu Iesu ḡenai eiaḡoto, ekirato, “Vereḡauka, au tari-kakagu bevaḡa-rakava iaḡoguni nai, ḡena rakava tu nega vira kavana bana tuḡamaḡi-fitoḡaia? Imaima ruarua (7) ba?” ");
INSERT INTO snc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu evaḡa-veseto, ekirato, “Asiḡina, dia 7 moḡo, senaḡina 70 ma vaḡa-baregona 7, o 70 taims 7, (moḡa anina tu vanaḡivanaḡi). ");
INSERT INTO snc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ḡoseḡaḡi, Guba Basileia tu vere ta kavana, ḡia eurato, ḡena vetuḡu-naḡi tarimari ḡeri ḡabitore bene vetauri ema bene vaḡa-maorori. ");
INSERT INTO snc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ḡia na ḡabitore dori evetaurito-ḡoi nuḡanai, vetuḡunaḡi tarimana ta ḡema-ḡabi-toḡaiato, ḡia ḡena ḡabitore ḡenai vira milion kina, moni barego vedaurea, eveiato. ");
INSERT INTO snc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mai vetuḡunaḡi tauna ḡena moni asi ilaila ḡena ḡabitore voina vinivinina ḡenai. Moḡesina naima vere na ḡena vetuḡu-naḡi merori ekirarito, mai tarima beḡene voivoi-iaḡia, vere ta ḡena vetuḡunaḡi meronai bene iaḡo, ma ḡaraḡona e ma natuna ema ḡena farefare mabarari ḡesi maki, mo ḡena ḡabitore bene davaia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Vetuḡu-naḡi tauna vere kwakuna koranai evetui-tarito, enoḡiato, ekirato, ‘Au ḡegu ai bono vevaḡa-gwaḡiḡi. A au na ḡemu dagara mabarari voiri bavinimuni.’ ");
INSERT INTO snc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Vere na evetuḡaiato nai, vetuḡunaḡi tauna ḡena ḡabitore etuḡamaḡi-fitoḡaiato, benamo etuḡu-rakaiato. ");
INSERT INTO snc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mai vetuḡunaḡi tauna eraka-rosito, ḡia ḡatana vetuḡunaḡi tarimana ta edoḡariato. Mai ḡatana moni kotuna eḡabi-toreato ḡia ḡenai. Eḡabi-tariato, ma ḡaiḡona egigiato, ekirato, ‘Au ḡegu ai oḡabi-toreato monina voina novinigu!’ ");
INSERT INTO snc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ḡatana vetuḡunaḡi tarimana ḡia kwakuna koranai evetui-tarito, enoḡiato, ekirato, ‘Nega kota novinigu roḡo, be voina mabarana bana vinimu!’ ");
INSERT INTO snc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Senaḡina ḡia asi eurato, benamo dibura numai edori-toḡaiato. Monai bene tanu, bene iaḡo mo, ḡena ḡabitore voina bene dava-iaḡia etato. ");
INSERT INTO snc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Benamo ḡia ḡesi vetuḡunaḡi ḡeiaḡo-vini vegogoato-ḡoi tarimari na mo veiḡa ḡeḡitaiato nai, ḡia nuḡari ḡemetoto, benamo ḡeiaḡoto vere ḡenai, mo kara ḡeḡorato dagarari mabarari ḡevaḡa-ribaiato. ");
INSERT INTO snc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Moḡesi nai ḡia na vetuḡunaḡi tauna numai ekea-toḡaiato, ekiraiato, ekirato, ‘Ḡoi vetuḡunaḡi tauna rakavana! Au na ḡoi moni vira milion au ḡegu ai oḡabi-toreato dagarari mabarari atuḡamaḡi-fitoḡarito, voina asi oviniguto, korana onoḡiguto nai. ");
INSERT INTO snc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ilailana ḡoi na maki karomu vetuḡunaḡi tauna boro vetuḡa-ḡwaia, au na ḡoi avetuḡa-ḡwamuto kavana.’ ");
INSERT INTO snc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mai vere ebaru-rakavato, benamo vetuḡunaḡi tauna dibura numai etoreato, monai metona bene ḡwaia mo, ḡena ḡabitore voina mabarana ma bene vini-ḡenoḡoia. ");
INSERT INTO snc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iesu ḡena guruḡa magona rekenai maiḡesina ekirato: Tamagu gubai etanuni na ḡomi mabarami mai veiḡa sebonai moḡo bevei-vinimini, bema ḡoi tarikakamu ḡena rakava nuḡamu mabarana ḡesi asi botuḡamaḡi-fitoḡaiani nai.” ");
INSERT INTO snc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu na maiḡeri dagara mabarari eguruḡa-iaḡi ḡosirito murinai, Galilea eiaḡuiato, Iudea tanona ḡana eiaḡoto, Ioridana ḡarukana reke ta kefonai. ");
INSERT INTO snc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tarimarima ḡutuma-bara ḡia murinai ḡeiaḡomato, e monai ḡeri keve evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisea tarimari kotari ḡia ḡenai ḡeiaḡoto, ḡevedanaḡi-veribaḡaniato, ḡekirato, “Tau ta ḡena ura ḡaraḡona bene fitoḡaia etoni nai, taravatu na beḡabiani?” ");
INSERT INTO snc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu na evaḡa-veserito, ekirato, “Ḡomi na Buka Veaḡa asi ḡoiaviani? Maiḡesi ekirani, ‘Tovotovona na veḡata, Barau na dagara mabarari eveirito nai, ḡia na tarimarima maki eveirito tau e vavine.’ ");
INSERT INTO snc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Benamo Barau ekirato, ‘Moḡesina nai tau ta na tamana e sinana beraga-kwanerini, ḡaraḡona ḡesi beḡe tanuni, benamo ḡia tauri ruarua beḡe sebonani.’ ");
INSERT INTO snc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Moḡa lorinai ḡia tu dia ruarua, senaḡi sebona moḡo. Moḡesi nai Barau na etore-sebonarito tarimari tu, tarima ta na asi ma bene tore-kirari.” ");
INSERT INTO snc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisea tarimari na ḡekiraiato, ḡekirato, “Karase nai Mose na taravatu eveiato nai, ekirani, tau na veḡaraḡo ruḡaruḡana fefana betoreani vau, ḡaraḡona betuḡu-rakaiani?” ");
INSERT INTO snc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu evaḡa-veseto, ekirato, “Mose na maoro evinimito, ḡaraḡomi boḡono tuḡu-rakari ḡana, korana ḡomi vaḡa-ribami tu gwaḡiḡi rakava nai. Senaḡina Barau na dagara mabarari eveirito nai, maiḡesina tu asiḡina. ");
INSERT INTO snc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Akiramini: Deikara na ḡaraḡona, enabe asi eveḡura-vanaḡini, senaḡi efitoḡaiani moḡo, vavine ta ma beḡaraḡoani, ḡia tu beveḡura-vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iesu ḡena mero na ḡekiraiato, ḡekirato, “Veḡaraḡo dabarana mo-ḡesina nai, tarimarima asi beḡene veḡaraḡo tu namo banaḡu.” ");
INSERT INTO snc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu evaḡa-veseto, ekirato, “Mai vevaḡa-riba maiḡa tarimarima mabarari na asi beḡe tuḡamaḡi-fakaiani, senaḡi Barau na deikara tuḡamaḡi-faka evinirito tarimari moḡo. ");
INSERT INTO snc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tarimarima kotari asi ḡeveḡaraḡoni, korana moḡesi veḡatana ḡemaḡurito sinari ḡerina, be asi ilaila beḡe veḡaraḡoni; ma kotari tu eunuko tauri kavari, (tarimarima na seuri ḡefararini); ema kotari tu Guba Basileia o Barau vetuḡunaḡina beḡene iaḡo-vinia uranai asi ḡeveḡaraḡoni.” ");
INSERT INTO snc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tarima kotari na naturi Iesu ḡenai ḡeḡwa-iaḡorito, ḡimana ḡia iatari ai bene tore-kauri, ema bene ḡauḡau ḡana. Senaḡina ḡena mero na ḡekira-ḡoirito. ");
INSERT INTO snc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu na ekirarito, ekirato, “Mani mero misiri ḡeiaḡoma au ḡegu ai, asi ḡokira-ḡoiri, korana Guba Basileia tu maniḡesina kavana tarimari ḡeri.” ");
INSERT INTO snc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Benamo Iesu ḡimana iatari ai etore-kaurito, evaḡa-namorito vau eiaḡuirito. ");
INSERT INTO snc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ḡaro tai tau ta Iesu ḡenai eiaḡoto, ekirato, “Vevaḡa-riba tauna, kara dagara namona baveiani vau, maḡuri vanaḡivanaḡi baḡabiani?” ");
INSERT INTO snc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu na evaḡa-veseato, ekirato, “Karase nai au odanaḡiguni, aiḡa tu dagara namona? Sebona moḡo namo, Barau. Bema ourani maḡuri vanaḡi-vanaḡi bono ḡabia nai, Barau ḡena taravatu bono korana-iaḡiri.” ");
INSERT INTO snc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ḡia na Iesu edanaḡiato, ekirato, “Kamara taravatu okiraḡirini?” Iesu ekirato, “Asi bono vaḡivaḡi, asi bono veḡura-vanaḡi, asi bono lema, asi bono vevaḡa-bade ḡofaḡofa, ");
INSERT INTO snc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamamu e sinamu bono gubakauri, e sevimu tarimana maki bono ura-vinia, ḡoi tauḡemu oveura-vinini kavana.” ");
INSERT INTO snc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mai maraḡa variḡuna ekirato, “Au na mani taravatu mabarari akorana-iaḡirini. Kamara dagara tu au na ma bana veia?” ");
INSERT INTO snc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu na ḡia evaḡa-veseato, ekirato, “Bema ḡoi ourani bono iobukaiobuka nai, giniguine tu noiaḡo, ḡemu farefare mabarari bono voivoi-iaḡiri, be moniri tu asi ḡeri-ḡari tarimari bono viniri, benamo gubai tu ma ḡemu farefare. Gabivau murigu ai bonoma raka.” ");
INSERT INTO snc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Maraḡa variḡuna na maiḡa eseḡaḡiato nai, nuḡana ma metona ḡesi eiaḡuiato, korana ḡia tu ma ḡena farefare ḡutuma tarimana. ");
INSERT INTO snc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu na ḡena mero ekirarito, ekirato, “Au na akira-korikorimini: Farefare vovoka tarimari ḡeri rakatoḡa Guba Basileia nuḡanai tu gwaḡiḡi rakava. ");
INSERT INTO snc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma akiramini: Kamela tu nila kadarena na bevanaḡini kotuna gwaḡiḡi, senaḡi ḡena farefare vovoka tarimana Barau ḡena Basileiai ḡena rakatoḡa tu gwaḡiḡi rakava.” ");
INSERT INTO snc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ḡena mero mai guruḡa ḡeseḡaḡiato nai, ḡeḡaba-rakavato moḡo. Benamo ḡevedanaḡito, ḡekirato, “Be deikara na maḡuri vanaḡivanaḡi bedoḡariani?” ");
INSERT INTO snc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Iesu na eḡita-karakararito, benamo evaḡa-veserito, ekirato, “Tarimarima ḡeri ai tu asi ilaila, senaḡi Barau ḡenai dagara mabarari tu ilaila.” ");
INSERT INTO snc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Benamo Petero eguruḡa-fouto, ekirato, “Ḡoi ribamu, ḡai ḡema dagara mabarari tu ḡaraga-kwanerito, benamo ḡoi murimu ai ḡarakani! Be ḡai kara baḡa ḡabini?” ");
INSERT INTO snc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu na ekirarito, ekirato, “Moḡoni akiramini, tanobara variḡuna befoforini nai, Tarimarima Natuna ḡena terona o vere seana kimorekimorenai betanu-kauni, ma ḡomi gabanana ruarua (12) au murigu ai ḡorakani tarimami maki vere seari gabanana ruarua (12) ai boḡo tanukauni, Isaraela ḡena doḡoro gabanana ruarua (12) boḡo ḡita-ḡaurini, ema boḡo ḡori-kaurini. ");
INSERT INTO snc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tarima ta na ḡena numa, kakana, tarina, tobana, tamana ma sinana e natuna, ema ḡena tano, au uragu ai beiaḡuirini nai, ḡia tu sinau-sinau ai dagara bedoḡarini, ema maḡuri vanaḡivanaḡi maki beḡabiani. ");
INSERT INTO snc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Senaḡina tarimarima ḡutuma toma ḡeguineni tu beḡe gabini, ema ḡutuma maki initoma ḡegabini tu beḡe guineni.” ");
INSERT INTO snc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Guba Basileia tu maiḡesi kavana: Vine tavoḡana tarimana ta boḡiboḡi iamoiamo ai numa na eraka-rosito, ḡena vine tavoḡanai beḡene ḡauvei tarimari evetaurito. ");
INSERT INTO snc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Benamo ḡauvei tarimari ḡesi ḡeguruḡa-vegogoto ma ḡevaḡa-moḡoniato, mo ḡauvei tarimari ḡaro sebona ta beḡe ḡauveini voiri silva monina sebona bevinirini ḡetato. Benamo ḡena vine tavoḡana nuḡanai etuḡu-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Boḡiboḡi 9 koloko kavana ḡia ma eraka-rosito, maketi gabuna ḡana eiaḡoto, monai tarima kotari ḡeruḡa-reko rekoto-ḡoi eḡita-rito. ");
INSERT INTO snc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Benamo ekirarito, ekirato, ‘Ḡomi maki ḡegu vine tavoḡana ḡana ḡoiaḡo, ḡoa ḡauvei, be voimi maorona bana vinimi.’ ");
INSERT INTO snc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ḡia maki ḡeiaḡoto. Ḡaroḡota 12 koloko ma 3 koloko kavana ḡia numa na ma eraka-rosito, kotari ma edoḡaririto, etuḡurito. ");
INSERT INTO snc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lavilavi rekenai 5 koloko kavana ma erakarosi-ḡenoḡoito, kotari roḡo mo ḡeruḡa-taḡoto-ḡoi nai edoḡaririto. Benamo edanaḡirito, ekirato, ‘Karase nai mainai ḡoruḡa-kava ruḡa-kavani mo, ḡaro mo evariḡoni?’ ");
INSERT INTO snc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ḡia na ḡevaḡa-veseato, ḡekirato, ‘Korana tarima ta na ḡauvei asi evinimani nai.’ Benamo ekirarito, ‘Ḡomi maki ḡegu vine tavoḡana ḡana ḡoiaḡo, ḡoa ḡauvei.’ ");
INSERT INTO snc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ḡaro eboraiato-ḡoi nai, tavoḡa biaguna na ḡauvei tarimari eḡita-ḡaurito-ḡoi tauna ekiraiato, ekirato, ‘Ḡauvei tarimari nokeari, be voiri noviniri, vau beḡe ḡauvei tarimari bono vini-guine, bene iaḡo mo, bakea-guineri tarimari bono vini-raḡasi. ");
INSERT INTO snc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Benamo mo lavilavi 5 koloko etuḡurito tarimari ḡeiaḡoma-guineto, benamo silva moniri sebori-sebori ḡeḡabito. ");
INSERT INTO snc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ḡeiaḡo-guineto tarimari ḡeiaḡomato nai, ḡia mataboru ḡekirato tu, voiri kotari ma betore-kaurini, senaḡi ḡia maki silva moniri sebori-sebori moḡo ḡeḡabito. ");
INSERT INTO snc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ḡeri moni ḡeḡabito nai, ḡemugu-muguto tavoḡa biaguna ḡenai, ");
INSERT INTO snc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ḡekirato, ‘Mai tarimarima gabivau ḡeiaḡomato maiḡeri tu, hora sebonai moḡo beḡe ḡauvei ma voiri, a ḡai tu ḡaro vinubana ḡavekwaraḡini, ma ḡaro ḡena seḡuka na etunu-rakavamani, nuḡanai voima ḡia ḡeri ḡesi bovini-sebonama.’ ");
INSERT INTO snc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tavoḡa biaguna na ḡia ta ekiraiato, ekirato, ‘Ḡatagu, noseḡaḡi, au na ḡoi asi baḡofamu. Taguruḡa-vegogoto nai, ḡaro sebona voina tu silva monina sebona tatato, nene? ");
INSERT INTO snc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mai moḡo voimu noḡabia, be noraka! Au aurani mai gabi tarimana bana vinia, ḡoi bavinimu ilailanai. ");
INSERT INTO snc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Be, au ma ḡegu maoro, mai ḡegu moni tu ḡegu ura ilailani bana vini. Ba ḡoi obaruni, korana au tu nuḡagu ma iakuna ḡesi avinini nai?’ ");
INSERT INTO snc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesu ḡena guruḡa evaḡa-magoato nai ekirato, “Guine tarimari tu beḡe gabini, ma gabi tarimari tu beḡe guineni.” ");
INSERT INTO snc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu Ierusalema dabarana na evaraḡeto-ḡoi nai, ḡia na ḡena mero gabanana ruarua (12) eḡabi-ḡere-vaḡirito, veḡuni ai evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ḡoseḡaḡi, ḡita tu Ierusalema ḡana tavaraḡeni. Monai Tarimarima Natuna tu Rubu Veaḡa vereri baregori ema taravatu vaḡa-riba-iaḡina tarimari ḡimari ai beḡe toreani. Ḡia na ḡena mase guruḡana beḡe vaḡa-moḡoniani, ");
INSERT INTO snc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","benamo irau bese (o Roma) tarimari beḡe vinirini, ḡia na beḡe vaseva-vaseva iaḡiani, beḡe kwariani e beḡe vaḡa-satauroani; senaḡi ḡaro vaḡa-toitoinai vau ma bevaisiraḡe-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Benamo Sebedaio ḡaraḡona ma natuna ruarua Iakobo (o Iames) ema Ioane ḡesi Iesu ḡenai ḡeiaḡoto, ḡoiranai ea vetui-tarito, dagara ta nenoḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Benamo Iesu na vavine edanaḡiato, ekirato, “Ḡoi kara ourani?” Ḡia evaḡa-veseto, ekirato, “Nokira-varagu, au natugu tauri ruarua iniḡeri, ḡoi ḡesi beḡeneasi tanu, ta aroribamu ai, ma ta kaurimu ai ḡemu Basileia nuḡanai.” ");
INSERT INTO snc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A Iesu na evaḡa-veserito, ekirato, “Ḡomi tu asi ribami kara ḡonoḡiani. Au na midigu bedina baniuani ḡomi maki boḡo niuni riba?” Ḡia ḡevaḡa-veseto, ḡekirato, “Oi, baḡa niuani.” ");
INSERT INTO snc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu na ma ekirarito, ekirato, “Moḡoni, au ḡegu bedi na ḡomi maki boḡo niuni, senaḡi au aroribagu rekenai o kaurigu ai boḡono tanu ḡotoni tu, dia au na bavaḡa-moḡoniani; a mai tu au Tamagu na eḡabi-torerito tarimari ḡeri.” ");
INSERT INTO snc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mero gabanana (10) na maiḡa ḡeseḡaḡiato nai, tarikaka ruarua Iakobo (o Iames) ema Ioane ḡebaru-vinirito. ");
INSERT INTO snc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Benamo Iesu na mabarari ekea-vegogorito, benamo evaḡa-guruḡarito, ekirato, “Ḡomi ribami, irau bese tarimari ḡeri vere na tarimarima ḡedori-naḡinaḡirini, ema ḡeri veguine-iaḡi tarimari baregori na tu ḡeri maoro seḡukari na ḡelaunaḡi-naḡirini. ");
INSERT INTO snc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Senaḡi ḡomi fakami ai moḡesina tu asi boḡono vei. Bema ta ḡomi fakami ai bene barego etoni nai, ḡia tu ḡomi mabarami vetuḡunaḡimi bene iaḡovini, ");
INSERT INTO snc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ema dei bene guine etoni tarimana, ḡia tu ḡemi vetuḡunaḡi tarimanai bene iaḡo. ");
INSERT INTO snc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tarimarima Natuna kavana, ḡia eiaḡomato tu, dia tarimarima na ḡia vetuḡunaḡina beḡene iaḡovini ḡana, senaḡina ḡia eiaḡomato tu, tarimarima vetuḡunaḡiri bene iaḡovini, ema ḡena maḡuri bene tore-taria, tarimarima ḡutuma bene voi-ḡenoḡoiri e bene vaḡa-maḡuriri ḡana.” ");
INSERT INTO snc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu ma ḡena mero ḡesi Ieriko ḡeraga-kwaneato, tarimarima ḡutuma-bara ḡia murina na ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mata-bubu tarimari ruarua dabara rikinai ḡetanu-taḡoto-ḡoi, ḡeseḡaḡito Iesu eraka-vanaḡito, benamo ḡekea-fouto, ḡekirato, “Vereḡauka o, Davida natuna, ḡai novetuḡama!” ");
INSERT INTO snc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tarimarima na ḡekira-ḡoirito, asi beḡene guruḡa ḡetato, senaḡi ḡia ḡekea-ḡiḡiraḡe ḡiḡiraḡeto-ḡoi, “Vereḡauka, Davida Natuna o, ḡai novetuḡama!” ");
INSERT INTO snc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu eruḡa-tarito, benamo ekea-iaḡomarito, ekirato, “Kara ḡemi naveia ḡotoni?” ");
INSERT INTO snc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ḡia na ḡekiraiato, ḡekirato, “Vereḡauka, ḡai ḡaurani tu, matama noma keo-fakari!” ");
INSERT INTO snc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Benamo Iesu na evetuḡa-ḡwarito, matari eḡabi-kararito, ma asikauna matari ḡenamoto e ḡeboḡeboḡe-ginikauto, benamo Iesu murina na ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu ma ḡena mero ḡesi ḡeraka-iaḡoto-ḡoi, Ierusalema ḡekavinaḡiato-ḡoi, ma Betefage ai ḡeraḡasito Olive Ḡorona rekenai, benamo Iesu na ḡena mero ruarua etuḡu-guinerito, ");
INSERT INTO snc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ekirarito, ekirato, “Ḡoiaḡo, ḡoira vanuḡana ḡana. Monai doniki ta barutari ma natuna ḡesi boḡo doḡaririni, boḡono ruḡari, benamo au ḡegu ai boḡono ḡori-iaḡomari. ");
INSERT INTO snc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bema tarima ta na bedanaḡimini nai, boḡono kiraia, ‘Vereḡauka na eura-vinirini, vau ma betuḡu-iaḡomarini, asi bekwaiboni.’” ");
INSERT INTO snc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Maiḡa eḡorato ḡenana, peroveta tauna ḡena guruḡatore guruḡana evaḡa-moḡoniani, ekirani, ");
INSERT INTO snc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siona natuna, (Ierusalema tarimari), nokirari, ‘Noḡitaia, ḡemu Vere mani eiaḡomani, manau tarimana, doniki tuḡunai eraḡeni, mai tu doniki natuna doḡenai betanukau.’” ");
INSERT INTO snc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mai mero ruarua ḡeiaḡoto, Iesu na ekirarito veiḡana ilailanai ḡeveiato. ");
INSERT INTO snc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ḡia na doniki ma natuna ḡesi Iesu ḡenai ḡeḡori-iaḡorito, ḡeri dabuḡa barari doniki doḡeri ai ḡeiava-kaurito, benamo Iesu etanu-kauto. ");
INSERT INTO snc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tarimarima ḡutuma-bara ḡeri dabuḡa barari dabarai ḡeiavarito, kotari tu ḡau legari ma lauri ḡesi ḡebasito, benamo dabarai ḡeiavato. ");
INSERT INTO snc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tarimarima ḡutuma-bara ḡia ḡoiranai ḡerakato e murinai ḡerakato, maiḡesina ḡevone-raḡeto-ḡoi, ḡekirato, “Hosana, Davida natuna ḡena! Vereḡauka aranai eiaḡomani tarimana sivaḡa-namoa! Hosana guba tuḡuna vanigerenai!” ");
INSERT INTO snc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Ierusalemai eraka-toḡato nai, vanuḡa tarimarimari mabarari ḡeveraga veragato-ḡoi ema ḡevedanaḡi-vedanaḡito-ḡoi, ḡekirato, “Mai tu deikara?” ");
INSERT INTO snc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iesu ḡesi ḡeraka-sebonato tarimari ḡevaḡa-veseto, ḡekirato, “Mai tu Iesu, peroveta tauna, Galilea vanuḡana Nasareta na eiaḡomani.” ");
INSERT INTO snc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu Rubu Veaḡa nuḡanai eraka-toḡato, benamo voivoi tarimari mabarari elai-rosirito. Moni ḡesenisito-ḡoi tarimari ḡeri fata e pune ḡevoivoi iaḡirito-ḡoi tarimari ḡeri diḡoka eḡuke-vebuburito, ");
INSERT INTO snc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ema ekirarito, ekirato, “Buka Veaḡa nuḡanai tu maiḡesi etoreato, Barau ekirato, ‘Au ḡegu numa tu bese irauirau ḡeri ḡuriḡuri numanai beḡe kiraḡiani,’ senaḡi ḡomi na tu lema tarimari ḡeri gumu gabunai boḡo vaḡa-iaḡoa.” ");
INSERT INTO snc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mata-bubu e kwaku rakava tarimari Iesu ḡenai ḡeiaḡomato Rubu Veaḡa nuḡanai, benamo ḡia na evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na ḡena nuḡa-farevaḡi veiḡari ḡeḡitarito, ema mero misiri garori ḡeseḡaḡirito, Rubu Veaḡa nuḡanai ḡevone-raḡeto-ḡoi, ḡekirato, “Hosana, Davida natuna ḡena,” benamo ḡia tu ḡebaru-rakavato, ");
INSERT INTO snc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","benamo Iesu ḡedanaḡiato, ḡekirato, “Ḡia na ini kara ḡekiraḡirini ne oseḡaḡirini ba?” Iesu na evaḡa-veserito, ekirato, “Oi aseḡaḡini, senaḡi ḡomi na Buka Veaḡa nuḡanai asi ḡoiaviani, ‘Mero misiri ema sinari ratari roḡo ḡeniurini merori na maki ḡoi ḡevaḡa-raḡemuni!’?” ");
INSERT INTO snc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Benamo Iesu na eraga-kwanerito, vanuḡa barana na eraka-rosito, Betania ḡana eiaḡoto, monai ea genato. ");
INSERT INTO snc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Boḡiboḡi, Iesu vanuḡa barana ḡana ma eḡenoḡoito, eraka-iaḡoto-ḡoi nuḡanai, ḡia evitoato. ");
INSERT INTO snc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ḡia na figi ḡauna ta dabara rikinai eḡitaiato, benamo eiaḡo-viniato, senaḡi asi ḡwaḡwana, a launa korina moḡo. Benamo Iesu na figi ḡauna ekiraiato, ekirato, “Ḡoi ḡemuna ḡwaḡwamu asi ma befofori-ḡenoḡoini!” Asikauna moḡo figi ḡauna emarai-ḡosito. ");
INSERT INTO snc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ḡena mero na figi ḡauna emarai-ḡosito ḡeḡitaiato nai, ḡeḡaba-rakavato, ḡekirato, “Figi ḡauna tu kamasi se beraga-mase moḡo?” ");
INSERT INTO snc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu evaḡa-veseto, ekirato, “Moḡoni akiramini, bema ḡomi boḡo veḡabidadamani, ma asi boḡo daradarani nai, ḡomi na maki mai figi ḡauna ḡenai baveia kavana boḡo veiani riba; a dia moḡa moḡo, senaḡi mai ḡoro boḡo kiraiani, ‘Noveḡabivaisi, be davarai noa vefiu-rei,’ benamo mo veiḡa tu beḡorani. ");
INSERT INTO snc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dagara mabarari ḡauḡau ai boḡo kiraḡirini ma veḡabidadamami ḡesi nai tu, boḡo doḡaririni.” ");
INSERT INTO snc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu Rubu Veaḡa nuḡanai eraka-toḡato, evevaḡa-ribato-ḡoi nai, Rubu Veaḡa vereri baregori ema Iuda vereri ḡia ḡenai ḡeiaḡomato, benamo ḡedanaḡiato, ḡekirato, “Kamara seḡukai ḡoi na mai veiḡa oveirini? Dei na maoro evinimuto?” ");
INSERT INTO snc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu na evaḡa-veserito, ekirato, “Au na maki vedanaḡi sebona avinimini; bema boḡo vaḡa-veseani nai, au na kamara maoro ai mai veiḡa aveirini bakira-varamini. ");
INSERT INTO snc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane ḡena babatiso veiḡana tu ainana eiaḡomato? Guba na eiaḡomato, ba tarimarima ḡerina?” Ḡia fakari ai ḡeverorito, ḡekirato, “Bema ḡita bita kirani, ‘Barau ḡenana’ bita toni nai, ḡia bekirani ‘Karase nai Ioane asi ḡovaḡa-moḡoniato?’ betoni. ");
INSERT INTO snc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Senaḡi bema ḡita bita kirani, ‘Tarimarima ḡerina’ bita toni nai, tarimarima gariri bitana vei, korana ḡia ribari, Ioane tu peroveta tarimana korikori.” ");
INSERT INTO snc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Moḡa lorinai ḡia na Iesu ḡevaḡa-veseato, ḡekirato, “Ḡai asi ribama.” Benamo Iesu na ḡia ekirarito, “Au na maki kamara maoro ai mai veiḡa aveirini tu, asi bakira-varamini.” ");
INSERT INTO snc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mai barabore tu kamasi ḡotuḡa-maḡiani? Tarima ta ma natuna ruarua. Tau-guinena ḡenai eiaḡoto, ekiraiato, ekirato, ‘Natugu, toma noiaḡo, vine tavoḡanai noa ḡauvei!’ ");
INSERT INTO snc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Natuna na evaḡa-veseato, ekirato, ‘Asi aurani,’ senaḡina gabivau evetuḡa-maḡi-kureto, benamo eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ḡia ma eiaḡoto natuna vaḡa-ruaruana ḡenai, tau-guinena evaḡa-guruḡaiato ilailanai ekiraiato. Mero evaḡa-veseto, ekirato, ‘Aiaḡoni,’ senaḡi asi eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ḡia tauri ruarua vekaravari ai dei na tu tamari ḡena ura eveiato?” Ḡia ḡevaḡa-veseto, ḡekirato, “Tau-guinena.” Iesu na ekirarito, “Moḡoni veḡata akiramini, takesi gogo tarimari e mata-boraḡa vavineri na ḡeguine-iaḡimini Barau ḡena Basileia rakatoḡanai. ");
INSERT INTO snc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ioane Babatiso ḡomi ḡemi ai eiaḡomato tu, vei-iobukaiobuka dabarana ḡemi ai evaḡa-foforiato, senaḡi asi ḡoseḡaḡi-viniato. A takesi gogo tarimari e mata-boraḡa vavineri na ḡevaḡa-moḡoniato. Ḡomi na maki ḡoḡitarito, senaḡi asi ḡovetuḡamaḡi-kureto, asi ḡovaḡa-moḡoniato.” ");
INSERT INTO snc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesu ekirato, “Barabore ta ma ḡoseḡaḡia: Tano biaguna ta na vine tavoḡana evaroato, maḡuna eḡabiato, tano ai vine gigi-gigina gurina ekwaiato, tavoḡa narinarina numana maki evaḡa-ruḡaiato. Moḡa murinai tavoḡa ḡitaḡauna tarimari ḡeri ai ḡena tavoḡa eraga-kwaneato, benamo erakato gabu ta ḡana. ");
INSERT INTO snc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vine ḡwari (o grapes) ḡemaḡeto, benamo ḡia na ḡena vetuḡunaḡi tauri etuḡurito tavoḡa narinarina tarimari ḡeri ai, ḡena vine ḡwaḡwari kota beḡenea ḡabi ḡana. ");
INSERT INTO snc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Senaḡi tavoḡa ḡitaḡauna tarimari na vetuḡunaḡi tauri ḡeḡabi-taririto, benamo ta ḡekwariato, ma ta ḡevaḡiato, ema ta fore na ḡetakiato. ");
INSERT INTO snc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tavoḡa biaguna na ḡena vetuḡunaḡi tauri vovoka kotari ma etuḡurito, senaḡi moḡesina ma ḡevei-vinirito. ");
INSERT INTO snc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dokonai ḡia na natuna korikori ḡeri ai etuḡu-iaḡoato, ekirato, ‘Natugu na-tuḡua, ḡia na beḡene gubakaua.’ ");
INSERT INTO snc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Senaḡi tavoḡa ḡitaḡauna tarimari natuna ḡeḡitaiato nai, tauḡeri ḡeveguruḡa-vevinito, ḡekirato, ‘Mani tu tavoḡa beḡaunaiani merona, be siḡabia, sivaḡi-masea, be ḡena tavoḡa bitana ḡaunaia!’ ");
INSERT INTO snc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Benamo ḡeḡabi-tariato, vine tavoḡana murikanai ḡeinu-iaḡoato, ḡevaḡi-maseato.” ");
INSERT INTO snc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iesu evedanaḡito, ekirato, “Tavoḡa biaguna beiaḡomani nai, mo tavoḡa ḡitaḡauna tarimari kamasi beveirini?” ");
INSERT INTO snc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ḡia ḡevaḡa-veseto, ḡekirato, “Mo veiḡa rakava tarimari ḡia na bevaḡirini veḡata, ma vine tavoḡana tu narinarina tarima boruri tari ma bevinirini, benamo ḡeri ḡwaḡwa negari ai, ḡwaḡwari ḡia ḡenai beḡene ḡwa-iaḡori.” ");
INSERT INTO snc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu na ma ekirarito, ekirato, “Ḡomi na mai toretore Buka Veaḡai asi ḡoiaviani, iniḡesi ekirani, ‘Fore numari ḡeragarini tarimari na asi ḡeura-viniato ma ḡefitoḡaiato forena tu duḡu forenai eiaḡoto. Mai veiḡa maiḡa tu Vereḡauka na eveiato, matara na taḡitaiani, ḡitaḡitana irau veḡata.’ ");
INSERT INTO snc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Moḡesi naima akiramini, Barau ḡena Basileia tu ḡemina beḡabi-vaḡiani, ema ḡwaḡwa evaḡa-ḡorani besena beviniani. ");
INSERT INTO snc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44"," Deikara mo fore iatanai beketokauni tarimana tu, beḡwa-kirakiraiani; ema mai fore tarima ta iatanai beketokauni nai, bevare-fatafataiani.” ");
INSERT INTO snc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rubu Veaḡa vereri baregori e Farisea tarimari na Iesu ḡena barabore ḡeseḡaḡirito nai, ḡeribato, Iesu na tu ḡia ekiraḡirini, ");
INSERT INTO snc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","naima ḡia ḡeri ura tu beḡene ḡabi-taria. Senaḡi tarimarima ḡutuma ḡevegogo taḡoto-ḡoi gariri ḡeveito, korana ḡia na ḡetuḡamaḡiato-ḡoi, Iesu tu peroveta tauna ta. ");
INSERT INTO snc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu na Iuda vereri ḡeri barabore ta ma ekiraḡiato: ");
INSERT INTO snc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Guba Basileia tu noḡa moḡo vere ta, natuna ḡena veḡaraḡo verekona evei-toreato kavana. ");
INSERT INTO snc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Benamo ḡena vetuḡunaḡi tarimari etuḡurito, ekea-kaurito tarimari keakeari, senaḡi asi ḡeurato nai, asi ḡeiaḡomato. ");
INSERT INTO snc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Moḡa lorinai ḡia na vetuḡunaḡi tarimari tari ma etuḡurito, ekirarito, ‘Akea-kaurito tarimari ḡoa kirari, “Au ḡegu vereko tu badabara-ḡosia, ḡegu boromakau tauri ema boromakau naturi mona mase tu bavaḡiri, dagara mabarari bavei-toreri, be ḡoiaḡoma vereko ḡana.” ’ ");
INSERT INTO snc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Senaḡi ḡia tu ḡeḡoiaḡito, ḡeri ura ḡauveiri moḡo ḡeveito. Ta vamoka ḡana eiaḡoto, ma ta tu ḡena sitoa ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","O tari tu vetuḡunaḡi tarimari ḡeḡabi-taririto, ḡekwaririto, ema ḡevaḡi-maserito. ");
INSERT INTO snc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Vere tu ebaru-rakavato, ḡena vetari doḡorori etuḡurito, mo vaḡivaḡi tarimari ḡevaḡi-maserito, ma ḡeri vanuḡa barana ḡegabu-kauato. ");
INSERT INTO snc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Benamo ḡia na ḡena vetuḡunaḡi tarimari evaḡa-guruḡarito, ekirato, ‘Au ḡegu veḡaraḡo verekona tu bavei-torea, senaḡi au na akea-kaurito tarimari tu asi ilaila beḡe iaḡomani. ");
INSERT INTO snc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Moḡa lorinai mai moḡo ḡoiaḡo, ḡatama baregori rakaḡutu dabarari ai boḡo doḡaririni tarimari mabarari boḡono kirari, beḡene iaḡoma vereko ḡana.’ ");
INSERT INTO snc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Benamo vetuḡunaḡi tarimari ḡeiaḡoto, ḡatamai ema dabarai ḡedoḡaririto tarimari mabarari, namori, rakavari, ḡegogo-iaḡorito, veḡaraḡo numana maki ḡevaḡa-vonuato. ");
INSERT INTO snc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Benamo vere eraka-toḡato, ḡeiaḡomato tarimari ḡitaḡitari nuḡanai, ḡia na tarima ta monai eḡitaiato, asi ḡena veḡaraḡo dabuḡana. ");
INSERT INTO snc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Benamo edanaḡiato, ekirato, ‘Ḡata, ḡoi tu ainana boraka-toḡa, asi ḡemu veḡaraḡo dabuḡana?’ Senaḡi mo tarima asi eguruḡato. ");
INSERT INTO snc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Benamo vere na ḡena vetuḡunaḡi tarimari evaḡa-guruḡarito, ekirato, ‘Ḡimana ema kwakuna ḡobarubaruri, benamo ḡofiu-rosia murika mukunanai. Monai bene taḡi, gadikana maki bene vaḡa-ḡaratariri.’ ");
INSERT INTO snc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Korana tarima ḡutuma Barau na ekearito, senaḡi viravira moḡo eḡabi-torerito maḡuri beḡe ḡabiani.” ");
INSERT INTO snc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisea tarimari ḡeraka-veḡitato, ḡeboioḡa-vegogoto, Iesu beḡene vaḡa-vedaḡa-raḡea vedanaḡiri ḡea veito. ");
INSERT INTO snc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Benamo ḡia na ḡeri mero tari ema Heroda murinai ḡerakato-ḡoi tarimari tari ḡetuḡu-iaḡorito, ḡekirato, “Vevaḡa-riba tarimamu, ḡai ribama ḡoi tu moḡoni vei-iobukaiobuka tarimamu. Ḡoi na moḡoni ai Barau ḡena dabara ovevaḡa-riba iaḡi-ḡitakauani. Tarimarima gariri asi oveini, tarima ḡeri dagi maki asi otuḡamaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Moḡa lorinai nokira-varama, kamasi otuḡa-maḡini: Kaisara, Roma ḡeri vere, ḡenai takesi baḡana vini ba asiḡi?” ");
INSERT INTO snc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Senaḡi Iesu ma ribana ḡeri boioḡa rakavari nai, ekirarito, “Ḡomi ḡofaḡofa tarimami! Karase nai au ḡoribaḡaniguni? ");
INSERT INTO snc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takesi monina ta ḡovinigu, nama ḡitaia!” Benamo silva monina ta ḡeviniato. ");
INSERT INTO snc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Benamo ḡia na edanaḡirito, ekirato, “Mai tu dei laulauna ema dei arana?” ");
INSERT INTO snc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ḡia ḡevaḡa-veseto, “Kaisara ḡena.” Iesu na evaḡa-guruḡarito, ekirato, “Be, Kaisara ḡena dagara Kaisara boḡono vinia, Barau ḡena dagara Barau boḡono vinia.” ");
INSERT INTO snc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mo guruḡa ḡeseḡaḡiato nai, ḡeḡaba-rakavato, benamo ḡeraga-kwaneato, ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mo ḡaro sebonai Sadukea tarimari kota Iesu ḡenai ḡeiaḡoto. Ḡia ḡeri tuḡamaḡi tu mase tarimari asi ma beḡe variḡisi-ḡenoḡoini. Benamo Iesu ḡedanaḡiato, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Vevaḡa-riba tarimamu, Mose maiḡesi ekirato, ‘Bema tau ta asi natuna bemaseni nai, ivana vabuna kakana o tarina ta na bene ḡaraḡoa, naturi beḡene maḡuri mase tauna ḡena.’ ");
INSERT INTO snc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mero mabarari tu imaima ruarua (7) mainai ḡetanuto-ḡoi. Mero guinena na eḡaraḡoato, ma emaseto asi natuna, benamo tarina na ma eḡaraḡoato. ");
INSERT INTO snc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mo veiḡa sebona tarina vaḡa-ruaruana ḡenai eḡorato, mero vaḡa-toitoina maki moḡesina moḡo mo vaḡa-imaima ruaruana (7). ");
INSERT INTO snc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dokonai mo vavine maki emaseto. ");
INSERT INTO snc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Variḡisi-ḡenoḡoi ḡaronai mo vavine tu dei ḡaraḡona? Korana ḡia tu tauri 7 na ḡeḡaraḡoato.” ");
INSERT INTO snc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu na evaḡa-veserito, ekirato, “Ḡomi tu ḡokerereni, korana Buka Veaḡa anina ema Barau ḡena seḡuka asi ribami. ");
INSERT INTO snc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mase na ma beḡe variḡisi-ḡenoḡoini tarimari tu asi ma beḡe veḡaraḡoni. Ḡia tu aneru kavana gubai. ");
INSERT INTO snc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A mase na ma beḡe variḡisi-ḡenoḡoini guruḡari Barau ḡena bukai asi ḡoiaviani? Ḡia ekirato, ");
INSERT INTO snc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au tu Aberahamo ḡena Barau, Isako ḡena Barau, ema Iakobo ḡena Barau.’ Ḡia tu maḡuri tarimari ḡeri Barau, dia mase tarimari ḡeri Barau!” ");
INSERT INTO snc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tarimarima ḡutuma na mo guruḡa ḡeseḡaḡiato nai, nuḡari ḡefarevaḡito ḡena vevaḡa-riba guruḡari na. ");
INSERT INTO snc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisea tarimari ḡeseḡaḡito, Iesu na Sadukea tarimari ḡeri guruḡa ekou-ḡaurito, benamo ḡeraka-vegogoto. ");
INSERT INTO snc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ḡia fakari ai ta tu taravatu vaḡa-riba-iaḡina tarimana. Ḡia na Iesu edanaḡi-veribaḡaniato, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vevaḡa-riba tarimamu, taravatu nuḡanai kamara taravatu tu barego vedaurea?” ");
INSERT INTO snc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu na evaḡa-veseato, ekirato, “‘Vereḡauka ḡoi ḡemu Barau bono ura-vinia ma nuḡamu mabarana, ma iaukamu mabarana, ma ḡemu tuḡamaḡi mabarana ḡesi.’ ");
INSERT INTO snc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Maiḡa tu taravatu giniguinena ema barego vedaureana. ");
INSERT INTO snc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Taravatu barego vedaureari vaḡa-ruaruana ḡia ilailana tu maiḡa: ‘Sevimu tarimana bono ura-vinia, ḡoi tauḡemu oveura-vinini kavana!’ ");
INSERT INTO snc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Maiḡeri taravatu ruarua na taravatu mabarari ema peroveta tarimari ḡeri guruḡa mabarari eḡabi-vegogorini.” ");
INSERT INTO snc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisea tarimari ḡevegogoto-ḡoi nai, Iesu na edanaḡirito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ḡomi na Keriso tu aiḡesi ḡotuḡa-maḡiani? Ḡia tu deikara natuna ḡotoni?” Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡia tu Davida natuna.” ");
INSERT INTO snc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesu na ma edanaḡirito, ekirato, “Davida tu kamasi nai Keriso tu ‘Vereḡauka’ etoni? Korana Davida Iauka Veaḡa na tuḡamaḡi-faka e riba eviniato, benamo ekirato, ");
INSERT INTO snc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Barau na au ḡegu Vereḡauka ekiraiato: Au ḡimagu aroribana rekenai noma tanu, bene iaḡo mo, ḡoi ḡebaru-vinimuni tarimari ḡoi kwakumu gaburenai batorerini.’ ");
INSERT INTO snc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bema Davida na Keriso tu ‘Vereḡaukana’ ekiraḡito, kamasi nai Keriso tu Davida natuna?” ");
INSERT INTO snc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ḡia mabarari ta na maki asi evaḡa-veseato, ema mo nega na eiaḡoto mo, tarima ta na maki asi ma edanaḡiato, korana ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesu na tarimarima ḡutuma-bara e ḡena mero evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Taravatu vaḡa-riba-iaḡina tarimari e Farisea tarimari na Mose ḡena taravatu ḡevevaḡa-riba iaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Moḡa lorinai ḡomi ḡevaḡa-ribamini guruḡari mabarari boḡono korana-iaḡiri e boḡono veiri. A ḡeri veiḡa asi boḡono tovotovori, korana kara ḡeḡobata-iaḡirini, tarimarima na beḡene veiri veiḡari tu, tauḡeri na asi ḡekorana-iaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ḡia na maruna metori tarimarima ḡevaḡa-faḡarini, senaḡina ḡimari didiri na ta maki ḡeri marunai asi ḡeveḡabikauni, asi ḡevaḡa-kavarini, maruna beḡene ḡwari ḡana. ");
INSERT INTO snc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ḡeri veiḡa mabarari ḡeveirini tu, tarimarima na beḡene ḡitari ḡana. Ḡia bakuri e ḡimari ai tu dagara veaḡari ḡebarubarurini, nuḡari ai Buka Veaḡa siriri ḡeḡurarini, moḡeri dagara ḡevaḡa-baregorini, ema ḡeri dabuḡa geveri maki ḡevaḡa-maukarini. ");
INSERT INTO snc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ḡanivegogo gaburi ai e rubu nuḡari ai ḡeri ura tanutanu namori ai beḡene tanu. ");
INSERT INTO snc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ḡia ḡeurani maketi gaburi ai beḡene rakaorakao, tarimarima na beḡene vaḡa-namori urari ai, ema tarimarima na ‘Vevaḡa-riba Tarimari’ beḡene kiraḡiri. ");
INSERT INTO snc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","A ḡomi tu ‘Vevaḡa-riba Tarimami’ ai asi beḡene kiraḡimi, korana Barau ḡereḡana moḡo ḡemi Vevaḡa-riba Tauna, ema ḡomi mabarami tu tarikaka. ");
INSERT INTO snc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ema tanobarai tarima ta ‘Tama’ asi boḡono kiraḡia, korana ḡomi Tamami tu sebona moḡo, ḡia tu gubai etanuni. ");
INSERT INTO snc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ḡomi maki ‘Veḡori-kau Tarimami’ asi beḡene kiraḡimi, korana ḡemi Veḡorikau Tauna tu sebona moḡo, Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Deikara barego vedaurea ḡomi fakami ai, ḡia tu ḡomi vetuḡunaḡimi beiaḡo-vinini. ");
INSERT INTO snc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tauḡena eveḡabi-vaisini tarimana tu Barau na bevaḡa-manauani, a tauḡena evevaḡa-manauni tarimana tu beḡabi-vaisiani.” ");
INSERT INTO snc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡami kika! Korana Guba Basileia ḡatama bokana tu tarimarima ḡoirari ai ḡokou-ḡauani. Ḡomi tauḡemi asi boḡo raka-toḡani, ema ḡeraka-toḡa ḡetoni tarimari ḡeri dabara maki ḡomi na ḡokourini. ");
INSERT INTO snc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14"," Taravatu ḡovevaḡa-riba iaḡiani tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡami kika! Ḡomi na vabu ḡeri numa e ḡeri farefare ḡovaḡa-koririni. Ḡemi ḡauḡau tu mauka kenene, ḡoḡofaḡofani. Moḡesi nai ḡomi tu meto barego vedaurea boḡo ḡabiani. ");
INSERT INTO snc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofa-ḡofa tarimami! Ḡomi gabu mabarari ḡana ḡoiaḡoni, davarai e tanobarai, tarima sebona kwariḡutu ḡemi doḡoro ai bene raka-toḡa uranai. Ḡoḡabiani, benamo karava eḡara-vanaḡi vanaḡini gabuna natunai ḡovaḡa-iaḡoani, ḡemi kira-sirivaḡi e seḡafore maki bevanaḡi-lelevaḡirini. ");
INSERT INTO snc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Veḡorikau taumi, matami bubuḡau, vetuḡami kika! Ḡemi vevaḡa-ribai ḡokirani, Rubu Veaḡa aranai bekiraḡi-toreni tarimana ḡena kiraḡitore tu asi anina ḡotoni, a Rubu Veaḡa golona (o gold-na) aranai bekiraḡi-toreni tauna tu, ḡena kiraḡitore roḡo bekorana-iaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Babo e mata-bubu tarimami! Aiḡa tu barego, golo ba golo evaḡa-veaḡaiani Rubu Veaḡana? ");
INSERT INTO snc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma ḡokirani, fata veaḡana aranai bekiraḡi-toreni tarimana ḡena kiraḡitore tu asi anina, a varevare dagarana fata veaḡana iatanai ḡetoreato dagarana aranai bekiraḡi-toreni tarimana tu ḡena kiraḡitore roḡo bekorana-iaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mata-bubu taumi. Aiḡa tu barego, varevare dagarana ba varevare dagarana evaḡa-veaḡaiani fata veaḡana? ");
INSERT INTO snc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Moḡa lorinai fata veaḡa aranai ekiraḡi-toreni tarimana na fata veaḡa e fata veaḡa iatanai ḡetorerito dagarari mabarari arari ai ekiraḡi-toreni. ");
INSERT INTO snc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ema Rubu Veaḡa aranai ekiraḡi-toreni tarimana na Rubu Veaḡa ema nuḡanai etanuni Barauna arari ai ekiraḡi-toreni. ");
INSERT INTO snc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ema guba aranai ekiraḡi-toreni tarimana na Barau ḡena terona e iatanai etanuni Barauna arari ai ekiraḡi-toreni. ");
INSERT INTO snc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡami kika! Korana ḡomi na Barau ḡovarevare-viniani dagarari, ḡemi ḡaniḡani ḡailauri misimisiri maki, karava gabanana (10) ḡoveirini, karava sebona boubou dagaranai ḡovaḡa-iaḡoani, senaḡina taravatu ḡena dagara baregori, vei-iobukaiobuka, vevetuḡaḡwa ema vetuḡamaḡikau tu ḡolearini. Ḡomi na tu maiḡeri veiḡa baregori ḡoro veiri ema mo veiḡa keiri maki asi boḡoro iaḡuiri. ");
INSERT INTO snc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Veḡorikau tarimami, matami bubu! Ḡami nanu na nagama ḡovei-vaḡiani, senaḡina kamela tu ḡolauboḡerini. ");
INSERT INTO snc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡamai kika! Ḡomi ḡemi kapusi e mereki muriri moḡo ḡoḡuriḡirini, senaḡi nuḡari tu lema e mata-ḡaniḡani ḡoveini dagarari na beḡe vonuvonu-raḡe. ");
INSERT INTO snc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisea tarimami, matami bubu! Kapusi e mereki nuḡari ai ḡotorerini dagarari boḡono iareva-guineri, benamo murina rekena maki bene veiareva. ");
INSERT INTO snc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡami kika! Ḡomi tu gara gaburi ḡefeni-kuro-kurorito kavana, murikari ḡitaḡitari tu namo vedaurea, senaḡina nuḡari tu mase tarimari turiḡari ema miro mabarari na ḡevonuto. ");
INSERT INTO snc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ḡomi maki moḡesina, tarimarima na ḡeḡitamini veiḡa iobukaiobuka tarimari noḡa, senaḡina nuḡami tu ḡofaḡofa e vei-rakava na ḡevonuvonu-raḡeto.” ");
INSERT INTO snc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Taravatu vaḡa-riba-iaḡina tarimami e Farisea tarimami, ḡofaḡofa tarimami, vetuḡami kika! Ḡomi na peroveta tarimari ḡeri gara gaburi ḡovei-ginikaurini, tuḡamaḡi-iaḡina foreri ḡovaḡa-ruḡarini, ema vei-iobukaiobuka tarimari ḡeri gara gaburi ḡovaḡa-vera verarini. ");
INSERT INTO snc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ḡokirani, ‘Tubuma ḡatama ḡeri negai ḡara maḡuri nai, peroveta tarimari vaḡivaḡiri ai asi ḡara vaḡa-kavari.’ ");
INSERT INTO snc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Moḡesi ḡokirani nai, tauḡemi ḡovekiraḡini, ḡomi tu peroveta ḡevaḡirito tarimari naturi. ");
INSERT INTO snc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Oba, ḡomi maki tubumi ḡatami ḡeveito-ḡoi kavana ma ḡovei-iaḡoni, ḡeri rakava ḡomi na ḡovaḡa-ḡuḡururini. ");
INSERT INTO snc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ḡomi mota! Mota naturi! Barau ḡena Kota baregona ḡarona beraḡasini nai, karava eḡara-vanaḡi vanaḡini gabuna na kamasi boḡo raga-maḡurini? ");
INSERT INTO snc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Moḡa lorinai akiramini, au na peroveta tarimari e iaunega tarimari ema vevaḡa-riba tarimari batuḡu-iaḡorini. Benamo kota tu boḡo vaḡi-maserini, aba, boḡo vaḡa-sataurorini; ma kotari tu rubu nuḡari ai boḡo kwaririni, rarari maki beḡe riḡoni, ema vanuḡa ta na boḡo lairini ma vanuḡa ta. ");
INSERT INTO snc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Moḡesina nai vei-iobukaiobuka tarimari ḡevaḡirito metori tu ḡomi iatami ai, Abela ḡevaḡi-maseato, monana eiaḡomato mo Sakaria, Barakia natuna, ḡia tu fata veaḡana ema numa veaḡana fakari ai ḡovaḡi-maseato. ");
INSERT INTO snc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Akira-korikorimini, mabarari metori tu toma ḡuru tarimami iatami ai beḡe ketokauni.” ");
INSERT INTO snc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalema, Ierusalema o, ḡoi na peroveta tarimari ovaḡirini ema Barau na etuḡu-iaḡosirini tarimari fore na otaki-maserini. Nega ḡutuma aurato, natumi bana gana-ḡeḡeraḡiri, kokoroku vavinena na natuna egoru-taririni kavana, senaḡi ḡomi tu asi ḡourato! ");
INSERT INTO snc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Moḡa lorinai ḡemi vanuḡa ema Rubu Veaḡa tu korina betanuni. ");
INSERT INTO snc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Korana au na akiramini, ḡomi roḡo au asi boḡo ḡitaguni, beiaḡoni mo, ḡaro ta beraḡasini, monai vau boḡo kirani, ‘Barau aranai eiaḡomani tauna sivaḡa-namoa.’” ");
INSERT INTO snc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu Rubu Veaḡa na eraka-rosito, eraka-veḡitato nuḡanai, ḡena mero ḡia ḡenai ḡeiaḡoto, ḡeri ura Rubu Veaḡa numari baregori beḡene vaḡa-ḡitaia. ");
INSERT INTO snc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Senaḡi Iesu na evaḡa-guruḡarito, ekirato, “Mai dagara mabarari ḡoḡitarini? Au na moḡoni akiramini: Mai fore ta fore ta iatanai asi beḡe tanuni, mabarari beḡe vare-bubu riḡorini.” ");
INSERT INTO snc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu Olive Ḡoronai etanu-taḡoto-ḡoi, benamo ḡena mero ḡia ḡenai ḡeiaḡoto, ḡedanaḡi-ḡairiato, ḡekirato, “Nokira-varama, mai dagara tu aitoma beḡe ḡorani? E ḡoi boḡenoḡoi-iaḡomani ema tanobara dokona beḡabiani maki kamara vetoḡa na bevaḡa-foforiani?” ");
INSERT INTO snc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu evaḡa-veseto, ekirato, “Ḡomi lorimi boḡono vetore, tarima ta na asi bene ḡofami. ");
INSERT INTO snc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Korana tarima ḡutuma au aragu ai beḡe iaḡomani, beḡe kirani, ‘Keriso tu au maiḡegu!’ Tarima vovoka beḡe ḡofarini. ");
INSERT INTO snc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ḡomi na vetari gururi e tuari variri boḡo seḡaḡirini nai, nuḡami asi beḡene raḡe. Maniḡeri dagara tu beḡe ḡorani, senaḡi dokona tu asi roḡo. ");
INSERT INTO snc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tanobara ta tanobara ta ḡesi beḡe vevaḡini, gavamani ta gavamani ta ḡesi beḡe vetarini. Gabu ḡutuma nuḡari ai doḡe beḡe ḡorani, tano maki beḡe iagani. ");
INSERT INTO snc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mai tu midigu moḡo besinaiani, noḡa moḡo mero keina emaḡurini midiguna kavana. ");
INSERT INTO snc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mo negai beḡe ḡabi-tarimini, beḡe vaḡa-midigu midigumini, beḡe vaḡi-masemini. Bese mabarari na beḡe baru-vinimini, korana au ḡovaḡa-moḡoniguni dainai. ");
INSERT INTO snc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Benamo tarima ḡutuma ḡeri veḡabidadama beḡe raga-kwanerini, tata beḡe verevani e beḡe vebaru-vevinini. ");
INSERT INTO snc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peroveta ḡofaḡofa tarimari beḡe variḡisini, tarima ḡutuma beḡe ḡofarini. ");
INSERT INTO snc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Vei-rakava maki beḡora-rovorovoni, benamo ḡutuma ḡeri veuravini maki beḡe farakani. ");
INSERT INTO snc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Senaḡina deikara bevevaḡa-gwaḡiḡini mo magona tu bemaḡurini. ");
INSERT INTO snc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Barau ḡena Basileia Varina Namona tu tanobara mabaranai beḡe ḡobata-iaḡiani, bese mabarari na beḡene seḡaḡia ḡana, moḡa murinai vau magona beraḡasini.” ");
INSERT INTO snc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ḡomi na dagara rakava vedaureana, vevaḡa-gari dagarana, peroveta tarimana Daniela na ekiraḡiato dagarana, boḡo ḡitaiani gabu veaḡanai beruḡani.” Mai guruḡa beiaviani tarimana bene riba maoro anina tu kara. ");
INSERT INTO snc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Benamo deidei Iudeai ḡetanuni tarimari ḡoro ḡana beḡene raga-iaḡo. ");
INSERT INTO snc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Deikara numa tuḡunai etanu-taḡoni tu, asi ma bene raka-toḡa numa nuḡana ḡana ḡena farefare ḡabiḡabiri. ");
INSERT INTO snc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Deikara vamoka nuḡanai maki asi ma bene ḡenoḡoi ḡena koudi ḡabiḡabina. ");
INSERT INTO snc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mo negai vavine ma baniri e ḡabi-variḡu vavineri kika ma vetuḡari! ");
INSERT INTO snc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Boḡono ḡauḡau Barau ḡenai, be ḡura e nagure negari ai o Sabadi ai asi boḡono raga-kwareḡa! ");
INSERT INTO snc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Korana mo negai midigumidigu tu asi keikeiri beḡe ḡorani, Barau na tanobara eveiato beiaḡoma maitoma, midigu moḡesina asi ḡeḡorani. Ma maiḡa murinai moḡesina kavana ta asi ma beḡora-ḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bema Barau na mo ḡaro rakavari asi bere vaḡa-kubiri, tarimarima ta asi bere maḡuri riba, senaḡi eḡabi-hidirito tarimari dairi ai, ḡia na ḡarori bevaḡa-kubirini. ");
INSERT INTO snc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mo negai, bema tarima ta na bekiramini, ‘Ḡoḡitaia, Keriso tu maiḡa!’ o ‘Ḡia tu iomoḡa!’ betoni nai, asi boḡono vaḡa-moḡonia. ");
INSERT INTO snc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Korana tu Keriso ḡofaḡofari e peroveta tarimari ḡofaḡofari beḡe foforini, vetoḡa boruri e nuḡa-farevaḡi veiḡari baregori beḡe veirini, Barau na eḡabi-viriḡirito tarimari beḡene ḡofa-veḡonuri ḡana. ");
INSERT INTO snc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Boḡono tuḡamaḡi-taḡoa, maiḡeri dagara tu akiravara-guinemini, hora roḡosi bene raḡasi nai. ");
INSERT INTO snc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bema tarima ta na bekiramini, ‘Ḡoḡitaia, ḡia tu tano fakanai moḡa,’ moḡana asi boḡono iaḡo; o bekirani, ‘Ḡoḡitaia, ḡia tu mo numa nuḡanai etanuni,’ asi boḡono vaḡa-moḡonia. ");
INSERT INTO snc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Korana Tarimarima Natuna beiaḡomani tu fofori-taḡo, noḡa moḡo kiriku ekimoreani gubai ḡaro raḡeraḡena na mo ḡaro riḡoriḡona kavana; ");
INSERT INTO snc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ma mase tauḡanina etanuni gabunai gaio maki monai beḡe vegogoni, (be ḡia na beḡe vaḡa-foforiani).” ");
INSERT INTO snc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mo rakava beḡe ḡorani murinai, ḡaro bemukunani e ḡue maki asi bemamani, visiḡu guba na beḡe ketoni e guba seḡukari beḡe iagaiagani. ");
INSERT INTO snc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Benamo Tarimarima Natuna vetoḡana gubai befoforini. Mo ḡaro ai tanobara beseri mabarari beḡe taḡi-vanoro vanoroni, korana Tarimarima Natuna beḡe ḡitaiani, magube iatana na beiaḡomani ma seḡuka barana e ma marevana ḡesi. ");
INSERT INTO snc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Benamo ḡia na ḡena aneru betuḡurini ma kibi gururi baregori ḡesi, eḡabi-viriḡirito tarimari beḡe vaḡa-vegogorini tanobara mabarari na.” ");
INSERT INTO snc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Figi ḡauna ḡenana mai barabore boḡono ribaia: Kabona ḡefori-raḡeni e launa ḡefafani nai, ḡoribani, ḡaro ḡena tora taimina tu bekavinaḡi ḡotoni. ");
INSERT INTO snc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Moḡa ilailanai, ḡomi maki bema mai dagara mabarari beḡe ḡorani boḡo ḡitarini nai, boḡono riba, Tarimarima Natuna tu bekavinaḡi ḡatama bokai. ");
INSERT INTO snc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moḡoni akiramini, mai ḡuru asi bekorini, beiaḡoni mo, mai dagara mabarari beḡe ḡorani. ");
INSERT INTO snc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Guba e tanobara beḡe rekwa-rekwani, senaḡi au ḡegu guruḡa tu asi beḡe rekwa-rekwani, beḡe tanu-vanaḡi vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Senaḡi mo ḡaro e hora tu tarima ta asi ribana, aneru gubai asi ribari e Natuna maki asi ribana, senaḡi Tamana ḡereḡana moḡo ma ribana. ");
INSERT INTO snc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tarimarima Natuna ḡena iaḡoma tu noḡa moḡo Noa ḡena negai kara ḡeḡorato kavana. ");
INSERT INTO snc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ḡutuḡutu roḡosi bere raga nai, tarimarima tu ḡeveini kavana ḡeḡaniḡanito-ḡoi, ḡeniuniuto-ḡoi, ema tau e vavine ḡeveḡaraḡoto-ḡoi, eiaḡomato mo, Noa ḡena lagatoi ai eraka-toḡato ḡaronai. ");
INSERT INTO snc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Senaḡi matari asi ḡekanito, asi ḡeribato kara beḡorani mo, ḡutuḡutu eraḡasito, benamo mabarari eḡutu-masemaserito. Tarimarima Natuna beiaḡomani maki moḡesina beḡorani. ");
INSERT INTO snc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mo ḡaro ai tau ruarua vamokai beḡe ḡauveini, ta tu Barau na beḡabi-vaḡiani, a ta tu betanuni. ");
INSERT INTO snc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vavine ruarua widi giro dagarana beḡe giro-vegogoani, ta tu beḡabi-vaḡiani, a ta tu betanuni. ");
INSERT INTO snc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Moḡesi nai tataḡa-taḡo boḡono tanu, korana ḡomi asi ribami ḡemi Vereḡauka tu aitoma beiaḡomani. ");
INSERT INTO snc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Boḡono riba-maoro: Bema numa tarimana ma ribana kamara aoanai lema tarimana beiaḡomani nai, ḡia tu tataḡa-taḡo betanuni, benamo lema tauna na numa asi bedareani. ");
INSERT INTO snc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Moḡa lorinai ḡomi maki boḡono verovina-tore, korana Tarimarima Natuna aitoma beraḡasini aoanai ḡomi asi boḡo ribani.” ");
INSERT INTO snc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Deikara tu mo farefare nari tarimari na guruḡa eseḡaḡini ema veiḡa roroḡotori eveini, ḡena vere na eḡabi-hidiato numa ema vetuḡunaḡi tarimari bene ḡita-ḡauri, ema ḡani-ḡani maki nega korikori ai bene viniri? ");
INSERT INTO snc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mo vetuḡunaḡi tarimana, ḡena vere na ekiraiato ilailanai eḡauveini, bema-ḡoitaḡoani tu namo. ");
INSERT INTO snc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Moḡoni akiramini, ḡia tu ḡena vere ḡena farefare mabarari ḡitaḡauri tarimanai betoreani. ");
INSERT INTO snc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Senaḡina bema ḡia vetuḡunaḡi tarimana rakavana, tauḡena nuḡana bekirani, ‘Au ḡegu vere ḡena ḡenoḡoi tu bekwaibo-rakava,’ ");
INSERT INTO snc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","benamo ḡia na karona bekwaririni, ma ḡia tu niuniu tarimari ḡesi beḡe ḡaniḡani-vegogoni e beḡe niuniu-vegogoni. ");
INSERT INTO snc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Vetuḡu-naḡi tarimana ḡena vere ḡena ḡenoḡoi ḡarona tu asi etuḡamaḡiani ḡaronai, ma asi eribaiani aoanai beraḡasini. ");
INSERT INTO snc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Benamo ḡena vere na bea basi-ḡutuḡutuani, ma ḡofaḡofa tarimari ḡesi bea toreani. Monai beḡe taḡini, gadikari maki beḡe veḡara-tarini.” ");
INSERT INTO snc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mo ḡaro ai Guba Basileia tu noḡa moḡo ḡuiato gabanana (10) kavana, ḡeri lamefa ḡeḡabirito, ḡeraka-rosito, veḡaraḡo variḡu tauna ḡesi beḡene vedoḡari ḡetato. ");
INSERT INTO snc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ḡuiato imaima (5) tu ma iaunegari, a imaima (5) tu babori. ");
INSERT INTO snc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Korana ḡuiato babori ḡeri lamefa moḡo ḡeḡabito, senaḡi keresini kota ma asi ḡeḡabikauto. ");
INSERT INTO snc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A iaunega ḡuiatori ḡeri lamefa ḡeḡabito nai, keresini maki kavabu ai ḡeḡabikauto. ");
INSERT INTO snc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Veḡaraḡo variḡu tauna ekwaiboto dainai, gena na matari eḡararito, benamo mabarari ḡegenato. ");
INSERT INTO snc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Boḡi nuḡanai ta ekoḡoto, ekirato, ‘Veḡaraḡo variḡu tauna mani eiaḡomani, be ḡoiaḡo, ḡia ḡesi boḡono vedoḡari!’ ");
INSERT INTO snc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Benamo ḡuiato 10 ḡetataḡato, ḡeri lamefa ḡeiarevarito. ");
INSERT INTO snc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ḡuiato babori na iaunega ḡuiatori ḡevaḡa-guruḡarito, ḡekirato, ‘Ḡemi keresini kota ḡovinima, korana ḡai ḡema lamefa mai ḡebuseni.’ ");
INSERT INTO snc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Senaḡi iaunega ḡuiatori ḡevaḡa-veseto, ḡekirato, ‘Asiḡina, ḡomi ema ḡai tu asi beilailani. Namona tu sitoa ḡana ḡoiaḡo, tauḡemi ḡemi ḡoa voi.’ ");
INSERT INTO snc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Keresini voi ḡeiaḡoto-ḡoi nai, veḡaraḡo variḡu tauna eraḡasito. Benamo ḡerovina-toreto ḡuiatori tu ḡia ḡesi veḡaraḡo verekonai ḡeraka-toḡato. Benamo ḡatama-boka ḡekou-ḡauato. ");
INSERT INTO snc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gabivau ḡuiato tari maki ma ḡevotuto, ḡekirato, ‘Vereḡauka, Vereḡauka o, ḡema ḡatama-boka noma keoa!’ ");
INSERT INTO snc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Senaḡi veḡaraḡo variḡu tauna evaḡa-veseto, ekirato, ‘Moḡoni akiramini, au tu asi ribagu ḡomi.’ ");
INSERT INTO snc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Moḡa lorinai, boḡono venari-taḡo, korana ḡemi Vereḡauka beiaḡomani ḡarona e horana asi ribami.” ");
INSERT INTO snc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Guba Basileia tu noḡa moḡo tarimana ta, gabu manaḡana ḡana bene iaḡo etato. Roḡosi bere raka nai, ḡena vetuḡunaḡi tarimari ekea-iaḡomarito, ḡena farefare evinirito, beḡene ḡauvei-iaḡiri ḡana. ");
INSERT INTO snc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ḡia na golo moniri ḡia tata sebori sebori ḡeri riba e kokore ilailari ai evinirito. (Golo monina ta tu tarima ta davana laḡani toitoi nuḡanai beḡabini kavana). Ta tu golo moniri imaima (5) eviniato, ma ta tu golo moniri ruarua (2), ma ta tu golo monina sebona eviniato. Benamo eraga-kwanerito, ḡena iaḡoiaḡo eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Golo moniri imaima eḡabirito tarimana maoromaoro eiaḡoto, ḡena moni eḡauvei-iaḡirito, golo moniri boruri imaima ma edoḡaririto. ");
INSERT INTO snc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Moḡesina kavana golo moniri ruarua eḡabirito tarimana na maki moni boruri ruarua ma edoḡaririto. ");
INSERT INTO snc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Senaḡi golo monina sebona eḡabiato tarimana eiaḡoto, tano ai guri ekwaiato, biaguna ḡena moni ekure-toḡaiato. ");
INSERT INTO snc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nega varau emanaḡato nuḡanai, mo vetuḡunaḡi tarimari ḡeri vere ma eḡenoḡoi-iaḡomato, ḡena moni kamasi ḡeḡauvei-iaḡirito beḡene vevarifiu-iaḡiri etato. ");
INSERT INTO snc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Benamo golo moniri imaima eḡabirito tarimana ema raka-toḡato, moni boruri imaima eḡabi-kaurito, ekirato, ‘Verebara, ḡoi na golo moniri imaima oviniguto nuḡanai, au na tu moni boruri imaima ma badoḡariri maiḡeri.’ ");
INSERT INTO snc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ḡia na evaḡa-namoato, ekirato, ‘Namo baregona! Ḡoi tu vetuḡunaḡi taumu namona, ma vetuḡamaḡikaumu! Dagara misiri oḡau-vei-iaḡi ginikaurini nai, au na dagara ḡutuma avinimuni, ḡoi na boḡita-ḡaurini. Noma raka-toḡa, au ḡesi sima iaku-vegogo!’ ");
INSERT INTO snc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Benamo golo moniri ruarua eviniato tarimana ma ema raka-toḡato, ekirato, ‘Verebara, ḡoi na golo moniri ruarua oviniguto nuḡanai, au na tu moni boruri ruarua ma badoḡariri, maiḡeri.’ ");
INSERT INTO snc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ḡena vere na evaḡa-namoato, ekirato, ‘Namo vedaurea! Ḡoi tu vetuḡunaḡi taumu namomu, ma vetuḡamaḡikaumu! Dagara misiri oḡauvei-iaḡi ginikaurini nai, au na dagara ḡutuma avinimuni, ḡoi na boḡita-ḡaurini. Noma raka-toḡa, au ḡesi sima iaku-vegogo!’ ");
INSERT INTO snc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Benamo golo monina sebona eḡabiato tarimana ema raka-toḡato, ekirato, ‘Verebara, au ribagu ḡoi tu asi vegubakau taumu, dia ḡoi na ovarorito dagarari okwarini, ema dia ḡoi na ḡue-ḡuturi ofiu-rovorovorito dagarari ovaḡa-vegogorini. ");
INSERT INTO snc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Moḡesi naima agarito, aiaḡoto, ḡemu moni tano nuḡanai akure-toḡaiato. Noḡitaia, dagarana iniḡa, ḡemu noḡabia.’ ");
INSERT INTO snc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ḡena vere na ekiraiato, ekirato, ‘Ḡoi vetuḡunaḡi taumu rakavamu ma ḡubulefimu. Ḡoi ribamu, dia au na avarorito dagarari akwarini, ema dia au na afiu-rovorovorito dagarari avaḡa-vegogorini. ");
INSERT INTO snc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kamuto, bere namo ḡegu moni tu banikai boro torea, benamo au bara ḡenoḡoi-iaḡoma nai tu, ma torekauna ḡesi bara doḡaria. ");
INSERT INTO snc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bevaitovo, ḡia na vetuḡunaḡi tarimari tari ekirarito, ekirato, ‘Mani moni sebona ḡenai maniḡa ḡoḡabia, moni gabanana (10) tarimana ḡovinia. ");
INSERT INTO snc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Korana ma ḡena-ḡana tarimana tu ḡutumari ma baviniani, be barego lelevaḡi beḡabini, a asi ḡena-ḡana tarimana tu ḡenai misina maki baḡabi-vaḡiani. ");
INSERT INTO snc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma mai vetuḡunaḡi tarimana rakavana ḡofiu-rosia murika mukunana ḡana. Monai bene taḡi, gadikana maki bene vaḡa-ḡaratariri.’” ");
INSERT INTO snc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tarimarima Natuna tu ma mamana marevana e seḡuka baregona, ema ma ḡena aneru mabarari ḡesi beḡe iaḡomani, ḡena teronai betanu-kauni. ");
INSERT INTO snc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bese mabarari ḡia ḡoiranai beḡe vaḡa-vegogorini, benamo ḡia na bevaḡa-farararini, noḡa moḡo mamoe narinariri tarimana na mamoe nanigosi ḡerina etore-ḡerevaḡirini kavana. ");
INSERT INTO snc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mamoe tu aroribana rekenai, ma nanigosi tu kaurina rekenai betorerini. ");
INSERT INTO snc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Benamo Vere na aroribana tarimari bevaḡa-guruḡarini, bekirani, ‘Ḡoiaḡoma! Tamagu na evaḡa-namomini tarimami, ḡoiaḡoma! Barau ḡena Basileia ḡoma ḡabia, guba tanobara eveirito neganai varau erovina-toreato ḡomi ḡemi. ");
INSERT INTO snc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Korana au evitoguto nai, ḡoḡubuguto; bokagu ekoketo nai, nanu ḡoviniguto; au vanuḡa boru tarimagu ḡomi fakami ai atanuto, senaḡi ḡoḡabi-raḡeguto; ");
INSERT INTO snc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","au asi ḡegu dabuḡa, ḡovaḡa-dabuḡaguto; akeveto nai, ḡonariguto; dibura numai atanuto nai, ḡoraka-ḡitaguto.’ ");
INSERT INTO snc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Benamo vei-iobukaiobuka tarimari na beḡe vaḡa-veseani, beḡe kirani, ‘Vereḡauka, aitoma ḡaḡitamuto ovitoto, ḡaḡubumuto? O onanu-maseto, nanu ḡavinimuto? ");
INSERT INTO snc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aitoma ḡoi vanuḡa boru tarimamu ai ḡaḡitamuto, ḡaḡabi-raḡemuto ḡai ḡema numai, o asi ḡemu dabuḡa, ḡavaḡa-dabuḡamuto? ");
INSERT INTO snc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kamara ḡaro ai ḡaḡitamuto ḡoi okeveto, o diburai otanuto, ḡaraka-ḡitamuto?’ ");
INSERT INTO snc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Benamo Vere na bevaḡa-veserini, bekirani, ‘Moḡoni akiramini, tarikakagu asi ḡeiavirini tarimari maiḡeri ta ḡovei-viniato ilailanai, au maki moḡesi ḡovei-viniguto.’ ");
INSERT INTO snc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Benamo kaurina rekena tarimari bevaḡa-guruḡarini, bekirani, ‘Au ḡegu na ḡoraka-veḡita, meto barego lele-vaḡina iatami ai etanuni tarimami, ḡoiaḡo, eḡara-vanaḡi vanaḡini karavana ḡana, Satani ma ḡena aneru ḡeri Barau na varau evei-toreato. ");
INSERT INTO snc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Korana evitoguto, senaḡi asi ḡoḡubuguto; nanu na emaseguto, senaḡi nanu asi ḡoviniguto; ");
INSERT INTO snc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","au tu vanuḡa boru tarimagu ḡomi fakami ai atanuto, senaḡi asi ḡoḡabi-raḡeguto ḡemi numai; asi ḡegu dabuḡa, senaḡi asi ḡovaḡa-dabuḡaguto; akeveto ema dibura numai atanuto, senaḡi asi ḡoraka-ḡitaguto.’ ");
INSERT INTO snc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Benamo ḡia maki beḡe vaḡa-veseani, beḡe kirani, ‘Vereḡauka, kamara ḡaro ai ḡaḡitamuto, ovitoto o onanu-maseto, o vanuḡa boru tarimamu, o asi ḡemu dabuḡa, o okeveto, o diburai otanuto, ḡai na asi ḡavaḡa-kavamuto?’ ");
INSERT INTO snc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Benamo Vere na bevaḡa-veserini, bekirani, ‘Moḡoni akiramini, ḡomi na mai tarikaka asi ḡeiavirini tarimari maiḡeri, ta asi ḡovaḡa-kavaiato nai, au maki moḡesi ḡovei-viniguto, asi ḡovaḡa-kavaguto.’ ");
INSERT INTO snc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tauna moḡa, ḡia tu midigu vanaḡivanaḡi gabuna ḡana beḡe iaḡoni, a vei-iobukaiobuka tarimari tu maḡuri vanaḡivanaḡi gabuna ḡana beḡe iaḡoni.” ");
INSERT INTO snc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu na maiḡeri dagara mabarari evevaḡa-riba iaḡi-ḡosirito nai, ḡena mero evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ḡomi ma ribami, ḡaro ruarua moḡo, benamo Pasova beḡe veiani. (Moḡa tu Iuda tarimari mase aneruna na evanaḡirito moḡo, asi evaḡirito verekona). Mo ḡaro ai Tarimarima Natuna tarima tari ḡimari ai beḡe toreani, beḡene vaḡa-satauroa ḡana.” ");
INSERT INTO snc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Benamo Rubu Veaḡa vereri baregori ema Iuda ḡeri vere baregori ḡesi ḡevegogoto, Kaiafas, Rubu Veaḡa verena barana, ḡena numai. ");
INSERT INTO snc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ḡeboioḡato, Iesu beḡene ḡabi-lemaia, benamo beḡene vaḡi-masea. ");
INSERT INTO snc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Senaḡi ḡekirato, “Dia vereko nuḡanai bene ḡora, korana vereko beḡe iaḡomani tarimari ḡia iatana na beḡe burini garina.” ");
INSERT INTO snc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu tu Betania ai, Simona, lepera tarimana, ḡena numai. ");
INSERT INTO snc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ḡeḡaniḡanito-ḡoi nuḡanai, vavine ta ḡia ḡenai eiaḡoto; kavabu namona ta, alabasta forena na ḡeveiato kavabuna, eḡabi-kauato, nuḡanai tu muramura ma bonana namona, voina barego vedaurea; Iesu ḡaniḡani gabunai etanu-taḡoto-ḡoi nai, mo vavine na Iesu debanai ebubuato. ");
INSERT INTO snc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ḡena mero na ḡeḡitaiato, benamo ḡebaruto, ḡekirato, “Karase nai mai muramura efitoḡa-kavaiani? ");
INSERT INTO snc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mai muramura bere voivoi-iaḡia, be moni baregona bere ḡabia, benamo asi ḡeri-ḡari tarimari bere viniri! ");
INSERT INTO snc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu ribana ḡia tu kara ḡekiraḡiato, moḡesina nai evaḡa-guruḡa-rito, ekirato, “Karase nai mai vavine ḡomugumugu-iaḡiani? Mai vavine na veiḡa namona au ḡegu ai beveia. ");
INSERT INTO snc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Asi ḡeri-ḡari tarimari tu ḡomi ḡesi boḡo tanu-vanaḡi vanaḡini. Senaḡi au tu dia ḡaro mabarari ḡomi ḡesi batanuni. ");
INSERT INTO snc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mai vavine na muramura au tauḡanigu ai bebubu-guinea, gurigurigu ḡana. ");
INSERT INTO snc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Moḡoni akiramini, Vari Namona beḡe ḡobata-iaḡiani tanobara mabarari nuḡari ai, mai vavine na veiḡa beveia veiḡana maki beḡea kiraḡiani, ḡia tuḡamaḡi-iaḡina.” ");
INSERT INTO snc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Benamo gabanana ruarua (12) tarimari ta, arana Iudas Isakariota, Rubu Veaḡa vereri baregori ḡeri ai eiaḡoto, ");
INSERT INTO snc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","edanaḡirito, ekirato, “Kara boḡo viniguni, bema Iesu ḡimami ai batore-kauani nai? Ḡia na silva moniri gabana toitoi (30) ḡeiavirito, benamo ḡeviniato. ");
INSERT INTO snc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mo nega monana Iudas na ḡimari ai betore-kauani dabarana evetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Asi etubuni faraona verekona ḡarona giniguinenai ḡena mero Iesu ḡenai ḡeiaḡoto, ḡedanaḡiato, ḡekirato, “Ḡai tu ainai Rubu Veaḡa verekona baḡana vei-torea, bono ḡania?” ");
INSERT INTO snc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Benamo Iesu na evaḡa-veserito, ekirato, “Ḡoiaḡo vanuḡa barana nuḡanai, mo bakiraḡia tarimana ḡenai, boḡono vaḡa-guruḡaia, boḡono kira, ‘Vevaḡa-riba tauna ekirani: Ḡegu hora varau beraḡasi. Ḡegu mero ḡesi ḡoi ḡemu numai ginitaḡo mamoena baḡa ḡaniani.’” ");
INSERT INTO snc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Benamo mero Iesu na ekirarito ilailanai vereko ḡevei-toreato. ");
INSERT INTO snc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lavilavi ai Iesu ma ḡena mero gabanana ruarua (12) ḡesi ḡetanu-tarito, vereko ḡeḡania ḡana. ");
INSERT INTO snc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Benamo ḡeḡaniḡanito-ḡoi nai, ekirarito, ekirato, “Moḡoni akiramini, ḡomi ta na au borevaguni.” ");
INSERT INTO snc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ḡia mabarari nuḡari ma metori ḡesi irau sebori irau sebori na ḡedanaḡiato, ḡekirato, “Vereḡauka, moḡoni dia au, ene?” ");
INSERT INTO snc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu evaḡa-veseto, ekirato, “Au ḡesi diḡu sebonai ḡanaba-riḡoni tarimana na au berevaguni. ");
INSERT INTO snc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tarimarima Natuna bemaseni Buka Veaḡai ḡetoreato ilailanai. Senaḡi Tarimarima Natuna berevaiani tarimana ḡenai tu vetuḡana kekei; asi bere maḡuri tu namo.” ");
INSERT INTO snc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Benamo Iudas, reva tarimana, ekirato, “Vevaḡa-riba taumu, moḡoni dia au, ene?” Iesu evaḡa-veseto, ekirato, “Dagarana maniḡa, mani okiraḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ḡeḡaniḡanito-ḡoi nuḡanai, Iesu na beredi eḡabiato, Barau evaḡa-namoato, etaviato, evinirito, benamo ekirato, “Ḡoḡabia, ḡoḡania, mai tu au tauḡanigu.” ");
INSERT INTO snc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ḡia na kapusi ma eḡabiato, evaḡa-namoato murinai, evinirito, ekirato, “Ḡoniua, ḡomi mabarami. ");
INSERT INTO snc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Korana mai tu au raragu, Ginitaḡo Variḡuna evaḡa-moḡoniani, bevebubuni, tarimarima ḡutuma ḡeri rakava tuḡamaḡi-fitoḡari ḡana. ");
INSERT INTO snc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Akiramini, mai vine nanuna asi ma baniu-ḡenoḡoiani, beiaḡoni mo, ḡaro beraḡasini vau, au ḡomi ḡesi ma bita niu-vegogoani au Tamagu ḡena Basileia nuḡanai.” ");
INSERT INTO snc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Benamo mari ta ḡemariato murinai, ḡeraka-rosito, Olive Ḡorona ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Toma boḡi ḡomi mabarami ḡemi veḡabidadama au ḡegu ai boḡo raga-kwaneani, korana Buka Veaḡai maiḡesi ekirani, ‘Au na mamoe ḡitaḡauri tarimana bavaḡiani, benamo mamoe mabarari beḡe raga-lausini.’ ");
INSERT INTO snc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Senaḡi au mase na ma bavariḡisi-ḡenoḡoini murinai, baraka-guineni Galilea ḡana. Monai vau bitana vedoḡari.” ");
INSERT INTO snc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero eguruḡa-fouto, Iesu ekiraiato, ekirato, “Bema mabarari na ḡeri veḡabidadama ḡoi ḡemu ai beḡe raga-kwaneani, senaḡi au na tu asiḡina.” ");
INSERT INTO snc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu na Petero evaḡa-guruḡaiato, ekirato, “Moḡoni akiramuni, toma boḡi kokoroku roḡosi bene goḡi nuḡanai, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni.” ");
INSERT INTO snc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Senaḡi Petero eguruḡa-ḡiḡiraḡeto, ekirato, “Bema ḡoi ḡesi bita mase-vegogoni maki, au na ḡoi tu asi veḡata bakira-ḡuniḡaumuni.” Ḡena mero mabarari maki moḡesi ḡekirato. ");
INSERT INTO snc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu ma ḡena mero ḡesi ḡeiaḡoto gabu ta arana Getesemane, benamo ḡia na evaḡa-guruḡarito, ekirato, “Mainai ḡotanutaḡo, au tu iomo ḡana aiaḡoni, naḡauḡau.” ");
INSERT INTO snc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Benamo Petero ema Sebedaio natuna ruarua moḡo eḡoririto, ḡia ḡesi ḡeiaḡoto. Moḡa nuḡanai Iesu tau-ḡanina efarakaiato, egarito, nuḡana maki evekwaraḡito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Benamo ekirarito, ekirato, “Au nuḡagu na meto asikei eḡwaiani, dori evaḡiguni. Mainai ḡotanu, boḡono vevaḡa-gwaḡiḡi au ḡesi.” ");
INSERT INTO snc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iesu kota ma eraka-naḡito, ḡoirana tano ai ekokofa-tarito, benamo eḡuriḡurito, ekirato, “Tamagu o, bema ma dabara ta, mai midigu bedina ḡeguna noma ḡabi-vaḡia. Senaḡi dia au ḡegu ura, ḡoi ḡemu ura moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ḡena mero toitoi ḡeri ai eḡenoḡoito nuḡanai, ḡia tu gena-maseri ai eḡoitaḡorito, benamo Petero ekiraiato, ekirato, “Kamasi nai ḡomi taumi toitoi au ḡesi aoa sebona ta kavana maki asi boḡo vevaḡa-gwaḡiḡini? ");
INSERT INTO snc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Boḡono vevaḡa-gwaḡiḡi, boḡono ḡauḡau, be veribaḡani beiaḡomani nai tu, asi boḡono moira. Iauka tu moḡoni eurani, senaḡi tau-ḡani tu emoirani.” ");
INSERT INTO snc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesu nega vaḡa-ruarua eraka-veḡitato, ea ḡuriḡurito, ekirato, “Tamagu o, bema asi dabara ta mai midigu bedina ḡeguna boḡabi-vaḡiani nai, ḡoi ḡemu ura bono veia moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma eḡenoḡoi-iaḡomato nuḡanai tu, ḡia asi ḡeri vevaḡa-gwaḡiḡi nai, genamaseri ai ma edoḡaririto, korana matari tu gena na eḡabi-rakavarito. ");
INSERT INTO snc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iesu na ma eiaḡuirito, ma eiaḡoto, vaḡa-toitoi ma eḡauḡauto, ḡena ḡuriḡuri guruḡari guineri ma ekiraḡi-ḡenoḡoirito. ");
INSERT INTO snc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Benamo ḡena mero ḡeri ai ma eḡenoḡoi-iaḡomato, ekirarito, “Ḡomi tu roḡo ḡogenani e ḡoiaḡaraḡini? Ḡoḡitaia! Aoana varau beraḡasi! Tarimarima Natuna tu beḡe revaia, rakava tarimari ḡimari ai beḡe torea. ");
INSERT INTO snc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ḡovariḡisi, be si-iaḡosi! Ḡoḡitaia, au revarevagu tarimana mai beraḡasi!” ");
INSERT INTO snc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu roḡo eguruḡato-ḡoi nuḡanai, Iudas, mero gabanana ruarua (12) tauna ta, eraḡasito. Tarimarima ḡutuma maki ḡia ḡesi ma ḡeri vetari baḡari e vevaḡi kwariri. Ḡia tu Rubu Veaḡa vereri baregori ema Iuda vereri na ḡetuḡurito. ");
INSERT INTO snc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Reva tarimana na vetoḡa ta ekiravara-torerito, ekirato, “Baverauani tarimana tu moḡa, boḡono ḡabi-taria.” ");
INSERT INTO snc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iudas eraḡasito nai, maoromaoro eiaḡoto Iesu ḡenai, benamo ekirato, “Vevaḡa-riba tarimamu, boḡi namona!” benamo everauato. ");
INSERT INTO snc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu na evaḡa-veseato, ekirato, “Ḡata, veiveina uranai boiaḡoma veiḡana noraga-veia!” Benamo ḡeiaḡomato, ḡimari na Iesu ḡeḡabi-tariato, ḡedegodegoato. ");
INSERT INTO snc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A Iesu ḡena mero ta ḡena vetari baḡana einu-vaḡiato, edaveato, benamo Rubu Veaḡa verena baregona ḡena vetuḡunaḡi tarimana seḡana ebasi-vaḡiato. ");
INSERT INTO snc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Benamo Iesu na ekiraiato, ekirato, “Ḡemu baḡa tu ḡuraḡurana gabunai noḡura-ḡenoḡoia. Korana vetari baḡari ḡeḡabini tarimari mabarari tu vetari baḡari na beḡe maseni. ");
INSERT INTO snc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ḡoi asi ribamu, Tamagu ḡena vevaḡa-kava banoḡiani, benamo ḡia na aneru vaḡa-sebo au ḡegu ai betuḡurini, aneru doḡorori gabanana ruarua (12) o 70,000 ema tari maki betuḡurini au vaḡa-kavagu? ");
INSERT INTO snc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Moḡesi bere vei, senaḡi Buka Veaḡai varau ḡetoreato guruḡana tu kamasi bemoḡonini? Be, maiḡesi moḡo beḡene vetore!” ");
INSERT INTO snc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iesu na monai mo tarima ḡutuma evaḡa-guruḡarito, ekirato, “Au tu seḡafore doḡorona ta aḡori-kauani, be ḡomi boḡo iaḡoma au ḡabiḡabigu tu ma ḡemi vetari baḡari e vevaḡi kwariri ḡesi? Ḡaro mabarari ai au tu ḡomi sevimi ai, Rubu Veaḡa nuḡanai avevaḡa-ribato-ḡoi, senaḡi asi ḡoḡabi-tariguto. ");
INSERT INTO snc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","A mai dagara mabarari ḡeḡorani tu, peroveta tarimari na Buka Veaḡai ḡetore-guinerito guruḡari vaḡa-moḡoniri ḡana.” Benamo Iesu ḡena mero mabarari na ḡeraga-kwaneato, ḡeraga-rovorovoto. ");
INSERT INTO snc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mo ḡeḡabi-tariato tarimari na Iesu ḡeḡori-iaḡoato, Kaiafas, Rubu Veaḡa verena baregona, ḡena numa ḡana. Monai taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ema Iuda vereri varau ḡeraka-vegogoto. ");
INSERT INTO snc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petero na Iesu eraka-tuḡuato-ḡoi, ma fakana eiaḡoto mo, Rubu Veaḡa verena baregona ḡena numa ḡana. Eraka-toḡato maḡu nuḡanai, benamo veḡitaḡau tarimari fakari ai ea tanu-tarito, bene ḡita, mo veiḡa magonai kara befoforini. ");
INSERT INTO snc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rubu Veaḡa vereri baregori e Iuda ḡeri kanisoro tarimari mabarari na vevaḡa-bade ḡofaḡofa tarimari ḡevetaurito, Iesu beḡene ḡofaḡofa-iaḡia, be beḡene vaḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Vevaḡa-bade ḡofaḡofa tarimari ḡutuma ḡevariḡisito, ḡeḡofaḡofa-iaḡiato, senaḡi ḡeri guruḡa tu asi ḡesebonato-ḡoi. Magonai vau ḡofaḡofa tarimari ruarua ḡevaisi-raḡeto, ");
INSERT INTO snc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ḡekirato, “Mai tarima ekirato, ‘Au tu ma seḡukagu mai Barau ḡena Rubu Veaḡa barovoani, ema ḡaro toitoi nuḡanai ma bavaḡa-ruḡa ḡenoḡoiani.’” ");
INSERT INTO snc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Benamo Rubu Veaḡa verena baregona eruḡa-vaisito, Iesu edanaḡiato, ekirato, “Ḡoi tu asi bovaḡa-veseni? Maiḡeri na ḡoi ḡevarifiu-iaḡimuni guruḡari tu kamasi?” ");
INSERT INTO snc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Senaḡi Iesu asi eguruḡato. Rubu Veaḡa verena baregona na ma edanaḡi-ḡenoḡoiato, ekirato, “Maḡuri Barauna aranai au na ḡoi akiramuni, nokira-varama: Ḡoi tu Keriso, Barau Natuna?” ");
INSERT INTO snc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu na evaḡa-veseato, ekirato, “Dagarana okiraḡiani maniḡa! Ma au na ḡomi mabarami akiramini: Mai ḡaro maiḡa, mo beiaḡoni ḡoirai, ḡomi na Tarimarima Natuna roḡo boḡo ḡitaiani, seḡuka Barauna ḡimana aroribanai betanuni, e guba maguberi iatari na beiaḡomani!” ");
INSERT INTO snc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Benamo Rubu Veaḡa verena baregona tauḡena ḡena dabuḡa edareato, ekirato, “Barau vaḡa-rakavana guruḡana tu ekiraḡi-ḡosiato! Karase vevaḡa-ḡita tarimari roḡo tavetaurini? Barau vaḡa-rakavana guruḡana bekiraḡia, varau boḡo seḡaḡia. ");
INSERT INTO snc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kara mani ḡotoni?” Ḡia mabarari ḡekirato, “Bene mase moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Benamo ḡoirana ḡekanunuato, ḡefaisiato. Kotari na ḡeforoato, ");
INSERT INTO snc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ḡekirato, “Keriso, ḡoi tu peroveta tarimana, be nokira-varama, deikara na bebotamu?” ");
INSERT INTO snc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petero roḡo numa maḡuna nuḡanai etanu-taḡoto-ḡoi, benamo vetuḡunaḡi ḡuiatona ta ḡia ḡenai eiaḡomato, ekirato, “Ḡoi maki Iesu, Galilea tauna, ḡesi orakaoto-ḡoi, okavaiato-ḡoi.” ");
INSERT INTO snc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Senaḡi Petero evekira-ḡuniḡauto mabarari ḡoirari ai, ekirato, “Au asi ribagu ḡoi kara okiraḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Benamo eraka-rosito, maḡu ḡatama bokana sevina ḡana eiaḡoto. Ma vetuḡunaḡi ḡuiatona ta na eḡitaiato, benamo sevina tarimari evaḡa-guruḡarito, ekirato, “Ḡia maki Iesu, Nasareta tarimana, ekavaiato tarimana.” ");
INSERT INTO snc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petero ma evekira-ḡuniḡauto, eguruḡa-gwaḡiḡito, ekirato, “Au asi ribagu mani tarima.” ");
INSERT INTO snc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nega kotuna evanaḡito nuḡanai, monai ḡeruḡa-taḡoto-ḡoi tarimari Petero ḡenai ḡeiaḡomato, ḡevaḡa-guruḡaiato, ḡekirato, “Moḡoni, ḡoi maki ḡia ḡesi tarimamu ta, korana garomu na evaḡa-foforimuni.” ");
INSERT INTO snc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Benamo Petero na ekirarito, “Asiḡina ḡinavaḡi, akira-korikorimini, mani tarima au asi ribagu!” Asikauna kokoroku egoḡito. ");
INSERT INTO snc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Benamo Petero na Iesu ḡena guruḡa etuḡamaḡi-doḡariato, ekiraiato, “Kokoroku roḡosi bene goḡi nai, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni.” Benamo eraka-rosito murikai, etaḡi-rakava rakavato. ");
INSERT INTO snc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Boḡiboḡi ekini-mama mamaiato-ḡoi, Rubu Veaḡa vereri baregori mabarari ema Iuda vereri ḡeboioḡa-vegogoto, Iesu beḡene vaḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Seini na ḡebarubaruato, ḡeḡori-iaḡoato, Pilato, Roma gavana, ḡimanai ḡetore-kauato. ");
INSERT INTO snc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iudas, reva tauna, na Iesu eḡitaiato, vaḡa-masena guruḡana varau ḡeveiato, benamo evetuḡamaḡi-kureto. Benamo silva moniri gabana toitoi (30) eḡwa-ḡenoḡoirito Rubu Veaḡa vereri barari e Iuda vereri ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ekirato, “Au tu bavei-rakava, korana asi ḡena rakava tarimana barevaia, bemaseni.” Ḡevaḡa-veseto, ḡekirato, “Mani tu dia ḡai ḡema nuḡa-vekwaraḡi, mani tu ḡoi tauḡemu ḡemu ḡauvei moḡo.” ");
INSERT INTO snc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iudas na silva moniri Rubu Veaḡa nuḡanai efiu-toḡarito, eraka-veḡitato. Benamo eiaḡoto, tauḡena ea veborato. ");
INSERT INTO snc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Benamo Rubu Veaḡa vereri baregori na mo silva moniri ḡeḡabirito, ḡekirato, “Mai tu rara voina monina, be boubou mauḡanai asi veḡata bita ḡuraiani, taravatu.” ");
INSERT INTO snc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ḡeguruḡa-iaḡiato, ḡevaḡa-moḡoniato murinai, mo moni ḡeḡabiato, ḡuro eveini tarimana ḡena tano ḡevoiato, tanobara boru tarimari ḡeri gara gabunai ḡevaḡa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Moḡesina nai mo tano arana ḡevatoani “Rara Tanona” beiaḡoma mo maitoma. ");
INSERT INTO snc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Monana Ieremia peroveta tarimana ḡena guruḡa ema moḡonito, ekirato, “Mo silva moniri gabanana toitoi (30) ḡeḡabirito, mo tu Isaraela tarimari na ḡevaḡa-moḡoniato voina misina, mo tau beḡene voia ḡana. ");
INSERT INTO snc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma mo moni na ḡuro eveini tarimana ḡena tano ḡevoiato, Vereḡauka ekirato ilailanai.” ");
INSERT INTO snc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu Roma gavanana ḡoiranai eruḡato, ḡia na edanaḡiato, ekirato, “Ḡoi tu Iuda tarimari ḡeri kini ba?” Iesu evaḡa-veseto, ekirato, “Oi, okiraḡiani maniḡa.” ");
INSERT INTO snc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Benamo Rubu Veaḡa vereri baregori ema Iuda vereri na Iesu ḡeḡofaḡofa-iaḡiato, senaḡi guruḡa ta asi ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Moḡa lorinai Pilato na evaḡa-guruḡaiato, ekirato, “Ḡoi asi oseḡaḡini, iatamu ai tu meto ḡutuma ḡekiraḡirini?” ");
INSERT INTO snc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Senaḡi Iesu asi eḡoiaḡito, guruḡa sebona tai maki asi evaḡa-veserito. Monana gavana nuḡana efarevaḡi-rakavato. ");
INSERT INTO snc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vanaḡivanaḡi Pasova verekona ḡaronai tu gavana na ḡia ḡeri dibura numai etanuni beḡe kiraḡiani tarimana ta etuḡu-rosiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mo laḡani ai tarima rakava kwaikwaina ta dibura numai etanuto, arana tu Barabas. ");
INSERT INTO snc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Moḡa lorinai tarima ḡutuma ḡevegogoto nuḡanai, Pilato na edanaḡirito, ekirato, “Deikara ḡoura-viniani natuḡu-rosia: Barabas ba Iesu, ḡekiraḡiani Keriso?” ");
INSERT INTO snc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Korana Pilato ribana ginikau, Iuda tarimari baregori ḡeri mama dainai, Iesu ḡia ḡimanai ḡetoreato. ");
INSERT INTO snc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato na Kota eḡorikauato-ḡoi nuḡanai, Pilato ḡaraḡona na ḡena keakau ta etuḡu-raḡasiato, ekirato, “Mani vei-iobukaiobuka tarimana ḡenai dagara ta asi bono veia, korana au tu boḡi ai banuvi, ḡegu nuvi ai midigumidigu baregona na beḡabigu ḡia dainai.” ");
INSERT INTO snc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Senaḡi Rubu Veaḡa vereri baregori ema Iuda vereri na vegogo tarimari nuḡari ḡeḡanirito, Pilato beḡene kiraia, Barabas bene tuḡu-rosia, a Iesu bene mase. ");
INSERT INTO snc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Senaḡi gavana na vegogo tarimari ma edanaḡirito, ekirato, “Ḡia tauri ruarua dei tu ḡomi ḡemi natuḡu-rosia?” Vegogo tarimari ḡefararato, ḡekirato, “Barabas!” ");
INSERT INTO snc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Benamo Pilato na edanaḡirito, ekirato, “O mai Iesu, ḡekiraḡiani Keriso, tu kamasi bana veia?” Ḡia mabarari ḡevaḡa-vese vegogoto, ḡekirato, “Novaḡa-satauroa!” ");
INSERT INTO snc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Senaḡi Pilato na ma edanaḡirito, ekirato, “Kara dainai? Kamara veiḡa rakavana eveiato nai?” Senaḡi mabarari ḡefarara-gigitarito, ḡekirato, “Novaḡa-satauroa!” ");
INSERT INTO snc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato etuḡamaḡi-fakato, ḡia ḡena riba guruḡari tu asi beḡe ḡabi-raḡerini, ma tarimarima ḡia iatana na beḡe burini garina, benamo ḡia tu nanu eḡabito, ḡimana eḡuriḡiato mo tarimarima ḡutuma ḡoirari ai, ema maiḡesi ekirato: “Au tu asi ḡegu kerere mai vei-iobukaiobuka tarimana rarana ḡenai; mai tu ḡomi ḡemi ḡauvei moḡo!” ");
INSERT INTO snc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vegogo tarimari mabarari ḡevaḡa-veseto, ḡekirato, “Mai tarima rarana o ḡena mase metona tu ḡai iatamai bene tanu ema ḡai natuma iatari ai.” ");
INSERT INTO snc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Benamo Pilato na Barabas etuḡu-rosiato ḡia ḡeri, a Iesu tu ḡekwaria etato vau soldia evinirito, beḡene vaḡa-satauroa ḡana. ");
INSERT INTO snc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Benamo Pilato ḡena vetari tarimari na Iesu ḡeḡori-iaḡoato gavana ḡena numa nuḡanai, benamo karori mabarari ḡekea-vegogorito, bena ḡeruḡa-ḡeḡeraḡiato. ");
INSERT INTO snc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ḡena dabuḡa ḡeruḡa-vaḡirito, dabuḡa kakakakana ḡevaḡa-veiato, ");
INSERT INTO snc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","debana dagarana ḡau ma giniginina na ḡevatoato, korona noḡa ḡeveiato, benamo Iesu debanai ḡetore-kauato. Oro ta maki ḡimana aroribanai ḡevaḡa-ḡabiato, benamo ḡoiranai ḡevetui-tarito, ḡevaseva-vaseva iaḡiato, ḡekirato, “Iuda ḡeri Kini o, ḡaro namona!” ");
INSERT INTO snc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Benamo ḡekanunu-kanunuato, mo oro ḡeḡabi-rariato, debana ḡekwari-ḡenoḡoi ḡenoḡoiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ḡevaseva-vaseva iaḡi-ḡosiato murinai, dabuḡa kakakakana ḡeḡabi-vaḡiato, ḡena dabuḡa korikorina ma ḡevaḡa-veiato. Benamo ḡeḡori-rosiato, beḡenea vaḡa-satauroa ḡana. ");
INSERT INTO snc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ḡeraka-rosito-ḡoi nai, Kurene tarimana ta ḡeḡoitaḡoato arana Simona. Vetari tarimari o soldia na ḡelaunaḡi-naḡiato, Iesu ḡena satauro neḡwaia. ");
INSERT INTO snc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Benamo vanuḡa na ḡeraka-rosito, gabu tai ḡeraḡasito arana tu Golgota, anina tu ‘Deba Ḡavana Gabuna’. ");
INSERT INTO snc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Monai vine nanuna midigu vaḡa-keina muramurana arana gal ḡesi ḡebubu-vegogoato dagarana, Iesu ḡeviniato; eiamuse-tovoato, senaḡi asi eniuato. ");
INSERT INTO snc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ḡevaḡa-satauroato murinai, ḡena dabuḡa ḡia fakarai ai ḡevarerito kasi ai. ");
INSERT INTO snc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Moḡa murinai ḡetanutanu-tarito, benamo ḡenariato. ");
INSERT INTO snc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ḡia debana iatanai kara koranai ḡevaḡa-satauroato guruḡana ḡekafa-kauato, maiḡesi ḡetoreato, “MAI TU IESU, IUDA ḠERI VERE.” ");
INSERT INTO snc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Seḡafore tarimari ruarua maki Iesu ḡesi ḡevaḡa-sataurorito, ta aroribana rekenai, ma ta kaurina rekenai. ");
INSERT INTO snc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ḡeraka-vanaḡito-ḡoi tarimari debari ḡekorakorarito-ḡoi, guruḡa rakavari Iesu ḡeviniato-ḡoi, ");
INSERT INTO snc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ḡekirato-ḡoi, “O ḡoi okirato, Rubu Veaḡa borovoani, ḡaro toitoi nuḡanai ma bovaḡa-ruḡa ḡenoḡoiani otato, tauḡemu novevaḡa-maḡuri! Bema ḡoi Barau Natuna, satauro tuḡuna na noraka-riḡo.” ");
INSERT INTO snc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ema Iuda vereri na maki maiḡesi ḡevaseva-vaseva iaḡiato-ḡoi, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ḡia na tarima boruri evaḡa-maḡuririto-ḡoi, kamuto ḡia tauḡena tu asi evevaḡa-maḡurini! Bema ḡia moḡoni Isaraela tarimari ḡeri vere nai, satauro na inimoḡo neraka-riḡo, be baḡana vaḡa-moḡonia. ");
INSERT INTO snc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ḡia na Barau eḡabidadama viniato-ḡoi, be siḡitaia, Barau na maki betuḡamaḡi-kauani, bevaḡa-maḡuriani ba? Evekiraḡito-ḡoi, ‘Au tu Barau Natuna,’ nene?” ");
INSERT INTO snc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iesu ḡesi ḡevaḡa-satauro vegogorito seḡafore tarimari ruarua na maki moḡesi ḡeguruḡa-rakava viniato. ");
INSERT INTO snc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Horaḡauna 12 koloko ea ḡabiato nai, tanobara mabarana mukuna na eḡabi-ḡauato, mukuna etanuto eiaḡoto mo horaḡauna 3 koloko. ");
INSERT INTO snc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Horaḡauna 3 koloko rekenai Iesu eḡabato, ekirato, “Eloi, eloi, lama sabaktani?” anina tu, “Au ḡegu Barau, au ḡegu Barau, kara dainai au boraga-kwanegu?” ");
INSERT INTO snc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tarimarima tari monai ḡeruḡa-taḡoto-ḡoi nai, ḡeseḡaḡiato, benamo ḡekirato, “Ḡia tu Elia ekeaiani.” ");
INSERT INTO snc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Benamo ḡeri tarima ta eraga-iaḡoto, nanu erimaiani dagarana ta eḡabiato, vine nanuna mamakina nuḡanai eduḡi-fereiato, gobu lefai egwanu-kauato, benamo eduḡi-raḡeato, Iesu na neniua ḡana. ");
INSERT INTO snc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Senaḡi kotari ḡekirato, “Sivaḡa-noga roḡo, siḡitaia, Elia beiaḡomani, bevaḡa-maḡuriani ba asiḡina.” ");
INSERT INTO snc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu ma eḡaba-fouto murinai emaseto. ");
INSERT INTO snc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Benamo mo negai moḡo Rubu Veaḡa nuḡanai veaḡa lelevaḡi daiḡutunai, kouḡau dabuḡana o ketin evedare-kikimato, eruaruato, tuḡuna na mo gabigabina. Tano eiagaiagato, fore barari ḡeḡwa-kirarito. ");
INSERT INTO snc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mase guriri ḡevekeo-fakato, ma tarima ḡutuma, Barau ḡena ura ḡeveirito-ḡoi tarimari, mase na ma ḡevaisiraḡe-ḡenoḡoito, ");
INSERT INTO snc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ḡeri guri gaburi ḡeiaḡuirito. Iesu ḡena variḡisi-ḡenoḡoi murinai, Siti Veaḡana ḡana ḡeiaḡoto, monai tarimarima ḡutuma ḡoirari ai ḡefoforito. ");
INSERT INTO snc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Vetari verena ma ḡena vetari tarimari ḡesi, Iesu ḡenariḡauato-ḡoi tarimari, na tano-iaga ema ḡeḡorato dagarari mabarari ḡeḡitarito nai, ḡegari-rakavato, ḡekirato, “Mai tarima tu moḡoni Barau Natuna!” ");
INSERT INTO snc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vavine ḡutuma maki monai, kotuna manaḡai ḡeruḡato, ḡemarereto-ḡoi. Moḡeri vavine Iesu murinai ḡerakato Galilea na eiaḡoto mo Ierusalema ḡana, ema ḡia vetuḡu-naḡina ḡeiaḡo-vinito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ḡia fakari ai tu Maria, Magadala vavinena; Maria, Iakobo (o Iames) e Ioane sinari; ema Iakobo e Ioane Sebedaio sinari. ");
INSERT INTO snc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mo lavilavi ai farefare ḡutuma tarimana Arimatea vanuḡa na eraḡasito, arana tu Iosefa; ḡia maki Iesu ḡena mero ta. ");
INSERT INTO snc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ḡia tu Pilato ḡenai eiaḡoto, benamo enoḡiato, Iesu tauḡanina bene ḡabia etato. Benamo Pilato na ḡena vetari tarimari ekirarito, Iesu tauḡanina Iosefa beḡene vinia. ");
INSERT INTO snc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Moḡa lorinai Iesu tauḡanina eḡabiato, dabuḡa kurokurona namona na ekumuato, ");
INSERT INTO snc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","gara gabuna fore kouḡanai ea tore-toḡaiato. Mo gara tu fore gwaḡiḡinai kouḡa ta ḡekoroato, ḡia tauḡena ḡena guri gabuna variḡuna ta. Fore baregona na ḡatama-boka ekure-ḡauato, benamo eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria, Magadala vavinena, ema Maria ta tu monai ḡetanu-taḡoto-ḡoi, guri ḡetanu-ḡoiraiato. ");
INSERT INTO snc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Vereko ḡevei-toreani ḡarona ekorito vau, Sabadi varau beḡabia, Rubu Veaḡa vereri baregori e Farisea tarimari Pilato ḡenai ḡeiaḡoto, ");
INSERT INTO snc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ḡekirato, “Verebara, ḡai ḡatuḡa-maḡini, mo ḡofaḡofa tarimana roḡo maḡuri nai, ekirato, ‘Ḡaro toitoi murinai au tu mase na ma bavariḡisi-ḡenoḡoini.’ ");
INSERT INTO snc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Moḡa lorinai gadi tauri bono kirari, be guri gabuna beḡene nari-ginikaua, bene iaḡo mo, ḡaro toitoi murinai. Irau ḡena mero beḡe iaḡoni, ma tauḡanina beḡe lemaiani, benamo tarimarima beḡe ḡofarini, beḡe kirani, ‘Ḡia tu mase na bevariḡisi-ḡenoḡoi,’ beḡe toni garina. Mai ḡofaḡofa maiḡa na ḡofaḡofa guinena bevanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato na ekirarito, ekirato, “Gadi tarimari ḡoḡabiri, ḡeiaḡo, be guri gabuna beḡene ruḡaḡau-ginikaua.” ");
INSERT INTO snc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Benamo gara ḡana ḡeiaḡoto, guri kouḡana ekou-ḡauato forena ḡekada-ḡauato, tabu vetoḡana ta ḡeveiato, benamo gadi tarimari ḡetorerito, beḡene riviḡaua. ");
INSERT INTO snc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabadi ekorito murinai, fura ḡarona giniguinenai, boḡiboḡi iamoiamo, Maria, Magadala vavinena, Maria ta ḡesi ḡeiaḡoto, gara gabuna ḡea ḡitaiato. ");
INSERT INTO snc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Asikauna tu tano-iaga baregona eḡorato, korana Vereḡauka ḡena aneru ta guba na emariḡoto, fore ekure-veḡitaiato, benamo iatanai etanukauto. ");
INSERT INTO snc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ḡia vetoḡana tu noḡa moḡo kiriku ekimoreani kavana, ema ḡena dabuḡa tu kuro-ḡaroḡaro kaufa o snou noḡa. ");
INSERT INTO snc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Guri gabuna ḡeḡitaḡauto tarimari tu ḡegari-rakavato nai ḡeḡoḡo-ḡoḡorito, benamo tano ai ḡeketo-tarito mase tarimari kavana. ");
INSERT INTO snc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aneru na mo vavine evaḡa-guruḡarito, ekirato, “Asi ḡogari, au ribagu ḡomi tu Iesu, ḡevaḡa-satauroato tauna, ḡovetauani. ");
INSERT INTO snc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ḡia mainai tu asiḡina; ḡia tu bevariḡisi-ḡenoḡoi, evaḡa-guruḡamito ilailanai. Ḡetoreato gabuna ḡoma ḡitaia. ");
INSERT INTO snc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Be ḡoiaḡo-ḡariḡari, ḡena mero boḡonoa kira-varari, boḡono kira, ‘Iesu tu mase na bevariḡisi-ḡenoḡoi, ema beguineni Galilea ḡana. Monai vau boḡoa ḡitaiani.’ Mai guruḡa nakira-varami ḡana baiaḡoma.” ");
INSERT INTO snc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Benamo mo vavine na guri gabuna ḡeragakwane-ḡariḡariato, ma gariri e ma verereri ḡesi ḡeragato ḡena mero ḡeri ai, mo aneru ḡena guruḡa ḡea vaḡa-ribari ḡana. ");
INSERT INTO snc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ḡeragato-ḡoi nai, asikauna Iesu tu ḡia ḡoirari ai eruḡato, ekirato, “Maino ḡomi ḡesi bene tanu!” Benamo ḡoiranai ḡevetui-tarito, kwakuna ḡeregorito, ḡetoma-rakariḡo viniato. ");
INSERT INTO snc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesu na evaḡa-guruḡarito, ekirato, “Asi ḡogari, ḡoiaḡo, au tarikakagu ḡoa kirari, Galilea ḡana beḡene iaḡo; monai vau au beḡene ḡitagu.” ");
INSERT INTO snc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vavine ruarua dabara na ḡeiaḡoto-ḡoi nuḡanai, tuari tarimari tari, guri gabuna ḡenari-ḡauato tarimari, ḡeḡenoḡoito vanuḡa barana ḡana, karakara ḡeḡorato dagarari mabarari Rubu Veaḡa vereri baregori ḡekira-vararito. ");
INSERT INTO snc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Benamo mo Rubu Veaḡa vereri barari tu Iuda vereri ḡesi ḡeboioḡa-vegogoto, gadi tarimari moni baregona ḡevinirito. ");
INSERT INTO snc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Maiḡesi ḡekirarito, ḡekirato, “Ḡomi tu boḡono kira, ‘Ḡena mero boḡi nuḡanai beḡe iaḡoma, ḡai tu genamai beḡe lemaia.’ ");
INSERT INTO snc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bema mai vari gavana na beseḡaḡiani nai tu, ḡai na ḡia nuḡana baḡa vei-magomagoani, be ḡomi veiḡa rakavana ta asi bevei-vinimini.” ");
INSERT INTO snc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gadi tarimari na moni ḡeḡabiato, ḡevaḡa-guruḡarito ilailanai ḡeguruḡato. Mai vari tu Iuda tarimari fakari ai ḡekiraḡi-rakaorakaoato, ma maitoma maki roḡo ḡekiraḡiani. ");
INSERT INTO snc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ḡena mero gabanana sebona (11) tu Galilea ḡana ḡeiaḡoto, Iesu na ekiraḡi-guineato ḡorona ḡana. ");
INSERT INTO snc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Monai ḡeḡitaiato nai, ḡetoma-rakariḡo viniato; senaḡi tari tu ḡedaradarato: ‘Mai tu moḡoni Iesu ba?’ ");
INSERT INTO snc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Benamo Iesu eraka-kavito, evaḡa-guruḡarito, ekirato, “Barau na seḡuka mabarana gubai ema tanobarai au varau bevinigu. ");
INSERT INTO snc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Moḡa lorinai ḡoiaḡo tanobara mabarari ḡana, bese mabarari ḡegu mero ai boḡono vaḡa-iaḡori. Ema Tamana, Natuna, Iauka Veaḡa aranai boḡono babatisori. ");
INSERT INTO snc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Boḡono vaḡa-ribari maki, avinimito vevaḡa-naḡiri mabarari beḡene korana-iaḡiri. Boḡono riba, au tu ḡaro mabarari ai ḡomi ḡesi bita tanuni, beiaḡoni mo, tanobara magona!” ");
INSERT INTO snc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesu Keriso Barau Natuna Varina Namona maiḡesina evesinato. ");
INSERT INTO snc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta tarimana arana Isaia na etoreato, “Barau ekirato, ‘Au na ḡegu vetuḡunaḡi tarimana tu batuḡu-guineani, ḡemu dabara vaḡa-maḡatana.’ ");
INSERT INTO snc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tarima ta tano fakanai ekeani, ekirani, ‘Vereḡauka ḡena dabara ḡoiarevaia, ḡena iaḡoma dabarana ḡovaḡa-maoromaoroa!’” ");
INSERT INTO snc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Moḡa lorinai Ioane eiaḡomato, tano fakanai tarimarima ebabatisorito-ḡoi e eḡobatato-ḡoi, tarimarima ḡeri rakava ḡerina beḡene vetuḡamaḡi-kure e beḡene raka-kure, ema babatiso beḡene ḡabia, Barau na ḡeri rakava bene tuḡamaḡi-fitoḡari ḡana. ");
INSERT INTO snc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tarimarima mabarari Iudea vanuḡari na e Ierusalema na ḡeiaḡoto-ḡoi Ioane ḡenai. Ḡeri rakava ḡekiraḡi-foforirito-ḡoi vau, ebabatisorito-ḡoi Ioridana ḡarukanai. ");
INSERT INTO snc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane ḡena dabuḡa tu kamela ḡwiri na ḡeveiato, ḡena gabaḡau tu nanigosi kefina, ḡana ḡaniḡani dagarari tu madudu e gode nanuri moḡo. ");
INSERT INTO snc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eḡobatato-ḡoi, ekirato, “Tarima ta au murigu na beiaḡomani, ḡia ḡena seḡuka na au ḡegu seḡuka tu evanaḡiani. Au maki asi ilaila ḡia ḡena tamaka varona baruḡaiani. ");
INSERT INTO snc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au na ḡomi tu nanu na ababatisomini, a ḡia na tu Iauka Veaḡa na bebabatisomini.” ");
INSERT INTO snc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mo negai Iesu tu Nasareta, Galilea vanuḡana ta, na eiaḡomato, benamo Ioane na Ioridana ḡarukanai ebabatisoato. ");
INSERT INTO snc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu nanu na eraka-raḡasito nuḡanai, guba eḡitaiato, evekeo-fakato, benamo Iauka Veaḡa pune kavana emariḡoto ḡia ḡenai. ");
INSERT INTO snc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Benamo garo ta guba na ekea-riḡoto, ekirato, “Ḡoi tu au Natugu, aura-vinimuni; ema ḡemu ai aiaku-rakavani maki.” ");
INSERT INTO snc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Moḡa murinai Iauka Veaḡa na Iesu tano fakana ḡana etuḡu-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Monai ḡaro e boḡi gabana vasivasi (40) etanuto, Satani na eriba ḡaniato-ḡoi. Ḡia tu boḡa bairi ḡesi ḡetanuto-ḡoi, aneru na ḡenariato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ioane ḡediburaiato murinai, Iesu Galilea ḡana eiaḡoto, Barau Varina Namona ea ḡobata iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Eḡobatato, ekirato, “Barau ḡena ḡaro tu varau beraḡasi, ḡena Basileia bevotu, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa)! Ḡemi rakava ḡerina ḡovetuḡamaḡi-kure, Vari Namona nuḡami na ḡovaḡa-moḡonia!” ");
INSERT INTO snc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu Galilea kou rikina na eraka-iaḡoto-ḡoi nuḡanai, Simona ma tarina Anduru ḡesi eḡitarito, ḡeri reke kou ai ḡefiuato, korana ḡia tu maina tarimari. ");
INSERT INTO snc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Ḡoiaḡoma, murigu ai ḡoma raka, be au na tu tarimarima maina viniri bana vaḡa-ribami.” ");
INSERT INTO snc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Benamo maoromaoro ḡeri reke ḡeraga-kwanerito, Iesu murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Asi ḡeraka-manaḡato, benamo Iesu na Iakobo (o Iames) Sebedaio, tarina Ioane ḡesi eḡitarito, ḡasi ai ḡeri reke ḡwadareri ḡeturirito-ḡoi; ");
INSERT INTO snc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ekearito, benamo ḡia na tamari Sebedaio ma ḡena ḡauvei tarimari ḡesi ḡasi ai ḡeraga-kwanerito, Iesu murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ḡeraka-iaḡoto, Kaperanaumai ḡevotuto. Monai Sabadi ai Iesu Iuda tarimari ḡeri rubu ai eraka-toḡato, benamo evevaḡa-ribato. ");
INSERT INTO snc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ḡia ḡena vevaḡa-riba guruḡari tarimarima na ḡeseḡaḡirito nai, ḡeḡaba-rakavato, korana tu ḡena guruḡa ma seḡukana, dia taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ḡeri guruḡa kavana. ");
INSERT INTO snc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mo rubu ai tarima ta tu iauka rakavana na eboroḡiato tarimana. Ḡia ekeato, ekirato, ");
INSERT INTO snc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu, Nasareta tarimamu o, kara ḡemai noveia otoni? Ḡoi tu ḡai vaḡa-rakavama uranai boiaḡoma? Au ribagu ḡoi tu deikara, ḡoi tu Barau ḡena Veaḡa Tarimamu!” ");
INSERT INTO snc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu na ekira-ḡoiato, “Gurumu! Ḡia ḡenana noraka-vaḡi!” ");
INSERT INTO snc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Benamo iauka rakavana na mo tarima evaḡa-ḡoḡo-ḡoḡoato, benamo ma ḡabana ḡesi eraka-vaḡito. ");
INSERT INTO snc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tarimarima mabarari ḡeḡaba-rakava rakavato, benamo tauḡeri ḡevedanaḡi-vedanaḡito, ḡekirato, “Mai tu kara? Vevaḡa-riba variḡuna? Ḡia tu ma seḡukana na iauka rakavari evaḡa-guruḡarini, ema garona maki ḡeseḡaḡiani!” ");
INSERT INTO snc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Benamo Iesu varina asikauna eraga-rovorovoto Galilea vanuḡari mabarari ai. ");
INSERT INTO snc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Rubu na ḡeraka-rosito murinai, Iakobo (o Iames) ema Ioane ḡesi ḡeiaḡoto, Simona ema Anduru ḡeri numai ḡea raḡekauto. ");
INSERT INTO snc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona ḡena taḡama vavinena tu ekeveto, tauḡanina eseḡukato, be egena-taḡoto-ḡoi, benamo Iesu ḡekira-varaiato. ");
INSERT INTO snc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu eiaḡoto ḡenai, ḡimanai eḡabito, benamo evaḡa-tanu vaisiato. Mo keve ekorito, benamo ḡia eḡuburito. ");
INSERT INTO snc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lavilavi, ḡaro eketoto murinai, tarimarima na keve tarimari e iauka rakavari na ḡeboroḡirito tarimari Iesu ḡenai ḡeḡori-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vanuḡa tarimari mabarari numa ḡoiranai ḡevegogoto. ");
INSERT INTO snc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesu na keve irauirau tarimari vovoka evaḡa-namorito e iauka rakavari ḡutuma elai-vaḡirito. Iauka rakavari mururi ekourito asi beḡene guruḡa, korana ḡia ribari Iesu. ");
INSERT INTO snc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Boḡiboḡi rekenai, roḡosi bene laḡani nai, Iesu evariḡisito, tano fakana ḡana eiaḡoto, ea ḡuriḡurito. ");
INSERT INTO snc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Benamo Simona ma karona ḡesi Iesu ḡea vetauato, ");
INSERT INTO snc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ḡea doḡariato nai, ḡekiraiato, ḡekirato, “Tarimarima na tu ḡoi ḡevetaumuni!” ");
INSERT INTO snc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu evaḡa-veseto, ekirato, “Vanuḡa kavinaḡiri ḡana si-iaḡo. Moḡeri ai maki bana ḡobata, au ḡegu iaḡoma korana tu moḡa.” ");
INSERT INTO snc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Benamo ḡia eiaḡoto Galilea vanuḡari mabarari ḡana. Rubu ai eḡobatato-ḡoi e iauka rakavari elai vaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepera tarimana ta Iesu ḡenai eiaḡoto, evetui-tarito, benamo enoḡiato, ekirato, “Bema ḡoi ourani nai, moḡoni boiarevaguni, bovaḡa-namoguni riba.” ");
INSERT INTO snc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu na evetuḡaiato, ḡimana etuḡu-iaḡoato, eḡabi-karaiato, benamo ekirato, “Aurani, be nonamo!” ");
INSERT INTO snc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Benamo vaḡa-sebo lepera na eraga-kwaneato, enamoto. ");
INSERT INTO snc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu na evaḡa-guruḡa gwaḡiḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mai veiḡa tarima ta asi bono kira-varaia. Noiaḡo, Rubu Veaḡa verena na bene ḡitamu, ema veiareva varevare dagarari Mose na ekiraḡiato ilailanai bono vinia. Be tarimarima beḡene riba, ḡoi tu bonamo.” ");
INSERT INTO snc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Senaḡi ḡia tu eiaḡoto, mo veiḡa varina efiuato. Moḡesi nai Iesu tu vanuḡa tai asi ma eraka-toḡato, a tano fakari ai moḡo etanuto-ḡoi. Senaḡina tarimarima gabu irauirauri na Iesu tu roḡo ḡeiaḡo-viniato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ḡaro kotari ḡevanaḡito vau, Iesu Kaperanauma ḡana eḡenoḡoito. Tarimarima na varina ḡeseḡaḡiato Iesu tu numai. ");
INSERT INTO snc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Moḡa lorinai tarimarima ḡutuma ḡeḡaru-vegogoto, numa nuḡana ḡevaḡa-vonuato, eiaḡoto ḡatama-boka korana maki asi faka ta. Monai vau Iesu na Vari Namona eḡobata-vinirito, ");
INSERT INTO snc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","nuḡanai tarima vasivasi (4) na tauḡanina tavi ta emaseto tarimana ta Iesu ḡenai ḡeḡwa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tarimarima ḡutuma nai, asi ḡeri dabara Iesu sevina ḡana beḡe raka-kavi iaḡoni. Naima ḡia na Iesu eruḡato iatana ḡuduḡuna ḡeḡiu-vaḡiato vau, keve rakava tarimana ma gedana ḡesi ḡetuḡu-riḡoato Iesu ḡoirana ḡana. ");
INSERT INTO snc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu na ḡeri veḡabidadama eḡitaiato nai, ḡia na keve rakava tarimana evaḡa-guruḡaiato, ekirato, “Natugu, ḡemu rakava batuḡamaḡi-fitoḡari.” ");
INSERT INTO snc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari kotari monai tanutaḡori ai, nuḡari ai maiḡesi ḡetuḡamaḡito, ");
INSERT INTO snc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Karase nai mai tarima moḡesina ekirani? Ḡia na Barau ekira-fitoḡaiani. Dei na rakava betuḡamaḡi-fitoḡarini? Barau moḡo ḡereḡana!” ");
INSERT INTO snc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu ma ribana ḡia kara ḡetuḡamaḡirito-ḡoi nai edanaḡirito, ekirato, “Karase nai maniḡesi ḡotuḡamaḡini? ");
INSERT INTO snc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aiḡesina baguruḡani tu meraḡa, keve rakava tarimana bavaḡa-guruḡaia, bakira, ‘Ḡemu rakava batuḡamaḡi-fitoḡari’ banasi, ba bara kiraia, ‘Noruḡa-vaisi, ḡemu geda noḡabia, be noraka’ barasi? ");
INSERT INTO snc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Au na navaḡa-ḡitami, Tarimarima Natuna tu ma ḡena maoro, rakava betuḡa-maḡi-fitoḡarini mai tanobarai.” Ḡia na keve rakava tarimana evaḡa-guruḡaiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Akiramuni, noruḡa-vaisi, ḡemu geda noḡabia, be numa ḡana noiaḡo!” ");
INSERT INTO snc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Maoromaoro eruḡa-vaisito, ḡena geda eḡabiato, tarimarima ḡoirari ai eraka-rosito. Moḡa lorinai mabarari ḡeḡaba-rakava rakavato, Barau ḡevaḡa-raḡeato, ḡekirato, “Maiḡesina kavana ta roḡosi tara ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu ma eiaḡoto kou rikinai. Tarimarima ḡutuma ḡia ḡenai ḡeiaḡoto, benamo ḡia na evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iesu eraka-iaḡoto-ḡoi nuḡanai, ḡia na Alfeo natuna arana Levi takesi moniri ḡeḡabito-ḡoi numanai tanutaḡo eḡitaiato, benamo ekiraiato, ekirato, “Murigu ai noma raka.” Benamo Levi evariḡisito, Iesu murinai erakato. ");
INSERT INTO snc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesu Levi ḡena numai eḡani-ḡanito-ḡoi nai, takesi gogo tarimari e vei-rakava tarimari ḡutuma maki Iesu ma ḡena mero ḡesi ḡeḡaniḡani-vegogoto, korana tarimarima vovoka ḡia murinai ḡerakato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, Farisea ḡeri doḡoro tarimari, na Iesu ḡeḡitaiato, takesi gogo tarimari e vei-rakava tarimari ḡesi ḡeḡaniḡani-vegogoto-ḡoi, benamo ḡia na Iesu ḡena mero ḡedanaḡirito, ḡekirato, “Ḡia tu karase nai takesi gogo e vei-rakava tarimari ḡesi ḡeḡaniḡani-vegogoni?” ");
INSERT INTO snc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu eseḡaḡito, benamo evaḡa-guruḡarito, ekirato, “Namo tarimari na doketa asi beḡe vetaurini, senaḡina keve tarimari na moḡo. Au aiaḡomato maki dia vei-iobukaiobuka tarimari keakeari, senaḡi vei-rakava tarimari.” ");
INSERT INTO snc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ḡaro ta Ioane Babatiso ḡena mero e Farisea tarimari ḡeḡani-veaḡato-ḡoi nai, tarima kotari Iesu ḡenai ḡeiaḡoto, benamo ḡedanaḡiato, ḡekirato, “Kara dainai Ioane Babatiso ḡena mero e Farisea tarimari ḡeri mero tu ḡeḡani-veaḡani, senaḡi ḡoi ḡemu mero tu asiḡi?” ");
INSERT INTO snc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡotuḡamaḡini, veḡaraḡo variḡu tauna ḡatana seviri ai etanuni nuḡanai beḡe ḡani-veaḡani ba? Asiḡina! Veḡaraḡo variḡu tauna ḡatana seviri ai neganai, asi beḡe ḡani-veaḡani. ");
INSERT INTO snc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ḡarona eiaḡomani veḡaraḡo tauna ḡatana ḡerina beḡe ḡabi-veḡitaiani, monai vau beḡe ḡani-veaḡani. ");
INSERT INTO snc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tarima ta na dabuḡa variḡuna veseana dabuḡa guinena ḡesi asi bebani-vegogoani. Bema moḡesina beveiani nai, dabuḡa variḡuna na guinena bedareani, ema vedarena maki bebaregoni. ");
INSERT INTO snc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tarima ta na vine nanuna variḡuna nanigosi kefina guinenai asi besisiani. Bema moḡesina beveiani nai, vine nanuna variḡuna na nanigosi kefina guinena bevei-fakaiani. Vine nanuna e kefi beḡe rakavani. Senaḡi vine nanuna variḡuna nanigosi kefina variḡunai besisiani tu namo.” ");
INSERT INTO snc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabadi tai Iesu ma ḡena mero ḡesi widi vamokari na ḡeraka-vanaḡito-ḡoi nai, ḡena mero tu rakarakari ai widi ḡebukito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisea tarimari na Iesu ḡekiraiato, ḡekirato, “Noḡitari, ḡia kara ḡeveini! Maniḡesi asi beḡene vei Sabadi ai, taravatu.” ");
INSERT INTO snc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu na evaḡa-veserito, ekirato, “Davida na kara eveiato guruḡari ḡoiaviato ba asiḡina, ḡia ma karona ḡesi ḡevitorito nai? ");
INSERT INTO snc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Barau ḡena numai eraka-toḡato, Barau ḡoiranai ḡetorerito-ḡoi beredi eḡabito, eḡanito, karona maki evinirito. Mo beredi tu veaḡa veḡata, Rubu Veaḡa vereri ḡereḡari moḡo ḡari. Mo veiḡa tu Abiata Rubu Veaḡa verena baregona ḡena negai eḡorato.” ");
INSERT INTO snc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Benamo Iesu na ma ekirarito, ekirato, “Barau na Sabadi eveiato tu tarimarima ḡeri, dia tarimarima eveirito Sabadi ḡena. ");
INSERT INTO snc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Moḡesi nai Tarimarima Natuna tu Sabadi Verena.” ");
INSERT INTO snc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ḡaro tai Iesu rubu ai ma eraka-toḡato. Ḡima boso tarimana ta tu monai. ");
INSERT INTO snc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tarima kotari maki monai, Iesu ḡeḡita-taḡoato-ḡoi, Sabadi ai mo tarima bevaḡa-namoani ba, beḡene ḡita-kaua, be beḡene vaḡa-bade-iaḡia ḡetato-ḡoi nai. ");
INSERT INTO snc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu na ḡima boso tarimana evaḡa-guruḡaiato, ekirato, “Noruḡa-vaisi, tarima mabarari ḡoirari ai noma ruḡa.” ");
INSERT INTO snc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Benamo Iesu na edanaḡirito, ekirato, “Aiḡa tu maoro, Sabadi ai veiḡa namori veiveiri namo ba veiḡa rakavari sini veiri? Tana vevaḡa-maḡuri ba tana vaḡivaḡi?” Senaḡi ḡia asi ḡeguruḡato. ");
INSERT INTO snc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu ma baruna e ma nuḡa-metona ḡesi eḡita-ḡeḡeraḡirito, korana tarimarima ḡenuḡa-bubuto nai. Benamo ḡima boso tarimana ekiraiato, ekirato, “Ḡimamu notuḡu-roroḡotoa.” Ḡimana etuḡu-roroḡotoato, benamo enamoto. ");
INSERT INTO snc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Moḡa murinai Farisea tarimari rubu na ḡeraka-rosito, Heroda murinai ḡerakato-ḡoi tarimari ḡesi ḡeboioḡa-vegogoto, Iesu kamasi beḡe vaḡiani dabarana ḡevetauato. ");
INSERT INTO snc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ma ḡena mero ḡesi ḡeraka-veḡitato, Galilea kouna ḡana ḡeiaḡoto. Tarimarima ḡutuma lelevaḡi Galilea na ḡia murina na ḡeiaḡoto, ema vovoka lelevaḡi maki Iudea na, ");
INSERT INTO snc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ierusalema na, Idumea na, Ioridana ḡaruka mo reke na, Taia e Sidono rekeri na ḡeiaḡoto, korana Iesu varina ḡeseḡaḡiato nai. ");
INSERT INTO snc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tarimarima ḡutuma nai, Iesu na ḡena mero ekirarito, ḡasi misina ta beḡene ḡabi-torea, tarimarima ḡutuma be beḡe ruḡaruḡa-ḡauani garina. ");
INSERT INTO snc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesu na keve tarimari ḡutuma evaḡa-namorito dainai, keve tarimari mabarari maki ḡeḡoto-iaḡoto, Iesu ḡenai beḡene veḡabi-kau ḡana. ");
INSERT INTO snc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iauka rakavari na ḡeboroḡirito tarimari na ḡia ḡeḡitaiato tu, ḡoiranai ḡeketo-tarito, ḡekoḡoto, ḡekirato, “Ḡoi tu Barau Natuna!” ");
INSERT INTO snc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesu na evaḡa-guruḡa gwaḡiḡirito, asi beḡene vaḡa-foforia ḡia tu deikara. ");
INSERT INTO snc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Moḡa murinai Iesu ḡoro ḡana evaraḡeto, benamo eura-vinirito tauri ea kearito, benamo ḡia ḡenai ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iesu na tarima gabanana ruarua (12) eḡabi-viriḡirito, arari apostolo evatorito, ḡia beḡene kavaia. Benamo ma bene tuḡuri, beḡene ḡobata, ");
INSERT INTO snc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ema seḡuka beḡene ḡabi, iauka rakavari beḡene lai-vaḡiri. ");
INSERT INTO snc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eḡabi-viriḡirito tarimari tu maiḡeri: Simona, arana variḡuna evatoato Petero; ");
INSERT INTO snc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iakobo (o Iames), Sebedaio natuna, ma tarina Ioane ḡesi, arari variḡuna evatoato, Boanere, anina tu guba eguruani natuna; ");
INSERT INTO snc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduru; Filipo; Batolomeo; Mataio; Tomasi; Iakobo (o Iames), Alfeo natuna; Tadeo; Simona, Selote tarimana; ");
INSERT INTO snc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ema Iudas Isakariota, ḡia tu Iesu berevaiani tarimana. ");
INSERT INTO snc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu tu numai ma eraḡekauto. Tarimarima ḡutuma lelevaḡi ma ḡevegogo-ḡenoḡoito nai, ḡia ma ḡena mero ḡesi asi ḡeri ḡaniḡani dabarana. ");
INSERT INTO snc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesu garagarana na varina ḡeseḡaḡiato, benamo ḡabiḡoina ḡeiaḡoto, korana tarimarima ḡekirato, “Ḡia tu bebabo!” ḡetato nai. ");
INSERT INTO snc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari Ierusalema na ḡemariḡoto, ḡekirato, “Belsebul, (mai tu Satani), iauka rakavari ḡeri vere, na ḡia eboroḡiato nai, iauka rakavari elai-vaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Benamo Iesu na ekea-iaḡoma-rito, barabore ai evaḡa-guruḡarito, ekirato, “Satani na Satani kamasi belai-veḡitaiani? ");
INSERT INTO snc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bema gavamani ta bevetavini, tauḡena bevevaḡi-vinini nai, mo gavamani asi beruḡani riba. ");
INSERT INTO snc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bema doḡoro ta bevetavini, tauḡena bevevaḡi-vinini, mo doḡoro maki asi beruḡani riba. ");
INSERT INTO snc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bema Satani bevetavini, tauḡena bevevaḡi-vinini, ḡia asi beruḡani, senaḡi bekorini. ");
INSERT INTO snc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tarima ta na gwada tarimana ḡena numai asi beraka-toḡani riba, ḡena farefare asi beverariani riba, senaḡi mo gwada tarimana bebarubaru-guineani vau, ḡena numa farefareri beverariani. ");
INSERT INTO snc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Moḡoni akiramini, tarimarima rakava beḡe veini ema Barau beḡe kira-fitoḡaiani tarimari ḡeri rakava mabarari Barau na betuḡamaḡi-fitoḡarini riba. ");
INSERT INTO snc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Senaḡi tarima ta na Iauka Veaḡa bekira-fitoḡaiani tarimana, ḡena rakava asi betuḡamaḡi-fitoḡaiani, mo rakava tu betanu-vanaḡi vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu moḡesi ekirato, korana tarima kota ḡekirato, “Ḡia tu iauka rakavana ḡia nuḡanai” ḡetato nai. ");
INSERT INTO snc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Benamo Iesu sinana ma tarina ḡeraḡasito. Numa murikanai ḡeruḡa-tarito, ḡevetuḡuto, Iesu ḡea kiraia, ḡema vaḡa-guruḡaia ḡana. ");
INSERT INTO snc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ḡia tu tarimarima ḡutuma na ḡetanu-ḡeḡeraḡiato, benamo ḡekiraiato, ḡekirato, “Ḡoi sinamu e tarimu tu murikai, ḡoi ḡevetaumuni.” ");
INSERT INTO snc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu na evaḡa-veserito, ekirato, “Au sinagu e au tarigu tu deiri?” ");
INSERT INTO snc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Benamo ḡetanu-ḡeḡeraḡiato tarimari eḡitarito, ekirato, “Au sinagu e au tarigu tu maiḡeri! ");
INSERT INTO snc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Barau ḡena ura ḡeveirini tarimari tu au tarigu, e au tobagu, ema au sinagu.” ");
INSERT INTO snc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu ma ea vevaḡa-riba ḡenoḡoito Galilea kouna rikinai. Tarimarima ḡutuma lelevaḡi na ma ḡea vegogo-ḡeḡeraḡiato nai, ḡasi ai ma eraḡekauto, benamo etanu-tarito. Ḡasi kota ḡelei-veḡitato, a tarimarima tu kou rikina na moḡo ḡevegogo-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu na dagara vovoka evaḡa-ribarito barabore ai. Ḡia ḡena vevaḡa-riba nuḡanai ekirato, ");
INSERT INTO snc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ḡoseḡaḡi! Iaraḡa tarimana ta eiaḡoto, ḡena widi ḡueri benea fiuri ḡana. ");
INSERT INTO snc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Efiurito-ḡoi nai, kota tu dabarai ḡeketoto. Benamo manu ḡeiaḡomato, ḡeḡanirito. ");
INSERT INTO snc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kotari tu forefore gaburi ai ḡeketokauto tano maḡiḡiri ai. Asikauna ḡetubu-raḡeto, korana tano iatanai moḡo. ");
INSERT INTO snc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Benamo ḡaro eraḡekauto nai, ḡia ḡemaḡuḡuto, korana lamuri asi ḡevariḡo-ḡitakauto lorinai, asikauna ḡemaseto. ");
INSERT INTO snc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kotari tu ḡauḡa ḡiniḡiniri nuḡari ai ḡeketoto. Benamo ḡauḡa ḡiniḡiniri ḡetubu-baregoto, varovaro dagarari ḡetubu-ḡaurito e ḡetuturarito nai, asi ḡeḡwato. ");
INSERT INTO snc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kotari tu tano namonai ḡeketoto, benamo ḡetubu-ginikauto, ḡegara-baregoto, ḡeḡwato kotari ḡwari tu gabana toitoi (30), kotari tu gabana imaima ma gabanana (60), kotari tu sinau sebona (100).” ");
INSERT INTO snc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Benamo Iesu ekirato, “Ma seḡana tarimana bene seḡaḡi!” ");
INSERT INTO snc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu ḡereḡana moḡo ḡaronai, ḡena mero gabanana ruarua (12) ma ḡia murinai ḡerakato-ḡoi tarimari kotari tu ḡia sevinai ruḡa-ḡeḡeraḡi, benamo mo barabore anina ḡevedanaḡi-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu na evaḡa-guruḡarito, ekirato, “Barau ḡena Basileia guruḡari vekuretoḡari ḡomi ḡemi ai tu fofori, senaḡi murika tarimari tu barabore ai avaḡa-guruḡarini, korana tu, ");
INSERT INTO snc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘beḡene ḡitaia, senaḡi anina asi beḡene ribaia, beḡene seḡaḡia, senaḡi asi beḡene tuḡamaḡi-maoroa, beḡe vetuḡamaḡi-kureni Barau ḡenai, benamo ḡeri rakava betuḡamaḡi-fitoḡarini garina.’” ");
INSERT INTO snc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Benamo Iesu na ma evaḡa-guruḡarito, ekirato, “Mai barabore anina asi ḡoribaiani nai, barabore tari tu kamasi boḡo ribarini? ");
INSERT INTO snc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iaraḡa tarimana na Barau ḡena guruḡa efiuani. ");
INSERT INTO snc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tarima kotari tu widi ḡueri dabarai ḡeketoni kavana. Guruḡa ḡeseḡaḡini nai, Satani na eḡabivaḡi-ḡariḡaririni. ");
INSERT INTO snc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tarima kotari tu widi ḡueri forefore ai ḡeketoni kavana. Guruḡa ḡeseḡaḡini nai, ma iakuri ḡesi ḡeḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Senaḡi guruḡa tarima nuḡari ai asi ḡevetoreni nai, asi ḡetanu-maukani. Barau ḡena guruḡa dainai, nega rakavari ḡeḡoitaḡoni, e ḡevanerini, o ḡevaḡa-midigu midigurini ḡarori ai ḡia ḡenana ḡeraka-veḡitani. ");
INSERT INTO snc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tarima kotari tu widi ḡueri ḡauḡa ḡiniḡiniri nuḡari ai ḡefiurini kavana. Barau ḡena guruḡa ḡeseḡaḡiani, ");
INSERT INTO snc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","senaḡi tanobara dagarari tuḡamaḡiri na, tanobara farefareri ḡetuḡamaḡi-gogogogorini, ema ḡeri ura dagarari kotari na Barau ḡena guruḡa ḡelautariani, naima Barau ḡena guruḡa ḡia ḡeri ai asi ḡwaḡwari. ");
INSERT INTO snc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tarima kotari tu widi ḡueri tano namonai ḡefiurini kavana. Guruḡa ḡeseḡaḡiani, ḡeḡabi-raḡeani, tauri ḡevetoreni kotari tu gabana toitoi (30), kotari tu gabana imaima ma gabanana (60), kotari tu sinau sebona (100).” ");
INSERT INTO snc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu na ma evaḡa-guruḡarito, ekirato, “Tarima ta lamefa begabuani nai, ḡuro na beḡoḡoi-tariani o fata gaburenai betoreani? Asiḡina, toretorena fatanai betore-kauani. ");
INSERT INTO snc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Vekuretoḡa dagarari mabarari beḡe foforini, ḡeseḡo-ḡaurito dagarari mabarari beḡe ḡabi-fakarini. ");
INSERT INTO snc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ma seḡana tarimana bene seḡaḡi!” ");
INSERT INTO snc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu na ma ekirarito, ekirato, “Boḡo seḡaḡirini guruḡari boḡono tuḡamaḡi-ginikauri. Ḡemi seḡaḡi ilailari ai Barau na riba e tuḡamaḡi-faka bevinimini. Tuḡamaḡi-faka kotari ma betore-kaurini. ");
INSERT INTO snc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma ḡena seḡaḡi tarimana tu tuḡamaḡi-faka beviniani, asi ḡena seḡaḡi tarimana, ḡena tuḡamaḡi-faka misina maki beḡabi-vaḡiani.” ");
INSERT INTO snc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu ma ekirato, “Barau ḡena Basileia tu noḡa moḡo tarima ta, widi ḡueri tano ai efiurini kavana. ");
INSERT INTO snc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ḡia tu boḡi ai egenani, laḡani ai evariḡisini nuḡanai, mo widi ḡueri ḡetubuni, ḡegarani, senaḡina ḡia tu asi ribana kamasi ḡegarani. ");
INSERT INTO snc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano tauḡena na tauna evaḡa-ḡoraiani. Guine tu gwabena etoreani, gabivau fekana, moḡa murinai tauna etoreani feka nuḡanai. ");
INSERT INTO snc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tauna bekirini nai, bebasiani, korana basibasi ḡarona bevotu.” ");
INSERT INTO snc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu evedanaḡito, ekirato, “Barau ḡena Basileia tu kara ḡesi bita vaḡa-ilailaiani? Kamara barabore na bevaḡa-foforiani? ");
INSERT INTO snc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ḡia tu mastadi ḡauna ḡutuna ta noḡa, tanobarai varovaro dagarari ḡueri mabarari fakari ai ḡia ḡereḡana misina korokoro, tano ai ḡevaroani. ");
INSERT INTO snc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Senaḡi tano ai ḡevaroani nai, egara-varaḡeni, varovaro dagarari mabarari fakari ai ḡia moḡo barego vedaurea. Ḡia legana maki baregori ḡetubuni. Monai rovo manuri ḡia legana iauḡanai ḡenuḡini.” ");
INSERT INTO snc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Moḡesina kavana baraboreri asisebo ai Iesu na Barau ḡena guruḡa eḡobata-vinirito-ḡoi, ḡia ḡeri riba e tuḡamaḡi-faka ilailari ai. ");
INSERT INTO snc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ḡena ḡobatai barabore asi eraga-kwanerito-ḡoi, senaḡi ḡena mero moḡo ḡereḡari ai vau, guruḡa aniri mabarari evaḡa-foforirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mo lavilavi ai Iesu na ḡena mero ekirarito, ekirato, “Siveḡasi-vanaḡi, kou mo rekena ḡana.” ");
INSERT INTO snc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Benamo mo tarimarima ḡutuma ḡeraga-kwanerito, ḡena mero na ḡekavaiato Iesu etanu-taḡoto-ḡoi ḡasinai, benamo ḡeḡura-rakaiato. Ḡasi kotari maki ḡia ḡesi. ");
INSERT INTO snc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iavara asi keikeina ta eraḡasito e ureure barego maki ḡasi ai evebubu-ḡurato-ḡoi, ḡasi maki dori evonuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu tu ḡasi gabinai fila iatanai egenato-ḡoi. Ḡena mero na ḡevaḡoato, ḡekirato, “Vevaḡa-riba tarimamu o, ḡoi tu asi ogarini? Ḡita tu mai taburuni!” ");
INSERT INTO snc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Benamo Iesu evariḡisito, iavara ekira-ḡoiato e ureure ekiraiato, “Nodoko, asi noḡareva.” Benamo iavara edokoto e emeḡomeḡo-tarito, asi eḡareva-ḡarevato. ");
INSERT INTO snc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu na ḡena mero ekirarito, ekirato, “Karase nai ḡogarini? Ḡomi tu roḡo asi ḡemi veḡabidadama?” ");
INSERT INTO snc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ḡia ḡegari-rakava rakavato, benamo tauḡeri ḡevedanaḡi-vedanaḡito, ḡekirato, “Mai tu kamara tarima? Iavara e ureure na maki garona ḡeseḡaḡiani!” ");
INSERT INTO snc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kou tavi tai ḡea vanaḡito Gerasa (o Gadara) tarimari ḡeri gabu ai. ");
INSERT INTO snc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesu ḡasi na eraka-riḡoto-ḡoi nai, iauka rakavana na eboroḡiato tarimana ta gara gabuna na eiaḡomato-ḡoi Iesu ḡenai. ");
INSERT INTO snc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ḡia tu gara kouḡari ai etanuto-ḡoi. Tarimarima ḡia barutarinai ḡeferauto, seini maki ḡia ḡenai asi gwaḡiḡi. ");
INSERT INTO snc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nega ḡutuma kwakuna e ḡimana seini na ḡebarurito-ḡoi, senaḡi seini edabu-ḡuturito-ḡoi, ema kwakunai auri dagarari maki elau-kirarito-ḡoi. Ḡia tu gwada rakava, tarima ta na maki asi bevaḡa-maranaiani riba. ");
INSERT INTO snc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Boḡi e laḡani ai ḡia tu garai e ḡoro tuḡuri ai ekoḡoto-ḡoi ema tauḡena maki fore na everamato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ḡia na Iesu manaḡai eḡitaiato, eraga-iaḡoto, ḡoiranai eketo-tarito, ");
INSERT INTO snc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ekoḡoto edueto, ekirato, “Iesu o, Iaru-korokoro Barauna Natuna, kara au ḡegu ai noveia otoni? Barau aranai anoḡimuni, asi bono vaḡa-midigu midigugu.” ");
INSERT INTO snc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ḡia moḡesi ekirato, korana Iesu na evaḡa-guruḡaiato, ekirato, “Iauka rakavamu, mani tarima ḡenana noraka-vaḡi!” ");
INSERT INTO snc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Benamo Iesu na edanaḡiato, ekirato, “Ḡoi aramu tu deikara?” Ḡia evaḡa-veseto, ekirato, “Au aragu tu ‘Vetari Tarimari Ḡutuma,’ korana ḡai tu vovoka.” ");
INSERT INTO snc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ḡia na Iesu enoḡi-ḡiḡiraḡeato, mo gabu na asi bene lai-rosiri. ");
INSERT INTO snc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Monai bai serina ḡoro gabakanai ḡedokadokato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Moḡesina nai iauka rakavari na Iesu ḡenoḡiato, ḡekirato, “Notuḡuma bai ḡeri ai, ḡia nuḡari ai ḡaraka-toḡa.” ");
INSERT INTO snc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu na etuḡu-iaḡorito. Benamo iauka rakavari mo tarima ḡenana ḡeraka-vaḡito, bai nuḡari ai ḡeraka-toḡato. Benamo lalaḡa na ḡekokosi-firiḡoto, kou ai ḡevebora-ḡuḡututo. Mo bai serina nuḡanai bai mabarari 2,000 kavana. ");
INSERT INTO snc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bai ḡitaḡauri tarimari ḡeragato, mo vari ḡea fiuato vanuḡa barana nuḡanai e vanuḡa keiri ai. Tarimarima ḡeraka-rosito, ḡeiaḡoto mo kara eḡorato dagarana ḡitaḡitana. ");
INSERT INTO snc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesu ḡenai ḡeraḡasito nai, ḡia na mo tarima iauka rakavari vovoka na ḡeboroḡiato tarimana ḡeḡitaiato, ma dabuḡana e ḡena tuḡamaḡi maki maoro etanu-taḡoto-ḡoi, benamo ḡia mabarari ḡegarito. ");
INSERT INTO snc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mo veiḡa ḡeḡorato, ḡeḡitarito tarimari na iauka rakavari na ḡeboroḡiato tarimana varina, ema bai variri, tarimarima ḡekira-vararito. ");
INSERT INTO snc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Benamo ḡia na Iesu ḡenoḡiato, ḡeri tano na bene raka-veḡita. ");
INSERT INTO snc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu ḡasi ai eraḡekauto-ḡoi nai, iauka rakavari ḡenana ḡeraka-vaḡito tarimana na enoḡiato, Iesu ḡesi bene iaḡo etato. ");
INSERT INTO snc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Senaḡi Iesu na ekiraiato, ekirato, “Noḡenoḡoi numa ḡana e ḡemu numa tarimari ḡeri ai. Benamo bonoa kira-varari, Barau na ḡemu ai kara beveia ema ḡena vevetuḡaḡwa ḡemu ai beḡora dagarana.” ");
INSERT INTO snc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Benamo ḡia eiaḡoto Vanuḡa Gabanana (10) tanori ai, ea vevari-fiuto, kara Iesu na ḡia ḡenai eveiato. Benamo tarimarima mabarari ḡeḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu ḡasi na ma eḡenoḡoito kou tavi ta ḡana maia. Mo kou rikinai tarimarima ḡutuma lelevaḡi na ma ḡea ḡaru-ḡeḡeraḡiato. ");
INSERT INTO snc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rubu ḡitaḡauna tarimana ta arana Iairo eiaḡoto, Iesu eḡitaiato nai, kwakuna koranai evetui-tarito, ");
INSERT INTO snc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma nuḡana mabarana ḡesi enoḡiato, ekirato, “Au natugu kekenina bekeve-rakava, dori emaseni. Mani ḡemu veiḡa, noiaḡoma, ḡimamu iatanai bono tore-kaua, be natugu bene namo!” ");
INSERT INTO snc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Benamo Iesu ḡia ḡesi ḡeiaḡoto-ḡoi nai, tarimarima ḡutuma lelevaḡi maki ḡeḡotokauto, ḡia na ḡeraka-vebibi vebibiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Monai vavine ta, ḡena keve tu rara kevena, laḡani gabanana ruarua (12) ekeve-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doketa vovoka na muramura ḡeviniato-ḡoi, senaḡi asi enamoto-ḡoi. Ḡena moni mabarari evaḡa-koririto, nenamo ḡana, senaḡi asi enamoto-ḡoi, ḡena keve moḡo emeto-iaḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ḡia na Iesu varina eseḡaḡiato naima eiaḡomato, tarimarima ḡutuma nuḡari na eraka-rokarokato mo Iesu murinai ea raḡasito, benamo ḡena dabuḡai eveḡabikauto. ");
INSERT INTO snc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Korana tu ḡia evetuḡamaḡito, “Ḡena dabuḡai moḡo baveḡabikauni nai banamoni.” ");
INSERT INTO snc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Benamo rara kevena edokoto, tauḡaninai emami-raḡiato ḡena keve varau ekorito. ");
INSERT INTO snc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mo negai Iesu eribato, ḡia ḡenana seḡuka eraka-vaḡito. Benamo tarimarima ḡutuma nuḡari na eruḡa-kureto, evedanaḡito, ekirato, “Deikara na au ḡegu dabuḡa beḡabi-karaia?” ");
INSERT INTO snc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ḡena mero ḡevaḡa-veseto, ḡekirato, “Noboḡeboḡe, mai tarimarima tu ḡutuma na ḡebebesi-karamuni, kamasi tu ma ovedanaḡini, okirani, ‘Deikara na beḡabi-karagu?’” ");
INSERT INTO snc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Senaḡi Iesu tu roḡo eboḡeboḡeto-ḡoi, eḡabi-karaiato tarimana eḡita-vetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mo vavine eriba-maoroto kara ḡenai eḡorato, benamo ma garina e ma ḡoḡo-ḡoḡona ḡesi Iesu kwakuna koranai ea vetui-tarito, benamo kara eḡorato mabarana ekiraḡi-foforirito. ");
INSERT INTO snc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu na mo vavine evaḡa-guruḡaiato, ekirato, “Natugu, ḡemu veḡabidadama na bevaḡa-namomu. Be, ma iakumu ḡesi noiaḡo, ḡemu keve bekori-moḡovaḡi.” ");
INSERT INTO snc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu roḡo eguruḡato-ḡoi nuḡanai, rubu ḡitaḡauna tauna Iairo ḡena numa na tarima kotari ḡeiaḡomato, Iairo ḡekiraiato, ḡekirato, “Natumu tu bemase. Vevaḡa-riba tarimana asi novaḡa-vekwaraḡia.” ");
INSERT INTO snc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu na mo guruḡa tu eseḡaḡi-ḡuiraḡiato moḡo, benamo rubu ḡitaḡauna tarimana evaḡa-guruḡaiato, ekirato, “Asi bono gari, bono veḡabidadama moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Benamo Iesu na mabarari ekira-ḡoirito, murina na asi beḡene iaḡo, senaḡi Petero, e Iakobo (o Iames), ema tarina Ioane moḡo ḡia ḡesi beḡene iaḡo. ");
INSERT INTO snc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iairo ḡena numai ḡeraḡasito, benamo Iesu na tarimarima eḡitarito, ḡeguru-raḡeto-ḡoi e ḡetaḡi-guruḡa guruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Benamo Iesu numai eraka-toḡato, evaḡa-guruḡarito, ekirato, “Karase nai ḡoguru-raḡeni e ḡotaḡini? Kekeni tu asi bemase, ḡia tu egenani moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Senaḡina tarimarima na ḡerikiriki-iaḡiato. Benamo Iesu na etuḡu-rosirito, bena kekeni tamana sinana e ḡia ḡekavaiato tarimari toitoi ḡesi moḡo kekeni ḡevaḡa-genaiato gabunai ḡeraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Benamo Iesu na kekeni ḡimanai eḡabito, evaḡa-guruḡaiato, ekirato, “Talita kumi!” Mo guruḡa anina tu “Kekeni, au na ḡoi akiramuni, novariḡisi!” ");
INSERT INTO snc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Benamo kekeni vaḡa-sebo evariḡisito, erakaorakaoto. Ḡia ḡena laḡani tu gabanana ruarua (12). Mai veiḡa eḡorato nai, tarimarima ḡeḡaba-rakava rakavato. ");
INSERT INTO snc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu na evaḡa-guruḡarito, mai veiḡa varina asiḡina ḡinavaḡi beḡene kiraḡia etato, ema ekirarito, mo kekeni beḡene ḡubua. ");
INSERT INTO snc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu na mo gabu eraga-kwaneato, benamo ḡena vanuḡa ḡana eiaḡoto; ḡia ḡena mero maki murina na ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabadi ḡaronai Iesu tu rubu ai ma ea vevaḡa-ribato, tarimarima ḡutuma na ḡeseḡaḡiato tu, ḡeḡaba-rakavato, ḡekirato, “Mai tarima mai riba tu ainana eḡabito? Ḡena iaunega maki dei na eviniato? Mai nuḡa-farevaḡi veiḡa boruri tu kamasi eveirini ḡimana na? ");
INSERT INTO snc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ḡia tu kamuda tarimana, ene? Maria natuna; Iakobo (o Iames), e Iosefa, e Iudas, e Simona kakari, ema tobana maki sevirai iniḡeri.” Benamo asi ma ḡevaḡa-moḡoniato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu na ekirarito, ekirato, “Peroveta tarimana tu gabu mabarari ai beḡe gubakauani, senaḡi ḡena vanuḡa korikori, garagarana, ema ḡena numa tarimari, na moḡo asi beḡe gubakauani.” ");
INSERT INTO snc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Monai ḡia na seḡuka veiḡari boruri asi eveito, a keve tarimari tu sebosebo moḡo iatari ai ḡimana etore-kauato, evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iesu edaradara-rakavato, korana asi ḡeri veḡabidadama nai. Benamo Iesu ma erakato, eiaḡoto vanuḡa kotari ai ma ea vevaḡa-ribato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Benamo Iesu na ḡena mero gabanana ruarua (12) ekearito, benamo ruari ruari etuḡurito, ema seḡuka evinirito, iauka rakavari beḡene lai-vaḡiri ḡana. ");
INSERT INTO snc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iesu na evaḡa-naḡirito, ekirato, “Kara ta asi boḡono ḡabi-kaua ḡemi iaḡoiaḡo ai, togoi moḡo. Dura, ḡaniḡani dagarari e moni maki asi boḡono ḡwakau. ");
INSERT INTO snc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaka boḡono vei, senaḡi sedi ruarua asi boḡono vei.” ");
INSERT INTO snc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma evaḡa-guruḡarito, ekirato, “Numa tai boḡo raḡekauni nai, mo numai moḡo boḡono tanu, bene iaḡo mo, vanuḡa boḡono raga-kwanea. ");
INSERT INTO snc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bema vanuḡa tai asi beḡe ḡabi-raḡemini e garomi asi beḡe seḡaḡirini nai, boḡono raga-kwanea, kwakumi kauri moḡo boḡono kwari-ketoketori ḡia ḡeri kira-sirivaḡi vaḡa-moḡoniri ḡana.” ");
INSERT INTO snc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Benamo ḡeiaḡoto, ḡea ḡobatato, tarimarima ḡeri rakava na beḡene vetuḡamaḡi-kure e beḡene raka-kure ḡana. ");
INSERT INTO snc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iauka rakavari vovoka tarimarima ḡerina ḡelai-vaḡirito, keve tarimari ḡutuma maki diḡa na ḡedaurito, ḡevaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda, Galilea verena, na mai veiḡa variri ea seḡaḡirito, korana Iesu arana gabu mabarana eraga-rovorovoto. Tarima kotari ḡekirato, “Ioane Babatiso mase na ma bevariḡisi-ḡenoḡoi. Moḡa lorinai mai veiḡa baregori mabarari evaḡa-foforirini.” ");
INSERT INTO snc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma kota ḡekirato, “Mai tu Elia,” ma kota ḡekirato, “Mai tu Peroveta tarimana ta, peroveta tarimari guineri kavana.” ");
INSERT INTO snc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Senaḡi Heroda eseḡaḡito nai, ekirato, “Mai tu Ioane Babatiso, au na debana abasi-ḡutuato tarimana, mase na ma bevariḡisi-ḡenoḡoi!” ");
INSERT INTO snc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Korana Heroda tauḡena evetuḡuto, Ioane ḡea ḡabi-tariato, benamo dibura numai ḡebarubaruato, ḡebiri-ḡauato. Mo veiḡa eveiato, korana tu etava-rariato vavinena Herodia, ḡia kakana Filipo ḡaraḡona, bene vaḡa-iakua ḡana. ");
INSERT INTO snc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ioane na Heroda evaḡa-guruḡaiato-ḡoi, ekirato, “Ḡoi na kakamu ḡaraḡona boḡaraḡo-veraria tu asi maoro!” ");
INSERT INTO snc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Moḡesina nai Herodia na Ioane ebaru-viniato, ḡena ura bene vaḡia, senaḡina asi ḡena dabara, ");
INSERT INTO snc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","korana Heroda na Ioane egari-viniato-ḡoi e eḡita-ḡauato-ḡoi. Heroda ribana Ioane tu vei-iobukaiobuka ema veaḡa tarimana. Ioane garona eseḡaḡiato nai, edaradarato-ḡoi, senaḡi eurato bene seḡaḡi-vinia. ");
INSERT INTO snc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodia ḡena ḡaro namona ta eraḡasito. Heroda ḡena ḡora ḡarona vetuḡamaḡi-iaḡina verekona o betdei pati eveiato, ḡena veguine-iaḡi tarimari baregori, e vetari ḡorikauri tarimari, ema Galilea vanuḡari ai veguine-iaḡi tarimari ekearito. ");
INSERT INTO snc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia natuna ḡuiatona ema raka-toḡato, benamo ebarato nai, Heroda ma ḡena varivari tarimari mabarari ḡesi evaḡa-iakurito. Benamo Heroda na mo ḡuiato ekiraiato, ekirato, “Ḡoi kara oura-viniani dagarana nokiraḡia, benamo bavinimuni.” ");
INSERT INTO snc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Benamo ekiraiato, ekirato, “Kara bonoḡiguni dagarana bavinimuni, ḡegu Basileia tavina bonoḡiguni maki bavinimuni.” ");
INSERT INTO snc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Benamo eraka-rosito, sinana edanaḡiato, ekirato, “Kara banasi?” Sinana na evaḡa-veseato, ekirato, “Ioane Babatiso debana, bonosi!” ");
INSERT INTO snc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Benamo mo ḡuiato ma eraga-ḡenoḡoito, benamo vere barana Heroda enoḡiato, ekirato, “Au aurani inimoḡo Ioane Babatiso debana diḡu ai novinigu.” ");
INSERT INTO snc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Vere barana ma evetuḡamaḡi-ḡenoḡoito, senaḡi asi eurato bene kira-sirivaḡi, korana ḡena varivari tarimari ḡoirari ai ekiraḡi-toreato bene. ");
INSERT INTO snc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Maoromaoro vere barana Heroda na tarima debari ebasi-ḡuturito-ḡoi tarimana ta etuḡuato, Ioane debana bene ḡwa-iaḡomaia ḡana. Benamo ḡia eiaḡoto, Ioane Babatiso dibura numanai debana ebasi-ḡutuato. ");
INSERT INTO snc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Benamo diḡu ai eḡwa-ḡenoḡoiato, benamo mo ḡuiato ema viniato. Ḡia na sinana eviniato. ");
INSERT INTO snc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioane ḡena mero na mo vari ḡeseḡaḡiato, benamo ḡeiaḡoto, tauḡanina ḡea ḡabiato, benamo gara gabunai ḡea guriato. ");
INSERT INTO snc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo tarimari ma ḡeḡenoḡoito Iesu ḡenai, benamo kara ḡeveito e ḡevevaḡa-riba iaḡirito dagarari mabarari ḡekira-varaiato. ");
INSERT INTO snc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iesu na evaḡa-guruḡarito, ekirato, “Gabu fakana ta ḡana si-iaḡosi, ḡoa iaḡaraḡi kotuna.” Korana tarimarima vovoka ḡeiaḡomato-ḡoi ema mainana ḡeiaḡoto-ḡoi, be ḡia maki asi ilaila beḡene iaḡaraḡi o beḡene ḡaniḡani. ");
INSERT INTO snc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Benamo mabarari ḡasi tai ḡeraḡeto, gabu fakana ta ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Senaḡi tarimarima ḡutuma na ḡeḡitarito, ḡeribato aiḡana ḡeiaḡoni. Benamo vanuḡa tata tarimarimari mabarari kwakuri na ḡeraka-ragaraga-iaḡoto, mo gabu ai ḡea raḡasi-guineto. ");
INSERT INTO snc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu ḡasi na eraka-riḡoto nai, tarimarima vovoka lelevaḡi eḡitarito, benamo evetuḡarito, korana ḡia tu noḡa moḡo mamoe asi ḡitaḡauri tarimana ta noḡa. Benamo ḡia na dagara vovoka evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Elavilavito-ḡoi nai, Iesu ḡena mero ḡia ḡenai ḡeiaḡoto, benamo ḡekirato, “Mai tu gabu fakana e ḡaro maki mo evariḡoni. ");
INSERT INTO snc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Notuḡu-rakari, vamoka vei tarimari ḡeri tanu gaburi e vanuḡa kavinaḡiri ḡana ḡeiaḡo, be ḡari ḡaniḡani ḡea voi.” ");
INSERT INTO snc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Senaḡi Iesu na evaḡa-veserito, ekirato, “Ḡomi na ḡaniḡani tari ḡoviniri.” Benamo ḡia na ḡedanaḡiato, ḡekirato, “Ḡoi ourani tu ḡaiaḡo, beredi silva moniri sinau ruarua (200) na ḡavoiri, benamo ḡama-ḡuburi otoni?” (Mai tu tarima ta davana ḡue imaima toitoi (8) nuḡanai beḡabini kavana). ");
INSERT INTO snc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu na ekirarito, ekirato, “Ḡomi ḡemi ai beredi tu vira maniḡeri? Ḡoiaḡo, ḡoa ḡitari.” Ḡea ḡitarito, benamo ḡekirato, “Beredi imaima, maḡani-kone ruarua maki.” ");
INSERT INTO snc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iesu na ḡena mero evaḡa-guruḡarito, tarimarima beḡene vareri, doḡoro doḡoro ai ḡauḡa iatari ai beḡene tanutanu-tari. ");
INSERT INTO snc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Benamo doḡoro loriri ai ḡetanuto, tari sinau sebori (100), tari gabana imaimari (50). ");
INSERT INTO snc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Benamo Iesu na mo beredi imaima e maḡani-kone ruarua eḡabirito, eboḡe-raḡeto, gubai eḡitaiato, Barau evaḡa-namoato vau, beredi etavi-kirakirarito, benamo ḡena mero evinirito beḡene vareri ḡana. Maḡani-kone ruarua maki moḡesina edudu-ḡutuḡuturito. ");
INSERT INTO snc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tarimarima mabarari ḡeḡani-maseto. ");
INSERT INTO snc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Murinai vau Iesu ḡena mero na beredi kwari e maḡani-kone kwari mabarari ḡevaḡa-vegogo-rito, boseḡa gabanana ruarua (12) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ḡeḡaniḡanito tauri mabarari tu 5,000. ");
INSERT INTO snc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Maoromaoro Iesu na ḡena mero ḡasi ai evaḡa-raḡerito, benamo etuḡu-guinerito kou tavi tai Betesaida ḡana, ma ḡia tu mo tarimarima ḡutuma roḡo etuḡu-lausirito. ");
INSERT INTO snc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Benamo etuḡu-lausirito murinai, ḡoro ḡana evaraḡeto ḡuriḡuri. ");
INSERT INTO snc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Emukuna-mukunato-ḡoi nai, ḡasi tu kou nuḡanai, a Iesu tu ḡereḡana tano ai. ");
INSERT INTO snc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Benamo ḡena mero eḡitarito, ḡevekwaraḡi rakavato-ḡoi levai, korana iavara tu ḡoirari na eiaḡomato-ḡoi. Benamo Iesu ḡeri ai eraka-iaḡoto nanu iatana na, ḡasi bene raka-vanaḡia etato. Mo tu horaḡauna 3 ema 6 koloko vefakanai boḡiboḡi rekenai. ");
INSERT INTO snc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Senaḡi ḡena mero na ḡeḡitaiato, nanu iatanai erakato-ḡoi, ḡetuḡamaḡito, ḡekirato, “Murava ta!” ḡetato. Benamo ḡeḡaba-fouto, ");
INSERT INTO snc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","korana mabarari na ḡeḡitaiato e ḡegari-rakavato. Senaḡina Iesu na eraga-vaḡa-guruḡarito, ekirato, “Ḡokokore, mai tu au, asi ḡogari!” ");
INSERT INTO snc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Benamo ḡasi ai eraḡekauto, ema iavara maki edokoto. Ḡena mero ḡeḡaba-rakavato, ");
INSERT INTO snc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","korana tu mo beredi evaḡa-ḡutumarito nuḡa-farevaḡi veiḡana anina roḡosi ḡere tuḡamaḡi-doḡaria, nuḡari roḡo bubu nai. ");
INSERT INTO snc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Benamo ḡasi ai kou na ḡevanaḡito, Genesareta tanonai ḡeraḡasito. Ḡeri ḡasi monai ḡebaru-tariato. ");
INSERT INTO snc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Benamo ḡasi na ḡeraka-vaḡito nai, maoromaoro tarimarima na ḡeḡita-leaiato, ḡeribato mo tu Iesu. ");
INSERT INTO snc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Benamo mo tano mabarana ḡeraga-ḡauato, benamo ḡeri keve tarimari ma gedari ḡesi Iesu ainai ḡeseḡaḡiato-ḡoi gaburi ḡana ḡeḡwa-iaḡorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu na eiaḡo-vinirito-ḡoi gaburi mabarari ai, vanuḡa barari ai, vanuḡa keiri ai, vamoka vei tarimari ḡeri tanu gaburi ai, ḡeri keve tarimari maketi gaburi ai ḡetorerito-ḡoi, benamo ḡenoḡiato-ḡoi, ḡena dabuḡa rikinai moḡo maki beḡene veḡabikau. Ḡeveḡabikauto-ḡoi tarimari tu ḡenamoto-ḡoi e ḡemaḡurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisea tarimari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari kota Ierusalema na ḡeiaḡomato, Iesu ḡevegogo-ḡeḡeraḡiato. ");
INSERT INTO snc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Benamo ḡena mero ḡeḡitarito, ḡeḡaniḡanito-ḡoi kota ḡimari ma “mirori” ḡesi, ḡimari asi ḡeḡuriḡirito ḡia seneri vereri ḡeri vevaḡa-naḡi ilailanai. ");
INSERT INTO snc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Boḡono riba, Farisea tarimari e Iuda tarimari mabarari tu asi roḡo beḡe ḡaniḡanini, senaḡi ḡimari roḡo beḡe ḡuriḡirini murinai vau beḡe ḡaniḡanini. Mai tu ḡia seneri vereri na ḡevaḡa-moḡoniato ema ḡevei-iaḡomaiato-ḡoi veiḡana. ");
INSERT INTO snc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maketi gaburi na beḡe iaḡomani maki asi roḡo beḡe ḡaniḡanini, senaḡi beḡe veḡuriḡi-guineni vau. Seneri ḡeri vevaḡa-naḡi vovoka kotari maki ḡekorana-iaḡirito-ḡoi, kapusi ḡuriḡi, ḡuro, ketolo e geda maki ḡeḡuriḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Moḡesi nai Farisea tarimari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na Iesu ḡedanaḡiato, ḡekirato, “Karase nai ḡemu mero na senera vereri ḡeri vevaḡa-naḡi asi ḡekorana-iaḡirini, ḡimari ma ‘mirori’ ḡesi ḡeḡaniḡanini?” ");
INSERT INTO snc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu na evaḡa-veserito, ekirato, “Isaia na eperoveta-iaḡimito ḡofaḡofa tarimami tu moḡoni, maiḡesi etoreato, ‘Mai besena tu mururi koriri ai moḡo au ḡegubakauguni ḡeri Barau, senaḡina ḡia nuḡari tu manaḡa rakava. ");
INSERT INTO snc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ḡetoma-rakariḡo vini-kavaguni, ḡeri vevaḡa-riba tu tarimarima ḡeri vevaḡa-naḡi taravaturi, a dia au ḡegu!’ ");
INSERT INTO snc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ḡomi na Barau ḡena taravatu tu ḡoraga-kwanerini, benamo tarimarima ḡeri vevaḡa-naḡi ḡokorana-iaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iesu na ma ekirarito, “Moḡoni, ḡomi na Barau ḡena taravatu ḡotuḡamaḡi-fitoḡarini, tauḡemi ḡemi vevaḡa-naḡi boḡono korana-iaḡiri ḡana. ");
INSERT INTO snc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose ekirato, ‘Tamami sinami boḡono gubakauri. Dei na tamana o sinana guruḡa rakavari eviniani tarimana tu boḡono vaḡi-masea.’ ");
INSERT INTO snc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Senaḡi ḡomi ḡokirani, tarima ta na tamana o sinana bevaḡa-guruḡaiani, bekirani, ‘Au na ḡomi asi bavaḡa-kavamini, korana bara vinimi dagarana tu au na Koban aviniani nai.’ Koban anina tu Barau ḡena. ");
INSERT INTO snc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Moḡesi veiḡai ḡomi na tarima ḡokouani, tamana e sinana asi bene vaḡa-kavari ḡana. ");
INSERT INTO snc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ḡomi na senemi ḡeri vevaḡa-naḡi ḡerina Barau ḡena guruḡa asi tauri ai moḡo ḡovaḡa-iaḡorini. Dagara vovoka moḡesi ḡoveirini.” ");
INSERT INTO snc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Benamo Iesu na tarimarima ḡutuma ma ekea-vegogorito ḡenai, benamo ekirarito, ekirato, “Mabarami ḡoseḡaḡi ema boḡono riba-maoro. ");
INSERT INTO snc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tarimarima murika na ḡeḡanirini, ḡevariḡoni tarima nuḡari ḡana, dagarari na tarima asi ḡevaḡa-rakavarini, senaḡi tarimarima nuḡari o loruri ḡuturi na ḡemaraḡeni dagarari na vau tarimarima ḡevaḡa-rakavarini. ");
INSERT INTO snc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16"," Ma seḡana tarimana bene seḡaḡi!” ");
INSERT INTO snc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu na mai tarimarima ḡutuma eraga-kwanerito, numai eraḡekauto; benamo ḡena mero na mo barabore anina ḡevedanaḡi-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu na evaḡa-guruḡarito, ekirato, “Ḡomi maki asi ḡotuḡamaḡi-fakani? Asi ḡoribani, murika na ḡevariḡoni dagarari na tarimarima asi ḡevaḡa-rakavarini? ");
INSERT INTO snc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Korana mo tu dia loruna na ḡevariḡoni, senaḡina sinaḡena na ḡevariḡoni, be ḡeiaḡoni moḡo.” Moḡa anina tu, ḡia na ḡaniḡani mabarari evaḡa-moḡonirito, asi ḡeri rakava. ");
INSERT INTO snc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Benamo ma ekirato, “Kara tarimarima loruna na emaraḡeni, monana tarimarima evaḡa-rakavaiani, ");
INSERT INTO snc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","korana tarima loruna na tuḡamaḡi rakavari, kima veiḡari, lema, vaḡivaḡi, ");
INSERT INTO snc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","veḡura-vanaḡi, mata-ḡaniḡani, veiḡa rakavari mabarari, ḡofaḡofa, mata-boraḡa, mama, vevaḡa-bade, veiavi, vei-babobabo ḡeiaḡomani. ");
INSERT INTO snc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mabarari dagara rakavari, maiḡeri loruna na ḡemaraḡeni, tarima ḡevaḡa-rakavarini.” ");
INSERT INTO snc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu monana evariḡisito, Taia e Sidono tanori ḡana eiaḡoto. Benamo numa tai ea raḡekau-ḡairito, ḡia asi eurato tarima ta na bene ribaia ḡia tu monai, senaḡi asi ḡena vekuretoḡa dabarana. ");
INSERT INTO snc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vavine ta, natuna ḡuiatona iauka rakavana na eboroḡiato, Iesu varina eseḡaḡiato nai, eiaḡoto, kwakuna koranai evetui-tarito. ");
INSERT INTO snc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mo vavine tu Grik vavinena, Siriafonesia ai emaḡurito. Benamo ḡia na Iesu enoḡiato, mo iauka rakavana natuna ḡuiatona ḡenana bene lai-vaḡia. ");
INSERT INTO snc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Benamo Iesu na ekiraiato, ekirato, “Mero misiri roḡo beḡene ḡani-mase guine, korana asi maoro, mero misiri ḡari ḡaniḡani bita ḡabirini, kwaiva bita fiu-vinirini.” ");
INSERT INTO snc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vavine na ma evaḡa-veseato, ekirato, “Vereḡauka, mani tu moḡoni, senaḡi kwaiva maki fata gaburenai mero misiri ḡeḡaniḡanini momori tu ḡeḡanirini.” ");
INSERT INTO snc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Benamo ḡia na mo vavine ma evaḡa-guruḡaiato, ekirato, “Maniḡesi bovaḡa-vese dainai, noḡenoḡoi, iauka rakavana tu natumu ḡenana beraka-vaḡi.” ");
INSERT INTO snc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Benamo mo vavine eḡenoḡoito ḡena numa ḡana nuḡanai, natuna ḡuiatona ea doḡariato, ḡena gedai egena-taḡoto-ḡoi eḡitaiato, iauka rakavana tu moḡoni eraka-vaḡito. ");
INSERT INTO snc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Benamo Iesu Taia tanona eraga-kwaneato, Sidono e Vanuḡa Gabanana (10) tanori eraka-vanaḡirito, Galilea kou ai eraḡasito. ");
INSERT INTO snc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Benamo tarima kotari na seḡa-bubu e asi eguruḡa-ginikauto-ḡoi tarimana ta ḡeḡabi-iaḡoato, benamo ḡenoḡiato, ḡimana iatanai bene tore-kaua. ");
INSERT INTO snc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Benamo Iesu na tarimarima ḡutuma nuḡari na eḡori-veḡitaiato, didina seḡana kouḡanai eduḡi-toḡarito, ekanunuto, benamo meana eḡabi-karaiato. ");
INSERT INTO snc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gubai eboḡe-raḡeto, eiaḡa-raḡeto ma ḡabana ḡesi, ekirato, “Efata!” anina tu “Noḡwa-faka!” ");
INSERT INTO snc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Benamo seḡana ḡeḡwa-fakarito, meana everuḡato, eroroḡototo, benamo eguruḡa-ḡitakauto. ");
INSERT INTO snc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu na ekirarito, tarima ta asi beḡene kira-varaia, senaḡi ekirarito-ḡoi guruḡari tu asi ḡeseḡaḡiato-ḡoi, ḡia varina tu ḡefiu-rovorovoato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tarimarima nuḡari ḡefarevaḡi-rakavato, ḡekirato, “Ḡia na dagara mabarari evei-ḡitakaurini, seḡa-bubu tarimari evaḡa-seḡaḡirini, muru-bubu tarimari evaḡa-guruḡarini.” ");
INSERT INTO snc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mo negai tarimarima ḡutuma lelevaḡi ma ḡevegogo-ḡenoḡoito. Ḡia asi ḡari ḡaniḡani nai, Iesu na ḡena mero ekea-kavirito sevina ḡana, benamo evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Au na mai tarimarima avetuḡarini, korana mai tu ḡaro toitoi veḡata au ḡesi maiḡeri, nuḡanai tu asi ḡari ḡaniḡani. ");
INSERT INTO snc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bema au na batuḡu-ḡenoḡoirini ḡeri vanuḡa ḡana ma vitori ḡesi nai, dabarai beḡe borimarini, korana kotari tu gabu manaḡa na ḡeiaḡomato nai.” ");
INSERT INTO snc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Benamo ḡena mero na ḡevaḡa-veseato, ḡekirato, “Kamara dabarai tarima ta na mai tarimarima beredi na beḡuburini mai tano fakanai?” ");
INSERT INTO snc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Benamo Iesu na edanaḡirito, ekirato, “Ḡomi ḡemi ai beredi tu vira?” Ḡia ḡevaḡa-veseto, ḡekirato, “Imaima ruarua (7).” ");
INSERT INTO snc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu na vegogo tarimari evaḡa-guruḡarito, tano ai ḡetanutanu-tari. Benamo beredi imaima ruarua (7) eḡabirito, Barau evaḡa-namoato, ebuki-ḡuturito, ḡena mero evinirito, mo tarimarima ḡoirari ai beḡene toretore-tariri ḡana. Benamo moḡesi ḡeveirito. ");
INSERT INTO snc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ḡia ḡeri ai maki maḡani-kone misiri kotari. Iesu na Barau ma evaḡa-namoato, ḡena mero ekirarito, moḡeri maki ḡevareri. ");
INSERT INTO snc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Benamo tarimarima ḡeḡani-maseto murinai, Iesu ḡena mero na ḡaniḡani kwari ḡegogorito, boseḡa mabarari imaima ruarua (7) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tarimarima mabarari tu 4,000 kavana. Benamo Iesu na etuḡu-rovorovorito, ");
INSERT INTO snc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma ḡia ema ḡena mero ḡesi ḡasi ai ḡeraḡeto, Dalmanuta tanona ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisea tarimari kota Iesu ḡenai ḡeiaḡoto, benamo ḡedanaḡi-ribaḡaniato. Ḡeri ura vetoḡa ta guba na bene mariḡo. ");
INSERT INTO snc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu iaḡana eḡaniato ma nuḡa metona ḡesi, benamo ekirato, “Karase nai toma ḡuru tarimari na vetoḡa ḡeḡita-vetaurini? Moḡoni akiramini, vetoḡa ta asiḡina ḡinavaḡi bavinimini!” ");
INSERT INTO snc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Benamo eraga-kwanerito, ḡasi ai ma eraḡeto, kou tavi ta ḡana ea vanaḡito. ");
INSERT INTO snc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesu ḡena mero ḡevetuḡa-rekwato, ḡaniḡani asi ḡeḡabikauto, beredi sebona moḡo ḡasi ai. ");
INSERT INTO snc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Benamo Iesu na esisiba-vinirito, ekirato, “Lorimi boḡono vetore, Farisea tarimari e Heroda ḡari farao evaḡa-tubuani muramurana garina.” ");
INSERT INTO snc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Benamo mo guruḡa tauḡeri fakari ai ḡeverori-iaḡiato, ḡekirato, “Moḡesina bekira, korana ḡita tu asi ḡara beredi nai.” ");
INSERT INTO snc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu na eribarito, benamo evaḡa-guruḡarito, ekirato, “Karase nai beredi ta sevimi ai asiḡi guruḡana ḡoveini? Ḡomi roḡosi boḡono riba, roḡosi boḡono tuḡamaḡi-faka? Nuḡami maki roḡo bubu? ");
INSERT INTO snc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma matami, senaḡi asi ḡoḡitani? Ma seḡami, senaḡi asi ḡoseḡaḡini? Asi ḡovetuḡamaḡi-taḡoni maki? ");
INSERT INTO snc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Au na beredi imaima abuki-ḡutuḡuturito tarimarima 5,000 ḡari nai, beredi kwari ḡogogorito tu, boseḡa vira ḡovaḡa-vonurito?” Ḡia ḡevaḡa-veseto, ḡekirato, “Gabanana ruarua (12).” ");
INSERT INTO snc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Au na beredi imaima ruarua (7) abuki-ḡutuḡuturito tarimarima 4,000 ḡari nai, beredi kwari ḡogogorito tu boseḡa vira ḡovaḡa-vonurito?” Ḡia ḡevaga-veseto, ḡekirato, “Imaima ruarua (7).” ");
INSERT INTO snc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Benamo Iesu na ekirarito, “Ḡomi roḡosi boḡono tuḡamaḡi-faka?” ");
INSERT INTO snc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ḡia Betesaida ḡana ḡeiaḡoto, benamo tarima kotari na mata-bubu tauna ta Iesu ḡenai ḡeḡori-iaḡoato, benamo ḡenoḡiato, bene ḡabi-karaia. ");
INSERT INTO snc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Benamo Iesu na mata-bubu tauna ḡimanai eḡabito, eḡori-rosiato vanuḡa na, benamo matana ekanunuato, ma ḡimana ḡenai etore-kaurito, edanaḡiato, “Dagara tari oḡitarini ba?” ");
INSERT INTO snc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mo tarima eboḡe-vaisito, ekirato, “Oi, tarima tari aḡitani, senaḡina noḡa moḡo ḡau noḡa ḡerakao-rakaoni.” ");
INSERT INTO snc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Benamo Iesu ḡimana matanai ma etore-kaurito, benamo eboḡeboḡe-ginikauto, dagara mabarari eḡita-ginikaurito. ");
INSERT INTO snc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Benamo Iesu na numa ḡana etuḡu-iaḡoato, evaḡa-guruḡaiato, ekirato, “Vanuḡa nuḡana na asi bono iaḡo.” ");
INSERT INTO snc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ma ḡena mero ḡesi Kaisarea Filipi tanona vanuḡari ḡana ḡeiaḡoto-ḡoi nuḡanai, dabarai Iesu na ḡena mero edanaḡirito, ekirato, “Tarimarima tu kara ḡetoni au tu dei?” ");
INSERT INTO snc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ḡia ḡevaḡa-veseto, ḡekirato, “Kotari ḡekirani tu Ioane Babatiso, ma kotari tu Elia, ma kotari tu peroveta tarimana ta.” ");
INSERT INTO snc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu na edanaḡirito, ekirato, “Senaḡi ḡomi tu kara ḡotoni au tu dei?” Petero na evaḡa-veseato, ekirato, “Ḡoi tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna).” ");
INSERT INTO snc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Benamo Iesu na evaḡa-guruḡarito, tarima ta asi beḡene kira-varaia. ");
INSERT INTO snc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Benamo Iesu na ḡena mero ma evaḡa-ribarito, ekirato, “Tarimarima Natuna tu midigu vovoka roḡo beḡanini. Iuda vereri, e Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiani tarimari na beḡe ruḡaiani; ema beḡe vaḡi-maseani maki, senaḡina ḡaro toitoi murinai mase na ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mai guruḡa ekiraḡi-foforiato, benamo Petero na eḡori-veḡitaiato, ekira-ḡoiato. ");
INSERT INTO snc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Senaḡi Iesu eruḡa-kureto, ḡena mero eḡitarito, ḡia na Petero ekira-ḡoiato, ekirato, “Satani, noraka-veḡita, korana ḡemu tuḡamaḡi tu dia Barau ḡena, senaḡi tarimarima ḡeri moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu na tarimarima ḡutuma ma ḡena mero ḡesi ekea-vegogorito, benamo evaḡa-guruḡarito, ekirato, “Bema tarima ta eurani au murigu ai bene raka etoni tarimana, tauḡena bene veruḡa, ḡena satauro bene ḡwaia, au murigu ai bene raka. ");
INSERT INTO snc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Korana deikara ḡena maḡuri moḡo lorina etoreani tarimana, ḡena maḡuri befitoḡaiani. A deikara au daigu ai e Vari Namona dainai ḡena maḡuri befitoḡaiani tarimana, ḡena maḡuri asi bevei-rekwarekwaiani. ");
INSERT INTO snc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bema tarima ta na tanobara mabarana uranai ḡena maḡuri befitoḡaiani, ḡena namo tu kara ḡia ḡenai? ");
INSERT INTO snc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Korana tarima ta ḡena maḡuri efitoḡaiato nai tu, kara na vau ma bevoi-ḡenoḡoiani? ");
INSERT INTO snc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Deikara na au bemaiaka-viniguni ema ḡegu guruḡa bemaiaka-viniani mai veḡura-vanaḡi e vei-rakava tarimari ḡoirari ai, ḡia maki Tarimarima Natuna na bemaiaka-viniani ḡena iaḡomai, ḡia Tamana mamana marevana e seḡuka baregona e ma ḡena aneru veaḡari ḡesi beḡe iaḡomani ḡaronai.” ");
INSERT INTO snc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Benamo ekirarito, ekirato, “Moḡoni akiramini: Tarima kotari mai ḡeruḡa-taḡoni tu asi roḡo beḡe maseni, beiaḡoni mo, Barau ḡena Basileia ma seḡukana ḡesi beiaḡomani beḡe ḡitaiani.” ");
INSERT INTO snc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ḡaro imaima sebona (6) ḡevanaḡito murinai, Iesu na Petero, e Iakobo (o Iames), ema Ioane eḡabirito, benamo ḡoro baregona tai eḡori-raḡerito. Monai ḡia ḡereḡari moḡo nuḡanai Iesu ḡeḡitaiato, vetoḡana eirauto, ");
INSERT INTO snc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ema ḡena dabuḡa ekuro-ḡaroḡaroto, tanobarai tarima ta na asi ilaila moḡesina bevaḡa-kurokuroani. ");
INSERT INTO snc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Benamo ḡia ḡoirari ai Elia ma Mose ḡefoforito, Iesu ḡesi ḡeguruḡa guruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Benamo Petero na Iesu evaḡa-guruḡaiato, ekirato, “Vevaḡa-riba tarimamu o, namo vedaurea ḡita tu maiḡera, be fouta toitoi ḡaragari. Ta ḡoi ḡemu, ta Mose ḡena, ta Elia ḡena.” ");
INSERT INTO snc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petero asi ribana kara bekiraḡiani, korana ḡia tu ḡegari-rakavato. ");
INSERT INTO snc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Benamo magube na ema iauka-taririto, ekumu-ḡaurito nuḡanai, garo ta magube nuḡana na ekea-rosito, ekirato, “Mai tu au Natugu, aura-viniani; ḡia boḡono seḡaḡi-vinia!” ");
INSERT INTO snc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ḡia na mo gabu ḡeraga-ḡita-ḡeḡeraḡiato, senaḡi ta asi ḡeḡitaiato ḡia ḡesi, Iesu moḡo ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ḡoro na ḡemariḡoto-ḡoi nuḡanai, Iesu na evaḡa-guruḡarito, kara ḡeḡitaiato dagarana tarima ta asi beḡene kira-varaia, bene iaḡo mo, Tarimarima Natuna mase na ma bene variḡisi-ḡenoḡoi. ");
INSERT INTO snc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Moḡa lorinai ḡena guruḡa fakari ai moḡo etanuto, senaḡi ḡia fakari ai ḡeverorito, mai mase na variḡisi-ḡenoḡoi anina tu kara. ");
INSERT INTO snc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Benamo ḡia na Iesu ḡedanaḡiato, ḡekirato, “Karase nai taravatu ḡevevaḡa-riba iaḡiani tarimari ḡekirani, Elia tu beiaḡoma-guineni?” ");
INSERT INTO snc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu evaḡa-veseto, ekirato, “Moḡoni, Elia tu beiaḡoma-guineni, dagara mabarari bevaḡa-variḡurini. A Tarimarima Natuna guruḡana kamasi ḡetoreato midigu vovoka beḡanini e beḡe ḡita-fitoḡaiani? ");
INSERT INTO snc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Senaḡi akiramini, Elia tu varau eiaḡomato, ema ḡeri ura veiḡari ḡia ḡenai varau ḡeveirito, ḡia guruḡana Buka Veaḡai ḡetore-guineato ilailanai.” ");
INSERT INTO snc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ḡena mero ḡeri ai ḡevotuto tu, tarimarima ḡutuma lelevaḡi na ḡeruḡa-ḡeḡeraḡirito, ḡeḡitarito, taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari maki ḡia ḡesi ḡeveḡare veḡareto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tarimarima na Iesu ḡeḡitaiato nai, nuḡari ḡefarevaḡito, benamo ḡenai ḡeraga-iaḡoto, ḡea vaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu na edanaḡirito, ekirato, “Mai tarima ḡesi tu kara veḡare-veḡarena ḡoveini?” ");
INSERT INTO snc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Benamo tarima ta ḡutuma nuḡari na evaga-veseto, ekirato, “Vevaḡa-riba tarimamu, au natugu ḡoi ḡemu ai baḡori-iaḡomaia. Ḡia tu muru-bubu iaukana na eboroḡiato nai, asi eguruḡani. ");
INSERT INTO snc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma mai iauka na eḡabiani ḡarori ai, tano ekwaraḡi-iaḡiani. Bokana na kaburoburo ḡeraka-rosini, gadikana eveḡara-tarini, tauḡanina egwaḡiḡini. Moḡa lorinai ḡoi ḡemu mero banoḡiri, mai iauka rakavana ḡelai-vaḡia basi, senaḡi beḡe lai-kavaia.” ");
INSERT INTO snc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Benamo Iesu ekirato, “Asi veḡabidadama tarimami! Ḡaro vira au ḡomi sevimi ai bana tanu? Ḡaro vira bana vevaḡa-gwaḡiḡi vinimi? Ḡoḡori-iaḡomaia!” ");
INSERT INTO snc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Benamo mo mero Iesu sevina ḡana ḡeḡori-iaḡoato. Iauka rakavana na Iesu eḡitaiato nai, vaḡa-sebo mero evaḡa-ḡoḡo-ḡoḡoato, tano ai eketoto, egena-vebiro vebiroto, bokana na kaburoburo ḡeraka-rosito. ");
INSERT INTO snc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu na mero tamana edanaḡiato, ekirato, “Aitoma mai keve edoḡariato?” Tamana evaḡa-veseto, ekirato, “Mai tu keina na veḡata! ");
INSERT INTO snc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nega vovoka iauka rakavana na karavai efiu-kauani, ema nanu ai efiu-reiani bene vaḡia ḡana. Bema dagara ta boveiani riba nai, mani ḡemu veiḡa, boro vetuḡa-ḡwama, boro vaḡa-kavama.” ");
INSERT INTO snc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Benamo Iesu ekirato, “Bema dagara ta boveiani riba otoni? Barau ḡenai eveḡabi-dadamani tarimana dagara mabarari beveirini riba.” ");
INSERT INTO snc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Benamo mero tamana asikauna eḡaba-fouto, ekirato, “Au aveḡabidadamani, senaḡi ḡegu tuḡamaḡi iauvoiauvo noma boroḡia.” ");
INSERT INTO snc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu na tarimarima ḡutuma ḡeraga-vegogoto-ḡoi eḡitarito nai, ḡia na mo iauka rakavana ekira-ḡoiato, ekirato, “Muru-bubu e seḡa-bubu iaukana, akiramuni, noraka-vaḡi, ma nuḡanai asi ma bono raka-toḡa ḡenoḡoi!” ");
INSERT INTO snc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Benamo iauka rakavana eḡaba-fouto, ḡia na mero evaḡa-ḡoḡoḡoḡo rakavaiato, benamo eraka-vaḡito. Mero tu ḡitaḡitana noḡa emaseto, moḡa lorinai tarimarima ḡutuma ḡekirato, “Mai tu bemase.” ");
INSERT INTO snc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Senaḡi Iesu na ḡimanai eḡabito, einu-vaisiato, benamo eruḡa-vaisito. ");
INSERT INTO snc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Moḡa murinai Iesu numai eraḡekauto, ḡena mero na vekuretoḡai ḡedanaḡiato, ḡekirato, “Karase nai ḡai na iauka rakavana asi ilaila baḡa lai-vaḡia?” ");
INSERT INTO snc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Benamo Iesu na evaḡa-veserito, ekirato, “Iauka maiḡesina lailairi tu kara ta asiḡina, senaḡina ḡauḡau e ḡaniveaḡa ḡereḡana moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mo gabu ḡeraga-kwaneato, Galilea tanona na ḡevanaḡito. Iesu asi ḡena ura tarima ta bene riba ḡia tu ainai, ");
INSERT INTO snc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","korana ḡena mero evaḡa-ribarito, ekirato, “Tarimarima Natuna tu beḡe revaiani vau, tarimarima ḡimari ai beḡe toreani, benamo beḡe vaḡi-maseani, senaḡi beḡe vaḡiani nai, ḡaro toitoi murinai tu ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Senaḡi ḡia tu asi ḡeriba-maoroto Iesu tu kara ekiraḡiato, senaḡi asi ma ḡedanaḡiato, korana ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaperanaumai ḡeraḡasito, benamo Iesu na numa nuḡanai vau edanaḡirito, ekirato, “Ḡomi dabarai tu kara ḡokiraḡiani-ḡoi?” ");
INSERT INTO snc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Senaḡi ḡia tu asi ḡevaḡa-veseto, korana dabarai tu, deikara barego vedaurea ḡekiraḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu etanu-tarito, ḡena mero gabanana ruarua (12) ekearito, benamo ekirarito, ekirato, “Dei bene guine etoni tarimana tu gabi taunai bene iaḡo, ema tarimarima mabarari vetuḡunaḡiri bene iaḡo-vini.” ");
INSERT INTO snc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Benamo ḡia na mero keina ta eḡabiato, ḡia fakari ai evaḡa-ruḡa-tariato, efani-vaisiato, benamo ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dei na mero keina maiḡesina kavana beḡabi-raḡeani au aragu ai, ḡia na tu au beḡabi-raḡeguni. Bema tarima ta na au beḡabi-raḡeguni tu, dia au ḡereḡagu moḡo beḡabi-raḡeguni, senaḡi etuḡuguto Barauna maki beḡabi-raḡeani.” ");
INSERT INTO snc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane na Iesu ekiraiato, ekirato, “Vevaḡa-riba tarimamu, tarima ta ḡaḡitaiato, ḡoi aramu ai iauka rakavari elai-vaḡirito-ḡoi, senaḡi ḡai na ḡakira-ḡoiato, korana ḡia tu dia ḡita ḡesi taraka-vegogoni.” ");
INSERT INTO snc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu na ekirarito, ekirato, “Asi boḡono kira-ḡoia, korana tarima ta au aragu ai nuḡa-farevaḡi veiḡa boruri eveirini tarimana tu, au murigu ai au asi ma bekira-rakavaguni. ");
INSERT INTO snc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Korana deikara na ḡita asi evaḡa-rakavarani tarimana tu ḡita ḡesi. ");
INSERT INTO snc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Moḡoni akiramini, tarima ta na nanu kapusina au aragu ai bevinimini, korana ḡomi tu Keriso ḡena tarima nai, ḡia voina tu beḡabiani veḡata.” ");
INSERT INTO snc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Bema tarima ta na au eḡabidadama-viniguni mero misina ta ḡena veḡabidadama evaḡa-rakavaiani, ḡia tu bere namo fore baregona ta ḡaiḡonai ḡere baru-kaua, davarai ḡere fiu-reia. ");
INSERT INTO snc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bema ḡoi ḡimamu na evaḡa-rakavamuni nai, bono basi-ḡutua. Ḡimamu sebonai maḡuri vanaḡivanaḡi bono doḡaria tu namo, a asi namo ḡimamu ruarua karava eḡara-vanaḡi vanaḡini asi ebuseni gabuna ḡana boiaḡoni. ");
INSERT INTO snc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44"," Monai ‘dimo na beḡe ḡani-vanaḡi vanaḡimini, ema karava asi ebuseni.’ ");
INSERT INTO snc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bema ḡoi kwakumu na evaḡa-rakavamuni nai, bono basi-ḡutua. Kwakumu sebonai maḡuri vanaḡivanaḡi bono doḡaria tu namo, a asi namo kwakumu ruarua karava eḡara-vanaḡi vanaḡini gabunai beḡe fiu-kaumuni. ");
INSERT INTO snc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46"," Monai ‘dimo na beḡe ḡani-vanaḡi vanaḡimini, ema karava asi ebuseni.’ ");
INSERT INTO snc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bema ḡoi matamu na evaḡa-rakavamuni nai, bono ḡibo-vaḡia. Matamu sebonai Barau ḡena Basileiai bono raka-toḡa tu namo, a asi namo matamu ruarua karava eḡara-vanaḡi vanaḡini gabunai beḡe fiu-kaumuni. ");
INSERT INTO snc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Monai ‘dimo na beḡe ḡani-vanaḡi vanaḡimini, ema karava asi ebuseni.’ ");
INSERT INTO snc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mabarari karava na bedamenarini, beiarevarini. ");
INSERT INTO snc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Damena tu namo, senaḡi bema damena mamina bekorini nai, mamina kamasi ma bovaḡa-mamina ḡenoḡoiani? Nuḡami ai damena bene tanu, e ḡomi tata karomi ḡesi maino nuḡanai boḡono tanu.” ");
INSERT INTO snc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu mo gabu eraga-kwaneato, benamo Iudea tanona ḡana eiaḡoto, Ioridana ḡarukana tavi tai evanaḡito. Tarimarima ḡutuma lelevaḡi ḡia ḡenai ma ḡeiaḡoto, benamo eveito-ḡoi kavana ma evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Benamo Farisea tarimari ma ḡeiaḡoto, benamo ḡea danaḡi-ḡofakauato, ḡekirato, “Tau ta ḡaraḡona befitoḡaiani nai, taravatu na beḡabiani?” ");
INSERT INTO snc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu na ma evaḡa-veserito, ekirato, “Mose ḡena taravatu nuḡanai kara etoni?” ");
INSERT INTO snc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ḡekirato, “Mose ḡena taravatu tu maiḡesi ekirani, veḡaraḡo ruḡaruḡana fefana betoreani vau, ḡaraḡona betuḡu-rakaiani.” ");
INSERT INTO snc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu na ekirarito, ekirato, “Mose na mai taravatu etoreato, korana ḡomi nuḡami tu roḡo bubu. ");
INSERT INTO snc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Senaḡina Barau na dagara mabarari eveirito nai, ḡia na tarimarima maki eveirito tau e vavine. ");
INSERT INTO snc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Moḡesina nai tau ta na tamana e sinana beraga-kwanerini, ḡaraḡona ḡesi beḡe tanuni. ");
INSERT INTO snc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Benamo ḡia tauri ruarua beḡe sebonani, moḡa lorinai ḡia tu dia ruarua, senaḡi sebona moḡo. ");
INSERT INTO snc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Moḡesi nai dei Barau na evaḡa-sebonarito tu, tarima ta na asi ma bene tore-kirari.” ");
INSERT INTO snc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma ḡeḡenoḡoito numai, ḡena mero na ma ḡedanaḡiato mo guruḡa anina tu kara. ");
INSERT INTO snc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu na evaḡa-veserito, ekirato, “Deikara na ḡaraḡona betuḡu-rakaiani, vavine ta ma beḡaraḡoani, ḡia tu beveḡura-vanaḡini. ");
INSERT INTO snc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vavine maki moḡesina, ḡia ḡaraḡona beraga-kwaneani, tau ta na ma beḡaraḡoani, ḡia maki beveḡura-vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tarima kotari na naturi ḡeḡwa-iaḡorito-ḡoi Iesu ḡenai bene ḡabi-karari ḡana, senaḡi ḡena mero na ḡekira-ḡoirito. ");
INSERT INTO snc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu na eḡitarito nai tu ebaruto. Benamo ḡena mero ekirarito, ekirato, “Mani mero misiri ḡeiaḡoma au ḡegu ai, asi ḡolai-ḡoiri, korana Barau ḡena Basileia tu maniḡesina kavana tarimari ḡeri. ");
INSERT INTO snc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Moḡoni akiramini, dei na Barau ḡena Basileia asi beḡabi-raḡeani mero misina na kavana, ḡia Basileiai tu asi beraka-toḡani.” ");
INSERT INTO snc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Benamo Iesu na mero misiri efaḡa-vaisirito, benamo ḡimana iatari ai etore-kaurito, evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu monana ma evaisi-raḡeto, benamo erakato nuḡanai, tarima ta ḡenai eraga-iaḡoto, benamo ḡoiranai ea vetui-tarito, edanaḡiato, ekirato, “Vevaḡa-riba tarimamu namona, au tu kara baveini vau maḡuri vanaḡivanaḡi baḡabiani?” ");
INSERT INTO snc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu na evaḡa-veseato, ekirato, “Ḡoi tu karase nai au namogu okiraḡini? Tarima ta asi namo, Barau moḡo ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Taravatu mabarari ma ribamu, ‘Asi bono vaḡivaḡi, asi bono veḡura-vanaḡi, asi bono lema, asi bono vevaḡa-daḡa ḡofaḡofa, asi bono ḡabi-kuretoḡa, tamamu sinamu bono gubakauri.’” ");
INSERT INTO snc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Benamo mo tarima ekirato, “Vevaḡa-riba tarimamu, au tu keigu na beiḡoma toma, mani taravatu mabarari akorana-iaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu na eḡitaiato ma veuravinina ḡesi ekirato, “Dagara sebona moḡo orabuni, noiaḡo, ḡemu farefare mabarari noa voivoi-iaḡiri, rabu tarimari bono viniri, benamo gubai tu ma ḡemu farefare; ma bono iaḡoma, murigu ai bonoma raka.” ");
INSERT INTO snc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mo tarima na mai guruḡa eseḡaḡiato nai, ḡoirana evaḡa-gwaḡiḡiato, nuḡana ma metona ḡesi eraka-veḡitato, korana ḡia ḡena farefare tu ḡutuma lelevaḡi. ");
INSERT INTO snc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Benamo Iesu na ḡena mero eḡita-ḡeḡeraḡirito, benamo evaḡa-guruḡarito, ekirato, “Ḡeri farefare vovoka tarimari Barau ḡena Basileiai ḡeri rakatoḡa tu gwaḡiḡi rakava.” ");
INSERT INTO snc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Benamo Iesu ḡena mero na mo guruḡa ḡeseḡaḡiato nai, nuḡari ḡefarevaḡito, senaḡi Iesu na ma evaḡa-guruḡa ḡenoḡoirito, ekirato, “Natuḡore, Barau ḡena Basileia rakatoḡana tu gwaḡiḡi rakava. ");
INSERT INTO snc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela nila kadarena na bevanaḡini tu kotuna gwaḡiḡi, senaḡi ḡena farefare vovoka tarimana Barau ḡena Basileiai ḡena rakatoḡa tu gwaḡiḡi rakava.” ");
INSERT INTO snc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Benamo ḡena mero nuḡari ḡefarevaḡi-rakavato, benamo ḡevaḡa-guruḡaiato, ḡekirato, “Be deikarari vau maḡuri beḡe ḡabiani?” ");
INSERT INTO snc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu na eḡitarito, benamo ekirato, “Tarimarima ḡeri ai tu asi ilaila, senaḡi Barau ḡenai tu ilaila, korana Barau ḡenai dagara mabarari tu ilaila.” ");
INSERT INTO snc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero na ekiraiato, ekirato, “Ḡoi ribamu, ḡai ḡema dagara mabarari tu ḡaraga-kwanerito, benamo ḡoi murimu ai ḡarakani.” ");
INSERT INTO snc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu evaḡa-veseto, ekirato, “Moḡoni akiramini, tarima ta ḡena numa eraga-kwaneato, o tarikakana merori, tobana, sinana, tamana, natuna e ḡena tano au daigu ai ema Vari Namona dainai, ");
INSERT INTO snc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ḡia mai maḡuri nuḡanai ḡena numa, tarikakana merori, tobana, sinana, natuna e tano sinau-sinau beḡoitaḡoni, ema midigumidigu maki; ema ḡaro beiaḡomani nai, maḡuri vanaḡivanaḡi bedoḡariani. ");
INSERT INTO snc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Senaḡi tarimarima ḡutuma toma ḡeguineni tu beḡe gabini, gabi tarimari tu beḡe guineni.” ");
INSERT INTO snc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu ma ḡena mero ḡesi Ierusalema ḡana ḡevaraḡeto-ḡoi, dabara na ḡeraka-iaḡoto-ḡoi, Iesu tu ḡoirari ai erakato, benamo ḡia ḡeḡaba-rakavato, ema muriri na ḡerakato tarimari maki ḡegarito. Benamo Iesu na ḡena mero gabanana ruarua (12) ma eḡori-veḡitarito, benamo ḡenai kara beḡe ḡorani dagarari ekira-vararito, ");
INSERT INTO snc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ekirato, “Ḡoseḡaḡi, ḡita tu Ierusalema ḡana tavaraḡeni. Monai Tarimarima Natuna tu Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiani tarimari ḡimari ai beḡe toreani. Ḡia na ḡena mase guruḡana beḡe vaḡa-moḡoniani, benamo irau bese (o Roma) tarimari ḡimari ai beḡe toreani. ");
INSERT INTO snc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ḡia na beḡe vaseva-vaseva iaḡiani, beḡe kanunuani, beḡe kwariani e beḡe vaḡi-maseani. Senaḡi ḡaro toitoi murinai ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Benamo Sebedaio natuna, Iakobo ma Ioane, Iesu ḡenai ḡeiaḡoto, benamo ḡekirato, “Vevaḡa-riba tarimamu, ḡai ḡaurani kara baḡa noḡimuni dagarana bono vinima.” ");
INSERT INTO snc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu na ekirarito, ekirato, “Kara ḡemi ai bana veia ḡotoni?” ");
INSERT INTO snc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Benamo ḡia na ḡevaḡa-guruḡaiato, ḡekirato, “Ḡai ḡaurani, ḡai ta aroribamu rekenai, ma ta tu kaurimu rekenai baḡana tanu ḡoi ḡemu Basileia marevana nuḡanai.” ");
INSERT INTO snc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Senaḡi Iesu na ekirarito, ekirato, “Ḡomi tu asi ribami kara ḡonoḡiani. Au na midigu bedina baniuani ḡomi maki boḡo niuni riba? Au beḡe babatisoguni babatisona ḡomi na maki boḡo ḡabiani riba?” ");
INSERT INTO snc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma ḡevaḡa-veseto, ḡekirato, “Oi.” Iesu na ekirarito, ekirato, “Moḡoni, au baniuni bedinai ḡomi maki boḡo niuni, ema au beḡe babatisoguni babatisona ḡomi maki beḡe babatisomini. ");
INSERT INTO snc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Senaḡi aroribagu rekenai o kaurigu ai boḡono tanu ḡotoni tu, dia au na bavaḡa-moḡoniani, a mai tu Barau na eḡabi-torerito tarimari ḡeri.” ");
INSERT INTO snc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mai guruḡa mero gabanana (10) ḡeseḡaḡiato nai, Iakobo e Ioane ḡebaru-vinirito. ");
INSERT INTO snc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Benamo Iesu na mabarari ekea-vegogorito, benamo evaḡa-guruḡarito, ekirato, “Ḡomi ribami, irau bese tarimari ḡeri vere na tarimarima ḡedori-naḡinaḡirini, ema ḡeri veguine-iaḡi tarimari baregori na tu ḡeri maoro seḡukari na ḡelaunaḡi-naḡirini. ");
INSERT INTO snc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Senaḡi ḡomi fakami ai moḡesina tu asi boḡono vei. Bema ta ḡomi fakami ai bene vere etoni nai tu, ḡomi mabarami vetuḡunaḡimi bene iaḡo-vini, ");
INSERT INTO snc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ema dei bene guine etoni tarimana, ḡia tu mabarari ḡeri vetuḡunaḡi tarimanai bene iaḡo. ");
INSERT INTO snc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Korana Tarimarima Natuna eiaḡomato tu, dia tarimarima na ḡia vetuḡunaḡina beḡene iaḡo-vini ḡana, senaḡina ḡia eiaḡomato tu, tarimarima vetuḡunaḡiri bene iaḡo-vini, ema ḡena maḡuri bene tore-taria, tarimarima ḡutuma bene voi-ḡenoḡoiri e bene vaḡa-maḡuriri ḡana.” ");
INSERT INTO snc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ieriko ai ḡeraḡasito, monana Iesu ma ḡena mero e tarimarima ḡutuma lelevaḡi ḡesi Ieriko ma ḡeraga-kwaneato nuḡanai, Batimeo, mata-bubu e noḡivegame tarimana, Timeo natuna, dabara rikinai etanu-taḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ḡia eseḡaḡito Iesu, Nasareta tarimana, tu ḡia sevinai, benamo ekea-fouto, ekirato, “Iesu o, Davida natuna, au novetuḡa-ḡwagu!” ");
INSERT INTO snc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tarimarima ḡutuma na ḡekira-ḡoiato, asi bene guruḡa ḡetato, senaḡi ḡia ekea-ḡiḡiraḡe ḡiḡiraḡeto-ḡoi, “Davida Natuna o, au novetuḡa-ḡwagu!” ");
INSERT INTO snc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu eruḡa-tarito, benamo ekirato, “Ḡokeaia.” Benamo ḡia na mata-bubu tarimana ḡekeaiato, ḡekirato, “Asi bono gari, novariḡisi, Iesu na ekeamuni bene.” ");
INSERT INTO snc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Benamo ḡena koudi efitoḡaiato, eburi-vaisito, Iesu sevina ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Benamo Iesu na edanaḡiato, ekirato, “Kara ḡemu naveia otoni?” Mata-bubu tarimana evaḡa-veseto, ekirato, “Vevaḡa-riba tarimamu, matagu noma keo-fakaia.” ");
INSERT INTO snc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Benamo Iesu ekirato, “Noiaḡo, ḡemu veḡabidadama na bevaḡa-namomu.” Benamo asikauna matana enamoto e eboḡeboḡe-ginikauto, benamo Iesu murina na dabara na eraka-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ḡeraka-iaḡoto-ḡoi, Ierusalema ḡekavinaḡiato-ḡoi, ma Betefage e Betania ai ḡeraḡasito Olive Ḡorona rekenai, benamo Iesu na ḡena mero ruarua etuḡu-guinerito, ");
INSERT INTO snc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ekirarito, ekirato, “Ḡoiaḡo, ḡoira vanuḡana ḡana. Boḡo raḡasini nai, doniki natuna ta barutarinai boḡo ḡitaiani, iatanai tarima ta roḡosi bene raḡe. Boḡono ruḡaia, benamo boḡono ḡori-iaḡomaia. ");
INSERT INTO snc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bema tarima ta na bedanaḡimini, bekirani, ‘Ḡomi tu karase nai maniḡesi ḡoveiani?’ betoni nai, boḡono kiraia, ‘Vereḡauka na eura-viniani, vau ma betuḡu-ḡenoḡoiani.’” ");
INSERT INTO snc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Benamo ḡerakato, ḡeiaḡoto, doniki natuna ḡea ḡoitaḡoato numa ta ḡoiranai barutari. Ḡeruḡaiato-ḡoi nuḡanai, ");
INSERT INTO snc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","monai ḡeruḡa-taḡoto-ḡoi tarimari na ḡedanaḡirito, ḡekirato, “Ḡomi tu karase nai mani doniki natuna ḡoruḡaiani?” ");
INSERT INTO snc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Benamo ḡevaḡa-veserito Iesu na ekirarito kavana, vau ḡetuḡu-rakarito. ");
INSERT INTO snc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","8","Benamo doniki natuna Iesu ḡenai ḡeḡori-iaḡoato, ḡeri dabuḡa barari doniki doḡenai ḡeiava-kaurito, benamo Iesu etanukauto. 8 Tarimarima ḡutuma ḡeri dabuḡa barari dabarai ḡeiavarito. Kota tu ḡau lauri boḡai ḡebasito, benamo dabarai ḡetorerito. ");
INSERT INTO snc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ḡoirai e gabi ai ḡerakato tarimari mabarari na ḡevone-raḡeato-ḡoi, ḡekirato, “Hosana, Vereḡauka aranai eiaḡomani tarimana sivaḡa-namoa! ");
INSERT INTO snc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Davida ḡita Tamara ḡena Basileia eiaḡomani, sivaḡa-namoa! Hosana guba tuḡunai!” ");
INSERT INTO snc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Ierusalemai eraḡasito nai, Rubu Veaḡa nuḡanai eraka-toḡato, dagara mabarari eḡita-vaḡa-ḡaurito. Senaḡi elavilavito nai, ḡia ma ḡena mero gabanana ruarua (12) ḡesi ḡeraka-rosito, Betania ḡana ma ḡeḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma elaḡanito, ḡia na Betania ḡeraga-kwaneato, ḡeraka-iaḡoto-ḡoi nuḡanai, Iesu evitoato. ");
INSERT INTO snc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eboḡeto, figi ḡauna ma launa ta eḡitaiato fakana kota manaḡai, benamo eiaḡoto, nea ḡitaia ma tauna ba asiḡina. Monai ea raḡasito tu, ḡwana ta asi edoḡariato, launa korina moḡo, korana ḡena ḡwa ḡarona roḡo nai. ");
INSERT INTO snc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Benamo Iesu na figi ḡauna ekiraiato, ekirato, “Ḡoi ḡwaḡwamu tarima ta na asi ma beḡaniani, toma beiaḡoni vanaḡivanaḡi!” Mai guruḡa ḡena mero na ḡeseḡaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ierusalemai ḡevotuto, Iesu Rubu Veaḡa nuḡanai eraka-toḡato, benamo voivoi tarimari elai-rosirito. Moni ḡesenisito-ḡoi tarimari ḡeri fata e pune ḡevoivoi-iaḡirito-ḡoi tarimari ḡeri diḡoka eḡuke-vebuburito. ");
INSERT INTO snc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rubu Veaḡa nuḡana na ḡeri farefare ḡeḡwa-iaḡorito-ḡoi tarimari maki ekira-ḡoirito. ");
INSERT INTO snc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Benamo tarimarima evaḡa-ribarito, ekirato, “Buka Veaḡa nuḡanai tu maiḡesi etoreato, Barau ekirato, ‘Au ḡegu numa tu bese irauirau ḡeri ḡuriḡuri numanai beḡe kiraḡiani,’ senaḡi ḡomi na tu lema tarimari ḡeri gumu gabunai boḡo vaḡa-iaḡoa.” ");
INSERT INTO snc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na ḡeseḡaḡiato nai, Iesu beḡene vaḡia dabarana ḡevetauato. Iesu garina ḡeveito-ḡoi, korana tarimarima mabarari na ḡena vevaḡa-riba guruḡari ai ḡeḡaba-rakavato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Elavilavito, benamo Iesu ma ḡena mero ḡesi vanuḡa barana ḡeraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Boḡiboḡi ai dabara na ma ḡeraka-vanaḡito nuḡanai, mo figi ḡauna ḡeḡitaiato, emarai-ḡosito, ḡokana maki ḡemaseto. ");
INSERT INTO snc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero na etuḡamaḡi-taḡoato, benamo Iesu ekiraiato, ekirato, “Vevaḡa-riba tarimamu, noḡitaia, ḡoi na mo figi ḡauna otovoḡaiato dagarana tu varau bemase.” ");
INSERT INTO snc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Benamo Iesu na evaḡa-veserito, ekirato, “Barau boḡono ḡabidadama-vinia. ");
INSERT INTO snc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Moḡoni akiramini, tarima ta na mai ḡoro bekiraiani, ‘Noveraḡa-raḡe, be davarai noa vefiu-rei,’ benamo nuḡana asi ma bedaradarani, senaḡi bevaḡa-moḡoniani, kara bekiraḡiani dagarana bemoḡonini nai, mo veiḡa tu beḡorani. ");
INSERT INTO snc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Moḡa lorinai akiramini, kara boḡo noḡini ḡauḡau ai nai, boḡo vaḡa-moḡonia, boḡo doḡaria, benamo boḡo ḡabiani. ");
INSERT INTO snc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bema ḡoruḡa-tarini, benamo ḡoḡauḡauni nai, rakava boḡono tuḡamaḡi-fitoḡari, bema tarima ta ḡenai ma ḡemi nuḡa meto nai, benamo ḡomi Tamami gubai etanuni na maki ḡemi rakava betuḡamaḡi-fitoḡarini. ");
INSERT INTO snc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26"," Senaḡi bema ḡomi na tarima ḡeri rakava asi boḡo tuḡamaḡi-fitoḡarini nai, ḡomi Tamami gubai etanuni na maki ḡemi rakava asi betuḡamaḡi-fitoḡarini.” ");
INSERT INTO snc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Benamo ḡia Ierusalemai ma ḡeraḡasito. Monai Iesu Rubu Veaḡa nuḡanai erakato-ḡoi nuḡanai, Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ema Iuda vereri ḡia ḡenai ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Benamo ḡedanaḡiato, ḡekirato, “Kamara maoro ai ḡoi na mai veiḡa oveirini? Dei na maoro evinimuto?” ");
INSERT INTO snc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu na evaḡa-veserito, ekirato, “Au na vedanaḡi sebona avinimini, boḡo vaḡa-veseani nai, au na kamara maoro ai mai veiḡa aveirini bakira-varamini. ");
INSERT INTO snc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane ḡena babatiso veiḡana tu guba na eiaḡomato, ba tarimarima ḡerina?” ");
INSERT INTO snc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ḡia fakari ai ḡeverorito, ḡekirato, “Bema ḡita bita kirani, ‘Barau ḡenana’ bita toni nai, ḡia bekirani, ‘Karase nai Ioane asi ḡovaḡa-moḡoniato?’ betoni. ");
INSERT INTO snc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Senaḡi bema ḡita bita kirani, ‘Tarimarima ḡerina’ bita toni nai maki asi ilaila.” Ḡia tu tarimarima gariri ḡegarito, korana ḡia ribari, Ioane tu peroveta tarimana korikori. ");
INSERT INTO snc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Moḡa lorinai ḡia na Iesu ḡevaḡa-veseato, ḡekirato, “Ḡai asi ribama.” Benamo Iesu na ḡia maki ekirarito, ekirato, “Au na maki kamara maoro ai mai veiḡa aveirini asi bakira-varamini.” ");
INSERT INTO snc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu na barabore ai ma evaḡa-guruḡarito, ekirato, “Tarima ta vine tavoḡana evaroato, maḡuna eḡabiato, tano ai vine gigi-gigina gurina ekwaiato, tavoḡa ḡitaḡauna numana maki evaḡa-ruḡaiato. Moḡa murinai tavoḡa ḡitaḡauna tarimari ḡeri ai ḡena tavoḡa eraga-kwaneato, benamo erakato gabu ta ḡana. ");
INSERT INTO snc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vine ḡwari (o grapes) ḡemaḡeto, benamo ḡia na ḡena vetuḡunaḡi tauna ta etuḡuato tavoḡa narinarina tarimari ḡeri ai, vine ḡwari kota benea ḡabi ḡana. ");
INSERT INTO snc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Senaḡi ḡeḡabi-tariato, benamo ḡekwariato vau, ḡimana kori ḡetuḡu-ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tavoḡa biaguna na ḡena vetuḡunaḡi tauna ta ma etuḡuato, senaḡi ḡia tu debana ḡekodo-fakaiato e ḡevei-maiaka maiakaiato. ");
INSERT INTO snc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Benamo ta ma etuḡuato, senaḡi ḡevaḡi-maseato; ema vetuḡunaḡi tarimari ḡutuma etuḡurito, kota tu ḡekwaririto, kota tu ḡevaḡirito. ");
INSERT INTO snc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tarima sebona ta tu roḡo ḡia sevinai, ḡia natuna korikori, ḡena lalokau merona. Dokonai ḡia etuḡuato, ekirato, ‘Natugu natuḡua, ḡia na beḡene gubakaua.’ ");
INSERT INTO snc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Senaḡi tavoḡa ḡitaḡauna tarimari tauḡeri ḡeveguruḡa-vevinito, ḡekirato, ‘Mani tu tavoḡa beḡaunaiani merona, be siḡabia, sivaḡia, benamo tavoḡa tu ḡita ḡera.’ ");
INSERT INTO snc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Benamo ḡeḡabi-tariato, ḡevaḡiato, vine tavoḡana murikanai ḡefiu-rosiato.” ");
INSERT INTO snc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu evedanaḡito, ekirato, “Tavoḡa biaguna na tu kara beveiani? Ḡia beiaḡomani, tavoḡa narinarina tarimari bevaḡi-ḡosirini, benamo vine tavoḡana tarima irauri tari ma bevinirini. ");
INSERT INTO snc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ḡomi na mai toretore Buka Veaḡai asi ḡoiaviani, iniḡesi ekirani, ‘Fore numari ḡeragarini tarimari na asi ḡeura-viniato ma ḡefitoḡaiato forena tu duḡu forenai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mai veiḡa maiḡa tu Vereḡauka na eveiato, matara na taḡitaiani, ḡitaḡitana irau veḡata.’” ");
INSERT INTO snc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Benamo Iuda vereri na Iesu beḡene ḡabia dabarana ḡevetauato, korana ḡia ribari, Iesu na mai barabore tu ḡia ekiraḡirito-ḡoi nai. Senaḡi tarimarima ḡutuma ḡevegogo-taḡoto-ḡoi gariri ḡeveito naima ḡeraga-kwaneato, ḡerakato. ");
INSERT INTO snc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gabivau Farisea tarimari e Heroda murinai ḡerakato-ḡoi tarimari kotari Iesu ḡenai ḡetuḡu-iaḡorito, ḡena guruḡai beḡene vaḡa-vedaḡa-raḡea e beḡene ḡabia ḡana. ");
INSERT INTO snc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ḡeiaḡomato, benamo Iesu ḡema ribaḡaniato, ḡekirato, “Vevaḡa-riba tarimamu, ḡai ribama ḡoi tu moḡoni vei-iobukaiobuka tarimamu, tarimarima gariri asi oveini. Tarima ḡeri dagi maki asi otuḡamaḡirini, senaḡi ḡoi na moḡoni ai Barau ḡena dabara ovevaḡa-riba iaḡi-ḡitakauani. Novaḡa-ribama, Kaisara, Roma ḡeri vere, ḡenai takesi baḡana dava ba asiḡi? Baḡana vinia ba asi baḡana vinia?” ");
INSERT INTO snc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Senaḡi Iesu na ḡeri ḡofaḡofa eribaiato nai, ekirarito, ekirato, “Karase nai au ḡoribaḡaniguni? Silva monina ta ḡoḡwa-iaḡomaia, nama ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Benamo ta ḡeḡwa-iaḡomaiato, Iesu na edanaḡirito, ekirato, “Mai tu dei laulauna e dei arana?” Ḡia ḡevaḡa-veseto, ḡekirato, “Kaisara ḡena.” ");
INSERT INTO snc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu na ekirarito, “Kaisara ḡena dagara Kaisara boḡono vinia, Barau ḡena dagara Barau boḡono vinia.” Benamo ḡeḡaba-rakavato ḡia ḡenai. ");
INSERT INTO snc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukea tarimari kota Iesu ḡenai ḡeiaḡoto. Ḡia ḡeri tuḡamaḡi tu, mase tarimari asi ma beḡe variḡisi-ḡenoḡoini. Benamo Iesu ḡedanaḡiato, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Vevaḡa-riba tarimamu, Mose na taravatu ḡai ḡema maiḡesina etoreato, ‘Bema tau ta kakana bemaseni, vabuna bemase-kwaneani, ma asi naturi nai, mo tau na kakana vabuna bene ḡaraḡoa, naturi beḡene maḡuri mase tauna ḡena.’ ");
INSERT INTO snc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mero mabarari tu imaima ruarua (7). Mero guinena na eḡaraḡoato, ma emaseto asi natuna. ");
INSERT INTO snc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mero vaḡa-ruaruana na vabuna ma eḡaraḡoato, senaḡi ḡia maki emaseto asi natuna. Mero vaḡa-toitoina maki moḡesina moḡo. ");
INSERT INTO snc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Moḡa nuḡanai ḡia mabarari tu imaima ruarua (7), naturi ta asi ḡevaḡa-ḡoraiato. Dokonai mo vavine maki emaseto. ");
INSERT INTO snc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Variḡisi-ḡenoḡoi ḡaronai mo vavine tu dei ḡaraḡona? Korana ḡia tu tauri 7 na ḡeḡaraḡoato.” ");
INSERT INTO snc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu na evaḡa-veserito, ekirato, “Ḡomi tu ḡokerereni, korana Buka Veaḡa anina ema Barau ḡena seḡuka asi ribami. ");
INSERT INTO snc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mase na ma beḡe variḡisi-ḡenoḡoini tarimari tu asi ma beḡe veḡaraḡoni. Ḡia tu aneru kavana gubai. ");
INSERT INTO snc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mase na ma beḡe variḡisi-ḡenoḡoini guruḡari Mose ḡena bukai asi ḡoiaviani? Ḡau eḡaraiato varina nuḡanai Barau na Mose ekiraiato, ekirato, ‘Au tu Aberahamo ḡena Barau, Isako ḡena Barau, ema Iakobo ḡena Barau.’ ");
INSERT INTO snc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ḡia tu dia mase tarimari ḡeri Barau, senaḡi maḡuri tarimari ḡeri Barau. Ḡomi tu ḡokerere-rakava rakavani!” ");
INSERT INTO snc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimana ta eiaḡomato, ḡeri guruḡa-guruḡa eseḡaḡiato, benamo eḡitaiato, Iesu na evaḡa-vese ginikaurito nai, edanaḡiato, ekirato, “Taravatu mabarari nuḡari ai aiḡa tu barego vedaureana?” ");
INSERT INTO snc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu na evaḡa-veseato, ekirato, “Barego vedaureana tu maiḡa: ‘Isaraela tarimami o, ḡoseḡaḡi, Vereḡauka ḡita ḡera Barau tu Vereḡauka sebona kwariḡutu. ");
INSERT INTO snc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Vereḡauka ḡoi ḡemu Barau bono ura-vinia ma nuḡamu mabarana, ma iaukamu mabarana, ma ḡemu tuḡamaḡi mabarana, ma kokoremu mabarana ḡesi.’ ");
INSERT INTO snc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Vaḡa-ruaruana tu maiḡa: ‘Sevimu tarimana bono ura-vinia, ḡoi tauḡemu oveura-vinini kavana.’ Taravatu ta na mai taravatu ruarua asi bevanaḡirini.” ");
INSERT INTO snc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Taravatu evevaḡa-riba iaḡiato-ḡoi tarimana ma evaḡa-veseto, ekirato, “Vevaḡa-riba tarimamu, ḡoi ḡemu guruḡa tu moḡoni, Barau tu sebona moḡo, asi ta maia. ");
INSERT INTO snc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bono ura-vinia ma nuḡamu mabarana, ma ḡemu tuḡamaḡi mabarana, ma gwadamu mabarana, ema sevimu ai etanuni tarimana maki bono ura-vinia, ḡoi tauḡemu oveura-vinini kavana. Maiḡa tu barego vedaurea, ginitaḡo dagarari e boubou dagarari mabarari evanaḡirito.” ");
INSERT INTO snc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Benamo Iesu na mo tarima ḡena vevaḡa-vese eḡitaiato ma iaunegana e ma tuḡamaḡi-fakana ḡesi, benamo ekiraiato, ekirato, “Ḡoi e Barau ḡena Basileia fakami tu asi manaḡa.” Moḡa murinai tarima ta na asi ma edanaḡiato, korana ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Rubu Veaḡa nuḡanai evevaḡa-ribato-ḡoi nuḡanai, ekirato, “Taravatu ḡevevaḡa-riba iaḡiani tarimari tu kamasi nai Keriso tu Davida natuna ḡetoni? ");
INSERT INTO snc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davida Iauka Veaḡa na riba e tuḡamaḡi-faka eviniato, benamo eguruḡa-foforito, ekirato, ‘Barau na au ḡegu Vereḡauka ekiraiato: Au ḡimagu aroribana rekenai noma tanu, bene iaḡo mo, ḡoi ḡebaru-vinimuni tarimari ḡoi kwakumu gaburenai batorerini.’ ");
INSERT INTO snc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida na Keriso tu ‘Vereḡaukana’ ekiraḡito; kamasi nai Keriso tu Davida natuna?” Tarimarima ḡutuma lelevaḡi Iesu ḡena guruḡa ma iakuri ḡesi ḡeseḡaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ḡena vevaḡa-riba nuḡanai ekirato, “Taravatu ḡevevaḡa-riba iaḡiani tarimari boḡono ḡita-ginikauri. Ḡia ḡeurani dabuḡa maukari beḡene riḡo, maketi gaburi ai beḡene rakao-rakao, tarimarima na beḡene vaḡa-namori urari ai. ");
INSERT INTO snc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rubu nuḡari ai e ḡanivegogo gaburi ai ḡeri ura sea namori ai beḡene tanu. ");
INSERT INTO snc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ḡia na vabu ḡeri numa e farefare ḡevaḡa-koririni. Ḡeri ḡauḡau tu mauka kenene, ḡeḡofaḡofani. Ḡia tu meto barego vedaurea beḡe ḡabini.” ");
INSERT INTO snc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu moni-tore mauḡana ḡoiranai etanu-tarito, benamo tarimarima moni ḡeḡurato-ḡoi eḡitarito. Farefare e moni vovoka tarimari ḡutuma moni barari ḡeḡurato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Senaḡi asi-ḡena e asi-ḡana vabuna ta eiaḡomato, ḡena moni misiri ruarua moḡo eḡura-riḡorito, mai tu noḡa moḡo toea sebona kavana. ");
INSERT INTO snc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Benamo Iesu na ḡena mero ekearito ḡia ḡenai, benamo ekirarito, ekirato, “Moḡoni akiramini, mai vabu na beḡuraia monina na mabarari ḡeri vini bevanaḡiri. ");
INSERT INTO snc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Korana ḡia mabarari ḡeri moni vovoka ḡerina koturi moḡo beḡe vini, senaḡi mai vabu tu asi ḡena-ḡana na nuḡanai ḡenai kara ḡetanuni ḡena maḡuri ai bere vevaḡa-kava-iaḡiri dagarari mabarari beḡurari.” ");
INSERT INTO snc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Rubu Veaḡa na eraka-rosito-ḡoi nai, ḡena mero ta na ekiraiato, ekirato, “Vevaḡa-riba tarimamu, mai fore asikeikeiri noḡitari e mai numa baregori ma marevari maki noḡitari.” ");
INSERT INTO snc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu na evaḡa-veseato, ekirato, “Mai numa baregori oḡitarini? Mai fore ta fore ta iatanai asi beḡe tanuni, mabarari beḡe vare-bubu-riḡorini.” ");
INSERT INTO snc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu Olive Ḡorona tuḡunai etanu-taḡoto-ḡoi, Rubu Veaḡa Ierusalemai eḡita-iaḡoato-ḡoi nuḡanai, Petero, e Iakobo (o Iames), e Ioane, ema Anduru na ḡedanaḡi-ḡairiato, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nokira-varama, mai dagara tu aitoma beḡe ḡorani, ema beḡe ḡorani nai, kamara vetoḡa na bevaḡa-foforiani, maniḡeri mabarari beḡe ḡorani?” ");
INSERT INTO snc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Benamo Iesu na evaḡa-veserito, ekirato, “Ḡomi lorimi boḡono vetore, tarima ta na asi bene ḡofami. ");
INSERT INTO snc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tarima vovoka au aragu ai beḡe iaḡomani, beḡe kirani, ‘Tarimana tu au maiḡegu!’ Tarima ḡutuma beḡe ḡofarini. ");
INSERT INTO snc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bema ḡomi na vetari o tuari gururi e tuari variri boḡo seḡaḡirini nai, nuḡami asi beḡene raḡe. Maniḡeri dagara tu beḡe ḡorani, senaḡi dokona tu asi roḡo. ");
INSERT INTO snc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tanobara ta tanobara ta ḡesi beḡe vevaḡini, gavamani ta gavamani ta ḡesi beḡe vetarini. Gabu ḡutuma nuḡari ai tano beḡe iagani, doḡe maki beḡe ḡorani. Mai tu midigu moḡo besinaiani, noḡa moḡo mero keina emaḡurini midiguna kavana. ");
INSERT INTO snc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tauḡemi boḡono venari-ginikau, korana beḡe ḡabimini, Iuda ḡeri kanisoro tarimari ḡeri ai beḡe ḡori-iaḡomini e rubu nuḡari ai beḡe kwarimini. Au ḡoḡabi-raḡeguni dainai, gavana e vere barari o kini ḡoirari ai roḡo boḡo ruḡani, au vaḡa-moḡonigu ai boḡono iaḡo. ");
INSERT INTO snc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vari Namona tu tanobara mabarari nuḡari ai beḡe ḡobata-iaḡi guineani. ");
INSERT INTO snc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bema Kota tarimari ḡoirari ḡana beḡe ḡori-iaḡomini nai, kara toma boḡoa kiraḡirini guruḡari asi boḡono nuḡa-vekwaraḡi-iaḡiri. Ḡarona beraḡasini vau, Barau na kara bevaḡa-ribamini guruḡari boḡono kiraḡiri, korana dia ḡomi boḡo guruḡani, senaḡi Iauka Veaḡa beguruḡani. ");
INSERT INTO snc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kakana na tarina berevaiani bene mase ḡana, tamana na natuna maki moḡesina beveiani. Naturi na tamari sinari beḡe seḡafore-vinirini ema beḡe vaḡirini. ");
INSERT INTO snc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tarimarima mabarari na beḡe iau-rakavamini, korana au ḡoḡabi-raḡeguni nai. Senaḡina deikara bevevaḡa-gwaḡiḡini mo dokona tu bemaḡurini.” ");
INSERT INTO snc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bema ḡomi na dagara rakava vedaureana, vevaḡa-gari dagarana, boḡo ḡitaiani, asi bene ruḡa gabunai beruḡani.” Mai guruḡa beiaviani tarimana bene riba maoro anina tu kara. “Benamo deidei Iudeai ḡetanuni tarimari ḡoro ḡana beḡene raga-iaḡo. ");
INSERT INTO snc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Deikara numa tuḡunai etanu-taḡoni tu, asi ma bene raka-toḡa numa nuḡana ḡana ḡena farefare ḡabiḡabiri. ");
INSERT INTO snc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Deikara vamoka nuḡanai maki asi ma bene ḡenoḡoi ḡena koudi ḡabi-ḡabiri. ");
INSERT INTO snc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mo negai vavine ma baniri e ḡabi-variḡu vavineri kika ma vetuḡari! ");
INSERT INTO snc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Boḡono ḡauḡau, mai dagara asi bene ḡora ḡura e nagure ḡarori ai! ");
INSERT INTO snc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Korana mo negai rakava e midigu barego beḡe raḡasini, Barau na tanobara eveiato beiaḡoma maitoma, rakava e midigu moḡesina asi ḡeḡorani. Ma maiḡa murinai moḡesina kavana ta asi ma beḡorani. ");
INSERT INTO snc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bema Vereḡauka na mo ḡaro rakavari asi bere vaḡa-kubiri, tarima ta asi bere maḡuri riba, senaḡi eḡabi-hidirito tarimari dairi ai, ḡia na ḡarori evaḡa-kubirito. ");
INSERT INTO snc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mo negai, bema tarima ta na bekiramini, ‘Ḡoḡitaia, Keriso tu maiḡa!’ o ‘Ḡoḡitaia, ḡia tu iomoḡa!’ betoni nai, asi boḡono vaḡa-moḡonia. ");
INSERT INTO snc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Korana tu Keriso ḡofaḡofari e peroveta tarimari ḡofaḡofari beḡe foforini, vetoḡa boruri e nuḡa-farevaḡi veiḡari beḡe veirini, Barau na eḡabi-viriḡirito tarimari beḡene ḡofa-veḡonuri ḡana. ");
INSERT INTO snc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Moḡesi nai tauḡemi boḡono venari; dagara mabarari tu akiravara-guinemini, aoa roḡosi bene raḡasi nai.” ");
INSERT INTO snc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Senaḡi mo negai, rakava beḡe ḡorani murinai, ḡaro bemukunani e ḡue maki asi bemamani, ");
INSERT INTO snc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","visiḡu guba na beḡe ketoni e guba seḡukari beḡe iagaiagani. ");
INSERT INTO snc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Benamo tarima na Tarimarima Natuna beḡe ḡitaiani, magube na beiaḡomani ma seḡuka barana e ma marevana ḡesi. ");
INSERT INTO snc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Benamo ḡia na aneru betuḡurini, eḡabi-viriḡirito tarimari beḡe vaḡa-vegogorini tanobara mabarari na.” ");
INSERT INTO snc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Figi ḡauna ḡenana mai barabore boḡono ribaia: Kabona ḡefori-raḡeni e launa ḡefafani nai, ḡoribani, ḡaro ḡena tora taimina tu bekavinaḡi ḡotoni. ");
INSERT INTO snc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Moḡa ilailanai, ḡomi maki bema mai dagara beḡe ḡorani boḡo ḡitarini nai, boḡono riba, Tarimarima Natuna tu bekavinaḡi ḡatama bokai. ");
INSERT INTO snc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moḡoni akiramini, mai ḡuru asi bekorini, beiaḡoni mo, mai dagara mabarari beḡe ḡorani. ");
INSERT INTO snc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Guba e tanobara beḡe rekwa-rekwani, senaḡi au ḡegu guruḡa tu asi beḡe rekwa-rekwani, beḡe tanu-vanaḡi vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Senaḡi mo ḡaro ema aoa tu tarima ta asi ribana, e aneru gubai asi ribari, ema Natuna maki asi ribana, senaḡi Tamana ḡereḡana moḡo ma ribana. ");
INSERT INTO snc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lorimi boḡono vetore, boḡono venari-ginikau, korana asi ribami, aitoma mo aoa beraḡasini. ");
INSERT INTO snc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ḡia tu maiḡesina kavana, tarima ta eraka-ḡerevaḡito, ḡena numa eraga-kwaneato, benamo ḡena vetuḡunaḡi tarimari maoro evinirito, tata ḡeri ḡauvei beḡene vei. Ḡatama-boka narinarina tarimana maki ekiraiato, bene riviḡaua. ");
INSERT INTO snc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Moḡesi nai ḡomi maki tataḡa-taḡo boḡono tanu, korana numa biaguna beḡenoḡoini aoana tu asi ribami, lavilavi ai, ba boḡi nuḡanai, ba kokoroku begoḡini ai, ba boḡiboḡi ai. ");
INSERT INTO snc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Irau mai moḡo beraḡasini, benamo genami ai beḡoitaḡomini ḡesi. ");
INSERT INTO snc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Au na kara ḡomi akira-varamini guruḡana tu tarimarima mabarari maki akira-vararini, akirani, ‘Tataḡa-taḡo boḡono tanu e boḡono venari-ginikau!’” ");
INSERT INTO snc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ḡaro ruarua moḡo, benamo Pasova verekona o Iuda tarimari mase aneruna na evanaḡirito asi evaḡirito verekona e asi etubuni faraona verekona beḡe veiani nuḡanai, Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na Iesu beḡene ḡabi-lemaia, benamo beḡene vaḡi-masea dabarana ḡevetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Senaḡi ḡekirato, “Dia vereko nuḡanai bene ḡora, korana vereko beḡe iaḡoma tarimari ḡia iatana na beḡe burini garina.” ");
INSERT INTO snc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu Betania ai Simona lepera tarimana ḡena numai eḡaniḡanito-ḡoi nuḡanai, vavine ta eraka-toḡato, kavabu namona ta, alabasta forena na ḡeveiato kavabuna, eḡabi-kauato, nuḡanai tu muramura ma bonana namona. Mo muramura tu ḡauḡa arana nad ḡokana na ḡeveito-ḡoi dagarana, ma voina tu varaḡe rakava. Mo vavine na mo kavabu bokana ebota-fakaiato, benamo muramura Iesu debanai ebubuato. ");
INSERT INTO snc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ḡia sevinai tarimari kota tu ma nuḡa-metori ḡesi ḡeveguruḡa-vevinito, ḡekirato, “Karase nai mai muramura bonana namona efitoḡa-kavaiani? ");
INSERT INTO snc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bere voivoi-iaḡia, benamo silva moniri sinau toitoi (300) bere ḡoitaḡoa, (mai tu tarima ta davana laḡani ta nuḡanai kavana), benamo asi ḡeri-ḡari tarimari bere viniri.” Benamo ḡia na mo vavine ḡevaneato. ");
INSERT INTO snc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Senaḡi Iesu ekirato, “Ḡoraga-kwanea! Kara dainai ḡomi na meto ḡoviniani? Mai vavine na tu veiḡa namona au ḡegu ai beveia. ");
INSERT INTO snc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Asi ḡeri-ḡari tarimari tu ḡomi ḡesi boḡo tanu-vanaḡi vanaḡini, be boḡo urani nai, boḡono vaḡa-kavari. Senaḡi au tu dia ḡaro mabarari ḡomi ḡesi batanuni. ");
INSERT INTO snc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mai vavine na tu kara bere veia dagarana beveia, ḡia na au tauḡanigu ai muramura bebubu-guinea gurigurigu ḡana. ");
INSERT INTO snc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Moḡoni akiramini, Vari Namona beḡe ḡobata-iaḡiani tanobara mabarari nuḡari ai, mai vavine na veiḡa beveia veiḡana maki beḡea kiraḡiani, ḡia tuḡamaḡi-iaḡina.” ");
INSERT INTO snc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Benamo Iudas Isakariota, gabanana ruarua (12) tarimana ta, Rubu Veaḡa vereri baregori ḡeri ai eiaḡoto, Iesu benea revaia ḡia ḡeri ai ḡana. ");
INSERT INTO snc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Benamo ḡia na ḡeseḡaḡiato nai, ḡeiaku-rakavato, benamo ḡekira-toreato, moni beḡe viniani. Benamo Iudas na ḡimari ai betore-kauani dabarana ma evetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ḡaro giniguinenai, asi etubuni faraona verekona veiveina e ginitaḡo mamoena vaḡivaḡina ḡaronai, Iesu ḡena mero ḡevedanaḡito, ḡekirato, “Ḡai tu ainai Pasova verekona baḡana vei-torea, bono ḡania?” ");
INSERT INTO snc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Benamo Iesu na ḡena mero ruarua etuḡurito, ekirarito, ekirato, “Vanuḡa baregonai boḡono raka-toḡa, benamo tarima ta nanu gwaḡutuna befaḡaiani boḡo ḡoitaḡoani. Murina na boḡono iaḡo. ");
INSERT INTO snc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Benamo beraḡekauni numanai numa biaguna boḡono vaḡa-guruḡaia, boḡono kira, ‘Vevaḡa-riba tarimana ekirani: Au ḡegu varivari daiḡutuna tu aiḡa, ḡegu mero ḡesi monai ginitaḡo mamoena baḡana ḡania?’ ");
INSERT INTO snc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Benamo ḡia na daiḡutu baregona ta numa tuḡunai bevaḡa-ḡitamini iarevatore. Monai boḡono dabaraia ḡita ḡara.” ");
INSERT INTO snc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Benamo mero ḡeiaḡoto, vanuḡa barana nuḡanai ḡeraka-toḡato, Iesu na ekiraḡirito ilailari ai ḡedoḡaririto. Monai vereko ḡeveiato. ");
INSERT INTO snc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Elavilavito, Iesu ma ḡena mero gabanana ruarua (12) ḡesi ma ḡeraḡasito. ");
INSERT INTO snc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ḡeḡaniḡanito-ḡoi nuḡanai Iesu ekirato, “Moḡoni akiramini, ḡomi ta na au borevaguni, ta au ḡesi ini taḡaniḡani-vegogoni tarimamu ta na.” ");
INSERT INTO snc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ḡia mabarari nuḡari ma metori ḡesi irau sebori irau sebori na ḡedanaḡiato, ḡekirato, “Moḡoni dia au, ene?” ");
INSERT INTO snc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu na ekirarito, ekirato, “Mai tu ḡomi gabanana ruarua (12) fakami ai ta dei au ḡesi diḡu sebonai ḡanaba-riḡoni tarimana. ");
INSERT INTO snc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tarimarima Natuna bemaseni, Buka Veaḡai ḡetoreato ilailanai. Senaḡi Tarimarima Natuna berevaiani tarimana vetuḡana kekei, asi bere maḡuri tu namo.” ");
INSERT INTO snc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ḡia ḡeḡaniḡanito-ḡoi nuḡanai, Iesu na beredi eḡabiato, Barau evaḡa-namoato, etaviato, evinirito, benamo ekirato, “Ḡoḡabia, mai tu au tauḡanigu.” ");
INSERT INTO snc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ḡia na kapusi ma eḡabiato, evaḡa-namoato murinai evinirito, benamo mabarari na ḡeniuato. ");
INSERT INTO snc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Benamo Iesu na ekirarito, ekirato, “Mai tu au raragu, Ginitaḡo Variḡuna evaḡa-moḡoniani, bevebubuni, tarimarima ḡutuma vaḡa-maḡuriri. ");
INSERT INTO snc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Moḡoni akiramini, vine nanuna asi ma baniu-ḡenoḡoiani, beiaḡoni mo, Barau ḡena Basileiai vau ma baniu-ḡenoḡoiani.” ");
INSERT INTO snc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Benamo mari ta ḡemariato murinai, ḡeraka-rosito, Olive Ḡorona ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Ḡomi mabarami ḡemi veḡabidadama au ḡegu ai boḡo raga-kwaneani, korana Buka Veaḡai maiḡesi etoreato, ‘Au na mamoe ḡitaḡauri tarimana bavaḡiani, benamo mamoe mabarari beḡe raga-lausini.’ ");
INSERT INTO snc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Senaḡi au mase na ma bavariḡisi-ḡenoḡoini murinai, baraka-guineni Galilea ḡana. Monai vau bitana vedoḡari.” ");
INSERT INTO snc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero ekirato, “Mabarari na ḡeri veḡabidadama ḡoi ḡemu ai beḡe raga-kwaneani, senaḡi au na tu asiḡina.” ");
INSERT INTO snc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu na evaḡa-veseato, ekirato, “Moḡoni akiramuni, toma boḡi kokoroku vaḡa-ruarua roḡosi bene goḡi nuḡanai, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni.” ");
INSERT INTO snc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Senaḡi Petero eguruḡa-ḡiḡiraḡeto, ekirato, “Bema ḡoi ḡesi bita mase-vegogoni maki, au na ḡoi tu asi veḡata bakira-ḡuniḡaumuni.” Mabarari moḡesi moḡo ḡekirato. ");
INSERT INTO snc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ḡia gabu arana Getesemane ai ḡea raḡasito, benamo Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Mainai ḡotanu, au tu naiaḡo, naḡuriḡuri roḡo.” ");
INSERT INTO snc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Benamo Petero, e Iakobo (o Iames), ema Ioane moḡo eḡoririto, ḡia ḡesi ḡeiaḡoto. Moḡa nuḡanai Iesu tauḡanina efarakaiato, egarito, nuḡana maki evekwaraḡito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Benamo ekirarito, ekirato, “Au nuḡagu na meto asikei eḡwaiani, dori evaḡiguni; mainai ḡotanu, boḡono venari.” ");
INSERT INTO snc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iesu kota ma eraka-naḡito, tano ai eketo-tarito, benamo Barau enoḡiato, ekirato, bema ma dabara ta moḡa neganai, mai aoa metona ḡenana bene vanaḡi. ");
INSERT INTO snc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ekirato, “Tama, Tamagai o, dagara mabarari ḡoi ḡemu ai veiveiri tu ilaila. Mai midigu bedina ḡeguna noma ḡabi-vaḡia. Senaḡi dia au ḡegu ura, ḡoi ḡemu ura moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Benamo eḡenoḡoito nuḡanai tu, ḡena mero genamaseri ai eḡoitaḡo-rito, benamo Petero ekiraiato, ekirato, “Simona, ḡoi tu ogenani? Aoa sebona ta kavana maki asi bovevaḡa-gwaḡiḡini? ");
INSERT INTO snc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Boḡono venari, boḡono ḡauḡau, be veribaḡani beiaḡomani nai, asi boḡono moira. Iauka tu moḡoni eurani, senaḡi tauḡani tu emoirani.” ");
INSERT INTO snc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Benamo ma eraka-veḡitato, ea ḡuriḡurito, mo ḡauḡau guruḡari guineri ma ea kiraḡirito. ");
INSERT INTO snc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma eḡenoḡoi-iaḡomato nuḡanai tu, genamaseri ai ma edoḡaririto, korana matari tu gena na eḡabi-rakavarito. Ḡia asi ribari kamasi beḡe vaḡa-veseani. ");
INSERT INTO snc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Vaḡa-toitoina ma eḡenoḡoito, benamo ekirarito, ekirato, “Ḡomi tu roḡo ḡogenani e ḡoiaḡaraḡini? Bevaitovo! Aoana varau beraḡasi! Ḡoḡitaia, Tarimarima Natuna tu beḡe revaia, rakava tarimari ḡimari ai beḡe torea. ");
INSERT INTO snc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ḡovariḡisi, be si-iaḡosi! Ḡoḡitaia, au revarevagu tarimana mai beraḡasi!” ");
INSERT INTO snc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu roḡo eguruḡato-ḡoi nuḡanai, Iudas, mero gabanana ruarua (12) tauna ta, eraḡasito. Tarimarima ḡutuma maki ḡia ḡesi ma ḡeri vetari baḡari e vevaḡi kwariri. Ḡia tu Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ema Iuda vereri na ḡetuḡurito. ");
INSERT INTO snc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Reva tarimana na vetoḡa ta ekiravara-torerito, ekirato, “Baverauani tarimana tu moḡa. Boḡono ḡabi-taria, boḡono ḡori-iaḡoa ḡomi ḡemi veḡitaḡau gaburenai.” ");
INSERT INTO snc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iudas eraḡasito nai, maoromaoro eiaḡoto Iesu ḡenai, benamo ekirato, “Vevaḡa-riba tarimamu o!” benamo everauato. ");
INSERT INTO snc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Benamo tuari tarimari na ḡeḡabi-tariato, ḡedegodegoato. ");
INSERT INTO snc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Senaḡi monai eruḡa-taḡoto-ḡoi tarimana ta, ḡena vetari baḡana einu-vaḡiato, edaveato, benamo Rubu Veaḡa verena baregona ḡena vetuḡunaḡi tarimana seḡana ebasi-vaḡiato. ");
INSERT INTO snc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu na ekirarito, ekirato, “Au tu seḡafore doḡorona ta aḡori-kauani? Be ḡomi boḡo iaḡoma au ḡabiḡabigu tu, ma ḡemi vetari baḡari e vevaḡi kwariri ḡesi? ");
INSERT INTO snc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ḡaro mabarari ai au tu ḡomi sevimi ai Rubu Veaḡa nuḡanai avevaḡa-ribato-ḡoi, senaḡi asi ḡoḡabiguto. A mai tu Buka Veaḡai ḡetore-guineato guruḡana vaḡa-moḡonina ḡana.” ");
INSERT INTO snc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ḡena mero mabarari na ḡeraga-kwaneato, ḡeraka-rovorovoto. ");
INSERT INTO snc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mero variḡuna ta tu kefina korina, senaḡi dabuḡa ta na moḡo tauḡanina eriḡo-ḡauato, Iesu murinai erakato. Ḡia maki ḡeḡabi-tariato, ");
INSERT INTO snc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","senaḡi ḡena dabuḡa ḡimari ai eraga-kwaneato, kefina kori moḡo eraga-kwaraḡato. ");
INSERT INTO snc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ḡia na Iesu ḡeḡori-iaḡoato Rubu Veaḡa verena baregona ḡenai, ema Rubu Veaḡa vereri baregori, e Iuda vereri, ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari mabarari ḡeraka-vegogoto. ");
INSERT INTO snc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero na Iesu eraka-ḡiuato, senaḡi ma fakana eiaḡoto mo, Rubu Veaḡa verena baregona ḡena numa maḡuna nuḡanai eraka-toḡato. Monai gadi tarimari fakari ai ea tanuto, benamo karava na etunuato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rubu Veaḡa vereri baregori e Iuda ḡeri kanisoro tarimari mabarari na tu Iesu vaḡa-masena korana ta ḡevetauato, senaḡi ta tu asi ḡedoḡari-ato. ");
INSERT INTO snc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tarimarima ḡutuma ḡeri ḡofaḡofa guruḡari na ḡevaḡa-badeato-ḡoi, senaḡi ḡeri guruḡa tu asi ḡesebonato-goi. ");
INSERT INTO snc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Benamo tarima kota ḡeruḡa-vaisito, benamo mai ḡofaḡofa guruḡari ḡekiraḡirito, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ḡai tu ḡia ḡena guruḡa baḡa seḡaḡia, bekira, ‘Au na mai tarimarima ḡimari na ḡeragaiato Rubu Veaḡana barovoani, ema ḡaro toitoi nuḡanai ta ma baragaiani dia ḡima veiveina rubuna.’” ");
INSERT INTO snc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Senaḡi ḡia ḡeri vevaḡa-bade guruḡari maki asi sebona. ");
INSERT INTO snc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Benamo Rubu Veaḡa verena baregona ḡoirari ai eruḡa-vaisito, benamo Iesu edanaḡiato, ekirato, “Ḡoi tu asi bovaḡa-veseni? Maiḡeri na ḡoi ḡevarifiu-iaḡimuni guruḡari tu kamasi?” ");
INSERT INTO snc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Senaḡi Iesu asi eguruḡato, ma asi evaḡa-veserito. Benamo Rubu Veaḡa verena baregona na ma edanaḡi-ḡenoḡoiato, ekirato, “Ḡoi tu Keriso, ḡevaḡa-namoani Barauna Natuna?” ");
INSERT INTO snc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu na evaḡa-veseato, ekirato, “Tarimana au maiḡegu! Ḡomi na Tarimarima Natuna roḡo boḡo ḡitaiani, Seḡuka Barauna ḡimana aroribanai betanuni, e guba maguberi iatari na beiaḡomani!” ");
INSERT INTO snc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Benamo Rubu Veaḡa verena baregona na ḡena dabuḡa edareato, ekirato, “Karase vevaḡa-ḡita tarimari roḡo tavetaurini? ");
INSERT INTO snc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Barau vaḡa-rakavana guruḡana boḡo seḡaḡia. Ḡomi kara ḡotoni?” Ḡia mabarari ḡekirato, “Bene mase moḡo.” ");
INSERT INTO snc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Benamo kota na ḡekanunuato, matana ḡekumu-ḡauato, ḡefaisiato, ḡekiraiato, ḡekirato, “Ḡoi tu peroveta tarimana, be nokiraḡia, deikara na bekwarimu?” Benamo gadi tarimari na ḡeḡabiato, ḡimari na ḡeforoato. ");
INSERT INTO snc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petero roḡo numa maḡuna nuḡanai, Rubu Veaḡa verena baregona ḡena vetuḡunaḡi ḡuiatori ta eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ḡia na Petero karava na etunuato-ḡoi eḡitaiato, benamo eḡita-ginikauato, ekiraiato, ekirato, “Ḡoi maki Iesu, Nasareta tauna, ḡesi orakaoto-ḡoi, okavaiato-ḡoi.” ");
INSERT INTO snc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Senaḡi ḡia evekira-ḡuniḡauto, ekirato, “Au asi ribagu ḡoi kara okiraḡiani,” benamo eraka-rosito maḡu ḡatama bokana ḡana, benamo kokoroku egoḡito. ");
INSERT INTO snc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mo vetuḡunaḡi ḡuiatona na ma eḡitaiato, benamo monai ḡeruḡa-taḡoto tarimari ekirarito, ekirato, “Tarimana ta tu maniḡa.” ");
INSERT INTO snc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petero ma evekira-ḡuniḡauto. Nega kotuna evanaḡito nuḡanai, ḡia sevinai ḡeruḡa-taḡoto-ḡoi tarimari na ḡekiraiato, ḡekirato, “Moḡoni, ḡoi maki ḡia ḡesi ḡorakaoto-ḡoi tarimamu ta, korana ḡoi tu Galilea taumu.” ");
INSERT INTO snc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Benamo Petero na ekirarito, ekirato, “Asiḡina ḡinavaḡi, akira-korikorimini, ḡomi na ḡokiraḡiani tarimana au tu asi ribagu.” ");
INSERT INTO snc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kokoroku vaḡa-ruaruana ma egoḡito, benamo Petero na Iesu ḡena guruḡa etuḡamaḡi-doḡariato, ekiraiato, “Kokoroku vaḡa-ruaruana roḡosi bene goḡi nai, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni.” Benamo etaḡi-rakava rakavato. ");
INSERT INTO snc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Boḡiboḡi iamoiamo, Rubu Veaḡa vereri baregori, e Iuda vereri, e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ema kanisoro tarimari mabarari na ḡevaḡa-moḡoniato. Benamo Iesu ḡebarubaruato, ḡeḡori-iaḡoato, Roma Gavana Pilato ḡea viniato. ");
INSERT INTO snc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato na edanaḡiato, ekirato, “Ḡoi tu Iuda tarimari ḡeri vere o kini?” Iesu na evaḡa-veseato, ekirato, “Oi, okiraḡiani maniḡa.” ");
INSERT INTO snc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Benamo Rubu Veaḡa vereri baregori na Iesu ḡevaḡa-badeato, guruḡa ḡutuma ḡekiraḡirito. ");
INSERT INTO snc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato na ma edanaḡi-ḡenoḡoiato, ekirato, “Ḡoi tu asi bovaḡa-veseni? Noḡitaia, ḡoi iatamu ai tu meto ḡutuma ḡekiraḡirini.” ");
INSERT INTO snc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Senaḡi Iesu asi eguruḡato, benamo Pilato tu edaradarato. ");
INSERT INTO snc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vanaḡivanaḡi Pasova verekona ḡaronai tu Pilato na ḡia ḡeri dibura numanai etanuni, beḡe kiraḡiani tarimana ta, etuḡu-rosiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mo laḡani ai tarima ta arana Barabas, ḡia tu dibura numai etanuto tarima kota ḡesi, korana ḡevevaḡito nai, tarima ta ḡevaḡi-maseato. ");
INSERT INTO snc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Benamo ḡutuma monai ḡevegogoto tarimari Pilato ḡenoḡiato, eveini kavana ma bene vei ḡana. ");
INSERT INTO snc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato na edanaḡirito, ekirato, “Ḡomi ḡourani au na Iuda tarimami ḡemi vere natuḡu-rosia ba?” ");
INSERT INTO snc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ḡia ribana, Rubu Veaḡa vereri baregori ḡeri mama dainai, Iesu ḡia ḡimanai ḡetoreato. ");
INSERT INTO snc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Senaḡi Rubu Veaḡa vereri baregori na tarimarima nuḡari ḡeḡanirito, Pilato na Barabas bene tuḡu-rosia. ");
INSERT INTO snc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Benamo Pilato na ma edanaḡirito, ekirato, “O mai Iuda tarimami ḡemi vere ḡotoni tu kamasi bana veia?” ");
INSERT INTO snc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ḡia ḡefararato, ḡekirato, “Novaḡa-satauroa!” ");
INSERT INTO snc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato na edanaḡirito, ekirato, “Karase nai, kamara veiḡa rakavana eveiato nai?” Senaḡi mabarari ḡefarara-gigitarito, ḡekirato, “Novaḡa-satauroa!” ");
INSERT INTO snc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ḡena ura mo tarimarima ḡutuma nuḡari bene vaḡa-namori ḡana, ḡia na Barabas etuḡu-rosiato, senaḡi Iesu tu ḡekwariato murinai, evinirito beḡene vaḡa-satauroa ḡana. ");
INSERT INTO snc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vetari tarimari na Iesu ḡeḡori-iaḡoato gavana ḡena numa nuḡanai, benamo karori mabarari ḡekea-vegogorito. ");
INSERT INTO snc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Benamo dabuḡa kakakakana ḡevaḡa-veiato, debana dagarana ḡau ma giniginina na ḡevatoato, korona noḡa ḡeveiato, benamo Iesu debanai ḡetore-kauato. ");
INSERT INTO snc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Benamo ḡevaḡa-namoato, ḡekirato, “Iuda ḡeri Kini o, ḡaro namona!” ");
INSERT INTO snc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Benamo oro kwarina na debana ḡekwari-ḡenoḡoi ḡenoḡoiato-ḡoi, ḡekanunu-kanunuato, ḡevetui-tari viniato, ḡetoma-rakariḡo ḡofakau-viniato. ");
INSERT INTO snc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ḡevaseva-vaseva iaḡi-ḡosiato murinai, dabuḡa kakakakana ḡekoki-vaḡiato, ḡena dabuḡa korikorina ma ḡevaḡa-veiato. Benamo ḡeḡori-rosiato beḡenea vaḡa-satauroa ḡana. ");
INSERT INTO snc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kurene tarimana ta arana Simona, Alesanda e Rufo tamari, gunika vanuḡana ta na eiaḡomato-ḡoi, vetari tarimari na ḡelaunaḡi-naḡiato Iesu ḡena satauro neḡwaia. ");
INSERT INTO snc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Benamo Iesu ḡeḡori-iaḡoato gabu ta arana Golgota ḡana, anina tu “Deba Ḡavana Gabuna.” ");
INSERT INTO snc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Benamo ḡia na vine nanuna, midigu vaḡa-keina muramurana arana muro ḡesi ḡebubu-vegogoato, ḡeviniato, senaḡi asi eniuato. ");
INSERT INTO snc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Benamo ḡevaḡa-satauroato; ḡena dabuḡa dainai laki ḡerena ta ḡeveiato, benamo ḡevarerito fakari ai. ");
INSERT INTO snc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Boḡiboḡi ai horaḡauna 9 koloko rekenai ḡevaḡa-satauroato. ");
INSERT INTO snc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kara koranai ḡevaḡa-satauroato guruḡana satauro iatanai maiḡesi ḡetoreato, “IUDA TARIMARI ḠERI VERE.” ");
INSERT INTO snc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lema tarimari ruarua maki Iesu ḡesi ḡevaḡa-sataurorito, ta aroribana rekenai, ma ta kaurina rekenai. ");
INSERT INTO snc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28"," Monana Buka Veaḡai ḡetore-guineato guruḡana evaḡa-moḡoniato, ekirato, “Ḡia vei-rakava tarimari ḡesi ḡeiavi-vegogoato.” ");
INSERT INTO snc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ḡeraka vanaḡito-ḡoi tarimari na guruḡa rakavari Iesu ḡeviniato-ḡoi, debari ḡekorakorarito, ḡekirato, “Aha, be ḡoi okirato Rubu Veaḡa borovoani, ḡaro toitoi nuḡanai ma bovaḡa-ruḡa ḡenoḡoiani otato! ");
INSERT INTO snc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Satauro tuḡuna na noraka-riḡo, tauḡemu novevaḡa-maḡuri!” ");
INSERT INTO snc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Rubu Veaḡa vereri baregori e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na maki fakari ai maiḡesi ḡevaseva-vaseva iaḡiato, ḡekirato, “Ḡia na tarima boruri evaḡa-maḡuririto, senaḡi tauḡena tu asi evevaḡa-maḡurini! ");
INSERT INTO snc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso, Isaraela tarimari ḡeri vere, satauro na inimoḡo noraka-riḡo ḡai ḡoiramai, be baḡana vaḡa-moḡonimu!” Iesu ḡesi ḡevaḡa-satauro vegogorito tarimari ruarua na maki ḡeguruḡa-rakava viniato. ");
INSERT INTO snc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Horaḡauna 12 koloko ea ḡabiato nai, tanobara mabarana mukuna na eḡabi-ḡauato; mukuna etanuto, eiaḡoto mo, horaḡauna 3 koloko. ");
INSERT INTO snc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Horaḡauna 3 koloko rekenai Iesu eḡabato, ekirato, “Eloi, eloi, lama sabaktani?” anina tu, “Au ḡegu Barau, au ḡegu Barau, kara dainai au boraga-kwanegu?” ");
INSERT INTO snc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iesu sevinai ḡeruḡa-taḡoto-ḡoi tarimari kota ḡeseḡaḡito, benamo ḡekirato, “Ḡoseḡaḡi, Elia ekeaiani.” ");
INSERT INTO snc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Benamo tarima ta eragato, nanu erimaiani dagarana ta eḡabiato, vine nanuna mamakina nuḡanai efereiato, gobu lefai egwanu-kauato, benamo eduḡi-raḡeato Iesu na neniua ḡana, ekirato, “Siḡitaia, Elia beiaḡomani, bema ḡabi-riḡoani ba?” ");
INSERT INTO snc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Benamo Iesu eḡaba-fouto murinai emaseto. ");
INSERT INTO snc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Benamo Rubu Veaḡa nuḡanai veaḡa lelevaḡi daiḡutuna kouḡauna dabuḡana o ketin evedare-kikimato, eruaruato, tuḡuna na mo gabigabina. ");
INSERT INTO snc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Roma vetari verena Iesu ḡoiranai eruḡa-taḡoto-ḡoi, ḡena ḡaba eseḡaḡiato e kamasi emaseto eḡitaiato, benamo ekirato, “Moḡoni veḡata, mai tarima tu Barau Natuna!” ");
INSERT INTO snc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vavine kotari maki ḡemarereto-ḡoi, kotuna manaḡai ḡeruḡato, fakari ai tu Maria, Magadala vavinena; e Maria, mai tu Iakobo (o Iames) keina e Iosefa ḡesi sinari; ema Salome. ");
INSERT INTO snc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galileai mai vavine tu Iesu murina na ḡerakato-ḡoi e ḡia vetuḡunaḡina ḡeiaḡo-vinito-ḡoi. Vavine vovoka ḡia ḡesi Ierusalema ḡana ḡemaraḡeto vavineri maki monai. ");
INSERT INTO snc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mo lavilavi ai vereko beḡe vei-toreani, Sabadi ḡarona roḡosi bere ḡabia nai. ");
INSERT INTO snc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iosefa, Arimatea vanuḡa tarimana, ḡematauraiato-ḡoi kanisoro fakari ai tarimana ta, Barau ḡena Basileia evaḡa-nogaiato-ḡoi tarimana, Pilato ḡenai eiaḡoto, benamo enoḡi-ginikauato, Iesu tauḡanina bene ḡabia etato. ");
INSERT INTO snc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato eseḡaḡito Iesu tu varau emaseto nai, nuḡana efarevaḡito, benamo vetari verena ekeaiato, edanaḡiato, ekirato, “Moḡoni, Iesu tu bemase ba?” ");
INSERT INTO snc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Benamo vetari verena na Iesu ḡena mase evaḡa-moḡoniato vau, Iesu tauḡanina Iosefa eviniato. ");
INSERT INTO snc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Moḡa murinai Iosefa na dabuḡa kurokurona namona ta evoiato, benamo Iesu eḡabi-riḡoato, dabuḡa na ekumuato. Gara gabuna fore kouḡanai ea tore-toḡaiato murinai, fore baregona na ḡatama-boka ekure-ḡauato. ");
INSERT INTO snc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria, Magadala vavinena, e Maria, Iosefa sinana, na etoreato gabuna ḡeḡita-kauato. ");
INSERT INTO snc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Iuda tarimari ḡeri Sabadi ekorito murinai, Maria, Magadala vavinena, e Maria, Iakobo (o Iames) sinana, ema Salome muramura ma bonana namona ḡevoito, beḡene iaḡo, Iesu tauḡanina beḡene daua ḡana. ");
INSERT INTO snc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fura ḡarona giniguinena o Sandei ai, boḡiboḡi ḡaro eraḡekauto nai, gara ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Benamo tauḡeri moḡo ḡeverorito-ḡoi, ḡekirato, “Deikara na mo fore barana gara ḡekouḡau-iaḡiato tu, dei na toma ea kure-veḡitaiani?” ");
INSERT INTO snc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Senaḡi ḡeboḡe-iaḡoto nuḡanai, mo fore baregona tu irau ai vetore. ");
INSERT INTO snc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ḡia gara kouḡana nuḡanai ḡeraka-toḡato nai tu, mero variḡuna ta ḡeḡitaiato, aroriba rekenai etanuto, ḡena dabuḡa tu kurokuro e mauka kenene, benamo nuḡari ḡefarevaḡi-rakavato. ");
INSERT INTO snc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ḡia na ekirarito, ekirato, “Asi ḡogari, au ribagu ḡomi tu Iesu, Nasareta tauna, ḡevaḡa-satauroato tarimana ḡovetauani. Ḡia tu bevariḡisi-ḡenoḡoi! Ḡia mainai tu asiḡina, ḡetoreato gabuna ḡoma ḡitaia. ");
INSERT INTO snc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Be ḡoiaḡo, ḡena mero e Petero boḡonoa kira-varari, boḡono kira, ‘Iesu tu beguineni Galilea ḡana. Monai vau boḡoa ḡitaiani evaḡa-guruḡamito ilailanai.’” ");
INSERT INTO snc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Benamo mo vavine ḡeraka-rosito gara nuḡana na, korana nuḡari ḡefarevaḡito e tauḡaniri ḡeḡoḡo-ḡoḡorito-ḡoi nai. Tarima ta maki asi ḡevaḡa-guruḡaiato, korana ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9"," Fura ḡarona giniguinenai, boḡi-boḡi iamoiamonai, Iesu evariḡisi-ḡenoḡoito, benamo Maria, Magadala vavinena, ḡenai efofori-guineto. Ḡia ḡenana tu iauka rakavari imaima ruarua (7) elai-vaḡirito. ");
INSERT INTO snc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ḡia eiaḡoto, benamo Iesu murina na ḡerakato-ḡoi tarimari ḡeri nuḡaraḡe e taḡitaḡi nuḡanai ekira-vararito. ");
INSERT INTO snc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ḡeseḡaḡiato Iesu tu maḡuri, Maria na eḡitaiato, senaḡi ḡena guruḡa asi ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Moḡa murinai ḡia tauri ruarua gabu ta ḡana ḡeraka-iaḡoto-ḡoi nuḡanai, Iesu ḡeri ai efoforito, senaḡi vetoḡana tu eirauto. ");
INSERT INTO snc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Benamo tauri ruarua ḡeḡenoḡoito, karori ḡekira-vararito, senaḡi ḡeri guruḡa asi ḡevaḡa-moḡonirito. ");
INSERT INTO snc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Moḡa murinai ḡena mero gabanana sebona (11) ḡeḡaniḡanito-ḡoi nuḡanai, ḡeri ai efoforito, evanerito, korana asi ḡeri veḡabidadama e ḡeri nuḡa-gwaḡiḡi dainai, korana mase na evariḡisi-ḡenoḡoito murinai, ḡeḡitaiato tarimari ḡeri guruḡa asi ḡevaḡa-moḡonirito. ");
INSERT INTO snc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Benamo ekirarito, ekirato, “Ḡoiaḡo, tanobara mabarari ai Vari Namona tarimarima mabarari ḡoirari ai boḡono ḡobata-iaḡia. ");
INSERT INTO snc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Deikara na mai Vari Namona bevaḡa-moḡoniani ema babatiso beḡabiani tarimana tu bemaḡurini, senaḡi asi bevaḡa-moḡoniani tarimana Barau na rakava voina beviniani. ");
INSERT INTO snc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ḡeveḡabi-dadamani tarimari ḡesi mai vetoḡa beḡe iaḡo-sebonani: Iauka rakavari au aragu ai beḡe lai-vaḡirini. Garo variḡuri irauirau ai beḡe guruḡani. ");
INSERT INTO snc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mota rakavari beḡe ḡabi-vaisini, mase ḡarikiri beḡe niurini, senaḡi asi beḡe vaḡa-rakavarini. Ḡimari keve tarimari iatari ai beḡe tore-kaurini, benamo keve tarimari beḡe namoni.” ");
INSERT INTO snc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesu Vereḡauka na evaḡa-guruḡarito murinai, Barau na eḡabi-vaisiato, guba ḡana evaraḡeto, benamo Barau aroribana rekenai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Benamo Iesu ḡena mero ḡeraka-lausito, gabu mabarari ai ḡea ḡobatato. Vereḡauka maki ḡia ḡesi ḡeḡauvei-vegogoto-ḡoi, ema ḡeri guruḡa evaḡa-moḡonirito-ḡoi nuḡa-farevaḡi veiḡa boruri ai. ");
INSERT INTO snc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vere taumu Teofilo, ḡoi atore-vinimuni. Tarimarima ḡutuma Iesu na eveirito veiḡari ḡita fakarai variri varau ḡetorerito. ");
INSERT INTO snc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tovotovona na tarimarima na matari na ḡeḡitarito dagarari ema ḡeḡobata-iaḡirito variri ilailari ḡevaḡa-ribarato. ");
INSERT INTO snc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Moḡa lorinai au maki atuḡamaḡini, namona maiḡa, Vere o, karakara ḡeḡorato dagarari sigana toḡana na bavetau-ḡitakauri, benamo ḡeḡorato ilailari ai ama torerini ḡoi ḡemu. ");
INSERT INTO snc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Benamo vau bono riba, ḡevaḡa-ribamuto-ḡoi guruḡari tu moḡoni veḡata. ");
INSERT INTO snc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heroda, vere barana o kini, na Iudea tanona eḡitaḡauato-ḡoi nuḡanai, Rubu Veaḡa verena ta etanuto-ḡoi arana Sakaria, Abia ḡena doḡoro tarimana. Ḡaraḡona arana tu Elisabeta. Ḡia maki Arona senena, Rubu Veaḡa vereri doḡorori vavinena. ");
INSERT INTO snc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ḡia tauri ruarua tu vei-iobukaiobuka tarimari Barau ḡoiranai. Vereḡauka ḡena taravatu ema vevaḡa-naḡi mabarabarari ḡekorana-iaḡirito-ḡoi ma nuḡari mabarari ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Senaḡi tauri ruarua asi naturi, korana Elisabeta tu gabani, ema ḡia tauri ruarua tu varau ḡeḡaukato. ");
INSERT INTO snc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ḡaro ta Sakaria ḡena vevaḡa-veaḡa ḡauveiri eveirito Rubu Veaḡai Barau ḡoiranai, korana ḡena doḡoro ḡeri nega dainai. ");
INSERT INTO snc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Benamo Rubu Veaḡa vereri ḡeri veiḡa ilailanai Sakaria ḡeḡabi-hidiato, muramura ma bonana namona bene gabu ḡana. Moḡa lorinai eraka-toḡato Vereḡauka ḡena Rubu Veaḡa nuḡanai, ");
INSERT INTO snc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","a tarimarima mabarari tu murikai ḡeḡuriḡurito-ḡoi muramura egabuto-ḡoi nuḡanai. ");
INSERT INTO snc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Benamo Vereḡauka ḡena aneru ta ḡia ḡenai efoforito, muramura goḡuna ma bonana fatana veaḡana aroriba rekenai eruḡataḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria na eḡitaiato nai, nuḡana efarevaḡito ema egarito. ");
INSERT INTO snc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Senaḡi aneru na ekiraiato, ekirato, “Sakaria, asi nogari, korana ḡemu ḡauḡau Barau na beseḡaḡia. Ḡaraḡomu Elisabeta na natumu ta beḡabiani, arana bono vatoa Ioane. ");
INSERT INTO snc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ḡoi boiakuni, boverereni, tarimarima ḡutuma maki ḡia bemaḡurini nai, beḡe iakuni. ");
INSERT INTO snc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Korana Vereḡauka ḡoiranai ḡia tu vere baregonai beiaḡoni. Ḡia tu vine nanuna asi bene niua ema niuniu dagarari gwaḡiḡiri maki asiḡina moḡo. Ḡia roḡo sinana dianai, Iauka Veaḡa na bevaḡa-vonuani. ");
INSERT INTO snc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ḡia na Isaraela tarimari vovoka beḡori-kurerini Vereḡauka, ḡeri Barau, ḡenai. ");
INSERT INTO snc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Vereḡauka ḡoiranai berakani Elia peroveta tarimana ḡena kokore ema ḡena seḡuka kavana. Tama e natu ḡia na ma bevaḡa-tanu vegogorini. Kira-sirivaḡi tarimari maki bevaḡa-tanu kurerini, vei-iobukaiobuka tarimari ai beḡe iaḡoni; benamo ḡia na tarimarima beḡabi-torerini Vereḡauka ḡena.” ");
INSERT INTO snc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria na aneru ekiraiato, ekirato, “Au tu kamasi baribaiani? Au tu ḡauka, ḡaraḡogu maki beḡauka.” ");
INSERT INTO snc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneru evaḡa-veseto, ekirato, “Au tu Gabriela, Barau ḡoiranai aruḡani. Barau na au betuḡugu, bana vaḡa-guruḡamu ema mai vari namona bana kira-varamu. ");
INSERT INTO snc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Senaḡi au ḡegu guruḡa asi ovaḡa-moḡoniani nai, ḡoi murumu bebubuni, asi boguruḡani, beiaḡoni mo, mai guruḡa anina bea ḡorani ḡaronai. Akiraḡirini dagarari ḡeri nega korikori ai beḡe ḡorani.” ");
INSERT INTO snc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mai veiḡa eḡorato-ḡoi nuḡanai, tarimarima na ḡenari-kavaiato nai, ḡeverorito karase nai Sakaria Rubu Veaḡa nuḡanai ea kwaibo-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eraka-rosito nai, asi evaḡa-guruḡarito, benamo ḡeribato, ḡia tu emata-vanaḡito, kara ta eḡitaiato Rubu Veaḡa nuḡanai. Benamo ḡia na vetoḡai moḡo evaḡa-ribarito, asi eguruḡato, korana muruna ebubuto nai. ");
INSERT INTO snc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaria ḡena ḡauvei ḡarori Rubu Veaḡai evaḡa-koririto murinai, eḡenoḡoito ḡena vanuḡa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Moḡa murinai ḡia ḡaraḡona Elisabeta varau ekuḡato, benamo ḡue imaima (5) etanu-vekuretoḡato numai. ");
INSERT INTO snc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ekirato, “Vereḡauka na bevetuḡagu, maiḡesina au ḡegu ai beveia. Ḡegu maiaka tarimarima ḡoirari ai beḡabi-vaḡia.” ");
INSERT INTO snc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta ma banina ḡue imaima sebona (6) nuḡanai, Barau na aneru ta arana Gabriela etuḡuato vanuḡa ta Galilea nuḡanai arana Nasareta ḡana. ");
INSERT INTO snc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ḡuiato ta monai. Ḡia tu ma kirakauna arana Iosefa, Davida ḡena doḡoro tarimana. Mo ḡuiato arana tu Maria. ");
INSERT INTO snc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneru ḡia ḡenai eiaḡoto, ekirato, “Ḡaro namona, Vereḡauka tu ḡoi ḡesi ema ḡena vevaḡa-namo bara ḡoi ḡemu ai.” ");
INSERT INTO snc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria na mai guruḡa eseḡaḡiato nai, nuḡana evekwaraḡi-rakavato, etuḡamaḡito mai vevaḡa-namo anina tu kara. ");
INSERT INTO snc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Benamo aneru na ma ekiraiato, ekirato, “Maria, asi nogari, Barau na ḡena namo e varevare-bara ḡoi iatamu ai betorea. ");
INSERT INTO snc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ḡoi tu bokuḡani ema mero ta boḡabiani, arana bono vatoa Iesu. ");
INSERT INTO snc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ḡia arana bevaraḡeni ema beḡe kiraḡiani Iaru-korokoro Barauna Natuna. Barau tuḡutuḡu na kini ai bevaḡa-iaḡoani, ḡia senena Davida kavana. ");
INSERT INTO snc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ḡia tu vere tuḡutuḡu ai beiaḡoni, vere betanu-vanaḡi vanaḡini Iakobo besena ḡeri, ḡena Basileia asi bekorini.” ");
INSERT INTO snc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria na aneru ekiraiato, ekirato, “Mai tu kamasi beḡorani? Au tau ta ḡesi tu roḡosi baḡana gena-vegogo.” ");
INSERT INTO snc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneru na evaḡa-veseato, ekirato, “Iauka Veaḡa ḡoi iatamu ai befoforini, Barau ḡena seḡuka na beboroḡimuni. Moḡesina nai ḡoi ḡemuna bemaḡurini merona veaḡana tu Barau Natunai beḡe kiraḡiani. ");
INSERT INTO snc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bono riba, ḡoi garagaramu Elisabeta, ḡia varau beḡauka, senaḡi ma banina. Ribamu, tarimarima na ḡekiraḡiato-ḡoi, ḡia tu gabani vavinena ḡetato-ḡoi, senaḡi toma ḡena ḡue imaima sebona (6) maiḡa. ");
INSERT INTO snc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Korana Barau tu dagara mabarari veiveiri ma ribana.” ");
INSERT INTO snc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ekirato, “Au tu Vereḡauka ḡena vetuḡunaḡi vavinegu, be bokira kavana au ḡegu ai bene ḡora.” Benamo aneru na eraga-kwaneato, erakato. ");
INSERT INTO snc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mo negai Maria evariḡisito, Iudea ḡorori vanuḡana ta ḡana eraga-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Monai Sakaria ḡena numai eraḡekauto, Elisabeta evaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeta na Maria ḡena vevaḡa-namo guruḡana eseḡaḡiato nai, natuna tu diana nuḡanai eḡarevato, benamo Elisabeta Iauka Veaḡa na evaḡa-vonuato, mamina eḡabiato. ");
INSERT INTO snc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Benamo eguruḡa-baregoto, ekirato, “Vavine vefakari ai Barau ḡena vevaḡa-namo ḡoi iatamu ai tu barego vedaurea, ema boḡabiani merona iatanai maki! ");
INSERT INTO snc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Senaḡi au ḡegu namo tu kara Vereḡauka sinana ḡegu ai beiaḡoma? ");
INSERT INTO snc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ḡemu vevaḡa-namo guruḡana baseḡaḡia nai, natugu tu nuḡagu ai eiakuni nai eḡarevani. ");
INSERT INTO snc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ḡoi overereni, korana oveḡabi-dadamato, Vereḡauka ḡena guruḡa bemoḡonini otato nai.” ");
INSERT INTO snc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Benamo Maria ekirato, “Au nuḡagu na Vereḡauka evaḡa-raḡeani. ");
INSERT INTO snc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au iaukagu na maki au vaḡa-maḡurigu Barauna eiaku-viniani, ");
INSERT INTO snc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","korana tu au, ḡena vetuḡunaḡi vavinena, ḡegu tanu lealeai roḡo etuḡamaḡi-taḡoguni! Mainana, beiaḡoni mo, ḡuru mabarari beḡe kirani, Barau ḡena vevaḡa-namo tu au iatagu ai beḡe toni, ");
INSERT INTO snc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","korana tu veiḡa baregori Seḡuka Barauna na au ḡegu ai beveiri. Ḡia arana tu veaḡa. ");
INSERT INTO snc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ḡena vetuḡaḡwa tu ḡia ḡegari-viniani tarimari iatari ai betoreani, ḡuru ta beiaḡoni ḡuru ta iatari ai betanuni. ");
INSERT INTO snc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ḡia ḡimana eḡabi-vaisirito seḡukana na ḡeveiavini tarimari elai-karovorito. ");
INSERT INTO snc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ḡia na vere baregori ḡeri tanutanu gaburi na edori-firiḡorito, a tanu lealea tarimari ḡia na eḡabi-vaisirito. ");
INSERT INTO snc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vito tarimari maki dagara namori ai evaḡa-vonurito, a farefare vovoka tarimari ḡia na ḡimari kori evaḡa-ḡenoḡoirito. ");
INSERT INTO snc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ḡena kiraḡitore ḡita tubura ḡatara Isaraela tarimari ḡesi asi etuḡa-rekwarito, ema ḡia eiaḡomato ḡena vetuḡunaḡi tarimari Isaraela bene vaḡa-kavari ḡana, ");
INSERT INTO snc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","senera ekiraḡitore-vinirito ilailana. Aberahamo ma besena ḡesi roḡo bevetuḡa-ḡwa vanaḡi-vanaḡirini, etato.” ");
INSERT INTO snc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria monai tu Elisabeta ḡesi ḡetanuto ḡue toitoi (3). Moḡa murinai ḡena vanuḡa ḡana ma eḡenoḡoi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeta ḡena ḡabi ḡarona varau eraḡasito nai, mero ta eḡabiato. ");
INSERT INTO snc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Benamo sevinai ḡetanuto tarimari ema garagarana na varina ḡeseḡaḡiato nai, ḡia ḡesi ḡeiaku-vegogoto, korana Vereḡauka ḡena namo e varevare-bara ḡia ḡenai eḡorato nai. ");
INSERT INTO snc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ḡaro vaḡa-imaima toitoinai (8) mero tauḡanina kefina beḡene lama-vaḡia ḡana ḡevegogoto. Mai ḡaro sebonai maki arana beḡene vatoa Sakaria, tamana beḡene turaia ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Senaḡi sinana asi eurato nai ekirato, “Asiḡina! Ḡia arana tu Ioane.” ");
INSERT INTO snc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ḡia ḡekirato, “Senaḡi ḡoi ḡemu bese nuḡanai mai ara tu asiḡina!” ");
INSERT INTO snc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Benamo ḡia na mero tamana ḡimari ai moḡo ḡedanaḡiato, mero arana tu deikara beḡene si. ");
INSERT INTO snc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria na toretore vetuḡuna ta ekiraḡiato, benamo maiḡesi etoreato, “Ḡia arana tu Ioane.” Benamo mabarari nuḡari ḡefarevaḡito. ");
INSERT INTO snc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Monai vau muruna evekeoto, meana maki eroroḡototo, benamo eguruḡato, Barau evaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Moḡa lorinai seviri ai ḡetanuto tarimari mabarari ḡeḡaba-rakavato ema mo veiḡa varina Iudea ḡoro vanuḡari mabarari nuḡari ai ḡevari-fiuato. ");
INSERT INTO snc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Varina ḡeseḡaḡiato tarimari mabarari na ḡetuḡamaḡi-iaḡiato, ḡekirato, “Mai mero tu kamasi beveini?” Korana tu Vereḡauka ḡimana seḡukana tu ḡia iatanai. ");
INSERT INTO snc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ioane tamana Sakaria Iauka Veaḡa na evaḡa-vonuato, benamo Barau ḡena guruḡa evaḡa-foforiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Vereḡauka, Isaraela tarimari ḡeri Barau, sivaḡa-namoa, korana tu ḡia ḡena bese tarimari eiaḡoma-vinirito bene voi-ḡenoḡoiri ema bene vaḡa-maḡuriri ḡana. ");
INSERT INTO snc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vevaḡa-maḡuri tauna ma seḡukana ḡesi etuḡuato ḡita ḡera, ḡia tu ḡena vetuḡunaḡi tauna Davida garakana. ");
INSERT INTO snc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mai kiraḡitore tu ḡena peroveta tarimari veaḡari na irau laḡani ai ḡekiraḡi-foforiato: ");
INSERT INTO snc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ḡita tu ḡia na ekira-ḡaurato, ḡevetari-vinirani ema ḡebaru-vinirani tarimari ḡimari na ḡia na bevaḡa-maḡurirani etato. ");
INSERT INTO snc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ekirato maki, ḡita tubura ḡatara bevetuḡa-ḡwarini, ema ḡena kiraḡitore veaḡana asi betuḡa-rekwaiani. ");
INSERT INTO snc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ḡia na ḡita senera Aberahamo ekiraḡitore-viniato, ");
INSERT INTO snc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","benamo ekirato, ḡevetari-vinirani tarimari ḡimari na beḡabi-maḡurirani. Benamo vetuḡunaḡina bisini iaḡo-vini asi garira ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ḡoiranai bisini raka ma veaḡara e ma iobukaiobukara ḡesi ḡera maḡuri ḡarori mabarari ai. ");
INSERT INTO snc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Natugu o, ḡoi tu Iaru-korokoro Barauna ḡena peroveta tarimana beḡe kiraḡimuni, korana tu boraka-guineni Vereḡauka ḡena dabara bono vaḡa-maḡataia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ḡena bese tarimari bono vaḡa-ribari, ḡia na ḡeri rakava bene tuḡamaḡi-fitoḡari ema bene vaḡa-maḡuriri. ");
INSERT INTO snc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Korana ḡita ḡera Barau ḡena vetuḡaḡwa tu barego ḡita ḡerai. Ḡaro eraḡekauni mamana kavana vevaḡa-maḡuri ḡita iatarai betanuni. ");
INSERT INTO snc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Benamo mukunai e mase gari nuḡanai ḡetanuni tarimari bevaḡa-mamarini, ema maino dabaranai beḡori-kaurini.” ");
INSERT INTO snc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ioane ebaregoto ema iaukana egwadato. Tano fakanai etanuto-ḡoi, eiaḡomato mo, Isaraela tarimari ḡeri ai efoforito ḡarona. ");
INSERT INTO snc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mo negai Kaisara Augusto, Roma ḡeri vere, na ḡena vevaḡa-naḡi etuḡuato, tanobara tarimari mabarari arari beḡene toreri, sensisi beḡene ḡabia. ");
INSERT INTO snc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mai tu sensisi giniguinena, Kwirinio na Siria evereato-ḡoi neganai ḡeḡabiato. ");
INSERT INTO snc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Moḡa lorinai tarimarima mabarari arari toretoreri uranai tata ḡeri vanuḡa korikori ḡana ḡeḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosefa maki erakato. Nasareta, Galilea rekena vanuḡa ta na, Betelehema ḡana eiaḡoto, Iudea rekena vanuḡa ta, Davida ḡena vanuḡa. Mo ḡana eiaḡoto, korana ḡia tu Davida ḡena doḡoro tarimana. ");
INSERT INTO snc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Monai arana beḡene torea ḡana, ḡia kirakauna Maria ḡia ḡesi ḡeiaḡoto. Ḡia tu ma banina. ");
INSERT INTO snc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tauri ruarua monai ḡetanuto-ḡoi nuḡanai, ḡena ḡabi ḡarona varau evotuto. ");
INSERT INTO snc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ḡia eḡabito, mero guinena eḡabiato, dabuḡai eseḡoato, boromakau ḡeri ḡaniḡani fatanai evaḡa-genakauato, korana varivari tarimari ḡeri numa asi faka ta dainai. ");
INSERT INTO snc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mo tano monai mamoe ḡenaririto-ḡoi tarimari kota tu boḡai ḡetanuto-ḡoi, boḡi ai ḡeri mamoe ḡeḡitaḡaurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Benamo Vereḡauka ḡena aneru ta ḡia ḡeri ai efoforito, Vereḡauka mamana na emama-taririto; ḡegari-rakavato, ");
INSERT INTO snc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","senaḡi aneru na ekirarito, ekirato, “Asi ḡogari! Vari Namona au na baḡwa-iaḡomaia ḡomi ḡemi, tarimarima mabarari vaḡa-iakuri ema vaḡa-verereri ḡana. ");
INSERT INTO snc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Maitoma Davida ḡena vanuḡai ḡemi vevaḡa-maḡuri tarimana bemaḡuri, Keriso Vereḡauka! ");
INSERT INTO snc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vetoḡana tu maiḡa, mero raraka-raraka boḡo doḡariani boromakau ḡeri ḡaniḡani fatanai genakau, dabuḡa na beseḡoa.” ");
INSERT INTO snc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Benamo asikauna guba aneruri ḡutuma mai aneru sebona ḡesi ḡefofori-barato, Barau ḡevaḡa-namoato, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Guba tuḡuna vanigerenai Barau beḡene vonevone-raḡe vinia, ema tanobarai maino ḡia na eiaunamo-vinirini tarimari na beḡene ḡabia!” ");
INSERT INTO snc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneru mabarari na ḡeraga-kwanerito, guba ḡana ḡeḡenoḡoito murinai, mamoe ḡitaḡauri tarimari ḡeguruḡa-vegogoto, ḡekirato, “Ḡita tu Betelehema ḡana si-iaḡo, Vereḡauka na bevaḡa-ribara dagarana sia ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Benamo ḡeraga-iaḡoto, Maria e Iosefa ḡedoḡaririto, mero keina maki boromakau ḡeri ḡaniḡani fatanai genataḡonai ḡeḡoitaḡoato. ");
INSERT INTO snc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mero ḡeḡitaiato, benamo aneru na ḡevaḡa-ribarito mero varina ḡekiraḡi-foforiato. ");
INSERT INTO snc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Benamo ḡeseḡaḡito tarimari mabarari mamoe ḡitataḡori tarimari ḡeri guruḡa na nuḡari ḡefarevaḡito. ");
INSERT INTO snc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria na mo guruḡa mabarari nuḡanai etorerito ema etuḡamaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoe ḡeḡitaḡauto-ḡoi tarimari ḡeḡenoḡoito, Barau ḡevevato-iaḡiato, ḡevaḡa-raḡeato, korana ḡeseḡaḡirito ema ḡeḡitarito dagarari tu moḡoni, aneru na ḡia evaḡa-ribarito ilailana. ");
INSERT INTO snc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ḡaro vaḡa-imaima toitoinai (8), mero tauḡanina kefina beḡe lama-vaḡiani ḡaronai, ḡia arana ḡevatoato, Iesu. Sinana na roḡosi bene ḡoitaḡoa nuḡanai, aneru na ekiraḡiato arana ḡeviniato. ");
INSERT INTO snc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mero eḡorato ḡaro gabana vasivasi (40) murinai, ḡia ḡeri veiareva ḡarona eraḡasito, Mose ḡena taravatu ekirani ilailanai. Benamo Iosefa e Maria na Iesu Ierusalema ḡana ḡeḡwa-iaḡoato, Vereḡauka ḡoiranai ḡea vaḡa-foforia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Korana Vereḡauka ḡena taravatu ekirani, “Ḡora guine merori mabarari tu veaḡa Vereḡauka ḡena.” ");
INSERT INTO snc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vere-ḡauka ḡena taravatu ilailana varevare dagarana beḡene vinia ḡetato, pune ruarua o pune variḡuri ruarua. ");
INSERT INTO snc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tau ta Ierusalemai etanuto-ḡoi, arana tu Simeona. Ḡia tu vei-iobukaiobuka tarimana ema Barau ḡena taravatu ekorana-iaḡiato-ḡoi tarimana. Ḡia na Isaraela ḡeri vevaḡa-maḡuri enariato-ḡoi ema Iauka Veaḡa na evaḡa-vonuato. ");
INSERT INTO snc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iauka Veaḡa na maki evaḡa-guruḡaiato, ekirato, ḡia asi roḡo bemaseni mo, Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), roḡo beḡitaiani. ");
INSERT INTO snc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iauka Veaḡa na Rubu Veaḡa nuḡanai Simeona eḡori-toḡaiato vau, Iesu tamana ema sinana na ḡeḡwa-toḡaiato, taravatu ekirani veiḡana beḡene veia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Benamo Simeona na mero eḡabiato, efaniato, Barau evaḡa-namoato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vereḡauka, ḡemu vetuḡunaḡi tauna mai vau bono tuḡu-fitoḡagu, ma mainogu ḡesi mai baiaḡoni ḡemu kiraḡitore vaḡa-ilailana. ");
INSERT INTO snc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Varau ḡemu vevaḡa-maḡuri matagu na bama ḡitaia, ");
INSERT INTO snc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ḡoi na ovei-toreato tarimarima mabarari ḡoirari ai. ");
INSERT INTO snc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mamana maiḡa, bese irauirau vaḡa-mama-iaḡiri, ma ḡoi ḡemu bese Isaraela vevato-iaḡiri ḡana.” ");
INSERT INTO snc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mero tamana e sinana na Simeona ḡena guruḡa ḡeseḡaḡito nai, ḡeḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Benamo Simeona na tauri ruarua evaḡa-namorito, Maria ekiraiato, ekirato, “Mai mero na Isaraela tarimari ḡutuma vaḡa-ketori ema ḡutuma vaḡa-vaisiraḡeri ai beiaḡoni. Ḡia tu vetoḡa ta Barau ḡenana, tarimarima ḡutuma na beḡe kiraḡi-fitoḡaiani, ");
INSERT INTO snc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","moḡesi tarimarima nuḡari vekuretoḡari dagarari mabarari beḡea foforini. Ḡoi, Maria, maki midigumidigu asikei boḡoitaḡoni, noḡa moḡo lorumu kaia na beḡe gwanu-toḡaiani midiguna kavana.” ");
INSERT INTO snc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Monai peroveta vavinena ta arana Ana. Ḡia tu Fanuela natuna, Asere ḡena doḡoro vavinena. Ḡia tu eveḡaraḡoto, laḡani imaima ruarua (7) ḡaraḡona ḡesi ḡetanuto, ");
INSERT INTO snc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","benamo evabuto, laḡani gabana imaima ma gabana toitoi vasivasi (84) etanuto, varau eḡaukato. Rubu Veaḡa asi eraga-kwaneato, laḡani e boḡi ai Barau etoma-rakariḡo viniato-ḡoi, eḡuriḡurito-ḡoi ema eḡaniveaḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mo hora sebonai ḡia maki eraḡasito, benamo Barau evaḡa-namoato, Ierusalema vaḡa-maḡurina ḡenariato-ḡoi tarimari ḡoirari ai mai mero varina ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosefa ema Maria na Vereḡauka ḡena taravatu ekirani veiḡari mabarari ḡeveirito murinai, Galilea ḡana ḡeḡenoḡoito, ḡeri vanuḡa Nasareta ḡana. ");
INSERT INTO snc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mai mero ebaregoto ma gwadana ḡesi; Barau ḡena iaunega na evonuvonu-raḡeto ema ḡena namo e varevare-bara tu ḡia iatanai. ");
INSERT INTO snc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Laḡani mabarari nuḡari ai Iesu tamana ema sinana tu Ierusalema ḡana ḡeiaḡoto-ḡoi, Pasova verekona dainai. (Moḡa tu Iuda tarimari mase aneruna na evanaḡirito moḡo, asi evaḡirito verekona). ");
INSERT INTO snc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu ḡena laḡani gabanana ruarua (12) eḡabiato nai, ḡia maki tamana ema sinana ḡesi vereko urana ḡeiaḡoto, ḡeveito-ḡoi kavana. ");
INSERT INTO snc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Vereko ekorito murinai, ḡeḡenoḡoito ḡeri vanuḡa ḡana, senaḡi ḡia asi ribari, Iesu tu Ierusalemai ḡeraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ḡia ḡeri tuḡamaḡi Iesu tu ḡia ḡesi. Ḡaro sebona ḡerakato murinai, garagarari ema ḡatari fakari ai ḡevetauato. ");
INSERT INTO snc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ḡevetauto nuḡanai asi ḡeḡoitaḡoato, moḡa lorinai ma ḡeḡenoḡoito Ierusalema ḡana Iesu vetauvetauna. ");
INSERT INTO snc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ḡaro toitoi murinai ḡeḡoitaḡoato, Iesu tu Rubu Veaḡa nuḡanai Iuda tarimari ḡeri vevaḡa-riba tarimari ḡesi. Barau ḡena guruḡa ḡekiraḡirito-ḡoi eseḡaḡirito-ḡoi ema ḡia na maki edanaḡirito-ḡoi mai guruḡa aniri tu kara. ");
INSERT INTO snc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mabarari na Iesu ḡena vedanaḡi ema evaḡa-veseto guruḡari ḡeseḡaḡito nai, ḡeḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iesu tamana ema sinana mainai ḡeḡoitaḡoato nai, nuḡari ḡefarevaḡi-rakavato, benamo sinana na ekiraiato, ekirato, “Natugu, karase nai ḡoi na ḡai maiḡesi boveima? Ḡoi tamamu ema au tu ḡoi daimu ai dabarama maki beḡe doko, kamasi ta mai bovei baḡasi.” ");
INSERT INTO snc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu ekirato, “Karase nai au ḡovetauguni? Ḡomi asi ribami au tu Tamagu ḡena numai?” ");
INSERT INTO snc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Senaḡi ḡia asi ribari, Iesu karase maiḡesina evevaḡa-veseto. ");
INSERT INTO snc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Moḡa murinai Iesu tamana ma sinana ḡesi ḡeḡenoḡoito Nasareta ḡana. Ḡeri guruḡa mabarari eiaḡo-vinirito-ḡoi. Maiḡeri dagara ḡeḡorato mabarari Maria na nuḡanai etorerito ema etuḡamaḡi taḡorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu efutuato ma iaunegana ḡesi, Barau ema tarimarima na maki ḡeuraviniato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio Kaisara, Roma ḡeri vere, evereto laḡani gabanana imaima (15) nuḡanai, Pontio Pilato tu Iudea ḡeri gavana, Heroda tu Galilea verena, tarina Filipo tu Iturea ma Trakoniti tanori ḡeri vere, Lisania tu Abilene verena. ");
INSERT INTO snc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas ma Kaiafas tu Rubu Veaḡa vereri baregori. Mo negai Barau na Ioane Sakaria evaḡa-guruḡaiato tano fakanai. ");
INSERT INTO snc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Benamo Ioane na Ioridana ḡarukana tanona mabarana eraka-vaḡa-ḡauato, eḡobatato-ḡoi, tarimarima ḡeri rakava ḡerina beḡene vetuḡamaḡi-kure e beḡene raka-kure, ema babatiso beḡene ḡabia, Barau na ḡeri rakava bene tuḡamaḡi-fitoḡari ḡana. ");
INSERT INTO snc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaia, peroveta tarimana, ḡena bukai etoreato ilailanai, ekirato, “Tarima ta tano fakanai ekeani, ekirani, ‘Vereḡauka ḡena dabara ḡoiarevaia, ḡena iaḡoma dabarana ḡovaḡa-maoromaoroa. ");
INSERT INTO snc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Douka gaburi mabarari boḡono vaḡa-vonuri, ḡoro baregori e ḡoro keiri mabarari boḡono vaḡa-faiarari. Dabara ḡeḡeva-ḡeḡevari boḡono vaḡa-maoromaorori, ema dabara koufakoufari maki boḡono vaḡa-vonuri. ");
INSERT INTO snc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Benamo tarimarima mabarari na Barau ḡena vevaḡa-maḡuri beḡe ḡitaiani!’” ");
INSERT INTO snc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tarimarima ḡutuma Ioane ḡenai ḡeiaḡoto, bene babatisori ḡana. Benamo Ioane na eḡobatarito, ekirarito, “Ḡomi mota naturi, dei na bekirami, Barau ḡena vevaḡa-maoro ḡenana boḡo raga-maḡurini? ");
INSERT INTO snc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ḡemi rakava ḡerina boḡono vetuḡamaḡi-kure, ema boḡono raka-kure Barau ḡenai, benamo ḡemi maḡuri ai ḡwaḡwa namori boḡono buri. Asi boḡono kira, ‘Aberahamo tu ḡai tamama, (be Barau na beḡabi-raḡemani).’ Korana boḡono riba, Barau tu ma seḡukana Aberahamo natuna tu mai fore ḡerina bevaḡa-ḡorarini! ");
INSERT INTO snc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Koko tu ḡau korari ai varau beḡe toreri. Benamo ḡwaḡwa namori asi beḡe ḡwani ḡauri mabarari tu beḡe basirini, karavai beḡe fiu-raḡerini.” ");
INSERT INTO snc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Vegogo tarimari na Ioane ḡedanaḡiato, ḡekirato, “Be, ḡai tu kara baḡana vei?” ");
INSERT INTO snc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ḡia na evaḡa-veserito, ekirato, “Ḡomi deidei ḡemi sedi ruarua nai, ta tu asi ḡena sedi tarimana bono vinia, e ma ḡana ḡaniḡani tarimana na maki moḡesi bene vei.” ");
INSERT INTO snc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takesi gogo tarimari maki babatiso beḡene ḡabi ḡana Ioane ḡenai ḡeiaḡoto, ḡedanaḡiato, ḡekirato, “Vevaḡa-riba taumu, ḡai tu kamasi baḡana vei?” ");
INSERT INTO snc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ḡia evaḡa-veseto, ekirato, “Taravatu ekirani lorinai moḡo boḡono gogo.” ");
INSERT INTO snc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Vetari tarimari o soldia na maki ḡedanaḡiato, ḡekirato, “Ḡai maki kamasi baḡana vei? Ḡia evaḡa-veseto, ekirato, “Tarima ḡeri moni asi boḡono verariri ema asi boḡono kira-rakavari. Ḡomi davami dainai maki asi boḡono mugumugu.” ");
INSERT INTO snc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tarimarima nuḡari ai maiḡesi ḡetuḡamaḡito, “Mai tarima tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), banaḡu,” ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Benamo Ioane na mabarari evaḡa-guruḡarito, ekirato, “Au tu nanu na ababatisomini, senaḡi tarima ta beiaḡomani, ḡia ḡena seḡuka na au ḡegu seḡuka tu evanaḡiani. Au tu asi ilaila ḡia ḡena tamaka varona baruḡaiani. Ḡia na Iauka Veaḡa ema karava na bebabatisomini. ");
INSERT INTO snc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ḡia ḡimanai tu iareva-iareva dagarana, widi momona tu widi tauri ḡenana bene iareva-ḡitakauri ḡana. Benamo widi tu ḡena vaḡa-vegogo numanai bevaḡa-vegogorini, senaḡi widi momona tu begabuani asi ebuseni karavanai.” ");
INSERT INTO snc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioane na mo guruḡai ema guruḡa ḡutumai maki Barau ḡena Vari Namona tarimarima eḡobata-vinirito, ema enoḡirito, ḡeri rakava ḡerina beḡene vetuḡamaḡi-kure. ");
INSERT INTO snc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ioane na maki Heroda, Galilea verena, evaneato, korana tu ḡia kakana Filipo ḡaraḡona eḡaraḡoato nai, ema veiḡa rakavari ḡutuma eveirito nai. ");
INSERT INTO snc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroda na mo rakava mabarari iatari ai ta ma etore-kauato, ḡia na Ioane dibura numanai ma ekou-ḡauato. ");
INSERT INTO snc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tarimarima mabarari Ioane na ebabatisorito-ḡoi nai, Iesu maki ebabatisoato. Benamo Iesu eḡauḡauto-ḡoi nuḡanai, guba evekeo-fakato, ");
INSERT INTO snc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iauka Veaḡa emariḡoto ḡia iatanai, vetoḡana noḡa pune kavana. Garo ta guba na ekea-riḡoto, ekirato, “Ḡoi tu au Natugu, aura-vinimuni; ema ḡemu ai aiaku-rakavani maki.” ");
INSERT INTO snc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu na ḡena ḡauvei esinaiato nai, ḡena laḡani tu gabana toitoi (30) kavana. Tarimarima ḡekirato-ḡoi, ḡia tu Iosefa natuna. Besena tu maiḡeri: Iosefa tu Heli natuna, ");
INSERT INTO snc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tu Matat natuna, Matat tu Levi natuna. Levi tu Melki natuna. Melki tu Ianai natuna. Ianai tu Iosefa natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosefa tu Matatia natuna. Matatia tu Amosa natuna. Amosa tu Nahum natuna. Nahum tu Eseli natuna. Eseli tu Nagai natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tu Mahat natuna. Mahat tu Matatia natuna. Matatia tu Semein natuna. Semein tu Ioseka natuna. Ioseka tu Ioda natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ioda tu Ioanan natuna. Ioanan tu Resa natuna. Resa tu Serubabele natuna. Serubabele tu Sealtiele natuna. Sealtiele tu Neri natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tu Melki natuna. Melki tu Adi natuna. Adi tu Kosam natuna. Kosam tu Elmadam natuna. Elmadam tu Ere natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere tu Iosua natuna. Iosua tu Eliesere natuna. Eliesere tu Iorim natuna. Iorim tu Matat natuna. Matat tu Levi natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi tu Simeona natuna. Simeona tu Iuda natuna. Iuda tu Iosefa natuna. Iosefa tu Ionam natuna. Ionam tu Eliakim natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim tu Melea natuna. Melea tu Mena natuna. Mena tu Matata natuna. Matata tu Natan natuna. Natan tu Davida natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davida tu Iese natuna. Iese tu Obed natuna. Obed tu Boas natuna. Boas tu Salmone natuna. Salmone tu Nasona natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasona tu Aminadab natuna. Aminadab tu Admin natuna. Admin tu Areni natuna. Areni tu Hesron natuna. Hesron tu Perese natuna. Perese tu Iuda natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iuda tu Iakobo natuna. Iakobo tu Isako natuna. Isako tu Aberahamo natuna. Aberahamo tu Tera natuna. Tera tu Nahoro natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoro tu Serug natuna. Serug tu Reu natuna. Reu tu Peleg natuna. Peleg tu Ebere natuna. Ebere tu Sela natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela tu Kainana natuna. Kainana tu Afasada natuna. Afasada tu Sem natuna. Sem tu Noa natuna. Noa tu Lameka natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameka tu Metusela natuna. Metusela tu Enoka natuna. Enoka tu Iared natuna. Iared tu Mahalalel natuna. Mahalalel tu Kainana natuna. ");
INSERT INTO snc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainana tu Enos natuna. Enos tu Seta natuna. Seta tu Adamu natuna. Adamu tu Barau natuna. ");
INSERT INTO snc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Ioridana ḡarukanai Iauka Veaḡa na evaḡa-vonuato vau, ea ḡenoḡoito, benamo Iauka na tano fakana ḡana eḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Monai ḡaro e boḡi gabana vasivasi (40) Diabolo na eribaḡaniato-ḡoi. Mo ḡaro mabarari nuḡari ai asi eḡaniḡanito-ḡoi, moḡa lorinai mo ḡaro ḡekorito murinai, ḡia evito-rakavaiato. ");
INSERT INTO snc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Diabolo na ekiraiato, ekirato, “Bema ḡoi Barau Natuna nai, mai fore nokiraia, be ḡaniḡani ai neiaḡo.” ");
INSERT INTO snc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A Iesu na evaḡa-veseato, ekirato, “Buka Veaḡa nuḡanai maiḡesi ekirani, ‘Tarimarima tu dia ḡaniḡani na moḡo bemaḡurini.’” ");
INSERT INTO snc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Benamo Diabolo na Iesu eḡori-raḡeato gabu ta tuḡunai, tanobara basileiari mabarari vaḡa-sebo evaḡa-ḡitaiato. ");
INSERT INTO snc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Benamo Diabolo ekirato, “Au na seḡuka bavinimuni, maiḡeri dagara mabarari boḡita-ḡaurini, aramu maki bebaregoni. Mai dagara mabarari tu au ḡegu, benamo aura-viniani tarimana baviniani. ");
INSERT INTO snc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Moḡa lorinai bema au botoma-rakariḡo viniguni nai, maiḡeri dagara mabarari boḡabirini ḡoi ḡemu.” ");
INSERT INTO snc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Senaḡi Iesu evaḡa-veseto, ekirato, “Buka Veaḡai tu maiḡesi ḡetoreato, ‘Vereḡauka, ḡoi ḡemu Barau bono toma-rakariḡo vinia, ḡia moḡo ḡereḡana vetuḡunaḡina bono iaḡo-vini!’” ");
INSERT INTO snc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Benamo Satani na Ierusalema ḡana eḡori-iaḡoato, Rubu Veaḡa tuḡunai evaḡa-ruḡakauato, ekiraiato, “Bema ḡoi Barau Natuna, mainana noburi-firiḡo, ");
INSERT INTO snc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","korana Buka Veaḡa nuḡanai maiḡesi ekirani, ‘Barau na ḡena aneru bekirarini, ḡoi beḡe narimuni.’ ");
INSERT INTO snc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ekirani maki, ‘Aneru na ḡimari na beḡe ḡobemuni, beḡe ḡabi-vaisimuni, kwakumu fore ai asi boraraiani.’” ");
INSERT INTO snc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu evaḡa-veseto, ekirato, “Buka Veaḡa nuḡanai maki ekirani, ‘Vereḡauka ḡoi ḡemu Barau asi bono riba-ḡania.’” ");
INSERT INTO snc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satani ḡena veribaḡani mabarari evaḡa-koririto, benamo eraga-kwaneato, eiaḡoto mo, ḡaro ta. ");
INSERT INTO snc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu ma eḡenoḡoito Galilea ḡana, Iauka Veaḡa seḡukana maki ḡia ḡesi. Ḡia varina Galilea tano nuḡanai ḡefiu-rovorovoato. ");
INSERT INTO snc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesu tu ḡeri rubu nuḡari ai evevaḡa-ribato-ḡoi, mabarari na ḡevaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Benamo Iesu Nasareta ḡana eiaḡoto. Mai tu ḡia ebaregoto vanuḡana. Vanaḡivanaḡi eveito-ḡoi kavana Sabadi ai ḡia rubu ai eraka-toḡato. Benamo Buka Veaḡa bene iavia ḡana evariḡisito nai, ");
INSERT INTO snc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaia peroveta tarimana ḡena buka rubu ḡitaḡauna tarimana na Iesu eviniato, benamo ḡia na ereraiato, ḡena iavi-iavi gabuna eḡoitaḡoato, maiḡesi ekirani, ");
INSERT INTO snc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Vereḡauka Iaukana tu au ḡegu ai maiḡa, korana ḡia na tu au eboroḡiguto, ema eviriḡiguto, Vari Namona gara veḡubu tarimari bana ḡobata-viniri ḡana. Etuḡuguto, dibura tarimari ḡeri ai Barau na dibura na varau eḡabi-vaḡirato varina bana varifiua ḡana, ema mata-bubu tarimari matari maki beḡene fafa. Ḡevaḡa-rakavarini tarimari bana vaḡa-maḡuriri, ");
INSERT INTO snc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ema Vereḡauka na tarimarima bevaḡa-maḡuririni laḡanina bana ḡobata-iaḡia.” ");
INSERT INTO snc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Benamo Iesu na buka ma eiokuato, rubu ḡitaḡauna tarimana ma evini-ḡenoḡoiato, benamo etanu-tarito. Mabarari rubu nuḡanai tarimari na ḡeḡita-karakaraiato. ");
INSERT INTO snc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Benamo Iesu na eḡobata-vinirito, ekirato, “Mai boḡo seḡaḡia guruḡana tu toma ḡaro ai bemoḡoni.” ");
INSERT INTO snc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Benamo mabarari na ḡevaḡa-namoato e ḡeḡabato, korana guruḡa namori ekiraḡirito nai. Ḡekirato, “Mai tu Iosefa natuna ba?” ");
INSERT INTO snc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Benamo Iesu na ekirarito, ekirato, “Au ribagu ḡomi na mai sisiba guruḡana au ḡegu ai boḡo kira-varaguni, boḡo kirani, ‘Doketa tarimamu, tauḡemu bono vevaḡa-maḡuri! Kaperanaumai oveirito veiḡari variri ḡama seḡaḡirito, be mainai ḡemu vanuḡa korikori ai maki bono vei.’” ");
INSERT INTO snc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Moḡoni akiramini, peroveta tarimana tu ḡena vanuḡa korikori ai asi beḡe ḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Maiḡa maki boḡono seḡaḡi: Moḡoni, Elia ḡena negai vabu ḡutuma Isaraelai ḡetanuto-ḡoi. Laḡani toitoi (3) ma ḡue imaima sebona (6) nuḡanai ḡura asi eraguto-ḡoi, tanobara mabarana doḡe na eḡabi-ḡauato. ");
INSERT INTO snc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Senaḡi mo Isaraela vaburi ḡeri ai Barau na Elia asi etuḡu-iaḡoato. Irau gabu vanuḡana ta arana Sarefata, Sidono tanonai, vabu ta ḡenai etuḡu-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elisa, peroveta tarimana, ḡena negai lepera tarimari ḡutuma Isaraelai ḡetanuto-ḡoi, senaḡi sebona ta asi evaḡa-namoato, Naman, Siria tarimana, moḡo ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rubu ai ḡevegogoto tarimari mabarari mo guruḡa ḡeseḡaḡiato nai, ḡebaru-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Benamo ḡevariḡisito, Iesu vanuḡa na ḡeinu-rosiato, ḡeri vanuḡa ḡevaḡa-ruḡaiato ḡorona tavi ta reke lofa asikeina na beḡene fiu-riḡoa ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Senaḡi Iesu tu ḡia fakari na moḡo eraka-vaḡito, mo eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu tu Kaperanauma, Galilea vanuḡana ta, ḡana evariḡoto. Benamo Sabadi ai evevaḡa-ribato. ");
INSERT INTO snc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ḡia ḡena vevaḡa-riba guruḡari tarimarima na ḡeseḡaḡiato nai, ḡeḡaba-rakavato, korana ḡena guruḡa ma seḡukana. ");
INSERT INTO snc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Rubu nuḡanai iauka rakavana na eboroḡiato tarimana ta etanu-taḡoto-ḡoi. Ḡia ekoḡo-gigitarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iesu, Nasareta taumu o, kara ḡemai noveia otoni? Ḡoi ḡai vaḡa-rakavama uranai boiaḡoma, ene? Au ribagu, ḡoi tu Barau ḡena Veaḡa Tarimamu.” ");
INSERT INTO snc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu na ekira-ḡoiato, ekirato, “Gurumu, ḡia ḡenana noraka-vaḡi!” Benamo mo iauka rakavana na tano eḡidara-iaḡiato tarimarima ḡoirari ai, ḡia ḡenana eraka-vaḡito, fau ta maki asi efoforito ḡia ḡenai. ");
INSERT INTO snc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Benamo tarimarima mabarari nuḡari ḡefarevaḡi-rakavato, ḡeveguruḡa-vevinito, ḡekirato, “Mainai kamasi eguruḡani? Be, ma seḡukana e ma gwadana ḡesi iauka rakavari evaḡa-guruḡarini, benamo ḡeraka-vaḡini!” ");
INSERT INTO snc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Benamo Iesu varina mo gabu mabaranai ḡefiu-rovorovoato. ");
INSERT INTO snc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu rubu eraga-kwaneato, benamo Simona ḡena numa ḡana eiaḡoto. Simona ḡena taḡama vavinena ekeveto, tauḡanina eseḡuka-rakavato; benamo Iesu ḡenoḡiato bene vaḡa-kavaia. ");
INSERT INTO snc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Benamo Iesu eiaḡoto mo vavine sevinai eruḡato, keve ekira-ḡoiato, benamo keve ekorito. Vavine maoromaoro evariḡisito, benamo eḡuburito. ");
INSERT INTO snc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ḡaro ea keto-firiḡoto-ḡoi nai, tarimarima na keve irauirau tarimari mabarari Iesu ḡenai ḡeḡori-iaḡorito. Ḡia ḡimana tarima tata iatari ai etore-kaurito evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iauka rakavari maki tarimarima ḡutuma ḡerina ḡeraka-vaḡito, benamo iauka rakavari ḡekoḡoto, ḡekirato, “Ḡoi tu Barau Natuna!” Senaḡi Iesu na evaḡa-guruḡarito asi beḡene guruḡa, korana ḡia ribari Iesu tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Elaḡanito, Iesu evariḡisito, tano fakana ḡana eiaḡoto. Tarimarima na ḡea vetauato, ḡedoḡariato, ḡeḡabi-tariato asi ḡeri ura ḡia na bene raga-kwaneri ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Senaḡi Iesu na evaḡa-guruḡarito, ekirato, “Au tu vanuḡa irauri ai maki bana ḡobata, Barau ḡena Basileia varina namona bana fiua, Barau na etuḡuguto korana tu moḡa.” ");
INSERT INTO snc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Benamo Iudea tanona ruburi nuḡari ai eḡobatato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ḡaro ta Iesu tu Genesareta kouna rikinai eruḡa-taḡoto-ḡoi, tarimarima na ḡeraga-ḡeḡeraḡiato, Barau ḡena guruḡa beḡene seḡaḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ḡia tu ḡasi ruarua eḡitarito, kou rikinai ḡeinu-raḡerito; maina tarimari na ḡeraga-kwanerito, ḡeri reke ḡeḡuriḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Benamo Iesu tu mo ḡasi tai eraḡeto, Simona ḡena ḡasi. Ḡia na Simona ekiraiato, kota negini-rosia nanu ḡana. Benamo ḡasi ai etanu-tarito, tarimarima ḡutuma evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eguruḡa-ḡosito vau, ḡia na Simona ekiraiato, ekirato, “Ḡemi ḡasi dodoku rekena ḡana ḡogini-rosia, be ḡemi reke boḡono toreri, maḡani-kone boḡono vaḡi ḡana.” ");
INSERT INTO snc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona evaḡa-veseto, ekirato, “Vevaḡa-riba taumu, ḡai tu baḡa vekwaraḡi-laḡani, maḡani-kone ta maki asi baḡa doḡaria, senaḡi ḡoi ḡemu guruḡa dainai reke atorerini.” ");
INSERT INTO snc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Benamo ḡetorerito, maḡani-kone asisebo ḡetoḡato, ḡeri reke maki dori ḡevedareto. ");
INSERT INTO snc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Moḡesi nai karori ḡasi tai ḡelau-iaverito, beḡene iaḡoma, be ḡia beḡenema vaḡa-kavari ḡetato. Ḡeiaḡomato, ḡasi ruarua maḡani-kone na ḡevaḡa-vonurito, dori ḡeburuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simona Petero na mo veiḡa eḡorato dagarana eḡitaiato, benamo Iesu kwakuna koranai eketo-tarito vau ekiraiato, ekirato, “Vereḡauka, noraka-veḡita au ḡeguna, au tu vei-rakava tarimagu!” ");
INSERT INTO snc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Korana tu ḡia ma karona mabarana ḡesi nuḡari ḡefarevaḡi-rakavato, mo maḡani-kone asisebo ḡevaḡirito nai. ");
INSERT INTO snc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simona ḡesi ḡemaina-vegogoto-ḡoi tarimari maki Iakobo (o Iames) e Ioane, Sebedaio natuna, ḡeḡaba-rakavato. Iesu na Simona ekiraiato, ekirato, “Asi nogari; maitoma bevesina beiaḡoni, ḡoi tu tarimarima bomaina-vinirini.” ");
INSERT INTO snc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Benamo ḡasi ruarua tu kou rikinai ḡeinu-raḡerito, ḡeri dagara mabarari ḡeraga-kwanerito, Iesu murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ḡaro ta Iesu tu vanuḡa ta nuḡanai, tarima ta monai kefina mabarana lepera moḡo. Ḡia na Iesu eḡitaiato nai, ḡoiranai evetui-tarito, enoḡiato, ekirato, “Vereḡauka, bema ḡoi ourani nai, moḡoni boiarevaguni, bovaḡa-namoguni riba!” ");
INSERT INTO snc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu ḡimana etuḡu-iaḡoato, eḡabi-karaiato, ekirato, “Aurani, be nonamo!” Benamo vaḡa-sebo lepera na eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu na evaḡa-guruḡaiato, ekirato, “Tarima ta asi bono kira-varaia.” Ma ekirato, “Noiaḡo, Rubu Veaḡa verena na bene ḡitamu, ema veiareva varevare dagarari Mose na ekiraḡiato ilailanai bono vinia, be tarimarima beḡene riba, ḡoi tu bonamo.” ");
INSERT INTO snc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Senaḡi Iesu varina tarimarima na ḡefiu-rovorovoato-ḡoi vau, tarimarima ḡutuma-bara ḡevegogoto-ḡoi, ḡia ḡena guruḡa seḡaḡi-seḡaḡiri e ḡeri keve vaḡa-namori uranai. ");
INSERT INTO snc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Senaḡi Iesu tu eraka-veḡitato-ḡoi tano fakana ḡana, ea ḡuriḡurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ḡaro tai Iesu evevaḡa-ribato-ḡoi nuḡanai, Farisea tarimari e taravatu vaḡa-riba-iaḡina tarimari Galilea e Iudea vanuḡari mabarari na, ema Ierusalema na ḡeiaḡomato, ḡia sevinai ḡema tanu-tarito. Barau ḡena seḡuka Iesu ḡenai evaḡa-foforiato, keve tarimari bene vaḡa-namori ḡana. ");
INSERT INTO snc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tarima kotari na tauḡanina tavi ta emaseto tarimana ta gedai genagenanai ḡeḡwa-iaḡoato. Numa nuḡanai beḡene raka-toḡa dabarana ḡevetauato, Iesu ḡoiranai beḡene tore-taria ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Senaḡi tarimarima ḡutuma naima, rakatoḡa dabara ta asi ḡedoḡariato. Moḡa lorinai keve rakava tarimana ma gedana ḡesi ḡeḡwa-raḡeato numa tuḡunai, ḡuduḡu ḡeḡiu-fakaiato vau, ḡetuḡu-riḡoato tarimarima fakari ai Iesu ḡoiranai. ");
INSERT INTO snc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu na ḡeri veḡabidadama eḡitaiato, benamo keve rakava tarimana ekiraiato, ekirato, “Ḡata, ḡoi ḡemu rakava batuḡamaḡi-fitoḡari.” ");
INSERT INTO snc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farisea tarimari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari maiḡesi ḡetuḡamaḡito, “Mai tu deikara, ḡia na Barau ekira-fitoḡaiani? Barau ḡereḡana na moḡo rakava etuḡamaḡi-fitoḡarini!” ");
INSERT INTO snc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu ma ribana ḡia kara ḡetuḡamaḡirito-ḡoi, benamo evaḡa-guruḡarito, ekirato, “Karase nai nuḡami ai maniḡesi ḡotuḡamaḡini? ");
INSERT INTO snc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aiḡesina baguruḡani tu meraḡa, ‘Ḡemu rakava batuḡamaḡi-fitoḡari’ banasi, ba bara kira, ‘Novariḡisi, be noraka’ barasi? ");
INSERT INTO snc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Au na navaḡa-ḡitami, Tarimarima Natuna tu ma seḡukana rakava betuḡamaḡi-fitoḡarini tanobarai.” Ḡia na keve rakava tarimana evaḡa-guruḡaiato, ekirato, “Novariḡisi, ḡemu geda noḡabia, be numa ḡana noiaḡo!” ");
INSERT INTO snc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Benamo ḡia maoromaoro evariḡisito tarimarima ḡoirari ai, egena-iaḡirito dagarari eḡabirito, ḡena numa ḡana eiaḡoto, Barau evaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tarimarima mabarari nuḡari ḡefarevaḡito ema Barau ḡevaḡa-raḡeato. Gari na evaḡa-vonurito, benamo ḡekirato, “Veiḡa boruri toma ḡaro ai bita ḡita!” ");
INSERT INTO snc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Moḡa murinai Iesu tu vanuḡa na eraka-rosito, benamo takesi gogo tarimana arana Levi takesi moniri ḡeḡabito-ḡoi numanai tanutaḡo eḡitaiato. Benamo Iesu na ekiraiato, ekirato, “Murigu ai noma raka.” ");
INSERT INTO snc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Benamo Levi evariḡisito, ḡena dagara mabarari eraga-kwanerito, Iesu murinai erakato. ");
INSERT INTO snc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Benamo Levi na ḡaniḡani baregona ḡena numai eveiato Iesu ḡana. Varivari tarimari vefakari ai tarimarima ḡutuma takesi gogo tarimari ema tarima tari ḡia ḡesi ḡeḡaniḡanito. ");
INSERT INTO snc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisea tarimari tari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ḡia ḡeri doḡoro tarimari, ḡevanevaneto Iesu ḡena mero ḡeri ai, ḡekirato, “Karase nai ḡomi tu takesi gogo tarimari e vei-rakava tarimari ḡesi ḡoḡaniḡanini ema ḡoniuniu-vegogoni?” ");
INSERT INTO snc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu na evaḡa-veserito, ekirato, “Namo tarimari tu doketa asi beḡe vetaurini, senaḡi keve tarimari moḡo. ");
INSERT INTO snc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au maki vei iobukaiobuka tarimari keakeari asi aiaḡomato, senaḡi vei-rakava tarimari beḡene vetuḡamaḡi-kure e beḡene raka-kure ḡana aiaḡomato.” ");
INSERT INTO snc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Farisea tarimari na Iesu ḡevaḡa-guruḡaiato, ḡekirato, “Ioane Babatiso ḡena mero nega-ḡutuma ḡeḡani-veaḡani e ḡeḡuriḡurini. Ḡai ḡema mero maki moḡesi ḡeveini, a ḡoi ḡemu mero tu ḡeḡaniḡanini e ḡeniuniuni moḡo.” ");
INSERT INTO snc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡotuḡamaḡini veḡaraḡo variḡu tarimana ḡatana seviri ai etanuni nuḡanai beḡe ḡani-veaḡani ei? ");
INSERT INTO snc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ḡarona eiaḡomani, veḡaraḡo variḡu tarimana ḡia ḡerina beḡe ḡabi-veḡitaiani, monai vau beḡe ḡani-veaḡani.” ");
INSERT INTO snc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu na ḡeri barabore ta ma ekiraḡiato, ekirato, “Tarima ta na dabuḡa variḡuna asi bedareani, dabuḡa guinena bani-iaḡina. Bema moḡesi beveini nai, dabuḡa variḡuna bedareani, ema dabuḡa variḡuna veseana dabuḡa guinena ḡesi asi beḡe ilailani. ");
INSERT INTO snc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tarima ta na vine nanuna variḡuna nanigosi kefina guinenai asi besisiani. Bema moḡesi beveini nai, vine nanuna variḡuna na kefi guinena beḡani-fakaiani. Vine nanuna bevebubuni e kefina berakavani. ");
INSERT INTO snc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Senaḡi vine nanuna variḡuna nanigosi kefina variḡunai besisiani tu namo! ");
INSERT INTO snc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ema tarima ta na vine nanuna guinena eniuani murinai vine nanuna variḡuna asi beura-viniani, korana ḡia bekirani, ‘Vine nanuna guinena tu namo vedaurea.’” ");
INSERT INTO snc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabadi tai Iesu widi vamokari nuḡari na eraka-iaḡoto-ḡoi, benamo ḡena mero widi ḡebukito, ḡimari ai ḡemuturito-ḡoi, benamo tauri tu ḡeḡanirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisea tarimari kotari na ḡedanaḡirito, ḡekirato, “Ḡomi tu kara dainai ḡaina taravatu asi ḡokorana-iaḡiani, Sabadi ai widi ḡobukini?” ");
INSERT INTO snc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu na evaḡa-veserito, ekirato, “Ḡomi Davida ma karona ḡesi ḡevitorito nai, Davida na veiḡa ta eveiato guruḡana tu asi ḡoiaviani? ");
INSERT INTO snc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Barau ḡena numai eraka-toḡato, Barau ḡoiranai ḡetorerito-ḡoi beredi eḡabito, eḡanito ema karona maki evinirito. Mo beredi tu veaḡa, Rubu Veaḡa vereri moḡo ḡari, taravatu.” ");
INSERT INTO snc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesu na ma ekirarito, ekirato, “Tarimarima Natuna tu Sabadi Verena.” ");
INSERT INTO snc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma Sabadi tai Iesu rubu ai eraka-toḡato, benamo evevaḡa-ribato-ḡoi. Monai tarima ta tu ḡimana aroribana tu ebosoto. ");
INSERT INTO snc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari e Farisea tarimari na tu ḡia ḡeḡita-taḡoato-ḡoi, mai Sabadi ai bevevaḡa-namoni ba asiḡi, korana beḡene samania ḡana. ");
INSERT INTO snc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Senaḡina Iesu na ḡia kara ḡetuḡamaḡiato-ḡoi tu eribaiato, benamo mo tarima ḡimana boso ekiraiato, ekirato, “Noruḡa-vaisi, mainai noma ruḡa.” Benamo eruḡa-vaisito, ea ruḡato. ");
INSERT INTO snc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Nadanaḡimi roḡo, taravatu nuḡanai aiḡa tu namo, Sabadi ai veiḡa namori veiveiri namo ba veiḡa rakavari sini veiri? Tana vevaḡa-maḡuri ba tana vaḡivaḡi?” ");
INSERT INTO snc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eboḡe-ḡeḡeraḡito, mabarari eḡitarito, benamo mo tarima ekiraiato, ekirato, “Ḡimamu notuḡu-roroḡotoa.” Ḡimana etuḡu-roroḡotoato, benamo enamoto ḡimana reke ta kavana. ");
INSERT INTO snc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Senaḡina ḡia tu ḡebaru-rakavato, benamo tauḡeri fakari ai moḡo ḡeguruḡa-vegogoto Iesu kamasi ta beḡene veia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mo ḡaro tai Iesu ḡoro ta tuḡuna ḡana evaraḡeto ḡuriḡuri, benamo mo boḡi vinubana Barau ḡenai eḡauḡauto. ");
INSERT INTO snc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Elaḡanito, ḡena mero ekea-vegogorito, benamo gabanana ruarua (12) eḡabi-viriḡirito, arari evatorito, apostolo. ");
INSERT INTO snc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simona, arana ta tu Petero, ma tarina Anduru; e Iakobo (o Iames), e Ioane, e Filipo, e Batolomeo, ");
INSERT INTO snc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Mataio, e Tomasi; e Iakobo (o Iames), Alfeo natuna; e Simona, Selote tarimana; ");
INSERT INTO snc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Iudas, Iakobo (o Iames) natuna; ema Iudas Isakariota, Iesu berevaiani tarimana. ");
INSERT INTO snc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ḡia ḡesi ḡoro na ḡeseiriḡoto tano faiaranai, benamo Iesu ema ruḡa-tarito. Ḡia ḡenai riba ḡeḡabito-ḡoi tarimari ḡutuma ema tarimarima ḡutuma lelevaḡiri maki Iudea ema Ierusalema na ḡeiaḡomato, Taia konena na e Sidono konena na ḡeiaḡomato, ");
INSERT INTO snc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ḡia beḡene seḡaḡia uranai ema ḡeri keve bene vaḡa-namori ḡana. Iauka rakavari na ḡeboroḡirito tarimari maki evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Benamo tarimarima mabarari ḡeurato-ḡoi Iesu beḡene ḡabi-karaia, korana tu seḡuka ḡia ḡenana eiaḡomato-ḡoi, benamo tarimarima mabarari ḡeri keve ḡenamoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu eboḡeboḡeto, benamo eboḡe-iaḡoto ḡena mero eḡitarito vau ekirato: “Gara veḡubu tu ḡoiaku, korana Barau ḡena Basileia tu ḡomi ḡemi. ");
INSERT INTO snc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ḡomi deidei toma ḡevitomini tu boḡono iaku, korana ḡomi roḡo boḡo ḡani-maseni bene. Ḡomi deidei toma ḡotaḡi-taḡini tu boḡono iaku, korana boḡo rikini bene. ");
INSERT INTO snc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Boḡono verere bema tarima na beḡe baru-vinimini, beḡe kira-fitoḡamini, beḡe rori-toremini, ema arami beḡe vaḡa-rakavarini Tarimarima Natuna dainai. ");
INSERT INTO snc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Moḡeri beḡe ḡorani ḡaronai boḡono iaku e boḡono buri-vaisi ma vereremi ḡesi, korana davami tu asikeikeina gubai. Korana ḡia seneri na maki peroveta tarimari moḡesi ḡeveirito. ");
INSERT INTO snc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Senaḡina ḡomi ma ḡemi farefare ḡutuma tarimami vetuḡami kika, korana vaḡa-iakumi farefareri tu varau ḡoḡabito bene. ");
INSERT INTO snc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toma ḡoḡani-maseni tarimami, vetuḡami, korana beḡea vitomini. Toma ḡorikini tarimami, vetuḡami kika, korana nuḡami beḡea metoni e boḡoa taḡini. ");
INSERT INTO snc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tarimarima na ḡekiraḡi-varaḡe varaḡemini tarimami, vetuḡami, korana seneri na maki peroveta tarimari ḡofaḡofari tu maniḡesi ḡevaḡa-raḡerito.” ");
INSERT INTO snc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Senaḡina au ḡoseḡaḡiguni tarimami akiramini: Ḡebaru-vinimini tarimari boḡono ura-viniri, ḡevaḡa-rakavamini tarimari veiḡa namori boḡono vei-viniri. ");
INSERT INTO snc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ḡekira-rakavamini tarimari boḡono vaḡa-namori ema veiḡa rakavari ḡevei-vinimini tarimari ḡeri boḡono ḡuriḡuri. ");
INSERT INTO snc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bema tarima ta na taḡomu tavi ta beforoani nai, taḡomu reke ta maki bono vinia. Tarima ta na ḡemu koudi beḡabiani nai, sedi maki asi bono ḡabi-taria, bene ḡabia. ");
INSERT INTO snc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ḡemu ai beḡe noḡinoḡini tarimari bono viniri ema deikara na ḡemu dagara ta beḡabi-rakaiani, ḡabiḡoina guruḡana asi bono vei. ");
INSERT INTO snc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kara ourani tarimarima na ḡemu ai beḡene veia veiḡana, ḡia ḡeri ai maki mo veiḡa bono veia. ");
INSERT INTO snc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bema ḡoura-vinirini tarimari tu ḡomi ḡeura-vinimini tarimari moḡo nai, ḡomi ḡemi namo tu kara? Rakava tarimari maki ḡeura-vinirini tarimari moḡo ḡeura-vinirini. ");
INSERT INTO snc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O bema veiḡa namori ḡemi ai ḡeveini tarimari moḡo veiḡa namori ḡovei-vinirini, ḡomi ḡemi namo tu kara? Rakava tarimari maki mani veiḡa sebona ḡeveiani. ");
INSERT INTO snc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O bema ma beḡe vini-ḡoimini tarimari moḡo ḡovinirini, ḡomi ḡemi namo tu kara? Rakava tarimari na maki tarima ḡevinirini, murinai tu mabarari ma beḡene dava-ḡoiri ḡetoni. ");
INSERT INTO snc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Senaḡina ḡebaru-vinimini ema ḡevaḡa-rakavamini tarimari boḡono ura-viniri, veiḡa namori ḡeri ai boḡono vei, boḡono viniri, a tuḡu vaḡa-voi tuḡamaḡina asi boḡono vei. Benamo davami beḡene barego, ema Iaru-korokoro Barauna natunai boḡono iaḡo, korana tu ḡia na asi ḡevaḡa-namoani tarimari e vei-rakava tarimari evaḡa-namorini. ");
INSERT INTO snc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Boḡono vevetuḡa-ḡwa, ḡomi Tamami evevetuḡa-ḡwani kavana.” ");
INSERT INTO snc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nuḡami ai tarimarima asi boḡono kira-kerereri. Moḡesi tu Barau na maki asi bekiraḡimini ḡomi tu kerere. Rakava voina tarimarima ḡeri ai asi boḡono kiraḡi-kaua, benamo Barau na rakava voina ḡemi ai asi bekiraḡi-kauani. Rakava boḡono tuḡamaḡi-fitoḡaia, be Barau na maki ḡemi rakava bene tuḡamaḡi-fitoḡari. ");
INSERT INTO snc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Boḡono vini, be Barau na maki bene vinimi, ḡutumari bene dori-riḡori, bene kora-vegogori, bene vonu-fokafoka, bene ḡiḡiḡiḡi-seḡi, bene bubu-riḡoa ḡemi ai. Korana aiḡesi ḡomi ḡovinini, Barau na maki moḡesi bevinimini.” ");
INSERT INTO snc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu na barabore ta ma ekira-vararito, ekirato, “Mata-bubu tarimana na mata-bubu tarimana ta beḡori-kauani riba ba? Ba tauri ruarua koufai beḡea keto-ḡurani? ");
INSERT INTO snc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Riba vetau merona na evaḡa-ribaiani tarimana asi bevanaḡiani, senaḡina ḡena sikuli bevaḡa-koriani vau, evaḡa-ribaiani tarimana ḡesi beḡe ilailani. ");
INSERT INTO snc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kara dainai tarikakamu matanai libika oḡitaiani, senaḡi ḡoi matamu ai ḡau tubina tu asi otuḡamaḡiani. ");
INSERT INTO snc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kamara dabarai ḡoi tarikakamu okiraiani, okirani, ‘Ḡata, au na roḡo matamu ai libika nakokia,’ senaḡina ḡoi tauḡemu matamu ai ḡau tubina tu asi oḡitaiani? Ḡofaḡofa tarimamu, guine tu ḡoi matamu ai ḡau tubina nokoki-vaḡia roḡo, benamo boboḡeboḡe-ginikauni vau, tarikakamu matanai libika bono kokia.” ");
INSERT INTO snc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ḡau namona beḡwani ḡwaḡwana tu dia rakava, ema ḡau rakavana beḡwani ḡwaḡwana tu dia namo. ");
INSERT INTO snc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ḡau mabarari tu ḡwari ai bita ribani. Figi ḡwari maki ḡau ma giniginiri ḡerina asi ḡebokoni, ema vine ḡwari (o grapes) ḡauḡa ḡiniḡiniri ḡeri ai asi ḡebokoni. ");
INSERT INTO snc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tarima namona na dagara namori nuḡanai evaḡa-vegogorini dagarari bevaḡa-raka-rosirini. Tarima rakavana na dagara asi namori nuḡanai evaḡa-vegogorini dagarari bevaḡa-raka-rosirini. Korana tarima tu nuḡana na kara eiaḡomani murunai ekiraḡirini.” ");
INSERT INTO snc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Karase nai au ḡokiraḡiguni, ḡokirani, ‘Vereḡauka, Vereḡauka,’ nuḡanai au aguruḡani veiḡari tu asi ḡoveirini? ");
INSERT INTO snc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Navaḡa-ribami, deikara au ḡegu ai eiaḡomani, au ḡegu guruḡa ema seḡaḡini ma veiḡari eveirini tu kamasi. ");
INSERT INTO snc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ḡia tu tarima ta ḡena numa eragaiato kavana. Guri ekwa-variḡo kwareḡaiato, ema fore iatanai evaḡa-ruḡaiato, benamo ḡabata baregona eragato, mo numa edoriato, senaḡi asi eketoto, korana fore iatanai eragaiato nai. ");
INSERT INTO snc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A tarima ta au ḡegu guruḡa eseḡaḡirini, senaḡi veiḡari tu asi eveirini, ḡia tu numa eragaiato nai, tano moirana iatanai moḡo evaḡa-ruḡaiato, ḡabata na mo numa edoriato nai, eketo-tarito, benamo eḡwa-rovorovoato.” ");
INSERT INTO snc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu na moḡeri guruḡa mabarari tarimarima ḡoirari ai ekiraḡi-ḡosirito vau, Kaperanauma vanuḡanai eraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Monai Roma vetari verena ta etanuto-ḡoi. Ḡena vetuḡunaḡi merona, euravini-baregoato-ḡoi merona, ekeve-rakavato, dori emaseto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Vetari verena na Iesu varina eseḡaḡiato, benamo Iuda tarima baregori kota etuḡu-iaḡorito, Iesu beḡene noḡia, bene iaḡoma, ḡena vetuḡunaḡi merona benema vaḡa-namoa. ");
INSERT INTO snc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Benamo Iesu ḡenai ḡeiaḡoto, ma nuḡari mabarari ḡesi ḡenoḡiato, ḡekirato, “Mai vetari verena tu tarima namona naima bono vaḡa-kavaia. ");
INSERT INTO snc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Korana ḡia na ḡita besera eura-vinirini, ema ḡai ḡema rubu maki ḡia na eragaiato.” ");
INSERT INTO snc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iesu ḡia ḡesi ḡeiaḡoto. Numa ḡeraka-kavinaḡiato-ḡoi nai, vetari verena na ḡatana kota etuḡu-iaḡorito Iesu ḡoirana ḡana, benamo vetari verena ḡena guruḡa Iesu ḡekira-varaiato, ḡekirato, “Vereḡauka, asi novekwaraḡi, au tu asi ilaila, ḡoi ḡegu numai boraḡekauni. ");
INSERT INTO snc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Au maki asi ilaila, ḡoi ḡemu ai baiaḡosini. Senaḡi ḡoi noguruḡa moḡo, benamo au ḡegu vetuḡunaḡi merona benamoni. ");
INSERT INTO snc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Au maki tarima kota ḡeri veḡitaḡau gabureri ai ema vetari tarimari o soldia tu au gaburegu ai. Au na ta bakiraiani, ‘Noraka!’ benamo berakani, ma ta bakiraiani, ‘Noiaḡoma!’ benamo beiaḡomani. Ema au ḡegu vetuḡunaḡi merona bakiraiani, ‘Maiḡa noveia!’ benamo beveiani.” ");
INSERT INTO snc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu na mai guruḡa eseḡaḡiato nai, eḡaba-rakavato, eruḡa-kureto, ḡia murinai ḡerakato tarimari ḡutuma evaḡa-guruḡarito, ekirato, “Au na ḡomi akiramini, veḡabidadama maiḡesi kavana Isaraela nuḡanai asi adoḡariato.” ");
INSERT INTO snc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Benamo vetari verena na etuḡurito tarimari ma ḡeḡenoḡoito ḡia ḡena numa ḡana. Keve merona ḡedoḡariato, ḡena keve varau ekorito. ");
INSERT INTO snc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Moḡa murinai Iesu tu vanuḡa ta ḡana eiaḡoto arana Nain. Ḡena mero ema tarimarima ḡutuma maki ḡia ḡesi ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vanuḡa nuḡanai roḡosi ḡene raka-toḡa nuḡanai, mase ta vanuḡa nuḡana na ḡeḡwa-rosiato-ḡoi. Vabu ta natuna merona ḡora ḡereḡa emaseto. Vanuḡa tarimari ḡutuma na vabu ḡekavaiato. ");
INSERT INTO snc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iesu na mo vabu eḡitaiato, benamo evetuḡaiato, ekiraiato, ekirato, “Asi notaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Benamo Iesu eraka-kavi-iaḡoto, mase mauḡana eḡabi-karaiato. Mauḡa ḡeḡwaiato tarimari ḡeruḡa-tarito. Benamo Iesu ekirato, “Mero futua, akiramuni, novariḡisi!” ");
INSERT INTO snc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Benamo etanu-vaisito, eguruḡato. Moḡa murinai Iesu na ḡia sinana ma evini-ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mabarari gari na evaḡa-vonurito. Barau ḡevaḡa-raḡeato, ḡekirato, “Peroveta tarimana barana ta ḡita fakarai bema fofori!” ema, “Barau na ḡena bese tarimari benema vaḡa-kavari ḡana beiaḡoma!” ");
INSERT INTO snc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Benamo mai veiḡa varina Iudea mabaranai ema Iudea sevina vanuḡari mabarari ai ḡefiu-rovorovoato. ");
INSERT INTO snc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane ḡena mero na mai dagara mabarari ḡeḡorato dagarari ḡekira-varaiato. Benamo Ioane na ḡena mero ruarua ekearito, ");
INSERT INTO snc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","etuḡurito Vereḡauka ḡenai, ḡene danaḡia, “Ioane na ekiraḡiato, beiaḡomani tarimana tu ḡoi, ba tarima boruna ta baḡana vaḡa-nogaia?” ");
INSERT INTO snc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tauri ruarua Iesu ḡenai ḡeraḡasito, benamo ḡekirato, “Ioane Babatiso na betuḡuma, bekira, ‘Ḡia na ekiraḡiato beiaḡomani tarimana tu ḡoi, ba tarima boruna ta baḡana vaḡa-nogaia?’” ");
INSERT INTO snc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mo aoa ai Iesu na tarimarima ḡutuma evaḡa-namorito, keve tarimari, midigu ḡeḡanito-ḡoi tarimari, iauka rakavari na ḡeboroḡirito tarimari. Mata-bubu tarimari ḡutuma maki matari evaḡa-iaḡarito. ");
INSERT INTO snc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Benamo Iesu na tauri ruarua evaḡa-veserito, ekirato, “Ḡoḡenoḡoi, ḡomi na boḡo ḡitari e boḡo seḡaḡiri veiḡari Ioane boḡono kira-varaia: Mata-bubu tarimari ḡeboḡeboḡeni, kwaku rakava tarimari ḡerakani, lepera tarimari ḡenamoni, seḡa-bubu tarimari ḡeseḡaḡini, mase tarimari ḡevariḡisi-ḡenoḡoini, ema asi ḡeri-ḡari tarimari ḡeri ai Vari Namona eḡobata-vinirini. ");
INSERT INTO snc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ḡena veḡabidadama au ḡegu ai asi beraga-kwaneani tarimana tu eiakuni!” ");
INSERT INTO snc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioane ḡena vetuḡunaḡi tarimari ḡerakato vau, Iesu na ḡevegogoto tarimari evaḡa-guruḡarito, Ioane varina ḡeri ekiraḡiato, ekirato, “Kara boḡono ḡitaia ḡana tano fakana ḡana ḡoiaḡoto? Gobu iavara na ekwari-ḡareva ḡarevaiani ḡitaḡitana ḡoiaḡoto? ");
INSERT INTO snc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kara boḡono ḡitaia ḡana ḡoiaḡoto? Dabuḡa namona eveiani tarimana ḡitaḡitana ḡoiaḡoto? Asiḡina, dabuḡa namori ḡeveirini tarimari ema ḡaniḡani namori ḡeḡanirini tarimari tu vere tarimari ḡeri numai ḡetanuni! ");
INSERT INTO snc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Be, kara boḡono ḡitaia ḡana ḡoiaḡoto? Peroveta tarimana dainai? Aba! Akiramini, ḡoḡitaiato tarimana tu peroveta tarimari mabarari evanaḡirini. ");
INSERT INTO snc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ioane varina Buka Veaḡai maiḡesi etoreato, Barau ekirato, ‘Au na ḡegu vetuḡunaḡi tarimana tu batuḡu-guineani, ḡemu dabara ḡoiramu ai vaḡa-maḡatana.’” ");
INSERT INTO snc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iesu ma ekirato, “Akiramini, mai tanobarai beḡe maḡuri tarimari mabarari fakari ai ta na Ioane asi bevanaḡiani. Senaḡi Barau ḡena Basileia nuḡanai gabi tarimana na Ioane tu evanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tarimarima mabarari ema takesi gogo tarimari maki mai guruḡa ḡeseḡaḡiato nai, ḡia na Barau ḡena dabara ḡevaḡa-moḡoniato, Ioane ḡena babatiso ḡeḡabiato. ");
INSERT INTO snc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Senaḡi Farisea tarimari e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na Barau ḡena vevaḡa-maḡuri dabarana ḡia ḡeri ai ḡetuḡamaḡi-fitoḡaiato. Ioane ḡena babatiso ḡia ḡeri ai asi ḡeḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Toma ḡuru tarimari tu deikarari ḡesi bana vaḡa-ilailari? Ḡia tu kamasi? ");
INSERT INTO snc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ḡia tu noḡa mero keiri kavana, vanuḡa ḡatamanai ḡetanu-taḡoni, ḡeḡereni, tavi ta merori na tavi tai ḡekea-vinirini, ḡekirani, ‘Ḡai tu veḡaraḡo vererenai gita ḡalauto-ḡoi ḡomi ḡemi, senaḡi ḡomi tu asi ḡobarato-ḡoi! Ḡai tu mase mariri ḡaḡabito-ḡoi, senaḡi ḡomi tu asi ḡotaḡito-ḡoi!’ ");
INSERT INTO snc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Korana tu Ioane Babatiso eiaḡomato, eḡani-veaḡato ema vine nanuna asi eniuato. Benamo ḡomi ḡokirani, ‘Ḡia tu iauka rakavana na eboroḡiato,’ ḡotoni. ");
INSERT INTO snc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tarimarima Natuna eiaḡomato, ḡia tu ḡaniḡani ta asi eruḡaiani. Benamo ḡomi ḡokirani, ‘Ḡia tu boḡeka tarimana ema vine nanuna eniu-ḡutumani tarimana, takesi gogo tarimari e vei-rakava tarimari ḡatari,’ ḡotoni. ");
INSERT INTO snc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Senaḡi Barau ḡena iaunega ḡeḡabi-raḡeani tarimari na Barau ḡena iaunega ḡevaḡa-moḡoniani.” ");
INSERT INTO snc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisea tarimana ta na Iesu enoḡiato, beḡene ḡaniḡani-vegogo etato. Benamo Iesu eiaḡoto ḡena numa ḡana, ḡaniḡani gabunai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mo vanuḡai vavine ta etanuto-ḡoi, ḡia tu mata-boraḡa vavinena. Ḡia eseḡaḡito, Iesu tu Farisea tarimana ḡena numai eḡaniḡanito-ḡoi, benamo fore kavabuna namona, alabasta forena na ḡeveiato kavabuna, nuḡanai tu muramura ma bonana namona eḡabi-kauato, ");
INSERT INTO snc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","eiaḡoto Iesu murinai eritoḡo-tarito, kwakuna koranai etaḡi-rakavato, benamo matana nanuna na Iesu kwakuna evaḡa-nufarito. Benamo ḡwina na ma edau-kaukaurito, kwakuna everauato, muramura ma bonana namona kwakunai ebubuato. ");
INSERT INTO snc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisea tarimana na, mo veiḡa eḡitaiato nai, ḡia nuḡanai maiḡesi etuḡamaḡito, “Mai tau bema moḡoni peroveta tarimana nai tu, ḡia bere riba, ḡia eḡabi-karaiani vavinena tu deikara. Ḡia bere riba, mo vavine tu mata-boraḡa vavinena!” ");
INSERT INTO snc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Benamo Iesu na ḡia evaḡa-guruḡaiato, ekirato, “Simona, au tu ma ḡegu guruḡa ḡoi ḡemu ai.” Simona ekirato, “Vevaḡa-riba taumu, noguruḡa, be naseḡaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu ekirato, “Tarima ruarua na moni evinito-ḡoi tarimana ḡenai moni ḡeḡabi-toreto. Tarima ta na silva moniri sinau imaima (500) eḡabi-torerito, ma ta na tu silva moniri gabana imaima (50) eḡabi-torerito. ");
INSERT INTO snc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Senaḡi mai tarima ruarua na ḡeri ḡabitore vaḡa-ḡenoḡoina tu gwaḡiḡi rakava nai, moni evinito-ḡoi tarimana na ḡeri ḡabitore etuḡamaḡi-fitoḡaiato moḡo. Dei na mo tarima euravini-baregoato?” ");
INSERT INTO snc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona evaḡa-veseto, ekirato, “Au atuḡamaḡini tu, eḡabitore-baregoto tarimana.” Iesu ekirato, “Oi, ḡemu vaḡa-vese tu maoro.” ");
INSERT INTO snc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Moḡa murinai Iesu etanu-kureto, vavine eḡoiraiato vau, Simona ekiraiato, ekirato, “Mai vavine oḡitaiani? Au ḡoi ḡemu numai bama raḡekau nai, kwakugu ḡuriḡi-ḡuriḡina nanuna ta asi boḡwa-iaḡomaia, a mai vavine na tu matana gorana na au kwakugu beḡuriḡia vau, ḡwina na bedau-kaukauri. ");
INSERT INTO snc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ḡoi na ḡita ḡera veḡabiraḡe veraunai au asi boḡabi-raḡegu, a mai vavine oḡitaiani, roḡosi bene doko au kwakugu roḡo everauani. ");
INSERT INTO snc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ḡoi na debagu ai diḡa ta asi bobubua, a ḡia tu au kwakugu muramura ma bonana namona na bevaḡa-fari vekoraḡiri. ");
INSERT INTO snc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Moḡa lorinai au na ḡoi akiramuni, ḡena rakava ḡutuma, senaḡi Barau na varau betuḡamaḡi-fitoḡari. Moḡa lorinai ḡena veuravini tu barego. A ḡena rakava koturi moḡo etuḡamaḡi-fitoḡarito tarimana tu ḡena veuravini maki asi barego.” ");
INSERT INTO snc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Benamo Iesu na mai vavine ekiraiato, ekirato, “Ḡemu rakava varau bama tuḡamaḡi-fitoḡari.” ");
INSERT INTO snc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ḡia ḡesi ḡeḡaniḡani-vegogoto tarimari ḡevedanaḡi-vedanaḡito, ḡekirato, “Mai tu kamara tarima, be ḡia na tarima ḡeri rakava maki etuḡamaḡi-fitoḡarini etoni?” ");
INSERT INTO snc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Senaḡi Iesu na vavine ma evaḡa-guruḡaiato, ekirato, “Ḡemu veḡabidadama na varau bevaḡa-maḡurimu. Maivau noiaḡo ma nuḡa namomu ḡesi.” ");
INSERT INTO snc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Moḡa murinai Iesu na vanuḡa barari e vanuḡa keiri eiaḡo-vinirito-ḡoi, Barau ḡena Basileia Varina Namona eḡobata-iaḡiato-ḡoi. Ḡena mero gabanana ruarua (12) ḡia ḡekavaiato. ");
INSERT INTO snc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Vavine kota maki ḡia ḡesi ḡeiaḡoto. Iesu na iauka rakavari mo vavine ḡerina elai-vaḡirito ema ḡeri keve evaḡa-namorito. Ta tu Maria, arana ḡevatoato Magadala vanuḡana vavinena. Mai tu iauka rakavari imaima ruarua (7) ḡia ḡenana elai-vaḡirito vavinena. ");
INSERT INTO snc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma ta tu Ioana, Kusa ḡaraḡona. Kusa tu Heroda ḡena farefare eḡita-ḡaurito-ḡoi tarimana ta. Ta tu Susana ema vavine vovoka maki. Moḡeri vavine na Iesu ma ḡena mero ḡeri farefare na ḡevaḡa-kavarito. ");
INSERT INTO snc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tarimarima ḡutuma bara ḡevegogoto, vanuḡa mabarari na Iesu ḡenai ḡeiaḡoto. Benamo ḡia na ḡeri barabore ta ekiraḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iaraḡa tarimana vamoka ḡana eiaḡoto, ḡena widi ḡueri bene fiu-rovorovori ḡana. Efiurito-ḡoi nai, kota dabarai ḡeketoto. Benamo tarimarima na ḡefana-veḡonurito ema guba manuri na ḡeḡanirito. ");
INSERT INTO snc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kotari tu fore tanonai ḡeketoto. Ḡetubuto, senaḡi asikauna ḡemaraito, korana tano tu asi nanuna nai. ");
INSERT INTO snc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kotari tu ḡauḡa ḡiniḡiniri nuḡari ai ḡeketoto. Benamo ḡauḡa ḡiniḡiniri ḡesi ḡetubu-sebonato, senaḡi varovaro dagarari ḡetuturarito nai ḡemaseto. ");
INSERT INTO snc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kotari tu tano namonai ḡeketoto. Benamo ḡetubu-ginikauto, ḡeḡwato, tata ḡwana sinau ta (100).” Benamo Iesu garona evaḡa-baregoato, ekirato, “Ma seḡana tarimana bene seḡaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ḡena mero na Iesu ḡedanaḡiato mo barabore anina tu kara. ");
INSERT INTO snc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu evaḡa-veseto, ekirato, “Barau ḡena Basileia guruḡari vekuretoḡari ḡemi ai evaḡa-foforirini, senaḡi mabarari tu barabore ai avaḡa-guruḡarini, beḡene ḡita, senaḡi anina asi beḡene ribaia, beḡene seḡaḡi, senaḡi asi beḡene tuḡamaḡi-fakaia.” ");
INSERT INTO snc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mai barabore anina tu maiḡa: Widi ḡueri tu Barau ḡena guruḡa. ");
INSERT INTO snc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dabarai ḡeketoto widi ḡueri tu tarimarima na Barau ḡena guruḡa ḡeseḡaḡiani. Senaḡi Satani eiaḡomani, Barau ḡena guruḡa ḡia nuḡari na eḡabi-vaḡirini, Vari Namona beḡe vaḡa-moḡoniani e beḡe maḡurini garina. ");
INSERT INTO snc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tano ma forenai widi ḡueri ḡeketoto tu tarimarima na Barau ḡena guruḡa ḡeseḡaḡiani e ma iakuri ḡesi ḡeḡabi-raḡeani. Senaḡi ḡia tu noḡa tarima asi lamuri kavana. Nega-kotuna moḡo Barau ḡena guruḡa ḡekorana-iaḡiani, senaḡi veribaḡani beraḡasini nai, beḡe ketoni. ");
INSERT INTO snc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ḡauḡa ḡiniḡiniri nuḡari ai ḡeketoto widi ḡueri tu tarimarima na Barau ḡena guruḡa ḡeseḡaḡiani, senaḡi ḡetuḡamaḡi-ḡutumani, tanobara farefareri ḡetuḡamaḡi-gogo gogorini ema tanobara ḡena maḡuri iakuri na Vari Namona elau-tariani. Moḡa lorinai ḡwaḡwa namori asi ḡeḡorani. ");
INSERT INTO snc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Senaḡi tano namonai ḡeketoto widi ḡueri tu tarimarima na Barau ḡena guruḡa ḡeseḡaḡiani, ma nuḡari namori e ma manauri ḡesi ḡeḡabi-raḡeani, ḡeḡabi-tariani mo, ḡwaḡwa namori ḡeḡorani. ");
INSERT INTO snc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tarima ta lamefa begabuani nai tu, dia ḡuro na beḡoḡoi-tariani o fata gaburenai betoreani. Asiḡina, ḡia tu lamefa toretorena fatanai betore-kauani. Benamo tarima beḡe raḡekauni nai, mabarari na mama beḡene ḡitaia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vekuretoḡa dagarari mabarari beḡe foforini, veḡuni guruḡari beḡe ribani e beḡe kiraḡi-foforirini. ");
INSERT INTO snc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Moḡa lorinai ḡoseḡaḡirini guruḡari loriri boḡono toreri. Korana ma ḡena seḡaḡi tarimana Barau na riba e tuḡamaḡi-faka beviniani, asi ḡena seḡaḡi tarimana, ḡia etuḡa-maḡini ma ḡena tuḡamaḡi-faka, senaḡi ḡena tuḡamaḡi-faka aiḡesi misina maki beḡabi-vaḡiani.” ");
INSERT INTO snc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu sinana ema tarina merori ḡia ḡenai ḡeiaḡoto, senaḡi tarimarima ḡutuma nai, asi ḡeri dabara Iesu ḡenai beḡe raka-kavini. ");
INSERT INTO snc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tarima ta na Iesu ekira-varaiato, ekirato, “Ḡoi sinamu ema tarimu tu murikai ḡeruḡa-taḡoni, ḡoi ḡevetaumuni.” ");
INSERT INTO snc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Benamo Iesu na mabarari ekirarito, “Barau ḡena guruḡa ḡeseḡaḡirini e ḡeveirini tarimari tu au sinagu ema au tarigu.” ");
INSERT INTO snc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ḡaro ta Iesu ma ḡena mero ḡesi ḡasi ai ḡeraḡekauto, benamo Iesu na evaḡa-guruḡarito, ekirato, “Siveḡasi-vanaḡi, kou mo rekena ḡana.” Benamo ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ḡeiaḡoto-ḡoi nuḡanai, Iesu egena-maseto. Benamo iavara asikei kou ai eraḡasito, benamo ureure ḡasi nuḡanai ḡevebubu-ḡurato nai, ḡasi dori eburuto. ");
INSERT INTO snc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Benamo ḡena mero Iesu ḡenai ḡeiaḡoto, ḡevaḡoato, ḡekirato, “Vevaḡa-riba taumu o, vevaḡa-riba taumu o, ḡita tu mai taburuni!” Iesu evariḡisito, iavara e ureure ekira-ḡoirito, benamo ḡedokoto, ḡemeḡomeḡo-tarito. ");
INSERT INTO snc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Ḡomi ḡemi veḡabidadama tu ainai?” Ḡia ḡegarito e ḡeḡaba-rakavato nai, tauḡeri mo ḡevedanaḡi-vedanaḡito, ḡekirato, “Mai tarima tu dei? Ḡia na iavara e ureure evaḡa-guruḡarito nai, garona ḡeseḡaḡiani!” ");
INSERT INTO snc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Monana Iesu ma ḡena mero ḡeiaḡoto, Gerasa (o Gadara) tarimari ḡeri gabu ai ḡeraḡasito, Galilea tavi ta kefonai. ");
INSERT INTO snc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu ḡasi na eraka-riḡoto nuḡanai, iauka rakavari na ḡeboroḡiato tarimana ta eiaḡomato Iesu ḡenai. Ḡia tu mo vanuḡa tarimana. Kai-veḡata asi dabuḡana etanuto-ḡoi, dia numai, senaḡi gara gabuna fore kouḡari ai. ");
INSERT INTO snc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ḡia na Iesu eḡitaiato nai, ekoḡo-fouto, benamo Iesu kwakuna koranai eketo-tarito, ekirato, “Iesu o, ḡoi Iaru-korokoro Barauna Natuna, kara au ḡegu ai noveia otoni? Anoḡimuni, asi bono vaḡa-midigu midigugu!” ");
INSERT INTO snc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ḡia moḡesi ekirato, korana Iesu na iauka rakavana evaḡa-guruḡaiato, mo tarima ḡenana neraka-vaḡi. Nega ḡutuma iauka rakavana na eḡabiato-ḡoi, kwakuna e ḡimana seini na ḡebarurito-ḡoi, senaḡi seini edabu-ḡuturito-ḡoi, benamo iauka rakavana na tano fakana ḡana eḡwa-iaḡoato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu na edanaḡiato, ekirato, “Ḡoi aramu tu deikara?” Ḡia na evaḡa-veseato, ekirato, “Au aragu tu ‘Ḡutuma,’” korana iauka rakavari vovoka na ḡeboroḡiato nai. ");
INSERT INTO snc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Benamo iauka rakavari na Iesu ḡenoḡiato-ḡoi, guri variḡo kwareḡana ḡana asi bene tuḡu-iaḡori. (Mo tu iauka rakavari ḡeri dibura gabuna). ");
INSERT INTO snc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Monai bai serina tu ḡoro gabakanai ḡedokadokato-ḡoi. Moḡa lorinai iauka rakavari na Iesu ḡenoḡiato, bai nuḡari ai ḡeraka-toḡa, ḡetato. Benamo Iesu na ekirarito, “Be, ḡoiaḡo!” ");
INSERT INTO snc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Benamo iauka rakavari mo tarima ḡenana ḡeraka-vaḡito, bai ḡeri ai ḡeraka-toḡato. Benamo moḡeri bai ḡeḡwa-bubu-lausiato, lalaḡa na ḡekokosi-firiḡoto, kou ai ḡevebora-maseto. ");
INSERT INTO snc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bai ḡitaḡauri tarimari na kara eḡorato dagarana ḡeḡitaiato, benamo ḡeragato, mo vari ḡea fiuato vanuḡa baranai e vanuḡa keiri ai. ");
INSERT INTO snc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tarima-rima ḡeḡoto-iaḡoto, kara eḡorato dagarana ḡea ḡitaia ḡana. Iesu ḡenai ḡeraḡasito nai, ḡia na mo tarima, iauka rakavari vovoka ḡia ḡenana ḡeraka-vaḡito tarimana, ḡedoḡariato, Iesu kwakuna koranai etanu-taḡoto-ḡoi ma dabuḡana e ḡena tuḡamaḡi maki maoro. Benamo ḡia mabarari ḡegarito. ");
INSERT INTO snc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mo veiḡa ḡeḡitaiato tarimari na iauka rakavari na ḡeboroḡiato tarimana kamasi enamoto varina tarimarima ḡekira-vararito. ");
INSERT INTO snc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Benamo Gerasa tano tarimari mabarari na Iesu ḡenoḡiato, neraga-kwaneri ḡetato, korana ḡegari-rakavato nai. Moḡa lorinai Iesu ḡasi ai eraḡekauto, ma eḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iauka rakavari ḡia ḡenana ḡeraka-vaḡito tarimana na enoḡiato, Iesu ḡesi bene iaḡo etato. Senaḡi Iesu na etuḡu-ḡenoḡoiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Noḡenoḡoi ḡemu numa ḡana. Barau na ḡoi ḡemu ai beveia veiḡana tarimarima bono kira-varari.” Benamo ḡia eiaḡoto, ḡena vanuḡa tarimari mabarari Iesu ḡena veiḡa ḡia ḡenai ḡeḡorato eḡobata-iaḡirito. ");
INSERT INTO snc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu kou mo reke na ma eḡenoḡoito nai, tarimarima ḡutuma na ḡeḡabi-raḡeato ma iakuri ḡesi, korana mabarari na Iesu ḡevaḡa-nogaiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Benamo tau ta arana Iairo, rubu ḡitaḡauna tarimana, Iesu ḡenai eiaḡoto, kwakuna koranai evetui-tarito, enoḡiato, ḡena numa ḡana ḡeiaḡo etato, ");
INSERT INTO snc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","korana ḡia natuna kekenina, ḡora ḡereḡa, dori emaseto-ḡoi nai. Ḡena laḡani tu gabanana ruarua (12). Iesu eiaḡoto-ḡoi nuḡanai, tarimarima ḡutuma na ḡeraka-vebibi vebibiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Moḡa nuḡanai vavine ta, ḡena keve tu rara kevena; laḡani gabanana ruarua (12) ekeve-iaḡiato. Ḡia na ḡena farefare e moni mabarari evaḡa-koririto doketa ḡeri ai ḡena keve beḡene vaḡa-namoa ḡana. Senaḡi ta na asi evaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tarimarima ḡutuma muriri ai vau evebibi-toḡato, ma tavi ta na ea raka-rosito mo, Iesu sevinai ea raḡasito. Iesu ḡena dabuḡa dudunai eveḡabikauto. Benamo vaḡa-sebo ḡena rara kevena ekorito. ");
INSERT INTO snc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu evedanaḡito, ekirato, “Dei na au beḡabi-karagu?” Mabarari ḡevekira-ḡuniḡauto, ḡekirato, “Au tu asiḡi.” Benamo Petero ekirato, “Vevaḡa-riba taumu, tarimarima oḡitarini, ḡekou-ḡeḡeraḡimuni ema ḡeraka-vebebesi vebebesini.” ");
INSERT INTO snc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Senaḡi Iesu ekirato, “Ta na au beḡabi-karagu, korana au ribagu, seḡuka au ḡeguna varau beraka-vaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mai vavine varau eribato, ḡia asi ḡena vekuretoḡa dabarana, benamo ma ḡoḡo-ḡoḡona ḡesi eiaḡoto, Iesu kwakuna koranai evetui-tarito, Iesu kara dainai eḡabi-karaiato ema ḡena keve vaḡa-sebo ekorito varina ekiraḡi-foforirito tarimarima ḡoirari ai. ");
INSERT INTO snc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Benamo Iesu na ekiraiato, ekirato, “Natugu, ḡemu veḡabidadama na bevaḡa-namomu. Be, ma nuḡa namomu ḡesi noiaḡo.” ");
INSERT INTO snc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu roḡo mo eguruḡato-ḡoi nuḡanai, tarima ta rubu ḡitaḡauna tauna Iairo ḡena numa na eiaḡomato, ekirato, “Natumu varau bemase. Vevaḡa-riba tauna asi novaḡa-vekwaraḡia.” ");
INSERT INTO snc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu na mo guruḡa eseḡaḡiato nai, Iairo ekiraiato, ekirato, “Asi bono gari, bono veḡabidadama moḡo, benamo ḡia tu bemaḡurini.” ");
INSERT INTO snc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iairo ḡena numai eraḡasito, benamo Iesu na tarimarima ekirarito, numai asi beḡene raḡekau, Petero, e Iakobo (o Iames), e Ioane, ema kekeni tamana ma sinana moḡo. ");
INSERT INTO snc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mabarari tu ḡetaḡito-ḡoi ema ḡetaḡi-guruḡa guruḡato-ḡoi nuḡanai, Iesu ekirato, “Asi ḡotaḡi, kekeni tu asi bemase, ḡia tu egenani moḡo.” ");
INSERT INTO snc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tarimarima na ḡerikiriki-iaḡiato, korana ḡia ribari, kekeni tu emaseto. ");
INSERT INTO snc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Senaḡi Iesu na kekeni ḡimanai eḡabito, evaḡa-guruḡaiato, ekeato, “Natugu o, novariḡisi!” ");
INSERT INTO snc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Benamo iaukana eḡenoḡoito, ma emaḡurito, vaḡa-sebo evariḡisito. Iesu na ekirarito, kekeni beḡene ḡubua. ");
INSERT INTO snc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ḡia tamana sinana ḡeḡaba-rakavato, senaḡi Iesu na evaḡa-naḡirito, mai veiḡa varina tarima ta asi beḡene kira-varaia. ");
INSERT INTO snc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu na ḡena mero gabanana ruarua (12) ekea-vegogorito, seḡuka evinirito, iauka rakavari mabarari beḡene lai-vaḡiri, ema keve tarimari beḡene vaḡa-namori ḡana. ");
INSERT INTO snc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Benamo etuḡurito, Barau ḡena Basileia varina beḡene ḡobata-iaḡia, ema keve tarimari beḡene vaḡa-namori. ");
INSERT INTO snc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Evaḡa-guruḡarito, ekirato, “Ḡemi iaḡoiaḡo ai kara ta asi boḡono ḡabi-kaua, togoi, dura, ḡaniḡani dagarari, moni, ema sedi ruarua maki asi boḡono ḡabi. ");
INSERT INTO snc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Beḡe ḡabi-raḡemini numanai boḡono tanu, bene iaḡo mo, vanuḡa boḡono raga-kwanea. ");
INSERT INTO snc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bema vanuḡa tai asi beḡe ḡabi-raḡemini nai, mo vanuḡa boḡono raga-kwanea, kwakumi kauri boḡono kwari-ketoketori, ḡia ḡeri kira-sirivaḡi vaḡa-moḡoniri ḡana.” ");
INSERT INTO snc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iesu ḡena mero ḡerakato, vanuḡa tata ḡana ḡeiaḡoto, Vari Namona ḡeḡobata-iaḡiato-ḡoi ema keve tarimari ḡevaḡa-namorito-ḡoi gabu mabarari ai. ");
INSERT INTO snc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroda, Galilea tanona verena, Iesu varina eseḡaḡiato, benamo edaradara-rakavato, korana tarima kota ḡekirato, Ioane Babatiso tu mase na ma evariḡisi-ḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma kota ḡekirato, Elia efoforito. Ma kota ḡekirato, peroveta tarimana guinena ta evariḡisi-ḡenoḡoito, ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Senaḡi Heroda ekirato, “Ioane debana tu au na abasi-ḡutuato. Be, mai varina aseḡaḡiani tarimana tu dei?” Heroda eurato Iesu bene ḡitaia. ");
INSERT INTO snc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu ḡena apostolo ma ḡeḡenoḡoito, karakara ḡeveirito veiḡari variri Iesu ḡekira-varaiato. Benamo Iesu na eḡori-ḡerevaḡirito, vanuḡa ta arana Betesaida ḡana eḡori-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Senaḡi tarimarima na ḡeseḡaḡirito nai, Iesu murina na ḡerakato. Benamo Iesu na eḡabi-raḡerito, Barau ḡena Basileia varina eḡobata-vinirito ema keve tarimari evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ḡaro evariḡoto-ḡoi nuḡanai, ḡena mero gabanana ruarua (12) Iesu ḡenai ḡeiaḡoto, ḡekirato, “Mai tarimarima notuḡuri, be kavinaḡi vanuḡari ai ema vamoka vei tarimari ḡeri tanu gaburi ai, ḡari ḡaniḡani e gena-gaburi ḡea vetau, korana mai tu tano fakana nai.” ");
INSERT INTO snc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Senaḡi Iesu na evaḡa-guruḡarito, ekirato, “Ḡomi na ḡaniḡani ḡoviniri.” Ḡia na ḡevaḡa-veseato, ḡekirato, “Ḡai ḡemai beredi tu imaima (5) ema maḡani-kone ruarua (2) moḡo. Ḡoi ourani ḡai baḡana iaḡo, ḡaniḡani baḡana voiri mai tarimarima ḡutuma ḡari?” ");
INSERT INTO snc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Korana tau mabarari tu 5,000 kavana. Iesu na ḡena mero ekirarito, ekirato, “Tarimarima ḡovareri doḡoro ta gabana imaima (50), doḡoro ta gabana imaima (50), benamo ḡene tanutanu-tari.” ");
INSERT INTO snc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iesu ekirato lorinai ḡeveiato, tarimarima mabarari ḡevaḡa-tanutanu-taririto. ");
INSERT INTO snc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Moḡa murinai Iesu na beredi imaima e maḡani-kone ruarua eḡabirito, gubai egaga-raḡeto, Barau evaḡa-namoato vau, ebuki-ḡutuḡuturito ema ekini-misimisirito, benamo ḡena mero evinirito beḡene vareri. ");
INSERT INTO snc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tarimarima na ḡeḡanirito nai, mabarari ḡeḡani-maseto. Gabivau Iesu ḡena mero na ḡaniḡani kwari ḡevaḡa-vegogorito, boseḡa gabanana ruarua (12) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ḡaro ta Iesu ḡereḡana eḡuriḡurito, ḡena mero maki ḡia ḡesi. Benamo Iesu na edanaḡirito, ekirato, “Tarimarima tu kara ḡetoni au tu dei?” ");
INSERT INTO snc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ḡia ḡevaḡa-veseto, ḡekirato, “Kota ḡekirani ḡoi tu Ioane Babatiso, ma kota tu Elia, ma kota tu peroveta tarimana guinena ta evariḡisi-ḡenoḡoito.” ");
INSERT INTO snc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iesu na ekirarito, ekirato, “Senaḡi ḡomi tu kara ḡotoni au tu dei?” Petero na evaḡa-veseato, ekirato, “Ḡoi tu Barau ḡena Keriso, ḡia na ekiraḡi-toreato vevaḡa-maḡuri tauna.” ");
INSERT INTO snc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu na elaunaḡirito, ḡia varina tarima ta asi beḡene kira-varaia. ");
INSERT INTO snc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ḡia ma ekirato, “Tarimarima Natuna midigu vovoka roḡo beḡanini. Iuda vereri, e Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiani tarimari na beḡe ruḡaiani; ema beḡe vaḡi-maseani maki, senaḡina ḡaro vaḡa-toitoinai vau mase na ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesu na ḡia mabarari evaḡa-guruḡarito, ekirato, “Bema tarima ta eurani au murigu ai bene raka etoni tarimana, tauḡena bene vekira-fitoḡa, ḡena satauro bene ḡwaia ḡaro mabarari ai, au murigu ai bene raka. ");
INSERT INTO snc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Korana deikara ḡena maḡuri moḡo lorina etoreani tarimana, ḡena maḡuri befitoḡaiani. A deikara au daigu ai ḡena maḡuri befitoḡaiani tarimana, ḡena maḡuri asi bevei-rekwarekwaiani. ");
INSERT INTO snc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bema tarima ta na tanobara mabarana uranai ḡena maḡuri befitoḡaiani, a ḡia tauḡena ḡena maḡuri bevaḡa-rakavaiani, ḡena namo tu kara ḡia ḡenai? ");
INSERT INTO snc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bema tarima ta na au ema ḡegu guruḡa maiakari na bemaiakaiani nai tu, Tarimarima Natuna na maki ḡia bemaiaka-viniani ḡena iaḡomai, ma mamana marevana e seḡuka baregona ḡesi, Tamana ma aneru veaḡari ḡesi beḡe iaḡomani ḡaronai. ");
INSERT INTO snc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Moḡoni akiramini, mainai ḡeruḡa-taḡoni tarimari kota asi roḡo beḡe maseni, Barau ḡena Basileia beḡe ḡitaiani.” ");
INSERT INTO snc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mai guruḡa ekiraḡi-ḡosiato murinai, ḡaro imaima toitoi (8) kavana ḡevanaḡito vau, Iesu na Petero, e Ioane, ema Iakobo (o Iames) eḡabirito, ḡoro ta ḡana ḡevaraḡeto bene ḡuriḡuri ḡana. ");
INSERT INTO snc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eḡauḡauto-ḡoi nuḡanai, ḡia ḡoirana vetoḡana eirauto, ema ḡena dabuḡa ekuro-ḡaroḡaroto. ");
INSERT INTO snc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Benamo tarima ruarua ḡefoforito, Mose ma Elia, Iesu ḡesi ḡeguruḡa guruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tauri ruarua ma marevari e mamari ḡesi ḡefoforito, Iesu ḡesi ḡeguruḡato, Ierusalemai bemaseni ḡetato, Barau ḡena ura ilailanai. ");
INSERT INTO snc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero ma karona ḡegena-maseto, senaḡi ma ḡetataḡato nai, Iesu ma marevana e mamana ḡesi ḡeḡitaiato, ema ḡia ḡesi ḡeruḡa-taḡoto tarimari maki ḡeḡita-rito. ");
INSERT INTO snc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tauri ruarua Iesu ḡeraga-kwanea ḡana nuḡanai, Petero na Iesu ekiraiato, ekirato, “Vevaḡa-riba taumu, namo vedaurea ḡita tu maiḡera, be mainai fouta toitoi ḡaragari. Ta ḡoi ḡemu, ta Mose ḡena, ta Elia ḡena.” Ḡia asi ribana kara ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ḡia roḡo eguruḡato-ḡoi nai, magube na ema iauka-taririto. Magube na eḡabi-ḡaurito nai, ḡia ḡegarito. ");
INSERT INTO snc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Garo ta magube nuḡana na ekea-rosito, ekirato, “Mai tu au Natugu, aḡabi-hidiato tarimana, ḡia boḡono seḡaḡi-vinia!” ");
INSERT INTO snc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mo garo ekorito nai, Iesu ḡereḡana ḡeḡitaiato. Mai veiḡa ḡeḡitarito dagarari, tarima ta asi ḡekira-varaiato mo negai. ");
INSERT INTO snc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ḡaro ta ekorito murinai, ḡia tu ḡoro na ḡeraka-variḡoto-ḡoi nuḡanai, tarimarima ḡutuma lelevaḡi ḡesi ḡeraka-veḡoitaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Benamo tau ta ḡutuma nuḡari na ekea-fouto, ekirato, “Vevaḡa-riba taumu o, anoḡimuni, au natugu merona noma ḡitaia. Mai tu au natugu sebona, ḡora ḡereḡa. ");
INSERT INTO snc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nega tari ai ḡia tu iauka rakavana na eḡabiani, benamo ekoḡo-founi; tauḡanina maki evaḡa-ḡoḡo-ḡoḡoani, benamo bokana na kaburoburo ḡeraka-rosini. Maiḡesina evaḡi-mase vanaḡi-vanaḡiani. ");
INSERT INTO snc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ḡoi ḡemu mero banoḡiri, ḡelai-vaḡia basi, senaḡi ḡia asi beḡe ilaila.” ");
INSERT INTO snc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu evaḡa-veseto, ekirato, “Asi veḡabidadama ema kira-sirivaḡi ḡuruna o! Ḡaro vira au tu sevimi ai bana tanu? Ḡaro vira bana vevaḡa-gwaḡiḡi-vinimi?” Benamo Iesu na mo tau ekiraiato, ekirato, “Natumu noḡori-iaḡomaia.” ");
INSERT INTO snc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mero eiaḡomato-ḡoi nai, iauka rakavana na tano ekwaraḡi-iaḡiato, tauḡanina evaḡaḡoḡo-ḡoḡoato. Senaḡi Iesu na iauka rakavana ekira-ḡoiato, mero evaḡa-namoato, benamo tamana ma evini-ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tarima mabarari ḡeḡaba-rakavato, korana Barau ḡena seḡuka ḡeḡitaiato nai. Tarimarima roḡo Iesu ḡena veiḡa ḡeḡaba-iaḡiato-ḡoi nai, Iesu na ḡena mero evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Au na guruḡa ta ḡemi nakiraḡia, be ḡoseḡaḡi ema asi boḡono tuḡa-rekwaia. Tarimarima Natuna tu beḡe revaiani vau tarimarima ḡimari ai beḡe toreani.” ");
INSERT INTO snc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Senaḡi ḡena mero na asi ḡetuḡamaḡi-doḡariato, Iesu tu kara ekiraḡiato. Mo guruḡa anina tu ḡia ḡeri ai vekuretoḡa, asi beḡene ribaia ḡana, ema Iesu maki asi ḡedanaḡiato, korana ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesu ḡena mero fakari ai vevane eḡorato, korana tu ḡekirato, dei tu barego vedaurea ḡia fakari ai. ");
INSERT INTO snc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu varau eribato kara ḡetuḡamaḡiato, moḡa lorinai mero keina ta eḡabiato, ḡia sevinai evaḡa-ruḡa-tariato vau, ");
INSERT INTO snc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ekirarito, ekirato, “Dei na mai mero beḡabi-raḡeani au aragu ai, ḡia na au beḡabi-raḡeguni. Bema tarima ta na au beḡabi-raḡeguni, etuḡuguto Barauna maki beḡabi-raḡeani. Korana deikara ḡomi na ḡokira-fitoḡaiani tarimana ḡomi fakami ai, ḡia tu barego vedaurea.” ");
INSERT INTO snc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioane na Iesu evaḡa-guruḡaiato, ekirato, “Vevaḡa-riba taumu, tarima ta ḡaḡitaiato, ḡoi aramu ai iauka rakavari elai-vaḡirito-ḡoi, senaḡi ḡai na ḡakira-ḡoiato, korana ḡia tu dia ḡita ḡesi taḡauveini nai.” ");
INSERT INTO snc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu na ekirarito, ekirato, “Asi boḡono kira-ḡoia, korana deikara na ḡomi asi evaḡa-rakavamini tarimana tu ḡomi evaḡa-kavamini.” ");
INSERT INTO snc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu guba ḡana bevaraḡeni ḡarona ekavinaḡiato-ḡoi nai, Ierusalema bene iaḡo-vinia, etato. ");
INSERT INTO snc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Benamo Iesu na vetuḡunaḡi tarimari etuḡu-guinerito, Samaria vanuḡana tai ḡeraḡasito, Iesu ḡena totoḡa gabuna ḡea vetauato. ");
INSERT INTO snc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Senaḡi vanuḡa tarimari na Iesu asi ḡeḡabi-raḡeato, korana tu Ierusalema eiaḡo-viniato-ḡoi nai. ");
INSERT INTO snc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iesu ḡena mero Iakobo (o Iames) e Ioane mo veiḡa ḡeḡitaiato, benamo ḡekirato, “Vereḡauka, ḡoi ourani karava guba na baḡana kiraḡia, bene mariḡo, bene vaḡa-rakavari?” ");
INSERT INTO snc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu eruḡa-kureto, tauri ruarua ekira-ḡoirito. ");
INSERT INTO snc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Benamo ḡia ma ḡerakato, vanuḡa ta ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ḡia dabara na ḡeiaḡoto-ḡoi nai, tarima ta na Iesu evaḡa-guruḡaiato, ekirato, “Ḡemu iaḡoiaḡo gaburi mabarari ai bana kavamu.” ");
INSERT INTO snc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu na ekiraiato, ekirato, “Boḡa kwaivari ma ḡeri kouḡa, ema manu ma ḡeri nuḡi, senaḡi Tarimarima Natuna tu asi ḡena gena-gabuna.” ");
INSERT INTO snc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iesu na tarima ta ma evaḡa-guruḡaiato, ekirato, “Murigu ai noma raka.” Senaḡi mo tarima evaḡa-veseto, ekirato, “Vereḡauka, asi roḡo, naḡenoḡoi, be tamagu roḡo naguria.” ");
INSERT INTO snc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu na evaḡa-veseato, ekirato, “Mani tu noiaḡuiri, mase tarimari (o Barau asi ḡekorana-iaḡiani tarimari) na ḡeri mase tauḡeri na beḡene guriri. Senaḡi ḡoi tu noiaḡo, Barau ḡena Basileia varina noa vari-fiua.” ");
INSERT INTO snc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tarima ta na ma ekiraiato, ekirato, “Vereḡauka, murimu ai naraka, senaḡi naiaḡo roḡo, ḡegu numa tarimari ḡesi ḡaveḡabi-tuḡu.” ");
INSERT INTO snc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu na evaḡa-veseato, ekirato, “Tarima ta efokafokani nai, murina ḡana ma eboḡe-ḡenoḡoini, ḡia tu asi ilaila Barau ḡena Basileia beḡabiani.” ");
INSERT INTO snc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Moḡa murinai Vereḡauka na tarima 72 eḡabi-viriḡirito, benamo ruari ruari etuḡu-guinerito, ḡia beiaḡoni vanuḡari e gaburi mabarari ḡana. ");
INSERT INTO snc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Evaḡa-guruḡarito, ekirato, “Kwakwa ḡaniḡaniri tu ḡutuma lelevaḡi, senaḡi kwakwa tarimari tu viravira moḡo. Moḡa lorinai kwakwa Vereḡaukana ḡonoḡia, be kwakwa tarimari tari ma bene tuḡu-iaḡori, ḡaniḡani beḡenea kwari. ");
INSERT INTO snc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ḡoiaḡo, au na mamoe kavana atuḡumini, boḡa kwaivari rakavari fakari ai. ");
INSERT INTO snc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Moni fusefuseri, dura e tamaka asi boḡono ḡabikau; dabarai tarima ta asi boḡono vaḡa-guruḡaia. ");
INSERT INTO snc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bema numa tai boḡo raḡekauni nai, boḡono kira, ‘Maino mai numai bene tanu.’ ");
INSERT INTO snc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bema maino eura-viniani tarimana monai etanuni nai, ḡemi maino guruḡana ḡia iatanai bene tanu. Bema asiḡina nai, maino tu ḡemi ai ma bene ḡenoḡoi. ");
INSERT INTO snc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Karakara beḡe vinimini boḡono ḡaniri e boḡono niuri, korana eḡauveini tarimana davana bene ḡabia ḡana. Numa ta na ma numa ta ḡana asi boḡono iaḡo, senaḡi mo numa sebonai moḡo boḡono tanu. ");
INSERT INTO snc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bema vanuḡa tai boḡo raḡasini, beḡe ḡabi-raḡemini, karakara ḡoirami ai beḡe tore-rosirini dagarari boḡono ḡaniri. ");
INSERT INTO snc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mo vanuḡai keve tarimari boḡono vaḡa-namori e tarimarima boḡono vaḡa-guruḡari, boḡono kira, ‘Barau ḡena Basileia, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani), tu sevimi ai maiḡa.’ ");
INSERT INTO snc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Senaḡi bema vanuḡai boḡo raḡasini, benamo asi beḡe ḡabi-raḡemini nai, ḡatamanai boḡono raka-rosi, boḡono kira, ");
INSERT INTO snc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ḡemi vanuḡa gagauri kwakumai beḡe kafakau dagarari maki mai ḡakora-vaḡirini ḡemi kira-sirivaḡi vaḡa-foforiri ḡana. Senaḡi boḡono riba, Barau ḡena Basileia tu bekavi-naḡi.’ ");
INSERT INTO snc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Au na akiramini, Kota baregona ḡaronai mai vanuḡa na meto beḡwaiani tu, Sodoma ḡena meto maki bevanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasini o, ḡoi ema Betesaida, vetuḡami kika! Korana nuḡa-farevaḡi veiḡari ḡemi ai ḡefoforito-ḡoi tu, Taia e Sidono nuḡari ai beḡere fofori, benamo ḡia tu irau laḡani ai ḡere vetuḡamaḡi-kure, fuse rakavari ai e tauḡaniri ma gurumari ai ḡeri vetuḡamaḡi-kure ḡere vaḡa-foforia. ");
INSERT INTO snc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Barau na tarimarima bekota-vinirini ḡarona baregonai, ḡomi na boḡo doḡariani metona tu Taia e Sidono ḡeri meto bevanaḡiani. ");
INSERT INTO snc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ḡoi maki, Kaperanauma o, ḡoi ourani guba ḡana bono varaḡe otoni? Asiḡina, ḡoi tu mase gabuna ḡana boiaḡoni!” ");
INSERT INTO snc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Dei na ḡomi beseḡaḡi-vinimini, au maki beseḡaḡi-viniguni; dei na asi beḡabi-raḡemini, au maki asi beḡabi-raḡeguni; ema dei na asi beḡabi-raḡeguni, etuḡuguto Barauna maki asi beḡabi-raḡeani.” ");
INSERT INTO snc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ḡena mero 72 ma ḡeḡenoḡoito ma iakuri ḡesi, ḡekirato, “Vereḡauka o, iauka rakavari ḡoi aramu ai ḡavaḡa-guruḡarito, benamo garoma ḡeseḡaḡirito-ḡoi.” ");
INSERT INTO snc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu na evaḡa-veserito, ekirato, “Satani aḡitaiato, kiriku ekimoreani kavana guba na eketo-firiḡoto. ");
INSERT INTO snc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Boḡono riba, au na seḡuka varau avinimito, mota ema kavikavi boḡono fana-tariri, ema Satani ḡena seḡuka maki boḡono vaḡa-farakaia ḡana; dagara ta na asi bevaḡa-rakavamini. ");
INSERT INTO snc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Senaḡina, dia boḡono iaku korana iauka rakavari ḡomi ḡemi seḡuka nuḡanai, asiḡina, a ḡomi tu boḡono verere korana arami gubai etorerito nai.” ");
INSERT INTO snc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mo tanu-vegogo nuḡanai Iauka Veaḡa na Iesu tu iaku na evaḡa-vonuato, benamo ekirato, “Tamagu o, avaḡa-namomuni, guba ema tanobara Verena! Korana ḡoi na ma iaunegari e riba tarimari ḡeri ai okure-toḡarini dagarari tu, asi ḡeri riba tarimari ḡeri ai ovaḡa-foforirini. Aba, Tamagu, mai tu ḡoi ḡemu veuravini korana evaḡa-foforiani. ");
INSERT INTO snc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dagara mabarari Tamagu na eviniguto. Tarima ta asi ribana ḡia Natuna, Tamana moḡo ḡereḡana, ema ta asi ribana ḡia Tamana, senaḡi Natuna ḡereḡana moḡo, ema Natuna na eura-vinirini tarimari ḡeri ai vau evaḡa-foforirini.” ");
INSERT INTO snc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Benamo Iesu eboḡe-kureto ḡena mero ḡeri ai, veḡuni ai evaḡa-guruḡarito, ekirato, “Ḡomi tu boḡono iaku, korana tu mai ḡoḡitarini dagarari dairi ai. ");
INSERT INTO snc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Au na akiramini, peroveta tarimari e tanobara vereri baregori o kini vovoka ḡeurato, mai ḡoḡitarini dagarari beḡere ḡitari, senaḡi asi ḡeḡitarito, ema ḡoseḡaḡirini dagarari beḡere seḡaḡiri, senaḡi asi ḡeseḡaḡirito.” ");
INSERT INTO snc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Taravatu evevaḡa-riba iaḡiato-ḡoi tarimana ta evariḡisito, benamo Iesu eribaḡaniato, ekirato, “Vevaḡa-riba taumu, au tu kara baveini vau, maḡuri vanaḡivanaḡi badoḡariani?” ");
INSERT INTO snc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu na evaḡa-veseato, ekirato, “Taravatu tu kara etoni? Ḡoi na tu kamasi oiaviani?” ");
INSERT INTO snc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ḡia evaḡa-veseto, ekirato, “‘Vereḡauka ḡoi ḡemu Barau bono ura-vinia ma nuḡamu mabarana, ma iaukamu mabarana, ma kokoremu mabarana, e ma tuḡamaḡimu mabarana’; ema ‘Sevimu tarimana maki bono ura-vinia ḡoi tauḡemu oveura-vinini kavana.’” ");
INSERT INTO snc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu na ekiraiato, ekirato, “Bovaḡa-vese maoro, maniḡesi bono vei, be bono maḡuri.” ");
INSERT INTO snc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Senaḡi taravatu evevaḡa-riba iaḡiato-ḡoi tarimana tu ma veiavina ḡesi Iesu ma edanaḡi-veribaḡaniato, ekirato, “Au sevigu tarimana tu dei?” ");
INSERT INTO snc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu evaḡa-veseto, ekirato, “Tau ta Ierusalema na Ieriko evariḡo-viniato-ḡoi nuḡanai, lema tarimari na dabarai ḡeguru-viniato, ḡena dabuḡa ḡekokirito, ḡevaḡa-vevaḡiato, dori moḡo ḡevaḡi-maseato, benamo monai ḡeraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Moḡa Rubu Veaḡa verena ta mo dabara na evariḡoto-ḡoi nai, mo tau edoḡariato, senaḡi eraka-ḡevi-raḡiato moḡo. ");
INSERT INTO snc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levi doḡorona tarimana ta, (Rubu Veaḡai vetuḡunaḡi tauna), maki moḡesi, mo tau ea doḡariato nai, maki eraka-ḡevi-raḡiato moḡo. ");
INSERT INTO snc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Senaḡina Samaria tarimana ta ḡena iaḡoiaḡo ai mo tau ea doḡariato, eḡitaiato nai, evetuḡaiato. ");
INSERT INTO snc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sevina ḡana eiaḡoto, diḡa e vine nanuna manuḡanai ebubuto, ekumuato, benamo ḡena doniki ai evaḡa-tanu-kauato, vinitaḡo numana ḡana eḡori-iaḡoato, monai enariato. ");
INSERT INTO snc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Boḡiboḡi evariḡisito nai, silva moniri ruarua numa ḡitaḡauna tarimana eviniato, ekirato, ‘Mai tau bono nariḡau-ḡitakaua. Bema moni asi beilailani nai, ḡegu ḡenoḡoi ai vau ḡemu moni davana bavinimuni.’” ");
INSERT INTO snc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu evedanaḡito, ekirato, “Ḡoi tu kara otoni? Mai tarima toitoi fakari ai deikara sevina tarimana tu mo lema tarimari na ḡevaḡa-vevaḡiato tauna ḡenai bita kiraḡiani?” ");
INSERT INTO snc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Taravatu evevaḡa-riba iaḡiato-ḡoi tarimana evaḡa-veseto, ekirato, “Evetuḡaiato tarimana.” Benamo Iesu na ekiraiato, “Noiaḡo, ḡoi maki moḡesi bono vei.” ");
INSERT INTO snc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ma ḡena mero ḡesi ḡeri iaḡoiaḡo ai vanuḡa tai ḡea votuto. Monai vavine ta arana Mareta ḡena numai eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ḡia tu ma tarina arana Maria, benamo Maria tu eiaḡoto, Vereḡauka kwakuna koranai etanu-tarito, ḡena guruḡa eseḡaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mareta tu veḡabiraḡe dagarari eveito-ḡoi, evekwaraḡito-ḡoi. Benamo eiaḡomato, ekirato, “Vereḡauka, ḡoi tu otuḡamaḡini ba? Tarigu na beraga-kwanegu, au ḡereḡagu moḡo avekwaraḡini. Nokiraia, be nema vaḡa-kavagu!” ");
INSERT INTO snc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Vereḡauka na evaḡa-veseato, ekirato, “Mareta! Mareta! Dagara ḡutumari na nuḡamu ḡevaḡa-veḡonuani e ḡevaḡa-vekwaraḡiani, ");
INSERT INTO snc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","senaḡi dagara sebona moḡo ḡerevaḡi. Maria na tu namona beḡabi-viriḡia, ta na ḡia ḡenana asi ma beḡabi-vaḡiani.” ");
INSERT INTO snc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ḡaro tai Iesu tu gabu tai eḡauḡauto. Ekorito nai, ḡena mero ta na evaḡa-guruḡaiato, ekirato, “Vereḡauka o, ḡuriḡuri novaḡa-ribama Ioane na ḡena mero evaḡa-ribarito ilailanai.” ");
INSERT INTO snc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu na ekirarito, ekirato, “Ḡoḡuriḡurini nai, boḡono kira: ‘Ḡai Tamama o, ḡoi aramu baḡana vaḡa-veaḡaia; ḡemu Basileia bene iaḡoma. ");
INSERT INTO snc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ḡaro tata ḡai ḡema-ḡama bonoma vinima. ");
INSERT INTO snc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ḡema rakava notuḡamaḡi-fitoḡari, korana ḡai maki ḡevaḡa-rakavamani tarimari ḡeri rakava ḡatuḡamaḡi-fitoḡarini. Ema veribaḡani ai asi bono ḡori-kauma.’” ");
INSERT INTO snc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Bema ḡomi ta boḡi nuḡanai ḡatana ḡenai bere iaḡo, bere noḡia, bere kira, ‘Ḡatagu o, ḡaniḡani dagarari kota naḡabi-toreri roḡo, ");
INSERT INTO snc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","korana au ḡatagu ta tu ḡena iaḡoiaḡo ai ḡegu ai beiaḡoma, senaḡi au tu asi ḡegu ḡaniḡani ḡia baḡubuani.’ ");
INSERT INTO snc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Benamo mo tarima na numa nuḡana na bere vaḡa-vesea, bere kira, ‘Asi novaḡa-vekwaraḡigu. Ḡatama-boka varau babiria, ema au tu natugu ḡesi ḡagenani. Au tu asi bavariḡisini, dagara ta asi bavinimuni.’ ");
INSERT INTO snc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Akiramini, enabe ḡia ḡatana, senaḡi asi bevariḡisini, ḡaniḡani asi beviniani, senaḡi ḡena noḡinoḡi ḡenoḡoi-ḡenoḡoi dainai bevariḡisini, eura-vinirini dagarari beviniani. ");
INSERT INTO snc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Moḡa lorinai, au na ḡomi akiramini, noḡinoḡi ai Barau na bevinimini, vetauvetau ai boḡo doḡarini, sekeseke o fidifidi ai ḡemi ḡatama-boka bekeoani. ");
INSERT INTO snc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Korana benoḡi-noḡini tarimana tu beḡabini, bevetauni tarimana bedoḡarini, ema beseke-sekeni tarimana Barau na ḡena ḡatama boka bekeoani. ");
INSERT INTO snc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ḡomi tama fakami ai deikara bema natumu merona maḡani-kone benoḡini nai, ḡoi na tu mota boviniani? ");
INSERT INTO snc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ḡatoi benoḡini nai, kavikavi boviniani? ");
INSERT INTO snc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Boḡono tuḡamaḡi, ḡomi tu rakava tarimami, senaḡi dagara namori natumi viniviniri ma ribami, moḡa lorinai ḡomi Tamami gubai etanuni, ḡia na Iauka Veaḡa ḡenoḡi-viniani tarimari bevinirini veḡatana!” ");
INSERT INTO snc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu na iauka rakavana, muru-bubu iaukana, elai-vaḡiato, benamo mo muru-bubu tarimana eguruḡato. Tarimarima ḡutuma na ḡevaḡa-raḡeato, ");
INSERT INTO snc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","senaḡi tarima kota ḡekirato, “Mai tu Belsebul, iauka rakavari ḡeri vere, ḡena seḡukai iauka rakavari elai-vaḡirini.” ");
INSERT INTO snc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tarima kotari na Iesu ḡedanaḡi-veribaḡaniato, vetoḡa ta guba na bene viniri ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Senaḡi Iesu na ḡia ḡeri tuḡamaḡi eribarito, benamo evaḡa-guruḡarito, ekirato, “Gavamani ta beveḡabi-kirani, ḡia tu berakavani, ema doḡoro ta beveḡabi-kirani, ḡia tu beketoni. ");
INSERT INTO snc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Moḡa lorinai Satani tu tauḡena moḡo bevevare-kirani, ḡena basileia tu kamasi beruḡani? Maiḡesi akiraḡiani, korana tu ḡomi ḡokirani, au tu Belsebul ḡena seḡukai iauka rakavari alai-vaḡirini. ");
INSERT INTO snc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bema au iauka rakavari Belsebul ḡena seḡukai alai-vaḡirini nai, ḡomi murimi ai ḡerakani tarimari na iauka rakavari aiḡesi ḡelai-vaḡirini? Ḡia na ḡevaḡa-moḡoniani ḡomi ḡemi guruḡa tu asi anina. ");
INSERT INTO snc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Senaḡi bema au iauka rakavari Barau ḡena seḡukai alai-vaḡirini nai, boḡono riba, Barau ḡena Basileia, ḡena veḡitaḡau seḡukana, tu ḡomi ḡemi ai varau beraḡasi. ");
INSERT INTO snc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kokore tarimana ma ḡena vaḡivaḡi dagarari ḡesi ḡena numa beḡita-ḡauani nai, ḡena farefare tu roḡo beḡe tanu-ginikauni. ");
INSERT INTO snc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Senaḡina kokore vedaurea tarimana ta ma beiaḡomani, mai tarima bevaḡa-vevaḡiani, benamo bevaḡa-darereani, ḡia ḡena vaḡivaḡi dagarari, veḡabidadama dagarari, beverariani, benamo ḡena farefare mabarari bevare-rovorovorini. ");
INSERT INTO snc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Deikara dia au ḡatagu tu, au ḡegu inai tarimana, ema deikara au ḡesi asi etore-vegogoni tu eveiari-lausilausini.” ");
INSERT INTO snc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Iauka rakavana ta tarima ta ḡenana eraka-rosito, benamo gabu kaukauri na eraka-vanaḡito, iaḡana bene ḡania etato, senaḡi iaḡaraḡi gabuna ta asi edoḡariato. Benamo ḡia tauḡena ekirato, ‘Naḡenoḡoi, araga-kwaneato numana ḡana.’ ");
INSERT INTO snc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eḡenoḡoi-iaḡoto, numa edoḡariato. Numana tu veiareva ema ḡitaḡitana namo vedaurea. ");
INSERT INTO snc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Benamo ḡia na iauka rakava kwaikwairi imaima ruarua (7) ma eḡori-iaḡorito, mabarari ḡeraka-toḡato, monai ḡetanuto. Moḡa lorinai mo tarima tu tovotovonai ḡena rakava tu kota misina, senaḡi dokonai ḡena rakava tu barego vedaurea.” ");
INSERT INTO snc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mo guruḡa ekiraḡiato-ḡoi nai, vavine ta tarimarima ḡutuma fakari na eguruḡa-vaisito, ekirato, “Ḡoi evaḡa-maḡurimuto e evini-rurumuto vavinena tu namo!” ");
INSERT INTO snc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Senaḡi Iesu evaḡa-veseto, ekirato, “Iniḡesi nokira, Barau ḡena ḡuruḡa ḡeseḡaḡiani ema ḡekorana-iaḡiani tarimari neḡi namo!” ");
INSERT INTO snc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tarimarima ḡutuma na Iesu ḡeruḡa-ḡeḡeraḡiato, benamo evaḡa-guruḡarito, ekirato, “Toma ḡuru tu ḡuru rakavana! Seḡuka vetoḡana ḡevetauani, senaḡi vetoḡa ta asi beḡe doḡariani, Iona, peroveta tarimana, vetoḡana moḡo. ");
INSERT INTO snc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Korana Iona tu vetoḡa ta Nineva tarimari ḡeri ai, moḡa ilailanai Tarimarima Natuna tu vetoḡai beiaḡoni mai ḡuru tarimari ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Barau na tarimarima bekota-vinirini ḡaronai, Seba vavine baregona o Kwin beruḡa-vaisini, mai ḡuru tarimari besamanirini, korana ḡia tu ḡena tanobara manaḡana na eiaḡomato, Solomona ḡena iaunega guruḡari bene seḡaḡiri ḡana. Senaḡi ḡoḡitaia, tarima ta na Solomona evanaḡiani tu maiḡa. ");
INSERT INTO snc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Barau ḡena Kota baregona ḡaronai, Nineva tarimari beḡe ruḡa-vaisini, toma ḡuru tarimari beḡe samanirini, korana Iona ḡena ḡobata ḡeseḡaḡiato neganai, ḡia ḡeri rakava ḡerina ḡevetuḡamaḡi-kureto. Senaḡi tarima ta na Iona evanaḡiani tu maiḡa.” ");
INSERT INTO snc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Tarima ta na lamefa begabuani nai, asi bekure-toḡaiani, diḡu na asi beḡoḡoi-tariani, senaḡi lamefa tore-torena gabuna korikorinai betoreani, beḡe raka-toḡani tarimari na mama beḡene ḡitaia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ḡoi matamu tu ḡoi tauḡanimu ḡena lamefa kavana. Bema ḡoi matamu namo nai, tauḡanimu mabarana bemamani. Senaḡi ḡoi matamu rakava nai, tauḡanimu mabarana bemukunani. ");
INSERT INTO snc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Moḡa lorinai, lorimu bono vetore, mama ḡoi nuḡamu ai bemukunani garina. ");
INSERT INTO snc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bema ḡoi tauḡanimu mabarana mama na bevonuvonu-raḡeni, mukuna kota maki asi betanuni, ḡia tu mama dikadika, lamefa emore-rovorovoni, ḡoi evaḡa-mamamuni kavana.” ");
INSERT INTO snc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu eguruḡa-ḡosito nai, Farisea tarimana ta na ekeaiato, ḡia ḡesi beḡene ḡaniḡani-vegogo; benamo ḡena numa ḡana eiaḡoto, ḡaniḡani gabunai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mo Farisea tarimana na eḡitaiato nai, nuḡana efarevaḡi-rakavato, korana Iesu tu asi eveḡuriḡito, (ḡia seneri vereri ḡeri vevaḡa-naḡi ilailanai), senaḡi eḡani-ḡanito moḡo. ");
INSERT INTO snc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Benamo Vereḡauka na evaḡa-guruḡaiato, ekirato, “Ḡomi Farisea tarimami na ḡemi kapusi ema disi muriri rekeri moḡo ḡoḡuriḡi-ginikaurini, senaḡi nuḡami tu verariverari ema vei-taḡuitaḡui na ḡevonu-fokafokato. ");
INSERT INTO snc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ḡomi tu babo! Ḡomi asi ḡoribani, murika rekena eveiato Barauna na nuḡana rekena maki ḡia na eveiato? ");
INSERT INTO snc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Senaḡi kapusi ema disi nuḡari dagarari tu asi ḡeri-ḡari tarimari boḡono viniri vau, dagara mabarari ḡemi ai beḡe veiarevani. ");
INSERT INTO snc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisea tarimami, vetuḡami kika! Korana ḡomi na Barau ḡovarevare-viniani dagarari misimisiri, ḡemi sivoḡa, kodukarava ema ḡaniḡani ḡailauri maki karava gabanana (10) ḡoveirini, karava sebona boubou dagaranai ḡovaḡa-iaḡoani, senaḡina vei-iobukaiobuka ema Barau uravinina maḡurina tu ḡoleaiani. Ḡomi na tu maiḡeri veiḡa baregori ḡoro veiri ema mo veiḡa keiri maki asi boḡoro iaḡuiri. ");
INSERT INTO snc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisea tarimami, vetuḡami kika! Korana ḡemi ura rubu ai tu tanutanu namori ai boḡono tanu, ema ḡemi ura maki maketi gaburi ai beḡene vaḡa-namomi. ");
INSERT INTO snc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vetuḡami kika! Ḡomi tu asi ḡita vetoḡari gara gaburi kavana, tarimarima iatari na ḡeraka-vanaḡini nai ḡemirorini, ḡia asi ḡeribani mo tu gabu rakavana.” ");
INSERT INTO snc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimana ta na Iesu evaḡa-guruḡaiato, ekirato, “Vevaḡa-riba taumu o, maiḡesi okirani nai, ḡai maki okira-fitoḡamani!” ");
INSERT INTO snc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu evaḡa-veseto, ekirato, “Ḡomi taravatu ḡovevaḡa-riba iaḡiani tarimami maki vetuḡami kika! Ḡomi na maruna metori tarimarima ḡovaḡa-faḡarini, senaḡi ḡimami didina ta maki ḡeri marunai asi ḡoveḡabikauni, asi ḡovaḡa-kavarini. ");
INSERT INTO snc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vetuḡami kika! Ḡomi tubumi ḡatami na peroveta tarimari ḡevaḡi-maserito, ema ḡomi na tu ḡeri gara gaburi namori ḡoveirini. ");
INSERT INTO snc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Moḡesi ḡomi tauḡemi tubumi ḡatami ḡeri veiḡa ḡokiraḡi-foforirini ema ḡovaḡa-moḡonirini; moḡoni veḡata, tubumi ḡatami na peroveta tarimari ḡevaḡi-maserito, ema ḡomi na ḡeri gara gaburi ḡoveirini. ");
INSERT INTO snc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Moḡa lorinai Barau ḡena Iaunega ekirani, ‘Au na peroveta tarimari ema apostolo tarimari batuḡu-iaḡorini ḡeri ai, benamo tari tu beḡe vaḡi-maserini, ma tari tu beḡe lai-lausilausirini.’ ");
INSERT INTO snc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Moḡesi nai, peroveta tarimari mabarari ḡevaḡi-maserito, Barau na tanobara eveiato veḡata beiaḡoma mo maitoma, metona tu toma ḡuru tarimari na beḡe ḡabiani. ");
INSERT INTO snc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela ḡevaḡi-maseato, monana eiaḡomato mo Sakaria, ḡia tu fata veaḡana ema Barau ḡena numa veaḡana fakari ai ḡevaḡi-maseato. Aba, au na akiramini, mabarari metori tu toma ḡuru tarimari na beḡe ḡabiani! ");
INSERT INTO snc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Taravatu ḡovevaḡa-riba iaḡiani tarimami, vetuḡami kika! Riba numana keo-fakana ḡatama-boka kina tu ḡomi na ḡoḡabiato. Ḡomi ḡereḡami asi boḡo raka-toḡani, ema ḡeraka-toḡa ḡetoni tarimari ḡeri dabara ḡomi na ḡokourini!” ");
INSERT INTO snc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu mo gabu na eraka-rosito, benamo taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ema Farisea tarimari na ḡekira-fitoḡaiato, ema dagara vovoka ḡevedanaḡi-viniato, ");
INSERT INTO snc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ḡeribaḡaniato, ḡeri ura tu dagara ta bene kiraḡi-kererea, be beḡene samania ḡana. ");
INSERT INTO snc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mo faka nuḡanai tarimarima ḡutuma lelevaḡi varau ḡevegogoto, asi-iaḡo asi-fana, benamo Iesu na ḡena mero evaḡa-guruḡa guinerito, ekirato, “Boḡono venari-ginikau Farisea tarimari ḡeri farao evaḡa-tubuani muramurana ḡerina, korana mani tu ḡia ḡeri ḡofaḡofa veiḡana bene. ");
INSERT INTO snc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vekouḡau dagarari mabarari beḡea foforini, vekuretoḡa guruḡari mabarari beḡea ribani. ");
INSERT INTO snc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Moḡa lorinai kara dagara mukunai ḡokiraḡiato, mamai beḡea seḡaḡiani, kara dagara koutoḡai seḡai ḡoguruḡa-ḡurato dagarana, beḡea kiraḡi-foforiani numa tuḡuna na, tarimarima mabarari na beḡene seḡaḡia ḡana.” ");
INSERT INTO snc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ḡatagu mabarami, akiramini, tauḡani beḡe vaḡiani, ma murinai kara ta ma asi beḡe veiani tarimari gariri asi boḡono vei. ");
INSERT INTO snc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Senaḡi navaḡa-ribami, deikara garina boḡono vei: Barau boḡono gari-vinia. Tauḡani bevaḡiani murinai ma ḡena seḡuka, ḡomi ma befiu-ḡuramini, karava eḡara-vanaḡi vanaḡini gabunai. Aba, au na akiramini, ḡia moḡo boḡono gari-vinia! ");
INSERT INTO snc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bisini imaima (5) maki fene ruarua na moḡo ḡevoirini, ene? Senaḡina Barau na tu sebona ta maki asi etuḡa-rekwaiani. ");
INSERT INTO snc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Moḡoni veḡatana, ḡomi tu debami ḡuiri maki mabarari Barau na eiavi-ginikaurito. Be asi boḡono gari; ḡomi voimi tu varaḡe lelevaḡi, bisini ḡutuma voiri maki ḡovanaḡirito!” ");
INSERT INTO snc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Au na akiramini, deikara na au tarimarima ḡoirari ai bekiraḡi-foforiguni, ḡia maki Tarimarima Natuna na Barau ḡena aneru ḡoirari ai bekiraḡi-foforiani. ");
INSERT INTO snc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Senaḡina au deikara na tarimarima ḡoirari ai beruḡaguni e bekira-ḡuniḡauguni, ḡia maki Barau ḡena aneru ḡoirari ai baruḡaiani e bakira-ḡuniḡauani. ");
INSERT INTO snc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tarimarima Natuna deikara na bekira-rakavaiani, Barau na ḡia ḡena rakava betuḡamaḡi-fitoḡaiani, senaḡina deikara na Iauka Veaḡa bekira-rakavaiani, ḡia ḡena rakava tu asi betuḡamaḡi-fitoḡaiani. ");
INSERT INTO snc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Iuda tarimari ḡeri rubu ai beḡe vaḡa-kotamini, ema vanuḡa vereri e Kota baregori ḡeseḡaḡini tarimari ḡoirari ḡana beḡe ḡori-iaḡomini nai, nuḡami asi beḡene vekwaraḡi, aiḡesi toma boḡo guruḡani o kara toma boḡo kiraḡirini. ");
INSERT INTO snc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Korana Iauka Veaḡa na mo ḡaro ai kara boḡo kiraḡirini guruḡari bevaḡa-ribamini.” ");
INSERT INTO snc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tarimarima ḡutuma nuḡana na tarima ta na Iesu ekiraiato, ekirato, “Vevaḡa-riba tarimamu o, au kakagu nokiraia, ḡai tamama na eraga-kwanerito farefareri nevareri, be au tavi ta nevinigu.” ");
INSERT INTO snc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu na evaḡa-veseato, ekirato, “Ḡoi tau o, au tu deikara na ḡomi taumi ruarua ḡemi farefare-tore viriḡi-viriḡina ḡana etoreguto?” ");
INSERT INTO snc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Benamo evaḡa-guruḡarito, ekirato, “Boḡono boḡeboḡe! Lorimi boḡono vetore, farefare vovoka mata-ḡaniḡaniri boḡo veini garina; korana tarimarima ḡeri maḡuri korikori tu dia ḡeri farefare vovoka na ḡevaḡa-ḡorarini.” ");
INSERT INTO snc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Benamo mai barabore ekiraḡiato, ekirato, “Farefare vovoka tarimana ta ḡena tano na ḡaniḡani namori evaḡa-ḡorarito. ");
INSERT INTO snc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ḡia etuḡa-maḡito, ekirato, ‘Kamasi toma baveini? Mai ḡaniḡani mabarari tu ainai bana vaḡa-vegogori?’ ");
INSERT INTO snc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Benamo ekirato, ‘Au tu maiḡesi navei. Ḡaniḡani atorerini numari guineri narovori, benamo numa baregori naragari. Mainai vau au ḡegu ḡaniḡani e farefare mabarari monai bana vaḡa-vegogori. ");
INSERT INTO snc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Benamo au tauḡegu bana vekira, ‘Ḡoi ḡemu dagara namori tu ḡutuma gorogoro bovaḡa-vegogori laḡani vovoka ḡana. Be, noiaḡaraḡi, noḡaniḡani, noniuniu e noverere.’ ");
INSERT INTO snc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Senaḡina Barau na ekiraiato, ekirato, ‘Kamuto, ḡoi tu babo! Toma boḡi ḡoi ḡemu maḡuri aḡabi-vaḡiani ḡemuna, benamo mai ḡemu farefare bovaḡa-vegogorini tu deikara na beḡabirini?’ ");
INSERT INTO snc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maiḡesina mo deidei tauḡeri moḡo ḡeri farefare ḡevaḡa-vegogoni tarimari tu asi ḡeri farefare Barau ḡoiranai.” ");
INSERT INTO snc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Benamo Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Moḡa lorinai, akiramini, ḡemi maḡuri asi boḡono tuḡamaḡiri, kara boḡo ḡanini; o tauḡanimi kara na boḡo dabuḡarini. ");
INSERT INTO snc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maḡuri tu dagara baregona, a ḡaniḡani tu dagara keina, ema tauḡani tu dagara baregona, a dabuḡa tu dagara keina. ");
INSERT INTO snc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gaio ḡotuḡamaḡiri, asi ḡevarovaroni ema asi ḡekwa-kwani; asi ḡeri ḡaniḡani-tore numari, senaḡina Barau na eḡuburini! Ḡomi tu dagara baregomi, a manu tu kei! ");
INSERT INTO snc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ḡomi deikara otuḡamaḡi-vekwaraḡini nai, ḡemu maḡuri kota maia bovaḡa-maukaiani? ");
INSERT INTO snc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mai dagara misina asi boveiani riba, karase nai tu dagara tari maia urari ai ovetuḡamaḡini? ");
INSERT INTO snc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Boḡa veraverari ḡoḡitari aiḡesi ḡegarani. Asi ḡeḡauveini ema dabuḡa asi ḡeturini. Senaḡina akiramini, Kini Solomona ḡena vedabuḡa marevana maki ḡevanaḡiani. ");
INSERT INTO snc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bema Barau na tanobara ḡauḡari moḡesi edabuḡarini, ḡia toma tu ḡegarani, ma boinani tu karavai beḡe fiu-raḡerini, Barau na ḡomi tu bevaḡa-dabuḡa ginikau-raḡemini. Ḡomi veḡabidadama misimisi tarimami! ");
INSERT INTO snc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Moḡa lorinai asi boḡono boḡe vetau-vetau, kara toma ḡoḡanini e kara toma ḡoniuni; ema asi boḡono tuḡamaḡi-vekwaraḡi maki. ");
INSERT INTO snc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Korana Barau asi ribari tarimari mabarari tu maniḡeri dagara ḡevetaurini, a ḡomi Tamami tu ma ribana maniḡeri dagara tu ḡoura-vinirini. ");
INSERT INTO snc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Senaḡina Barau ḡena Basileia boḡono vetaua, benamo maniḡeri dagara mabarari bevinimini.” ");
INSERT INTO snc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Seri misina, asi boḡono gari, korana Tamami ḡena ura tu ma nuḡa namona ḡesi ḡena Basileia bene vinimi. ");
INSERT INTO snc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ḡemi farefare ḡovoivoi-iaḡiri, ma moni asi-ḡeri e asi-ḡari tarimari ḡoviniri. Asi beḡe rakavani moni fusefuseri ḡoḡabiri, ḡemi farefare gubai ḡovaḡa-vegogori, monai tu asi beḡe korini, monai lema tarimari asi beḡe raka-kavini ema faro na maki asi beḡe vaḡa-rakavarini. ");
INSERT INTO snc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Korana tu ḡomi ḡemi farefare ainai, ḡomi nuḡami maki monai.” ");
INSERT INTO snc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ḡauvei ḡana boḡono vedabuḡa-tore ema ḡemi lamefa beḡene ḡara-taḡo. ");
INSERT INTO snc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Vetuḡunaḡi tarimari na ḡeri vere numai ḡenari-taḡoani kavana boḡono tanu. Vevaḡa-veḡaraḡo verekona na ma beḡenoḡoini, ḡatama-bokai befidifidini nai, ḡena ḡatama beḡene raga-keoa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vetuḡunaḡi tarimari roḡo tataḡa ḡeri vere beḡenoḡoini tu namo. Moḡoni akiramini, ḡena rami beriḡoani, ḡaniḡani gabunai bevaḡa-tanurini, benamo ḡaniḡani bevinirini. ");
INSERT INTO snc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mo vetuḡunaḡi tarimari roḡo naritaḡo ḡeri vere beḡenoḡoini tu namo, kamasi boḡi nuḡanai o boḡiboḡi rekenai beiaḡomani. ");
INSERT INTO snc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Senaḡi boḡono riba, bema numa tarimana ma ribana, kamara horai lema tarimana beiaḡomani tu, numa benariani, be lema tarimana maki lema bevedaureani. ");
INSERT INTO snc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Moḡa lorinai ḡomi maki boḡono venari-taḡo, korana Tarimarima Natuna tu asi ḡotuḡamaḡiani aoanai beiaḡomani.” ");
INSERT INTO snc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Benamo Petero na edanaḡiato, ekirato, “Vereḡauka, mai barabore tu ḡai ḡemai moḡo okiraḡiani, ba tarimarima mabarari ḡeri ai maki?” ");
INSERT INTO snc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Vereḡauka evaḡa-veseto, ekirato, “Deikara tu mo farefare nari tarimari na guruḡa eseḡaḡini ema veiḡa roroḡotori eveini, ḡena vere na eḡabi-viriḡiato, numa ema vetuḡunaḡi tarimari bene ḡitaḡauri, ema ḡaniḡani maki nega korikori ai bene viniri? ");
INSERT INTO snc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mo vetuḡunaḡi tarimana, ḡena vere na ekiraiato ilailanai eḡauveini, bema-ḡoitaḡoani tu namo. ");
INSERT INTO snc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Moḡoni akiramini, ḡia tu ḡena vere ḡena farefare mabarari ḡitaḡauri tarimanai bevaḡa-iaḡoani. ");
INSERT INTO snc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Senaḡina bema vetuḡunaḡi tarimana bekirani, ‘Au ḡegu vere ḡena ḡenoḡoi tu bekwaibo rakava,’ benamo vetuḡunaḡi tauri ema vavineri bekwaririni, ma beḡanini e beniu-babobaboni. ");
INSERT INTO snc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Vetuḡunaḡi tarimana ḡena vere ḡena ḡenoḡoi ḡarona tu asi etuḡamaḡiani ḡaronai, ma asi eribaiani aoanai beraḡasini. Ḡena vere na bea basi-ḡutuḡutuani, ma asi ḡevaḡa-moḡonini tarimari ḡesi bea toreani. ");
INSERT INTO snc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mo vetuḡunaḡi tarimana ḡena vere ḡena ura tu ma ribana, senaḡi asi eḡabi-kavini ema ḡena vere ḡena ura asi eveiani tu, ribi baregona korikori beḡabiani. ");
INSERT INTO snc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A vetuḡunaḡi tarimana asi ribana ḡena vere ḡena ura, ma bea ḡauvei-kavani, voina tu ribi, senaḡi asi vovoka beḡabini. Ḡutumari eviniato tarimana ḡenana tu ḡutumari ma beura-viniani; vovoka lelevaḡiri eviniato tarimana ḡenana tu vovoka lelevaḡiri ma bevetau-viniani.” ");
INSERT INTO snc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Au tu karava aḡabi-iaḡomaiato tanobara ḡana, ema ḡegu ura bere ḡarakau guine tu namo! ");
INSERT INTO snc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Senaḡi au tu babatiso ta baḡabiani, ema au tu anuḡa-vekwaraḡini, beiaḡoni mo, bavaḡa-koriani! ");
INSERT INTO snc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ḡomi ḡotuḡamaḡini, au tu maino tanobara ḡana aḡabi-iaḡomaiato? Asiḡi, senaḡi akiramini, vetavi-kirakira urana na aiaḡomato. ");
INSERT INTO snc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Toma beiaḡoni mo ḡoira laḡaniri ai, bese tai imaima tu beḡe vetavi-kirani, toitoi beḡe veḡitani ruarua ḡerina, ema ruarua beḡe veḡitani toitoi ḡerina. ");
INSERT INTO snc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tamana natuna tauna ḡenana beveḡitani, natuna tauna tamana ḡenana beveḡitani; sinana natuna vavinena ḡenana beveḡitani, ma natuna vavinena sinana ḡenana beveḡitani; taḡama vavine barana taḡama vavine keina ḡenana beveḡitani, ma taḡama vavine keina taḡama vavine barana ḡenana beveḡitani.” ");
INSERT INTO snc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu na tarimarima ḡutuma evaḡa-guruḡarito, ekirato, “Bema ḡaro eketoni rekenai magube dubadubari ḡeraḡekauni ḡoḡitarini nai tu, ḡokirani, ‘Ḡura beraguni,’ benamo eraguni. ");
INSERT INTO snc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma gabina rekena (o south) na iavara eiaḡomani nai ḡokirani, ‘Ḡaro beseḡukani,’ benamo ḡaro eseḡukani. ");
INSERT INTO snc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ḡofaḡofa tarimami! Tanobara e guba vetoḡari kiraḡi-kiraḡiri tu ma ribami; kamasi nai mai toma ḡaro vetoḡana tu asi ribami? ");
INSERT INTO snc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Karase nai tauḡemi na asi ḡotuḡamaḡi-fakaiani kara tu maoro? ");
INSERT INTO snc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Esamanimuto tarimana ḡesi roḡo ḡoiaḡoni Kota ḡana nuḡanai boḡono maino. Bema asiḡina nai, Kota eseḡaḡini tarimana ḡimanai bea tore-kaumuni, ma Kota eseḡaḡini tarimana na folisi ḡimanai bea tore-kaumuni, benamo folisi na dibura numanai bea fiu-toḡamuni. ");
INSERT INTO snc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Akiramuni, asi boraka-vaḡini, beiaḡoni mo, moni mabarana boa vaḡa-voi-ḡosiani.” ");
INSERT INTO snc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mo negai tarima kota Iesu ḡenai ḡeiaḡoto, benamo Iesu ḡekira-varaiato, Galilea tarimari Pilato na evaḡirito, ḡeri ginitaḡo dagarari Barau ḡeviniato-ḡoi nuḡanai; ḡia rarari tu ginitaḡo dagarari rarari ḡesi ebubu-sebonarito. ");
INSERT INTO snc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡotuḡa-maḡini, mo Galilea tarimari moḡesi ḡevaḡirito-ḡoi nai, monana ḡevaḡa-moḡoniato, ḡeri rakava tu Galilea tarimari mabarari ḡeri rakava evanaḡirito? ");
INSERT INTO snc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Asiḡina! Au na akiramini, bema ḡemi rakava ḡerina asi boḡo vetuḡamaḡi-kureni, ḡomi mabarami moḡesi boḡo maseni ḡia ḡemaseto kavana. ");
INSERT INTO snc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A mo tarima gabanana imaima toitoi (18) Siloam kounai numa baregona eketoto ḡia iatari ai nai, evaḡirito tu kamasi? Ḡomi ḡotuḡamaḡini, mo tarima ḡeri rakava tu Ierusalema tarimari mabarari ḡeri rakava evanaḡirito? ");
INSERT INTO snc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Asiḡina! Au na akiramini, bema ḡemi rakava ḡerina asi boḡo vetuḡamaḡi-kureni, ḡomi mabarami maki boḡo maseni ḡia ḡemaseto kavana.” ");
INSERT INTO snc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu na mai barabore ekira-vararito, ekirato, “Tarima ta ḡena vine tavoḡana nuḡanai figi ḡauna evaroato. Benamo eiaḡoto, figi ḡauna ḡwaḡwana ea vetauato, senaḡina ḡwana ta asi edoḡariato. ");
INSERT INTO snc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Moḡa lorinai ḡena vamoka narinarina tarimana evaḡa-guruḡaiato, ekirato, ‘Noḡitaia, laḡani toitoi beḡe iaḡo, au mai ḡau ḡitaḡitana aiaḡomani, senaḡina ḡwana ta asi adoḡariani. Nobasi-laua, korana asi tauna bene! Mai tano eḡauvei-iaḡi-taḡuiani.’ ");
INSERT INTO snc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Senaḡi vamoka ḡitaḡauna tarimana evaḡa-veseto, ekirato, ‘Vereḡauka, noraga-kwanea, mai laḡani sebona moḡo bene tanu. Au na bakwa-ḡeḡeraḡiani ema tano namori ma babubuni. ");
INSERT INTO snc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Benamo ḡwaḡwana namori beḡe burini laḡani ḡoirai tu namo, bema asiḡi nai, vau bono basia.’” ");
INSERT INTO snc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabadi tai Iesu tu evaḡa-ribatoḡoi rubu ta nuḡanai. ");
INSERT INTO snc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vavine ta monai iauka rakavana na eboroḡiato, evei-kevekeveato laḡani gabanana imaima toitoi (18). Ḡia doḡena eḡeḡevato, asi eruḡa-vaisito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu na eḡitaiato, benamo ekea-iaḡomaiato, ekiraiato, “Vavine o, ḡoi tu mani keve manina na varau bofaka.” ");
INSERT INTO snc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Benamo Iesu ḡimana mo vavine iatanai eveḡabikauto nai, vaḡa-sebo moḡo doḡena eroroḡototo, Barau evaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Rubu ḡitaḡauna tarimana ebaruto, korana Iesu na Sabadi ai evevaḡa-namoto nai. Moḡa lorinai ḡia na tarimarima evaḡa-guruḡarito, ekirato, “Ḡaro imaima sebona tarimarima ḡeri ḡauvei ḡarori. Mo ḡaro ai vevaḡa-namo uranai boḡono iaḡoma, senaḡi Sabadi ai asi boḡono iaḡoma.” ");
INSERT INTO snc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vereḡauka na evaḡa-veseato, ekirato, “Ḡofaḡofa tarimami! Sabadi ai ḡemi boromakau o doniki asi ḡoruḡarini, ḡeri numa na asi ḡoḡori-rosirini nanu niu? ");
INSERT INTO snc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A mai vavine, Aberahamo besena vavinena, Satani na laḡani gabanana imaima toitoi (18) ebarubaruato, au na Sabadi ai barubaru ḡenana asi baruḡaiani ba?” ");
INSERT INTO snc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Moḡesi ekirato nai, ḡebaru-viniato-ḡoi tarimari ḡemaiakarito, senaḡi tarimarima mabarari na Iesu ḡena veiḡa boruri ḡeḡitarito nai, ḡeiaku-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Benamo Iesu na edanaḡirito, ekirato, “Barau ḡena Basileia tu aiḡesi? Kara ḡenai bavaḡa-ilailaiani? ");
INSERT INTO snc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ḡia tu mastadi ḡauna ḡutuna kavana. Tarima ta na eḡabiato, ḡena vamokai evaroato. Mastadi ḡauna ḡutuna egarato, ḡau ai eiaḡoto, benamo guba manuri leganai ḡesikokauto.” ");
INSERT INTO snc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu na ma edanaḡirito, ekirato, “Barau ḡena Basileia tu kara ḡesi bavaḡa-ilailaiani? ");
INSERT INTO snc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ḡia tu maiḡesi, vavine ta na farao evaḡa-tubuani muramurana kotuna ta moḡo eḡabiato, benamo farao fuseri toitoi ḡesi egiroato, eiaḡoto mo, muramura na mabarana evaḡa-tubu baregoato.” ");
INSERT INTO snc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu Ierusalema dabaranai eiaḡoto-ḡoi nai, vanuḡa baregori ema keiri nuḡari ai evevaḡa-ribato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tarima ta na edanaḡiato, ekirato, “Vereḡauka, tarima viravira moḡo beḡe maḡurini ba?” Iesu na evaḡa-veserito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Boḡono vebibi-toḡa, ḡatama-boka kibobona boḡono raka-toḡa ḡana, korana au na akiramini, tarimarima ḡutuma ḡeraka-toḡa ḡetoni, senaḡi asi beḡe raka-toḡani. ");
INSERT INTO snc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Numa tarimana bevariḡisini, ḡatama-boka bekouani murinai, ḡomi tu murikai boḡo ruḡa-taḡoni, ḡatama-bokai boḡo fidifidini, boḡo kirani, ‘Vereḡauka, ḡai ḡema ḡatama-boka nokeoa!’ senaḡi ḡia bekirani, ‘Au asi ribagu ḡomi ainana boḡo iaḡoma!’ ");
INSERT INTO snc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Benamo ḡomi boḡo kirani, ‘Ḡai tu ḡoi ḡesi taḡaniḡanito-ḡoi ema taniuniu-vegogoto-ḡoi; ema ḡoi tu ḡai ḡema vanuḡa ḡatamanai ovevaḡa-ribato-ḡoi!’ ");
INSERT INTO snc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Senaḡina ḡia ma bekirani, ‘Au asi ribagu ḡomi ainana ḡoiaḡomani. Au ḡeguna ḡoraka-veḡita vei-rakava tarimami!’ ");
INSERT INTO snc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Benamo Aberahamo, Isako, Iakobo, ema peroveta tarimari mabarari boḡo ḡitarini Barau ḡena Basileia nuḡanai, senaḡi ḡomi tu murikai beḡe dori-rosimini; mo ḡaro ai boḡo taḡini, gadikami beḡe veḡara-tarini. ");
INSERT INTO snc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tarimarima ḡaro eraḡekauni ema ḡaro evariḡoni, e debana (o north) ema gabina (o south) rekena na beḡe iaḡomani, beḡe tanu-tarini vereko ai Barau ḡena Basileia nuḡanai. ");
INSERT INTO snc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Boḡono riba, toma ḡegabini tarimari tu beḡe guineni, a ḡeguineni tarimari tu beḡe gabini.” ");
INSERT INTO snc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mo negai Farisea tarimari kota Iesu ḡenai ḡeiaḡoto, ḡevaḡa-guruḡaiato, ḡekirato, “Mai gabu noraga-kwanea, gabu ta ḡana noiaḡo, korana Heroda eurani ḡoi bene vaḡimu etoni.” ");
INSERT INTO snc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu evaḡa-veseto, ekirato, “Ḡoiaḡo, mo boḡa kwaivana ḡoa kiraia, ‘Au tu iauka rakavari alai-vaḡirini ema tarimarima avaḡa-namorini toma, boinani, ema ḡaro vaḡa-toitoinai ḡegu ḡauvei bavaḡa-kori ginikauani.’ ");
INSERT INTO snc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Senaḡi toma, boinani, ilaḡani ḡegu iaḡoiaḡo ai roḡo baiaḡoni, korana peroveta tarimana tu irau gabu ai asi bemaseni, senaḡi Ierusalemai moḡo! ");
INSERT INTO snc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ierusalema, Ierusalema o, ḡoi na peroveta tarimari ovaḡirini ema Barau na etuḡu-iaḡosirini tarimari fore na otaki-maserini. Nega ḡutuma aurato, natumi bana gana-ḡeḡeraḡiri, kokoroku vavinena na natuna egoru-taririni kavana, senaḡi ḡomi tu asi ḡourato! ");
INSERT INTO snc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Moḡa lorinai ḡemi vanuḡa e Rubu Veaḡa korina betanuni. Au na akiramini, ḡomi roḡo au asi boḡo ḡitaguni, beiaḡoni mo, ḡaro ta beraḡasini, monai vau boḡo kirani, ‘Barau aranai eiaḡomani tauna sivaḡa-namoa.’” ");
INSERT INTO snc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabadi tai Iesu (ḡekeaiato nai) eiaḡoto, Farisea ḡeri veḡorikau tarimana ta ḡena numai beḡene ḡaniḡani ḡana, benamo tarimarima na ḡena veiḡa ḡeḡita-ginikaurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Monai tarima ta ḡia tauḡanina eroro-roroto, Iesu ḡoiranai etanu-taḡoto. ");
INSERT INTO snc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Benamo Iesu na taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari e Farisea tarimari edanaḡirito, ekirato, “Sabadi ai keve vaḡa-namo tu maoro ba asiḡina?” ");
INSERT INTO snc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Senaḡi ḡia asi ḡeguruḡato, ta na maki asi evaḡa-veseato. Benamo Iesu na mo keve tarimana eḡabiato, evaḡa-namoato murinai etuḡuato. ");
INSERT INTO snc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Benamo ekirarito, ekirato, “Ḡomi deikara natumu o ḡemu boromakau nanu gurina nuḡanai bere keto-ḡura nai, ḡoi na Sabadi ai boro inu-raḡea ba asiḡina?” ");
INSERT INTO snc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Senaḡi ḡia na Iesu asi ḡevaḡa-veseato. ");
INSERT INTO snc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu na varivari tarimari eḡitarito, tanutanu namori moḡo ḡeḡaunarito, benamo ḡeri barabore ta ekiraḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bema tarima ta na bekeamuni, veḡaraḡo verekona raka-vegogonai, gabu namonai asi bono tanu-tari, korana irau vereko ḡorikauna tauna na tarima barana ta bekeaiani ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Benamo ekeamito tarimana beiaḡomani, bekiramuni, ‘Noveḡita, mai vere ḡena tanutanu novaḡa-fakaia.’ Ḡoi tu bemaiakamuni, benamo botanu-riḡoni. ");
INSERT INTO snc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bema ḡoi ḡekeamuni nai, tanutanu tanonai bono tanu. Benamo vereko ḡorikauna tarimana beiaḡomani nai, bekirani, ‘Ḡata, tuḡuna ḡana novaraḡe.’ Benamo ḡoi tu beḡe vaḡa-raḡemuni vereko tarimari mabarari na. ");
INSERT INTO snc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Korana tu tauḡena eveḡabi-vaisini tarimana tu, Barau na betore-riḡoani, a tauḡena evetore-riḡoni tarimana tu, beḡabi-vaisiani.” ");
INSERT INTO snc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu na vereko ḡorikauna tarimana ekiraiato, ekirato, “Bema ḡoi ḡaniḡani o vereko ta bodabaraiani nai, ḡatamu, tarikakamu, garagaramu o sevimu ai ḡetanuni taḡa tarimari asi bono keari, korana ḡia na ḡoi ma beḡe keamuni, ḡoina keakau beḡe vaḡa-voiani. ");
INSERT INTO snc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Senaḡi bema vereko ta bodabaraiani nai, gara veḡubu, tauḡaniri rakava, kwaku rakava, mata-bubu tarimari bono keari, ");
INSERT INTO snc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","benamo ḡoi tu Barau ḡena vevaḡa-namo boḡoitaḡoani. Moḡoni, ḡia na asi beḡe vaḡa-voimuni, senaḡi veiḡa iobuka-iobuka tarimari mase na ma beḡe variḡisi-ḡenoḡoini ḡaronai vau, voimu boa ḡoitaḡoani.” ");
INSERT INTO snc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesu ḡesi ḡeḡaniḡani-vegogoto tarimana ta na mo guruḡa eseḡaḡiato nai, ekiraiato, ekirato, “Barau ḡena Basileiai vereko bea ḡaniani tarimana tu beiakuni.” ");
INSERT INTO snc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu na evaḡa-veseato, ekirato, “Tarima ta na vereko barana ta edabaraiato, benamo tarimarima ḡutuma ekearito. ");
INSERT INTO snc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ḡani-vereko ḡaronai ḡena vetuḡunaḡi tarimana ta etuḡuato, ekearito tarimari nea kirari, ‘Ḡoiaḡoma, dagara mabarari beḡe rovina-toreri.’ ");
INSERT INTO snc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Senaḡi ḡia mabarari ḡekira-sirivaḡito. Ta ekirato, ‘Au tu tano ta bavoia, be aurani bana ḡitaia nai, asi bono baru.’ ");
INSERT INTO snc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta ma ekirato, ‘Au tu boromakau gabanana (10) bavoiri nai, aiaḡoni fokafokai atovo-naḡirini, be asi bono baru.’ ");
INSERT INTO snc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta ma ekirato, ‘Au tu inivau mo baveḡaraḡo nai, asi baiaḡosini.’ ");
INSERT INTO snc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Vetuḡunaḡi tarimana eḡenoḡoito, ḡena vere ekira-varaiato. Benamo numa tarimana ma baruna ḡesi ḡena vetuḡunaḡi tarimana ekiraiato, ekirato, ‘Noraga-iaḡo vanuḡai, gara veḡubu, tauḡaniri rakava, mata-bubu ema kwaku rakava tarimari bono ḡori-iaḡomari.’ ");
INSERT INTO snc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Benamo vetuḡunaḡi tarimana eḡenoḡoito, ekirato, ‘Vere o, mani ḡemu ura ḡauveina tu varau baveia, senaḡi numa roḡosi bene vonu.’ ");
INSERT INTO snc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Benamo vere na vetuḡunaḡi tarimana ma ekiraiato, ekirato, ‘Noiaḡo dabara barai ema vamoka dabarari ai, tarimarima bono kirari, beḡene iaḡoma, be auna numa benema vonu. ");
INSERT INTO snc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Au na akiramini, akearito tarimari ta na ḡegu vereko ḡaniḡanina misina ta asi bevaḡa-mamiani.’” ");
INSERT INTO snc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tarimarima ḡutuma-bara Iesu ḡesi ḡeiaḡoto-ḡoi, benamo eruḡa-kureto, ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bema tarima ta eurani, au ḡegu ai bene iaḡoma etoni, senaḡi ḡia tamana ema sinana, ḡaraḡona ema natuna, kakana tarina ema tauḡena ḡena maḡuri maki veuraviniri asi betuḡamaḡi-fitoḡaiani nai, ḡia tu dia au ḡegu mero. ");
INSERT INTO snc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Deikara tauḡena ḡena satauro asi beḡwaiani, benamo au murigu na asi berakani, ḡia tu dia au ḡegu mero. ");
INSERT INTO snc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bema ḡomi ta eurani numa ta bene ragaia etoni nai, betanu-tari guineni, numa voina beribaiani, moni beilailani ba asiḡina, ene? ");
INSERT INTO snc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Irau ḡauvei besinaiani, benamo asi bevaḡa-koriani, mabarari na beḡe ḡitaiani tarimari na beḡe rikiriki-iaḡiani, ");
INSERT INTO snc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","beḡe kirani, ‘Mai tarima na esinaiato, senaḡi asi evaḡa-koriato.’ ");
INSERT INTO snc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O kamara vanuḡa verena, irau vanuḡa verena ta bene vetari-vinia etoni, benamo asi betanu-tari guineni, sisiba asi bevetauni, ḡena vetari tarimari mabarari 10,000, ema reke ta vere ḡena 20,000, ḡia ḡeiaḡoma-viniani nai, bevaḡa-darereani ba? ");
INSERT INTO snc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bema ḡia asi ilaila nai, ḡia aranai ḡena tarima tari betuḡu-iaḡorini, mo doḡoro barana roḡo fakari manaḡa nuḡanai, maino beḡene ḡabia dabarana beḡea veiani. ");
INSERT INTO snc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Moḡa ilailanai deikara ḡena dagara mabarari asi beiaḡuirini tu asi au ḡegu mero.” ");
INSERT INTO snc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Damena tu namo, senaḡi bema damena mamina berekwa-rekwani nai, kamara dabarai mamina ma beḡenoḡoini? ");
INSERT INTO snc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ḡia tu asi ilaila tano vaḡa-namona ema asi namo varovaro dagarari ḡesi vaḡa-garari ḡana; moḡa lorinai tarima na beḡe fitoḡaiani. Ma seḡana tarimana bene seḡaḡi!” ");
INSERT INTO snc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takesi gogo tarimari ema vei-rakava tarimari ḡutuma Iesu ḡenai ḡeiaḡoto, ḡena guruḡa beḡene seḡaḡiri ḡana. ");
INSERT INTO snc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisea tarimari ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ḡemugumuguto, ḡekirato, “Mai tarima tu rakava tarimari eḡabi-raḡerini ema ḡia ḡesi ḡeḡaniḡani-vegogoni!” ");
INSERT INTO snc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Benamo Iesu na mai barabore ḡeri ekiraḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bema ḡomi ta ma ḡena mamoe sinau ta (100), benamo sebona berekwa-rekwani nai, ḡia tu kara beveini? Ḡia na 99 tano fakanai beraga-kwanerini, edobito mamoena bevetauani mo beḡoitaḡoani. ");
INSERT INTO snc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bedoḡariani nai, ḡabanai befaḡa-gabagabaiani ma iakuna ḡesi, ");
INSERT INTO snc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","benamo numa ḡana beiaḡoni. Beraḡasini nai, ḡatana e sevina tarimari bekearini, bekirani, ‘Sima iaku-vegogo, korana ḡegu mamoe, edobito dagarana, ma badoḡaria.’ ");
INSERT INTO snc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Au na akiramini, moḡa ilailanai rakava tarimana ta ḡena rakava ḡerina evetuḡamaḡi-kureni nai, gubai iaku ema verere tu barego lelevaḡi, a vei-iobukaiobuka tarimari 99 ḡeri vei-iobukaiobuka dairi ai asi beḡe vetuḡamaḡi-kureni maki bevanaḡirini.” ");
INSERT INTO snc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Bema vavine ta ḡena silva moniri mabarana gabanana (10), benamo sebona bevei-rekwa-rekwani nai, ḡia tu kara beveini? Ḡia na lamefa begabuani, numa bedaroani, mo moni sebona bevetau-ḡitakauani mo bea ḡoitaḡoani. ");
INSERT INTO snc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bedoḡariani nai, ḡia na ḡatana e sevina tarimari bekearini, bekirani, ‘Sima iaku-vegogo, korana tu ḡegu silva monina, erekwa-rekwato dagarana, varau badoḡaria.’ ");
INSERT INTO snc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Au na akiramini, rakava tarimana ta ḡena rakava ḡerina evetuḡamaḡi-kureni nai, Barau ḡena aneru moḡesi beḡe iakuni.” ");
INSERT INTO snc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu ma ekirato, “Tarima ta natuna ruarua. ");
INSERT INTO snc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tau muriseina na tamana ekiraiato, ekirato, ‘Tama, ḡitana farefare novareri, be au debagu farefareri tu novinigu.’ Benamo farefare mabarari natuna ruarua fakari ai evarerito. ");
INSERT INTO snc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ḡaro asi vovoka ḡeiaḡoto nuḡanai, tau muriseina ḡena farefare evaḡa-vegogoto, benamo tano manaḡa ḡana erakato. Monai ḡena farefare ea ḡere-iaḡirito. ");
INSERT INTO snc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ḡena farefare mabarari evaḡa-koririto murinai, mo tano ai doḡe barego eḡorato. Ḡia varau asi-ḡena, asi-ḡana. ");
INSERT INTO snc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Benamo eiaḡoto, mo tanobara tarimana ta ḡenai ḡauvei ea vetauto, benamo ḡia na etuḡuato ḡena tano ai bai bene ḡitaḡauri ḡana. ");
INSERT INTO snc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ḡia evito-rakavaiato nai, bai ḡari ḡaniḡani bene ḡaniri etato, senaḡi mo ḡaniḡani maki ta na asi eviniato. ");
INSERT INTO snc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Benamo ea vetuḡamaḡi-kureto, ekirato, ‘Tamagu ḡena ḡauvei tarimari tu vovoka, ema ḡari ḡaniḡani maki ḡutuma, senaḡi au tu mainai vitona evaḡiguni. ");
INSERT INTO snc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Naḡenoḡoi, tamagu ḡenai naiaḡo, benamo bana kiraia: Tama, Barau ḡoiranai ema ḡoi ḡoiramu ai avei-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au tu asi ilaila ḡoi natumu ai ma bono kiraḡigu; senaḡi anoḡimuni, ḡemu vetuḡunaḡi tarimanai bono vaḡa-iaḡogu, banasi.’ ");
INSERT INTO snc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Benamo evariḡisito, tamana ḡenai eiaḡoto. Gabu manaḡa na roḡo eiaḡomato-ḡoi nai, tamana na varau eḡita-doḡariato, benamo evetuḡa-rakavaiato, benamo eraga-iaḡoto, ea faḡa-maḡuriato, everauato. ");
INSERT INTO snc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Benamo natuna na ekiraiato, ekirato, ‘Tama, au tu Barau ḡoiranai ema ḡoi ḡoiramu ai ma ḡegu vei-rakava. Au tu asi ilaila ḡoi natumu ai bono kiraḡigu.’ ");
INSERT INTO snc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Senaḡi tamana na ḡena vetuḡunaḡi tarimari evaḡa-guruḡarito, ekirato, ‘Ḡoraga-vei! Dabuḡa namo vedaureana ta ḡoḡwa-iaḡomaia, ḡoma vaḡa-riḡoa. Rini ta didinai ḡoma dori-toḡaia, ema tamaka maki kwakunai ḡoma toreri. ");
INSERT INTO snc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ema boromakau natuna ma monana ḡoḡwa-iaḡomaia, ḡovaḡia, benamo bisini ḡania e bisini verere-vegogo. ");
INSERT INTO snc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Korana natugu maiḡa emaseto, senaḡi ma bemaḡuri-ḡenoḡoi; erekwa-rekwato, senaḡi ma bama doḡaria!’ Benamo ḡia ḡeverere-vegogoto. ");
INSERT INTO snc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Natuna tau guinena tu vamokai. Vamoka na eḡenoḡoito, numa eiaḡo-viniato-ḡoi nai, mari e bara gururi eseḡaḡirito. ");
INSERT INTO snc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Benamo vetuḡunaḡi tarimana ta ekeaiato, mo guru korana evedanaḡi-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Vetuḡunaḡi tarimana na evaḡa-veseato, ekirato, ‘Ḡoi tarimu beḡenoḡoi, tamamu na ma namona e ma maḡurina ḡesi bema doḡaria lorinai, ḡia na vetuḡunaḡi tarimari bevaḡa-guruḡari, boromakau natuna ma monana ḡesi beḡe vaḡia.’ ");
INSERT INTO snc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tau guinena ebaru-rakavato, numai asi eraka-toḡato, benamo tamana eraka-rosito, enoḡiato neraka-toḡa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Senaḡi ḡia na tamana evaḡa-veseato, ekirato, ‘Noḡitaia, au tu laḡani ḡutuma ḡoi rekemu ai atanuni, vetuḡunaḡimu aiaḡo-vinini, ḡemu ura mabarana akorana-iaḡirini, ḡemu vevaḡa-naḡi ta asi afitoḡaiato, senaḡi ḡoi na nanigosi natuna ta maki asi oviniguni au ma ḡatagu ḡesi vaḡa-iaku-iaḡima ḡana. ");
INSERT INTO snc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A mai natumu mata-boraḡa vavineri ḡeri ai ḡemu farefare mabarari bea vaḡa-koriri; bea ḡenoḡoi nai tu, ḡoi na tu boromakau natuna mona mase bovaḡia ḡia ḡana!’ ");
INSERT INTO snc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamana evaḡa-veseto, ekirato, ‘Natugu, ḡoi tu au sevigu ai otanu-vanaḡi vanaḡini, au ḡegu dagara mabarari tu ḡoi ḡemu. ");
INSERT INTO snc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A toma ḡita si-iaku, bisini verere, korana tarimu emaseto, senaḡi bemaḡuri; erekwa-rekwato, senaḡi ma bitama doḡaria.’” ");
INSERT INTO snc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Farefare e moni vovoka tarimana ta etanuto-ḡoi. Benamo tarima kotari na farefare vovoka tarimana ḡekira-varaiato, ḡia ḡena farefare ḡitaḡauna tarimana na ḡena farefare eḡere-iaḡirini. ");
INSERT INTO snc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Moḡa lorinai taḡa tarimana na ekea-toḡaiato, benamo ekirato, ‘Ḡoi varimu baseḡaḡia moḡoni ba? Au ḡegu ḡauvei oḡwa-ragaiato nai, novevarifiu-iaḡia, korana initoma ḡoi tu dia au ḡegu farefare narinarina tarimana.’ ");
INSERT INTO snc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Benamo mo farefare ḡitaḡauna tarimana etuḡamaḡito, ekirato, ‘Au ḡegu baregona na toma evaḡa-dokoguni ḡegu ḡauvei na. Kara baveini? Au tu asi gwadagu baiaraḡani ema noḡinoḡi au ḡegu ai tu maiaka dagarana.’ ");
INSERT INTO snc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Etuḡamaḡito-ḡoi nuḡanai, ekirato, ‘Mai bama riba kara baveiani! Benamo bevaḡa-dokoguni nai, ḡatagu namori ḡutuma na beḡe ḡabi-raḡeguni ḡeri numai.’ ");
INSERT INTO snc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Moḡa lorinai ḡena baregona ḡenai ḡeḡabi-toreto tarimari mabarari ekea-vegogorito. Benamo ta edanaḡiato, ekirato, ‘Ḡoi ḡemu ḡabitore tu vira?’ ");
INSERT INTO snc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Evaḡa-veseto, ekirato, ‘Olive diḡana kavaburi sinau imaima toitoi (800).’ Benamo farefare ḡitaḡauna tarimana na ekiraiato, ‘Ḡemu ḡabitore fefana maiḡa, noraga-tanutari, benamo sinau vasivasi (400) notorea.’ ");
INSERT INTO snc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Benamo ta ma edanaḡiato, ekirato, ‘Ḡoi ḡemu ḡabitore tu vira?’ Ḡia ekirato, ‘Widi fuseri mabarari 1,000.’ Benamo farefare ḡitaḡauna tarimana na ekiraiato, ‘Ḡemu ḡabitore fefana maiḡa, noḡabia, benamo sinau imaima toitoi (800) notorea.’ ");
INSERT INTO snc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Dokonai mo farefare narinarina tarimana rakavana ḡena baregona na evaḡa-raḡeato, korana ḡena tuḡamaḡi-iobuka dainai. Korana tanobara tarimari tu ḡeiaunega-lelevaḡito ḡeri tanu-vegogo ai, a mamai ḡetanuni tarimari tu asiḡina. ");
INSERT INTO snc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Au na akiramini, mai tanobara farefareri e moniri rakavari ḡerina tarimarima tu ḡomi ḡatami ai boḡono vaḡa-iaḡori, korana ḡemi moni bea korini nai, ḡomi tu beḡe tanu-vanaḡi vanaḡini numari ai beḡene ḡabi-raḡemi gubai. ");
INSERT INTO snc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Deikara dagara misina ḡauvei-iaḡina ma ribana nai, dagara baregona maki ḡauvei-iaḡina ma ribana; ema deikara dagara keinai beḡofaḡofani nai, dagara baregonai maki beḡofaḡofani. ");
INSERT INTO snc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bema ḡomi tanobara farefareri e moniri ḡauvei-iaḡiri asi ribami nai, Barau na kamasi farefare korikoriri gubai bevinimini boḡo ḡauvei-iaḡirini? ");
INSERT INTO snc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ema bema ḡomi tarima ta ḡena farefare asi boḡo ḡitaḡau-ginikaurini nai, Barau na ḡomi ḡemi farefare maki asi bevinimini? ");
INSERT INTO snc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Vetuḡunaḡi tarimana na baregona ruarua vetuḡunaḡiri asi beiaḡo-vinirini riba. Korana ḡia na ta tu asi beura-viniani, a ta tu beura-viniani; ta bevaḡa-moḡoniani, a ta tu beḡofaḡofa-iaḡiani. Ḡomi maki Barau ema moni nega sebonai vetuḡunaḡiri asi boḡo iaḡo-vinirini, asiḡina-ḡinavaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisea tarimari tu moni ḡeuravini-baregorito-ḡoi. Iesu ḡena guruḡa mabarana ḡeseḡaḡiato nai, ḡerikiriki-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu na evaḡa-guruḡarito, ekirato, “Ḡomi tu tarimarima ḡoirari ai ḡovekiraḡini, senaḡi Barau tu nuḡami ribana. Tarimarima na ḡevaḡa-raḡerini dagarari Barau na tu asi eura-vinirini, etuḡamaḡi-fitoḡarini. ");
INSERT INTO snc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mose ḡena taravatu ema peroveta tarimari ḡeri guruḡa ḡetanuto-ḡoi eiaḡomato mo, Ioane Babatiso ḡena negai. Monana Barau ḡena Basileia varina ḡeḡobata-iaḡiani nai, tarimarima mabarari ḡevebibi-toḡani beḡene raka-toḡa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Guba ema tanobara beḡe rekwa-rekwani tu ma dabarana, senaḡi taravatu ḡena toutou ta maki asi berekwa-rekwani. ");
INSERT INTO snc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tau ta na ḡaraḡona belaiani, benamo vavine ta ma beḡaraḡoani nai, ḡia mo tu veḡura-vanaḡi veiḡana beveiani; ma tarima boruna ta na mo tau na elaiato vavinena moḡa ma beḡaraḡoani nai, ḡia maki beveḡura-vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Farefare e moni vovoka tarimana ta etanuto-ḡoi. Ḡia tu dabuḡa namori moḡo eveito-ḡoi e ḡaro mabarari ai everereto-ḡoi ema ḡaniḡani namona moḡo eḡanito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ḡena numa ḡatama bokanai tarima ta asi-ḡena ema asi-ḡana arana Lasaro egena-taḡoto-ḡoi. Ḡia tu kefina mabarana lakufodo. ");
INSERT INTO snc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eura-baregoto-ḡoi taḡa tarimana ḡana ḡaniḡani momori bene ḡani. Kwaiva maki ḡeiaḡoto, ḡia manuḡana ḡeiamuserito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Asi ḡena-ḡana tarimana emaseto, benamo aneru na Aberahamo sevina ḡana ḡeḡwa-iaḡoato. Farefare vovoka tarimana ma emaseto, benamo ḡeguriato. ");
INSERT INTO snc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mase gabunai (o Hades) midigu eḡanito-ḡoi nai, eboḡe-raḡeto, manaḡai Aberahamo eḡitaiato, ema Lasaro maki ḡia ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Benamo ekeato, ekirato, ‘Aberahamo, tamagu o, novetuḡagu, mani Lasaro notuḡua, ḡimana didina nanu ai nea duḡi-reia, be meagu moḡo nama vaḡa-ḡavea, korana tu au mai karava morenai midigu vovoka aḡanini.’ ");
INSERT INTO snc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Senaḡi Aberahamo ekirato, ‘Natugu o, notuḡamaḡia, ḡoi omaḡurito-ḡoi ḡarori ai dagara namori oḡabito-ḡoi, a Lasaro tu dagara rakavari eḡabito-ḡoi. Senaḡi toma ḡia tu everereni, a ḡoi tu midigu oḡanini. ");
INSERT INTO snc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ḡita fakarai maki koufa bara ta etanuni, moḡa lorinai maina na tarima ta maniḡana asi beiaḡosini, ema manina na maki ta maiḡana asi beiaḡomani.’ ");
INSERT INTO snc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Benamo farefare vovoka tarimana ekirato, ‘Tamagu o, anoḡimuni, Lasaro notuḡua tamagu ḡena numa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Au tarigu merori tu imaima. Ḡia na bene vaḡa-guruḡari, mai midigu ḡani gabuna ḡana beḡe iaḡomani garina.’ ");
INSERT INTO snc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Senaḡi Aberahamo ekirato, ‘Mose ema peroveta tarimari tu ḡia ḡesi, be garori neḡi beḡene seḡaḡiri.’ ");
INSERT INTO snc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Taḡa tarimana ekirato, ‘Asiḡi, tamagu! Senaḡi bema emaseto tarimana ta beiaḡoni nai, ḡia tu ḡeri rakava ḡerina beḡe vetuḡamaḡi-kureni.’ ");
INSERT INTO snc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aberahamo ekirato, ‘Bema Mose ḡena taravatu ema peroveta tarimari ḡeri ḡuruḡa asi beḡe seḡaḡirini nai, mase na tarima ta bere variḡisi-ḡenoḡoi maki asi ḡere seḡaḡi-vinia.’” ");
INSERT INTO snc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Tarimarima vaḡa-ketori dagarari roḡo beḡe ḡorani, senaḡi bevaḡa-ḡorarini tarimana tu vetuḡana kekei. ");
INSERT INTO snc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ḡia tu bere namo fore baregona ta ḡaiḡonai ḡere baru-kaua, benamo davarai ḡere fiu-reia, korana mai misimisiri ta rakavai beḡofa-toḡaiani garina. ");
INSERT INTO snc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Moḡesi nai lorimi boḡono vetore! Bema ḡoi tarikakamu veiḡa rakavari eveini nai, bono kira-ḡoia, ema ḡena rakava ḡerina bevetuḡamaḡi-kureni nai, ḡena rakava bono tuḡamaḡi-fitoḡari. ");
INSERT INTO snc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bema ḡia na ḡaro ta vaḡa-imaima ruarua (7) bevaḡa-rakavamuni, ema vaḡa-imaima ruarua (7) beḡenoḡoini ḡemu ai, bekirani, ‘Bavetuḡamaḡi-kure,’ betoni nai, ḡoi na ḡena rakava bono tuḡamaḡi-fitoḡari.” ");
INSERT INTO snc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iesu ḡena apostolo na Vereḡauka ḡevaḡa-guruḡaiato, ḡekirato, “Ḡema veḡabidadama novaḡa-baregori!” ");
INSERT INTO snc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Vereḡauka na evaḡa-veserito, ekirato, “Bema ḡomi ḡemi veḡabidadama tu mastadi ḡauna ḡutuna ḡena barego kavana, misina korokoro moḡo, senaḡi ḡomi na mai ḡau baregona o malberi ḡauna boḡo kiraiani, ‘Noveraḡa-vaḡi, be davarai noa vevaro!’ boḡo toni, benamo garomi tu beseḡaḡiani.” ");
INSERT INTO snc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Bema ḡomi ta ḡemu vetuḡunaḡi tarimana tano befokani o mamoe beḡita-ḡaurini murinai, ḡauvei gabuna na numa ḡana beiaḡomani nai, ḡoi na bokiraiani, ‘Noraka-ḡariḡari, be noma ḡaniḡani,’ botoni ba? ");
INSERT INTO snc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Asiḡina, senaḡi ḡoi bokirani, ‘Ḡagu ḡaniḡani novei, ema bono vedabuḡa, be bonoma nari-ḡaugu; au bana ḡaniḡani ema bana niuniu-ḡosi murinai vau, ḡoi ma bono ḡaniḡani ema bono niuniu.’ ");
INSERT INTO snc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ba vetuḡunaḡi tarimana ḡena seḡaḡi ai dainai bevaḡa-namoani? Asiḡina. ");
INSERT INTO snc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ḡomi maki moḡesi; bema Barau na bekiramini ḡauveiri mabarari boḡo veirini nai, boḡo kirani, ‘Ḡita vetuḡunaḡi tarimara ḡera ḡauvei.’” ");
INSERT INTO snc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu Ierusalema eiaḡo-viniato-ḡoi nai, Samaria ema Galilea tanori vefakari na eraka-vanaḡito. ");
INSERT INTO snc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Vanuḡa tai eraka-toḡato, benamo lepera tarimari gabanana (10) ḡesi ḡevedoḡarito. Roḡo manaḡai ḡeruḡa-tarito, ");
INSERT INTO snc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ḡia ḡekeato, ḡekirato, “Iesu! Ḡema Vereḡauka! Novetuḡama!” ");
INSERT INTO snc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu na eḡitarito, benamo evaḡa-guruḡarito, ekirato, “Rubu Veaḡa vereri ḡeri ai ḡoiaḡo, be beḡenea ḡitami.” Benamo ḡeiaḡoto-ḡoi nuḡanai, tauḡaniri ḡeveiarevato, ḡenamoto. ");
INSERT INTO snc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tarima sebona moḡo ḡia fakari ai kefina eḡitaiato enamoto, benamo eḡenoḡoi-iaḡoto, Barau evonevone-raḡe viniato. ");
INSERT INTO snc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Benamo Iesu kwakuna koranai evetui-tarito, evaḡa-namoato. Ḡia tu Samaria tarimana. ");
INSERT INTO snc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu ekirato, “Tarima mabarari tu gabanana (10) beḡe namo. Imaima vasivasi (9) tu aiḡeri? ");
INSERT INTO snc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kara dainai mai irau gabu tarimana ḡereḡana moḡo beḡenoḡoi-iaḡoma, Barau bema vaḡa-raḡea?” ");
INSERT INTO snc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Benamo Iesu na ekiraiato, ekirato, “Novariḡisi, noiaḡo, ḡemu veḡabi-dadama na bevaḡa-maḡurimu.” ");
INSERT INTO snc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisea tarimari kota na Iesu ḡedanaḡiato, Barau ḡena Basileia tu aitoma beiaḡomani. Ḡia na evaḡa-veserito, ekirato, “Barau ḡena Basileia beiaḡomani tu asi boḡo ḡitaiani dagarana. ");
INSERT INTO snc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tarima ta asi bekirani, ‘Noḡitaia, iniḡa!’ o ‘Iomoḡa!’; korana Barau ḡena Basileia tu ḡomi fakami ai maniḡa.” ");
INSERT INTO snc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Benamo ḡia na ḡena mero evaḡa-guruḡarito, ekirato, “Ḡaro ta beraḡasini nai, ḡomi ḡemi ura baregona tu Tarimarima Natuna ḡena ḡaro sebona ta moḡo boḡono ḡitaia, senaḡi asi boḡo ḡitaiani. ");
INSERT INTO snc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kotari na beḡe kiramini, ‘Tarimana iomoḡa!’ o ‘Tarimana maiḡa!’ beḡe toni. Senaḡi asi boḡono iaḡo, murinai asi boḡono raka. ");
INSERT INTO snc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Korana kiriku eragani nai, morena gubai reketa-reketa ḡana eiaḡoni kavana, Tarimarima Natuna ḡena ḡaro nuḡanai maki moḡesi beveini. ");
INSERT INTO snc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Senaḡi ḡia midigumidigu vovoka roḡo beḡani-guineni, ema toma ḡuru tarimari na roḡo beḡe kira-fitoḡaiani. ");
INSERT INTO snc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tarimarima Natuna beiaḡomani ḡaronai tu Noa ḡena negai kavana. ");
INSERT INTO snc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tarimarima mabarari ḡeḡaniḡanito-ḡoi, ḡeniuniuto-ḡoi, tau e vavine ḡeveḡaraḡoto-ḡoi, eiaḡomato mo, Noa ḡena lagatoi ai eraka-toḡato ḡaronai, benamo ḡutuḡutu na mabarari eḡutu-maserito. ");
INSERT INTO snc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lota ḡena negai maki moḡesi moḡo. Ḡeḡaniḡanito-ḡoi, ḡeniuniuto-ḡoi, ḡevoivoito-ḡoi, ḡevaro-varoto-ḡoi, numa ḡeragato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Senaḡi Lota Sodoma eraga-kwaneato ḡaronai, karava ma salfa o fore seḡukari ḡesi guba na ḡeketo-firiḡoto, mabarari evaḡi-masemaserito. ");
INSERT INTO snc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tarimarima Natuna befoforini nai, maki moḡesina beḡorani. ");
INSERT INTO snc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mo ḡaro ai, bema tarima ta tu numa tuḡunai etanu-taḡoni, numai asi ma bene raka-toḡa ḡena farefare bene ḡabiri. Ema bema tarima ta tu vamokai nai, ḡia ḡena numa ḡana asi ma bene ḡenoḡoi ḡena farefare ḡabiḡabiri. ");
INSERT INTO snc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota ḡaraḡona boḡono tuḡamaḡia! ");
INSERT INTO snc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Deikara tauḡena moḡo ḡena maḡuri lorina etoreani tarimana, ḡena maḡuri beleaiani; a ḡena maḡuri eleaiani tarimana na maḡuri bedoḡariani. ");
INSERT INTO snc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Akiramini, mo boḡi ai tarima ruarua geda sebonai beḡe genani nuḡanai, ta tu Barau na beḡabi-vaḡiani, (korana beḡabi-raḡeani nai), a ta tu betanuni, (korana bekira-fitoḡaiani nai). ");
INSERT INTO snc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vavine ruarua widi giro dagarana beḡe giro-vegogoani nai, ta tu beḡabi-vaḡiani, a ta tu betanuni. ");
INSERT INTO snc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36"," Tarima ruarua vamokai beḡe ḡauveini nai, ta tu beḡabi-vaḡiani, a ta tu betanuni.” ");
INSERT INTO snc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesu ḡena mero na ḡedanaḡiato, ḡekirato, “Vereḡauka o, ainai beḡorani?” Iesu evaḡa-veseto, ekirato, “Mase tauḡanina etanuni gabunai, gaio maki monai beḡe vegogoni, (be ḡia na beḡe vaḡa-foforiani).” ");
INSERT INTO snc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Benamo Iesu na ḡena mero ḡeri barabore ta ekiraḡiato. Mo barabore na bene vaḡa-ribari, be vanaḡivanaḡi beḡene ḡauḡau ema asi beḡene moiramoira ḡana. ");
INSERT INTO snc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Maiḡesi ekirato, “Vanuḡa tai Kota eseḡaḡini tarimana ta etanuto-ḡoi. Ḡia tu Barau garina asi eveito-ḡoi, ema tarimarima maki asi egubakaurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mo vanuḡa vabuna ta mai Kota eseḡaḡini tarimana ḡenai eiaḡo-ḡenoḡoi ḡenoḡoito-ḡoi, ḡena maoro evevaḡa-doḡe-gani viniato-ḡoi ema ekirato-ḡoi, ‘Novaḡa-kavagu, be ḡevaḡa-rakavaguni tarimari davari noviniri!’ ");
INSERT INTO snc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nega emanaḡato nuḡanai, Kota eseḡaḡini tarimana na vabu ḡena ura veiḡana asi eveiato. Senaḡi ḡaro ta ḡia tauḡena evetuḡamaḡito, ekirato, ‘Au tu Barau garina asi aveini ema tarimarima maki asi agubakaurini, ");
INSERT INTO snc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","senaḡi dagara sebona tu, mai vabu na au evaḡa-doḡe-ganiguni nai, ḡena ura veiḡana naveia, korana vanaḡivanaḡi beiaḡomani, benamo au bevaḡa-doḡe-gani iaḡoguni ḡesi.” ");
INSERT INTO snc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Vereḡauka ma ekirato, “Mo Kota eseḡaḡini tarimana kara etato, ḡoseḡaḡia. ");
INSERT INTO snc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Be kamasi? Barau na eviriḡirito tarimari, ḡia ḡenai boḡi ema laḡani mabarari ai ḡetaḡitaḡini ema ḡenoḡinoḡi-viniani tarimari, vevaḡa-maoro nuḡanai tu asi bevaḡa-kavarini? Nevaḡa-kavari ḡana nai tu bekwaiboni? ");
INSERT INTO snc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Au na akiramini, ḡeri maoro ai ḡia na bevaḡa-kava ḡariḡaririni. Senaḡi Tarimarima Natuna ma beiaḡomani nai, ḡia veḡabi-dadama tanobarai bedoḡariani ba asiḡina?” ");
INSERT INTO snc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tarima kotari ḡeri tuḡamaḡi ḡia tu vei-iobukaiobuka, a tarimarima mabarari tu vei-rakava tarimari. Iesu na mai tarima ḡeri barabore ekiraḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tarima ruarua Rubu Veaḡa ḡana ḡeiaḡoto, ḡea ḡuriḡurito; ta tu Farisea tarimana, a ta tu takesi gogo tarimana. ");
INSERT INTO snc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisea tarimana ḡereḡana reke tai eruḡato, benamo eḡauḡauto, ekirato, ‘Barau o, avaḡa-namomuni, korana au tu dia tarima mabarari kavana, be seḡafore tarimari, vei ḡeḡeva-ḡeḡeva tarimari, veḡura-vanaḡi tarimari. Avaḡa-namomuni, korana au tu dia iomo takesi gogo tarimana kavana. ");
INSERT INTO snc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fura o wiki ta nuḡanai au tu ḡaro ruarua aḡani-veaḡani, ema adoḡarini dagarari karava gabanana (10) aveirini, benamo karava sebona tu ḡoi avinimuni.’ ");
INSERT INTO snc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Senaḡi takesi gogo tarimana tu manaḡai eruḡato, asi eboḡe-raḡeto gubai, kobana ebotaiato, ekirato, ‘Barau o, au tu rakava tarimagu, noma vetuḡagu!’ ");
INSERT INTO snc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Au na akiramini, takesi gogo tarimana tu Barau na evaḡa-moḡoniato, ma vei-iobukaiobukana ḡesi vanuḡa ḡana eḡenoḡoito, a Farisea tarimana tu asiḡina. Korana tauḡena moḡo eveḡabi-varaḡeni tarimana tu, Barau na bevaḡa-variḡoani, a tauḡena evevaḡa-variḡoni tarimana tu, bevaḡa-varaḡeani.” ");
INSERT INTO snc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tarima kotari mero misimisiri Iesu ḡenai ḡeḡwa-iaḡorito, ḡimana iatari ai bene toreri ḡana. Ḡena mero na ḡeḡitarito, benamo ḡekira-ḡoirito. ");
INSERT INTO snc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Senaḡi Iesu na mero misiri ekea-iaḡomarito, ḡena mero ekirarito, ekirato, “Mani mero misiri au ḡegu ai ḡeiaḡoma, asi ḡolairi, korana maniḡesina kavana tu Barau ḡena Basileia tarimari. ");
INSERT INTO snc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Moḡoni au na ḡomi akiramini, dei na Barau ḡena Basileia asi beḡabi-raḡeani mero misina kavana, Basileiai asi beraka-toḡani.” ");
INSERT INTO snc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda tarimari ḡeri vere tauna ta na Iesu edanaḡiato, ekirato, “Vevaḡa-riba taumu namona, au kara baveini vau, maḡuri vanaḡivanaḡi badoḡariani?” ");
INSERT INTO snc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu na evaḡa-veseato, ekirato, “Ḡoi karase nai au namogu okiraḡini? Tarima ta asi namo, Barau moḡo ḡereḡana. ");
INSERT INTO snc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Taravatu ma ribamu, ‘Asi bono veḡura-vanaḡi, asi bono vaḡivaḡi, asi bono lema, asi bono vevaḡa-daḡa ḡofaḡofa, tamamu sinamu bono gubakauri.’” ");
INSERT INTO snc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mo tarima ekirato, “Au keigu na beiaḡoma toma mani taravatu mabarari akorana-iaḡirini.” ");
INSERT INTO snc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu na mo guruḡa eseḡaḡiato, benamo ekiraiato, “Ḡoi tu dagara sebonai moḡo orabuni. Ḡemu farefare mabarari novoivoi-iaḡiri, moniri tu asi-ḡeri ema asi-ḡari tarimari bono viniri, benamo gubai ḡoi ḡemu farefare bodoḡaririni. Moḡesi boveini vau, au murigu ai bonoma raka.” ");
INSERT INTO snc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mo guruḡa eseḡaḡiato nai, nuḡana emeto-rakavato, korana ḡia tu farefare ḡutuma tarimana. ");
INSERT INTO snc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu na eḡitaiato, benamo ekiraiato, ekirato, “Farefare vovoka tarimari Barau ḡena Basileia ḡeri rakatoḡa tu gwaḡiḡi rakava! ");
INSERT INTO snc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamela nila kadarena na ḡena rakatoḡa tu kotuna gwaḡiḡi, a farefare vovoka tarimana Barau ḡena Basileia rakatoḡana ḡia ḡenai tu gwaḡiḡi rakava.” ");
INSERT INTO snc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tarimarima na mai guruḡa ḡeseḡaḡiato, benamo Iesu ḡedanaḡiato, ḡekirato, “Be, deikarari vau maḡuri beḡe doḡariani?” ");
INSERT INTO snc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu evaḡa-veseto, ekirato, “Tarimarima na asi beḡe veirini riba dagarari tu Barau na beveirini riba.” ");
INSERT INTO snc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petero na ekiraiato, ekirato, “Ḡoi ribamu, ḡai tu ḡema dagara mabarari ḡaraga-kwanerito, murimu ai ḡarakani.” ");
INSERT INTO snc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu na ekirarito, “Moḡoni akiramini, tarima ta ḡena numa eraga-kwaneato, o ḡaraḡona, kakana, tarina, tamana, sinana, natuna Barau ḡena Basileia uranai, ");
INSERT INTO snc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ḡia na mai maḡuri nuḡanai dagara ḡutuma beḡoitaḡoni, ema mo negai vau maḡuri vanaḡivanaḡi bedoḡariani.” ");
INSERT INTO snc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu na ḡena mero gabanana ruarua (12) eḡori-veḡitarito, benamo ekirarito, ekirato, “Ḡoseḡaḡi! Ḡita tu Ierusalema ḡana tavaraḡeni. Monai peroveta tauri na Tarimarima Natuna varina ḡetore-guineto guruḡari aniri mabarari beḡe moḡonini. ");
INSERT INTO snc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Irau bese (o Roma) tarimari ḡimari ai beḡe toreani. Ḡia na beḡe vaseva vaseva-iaḡiani, beḡe rikiriki-iaḡiani e beḡe kanunu-kanunuani. ");
INSERT INTO snc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Beḡe botaiani e beḡe vaḡi-maseani, senaḡi ḡaro vaḡa-toitoinai vau ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iesu ḡena mero mo guruḡa tauna asi ḡeḡoitaḡoato. Guruḡa anina ḡia ḡeri ai tu vekuretoḡa. Ḡia asi ribari Iesu na kara ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu tu Ieriko ekavinaḡiato nai, mata-bubu tauna ta dabara rikinai etanu-taḡoto-ḡoi, enoḡinoḡito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tarimarima ḡutuma dabarai ḡeraka-vanaḡito eseḡaḡito, benamo evedanaḡito, “Mai guru anina tu kara?” ");
INSERT INTO snc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ḡekirato, “Iesu, Nasareta tauna, eraka-vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Benamo ekea-fouto, ekirato, “Iesu o, Davida natuna, au novetuḡagu!” ");
INSERT INTO snc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ḡoirai ḡerakato tarimari na ḡekira-ḡoiato, senaḡi ḡia ekea-ḡiḡiraḡe ḡiḡiraḡeto-ḡoi, “Davida Natuna o, au novetuḡagu!” ");
INSERT INTO snc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu eruḡa-tarito, benamo ekirato, “Ḡoḡori-iaḡomaia!” Ḡia eiaḡomato, benamo Iesu na edanaḡiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kara ourani ḡemu ai naveia otoni?” Ḡia evaḡa-veseto, ekirato, “Vereḡauka o, matagu noma vaḡa-iaḡaia.” ");
INSERT INTO snc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ekirato, “Be, matamu nenamo, ḡemu veḡabidadama na bevaḡa-namomu.” ");
INSERT INTO snc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Vaḡa-sebo matana enamoto, eboḡeboḡe-ginikauto, Iesu murinai erakato, Barau evaḡa-raḡeato. Mo veiḡa ḡeḡitaiato tarimari mabarari na maki Barau ḡevaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Ieriko ai eraḡasito, benamo vanuḡa nuḡana na eraka-iaḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Monai tu takesi gogo tarimari ḡeri vere ta arana Sagaio; ḡia tu moni ema farefare vovoka tarimana. ");
INSERT INTO snc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ḡia ḡena ura tu Iesu neḡita-vetoḡaia ḡia tu dei, senaḡi tarimarima ḡutuma ema ḡia tu tau kubina nai, neḡitaia ḡana egera-kavato. ");
INSERT INTO snc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Moḡa lorinai eraga-guine-iaḡoto, sikamoa ḡauna tai eraḡeto, Iesu monana beraka-vanaḡini nai, bene ḡitaia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu mo gabu ai eraḡasito, eboḡe-raḡeto, eḡitaiato, benamo ekiraiato, “Sagaio, norakariḡo-ragaraga, korana au toma tu ḡoi ḡemu numai batanuni bene.” ");
INSERT INTO snc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Benamo Sagaio eraga-rakariḡoto, ma iakuna ḡesi Iesu eḡori-iaḡoato ḡena numa ḡana. ");
INSERT INTO snc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ḡeḡitaiato tarimari mabarari ḡemugumuguto, ḡekirato, “Mai tau tu rakava tarimana, ḡena numai ea tanuni.” ");
INSERT INTO snc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sagaio eruḡa-vaisito, Vereḡauka evaḡa-guruḡaiato, ekirato, “Vereḡauka, noseḡaḡi! Ḡegu farefare reke-ta tu gara veḡubu tarimari bavinirini, ema ḡena farefare aḡabi-kavaiato tarimana tu, nega vaḡa-vasivasi bavini-ḡenoḡoiani.” ");
INSERT INTO snc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu na ekiraiato, ekirato, “Toma vevaḡa-maḡuri tu mai numai bema raḡasi, korana mai tarima maki Aberahamo natuna. ");
INSERT INTO snc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Korana Tarimarima Natuna tu rekwarekwa tarimari vetauvetauri ema bene vaḡa-maḡuriri ḡana eiaḡomato.” ");
INSERT INTO snc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mabarari ḡeseḡaḡito-ḡoi nuḡanai, Iesu na ḡeri barabore ta ekiraḡiato. Korana ḡia tu Ierusalema ekavi-naḡiato nai, ḡia mataboru ḡekirato, Barau ḡena Basileia tu mo negai befoforini. ");
INSERT INTO snc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Benamo ḡia ekirato, “Dagi baregona tarimana ta gabu manaḡana ḡana eiaḡoto, kini o vere dagina bene ḡabia vau, ma bene ḡenoḡoi ḡana. ");
INSERT INTO snc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Roḡosi bere raka nai, ḡena vetuḡunaḡi tarimari gabanana (10) ekea-iaḡomarito, golo moniri ḡia tata sebori-sebori evinirito, benamo ekirarito, ekirato, ‘Au murigu ai boḡono ḡauvei-iaḡiri, be moni boruri tari ma boḡono doḡari.’ ");
INSERT INTO snc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Senaḡi ḡena tanobara tarimari na asi ḡeura-viniato-ḡoi nai, murina na guruḡa ḡetuḡuto, ḡekirato, ‘Ḡai asi ḡaurani mai tarima ḡai ḡema vere ai bene iaḡo.’ ");
INSERT INTO snc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Senaḡi mo tarima na kini dagina ḡeviniato murinai, eḡenoḡoi-iaḡomato. Benamo ḡena vetuḡunaḡi tarimari ekea-iaḡomarito, beḡene vaḡa-ribaia, moni boruri vira ḡia tata ḡedoḡarito. ");
INSERT INTO snc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tarima giniguinena eiaḡomato, benamo ekirato, ‘Vereḡauka, golo monina sebona oviniguto nuḡanai, au na tu moni gabanana (10) ma adoḡaririto.’ ");
INSERT INTO snc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ḡia na evaḡa-namoato, ekirato, ‘Ḡoi tu vetuḡunaḡi taumu namona! Dagara misiri oḡauvei-iaḡi ginikaurini nai, au na vanuḡa mabarari gabanana (10) avinimuni, ḡoi na boḡita-ḡaurini.’ ");
INSERT INTO snc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Vaḡa-ruaruana eiaḡomato, benamo ekirato, ‘Vereḡauka, sebona oviniguto nuḡanai, au na moni imaima ma adoḡaririto.’ ");
INSERT INTO snc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ḡena vere na ekiraiato, ‘Ḡoi tu vanuḡa imaima boḡita-ḡaurini.’ ");
INSERT INTO snc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Vetuḡunaḡi tarimana ta ma eiaḡomato, benamo ekirato, ‘Vereḡauka o, ḡoi ḡemu moni sebona tu iniḡa, au na muko ai akumuato, akure-toḡaiato. ");
INSERT INTO snc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au tu ḡoi garimu aveito, korana ḡoi tu asi vegubakau taumu. Tarima ḡeri dagara oḡabirini, ema dia ḡoi na ovarorito dagarari obasirini e okwarini.’ ");
INSERT INTO snc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ḡena vere na ekiraiato, ‘Ḡoi tu vetuḡunaḡi tarimana rakavana! Tauḡemu ḡemu guruḡa na bavevaḡa-maoro vinimuni. Ḡoi ribamu au tu asi vegubakau taugu, dia au ḡegu dagarari aḡabirini, ema dia avaroto dagarari abasirini. ");
INSERT INTO snc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Be, karase nai ḡegu moni tu banikai asi otoreato? Benamo au bara ḡenoḡoi nai tu, ma torekauna o interestina ḡesi bara doḡaria.’ ");
INSERT INTO snc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Benamo monai ḡeruḡa-taḡoto-ḡoi tarimari ekirarito, ekirato, ‘Mani moni sebona ḡenai maniḡa ḡoḡabia, moni gabanana (10) tarimana ḡovinia.’ ");
INSERT INTO snc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Senaḡi ḡia na ḡekiraiato, ‘Vereḡauka, ḡia ḡena moni tu varau 10 beḡabia.’ ");
INSERT INTO snc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ḡia evaḡa-veseto, ekirato, ‘Au na akiramini, ma ḡena-ḡana tarimana tu ḡutumari ma baviniani, a asi ḡena-ḡana tarimana tu, ḡenai misina maki baḡabi-vaḡiani. ");
INSERT INTO snc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Senaḡi au ḡebaru-viniguni tarimari, asi ḡeurato au ḡia bana guine-iaḡiri ḡetato tarimari, ḡoḡori-iaḡomari, au ḡoiragu ai ḡoma vaḡi-maseri!’” ");
INSERT INTO snc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eguruḡa-ḡosito vau, Iesu eraka-guineto, Ierusalema ḡana evaraḡeto. ");
INSERT INTO snc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betefage e Betania ekavinaḡirito-ḡoi nai, Olive Ḡorona rekenai, benamo Iesu na ḡena mero ruarua etuḡu-guinerito, ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ḡoira vanuḡana ḡana ḡoiaḡo. Boḡo raḡasini nai, doniki natuna ta barutari boḡo ḡitaiani, iatanai tarima ta roḡosi bene raḡe. Boḡono ruḡaia, benamo boḡono ḡori-iaḡomaia. ");
INSERT INTO snc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bema tarima ta na bedanaḡimini, bekirani, ‘Karase nai ḡoruḡaiani?’ betoni nai, ḡomi boḡono kira, ‘Vereḡauka na eura-viniani.’” ");
INSERT INTO snc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Benamo tauri ruarua ḡeiaḡoto, Iesu na ekira-vararito ilailanai ḡedoḡariato. ");
INSERT INTO snc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Doniki natuna ḡeruḡaiato-ḡoi nuḡanai, doniki biaguri na ḡedanaḡirito, “Ḡomi tu karase mani doniki ḡoruḡaiani?” ");
INSERT INTO snc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ḡevaḡa-veseto, ḡekirato, “Vereḡauka na eura-viniani.” ");
INSERT INTO snc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Benamo Iesu ḡenai ḡeḡori-iaḡoato. Ḡeri dabuḡa barari doniki doḡenai ḡeiavarito vau, Iesu ḡevaḡa-tanu-kauato. ");
INSERT INTO snc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu eiaḡoto-ḡoi nai, tarimarima ḡeri dabuḡa barari dabarai ḡeiavarito. ");
INSERT INTO snc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ierusalema varau ekavinaḡiato, Olive Ḡorona na evariḡoto-ḡoi, benamo Iesu ḡena mero ḡutuma lelevaḡi ḡeiakuto, Barau ḡevonevone-raḡe viniato, korana nuḡa-farevaḡi veiḡari ḡeḡitarito nai. ");
INSERT INTO snc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ḡekirato, “Ḡera Vere baregona, Vereḡauka aranai eiaḡomani Kinina, sivaḡa-namoa! Maino gubai bene barego ema vevaḡa-raḡe tu guba tuḡunai!” ");
INSERT INTO snc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Benamo Farisea tarimari kota na tarimarima ḡutuma nuḡari na Iesu ḡekiraiato, ḡekirato, “Vevaḡa-riba taumu, ḡoi ḡemu mero nokira-ḡoiri!” ");
INSERT INTO snc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu na evaḡa-veserito, ekirato, “Au na akiramini, bema ḡia asi beḡe koḡoni nai, mai fore beḡe koḡoni.” ");
INSERT INTO snc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu vanuḡa barana Ierusalema ḡana eraka-kavinaḡito, eḡitaiato, benamo taḡina eveito, ");
INSERT INTO snc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ekirato, “Toma ḡaro ai ḡemu maino korana boro ribaia bere namo! Senaḡi toma, ḡoi na asi oḡitaiani. ");
INSERT INTO snc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ḡarona beraḡasini nai, ḡebaru-vinimuni tarimari na tano beḡe ragaiani, beḡe kobe-ḡeḡeraḡimuni, asi ḡemu rakarosi dabarana. ");
INSERT INTO snc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Benamo ḡoi ema nuḡamu ai ḡetanuni tarimari beḡe fuki-bubu-riḡomini tano ai; fore maki ta iatanai asi beḡe iaḡuiani, korana Barau ḡena vevaḡa-kava emariḡoto asi oribaiani nai.” ");
INSERT INTO snc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu Rubu Veaḡa nuḡanai eraka-toḡato, voivoi tarimari elai-rosirito, ");
INSERT INTO snc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ekirarito, ekirato, “Buka Veaḡa nuḡanai tu maiḡesi ekirani, ‘Ḡegu numa tu ḡuriḡuri numana beḡe kiraḡiani,’ senaḡi ḡomi na tu lema tarimari ḡeri gumu gabunai boḡo vaḡa-iaḡoa.” ");
INSERT INTO snc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iesu tu ḡaro mabarari ai Rubu Veaḡa nuḡanai evevaḡa-ribato-ḡoi. Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ema Iuda vereri na ḡia beḡene vaḡia dabarana ḡevetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Senaḡi asi ḡeri dabara, korana tu tarimarima mabarari ḡeurato-ḡoi, Iesu ḡena guruḡa ta maki asi beḡene vei-ketoa. ");
INSERT INTO snc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ḡaro tai Iesu tu Rubu Veaḡa nuḡanai evevaḡa-ribato-ḡoi, Vari Namona tarimarima eḡobata-vinirito-ḡoi. Benamo Rubu Veaḡa vereri baregori, e taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari, ema Iuda vereri Iesu ḡenai ḡeiaḡoto, ");
INSERT INTO snc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ḡedanaḡiato, ḡekirato, “Kamara seḡukai ḡoi na mai dagara oveirini? Dei na mai seḡuka evinimuto?” ");
INSERT INTO snc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu na evaḡa-veserito, ekirato, “Au na maki vedanaḡi ta avinimini. Ḡokira-varagu, ");
INSERT INTO snc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioane ḡena babatiso veiḡana tu Barau ḡenana eiaḡomato, ba tarimarima ḡerina?” ");
INSERT INTO snc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ḡia fakari ai ḡeverorito, ḡekirato, “Bema ḡita bita kirani, ‘Barau ḡenana,’ bita toni nai, ḡia bekirani, ‘Karase nai Ioane asi ḡovaḡa-moḡoniato?’ betoni. ");
INSERT INTO snc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Senaḡi bema ḡita bita kirani, ‘Tarimarima ḡerina,’ bita toni nai, tarimarima mabarari na fore na beḡe taki-maserani, korana ḡia ḡekirani, Ioane tu peroveta tarimana, ḡetoni.” ");
INSERT INTO snc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iesu ḡevaḡa-veseato, ḡekirato, “Ḡai asi ribama,” ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Benamo Iesu na ḡia maki ekirarito, ekirato, “Au na maki kamara seḡukai mai dagara aveirini asi bakira-varamini.” ");
INSERT INTO snc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Benamo Iesu na tarimarima mai barabore ekira-vararito, ekirato, “Tarima ta vine tavoḡana evaroato vau, tavoḡa ḡitaḡauna tarimari ḡeri ai eraga-kwaneato. Benamo erakato gabu ta ḡana. Monai ḡaro ḡutuma ea tanuto. ");
INSERT INTO snc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vine ḡwari (o grapes) ḡemaḡeto, benamo ḡia na ḡena vetuḡunaḡi tauna ta etuḡuato tavoḡa narinarina tarimari ḡeri ai, vine ḡwari kota benea ḡabi ḡana. Senaḡi tavoḡa ḡitaḡauna tarimari na ḡekwariato vau, ḡimana kori ḡetuḡu-ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Benamo vetuḡunaḡi tauna ta ma etuḡuato, senaḡi ḡia maki ḡevaḡa-vevaḡiato, ḡevei-maiaka maiakaiato, ḡimana kori ḡetuḡu-ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vetuḡunaḡi tauna vaḡa-toitoina maki etuḡuato, senaḡi ḡevaḡa-vevaḡi rakavaiato, kefina maki ma fauri vau ḡelai-rosiato. ");
INSERT INTO snc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Benamo tavoḡa biaguna ekirato, ‘Au tu kara ma baveini? Au natugu, auravini-baregoani merona, na-tuḡua, atuḡamaḡini ḡia beḡe gubakauani!’ ");
INSERT INTO snc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Senaḡi tavoḡa narinarina tarimari na ḡeḡitaiato nai, tauḡeri ḡeveguruḡa-vevinito, ḡekirato, ‘Mani tu tavoḡa biaguna natuna, be sivaḡia, benamo tavoḡa tu ḡita ḡera.’ ");
INSERT INTO snc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Benamo tavoḡa murikanai ḡeinu-rosiato, ḡevaḡi-maseato. Iesu evedanaḡito, ekirato, “Tavoḡa biaguna tu kara beveiani ḡia ḡeri ai? ");
INSERT INTO snc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ḡia beiaḡomani, tavoḡa ḡitaḡauna tarimari bevaḡi-ḡosirini, benamo tavoḡa tu tarima irauri ma bevinirini.” Tarimarima na mai guruḡa ḡeseḡaḡiato nai, ḡekirato, “Asiḡi, maiḡesi asi bene vetore!” ");
INSERT INTO snc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu na eḡitarito, benamo edanaḡirito, ekirato, “Be, mai guruḡa Buka Veaḡa nuḡanai anina tu kara? Maiḡesi ekirato, ‘Fore numari ḡeragarini tarimari na asi ḡeura-viniato ma ḡefitoḡaiato forena tu duḡu forenai eiaḡoto.’ ");
INSERT INTO snc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Deikara mo fore iatanai beketokauni tarimana beḡwa-kirakiraiani; ema mai fore tarima ta iatanai beketokauni nai, belau-fatafataiani.” ");
INSERT INTO snc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari e Rubu Veaḡa vereri baregori na Iesu inimoḡo beḡene ḡabia dabarana ḡevetauato-ḡoi, korana ḡia ribari, Iesu na mai barabore tu ḡia iatari ai ekiraḡirito-ḡoi nai. Senaḡi tarimarima ḡutuma vegogo-taḡo naima ḡegarito. ");
INSERT INTO snc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Moḡa lorinai ḡeḡita-taḡoato moḡo. Gabivau ḡofaḡofa tarimari ḡetuḡurito, ḡia na beḡene danaḡia noḡa vei-iobukaiobuka tarimari kavana; beḡene danaḡia, bema Iesu ḡena guruḡa beiaḡo-irauni nai, Iesu beḡene ḡabia, Roma gavanana ḡimana seḡukanai beḡene torea. ");
INSERT INTO snc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mo ḡofaḡofa tarimari na Iesu ḡedanaḡiato, ḡekirato, “Vevaḡa-riba taumu o, ḡai ribama, ḡemu guruḡa e ḡemu vevaḡa-riba tu maoromaoro. Tarimarima ḡeri dagi asi otuḡamaḡirini, senaḡi ḡoi na Barau ḡena dabara ovevaḡa-riba-iaḡi ḡitakauani ma moḡonimu ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nokirama, Kaisara, Roma ḡeri vere, takesi moniri bitana vinia tu namo ba asiḡi?” ");
INSERT INTO snc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu na ḡeri ḡofaḡofa varau eḡitaiato, benamo ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Silva monina ta ḡovaḡa-ḡitagu! Mai tu dei iouiouna e dei arana?” Ḡia ḡevaḡa-veseto, ḡekirato, “Mai tu Kaisara laulauna e arana,” ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Benamo Iesu na ekirarito, “Kaisara ḡena, Kaisara boḡono vinia, Barau ḡena, Barau boḡono vinia.” ");
INSERT INTO snc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iesu ḡena guruḡa tarimarima ḡoirari ai tu maoro nai, asi ḡeri dabara ḡia beḡe ḡofa-darereani, senaḡi ḡena vevaḡa-vese na nuḡari ḡefarevaḡito, asi ma ḡeguruḡato. ");
INSERT INTO snc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukea tarimari kota Iesu ḡenai ḡeiaḡoto. Ḡeri tuḡamaḡi tu, mase tarimari asi ma beḡe variḡisi-ḡenoḡoini. Iesu ḡedanaḡiato, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Vevaḡa-riba taumu o, Mose na taravatu ḡai ḡema maiḡesi etoreato, ‘Bema tau ta kakana bemaseni, ma vabuna tu roḡo maḡuri, senaḡi asi naturi nai tu, mo tau na kakana vabuna bene ḡaraḡoa. Korana tu ḡia na naturi tari beḡene vaḡa-maḡuriri mo mase tauna ḡena.’ ");
INSERT INTO snc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tarikaka tau moḡo korina mabarari tu imaima ruarua (7). Tau guinena na vavine ta eḡaraḡoato, ma emaseto, natuna ta asi evaḡa-ḡoraiato. ");
INSERT INTO snc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tau vaḡa-ruaruana na vabu ma eḡaraḡoato, ");
INSERT INTO snc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tau vaḡa-toitoina maki moḡesina moḡo. Moḡa nuḡanai ḡia mabarari tu imaima ruarua (7), senaḡi mabarari ḡemaseto, naturi ta asi ḡevaḡa-ḡoraiato. ");
INSERT INTO snc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dokonai mo vavine maki emaseto. ");
INSERT INTO snc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Variḡisi-ḡenoḡoi ḡaronai mo vavine tu dei ḡaraḡona, korana ḡia tu tau imaima ruarua (7) na ḡeḡaraḡoato nai?” ");
INSERT INTO snc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu na evaḡa-veserito, ekirato, “Mai tanobarai tau e vavine ḡeveḡaraḡoni, ");
INSERT INTO snc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","senaḡi roḡo beiaḡomani Basileianai, vei-iobukaiobuka tarimari beḡe variḡisi-ḡenoḡoini. Ḡia tu asi beḡe veḡaraḡoni. ");
INSERT INTO snc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ḡia asi beḡe maseni maki, senaḡi aneru kavana beḡe tanuni. Barau natunai beḡe iaḡoni, korana ḡia tu variḡisi-ḡenoḡoi tarimari. ");
INSERT INTO snc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose na evaḡa-moḡoniato, mase na ma beḡe variḡisi-ḡenoḡoini. Ḡau eḡaraiato-ḡoi varina nuḡanai, Mose na Vereḡauka tu ‘Aberahamo ḡena Barau, Isako ḡena Barau, Iakobo ḡena Barau’ ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moḡoni, ḡia tu maḡuri tarimari ḡeri Barau, dia mase tarimari ḡeri Barau. Korana Barau ḡenai tu, tarimarima mabarari tu maḡuri.” ");
INSERT INTO snc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari kota ḡekirato, “Vevaḡa-riba taumu o, vevaḡa-vese namona tu maniḡa.” ");
INSERT INTO snc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Benamo moḡa murina na asi ma ḡedanaḡi-ḡenoḡoiato, ḡegarito nai. ");
INSERT INTO snc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu na ekirarito, ekirato, “Ḡia tu kamasi nai Keriso tu Davida natuna ḡetoni? ");
INSERT INTO snc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davida tu Salamo nuḡanai ekirato, ‘Barau na ḡegu Vereḡauka ekiraiato: Au ḡimagu aroribana rekenai bono tanu, ");
INSERT INTO snc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bene iaḡo mo, ḡoi ḡebaru-vinimuni tarimari ḡoi kwakumu gaburenai batorerini.’ ");
INSERT INTO snc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davida na Keriso tu ‘Vereḡauka’ etato. Kamasi nai Keriso tu Davida natuna?” ");
INSERT INTO snc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tarimarima mabarari ḡoirari ai Iesu na ḡena mero ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Taravatu ḡevevaḡa-riba iaḡiani tarimari ḡerina lorimi boḡono vetore. Ḡia ḡeurani dabuḡa maukari beḡene riḡo, maketi gaburi ai beḡene rakaorakao, tarimarima na beḡene vaḡa-namori urari ai. Rubu nuḡari ai ema ḡani-vegogo gaburi ai ḡeri ura tanutanu namori ai beḡene tanu. ");
INSERT INTO snc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ḡia na vabu ḡeri numa ma farefare ḡevaḡa-koririni. Ḡeri ḡauḡau tu mauka kenene, senaḡi ḡeḡofaḡofani. Moḡesi ḡeveini tarimari meto barego vedaurea beḡe ḡabini.” ");
INSERT INTO snc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu eboḡe-vaisito nai, moni vovoka tarimari ḡeri boubou moni mauḡai ḡeḡurato-ḡoi eḡitarito. ");
INSERT INTO snc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Asi-ḡena ema asi-ḡana vabuna ta eiaḡomato, eḡitaiato, ḡena moni misiri ruarua moḡo eḡura-riḡorito, (mai tu noḡa moḡo toea sebona kavana). ");
INSERT INTO snc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Benamo Iesu ekirato, “Moḡoni, au na akiramini, mai vabu na beḡuraia monina tu mabarari ḡeri vini bevanaḡiri. ");
INSERT INTO snc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Korana mabarari ḡeri moni vovoka ḡerina koturi moḡo beḡe vini, senaḡi mai vabu tu ḡena moni misina ḡenana moḡo, ḡena maḡuri ai bere vevaḡa-kava-iaḡiri dagarari mabarari beḡurari.” ");
INSERT INTO snc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu ḡena mero kota na Rubu Veaḡa ḡeguruḡa-iaḡiato, ḡitaḡitana ma marevana, ma ḡena fore namori ḡesi ema Barau ḡevarevare-viniato varevare dagarari namori na ḡevaḡa-veraiato, ḡetato. Senaḡi Iesu ekirato, ");
INSERT INTO snc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ḡarona beraḡasini, mainai ḡoḡitarini dagarari mabarari tarima tari na beḡe vare bubu-riḡorini, fore ta fore ta iatanai asi beḡe tanuni.” ");
INSERT INTO snc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Benamo Iesu ḡedanaḡiato, ḡekirato, “Vevaḡa-riba taumu, aitoma beḡorani? Ema beḡorani nai, kamara vetoḡa na bevaḡa-moḡoniani?” ");
INSERT INTO snc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu evaḡa-veseto, ekirato, “Ḡomi lorimi boḡono vetore, beḡe ḡofamini ḡesi. Korana tu tarimarima ḡutuma au aragu ai beḡe iaḡomani, beḡe kirani, ‘Tarimana tu au maiḡegu!’ ema, ‘Ḡarona beraḡasi!’ beḡe toni. Senaḡi ḡia muriri ai asi boḡono raka. ");
INSERT INTO snc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bema ḡomi na vetari o tuari gururi e gururaḡe boḡo seḡaḡirini nai, nuḡami asi beḡene raḡe. Mai dagara beḡe ḡora-guineni, senaḡi dokona asi roḡo beraḡasini.” ");
INSERT INTO snc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesu ma ekirato, “Tanobara ta tanobara ta ḡesi beḡe vevaḡini, gavamani ta gavamani ta ḡesi beḡe vetarini. ");
INSERT INTO snc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gabu ḡutuma nuḡari ai tano beḡe iagaiagani, doḡe beḡe ḡorani, ema tarimarima ḡutuma keve beḡe doḡarini ta ḡenana bevanaḡini ta ḡenai. Vevaḡa-gari vetoḡari baregori guba na beḡe foforini. ");
INSERT INTO snc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Senaḡi mo dagara roḡosi beḡene ḡora nai, ḡia na ḡomi beḡe ḡabimini, beḡe vaḡa-midigumini. Rubu ai beḡe vaḡa-kotamini, dibura numari ai beḡe tore-toḡamini. Kini e gavana ḡoirari ai beḡe ḡori-iaḡomini, korana au ḡoḡabi-raḡeguni nai. ");
INSERT INTO snc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mai tu ḡomi ḡemi nega namona au vaḡa-moḡonigu ai boḡo iaḡoni. ");
INSERT INTO snc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Boḡono vetuḡamaḡi, ḡemi vevaḡa-vese guruḡari asi boḡono tuḡamaḡi-guine guineri, ");
INSERT INTO snc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","korana tu au na guruḡa e iaunega bavinimini, beḡe baru-vinimini tarimari na beḡe kira-ḡoimini, senaḡi asi beḡe kokoreni. ");
INSERT INTO snc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tamami, sinami, kakami, tarimi, garagarami, e ḡatami na tarimarima ḡimari ai beḡe revamini. Ḡomi kota maki beḡe vaḡi-masemini. ");
INSERT INTO snc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tarimarima mabarari na beḡe iau-rakavamini, korana au ḡoḡabi-raḡeguni nai. ");
INSERT INTO snc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Senaḡi debami ḡuiri sebona maki asi berekwa-rekwani. ");
INSERT INTO snc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Boḡo vevaḡa-gwaḡiḡini nai tu, boḡo maḡurini.” ");
INSERT INTO snc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Vetari o tuari doḡorori na Ierusalema beḡe tanu-ḡeḡeraḡiani boḡo ḡitaiani, benamo boḡo ribani, Ierusalema dori ḡevaḡa-rakavaiani. ");
INSERT INTO snc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mo negai Iudeai ḡetanuni tarimari tu ḡoro ḡana beḡene raga-iaḡo. Vanuḡa barana Ierusalema nuḡanai ḡetanuni tarimari tu, vanuḡa beḡene raga-kwanea, ema gunikai ḡetanuni tarimari tu vanuḡa barana nuḡanai asi beḡene raka-toḡa. ");
INSERT INTO snc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Korana mo negai tu Barau na tarimarima ḡeri rakava voiri bevinirini Buka Veaḡai ḡetore-guineato vaḡa-moḡoniri. ");
INSERT INTO snc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vavine ma baniri e ḡabi-variḡu vavineri kika ma vetuḡari! Midigu barego mai tano ai beḡe raḡasini, ema Barau na ḡena bese tarimari bevaḡa-maoro vinirini. ");
INSERT INTO snc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tarima kota tu vetari baḡari na beḡe vaḡi-maserini, kota tu beḡe ḡabi-maḡuririni, tanobara mabarari ḡana beḡe ḡori-iaḡorini, beḡea diburarini; ema irau bese tarimari na Ierusalema beḡe fana-tariani, beiaḡoni mo, ḡeri ḡaro bea korini.” ");
INSERT INTO snc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ḡaro, ḡue, ema visiḡu nuḡari ai vetoḡa beḡe ḡorani. Tanobara beseri davara ema ureure gururi ai beḡe gari-rakavani. ");
INSERT INTO snc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tarimarima beḡe keto-founi gari dainai, ḡeri tuḡamaḡi maki roḡo beḡe korini mo beḡe ḡorani dagarari dairi ai; korana tu guba seḡukari beḡe iagaiagani. ");
INSERT INTO snc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mo negai Tarimarima Natuna beḡe ḡitaiani, magube nuḡana na beiaḡomani ma seḡukana e ma mamana baregona ḡesi. ");
INSERT INTO snc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mo dagara beḡe ḡorani nai, boḡono variḡisi, boḡono boḡe-vaisi, korana vaḡa-maḡurimi tu varau bekavinaḡi.” ");
INSERT INTO snc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu na ḡeri barabore ta ekiraḡiato, ekirato, “Figi ḡauna ema ḡau mabarari ḡoḡitari. ");
INSERT INTO snc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lauri variḡuri ḡefafani ḡoḡitarini, ḡomi ḡoribani, ḡaro ḡena tora taimina varau bekavinaḡi. ");
INSERT INTO snc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Moḡa ilailanai, ḡomi maki bema boḡo ḡitarini, mai dagara beḡe ḡorani nai, boḡo ribani, Barau ḡena Basileia tu bekavinaḡi. ");
INSERT INTO snc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Moḡoni akiramini, mai ḡuru asi bekorini, beiaḡoni mo, mai dagara mabarari beḡe ḡorani. ");
INSERT INTO snc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Guba e tanobara beḡe rekwa-rekwani, senaḡi au ḡegu guruḡa tu asi beḡe rekwarekwani, beḡe tanu-vanaḡi vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Lorimi boḡono vetore, ḡaniḡani e niuniu ḡutuma, ema tanobara ḡena tuḡamaḡi dagarari na ḡomi nuḡami beḡe vaḡa-metorini ḡesi. Benamo mo ḡaro na nuḡami bevaḡa-farevaḡirini. ");
INSERT INTO snc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Korana mo ḡaro tu tanobarai ḡetanuni tarimari mabarari ḡeri ai beraḡasini. ");
INSERT INTO snc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Moḡa lorinai boḡono venari, boḡono ḡauḡau ḡaro mabarari ai, beḡe ḡorani dagarari mabarari ḡerina boḡono raga-maḡuri ḡana, korana Tarimarima Natuna ḡoiranai roḡo boḡo ruḡani.” ");
INSERT INTO snc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ḡaro mabarari ai Iesu tu Rubu Veaḡai evevaḡa-ribato-ḡoi, a lavilavi ai tu eraka-rosito-ḡoi, Olive Ḡorona tuḡunai ea genato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Boḡiboḡi iamoiamonai tarimarima mabarari Rubu Veaḡai ḡevegogoto-ḡoi ḡia ḡena guruḡa beḡene seḡaḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Asi etubuni faraona verekona arana Pasova varau ekavi-naḡito. (Mo tu Iuda tarimari mase aneruna na evanaḡirito moḡo, asi evaḡirito verekona). ");
INSERT INTO snc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Rubu Veaḡa vereri baregori ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari na Iesu beḡene ḡabia, benamo beḡene vaḡi-ḡairia dabarana ḡevetauato, korana tarimarima gariri ḡeveito. ");
INSERT INTO snc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mo negai Satani na Iudas Isakariota, tarima ta gabanana ruarua (12) fakari ai, eboroḡiato. ");
INSERT INTO snc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Benamo Iudas eiaḡoto Rubu Veaḡa vereri baregori ema Rubu Veaḡa narinarina tarimari ḡeri vere ḡeri ai, Iesu tu ḡia ḡimari ai kamasi bene tore-kaua dabarana ḡeboioḡa-vegogoato. ");
INSERT INTO snc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ḡia ḡeiaku-rakavato, ḡekira-toreato, moni beḡe viniani, ḡetato. ");
INSERT INTO snc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudas na eḡabi-raḡeato, benamo Iesu ḡia ḡimari ai vekuretoḡai betore-kauani dabarana evetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ginitaḡo mamoeri beḡe vaḡirini ḡarona varau eraḡasito. ");
INSERT INTO snc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Benamo Iesu na Petero ma Ioane etuḡurito, ekirato, “Ḡoiaḡo, Pasova verekona boḡono dabaraia, bitana ḡania.” ");
INSERT INTO snc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ḡevaḡa-veseto, ḡekirato, “Ḡai tu ainai baḡana dabara-torea?” ");
INSERT INTO snc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Benamo Iesu na ekirarito, ekirato, “Vanuḡa baregonai boḡo raka-toḡani nai, tarima ta nanu gwaḡutuna befaḡaiani boḡo ḡoitaḡoani. Murina na boḡono iaḡo, ḡia beraḡekauni numanai boḡono raḡekau. ");
INSERT INTO snc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Benamo numa tarimana boḡono vaḡa-guruḡaia, boḡono kira, “Vevaḡa-riba tauna ekirani, ‘Varivari daiḡutuna tu aiḡa, au ema ḡegu mero ḡesi monai ginitaḡo mamoena baḡana ḡania?’ ");
INSERT INTO snc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Benamo ḡia na daiḡutu baregona ta numa tuḡunai bevaḡa-ḡitamini, ḡeiareva-toreato. Monai boḡono dabara-torea.” ");
INSERT INTO snc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Benamo ḡeiaḡoto, Iesu na ekiraḡirito kavana ḡedoḡaririto. Monai vereko ḡedabaraiato. ");
INSERT INTO snc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ginitaḡo mamoena beḡe ḡaniani aoana eraḡasito. Iesu tu ḡena apostolo tarimari ḡesi ḡaniḡani gabunai ḡetanu-tarito. ");
INSERT INTO snc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Benamo Iesu na evaḡa-guruḡarito, ekirato, “Au ḡegu ura baregona mai ginitaḡo mamoena ḡomi ḡesi bitana ḡani-vegogo-guinea vau, midigu bana ḡani. ");
INSERT INTO snc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Korana tu akiramini, ginitaḡo mamoena asi ma baḡaniani, beiaḡoni mo, ginitaḡo anina korikorina bea foforini Barau ḡena Basileia nuḡanai.” ");
INSERT INTO snc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Benamo Iesu na kapusi ta eḡabiato, evaḡa-namoato, ekirato, “Maiḡa tu ḡoḡabia, mabarami boḡono niua. ");
INSERT INTO snc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Korana tu akiramini, vine nanuna asi ma baniu-ḡenoḡoiani, beiaḡoni mo, Barau ḡena Basileia beiaḡomani vau.” ");
INSERT INTO snc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Benamo Iesu na beredi eḡabiato, evaḡa-namoato, ebuki-ḡutuato, evinirito, ekirato, “Mai tu au tauḡanigu, ḡomi avinimini; maiḡa boḡono veia, au vetuḡamaḡi-iaḡigu ḡana.” ");
INSERT INTO snc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ḡeḡani-ḡosito vau, kapusi ma eḡabiato, ekirato, “Mai kapusi tu Ginitaḡo Variḡuna, au raragu na bevaḡa-moḡoniani, bevebubuni ḡomi vaḡa-maḡurimi ḡana. ");
INSERT INTO snc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Senaḡi au berevaguni tarimana tu mainai au ḡesi taḡani-vegogoni! ");
INSERT INTO snc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Moḡoni, Tarimarima Natuna bemaseni, Barau na ekiraḡi-guineato ilailanai, senaḡi berevaiani tarimana vetuḡana kekei!” ");
INSERT INTO snc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Benamo tauḡeri ḡevedanaḡi-vedanaḡito, ḡia deikara na moḡesi beveiani. ");
INSERT INTO snc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Benamo Iesu ḡena mero tauḡeri ḡeveḡare-veḡareto, deikara ḡia fakari ai barego lelevaḡi. ");
INSERT INTO snc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu na evaḡa-guruḡarito, ekirato, “Irau bese tarimari ḡeri vere na tarimarima ḡedori-naḡinaḡirini, ema veguine-iaḡi tarimari baregori na ḡeri maoro seḡukari na ḡelaunaḡi-naḡirini, ema tarimarima na beḡene vevato-iaḡiri ḡetoni. ");
INSERT INTO snc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Senaḡi ḡomi tu dia moḡesina. Ḡomi fakami ai tau guinena tu tau muriseinai bene iaḡo, ema vere tauna tu vetuḡunaḡi taunai bene iaḡo. ");
INSERT INTO snc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dei tu barego, ḡaniḡani gabunai etanu-taḡoni tarimana ba vetuḡunaḡi tarimana? Ḡaniḡani gabunai etanu-taḡoni tarimana, ene? Senaḡi au tu ḡomi fakami ai vetuḡunaḡi tarimana noḡa. ");
INSERT INTO snc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ḡomi tu au ḡeribaḡaniguto-ḡoi nai, ḡotanu-gwaḡiḡito-ḡoi tarimami. ");
INSERT INTO snc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Moḡa lorinai au Tamagu na maoro eviniguto, Basileia ta au ḡegu ekiraḡiato ilailanai, au maki Basileia ta ḡomi ḡemi akiraḡiani. ");
INSERT INTO snc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Benamo ḡomi maki au ḡegu Basileiai bita ḡaniḡani-vegogoni e bita niuniu-vegogoni, ema ḡomi teronai o vere seari ai boḡo tanuni, Isaraela beseri gabanana ruarua (12) boḡo vaḡa-maoro vinirini.” ");
INSERT INTO snc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simona, Simona o, noseḡaḡi! Au na akiramini, Barau na Satani maoro eviniato, ḡomi bene ribaḡanimi, namo e rakava bene tore-kirari ḡana, noḡa iaraḡa tarimana na widi ema momo etore-kirarini kavana. ");
INSERT INTO snc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Senaḡi au na ḡemu varau aḡuriḡurito, ḡemu veḡabidadama asi bene keto ḡana. Benamo ma bovetuḡamaḡi-ḡenoḡoini au ḡegu ai nai, tarikakamu bono vaḡa-kokoreri.” ");
INSERT INTO snc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero evaḡa-veseto, ekirato, “Vereḡauka, au tu ḡoi ḡesi dibura numai beḡe torerani ema bita mase-vegogoni!” ");
INSERT INTO snc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu ekirato, “Petero, au na akiramuni, toma kokoroku asi begoḡini, beiaḡoni mo, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni, bokirani, ‘Au tu asi ribagu ḡia,’ botoni.” ");
INSERT INTO snc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu na ḡena mero evaḡa-guruḡarito, ekirato, “Au na ḡomi atuḡumito nai, asi ḡemi fusefuse, dura, o tamaka. Ḡomi dagara tai ḡorabuto ba? Ḡia ḡevaḡa-veseto, ḡekirato, “Asiḡina!” ");
INSERT INTO snc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu na ma evaḡa-guruḡarito, ekirato, “Senaḡi toma ḡomi deikara ma ḡena fusefuse ema dura, bene ḡabiri; ema deikara asi ḡena vetari baḡana, ḡena koudi bene voivoi-iaḡia, benamo ta ma bene voia. ");
INSERT INTO snc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Korana au na akiramini, Buka Veaḡa nuḡanai ekirani, ‘Seḡafore tarimari ḡesi beḡe iavi-vegogoani.’ Mo guruḡa au ḡegu ai bemoḡonini.” ");
INSERT INTO snc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iesu ḡena mero ḡevaḡa-veseto, ḡekirato, “Noḡitaia, Vereḡauka, vetari baḡari ruarua maiḡeri.” Iesu evaḡa-veseto, ekirato, “Benamo!” ");
INSERT INTO snc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Benamo Iesu tu vanuḡa barana eraga-kwaneato, Olive Ḡorona ḡana eiaḡoto eveito-ḡoi kavana. Ḡena mero ḡia murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Monai ḡeraḡasito, benamo Iesu na evaḡa-guruḡarito, ekirato, “Boḡono ḡauḡau, be veribaḡani ai asi boḡono moira.” ");
INSERT INTO snc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Benamo ḡereḡana eraka-ḡerevaḡito, fore tafiurini ḡea keto-tarini ḡena manaḡa ilailanai, benamo evetui-tarito, eḡuriḡurito. ");
INSERT INTO snc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ekirato, “Tamagu o, bema nuḡamu ilaila nai, mai midigu bedina au ḡeguna noma ḡabi-vaḡia; senaḡi dia au ḡegu ura, ḡoi ḡemu ura moḡo.”  ");
INSERT INTO snc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Benamo aneru ta guba na emariḡoto, Iesu kokore eviniato. ");
INSERT INTO snc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Midigu barana na ḡia nuḡana evaḡa-vonuato, benamo eḡauḡauto ma nuḡana mabarana ḡesi, eiaḡoto mo, seḡurina tano ai eriḡoto rara kabudona noḡa. ");
INSERT INTO snc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eḡauḡau-ḡosito vau, evariḡisito, ḡena mero ḡeri ai eḡenoḡoi-iaḡoto, genari ai eḡoitaḡorito, dabarari ḡedokoto nai. ");
INSERT INTO snc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Benamo ḡia na evaḡa-guruḡarito, ekirato, “Karase nai ḡomi ḡogenani? Ḡovariḡisi, ḡoḡuriḡuri, be veribaḡani ai asi boḡono moira.” ");
INSERT INTO snc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu roḡo mo eguruḡato-ḡoi nuḡanai, tarimarima ḡutuma ḡeraḡasito, Iudas, mero ta gabanana ruarua (12) fakari ai, ḡia na eḡori-kaurito. Iesu eiaḡo-viniato bene veraua ḡana. ");
INSERT INTO snc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Senaḡi Iesu na ekiraiato, ekirato, “Iudas o, Tarimarima Natuna verau na borevaiani ba?” ");
INSERT INTO snc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iesu sevinai ḡeruḡa-taḡoto merori na ḡeḡitaiato kara beḡorani, benamo ḡedanaḡiato, ḡekirato, “Vetari baḡana na baḡana basiri ba?” ");
INSERT INTO snc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Benamo ḡia ta na Rubu Veaḡa verena baregona ḡena vetuḡunaḡi tarimana vetari baḡana na eiaḡo-viniato, benamo seḡana aroribana ebasi-vaḡiato. ");
INSERT INTO snc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Senaḡi Iesu ekirato, “Benamo, ḡovaḡa-dokoa!” Mo tarima seḡana eḡabi-karaiato, evaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Benamo Iesu ḡabiḡabina ḡeiaḡomato tarimari, Rubu Veaḡa vereri baregori e Rubu Veaḡa ḡitaḡauna tarimari ḡeri baregona ema Iuda vereri ḡia na evaḡa-guruḡarito, ekirato, “Ḡomi boḡo iaḡoma ma ḡemi vetari baḡari e ma ḡemi fato ḡesi, noḡa moḡo seḡafore tarimana ta ḡabiḡabina ḡoro iaḡoma kavana? ");
INSERT INTO snc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ḡaro mabarari ai au tu ḡomi sevimi ai Rubu Veaḡa nuḡanai, senaḡi asi ḡoḡabi-tariguto. Mai tu ḡomi ḡemi nega, mukuna (o Satani) ḡena seḡuka negana.” ");
INSERT INTO snc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Benamo ḡia na Iesu ḡeḡabi-tariato, Rubu Veaḡa verena baregona ḡena numa ḡana ḡeḡori-iaḡoato. Petero maki ḡia murinai erakato, senaḡi ma fakana. ");
INSERT INTO snc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Numa maḡuna nuḡanai tarima kota na karava ḡevaḡa-ḡaraiato, benamo ḡetanu-ḡeḡeraḡiato. Petero maki ḡia seviri ai etanu-tarito. ");
INSERT INTO snc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Benamo vetuḡunaḡi ḡuiatona ta na karava mamanai eḡitaiato, eḡita-karakaraiato, ekirarito, ekirato, “Mai tarima maki Iesu ekavaiato-ḡoi!” ");
INSERT INTO snc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Senaḡi ḡia evekira-ḡuniḡauto, ekirato, “Ḡoi vavine, au tu asi ribagu ḡia!” ");
INSERT INTO snc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nega kotuna evanaḡito nuḡanai, tarima ta na Petero eḡitaiato, ekiraiato, “Ḡoi maki ḡia karori ta!” Senaḡi Petero evaḡa-veseto, ekirato, “Ḡoi tau, au tu asiḡi!” ");
INSERT INTO snc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aoa ta evanaḡito vau, tarima ta ma eguruḡato ma nuḡana mabarana ḡesi, ekirato, “Moḡoni, ḡia maki Iesu ḡesi tarimana ta, korana ḡia maki Galilea tauna!” ");
INSERT INTO snc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Senaḡi Petero evaḡa-veseto, ekirato, “Ḡoi tau, au asi ribagu ḡoi kara okiraḡiani!” Ḡia roḡo mo eguruḡato-ḡoi nuḡanai, kokoroku egoḡito. ");
INSERT INTO snc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Benamo Vereḡauka eruḡa-kureto, ḡia na Petero eḡitaiato nai, Vereḡauka ḡena guruḡa etuḡamaḡi-doḡariato, ekiraiato, “Toma kokoroku asi begoḡini, beiaḡoni mo, ḡoi na au vaḡa-toitoi bokira-ḡuniḡauguni.” ");
INSERT INTO snc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Benamo Petero eraka-rosito, etaḡi-rakava rakavato. ");
INSERT INTO snc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iesu ḡenariḡauato tarimari na ḡevaseva vaseva-iaḡiato e ḡekwariato. ");
INSERT INTO snc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matana ḡekumu-ḡauato, ḡekiraiato, ḡekirato, “Ḡoi tu peroveta tarimana, be nokiraḡia, dei na bekwarimu?” ");
INSERT INTO snc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Guruḡa rakavari ḡutuma ḡia ḡeviniato. ");
INSERT INTO snc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Elaḡanito, Iuda vereri, e Rubu Veaḡa vereri baregori, ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ḡeraka-vegogoto. Iesu ḡeḡori-iaḡoato Iuda kanisoro tarimari ḡoirari ai. ");
INSERT INTO snc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Benamo ḡekiraiato, ḡekirato, “Nokira-varama, ḡoi tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), ba?” Iesu na evaḡa-veserito, ekirato, “Bema au na bakiramini, ḡomi na asi boḡo vaḡa-moḡoniguni, ");
INSERT INTO snc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ema bema vedanaḡi ta bavinimini, asi boḡo vaḡa-veseguni. ");
INSERT INTO snc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Senaḡi toma beiaḡoni mo ḡoira laḡaniri ai, Tarimarima Natuna tu Seḡuka Barauna ḡimana aroribanai betanu-taḡoni.” ");
INSERT INTO snc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Benamo mabarari ḡekirato, “Be, ḡoi tu Barau Natuna otoni?” Ḡia evaḡa-veseto, ekirato, “Ḡomi na ḡokiraḡiani maniḡa.” ");
INSERT INTO snc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ḡia ḡekirato, “Karase vevaḡa-moḡoni tarimari tari roḡo tavetaurini? Ḡia tauḡena muruna na bekiraḡia bita seḡaḡia.” ");
INSERT INTO snc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Benamo vegogo tarimari mabarari ḡevariḡisito, Iesu ḡeḡori-iaḡoato gavana Pilato ḡenai. ");
INSERT INTO snc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Monai ḡeḡofaḡofa-iaḡiato, ḡekirato, “Mai tarima maiḡa baḡa doḡaria, ḡai ḡema bese tarimari eḡorikau-kerererini, ekirani, Kaisara, Roma ḡeri vere, ḡena takesi moniri asi beḡene vinia etoni, ema tauḡena evekiraḡini, ḡia tu Keriso, Barau na ekiraḡi-toreato verena o kinina.” ");
INSERT INTO snc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Benamo Pilato na edanaḡiato, ekirato, “Ḡoi tu Iuda tarimari ḡeri vere ba?” Iesu evaḡa-veseto, ekirato, “Oi, okiraḡiani maniḡa.” ");
INSERT INTO snc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Benamo Pilato na Rubu Veaḡa vereri baregori e tarimarima ḡutuma ekirarito, ekirato, “Kerere ta asi badoḡaria mai tarima ḡenai.” ");
INSERT INTO snc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Senaḡi mo tarimarima roḡo ḡeḡiḡiraḡeto, ḡekirato, “Ḡia ḡena vevaḡa-riba guruḡari na Iudea tarimari mabarari nuḡari evei-veḡonurini. Galileai esinaiato mo beiaḡoma mai gabu ai.” ");
INSERT INTO snc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mo guruḡa eseḡaḡiato nai, Pilato evedanaḡito, ekirato, “Mai tarima tu Galilea tarimana ba?” ");
INSERT INTO snc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Benamo Pilato eribato, Iesu tu Heroda ḡena seḡuka gaburenai nai, Iesu Heroda ḡenai ḡetuḡu-iaḡoato. Ḡia maki Ierusalemai mo ḡaro ai. ");
INSERT INTO snc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda eiaku-rakavato Iesu eḡitaiato nai, korana Heroda na Iesu varina eseḡaḡiato, ema kai-veḡata evaḡa-nogato Iesu bene ḡitaia ḡana. Ḡia eurato Iesu na nuḡa-farevaḡi veiḡari kota bene veiri bene ḡitari. ");
INSERT INTO snc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Moḡa lorinai vedanaḡi ḡutuma Iesu edanaḡiato, senaḡi ḡia asi evaḡa-veseto. ");
INSERT INTO snc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Rubu Veaḡa vereri baregori ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari monai ḡeruḡa-taḡoto-ḡoi, Iesu ḡeḡofaḡofa-iaḡi lelevaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda ema ḡena vetari tarimari o soldia na Iesu ḡerikiriki-iaḡiato-ḡoi, ḡevei-veḡare veḡareato, ema dabuḡa namona ta ḡevaḡa-dabuḡa-iaḡiato, benamo ma ḡetuḡu-ḡenoḡoiato Pilato ḡenai. ");
INSERT INTO snc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato ema Heroda ḡevebaru-vevinito-ḡoi, senaḡi mo ḡaro ai ḡeveḡata-ḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato na Rubu Veaḡa vereri baregori, e Iuda vereri, ema tarimarima mabarari ekea-vegogorito, ");
INSERT INTO snc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ekirarito, ekirato, “Ḡomi na mai tarima boḡo ḡori-iaḡomaia au ḡegu ai, ḡokirani, ḡia na tarimarima eḡorikau-kerererini ḡotoni. Toma au na ḡomi ḡoirami ai ḡemi guruḡa bavetauri, senaḡi kerere ta asi badoḡaria. ");
INSERT INTO snc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroda maki kerere ta asi edoḡariato ḡia ḡenai nai, ma betuḡu-ḡenoḡoi iaḡomaia ḡita ḡerai. Ḡomi na ḡoḡitaiani, ḡia tu rakava ta asi eveiato bene mase ḡana. ");
INSERT INTO snc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Moḡa lorinai au na mai akwariani vau baruḡaiani.”  ");
INSERT INTO snc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vanaḡivanaḡi eveini kavana Pilato na Pasova verekona ḡaronai dibura numai etanuni tarimana ta beruḡaiani. ");
INSERT INTO snc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Senaḡi tarimarima mabarari ḡekoḡo-vegogoto, ḡekirato, “Bono vaḡia! Barabas noruḡaia, novinima!” ");
INSERT INTO snc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tu dibura numai ḡekou-ḡauato, korana vanuḡa barana nuḡanai ḡevevaḡito ema tarima ta ḡevaḡi-maseato nai. ");
INSERT INTO snc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato enuḡa-vekwaraḡito Iesu bene ruḡaia, moḡa lorinai tarimarima ma evaḡa-guruḡa ḡenoḡoirito, ");
INSERT INTO snc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","senaḡi ḡia ma ḡekoḡo-ḡenoḡoi ḡenoḡoito-ḡoi, ḡekirato, “Novaḡa-satauroa, novaḡa-satauroa!” ");
INSERT INTO snc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nega vaḡa-toitoina evaḡa-guruḡarito, ekirato, “Karase nai, kamara rakava mai tarima na eveiato? Au na rakava ta asi aḡoitaḡoani eveiato bene mase ḡana. Moḡa lorinai au na mai akwariani vau baruḡaiani.” ");
INSERT INTO snc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Senaḡi ḡia ḡekoḡoto ma nuḡari mabarari ḡesi, ḡekirato, novaḡa-satauroa; benamo dokonai ḡia ḡeri ura ekwalimuto. ");
INSERT INTO snc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Benamo Pilato na ḡia ḡeri ura eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mo vevaḡi ema vaḡivaḡi dainai dibura numanai etanuto tarimana, eruḡa-fitoḡaiato ḡeri noḡinoḡi ilailanai, a Iesu tu evinirito ḡeri ura veiḡana beḡene veia. ");
INSERT INTO snc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Vetari tarimari na Iesu ḡeḡori-rosiato, benamo ḡeḡori-iaḡoato-ḡoi nai, tarima ta ḡesi ḡevedoḡarito, Simona, Kurene tarimana, ḡia tu gunika na ema raka-rosito vanuḡa barana ḡana eiaḡoto-ḡoi nai, tuari tarimari na ḡeḡabi-tariato, satauro ḡia faḡanai ḡetore-kauato. Ḡia na satauro efaḡaiato, benamo Iesu murina na eiaḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tarimarima ḡutuma tu Iesu murinai ḡerakato. Ḡia vefakari ai tari tu vavine, ḡia tu Iesu taḡina ḡeveito-ḡoi ema ḡetaḡi-guruḡa guruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Benamo Iesu eruḡa-kureto, evaḡa-guruḡarito, ekirato, “Ierusalema vavinemi! Au taḡigu asi ḡotaḡi, senaḡi tauḡemi taḡimi ema natumi taḡiri ḡovei. ");
INSERT INTO snc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Korana ḡaro rakavari beḡe iaḡomani, tarimarima maiḡesi beḡe kirani, ‘Sinaḡe gabani vavineri ema ratari asi ḡerururini vavineri beḡene iaku!’ ");
INSERT INTO snc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Benamo ḡoro baregori beḡe vaḡa-guruḡarini, beḡe kirani, ‘Ḡai iatamai ḡoketokau!’ ema ḡoro keiri beḡe kirarini, ‘Ḡai ḡolautarima!’ ");
INSERT INTO snc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bema au, ḡau maḡurigu, na maiḡesi beḡe veiguni nai tu, ḡomi, ḡau matuḡumi, kamasi beḡe veimini?” ");
INSERT INTO snc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Seḡafore tarimari ruarua maki Iesu ḡesi ḡeḡori-rosirito ḡia ḡesi beḡene vaḡa-sataurori ḡana. ");
INSERT INTO snc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gabu ta arana “Deba Ḡavana” ai ḡeraḡasito. Monai seḡafore tarimari ḡesi ḡevaḡa-satauroato, ta aroribana rekenai, ma ta kaurina rekenai. ");
INSERT INTO snc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu ekirato, “Tamagu o, ḡeri rakava bono tuḡamaḡi-fitoḡari, korana kara ḡeveiani ḡia asi ribari.” Benamo laki ḡerena ta ḡeveiato vau, ḡena dabuḡa ḡevarerito. ");
INSERT INTO snc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tarimarima ḡeruḡa-tarito, ḡe-marereto-ḡoi, ema Iuda tarima baregori na ḡerikiriki-iaḡiato-ḡoi, ḡekirato, “Ḡia na tarima tari evaḡa-maḡuririto, a ḡia tauḡena tu asi bevevaḡa-maḡurini bema ḡia Keriso, Barau na eḡabi-viriḡiato vevaḡa-maḡuri tauna.” ");
INSERT INTO snc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vetari tarimari na maki ḡevaseva-vaseva-iaḡiato, ḡia ḡenai ḡeiaḡoto, vine nanuna mamakina ḡeduḡi-viniato, ");
INSERT INTO snc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","benamo ḡekirato, “Bema ḡoi Iuda tarimari ḡeri vere otoni, ḡoi tauḡemu novevaḡa-maḡuri.” ");
INSERT INTO snc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Toretore ta maki ḡia iatanai ḡetoreato, ekirato: “MAI TU IUDA TARIMARI ḠERI VERE.” ");
INSERT INTO snc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Seḡafore tarimana ta, ḡia ḡesi ḡevaḡa-satauro vegogoato tarimana, na evaneato, ekirato, “Ḡoi tu dia Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna)? Ḡoi tauḡemu novevaḡa-maḡuri, ḡai maki novaḡa-maḡurima!” ");
INSERT INTO snc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ḡia karona na ekira-ḡoiato, ekirato, “Ḡoi Barau garina asi ogarini? Ḡoi maki bomaseni ḡia ilailanai. ");
INSERT INTO snc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dagara sebona, ḡita taura ruarua tamaseni ḡera rakava voiri dainai, senaḡi mai tarima tu asi ḡena vei-rakava.” ");
INSERT INTO snc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Benamo ḡia na Iesu enoḡiato, ekirato, “Iesu, ḡemu Basileia boḡabiani nai, au maki bono tuḡamaḡigu.” ");
INSERT INTO snc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu na evaḡa-veseato, ekirato, “Moḡoni akiramuni, toma ḡaro ai ḡoi tu au ḡesi paradaiso ai.” ");
INSERT INTO snc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ḡaroḡota, horaḡauna 12 koloko varau eḡabiato, ḡaro ḡena seḡuka ekorito, tanobara mabarana mukuna na eḡabi-ḡauato, eiaḡoto mo, horaḡauna 3 koloko. ");
INSERT INTO snc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Benamo Rubu Veaḡa nuḡanai veaḡa lelevaḡi daiḡutuna kouḡauna dabuḡana o ketin evedare-kikimato. ");
INSERT INTO snc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu ekoḡoto, ekirato, “Tamagu o, iaukagu tu ḡoi ḡimamu ai atoreani!” Eguruḡa-ḡosito vau emaseto. ");
INSERT INTO snc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Vetari verena na mo veiḡa eḡitaiato, benamo Barau evaḡa-raḡeato, ekirato, “Moḡoni veḡata, mai tarima tu vei-iobukaiobuka tarimana!” ");
INSERT INTO snc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Marere tarimari ḡutuma na mo veiḡa eḡorato dagarana ḡeḡitaiato, benamo kobari ḡeiafarito, ḡevetuḡamaḡi-rakavato, ḡeri numa ḡana ḡeḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Senaḡi Iesu ḡeribaiato tarimari mabarari, Galilea na ḡia murina na ḡeiaḡomato vavineri maki, manaḡai ḡeruḡato, ḡeḡorato dagarari ḡeḡitarito. ");
INSERT INTO snc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tarima ta arana Iosefa etanuto-ḡoi Iudea vanuḡana Arimatea nuḡanai. Ḡia tu varina namo tarimana ta, Barau ḡena Basileia evaḡa-nogaiato-ḡoi. Ḡia maki Iuda kanisoro tarimana, senaḡi ḡevekira-toreto veiḡana asi eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Benamo Pilato ḡenai eiaḡoto, Iesu tauḡanina bene ḡabi-riḡoa etato. ");
INSERT INTO snc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Moḡa murinai Iesu tauḡanina eḡabi-riḡoato, dabuḡa kurokurona namona na ekumuato, gara gabuna fore ḡebasiato kouḡanai etore-toḡaiato. Mo gara tu variḡuna, nuḡanai mase ta roḡosi beḡere torea. ");
INSERT INTO snc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mo veiḡa tu Fraidei lavilavi ai eḡorato, Sabadi ḡana ḡevei-toreato-ḡoi ḡarona, Sabadi dori eraḡasito nai. ");
INSERT INTO snc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea na Iesu ḡesi ḡeiaḡomato vavineri, Iosefa murina na ḡeiaḡoto, gara kouḡana ema Iesu tauḡanina aiḡesi etore-toḡaiato ḡeḡitaiato. ");
INSERT INTO snc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Benamo ḡeḡenoḡoito Ierusalema sitina ḡana, muramura ma bonari ema daudau muramurari ḡeḡabi-torerito. Sabadi ai ḡeiaḡaraḡito taravatu ekirani lorinai. ");
INSERT INTO snc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fura ḡarona giniguinenai o Sandei ai, vavine tu boḡiboḡi iamoiamonai gara ḡana ḡeiaḡoto, muramura bonari namori ḡerovina-torerito dagarari ḡeḡwa-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gara kouḡana forena tu kure-veḡita, irau ai vetore ḡeḡitaiato. ");
INSERT INTO snc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gara kouḡana na ḡeraka-toḡato, senaḡi Iesu Vereḡauka tauḡanina tu asi ḡedoḡariato. ");
INSERT INTO snc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ḡia roḡo mo ḡedaradarato-ḡoi nuḡanai, tau ruarua ḡia seviri ai ḡeruḡa-tarito, ḡeri dabuḡa tu kuro-ḡaroḡarori. ");
INSERT INTO snc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vavine tu ḡegari-rakavato, tano ai ḡetutuḡu-tarito, benamo mo tarima na ḡevaḡa-guruḡarito, ḡekirato, “Karase nai maḡuri tarimana mase gabunai ḡovetauani? ");
INSERT INTO snc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ḡia tu dia mainai; mase na ma bevariḡisi-ḡenoḡoi. Galileai etanuto-ḡoi nai, evaḡa-guruḡamito guruḡana boḡono tuḡamaḡia, ");
INSERT INTO snc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ekirato, ‘Tarimarima Natuna tu rakava tarimari ḡeri ai beḡe revaiani, beḡe vaḡa-satauroani, ḡaro vaḡa-toitoinai vau ma bevariḡisi-ḡenoḡoini.’” ");
INSERT INTO snc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Benamo vavine na mo guruḡa ḡetuḡamaḡi-doḡariato. ");
INSERT INTO snc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gara ḡeraga-kwaneato, ḡeḡenoḡoito, mo dagara eḡorato dagarana varina mabarana Iesu ḡena mero gabanana sebona (11) ma karori ḡesi ḡekira-vararito. ");
INSERT INTO snc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vavineri tu maiḡeri: Maria, Magadala vavinena, e Ioana, e Maria, Iakobo (o Iames) sinana, ema karori tari maki. Ḡia na mai vari Iesu ḡena apostolo tarimari ḡeri ḡekiraḡito. ");
INSERT INTO snc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Senaḡi vavine ḡeri guruḡa asi ḡevaḡa-moḡonirito, korana apostolo ḡetuḡamaḡito, ḡia noḡa ḡeguruḡa-babobaboto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Senaḡi Petero tu evariḡisito, eraga-iaḡoto, gara kouḡanai ea boḡe-toḡato, senaḡi Iesu ḡekumuato dabuḡari moḡo eḡitarito. Benamo numa ḡana eḡenoḡoi-iaḡoto nuḡanai, ḡeḡorato dagarari etuḡamaḡirito nai, eḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mo ḡaro sebonai Iesu ḡena mero ruarua tu Emausa vanuḡana ḡana ḡeiaḡoto; mo gabu ḡena manaḡa Ierusalema na tu 11 kilomita kavana. ");
INSERT INTO snc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ḡerakato-ḡoi nuḡanai, ḡeḡorato dagarari ḡeguruḡa-guruḡa iaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ḡeri raka guruḡa-guruḡai Iesu maki eraka-kavi-iaḡoto, ḡia ḡesi ḡeraka-iaḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Senaḡi tauri ruarua asi ḡeribato ḡia tu dei. ");
INSERT INTO snc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu na edanaḡirito, ekirato, “Ḡomi tu kara mai dabarai ḡoraka-guruḡa guruḡa-iaḡiani?” Benamo tauri ruarua ḡeruḡa-tarito, ḡeboḡe-vetuḡato. ");
INSERT INTO snc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Benamo ḡia ta, arana Kleopa, na evaḡa-veseato, ekirato, “Ierusalema ḡana ḡeiaḡomato tarimari fakari ai betaḡu ḡoi moḡo ḡereḡamu mainai beḡe ḡora dagarari asi ribamu?” ");
INSERT INTO snc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu evedanaḡito, ekirato, “Kamara dagara?” Ḡia ḡevaḡa-veseto, ḡekirato, “Iesu, Nasareta tarimana, ḡenai ḡeḡorato dagarari. Ḡia tu peroveta tarimana, Barau ḡoiranai e tarimarima mabarari ḡoirari ai ḡena veiḡa ema ḡena guruḡa maki ma seḡukari. ");
INSERT INTO snc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ḡita ḡera Rubu Veaḡa vereri baregori ema ḡera veḡorikau tarimari na ḡerevaiato bene mase ḡana, ḡevaḡa-satauroato. ");
INSERT INTO snc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Senaḡi ḡai ḡatuḡamaḡito, ḡia na Isaraela tarimari bevaḡa-maḡuririni. Mai dagara eḡorato beiaḡoma toma tu varau ḡaro toitoi beḡe iaḡo. ");
INSERT INTO snc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Moḡa iatanai, ḡema vavine tari na ḡai nuḡama beḡe vaḡa-farevaḡiri. Ḡia tu boḡiboḡi iamoiamonai gara ḡana beḡe iaḡo. ");
INSERT INTO snc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Senaḡi tauḡanina asi beḡe doḡaria. Benamo beḡe ḡenoḡoi-iaḡoma, beḡe kira tu, aneru beḡe ḡitari, mo aneru na beḡe kirari, ‘Ḡia tu varau bemaḡuri-ḡenoḡoi,’ beḡesi. ");
INSERT INTO snc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ḡai karoma tari maki gara ḡana beḡe iaḡo, vavine na beḡe kiraḡia kavana beḡe doḡaria, senaḡi Iesu asi beḡe ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Benamo Iesu na ekirarito, ekirato, “Ḡomi tu babo, peroveta tarimari ḡeri guruḡa vaḡa-moḡoniri ai maki kwaibo rakava! ");
INSERT INTO snc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso tu moḡesi bene midigu-midigu murinai vau, mareva namonai bene raka-toḡa, ene?” ");
INSERT INTO snc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Benamo ḡia varina Mose e peroveta tarimari ḡeri bukai ema Buka Veaḡa mabarana maki ḡetorerito guruḡari aniri evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ḡeiaḡo-viniato-ḡoi vanuḡana Emausa ḡekavinaḡiato, benamo ḡia tu bene raka-vanaḡi etato. ");
INSERT INTO snc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Senaḡi ḡekira-ḡoiato, ḡekirato, “Ḡai ḡesi notanu, korana belavilavi ema ḡaro maki mai emukunani bene.” Benamo ḡia ḡesi ḡeraka-toḡato, ḡetanuto. ");
INSERT INTO snc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ḡaniḡani gabunai ḡetanu-taḡoto-ḡoi nai, Iesu na beredi eḡabiato, evaḡa-namoato, edudu-ḡutuato, tauri ruarua evinirito. ");
INSERT INTO snc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Benamo matari ḡevekeoto, ḡeribato mo tu ḡia. Senaḡi ḡia tu ḡoirari ai erekwa-rekwato. ");
INSERT INTO snc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Benamo tauri ruarua ḡeveguruḡa-vevinito, ḡekirato, “Dabarai evaḡa-guruḡarani-ḡoi nai, ema Buka Veaḡai ḡetorerito guruḡari aniri ḡera ekiraḡi-maḡatarini-ḡoi nai, ḡita nuḡara tu ḡeseḡuseḡuni-ḡoi, noḡa moḡo karava na ḡeḡararini-ḡoi, ene?” ");
INSERT INTO snc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Benamo maoromaoro ḡevariḡisito, Ierusalema ḡana ma ḡeḡenoḡoi-iaḡoto, Iesu ḡena mero gabanana sebona (11) ma karori ḡesi vegogo-taḡori ai ḡedoḡaririto. ");
INSERT INTO snc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ḡia na tauri ruarua ḡevaḡa-guruḡarito, ḡekirato, “Moḡoni veḡata, Vereḡauka tu bevariḡisi-ḡenoḡoi ema Simona ḡenai maki efoforito.” ");
INSERT INTO snc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Benamo tauri ruarua na dabarai eḡorato dagarana ema kamasi Iesu na beredi edudu-ḡutuato vauro, Iesu ḡia na ḡeḡita-leaiato ḡeri ḡekiraḡito. ");
INSERT INTO snc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mo tarima ruarua roḡo ḡeguruḡato-ḡoi nuḡanai, Vereḡauka ḡia fakari ai eruḡa-rosito, benamo ekirarito, ekirato, “Maino ḡemi ai bene tanu.” ");
INSERT INTO snc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ḡia tu nuḡari maki ḡefarevaḡi-rakavato ema ḡegarito, ḡia mataboru ḡekirato, murava ta ḡeḡitaiato. ");
INSERT INTO snc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Senaḡi ḡia ekirato, “Karase nai nuḡami beḡe vekwaraḡi-rakava? Kara dainai ḡodaradarani? ");
INSERT INTO snc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ḡimagu ema kwakugu ḡoma ḡitari, benamo boḡono riba mai tu au. Ḡoma ḡabi-karagu, benamo boḡono riba, korana murava tu asi viriḡona ema asi turiḡana, ḡoḡitaguni au tu ma viriḡogu e ma turiḡagu.” ");
INSERT INTO snc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Moḡesi ekirato, benamo ḡimana ema kwakuna evaḡa-ḡitarito. ");
INSERT INTO snc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Senaḡi ḡia tu roḡo ḡedaradarato-ḡoi ḡeri iaku ema ḡeri nuḡa-farevaḡi dainai; benamo Iesu na edanaḡirito, ekirato, “Ḡaniḡani tari maniḡeri ba?” ");
INSERT INTO snc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ḡia na maḡani-kone gabugabuna ta ḡeviniato. ");
INSERT INTO snc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Benamo Iesu na eḡabiato, ḡoirari ai eḡaniato. ");
INSERT INTO snc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Benamo evaḡa-guruḡarito, ekirato, “Au tu roḡo ḡomi ḡesi tatanu-vegogoto-ḡoi nai, akiramito-ḡoi: Mose ḡena taravatu e peroveta tarimari ḡeri guruḡa ema Salamo ai au varigu ḡetorerito guruḡari mabarari beḡe moḡonini.” ");
INSERT INTO snc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Benamo Iesu na nuḡari ekeorito, Buka Veaḡa guruḡari aniri beḡene tuḡamaḡi-fakari ḡana. ");
INSERT INTO snc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma ekirarito, ekirato, “Maiḡesi ḡetoreato: Keriso tu moḡesi roḡo bemidigu-midiguni, ema ḡaro vaḡa-toitoinai mase na ma bevariḡisi-ḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ema ḡia aranai vetuḡamaḡi-kure ema rakava tuḡamaḡi-fitoḡari beḡene ḡobata-iaḡi-rovorovori tanobara mabarari ai, Ierusalema na bene vematama. ");
INSERT INTO snc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mai dagara vaḡa-moḡoniri tarimami tu ḡomi. ");
INSERT INTO snc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Au tauḡegu na tu Tamagu na ekiraḡi-toreato Iaukana batuḡuani, iatami ai befoforini. Ḡomi tu Ierusalemai boḡono tanu, bene iaḡo mo, guba na bemariḡoni seḡukana boḡo ḡabiani.” ");
INSERT INTO snc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Moḡa murinai Iesu na Ierusalema na eḡori-rosirito, ḡeiaḡoto mo, Betania ḡana, benamo ḡimana eḡabi-vaisirito, evaḡa-namorito. ");
INSERT INTO snc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Evaḡa-namorito-ḡoi nuḡanai, Iesu tu ḡia ḡerina eveḡitato, Barau na eḡabi-varaḡeato guba ḡana. ");
INSERT INTO snc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ḡia na ḡetoma-rakariḡo viniato murinai, ma iakuri e ma verereri ḡesi Ierusalema ḡana ma ḡeḡenoḡoi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Benamo Rubu Veaḡai ḡetanuto-ḡoi, Barau ḡevaḡa-raḡeato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tovotovonai veḡata Guruḡa etanuto-ḡoi. Mo Guruḡa tu Barau ḡesi ḡetanuto-ḡoi, ema mo Guruḡa tu Barau. ");
INSERT INTO snc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ḡia tu tovotovona na veḡata Barau ḡesi ḡetanuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dagara mabarari tu Barau na ḡia ḡenana eveirito. Ma Barau na dagara sebona kwariḡutu ta maki dabara borunai ta maki asi eveiato, asiḡina ḡinavaḡi. ");
INSERT INTO snc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maḡuri tu ḡia nuḡanai etanuni; mo maḡuri tu tarimarima ḡeri mama. ");
INSERT INTO snc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mama tu mukuna nuḡanai emamani, senaḡi mukuna na asi etuḡamaḡi-fakaiato e asi eḡita-leaiato. ");
INSERT INTO snc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Barau na tarima ta etuḡuato, arana tu Ioane. ");
INSERT INTO snc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ḡia tu guruḡa moḡonina kiraḡi-kiraḡina ema mama vaḡa-foforina ḡana eiaḡomato. Be ḡia ḡenana tarimarima mabarari na vari beḡene seḡaḡia e beḡene vaḡa-moḡonia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ḡia tauḡena tu dia mo mama, senaḡi ḡia eiaḡomato tu, mama benema kiraḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mo mama tu mama korikorina, tanobara ḡana eiaḡomato, tarimarima mabarari mama benema viniri ḡana. ");
INSERT INTO snc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Guruḡa tu tanobarai etanuto-ḡoi, ema mo guruḡa ḡenana Barau na tanobara eveiato, senaḡi tanobara na tu asi eribaiato. ");
INSERT INTO snc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ḡia tu ḡena tanobara ḡana eiaḡomato, senaḡi ḡena tarimarima na asi ḡeḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A tarimarima kotari na ḡeḡabi-raḡeato e ḡevaḡa-moḡoniato nai, ḡia na maoro evinirito, Barau natunai beḡene iaḡo. ");
INSERT INTO snc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ḡia Barau natunai ḡeiaḡoto tu dia tauḡanina ḡenana. Mo tu dia sina tama rarari na o tauḡani ḡena urai o sina tama ḡeri urai. Asiḡi, tarimarima tu Barau tauḡena ḡereḡana na moḡo ḡia natunai evaḡa-iaḡorini. ");
INSERT INTO snc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mo Guruḡa tu tarimarima tauḡaninai eiaḡoto, benamo ḡai fakamai ema tanuto. Ḡia marevana e seḡukana baregona ḡaḡitaiato. Moḡa tu Barau na Natuna sebona kwariḡutu eviniato marevana e seḡukana. Varevare-bara ema guruḡa e maḡuri moḡonina na evonuvonu-raḡeto. ");
INSERT INTO snc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioane na ḡia guruḡana ekiraḡi-foforiato, ekeato, ekirato, “Au na akiraḡiato tarimana tu maiḡa, akirato, ‘Au murigu na beiaḡomani tarimana na au evanaḡiguto. Korana tu au maki roḡosi roḡo bana maḡuri nuḡanai veḡata, ḡia tu etanuto-ḡoi.’” ");
INSERT INTO snc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ḡia tu varevare-bara na evonuvonu-raḡeto. Mo ḡena varevare-bara lorinai ḡita mabarara vevaḡa-namo iatai-iatai maki evinirani. ");
INSERT INTO snc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Korana Barau na Mose ḡenana taravatu evinirato, a varevare-bara ema guruḡa e maḡuri moḡonina tu Iesu Keriso na eḡwa-iaḡomarito. ");
INSERT INTO snc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tovotovona na veḡata beiaḡoma maitoma tarima ta na Barau asi eḡitaiato. Natuna ḡora ḡereḡa, Tamana sevinai etanuni tarimana, ḡia na Barau ema vaḡa-foforiato. ");
INSERT INTO snc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ioane ḡena guruḡa-fofori tu maiḡa. Iuda tarimari na Rubu Veaḡa vereri e Levi doḡorona tarimari, (mai tu Rubu Veaḡai vetuḡunaḡi tarimari), kotari Ierusalema na Ioane ḡenai ḡetuḡu-iaḡorito, beḡene danaḡia ḡana, beḡene kira, “Ḡia tu deikara?” ");
INSERT INTO snc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Benamo Ioane asi evekira-ḡuniḡauto, senaḡi ḡoirari ai eguruḡa-foforito, ekirato, “Au tu dia Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna).” ");
INSERT INTO snc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma ḡedanaḡiato, ḡekirato, “Ba ḡoi tu deikara? Ḡoi tu Elia ba?” Ḡia ekirato, “Au tu dia Elia.” Ma ḡekirato, “Ḡai na peroveta tarimana ḡanariani tarimana tu ḡoi ba?” Ḡia evaḡa-veseto, ekirato, “Asiḡina!” ");
INSERT INTO snc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Benamo ḡia na ma ḡedanaḡi-ḡenoḡoiato, ḡekirato, “Ba ḡoi tu deikara? Ḡemu vevaḡa-vese novini-ginikauma, be beḡe tuḡuma tarimari ḡeri ai baḡana iaḡo, baḡana vaḡa-ribari. Ḡoi tauḡemu varimu tu aiḡesi?” ");
INSERT INTO snc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Benamo Ioane tauḡena evevari-fiuto, ekirato, “Au tu garo ta tano fakanai ekea-koḡokoḡoni, ekirani, ‘Vereḡauka ḡena dabara boḡono iareva-toretorea.’” Isaia peroveta tarimana na ekiraḡi-guineato ilailana. ");
INSERT INTO snc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mo vetuḡu ḡeiaḡo-viniato tarimari tu Farisea tarimari. ");
INSERT INTO snc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Benamo Ioane ḡedanaḡiato, ḡekirato, “Bema ḡoi tu dia Keriso, e dia Elia, e dia mo peroveta tarimana, karase nai ḡoi tu ovevaḡa-babatisoni?” ");
INSERT INTO snc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioane evaḡa-veseto, ekirato, “Au tu nanu na moḡo ababatisoni, senaḡina tarima ta tu ḡomi fakami ai eruḡa-taḡoni, ma ḡomi tu asi ribami ḡia. ");
INSERT INTO snc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ḡia tu au murigu na eiaḡomani, ema au tu asi ilaila, ḡia ḡena tamaka varori baruḡarini.” ");
INSERT INTO snc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mai dagara mabarari tu Betania, Ioridana ḡarukana mo rekenai, ḡeḡorato, Ioane ebabatisoto-ḡoi gabunai. ");
INSERT INTO snc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ma elaḡanito nuḡanai, Ioane na Iesu eḡitaiato, ḡia ḡenai eiaḡomato-ḡoi, benamo ekirato, “Ḡoboḡe, mani tu Barau ḡena Mamoe Natuna, ḡia na tanobara ḡena rakava beḡabi-vaḡiani. ");
INSERT INTO snc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Au na tu ḡia akiraḡiato, akirato, ‘Au murigu na eiaḡomani tarimana na evanaḡiguto, korana tu au roḡosi roḡo bara maḡuri nuḡanai veḡata, ḡia tu etanuto-ḡoi.’ ");
INSERT INTO snc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tovo-tovonai au tu asi ribagu ḡia, senaḡi au aiaḡomato nanu na ababatisoni, korana tu Isaraela tarimari na Iesu beḡene ribaia ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Benamo Ioane ma eguruḡa-foforito, ekirato, “Iauka aḡitaiato, guba na emariḡoto pune noḡa, ḡia iatanai etanukauto. ");
INSERT INTO snc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tovotovonai au tu asi ribagu ḡia, senaḡi Barau na etuḡuguto, bana iaḡoma tu, tarimarima nanu na bana babatisori ḡana. Ḡia na evaḡa-guruḡaguto, ekirato, ‘Ḡoi na tarima ta boḡitaiani, Iauka bemariḡoni, iatanai betanu-kauni. Mo tau tu tarimarima Iauka Veaḡa na bebabatisorini.’” ");
INSERT INTO snc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ioane ekirato, “Au na aḡitaiato naima akiraḡi-foforiani, ḡia tu Barau Natuna.” ");
INSERT INTO snc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma elaḡanito nai tu, Ioane e ḡena mero ruarua ḡesi monai ma ḡeruḡa-taḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ḡeruḡa-taḡoto-ḡoi nuḡanai tu, Iesu eraka-vanaḡito, eḡitaiato, benamo ekirato, “Ḡoboḡe, Barauna Mamoe Natuna, (ḡena ginitaḡo mamoena), ḡoḡitaia.” ");
INSERT INTO snc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma Ioane ḡena mero ruarua na mo guruḡa ḡeseḡaḡiato, benamo Iesu murina na ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu eruḡa-kureto, ma murinai ḡerakakauto tarimari ruarua eḡitarito, benamo edanaḡirito, ekirato, “Ḡomi tu kara ḡourani?” Ḡia ḡevaḡa-veseto, ḡekirato, “Rabi, ḡoi tu ainai otanuni?” Rabi anina tu vevaḡa-riba tarimana. ");
INSERT INTO snc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ḡia evaḡa-veseto, ekirato, “Ḡoiaḡoma, ḡoma ḡitaia.” Benamo ḡia ḡesi ḡeiaḡoto, ma ḡena tanu gabuna ḡea ḡitaiato, mo ḡaro vinubana tu ḡia ḡesi ḡebukato. Mo tu horaḡauna 4 koloko lavilavi rekenai. ");
INSERT INTO snc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ioane ḡena guruḡa ḡeseḡaḡiato, benamo Iesu murinai ḡerakato tarimana ta tu Anduru, Simona Petero tarina. ");
INSERT INTO snc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anduru na Iesu eraga-kwaneato. Asikauna kakana Simona edoḡariato, benamo ekiraiato, ekirato, “Ḡai na Mesia baḡa doḡaria.” Mesia anina tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tarimana). ");
INSERT INTO snc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Benamo ḡia na Simona Iesu ḡenai eḡori-iaḡoato. Iesu na eḡitaiato, benamo ekirato, “Ḡoi aramu tu Simona, Ioane natuna, senaḡi ḡoi toma aramu beḡe kiraḡiani tu Kefas beḡe toni.” Mai ara “Kefas” ema “Petero” aniri tu sebona, garo ai anina tu “Fore”. ");
INSERT INTO snc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ma elaḡanito nai tu, Iesu tu Galilea tanona ḡana neiaḡo etato. Ḡia na Filipo edoḡariato, benamo ekiraiato, ekirato, “Murigu ai noma raka.” ");
INSERT INTO snc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo tu Betesaida tarimana, Anduru e Petero ḡesi vanuḡa sebona. ");
INSERT INTO snc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo na Natanaela edoḡariato, benamo ekiraiato, ekirato, “Mose ḡena taravatu ai ema peroveta tarimari ḡeri bukai varina ḡetoreato tarimana tu baḡa doḡaria; ḡia tu Iesu, Nasareta tarimana, Iosefa natuna.” ");
INSERT INTO snc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaela evedanaḡito, ekirato, “Nasareta na dagara namona ta beiaḡomani?” Filipo ekirato, “Noiaḡoma, noma ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu na Natanaela eḡitaiato, eiaḡomato-ḡoi, benamo ḡia ekiraḡiato, ekirato, “Ḡoboḡe, mani tarima tu Isaraela tarimana korikorina, ḡia ḡenai ḡofaḡofa ta tu asi etanuni.” ");
INSERT INTO snc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaela na edanaḡiato, ekirato, “Kamasi boribagu?” Iesu na evaḡa-veseato, ekirato, “Filipo tu vau bekeamu. Au na ḡoi tu baḡita-guinemu figi ḡauna gaburenai roḡo otanuto-ḡoi nai.” ");
INSERT INTO snc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Benamo Natanaela na evaḡa-veseato, ekirato, “Vevaḡa-riba tarimamu, ḡoi tu Barau Natuna; ḡoi tu Isaraela Verena.” ");
INSERT INTO snc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu na ma evaḡa-veseato, ekirato, “Ḡoi na au ovaḡa-moḡoniguni, korana au na bakira-varamu, ḡoi tu figi ḡauna gaburenai baḡita-guinemu, nene? Veiḡa tari vau boḡitarini, mai veiḡa maiḡa maki beḡe vanaḡiani.” ");
INSERT INTO snc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Benamo ma ekirarito, ekirato, “Moḡoni veḡata, au na ḡomi akiramini, guba bevekeo-fakani boḡo ḡitaiani, ema Barau ḡena aneru beḡe varaḡeni e beḡe mariḡoni boḡo ḡitarini Tarimarima Natuna ḡenai.” ");
INSERT INTO snc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ḡaro ruarua ḡekorito murinai, Kana vanuḡana nuḡanai veḡaraḡo verekona ta ḡeveiato. Kana vanuḡana tu Galilea tanona nuḡanai. Mo veḡaraḡo verekona nuḡanai tu Iesu sinana maki monai. ");
INSERT INTO snc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ema Iesu ma ḡena mero ḡesi maki ḡeura-maḡirito, be mo veḡaraḡo verekona nuḡanai ḡeraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vine nanuna o wain ekorito, benamo Iesu sinana na Iesu evaḡa-guruḡaiato, ekirato, “Ḡia tu asi ḡari vine nanuna.” ");
INSERT INTO snc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu na evaḡa-veseato, ekirato, “Vavine, karase nai au oma kira-varaguni? Mani tu ḡomi ḡemi ḡauvei. Au ḡegu ḡaro tu roḡosi bene votu. ");
INSERT INTO snc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Benamo sinana na vetuḡunaḡi tarimari evaḡa-guruḡarito, ekirato, “Kara bekira-varamini veiḡana boḡono veia.” ");
INSERT INTO snc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Monai tu fore gwaḡuturi imaima sebona (6) vaḡa-ruḡa, Iuda tarimari ḡeri veiareva veiḡari ḡari ḡeḡauvei-iaḡirito-ḡoi. Mo fore gwaḡuturi tata nuḡari tauri galon gabana ruarua (20) o gabana toitoi (30) kavari. ");
INSERT INTO snc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu na vetuḡunaḡi tarimari ekirarito, ekirato, “Mani gwaḡutu nanu na ḡovaḡa-vonuri!” Benamo ḡevaḡa-vonu fokafokarito. ");
INSERT INTO snc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Moḡa murinai ma ekirarito, ekirato, “Kota ḡoḡutu-vaḡia, ḡoḡwa-iaḡoa vereko ḡorikauna tarimana ḡenai.” Ḡeḡutu-vaḡito, benamo ḡeḡwa-iaḡoato, ");
INSERT INTO snc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","vereko ḡorikauna tarimana na mo nanu, vine nanunai evaḡa-iaḡoato moḡa, eniu-tovoato. Ḡia tu asi ribana mo vine nanuna tu ainana eiaḡomato; a nanu ḡesisiato merori ḡereḡari moḡo ma ribari. Benamo vereko ḡorikauna tarimana na veḡaraḡo variḡu tauna ekea-iaḡomaiato, benamo evaḡa-guruḡaiato, ekirato, ");
INSERT INTO snc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Tarimarima mabarari na vine nanuna namo vedaureana tu ḡetore-rosi guineani, benamo vereko tarimari ḡeniu-maseni murinai vau, vine nanuna kota namo raḡina ma ḡetore-rosiani. Senaḡina ḡoi na tu vine nanuna namo vedaureana tu boḡabi-taria mo maitoma.” ");
INSERT INTO snc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mai tu Iesu ḡena vetoḡa boruna giniguinena evaḡa-foforiato Kana vanuḡanai, Galilea tanona nuḡanai. Monana ḡia marevana e seḡukana baregona evaḡa-foforiato, ema ḡena mero na ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Moḡa murinai Iesu ma sinana e tarina merori, ema ḡena mero ḡesi ḡevariḡoto Kaperanauma ḡana. Ma monai ḡaro viravira ta ḡetanuto. ");
INSERT INTO snc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda tarimari ḡeri Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona ḡoirai ekavinaḡito naima, Iesu tu Ierusalema ḡana evaraḡeto. ");
INSERT INTO snc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rubu Veaḡa nuḡanai tarimarima na boromakau, e mamoe, ema pune ḡevoivoi-iaḡirito-ḡoi, ema tarima kotari teibolo ai ḡetanuto ma moni ḡesenisito-ḡoi edoḡaririto. ");
INSERT INTO snc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Benamo varo kwarina ta evatoato. Monana Rubu Veaḡa na mamoe e boromakau mabarari ema lailai-rosirito. Moni ḡesenisirito-ḡoi tarimari ḡeri fata eḡuke-vebuburito, ḡeri moni ebubu-lausilausirito. ");
INSERT INTO snc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Benamo pune ḡevoito-ḡoi tarimari ekira-ḡoirito, ekirato, “Maiḡeri dagara mainana ḡoḡabi-rosiri! Au Tamagu ḡena numa tu voivoi numanai asi ḡovaḡa-iaḡoa!” ");
INSERT INTO snc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Benamo ḡena mero na Buka Veaḡai evetoreto guruḡana ḡetuḡamaḡi-doḡariato, ekirani, “Ḡoi ḡemu numa uravinina nuḡagu ai tu karava noḡa eḡarani.” ");
INSERT INTO snc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Moḡa murinai Iuda tarimari na ḡevaḡa-guruḡaiato, ḡekirato, “Maiḡesi oveini anina tu kara? Kamara vetoḡa na bevaḡa-foforimuni ḡai ḡemai, ḡoi tu ma ḡemu maoro maiḡeri boveirini?” ");
INSERT INTO snc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu evaḡa-veseto, ekirato, “Mai Rubu Veaḡa ḡorovoa, benamo ḡaro toitoi nuḡanai au na ma bana vaḡa-ruḡa-vaisi ḡenoḡoia.” ");
INSERT INTO snc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ḡia na ḡekiraiato, ḡekirato, “Mai Rubu Veaḡa tu laḡani gabana vasivasi ma imaima sebona (46) nuḡari ai ḡeragaiato. A ḡoi na tu ḡaro toitoi nuḡanai ma boraga-ḡenoḡoiani otoni?” ");
INSERT INTO snc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Senaḡi Iesu na tu ḡia tauḡanina Rubu Veaḡai evaḡa-ilailaiato. ");
INSERT INTO snc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesu mase na evaisi-raḡeto murinai, ḡena mero na mo guruḡa ḡetuḡamaḡi-doḡariato, benamo ḡia na Buka Veaḡa ema Iesu na evaḡa-ribarito guruḡari ḡevaḡa-moḡonirito. ");
INSERT INTO snc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesu Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona ḡarori ai Ierusalemai etanuto-ḡoi nai, tarima vovoka na ḡevaḡa-moḡoniato, korana tu vetoḡa boruri ḡutuma eveirito ḡeḡitarito nai. ");
INSERT INTO snc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Senaḡi Iesu na ḡia asi evaḡa-moḡonirito, korana tarimarima mabarari ḡia tu ma ribana ginikau. ");
INSERT INTO snc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ema tarima ta tu asi ilaila ḡia tarimarima ḡeri maḡuri dabarari bekira-varaiani, korana tarimarima mabarari nuḡari tu ḡia ma ribana. ");
INSERT INTO snc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisea tarimana ta etanuto-ḡoi arana Nikodemo; ḡia tu Iuda tarimari ḡeri veḡorikau tauna ta. ");
INSERT INTO snc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nega ta boḡi ai Iesu ḡenai eiaḡoto, benamo ekirato, “Rabi, ḡai ribama, ḡoi tu vevaḡa-riba tarimamu, Barau ḡenana oiaḡomato, korana tu vetoḡa boruri oveirini maiḡeri tu Barau na asi evaḡa-kavaiani tarimana na tu asiḡina ḡinavaḡi beveirini riba.” ");
INSERT INTO snc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu na evaḡa-veseato, ekirato, “Moḡoni veḡata akiramuni, asi beḡora-ḡenoḡoini tarimana na Barau ḡena Basileia tu asiḡina ḡinavaḡi beḡitaiani.” ");
INSERT INTO snc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Benamo Nikodemo na edanaḡiato, ekirato, “Tarima baregona ta tu kamasi ma beḡora-ḡenoḡoini? Sinana nuḡanai ma beraka-toḡani, benamo ma beḡora-ḡenoḡoini?” ");
INSERT INTO snc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu ma evaḡa-veseto, ekirato, “Au na akira-korikorimuni, tarima ta Barau ḡena Basileia nuḡanai asi berakatoḡa-kavani, senaḡina nanu ḡenana beḡorani ema Iauka ḡenana maki beḡorani tarimana vau beraka-toḡani. ");
INSERT INTO snc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tarimarima tauḡanina ḡenana eḡorani tu tauḡani, ma Barau Iaukana ḡenana eḡorani tu iauka. ");
INSERT INTO snc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ḡoi nuḡamu asi bene farevaḡi maiḡesi akiramuni nai, korana au bakira, ‘Ḡomi mabarami boḡono ḡora-ḡenoḡoi.’ ");
INSERT INTO snc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iavara etoḡani tu, eurani gaburi ḡana eḡau-iaḡoni. Guruna tu ḡoseḡaḡiani, senaḡi ainana eiaḡomani, ma aiḡana eiaḡoni tu asi ḡoribaiani. Barau Iaukana ḡenana ḡeḡorani tarimari mabarari maki moḡesina, asi ḡoribani kamasi ḡeḡorani.” ");
INSERT INTO snc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ma evedanaḡito, ekirato, “Mai dagara tu kamasi beḡe ḡorani?” ");
INSERT INTO snc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu ma evaḡa-veseto, ekirato, “Ḡoi tu Isaraela ḡeri vevaḡa-riba tarimamu, senaḡi maiḡeri dagara ḡoi tu asi ribamu? ");
INSERT INTO snc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Au na akira-korikorimuni, ḡai tu ribama dagarari ḡaguruḡa-iaḡirini, ema ḡaḡitarito dagarari ḡakiraḡi-foforirini, senaḡina ḡema guruḡa tu asi ḡoḡabi-raḡerini. ");
INSERT INTO snc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Au na ḡomi ḡemi tu tanobara dagarari akiraḡirini, senaḡi asi ḡovaḡa-moḡoniguni, a guba dagarari bakira-varamini nai tu, kamasi boḡo vaḡa-moḡoniguni? ");
INSERT INTO snc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tarima ta guba ḡana asiḡina ḡinavaḡi evaraḡeto, senaḡina guba na emariḡoto tarimana ḡereḡana moḡo, mo tu Tarimarima Natuna. ");
INSERT INTO snc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mose na tano fakanai mota eḡabi-vaisiato ilailanai, Tarimarima Natuna maki moḡesi beḡe ḡabi-vaisiani. ");
INSERT INTO snc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Monana vau ḡia ḡenai beḡe veḡabidadamani tarimari mabarari na maḡuri vanaḡivanaḡi beḡe ḡabiani. ");
INSERT INTO snc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Korana Barau na tanobara euravini-baregoato nai, Natuna ḡora ḡereḡa evinirato, be ḡia beḡe ḡabidadama-viniani tarimari mabarari tu asi beḡe maseni, a maḡuri vanaḡivanaḡi beḡe ḡabiani. ");
INSERT INTO snc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Korana Barau na Natuna etuḡu-mariḡoato tanobara ḡana tu, dia tanobara bene vaḡa-kotaia ḡana, senaḡi tanobara ḡia bakunai bene maḡuri ḡana. ");
INSERT INTO snc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ḡia ḡenai eveḡabidadamani tarimana tu meto asi beviniani, senaḡi asi eveḡabidadamani tarimana tu varau meto eḡwa-taḡoani, korana ḡia na tu Barau Natuna ḡora ḡereḡa asi eḡabidadama-viniani nai. ");
INSERT INTO snc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mo meto korana tu maiḡesi: Mama tu tanobarai varau ema foforito, senaḡi tarimarima na mukuna ḡeuravini-baregoato, korana ḡeri veiḡa tu rakava nai. ");
INSERT INTO snc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Veiḡa rakavari ḡeveini tarimari mabarari na tu mama ḡeruḡaiani, mama asi ḡeiaḡo-viniani. Ḡia tu ḡegarini, korana ḡeri veiḡa rakavari beḡe foforini mamai garina. ");
INSERT INTO snc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Senaḡi deikara dabara moḡonina ekorana-iaḡiani tarimana na mama eiaḡo-viniani, benamo tarimarima na beḡe ḡita-ginikauani, ḡena veiḡa namori eveirito tu Barau ḡenana eveirito. ");
INSERT INTO snc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Moḡa murinai Iesu ma ḡena mero ḡesi Iudea tanona rekena ḡana ḡeiaḡoto. Monai Iesu tu ḡena mero ḡesi ḡetanuto-ḡoi e ebabatisoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ioane maki Aenon ai, Salim rekenai, ebabatisoto-ḡoi, korana nanu tu barego monai. Tarimarima mo ḡana ḡeiaḡoto-ḡoi, ea babatisorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mo tu Ioane dibura numanai roḡosi ḡere kou-ḡaua nuḡanai. ");
INSERT INTO snc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Moḡa ḡaronai Ioane ḡena mero Iuda tarimana ta ḡesi ḡeveḡare-veḡareto. Ḡia ḡeri guruḡa tu, kamara veḡuriḡi veiḡanai tu tarimarima benamo-vedaureani. ");
INSERT INTO snc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ioane ḡena mero Ioane ḡenai ḡeiaḡoto, benamo ḡekirato, “Vevaḡa-riba tarimamu, Ioridana ḡarukana mo rekenai ḡoi ḡesi ḡotanuto-ḡoi e ḡoi na oguruḡa-iaḡiato tarimana tu ebabatisoni, ema tarimarima vovoka ḡia ḡenai ḡeiaḡoni.” ");
INSERT INTO snc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioane evaḡa-veseto, ekirato, “Tarima ta na dagara ta asi beḡoitaḡo-kavaiani, senaḡi Barau na guba na bevini-riḡoani vau beḡoitaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ḡomi tauḡemi na ḡoseḡaḡiguto, be ma ribami au akirato, ‘Au tu dia Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), senaḡi au tu etuḡu-guineguto ḡia ḡoirana ḡana.’ ");
INSERT INTO snc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Beveḡaraḡoni ḡuiatona tu beḡaraḡoani futuana na beḡaraḡoani. A beveḡaraḡoni futuana ḡatana tu eruḡa-taḡoni moḡo, (mai tu au, Ioane), ema ḡatana eseḡaḡi-ḡauni, ma ḡatana beveḡaraḡoni futuana garona beseḡaḡiani nai tu, beiakuni. Moḡesi naima au tu iaku na bama vonuvonu-raḡe. ");
INSERT INTO snc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ḡia tu bene barego, a au tu bana kei.” ");
INSERT INTO snc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tuḡuna na emariḡoto tarimana tu dagara mabarari iatari ai; tano na eiaḡomato tarimana tu tanobara tarimana ema tanobara guruḡari moḡo bekiraḡini. Guba na eiaḡomato tarimana dagara mabarari iatari ai. ");
INSERT INTO snc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ḡia tu monai eḡitato e eseḡaḡito dagarari ekiraḡi-foforirini, senaḡi tarima ta na ḡena guruḡa asi eḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Deikara na ḡia ḡena guruḡa eḡabi-raḡeani tarimana na evaḡa-moḡoni korikoriani, Barau tu moḡoni veḡata. ");
INSERT INTO snc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Korana tu Barau na etuḡuato tarimana na Barau ḡena guruḡa bekiraḡiani, korana tu Barau na ḡena Iauka Veaḡa eviniato ema evaḡa-vonuvonu-raḡeani. ");
INSERT INTO snc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana na Natuna eura-viniani, ema dagara mabarari ḡia ḡimanai etore-kaurito. ");
INSERT INTO snc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Deikara na Natuna evaḡa-moḡoniani tarimana na maḡuri vanaḡivanaḡi beḡabiani. A Natuna asi evaḡa-moḡoniani tarimana na maḡuri asi beḡabiani, senaḡi Barau ḡena baru tu ḡia iatanai betanuni.” ");
INSERT INTO snc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisea tarimari tu varau ḡeseḡaḡito, Iesu na tarima vovoka eḡabirito, ḡena mero ai evaḡa-iaḡorito e ebabatisorito, ma Ioane na tu asi vovoka eḡabirito. ");
INSERT INTO snc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Senaḡina Iesu tauḡena na ta tu asi ebabatisoato; mo tu ḡena mero moḡo ḡebabatisoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu eribato ḡia varina Farisea tarimari na eseḡaḡiato, benamo Iudea eiaḡuiato, Galilea ḡana ma eḡenoḡoi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ḡalilea ḡana tu Samaria tanona na eraka-vanaḡito. ");
INSERT INTO snc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria vanuḡana tai eraḡasito. Mo vanuḡa arana tu Sika. Mo vanuḡa tu Iakobo na natuna Iosefa eviniato tanona sevinai. ");
INSERT INTO snc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iakobo ḡena nanu gurina maki monai. Iesu tu eraka-iaḡomato, be egaugau-raḡeto, benamo mo nanu gurina sevinai etanu-tarito. Mo tu horaḡauna 12 koloko nuḡanai ḡaroḡotai. ");
INSERT INTO snc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Etanu-taḡoto-ḡoi nuḡanai, Samaria vavinena ta nanu ḡutu eiaḡoto, benamo Iesu na enoḡiato, ekirato, “Nanu kota noma vinigu, be nama niu.” ");
INSERT INTO snc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ḡena mero tu vanuḡa ḡana, ḡaniḡani voi ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria vavinena evaḡa-veseto, ekirato, “Ḡoi tu Iuda taumu, ma au tu Samaria vavinegu, karase nai au ḡegu ai nanu onoḡini?” Moḡesi ekirato, korana Iuda tarimari tu Samaria tarimari ḡesi asi ḡevegara-garato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Benamo Iesu na evaḡa-veseato, ekirato, “Bema Barau ḡena varevare dagarana boro riba, ema boro riba maki, nanu kota ḡemu ai enoḡiani tarimana tu deikara nai tu, ḡia boro noḡia, benamo ḡia na maḡuri nanuna bere vinimu.” ");
INSERT INTO snc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vavine ekirato, “Vereḡauka, ḡoi tu asi ḡemu tuḡu-riḡo dagarana e guri maki variḡo. Mani maḡuri nanuna tu ainana boḡabiani? ");
INSERT INTO snc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ḡoi tu varaḡe lelevaḡi, ma ḡai senema Iakobo tu kei, ei? Mai nanu gurina tu ḡia na evinimato, ema ḡia tauḡena na eniuato-ḡoi, natuna mabarari na ema ḡena boromakau e mamoe seriri na maki ḡeniuato-ḡoi.” ");
INSERT INTO snc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu na ma evaḡa-veseato, ekirato, “Mai nanu beḡe niuani tarimari mabarari bokari ma beḡe koke-ḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A au na baviniani nanuna beniuani tarimana tu, bokana asi ma bekoke-ḡenoḡoini. Korana au na baviniani nanuna tu ḡia nuḡanai nanu gurinai beiaḡoni, bevoneḡoi-voneḡoini ema maḡuri vanaḡivanaḡi beviniani.” ");
INSERT INTO snc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mo vavine na enoḡiato, ekirato, “Vereḡauka, mani nanu novinigu, be bokagu asi ma bene koke-ḡenoḡoi, ema maiḡana nanu-ḡutu asi ma bana iaḡoma.” ");
INSERT INTO snc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Benamo Iesu na evaḡa-guruḡaiato, ekirato, “Noiaḡo, ḡaraḡomu noa keaia, benamo taumi ruarua boḡono iaḡoma.” ");
INSERT INTO snc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mo vavine evaḡa-veseto, ekirato, “Au tu asi ḡaraḡogu.” Iesu ekirato, “Mani tu moḡoni okirani, ‘Au tu asi ḡaraḡogu’ otoni tuna. ");
INSERT INTO snc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ḡemu guruḡa tu moḡoni, korana ḡoi tu vaḡa-imaima veḡata oveḡaraḡoto, ema mani oḡabiato tarimana maniḡa tu dia ḡoi ḡaraḡomu. ");
INSERT INTO snc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mo vavine ekirato, “Vereḡauka, au toma bama riba, ḡoi tu peroveta tarimamu. ");
INSERT INTO snc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ḡai tubuma ḡatama na tu mai ḡoro ai Barau ḡetoma-rakariḡo viniato-ḡoi, a ḡomi Iuda tarimami ḡokirani, toma-rakariḡo gabuna tu Ierusalemai moḡa, be tarimarima tu monai beḡene toma-rakariḡo.” ");
INSERT INTO snc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu ekirato, “Vavine, ḡegu guruḡa bono vaḡa-moḡonia, ḡaro ta eiaḡomani, mai ḡoro ai e Ierusalemai maki Tamara asi boḡo toma-rakariḡo viniani. ");
INSERT INTO snc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ḡomi Samaria tarimami na ḡotoma-rakariḡo viniani Barauna tu asi ribami; a ḡai na ḡatoma-rakariḡo viniani Barauna tu ribama, korana vevaḡa-maḡuri tu ḡai Iuda tarimama ḡemana eiaḡomani. ");
INSERT INTO snc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Senaḡi ḡarona eiaḡomani ema varau beraḡasi maiḡa, toma-rakariḡo tarimari moḡoniri na Tamara Barau tu iaukai e moḡoni ai beḡe toma-rakariḡo viniani. Korana Tamara na tu moḡesi beḡe toma-rakariḡo viniani tarimari evetaurini. ");
INSERT INTO snc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Barau tu Iauka, ma beḡe toma-rakariḡo viniani tarimari na tu iaukai ema moḡoni ai beḡene toma-rakariḡo vinia.” ");
INSERT INTO snc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mo vavine na ekiraiato, ekirato, “Au ribagu, Mesia, ḡekiraḡiani Keriso ḡetoni, tu beiaḡomani. Ḡia beiaḡomani ḡaronai, ḡia na dagara mabarari bekiraḡi-foforirini.” ");
INSERT INTO snc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Benamo Iesu na evaḡa-veseato, ekirato, “Tarimana tu au maiḡegu, ḡoi avaḡa-guruḡamuni.” ");
INSERT INTO snc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesu moḡesi eguruḡato-ḡoi nuḡanai, ḡena mero ḡeraḡasito. Ḡia mabarari nuḡari ḡefarevaḡito, korana Iesu tu vavine ta ḡesi ḡeguruḡa guruḡato-ḡoi, senaḡi tarima ta asi ekirato, “Ḡoi tu kara ourani?” O “Karase nai mai vavine ḡesi ḡoguruḡa-guruḡani?” ");
INSERT INTO snc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Benamo mo vavine na ḡena nanu gwaḡutuna eraga-kwaneato, eḡenoḡoi-iaḡoto vanuḡa ḡana, benamo vanuḡa tarimari ea kirarito. ");
INSERT INTO snc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ekirato, “Ḡoiaḡoma, tarima ta ḡoma ḡitaia. Ḡia na au ḡegu veiḡa aveirito dagarari mabarabarari bekiraḡi-fofori foforiri. Betaḡu ḡia tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), banaḡu?” ");
INSERT INTO snc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Benamo tarimarima na vanuḡa ḡeiaḡuiato, ma Iesu ḡenai ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mo faka nuḡanai ḡena mero na Iesu ḡekiraiato, ḡekirato, “Vevaḡa-riba tarimamu, noḡaniḡani.” ");
INSERT INTO snc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Senaḡi ḡia evaḡa-veseto, ekirato, “Au tu ma ḡagu ḡaniḡani, ḡomi asi ribami ḡaniḡanina.” ");
INSERT INTO snc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Moḡesina naima ḡena mero tauḡeri ḡevedanaḡito, ḡekirato, “Tarima ta na ḡana ḡaniḡani beḡwa-iaḡoma ba?” ");
INSERT INTO snc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu na ekirarito, ekirato, “Au ḡagu ḡaniḡani tu etuḡuguto Barauna ḡena ura bana veia, ema eviniguto ḡauveina bana vaḡa-koria. ");
INSERT INTO snc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ḡomi ma ḡemi sisiba guruḡana, ḡokirani, ‘Ḡue vasivasi murinai vau kwakwa ḡarona beiaḡomani.’ A au na akiramini, matami ḡokeori, benamo vamoka ḡoḡita-ginikauri, tauri tu varau beḡe gwaḡiḡi, kwakwa ḡarona tu beraḡasi. ");
INSERT INTO snc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kwakwa tarimana ḡena ḡauvei voina tu beḡabiani, ema vamoka ḡaniḡanina bevaḡa-vegogoani tu, maḡuri vanaḡivanaḡi ḡana. Tauna moḡa, varovarona tarimana e kwakwa tarimana beḡe iaku-vegogoni. ");
INSERT INTO snc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Korana moḡesi bevetoreni nai tu, iniḡesina ḡekiraḡiani guruḡana tu moḡoni, ‘Tarima ta na tu evaroani, ma ta na tu ekwaiani.’ ");
INSERT INTO snc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au na ḡomi atuḡumito tu, asi ḡovaro-vekwaraḡito dagarari kwakwari. Varovarori vekwaraḡiri tu tarima tari ḡevekwaraḡito, a ḡomi na tu ḡia ḡeri vekwaraḡi dagarari kwakwari boḡo raka-toḡa.” ");
INSERT INTO snc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Benamo Samaria tarimari vovoka mo vanuḡa nuḡanai Iesu ḡevaḡa-moḡoniato, korana tu mo vavine ḡena vevarifiu guruḡana ḡenana naima, ḡia ekirato, “Au ḡegu veiḡa rakavari aveirito dagarari mabarabarari bekiraḡi-fofori foforiri.” ");
INSERT INTO snc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Moḡesina naima Samaria tarimari Iesu ḡenai ḡeiaḡomato nai tu, ḡenoḡiato, ḡia ḡesi roḡo beḡene tanu. Moḡa lorinai Iesu mo vanuḡai ḡaro ruarua ma etanuto. ");
INSERT INTO snc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma tarimarima vovoka na Iesu ḡevaḡa-moḡoniato, korana ḡena vevarifiu guruḡari na. ");
INSERT INTO snc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Benamo ḡia na mo vavine ḡekiraiato, ḡekirato, “Ḡai na maitoma Iesu ḡavaḡa-moḡoniani, dia ḡoi ḡemu guruḡa lorinai, senaḡi ḡai tauḡema na ḡia baḡa seḡaḡia, ma baḡama riba-ginikau, ḡia tu moḡoni Keriso, tanobara Vaḡa-maḡurina Tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesu monai ḡaro ruarua etanuto murinai, Galilea ḡana ma eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu tauḡena na ekiraḡi-foforiato, ekirato, “Peroveta tarimana tu ḡena vanuḡa korikorina tarimari na asi beḡe gubakauani.” ");
INSERT INTO snc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Benamo Galileai ea votuto nai tu, Galilea tarimari na ḡeḡabi-raḡeato. Iesu ḡeḡabi-raḡeato korana Ierusalemai Pasova verekona nuḡanai tu ḡia maki monai, be Iesu na kara eveirito dagarari mabarari tu, matari na ḡeḡitarito. ");
INSERT INTO snc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Benamo Iesu ma eḡenoḡoito Galilea vanuḡana ta arana Kana ḡana. Kana tu Iesu na nanu wain ai evaḡa-iaḡoato vanuḡana. Monai kini ḡena vere ta Kaperanaumai etanuto-ḡoi, ma ḡia natuna merona tu ekeve-rakavato. ");
INSERT INTO snc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mo vere eseḡaḡito, Iesu tu Iudea na eiaḡomato Galilea ḡana, benamo eiaḡoto ḡia ḡenai, benamo enoḡiato, Kaperanauma ḡana nevariḡo, be ḡia natuna merona nea vaḡa-maḡuria, korana ḡia natuna merona tu dori emaseto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu na ekiraiato, ekirato, “Ḡomi tu vetoḡa boruri e nuḡa-farevaḡi veiḡari asi boḡo ḡitarini tu, asi boḡo vaḡa-moḡoniguni.” ");
INSERT INTO snc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mo vere ekirato, “Vereḡauka, si-iaḡo, natugu bemaseni ḡesi.” ");
INSERT INTO snc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu na ekiraiato, ekirato, “Noiaḡo, natumu merona tu bemaḡuri bene.” Mo tarima na Iesu ḡena guruḡa evaḡa-moḡoniato, benamo eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dabara na eḡenoḡoi-iaḡoto-ḡoi nuḡanai, ḡena vetuḡunaḡi tarimari ḡesi ḡevedoḡarito, benamo ḡekira-varaiato, ḡekirato, “Ḡoi natumu merona tu bemaḡuri.” ");
INSERT INTO snc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Benamo ḡia na edanaḡirito, kamara horai natuna merona enamoto. Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡoraḡani horaḡauna 1 koloko lavilavi rekenai ḡia mo keve na eraga-kwaneato.” ");
INSERT INTO snc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Benamo tamana eriba-maoroto, mo aoa korikorinai enamoto, Iesu na ḡia evaḡa-guruḡaiato, ekirato, “Ḡoi natumu tu bemaḡuri.” Benamo ḡia e ḡena numa tarimari mabarari ḡesi Iesu ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mai tu vetoḡa boruna vaḡa-ruaruana Iesu na eveiato, Iudea na Galilea ḡana eiaḡoto murinai. ");
INSERT INTO snc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mai veiḡa murinai Iesu tu Ierusalema ḡana ma evaraḡeto, korana Iuda tarimari tu ḡeri vereko ta ḡeveiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ierusalemai kou ta tu ḡatama-boka baregona arana Mamoe Ḡatama-bokana sevinai. Mo kou arana Heberu garo ai tu Betesda, ma ḡia sevinai tu iaḡaraḡi foutari imaima (5). ");
INSERT INTO snc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ḡaro mabarari ai kevekeve tarimari vovoka monai ḡegena-taḡoto-ḡoi, mata-bubu, kwaku rakava, ema tauḡaniri ḡemaseto tarimari, nanu ḡena ḡareva-ḡareva ḡevaḡa-nogaiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Korana aneru ta guba na emariḡoto-ḡoi, mo nanu evaḡa-ḡareva ḡarevaiato-ḡoi. Mo nanu eḡarevato-ḡoi nuḡanai, eturu-ferei guineto-ḡoi tarimana tu ḡena keve enamoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Monai tarima ta egena-taḡoto-ḡoi, ḡena keve laḡaniri tu gabana toitoi ma imaima toitoi (38). ");
INSERT INTO snc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu na monai genataḡonai eḡitaiato, ma eribato, ḡia tu ḡaro vovoka veḡata ekeve-iaḡiato. Benamo Iesu na edanaḡiato, ekirato, “Ḡoi ourani nonamo ba?” ");
INSERT INTO snc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Keve tarimana na evaḡa-veseato, ekirato, “Vereḡauka, nanu eḡareva-ḡarevani nai, au kou ai tu asi tau raga tore-reigu tarimana ta. Mainana tauḡegu kou aiaḡo-viniani nai tu, ta eraka-rei-guineni. ");
INSERT INTO snc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu na ekiraiato, ekirato, “Novariḡisi, ḡemu geda noḡabi-vaisia, be noraka.” ");
INSERT INTO snc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Benamo mo tarima ḡena keve asikau enamoto, ma ḡena geda eḡabi-vaisiato, benamo eruḡa-vaisito, erakato. Mo veiḡa tu Sabadi ai eḡorato. ");
INSERT INTO snc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Moḡa lorinai Iuda tarimari na mo keve na enamoto tarimana ḡekiraiato, ḡekirato, “Toma tu Sabadi, ḡemu geda asi bono ḡwa-rakao rakaoa, taravatu.” ");
INSERT INTO snc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ḡia na evaḡa-veserito, ekirato, “Au bevaḡa-namogu tarimana na bekiragu, bekira, ‘Ḡemu geda noḡabi-vaisia, be noraka,’ besi.” ");
INSERT INTO snc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Benamo ḡia na ḡedanaḡiato, ḡekirato, “Mo tu kamara tarima na bekiramu, ‘Ḡemu geda noḡabi-vaisia, be noraka,’ besi?” ");
INSERT INTO snc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Senaḡi mo Iesu na evaḡa-namoato tarimana tu asi ribana, dei na evaḡa-namoato, korana Iesu tu eraka-veḡitato, tarima ḡutuma mo gabu ai vekaravari na. ");
INSERT INTO snc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Gabivau Iesu na mo tarima Rubu Veaḡa nuḡanai edoḡariato, benamo ekiraiato, ekirato, “Noseḡaḡi, maitoma ḡoi tu bonamo. Veiḡa rakavana ta asi ma bono vei-ḡenoḡoia, rakava barego vedaureana ta na beḡabimuni ḡesi.” ");
INSERT INTO snc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Benamo mo tarima erakato, eiaḡoto, Iuda tarimari ea kira-vararito, ḡia tu Iesu na evaḡa-namoato. ");
INSERT INTO snc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Monana vau Iuda tarimari na Iesu ḡevaḡa-rakavaiato-ḡoi, korana Sabadi ai mo vevaḡa-maḡuri veiḡana eveiato nai. ");
INSERT INTO snc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Benamo Iesu na evaḡa-veserito, ekirato, “Au Tamagu tu vanaḡivanaḡi eḡauveini naima, au maki aḡauveini.” ");
INSERT INTO snc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Moḡesi ma ekirato nai, Iuda tarimari ḡeri ura tu dabara ta veḡata beḡene ḡoitaḡoa, be Iesu tu beḡene vaḡi-masea ḡetato. Dia mo Sabadi asi ekorana-iaḡiato moḡo dainai, senaḡina ekirato, Barau tu ḡia Tamana ma etato. Korana mo dabarai ḡia tu Barau ḡesi ilaila etato. ");
INSERT INTO snc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Benamo Iesu na evaḡa-veserito, ekirato, “Moḡoni, au na akira-korikorimini, Natuna ḡereḡana na kara ta asi beveiani, senaḡi Tamana ḡena veiḡa beḡitarini veiḡari moḡo ḡia na beveirini. Tamana kara eveini dagarari mabarabarari Natuna na maki beveirini. ");
INSERT INTO snc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Korana tu Tamana na Natuna eura-viniani, ema ḡia na eveirini dagarari mabarari maki evaḡa-ḡitaiani. Oba, dagara barego lelevaḡiri maki ḡenai bevaḡa-foforiani, maiḡeri dagara maki beḡe vanaḡirini, ḡomi nuḡami beḡene farevaḡi ḡana. ");
INSERT INTO snc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vaḡa-ilailana Tamana na mase tarimari evaḡa-vaisi-raḡerini, benamo maḡuri evinirini kavana, Natuna na maki ḡena ura tarimari maḡuri evinirini. ");
INSERT INTO snc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamana na tu tarima ta asi evaḡa-kotaiani, korana vevaḡa-kota seḡukana mabarana tu Natuna eviniato. ");
INSERT INTO snc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Moḡa tauna tu, tarimarima mabarari na Natuna beḡene gubakaua, Tamana ḡeguba-kauani kavana. Natuna asi eguba-kauani tarimana na tu Tamana maki asi egubakauani, korana Tamana na tu Natuna etuḡuato. ");
INSERT INTO snc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Moḡoni au na akiramini, au ḡegu guruḡa eseḡaḡiani ema etuḡuguto Barauna evaḡa-moḡoniani tarimana na maḡuri vanaḡivanaḡi varau beḡabia. Ḡia tu Barau ḡena Kota nuḡanai asi beraka-toḡani. Asiḡina. Mase varau beraga-kwanea, maḡuri nuḡanai varau beraka-toḡa. ");
INSERT INTO snc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Moḡoni akiramini, ḡarona roḡo beiaḡomani, ma varau bevotu, mase tarimari na Barau Natuna garona beḡe seḡaḡiani, ma beḡe seḡaḡiani tarimari tu beḡe maḡurini. ");
INSERT INTO snc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Korana tu Tamana tauḡena ḡenai maḡuri etanuni ilailanai, Natuna maki moḡesi eviniato, maḡuri ḡenai etanuni. ");
INSERT INTO snc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ema ḡia Natuna maoro eviniato, bene vevaḡa-kota ḡana, korana ḡia tu Tarimarima Natuna. ");
INSERT INTO snc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nuḡami asi beḡene farevaḡi! Ḡarona mani eiaḡomani, mase tarimari mabarari roḡo gara nuḡari ai na Barau Natuna garona beḡe seḡaḡiani. ");
INSERT INTO snc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Benamo beḡema raka-rosini: Vei-namo tarimari beḡe vaisi-raḡeni, maḡuri beḡene ḡabia ḡana, a vei-rakava tarimari beḡe vaisi-raḡeni, rakava voina metona beḡene ḡabia ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Au tu ḡereḡagu na dagara ta asi baveiani riba. Avevaḡa-kotani maki Barau na ekiraguni aseḡaḡirini ilailari ai aveirini, moḡa lorinai ḡegu vevaḡa-kota tu roroḡoto, korana dia au tauḡegu ḡegu ura ta akorana-iaḡiani, senaḡi au etuḡuguto Barauna ḡena ura moḡo aveiani. ");
INSERT INTO snc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bema au tauḡegu moḡo bara vekiraḡi-fofori nai tu, au ḡegu guruḡa tu asi tau vaḡa-moḡonina. ");
INSERT INTO snc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Senaḡi tarima ta na maki au evaḡa-moḡoniguni, ma au ribagu, ḡia na au ekiraḡi-foforiguni guruḡana tu moḡoni. ");
INSERT INTO snc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ḡomi na tarima kotari ḡotuḡu-iaḡorito Ioane ḡenai, benamo ḡia na guruḡa moḡonina ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Au vaḡa-moḡonigu guruḡari tu dia tarimarima ḡerina eiaḡomani, a Ioane bakiraḡia korana tu, ḡomi maḡuri boḡono doḡaria uranai. ");
INSERT INTO snc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioane tu noḡa moḡo lamefa eḡarato-ḡoi ema emore-taḡoto-ḡoi, benamo ḡomi mo faka kotunai ḡemi ura tu, ḡia ḡena mamai boḡono iaku-tanu moḡo ḡotato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Senaḡi au ḡevaḡa-moḡoniguni veiḡari na, Ioane na evaḡa-moḡoniguni guruḡari, moḡeri tu ḡevanaḡirini. Korana tu Tamagu na eviniguto ḡauveina maitoma aveiani, mainana au evaḡa-moḡoniguni, au tu Tamagu na etuḡuguto. ");
INSERT INTO snc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Au tu Tamagu na etuḡuguto, ma ḡia tauḡena na maki au ekiraḡi-foforiguto. Ḡomi na ḡia garona tu roḡosi ḡoro seḡaḡia, ema vetoḡana maki roḡosi ḡoro ḡitaia. ");
INSERT INTO snc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ema ḡena guruḡa ḡomi nuḡami ai tu asi etanuni, korana ḡia na etuḡuato tarimana tu asi ḡovaḡa-moḡoniani. ");
INSERT INTO snc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ḡomi na Buka Veaḡa guruḡari ḡovetau-ginikaurini, korana ḡomi ḡotuḡamaḡini tu, moḡeri guruḡa nuḡari ai maḡuri vanaḡivanaḡi boḡo doḡariani. Moḡeri guruḡa na tu au ḡekiraḡiguni. ");
INSERT INTO snc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Senaḡina ḡomi maḡuri ḡabiḡabina uranai au ḡegu ai iaḡoma tu asi ḡourani. ");
INSERT INTO snc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Au tu tarimarima ḡerina vevaḡa-raḡe tu asi avetauani. ");
INSERT INTO snc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Senaḡi ḡomi aiḡesi, au tu ma ribagu. Au ma ribagu ḡomi nuḡami o lorumi ḡuturi ai Barau uravinina tu asi etanuni. ");
INSERT INTO snc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Au aiaḡomato tu Tamagu aranai, ma asi ḡoḡabi-raḡeguni. Senaḡi tarima boruna ma beiaḡomani tauḡena aranai nai tu, boḡo ḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ḡomi tu tauḡemi fakami ai moḡo ḡovevaḡa-raḡeni tu ḡoḡabi-raḡerini. Senaḡi mo vevaḡa-raḡe tu Barau ḡereḡana na moḡo beveiani. Ma Barau ḡenana eiaḡomani mo vevaḡa-raḡe, ḡomi na tu asi ḡourani boḡono ḡabia. Bema ḡomi maniḡesi tauḡemi fakami ai moḡo ḡovevaḡa-raḡeni nai tu, kamasi au boḡo vaḡa-moḡoniguni? ");
INSERT INTO snc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Asi boḡono tuḡamaḡi, au na Tamagu ḡoiranai bavaḡa-daḡamini, asiḡina. Vaḡa-daḡa tarimana tu ḡoḡabi-raḡeani tarimana, Mose, ḡia na ḡomi bevaḡa-daḡamini. ");
INSERT INTO snc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bema ḡomi na Mose moḡoni boḡoro vaḡa-moḡonia nai tu, au maki boḡoro vaḡa-moḡonigu, korana ḡia na tu au varigu etoreato. ");
INSERT INTO snc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Senaḡina bema ḡia na etoreato guruḡana asi boḡo vaḡa-moḡoniani nai, au ḡegu guruḡa tu kamasi boḡo vaḡa-moḡoniani?” ");
INSERT INTO snc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Moḡa murinai Iesu Galilea kouna na evanaḡi-iaḡoto tavi ta reke ḡana. Mo kou arana ta tu Tiberia. ");
INSERT INTO snc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Benamo tarimarima vovoka tabutabu ḡia murina na ḡeiaḡoto, korana vetoḡa boruri eveito keve tarimari ḡeri ai ḡeḡitarito nai. ");
INSERT INTO snc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Moḡa murinai Iesu ḡoro ḡana evaraḡeto, benamo monai ḡena mero ḡesi ḡetanu-tarito. ");
INSERT INTO snc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda tarimari ḡeri vereko arana Pasova ekavinaḡito-ḡoi ḡoirai. (Mai tu Iuda tarimari mase aneruna na evanaḡirito moḡo, asi evaḡirito, verekona). ");
INSERT INTO snc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu eboḡe-vaisito, tarimarima asisebo ḡia ḡenai ḡeiaḡomato-ḡoi, benamo ḡia na Filipo ekiraiato, ekirato, “Ḡita ḡaniḡani tu ainai toma tavoini, maiḡeri tarimarima mabarari taḡubu-iaḡirini?” ");
INSERT INTO snc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu moḡesi ekirato, korana Filipo nuḡana bene ribaia ḡana. A ḡia tu ma ribana kara beveiani. ");
INSERT INTO snc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo na evaḡa-veseato, ekirato, “Silva moniri sinau ruarua (200) na ḡaniḡani dagarari bita voini, senaḡi asi beḡe ilailani, mai tu koturi koturi moḡo maki asi veḡata mabarari beḡe ḡanini.” (Silva moniri sinau ruarua (200) tu tarima ta davana ḡue imaima toitoi (8) nuḡanai beḡabini kavana). ");
INSERT INTO snc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ḡena mero ta arana Anduru, Simona Petero tarina, ḡia na ma evaḡa-veseato, ekirato, ");
INSERT INTO snc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mero misina ta maiḡa, ḡia tu ma ḡana beredi imaima (5) e maḡani-kone ruarua (2). Senaḡi asi beḡe ilailani mai tarimarima mabarari ḡeri ai tu-na.” ");
INSERT INTO snc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu na ekirarito, ekirato, “Tarimarima ḡokirari, ḡetanutanu-tari.” Mo gabu moḡa ḡauḡana tu vovoka. Benamo tarimarima mabarari ḡetanutanu-tarito. Tau ḡereḡari moḡo mabarari tu 5,000 kavana. ");
INSERT INTO snc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Benamo Iesu na mo beredi eḡabirito, Barau evaḡa-namoato, benamo ḡetanutanu-tarito tarimari mabarari ḡevini-vaḡa-ḡaurito. Maḡani-kone maki moḡesi eveirito, mabarari ḡeḡabito ḡeri ura ilailari ai. ");
INSERT INTO snc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ḡia mabarari ḡeḡani-maseto, benamo Iesu na ḡena mero ekirarito, ekirato, “Beredi kwari mabarari ḡovaḡa-vegogori, misina ta maki asi bene rekwa-rekwa.” ");
INSERT INTO snc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Benamo mo beredi ḡeḡanirito kwakwari moḡeri mabarari ḡevaḡa-vegogorito, boseḡa gabanana ruarua (12) ḡevaḡa-vonurito. ");
INSERT INTO snc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tarimarima na Iesu na mai vetoḡa boruna eveiato ḡeḡitaiato nai, ḡekirato, “Moḡoni, mai tu peroveta tarimana tanobara ḡana beiaḡomani ḡetato tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu eribato, tarimarima tu beḡe iaḡomani, ḡia beḡema ḡabi-tariani ḡeri kini ai beḡene vaḡa-iaḡoa ḡana. Moḡesina naima ḡereḡana ḡoro ḡana ma eiaḡo-ḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Elaviboḡi-iaḡoto nai, Iesu ḡena mero kou ḡana ḡevariḡoto. ");
INSERT INTO snc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Monai ḡasi tai ḡeraḡeto, benamo kou na ḡevanaḡito, Kaperanauma ḡana ḡeiaḡoto. Mo tu varau eboḡito, ma Iesu tu roḡosi bere rakakau ḡia ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A iavara baregona tu eragato-ḡoi, be mo kou ureurena maki ebaregoto. ");
INSERT INTO snc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iesu ḡena mero kilomita imaima (5) o imaima sebona (6) kavana ḡasi ḡelevaiato nuḡanai, ḡia na Iesu ḡeḡitaiato, nanu iatana na eraka-iaḡomato-ḡoi, ḡasi eiaḡoma-viniato-ḡoi, benamo ḡia tu ḡegarito. ");
INSERT INTO snc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iesu na ekirarito, ekirato, “Asi ḡogari, mai tu au.” ");
INSERT INTO snc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Benamo ḡia ḡeḡabi-raḡeato, ḡasi ai eraḡekauto, ma asikauna tu ḡeiaḡo-viniato-ḡoi gabunai ḡevotuto. ");
INSERT INTO snc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Elaḡanito boḡiboḡinai, tarimarima vovoka Iesu ḡena mero ḡasi ai ḡeraḡeto gabunai ḡeruḡa-taḡoto-ḡoi. Ḡia ḡeribato, tovotovonai monai ḡasi tu sebona moḡo mo kou rikinai. Ema ma ribari maki, Iesu tu ḡena mero ḡesi mo ḡasi ai asi eraḡeto, ḡena mero tu ḡereḡari moḡo ḡeraḡeto ema ḡevanaḡi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ḡasi kotari Tiberia na ma ḡeiaḡomato, kou rikinai ḡema darokauto. Ḡia ḡedarokauto gabuna moḡa tu, Vereḡauka na beredi Barau evaḡa-namoato murinai, tarimarima evinirito, ḡeḡanirito gabuna sevinai. ");
INSERT INTO snc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mo tarimarima ḡeriba-maoroto, Iesu ma ḡena mero ḡesi monai tu asiḡina, benamo mo ḡasi ai ma ḡeraḡekauto, Kaperanauma ḡana ḡevanaḡi-iaḡoto, Iesu ḡea vetauato. ");
INSERT INTO snc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tarimarima na Iesu kou tavi ta kefonai ḡedoḡariato, benamo ḡekiraiato, ḡekirato, “Vevaḡa-riba tarimamu, ḡoi tu aitoma mainai boma votu?” ");
INSERT INTO snc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu na evaḡa-veserito, ekirato, “Au na moḡoni akiramini, ḡomi na au ḡovetauguni korana tu mo beredi ḡoḡanito, benamo ḡoḡani-maseto, a dia mo vetoḡa boruri ḡoḡitarito nai, ḡovetauguni. ");
INSERT INTO snc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma beḡe rakavani ḡaniḡaniri ḡauveiri asi boḡono vei, senaḡi ḡaniḡani roḡo betanu-iaḡoni, beiaḡoni mo, maḡuri vanaḡivanaḡi, ḡauveina boḡono vei. Mo ḡaniḡani tu Tarimarima Natuna na bevinimini, korana Tamana Barau na ḡia ḡenai vetoḡa ta eveiato, mo tu ḡia evaḡa-moḡoniato vetoḡana.” ");
INSERT INTO snc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Benamo ḡedanaḡiato, ḡekirato, “Ḡai Barau ḡena ura ḡauveiri ḡaveini baḡa toni tu kara baḡana veia?” ");
INSERT INTO snc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu na evaḡa-veserito, ekirato, “Barau ḡena ḡauvei ḡomi na boḡono veia etoni ḡauveina tu maiḡa moḡo: Etuḡuato tarimana boḡono vaḡa-moḡonia.” ");
INSERT INTO snc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ḡia na ma ḡedanaḡiato, ḡekirato, “Ḡoi na ḡai ḡema tu kamara vetoḡa boruna boveiani baḡa ḡitaiani, benamo ḡoi baḡa vaḡa-moḡonimuni? Ḡoi na kara boveiani? ");
INSERT INTO snc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ḡai senema na tu mana ḡeḡaniato tano fakanai, Buka Veaḡa nuḡanai ekirani kavana, maiḡesi ekirani, ‘Ḡia na beredi guba na evini-riḡorito ḡeḡanito.’” ");
INSERT INTO snc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu na evaḡa-veserito, ekirato, “Moḡoni veḡata akiramini, dia Mose na mo beredi guba na evinimito. Asiḡi. Au Tamagu na tu moḡoni beredi korikorina guba na evinimini. ");
INSERT INTO snc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Korana Barau ḡena beredi tu guba na emariḡoto tarimana. Ḡia na tanobarai ḡetanuni tarimari maḡuri evinirini.” ");
INSERT INTO snc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Benamo ḡia na ḡekiraiato, ḡekirato, “Vereḡauka, mani beredi ḡaro mabarari ai bono vinima.” ");
INSERT INTO snc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu na ekirarito, ekirato, “Maḡuri beredina tu au maiḡegu. Au ḡegu ai beiaḡomani tarimana tu asi ma bevitoani, ema au bevaḡa-moḡoniguni tarimana tu, bokana asi ma bekokeni. ");
INSERT INTO snc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Senaḡi au na ḡomi tu varau akiramito, ḡoḡitaguni, senaḡi asi ḡovaḡa-moḡoniguni. ");
INSERT INTO snc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tamagu na au eviniguto tarimari mabarari tu, au ḡegu ai beḡe iaḡomani, ema deikara au ḡegu ai beḡe iaḡomani tarimari, au na asi balai-ḡenoḡoirini. ");
INSERT INTO snc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Korana au guba na amariḡoto tu, dia au ḡegu ura bana veia ḡana, senaḡina au etuḡuguto Barauna ḡena ura bana veia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ema au etuḡuguto Barauna ḡena ura tu, au eviniguto tarimari mabarari ta asi bana vei-rekwa rekwaia, a mabarabarari mase na ma bana vaḡa-variḡisi ḡenoḡoiri ḡaro magonai. ");
INSERT INTO snc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Korana au Tamagu ḡena ura tu, Natuna beḡe ḡitaiani ema beḡe vaḡa-moḡoniani tarimari mabarari na maḡuri vanaḡivanaḡi beḡe ḡabiani, ma ḡaro dokonai ma bavaḡa-variḡisi ḡenoḡoirini.” ");
INSERT INTO snc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Benamo Iuda tarimari ḡemugu-muguto, korana ḡia ekirato, “Au tu guba na amariḡoto beredina.” ");
INSERT INTO snc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Benamo ḡekirato, “Mai tarima tu Iesu, Iosefa natuna, nene? Ḡia tamana e sinana tu ḡita ribara. Ma kamara dabarai ḡia tu ekirani, ‘Au tu guba na amariḡoto’?” ");
INSERT INTO snc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu na evaḡa-veserito, ekirato, “Ḡomi tauḡemi fakami ai mugumugu ḡovaḡa-dokoa. ");
INSERT INTO snc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Au ḡegu ai ta asi beiaḡoma-kavani, senaḡina Tamagu, au etuḡuguto Barauna, ḡia na deikara au ḡegu ai beinu-kaviani tarimana moḡo. Ema au ḡegu ai beiaḡomani tarimana tu, au na ḡaro dokonai mase na bavaḡa-variḡisi ḡenoḡoiani. ");
INSERT INTO snc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Peroveta tarimari na maiḡesi ḡetoreato, ‘Ḡia mabarari Barau na bevaḡa-ribarini.’ Tamagu ḡeseḡaḡi-viniani ema ḡenana riba ḡeḡabini tarimari mabarari tu, au ḡegu ai beḡe iaḡomani. ");
INSERT INTO snc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Au tu asi akirani, tarima ta na Tamagu eḡitaiato atoni, senaḡi Barau ḡenana eiaḡomato tarimana ḡereḡana na moḡo Tamagu eḡitaiato. ");
INSERT INTO snc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Moḡoni akiramini, au evaḡa-moḡoniguni tarimana na maḡuri vanaḡivanaḡi beḡabiani. ");
INSERT INTO snc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maḡuri beredina tu au maiḡegu. ");
INSERT INTO snc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ḡomi senemi na tano fakanai mana ḡeḡanito-ḡoi, senaḡi ma ḡemaseto. ");
INSERT INTO snc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A guba na emariḡoni beredina tu maiḡea, ḡia beḡaniani tarimana tu asi bemaseni. ");
INSERT INTO snc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Au tu maḡuri beredina guba na amariḡoto. Tarima ta na mai beredi beḡaniani, ḡia tu bemaḡuri-vanaḡi vanaḡini. Mai beredi au na baviniani tu au viriḡogu. Au viriḡogu bavini-fitoḡaiani korana tu, tanobarai ḡetanuni tarimari na maḡuri beḡene ḡabia ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mainana Iuda tarimari tauḡeri fakari ai veḡare-veḡare baregona eḡorato, ḡia ḡekirato, “Mai tarima na tu kamara dabarai ḡia viriḡona bevinirani bita ḡaniani?” ");
INSERT INTO snc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu na ekirarito, ekirato, “Moḡoni akiramini, bema ḡomi na Tarimarima Natuna viriḡona asi boḡo ḡaniani ema rarana asi boḡo niuani nai, ḡomi nuḡami ai maḡuri asi betanuni. ");
INSERT INTO snc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Deikara na au viriḡogu beḡaniani ema raragu beniuani tarimana tu, maḡuri vanaḡivanaḡi beḡabiani, ema au na ḡaro dokonai mase na bavaḡa-variḡisi ḡenoḡoiani. ");
INSERT INTO snc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Korana au viriḡogu tu ḡaniḡani korikorina, ema au raragu maki niuniu dagarana korikorina. ");
INSERT INTO snc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Deikara au viriḡogu beḡaniani e raragu beniuani tarimana tu, au nuḡagu ai betanuni, ema au maki ḡia nuḡanai batanuni. ");
INSERT INTO snc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu maḡurina na etuḡuguto ema au tu ḡia koranai amaḡurini. Moḡa ilailanai au viriḡogu beḡaniani tarimana maki bemaḡurini, korana au amaḡurini. ");
INSERT INTO snc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Au tu guba na emariḡoto beredina maiḡegu. Ḡomi senemi tu mana ḡeḡanito ma ḡemaseto. Senaḡi mai beredi beḡaniani tarimana tu bemaḡuri-vanaḡi vanaḡini.” ");
INSERT INTO snc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu na maiḡeri guruḡa Iuda tarimari rubu ai ekiraḡirito, Kaperanaumai evevaḡa-ribato-ḡoi nuḡanai. ");
INSERT INTO snc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu ḡena mero ḡutuma na mai guruḡa ḡeseḡaḡiato nai tu, ḡekirato, “Mai vevaḡa-riba guruḡana tu gwaḡiḡi rakava, dei na beḡabi-raḡeani.” ");
INSERT INTO snc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu ribana ḡena mero na mo guruḡa ḡemugumugu-iaḡiato-ḡoi, benamo ekirarito, ekirato, “Mai guruḡa na bevaḡa-daḡa-raḡemi? ");
INSERT INTO snc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bema ḡomi na Tarimarima Natuna boḡo ḡitaiani, beḡenoḡoi-varaḡeni, etanu-iaḡiato gabuna ḡana tu kamasi? ");
INSERT INTO snc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Barau Iaukana na maḡuri evinirani; tauḡani na asi bevaḡa-kavarani. Au na avaḡa-guruḡamini guruḡari tu Iauka, ema ḡia nuḡari ai tu maḡuri etanuni. ");
INSERT INTO snc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Senaḡi ḡomi kotari na tu asi ḡovaḡa-moḡoniguni.” Iesu ribana tovotovona na veḡata, deikara ta na tu asi evaḡa-moḡoniato-ḡoi ema deikara na maki ḡia berevaiani. ");
INSERT INTO snc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma ekirato, “Moḡesina naima au na akiramito, ta au ḡegu ai asi beiaḡoma-kavani, senaḡi Tamagu na bevaḡa-moḡoniani tarimana vau beiaḡomani.” ");
INSERT INTO snc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mo guruḡa ḡeseḡaḡiato, monana Iesu ḡena mero ḡutuma ḡia ḡenana ḡeraka-veḡitato, ema ḡia ḡesi asi ma ḡerakao-vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Benamo Iesu na ḡena mero gabanana ruarua (12) edanaḡirito, ekirato, “Ḡomi maki ḡourani boḡono raka-veḡita ba?” ");
INSERT INTO snc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Petero na evaḡa-veseato, ekirato, “Vereḡauka, ḡai tu deikara ḡenai ma baḡa iaḡoni? Maḡuri vanaḡivanaḡi guruḡari tu ḡoi ḡemu ai. ");
INSERT INTO snc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ḡai na ḡavaḡa-moḡonimuni ema ḡariba-korikorini, ḡoi tu Barau ḡena Veaḡa Tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu evaḡa-veseto, ekirato, “Au na ḡomi gabanana ruarua (12) aḡabi-viriḡimito nene? Senaḡi sebomu ta tu bodiabolo.” ");
INSERT INTO snc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ḡia na tu Iudas, Simona Isakariota natuna, ekiraḡiato. Iudas maki mo mero gabanana ruarua (12) fakari merona ta, senaḡi ḡia na Iesu vau berevaiani. ");
INSERT INTO snc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Moḡa murinai Iesu tu Galileai erakaoto-ḡoi. Ḡia asi eurato, Iudea ḡana bene iaḡo, korana Iuda tarimari monai ḡeri ura tu, ḡia beḡene vaḡia. ");
INSERT INTO snc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iuda tarimari ḡeri Fouta Verekona ḡarona ekavinaḡito. (Mai fouta verekona ḡeveiato-ḡoi nai tu, fouta ḡeragato-ḡoi, benamo nuḡari ai ḡetanuto-ḡoi, korana seneri tano fakanai fouta nuḡari ai ḡetanuto-ḡoi, moḡa beḡene tuḡamaḡi-iaḡia ḡana). ");
INSERT INTO snc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Benamo Iesu tarina merori na ḡekiraiato, ḡekirato, “Mai gabu noraga-kwanea, Iudea ḡana bono iaḡo, benamo oveirini dagarari ḡemu mero na beḡene ḡitari. ");
INSERT INTO snc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Korana deikara tauḡena bene vevaḡa-fofori etoni tarimana, beḡene ribaia uranai tu, kara ta asi bevei-vekuretoḡaiani. Ma ḡoi tu maiḡeri veiḡa oveirini, be tanobara mabarari ai novevaḡa-fofori!” ");
INSERT INTO snc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Korana Iesu tarina mabarari na maki ḡia tu asi ḡevaḡa-moḡoniato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Moḡa lorinai Iesu na ekirarito, ekirato, “Au ḡegu ḡaro tu roḡosi bene raḡasi. A ḡomi ḡemi ai ḡaro mabarari tu loriri ai moḡo. ");
INSERT INTO snc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tanobara na ḡomi tu asi ebaru-vinimini, senaḡi au tu ebaru-viniguni, korana au tu veiḡa rakavari eveirini dagarari akiraḡi-foforirini. ");
INSERT INTO snc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ḡomi boḡono iaḡo mo vereko ḡana. A au tu asi baiaḡoni, korana au ḡegu ḡaro korikori tu roḡosi roḡo bene raḡasi.” ");
INSERT INTO snc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesu moḡesi ekirato, benamo Galileai etanuto. ");
INSERT INTO snc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu tarina merori ḡeiaḡoto mo vereko ḡana, muriri ai Iesu maki ma eiaḡoto. Senaḡi asi eraka-foforito, a vekuretoḡai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mo vereko gabuna Iuda tarimari na tu mo vereko nuḡanai ḡevetauato-ḡoi, ḡevedanaḡi-vedanaḡito-ḡoi, ḡekirato-ḡoi, “Ḡia tu ainai?” ");
INSERT INTO snc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mo ḡutuma-bara nuḡanai Iesu kiraḡi-ḡairiḡairina tu ebarego-rakavato. Tarima kotari ḡekirato-ḡoi, “Ḡia tu tarima namona” ḡetato. Ma kotari tu ḡekirato-ḡoi, “Asiḡi, ḡia na tarimarima eḡorikau-darere darererini.” ");
INSERT INTO snc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Senaḡi tarima ta na asi eguruḡa-iaḡi foforiato, korana ḡia mabarari Iuda vereri gariri ḡeveito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Vereko ḡarori kotari ḡekorito, kotari roḡo moḡeri nuḡanai vau, Iesu Rubu Veaḡai eraka-toḡato, benamo evevaḡa-ribato. ");
INSERT INTO snc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Benamo Iuda tarimari ḡeḡaba-vedaureato, ḡekirato, “Mai tarima vevaḡa-riba guruḡari tu kamasi eribato, ḡia vevaḡa-riba gabuna ta ḡana riba-vetau tu asi eiaḡoto.” ");
INSERT INTO snc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu evaḡa-veseto, ekirato, “Kara au avevaḡa-riba iaḡini tu dia au ḡegu vevaḡa-riba, senaḡi au etuḡuguto Barauna ḡenana ḡeiaḡomani. ");
INSERT INTO snc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bema tarima ta eurani Barau ḡena ura bene veiri etoni tarimana na, au ḡegu vevaḡa-riba guruḡari beribarini. Beribani, au ḡegu vevaḡa-riba guruḡari Barau ḡenana ḡeiaḡomani, o au tauḡegu ḡeguna moḡo. ");
INSERT INTO snc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tarima ta deikara ḡena ura guruḡari ekiraḡini tu, tauḡena arana vaḡa-raḡena dabarana evetauani. Senaḡi au etuḡuguto Barauna vaḡa-raḡena dabarana eveiani tarimana ḡenai tu, guruḡa moḡonina etanuni, a ḡia ḡenai ḡofaḡofa ta tu asi etanuni. ");
INSERT INTO snc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose na ḡomi taravatu tu evinimito, ene? Senaḡi ḡomi ta na mo taravatu tu asi ḡokorana-iaḡiani. Ma karase nai ḡomi na au tu ḡovaḡigu ḡotoni?” ");
INSERT INTO snc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mo tarimarima ḡutuma ḡevaḡa-veseto, ḡekirato, “Ḡoi tu iauka rakavana ta na eboroḡimuto. Deikara na nevaḡimu otoni?” ");
INSERT INTO snc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu na evaḡa-veserito, ekirato, “Au na mainai Ierusalemai veiḡa boruna sebona aveiato nai, ḡomi mabarabarami nuḡami ḡefarevaḡini. ");
INSERT INTO snc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose na mero tauḡaniri kefi-lamavaḡi veiḡana evinimito, moḡa lorinai ḡomi na mero keiri Sabadi ai maki kefiri ḡolama-vaḡirini. Mo kefi-lamavaḡi veiḡana tu dia Mose na esinaiato, senaḡi ḡomi senemi na ḡesinaiato. ");
INSERT INTO snc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bema mero tauḡaniri kefiri Sabadi ai ḡolama-vaḡirini Mose ḡena taravatu boḡo vanaḡiani ḡesi, kara dainai au tu ḡobaru-viniguni, Sabadi ai tarima ta bavaḡa-namo ginikaua nai, ei? ");
INSERT INTO snc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ḡomi na dagara tu murikari vetoḡari ai asi boḡono ḡita-viriḡiri, senaḡi dagara mabarari veiḡa roroḡotori ai boḡono ḡita-viriḡiri.” ");
INSERT INTO snc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Benamo Ierusalema tarimari kotari ḡekirato, “Mai beḡene vaḡia ḡetoni tarimana tu maiḡa. ");
INSERT INTO snc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ḡoḡitaia, ḡia tu ma guguraḡina ḡesi eguruḡani, ma ta na ḡenai guruḡa ta asi ekiraḡiani. Ba betaḡu kanisoro tarimari beḡe riba, Keriso korikorina tu maiḡa. ");
INSERT INTO snc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Senaḡi Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), beiaḡomani nai, ta asi beribani ḡia tu ainana beiaḡomani. A mai tarima ainana eiaḡomato ḡita tu mabarara ma ribara.” ");
INSERT INTO snc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu roḡo Rubu Veaḡai evevaḡa-ribato-ḡoi nuḡanai, eguruḡa-baregoto, ekirato, “Moḡoni, ḡomi ma ribami au tu deikara e ainana aiaḡomato. Senaḡi au tu dia tauḡegu ḡegu urai moḡo aiaḡomato. Au etuḡuguto Barauna tu moḡoni. Ma ḡomi tu asi ribami ḡia. ");
INSERT INTO snc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Senaḡi au ḡia tu ma ribagu, korana au tu ḡia ḡenana aiaḡomato e ḡia na etuḡuguto.” ");
INSERT INTO snc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Benamo ḡeḡabi-taria ḡetato, senaḡi tarima ta ḡimana ḡia ḡenai asi evenabakauto, korana ḡena ḡaro korikori tu roḡosi bere votu bene. ");
INSERT INTO snc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Senaḡi tarimarima vovoka mai ḡutuma nuḡanai ḡia ḡevaḡa-moḡoniato, ḡekirato, “Keriso beiaḡomani nai, vetoḡa boruri veiveiri ai mai tarima bevanaḡiani ba?” ");
INSERT INTO snc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisea tarimari ḡeseḡaḡito, tarimarima ḡutuma na mo guruḡa Iesu ḡenai ḡekiraḡi-ḡairiḡairito-ḡoi. Moḡa ḡaramanai Farisea tarimari e Rubu Veaḡa vereri baregori na Rubu Veaḡa ḡitaḡauna tarimari kota ḡetuḡurito, Iesu beḡene ḡabia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu ekirato, “Au tu ḡaro viravira moḡo ḡomi ḡesi bita tanuni, moḡa murinai ma baraka-veḡitani, etuḡuguto Barauna ḡenai baiaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ḡomi na boḡo vetauguni, senaḡi asi boḡo doḡariguni; ema au batanuni gabuna ḡana, ḡomi tu asi boḡo iaḡoni riba.” ");
INSERT INTO snc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Benamo Iuda tarimari tauḡeri ḡevedanaḡito, ḡekirato, “Ḡia tu aiḡana beiaḡoni, be ḡita na asi bita doḡariani riba etoni? Betaḡu ḡia tu beiaḡoni irau bese tarimari ḡeri tanobara ḡana, Iuda tarimari ḡutuma maki ḡia fakari ai ḡetanuni gaburi, monai irau bese tarimari bea vaḡa-ribarini. ");
INSERT INTO snc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mai tu kamara guruḡa ḡia na ekiraḡiani, ekirani, ‘Boḡo vetauguni, senaḡi asi boḡo doḡariguni,’ ema, ‘Au batanuni gabuna ḡana ḡomi tu asi boḡo iaḡoni riba’?” ");
INSERT INTO snc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Vereko magona ḡarona, mo tu ḡaro barego lelevaḡina, Iesu eruḡa-vaisito, benamo eguruḡa-fouto, ekirato, “Deikara nanu na bokana bekokeni tu, au ḡegu ai bene iaḡoma, nanu benema niu. ");
INSERT INTO snc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Buka Veaḡa nuḡanai ekirani ilailanai, ekirani, ‘Au bevaḡa-moḡoniguni tarimana nuḡana na tu maḡuri nanuna beḡaru-rosini.’” ");
INSERT INTO snc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu na Iauka moḡesi ekiraḡiato-ḡoi, kamara tarima Iesu ḡevaḡa-moḡoniani tarimari na vau beḡe ḡabiani. Mo ḡaro ai Iauka Veaḡa tu Barau na roḡosi bere viniri, korana Iesu na Barau ḡena mareva baregona maki roḡosi bere ḡabia nai. ");
INSERT INTO snc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tarima kota mo ḡutuma nuḡari ai mo guruḡa ḡeseḡaḡiato, benamo ḡekirato, “Moḡoni, ḡita na peroveta tarimana tanariani tarimana tu maiḡea.” ");
INSERT INTO snc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tarima kotari ḡekirato, “Mai tu Keriso.” Senaḡi kotari ḡekirato, “Asiḡi, Keriso tu Galilea na asi beiaḡomani. ");
INSERT INTO snc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buka Veaḡa nuḡanai ekirani, Keriso tu Davida besena na beiaḡomani, ema Betelehemai, Davida etanuto-ḡoi vanuḡanai, bemaḡurini.” ");
INSERT INTO snc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Moḡesina naima tarima tauḡeri fakari ai moḡo ḡevetore-kirato, korana Iesu ḡaramanai. ");
INSERT INTO snc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tarima kota ḡeurato beḡene ḡabia, senaḡina ta ḡimana ḡia ḡenai asi evenabakauto. ");
INSERT INTO snc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rubu Veaḡa ḡitaḡauna tarimari ḡeḡenoḡoito, benamo Rubu Veaḡa vereri baregori ema Farisea tarimari na ḡedanaḡirito, ḡekirato, “Karase nai ḡia tu asi boḡo ḡori-iaḡomaia?” ");
INSERT INTO snc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rubu Veaḡa ḡitaḡauna tarimari ḡevaḡa-veseto, ḡekirato, “Mai tarima eguruḡani kavana, ta roḡosi bene guruḡa.” ");
INSERT INTO snc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Benamo Farisea tarimari na ḡekirarito, ḡekirato, “Be, ḡomi maki ḡia na beḡofami? ");
INSERT INTO snc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Veḡorikau tarimana ta o Farisea tarimana ta na ḡia evaḡa-moḡoniani ba? Asiḡina! ");
INSERT INTO snc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A mai tarimarima na ḡevaḡa-moḡoniani, ḡia tu Mose ḡena taravatu asi ribari tarimari. Barau na ḡeri rakava voiri bevinirini.” ");
INSERT INTO snc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisea tarimana ta monai arana Nikodemo. Ḡia tu boḡi ta eiaḡoto Iesu ea ḡitaiato tarimana. Ḡia na ekirarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ḡita ḡera taravatu ekirani, tarima tu ḡena guruḡa ḡeseḡaḡi-guineani roḡo, moḡa murinai vau ḡena rakava voina metona beḡe viniani.” ");
INSERT INTO snc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ḡia na ḡevaḡa-veseato, ḡekirato, “Ḡoi maki Galilea tarimamu ba? Buka Veaḡa nuḡana bono vetaua, monana boribani, peroveta tarimana ta Galilea na tu asi beiaḡomani.” ");
INSERT INTO snc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53"," Benamo tarimarima mabarari ḡeri numa ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Senaḡi Iesu tu Olive Ḡorona ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma elaḡanito boḡiboḡi iamoiamo tu ḡia ma eḡenoḡoito Rubu Veaḡa ḡana. Monai tarimarima mabarari ḡeiaḡomato ḡenai, ḡetanu-ḡeḡeraḡiato, benamo etanu-tarito, evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Benamo taravatu ḡevevaḡa-riba iaḡirito-ḡoi tarimari e Farisea tarimari na vavine ta Iesu ḡenai ḡeḡori-iaḡoato. Mo vavine tu eveḡura-vanaḡito-ḡoi nuḡanai ḡedoḡariato, benamo ḡeḡori-iaḡoato mo, Iesu ḡesi ḡetanu-taḡoto-ḡoi tarimari mabarari ḡoirari ai ḡea vaḡa-ritoḡoato. ");
INSERT INTO snc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iesu ḡekiraiato, ḡekirato, “Vevaḡa-riba tarimamu, mai vavine tu eveḡura-vanaḡini-ḡoi nuḡanai beḡe ḡoitaḡoa. ");
INSERT INTO snc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma Mose ḡena taravatu ekirani, moḡesi beḡe veini vavineri tu, fore na baḡana taki-maseri. Ḡoi tu kara mani otoni?” ");
INSERT INTO snc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Moḡesi ḡekirato tu, Iesu ḡeriba-ḡaniato, beḡene vaḡa-daḡaia ḡana. Senaḡi Iesu etutuḡu-tarito, tano ai didina ta na etoretoreto. ");
INSERT INTO snc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ḡia na roḡo Iesu ḡedanaḡiato-ḡoi nai, eruḡa-vaisito, benamo ekirarito, ekirato, “Deikara ḡomi fakami ai roḡosi roḡo bene vei-rakava nai tu, ḡia na fore bene ḡabia, mai vavine bene ḡidara-guinea.” ");
INSERT INTO snc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Benamo Iesu ma etoḡa-tarito, tano ai ma etoretoreto. ");
INSERT INTO snc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ḡia na mo guruḡa ḡeseḡaḡiato nai, ḡia tata nuḡari ai ḡeribato ma ḡeri vei-rakava, benamo irau sebori-sebori ḡerakaraka-veḡitato; tau ḡaukari ḡeraka-guineto murinai vau ḡuru-gabi ma ḡerakato. Iesu ḡereḡana moḡo etanuto, monai roḡo eruḡa-taḡoto-ḡoi vavinena ḡesi. ");
INSERT INTO snc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ḡia eruḡa-vaisito nai tu, tarima ta asi eḡitaiato, mo vavine moḡo, benamo edanaḡiato, ekirato, “Ḡoi beḡe vaḡa-daḡamu tarimari tu aiḡeri? Ta na ḡemu rakava voina metona asi bevinimu?” ");
INSERT INTO snc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mo vavine evaḡa-veseto, ekirato, “Vereḡauka, sebona ta maki asiḡina.” Benamo Iesu ekirato, “Au na maki ḡemu rakava voina metona asi bavinimuni. Noiaḡo, senaḡi asi ma bono vei-rakava ḡenoḡoi.” ");
INSERT INTO snc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Benamo Iesu na tarimarima ma eḡobata-vinirito, ekirato, “Au tu tanobara mamana. Deikara au murigu ai berakani tarimana tu, mukunai asi berakani, senaḡi maḡuri mamana beḡabiani.” ");
INSERT INTO snc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisea tarimari na ḡekiraiato, ḡekirato, “Ḡoi tu tauḡemu ovekiraḡini; be ḡoi ḡemu vekiraḡi tu asi moḡoni.” ");
INSERT INTO snc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu evaḡa-veseto, ekirato, “Asiḡi, au tauḡegu avekiraḡini, senaḡina au na kara akiraḡiani tu moḡoni. Korana au ribagu ainana aiaḡomato ema aiḡana ma baiaḡoni. A ḡomi tu asi ribami au ainana aiaḡomato ema aiḡana ma aiaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ḡomi tu tarimarima ḡeri vevaḡa-maoro dabaranai ḡovevaḡa-maoroni. Au na ta tu asi avaḡa-maoroani. ");
INSERT INTO snc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Senaḡi bema au bavevaḡa-maoroni nai, ḡegu vevaḡa-maoro tu moḡoni. Korana au tu dia ḡereḡagu moḡo avevaḡa-maoroni, senaḡina Tamagu, au etuḡuguto Barauna, au ḡesi baḡa vevaḡa-maoroni. ");
INSERT INTO snc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ḡomi ḡemi taravatu ai maki maiḡesi ekirani, tarima ruarua na guruḡa sebona moḡo ḡekiraḡiani nai tu moḡoni. ");
INSERT INTO snc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Au tu tauḡegu avekiraḡini; ema Tamagu, etuḡuguto Barauna, na maki au ekiraḡiguni. ");
INSERT INTO snc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Benamo ḡia na ḡedanaḡiato, ḡekirato, “Ḡoi tamamu tu ainai?” Iesu evaḡa-veseto, ekirato, “Ḡomi tu asi ribami au, ma Tamagu maki asi ribami. Bema au boḡoro ribagu tu, Tamagu maki ḡoro ribaia.” ");
INSERT INTO snc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu na mai ḡena guruḡa tu Rubu Veaḡai evevaḡa-ribato-ḡoi, moni ḡevaḡa-vegogoto-ḡoi mauḡana gabunai. Tarima ta asi evenabakauto ḡenai, korana ḡia ḡena ḡaro roḡosi bere votu. ");
INSERT INTO snc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu na ma evaḡa-guruḡa ḡenoḡoirito, ekirato, “Au tu araka-veḡitani. Ma ḡomi na boḡo vetauguni, senaḡi ḡemi vei-rakava nuḡanai boḡo maseni. Au baiaḡoni gabuna ḡana, ḡomi tu asi boḡo iaḡoni riba.” ");
INSERT INTO snc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Benamo Iuda tarimari ḡekirato, “Ḡia bekira, ḡia beiaḡoni gabuna ḡana ḡita tu asi bita iaḡoni. Moḡa tauna ḡia tu tauḡena bevevaḡini ba?” ");
INSERT INTO snc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu evaḡa-veseto, ekirato, “Ḡomi tu mai tanobara maiḡa mainana eveimito, senaḡi au tu tuḡuna na amariḡoto. Ḡomi tu mai tanobara tarimari, senaḡi au tu dia mai tanobara tarimagu. ");
INSERT INTO snc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Moḡa lorinai au na ḡomi bakirami, ḡemi rakavai boḡo maseni. Korana bema au, Keriso, asi boḡo vaḡa-moḡoniguni nai tu, ḡemi rakavai boḡo maseni.” ");
INSERT INTO snc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Benamo ḡia na ḡedanaḡiato, ḡekirato, “Ḡoi tu deikara?” Iesu na ma evaḡa-veserito, ekirato, “Tovotovonai veḡata ḡemi akiraḡito-ḡoi kavana. ");
INSERT INTO snc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Guruḡa vovoka bara kiraḡiri ema bara vevaḡa-maoro vinimi, korana ḡemi veiḡa lorinai. Senaḡina sebona moḡo, au etuḡuguto Barauna tu moḡoni, ma ḡia ḡenana aseḡaḡito guruḡari tanobarai ḡetanuni tarimari akira-vararini.” ");
INSERT INTO snc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ḡia tu asi ḡetuḡamaḡi-fakato Iesu na mo tu Tamana ekiraḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Benamo ma ekirarito, ekirato, “Ḡomi na Tarimarima Natuna ḡau ḡesi boḡo ḡabi-vaisiani murinai vau, boḡo ribani au tu Keriso. Benamo boḡo ribani, au ḡereḡagu na kara ta ḡegu urai moḡo asi aveiani, senaḡi Tamagu na au kara evaḡa-ribaguni guruḡari moḡo, au na ḡomi akira-varamini. ");
INSERT INTO snc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ema au etuḡuguto Barauna tu au ḡesi, au asi eraga-kwaneguni; korana au na vanaḡi-vanaḡi tu ḡia na eiaku-iaḡirini veiḡari moḡo aveirini.” ");
INSERT INTO snc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tarima vovoka na Iesu ḡevaḡa-moḡoniato, maiḡeri guruḡa ekiraḡirito-ḡoi nai. ");
INSERT INTO snc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Benamo Iesu na mo Iuda tarimari, ḡia ḡevaḡa-moḡoniato tarimari, ekirarito, ekirato, “Bema ḡomi na au ḡegu vevaḡa-riba guruḡari boḡo korana-iaḡirini nai, ḡomi tu moḡoni au ḡegu mero korikori. ");
INSERT INTO snc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Benamo guruḡa moḡonina boḡo ribaiani, ma mo guruḡa moḡonina na beruḡa-vaḡimini, dagara ta na asi ma bebarubarumini.” ");
INSERT INTO snc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡai tu Aberahamo garakana ema ḡai tu tarima ta ḡena tuḡu-rakaorakao tarimanai tu asi ḡaiaḡoto. Ma ḡoi kamasi nai tu okirani, ‘Guruḡa moḡonina na beruḡa-vaḡimini’?” ");
INSERT INTO snc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu na evaḡa-guruḡarito, ekirato, “Akira-korikorimini, deikara rakava eveini, ḡia tu vei-rakava ḡena tuḡu-rakaorakao tarimana. ");
INSERT INTO snc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tuḡu-rakaorakao tarimana tu numai asi betanu-vanaḡi vanaḡini, senaḡi numa tarimana natuna tu numai betanu-vanaḡi vanaḡini. ");
INSERT INTO snc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Moḡa lorinai bema Barau Natuna na beruḡa-vaḡimini nai, ḡomi tu boḡo raka-vaḡi korikorini, dagara ta na asi ma bebarubarumini. ");
INSERT INTO snc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au ribagu ḡomi tu Aberahamo garakana, senaḡi ḡomi ḡourani, au tu boḡono vaḡigu, korana ḡomi na ḡegu vevaḡa-riba guruḡari tu, asiḡina ḡinavaḡi moḡo ḡoḡabi-raḡerini. ");
INSERT INTO snc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Au na tu kara Tamagu ḡenai aḡitarito dagarari ḡomi akira-varamini, a ḡomi tu tamami ḡenana ḡoseḡaḡito dagarari ḡomi na ḡoveirini.” ");
INSERT INTO snc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ḡia na Iesu ma ḡevaḡa-veseato, ḡekirato, “Ḡai tamama tu Aberahamo.” Iesu na evaḡa-veserito, ekirato, “Bema ḡomi moḡoni Aberahamo natuna nai, ḡia na eveirito veiḡari ḡomi na maki ḡoro veiri. ");
INSERT INTO snc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Au tu Barau ḡenana aseḡaḡirito guruḡari moḡoniri mabarari ḡomi akira-varamini, senaḡi ḡomi ḡourani tu, au ḡovaḡigu ḡotoni. Aberahamo moḡesi asi eveito. ");
INSERT INTO snc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ḡomi tu tauḡemi tamami, (Diabolo), na kara eveini veiḡana ḡoveiani.” Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡai tu dia kuḡa-gara tarimama. Ḡai Tamama tu Barau moḡo ḡereḡana.” ");
INSERT INTO snc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu na ekirarito, ekirato, “Bema Barau moḡoni ḡomi Tamami nai tu, au ḡoro ura-vinigu. Korana au tu Barau sevina na aiaḡomato. Au ḡegu urai asi aiaḡomato, senaḡi ḡia na etuḡuguto. ");
INSERT INTO snc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Karase nai au na kara akiraḡiani guruḡana asi ḡotuḡa-maḡi-fakani? Korana au ḡegu guruḡa tu asi ilaila boḡo seḡaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ḡomi tu tamami Diabolo ḡena tarimarima, be ḡomi ḡourani tu tamami na euravini-rakavarini veiḡari boḡono veiri. Tovotovona na veḡata ḡia tu vevaḡi-deba tarimana ema guruḡa moḡonina tu asi ekorana-iaḡiani, korana ḡia nuḡanai guruḡa moḡonina ta tu asi etanuni. Ḡia eḡofaḡofani, moḡa tu ḡia ḡena maḡuri korikori. Korana ḡia tu ḡofaḡofa tarimana, ema ḡofaḡofa mabarari tamari. ");
INSERT INTO snc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Senaḡi au na ḡomi tu guruḡa moḡonina akira-varamini, nuḡanai ḡomi na au tu asi ḡovaḡa-moḡoniguni. ");
INSERT INTO snc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ḡomi ta na au ḡegu ai vei-rakava ta bodoḡaria ba? A bema au na guruḡa moḡonina akiraḡiani nai, kara dainai au tu asi ḡovaḡa-moḡoniguni, ei? ");
INSERT INTO snc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Barau natuna na Barau ḡena guruḡa beseḡaḡiani. A ḡomi tu dia Barau natuna, moḡa lorinai asi ḡoseḡaḡini.” ");
INSERT INTO snc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Benamo Iuda tarimari na Iesu ḡekiraiato, ḡekirato, “Ḡai tu moḡoni ḡamaoroni. Ḡoi tu Samaria tarimamu ema iauka rakavana na beboroḡimu.” ");
INSERT INTO snc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu evaḡa-veseto, ekirato, “Au tu iauka rakavana na asi beboroḡigu. Au tu Tamagu agubakauani, senaḡi ḡomi na au tu asi ḡogubakauguni. ");
INSERT INTO snc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au tauḡegu aragu vaḡa-raḡena dabarana asi avetauani; senaḡi tarima ta na evetauani, ma ḡia tu Kota eseḡaḡini tarimana. ");
INSERT INTO snc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Moḡoni veḡata, akiramini, au ḡegu guruḡa bekorana-iaḡirini tarimana tu asi bemaseni.” ");
INSERT INTO snc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iuda tarimari ḡekirato, “Ḡai toma baḡa riba-ginikau, ḡoi tu iauka rakavana na eboroḡimuto. Aberahamo emaseto, peroveta tarimari maki ḡemaseto, a ḡoi okirani, deikara na ḡoi ḡemu guruḡa bekorana-iaḡirini tarimana tu asi bemaseni. ");
INSERT INTO snc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ḡai tamama Aberahamo emaseto. Ḡoi na ḡia, tamama Aberahamo, ovanaḡiato, ei? Ḡia emaseto ema peroveta tarimari maki ḡemase-ḡosito. Ḡoi otuḡamaḡini, ḡoi tu deikara?” ");
INSERT INTO snc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu evaḡa-veseto, ekirato, “Bema au tauḡegu bara vevaḡa-raḡe, ḡegu vevaḡa-raḡe tu asi tauna. Senaḡina au tu Tamagu na evaḡa-raḡeguni. Ma ḡia tu ḡomi na ḡokiraḡiani, ḡokirani, ḡomi ḡemi Barau ḡotoni. ");
INSERT INTO snc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ḡomi tu asi ribami ḡia, senaḡi au tu ma ribagu ḡia. Bema au bara kira, au asi ribagu ḡia, au tu ḡofaḡofa tarimagu ḡomi kavana, senaḡi au ma ribagu ḡia ema ḡena guruḡa akorana-iaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ḡomi tamami Aberahamo etuḡa-maḡito, au ḡegu iaḡoma ḡarona beḡitaiani etato, benamo eiakuto. Eḡitaiato, benamo iauna enamoto.” ");
INSERT INTO snc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iuda tarimari na Iesu ḡekiraiato, ḡekirato, “Ḡoi ḡemu maḡuri laḡaniri tu gabana imaima (50) maki roḡosi bene doḡaria, ma kamasi tu Aberahamo oḡitaiato otoni?” ");
INSERT INTO snc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu na evaḡa-veserito, ekirato, “Moḡoni akiramini, Aberahamo roḡosi roḡo bere ḡora veḡata, au tu atanuto-ḡoi.” ");
INSERT INTO snc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Benamo fore ḡeḡabito, ḡetakia ḡetato, senaḡi Iesu egumuto, benamo vekaravari na Rubu Veaḡa na eraka-rosito. ");
INSERT INTO snc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu eraka-vanaḡito-ḡoi nuḡanai, tarima ta eḡitaiato. Mo tarima tu mata-bubu emaḡurito. ");
INSERT INTO snc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ḡena mero na Iesu ḡedanaḡiato, ḡekirato, “Vevaḡa-riba tarimamu, deikara evei-rakavato, benamo mai tarima matana bubu emaḡurito? Ḡia ba tamana sinana?” ");
INSERT INTO snc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu evaḡa-veseto, ekirato, “Dia ḡia ḡena rakava o dia tamana sinana ḡeri rakava dainai, senaḡi maiḡesi evetoreto korana tu, Barau ḡena seḡuka ḡia ḡenana bene fofori ḡana. ");
INSERT INTO snc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Au etuḡuguto Barauna ḡena ḡauvei tu laḡani nuḡanai bisini veiri. Boḡi mani eiaḡomani, ma ta asi beḡauveini riba. ");
INSERT INTO snc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Au roḡo tanobarai atanuni nuḡanai, au tu tanobara mamana.” ");
INSERT INTO snc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mai guruḡa ekiraḡiato murinai, Iesu tano ai ekanunuto. Kanununa na nigo emoḡeato, benamo mo nigo na mata-bubu tarimana matana eianaiato. ");
INSERT INTO snc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma ekiraiato, ekirato, “Noiaḡo, ḡoiramu Siloam kounai noa ḡuriḡia.” Siloam anina tu “Barau na etuḡuato tarimana.” Benamo eiaḡoto, ḡoirana ea ḡuriḡiato, ma eḡenoḡoito nai, matana tu varau eiaḡaiato. ");
INSERT INTO snc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ḡia sevina tarimari e vanaḡi-vanaḡi enoḡinoḡito-ḡoi gabunai ḡeḡitaiato-ḡoi tarimari ḡevedanaḡito, ḡekirato, “Mai tarima tu noḡinoḡi gabunai etanu-taḡoto-ḡoi tarimana ene?” ");
INSERT INTO snc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kota ḡekirato, “Tarimana tu maniḡa.” Senaḡi kota ḡekirato, “Asiḡina, mani tu tarima boruna ta, senaḡina ḡitaḡitana moḡo ḡia kavana.” Benamo ḡia tauḡena ekirato, “Tarimana tu au maiḡegu.” ");
INSERT INTO snc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tarimarima ḡekirato, “Be ḡoi matamu tu kamasi boiaḡaia?” ");
INSERT INTO snc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ḡia evaḡa-veseto, ekirato, “Mo tarima arana Iesu, ḡia na nigo bemoḡea, ma au matagu ai beianaia, benamo bekiragu, ‘Siloam kounai noa ḡuriḡia.’ Baiaḡo, baḡuriḡia, benamo matagu baiaḡaia.” ");
INSERT INTO snc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma ḡedanaḡiato, ḡekirato, “Tarimana tu aiḡa?” Ḡia evaḡa-veseto, ekirato, “Au asi ribagu.” ");
INSERT INTO snc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Benamo matana enamoto tarimana Farisea tarimari ḡeri ai ḡeḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mo ḡaro Iesu na nigo emoḡeato, ma mata-bubu tarimana matana evaḡa-namoato tu Sabadi ḡarona. ");
INSERT INTO snc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Moḡa lorinai Farisea tarimari na ma ḡedanaḡi-ḡenoḡoiato, kamasi matana eiaḡaiato. Ḡia na ekirarito, ekirato, “Mo tarima na matagu nigo na eianaiato, benamo ḡoiragu aḡuriḡiato, ma toma tu aboḡeboḡeni.” ");
INSERT INTO snc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisea tarimari kotari ḡekirato, “Mai tarima tu dia Barau ḡenana eiaḡomato, korana ḡia na Sabadi asi ekorana-iaḡiani.” Ma kotari ḡekirato, “Vei-rakava tarimari na moḡesina veiḡari tu kamasi beḡe veirini?” Monana ḡia tauḡeri fakari ai ḡevetavi-kirato. ");
INSERT INTO snc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Benamo Farisea tarimari na mo tarima ma ḡedanaḡiato, ḡekirato, “Ḡoi okirani ḡia na matamu bevaḡa-iaḡaia otoni? Ḡoi na ḡia tu kamasi oḡitaiani?” Ḡia evaḡa-veseto, ekirato, “Ḡia tu peroveta tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iuda tarimari na mai tarima ḡena guruḡa asi ḡevaḡa-moḡoniato, korana ekirato, ‘Tovotovonai au matagu tu bubu, a mai vau aboḡeboḡe-ginikauni.’ Moḡa lorinai tamana e sinana ḡekea-iaḡomarito. ");
INSERT INTO snc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Benamo ḡia na ḡedanaḡirito, ḡekirato, “Mai tu ḡomi natumi ba? Ma moḡoni ḡia tu mata-bubu emaḡurito ḡotoni? Ma kamasi nai tu vau mai ma eboḡe-boḡeni?” ");
INSERT INTO snc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Benamo tamana e sinana ḡevaḡa-veseto, ḡekirato, “Ḡai ribama, ḡia tu ḡai natuma, ema ḡai ribama maki, ḡia tu mata-bubu emaḡurito. ");
INSERT INTO snc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Senaḡi ḡai tu asi ribama, maitoma tu kamara dabarai eboḡeboḡeni. Ḡai maki asi ribama, dei na matana bevaḡa-namoa. Ḡodanaḡia, ḡia tu mero barego, be tauḡena bevaḡa-veseni.” ");
INSERT INTO snc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana e sinana moḡesi ḡekirato, korana Iuda tarimari gariri ḡeveito nai. Korana Iuda tarimari na ḡevaḡa-moḡoniato, tarima ta na Iesu bekiraḡiani Keriso betoni tarimana tu, rubu na beḡe tore-veḡitaiani. ");
INSERT INTO snc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Moḡesi naima tamana e sinana ḡekirato, “Ḡia mero barego, be ḡodanaḡia,” ḡetato. ");
INSERT INTO snc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Matana enamoto tarimana ma ḡekea-ḡenoḡoiato, benamo ḡekiraiato, ḡekirato, “Barau novaḡa-raḡea, be noguruḡa-korikori. Ḡai ribama, ḡoi matamu bevaḡa-namoa tarimana tu vei-rakava tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Matana enamoto tarimana evaḡa-veseto, ekirato, “Au asi ribagu, ḡia tu vei-rakava tarimana ba asiḡi. Dagara sebona moḡo ma ribagu: Au matagu tu bubu, senaḡi toma tu aboḡeboḡeni.” ");
INSERT INTO snc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ḡia na ḡekiraiato, ḡekirato, “Mo tarima tu kara eveiato ḡoi ḡemu ai? Ḡoi matamu bubu na tu kamasi evaḡa-fafaiato?” ");
INSERT INTO snc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ḡia evaḡa-veseto, ekirato, “Au na ḡomi tu varau bakira-varami, senaḡi ḡomi asi ḡoseḡaḡini. Karase nai ḡourani ma ḡoseḡaḡi-ḡenoḡoi ḡotoni? Ḡomi maki ḡia ḡena mero ai boḡono iaḡo ḡotoni ba?” ");
INSERT INTO snc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Benamo ḡia na ḡeguruḡa-gwaḡiḡi viniato, ḡekirato, “Ḡoi neḡi ḡia ḡena mero, ḡai tu Mose ḡena mero. ");
INSERT INTO snc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ḡai ribama Barau na Mose evaḡa-guruḡaiato. A mani tarima, ḡai asi ribama ḡia tu ainana eiaḡomato!” ");
INSERT INTO snc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Matana enamoto tarimana evaḡa-veseto, ekirato, “Ia, ḡomi tu kamasi ma ḡoguruḡani, ma ḡokirani ḡomi tu asi ribami ḡia tu ainana eiaḡomato ḡotoni? Senaḡina ḡoḡitaia, ḡia na tu au matagu bevaḡa-namoa. ");
INSERT INTO snc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ḡita ma ribara, Barau na vei-rakava tarimari tu asi eseḡaḡi-vinirini, a deikara na ḡia ḡekorana-iaḡiani e ḡena ura veiḡari ḡeveirini tarimari, ḡia na tu eseḡaḡi-vinirini. ");
INSERT INTO snc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tanobara evesinato na veḡata tarima ta roḡosi tara seḡaḡi, tarima ta mata-bubu eḡorato tarimana matana evaḡa-iaḡaiato. ");
INSERT INTO snc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bema mai tarima Barau ḡenana asi bere iaḡoma, ḡia na dagara ta asi bere veia riba.” ");
INSERT INTO snc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡoi tu omaḡurito veḡata na rakava tarimamu, ma kamasi tu ḡai novaḡa-ribama otoni?” Benamo rubu nuḡana na ḡelai-rosiato. ");
INSERT INTO snc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu eseḡaḡito, matana enamoto tarimana tu ḡelai-rosiato, benamo tarimana edoḡariato nai tu, ekiraiato, ekirato, “Tarimarima Natuna ovaḡa-moḡoniani ba, ei?” ");
INSERT INTO snc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mo tarima evaḡa-veseto, ekirato, “Vereḡauka, ḡia tu dei? Nokira-varagu, be bana vaḡa-moḡonia.” ");
INSERT INTO snc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu na ekiraiato, ekirato, “Tarimana tu varau oḡitaiani maiḡa, ḡoi initoma ḡia ḡesi ḡoguruḡa-guruḡani.” ");
INSERT INTO snc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Benamo matana enamoto tarimana ekirato, “Vereḡauka, avaḡa-moḡonimuni.” Benamo evetui-tarito, Iesu etoma-rakariḡo viniato. ");
INSERT INTO snc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu ekirato, “Au tu vevaḡa-kota uranai mai tanobara ḡana aiaḡomato, mata-bubu tarimari beḡene boḡeboḡe ḡana, ema ḡeboḡeboḡeni tarimari matari beḡene bubu ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisea tarimari kota monai ḡia ḡesi, mai guruḡa ḡeseḡaḡiato, benamo ḡekiraiato, ḡekirato, “Ḡoi okirani, ḡai tu mata-bubu otoni?” ");
INSERT INTO snc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu evaḡa-veseto, ekirato, “Bema ḡomi mata-bubu nai tu, ḡomi asi ḡemi rakava ḡoro tanu, senaḡi ḡomi ḡokirani ‘Ḡai matama tu iaḡataḡo’ ḡotoni, naima ḡomi ḡemi rakava tu roḡo iatami ai.” ");
INSERT INTO snc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu ekirato, “Moḡoni, au na ḡomi akira-korikorimini, mamoe maḡuna ḡatama bokana na asi beraka-toḡani, senaḡi dabara ta na befaḡa-seḡini tarimana tu lema e verari-verari tarimana. ");
INSERT INTO snc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A mamoe ḡitaḡauri tarimana tu ḡatama-boka na beraka-toḡani. ");
INSERT INTO snc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ḡatama-boka narinarina tarimana na ḡena ḡatama-boka bekeoani, benamo mamoe na ḡia garona ḡeseḡaḡiani. Ḡia na ḡena mamoe arari evatorini, benamo eḡori-rosirini. ");
INSERT INTO snc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ḡena mamoe mabarari eḡori-rosirini, benamo ḡia ḡoirari ai erakani, ma ḡena mamoe ḡia murinai ḡerakakauni, korana mamoe ma ribari ḡia garona. ");
INSERT INTO snc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A tarima boruna ta murina na tu asi beḡe iaḡoni, asiḡina ḡinavaḡi; tarima boruna ḡenana tu beḡe raga-kwareḡani, korana ḡia garona mamoe tu asi ribari.” ");
INSERT INTO snc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu na mo barabore ekira-vararito, senaḡi ḡia tu asi ḡetuḡamaḡi-fakato. ");
INSERT INTO snc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Benamo Iesu na ma ekirarito, ekirato, “Au na moḡoni akiramini. Au tu mamoe ḡeri ḡatama-boka. ");
INSERT INTO snc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ḡeiaḡoma-guineto tarimari mabarari tu lema e verari-verari tarimari. A mamoe na garori asi ḡeseḡaḡirito. ");
INSERT INTO snc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Au tu ḡatama-boka. Deikara au ḡeguna beraka-toḡani tarimana tu bemaḡurini. Beraka-toḡani, beraka-rosini, ema ḡaniḡani beḡoitaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Lema tarimana tu asi beiaḡoma-kavani. Senaḡi ḡia tu lema beiaḡomani, vaḡivaḡi beiaḡomani, vevaḡa-rakava kwaikwai beiaḡomani. A au aiaḡomato tu, maḡuri beḡene ḡabia, ema maḡuri na beḡene vonuvonu-raḡe ḡana. ");
INSERT INTO snc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Au tu mamoe ḡitaḡauri tarimagu namona. Mamoe narinariri tarimana namona tu ḡena maḡuri etore-tariani mamoe urari ai. ");
INSERT INTO snc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ḡauvei tarimana ḡevoiani vau mamoe eḡitaḡauni tarimana, ḡia tu dia mamoe ḡitaḡauri tarimana korikori, ema ḡia tu dia mamoe biagunari. Moḡa lorinai boḡa kwaivana rakavana eiaḡomani beḡitaiani nai, mamoe beiaḡuirini ma beraga-kwareḡani. Benamo boḡa kwaivana rakavana na beḡabi-taririni, benamo bevaḡa-gari lausirini. ");
INSERT INTO snc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma voina tarimana eraga-kwareḡani, korana ḡia tu vetuḡunaḡi tarimana ma voina, ema mamoe maki asi etuḡamaḡi-kaurini. ");
INSERT INTO snc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Au tu mamoe narinariri tarimagu namona. Ḡegu mamoe ribagu e ḡegu mamoe maki ma ribari au. ");
INSERT INTO snc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Vaḡa-ilailana Tamagu ribana au e au maki ribagu Tamagu kavana. Ema ḡegu maḡuri maki atore-tariani ḡia urari ai. ");
INSERT INTO snc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Au ma ḡegu mamoe irauri kotari ḡetanuni. Senaḡi ḡia mai seri nuḡanai tu asi tauri roḡo. Au na ḡia maki baḡori-iaḡomarini. Ḡia na au garogu beḡe seḡaḡiani, ema ḡia maki mai seri sebonai beḡe iaḡoni e ḡitaḡauri tarimana maki sebona. ");
INSERT INTO snc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamagu na eura-viniguni, korana ḡegu maḡuri tu atore-tariani, ema ma baḡabi-ḡenoḡoiani. ");
INSERT INTO snc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tarima ta na au ḡegu maḡuri asi beḡabi-vaḡiani au ḡeguna. Au tauḡegu ḡegu urai atore-tariani. Au tu ma ḡegu seḡuka batore-tariani, ema ma ḡegu seḡuka baḡabi-ḡenoḡoiani. Moḡa tu au Tamagu na ekiraguto bana veia.” ");
INSERT INTO snc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mai guruḡa ḡaramanai Iuda tarimari tauḡeri vekaravari ai moḡo ma ḡevevarekira-ḡenoḡoito. ");
INSERT INTO snc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tarima vovoka ḡekirato, “Ḡia tu iauka rakavana na beboroḡia, be bebabo. Karase nai ḡia ḡoseḡaḡi-viniani?” ");
INSERT INTO snc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Senaḡi tarima kotari ḡekirato, “Tarima ta iauka rakavana na beboroḡiani nai tu, maiḡesi asi beguruḡani. Iauka rakavana na mata-bubu tarimari matari tu kamasi bevaḡa-fafarini?” ");
INSERT INTO snc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Monai Rubu Veaḡa Vaḡa-veaḡana Verekona Ierusalemai ḡarona eḡabiato. Mo tu faraka ḡueri nuḡanai. ");
INSERT INTO snc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma Iesu tu Rubu Veaḡai Solomona ḡena touraḡe na eraka-iaḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Benamo Iuda tarimari na ḡeruḡa-ḡeḡeraḡiato, benamo ḡedanaḡiato, ḡekirato, “Ḡai tu roḡo ḡadaradarani. Aitoma vau bokira-varamani, ḡoi tu deikara? Bema ḡoi moḡoni Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna), nai tu, ḡemai novekiraḡi-fofori ginikau.” ");
INSERT INTO snc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu na evaḡa-veserito, ekirato, “Au na tu varau akiramito, senaḡina asi ḡovaḡa-moḡoniguni. Au Tamagu aranai aveirini veiḡari na tu au ḡevaḡa-foforiguni. ");
INSERT INTO snc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Senaḡi ḡomi na asi ḡovaḡa-moḡoniguni, korana ḡomi tu dia au ḡegu mamoe. ");
INSERT INTO snc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Au ḡegu mamoe na tu au garogu ḡeseḡaḡiani. Ema au ribagu ḡia, ema ḡia tu au murigu ai ḡerakani. ");
INSERT INTO snc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Benamo au na maḡuri vanaḡivanaḡi avinirini, ema ḡia tu asiḡina ḡinavaḡi beḡe maseni; ema ta na au ḡeguna asi beḡabi-ḡerevaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ḡia tu au Tamagu na au eviniguto, e au Tamagu tu iaru-korokoro, ta na asi bevanaḡiani. Ema ta na maki asi ilaila ḡia ḡena veḡitaḡau seḡukana ḡenana beḡabi-ḡerevaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Au ema au Tamagu tu sebona moḡo.” ");
INSERT INTO snc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Benamo Iuda tarimari fore ma ḡeḡabito, ḡetakia ḡetato. ");
INSERT INTO snc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesu na ekirarito, ekirato, “Veiḡa namori vovoka ḡomi ḡoirami ai aveirito. Mo veiḡa mabarari tu au Tamagu na eviniguto bana veiri etato. Moḡeri veiḡa mabarari fakari ai tu, kamara veiḡa ḡaramanai ḡourani au ḡotakigu ḡotoni?” ");
INSERT INTO snc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iuda tarimari ḡekirato, “Veiḡa namona ta ḡaramanai ḡoi tu asi ḡatakimuni, senaḡi ḡoi na Barau okira-fitoḡaiani nai. Ḡoi tu tarimarima moḡo, senaḡi tauḡemu Barau ai ovevaḡa-iaḡoni.” ");
INSERT INTO snc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu na evaḡa-veserito, ekirato, “Ḡomi ḡemi taravatu nuḡanai guruḡa ta tu maiḡesi ekirani, ‘Au akirato, ḡomi tu barau.’ ");
INSERT INTO snc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ḡita ma ribara, kara Buka Veaḡai ekiraḡiani guruḡana tu etanu-vanaḡi vanaḡini. Barau na mo tarimarima ekiraḡirito ‘barau’, ma Barau na ḡena guruḡa evinirito tarimari tu ḡia. ");
INSERT INTO snc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A au tu Tamagu na eḡabi-viriḡiguto, ema etuḡuguto tanobara ḡana; ma kamasi nai tu ḡokiraguni, ḡokirani, au na Barau akira-fitoḡaiani, korana au akirani, ‘Au tu Barau Natuna’ atoni ei? ");
INSERT INTO snc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bema au Tamagu ḡena veiḡa asi aveirini nai, asi boḡono vaḡa-moḡonigu. ");
INSERT INTO snc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Senaḡi ḡena veiḡa aveirini nai, mo veiḡa boḡono vaḡa-moḡoniri, bema au asi boḡono vaḡa-moḡonigu ḡotoni tu. Boḡono riba ema boḡono vaḡa-moḡonia, Tamagu tu au nuḡagu ai etanuni, ema au maki Tamagu nuḡanai atanuni.” ");
INSERT INTO snc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mo guruḡa ḡaramanai ḡeurato, Iesu ma ḡeḡabi-taria ḡetato, senaḡina ḡimari na moḡo ma eveḡabi-vaḡito, erakato. ");
INSERT INTO snc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Benamo monana Iesu ma eḡenoḡoito. Eraka-iaḡoto, Ioridana ḡarukana eraka-vanaḡito, eiaḡoto reke ta kefo, guinenai Ioane ebabatisoto-ḡoi gabuna ḡana; monai ea tanuto. ");
INSERT INTO snc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tarima vovoka ḡia ḡenai ḡeiaḡoto, benamo ḡekirato, “Ioane na vetoḡa boruna ta asi eveiato, senaḡi mai tarima guruḡana ekiraḡirito guruḡari mabarari tu moḡoni veḡata.” ");
INSERT INTO snc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Monai tarima vovoka Iesu ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania tarimana ta arana Lasaro ekeveto. Betania tu Maria ma tobana ḡuiatona Mareta ḡeri vanuḡa. ");
INSERT INTO snc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mai Maria maiḡa mainana Vereḡauka muramura bonana namo vedaureana na edioroato, ema Vereḡauka kwakuna maki ḡuina na edau-kaukauato ḡuiatona. Lasaro tu Maria tobana futuana. ");
INSERT INTO snc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Benamo mai ḡuiato ruarua na Iesu ḡena guruḡa ḡetuḡuto, ḡekirato, “Vereḡauka, ḡoi na oura-viniani tarimana tu bekeve.” ");
INSERT INTO snc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu na mo vari eseḡaḡiato nai tu, ekirato, “Mani keve na tu asi bevei-maseani. Mani tu Barau ḡena seḡuka e mareva baregona bene fofori ḡana. Ema maniḡa ḡenana Barau Natuna beḡene vaḡa-raḡea.” ");
INSERT INTO snc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu na Mareta ma tarina ḡuiatona Maria ema Lasaro tu eura-vinirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Senaḡi Lasaro ḡena keve varina eseḡaḡiato tu, ḡaro ruarua roḡo ma etanuto, mo etanuto-ḡoi gabunai. ");
INSERT INTO snc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mo ḡaro ruarua muriri ai ḡena mero evaḡa-guruḡarito, ekirato, “Ḡita tu ma siḡenoḡoi-iaḡo Iudea ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ḡena mero na ḡekiraiato, ḡekirato, “Vevaḡa-riba tarimamu, ini ḡoraḡani Iuda tarimari na tu fore na ḡetakimu ḡetato, a toma tu siḡenoḡoi-iaḡo ma otoni.” ");
INSERT INTO snc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu na evaḡa-veserito, ekirato, “Ḡaro ta nuḡanai horaḡauna mabarana tu 12 ene? Bema tarima ta laḡani mamanai erakani nai tu, asi bevefutu-naḡini, korana ḡia tu mai tanobara laḡani mamanai eboḡeboḡeni. ");
INSERT INTO snc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Senaḡi mukunai erakani tarimana tu evekaḡe-kaḡekauni, korana ḡia nuḡanai mama tu asi etanuni.” ");
INSERT INTO snc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu maiḡesi evaḡa-guruḡa-ḡosirito murinai, ma ekirarito, ekirato, “Ḡita ḡatara Lasaro tu egenani, senaḡi au tu aiaḡoni, gena na navaḡo-tataḡaia ḡana.” ");
INSERT INTO snc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Benamo ḡena mero ḡekirato, “Vereḡauka, bema egenani nai tu, vau ma benamoni.” ");
INSERT INTO snc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Senaḡina Iesu na mo tu emaseto ekiraḡiato-ḡoi. A ḡena mero mataboru ḡekirato-ḡoi tu, eiaḡaraḡini nai egena-maseto ekiraḡiani, ḡetato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Benamo Iesu na ekiravara-ginikaurito, ekirato, “Lasaro tu bemase. ");
INSERT INTO snc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Senaḡi ḡomi ḡemi namo atuḡamaḡiani nai aiakuni, mo ḡaro ai au ḡia ḡesi tu asiḡi, korana maiḡa ḡenana au boḡo vaḡa-moḡoniguni. Be si-iaḡo ḡenai.” ");
INSERT INTO snc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Benamo Tomasi, arana ta tu Didimo o Kafa ḡetato-ḡoi, na Iesu ḡena mero kotari ekirarito, ekirato, “Ḡita maki ḡia ḡesi si-iaḡo, be ḡia ḡesi bisini mase-sebona.” ");
INSERT INTO snc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu ma eraḡasito nai eribato, Lasaro tauḡanina tu ḡaro vasivasi (4) guri ai varau begena. ");
INSERT INTO snc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania e Ierusalema vefakari tu kilomita toitoi (3) kavana. ");
INSERT INTO snc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ema Iudea tarimari vovoka Mareta e Maria ḡeri ai ḡeiaḡoto, tauri beḡene vaḡa-gwaḡiḡiri ḡana, korana tobari emaseto bene. ");
INSERT INTO snc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mareta eseḡaḡito, Iesu tu eiaḡomato-ḡoi nai, eraga-raka toreḡau-iaḡoto Iesu ḡesi ḡea vedoḡarito. A Maria tu numai etanu-gwaḡiḡito. ");
INSERT INTO snc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Benamo Mareta na Iesu ekiraiato, ekirato, “Vereḡauka, ḡoi bere mainai kavana tu, au tobagu asi bere mase. ");
INSERT INTO snc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Senaḡi au ribagu, initoma maki kara dagara Barau bonoḡiani tu, Barau na bevinimuni.” ");
INSERT INTO snc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu na ekiraiato, ekirato, “Ḡoi tobamu tu bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mareta na Iesu evaḡa-veseato, ekirato, “Au ribagu, ḡaro magonai variḡisi-ḡenoḡoi ḡaronai ḡia tu ma bevariḡisi-ḡenoḡoini.” ");
INSERT INTO snc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu na Maria ekiraiato, ekirato, “Au tu variḡisi-ḡenoḡoi ema maḡuri. Au bevaḡa-moḡoniguni tarimana tu bemaseni, senaḡina roḡo maḡuri betanuni. ");
INSERT INTO snc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ema deikara maḡuri etanuni nuḡanai, au evaḡa-moḡoniguni tu asiḡina ḡinavaḡi bemaseni. Mai guruḡa ovaḡa-moḡoniani ba?” ");
INSERT INTO snc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mareta na ekiraiato, ekirato, “Oi Vereḡauka, au na avaḡa-moḡoni korikorimuni, ḡoi tu moḡoni Keriso, Barau Natuna, tanobara ḡana boiaḡomani tarimamu.” ");
INSERT INTO snc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mareta moḡesi ekirato murinai eḡenoḡoi-iaḡoto, benamo tarina Maria vekuretoḡai ea kea-ḡairiato, ekirato, “Vevaḡa-riba tarimana tu beiaḡoma ema ḡoi ekeamuni.” ");
INSERT INTO snc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria na mo guruḡa eseḡaḡiato nai, asikauna evariḡisito, benamo Iesu ḡenai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mo horai Iesu tu vanuḡai roḡosi roḡo bere raka-toḡa, ḡia roḡo Mareta na mo edoḡariato gabunai roḡo. ");
INSERT INTO snc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iuda tarimari, Maria ḡetanu-dukudukuato-ḡoi tarimari, na Maria ḡeḡitaiato, eraga-variḡisito ma eraka-rosito nai tu, murina na ḡerakato. Ḡia mataboru ḡekirato, Maria tu gara ḡana eiaḡoni, mase tarimana nea taḡi-vinia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria eiaḡoto, Iesu sevinai eraḡasito, ma Iesu eḡitaiato nai tu, kwakuna koranai evetui-tarito, benamo evaḡa-guruḡaiato, ekirato, “Vereḡauka, ḡoi bere mainai kavana tu, au tobagu asi bere mase.” ");
INSERT INTO snc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu na Maria eḡitaiato etaḡito-ḡoi, ema mo Iuda tarimari, ḡia ḡesi ḡeiaḡomato tarimari, maki ḡetaḡito-ḡoi nai tu, ḡia nuḡana maki tuḡamaḡina eḡabi-rakavaiato, dori etaḡito. ");
INSERT INTO snc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Benamo Iesu na edanaḡirito, ekirato, “Ainai ḡotoreato?” Ḡia na ḡevaḡa-veseato, ḡekirato, “Vereḡauka, noiaḡoma, be noma ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu etaḡito. ");
INSERT INTO snc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Benamo Iuda tarimari ḡekirato, “Ḡoḡitaia, Lasaro tu euravini-rakavaiani.” ");
INSERT INTO snc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Senaḡi Iuda tarimari kotari ḡekirato, “Mai tarima na mata-bubu tarimana matana evaḡa-iaḡaiato, be Lasaro maki asi veḡata bere vaḡa-masea, ene?” ");
INSERT INTO snc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Monana Iesu nuḡana ma evaḡa-vekwaraḡi lelevaḡiato, benamo gara gabuna ḡana eiaḡoto. Mo gara forena kouḡana tu fore ta na ḡetabe-ḡauato. ");
INSERT INTO snc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu ekirato, “Fore ḡoḡabi-veḡitaia.” Ma Mareta, mo mase tarimana tobana, na Iesu ekiraiato, ekirato, “Vereḡauka, ḡia emaseto ḡarona na beiaḡoma toma tu ḡaro vaḡa-vasivasina (4), be bonana tu rakava kwaikwai banaḡu.” ");
INSERT INTO snc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu na Mareta ekiraiato, ekirato, “Au na ḡoi tu bakiramu, bema bovaḡa-moḡoniguni nai, Barau marevana baregona boḡitaiani basi, ene?” ");
INSERT INTO snc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Benamo mase tarimana ḡetoreato gabuna na fore ḡeḡabi-veḡitaiato. Moḡa murinai Iesu eboḡe-vaisito, benamo ekirato, “Tamagu o, au na ḡoi atanikiumuni, korana ḡoi na varau boseḡaḡigu. ");
INSERT INTO snc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Au ribagu, ḡoi na vanaḡivanaḡi oseḡaḡiguni. Senaḡi maiḡesi akirani korana tu mai tarimarima ḡeruḡa-taḡoni maiḡeri urari ai. Be ḡia na beḡene vaḡa-moḡonia, au tu ḡoi na otuḡuguto.” ");
INSERT INTO snc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Moḡesi eguruḡato murinai ekea-fararato, ekirato, “Lasaro, noma rakarosi!” ");
INSERT INTO snc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Benamo mo emaseto tarimana mase dabuḡari na ḡimana kwakuna viriviri-tari e ḡoirana ekumu-iaḡiato dabuḡana ḡesi ema raka-rosito. Iesu na ekirarito, ekirato, “Ḡoruḡaia, be neraka.” ");
INSERT INTO snc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Benamo mo Iuda tarimari vovoka, Maria ḡenai ḡeiaḡoto moḡeri, Iesu na mo veiḡa eveirito ḡeḡitarito nai, vovoka tu Iesu ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Senaḡi kotari tu ḡeḡenoḡoi-iaḡoto Farisea tarimari ḡeri ai, benamo Iesu na kara eveirito dagarari ḡea kira-vararito. ");
INSERT INTO snc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Benamo Rubu Veaḡa vereri baregori ema Farisea tarimari na kanisoro tarimari ḡekea-vegogorito, benamo ḡekirato, “Ḡita tu kara toma taveiani? Mai tarima na vetoḡa boruri vovoka eveirini. ");
INSERT INTO snc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bema ḡia maiḡesi ḡita na bita ḡita-ḡuiraḡiani moḡo nai tu, tarimarima mabarari na ḡia beḡe vaḡa-moḡoniani. Benamo Roma tarimari beḡe iaḡomani, ḡita ḡera gabu (o Rubu Veaḡa) ema ḡera tanobara ḡita ḡerana beḡema ḡabi-vaḡiani.” ");
INSERT INTO snc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Benamo ḡia fakari ai tarima ta arana Kaiafas, ḡia mo laḡani ai tu Rubu Veaḡa verena baregona, ḡia na ekirarito, ekirato, “Ḡomi dagara ta tu asi ribami! ");
INSERT INTO snc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ḡomi asi ḡotuḡamaḡi-fakani, namona tu tarima sebona moḡo tarimarima mabarari urari ai bene mase, a mai tanobara mabarana beḡe vaḡa-rakava ḡosiḡosiani tu asi namo.” ");
INSERT INTO snc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ḡia moḡesi ekirato tu, dia ḡia tauḡena nuḡana siga moḡo eguruḡato; senaḡi ḡia mo laḡani ai tu Rubu Veaḡa verena baregona, moḡa lorinai ḡia mo tu eperovetato, Iesu tu bene mase Iuda tarimari mabarari urari ai. ");
INSERT INTO snc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ema Iesu tu dia Iuda tarimari moḡo urari ai bemaseni. Senaḡi Barau natuna gabu irauirau ai ḡetanu-lausilausini tarimari mabarari bene ḡabi-vegogori, doḡoro sebonai bene vaḡa-iaḡori ḡana. ");
INSERT INTO snc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Moḡa lorinai mo ḡaro na evesinato eiaḡoto tu, Iuda tarimari baregori na Iesu kamasi beḡe vaḡi-maseani dabarana ḡevetauato. ");
INSERT INTO snc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Moḡesina naima Iuda tarimari ḡoirari ai Iesu asi eraka-foforito-ḡoi. Mo gabu na eraka-veḡitato, eiaḡoto tano fakana asi tarimarimana gabuna sevinai, vanuḡa ta arana Efraim ḡana. Ḡena mero ḡesi monai ḡea tanuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuda tarimari ḡeri Pasova verekona tu ekavinaḡito. (Moḡa tu Iuda tarimari mase aneruna na evanaḡirito moḡo, asi evaḡirito verekona). Ma Iuda tarimari vovoka mo tanobarai ḡetanuto Ierusalemai ḡema raka-vegogoto. Ḡia ḡema raka-vegogoto tauna korikori, Barau ḡoiranai beḡene veiareva vauro, Pasova verekona bene vesina. ");
INSERT INTO snc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ḡia na Iesu ḡeḡita-vetauato-ḡoi, ma Rubu Veaḡa nuḡanai ḡeruḡa-vegogoto nai tu, tauḡeri fakari ai moḡo ḡevedanaḡi-vedanaḡito, ḡekirato, “Ḡomi tu kamasi mani ḡotuḡamaḡini? Mai vereko ai toma ema ḡoira-refoni ba?” ");
INSERT INTO snc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rubu Veaḡa vereri baregori ema Farisea tarimari na vevaḡa-naḡi guruḡana tu varau Iuda tarimari ḡevinirito, ḡekirarito, bema ta beseḡaḡini Iesu tu ainai, ḡia tu maoromaoro bene iaḡo, Iuda vereri benea kira-varari, be beḡene ḡabia. ");
INSERT INTO snc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona tu ḡaro imaima sebona (6) roḡo ḡoirai nuḡanai, Iesu Betania ḡana eiaḡoto. Lasaro tu Betaniai etanuto-ḡoi, ema monai emaseto, ma Iesu na mase na evaḡa-variḡisiato. ");
INSERT INTO snc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Monai Iesu ḡabiraḡena ḡaniḡanina ḡeveiato. Mareta na ḡari ḡaniḡani edabaraiato, ma Lasaro maki monai ḡaniḡani gabunai ḡetanu-vegogoto tarimari ḡesi ḡetanu-vegogoto, ḡeḡaniḡanito. ");
INSERT INTO snc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Benamo Maria na muramura bonana namo vedaureana lita kwana kavana eḡabiato, benamo Iesu kwakuna fanafanana ediḡa-iaḡiato, ema ḡuina na Iesu kwakuna fanafanana ma edau-kaukauato. Ma numa mabarana tu mo muramura bonana na evaiato. Mo muramura tu ḡauḡa arana nad ḡokana na ḡeveito-ḡoi, ema voina tu varaḡe rakava. ");
INSERT INTO snc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Senaḡi Iesu ḡena mero ta arana Iudas Isakariota, mai tu Iesu vau ma bea revaiani tarimana, ekirato, ");
INSERT INTO snc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Karase mai muramura mabarana tu silva moniri sinau toitoi (300) ai asi bevoivoi-iaḡia? (Mai tu tarima ta davana laḡani ta nuḡanai kavana). Bere voivoi-iaḡia, be voina monina bere ḡabia tu, asi ḡeri-ḡari tarimari bere viniri.” ");
INSERT INTO snc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ḡia moḡesina eguruḡato tu, dia asi ḡeri-ḡari tarimari evetuḡa-ḡwarito-ḡoi lorinai, senaḡi korana ḡia tu lema tarimana naima. Ḡia na tu moni fusena eḡwa-rakao rakaoato-ḡoi, ma mo fuse ai moni elemarito-ḡoi, benamo ḡena ura dagarari evoi-iaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Benamo Iesu ekiraiato, ekirato, “Ḡoraga-kwanea, mai vavinena tu kara bere veia dagarana beveia, ḡia na au tauḡanigu muramura na bedau-guinea, gurigurigu ḡana. ");
INSERT INTO snc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Asi ḡeri-ḡari tarimari tu vanaḡivanaḡi ḡomi ḡesi boḡo tanuni, a au tu vanaḡivanaḡi ḡomi ḡesi asi batanuni.” ");
INSERT INTO snc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iuda tarimari vovoka tabutabu ḡeseḡaḡito Iesu tu Betania ai. Benamo moḡana ḡeiaḡoto, dia Iesu moḡo uranai, senaḡi Lasaro maki beḡene ḡitaia ḡana. Lasaro tu mase na Iesu na evaḡa-variḡisi ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Moḡesi naima Rubu Veaḡa vereri baregori tu ḡeboioḡato, Lasaro maki beḡene vaḡi-masea ḡetato. ");
INSERT INTO snc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Korana tu ḡia dainai Iuda tarimari vovoka ḡia ḡerina ḡeraka-veḡitato, benamo Iesu ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ma elaḡanito nai, vereko uranai ḡeiaḡomato tarimari vovoka ḡeseḡaḡito, Iesu tu Ierusalema ḡana varau eraka-iaḡomato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Galamo lauri noḡa dagarari ḡeḡabito, benamo Iesu ḡenai ḡeiaḡoto, ḡeḡabato, ḡekirato, “Hosana! Isaraela ḡeri Kini sivaḡa-namoa, Vereḡauka aranai eiaḡomani tarimana sivaḡa-namoa!” ");
INSERT INTO snc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ma Iesu na doniki natuna ta edoḡariato, benamo iatanai etanukauto, Buka Veaḡa nuḡanai ekirani ilailanai, ");
INSERT INTO snc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siona natuna, (Ierusalema tarimami), asi ḡogari, ḡoboḡe, ḡemi Vere eiaḡomani, ḡia tu doniki natuna iatanai betanukau.” ");
INSERT INTO snc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mo ḡaro ai ḡena mero na maiḡeri tu asi ḡetuḡamaḡi-fakarito. Senaḡi Barau na Iesu evaḡa-raḡeato e mareva baregona eviniato murinai vau, ḡia ḡeriba-maoroto, maiḡeri mabarari ḡetorerito tu, ḡia ḡekiraḡiato. Ema ḡeribato, mo veiḡa mabarari tu ḡia ḡenai ḡeveirito. ");
INSERT INTO snc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu na Lasaro gara forena kouḡana na ekea-rosiato, ema mase na evaḡa-variḡisiato ḡaronai, tarimarima tu ḡutuma-bara ḡia ḡesi. Benamo moḡeri tarima na mo veiḡa ḡeḡitaiato varina tu roḡo ḡevari-fiuato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tarima ḡutuma ḡeiaḡoto Iesu ḡesi vedoḡari, korana ḡeseḡaḡito, Iesu na mo vetoḡa boruna eveiato dainai. ");
INSERT INTO snc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Moḡesina nai Farisea tarimari tauḡeri fakari ai ḡevedare-mutukato, ḡekirato, “Ḡoḡitaiani, ḡomi tu asi ḡokokoreni. Ḡoboḡe, mai tanobara tarimana mabarana tu ḡia murinai ḡerakani.” ");
INSERT INTO snc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Vereko ḡaronai toma-rakariḡo uranai Ierusalema ḡana ḡevaraḡeto tarimari fakari ai tu, Grik o Helene tarimari kotari maki ḡerakakauto. ");
INSERT INTO snc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ḡia ḡeiaḡoto Filipo ḡenai, benamo ḡekiraiato, ḡekirato, “Verebara, ḡai ḡaurani tu Iesu ḡaḡitaia ḡatoni.” Filipo tu Galilea tanonai vanuḡa arana Betesaida tarimana. ");
INSERT INTO snc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo eiaḡoto Anduru ea kiraiato, benamo tauri ruarua ḡeiaḡoto, Iesu ḡekiraiato. ");
INSERT INTO snc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu na evaḡa-veserito, ekirato, “Ḡarona varau bema-raḡasi, Tarimarima Natuna mareva baregona beḡabiani. ");
INSERT INTO snc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Moḡoni korikori akiramini, widi ḡuena tano nuḡanai beketo-ḡurani ema bemaseni vau, vovokari ḡia ḡenana beḡe ḡorani. A widi ḡuena tano ai asi beketoni ema asi maki bemaseni nai, ḡereḡana moḡo betanuni. ");
INSERT INTO snc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ḡena maḡuri eura-viniani tarimana na maḡuri vanaḡivanaḡi tu asi beḡabiani, beleaiani. A mai tanobarai ḡena maḡuri etuḡamaḡi-fitoḡaiani tarimana na, ḡena maḡuri tu etore-taḡoani maḡuri vanaḡivanaḡi ḡana. ");
INSERT INTO snc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Au vetuḡunaḡigu eiaḡo-vinini tarimana tu au murigu na bene raka; be au ainai, au vetuḡunaḡigu eiaḡo-vinini tarimana maki monai au ḡesi. Au vetuḡunaḡigu eiaḡo-vinini tarimana tu, au Tamagu na ḡia maki bevaḡa-namoani.” ");
INSERT INTO snc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Maitoma au nuḡagu tu evekwaraḡini, e ḡegu tuḡamaḡi bebarego. Be kara batoni? Nakira, ‘Tama, mai hora na noma vaḡa-maḡurigu’ nasi? Asiḡina, au ḡegu iaḡoma tauna korikori aoanai tu mai bama raḡasi maiḡea. ");
INSERT INTO snc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamagu, ḡoi aramu novaḡa-raḡea.” Benamo garo ta guba na emariḡoto, ekirato, “Au na aragu tu varau bavaḡa-raḡea, ema mai maki ma bavaḡa-raḡe ḡenoḡoiani.” ");
INSERT INTO snc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tarima ḡutuma monai ruḡa-vegogo na mo garo ḡeseḡaḡiato, benamo ḡekirato, “Guba begurua.” Ma kotari ḡekirato, “Aneru ta na bevaḡa-guruḡaia.” ");
INSERT INTO snc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu na evaḡa-veserito, ekirato, “Mani garo tu dia au uragu ai nai beiaḡoma, senaḡi ḡomi urami ai nai beiaḡoma. ");
INSERT INTO snc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maitoma tu tanobarai Barau na vevaḡa-maoro eveiani. Maitoma Barau na mai tanobara verena, Satani, evaḡa-darereani. ");
INSERT INTO snc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Benamo au tano iatana na beḡe ḡabi-vaisiguni, monana tarimarima mabarari au ḡegu ai bainu-kavirini.” ");
INSERT INTO snc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ḡia maiḡesi eguruḡato tu, ḡia ḡena mase ai tu aiḡesi bemaseni moḡa ekiraḡi-rosiato. ");
INSERT INTO snc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tarimarima ḡevaḡa-veseto, ḡekirato, “Ḡai taravatu guruḡari na ḡaseḡaḡito, Keriso tu betanu-vanaḡi vanaḡini, ma ḡoi kamasi nai tu okirani, Tarimarima Natuna tu beḡe ḡabi-vaisiani? Tarimarima Natuna tu deikara ei?” ");
INSERT INTO snc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Benamo Iesu na ekirarito, ekirato, “Mama ḡomi ḡesi tu asi betanu-maukani. Mama roḡo ḡomi ḡesi nuḡanai, mamai ḡoraka, mukuna na beḡabimini garina. Mukuna nuḡanai erakani tarimana tu asi ribana, ḡia tu aiḡana eiaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mama roḡo ḡomi ḡesi nuḡanai, mama boḡono vaḡa-moḡonia, be mama natunai boḡono iaḡo.” Maiḡeri guruḡa ekiraḡi-ḡosirito murinai eraga-kwanerito, benamo eiaḡoto, asi beḡe ḡoitaḡoani gabunai etanuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu na Iuda tarimari ḡoirari ai vetoḡa boruri vovoka eveirito, senaḡi roḡo mo asi ḡevaḡa-moḡoniato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Monana peroveta tarimana arana Isaia ḡena guruḡa emoḡonito, Isaia maiḡesi ekirato, “Vereḡauka, deikara na ḡai ḡema guruḡa bevaḡa-moḡonirini? Deikara ḡenai Vereḡauka ḡena seḡuka befoforini?” ");
INSERT INTO snc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ḡia na Iesu asi ḡevaḡa-moḡoniato anina tu, Isaia gabu tai ḡena toretore ai ma ekirato, ");
INSERT INTO snc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Barau na matari evaḡa-tufarito, ema nuḡari evei-mukunarito, korana matari na asi beḡene boḡeboḡe, ema nuḡari ai asi beḡene tuḡamaḡi-faka ḡana. Au ḡegu ai beḡe ḡenoḡoini, benamo bavaḡa-namorini garina.” ");
INSERT INTO snc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia moḡesi ekirato, korana ḡia na Iesu marevana e seḡukana baregona eḡita-guineato nai, benamo ḡia eguruḡa-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iuda ḡorikauna vereri vovoka na maki Iesu ḡevaḡa-moḡoniato, senaḡi Farisea tarimari gariri ḡeveito-ḡoi, be Iesu asi ḡekiraḡi-foforiato-ḡoi. Korana bema beḡe kiraḡi-foforiani nai tu, Farisea tarimari na rubu na beḡe tuḡu-vaḡirini garina. ");
INSERT INTO snc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Korana mo Iuda vereri ḡeri ura baregona tu, tarimarima na beḡene vaḡa-raḡeri, a Barau na bene vaḡa-raḡeri tuḡamaḡina tu asi ḡeveiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu efararato, ekirato, “Au bevaḡa-moḡoniguni tarimana tu dia au evaḡa-moḡoniguni, senaḡi au etuḡuguto Barauna evaḡa-moḡoniani. ");
INSERT INTO snc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ema au eḡitaguni tarimana na tu au etuḡuguto Barauna eḡitaiani. ");
INSERT INTO snc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Au tu mama, mai tanobara ḡana aiaḡomato, be au bevaḡa-moḡoniguni tarimana tu mukuna nuḡanai asi betanuni. ");
INSERT INTO snc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma bema tarima ta na au ḡegu guruḡa eseḡaḡiani, senaḡi asi evaḡa-moḡoniani, au na mo tarima tu asi bakota-viniani. Korana au tu dia tanobara kota-vinina ḡana aiaḡomato. Asiḡina. Au tu tanobara vaḡa-maḡurina ḡana aiaḡomato. ");
INSERT INTO snc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Au eruḡaguni ema au ḡegu guruḡa asi eḡabi-raḡerini tarimana, kota-vinina tarimana ta etanuni. Au na akiraḡirito guruḡari, moḡeri guruḡa na ḡia beḡea kota-viniani mo ḡaro magonai. ");
INSERT INTO snc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Korana au tu dia tauḡegu ḡegu maoro ai aguruḡani. Senaḡi Tamagu, au etuḡuguto Barauna, na evaḡa-naḡiguto au na kara guruḡana bana kiraḡia ema kamasi bana kiraḡia. ");
INSERT INTO snc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Au ribagu, Tamagu ḡena guruḡa na tarimarima maḡuri vanaḡivanaḡi beḡe ḡabini. Moḡa lorinai au na kara akiraḡirini guruḡari tu, kara dagara Tamagu na ekiraguni bana kiraḡiri etoni guruḡari moḡo.” ");
INSERT INTO snc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona tu dori eḡabiato-ḡoi, benamo Iesu eribato, mai tanobara beiaḡuiani ma Tamana ḡenai bevaraḡeni ḡarona tu varau beraḡasi. Mai tanobarai ḡena tarimarima ḡetanuto euravini-rakavarito, ma ḡena veuravini ḡeri ai tu asi edokoto, eiaḡoto mo magona. ");
INSERT INTO snc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iesu ma ḡena mero ḡesi lavilavi ḡaniḡanina ḡeḡaniato-ḡoi nuḡanai, Diabolo na Iudas Isakariota, Simona natuna, nuḡana eḡaniato, Iesu bene revaia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu ribana, Tamana na dagara mabarari tu ḡia ḡena seḡuka gaburenai etorerito. Ema ribana maki, ḡia tu Barau ḡenana eiaḡomato, ema ma beḡenoḡoini Barau ḡenai; ");
INSERT INTO snc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","benamo ḡaniḡani gabuna na evariḡisito, ḡena koudi ekoki-vaḡiato, benamo tauḡela eriḡoato. ");
INSERT INTO snc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Benamo naḡu ai nanu ebubuto, benamo ḡena mero kwakuri eḡuriḡirito, ma eriḡoato tauḡelana na tu edau-kaukaurito. ");
INSERT INTO snc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kwakuri eḡuriḡi-iaḡomato mo, Simona Petero ḡenai eraḡasito, benamo Petero na ekiraiato, ekirato, “Vereḡauka, ḡoi tu au kwakugu noḡuriḡia otoni?” ");
INSERT INTO snc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu na evaḡa-veseato, ekirato, “Maitoma au na kara aveiani veiḡana tu asi otuḡamaḡi-fakaiani, senaḡi gabivau boribani.” ");
INSERT INTO snc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petero na ekiraiato, ekirato, “Asiḡi, au kwakugu ḡoi na tu asiḡina ḡinavaḡi boḡuriḡiani.” Iesu na evaḡa-veseato, ekirato, “Bema au na ḡoi kwakumu asi baḡuriḡiani nai, ḡoi tu dia au ḡegu mero.” ");
INSERT INTO snc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Petero ekirato, “Vereḡauka, dia kwakugu moḡo, senaḡi ḡimagu ema debagu maki.” ");
INSERT INTO snc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu na ekiraiato, ekirato, “Efouni tarimana tauḡanina mabarana tu veiareva, be ḡia tu kwakuna moḡo beḡuriḡiani. Ḡomi mabarami tu veiareva, senaḡi sebona ta moḡo asi veiareva.” ");
INSERT INTO snc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu ma ribana deikara na ḡia berevaiani; moḡesina nai ekirato, “Dia mabarami veiareva.” ");
INSERT INTO snc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kwakuri eḡuriḡi-ḡosito murinai, ḡena dabuḡa baregona ma eveiato, ema eiaḡoto ḡena tanutanu gabunai ea tanu-tarito, benamo ekirarito, ekirato, “Au na ḡomi ḡemi ai kara baveia veiḡana tauna korikori boḡo tuḡamaḡi-fakaia ba? ");
INSERT INTO snc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ḡomi na au ḡokiraḡiguni, ḡokirani ‘Vevaḡa-riba Tarimana’ ema ‘Vereḡauka’, mo tu moḡoni ḡokiraḡiguni, korana au tu moḡoni Vevaḡa-riba Tarimagu ema Vereḡauka. ");
INSERT INTO snc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bema au ḡomi ḡemi Vereḡauka ema Vevaḡa-riba tarimagu na ḡomi kwakumi baḡuriḡiri nai, ḡomi maki tauḡemi fakami ai moḡo karomi tari kwakuri boḡono ḡuriḡiri. ");
INSERT INTO snc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Korana au na bavaḡa-ḡitami, be au na kara ḡomi ḡemi ai baveia veiḡana, ḡomi na maki boḡono veia. ");
INSERT INTO snc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Au na ḡomi moḡoni akiramini, ḡauvei merona na ḡena vere asi bevanaḡiani, e vetuḡunaḡi merona na betuḡua tarimana asi bevanaḡiani. ");
INSERT INTO snc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Toma maiḡeri dagara mabarari ḡomi na boḡo ribari, bema boḡo veirini nai tu boḡo iakuni. ");
INSERT INTO snc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Au na ḡomi mabarami asi akiraḡimini, au na aḡabi-viriḡirito tarimari tu au ribagu. Senaḡi mai tu Buka Veaḡa nuḡanai ḡetorerito guruḡari beḡene moḡoni ḡana: ‘Deikara au ḡesi beredi baḡa ḡani-vegogoani tarimana tu, kwakuna gwadirina beḡabi-vaisiani au ḡegu ai.’ (Moḡa anina tu, Iesu ma bekira-fitoḡaiani, benamo vaḡi-masena dabarana beveiani). ");
INSERT INTO snc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Toma au na ḡoirai beḡe ḡorani dagarari akira-varamini, be beḡe ḡorani nai tu boḡono riba-maoro, (Barau na etuḡuato) Tarimana tu Au. ");
INSERT INTO snc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Moḡoni akiramini, au na atuḡuani tarimana eḡabi-raḡeani tarimana na tu au eḡabi-raḡeguni. Ma au eḡabi-raḡeguni tarimana na au etuḡuguto tarimana, Barau, eḡabi-raḡeani.” ");
INSERT INTO snc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu na maiḡeri guruḡa ekiraḡirito murinai, nuḡana evekwaraḡi-baregoto, benamo eguruḡa-foforito, ekirato, “Akira-korikorimini, ḡomi ta na tu au borevaguni.” ");
INSERT INTO snc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Benamo ḡena mero ḡeveḡita-veḡitato, asi ribari deikara ekiraḡiato. ");
INSERT INTO snc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ḡena mero vekaravari ai Iesu na eura-viniato-ḡoi merona tu ḡia ḡenai evetabekauto. ");
INSERT INTO snc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma Simona Petero na vetoḡai moḡo Ioane evaḡa-guruḡaiato, eurato, Iesu nedanaḡia deikara ekiraḡiani. ");
INSERT INTO snc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Benamo (Iesu na eura-viniato-ḡoi merona) Iesu ḡenai ma evetabekauto, benamo edanaḡiato ekirato, “Vereḡauka, mo tu deikara, ei?” ");
INSERT INTO snc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu evaḡa-veseto, ekirato, “Au na beredi bafereiani, benamo ḡia baviniani tarimana tu moḡea.” Benamo Iesu na beredi efereiato, ma Simona natuna, Iudas Isakariota, eviniato. ");
INSERT INTO snc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iudas na mo beredi eḡabiato, benamo Satani nuḡanai eraka-ḡurato. Benamo Iesu na ekiraiato, ekirato, “Kara ourani noveia tu novei-ḡarimoḡia.” ");
INSERT INTO snc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Senaḡi mo ḡeḡaniḡani-vegogoto tarimari tu sebona ta maki asi eribato, karase nai Iesu na moḡesi ekiraiato. ");
INSERT INTO snc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Moḡa nuḡanai Iudas tu moni mauḡa-mauḡana eḡita-ḡauato-ḡoi. Moḡesina naima ḡia kotari ḡetuḡamaḡito, Iesu na tu bekiraia, vereko ai karakara ḡeura-vinirini dagarari nea voiri, o asi ḡeri-ḡari tarimari dagara tari nea viniri ḡetato. ");
INSERT INTO snc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iudas na mo beredi eḡabi-raḡeato murinai tu, asikauna mo numa na eraka-rosito. Mo tu varau eboḡito. ");
INSERT INTO snc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iudas eraka-rosito murinai, Iesu ekirato, “Maitoma Tarimarima Natuna beḡe vaḡa-raḡeani, ema Barau maki Natuna ḡenana beḡe vaḡa-raḡeani. ");
INSERT INTO snc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bema Barau na Iesu bakunai vevaḡa-raḡe e mareva baregona beḡabiani nai tu, Barau tauḡena na maki tauḡena ḡena mareva baregona Tarimarima Natuna beviniani. Ma Barau na asikauna beviniani. ");
INSERT INTO snc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natugu, au ḡomi ḡesi tu asi bita tanu-maukani. Benamo ḡomi na au ma boḡo ḡita-vetauguni. Au na Iuda tarimari avaḡa-guruḡarito ilailanai, ḡomi maki mo guruḡa sebona avinimini: Au aiaḡoni gabuna ḡana, ḡomi tu asi boḡo iaḡoni riba. ");
INSERT INTO snc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Taravatu guruḡana variḡuna avinimini. Tarikakami ḡesi boḡono veuravini. Au na ḡomi aura-vinimini ilailanai, ḡomi maki tarikakami ḡesi boḡono veuravini. ");
INSERT INTO snc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bema ḡomi tarikakami ḡesi boḡo veura-vinini nai, tarimarima mabarari beḡe ribani, ḡomi tu au ḡegu mero.” ");
INSERT INTO snc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petero na Iesu edanaḡiato, ekirato, “Vereḡauka, ḡoi tu aiḡana oiaḡoni?” Iesu evaḡa-veseto, ekirato, “Au aiḡana aiaḡoni gabuna ḡana, maitoma au murigu na tu asi boḡo iaḡomani, senaḡi gabivau boḡo iaḡomani murigu na.” ");
INSERT INTO snc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petero na Iesu ekiraiato, ekirato, “Vereḡauka, kara dainai toma au ḡoi murimu na tu asi baiaḡosini riba? Au tu ḡoi uramu ai ḡegu maḡuri batore-tariani, bamaseni.” ");
INSERT INTO snc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu na Petero evaḡa-veseato, ekirato, “Ḡoi ḡemu maḡuri tu au uragu ai botore-tariani otoni? Akira-korikorimuni, kokoroku roḡosi roḡo bene goḡi nuḡanai, ḡoi na au tu vaḡa-toitoi bokira-ḡuniḡauguni.” ");
INSERT INTO snc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nuḡami asi beḡene raḡe, ema asi boḡono tuḡamaḡi-ḡutuma. Barau boḡono vaḡa-moḡonia, ema au maki boḡono vaḡa-moḡonigu. ");
INSERT INTO snc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Au Tamagu ḡena numai daiḡutu tu asisebo; bema asiḡi nai tu, mai guruḡa ḡomi asi bara kira-varami: Au aiaḡoni tu, ḡomi ḡemi gabu ta arovina-toreani. ");
INSERT INTO snc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Benamo aiaḡoni, ḡomi ḡemi gabu barovina-toreani. Barovinatore-ḡosiani vau, ma baḡenoḡoi-iaḡomani, benamo ḡomi baḡori-iaḡomini au ḡesi bita tanuni. Be au ainai batanuni gabunai, ḡomi maki monai au ḡesi bita tanuni. ");
INSERT INTO snc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Au baiaḡoni gabuna dabarana tu ḡomi ma ribami.” ");
INSERT INTO snc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi na ekiraiato, ekirato, “Vereḡauka, ḡai tu asi ribama ḡoi aiḡana oiaḡoni, ma dabara tu kamasi baḡa ribaiani?” ");
INSERT INTO snc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu na ekiraiato, ekirato, “Dabara tu au, e moḡonina maki au, ema maḡuri maki au. Tarima ta Tamagu ḡenai dabara boruna na ta asi beiaḡoni. Asiḡina ḡinavaḡi. Au ḡeguna moḡo. ");
INSERT INTO snc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bema moḡoni au ḡomi na ḡoribaguto tu, au Tamagu maki ḡoro ribaia. Ma toma vau ḡoribaiani ema varau boḡo ḡitaia.” ");
INSERT INTO snc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo na Iesu ekiraiato, ekirato, “Vereḡauka, Tamara novaḡa-ribama, be nuḡama beḡene genatari.” ");
INSERT INTO snc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu na ekiraiato, ekirato, “Filipo, au ḡoi ḡesi tu kai-veḡata atanuto, ma ḡoi na au tu roḡosi roḡo boro ribagu? Au eḡitaguni tarimana na Tamagu eḡitaiani. Ma ḡoi tu kamasi nai okirani, ‘Tamara novaḡa-ribama otoni?’ ");
INSERT INTO snc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ḡoi na asi ovaḡa-moḡoniani, au tu Tamagu nuḡanai, ma Tamagu tu au nuḡagu ai, ei? Au na ḡomi avaḡa-guruḡamini guruḡari tu dia au tauḡegu ḡegu maoro ai avaḡa-guruḡamini. Asiḡina. Mai tu Tamagu, ḡia tu nuḡagu ai etanuni, ḡia na ḡena ḡauvei eveirini. ");
INSERT INTO snc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Au akirani, au tu Tamagu nuḡanai atanuni ema Tamagu tu au nuḡagu ai etanuni atoni nai tu boḡono vaḡa-moḡonigu. Bema asiḡina nai, mai veiḡa aveirini ḡoḡitarini nai boḡono vaḡa-moḡonigu. ");
INSERT INTO snc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Moḡoni akiramini, au evaḡa-moḡoniguni tarimana tu, au na aveirini veiḡari, ḡia na maki beveirini. Ema ḡia na tu veiḡa barego lelevaḡiri beveirini, au na aveirini veiḡari tu bevanaḡirini. Korana au tu Tamagu ḡenai ma aiaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ema au aragu ai karakara boḡo noḡirini tu, au na baveirini. Monana Tamagu beḡe vaḡa-raḡeani Natuna bakunai. ");
INSERT INTO snc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Au aragu ai kara boḡo noḡi-raḡerini dagarari mabarari tu, veiḡari au na baveirini.” ");
INSERT INTO snc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Bema ḡomi na au ḡoura-viniguni nai tu, au ḡegu taravatu guruḡari boḡo korana-iaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Benamo au na Tamagu banoḡiani, bena ḡia na vevaḡa-kava tarimana ta ma bevinimini. Mo vevaḡa-kava tarimana tu ḡomi ḡesi betanu-vanaḡi vanaḡini. ");
INSERT INTO snc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ḡia tu guruḡa moḡonina evaḡa-foforiani Iaukana. Ḡia tu tanobara maḡurinai ḡetanuni tarimari na asi beḡe ḡabi-raḡeani riba, korana asi ḡeḡitaiani ema asi ḡeribaiani. Senaḡi ḡia ḡomi tu ma ribami, korana ḡia tu ḡomi ḡesi ḡotanuni ema ḡomi nuḡami ai betanuni. ");
INSERT INTO snc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Au na ḡomi ḡereḡami gara noḡa asi baiaḡuimini. Au ma baḡenoḡoi-iaḡomani ḡomi ḡemi ai. ");
INSERT INTO snc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tanobara tarimari na asi ma beḡe ḡitaguni ḡarona tu asi manaḡa, senaḡi ḡomi na tu boḡo ḡitaguni. Ḡomi tu au amaḡuri-taḡoni bakunai, be boḡo maḡuri-taḡoni. ");
INSERT INTO snc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mo ḡaro ai ḡomi boḡo ribani, au tu Tamagu nuḡanai atanuni, ema ḡomi au nuḡagu ai ḡotanuni, ema au ḡomi nuḡami ai atanuni. ");
INSERT INTO snc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Au ḡegu taravatu guruḡari eḡabi-raḡerini ema ekorana-iaḡirini tarimana na tu au eura-viniguni. Ema au eura-viniguni tarimana tu au Tamagu na maki beura-viniani. Au na maki baura-viniani ema au tauḡegu ḡia ḡenai bavevaḡa-foforini.” ");
INSERT INTO snc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iudas, dia Iudas Isakariota, na ekiraiato, ekirato, “Vereḡauka, kamasi nai ḡoi tauḡemu ḡai ḡemai tu bovevaḡa-foforini, senaḡi tanobara ḡenai tu asiḡina?” ");
INSERT INTO snc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu na evaḡa-veseato, ekirato, “Au eura-viniguni tarimana na au ḡegu vevaḡa-riba bekorana-iaḡiani. Benamo au Tamagu na mo tarima beura-viniani. Benamo tauma ruarua baḡa iaḡoni ḡia ḡenai, bena ḡia ḡesi baḡa tanu-vanaḡi vanaḡini. ");
INSERT INTO snc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Au asi eura-viniguni tarimana tu, au ḡegu guruḡa asi ekorana-iaḡirini. Mai guruḡa ḡoseḡaḡirini tu dia au ḡegu, senaḡi Tamagu ḡena; au tu ḡia na etuḡuguto. ");
INSERT INTO snc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ḡomi ḡesi roḡo atanuni nuḡanai, maiḡeri guruḡa ḡomi akira-varamini. ");
INSERT INTO snc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A ḡomi vaḡa-kavami tarimana tu Iauka Veaḡa. Ḡia tu au aragu ai Tamagu na betuḡu-iaḡomaiani. Ḡia na dagara mabarari bevaḡa-ribamini, ema au na kara akiraḡirito dagarari, ḡemi tuḡamaḡi ai ma bevaḡa-fofori ḡenoḡoirini. ");
INSERT INTO snc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Maino ḡomi ḡesi mai aiaḡuiani. Mai tu au ḡegu maino ḡomi avinimini. Ema mai maino au na ḡomi avinimini tu, dia tanobara tarimari na ḡomi ḡevinimini kavana avinimini. Nuḡami asi beḡene raḡe e asi boḡono tuḡamaḡi-ḡutuma ema asi boḡono gari. ");
INSERT INTO snc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Au baguruḡa boḡo seḡaḡia, au bakira, ‘Au tu araka-ḡerevaḡini, senaḡi ma baḡenoḡoi-iaḡomani ḡomi ḡemi ai.’ Bema au boḡoro ura-vinigu nai tu, Tamagu ḡenai aiaḡoni, be ḡoro iaku, korana au Tamagu tu iaru-korokoro, au iata-raḡegu ai. ");
INSERT INTO snc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mai veiḡa tu roḡosi roḡo bere ḡora nuḡanai akira-varamini. Be mai veiḡa befoforini nai, boḡono vaḡa-moḡonigu. ");
INSERT INTO snc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Au ḡomi ḡesi asi bita guruḡa-guruḡa maukani, korana mai tanobara eḡori-kauani verena, Satani, tu dori eraḡasini. Ḡia tu asi kokorena, be au ḡegu ai kara ta asi beveiani. ");
INSERT INTO snc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Senaḡi mai tanobara tarimari beḡene riba, au na Tamagu aura-viniani. Ema au tu Tamagu na ekiraḡiato ilailanai aveini. Be ḡovariḡisi, mai gabu na siraka-veḡita.” ");
INSERT INTO snc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Au tu vine ḡauna korikori, ma au Tamagu tu vine tavoḡana ḡauvei-iaḡina tarimana. ");
INSERT INTO snc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Vine legari au ḡegu ai kafakau dagarari, asi ḡeḡwani legari tu, ḡia na ebasi-vaḡirini; ma lega mabarari ma ḡwari tu, ḡia na eiarevarini, beḡene ḡwa-vovoka uranai. ");
INSERT INTO snc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ḡomi tu varau boḡo iareva-ḡosi. Mo guruḡa avinimito moḡeri na beḡe iarevami. ");
INSERT INTO snc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Au ḡegu ai boḡono kafakau, be au maki ḡomi ḡemi ai kafakau-taḡo bana tanu. A vine legana ta ḡereḡana moḡo nai tu asi beḡwani, senaḡi vine ḡauna ḡenai bekafakau-taḡoni vau beḡwani. Ḡomi maki moḡesi, bema au ḡesi asi boḡo sebonani nai, ḡwaḡwami ta asi bevetoreni. ");
INSERT INTO snc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Au tu vine, a ḡomi tu lega. Au ḡegu ai bekafakauni, au ḡia ḡenai bakafakauni kavana, tarimana tu ḡwaḡwana asisebo bevetoreni. Bema au boḡo iaḡuiguni nai, dagara ta asi boḡo veiani. ");
INSERT INTO snc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Au ḡegu ai asi ekafakauni tarimana tu, vine ḡauna legana noḡa beḡe ḡabiani, ma beḡe fitoḡaiani, benamo bea kaukauni. Mo ḡau legari kakorori tu ḡeḡabi-vegogorini, benamo karavai ḡefiu-raḡerini, benamo ḡegaburini. ");
INSERT INTO snc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bema ḡomi au ḡegu ai boḡo kafakauni o au ḡesi boḡo sebonani, ma au ḡegu guruḡa ḡomi ḡemi ai betanuni nai tu, kara ḡoura-vinirini dagarari boḡo noḡini tu, ḡemi noḡinoḡi dagarari boḡo ḡoitaḡorini. ");
INSERT INTO snc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bema ḡwaḡwami asisebo asisebo beḡe vetoreni nai tu, tarimarima na au Tamagu ḡevaḡa-raḡeani, ema ḡomi maki au ḡegu mero korikori ai boḡo iaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamagu na au eura-viniguni ilailanai, au na ḡomi maki aura-vinimini. Vanaḡivanaḡi au ḡegu veuravini nuḡanai boḡono tanu. ");
INSERT INTO snc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bema au ḡegu taravatu guruḡari boḡo korana-iaḡirini nai, ḡomi tu au ḡegu veuravini nuḡanai boḡo tanuni, ilailana au Tamagu ḡena taravatu guruḡari akorana-iaḡirini, benamo ḡia ḡena veuravini nuḡanai atanuni kavana. ");
INSERT INTO snc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Au na maiḡeri guruḡa ḡomi bavinimi anina tu, au ḡegu iaku ḡomi nuḡami ai bene tanu, be ḡomi maki nuḡami iaku na beḡene vonuvonu-raḡe. ");
INSERT INTO snc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Au ḡegu taravatu guruḡana tu maiḡa, tauḡemi fakami ai karomi ḡesi boḡono veuravini, au na ḡomi aura-vinimini kavana. ");
INSERT INTO snc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma ḡena veuravini barego lelevaḡina tarimana tu, karona urari ai ḡena maḡuri gwaina asi eḡabiani, etore-tariani. Ma ḡena veuravini barego tarimana korikori tu moḡa, ma boruna ta tu asiḡina maia. ");
INSERT INTO snc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bema au na kara akiramini veiḡari boḡo veirini nai, ḡomi tu au ḡatagu. ");
INSERT INTO snc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Au na ḡomi tu vetuḡunaḡi-iaḡovini tarimami asi ma bakiraḡimini, korana vetuḡunaḡi-iaḡovini tarimana na ḡena vere na kara eveiani, ḡia tu asi ribana. A ḡomi tu ḡata batoni, korana au Tamagu ḡenana kara aseḡaḡirito dagarari mabarari tu, ḡomi varau avaḡa-ribamito. ");
INSERT INTO snc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ḡomi na au asi ḡoḡabi-viriḡiguto, senaḡi au na ḡomi aḡabi-hidimito, ema avaḡa-ruḡamito boḡono iaḡo, ḡwaḡwami boḡono vaḡa-ḡorari, ma moḡeri tu namo moḡo beḡene tanu-vanaḡi vanaḡi. Moḡesina tu karakara ḡoura-vinirini dagarari au aragu ai Tamagu boḡo noḡiani tu, Tamagu na bevinimini. ");
INSERT INTO snc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Au ḡegu taravatu guruḡana ḡomi avinimini tu maiḡa, karomi ḡesi boḡono veuravini.” ");
INSERT INTO snc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Bema tanobara tarimari na beḡe iau-rakava vinimini nai, boḡono riba, au tu ḡeiau-rakava vini-guineguto. ");
INSERT INTO snc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bema ḡomi tanobara ḡena tarimarima roḡo ḡoro tanu tu, tanobara tarimari na beḡere ura-vinimi, korana ḡomi tu ḡia ḡeri tarimarima bene. Senaḡi ḡomi tu dia tanobara ḡena tarimarima. Asiḡina. Ḡomi tu varau aḡabi-viriḡimito, ma tanobara maḡurina nuḡana na aḡabi-vaḡimito. Moḡa lorinai tanobara tarimari na ḡeiau-rakavamini. ");
INSERT INTO snc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Akiramito guruḡana boḡono tuḡamaḡi-taḡoa: ‘Vetuḡunaḡi merona na etuḡu-naḡiani tarimana asi bevanaḡiani.’ Bema au ḡevaḡa-midigu midiguguto, ḡomi maki beḡe vaḡa-midigu midigumini. Bema au ḡegu guruḡa ḡekorana-iaḡirito, ḡomi ḡemi guruḡa maki beḡe korana-iaḡirini. ");
INSERT INTO snc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ḡia na maiḡeri veiḡa asi namori mabarari ḡomi ḡemi ai beḡe veirini tauna korikori tu, ḡomi na au aragu ḡokorana-iaḡiani nai; korana au etuḡuguto Barauna ḡia tu asi ribari. ");
INSERT INTO snc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bere au asi bara iaḡoma, ma asi bara guruḡa-viniri, ḡia tu asi ḡeri rakava. Senaḡi ḡia maitoma ḡeri rakava na tu asi ḡeri raga-maḡuri dabarana. ");
INSERT INTO snc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Au eiau-rakavaguni tarimana na au Tamagu maki eiau-rakavaiani. ");
INSERT INTO snc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bere au na nuḡa-farevaḡi veiḡari, tarima tari na roḡosi roḡo beḡene veiri dagarari, ḡia vefakari ai asi bara veiri, ḡia tu asi ḡeri vei-rakava. Senaḡi maitoma ḡia na moḡeri nuḡa-farevaḡi veiḡari tu beḡe ḡitari, ma nuḡanai ḡia na au ma Tamagu ḡesi tauma ruarua tu ḡeiau-rakavamani. ");
INSERT INTO snc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Senaḡi maiḡeri veiḡa ḡeḡorani korana tu, taravatu nuḡanai ḡetoreato guruḡana bene moḡoni ḡana. Mo guruḡa tu iniḡesi ekirani: ‘Au tu ḡeiau-rakava-kavaguto moḡo, asi korana tai.’ ");
INSERT INTO snc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Vevaḡa-kava Iaukana tu beiaḡomani. Ḡia tu guruḡa moḡoniri kiraḡi-kiraḡiri Iaukana, Tamagu ḡenana beiaḡomani. Au na ḡomi ḡemi ai batuḡuani, Tamagu sevinai batanuni nai tu. Ḡia na au bema kiraḡi-foforiguni. ");
INSERT INTO snc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ḡomi na maki au roḡo boḡono kiraḡi-foforigu, korana ḡomi tu au ḡesi tatanuni tovotovona na veḡata bene.” ");
INSERT INTO snc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Au na maiḡeri guruḡa akira-varamini, korana asi aurani ḡemi veḡabidadama na boḡono raka-veḡita. ");
INSERT INTO snc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iuda tarimari ḡeri rubu na beḡe tore-veḡitamini. Aba, ḡarona mani eiaḡomani, tau ta na bevaḡi-masemini nai tu, ḡia mataboru bekirani, ḡia tu Barau vetuḡunaḡina eiaḡo-viniani. ");
INSERT INTO snc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Maiḡeri veiḡa ḡomi ḡemi ai beḡe veirini korana tu ḡia na au Tamagu asi ḡeribaiato, ema au maki asi ḡeribaguto. ");
INSERT INTO snc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Senaḡi au na maiḡeri guruḡa tu nakiravara-guinemi. Be ḡoirai vau tarimarima na veiḡari ḡemi ai beḡea veirini nai, maiḡeri guruḡa bakira-varami boḡono tuḡamaḡiri. Tovotovonai au tu roḡo ḡomi ḡesi tatanuto-ḡoi naima, maiḡeri guruḡa ḡemi asi akiraḡirito. ");
INSERT INTO snc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Senaḡi toma tu etuḡu-mariḡoguto Barauna ḡenai ma aḡenoḡoi-iaḡoni, ma ta na tu asi odanaḡiguni, ‘Ḡoi tu aiḡana oiaḡoni?’ asi otoni. ");
INSERT INTO snc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ḡomi tu maiḡeri guruḡa bakira-varami nai, nuḡami ḡevekwaraḡini e ḡetaḡitaḡini. ");
INSERT INTO snc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Senaḡi moḡoni akiramini, mai tu ḡomi ḡemi namo uranai ḡomi vekaravami na araka-ḡerevaḡini, arakani. Korana tu bema au asi barakani nai, vevaḡa-kava Iaukana ḡemi ai asi beiaḡomani. Senaḡi bema au baiaḡoni nai tu, ḡemi ai batuḡu-iaḡomaiani. ");
INSERT INTO snc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma ḡia beiaḡomani nai, mai tanobara tarimari ḡeri vei-rakava ma Barau ḡena vei-iobukaiobuka ema Barau na tanobara tarimari bekota-vinirini aniri bevaḡa-fofori ginikaurini. ");
INSERT INTO snc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ḡeri vei-rakava tauna korikori tu, au asi ḡevaḡa-moḡoniguni. ");
INSERT INTO snc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Barau ḡena vei-iobukaiobuka tauna korikori tu maiḡa, au tu Tamagu ḡenai aiaḡoni, be asi ma boḡo ḡita-ḡenoḡoiguni. ");
INSERT INTO snc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ema Barau na tanobara tarimari bekota-vinirini anina tu maiḡea, mai tanobara verena tu varau ekota-viniato. ");
INSERT INTO snc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dagara vovoka roḡo aurani nakira-varami, senaḡi mabarari maitoma tu asi ilaila boḡo tuḡamaḡi-fakarini e asi boḡo ḡabi-raḡerini. ");
INSERT INTO snc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Senaḡi guruḡa moḡoni Iaukana beiaḡomani, ḡia na vau ḡomi beḡori-kaumini, benamo guruḡa moḡoniri boḡo ribarini. Korana ḡia tu dia tauḡena ḡena tuḡamaḡi guruḡari bekiraḡirini. Asiḡina. Ḡia tu au ḡeguna beseḡaḡini guruḡari moḡo bekiraḡirini. Ema gabivau beḡe ḡorani dagarari bekiravara-guinemini. ");
INSERT INTO snc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ḡia na au bevaḡa-raḡeguni, korana au ḡeguna beḡabirini guruḡari ḡomi bekira-varamini. ");
INSERT INTO snc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Au Tamagu ḡena dagara mabarari tu au ḡegu. Moḡesi naima au bakira, ‘Ḡia na au ḡeguna beḡabirini guruḡari ḡomi bekira-varamini.’” ");
INSERT INTO snc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ḡaro asi manaḡa nuḡanai, ḡomi na au asi ma boḡo ḡitaguni, ma ḡaro asi manaḡa murinai tu, ma boḡo ḡitaguni. Korana au tu Tamagu ḡenai aiaḡoni.” ");
INSERT INTO snc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Benamo ḡena mero kotari tauḡeri vefakari ai moḡo ḡeguruḡa-guruḡato, ḡekirato, “Mai ḡia na tu kara ekiraḡiani, ekirani, ‘Ḡaro asi manaḡa nuḡanai au asi ma boḡo ḡitaguni, ma ḡaro asi manaḡa murinai tu ma boḡo ḡitaguni,’ e ma ekirani, ‘Korana au tu Tamagu ḡenai aiaḡoni?’” ");
INSERT INTO snc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Moḡesina naima ḡekirato, “Mai ḡia na tu kara ekiraḡiani, ekirani, ‘Ḡaro asi manaḡa’ etoni? Ḡita asi taribani ḡia na tu kara ekiraḡiani!” ");
INSERT INTO snc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu eribato, ḡena mero ḡeri ura tu ḡedanaḡia ḡetato-ḡoi, naima ḡia na evaḡa-guruḡarito, ekirato, “Ḡomi tu tauḡemi ḡereḡami au na kara bakiraḡia vedare-mutukana ḡoveini ei? Au bakira, ‘Ḡaro asi manaḡa nuḡanai asi ma boḡo ḡitaguni, ma ḡaro asi manaḡa murinai tu ma boḡo ḡitaguni,’ basi anina ḡovetauani? ");
INSERT INTO snc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Moḡoni akiramini, ḡomi tu boḡo taḡini e boḡo taḡi-vanoro vanoroni, senaḡi tanobara tarimari tu beḡe iakuni, beḡe verereni. Ḡomi tu boḡo nuḡa-midigu midiguni, senaḡi ḡemi nuḡa-midigumidigu tu iaku verere ai beḡe iaḡoni. ");
INSERT INTO snc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vavine ta mero nevaḡa-maḡuria ḡana tu, emidigumidiguni, korana ḡena ḡabi aoana eraḡasini. Senaḡi mero emaḡurini nai, ḡenai mo midigumidigu tu etuḡa-rekwaiani, korana mero ta tanobarai varau bevaḡa-maḡuria iakunai. ");
INSERT INTO snc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ḡomi maki moḡesina: Toma tu ḡonuḡa-midigu midiguni, senaḡi au na ma baḡita-ḡenoḡoimini, be ma boḡo iakuni. Ma tarima ta na ḡomi ḡemi mo iaku tu asi ilaila ḡemina ma beḡabi-veḡitaiani. ");
INSERT INTO snc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma mo ḡaro ai ḡomi na au dagara ta asi ma boḡo noḡiguni. Moḡoni akiramini, au aragu ai karakara boḡo noḡirini dagarari mabarari, au Tamagu na bevinimini. ");
INSERT INTO snc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Beiaḡoma mo initoma, ḡomi na au aragu ai dagara ta roḡosi roḡo boḡoro noḡia. Au aragu ai boḡono noḡi-raḡe, be boḡono doḡari; benamo nuḡami iaku na beḡene vonuvonu-raḡe.” ");
INSERT INTO snc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Maiḡeri guruḡa au na ḡomi ḡemi tu barabore ai akiraḡirini, senaḡi ḡaro ḡoirai tu barabore ai asi ma bavaḡa-guruḡamini. Ḡoirai vau au Tamagu varina tu ḡemi bakiraḡi-fofori ginikauani. ");
INSERT INTO snc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mo ḡaro beraḡasini nai, ḡomi tu au aragu ai boḡo noḡinoḡini. A au tu asi akirani, au na ḡomi urami ai Tamagu banoḡiani; ");
INSERT INTO snc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","korana Tamagu tauḡena na ḡomi eura-vinimini. Ḡomi eura-vinimini, korana ḡomi na au ḡoura-viniguni, ema ḡovaḡa-moḡoniguni, au tu Barau ḡenana aiaḡomato. ");
INSERT INTO snc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Au tu Tamagu sevina na mai tanobara ḡana amariḡoto. Ma toma tu mai tanobara aiaḡuiani, Tamagu ḡenai ma aḡenoḡoi-iaḡoni.” ");
INSERT INTO snc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ḡena mero na ḡevaḡa-guruḡaiato, ḡekirato, “Oḡitaiani, toma ḡoi tu oguruḡa-fofori ginikauni, asi oguruḡa-baraboreni. ");
INSERT INTO snc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Toma ḡai ḡama riba-korikorini, ḡoi tu dagara mabarari ma ribamu. Tarima ta na nedanaḡimu betoni vedanaḡina maki, ḡoi na tu boriba-guineani. Moḡa lorinai ḡavaḡa-moḡonimuni, ḡoi tu moḡoni Barau ḡenana oiaḡomato.” ");
INSERT INTO snc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu na evaḡa-veserito, ekirato, “Mai vau ḡovaḡa-moḡoniguni, ei? ");
INSERT INTO snc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Moḡoni, ḡarona mani eiaḡomani, varau beraḡasi, ḡomi tu boḡo raga-rovorovoni, tata ḡemi ura ragana boveini, benamo au tu ḡereḡagu boḡo iaḡui-momoraḡiguni. Senaḡi au tu dia ḡereḡagu, korana Tamagu tu au sevigu ai. ");
INSERT INTO snc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Au aurani, au ḡegu ai boḡono kafakau, be au ḡegu ai maino boḡono ḡabi uranai, au na maiḡeri guruḡa ḡomi bakira-varami. Mai tanobarai ḡotanuni nai, midigumidigu boḡo ḡoitaḡoani. Senaḡi boḡono kokore! Au na tanobara ḡena seḡuka avaḡa-ketoato.” ");
INSERT INTO snc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu moḡesi eguruḡa-ḡosito murinai, egaga-raḡeto, guba eḡitaiato, benamo ekirato, “Tamagu, horana tu maiḡa. Natumu marevana baregona novaḡa-foforia, be Natumu na ḡoi marevamu baregona maki bene vaḡa-foforia. ");
INSERT INTO snc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Korana ḡoi na maoro ḡia oviniato, tarimarima mabarari ḡia ḡena veḡitaḡau gaburenai beḡene tanu. Be ḡoi na ḡia oviniato tarimari mabarari maḡuri vanaḡivanaḡi bene viniri. ");
INSERT INTO snc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Maḡuri vanaḡivanaḡi tu maiḡa: Maḡuri vanaḡivanaḡi beḡe ḡabiani tarimari mabarari beḡene riba, Barau moḡonimu tu ḡoi sebomu kwariḡutu moḡo, ema Iesu Keriso beḡene ribaia. Iesu Keriso tu ḡoi na otuḡuato tanobara ḡana. ");
INSERT INTO snc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Au na ḡoi tanobarai bavaḡa-raḡemu. Ḡoi na oviniguto bana veia otato ḡauveina varau bavaḡa-koria. ");
INSERT INTO snc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tama, tanobara roḡosi bere vesina ema au maki roḡo ḡoi ḡesi atanuto-ḡoi nuḡanai, au ḡegu ai tu mareva baregona etanuto-ḡoi. Toma aurani, mo mareva ḡoi tauḡemu ḡoiramu ai ḡegu ai novaḡa-foforia.” ");
INSERT INTO snc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tanobara maḡurina nuḡana na oḡabi-vaḡirito, benamo oviniguto tarimari ḡeri ai ḡoi tu avaḡa-foforimuto. Moḡeri tu ḡoi ḡemu tarimarima, ḡoi na au oviniguto. Ma ḡia na ḡoi ḡemu guruḡa ḡekorana-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Toma ḡia beḡe riba, ḡoi na oviniguto dagarari mabarari tu ḡoi ḡemuna moḡo ḡeiaḡomato. ");
INSERT INTO snc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Korana ḡoi na oviniguto guruḡari mabarari akira-vararito. Ḡia na mo guruḡa mabarari ḡeḡabi-raḡerito, ma ḡeriba-maoroto, au tu ḡoi sevimu na aiaḡomato. Ema ḡevaḡa-moḡoniani, au ḡoi na otuḡu-iaḡomaguto. ");
INSERT INTO snc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Au tu ḡia ḡeri aḡuriḡurini. Au tu dia mai tanobara maḡurinai ḡetanuni tarimari ḡeri aḡauḡauni. Senaḡi au oviniguto tarimari ḡeri aḡauḡauni, korana ḡia tu ḡoi ḡemu tarimarima. ");
INSERT INTO snc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Au ḡegu tarimarima mabarari tu ḡoi ḡemu tarimarima. Ema ḡoi ḡemu tarimarima mabarari tu au ḡegu tarimarima. Ema ḡia ḡerina au aragu evaraḡeni, korana au ḡegu mareva baregona ḡevaḡa-foforiani. ");
INSERT INTO snc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Au tu ḡoi ḡemu ai aiaḡosini, mai tanobarai asi batanu-rovaḡini. Senaḡi ḡia tu tanobarai roḡo beḡe tanuni. Tamagu Veaḡamu, ḡoi na au oviniguto tarimari ḡoi aramu seḡukana na bono ḡitaḡauri. Be ḡia mabarari beḡene sebona, ḡita taura ruarua kavana. ");
INSERT INTO snc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Au tanobarai roḡo ḡia ḡesi atanuto-ḡoi nuḡanai, ḡoi aramu seḡukana na ḡia anariḡaurito-ḡoi. Ḡoi na au oviniguto tarimari tu aḡitaḡau-ginikaurito, be ta asi erekwarekwato; bene rekwarekwa tauna moḡo, moḡoni erekwarekwato, Buka Veaḡai ḡetoreato guruḡana vaḡa-moḡonina ḡana. ");
INSERT INTO snc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Senaḡi toma au tu ḡoi ḡemu ai aiaḡosini. Au tu roḡo tanobarai maiḡegu nuḡanai, maiḡeri guruḡa bakiraḡiri, au ḡegu iaku e verere na ḡia nuḡari bene vaḡa-vonuvonu raḡeri ḡana. ");
INSERT INTO snc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ḡoi ḡemu guruḡa au na ḡia varau avinirito. Ma tanobara maḡurinai ḡetanuni tarimari na ḡeiau-rakavarini, korana ḡia toma tu dia mai tanobara tarimari, au kavana, au tu dia mai tanobara tarimagu. ");
INSERT INTO snc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Au tu dia ḡia mai tanobara na bono ḡabi-vaḡiri ḡuriḡurina aveini. Senaḡi anoḡimuni, bono nariḡauri, be Tarima Rakavana, Satani, na asi bene ḡabiri atoni. ");
INSERT INTO snc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ḡia tu dia mai tanobara tarimari, au kavana, au tu dia mai tanobara tarimagu. ");
INSERT INTO snc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ḡoi ḡemu guruḡa moḡonina na novaḡa-veaḡari; ḡoi ḡemu guruḡa tu moḡoni. ");
INSERT INTO snc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ḡoi na tanobara maḡurinai ḡetanuni tarimari fakari ai au otuḡu-toḡaguto ilailanai, au na ḡia maki tanobara maḡurinai roḡo ḡetanuni tarimari vekaravari ai batuḡu-toḡari. ");
INSERT INTO snc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ḡia urari ai au tauḡegu avevaḡa-veaḡani, be ḡia maki beḡene veaḡa-korikori.” ");
INSERT INTO snc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Au tu dia ḡia ḡena mero ḡereḡari ḡeri moḡo aḡauḡauni. Asiḡi. Au tu ḡia na vari beḡea fiuani nai, au beḡe vaḡa-moḡoniguni tarimari mabarari maki ḡeri aḡuriḡurini. ");
INSERT INTO snc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Be ḡia mabarari sebonai beḡene iaḡo, Tama, ḡoi au nuḡagu ai otanuni ema au ḡoi nuḡamu ai atanuni ilailana. Moḡesi kavana au aurani, ḡia maki beḡene sebona moḡo, ma ḡita nuḡarai beḡene tanu, be tanobara maḡurinai roḡo ḡetanuni tarimari beḡene riba, au tu ḡoi na otuḡu-mariḡoguto. ");
INSERT INTO snc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ḡoi na au mareva baregona oviniguto dagarana ḡia avinirito, ḡia sebonai beḡene iaḡo uranai, be ḡita taura ruarua sebona kavana, ḡia maki beḡene sebona. ");
INSERT INTO snc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Au ḡia nuḡari ai, ma ḡoi au nuḡagu ai, be ḡia maki beḡene sebona-kwariḡuto korikori. Benamo monana tanobara maḡurinai roḡo ḡetanuni tarimari beḡene riba, au tu ḡoi na otuḡu-iaḡomaguto, ema beḡene riba maki, ḡoi na ḡia oura-vinirini au oura-viniguni kavana. ");
INSERT INTO snc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tama, au ḡegu ura baregona tu, au ainai batanuni, au oviniguto tarimari maki au ḡesi, be monai baḡana tanu, be au mareva baregona oviniguto marevana beḡene ḡitaia. Mo mareva oviniguto, korana au ḡoi na tu tanobara roḡosi roḡo boro veia nuḡanai veḡata oura-viniguto. ");
INSERT INTO snc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamagu o, ḡoi tu vei-iobukaiobuka Baraumu, tanobara maḡurinai ḡetanuni tarimari na ḡoi asi ḡeribamuto. A au na tu ḡoi aribamuto, ema au ḡegu mero maiḡeri tu beḡe riba, au tu ḡoi na otuḡu-mariḡoguto. ");
INSERT INTO snc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ḡoi aramu ḡia akira-vararito, e roḡo bakiraḡi-foforiani. Korana monana au oura-viniguni veuravinina ḡia nuḡari ai betanuni, ema au maki ḡia nuḡari ai batanuni.” ");
INSERT INTO snc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu na mo ḡauḡau ekiraḡi-ḡosiato murinai, ḡena mero ḡesi ḡerakato. Ḡeiaḡoto, Kidron ḡarukana na ḡeraka-vanaḡito, reke ta ḡana. Monai tu vamoka ta, ma ḡena mero ḡesi mo vamoka nuḡana na ḡeraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iudas, Iesu erevaiato tarimana, maki mo gabu tu ma ribana, korana Iesu ma ḡena mero ḡesi monai ḡaro vovoka ḡetanu-vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Moḡesina naima Iudas na Roma vetari tarimari e Rubu Veaḡa ḡitaḡauna tarimari tari eḡoririto. Mo Rubu Veaḡa ḡitaḡauna tarimari tu Rubu Veaḡa vereri baregori e Farisea tarimari na ḡetuḡurito. Benamo mo vamoka ḡana ḡeiaḡoto, ma tosiri, ma lamefari, ema ma ḡeri vetari farefareri. ");
INSERT INTO snc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu tu ribana guine, ḡia ḡenai kara beḡe ḡorani dagarari mabarari, naima eiaḡoto seviri ḡana, benamo edanaḡirito, ekirato, “Ḡomi na tu deikara ḡovetauani?” ");
INSERT INTO snc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ḡia ḡevaḡa-veseto, ḡekirato, “Iesu, Nasareta tarimana.” Iesu na ekirarito, ekirato, “Tarimana tu au.” Ma Iudas, Iesu erevaiato tarimana, maki ḡia ḡesi monai ruḡataḡo. ");
INSERT INTO snc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu na ekirarito, ekirato, “Tarimana tu au,” etato nai, ḡia mabarari ḡeruḡa-ḡenoḡoito, benamo tano ai ḡeketo-tarito. ");
INSERT INTO snc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu na ma edanaḡi-ḡenoḡoirito, ekirato, “Ḡomi na tu deikara ḡovetauani?” Benamo ḡia ḡekirato, “Iesu, Nasareta Tarimana.” ");
INSERT INTO snc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu evaḡa-veseto, ekirato, “Au na bakirami, tarimana tu au. Bema ḡomi tu au moḡo ḡovetauguni nai, maiḡeri tarima ḡotuḡuri, ḡeraka.” ");
INSERT INTO snc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Moḡesi ekirato, korana ḡia ḡena guruḡa tovotovonai ekiraḡiato guruḡana bene moḡoni ḡana, ekirato, “Au oviniguto tarimari tu sebona ta maki asi avei-rekwa-rekwaiato.” ");
INSERT INTO snc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma nuḡanai Simona Petero ḡimanai tu vetari baḡana ta. Mo vetari baḡana einu-vaḡiato, edaveato, benamo Rubu Veaḡa verena baregona ḡena vetuḡunaḡi-iaḡovini tarimana seḡana aroribana ebasi-vaḡiato. Mo vetuḡunaḡi-iaḡovini tarimana arana tu Malko. ");
INSERT INTO snc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Benamo Iesu na Petero ekiraiato, ekirato, “Ḡoi na mani vetari baḡana faosinai noḡura-toḡaia! Au Tamagu na bevinigu midigumidigu bedina tu asi bana niua, ei?” ");
INSERT INTO snc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Benamo vetari tarimari ma ḡorikauri tarimana ema Iuda tarimari ḡeri Rubu Veaḡa ḡitaḡauna tarimari na Iesu ḡeḡabiato, benamo ḡebarubaruato, ");
INSERT INTO snc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","benamo Anas ḡenai ḡeḡori-iaḡo guineato, korana Anas tu Kaiafas ḡena taḡama. Kaiafas na Anas natuna vavinena eḡaraḡoato. Kaiafas tu Rubu Veaḡa verena baregona mo laḡani ai. ");
INSERT INTO snc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas na Iuda tarimari esisiba-vinirito, ekirato, “Namona tu tarima sebona ta moḡo tarimarima mabarari urari ai bene mase.” ");
INSERT INTO snc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petero e Iesu ḡena mero ta na tu Iesu ḡeraka-ḡiuato. Rubu Veaḡa verena baregona tu ma ribana, mo Iesu ḡena mero moḡa. Moḡesi nai ḡia maki Iesu ḡesi evaḡa-rakatoḡa sebonaiato, Rubu Veaḡa verena baregona ḡena numa maḡuna nuḡanai Kota gabunai. ");
INSERT INTO snc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Senaḡi Petero tu ḡatama-boka murikanai moḡo eruḡato. Ma mo Iesu ḡena mero, Rubu Veaḡa verena baregona na eribaiato merona, ma eḡenoḡoito, benamo ḡatama-boka eḡita-ḡauato ḡuiatona ea vaḡa-guruḡaiato, ma Petero eḡori-toḡaiato. ");
INSERT INTO snc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Benamo ḡatama-boka eḡita-ḡauato ḡuiatona na Petero ekiraiato, ekirato, “Ḡoi maki mai tarima ḡena mero ta, ene?” Petero evaḡa-veseto, ekirato, “Asiḡina, au tu asiḡi.” ");
INSERT INTO snc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mo gabu faraka na eḡabiato, be vetuḡunaḡi-iaḡovini tarimari ema Rubu Veaḡa ḡitaḡauna tarimari na tu karava ta ḡetutuato. Benamo mo karava ḡeruḡa-ḡeḡeraḡiato, ḡevetunuto-ḡoi. Petero maki ḡia seviri ai eruḡato ma evetunuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mo horai tu Rubu Veaḡa verena baregona na Iesu edanaḡiato, Iesu ḡena mero e ḡena vevaḡa-riba evedanaḡi-iaḡirito. ");
INSERT INTO snc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu na evaḡa-veseato, ekirato, “Au tu tarimarima ḡutuma-bara ḡoirari ai aguruḡa-foforito. Au tu vanaḡivanaḡi Iuda tarimari ḡeri rubu ai ema Rubu Veaḡa nuḡari ai avevaḡa-ribato-ḡoi, ma Iuda tarimari ḡema-raka-vegogoni gaburi ai, au asi aguruḡa-vekuretoḡato. ");
INSERT INTO snc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kara dainai au odanaḡiguni? Mo au aguruḡato ḡeseḡaḡiguto tarimari noa danaḡiri, ḡia ma ribari au na kara akiravara-vinirito.” ");
INSERT INTO snc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu moḡesi eguruḡato nai, Rubu Veaḡa ḡitaḡauna tarimana ta ḡia sevinai eruḡa-taḡoto-ḡoi, monana Iesu ḡoirana eforo-bubuḡauato. Benamo Iesu ekiraiato, ekirato, “Ḡoi mai Rubu Veaḡa verena baregona tu maniḡesi ovaḡa-guruḡaiani?” ");
INSERT INTO snc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu na evaḡa-veseato, ekirato, “Bema au na guruḡa rakavana ta bakiraḡia nai, nokiraḡia, kamara guruḡa rakavana! Senaḡi bema au tu baguruḡa-korikori, kara dainai boforogu.” ");
INSERT INTO snc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Benamo Anas na Iesu roḡo varo na barubaru Rubu Veaḡa verena baregona Kaiafas ḡenai etuḡu-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Petero tu roḡo ruḡataḡo karavai evetunuto-ḡoi. Benamo karava sevinai ḡeruḡa-vegogoto tarimari na ḡedanaḡiato, ḡekirato, “Ḡoi maki ḡia ḡena mero ta, ene?” Petero evekira-ḡuniḡauto, ekirato, “Asiḡina, au tu asiḡi.” ");
INSERT INTO snc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rubu Veaḡa verena baregona ḡena vetuḡunaḡi-iaḡovini tarimana ta tu mo Petero na seḡana ebasi-vaḡiato tarimana garagarana ta, ḡia ekirato, “Au atuḡamaḡini tu, ḡoi maki ḡia ḡesi mo vamoka nuḡanai aḡitamuto banaḡu, ene?” ");
INSERT INTO snc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petero ma evekira-ḡuniḡau ḡenoḡoito, ma nuḡanai asikauna tu kokoroku egoḡito. ");
INSERT INTO snc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Benamo Iuda tarimari na Iesu Kaiafas sevina na ḡeḡori-iaḡoato Roma ḡeri gavana ḡena numa barana ḡana. Mo tu varau ekini-mama mamato-ḡoi. Ma Iuda tarimari tu asi ḡeurato, Roma ḡeri gavana ḡena numai beḡene raka-toḡa, korana ḡekirato, veiareva, asi rakavari, beḡene tanu. Ḡia ḡeri ura tu Pasova o mase aneruna na Isaraela tarimari evanaḡirito moḡo asi evaḡirito verekona beḡene ḡania veḡata. ");
INSERT INTO snc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Benamo Pilato ḡeri ai eraka-rosito, benamo ekirato, “Mai tarima boḡo ḡabi-iaḡomaia ḡena kerere korana tu kara?” ");
INSERT INTO snc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ḡia na ḡevaḡa-veseato, ḡekirato, “Bema ḡia veiḡa rakavari asi bere vei nai tu, ḡoi ḡemu ai asi baḡara ḡabi-iaḡomaia.” ");
INSERT INTO snc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Benamo Pilato na ekirarito, ekirato, “Ḡoḡabia, ma ḡoḡori-iaḡoa, benamo ḡemi taravatu ekirani ilailanai ḡoa vaḡa-kotaia.” Moḡesi naima Iuda tarimari na Pilato ḡekiraiato, ḡekirato, “Ḡai ḡema taravatu na tu maoro asi evinimani, tarima ta baḡana vaḡi-masea.” ");
INSERT INTO snc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Maiḡa eḡorato anina tu, Iesu na ḡia aiḡesina bemaseni ekiraḡiato guruḡana bene moḡoni ḡana. ");
INSERT INTO snc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Benamo Pilato numa barana ḡana ma erakatoḡa-ḡenoḡoito, bena Iesu ekeaiato, ma edanaḡiato, “Ḡoi tu Iuda tarimari ḡeri vere ba?” ");
INSERT INTO snc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu na evaḡa-veseato, ekirato, “Ḡoi maniḡesi au okiraḡini tu tauḡemu nuḡamu siga moḡo oguruḡani ba tarima tari na beḡe kira-varamu guruḡana.” ");
INSERT INTO snc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato evaḡa-veseto, ekirato, “Be, au tu Iuda tarimagu, ei? Ḡoi tu ḡemu tanobara tarimari na ema Rubu Veaḡa vereri na beḡe ḡabi-iaḡomamu, au beḡema vinigu. Ḡoi tu kara kererena oveiato?” ");
INSERT INTO snc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu na evaḡa-veseato, ekirato, “Au ḡegu Basileia tu dia mai tanobara dagarana. Bere au ḡegu Basileia mai tanobara nuḡanai bere vetore e bere ruḡa nai tu, au ḡegu vetuḡunaḡi-iaḡovini tarimari ḡere variḡisi, Iuda tarimari ḡesi ḡere vevaḡi, ma tarima ta maki asi bere ilaila, Iuda tarimari ḡimari ai bere toregu. Senaḡi au ḡegu Basileia tu dia mai tanobara nuḡanai eruḡani.” ");
INSERT INTO snc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato na moḡesina naima Iesu edanaḡiato, ekirato, “Be ḡoi tu vere ba?” Iesu evaḡa-veseto, ekirato, “Ḡoi okirani au vere otoni tu moḡoni oguruḡani. Au tanobarai ama maḡurito tauna korikori, guruḡa moḡonina bana vaḡa-foforia ḡana. Guruḡa moḡoninai ḡetanuni tarimari mabarari na au garogu tu ḡeseḡaḡiani.” ");
INSERT INTO snc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ekirato, “Guruḡa moḡonina tu kara?” Moḡesi eguruḡato murinai, ma eraka-rosito Iuda tarimari ḡeri ai, benamo ekirarito, ekirato, “Au na mai tarima ḡenai rakava ta tu asi badoḡaria. ");
INSERT INTO snc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Senaḡi ḡomi ḡemi veiḡa ta tu iniḡesi, Pasova verekona ḡaronai, dibura tarimana ta bana tuḡu-vaḡia. Be ḡomi ḡourani tu, ḡemi Iuda tarimari ḡeri vere natuḡu-vaḡia, ba?” ");
INSERT INTO snc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Benamo ḡia mabarari ḡekoḡoto, ḡekirato, “Asiḡina! Ḡia tu asiḡi! Senaḡi Barabas.” A Barabas tu elemato-ḡoi e evevaḡito-ḡoi naima ḡediburaiato. ");
INSERT INTO snc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Moḡesi naima Pilato na Iesu eḡabiato, vetari tarimari o soldia evinirito, benamo ḡekwariato. ");
INSERT INTO snc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ema soldia na varovaro ma giniri dagarana ḡebito-ḡeḡeraḡiato, korona noḡa ḡeveiato, benamo Iesu debanai ḡetore-kauato. Ema dabuḡa maukana kakakakana na ḡevaḡa-dabuḡaiato. ");
INSERT INTO snc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Benamo ḡoirana ḡana ḡeraka-kavito, benamo ḡekiraiato, ḡekirato, “Iuda tarimari ḡeri Vere, ḡaro namona!” Benamo ḡoirana ma ḡeforoato. ");
INSERT INTO snc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ma eraka-rosito Iuda tarimari ḡeri ai, benamo ekirarito, ekirato, “Ḡoḡitaia, au na ḡia ḡomi ḡoirami ai ama ḡori-rosiani anina tu nama vaḡa-ribami, au na ḡia ḡenai rakava ta tu asi badoḡaria.” ");
INSERT INTO snc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Benamo Iesu ema raka-rosito, debana tu ma koronana, ḡau ma giniginina ḡevatoato dagarana, ema dabuḡa kakakakana maki roḡo etogi-taḡoato-ḡoi. Benamo Pilato na Iuda tarimari ekirarito, ekirato, “Ḡoḡitaia, tarimana tu maiḡa.” ");
INSERT INTO snc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Moḡesi Rubu Veaḡa vereri baregori ma ḡeri vetuḡunaḡi-iaḡovini tauri na ḡeḡitaiato nai, ḡefararato, ḡekirato, “Ḡovaḡa-satauroa! Ḡovaḡa-satauroa!” Benamo Pilato na ekirarito, ekirato, “Ḡomi tauḡemi na ḡoḡabi-iaḡoa, ma ḡoa vaḡa-satauroa, korana au na ḡia ḡenai kerere ta asi badoḡaria.” ");
INSERT INTO snc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma Iuda tarimari na ḡevaḡa-veseato, ḡekirato, “Ḡai tu ma ḡema taravatu, ma ḡai ḡema taravatu ekirani, ḡia tu bene mase veḡata, korana ḡia tu tauḡena moḡo Barau Natunai bevevaḡa-iaḡo.” ");
INSERT INTO snc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato na mo guruḡa eseḡaḡiato nai, egari-rakava rakavato. ");
INSERT INTO snc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Benamo numa baregonai ma eraka-toḡato, benamo Iesu ekiraiato, ekirato, “Ḡoi tu ainana oiaḡomato, ei?” Senaḡi Iesu na asi evaḡa-veseato. ");
INSERT INTO snc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Benamo Pilato na ekiraiato, ekirato, “Ḡoi tu asi ourani au vaḡa-vesegu ei? Ḡoi asi ribamu au tu ma ḡegu seḡuka ḡoi bavaḡa-satauromuni, e ma ḡegu seḡuka ḡoi batuḡu-vaḡimuni?” ");
INSERT INTO snc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu evaḡa-veseto ekirato, “Bere Barau na guba na ḡoi seḡuka asi bere vinimu nai tu, toma au ḡoi ḡemu seḡuka gaburenai asi bara ritoḡo. Moḡa lorinai, au eḡabiguto ma ḡoi ḡimamu ai etoreguto tarimana, ḡena rakava tu barego lelevaḡi”. ");
INSERT INTO snc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato na mo guruḡa eseḡaḡiato, benamo dabara evetauto-ḡoi, ḡena ura Iesu bene tuḡu-vaḡia. Senaḡi Iuda tarimari roḡo ḡekoḡoto-ḡoi, ḡekirato-ḡoi, “Bema ḡoi na mai tarima botuḡu-vaḡiani nai, ḡoi tu dia Kaisara ḡatana. Kamara tarima tauḡena evekiraḡini vere etoni, ḡia na tu Kaisara, Roma ḡeri vere, ekira-fitoḡaiani.” ");
INSERT INTO snc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato na mo guruḡa eseḡaḡiato, benamo Iesu ema ḡori-rosiato, benamo eiaḡoto, Kota eseḡaḡini tarimana ḡena sea ai ea tanukauto. Mo gabu tu “Fore Touraḡena” ḡetato-ḡoi. Ma Heberu garonai tu “Gabata.” ");
INSERT INTO snc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mo ḡaro tu Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona ḡana rovinatore ḡarona, ma horaḡauna 12 koloko tu varau eḡabiato. Benamo Pilato na Iuda tarimari ekirarito, ekirato, “Ḡoboḡe, ḡemi vere iomaiḡa!” ");
INSERT INTO snc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Senaḡi ḡia tu ḡefararato, ḡekirato, “Ḡoḡabi-veḡitaia! Ḡoḡabi-veḡitaia! Ḡoa vaḡa-satauroa!” Pilato na ma edanaḡirito, ekirato, “Ḡomi ḡemi vere tu navaḡa-satauroa, ei?” Rubu Veaḡa vereri baregori ḡevaḡa-veseto, ḡekirato, “Kaisara ḡereḡana moḡo ḡai ḡema vere, ma vere boruna ta tu asiḡina.” ");
INSERT INTO snc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Benamo Pilato na Iesu ḡia ḡimari ai etore-kauato beḡene vaḡa-satauroa ḡana. Benamo vetari tarimari o soldia na Iesu ḡeḡabiato, ḡeḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma Iesu na ḡena satauro efaḡa-vaisiato, eraka-rosito, eiaḡoto gabu arana “Deba Ḡavana Gabuna” ḡana. Heberu garonai mo gabu arana tu “Golgota”. ");
INSERT INTO snc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mo gabu ai ḡia na Iesu ḡevaḡa-satauroato tarima ruarua ḡesi; ta tavi tai, ta tavi tai, ma Iesu tu nuḡanai. ");
INSERT INTO snc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma Pilato na guruḡa tari ḡau lefalefa tai etorerito, benamo satauro tuḡunai ḡeikoko-kafakauato. Etorerito guruḡari tu maiḡeri, “IESU, NASARETA TAUNA, IUDA TARIMARI ḠERI VERE.” ");
INSERT INTO snc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mo guruḡa tu Heberu garo ai, e Roma garo ai, ema Grik garo ai etorerito. Iesu ḡevaḡa-satauroato gabuna tu vanuḡa baregona sevinai, be Iuda tarimari vovoka na mo guruḡa debana ḡeiaviato. ");
INSERT INTO snc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Benamo Rubu Veaḡa vereri baregori na Pilato ḡekiraiato, ḡekirato, “‘Iuda tarimari ḡeri Vere’ tu asi notorea, senaḡi iniḡesi notorea, ‘Ḡia ekirato, au tu Iuda tarimari ḡeri Vere.’” ");
INSERT INTO snc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma Pilato na evaḡa-veserito, ekirato, “Kara au na batorea guruḡana tu batorea veḡata.” ");
INSERT INTO snc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Vetari tarimari na Iesu ḡevaḡa-satauroato murinai, ḡena dabuḡa ḡeḡabirito, ma karava vasivasi ḡeveirito, benamo vetari tarimari na ḡeri sebori sebori ḡeḡabito, ma vei-gabigabi dabuḡana tu ḡeiaḡuiato. Korana vei-gabigabi dabuḡana tu dabuḡa sebona na moḡo ḡeturiato. A ḡia tu dia dabuḡa vesavesari vovoka ḡeturi-kavikavito vau ḡeveiato dabuḡana. ");
INSERT INTO snc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Moḡesina naima tauḡeri fakari ai ḡeguruḡa-vegogoto, ḡekirato, “Asi sidarea, senaḡi laki ḡerena ta siveia, bewinini tarimana na mo dabuḡa bene ḡabia uranai.” Mai veiḡa ḡeveiato tauna korikori tu, Buka Veaḡai ḡetorerito guruḡari beḡene moḡoni ḡana, maiḡesi ekirani, “Au ḡegu dabuḡa ḡia fakari ai ḡekaravarito, ema au ḡegu dabuḡa uranai laki ḡerena ta ḡeveiato.” Moḡesi naima vetari tarimari na maiḡeri veiḡa ḡeveirito. ");
INSERT INTO snc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu ḡena satauro koranai tu vavine vasivasi (4) ḡeruḡa-taḡoto-ḡoi: Iesu sinana, e Iesu sinana tarina vavinena, e Maria, Klopa ḡaraḡona, ema Maria, Magadala vanuḡana vavinena. ");
INSERT INTO snc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu na sinana e Iesu na eura-viniato-ḡoi merona monai ruḡataḡo eḡitarito, benamo Iesu na sinana ekiraiato, ekirato, “Natumu merona maniḡa.” ");
INSERT INTO snc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ema ḡena mero ekiraiato, ekirato, “Sinamu maniḡa.” Mo ḡaro na evesinato, Iesu ḡena mai mero na Iesu sinana ḡena numa ḡana eḡori-iaḡoato, benamo enariato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Moḡa murinai Iesu eribato, ḡena ḡauvei mabarari tu varau bevaḡa-koriri. Ma Buka Veaḡai ḡetoreato guruḡana bene moḡoni uranai ekirato, “Au bokagu bekoke.” ");
INSERT INTO snc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A gwaḡutu ta nuḡanai tu vine nanuna mamakina monai toretaḡo. Nanu erimaiani dagarana mo vine nanuna mamakinai ḡeduḡi-fereiato. Ma vine nanuna mamakina na evonuto, benamo isopo legana dudunai ḡetore-kauato, benamo ḡeduḡi-varaḡeato, Iesu bokanai ḡetore-kauato. ");
INSERT INTO snc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu na mo vine nanuna mamakina eniuato, benamo ekirato, “Bema-kori.” Ma debana eḡero-riḡoto, benamo tauḡanina na ḡia iaukana eraka-vaḡito, emaseto. ");
INSERT INTO snc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mo ḡaro moḡa tu rovinatore ḡarona, korana beboḡini ma belaḡanini tu Sabadi veaḡana baregona ta mo Pasova o Iuda tarimari mase aneruna na evanaḡirito moḡo verekona ḡarori nuḡari ai. Moḡa lorinai Iuda tarimari asi ḡeurato, mo Sabadi veaḡana baregonai mase tarimari tauḡaniri satauro tuḡunai beḡene tanu. Moḡesi naima Pilato ḡenogiato, Iesu ema mo tarima ruarua kwakuri beḡene kwari-koruri, benamo satauro tuḡuna na beḡene ḡabi-riḡori. ");
INSERT INTO snc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Moḡa lorinai vetari tarimari ḡeiaḡomato, benamo ḡevaḡa-satauro debaiato tarimana kwakuna ḡekwari-koruato, ma tarima vaḡa-ruaruana Iesu ḡesi ḡevaḡa-satauroato moḡa maki moḡesi ḡeveiato. ");
INSERT INTO snc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Senaḡi Iesu ḡenai ḡeiaḡomato nai, Iesu tu varau emaseto ḡeḡitaiato, be kwakuna asi ḡekwari-koruato. ");
INSERT INTO snc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A vetari tarimana ta na moḡo Iesu sebina garaḡota na egwanuato. Benamo asikauna mo egwanuato gabuna na rara e nanu ḡevebubu-rosito. ");
INSERT INTO snc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Maiḡa eḡitaiato tarimana na evari-fiuato, ma ḡia ḡena vevarifiu tu moḡoni. Ḡia ma ribana, ḡia tu eguruḡa-korikorini, ma ḡia na ekiraḡi-foforiani anina tu, ḡomi na maki boḡono vaḡa-moḡonia ḡana. ");
INSERT INTO snc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Maiḡeri veiḡa ḡeveirito korana tu, Buka Veaḡai ḡetorerito guruḡari beḡene moḡoni, ekirani, “Ḡia tu turiḡana sebona ta maki asi beḡe lau-koruani.” ");
INSERT INTO snc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma Buka Veaḡai etoreato guruḡana ta tu maiḡesi ekirani, “Sebina ḡegwanuato tarimana ḡenai ma beḡe boḡe-raḡeni.” ");
INSERT INTO snc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Maiḡa murinai Iosefa, Arimatea tarimana, na Pilato enoḡiato, Iesu tauḡanina bene ḡabia ḡana. Pilato na maoro eviniato, benamo eiaḡoto, Iesu tauḡanina ea ḡabiato. Iosefa tu Iesu ḡena mero ta, senaḡi Iuda tarimari gariri eveito-ḡoi, be eraka-vekuretoḡato-ḡoi, ḡena veḡabidadama asi evaḡa-foforito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, tovotovonai Iesu ḡenai boḡi eiaḡoto tarimana, maki eiaḡoto. Ḡia na tu muro e aloe ḡegiro-sebonarito muramurana kilogram gabana toitoi (30) maki eḡabi-kauato. (Mo vedau muramurana bonana tu namo vedaurea). ");
INSERT INTO snc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Benamo Iesu tauḡanina ḡeḡabiato, ma tauri ruarua na dabuḡa kurokurona namona mamuramurana dagarana na ḡekumuato, Iuda seneri na mase tarimari ḡeveirito-ḡoi ilailanai. ");
INSERT INTO snc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu ḡevaḡa-satauroato gabuna tu ma vamokana. Mo vamoka nuḡanai tu gara kouḡana ta fore na ḡeveiato, ma nuḡanai tarima ta tu roḡosi beḡere tore-toḡaia. ");
INSERT INTO snc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mo ḡaro moḡa tu Iuda tarimari ḡeri rovinatore ḡarona, ema mo gara kouḡana maki kavinaḡi, be Iesu ḡeḡabiato, monai ḡea tore-toḡaiato. ");
INSERT INTO snc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabadi ḡarona murinai, Sandei boḡiboḡi iamoiamo, roḡo mukunamukunai, Maria, Magadala vavinena, gara ḡana eiaḡoto. Benamo eboḡeto, gara ḡatama bokana ḡetabe-ḡauato forena tu ḡeḡabi-veḡitaiato, be irau ai vetore eḡitaiato. ");
INSERT INTO snc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Benamo eraga-ḡenoḡoi-iaḡomato, Simona Petero e Iesu ḡena mero ta, Iesu na eura-viniato-ḡoi merona, ḡeri ai, benamo ekirarito, ekirato, “Vereḡauka tu gara na beḡe ḡabi-rakaia, ma ḡita asi ribara ainai beḡe torea.” ");
INSERT INTO snc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Benamo Petero ema Iesu ḡena mo mero ta moḡa ḡeraka-rosito, benamo gara ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma tauri ruarua ḡeraga-vegogo-iaḡoto, senaḡi Iesu ḡena mo mero ta na Petero eraga-kwaneato, ma gara forenai ea raḡasi-guineto. ");
INSERT INTO snc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Etoḡa-tarito, benamo eboḡe-toḡato, Iesu ḡekumuato mo dabuḡa kurokurona eḡitaiato monai toretari. Ḡia tu eboḡe-toḡato moḡo, asi eraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Benamo Simona Petero eraḡasito, benamo eraka-toḡato gara kouḡana nuḡanai, ma Iesu ḡekumuato dabuḡa kurokurona eḡitaiato monai toretari, ");
INSERT INTO snc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ema Iesu debana mabarana ḡebaru-ḡauato mukona eḡitaiato, Iesu tauḡanina ḡekumu-ḡauato mo dabuḡa kurokurona ḡesi tu asi tore-sebona. Senaḡi mo muko tu ḡereḡana iokuioku, be irau ai. ");
INSERT INTO snc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Benamo Iesu ḡena mo mero ema raḡasi-guineto, moḡa maki eraka-toḡato. Moḡeri dagara eḡitarito, benamo evaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Korana ḡia na Buka Veaḡai evetoreto guruḡana tu roḡosi roḡo beḡene riba-korikoria, guruḡana tu maiḡa: Iesu tu mase na ma bevariḡisi-ḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Benamo Iesu ḡena mero ruarua ma ḡeḡenoḡoito ḡeri numa ḡana. ");
INSERT INTO snc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Senaḡi Maria tu gara kouḡana murikanai eruḡato vau etaḡito-ḡoi. Ma etaḡito-ḡoi nuḡanai etoḡa-tarito, benamo eboḡe-toḡato fore kouḡana nuḡana ḡana. ");
INSERT INTO snc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Benamo aneru ruarua eḡitarito, dabuḡa kurokuro ḡetogito, Iesu ḡevaḡa-genaiato gabunai tanutaḡo. Ta tu debakanai etanuto, ma ta tu gabikanai etanuto. ");
INSERT INTO snc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Benamo mo aneru ruarua na ḡekiraiato, ḡekirato, “Vavine, ḡoi tu karase nai otaḡini?” Maria na evaḡa-veserito, ekirato, “Korana au ḡegu Vereḡauka tu beḡe ḡabi-rakaia, ma au asi ribagu ainai ma beḡea torea.” ");
INSERT INTO snc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maiḡesi eguruḡa-ḡosito murinai, eboḡe-ḡeḡeraḡito tu, Iesu monai ruḡataḡo eḡitaiato. Senaḡi Maria tu asi eriba-maoroto, mo tu Iesu eruḡa-taḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu na ekiraiato, ekirato, “Vavine, ḡoi tu kara dainai otaḡini?” Ḡoi tu deikara ovetauani?” Maria etuḡamaḡito, Iesu tu mo vamokai eḡaukarani tarimana, be ekiraiato, ekirato, “Verebara, bema ḡoi na boḡabi-rakaia nai tu, ainai botorea gabuna nokira-varagu, be naḡabia.” ");
INSERT INTO snc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu na ekiraiato, ekirato, “Maria!” Maria eruḡa-kureto, benamo ekiraiato Heberu garo ai, ekirato, “Raboni!” Mai guruḡa tauna tu, “Vevaḡa-riba Tauna.” ");
INSERT INTO snc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu na ekiraiato, ekirato, “Au asi noḡabi-tarigu, korana au tu Tamagu ḡenai roḡosi roḡo bara varaḡe. Senaḡi noiaḡo au tarikakagu ḡeri ai, benamo bono kirari, ‘Au tu au Tamagu e ḡomi Tamami, ema au ḡegu Barau e ḡomi ḡemi Barau ḡenai avaraḡeni.’” ");
INSERT INTO snc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria, Magadala vavinena, Iesu ḡena mero ḡeri ai eiaḡoto, benamo ekirarito, ekirato, “Au na Vereḡauka tu baḡitaia.” Benamo Vereḡauka na evaḡa-guruḡaiato guruḡari mabarari maki ma ekira-vararito. ");
INSERT INTO snc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mo Sandei boḡi ai, mo tu ḡaro giniguinena fura ta nuḡanai, Iesu ḡena mero tu numa tai ḡevegogoto. Ḡia tu Iuda tarimari gariri ai, be ḡeri numa ḡatama bokana tu ḡebiri-ḡauato. Ma Iesu eiaḡomato, ḡia fakari ai eruḡa-tarito, benamo ekirato, “Asi ḡogari, nuḡami ai maino netanu.” ");
INSERT INTO snc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Moḡesi eguruḡa-ḡosito murinai, ḡimana ḡeikokorito e sebina ḡegwanuato moḡeri evaḡa-ḡitarito. Vereḡauka ḡeḡitaiato nai, ḡeiaku-rakavato. ");
INSERT INTO snc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Benamo Iesu na ḡia ma ekirato, “Asi ḡogari, nuḡami ai maino netanu! Tamagu na au etuḡuguto kavana, au na maki ḡomi atuḡumini.” ");
INSERT INTO snc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Moḡesina evaḡa-guruḡa ḡosirito murinai, iaḡana efururu-iaḡoato ḡeri ai, benamo ekirarito, ekirato, “Iauka Veaḡa ḡoḡabia. ");
INSERT INTO snc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ḡomi na ḡena rakava boḡo tuḡamaḡi-fitoḡaiani tarimana, ḡena rakava tu Barau na maki betuḡamaḡi-fitoḡaiani. A ḡena rakava asi boḡo tuḡamaḡi-fitoḡaiani tarimana tu, ḡena rakava Barau na maki asi betuḡamaḡi-fitoḡaiani.” ");
INSERT INTO snc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Senaḡi Tomasi tu Iesu ḡena mero ḡeri ai eiaḡoto ḡaronai ḡia tu asiḡina. Tomasi arana ta tu Didimo o Kafa, ema ḡia maki Iesu ḡena mero ta mo mero gabanana ruarua (12) nuḡanai. ");
INSERT INTO snc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Moḡesina nai Iesu ḡena mero na ḡekira-varaiato, ḡekirato, “Vereḡauka tu ḡai na baḡa ḡitaia.” A Tomasi tu ekirato, “Au tu ḡimana ḡeikokorito gaburi baḡitarini, ema didigu ikoko ḡeraka-toḡato gaburi na baduḡi-toḡaiani, e sebina ḡegwanuato, monana didigu baduḡi-toḡaiani vau, bavaḡa-moḡoniani.” ");
INSERT INTO snc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ḡaro imaima toitoi (8) ḡekorito murinai, Iesu ḡena mero tu numa nuḡanai maia, ma mo ḡaro ai tu Tomasi maki ḡia ḡesi. Mo numa ḡatama bokana tu biribiri, senaḡi Iesu tu eiaḡomato, fakari ai eruḡa-tarito, benamo ekirato, “Asi ḡogari, nuḡami ai maino netanu.” ");
INSERT INTO snc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Benamo Tomasi ekiraiato ekirato, “Tomasi, ḡimagu noḡitari, didimu mai ikoko gaburi ai noma duḡi-toḡaia. E ḡimamu notuḡu-iaḡomaia, be didimu au sebigu ḡegwanuato mainai noma duḡi-toḡaia. Ḡemu daradara novaḡa-dokoa, ma novaḡa-moḡonigu.” ");
INSERT INTO snc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Benamo Tomasi na Iesu evaḡa-veseato, ekirato, “Au ḡegu Vereḡauka ema ḡegu Barau.” ");
INSERT INTO snc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu na ekiraiato, ekirato, “Tomasi, ḡoi tu ovaḡa-moḡoniguni, korana boḡitagu nai. A asi ḡeḡitaguni, senaḡi ḡevaḡa-moḡoniguni tarimari tu beḡene iaku.” ");
INSERT INTO snc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu na vetoḡa boruri ḡutuma ḡena mero ḡoirari ai eveirito. Senaḡi moḡeri mai bukai tu asi atorerito. ");
INSERT INTO snc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","A maiḡeri atorerito korana tu, ḡomi na Iesu boḡono vaḡa-moḡonia, ḡia tu moḡoni Keriso, Barau Natuna. Ma bema ḡomi na ḡia boḡo vaḡa-moḡoniani nai, ḡia aranai maḡuri vanaḡivanaḡi boḡo ḡabiani. ");
INSERT INTO snc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Moḡa murinai Tiberia kouna rikinai Iesu ḡena mero ḡeri ai ma efoforito. Monai tu maiḡesi efoforito: ");
INSERT INTO snc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petero; Tomasi, arana ta tu Didimo o Kafa; Natanaela, Kana vanuḡa tarimana, Kana tu Galilea tanonai; Sebedaio natuna ruarua; ema Iesu ḡena mero ruarua; mabarari monai ḡetanu-vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Benamo Simona Petero na ekirarito, ekirato, “Au tu kou ḡana maina aiaḡoni.” Ma mo kotari ḡekirato, “Ḡai maki ḡoi ḡesi taiaḡoni.” Benamo tauri imaima ruarua (7) ḡeraka-rosito, ḡeiaḡoto, ḡasi ai ḡea raḡekauto, benamo ḡea mainato. Senaḡi mo boḡi barabara nuḡanai tu maḡani-kone ta maki asi ḡeḡoitaḡoato. ");
INSERT INTO snc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Boḡiboḡi iamoiamo Iesu tu kou rikinai eruḡa-taḡoto-ḡoi; senaḡi ḡena mo mero tu asi ḡeriba-maoroto, mo tu Iesu eruḡa-taḡoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Benamo Iesu na ekirarito ekirato, “Natugu, ḡomi ḡemi ai maḡani-kone tari maniḡeri, ba?” Ḡia na ḡevaḡa-veseato, ḡekirato, “Asiḡina.” ");
INSERT INTO snc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Benamo Iesu na ekirarito, ekirato, “Reke ḡasi aroribana rekena na ḡofiu-riḡoa, maninai tu maḡani-kone tari boḡo ḡoitaḡoni.” Reke ḡefiu-riḡoato, benamo ma ḡeinu-raḡea ḡetato nai tu ḡeinu-kavaiato meto fanifani, korana tu maḡani-kone vovoka tabutabu ḡevaḡa-toḡarito bene. ");
INSERT INTO snc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iesu ḡena mero ta tu Iesu na eura-viniato-ḡoi merona. Mai mero na Petero ekiraiato, ekirato, “Vereḡauka tu iomoḡa.” Simona Petero na mo guruḡa eseḡaḡiato, “Vereḡauka tu iomoḡa” nai, asikauna ḡena dabuḡa eraga-veiato, benamo kou ai ebaba-reito. Mo dabuḡa tu, eḡauveito-ḡoi be ekokiato. ");
INSERT INTO snc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Senaḡi Iesu ḡena mero kota tu mo bouti na vau ḡeleva-iaḡoto. Mo reke ma maḡani-konena maki ḡeinukau-iaḡo sebonaiato. Korana ḡia na mo reke ḡefiu-riḡoato gabuna ema fenu fakari tu asi manaḡa, mita sinau sebona (100) kavana moḡo. ");
INSERT INTO snc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Fenu ai ḡea darokauto nai, ḡeboḡeto tu karava vaḡa-ḡara ḡeḡitaiato, e maḡani-kone karava torekau ḡeḡitarito, ema beredi tari maki monai toretaḡo. ");
INSERT INTO snc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Iesu na ekirarito, ekirato, “Ḡomi na reke ai boḡo vaḡa-toḡari maḡani-koneri tari ḡoḡabi-iaḡomari.” ");
INSERT INTO snc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Petero ḡasi ai eraḡekauto, benamo reke fenu ai einu-raḡeato. Mo reke tu maḡani-kone baregori na evonuto, mo maḡani-kone baregori tu mabarari sinau sebona gabana imaima ma toitoi (153), ḡutuma lelevaḡi, senaḡi reke tu asi evedareto. ");
INSERT INTO snc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu na ekirarito, ekirato, “Ḡoiaḡoma, ḡoma ḡaniḡani.” Iesu ḡena mo mero moḡeri ta na Iesu tu iniḡesi asi ma ḡedanaḡiato, “Ḡoi tu dei, ei?” Korana ḡia ribari, mo tu Vereḡauka. ");
INSERT INTO snc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu eiaḡomato, beredi eḡabiato, benamo evinirito, ma maḡani-kone maki moḡesi eveirito. ");
INSERT INTO snc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mai tu nega vaḡa-toitoina ḡena mero ḡeri ai efoforito, Barau na mase na evaga-variḡisi ḡenoḡoiato murinai. ");
INSERT INTO snc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ḡeḡaniḡani-ḡosito murinai, Iesu na Petero ekiraiato, ekirato, “Simona, Ioane natuna, ḡoi na au oura-viniguni veuravinina na maiḡeri ḡeri veuravini au ḡegu ai ḡetoreani maki evanaḡiani, ei?” Petero ekirato, “Oi Vereḡauka, ḡoi ma ribamu, au na ḡoi tu aura-vinimuni.” Iesu na ekiraiato, ekirato, “Au ḡegu mamoe naturi bono ḡuburi.” ");
INSERT INTO snc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu na ma edanaḡi-ḡenoḡoiato, ekirato, “Simona, Ioane natuna, au oura-viniguni, ei?” Petero evaḡa-veseto, ekirato, “Oi Vereḡauka, ḡoi ma ribamu, au na ḡoi tu aura-vinimuni.” Iesu ekirato, “Au ḡegu mamoe bono nari-ginikauri.” ");
INSERT INTO snc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu na Petero vaḡa-toitoina ma edanaḡiato, ekirato, “Simona, Ioane natuna, ḡoi na au oura-viniguni, ei?” Petero enuḡa-metoto, korana Iesu na mo tu vaḡa-toitoina edanaḡiato, “Ḡoi au tu oura-viniguni, ei?” Petero ekirato, “Vereḡauka, ḡoi tu dagara mabarari ma ribamu, e ḡoi ma ribamu, au na ḡoi tu aura-vinimuni.” Iesu ekirato, “Au ḡegu mamoe bono ḡuburi. ");
INSERT INTO snc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Akira-korikorimuni, ḡoi variḡumu ai tu, tauḡemu na gabakamu gabaḡau na obaruato-ḡoi, benamo oura-vinirito-ḡoi gaburi ḡana oiaḡoto-ḡoi. Senaḡi ḡoi boḡaukani nai tu, ḡimamu botuḡu-roroḡotoani, benamo tarima ta na ḡimamu bebaruani, benamo beḡori-kaumuni, ma asi oura-viniani gabuna ḡana beḡori-iaḡomuni.” ");
INSERT INTO snc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu na mai guruḡa ekiraḡiato tu, Petero bemaseni dabarana ema ḡena mase na kamasi Barau bevaḡa-raḡe baregoani, etore-rosiato. Benamo Petero ekiraiato, ekirato, “Au murigu ai noma raka.” ");
INSERT INTO snc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petero eruḡa-kureto tu, Iesu na eura-viniato-ḡoi merona eḡitaiato, muriri na eraka-iaḡoto-ḡoi. Mai mero tu, mo Iesu ḡeḡaniḡani-vegogoto lavilavinai Iesu ḡenai evetabekauto, benamo edanaḡiato, ekirato, “Vereḡauka, ḡoi berevamuni tarimana tu dei, ei?” ");
INSERT INTO snc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petero na mo mero (o Ioane) eḡitaiato, benamo Iesu ekiraiato, ekirato, “Senaḡi Vereḡauka, ḡia maḡurina tu aiḡesi ei?” ");
INSERT INTO snc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu na evaḡa-veseato, ekirato, “Bema au baurani, ḡia tu maḡuri bene tanu mo, au ma baḡenoḡoini, ḡoi tu asi ḡemu ḡauvei ta maniḡa ovedanaḡi-iaḡiani. Ḡoi tu au murigu ai noma raka.” ");
INSERT INTO snc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mai guruḡa dainai, tarikaka veḡabidadama nuḡanai fakari guruḡa leileiri ḡekiraḡirito-ḡoi, ḡekirato, “Iesu ḡena mai mero maiḡa tu asi bemaseni.” Senaḡi Iesu tu asi ekirato, mo mero tu asi bemaseni. Iesu maiḡesi moḡo ekirato, “Bema au baurani, ḡia tu maḡuri bene tanu mo, au ma baḡenoḡoini, ḡoi tu asi ḡemu ḡauvei ta maniḡa ovedanaḡi-iaḡiani.” ");
INSERT INTO snc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mo Iesu ḡena mero dagarana tu maiḡa, maiḡeri guruḡa evari-fiurini ema etorerini maiḡa. Ḡita ribara, ḡia ḡena vevarifiu guruḡari tu moḡoni. ");
INSERT INTO snc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu na dagara tu vovoka eveirito. Bere mabarari ḡere toreri nai tu, au atuḡamaḡini, mai tanobara gabuna mabarana tu bere kei, asi veḡata bere ilaila, moḡeri buka mabarari ḡetore-vegogori ḡana uranai tu-na. ");
INSERT INTO snc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, ḡoi atore-vinimuni. Ḡegu toretore giniguinena nuḡanai, Iesu ḡena ḡauvei e ḡena vevaḡa-riba guruḡari mabarari atore-foforirito, ḡena ḡauvei esinaiato veḡata, ");
INSERT INTO snc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","eiaḡoto mo, Barau na guba ḡana eḡabi-varaḡeato. Roḡosi roḡo bere ḡabi-varaḡea nuḡanai, Iauka Veaḡa ḡenana eḡabi-viriḡirito apostolori evaḡa-ribarito. ");
INSERT INTO snc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ḡena midigumidigu e mase murinai ḡia mai apostolo ḡeri ai efoforito ema vetoḡa moḡoniri vovokari ai ḡia tauḡena evevaḡa-moḡonito ḡia tu maḡuri etanuni. Ḡia tu ḡaro gabana vasivasi (40) nuḡanai apostolo ḡeri ai dabara vovokai efoforito-ḡoi, ḡeḡitaiato-ḡoi, ema Barau ḡena Basileia, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa), varina ḡeri ekiraḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma Iesu ḡesi ḡeraka-vegogoto nai, Iesu na ekirarito, ekirato, “Ierusalema asi boḡono iaḡuia, senaḡi au na akira-varamito varevarena roḡo boḡono vaḡa-nogaia, mo tu au Tamagu na ekiraḡi-toreato varevarena. ");
INSERT INTO snc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Korana Ioane tu moḡoni nanu na ebabatisoto-ḡoi, senaḡina ḡomi tu ḡaro viravira beḡe korini murinai tu, Iauka Veaḡa na bebabatisomini.” ");
INSERT INTO snc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostolo Iesu ḡesi ḡevegogoto nai, Iesu ḡedanaḡiato, ḡekirato, “Vereḡauka, ḡoi na toma mai negai Isaraela tarimama, Roma ḡeri veḡitaḡau na bovaḡa-maḡurimani, benamo Isaraela ḡema veḡitaḡau o basileia ma bovini-ḡenoḡoimani ba?” ");
INSERT INTO snc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu evaḡa-veseto, ekirato, “Mani tu au Tamagu ḡereḡana ḡena seḡukai ḡarori e negari etorerito, ḡomi na tu asi boḡo ribarini. ");
INSERT INTO snc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Senaḡi ḡomi tu Iauka Veaḡa iatami ai beraka-riḡoni, benamo seḡuka boḡo ḡabiani, ema au kiraḡi-foforigu tarimami ai boḡo iaḡoni, Ierusalema ai, Iudea ai e Samaria gaburi mabarari ai, beiaḡoni mo, tanobara gaburi mabarari ai.” ");
INSERT INTO snc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eguruḡa-ḡosito murinai, matari ḡutuḡuturi ai Barau na guba ḡana eḡabi-varaḡeato. Ḡeḡita-ḡauato mo, magube na ekou-ḡauato, benamo asi ma ḡeḡitaiato. ");
INSERT INTO snc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Apostolo na Iesu guba ḡana evaraḡeto-ḡoi roḡo ḡeḡita-raḡeato-ḡoi nuḡanai, tau ruarua dabuḡa kurokurori na ḡevedabuḡato, asikauna ḡia seviri ai ḡema ruḡa-tarito. ");
INSERT INTO snc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Benamo ḡekirato, “Galilea tarimami, karase maninai boḡo ruḡa vau guba ḡoḡita-taḡoani? Mai Iesu, ḡomi ḡemina guba ḡana beḡabi-varaḡea tarimana, tu ma beḡenoḡoi-iaḡomani. Ḡia tu guba ḡana bevaraḡe boḡo ḡitaia kavana, guba na ma bemariḡoni.” ");
INSERT INTO snc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Benamo apostolo Olive Ḡorona na Ierusalema ḡana ma ḡeḡenoḡoi-iaḡoto. Mo gabu ruarua fakari tu kilomita sebona kavana. ");
INSERT INTO snc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ierusalemai ḡeraḡasito, benamo ḡetanuto-ḡoi numana tuḡuna daiḡutuna ḡana ḡeraḡekauto. Mo daiḡutu ai apostolo ḡevegogoto, arari tu Petero; Ioane; Iakobo (o Iames) e Anduru; Filipo e Tomasi; Batolomeo; Mataio; Iakobo Alfeo; Simona, Selote tauna; ema Iudas, Iakobo natuna. ");
INSERT INTO snc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ḡia mabarari ma nuḡari sebona ḡesi ḡeḡuriḡuri-vegogoto-ḡoi, vavine tari maki e Maria, Iesu sinana, ema Iesu tarina doḡoro. ");
INSERT INTO snc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Moḡeri ḡaro ai Iesu ḡevaḡa-moḡoniato-ḡoi tarimari mabarari tu sinau sebona ma gabana ruarua (120) ḡevegogoto-ḡoi. Ḡia fakari na Petero eruḡa-vaisito, benamo ekirato. ");
INSERT INTO snc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tarikakagu mabarami, toretore veaḡana tu bema moḡoni, mo tu Iauka Veaḡa Davida muruna na kai-veḡata ekirato, Iudas na Iesu ḡabitarina tarimari beḡori-kaurini guruḡana. ");
INSERT INTO snc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iudas tu ḡai karoma ta, ema ḡia maki apostolo ḡauveina tarimana, ḡai kavana.” ");
INSERT INTO snc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ḡena vei-rakava voina monina na tano ta evoiato. Monai ḡia eketoto, benamo emaseto, ma nuḡana eḡwa-fakaiato, benamo sinaḡena evebubu-rosito. ");
INSERT INTO snc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ierusalema tarimari mabarari na varina ḡeseḡaḡiato, benamo mo tano arana ḡeri garo ai ḡekiraḡiato “Akeledama” anina tu “Rara Tanona.” ");
INSERT INTO snc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Korana Salamo bukanai varau ḡetoreato, ekirani, ‘Ḡena numa bene karovo, tarima ta asi bene tanu.’ Ma guruḡa ta Salamo nuḡanai ekirani, ‘Ḡena veḡitataḡo ḡauveina maki ta na bene ḡabia.’ ");
INSERT INTO snc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Moḡa lorinai namona tu tau ta siḡabi-viriḡia. Mo tau tu ḡita ḡesi vanaḡivanaḡi tarakao-vegogoto-ḡoi, Iesu Vereḡauka ḡita fakarai taraka-toḡato-ḡoi e taraka-rosito-ḡoi nai, ");
INSERT INTO snc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ema Ioane na tarima ebabatisorito negana na, beiaḡoma mo, Iesu ḡai ḡemana guba ḡana eḡabi-varaḡeato ḡarona tarimana ta. Korana tu ḡia maki ḡai ḡesi Iesu ḡena variḡisi-ḡenoḡoi bene kiraḡi-foforia. ");
INSERT INTO snc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Moḡa lorinai ḡia na tau ruarua ḡeḡabirito, Iosefa, arana tu Barasaba ḡetato-ḡoi, arana ta maki Iusto; ema Matias. ");
INSERT INTO snc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Benamo ḡeḡauḡauto, ḡekirato, “Vereḡauka o, tarimarima mabarari nuḡari ḡoi na tu oribarini, moḡa lorinai novaḡa-ḡitama, dei tu ḡoi na boḡabi-hidia, ");
INSERT INTO snc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","apostolo ḡauveina bene veia Iudas gabunai; a Iudas tu eiaḡoto ḡena gabu korikorina ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Benamo fore ḡerena ḡeveiato nuḡanai, fore tu Matias aranai eketoto, benamo Matias apostolo gabanana sebona (11) ḡesi ḡeiavi-sebonaiato. ");
INSERT INTO snc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekoste ḡaronai, Iesu ḡevaḡa-moḡoniato-ḡoi tarimari mabarari gabu sebonai ḡevegogoto. Pentekoste anina tu gabana imaima (50), mo tu Pasova verekona ḡarona na beiaḡoma mo, mai ḡaro maiḡa. ");
INSERT INTO snc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Benamo asikauna iavara baregona ta guruna noḡa guba na emariḡoto, ḡetanu-vegogoto numana nuḡana mabarana evaḡa-vonuato. ");
INSERT INTO snc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Benamo noḡa moḡo karava meari kavana ḡemariḡoto-ḡoi ḡeḡitarito. Mo karava meari ḡemariḡoto, benamo ḡia tata tubuari ai ḡemoreto. ");
INSERT INTO snc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Benamo ḡia mabarari Iauka Veaḡa na evaḡa-vonurito, benamo garo irauirauri ai ḡeguruḡato, Iauka Veaḡa na evinirito ilailanai. ");
INSERT INTO snc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Moḡa ḡaronai tu Iuda tarimari, Barau garina ḡeveito-ḡoi tarimari, tu tanobara gaburi mabarari na ḡeiaḡomato, benamo Ierusalemai ḡetanuto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mo guru ḡeseḡaḡiato nai, tarimarima ḡutuma ḡeḡaru-vegogoto. Nuḡari ḡefarevaḡito, korana ḡia tata na Iesu ḡevaḡa-moḡoniato-ḡoi tarimari ḡeseḡaḡirito tu mo ḡeraka-vegogoto tarimari ḡeri garo ai ḡeguruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ḡia ḡeḡaba-rakavato e ḡedaradarato, ḡekirato, “Mai ḡeguruḡani tarimari tu Galilea tarimari, ene? ");
INSERT INTO snc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kamara dabarai tu ḡita tata ḡera garo ai ḡeguruḡani taseḡaḡirini? ");
INSERT INTO snc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ḡita tari tu Patia tarimara, tari tu Media tarimara e Elam tarimara. Tari tu Mesopotamia, Iudea e Kapadokia na, ema tari tu Ponto na e Asia na, ");
INSERT INTO snc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia e Pamfilia na, Aigupito e Kurene sevina Libia tanori na, ema tari tu Roma na taiaḡomato, ");
INSERT INTO snc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iuda tarimara, e irau bese tarimari Iuda ḡera toma-rakariḡo ḡeḡabi-raḡeato tarimari; ema ḡita tari tu Krete e Arabia tarimara. Senaḡi ḡita mabarara na taseḡaḡirini ḡita tata ḡera garo ai Barau na veiḡa baregori boruri eveirito-ḡoi ḡekiraḡi-foforirini.” ");
INSERT INTO snc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mabarari ma nuḡa-farevaḡiri e ma daradarari ḡesi tauḡeri ḡevedanaḡi-vedanaḡito, ḡekirato, “Mai veiḡa anina tu kara?” ");
INSERT INTO snc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Senaḡina tarima tari na tu ḡevaseva-vaseva-iaḡirito, ḡekirato, “Maiḡeri tarima tu beḡe niu-rakava.” ");
INSERT INTO snc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Benamo Petero ma apostolo gabanana sebona (11) ḡesi ḡeruḡa-vaisito, ma garona evaḡa-baregoato, benamo vegogo tarimari eḡobata-vinirito, ekirato, “Iuda tarimami e Ierusalemai ḡotanuni tarimami mabarami, boḡono seḡaḡi-ginikau, mai veiḡa tauna ḡemi nakiraḡi-maḡataia. ");
INSERT INTO snc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Maiḡeri tarima tu asi beḡe niu-rakava, ḡomi ḡotuḡamaḡini kavana. Mai tu roḡo boḡiboḡi horaḡauna 9 koloko. ");
INSERT INTO snc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Senaḡi maitoma tu Ioel, peroveta tarimana, na ekiraḡi-guineato kavana efoforini, ekirato, ");
INSERT INTO snc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Barau ekirani: Ḡaro dokori ai au Iaukagu babubu-riḡoani tarimarima mabarari iatari ai. Benamo natumi merori e ḡuiatori beḡe perovetani, ḡemi maraḡa variḡu beḡe mata-vanaḡini, ema ḡemi tau ḡaukari beḡe nuvini. ");
INSERT INTO snc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oi, moḡeri ḡaro ai au ḡegu vetuḡunaḡi tauri e vavineri iatari ai au Iaukagu babubu-riḡoani, benamo beḡe perovetani. ");
INSERT INTO snc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Benamo nuḡa-farevaḡi veiḡari guba tuḡunai bavaḡa-foforirini, ema vetoḡa dagarari tanobarai; rara, e karava, ema goḡu barukari. ");
INSERT INTO snc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ḡaro ma bevetore-kureni bemukunani, e ḡue tu bekakakakani, rara kavanai beiaḡoni, Vereḡauka ḡena iaḡoma ḡarona baregona e irau vedaureana bekavinaḡini nai. ");
INSERT INTO snc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Benamo deikara Vereḡauka aranai ekea-raḡeni tarimana tu maḡuri beḡabiani.’ ");
INSERT INTO snc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isaraela tarimami, mai guruḡa boḡono seḡaḡiri: Iesu, Nasareta tarimana, Barau na eviniato ḡauveina tu ḡomi ḡemi ai evaḡa-fofori ginikauato. Ḡia ḡenana Barau ḡena seḡuka veiḡari e nuḡa-farevaḡi veiḡari ema vetoḡa tari eveirito ḡomi vefakami ai, be ḡomi tu ma ribami. ");
INSERT INTO snc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Barau ḡena urai e ribai varau eboioḡa-guineato ilailanai, Iesu ḡomi ḡimami ai etore-kauato, benamo rakava tarimari na ḡevaḡa-kavamito, benamo Iesu satauro ai ḡoikoko-kauato nai ḡovaḡi-maseato. ");
INSERT INTO snc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Senaḡina Barau na ḡia mase na evaḡa-variḡisi ḡenoḡoiato, ema mase midiguna na eḡabi-vaḡiato, korana mase na ḡia tu asi ilaila beḡabi-tariani riba. ");
INSERT INTO snc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davida na ḡia ekiraḡiato, ekirato, ‘Vereḡauka tu ḡaro mabarari ai ḡoiragu ai aḡitaiani. Ḡia tu au aroribagu ai, be dagara ta na asi bevaḡa-ḡarevaguni. ");
INSERT INTO snc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Moḡa lorinai nuḡagu iaku na bevonu, ema ḡegu guruḡa tu iaku na beḡe vonu. Mase garina maki asi aveini, ");
INSERT INTO snc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","korana au tu mase tarimari ḡeri gabu ai asi boraga-kwaneguni, ema ḡemu Tarima Veaḡana tu asi beboraḡani. ");
INSERT INTO snc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Maḡuri dabarari tu varau ovaḡa-ribaguto; ḡoi sevimu ai batanuni, benamo iaku na bovaḡa-vonuguni.’ ");
INSERT INTO snc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tarikakagu mabarami, initoma au tu nuḡagu ma kokorena ḡesi bakirani, ḡita senera baregona Davida tu emaseto ema ḡeguriato, maitoma ḡia gurina tu ḡita ḡesi maiḡea. ");
INSERT INTO snc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Senaḡi ḡia tu peroveta tarimana, ema ma ribana Barau na tu varau ekiraḡi-toreato, ekirato: Davida besena ta tu ḡia ḡena teronai betanukauni veḡata. ");
INSERT INTO snc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davida na eriba-guineato, Barau na kara ḡoirai beveiani eḡitaiato. Benamo Keriso ḡena variḡisi-ḡenoḡoi guruḡana ekiraḡiato, ekirato, ‘Ḡia tu mase tarimari ḡeri gabu ai asi eraga-kwaneato, ema tauḡanina asi beboraḡani.’ ");
INSERT INTO snc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Barau na mai Iesu, mase na evaḡa-variḡisi ḡenoḡoiato, ḡai mabarama ribama. ");
INSERT INTO snc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Barau na eḡabi-vaisiato, ḡimana aroribanai etoreato, benamo Barau na ekiraḡi-toreato, Iauka Veaḡa na Tamana ḡenana eḡabiato. Benamo ḡia na mo Iauka Veaḡa toma bebubu-riḡoa, ḡomi na ḡoḡitaiani ema ḡoseḡaḡiani. ");
INSERT INTO snc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Korana Davida guba ḡana tu asi evaraḡeto, senaḡi ekirato, ‘Barau na au ḡegu Vereḡauka ekiraiato, ekirato: Au aroribagu ai noma-tanu, ");
INSERT INTO snc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bene iaḡo mo, ḡevetari-vinimuni tarimari bana tore-riḡori, kwakumu vaḡa-ruḡa tarina dagaranai bana vaḡa-iaḡori.’ ");
INSERT INTO snc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Moḡa lorinai Isaraela tarimari mabarari tu beḡene riba-ginikau, mai Iesu, ḡomi na ḡovaḡa-satauroato tu, Barau na Vereḡauka e Keriso ai evaḡa-iaḡoato.” ");
INSERT INTO snc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mai guruḡa ḡeseḡaḡiato nai, nuḡari ḡeraḡeto, benamo Petero e mo apostolo tari ḡedanaḡirito, ḡekirato, “Tarikaka, ḡai tu kamasi toma ḡaveini?” ");
INSERT INTO snc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero na ekirarito, ekirato, “Ḡomi tata ḡemi rakava ḡerina boḡono vetuḡamaḡi-kure ma boḡono raka-kure, ema Iesu Keriso aranai babatiso boḡono ḡabia, be ḡemi rakava bene tuḡamaḡi-fitoḡari; ema ḡena varevare, Iauka Veaḡa, boḡono ḡabia. ");
INSERT INTO snc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Korana Barau ḡena kiraḡitore eveiato tu ḡomi ḡemi e ḡomi natumi ḡeri, ema manaḡai ḡetanuni tarimari ḡeri. Aba, Vereḡauka ḡera Barau na ekiraḡi-toreato Iauka Veaḡana tu bekearini tarimari mabarari bevinirini.” ");
INSERT INTO snc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero na guruḡa ḡutuma ekiraḡirito, esisiba-vinirito e elau-naḡirito, ekirato, “Mai bese tarimari rakavari ḡerina tauḡemi boḡono raga-maḡuri.” ");
INSERT INTO snc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tarima ḡutuma na ḡena guruḡa ḡeḡabi-raḡeato, benamo babatiso ḡeḡabiato. Mo ḡaro sebonai tarimarima mabarana daḡara toitoi (3,000) kavana ḡia ḡeri doḡoro nuḡanai ḡebere-toḡato. ");
INSERT INTO snc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Benamo vanaḡivanaḡi apostolo tarimari ḡerina riba ḡeḡabito-ḡoi, ḡevegogoto-ḡoi e ḡevevaḡa-kavato-ḡoi, beredi ḡetavi-kirato-ḡoi o anibou ḡeḡanito-ḡoi e ḡeḡauḡau-vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolo ḡerina Barau na nuḡa-farevaḡi veiḡari e vetoḡa boruri ḡutuma eveirito-ḡoi, ema tarimarima mabarari ḡegari-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iesu ḡevaḡa-moḡoniato tarimari mabarari ḡetanu-vegogoto-ḡoi ema ḡeri-ḡari ḡevevarevare-vevinito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ḡeri farefare e tano ḡevoivoi-iaḡirito-ḡoi, benamo moniri tu ḡia mabarari vefakari ai ḡevarerito-ḡoi, tata ḡena rabu ilailanai. ");
INSERT INTO snc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ḡaro vanaḡivanaḡi mabarari Rubu Veaḡai ḡevegogoto-ḡoi. Ḡeri numai anibou ḡeḡanito-ḡoi e ḡeḡaniḡani-vegogoto-ḡoi ma iakuri e ma mainori ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Barau ḡevaḡa-raḡeato-ḡoi, ema tarimarima mabarari ḡeri veiau-namo ḡeverere-iaḡiato-ḡoi. Benamo ḡaro mabarari ai Vereḡauka na evaḡa-maḡuririto-ḡoi tarimari ḡia ḡesi etore-vegogorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ḡaro ta lavilavi horaḡauna 3 koloko ai ḡauḡau horanai, Petero e Ioane Rubu Veaḡa ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Monai tarima ta tu emaḡurito kwakuna rakava ḡeḡoitaḡoato. Ḡaro mabarari ai ḡeḡwa-iaḡoato-ḡoi, Rubu Veaḡa ḡatama bokana arana “Namo Vedaurea” koranai ḡevaḡa-tanutariato-ḡoi, benamo Rubu Veaḡai ḡeraka-toḡato-ḡoi tarimari ḡeri ai moni enoḡito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ḡia na Petero e Ioane ḡeraka-toḡa ḡana nuḡanai eḡitarito, benamo kara ta ḡevinia uranai enoḡirito. ");
INSERT INTO snc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tauri ruarua na ḡeḡita-karakaraiato, benamo Petero na ekiraiato, ekirato, “Ḡai noḡitama!” ");
INSERT INTO snc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mo guruḡa eseḡaḡiato lorinai, tauri ruarua eḡitarito, ḡia mataboru ekirato tu, kara ta beḡe viniani. ");
INSERT INTO snc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Senaḡi Petero na ekiraiato, ekirato, “Au tu asi ḡegu moni, senaḡina ḡegu ai kara etanuni dagarana avinimuni. Iesu Keriso, Nasareta tauna, aranai akiramuni, novariḡisi, noraka!” ");
INSERT INTO snc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Benamo Petero na kwaku rakava tarimana ḡimana aroribanai eḡabito, evaḡa-ruḡa-vaisiato. Asikauna ḡia kwakuna ema kwakuna komukomuri ḡetubutubu-kauto. ");
INSERT INTO snc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ḡia eburi-vaisito, eruḡa-tarito, eraka-iaḡoto. Benamo Petero ema Ioane ḡesi Rubu Veaḡanai ḡeraka-toḡato, erakato e eburi-vaisito, Barau evaḡa-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tarimarima mabarari na ḡeḡitaiato, erakato e Barau evaḡa-raḡeato-ḡoi, ");
INSERT INTO snc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ema ḡeḡita-leaiato, ḡia tu “Namo Vedaurea” ḡatama-boka koranai etanuto-ḡoi vau enoḡinoḡito-ḡoi tarimana nai, ḡia mabarari nuḡari ḡefarevaḡito e ḡeḡaba-rakavato, mo veiḡa ḡia ḡenai eḡorato nai. ");
INSERT INTO snc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mo tau roḡo Petero e Ioane ḡeri ai eveḡabikau-taḡoto-ḡoi, touraḡe baregona arana “Solomona Ḡena Touraḡe” ai, tarimarima mabarari ḡeḡaba-rakavato, benamo ḡeraga-iaḡoto ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petero na mo tarimarima eḡitarito, benamo evaḡa-guruḡarito, ekirato, “Isaraela tarimami, karase nai mai dagara tu ḡoḡaba-iaḡiani? Karase nai ḡai ḡoḡita-karakaramani? Ḡomi ḡotuḡamaḡini mai tu tauḡema ḡema seḡukai e Barau korana-iaḡinai naima, mai tarima baḡa vaḡa-rakaia ḡotoni? ");
INSERT INTO snc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aberahamo, Isako, Iakobo ḡeri Barau, ḡita senera mabarari ḡeri Barau, na ḡena vetuḡunaḡi tarimana Iesu evaḡa-raḡeato, senaḡi ḡomi na Roma tarimari ḡoviniato beḡene vaḡia ḡana, ma Pilato ḡena ura bene tuḡu-vaḡia asi beḡene vaḡia etato nai, ḡomi tu asi ḡourato. ");
INSERT INTO snc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ḡia tu Veaḡa e Vei-Iobukaiobuka tarimana, senaḡi ḡomi na tu asi ḡoura-viniato, ema Pilato ḡonoḡiato, vaḡivaḡi tarimana tu bene tuḡu-rosia ḡotato. ");
INSERT INTO snc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Maḡuri eḡwa-iaḡomaiato tarimana tu ḡomi na ḡovaḡi-maseato. Senaḡi Barau na mase na ma evaḡa-variḡisi ḡenoḡoiato. Ḡai maiḡa tu ribama e ḡakiraḡi-foforiani. ");
INSERT INTO snc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ḡai ḡema veḡabidadama Iesu aranai nai, mai tarima ḡomi na ḡoḡitaiani e ribami bevaḡa-namoa. Mai tu Iesu aranai ema veḡabi-dadama ḡia ḡenana eiaḡomani na, mai tarima bevaḡa-namo korikoria, ḡomi mabarami na ḡoḡitaiani maiḡa. ");
INSERT INTO snc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tarikakagu mabarami, au toma aribani, kara ḡemi veḡorikau tarimari ḡesi ḡoveiato tu asi ribami dainai. ");
INSERT INTO snc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Senaḡina Barau na guinenai ḡena peroveta tarimari mabarari mururi na ekirato, ḡia ḡena Keriso tu midigu roḡo beḡanini etato. Mo guruḡa tu ḡomi ḡemina ema moḡonito. ");
INSERT INTO snc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Moḡa lorinai ḡovetuḡamaḡi-kure ma ḡoraka-kure Barau ḡenai, be ḡia na ḡemi rakava bene ḡabi-vaḡiri. ");
INSERT INTO snc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bema moḡesi boḡo veini nai, Iauka ḡena kokore Vereḡauka ḡenana beiaḡomani, ema ḡia na Iesu Keriso betuḡu-iaḡomaiani. Ḡia tu Barau na ḡomi ḡemi eḡabitore-guineato. ");
INSERT INTO snc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ḡia tu gubai roḡo betanuni, beiaḡoni mo, Barau na dagara mabarari bevaḡa-variḡu ḡenoḡoirini. Ḡia na ḡena peroveta tarimari veaḡari mururi na kai-veḡata ekiraḡiato ilailanai. ");
INSERT INTO snc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Korana Mose ekirato, ‘Vereḡauka ḡemi Barau na ḡomi ḡemi tarimarima fakari na ḡemi peroveta tarimana ta bevaḡa-ruḡaiani au kavana. Ḡia na bevaḡa-guruḡamini guruḡari mabarari tu boḡono seḡaḡiri. ");
INSERT INTO snc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tarima ta na ḡia ḡena guruḡa asi beseḡaḡi-viniani tarimana tu, Barau na ḡena tarimarima fakari na beḡabi-vaḡiani, benamo bevaḡi-maseani.’ ");
INSERT INTO snc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Moḡoni, peroveta tarimari mabarari Samuela na beiaḡoma mo toma, ema ḡia murina na ḡeiaḡomato peroveta tarimari maki ḡutuma varau ḡeguruḡato, maiḡeri ḡaro ḡekiraḡirito. ");
INSERT INTO snc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ḡomi tu peroveta tarimari naturi, ema Barau ḡena kiraḡitore ḡomi senemi ḡeri eveiato maki ḡomi ḡemi. Barau na Aberahamo evaḡa-guruḡaiato nai, ekirato, ‘Ḡoi natumu ḡenana tanobara beseri mabarari namo beḡe ḡabiani.’ ");
INSERT INTO snc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Moḡa lorinai Barau na ḡena vetuḡunaḡi tarimana Iesu evaḡa-ruḡaiato, benamo ḡemi ai etuḡu-iaḡosi guineato, ḡomi bene vaḡa-namomi ḡana. Mo namo anina tu, ḡomi tata ḡemi rakava ḡerina beḡori-kuremini. ");
INSERT INTO snc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero e Ioane na tarima-rima roḡo ḡevaḡa-guruḡarito-ḡoi nuḡanai, Rubu Veaḡa vereri, e Rubu Veaḡa ḡitaḡauna tarimari ḡeri vere, ema Sadukea tarimari ḡeraḡasito. ");
INSERT INTO snc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ḡia tu ḡebaruto, korana mai apostolo ruarua na tu tarimarima ḡevaḡa-ribarito-ḡoi e ḡeri ḡeḡobatato-ḡoi nai tu ḡekirato-ḡoi, Iesu tu mase na evariḡisi-ḡenoḡoito; moḡa lorinai mase tarimari maki beḡe variḡisi-ḡenoḡoini. ");
INSERT INTO snc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Benamo tauri ruarua ḡeḡabi-taririto, benamo dibura numai ḡebiri-ḡaurito; monai beḡene gena mo boḡiboḡi, korana tu ḡaro maki ekofuto. ");
INSERT INTO snc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Senaḡi Petero e Ioane ḡeri ḡobata tarima vovoka na ḡeseḡaḡiato, benamo tarima ḡutuma na ḡevaḡa-moḡoniato, benamo tau numerana eiaḡoto mabarana tu daḡara imaima (5,000) kavana. ");
INSERT INTO snc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Elaḡanito nai tu, Iuda vereri, e vanuḡa tarima baregori, ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari Ierusalemai ḡevegogoto. ");
INSERT INTO snc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, Rubu Veaḡa verena baregona, e Kaiafas, e Ioane, e Alesanda, ema Rubu Veaḡa verena baregona ḡena bese maki monai. ");
INSERT INTO snc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Benamo tauri ruarua ḡeḡori-iaḡorito, benamo ḡoirari ai ḡea vaḡa-ritoḡorito vau ḡedanaḡirito, ḡekirato, “Kamara seḡukai o deikara aranai mai veiḡa ḡoveiato?” ");
INSERT INTO snc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Benamo Petero, Iauka Veaḡa na evonuto, evaḡa-veseto, ekirato, “Isaraela veremi e veḡitaḡau tarimami! ");
INSERT INTO snc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bema ḡai toma boḡo kea-iaḡomama tu, ḡourani ḡai na ḡakira-varami, mai kwaku rakava tarimana ḡenai veiḡa namona baḡa veia ema kamara dabarai ḡia be-namo nai tu, ");
INSERT INTO snc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ḡomi mabarami e Isaraela nuḡanai tarimarima mabarami tu boḡono riba, Iesu Keriso, Nasareta tarimana, ḡomi na ḡovaḡa-satauroato, ma Barau na mase na evaḡa-variḡisi ḡenoḡoiato tarimana, aranai mai tarima benamo-ḡosiḡosi, ḡomi ḡoirami ai eruḡa-taḡoni. ");
INSERT INTO snc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mo Iesu tu, ‘ḡomi, numa raga tarimami, na ḡoruḡaiato forena, ḡia tu duḡu barana forenai eiaḡoto.’ ");
INSERT INTO snc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vevaḡa-maḡuri tu ḡia ḡereḡana ḡenana bita doḡarini; tanobara mabarana nuḡanai Barau na ara ta tu asi evinirato, ḡita bene vaḡa-maḡurira ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kanisoro tarimari na Petero e Ioane ḡeḡitarito, asi ḡegarito-ḡoi ema ḡeribarito maki, ḡia tu vevaḡa-riba gabuna ta ḡana asi ḡeiaḡoto, ma tauri ruarua asi iaunegari. Moḡa ḡeḡitaiato nai, ḡeḡabato e nuḡari ḡevekeoto, benamo ḡeribato, ḡia tu Iesu ḡesi ḡerakao-vekakoto-ḡoi tarimari. ");
INSERT INTO snc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ema mo tarima ḡeḡitaiato namo-ḡosiḡosi Petero e Ioane ḡesi ḡeruḡa-taḡoto-ḡoi, benamo asi ḡeri guruḡa dabarana. ");
INSERT INTO snc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Moḡa lorinai ḡekirarito, mo vegogo gabuna na ḡeraka-veḡita. Benamo ḡeraka-rosito murika ḡana, benamo ḡia ḡereḡari moḡo ḡevedanaḡi-vevinito, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Maiḡeri tarima ruarua tu kamasi toma taveirini? Ierusalemai ḡetanuni tarimari mabarari ma ribari, ḡia tu nuḡa-farevaḡi veiḡana ta beḡe veia, ema ḡita na asi bita kira-ḡuniḡauani riba. ");
INSERT INTO snc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Senaḡi tarimarima na beḡe vari-fiuani garinai, maiḡeri tarima tu tana vaḡa-gariri e tana kira-ḡoiri, Iesu aranai tarima ta asi ma beḡene vaḡa-guruḡa ḡenoḡoia.” ");
INSERT INTO snc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Benamo ma ḡekea-toḡarito, benamo ḡekirarito, Iesu aranai asiḡina ḡinavaḡi ma beḡene ḡobata e beḡene vevaḡa-riba. ");
INSERT INTO snc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Senaḡi Petero e Ioane na ḡevaḡa-veserito, ḡekirato, “Ḡomi tauḡemi ḡotuḡamaḡi-viriḡia, aiḡa tu roroḡoto Barau ḡoiranai? Ḡomi na kara ḡokiraḡiani baḡana veia, ba Barau na ekiraḡiani veiḡana baḡana veia? ");
INSERT INTO snc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Korana ḡaḡitarito e ḡaseḡaḡirito dagarari tu ḡai na asi ilaila baḡa kira-ḡuniḡaurini e muruma maki moḡeri kiraḡi-kiraḡiri ai asi baḡa kourini riba.” ");
INSERT INTO snc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma ḡevaḡa-guruḡa gwaḡiḡirito murinai, ḡetuḡu-rosirito. Vaḡa-rakavari dabarana ta asi ḡedoḡariato, korana tarima mabarari na Barau ḡevaḡa-raḡeato-ḡoi, mo nuḡa-farevaḡi veiḡana lorinai. ");
INSERT INTO snc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Korana mo nuḡa-farevaḡi veiḡana na enamoto tarimana ḡena maḡuri laḡaniri tu gabana vasivasi (40) maki evanaḡiato. ");
INSERT INTO snc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petero e Ioane ḡetuḡu-vaḡirito murinai, karori ḡeri ai ḡeḡenoḡoi-iaḡoto. Ma Rubu Veaḡa vereri baregori e Iuda vereri na kara ḡekiravara-vinirito dagarari mabarari karori ḡeri ḡekiraḡirito. ");
INSERT INTO snc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Benamo karori na moḡeri guruḡa ḡeseḡaḡirito nai, ḡia mabarari Barau ḡeḡuriḡuri-vini vegogoato, ḡekirato, “Vereḡauka o, guba, tanobara, daḡaru-bara, ema nuḡari ai ḡetanuni dagarari mabarari ḡoi na oveirito. ");
INSERT INTO snc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iauka Veaḡa ḡenana, ḡai senema Davida, ḡoi ḡemu vetuḡunaḡi tarimana, muruna na oguruḡato nai ekirato, ‘Kara dainai irau bese tarimari tu ḡebaru-rakava rakavani? Ema karase nai tarimarima na tu asi beḡe ḡauveini boioḡari ḡeveirini? ");
INSERT INTO snc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tanobara vereri ḡeverovinato, ema veḡitaḡau tarimari baregori ḡeḡaru-vegogoto, Vereḡauka ma ḡena Keriso ḡesi beḡene vetari-viniri ḡana.’ ");
INSERT INTO snc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Moḡoni veḡata, Heroda e Pontio Pilato, irau bese tarimari e Isaraela tarimari ḡesi mai vanuḡa baregonai ḡevegogoto, ḡoi ḡemu vetuḡunaḡi tarimana veaḡana Iesu, ḡia tu ḡoi na oviriḡiato e Keriso ai ovaḡa-iaḡoato, ḡana boioḡa ḡetogato. ");
INSERT INTO snc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ḡia na ḡeveirito dagarari tu kara ḡoi na ḡemu seḡukai e urai oboioḡa-guinerito beḡene vetore otato dagarari moḡo. ");
INSERT INTO snc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Moḡa lorinai, Vereḡauka o, ḡeri vevaḡa-gari veiḡari noḡitari, ema ḡai ḡoi ḡemu vetuḡunaḡi tarimama kokore novinima, be ḡemu vari baḡana kiraḡia ma kokorema ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ḡimamu notuḡu-rosia, be keve tarimari bono vaḡa-namori, ema vetoḡa boruri e nuḡa-farevaḡi veiḡari bono veiri, Iesu, ḡoi ḡemu vetuḡunaḡi tarimana veaḡana aranai.” ");
INSERT INTO snc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ḡeḡauḡau-ḡosito murinai, ḡevegogoto numana eḡareva-ḡarevato. Benamo ḡia mabarari Iauka Veaḡa na ḡevonuto, benamo Barau ḡena vari ḡekiraḡiato ma kokoreri ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iesu ḡevaḡa-moḡoniato-ḡoi tarimari mabarari ḡeri tuḡamaḡi e nuḡari tu sebonai moḡo. Ta ḡena farefare ḡia ḡereḡana ḡena asi etato-ḡoi, senaḡi ḡeri dagara mabarari ḡia tata ḡevevarevare-vevinito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Seḡuka barego ḡesi apostolo tarimari na Iesu Vereḡauka ḡena variḡisi-ḡenoḡoi ḡevari-fiuato-ḡoi, ema Barau ḡena namo e varevare-bara ḡia mabarari iatari ai ebubu-riḡoato. ");
INSERT INTO snc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ḡia fakari ai ta maki asi erabuto-ḡoi. Korana ma ḡeri tano o numa tarimari na, moḡeri numa e tano ḡevoivoi-iaḡirito-ḡoi, benamo davari moniri tu ḡeḡwa-iaḡorito-ḡoi, ");
INSERT INTO snc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Apostolo ḡoirari ai ḡetore-taririto-ḡoi. Benamo mabarari ḡevini-ilailarito-ḡoi, tata ḡena rabu ilailanai. ");
INSERT INTO snc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iosefa tu apostolo na arana ḡevatoato Banabas, anina tu “Velaunaḡi Tarimana”. Ḡia tu Levi doḡorona, Saipras motumotunai emaḡurito. ");
INSERT INTO snc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ḡia ḡena tano evoiato, benamo voina monina tu eḡwa-iaḡoato, apostolo kwakuri koranai ea tore-tariato. ");
INSERT INTO snc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A tau ta etanuto-ḡoi arana Anania, ḡaraḡona arana tu Safira. Anania na ḡeri tano ta ea voivoi-iaḡiato, ḡaraḡona na maki eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Senaḡina mo tano monina kwana tu eḡabi-tariato, ma kwana reke ta moḡo eḡwa-iaḡoato apostolo ḡoirari ai ea tore-tariato. Mo veiḡa eveiato ḡaraḡona tu ma ribana. ");
INSERT INTO snc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Benamo Petero na ekiraiato, ekirato, “Anania, karase nai Satani na beboroḡimu, benamo Iauka Veaḡa boḡofaia, tano monina kwana tu ḡoi ḡemu boḡabi-taria? ");
INSERT INTO snc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Roḡosi boro voia nai tu, tano tu ḡoi ḡemu, ene? Ma beḡe voia murinai maki moni tu ḡoi ḡemu. Kara botuḡamaḡia nai, mai veiḡa bono veia bosi? Ḡoi na tu dia tarimarima boḡofari, senaḡi Barau boḡofaia.” ");
INSERT INTO snc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania na mo guruḡa eseḡaḡiato nai, eketo-tarito, emaseto. Benamo mo veiḡa eḡorato varina ḡeseḡaḡiato tarimari mabarari ḡegari-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Benamo tarima variḡuri ḡevariḡisito, Anania tauḡanina dabuḡa na ḡeseḡoato, ḡeḡwa-rosiato, benamo ḡea guriato. ");
INSERT INTO snc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hora toitoi kavana murinai, ḡaraḡona ema raka-toḡato, senaḡi ḡia kara eḡorato tu asi ribana. ");
INSERT INTO snc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero na edanaḡiato, ekirato, “Nokira-varagu, ḡomi taumi ruarua na tano monina boḡo ḡabia tu maiḡa moḡo ba?” Ḡia evaḡa-veseto, ekirato, “Oi, voina tu maniḡa moḡo.” ");
INSERT INTO snc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Benamo Petero na ekiraiato, ekirato, “Karase nai ḡoi ma ḡaraḡomu ḡesi nuḡami ḡovaḡa-sebonarito, Vereḡauka Iaukana ḡoḡofaiato? Noboḡe, ḡoi ḡaraḡomu beḡe guria tarimari tu ḡatama-bokai ḡeruḡa-taḡoni, ḡia na ḡoi maki ma ḡeḡwa-rosimuni.” ");
INSERT INTO snc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mo horai moḡo ḡia Petero kwakuna koranai eketo-tarito, emaseto. Benamo mo tarima variḡuri ḡeraka-toḡato, ma ḡeḡitaiato mase, benamo tauḡanina ḡeḡwa-rosiato, ḡaraḡona sevinai ḡea guriato. ");
INSERT INTO snc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekalesia mabarana e varina ḡeseḡaḡiato tarimari mabarari gari baregona na eḡabirito. ");
INSERT INTO snc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vetoḡa e veiḡa boruri ḡutuma apostolo na tarimarima ḡoirari ai ḡeveirito-ḡoi. Ma Iesu ḡevaḡa-moḡoniato-ḡoi tarimari mabarari tu “Solomona Ḡena Touraḡe” ai ḡevegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Asi veḡabidadama tarimari na ḡevaḡa-raḡerito-ḡoi, senaḡi ḡegarito-ḡoi, be ḡia ḡesi asi ḡea vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Senaḡi tau e vavine tu ḡutuma lelevaḡi na Vereḡauka ḡevaḡa-moḡoniato-ḡoi. Mo ḡevaḡa-moḡonito-ḡoi tauri e vavineri tu mabarari apostolo ḡeri doḡoro ai ḡerakaraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Apostolo na ḡeveirito-ḡoi veiḡari tarimarima na ḡeribarito, benamo keve tarimari ḡeḡwa-rosirito dabara ḡana, benamo genagena fatari ai e gedai ḡetorerito, Petero bene raka-vanaḡi nai, iouiouna na bene iauka-tariri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ema tarimarima ḡutuma-bara Ierusalema sevina vanuḡari na keve tarimari e iauka rakavari na ḡeboroḡirito tarimari ḡeḡwa-iaḡorito, benamo mabarari ḡenamoto. ");
INSERT INTO snc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Benamo Rubu Veaḡa verena baregona ma karona Sadukea doḡorona ḡesi, apostolo tarimari ḡeri ai ḡemama-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ḡia na apostolo tarimari ḡeḡabi-taririto, benamo dibura numai ḡebiri-ḡaurito. ");
INSERT INTO snc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Senaḡi mo boḡi Vereḡauka ḡena aneru na dibura numa ḡatama bokana erovoato, benamo apostolo eḡori-rosirito, benamo evaḡa-guruḡarito, ekirato, ");
INSERT INTO snc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ḡoiaḡo, Rubu Veaḡanai boḡono ruḡa, benamo mai maḡuri variḡuna mabarana tarimarima ḡeri boḡono kiraḡia.” ");
INSERT INTO snc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Boḡiboḡi iamo-iamonai Rubu Veaḡai ḡeraka-toḡato, aneru na ḡevaḡa-guruḡarito ilailanai tarimarima ḡevaḡa-ribarito. Rubu Veaḡa verena baregona ma karona ḡesi ḡeraḡasito, benamo kanisoro tarimari e Isaraela vereri mabarari ḡekea-vegogorito, benamo dibura numa ḡana ḡevetuḡu-iaḡoto, apostolo tarimari urari na. ");
INSERT INTO snc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Senaḡi vetuḡunaḡi tauri dibura numai ḡea raḡasito nai tu, apostolo tarimari asi ḡedoḡaririto. Benamo ḡeḡenoḡoito, ḡea kira-vararito, ḡekirato, ");
INSERT INTO snc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dibura numana ḡatama bokana tu biribiri, ema ḡitaḡau tarimari maki ruḡataḡo; senaḡi ḡatama-boka baḡa rovo-fakaia nai tu, apostolo ta tu asi baḡa ḡoitaḡoa.” ");
INSERT INTO snc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Rubu Veaḡa ḡitataḡona tarimana baregona e Rubu Veaḡa vereri baregori na mo guruḡa ḡeseḡaḡiato nai tu, ḡeiauvoiauvo-rakavato, asi ribari mo veiḡa anina tu kara. ");
INSERT INTO snc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ḡedaradarato-ḡoi nuḡanai tu, tarima ta eraka-toḡato, benamo ekirarito, ekirato, “Ḡoseḡaḡi! Dibura numai ḡobiri-ḡaurito tarimari tu Rubu Veaḡai ḡeruḡa-taḡoni, ma tarimarima ḡevaḡa-ribarini.” ");
INSERT INTO snc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Benamo Rubu Veaḡa ḡitaḡauna tarimana baregona ma ḡena mero ḡesi apostolo tarimari ḡea ḡori-ḡenoḡoirito. Asi ḡevei-guguraḡirito, korana tarimarima na fore na beḡe ḡidararini garina. ");
INSERT INTO snc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ḡeḡori-toḡarito, kanisoro ḡoiranai ḡevaḡa-ruḡarito, benamo Rubu Veaḡa verena baregona na edanaḡirito, ekirato, ");
INSERT INTO snc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ḡai na guruḡa gwaḡiḡina ḡavinimito, mai tarima aranai asi boḡono vevaḡa-riba, senaḡi ḡoḡitaia, ḡomi na kara boḡo veia! Ḡomi ḡemi vevaḡa-riba boḡo vaḡa-rega rovorovoa, benamo Ierusalema mabarana varau beḡaua, ema ḡomi ḡourani ḡia ḡena mase tu ḡai baḡana daḡa.” ");
INSERT INTO snc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero e apostolo kotari ḡevaḡa-veseto, ḡekirato, “Ḡai tu Barau ḡena ura baḡa korana-iaḡiani, dia tarimarima ḡeri ura. ");
INSERT INTO snc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iesu tu ḡomi na satauro tuḡunai ḡoikoko-kauato nai, ḡovaḡi-maseato, senaḡi ḡita tamara ḡeri Barau na ma evaḡa-variḡisi ḡenoḡoiato. ");
INSERT INTO snc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Barau na eḡabi-vaisiato, ḡia aroribanai evaḡa-ruḡaiato, Veḡitaḡau Verena e Vevaḡa-maḡuri Tarimanai evaḡa-iaḡoato. Isaraela tarimari bene vaḡa-vetuḡamaḡi-kureri, ema ḡeri rakava bene tuḡamaḡi-fitoḡari ḡana. ");
INSERT INTO snc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ḡai tu mai dagara kiraḡi-foforiri tarimama. Iauka Veaḡa na maki maiḡeri dagara ekiraḡi-foforirini. Mo Iauka Veaḡa tu Barau na ḡia ḡeseḡaḡi-viniani tarimari mabarari evinirito.” ");
INSERT INTO snc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kanisoro tarimari na mai guruḡa ḡeseḡaḡiato nai tu ḡebaru-rakavato, ma ḡeri ura mo apostolo tarimari tu ḡevaḡi-maseri moḡo. ");
INSERT INTO snc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Senaḡi ḡia fakari ai Farisea tarimana arana Gamaliel, taravatu evevaḡa-riba iaḡiato-ḡoi, ema tarimarima mabarari na ḡegubakauato-ḡoi tarimana, kanisoro nuḡari na eruḡa-vaisito. Benamo ekirato, moḡeri apostolo tarimari ḡeḡori-rosiri roḡo. ");
INSERT INTO snc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Benamo ḡia na kanisoro vegogona ekiraiato, ekirato, “Isaraela tarimami, maiḡeri tarima kamasi ḡoveiri ḡotoni ḡenai boḡono tuḡamaḡi-ginikau. ");
INSERT INTO snc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ḡaro kotari varau beḡe iaḡo, Teuda eruḡa-vaisito, evekiraḡito, ḡia tu tarima baregona ta, benamo tarima sinau vasivasi (400) kavana ḡia ḡesi ḡekauto. Senaḡi ḡia ḡevaḡi-maseato nai tu, ḡena tarimarima mabarari ḡeraga-rovorovoto; mo doḡoro toma tu asiḡina maia. ");
INSERT INTO snc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Moḡa murinai tu Iudas, Galilea tauna, tarimarima arari toretoreri o sensisi ḡabiḡabina ḡarori ai efoforito, ḡia maki ḡutuma-bara eḡori-kaurito, senaḡina ḡia maki ḡevaḡiato nai, ḡena tarimarima tu ḡeraga-rovorovoto. ");
INSERT INTO snc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Moḡa lorinai initoma veiḡanai, au na akiramini, mai tarima ḡoraga-kwaneri, ema ḡeri ai kara ta asi boḡono veia. Korana bema ḡeri boioḡa e ḡauvei maiḡeri tarimarima ḡerina eiaḡomani nai tu berekwa-rekwani. ");
INSERT INTO snc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Senaḡi bema mai tu Barau ḡenana eiaḡomani nai tu, ḡomi na maiḡeri tarima tu asi ilaila boḡo kourini bene. Asi namo Barau boḡo vetari-viniani!” Kanisoro na Gamaliel ḡeseḡaḡi-viniato. ");
INSERT INTO snc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Benamo apostolo ma ḡekea-toḡarito, ḡekwaririto, benamo ḡekirarito, Iesu aranai asiḡina ḡinavaḡi ma beḡene vevaḡa-riba ḡenoḡoi; benamo ḡetuḡu-rakarito. ");
INSERT INTO snc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolo na kanisoro vegogona ḡeraga-kwaneato ma iakuri ḡesi, korana Barau na eḡabi-hidirito, ḡia tu ilaila Iesu aranai maiaka beḡe ḡabiani bene. ");
INSERT INTO snc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Benamo ḡaro vanaḡivanaḡi ai Rubu Veaḡai e tarimarima ḡeri numa nuḡari ai Vari Namona ḡevevaḡa-ribato-ḡoi e ḡeḡobata-iaḡiato-ḡoi, ḡekirato-ḡoi, Iesu tu Keriso. ");
INSERT INTO snc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Moḡeri ḡaro ai Iesu ḡekorana-iaḡiato-ḡoi tarimari tu ḡeḡutuma-iaḡoto-ḡoi. Ma Iuda tarimari, Grik garo ai ḡeguruḡato-ḡoi tarimari, e Heberu garo ai ḡeguruḡato-ḡoi tarimari fakari ai veḡareveḡare eḡorato. Grik garo ai ḡeguruḡato-ḡoi tarimari ḡekirato, ḡia ḡeri vabu tu ḡaro tata ḡaniḡani ḡevareto-ḡoi nai tu ḡevaḡa-raburito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Moḡa lorinai apostolo gabanana ruarua (12) na Iesu ḡekorana-iaḡiato-ḡoi tarimari mabarari ḡekea-vegogorito, benamo ḡekirato, “Ḡai na ḡaniḡani varevarena uranai, Barau ḡena guruḡa asi baḡa vari-fiuani tu asi maoro. ");
INSERT INTO snc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Moḡa lorinai, tarikakagu mabarami, ḡomi vefakami ai tau imaima ruarua (7) ḡoḡabi-viriḡiri, variri namo tarimari, Iauka Veaḡa na e iaunega na ḡevonuto tarimari; benamo mai ḡauvei ḡia baḡana vini-vanaḡiri. ");
INSERT INTO snc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A ḡai tauḡema ḡema taimi mabaranai tu ḡauḡau e ḡobatai baḡana torea.” ");
INSERT INTO snc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Apostolo tarimari ḡeri boioḡa ḡia mabarari na ḡeiaku-iaḡiato. Benamo ḡia na mai tau maiḡeri ḡeḡabirito: Stefano, veḡabidadama na e Iauka Veaḡa na evonuto tarimana; e Filipo; Prokoro; Nikanoro; Timon; Pamena; e Nikolas, Antioka tarimana senaḡi Iuda tarimari ḡeri toma-rakariḡo ekorana-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ḡia na mai tau maiḡeri apostolo ḡoirari ai ḡevaḡa-ruḡarito, benamo apostolo na ḡia iatari ai ḡeḡuriḡurito ema apostolo ḡimari ḡia iatari ai ḡetore-kaurito. ");
INSERT INTO snc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Benamo Barau ḡena guruḡa eraga-rovorovoto. Ema Iesu korana-iaḡina tarimari Ierusalemai ḡevovoka-ḡarimoḡito, ema Rubu Veaḡa vereri ḡutuma gorogoro na maki Barau ḡena guruḡa ḡeḡabi-raḡeato, benamo ḡeveḡabidadamato. ");
INSERT INTO snc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano tu Barau ḡena varevare-bara e seḡuka na evonuto tarimana, ḡia na nuḡa-farevaḡi veiḡari boruri baregori tarimarima ḡoirari ai eveirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Senaḡi vekira-fitoḡa barego evariḡisito. Iuda tarimari ḡeri rubu doḡorona ta ḡekiraḡirito-ḡoi “Ruḡavaḡi tarimari”. Ḡia ema Iuda tarimari, Kurene e Alesandria na ema Kilikia e Asia tanobara na ḡeiaḡomato tarimari, Stefano ḡesi ḡeveḡare-veḡareto. ");
INSERT INTO snc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Senaḡi Stefano ḡena guruḡa tu asi ḡelautariato-ḡoi, korana ḡia tu Iauka Veaḡa na eviniato-ḡoi iauneganai eguruḡato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Benamo ḡia na tarima kotari nuḡari ḡeḡanirito beḡene kira, “Ḡai na Stefano ḡaseḡaḡiato, ḡia na Mose e Barau ekira-fitoḡarito.” ");
INSERT INTO snc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mo dabarai ḡia na tarimarima, e Iuda vereri, ema taravatu ḡevevaḡa-riba iaḡiato-ḡoi tarimari ḡekira-vaisivaisirito. Ḡia Stefano ḡenai ḡeiaḡoto, ḡea ḡabi-tariato, benamo Iuda ḡeri kanisoro ḡoirana ḡana ḡeḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Monai beḡene ḡofaḡofa ḡana vevaḡa-bade tarimari kotari ḡeḡori-toḡarito, benamo ḡekirato, “Mai tarima na tu ḡaro mabarari ai ḡita ḡera Rubu Veaḡana e Mose ḡena taravatu ekira-fitoḡarini. ");
INSERT INTO snc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ḡai na ḡaseḡaḡiato, ekirato, ‘Iesu, Nasareta tarimana, na mai Rubu Veaḡana bevaḡa-rakavaiani, ema Mose na evinirato veiḡari mabarari bevaḡa-iraurini.’” ");
INSERT INTO snc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kanisoro ai ḡevegogo-taḡoto-ḡoi tarimari mabarari na Stefano ḡeḡita-karakaraiato, ema ḡoirana ḡeḡitaiato tu noḡa moḡo aneru ta ḡoirana. ");
INSERT INTO snc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Benamo Rubu Veaḡa verena baregona na Stefano edanaḡiato, ekirato, “Maiḡeri guruḡa tu moḡoni ba?” ");
INSERT INTO snc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano na evaḡa-veserito, ekirato, “Tarikakagu e tamagu mabarami, au ḡoseḡaḡigu! Ḡita senera Aberahamo Haran vanuḡanai roḡosi roḡo berea tanu nai, mareva barego Barauna ḡia ḡenai efoforito Mesopotamia ai, ");
INSERT INTO snc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","benamo ḡia ekiraiato, ekirato, ‘Ḡemu bese e tanobara noiaḡuia, benamo au na bavaḡa-ḡitamuni tanobarana ḡana bono iaḡo.’ ");
INSERT INTO snc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Benamo ḡia na Kaldea tanobarana eraga-kwaneato, benamo Haran ai ea vanuḡato. Ma tamana emaseto murinai, Barau na etuḡu-iaḡomaiato initoma ḡotanu-iaḡiani tanobarana ḡana. ");
INSERT INTO snc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A Barau na Aberahamo tu ḡena tano misina kota maki asi eviniato. Kwaku vaḡa-ruḡatarina gabuna ilailanai misina kota maki asi eviniato. Senaḡi Barau eguruḡa-toreto ḡia na tano ta beviniani, ḡia e ḡia murina na beḡe ḡorani tarimari na tano ta beḡe ḡaunaiani ḡia ḡeri. Mo ḡaro ai Aberahamo tu asi natuna. ");
INSERT INTO snc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Barau na ma evaḡa-guruḡaiato, ekirato, ‘Ḡoi ḡemuna beḡe ḡorani beseri tu tano boruna tai beḡe tanuni. Ma laḡani sinau vasivasi (400) mo gabu tarimari ḡeri vetuḡunaḡi tarimari ai beḡe vaḡa-iaḡorini e beḡe vaḡa-midigu midigurini.’ ");
INSERT INTO snc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Barau ma ekirato, ‘Isaraela tarimari na vetuḡunaḡiri ḡeiaḡo-vinini beseri tu au na bavevaḡa-maoro vinirini, moḡa murinai ḡia tu mo tano na beḡe raka-rosini, mai gabu ai au beḡema toma-rakariḡo viniguni.’ ");
INSERT INTO snc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Benamo Barau na Aberahamo kefi-lamavaḡi veiḡana eviniato, mo tu ḡia ḡena kiraḡitore vetoḡana. Benamo Aberahamo na Isako evaḡa-ḡoraiato, ma ḡaro vaḡa-imaima toitoina (8) murinai tauḡanina kefina elama-vaḡiato. Moḡa murinai Isako na Iakobo evaḡa-ḡoraiato, ma Iakobo na ḡera doḡoro ḡedebarini tarimari gabanana ruarua (12) evaḡa-ḡorarito. ");
INSERT INTO snc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Doḡoro debari tarimari Iosefa ḡenai ḡemamato, benamo Aigupito tarimari ḡeri ai ḡevoivoi-iaḡiato. Senaḡina Barau tu Iosefa ḡesi, ");
INSERT INTO snc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ema ḡena dabara doko mabarari ḡerina evaḡa-maḡuriato. Barau na Iosefa iaunega eviniato, ema Pharao, Aigupito verena, nuḡana evaḡa-namoato Iosefa ḡenai, benamo Pharao na eura-viniato ema seḡuka eviniato, Aigupito tanona ema ḡia ḡena numa tarimari e farefareri bene ḡita-ḡauri. ");
INSERT INTO snc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Benamo Aigupito tanona mabarana ema Kanana tanona mabaranai doḡe ḡeḡorato, monana vito e nanu mase baregona evaḡa-ḡoraiato, benamo ḡita senera tu asi ḡeri ḡaniḡani doḡari dabarana. ");
INSERT INTO snc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Senaḡina Iakobo eseḡaḡito Aigupito tu ma widina, benamo ḡia na ḡita senera etuḡu-iaḡorito, mo tu ḡia ḡeri iaḡoiaḡo giniguinena. ");
INSERT INTO snc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma ḡeri iaḡoiaḡo vaḡa-ruaruanai Iosefa tauḡena kakana e tarina ekira-vararito ḡia tu deikara, benamo Pharao na Iosefa ḡena bese eribaiato. ");
INSERT INTO snc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Moḡa murinai Iosefa evetuḡuto, tamana Iakobo ma ḡena bese ḡeri ai Aigupito ḡana beḡene iaḡoma ḡana. Iakobo besena Kananai tu mabarana gabana imaima ma gabana ruarua imaima (75). ");
INSERT INTO snc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Benamo Iakobo Aigupito ḡana evariḡoto, monai ḡia e ḡita senera ḡemaseto. ");
INSERT INTO snc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ḡia tauḡaniri tu Sekem ḡana ḡeḡwa-ḡenoḡoi iaḡorito, benamo monai ḡea guririto. Mo gara gabuna tu Aberahamo na Hamora naturi ḡerina moni na evoiato. ");
INSERT INTO snc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Barau na ḡena kiraḡitore Aberahamo ḡenai bevaḡa-moḡoniani ḡarona ekavinaḡito-ḡoi nai tu, ḡita ḡera tarimarima Aigupito ai ḡeḡutuma-gorogoroto. ");
INSERT INTO snc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ma moḡa murinai tu vere ta na Aigupito eḡita-ḡauato. Mo vere moḡa tu asi ribana Iosefa. ");
INSERT INTO snc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ḡia na ḡita senera eḡofarito-ḡoi e evaḡa-midigu midigurito-ḡoi, ema ekirarito-ḡoi, naturi raraka-rarakari ḡeri numa na beḡene tore-rosiri, beḡene mase ḡana. ");
INSERT INTO snc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mo negai Mose emaḡurito. Ma Mose eḡorato nai, marevana tu namo vedaurea. Ma ḡia tu ḡue toitoi tamana ḡena numai ḡenariato, ");
INSERT INTO snc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","benamo numa na ḡetore-rosiato nai tu, Pharao natuna ḡuiatona na eḡabiato, benamo natunai evaḡa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose tu Aigupito ḡeri riba e iaunega mabarana ḡevaḡa-ribaiato, ema ḡena guruḡa e veiḡa ma seḡukari tarimanai eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ma ḡena maḡuri laḡanina gabana vasivasi (40) eḡabiato, benamo karona Isaraela tarimari nea raka-ḡitari etato. ");
INSERT INTO snc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ḡia na Aigupito tarimana ta eḡitaiato, Isaraela tarimana ekwariato-ḡoi, benamo ḡia eiaḡoto gogobana eragato, benamo mo Aigupito tarimana evaḡi-maseato. ");
INSERT INTO snc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose mataboru ekirato tu ḡena tarimarima beḡe tuḡamaḡi-fakani, ḡia ḡenana Barau na Isaraela tarimari bevaḡa-maḡuririni, senaḡi moḡa Isaraela tarimari na tu asi ḡeriba-maoroato. ");
INSERT INTO snc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ma elaḡanito nai, ḡia na Isaraela tarimari ruarua eḡitarito ḡevevaḡito-ḡoi, benamo nevaḡa-mainori ḡana ekirarito, ekirato, ‘Ḡomi tau ruarua, ḡoseḡaḡi, ḡomi tu tarikaka moḡo ruarua, ma kara dainai tu taumi ruarua ḡovevaḡini?’ ");
INSERT INTO snc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Senaḡi vevaḡi ekoraiato tarimana na Mose edori-veḡitaiato, benamo ekirato, ‘Ḡoi tu deikara na ḡai ḡema vere ema toto-iobukaiobuka tarimanai evaḡa-iaḡomuto? ");
INSERT INTO snc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ḡoi ourani tu ḡoraḡani Aigupito tarimana ovaḡi-maseato kavana au novaḡi-masegu otoni?’ ");
INSERT INTO snc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose na mo guruḡa eseḡaḡiato, benamo eraga-kwareḡato, Midian ḡana egari-rakato. Monai etanuto-ḡoi nuḡanai natuna ruarua ḡemaḡurito. ");
INSERT INTO snc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Laḡani gabana vasivasi (40) ḡekorito murinai, aneru ta tano fakanai Sinai Ḡorona sevinai Mose ḡenai efoforito. Mo aneru tu ḡau ruguruguna ḡenai karava morenai eiaḡoto, benamo Mose ḡenai efoforito. ");
INSERT INTO snc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose na moḡa eḡitaiato nai, eḡabato; benamo nea ḡita-ginikaua ḡana eraka-kavinaḡi iaḡoto-ḡoi nuḡanai, Vereḡauka garona eseḡaḡiato, maiḡesi ekirato, ");
INSERT INTO snc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Au tu ḡoi senemu Aberahamo, Isako, e Iakobo ḡeri Barau.’ Mose egari-rakavato, benamo asi eurato ma bene boḡe-iaḡo ḡenoḡoi. ");
INSERT INTO snc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Barau na evaḡa-guruḡaiato, ekirato, ‘Ḡemu tamaka kwakumu na novei-vaḡiri, korana mani oruḡa-taḡoni gabuna tu tano veaḡana. ");
INSERT INTO snc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Moḡoni, au ḡegu tarimarima Aigupito ai ḡevaḡa-midigu midigurini tu baḡitari ema ḡeri midigumidigu ḡabana guruna baseḡaḡiri nai, au bamariḡo tu navaḡa-maḡuriri ḡana. Toma noiaḡoma, au na ḡoi tu Aigupito ḡana atuḡu-ḡenoḡoimuni.’ ");
INSERT INTO snc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mai Mose tu Isaraela tarimari na ḡeruḡaiato tarimana. Maiḡesi ḡekirato, ‘Ḡoi tu deikara na ḡai ḡema vere e toto-iobukaiobuka tarimanai evaḡa-iaḡomuto?’ Mai tarima sebona moḡo tu Barau na etuḡuato bene vere e bene vevaḡa-maḡuri. Ema ḡia na maki ḡau rugurugunai karava moreri ai efoforito aneruna ḡenana evaḡa-kavaiato. ");
INSERT INTO snc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ḡia na Isaraela tarimari Aigupito na eḡori-rosirito nai, nuḡa-farevaḡi veiḡari e vetoḡa boruri eveirito-ḡoi, Aigupito nuḡanai e Davara Kakakakanai ema tanobara fakanai laḡani gabana vasivasi (40). ");
INSERT INTO snc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mai Mose sebona na Isaraela tarimari ekirarito, ekirato, ‘Barau na ḡemi peroveta tarimana ta betuḡuani, au etuḡuguto kavana. Mo peroveta tu ḡomi ḡemi tarimarima ta.’ ");
INSERT INTO snc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ḡia tu Isaraela tarimari ḡeri vegogo nuḡanai tano fakanai ḡita senera ema Sinai Ḡoronai evaḡa-guruḡaiato aneruna ḡesi monai. Ḡia na Barau ḡena maḡuri guruḡana Barau ḡenana eḡabiato, ḡita ma bene vaḡa-ribara ḡana. ");
INSERT INTO snc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Senaḡina ḡita senera asi ḡeurato ḡena guruḡa beḡene ḡabi-raḡea, ema ḡia ḡekira-fitoḡaiato ema nuḡari ai ḡeri ura tu Aigupito ḡana ma ḡeḡenoḡoi. ");
INSERT INTO snc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ḡia na Arona ḡekiraiato, ḡekirato, ‘Ḡita ḡera barau tari noveiri, ḡita ḡoirarai beḡene raka ḡana. Korana mai Mose ḡita Aigupito na eḡori-rosirato tarimana tu ḡita asi ribara kamasi ta bevei bene.’ ");
INSERT INTO snc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mo ḡaro ai ḡia na boromakau natuna kavana kwaivakukuna ḡeveiato. Benamo mo kwaivakuku ḡoiranai ginitaḡo dagarari ḡea toreto ema ḡeḡani-verekoto. Tauḡeri ḡimari na ḡeveiato dagarana ḡeverere-viniato. ");
INSERT INTO snc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Benamo Barau eraka-veḡitato, ma Isaraela tarimari evini-iaḡorito, guba visiḡuri beḡene toma-rakariḡo viniri ḡana. Mo tu peroveta tarimari ḡeri bukai ḡetoreato ilailanai, ekirani, ‘Isaraela tarimami! Laḡani gabana vasivasi (40) tano fakanai ḡovaḡirito-ḡoi mamoeri, boromakauri, e ginitaḡo dagarari tu dia au ḡegu. ");
INSERT INTO snc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mo tu kwaivakuku barauna Molok ḡena farai rubuna, ema ḡemi barau Refan ḡena visiḡu iouiouna ḡoḡwaiato-ḡoi; moḡeri kwaivakuku tu ḡomi na ḡoveirito, boḡono toma-rakariḡo viniri ḡana. Moḡa lorinai au na ḡomi batuḡu-rakamini Babulona mo rekena ḡana.’ ");
INSERT INTO snc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ḡita senera tanobara fakanai ḡetanuto-ḡoi nai tu, farai rubuna maki ḡia ḡesi. Mo farai rubuna Barau na ḡena guruḡa moḡoniri evaḡa-foforirito-ḡoi. Mo farai rubuna ḡeragaiato tu Barau na Mose ekira-varaiato lorinai, ema Mose na farai rubuna vetoḡana eḡitaiato ilailanai moḡo ḡeveiato. ");
INSERT INTO snc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Moḡa murinai ḡita senera na mo farai rubuna tamari ḡerina ḡeḡabiato, benamo Iosefa ḡena veḡorikau neganai ḡeḡwakau-iaḡoato irau bese tarimari tu ḡita senera ḡoirari ai Barau na ḡeri tano na elai-veḡitarito. Mo farai rubuna monai etanuto mo, Davida ḡena nega. ");
INSERT INTO snc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davida na Barau ḡena vevaḡa-namo eḡabiato, ema enoḡinoḡito, monai Iakobo ḡena Barau ḡena tanu numana bene ragaia etato. ");
INSERT INTO snc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Senaḡina Solomona na vau ḡena numa eragaiato. ");
INSERT INTO snc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Senaḡi Iaru-korokoro Barauna tu tarimarima ḡimari na ḡeragarini numari ai tu asi etanuni, peroveta tarimana ekirani kavana, ");
INSERT INTO snc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Vereḡauka ekirani, “Guba tu au ḡegu terona, ema tanobara tu au kwakugu vaḡa-ruḡatarina gabuna. Be, au ḡegu numa tu kamasi-kamasi na boḡo ragaiani? Au ḡegu iaḡaraḡi gabuna tu aiḡa? ");
INSERT INTO snc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Maiḡeri dagara mabarari au ḡimagu na asi aveirito, ei?” ’ ");
INSERT INTO snc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefano ma eguruḡato, ekirato, “Kira-ḡuiraḡi tarimami! Ḡomi nuḡami e seḡami tu Barau asi ḡeura-viniani tarimari kavari. Ḡomi tu senemi ḡeveito-ḡoi kavari ḡoveini, vanaḡivanaḡi Iauka Veaḡa ḡolai-veḡitaiani! ");
INSERT INTO snc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kamara peroveta tu ḡomi senemi na asi ḡevaḡa-midigu midiguato? Ḡia na tu Vei-iobukaiobuka Tarimana ḡena iaḡoma ḡekiraḡi-fofori guineato tarimari tu ḡevaḡi-maserito. Ma toma ḡomi na tu Iesu boḡo revaia e boḡo vaḡi-debaia. ");
INSERT INTO snc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Barau ḡena taravatu aneru na ḡeḡwa-mariḡoato tu ḡomi na ḡoḡabiato, senaḡina asi ḡokorana-iaḡiato.” ");
INSERT INTO snc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ḡia na mo guruḡa ḡeseḡaḡiato nai, ḡebaru-rakavato, gadikari maki ḡeḡara-taririto Stefano ḡenai. ");
INSERT INTO snc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Senaḡi Stefano tu Iauka Veaḡa na evaḡa-vonuato, egaga-raḡeto guba ḡana, benamo gubai Barau marevana baregona eḡitaiato, ema Iesu eḡitaiato Barau aroribanai ruḡataḡo. ");
INSERT INTO snc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Benamo ekirato, “Ḡoboḡe! Guba bevekeo-faka aḡitaiani, ema Tarimarima Natuna tu Barau aroribanai eruḡa-taḡoni!” ");
INSERT INTO snc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mo guruḡa ḡeseḡaḡiato nai tu, ḡimari na seḡari ḡekou-ḡaurito vau ḡefararato. Benamo mabarari vaḡa-sebo ḡia ḡeraga-viniato, ");
INSERT INTO snc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ḡeḡabiato, benamo siti murina ḡana ḡeinu-rosiato, benamo fore na ḡeḡidaraiato. Ma vaḡa-moḡoni tarimari ḡeri dabuḡa tu futua ta arana Saulo, ḡia kwakuna koranai ḡetorerito. ");
INSERT INTO snc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ḡeḡidaraiato-ḡoi nuḡanai, Stefano eḡuriḡurito, ekirato, “Iesu Vereḡauka o, au iaukagu noḡabi-raḡea.” ");
INSERT INTO snc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Evetui-tarito, benamo ma taḡina ḡesi ekea-raḡeto, ekirato, “Vereḡauka o, ḡeri veiḡa rakavana maiḡa voina asi bono viniri.” Moḡesi eguruḡato, benamo emaseto. ");
INSERT INTO snc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo na Stefano vaḡimasena tu eḡabi-raḡeato. Mo ḡaro ai Ierusalema nuḡanai ekalesia vaḡa-midigumidiguna e lai-lausilausina baregona evesinato. Veḡabidadama tarimari mabarari ḡeraga-rovorovoto, Iudea e Samaria tanori mabarari ḡana ḡeiaḡoto, senaḡi apostolo tarimari ḡereḡari moḡo ḡeraga-kwanerito. ");
INSERT INTO snc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Barau korana-iaḡina tarimari kotari na Stefano taḡina ḡevei-rakavato e ma taḡiri ḡesi ḡekeuato, benamo ḡea guriato. ");
INSERT INTO snc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Senaḡina Saulo na tu ekalesia nevaḡa-rakava korikoria etato. Numa tata nuḡari ai eraka-toḡato-ḡoi, benamo veḡabidadama tauri e vavineri einu-rosirito-ḡoi, ma eḡabi-iaḡorito-ḡoi dibura numai ea biri-ḡaurito. ");
INSERT INTO snc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ḡevaḡa-karovorito tarimari tu ḡeiaḡoto gaburi ai Barau ḡena guruḡa ḡea ḡobata-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo tu Samaria vanuḡana baregona ḡana eiaḡoto, monai Keriso varina ea fiuato. ");
INSERT INTO snc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ḡutuma na Filipo ḡena guruḡa ḡeseḡaḡiato ema nuḡa-farevaḡi veiḡari eveirito ḡeḡitarito nai, ḡia mabarari na ḡeseḡaḡi-vini magomagoato. ");
INSERT INTO snc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Iauka rakavari tarimarima ḡutuma ḡerina ma ḡabari ḡesi ḡeraka-vaḡito, ema tauḡaniri tavi tari ḡemaseto tarimari e kwaku rakava tarimari ḡutuma ḡenamoto. ");
INSERT INTO snc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Moḡa lorinai mo Samaria vanuḡana nuḡanai iaku baregona eḡorato. ");
INSERT INTO snc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mo vanuḡai tarima ta etanuto-ḡoi arana tu Simona. Guinenai ḡena meḡameḡa e ḡora veiḡari na Samaria tarimari evaḡa-ḡaba rakavarito-ḡoi. Tauḡena evekiraḡito-ḡoi, ḡia tu varaḡe rakava, ");
INSERT INTO snc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ema tarimarima mabarari mo vanuḡa nuḡanai misina na beiaḡo mo baregona na ḡeseḡaḡi-viniato-ḡoi, ema ḡekirato-ḡoi, “Mai tarima tu mo Barau ḡenana eiaḡomato seḡukana ḡekiraḡiani ‘Seḡuka Baregona’.” ");
INSERT INTO snc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ḡia ḡeseḡaḡi-viniato, korana ḡaro barego vedaurea ḡia ḡena meḡameḡa veiḡari na evaḡa-ḡabarito. ");
INSERT INTO snc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Senaḡi Filipo na Barau ḡena Basileia, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa), Varina Namona e Iesu Keriso arana varina eḡobata-vinirito nai, tau e vavine na ḡevaḡa-moḡoniato, benamo ebabatisorito. ");
INSERT INTO snc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona na maki evaḡa-moḡoniato, benamo babatiso eḡabiato. Moḡa murinai Simona na Filipo ekaferi-kaferiato, ma Filipo na seḡuka veiḡari baregori e vetoḡa boruri eveirito-ḡoi nai, eḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostolo tarimari Ierusalemai ḡetanuto-ḡoi ḡeseḡaḡito, Samaria tarimari na tu varau Barau ḡena guruḡa ḡeḡabi-raḡeato, benamo Petero e Ioane ḡetuḡu-iaḡorito Samaria ḡana. ");
INSERT INTO snc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tauri ruarua ḡeraḡasito nai tu, veḡabidadama tarimari iatari ai ḡeḡauḡauto, Iauka Veaḡa beḡene ḡabia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Korana Iauka Veaḡa ḡia ta iatari ai tu roḡosi roḡo bere raka-riḡo. Ḡia tu Iesu Vereḡauka aranai moḡo babatiso ḡeḡabiato. ");
INSERT INTO snc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petero e Ioane ḡimari ḡia iatari ai ḡeveḡabikauto, benamo ḡia na Iauka Veaḡa ḡeḡabiato. ");
INSERT INTO snc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simona na apostolo tarimari eḡitarito, ḡimari ḡetore-kaurito vau Iauka Veaḡa ḡeḡabiato, benamo ḡia na moni Petero e Ioane eduḡi-vinirito, ekirato, ");
INSERT INTO snc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Au maki mani seḡuka ḡovinigu, be ḡimagu ta iatanai bana tore-kaua nai, Iauka Veaḡa bene ḡabia.” ");
INSERT INTO snc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Senaḡi Petero na ekiraiato, ekirato, “Ḡoi ma ḡemu moni ḡesi karava gabuna ḡana ḡoiaḡo, korana otuḡamaḡini Barau ḡena varevare tu moni na bovoiani! ");
INSERT INTO snc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mai ḡauvei ai ḡoi tu asi ḡemu gabu, korana nuḡamu tu asi roroḡoto Barau ḡoiranai. ");
INSERT INTO snc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mai ḡemu ura rakavana ḡenana novetuḡamaḡi-kure, benamo Vereḡauka nonoḡia, betaḡu ḡia na maniḡesi tuḡamaḡi ḡeḡevana oḡabiani nuḡamu ai maniḡa betuḡamaḡi-fitoḡaiani. ");
INSERT INTO snc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Korana aḡitamuni, ḡoi tu nuḡa-ḡirimaḡirima na ovonuto, ema rakava na ebaru-bubuḡaumuto.” ");
INSERT INTO snc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Benamo Simona na Petero evaḡa-veseato, ekirato, “Mani ḡemi veiḡa, au iatagu ai Vereḡauka nonoḡia, be mani bokiraḡiri dagarari ta au ḡegu ai asi bene ḡora.” ");
INSERT INTO snc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero e Ioane na Vereḡauka ḡena guruḡa ḡekiraḡi-foforiato e ḡevari-fiuato murinai, Ierusalema ḡana ḡeḡenoḡoito. Ḡeri ḡenoḡoi ai Samaria vanuḡari vovokari Vari Namona ḡeḡobata-iaḡiato. ");
INSERT INTO snc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Vereḡauka ḡena aneru ta na Filipo evaḡa-guruḡaiato, ekirato, “Novariḡisi, gabina (o south) rekena ḡana noiaḡo, bono iaḡo mo, Ierusalema na Gasa ḡana ḡeiaḡoni dabarana ḡana. Mo tu tano fakana dabarana, tarima ta asi etanuni.” ");
INSERT INTO snc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Benamo evariḡisito, eiaḡoto. Eiaḡoto-ḡoi nuḡanai, Itiopia tarimana ta, dagi baregona tarimana, tu ḡena vanuḡa ḡana eḡenoḡoito-ḡoi. Ḡia tu Itiopia ḡitaḡauna vavinena baregona ḡena farefare eḡitaḡaurito-ḡoi tarimana baregona. Ḡia tu eunuko, (seuri ḡefararito tarimana). Ḡia Ierusalema ḡana eiaḡoto tu, Barau benea toma-rakariḡo vinia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ḡena ḡenoḡoi ai kariota iatanai etanukauto vau, Isaia peroveta tarimana ḡena buka eiavi-iaḡoato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Benamo Iauka Veaḡa na Filipo evaḡa-guruḡaiato, ekirato, “Noiaḡo, mo kariota sevinai bonoa raka.” ");
INSERT INTO snc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Benamo Filipo kariota sevina ḡana eraga-iaḡoto, benamo mo tarima eseḡaḡiato, Isaia peroveta tarimana ḡena buka eiaviato-ḡoi. Benamo ekirato, “Mani guruḡa oiaviani anina ma ribamu ba?” ");
INSERT INTO snc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ḡia evaḡa-veseto, ekirato, “Au tu kamasi baribani. Mai tu tarima ta na bekira-varaguni vau bariba-maoroni.” Benamo Filipo ekiraiato, ekirato, “Kariotai noma raḡekau, be sevigu ai noma tanu.” ");
INSERT INTO snc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ḡia na buka nuḡanai eiaviato-ḡoi toretorena tu maiḡa, “Ḡia tu mamoe kavana ḡeḡori-iaḡoato, beḡene vaḡi-masea ḡana; ema ḡia tu mamoe natuna kavana ḡuiri ḡefakosi-vaḡirini nai tu, mururi asi ḡekeorini, moḡesina kavana ḡia maki muruna asi ekeoato. ");
INSERT INTO snc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ḡetore-riḡoato e ḡena Kota dabarana ḡekouato. Ḡena bese tarimari tu dei na bekiraḡirini? Korana ḡena maḡuri tanobarai tu bema kori.” ");
INSERT INTO snc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuko tauna na Filipo enoḡiato, ekirato, “Nokira-varagu, mai peroveta tarimana na tu deikara moḡesi ekiraḡiato? Ḡia tauḡena evekiraḡito ba ta ekiraḡiato?” ");
INSERT INTO snc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Benamo Filipo na mo toretore ḡenana ḡena guruḡa esinaiato, ema Iesu Varina Namona evaḡa-ribaiato. ");
INSERT INTO snc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mo dabara na ḡeiaḡoto nuḡanai, nanu gabuna tai ḡeraḡasito. Benamo mo eunuko tauna na Filipo ekiraiato, ekirato, “Noboḡe, nanu tu maiḡa, kara na au babatisogu elau-ḡauani?” ");
INSERT INTO snc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37"," Benamo Filipo ekirato, “Bema nuḡamu mabarana ḡesi ovaḡa-moḡoniani nai tu ba-babatisomuni.” Ḡia evaḡa-veseto, ekirato, “Oi, nuḡagu mabarana ḡesi avaḡa-moḡoniani Iesu Keriso tu Barau Natuna.” ");
INSERT INTO snc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Benamo ḡena draiva ekiraiato, kariota nevaḡa-ruḡataria, benamo kariota eruḡa-tarito. Filipo e eunuko tauri ruarua nanu ai ḡeraka-riḡoto, benamo Filipo na eunuko tarimana ebabatisoato. ");
INSERT INTO snc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tauri ruarua nanu na ḡeraḡekauto-ḡoi nai, Vereḡauka Iaukana na Filipo tu eḡabi-veḡitaiato. Eunuko tarimana na asi ma eḡitaiato, senaḡi ḡena iaḡoiaḡo dabara na eiaḡoto-ḡoi roḡo ma iakuna ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo tu Asoto ai ma ea foforito. Monai vanuḡa mabarari ḡari eiaḡoto, Vari Namona ea ḡobata-iaḡiato-ḡoi, eiaḡoto mo Kaisarea ai eraḡasito. ");
INSERT INTO snc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo roḡo Vereḡauka ḡekorana-iaḡiato-ḡoi tarimari vaḡa-rakavari e vaḡi-maseri guruḡari evei-gwadato-ḡoi ma baruna ḡesi. Benamo eiaḡoto Rubu Veaḡa verena baregona ḡenai, ");
INSERT INTO snc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","enoḡiato, vevaḡa-riba fefana bene torea, Damaseko ai Iuda tarimari ḡeri rubu bene viniri ḡana. Be, Iesu ḡekorana-iaḡiani tauri e vavineri monai bene doḡariri nai tu bene barubaruri, benamo Ierusalema ḡana bene ḡori-ḡenoḡoi iaḡomari. ");
INSERT INTO snc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Benamo Saulo na Ierusalema eiaḡuiato ma Damaseko ḡana eiaḡoto. Damaseko vanuḡa ekavinaḡiato nuḡanai, asikauna mama ta guba na emoreto, ḡia enanagi-tariato. ");
INSERT INTO snc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Benamo ḡia tano ai eketo-tarito, ma garo ta eseḡaḡiato, ekirato, “Saulo, Saulo! Kara dainai au ovaḡa-midigu midiguguni e olaiguni?” ");
INSERT INTO snc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ḡia evedanaḡito, ekirato, “Vereḡauka, ḡoi tu deikara ei?” Mo garo evaḡa-veseto, ekirato, “Au tu Iesu, ḡoi na au ovaḡa-rakavaguni tarimagu. ");
INSERT INTO snc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Senaḡi novariḡisi, vanuḡa baregonai noa raka-toḡa, monai vau tarima ta na bekiramuni kara ma bono vei.” ");
INSERT INTO snc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ḡia ḡekavaiato tarimari mabarari ḡeruḡa-tarito, asi ḡeguruḡato, korana garo tu ḡeseḡaḡiato, a tarimana tu asi ḡeḡitaiato. ");
INSERT INTO snc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo tano na evariḡisito, matana eiaḡaiato nai tu, dagara ta asi eḡitaiato. Benamo karona na ḡimanai ḡeḡabito, Damaseko ḡana ḡeḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ḡaro toitoi veḡata matana ebubuto asi eboḡeboḡeto, ema asi eḡaniḡanito e nanu o dagara ta asi eniuato. ");
INSERT INTO snc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaseko ai Iesu ekorana-iaḡiato-ḡoi tarimana ta arana Anania, mata-vanaḡi ai Vereḡauka na evaḡa-guruḡaiato, ekirato, “Anania!” Ḡia evaḡa-veseto, ekirato, “Ou! Vereḡauka, au maiḡegu.” ");
INSERT INTO snc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Vereḡauka na evaḡa-guruḡaiato, ekirato, “Novariḡisi, be dabara ta arana Roroḡoto Dabarana na noiaḡo. Bono iaḡo Iudas ḡena numa nuḡanai, Taso tarimana ta arana Saulo bonoa vedanaḡi-iaḡia, korana ḡia tu monai moḡa eḡuri-ḡurini. ");
INSERT INTO snc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ḡia na mata-vanaḡi ai tarima ta arana Anania beḡitaia, beraka-toḡa, ḡimana ḡia iatanai betore-kauri, matana bene fafa ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania evaḡa-veseto, ekirato, “Vereḡauka, tarima ḡutuma na ḡegu ḡekiraḡito, mai tau na Ierusalemai ḡoi ḡemu tarimarima veaḡari tu veiḡa rakava kwaikwairi evei-vinirini. ");
INSERT INTO snc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ema Damaseko ḡana beiaḡoma tu Rubu Veaḡa vereri baregori na maoro ḡeviniato, ḡoi aramu ḡevaḡa-raḡeani tarimari mabarari bene barubaruri e dibura numai bene toreri ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Senaḡina Vereḡauka na ekiraiato, ekirato, “Noiaḡo, korana mai tau tu au na varau aḡabi-viriḡiato, bese irauirau tarimari e tanobara vereri baregori ema Isaraela tarimari ḡoirari ai au aragu bene kiraḡia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ema au na bavaḡa-ḡitaiani, ḡia au aragu bakunai tu midigumidigu vovoka roḡo beḡabini.” ");
INSERT INTO snc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Benamo Anania eiaḡoto, numai eraka-toḡato, ema ḡimana Saulo iatanai etore-kauato. Benamo ekirato, “Saulo tarikakagu, Vereḡauka Iesu, ḡia tu maiḡana oiaḡomato-ḡoi nai dabara tumanai ḡemu ai efoforito tarimana. Ḡia na betuḡugu, korana matamu ma bene fafa ema Iauka Veaḡa na ḡoi bene vaḡa-vonumu ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Asikauna dagara ta maḡani-kone ḡunari noḡa matana na eketo-vaḡito, benamo ma eboḡeboḡe-ḡenoḡoito. Moḡa murinai evaisi-raḡeto, benamo babatiso eḡabiato. ");
INSERT INTO snc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eḡaniḡanito murinai, tauna ma ekokore-ḡenoḡoito. Ma Saulo Damaseko ai tu ḡaro kotari roḡo ma etanuto, Iesu ḡekorana-iaḡiato-ḡoi tarimari ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ḡia asikauna rubu ḡana eiaḡoto, Iesu ea ḡobata-iaḡiato, ekirato, “Iesu tu Barau Natuna.” ");
INSERT INTO snc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulo ḡeseḡaḡiato tarimari mabarari nuḡari ḡefarevaḡito, benamo ḡekirato, “Mai tarima tu Iesu arana ḡekiraḡiani tarimari Ierusalemai evaḡirini tarimana ene? Ema maiḡana beiaḡoma tu mai veiḡa sebona uranai bene ḡabiri, be Rubu Veaḡa vereri ḡeri ai bene ḡori-ḡenoḡoi-iaḡori ḡana ene?” ");
INSERT INTO snc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Senaḡi Saulo ḡena ḡobata seḡukana tu ebaregoto-ḡoi. Ḡena guruḡai Iesu evaḡa-moḡoniato-ḡoi, moḡoni Iesu tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). Mo guruḡa Iuda tarimari Damaseko ai ḡetanuto-ḡoi tarimari tu asi ḡeri vaḡa-vese dabarana. ");
INSERT INTO snc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ḡaro ḡutuma ḡekorito murinai, Iuda tarimari ḡevegogoto, Saulo vaḡi-masena dabarana ḡeboioḡaiato; ");
INSERT INTO snc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","senaḡi kara ḡeboioḡaiato dagarana tu tarima tari na Saulo ḡekira-varaiato, be eribaiato. Boḡi-laḡani vanuḡa barana ḡatama bokari ḡeḡita-ḡaurito-ḡoi, ḡia beḡene vaḡia uranai. ");
INSERT INTO snc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Senaḡi boḡi ta Iesu ḡekorana-iaḡiato-ḡoi tarimari na ḡeḡabiato, boseḡai ḡeḡuraiato, benamo vanuḡa maḡuna murikana na ḡetuḡu-riḡoato. ");
INSERT INTO snc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Ierusalemai ea votuto nai tu, ḡena ura Iesu ḡekorana-iaḡiato-ḡoi tarimari ḡesi beḡene tanu-vegogo, senaḡi ḡia mabarari na ḡegari-viniato, korana asi ḡevaḡa-moḡoniato-ḡoi, ḡia tu moḡoni korikori Iesu ḡena mero. ");
INSERT INTO snc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Senaḡi Banabas na ea ḡoriato, apostolo tarimari ḡeri ai eḡori-iaḡoato. Ḡia na vau ḡeri ekiraḡito, Saulo na Vereḡauka dabarai kamasi eḡitaiato, ema Vereḡauka na eguruḡa-viniato. Ema ekira-vararito, kamasi Saulo tu Damaseko ai ma kokorena ḡesi, asi egarito, Iesu aranai eḡobatato nai. ");
INSERT INTO snc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Moḡa lorinai Saulo ḡia ḡesi ḡetanuto-ḡoi ema Ierusalema mabaranai eḡobatato-ḡoi Vereḡauka aranai ma kokorena ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik garo ai ḡeguruḡato-ḡoi Iuda tarimari ḡesi ḡeguruḡato-ḡoi e ḡeveḡare veḡareto-ḡoi, senaḡi ḡia na tu beḡene vaḡi-masea dabarana ḡevetauato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tarikaka na mai boioḡa ḡeribaiato nai tu, Saulo Kaisarea ḡana ḡeḡori-variḡoato, ma monana Taso ḡana ḡetuḡu-rakaiato. ");
INSERT INTO snc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Moḡa lorinai ekalesia mabarana Iudea, Galilea, e Samaria tanori ai maino eḡorato. Ekalesia ḡena kokore ebaregoto e Vereḡauka garina ḡeveito-ḡoi ema Iauka Veaḡa na evaḡa-kavarito. ");
INSERT INTO snc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petero gabu mabarari ḡari eiaḡoto, nuḡanai tu Lida ḡana maki evariḡoto, Barau ḡena tarimarima veaḡari rakaḡitari. ");
INSERT INTO snc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Monai tarima ta arana Aenea edoḡariato. Ḡia kwakuna tu mase ema laḡani imaima toitoi (8) veḡata ḡena genagena bedina na asi evariḡisito. ");
INSERT INTO snc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Benamo Petero na evaḡa-guruḡaiato, ekirato, “Aenea, Iesu Keriso na evaḡa-namomuni. Novariḡisi, ḡemu genagena noiokua.” Asikauna Aenea evariḡisito. ");
INSERT INTO snc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Monai ḡetanuto-ḡoi Lida e Saron tarimari mabarari na ḡeḡitaiato, benamo Vereḡauka ḡenai ḡeraka-kureto. ");
INSERT INTO snc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iopai Iesu ekorana-iaḡiato-ḡoi vavinena ta arana Tabita etanuto-ḡoi. Grik garo ai arana tu Doreka, anina tu “deer”. Ḡia tu veiḡa namori ḡutuma eveito-ḡoi, ema asi ḡeri-ḡari tarimari evaḡa-kavarito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mo negai ḡia tu ekeveto, benamo emaseto. Tauḡanina ḡeguriato, benamo numa tuḡunai daiḡutu tai ḡea toreato. ");
INSERT INTO snc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iopa e Lida fakari tu asi manaḡa. Be Iesu ḡekorana-iaḡiato-ḡoi tarimari Iopai ḡeseḡaḡito Petero tu Lidai nai, tarima ruarua ḡetuḡu-iaḡorito ḡia ḡenai, beḡene noḡia, beḡene kira, “Ḡai ḡesi si-iaḡo, asi nokwaibo!” ");
INSERT INTO snc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Moḡa lorinai Petero evariḡisito, benamo ḡia ḡesi ḡeiaḡoto. Eraḡasito nai tu, tuḡuna daiḡutuna ḡana ḡeḡori-varaḡeato. Monai vabu mabarari na ḡeruḡa-ḡeḡeraḡiato, benamo koudi e dabuḡa kotari, Doreka na maḡurinai eturirito-ḡoi dagarari, ḡia ḡevaḡa-ḡita-iaḡiato ma taḡiri ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petero na ḡia mabarari daiḡutu na etuḡu-rosirito, benamo evetui-tarito, eḡuri-ḡurito. Moḡa murinai eboḡe-tarito, mase vavinena eḡitaiato, benamo ekirato, “Tabita, novariḡisi!” Tabita na matana eiaḡarito, ma Petero eḡitaiato, benamo etanu-vaisito. ");
INSERT INTO snc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero na ḡimanai eḡabito, evaḡa-ruḡa-vaisiato. Benamo veḡabidadama tarimari e vabu ekea-toḡarito. Ḡia ḡema raka-toḡato nuḡanai, Tabita tu maḡuri eruḡa-taḡoto-ḡoi. Benamo Petero na ḡeri ai etuḡu-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mai veiḡa varina Iopa mabaranai eraga-rovorovoto, benamo tarima ḡutuma na Vereḡauka ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero ḡaro vovoka Iopai etanuto, boromakau kefiri eḡauvei-iaḡirito-ḡoi tarimana arana Simona ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tarima ta arana Korenelio, ḡia tu Kaisarea vanuḡanai etanuto-ḡoi. Ma ḡia tu Roma ḡeri vetari tarimari sinau sebona (100) eḡorikaurito-ḡoi tarimana. Ḡia na vetari doḡorona arana ḡekiraḡiato-ḡoi tu “Itali ḡeri Vetari Doḡorona” eḡita-ḡaurito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ḡia e ḡena numa tarimari mabarari ḡesi tu Barau ḡekorana-iaḡiato-ḡoi ema Barau garina ḡeveito-ḡoi. Ḡia na asi ḡeri-ḡari Iuda tarimari evaḡa-kava baregorito-ḡoi, ema vanaḡivanaḡi eḡauḡauto-ḡoi Barau ḡenai. ");
INSERT INTO snc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lavilavi ta, horaḡauna 3 koloko rekenai ḡia emata-vanaḡito, Barau ḡena aneru ta eḡita-korikoriato, ema raka-toḡato, benamo ḡia evaḡa-guruḡaiato, ekirato, “Korenelio!” ");
INSERT INTO snc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Benamo ma garina ḡesi Korenelio na mo aneru eḡita-karakaraiato, benamo ekirato, “Vereḡauka, kara?” Aneru na evaḡa-veseato, ekirato, “Ḡemu ḡuriḡuri e ḡemu vevaḡa-kava asi ḡeri-ḡari tarimari ḡeri ai tu Barau na eḡabi-raḡerito, ema ḡia na etuḡamaḡirini. ");
INSERT INTO snc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Toma, tau kotari Iopa ḡana notuḡu-iaḡori, be tau ta arana Simona, ḡia arana ta tu Petero, beḡenea ḡoria. ");
INSERT INTO snc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ḡia tu Simona, boromakau kefiri eḡauvei-iaḡirini tarimana ḡesi etanuni; ḡena numa tu kone rikinai.” ");
INSERT INTO snc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mo evaḡa-guruḡaiato aneruna na eraga-kwaneato, benamo Korenelio na ḡena vetuḡunaḡi tarimari ruarua ema ḡena vetari tarimana ta ekea-iaḡomarito. Ḡena vetari tarimana moḡa tu Barau ekorana-iaḡiato-ḡoi tarimana e ḡia tu vanaḡivanaḡi Korenelio sevinai ḡia vetuḡunaḡina ḡeiaḡo-viniato-ḡoi tarimana ta. ");
INSERT INTO snc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kara eḡorato dagarari mabarari Korenelio na ekira-vararito, benamo Iopa ḡana etuḡu-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ma elaḡanito, ḡia tu dabara na roḡo ḡeiaḡoto-ḡoi, Iopa ḡekavi-naḡiato, ḡaroḡotai Petero tu numa tuḡunai eraḡekauto, nea ḡuriḡuri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ḡia varau evitoato, benamo ḡena ura tu neḡaniḡani. Ma ḡaniḡani tu roḡo ḡerovinarito-ḡoi nuḡanai, ḡia emata-vanaḡito. ");
INSERT INTO snc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ḡia na guba evekeoto eḡitaiato, ema dagara ta dabuḡa baregona kavana, daigunina vasivasi emariḡoto-ḡoi ḡia ḡenai, noḡa moḡo ḡetuḡu-mariḡoato-ḡoi tanobara ḡana. ");
INSERT INTO snc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ḡia emariḡoto-ḡoi nuḡanai tu maḡuri dagarari irauirau mabarari, kwakuri vasivasi ḡerakani dagarari, e ḡedarani dagarari, ema guba na ḡerovoni manuri. ");
INSERT INTO snc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Benamo garo ta na ekiraiato, ekirato “Petero, novariḡisi, be novaḡiri, noḡaniri!” ");
INSERT INTO snc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Senaḡi Petero evaḡa-veseto, ekirato, “Vereḡauka, asiḡina ḡinavaḡi! Rakava e asi veiareva dagarari ta au na roḡosi roḡo bara ḡania.” ");
INSERT INTO snc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mo garo na ma evaḡa-guruḡa ḡenoḡoiato ekirato, “Barau na eiarevarito dagarari ta rakavana asi bono kiraḡi.” ");
INSERT INTO snc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Vaḡa-toitoi moḡesi eḡorato, benamo mo dabuḡa asikauna tu guba ḡana ma eḡabi-varaḡeato. ");
INSERT INTO snc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petero na mo ḡena mata-vanaḡi ai eḡitarito dagarari anina roḡo etuḡamaḡi-vetaurito-ḡoi nuḡanai, Korenelio ḡena vetuḡunaḡi tarimari tu ḡevotuto, ma ḡeribato Simona ḡena numa tu ainai. Benamo ḡeiaḡoto mo numa ḡatama bokana korana ḡoiranai ḡea ritoḡo-tarito. ");
INSERT INTO snc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Benamo ḡekeato e ḡevedanaḡito, ḡekirato, “Simona, arana ta ḡekiraḡiani Petero, tu mainai etanuni ba?” ");
INSERT INTO snc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petero na tu roḡo mo mata-vanaḡi anina etuḡamaḡi-vetauato-ḡoi nuḡanai, Iauka Veaḡa na evaḡa-guruḡaiato, ekirato, “Noseḡaḡi, ḡoi tu tarima toitoi na ḡevetaumuni. ");
INSERT INTO snc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Be novariḡisi, noraka-riḡo, ḡia ḡesi boḡono iaḡo. Asi bono ḡoiaḡi, korana au na atuḡurito bene.” ");
INSERT INTO snc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero eraka-riḡoto mo tarima ḡeri ai, benamo ekirato, “Ḡovetauani tauna tu au maiḡegu. Kara dainai boḡo iaḡoma?” ");
INSERT INTO snc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ḡia ḡevaḡa-veseto, ḡekirato, “Ḡai tu vetari tarimari sinau sebona (100) eḡori-kaurini tarimana arana Korenelio na betuḡuma. Ḡia tu vei-iobukaiobuka e Barau garina eveini tarimana, ema Iuda tarimari mabarari na maki ḡegubakau-baregoani. Ḡia tu Barau ḡena aneru ta na ekiraiato, ḡoi bene keakaumu, ḡena numa ḡana bono iaḡo, ema ḡoi na kara bokiraḡirini bene seḡaḡiri.” ");
INSERT INTO snc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Benamo Petero na mo tarima eḡabi-raḡerito ḡena numai, monai ḡegenato. Boḡiboḡi ai ḡevariḡisito, benamo Petero ḡia ḡesi ḡeiaḡoto, ema tarikaka kotari Iopa na maki ḡia ḡesi ḡeiaḡo-sebonato. ");
INSERT INTO snc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ḡia ḡeiaḡoto, dabara tumanai ḡea genato, ma elaḡanito vau Kaisareai ḡevotuto. Korenelio na tu ḡia enari-taḡorito-ḡoi, garagarana e ḡatana maki ekea-vegogorito ḡena numai. ");
INSERT INTO snc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petero eraka-toḡato nuḡanai, Korenelio na edoḡariato, benamo kwakuna koranai evetui-tarito ma etutuḡutari-viniato. ");
INSERT INTO snc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Senaḡi Petero na evaḡa-ruḡa-vaisiato, ekirato, “Novariḡisi, au maki tarimarima moḡo.” ");
INSERT INTO snc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Numa nuḡanai ḡeraka-toḡato-ḡoi nai, Petero na Korenelio evaḡa-guruḡaiato-ḡoi. Ma numa nuḡanai tu tarimarima ḡutuma vegogotaḡo edoḡaririto. ");
INSERT INTO snc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Benamo ḡia na evaḡa-guruḡarito, ekirato, “Ḡomi tauḡemi maki ma ribami ginikau, ḡai ḡema taravatu ekirani, Iuda tarimana ta irau bese tarimana ta ḡesi asi bene tanu-vegogo o asi bene raka-ḡitaia maki, taravatu. Senaḡi Barau na bevaḡa-ḡitagu, au na tarima ta asi bana kiraḡia ḡia tu rakava o asi veiareva. ");
INSERT INTO snc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Moḡa lorinai boḡo keakaugu nai, baiaḡoma moḡo, asi bakira-sirivaḡi. Be nadanaḡimi, au tu kara dainai boḡo keakaugu?” ");
INSERT INTO snc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korenelio ekirato, “Ḡaro vasivasi varau beḡe iaḡo, au tu ḡegu numai aḡauḡauto-ḡoi horaḡauna 3 koloko lavilavi rekenai, maitoma horaḡauna kavana. Benamo asikauna dabuḡa kurokuro lelevaḡina na evedabuḡato tarimana ta ḡoiragu ai eruḡa-tarito, ");
INSERT INTO snc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","benamo ekirato, ‘Korenelio! Barau na ḡemu ḡauḡau beseḡaḡia e vevaḡa-kava veiḡari asi ḡeri-ḡari tarimari ḡeri ai etuḡa-maḡirito. ");
INSERT INTO snc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Iopa ḡana novetuḡu-iaḡo, Simona, ḡia arana ḡekiraḡiani Petero ḡetoni, beḡenea kiraia, be bene iaḡoma. Ḡia tu Simona, boromakau kefiri eḡauvei-iaḡirini tarimana ḡena numai etanuni kone rikinai.’ ");
INSERT INTO snc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Moḡa lorinai asikauna vetuḡumu araga-veito, ema bovei-nauḡa, veiḡa namo taumu, korana boiaḡoma bene. Toma ḡai mabarama tu Barau ḡoiranai maiḡema, ma Vereḡauka na bevaḡa-naḡimu guruḡari mabarari baḡana seḡaḡiri ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Benamo Petero ḡena guruḡa esinaiato, ekirato, “Au toma bama riba-maoro, Barau na tarimarima mabarari tu eḡabiraḡe-ilailarini. ");
INSERT INTO snc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bese mabarari nuḡari ai tu deikara na ḡia garina eveini, ema veiḡa iobukari eveini tarimana moḡo ḡia na eḡabi-raḡeani. ");
INSERT INTO snc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Barau na Isaraela tarimari ḡeri ai etuḡu-iaḡomaiato varina tu maiḡa, mo tu maino varina Iesu Keriso ḡenana maino varina namona efiuato-ḡoi. Iesu Keriso tu tarima mabarari ḡeri Vereḡauka. ");
INSERT INTO snc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ḡomi ma ribami Iudea nuḡanai kara eḡorato, Galilea na evesinato. Mo tu Ioane na babatiso eḡobata-iaḡiato murinai. ");
INSERT INTO snc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iesu, Nasareta tarimana varina, ḡomi ma ribami, kamasi Barau na Iauka Veaḡa e seḡuka ḡia iatanai ebubu-riḡoato. Ḡia tu gabu mabarari ḡari eiaḡoto, veiḡa namori eveirito-ḡoi, ema Diabolo ḡena seḡuka na eḡabirito tarimari mabarari evaḡa-maḡuririto-ḡoi, korana Barau tu ḡia ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ḡai tu ḡia na Iuda e Ierusalema tanori ai eveirito-ḡoi dagarari mabarari ḡavaḡa-moḡonirini tarimama. Ḡia tu satauro ai ḡeikoko-kauato nai ḡevaḡa-maseato. ");
INSERT INTO snc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Senaḡina Barau na ḡaro vaḡa-toitoinai (3) evaḡa-variḡisi ḡenoḡoiato ema evaḡa-foforiato beḡene ḡitaia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ḡia tu tarimarima mabarari na asi ḡeḡitaiato, senaḡi ḡevaḡa-moḡoniani tarimari, mo tu Barau na eviriḡi-guinerito tarimari na moḡo ḡeḡitaiato. Ma moḡeri tarimari tu ḡai maiḡema. Ḡia evariḡisi-ḡenoḡoito murinai, ḡai tu ḡia ḡesi ḡaḡaniḡani-vegogoto e ḡaniuniu-vegogoto. ");
INSERT INTO snc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ḡia na evaḡa-naḡimato, tarimarima ḡeri baḡana ḡobata e baḡana kiraḡi-foforia, ḡia tu Barau na eḡabi-hidiato, maḡuri tarimari e mase tarimari ḡeri vevaḡa-maoro tarimanai evaḡa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta tarimari mabarari na ḡia ḡekiraḡi-foforiato-ḡoi, ḡekirato-ḡoi, ḡia beḡe vaḡa-moḡoniani tarimari mabarari tu ḡia arana seḡukanai Barau na ḡeri rakava betuḡamaḡi-fitoḡarini.” ");
INSERT INTO snc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petero roḡo eguruḡato-ḡoi nuḡanai, Barau ḡena guruḡa ḡeseḡaḡiato-ḡoi tarimari mabarari iatari ai Iauka Veaḡa eraka-riḡoto. ");
INSERT INTO snc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuda tarimari Iesu ḡevaḡa-moḡoniato-ḡoi ema Petero ḡesi Iopa na ḡeiaḡomato tarimari tu ḡeḡaba-rakavato, korana Barau na Iauka Veaḡa irau bese tarimari maki evinirito iatari ai ebubu-riḡoato. ");
INSERT INTO snc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Korana ḡeseḡaḡirito garo irauri ai ḡeguruḡato-ḡoi, ema Barau ḡevaḡa-raḡeato. Benamo Petero ekirato, ");
INSERT INTO snc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","mai tarimarima na tu Iauka Veaḡa varau beḡe ḡabia, ḡita na taḡabiato kavana. Be, nanu nuḡanai babatiso beḡene ḡabia ḡana tu deikara na bekira-ḡoiani? ");
INSERT INTO snc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Moḡa lorinai ḡia na ekirarito, Iesu Keriso aranai beḡene babatisori. Benamo ḡia na Petero ḡenoḡiato, ḡaro kotari ḡia ḡesi roḡo ma beḡene tanu. ");
INSERT INTO snc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolo e tarikaka Iudea tanonai mabarari ḡeseḡaḡito, irau bese tarimari na maki Barau ḡena guruḡa varau ḡeḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Benamo Petero Ierusalema ḡana evaraḡeto nai tu, Iesu ḡevaḡa-moḡoniato-ḡoi tarimari, senaḡi tauḡaniri kefiri tu ḡelama-vaḡirito, moḡeri na ḡeḡau-fitoḡaiato, ");
INSERT INTO snc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ḡekirato, “Ḡoi tu kefiri asi ḡelama-vaḡirini irau bese tarimari ḡeri numai oa raka-toḡato, ema ḡia ḡesi oa ḡaniḡani-vegogoto!” ");
INSERT INTO snc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Benamo Petero na vari mabarana ḡeri ekiraḡito, kamasi evesinato mo magona. Ekirato, ");
INSERT INTO snc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Au tu Iopa vanuḡana baregonai aḡuriḡurito-ḡoi, nuḡanai amata-vanaḡito. Aboḡeto, dagara ta dabuḡa baregona kavana, daigunina tu vasivasi (4), guba na emariḡoto-ḡoi, noḡa moḡo ḡetuḡu-mariḡoato-ḡoi, ḡoiragu ai ema vetore-tarito. ");
INSERT INTO snc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aboḡe-ḡurato nai tu, maḡuri dagarari irauirau, tanobarai kwakuri vasivasi na ḡerakani bureḡari, e boḡai ḡetanuni bureḡari, e ḡedarani dagarari, ema guba na ḡerovoni manuri aḡitarito. ");
INSERT INTO snc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Benamo garo ta aseḡaḡiato, ekirato, ‘Petero, novariḡisi, be novaḡiri e noḡaniri!’ ");
INSERT INTO snc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Senaḡi au akirato, ‘Vereḡauka, asiḡina ḡinavaḡi, rakava e asi veiareva dagarari ta au murugu na roḡosi beḡere raka-toḡa.’ ");
INSERT INTO snc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mo garo guba na ma eguruḡa-ḡenoḡoito, ekirato, ‘Barau na eiarevarito dagarari tu rakavari asi bono kiraḡiri.’ ");
INSERT INTO snc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Vaḡa-toitoina moḡesi eḡorato, benamo dagara mabarari guba ḡana ma eḡabi-varaḡerito. ");
INSERT INTO snc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mo horaḡauna sebonai tarima toitoi au atanuto-ḡoi numanai ḡeraḡasito. Ḡia tu Kaisarea na ḡetuḡurito au ḡegu ai. ");
INSERT INTO snc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Benamo Iauka Veaḡa na ekiraguto, ḡia ḡesi bana iaḡo, asi bana ḡoiaḡi. Mai tarikaka imaima sebona (6) maki au ḡesi Kaisarea ḡana ḡaiaḡoto, ema mabarama Korenelio ḡena numai ḡaraka-toḡato. ");
INSERT INTO snc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ḡia na ḡema ekiraḡiato, kamasi aneru ta, ḡia ḡena numai efoforito eḡitaiato, ema ekiraiato, ekirato, ‘Iopa ḡana novetuḡu-iaḡo, Simona, ḡia arana ta tu Petero, beḡenea kiraia, bene iaḡoma. ");
INSERT INTO snc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ḡia na guruḡa tari ḡemu bekiraḡirini, benamo mo guruḡa ḡerina Barau na ḡoi ema ḡemu numa tarimari mabarari bevaḡa-maḡurimini.’ ");
INSERT INTO snc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Au na guruḡa vau asinaiato nuḡanai, Iauka Veaḡa emariḡoto ḡia iatari ai, Pentekoste ḡaronai ḡita iatarai emariḡoto kavana. ");
INSERT INTO snc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Benamo Vereḡauka na kara ekiraḡiato dagarana atuḡamaḡi-doḡariato, ekirato, ‘Ioane tu nanu na ebabatisoto-ḡoi, senaḡina ḡomi tu Iauka Veaḡa na bebabatisomini.’ ");
INSERT INTO snc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bema Barau na mo varevare sebona moḡo, ḡita Vereḡauka Iesu Keriso tavaḡa-moḡoniato nai evinirato varevarena, irau bese tarimari maki evinirito nai tu, au tu deikara, be au na Barau bakira-ḡoiani?” ");
INSERT INTO snc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ḡia na mo guruḡa ḡeseḡaḡiato nai, ḡeri guruḡa barubaru ḡevaḡa-magoato, benamo Barau ḡevaḡa-raḡeato, ḡekirato, “O kato, irau bese tarimari maki Barau na vetuḡamaḡi-kure dabarana bevaḡa-ḡitari, maḡuri beḡene ḡabia ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefano emaseto nai, ekalesia vaḡa-midigumidiguna e lai-lausilausina eḡorato, benamo veḡabidadama tarimari ḡevaḡa-raga rovorovorito. Ḡia kotari ḡeiaḡoto mo Foenikia, Saipras e Antioka ai ḡea raḡasito. Monai Iuda tarimari ḡeri ai moḡo Iesu varina ḡeḡobata-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Senaḡi veḡabidadama tarimari kotari, Saipras e Kurene tarimari tu Antioka ḡana ḡeiaḡoto, Grik tarimari ḡeri ai maki vari ḡea fiuato, Iesu Vereḡauka Varina Namona ḡeḡobata-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Vereḡauka seḡukana tu ḡia ḡesi, be tarimarima ḡutuma-bara Vereḡauka ḡevaḡa-moḡoniato ema ḡevetuḡamaḡi-kureto. ");
INSERT INTO snc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ierusalema ekalesiari na mai vari ḡeseḡaḡiato, benamo ḡia na Banabas Antioka ḡana ḡetuḡu-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ḡia Antiokai eraḡasito, benamo Barau ḡena varevare-bara tarimarima ḡeri ai eḡitaiato nai, eiaku-rakavato. Ma mabarari elaunaḡirito, moḡoni ai Vereḡauka beḡene korana-iaḡia ma nuḡari mabarari ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas tu tarima namona, Iauka Veaḡa e veḡabidadama na evonuto. Ema tarimarima ḡutuma-bara Vereḡauka ḡena tarimarimai ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Benamo Banabas Taso ḡana eiaḡoto, Saulo vetau-vetauna. ");
INSERT INTO snc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Edoḡariato, benamo Antioka ḡana eḡori-iaḡoato. Monai mo laḡani sebona, tauri ruarua ekalesia ḡesi ḡevegogoto-ḡoi e tarimarima ḡutuma-bara ḡevaḡa-ribarito-ḡoi. Iesu ḡekorana-iaḡiato-ḡoi tarimari tu Antioka vanuḡanai vau ḡekiraḡirito “Christian”. ");
INSERT INTO snc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mo ḡaro ai peroveta tarimari kotari Ierusalema na Antioka ḡana ḡevariḡoto. ");
INSERT INTO snc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ta ḡia fakari ai arana tu Agabo. Agabo evariḡisito, Iauka na evaḡa-ribaiato ilailanai tanobara mabaranai doḡe baregona beḡorani varina efiu-guineato. Mo doḡe baregona tu Klaudio ḡena veḡitaḡau ḡarori ai eḡorato. ");
INSERT INTO snc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Iesu ḡekorana-iaḡiato-ḡoi tarimari na ḡeura-iaḡiato, ḡia tata ḡeri doḡari ilailari ai tarikakari Iudeai ḡeri ai ḡeri varevare dagarari kotari beḡene tuḡu-iaḡo, beḡene vaḡa-kavari ḡana. ");
INSERT INTO snc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mo veiḡa tu ḡeveiato, Banabas e Saulo ḡeri ai ḡeri moni ḡetuḡukauto, rubu ḡitataḡona tarimari beḡene viniri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Moḡeri ḡaro ai Kini Heroda na ekalesia tarimari kotari eḡabi-taririto, bene vaḡa-midigu midiguri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iakobo (o Iames), Ioane kakana, tu baḡa na debana ebasi-ḡutuato. ");
INSERT INTO snc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Heroda na Iuda tarimari eḡitarito, mo veiḡa ḡeiaku-iaḡiato nai tu, Petero maki ma ea ḡabi-tariato. Mo tu asi etubuni faraona verekona ḡarori ai eḡorato. ");
INSERT INTO snc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petero eḡabi-tariato, benamo dibura numai etoreato. Monai vetari tarimari gabanana imaima sebona (16) etorerito, vasiri vasiri ai evaḡa-ruḡarito vauro, Petero ḡeḡita-ḡauato. Heroda ḡena ura tu Pasova murinai vauro, tarimarima ḡoirari ai bene ḡori-rosia ema bene vaḡa-kotaia. ");
INSERT INTO snc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Moḡa lorinai Petero tu dibura numai ḡeḡita-ḡauato-ḡoi, a ekalesia tu Barau ḡenai ḡeḡauḡau-kokore kokoreto-ḡoi Petero ḡena. ");
INSERT INTO snc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Boḡi, ma belaḡanini tu Heroda na tarimarima ḡoirari ai Petero beḡori-rosiani, Petero tu seini na ḡebarubaruato, benamo vetari tarimari ruarua vekaravari ai egenato, ema ḡatama-boka ḡitaḡauna vetari tarimari na maki ḡatama-boka ḡenari-taḡoato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Benamo Vereḡauka ḡena aneru ta efoforito, Petero sevinai eruḡa-tarito, ema mama ta dibura numa nuḡanai enanagi-tariato. Mo aneru na Petero ḡabana ebota-karaiato, benamo evaḡo-tataḡaiato, ma ekiraiato, ekirato, “Ragavei, novariḡisi!” Benamo seini Petero ḡimana na ḡeketo-vaḡito. ");
INSERT INTO snc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Benamo aneru na evaḡa-guruḡaiato, ekirato, “Ḡemu gabaḡau nobaru-taria, ema ḡemu tamaka noveiri.” Benamo Petero na eveirito. Aneru ma ekirato, “Ḡemu koudi na noveseḡo, be au murigu na noiaḡoma.” ");
INSERT INTO snc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero ḡia murinai erakato mo, dibura numa na eraka-rosito. Senaḡi ḡia tu asi ribana, mo aneru na kara eveiato-ḡoi tu moḡoni. Ḡia mataboru ekirato tu, emata-vanaḡini etato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ḡatama-boka ḡitaḡauna tarimari ḡeruḡato gabuna ta ḡeraka-vanaḡiato, ma vaḡa-ruaruana ma ḡeraka-vanaḡiato, ḡeiaḡoto mo, auri ḡatama-bokanai ḡea raḡasito. Moḡa tu vanuḡa barana rakarosina ḡatama-bokana. Mo ḡatama-boka tu tauḡena moḡo ḡia ḡeri evekeoto, benamo ḡeraka-rosito. Dabara na ḡeraka-variḡoto-ḡoi nuḡanai, asikauna aneru na Petero eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Monai vau Petero eribato ḡia ḡenai kara eḡorato, benamo ekirato, “Au toma moḡoni bama riba, Vereḡauka na ḡena aneru betuḡua tu, Heroda ḡimana na, ema Iuda tarimari na au ḡegu ai kara ta beḡene veia ḡetato-ḡoi ḡenana bema vaḡa-maḡurigu. ");
INSERT INTO snc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mo veiḡa etuḡamaḡi-fakaiato, benamo Maria ḡena numa ḡana eiaḡoto. Maria tu Ioane Mareko sinana. Monai numa nuḡanai tu tarimarima ḡutuma ḡevegogoto, ḡeḡauḡauto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petero numa murikana ḡatama bokanai esekeseketo, benamo vetuḡunaḡi ḡuiatona ta arana Roda eiaḡoto, nea ḡitaia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Senaḡi ḡia na Petero garona eseḡaḡi-leaiato, benamo iaku na evaḡa-vonuato, benamo ḡatama-boka tu asi ekeo-fakaiato, a ḡia tu eraga-ḡenoḡoito, ea kirarito, Petero tu murikai eruḡa-taḡoni. ");
INSERT INTO snc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ḡia na ḡekiraiato, ḡekirato, “Ḡoi tu bebabomu ba!” Senaḡi ḡia eḡiḡiraḡeto-ḡoi, ekirato, “Moḡoni, Petero tu murikai eruḡa-taḡoni.” Benamo ḡekirato, “Mani tu ḡia ḡena aneru!” ");
INSERT INTO snc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Senaḡina Petero tu roḡo esekeseke-ḡiḡiraḡeto-ḡoi. Benamo ḡeiaḡoto, ḡatama-boka ḡea keo-fakaiato nai tu, Petero ḡeḡitaiato, ḡeḡaba-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petero ḡimana na ekira-ḡoirito asi beḡene guruḡa, benamo Vereḡauka na kamasi dibura numa na eḡori-rosiato ḡeri ekiraḡito. Ḡia na evaḡa-guruḡarito, ekirato, “Iakobo (o Iames) e tarikaka mabarari ḡeri mai vari boḡono kiraḡia.” Benamo ḡia tu erakato, gabu ta ḡana ma eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Boḡiboḡi, vetari tarimari fakari ai tu daradara baregona eḡorato; ḡevedanaḡi-vedanaḡito, ḡekirato, “Petero tu kamasi bevei?” ");
INSERT INTO snc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroda na gabu mabarana evetau-ginikauato, senaḡi Petero asi eḡoitaḡoato. Benamo Petero ḡeḡita-ḡauato tarimari evaḡa-kotarito murinai, ḡena vetari tarimari o soldia ekirarito beḡenea vaḡi-maseri. Moḡa murinai Heroda na Iudea eraga-kwaneato, ma Kaisareai ḡaro tari ea tanuto. ");
INSERT INTO snc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroda tu Taia e Sidono tarimari ebaruvini-rakavarito; moḡa lorinai Taia e Sidono tarimari ḡeveḡabi-vegogoto, ma Heroda ḡea ḡitaiato. Senaḡi guine, Blasto, Heroda ḡena gena-daiḡutuna ḡitataḡona tarimana ḡesi roḡo ḡeveḡatato, ḡevaḡa-maranaiato, ema ḡia rekeri ai roḡo ekauto. Moḡa murinai vauro ḡeiaḡoto, Heroda ḡenai maino ḡea noḡiato, korana ḡia ḡeri tanobara ḡaniḡanina tu Heroda ḡena tanobarai ḡeḡabito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Benamo ekiraḡi-toreato ḡaronai, Heroda na ḡena vere dabuḡana eveiato, benamo ḡena teronai ea tanukauto vau, tarimarima eguruḡa-vinirito. ");
INSERT INTO snc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Benamo tarimarima ḡeḡabato, ḡekirato, “Mai tu barau ta garona, dia tarimarima garona.” ");
INSERT INTO snc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mo horai Vereḡauka ḡena aneru ta na Heroda ekwariato, korana ḡia na mo guruḡa eseḡaḡiato nai, Barau tu asi evaḡa-raḡeato. Ḡia tu ḡuioḡuio na ḡeḡaniato, emaseto. ");
INSERT INTO snc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Senaḡi Barau ḡena guruḡa tu ebaregoto e eraga-rovorovoto. ");
INSERT INTO snc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas e Saulo tu ḡeri ḡauvei ḡevaḡa-koriato, benamo Ierusalema na ḡeḡenoḡoito; Ioane Mareko maki ḡeḡori-kauato. ");
INSERT INTO snc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka ekalesiana nuḡanai tu peroveta e vevaḡa-riba tarimari kotari. Arari tu Banabas; Simeona, arana ta tu Niga; Lukio, Kurene tarimana; Manaen, ḡia tu Gavana Heroda ḡesi ḡevaḡa-baregorito; e Saulo. ");
INSERT INTO snc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ḡia na Vereḡauka ḡetoma-rakariḡo viniato-ḡoi e ḡeḡani-veaḡato-ḡoi nuḡanai, Iauka Veaḡa na ekirarito, ekirato, “Banabas e Saulo tu au ḡegu boḡono ḡabi-ḡerevaḡiri, korana au na bakeari, ḡegu ḡauvei ta beḡene veia ḡana.” ");
INSERT INTO snc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Benamo ḡia ḡeḡani-veaḡato e ḡeḡuriḡurito murinai, ḡimari ḡia iatari ai ḡetore-kaurito, benamo ḡetuḡu-rakarito. ");
INSERT INTO snc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iauka Veaḡa na Banabas e Saulo etuḡurito, benamo tauri ruarua kone vanuḡana Seleukia ḡana ḡevariḡoto. Seleukia na tauri ruarua bouti ai ḡeraḡeto, benamo Saipras motumotu ḡana ḡevanaḡito. ");
INSERT INTO snc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Banabas ma Saulo Salami ai ḡevotuto nai, Barau ḡena guruḡa Iuda tarimari ḡeri rubu tari ai ḡea ḡobata-iaḡiato. Ioane Mareko maki ḡia ḡesi, ḡia tauri ruarua evaḡa-kavarito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tauri ruarua na Saipras motumotu mabarana ḡeraka-vanaḡiato, ḡeiaḡoto Pafo vanuḡanai ḡea raḡasito. Monai Iuda ḡeri ḡora e peroveta ḡofaḡofa tarimana ta arana Bar-Iesu ḡea doḡariato. ");
INSERT INTO snc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ma Bar-Iesu tu motumotu verena, ma iaunega rakavarakava tarimana arana Seregio Paulo ḡatana. Mo vere na Banabas e Saulo ekea-iaḡorito ḡia ḡoirana ḡana, korana ḡena ura tu Barau ḡena guruḡa bene seḡaḡia. ");
INSERT INTO snc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Senaḡi mo ḡora tarimana Elima, (Bar-Iesu arana ta tu Elima), na ḡeri guruḡa ekira-fitoḡarito, ḡena ura vere na Iesu asi bene vaḡa-moḡonia. ");
INSERT INTO snc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Benamo Saulo, arana ta tu Paulo, Iauka Veaḡa na evaḡa-vonuato, benamo Elima eḡita-karakaraiato. ");
INSERT INTO snc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Benamo ekirato, “Ḡoi tu Diabolo natuna, ema veiḡa iobukaiobukari mabarari tu ḡoi na ovetari-vinirini! Ḡoi tu ḡofaḡofa e rakava mabarari na ovonuto. Vereḡauka ḡena veiḡa iobukaiobukari ḡofaḡofai bono vaḡa-iaḡori uranai ovededegwani. Mo veiḡa tu aitoma vau bovaḡa-dokoani? ");
INSERT INTO snc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Noseḡaḡi! Toma Vereḡauka ḡena seḡuka ḡoi ḡemu ai befoforini, matamu bebubuni, ma laḡani mamana asi boḡitaiani, beiaḡoni mo, ḡaro ta.” Asikauna Elima tu mukuna na matana eḡabi-ḡauato, benamo eraka-ḡeḡeraḡi ḡeḡeraḡito, ḡena ura ta na ḡimanai bene ḡabi, ma bene ḡori-kaua. ");
INSERT INTO snc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mo vere na kara eḡorato dagarana eḡitaiato nai, Vereḡauka evaḡa-moḡoniato. Ema eḡaba-rakavato Vereḡauka ḡena vevaḡa-riba guruḡari ai. ");
INSERT INTO snc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ma karona ḡesi Pafo ḡeraga-kwaneato, bouti na Pega ḡana ḡeiaḡoto. Pega tu Pamfilia nuḡanai. Pegai benamo Ioane Mareko na Paulo e Banabas eraga-kwanerito, ḡia tu Ierusalema ḡana ma eḡenoḡoi-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pega na kwakuri na Antioka ḡana ḡeiaḡoto. Antioka tu Pisidia tanonai. Sabadi ai tu Iuda tarimari ḡeri rubu ai ḡeraka-toḡato, bena ḡetanu-tarito. ");
INSERT INTO snc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mose ḡena taravatu e peroveta tarimari ḡeri toretore ḡeiavirito murinai, rubu ḡitaḡauna tarimari na noḡinoḡi ḡetuḡu-iaḡoato ḡia tauri ruarua ḡeri ai, ḡekirato, “Tarikaka, bema ma ḡemi vevaḡa-gwaḡiḡi guruḡari mai tarimarima ḡeri ai nai tu, ḡai ḡaurani, ḡeri ḡokiraḡi.” ");
INSERT INTO snc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo evariḡisito, ḡimana na eiave-taririto, benamo ekirato, “Isaraela taumi e irau bese tarimari fakari ai Barau garina ḡoveini tarimami, ḡoseḡaḡi! ");
INSERT INTO snc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mai Isaraela tarimari ḡeri Barau na ḡai senema eḡabi-viriḡirito, ema ḡia na evaḡa-ḡutumarito, Aigupito tanonai ḡetanuto-ḡoi nai. Ma Barau ḡena seḡuka baregona na Aigupito tanona na eḡori-rosirito, ");
INSERT INTO snc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ema laḡani gabana vasivasi (40) kavana tano fakanai ḡia ḡeri ai evevaḡa-gwaḡiḡito. ");
INSERT INTO snc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ḡia na Kanana tanonai bese imaima ruarua (7) tarimarimari evaḡa-mou-taririto. Ma ḡeri tano tu eḡabiato, Isaraela tarimari evinirito e ḡeri tanobarai evaḡa-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mo dagara mabarari tu laḡani sinau vasivasi ma gabana imaima (450) kavana nuḡanai ḡeḡorato. Moḡa murinai ḡia na vevaḡa-roroḡoto tarimari evinirito, eiaḡoto mo peroveta tarimana Samuela ḡena veḡitaḡau laḡanina. ");
INSERT INTO snc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ma ḡeri vere o kini ta beḡene ḡabia noḡinoḡina ḡeveito nai, Barau na Saulo evinirito. Ḡia tu Kisa natuna, mo tu Beniamina ḡena doḡoro tarimana. Saulo na laḡani gabana vasivasi (40) eḡita-ḡaurito. ");
INSERT INTO snc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saulo kini dagina na eḡabi-vaḡiato murinai, Barau na Davida eḡabiato, Isaraela ḡeri kini ai evaḡa-iaḡoato. Barau na Davida tu maiḡesina ekiraḡi-foforiato, ekirato, ‘Au na Davida, Iese natuna, badoḡaria, ḡia tu au nuḡagu na euravini-rakavaiani tarimana. Ḡia na au ḡegu ura veiḡari mabarari beveirini.’ ");
INSERT INTO snc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Barau na ḡena guruḡatore ilailanai, Davida besena na, Isaraela tarimari ḡeri vevaḡa-maḡuri tarimana etuḡu-mariḡoato. Mo vevaḡa-maḡuri tarimana tu Iesu. ");
INSERT INTO snc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesu roḡosi roḡo bere ḡauvei nuḡanai, Ioane na Isaraela tarimari mabarari eḡobata-vinirito, ekirarito, ḡeri rakava ḡerina beḡene vetuḡamaḡi-kure, benamo babatiso beḡene ḡabia. ");
INSERT INTO snc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ioane na ḡena ḡauvei dori evaḡa-koriato nuḡanai, tarimarima ekirarito, ekirato, ‘Ḡomi ḡotuḡa-maḡini au tu dei? Au tu dia ḡomi na ḡovaḡa-nogaiani tarimana. Senaḡi ḡoboḡe! Ḡia tu au murigu na mani eiaḡomani, ma au tu asi ilaila ḡia kwakuna tamakari bakoki-vaḡirini.’ ");
INSERT INTO snc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tarikakagu, Aberahamo besena, ema ḡomi irau bese fakari ai Barau garina ḡoveini tarimami: Mai vevaḡa-maḡuri guruḡana tu ḡita ḡera etuḡu-iaḡomaiato. ");
INSERT INTO snc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ierusalema tarimari ma ḡeri vere ḡesi Iesu asi ḡeḡita-leaiato, ema Iesu, peroveta tarimari ḡeri guruḡa Sabadi mabarari ai ḡeiavirito-ḡoi, tu asi ḡetuḡamaḡi-fakarito. Moḡesina naima ḡia na Iesu vaḡi-masena guruḡana ḡekiraḡito nai, peroveta tarimari ḡeri guruḡa ḡevaḡa-moḡonirito. ");
INSERT INTO snc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Oba, vaḡi-masena korana ta tu asi ḡedoḡariato, senaḡina Pilato ḡenoḡiato, bene vaḡi-masea ḡetato. ");
INSERT INTO snc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Buka Veaḡai ḡia ḡekiraḡiato guruḡari mabarari ḡeveirito murinai, satauro tuḡuna na ḡeḡabi-riḡoato, benamo fore ḡekwaiato kouḡana garanai ḡea toreato. ");
INSERT INTO snc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Senaḡi Barau na mase na ma evaḡa-variḡisi ḡenoḡoiato, ");
INSERT INTO snc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ḡia ḡesi Galilea na Ierusalema ḡana ḡeiaḡoto-ḡoi tarimari na ḡaro vovoka ḡeḡitaiato. Ma ḡia toma tu Isaraela tarimari ḡeri ai Iesu ḡekiraḡi-foforiani. ");
INSERT INTO snc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ema Barau na ḡita senera kara ekiraḡitore-vinirito Varina Namona ḡomi ḡakira-varamini. ");
INSERT INTO snc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Mo kiraḡitore tu Barau na ḡita, ḡia tuburi, ḡera evaḡa-moḡoniato, mo tu ḡia na Iesu mase na ma evaḡa-variḡisi ḡenoḡoiato nai. Salamo vaḡa-ruaruanai etoreato ilailana, ekirani, ‘Ḡoi tu au Natugu; toma au tu ḡoi Tamamu ai baiaḡo.’ ");
INSERT INTO snc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Barau na moḡoni mase na evaḡa-variḡisi ḡenoḡoiato e asi ma beḡenoḡoini gara ḡana, benamo beboraḡani. Barau na tu maiḡesi ekiraḡiato, ekirato, ‘Davida ḡena akiraḡi-torerito, vevaḡa-namo veaḡari e moḡoniri tu ḡomi bavinimini.’ ");
INSERT INTO snc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ema Salamo ta nuḡanai ma ekirani, ‘Ḡoi ḡemu tarima veaḡana tu asi beboraḡani, korana tu asi bene ḡora otato.’ ");
INSERT INTO snc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davida ḡena ḡuru ai Barau ḡena vetuḡunaḡi eiaḡo-vinito-ḡoi nai emaseto, benamo senena seviri ai ḡeguriato, ma tauḡanina tu eboraḡato. ");
INSERT INTO snc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Senaḡi Iesu, Barau na mase na evaḡa-variḡisi ḡenoḡoiato tarimana, tu tauḡanina asi eboraḡato. ");
INSERT INTO snc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Moḡa lorinai, tarikakagu mabarami, au aurani boḡono riba, ḡai tu Iesu bakunai rakava tuḡamaḡi-fitoḡari varina ḡomi ḡemi ḡavari-fiuani. ");
INSERT INTO snc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mose ḡena taravatu na ḡomi ḡemi rakava tu asi beruḡa-vaḡirini riba, a Iesu na ḡia ḡevaḡa-moḡoniani tarimari mabarari ḡeri rakava tu eruḡa-vaḡirini, vei-iobukaiobuka tarimari ai evaḡa-iaḡorini. ");
INSERT INTO snc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Rorimi boḡono vetore, be peroveta tarimari na ḡekiraḡirito dagarari, ḡemi ai asi beḡene ḡora; ḡekirato, ");
INSERT INTO snc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ḡomi veḡabi-varaḡevaraḡe tarimami ḡoboḡeboḡe! Nuḡami ḡefarevaḡi, benamo ḡomase! Korana ḡemi maḡuri ḡarori ai au na veiḡa ta baveiani, enabe ta na ḡemi bekiraḡi-ginikauani, senaḡi asi boḡo vaḡa-moḡoniani!’” ");
INSERT INTO snc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo e Banabas rubu na ḡeraka-riḡoto-ḡoi nuḡanai, tarimarima na ḡenoḡirito, ḡoira Sabadi ai ma beḡene ḡenoḡoi, be mo guruḡa kotari ma ḡeri beḡene kiraḡi. ");
INSERT INTO snc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tarimarima vegogo na ḡeḡwa-lausiato murinai, Iuda tarimari ḡutuma, ema irau bese tarimari, Barau ḡekorana-iaḡiato-ḡoi tarimari, ḡutuma maki Paulo e Banabas muriri na ḡeiaḡoto. Tauri ruarua na ḡevaḡa-guruḡarito e ḡelaunaḡirito, Barau ḡena varevare-bara nuḡanai beḡene ruḡa-gwaḡiḡi. ");
INSERT INTO snc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabadi vaḡa-ruaruanai, dori moḡo mo vanuḡa baregona tarimari mabarari na Vereḡauka ḡena guruḡa seḡaḡi-seḡaḡina ḡeraka-vegogoto. ");
INSERT INTO snc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Iuda tarimari na mo ḡutuma ḡeḡitarito nai, ḡemama-rakavato; benamo Paulo na kara ekiraḡirito-ḡoi guruḡari, ḡia na ḡekira-fitoḡarito e ḡevei-veḡare veḡareato. ");
INSERT INTO snc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Senaḡi Paulo e Banabas tu ma kokoreri ḡesi ḡevaḡa-veserito, ḡekirato, “Barau ḡena ura lorinai tu ḡia ḡena guruḡa ḡai na ḡomi baḡana kiravara-guinemi. Senaḡi ḡomi na asi ḡoḡabi-raḡeani, monana tu ḡomi tauḡemi na ḡovaḡa-moḡoniani, ḡomi tu asi ilaila maḡuri vanaḡivanaḡi boḡo ḡabiani. Moḡa lorinai, ḡai na ḡomi ḡaraga-kwanemini, ma irau bese tarimari ḡeri ai ḡaiaḡoni. ");
INSERT INTO snc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Korana Vereḡauka na tu maiḡesi evaḡa-naḡimato, ekirato, ‘Au na ḡomi atoremito tu, irau bese tarimari ḡeri mamai boḡono iaḡo, be vevaḡa-maḡuri boḡono ḡabi-rosia tanobarai ḡetanuni tarimari mabarari ḡeri ai.’” ");
INSERT INTO snc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Irau bese tarimari na mo guruḡa ḡeseḡaḡiato nai, ḡeiakuto e Vereḡauka ḡena guruḡa ḡevaḡa-raḡeato; ema Barau na eḡabi-viriḡirito maḡuri vanaḡivanaḡi beḡe ḡabiani tarimari mabarari ḡeveḡabidadamato. ");
INSERT INTO snc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Vereḡauka ḡena guruḡa mo gabu mabarana nuḡanai eraga-rovorovoto. ");
INSERT INTO snc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Senaḡi Iuda tarimari na irau bese vavineri, dagi baregori ḡeḡabi-taḡorito-ḡoi ma Barau ḡekorana-iaḡiato-ḡoi vavineri, e vanuḡa baregonai veḡitaḡau tauri, nuḡari ḡeḡanirito. Benamo ḡia na vevaḡa-midigumidigu ḡevaḡa-ḡoraiato Paulo e Banabas ḡeri ai, ema ḡeri gabu na ḡelai-rosirito. ");
INSERT INTO snc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tauri ruarua na kwakuri kauri ḡekwari-ketoketorito, ḡia ḡeri kira-sirivaḡi vaḡa-moḡoniri ḡana, benamo Ikonia ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Iesu ḡekorana-iaḡiato-ḡoi tarimari Antiokai tu iaku e Iauka Veaḡa na ḡevonuvonu-raḡeto. ");
INSERT INTO snc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniai Paulo e Banabas tauri ruarua Iuda tarimari ḡeri rubu ai ḡeveito-ḡoi kavana ḡeraka-toḡato, benamo ḡeḡobatato. Ḡeri ḡobata na Iuda e Grik tarimari ḡutuma lelevaḡi ḡeveḡabidadamato. ");
INSERT INTO snc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Senaḡi Iuda tarimari asi ḡeurato Iesu beḡene vaḡa-moḡonia, tarima kotari na irau bese tarimari ḡelaunaḡi-naḡirito, benamo tarikaka veḡabidadama nuḡanai tarimari ḡeiau-rakava vinirito. ");
INSERT INTO snc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo e Banabas monai ḡetanu-maukato. Ma kokoreri ḡesi Vereḡauka ḡena varevare-bara guruḡana ḡekiraḡiato-ḡoi. Vereḡauka na ḡeri guruḡa evaḡa-moḡonirito tu seḡuka evinirito, vetoḡa boruri e nuḡa-farevaḡi veiḡari ḡeveito. ");
INSERT INTO snc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Senaḡi mo vanuḡa baregona tarimari tu ḡevevare-kirato, reke-ta Iuda tarimari ḡesi ḡekauto, reke-ta tu apostolo tarimari ḡesi. ");
INSERT INTO snc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Benamo irau bese tarimari e Iuda tarimari ma ḡeri veguine-iaḡi tauri ḡesi ḡeverori-vegogoto, ḡeurato apostolo beḡene vaḡa-midigu midiguri e fore na beḡene ḡidara-maseri. ");
INSERT INTO snc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Senaḡi Paulo e Banabas na mo boioḡa ḡeribaiato, benamo Likaonia tanonai vanuḡa baregori ruarua Listera e Derebe, ema seviri tanori ḡana ḡegari-iaḡoto e seviri vanuḡari tari ḡari. ");
INSERT INTO snc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Monai Vari Namona ḡeḡobata-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listerai tarima ta etanuto-ḡoi; ḡia tu kwakuna rakava emaḡurito, be asi erakato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mo tarima tu eseḡaḡi-taḡoto-ḡoi Paulo eḡobatato-ḡoi nuḡanai. Paulo na eḡita-karakaraiato, benamo eribato ḡia tu ḡena veḡabidadama na bevaḡa-namoani riba, ");
INSERT INTO snc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","benamo eguruḡa-fararato, ekirato, “Novariḡisi, noruḡa-tari. Benamo eburi-vaisito, erakato. ");
INSERT INTO snc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tarimarima ḡutuma na kara Paulo na eveiato ḡeḡitaiato nai, ḡeri Likaonia garonai ḡekoḡoto, ḡekirato, “Barau tu tarimarimai beḡe iaḡo, beḡe raka-riḡo ḡita ḡerai!” ");
INSERT INTO snc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ḡia na Banabas arana tu Dios ḡetato, ema Paulo arana tu Hemes ḡetato, korana Paulo tu eguruḡa-vovokato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dios ḡena Rubu Veaḡa verena ḡena rubu tu vanuḡa barana murikanai. Ḡia na boromakau e veravera vanuḡa maḡuna ḡatama bokana ḡana eḡwa-iaḡorito, korana tarimarima ḡutuma ḡesi ḡeurato, apostolo ḡeri ai ginitaḡo veiḡari beḡene vei ḡana. ");
INSERT INTO snc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Senaḡina apostolo ruarua Banabas e Paulo na ḡeseḡaḡirito, kara ḡeveia ḡetato nai, ḡeri dabuḡa ḡedarerito, benamo ḡutuma nuḡari ai ḡeraga-ḡabaḡaba-toḡato. ");
INSERT INTO snc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ḡekirato, “Karase ḡomi tau tu maiḡesi ḡoveini? Ḡai maki tarimarima moḡo ḡomi kavana! Ḡai na tu Vari Namona ḡomi ḡemi ai ḡaḡabi-iaḡomaiani, ḡomi ḡakiramini, mai asi tauri dagarari boḡono raga-kwaneri, benamo Barau maḡurina ḡenai boḡono raka-ḡenoḡoi ḡatoni. Ḡia na guba, tanobara, daḡaru-bara, e ḡetanu-iaḡirini dagarari mabarari eveirito. ");
INSERT INTO snc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Guinenai ḡia na bese mabarari etao-fitoḡarito, tauḡeri ḡeri ura dabarari ai beḡene raka ḡana. ");
INSERT INTO snc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Senaḡi dagara namori eveirini ḡerina, ḡia tauḡena vanaḡivanaḡi evevaḡa-moḡonini: Ḡia na ḡura guba na evinimini e varovaro dagarari ḡeri ḡaro korikoriri ai evinimini. Ḡia na ḡaniḡani asisebo evinimini e nuḡami iaku na evaḡa-vonurini.” ");
INSERT INTO snc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Moḡesi ḡevaḡa-guruḡarito, senaḡina mo tarimarima ḡutuma-bara tu ḡia tauri ruarua ḡeri ai ginitaḡo ḡauveina ḡeveia roḡo ḡetato-ḡoi, kiraḡoiri tu tauri ruarua ḡeri ai tu egwaḡiḡito. ");
INSERT INTO snc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A Iuda tarimari kotari Antioka e Ikonia na ḡeiaḡomato, ma moḡeri tarimari ḡia rekeri ai ḡeḡabi-vanaḡirito. Benamo Paulo fore na ḡeḡidaraiato ma ḡeinu-rosiato vanuḡa murina ḡana. Ḡia ḡetuḡamaḡito tu varau emaseto. ");
INSERT INTO snc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Senaḡi Iesu ḡekorana-iaḡiato-ḡoi tarimari na ḡeruḡa-ḡeḡeraḡiato nai tu eruḡa-vaisito, benamo vanuḡa barana ḡana ma erakatoḡa-ḡenoḡoito. Boḡiboḡi tu Banabas ḡesi Derebe ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo e Banabas na Derebe ai Vari Namona ḡeḡobata-iaḡiato, benamo tarimarima ḡutuma Iesu korana-iaḡina tarimari ai ḡeḡabi-toḡarito. Benamo ma ḡeḡenoḡoi-iaḡoto Listera, e Ikonia, ema Pisidia Antiokana ḡana. ");
INSERT INTO snc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ḡia na Iesu ḡekorana-iaḡiato-ḡoi tarimari ḡevaḡa-kokorerito e ḡelaunaḡirito, ḡeri veḡabidadama beḡene ḡabi-gigitariri. Ema ḡekirato, “Ḡita tu midigumidigu vovoka bita ḡabirini vau Barau ḡena Basileiai bita raka-toḡani.” ");
INSERT INTO snc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tauri ruarua na rubu tatai veḡorikau tarimari ḡevaḡa-ruḡarito. Ma tauri ruarua ḡeḡani-veaḡato e ḡeḡauḡauto murinai, Vereḡauka ḡimanai ḡetore-kaurito. Mo tu ḡia na ḡeḡabidadama-viniato-ḡoi Vereḡaukana ḡenai. ");
INSERT INTO snc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia tanona na ḡeraka-vanaḡito murinai tu, Pamfilia tanonai ḡeraḡasito. ");
INSERT INTO snc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pega vanuḡanai Vereḡauka ḡena guruḡa ḡeḡobata-iaḡiato murinai tu, Atalia vanuḡana ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia na tu bouti na ḡeḡenoḡoi-iaḡoto Antioka ḡana. Monai tu, ḡeri evanelia iaḡoiaḡona roḡosi roḡo beḡene sinaia nai, tarikaka na Barau ḡena namo e varevare-bara nuḡanai ḡetore-kaurito, mai ḡauvei beḡene veia ḡana. Ḡauveina tu toma beḡe vaḡa-koria. ");
INSERT INTO snc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokai ḡeraḡasito nai tu, ekalesia tarimari ḡevaḡa-vegogorito, benamo Barau na ḡia ḡerina kara eveirito dagarari mabarari, e kamasi ḡia na irau bese tarimari ḡeri veḡabidadama ḡatama bokana ekeoato variri, ḡeri ekiraḡito. ");
INSERT INTO snc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Monai Iesu ḡekorana-iaḡiato-ḡoi tarimari ḡesi tauri ruarua ḡetanu-maukato. ");
INSERT INTO snc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tau kotari Iudea na Antioka ḡana ḡevariḡoto, benamo tarikaka veḡabidadama nuḡanai tarimari ḡevaḡa-ribarito, ḡekirato, “Ḡomi tu vevaḡa-maḡuri asi ilaila boḡo ḡabiani riba, bema mero tauḡaniri kefi-lamavaḡi veiḡana Mose ḡena taravatu ai ekiraḡiani dagarana asi boḡo korana-iaḡiani nai.” ");
INSERT INTO snc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mo guruḡa ḡaramanai, Paulo e Banabas ḡia ḡesi veḡare-veḡare baregona ḡeveiato. Moḡa lorinai Paulo e Banabas ema Antioka ekalesia tarimari kotari ḡeviriḡirito, Ierusalema ḡana beḡene varaḡe, be apostolo e ekalesia ḡeḡori-kauato-ḡoi tarimari ḡeri ai mo guruḡa beḡenea vedanaḡi-iaḡia. ");
INSERT INTO snc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ḡia tu rubu na ḡetuḡu-iaḡorito. Ma Foenikia e Samaria tanori nuḡari na ḡeraka-vanaḡito nai tu, monai tarikaka ḡeri ḡekiraḡito, kamasi irau bese tarimari Barau ḡenai ḡevetuḡamaḡi-kureto. Tarikaka mabarari na mo vari ḡeseḡaḡiato nai, mabarari ḡeiaku-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ierusalemai ḡeraḡasito nai, ekalesia tarimari, e apostolo tauri, ema ekalesia ḡeḡita-taḡoato-ḡoi tarimari na ḡeḡabi-raḡerito. Benamo Barau na ḡia ḡerina kara eveito dagarari mabarari ḡeri ḡekiraḡito. ");
INSERT INTO snc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Senaḡi Farisea doḡoro na Iesu ḡeḡabidadama-viniato-ḡoi tarimari kotari ḡeruḡa-vaisito, benamo ḡekirato, “Irau bese tarimari maki tauḡaniri kefiri beḡene lama-vaḡiri, ema boḡono kirari, Mose ḡena taravatu beḡene korana-iaḡia.” ");
INSERT INTO snc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Benamo apostolo e ekalesia ḡeḡita-taḡoato-ḡoi tarimari ḡetanu-vegogoto, ma mo vedanaḡi ḡetuḡa-maḡiato. ");
INSERT INTO snc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ḡeguruḡa-iaḡi maukaiato murinai, Petero evariḡisito, benamo ekirato, “Tarikakagu mabarami, ḡomi ma ribami, kai-veḡata ḡomi vefakami ai Barau na au eḡabi-hidiguto, irau bese tarimari ḡeri Vari Namona bana kiraḡia, be ḡia maki beḡene seḡaḡi e beḡene veḡabidadama. ");
INSERT INTO snc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ema tarimarima nuḡari eribarini Barauna na irau bese tarimari Iauka Veaḡa evinirito, ḡita evinirato kavana. Mo veiḡa ḡenana evaḡa-ḡitarani, ḡia maki eḡabi-raḡerito. ");
INSERT INTO snc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ḡita e ḡia fakarai vaḡa-iraura vetoḡana ta tu asi eveiato, korana tu ḡeri veḡabidadama lorinai, Barau na nuḡari eiarevarito. ");
INSERT INTO snc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma toma tu kara dainai Barau ḡotovo-naḡiani, Iesu ḡekorana-iaḡiani tarimari iatari ai meto ḡotorerini. Mo tu ḡita tauḡera na e ḡita senera na maki mo maruna ḡwaḡwana asi ḡeilailato dagarana. ");
INSERT INTO snc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Asiḡina! Ḡita taribani, ḡita tu Iesu Vereḡauka ḡena namo e varevare-bara lorinai, Barau na evaḡa-maḡurirani, ḡia maki moḡesina.” ");
INSERT INTO snc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Petero moḡesi ekirato nai, vegogo tarimari mabarari asi ḡeguruḡato. Benamo Banabas e Paulo ḡeseḡaḡi-vinirito, Barau ḡia ḡerina vetoḡa boruri e nuḡa-farevaḡi veiḡari, Grik tarimari fakari ai eveirito dagarari, mabarari ḡekiraḡirito. ");
INSERT INTO snc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ḡia ḡeguruḡa-ḡosito vau, Iakobo (o Iames) eguruḡato, ekirato, “Tarikakagu mabarami, ḡoseḡaḡigu! ");
INSERT INTO snc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simona na inivau bekiraḡi-ginikaua, kamasi tovotovonai Barau na irau bese tarimari etuḡamaḡirito, benamo ḡia fakari na bese ta eḡabi-viriḡiato, ḡia arana beḡene ḡabia ḡana. ");
INSERT INTO snc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mai tu peroveta tarimari ḡeri guruḡa ḡesi beḡe ilaila-ginikau, korana maiḡesi ḡetoreato, ");
INSERT INTO snc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Vereḡauka ekirani: Maiḡa murinai au ma baḡenoḡoi-iaḡomani, benamo Davida ḡena numa, eḡwa-kafuato dagarana, ma baraga-ḡenoḡoiani. Ḡefuki-rovorovoato dagarana, au na ma baraga-ḡenoḡoiani, ema bavaḡa-ruḡavaisi-ḡenoḡoiani. ");
INSERT INTO snc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Korana tu tarimarima kotari maki mabarari na, ema au aragu ḡeḡabi-rakaoani tarimari irau bese tarimari mabarari na, au, Vereḡauka, beḡene vetaugu ḡana. ");
INSERT INTO snc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Vereḡauka na maiḡeri dagara mabarari bevaḡa-ḡorarini. Ma irau laḡani ai veḡata maiḡeri veiḡa evaḡa-foforirito.’ ");
INSERT INTO snc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Moḡa lorinai au atuḡamaḡini, irau bese tarimari ḡevetuḡamaḡi-kureni Barau ḡenai nai tu, ḡeri ai asi bitana vaḡa-gwaḡiḡia. ");
INSERT INTO snc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Senaḡi fefa ta bitana torea, bitana kirari, kwaivakuku ḡevarevare-vinirini ḡaniḡaniri tu asi beḡene ḡaniri, korana mo tu ḡofaḡofa barauri ḡevinirini dagarari; mata-boraḡa veiḡari asi beḡene veiri, ema ḡaiḡori na ḡebito-maserini bureḡari asi beḡene ḡaniri e rara asi beḡene ḡani. ");
INSERT INTO snc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Korana Mose ḡena taravatu tu kai-veḡata vanuḡa baregori mabarari ai ḡeḡobata-iaḡirini ema Sabadi ḡarori mabarari ai Iuda tarimari ḡeri rubu ai ḡeiavirini.” ");
INSERT INTO snc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Benamo apostolo e ekalesia ḡeḡori-kauato-ḡoi tarimari ema ekalesia mabarari ḡeurato, ḡia fakari na tau kotari beḡene ḡabi-viriḡiri, benamo Paulo e Banabas ḡesi Antioka ḡana beḡene tuḡu-iaḡori. Ḡia na Iudas, arana ta tu Barasaba ḡetato-ḡoi, e Silas ḡeḡabi-viriḡirito. Ḡia tu tarikaka na ḡegubakau-baregorito-ḡoi tarimari. ");
INSERT INTO snc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mai fefa tu ḡia ḡesi ḡetuḡu-iaḡoato: “Ḡai ḡomi tarikakami veḡabidadama nuḡanai, apostolo tarimama e ekalesia ḡeḡita-taḡoani tarimama na ḡema vevaḡa-namo ḡatuḡu-iaḡosiani, ḡomi tarikaka veḡabidadama nuḡanai irau bese tarimami, Antioka ai, Siria ai, e Kilikia ai ḡotanuni tarimami mabarami ḡemi ai. ");
INSERT INTO snc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ḡai baḡama seḡaḡi, mainana tau kotari ḡeiaḡosito, benamo ḡeri guruḡa na ḡemi tuḡamaḡi ḡevaḡa-veḡonurito e ḡevaḡa-daradaramito. Korana tu ḡekiramito, tauḡanimi kefiri boḡono lama-vaḡiri ema taravatu boḡono korana-iaḡia. Senaḡi mani tu dia ḡai ḡemana ḡeḡabito guruḡari. ");
INSERT INTO snc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Moḡa lorinai, ḡema vegogo ai ḡai mabarama na ḡavaḡa-moḡoniato, tau kotari baḡana ḡabi-hidiri, be baḡana tuḡu-iaḡosiri, ḡema tuḡamaḡikau tarimari Banabas e Paulo ḡesi beḡene iaḡosi. ");
INSERT INTO snc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ḡia tu ḡeri maḡuri gwairi asi ḡeḡabirito, ḡetore-taririto, ḡera Vereḡauka Iesu Keriso arana dainai. ");
INSERT INTO snc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Moḡa lorinai, Iudas e Silas baḡa tuḡuri, kara baḡa toreri dagarari ḡia tauḡeri mururi na guruḡai ḡomi ḡemi ai beḡene vaḡa-moḡoniri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Iauka Veaḡa e ḡai ḡakirato, namona tu ḡomi iatami ai meto ta asi baḡana tore-kaua. Senaḡina maiḡesi veiḡari moḡo boḡono korana-iaḡiri: ");
INSERT INTO snc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ḡofaḡofa barauri o kwaivakuku ḡevinirini ḡaniḡaniri asi boḡono ḡani; rara asi boḡono ḡani; ḡaiḡori na ḡebito-maserini bureḡari asi boḡono ḡaniri; e mata-boraḡa veiḡari asi boḡono veiri. Mo dagara ḡerina boḡo raka-veḡitani nai, ḡomi tu boḡo iaḡo-ginikauni. Boḡono gena.” ");
INSERT INTO snc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ḡeviriḡirito tarimari ḡetuḡurito, benamo Antioka ḡana ḡevariḡoto. Monai veḡabidadama tarimari mabarari ḡevaḡa-vegogorito vau, ḡeri fefa ḡevinirito. ");
INSERT INTO snc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ḡia na mo fefa ḡeiaviato nai, ḡeiaku-rakavato, korana vevaḡa-kava guruḡana ḡeseḡaḡiato nai. ");
INSERT INTO snc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iudas e Silas, ḡia tauḡeri tu peroveta tarimari. Ḡia tauri ruarua na tarikaka ḡeri guruḡa ḡutuma ḡekiraḡirito, ḡelaunaḡirito e ḡevaḡa-gwaḡiḡirito. ");
INSERT INTO snc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ḡaro kotari monai ḡetanuto murinai, ma mainori ḡesi tarikaka na ḡetuḡu-ḡenoḡoirito, ḡetuḡurito tarimari ḡeri ai. ");
INSERT INTO snc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34"," Senaḡi Silas tu eurato Antiokai roḡo bene tanu. ");
INSERT INTO snc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo e Banabas tu Antiokai ḡetanu-maukato, ma tarima ḡutuma ḡesi Vereḡauka ḡena guruḡa ḡevevaḡa-riba iaḡiato-ḡoi, e ḡeḡobata-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ḡaro kotari ḡevanaḡito murinai, Paulo na Banabas evaḡa-guruḡaiato, ekirato, “Taura ruarua ma siḡenoḡoi-iaḡo, Vereḡauka ḡena guruḡa taḡobata-iaḡiato-ḡoi vanuḡari mabarari ḡari, tarikakara bitana ḡitari, ḡeri veḡabidadama maḡurina tu aiḡesina.” ");
INSERT INTO snc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas ḡena ura tu Ioane Mareko maki neḡori-kaua, be ḡia ḡesi beḡene iaḡo. ");
INSERT INTO snc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Senaḡi Paulo asi ḡena ura ḡia beḡene ḡori-kaua, korana ḡia na Pamfilia ai tu eraga-kwanerito, ema ḡia ḡesi asi ḡeḡauveito mo ḡeri ḡauvei magona. ");
INSERT INTO snc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Moḡa ḡaramanai ḡia tauri ruarua veḡareveḡare baregona ḡeveiato. Benamo tauri ruarua ḡeveraga-kwaneto. Banabas na Mareko eḡoriato, bouti ai ḡeraḡeto, benamo Saipras ḡana ḡeiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A Paulo na tu Silas eḡabi-viriḡiato. Tarikaka na Vereḡauka ḡena varevare-bara vevaḡa-namona ḡevinirito murinai ḡerakato. ");
INSERT INTO snc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria e Kilikia tanori na ḡeraka-vanaḡito, benamo ekalesia doḡorori monai ḡevaḡa-gwaḡiḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo monana evanaḡi-iaḡoto Derebe ai ea votuto, ma monana tu eiaḡoto Listera ai ea raḡasito. Listerai tu Iesu ekorana-iaḡiato-ḡoi tarimana ta etanuto-ḡoi, arana tu Timoteo. Timoteo sinana tu Iuda vavinena, ḡia maki eveḡabi-dadamato-ḡoi vavinena, senaḡi tamana tu Grik tarimana. ");
INSERT INTO snc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tarikaka mabarari Listerai e Ikoniai na Timoteo tu tarima namonai ḡekiraḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo eurato Timoteo tu bene ḡori-kaua, be ḡia ḡesi beḡene iaḡo, moḡa lorinai, ḡia tauḡanina kefina elama-vaḡiato. Moḡesi ḡeveiato, korana monai ḡetanuto-ḡoi Iuda tarimari mabarari ribari, Timoteo tamana tu Grik tarimana. ");
INSERT INTO snc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vanuḡa loriri na ḡevanaḡi-iaḡoto-ḡoi nai tu, Ierusalemai ḡetanuni apostolori e ekalesia ḡorikauri tarimari na ḡevaḡa-moḡonirito guruḡari veḡabidadama tarimari ḡeri ḡekiraḡito-ḡoi, ḡia na beḡene korana-iaḡiri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Benamo ekalesia tarimari ḡeri veḡabidadama ḡevaḡa-kokorerito, e ḡaro mabarari ai ekalesia ḡeḡutumato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo ma karona ḡesi Frigia e Galatia tanori nuḡari na ḡeraka-vanaḡito moḡo, korana Iauka Veaḡa na ekira-ḡoirito, Asia tanori ai Barau ḡena guruḡa asi beḡene vari-fiua. ");
INSERT INTO snc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia tano vetoḡanai ḡeraḡasito, benamo Bitinia tanonai ḡeraka-toḡa ḡetato, senaḡi Iesu Iaukana asi eurato ḡia mo ḡana beḡene iaḡo. ");
INSERT INTO snc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Moḡa lorinai Misia na ḡevanaḡito, Troas vanuḡanai ḡea votuto. ");
INSERT INTO snc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mo boḡi Paulo emata-vanaḡito. Ḡia na Makedonia tarimana ta ruḡataḡo eḡitaiato, ḡia enoḡiato-ḡoi, ekirato, “Makedonia ḡana noiaḡoma, noma vaḡa-kavama.” ");
INSERT INTO snc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo na mo mata-vanaḡi eḡitaiato murinai, ḡaraga-ḡabikavito, Makedonia ḡana baḡana iaḡo ḡana. Korana ḡaribato, mo tu Barau na ekeamato, mo tarimarima ḡeri ai Vari Namona baḡana fiua ḡana. ");
INSERT INTO snc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Moḡa lorinai Troas ai bouti ai ḡaraḡeto, benamo maoromaoro Samotrake motumotu ḡana ḡaiaḡoto. Monai ḡagenato, elaḡanito vau Neapoli ḡana ḡaiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Monana gunika ḡana ḡaiaḡoto mo, Filipi ai ḡaraḡasito. Filipi tu Makedonia tanonai vanuḡa baregona eruḡa-guineto vanuḡana, e Roma ḡeri gabu. Monai ḡaro kotari ḡatanuto. ");
INSERT INTO snc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabadi ai, vanuḡa maḡuna ḡatama bokana na ḡaraka-rosito, ḡaruka rekena ḡana ḡaiaḡoto, ḡai ḡatuḡamaḡito, Iuda tarimari ḡeri ḡauḡau gabuna ta tu monai. Ḡai ḡatanu-tarito, benamo mo ḡaruka rikinai ḡevegogoto vavineri ḡavaḡa-guruḡarito. ");
INSERT INTO snc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Monai eseḡaḡimato-ḡoi vavinena ta arana Lidia, Taiatira vavinena. Ḡia tu voiri barego dabuḡari evoivoi-iaḡirito-ḡoi. Ḡia tu Barau etoma-rakariḡo viniato-ḡoi vavinena. Ḡia Vereḡauka na nuḡana ekeoato, benamo Paulo na kara ekiraḡiato-ḡoi eseḡaḡiato ma eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ḡia ma ḡena numa tarimari ḡesi babatiso ḡeḡabiato murinai, ḡia na enoḡimato, ekirato, “Bema ḡovetuḡamaḡini au tu Vereḡauka ḡenai moḡoni aveḡabidadamani nai tu, si-iaḡo, be au ḡegu numai bitana tanu.” Benamo ḡia na nuḡama eḡanirito, benamo ḡia ḡesi ḡaiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ḡaro ta ḡauḡau gabuna ḡana ḡaiaḡoto-ḡoi nuḡanai, vetuḡunaḡi ḡuiatona ta na edoḡarimato. Ḡia tu iauka rakavana ta na eboroḡiato, ma ḡoirai kara beḡe ḡorani dagarari ekiraḡi-foforirito-ḡoi. Ḡoirai beḡe ḡorani dagarari ekiraḡi-foforirito-ḡoi nai tu, ḡitaḡauna tarimari ḡeri moni ḡutuma evaḡa-ḡorarito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mo ḡuiato na Paulo e ḡai mabarama murima na eiaḡomato, ekoḡoto-ḡoi, maiḡesi ekirato-ḡoi, “Maiḡeri tarima tu Iaru-korokoro Barauna ḡena vetuḡunaḡi tarimari! Vevaḡa-maḡuri kamasi boḡo ḡabiani dabarana varina ḡefiuani.” ");
INSERT INTO snc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ḡaro vovoka moḡesi eveito-ḡoi, eiaḡoto mo, Paulo ebaruto, benamo eruḡa-kureto, mo iauka rakavana ekiraiato, ekirato, “Iesu Keriso aranai au na akiramuni, mani kekeni ḡenana noraka-vaḡi!” Benamo mo horai moḡo iauka rakavana mo ḡuiato ḡenana eraka-vaḡito. ");
INSERT INTO snc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mo ḡuiato ḡitaḡauna tarimari ḡeribato, ḡia ḡeri moni doḡari dabarana ekorito, benamo ḡia na Paulo e Silas ḡeḡabi-taririto, taravatu tauri ḡeri ai maketi gabuna ḡana ḡeinu-iaḡorito. ");
INSERT INTO snc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kota ḡeseḡaḡini tarimari ḡoirari ai ḡevaḡa-ruḡarito vau ḡekirato, “Mai tu Iuda tarimari. Ḡia na ḡita ḡera vanuḡa baregonai rakava ḡevaḡa-ḡoraiani. ");
INSERT INTO snc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ema ḡia na ḡevevaḡa-riba iaḡirini veiḡari ḡita ḡera taravatu na tu asi eḡabi-raḡerini. Ḡita tu Roma tarimara, ḡia ḡeri veiḡa tu asi bita ḡabi-raḡerini e asi bita veirini riba.” ");
INSERT INTO snc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tarimarima ḡutuma-bara ḡia ḡesi ḡekauto, Paulo e Silas ḡeguru-vinirito. Benamo Kota ḡeseḡaḡini tarimari na Paulo e Silas ḡeri dabuḡa ḡedarerito, benamo mo ḡutuma-bara ḡekirarito, beḡene kwariri. ");
INSERT INTO snc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ḡekwari-biruḡa biruḡarito murinai, dibura numai ḡefiu-toḡarito, ema dibura numa ḡitaḡauna tarimana ḡekiraiato, bene ḡitaḡau-ginikauri. ");
INSERT INTO snc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ḡia na mo vevaḡa-naḡi guruḡana eseḡaḡiato, benamo dibura numana nuḡana buroburonai efiu-toḡarito. Kwakuri tu ḡau duduri baregori ma metori vekaravari ai ebaru-taririto. ");
INSERT INTO snc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Boḡi nuḡanai Paulo e Silas tu ḡeḡuriḡurito-ḡoi e Barau vaḡa-raḡena mariri ḡeḡabirito-ḡoi, ma dibura numa tarimari kotari na tu ḡeseḡaḡi-taḡorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Asikauna tano-iaga baregona eraḡasito, dibura numana korana duḡuri maki eḡareva-ḡareva vinubato. Vaḡa-sebo ḡatama-boka mabarari ḡevekeoto, e dibura tarimari ḡebarurito seiniri mabarari ḡeketoketo-vaḡito. ");
INSERT INTO snc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Dibura numana ḡitaḡauna tarimana etataḡato, mo ḡatama-boka mabarari eḡitarito tu vekeo. Ḡena tuḡamaḡi dibura tarimari mabarari tu ḡeraga-lemato etato, benamo ḡena vetari baḡana einu-vaḡiato, ma tauḡena nevevaḡi-mase etato. ");
INSERT INTO snc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Senaḡi Paulo na eḡaba-viniato, ekirato, “Tauḡemu asi novevaḡa-rakava! Ḡai mabarama tu maiḡema!” ");
INSERT INTO snc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dibura numa ḡitaḡauna tarimana kere keari eveito, eraga-toḡato, benamo ma ḡoḡo-ḡoḡona ḡesi Paulo e Silas kwakuri korari ai ea keto-tarito. ");
INSERT INTO snc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Benamo monana eḡori-rosirito ma edanaḡirito, ekirato, “Vere tarimami, au tu kamasi baveini vau maḡuri badoḡariani?” ");
INSERT INTO snc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ḡia na ḡevaḡa-veseato, ḡekirato, “Iesu Vereḡauka bono ḡabidadama-vinia, benamo maḡuri boḡabiani, ḡoi e ḡemu numa tarimari mabarari.” ");
INSERT INTO snc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Benamo ḡia na Vereḡauka ḡena guruḡa, ḡia ma ḡena numa tarimari mabarari ḡesi, ḡeri ḡekiraḡito. ");
INSERT INTO snc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mo boḡi horanai moḡo, dibura numa ḡitaḡauna tarimana na tauri ruarua eḡori-iaḡorito, manuḡari ea ḡuriḡirito, ema ḡia ma ḡena numa tarimari mabarari ḡesi mo boḡi sebonai ḡebabatisorito. ");
INSERT INTO snc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Moḡa murinai ḡia na Paulo e Silas ḡena numa nuḡanai eḡori-toḡarito, benamo ḡaniḡani evinirito, ḡeḡanito. Ma ḡia ma ḡena numa tarimari ḡesi tu iaku na ḡevonuto, korana ḡia toma tu Barau ḡenai ḡeveḡabidadamani. ");
INSERT INTO snc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Boḡiboḡi, Kota ḡeseḡaḡini tarimari na vetuḡunaḡi-iaḡovini tarimari ḡetuḡurito, ḡekirato, “Mani dibura numai tarimari ruarua ḡoa tuḡu-vaḡiri.” ");
INSERT INTO snc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Benamo dibura numa ḡitaḡauna tauna na Paulo ekira-varaiato, ekirato, “Kota ḡeseḡaḡini tarimari na guruḡa beḡe tuḡua, ḡoi e Silas tu baḡana tuḡu-rosimi beḡesi. Moḡa lorinai ḡoraka-rosi ma mainomi ḡesi.” ");
INSERT INTO snc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Senaḡi Paulo na vetuḡunaḡi-iaḡovini tarimari ekirarito, ekirato, “Ḡai tu Roma tarimama, senaḡi ḡia na tarimarima ḡutuma-bara ḡoirari ai ḡai ḡekwari-kavamato moḡo, a ḡema rakava tu asi ḡevetauato, senaḡi dibura numai ḡefiu-toḡamato. Ma initoma tu vekuretoḡai ma ḡetuḡu-rosima ḡetoni? Asiḡina ḡinavaḡi! Ḡia tauḡeri maiḡana beḡene iaḡoma, benamo ḡai beḡenema ḡori-rosima.” ");
INSERT INTO snc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Benamo vetuḡunaḡi-iaḡovini tarimari na mo guruḡa Kota ḡeseḡaḡini tarimari ḡekira-vararito. Ḡia ḡeseḡaḡito Paulo e Silas tu Roma tarimari ai ḡeiaḡoto nai tu ḡegarito. ");
INSERT INTO snc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Benamo ḡeiaḡoto, Paulo e Silas ḡenoḡirito, ḡeri rakava beḡene tuḡamaḡi-fitoḡari. Benamo ḡia tauri ruarua dibura numa na ḡetuḡu-rosirito, e ḡenoḡirito, mo vanuḡa barana beḡene raga-kwanea. ");
INSERT INTO snc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo e Silas na dibura numana ḡeraga-kwaneato, Lidia ḡena numa ḡana ḡeiaḡoto. Monai tarikaka ḡesi ḡevedoḡarito, benamo vevaḡa-gwaḡiḡi guruḡari na ḡevaḡa-kokorerito, benamo ḡerakato. ");
INSERT INTO snc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo e Silas na Amfipoli e Apolonia ḡeraka-vanaḡiato, ḡeiaḡoto mo Tesalonikai ḡeraḡasito. Iuda tarimari ḡeri rubu ta tu monai. ");
INSERT INTO snc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo tu eveito-ḡoi kavana rubu ai eraka-toḡato. Ema Sabadi ḡarori toitoi nuḡari ai, ḡia tu tarimarima ḡesi Buka Veaḡa guruḡari ḡeguruḡa-guruḡa-iaḡirito. ");
INSERT INTO snc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ḡia ḡeri ekiraḡi-ginikauto-ḡoi, e evaḡa-moḡoniato-ḡoi, Keriso tu bemidigu-midiguni e mase na ma bevariḡisi-ḡenoḡoini. Ema ekirato, “Mai Iesu, varina ḡomi ḡemi afiuani tarimana, tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna).” ");
INSERT INTO snc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iuda tarimari kotari na mo guruḡa ḡevaḡa-moḡoniato, benamo Paulo e Silas ḡesi ḡesebonato. Ema Barau ḡetoma-rakariḡo viniato-ḡoi Grik tarimari ḡutuma lelevaḡi e vanuḡai ḡeri dagi barego vavineri ḡutuma maki ḡia ḡesi ḡesebonato. ");
INSERT INTO snc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Senaḡi Iuda tarimari tu ḡemamato, benamo voivoi gabunai seḡafore lelevaḡi tarimari kotari ḡeḡabi-vegogorito, seḡafore doḡorona ta ḡesinaiato. Benamo ḡia na gururaḡe e vevaḡi baregona vanuḡa barana nuḡanai ḡeveiato. Ma Iason ḡena numa ḡeraḡeato, Paulo e Silas beḡene doḡariri, be tarimarima ḡoirari ai beḡene ḡori-rosiri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Senaḡi asi ḡedoḡaririto, benamo Iason e tarikaka kotari ḡeinu-iaḡorito, vanuḡa ḡitaḡauna tauri ḡoirari ḡana, ma koḡori ḡesi ḡekirato, “Tanobara mabarari ai mai tarima na rakava ḡevaḡa-ḡoraiani, ma toma tu mai ḡana beḡe iaḡoma, ");
INSERT INTO snc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","benamo Iason na ḡena numai eḡita-ḡaurini. Ḡia na Kaisara ḡena taravatu ḡekiraḡi-fitoḡaiani, korana tu ḡekirani, vere barana ta ma ḡetoni. Ḡekirani, mo vere arana tu Iesu.” ");
INSERT INTO snc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vanuḡa tarimari e ḡitataḡona tarimari na mo guruḡa ḡeseḡaḡiato nai, ḡeri daradara ebaregoto. ");
INSERT INTO snc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Benamo ḡia na Iason ma karona ḡesi ḡevaḡa-fainirito moḡo, benamo ḡetuḡu-rakarito. ");
INSERT INTO snc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Eboḡito nai tu asikauna tarikaka na Paulo e Silas Berea ḡana ḡeraga-tuḡu-rakarito. Bereai ḡea raḡasito nai tu ḡeiaḡoto, Iuda tarimari ḡeri rubu ḡana. ");
INSERT INTO snc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bereai tarimarima tu tarima namori, dia Tesalonika tarimari kavari. Ḡia na Barau ḡena guruḡa ḡeseḡaḡiato-ḡoi nai, ḡeura-iaḡi baregoato-ḡoi. Ema ḡaro mabarari ai Buka Veaḡa nuḡanai kara Paulo na ekiraḡiato-ḡoi ḡevetauato-ḡoi. Korana tu ḡeurato-ḡoi beḡene riba, Paulo na kara ekiraḡiato-ḡoi guruḡari tu moḡoni ba, beḡene vaḡa-moḡoniri ḡana. ");
INSERT INTO snc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Iuda tarimari ḡutuma Iesu Keriso ḡevaḡa-moḡoniato; ema Grik vavineri barego-baregori kotari na e Grik tauri ḡutuma maki Iesu Keriso ḡevaḡa-moḡoniato. ");
INSERT INTO snc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Senaḡi Iuda tarimari Tesalonikai ḡeseḡaḡito, Paulo tu Bereai Barau ḡena guruḡa eḡobata-iaḡiato-ḡoi. Benamo ḡeiaḡoto, vanuḡa tarimari nuḡari ḡea ḡanirito e ḡekira-vaisi vaisirito. ");
INSERT INTO snc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Benamo Paulo tu asikauna tarikaka na kone ḡana ḡetuḡu-rakaiato; a Silas ema Timoteo tu Bereai ḡetanuto. ");
INSERT INTO snc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paulo ḡekava-iaḡoato tauri na ḡeḡori-iaḡoato mo Atena. Monana ma ḡeḡenoḡoito Berea ḡana. Ḡia ḡeḡenoḡoito nai tu, Paulo ḡena keakau guruḡana ta maki ḡeḡwaiato, ekirato, Silas e Timoteo ḡia ḡenai beḡene iaḡo-ḡarimoḡi etato. ");
INSERT INTO snc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenai, Paulo na Silas e Timoteo evaḡa-nogarito-ḡoi nuḡanai, mo vanuḡa baregona eḡitaiato tu kwaivakuku na ḡevaḡa-vonuato. Benamo ḡia nuḡana emeto-rakavato. ");
INSERT INTO snc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Moḡa lorinai eiaḡoto Iuda tarimari ḡeri rubu ḡana, Iuda tarimari e irau bese tarimari Barau ḡetoma-rakariḡo viniato-ḡoi tarimari ḡesi ḡeguruḡa-guruḡato. Ema ḡaro mabarari ai maketi ai ḡeraka-refoto-ḡoi tarimari evaḡa-guruḡarito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vevaḡa-riba tauri irauri, ḡeri orea ḡekiraḡirito-ḡoi tu Epikurea ema Stoiki, na Paulo ḡeḡoitaḡoato, benamo ḡevaḡa-veḡare veḡareato. Ḡia kotari ḡevedanaḡito, ḡekirato, “Mai muru-babo tu kara ekiraḡiani?” Ma kotari ḡevaḡa-veseto, ḡekirato, “Ḡia mai tu noḡa moḡo barau irauri ekiraḡirini.” Ḡia moḡesi ḡekirato, korana Paulo tu Iesu e ḡena variḡisi-ḡenoḡoi varina eḡobata-iaḡiato-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Benamo ḡia na Paulo ḡeḡabiato, Areopago ḡorona ḡana ḡeḡori-iaḡoato, kanisoro ḡevegogoto-ḡoi gabuna ḡana. Benamo monai ḡekiraiato, ḡekirato, “Ḡai ḡaurani tu ḡariba, mai vevaḡa-riba variḡuna oveiani tu kara okiraḡiani? ");
INSERT INTO snc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ḡoi na guruḡa tari okiraḡirini tu ḡai na asi ḡaseḡaḡirini dagarari, naima ḡai ḡaurani tu aniri baḡana ribari.” ");
INSERT INTO snc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Korana Atena tarimari mabarari e irau gabu tarimari monai ḡetanuni tu, ḡauvei ta asi ḡeveiato-ḡoi, senaḡi ḡia ḡeri veiḡa sebona tu ḡaro mabarari ai mo guruḡa variḡuri moḡo ḡekiraḡi-taḡorito-ḡoi e ḡeseḡaḡi-taḡorito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Benamo Paulo tu Areopago vegogona nuḡana na eruḡa-vaisito, benamo ekirato, “Atena tarimami! Au na ḡomi aḡitamini, ḡomi tu ḡemi barau ḡeri ai ḡovetuḡamaḡikau-barego korikorini. ");
INSERT INTO snc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Korana ḡemi vanuḡai arakaorakaoni e ḡemi toma-rakariḡo gaburi aḡitarito nai tu, au na fata veaḡana ta aḡitaiato, iatanai tu mai guruḡa ḡetoreato, ‘ASI RIBAMA BARAUNA ḠENA.’ Moḡa lorinai mo asi ribami Barauna, ḡomi na ḡotoma-rakariḡo viniani tu, toma au na akira-varamini. ");
INSERT INTO snc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tanobara e tanobara nuḡanai ḡetanuni dagarari mabarari eveirito Barauna tu guba e tanobara verena. Ḡia tu tarimarima ḡimari na ḡeragarito rubu veaḡari ai tu asi etanuni. ");
INSERT INTO snc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ḡia tu dagara tai asi erabuto, be tarimarima ḡimari na ḡia ḡena tu asi beḡe veiani riba. Ḡia tauḡena na tarimarima mabarari maḡuri evinirini, iaḡari ema dagara mabarari evinirini. ");
INSERT INTO snc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tarima sebona ḡenana ḡia na tarimarima beseri mabarari evaḡa-ḡorarito, ema tanobara mabarana beḡene tanu-iaḡia etato. Ḡia tauḡena na ḡeri maḡuri laḡaniri ema ḡeri tanu gaburi korikori eboioḡa-guinerito. ");
INSERT INTO snc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Barau na moḡesi eveiato, korana ḡia beḡene ḡita-vetaua ḡana; ema beḡene vetau-kokore kokorea, benamo beḡene doḡaria. Oba, Barau e ḡita tata vefakara tu asi manaḡa. ");
INSERT INTO snc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Korana ḡita tu, ḡia koranai tamaḡurini, taḡareva-ḡarevani e roḡo tamaḡuri-taḡoni.’ Ḡemi mari ḡegarani e ḡesisiba-iaḡirini tauri na ḡekiraḡiato kavana, ḡekirato, ‘Ḡita maki ḡia natuna.’ ");
INSERT INTO snc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ḡita tu Barau natuna lorinai, asi bitana tuḡamaḡi, Barau tu golo, silva, o fore, tarimarima ḡena boioḡai ema ribai ekororito dagarari kavana. ");
INSERT INTO snc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Guinenai tarimarima tu asi ḡeri ribamaoro nai, Barau na moḡeri tu eḡita-ragakwanerito. Senaḡi toma tu, ḡia na tarimarima mabarari gabu mabarari ai ekirarini, beḡene vetuḡamaḡi-kure. ");
INSERT INTO snc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Korana ḡia na ḡaro ta ekiraḡi-toreato, mo ḡaro ai ḡena ḡabiviriḡi tarimana na tanobarai vevaḡa-maoro beveiani ma iobukaiobukana ḡesi. Barau na mo tau evaḡa-moḡoniato tarimarima mabarari ḡoirari ai, vetoḡana tu mase na evaḡa-variḡisi ḡenoḡoiato.” ");
INSERT INTO snc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mase na variḡisi-ḡenoḡoina guruḡana ḡeseḡaḡito nai, kotari na tu Paulo ḡerikiriki-iaḡiato. Ma kotari tu ḡekirato, “Ḡai ḡaurani tu, mo vari ḡema ma nokiraḡi-ḡenoḡoia.” ");
INSERT INTO snc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Benamo Paulo na mo vegogo eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Senaḡi tau lakouna tu ḡia ḡesi ḡerakakauto e Barau ḡenai ḡeveḡabidadamato. Ḡia fakari ai tu Dionisio, ḡia tu Areopago ḡoro ai ḡevegogoto-ḡoi tarimana ta, e vavine ta arana Damari, ema tarima kotari maki. ");
INSERT INTO snc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Moḡa murinai Paulo na Atena eraga-kwaneato, Korinto ḡana eiaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Monai ḡia na Iuda tarimana arana Akwila eḡoitaḡoato. Akwila tu Ponto ai emaḡurito. Ḡia tu ḡaraḡona Priskila ḡesi Itali na vau ḡeraḡasito. Ḡia Itali na ḡeiaḡomato, korana tu Klaudio na Iuda tarimari mabarari ekirarito, Roma beḡene raga-kwanea. Paulo eiaḡoto ḡia ḡeri ai, ea ḡitarito. ");
INSERT INTO snc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ḡia maki Akwila ma ḡaraḡona ḡesi kavana farai numari eturito-ḡoi. Moḡa lorinai Paulo monai tu ḡia tauri ruarua ḡesi etanuto-ḡoi ema ḡeḡauvei-vegogoto-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabadi mabarari ai tu Iuda tarimari ḡeri rubu ai eḡobatato-ḡoi, Iuda e Grik tarimari nuḡari neḡabiri uranai. ");
INSERT INTO snc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas e Timoteo Makedonia na ḡeraḡasito nai, Paulo tu Barau ḡena guruḡa eḡobata-iaḡiato-ḡoi ḡaro mabaranai, Iuda tarimari ḡeri ai ekiraḡi-foforiato-ḡoi, Iesu tu moḡoni Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Senaḡi Iuda tarimari na Paulo ḡena guruḡa ḡevaḡa-ḡenoḡoiato, e guruḡa asi namori ḡenai ḡekira-veḡare veḡareato nai, Paulo na ḡena dabuḡa ekorakoraiato ḡia ḡoirari ai vauro evaḡa-guruḡa gwaḡiḡi-vinirito, ekirato, “Ḡomi rarami verebana tu tauḡemi iatami ai! Au ḡegu ai vereba ta asiḡina. Toma au tu aiaḡoni irau bese tarimari ḡeri ai.” ");
INSERT INTO snc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Benamo mo rubu na eraka-rosito, eiaḡoto, irau bese tarimana arana Titio Iusto ḡena numa ḡana. Titio tu Barau etoma-rakariḡo viniato-ḡoi tarimana, ma ḡena numa tu rubu sebinai moḡo. ");
INSERT INTO snc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispo, rubu ḡorikauna tarimana e ḡena numa tarimari mabarari ḡesi tu Vereḡauka ḡeḡabidadama-viniato-ḡoi. Ema Korinto tarimari ḡutuma na maki vari ḡeseḡaḡiato, benamo ḡevaḡa-moḡoniato ema babatiso ḡeḡabito. ");
INSERT INTO snc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Boḡi tai Vereḡauka na Paulo mata-vanaḡi ai evaḡa-guruḡaiato, ekirato, “Asi bono gari, murumu asi bene kafu, bono guruḡa! ");
INSERT INTO snc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Korana au tu ḡoi ḡesi bene; ta na asi beiaḡo-vinimuni e asi bevaḡa-rakavamuni riba, korana au ḡegu tarimarima tu ḡutuma mai vanuḡa baregonai.” ");
INSERT INTO snc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Moḡa lorinai Paulo monai etanuto laḡani ta e ḡue imaima sebona (6); Barau ḡena guruḡa tarimarima evaḡa-riba iaḡirito-ḡoi. ");
INSERT INTO snc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio tu Akaia tanona ḡeri gavana ḡauveina eveito-ḡoi nuḡanai, Iuda tarimari ḡeḡaru-vegogoto, Paulo ḡeḡabi-tariato, Kota gabuna ḡana ḡeḡori-iaḡoato. ");
INSERT INTO snc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ḡekirato, “Mai tarima na tarimarima nuḡari eḡanirini, ma taravatu na asi ekiraḡiani maḡurinai Barau beḡene toma-rakariḡo vinia etoni.” ");
INSERT INTO snc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo neguruḡa etato nuḡanai, Galio na Iuda tarimari ekirarito, ekirato, “Ḡomi Iuda tarimami, bema veiḡa rakavana tai o kerere baregona tai boḡoro samani nai tu, bara seḡaḡi-vinimi riba. ");
INSERT INTO snc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Senaḡi mani veḡareveḡare tu vevaḡa-riba, e ara, ema tauḡemi ḡemi taravatu veḡareveḡareri, naima tauḡemi na boḡono vei-roroḡotori. Au na maniḡesina dagarari Kotai tu asi baseḡaḡirini!” ");
INSERT INTO snc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Benamo ḡia na Kota gabuna na elai-rosirito. ");
INSERT INTO snc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ḡia mabarari na rubu ḡorikauna tarimana, Sostene, ḡeḡabi-tariato, Kota gabuna ḡoiranai benamo ḡekwari-korukoruato. Ma Galio tu eḡitarito senaḡi eboḡe-ḡuiraḡito moḡo. ");
INSERT INTO snc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo Korinto ai tarikaka veḡabidadama nuḡanai tarimari ḡesi tu ḡaro kota vovoka roḡo ma ḡetanuto. Moḡa murinai eraga-kwanerito, benamo Priskila e Akwila ḡesi bouti ta Siria ḡana ḡeiaḡoto. Kenkrea na roḡosi beḡere raka nuḡanai, ḡia tu debana ḡeraroato, korana ḡena kiraḡitore gwaḡiḡina ta Barau ḡenai eveiato nai. ");
INSERT INTO snc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso ai ḡeraḡasito, benamo Paulo na Priskila e Akwila monai eraga-kwanerito. Ḡia tu Iuda tarimari ḡeri rubu ai eraka-toḡato benamo Iuda tarimari ḡesi ḡea guruḡa-guruḡato. ");
INSERT INTO snc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ḡia na ḡenoḡiato, monai Iuda tarimari ḡesi roḡo bene tanu, senaḡi ḡeri noḡinoḡi asi eḡabi-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Senaḡi ḡena rakai tu iniḡesi evaḡa-guruḡarito, ekirato, “Bema Barau beurani nai, ḡomi ḡemi ai ma baḡenoḡoi-iaḡomani.” Benamo bouti ai ea raḡekauto, ma Efeso eraga-kwaneato. ");
INSERT INTO snc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kaisareai eraḡasito nai, kwakuna na Ierusalema ḡana evaraḡeto, ekalesia ḡesi ḡea veḡoitaḡoto vauro, Antioka ḡana evariḡo-iaḡoto. ");
INSERT INTO snc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ḡaro kotari monai etanuto murinai, Galatia e Frigia tanori ḡana eiaḡoto, Iesu ḡekorana-iaḡiato-ḡoi tarimari mabarari gabu tatai ḡetanuto-ḡoi tarimari ea vaḡa-kokorerito. ");
INSERT INTO snc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mo horai Iuda tarimana ta arana Apolos, Alesandria ai emaḡurito tarimana, Efeso ḡana eiaḡoto. Ḡia ḡena riba tu varaḡe lelevaḡi, guruḡai namo vedaurea e Buka Veaḡa maki eriba-ginikau-raḡeato. ");
INSERT INTO snc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ḡia tu Vereḡauka ḡena dabara ḡevaḡa-ribaiato, benamo nuḡana mabarana ḡesi Iesu varina efiuato, e evaḡa-riba-iaḡi ginikauato. Dagara sebona, ḡia tu Ioane ḡena babatiso moḡo eribaiato. ");
INSERT INTO snc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Rubu nuḡanai eḡobatato-ḡoi ma kokorena ḡesi. Monai Priskila e Akwila na ḡeseḡaḡiato, benamo ḡeḡori-kauato, ḡia ḡetanuni numana ḡana ḡeḡori-iaḡoato, monai vauro Barau ḡena dabara moḡonina ḡevaḡa-riba ginikauato. ");
INSERT INTO snc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Benamo Apolos eurato, Akaia ḡana bene iaḡo. Moḡa lorinai tarikaka Efeso ai ḡetanuni na ḡevaḡa-kavaiato, e fefa ta ḡetoreato Akaiai Iesu ḡekorana-iaḡiato-ḡoi tarimari ḡeri, ḡenoḡirito, Apolos eiaḡoni nai beḡene ḡabi-raḡea. Apolos ea raḡasito nai tu, Barau ḡena varevare-bara ḡenana Barau ḡevaḡa-moḡoniato tarimari tu vevaḡa-kava barego Apolos ḡenana ḡedoḡariato. ");
INSERT INTO snc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Korana ḡena guruḡa kokoreri ḡerina Iuda tarimari evaḡa-ketorito tarimarima ḡutuma ḡoirari ai, Apolos na Buka Veaḡa na ḡeri evaḡa-moḡoniato-ḡoi Iesu tu Keriso, (Barau na ekiraḡi-toreato vevaḡa-maḡuri tauna). ");
INSERT INTO snc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos tu Korinto ai etanuto-ḡoi nai, Paulo gunika rekena na eiaḡoto mo Efeso ai ea raḡasito. Monai Iesu ḡekorana-iaḡiato-ḡoi tarimari tari edoḡaririto, ");
INSERT INTO snc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","benamo edanaḡirito, ekirato, “Iesu ḡenai ḡoveḡabidadamato nai, Iauka Veaḡa ḡoḡabiato ba?” Ḡia ḡevaḡa-veseto, ḡekirato, “Asiḡina, ḡai tu Iauka Veaḡa maki etanuni guruḡana ta tu roḡosi maki baḡana seḡaḡia.” ");
INSERT INTO snc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Benamo Paulo na ma edanaḡirito, ekirato, “Be ḡomi na tu kamara babatiso ḡoḡabiato?” Ḡia ḡevaḡa-veseto, ḡekirato, “Ioane ḡena babatiso.” ");
INSERT INTO snc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Benamo Paulo ekirato, “Ioane tu rakava ḡerina ḡevetuḡamaḡi-kureto tarimari ebabatisorito, ema Isaraela tarimari ekirarito, ḡia murina na beiaḡomani tarimana beḡene ḡabidadama-vinia, mo tu Iesu.” ");
INSERT INTO snc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mo guruḡa ḡeseḡaiato nai, Vereḡauka Iesu aranai babatiso ḡeḡabiato. ");
INSERT INTO snc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo ḡimana ḡia iatari ai etore-kaurito nai tu, Iauka Veaḡa emariḡoto ḡia iatari ai. Benamo garo irauirau ai ḡeguruḡato, e Barau na ḡia ḡeri ai evaḡa-foforirito guruḡari ḡevari-fiurito. ");
INSERT INTO snc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tauri mabarari tu gabanana ruarua (12) kavana. ");
INSERT INTO snc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo monai ḡue toitoi etanuto. Ma vanaḡivanaḡi rubu ai eraka-toḡato-ḡoi, Barau ḡena Basileia, (ḡena veḡitaḡau seḡukana evaḡa-ruḡaiani maiḡa), eḡobata-iaḡiato-ḡoi ma kokorena ḡesi, ema tarimarima ḡesi ḡeguruḡa-iaḡiato-ḡoi e nuḡari eḡanirito-ḡoi. ");
INSER