﻿USE sofia;
DROP TABLE IF EXISTS sofia.sna_vpl;
CREATE TABLE sna_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sna_vpl WRITE;
INSERT INTO sna_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pakutanga Mwari akasika matenga nenyika. ");
INSERT INTO sna_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Zvino nyika yakanga isina kugadzirwa uye isina chinhu, rima rakanga riri pamusoro pemvura yakadzika, uye Mweya waMwari wakanga uchigara pamusoro pemvura. ");
INSERT INTO sna_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Uye Mwari akati, “Chiedza ngachivepo,” chiedza chikavapo. ");
INSERT INTO sna_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mwari akaona kuti chiedza chakanga chakanaka, uye akaparadzanisa chiedza nerima. ");
INSERT INTO sna_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mwari akatumidza chiedza kuti “masikati,” uye rima akaritumidza kuti “usiku.” Uye madekwana akavapo, namangwanani akavapo, zuva rokutanga. ");
INSERT INTO sna_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Uye Mwari akati, “Ngapave nenzvimbo pakati pemvura kuti iparadzanise mvura nemvura.” ");
INSERT INTO sna_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Saka Mwari akaita nzvimbo uye akaparadzanisa mvura yakanga iri pasi penzvimbo iyi kubva pamvura yakanga iri pamusoro payo. Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mwari akatumidza nzvimbo iyi kuti “denga.” Uye madekwana akavapo, namangwanani akavapo, zuva rechipiri. ");
INSERT INTO sna_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Uye Mwari akati, “Mvura iri pasi pedenga ngaiungane panzvimbo imwe chete, uye pasi pakaoma ngapaonekwe.” Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mwari akatumidza pasi pakaoma kuti, “nyika,” uye mvura yakaungana akaiti “makungwa.” Uye Mwari akaona kuti zvakanga zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ipapo Mwari akati, “Nyika ngaimerese uswa: miriwo inobereka mbeu nemiti panyika inobereka michero ine mhodzi mukati mayo, maererano nemhando dzayo dzakasiyana-siyana.” Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nyika yakameresa uswa: miriwo inobereka mbeu maererano nemhando dzayo nemiti inobereka michero ine mhodzi mukati mayo, maererano nemhando dzayo. Uye Mwari akaona kuti zvakanga zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Uye madekwana akavapo, namangwanani akavapo, zuva rechitatu. ");
INSERT INTO sna_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Uye Mwari akati, “Ngakuve nezviedza munzvimbo yedenga kuti zviparadzanise masikati kubva pausiku, uye ngazvishande sezviratidzo zvokucherechedza mwaka namazuva namakore, ");
INSERT INTO sna_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","uye ngazvive zviedza munzvimbo yedenga kuti zvivhenekere panyika.” Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mwari akaita zviedza zvikuru zviviri, chiedza chikuru kuti chibate ushe masikati uye chiedza chiduku kuti chibate ushe usiku. Akaitawo nyeredzi. ");
INSERT INTO sna_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mwari akazviisa munzvimbo yedenga kuti zvivhenekere panyika, ");
INSERT INTO sna_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kuti zvibate ushe masikati nousiku, uye kuti zviparadzanise chiedza kubva parima. Uye Mwari akaona kuti zvakanga zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Uye madekwana akavapo, namangwanani akavapo, zuva rechina. ");
INSERT INTO sna_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Uye Mwari akati, “Mvura ngaive nezvisikwa zvipenyu, uye shiri ngadzibhururuke pamusoro penyika munzvimbo yedenga.” ");
INSERT INTO sna_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Saka Mwari akasika zvisikwa zvikuru zvegungwa nezvipenyu zvose zvinokambaira zvinogara mumvura, maererano namarudzi azvo, uye neshiri dzina mapapiro, maererano namarudzi adzo. Uye Mwari akaona kuti zvakanga zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mwari akazviropafadza akati, “Berekanai muwande muzadze mvura iri mumakungwa, uye shiri ngadziwande panyika.” ");
INSERT INTO sna_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Uye madekwana akavapo, namangwanani akavapo, zuva rechishanu. ");
INSERT INTO sna_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Uye Mwari akati, “Nyika ngaibereke zvisikwa zvipenyu maererano namarudzi azvo: zvipfuwo, zvisikwa zvinokambaira panyika, nezvikara zvesango, chimwe nechimwe nemhando yacho.” Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mwari akaita mhuka dzesango maererano namarudzi adzo, zvipfuwo namarudzi azvo, nezvisikwa zvose zvinokambaira panyika maererano namarudzi azvo. Uye Mwari akaona kuti zvakanga zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ipapo Mwari akati, “Ngatiitei munhu nomufananidzo wedu, akafanana nesu, uye ngavave nesimba pamusoro pehove dzegungwa napamusoro peshiri dzedenga, napamusoro pemombe, napamusoro penyika yose, uye napamusoro pezvisikwa zvose zvinokambaira panyika.” ");
INSERT INTO sna_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Saka Mwari akasika munhu nomufananidzo wake, akamusika mumufananidzo waMwari; akavasika murume nomukadzi. ");
INSERT INTO sna_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mwari akavaropafadza akati kwavari, “Berekanai muwande; zadzai nyika uye mubate ushe pamusoro payo. Muve nesimba pamusoro pehove dzegungwa napamusoro peshiri dzedenga napamusoro pezvisikwa zvipenyu zvinokambaira panyika.” ");
INSERT INTO sna_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ipapo Mwari akati, “Ndinokupai miriwo yose inobereka iri pamusoro penyika yose nemiti yose ine michero, ine mhodzi mukati mayo. Zvichava zvokudya zvenyu. ");
INSERT INTO sna_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Uye kumhuka dzose dzapanyika neshiri dzose dzedenga nokuzvisikwa zvose zvinokambaira panyika, zvose zvinofema, ndinozvipa miriwo minyoro kuti zvive zvokudya zvazvo.” Uye zvakaita saizvozvo. ");
INSERT INTO sna_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mwari akaona zvose zvaakanga aita, kuti zvakanga zvakanaka kwazvo. Uye madekwana akavapo, namangwanani akavapo, zuva rechitanhatu. ");
INSERT INTO sna_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Naizvozvo matenga nenyika zvakapera mukushongedzwa kukuru kwazvo kwose. ");
INSERT INTO sna_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pazuva rechinomwe Mwari akanga apedza basa raakanga achiita; saka pazuva rechinomwe akazorora pamabasa ake ose. ");
INSERT INTO sna_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Uye Mwari akaropafadza zuva rechinomwe akariita dzvene nokuti pazuva iro akazorora pabasa rose rokusika raakanga aita. ");
INSERT INTO sna_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iyi ndiyo rondedzero yamatenga nenyika pazvakasikwa. Jehovha Mwari paakaita nyika namatenga, ");
INSERT INTO sna_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","uye kwakanga kusati kwava namakwenzi esango panyika, uye miriwo yesango yakanga isati yamera, nokuti Jehovha Mwari akanga asati anayisa mvura panyika uye kwakanga kusina munhu wokuzorima panyika, ");
INSERT INTO sna_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","asi hova dzaibuda dzichibva pasi uye dzichinyorovesa pasi pose, ");
INSERT INTO sna_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Jehovha Mwari akaumba munhu kubva paguruva revhu uye akafemera mweya woupenyu mumhino dzake, uye munhu akava mupenyu. ");
INSERT INTO sna_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Zvino Jehovha Mwari akanga adyara bindu kumabvazuva, muEdheni; uye akaisa munhu waakanga aumba imomo. ");
INSERT INTO sna_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Uye Jehovha Mwari akaita mhando dzose dzemiti kuti dzimere kubva muvhu, miti yaifadza meso uye yakanga yakanaka pakudya. Pakati pebindu pakanga pano muti woupenyu nomuti wokuziva zvakanaka nezvakaipa. ");
INSERT INTO sna_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Rwizi rwaidiridza bindu rwaiyerera ruchibva muEdheni; kubva imomo rwakaparadzana rukava hova ina. ");
INSERT INTO sna_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Zita rerwokutanga ndiPishoni; runopoterera nomunyika yose yeHavhira, imomo mune goridhe. ");
INSERT INTO sna_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Goridhe romunyika iyoyo rakanaka; uyewo dheriamu nebwe reonikisi zvirimo.) ");
INSERT INTO sna_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Zita rorwizi rwechipiri ndiGihoni; runopoterera nomunyika yose yeEtiopia. ");
INSERT INTO sna_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Zita rorwizi rwechitatu ndiTigirisi; runoyerera ruchitevedza rutivi rwamabvazuva eAshuri. Uye rwizi rwechina ndiYufuratesi. ");
INSERT INTO sna_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jehovha Mwari akatora munhu akamuisa mubindu reEdheni kuti aririme nokurichengeta. ");
INSERT INTO sna_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Uye Jehovha Mwari akarayira munhu achiti, “Wakasununguka kuti udye zvinobva pamuti upi zvawo uri mubindu; ");
INSERT INTO sna_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","asi haufaniri kudya zvinobva pamuti wokuziva zvakanaka nezvakaipa, nokuti pauchaudya uchafa zvirokwazvo.” ");
INSERT INTO sna_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Jehovha Mwari akati, “Hazvina kunaka kuti munhu agare ari oga. Ndichamuitira mubatsiri akamukwanira.” ");
INSERT INTO sna_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Zvino Jehovha Mwari akanga aumba kubva muvhu, mhuka dzose dzesango neshiri dzose dzedenga. Akazviuyisa kumunhu kuti aone kuti achazvitumidza mazita api, uye chisikwa chipenyu chimwe nechimwe sezvachakatumidzwa nomunhu, ndiro rakava zita racho. ");
INSERT INTO sna_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Saka munhu akatumidza mazita kuzvipfuwo zvose, nokushiri dzose dzedenga nemhuka dzose dzesango. Asi kuna Adhamu kwakanga kusina kuwanikwa mubatsiri akamukwanira. ");
INSERT INTO sna_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Saka Jehovha Mwari akaita kuti munhu avate hope huru; uye paakanga achakavata, akatora rumwe rumbabvu rwomunhu akavhara nenyama nzvimbo yaakarubvisa. ");
INSERT INTO sna_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ipapo Jehovha Mwari akaita mukadzi kubva parumbabvu rwaakanga abvisa pamunhu, uye akamuuyisa kumurume. ");
INSERT INTO sna_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Murume akati, “Zvino uyu ibvupa ramapfupa angu nenyama yenyama yangu; achanzi ‘mukadzi’, nokuti akatorwa kubva pamurume.” ");
INSERT INTO sna_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nokuda kwechikonzero ichi, murume achasiya baba namai vake agonamatira kumukadzi wake, uye vachava nyama imwe. ");
INSERT INTO sna_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Murume nomukadzi wake vakanga vasina kusimira vose, uye havana kutongonyara. ");
INSERT INTO sna_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Zvino nyoka yakanga ina manomano kupfuura mhuka dzose dzakasikwa naJehovha Mwari. Yakati kumukadzi, “Ko, chaizvoizvo Mwari akati, ‘Hamufaniri kudya muti upi zvawo uri mubindu here’?” ");
INSERT INTO sna_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mukadzi akati kunyoka, “Tingadya hedu michero inobva mumiti iri mubindu, ");
INSERT INTO sna_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","asi Mwari akati, ‘Hamufaniri kudya muchero unobva pamuti uri pakati pebindu, uye musaubata kuti murege kufa.’ ” ");
INSERT INTO sna_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka yakati kumukadzi, “Hamungafi zvirokwazvo. ");
INSERT INTO sna_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nokuti Mwari anoziva kuti mukaudya meso enyu achasvinudzwa, uye muchaita saMwari mugoziva zvakanaka nezvakaipa.” ");
INSERT INTO sna_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mukadzi akati aona kuti muchero womuti wakanga wakanaka kuudya uye kuti waifadza meso, uye kuti waidikanwa kuti munhu ave nouchenjeri, akatora mumwe akadya. Akapawo mumwe kumurume wake, uyo akanga anaye, naiye akaudya. ");
INSERT INTO sna_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ipapo meso avo vose vari vaviri akasvinudzwa, uye vakaziva kuti vakanga vasina kusimira; saka vakasonanidza mashizha omuonde pamwe chete ndokuzvigadzirira nguo. ");
INSERT INTO sna_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ipapo murume nomukadzi wake vakanzwa inzwi raJehovha Mwari paakanga achifamba mubindu kwotonhorera, vakavanda pamberi paJehovha Mwari, pakati pemiti yomubindu. ");
INSERT INTO sna_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Asi Jehovha Mwari akadana murume akati, “Uripiko?” ");
INSERT INTO sna_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Akapindura akati, “Ndanzwa inzwi renyu mubindu, uye ndatya nokuti ndanga ndisina kusimira; saka ndavanda.” ");
INSERT INTO sna_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Uye iye akati, “Ndiani akuudza kuti hauna kusimira? Wadya kanhi muti wandakakurayira kuti urege kudya?” ");
INSERT INTO sna_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Murume akati, “Mukadzi wamakandipa kuno kuti ave neni, ndiye andipa mumwe muchero womuti, uye ini ndikadya.” ");
INSERT INTO sna_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ipapo Jehovha Mwari akati kumukadzi, “Chiiko ichi chawaita?” Mukadzi akati, “Nyoka yandinyengera, ndikadya.” ");
INSERT INTO sna_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Saka Jehovha Mwari akati kunyoka, “Nokuti waita izvi, “Watukwa kupfuura zvipfuwo zvose, kupfuura mhuka dzose dzesango! Uchafamba nedumbu rako uye uchadya guruva mazuva ose oupenyu hwako. ");
INSERT INTO sna_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Uye ndichaisa ruvengo pakati pako nomukadzi, uye pakati porudzi rwako nerwomukadzi; achapwanya musoro wako, uye iwe ucharuma chitsitsinho chake.” ");
INSERT INTO sna_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kumukadzi akati, “Ndichawedzera kwazvo kurwadziwa kwako mukubereka vana; uchabereka vana mukurwadziwa. Kuda kwako kuchava kumurume wako, uye achava nesimba pamusoro pako.” ");
INSERT INTO sna_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kuna Adhamu akati, “Nokuti wakateerera kumukadzi wako uye ukadya zvakabva pamuti wandakakurayira ndichiti, ‘Haufaniri kuudya,’ “Ivhu ratukwa nokuda kwako; mukushanda kunorwadza, uchadya zvibereko zvaro mazuva ose oupenyu hwako. ");
INSERT INTO sna_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Richakuberekera minzwa norukato, uye uchadya miriwo yomusango. ");
INSERT INTO sna_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Neziya rechiso chako uchadya zvokudya zvako kusvikira wadzokera kuguruva, sezvo wakatorwa kwariri; nokuti uri guruva, kuguruva uchadzokera.” ");
INSERT INTO sna_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Uye Adhamu akatumidza mukadzi wake kuti Evha, nokuti aizova mai vavapenyu vose. ");
INSERT INTO sna_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Jehovha Mwari akaitira Adhamu nomukadzi wake nguo dzamatehwe uye akavafukidza. ");
INSERT INTO sna_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Uye Jehovha Mwari akati, “Munhu ava somumwe wedu, anoziva zvakanaka nezvakaipa. Haafaniri kutenderwa kutambanudza ruoko rwake kuti atorewo zvinobva pamuti woupenyu uye kuti azvidye, akazorarama nokusingaperi.” ");
INSERT INTO sna_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Saka Jehovha Mwari akamudzinga mubindu reEdheni kuti arime ivhu raakatorwa kwariri. ");
INSERT INTO sna_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mushure mokunge adzinga munhu, akaisa makerubhi kurutivi rwokumabvazuva kweBindu reEdheni nomunondo unopfuta uye uchivheyeswa mberi neshure kuti urinde nzira inoenda kumuti woupenyu. ");
INSERT INTO sna_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adhamu akarara nomukadzi wake Evha, uye akava nemimba akabereka Kaini. Akati, “Norubatsiro rwaJehovha, ndabereka murume.” ");
INSERT INTO sna_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mushure akabereka mununʼuna wake Abheri. Zvino Abheri aiva mufudzi wamakwai, uye Kaini aiva murimi wevhu. ");
INSERT INTO sna_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mukufamba kwenguva, Kaini akauya nezvimwe zvezvibereko zvevhu sechipiriso kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Asi Abheri akauya nomugove wamafuta aibva mumhongora dzamakwai. Jehovha akagamuchira Abheri nechipiriso chake, ");
INSERT INTO sna_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","asi Kaini nechipiriso chake haana kumugamuchira. Saka Kaini akatsamwa zvikuru, uye chiso chake chikaunyana. ");
INSERT INTO sna_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ipapo Jehovha akati kuna Kaini, “Wakatsamweiko? Seiko chiso chako chakaunyana? ");
INSERT INTO sna_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kana ukaita zvakanaka, haungagamuchirwi here? Asi kana usingaiti zvakanaka, chivi chakakuvandira pamukova wako; chinoda kukubata, asi iwe unofanira kuchikunda.” ");
INSERT INTO sna_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Zvino Kaini akati kumununʼuna wake, “Ngatimbobuda tiende kumunda.” Uye vakati vari mumunda Kaini akarwisa mununʼuna wake Abheri akamuuraya. ");
INSERT INTO sna_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ipapo Jehovha akati kuna Kaini, “Aripiko mununʼuna wako Abheri?” Iye akati, “Handizivi. Ko, ndini muchengeti womununʼuna wangu here?” ");
INSERT INTO sna_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jehovha akati, “Waiteiko? Inzwa! Ropa romununʼuna wako riri kudanidzira kwandiri richibva muvhu. ");
INSERT INTO sna_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Zvino watukwa uye wadzingwa panyika yazarura muromo wayo kuti imedze ropa romununʼuna wako kubva paruoko rwako. ");
INSERT INTO sna_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Paunorima ivhu, harichazombokuberekeri zvibereko zvaro. Uchava mudzungairi asingatongozorori panyika.” ");
INSERT INTO sna_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini akati kuna Jehovha, “Kurangwa kwangu kunopfuura zvandinokwanisa kutakura. ");
INSERT INTO sna_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nhasi muri kundidzinga kubva panyika, uye ndichavanzwa pamberi penyu; ndichava mudzungairi asina zororo panyika, uye ani naani achandiwana achandiuraya.” ");
INSERT INTO sna_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Asi Jehovha akati kwaari, “Kwete hazvingadaro; kana munhu upi zvake akauraya Kaini, achatsiviwa kanomwe.” Ipapo Jehovha akaisa rupau pana Kaini kuitira kuti kurege kuva nomunhu anenge amuwana angazomuuraya. ");
INSERT INTO sna_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Saka Kaini akabva pamberi paJehovha akandogara munyika yeNodhi, kumabvazuva kweEdheni. ");
INSERT INTO sna_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini akarara nomukadzi wake, akava nemimba akamuberekera Enoki. Ipapo Kaini akanga achivaka guta, uye akaritumidza zita romwanakomana wake Enoki. ");
INSERT INTO sna_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki akaberekerwa Iradhi, uye Iradhi akanga ari baba vaMehujaeri, uye Mehujaeri akanga ari baba vaMetushaeri, uye Metushaeri akanga ari baba vaRameki. ");
INSERT INTO sna_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rameki akawana vakadzi vaviri, mumwe ainzi Adha uye mumwe ainzi Zira. ");
INSERT INTO sna_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adha akabereka Jabhari, ndiye akanga ari baba vavaya vanogara mumatende vaichengeta zvipfuwo. ");
INSERT INTO sna_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Zita romununʼuna wake rainzi Jubhari; akanga ari baba wavose vanoridza rudimbwa nenyere. ");
INSERT INTO sna_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zira akanga ane mwanakomana, Tubhari-Kaini, aigadzira nhumbi dzemhando dzose dzendarira nedzesimbi. Hanzvadzi yaTubhari-Kaini yainzi Naama. ");
INSERT INTO sna_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Rameki akati kuvakadzi vake, “Adha naZira, nditeererei; imi vakadzi vaRameki, inzwai mashoko angu. Ndauraya munhu nokuti andikuvadza, nejaya nokuti randipwanya. ");
INSERT INTO sna_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kana Kaini achitsiviwa kanomwe, naizvozvo Rameki kana makumi manomwe namanomwe.” ");
INSERT INTO sna_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adhamu akararazve nomukadzi wake, akabereka mwanakomana akamutumidza zita rokuti Seti, achiti, “Mwari andipa mumwe mwana panzvimbo yaAbheri, sezvo Kaini akamuuraya.” ");
INSERT INTO sna_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setiwo akava nomwanakomana, akamutumidza zita rokuti Enoshi. Panguva iyo vanhu vakatanga kudana kuzita raJehovha. ");
INSERT INTO sna_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iyi ndiyo rondedzero yakanyorwa yorudzi rwaAdhamu. Mwari paakasika munhu akamuita nomufananidzo waMwari. ");
INSERT INTO sna_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Akavasika murume nomukadzi uye akavaropafadza. Uye vakati vasikwa, akavatumidza kuti “munhu.” ");
INSERT INTO sna_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adhamu akati agara makore zana namakumi matatu, akabereka mwanakomana akafanana naye, akanga akamutodza; akamutumidza zita rokuti Seti. ");
INSERT INTO sna_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Shure kwokuberekwa kwaSeti, Adhamu akararama kwamakore mazana masere uye akaberekazve vamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Pamwe chete, Adhamu akararama kwamakore mazana mapfumbamwe namakumi matatu, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti akati agara makore zana namashanu, akabereka Enoshi. ");
INSERT INTO sna_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Uye shure kwokubereka kwake Enoshi, Seti akararama kwamakore mazana masere namanomwe uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Pamwe chete, Seti akararama kwamakore mazana mapfumbamwe negumi namaviri, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi akati ararama kwamakore makumi mapfumbamwe, akabereka Kenani. ");
INSERT INTO sna_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Uye shure kwokubereka kwake Kenani, Enoshi akararama kwamakore mazana masere ane gumi namashanu uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Pamwe chete, Enoshi akararama kwamakore mazana mapfumbamwe namashanu, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani akati ararama kwamakore makumi manomwe, akabereka Maharareri. ");
INSERT INTO sna_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Uye mushure mokubereka kwake Maharareri, Kenani akagara kwamakore mazana masere namakumi mana uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Pamwe chete, Kenani akararama kwamakore mazana mapfumbamwe negumi, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maharareri akati agara kwamakore makumi matanhatu namashanu, akabereka Jaredhi. ");
INSERT INTO sna_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Uye mushure mokubereka kwake Jaredhi, Maharareri akararama kwamakore mazana masere namakumi matatu uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Pamwe chete, Maharareri akararama kwamakore mazana masere namakumi mapfumbamwe namashanu, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredhi akati ararama kwamakore zana namakumi matanhatu namaviri, akabereka Enoki. ");
INSERT INTO sna_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Uye mushure mokubereka kwake Enoki, Jaredhi akararama kwamakore mazana masere akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Pamwe chete, Jaredhi akararama kwamakore mazana mapfumbamwe namakumi matanhatu namaviri, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoki akati ararama kwamakore makumi matanhatu namashanu, akabereka Metusera. ");
INSERT INTO sna_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Uye mushure mokubereka kwake Metusera, Enoki akafamba naMwari kwamakore mazana matatu uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Pamwe chete, Enoki akararama kwamakore mazana matatu namakumi matanhatu namashanu. ");
INSERT INTO sna_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki akafamba naMwari; ipapo akasazovapo, nokuti Mwari akamutora. ");
INSERT INTO sna_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusera akati ararama kwamakore zana namakumi masere namanomwe, akabereka Rameki. ");
INSERT INTO sna_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Uye mushure mokubereka kwake Rameki, Metusera akararama kwamakore mazana manomwe namakumi masere namaviri uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Pamwe chete, Metusera akararama kwamakore mazana mapfumbamwe namakumi matanhatu namapfumbamwe, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Rameki akati ararama kwamakore zana namakumi masere namaviri, akabereka mwanakomana. ");
INSERT INTO sna_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Akamutumidza zita rokuti Noa uye akati, “Achativaraidza pabasa uye napakurwadziwa kwokubata kwamaoko edu zvinobva pavhu rakatukwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mushure mokuberekwa kwaNoa, Rameki akararama kwamakore mazana mashanu namakumi mapfumbamwe namashanu uye akavazve navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pamwe chete, Rameki akararama kwamakore mazana manomwe namakumi manomwe namanomwe, uye ipapo akafa. ");
INSERT INTO sna_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mushure mokunge Noa ava namakore okuberekwa mazana mashanu, akabereka Shemu, Hamu naJafeti. ");
INSERT INTO sna_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Vanhu vakati vatanga kuwanda panyika uye vanasikana vakaberekwa kwavari, ");
INSERT INTO sna_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","vanakomana vaMwari vakaona kuti vanasikana vavanhu vakanga vakanaka, uye vakazviwanira upi zvake wavakasarudza. ");
INSERT INTO sna_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ipapo Jehovha akati, “Mweya wangu haungarambi uchigara mumunhu nokusingaperi, nokuti inyama; mazuva ake achava makore zana namakumi maviri.” ");
INSERT INTO sna_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","VaNefirimu vakanga vari panyika mumazuva iwayo, uyewo mushure maizvozvo, vanakomana vaMwari vakapinda kuvasikana vavanhu vakaita vana navo. Vakanga vari mhare dzakare, vanhu vaiva nomukurumbira. ");
INSERT INTO sna_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jehovha akaona kuti kuipa kwomunhu panyika kwakanga kuri kukuru sei, uye kuti ndangariro dzomwoyo wake dzakanga dzakaipa bedzi nguva dzose. ");
INSERT INTO sna_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Jehovha akazvidemba kuti akanga aita munhu panyika, uye mwoyo wake wakazara nokurwadziwa. ");
INSERT INTO sna_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Saka Jehovha akati, “Ndichabvisa vanhu pamusoro penyika ivo vanhu vandakaisa, vanhu nemhuka, nezvisikwa zvinokambaira pamusoro pevhu, neshiri dzedenga, nokuti ndinozvidemba kuti ndakazviita.” ");
INSERT INTO sna_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Asi Noa akawana nyasha pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iyi ndiyo rondedzero yezvaNoa. Noa akanga ari munhu akarurama, asina chaanopomerwa pakati pavanhu venguva yake, uye akafamba naMwari. ");
INSERT INTO sna_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa akanga ana vanakomana vatatu vaiti: Shemu, Hamu naJafeti. ");
INSERT INTO sna_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Zvino nyika yakanga yaora pamberi paMwari uye yakanga yazara nokurwisana. ");
INSERT INTO sna_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mwari akaona kuti nyika yakanga yaora sei, nokuti vanhu vose panyika vakanga vaodza nzira dzavo. ");
INSERT INTO sna_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Saka Mwari akati kuna Noa, “Ndava kuzoisa magumo kuvanhu vose, nokuti nyika yazara nokurwisana nokuda kwavo. Zvirokwazvo ndiri kuzovaparadza vose pamwe chete nenyika. ");
INSERT INTO sna_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Saka iwe zviitire areka yomuti womusipuresi; uite makamuri mukati mayo uye uiname nenamo mukati nokunze. ");
INSERT INTO sna_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Uku ndiko kuvaka kwaunofanira kuiita: Areka inofanira kureba makubhiti mazana matatu, upamhi hwayo huve makubhiti makumi mashanu uye makubhiti makumi matatu pakukwirira kwayo. ");
INSERT INTO sna_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Uite windo uchipoteredza areka ugosiya kubhiti rimwe chete kumusoro. Uise mukova parutivi rweareka uye uite muturikidzwa wapasi, wapakati nowapamusoro. ");
INSERT INTO sna_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ndichauyisa mvura yamafashamu pamusoro penyika kuti iparadze zvipenyu zvose pasi pedenga, zvisikwa zvose zvino upenyu mazviri. Zvinhu zvose zviri panyika zvichaparara. ");
INSERT INTO sna_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Asi ndichasimbisa sungano yangu newe, uye uchapinda muareka, iwe navanakomana vako uye nomukadzi wako uye navakadzi vavanakomana vako vari pauri. ");
INSERT INTO sna_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Unofanira kuisa muareka zviviri zviviri pazvisikwa zvipenyu zvose, chikono nechikadzi, kuti zvirarame pamwe chete newe. ");
INSERT INTO sna_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Zviviri zviviri kubva kumhando dzose dzeshiri, nokubva kumhando dzose dzemhuka nokuzvisikwa zvose zvinokambaira panyika, zvichauya kwauri kuti zvichengetwe zviri zvipenyu. ");
INSERT INTO sna_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Unofanira kutora zvokudya zvamarudzi ose zvinofanira kudyiwa ugozvichengeta kuti zvigova zvokudya zvako nezvazvo.” ");
INSERT INTO sna_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa akaita zvose sezvaakanga arayirwa naMwari. ");
INSERT INTO sna_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ipapo Jehovha akati kuna Noa, “Pindai muareka iwe nemhuri yako yose nokuti ndakuona iwe kuti wakarurama murudzi urwu. ");
INSERT INTO sna_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Utore mhando dzemhuka dzose dzakanaka nomwe nomwe, mukono nehadzi yayo uye mbiri mbiri pamhando dzose dzemhuka dzisina kunaka, mukono nehadzi yayo, ");
INSERT INTO sna_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","uyewo nomwe nomwe pamhando dzose dzeshiri, mukono nehadzi, kuti uraramise marudzi azvo akasiyana-siyana munyika yose. ");
INSERT INTO sna_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mazuva manomwe kubva zvino ndichanayisa mvura panyika kwamazuva makumi mana nousiku makumi mana, uye ndichabvisa pamusoro penyika zvisikwa zvipenyu zvose zvandakaita.” ");
INSERT INTO sna_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Uye Noa akaita zvose zvaakarayirwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa akanga ava namakore mazana matanhatu okuberekwa panguva yakanaya mvura yamafashamu panyika. ");
INSERT INTO sna_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Uye Noa navanakomana vake nomukadzi wake navakadzi vavanakomana vake vakapinda muareka kuti vapunyuke pamvura yamafashamu. ");
INSERT INTO sna_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Zviviri zviviri zvemhuka dzakanaka nedzisina kunaka, zviviri zviviri zveshiri nezvezvisikwa zvose zvinokambaira panyika, ");
INSERT INTO sna_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mukono nehadzi, zvakauya kuna Noa ndokupinda muareka, sezvakanga zvarayirwa naMwari kuna Noa. ");
INSERT INTO sna_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Uye shure kwamazuva manomwe mvura yamafashamu yakasvika panyika. ");
INSERT INTO sna_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mugore ramazana matanhatu roupenyu hwaNoa, pazuva regumi namanomwe romwedzi wechipiri, pazuva iro zvitubu zvose zvapakadzika zvakatubuka, uye masuo amafashamu okudenga akazarurwa. ");
INSERT INTO sna_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Uye mvura yakanaya panyika kwamazuva makumi mana nousiku makumi mana. ");
INSERT INTO sna_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Pazuva racho iroro, Noa navanakomana vake, Shemu, Hamu naJafeti, pamwe chete nomukadzi wake navakadzi vavanakomana vake vatatu, vakapinda muareka. ");
INSERT INTO sna_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Vakanga vane mhuka dzose dzesango namarudzi adzo, nezvipfuwo zvose namarudzi azvo neshiri dzose namarudzi adzo, nezvose zvina mapapiro. ");
INSERT INTO sna_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zviviri zviviri pazvisikwa zvose zvino upenyu mazviri zvakauya kuna Noa zvikapinda muareka. ");
INSERT INTO sna_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Mhuka dzaipinda dzaiva mukono nehadzi pazvipenyu zvose, sezvakanga zvarayirwa Noa naMwari. Ipapo Jehovha akamupfigira mukati. ");
INSERT INTO sna_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mafashamu akaramba achingouya panyika kwamazuva makumi mana, uye mvura sezvayakaramba ichiwanda yakasimudza areka pamusoro-soro penyika. ");
INSERT INTO sna_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mvura zhinji yakasimuka uye ikawanda zvikuru panyika, uye areka ikayangarara pamusoro pemvura. ");
INSERT INTO sna_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yakakwira kwazvo pamusoro penyika, uye makomo ose marefu ari pasi pedenga akafukidzwa. ");
INSERT INTO sna_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mvura zhinji yakasimuka ikafukidza makomo kusvikira pamakubhiti gumi namashanu kudzika kubva pamusoro pawo. ");
INSERT INTO sna_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zvipenyu zvose zvinokambaira panyika zvakaparara, shiri, zvipfuwo, mhuka dzesango, zvisikwa zvose zvakafararira pamusoro penyika, namarudzi ose avanhu. ");
INSERT INTO sna_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Zvinhu zvose zvakanga zvino kufema kwoupenyu mumhino dzazvo panyika zvakafa. ");
INSERT INTO sna_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Zvinhu zvose zvipenyu zvaiva pamusoro penyika zvakaparadzwa, vanhu nemhuka, nezvisikwa zvinokambaira panyika neshiri dzedenga zvakaparadzwa kubva panyika. Noa bedzi ndiye akasiyiwa navaya vaiva naye muareka. ");
INSERT INTO sna_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mvura zhinji yakafukidza nyika kwamazuva makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Asi Mwari akarangarira Noa nemhuka dzose dzesango nezvipfuwo zvakanga zvinaye muareka, uye akatuma mhepo pamusoro penyika, uye mvura zhinji ikaserera. ");
INSERT INTO sna_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Zvino zvitubu zvepakadzika uye masuo amafashamu okudenga zvakanga zvazarirwa, uye mvura yakanga yaguma kunaya kubva kudenga. ");
INSERT INTO sna_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mvura yakaserera zvishoma nezvishoma kubva panyika. Pakupera kwamazuva zana namakumi mashanu mvura yakanga yadzika, ");
INSERT INTO sna_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","uye pazuva regumi namanomwe romwedzi wechinomwe, areka yakagara pamakomo eArarati. ");
INSERT INTO sna_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mvura yakaramba ichiserera kusvikira pamwedzi wegumi, uye pazuva rokutanga romwedzi wegumi misoro yamakomo yakatanga kuonekwa. ");
INSERT INTO sna_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Shure kwamazuva makumi mana, Noa akazarura windo raakanga aita muareka, ");
INSERT INTO sna_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","uye akatuma gunguo, uye rakaramba richibhururuka kuno nokoko kusvikira mvura yapwa panyika. ");
INSERT INTO sna_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ipapo akatuma njiva kuti aone kana mvura yakanga yaserera kubva pamusoro penyika. ");
INSERT INTO sna_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Asi njiva haina kuwana nzvimbo yokumhara nokuti mvura yakanga iri pose pose; saka yakadzokera kuna Noa muareka. Akatambanudza ruoko rwake akadzorera njiva muareka maaiva. ");
INSERT INTO sna_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Akarindira kwamamwezve mazuva manomwe uye akabudisazve njiva muareka. ");
INSERT INTO sna_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Njiva yakati yadzokera kwaari panguva yamanheru, onei heyo mumuromo mayo yakaruma shizha nyoro rakatanhwa pamuorivhi! Ipapo Noa akaziva kuti mvura yakanga yaserera panyika. ");
INSERT INTO sna_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Akamirirazve kwamamwe mazuva manomwe uye akabudisazve njiva, asi panguva iyi haina kuzodzoka kwaari. ");
INSERT INTO sna_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pazuva rokutanga romwedzi wokutanga wegore ramazana matanhatu nerimwe aNoa, mvura yakanga yapwa panyika. Ipapo Noa akabvisa chifukidziro cheareka akaona kuti pamusoro penyika pakanga paoma. ");
INSERT INTO sna_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pazuva ramakumi maviri namanomwe romwedzi wechipiri nyika yakanga yaoma kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ipapo Mwari akati kuna Noa, ");
INSERT INTO sna_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Budai muareka, iwe nomukadzi wako navanakomana vako navakadzi vavo. ");
INSERT INTO sna_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Budisa mhando dzose dzezvisikwa zvipenyu zvaunazvo, shiri, mhuka nezvisikwa zvose zvinokambaira panyika, kuitira kuti zvibereke uye zvive zvizhinji pamusoro payo.” ");
INSERT INTO sna_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Saka Noa akabuda, pamwe chete navanakomana vake nomukadzi wake uye navakadzi vavanakomana vake. ");
INSERT INTO sna_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mhuka dzose nezvisikwa zvose zvinokambaira panyika neshiri dzose, zvinhu zvose zvinofamba panyika, zvakabuda muareka, rudzi ruchitevera rumwe. ");
INSERT INTO sna_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ipapo Noa akavakira Jehovha aritari, uye akatora dzimwe dzemhuka dzose dzakanaka neshiri dzakanaka, akabayira zvipiriso zvinopiswa pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jehovha akanzwa kunhuhwira kwakanaka akati mumwoyo make, “Handichazotukazve nyika nokuda kwomunhu, kunyange hazvo kufunga kwomwoyo wake kwakaipa kubva pakuberekwa kwake. Uye handichazoparadzazve zvisikwa zvipenyu zvose, sezvandakaita. ");
INSERT INTO sna_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Kana nyika ichingovapo, nguva dzokudyara nedzokukohwa, kutonhora nokupisa, zhizha nechando, masikati nousiku hazvingatongogumi.” ");
INSERT INTO sna_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ipapo Mwari akaropafadza Noa navanakomana vake, akati kwavari, “Berekanai muwande uye muzadze nyika. ");
INSERT INTO sna_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mhuka dzose dzenyika neshiri dzose dzedenga dzichakutyai uye dzichakuvhundukai; zvisikwa zvose zvinokambaira panyika, nehove dzose dzegungwa, zvakapiwa mumaoko enyu. ");
INSERT INTO sna_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Zvinhu zvose zvinorarama nezvinokambaira zvichava zvokudya zvenyu. Sezvandakakupai muriwo munyoro, ndiri kukupai zvino zvinhu zvose. ");
INSERT INTO sna_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Asi hamufaniri kudya nyama, ropa rayo roupenyu richiri mairi. ");
INSERT INTO sna_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Uye zvirokwazvo ndichatsvaka kuti muzvidavirire nokuda kweropa roupenyu hwenyu. Ndichatsvaka kuti muzvidavirire pamhuka dzose. Uye kubvawo pamunhu mumwe nomumwe, ndichatsvaka kuti azvidavirire nokuda kwoupenyu hwomunhu wokwake. ");
INSERT INTO sna_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ani naani anoteura ropa romunhu, ropa rake richateurwawo nomunhu; nokuti nomufananidzo waMwari, Mwari akaita munhu. ");
INSERT INTO sna_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kana murimi, berekanai muwande; muwande panyika uye muwande kwazvo pamusoro payo.” ");
INSERT INTO sna_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ipapo Mwari akati kuna Noa navanakomana vaaiva navo, ");
INSERT INTO sna_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Zvino ndava kusimbisa sungano yangu newe uye nezvizvarwa zvako zvinotevera, ");
INSERT INTO sna_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","uye nezvisikwa zvipenyu zvose zvakanga zvinewe, shiri, zvipfuwo nemhuka dzose dzesango, dzose dziya dzakabuda newe muareka, zvisikwa zvipenyu zvose zviri panyika. ");
INSERT INTO sna_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ndiri kusimbisa sungano yangu newe: Zvipenyu zvose hazvichatongoparadzwizve nemvura yamafashamu; hakuchatongovizve namafashamu okuti aparadze nyika.” ");
INSERT INTO sna_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Uye Mwari akati, “Ichi ndicho chiratidzo chesungano yandiri kuita pakati pangu nemi nezvisikwa zvose zvipenyu zvinemi, sungano yamarudzi ose ari kuzouya: ");
INSERT INTO sna_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ndaisa muraravungu wangu mumakore, uye uchava chiratidzo chesungano pakati pangu nenyika. ");
INSERT INTO sna_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pose pandinouyisa makore pamusoro penyika, uye muraravungu ukaonekwa mumakore, ");
INSERT INTO sna_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ndicharangarira sungano yangu pakati pangu nemi nezvisikwa zvipenyu zvose zvamarudzi ose. Mvura haingatongoitizve mafashamu kuti iparadze zvipenyu zvose. ");
INSERT INTO sna_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pose panoonekwa muraravungu mumakore, ndichaona ndigorangarira sungano yangu isingaperi pakati paMwari nezvisikwa zvipenyu zvose zvemhando dzose panyika.” ");
INSERT INTO sna_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Saka Mwari akati kuna Noa, “Ichi ndicho chiratidzo chesungano yandakasimbisa pakati pangu nezvipenyu zvose zviri panyika.” ");
INSERT INTO sna_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Vanakomana vaNoa vakabuda muareka vaiva Shemu, Hamu naJafeti. (Hamu akanga ari baba vaKenani.) ");
INSERT INTO sna_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ava ndivo vakanga vari vanakomana vatatu vaNoa, uye kwavari ndiko kwakabva vanhu vakapararira pamusoro penyika. ");
INSERT INTO sna_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa akava murimi, akarima munda wamazambiringa. ");
INSERT INTO sna_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Akati anwa imwe yewaini yawo, akadhakwa uye akavata akashama mutende rake. ");
INSERT INTO sna_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, baba vaKenani, akaona kusasimira kwababa vake akaudza mukoma wake nomununʼuna vake vaiva panze. ");
INSERT INTO sna_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Asi Shemu naJafeti vakatora nguo vakayiisa pamapfudzi avo; ipapo vakafamba nenhendashure vakafukidza baba vavo pakusasimira kwavo. Zviso zvavo zvakanga zvakatarisa parutivi kuitira kuti varege kuona kusasimira kwababa vavo. ");
INSERT INTO sna_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa akati amuka kubva pawaini yake uye akaziva zvakanga zvaitwa kwaari nomwanakomana wake muduku, ");
INSERT INTO sna_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","akati, “Kenani ngaatukwe! Achava muranda wavaranda kuvakuru vake.” ");
INSERT INTO sna_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Akatiwo, “Ngaakudzwe Jehovha, Mwari waShemu! Kenani ngaave muranda waShemu. ");
INSERT INTO sna_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mwari ngaakurise nyika yaJafeti; Jafeti ngaagare mumatende aShemu, uye Kenani ngaave muranda wake.” ");
INSERT INTO sna_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Shure kwamafashamu, Noa akararama kwamakore mazana matatu namakumi mashanu. ");
INSERT INTO sna_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Pamwe chete, Noa akararama kwamakore mazana mapfumbamwe namakumi mashanu, uye akafa. ");
INSERT INTO sna_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iyi ndiyo rondedzero yamarudzi aShemu, Hamu naJafeti, vana vaNoa, avo vakaitawo vanakomana mushure mamafashamu. ");
INSERT INTO sna_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Vanakomana vaJafeti vanoti: Gomeri, Magogi, Madhai, Javhani, Jubhari, Mesheki naTirasi. ");
INSERT INTO sna_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Vanakomana vaGomeri vanoti: Ashikenazi, Rifati naTogarima. ");
INSERT INTO sna_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Vanakomana vaJavhani vanoti: Erisha, Tashishi, Kitimi naRodhanimi. ");
INSERT INTO sna_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Kubva kwavari ivava vanhu vomumahombekombe egungwa vakapararira munyika dzavo, nedzimba dzavo pakati pendudzi dzavo, rudzi rumwe norumwe nomutauro warwo.) ");
INSERT INTO sna_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Vanakomana vaHamu vanoti: Kushi, Miziraimi, Puti naKenani. ");
INSERT INTO sna_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Vanakomana vaKushi vanoti: Sebha, Havhira, Sabhata, Rama naSabhiteka. Vanakomana vaRaama vanoti: Shebha naDhedhani. ");
INSERT INTO sna_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi akanga ari baba vaNimurodhi, uyo akanga ari murwi ane simba panyika. ");
INSERT INTO sna_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Akanga ari muvhimi mukuru pamberi paJehovha; ndokusaka zvichinzi, “SaNimirodhi, muvhimi mukuru pamberi paJehovha.” ");
INSERT INTO sna_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Maguta okutanga oumambo hwake akanga ari Bhabhironi, Ereki, Akadhi neKarine, munyika yeShinari. ");
INSERT INTO sna_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Achibva munyika iyoyo akaenda kuAsiria, uko kwaakandovaka Ninevhe, Rehobhoti Iri, neKara ");
INSERT INTO sna_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","neReseni, riri pakati peNinevhe neKara; rinova ndiro guta guru. ");
INSERT INTO sna_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Miziraimi akanga ari baba veava: vaRudhi, vaAnami, vaRehabhi, vaNafutuhi, ");
INSERT INTO sna_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","vaPaturusi, vaKasiruhi (kunova ndiko kwakabva vaFiristia) navaKafitori. ");
INSERT INTO sna_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenani akanga ari baba veava: Sidhoni dangwe rake, navaHiti, ");
INSERT INTO sna_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","vaJebhusi, vaAmori, vaGirigashi, ");
INSERT INTO sna_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","vaHivhi, vaAriki, vaSini, ");
INSERT INTO sna_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","vaAvhadhi, vaZemari navaHamati. (Shure kwaizvozvo dzimba dzavaKenani dzakapararira, ");
INSERT INTO sna_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","uye miganhu yavaKenani yakasvika kuSidhoni yakananga kuGerari kusvikira kuGaza, uyezve yakananga kuSodhomu, Gomora, Adhima neZebhoimi, kusvikira kuRasha.) ");
INSERT INTO sna_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ava ndivo vanakomana vaHamu nedzimba dzavo uye nemitauro yavo, munyika dzavo nendudzi dzavo. ");
INSERT INTO sna_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu akaberekerwawo vanakomana, mukoma wake akanga ari Jafeti; Shemu akanga ari tateguru wavanakomana vose vaEbheri. ");
INSERT INTO sna_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Vanakomana vaShemu vaiti: Eramu, Ashuri, Afakisadhi, Rudhi naAramu. ");
INSERT INTO sna_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Vanakomana vaAramu vaiti: Uzi, Huri, Geteri naMesheki. ");
INSERT INTO sna_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afakisadhi akanga ari baba vaShera, uye Shera ari baba vaEbheri. ");
INSERT INTO sna_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebheri akaberekerwa vanakomana vaviri: Mumwe ainzi Peregi, nokuti pamazuva ake nyika yakakamurwa; zita romununʼuna wake rainzi Jokitani. ");
INSERT INTO sna_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokitani akanga ari baba veava vanoti: Arimodhadhi, Sherefi, Hazamavheti, Jera, ");
INSERT INTO sna_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadhoramu, Uzari, Dhikira, ");
INSERT INTO sna_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obhari, Abhimaeri, Shebha, ");
INSERT INTO sna_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havhira naJobhabhi. Vose ava vakanga vari vanakomana vaJokitani. ");
INSERT INTO sna_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Dunhu ravaigara raibvira kuMesha rakananga kuSefari, kunyika yezvikomo yokumabvazuva.) ");
INSERT INTO sna_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ava ndivo vanakomana vaShemu nedzimba dzavo uye nemitauro yavo, munyika dzavo nendudzi dzavo. ");
INSERT INTO sna_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Idzi ndidzo dzimba dzavanakomana vaNoa maererano nezvizvarwa zvavo, pakati pendudzi dzavo. Kubva kuna ava ndudzi dzakapararira pamusoro penyika shure kwamafashamu. ");
INSERT INTO sna_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Zvino nyika yose yakanga ino rurimi rumwe chete nokutaura kwakafanana. ");
INSERT INTO sna_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Vanhu vakati vachitamira kumabvazuva, vakawana bani romuShinari vakagaramo. ");
INSERT INTO sna_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Vakataurirana vakati, “Uyai, ngatiitei zvidhina tigozvipisa kwazvo.” Vakashandisa zvidhina pachinzvimbo chamabwe, uye bhitumini ikava dhaka ravo. ");
INSERT INTO sna_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ipapo vakati, “Uyai, ngatizvivakirei guta neshongwe inosvika kudengadenga, kuti tizviitire mukurumbira uye kuti tirege kupararira panyika yose.” ");
INSERT INTO sna_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Asi Jehovha akaburuka pasi kuti azoona guta neshongwe yakanga ichivakwa navanhu. ");
INSERT INTO sna_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Jehovha akati, “Kana vanhu ava vava somunhu mumwe, vachitaura rurimi rumwe chete, vakatanga kuita izvi, zvino hapana chinhu chavanoronga kuti vachiite chichavaomera. ");
INSERT INTO sna_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Uyai, ngatiburukei tindovapesanisa mutauro wavo kuti varege kunzwisisana.” ");
INSERT INTO sna_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Saka Jehovha akavaparadzira pamusoro penyika yose ipapo, uye vakarega kuvaka guta. ");
INSERT INTO sna_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ndokusaka nzvimbo iyo yakanzi Bhabheri, nokuti ipapo Jehovha akapesanisa mutauro wenyika yose. Kubva ipapo Jehovha akavaparadzira pamusoro penyika yose. ");
INSERT INTO sna_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iyi ndiyo rondedzero yamarudzi aShemu. Makore maviri shure kwamafashamu, Shemu paakanga ava namakore zana okuberekwa, akabereka Afakisadhi. ");
INSERT INTO sna_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Uye shure kwokubereka Afakisadhi, Shemu akararama kwamakore mazana mashanu uye akava navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Afakisadhi akati ava namakore makumi matatu namashanu okuberekwa, akabereka Shera. ");
INSERT INTO sna_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Uye shure kwokubereka kwake Shera, Afakisadhi akararama kwamakore mazana mana namatatu uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shera akati ava namakore makumi matatu okuberekwa, akabereka Ebheri. ");
INSERT INTO sna_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Uye shure kwokubereka kwake Ebheri, Shera akararama kwamakore mazana mana namatatu uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebheri akati ava namakore makumi matatu namana okuberekwa, akabereka Peregi. ");
INSERT INTO sna_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Uye shure kwokubereka kwake Peregi, Ebheri akararama kwamakore mazana mana namakumi matatu uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peregi akati ava namakore makumi matatu, okuberekwa akabereka Reu. ");
INSERT INTO sna_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Uye shure kwokubereka kwake Reu, Peregi akararama kwamakore mazana maviri namapfumbamwe uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu akati ava namakore makumi matatu namaviri okuberekwa, akabereka Serugi. ");
INSERT INTO sna_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Uye shure kwokubereka kwake Serugi, Reu akararama kwamakore mazana maviri namanomwe uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi akati ava namakore makumi matatu okuberekwa, akabereka Nahori. ");
INSERT INTO sna_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Uye shure kwokubereka kwake Nahori, Serugi akararama kwamakore mazana maviri uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori akati ava namakore makumi maviri namapfumbamwe okuberekwa, akabereka Tera. ");
INSERT INTO sna_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Uye shure kwokubereka kwake Tera, Nahori akazorarama kwamakore zana negumi namapfumbamwe uye akazova navamwe vanakomana navanasikana. ");
INSERT INTO sna_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Shure kwokunge Nahori ava namakore makumi manomwe okuberekwa, akabereka Abhurama, Nahori naHarani. ");
INSERT INTO sna_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iyi ndiyo rondedzero yavana vaTera. Tera akabereka Abhurama, Nahori naHarani. Uye Harani akabereka Roti. ");
INSERT INTO sna_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Baba vake Tera vachiri vapenyu Harani akafira muUri ravaKaradhea, munyika yaakaberekerwa, ");
INSERT INTO sna_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","vose vari vaviri Abhurama naNahori vakawana. Zita romukadzi waAbhurama rainzi Sarai, uye zita romukadzi waNahori rainzi Mirika; akanga ari mwanasikana waHarani, baba vaMirika naIsika. ");
INSERT INTO sna_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Zvino Sarai akanga asingabereki; akanga asina vana. ");
INSERT INTO sna_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera akatora mwanakomana wake Abhurama, muzukuru wake Roti, mwanakomana waHarani, nomuroora wake Sarai, mukadzi womwanakomana wake Abhurama, uye vakaenda kuUri yavaKaradhea pamwe chete kuti vaende kuKenani. Asi vakati vasvika paHarani, vakagara ipapo. ");
INSERT INTO sna_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera akararama kwamakore mazana maviri namashanu, uye akafira paHarani. ");
INSERT INTO sna_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jehovha akanga ati kuna Abhurama, “Siya nyika yako, vanhu vako neimba yababa vako uye uende kunyika yandichakuratidza. ");
INSERT INTO sna_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ndichakuita rudzi rukuru uye ndichakuropafadza; ndichaita kuti zita rako rive guru, uye iwe uchava ropafadzo. ");
INSERT INTO sna_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ndicharopafadza vaya vanokuropafadza, uye ani naani anokutuka ndichamutuka; uye marudzi ose ari panyika acharopafadzwa kubudikidza newe.” ");
INSERT INTO sna_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Saka Abhurama akabva, sezvaakanga audzwa naJehovha; uye Roti akaenda naye. Abhurama akanga ava namakore makumi manomwe namashanu okuberekwa paakasimuka kubva paHarani. ");
INSERT INTO sna_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Akatora mukadzi wake Sarai, mwanakomana womununʼuna wake Roti, pfuma yose yavakanga vava nayo, navanhu vavakanga vawana muHarani, uye vakasimuka vakaenda kunyika yeKenani, uye vakasvika ikoko. ");
INSERT INTO sna_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abhurama akafamba nomunyika kusvikira panzvimbo yomuti mukuru weMore paShekemu. Panguva iyoyo vaKenani vakanga vari munyika. ");
INSERT INTO sna_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jehovha akazviratidza kuna Abhurama akati, “Ndichapa nyika iyi kuvana vako.” Saka akavakira Jehovha aritari ipapo, iye akanga azviratidza kwaari. ");
INSERT INTO sna_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kubva ipapo akaenda mberi akananga kuzvikomo zviri kumabvazuva kweBheteri uye akadzika tende rake ikoko, Bheteri riri kumavirira uye Ai riri kumabvazuva. Akavakira Jehovha aritari ipapo uye akadana kuzita raJehovha. ");
INSERT INTO sna_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Uye Abhurama akasimuka akaenda mberi akananga kuNegevhi. ");
INSERT INTO sna_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Zvino nzara yakanga iripo panyika, uye Abhurama akaburuka akaenda kuIjipiti kuti andogara ikoko kwechinguva nokuti nzara yakanga iri huru kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Paakanga oda kupinda muIjipiti, akati kumukadzi wake, Sarai, “Ndinoziva kuti uri mukadzi akanakisa. ");
INSERT INTO sna_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Pauchaonekwa navaIjipita, vachati, ‘Uyu ndiye mukadzi wake.’ Ipapo vachandiuraya asi iwe vachakurega uri mupenyu. ");
INSERT INTO sna_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Saka uti uri hanzvadzi yangu, kuti ndigobatwa zvakanaka nokuda kwako uye upenyu hwangu hucharwirwa nokuda kwako.” ");
INSERT INTO sna_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abhurama akati asvika kuIjipiti, vaIjipita vakaona kuti akanga ane mukadzi akanaka kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Uye machinda aFaro vakati vamuona, vakandomurumbidza kuna Faro, uye vakabva vamutora vakamupinza mumuzinda wake. ");
INSERT INTO sna_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Akabata Abhurama zvakanaka nokuda kwake, uye Abhurama akava namakwai nemombe, makono embongoro namakadzi, varandarume navarandakadzi uye nengamera. ");
INSERT INTO sna_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Asi Jehovha akatambudza Faro neveimba yake nehosha yakaipisisa nokuda kwaSarai mukadzi waAbhurama. ");
INSERT INTO sna_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Saka Faro akadana Abhurama akati, “Waiteiko kwandiri? Wakaregereiko kundiudza kuti uyu mukadzi wako? ");
INSERT INTO sna_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Seiko wakati, ‘Ihanzvadzi yangu,’ nokudaro ndakamutora kuti ave mukadzi wangu? Naizvozvo zvino, hoyu mukadzi wako. Mutore uende!” ");
INSERT INTO sna_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ipapo Faro akarayira varanda vake pamusoro paAbhurama, vakamurega achienda nomukadzi wake uye nezvinhu zvose zvaakanga anazvo. ");
INSERT INTO sna_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Saka Abhurama akakwidza achibva kuIjipiti akaenda kuNegevhi, nomukadzi wake uye nezvinhu zvose zvaakanga anazvo, uye Roti akaenda naye. ");
INSERT INTO sna_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abhurama akanga apfuma kwazvo pamombe nesirivha uye negoridhe. ");
INSERT INTO sna_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kubva kuNegevhi akafamba nzvimbo nenzvimbo kudzamara asvika kuBheteri, kunzvimbo iri pakati peBheteri neAi kwaimbova netende rake kare ");
INSERT INTO sna_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","uye kwaakanga atanga kuvaka aritari. Abhurama akadana kuzita raJehovha ikoko. ");
INSERT INTO sna_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Zvino Roti, uyo akanga achifamba naAbhurama, akanga ana makwai nemombewo namatende. ");
INSERT INTO sna_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Asi nyika haina kugona kuvaringana kuti vagare pamwe chete, nokuti pfuma yavo yakanga yakawanda kwazvo zvokuti vakanga vasisakwanisi kugara pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Uye gakava rakamuka pakati pavafudzi vaAbhurama navafudzi vaRoti. VaKenani navaPerizi vakanga vachigarawo munyika panguva iyoyo. ");
INSERT INTO sna_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Saka Abhurama akati kuna Roti, “Ngaparege kuva negakava pakati pako neni, kana pakati pavafudzi vako nevangu, nokuti tiri hama. ");
INSERT INTO sna_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ko, nyika yose iyi haisi pamberi pako here? Ngatiparadzane. Kana ukaenda kuruboshwe, ini ndichaenda kurudyi; kana ukaenda kurudyi, ini ndichaenda kuruboshwe.” ");
INSERT INTO sna_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Roti akatarira kumusoro akaona bani rose reJorodhani kuti rakanga rakanyatsonyorova, sebindu raJehovha, kufanana nenyika yeIjipiti, kwakanangana neZoari. (Panguva iyi Jehovha akanga achigere kuparadza Sodhomu neGomora.) ");
INSERT INTO sna_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Saka Roti akazvisarudzira bani rose reJorodhani uye akasimuka akananga kumabvazuva. Varume vaviri ava vakaparadzana: ");
INSERT INTO sna_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abhurama akagara munyika yeKenani, Roti akagara pakati pamaguta omumapani uye akadzika matende ake pedyo neSodhomu. ");
INSERT INTO sna_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Zvino varume veSodhomu vakanga vakaipa uye vaitadzira Jehovha kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jehovha akati kuna Abhurama shure kwokubva kwaRoti, “Simudza meso ako uri pauri ipapo uye utarire kumusoro nezasi, kumabvazuva nokumavirira. ");
INSERT INTO sna_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nyika yose yauri kuona ndichakupa iwe navana vako nokusingaperi. ");
INSERT INTO sna_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ndichaita kuti vana vako vave seguruva renyika, zvokuti kana pano munhu angagona kuverenga guruva, naizvozvo vana vako vachagona kuverengwawo. ");
INSERT INTO sna_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Enda, famba munyika, muurefu nomuupamhi hwayo, nokuti ndichaipa kwauri.” ");
INSERT INTO sna_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Saka Abhurama akabvisa matende ake uye akandogara pedyo nemiti mikuru yeMamure paHebhuroni, uye akavakira Jehovha aritari ipapo. ");
INSERT INTO sna_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Panguva iyoyo Amuraferi mambo weShinari, Arioki mambo weErasa, Kedhoraomeri mambo weEramu naTidhari mambo weGoyimi ");
INSERT INTO sna_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","vakaenda kundorwa naBhera mambo weSodhomu, Bhirisha mambo weGomora, Shinabhi mambo weAdhima, Shemebheri mambo weZebhoimi, uye namambo weBhera (ndiro Zoari). ");
INSERT INTO sna_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Madzimambo ose aya akabatana pakurwa muMupata weSidhimi (ndiro Gungwa roMunyu). ");
INSERT INTO sna_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Vakanga vari varanda vaKedhoraomeri kwamakore gumi namaviri, asi vakamumukira mugore regumi namatatu. ");
INSERT INTO sna_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mugore regumi namana, Kedhoraomeri namadzimambo ainzwanana naye vakabuda vakandokunda vaRefaiti muAshiteroti Kanaimi, ivo vaZuzi muHamu, vaEmi muShavhe Kiriataimi ");
INSERT INTO sna_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","navaHori munyika yezvikomo yeSeiri, kusvikira kuEri Parani pedyo negwenga. ");
INSERT INTO sna_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ipapo vakadzokera vakaenda kuEni Mishipati (ndiro Kadheshi), uye vakakunda nyika yose yavaAmareki, pamwe chete navaAmori vakanga vachigara muHazazoni Tamari. ");
INSERT INTO sna_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ipapo mambo weSodhomu, mambo weGomora, mambo weAdhima, mambo weZebhoimi namambo weBhera (ndiro, Saori) vakabuda vakamira panzvimbo yavo yehondo muMupata weSidhimi ");
INSERT INTO sna_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kuti varwe naKedhoraomeri mambo weEramu, Tidhari mambo weGoyimi, Amuraferi mambo weShinari naArioki mambo weErasa, madzimambo mana achirwa namadzimambo mashanu. ");
INSERT INTO sna_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Zvino mupata weSidhimi wakanga uzere namakomba etara, uye madzimambo eSodhomu neGomora paakatiza, vamwe varume vakawira maari uye vakasara vakatizira kuzvikomo. ");
INSERT INTO sna_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Madzimambo mana aya akatora pfuma yose yeSodhomu neGomora nezvokudya zvavo zvose vakaenda. ");
INSERT INTO sna_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Vakatorawo Roti mwanakomana womununʼuna waAbhurama nepfuma yake, sezvo akanga achigara muSodhomu. ");
INSERT INTO sna_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mumwe akapunyuka akauya akasvikoudza Abhurama muHebheru. Zvino Abhurama akanga achigara pedyo nemiti mikuru yaMamure muAmori, mununʼuna waEshikori naAneri, avo vose vainzwanana naAbhurama. ");
INSERT INTO sna_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abhurama akati anzwa kuti hama yake yakanga yatapwa, akadana varume vakanga vadzidziswa kurwa mazana matatu negumi navasere vakaberekerwa mumba make vakavatevera kusvikira paDhani. ");
INSERT INTO sna_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abhurama akapatsanura vanhu vake panguva dzousiku kuti vandovarwisa, uye vakavakunda, vakavatevera kusvikira paHobhabhi, kumusoro kweDhamasiko. ");
INSERT INTO sna_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Akadzosa zvinhu zvose uye akadzosawo hama yake Roti nepfuma yake, pamwe chete navakadzi navamwe vanhu. ");
INSERT INTO sna_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Shure kwokudzoka kwaAbhurama akunda Kedhoraomeri namadzimambo akanga abatana naye, mambo weSodhomu akabuda kuti azosangana naye muMupata weShavhe (ndiwo Mupata waMambo). ");
INSERT INTO sna_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ipapo Merikizedheki mambo weSaremu akamuvigira chingwa newaini. Akanga ari muprista waMwari Wokumusoro-soro, ");
INSERT INTO sna_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","uye akaropafadza Abhurama, achiti, “Abhurama ngaaropafadzwe naMwari Wokumusoro-soro, Musiki wedenga napasi. ");
INSERT INTO sna_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Uye Mwari Wokumusoro-soro ngaakudzwe, akaisa vavengi vako muruoko rwako.” Ipapo Abhurama akamupa chegumi chezvinhu zvose. ");
INSERT INTO sna_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mambo weSodhomu akati kuna Abhurama, “Ndipe vanhu uzvichengetere hako pfuma.” ");
INSERT INTO sna_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Asi Abhurama akati kuna mambo weSodhomu, “Ndakasimudzira ruoko rwangu kuna Jehovha, Mwari Wokumusoro-soro, Musiki wedenga napasi, uye ndakaita mhiko ");
INSERT INTO sna_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kuti handizogamuchiri chinhu chako, kunyange rushinda kana rukanda rweshangu, kuti urege kuzoti, ‘Ndakapfumisa Abhurama.’ ");
INSERT INTO sna_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Handina chinhu chandinogamuchira kunze kwezvakadyiwa navanhu vangu uye mugove wavanhu vakaenda neni, Aneri, Shikori naMamure. Ngavatore mugove wavo ivavo.” ");
INSERT INTO sna_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Shure kwaizvozvo shoko raJehovha rakasvika kuna Abhurama muchiratidzo richiti: “Usatya, Abhurama. Ndiri nhoo yako, mubayiro wako mukuru chaizvo.” ");
INSERT INTO sna_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Asi Abhurama akati, “Haiwa Ishe Jehovha, muchandipeiko sezvo ndisina mwana uye Eriezeri weDhamasiko ndiye achava mudyi wenhaka yangu here?” ");
INSERT INTO sna_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Uye Abhurama akati, “Hamuna kundipa vana; saka muranda ari mumba mangu ndiye achava mudyi wenhaka yangu.” ");
INSERT INTO sna_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ipapo shoko raJehovha rakasvika kwaari richiti, “Murume uyu haangavi mudyi wenhaka yako, asi mwanakomana anobva mumuviri wako ndiye achava mudyi wenhaka yako.” ");
INSERT INTO sna_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Akamutora akamubudisa panze akati, “Tarisa kumusoro kumatenga uye uverenge nyeredzi uone zvirokwazvo kana ukakwanisa kudziverenga.” Ipapo akati kwaari, “Ndizvo zvichaita vana vako.” ");
INSERT INTO sna_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abhurama akatenda Jehovha, uye iye akamuti ndiko kururama kwake. ");
INSERT INTO sna_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Akatiwo kwaari, “Ndini Jehovha, akakubudisa munyika yeUri yavaKaradhea kuti ndikupe nyika iyi kuti uitore ive yako.” ");
INSERT INTO sna_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Asi Abhurama akati, “Haiwa Ishe Jehovha, ndingaziva seiko kuti ndichaitora?” ");
INSERT INTO sna_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Saka Jehovha akati kwaari, “Ndivigire tsiru, mbudzi negondobwe, chimwe nechimwe chazvo china makore matatu pamwe chete nenjiva uye nehangaiwa.” ");
INSERT INTO sna_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abhurama akauyisa zvose izvi kwaari, akazvigura napakati uye akaronga hafu dzacho dzakatarisana; asi shiri haana kudzipamura napakati. ");
INSERT INTO sna_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ipapo shiri dzinodya nyama dzakaburukira panyama, asi Abhurama akadzidzinga. ");
INSERT INTO sna_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Zuva parakanga rovira, Abhurama akabatwa nehope huru, uye rima guru rinotyisa rakauya pamusoro pake. ");
INSERT INTO sna_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ipapo Jehovha akati kwaari, “Uzive zvirokwazvo kuti zvizvarwa zvako zvichava vatorwa munyika isati iri yavo, uye vachabatwa senhapwa uye vachibatwa zvakaipa kwamakore mazana mana. ");
INSERT INTO sna_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Asi ndicharanga rudzi rwavachashandira senhapwa, uye shure kwaizvozvo vachabuda vaine pfuma zhinji kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kunyange zvakadaro, iwe uchaenda kumadzibaba ako norugare uye uchavigwa wakwegura kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Parudzi rwechina, zvizvarwa zvako zvichadzoka pano, nokuti chivi chavaAmori hachisati chasvika pakuzara kwacho.” ");
INSERT INTO sna_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Zuva rakati ravira, uye kwasviba, choto chinopfungaira utsi uye nomwenje unopfuta zvakaonekwa uye zvikapfuura napakati penhindi. ");
INSERT INTO sna_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Pazuva iro, Jehovha akaita sungano naAbhurama akati, “Nyika iyi ndinoipa kuzvizvarwa zvako, kubva kurwizi rweIjipiti kusvikira kurwizi rukuru, Yufuratesi, ");
INSERT INTO sna_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","nyika yavaKeni, navaKenazi, vaKadhimoni, ");
INSERT INTO sna_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","vaHiti, vaPerizi, vaRefaimi, ");
INSERT INTO sna_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","vaAmori, vaKenani, vaGirigashi navaJebhusi.” ");
INSERT INTO sna_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Zvino Sarai, mukadzi waAbhurama, akanga asina kumuberekera vana. Asi iye akanga ano murandakadzi wechiIjipita ainzi Hagari; ");
INSERT INTO sna_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","saka akati kuna Abhurama, “Jehovha akandikonesa kubereka vana. Enda hako undovata nomurandakadzi wangu; zvimwe ndingaita mhuri kubudikidza naye.” Abhurama akabvuma zvakanga zvataurwa naSarai. ");
INSERT INTO sna_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saka shure kwokugara kwaAbhurama kwamakore gumi muKenani, Sarai mukadzi wake akatora Hagari murandakadzi wake wechiIjipita akamupa kumurume wake kuti ave mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Akavata naHagari uye Hagari akabata pamuviri. Paakaziva kuti akanga ava napamuviri, akatanga kuzvidza tenzikadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ipapo Sarai akati kuna Abhurama, “Ndiwe waita kuti nditambudzike. Ndakaisa murandakadzi wangu mumaoko ako, uye zvino zvaava kuziva kuti ava napamuviri, ava kundizvidza. Mwari ngaatonge pakati pangu newe.” ");
INSERT INTO sna_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abhurama akati, “Murandakadzi wako ari mumaoko ako. Ita naye zvaunofunga kuti zvakaisvonaka.” Ipapo Sarai akabata Hagari zvakaipa; saka akatiza. ");
INSERT INTO sna_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mutumwa waJehovha akawana Hagari ari pedyo netsime raiva murenje; rakanga riri tsime rakanga riri parutivi pomugwagwa unoenda kuShuri. ");
INSERT INTO sna_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Uye akati, “Hagari, murandakadzi waSarai, wabvepiko, uye uri kuendepiko?” Iye akati, “Ndiri kutiza kubva kuna tenzikadzi wangu Sarai.” ");
INSERT INTO sna_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ipapo mutumwa waJehovha akati kwaari, “Dzokera kuna tenzikadzi wako undozvininipisa pasi pake.” ");
INSERT INTO sna_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mutumwa akatizve, “Ndichawandisa zvizvarwa zvako zvokuti havangaverengeki.” ");
INSERT INTO sna_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mutumwa waJehovha akatiwo kwaari: “Iye zvino wava nemimba uye uchava nomwanakomana. Uchamutumidza zita rokuti Ishumaeri, nokuti Jehovha anzwa nezvokutambura kwako. ");
INSERT INTO sna_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Achava mbongoro yomusango: ruoko rwake rucharwa navanhu vose uye ruoko rwavanhu vose rucharwa naye, uye achararama mukupesana nehama dzake dzose.” ");
INSERT INTO sna_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagari akapa zita iri kuna Jehovha akataura naye akati: “Ndimi Jehovha anondiona,” nokuti akati, “Zvino ndaona Iye anondiona.” ");
INSERT INTO sna_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ndokusaka tsime rakanzi Bheeri Rahai Roi; richiripo, pakati peKadheshi neBheredhi. ");
INSERT INTO sna_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Saka Hagari akaberekera Abhurama mwanakomana, uye Abhurama akapa zita rokuti Ishumaeri kumwanakomana waakanga abereka. ");
INSERT INTO sna_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abhurama akanga ava namakore makumi masere namatanhatu okuberekwa paakaberekerwa mwanakomana naHagari. ");
INSERT INTO sna_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abhurama akati ava namakore makumi mapfumbamwe namapfumbamwe okuberekwa, Jehovha akazviratidza kwaari akati, “Ndini Mwari Wamasimba Ose; famba pamberi pangu uye uve wakarurama. ");
INSERT INTO sna_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ndichasimbisa sungano yangu pakati pangu newe uye ndichakukurisa kwazvo.” ");
INSERT INTO sna_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abhurama akawira pasi nechiso chake, uye Mwari akati kwaari, ");
INSERT INTO sna_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kana ndirini, iyi ndiyo sungano yangu newe: Uchava baba vendudzi zhinji. ");
INSERT INTO sna_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hauchazonzi Abhurama; zita rako richanzi Abhurahama nokuti ndakuita baba vendudzi zhinji. ");
INSERT INTO sna_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndichakuita kuti uve navana vazhinji; ndichaita ndudzi kubva mauri, uye madzimambo achabva pauri. ");
INSERT INTO sna_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ndichasimbisa sungano yangu sesungano isingaperi pakati pangu newe uye nezvizvarwa zvako zvinotevera kumarudzi achauya, kuti ndive Mwari wako naMwari wezvizvarwa zvako zvinotevera. ");
INSERT INTO sna_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nyika yose yeKenani, mauri mutorwa zvino, ndichaipa kwauri nokusingaperi kuti ive yako nezvizvarwa zvako zvinokutevera; uye ini ndichava Mwari wavo.” ");
INSERT INTO sna_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ipapo Mwari akati kuna Abhurahama, “Kana uriwe, unofanira kuchengeta sungano yangu, iwe nezvizvarwa zvako zvinokutevera kumarudzi achauya. ");
INSERT INTO sna_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iyi ndiyo sungano yangu newe nezvizvarwa zvako zvinokutevera, sungano yaunofanira kuchengeta: Munhurume wose ari pakati penyu anofanira kudzingiswa. ");
INSERT INTO sna_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Munofanira kudzingiswa, uye ichi chichava chiratidzo chesungano pakati pangu newe. ");
INSERT INTO sna_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kubva kuzvizvarwa zvinotevera, mwanakomana mumwe nomumwe ari pakati penyu ava namazuva masere okuberekwa anofanira kudzingiswa, kusanganisa navaya vakaberekerwa mumba mako kana vakatengwa nemari kumutorwa, vaya vasiri vana vako. ");
INSERT INTO sna_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Angava akaberekerwa mumba mako kana akatengwa nemari yako, vanofanira kudzingiswa. Sungano yangu panyama yenyu inofanira kuva sungano isingaperi. ");
INSERT INTO sna_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Munhurume upi zvake, asina kudzingiswa panyama, achabviswa pavanhu vokwake; aputsa sungano yangu.” ");
INSERT INTO sna_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mwari akatiwo kuna Abhurahama, “Kana ari Sarai mukadzi wako, hauchazomutizve Sarai; zita rake richanzi Sara. ");
INSERT INTO sna_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ndichamuropafadza uye zvirokwazvo ndichakupa mwanakomana naye. Ndichamuropafadza kuitira kuti agozova mai vendudzi; madzimambo amarudzi achabva kwaari.” ");
INSERT INTO sna_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abhurahama akawira pasi nechiso chake, akaseka uye akati mumwoyo make, “Ko, mwanakomana angaberekwa nomunhu ava namakore zana okuberekwa here? Ko, Sara angabereka mwana iye ava namakore makumi mapfumbamwe here?” ");
INSERT INTO sna_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Uye Abhurahama akati kuna Mwari, “Dai hazvo Ishumaeri agara hake pamaropafadzo enyu!” ");
INSERT INTO sna_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ipapo Mwari akati, “Hongu, asi mukadzi wako Sara achakuberekera mwanakomana, uye uchamutumidza kuti Isaka. Ndichasimbisa sungano yangu sesungano isingaperi yezvizvarwa zvake zvinomutevera. ");
INSERT INTO sna_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Uye kana ari Ishumaeri, ndakanzwa: Ndichamuropafadza zvirokwazvo, ndichamuita kuti ave navana vazhinji uye ndichaita kuti vawande kwazvo. Achava baba wavatongi gumi navaviri, uye ndichamuita rudzi rukuru. ");
INSERT INTO sna_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Asi ndichasimbisa sungano yangu naIsaka, uyo achaberekerwa iwe naSara nenguva ino gore rinouya.” ");
INSERT INTO sna_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Akati apedza kutaura naAbhurahama, Mwari akakwira kumusoro achibva paari. ");
INSERT INTO sna_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Pazuva racho iroro Abhurahama akatora mwanakomana wake Ishumaeri navose vakaberekwa mumba make kana vakanga vatengwa nemari, vanhurume vose vaiva mumba make, akavadzingisa, sezvaakanga audzwa naMwari. ");
INSERT INTO sna_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abhurahama akanga ava namakore makumi mapfumbamwe namapfumbamwe okuberekwa paakadzingiswa, ");
INSERT INTO sna_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","uye Ishumaeri mwanakomana wake akanga ava namakore gumi namatatu okuberekwa; ");
INSERT INTO sna_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abhurahama naIshumaeri mwanakomana wake vakadzingiswa vose zuva rimwe chete iroro. ");
INSERT INTO sna_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Uye munhurume wose aiva mumba maAbhurahama, kusanganisa vaya vakaberekerwa mumba make kana vakanga vatengwa kubva kuvatorwa, vakadzingiswa pamwe chete naye. ");
INSERT INTO sna_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Jehovha akazviratidza kuna Abhurahama pedyo nemiti mikuru yeMamure panguva yaakanga agere pamukova wokupinda patende rake masikati zuva richipisa. ");
INSERT INTO sna_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abhurahama akasimudza meso ake ndokuona varume vatatu vamire naye. Akati avaona, akamhanya achibva pamukova wetende rake kuti andosangana navo uye akakotamira pasi. ");
INSERT INTO sna_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Akati, “Kana ndawana nyasha pamberi penyu, ishe wangu, musapfuura henyu muranda wenyu. ");
INSERT INTO sna_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Regai muvigirwe mvura shoma, mugoshamba tsoka dzenyu mose uye mugozorora pasi pomuti uyu. ");
INSERT INTO sna_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Regai ndikutorerei zvokudya kuti mudye, kuitira kuti musimbiswe ipapo mugoenderera henyu mberi norwendo rwenyu, sezvo zvino masvika pamuranda wenyu.” Vakapindura vakati, “Zvakanaka, ita hako sezvawareva.” ");
INSERT INTO sna_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Saka Abhurahama akakurumidza kuenda kutende kuna Sara. Akati kwaari, “Kurumidza, tora zviero zvitatu zvoupfu hwakatsetseka uhukanye ugobika chingwa.” ");
INSERT INTO sna_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ipapo iye akamhanyira kumombe akandosarudza mhuru yakaisvonaka, akaipa kumuranda, uyo akakurumidza kuigadzira. ");
INSERT INTO sna_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ipapo akauyisa ruomba nomukaka uye nemhuru yakanga yagadzirwa, akazvigadzika pamberi pavo. Pavakanga vachidya, akamira pedyo navo pasi pomuti. ");
INSERT INTO sna_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Vakamubvunza vakati, “Mukadzi wako Sara aripiko?” Iye akati, “Ari mutende umo.” ");
INSERT INTO sna_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ipapo Jehovha akati, “Zvirokwazvo ndichadzokazve gore rinouya nenguva inenge seino, uye Sara mukadzi wako achava nomwanakomana.” Zvino Sara akanga achiteerera ari pamukova wetende wakanga uri shure kwake. ");
INSERT INTO sna_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abhurahama naSara vakanga vakwegura uye vava namakore mazhinji, uye Sara akanga atopfuura zera rokubereka vana. ");
INSERT INTO sna_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saka Sara akaseka mumwoyo make paakafunga achiti, “Ndichazovawo nomufaro uyu here zvino shure kwokuchembera kwangu, vatenzi vangu vakwegura?” ");
INSERT INTO sna_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ipapo Jehovha akati kuna Abhurahama, “Seiko Sara aseka achiti, ‘Ndichava nomwana zvechokwadi here, sezvo zvino ndakwegura?’ ");
INSERT INTO sna_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Pane chinhu chakaoma kuna Jehovha here? Ndichadzokazve kwauri gore rinouya senguva dzakatarwa uye Sara achava nomwanakomana.” ");
INSERT INTO sna_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara akatya, saka akareva nhema akati, “Handina kuseka.” Asi iye akati, “Hongu, waseka.” ");
INSERT INTO sna_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Varume vakati vasimuka kuti vaende, vakatarisa vakananga zasi kuSodhomu, uye Abhurahama akafamba navo achivaperekedza. ");
INSERT INTO sna_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ipapo Jehovha akati, “Ko, ndichavanzira Abhurahama zvandiri kuda kuita here. ");
INSERT INTO sna_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Zvirokwazvo Abhurahama achava rudzi rukuru rune simba, uye ndudzi dzose dzapanyika dzicharopafadzwa kubudikidza naye. ");
INSERT INTO sna_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nokuti ndakamusarudza kuti agotungamirira vana vake neveimba yake kuti vachengete nzira yaJehovha nokuita zvakanaka nezvakarurama, kuitira kuti Jehovha agouyisa pamusoro paAbhurahama zvaakamuvimbisa.” ");
INSERT INTO sna_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ipapo Jehovha akati, “Kuchema pamusoro peSodhomu neGomora kukuru kwazvo uye chivi chavo chaipisisa ");
INSERT INTO sna_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","zvokuti ndichaburuka kuti ndinoona kana zvavakaita zvakanyanya kuipa sokuchema kwakasvika kwandiri. Kana zvisina kudaro, ndichazviziva.” ");
INSERT INTO sna_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Vanhu vaya vakabvapo uye vakaenda vakananga kuSodhomu, asi Abhurahama akaramba amire pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ipapo Abhurahama akaswedera kwaari akati, “Ko, muchaparadza vakarurama pamwe chete navakaipa here? ");
INSERT INTO sna_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ko, kana muguta mune vanhu makumi mashanu vakarurama? Muchariparadza zvechokwadi here mukasasiya nzvimbo iyo nokuda kwavanhu makumi mashanu varimo? ");
INSERT INTO sna_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Zvakadaro ngazvive kure nemi kuti muite chinhu chakadai, kuti muuraye vakarurama pamwe chete navatadzi, muchiitira vakarurama zvakafanana navatadzi. Zvakadaro ngazvive kure nemi! Ko, mutongi wenyika yose haangaiti zvakarurama here?” ");
INSERT INTO sna_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jehovha akati, “Kana ndikawana vanhu vakarurama makumi mashanu vari muguta reSodhomu, ndichaponesa nzvimbo yose nokuda kwavo.” ");
INSERT INTO sna_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ipapo Abhurahama akataurazve akati, “Zvino zvandatanga kudai kuti nditaure kuna Ishe, kunyange hazvo ndisiri chinhu asi guruva namadota, ");
INSERT INTO sna_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ko, kana kukashayikwa vashanu kune vakarurama vana makumi mashanu? Muchaparadza guta rose nokuda kwavashanu ava here?” Akati, “Kana ndikawana makumi mana navashanu imomo, handingariparadzi.” ");
INSERT INTO sna_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Zvakarezve akataura kwaari akati, “Ko, kana kukawanikwa makumi mana chete?” Iye akati, “Nokuda kwamakumi mana iwayo, handingaiti izvozvo.” ");
INSERT INTO sna_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ipapo akati, “Ishe ngaarege kunditsamwira, asi regai nditaure hangu. Ko, kana makumi matatu chete vakawanikwamo?” Iye akapindura akati, “Handingaiti izvozvo kana ndikawana makumi matatu chete.” ");
INSERT INTO sna_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abhurahama akati, “Zvino zvandatsunga hangu kudai kuti nditaure kuna Ishe, ko, kana makumi maviri akawanikwamo?” Iye akati, “Nokuda kwamakumi maviri iwayo, handingariparadzi.” ");
INSERT INTO sna_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ipapo akati, “Ishe ngaarege kunditsamwira, asi regai hangu nditaurezve kamwe chete. Ko, kana gumi chete vakawanikwamo?” Iye akapindura akati, “Nokuda kwaivavo gumi, handingariparadzi.” ");
INSERT INTO sna_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Jehovha akati apedza kutaura naAbhurahama, akabva, uye Abhurahama akadzoka kumba kwake. ");
INSERT INTO sna_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Vatumwa vaviri vakasvika muSodhomu madekwana, uye Roti akanga agere pasuo reguta. Akati achivaona, akasimuka kuti andosangana navo uye akakotamisa uso hwake pasi. ");
INSERT INTO sna_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Akati, “Madzishe angu, ndapota hangu tsaukirai henyu kumba kwomuranda wenyu. Mushambidze henyu tsoka dzenyu uye mugovata usiku huno, ipapo mugoenda henyu mangwana mangwanani.” Ivo vakati, “Kwete, tichavata hedu pachivara usiku huno.” ");
INSERT INTO sna_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Asi akavakumbirisa zvokuti vakatenda kuenda naye uye vakapinda mumba make. Akavagadzirira zvokudya, akabika chingwa chisina mbiriso, uye vakadya. ");
INSERT INTO sna_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Vasati vaenda kundovata, varume vose vaibva kumativi ose eguta reSodhomu, vose vaduku navakuru, vakakomba imba. ");
INSERT INTO sna_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Vakadana Roti vachiti, “Varipiko varume vapinda mumba mako usiku huno? Vaburitse kuno kwatiri kuti tivate navo.” ");
INSERT INTO sna_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Roti akabuda kunze kuti andosangana navo uye akapfiga mukova shure kwake, ");
INSERT INTO sna_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","akati, “Kwete, shamwari dzangu. Regai kuita chinhu ichi chakaipa. ");
INSERT INTO sna_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tarirai, ndina vanasikana vaviri vasina kutongovata nomurume. Regai ndivabudisire kwamuri uye mungagona kuita zvamunoda navo. Asi musaita kana chinhu kuvarume ava, nokuti vakavanda pasi pedenga rangu.” ");
INSERT INTO sna_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ivo vakati, “Suduruka!” Uye vakati, “Munhu uyu akauya pano ari mutorwa, asi zvino ava kuda kutitonga! Tichakuitira zvakaipa iwe kupfuura ivo.” Vakaramba vachimanikidza Roti uye vakaswedera mberi kuti vapaze gonhi. ");
INSERT INTO sna_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Asi varume vaiva mukati vakatambanudza maoko avo vakakwevera Roti mumba uye vakapfiga mukova. ");
INSERT INTO sna_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ipapo vakapofumadza varume vakanga vari pamukova wemba, vaduku navakuru, zvokuti havana kuzogona kuona mukova. ");
INSERT INTO sna_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Varume vaviri vakati kuna Roti, “Una vamwe vanhu pano here, vakuwasha, vanakomana kana vanasikana, kana mumwe wako zvake ari muguta? Vabudise muno, ");
INSERT INTO sna_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","nokuti tiri kuzoparadza nzvimbo ino. Kuchema kuna Jehovha pamusoro pavanhu ava kwakura zvokuti atituma kuzoriparadza.” ");
INSERT INTO sna_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Saka Roti akabuda akandotaura kuvakuwasha vake, vakanga vatsidza kuti vachawana vanasikana vake, akati, “Kurumidzai kubva panzvimbo ino, nokuti Jehovha ava kuda kuparadza guta!” Asi vakuwasha vake vakafunga kuti aiita zveje-e navo. ");
INSERT INTO sna_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mambakwedza, vatumwa vakakurudzira Roti vachiti, “Kurumidza! Tora mukadzi wako navanasikana vako vaviri vaunavo, kuti murege kuparadzwa kana guta roparadzwa.” ");
INSERT INTO sna_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Akati achinonoka, varume vakabata ruoko rwake uye namaoko omukadzi wake neavanasikana vake vaviri vakavabudisa zvakanaka kunze kweguta, nokuti Jehovha akavanzwira tsitsi. ");
INSERT INTO sna_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Vakati vachangovabudisa kunze, mumwe wavo akati, “Tizai nokuda kwoupenyu hwenyu! Musacheuka, uye musamira papi zvapo mubani! Tizirai kumakomo kuti murege kuparadzwa!” ");
INSERT INTO sna_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Asi Roti akati kwavari, “Kwete, madzibaba angu, ndapota! ");
INSERT INTO sna_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Muranda wenyu awana nyasha pamberi penyu, uye maratidza unyoro hukuru kwandiri zvamarwira upenyu hwangu. Asi handigoni kutizira kumakomo; njodzi iyi ingazondibata, uye ndingazofa. ");
INSERT INTO sna_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tarirai, herino guta riri pedyo randingatizira kwariri, uye iduku zvaro. Regai nditizire kwariri, iduku kwazvo, handizvo here? Ipapo upenyu hwangu hucharwirwa.” ");
INSERT INTO sna_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Akati kwaari, “Zvakanaka, ndichaitawo zvawakumbira; handisi kuzoparadza guta rauri kureva. ");
INSERT INTO sna_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Asi chitizirai ikoko nokukurumidza, nokuti handigoni kuita chinhu chipi zvacho kusvikira masvika kwariri.” (Ndokusaka guta iro richinzi Zoari.) ");
INSERT INTO sna_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kusvika kwakaita Roti paZoari, zuva rakanga rakwira pamusoro penyika. ");
INSERT INTO sna_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ipapo Jehovha akanayisa safuri inopfuta pamusoro peSodhomu neGomora, zvichibva kudenga kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Naizvozvo akaparadza maguta ayo uye nebani rose, navose vakanga vagere mumaguta uyewo nezvose zvakanga zvamera munyika. ");
INSERT INTO sna_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Asi mukadzi waRoti akacheuka, akava shongwe yomunyu. ");
INSERT INTO sna_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Fume mangwana mangwanani Abhurahama akamuka akadzokera kunzvimbo yaakanga amira pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Akatarisa zasi kwakanangana nokuSodhomu neGomora, kwakatarisana nokunyika yose yebani, akaona utsi hwakawanda huchisimuka kubva panyika, kufanana noutsi hunobva pachoto. ");
INSERT INTO sna_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Saka Mwari paakaparadza maguta omubani, akarangarira Abhurahama, uye akabudisa Roti kubva panjodzi yakaparadza maguta makanga muchigara Roti. ");
INSERT INTO sna_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Roti navanasikana vake vaviri vakabva paZoari vakandogara mumakomo, nokuti akanga achitya kugara muZoari. Iye navanasikana vake vakagara mubako. ");
INSERT INTO sna_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Rimwe zuva mwanasikana wake mukuru akati kumuduku wake, “Baba vedu vakwegura, uye pano hapana varume vokuti vavate nesu, setsika yenyika yose. ");
INSERT INTO sna_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ngatinwisei baba vedu waini tigorara navo kuti tichengetedze rudzi rwedu kubudikidza nababa vedu.” ");
INSERT INTO sna_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Usiku ihwohwo vakanwisa baba vavo waini, uye mwanasikana mukuru akapinda akavata navo. Ivo havana kuziva kuvata kwake pasi kana kumuka kwake. ");
INSERT INTO sna_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pazuva rakatevera mwanasikana mukuru akati kumuduku wake, “Madeko ndakavata nababa vangu. Ngativanwiseizve waini usiku huno, iwe ugopinda undovata navo kuitira kuti tichengete rudzi rwedu kubudikidza nababa vedu.” ");
INSERT INTO sna_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Saka vakaita kuti baba vavo vanwezve waini usiku ihwohwo uye mwanasikana muduku akapinda akandovata navo. Ivo havana kuziva kuvata kwake pasi kana kumuka kwake. ");
INSERT INTO sna_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Saka vanasikana vose vaRoti vakava nemimba nababa vavo. ");
INSERT INTO sna_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwanasikana mukuru akava nomwanakomana, akamutumidza zita rokuti Moabhu; ndiye baba wavaMoabhu vanhasi. ");
INSERT INTO sna_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mwanasikana muduku akavawo nomwanakomana, uye akamutumidza zita rokuti Bheni-Ami; ndiye baba wavaAmoni vanhasi. ");
INSERT INTO sna_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Zvino Abhurahama akabvapo akapinda mudunhu rokuNegevhi akandogara pakati peKadheshi neShuri. Akagara muGerari kwechinguva, ");
INSERT INTO sna_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","uye ikoko Abhurahama akati nezvomukadzi wake Sara, “Ihanzvadzi yangu.” Ipapo Abhimereki mambo weGerari akatuma vanhu kuti vandotora Sara. ");
INSERT INTO sna_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Asi Mwari akauya kuna Abhimereki usiku mukurota uye akati kwaari, “Wakangoita somunhu akafa nokuda kwomukadzi wawatora; mukadzi womunhu.” ");
INSERT INTO sna_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Zvino Abhimereki akanga asati aswedera kwaari, saka akati, “Ishe, muchaparadza rudzi rusina mhosva here? ");
INSERT INTO sna_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ko, iye haana kuti kwandiri, ‘Ihanzvadzi yangu’ here, naiyewo mukadzi haana kuti kwandiri ‘Ihanzvadzi yangu’ here? Ndakaita izvi nehana yakachena uye namaoko akachena.” ");
INSERT INTO sna_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ipapo Mwari akati kwaari mukurota, “Hongu, ndinozviziva kuti wakaita izvi nehana yakachena, nokudaro ndakukonesa kuti unditadzire. Ndokusaka ndisina kukutendera kuti umubate. ");
INSERT INTO sna_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Zvino chidzosera mukadzi womurume uyu, nokuti muprofita, uye achakunyengeterera urarame. Asi kana usina kumudzosa, uzive kuti iwe navose vari vako muchafa.” ");
INSERT INTO sna_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mangwanani akatevera Abhimereki akadana varanda vake vose, uye paakavaudza zvose zvakanga zvaitika, vakatya kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ipapo Abhimereki akadana Abhurahama kuti apinde akati, “Waiteiko kwatiri? Ndakakutadzira zvakaita seiko zvawauyisa mhosva huru yakadai pamusoro pangu napamusoro poumambo hwangu? Wandiitira zvinhu zvisingafaniri kuitwa.” ");
INSERT INTO sna_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Uye Abhimereki akabvunza Abhurahama akati, “Wakaoneiko chakaita kuti uite izvi?” ");
INSERT INTO sna_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abhurahama akapindura akati, “Ndakati mumwoyo mangu, ‘Zvirokwazvo munzvimbo ino hamuna kutya Mwari, uye vachandiuraya nokuda kwomukadzi wangu.’ ");
INSERT INTO sna_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Zvisinei hazvo, zvirokwazvo ihanzvadzi yangu, mwanasikana wababa vangu kunyange hazvo asina kuberekwa namai vangu; uye akazova hake mukadzi wangu. ");
INSERT INTO sna_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Uye Mwari paakandiita kuti ndifambe kubva paimba yababa vangu, ndakati kwaari, ‘Izvi ndizvo zvaungandiratidza nazvo madiro aunondiita: Kwose kwatinoenda, utaure pamusoro pangu uchiti, “Ihanzvadzi yangu.” ’ ” ");
INSERT INTO sna_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ipapo Abhimereki akauya namakwai nemombe uye navarandarume navarandakadzi akavapa kuna Abhurahama, uye akadzosa Sara mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Uye Abhimereki akati, “Nyika yangu iri pamberi pako; gara paunoda.” ");
INSERT INTO sna_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kuna Sara akati, “Ndiri kupa hanzvadzi yako mashekeri chiuru esirivha. Ichi ndicho chichava chifukidzo pamusoro pemhosva yandakaita kwauri pamberi pavose vaunavo; waruramiswa kwazvo.” ");
INSERT INTO sna_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ipapo Abhurahama akanyengetera kuna Mwari, uye Mwari akaporesa Abhimereki, mukadzi wake uye navarandakadzi vake kuti vakwanise kuita vana zvakare, ");
INSERT INTO sna_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","nokuti Jehovha akanga azarira zvizvaro zvavo zvose muimba yaAbhimereki nokuda kwaSara mukadzi waAbhurahama. ");
INSERT INTO sna_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Zvino Jehovha akaitira Sara nyasha sezvaakanga areva, uye Jehovha akaitira Sara zvaakanga avimbisa. ");
INSERT INTO sna_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara akava nemimba uye akaberekera Abhurahama mwanakomana munguva yokukwegura kwake, panguva chaiyo yakanga yavimbiswa naMwari. ");
INSERT INTO sna_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abhurahama akatumidza mwanakomana waakaberekerwa naSara zita rokuti Isaka. ");
INSERT INTO sna_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mwanakomana wake Isaka paakanga ava namazuva masere okuberekwa, Abhurahama akamudzingisa, sezvaakanga arayirwa naMwari. ");
INSERT INTO sna_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abhurahama akanga ava namakore okuberekwa zana paakaberekerwa mwanakomana wake Isaka. ");
INSERT INTO sna_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara akati, “Mwari andivigira kuseka, uye vose vachanzwa nezvazvo vachaseka neni.” ");
INSERT INTO sna_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Uye akatizve, “Ndianiko aizoti kuna Abhurahama, Sara achazorera vana? Asi ndamuberekera mwanakomana panguva yokukwegura kwake.” ");
INSERT INTO sna_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana akakura uye akarumurwa, uye pazuva rakarumurwa Isaka, Abhurahama akaita mutambo mukuru. ");
INSERT INTO sna_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Asi Sara akaona mwanakomana akanga aberekerwa Abhurahama naHagari muIjipita achiseka, ");
INSERT INTO sna_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ndokubva ati kuna Abhurahama, “Dzinga mukadzi murandakadzi uyo nomwanakomana wake, nokuti mwanakomana womurandakadzi uyo haangatongogovani nhaka nomwanakomana wangu Isaka.” ");
INSERT INTO sna_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nyaya iyi yakatambudza Abhurahama zvikuru kwazvo nokuti yaiva nechokuita nomwanakomana wake. ");
INSERT INTO sna_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Asi Mwari akati kwaari, “Usanyanya kutambudzika hako pamusoro pomukomana uye napamusoro pomurandakadzi wako. Teerera zvaunoudzwa naSara, nokuti muna Isaka ndimo muchaverengerwa vana vako. ");
INSERT INTO sna_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ndichaitawo rudzi kubudikidza nomwanakomana womurandakadzi, nokuti naiyewo mwana wako.” ");
INSERT INTO sna_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mangwanani akatevera, Abhurahama akatora zvokudya neguchu redehwe rine mvura akazvipa kuna Hagari. Akazviisa pamapfudzi ake ipapo akamuendesa pamwe chete nomukomana. Akaenda uye akadzungaira ari mugwenga reBheerishebha. ");
INSERT INTO sna_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mvura yaiva muguchu redehwe yakati yapera, akaisa mukomana pasi pegwenzi. ");
INSERT INTO sna_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ipapo akabvapo akandogara pedyo naipapo, nhambwe inenge ingasvika museve, nokuti akafunga mumwoyo make akati, “Handingatariri mukomana achifa.” Uye agere pedyo ipapo akatanga kuchema. ");
INSERT INTO sna_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mwari akanzwa mukomana achichema, uye mutumwa waMwari akadana Hagari kubva kudenga akati kwaari, “Zvaita seiko Hagari? Usatya; Mwari anzwa kuchema kwomukomana paakavata apo. ");
INSERT INTO sna_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Simudza mukomana umubate noruoko, nokuti ndichamuita rudzi rukuru.” ");
INSERT INTO sna_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ipapo Mwari akasvinudza meso ake uye akaona tsime remvura. Saka akaenda akandozadza guchu nemvura ndokubva apa mukomana kuti anwe. ");
INSERT INTO sna_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mwari akava nomukomana pakukura kwake. Akagara mugwenga akazova munhu aipfura nouta. ");
INSERT INTO sna_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paakanga achigara mugwenga reParani, mai vake vakamutsvakira mukadzi aibva kuIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Panguva iyoyo Abhimereki naPikori mukuru wamauto ake, akati kuna Abhurahama, “Mwari anewe pazvinhu zvose zvaunoita. ");
INSERT INTO sna_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Zvino ndipikire pano pamberi paMwari kuti hauzondinyengeri ini, kana vana vangu kana zvizvarwa zvangu. Ndiitirei tsitsi ini nenyika yaugere mairi somutorwa, kuti sezvandakakuitira tsitsi uchaita zvimwe chetezvo newewo.” ");
INSERT INTO sna_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abhurahama akati, “Ndinopika.” ");
INSERT INTO sna_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ipapo Abhurahama akamhanʼara kuna Abhimereki pamusoro petsime remvura rakanga ratorwa navaranda vaAbhimereki. ");
INSERT INTO sna_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Asi Abhimereki akati, “Handizivi akaita izvozvo. Iwe hauna kundiudza, uye ndatozvinzwa izvozvo nhasi chaiye.” ");
INSERT INTO sna_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Saka Abhurahama akauya namakwai nemombe akazvipa kuna Abhimereki, uye varume vaviri ava vakaita sungano. ");
INSERT INTO sna_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abhurahama akatsaura sheche nomwe dzamakwayana kubva kuboka, ");
INSERT INTO sna_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","uye Abhimereki akabvunza Abhurahama akati, “Sheche dzamakwai idzi dzawatsaura dzinoreveiko?” ");
INSERT INTO sna_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Akapindura achiti, “Gamuchira makwayana manomwe aya kubva muruoko rwangu sechapupu chokuti ndini ndakachera tsime iri.” ");
INSERT INTO sna_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Saka nzvimbo iyo yakanzi Bheerishebha, nokuti varume vaviri ava vakapika mhiko ipapo. ");
INSERT INTO sna_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mushure mokuitwa kwesungano paBheerishebha, Abhimereki naPikori mukuru wamauto ake vakadzokera kunyika yavaFiristia. ");
INSERT INTO sna_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abhurahama akadyara muti womutamarisiki muBheerishebha, uye ipapo akadana kuzita raJehovha, Mwari Wokusingaperi. ");
INSERT INTO sna_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Uye Abhurahama akagara munyika yavaFiristia kwenguva refu. ");
INSERT INTO sna_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Shure kwaizvozvo, Mwari akaedza Abhurahama. Akati kwaari, “Abhurahama!” Iye akati, “Ndiri pano hangu.” ");
INSERT INTO sna_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ipapo Mwari akati, “Tora mwanakomana wako, mwanakomana wako mumwe oga, Isaka, iye waunoda, uende kunyika yeMoria. Umubayire ikoko sechipiriso chinopiswa pane rimwe gomo randichakuudza.” ");
INSERT INTO sna_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mangwanani akatevera, Abhurahama akamuka akasunga mbongoro yake. Akatora varanda vake vaviri nomwanakomana wake Isaka. Akati atema huni dzechipiriso chinopiswa dzakakwana, akasimuka akaenda kunzvimbo yaakanga audzwa nezvayo naMwari. ");
INSERT INTO sna_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pazuva rechitatu, Abhurahama akasimudza meso ake akaona nzvimbo yacho ichiri kure. ");
INSERT INTO sna_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Akati kuvaranda vake, “Sarai henyu pano nembongoro iyi, ini nomukomana timboyambukira uko. Tichandonamata tigodzoka hedu kwamuri.” ");
INSERT INTO sna_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abhurahama akatora huni dzechipiriso chinopiswa akadziisa pana Isaka mwanakomana wake, uye iye pachake akatakura moto nebanga. Pavakanga vachifamba pamwe chete vari vaviri, ");
INSERT INTO sna_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka akataura nababa vake Abhurahama akati, “Baba!” Abhurahama akati, “Chiiko mwanangu?” Isaka akati, “Moto nehuni zviri pano, asi gwayana rechipiriso chinopiswa riripiko?” ");
INSERT INTO sna_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abhurahama akapindura akati, “Mwari pachake ndiye achapa gwayana rechipiriso chinopiswa, mwanakomana wangu.” ");
INSERT INTO sna_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Vakati vasvika panzvimbo yaakanga ataurirwa nezvayo naMwari, Abhurahama akavaka aritari ipapo uye akaisa huni pamusoro payo. Akasunga mwanakomana wake Isaka akamuradzika paaritari, pamusoro pehuni. ");
INSERT INTO sna_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ipapo akatambanudza ruoko rwake akatora banga kuti auraye mwanakomana wake. ");
INSERT INTO sna_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Asi mutumwa waJehovha akadanidzira kwaari kubva kudenga akati, “Abhurahama! Abhurahama!” Iye akapindura akati, “Ndiri pano hangu.” ");
INSERT INTO sna_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Akati, “Usaisa ruoko rwako pamukomana. Usamboita chimwe chinhu kwaari. Zvino ndava kuziva kuti unotya Mwari, nokuti hauna kundinyima mwanakomana wako, mwanakomana wako mumwe woga.” ");
INSERT INTO sna_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abhurahama akasimudza meso ake uye ipapo padenhere akaona gondobwe rakabatwa nenyanga dzaro. Akaendapo akatora gondobwe akaribayira sechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Saka Abhurahama akatumidza nzvimbo iyo kuti, “Jehovha Achapa.” Uye nanhasi zvinonzi, “Pagomo raJehovha ndipo pazvichapiwa.” ");
INSERT INTO sna_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mutumwa waJehovha akadana kuna Abhurahama kubva kudenga kechipiri ");
INSERT INTO sna_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","akati, “Ndinopika neni pachangu, ndizvo zvinotaura Jehovha, kuti nokuda kwokuti waita izvi uye kuti hauna kundinyima mwanakomana wako, mwanakomana wako mumwe oga, ");
INSERT INTO sna_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","zvirokwazvo ndichakuropafadza uye ndichaita kuti zvizvarwa zvako zviwande senyeredzi dzokudenga uye sejecha riri pamahombekombe egungwa. Zvizvarwa zvako zvichatora maguta avavengi vavo, ");
INSERT INTO sna_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","uye kubudikidza navana vako ndudzi dzose dzapanyika dzicharopafadzwa, nokuti wakanditeerera.” ");
INSERT INTO sna_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ipapo Abhurahama akadzokera kuvaranda vake, vakasimuka vose pamwe chete vakaenda kuBheerishebha. ");
INSERT INTO sna_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Shure kwaizvozvo, Abhurahama akaudzwa kuti, “Mirika ava maiwo; akaberekera mununʼuna wako Nahori vanakomana vanoti: ");
INSERT INTO sna_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uzi dangwe, Bhuzi mununʼuna wake, Kemueri (baba vaAramu), ");
INSERT INTO sna_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedhi, Hazo, Piridhashi, Jidhirafi naBhetueri.” ");
INSERT INTO sna_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bhetueri akabereka Rabheka. Mirika akaberekera Nahori mununʼuna waAbhurahama vanakomana vasere ava. ");
INSERT INTO sna_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Murongo wake ainzi Reuma, naiyewo akava navanakomana vaiti: Tebha, Gahamu, Tahashi naMaaka. ");
INSERT INTO sna_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara akararama akasvika makore zana namakumi maviri namanomwe okuberekwa. ");
INSERT INTO sna_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Akafira paKiriati Abha (ndiro Hebhuroni) munyika yeKenani, uye Abhurahama akandochema Sara akaungudza pamusoro pake. ");
INSERT INTO sna_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ipapo Abhurahama akasimuka kubva parutivi pomukadzi wake akanga afa akandotaura navaHiti, akati, ");
INSERT INTO sna_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ndiri mutorwa nomueni pakati penyu. Nditengesereiwo nzvimbo pano yokuviga kuti ndigogona kuviga vakafa vangu.” ");
INSERT INTO sna_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","VaHiti vakapindura Abhurahama vakati, ");
INSERT INTO sna_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ishe, tinzwei. Imi muri muchinda mukuru pakati pedu. Vigai henyu akafa wenyu muguva rakaisvonaka pakati pamakuva edu. Hakuna munhu pakati pedu angakunyimai guva rake kuti muvige akafa wenyu.” ");
INSERT INTO sna_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ipapo Abhurahama akasimuka akakotamira pasi pamberi pavanhu venyika, ivo vaHiti. ");
INSERT INTO sna_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Akati kwavari, “Kana muchida kuti ndivige akafa wangu, zvino chindinzwai uye mundikumbirire kuna Efuroni mwanakomana waZohari pachinzvimbo changu, ");
INSERT INTO sna_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kuti anditengesere bako raMakapera, raanaro uye riri kumucheto womunda wake. Mukumbirei kuti anditengesere nomutengo uzere ive nzvimbo yangu yokuviga vakafa pakati penyu.” ");
INSERT INTO sna_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efuroni muHiti akanga agere pakati pavanhu vake akapindura Abhurahama, vaHiti vose vakanga vauya pasuo reguta vachizvinzwa, ");
INSERT INTO sna_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","akati, “Kwete, ishe wangu. Inzwai; ndinokupai munda, uye ndinokupai bako riri mauri. Ndinoupa kwamuri pamberi pavanhu vangu. Vigai henyu akafa wenyu.” ");
INSERT INTO sna_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Zvakare Abhurahama akakotamira pasi pamberi pavanhu venyika ");
INSERT INTO sna_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","akati kuna Efuroni vachizvinzwa, “Nditeerere, kana uchida. Ndicharipa mutengo womunda. Ugamuchire hako kubva kwandiri kuti ndigoviga vakafa vangu imomo.” ");
INSERT INTO sna_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuroni akapindura Abhurahama akati, ");
INSERT INTO sna_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Nditeererei, ishe wangu, mutengo wenyika unoita mashekeri mazana mana esirivha, asi chingava chiiko pakati pangu nemi? Vigai henyu akafa venyu.” ");
INSERT INTO sna_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abhurahama akabvumirana nomutengo waEfuroni akamuyerera mutengo waakanga areva vaHiti vachizvinzwa; mazana mana amashekeri esirivha, maererano nomutengo waivapo pakati pavatengesi. ");
INSERT INTO sna_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Saka munda waEfuroni muMakapera pedyo neMamure, zvose munda nebako zvaive mauri, nemiti yose yaiva pakati pomuganhu womunda, zvakapiwa ");
INSERT INTO sna_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kuna Abhurahama zvikava zvake pamberi pavaHiti vakanga vauya pasuo reguta. ");
INSERT INTO sna_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Shure kwaizvozvo Abhurahama akaviga mukadzi wake Sara mubako mumunda weMakapera pedyo neMamure (iro Hebhuroni) munyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Saka munda nebako raiva mauri zvakapiwa kuna Abhurahama navaHiti senzvimbo yamakuva. ");
INSERT INTO sna_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Zvino Abhurahama akanga akwegura ava namakore mazhinji, uye Jehovha akanga amuropafadza pazvinhu zvose. ");
INSERT INTO sna_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Akati kumuranda wake mukuru womumba make, iye akanga ari mutariri wezvose zvaakanga anazvo, “Isa ruoko rwako pasi pechidya changu. ");
INSERT INTO sna_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ndinoda kuti upike naJehovha, Mwari wokudenga uye Mwari wenyika, kuti haungatoreri mwanakomana wangu mukadzi kubva kuvanasikana vavaKenani, avo vandigere pakati pavo, ");
INSERT INTO sna_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","asi uchaenda kunyika yangu nokuhama dzangu ugondotorera mwanakomana wangu Isaka mukadzi.” ");
INSERT INTO sna_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Muranda akabvunza akati, “Ko, kana mukadzi asingadi kuuya neni kunyika ino? Ndichazoenda here nomwanakomana wenyu kunyika yamakabva?” ");
INSERT INTO sna_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abhurahama akati, “Chenjera kuti urege kudzokera nomwanakomana wangu ikoko. ");
INSERT INTO sna_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehovha, Mwari wokudenga, akandibudisa muimba yababa vangu nomunyika yokuzvarwa kwangu uye iye akataura kwandiri akandivimbisa nemhiko achiti, ‘Ndichapa nyika iyi kuvana vako,’ achatuma mutumwa pamberi pako kuitira kuti ugogona kuwanira mwanakomana wangu mukadzi kubva ikoko. ");
INSERT INTO sna_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kana mukadzi asingadi kuuya newe, iwe uchasunungurwa pamhiko yangu iyi. Usadzokera chete nomwanakomana wangu ikoko.” ");
INSERT INTO sna_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Saka muranda akaisa ruoko rwake pasi pechidya chatenzi wake Abhurahama akapika mhiko kwaari maererano neshoko iri. ");
INSERT INTO sna_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ipapo muranda akatora ngamera dzatenzi wake gumi akaenda, akatora mhando dzezvinhu zvose zvakanaka kubva kuna tenzi wake. Akasimuka akaenda kuAramu Naharaimu akananga kuguta reNahori. ");
INSERT INTO sna_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Akaita kuti ngamera dzipfugame pasi pedyo netsime raiva kunze kweguta; kwakanga kwava kudoka, nguva yaibuda vakadzi kundochera mvura. ");
INSERT INTO sna_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Akanyengetera akati, “Haiwa Jehovha, Mwari watenzi wangu Abhurahama, itai kuti ndibudirire nhasi, muitire tenzi wangu Abhurahama zvakanaka. ");
INSERT INTO sna_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Onai, ndimire parutivi petsime rino, uye vanasikana vavanhu vomuguta rino vari kubuda vachiuya kuzochera mvura. ");
INSERT INTO sna_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ngazviitike kuti pandinoti kumusikana, ‘Ndapota, tura chirongo chako kuti ndinwewo mvura,’ uye iye akati, ‘Inwai henyu uye ndichanwisawo ngamera dzenyu’ ngaave iye wamasarudzira muranda wenyu Isaka. Naizvozvo ndichaziva kuti maitira tenzi wangu zvakanaka.” ");
INSERT INTO sna_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Asati apedza kunyengetera, Rabheka akasvika nechirongo chake papfudzi rake. Akanga ari mwanasikana waBhetueri mwanakomana waMirika, mukadzi waNahori mununʼuna waAbhurahama. ");
INSERT INTO sna_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Musikana akanga akanaka kwazvo, ari mhandara; hakuna murume akanga ambovata naye. Akaenda kutsime, akazadza chirongo chake akadzokazve. ");
INSERT INTO sna_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Muranda akamhanya akandosangana naye akati, “Ndapota, ndipewo mvura shoma shoma yokunwa kubva muchirongo chako.” ");
INSERT INTO sna_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iye akati, “Inwai henyu, ishe wangu,” akakurumidza kutura chirongo mumaoko ake uye akamupa kuti anwe. ");
INSERT INTO sna_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Shure kwokumupa mvura kuti anwe, akati, “Ndichachererawo ngamera dzenyu mvura, kusvikira dzapedza kunwa.” ");
INSERT INTO sna_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Saka akakurumidza kudururira mvura yaiva muchirongo chake muchinwiro, akamhanyira kutsime zvakare kundochera imwe mvura zhinji, akachera yakakwanira ngamera dzake. ");
INSERT INTO sna_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Asina chaakataura, murume uyu akamutarisisa kuti azive kuti Jehovha akanga aita kuti rwendo rwake rubudirire here kana kuti kwete. ");
INSERT INTO sna_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamera dzakati dzapedza kunwa, murume uya akatora mhete yegoridhe yapamhino yairema hafu yeshekeri nezvishongo zviviri zvamaoko zvairema mashekeri gumi. ");
INSERT INTO sna_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ipapo akamubvunza akati, “Uri mwanasikana waaniko? Ndapota, dondiudzawo, kumba kwababa vako kungaita nzvimbo yedu yokuvata here?” ");
INSERT INTO sna_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Akamupindura akati, “Ndiri mwanasikana waBhetueri, mwanakomana waMirika akaberekera Nahori.” ");
INSERT INTO sna_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Uye akatizve, “Tine uswa hwakawanda namashanga, uyewo nenzvimbo yenyu yokuvata.” ");
INSERT INTO sna_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ipapo murume uya akakotamira pasi akanamata Jehovha, ");
INSERT INTO sna_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","akati, “Jehovha ngaarumbidzwe, Mwari watenzi wangu Abhurahama, iye asina kurega kuita zvakanaka nokutendeka kwake kuna tenzi wangu. Kana ndirini, Jehovha akanditungamirira parwendo rwangu akandisvitsa kumba kwehama dzatenzi wangu.” ");
INSERT INTO sna_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Musikana akamhanya akandoudza veimba yamai vake pamusoro pezvinhu zvose izvi. ");
INSERT INTO sna_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Zvino Rabheka akanga ane hanzvadzi yainzi Rabhani, uye iye akakurumidza kubuda akaenda kumurume uya kutsime. ");
INSERT INTO sna_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Akati achingoona mhete yemhino nezvishongo mumaoko ehanzvadzi yake, uye anzwa Rabheka achitaura zvakanga zvarehwa nomurume uyu kwaari, akabuda akaenda kumurume akamuwana amire pangamera pedyo netsime. ");
INSERT INTO sna_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Akati, “Uya iwe wakaropafadzwa naJehovha. Wakamirireiko pano? Ndatogadzira imba nenzvimbo yengamera.” ");
INSERT INTO sna_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Saka murume uya akaenda kumba, uye ngamera dzakaturwa. Uswa namashanga zvakavigirwa ngamera, uye iye navanhu vake vakavigirwa mvura kuti vashambe tsoka dzavo. ");
INSERT INTO sna_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Zvokudya zvakaiswa pamberi pake, asi iye akati, “Handingatongodyi kusvikira ndakuudzai zvandinoda kureva.” Rabhani akati, “Tiudze hako zvino.” ");
INSERT INTO sna_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Saka iye akati, “Ndiri muranda waAbhurahama. ");
INSERT INTO sna_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jehovha akaropafadza tenzi wangu kwazvo, uye ava mupfumi. Akamupa makwai nemombe, sirivha negoridhe, varandarume navarandakadzi, ngamera nembongoro. ");
INSERT INTO sna_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara mukadzi watenzi wangu akamuberekera mwanakomana panguva yokukwegura kwake, uye akamupa zvinhu zvose zvaanazvo. ");
INSERT INTO sna_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Uye tenzi wangu akaita kuti ndipike mhiko, uye akati, ‘Haufaniri kutorera mwanakomana wangu mukadzi kubva kuvanasikana vavaKenani, munyika yandigere, ");
INSERT INTO sna_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","asi enda kumhuri yababa vangu uye nokuimba yangu, undotorera mwanakomana wangu mukadzi ikoko.’ ");
INSERT INTO sna_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ipapo ndakabvunza tenzi wangu ndikati, ‘Ko, kana mukadzi akasauya neni?’ ");
INSERT INTO sna_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Akapindura akati, ‘Jehovha, iye wandinofamba pamberi pake, achatuma mutumwa wake newe uye achaita kuti rwendo rwenyu rubudirire, kuti uwanire mwanakomana wangu mukadzi, paunoenda kuimba yokwangu, kumhuri yababa vangu. ");
INSERT INTO sna_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Zvino, kana wasvika kuimba yokwangu, iwe uchasunungurwa pamhiko kunyange vakaramba kumupa kwauri, uchasunungurwa pamhiko yangu.’ ");
INSERT INTO sna_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Pandasvika patsime nhasi, ndati, ‘Haiwa Jehovha, Mwari watenzi wangu Abhurahama, kana muchida, ndapota ndipeiwo kubudirira parwendo rwandafamba. ");
INSERT INTO sna_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tarirai, ndimire parutivi petsime iri; kana musikana akabuda kuzochera mvura uye ndikati kwaari, “Ndapota rega ndinwe mvura shoma shoma kubva muchirongo chako,” ");
INSERT INTO sna_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","uye kana iye akati kwandiri, “Inwai henyu, uye ndichachererawo ngamera dzenyu,” ngaave iye asarudzirwa mwanakomana watenzi wangu naJehovha.’ ");
INSERT INTO sna_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ndisati ndapedza kunyengetera mumwoyo mangu, Rabheka auya, ane chirongo chake papfudzi rake. Aenda kutsime uye akachera mvura, uye ini ndikati kwaari, ‘Ndapota ndipewo mvura ndinwe.’ ");
INSERT INTO sna_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Akurumidza kutura chirongo chake papfudzi rake akati, ‘Inwai henyu, uye ndichanwisa ngamera dzenyuwo.’ Saka ndanwa mvura, uye anwisawo ngamera. ");
INSERT INTO sna_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ndamubvunza ndikati, ‘Uri mwanasikana waaniko?’ “Iye ati, ‘Ndiri mwanasikana waBhetueri mwanakomana waNahori, waakaberekerwa naMirika.’ “Ipapo ndaisa mhete pamhino yake nezvishongo mumaoko ake, ");
INSERT INTO sna_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","uye ndakotama pasi ndikanamata Jehovha. Ndarumbidza Jehovha, Mwari watenzi wangu Abhurahama, uyo akanditungamirira munzira yakarurama kuti ndiwane muzukuru womununʼuna watenzi wangu kuti ave mukadzi womwanakomana wake. ");
INSERT INTO sna_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Zvino kana muchaitira zvakanaka nokutendeka kuna tenzi wangu, ndiudzei; uye kana zvisizvo, ndiudzei, kuti ndigoziva kwokuenda.” ");
INSERT INTO sna_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Rabhani naBhetueri vakapindura vakati, “Izvi zvinobva kuna Jehovha; isu hatina chinhu chatingataura kwauri, chakaipa kana chakanaka. ");
INSERT INTO sna_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hoyu Rabheka; mutore uende, uye ngaave mukadzi womwanakomana watenzi wako, sokutungamirirwa kwawaitwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Muranda waAbhurahama akati anzwa zvavakataura, akakotama pasi pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ipapo muranda akabudisa goridhe nezvishongo zvesirivha nenguo dzokufuka akazvipa kuna Rabheka; uye akapawo zvipo zvomutengo mukuru kuhanzvadzi yake nokuna mai vake. ");
INSERT INTO sna_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ipapo iye navarume vakanga vanaye vakadya vakanwa, uye vakararapo usiku uho. Akati amuka mangwanani, akati, “Ndiregei hangu ndichienda kuna tenzi wangu.” ");
INSERT INTO sna_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Asi hanzvadzi yake namai vake vakapindura vakati, “Regai musikana agare nesu mazuva angaita kana gumi; ipapo mungazoenda henyu.” ");
INSERT INTO sna_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Asi akati kwavari, “Musandirambidza, sezvo zvino Jehovha akandipa kubudirira parwendo rwangu. Ndiregei hangu ndiende kuna tenzi wangu.” ");
INSERT INTO sna_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ipapo vakati, “Regai tidane musikana timubvunze nezvazvo.” ");
INSERT INTO sna_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Saka vakadana Rabheka vakamubvunza vakati, “Uchaenda here nomurume uyu?” Iye akati, “Ndichaenda.” ");
INSERT INTO sna_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Saka vakaendesa hanzvadzi yavo Rabheka, pamwe chete nomureri wake nomuranda waAbhurahama navanhu vake. ");
INSERT INTO sna_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Uye vakaropafadza Rabheka vakati, “Iwe hanzvadzi yedu, uve mai wavazhinji vave zviuru nezviuru; vana vako ngavatore masuo avavengi vavo.” ");
INSERT INTO sna_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ipapo Rabheka navasikana vake vakagadzirira vakatasva ngamera dzavo vakaenda nomurume uya. Saka muranda akatora Rabheka akabva aenda. ");
INSERT INTO sna_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Zvino Isaka akanga achibva kuBheeri Rahai Roi, nokuti akanga achigara kuNegevhi. ");
INSERT INTO sna_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Humwe usiku akabuda akaenda musango kuti ambondorangarira, uye paakasimudza meso ake, akaona ngamera dzichiswedera, ");
INSERT INTO sna_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","naRabhekawo akasimudza meso ake akaona Isaka. Akaburuka kubva pangamera yake ");
INSERT INTO sna_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","uye akabvunza muranda akati, “Ndianiko murume ari musango uyo ari kuuya kuzosangana nesu?” Muranda akapindura akati, “Nditenzi wangu.” Saka akatora chifukidzo akazvifukidza. ");
INSERT INTO sna_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ipapo muranda akaudza Isaka zvose zvaakanga aita. ");
INSERT INTO sna_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka akamupinza mutende ramai vake Sara, uye akawana Rabheka. Saka akava mukadzi wake, uye akamuda; naizvozvo Isaka akanyaradzwa shure kwokufa kwamai vake. ");
INSERT INTO sna_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abhurahama akawana mumwe mukadzi, zita rake ainzi Ketura. ");
INSERT INTO sna_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Akamuberekera Zimurami, Jokishani, Medhani, Midhiani, Ishibhaki naShua. ");
INSERT INTO sna_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokishani akabereka Shebha naDhedhani; zvizvarwa zvaDhedhani zvakanga zviri vaAshuri, vaRetushi navaReumi. ");
INSERT INTO sna_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Vanakomana vaMidhiani vakanga vari Efa, Eferi, Hanoki, Abhidha naEridha. Vose ava vakanga vari zvizvarwa zvaKetura. ");
INSERT INTO sna_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abhurahama akasiya zvinhu zvose zvaakanga anazvo kuna Isaka. ");
INSERT INTO sna_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Asi paakanga achiri mupenyu akapa zvipo kuvanakomana vavarongo vake uye akavabvisa pamwanakomana wake Isaka akavaendesa kumabvazuva. ");
INSERT INTO sna_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Pamwe chete, Abhurahama akararama makore zana namakumi manomwe namashanu. ");
INSERT INTO sna_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ipapo Abhurahama akabudisa mweya wake akafa akwegura kwazvo, ava mutana uye ava namakore mazhinji; uye akasanganiswa navanhu vake. ");
INSERT INTO sna_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Vanakomana vake Isaka naIshumaeri vakamuviga mubako reMakapera pedyo neMamure, mumunda waEfuroni mwanakomana waZofa muHiti, ");
INSERT INTO sna_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","munda wakanga watengwa naAbhurahama kubva kumuHiti. Ndimo makavigwa Abhurahama nomukadzi wake Sara. ");
INSERT INTO sna_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Shure kwokufa kwaAbhurahama, Mwari akaropafadza mwanakomana wake Isaka, uyo akagara pedyo neBheeri Rahai Roi. ");
INSERT INTO sna_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iyi ndiyo nhoroondo yomwanakomana waAbhurahama, iye Ishumaeri, akaberekerwa Abhurahama naHagari muIjipita, murandakadzi waSara. ");
INSERT INTO sna_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aya ndiwo mazita avanakomana vaIshumaeri, akanyorwa muurongwa hwamaberekerwo avo: Nebhayoti dangwe raIshumaeri, Kedhari, Adhibheeri, Mibhisami, ");
INSERT INTO sna_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima, Dhuma, Masa, ");
INSERT INTO sna_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadhadhi, Tema, Jeturi, Nafishi naKedhema. ");
INSERT INTO sna_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ava ndivo vaiva vanakomana vaIshumaeri, uye aya ndiwo mazita avatongi gumi navaviri vamarudzi maererano namagariro avo nemisasa yavo. ");
INSERT INTO sna_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Pamwe chete, Ishumaeri akararama makore zana namakumi matatu namakore manomwe. Akabudisa mweya wake akafa, akasanganiswa navanhu vake. ");
INSERT INTO sna_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Zvizvarwa zvake zvakandogara munzvimbo yaibva kuHavhira kusvikira kuShuri, pedyo nomuganhu weIjipiti, kana munhu achienda akananga kuAshuri. Uye vakagara vachipesana nehama dzavo. ");
INSERT INTO sna_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iyi ndiyo nhoroondo yomwanakomana waAbhurahama, Isaka. Abhurahama akabereka Isaka, ");
INSERT INTO sna_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","uye Isaka akanga ava namakore makumi mana okuberekwa paakawana Rabheka mwanasikana waBhetueri muAramu, aibva kuPadhani Aramu uye ari hanzvadzi yaRabhani muAramu. ");
INSERT INTO sna_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka akanyengeterera mukadzi wake kuna Jehovha, nokuti akanga asingabereki. Jehovha akapindura munyengetero wake, uye mukadzi wake Rabheka akava nemimba. ");
INSERT INTO sna_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Vana vakanga vachisundana mukati make, iye akati, “Seiko izvi zvichiitika kwandiri?” Saka akaenda kundobvunza Jehovha. ");
INSERT INTO sna_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jehovha akati kwaari, “Ndudzi mbiri dziri muchizvaro chako, uye marudzi maviri achabuda mauri achaparadzana; rumwe rudzi ruchava nesimba kupfuura rumwe, uye mukuru achashumira muduku.” ");
INSERT INTO sna_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nguva yokubereka kwake yakati yasvika, onei makanga muna vakomana vaviri muchizvaro chake. ");
INSERT INTO sna_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Akatanga kubuda akanga ari mutsvuku, uye muviri wake wose wakanga wakaita senguo ine mvere; saka vakamutumidza zita rokuti Esau. ");
INSERT INTO sna_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Shure kwaizvozvo, mununʼuna wake akabuda, ruoko rwake rwakabata chitsitsinho chaEsau; saka akatumidzwa zita rokuti Jakobho. Isaka akanga ava namakore okuberekwa makumi matanhatu Rabheka paakavabereka. ");
INSERT INTO sna_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Vakomana vakakura, uye Esau akava mudzimba akachenjera, murume wesango, asi Jakobho akanga ari murume akanyarara, achigara pakati pamatende. ");
INSERT INTO sna_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Sezvo Isaka aifarira nyama yemhuka, aida Esau, asi Rabheka aida Jakobho. ");
INSERT INTO sna_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Rimwe zuva Jakobho paakanga achibika zvokudya, Esau akasvikopinda achibva kusango, aziya nenzara! ");
INSERT INTO sna_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Akati kuna Jakobho, “Dokurumidzawozve, undipewo zvimwe zvokudya zvakatsvukira izvo ndidye! Ndava kuziya nenzara!” (Ndokusaka akatumidzwawo zita rokuti Edhomu). ");
INSERT INTO sna_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakobho akapindura akati, “Tanga wanditengesera udangwe hwako.” ");
INSERT INTO sna_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau akati, “Tarira, ndava kuda kufa ini. Ko, udangwe huchandibatsirei?” ");
INSERT INTO sna_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Asi Jakobho akati, “Tanga wandipikira.” Saka akapika mhiko kwaari, achitengesa udangwe hwake kuna Jakobho. ");
INSERT INTO sna_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ipapo Jakobho akapa Esau chingwa nenyemba. Akadya uye akanwa, ipapo akasimuka akaenda. Saka Esau akazvidza udangwe hwake. ");
INSERT INTO sna_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Zvino munyika makanga mune nzara, isati iri nzara iya yakatanga kuvapo panguva yaAbhurahama, uye Isaka akaenda kuna Abhimereki mambo wavaFiristia muGerari. ");
INSERT INTO sna_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jehovha akazviratidza kuna Isaka akati, “Usaburuka kuIjipiti; gara munyika yandinokuudza kuti ugare. ");
INSERT INTO sna_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Gara hako munyika ino kwechinguva, uye ndichava newe uye ndichakuropafadza. Nokuti kwauri nokuzvizvarwa zvako ndichapa nyika iyi yose uye ndichasimbisa mhiko yandakapika kuna baba vako Abhurahama. ");
INSERT INTO sna_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ndichaita kuti zvizvarwa zvako zviwande senyeredzi dzokudenga uye ndichavapa nyika dzose idzi, uye kubudikidza navana vako ndudzi dzose dzapanyika dzicharopafadzwa, ");
INSERT INTO sna_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","nokuti Abhurahama akanditeerera uye akachengeta zvaidikanwa neni, nemitemo yangu, zvirevo zvangu uye nemirayiro yangu.” ");
INSERT INTO sna_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Saka Isaka akagara muGerari. ");
INSERT INTO sna_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Vanhu venyika iyo pavakamubvunza pamusoro pomukadzi wake, akati, “Ihanzvadzi yangu,” nokuti akanga achitya kuti, “Mukadzi wangu.” Akafunga mumwoyo make achiti, “Vanhu vomunyika muno vangandiuraye nokuda kwaRabheka, nokuti akanaka kwazvo.” ");
INSERT INTO sna_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka akati agara ikoko kwenguva refu, Abhimereki mambo wavaFiristia akatarira pasi napawindo akaona Isaka achitamba nomukadzi wake Rabheka. ");
INSERT INTO sna_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Saka Abhimereki akadana Isaka akati, “Mukadzi wako chaiye uyu! Seiko wakati, ‘Ihanzvadzi yangu’?” Isaka akapindura akati, “Nokuti ndakafunga kuti ndingafa nokuda kwake.” ");
INSERT INTO sna_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ipapo Abhimereki akati, “Chiiko ichi chawakaita kwatiri? Mumwe wavarume aigona kunge akavata nomukadzi wako, uye ungadai wakazouyisa mhosva pamusoro pedu.” ");
INSERT INTO sna_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Saka Abhimereki akarayira vanhu vake vose achiti, “Ani naani anobata murume uyu kana mukadzi wake achaurayiwa zvirokwazvo.” ");
INSERT INTO sna_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka akadyara zviyo munyika uye mugore racho iroro akakohwa zvakapetwa kazana, nokuti Jehovha akamuropafadza. ");
INSERT INTO sna_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Murume uyu akava mupfumi, uye pfuma yake yakaramba ichiwanda kusvikira apfuma kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Akanga ana makwai mazhinji nemombe dzakawanda navaranda vakawanda zvokuti vaFiristia vakamuitira godo. ");
INSERT INTO sna_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Saka matsime ose akanga acherwa navaranda vababa vake panguva yababa vake Abhurahama, vaFiristia vakaadzivira, vachiazadza nevhu. ");
INSERT INTO sna_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ipapo Abhimereki akati kuna Isaka, “Ibva uende kure nesu; wanyanya kuva nesimba zvokutipfuura.” ");
INSERT INTO sna_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Saka Isaka akabvapo akandodzika musasa muMupata weGera akagara ikoko. ");
INSERT INTO sna_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka akacherazve matsime akanga acherwa panguva yababa vake Abhurahama, iwo akanga adzivirwa navaFiristia shure kwokufa kwaAbhurahama, uye akaapa mazita mamwe chetewo aakanga atumidzwa nababa vake. ");
INSERT INTO sna_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Varanda vaIsaka vakachera muMupata vakawanamo tsime remvura yakanaka. ");
INSERT INTO sna_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Asi vafudzi veGerari vakakakavadzana navafudzi vaIsaka vachiti, “Mvura iyi ndeyedu!” Saka akatumidza tsime iro zita rokuti Eseki, nokuda kwokuti vakapesana naye. ");
INSERT INTO sna_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ipapo vakacherazve rimwe tsime, asi vakakakavadzana pamusoro parowo; saka akaritumidza zita rokuti Sitima. ");
INSERT INTO sna_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Akaenderera mberi kubva ipapo akachera rimwe tsime, uye hapana munhu akazokakavadzana naye pamusoro paro. Akaritumidza zita rokuti Rehobhoti, achiti, “Zvino Jehovha azotipa nzvimbo uye tichawanda munyika.” ");
INSERT INTO sna_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kubva ipapo akaenda kuBheerishebha. ");
INSERT INTO sna_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Usiku ihwohwo Jehovha akazviratidza kwaari akati, “Ndini Mwari wababa vako Abhurahama. Usatya, nokuti ndinewe. Ndichakuropafadza uye ndichakurisa zvizvarwa zvako nokuda kwomuranda wangu Abhurahama.” ");
INSERT INTO sna_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka akavaka aritari ipapo akadana kuzita raJehovha. Akadzika tende rake ipapo uye pakare ipapo varanda vake vakachera tsime. ");
INSERT INTO sna_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Zvichakadaro, Abhimereki akanga asvika kwaari achibva kuGerari, aina Ahuzati aiva mupamazano wake naPikori mukuru wavarwi vake. ");
INSERT INTO sna_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka akavabvunza akati, “Mavingeiko kwandiri, sezvo makanga muri mhandu dzangu uye mukandidzinga?” ");
INSERT INTO sna_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Vakamupindura vakati, “Takaona pachena kuti Jehovha akanga anewe; saka takati, ‘Panofanira kuva nechitenderano chemhiko pakati pedu,’ pakati pedu newe. Ngatiite sungano newe ");
INSERT INTO sna_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","yokuti iwe hauzotiitiri zvakaipa, sezvo isu tisina kukubata zvakaipa asi takaramba tichikuitira zvakanaka uye tikakuendesa norugare. Uye zvino waropafadzwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ipapo Isaka akavaitira mutambo, vakadya, vakanwa. ");
INSERT INTO sna_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mangwanani akatevera varume ava vakapikirana. Ipapo Isaka akavaendesa parwendo rwavo, vakamusiya murugare. ");
INSERT INTO sna_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Musi iwoyo varanda vaIsaka vakauya vakamuudza nezvetsime ravakanga vachera. Vakati, “Tawana mvura!” ");
INSERT INTO sna_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Akaritumidza zita rokuti Shibha, uye kusvikira nhasi zita reguta richiri kunzi Bheerishebha. ");
INSERT INTO sna_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau akati ava namakore makumi mana okuberekwa, akawana Judhisi mwanasikana waBheeri muHiti, uyewo Bhasemati mwanasikana waEroni muHiti. ");
INSERT INTO sna_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ivava vakarwadzisa Isaka naRabheka. ");
INSERT INTO sna_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka akati akwegura uye meso ake akanga aneta zvokuti akanga asisaoni, akadana Esau mwanakomana wake mukuru akati kwaari, “Mwanakomana wangu.” Iye akapindura akati, “Ndiri pano.” ");
INSERT INTO sna_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka akati, “Zvino ndava murume mutana uye handizivi zuva rokufa kwangu. ");
INSERT INTO sna_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Naizvozvo zvino tora zvombo zvako, goba rako nouta ugoenda kusango kuti unondivhimirawo mhuka. ");
INSERT INTO sna_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Undigadzirire zvokudya zvinondinakira ugondivigira kuti ndidye, kuitira kuti ndikupe maropafadzo angu ndisati ndafa.” ");
INSERT INTO sna_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Zvino Rabheka akanga akateerera Isaka paakanga achitaura nomwanakomana wake Esau. Esau akati aenda kusango kuti andovhima mhuka kuti agouya nayo, ");
INSERT INTO sna_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rabheka akati kumwanakomana wake Jakobho, “Tarira, ndanzwa baba vako vachiti kumukoma wako Esau, ");
INSERT INTO sna_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ndivigirewo mhuka ugondigadzirira nyama inonaka kuti ndidye kuitira kuti ndigokupa maropafadzo angu ndisati ndafa.’ ");
INSERT INTO sna_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Zvino, chinzwa mwanakomana wangu, nyatsoteerera uye uite zvandinokuudza. ");
INSERT INTO sna_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Enda kuzvipfuwo unondivigira mbudzana mbiri dzakaisvonaka, kuti ndigogadzirira baba vako nyama inonaka nenzira chaiyo yavanoda. ");
INSERT INTO sna_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ipapo ugoitora uende nayo kuna baba vako kuti vadye, kuitira kuti vagokupa maropafadzo avo vasati vafa.” ");
INSERT INTO sna_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakobho akati kuna Rabheka mai vake, “Asi mukoma wangu Esau munhu ane mvere, uye ini ndiri munhu ane ganda risina mvere. ");
INSERT INTO sna_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ko, kana baba vangu vakandibata? Ndichava somunhu anovanyengera uye ndikazouyisa kutukwa pamusoro pangu pachinzvimbo chokuropafadzwa.” ");
INSERT INTO sna_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mai vake vakati kwaari, “Mwanakomana wangu, rega kutukwa kuuye pamusoro pangu. Iwe ita zvandinoreva; enda unonditorera idzo.” ");
INSERT INTO sna_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Saka akaenda akandodzitora akauya nadzo kuna mai vake, uye vakagadzira nyama inonaka, nenzira chaiyo yaidikanwa nababa vake. ");
INSERT INTO sna_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ipapo Rabheka akatora nguo dzakaisvonaka dzaEsau mwanakomana wake mukuru, dzaakanga anadzo mumba, akadzipfekedza mwanakomana wake muduku iye Jakobho. ");
INSERT INTO sna_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Akafukidzawo namatehwe embudzi, maoko ake uye nenzvimbo dzomutsipa wake dzakanga dzisina mvere. ");
INSERT INTO sna_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ipapo akapa kumwanakomana wake Jakobho nyama inonaka nechingwa chaakanga abika. ");
INSERT INTO sna_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Akaenda kuna baba vake akati, “Baba vangu.” Vakapindura vakati, “Ndiri pano mwana wangu. Ndianiko?” ");
INSERT INTO sna_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakobho akati kuna baba vake, “Ndini Esau dangwe renyu. Ndaita sezvamandiudza. Ndapota, mukai mudye nyama yemhuka yangu kuitira kuti mundipe maropafadzo enyu.” ");
INSERT INTO sna_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka akabvunza mwanakomana wake akati, “Waiwana seiko nokukurumidza zvakadai, mwanakomana wangu?” Iye akapindura akati, “Jehovha Mwari wenyu aita kuti ndibudirire.” ");
INSERT INTO sna_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ipapo Isaka akati kuna Jakobho, “Swedera pedyo kuti ndikubate, mwana wangu, kuti ndizive kana uri Esau mwanakomana wangu chaiye kana kwete.” ");
INSERT INTO sna_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakobho akaswedera kuna baba vake Isaka, iye akamubata akati, “Inzwi, inzwi raJakobho, asi maoko maoko aEsau.” ");
INSERT INTO sna_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Haana kugona kumuziva, nokuti maoko ake aiva nemvere dzakaita sedzomukoma wake Esau; saka akamuropafadza. ");
INSERT INTO sna_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Akati, “Ndiwe mwanakomana wangu Esau chaiye here?” Akapindura akati, “Ndini.” ");
INSERT INTO sna_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ipapo akati, “Mwanakomana wangu, ndipe nyama yako yemhuka ndidye, kuitira kuti ndikupe maropafadzo angu.” Jakobho akaiisa kwaari akadya; uye akauya newaini akanwa. ");
INSERT INTO sna_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ipapo baba vake Isaka vakati kwaari, “Uya pano mwanakomana wangu unditsvode.” ");
INSERT INTO sna_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Saka akaenda kwaari iye akamutsvoda. Isaka akati anzwa kunhuhwira kwenguo dzake akamuropafadza achiti, “Haiwa kunhuhwira kwomwanakomana wangu kwakaita sokunhuhwira kwesango raropafadzwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mwari ngaakupe dova rokudenga noupfumi hwenyika, zviyo zvakawanda newaini itsva. ");
INSERT INTO sna_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ndudzi ngadzikushumire uye marudzi akupfugamire. Uve ishe wehama dzako, uye vanakomana vamai vako vakupfugamire. Vaya vanokutuka ngavatukwe uye vaya vanokuropfadza ngavaropafadzwe.” ");
INSERT INTO sna_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Shure kwokunge Isaka apedza kumuropafadza uye Jakobho achangobva pamberi pababa vake, mukoma wake Esau akasvika achibva kundovhima. ");
INSERT INTO sna_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Naiyewo akagadzira nyama inonaka akauya nayo kuna baba vake. Ipapo akati kwavari, “Baba vangu, mukai mudye nyama yangu yemhuka, kuti mugondipa maropafadzo.” ");
INSERT INTO sna_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Baba vake Isaka vakamubvunza vakati, “Ndiwe aniko?” Akapindura akati, “Ndini Esau mwanakomana wenyu wedangwe.” ");
INSERT INTO sna_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka akadedera nehasha akati, “Ndianiko zvino, avhima mhuka akauya nayo kwandiri? Ndaidya iwe uchigere kusvika uye ndamuropafadza, uye zvirokwazvo acharopafadzwa!” ");
INSERT INTO sna_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau akati anzwa mashoko ababa vake akaridza mhere nokuchema kukuru neshungu uye akati kuna baba vake, “Ndiropafadzei neniwo, baba vangu!” ");
INSERT INTO sna_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Asi ivo vakati, “Mununʼuna wako auya nokunyengera akatora maropafadzo ako.” ");
INSERT INTO sna_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau akati, “Haana kutumidzwa zita chairo here rokuti Jakobho? Akandinyengera kaviri kose: Akatora udangwe hwangu, uye zvino atora maropafadzo angu!” Ipapo akabvunza akati, “Ko, hamuna kundichengeterawo kana ropafadzo here?” ");
INSERT INTO sna_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka akapindura Esau akati, “Ndamuita ishe wako uye ndakaita hama dzake dzose varanda vake, uye ndamusimbisa nezviyo newaini itsva. Saka chiiko chandichagona kukuitira mwana wangu?” ");
INSERT INTO sna_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau akati kuna baba vake, “Munongova neropafadzo imwe chete here, baba vangu? Ndiropafadzeiwo, baba vangu!” Ipapo Esau akachema achiridza mhere. ");
INSERT INTO sna_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Baba vake Isaka vakamupindura vakati, “Ugaro hwako huchava kure nepfuma yenyika, kure nedova rokudenga kumusoro. ");
INSERT INTO sna_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Iwe uchararama nomunondo uye uchashumira mununʼuna wako. Asi paunenge woshaya zororo uchabvisa joko rake kubva pamutsipa wako.” ");
INSERT INTO sna_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau akavenga Jakobho nokuda kwokuropafadzwa kwaakapiwa nababa vake. Akati mumwoyo make, “Mazuva okuchema baba vangu ava pedyo; ipapo ndichauraya mununʼuna wangu Jakobho.” ");
INSERT INTO sna_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rabheka akati audzwa zvakanga zvataurwa nomwanakomana wake mukuru Esau, akatuma munhu kuna Jakobho mwanakomana wake muduku akati kwaari, “Mukoma wako Esau ari kuzvinyaradza nepfungwa dzokuda kukuuraya. ");
INSERT INTO sna_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Naizvozvo zvino, mwanakomana wangu, chiita zvandinokuudza: Tiza izvozvi uende kuhanzvadzi yangu Rabhani kuHarani. ");
INSERT INTO sna_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ugare naye kwechinguva kusvikira shungu dzomukoma wako dzaserera. ");
INSERT INTO sna_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mukoma wako paachazenge asisina kukutsamwira uye akanganwa zvawakamuitira, ini ndichatuma shoko kwauri rokuti uchidzoka kubva ikoko. Ndorasikirwa nemi seiko muri vaviri zuva rimwe chete?” ");
INSERT INTO sna_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ipapo Rabheka akati kuna Isaka, “Ndinosemburwa noupenyu nokuda kwavakadzi vechiHiti ava. Kana Jakobho akatora mukadzi anobva pakati pavakadzi vechiHiti vakaita savava, kurarama kwangu hakungavi namaturo.” ");
INSERT INTO sna_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Saka Isaka akadana Jakobho akamuropafadza uye akamurayira achiti, “Usawana mukadzi muKenani. ");
INSERT INTO sna_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kurumidza uende kuPadhani Aramu kuimba yaBhetueri baba vamai vako. Uzvitorere mukadzi ikoko, kubva pakati pavanasikana vaRabhani, hanzvadzi yamai vako. ");
INSERT INTO sna_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mwari Wamasimba Ose ngaakuropafadze uye aite kuti ubereke uye akuitei vazhinji kusvikira mava marudzi mazhinji. ");
INSERT INTO sna_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngaakupe iwe nezvizvarwa zvako maropafadzo akapiwa kuna Abhurahama, kuitira kuti utore nyika yaugere zvino somutorwa, nyika yakapiwa Abhurahama naMwari.” ");
INSERT INTO sna_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ipapo Isaka akaendesa Jakobho, uye akaenda kuPadhani Aramu, kuna Rabhani mwanakomana waBhetueri muAramu, hanzvadzi yaRabheka, akanga ari mai vaJakobho naEsau. ");
INSERT INTO sna_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Zvino Esau akaziva kuti Isaka akanga aropafadza Jakobho uye kuti akanga amuendesa kuPadhani Aramu kuti andotora mukadzi ikoko, uye kuti paakamuropafadza akamurayira achiti, “Usawana mukadzi muKenani,” ");
INSERT INTO sna_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","uye kuti Jakobho akateerera baba namai vake akaenda kuPadhani Aramu. ");
INSERT INTO sna_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ipapo Esau akaziva kuti vakadzi veKenani vakanga vasingafadzi sei Isaka baba vake; ");
INSERT INTO sna_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","saka akaenda kuna Ishumaeri akandowana Maharati, hanzvadzi yaNebhayoti mwanasikana waIshumaeri mwanakomana waAbhurahama, kuwedzera pavakadzi vaakanga atova navo kare. ");
INSERT INTO sna_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakobho akabva paBheerishebha akaenda kuHarani. ");
INSERT INTO sna_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Akati asvika pane imwe nzvimbo, akavata ipapo usiku nokuti zuva rakanga ravira. Akatora rimwe ramatombo ipapo, akaritsamira akavata. ");
INSERT INTO sna_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akarota achiona manera amire panyika, uye musoro wawo uchisvika kudenga, uye vatumwa vaMwari vaikwidza nokudzika nawo. ");
INSERT INTO sna_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Pamusoro pawo ipapo pakanga pamire Jehovha, uye akati, “Ndini Jehovha, Mwari wababa vako Abhurahama naMwari waIsaka. Ndichakupa iwe nezvizvarwa zvako nyika yauvete pairi. ");
INSERT INTO sna_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Zvizvarwa zvako zvichaita seguruva renyika, uye muchapararira kubva kumavirira kusvikira kumabvazuva, kumusoro nezasi. Marudzi ose apanyika acharopafadzwa kubudikidza navana vako. ");
INSERT INTO sna_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ndinewe uye ndichakuchengeta kwose kwaunoenda, uye ndichakudzosazve munyika ino. Handingakusiyi kusvikira ndaita zvandakavimbisa.” ");
INSERT INTO sna_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakobho akati apepuka pahope, akafunga akati, “Zvirokwazvo Jehovha ari panzvimbo ino, uye ndanga ndisingazvizivi.” ");
INSERT INTO sna_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Akanga achitya uye akati, “Nzvimbo ino inotyisa sei! Iyi imba chaiyo yaMwari; iri ndiro suo rokudenga.” ");
INSERT INTO sna_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mangwanani akatevera Jakobho akatora dombo raakanga akatsamira akarimisa sembiru akadururira mafuta pamusoro paro. ");
INSERT INTO sna_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Akatumidza nzvimbo iyi zita rokuti Bheteri, kunyange zvazvo guta iro raimbonzi Ruzi. ");
INSERT INTO sna_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ipapo Jakobho akaita mhiko, akati, “Kana Mwari akava neni uye akandichengeta parwendo urwu rwandiri kufamba uye akandipa zvokudya kuti ndidye nenguo dzokupfeka ");
INSERT INTO sna_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","uye ndikadzoka zvakanaka kuimba yababa vangu, ipapo Jehovha achava Mwari wangu, ");
INSERT INTO sna_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","uye dombo iri randamisa sembiru richava imba yaMwari, uye pane zvose zvamuchandipa ndichakupai chegumi.” ");
INSERT INTO sna_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ipapo Jakobho akapfuurira mberi norwendo rwake akasvika kunyika yavanhu vokumabvazuva. ");
INSERT INTO sna_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ikoko akaona tsime musango, namapoka matatu amakwai avete pedyo naro nokuti makwai ainwiswa patsime iroro. Ibwe rakanga riri pamuromo wetsime rakanga riri guru. ");
INSERT INTO sna_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mapoka ose aiti aungana ipapo, vafudzi vaikungurutsa ibwe kubva pamuromo wetsime vachinwisa makwai avo. Ipapo vaizodzorera ibwe panzvimbo yaro, ipo pamuromo wetsime. ");
INSERT INTO sna_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakobho akabvunza vafudzi akati, “Mabvepiko, hama dzangu?” Ivo vakapindura vakati, “Tabva kuHarani.” ");
INSERT INTO sna_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iye akati kwavari, “Munoziva Rabhani, muzukuru waNahori here?” Vakapindura vakati, “Hongu, tinomuziva.” ");
INSERT INTO sna_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ipapo Jakobho akavabvunza akati, “Anofara here?” Ivo vakati, “Hongu, anofara uye hoyo mwanasikana wake Rakeri ari kuuya namakwai.” ");
INSERT INTO sna_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iye akati, “Tarirai, achiri masikati haisati yava nguva yokuti makwai aunganidzwe. Nwisai makwai mugoadzosera kumafuro.” ");
INSERT INTO sna_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Vakapindura vakati, “Hatigoni kudaro kusvikira mapoka ose aunganidzwa uye ibwe rakungurutswa kubva pamuromo wetsime. Ipapo ndipo patinozonwisa makwai.” ");
INSERT INTO sna_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Paakanga achiri kutaura navo, Rakeri akasvika namakwai ababa vake, nokuti akanga ari mufudzikadzi. ");
INSERT INTO sna_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakobho akati achiona Rakeri mwanasikana waRabhani, hanzvadzi yamai vake, uye namakwai aRabhani, akaendapo akandokungurutsa ibwe kubva pamuromo wetsime ndokubva anwisa makwai asekuru vake. ");
INSERT INTO sna_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ipapo Jakobho akatsvoda Rakeri akachema zvikuru. ");
INSERT INTO sna_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Uye akaudza Rakeri kuti iye akanga ari hama yababa vake uye ari mwanakomana waRabheka. Saka Rakeri akamhanya akandoudza baba vake. ");
INSERT INTO sna_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Rabhani akati angoudzwa mashoko pamusoro paJakobho, mwanakomana wehanzvadzi yake, akakurumidza kundosangana naye. Akamumbundikira, akamutsvoda akamuuyisa kumba kwake, uye ipapo Jakobho akamuudza zvose izvi. ");
INSERT INTO sna_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ipapo akati kwaari, “Iwe uri nyama yangu neropa rangu.” Shure kwokugara kwake naye mwedzi wose, ");
INSERT INTO sna_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Rabhani akati kwaari, “Ungandishandira usingapuwi mubayiro nokuda kwokuti uri hama yangu here? Ndiudze kuti mubayiro wako unofanira kuva chii?” ");
INSERT INTO sna_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Zvino Rabhani akanga ana vanasikana vaviri; zita romukuru rainzi Rea uye zita romuduku rainzi Rakeri. ");
INSERT INTO sna_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Rea akanga ana meso akaneta, asi Rakeri akanga ane chimiro chinoyevedza uye akanaka kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakobho aida Rakeri uye akati, “Ndichakushandirai kwamakore manomwe mugondipa Rakeri mwanasikana wenyu muduku.” ");
INSERT INTO sna_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Rabhani akati, “Zviri nani kuti ndimupe kwauri pano kumupa kuno mumwewo murume. Chigara hako pano neni.” ");
INSERT INTO sna_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Saka Jakobho akashanda kwamakore manomwe kuti awane Rakeri, asi akaita samazuva mashoma chete kwaari nokuda kworudo rwake kwaari. ");
INSERT INTO sna_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ipapo Jakobho akati kuna Rabhani, “Ndipei mukadzi wangu. Nguva yangu yakwana uye ndinoda kuvata naye.” ");
INSERT INTO sna_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Saka Rabhani akaunganidza pamwe chete vanhu vose venzvimbo iyo akaita mutambo. ");
INSERT INTO sna_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Asi akati ava madekwana, akatora mwanasikana wake Rea akamupa kuna Jakobho, Jakobho akavata naye. ");
INSERT INTO sna_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Uye Rabhani akapa Ziripa murandakadzi wake kumwanasikana wake kuti ave mushandi wake. ");
INSERT INTO sna_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kwakati kwaedza mangwanani wanei ndiRea! Saka Jakobho akati kuna Rabhani, “Chiiko ichi chamaita kwandiri? Ndakashandira Rakeri, hazvisirizvo here? Seiko mandinyengera?” ");
INSERT INTO sna_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Rabhani akapindura akati, “Haisi tsika yedu kuno kuti mwanasikana muduku atange kuwanikwa mukuru achigere kuwanikwa. ");
INSERT INTO sna_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pedzisa vhiki youmwenga yomwanasikana uyu; ipapo tichazokupawo muduku shure kwokushandira mamwe makore manomwe.” ");
INSERT INTO sna_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Uye Jakobho akaita saizvozvo. Akapedza vhiki naRea, uye ipapo Rabhani akamupa mwanasikana wake Rakeri kuti ave mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Rabhani akapa murandakadzi wake Bhiriha kuna Rakeri kuti ave mushandi wake. ");
INSERT INTO sna_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakobho akavatawo naRakeri uye aida Rakeri kupfuura Rea. Uye akashandira Rabhani kwamamwe makore manomwe. ");
INSERT INTO sna_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jehovha akati aona kuti Rea akanga asingadikanwi, akazarura chizvaro chake, asi Rakeri akanga asingabereki. ");
INSERT INTO sna_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Rea akava nemimba akabereka mwanakomana. Akamutumidza zita rokuti Rubheni, nokuti akati, “Jehovha akaona kutambudzika kwangu. Zvirokwazvo murume wangu achandida zvino.” ");
INSERT INTO sna_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Akabatazve pamwe pamuviri, uye akati abereka mwanakomana, akati, “Nokuti Jehovha akanzwa kuti handidikanwi, akandipa uyuzve.” Saka akamutumidza kuti Simeoni. ");
INSERT INTO sna_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Akabatazve pamwe pamuviri uye akati abereka mwanakomana, akati, “Zvino pakupedzisira murume wangu achabatanidzwa neni, nokuti, ndamuberekera vanakomana vatatu.” Saka akamutumidza zita rokuti Revhi. ");
INSERT INTO sna_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Akabatazve pamwe pamuviri uye paakabereka mwanakomana, akati, “Nguva ino ndicharumbidza Jehovha.” Saka akamutumidza zita rokuti Judha. Ipapo akaguma kubereka vana. ");
INSERT INTO sna_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakeri akati aona kuti akanga asingaberekeri Jakobho vana, akaitira mukoma wake godo. Saka akati kuna Jakobho, “Ndipe vana, kana zvikasadaro ndichafa!” ");
INSERT INTO sna_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakobho akamutsamwira akati, “Ko, ini ndiri panzvimbo yaMwari here akakuita kuti urege kuva nevana?” ");
INSERT INTO sna_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ipapo akati, “Hoyu Bhiriha, murandakadzi wangu. Vata naye kuitira kuti andiberekere vana uye kuti kubudikidza naye neni ndigovawo nemhuri.” ");
INSERT INTO sna_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Saka akamupa murandakadzi wake Bhiriha kuti ave mukadzi wake. Jakobho akavata naye, ");
INSERT INTO sna_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","akava nemimba akamuberekera mwanakomana. ");
INSERT INTO sna_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ipapo Rakeri akati, “Mwari andiruramisira; iye akanzwa mukumbiro wangu uye akandipa mwanakomana.” Nokuda kwaizvozvo akamutumidza zita rokuti Dhani. ");
INSERT INTO sna_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bhiriha murandakadzi waRakeri akavazve nemimba uye akaberekera Jakobho mwanakomana wechipiri. ");
INSERT INTO sna_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ipapo Rakeri akati, “Ndakava nokurwa kukuru nomukoma wangu, ndikakunda.” Saka akamutumidza zita rokuti Nafutari. ");
INSERT INTO sna_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Rea akati aona kuti aguma kubereka vana, akatora murandakadzi wake Ziripa akamupa kuna Jakobho somukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ziripa murandakadzi waRea akaberekera Jakobho mwanakomana. ");
INSERT INTO sna_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ipapo Rea akati, “Makorokoto! Zvaita zvakanaka.” Saka akamutumidza zita rokuti Gadhi. ");
INSERT INTO sna_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ziripa murandakadzi waRea akaberekera Jakobho mwanakomana wechipiri. ");
INSERT INTO sna_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ipapo Rea akati, “Mufaroi wandinawo! Vakadzi vachati mufaro kwandiri.” Saka akamutumidza zita rokuti Asheri. ");
INSERT INTO sna_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Panguva yokuchekwa kwegorosi, Rubheni akabuda akaenda musango akandowana mamandiraki, akauya nawo kuna mai vake Rea, Rakeri akati kuna Rea, “Ndapota dondipawo mamwe mamandiraki omwanakomana wako.” ");
INSERT INTO sna_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Asi iye akati kwaari, “Ko, hazvina kuringana here kuti wakanditorera murume wangu? Uchada kutorazve mamandiraki omwanakomana wangu here?” Rakeri akati, “Zvakanaka, ngaavate newe usiku huno nokuda kwamamandiraki omwanakomana wako.” ");
INSERT INTO sna_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Saka Jakobho akati achisvika kubva kusango manheru iwayo, Rea akabuda kundomuchingamidza. Akati kwaari, “Unofanira kuvata neni iwe. Ndakutenga nemamandiraki omwanakomana wangu.” Saka akavata naye usiku ihwohwo. ");
INSERT INTO sna_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mwari akanzwa Rea, uye akava nemimba akaberekera Jakobho mwanakomana wechishanu. ");
INSERT INTO sna_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ipapo Rea akati, “Mwari akandipa mubayiro nokuda kwokupa murandakadzi wangu kumurume wangu.” Saka akamutumidza zita rokuti Isakari. ");
INSERT INTO sna_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Rea akabatazve pamuviri uye akaberekera Jakobho mwanakomana wechitanhatu. ");
INSERT INTO sna_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ipapo Rea akati, “Mwari andipa chipo chinokosha. Nguva ino murume wangu achandikudza, nokuti ndamuberekera vanakomana vatanhatu.” Saka akamutumidza zita rokuti Zebhuruni. ");
INSERT INTO sna_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Shure kwaizvozvo akazobereka mwanasikana uye akamutumidza zita rokuti Dhaina. ");
INSERT INTO sna_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ipapo Mwari akarangarira Rakeri; akamunzwa uye akazarura chizvaro chake. ");
INSERT INTO sna_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Akava nemimba akabereka mwanakomana uye akati, “Mwari abvisa kunyadziswa kwangu.” ");
INSERT INTO sna_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Akamutumidza zita rokuti Josefa, uye akati, “Mwari ngaandiwedzere mumwe mwanakomana.” ");
INSERT INTO sna_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Shure kwokuberekwa kwaJosefa naRakeri, Jakobho akati kuna Rabhani, “Ndiregei ndiende kunyika yokwangu. ");
INSERT INTO sna_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ndipei vakadzi vangu navana, avo vandakakushandirai kuti ndigowana, uye ndigoenda. Munoziva kuti ndakakushandirai sei.” ");
INSERT INTO sna_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Asi Rabhani akati kwaari, “Kana ndawana nyasha pamberi pako, ndapota hangu imbogara. Ndakaona nokuvuka kuti Jehovha akandiropafadza nokuda kwako.” ");
INSERT INTO sna_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Akatizve, “Reva muripo wako, uye ndichakuripa.” ");
INSERT INTO sna_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakobho akati kwaari, “Munoziva kuti ndakakushandirai sei uye kuti zvipfuwo zvenyu ndakazvichengeta sei. ");
INSERT INTO sna_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Zvishoma zvamaiva nazvo kare ndisati ndauya zvawanda, uye Jehovha akakuropafadzai kwose kwandakanga ndiri. Asi zvino, ndichaitirawo mhuri yangu chinhu riniko?” ");
INSERT INTO sna_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Akamubvunza akati, “Ndokupeiko?” Jakobho akati, “Musandipa chinhu. Asi kana mukandiitira chinhu chimwe chete ichi, ndicharamba ndichifudza makwai enyu uye ndichaachengeta: ");
INSERT INTO sna_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Regai ndifambe pakati pezvipfuwo zvenyu zvose nhasi nditsaure pakati pazvo zvose zvina mavara namakwai ana makwapa, gwayana dema rimwe nerimwe nembudzi imwe neimwe ina mavara kana ina makwapa. Ndizvo zvichava mubayiro wangu. ");
INSERT INTO sna_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Uye kutendeka kwangu kuchandipupurira pane ramangwana rangu, pose pamunenge muchizoona mubayiro wangu wamakandipa. Mbudzi ipi zvayo yandinayo inenge isina mavara kana gwapa, kana gwayana ripi zvaro rinenge risina kusviba, zvichanzi zvakabiwa.” ");
INSERT INTO sna_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Rabhani akati, “Ndizvozvo. Ngazvive sezvawataura.” ");
INSERT INTO sna_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Musi wacho iwoyo akatsaura nhongo dzose dzembudzi dzakanga dzine mitsetse kana dzaiva namakwapa, nenhunzvi dzose dzembudzi (dzose dzakanga dzine zvichena padziri) namakwayana matema ose, akazvichengetesa navanakomana vake. ");
INSERT INTO sna_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ipapo akaisa nhambwe yorwendo rwamazuva matatu pakati pake naJakobho, asi Jakobho akaramba achifudza makwai akanga asara aRabhani. ");
INSERT INTO sna_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kunyange zvakadaro, Jakobho akatora matavi akatemwa kubva pamupopura, muarimondi nomuti womupureni uye akasvuura mitsetse michena pairi achibvisa gwati kuti kuchena kwedanda kwomukati kuonekwe. ");
INSERT INTO sna_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ipapo akaisa matanda ose akasvuurwa muzvinwiro zvose, kuitira kuti ave mberi kwezvipfuwo pazvainge zvauya kuzonwa. Zvipfuwo zvapfumvura zvaiti pazvinenge zvauya kuzonwa mvura, ");
INSERT INTO sna_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","zvaisangana pamberi pamatanda. Uye zvaibereka vana vane mitsetse kana vane mavara kana makwapa. ");
INSERT INTO sna_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakobho aitsaura mbudzana kana makwayana oga, asi aiita kuti akasara atarisane nezvipfuwo zvine mitsetse nezvipfuwo zvitema zvakanga zviri zvaRabhani. Nokudaro akaparadzanisa zvipfuwo zvake nezvaRabhani. ");
INSERT INTO sna_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Pose painge nhunzvi dzezvipfuwo zvine simba zvapfumvura, Jakobho aiisa matanda muzvinwiro pamberi pezvipfuwo kuitira kuti zvisangane pedyo namatanda, ");
INSERT INTO sna_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","asi kana zvipfuwo zvisina simba, aisaisa matanda ipapo. Saka zvipfuwo zvisina simba zvakaenda kuna Rabhani uye zvine simba zvikaenda kuna Jakobho. ");
INSERT INTO sna_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nenzira iyi murume uyu akapfuma kwazvo uye akava namapoka akawanda amakwai, navarandakadzi navarandarume, uye ngamera nembongoro. ");
INSERT INTO sna_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakobho akanzwa kuti vanakomana vaRabhani vakanga vachiti, “Jakobho atora zvose zvaiva zvababa vedu uye awana upfumi hwose uhu kubva kune zvaiva zvababa vedu.” ");
INSERT INTO sna_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Uye Jakobho akaona kuti ndangariro dzaRabhani kwaari dzakanga dzisisina kuita sapakutanga. ");
INSERT INTO sna_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ipapo Jehovha akati kuna Jakobho, “Dzokera kunyika yamadzibaba ako nokuhama dzako, uye ndichava newe.” ");
INSERT INTO sna_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Saka Jakobho akatuma shoko kuna Rakeri naRea kuti vauye kusango kwakanga kuna makwai ake. ");
INSERT INTO sna_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Akati kwavari, “Ndinoona kuti ndangariro dzababa venyu kwandiri hadzisisina kuita sezvadzakanga dzakaita kare, asi Mwari wababa vangu aneni. ");
INSERT INTO sna_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Munoziva kuti ndakashandira baba venyu nesimba rangu rose, ");
INSERT INTO sna_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","asi baba venyu vakandinyengera nokushandura-shandura mubayiro wangu kagumi kose. Kunyange zvakadaro hazvo, Mwari haana kuvatendera kuti vandikuvadze. ");
INSERT INTO sna_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pavakati, ‘Zvina mavara zvichava mubayiro wako,’ ipapo zvipfuwo zvose zvakabereka zvina mavara, uye pavakati, ‘Zvine mitsetse zvichava mubayiro wako,’ ipapo zvipfuwo zvose zvakaberekwa zvine mitsetse. ");
INSERT INTO sna_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Saka Mwari akatora zvipfuwo zvababa venyu akazvipa kwandiri. ");
INSERT INTO sna_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Panguva yokubereka kwezvipfuwo, ndakarota dzimwe hope dzokuti ndakatarira ndikaona kuti nhongo dzembudzi dzaisangana nezvipfuwo dzakanga dzine mitsetse, dzina mavara kana kuti dzina makwapa. ");
INSERT INTO sna_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mutumwa waMwari akati kwandiri mukurota, ‘Jakobho,’ ini ndikapindura ndikati, ‘Ndiri pano.’ ");
INSERT INTO sna_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Uye akati, ‘Tarira uone kuti nhongo dzose dzembudzi dzinosangana nezvipfuwo zvose dzine mitsetse, mavara kana makwapa, nokuti ndaona zvose zvakanga zvichiitwa naRabhani kwauri. ");
INSERT INTO sna_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ndini Mwari weBheteri, kuya kwawakazodza mbiru uye kwawakaita mhiko neni. Zvino kurumidza ubve munyika ino udzokere kunyika kwawakazvarirwa.’ ” ");
INSERT INTO sna_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ipapo Rakeri naRea vakati, “Ko, tichine mugove munhaka yababa vedu here? ");
INSERT INTO sna_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ko, havationi savatorwa here? Havana kungotitengesa chete, asi vakashandisa mutengo wedu wose. ");
INSERT INTO sna_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Zvirokwazvo pfuma yose yakatorwa naMwari kubva kuna baba vedu ndeyedu nevana vedu. Saka ita zvose zvaunoudzwa naMwari.” ");
INSERT INTO sna_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ipapo Jakobho akaisa vana vake navakadzi vake pangamera, ");
INSERT INTO sna_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","uye akatinha zvipfuwo zvose pamwe chete nepfuma yose yaakanga aunganidza muPadhani Aramu, kuti aende kuna baba vake Isaka kunyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Rabhani akati aenda kundoveura makwai ake, Rakeri akaba vamwari vomumba mababa vake. ");
INSERT INTO sna_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Pamusoro paizvozvo, Jakobho akanyengera Rabhani muAramu nokusamuudza kuti ava kuenda. ");
INSERT INTO sna_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Saka akatiza nezvose zvaakanga anazvo, akayambuka Rwizi akananga kunyika yezvikomo yeGireadhi. ");
INSERT INTO sna_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Pazuva rechitatu Rabhani akazoudzwa kuti Jakobho akanga atiza. ");
INSERT INTO sna_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Akatora hama dzake, akatevera Jakobho kwamazuva manomwe uye vakamubatira munyika yezvikomo yeGireadhi. ");
INSERT INTO sna_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ipapo Mwari akasvika kuna Rabhani muAramu mukurota usiku uye akati kwaari, “Chenjera kuti urege kutaura chinhu chipi zvacho kuna Jakobho, chakanaka kana chakaipa.” ");
INSERT INTO sna_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jakobho akanga adzika tende rake munyika yezvikomo yeGireadhi paakabatwa naRabhani, uye Rabhani nehama dzake vakadzikawo musasa ipapo. ");
INSERT INTO sna_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ipapo Rabhani akati kuna Jakobho, “Waiteiko? Wandinyengera, uye watakura vanasikana vangu senhapwa muhondo. ");
INSERT INTO sna_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ko, watizirei muchivande uye ukandinyengera? Seiko usina kundiudza, kuitira kuti ndaidai ndakuendesa nomufaro uye kuchiimbwa nziyo nokuridzwa matambureni norudimbwa? ");
INSERT INTO sna_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hauna kunditendera kutsvoda vazukuru vangu kana kuonekana navanasikana vangu. Waita zvoupenzi. ");
INSERT INTO sna_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndine simba rokukukuvadza; asi usiku Mwari wababa vako ati kwandiri, ‘Chenjera kuti urege kutaura chinhu chipi zvacho kuna Jakobho, chakanaka kana chakaipa.’ ");
INSERT INTO sna_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Zvino wakada kuenda nokuda kwokushuva kudzokera kuimba yababa vako. Asi wakabireiko vamwari vangu?” ");
INSERT INTO sna_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakobho akapindura Rabhani akati, “Ndakanga ndichitya, nokuti ndakafunga kuti maizonditorera vanasikana venyu nechisimba. ");
INSERT INTO sna_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Asi kana mukawana munhu upi zvake anenge ana vamwari venyu, iyeye haafaniri kurarama. Pamberi pehama dzedu zvionerei pachenyu kana pane chinhu chenyu pano neni; uye kana zvakadaro, muchitore henyu.” Zvino Jakobho akanga asingazivi kuti Rakeri akanga aba vamwari vacho. ");
INSERT INTO sna_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Saka Rabhani akapinda mutende raJakobho nomutende raRea uye nomumatende maviri avarandakadzi, asi haana kuwana chinhu. Mushure mokubuda kwake mutende raRea, akapinda mutende raRakeri. ");
INSERT INTO sna_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Zvino Rakeri akanga atora vamwari vomuimba yababa vake akavaisa pasi pechigaro chengamera yake uye akanga agere pamusoro pazvo. Rabhani akatsvaka pakati pezvinhu zvose mutende asi haana kuwana chinhu. ");
INSERT INTO sna_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeri akati kuna baba vake, “Regai henyu kutsamwa, ishe wangu, kuti handigoni kusimuka pamberi penyu; ndiri pamutowo wavakadzi.” Saka akatsvaka asi haana kuwana vamwari veimba yake. ");
INSERT INTO sna_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakobho akatsamwa uye akapopotera Rabhani akati, “Mhaka yangu ndeyeiko? Chivi chandakaita ndecheiko zvamandivhima mukadai? ");
INSERT INTO sna_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Zvino zvamatsvaka pakati penhumbi dzangu dzose, chiiko chamawana chokumba kwenyu? Chiisei pano pamberi pehama dzenyu, uye ngavatonge pakati pedu isu vaviri. ");
INSERT INTO sna_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ndakanga ndinemi makore makumi maviri aya. Makwai enyu nembudzi dzenyu hazvina kusvodza, uye handina kudya makondobwe amakwai enyu. ");
INSERT INTO sna_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Handina kuuya kwamuri nezvipfuwo zvakabvamburwa nezvikara zvesango; ndakatakura mutoro wacho pachangu. Uye makareva muripo kubva kwandiri pane zvose zvakabiwa masikati kana usiku. ");
INSERT INTO sna_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aya ndiwo aiva magariro angu: Ndakapiswa nezuva masikati uye nechando usiku, uye hope dzakatiza mumaziso angu. ");
INSERT INTO sna_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Zvakanga zvakaita saizvozvi kwamakore gumi namana nokuda kwavanasikana venyu vaviri ava nemakore matanhatu nokuda kwezvipfuwo zvenyu, uye makashandura mubayiro wangu kagumi. ");
INSERT INTO sna_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Dai Mwari wababa vangu, iye Mwari waAbhurahama uye aityiwa naIsaka, akanga asineni, zvirokwazvo mungadai makandiendesa ndisina chinhu. Asi Mwari akaona kutambudzika kwangu nokubata kwamaoko angu, uye usiku akakutsiurai.” ");
INSERT INTO sna_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Rabhani akapindura Jakobho akati, “Madzimai aya vanasikana vangu, uye vana ava vana vangu, uye zvipfuwo izvi ndezvangu. Zvose zvaunoona ndezvangu. Asi ndichaiteiko nhasi pamusoro pavanasikana vangu ava, kana pamusoro pavana vavakabereka? ");
INSERT INTO sna_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Uya zvino, ngatiite sungano, iwe neni, uye ngaive chapupu pakati pedu.” ");
INSERT INTO sna_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Saka Jakobho akatora ibwe akarimisa sembiru. ");
INSERT INTO sna_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Akati kuhama dzake, “Unganidzai mamwe mabwe.” Saka vakatora mabwe vakaaunganidza vakaita murwi, uye vakadya ipapo pamurwi. ");
INSERT INTO sna_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Rabhani akautumidza zita rokuti Jegari Sahadhuta, uye Jakobho akautumidza kuti Gareedhi. ");
INSERT INTO sna_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Rabhani akati, “Murwi uyu ndiwo uchapupu pakati pangu newe nhasi.” Ndokusaka wakanzi Gareedhi. ");
INSERT INTO sna_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Wakanga uchinziwo Mizipa, nokuti akati, “Jehovha ngaachengete iwe neni patinenge tiri kure nokure. ");
INSERT INTO sna_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kana ukabata vanasikana vangu zvakaipa kana kutora vamwe vakadzi kunze kwevanasikana vangu, kunyange dai mumwe munhu akasava nesu, rangarira kuti Mwari ndiye chapupu pakati pako neni.” ");
INSERT INTO sna_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Rabhani akatiwo kuna Jakobho, “Hoyu murwi uyu, uye heyi mbiru yandamisa iyi pakati pako neni. ");
INSERT INTO sna_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Murwi uyu ndiwo chapupu uye mbiru iyi ndiyo chapupu, kuti handizopfuuri murwi uno ndichiuya kwauri kuti ndizokukuvadza uye kuti iwe hauzopfuuri murwi uno nembiru uchiuya kurutivi rwangu kuti uzondikuvadza. ");
INSERT INTO sna_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mwari waAbhurahama naMwari waNahori, iye Mwari wababa vavo, ngaatonge pakati pedu.” Saka Jakobho akaita mhiko muzita raiye aityiwa nababa vake Isaka. ");
INSERT INTO sna_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Akapa chibayiro imomo munyika yezvikomo uye akakoka hama dzake kuti dzizodya. Mushure mokudya vakavatapo usiku ihwohwo. ");
INSERT INTO sna_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mangwanani akatevera Rabhani akatsvoda vazukuru vake navanasikana vake uye akavaropafadza. Ipapo akabva akadzokera kumusha kwake. ");
INSERT INTO sna_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakobho akaendawo nenzira yake, uye vatumwa vaMwari vakasangana naye. ");
INSERT INTO sna_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jakobho akati achivaona, akati, “Uyu ndiwo musasa waMwari!” Saka akatumidza nzvimbo iyo zita rokuti Mahanaimi. ");
INSERT INTO sna_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakobho akatuma nhume mberi kwake kumukoma wake Esau munyika yeSeiri, iyo nyika yeEdhomu. ");
INSERT INTO sna_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akavarayira akati, “Izvi ndizvo zvamunofanira kutaura kuna tenzi wangu Esau kuti: ‘Zvanzi nomuranda wenyu Jakobho, Ndakanga ndichigara naRabhani uye ndakagarako kusvikira zvino. ");
INSERT INTO sna_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ndine mombe nembongoro, makwai nembudzi, varandarume navarandakadzi. Zvino ndiri kutuma shoko iri kuna she wangu, kuti ndiwane nyasha pamberi penyu.’ ” ");
INSERT INTO sna_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nhume dzakati dzadzoka kuna Jakobho, dzakati kwaari, “Takaenda kumukoma wenyu Esau, uye ari kuuya zvino kuzosangana nemi, uye ana varume mazana mana.” ");
INSERT INTO sna_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ipapo Jakobho akatya zvikuru uye akatambudzika, akaparadzanisa vanhu vaakanga anavo mumapoka maviri, uye makwai nemombe nengamerawo. ");
INSERT INTO sna_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Akafunga akati, “Kana Esau akasvika akaparadza rimwe boka, boka rasara ringapunyuka.” ");
INSERT INTO sna_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ipapo Jakobho akanyengetera akati, “Haiwa Mwari wababa vangu Abhurahama, Mwari wababa vangu Isaka, imi Jehovha makati kwandiri, ‘Dzokera kunyika yokwako nokuhama dzako, uye ndichaita kuti ubudirire,’ ");
INSERT INTO sna_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ini handina kufanirwa nenyasha dzenyu dzose idzi uye nokutendeka kwamakaratidza muranda wenyu. Ndakanga ndichingova netsvimbo yangu bedzi pandakayambuka Jorodhani urwu, asi zvino ndava mapoka maviri. ");
INSERT INTO sna_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ndinokumbira kuti mundiponese kubva muruoko rwomukoma wangu Esau, nokuti ndinotya kuti achasvika akandiuraya, uyewo madzimai aya navana vavo. ");
INSERT INTO sna_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Asi imi makati, ‘Zvirokwazvo ndichaita kuti ubudirire uye kuti zvizvarwa zvako zvive sejecha regungwa, risingagoni kuverengwa.’ ” ");
INSERT INTO sna_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Akapedza usiku hwose ipapo, uye pane zvaakanga anazvo, akatsaurira mukoma wake Esau chipo chaiti: ");
INSERT INTO sna_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","mazana maviri enhunzvi dzemakwai namakumi maviri enhongo dzembudzi, mazana maviri amatunzvi amakwai namakondobwe makumi maviri, ");
INSERT INTO sna_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamera hadzi, makumi matatu navana vadzo, mhou dzemombe makumi mana nehando gumi, mbongoro hadzi makumi maviri uye nehono gumi. ");
INSERT INTO sna_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Akaita kuti zvichengetwe navaranda vake, boka rimwe nerimwe riri roga, uye akati kuvaranda vake, “Tungamirai mberi kwangu, uye musiye nzvimbo pakati pamapoka.” ");
INSERT INTO sna_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Akarayira uya akanga achitungamirira akati, “Mukoma wangu Esau paanosangana nemi uye akakubvunza achiti, ‘Uri waaniko iwe, uye uri kuendepi, uye pfuma yose iri mberi kwako ndeyani?’ ");
INSERT INTO sna_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ipapo iwe unofanira kupindura uchiti, ‘Ndezvomuranda wenyu Jakobho. Izvi zvipo zvatumirwa kuna she wangu Esau, uye iye ari kutevera mumashure medu.’ ” ");
INSERT INTO sna_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Akarayirawo wechipiri, wechitatu uye navamwe vose vaitevera mapoka achiti, “Munofanira kutaura chinhu chimwe chete kuna Esau pamunosangana naye. ");
INSERT INTO sna_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Uye murangarire kuti, ‘Muranda wenyu Jakobho ari kuuya mumashure medu.’ ” Nokuti akafunga akati, “Ndamunyaradza nezvipo zvandiri kumutumira mberi; pandinozomuona, zvichida achandigamuchira.” ");
INSERT INTO sna_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Saka chipo chaJakobho chakatungamira mberi kwake, asi iye pachake akavata mumusasa. Nokuti akafunga akati, “Ndichamunyaradza nezvipo zvandiri kutumira mberi; pandinozomuona, zvichida achandigamuchira.” ");
INSERT INTO sna_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Usiku ihwohwo Jakobho akamuka akatora vakadzi vake vaviri, varandakadzi vake navanakomana vake gumi nomumwe vakayambuka pazambuko reJabhoki. ");
INSERT INTO sna_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Shure kwokuvayambutsa rukova, akayambutsawo zvose zvaakanga anazvo. ");
INSERT INTO sna_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Saka Jakobho akasara ari oga, uye mumwe murume akaita mutsimba naye kusvikira utonga hwatsvuka. ");
INSERT INTO sna_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Murume uye paakaona kuti akanga asingagoni kumukunda, akabata pahudyu yaJakobho zvokuti hudyu yakashodogoka paakanga achiita mutsimba nomunhu uyu. ");
INSERT INTO sna_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ipapo murume uya akati, “Ndirege ndiende, nokuti utonga hwatsvuka.” Asi Jakobho akapindura akati, “Handingatongokuregei muchienda kusvikira mandiropafadza.” ");
INSERT INTO sna_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Murume uya akamubvunza akati, “Zita rako ndianiko?” Jakobho akapindura akati, “Jakobho.” ");
INSERT INTO sna_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ipapo murume uya akati, “Zita rako harichazonzi Jakobho, asi Israeri, nokuti wakarwa naMwari uye nomunhu ukakunda.” ");
INSERT INTO sna_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakobho akati, “Ndapota hangu, ndiudzei zita renyu.” Asi iye akapindura akati, “Seiko uchibvunza zita rangu?” Ipapo akamuropafadza. ");
INSERT INTO sna_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Saka Jakobho akatumidza nzvimbo iyo zita rokuti Penieri, akati, “Nokuti ndaona Mwari chiso nechiso, asi handina kufa.” ");
INSERT INTO sna_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Zuva rakakwira pamusoro pake, paakanga opfuura Penieri, uye akanga achikamhina nokuda kwehudyu yake. ");
INSERT INTO sna_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Naizvozvo kusvikira zuva ranhasi vaIsraeri havadyi runda rakabatanidzwa nehudyu, nokuti hudyu yaJakobho yakanga yakuvadzwa pedyo nerunda. ");
INSERT INTO sna_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakobho akasimudza meso ake ndokuona hoyo Esau, achiuya ana varume mazana mana; saka akaparadzanisa vana pakati paRea naRakeri navarandakadzi vaviri. ");
INSERT INTO sna_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Akaisa varandakadzi navana vavo pamberi, Rea navana vake vachitevera, uye Rakeri naJosefa mumashure. ");
INSERT INTO sna_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iye pachake akatungamira mberi akakotamira pasi kanomwe paakanga oswedera kumukoma wake. ");
INSERT INTO sna_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Asi Esau akamhanya kundosangana naye akamumbundikira mumutsipa namaoko ake uye akamutsvoda. Uye vakachema. ");
INSERT INTO sna_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ipapo Esau akasimudza meso ake akaona madzimai navana. Akamubvunza akati, “Ndivanaaniko ava vaunavo?” Jakobho akapindura akati, “Ndivo vana vakapiwa muranda wenyu naMwari.” ");
INSERT INTO sna_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ipapo varandakadzi navana vavo vakaswedera uye vakakotama pasi. ");
INSERT INTO sna_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Zvimwe chetezvo, Rea navana vake vakasvika uye vakakotama pasi. Mushure mavo vose Josefa naRakeri, naivowo vakakotama pasi. ");
INSERT INTO sna_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau akati, “Ko, unorevei namapoka ose andasangana nawo aya?” Iye akati, “Kuti ndiwane nyasha pamberi penyu, ishe wangu.” ");
INSERT INTO sna_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Asi Esau akati, “Ndatova nezvizhinji, mununʼuna wangu. Chizvichengetera iwe zvaunazvo.” ");
INSERT INTO sna_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakobho akati, “Kwete ndapota! Kana ndawana nyasha kwamuri gamuchirai henyu chipo ichi kubva kwandiri. Nokuti kuona chiso chenyu kunenge kuona chiso chaMwari, sezvo zvino mandigamuchira zvakanaka kudai. ");
INSERT INTO sna_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ndapota, gamuchirai chipo chandakuvigirai, nokuti Mwari akandiitira nyasha uye ndine zvose zvandinoda.” Uye nokuda kwokuti Jakobho akaramba achimugombedzera, Esau akazochigamuchira. ");
INSERT INTO sna_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ipapo Esau akati, “Ngatiendei zvedu; ndichakuperekedzai.” ");
INSERT INTO sna_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Asi Jakobho akati kwaari, “Ishe wangu anoziva kuti vana vachiri vaduku uye kuti ndinofanira kuchengetedza makwai nemombe dziri kunwisa. Kana zvikanyanya kutinhwa nezuva rimwe chete, zvingazofa. ");
INSERT INTO sna_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Saka ishe wangu ngaatungamire hake mberi kwomuranda wake, ini ndichifamba hangu zvishoma zvishoma nenhambwe dzinoenderana nezvipfuwo zviri mberi kwangu, uyewo zvinoenderana navana, kudzamara ndasvika kuna she wangu kuSeiri.” ");
INSERT INTO sna_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau akati, “Zvino chirega ndisiye vamwe vanhu vangu newe.” Jakobho akabvunza akati, “Asi mungaitireiko izvozvo? Regai ndiwane nyasha pamberi pashe wangu bedzi.” ");
INSERT INTO sna_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Saka pazuva iroro, Esau akapinda munzira yake akadzokera kuSeiri. ");
INSERT INTO sna_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Zvisinei hazvo, Jakobho akaenda kuSukoti, kwaakazvivakira imba yake uye akaitirawo zvipfuwo zvake matanga. Ndokusaka nzvimbo iyo ichinzi Sukoti. ");
INSERT INTO sna_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Shure kwokubva kwaJakobho kuPadhani Aramu, akasvika zvakanaka kuguta reShekemu muKenani uye akadzika musasa wake pakatarisana neguta. ");
INSERT INTO sna_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Akatenga nzvimbo yaakadzika matende ake kubva kuvanakomana vaHamori, baba vaShekemu nezana resirivha. ");
INSERT INTO sna_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Akavaka aritari ipapo uye akaitumidza zita rokuti Eri Erohe Israeri. ");
INSERT INTO sna_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Zvino Dhaina, mwanasikana akaberekerwa Jakobho naRea, akabuda kundoshanyira madzimai enyika iyo. ");
INSERT INTO sna_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shekemu mwanakomana waHamori muHivhi, mutongi wenzvimbo iyo, akati amuona, akamumanikidza akavata naye, uye akamunyadza. ");
INSERT INTO sna_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mwoyo wake wakadokwairira Dhaina mwanasikana waJakobho, uye aida musikana uyu, uye akataura naye zvinyoronyoro. ");
INSERT INTO sna_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Saka Shekemu akati kuna Hamori baba vake, “Nditorerei musikana uyu kuti ave mukadzi wangu.” ");
INSERT INTO sna_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakobho paakanzwa kuti mwanasikana wake Dhaina akanga asvibiswa, vanakomana vake vakanga vari kusango nezvipfuwo zvake; saka akanyarara pamusoro pazvo kusvikira vauya kumba. ");
INSERT INTO sna_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ipapo Hamori baba vaShekemu vakabuda kundotaura naJakobho. ");
INSERT INTO sna_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Zvino vanakomana vaJakobho vakauya vachibva kusango, pavakangonzwa zvakanga zvaitika. Vakanga vane shungu uye vakatsamwa, nokuti Shekemu akanga aita chinhu chinonyadza kwazvo kuna Israeri, chokuvata nomwanasikana waJakobho, chinhu chisingafaniri kuitwa. ");
INSERT INTO sna_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Asi Hamori akati kwavari, “Mwanakomana wangu Shekemu anodokwairira mwanasikana wenyu. Ndapota mupei henyu iye kuti ave mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ngatiwaniranei; tipei vanasikana venyu uye imiwo mutore vanasikana vedu. ");
INSERT INTO sna_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Munogona henyu kugara pakati pedu; nyika iri pamberi penyu. Garaimo, tengesaimo, uye muve nepfuma murimo.” ");
INSERT INTO sna_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ipapo Shekemu akati kuna baba vaDhaina nokuhanzvadzi dzake, “Regai ndiwane nyasha pamberi penyu, uye ndichakupai zvose zvamunoda. ");
INSERT INTO sna_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Revai henyu roora romwenga uye ndichakupai chipo chikuru sezvamunoda, uye zvose zvamuchareva kwandiri ndicharipa hangu. Ndipei bedzi musikana ave mukadzi wangu.” ");
INSERT INTO sna_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Nokuda kwokuti hanzvadzi yavo Dhaina yakanga yasvibiswa vanakomana vaJakobho vakapindura nokunyengera pakutaura kwavo kuna Shekemu nababa vake Hamori. ");
INSERT INTO sna_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Vakati kwaari, “Hatingaiti chinhu chakadaro; hatigoni kupa hanzvadzi yedu kumurume asina kudzingiswa. Chingava chinyadziso kwatiri ichocho. ");
INSERT INTO sna_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tingangotenderana kana maita chinhu chimwe chete: kuti imi muve sesu nokudzingisa varume vose. ");
INSERT INTO sna_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ipapo tichakupai vanasikana vedu uye tigozvitorerawo vanasikana venyu. Tichagara pakati penyu tigova vanhu vamwe nemi. ");
INSERT INTO sna_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Asi kana musingadi kudzingiswa, isu tichatora hanzvadzi yedu tigoenda.” ");
INSERT INTO sna_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kutaura kwavo kwainge kwakanaka kuna Hamori nomwanakomana wake Shekemu. ");
INSERT INTO sna_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Jaya iri raikudzwa zvikuru pakati pemhuri yose yababa varo, harina kunonoka kuita zvavakareva, nokuti akanga achifadzwa nomwanasikana waJakobho. ");
INSERT INTO sna_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Saka Hamori nomwanakomana wake Shekemu vakaenda kusuo reguta ravo kuti vandotaura navamwe varume vomuguta ravo. ");
INSERT INTO sna_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Vakati, “Vanhu ava vakanaka kwazvo kwatiri. Ngavagare munyika yedu uye vashambadzire mairi; nyika yakakura kwazvo kwavari. Tinogona kuwana vanasikana vavo uye ivo vanogona kuwana veduwo. ");
INSERT INTO sna_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Asi varume vachatenderana nesu kuti tive savanhu vamwe nechinhu chimwe bedzi, chokuti vanhurume vedu vadzingiswe, sezvavari ivo. ");
INSERT INTO sna_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ko, mombe dzavo, pfuma yavo nezvimwe zvipfuwo zvavo hazvingavi zvedu here? Saka ngatitenderanei navo, vagogara pakati pedu.” ");
INSERT INTO sna_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Varume vose vakabuda kusuo reguta vakabvumirana naHamori nomwanakomana wake Shekemu, uye vanhurume vose vomuguta vakadzingiswa. ");
INSERT INTO sna_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Shure kwamazuva matatu, vose vachiri kurwadziwa, vanakomana vaviri vaJakobho, Simeoni naRevhi, hanzvadzi dzaDhaina, vakatora minondo yavo vakarwisa guta rakanga risina chifungidziro, vakauraya munhurume wose. ");
INSERT INTO sna_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Vakauraya Hamori nomwanakomana wake nomunondo uye vakatora hanzvadzi yavo Dhaina kubva mumba maShekemu vakaenda. ");
INSERT INTO sna_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Vanakomana vaJakobho vakasvika kuzvitunha vakapamba guta iro makanga masvibiswa hanzvadzi yavo. ");
INSERT INTO sna_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Vakatora makwai avo nemombe dzavo, mbongoro dzavo nezvose zvakanga zviri zvavo muguta uye nezvaiva musango. ");
INSERT INTO sna_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Vakatakura pfuma yavo navakadzi vavo vose navana, vakapamba zvinhu zvose zvaiva mudzimba. ");
INSERT INTO sna_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ipapo Jakobho akati kuna Simeoni naRevhi, “Mandiparira dambudziko mukandiita chinhu chinonhuhwa kuvaKenani navaPerizi, vanhu vagere munyika muno. Tiri vashoma isu, uye kana vakandikomberana uye vakarwa neni, ini nemhuri yangu tichaparadzwa.” ");
INSERT INTO sna_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Asi ivo vakapindura vakati, “Zvakanaka here kuti vabate hanzvadzi yedu sechifeve?” ");
INSERT INTO sna_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ipapo Mwari akati kuna Jakobho, “Kwira uende kuBheteri undogara ikoko, uye uvake aritari yaMwari ikoko, iye akazviratidza kwauri pawakanga uchitiza mukoma wako Esau.” ");
INSERT INTO sna_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Saka Jakobho akati kune veimba yake nokuna vose vakanga vanaye, “Bvisai vamwari vavatorwa vamunavo, muzvinatse uye mupfeke dzimwe nguo dzenyu. ");
INSERT INTO sna_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ipapo mugouya tiende kuBheteri, uko kwandichandovaka aritari yaMwari, iye akandipindura pazuva rokutambudzika kwangu uye iye akanga aneni kwose kwandakaenda.” ");
INSERT INTO sna_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Saka vakapa Jakobho vamwari vavatorwa vose vavaiva navo nemhete dzaiva munzeve dzavo, uye Jakobho akazvifushira pasi pomuouki weShekemu. ");
INSERT INTO sna_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ipapo vakasimuka, kutya Mwari kukawira pamusoro pamaguta ose akavapoteredza zvokuti hakuna munhu akavatevera. ");
INSERT INTO sna_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakobho navanhu vose vaaiva navo vakasvika kuRuzi (ndirowo Bheteri) munyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Akavaka aritari ipapo, akatumidza nzvimbo iyo zita rokuti Eri Bheteri, nokuti Mwari akazviratidza kwaari ipapo paakanga achitiza mukoma wake. ");
INSERT INTO sna_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Zvino Dhibhora, mureri waRabheka, akafa akavigwa pasi pomuouki mujinga meBheteri. Saka pakatumidzwa zita rokuti Aroni Bhakuti. ");
INSERT INTO sna_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Shure kwokudzokera kwaJakobho kuPadhani Aramu, Mwari akazviratidza zvakare uye akamuropafadza. ");
INSERT INTO sna_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mwari akati kwaari, “Zita rako ndiJakobho, asi hauchanzi Jakobho, zita rako richanzi Israeri.” Saka akamutumidza zita rokuti Israeri. ");
INSERT INTO sna_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Uye Mwari akati kwaari, “Ndini Mwari Wamasimba Ose; berekanai muwande. Rudzi neboka rendudzi zvichabva kwauri, uye madzimambo achabuda kubva mauri. ");
INSERT INTO sna_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nyika yandakapa Abhurahama naIsaka ndinoipawo kwauri, uye ndichapa nyika ino kuzvizvarwa zvako zvinokutevera.” ");
INSERT INTO sna_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ipapo Mwari akakwira kudenga akabva panzvimbo yaakanga ataura naye. ");
INSERT INTO sna_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakobho akamisa mbiru yebwe panzvimbo iyo Mwari akanga ataura naye, uye akadururira chipiriso chinonwiwa pariri; akadirawo mafuta pariri. ");
INSERT INTO sna_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakobho akatumidza nzvimbo iyo Mwari akanga ataura naye kuti Bheteri. ");
INSERT INTO sna_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ipapo vakapfuurira mberi kubva kuBheteri. Vachiri chinhambwe neEfurati, Rakeri akatanga kurwadziwa uye akatambudzika zvikuru. ");
INSERT INTO sna_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Uye paakanga achitambudzika zvikuru pakupona mwana, mbuya vaimuchengeta vakati kwaari, “Usatya, nokuti uno mumwe mwanakomana.” ");
INSERT INTO sna_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Paakabudisa mweya wake, nokuti akanga ofa, akatumidza mwanakomana wake zita rokuti Bheni-Oni. Asi baba vake vakamutumidza zita rokuti Bhenjamini. ");
INSERT INTO sna_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Saka Rakeri akafa akavigwa munzira yaienda kuEfurati (ndiro Bheterehema). ");
INSERT INTO sna_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Pamusoro peguva rake Jakobho akaisa mbiru, uye kusvikira zuva ranhasi mbiru iyi inoratidza guva raRakeri. ");
INSERT INTO sna_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israeri akapfuurira mberi zvakare akandodzika tende rake seri kweMigidhari Edheri. ");
INSERT INTO sna_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israeri achiri kugara munyika iyo, Rubheni akapinda akandovata nomurongo wababa vake Bhiriha, uye Israeri akanzwa nezvazvo. Jakobho akanga ana vanakomana gumi navaviri: ");
INSERT INTO sna_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Vanakomana vaRea vaiti: Rubheni dangwe raJakobho, Simeoni, Revhi, Judha, Isakari naZebhuruni. ");
INSERT INTO sna_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Vanakomana vaRakeri vaiva: Josefa naBhenjamini. ");
INSERT INTO sna_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Vanakomana vaBhiriha murandakadzi waRakeri vaiva: Dhani naNafutari. ");
INSERT INTO sna_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Vanakomana vaZiripa murandakadzi waRea vaiva: Gadhi naAsheri. Ava ndivo vanakomana vaJakobho, vaakabereka muPadhani Aramu. ");
INSERT INTO sna_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakobho akasvika kumusha kuna baba vake Isaka paMamure, pedyo neKiriati Abha (ndiro Hebhuroni), uko kwakambogara Abhurahama naIsaka. ");
INSERT INTO sna_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka akararama kwamakore zana namakumi masere. ");
INSERT INTO sna_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ipapo akabudisa mweya wake akafa akasanganiswa navanhu vake, akwegura kwazvo. Uye vanakomana vake Esau naJakobho vakamuviga. ");
INSERT INTO sna_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iyi ndiyo nhoroondo yaEsau (ndiye Edhomu). ");
INSERT INTO sna_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau akatora mukadzi wake kubva kuvakadzi veKenani: Adha mwanasikana waEroni muHiti, naOhoribhama mwanasikana waAna, muzukuru waZibheoni muHivhi, ");
INSERT INTO sna_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","uyewo Bhasemati mwanasikana waIshumaeri, hanzvadzi yaNebhayoti. ");
INSERT INTO sna_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adha akaberekera Esau Erifazi, Bhasemati akabereka Reueri, ");
INSERT INTO sna_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","uye Ohoribhama akabereka Jeushi, Jaramu naKora. Ndivo vana vaEsau vaakaberekerwa muKenani. ");
INSERT INTO sna_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau akatora vakadzi vake navanakomana vake uye vanasikana vake navamwe vose veimba yake, pamwe chete nemombe dzake nezvimwe zvipfuwo zvake nepfuma yake yose yaakanga awana muKenani, akaenda kunyika yakanga iri kure nomununʼuna wake Jakobho. ");
INSERT INTO sna_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pfuma yakanga yawanda kwazvo kuti vagare pamwe chete; nyika yavaigara yakanga isisavaringani vose nokuda kwezvipfuwo zvavo. ");
INSERT INTO sna_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Saka Esau (ndiye Edhomu) akandogara kunyika yezvikomo yeSeiri. ");
INSERT INTO sna_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iyi ndiyo nhoroondo yaEsau baba vavaEdhomu munyika yezvikomo yeSeiri. ");
INSERT INTO sna_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aya ndiwo mazita avanakomana vaEsau: Erifazi, mwanakomana womukadzi waEsau, Adha, Reueri, mwanakomana waBhasemati, mukadzi waEsau. ");
INSERT INTO sna_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Vanakomana vaErifazi vaiva: Temani, Omari, Zefo, Gatami naKenazi. ");
INSERT INTO sna_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Mwanakomana waEsau, Erifazi naiyewo akanga ano murongo ainzi Timina, uyo akamuberekera Amareki. Ava ndivo vaiva vazukuru vaAdha, mukadzi waEsau. ");
INSERT INTO sna_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Vanakomana vaReueri vaiva: Nahati, Zera, Shama naMiza. Ava ndivo vaiva vazukuru vaBhasemati mukadzi waEsau. ");
INSERT INTO sna_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Vanakomana vaOhoribhama, mukadzi waEsau, mwanasikana waAna, muzukuru waZibheoni, vaakaberekera Esau, vaiva: Jeushi, Jaramu naKora. ");
INSERT INTO sna_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aya ndiwo aiva madzishe pakati pezvizvarwa zvaEsau: Vanakomana vaErifazi, dangwe raEsau, vaiva: madzishe Temani, Omari, Sefo, Kenazi, ");
INSERT INTO sna_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatami naAmareki. Aya ndiwo madzishe akabva kuna Erifazi muEdhomu; vaiva vazukuru vaAdha. ");
INSERT INTO sna_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Vanakomana vaReueri, mwanakomana waEsau, vaiva madzishe Nahati, Zera, Shama naMiza. Aya ndiwo madzishe akabva kuna Reueri muEdhomu; vakanga vari vazukuru vaBhasemati, mukadzi waEsau. ");
INSERT INTO sna_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Vanakomana vaOhoribhama, mukadzi waEsau, vaiva: madzishe Jeushi, Jaramu naKora. Aya ndiwo madzishe akabva kuna Ohoribhama mukadzi waEsau mwanasikana waAna. ");
INSERT INTO sna_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ava ndivo vaiva vanakomana vaEsau (ndiye Edhomu) uye aya ndiwo madzishe avo. ");
INSERT INTO sna_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ava ndivo vakanga vari vanakomana vaSeiri muHori, vakanga vachigara mudunhu iroro: Rotani, Shobhari, Zibheoni, Ana, ");
INSERT INTO sna_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dhishoni, Ezeri naDhishani. Vanakomana ava vaSeiri muEdhomu vakanga vari madzishe avaHori. ");
INSERT INTO sna_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Vanakomana vaRotani vaiva: Hori naHomami. Timina akanga ari hanzvadzi yaRotani. ");
INSERT INTO sna_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Vanakomana vaShobhari vaiva: Arivhani, Manahati, Ebhari, Shefo naOnami. ");
INSERT INTO sna_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Vanakomana vaZibheoni vaiva: Ayia naAna. Uyu ndiye uya Ana akawana matsime emvura inopisa mugwenga paakanga achifudza mbongoro dzababa vake Zibheoni. ");
INSERT INTO sna_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Vanakomana vaAna vaiva: Dishoni naOhoribhama, mwanakomana waAna. ");
INSERT INTO sna_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Vanakomana vaDhishoni vaiva: Hemidhani, Eshibhani, Itirani naKerani. ");
INSERT INTO sna_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Vanakomana vaEzeri vaiva: Bhirihani, Zaavhani naAkani. ");
INSERT INTO sna_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Vanakomana vaDhishani vaiva: Uzi naArani. ");
INSERT INTO sna_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Aya ndiwo akanga ari madzishe avaHori: Rotani, Shobhari, Zibheoni, Ana, ");
INSERT INTO sna_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dhishoni, Ezeri naDhishani. Aya ndiwo akanga ari madzishe avaHori zvichienderana namarudzi avo, munyika yaSeiri. ");
INSERT INTO sna_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aya ndiwo madzimambo akatonga muEdhomu pasati pambova namambo upi zvake akatonga muIsraeri: ");
INSERT INTO sna_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bhera, mwanakomana waBheori, akava mambo weEdhomu. Guta rake rakatumidzwa zita rokuti Dhinihabha. ");
INSERT INTO sna_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bhera akati afa, Jobhabhi, mwanakomana waZera, aibva kuBhozira akamutevera paumambo. ");
INSERT INTO sna_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobhabhi akati afa, Hushami aibva kunyika yavaTemani akamutevera paumambo. ");
INSERT INTO sna_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushani akati afa, Hadhadhi mwanakomana waBhedhadhi, uya akakunda Midhiani munyika yeMoabhu, akamutevera paumambo. Guta rake rakatumidzwa zita rokuti Avhiti. ");
INSERT INTO sna_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadhadhi akati afa, Samura aibva kuMasireka akamutevera paumambo. ");
INSERT INTO sna_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samura akati afa, Shauri aibva kuRehobhoti paRwizi akamutevera paumambo. ");
INSERT INTO sna_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauri akati afa, Bhaari-Hanani mwanakomana waAkibhori akamutevera paumambo. ");
INSERT INTO sna_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bhaari-Hanani mwanakomana waAkibhori akati afa, Hadhadhi akamutevera paumambo. Guta rake rakatumidzwa zita rokuti Pua, uye zita romukadzi wake rainzi Mehetabheri mwanasikana waMatiredhi, mwanasikana waMe-Zahabhi. ");
INSERT INTO sna_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Aya ndiwo madzishe akabva kuna Esau, namazita avo, maererano nedzimba dzavo namatunhu avo: Timina, Arivha, Jeteti, ");
INSERT INTO sna_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ohoribhama, Era, Pinoni, ");
INSERT INTO sna_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mibhiza, ");
INSERT INTO sna_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidhieri naIrami. Aya ndiwo akanga ari madzishe eEdhomu, maererano namagariro avo munyika yavakatora. Uyu ndiye Esau baba wevaEdhomu. ");
INSERT INTO sna_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakobho akagara munyika yakanga yambogarwa nababa vake, iyo nyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iyi ndiyo nhoroondo yaJakobho. Josefa jaya ramakore gumi namanomwe, akanga achifudza makwai pamwe chete namadzikoma ake, vanakomana vaBhiriha navanakomana vaZiripa, vakadzi vababa vake, uye akauya namashoko akaipa kuna baba vavo pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zvino Israeri akanga achida Josefa kupfuura vamwe vavanakomana vake, nokuti akanga aberekwa panguva youtana hwake; uye akamuitira nguo yakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Madzikoma ake akati aona kuti baba vavo vaimuda kupfuura ani zvake pakati pavo, vakamuvenga uye vakasagona kutaura naye mashoko akanaka. ");
INSERT INTO sna_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Josefa akarota hope, uye paakaudza madzikoma ake izvozvo, vakanyanya kumuvenga. ");
INSERT INTO sna_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Akati kwavari, “Inzwai hope dzandakarota idzi: ");
INSERT INTO sna_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Takanga tichisunga zvisote zvezviyo kumunda onei pakarepo chisote changu chakasimuka chikamira chakati twi, asi zvisote zvenyu zvakaungana zvakapoteredza changu uye zvikakotama kwachiri.” ");
INSERT INTO sna_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Madzikoma ake akati kwaari, “Ko, iwe unoda kutitonga here? Ko, zvirokwazvo uchatitonga here iwe?” Uye vakanyanyisa kumuvenga nokuda kwokurota kwake uye nokuda kwezvaakanga ataura. ");
INSERT INTO sna_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ipapo akarotazve dzimwe hope, uye akadzitaura kumadzikoma ake. Akati, “Inzwai, ndarota dzimwe hope, uye panguva iyi zuva nomwedzi nenyeredzi gumi neimwe zvanga zvichindipfugamira.” ");
INSERT INTO sna_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Paakaudza baba vake pamwe chete namadzikoma ake, baba vake vakamutsiura vakati, “Kurotai kwawakaita uku? Ko, mai vako neni namadzikoma ako tichauya kuzokupfugamira here iwe zvirokwazvo?” ");
INSERT INTO sna_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Madzikoma ake akamuitira godo, asi baba vake vakazvichengeta mumwoyo mavo. ");
INSERT INTO sna_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Zvino madzikoma ake akanga abuda kundofudza makwai ababa vavo pedyo neShekemu, ");
INSERT INTO sna_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","uye Israeri akati kuna Josefa, “Sezvaunoziva, madzikoma ako ari kufudza makwai pedyo neShekemu. Uya, ndikutume kwavari.” Iye akati, “Zvakanaka.” ");
INSERT INTO sna_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Saka akati kwaari, “Enda undoona kana zvinhu zvakanaka kumadzikoma ako nezvipfuwo, ugodzoka kwandiri neshoko.” Ipapo akamutuma achibva napaMupata weHebhuroni. Josefa akati asvika kuShekemu, ");
INSERT INTO sna_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mumwe murume akamuwana achidzungaira musango akamubvunza akati, “Uri kutsvakeiko?” ");
INSERT INTO sna_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Akapindura akati, “Ndiri kutsvaka madzikoma angu. Mungandiudzawo kwavanofudzira makwai avo here?” ");
INSERT INTO sna_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Murume uya akati, “Vabva pano, ndavanzwa vachiti, ‘Ngatiendei kuDhotani.’ ” Saka Josefa akatevera madzikoma ake akandovawana pedyo neDhotani. ");
INSERT INTO sna_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Asi vakamuona achiri kure, asati asvika kwavari, vakarangana kumuuraya. ");
INSERT INTO sna_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Vakataurirana vachiti, “Hoyo muroti uya ouya! ");
INSERT INTO sna_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Uyai zvino timuuraye tigomukanda mune rimwe ramatsime aya tigoti akadyiwa nechikara. Ipapo tichazoona zvinobva pakurota kwake.” ");
INSERT INTO sna_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubheni akati anzwa izvi, akaedza kumununura kubva mumaoko avo. Akati, “Ngatiregei kumuuraya. ");
INSERT INTO sna_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Regai kuteura ropa. Mukandei mutsime iri muno mugwenga, asi regai kutambanudza maoko enyu paari.” Rubheni akareva izvozvi kuti amununure kwavari uye kuti agomudzosera kuna baba vake. ");
INSERT INTO sna_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Saka Josefa akati asvika kumadzikoma ake, vakamubvisa nguo yake, iyo nguo iya yakanga yakaisvonaka, yaiva nemavara-mavara yaakanga akapfeka, ");
INSERT INTO sna_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","uye vakamutora vakamukanda mutsime. Zvino tsime rakanga rapwa risina mvura. ");
INSERT INTO sna_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Pavakagara kuti vadye zvokudya zvavo, vakasimudza meso avo vakaona ngoro dzavaIshumaeri dzichibva kuGireadhi. Ngamera dzavo dzakanga dzakatakura zvinonhuhwira, bharimu nemura, uye vakanga vachienda nazvo kuIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judha akati kuhama dzake, “Tichawaneiko kana tikauraya mununʼuna wedu tikafushira ropa rake? ");
INSERT INTO sna_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Uyai, ngatimutengesei kuvaIshumaeri ava tirege kutambanudza maoko edu paari; pamusoro pezvo iye mununʼuna wedu, nyama yedu neropa redu.” Madzikoma ake akatenderana. ");
INSERT INTO sna_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Saka vashambadziri veMidhiani vakati vasvika, madzikoma ake akabudisa Josefa kubva mutsime vakamutengesa kuvaIshumaeri namashekeri makumi maviri esirivha, ivo vakaenda naye kuIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubheni paakadzokera kutsime uye akawana Josefa asisimo akabvarura nguo dzake. ");
INSERT INTO sna_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Akadzokerazve kuvanunʼuna vake akati, “Mukomana haasisimo! Zvino ndichaendepiko?” ");
INSERT INTO sna_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ipapo vakatora nguo yaJosefa, vakauraya mbudzi ndokunyika nguo iya muropa. ");
INSERT INTO sna_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Vakatora nguo iya yakaisvonaka vakaenda nayo kuna baba vavo vakati, “Takanonga ichi. Cherechedzai muone kana ingava nguo yomwanakomana wenyu here.” ");
INSERT INTO sna_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Akaiziva akati, “Inguo yomwanakomana wangu! Zvimwe zvikara zvesango zvamudya. Zvirokwazvo Josefa akabvamburwa-bvamburwa.” ");
INSERT INTO sna_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ipapo Jakobho akabvarura nguo dzake, akapfeka nguo dzamasaga akachema mwanakomana wake kwamazuva mazhinji. ");
INSERT INTO sna_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Vanakomana vake navanasikana vake vose vakauya kuzomunyaradza, asi akaramba kunyaradzwa. Akati, “Kwete, ndichaburuka kuguva ndichichema mwanakomana wangu.” Saka baba vake vakamuchema. ");
INSERT INTO sna_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Zvichakadaro, vaMidhiani vakatengesa Josefa muIjipiti kuna Potifa mumwe wavabati vaFaro, mukuru wavarindi. ");
INSERT INTO sna_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Panguva iyoyo, Judha akabva kuhama dzake akaburuka akandogara nomurume wokuAdhurama ainzi Hira. ");
INSERT INTO sna_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ikoko Judha akasangana nomwanasikana womumwe murume muKenani ainzi Shua. Akamuwana uye akavata naye; ");
INSERT INTO sna_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","akava nemimba akabereka mwanakomana, zita rake rainzi Eri. ");
INSERT INTO sna_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Akaitazve imwe mimba akabereka mwanakomana uye akamutumidza zita rokuti Onani. ");
INSERT INTO sna_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Akabereka mumwezve mwanakomana akamutumidza zita rokuti Shera. Akamuberekera kuKezibhi. ");
INSERT INTO sna_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judha akatorera dangwe rake Eri mukadzi, uye zita rake ainzi Tamari. ");
INSERT INTO sna_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Asi Eri, dangwe raJudha, akanga akaipa pamberi paJehovha, saka Jehovha akamuuraya. ");
INSERT INTO sna_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ipapo Judha akati kuna Onani, “Vata nomukadzi womukoma wako uye umuitire zvawakafanira kuita kwaari somununʼuna, kuti uberekere mukoma wako vana.” ");
INSERT INTO sna_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Asi Onani akaziva kuti vana havaizova vake; saka pose paaivata nomukadzi womukoma wake, aiteurira mbeu pasi kuti arege kuberekera mukoma wake vana. ");
INSERT INTO sna_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Zvaakaita zvakanga zvakaipa pamberi paJehovha; saka akamuurayawo. ");
INSERT INTO sna_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ipapo Judha akati kuna Tamari mukadzi womwana wake, “Gara hako uri chirikadzi mumba mababa vako kusvikira mwanakomana wangu Shera akura.” Nokuti akafunga kuti, “Naiye angafawo, sezvakaita madzikoma ake.” Saka Tamari akaenda akandogara mumba mababa vake. ");
INSERT INTO sna_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Shure kwenguva refu mukadzi waJudha, mwanasikana waShua, akafa. Judha akati anyaradzwa kubva pakuchema kwake, akakwidza akaenda kuTimina kuvarume vakanga vachiveura makwai, uye shamwari yake Hira muAdhuramu akaenda naye. ");
INSERT INTO sna_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamari akati audzwa kuti, “Vatezvara vako vari kuenda kuTimina kuti vandoveura makwai avo,” ");
INSERT INTO sna_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","akabvisa nguo dzechirikadzi, akazvifukidza nechifukidzo chokumeso kuti azvivanze, uye ipapo akagara pasi pasuo rinopinda kuEnaimi, uri munzira inoenda kuTimina. Nokuti akaona kuti kunyange zvazvo Shera akanga akura, haana kunge apiwa kwaari kuti ave mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judha akati amuona, akafunga kuti chifeve, nokuti akanga akafukidza uso hwake. ");
INSERT INTO sna_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Asingazivi kuti akanga ari muroora wake, akaenda kwaari parutivi rwenzira akati, “Uya zvino, rega ndivate newe.” Iye akati, “Unozondipei kuti ndivate newe?” ");
INSERT INTO sna_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iye akati, “Ndingakupa mbudzana kubva muboka rangu rembudzi.” Iye akati, “Ungandipa chimwe chinhu here kuti chive chitsidzo kusvikira wazonditumira?” ");
INSERT INTO sna_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iye akati, “Ndingakupa chitsidzo cheiko?” Akapindura akati, “Mhete yako yechisimbiso norutambo rwayo, netsvimbo iri muruoko rwako.” Saka akamupa izvozvo uye akavata naye, uye akava nemimba naye. ");
INSERT INTO sna_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Shure kwokubva kwake ipapo akabvisa chifukidzo ndokubva apfekazve nguo dzake dzechirikadzi. ");
INSERT INTO sna_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Zvichakadaro, Judha akatuma shamwari yake muAdhuramu nembudzana iya kuitira kuti chitsidzo chake chidzoswe kwaari kubva kumukadzi uya, asi haana kumuwana. ");
INSERT INTO sna_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Akabvunza varume vaigara ikoko akati, “Chiripiko chifeve chaigara parutivi rwenzira yeEnaimi?” Ivo vakati, “Hapana kumbova nechifeve pano.” ");
INSERT INTO sna_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Saka iye akadzokerazve kuna Judha akandoti, “Handina kumuwana. Pamusoro paizvozvo, vanhu vanogara ikoko vakati, ‘Hakuna kumbova nechifeve kuno.’ ” ");
INSERT INTO sna_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ipapo Judha akati, “Regai achengete zvaanazvo, kuti arege kuzova chiseko. Zvakadaro ndanga ndamutumira mbudzana iyi, asi hauna kugona kumuwana.” ");
INSERT INTO sna_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Shure kwemwedzi inenge mitatu, Judha akaudzwa kuti, “Muroora wako Tamari ane mhosva youfeve, uye nokuda kwaizvozvo ava nemimba.” Judha akati, “Mubudisei apiswe afe!” ");
INSERT INTO sna_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Zvino paakanga achibudiswa, akatumira shoko kuna vatezvara vake akati, “Ndine mimba yomuridzi wezvinhu izvi.” Uye akatizve, “Onai kana mungaziva mwene wemhete yechisimbiso iyi norutambo rwayo, netsvimbo iyi.” ");
INSERT INTO sna_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judha akazviziva uye akati, “Iye akarurama kupfuura ini, sezvo ndanga ndisingadi kumupa kumwanakomana wangu Shera.” Uye haana kuzovata naye zvakare. ");
INSERT INTO sna_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Nguva yake yokupona yakati yasvika, mudumbu make makanga muna vanakomana vaviri. ");
INSERT INTO sna_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Paakanga achipona, mumwe wavo akabudisa ruoko rwake; saka vanyamukuta vakatora rushinda rutsvuku vakamusunga paruoko rwake uye vakati, “Uyu ndiye atanga kubuda.” ");
INSERT INTO sna_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Asi akati adzosera ruoko rwake mukati, mununʼuna wake akabuda, uye vakati, “Saka ndiwo mabudiro awaita nhai!” Uye akatumidzwa zita rokuti Perezi. ");
INSERT INTO sna_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ipapo mukoma wake akanga ano rushinda rutsvuku paruoko rwake, akabuda uye akatumidzwa zita rokuti Zera. ");
INSERT INTO sna_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Zvino Josefa akanga atorwa akaendeswa kuIjipiti. Potifa muIjipita uyo akanga ari mumwe wamachinda aFaro ari mukuru wavarindi, akamutenga kuvaIshumaeri avo vakanga vamuendesa ikoko. ");
INSERT INTO sna_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jehovha akanga ana Josefa uye akaita kuti abudirire, uye aigara mumba momuIjipita, tenzi wake. ");
INSERT INTO sna_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tenzi wake akati achiona kuti Jehovha akanga anaye uye kuti Jehovha akamuita kuti abudirire muzvinhu zvose zvaakanga achiita, ");
INSERT INTO sna_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josefa akawana nyasha pamberi pake uye akava mubatiri wake. Potifa akamuita kuti ave mutariri weimba yake, uye akamuita muchengeti wezvinhu zvose zvakanga zviri zvake. ");
INSERT INTO sna_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kubvira panguva yaakamuisa kuti ave mutariri weimba yake nowezvinhu zvose zvaaiva nazvo, Jehovha akaropafadza imba yomuIjipita nokuda kwaJosefa. Maropafadzo aJehovha akanga ari pamusoro pezvinhu zvose zvakanga zviri zvaPotifa, zvose mumba nomumunda. ");
INSERT INTO sna_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Saka akaisa mumaoko aJosefa zvinhu zvose zvaakanga anazvo; Josefa ari mutariri, iye haana kumbova nehanya nezvimwe zvinhu kunze kwezvokudya zvaaidya bedzi. Zvino Josefa akanga akanyatsoumbwa, akanaka, ");
INSERT INTO sna_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","uye shure kwechinguva mukadzi watenzi wake akatarira Josefa ndokubva ati kwaari, “Uya uzovata neni!” ");
INSERT INTO sna_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Asi akaramba. Akati kwaari, “Ini somutariri, tenzi wangu haana kuva nehanya nezvinhu zvose zviri mumba make; zvose zvaanazvo, akazviisa mumaoko angu. ");
INSERT INTO sna_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hamuna munhu mukuru muno mumba kupfuura ini. Tenzi wangu havana kundinyima kana chinhu chimwe zvacho kunze kwenyu, nokuti imi muri mukadzi wavo. Zvino ndingaitirei chinhu chakaipa kudai uye ndichitadzira Mwari?” ");
INSERT INTO sna_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Uye kunyange zvake aitaura naJosefa zuva nezuva, iye akaramba kuenda panhoo naye, kana kutombova naye. ");
INSERT INTO sna_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Rimwe zuva akapinda mumba kuti andoita mabasa ake, uye kwakanga kusina mumwe wavashandi vomumba aivamo. ");
INSERT INTO sna_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Akamubata nejasi rake uye akati, “Uya kumubhedha uzovata neni!” Asi akasiya jasi rake muruoko rwake akamhanya ndokubuda kunze kwemba. ");
INSERT INTO sna_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Akati aona kuti asiya jasi rake muruoko rwake uye kuti akanga abuda kunze kwemba, ");
INSERT INTO sna_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","akadanidzira kuvashandi, akati, “Tarirai, muHebheru uyu akauyiswa kwatiri kuti azotidadira! Apinda muno kuti azovata neni, asi ndaridza mhere. ");
INSERT INTO sna_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Paanzwa ndoridza mhere kuti ndibatsirwe, abva asiya jasi rake pandiri ndokutizira kunze kwemba.” ");
INSERT INTO sna_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Akachengeta jasi rake parutivi pake kusvikira tenzi wake auya kumba. ");
INSERT INTO sna_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ipapo akamutaurira nyaya iyi akati, “Uya muranda wechiHebheru wamakauyisa kwatiri akauya kwandiri kuti azondidadira. ");
INSERT INTO sna_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Asi pandangoridza mhere kuti ndibatsirwe, akabva asiya jasi rake pandiri ndokutizira kunze kwemba.” ");
INSERT INTO sna_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tenzi wake akati anzwa nyaya yaakaudzwa nomukadzi wake achiti, “Izvi ndizvo zvandakaitirwa nomuranda wako,” akavira nehasha. ");
INSERT INTO sna_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tenzi waJosefa akamutora akamuisa mutorongo, nzvimbo yaichengeterwa vasungwa vamambo; saka akava mutorongo. ");
INSERT INTO sna_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehovha akava naJosefa; akamunzwira tsitsi akamuitira nyasha pamberi pomutariri womutorongo. ");
INSERT INTO sna_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Saka mutariri womutorongo akaita kuti Josefa ave mutariri wavose vaiva vakabatwa mutorongo, uye ndiye aiona nezvose zvaiitwa imomo. ");
INSERT INTO sna_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mutariri wetorongo akanga asina hanya nechinhu chipi zvacho chaiva pasi paJosefa, nokuti Jehovha akanga ana Josefa uye akaita kuti abudirire pane zvose zvaaiita. ");
INSERT INTO sna_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Shure kwaizvozvo, mudiri nomubiki wamambo weIjipiti vakatadzira tenzi wavo, mambo weIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faro akatsamwira varanda vake vaviri, mudiri mukuru nomubiki mukuru, ");
INSERT INTO sna_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","akaita kuti vachengetwe mumba yomukuru wavarindi, mutorongo rimwe chetero makanga makapfigirwa Josefa. ");
INSERT INTO sna_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mukuru wavarindi akavatumira kuna Josefa, akavachengeta uye vakava muchitokisi kwechinguva. ");
INSERT INTO sna_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Vose vari vaviri vakarota hope, mudiri nomubiki wamambo weIjipiti, avo vakanga vakabatwa vari mutorongo, vakarota usiku humwe chetehwo, uye kurota kumwe nokumwe kwakanga kune zvakunoreva. ");
INSERT INTO sna_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Josefa akati auya kwavari mangwanani akatevera, akaona kuti vakanga vakasurukirwa. ");
INSERT INTO sna_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Saka akabvunza varanda vaFaro vakanga vari muchitokisi naye mumba matenzi wake akati, “Seiko nhasi zviso zvenyu zvichipunyaira kudai?” ");
INSERT INTO sna_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Vakapindura vakati, “Tose tiri vaviri tarota hope, asi hakuna munhu angadzidudzira.” Ipapo Josefa akati kwavari, “Ko, kududzira hakuzi kwaMwari here? Ndiudzei kurota kwenyu.” ");
INSERT INTO sna_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Saka mudiri mukuru akataurira Josefa kurota kwake. Akati kwaari, “Mukurota kwangu ndaona muzambiringa pamberi pangu, ");
INSERT INTO sna_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","uye mumuzambiringa manga mune matavi matatu. Wati uchangobuka, waita maruva, uye masumbu awo aibva akava mazambiringa. ");
INSERT INTO sna_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mukombe waFaro wanga uri muruoko rwangu, uye ndatora mazambiringa, ndikaasvinira mumukombe waFaro uye ndikaisa mukombe muruoko rwake.” ");
INSERT INTO sna_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josefa akati kwavari, “Uku ndiko kududzirwa kwadzo. Matavi matatu ndiwo mazuva matatu. ");
INSERT INTO sna_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mukati mamazuva matatu, Faro achasimudza musoro wako agokudzosera pabasa rako, uye uchaisa mukombe waFaro muruoko rwake, sezvawaisimboita pawakanga uri mudiri wake. ");
INSERT INTO sna_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Asi pazvinenge zvakunakira iwe, undirangarire uye undiitirewo ngoni; undireverere kuna Faro kuti ndigobudiswa mutorongo rino. ");
INSERT INTO sna_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nokuti ndakatorwa nokumanikidzwa kubva kunyika yavaHebheru, kunyange pano handina kuita chinhu chakafanira kuti ndipinzwe mugomba rino.” ");
INSERT INTO sna_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mubiki mukuru akati aona kuti Josefa akanga apa dudziro yakanaka, akati kuna Josefa, “Neniwo ndarota hope. Pamusoro pangu panga pane matengu matatu echingwa. ");
INSERT INTO sna_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mudengu rapamusoro manga mune mhando dzose dzezvinhu zvakabikwa zvaFaro, asi shiri dzanga dzichidya kubva mudengu ranga riri pamusoro pangu.” ");
INSERT INTO sna_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josefa akati, “Uku ndiko kududzirwa kwazvo. Matengu matatu ndiwo mazuva matatu. ");
INSERT INTO sna_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mukati mamazuva matatu, Faro achasimudza musoro wako kubva pauri agokuturika pamuti. Uye shiri dzichadya nyama yako.” ");
INSERT INTO sna_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Zvino zuva rechitatu rakanga riri zuva rokuzvarwa kwaFaro, uye akaitira varanda vake vose mutambo. Akasimudza misoro yavaranda vake vaiti mudiri mukuru nomubiki mukuru pamberi pavaranda vake. ");
INSERT INTO sna_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Akadzosera mudiri mukuru pabasa rake, zvokuti akaisazve mukombe muruoko rwaFaro, ");
INSERT INTO sna_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","asi akaturika mubiki mukuru pamuti, sezvazvakanga zvataurwa naJosefa kwavari mukududzira kwake. ");
INSERT INTO sna_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kunyange zvakadaro hazvo, mudiri mukuru haana kurangarira Josefa; akamukanganwa. ");
INSERT INTO sna_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Makore maviri azere akati apfuura, Faro akarota hope: Akanga amire paRwizi Nairi. ");
INSERT INTO sna_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Uye mhou nomwe dzakanga dzakanaka, dzakakora, dzakabuda murwizi dzikafura pakati petsanga. ");
INSERT INTO sna_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Shure kwadzo, dzimwe mhou nomwe, dzakanga dzakashata uye dzakaonda, dzakabuda muna Nairi, dzikamira parutivi rwedziya dzaiva kumahombekombe orwizi. ");
INSERT INTO sna_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Uye mhou dziya dzakanga dzakashata, dzakaonda, dzakadya mhou dziya dzakanga dzakanaka uye dzakakora. Ipapo Faro akapepuka. ");
INSERT INTO sna_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Akavatazve hope uye akarota kechipiri: Hura dzezviyo nomwe dzakanga dzakakora uye dzakanaka, dzakanga dzichikura padzinde rimwe. ");
INSERT INTO sna_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Shure kwadzo, dzimwe hura nomwe dzezviyo dzakabuda, dzakatetepa uye dzakapiswa nemhepo yokumabvazuva. ");
INSERT INTO sna_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Hura dzezviyo dzakatetepa dzakamedza dziya nomwe dzakanga dzakakora, hura dzakanga dzizere. Ipapo akapepuka, onei kwakanga kuri kurota. ");
INSERT INTO sna_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mangwanani pfungwa dzake dzakatambudzika, saka akatuma shoko kunʼanga dzose navachenjeri veIjipiti. Faro akavaudza kurota kwake, asi hakuna munhu akagona kuzvidudzira kwaari. ");
INSERT INTO sna_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ipapo mudiri mukuru akati kuna Faro, “Nhasi ndinorangarira kutadza kwangu. ");
INSERT INTO sna_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pane imwe nguva Faro akatsamwira varanda vake, uye akandipfigira ini nomubiki mukuru mumba momukuru wavarindi. ");
INSERT INTO sna_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Mumwe nomumwe wedu akarota hope usiku humwe chetehwo, uye kurota kumwe nokumwe kwaiva nedudziro yako. ");
INSERT INTO sna_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Zvino jaya rechiHebheru rakanga rinesu, iye muranda womukuru wavarindi, takamuudza kurota kwedu, iye akakududzira kwatiri, achipa murume mumwe nomumwe dudziro yehope dzake. ");
INSERT INTO sna_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Uye zvinhu zvakaitika chaizvo sezvaakadudzira kwatiri: Ini ndakadzoserwa pabasa rangu, uye mumwe murume uye akasungirirwa.” ");
INSERT INTO sna_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Saka Faro akatuma vanhu kuna Josefa, uye akakurumidza kubudiswa mugomba. Akati aveurwa musoro uye apfeka dzimwe nguo, akauya pamberi paFaro. ");
INSERT INTO sna_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faro akati kuna Josefa, “Ndakarota hope, uye hakuna munhu akagona kudzidudzira. Asi ndanzwa zvarehwa nezvako kuti paunonzwa kurota uku, unogona kukududzira.” ");
INSERT INTO sna_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josefa akapindura Faro akati, “Ini handigoni kuzviita, asi Mwari achapa Faro mhinduro yaanoda.” ");
INSERT INTO sna_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ipapo Faro akati kuna Josefa, “Mukurota kwangu, ndakanga ndimire pamahombekombe aNairi, ");
INSERT INTO sna_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ipapo ndikaona mhou nomwe dzichibuda murwizi, dzakakora uye dzakanaka, uye dzikafura pakati petsanga. ");
INSERT INTO sna_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Shure kwadzo, dzimwe mhou nomwe dzakabuda, dzine nzara uye dzakashata uye dzakaonda. Handisati ndamboona mhou dzakaipa kudai munyika yose yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mhou dzakaonda uye dzakashata dzakadya mhou nomwe dziya dzakakora dzakanga dzatanga kuuya. ");
INSERT INTO sna_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Asi kunyange zvazvo dzakadzidya, hakuna munhu aigona kuona kuti dzakanga dzaita izvozvo; dzaingoratidzika kushata sezvadzakanga dzakaita kare. Ipapo ndakapepuka. ");
INSERT INTO sna_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mukurota kwangu, ndakaonawo hura nomwe dzezviyo, dzizere uye dzakanaka, dzichikura padzinde rimwe chete. ");
INSERT INTO sna_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Shure kwadzo dzimwe hura nomwe dzakamera, dzakasvava, dzakaonda uye dzakapiswa nemhepo yokumabvazuva. ");
INSERT INTO sna_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Hura dziya dzakaonda dzakamedza dziya hura nomwe dzakanga dzakanaka. Ndakaudza nʼanga izvi, asi hakuna akagona kunditsanangurira.” ");
INSERT INTO sna_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ipapo Josefa akati kuna Faro, “Kurota kwaFaro ndokumwe uye kwakafanana. Mwari akaratidza kuna Faro zvinhu zvaava kuda kuita. ");
INSERT INTO sna_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mhou nomwe dzakanaka ndiwo makore manomwe, uye hura nomwe dzakanaka dzezviyo ndiwo makore manomwe amaguta; kurota uku kumwe chete uye kwakafanana. ");
INSERT INTO sna_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mhou nomwe dzakaonda uye dzakashata dzakakwira pashure, ndiwo makore manomwe, ndizvowo nehura nomwe dzezviyo dzisingabatsiri dzakapiswa nemhepo yokumabvazuva; ndiwo makore manomwe enzara. ");
INSERT INTO sna_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Zvakangoita sezvandataura kuna Faro ndichiti: Mwari aratidza Faro zvaava kuda kuita. ");
INSERT INTO sna_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Makore manomwe amaguta makuru ari kuuya munyika yose yeIjipiti, ");
INSERT INTO sna_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","asi makore manomwe enzara achaatevera. Ipapo maguta ose omuIjipiti achakanganwikwa, uye nzara ichaparadza nyika. ");
INSERT INTO sna_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Maguta omunyika haachazorangarirwi, nokuti nzara inoatevera ichava huru kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kurota uku kwapiwa kuna Faro nenzira mbiri nokuti nyaya iyi yarongwa zvizere naMwari, uye Mwari achazviita nokukurumidza. ");
INSERT INTO sna_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Zvino Faro ngaatsvake munhu anonzwisisa uye akachenjera amugadze kuti ave mutariri wenyika yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faro ngaagadze vatariri pamusoro penyika kuti vaunganidze chikamu chimwe chete muzvishanu chezvichakohwewa muIjipiti mukati mamakore manomwe aya amaguta. ");
INSERT INTO sna_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Vanofanira kuunganidza zvokudya zvose zvamakore aya akanaka ari kuuya uye vagochengeta zviyo pasi pesimba raFaro, zvinofanira kuchengetwa kuti zvizove zvokudya. ");
INSERT INTO sna_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Zvokudya izvi zvinofanira kuchengeterwa nyika, kuti zvigozoshandiswa panguva yamakore manomwe enzara achauya pamusoro peIjipiti, kuitira kuti nyika irege kuparadzwa nenzara.” ");
INSERT INTO sna_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Urongwa uhu hwakaratidza kuva hwakanaka kuna Faro nokuvaranda vake vose. ");
INSERT INTO sna_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Saka Faro akavabvunza akati, “Tingawana here munhu akaita somurume uyu, munhu ane mweya waMwari maari?” ");
INSERT INTO sna_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ipapo Faro akati kuna Josefa, “Sezvo Mwari aita kuti izvi zvose zvizivikanwe newe, hakuna munhu anoziva uye akachenjera sewe. ");
INSERT INTO sna_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iwe uchava mutariri womuzinda wangu, navanhu vangu vose, uye vanhu vangu vose vanofanira kuzviisa pasi pezvaunovarayira. Ndichava mukuru kwauri pachigaro choushe chete.” ");
INSERT INTO sna_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Saka Faro akati kuna Josefa, “Ndakugadza kuti uve mutariri wenyika yose yeIjipiti.” ");
INSERT INTO sna_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ipapo Faro akabvisa mhete yake pamunwe wake akaiisa pamunwe waJosefa. Akamupfekedza nguo dzakaisvonaka uye akaisa uketani hwegoridhe pamutsipa wake. ");
INSERT INTO sna_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Akamuita kuti akwire pangoro yake ari wechipiri pakutungamirira, uye vanhu vakadanidzira pamberi pake vachiti, “Dziurai nzira!” Nokudaro akamuita mutariri weIjipiti yose. ");
INSERT INTO sna_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ipapo Faro akati kuna Josefa, “Ndini Faro, asi pasina shoko rawataura iwe hakuna munhu achasimudza ruoko rwake kana rutsoka rwake munyika yose yeIjipiti.” ");
INSERT INTO sna_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faro akatumidza Josefa zita rokuti Zafenati-Panea uye akamupa Asenati mwanasikana waPotifera, muprista waOni, kuti ave mukadzi wake. Uye Josefa akafamba munyika yose yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josefa akanga ava namakore makumi matatu okuberekwa paakapinda pabasa raFaro mambo weIjipiti. Uye Josefa akabuda kubva pamberi paFaro akafamba munyika yose yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Panguva yamakore manomwe amaguta, nyika yakabereka zvizhinji kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Josefa akaunganidza zvokudya zvose zvakawanikwa mumakore manomwe aya amaguta muIjipiti akazviunganidza mumaguta. Muguta rimwe nerimwe akaisa zvokudya zvaibva muminda yakapoteredza. ");
INSERT INTO sna_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josefa akaunganidza zviyo zvakawanda kwazvo, sejecha regungwa; zvakanga zvakawanda zvokuti haana kuzokwanisa kuzvinyora nokuti zvakanga zvisisagoni kuyerwa. ");
INSERT INTO sna_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Makore enzara asati asvika, Josefa akanga aberekerwa vanakomana vaviri naAsenati mwanasikana waPotifera, muprista waOni. ");
INSERT INTO sna_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josefa akatumidza dangwe rake zita rokuti Manase akati, “Nokuti Mwari akaita kuti ndikanganwe kutambudzika kwangu kwose navose veimba yababa vangu.” ");
INSERT INTO sna_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwanakomana wake wechipiri akamutumidza zita rokuti Efuremu akati, “Nokuti Mwari akaita kuti ndive nezvibereko munyika yokutambudzika kwangu.” ");
INSERT INTO sna_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Makore manomwe amaguta muIjipiti akasvika pakupera, ");
INSERT INTO sna_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","uye makore manomwe enzara akatanga, sezvazvakanga zvarehwa naJosefa. Kwakava nenzara mune dzimwe nyika dzose, asi munyika yose yeIjipiti maiva nezvokudya. ");
INSERT INTO sna_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ijipiti yose payakatanga kunzwa nzara, vanhu vakatanga kuchemera zvokudya kuna Faro. Ipapo Faro akaudza vaIjipita vose akati, “Endai kuna Josefa muite zvaanokuudzai.” ");
INSERT INTO sna_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzara yakati yapararira munyika yose, Josefa akazarura matura akatengesa zviyo kuvaIjipita, nokuti nzara yakanga iri huru munyika yose yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Uye nyika dzose dzakauya kuzotenga zviyo kuIjipiti kubva kuna Josefa, nokuti nzara yakanga iri huru munyika dzose. ");
INSERT INTO sna_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jakobho akati anzwa kuti kuIjipiti kwaiva nezviyo, akati kuvanakomana vake, “Seiko muchiramba makangotarisana?” ");
INSERT INTO sna_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Akaenderera mberi akati, “Ndanzwa kuti kuIjipiti kune zviyo. Burukai muende ikoko mundotitengera zviyo, kuitira kuti tirarame tirege kufa.” ");
INSERT INTO sna_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ipapo madzikoma aJosefa gumi vakaburuka vakaenda kundotenga zviyo kuIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Asi Jakobho haana kuendesa Bhenjamini, mununʼuna waJosefa, pamwe chete navamwe, nokuti akanga achitya kuti zvakaipa zvaizomuwira. ");
INSERT INTO sna_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Saka vanakomana vaIsraeri vakanga vari pakati pavaya vakaenda kundotenga zviyo, nokuti nzara yakanga iri munyika yeKenaniwo. ");
INSERT INTO sna_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zvino Josefa akanga ari mubati wenyika; ndiye aitengesa zviyo kuvanhu vayo vose. Saka madzikoma aJosefa akati asvika, vakakotamira pasi kwaari nezviso zvavo. ");
INSERT INTO sna_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josefa achingoona madzikoma ake, akavaziva, asi akaita seasingavazivi uye akataura navo nehasha. Akati, “Munobvepi imi?” Ivo vakati, “Tinobva kunyika yeKenani, tauya kuzotenga zvokudya.” ");
INSERT INTO sna_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kunyange zvazvo Josefa akaziva madzikoma ake, ivo havana kumuziva. ");
INSERT INTO sna_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ipapo akarangarira kurota kwake pamusoro pavo akati kwavari, “Muri vasori imi. Mauya kuzoona nyika yedu paisina kudzivirirwa.” ");
INSERT INTO sna_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ivo vakapindura vakati, “Kwete, ishe wedu. Varanda venyu vauya kuzotenga zvokudya. ");
INSERT INTO sna_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Isu tose tiri vanakomana vomunhu mumwe. Varanda venyu vakatendeka, havasi vasori.” ");
INSERT INTO sna_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iye akati kwavari, “Kwete, mauya kuzoona nyika yedu paisina kudzivirirwa.” ");
INSERT INTO sna_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Asi vakapindura vakati, “Varanda venyu vaiva gumi navaviri, vari vanakomana vomunhu mumwe, anogara munyika yeKenani. Gotwe ndiye ari kuna baba vedu iye zvino, uye mumwe haachisipo.” ");
INSERT INTO sna_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josefa akati kwavari, “Ndizvo chaizvo zvandataura kwamuri ndichiti: Muri vasori imi! ");
INSERT INTO sna_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Uye aya ndiwo maedzerwo amuchaitwa: Zvirokwazvo noupenyu hwaFaro, hamuchabvi panzvimbo ino kunze kwokunge mununʼuna wenyu gotwe auya pano. ");
INSERT INTO sna_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumai mumwe wenyu kuti andotora mununʼuna wenyu gotwe; vamwe vose vachachengetwa mutorongo, kuti mashoko enyu aedzwe kuti zvionekwe kana muchitaura chokwadi. Kana zvisina kudaro, ipapo zvirokwazvo naFaro mupenyu, muri vasori!” ");
INSERT INTO sna_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Uye akavaisa vose mutorongo kwamazuva matatu. ");
INSERT INTO sna_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pazuva rechitatu, Josefa akati kwavari, “Itai izvi kuti mugorarama, nokuti ndinotya Mwari. ");
INSERT INTO sna_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kana muri vanhu vakatendeka, regai mumwe wenyu agare muno mutorongo, asi vamwe venyu vaende nezviyo kumhuri dzenyu dziri kuziya. ");
INSERT INTO sna_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Asi munofanira kuuya nomununʼuna wenyu gotwe kwandiri, kuitira kuti mashoko enyu asimbiswe uye kuti murege kufa.” Izvi vakazviita. ");
INSERT INTO sna_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Vakataurirana vachiti, “Zvirokwazvo tava kurangwa nokuda kwomununʼuna wedu. Takaona kutambudzika kwaakaita paakatikumbira kuti tirege kumuuraya, asi isu hatina kumuteerera; ndokusaka nhamo iyi yauya pamusoro pedu.” ");
INSERT INTO sna_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubheni akapindura akati, “Ko, handina kukuudzai here kuti murege kutadzira mukomana? Asi hamuna kuda kunditeerera! Zvino tinofanira kuzvidavirira nokuda kweropa rake.” ");
INSERT INTO sna_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Havana kuziva kuti Josefa aigona kuvanzwisisa, sezvo akanga achishandisa mududziri. ");
INSERT INTO sna_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Akabva pavari akatanga kuchema, asi pakarepo akadzoka kwavari akatauriranazve navo. Akaita kuti Simeoni atorwe kubva pakati pavo uye kuti asungwe vakatarisa. ");
INSERT INTO sna_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josefa akarayira kuti masaga avo azadzwe nezviyo, vaise mari yomumwe nomumwe musaga rake, uye kuti vapiwe mbuva yorwendo rwavo. Shure kwokuitirwa kwavo izvi, ");
INSERT INTO sna_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","vakatakudza mbongoro dzavo zviyo vakaenda. ");
INSERT INTO sna_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Panzvimbo yavakavata usiku, mumwe wavo akazarura saga rake kuti atorere mbongoro yake zvokudya, akaona mari yake pamuromo wesaga rake. ");
INSERT INTO sna_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Akati kuna vamwe vake, “Mari yangu yadzoserwa. Heyi iri musaga rangu.” Mwoyo yavo yakati rukutu vakatarisana vachidedera, uye vakati, “Chiiko ichi chataitirwa naMwari?” ");
INSERT INTO sna_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pavakasvika kuna baba vavo Jakobho munyika yeKenani, vakamuudza zvakanga zvaitika kwavari. Vakati, ");
INSERT INTO sna_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Murume anova ndiye ishe pamusoro penyika iyo akataura nesu nehasha uye akatiita sokunge taiva vasori munyika. ");
INSERT INTO sna_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Asi takati kwaari, ‘Tiri vanhu vakatendeka; hatisi vasori. ");
INSERT INTO sna_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Takanga tiri vanakomana gumi navaviri vababa vamwe chete. Mumwe haachipo, uye gotwe ndiye ana baba vedu zvino kuKenani.’ ” ");
INSERT INTO sna_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ipapo murume anova ndiye ishe panyika iyo akati kwatiri, ‘Hechi chinhu chichandizivisa kana muri vanhu vakatendeka: Siyai mumwe wenyu neni pano, mugotakura zvokudya zvemhuri dzenyu dziri kuziya muende. ");
INSERT INTO sna_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Asi muuye nomununʼuna wenyu gotwe kwandiri kuitira kuti ndigoziva kuti hamusi vasori, asi kuti muri vanhu vakatendeka. Ipapo ndichadzosera mumwe wenyu kwamuri, uye mungazotenga henyu muno munyika.’ ” ");
INSERT INTO sna_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Pavakanga vachidurura masaga avo, wanei musaga romumwe nomumwe wavo makanga mune homwe yake yesirivha! Ivo nababa vavo pavakaona mari muhomwe, vakatya. ");
INSERT INTO sna_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Baba vavo Jakobho vakati, “Mandipedzera vana vangu. Josefa haasisipo naSimeoni haasisipo, uye zvino munoda kutora Bhenjamini. Zvinhu zvose zviri kundimukira!” ");
INSERT INTO sna_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ipapo Rubheni akati kuna baba vake, “Mungauraya henyu vanakomana vangu vaviri ava kana ndisina kudzoka naye kwamuri. Muisei mumaoko angu, ndichadzoka naye.” ");
INSERT INTO sna_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Asi Jakobho akati, “Mwanakomana wangu haangaburuki nemi kuti aende ikoko; mukoma wake akafa uye ndiye chete asara. Kana zvakaipa zvikamuwira parwendo rwamuri kufamba, muchaburutsira musoro wangu wachena muguva mukusuwa.” ");
INSERT INTO sna_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Zvino nzara yakanga ichakanyanya munyika. ");
INSERT INTO sna_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Saka vakati vadya zviyo zvose zvavakanga vabva nazvo kuIjipiti, baba vavo vakati kwavari, “Dzokerai mundotitengera zvimwe zvokudya.” ");
INSERT INTO sna_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Asi Judha akati kwavari, “Murume uya akatiyambira kwazvo akati, ‘Hamungazooni chiso changuzve kunze kwokunge mununʼuna wenyu auya nemi.’ ");
INSERT INTO sna_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kana mukaendesa mununʼuna wedu nesu, tichaenda kundokutengerai zvokudya. ");
INSERT INTO sna_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Asi kana mukasamuendesa, hatingatongoendi, nokuti murume uya akati, ‘Hamungazooni chiso changuzve kunze kwokunge mununʼuna wenyu auya nemi.’ ” ");
INSERT INTO sna_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israeri akabvunza akati, “Seiko makauyisa dambudziko iri pamusoro pangu zvamakaudza murume uyu kuti muno mumwe mununʼuna?” ");
INSERT INTO sna_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ivo vakapindura vakati, “Murume uyu akatibvunzisisa kwazvo nezvedu uye nezvemhuri yedu. Akati, ‘Baba venyu vachiri vapenyu here? Muno mumwe mununʼuna here?’ Takangopindura mubvunzo wake zvakanaka. Ko, taiziva sei kuti aizoti, ‘Uyai nomununʼuna wenyu kuno?’ ” ");
INSERT INTO sna_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ipapo Judha akati kuna Israeri baba vake, “Tumai mukomana pamwe chete neni tibve taenda izvozvi, kuitira kuti isu nemi navana vedu tirarame uye tirege kufa. ");
INSERT INTO sna_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ini pachangu ndichava rubatso rwokuchengetedzeka kwake; musiyei muruoko rwangu pachangu. Kana ndikasadzoka naye kwamuri ndikamumisa pamberi penyu, ini ndichava nemhosva pamberi penyu muupenyu hwangu hwose. ");
INSERT INTO sna_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Izvozvi dai tisina kunonoka, tingadai takatoenda uye takatodzoka kaviri kwose.” ");
INSERT INTO sna_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ipapo baba vavo Israeri vakati kwavari, “Kana zvakadaro, itai izvi zvino: Isai zvimwe zvibereko zvemichero yenyika ino zvakaisvonaka mumasaga enyu uye mugoenda nazvo sezvipo kumurume uyo, bharimu shoma shoma, nouchi hushoma shoma, zvinonhuhwira nemura, nzungu dzomupistakio namaarimondi. ");
INSERT INTO sna_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutakure mari yakapetwa kaviri, nokuti munofanira kudzorera mari yakanga yadzoserwa pamiromo yamasaga enyu. Zvichida kwaiva kukanganisa. ");
INSERT INTO sna_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Toraiwo mununʼuna wenyu mudzokere izvozvi kumunhu uyo. ");
INSERT INTO sna_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Uye Mwari Wamasimba Ose ngaakunzwirei ngoni pamberi pomunhu uyo kuitira kuti asunungure mumwe mununʼuna wenyu naBhenjamini uye vagodzokazve nemi. Kana ndirini, kana ndafirwa navana vangu, ndafirwa hangu.” ");
INSERT INTO sna_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Saka varume vakatora zvipo nemari yakapetwa kaviri, naBhenjaminiwo. Vakakurumidza kuburuka kuIjipiti vakandozviratidza kuna Josefa. ");
INSERT INTO sna_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Josefa akati achiona Bhenjamini anavo, akati kuvatariri veimba yake, “Torai varume ava muende navo kumba kwangu, muuraye chipfuwo mugogadzira zvokudya; vanofanira kudya neni masikati ano.” ");
INSERT INTO sna_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Varume vakaita sezvavakanga vaudzwa naJosefa vakabva vatora varume vaya vakaenda navo kumba kwaJosefa. ");
INSERT INTO sna_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Zvino varume vaya vakatya pavakatorwa vakaendwa navo kumba kwake. Vakafunga vakati, “Tauyiswa muno nokuda kwemari iya yakadzoserwa mumasaga edu panguva yokutanga. Anoda kutirwisa, agotikunda, agotisunga senhapwa uye agotora mbongoro dzedu.” ");
INSERT INTO sna_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Saka vakaenda kumutariri waJosefa vakandotaura naye pamukova wokupinda mumba make. ");
INSERT INTO sna_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Vakati kwaari, “Tapota ishe, takauya kuno panguva yokutanga kuti tizotenga zvokudya. ");
INSERT INTO sna_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Asi patakamira pane imwe nzvimbo usiku, takazarura masaga edu uye mumwe nomumwe wedu akawana mari yake iri pamuromo wesaga, iyo mari yacho yose zvayo. Saka tadzoka nayo. ");
INSERT INTO sna_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tauyawo neimwe mari yokuti tizotenga zvokudya. Hatizivi akaisa mari yedu mumasaga edu.” ");
INSERT INTO sna_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iye akati, “Zvakanakai. Musatya henyu Mwari wenyu, iye Mwari wababa venyu, ndiye akakupai pfuma mumasaga enyu, ini ndakagamuchira mari yenyu.” Ipapo akabudisa Simeoni akamuuyisa kwavari. ");
INSERT INTO sna_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mutariri uya akauyisa varume vaya mumba maJosefa, akavapa mvura kuti vashambe tsoka dzavo uye akapa mbongoro dzavo zvokudya. ");
INSERT INTO sna_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Vakagadzira zvipo zvokupa Josefa pakusvika kwake masikati, nokuti vakanga vanzwa kuti vachandodya ikoko. ");
INSERT INTO sna_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Josefa akati auya kumba, ivo vakamupa zvipo zvavakanga vapinda nazvo mumba, uye vakakotamira pasi kwaari. ");
INSERT INTO sna_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Akavabvunza mufaro, uye akati, “Vakadii baba venyu, mutana, vamakandiudza nezvavo? Vachiri vapenyu here?” ");
INSERT INTO sna_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Vakapindura vakati, “Muranda wenyu, ivo baba vedu vachiri vapenyu uye vanofara.” Uye vakakotama pasi kuti vamuremekedze. ");
INSERT INTO sna_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Paakatarisa-tarisa akaona mununʼuna wake Bhenjamini, mwanakomana wamai vake chaiye, akabvunza akati, “Uyu ndiye mununʼuna wenyu gotwe, wamakandiudza nezvake here?” Uye akati, “Mwari akuitire nyasha, mwanakomana wangu.” ");
INSERT INTO sna_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Adumbirwa pakuona kwake mununʼuna wake, Josefa akakurumidza kubuda uye akatsvaka nzvimbo paangachema ari. Akapinda muimba yake yomukati akandochema ari imomo. ");
INSERT INTO sna_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Shure kwokushamba uso hwake, akabuda uye akazvidzora, akati “Pakurai zvokudya.” ");
INSERT INTO sna_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Vakamupakurira ari oga, madzikoma vari voga, uye vaIjipita vaidya naye vari voga, nokuti vaIjipita vakanga vasingagoni kudya pamwe chete navaHebheru, nokuti zvinonyangadza kuvaIjipita. ");
INSERT INTO sna_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Varume vakanga vakagariswa pamberi pake zvaienderana namazera avo, kubva kudangwe kusvikira kugotwe; uye vakatarisana zvikavakatyamadza. ");
INSERT INTO sna_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Pavakagoverwa migove kubva patafura yaJosefa, mugove waBhenjamini wakanga wakawanda kashanu kupinda ani zvake pakati pavo. Saka vakadya nokunwa naye vakasununguka. ");
INSERT INTO sna_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Zvino Josefa akarayira mutariri weimba yake achiti, “Zadza masaga avarume ava nezvokudya zvakawanda zvavanokwanisa kutakura, uye uise mari yomumwe nomumwe mumuromo wesaga. ");
INSERT INTO sna_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ipapo ugoisa mukombe wangu, iwo wesirivha, mumuromo wesaga remuduku kuna vose, pamwe chete nemari yezviyo zvake.” Uye akaita sezvaakanga audzwa naJosefa. ");
INSERT INTO sna_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kwakati kuchiedza, varume vaya vakaendeswa panzira yavo pamwe chete nembongoro dzavo. ");
INSERT INTO sna_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Vakanga vasati vava kure neguta Josefa paakati kumutariri wake, “Tevera varume vaya izvozvi, uye paunovabata, uti kwavari, ‘Seiko matsiva chakanaka nechakaipa? ");
INSERT INTO sna_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ko, uyu hauzi mukombe unonwira tenzi wangu uye wavanoshandisa pakuvuka here? Chinhu chamaita ichi chakaipa.’ ” ");
INSERT INTO sna_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Paakavabata, akadzokorora mashoko aya kwavari. ");
INSERT INTO sna_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Asi ivo vakati kwaari, “Seiko ishe wangu achitaura zvinhu zvakadai? Ngazvive kure navaranda venyu kuti vaite chinhu chakadaro! ");
INSERT INTO sna_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Takadzoka kwamuri kubva kunyika yeKenani kunyange nemari yatakawana mumiromo yamasaga edu. Saka taizobireiko sirivha kana goridhe mumba matenzi wenyu? ");
INSERT INTO sna_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kana mumwe upi zvake wavaranda venyu akawanikwa anayo, ngaafe; uye isu tose tichava nhapwa dzashe wangu.” ");
INSERT INTO sna_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iye akati, “Zvakanaka chaizvo, ngazvive sezvamataura. Ani naani anowanikwa anayo achava nhapwa yangu; vamwe mose hamungapiwi mhosva.” ");
INSERT INTO sna_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mumwe nomumwe wavo akakurumidza kuburutsa saga rake pasi uye akarizarura. ");
INSERT INTO sna_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ipapo mutariri akatanga kutsvaka, akatanga kumukuru akapedzisira kumuduku wavose. Uye mukombe wakawanikwa musaga raBhenjamini. ");
INSERT INTO sna_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ipapo, vakabvarura nguo dzavo. Ipapo vakatakudza mbongoro dzavo uye vakadzokera kuguta. ");
INSERT INTO sna_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josefa akanga achiri mumba pakapinda Judha navanunʼuna vake, uye vakazviwisira pasi pamberi pake. ");
INSERT INTO sna_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josefa akati kwavari, “Chiiko ichi chamaita? Hamuzivi kuti munhu akaita seni anogona kuziva zvinhu nokuvuka here?” ");
INSERT INTO sna_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judha akapindura akati, “Chiiko chatingataura kuna ishe wangu? Tingataureiko? Tingazvipembedza seiko? Mwari afukura mhosva yavaranda venyu. Zvino tava nhapwa dzashe wedu, isu pachedu naiye awanikwa ano mukombe.” ");
INSERT INTO sna_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Asi Josefa akati, “Ngazvive kure neni kuti ndiite chinhu chakadai! Munhu awanikwa ano mukombe wangu chete ndiye achava nhapwa yangu. Imi mose, dzokerai kuna baba venyu norugare.” ");
INSERT INTO sna_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ipapo Judha akaenda kwaari akati, “Ndapota, ishe wangu, regai muranda wenyu ataure shoko rimwe kuna she wangu. Regai kutsamwira muranda wenyu, kunyange hazvo makaenzana naFaro pachake. ");
INSERT INTO sna_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ishe wangu akabvunza varanda vake akati, ‘Muna baba kana mununʼuna here?’ ");
INSERT INTO sna_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Uye isu takapindura tikati, ‘Tina baba vava vatana, uye pano mukomana muduku akaberekwa pautana hwavo. Mukoma wake akafa, uye ndiye oga asara mwanakomana wamai vake, uye baba vake vanomuda.’ ");
INSERT INTO sna_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ipapo imi makati kuvaranda venyu, ‘Uyai naye kuno kwandiri kuti ndimuone, ini pachangu.’ ");
INSERT INTO sna_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Uye isu takati kuna she wangu, ‘Mukomana haangasiye baba vake; kana akavasiya, baba vake vangafa.’ ");
INSERT INTO sna_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Asi imi makati kuvaranda venyu, ‘Kunze kwokunge mauya nomununʼuna wenyu gotwe, hamungazooni chiso changu.’ ");
INSERT INTO sna_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Patakadzokera kumuranda wenyu, baba vangu, takavaudza zvakanga zvarehwa naishe wangu. ");
INSERT INTO sna_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ipapo baba vedu vakati, ‘Dzokerai mundotengazve zvimwe zvokudya zvishoma.’ ");
INSERT INTO sna_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Asi isu takati, ‘Hatigoni kuenda. Tichaenda bedzi kana mununʼuna wedu anesu. Hatigoni kuona chiso chomurume uyo kunze kwokunge mununʼuna wedu gotwe aenda nesu.’ ");
INSERT INTO sna_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Muranda wenyu baba vangu vakati kwatiri, ‘Imi munoziva kuti mukadzi wangu akandiberekera vanakomana vaviri. ");
INSERT INTO sna_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mumwe wavo akabva kwandiri, uye ndikati, “Zvirokwazvo akabvamburwa-bvamburwa.” Uye handina kuzomuona kubvira ipapo. ");
INSERT INTO sna_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kana mukanditorera iyeyuwo uye kana zvakaipa zvikamuwira, muchaendesa musoro wangu wachena kuguva mukusuwa.’ ");
INSERT INTO sna_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Saka zvino, kana mukomana akasava nesu pandinodzokera kumuranda wenyu, baba vangu, uye kana baba vangu, avo vakasunganidza upenyu hwavo kuupenyu hwomukomana, ");
INSERT INTO sna_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","vakaona kuti mukomana haapo, vachafa. Muranda wenyu achaendesa musoro wachena wababa vedu kuguva mukusuwa. ");
INSERT INTO sna_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Muranda wenyu akapa rubatso rwokuchengetedzeka kwomukomana kuna baba vangu. Ndakati, ‘Kana ndikasadzoka naye kwamuri, ndini ndichava nemhosva pamberi penyu, baba vangu, upenyu hwangu hwose!’ ");
INSERT INTO sna_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Zvino, ndapota, regai henyu muranda wenyu asare kuno senhapwa yashe wangu pachinzvimbo chomukomana, uye murege mukomana adzokere namadzikoma ake. ");
INSERT INTO sna_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ndingadzokera sei kuna baba vangu kana mukomana ndisinaye? Kwete! Musandirega ndichiona njodzi ichiuya pamusoro pababa vangu.” ");
INSERT INTO sna_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ipapo Josefa akanga asisagoni kuzvidzora pamberi pavashandiri vake vose, uye akadanidzira akati, “Munhu wose ngaabve pamberi pangu!” Saka pakanga pasisina mumwe munhu pana Josefa paakazvizivisa kuhama dzake. ");
INSERT INTO sna_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Uye akachema zvikuru kwazvo zvokuti vaIjipita vakamunzwa, uye veimba yaFaro vakanzwa nezvazvo. ");
INSERT INTO sna_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josefa akati kuhama dzake, “Ndini Josefa! Ko, baba vangu vachiri vapenyu here?” Asi hama dzake hadzina kugona kumupindura, nokuti vakanga vachitya pamberi pake. ");
INSERT INTO sna_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ipapo Josefa akati kuhama dzake, “Swederai henyu kwandiri.” Vakati vaita izvozvo, akati, “Ndini Josefa hama yenyu, wamakatengesa kuIjipiti! ");
INSERT INTO sna_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Uye zvino, musatambudzika uye musazvitsamwira nokuda kwokuti makanditengesa kuno, nokuti Mwari akandituma mberi kwenyu kuti ndigoponesa upenyu hwavanhu. ");
INSERT INTO sna_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nokuti pava namakore maviri zvino nzara yava munyika, uye makore mashanu ari kutevera kuchange kusingarimwi kana kukohwewa. ");
INSERT INTO sna_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Asi Mwari akandituma mberi kwenyu kuti ndikuchengeterei vanosara panyika uye kuti ndiponese upenyu hwenyu nokusunungurwa kukuru. ");
INSERT INTO sna_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Saka zvino, hamusimi makandituma kuno, asi Mwari. Akandiita baba kuna Faro, ishe weimba yake yose nomutongi weIjipiti yose. ");
INSERT INTO sna_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Zvino kurumidzai mudzokere kuna baba vangu mundoti kwavari, ‘Zvanzi nomwanakomana wenyu Josefa: Mwari akandiita ishe weIjipiti yose. Burukai muuye kwandiri; musanonoka. ");
INSERT INTO sna_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Muchandogara munyika yeGosheni muve pedyo neni, imi, vana venyu navazukuru venyu, zvipfuwo zvenyu nemombe dzenyu nezvose zvamunazvo. ");
INSERT INTO sna_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ndichakuriritirai ikoko, nokuti mamwe makore mashanu enzara ari kuuya. Kana zvikasadaro imi neveimba yenyu navose vamunavo mungazova varombo.’ ");
INSERT INTO sna_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Muri kuzvionera pachenyu, uye kana mununʼuna wangu uyu Bhenjamini, kuti ndini chaiye ari kutaura nemi. ");
INSERT INTO sna_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Muudze baba vangu pamusoro pokukudzwa kwangu muIjipiti uye napamusoro pezvinhu zvose zvamaona. Uye muuye nababa vangu kuno nokukurumidza.” ");
INSERT INTO sna_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ipapo akawira pamutsipa womununʼuna wake Bhenjamini akachema, uye Bhenjamini akamumbundikirawo achichema. ");
INSERT INTO sna_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Uye akatsvoda madzikoma ake ose uye akachema pamusoro pavo. Shure kwaizvozvo, madzikoma ake akataura naye. ");
INSERT INTO sna_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Shoko rakati rasvika kumuzinda waFaro kuti madzikoma aJosefa akanga auya, Faro namachinda ake ose vakafara. ");
INSERT INTO sna_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faro akati kuna Josefa, “Taurira hama dzako uti, ‘Itai izvi: Takudzai zvipfuwo zvenyu mudzokere kunyika yeKenani, ");
INSERT INTO sna_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","mundouya nababa venyu uye nemhuri kuno kwandiri. Ndichakupai nyika yakaisvonaka yeIjipiti uye mugofara nezvakakora zvenyika.’ ");
INSERT INTO sna_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Iwe unorayirwawo kuti uvaudze kuti, ‘Itai izvi: Torerai vana navakadzi venyu dzimwe ngoro dzinobva muIjipiti uye mundotora baba venyu mugodzoka. ");
INSERT INTO sna_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Musafunganya henyu nezvenhumbi dzenyu, nokuti zvakaisvonaka zvose zveIjipiti zvichava zvenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Saka vanakomana vaIsraeri vakaita saizvozvo. Josefa akavapa ngoro, sezvakanga zvarayirwa naFaro, uye akavapawo mbuva yorwendo rwavo. ");
INSERT INTO sna_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Akapa mumwe nomumwe wavo nguo itsva, asi akapa Bhenjamini mazana matatu amashekeri esirivha nenguo shanu dzokupfeka. ");
INSERT INTO sna_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Uye izvi ndizvo zvaakatumira kuna baba vake: Mbongoro hono gumi dzakanga dzakatakura zvinhu zvakaisvonaka zveIjipiti, nembongoro hadzi gumi dzakanga dzakatakura zviyo nechingwa nezvimwe zvembuva yorwendo. ");
INSERT INTO sna_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ipapo akaendesa hama dzake uye pavakanga voenda akati kwavari, “Musakakavadzana munzira!” ");
INSERT INTO sna_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Saka vakabuda muIjipiti uye vakaenda vakandosvika kuna baba vavo Jakobho kunyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Uye vakati kwavari, “Josefa mupenyu! Uye ndiye mutongi weIjipiti yose.” Jakobho akati rukutu; haana kuvatenda. ");
INSERT INTO sna_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Asi pavakavaudza zvose zvakanga zvarehwa naJosefa kwavari, uye paakaona ngoro dzakanga dzatumirwa kwavari naJosefa kuti dzizovatakura, mweya wababa wavo Jakobho wakamutsiridzwa. ");
INSERT INTO sna_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Uye Israeri akati, “Ndagutsikana! Mwana wangu Josefa achiri mupenyu. Ndichaenda kundomuona ndisati ndafa.” ");
INSERT INTO sna_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Saka Israeri akasimuka nezvose zvakanga zviri zvake, uye akati asvika kuBheerishebha, akapa zvibayiro kuna Mwari wababa vake Isaka. ");
INSERT INTO sna_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Uye Mwari akataura kuna Israeri muchiratidzo usiku akati, “Jakobho! Jakobho!” Iye akati, “Ndiri pano.” ");
INSERT INTO sna_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mwari akati, “Ndini Mwari, iye Mwari wababa vako. Usatya kuenda kuIjipiti, nokuti ndichakuita rudzi rukuru ikoko. ");
INSERT INTO sna_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ndichaburuka kuIjipiti pamwe chete newe, uye zvirokwazvo ndichakudzosazve. Uye ruoko rwaJosefa chairwo ndirwo ruchazarira meso ako.” ");
INSERT INTO sna_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ipapo Jakobho akabva paBheerishebha, uye vanakomana vaIsraeri vakatora baba vavo Jakobho navana vavo navakadzi vavo vakavakwidza mungoro dzakanga dzatumirwa naFaro kuti dzivatakure. ");
INSERT INTO sna_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Vakaendawo nezvipfuwo zvavo nepfuma yose yavakanga vawana muKenani, uye Jakobho navana vake vose vakaenda kuIjipiti. ");
INSERT INTO sna_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Akaenda pamwe chete navanakomana vake, navazukuru vake navanasikana vake navanasikana vavo, vana vake vose. ");
INSERT INTO sna_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aya ndiwo mazita avanakomana vaIsraeri (Jakobho nezvizvarwa zvake) vakaenda kuIjipiti: Rubheni dangwe raJakobho. ");
INSERT INTO sna_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Vanakomana vaRubheni vaiva: Hanoki, Paru, Hezironi naKami. ");
INSERT INTO sna_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Vanakomana vaSimeoni vaiva: Jemueri, Jamini, Ohadhi, Jakini, Zohari naShauri, mwanakomana womukadzi muKenani. ");
INSERT INTO sna_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Vanakomana vaRevhi vaiva: Gerishoni, Kohati naMerari. ");
INSERT INTO sna_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Vanakomana vaJudha vaiva: Eri, Onani, Shera, Perezi naZera (asi Eri naOnani vakanga vafira munyika yeKenani). Vanakomana vaPerezi: Hezironi naHamuri. ");
INSERT INTO sna_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Vanakomana vaIsakari vaiva: Tora, Pua, Jashubhi naShimironi. ");
INSERT INTO sna_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Vanakomana vaZebhuruni vaiva: Seredhi, Eroni naJareri. ");
INSERT INTO sna_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ava ndivo vanakomana vakaberekerwa Jakobho naRea muPadhani Aramu, kunze kwaDhaina mwanasikana wake. Vanakomana navanasikana vake ava vakanga vari makumi matatu navatatu pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Vanakomana vaGadhi vaiva: Zefoni, Hagi, Shuni, Ezibhoni, Eri, Arodhi naAreri. ");
INSERT INTO sna_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Vanakomana vaAsheri vaiva: Imina, Ishivha, Ishivhi naBheria. Hanzvadzi yavo yakanga iri Sera. Vanakomana vaBheria vaiva: Hebheri naMarikieri. ");
INSERT INTO sna_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ava ndivo vana vakaberekerwa Jakobho naZiripa, uyo akanga apiwa naRabhani kuna Rea mwanasikana wake, gumi navatanhatu pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Vanakomana vaRakeri mukadzi waJakobho vaiva: Josefa naBhenjamini. ");
INSERT INTO sna_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","MuIjipiti, Manase naEfuremu vakaberekerwa Josefa naAsenati mwanasikana waPotifera, muprista waOni. ");
INSERT INTO sna_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Vanakomana vaBhenjamini vaiva: Bhera, Bhekeri, Gera, Naamani, Ehi, Roshi, Mupimi, Hupimi naAridhi. ");
INSERT INTO sna_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ava ndivo vakanga vari vanakomana vaRakeri vakanga vaberekerwa Jakobho, gumi navana pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwanakomana waDhani aiva: Hushimi. ");
INSERT INTO sna_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Vanakomana vaNafutari vaiva: Jazieri, Guni, Jezeri naShiremi. ");
INSERT INTO sna_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ava ndivo vanakomana vakaberekerwa Jakobho naBhiriha, uya akapiwa naRabhani kuna Rakeri mwanasikana wake, vanomwe pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Vose vakaenda naJakobho kuIjipiti, vaya vakanga vari zvizvarwa zvake chaizvo, tisingaverengi vakadzi vavanakomana vake, vaiva vanhu makumi matanhatu navatanhatu pakuwanda. ");
INSERT INTO sna_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pamwe chete navanakomana vaviri vakaberekerwa Josefa muIjipiti, vose vemhuri yaJakobho, avo vakaenda kuIjipiti, vakanga vari makumi manomwe pamwe chete. ");
INSERT INTO sna_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Zvino Jakobho akatuma Judha pamberi pake kuna Josefa kuti aratidzwe nzira yokuenda nayo kuGosheni. Vakati vasvika mudunhu reGosheni, ");
INSERT INTO sna_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josefa akaita kuti ngoro yake igadzirirwe uye akaenda kuGosheni kundosangana nababa vake Israeri. Josefa paakangosvika pamberi pavo, akambundikira baba vake uye akachema kwenguva refu. ");
INSERT INTO sna_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israeri akati kuna Josefa, “Zvino ndagadzirira kufa, sezvo ndazvionera pachangu kuti uchiri mupenyu.” ");
INSERT INTO sna_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ipapo Josefa akati kuhama dzake nokune veimba yababa vake, “Ini ndichaenda kuti ndinotaura naFaro uye ndichandoti kwaari, ‘Madzikoma angu neveimba yababa vangu, vakanga vachigara kunyika yeKenani, vauya kwandiri. ");
INSERT INTO sna_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Vanhu ava vafudzi; vanochengeta zvipfuwo, uye vauya namakwai avo nemombe dzavo nezvose zvavanazvo.’ ");
INSERT INTO sna_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Pamunodanwa naFaro uye akakubvunzai achiti, ‘Basa renyu ndereiko?’ ");
INSERT INTO sna_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","imi munofanira kupindura muchiti, ‘Varanda venyu vaiva vachengeti vezvipfuwo kubvira pauduku hwavo, sezvakanga zvichiitawo madzibaba edu.’ Ipapo muchatenderwa kugara munyika yeGosheni, nokuti vafudzi vose vanonyangadza kuvaIjipita.” ");
INSERT INTO sna_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josefa akaenda akandoudza Faro akati, “Baba vangu namadzikoma angu, pamwe chete nezvipfuwo zvavo uye nemombe dzavo nezvavo zvose, vauya vachibva kunyika yeKenani uye vava muGosheni zvino.” ");
INSERT INTO sna_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Akasarudza vashanu pamadzikoma ake akavaendesa pamberi paFaro. ");
INSERT INTO sna_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faro akabvunza madzikoma aJosefa akati, “Basa renyu ndereiko?” Ivo vakapindura Faro vakati, “Varanda venyu vafudzi, sezvakanga zvakangoita madzibaba edu.” ");
INSERT INTO sna_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Vakatizve kwaari, “Tauya kuzogara kuno kwechinguva, nokuti nzara yakanyanya muKenani uye zvipfuwo zvavaranda venyu hazvisisina mafuro. Saka zvino, tapota regai varanda venyu vagare muGosheni.” ");
INSERT INTO sna_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faro akati kuna Josefa, “Baba vako namadzikoma ako vauya kwauri, ");
INSERT INTO sna_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","uye nyika yeIjipiti iri pamberi pako; garisa baba vako namadzikoma ako panzvimbo yakanakisisa munyika ino. Ngavagare muGosheni. Uye kana uchiziva kuti pakati pavo pane vamwe vane zvavanokwanisa kuita, uvaite kuti vave vatariri vezvipfuwo zvangu.” ");
INSERT INTO sna_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ipapo akapinza baba vake Jakobho akavaendesa pamberi paFaro. Shure kwokuropafadzwa kwaFaro naJakobho, ");
INSERT INTO sna_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faro akavabvunza akati, “Mava namakore manganiko?” ");
INSERT INTO sna_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Uye Jakobho akati kuna Faro, “Makore okufamba kwangu panyika izana namakumi matatu. Makore angu akanga ari mashoma uye akaoma, uye haaenzani namakore okufamba kwamadzibaba angu.” ");
INSERT INTO sna_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ipapo Jakobho akaropafadza Faro akabva pamberi pake. ");
INSERT INTO sna_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Saka Josefa akagarisa baba vake namadzikoma ake munyika yeIjipiti uye akavapa nzvimbo mudunhu rakanakisisa munyika, dunhu reRamasesi, sokurayira kwaFaro. ");
INSERT INTO sna_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josefa akapa baba vake namadzikoma ake navose veimba yababa vake zvokudya, zvakaenzana nouwandu hwavana vavo. ");
INSERT INTO sna_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kunyange zvakadaro, kwakanga kusina zvokudya munyika yose nokuti nzara yakanga iri huru, nyika yeIjipiti nenyika yeKenani dzakaziya nokuda kwenzara. ");
INSERT INTO sna_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josefa akaunganidza mari yose yaiwanikwa muIjipiti neKenani yomuripo wezviyo zvavaitenga, uye akaenda nayo kumuzinda waFaro. ");
INSERT INTO sna_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mari yavanhu veIjipiti nevokuKenani yakati yapera, vanhu veIjipiti yose vakauya kuna Josefa vakati, “Tipei zvokudya. Tofireiko pamberi penyu? Mari yedu yapera.” ");
INSERT INTO sna_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ipapo Josefa akati, “Uyai nezvipfuwo zvenyu. Ndichakutengeserai zvokudya ndichitsinhanisa nezvipfuwo zvenyu, sezvo mari yenyu yapera.” ");
INSERT INTO sna_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Saka vakauya nezvipfuwo zvavo kuna Josefa, uye akavapa zvokudya achitsinhanisa namabhiza avo, makwai nembudzi dzavo, mombe nembongoro dzavo. Uye akavabudisa mugore iro nezvokudya zvokutsinhana nezvipfuwo zvavo zvose. ");
INSERT INTO sna_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Gore iroro rakati rapera, vakauya kwaari mugore rakatevera vakati, “Hatingavanziri ishe wedu chokwadi chokuti sezvo mari yedu yakapera uye zvipfuwo zvedu zvava zvenyu, hapasisina chasara chatingapa ishe wedu kunze kwemiviri yedu nenyika yedu. ");
INSERT INTO sna_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tichafireiko pamberi penyu, isu nenyika yeduwo? Titengei isu nenyika yedu titsinhane nezvokudya, uye isu nenyika yedu tichava varanda vaFaro. Tipeiwo mbeu kuitira kuti tirarame uye tirege kufa, uye kuti nyika irege kuparara.” ");
INSERT INTO sna_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Saka Josefa akatengera Faro nyika yose iri muIjipiti. VaIjipita vakatengesa, mumwe nomumwe munda wake, nokuti nzara yakanga iri huru kwazvo. Nyika yakava yaFaro, ");
INSERT INTO sna_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","uye Josefa akaita kuti vanhu vave varanda kubva kuna mamwe magumo eIjipiti kusvikira kuna mamwe. ");
INSERT INTO sna_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kunyange zvakadaro hazvo, haana kutenga nyika yavaprista, nokuti ivo vaigamuchira migove nguva dzose kubva kuna Faro uye vakanga vane zvokudya zvakakwana kubva pamugove wavaipiwa naFaro. Ndokusaka vasina kutengesa nyika yavo. ");
INSERT INTO sna_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josefa akati kuvanhu, “Zvino zvandakutengai nhasi imi nenyika yenyu kuti muve vaFaro, heyi mbeu yokuti mudyare muminda. ");
INSERT INTO sna_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Asi pamunokohwa, mupe chikamu chimwe chete kubva muzvishanu chazvo kuna Faro. Zvimwe zvikamu zvina kubva muzvishanu mungazvichengeta henyu sembeu dzomuminda nezvokudya zvenyu navari mudzimba dzenyu navana venyu.” ");
INSERT INTO sna_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ivo vakati, “Makaponesa upenyu hwedu. Ngatiwanei hedu nyasha pamberi penyu ishe wedu; tichava varanda kuna Faro.” ");
INSERT INTO sna_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Saka Josefa akasimbisa izvi somurayiro pamusoro penyika muIjipiti, murayiro uyu uchiri kushanda nanhasi, kuti chikamu chimwe chete kubva muzvishanu chezvibereko ndechaFaro. Nyika yavaprista bedzi ndiyo yakanga isiri yaFaro. ");
INSERT INTO sna_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Zvino vaIsraeri vakagara muIjipiti mudunhu reGosheni. Vakawana pfuma ikoko, vakabereka vana uye vakawanda zvikuru. ");
INSERT INTO sna_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakobho akagara muIjipiti kwamakore gumi namanomwe, uye akararama kwamakore zana namakumi mana namanomwe. ");
INSERT INTO sna_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nguva yokufa kwaIsraeri yakati yaswedera, akadana mwanakomana wake Josefa uye akati kwaari, “Kana ndawana nyasha pamberi pako, isa ruoko rwako pasi pechidya changu uye ugovimbisa kuti uchandinzwira ngoni uye uchava wakatendeka. Usandiviga muIjipiti, ");
INSERT INTO sna_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","asi pandinozorora namadzibaba angu, mundibudise muIjipiti munondiviga pavakavigwa.” Iye akati, “Ndichaita sezvamareva.” ");
INSERT INTO sna_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ivo vakati, “Ndipikire.” Ipapo Josefa akapika kwaari, uye Israeri akanamata akasendamira pamusoro wetsvimbo yake. ");
INSERT INTO sna_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Shure kwaizvozvo Josefa akaudzwa kuti, “Baba vako vanorwara.” Saka akatora vanakomana vake vaviri Manase naEfuremu pamwe chete naye. ");
INSERT INTO sna_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jakobho akati audzwa kuti, “Mwanakomana wako Josefa auya,” Israeri akazvisimbaradza uye akagara panhoo. ");
INSERT INTO sna_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakobho akati kuna Josefa, “Mwari Wamasimba Ose akazviratidza kwandiri paRuzi munyika yeKenani, uye akandiropafadza ipapo, ");
INSERT INTO sna_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","uye akati kwandiri, ‘Ndichakuita kuti ubereke vana uye ndichaita kuti muwande. Ndichakuita vanhu vazhinji, uye ndichakupa nyika ino kuti ive yako nokuzvizvarwa zvako nokusingaperi.’ ");
INSERT INTO sna_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ipapo zvino, vanakomana vako vaviri vawakaberekerwa muIjipiti ndisati ndasvika kwauri kuno vachanzi ndevangu; Efuremu naManase vachava vangu, saRubheni naSimeoni vari vangu. ");
INSERT INTO sna_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Vana vose vawakaberekerwa mumashure mavo vachava vako; munyika yavo yenhaka vachazivikanwa pasi pamazita amadzikoma avo. ");
INSERT INTO sna_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pandakanga ndichibva kuPadhani, ndakasuwa nokuti Rakeri akafira munyika yeKenani patakanga tichiri munzira, nhambwe pfupi kubva kuEfurati. Saka ndakamuviga ipapo parutivi rwomugwagwa unoenda kuEfurati” (ndiro Bheterehema). ");
INSERT INTO sna_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israeri akati aona vanakomana vaJosefa, akabvunza akati, “Ndivanaani ava?” ");
INSERT INTO sna_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josefa akati kuna baba vake, “Ndivo vanakomana vandakapiwa kuno naMwari.” Ipapo Israeri akati, “Uya navo pano ndivaropafadze.” ");
INSERT INTO sna_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Zvino meso aIsraeri akanga aneta nokuda kwokukwegura, uye akanga asisagoni kuona zvakanaka. Saka Josefa akauya navanakomana vake pedyo naye, baba vake vakavatsvoda uye vakavambundikira. ");
INSERT INTO sna_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israeri akati kuna Josefa, “Handina kumbofunga kuti ndichaona chiso chakozve, uye zvino Mwari anditendera kuti ndione vana vakowo.” ");
INSERT INTO sna_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ipapo Josefa akavabvisa pamabvi aIsraeri akakotama pasi nechiso chake. ");
INSERT INTO sna_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Uye Josefa akavatora vose vari vaviri, Efuremu kurudyi kwake akatarira kuruoko rworuboshwe rwaIsraeri, uye Manase kuruboshwe, akatarira kuruoko rworudyi rwaIsraeri, uye akavaswededza pedyo navo. ");
INSERT INTO sna_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Asi Israeri akatambanudza ruoko rwake rworudyi akaruisa pamusoro waEfuremu, kunyange zvake akanga ari muduku, uye akachinjika maoko ake, akaisa ruoko rwake rworuboshwe pamusoro waManase, kunyange hazvo Manase akanga ari iye dangwe. ");
INSERT INTO sna_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ipapo akaropafadza Josefa akati, “Mwari uyo madzibaba angu, ivo Abhurahama naIsaka, vakafamba pamberi pake, iye Mwari akanga ari mufudzi wangu upenyu hwangu hwose kusvikira nhasi, ");
INSERT INTO sna_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mutumwa akandisunungura kubva pane zvakaipa zvose, ngaaropafadze vakomana ava. Ngavadanwe nezita rangu uye namazita amadzibaba angu Abhurahama naIsaka, uye ngavawande zvikuru pamusoro penyika.” ");
INSERT INTO sna_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Josefa paakaona baba vake vachiisa ruoko rwavo rworudyi pamusoro waEfuremu haana kufadzwa nazvo; saka akabata ruoko rwababa vake kuti arubvise pamusoro waEfuremu aruise pamusoro waManase. ");
INSERT INTO sna_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josefa akati kwavari, “Kwete, baba vangu, uyu ndiye dangwe; isai ruoko rwenyu rworudyi pamusoro wake.” ");
INSERT INTO sna_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Asi baba vakaramba vakati, “Ndinozviziva, mwana wangu, ndinozviziva. Naiyewo achava rudzi, uye naiyewo achava mukuru. Kunyange zvakadaro hazvo muduku achava mukuru kupfuura iye, uye zvizvarwa zvake zvichava boka rendudzi zhinji.” ");
INSERT INTO sna_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Akavaropafadza pazuva iro akati, “Muzita rako, Israeri achataura ropafadzo iyi achiti: ‘Mwari ngaakuite saEfuremu naManase.’ ” Saka akaisa Efuremu pamberi paManase. ");
INSERT INTO sna_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ipapo Israeri akati kuna Josefa, “Ndava pedyo nokufa, asi Mwari achava newe uye achakudzoserai kunyika yamadzibaba enyu. ");
INSERT INTO sna_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Uye kwauri, sezvo uri munhu ari pamusoro pamadzikoma ako, ndinokupa mugove wenyika yandakatorera vaAmori nomunondo wangu uye nouta hwangu.” ");
INSERT INTO sna_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ipapo Jakobho akadana vanakomana vake akati, “Unganai kuti ndikuudzei zvichaitika kwamuri pamazuva anouya. ");
INSERT INTO sna_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Unganai muteerere, imi vanakomana vaJakobho; teererai kuna baba venyu Israeri. ");
INSERT INTO sna_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubheni, iwe uri dangwe rangu, simba rangu, chiratidzo chokutanga chesimba rangu, unokunda mukukudzwa, unokunda musimba. ");
INSERT INTO sna_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Unozunguzika semvura zhinji, hauchazokundizve, nokuti wakakwira panhoo yababa vako, panhoo yangu uye ukaisvibisa. ");
INSERT INTO sna_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni naRevhi mukoma nomununʼuna, minondo yavo zvombo zvokurwa. ");
INSERT INTO sna_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ngandirege kupinda parangano yavo, ngandirege kuva paungano yavo, nokuti vakauraya vanhu mukutsamwa kwavo uye vakagura marunda enzombe sezvavaida. ");
INSERT INTO sna_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kutsamwa kwavo ngakutukwe, kunotyisa zvakadai, uye hasha dzavo, dzaiva noutsinye kudai! Ndichavaparadzira muna Jakobho uye ndigovatsaura muna Israeri. ");
INSERT INTO sna_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judha, hama dzako dzichakurumbidza; ruoko rwako ruchava pamitsipa yavavengi vako; vanakomana vababa vako vachakotama kwauri. ");
INSERT INTO sna_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Uri mwana weshumba, iwe Judha; unodzoka kubva kune zvaunouraya, mwana wangu. Seshumba anonyangira uye anovata pasi, seshumbakadzi, ndiani anotsunga kumumutsa? ");
INSERT INTO sna_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tsvimbo youshe haingabvi kuna Judha, uye mudonzvo womutongi pakati pamakumbo ake, kusvikira asvika kumuridzi wawo, uye kuteerera kwendudzi ndokwake. ");
INSERT INTO sna_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Achasungirira mbongoro yake pamuzambiringa, nomwana wayo padavi rakaisvonaka; achasuka nguo dzake muwaini, zvokufuka zvake muropa ramazambiringa. ");
INSERT INTO sna_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meso ake achasviba kupfuura waini, meno ake achachena kupfuura mukaka. ");
INSERT INTO sna_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebhuruni achagara kumahombekombe egungwa uye achava zororo rezvikepe; muganhu wake uchasvika paSidhoni. ");
INSERT INTO sna_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakari imbongoro ine simba, ivete pasi pakati pamatanga amakwai. ");
INSERT INTO sna_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Paanoona nzvimbo yake yokuzorora kuti yanaka sei uye kuti nyika yake inofadza sei, acharerekera pfudzi rake kumutoro uye achava mubatiri wechibharo. ");
INSERT INTO sna_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dhani acharuramisira vanhu vake somumwe wamarudzi aIsraeri. ");
INSERT INTO sna_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dhani achava nyoka iri parutivi pomugwagwa, semhakure iri munzira, inoruma chitsitsinho chebhiza kuitira kuti mutasvi waro awire pasi neshure. ");
INSERT INTO sna_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ndakamirira rusununguko rwenyu, imi Jehovha. ");
INSERT INTO sna_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadhi acharohwa neboka ravapambi, asi achavarova pazvitsitsinho zvavo. ");
INSERT INTO sna_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Zvokudya zvaAsheri zvichava zvakakora; achauya nezvinonaka zvakafanira madzimambo. ");
INSERT INTO sna_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutari isheche yemhembwe yakasunungurwa, inobereka tsvana dzakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josefa muzambiringa unobereka mazambiringa, unobereka uri pedyo netsime, matavi awo anokwira pamadziro. ");
INSERT INTO sna_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Neshungu vapfuri vanomurwisa; vanomupfura noruvengo. ");
INSERT INTO sna_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Asi uta hwake hwakaramba hwakasimba, maoko ake akasimba, akagwinya, nokuda kworuoko rwaIye Anesimba waJakobho, nokuda kwoMufudzi, iye Dombo raIsraeri, ");
INSERT INTO sna_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nokuda kwaMwari wababa vako anokubatsira, nokuda kwoWamasimba Ose anokuropafadza namaropafadzo okumatenga kumusoro, maropafadzo okwakadzika kuri pasi, maropafadzo amazamu neechizvaro. ");
INSERT INTO sna_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Maropafadzo ababa vako makuru kupfuura maropafadzo amakomo ekare, kupfuura zvakawanda zvezvikomo zvamakore ekare. Zvose izvi ngazvigare pamusoro waJosefa, pamusoro womuchinda ari pakati pehama dzake. ");
INSERT INTO sna_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bhenjamini ibere rinoparadza; mangwanani anodya nyama, madekwana anogovera zvaapamba.” ");
INSERT INTO sna_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ava vose ndiwo marudzi gumi namaviri aIsraeri, uye izvi ndizvo zvakataurwa nababa vavo kwavari pavakavaropafadza, vachipa mumwe nomumwe kuropafadzwa kwakamufanira. ");
INSERT INTO sna_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ipapo akavarayira akati, “Ini ndava kuzosanganiswa navanhu vokwangu. Mundivige namadzibaba angu mubako mumunda waEfuroni muHiti, ");
INSERT INTO sna_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","bako riri mumunda weMakapera, pedyo neMamure muKenani, rakatengwa kubva kuna Efuroni naAbhurahama senzvimbo yokuviga pamwe chete nomunda. ");
INSERT INTO sna_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ndipo pakavigwa Abhurahama nomukadzi wake Sara, ndipozve pakavigwa Isaka nomukadzi wake Rabheka, uye Rea akavigwa ipapo. ");
INSERT INTO sna_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Munda nebako riri mauri zvakatengwa kubva kuvaHiti.” ");
INSERT INTO sna_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jakobho akati apedza kurayira vanakomana vake, akadzora tsoka dzake mumubhedha, akabudisa mweya wake akasanganiswa navanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josefa akazviwisira pamusoro pababa vake akachema pamusoro pavo uye akavatsvoda. ");
INSERT INTO sna_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ipapo Josefa akarayira varapi vaimushandira kuti vasasike baba vake Israeri. Saka varapi vakamusasika, ");
INSERT INTO sna_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","vakapedza mazuva makumi mana azere, nokuti ndiyo yakanga iri nguva yaidikanwa yokusasika mutumbi. Uye vaIjipiti vakamuchema kwamazuva makumi manomwe. ");
INSERT INTO sna_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mazuva okuchema akati apera, Josefa akati kune veimba yaFaro, “Kana ndawana nyasha pamberi penyu, nditaurireiwo kuna Faro. Mumuudze kuti, ");
INSERT INTO sna_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baba vangu vakaita kuti ndipike mhiko uye vakati, “Ini ndava kufa; mundivige muguva randakazvicherera munyika yeKenani.” Zvino regai hangu ndikwidze ndinoviga baba vangu; ipapo ndigozodzoka hangu.’ ” ");
INSERT INTO sna_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faro akati, “Kwira hako undoviga baba vako, sezvo vakaita kuti upikire kuita izvozvo.” ");
INSERT INTO sna_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Saka Josefa akakwidza kundoviga baba vake. Varanda vose vaFaro vakamuperekedza, vanokudzwa vomumba make navose vanokudzwa vomuIjipiti, ");
INSERT INTO sna_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","tisingaverengi vose vomumhuri yaJosefa namadzikoma ake uye navose veimba yababa vake. Vana vavo chete namakwai avo nemombe dzavo, ndivo vakasiyiwa muGosheni. ");
INSERT INTO sna_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ngoro navatasvi vamabhiza vakaendawo naye. Rakanga riri boka guru kwazvo. ");
INSERT INTO sna_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Vakati vasvika paburiro raAtadhi, pedyo neJorodhani, vakachema zvikuru neshungu; uye ipapo Josefa akatara mazuva manomwe okuchema baba vake. ");
INSERT INTO sna_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","VaKenani vaigara ikoko vakati vachiona kuchema ikoko paburiro raAtadhi, vakati, “VaIjipita vari pakuchema kukuru.” Ndokusaka nzvimbo iyo iri pedyo neJorodhani yakatumidzwa zita rokuti Abheri Miziraimi. ");
INSERT INTO sna_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Saka vanakomana vaJakobho vakaita sezvaakavarayira: ");
INSERT INTO sna_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Vakamutakura vakaenda naye kunyika yeKenani uye vakamuviga mubako mumunda weMakapera, pedyo neMamure, rakatengwa naAbhurahama senzvimbo yokuviga kubva kuna Efuroni muHiti, pamwe chete nomunda wacho. ");
INSERT INTO sna_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Shure kwokuvigwa kwababa vake, Josefa akadzokera kuIjipiti, pamwe chete namadzikoma ake navamwe vose vakanga vaenda naye kundoviga baba vake. ");
INSERT INTO sna_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Madzikoma aJosefa akati aona kuti baba vavo vakanga vafa, vakati, “Zvimwe Josefa angadaro achiri kutivenga uye akatitsiva pane zvakaipa zvose zvatakaita kwaari?” ");
INSERT INTO sna_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Saka vakatuma shoko kwaari vakati, “Baba vako vakasiya varayira vasati vafa vachiti: ");
INSERT INTO sna_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Izvi ndizvo zvamunofanira kutaura kuna Josefa: Ndinokumbira kuti ukanganwire madzikoma ako zvivi zvavo nezvitadzo zvavakaita pavakakuitira zvakaipa kwazvo. Zvino ndapota kanganwira hako zvivi zvavaranda vaMwari wababa vako.’ ” Pakasvika shoko ravo kwaari, Josefa akachema. ");
INSERT INTO sna_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ipapo madzikoma ake akauya akazviwisira pasi pamberi pake. Vakati, “Tiri varanda venyu.” ");
INSERT INTO sna_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Asi Josefa akati kwavari, “Musatya. Ko, ini ndiri pachinzvimbo chaMwari here? ");
INSERT INTO sna_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Imi makafunga kundiitira zvakaipa, asi Mwari akafunga kuita zvakanaka kuti apedzise zviri kuitwa iye zvino, iko kuponeswa kwemweya mizhinji. ");
INSERT INTO sna_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Naizvozvo zvino, musatya. Ndichakuriritirai imi navana venyu.” Akavasimbaradza uye akataura nounyoro kwavari. ");
INSERT INTO sna_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josefa akagara muIjipiti pamwe chete nemhuri yose yababa vake. Akararama kwamakore zana negumi, ");
INSERT INTO sna_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","uye akaona vana vaEfuremu vorudzi rwechitatu. Uyewo vana vaMakiri mwanakomana waManase vakaiswa pamakumbo aJosefa pavakaberekwa. ");
INSERT INTO sna_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ipapo Josefa akati kumadzikoma ake, “Ini ndava kuzofa. Asi zvirokwazvo Mwari achakubatsirai nokukubudisai munyika muno achikuendesai kunyika yakavimbiswa nemhiko kuna Abhurahama, Isaka naJakobho.” ");
INSERT INTO sna_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Uye Josefa akaita kuti vanakomana vaIsraeri vapike mhiko uye akati, “Zvirokwazvo Mwari achakubatsirai, uye ipapo munofanira kutakura mapfupa angu kubva munzvimbo ino.” ");
INSERT INTO sna_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Saka Josefa akafa ava namakore zana negumi. Uye shure kwokumusasika, akaiswa mubhokisi muIjipiti.");
INSERT INTO sna_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Aya ndiwo mazita avanakomana vaIsraeri vakaenda naJakobho kuIjipiti, mumwe nomumwe nemhuri yake: ");
INSERT INTO sna_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubheni, Simeoni, Revhi naJudha; ");
INSERT INTO sna_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zebhuruni naBhenjamini; ");
INSERT INTO sna_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dhani naNafutari; Gadhi naAsheri. ");
INSERT INTO sna_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Zvizvarwa zvose zvaJakobho zvakanga zviri makumi manomwe pakuwanda; Josefa akanga atova muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Zvino Josefa nehama dzake dzose navose vezera iroro vakafa, ");
INSERT INTO sna_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","asi vaIsraeri vakaberekana vakawanda zvikuru uye vakava vazhinji kwazvo, zvokuti nyika yakanga yazara navo. ");
INSERT INTO sna_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ipapo mambo mutsva, akanga asingazivi nezvaJosefa, akatanga kutonga muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Akati kuvanhu vake, “Tarirai, vaIsraeri vanyanya kuwanda kwazvo. ");
INSERT INTO sna_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Uyai tivafungire zano nokuti vangazonyanya kuwanda uye kana hondo ikamuka, vangazobatana navavengi vedu, vakarwa nesu vakazobva munyika.” ");
INSERT INTO sna_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Saka vakagadza vatariri vebasa pamusoro pavo kuti vavadzvinyirire nebasa rechibharo, uye vakavaka Pitomu neRamesesi kuti ave maguta amatura aFaro. ");
INSERT INTO sna_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Asi pavakanyanya kudzvinyirirwa ndipo pavakanyanya kuwanda uye nokupararira; saka vaIjipita vakasvika pakutya vaIsraeri ");
INSERT INTO sna_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","uye vakavashandisa zvino utsinye. ");
INSERT INTO sna_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Vakashungurudza upenyu hwavo nebasa rakaoma rezvidhina nedhaka uye nemhando dzose dzebasa romuminda; vaIjipita vakavashandisa noutsinye mubasa rakaoma. ");
INSERT INTO sna_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mambo weIjipiti akati kuna vananyamukuta vechiHebheru vainzi Shifura naPua, ");
INSERT INTO sna_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Pamunobatsira vakadzi vechiHebheru pakusununguka uye mukavacherechedza vachisununguka, kana ari mukomana, mumuuraye; kana ari musikana murege ari mupenyu.” ");
INSERT INTO sna_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Asi, vananyamukuta vakanga vachitya Mwari, uye havana kuita zvavakanga varayirwa namambo weIjipiti kuti vaite; vakarega vanakomana vari vapenyu. ");
INSERT INTO sna_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ipapo mambo weIjipiti akadana vananyamukuta akavabvunza achiti, “Seiko maita izvi? Seiko marega vana vechikomana vari vapenyu?” ");
INSERT INTO sna_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Vananyamukuta vakapindura Faro vachiti, “Vakadzi vechiHebheru havana kufanana navakadzi veIjipiti; vane simba uye vanosununguka vananyamukuta vasati vasvika.” ");
INSERT INTO sna_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Saka Mwari akaitira vananyamukuta zvakanaka uye vanhu vakawedzerwa vakava vazhinji kwazvo. ");
INSERT INTO sna_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Uye nokuda kwokuti vananyamukuta vaitya Mwari, iye akavapa mhuri dzavo pachavo. ");
INSERT INTO sna_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ipapo Faro akarayira vanhu vose kuti, “Vanakomana vose vanoberekwa munofanira kuvakanda murwizi Nairi, asi murege vanasikana vose vari vapenyu.” ");
INSERT INTO sna_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Zvino mumwe murume weimba yaRevhi akawana mukadzi, ");
INSERT INTO sna_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","uye mukadzi uyu akava nemimba akabereka mwanakomana. Paakaona kuti akanga ari mwana akanaka, akamuvanza kwemwedzi mitatu. ");
INSERT INTO sna_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Asi akati asisagoni kumuvanza, akamutorera tswanda yenhokwe akainama netara nenamo. Ipapo akaisa mwana imomo ndokuiisa pakati petsanga dzaiva mumahombekombe aNairi. ");
INSERT INTO sna_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hanzvadzi yake yakamira iri chinhambwe kuti ione kuti chii chaizoitika kwaari. ");
INSERT INTO sna_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ipapo mwanasikana waFaro akaburuka akaenda kurwizi Nairi kuti andoshamba, uye varandakadzi vake vakanga vachifamba vachitevedza mahombekombe. Akaona tswanda pakati petsanga ndokubva atuma murandakadzi wake kuti andoitora. ");
INSERT INTO sna_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Akaizarura akaona mwana. Akanga achichema, uye akamunzwira tsitsi. Akati, “Uyu ndomumwe wavana vavaHebheru.” ");
INSERT INTO sna_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ipapo hanzvadzi yake yakakumbira mwanasikana waFaro ikati, “Ndingaenda here ndikandokutorerai mumwe wavakadzi vechiHebheru kuti azokurererai mwana?” ");
INSERT INTO sna_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Uye mwanasikana waFaro akapindura akati, “Hongu.” Uye musikana akaenda akandotora mai vomwana. ");
INSERT INTO sna_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwanasikana waFaro akati kwavari, “Tora mwana uyu unondirererawo, uye ini ndichakupa muripo wako.” Saka mukadzi akatora mwana akamurera. ");
INSERT INTO sna_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwana akati akura, akamutora akaenda naye kumwanasikana waFaro akava mwanakomana wake. Akamutumidza zita rokuti Mozisi, achiti, “Ndakamutora mumvura.” ");
INSERT INTO sna_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Rimwe zuva Mozisi akura, akaenda kwakanga kuna vanhu vokwake uye akavatarira vari pabasa ravo rakaoma. Akaona muIjipita achirova muHebheru, mumwe wavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Akaringa-ringa ndokuona kusina munhu achibva auraya muIjipita, ndokumuviga mujecha. ");
INSERT INTO sna_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Zuva rakatevera, akabuda akaona vaHebheru vaviri vachirwa. Akabvunza uya akanga akanganisa akati, “Seiko uchirova mumwe wako muHebheru?” ");
INSERT INTO sna_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Murume uya akati, “Ndianiko akakuita mubati nomutongi pamusoro pedu? Uri kuda kundiuraya sokuuraya kwawakaita muIjipita nhai?” Ipapo Mozisi akatya akafunga akati, “Zvandakaita zvinofanira kuva zvava kuzivikanwa.” ");
INSERT INTO sna_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faro akati anzwa izvi, akaedza kuuraya Mozisi, asi Mozisi akatiza Faro akaenda kundogara kuMidhiani, uye akagara patsime. ");
INSERT INTO sna_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Zvino muprista weMidhiani akanga ana vanasikana vanomwe uye vakauya kuzochera mvura yokuti vazadze midziyo yainwira zvipfuwo zvababa vavo. ");
INSERT INTO sna_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Vamwe vafudzi vakasvika vakavadzinga, asi Mozisi akasimuka akavanunura uye akanwisa zvipfuwo zvavo. ");
INSERT INTO sna_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Vasikana pavakadzokera kuna Reueri baba vavo, akavabvunza akati, “Makurumidza seiko kudzoka nhasi?” ");
INSERT INTO sna_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Vakapindura vakati, “Tanunurwa nomuIjipita kubva kuvafudzi. Abva aticherera mvura uye akanwisa zvipfuwo.” ");
INSERT INTO sna_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Akabvunza vanasikana vake akati, “Aripiko? Mamusiyirei? Mudanei, auye azodya.” ");
INSERT INTO sna_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mozisi akabvuma kugara nomurume uyu, uyo akazopa mwanasikana wake Zipora kuna Mozisi kuti ave mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora akabereka mwanakomana, uye Mozisi akamutumidza zita rokuti Gerishomi, achiti, “Ndava mueni munyika yavatorwa.” ");
INSERT INTO sna_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Zvino makore mazhinji akati apfuura, mambo weIjipiti akafa. VaIsraeri vakagomera muutapwa hwavo uye vakachema, kuchemera rubatsiro rwavo nokuda kwoutapwa hwavo kukakwira kuna Mwari. ");
INSERT INTO sna_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mwari akanzwa kugomera kwavo uye akarangarira sungano yake naAbhurahama, naIsaka uye naJakobho. ");
INSERT INTO sna_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Saka Mwari akatarisa pamusoro pavaIsraeri akava nehanya navo. ");
INSERT INTO sna_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Zvino Mozisi akanga achifudza makwai aJeturo tezvara wake, muprista weMidhiani, uye akatungamirira makwai kurutivi rwuri kure mugwenga akasvika kuHorebhi, gomo raMwari. ");
INSERT INTO sna_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ikoko, mutumwa waJehovha akazviratidza kwaari mumarimi omoto aiva mugwenzi. Mozisi akaona kuti kunyange zvazvo gwenzi rakanga richipfuta, rakanga risingatsvi. ");
INSERT INTO sna_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Saka Mozisi akafunga akati, “Ndichaenda apo ndinoona chishamiso ichi, kuti seiko gwenzi risingatsvi.” ");
INSERT INTO sna_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Jehovha akati aona kuti akanga aendako kuti andoona, Mwari akadana kwaari kubva mugwenzi akati, “Mozisi! Mozisi!” Uye Mozisi akati, “Ndiri pano hangu.” ");
INSERT INTO sna_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mwari akati, “Usaswedera pedyo. Bvisa shangu dzako nokuti nzvimbo yaumire itsvene.” ");
INSERT INTO sna_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ipapo akati, “Ndini Mwari wababa vako, Mwari waAbhurahama, Mwari waIsaka naMwari waJakobho.” Uye Mozisi akafukidza chiso chake, nokuti akanga achitya kutarisa Mwari. ");
INSERT INTO sna_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Jehovha akati, “Zvirokwazvo ndaona kutambudzika kwavanhu vangu muIjipiti. Ndanzwa kuchema kwavo nokuda kwavatariri vavo vamabasa, uye ndinoziva kutambudzika kwavo. ");
INSERT INTO sna_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Saka ndaburuka kuti ndivanunure vabve muruoko rwavaIjipita uye kuti ndivabudise munyika iyo ndivaise kunyika yakanaka uye yakakura, nyika inoyerera mukaka nouchi, nzvimbo yavaKenani, vaHiti, vaAmori, vaPerezi, vaHivhi navaJebhusi. ");
INSERT INTO sna_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Uye zvino kuchema kwavaIsraeri kwasvika kwandiri, uye ndaona nzira yavanotambudzwa nayo navaIjipita. ");
INSERT INTO sna_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Saka chienda, zvino, ndiri kukutuma kuna Faro kuti undobudisa vanhu vangu vaIsraeri kubva muIjipiti.” ");
INSERT INTO sna_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Asi Mozisi akati kuna Mwari, “Ndini aniko ini kuti ndiende kuna Faro kuti ndinobudisa vaIsraeri kubva muIjipiti?” ");
INSERT INTO sna_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Uye Mwari akati, “Ndichava newe. Uye ichi chichava chiratidzo kwauri chokuti ndini ndakutuma: Paunenge wabudisa vanhu kubva muIjipiti, muchanamata Mwari pagomo rino.” ");
INSERT INTO sna_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mozisi akati kuna Mwari, “Ko, kana ndikaenda kuvaIsraeri uye ndikanoti kwavari, ‘Mwari wamadzibaba enyu andituma kwamuri,’ uye ivo vakandibvunza kuti, ‘Zita rake ndiani?’ ipapo ndichavaudzeiko?” ");
INSERT INTO sna_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mwari akati kuna Mozisi, “Ndiri Wandiri. Izvi ndizvo zvaunofanira kutaura kuvaIsraeri: ‘Ndiri’ andituma kwamuri.” ");
INSERT INTO sna_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mwari akatiwo kuna Mozisi, “Uti kuvaIsraeri, ‘Jehovha, Mwari wamadzibaba enyu, Mwari waAbhurahama, Mwari waIsaka naMwari waJakobho andituma kwamuri.’ Iri ndiro zita rangu nokusingaperi, zita randinofanira kurangarirwa naro kusvikira kuzvizvarwa zvose. ");
INSERT INTO sna_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Enda undounganidza vakuru vavaIsraeri ugoti kwavari, ‘Jehovha, Mwari wamadzibaba enyu, Mwari waAbhurahama, Mwari waIsaka, naMwari waJakobho, akazviratidza kwandiri uye akati, “Ndakatarira pamusoro penyu uye ndikaona zvakanga zvichiitwa kwamuri muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Uye ndakavimbisa kukubudisai mukutambudzika kwenyu muIjipiti ndikuisei kunyika yavaKenani, navaHiti, vaAmori, vaPerezi, vaHivhi navaJebhusi, nyika inoyerera mukaka nouchi.” ’ ");
INSERT INTO sna_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Vakuru vavaIsraeri vachakuteerera. Ipapo iwe navakuru vavaIsraeri munofanira kuenda kuna mambo weIjipiti munoti kwaari, ‘Jehovha Mwari wavaHebheru akasangana nesu. Regai tifambe rwendo rwamazuva matatu tiende kurenje kuti tindobayira kuna Jehovha Mwari wedu.’ ");
INSERT INTO sna_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Asi ndinoziva kuti mambo weIjipiti haasi kuzokutenderai kunze kwokunge ruoko rune simba rwamumanikidza. ");
INSERT INTO sna_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Saka ndichatambanudza ruoko rwangu ndigorova vaIjipiti nezvishamiso zvose zvandichaita pakati pavo. Shure kwaizvozvo achakutenderai kuenda. ");
INSERT INTO sna_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Uye ndichaita kuti vaIjipita vaitire vanhu ava nyasha, zvokuti pamunoenda hamuendi musina chinhu. ");
INSERT INTO sna_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mukadzi mumwe nomumwe anofanira kukumbira muvakidzani wake nomukadzi upi zvake waagere naye mumba make, zvishongo zvesirivha nezvegoridhe uye nguo dzamuchapfekedza vanakomana venyu nevanasikana venyu. Uye saizvozvo muchapamba vaIjipita.” ");
INSERT INTO sna_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mozisi akapindura akati, “Ko, kana vakasanditenda kana kunditeerera uye vakati, ‘Jehovha haana kuzviratidza kwauri’?” ");
INSERT INTO sna_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ipapo Jehovha akati kwaari, “Chiiko icho chiri muruoko rwako?” Akapindura akati, “Itsvimbo.” ");
INSERT INTO sna_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Jehovha akati, “Ikande pasi.” Mozisi akaikanda pasi ikava nyoka, uye akaitiza. ");
INSERT INTO sna_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ipapo Jehovha akati kwaari, “Tambanudza ruoko ugoibata nokumuswe.” Saka Mozisi akatambanudza ruoko ndokubata nyoka uye ikadzokera pakare pakuva tsvimbo muruoko rwake. ");
INSERT INTO sna_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Jehovha akati, “Izvi ndezvokuti vagotenda kuti Jehovha, Mwari wamadzibaba avo, Mwari waAbhurahama, Mwari waIsaka, naMwari waJakobho, azviratidza kwauri.” ");
INSERT INTO sna_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ipapo Jehovha akati, “Isa ruoko rwako muchipfuva chako.” Saka Mozisi akaisa ruoko rwake muchipfuva chake, uye paakarubudisa, rwakanga rwachena maperembudzi, sechando. ");
INSERT INTO sna_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Iye akati, “Zvino chirudzorerazve muchipfuva chako,” uye paakarubudisa, rwakanga rwavandudzwa, rwaita somuviri wake wose. ");
INSERT INTO sna_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ipapo Jehovha akati, “Kana vasingakutendi kana kuteerera kuchiratidzo chokutanga, vangangotendawo chechipiri. ");
INSERT INTO sna_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Asi kana vasingatendi zviratidzo zviviri izvi kana kukuteerera, utore mvura kubva muna Nairi ugoidira pasi. Mvura yaunotora kubva murwizi ichava ropa pamusoro pevhu.” ");
INSERT INTO sna_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mozisi akati kuna Jehovha, “Haiwa Jehovha, handina kumbogona kutaura, kunyange nakare, kana kubva pamataura nomuranda wenyu. Ndinokakama pakutaura uye rurimi rwangu runononoka.” ");
INSERT INTO sna_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Jehovha akati kwaari, “Ndianiko akapa munhu muromo? Ndianiko anomuita matsi kana mbeveve? Ndiani anomusvinudza kana kumuita bofu? Handisini here, Jehovha? ");
INSERT INTO sna_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Zvino chienda, ini ndichakubatsira kutaura uye ndichakudzidzisa zvokutaura.” ");
INSERT INTO sna_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Asi Mozisi akati, “Haiwa Jehovha, ndapota hangu, tumai henyu mumwe kuti aite izvozvo.” ");
INSERT INTO sna_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ipapo kutsamwa kwaJehovha kwakapisa pamusoro paMozisi uye akati, “Ko, mukoma wako, Aroni muRevhi? Ndinoziva kuti anogona kutaura zvakanaka. Ari munzira kuzokuchingamidza izvozvi, uye mwoyo wake uchafara paachakuona. ");
INSERT INTO sna_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Uchataura naye ugoisa mashoko mumuromo make; ndichakubatsirai mose uye ndichakudzidzisai zvokuita. ");
INSERT INTO sna_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Uye achataura kuvanhu panzvimbo yako, uye zvichaita sokunge iye ndiye muromo wako uye sokunge iwe ndiwe Mwari kwaari. ");
INSERT INTO sna_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Asi takura tsvimbo iyi muruoko rwako yauchaita zviratidzo nayo.” ");
INSERT INTO sna_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ipapo Mozisi akadzokera kuna Jeturo tezvara wake akati kwaari, “Regai ndidzokere kuvanhu vokwangu kuIjipiti kuti ndinoona kana vachiri vapenyu.” Jeturo akati, “Enda hako, ufambe zvakanaka.” ");
INSERT INTO sna_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Zvino Jehovha akanga ati kuna Mozisi ari muMidhiani, “Dzokera kuIjipiti, nokuti vanhu vose vaida kukuuraya vakafa.” ");
INSERT INTO sna_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Saka Mozisi akatora mukadzi wake navanakomana vake akavakwidza pambongoro akasimuka akadzokera kuIjipiti. Uye akatakura tsvimbo yaMwari muruoko rwake. ");
INSERT INTO sna_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Jehovha akati kuna Mozisi, “Paunodzokera kuIjipiti, uone kuti waita zvishamiso zvose pamberi paFaro, ndakupa simba rokuita izvozvo. Asi ndichaomesa mwoyo wake zvokuti haazotenderi vanhu kuenda. ");
INSERT INTO sna_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ipapo uti kuna Faro, ‘Zvanzi naJehovha: Israeri ndiye mwanakomana wangu wedangwe, ");
INSERT INTO sna_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","uye ndinoti kwauri, “Rega mwanakomana wangu aende, kuti anondinamata.” Asi kana ukaramba kumutendera kuti aende, ndichauraya mwanakomana wako wedangwe.’ ” ");
INSERT INTO sna_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ari paimba yavaeni pavakavata, Jehovha akasangana naMozisi uye akada kumuuraya. ");
INSERT INTO sna_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Asi Zipora akatora banga rebwe romusarasara akacheka chikanda chapamberi chomwanakomana wake uye akabata tsoka dzaMozisi nacho. Akati, “Zvirokwazvo uri murume weropa kwandiri.” ");
INSERT INTO sna_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Saka Jehovha akamurega. Panguva iyoyo Zipora akati kwaari, “Murume weropa,” achireva nezvokudzingiswa. ");
INSERT INTO sna_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Jehovha akati kuna Aroni, “Enda kurenje undosangana naMozisi.” Saka akasangana naMozisi pagomo raMwari uye akamutsvoda. ");
INSERT INTO sna_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ipapo Mozisi akaudza Aroni zvinhu zvose zvaakanga atumwa naJehovha kuti azozvitaura, uyewo pamusoro pezvishamiso zvose zvaakanga amurayira kuti aite. ");
INSERT INTO sna_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mozisi naAroni vakaunganidza vakuru vose vavana vaIsraeri, ");
INSERT INTO sna_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","uye Aroni akavaudza zvinhu zvose zvakanga zvaudzwa Mozisi naJehovha. Akaitawo zviratidzo pamberi pavanhu, ");
INSERT INTO sna_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","vakatenda. Uye pavakanzwa kuti Jehovha akanga ane hanya navo, uye kuti akanga aona kutambudzika kwavo, vakakotama pasi vakanamata. ");
INSERT INTO sna_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Shure kwaizvozvo Mozisi naAroni vakaenda kuna Faro vakati, “Zvanzi naJehovha, Mwari waIsraeri: ‘Rega vanhu vangu vaende, kuti vanondiitira mutambo kurenje.’ ” ");
INSERT INTO sna_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faro akati, “Jehovha ndianiko, kuti ndigomuteerera uye ndigorega vaIsraeri vachienda? Handimuzivi Jehovha iyeye uye handidi kurega vaIsraeri vachienda.” ");
INSERT INTO sna_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ipapo vakati, “Mwari wavaHebheru akasangana nesu. Zvino tiregei tifambe rwendo rwamazuva matatu kurenje kuti tinobayira zvipiriso kuna Jehovha Mwari wedu, kuti arege kutirova namatambudziko kana nomunondo.” ");
INSERT INTO sna_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Asi mambo weIjipiti akati, “Mozisi naAroni, munobvisireiko vanhu pabasa ravo? Dzokerai kubasa renyu!” ");
INSERT INTO sna_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ipapo Faro akati, “Tarirai, vanhu vawanda zvino munyika, uye muri kuvakonesa kushanda.” ");
INSERT INTO sna_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Musi mumwe chetewo Faro akarayira vatariri vebasa navakuru vakuru vavanhu achiti, ");
INSERT INTO sna_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Imi hamuchazovigiri vanhu uswa hwokuita zvidhina; varegei vandozviunganidzira uswa pachavo. ");
INSERT INTO sna_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Asi vanofanira kuita zvidhina zvakaenzana pakuwanda nezvavaisimboita kare; musazvitapudza. Isimbe; ndokusaka vachichema vachiti, ‘Tiregei tiende kundobayira kuna Mwari wedu.’ ");
INSERT INTO sna_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Itai kuti basa rinyanye kuomera vanhu kuitira kuti varambe vachishanda uye varege kuteerera kunhema.” ");
INSERT INTO sna_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ipapo vatariri vebasa navakuru vakuru vakabuda vakandoti kuvanhu, “Zvanzi naFaro, ‘Handichazokupaizve uswa. ");
INSERT INTO sna_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Endai mundozvitsvakira uswa kana kupi zvako kwamungahuwana, asi basa renyu haritapudzwi kana napaduku.’ ” ");
INSERT INTO sna_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Saka vanhu vakapararira muIjipiti yose kundounganidza mashanga kuti vaashandise pachinzvimbo chouswa. ");
INSERT INTO sna_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Vatariri vebasa vakaramba vachivamanikidza vachiti, “Pedzai basa ramakatarirwa pazuva rimwe nerimwe, sezvamaiita pamaiwana uswa.” ");
INSERT INTO sna_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Vakuru vakuru vavaIsraeri vakanga vagadzwa navatariri vebasa vaFaro vakarohwa uye vakabvunzwa kuti, “Seiko musina kupedza basa renyu rezvidhina zvanezuro nezvanhasi, sezvamaichiita kare pamaipuwa uswa.” ");
INSERT INTO sna_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ipapo vakuru vakuru vavaIsraeri vakaenda nechichemo kuna Faro vakati, “Seiko muchibata varanda venyu nenzira yakadai? ");
INSERT INTO sna_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Varanda venyu havapiwi uswa, asi tinonzi, ‘Itai zvidhina!’ Varanda venyu vari kurohwa, asi mhosva ndeyavanhu venyu.” ");
INSERT INTO sna_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faro akati, “Simbe, ndizvo zvamuri imi, muri simbe! Ndokusaka muchingoramba muchiti, ‘Tiregei tindobayira kuna Jehovha.’ ");
INSERT INTO sna_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Zvino chiendai kubasa. Hamuzombopiwi kana uswa, asi munofanira kuita basa renyu rezvidhina zvakakwana.” ");
INSERT INTO sna_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Vakuru vakuru vavaIsraeri vakaona kuti vapinda mudambudziko pavakaudzwa kuti, “Hamufaniri kutapudza uwandu hwezvidhina zvamakatarirwa pazuva rimwe.” ");
INSERT INTO sna_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Pavakabva pana Faro, vakawana Mozisi naAroni vakavamirira, ");
INSERT INTO sna_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","uye vakati, “Jehovha ngaakutarirei uye akutongei! Matiita chinhu chinonhuhwa kuna Faro namachinda ake uye maisa munondo muruoko rwavo kuti vatiuraye.” ");
INSERT INTO sna_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mozisi akadzokera kuna Jehovha akati, “Haiwa Jehovha, mauyisireiko dambudziko pamusoro pavanhu ava? Ndizvo zvamakanditumira here? ");
INSERT INTO sna_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kubva pandakaenda kuna Faro kuti ndinotaura muzita renyu, iye akauyisa dambudziko pamusoro pavanhu ava, uye imi hamuna kutongonunura vanhu venyu napaduku.” ");
INSERT INTO sna_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ipapo Jehovha akati kuna Mozisi, “Zvino uchaona zvandichaita kuna Faro. Nokuda kworuoko rwangu rune simba achavaregera kuti vaende; nokuda kworuoko rwangu rune simba achavadzinga munyika make.” ");
INSERT INTO sna_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mwari akatiwo kuna Mozisi, “Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ndakazviratidza kuna Abhurahama, kuna Isaka, nokuna Jakobho saMwari Wamasimba Ose, asi nezita rangu, Jehovha, handina kuzvizivisa kwavari. ");
INSERT INTO sna_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ndakasimbisawo sungano yangu navo kuti ndivape nyika yeKenani, nyika yavakagara savatorwa. ");
INSERT INTO sna_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Pamusoro paizvozvo, ndanzwa kugomera kwavaIsraeri, vakabatwa muutapwa navaIjipita, uye ndarangarira sungano yangu. ");
INSERT INTO sna_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Naizvozvo, uti kuvaIsraeri, ‘Ndini Jehovha, uye ndichakubudisai kubva pasi pejoko ravaIjipita. Ndichakusunungurai kuti musava nhapwa kwavari, uye ndichakudzikinurai noruoko rwakatambanudzwa uye nokutonga kwamabasa makuru. ");
INSERT INTO sna_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ndichakutorai savanhu vangu, uye ndichava Mwari wenyu. Ipapo muchaziva kuti ndini Jehovha Mwari wenyu, akakubvisai pasi pejoko ravaIjipita. ");
INSERT INTO sna_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Uye ndichakuuyisai kunyika yandakapika ndakasimudza ruoko kuna Abhurahama, kuna Isaka nokuna Jakobho. Ndichaipa kwamuri senhaka yenyu. Ndini Jehovha.’ ” ");
INSERT INTO sna_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mozisi akazivisa izvi kuvaIsraeri, asi havana kumuteerera nokuda kwokuora mwoyo kwavo uye nousungwa hune utsinye. ");
INSERT INTO sna_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Enda undotaurira Faro mambo weIjipiti kuti arege vaIsraeri vabude munyika yake.” ");
INSERT INTO sna_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Asi Mozisi akati kuna Jehovha, “Kana vaIsraeri vasinganditeereri, Faro anganditeerera seiko, sezvo ndichitaura nemiromo inokakama?” ");
INSERT INTO sna_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Zvino Jehovha akataura kuna Mozisi naAroni pamusoro pavaIsraeri napamusoro paFaro mambo weIjipiti, uye akavarayira kuti vabudise vaIsraeri kubva muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ava ndivo vaiva vakuru vemhuri dzavo: Vanakomana vaRubheni mwanakomana wedangwe waIsraeri vaiva Hanoki naParu, Hezironi naKami. Idzi ndidzo dzakanga dziri dzimba dzaRubheni. ");
INSERT INTO sna_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Vanakomana vaSimeoni vaiva Jemueri, Jamini, Ohadhi, Jakini, Zohari naShauri mwanakomana womukadzi muKenani. Idzi ndidzo dzaiva dzimba dzaSimeoni. ");
INSERT INTO sna_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Aya ndiwo mazita avanakomana vaRevhi maererano nokunyorwa kwawo: Gerishoni, Kohati naMerari. (Revhi akararama makore zana namakumi matatu namanomwe.) ");
INSERT INTO sna_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Vanakomana vaGerishoni, nedzimba dzavo, vaiva Ribhini naShimei. ");
INSERT INTO sna_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Vanakomana vaKohati vaiva Amurami, Izhari, Hebhuroni naUzieri. Kohati akararama kwamakore zana namakumi matatu namatatu. ");
INSERT INTO sna_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Vanakomana vaMerari vaiva Mari naMushi. Idzi ndidzo dzaiva dzimba dzaRevhi sokunyorwa kwadzo. ");
INSERT INTO sna_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amurami akawana hanzvadzi yababa vake Jokebhedhi, uyo akamuberekera Aroni naMozisi. (Amurami akararama kwamakore zana namakumi matatu namanomwe.) ");
INSERT INTO sna_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Vanakomana vaIzhari vaiva Kora, Nefegi naZikiri. ");
INSERT INTO sna_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Vanakomana vaUzieri vaiva Mishaeri, Erizafani naSitiri. ");
INSERT INTO sna_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroni akawana Erishebha mwanasikana waAminadhabhi nehanzvadzi yaNashoni, uye akamuberekera Nadhabhi naAbhihu, Ereazari naItamari. ");
INSERT INTO sna_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Vanakomana vaKora vaiva Asiri, Erikana naAbhiasafu. Idzi ndidzo dzaiva dzimba dzavaKora. ");
INSERT INTO sna_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ereazari mwanakomana waAroni akawana mumwe wavanasikana vaPutieri, uye akamuberekera Finehazi. Ava ndivo vakanga vari vakuru vemhuri dzavaRevhi, mhuri nemhuri. ");
INSERT INTO sna_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ndivo vaya vanaAroni naMozisi vakanzi naJehovha, “Budisai vaIsraeri muIjipiti namapoka avo.” ");
INSERT INTO sna_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ndivo vakataura kuna Faro mambo weIjipiti pamusoro pokubudisa vaIsraeri kubva muIjipiti. Ndivo vamwe chetevo Mozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Zvino Jehovha paakataura naMozisi muIjipiti, ");
INSERT INTO sna_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","akati kwaari, “Ndini Jehovha. Taurira Faro mambo weIjipiti zvose zvandinokuudza.” ");
INSERT INTO sna_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Asi Mozisi akati kuna Jehovha, “Sezvo ndichitaura nemiromo inokakama, Faro angateerera kwandiri seiko?” ");
INSERT INTO sna_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ipapo Jehovha akati kuna Mozisi. “Tarira, ndakuita saMwari kuna Faro, uye mukoma wako Aroni achava muprofita wako. ");
INSERT INTO sna_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Unofanira kutaura zvinhu zvose zvandinokurayira, uye mukoma wako Aroni anofanira kuudza Faro kuti arege vaIsraeri vabude munyika yake. ");
INSERT INTO sna_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Asi ndichaomesa mwoyo waFaro uye kunyange ndikawanza zviratidzo nezvishamiso zvangu muIjipiti, ");
INSERT INTO sna_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","haazombokuteereri. Ipapo ndichaisa ruoko rwangu pamusoro peIjipiti uye namabasa okutonga kukuru ndichabudisa hondo dzangu, ivo vanhu vangu vaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Uye vaIjipita vachaziva kuti ndini Jehovha pandichatambanudza ruoko rwangu pamusoro peIjipiti uye ndichabudisa vaIsraeri kubva mairi.” ");
INSERT INTO sna_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mozisi naAroni vakaita sezvavakanga varayirwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mozisi akanga ana makore makumi masere uye Aroni makumi masere namatatu pavakataura kuna Faro. ");
INSERT INTO sna_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Faro paanoti kwamuri, ‘Itai chiratidzo,’ ipapo uti kuna Aroni, ‘Tora tsvimbo yako uikande pasi pamberi paFaro,’ uye ichava nyoka.” ");
INSERT INTO sna_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Saka Mozisi naAroni vakaenda kuna Faro vakandoita sezvavakarayirwa naJehovha. Aroni akakanda tsvimbo yake pasi pamberi paFaro namachinda ake, uye ikava nyoka. ");
INSERT INTO sna_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ipapo Faro akadana varume vakachenjera navaroyi, uye nʼanga dzeIjipiti dzakaitawo zvimwe chetezvo nouroyi hwadzo. ");
INSERT INTO sna_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Mumwe nomumwe akakanda tsvimbo yake pasi uye ikava nyoka. Asi tsvimbo yaAroni yakamedza tsvimbo dzavo. ");
INSERT INTO sna_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Asi mwoyo waFaro wakava wakaoma uye haana kuvateerera, sezvakanga zvarehwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ipapo Jehovha akati kuna Mozisi, “Mwoyo waFaro mukukutu; haabvumi kuti vanhu vaende. ");
INSERT INTO sna_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Enda kuna Faro mangwanani paanenge achienda kumvura. Umire pamahombekombe aNairi kuti ugosangana naye, uye ubate muruoko rwako tsvimbo iya yakashandurwa ikava nyoka. ");
INSERT INTO sna_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ipapo uti kwaari, ‘Jehovha, Mwari wavaHebheru, andituma kuti ndizoti kwauri: Rega vanhu vangu vaende, kuitira kuti vanondinamata murenje. Asi kusvikira zvino hauna kunditeerera.’ ");
INSERT INTO sna_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Zvanzi naJehovha: ‘Uchaziva kuti ndini Jehovha nechinhu ichi: Ndicharova mvura yeNairi netsvimbo iri muruoko rwangu uye ichashanduka ikava ropa. ");
INSERT INTO sna_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Hove dziri muna Nairi dzichafa, uye rwizi ruchanhuhwa; vaIjipita havazokwanisi kunwa mvura yarwo.’ ” ");
INSERT INTO sna_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Jehovha akati kuna Mozisi, “Taurira Aroni uti, ‘Tora tsvimbo yako uye utambanudze ruoko rwako pamusoro pemvura yeIjipiti, pamusoro pehova pamusoro pemigero, pamusoro pamadziva uye napamusoro pamagawa,’ uye zvichashanduka zvikava ropa. Ropa richava pose pose muIjipiti, kunyange mukati memidziyo yemiti neyamabwe.” ");
INSERT INTO sna_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mozisi naAroni vakaita sezvavakarayirwa naJehovha. Akasimudza tsvimbo yake pamberi paFaro namachinda ake akarova mvura yeNairi, mvura yose ikashanduka ikava ropa. ");
INSERT INTO sna_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Hove dzaiva muna Nairi dzakafa, uye rwizi rwakanhuhwa zvakaipa kwazvo zvokuti vaIjipita havana kugona kunwa mvura yarwo. Ropa rakanga riri pose pose muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Asi nʼanga dzavaIjipita dzakaita zvimwe chetezvo nouroyi hwadzo, mwoyo waFaro ukava mukukutu; haana kuda kuteerera Mozisi naAroni, sezvakanga zvarehwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Asi akadzokera mumuzinda wake, uye haana kunyange kuzviisa mumwoyo make. ");
INSERT INTO sna_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Uye vaIjipita vose vakachera mujinga maNairi kuti vawane mvura yokunwa, nokuti vakanga vasingagoni kunwa mvura yomurwizi. ");
INSERT INTO sna_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mazuva manomwe akapfuura mushure mokunge Jehovha arova Nairi. ");
INSERT INTO sna_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ipapo Jehovha akati kuna Mozisi, “Enda kuna Faro undoti kwaari, ‘Zvanzi naJehovha: Rega vanhu vangu vaende, kuti vanondinamata. ");
INSERT INTO sna_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kana ukaramba kuti vaende, ndichatambudza nyika yako yose namatatya. ");
INSERT INTO sna_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nairi ruchazara namatatya. Achakwira agopinda mumuzinda wako nomuimba yako yokuvata uye napamubhedha wako, nomudzimba dzamachinda ako uye napavanhu vako uye nomuzvoto zvako nepokukanyira chingwa. ");
INSERT INTO sna_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Matatya achakwira pamusoro pako napamusoro pavanhu vako napamusoro pamachinda ako ose.’ ” ");
INSERT INTO sna_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ipapo Jehovha akati kuna Mozisi, “Taurira Aroni uti, ‘Tambanudza ruoko rwako pamwe chete netsvimbo yako pamusoro pehova napamusoro pemigero napamadziva, uye uite kuti matatya auye pamusoro penyika yeIjipiti.’ ” ");
INSERT INTO sna_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Saka Aroni akatambanudzira ruoko rwake pamusoro pemvura yeIjipiti, matatya akauya akafukidza nyika. ");
INSERT INTO sna_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Asi nʼanga dzakaitawo zvimwe chetezvo nouroyi hwadzo; vakaitawo matatya kuti auye pamusoro penyika yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Faro akadana Mozisi naAroni akati, “Nyengeterai kuna Jehovha kuti abvise matatya aya kwandiri uye nokuvanhu vangu, uye ini ndichatendera vanhu venyu kuti vaende kundobayira zvipiriso kuna Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mozisi akati kuna Faro, “Ndinopa ruremekedzo kwamuri kuti mureve nguva yokuti ndikunyengetererei imi navaranda venyu uye navanhu venyu kuti imi nedzimba dzenyu mubvisirwe matatya, kuti asare muna Nairi chete.” ");
INSERT INTO sna_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faro akati, “Mangwana.” Mozisi akapindura akati, “Zvichaitika sezvamareva, kuitira kuti mugoziva kuti hakuna mumwe akaita saJehovha Mwari wedu. ");
INSERT INTO sna_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Matatya achabva kwamuri nomudzimba dzenyu, kumachinda enyu nokuvanhu venyu; achasara muna Nairi chete.” ");
INSERT INTO sna_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ipapo Mozisi naAroni vakabva pana Faro, Mozisi akadana kuna Jehovha pamusoro pamatatya aakanga auyisa kuna Faro. ");
INSERT INTO sna_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Uye Jehovha akaita zvakanga zvakumbirwa naMozisi. Matatya akafa mudzimba, nomuruvazhe uye nomuminda. ");
INSERT INTO sna_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Akaunganidzwa akaita mirwi uye nyika yakanhuhwa nokuda kwawo. ");
INSERT INTO sna_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Asi Faro akati aona kuti rusununguko rwakanga rwavapo, akaomesa mwoyo wake uye akasada kuteerera Mozisi naAroni, sezvakanga zvarehwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ipapo Jehovha akati kuna Mozisi, “Taurira Aroni uti, ‘Tambanudza tsvimbo yako ugorova guruva revhu,’ uye munyika yose yeIjipiti, guruva richava umhutu.” ");
INSERT INTO sna_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Vakaita izvozvo uye Aroni akati atambanudza ruoko rwaiva netsvimbo akarova guruva umhutu hukauya pamusoro pavanhu nezvipfuwo. Guruva rose munyika yose yeIjipiti rakava umhutu. ");
INSERT INTO sna_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Asi nʼanga dzakakundikana, padzakaedza nouroyi hwadzo kubudisa umhutu. ");
INSERT INTO sna_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nʼanga dzakati kuna Faro, “Uyu munwe waMwari.” Asi mwoyo waFaro wakava mukukutu uye haana kuda kuteerera, sezvakanga zvarehwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ipapo Jehovha akati kuna Mozisi, “Muka mangwanani-ngwanani undosangana naFaro paanenge achienda kumvura ugoti kwaari, ‘Zvanzi naJehovha: Rega vanhu vangu vaende, kuti vanondinamata. ");
INSERT INTO sna_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kana usingatenderi vanhu vangu kuti vaende, ndichatumira bute renhunzi pamusoro pako napamusoro pamachinda ako, napamusoro pavanhu vako uye nomudzimba dzenyu. Dzimba dzavaIjipita dzichazara nenhunzi, uye kunyange pavhu pavamire. ");
INSERT INTO sna_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Asi pazuva iroro ndichatsaura nyika yeGosheni uko kunogara vanhu vangu; hakuna bute renhunzi richawanikwa ikoko kuitira kuti ugoziva kuti ini, Jehovha, ndiri munyika muno. ");
INSERT INTO sna_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ndichaita mutsauko pakati pavanhu vangu navanhu vako. Chiratidzo ichi chichaitika mangwana.’ ” ");
INSERT INTO sna_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Uye Jehovha akaita izvozvo. Mabute enhunzi akapinda mumuzinda maFaro uye nomudzimba dzamachinda ake, uye muIjipiti yose, nyika yakaparadzwa namabute enhunzi. ");
INSERT INTO sna_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ipapo Faro akadana Mozisi naAroni akati, “Endai mundobayira kuna Mwari wenyu munyika muno.” ");
INSERT INTO sna_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Asi Mozisi akati, “Hazvina kunaka kuita saizvozvo. Zvipiriso zvatinoda kubayira kuna Jehovha Mwari wedu zvingazonyangadza vaIjipita. Uye kana tikapa zvibayiro zvinonyangadza pamberi pavo, havangazotitaki namabwe here? ");
INSERT INTO sna_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tinofanira kufamba rwendo rwamazuva matatu kuti tinobayira kuna Jehovha Mwari wedu murenje, sezvaakatirayira.” ");
INSERT INTO sna_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faro akati, “Ndichakutenderai kuenda kunobayira zvipiriso kuna Jehovha Mwari wenyu murenje, asi hamufaniri kuenda kure kure. Zvino chindinyengetererai.” ");
INSERT INTO sna_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mozisi akapindura akati, “Ndichangobva pauri, ndichanonyengetera kuna Jehovha, uye mangwana nhunzi dzichabva pana Faro namachinda ake uye napavanhu vake. Ivai nechokwadi chete kuti Faro haazonyengerizve achirambidza vanhu kuenda kundopa zvibayiro kuna Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ipapo akabva pana Faro akandonyengetera kuna Jehovha, ");
INSERT INTO sna_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","uye Jehovha akaita zvaakakumbirwa naMozisi. Nhunzi dzakabva pana Faro nokumachinda ake uye nokuvanhu vake; hakuna nhunzi yakasara. ");
INSERT INTO sna_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Asi panguva inozve, Faro akaomesa mwoyo wake uye akaramba kutendera vanhu kuti vaende. ");
INSERT INTO sna_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ipapo Jehovha akati kuna Mozisi, “Enda kuna Faro undoti kwaari, ‘Zvanzi naJehovha: Mwari wavaHebheru: Rega vanhu vangu vaende, kuti vanondinamata. ");
INSERT INTO sna_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kana uchiramba kuti vaende uye ukaramba uchivadzivisa, ");
INSERT INTO sna_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ruoko rwaJehovha ruchauyisa hosha yakaipa pakati pezvipfuwo zvako zviri muminda napamusoro pamabhiza ako nembongoro dzako nengamera napamusoro pemombe dzako uye napamusoro pamakwai nembudzi. ");
INSERT INTO sna_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Asi Jehovha achaisa mutsauko pakati pezvipfuwo zveIsraeri nezveIjipiti, kuitira kuti parege kuva nezvipfuwo zvavaIsraeri zvichafa.’ ” ");
INSERT INTO sna_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jehovha akatsaura nguva uye akati, “Mangwana Jehovha achaita izvi munyika.” ");
INSERT INTO sna_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Uye chifumi chamangwana Jehovha akazviita: Zvipfuwo zvose zvavaIjipita zvakafa, asi hapana kana chipfuwo chimwe chete chavaIsraeri chakafa. ");
INSERT INTO sna_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faro akatuma vanhu kundoferefeta uye akawana kuti pakanga pasina kunyange chipfuwo chimwe chete chavaIsraeri chakanga chafa. Asi mwoyo wake wakanga uri mukukutu saka haana kutendera vanhu kuenda. ");
INSERT INTO sna_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ipapo Jehovha akati kuna Mozisi naAroni, “Torai tsama dzamadota kubva pachoto mugoita kuti Mozisi aakushe mumhepo pamberi paFaro. ");
INSERT INTO sna_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Richava guruva rakatsetseka pamusoro penyika yose yeIjipiti, uye mamota anoputika achamera pavanhu napazvipfuwo munyika yose.” ");
INSERT INTO sna_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Saka vakatora madota pachoto vakandomira pamberi paFaro. Mozisi akaakusha mumhepo, mamota anoputika akamera pamusoro pavanhu napamusoro pezvipfuwo. ");
INSERT INTO sna_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Nʼanga hadzina kugona kumira pamberi paMozisi nokuda kwamamota akanga ari pavari uye napavaIjipita vose. ");
INSERT INTO sna_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Asi Jehovha akaomesa mwoyo waFaro uye haana kuda kuteerera kuna Mozisi naAroni, zvakanga zvarehwa naJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ipapo Jehovha akati kuna Mozisi, “Muka mangwanani-ngwanani undosangana naFaro ugoti kwaari, ‘Zvanzi naJehovha Mwari wavaHebheru: Rega vanhu vangu vaende, kuti vanondinamata, ");
INSERT INTO sna_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","kana zvikasadaro nenguva ino ndichatuma matambudziko angu ose pamusoro pako napamusoro pavaranda vako uye napamusoro pavanhu vako, kuti ugoziva kuti hakuna mumwe akafanana neni munyika yose. ");
INSERT INTO sna_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nokuti iye zvino ndingadai ndakatambanudza ruoko rwangu ndikakurova iwe navanhu vako nehosha yaigona kukuparadzai panyika. ");
INSERT INTO sna_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Asi ndakakumutsa nokuda kwechinangwa ichi, kuti ndikuratidze simba rangu uye kuti zita rangu riparidzwe munyika yose. ");
INSERT INTO sna_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Iwe wakazvigadzirira kurwa navanhu vangu uye haudi kuvatendera kuti vaende. ");
INSERT INTO sna_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Naizvozvo, nenguva ino mangwana ndichatuma chimvuramabwe chakaipisisa kwazvo chisina kumbovapo pamusoro peIjipiti, kubva pazuva rayakavambwa kusvikira zvino. ");
INSERT INTO sna_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Chirayira izvozvi kuti zvipfuwo zvako nezvose zviri musango zvipinde mumatanga, nokuti chimvuramabwe chichawira pamusoro pomunhu wose napamusoro pezvipfuwo zvisina kupfigirwa zvichiri musango, uye zvichafa.’ ” ");
INSERT INTO sna_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Machinda aFaro ayo akanga achitya shoko raJehovha akakurumidza kupinza vatapwa vavo nezvipfuwo zvavo mukati. ");
INSERT INTO sna_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Asi vaya vakazvidza shoko raJehovha vakarega vatapwa vavo nezvipfuwo zviri musango. ");
INSERT INTO sna_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ipapo Jehovha akati kuna Mozisi, “Tambanudzira ruoko rwako kudenga kuti chimvuramabwe chiwire pamusoro peIjipiti yose, pamusoro pavanhu napamusoro pezvipfuwo napamusoro pezvinhu zvose zvinomera muminda yeIjipiti.” ");
INSERT INTO sna_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mozisi akati atambanudzira tsvimbo yake kudenga, Jehovha akatuma kutinhira nechimvuramabwe, uye mheni yakapenya yakananga pasi. Saka Jehovha akanayisa chimvuramabwe pamusoro penyika yeIjipiti; ");
INSERT INTO sna_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","chimvuramabwe chakawa uye mheni yakapenya mberi neshure. Ndiro rakava dutu rakaipisisa kwazvo munyika yose yeIjipiti, kubva panguva yavakatanga kuva rudzi. ");
INSERT INTO sna_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Munyika yose yeIjipiti, chimvuramabwe chakarova zvinhu zvose zvakanga zviri musango, zvose vanhu nezvipfuwo; chakarovera pasi zvose zvaimera musango ndokuparadza miti yose. ");
INSERT INTO sna_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nzvimbo yachisina kunaya chete inyika yeGosheni, uko kwaiva navaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ipapo Faro akadana Mozisi naAroni akati, “Nguva ino ndatadza. Jehovha ndiye akarurama asi ini navanhu vangu hatina kururama. ");
INSERT INTO sna_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nyengeterai kuna Jehovha, nokuti kutinhira nechimvuramabwe zvanyanya. Ndichakutenderai kuti muende; hamuchafaniri kuramba mugerezve muno.” ");
INSERT INTO sna_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mozisi akapindura akati, “Pandichabuda muguta, ndichatambanudza maoko angu ndichinyengetera kuna Jehovha. Mutinhiro uchapera uye hakuchazovazve nechimvuramabwe, kuti ugoziva kuti nyika ndeyaJehovha. ");
INSERT INTO sna_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Asi ndinoziva kuti iwe namachinda ako hamutyi Jehovha Mwari nazvino.” ");
INSERT INTO sna_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Miti yeshinda nebhari zvakanga zvaparadzwa, sezvo bhari rakanga rava nehura uye miti yava namaruva. ");
INSERT INTO sna_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Kunyange zvakadaro gorosi nesipereti, hazvina kuparadzwa, nokuti zvakanga zvisati zvaibva.) ");
INSERT INTO sna_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ipapo Mozisi akabva pana Faro akabuda muguta. Akatambanudzira maoko ake kuna Jehovha; kutinhira nechimvuramabwe zvakamira, uye mvura haina kuzonayazve panyika. ");
INSERT INTO sna_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Faro akati aona kuti mvura nechimvuramabwe uye nokutinhira zvapera, akatadzazve: Iye namachinda ake vakaomesa mwoyo yavo. ");
INSERT INTO sna_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Saka mwoyo waFaro wakaoma uye akasada kutendera vaIsraeri kuenda, sokutaura kwakanga kwaita Jehovha kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ipapo Jehovha akati kuna Mozisi, “Enda kuna Faro nokuti ndaomesa mwoyo wake uye nemwoyo yamachinda ake kuitira kuti ndiite zviratidzo zvangu izvi pakati pavo, ");
INSERT INTO sna_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kuti mugoudza vana venyu navazukuru venyu marangiro akaoma andakaita vaIjipita uye kuti ndakaita zviratidzo zvangu sei pakati pavo, uye kuti imi mugoziva kuti ndini Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Saka Mozisi naAroni vakaenda kuna Faro vakandoti kwaari, “Zvanzi naJehovha: Mwari wavaHebheru, ‘Uchasvika riniko uchiramba kuzvininipisa pamberi pangu? Rega vanhu vangu vaende kuti vanondinamata. ");
INSERT INTO sna_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kana uchiramba kuvatendera kuenda, ini ndichauyisa mhashu munyika yako mangwana. ");
INSERT INTO sna_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Dzichafukidza nyika yose zvokuti pasi hapangaonekwi. Dzichadya zvishoma zvawakanga wasiyirwa shure kwechimvuramabwe, pamwe chete nemiti yose iri kumera muminda yako. ");
INSERT INTO sna_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Dzichazadza dzimba dzako nedzamachinda ako nedzavaIjipita vose, chinhu chisina kumboonekwa namadzibaba ako kana madzitateguru ako kubva pazuva ravakagara munyika ino kusvika zvino.’ ” Ipapo Mozisi akatendeuka akabva pana Faro. ");
INSERT INTO sna_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Machinda aFaro akati kwaari, “Munhu uyu acharamba ari musungo kwatiri kusvikira riniko? Regai vanhu vaende, kuti vagonamata Jehovha Mwari wavo. Ko, hamusi kuzviona here nazvino kuti Ijipiti yaparara?” ");
INSERT INTO sna_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ipapo Mozisi naAroni vakadzoswazve kuna Faro. Iye akati, “Endai mundonamata Jehovha Mwari wenyu. Asi vachaenda ndivanaaniko?” ");
INSERT INTO sna_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mozisi akapindura akati, “Tichaenda navaduku vedu uye navakuru, pamwe chete navanakomana vedu navanasikana vedu, uye namakwai edu nemombe dzedu, nokuti tinofanira kuita mutambo wokupemberera Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faro akati, “Jehovha ngaave nemi, kana ndikakutenderai kuenda, pamwe chete navakadzi navana venyu! Zviri pachena kuti imi muri kuda kuita zvakaipa. ");
INSERT INTO sna_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kwete! Varume chete ngavaende; vandonamata Jehovha, sezvo zviri izvo zvamanga muchikumbira.” Ipapo Mozisi naAroni vakadzingwa pamberi paFaro. ");
INSERT INTO sna_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Uye Jehovha akati kuna Mozisi, “Tambanudza ruoko rwako pamusoro peIjipiti kuitira kuti mhashu dzigoita bute pamusoro dzigodya zvose zvinomera muminda, zvose zvakasiyiwa nechimvuramabwe.” ");
INSERT INTO sna_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Saka Mozisi akatambanudza tsvimbo yake pamusoro peIjipiti, uye Jehovha akaita kuti mhepo yokumabvazuva ivhuvhute munyika zuva rose nousiku hwose. Mangwanani, mhepo yakanga yauyisa mhashu; ");
INSERT INTO sna_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","dzakazadza Ijipiti yose uye dzikamhara munzvimbo dzose dzenyika dzakawanda zvikuru. Hakuna kutongova nedambudziko remhashu rakadai, uye harichazombovapozve. ");
INSERT INTO sna_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Dzakafukidza pasi pose kusvikira pasviba kuti svi-i. Dzakadya zvose zvakanga zvasara shure kwechimvuramabwe, zvinhu zvose zvaimera muminda uye michero yaiva pamiti. Hakuna chakasvibirira chakasara mumiti kana zvirimwa zvomunyika yose yeIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faro akakurumidza kudana Mozisi naAroni akati, “Ndatadzira Jehovha Mwari wenyu uye nemi. ");
INSERT INTO sna_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Zvino ndiregerereizve chivi changu uye munyengetere kuna Jehovha Mwari wenyu kuti abvise kwandiri dambudziko rinouraya iri.” ");
INSERT INTO sna_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ipapo Mozisi akabva pana Faro akanyengetera kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Uye Jehovha akashandura mhepo ikava mhepo ine simba yokumavirira ikasimudza mhashu ikadzikanda muGungwa Dzvuku. Hapana mhashu yakasara papi zvapo muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Asi Jehovha akaomesa mwoyo waFaro, uye akasatendera vaIsraeri kuti vaende. ");
INSERT INTO sna_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ipapo Jehovha akati kuna Mozisi, “Tambanudzira ruoko rwako kudenga kuti rima ripararire pamusoro peIjipiti, rima rinonzwikwa.” ");
INSERT INTO sna_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Saka Mozisi akatambanudzira ruoko rwake kudenga, rima guru rikafukidza Ijipiti yose kwamazuva matatu. ");
INSERT INTO sna_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hapana aigona kuona mumwe munhu papi zvapo kana kubva panzvimbo yake kwamazuva matatu. Asi vaIsraeri vainge vane chiedza munzvimbo dzavaigara. ");
INSERT INTO sna_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ipapo Faro akadana Mozisi akati, “Endai mundonamata Jehovha. Kunyange vakadzi venyu navana vangaenda havo nemi; musiye chete makwai enyu nemombe.” ");
INSERT INTO sna_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Asi Mozisi akati, “Munofanira kutitendera kuti tive nezvibayiro uye nezvipiriso zvinopiswa kuti tipe kuna Jehovha Mwari wedu. ");
INSERT INTO sna_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Zvipfuwo zvedu zvinofanira kuendawo nesu; hapana hwanda rinofanira kusara. Tinofanira kuzvishandisa zvimwe zvacho mukunamata Jehovha Mwari wedu, uye kusvikira tasvikako hatingazivi zvatingashandisa kuti tinamate Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Asi Jehovha akaomesa mwoyo waFaro, saka haana kuda kuvatendera kuti vaende. ");
INSERT INTO sna_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faro akati kuna Mozisi, “Ibvai pano! Chenjerai kuti murege kuzoonekwazve pamberi pangu! Musi wamuchaona chiso changu muchafa.” ");
INSERT INTO sna_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mozisi akapindura akati, “Sezvamareva, handichazoonekwazve pamberi penyu.” ");
INSERT INTO sna_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Zvino Jehovha akanga ati kuna Mozisi, “Ndichauyisa rimwezve dambudziko pamusoro paFaro napamusoro peIjipiti. Shure kwaizvozvo, achakutenderai kubva muno, uye paanozviita, achakudzingirai kunze zvachose. ");
INSERT INTO sna_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Udza vanhu kuti varume navakadzi, pamwe chete, vakumbire vavakidzani vavo zvishongo zvesirivha nezvegoridhe.” ");
INSERT INTO sna_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Jehovha akaita kuti vanhu vawanirwe nyasha navaIjipita, uye Mozisi pachake akanga achikudzwa zvikuru muIjipiti namachinda aFaro uye navanhu. ");
INSERT INTO sna_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Saka Mozisi akati, “Zvanzi naJehovha: ‘Pakati pousiku ndichafamba napakati peIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mwanakomana wose wedangwe ari muIjipiti achafa, kubva pamwanakomana wedangwe waFaro, iye agere pachigaro choushe, kusvikira kumwanakomana wedangwe womurandakadzi, ari paguyo rake, namatangwe ose emombewo. ");
INSERT INTO sna_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Pachava nokuchema kukuru muIjipiti yose, kwakadaro hakuna kumbovapo uye hakungavepozve. ");
INSERT INTO sna_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Asi pakati pavaIsraeri hapana kana imbwa ichahukura munhu zvake kana chipfuwo.’ Ipapo uchaziva kuti Jehovha anoita mutsauko pakati peIjipiti neIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Machinda ako ose aya achauya kwandiri, vachipfugama pamberi pangu vachiti, ‘Chiendai, imi navanhu vose vanokuteverai!’ Shure kwaizvozvo ndichaenda.” Ipapo Mozisi, atsamwa kwazvo, akabva pana Faro. ");
INSERT INTO sna_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Jehovha akanga ati kuna Mozisi, “Faro acharamba kukuteerera, kuitira kuti zvishamiso zvangu zviwande muIjipiti.” ");
INSERT INTO sna_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mozisi naAroni vakaita zvishamiso zvose izvi pamberi paFaro, asi Jehovha akaomesa mwoyo waFaro uye haana kuda kutendera vaIsraeri kuti vabude munyika yake. ");
INSERT INTO sna_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Jehovha akati kuna Mozisi naAroni vari muIjipiti, ");
INSERT INTO sna_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwedzi uno unofanira kuva mwedzi wokutanga kwamuri, mwedzi wokutanga wegore renyu. ");
INSERT INTO sna_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Udzai ungano yose yeIsraeri kuti pazuva regumi romwedzi uno, murume mumwe nomumwe anofanira kutorera mhuri yake gwayana, rimwe chete paimba imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kana imba ipi zvayo iri duku kwazvo pagwayana rose, vanofanira kugovana rimwe chete nomuvakidzani ari pedyo zvichienderana nouwandu hwavanhu varipo. Munofanira kuona mugove unodikanwa maererano nezvingadyiwa nomunhu mumwe nomumwe. ");
INSERT INTO sna_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Zvipfuwo zvamunosarudza zvinofanira kuva mikono yegore rimwe chete isina chainopomerwa, uye munogona kuzvitora kubva kumakwai kana kumbudzi. ");
INSERT INTO sna_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Muzvichengete kusvikira pazuva regumi namana romwedzi, ipapo ungano yose yeIsraeri inofanira kuzviuraya panguva yamadekwana. ");
INSERT INTO sna_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ipapo vanofanira kutora rimwe ropa vagoriisa pamagwatidziro maviri egonhi napazvivivo zvedzimba dzavanodyira makwayana vari. ");
INSERT INTO sna_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Usiku ihwohwo vanofanira kudya nyama yakagochwa pamoto, pamwe chete nemiriwo inovava, nechingwa chisina mbiriso. ");
INSERT INTO sna_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Musadya nyama iri mbishi kana yakabikwa mumvura, asi mugoche pamoto, musoro, makumbo uye nezvomukati. ");
INSERT INTO sna_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Musasiya kana chimwe charo kusvikira mangwanani; kana zvimwe zvikasara kusvikira mangwanani, munofanira kuzvipisa. ");
INSERT INTO sna_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Aya ndiwo madyiro amunoriita: Majasi akasungwa nebhanhire, makapfeka shangu mutsoka dzenyu, uye tsvimbo dzenyu dziri mumaoko enyu. Muridye nokukurumidza; ndiyo Pasika yaJehovha. ");
INSERT INTO sna_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Nousiku ihwohwo ndichapfuura napakati peIjipiti ndigorova matangwe ose, zvose vanhu nezvipfuwo, uye ndichatonga vamwari vose veIjipiti. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ropa richava chiratidzo kwamuri mudzimba dzamunogara; uye ndikaona ropa, ndichapfuura pamuri. Hapana hosha inoparadza ichakubatai pandicharova Ijipiti. ");
INSERT INTO sna_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Iri ndiro zuva ramunofanira kurangarira; kuzvizvarwa zvinotevera mucharipemberera somutambo kuna Jehovha, mutemo wokusingaperi. ");
INSERT INTO sna_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kwamazuva manomwe, munofanira kudya chingwa chisina mbiriso. Pazuva rokutanga mubvise mbiriso mudzimba dzenyu, nokuti ani naani anodya chinhu chipi zvacho chine mbiriso mukati macho kubva pazuva rokutanga kusvikira pazuva rechinomwe anofanira kubviswa pakati pavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pazuva rokutanga muite ungano tsvene, uye mugoitazve imwe ungano pazuva rechinomwe. Musatomboshanda pamazuva iwayo, kunze bedzi kwokugadzira zvokudya zvokuti munhu wose adye, ndizvo chete zvamungaita. ");
INSERT INTO sna_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mupemberere Mutambo weZvingwa Zvisina Mbiriso, nokuti pazuva irori ndipo pandakabudisa mapoka enyu kubva muIjipiti. Mupemberere zuva irori uve mutemo wokusingaperi kuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mumwedzi wokutanga munofanira kudya chingwa chakabikwa chisina mbiriso, kubva pamadekwana ezuva regumi namana kusvikira madekwana ezuva ramakumi maviri nerimwe. ");
INSERT INTO sna_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kwamazuva manomwe, mbiriso ngairege kuwanikwa mudzimba dzenyu. Uye ani naani anodya chinhu chipi zvacho chine mbiriso anofanira kubviswa pakati peungano yaIsraeri, angava mutorwa kana akaberekerwa munyika imomo. ");
INSERT INTO sna_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Musadya chinhu chakabikwa nembiriso. Pose pamunogara, munofanira kudya chingwa chisina mbiriso.” ");
INSERT INTO sna_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ipapo Mozisi akadana vakuru vose veIsraeri akati kwavari, “Endai izvozvi mundosarudza zvipfuwo zvemhuri dzenyu mugouraya gwayana rePasika. ");
INSERT INTO sna_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mutore sumbu rehisopi, murinyike muropa riri mumudziyo uye mugoisa rimwe ropa nechapamusoro pechivivo uye napamativi maviri amagwatidziro egonhi. Parege kuva nomumwe wenyu anobuda pamukova weimba yake kusvikira mangwanani. ");
INSERT INTO sna_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Jehovha paanopinda napakati penyika kuti arove vaIjipita, achaona ropa pamusoro pechivivo nomumativi amagwatidziro egonhi uye achapfuura pamikova yenyu, uye haangatenderi muparadzi kuti apinde mudzimba dzenyu kuti akurovei. ");
INSERT INTO sna_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Muteerere mirayiro iyi ive mitemo kwamuri nokuzvizvarwa zvenyu nokusingaperi. ");
INSERT INTO sna_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pamunopinda munyika yamuchapiwa naJehovha sezvaakavimbisa, mucherechedze chirevo ichi. ");
INSERT INTO sna_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Uye pamuchabvunzwa navana venyu vachiti, ‘Zvinoreveiko izvi kwamuri?’ ");
INSERT INTO sna_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ipapo muvaudze kuti, ‘Ndicho chibayiro chePasika yaJehovha, uyo akapfuura napadzimba dzavaIsraeri muIjipiti akaponesa dzimba dzedu paakarova vaIjipita.’ ” Ipapo vanhu vakapfugama vakanamata. ");
INSERT INTO sna_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","VaIsraeri vakaita sezvakanga zvarayirwa naJehovha kuna Mozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pakati pousiku Jehovha akarova matangwe ose omuIjipiti, kubva padangwe raFaro, iye aizogara pachigaro choushe, kusvika kudangwe romusungwa, akanga ari mutorongo, nedangwe rezvipfuwo zvosewo. ");
INSERT INTO sna_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faro namachinda ake ose uye navaIjipita vose vakamuka usiku, uye kwakava nokuungudza kukuru muIjipiti, nokuti kwakanga kusina imba isina munhu akanga afa. ");
INSERT INTO sna_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Faro akadana Mozisi naAroni usiku akati, “Simukai, mubve pakati pavanhu vangu, imi navaIsraeri! Endai, mundonamata Jehovha sezvamakakumbira. ");
INSERT INTO sna_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mutore makwai enyu nemombe, sezvamakareva, mugoenda. Uyewo mundiropafadze.” ");
INSERT INTO sna_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","VaIjipita vakakurudzira vanhu kuti vakurumidze kubva munyika. Nokuti vakati, “Zvimwe tingafa tose!” ");
INSERT INTO sna_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Saka vanhu vakatora mukanyiwa wavo usati waiswa mbiriso, vakatakura pamapfudzi avo mumidziyo yokukanyira vakazviputira mumicheka. ");
INSERT INTO sna_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","VaIsraeri vakaita sezvavakarayirwa naMozisi vakakumbira zvishongo zvesirivha, negoridhe uye nezvokupfeka. ");
INSERT INTO sna_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Jehovha akapa vanhu nyasha pamberi pavaIjipita, uye vakavapa zvavakakumbira; saka vakapamba vaIjipita. ");
INSERT INTO sna_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","VaIsraeri vakafamba kubva paRamesesi kusvikira kuSukoti. Kwakanga kuna varume mazana matanhatu ezviuru vaifamba netsoka, pasingaverengwi vakadzi navana. ");
INSERT INTO sna_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Vamwe vanhu vazhinji vakaendawo navo, pamwe chete namapoka makuru ezvipfuwo, zvose makwai nemombe. ");
INSERT INTO sna_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Vakabika makeke ezvingwa zvisina mbiriso nomukanyiwa wavakabva nawo kuIjipiti. Mukanyiwa uyu wakanga usina mbiriso nokuti vakanga vadzingwa kubva muIjipiti uye havana kuwana nguva yokuti vazvigadzirire zvokudya. ");
INSERT INTO sna_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Zvino nguva yakagara vanhu veIsraeri muIjipiti yakanga iri makore mazana mana namakumi matatu. ");
INSERT INTO sna_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pakupera kwamakore mazana mana namakumi matatu, kusvikira pazuva racho iroro, ungano yose yavanhu vaJehovha yakabva muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Usiku uhwo hunofanira kurangarirwa Jehovha, nokuti akavabudisa muIjipiti nahwo. Ndihwo usiku hwaJehovha, hunofanira kurangarirwa kwazvo navana vaIsraeri vose namarudzi avo ose. ");
INSERT INTO sna_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jehovha akati kuna Mozisi naAroni, “Iyi ndiyo mitemo yePasika: “Mutorwa haafaniri kuidya. ");
INSERT INTO sna_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nhapwa ipi zvayo yawakatenga ingadya hayo mushure mokunge wamudzingisa, ");
INSERT INTO sna_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","asi mueni uye nomunhu anoshandira mari haafaniri kuidya. ");
INSERT INTO sna_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Inofanira kudyirwa muimba imwe chete; musabuda neimwe nyama kunze kwemba. Musavhuna kana bvupa. ");
INSERT INTO sna_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ungano yose yeIsraeri inofanira kuipemberera. ");
INSERT INTO sna_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Mutorwa wose agere pakati penyu anoda kupemberera Pasika yaJehovha anofanira kudzingisa varume vose vari mumba make; ipapo achadya hake somunhu akaberekerwa munyika imomo. Murume asina kudzingiswa haafaniri kuidya. ");
INSERT INTO sna_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Murayiro mumwe chete iwoyo unobata kuna vose vakaberekerwa munyika imomo nokumutorwa agere pakati penyu.” ");
INSERT INTO sna_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","VaIsraeri vose vakaita sezvakanga zvarayirwa naJehovha kuna Mozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Uye pazuva racho iroro Jehovha akabudisa vaIsraeri kubva muIjipiti namapoka avo. ");
INSERT INTO sna_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nditsaurire matangwe echirume ose. Chibereko chokutanga chechizvaro pakati pavaIsraeri ndechangu, chingava chomunhu kana chechipfuwo.” ");
INSERT INTO sna_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ipapo Mozisi akati kuvanhu, “Rangarirai zuva iri, iro zuva ramakabuda muIjipiti, munyika youtapwa, nokuti Jehovha akakubudisai mairi noruoko rune simba. Musadya chinhu chine mbiriso. ");
INSERT INTO sna_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Nhasi, mumwedzi waAbhibhi muri kubuda. ");
INSERT INTO sna_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Pamunosvitswa naJehovha munyika yavaKenani, vaHiti, vaAmori, vaHivhi, navaJebhusi, iyo nyika yaakapikira madzibaba enyu kuti vazokupai iyo, nyika inoyerera mukaka nouchi, munofanira kucherechedza chirevo ichi mumwedzi uno. ");
INSERT INTO sna_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwamazuva manomwe munofanira kuitira Jehovha mutambo. ");
INSERT INTO sna_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mudye chingwa chisina mbiriso pamazuva manomwe iwayo; chinhu chine mbiriso hachifaniri kuonekwa pakati penyu, uye mbiriso zvayo haifaniri kuonekwa panzvimbo ipi zvayo pakati pemiganhu yenyu. ");
INSERT INTO sna_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Pazuva iroro uudze mwanakomana wako kuti, ‘Ndinoita izvi nokuda kwezvandakaitirwa naJehovha pandakabuda muIjipiti.’ ");
INSERT INTO sna_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mucherechedzo uyu uchava kwauri sechiratidzo paruoko rwako uye sechirangaridzo pahuma yako chokuti murayiro waJehovha unofanira kuva pamiromo yako. Nokuti Jehovha akakubudisa muIjipiti noruoko rwake rune simba. ");
INSERT INTO sna_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Unofanira kuchengeta mutemo uyu panguva dzakatarwa gore negore. ");
INSERT INTO sna_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Shure kwokunge Jehovha akusvitsa munyika yavaKenani uye aipa kwauri, sezvaakavimbisa nemhiko kwauri nokumadzitateguru ako, ");
INSERT INTO sna_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","unofanira kupa kuna Jehovha chibereko chokutanga chezvizvaro zvose. Zvikono zvezvipfuwo zvako zvose zvinotanga kuzarura chibereko ndezvaJehovha. ");
INSERT INTO sna_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Udzikinure negwayana mwana wose wokutanga wembongoro, asi kana usingaudzikinuri, uvhune mutsipa wawo. Udzikinure matangwe ose pakati pavanakomana vako. ");
INSERT INTO sna_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Mumazuva anouya, paunenge uchibvunzwa nomwanakomana wako kuti, ‘Zvinoreveiko izvi?’ uti kwaari, ‘Noruoko rune simba Jehovha akatibudisa muIjipiti, munyika youtapwa. ");
INSERT INTO sna_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faro paakasindimara achiramba kuti tiende, Jehovha akauraya matangwe ose omuIjipiti, zvose vanhu nezvipfuwo. Ndokusaka ndichibayira kuna Jehovha mukono wokutanga wechibereko chechizvaro chose uye ndichidzikinura dangwe rimwe nerimwe ravanakomana vangu.’ ");
INSERT INTO sna_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Uye chichava chiratidzo paruoko rwako nerundanyara pahuma yako kuti Jehovha akatibudisa kubva muIjipiti noruoko rune simba.” ");
INSERT INTO sna_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faro akati atendera vanhu kuti vaende, Mwari haana kuvatungamirira nenzira yaipinda nomunyika yavaFiristia, kunyange zvazvo yakanga iri pfupi. Nokuti Mwari akati, “Kana vakasangana nehondo, vangashandura pfungwa dzavo vakadzokera kuIjipiti.” ");
INSERT INTO sna_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Saka Mwari akatungamirira vanhu vachipoterera nomumugwagwa womurenje vakananga kuGungwa Dzvuku. VaIsraeri vakabuda kubva muIjipiti vakapakata nhumbi dzehondo. ");
INSERT INTO sna_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mozisi akatora mapfupa aJosefa nokuti Josefa akanga aita kuti vanakomana vaIsraeri vapike mhiko. Akanga ati, “Zvirokwazvo Mwari achakubatsirai, uye ipapo munofanira kutakura mapfupa angu kubva panzvimbo ino.” ");
INSERT INTO sna_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Vakati vabva paSukoti vakadzika musasa paEtamu pamucheto werenje. ");
INSERT INTO sna_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Masikati Jehovha aivatungamirira neshongwe yegore kuti avatungamirire munzira yavo uye usiku aivatungamirira neshongwe yomoto kuti vavhenekerwe, kuti vafambe masikati kana usiku. ");
INSERT INTO sna_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Shongwe yegore masikati kana shongwe yemoto usiku hazvina kubva panzvimbo yazvo pamberi pavanhu. ");
INSERT INTO sna_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Taurira vaIsraeri kuti vadzoke vagondodzika musasa pedyo nePi Hahiroti, pakati peMigidhori negungwa. Vanofanira kudzika misasa pedyo nepagungwa, pakatarisana neBhaari Zefoni. ");
INSERT INTO sna_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faro achafunga kuti, ‘VaIsraeri vari kungodzungaira nenyika vakanganisika, vadzimira murenje.’ ");
INSERT INTO sna_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Uye ndichaomesa mwoyo waFaro, agovatevera. Asi ini ndichazviwanira kukudzwa kubudikidza naFaro nehondo yake yose, uye vaIjipita vachaziva kuti ndini Jehovha.” Saka vaIsraeri vakaita izvozvo. ");
INSERT INTO sna_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mambo weIjipiti akati audzwa kuti vanhu vatiza, Faro namachinda ake vakapindura pfungwa dzavo pamusoro pavo vakati, “Ko, taitei? Tarega vaIsraeri vachienda uye havachatishandiri!” ");
INSERT INTO sna_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Saka akaita kuti ngoro dzake dzigadzirwe uye akatora hondo yake akaenda nayo. ");
INSERT INTO sna_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Akatora ngoro dzakanakisisa dzaisvika mazana matanhatu, pamwe chete nedzimwe ngoro dzeIjipiti dzina vatariri vadzo dzose. ");
INSERT INTO sna_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jehovha akaomesa mwoyo waFaro mambo weIjipiti, kuti atevere vaIsraeri, avo vakanga vachifamba vakashinga kwazvo. ");
INSERT INTO sna_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","VaIjipita, mabhiza ose aFaro nengoro dzake, vatasvi vamabhiza namauto, vakatevera vaIsraeri vakavabata pavakanga vadzika musasa pagungwa pedyo nePi Hahiroti, pakatarisana neBhaari Zefoni. ");
INSERT INTO sna_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Faro paakanga osvika, vaIsraeri vakasimudza meso avo, uye vakaona vaIjipita vachifamba vachivatevera. Vakavhunduka uye vakachema kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Vakati kuna Mozisi, “Zvinoreva kuti muIjipiti makanga musina makuva here zvawatiuyisa kurenje kuti tife? Chiiko chawaita kwatiri zvawatibudisa muIjipiti? ");
INSERT INTO sna_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ko, tiri muIjipiti hatina kuti, ‘Tisiye takadaro; rega tishandire vaIjipita here’? Zvaiva nani kwatiri kuti tishandire vaIjipita pano kuti tifire murenje!” ");
INSERT INTO sna_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mozisi akapindura vanhu akati, “Musatya. Mirai nesimba uye muchaona kusunungura kwaJehovha kwaachakuitirai nhasi. VaIjipita vamunoona nhasi hamuchazovaonizve. ");
INSERT INTO sna_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jehovha achakurwirai; imi ingonyararai bedzi.” ");
INSERT INTO sna_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ipapo Jehovha akati kuna Mozisi, “Seiko uchidanidzira kwandiri? Taurira vaIsraeri kuti vapfuurire mberi. ");
INSERT INTO sna_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Simudza tsvimbo yako ugotambanudzira ruoko rwako pamusoro pegungwa kuti mvura iparadzane kuitira kuti vaIsraeri vapinde mugungwa napavhu rakaoma. ");
INSERT INTO sna_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ndichaomesa mwoyo yavaIjipita zvokuti vachapinda vachivatevera. Uye ndichawana kukudzwa kubudikidza naFaro nehondo yake yose, nengoro dzake uye navatasvi vake vamabhiza. ");
INSERT INTO sna_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","VaIjipita vachaziva kuti ndini Jehovha pandichawana kukudzwa kubudikidza naFaro, ngoro dzake navatasvi vake vamabhiza.” ");
INSERT INTO sna_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ipapo mutumwa waMwari, uyo akanga achifamba ari mberi kwehondo yavaIsraeri, akadzokera shure kwavo. Shongwe yegore yakabvawo mberi kwavo ikandomira shure kwavo, ");
INSERT INTO sna_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","iri pakati pehondo dzeIjipiti nedzeIsraeri. Usiku hwose gore rakauyisa rima kuno rumwe rutivi uye chiedza kuno rumwe rutivi; saka hakuna akaswedera kuno mumwe usiku hwose. ");
INSERT INTO sna_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ipapo Mozisi akatambanudzira ruoko rwake pamusoro pegungwa, uye usiku hwose ihwohwo Jehovha akasunda gungwa nemhepo ine simba yokumabvazuva rikashanduka pakava nenyika yakaoma. Mvura yakakamurana, ");
INSERT INTO sna_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","uye vaIsraeri vakapinda nomugungwa napavhu rakaoma uye madziro emvura ari kuruoko rworudyi nokuruboshwe kwavo. ");
INSERT INTO sna_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","VaIjipita vakavatevera, uye mabhiza ose aFaro nengoro dzake navatasvi vamabhiza vakatevera mugungwa. ");
INSERT INTO sna_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Panguva yamangwanani Jehovha akatarira pasi nomushongwe yomoto uye nomugore raiva kurutivi rwehondo yavaIjipita, akainyonganisa. ");
INSERT INTO sna_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Akaita kuti mavhiri engoro dzavo abve zvokuti zvakanga zvaoma kudzifambisa. Uye vaIjipita vakati, “Ngatitizei kubva kuvaIsraeri. Jehovha ari kuvarwira achirwa navaIjipita.” ");
INSERT INTO sna_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ipapo Jehovha akati kuna Mozisi, “Tambanudzira ruoko rwako pamusoro pegungwa kuitira kuti mvura iyerere napamusoro pavaIjipita napamusoro pengoro dzavo napamusoro pavatasvi vavo vamabhiza.” ");
INSERT INTO sna_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mozisi akatambanudzira ruoko rwake pamusoro pegungwa, uye kwaedza, gungwa rakadzokera panzvimbo yaro. VaIjipita vakanga vachitizira kwariri, uye Jehovha akavakukurira mugungwa. ");
INSERT INTO sna_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mvura yakadzokera pakare ikafukidza ngoro navatasvi vamabhiza, hondo yose yaFaro yakanga yatevera vaIsraeri ikanyura mugungwa. Hapana kana mumwe wavo akararama. ");
INSERT INTO sna_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Asi vaIsraeri vakapinda nomugungwa napavhu rakaoma uye madziro emvura ari kuruoko rwavo rworudyi nokuruboshwe. ");
INSERT INTO sna_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zuva iroro Jehovha akaponesa vaIsraeri kubva mumaoko avaIjipita, uye vaIsraeri vakaona vaIjipita vakanga vafa pamahombekombe. ");
INSERT INTO sna_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Uye vaIsraeri pavakaona simba guru raJehovha richiratidzwa pamusoro pavaIjipita, vanhu vakatya Jehovha uye vakatenda kwaari naMozisi muranda wake. ");
INSERT INTO sna_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ipapo Mozisi navaIsraeri vakaimba rwiyo urwu kuna Jehovha: “Ndichaimbira Jehovha, nokuti iye anokudzwa zvikurukuru. Bhiza nomutasvi waro akazvikanda mugungwa. ");
INSERT INTO sna_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Jehovha ndiye simba rangu norwiyo rwangu; iye ava ruponeso rwangu. Ndiye Mwari wangu, uye ndichamurumbidza, Mwari wababa vangu, uye ndichamukudza. ");
INSERT INTO sna_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jehovha imhare; Jehovha ndiro zita rake. ");
INSERT INTO sna_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ngoro dzaFaro nehondo yake akazvikanda mugungwa. Machinda aFaro akanakisisa akanyudzwa muGungwa Dzvuku. ");
INSERT INTO sna_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mvura yakadzika yakavafukidza; vakanyura kwakadzika sedombo. ");
INSERT INTO sna_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Ruoko rwenyu rworudyi, imi Jehovha, rwakakudzwa nesimba. Ruoko rwenyu rworudyi, imi Jehovha, rwakaparadza muvengi. ");
INSERT INTO sna_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Muukuru hwoumambo hwenyu makakanda pasi vaya vaikupikisai. Makasunungura kutsamwa kwenyu kunopisa, kukavapisa sehundi. ");
INSERT INTO sna_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nokufema kwemhino dzenyu mvura zhinji yakaita murwi. Mvura yamasaisai yakamira yakasimba semadziro; mvura yakadzika yakaungana mukati megungwa. ");
INSERT INTO sna_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Muvengi akazvikudza achiti, ‘Ndichavatevera, ndichavabata. Ndichagova zvakapambwa; ndichazvimbirwa navo. Ndichavhomora munondo wangu uye ruoko rwangu ruchavaparadza.’ ");
INSERT INTO sna_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Asi makafuridza nokufema kwenyu, gungwa rikavafukidza. Vakanyura somutobvu mukati memvura ine simba. ");
INSERT INTO sna_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Ndianiko pakati pavamwari akaita semi, imi Jehovha? Ndiani akaita semi, paumambo noutsvene, mukubwinya kunotyisa, anoita zvishamiso? ");
INSERT INTO sna_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Makatambanudza ruoko rwenyu rworudyi, nyika ikavamedza. ");
INSERT INTO sna_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Murudo rwenyu rusingaperi muchatungamirira vanhu vamakadzikinura. Musimba renyu imi muchavatungamirira kuugaro hwenyu hutsvene. ");
INSERT INTO sna_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ndudzi dzichazvinzwa uye dzichadedera; kurwadziwa kuchabata vanhu vokuFiristia. ");
INSERT INTO sna_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Madzishe eEdhomu achavhundutswa, vatungamiri veMoabhu vachabatwa nokudedera, vanhu veKenani vachanyunguduka; ");
INSERT INTO sna_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","kutya nokuvhunduka zvichavawira. Nesimba roruoko rwenyu vachanyarara kunge dombo, kusvikira vanhu venyu vapfuura, imi Jehovha, kusvikira vanhu vamakatenga vapfuura. ");
INSERT INTO sna_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Muchaenda navomo uye mugovasima pagomo renhaka yenyu, nzvimbo tsvene yakasimbiswa namaoko enyu, imi Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Jehovha achatonga nokusingaperi-peri.” ");
INSERT INTO sna_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mabhiza aFaro, ngoro navatasvi vamabhiza vakapinda mugungwa, Jehovha akauyisa mvura yomugungwa pamusoro pavo, asi vaIsraeri vakafamba napakati pegungwa pavhu rakaoma. ");
INSERT INTO sna_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ipapo Miriamu muprofitakadzi, hanzvadzi yaAroni, akatora tambureni muruoko rwake, uye vakadzi vose vakamutevera, vana matambureni uye vachitamba. ");
INSERT INTO sna_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu akavaimbira akati: “Imbirai Jehovha, nokuti anokudzwa zvikuru kuru. Bhiza nomutasvi waro akazvikanda mugungwa.” ");
INSERT INTO sna_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ipapo Mozisi akatungamirira vaIsraeri kubva paGungwa Dzvuku uye vakapinda murenje reShuri. Vakafamba kwamazuva matatu murenje vachishayiwa mvura. ");
INSERT INTO sna_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Vakati vasvika paMara, havana kugona kunwa mvura yacho nokuti yaivava. (Ndokusaka nzvimbo yacho ichinzi Mara.) ");
INSERT INTO sna_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Saka vanhu vakapopotera Mozisi vachiti, “Tonweiko?” ");
INSERT INTO sna_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ipapo Mozisi akachema kuna Jehovha, Jehovha akamuratidza chimuti. Akachikanda mumvura, mvura ikanaka. Jehovha akavaitirapo mutemo nomurayiro, uye akavaedza ipapo. ");
INSERT INTO sna_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Akati, “Kana mukanyatsoteerera inzwi raJehovha Mwari wenyu uye mukaita zvakarurama pamberi pake, kana mukarerekera nzeve dzenyu kumirayiro yake uye mukachengeta mitemo yose, haangauyisi pamusoro penyu zvirwere zvose zvandakauyisa pamusoro pavaIjipita, nokuti ndini Jehovha anokuporesai.” ");
INSERT INTO sna_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ipapo vakasvika paErimu, paiva namatsime gumi namaviri uye nemiti yemichindwe makumi manomwe, uye vakadzika misasa ipapo pedyo nemvura. ");
INSERT INTO sna_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ungano yose yavaIsraeri yakasimuka kubva paErimu vakasvika kuRenje reSini, riri pakati peErimu neSinai, pazuva regumi namashanu romwedzi wechipiri shure kwokubuda kwavo muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Murenje imomo ungano yose yavaIsraeri yakapopotera Mozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","VaIsraeri vakati kwavari, “Dai takafa zvedu noruoko rwaJehovha tiri muIjipiti! Uko kwataikomba makate enyama uye tichidya zvokudya zvose zvataida, asi makatibudisa kurenje kuno kuti ungano ino yose iziye nenzara kusvikira pakufa.” ");
INSERT INTO sna_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ipapo Jehovha akati kuna Mozisi, “Ndichakunayisirai chingwa chichabva kudenga. Vanhu vanofanira kubuda zuva rimwe nerimwe vagounganidza zvinoringana nezuva iroro. Nenzira iyoyi ndichavaedza ndigoona kana vachitevera zvandinovarayira. ");
INSERT INTO sna_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pazuva rechitanhatu vanofanira kugadzira zvavanouya nazvo, uye zvinofanira kuva zviyero zviviri kupfuura zvavanosiunganidza pane mamwe mazuva.” ");
INSERT INTO sna_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Saka Mozisi naAroni vakati kuvaIsraeri vose, “Madekwana muchaziva kuti akanga ari Jehovha akakubudisai kubva muIjipiti, ");
INSERT INTO sna_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","uye mangwanani muchaona kubwinya kwaJehovha, nokuti akanzwa kugununʼuna kwenyu pamusoro pake. Tisu vanaaniko, zvamunotipopotera?” ");
INSERT INTO sna_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mozisi akatiwo, “Muchaziva kuti akanga ari Jehovha paachakupai nyama kuti mudye madekwana uye zvokudya zvose zvamunoda mangwanani nokuti akanzwa kugununʼuna kwenyu pamusoro pake. Tisu vanaaniko? Hamusi kupopotera isu, asi Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ipapo Mozisi akati kuna Aroni, “Udza ungano yose yaIsraeri kuti, ‘Uyai pamberi paJehovha, nokuti anzwa kupopota kwenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aroni achiri kutaura neungano yose yavaIsraeri vakatarisa kurenje vakaona kubwinya kwaJehovha kuchiratidzwa mugore. ");
INSERT INTO sna_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ndanzwa kupopota kwavaIsraeri. Vaudze kuti, ‘Panguva yorubvunzavaeni muchadya nyama, uye mangwanani muchaguta nechingwa. Ipapo muchaziva kuti ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Madekwana iwayo zvihuta zvakauya zvikafukidza musasa, uye mangwanani pakanga pane dova rakapoteredza musasa. ");
INSERT INTO sna_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Dova rakati rapera, mahwendefa matete akanga akaita samazaya echando akaonekwa pasi murenje. ");
INSERT INTO sna_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","VaIsraeri vakati vazviona, vakati kuno mumwe nomumwe wavo, “Chiiko ichi?” Nokuti vakanga vasingazivi kuti chaiva chii. Mozisi akati kwavari, “Ndicho chingwa chamapiwa naJehovha kuti mudye. ");
INSERT INTO sna_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Izvi ndizvo zvakarayirwa naJehovha achiti, ‘Mumwe nomumwe anofanira kuunganidza zvinomukwanira. Utorere munhu mumwe nomumwe waunaye mutende rako omeri rimwe chete.’ ” ");
INSERT INTO sna_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","VaIsraeri vakaita sezvavakaudzwa; vamwe vakaunganidza zvakawanda, vamwe zvishoma. ");
INSERT INTO sna_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Uye pavakayera neomeri, uya akaunganidza zvizhinji haana kusara nezvakawanda, uye uya akaunganidza zvishoma haana kusara nezvishoma. Mumwe nomumwe akaunganidza zvaimukwanira. ");
INSERT INTO sna_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ipapo Mozisi akati kwavari, “Hakuna munhu anofanira kusara nezvimwe kusvikira mangwanani.” ");
INSERT INTO sna_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kunyange zvakadaro, vamwe vavo havana kuteerera kuna Mozisi, vakachengeta zvimwe zvacho kusvikira mangwanani, asi zvakanga zvazara nehonye uye zvatanga kunhuhwa. Saka Mozisi akavatsamwira. ");
INSERT INTO sna_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mangwanani oga oga munhu mumwe nomumwe akaunganidza zvaimukwanira, uye zuva parakanga ropisa, zvakanyungudika. ");
INSERT INTO sna_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pazuva rechitanhatu, vakaunganidza zviyero zviviri, maomeri maviri pamunhu mumwe nomumwe, uye vatungamiri veungano vakauya vakazivisa izvi kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Iye akati kwavari, “Izvi ndizvo zvakarayirwa naJehovha: ‘Mangwana izuva rokuzorora, Sabata dzvene kuna Jehovha. Saka bikai zvamunofanira kubika uye muvidze zvamunofanira kuvidza. Chengetai zvose zvinenge zvasara, mugozvichengeta kusvikira mangwanani.’ ” ");
INSERT INTO sna_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Saka vakazvichengeta kusvikira mangwanani, sezvavakarayirwa naMozisi, uye hazvina kunhuhwa kana kuva namakonye mazviri. ");
INSERT INTO sna_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mozisi akati, “Muzvidye iye nhasi, nokuti nhasi iSabata kuna Jehovha. Hamuzombowani chimwe chazvo pasi iye nhasi. ");
INSERT INTO sna_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Muzviunganidze kwamazuva matanhatu, asi pazuva rechinomwe, iSabata, hakuzombovi nechinhu.” ");
INSERT INTO sna_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kunyange zvakadaro hazvo, vamwe vanhu vakabuda kundounganidza nezuva rechinomwe, asi havana chavakawana. ");
INSERT INTO sna_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ipapo Jehovha akati kuna Mozisi, “Muchasvika riniko muchiramba kuchengeta mirayiro yangu nezvandakakurayirai? ");
INSERT INTO sna_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Rangarirai kuti Jehovha akakupai Sabata; ndokusaka pazuva rechitanhatu achikupai chingwa chamazuva maviri. Munhu mumwe nomumwe anofanira kuramba agere paari ipapo pazuva rechinomwe; hakuna anobuda kunze.” ");
INSERT INTO sna_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Saka vanhu vakazorora pazuva rechinomwe. ");
INSERT INTO sna_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Vanhu veIsraeri vakatumidza chingwa icho kuti mana. Chakanga chakachena semhodzi yekorianda uye chainaka sechingwa chine uchi. ");
INSERT INTO sna_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mozisi akati, “Izvi ndizvo zvakarayirwa naJehovha, ‘Mutore omeri yemana mugoichengetera zvizvarwa zvinotevera, kuti vagoona chingwa chandakakupai kuti mudye muri murenje pandakakubudisai kubva munyika yeIjipiti.’ ” ");
INSERT INTO sna_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Saka Mozisi akati kuna Aroni, “Tora mudziyo ugoisa omeri yemana imomo. Ipapo ugozviisa pamberi paJehovha kuti zvichengeterwe zvizvarwa zvinotevera.” ");
INSERT INTO sna_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sokurayira kwaJehovha kuna Mozisi, Aroni akaisa mana pamberi peChipupuriro, kuti ichengetwepo. ");
INSERT INTO sna_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","VaIsraeri vakadya mana kwamakore makumi mana, kusvikira vasvika kunyika yaiva navanhu; vakadya mana kusvikira vasvika pamuganhu weKenani. ");
INSERT INTO sna_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Omeri ndiro chegumi cheefa.) ");
INSERT INTO sna_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ungano yose yavaIsraeri yakasimuka kubva paRenje reSini, vachifamba nzvimbo nenzvimbo sokurayira kwaJehovha. Vakadzika musasa paRefidhimu, asi pakanga pasina mvura yokuti vanhu vanwe. ");
INSERT INTO sna_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Saka vanhu vakakakavadzana naMozisi uye vakati, “Tipe mvura tinwe.” Mozisi akapindura akati, “Seiko muchikakavadzana neni? Seiko muchiedza Jehovha?” ");
INSERT INTO sna_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Asi vanhu vakanga vane nyota yemvura ipapo, saka vakapopotedzana naMozisi. Vakati, “Seiko wakatibudisa muIjipiti kuti isu navana vedu nezvipfuwo zvedu tife nenyota?” ");
INSERT INTO sna_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ipapo Mozisi akachema kuna Jehovha akati, “Ndoiteiko navanhu ava? Votoda kunditaka namabwe.” ");
INSERT INTO sna_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Jehovha akapindura Mozisi akati, “Famba pamberi pavanhu. Tora vamwe vavakuru vavaIsraeri uye ubate muruoko rwako tsvimbo yawakarova nayo mvura yeNairi, ugoenda. ");
INSERT INTO sna_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ndichamira ipapo pamberi pako padombo riri paHorebhi. Urove dombo, uye mvura ichabuda pariri, kuti vanhu vanwe.” Saka Mozisi akaita izvi pamberi pavakuru vavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Uye akatumidza nzvimbo iyi kuti Masa neMeribha nokuti vaIsraeri vakakavadzana naye uye nokuti vakaedza Jehovha vachiti, “Ko, Jehovha ari pakati pedu here kana kuti kwete?” ");
INSERT INTO sna_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","VaAmareki vakauya vakarwa navaIsraeri paRefidhimu. ");
INSERT INTO sna_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mozisi akati kuna Joshua, “Sarudza vamwe varume vokwedu ugobuda kundorwa navaAmareki. Mangwana ndichandomira pamusoro pechikomo ndine tsvimbo yaMwari mumaoko angu.” ");
INSERT INTO sna_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Saka Joshua akarwa navaAmareki sokurayirwa kwaakaitwa naMozisi, uye Mozisi, Aroni naHuri vakakwira pamusoro pechikomo. ");
INSERT INTO sna_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mozisi paainge akasimudza maoko ake, vaIsraeri vaikunda, asi paaingoderedza maoko ake, vaAmareki vaikunda. ");
INSERT INTO sna_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Maoko aMozisi akati aneta, vakatora dombo ndokuriisa pasi pake iye akagara pamusoro paro. Aroni naHuri vakabata maoko ake vakamutsigira, mumwe kuno rumwe rutivi, mumwe kuno rumwe rutivi, kuitira kuti maoko ake arambe akatsiga kusvikira madekwana. ");
INSERT INTO sna_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Saka Joshua akakunda hondo yavaAmareki nomunondo. ");
INSERT INTO sna_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ipapo Jehovha akati kuna Mozisi, “Nyora izvi mubhuku chive chinhu chicharangarirwa uye uve nechokwadi kuti Joshua azvinzwa, nokuti ndichabvisa chirangaridzo chose cheAmareki pasi pedenga.” ");
INSERT INTO sna_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mozisi akavaka aritari akaitumidza kuti “Jehovha ndiye Mureza wangu.” ");
INSERT INTO sna_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Akati, “Nokuti maoko akasimudzirwa kumusoro kuchigaro choushe chaJehovha. Jehovha acharwa neAmareki kubva kune chimwe chizvarwa kusvikira kune nechimwe chizvarwa.” ");
INSERT INTO sna_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Zvino Jeturo, muprista weMidhiani uye ari tezvara waMozisi, akanzwa zvinhu zvose zvakaitirwa Mozisi naMwari uye nokuvanhu vake vaIsraeri, uye kuti Jehovha akanga abudisa vaIsraeri sei kubva muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Shure kwokunge Mozisi adzosera Zipora mukadzi wake, tezvara wake Jeturo akagamuchira Zipora ");
INSERT INTO sna_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","navanakomana vake vaviri. Mumwe mwanakomana akatumidzwa kunzi Gerishomi nokuti akati, “Ndava mutorwa munyika yavamwe;” ");
INSERT INTO sna_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","uye mumwe akatumidzwa kunzi Eriezeri, nokuti akati, “Mwari wababa vangu akanga ari mubatsiri wangu; akandiponesa kubva pamunondo waFaro.” ");
INSERT INTO sna_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jeturo, tezvara waMozisi, pamwe chete navanakomana vaMozisi nomukadzi wake, vakauya kwaari kurenje, kwaakanga akadzika musasa pedyo negomo raMwari. ");
INSERT INTO sna_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jeturo akanga atumira shoko kwaari achiti, “Ini, tezvara wako Jeturo, ndiri kuuya kwauri nomukadzi wako navanakomana vako vaviri.” ");
INSERT INTO sna_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Saka Mozisi akabuda kundochingamidza tezvara vake uye akakotama pasi akamutsvoda. Vakakwazisana ndokubva vapinda mutende. ");
INSERT INTO sna_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mozisi akataurira tezvara wake zvinhu zvose zvakaitwa naJehovha kuna Faro nokuvaIjipita nokuda kwavaIsraeri, uyewo nokutambudzika kwavakasangana nako munzira, uye kuti Jehovha akavaponesa sei. ");
INSERT INTO sna_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jeturo akafara kunzwa nezvezvinhu zvose zvakanaka zvakaitirwa vaIsraeri naJehovha, mukuvanunura kubva muruoko rwavaIjipita. ");
INSERT INTO sna_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Akati, “Jehovha ngaarumbidzwe, iye akakununura kubva muruoko rwavaIjipita norwaFaro, uye iye akanunura vanhu kubva muruoko rwavaIjipita. ");
INSERT INTO sna_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Zvino ndava kuziva kuti Jehovha mukuru kupfuura vamwe vamwari vose, nokuti akaita izvi kuna avo vakabata vaIsraeri nokuzvikudza.” ");
INSERT INTO sna_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ipapo Jeturo, tezvara waMozisi, akauya nechipiriso chinopiswa nezvimwewo zvibayiro kuna Mwari, uye Aroni akauya navakuru vose veIsraeri kuti vazodya chingwa pamwe chete natezvara waMozisi pamberi paMwari. ");
INSERT INTO sna_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Fume mangwana, Mozisi akagara pachigaro chake kuti ashande somutongi wavanhu, uye ivo vakamira vakamupoteredza kubva mangwanani kusvikira madekwana. ");
INSERT INTO sna_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tezvara wake akati aona zvose zvakanga zvichiitwa naMozisi kuvanhu, akati, “Chiiko ichi chauri kuitira vanhu? Seiko iwe uchitonga uri woga, asi vanhu vose ava vamire vakakupoteredza kubva mangwanani kusvikira madekwana?” ");
INSERT INTO sna_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mozisi akamupindura akati, “Nokuti vanhu vanouya kwandiri kuzotsvaka kuda kwaMwari. ");
INSERT INTO sna_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pose pavanouya negakava vanouya kwandiri, uye ini ndotonga pakati pavo uye ndovazivisa mitemo nemirayiro yaMwari.” ");
INSERT INTO sna_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tezvara waMozisi akapindura akati, “Zvauri kuita hazvina kunaka. ");
INSERT INTO sna_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Iwe navanhu ava vanouya kwauri muchangozvinetesa chete. Basa iri rinorema kwazvo kwauri; haungagoni kuriita uri woga. ");
INSERT INTO sna_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nditeerere iye zvino ndigokupa zano, uye Mwari ngaave newe. Unofanira kuva mumiririri wavanhu pamberi paMwari uye ugouyisa magakava avo kwaari. ");
INSERT INTO sna_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Uvadzidzise mitemo nemirayiro, ugovaratidza nzira yokurarama namabasa avanofanira kuita. ");
INSERT INTO sna_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Asi sarudza varume vanokwanisa kubva pakati pavanhu vose, varume vanotya Mwari, varume vakatendeka vanovenga fufuro, ugovagadza samachinda pamusoro pezviuru, pamusoro pamazana, pamusoro pamakumi mashanu napamusoro pegumi. ");
INSERT INTO sna_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Uvaite kuti vashande savatongi vavanhu panguva dzose, asi uvaite kuti vauye kwauri nenyaya dzose dzakaoma; nyaya dzakareruka ngavatonge ivo pachavo. Izvozvo zvicharerutsa mutoro wako, nokuti vanenge vachigovana newe. ");
INSERT INTO sna_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kana uchiita izvi uye Mwari achikurayira, uchagona kutakura mutoro uyu, uye vanhu vose ava vachaenda kudzimba vagutsikana.” ");
INSERT INTO sna_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mozisi akateerera tezvara wake akaita zvinhu zvose zvaakareva. ");
INSERT INTO sna_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Akasarudza varume vaikwanisa kubva pakati pavaIsraeri vose akavaita vatungamiriri vavanhu, akavaita vabati vezviuru, vabati vamazana, vabati vamakumi mashanu, navabati vegumi. ");
INSERT INTO sna_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Vakashanda savatongi vavanhu nguva dzose. Mhaka dzakaoma ndidzo dzavakauya nadzo kuna Mozisi, asi dzakareruka ndivo vaitonga ivo pachavo. ");
INSERT INTO sna_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ipapo Mozisi akatendera tezvara vake kuti vaende havo, uye Jeturo akadzokera kunyika yake. ");
INSERT INTO sna_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mumwedzi wechitatu shure kwokunge vaIsraeri vabva kuIjipiti, pazuva racho iroro, vakasvika kuRenje reSinai. ");
INSERT INTO sna_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Shure kwokusimuka kwavo kubva paRefidhimu, vakapinda muRenje reSinai, uye vaIsraeri vakadzika misasa imomo murenje pamberi pegomo. ");
INSERT INTO sna_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ipapo Mozisi akakwira kuna Mwari, uye Jehovha akadana kwaari ari mugomo akati, “Izvi ndizvo zvaunofanira kutaura kuimba yaJakobho uye zvaunofanira kuudza vanhu veIsraeri: ");
INSERT INTO sna_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Iwe pachako wakaona zvandakaita kuIjipiti, uye kuti ndakakutakurai sei pamapapiro egondo ndikakusvitsai kwandiri. ");
INSERT INTO sna_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Zvino kana muchinditeerera nomwoyo wose uye mukachengeta sungano yangu, ipapo muchava pfuma yangu chaiyo pakati pendudzi dzose. Kunyange hazvo nyika yose iri yangu, ");
INSERT INTO sna_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","muchava kwandiri umambo hwavaprista uye rudzi rutsvene.’ Aya ndiwo mashoko aunofanira kutaura kuvaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Saka Mozisi akadzokera akadana vakuru vavanhu akaisa pamberi pavo mashoko ose aakanga arayirwa naJehovha kuti ataure. ");
INSERT INTO sna_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Vanhu vose vakapindura pamwe chete vachiti, “Tichaita zvose zvakarehwa naJehovha.” Saka Mozisi akadzosera mhinduro yavo kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Jehovha akati kuna Mozisi, “Ndiri kuzouya kwauri ndiri mugore gobvu, kuitira kuti vanhu vagondinzwa ndichitaura newe vagoramba vachivimba newe.” Ipapo Mozisi akaudza Jehovha zvakanga zvarehwa navanhu. ");
INSERT INTO sna_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Uye Jehovha akati kuna Mozisi, “Enda kuvanhu undovanatsa nhasi namangwana. Uite kuti vawache nguo dzavo ");
INSERT INTO sna_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","uye vange vagadzirira nezuva rechitatu, nokuti pazuva iroro Jehovha achaburuka paGomo reSinai pamberi pavanhu vose. ");
INSERT INTO sna_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Uisire vanhu miganhu yakapoteredza gomo ugovaudza kuti, ‘Chenjerai kuti murege kukwira mugomo kana kubata mujinga maro. Ani naani achabata gomo achaurayiwa, zvirokwazvo. ");
INSERT INTO sna_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Zvirokwazvo achatakwa namabwe kana kubayiwa nemiseve; hakuna ruoko ruchamubata. Angava munhu kana chipfuwo, haangatenderwi kurarama.’ Vangakwira havo kugomo kana bedzi hwamanda yorunyanga rwegondobwe yaramba ichirira.” ");
INSERT INTO sna_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Shure kwokuburuka kwaMozisi mugomo achienda kuvanhu, akavanatsa, uye ivo vakashambidza nguo dzavo. ");
INSERT INTO sna_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ipapo akati kuvanhu, “Zvigadzirirei nezvezuva rechitatu. Murege kurara navakadzi venyu.” ");
INSERT INTO sna_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Panguva yamangwanani yezuva rechitatu pakava nokutinhira uye nemheni, negore gobvu rakafukidza gomo, uye kurira kukuru kwehwamanda. Munhu wose aiva mumisasa akadedera. ");
INSERT INTO sna_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ipapo Mozisi akatungamirira vanhu vachibuda mumisasa kuti vandosangana naMwari, uye vakandomira mujinga megomo. ");
INSERT INTO sna_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Gomo reSinai rakanga rakafukidzwa noutsi, nokuti Jehovha akanga aburukira pamusoro paro ari mumoto. Utsi hwakapfungaira huchikwira kumusoro soutsi hwakanga huchibva pavira romoto, gomo rose rakazungunuka nesimba guru, ");
INSERT INTO sna_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","uye inzwi rehwamanda rakanyanya kurira nokurira kukuru. Ipapo Mozisi akataura uye inzwi raMwari rikamupindura. ");
INSERT INTO sna_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Jehovha akaburukira pamusoro peGomo reSinai uye akadana Mozisi kuti auye pamusoro pegomo. Saka Mozisi akakwirako ");
INSERT INTO sna_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","uye Jehovha akati kwaari, “Buruka unoyambira vanhu kuti varege kumanikidzira kupinda kuti vandoona Jehovha vazhinji vavo vakazofa. ");
INSERT INTO sna_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kunyange vaprista, vanoswedera kuna Jehovha, vanofanira kuzvinatsa, kuti Jehovha arege kuvaparadza.” ");
INSERT INTO sna_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mozisi akati kuna Jehovha, “Vanhu havangakwiri muGomo reSinai, nokuti imi pachenyu makatiyambira mukati, ‘Isai miganhu yakapoteredza gomo uye muritsaure kuti rive dzvene.’ ” ");
INSERT INTO sna_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Jehovha akapindura akati, “Buruka undotora Aroni ukwire naye kuno. Asi vaprista navanhu havafaniri kumanikidzira kusvika kuno kuna Jehovha, nokuti angavaparadza.” ");
INSERT INTO sna_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Saka Mozisi akaburuka akaenda kuvanhu akandovaudza. ");
INSERT INTO sna_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Uye Mwari akataura mashoko aya ose akati: ");
INSERT INTO sna_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ndini Jehovha Mwari wako, akakubudisa kubva muIjipiti, munyika youranda. ");
INSERT INTO sna_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Usava navamwe vamwari kunze kwangu. ");
INSERT INTO sna_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Usazviitira mufananidzo wechinhu chipi zvacho chiri kudenga kumusoro kana wechiri panyika pasi kana wechiri mumvura. ");
INSERT INTO sna_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Usazvipfugamira kana kuzvinamata, nokuti ini Jehovha Mwari wako, ndiri Mwari ane godo, ndinoranga vana nokuda kwechivi chamadzibaba kusvikira kuchizvarwa chechitatu nechechina cheavo vanondivenga, ");
INSERT INTO sna_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","asi ndicharatidza rudo kuzvizvarwa zvine chiuru, avo vanondida uye vanochengeta mirayiro yangu. ");
INSERT INTO sna_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Usareva zita raJehovha Mwari wako pasina nokuti Jehovha haazoregi kupa mhosva munhu upi zvake anoreva zita rake pasina. ");
INSERT INTO sna_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Rangarira zuva reSabata kuti urichengete riri dzvene. ");
INSERT INTO sna_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Uchashanda mazuva matanhatu nokuita basa rako rose, ");
INSERT INTO sna_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","asi zuva rechinomwe iSabata kuna Jehovha Mwari wako. Pazuva iroro hamufaniri kuita basa ripi zvaro, iwe kana mwanakomana wako, kana mwanasikana wako, murandarume wako kana murandakadzi wako, uye zvipfuwo zvako kana mutorwa ari mukati mamasuo ako. ");
INSERT INTO sna_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nokuti mumazuva matanhatu Jehovha akaita matenga nenyika, gungwa, nezvose zviri mariri, asi akazorora nomusi wechinomwe. Naizvozvo Jehovha akaropafadza zuva reSabata akariita dzvene. ");
INSERT INTO sna_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Kudza baba vako namai vako, kuti ugorarama mazuva mazhinji munyika yaunopiwa naJehovha Mwari wako. ");
INSERT INTO sna_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Usauraya. ");
INSERT INTO sna_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Usaita upombwe. ");
INSERT INTO sna_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Usaba. ");
INSERT INTO sna_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Usapupurira muvakidzani wako nhema. ");
INSERT INTO sna_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Usachiva imba yomuvakidzani wako. Usachiva mukadzi womuvakidzani wako, kana murandarume wake, kana murandakadzi wake, kana nzombe yake, kana mbongoro yake, kana chinhu chipi zvacho chomuvakidzani wako.” ");
INSERT INTO sna_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Vanhu vakati vaona mheni nokutinhira uye vanzwa hwamanda, uye vaona gomo richipfungaira utsi, vakadedera nokutya. Vakagara vari chinhambwe ");
INSERT INTO sna_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","vakati kuna Mozisi, “Taura iwe kwatiri uye tichakuteerera. Asi usarega Mwari achitaura nesu, kuti tirege kufa.” ");
INSERT INTO sna_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mozisi akati kuvanhu, “Musatya. Mwari auya kuzokuedzai, kuitira kuti kutya Mwari kugova nemi, kuti murege kutadza.” ");
INSERT INTO sna_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Vanhu vakaramba vari chinhambwe, Mozisi paakanga achiswedera kurima gobvu kwakanga kuna Mwari. ");
INSERT INTO sna_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ipapo Jehovha akati kuna Mozisi, “Taurira vaIsraeri kuti, ‘Mazvionera pachenyu kuti ndataura kwamuri ndiri kudenga ndikati: ");
INSERT INTO sna_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Musaita vamwari vapi zvavo kunze kwangu; musazviitira vamwari vesirivha kana vamwari vegoridhe. ");
INSERT INTO sna_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Mundiitire aritari yevhu mugobayira pamusoro payo zvipiriso zvinopiswa uye zvipiriso zvokuwadzana, makwai enyu, mbudzi dzenyu nemombe dzenyu. Pose pandichaita kuti zita rangu rikudzwe, ndichauya kwamuri ndigokuropafadzai. ");
INSERT INTO sna_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kana muchindiitira aritari yamabwe, musaivaka namabwe akavezwa, nokuti mungazoisvibisa kana mukashandisa mbezo pairi. ");
INSERT INTO sna_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Uye musakwira kuaritari yangu namatanho, kuti kusasimira kwenyu kurege kuonekwa muri pairi.’ ");
INSERT INTO sna_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Iyi ndiyo mirayiro yaunofanira kumisa pamberi pavo: ");
INSERT INTO sna_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Kana ukatenga muranda wechiHebheru, anofanira kukushandira kwamakore matanhatu. Asi mugore rechinomwe, anofanira kusunungurwa aende, asina chinhu chaanoripa. ");
INSERT INTO sna_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kana akauya ari oga, anofanira kusunungurwa aende ari oga; asi kana ano mukadzi pakuuya kwake, anofanira kuenda nomukadzi wake. ");
INSERT INTO sna_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kana tenzi wake akamupa mukadzi uye akamuberekera vanakomana kana vanasikana, mukadzi navana vake vachava vatenzi wake, uye murume chete ndiye achasunungurwa kuti aende hake. ");
INSERT INTO sna_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Asi muranda akati, ‘Ndinoda tenzi wangu, mukadzi wangu navana vangu asi handisi kuda kusunungurwa,’ ");
INSERT INTO sna_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ipapo tenzi wake anofanira kuenda naye pamberi pavatongi. Achaenda naye pamukova kana pagwatidziro romukova agomuboora nzeve yake norunji. Ipapo achava muranda wake kwoupenyu hwake hwose. ");
INSERT INTO sna_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kana munhu akatengesa mwanasikana wake kuti ave murandakadzi, iyeye haafaniri kusunungurwa kuti aende sezvinoita varandarume. ");
INSERT INTO sna_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kana asingafadzi tenzi akamusarudza kuti ave wake, anofanira kumurega kuti adzikinurwe. Haana mvumo yokumutengesa kuvatorwa, nokuti aputsa chitenderano naye. ");
INSERT INTO sna_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kana akamusarudzira mwanakomana wake, anofanira kumupa kodzero dzomwanasikana. ");
INSERT INTO sna_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kana akawana mumwe mukadzi, haafaniri kunyima mukadzi wokutanga zvokudya, nguo kana kodzero dzake dzokuwanikwa. ");
INSERT INTO sna_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kana asingamupi zvinhu zvitatu izvi, anofanira kuenda akasununguka pasina kana mari yaanoripa. ");
INSERT INTO sna_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ani naani anorova munhu uye akamuuraya, zvirokwazvo naiye achaurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kunyange zvakadaro hazvo, kana asingazviiti nobwoni, asi Mwari atendera kuti zviitike, iye anofanira kutizira kunzvimbo yandichatsaura. ");
INSERT INTO sna_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Asi kana munhu akaronga uye akauraya mumwe munhu nobwoni, mumubvise paaritari yangu uye mumuuraye. ");
INSERT INTO sna_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ani naani anorova baba vake kana mai vake anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ani naani anoba mumwe munhu uye akamutengesa kana kuti akawanikwa achinaye paanenge abatwa, anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ani naani anotuka baba vake kana mai vake anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Kana vanhu vakakakavadzana uye mumwe akarova mumwe nebwe kana nechibhakera chake uye akasafa asi akavata panhoo, ");
INSERT INTO sna_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","munhu arova haazobatwi nemhosva kana mumwe wacho akamuka akafamba-famba kunze nomudonzvo wake; kunyange zvakadaro hazvo, anofanira kuripa munhu akakuvara nokuda kwokurasikirwa kwake nenguva yake uye aone kuti apora zvachose. ");
INSERT INTO sna_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kana munhu akarova murandarume wake kana murandakadzi netsvimbo uye muranda akafa nokuda kwokurohwa, anofanira kurangwa, ");
INSERT INTO sna_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","asi haafaniri kurangwa kana muranda akamuka shure kwezuva rimwe chete kana maviri, sezvo muranda ari mudziyo wake. ");
INSERT INTO sna_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kana varume vachirwa vakarova mukadzi ane mimba uye akabereka gavamwedzi asi asina kukuvara zvakanyanya, nyakupara mhosva anofanira kuripiswa zvose zvazvo zvinodiwa nomurume wacho uye zvinobvumirwa nedare remhosva. ");
INSERT INTO sna_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Asi kana pane kukuvara kwakaipisisa, unofanira kutora upenyu noupenyu, ");
INSERT INTO sna_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ziso neziso, zino nezino, ruoko noruoko, tsoka netsoka, ");
INSERT INTO sna_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kutsva nokutsva, ronda neronda, vanga nevanga. ");
INSERT INTO sna_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kana munhu akarova murandarume kana murandakadzi paziso uye akariparadza, anofanira kurega muranda achienda akasununguka kuti atsive ziso rake. ");
INSERT INTO sna_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Uye kana akabvisa zino romurandarume kana romurandakadzi, anofanira kurega muranda aende akasununguka kuti atsive zino rake. ");
INSERT INTO sna_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kana hando ikatunga murume kana mukadzi akafa, hando iyoyo inofanira kutakwa namabwe kusvika yafa, uye nyama yayo haifaniri kudyiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kunyange zvakadaro hazvo, kana hando yanga ine tsika yokutunga uye muridzi wayo akamboyambirwa hake asi akasaipfigira mudanga uye ikauraya murume kana mukadzi, hando iyo inofanira kutakwa namabwe uyewo muridzi wayo anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kunyange zvakadaro hazvo, kana pachidikanwa muripo unobva kwaari angadzikinura hake upenyu hwake nokuripa zvose zvazvo zvinodikanwa. ");
INSERT INTO sna_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Murayiro uyu unobatawo kana hando iyi yatunga mwanakomana kana mwanasikana. ");
INSERT INTO sna_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kana hando ikatunga murandarume kana murandakadzi, muridzi wayo anofanira kuripa mashekeri esirivha makumi matatu kuna tenzi womuranda, uye hando inofanira kutakwa namabwe. ");
INSERT INTO sna_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Kana munhu akafukunura gomba kana kuchera rimwe gomba uye akarega kurifushira uye nzombe kana mbongoro ikawira mariri, ");
INSERT INTO sna_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","muridzi wegomba anofanira kuripa kurasikirwa uku; anofanira kuripira muridzi wayo, uye chipfuwo chafa chichava chake. ");
INSERT INTO sna_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kana hando yomumwe munhu ikakuvadza hando yomumwe uye ikafa, vanofanira kutengesa mhenyu yacho vagogovana zvakaenzana mari yacho vari vaviri, uye nemombe yakafawo. ");
INSERT INTO sna_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kunyange zvakadaro, kana zvakanga zvichizivikanwa kuti hando iyi yagara ine tsika yokutunga, asi muridzi akasaipfigira mudanga, muridzi anofanira kuripa chipfuwo nechipfuwo, uye chipfuwo chafa chichava chake. ");
INSERT INTO sna_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kana munhu akaba nzombe kana gwai uye akauraya kana kutengesa anofanira kuripa mombe shanu nokuda kwenzombe uye makwai mana pagwai rimwe chete. ");
INSERT INTO sna_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Kana mbavha ikabatwa ichipaza uye ikarohwa ikafa, nyakudzivirira haana mhosva yokuteura ropa; ");
INSERT INTO sna_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","asi kana zvikaitika shure kwokubuda kwezuva, anenge ane mhosva yokuteura ropa. “Mbavha inofanira kudzora zvayaba, asi kana isina chinhu, inofanira kutongeswa kuti iripe umbavha hwayo. ");
INSERT INTO sna_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Kana chipfuwo chakabiwa chikawanikwa chichiri chipenyu muruoko rwake, ingava nzombe kana mbongoro kana gwai, iye anofanira kuripa zvava zviviri. ");
INSERT INTO sna_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kana munhu akafudza zvipfuwo zvake mumunda kana mumunda womuzambiringa uye akarega zvipfuwo zvake zvichidya mumunda womunhu, anofanira kudzorera zvakaisvonaka zvinobva mumunda wake kana mumunda wake womuzambiringa. ");
INSERT INTO sna_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kana moto ukapfuta uye ukapararira muzvikwenzi zveminzwa zvokuti unopisa mirwi yezviyo kana zviyo zvimire, kana munda wose, munhu abatidza moto anofanira kudzorera nomuripo. ");
INSERT INTO sna_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Kana munhu akapa muvakidzani wake sirivha kana zvinhu kuti achengete zvichibva zvabiwa kubva mumba momuvakidzani, mbavha yacho, kana ikabatwa, inofanira kuripa zvakapetwa kaviri. ");
INSERT INTO sna_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Asi kana mbavha isina kuwanikwa, muridzi wemba anofanira kumira pamberi pavatongi kuti zvionekwe kana akaisa ruoko rwake pazvinhu zvomumwe munhu. ");
INSERT INTO sna_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Panyaya dzose dzokuchengeta zvisiri pamutemo, nzombe, mbongoro, gwai, nguo kana chimwewo zvacho chakarasika chinonzi nomumwe munhu, ‘Ndechangu ichi’, vaviri ava vanofanira kuuya nenyaya dzavo pamberi pavatongi. Munhu uyo achanzi ane mhosva navatongi anofanira kuripira muvakidzani wake zvakapetwa kaviri. ");
INSERT INTO sna_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kana munhu akapa mbongoro, nzombe, gwai kana chipfuwo chipi zvacho kumuvakidzani wake kuti achengete chichibva chafa kana kukuvara kana kutorwa pasina anozviona, ");
INSERT INTO sna_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nyaya iri pakati pavo inofanira kugadziriswa nokuita mhiko pamberi paJehovha yokuti muvakidzani haana kuisa maoko ake pazvinhu zvomumwe munhu. Muridzi anofanira kugamuchira izvi, uye hapana muripo unodikanwa apa. ");
INSERT INTO sna_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Asi kana chipfuwo chakabiwa kubva kumuvakidzani, iye anofanira kudzorera kumuridzi nomuripo. ");
INSERT INTO sna_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kana chakabvarurwa-bvarurwa nechikara chesango, iye achauyisa zvakasara zvacho zvive umboo uye haazosungirwi kuripa chipfuwo chakabvamburwa. ");
INSERT INTO sna_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kana munhu akakwereta chipfuwo kubva kumuvakidzani wake uye chikakuvara kana kufa, muridzi wacho asipo, anofanira kuripa. ");
INSERT INTO sna_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Asi kana muridzi ane chipfuwo chacho, akwereta haafaniri kuzoripa. Kana chipfuwo ichi changa chichiripirwa mari yokuchishandisa, mari yakaripwa yacho ndiyo inozozadzisa kurasikirwa kwake. ");
INSERT INTO sna_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kana murume akanyengera musikana anenge ari mhandara asina kutsidzira kuti awanikwe uye akavata naye, iye anofanira kubvisa roora, uye achava mukadzi wake. ");
INSERT INTO sna_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kana baba vake vasingadi zvachose kuti vamupe kwaari, anofanira bedzi kubvisa roora rinobvisirwa mhandara. ");
INSERT INTO sna_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Usatendera muroyikadzi kuti ararame. ");
INSERT INTO sna_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ani naani anoita chipfuwo mukadzi anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ani naani anobayira kuna mwari upi zvake kunze kwangu anofanira kuparadzwa. ");
INSERT INTO sna_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Usabata mutorwa zvakaipa kana kumudzvinyirira, nokuti imi makanga muri vatorwa muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Musaitira zvakaipa chirikadzi nenherera. ");
INSERT INTO sna_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kana mukaita izvozvo uye ivo vakachema kwandiri, zvirokwazvo ndichanzwa kuchema kwavo. ");
INSERT INTO sna_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Kutsamwa kwangu kuchamuka, uye ndichakuurayai nomunondo; vakadzi venyu vachava chirikadzi uye vana venyu vachava nherera. ");
INSERT INTO sna_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kana mukakweretesa mari kuno mumwe wavanhu vangu vari pakati penyu vanoshaya, musaita somunhu webasa rokukweretesa; musamuripisa yava nemhindu. ");
INSERT INTO sna_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kana ukatora jasi romuvakidzani wako sechitsidzo, uridzorere kwaari zuva rodoka, ");
INSERT INTO sna_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","nokuti jasi rake ndicho chifukidzo bedzi chaanacho chomuviri wake. Achavata akafukeiko? Paanochema kwandiri, ini ndichanzwa, nokuti ndine tsitsi. ");
INSERT INTO sna_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Usamhura Mwari kana kutuka mutongi wavanhu vako. ");
INSERT INTO sna_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Usarega kupa zvipiriso zvinobva mumatura ako kana muzvisviniro zvako. “Unofanira kundipa dangwe ravanakomana vako. ");
INSERT INTO sna_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Muite zvimwe chetezvo kumombe dzenyu nokumakwai enyu. Murege zvigare mazuva manomwe navanamai vazvo, asi muzvipe kwandiri pazuva rorusere. ");
INSERT INTO sna_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Munofanira kuva vanhu vangu vatsvene. Saka musadya nyama yechipfuwo chakabvamburwa nezvikara zvesango, muikandire kumbwa. ");
INSERT INTO sna_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Usaparadzira mashoko enhema. Usabatsira munhu akaipa nokuva chapupu chakaipa. ");
INSERT INTO sna_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Usatevedzera vanhu vazhinji pakuita zvakaipa. Paunopa umboo mudare redzimhosva, usaminamisa kururamisira uchienda kurutivi rworuzhinji, ");
INSERT INTO sna_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","uye usatsaura munhu murombo uchienda kudivi rake pamhaka yake. ");
INSERT INTO sna_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kana ukaona nzombe yomuvengi wako kana mbongoro yake yarasika, ona kuti waidzosera kwaari. ");
INSERT INTO sna_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kana ukaona mbongoro yomunhu anokuvenga yawira pasi nokuda kwokuremerwa, usaisiya ipapo; iva nechokwadi kuti wamubatsira pairi. ");
INSERT INTO sna_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Usaramba kururamisira varombo vavanhu vokwako pamatare edzimhosva. ");
INSERT INTO sna_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Usava nechokuita nokupomerwa kwemhosva yenhema uye usatongera rufu munhu asina mhosva, kana munhu akatendeka, nokuti ini handizopembedzi munhu ane mhosva. ");
INSERT INTO sna_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Usagamuchira fufuro, nokuti fufuro inopofumadza vaya vanoona uye inomonyorora mashoko owakarurama. ");
INSERT INTO sna_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Musadzvinyirira mutorwa; imi pachenyu munoziva kuti zvakaita sei kuva mutorwa, nokuti makanga muri vatorwa muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Makore matanhatu munofanira kudyara minda yenyu mugokohwa zvirimwa, ");
INSERT INTO sna_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","asi pagore rechinomwe nyika ngairege kurimwa kana kushandiswa. Ipapo varombo vari pakati pavanhu venyu vangawanawo zvokudya kubva mairi, uye zvikara zvesango zvigodya zvavanenge vasiya. Muitewo zvimwe chetezvo kuminda yenyu yemizambiringa neyemiorivhi. ");
INSERT INTO sna_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Muite basa renyu mazuva matanhatu, asi pazuva rechinomwe musashanda, kuitira kuti nzombe yako nembongoro yako zvizorore uye nhapwa yakaberekerwa mumba mako, nomutorwa, vazororewo. ");
INSERT INTO sna_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Muchenjerere kuti muite zvose zvandakareva kwamuri. Musareva mazita avamwe vamwari; ngaarege kunzwikwa pamiromo yenyu. ");
INSERT INTO sna_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Katatu pagore munofanira kupemberera mutambo kwandiri. ");
INSERT INTO sna_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Mupemberere Mutambo weChingwa Chisina Mbiriso; mazuva manomwe, munofanira kudya chingwa chisina mbiriso, sezvandakakurayirai. Muite izvi panguva dzakatarwa mumwedzi waAbhibhi, nokuti mumwedzi iwoyo ndipo pamakabuda kubva muIjipiti. “Hakuna munhu anofanira kumira pamberi pangu asina chinhu. ");
INSERT INTO sna_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mupemberere Mutambo woKukohwa nezvibereko zvokutanga zvezvirimwa zvamakadyara muminda yenyu. “Mupemberere Mutambo woKuunganidza pakupera kwegore, pamunounganidza zvirimwa zvenyu kubva mumunda. ");
INSERT INTO sna_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Varume vose vanofanira kumira pamberi paIshe Jehovha katatu pagore. ");
INSERT INTO sna_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Musapa ropa rechibayiro kwandiri pamwe chete nechinhu chipi zvacho chine mbiriso. “Mafuta ezvipiriso zvangu zvomutambo haafaniri kuchengetwa kusvikira mangwana mangwanani. ");
INSERT INTO sna_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Muuye nezvakanakisisa zvezvibereko zvokutanga zvevhu renyu kuimba yaJehovha Mwari wenyu. “Musabika mbudzana mumukaka wamai vayo. ");
INSERT INTO sna_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Tarirai, ndiri kutumira mutumwa pamberi penyu kuti akuchengetei munzira uye kuti akusvitsei kunzvimbo yandakakugadzirirai. ");
INSERT INTO sna_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Murerekere nzeve dzenyu kwaari mugoteerera zvaanoreva. Musamumukira; iye haangazoregereri kumukira kwenyu, sezvo Zita rangu riri maari. ");
INSERT INTO sna_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kana mukanyatsoteerera kune zvaanoreva nokuita zvose zvandinoreva, ini ndichava muvengi kuvavengi venyu uye ndichapikisa avo vanokupikisai. ");
INSERT INTO sna_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mutumwa wangu achakutungamirirai uye achakupinzai munyika yavaAmori, vaHiti, vaPerezi, vaKenani, vaHivhi navaJebhusi, uye ndichavapedza chose. ");
INSERT INTO sna_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Musapfugamira vamwari vavo kana kuvanamata kana kuwadzana namabasa avo. Munofanira kuvaparadza uye mugoputsa matombo avo anoyera. ");
INSERT INTO sna_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Namatai Jehovha Mwari wenyu, uye ipapo maropafadzo ake achava pane zvokudya zvenyu nemvura yenyu. Ndichabvisa urwere kubva pakati penyu, ");
INSERT INTO sna_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","uye hakuna achabva pamuviri kana asingabereki munyika yenyu. Ndichakupai upenyu huzere. ");
INSERT INTO sna_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ndichatuma kuvhundutsa kwangu pamberi penyu uye ndichauyisa nyonganiso pamusoro pendudzi dzose dzamunosangana nadzo. Ndichaita kuti vavengi venyu vose vatendeuke vagotiza. ");
INSERT INTO sna_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ndichatuma mago pamberi penyu kuti adzinge vaHivhi, vaKenani navaHiti kuti vabve munzira yenyu. ");
INSERT INTO sna_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Asi handizovadzingi mugore rimwe chete, nokuti nyika ingazoita sango uye mhuka dzesango dzikakuwandirai. ");
INSERT INTO sna_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ndichavabvisa pamberi penyu zvishoma zvishoma, kusvikira manyatsowanda kuti mutore nyika. ");
INSERT INTO sna_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ndichasimbisa miganhu yenyu kubva kuGungwa Dzvuku kusvikira kuGungwa ravaFiristia, uye kubva kuRenje kusvikira kuRwizi. Ndichaisa mumaoko enyu vanhu vagere munyika iyi uye imi muchavadzinga pamberi penyu. ");
INSERT INTO sna_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Musaita sungano navo kana navamwari vavo. ");
INSERT INTO sna_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Musavatendera kuti vagare munyika yenyu kuti varege kukuitai kuti munditadzire, nokuti kunamata vamwari vavo kuchava musungo kwamuri zvirokwazvo.” ");
INSERT INTO sna_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ipapo akati kuna Mozisi, “Kwira kuna Jehovha, iwe naAroni, Nadhabhi naAbhihu, navakuru vavaIsraeri makumi manomwe. Munamate muri chinhambwe, ");
INSERT INTO sna_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","asi Mozisi oga ndiye anofanira kuswedera kuna Jehovha; vamwe havafaniri kuswedera pedyo. Uye vanhu havangakwiri naye.” ");
INSERT INTO sna_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mozisi akati aenda kundoudza vanhu mashoko ose nemirayiro yose yaJehovha, ivo vakati nenzwi rimwe chete, “Tichaita zvinhu zvose zvakarehwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ipapo Mozisi akanyora zvinhu zvose zvakanga zvarehwa naJehovha. Akamuka mangwana acho mangwanani akavaka aritari mujinga megomo uye akamisa mbiru dzamabwe gumi nembiri dzichimirira marudzi gumi namaviri avaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ipapo akatuma majaya avaIsraeri, uye vakapa zvipiriso zvinopiswa uye vakabayira hando duku sezvipiriso zvokuwadzana kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mozisi akatora hafu yeropa akariisa mumidziyo, uye imwe hafu akaisasa paaritari. ");
INSERT INTO sna_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ipapo akatora Bhuku reSungano akariverengera vanhu. Ivo vakati, “Tichaita zvinhu zvose zvakarehwa naJehovha; tichazviteerera.” ");
INSERT INTO sna_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ipapo Mozisi akatora ropa, akarisasa pamusoro pavanhu uye akati, “Iri iropa resungano yaitwa naJehovha nemi maererano namashoko aya ose.” ");
INSERT INTO sna_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mozisi naAroni, Nadhabhi naAbhihu uye navakuru makumi manomwe vavaIsraeri vakakwira ");
INSERT INTO sna_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","uye vakaona Mwari waIsraeri. Pasi petsoka dzake pakanga pane chimwe chinhu chakaita sechivakwa chesafire, chakanga chichionekwa sedenga pacharo. ");
INSERT INTO sna_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Asi Mwari haana kusimudza ruoko rwake pamusoro pavatungamiri vavaIsraeri ava; vakaona Mwari, uye vakadya vakanwa. ");
INSERT INTO sna_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Jehovha akati kuna Mozisi, “Kwira kuno kwandiri pamusoro pegomo ugare pano, ndigokupa mahwendefa amabwe, ane mirayiro nemitemo zvandanyora kuti varayirwe.” ");
INSERT INTO sna_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ipapo Mozisi akasimuka naJoshua mubatsiri wake, uye Mozisi akakwira mugomo raMwari. ");
INSERT INTO sna_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Akati kuvakuru, “Timirirei pano kusvikira tadzoka kwamuri. Aroni naHuri vanemi, uye ani naani zvake anopesana nomumwe anogona kuenda kwavari.” ");
INSERT INTO sna_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mozisi akati akwira mugomo, gore rakarifukidza, ");
INSERT INTO sna_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","uye kubwinya kwaJehovha kwakagara pamusoro peGomo reSinai. Gore rakafukidza gomo iro kwamazuva matanhatu, uye pazuva rechinomwe, Jehovha akadana Mozisi ari mukati megore. ");
INSERT INTO sna_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","KuvaIsraeri, kubwinya kwaJehovha kwairatidzika somoto unoparadza uri pamusoro pegomo. ");
INSERT INTO sna_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ipapo akapinda mugore paakanga achikwira mugomo. Uye akagara mugomo kwamazuva makumi mana nousiku huna makumi mana. ");
INSERT INTO sna_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Taurira vaIsraeri kuti vandivigire chipiriso. Unofanira kugamuchira chipiriso changu kubva kumunhu upi noupi anosundwa nomwoyo wake kuti ape. ");
INSERT INTO sna_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Izvi ndizvo zvipiriso zvaunofanira kugamuchira kubva kwavari: “goridhe, sirivha, ndarira; ");
INSERT INTO sna_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","wuru yebhuruu, pepuru netsvuku uye nemicheka yakaisvonaka; makushe embudzi; ");
INSERT INTO sna_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","matehwe amakondobwe akapendwa zvitsvuku namatehwe emombe dzomugungwa; matanda omuunga; ");
INSERT INTO sna_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta omuorivhi emwenje; zvinonhuhwira zvemafuta okuzodza anonhuhwira uye nezvimwe zvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mabwe eonikisi nezvimwe zvinokosha zvinofanira kuiswa paefodhi napachidzitiro chechipfuva. ");
INSERT INTO sna_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ipapo uite kuti vaite nzvimbo yangu tsvene, uye ini ndichagara pakati pavo. ");
INSERT INTO sna_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Muite tabhenakeri iyi nemidziyo yayo yose nomufananidzo wandichakuratidza. ");
INSERT INTO sna_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Uite kuti vaite bhokisi ramatanda omuunga, rakareba makubhiti maviri nehafu, upamhi kubhiti nehafu, uye kubhiti nehafu pakukwira. ");
INSERT INTO sna_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Murifukidze negoridhe rakaisvonaka, mukati nokunze, uye muite hata yegoridhe yakaripoteredza. ");
INSERT INTO sna_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Muiumbire mhete ina dzegoridhe mugodzisungira pamakumbo aro mana, nemhete mbiri pano rumwe rutivi uye mhete mbiri kuno rumwe rutivi. ");
INSERT INTO sna_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ipapo mugoita matanda omuunga uye negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Muise matanda aya mukati memhete dziri parutivi rwebhokisi kuti mutakure bhokisi nawo. ");
INSERT INTO sna_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Matanda anofanira kugara ari mumhete dzebhokisi iri; haafaniri kubviswa. ");
INSERT INTO sna_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ipapo mugoisa muareka chipupuriro, chandichakupai. ");
INSERT INTO sna_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Muite chifunhiro chokuyananisa chegoridhe rakaisvonaka, makubhiti maviri nehafu pakureba uye kubhiti nehafu paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Uye muite makerubhi maviri egoridhe rakapambadzirwa kumacheto echifunhiro. ");
INSERT INTO sna_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Muite kerubhi rimwe chete kuno rumwe rutivi uye kerubhi rechipiri kuno rumwe rutivi; muite bandi rimwe chete rekerubhi nechifukidzo, pamativi maviri. ");
INSERT INTO sna_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mapapiro amakerubhi anofanira kutambanudzirwa kumusoro, akafukidzira chifunhiro. Makerubhi anofanira kutarisana, akatarira kuchifunhiro. ");
INSERT INTO sna_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Muise chifunhiro pamusoro peareka uye mugoisa muareka, Chipupuriro chandichakupai. ");
INSERT INTO sna_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ipapo, pamusoro pechifunhiro chiri pakati pamakerubhi maviri ari pamusoro peareka yeChipupuriro, ndichasangana newe ndigokupa mirayiro yangu yose yavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Uite tafura namatanda omuunga yakareba makubhiti maviri, kubhiti rimwe chete paupamhi uye kubhiti nehafu pakukwirira. ");
INSERT INTO sna_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Muifukidzire negoridhe rakaisvonaka uye mugoipoteredza nezvakaumbwa zvegoridhe. ");
INSERT INTO sna_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Uyewo uite vhiri rinoipoteredza rino upamhi hwakaita sechanza choruoko ugoisa goridhe rakaumbwa pamusoro pevhiri. ");
INSERT INTO sna_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Uite mhete ina dzegoridhe dzetafura ugodzisungira kumakona mana, pane makumbo ayo. ");
INSERT INTO sna_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mhete idzi dzinofanira kuva pedyo nevhiri kuti dzibate matanda anoshandiswa kutakura tafura. ");
INSERT INTO sna_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Uite matanda omuunga, uafukidze negoridhe uye mugotakura tafura nawo. ");
INSERT INTO sna_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Uye uite ndiro dzayo namadhishi negoridhe rakaisvonaka, uyewo namatende ayo nembiya dzokudirisa zvipiriso. ");
INSERT INTO sna_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Uise chingwa choKuratidza patafura iyi kuti chive pamberi pangu nguva dzose. ");
INSERT INTO sna_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Uite chigadziko chomwenje chegoridhe rakaisvonaka uye ugoipambadzira pasi payo pamwe chete nerwiriko rwayo; mbiya dzayo, mabukira namaruva acho zvichava chinhu chimwe chete nacho. ");
INSERT INTO sna_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Matavi matanhatu anofanira kutambarara achibva mumativi echigadziko chomwenje, matatu kuno rumwe rutivi uye matatu kuno rumwezve. ");
INSERT INTO sna_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Mikombe mitatu yakaumbwa samaruva omuarimondi namabukira uye namaruva zvinofanira kuva padavi rimwe chete, matatu kune rimwe davi, uye zvimwe chetezvo kumativi matanhatu ose anotambarara kubva pachigadziko chomwenje. ");
INSERT INTO sna_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Uye pachigadziko chomwenje panofanira kuva nemikombe mina yakaumbwa samaruva omuarimondi ane mabukira namaruva. ");
INSERT INTO sna_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Bukira rimwe chete richava pasi pamatavi maviri okutanga anotambarara kubva pachigadziko chomwenje, bukira rechipiri riri pasi pamamwe matavi maviri, uye bukira rechitatu riri pasi pamamwezve pamatavi maviri, mativi ose ari matanhatu. ");
INSERT INTO sna_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mabukira namatavi achava ebandi rimwe chete nechigadziko chomwenje, negoridhe rakaisvonaka rakapambadzirwa. ");
INSERT INTO sna_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Ipapo ugoita mwenje yacho minomwe uye ugoigadzika pamusoro pacho kuitira kuti zvigovhenekera nzvimbo iri mberi kwacho. ");
INSERT INTO sna_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mbato dzacho nendiro dzacho zvinofanira kuva zvegoridhe rakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tarenda regoridhe rakaisvonaka rinofanira kushandiswa pachigadziko chomwenje nemimwe midziyo yose iyi. ");
INSERT INTO sna_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Uone kuti wazviita zvichienderana nomufananidzo wawakaratidzwa pagomo. ");
INSERT INTO sna_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Uite tabhenakeri nezvidzitiro gumi zvomucheka wakarukwa zvakaisvonaka, nowebhuruu, pepuru nomutsvuku, namakerubhi akasonerwa mairi nemhizha dzamabasa amaoko. ");
INSERT INTO sna_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Zvidzitiro zvose zvinofanira kuva zvakaenzana, zvakareba makubhiti makumi maviri namasere uye makubhiti mana paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ubatanidze zvidzitiro zvishanu pamwe chete, ugoita zvimwe chetezvo nezvimwe zvishanu. ");
INSERT INTO sna_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Uite zvishwe zvomucheka webhuruu kurutivi rwokumucheto wechidzitiro zvakabatanidzwa pamwe chete, uye ugoita zvimwe chete nechidzitiro chokumucheto mune zvimwe zvakabatanidzwa. ");
INSERT INTO sna_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Uite zvishwe makumi mashanu pachidzitiro chimwe chete uye makumi mashanu ezvishwe pamucheto wechidzitiro chezvimwe zvakabatanidzwa, zvishwe zvitarisane chimwe nechimwe. ");
INSERT INTO sna_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ipapo ugoita zvikoreko zvegoridhe makumi mashanu uye uzvishandise kubatanidza zvidzitiro pamwe chete kuitira kuti tabhenakeri ive chinhu chimwe. ");
INSERT INTO sna_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Uite zvidzitiro zvamakushe embudzi zvetende riri pamusoro petabhenakeri, zvose zvive gumi nerimwe pamwe chete. ");
INSERT INTO sna_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Zvidzitiro zvose zviri gumi nerimwe zvinofanira kuenzana, makubhiti makumi matatu pakureba uye makubhiti mana paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ubatanidze zvidzitiro zvishanu pamwe chete zviite chinhu chimwe chete uye zvimwe zvitanhatu zvivewo chinhu chimwe chete. Upete chidzitiro chechitanhatu kaviri pamberi petende. ");
INSERT INTO sna_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Uite zvishwe makumi mashanu pamupendero wechidzitiro chokumucheto zvakabatanidzwa uyewo pamupendero wechidzitiro chokumucheto kwezvimwe zvakabatanidzwa. ");
INSERT INTO sna_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ipapo ugoita zvikorekedzo zvendarira makumi mashanu ugozviisa muzvishwe kuti zvibatanidze tende pamwe chete chigova chinhu chimwe chete. ");
INSERT INTO sna_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kana zviri zvokuwedzera urefu hwezvidzitiro zvetende, hafu yechidzitiro inenge yasara inofanira kurembera necheshure kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Zvidzitiro zvetende zvinofanira kurebesa nekubhiti rimwe chete pamativi ose ari maviri; zvinenge zvasara zvinofanira kurembera pamativi etabhenakeri kuti zvigoifukidza. ");
INSERT INTO sna_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Uite chifukidzo chetende chamatehwe amakondobwe akapendwa nezvitsvuku, uye pamusoro paizvozvo chifukidzo chamatehwe emombe dzomugungwa. ");
INSERT INTO sna_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Uitire tabhenakeri mapuranga akati twi amatanda omuunga. ");
INSERT INTO sna_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Puranga rimwe nerimwe rinofanira kureba makubhiti gumi uye kubhiti nehafu paupamhi, ");
INSERT INTO sna_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","nembambo mbiri dzakamiswa dzakatarisana. Uite mapuranga ose etabhenakeri nenzira iyoyi. ");
INSERT INTO sna_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Uite mapuranga makumi maviri okurutivi rwezasi rwetabhenakeri ");
INSERT INTO sna_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","uye uite zvigadziko zvesirivha makumi mana kuti zvive pasi pawo, zvigadziko zviviri papuranga rimwe nerimwe, chimwe chete pasi pembambo imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kuno rumwe rutivi, rwokumusoro kwetabhenakeri, uite mapuranga makumi maviri, ");
INSERT INTO sna_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","uye zvigadziko zvesirivha makumi mana. Zviviri zviri pasi pepuranga rimwe nerimwe. ");
INSERT INTO sna_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Uite mapuranga matanhatu kurutivi rwokumucheto cheto, ndiko kumavirira etabhenakeri, ");
INSERT INTO sna_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","uye uite mapuranga maviri amakona okumucheto cheto. ");
INSERT INTO sna_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Pamakona maviri aya, anofanira kuva maviri maviri kubva pasi kusvikira kumusoro, uye agadzikwe mumhete imwe chete; ose ari maviri ngaave saizvozvo. ");
INSERT INTO sna_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Saka pachava namapuranga masere uye zvigadziko zvesirivha gumi nezvitanhatu, zviviri pasi pepuranga rimwe nerimwe. ");
INSERT INTO sna_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Uyewo uite mbariro dzamatanda omuunga: shanu dzamapuranga okuno rumwe rutivi rwetabhenakeri, ");
INSERT INTO sna_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","shanu dzaaya ari pano rumwe rutivi, uye shanu dzamapuranga okumavirira, kumucheto cheto kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mbariro yapakati inofanira kutandavara kubva kumucheto kusvikira kuno mumwe mucheto napakati pamapuranga. ");
INSERT INTO sna_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ufukidze mapuranga negoridhe uye ugoita mhete dzegoridhe kuti dzigobata mbariro. Uyewo ufukidze mbariro negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Umise tabhenakeri maererano nomufananidzo wawakaratidzwa mugomo. ");
INSERT INTO sna_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Uite chidzitiro chebhuruu, nechepepuru nechitsvuku chomucheka wakarukwa zvakaisvonaka, namakerubhi akasonerwapo nenyanzvi yokusona. ");
INSERT INTO sna_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Urirembedze nezvikorekedzo zvegoridhe pamatanda mana omuunga akafukidzwa negoridhe uye amire pamusoro pezvigadziko zvina zvesirivha. ");
INSERT INTO sna_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Urembedze chidzitiro pazvikorekedzo uye ugoisa areka yeChipupuriro shure kwechidzitiro. Chidzitiro ichi chichaparadzanisa nzvimbo tsvene nevnzvimbo tsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Uise chifukidziro chokuyananisa pamusoro peareka yeChipupuriro iri munzvimbo tsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Uise tafura kunze kwechidzitiro nechokumusoro kwetabhenakeri ugogadzika chigadziko chomwenje chakatarisana nayo nechezasi. ");
INSERT INTO sna_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Pamukova wokupinda mutende uite chidzitiro chewuru yebhuruu, pepuru netsvuku uye nomucheka wakarukwa zvakaisvonaka, basa romusoni anogona. ");
INSERT INTO sna_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Uite zvikorekedzo zvegoridhe zvechidzitiro ichi uye matanda mashanu omuunga akafukidzwa negoridhe. Uye uaumbire zvigadziko zvishanu zvendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Uvake aritari yamatanda omuunga, makubhiti matatu pakukwirira kwayo; inofanira kuva namativi mana akaenzana, kureba kwayo makubhiti mashanu uye upamhi hwayo makubhiti mashanu. ");
INSERT INTO sna_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Uite runyanga pamakona ayo mana, kuti nyanga nearitari zvive chinhu chimwe, uye ufukidze aritari nendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Uite midziyo yayo yose nendarira, hari dzayo dzokubvisisa madota, uye foshoro dzayo, mbiya dzokusasa nadzo, zvibayiso zvenyama nemakango apamoto. ");
INSERT INTO sna_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Uyiitire chiparo, sefa yendarira, uye ugoita mhete yendarira pakona imwe neimwe yesefa. ");
INSERT INTO sna_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Uchiise pasi pechitsiko chearitari kuitira kuti chive pakati nepakati pearitari. ");
INSERT INTO sna_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Uitire aritari matanda omuunga uye ugoafukidza nendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Matanda aya anofanira kupinzwa mukati memhete kuti agova kumativi maviri earitari painenge yotakurwa. ");
INSERT INTO sna_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Uite aritari namapuranga, isina chinhu mukati mayo. Inofanira kugadzirwa sokuratidzwa kwawakaitwa pagomo. ");
INSERT INTO sna_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Uitire tabhenakeri ruvazhe. Rutivi rwezasi runofanira kureba makubhiti zana uye runofanira kuva nezvidzitiro zvakarembedzwa zvomucheka wakarukwa zvakaisvonaka, ");
INSERT INTO sna_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","namatanda makumi maviri uye zvigadziko zvendarira makumi maviri uye zvikorekedzo zvesirivha nezvisungo pamatanda. ");
INSERT INTO sna_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Rutivi rwokumusoro rucharebawo makubhiti zana uye runofanira kuva nezvidzitiro zvakarembedzwa, namatanda makumi maviri, nezvigadziko zvendarira makumi maviri, uye zvikorekedzo zvesirivha nezvisungo pamatanda. ");
INSERT INTO sna_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Kumucheto kworuvazhe, nechokumavirira, kunofanira kuva noupamhi hwamakubhiti makumi mashanu uye zvidzitiro zvakarembedzwa, namatanda gumi uye zvigadziko gumi. ");
INSERT INTO sna_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kumucheto nechokumabvazuva kwakatarisana nokunobuda nezuva, upamhi hworuvazhe hunofanira kuva makubhiti makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Zvidzitiro zvakareba makubhiti gumi namashanu zvinofanira kuva kuno rumwe rutivi rwomukova, namatanda matatu nezvigadziko zvitatu, ");
INSERT INTO sna_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","uye zvimwe zvidzitiro zvakareba makubhiti gumi namashanu ngazvivewo kuno rumwe rutivi, namatanda matatu nezvigadziko zvitatuwo. ");
INSERT INTO sna_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Pamukova wokupinda muruvazhe, uise chidzitiro chakareba makubhiti makumi maviri, chewuru yebhuruu, yepepuru netsvuku uye nomucheka wakarukwa zvakaisvonaka, basa romusoni anogona, namatanda mana uyewo zvigadziko zvina. ");
INSERT INTO sna_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Matanda ose akapoteredza ruvazhe anofanira kuva nezvisungiso zvesirivha nezvikorekedzo, uye zvigadziko zvendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ruvazhe ruchareba makubhiti zana uye makubhiti makumi mashanu paupamhi, nezvidzitiro zvemicheka yakarukwa zvakaisvonaka yakareba makubhiti mashanu, uye nezvigadziko zvendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Mimwe midziyo inoshandiswa paushumiri hwetabhenakeri, ringava basa ripi zvaro, kusanganisira mbambo dzose dzetende neiya yomuruvazhe, inofanira kuva yendarira. ");
INSERT INTO sna_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Urayire vaIsraeri kuti vakuvigire mafuta omuorivhi akachena, akasvinwa omwenje, kuitira kuti mwenje irambe ichipfuta. ");
INSERT INTO sna_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","MuTende Rokusangana, kunze kwechidzitiro chiri pamberi peChipupuriro, Aroni navanakomana vake vanofanira kurega mwenje ichiramba ichipfuta pamberi paJehovha, kubva madekwana kusvikira mangwanani. Uyu unofanira kuva mutemo usingaperi pakati pavaIsraeri nokuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Uite kuti Aroni mukoma wako pamwe chete navanakomana vake vanoti Nadhabhi naAbhihu, Ereazari naItamari vauyiswe kwandiri kubva pakati pavaIsraeri kuti vandishumire savaprista. ");
INSERT INTO sna_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Uitire mukoma wako nguo tsvene, kuti apiwe ruremekedzo uye kukudzwa. ");
INSERT INTO sna_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Utaurire varume voumhizha vose vandakapa uchenjeri hwokuita zvakadaro kuti vanofanira kusonera Aroni nguo, dzokutsaurwa kwake, kuti agondishumira somuprista. ");
INSERT INTO sna_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Idzi ndidzo nguo dzavanofanira kuita: chidzitiro chapachipfuva, efodhi, jasi, nenguo yakarukwa, nguwani nendaza. Vanofanira kuitira mukoma wako Aroni navanakomana vake, nguo tsvene idzi. ");
INSERT INTO sna_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Uvaite kuti vashandise wuru yegoridhe, nebhuruu, pepuru netsvuku uye mucheka wakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Vaite efodhi yewuru yegoridhe, nebhuruu, pepuru netsvuku, nomucheka wakarukwa zvakaisvonaka, basa romunhu ano umhizha. ");
INSERT INTO sna_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ngaive namapenga maviri apamapfudzi akabatanidzwa pamakona ayo maviri, kuitira kuti igogona kubatanidzwa. ");
INSERT INTO sna_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Bhanhire rayo rakarukwa noumhizha rinofanira kufanana nayo, rive rebenga rimwe chete neefodhi uye rakagadzirwa newuru yegoridhe, nebhuruu, pepuru netsvuku, uye nomucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Utore mabwe maviri eonikisi ugonyora runyoro rwakatemwa pamusoro pawo mazita avanakomana vaIsraeri ");
INSERT INTO sna_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","zvichienderana nokuberekwa kwavo, mazita matanhatu padombo rimwe chete uye mamwe matanhatu asara anyorwe pane rimwe dombo. ");
INSERT INTO sna_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nyora mazita avanakomana vaIsraeri pamatombo maviri nenzira inoitwa nomuvezi wamatombo achitema runyoro pachisimbiso. Ipapo ugoamisa muzvirukwa zvegoridhe ");
INSERT INTO sna_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","uye ugoasungirira pamapenga apapfudzi eefodhi ave matombo echirangaridzo kuvana vaIsraeri. Aroni anofanira kutakura mazita aya pamapfudzi ake chive chirangaridzo pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Uite zvirukwa zvegoridhe ");
INSERT INTO sna_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","uye nengetani mbiri dzakarukwa setambo negoridhe rakaisvonaka, ugobatanidza ngetani nezvirukwa. ");
INSERT INTO sna_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Uite chidzitiro chapachipfuva chokutanga, basa romunhu woumhizha. Uchiite chifanane neefodhi yewuru yegoridhe, nebhuruu, pepuru netsvuku, uye mucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ngachienzane mativi ose ari mana, kureba kwacho sechanza choruoko uye upamhi hwakaita sechanza choruoko, uye chipetwe kaviri. ");
INSERT INTO sna_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ipapo uronge mitsara mina yamatombo anokosha pamusoro pacho. Mumutsara wokutanga muchava nerubhi, netopazi uye bheriri; ");
INSERT INTO sna_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","mumutsara wechipiri muchava neturikoisi, safire neemaradhi; ");
INSERT INTO sna_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","mumutsara wechitatu muchava nejasindi, agati neametisiti; ");
INSERT INTO sna_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","mumutsara wechina muchava nekirisoriti, onekisi uye nejasipa. Uaise muzvirukwa zvegoridhe. ");
INSERT INTO sna_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Panofanira kuva namatombo gumi namaviri, rimwe chete richimirira zita rimwe nerimwe ravanakomana vaIsraeri, rimwe nerimwe rakatemwa runyoro padombo sezvinoita chisimbiso chezita romumwe wavamarudzi gumi namaviri. ");
INSERT INTO sna_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Uite ngetani dzechidzitiro chapachipfuva dzakarukwa negoridhe rakaisvonaka, uzvimone setambo. ");
INSERT INTO sna_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Uite mhete mbiri dzegoridhe ugodzisungirira pamakona maviri echidzitiro chapachipfuva. ");
INSERT INTO sna_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Usungirire ngetani mbiri dzegoridhe pamhete dziri pamakona echidzitiro chapachipfuva, ");
INSERT INTO sna_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","nemimwe micheto yengetani inoenda kuzvirukwa zviviri uchizvibatanidza, kuzvipenga zvapamapfudzi zveefodhi nechokumberi. ");
INSERT INTO sna_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Uite mhete mbiri dzegoridhe ugodzibatanidza kuna mamwe makona echidzitiro chapachipfuva pamupendero wechomukati kunotevererana neefodhi. ");
INSERT INTO sna_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Uitezve dzimwe mhete dzegoridhe ugodzibatanidza pasi pemapenga apamapfudzi nechokumberi kweefodhi, pedyo nomusono uri nechapamusoro pebhanhire romuchiuno reefodhi. ");
INSERT INTO sna_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mhete dzepachidzitiro chechipfuva dzinofanira kusungirirwa pamhete dzeefodhi netambo yebhuruu, dzichibatanidzwa nebhanhire romuchiuno, kuitira kuti chidzitiro chapachipfuva chirege kubva paefodhi. ");
INSERT INTO sna_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Nguva dzose Aroni paanenge achipinda muNzvimbo Tsvene, achange akatakura mazita avanakomana vaIsraeri pamwoyo wake pachidzitiro chechipfuva chokutonga sechirangaridzo chenguva dzose pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Uyezve uise Urimi neTumimi muchidzitiro chechipfuva, kuitira kuti vagare vari pamwoyo waAroni pose paanenge achipinda pamberi paJehovha. Nokudaro Aroni acharamba akatakura zvinhu zvokutonga nazvo vaIsraeri pamwoyo wake pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Uite jasi rose zvaro reefodhi nomucheka webhuruu, ");
INSERT INTO sna_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","neburi romusoro pakati paro. Panofanira kuzova nomupendero wakarukwa wakaita sekora unopoteredza buri iri, kuitira kuti rirege kubvaruka. ");
INSERT INTO sna_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Uite matamba ewuru yebhuruu, yepepuru netsvuku akapoteredza mupendero wejasi, namatare egoridhe pakati pawo. ");
INSERT INTO sna_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Matare egoridhe namatamba zvinofanira kukayana zvichipoteredza mupendero wejasi. ");
INSERT INTO sna_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aroni anofanira kuripfeka paanenge achishumira. Kurira kwamatare kuchanzwikwa paanenge achipinda muNzvimbo Tsvene pamberi paJehovha uye nepaanenge achibuda, kuitira kuti arege kufa. ");
INSERT INTO sna_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Uite ndiro yegoridhe ugotema runyoro pairi sezvinoitwa pachisimbiso kuti: MUTSVENE KUNA JEHOVHA. ");
INSERT INTO sna_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Usungire tambo yebhuruu pairi kuti ibatanidzwe nenguwani; inofanira kuva mberi kwenguwani. ");
INSERT INTO sna_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ichava pahuma yaAroni, uye iye achatakura mhosva dzingava pazvipo zvitsvene zvinotsaurwa navaIsraeri, zvingava zvipo zvipi hazvo. Zvichava pahuma yaAroni nguva dzose kuitira kuti zvigamuchirwe naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Uruke jasi romucheka wakaisvonaka ugoita nguwani yomucheka wakaisvonaka. Ndaza inofanira kuva basa romuruki. ");
INSERT INTO sna_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Uite majasi, ndaza namabhanhire omumusoro avanakomana vaAroni, kuti vapiwe ruremekedzo nokukudzwa. ");
INSERT INTO sna_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Shure kwokunge wapfekedza mukoma wako Aroni navanakomana vake, uvazodze uye ugovagadza. Uvatsaure kuti vagondishumira savaprista. ");
INSERT INTO sna_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Uite nguo dzapasi dzomucheka dzive chifukidzo chomuviri, dzinobva muchiuno kusvikira kumabvi. ");
INSERT INTO sna_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aroni navanakomana vake vanofanira kudzipfeka pose pavanenge vachipinda muTende roKusangana kana kuswedera paaritari kuti vashumire vari muNzvimbo Tsvene, kuitira kuti varege kuva nemhosva vakafa. “Uchava mutemo wokusingaperi kuna Aroni nezvizvarwa zvake. ");
INSERT INTO sna_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Izvi ndizvo zvaunofanira kuita kuti uvanatse, kuti vandishumire savaprista: Utore hando duku namakondobwe maviri asina chinongo. ");
INSERT INTO sna_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Uye ubike chingwa noupfu hwakatsetseka hwegorosi, husina mbiriso, uye ubike makeke akavhenganiswa namafuta, nezvingwa zvitete zvakazorwa mafuta. ");
INSERT INTO sna_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Uzviise mudengu uye ugozvikumikidza zviri imomo, pamwe chete nehando uye makondobwe maviri. ");
INSERT INTO sna_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ipapo ugouya naAroni navanakomana vake kumukova wokupinda nawo kuTende Rokusangana ugovashambidza nemvura. ");
INSERT INTO sna_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tora hanzu ugopfekedza Aroni jasi, nguo yeefodhi neefodhi pachayo uye nechidzitiro chapachipfuva. Usungire efodhi paari nebhanhire romuchiuno rakarukwa nounyanzvi. ");
INSERT INTO sna_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Uise nguwani pamusoro wake uye ugoibatanidza nekorona tsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Utore mafuta okuzodza ugomuzodza uchiita zvokuadira pamusoro pake. ");
INSERT INTO sna_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Uye vanakomana vake ugovapfekedza majasi ");
INSERT INTO sna_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","uye ugoisa mabhanhire omumusoro pamusoro pavo. Ipapo ugosungira ndaza pana Aroni navanakomana vake. Uprista ndohwavo nomutemo usingaperi. Nenzira iyi uchagadza Aroni navanakomana vake. ");
INSERT INTO sna_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Uuye nehando pamberi peTende Rokusangana, uye Aroni navanakomana vake vachaisa maoko avo pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Uiuraye pamberi pomukova wokupinda kuTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Utore rimwe reropa rehando ugoriisa panyanga dzearitari nomunwe wako, uye ugodira rasara racho pahwaro hwearitari. ");
INSERT INTO sna_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ipapo ugotora mafuta ose akapoteredza zvomukati, zvinoti chiropa, neitsvo dziri mbiri namafuta ari pamusoro padzo, ugoapisa pamusoro pearitari. ");
INSERT INTO sna_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Asi upise nyama yehando nedehwe rayo namazvizvi ayo kunze kwomusasa. Ndicho chipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Utore rimwe regondobwe, uye Aroni navanakomana vake vagoisa maoko avo pamusoro paro. ");
INSERT INTO sna_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Uriuraye ugotora ropa raro urisase pamativi ose earitari. ");
INSERT INTO sna_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ucheke gondobwe kuita muzvidimbu zvidimbu uye ugosuka zvomukati, uye makumbo, uchiaisa pamwe chete nomusoro nezvimwe zvidimbu. ");
INSERT INTO sna_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ipapo ugopisa gondobwe rose paaritari. Ndicho chipiriso chinopiswa kuna Jehovha, chinonhuhwira zvinofadza, chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Utore rimwe gondobwe, uye Aroni navanakomana vake vachaisa maoko avo pamusoro waro. ");
INSERT INTO sna_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Uriuraye, utore rimwe ropa raro ugoriisa pamucheto wenzeve dzorudyi dzavanakomana vaAroni, napazvigunwe zvikuru zvamaoko avo orudyi, nokuzvigunwe zvikuru zvokutsoka dzavo dzorudyi. Ipapo ugosasa ropa pamativi ose earitari. ");
INSERT INTO sna_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Uye ugotora rimwe ropa riri paaritari namamwe mafuta okuzodza usase pana Aroni napanguo dzake uye napavanakomana vake napanguo dzavo. Ipapo iye navanakomana vake nenguo dzavo vachanatswa. ");
INSERT INTO sna_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Utore pagondobwe iri mafuta, mafuta apamuswe, mafuta akapoteredza zvomukati, akafukidza chiropa, itsvo dzose dziri mbiri namafuta ari padziri, uye nechidya chokurudyi. (Iri ndiro gondobwe rokugadzwa.) ");
INSERT INTO sna_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kubva padengu rechingwa chakabikwa chisina mbiriso, chiri pamberi paJehovha, utore chimwe chete, nekeke rakavhenganiswa namafuta, uye nechingwa chitete. ");
INSERT INTO sna_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Uise izvi zvose mumaoko aAroni navanakomana vake ugozvininira pamberi paJehovha sechipiriso chokuninira. ");
INSERT INTO sna_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ipapo uzvitore kubva mumaoko avo ugozvipisa paaritari pamwe chete nechipiriso chinopiswa chinonhuhwira zvinofadza kuna Jehovha, chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Shure kwokunge watora chityu chegondobwe rokugadzwa kwaAroni, uchininire pamberi paJehovha sechipiriso chokuninira uye chichava mugove wako. ");
INSERT INTO sna_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Unatse mitezo iyo yegondobwe rokugadza raAroni navanakomana vake: chityu chakaninirwa uye chakakumikidzwa. ");
INSERT INTO sna_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Uyu unofanira kuva mugove wenguva dzose unobva kuvaIsraeri, waAroni navanakomana vake. Uyu ndiwo mugove unofanira kupiwa navaIsraeri kuna Jehovha kubva pazvipiriso zvavo zvokuwadzana. ");
INSERT INTO sna_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Nguo tsvene dzaAroni dzichava dzezvizvarwa zvake kuitira kuti vazodzwe uye vagogadzwa vakadzipfeka. ");
INSERT INTO sna_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwanakomana wake achamutevera pauprista uye anouya kuTende Rokusangana kuti azoshumira ari muNzvimbo Tsvene, anofanira kudzipfeka kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Utore gondobwe rokugadzwa ugobika nyama yaro munzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aroni navanakomana vake vanofanira kudya nyama yegondobwe uye nechingwa chiri mudengu vari pamukova wokupinda paTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Vanofanira kudya zvipiriso izvi zvavakaitirwa yananiso yokugadzwa kwavo uye nokunatswa kwavo nazvo. Asi hakuna mumwe munhu anofanira kuzvidya nokuti zvitsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Uye kana pakava nenyama yegondobwe rokugadzwa inosara kana chingwa chipi zvacho chinosara kusvikira mangwana mangwanani, muzvipise. Hazvifaniri kudyiwa, nokuti zvitsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Uitire Aroni navanakomana vake zvinhu zvose zvandakakurayira, uchitora mazuva manomwe okuvagadza. ");
INSERT INTO sna_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ubayire hando zuva rimwe nerimwe sechipiriso chechivi chive chokuyananisa. Unatse aritari nokuiitira yananiso, uye ugoizodza kuti uiite tsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mazuva manomwe uyananisire aritari uye uinatse. Ipapo aritari ichava tsvene-tsvene, uye chose chichaigunzva chichava chitsvene. ");
INSERT INTO sna_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Izvi ndizvo zvaunofanira kupa paaritari nguva dzose zuva rimwe nerimwe: makwayana maviri egore rimwe chete. ");
INSERT INTO sna_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ubayire rimwe chete mangwanani uye nerimwe chete madekwana. ");
INSERT INTO sna_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Negwayana rokutanga ubayire nechegumi cheefa choupfu hwakatsetseka hwakasanganiswa nechikamu chimwe chete kubva muzvina chehini chamafuta akabva mumaorivhi akasvinwa, uye chikamu chimwe chete kubva muzvina chehini yewaini chive chipiriso chinonwiwa. ");
INSERT INTO sna_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ubayire rimwe gwayana zuva richangovira pamwe chete nechipiriso chimwe chetecho chezviyo nechipiriso chacho chinonwiwa sechamangwanani, chive chinonhuhwira zvinofadza, chipiriso chakaitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Chipiriso chinopiswa ichi chinofanira kuitwa nguva dzose pamukova weTende Rokusangana pamberi paJehovha kuzvizvarwa zvose. ");
INSERT INTO sna_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ipapo ndipo pandichasangana newe uye ndigotaura kwauri, ndipozve pandichasangana navaIsraeri, uye nzvimbo iyi ichatsaurwa nokubwinya kwangu. ");
INSERT INTO sna_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Saka ndichatsaura Tende Rokusangana nearitari uye ndichatsaura Aroni navanakomana vake kuti vandishumire savaprista. ");
INSERT INTO sna_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ipapo ndichagara pakati pavaIsraeri uye ndigova Mwari wavo. ");
INSERT INTO sna_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Vachaziva kuti ndini Jehovha Mwari wavo, akavabudisa kubva muIjipiti kuitira kuti ndigogara pakati pavo. Ndini Jehovha Mwari wavo. ");
INSERT INTO sna_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Uite aritari yokupisira zvinonhuhwira namatanda omuunga. ");
INSERT INTO sna_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Inofanira kuenzana mativi ayo ose ari mana, yakareba kubhiti rimwe chete uye kubhiti rimwe chete paupamhi, uye kukwirira kwayo makubhiti maviri, nyanga dzayo dzive chinhu chimwe chete nayo. ");
INSERT INTO sna_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ufukidze pamusoro payo namativi ose uye nenyanga dzayo negoridhe rakaisvonaka, ");
INSERT INTO sna_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","uye uite hata mbiri kumativi akatarisana. Kuti dzibate mapango anoshandiswa kuitakura. ");
INSERT INTO sna_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Uite mapango aya nomuti womuunga uye uafukidze negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Uise aritari mberi kwechidzitiro chiri pamberi peareka yeChipupuriro, pamberi pechifunhiro chokuyananisa chiri pamusoro peChipupuriro, pandichasangana newe. ");
INSERT INTO sna_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aroni anofanira kupisa zvinonhuhwira pamusoro pearitari mangwanani oga oga paanogadzira mwenje. ");
INSERT INTO sna_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Anofanira kupisazve zvinonhuhwira paanenge achitungidza mwenje zuva richangovira saka zvinonhuhwira zvinofanira kupiswa nguva dzose pamberi paJehovha kusvikira kuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Musapisira pamusoro pearitari iyi zvimwewo zvazvo zvinonhuhwira kana zvipiriso zvipi zvazvo zvinopiswa kana zvipiriso zvezviyo, uye musadururire chipiriso chinonwiwa pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aroni achaita yananiso panyanga idzi kamwe chete pagore. Yananiso yapagore iyi inofanira kuitwa neropa rokuyananisa rechipiriso chechivi kusvikira kuzvizvarwa zvinotevera. Chitsvene-tsvene kuna Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Paunoverenga vaIsraeri kuti uvanyore, mumwe nomumwe anofanira kupa Jehovha rudzikinuro rwoupenyu hwake panguva yaanoverengwa. Ipapo hapana denda richazouya pamusoro pavo paunovaverenga. ");
INSERT INTO sna_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mumwe nomumwe anoyambukira kuna avo vatoverengwa anofanira kupa hafu yeshekeri, zvichienderana neshekeri renzvimbo tsvene, rinorema magera makumi maviri. Hafu yeshekeri iyi chipiriso kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Vose vanoyambuka, vaya vana makore makumi maviri kana anopfuura iwayo, vanofanira kupa chipiriso kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Vapfumi havafaniri kupa zvinopfuura hafu yeshekeri uye varombo havafaniri kupa zvishoma pamunoita chipiriso kuna Jehovha kuti muyananiswe upenyu hwenyu. ");
INSERT INTO sna_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ugamuchire mari yeyananiso kubva kuvaIsraeri ugoishandisa paushumiri hweTende Rokusangana. Chichava chirangaridzo kuvaIsraeri pamberi paJehovha, muchiyananisira upenyu hwenyu.” ");
INSERT INTO sna_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Uite mudziyo wokushambira wendarira, nechigadziko chawo chendarira. Ugouisa pakati peTende Rokusangana nearitari uye ugoisa mvura mauri. ");
INSERT INTO sna_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aroni navanakomana vake vanofanira kushamba maoko avo netsoka dzavo nemvura. ");
INSERT INTO sna_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Pose pavachapinda muTende Rokusangana vachashamba kuitira kuti varege kufa. Uyezve, pavanoswedera paaritari kuti vazoshumira nokupa chipiriso chinoitirwa Jehovha nomoto, ");
INSERT INTO sna_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","vachashamba maoko avo netsoka dzavo kuitira kuti varege kufa. Uyu unofanira kuva mutemo usingaperi waAroni nezvizvarwa zvake kusvikira kuzvizvarwa zvinotevera.” ");
INSERT INTO sna_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Tora zvinonhuhwira zvinotevera izvi: mazana mashanu amashekeri emura inoerera, hafu yakadaro (ndiwo mazana maviri namakumi mashanu amashekeri) ezvinonhuhwira zvesinamoni, mazana maviri namakumi mashanu enzimbe, ");
INSERT INTO sna_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","mashekeri omuunga mazana mashanu, zvose zvichienderana neshekeri renzvimbo tsvene, nehini yamafuta omuorivhi. ");
INSERT INTO sna_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Vhenganisa izvi kuti zvive mafuta matsvene okuzodza, anonhuhwira akavhenganiswa, basa romuvhenganisi wezvinonhuhwira. Achava mafuta matsvene okuzodza. ");
INSERT INTO sna_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ipapo ugoashandisa kuzodza Tende Rokusangana, neareka yeChipupuriro, ");
INSERT INTO sna_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tafura nemidziyo yayo yose, chigadziko chomwenje nenhumbi dzacho dzose, aritari yezvinonhuhwira, ");
INSERT INTO sna_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","aritari yezvipiriso zvinopiswa nemidziyo yayo, uye mudziyo wokushambira nechigadziko chawo. ");
INSERT INTO sna_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Unofanira kuzvitsaura kuti zvigova zvitsvene-tsvene, uye zvose zvichazvigunzva zvichava zvitsvene. ");
INSERT INTO sna_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Uzodze Aroni navanakomana vake uye uvatsaure kuitira kuti vagondishandira savaprista. ");
INSERT INTO sna_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Uti kuvaIsraeri, ‘Aya achava mafuta angu matsvene okuzodza kuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Musaadira pamiviri yavanhu uye musaita mafuta api zvawo nenzira imwe cheteyo. Matsvene, uye munofanira kuaita matsvene. ");
INSERT INTO sna_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ani naani anoita mafuta anonhuhwira akafanana nawo uye ani naani anoaisa pamunhu upi zvake kunze kwomuprista anofanira kubviswa pakati pavanhu vokwake.’ ” ");
INSERT INTO sna_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ipapo Jehovha akati kuna Mozisi, “Tora zvinonhuhwira zvinoti sitaketi, onika negaribhanamu, uye zvinonhuhwira zvakaisvonaka, zvose zvakaenzana, ");
INSERT INTO sna_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","uye ugoita zvinonhuhwira zvakavhenganiswa, basa romuvhenganisi wezvinonhuhwira. Zvinofanira kurungwa nomunyu, uye zvitsvene. ");
INSERT INTO sna_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ukuye zvimwe zvacho zvive upfu ugozviisa pamberi peChipupuriro chiri muTende Rokusangana, umo mandichasangana newe. Zvichava zvitsvene-tsvene kwauri. ");
INSERT INTO sna_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Usazviitira zvinonhuhwira zvipi zvazvo nenzira imwe cheteyo; uzvicherechedze kuti zvitsvene kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ani naani achaita chipi zvacho chakafanana nacho kuti afadzwe nokunhuhwira kwacho, anofanira kubviswa pakati pavanhu vokwake.” ");
INSERT INTO sna_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tarira ndasarudza Bhezareri mwanakomana waUri, mwanakomana waHuri, worudzi rwaJudha, ");
INSERT INTO sna_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","uye ndamuzadza noMweya waMwari, nouchenjeri, nokugona nokuziva mhando dzose dzoumhizha, ");
INSERT INTO sna_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","kuita unyanzvi hwebasa regoridhe, sirivha nendarira, ");
INSERT INTO sna_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kuveza nokuronga mabwe, kushanda pabasa rokuveza matanda, nokubata mumhando dzose dzoumhizha. ");
INSERT INTO sna_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Pamusoro paizvozvo ndakagadza Ohoriabhi mwanakomana waAhisamaki, worudzi rwaDhani, kuti amubatsire. “Uyezve ndapa unyanzvi kumhizha kuti vaite zvinhu zvose zvandakakurayira zvinoti: ");
INSERT INTO sna_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Tende Rokusangana, areka yeChipupuriro ine chifukidzo chokuyananisa pamusoro payo, nenhumbi dzose dzetende, ");
INSERT INTO sna_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tafura nemidziyo yayo, chigadziko chomwenje chegoridhe rakaisvonaka nenhumbi dzacho dzose, aritari yezvinonhuhwira, ");
INSERT INTO sna_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","aritari yezvipiriso zvinopiswa nemidziyo yayo dzose, mudziyo wokushambira nechigadziko chawo, ");
INSERT INTO sna_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","uyewo nguo yakarukwa, dzose nguo tsvene dzaAroni muprista uye nenguo dzavanakomana vake pavanoshumira savaprista, ");
INSERT INTO sna_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","namafuta okuzodza uye nezvinonhuhwira kwazvo zveNzvimbo Tsvene. “Vanofanira kudzigadzira sezvandakakurayira iwe.” ");
INSERT INTO sna_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Uti kuvaIsraeri, ‘Munofanira kucherechedza Sabata rangu. Ichi ndicho chichava chiratidzo pakati pangu nemi kuzvizvarwa zvinotevera, kuti mugoziva kuti ndini Jehovha, anokuitai vatsvene. ");
INSERT INTO sna_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Cherechedzai Sabata, nokuti idzvene kwamuri. Munhu upi zvake anorizvidza anofanira kuurayiwa; ani naani anobata basa ripi zvaro pazuva iroro anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kwamazuva matanhatu, basa rinofanira kuitwa, asi zuva rechinomwe iSabata rokuzorora, idzvene kuna Jehovha. Ani naani anoita basa ripi zvaro nomusi weSabata anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","VaIsraeri vanofanira kucherechedza Sabata, vachiripemberera kusvikira kuzvizvarwa zvinotevera sesungano isingaperi. ");
INSERT INTO sna_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Richava chiratidzo pakati pangu navaIsraeri nokusingaperi, nokuti mukati mamazuva matanhatu Jehovha akasika denga nenyika, uye nomusi wechinomwe akarega kushanda uye akazorora.’ ” ");
INSERT INTO sna_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Jehovha akati apedza kutaura naMozisi paGomo reSinai, akamupa mahwendefa maviri eChipupuriro, mahwendefa amabwe akanyorwa nomunwe waMwari. ");
INSERT INTO sna_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Vanhu vakati vaona kuti Mozisi akanga anonoka kwazvo kuburuka kubva mugomo, vakaungana pana Aroni vakati, “Uya, tiitire vamwari vachatitungamirira. Kana ari munhu uyu Mozisi akatibudisa muIjipiti, hatizivi zvakaitika kwaari.” ");
INSERT INTO sna_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aroni akavapindura akati, “Bvisai mhete dzegoridhe dzakapfekwa navakadzi venyu, vanakomana venyu navanasikana venyu mugouya nadzo kwandiri.” ");
INSERT INTO sna_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Saka vanhu vose vakabvisa mhete dzavo vakauya nadzo kuna Aroni. ");
INSERT INTO sna_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Akatora zvavakamupa akaita nazvo chifananidzo chakaumbwa muchimiro chemhuru, achichiveza nembezo. Ipapo vakati, “Ava ndivo vamwari venyu, imi Israeri, vakakubudisai kubva muIjipiti.” ");
INSERT INTO sna_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aroni akati aona izvi, akavaka aritari pamberi pemhuru iya akazivisa vanhu kuti, “Mangwana kuchava nomutambo kuna Jehovha.” ");
INSERT INTO sna_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Saka zuva rakatevera vanhu vakamuka mangwanani vakabayira zvipiriso zvinopiswa uye vakapa zvipiriso zvokuwadzana. Shure kwaizvozvo vakagara pasi vakadya, vakanwa uye vakasimuka kuti vatambe. ");
INSERT INTO sna_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ipapo Jehovha akati kuna Mozisi, “Buruka, nokuti vanhu vako, vawakabudisa muIjipiti, vaora. ");
INSERT INTO sna_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Vakurumidza kutsauka pane zvandakavarayira uye vakazviitira chifananidzo chakavezwa muchimiro chemhuru. Vapfugamira pachiri uye vakabayira kwachiri uye vakati, ‘Ava ndivo vamwari venyu, imi vaIsraeri, vakakubudisai kubva muIjipiti.’ ” ");
INSERT INTO sna_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Jehovha akati kuna Mozisi, “Ndaona vanhu ava, uye vanhu vane mitsipa mikukutu. ");
INSERT INTO sna_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Zvino ndirege hangu kuti kutsamwa kwangu kupfute pamusoro pavo ndivaparadze. Ipapo iwe ndichakuita rudzi rukuru.” ");
INSERT INTO sna_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Asi Mozisi akatsvaka nyasha dzaJehovha Mwari wake, akati, “Haiwa Jehovha, kutsamwa kwenyu kungapfuta seiko pamusoro pavanhu venyu, vamakabudisa kubva muIjipiti nesimba guru uye noruoko rune simba? ");
INSERT INTO sna_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","VaIjipita vachataurireiko vachiti, ‘Akavabudisa muIjipiti nomurangariro wakaipa, kuti avauraye mumakomo uye nokuvaparadza panyika’? Dzokai henyu pakutsamwa kwenyu kunotyisa; dzokai murege kuuyisa njodzi pamusoro pavanhu venyu. ");
INSERT INTO sna_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Rangarirai varanda venyu vanaAbhurahama, Isaka naIsraeri, vamakapika kwavari nemi pachenyu muchiti, ‘Ndichaita kuti zvizvarwa zvenyu zviwande senyeredzi dzokudenga, uye ndichapa zvizvarwa zvenyu nyika iyi yose yandakavavimbisa, uye ichava nhaka yavo nokusingaperi.’ ” ");
INSERT INTO sna_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ipapo Jehovha akazvidemba uye akarega kuuyisa njodzi yaakanga oda kuisa pamusoro pavanhu vake. ");
INSERT INTO sna_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mozisi akadzoka akaburuka mugomo ane mahwendefa maviri eChipupuriro mumaoko ake. Akanga akanyorwa kumativi ose ari maviri, mberi neshure. ");
INSERT INTO sna_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mahwendefa aya rakanga riri basa raMwari; runyoro rwakanga rwuri runyoro rwaMwari, rwakatemwa pamahwendefa. ");
INSERT INTO sna_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Joshua akati anzwa mheremhere yavanhu vaidanidzira, akati kuna Mozisi, “Mune ruzha rwehondo mumusasa.” ");
INSERT INTO sna_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mozisi akapindura akati, “Harusi ruzha rwokukunda, harusi ruzha rwokukundwa; ruzha rwokuimba rwandinonzwa.” ");
INSERT INTO sna_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mozisi akati aswedera pamusasa akaona mhuru uye nokutamba, kutsamwa kwake kukavira uye akakanda mahwendefa achibva mumaoko ake, akaaputsa kuita zvidimbu zvidimbu pajinga regomo. ");
INSERT INTO sna_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Uye akatora mhuru yavakanga vagadzira ndokuipisa nomoto; ipapo akaikuya kuita upfu, akahuparadzira pamusoro pemvura uye akaita kuti vaIsraeri vainwe. ");
INSERT INTO sna_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Akati kuna Aroni, “Ko vanhu ava vakaiteiko kwauri, zvawakavatungamirira muchivi chikuru zvakadai?” ");
INSERT INTO sna_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroni akapindura akati, “Regai kutsamwa, ishe wangu. Munoziva kuti vanhu ava vanorerekera sei pakutadza. ");
INSERT INTO sna_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Vakati kwandiri, ‘Tiitire vamwari vachatitungamirira. Kana ari munhu uyu Mozisi akatibudisa kubva muIjipiti, hatizivi zvakaitika kwaari.’ ");
INSERT INTO sna_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Saka ndakati kwavari, ‘Ani naani ane zvishongo zvegoridhe, ngaabvise.’ Ipapo vakandipa goridhe ndikarikanda mumoto, uye ndipo pakabuda mhuru iyi!” ");
INSERT INTO sna_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mozisi akaona kuti vanhu vakanga vatopenga zvavo uye kuti Aroni akanga avarega vasisazvidzori uye kuti vakanga vava chiseko kuvavengi vavo. ");
INSERT INTO sna_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Saka akamira pamukova wokupinda nawo mumusasa akati, “Ani naani ari kurutivi rwaJehovha, ngaauye kwandiri.” Uye vaRevhi vose vakaenda kwaari. ");
INSERT INTO sna_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ipapo akati kwavari, “Zvanzi naJehovha Mwari waIsraeri, ‘Murume mumwe nomumwe ngaapakate munondo parutivi rwake. Mufambe mumusasa kubva kuno rumwe rutivi kusvika kuno rumwe, mumwe nomumwe achiuraya hama yake neshamwari yake nomuvakidzani wake.’ ” ");
INSERT INTO sna_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","VaRevhi vakaita sezvavakarayirwa naMozisi, uye nomusi uyo vanhu zviuru zvitatu vakafa. ");
INSERT INTO sna_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ipapo Mozisi akati, “Imi matsaurirwa Jehovha nhasi, nokuti makanga muchirwa navanakomana venyu uye nehama dzenyu, uye akuropafadzai nhasi.” ");
INSERT INTO sna_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Fume mangwana Mozisi akati kuvanhu, “Maita chitadzo chikuru. Asi zvino ndichaenda kuna Jehovha; zvimwe ndingagona kukuitirai yananiso nokuda kwechivi chenyu.” ");
INSERT INTO sna_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Saka Mozisi akadzokera kuna Jehovha akati, “Haiwa vanhu ava vaita chivi chikuru sei! Vazviitira vamwari vegoridhe. ");
INSERT INTO sna_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Asi zvino, ndapota hangu varegererei chivi chavo, asi kana zvisina kudaro, ipapo ndidzimei henyu mubhuku ramakanyora.” ");
INSERT INTO sna_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Jehovha akapindura Mozisi akati, “Ani naani anenge atadzirana neni ndichamudzima mubhuku rangu. ");
INSERT INTO sna_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Zvino chienda, tungamirira vanhu kunzvimbo yandakataura nezvayo, uye mutumwa wangu achakutungamirirai. Kunyange zvakadaro, nguva yokuti ndirange painosvika, ndichavaranga nokuda kwechivi chavo.” ");
INSERT INTO sna_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Uye Jehovha akarova vanhu nedenda nokuda kwezvavakaita nemhuru yakaitwa naAroni. ");
INSERT INTO sna_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ipapo Jehovha akati kuna Mozisi, “Ibva panzvimbo ino, iwe navanhu vawakabudisa kubva muIjipiti uye ukwidze kunyika yandakavimbisa nemhiko kuna Abhurahama, Isaka naJakobho ndichiti, ‘Ndichaipa kuzvizvarwa zvako.’ ");
INSERT INTO sna_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ndichatuma mutumwa pamberi pako agodzinga vaKenani, vaAmori, vaHiti, vaPerezi, vaHivhi navaJebhusi. ");
INSERT INTO sna_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kwidzai kunyika inoyerera mukaka nouchi. Asi ini handiendi nemi, nokuti muri vanhu vane mitsipa mikukutu uye ndingazokuparadzai munzira.” ");
INSERT INTO sna_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Vanhu vakati vachinzwa mashoko anotambudza aya, vakatanga kuchema uye hapana munhu akashonga zvinoyevedza. ");
INSERT INTO sna_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nokuti Jehovha akanga ati kuna Mozisi, “Taurira vaIsraeri uti, ‘Muri vanhu vane mitsipa mikukutu. Kana dai ndingaende nemi kunyange kwenguva duku, ndingakuparadzai. Zvino bvisai zvishongo zvenyu uye ini ndichafunga zvokuita nemi.’ ” ");
INSERT INTO sna_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Saka vaIsraeri vakabvisa zvishongo zvavo pagomo reHorebhi. ");
INSERT INTO sna_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Zvino Mozisi aisitora tende achiridzika kunze kwomusasa kachinhambwe, achiti ndiro “tende rokusangana.” Munhu upi zvake ainge ane chaanoda kubvunza kuna Jehovha aienda kuTende Rokusangana kunze kwomusasa. ");
INSERT INTO sna_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Uye pose paibuda Mozisi achienda kutende, vanhu vose vaisimuka vachibva vamira pamikova yamatende avo, vakatarira Mozisi kusvikira apinda mutende. ");
INSERT INTO sna_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kana Mozisi apinda mutende, shongwe yegore yaiburuka yobva yamira pamukova, Jehovha achitaura naMozisi. ");
INSERT INTO sna_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Vanhu vaiti vangoona shongwe yegore pamukova wokupinda mutende, vose vaimira vobva vanamata, mumwe nomumwe pamukova wetende rake. ");
INSERT INTO sna_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Jehovha aizotaura naMozisi uso nouso, somunhu anotaura neshamwari yake. Ipapo Mozisi aizodzokera kumusasa, asi mubatsiri wake Joshua mwanakomana waNuni akanga asingabudi mutende. ");
INSERT INTO sna_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mozisi akati kuna Jehovha, “Imi manga muchiti kwandiri, ‘Tungamirira vanhu ava,’ asi hamusati mandizivisa wamuchandituma naye. Manga muchingoti, ‘Ndinokuziva nezita rako uye wawana nyasha kwandiri.’ ");
INSERT INTO sna_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kana muchifadzwa neni, ndidzidzisei nzira dzenyu kuitira kuti ndigokuzivai uye ndirambe ndichiwana nyasha kwamuri. Rangarirai kuti rudzi urwu vanhu venyu.” ");
INSERT INTO sna_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Jehovha akapindura akati, “Kuvapo kwangu kuchaenda newe, uye ndichakupa zororo.” ");
INSERT INTO sna_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ipapo Mozisi akati kwaari, “Kana Kuvapo kwenyu kusingaendi nesu, musatibvisa pano. ");
INSERT INTO sna_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Vanhu vachaziva sei kuti munofadzwa neni uye navanhu venyu kana musina kuenda nesu? Chiizve chicharatidza mutsauko pakati pangu navanhu venyu navamwe vanhu vose vari pamusoro penyika?” ");
INSERT INTO sna_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Uye Jehovha akati kuna Mozisi, “Ndichaita chinhu ichocho chawakumbira, nokuti ndinofadzwa newe uye ndinokuziva nezita.” ");
INSERT INTO sna_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ipapo Mozisi akati, “Zvino ndiratidzei kubwinya kwenyu.” ");
INSERT INTO sna_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Uye Jehovha akati, “Ndichaita kuti kunaka kwangu kupfuure napamberi pako, uye ndichaparidza zita rangu, iro Jehovha, pamberi pako. Ndichanzwira nyasha iye wandichanzwira nyasha, uye ndichanzwira tsitsi uyo wandichanzwira tsitsi.” ");
INSERT INTO sna_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Akati, “Asi haugoni kuona chiso changu, nokuti hapana munhu angandiona uye akararama.” ");
INSERT INTO sna_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ipapo Jehovha akati, “Pane nzvimbo iri pedyo neni paungamira padombo. ");
INSERT INTO sna_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Panopfuura kubwinya kwangu, ndichakuisa mumukaha wedombo uye ndichakufukidza noruoko rwangu kusvikira ndapfuura. ");
INSERT INTO sna_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ipapo ndichabvisa ruoko rwangu uye uchaona shure kwangu; asi chiso changu hachifaniri kuonekwa.” ");
INSERT INTO sna_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Jehovha akati kuna Mozisi, “Veza matombo maviri amahwendefa akaita seokutanga, uye ndichanyora paari mashoko akanga ari pamahwendefa okutanga, awakaputsa. ");
INSERT INTO sna_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ugadzirire mangwanani, uye ipapo ugouya pamusoro peGomo reSinai. Uzviise kwandiri iwe ipapo pamusoro pegomo. ");
INSERT INTO sna_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Hapana munhu anofanira kuuya newe kana kuonekwa papi zvapo pamusoro peGomo; kunyange makwai kana mombe zvinopfuura pamberi pegomo.” ");
INSERT INTO sna_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Saka Mozisi akaveza mahwendefa maviri amabwe akaita seokutanga uye akakwira pamusoro pegomo reSinai mangwanani-ngwanani, sezvaakanga arayirwa naJehovha; uye akatakura mahwendefa maviri amabwe mumaoko ake. ");
INSERT INTO sna_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ipapo Jehovha akaburuka kwaari ari mugore akamira naye ipapo uye akazivisa zita rake, Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Uye akapfuura napamberi paMozisi, achizivisa achiti, “Jehovha, Jehovha, Mwari ane tsitsi nenyasha, anononoka kutsamwa, azere norudo uye akatendeka, ");
INSERT INTO sna_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","anoitira rudo kuzviuru zvamazana, uye achikanganwira zvakaipa, kumukira nechivi. Asi haaregi ane mhosva asingarangwi; anoranga vana navana vavo nokuda kwechivi chamadzibaba avo kusvikira kuchizvarwa chechitatu nechechina.” ");
INSERT INTO sna_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mozisi akakotamira pasi akanamata. ");
INSERT INTO sna_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Akati, “Haiwa Jehovha, kana ndawana nyasha pamberi penyu, ipapo Jehovha ngaaende nesu. Kunyange vanhu ava vane mitsipa mikukutu, regererai henyu kuipa kwedu nechivi chedu, uye mutitore senhaka yenyu.” ");
INSERT INTO sna_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ipapo akati, “Ndava kuita sungano newe. Ndichaita zvishamiso pamberi pavanhu vako zvisina kumboitwa kare mundudzi dzipi zvadzo munyika yose. Vanhu vaunogara pakati pavo vachaona kuti basa randichakuitira ini, Jehovha rinotyisa sei. ");
INSERT INTO sna_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Uteerere zvandinokurayira nhasi. Ndichadzinga pamberi pako vaAmori, vaKenani, vaHiti, vaPerezi, vaHivhi navaJebhusi. ");
INSERT INTO sna_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Uchenjerere kuti urege kuita sungano naavo vagere munyika yamunoenda kuti varege kuva musungo pakati penyu. ");
INSERT INTO sna_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Putsirai aritari dzavo pasi, pwanyai matombo avo anoyera uye muteme matanda avo aAshera. ");
INSERT INTO sna_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Musanamata vamwe vamwari vapi zvavo, nokuti Jehovha, iye ane zita rinonzi Godo, ndiye Mwari ane godo. ");
INSERT INTO sna_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Uchenjerere kuti urege kuita sungano naavo vanogara munyika; nokuti pavanenge voita ufeve hwavo kuna vamwari vavo uye vakabayira kwavari, vachakukokai uye muchadya zvibayiro zvavo. ");
INSERT INTO sna_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Uye pamunosarudza vamwe vanasikana vavo kuti vave vakadzi vavanakomana venyu uye vanasikana avo vakaita ufeve navamwari vavo, vachatungamirira vanakomana venyu kuita zvimwe chetezvo. ");
INSERT INTO sna_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Musaita zvifananidzo zvakaumbwa. ");
INSERT INTO sna_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Mupemberere Mutambo weZvingwa Zvisina Mbiriso. Mudye chingwa chisina mbiriso kwamazuva manomwe, sezvandakurayirai. Muite izvi panguva yakatarwa mumwedzi waAbhibhi, nokuti mumwedzi iwoyo makabuda muIjipiti. ");
INSERT INTO sna_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Chibereko chose chinotanga kuzarura chizvaro ndechangu, kusanganisira matangwe ose makono ezvipfuwo zvako, dzingava mombe kana makwai. ");
INSERT INTO sna_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Udzikinure dangwe rembongoro negwayana, asi kana usingaridzikinuri, urivhune mutsipa waro. Udzikinure matangwe ose kuvanakomana venyu. “Hapana munhu anofanira kumira pamberi pangu asina chinhu. ");
INSERT INTO sna_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Mubate basa mazuva matanhatu, asi nezuva rechinomwe munofanira kuzorora; kunyange munguva dzokurima nedzokukohwa munofanira kuzorora. ");
INSERT INTO sna_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mupemberere Mutambo weMavhiki nezvibereko zvokutanga zvegorosi yakohwewa, uye Mutambo woKuunganidza pakupera kwegore. ");
INSERT INTO sna_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Katatu pagore, varume vose vanofanira kumira pamberi paIshe Jehovha, Mwari waIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ndichadzinga ndudzi pamberi penyu uye ndichakurisa nyika yenyu, uye hakuna munhu achachiva nyika yenyu pamunokwidzako katatu gore rimwe nerimwe, kuti mumire pamberi paJehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Musapa kwandiri ropa rezvibayiro pamwe chete nechinhu chipi zvacho chine mbiriso, uye musarega chimwe chezvibayiro zvoMutambo wePasika chichisara kusvikira mangwanani. ");
INSERT INTO sna_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Muuyise zvakaisvonaka zvezvibereko zvevhu renyu zvokutanga kuimba yaJehovha Mwari wenyu. “Musabika mbudzana mumukaka wamai vayo.” ");
INSERT INTO sna_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ipapo Jehovha akati kuna Mozisi, “Nyora mashoko aya, nokuti maererano namashoko aya ndaita sungano newe uye neIsraeri.” ");
INSERT INTO sna_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mozisi akanga ariko kuna Jehovha kwamazuva makumi mana nousiku makumi mana, asingadyi chingwa kana kunwa mvura. Uye akanyora pamahwendefa mashoko esungano, iyo Mirayiro Gumi. ");
INSERT INTO sna_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mozisi akati aburuka muGomo reSinai aine mahwendefa maviri eChipupuriro mumaoko ake, akanga asingazivi kuti chiso chake chaibwinya nokuti akanga ataura naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aroni navaIsraeri vose pavakaona Mozisi, chiso chake chakanga chichibwinya, uye vakatya kuswedera pedyo naye. ");
INSERT INTO sna_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Asi Mozisi akavadana; uye Aroni navatungamiri vose vavanhu vakadzokera kwaari, uye akataura navo. ");
INSERT INTO sna_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Shure kwaizvozvo vaIsraeri vose vakaswedera pedyo naye akavapa mirayiro yose yaakanga apiwa naJehovha muGomo reSinai. ");
INSERT INTO sna_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mozisi akati apedza kutaura navo, akaisa chifukidzo pachiso chake. ");
INSERT INTO sna_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Asi pose paaipinda paKuvapo kwaJehovha kuti ataure naye, aibvisa chifukidzo kusvikira abuda kunze. Uye aiti paaibuda achiudza vaIsraeri zvaainge arayirwa, ");
INSERT INTO sna_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","vaiona kuti chiso chake chakanga chichibwinya. Ipapo Mozisi aizoisazve chifukidzo pachiso chake kusvikira apinda kundotaura naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mozisi akaunganidza ungano yose yavaIsraeri akati kwavari, “Izvi ndizvo zvinhu zvamakarayirwa naJehovha kuti muite: ");
INSERT INTO sna_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mubate basa, mazuva matanhatu, asi zuva rechinomwe richava zuva dzvene kwamuri, Sabata rokuzorora kuna Jehovha. Ani naani anoita basa ripi zvaro pazuva iro anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Musabatidze moto panzvimbo ipi zvayo yamugere pazuva reSabata.” ");
INSERT INTO sna_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mozisi akati kuungano yose yavaIsraeri, “Izvi ndizvo zvakarayirwa naJehovha: ");
INSERT INTO sna_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kubva pane zvamunazvo, mutore chipiriso chaJehovha. Ani naani anoda ngaauyise kuna Jehovha chipiriso: “chegoridhe, sirivha uye nendarira; ");
INSERT INTO sna_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","wuru yebhuruu, pepuru netsvuku uye nomucheka wakaisvonaka; mvere dzembudzi; ");
INSERT INTO sna_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","matehwe amakondobwe akapendwa zvitsvuku namatehwe emombe dzomugungwa; matanda omuunga; ");
INSERT INTO sna_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta omuorivhi emwenje; zvinonhuhwira zvamafuta okuzodza uye namafuta anonhuhwira kwazvo; ");
INSERT INTO sna_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mabwe eonikisi namamwe mabwe anokosha okuisa paefodhi nechidzitiro chechipfuva. ");
INSERT INTO sna_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Vose vane umhizha pakati penyu ngavauye vazogadzira zvinhu zvose zvakarayirwa naJehovha: ");
INSERT INTO sna_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“tabhenakeri netende rayo uye nechifukidzo chayo, zvikorekedzo, mapuranga, mbariro, mapango nezvigadziko; ");
INSERT INTO sna_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","areka namapango ayo, chifunhiro chokuyananisa uye nechidzitiro chinochidzivirira; ");
INSERT INTO sna_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tafura namapango ayo uye midziyo yayo yose uye nechingwa choKuratidza; ");
INSERT INTO sna_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","chigadziko chomwenje nenhumbi dzacho, mwenje namafuta omwenje; ");
INSERT INTO sna_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","aritari yezvinonhuhwira namapango ayo, mafuta okuzodza uye nezvinonhuhwira kwazvo; chidzitiro chapamukova wokupinda kutabhenakeri; ");
INSERT INTO sna_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","aritari yezvipiriso zvinopiswa pamwe chete nechiparo chacho chendarira, mapango ayo nemidziyo yayo yose; mudziyo wokushambira wendarira nechigadziko chawo; ");
INSERT INTO sna_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","zvidzitiro zvaparuvazhe namatanda azvo nezvigadziko, uye chidzitiro chomukova wokupinda paruvazhe; ");
INSERT INTO sna_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","hoko dzetende retabhenakeri uye dzeparuvazhe, netambo dzacho; ");
INSERT INTO sna_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nguo dzakarukwa dzinopfekwa pakushumira munzvimbo tsvene, zvose nguo tsvene yaAroni muprista nenguo dzavanakomana vake pavanoshumira savaprista.” ");
INSERT INTO sna_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ipapo ungano yose yavaIsraeri yakabva pamberi paMozisi, ");
INSERT INTO sna_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","uye munhu wose aida uye akasundwa nomwoyo wake akauya nechipiriso kuna Jehovha chebasa rapaTende Rokusangana, noushumiri hwayo hwose, nezvenguo tsvene. ");
INSERT INTO sna_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Vose vakanga vachida, zvose varume navakadzi, vakauya nezvishongo zvegoridhe zvemhando dzose zvaiti: zvikorekedzo, mhete dzenzeve, mhete uye nezvishongo zvoukomba. Vose vakapa goridhe ravo sechipiriso chokuninira kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Munhu wose akanga aine wuru yebhuruu, pepuru kana tsvuku kana mucheka wakaisvonaka, kana mvere dzembudzi, matehwe amakondobwe akapendwa zvitsvuku kana matehwe emombe dzomugungwa, vakauya nazvo. ");
INSERT INTO sna_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Vaya vaipa chipiriso chesirivha kana ndarira vakauya nazvo sechipiriso kuna Jehovha, uye vose vaiva namatanda omuunga echikamu chipi zvacho chebasa vakauya nawo. ");
INSERT INTO sna_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mukadzi wose aigona kuruka akaruka namaoko ake uye akauyisa zvaakanga aruka, wuru yebhuruu, pepuru kana tsvuku kana mucheka wakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Uye vakadzi vose vaida zvavo uye vaiva nounyanzvi hwokuruka, vakaruka mvere dzembudzi. ");
INSERT INTO sna_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Vatungamiriri vakauya namabwe eonikisi namamwewo mabwe kuti azoiswa paefodhi napachidzitiro chechipfuva. ");
INSERT INTO sna_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Vakauyawo nezvinonhuhwira namafuta omuorivhi emwenje uye namafuta okuzodza namafuta anonhuhwira kwazvo. ");
INSERT INTO sna_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","VaIsraeri vose, varume navakadzi vakanga vachida havo, vakavigira Jehovha zvipiriso zvokupa nokuzvisarudzira zvebasa rose rakanga rarayirwa Mozisi naJehovha kuti vaite. ");
INSERT INTO sna_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ipapo Mozisi akati kuvaIsraeri, “Tarirai, Jehovha asarudza Bhezareri mwanakomana waUri, mwanakomana waHuri, worudzi rwaJudha, ");
INSERT INTO sna_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","uye amuzadza noMweya waMwari, nenjere, nokugona uye noruzivo rwemhando dzose dzoumhizha, ");
INSERT INTO sna_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kuti aite zvinhu zvinoyevedza zvebasa regoridhe, sirivha nendarira, ");
INSERT INTO sna_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kuveza nokuronga mabwe, kushanda mukuveza matanda uye nokuita mhando dzose dzoumhizha. ");
INSERT INTO sna_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Uye apa vose vari vaviri iye naOhoriabhu mwanakomana waAhisamaki, worudzi rwaDhani kugona kudzidzisa vamwe. ");
INSERT INTO sna_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Avazadza nenjere dzokuita mhando dzose dzebasa semhizha, vasoni, navasuki vewuru yebhuruu, pepuru netsvuku uye nomucheka wakaisvonaka, vose zvavo imhizha huru navasoni.” ");
INSERT INTO sna_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Saka Bhezareri, Ohoriabhu uye nomunhu wose wounyanzvi apiwa unyanzvi naJehovha uye kugona kuziva maitirwo ebasa rokuvaka imba tsvene ngavaite basa sezvakarayirwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ipapo Mozisi akadana Bhezareri naOhoriabhu uye nomunhu wose wounyanzvi uyo akapiwa kugona naJehovha uye akanga achida hake kuuya kuzoshanda basa. ");
INSERT INTO sna_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Vakagamuchira kubva kuna Mozisi zvipo zvose zvakanga zvauya navaIsraeri kuti zvishandiswe pabasa rokuvaka imba tsvene. Uye vanhu vakaramba vachiuyisa zvipo zvokupa nokuzvisarudzira mangwanani oga oga. ");
INSERT INTO sna_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Saka varume vose voumhizha vakanga vachiita basa rose rapaimba tsvene vakasiya basa ravo ");
INSERT INTO sna_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","vakati kuna Mozisi, “Vanhu vari kuuya nezvakawandisa zvokuitisa basa rakarayirwa naJehovha kuti riitwe.” ");
INSERT INTO sna_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ipapo Mozisi akarayira uye vakatuma shoko iri pakati pomusasa wose vachiti, “Ngakurege kuva nomurume kana mukadzi achaitazve chimwe chinhu sechipo chenzvimbo tsvene.” Nokudaro vanhu vakadziviswa kuuyisa zvimwe, ");
INSERT INTO sna_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","nokuti zvavakanga vatova nazvo zvakanga zvatowandisa pane zvaidiwa kuita basa rose. ");
INSERT INTO sna_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Varume vose vounyanzvi vakaita tabhenakeri nezvidzitiro gumi zvemicheka yakarukwa zvakaisvonaka newuru yebhuruu, pepuru netsvuku, namakerubhi akasonerwa mazviri nemhizha ino unyanzvi. ");
INSERT INTO sna_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Zvidzitiro zvose zvakanga zvakaenzana, zvakareba makubhiti makumi maviri namasere uye makubhiti mana paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Vakabatanidza zvimwe zvidzitiro zvishanu pamwe chete uye vakaita zvimwe chetezvo pane zvimwe zvishanu. ");
INSERT INTO sna_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ipapo vakaita zvishwe zvomucheka webhuruu zvichitevedza mupendero wechidzitiro chokumucheto mumubatanidzwa mumwe chete, zvimwe chetezvo zvikaitwawo kune chimwe chidzitiro chokumucheto. ");
INSERT INTO sna_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Vakaitawo zvishwe makumi mashanu pachidzitiro chimwe chete uye zvishwe makumi mashanu pachidzitiro chokupedzisira chezvimwe zvakabatanidzwa nezvishwe zvakanga zvakatarisana. ");
INSERT INTO sna_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ipapo vakaita zvikorekedzo zvegoridhe makumi mashanu ndokuzvishandisa kusonanidza zvibatanidzwa zviviri zvezvidzitiro pamwe chete kuitira kuti tabhenakeri ive chinhu chimwe chete. ");
INSERT INTO sna_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Vakaita zvidzitiro zvemvere dzembudzi zvetende rapamusoro petabhenakeri, gumi nechimwe pamwe chete. ");
INSERT INTO sna_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Zvidzitiro zvose zviri gumi nechimwe zvakanga zvakaenzana, makubhiti makumi matatu pakureba uye makubhiti mana paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Vakabatanidza zvidzitiro zvishanu pamwe chete kuti zvive mubatanidzwa mumwe chete, uye zvimwe zvitanhatu kuti zvive pamwe chete. ");
INSERT INTO sna_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ipapo vakaita zvishwe makumi mashanu zvaitevedza mupendero wechidzitiro chokupedzisira muchibatanidzwa chimwe chete uyewo zvichitevedza mupendero wechidzitiro chokupedzisira muno mumwe mubatanidzwa. ");
INSERT INTO sna_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Vakaita zvikorekedzo zvendarira makumi mashanu kuti zvisunganidze tende pamwe chete zvive sechinhu chimwe chete. ");
INSERT INTO sna_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ipapo vakagadzirira tende chifukidzo chamatehwe amakondobwe akapendwa zvitsvuku, uye pamusoro pacho chifunhiro chamatehwe emombe dzomugungwa. ");
INSERT INTO sna_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Vakaita mapuranga akamiswa amatanda omuunga etabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Puranga rimwe nerimwe rakanga rakareba makubhiti gumi uye kubhiti rimwe nehafu paupamhi, ");
INSERT INTO sna_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","nembambo mbiri dzakamiswa dzakatarisana. Vakaita mapuranga ose etabhenakeri nenzira iyi. ");
INSERT INTO sna_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Vakaita mapuranga makumi maviri kurutivi rwezasi kwetabhenakeri ");
INSERT INTO sna_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","uye vakaita makumi mana ezvigadziko zvesirivha kuti zviende pasi pazvo, zvigadziko zviviri pasi pepuranga rimwe nerimwe, chimwe chete pasi pembato imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kuno rumwe rutivi, rutivi rwokumusoro kwetabhenakeri, vakaita mapuranga makumi maviri ");
INSERT INTO sna_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","uye makumi mana ezvigadziko zvesirivha, zviviri zviri pasi pepuranga rimwe nerimwe. ");
INSERT INTO sna_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Vakaita mapuranga matanhatu okumucheto cheto, iko kumavirira kwetabhenakeri, ");
INSERT INTO sna_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","uye mapuranga maviri akanga akagadzirirwa makona etabhenakeri nechokumucheto cheto. ");
INSERT INTO sna_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Pamakona maviri aya mapuranga aiva maviri kubva pasi kusvikira kumusoro uye akaiswa mumhete imwe chete; ose akanga akagadzirwa zvakafanana. ");
INSERT INTO sna_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Saka pakanga pana mapuranga masere uye zvigadziko gumi nezvitanhatu zvesirivha, zviviri zviri pasi pepuranga rimwe nerimwe. ");
INSERT INTO sna_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Vakaitawo mbariro dzomuti womuunga: shanu dzamapuranga aiva pano rumwe rutivi rwetabhenakeri, ");
INSERT INTO sna_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","shanu dzaaya aiva kuno rumwe rutivi, uye shanu dzamapuranga aiva kumavirira, pamucheto cheto kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Vakaita mbariro yapakati kuitira kuti ichinjike kubva kumucheto kusvikira kumucheto pakati pamapuranga. ");
INSERT INTO sna_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Vakafukidza mapuranga negoridhe uye vakaita mhete dzegoridhe kuti dzibate mbariro. Vakafukidzawo mbariro negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Vakaita zvidzitiro zvewuru yebhuruu, pepuru netsvuku uye nomucheka wakarukwa zvakaisvonaka, namakerubhi akasonerwa pauri nemhizha ino unyanzvi. ");
INSERT INTO sna_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Vakaita matanda mana omuti womuunga vakaafukidza negoridhe. Vakaaitira zvikorekedzo zvegoridhe uye vakaumba zvigadziko zvawo zvina zvesirivha. ");
INSERT INTO sna_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Vakaita chidzitiro chomukova wokupinda mutende chewuru yebhuruu, pepuru netsvuku uye mucheka wakarukwa zvakaisvonaka, basa romuruki; ");
INSERT INTO sna_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","uye vakaita matanda mashanu nezvikorekedzo zvawo. Vakafukidza misoro yamatanda nehata dzawo negoridhe uye vakaita zvigadziko zvawo zvishanu zvendarira. ");
INSERT INTO sna_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bhezareri akaita areka yamatanda omuunga, yakareba makubhiti maviri nehafu, kubhiti rimwe nehafu paupamhi, uye kubhiti rimwe chete nehafu pakukwirira. ");
INSERT INTO sna_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Akaifukidza negoridhe rakaisvonaka, zvose mukati nokunze, uye akaita hata yegoridhe yakaipoteredza. ");
INSERT INTO sna_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Akaiumbira mhete dzegoridhe ina akadziisa pamakumbo ayo mana, nemhete mbiri pano rumwe rutivi uye dzimwe mbiri kuno rumwezve rutivi. ");
INSERT INTO sna_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ipapo akaita mapango omuti womuunga uye akaafukidza negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Uye akapinza mapango mukati memhete parutivi rweareka okuitakura nawo. ");
INSERT INTO sna_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Akagadzira chifunhiro chokuyananisa chegoridhe rakaisvonaka, makubhiti maviri nehafu pakureba uye kubhiti rimwe chete nehafu paupamhi. ");
INSERT INTO sna_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ipapo akaita makerubhi maviri negoridhe rakapambadzirwa kumacheto echifunhiro. ");
INSERT INTO sna_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Akaita kerubhi rimwe chete kurutivi rumwe chete rwokumucheto uye kerubhi rechipiri kuno rumwezve rutivi, mativi okumucheto ari maviri akaaita chinhu chimwe chete nechifunhiro. ");
INSERT INTO sna_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mapapiro amakerubhi akanga akatambanudzirwa kumusoro, achifukidza chifunhiro nomumvuri wawo. Makerubhi akanga akatarisana, akatarisa kuchifunhiro. ");
INSERT INTO sna_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Vakagadzira tafura namatanda omuunga, yakareba makubhiti maviri, uye kubhiti rimwe chete paupamhi, uye kubhiti rimwe chete nehafu pakukwirira. ");
INSERT INTO sna_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ipapo vakaifukidza negoridhe rakaisvonaka uye vakagadzira hata yegoridhe yakaipoteredza. ");
INSERT INTO sna_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Vakaiitirawo mukombero wakaipoteredza une upamhi hwakaita sechanza choruoko ndokuisa hata yegoridhe pamukombero. ");
INSERT INTO sna_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Vakaumba mhete ina dzegoridhe dzetafura uye vakadzisungirira pamakona mana, paya pakanga pana makumbo. ");
INSERT INTO sna_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mhete dzakaiswa pedyo nomukombero kuti dzibate mapango aishandiswa pakutakura tafura. ");
INSERT INTO sna_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mapango okutakura tafura akagadzirwa namatanda omuunga uye akanga akafukidzwa negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Uye vakaita nhumbi dzetafura negoridhe rakaisvonaka, ndiro dzayo, madhishi nemikombe uye nezvirongo zvayo zvokudururira zvipiriso zvinonwiwa. ");
INSERT INTO sna_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Vakagadzira chigadziko chomwenje chegoridhe rakaisvonaka uye vakaripambadzira, chigadziko nerwiriko; mikombe inenge maruva, mabukira namaruva zvaiva chinhu chimwe chete nacho. ");
INSERT INTO sna_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mapazi matanhatu akaiswa kubva kumativi echigadziko chomwenje, matatu kurutivi rumwe chete uye mamwe matatu kuno rumwe rutivi. ");
INSERT INTO sna_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Mikombe mitatu yakanga yakaumbwa seruva remuarimondi namabukira namaruva makuru zvakanga zviri pane rimwe davi, matatu padavi raitevera uye zvakanga zvakaita saizvozvo pamatavi ose ari matanhatu aibva pachigadziko chomwenje. ");
INSERT INTO sna_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Uye pamusoro pechigadziko chomwenje paiva nemikombe mina yakanga yakaumbwa seruva romuarimondi namabukira uye namaruva makuru. ");
INSERT INTO sna_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Bukira rimwe chete rakanga riri pasi pamatavi maviri okutanga aibva pachigadziko chomwenje, bukira rechipiri rakanga riri pasi pamatavi maviri aitevera, uye bukira rechitatu rakanga riri pasi pamatavi mamwezve maviri, ose ari matanhatu pamwe chete. ");
INSERT INTO sna_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mabukira namatavi zvaiva chinhu chimwe chete nechigadziko chomwenje, chegoridhe rakaisvonaka rakapambadzirwa. ");
INSERT INTO sna_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Vakaita mwenje yacho minomwe, pamwe chete nembato dzacho uye nendiro dzacho, dzegoridhe rakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Vakaita chigadziko chomwenje nenhumbi dzacho dzose kubva patarenda rimwe chete regoridhe rakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Vakaita aritari yezvinonhuhwira namatanda omuunga. Yakanga yakaenzana mativi ose ari mana, yakareba kubhiti rimwe chete uye kubhiti rimwe chete paupamhi, uye makubhiti maviri pakukwirira kwayo, nyanga dzayo dziri chinhu chimwe chete nayo. ");
INSERT INTO sna_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Vakafukidza pamusoro payo nokumativi ose uye nenyanga, negoridhe rakaisvonaka, uye vakagadzira hata yakaipoteredza. ");
INSERT INTO sna_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Vakaita mhete dzegoridhe mbiri pasi pehata, mbiri kuno rumwe rutivi, kuti dzibate mapango aishandiswa pakuitakura. ");
INSERT INTO sna_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Vakagadzira mapango omuti womuunga uye vakaafukidza negoridhe. ");
INSERT INTO sna_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Vakagadzirawo mafuta matsvene okuzodza uye nezvinonhuhwira kwazvo zvakaisvonaka, basa romuvhenganisi wezvinonhuhwira. ");
INSERT INTO sna_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Vakavaka aritari yezvipiriso zvinopiswa yamatanda omuunga, yakakwirira makubhiti matatu; yakanga yakaenzana mativi ayo mana ina makubhiti mashanu pakureba uye namakubhiti mashanu paupamhi hwayo. ");
INSERT INTO sna_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Vakagadzira runyanga pamakona mana ose zvokuti nyanga nearitari zvakanga zvava chinhu chimwe chete, uye vakafukidza aritari nendarira. ");
INSERT INTO sna_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Vakaita midziyo yayo yose nendarira, hari dzayo, foshoro dzayo, midziyo yokusasa zvibayiso zvenyama uye namakango apamoto. ");
INSERT INTO sna_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Vakaitira aritari chiparo, mumbure wendarira, kuti chive pasi pechitsiko chayo, pakati napakati pokukwirira kwearitari. ");
INSERT INTO sna_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Vakaumba mhete dzendarira kuti dzibate mapango amakona mana echiparo chendarira. ");
INSERT INTO sna_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Vakaita mapango omuti womuunga vakaafukidza nendarira. ");
INSERT INTO sna_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Vakapinza mapango mukati memhete kuitira kuti agova pamativi earitari, kuti vaitakure nawo. Vakaiita namapuranga, isina chinhu mukati. ");
INSERT INTO sna_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Vakagadzira mudziyo wokushambira wendarira uye nezvigadziko zvawo zvendarira kubva pazvionioni zvamadzimai aishumira pamukova wokupinda muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Pashure vakaita ruvazhe. Rutivi rwezasi rwakanga rwakareba makubhiti zana uye rwaiva nezvidzitiro zvomucheka wakarukwa zvakaisvonaka, ");
INSERT INTO sna_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","namatanda makumi maviri uye nezvigadziko zvendarira makumi maviri, nezvikorekedzo zvesirivha uye nezvisungo pamusoro pamatanda. ");
INSERT INTO sna_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Rutivi rwokumusorowo rwakanga runa makubhiti zana pakureba uye rwakanga rune matanda makumi maviri nezvigadziko zvendarira, ine zvikorekedzo zvesirivha nezvisungo pamusoro pamatanda. ");
INSERT INTO sna_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mucheto wokumavirira wakanga una makubhiti makumi mashanu paupamhi, uye kwaiva nezvidzitiro, namatanda gumi uye nezvigadziko gumi, nezvikorekedzo zvesirivha nezvisungo pamusoro pamatanda. ");
INSERT INTO sna_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kumucheto wokumabvazuva, wakananga kunobuda nezuva, kwaivawo noupamhi hwamakubhiti makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Zvidzitiro zvakareba makubhiti gumi namashanu zvaiva kurutivi rumwe chete rwomukova, namatanda matatu ezvigadziko zvitatu, ");
INSERT INTO sna_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","uye zvidzitiro zvakareba makubhiti gumi namashanu zvaiva kuno rumwe rutivi rwokupinda muruvazhe, namatanda matatu uye nezvigadziko zvitatu. ");
INSERT INTO sna_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Zvidzitiro zvose zvaipoteredza ruvazhe zvaiva zvomucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Zvigadziko zvamatanda zvakanga zviri zvendarira. Zvikorekedzo nezvisungo zvaiva pamatanda zvaiva zvesirivha, uye misoro yawo yakanga yakafukidzwa nesirivha; saka matanda ose oruvazhe akanga ane zvisungo zvesirivha. ");
INSERT INTO sna_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Chidzitiro chomukova wokupinda muruvazhe chaiva chewuru yebhuruu, nepepuru netsvuku uye nomucheka wakarukwa zvakaisvonaka, basa romuruki. Chakanga chakareba makubhiti makumi maviri, chakaita sechidzitiro chaparuvazhe, makubhiti mashanu kukwirira kwacho, ");
INSERT INTO sna_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","namatanda mana uye nezvigadziko zvendarira zvina. Zvikorekedzo zvazvo nezvisungo zvazvo zvaiva zvesirivha, uye misoro yacho yakanga yakafukidzwa nesirivha. ");
INSERT INTO sna_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Mbambo dzose dzetende retabhenakeri nezvaipoteredza ruvazhe zvaiva zvendarira. ");
INSERT INTO sna_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Uku ndiko kuwanda kwezvinhu zvakashandiswa patabhenakeri, iyo tabhenakeri yeChipupuriro, zvakanyorwa pakurayira kwaMozisi navaRevhi vari pasi paItamari mwanakomana waAroni, muprista. ");
INSERT INTO sna_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bhezareri mwanakomana waUri, mwanakomana waHuri, worudzi rwaJudha, akagadzira zvose zvakarayirwa Mozisi naJehovha; ");
INSERT INTO sna_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","aiva naDhoriabhu mwanakomana waAhisamaki, worudzi rwaDhani, mhizha nomusoni, uye musoni wewuru yebhuruu, pepuru netsvuku nomucheka wakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kuwanda kwegoridhe rose rakabva kuzvipiriso zvokuninira rakashandiswa pabasa rose rapaimba tsvene kwaiva matarenda makumi maviri namapfumbamwe namashekeri mazana manomwe ana makumi matatu, zvichienderana neshekeri renzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sirivha yakawanikwa yakabva kuna avo veungano vakaverengwa pakunyorwa, yaiva matarenda zana, uye chiuru chimwe namazana manomwe namakumi manomwe namashanu amashekeri, zvichienderana neshekeri renzvimbo tsvene, ");
INSERT INTO sna_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","bheka rimwe chete pamunhu, ndiyo hafu yeshekeri, zvichienderana neshekeri renzvimbo tsvene, kubva kumunhu wose akanga ayambukira kuna avo vakanga vatoverengwa, vana makore makumi maviri kana kupfuura, varume vakanga vari zviuru mazana matanhatu navatatu namazana mashanu ana makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Matarenda zana esirivha akashandiswa kugadzira zvigadziko zvenzvimbo tsvene pachidzitiro, zvigadziko zana zvaibva pamatarenda zana, tarenda rimwe chete pachigadziko chimwe nechimwe. ");
INSERT INTO sna_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Vakashandisa mashekeri chiuru chimwe chete namazana manomwe namakumi manomwe namashanu uye kuti vagadzire zvikorekedzo zvamatanda, kufukidza misoro yamatanda, uye vagadzire zvisungo zvawo. ");
INSERT INTO sna_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ndarira yakabva kuzvipiriso zvokuninira yaiva matarenda makumi manomwe namashekeri zviuru zviviri namazana mana. ");
INSERT INTO sna_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Vakaishandisa kugadzira nheyo dzomukova weTende Rokusangana, aritari yendarira, chiparo chayo chendarira nemidziyo yayo yose, ");
INSERT INTO sna_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","nheyo dzepakapoteredza ruvazhe nedzomukova warwo nembambo dzose dzetende retabhenakeri uye nezvose zvakapoteredza ruvazhe. ");
INSERT INTO sna_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kubva pawuru yebhuruu nepepuru netsvuku, vakaita nguo dzakarukwa dzoushumiri munzvimbo tsvene. Vakaitawo nguo tsvene dzaAroni, sokurayira kwakaita Jehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Vakaita efodhi yegoridhe, wuru yebhuruu, pepuru netsvuku, uye nomucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Vakapambadzira goridhe rikava marata matete uye vakagura tuwaya kuti tupfekerwe muwuru yebhuruu, yepepuru netsvuku uye mumucheka wakaisvonaka, basa remhizha ino unyanzvi. ");
INSERT INTO sna_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Vakaita zvipenga zvapapfudzi zveefodhi, zvaibatanidzwa pana mamwe makona ayo maviri, kuti isimbiswe. ");
INSERT INTO sna_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Bhanhire rayo romuchiuno rakarukwa nounyanzvi rakanga rakafanana nayo, zvaive chinhu chimwe neefodhi uye zvakagadzirwa negoridhe, newuru yebhuruu, nepepuru netsvuku nomucheka wakarukwa zvakaisvonaka, sokurayirwa kwakaitwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Vakagadzira matombo eonikisi vakaanyudza mukati mamaruva egoridhe uye vakanyora norunyoro rwokutema padombo sezvinoitwa padombo rechisimbiso ramazita avanakomana vaIsraeri. ");
INSERT INTO sna_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ipapo vakaisa pamapenga apamapfudzi eefodhi matombo echirangaridzo chavana vaIsraeri sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Vakaita chidzitiro chechipfuva, basa remhizha ino unyanzvi. Vakachiita seefodhi: negoridhe, uye wuru yebhuruu, pepuru netsvuku, uye nomucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Chakanga chakaenzana mativi acho ose ari mana, chakaenzana nechanza paurefu uye chakaenzana nechanza paupamhi uye chakapetwa kaviri. ");
INSERT INTO sna_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ipapo vakagadzira mitsara mina yamatombo anokosha pamusoro pacho. Mumutsara wokutanga makanga mune ibwe rerubhi, topazi nebheriri; ");
INSERT INTO sna_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","mumutsara wechipiri maiva netekoisi, nesafire uye neemaradhi; ");
INSERT INTO sna_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","mumutsara wechitatu maiva nejasindi, neagati uye neametisiti; ");
INSERT INTO sna_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","mumutsara wechina maiva nekirisoriti, neonikisi uye nejasipa. Akanga akagadzirwa mukati mamaruva egoridhe. ");
INSERT INTO sna_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Paiva namatombo gumi namaviri, rimwe richimirira rimwe ramazita avanakomana vaIsraeri, rimwe nerimwe rakanyorwa, sorunyoro rwakatemwa padombo sechisimbiso, chine rimwe ramazita amarudzi gumi namaviri. ");
INSERT INTO sna_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Chidzitiro chechipfuva vakachiitirawo uketani hwakarukwa negoridhe rakaisvonaka, rwakaita setambo. ");
INSERT INTO sna_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Vakaita maruva maviri egoridhe nemhete mbiri dzegoridhe, uye vakasungirira mhete idzi pana mamwe amakona maviri echidzitiro chechipfuva. ");
INSERT INTO sna_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Vakasungirira humwe uketani huviri hwegoridhe pamhete dzapamakona echidzitiro chechipfuva, ");
INSERT INTO sna_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","uye mimwe miromo youketani pamaruva maviri, zvichibatanidzwa pazvipenga zvapamapfudzi eefodhi nechemberi. ");
INSERT INTO sna_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Vakagadzira mhete dzegoridhe mbiri vakadzibatanidza namamwe makona maviri echidzitiro chechipfuva pamupendero nechomukati pedyo neefodhi. ");
INSERT INTO sna_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ipapo vakagadzira dzimwezve mhete mbiri dzegoridhe uye vakadzibatanidza nechepasi pezvipenga zvamapfudzi pamberi peefodhi, pedyo nemusono uri nechapamusoro pebhanhire romuchiuno refodhi. ");
INSERT INTO sna_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Vakasungirira mhete dzapachidzitiro chapachipfuva pamhete dzapaefodhi netambo yebhuruu, ichiibatanidza nebhanhire romuchiuno kuitira kuti chidzitiro chechipfuva chirege kubva paefodhi, sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Vakaita jasi reefodhi nomucheka webhuruu yoga, basa romuruki, ");
INSERT INTO sna_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","rakazaruka pakati pejasi sokuzaruka kwekora, uye mupendero wakapoteredza buri iri, kuitira kuti rirege kubvaruka. ");
INSERT INTO sna_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Vakaita matamba ewuru yebhuruu, nepepuru netsvuku nomucheka wakarukwa zvakaisvonaka wakapoteredza mupendero wejasi. ");
INSERT INTO sna_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Uye vakaita matare egoridhe rakaisvonaka uye vakaabatanidza achipoteredza mupendero pakati pamatamba. ");
INSERT INTO sna_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Matare namatamba akanga achipesana akapoteredza mupendero wejasi rinofanira kupfekwa pakushumira, sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Vakaitira Aroni navanakomana vake, majasi omucheka wakaisvonaka, basa romuruki, ");
INSERT INTO sna_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","uye nguwani yomucheka wakaisvonaka, bhanhire romucheka romumusoro uye nenguo dzapasi dzomucheka wakarukwa zvakaisvonaka. ");
INSERT INTO sna_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ndaza yacho yakanga iri yomucheka wakarukwa zvakaisvonaka wewuru yebhuruu, pepuru netsvuku, basa romuruki, sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Vakagadzira ndiro, korona tsvene, yegoridhe rakaisvonaka uye yakanyorwa pairi, sorunyoro rwapachisimbiso, kuti: mutsvene kuna jehovha. ");
INSERT INTO sna_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ipapo vakasungirira tambo yebhuruu pairi kuti ibatanidzwe nenguwani, sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Saka basa rose patabhenakeri, Tende Rokusangana, rakapera. VaIsraeri vakaita zvinhu zvose sezvakanga zvarayirwa naJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ipapo vakauya netabhenakeri kuna Mozisi: tende nenhumbi dzaro dzose, zvikorekedzo zvayo, mapuranga, mbariro, matanda nezvigadziko; ");
INSERT INTO sna_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","chifukidzo chamatehwe amakondobwe akapendwa zvitsvuku, chifukidzo chamatehwe emombe dzomugungwa nezvidzitiro zvokudzivirira; ");
INSERT INTO sna_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","areka yeChipupuriro namapango ayo nechifunhiro chokuyananisa; ");
INSERT INTO sna_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tafura nemidziyo yayo dzose nechingwa choKuratidza; ");
INSERT INTO sna_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","zvigadziko zvomwenje zvegoridhe rakaisvonaka nemitsara yacho yemwenje, nhumbi dzayo dzose, namafuta omwenje; ");
INSERT INTO sna_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","aritari yegoridhe, mafuta okuzodza, zvinonhuhwira kwazvo nechidzitiro chapamukova wetende; ");
INSERT INTO sna_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","aritari yendarira, chiparo chayo chendarira, mapango ayo nemidziyo yayo yose; dhishi nechigadziko charo; ");
INSERT INTO sna_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","zvidzitiro zvoruvazhe namatanda nezvigadziko zvarwo, uye chidzitiro chapamukova woruvazhe; tambo nembambo dzetende dzaparuvazhe; midziyo yose yetabhenakeri, Tende Rokusangana; ");
INSERT INTO sna_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","uye jasi rakarukwa rinopfekwa pakushumira munzvimbo tsvene, zvose nguo tsvene dzaAroni muprista nenguo dzavanakomana vake pavanoshumira savaprista. ");
INSERT INTO sna_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","VaIsraeri vakanga vaita basa rose sokurayira kwaJehovha kuna Mozisi. ");
INSERT INTO sna_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mozisi akaongorora basa uye akaona kuti vakanga variita sokurayira kwakanga kwaita Jehovha. Saka Mozisi akavaropafadza. ");
INSERT INTO sna_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Dzika tabhenakeri, Tende Rokusangana, pazuva rokutanga romwedzi wokutanga. ");
INSERT INTO sna_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Uise areka yeChipupuriro mairi uye ugofukidza areka nechidzitiro. ");
INSERT INTO sna_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Upinze tafura ugoisa zvinhu zvayo pairi. Ipapo ugopinza chigadziko chomwenje ugomisa mwenje yacho. ");
INSERT INTO sna_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Uise aritari yezvinonhuhwira yegoridhe pamberi peareka yechipupuriro uye ugoisa chidzitiro pamukova wokupinda mutabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Uise aritari yezvipiriso zvinopiswa pamberi pomukova wokupinda kutabhenakeri, Tende Rokusangana; ");
INSERT INTO sna_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","uise dhishi pakati peTende Rokusangana nearitari ugoisa mvura mariri. ");
INSERT INTO sna_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ugadzire ruvazhe rwakaipoteredza uye ugoisa chidzitiro pamukova woruvazhe. ");
INSERT INTO sna_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Utore mafuta okuzodza ugozodza tabhenakeri nezvinhu zvose zvirimo; uinatse nemidziyo yayo yose, uye ichava tsvene. ");
INSERT INTO sna_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ipapo ugozodza aritari yezvipiriso zvinopiswa nemidziyo yayo yose; unatse aritari, uye ichava tsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Uzodze dhishi nechigadziko charo ugozvinatsa. ");
INSERT INTO sna_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Uuye naAroni navanakomana vake kumukova weTende Rokusangana ugovashambidza nemvura. ");
INSERT INTO sna_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ipapo ugopfekedza Aroni nguo tsvene, umuzodze uye ugomunatsa kuti agondishumira somuprista. ");
INSERT INTO sna_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Uuyise vanakomana vake ugovapfekedza majasi. ");
INSERT INTO sna_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Uvazodze sokuzodza kwawaita baba vavo, kuti vagondishumira savaprista. Kuzodzwa kwavo kuchava kwouprista hucharamba huripo kuzvizvarwa zvinotevera.” ");
INSERT INTO sna_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mozisi akaita zvose sezvaakarayirwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Saka tabhenakeri yakamiswa pazuva rokutanga romwedzi wokutanga mugore rechipiri. ");
INSERT INTO sna_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mozisi akati amisa tabhenakeri, akaisa zvigadziko panzvimbo yazvo, akadzika mapuranga, akapinza mbariro uye akamisa matanda. ");
INSERT INTO sna_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ipapo akatambanudza tende akariisa pamusoro petabhenakeri ndokuisa chifukidzo pamusoro petende, sokurayirwa kwaakaitwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Akatora Chipupuriro akachiisa muareka, akabatanidza mapango paareka uye akaisa chifunhiro chokuyananisa pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ipapo akauyisa areka mutabhenakeri ndokuturika chidzitiro chokufukidzira akafukidza areka yeChipupuriro, sokurayira kwakaita Jehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mozisi akaisa tafura muTende Rokusangana nechokurutivi rwokumusoro kwetabhenakeri kunze kwechidzitiro ");
INSERT INTO sna_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","uye akaisa chingwa pamusoro payo pamberi paJehovha, sokurayirwa kwaakaitwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Akaisa chigadziko chomwenje muTende Rokusangana chakatarisana netafura nechokurutivi rwezasi rwetabhenakeri ");
INSERT INTO sna_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","uye akamisa mwenje pamberi paJehovha, sokurayirwa kwaakaitwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mozisi akaisa aritari yegoridhe muTende Rokusangana pamberi pechidzitiro, ");
INSERT INTO sna_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","uye akapisa zvinonhuhwira pairi, sokurayirwa kwaakaitwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ipapo akaisa chidzitiro pamukova wetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Akamisa aritari yezvipiriso zvinopiswa pedyo nomukova wetabhenakeri, Tende Rokusangana, akapa pairi zvipiriso zvinopiswa nezvipiriso zvezviyo, sokurayirwa kwaakaitwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Akaisa dhishi pakati peTende Rokusangana nearitari uye akaisa mvura yokushamba mariri, ");
INSERT INTO sna_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","uye Mozisi naAroni navanakomana vake vakaishandisa kushamba maoko avo netsoka dzavo. ");
INSERT INTO sna_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Vaishamba pose pavaipinda muTende Rokusangana kana kuswedera paaritari, sokurayirwa kwakaitwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ipapo Mozisi akaita ruvazhe rwakapoteredza tabhenakeri nearitari uye akaturika chidzitiro pamukova wokupinda muruvazhe. Nokudaro Mozisi akapedza basa. ");
INSERT INTO sna_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ipapo gore rakafukidza Tende Rokusangana, uye kubwinya kwaJehovha kwakazadza tabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mozisi haana kugona kupinda muTende Rokusangana nokuti gore rakanga ragara pariri, uye kubwinya kwaJehovha kwakazadza tabhenakeri. ");
INSERT INTO sna_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mukufamba kwose kwavaIsraeri, pose paisimuka gore kubva pamusoro petabhenakeri, ivo vaisimuka vachienda; ");
INSERT INTO sna_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","asi kana gore risina kubva, vakanga vasingafambi, kusvikira pazuva rarinosimuka. ");
INSERT INTO sna_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Saka gore raJehovha raiva pamusoro petabhenakeri masikati; uye moto wakanga uri mugore usiku, pamberi peimba yose yaIsraeri panguva yokufamba kwavo kwose.");
INSERT INTO sna_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Jehovha akadana Mozisi akataura naye ari muTende Rokusangana akati, ");
INSERT INTO sna_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Taura kuvana vaIsraeri uti kwavari, ‘Kana munhu upi zvake pakati penyu achiuya nechipiriso kuna Jehovha ngaauye nechipiriso chezvipfuwo, zvemombe kana zvamakwai. ");
INSERT INTO sna_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Kana chipiriso chake chiri chinopiswa chinobva mudanga remombe, ngaape chikono chisina kuremara. Ngaachibayire pamusuo weTende Rokusangana kuti chigamuchirwe pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Anofanira kuisa ruoko rwake pamusoro pechibayiro chinopiswa uye chichagamuchirwa chakamumirira iye kuti chimuyananisire. ");
INSERT INTO sna_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ngaabaye hando diki pamberi paJehovha uye ipapo vanakomana vaAroni vaprista vachauya neropa vagorisasa paaritari kumativi ose pamusuo wokupinda nawo muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Anofanira kuvhiya chipiriso chinopiswa agochicheka kuita zvidimbu zvidimbu. ");
INSERT INTO sna_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Vanakomana vaAroni, muprista, vanofanira kuisa moto paaritari vagoronga huni pamoto. ");
INSERT INTO sna_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ipapo vanakomana vaAroni vaprista vacharonga zvidimbu zvenyama, zvichisanganisira musoro namafuta pamusoro pehuni dzinenge dzichipfuta paaritari. ");
INSERT INTO sna_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Anofanira kusuka nyama yomukati namakumbo nemvura, uye muprista agopisa zvose paaritari. Chipiriso chinopiswa, chipiriso chinogadzirwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Kana chipiriso chiri chinopiswa, chinobva muzvipfuwo, chiri chegwai kana chembudzi, anofanira kupa chikono chisina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ngaachibayire parutivi rwearitari nechokumusoro pamberi paJehovha, vanakomana vaAroni vaprista vagosasa ropa kumativi ose earitari. ");
INSERT INTO sna_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Anofanira kucheka nyama muzvidimbu uye muprista achaironga pamwe chete nomusoro namafuta pamusoro pehuni dzinenge dzichipfuta paaritari. ");
INSERT INTO sna_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Anofanira kusuka nyama yomukati namakumbo nemvura, uye muprista anofanira kuuyisa zvose agozvipisa pamusoro pearitari. Chibayiro chinopiswa, chibayiro chakagadzirwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Kana chipiriso chake kuna Jehovha chiri chipiriso chinopiswa cheshiri, ngaape njiva kana hangaiwa ichiri diki. ");
INSERT INTO sna_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Muprista achaiisa paaritari agodambura musoro, oipisa paaritari; ropa rayo richaerera parutivi pearitari. ");
INSERT INTO sna_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ngaabvise chihururu neminhenga agozvikanda kumabvazuva kwearitari kunenge kune madota. ");
INSERT INTO sna_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Achaibvambura namapapiro ayo asingaiparadzanisi zvachose, muprista agoipisa pahuni dziri pamoto uri paaritari. Chipiriso chinopiswa, chipiriso chakagadzirwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Kana munhu achiuya kuna Jehovha nechipiriso chezviyo, chipiriso chake chinofanira kuva choupfu hwakatsetseka. Anofanira kudira mafuta pachiri agoisa zvinonhuhwira pamusoro pacho, ");
INSERT INTO sna_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","agoenda nacho kuvanakomana vaAroni vaprista. Muprista achatora tsama youpfu hwakatsetseka namafuta, pamwe chete nezvinonhuhwira, agozvipisa sechikamu chechirangaridzo paaritari. Chipiriso chakagadzirwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Zvimwe zvose zvinosara pazvipiriso zvezviyo ndezvaAroni navanakomana vake, chikamu chitsvene-tsvene chezvipiriso zvinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Kana ukauya nechipiriso chezviyo zvakabikwa muchitofu chinofanira kuva choupfu hwakatsetseka: makeke anenge aitwa asina mbiriso uye akasanganiswa namafuta kana kuti makeke matete asina mbiriso akazorwa mafuta. ");
INSERT INTO sna_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kana chipiriso chako chezviyo chagadzirirwa mugango, chinofanira kugadzirwa noupfu hwakatsetseka hwakasanganiswa namafuta pasina mbiriso. ");
INSERT INTO sna_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Unofanira kuchipfupfunyura ugodira mafuta pachiri; ichi chipiriso chezviyo. ");
INSERT INTO sna_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kana chipiriso chako chezviyo chakabikwa mugango chinofanira kuva choupfu hwakatsetseka namafuta. ");
INSERT INTO sna_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Uuye nechipiriso chezviyo chakaitwa nezvinhu izvi kuna Jehovha, ugochipa kumuprista achachiendesa kuaritari. ");
INSERT INTO sna_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Muprista achatora kubva muchipiriso chezviyo chikamu chechirangaridzo agochipisa paaritari sechipiriso chinogadzirwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Zvinosara pazvipiriso zvezviyo ndezvaAroni navanakomana vake, chikamu chitsvene-tsvene chezvipiriso zvinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Zvipiriso zvose zvezviyo zvamunouya nazvo kuna Jehovha zvinofanira kugadzirwa pasina mbiriso nokuti hamufaniri kupisa chero mbiriso kana uchi muchipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Munokwanisa kuzviuyisa kuna Jehovha sechipiriso chezvirimwa zvamunotanga kukohwa asi hazvifaniri kuuyiswa paaritari somunhuwi unonhuhwira zvinofadza. ");
INSERT INTO sna_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Rungai zvipiriso zvenyu zvose zvezviyo nomunyu. Musasiya munyu wesungano yaMwari wenyu pazvipiriso zvenyu zvose zvezviyo; muise munyu muzvipiriso zvenyu zvose zvezviyo. ");
INSERT INTO sna_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Kana uchiuyisa chipiriso chezviyo zvokutanga kuna Jehovha upe hura dzezviyo zvitsva zvakakangwa pamoto uye zvakakuyiwa. ");
INSERT INTO sna_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Uise mafuta nezvinonhuhwira pazviri, chipiriso chezviyo. ");
INSERT INTO sna_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Muprista achapisa chikamu chechirangaridzo chezviyo zvakakuyiwa, namafuta, pamwe chete nezvose zvinonhuhwira, sechipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Kana chipiriso chomumwe chiri chokuwadzana, uye akapa chipfuwo, chichibva mudanga, chingava chikono kana chikadzi, anofanira kuuyisa pamberi paJehovha chipfuwo chisina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Anofanira kuisa ruoko rwake pamusoro pechibayiro chake agochibayira pamusuo weTende Rokusangana. Ipapo vanakomana vaAroni vaprista vachasasa ropa kumativi ose earitari. ");
INSERT INTO sna_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kubva pachipiriso chokuwadzana anofanira kuuya nechipiriso chinoitwa nomoto kuna Jehovha, mafuta ose anofukidza ura, kana akabatana nahwo, ");
INSERT INTO sna_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","itsvo mbiri namafuta ari pamusoro padzo, pedyo napachiuno, nezvinofukidza chiropa, zvaachabvisa pamwe chete neitsvo. ");
INSERT INTO sna_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ipapo vanakomana vaAroni vanofanira kuzvipisa paaritari pamusoro pechipiriso chinopiswa chinenge chichitsva pamoto, sechibayiro chinoitwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Kana achipa gwai sechipiriso chokuwadzana kuna Mwari anofanira kupa gono kana gadzi risina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kana achipa gwayana, anofanira kuriuyisa pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Anofanira kuisa ruoko rwake pamusoro pechibayiro chake agochiuraya pamberi peTende Rokusangana. Ipapo vanakomana vaAroni vachasasa ropa paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kubva pachipiriso chokuwadzana anofanira kuuya nechipiriso chinoitirwa Jehovha nomoto, mafuta acho, ose mafuta echimuswe chakakora chakadimurwa, nechapamusana, ose mafuta akafukidza ura neakabatana nahwo, ");
INSERT INTO sna_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","itsvo mbiri namafuta ari padziri pedyo nechiuno nezvakafukidza chiropa, achazvibvisa pamwe chete neitsvo. ");
INSERT INTO sna_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Muprista achazvipisa paaritari sezvokudya, chipiriso chinoitwa kuna Mwari nomoto. ");
INSERT INTO sna_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Kana chipiriso chake chiri mbudzi, anofanira kuipa kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Anofanira kuisa ruoko rwake pamusoro payo agoibayira pamberi peTende Rokusangana. Ipapo vanakomana vaAroni vachasasa ropa rayo paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kubva kune zvaanopa anofanira kupa kuna Jehovha chipiriso ichi chakaitwa nomoto, mafuta ose anofukidza zvose zvomukati kana zvakabatana nazvo, ");
INSERT INTO sna_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","itsvo mbiri namafuta ari padziri pedyo nechiuno neakafukidza chiropa, zvichabviswa pamwe chete neitsvo. ");
INSERT INTO sna_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Vaprista vachazvipisa paaritari sezvokudya, chipiriso chinoitwa nomoto, chinonhuhwira zvinofadza. Mafuta ose ndeaJehovha. ");
INSERT INTO sna_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Uyu murayiro usingaperi kumarudzi achatevera, kwose kwamuchagara: Hamufaniri kudya mafuta kana ropa.’ ” ");
INSERT INTO sna_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Uti kuvana veIsraeri, ‘Kana munhu upi zvake akatadza nokusaziva akaita zvisingabvumirwi pamurayiro upi zvawo waJehovha, ");
INSERT INTO sna_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","kana muprista akazodzwa, akatadza akauyisa mhosva pamusoro pavanhu, anofanira kuuya kuna Jehovha nehando diki isina kuremara sechibayiro chechivi, nokuda kwechivi chaakaita. ");
INSERT INTO sna_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Anofanira kupa hando diki pamusuo weTende Rokusangana pamberi paJehovha. Anofanira kuisa ruoko rwake pamusoro payo agoibaya pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ipapo muprista akazodzwa achatora rimwe reropa rehando iyi agoritakura agopinda naro muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Anofanira kunyika munwe muropa agosasa rimwe racho kanomwe pamberi paJehovha; pamberi pechidzitiro chenzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Muprista achatora rimwe ropa agoisa panyanga dzearitari yezvinonhuhwira zviri pamberi paJehovha muTende Rokusangana. Rimwe ropa rose acharidira mujinga mearitari yezvibayiro zvinopiswa pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Achabvisa mafuta anofukidza zvose zvomukati kana akabatana nazvo, ");
INSERT INTO sna_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","itsvo mbiri namafuta ari padziri pedyo nechiuno nezvakafukidza chiropa, achazvibvisa pamwe chete neitsvo, ");
INSERT INTO sna_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","sokubviswa kunoitwa mafuta pahando inopiwa sechibayiro chokuwadzana. Ipapo muprista achazvipisa paaritari yezvipiriso zvinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Asi dehwe rehando, nyama yose pamwe chete nomusoro namakumbo, ura zvomukati namazvizvi, ");
INSERT INTO sna_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","zvinoreva kuti zvose zvehando, anofanira kuzvibudisa kunze kwemisasa panzvimbo yakacheneswa, panorasirwa madota agozvipisa pamoto wehuni padurunhuru. ");
INSERT INTO sna_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Kana ungano yose yaIsraeri ikatadza nokusaziva ikaita zvisingatenderwi pamirayiro ipi zvayo yaJehovha, kunyange ungano isingazivi kuti chii chakaitika, vose vane mhosva. ");
INSERT INTO sna_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kana vakaziva chivi chavakaita, ungano ichapa hando diki sechipiriso chechivi vagouya nayo kuTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Vakuru veungano vanofanira kuisa maoko avo pamusoro wehando pamberi paJehovha uye hando ichabayiwa pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ipapo muprista akazodzwa achatora rimwe ropa rehando agopinda naro muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Achanyika munwe wake muropa agorisasa pamberi paJehovha kanomwe, pamberi pechidzitiro. ");
INSERT INTO sna_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Anofanira kuisa rimwe ropa panyanga dzearitari iri pamberi paJehovha muTende Rokusangana. Rimwe ropa rose acharidururira mujinga mearitari yechibayiro chinopiswa pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Achabvisa mafuta ose pairi agoapisa paaritari ");
INSERT INTO sna_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","agoita nehando iyi zvaakaita nehando yechipiriso chezvivi. Nenzira iyi muprista anofanira kuvayananisira, uye vacharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ipapo achaenda nehando kunze kwomusasa agoipisa sokupisa kwaakaita hando yokutanga. Ichi ndicho chipiriso chezvivi cheungano yavanhu. ");
INSERT INTO sna_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Kana mutungamiri akatadza nokusaziva, akaita zvinorambidzwa pamirayiro ipi zvayo yaJehovha Mwari wake, ane mhosva. ");
INSERT INTO sna_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kana akaziviswa chivi chaakaita, anofanira kuuya nechipiriso chake chenhongo yembudzi isina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Anofanira kuisa ruoko rwake pamusoro wembudzi agoibayira panzvimbo panobayirwa chipiriso chinopiswa pamberi paJehovha. Ichi chipiriso chezvivi. ");
INSERT INTO sna_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ipapo muprista achatora rimwe ropa rechibayiro chezvivi nomunwe wake agoriisa panyanga dzearitari yechibayiro chinopiswa agodurura rimwe rose mujinga mearitari. ");
INSERT INTO sna_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Achapisa mafuta ose paaritari sokupisa kwaakaita mafuta echibayiro chokuwadzana. Nenzira iyi muprista achayananisira munhu pazvivi zvake uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Kana nhengo yeungano yavanhu ikatadza nokusaziva uye ikaita zvisingabvumirwi mumurayiro upi noupi waJehovha, ine mhosva. ");
INSERT INTO sna_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kana akaziviswa chivi chaakaita, anofanira kuuya nechibayiro chake chechivi chaakaita mbudzi hadzi isina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Anofanira kuisa ruoko rwake pamusoro wechibayiro chechivi agochiuraya panzvimbo yechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ipapo muprista achatora rimwe ropa nomunwe wake agoriisa panyanga dzearitari yechibayiro chinopiswa agodira rimwe ropa rose mujinga mearitari. ");
INSERT INTO sna_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Achabvisa mafuta ose sokubviswa kunoitwa mafuta pachibayiro chokuwadzana uye muprista achazvipisa paaritari sezvinonhuhwira zvinofadza kuna Jehovha. Nenzira iyi muprista achamuyananisira uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Kana akauya negwayana rechipiriso chake chezvivi, anofanira kuuya nesheshe isina kuremara. ");
INSERT INTO sna_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Anofanira kuisa ruoko rwake pamusoro waro agoribaya sechibayiro chezvivi panzvimbo inobayirwa chipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ipapo muprista achatora rimwe ropa racho nomunwe wake agoriisa panyanga dzearitari yechibayiro chinopiswa agodurura rimwe ropa rose mujinga mearitari. ");
INSERT INTO sna_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Achabvisa mafuta ose sokubviswa kunoitwa mafuta pagwayana rechibayiro chokuwadzana, uye muprista achazvipisa paaritari pamusoro pezvipiriso zvinoitwa kuna Mwari nomoto. Nenzira iyi muprista achamuyananisira pachivi chaakaita, uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Kana munhu akatadza nokuti aramba kupa uchapupu iye achinzi ape uchapupu pamusoro pezvaakaona kana zvaakanzwa, achava nemhosva. ");
INSERT INTO sna_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kana kuti munhu akabata zvinhu zvipi zvazvo zvisina kuchena, zvingava zvitunha zvemhuka dzesango dzisina kuchena, kana mombe isina kuchena, kana zvipuka zvisina kuchena zvinofamba pavhu, kunyange asingazvizivi, atova asina kuchena uye ane mhosva. ");
INSERT INTO sna_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Kana kuti akabata zvisakachena zvavanhu, chinhu chipi zvacho chinoita kuti asava akachena, kunyange asingazvizivi, paanozozviziva, achava nemhosva. ");
INSERT INTO sna_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Kana kuti munhu asina kunyatsofungisisa akaita mhiko yokuti achaita chimwe chinhu, chingava chakanaka kana chakaipa, panyaya ipi zvayo, munhu yaanenge apika pamusoro payo asina kufungisisa, kunyange zvazvo asingazvizivi, paanozozviziva achava nemhosva. ");
INSERT INTO sna_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Kana munhu akava nemhosva pane chimwe chaizvozvi anofanira kureurura nzira yaakatadza nayo ");
INSERT INTO sna_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","uye somuripo wechivi chaakaita, anofanira kuuya kuna Jehovha negwayana sheshe kana mbudzana sechipiriso chechivi uye muprista achamuyananisira chivi chake. ");
INSERT INTO sna_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Kana asingakwanisi kuuya negwayana anofanira kuuya nenjiva mbiri kana hangaiwa diki mbiri kuna Jehovha somuripo wechivi chake, imwe somuripo wechivi, imwe sechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Anofanira kudziuyisa kumuprista uyo achatanga kupa imwe yacho sechipiriso chechivi. Anofanira kumonyorora mutsipa wayo asingabvisi musoro zvachose. ");
INSERT INTO sna_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Achasasa rimwe ropa rechipiriso chezvivi kumativi earitari, rimwe ropa rose rinofanira kudururwa mujinga mearitari. Ichi chipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ipapo muprista achapa chimwe chacho sechipiriso chinopiswa nenzira yakatarwa agomuyananisira pachivi chaakaita, uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Asi, kana asingakwanisi kuuya nenjiva mbiri kana hangaiwa diki mbiri, anofanira kuuya nechipiriso chezvivi zvake chiri chegumi cheefa youpfu hwakatsetseka sechipiriso chezvivi. Haafaniri kuisa mafuta kana zvinonhuhwira pazviri nokuti chipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Anofanira kuzviuyisa kumuprista uyo achatora tsama sechikamu chechirangaridzo agozvipisa paaritari pamusoro pezvipiriso zvinoitirwa Jehovha nomoto. Ichi chipiriso chezvivi. ");
INSERT INTO sna_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nenzira iyi muprista achamuyananisira pazvivi zvose zvaakaita uye acharegererwa. Zvimwe zvose zvezvipiriso zvinosara zvichava zvomuprista, sezvinoitwa nezvipiriso zvezviyo.’ ” ");
INSERT INTO sna_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ipapo Jehovha akati kuna Mozisi: ");
INSERT INTO sna_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kana munhu akakanganisa chimwe chinhu uye akatadza nokusaziva maererano nezvinhu zvose zvitsvene zvaJehovha, anofanira kuuya kuna Jehovha nomuripo wegondobwe risina kuremara, uye rine muripo unokwanirana nesirivha, maererano neshekeri repanzvimbo tsvene. Ichi chipiriso chezvivi. ");
INSERT INTO sna_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Anofanira kuripira zvaakatadza kuita maererano nezvinhu zvitsvene, agowedzera chikamu chimwe chete kubva muzvishanu agopa zvose kumuprista, achamuyananisira negondobwe sechipiriso chemhosva, uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Kana munhu akatadza uye akaita zvisingabvumirwi pamirayiro ipi zvayo yaJehovha, kunyange asingazvizivi, ane mhosva uye achava nemhaka. ");
INSERT INTO sna_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Anofanira kuuya kumuprista nechipiriso chemhosva gondobwe risina kuremara uye rine muripo wakafanira. Nenzira iyi muprista achamuyananisira pakukanganisa kwaakaita nokusaziva, uye acharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ichi chipiriso chezvivi, akabatwa nemhosva yaakapara kuna Jehovha.” ");
INSERT INTO sna_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kana mumwe akatadza uye akasavimbika kuna Jehovha nokunyengedza muvakidzani wake pazvinhu zvaakachengeteswa, kana zvaakabatiswa kana zvakabiwa, kana kuti akamubiridzira, ");
INSERT INTO sna_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kana kuti akawana nhumbi dzakarasika akareva nhema pamusoro padzo, kana kuti akapika nhema kana kuti akaita chivi chipi zvacho chingaitwa navanhu, ");
INSERT INTO sna_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kana akatadza kudaro akava nemhosva, anofanira kudzosa zvaakaba kana zvaakatora nokumanikidza, kana kuti zvaakachengeteswa kana kuti zvakarasika zvaakawana, ");
INSERT INTO sna_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","kana kuti chipi zvacho chaakapupura nhema pamusoro pacho. Anofanira kudzorera zvakazara owedzera chikamu chimwe chete kubva muzvishanu pazviri agopa zvose kumuridzi pazuva raanouya nechipiriso chemhosva. ");
INSERT INTO sna_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Somuripo anofanira kuuyisa kumuprista, ndiko kuti kuna Jehovha, chipiriso chake chemhosva chegondobwe, kubva mumakwai, risina kuremara uye rine mutengo unokwanirana. ");
INSERT INTO sna_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Nenzira iyi muprista achamuyananisira pamberi paJehovha uye acharegererwa pane zvose zvaakaita zvakamuita kuti ave nemhosva.” ");
INSERT INTO sna_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Ipa Aroni navanakomana vake murayiro uyu uti, ‘Iyi ndiyo mirayiro yechipiriso chinopiswa: Chipiriso chinopiswa chinofanira kuramba chiri pachoto paaritari usiku hwose, kusvikira mangwanani, uye moto unofanira kuramba uchibvira paaritari. ");
INSERT INTO sna_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ipapo muprista achapfeka hanzu dzake dzomucheka, nebhurukwa rake romucheka pamuviri wake, uye achabvisa madota echipiriso chinopiswa nomoto paaritari agoaisa parutivi pearitari. ");
INSERT INTO sna_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ipapo anofanira kubvisa nguo idzi ogopfeka dzimwe, uye ogotakura madota aya agoenda nawo kunze kwomusasa kunzvimbo yakacheneswa. ");
INSERT INTO sna_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto uri paaritari unofanira kuramba uchibvira, haufaniri kudzima. Mangwanani oga oga muprista anofanira kuwedzera huni agoronga chipiriso chinopiswa pamoto, agopisa mafuta ezvipiriso zvokuwadzana pairi. ");
INSERT INTO sna_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto unofanira kuramba uchibvira paaritari nguva dzose; uye haufaniri kudzima. ");
INSERT INTO sna_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Iyi ndiyo mirayiro yechipiriso chezviyo: Vanakomana vaAroni vanofanira kuuya nacho pamberi paJehovha, pamberi pearitari. ");
INSERT INTO sna_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Muprista anofanira kutora tsama youpfu hwakatsetseka namafuta, pamwe chete nezvinonhuhwira zvose pachipiriso chezviyo agopisa chikamu chechirangaridzo paaritari sezvinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aroni navanakomana vake vachadya zvinosara zvacho, asi zvinofanira kudyiwa zvisina mbiriso panzvimbo tsvene, vanofanira kuzvidyira muchivanze cheTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Hazvifaniri kubikwa nembiriso, ndazvipa kwavari sechikamu chezvibayiro zvinoitwa kwandiri nomoto. Sechipiriso chezvivi nechipiriso chemhosva, zvitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Munhurume wose wechizvarwa chaAroni anogona kuzvidya. Chikamu chake chaanofanira kugara achiwana pazvipiriso zvinopiwa kuna Jehovha nomoto kuzvizvarwa zvichatevera. Munhu wose achabata izvi achava mutsvene.’ ” ");
INSERT INTO sna_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Uye Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ichi ndicho chibayiro chaAroni navanakomana vake chavanofanira kuuyisa kuna Jehovha pazuva raanozodzwa: chegumi cheefa youpfu hwakatsetseka sechipiriso chezviyo chamazuva ose, hafu yacho mangwanani neimwe hafu manheru. ");
INSERT INTO sna_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Zvibikei namafuta mugango. Muuye nazvo zvakasanganiswa zvakanaka, mugouya nechipiriso chezviyo chakamedurwa-medurwa sezvinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mwanakomana achamutevera somuprista akazodzwa achazvigadzira. Chikamu chamazuva ose chaJehovha uye chinofanira kupiswa chose. ");
INSERT INTO sna_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Zvose zvipiriso zvezviyo zvomuprista zvichapiswa chose, hazvifaniri kudyiwa.” ");
INSERT INTO sna_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Uti kuna Aroni navanakomana vake, ‘Iyi ndiyo mirayiro yechipiriso chechivi. Chipiriso chechivi chinofanira kubayiwa pamberi paJehovha panzvimbo inobayirwa chipiriso chinopiswa; chitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Muprista anopa izvozvo achazvidya; zvinofanira kudyirwa panzvimbo tsvene muchivanze cheTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chose chinogunzva nyama chichava chitsvene, uye kana rimwe ropa rikawira panguo, unofanira kuisukira panzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Hari yevhu inobikirwa nyama inofanira kuputswa; asi kana zvikabikwa mupoto yendarira, poto inofanira kukweshwa igosukurudzwa nemvura. ");
INSERT INTO sna_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Murume wose ari mumhuri yomuprista anogona kuidya; itsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Asi chipiriso chechivi, chipi nechipi chine ropa richauyiswa muTende Rokusangana kuti rizoyananisira muNzvimbo Tsvene, hachifaniri kudyiwa; chinofanira kupiswa. ");
INSERT INTO sna_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Iyi ndiyo mirayiro yechipiriso chemhosva chitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Chipiriso chemhosva chinofanira kubayirwa panzvimbo panobayirwa chipiriso chinopiswa uye ropa racho rinofanira kusaswa paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mafuta acho ose achapiswa sechipiriso, chimuswe chakakora namafuta akafukidza zvomukati, ");
INSERT INTO sna_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","itsvo mbiri namafuta ari padziri pedyo nechiuno, uye zvakafukidza chiropa, zvinofanira kubviswa pamwe chete neitsvo. ");
INSERT INTO sna_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Muprista anofanira kuzvipisa paaritari sechipiriso chinoitirwa Jehovha nomoto. Ichi chipiriso chemhosva. ");
INSERT INTO sna_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Munhurume upi zvake weimba yomuprista angachidya, asi chinofanira kudyirwa munzvimbo tsvene; chitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Chipiriso chemhosva chinofanira kuitwa sezvinoitwa nechipiriso chezvivi: ndechomuprista anoyananisira nazvo. ");
INSERT INTO sna_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Muprista anopisa chipiriso chinopiswa chomunhu upi zvake anogona kuzvichengetera dehwe racho. ");
INSERT INTO sna_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Zvipiriso zvose zvezviyo zvinobikwa muchitofu kana zvinobikwa mugango kana muhari ndezvomuprista anozvipa, ");
INSERT INTO sna_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","uye zvipiriso zvose zvezviyo zvingava zvakasangana namafuta kana zvakaoma, ndezvavanakomana vaAroni, mumwe nomumwe, zvakamuringana. ");
INSERT INTO sna_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Iyi ndiyo mirayiro yechipiriso chokuwadzana, chinogona kupiwa nomunhu kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Kana akachipa sechiratidzo chokuvonga ipapo pamwe chete nechipiriso chokuvonga ichi, anofanira kupa makeke echingwa chakabikwa chisina mbiriso, chakaiswa mafuta, makeke matete akabikwa pasina mbiriso, akazorwa mafuta, namakeke oupfu hwakatsetseka akanyatsokanywa akaiswa mafuta. ");
INSERT INTO sna_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pamwe chete nechipiriso chake chokuwadzana chokuvonga anofanira kupa chipiriso chamakeke akabikwa nembiriso. ");
INSERT INTO sna_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Anofanira kuuya nemhando imwe neimwe sechipiriso, chikamu chinopiwa kuna Jehovha; ndezvomuprista anosasa ropa nezvipiriso zvokuwadzana. ");
INSERT INTO sna_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama yechipiriso chake chokuwadzana chokuvonga inofanira kudyiwa musi wainopiwa. Haafaniri kusiya imwe kusvikira mangwanani. ");
INSERT INTO sna_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Kana chipiriso chake chiri chemhiko kana kuti chiri chipiriso chokungopawo, chibayiro ichocho chichadyiwa musi wachinopiwa, asi chinhu chose chinosara chinogona kudyiwa musi unotevera. ");
INSERT INTO sna_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nyama yose yechibayiro inosara kusvikira zuva rechitatu inofanira kupiswa. ");
INSERT INTO sna_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kana nyama yechipiriso chokuwadzana ikadyiwa nomusi wechitatu haizogamuchirwi. Hazvigamuchirwi panzvimbo yomunhu anenge azvipa nokuti hazvina kuchena, munhu achadya chikamu chipi chazvo achava nemhosva yacho. ");
INSERT INTO sna_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Nyama inogunzva chisina kucheneswa haifaniri kudyiwa, inofanira kupiswa. Kana iri imwe nyama, munhu wose akacheneswa anogona kuidya. ");
INSERT INTO sna_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Asi kana munhu asina kuchena akadya nyama iyi yokuwadzana yaJehovha, munhu iyeye anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kana munhu akabata chinhu chisina kuchena, kunyange kusachena kwavanhu, kana mhuka isina kuchena, kana chose chisina kuchena, chinhu chinonyangadza, uye akazodya nyama ipi yechipiriso chokuwadzana chaJehovha, munhu iyeye anofanira kubviswa pakati pavanhu vokwake.’ ” ");
INSERT INTO sna_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Uti kuvana veIsraeri, ‘Musadya mafuta api zvawo emombe, makwai kana mbudzi. ");
INSERT INTO sna_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta echipfuwo chinenge chawanikwa chakafa kana chabvamburwa nezvikara zvesango anogona kushandiswa pana mamwe mabasa asi hamufaniri kuadya. ");
INSERT INTO sna_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Munhu wose anodya mafuta emhuka inoitwa nayo chipiriso chinoitirwa Jehovha nomoto anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kwose kwose kwamunogara hamufaniri kudya ropa reshiri kana mhuka ipi zvayo. ");
INSERT INTO sna_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kana munhu upi zvake akadya ropa, munhu iyeye anofanira kubviswa pakati pavanhu vokwake.’ ” ");
INSERT INTO sna_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Uti kuvana veIsraeri, ‘Munhu wose anouya nechipiriso chokuwadzana kuna Jehovha anofanira kuuya nechikamu chacho sechibayiro kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Namaoko ake anofanira kuuya nechipiriso chinoitirwa Jehovha nomoto, anofanira kuuya namafuta pamwe chete nechityu, agoninira chityu kuna Jehovha sechipiriso chokuninira. ");
INSERT INTO sna_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Muprista achapisa mafuta paaritari, asi chityu ndechaAroni navanakomana vake. ");
INSERT INTO sna_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Munofanira kupa bandauko rorudyi pazvipiriso zvenyu zvokuwadzana kumuprista somugove wakewo. ");
INSERT INTO sna_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mwanakomana waAroni anopa ropa namafuta echipiriso chokuwadzana achatora bandauko rokurudyi somugove wake. ");
INSERT INTO sna_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kubva kuzvipiriso zvokuwadzana zvavana veIsraeri ndatora chityu chinoninirwa nebandauko rinouyiswa ndikazvipa kuna Aroni muprista navanakomana vake somugove wavo wavanofanira kugara vachiwana kubva kuvaIsraeri.’ ” ");
INSERT INTO sna_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Uyu ndiwo mugove wezvibayiro zvinoitirwa Jehovha nomoto zvakapiwa kuna Aroni navanakomana vake pazuva ravakagadzwa kuti vashumire Jehovha savaprista. ");
INSERT INTO sna_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Pazuva ravakazodzwa, Jehovha akarayira kuti vaIsraeri vape izvi kwavari somugove wavanofanira kugara vachiwana kuzvizvarwa zvichatevera. ");
INSERT INTO sna_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Zvino iyi ndiyo mirayiro yezvipiriso zvinopiswa, chipiriso chezviyo, chipiriso chechivi, chipiriso chemhosva, chipiriso chokugadzwa nechipiriso chokuwadzana, ");
INSERT INTO sna_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","zvakapiwa Mozisi naJehovha paGomo reSinai pazuva raakarayira vaIsraeri kuti vauye nezvipiriso kuna Jehovha muGwenga reSinai. ");
INSERT INTO sna_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Uya naAroni navanakomana vake, nguo dzavo, mafuta okuzodza nawo, hando yechipiriso chechivi, makondobwe maviri nedengu rine chingwa chisina mbiriso, ");
INSERT INTO sna_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ugounganidza ungano yose pamusuo weTende Rokusangana.” ");
INSERT INTO sna_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mozisi akaita sezvaakaudzwa naJehovha, uye ungano ikaungana pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mozisi akati kuungano, “Izvi ndizvo zvarayirwa naJehovha kuti zviitwe.” ");
INSERT INTO sna_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ipapo Mozisi akauya naAroni navanakomana vake mberi akavashambidza nemvura. ");
INSERT INTO sna_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Akapfekedza Aroni nguo akamusunga bhanhire, akamupfekedza jasi, uye akamupfekedza efodhi. Akasungirirawo efodhi paari nendaza yakanga yakasonwa nounyanzvi; saka yakasungirirwa paari. ");
INSERT INTO sna_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Akaisa chidzitiro chepachipfuva paari uye akaisa Urimi neTumimi pachidzitiro chepachipfuva. ");
INSERT INTO sna_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ipapo akaisa nguwani pamusoro waAroni, nechemberi akaisa hwendefa regoridhe, iyo korona tsvene, sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ipapo Mozisi akatora mafuta okuzodza akazodza tabhenakeri nezvose zvakanga zvirimo, naizvozvo akazvitsaura. ");
INSERT INTO sna_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Akasasa mamwe mafuta paaritari kanomwe, achizodza aritari nemidziyo yayo yose nedhishi nechigadziko charo kuti azvitsaure. ");
INSERT INTO sna_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Akadurura mamwe mafuta okuzodza pamusoro waAroni, akamuzodza achimutsaura. ");
INSERT INTO sna_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ipapo akauya navanakomana vaAroni mberi, akavapfekedza nguo, akavasunga zviuno namabhanhire akavapfekedza nguwani mumusoro sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Akazouya nehando yechipiriso chechivi, Aroni navanakomana vake vakaisa maoko avo pamusoro wayo. ");
INSERT INTO sna_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mozisi akabaya hando akatora rimwe ropa rayo, akariisa panyanga dzose dzearitari kuti achenese aritari. Akadurura rimwe ropa rose mujinga mearitari. Naizvozvo akaitsaura kuti aiyananisire. ");
INSERT INTO sna_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mozisi akatora mafuta ose akanga akafukidza nhengo dzomukati, akanga akafukidza chiropa, neitsvo mbiri namafuta adzo, akazvipisa paaritari. ");
INSERT INTO sna_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Asi hando nedehwe rayo nenyama nezvomukati akazvipisa kunze kwomusasa sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Akauya zvino negondobwe sechipiriso chinopiswa, Aroni navanakomana vake vakaisa maoko avo pamusoro waro. ");
INSERT INTO sna_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ipapo Mozisi akauraya gondobwe akasasa ropa raro paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Akacheka gondobwe kuita zvidimbu uye akapisa musoro, zvidimbu namafuta. ");
INSERT INTO sna_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Akasuka ura namakumbo nemvura uye akapisa gondobwe rose paaritari sechipiriso chinopiswa, chinonhuhwira zvinofadza, chipiriso chinoitirwa Jehovha nomoto, sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Akauya zvino nerimwe gondobwe, gondobwe rokugadza, uye Aroni navanakomana vake vakaisa maoko avo pamusoro waro. ");
INSERT INTO sna_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mozisi akauraya gondobwe akatora rimwe ropa raro akariisa pamucheto wenzeve yaAroni yokurudyi napamunwe wake woruoko rwokurudyi napagunwe guru retsoka yake yokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mozisi akauyawo navanakomana vaAroni mberi akaisa ropa pamucheto wezasi wenzeve dzavo dzokurudyi, paminwe mikuru yamaoko avo okurudyi napazvigunwe zvikuru zvamakumbo avo okurudyi. Akasasa ropa paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Akatora mafuta, chimuswe chakakora, mafuta ose akafukidza ura, akafukidza chiropa, itsvo mbiri namafuta adzo nechidya chokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ipapo kubva mudengu rechingwa chisina mbiriso raiva pamberi paJehovha, akatora chingwa, keke rakabikwa namafuta nekeke dete, akaisa izvi panzvimbo dzina mafuta pamusoro pebandauko rokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Akaisa zvose mumaoko aAroni neevanakomana vake uye vakazvininira kuna Jehovha sechipiriso chokuninira. ");
INSERT INTO sna_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ipapo Mozisi akazvitora kubva mumaoko avo akazvipisa paaritari pamusoro pechipiriso chinopiswa sechipiriso chokugadza, chinonhuhwira zvinofadza, chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Akatorawo chityu, mugove waMozisi pagondobwe rokugadza, akazvininira kuna Jehovha sechipiriso chokuninira sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ipapo Mozisi akatora mamwe mafuta okuzodza nerimwe ropa kubva paaritari akarisasa pana Aroni navanakomana vake nenguo dzavo. Saizvozvo, akatsaura Aroni nenguo dzake navanakomana vake nenguo dzavo. ");
INSERT INTO sna_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ipapo Mozisi akati kuna Aroni navanakomana vake, “Bikai nyama pamusuo weTende Rokusangana mugoidyira ipapo nechingwa chomudengu rezvipiriso zvokugadzwa sezvandakarayira ndichiti, ‘Aroni navanakomana vake vanofanira kuchidya.’ ");
INSERT INTO sna_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ipapo mugopisa zvose zvasara panyama nechingwa. ");
INSERT INTO sna_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Musabva pamusuo weTende Rokusangana kwamazuva manomwe kusvikira mazuva okugadzwa kwenyu apera, nokuti kugadzwa kwenyu kuchapedza mazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Zvaitwa nhasi zvakarayirwa naJehovha kuti akuyananisirei. ");
INSERT INTO sna_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Munofanira kugara pamusuo weTende Rokusangana usiku namasikati kwamazuva manomwe mugoita zvinoda Jehovha kuti musafe nokuti ndizvo zvandarayirwa.” ");
INSERT INTO sna_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Saka Aroni navanakomana vake vakaita zvose zvakarayirwa naJehovha kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Pazuva rorusere Mozisi akadana Aroni navanakomana vake navakuru veIsraeri. ");
INSERT INTO sna_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Akati kuna Aroni, “Tora hando diki yechipiriso chako chechivi negondobwe rechipiriso chako chinopiswa zvose zvisina kuremara ugouya nazvo kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Uti kuvana veIsraeri, ‘Torai nhongo yembudzi yechipiriso chechivi, mhuru negwayana zvose zvine gore uye zvisina kuremara sechipiriso chinopiswa ");
INSERT INTO sna_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","nehando negondobwe zvechipiriso chokuwadzana kuti mubayire pamberi paJehovha, pamwe chete nechipiriso chezviyo chakasanganiswa namafuta. Nokuti nhasi Jehovha achazviratidza kwamuri.’ ” ");
INSERT INTO sna_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Vakatora zvinhu zvakarayirwa naMozisi vakaenda nazvo mberi kweTende Rokusangana uye ungano yose ikauya ikamira pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ipapo Mozisi akati, “Izvi ndizvo zvakarayirwa naJehovha kuti muite kuti kubwinya kwaJehovha kugoratidzwa kwamuri.” ");
INSERT INTO sna_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mozisi akati kuna Aroni, “Uya kuaritari ugobayira chipiriso chako chechivi nechipiriso chako chinopiswa ugozviyananisira iwe navanhu; bayira chipiriso chavanhu ugovayananisira sezvakarayirwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Saka Aroni akauya kuaritari akabaya mhuru sechipiriso chechivi chake. ");
INSERT INTO sna_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Vanakomana vake vakauya neropa kwaari akanyika munwe wake muropa akariisa panyanga dzearitari. Rimwe ropa rose akaridururira mujinga mearitari. ");
INSERT INTO sna_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Akapisa mafuta, itsvo namafuta akafukidza chiropa kubva pachipiriso chechivi paaritari sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nyama nedehwe akazvipisa kunze kwomusasa. ");
INSERT INTO sna_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ipapo akabaya chipiriso chinopiswa, uye vanakomana vake vakamutambidza ropa akarisasa paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Vakamutambidza chipiriso chinopiswa chidimbu nechidimbu zvichisanganisira musoro akazvipisa paaritari. ");
INSERT INTO sna_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Akasuka ura namakumbo akazvipisa pamusoro pechipiriso chinopiswa paaritari. ");
INSERT INTO sna_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ipapo Aroni akauya nechipiriso chavanhu akatora mbudzi yechipiriso chavanhu chechivi akaiuraya uye akaipa sechipiriso chechivi sezvaakaita neyokutanga. ");
INSERT INTO sna_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Akauya nechipiriso chinopiswa akachipa nenzira yakatarwa. ");
INSERT INTO sna_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Akauyawo nechipiriso chezviyo, akatora tsama yacho akaipisa paaritari achiwedzera pachipiriso chinopiswa mangwanani. ");
INSERT INTO sna_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Akabaya hando negondobwe sechipiriso chokuwadzana chavanhu. Vanakomana vake vakamutambidza ropa akarisasa paaritari kumativi ose. ");
INSERT INTO sna_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Asi mafuta ehando neegondobwe, chimuswe chakakora, fukidziro yamafuta, itsvo nezvinofukidza chiropa, ");
INSERT INTO sna_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","izvi vakazviisa pazvityu. Aroni akapisa mafuta paaritari. ");
INSERT INTO sna_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aroni akaninira zvityu nebandauko rokurudyi pamberi paJehovha sechipiriso chokuninira sokurayirwa kwaMozisi. ");
INSERT INTO sna_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ipapo Aroni akasimudzira maoko ake kuvanhu akavaropafadza. Apedza kubayira chipiriso chechivi, chipiriso chinopiswa nechipiriso chokuwadzana akaburuka pasi. ");
INSERT INTO sna_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mozisi naAroni vakapinda muTende Rokusangana. Pavakabuda vakaropafadza vanhu, uye kubwinya kwaJehovha kukaonekwa navanhu vose. ");
INSERT INTO sna_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moto wakabuda kubva pamberi paJehovha ukapisa chipiriso chinopiswa namafuta paaritari. Vanhu vose pavakazviona vakadanidzira nomufaro uye vakawira pasi nezviso zvavo. ");
INSERT INTO sna_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Zvino Nadhabhi naAbhihu, vanakomana vaAroni vakatora, mumwe nomumwe, hadyana yake yezvinonhuhwira, vakaisamo moto, vakaisawo zvinonhuhwira, vakaisa moto usingabvumirwi pamberi paJehovha zvaakanga asina kuvarayira. ");
INSERT INTO sna_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Saka naizvozvo moto wakabuda kubva pamberi paJehovha ukavapisa vose ndokubva vafa pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ipapo Mozisi akati kuna Aroni, “Izvi ndizvo zvakataurwa naJehovha paakati: “ ‘Pakati peavo vachaswedera kwandiri ndicharatidza utsvene hwangu, pamberi pavanhu vose ndichakudzwa.’ ” Aroni akaramba anyerere. ");
INSERT INTO sna_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mozisi akadana Mishaeri naErizafani, vanakomana vaUzieri, babamunini vaAroni, akati kwavari, “Uyai pano mutakure madzikoma enyu muende navo kunze kwomusasa vabve pamberi penzvimbo tsvene.” ");
INSERT INTO sna_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Saka vakauya vakavatakura vachakapfeka hanzu dzavo vakaenda navo kunze kwomusasa sezvazvakanga zvarayirwa naMozisi. ");
INSERT INTO sna_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ipapo Mozisi akati kuna Aroni navanakomana vake, Ereazari naItamari, “Musarega bvudzi renyu risina kukamwa uye musabvarura nguo dzenyu nokuti mungafa, Mwari akatsamwira ungano yose. Asi hama dzenyu, imba yose yaIsraeri, vanogona kuchema avo vakaparadzwa nomoto naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Musabva pamusuo weTende Rokusangana nokuti mungafa nokuti mafuta aJehovha okuzodza ari pamuri.” Saka vakaita sezvakataurwa naMozisi. ");
INSERT INTO sna_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ipapo Jehovha akati kuna Aroni, ");
INSERT INTO sna_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Iwe navanakomana vako hamufaniri kunwa waini kana zvimwe zvinwiwa zvakaviriswa pose pose pamunopinda muTende Rokusangana nokuti mungafa. Uyu mutemo usingaperi kusvikira kuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Munofanira kuisa mutsauko pakati pezvitsvene nezvisingakoshi, pakati pezvakachena nezvisina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Uye munofanira kudzidzisa vaIsraeri mirayiro yose yavakapiwa naJehovha kubudikidza naMozisi.” ");
INSERT INTO sna_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mozisi akati kuna Aroni navanakomana vake vakanga vasara, Ereazari naItamari, “Torai chipiriso chezviyo kubva pazvipiriso zvakaitirwa Jehovha nomoto, zvakagadzirwa pasina mbiriso mugochiisa parutivi pearitari nokuti chitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Zvidyei munzvimbo tsvene, nokuti mugove wenyu nomugove wavanakomana venyu, wezvipiriso zvinoitirwa Jehovha nomoto, nokuti ndakarayirwa saizvozvo. ");
INSERT INTO sna_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Asi iwe navanakomana vako navanasikana vako, munogona kudya chityu chakaninirwa nebandauko rakakumikidzwa. Zvidyei munzvimbo yakacheneswa; izvi zvakapiwa kwauri navana vako somugove wenyu wezvipiriso zvokuwadzana zvavana vaIsraeri. ");
INSERT INTO sna_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Bandauko rakakumikidzwa nechityu chakaninirwa zvinofanirwa kuuyiswa namafuta nezvipiriso zvinoitwa nomoto, kuti zvininirwe pamberi paJehovha sechipiriso chokuninira. Uyu uchava mugove wamuchagara muchiwana navana venyu sezvakarayirwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mozisi akati abvunza nezvembudzi yechipiriso chechivi akawana yatopiswa, akatsamwira Ereazari naItamari vanakomana vaAroni vakanga vasara akabvunza akati, ");
INSERT INTO sna_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Sei musina kudyira chipiriso chechivi munzvimbo tsvene? Chitsvene-tsvene, chakapiwa kwamuri kuti chibvise mhosva yeungano nokuvayananisira pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Sezvo ropa racho risina kuuyiswa kuNzvimbo Tsvene, maifanira kudyira mbudzi munharaunda yenzvimbo tsvene, sezvandakarayira.” ");
INSERT INTO sna_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroni akapindura Mozisi achiti, “Nhasi vabayira chipiriso chavo chechivi nechipiriso chavo chinopiswa pamberi paJehovha asi zvinhu zvakaita seizvi zvaitika kwandiri. Jehovha aidai afara here dai ndadya chipiriso chechivi nhasi?” ");
INSERT INTO sna_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mozisi paakanzwa izvi akagutsikana. ");
INSERT INTO sna_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Taurai kuvaIsraeri muti, ‘Pamhuka dzose dzinofamba panyika, idzi ndidzo dzamunogona kudya: ");
INSERT INTO sna_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Munogona kudya mhuka ipi zvayo ina mahwanda, akapararana zvachose, uye inozeya zvokudya. ");
INSERT INTO sna_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Asi kune dzimwe dzinongozeya kudya chete, kana kuti dzimwe dzine mahwanda akaparadzana chete, idzi hamufaniri kudzidya. Ngamera, kunyange ichizeya zvokudya, haina mahwanda akapatsanuka; haina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Mbira kunyange ichizeya zvokudya, haina mahwanda akapatsanuka, haina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Tsuro kunyange ichizeya zvokudya, haina mahwanda akapatsanuka, haina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nguruve kunyange ine mahwanda akanyatsopatsanuka, haizeyi zvokudya, haina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hamufaniri kudya nyama yazvo kana kubata zvitunha zvazvo; hazvina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Pazvisikwa zvose zvinogara mumvura yamakungwa nenzizi, munogona kudya dzose dzine zvimbi namakwati. ");
INSERT INTO sna_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Asi zvipuka zvose zvomugungwa kana munzizi zvisina zvimbi namakwati, kunyange pakati pezvinouya samatutu kana pakati pezvose zvisikwa zvinorarama mumvura, zvinonyangadza kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Uye sezvo zvichinyangadza kwamuri hamufaniri kudya nyama yazvo uye munofanira kusema zvitunha zvazvo. ");
INSERT INTO sna_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chose chinhu chinorarama mumvura chisina zvimbi namakwati chinonyangadza kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Idzi ndidzo shiri dzamunofanira kusema, uye musadzidya nokuti dzinonyangadza kwamuri: gondo, gora, chapungu, ");
INSERT INTO sna_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","njerere, marudzi ose oruvangu rutema, ");
INSERT INTO sna_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","marudzi ose amakunguo, ");
INSERT INTO sna_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","marudzi ose amazizi, shiri yegungwa namarudzi ose oruvangu, ");
INSERT INTO sna_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","nezizi duku, nekanyururahove, nezizi guru, ");
INSERT INTO sna_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","nejichidza, nekondo, negora, ");
INSERT INTO sna_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","neshuramurove, namarudzi ose ekondo, nemhupupu nechiremwaremwa. ");
INSERT INTO sna_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Zvose zvipukanana zvinobhururuka, zvinofamba namakumbo mana zvinonyangadza kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kunyange zvakadaro, kunewo zvimwe zvipuka zvine mapapiro zvinofamba namakumbo mana zvamunogona kudya, izvo zvine makumbo akabatanidzwa okukwakuka nawo. ");
INSERT INTO sna_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pakati pezvizvi munogona kudya marudzi ose emhashu, namarudzi ose amakurwe namarudzi ebambamukota. ");
INSERT INTO sna_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Asi zvimwe zvose zvipukanana zvine mapapiro zvine makumbo mana munofanira kuzvisema. ");
INSERT INTO sna_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Musazvisvibisa nezvizvi; ani naani anobata zvitunha zvazvo achava akasviba kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ani naani achanhonga chimwe chezvitunha zvazvo anofanira kusuka nguo dzake uye achava akasviba kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Mhuka yose yose ina mahwanda akapararana asi asina kunyatsopararana, isingazeyi kudya, haina kuchena kwamuri; ani naani anobata chitunha chayo achava asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Pamhuka dzose dzinofamba namakumbo mana, idzo dzine tsoka dzakafara hadzina kuchena kwamuri; ani naani anobata chitunha chadzo achava akasviba kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ani naani achanhonga zvitunha zvadzo anofanira kusuka nguo dzake uye achava akasviba kusvikira manheru. Hadzina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Pamhuka dzinokambaira panyika, idzi hadzina kuchena kwamuri: chidembo, gonzo, namarudzi ose egwavava, ");
INSERT INTO sna_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","chifurira, namarudzi ose amadzvinyu, dhambakura nerwaivhi. ");
INSERT INTO sna_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Pane zvose zvinokambaira panyika, izvi hazvina kuchena kwamuri. Asi ani naani anozvibata kana zvafa achava akasviba kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kana chimwe chazvo chikafa, chikawira pamusoro pechimwe chinhu, chinhu ichocho hazvinei kuti chinoshandiswei, chinova chisina kuchena kunyange chakagadzirwa nomuti, mucheka, dehwe, kana saga. Chiisei mumvura; chichava chisina kuchena kusvikira manheru, uye ipapo chichava chakachena. ");
INSERT INTO sna_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kana chimwe chazvo chikawira muhari yevhu, zvose zviri mairi zvichava zvisina kuchena, uye munofanira kuputsa hari yacho. ");
INSERT INTO sna_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chokudya chipi zvacho chinogona kudyiwa, asi chine mvura pachiri, yabva muhari iyoyo chichava chisina kuchena uye kana chipi zvacho chinganwiwa kubva imomo hachina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chose chinhu chinowirwa nechitunha chazvo chinova chisina kuchena; choto kana hari yokubikira zvinofanira kuputswa. Hazvina kuchena uye munofanira kuzvibata sezvisina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Asi chitubu, kana tsime rokuchera mvura zvinoramba zvakachena, asi ani naani anobata chimwe chezvitunha izvi achava asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kana chitunha chikawira pambeu ipi zvayo inofanira kudyarwa, inoramba yakachena. ");
INSERT INTO sna_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Asi kana mvura yaiswa pambeu, uye chitunha chikawira pairi, inova isina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Kana mhuka yamunobvumirwa kudya ikafa yoga, munhu wose achabata mutumbi wayo achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Munhu wose achadya imwe nyama yacho anofanira kusuka nguo dzake agova asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Chisikwa chose chinokambaira panyika chinonyangadza, hachifaniri kudyiwa. ");
INSERT INTO sna_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Hamufaniri kudya chisikwa chipi zvacho chinokambaira panyika, chingava chinofamba nedumbu kana chinofamba namakumbo mana kana namakumbo akawanda, chinonyangadza. ");
INSERT INTO sna_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Musazvisvibisa nechimwe chezvisikwa izvi. Musazvisvibisa nazvo kana nokuda kwazvo. ");
INSERT INTO sna_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ndini Jehovha Mwari wenyu, zvitsaurei mugova vatsvene, nokuti ndiri mutsvene. Musazvisvibisa nechipuka chipi zvacho chinofamba-famba pasi. ");
INSERT INTO sna_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ndini Jehovha akakubudisai muIjipiti kuti ndive Mwari wenyu; saka ivai vatsvene nokuti ndiri mutsvene. ");
INSERT INTO sna_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Ndiyo mitemo iri maererano nemhuka, shiri, zvipenyu zvose zvinofamba mumvura nezvipuka zvose zvinofamba panyika. ");
INSERT INTO sna_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Munofanira kuisa mutsauko pakati pezvisina kuchena nezvakachena, pakati pezvisikwa zvipenyu zvinogona kudyiwa nezvisingagoni kudyiwa.’ ” ");
INSERT INTO sna_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Uti kuvaIsraeri, ‘Mukadzi akava napamuviri akabereka mwanakomana, achava asina kuchena kwamazuva manomwe, sezvaanova asina kuchena paanoenda kumwedzi. ");
INSERT INTO sna_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pazuva rorusere mukomana uyo anofanira kudzingiswa. ");
INSERT INTO sna_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Zvino mukadzi anofanira kumirira mazuva makumi matatu namatatu kuti acheneswe pakubuda ropa kwake. Haafaniri kubata chinhu chipi zvacho chitsvene kana kusvika kunzvimbo tsvene kusvikira mazuva okucheneswa kwake apera. ");
INSERT INTO sna_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kana akabereka mwanasikana, kwevhiki mbiri mukadzi achava asina kuchena sepaanoenda kumwedzi. Ipapo anofanira kumira mazuva makumi matanhatu namatanhatu kuti acheneswe kubva pakubuda ropa. ");
INSERT INTO sna_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Kana mazuva okucheneswa nokuda kwomwanakomana kana mwanasikana apera, anofanira kuuya kumuprista pamusuo weTende Rokusangana, negwayana rine gore rimwe chete sechipiriso chinopiswa nehangaiwa diki kana njiva yechipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Achazvibayira pamberi paJehovha kuti agomuyananisira, achava akacheneswa kubva pakubuda ropa kwake. “ ‘Iyi ndiyo mirayiro yomukadzi anobatsirwa nomwanakomana kana mwanasikana. ");
INSERT INTO sna_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kana asingakwanisi kuuya negwayana, anofanira kuuya nenjiva mbiri kana hangaiwa diki mbiri, imwe yechipiriso chinopiswa imwe yechipiriso chechivi. Nenzira iyi muprista achamuyananisira uye achava akachena.’ ” ");
INSERT INTO sna_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kana ani naani ane pakazvimba kana kuti ane tumapundu kana chivara chichena paganda rake chinogona kunge chiri chirwere chinotapukira anofanira kuuyiswa kuna Aroni muprista kana kuno mumwe wavanakomana vake muprista. ");
INSERT INTO sna_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Muprista achatarisa chironda chiri paganda rake, uye kana bvudzi riri pachironda rachena uye ronda roratidza kudzika kudarika paganda, chirwere cheganda chinotapukira. Kana muprista akamuongorora achamuzivisa kuvanhu somunhu asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kana gwapa riri paari riri jena asi risingaratidzi kudzika kudarika paganda uye bvudzi risina kuchena, muprista anofanira kugarisa munhu iyeye oga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pazuva rechinomwe muprista anofanira kumuongorora uye akaona kuti chironda hachina kupinduka uye hachina kupararira muganda anofanira kumuchengeta pake oga kwamamwe mazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Pazuva rechinomwe muprista anofanira kumuongorora zvakare, uye kana chironda chaserera uye chisina kupararira neganda, muprista achamuzivisa somunhu akachena, tunongova tumapundu. Munhu anofanira kusuka nguo dzake uye achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Asi kana tumapundu tukapararira nomuviri wake shure kwokunge azviratidza kumuprista kuti zviziviswe kuti akachena, anofanira kuenda kumuprista zvakare. ");
INSERT INTO sna_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Muprista anofanira kumuongorora, uye kana tumapundu twapararira neganda, achazivisa kuti haana kuchena; chirwere chinotapukira. ");
INSERT INTO sna_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Kana munhu upi zvake ane chirwere chinotapukira, anofanira kuuyiswa kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Muprista anofanira kumuongorora, uye kana pane kuzvimba nokucheneruka paganda, uye zvapindura bvudzi kuti rive jena, uye kana pane nyama yakatsvuka, pakazvimba, ");
INSERT INTO sna_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","chirwere cheganda chava nenguva uye muprista achazivisa kuti haana kuchena. Haafaniri kumugarisa ari oga, nokuti atogara asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Kana chirwere chikabuda paganda rake rose uye sokuona kwomuprista, chakafukidza ganda rose romunhu abatwa nehosha, kubva kumusoro kusvika kutsoka, ");
INSERT INTO sna_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","muprista anofanira kumuongorora uye kana chirwere chapararira nomuviri wake wose, achazivisa kuti munhu uyu akachena, sezvo zvose zvachenuruka, akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Asi pose panoonekwa ronda paari, achava asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Muprista paachaona ronda, achazivisa kuti haana kuchena. Ronda harina kuchena ane chirwere chinotapukira. ");
INSERT INTO sna_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Zvikaitika kuti ronda richeneruke, anofanira kuenda kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ipapo muprista anofanira kumuongorora uye kana zvironda zvachenuruka, muprista achazivisa kuti munhu ane hosha uyu akachena, ipapo achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Kana munhu akava nemota paganda rake rikapora, ");
INSERT INTO sna_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","uye panzvimbo panga pane mota pakazvimba pakacheneruka kana kuti pakatsvuka, anofanira kuzviratidza kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Muprista anofanira kumuongorora uye kana zvikaratidza kudzika kudarika paganda uye bvudzi riri pachiri rikapinduka rikava jena, muprista achazivisa kuti haana kuchena, chirwere chinotapukira cheganda chabuda panga pane mota. ");
INSERT INTO sna_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Asi kana muprista achiongorora, pasina bvudzi jena pachiri uye paserera, ipapo muprista anofanira kumugarisa oga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kana zviri kupararira muganda, muprista achazivisa kuti haana kuchena, zvinotapukira. ");
INSERT INTO sna_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Asi kana gwapa risina kupinduka uye risina kupararira, rinongova vanga kubva pamota uye muprista achazivisa kuti akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Kana munhu akatsva paganda uye akabuda gwapa dzvuku kana rakacheneruka paronda rokutsva, ");
INSERT INTO sna_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","muprista anofanira kutarisa gwapa uye kana bvudzi riri pariri rapinduka rikava jena uye zvakadzika kudarika ganda, chirwere chinotapukira cheganda chabuda pakatsva. ");
INSERT INTO sna_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Asi kana muprista akachiongorora, pasina bvudzi jena pagwapa uye kana zvisina kudzika kudarika ganda uye zvaserera, ipapo muprista anofanira kumugarisa oga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pazuva rechinomwe muprista anofanira kumuongorora uye kana zvichipararira neganda, muprista achazivisa kuti haana kuchena; chirwere chinotapukira cheganda. ");
INSERT INTO sna_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Asi kana gwapa rikasapinduka uye risina kupararira neganda, asi raserera, kuzvimba kunobva pakutsva uye muprista achazivisa kuti akachena, rinongova vanga rinobva pakutsva. ");
INSERT INTO sna_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Kana munhurume kana munhukadzi akava nechironda mumusoro kana pachirebvu, ");
INSERT INTO sna_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","muprista anofanira kuongorora chironda, uye kana chichiratidza kudzika kudarika ganda, uye bvudzi riri machiri riri renhundurwa uye riri dete, muprista achazivisa kuti munhu iyeye haana kuchena, kuvava, chirwere chinotapukira chomusoro kana chechirebvu. ");
INSERT INTO sna_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Asi kana muprista akaongorora ronda iri uye kana risingaratidzi kudzika kudarika ganda uye pasina bvudzi dema pariri, zvino muprista anofanira kuchengeta munhu ane hosha ari oga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pazuva rechinomwe muprista anofanira kuongorora ronda, uye kana kuvava kusina kupararira uye pasina bvudzi renhundurwa uye risingaratidzi kudzika kudarika ganda, ");
INSERT INTO sna_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","anofanira kuveurwa bvudzi pachisiyiwa nzvimbo ine hosha, uye muprista anofanira kumuchengeta ari oga kwamamwe mazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Pazuva rechinomwe muprista anofanira kuongorora panovava, uye kana pasina kupararira neganda zvichiratidza kuti hazvina kudzika kudarika ganda, muprista achazivisa kuti akachena. Anofanira kusuka nguo dzake agova akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Asi kana kuvava kukaparira neganda iye aziviswa kuti akachena, ");
INSERT INTO sna_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","muprista anofanira kumuongorora, uye kana kuvava kwapararira neganda, muprista haafaniri kutsvaga bvudzi renhundurwa, nokuti munhu iyeye haana kuchena. ");
INSERT INTO sna_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Zvisinei hazvo, kana zvikaitika kuti sokuona kwake hazvina kupinduka, uye bvudzi dema ramera mazviri, kuvava kwaporeswa, achena uye muprista achazivisa kuti akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Kana munhurume kana munhukadzi ane makwapa machena paganda ");
INSERT INTO sna_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","muprista anofanira kuaongorora uye kana makwapa asina kunyanyochena, tumapundu tusingakuvadzi twabuda paganda, munhu iyeye akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Kana bvudzi romumwe rikabva akasara asisina bvudzi, ava nemhanza, akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kana akabva bvudzi pahuma uye akasara ava nemhanza, akachena. ");
INSERT INTO sna_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Asi kana ane chironda chichena chakatsvukuruka pamhanza yake kana pahuma, chirwere chinotapukira chabuda pamusoro pake kana pahuma. ");
INSERT INTO sna_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Muprista anofanira kumuongorora uye kana kuzvimba kuri pamusoro pake kana pamhanza kwakatsvukuruka nokuchena sechirwere chinotapukira cheganda, ");
INSERT INTO sna_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","murume iyeye arwara uye haana kuchena. Muprista anofanira kuzivisa kuti haana kuchena nokuda kwechironda chiri pamusoro wake. ");
INSERT INTO sna_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Munhu ane chirwere chinotapukira ichi anofanira kupfeka nguo dzakabvaruka, osiya bvudzi rake risina kukamwa, ofukidza chikamu chepasi cheuso hwake, odanidzira achiti, ‘Handina kuchena! Handina kuchena!’ ");
INSERT INTO sna_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kana aramba ane chirwere ichocho anongoramba asina kuchena. Anofanira kugara oga; anofanira kugara kunze kwomusasa. ");
INSERT INTO sna_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kana nguo ipi neipi yazadzwa maperembudzi, ingava nguo yeshinda, kana yewuru kana yomucheka, ");
INSERT INTO sna_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ungava mucheka wakarukwa kana mucheka wewuru kana wedehwe kana chinhu chakagadzirwa nedehwe, ");
INSERT INTO sna_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","uye kana utachiona huri muchipfeko kana dehwe kana mucheka wakarukwa kana chinhu chedehwe, chiri choruvara rwezerere kana chakatsvukuruka, chirwere chinopararira chamaperembudzi uye chinofanira kuratidzwa kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Muprista anofanira kuchiongorora agochengeta chinhu chacho pacho choga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pazuva rechinomwe anofanira kuchiongorora uye kana maperembudzi apararira muchipfeko kana nguo yakarukwa, zvisinei kuti chinoshandiswei, chirwere chinoparadza chamaperembudzi; chinhu ichocho hachina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Anofanira kupisa nguo yacho, kana mucheka wakarukwa wewuru kana mucheka weshinda, kana wedehwe une utachiona mauri, nokuti maperembudzi anoparadza, chinhu ichocho chinofanira kupiswa. ");
INSERT INTO sna_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Asi kana muprista akachiongorora, maperembudzi asina kupararira muchipfeko kana mucheka wakarukwa, kana chinhu chakagadzirwa nedehwe, ");
INSERT INTO sna_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","acharayira kuti chinhu chine utachiona chisukwe. Ipapo anofanira kuchigarisa choga kwamamwe mazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mushure mokunge chinhu chine utachiona chasukwa, muprista anofanira kuchiongorora uye kana maperembudzi asina kuratidza kupinduka maonekero awo, kunyange zvisina kupararira, hachina kuchena. Pisai chinhu ichocho nomoto kunyange maperembudzi akanganisa divi rimwe chete. ");
INSERT INTO sna_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kana muprista akachiongorora, maperembudzi akange aumbuka mushure mokunge chinhu chasukwa, anofanira kubvarura chidimbu chapinda utachiona kubva panguo, kana padehwe kana pamucheka wakarukwa. ");
INSERT INTO sna_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Asi kana zvikabuda zvakare pachipfeko, kana pamucheka wakarukwa, kana pachinhu chedehwe, zviri kupararira uye chose chine maperembudzi chinofanira kupiswa nomoto. ");
INSERT INTO sna_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nguo iyi, kana mucheka wakarukwa, kana chinhu chedehwe chasukwa uye chabviswa maperembudzi, chinofanira kusukwa zvakare uye chichava chakachena.” ");
INSERT INTO sna_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Iyi ndiyo mirayiro inoenderana nokuzadzwa namaperembudzi kwechipfeko chewuru kana chomucheka, mucheka wakarukwa kana chinhu chose chedehwe kuti zvigoziviswa kuti zvakachena kana kuti hazvina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Jehovha akati kuna Mozisi: ");
INSERT INTO sna_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Iyi ndiyo mirayiro yomunhu ane chirwere panguva yake yokucheneswa kana auyiswa kumuprista: ");
INSERT INTO sna_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Muprista anofanira kuenda kunze kwomusasa agonomuongorora. Kana munhu aporeswa kubva kumaperembudzi, ");
INSERT INTO sna_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","muprista acharayira kuti shiri mbiri mhenyu dzakachena, nedanda romusidhari, nomucheka mutsvuku, nehisopi zviuyiswe kuti acheneswe. ");
INSERT INTO sna_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ipapo muprista acharayirwa kuti imwe yeshiri idzi iurayiwe pamusoro pemvura yakachena muhari yevhu. ");
INSERT INTO sna_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Anofanira zvino kutora shiri mhenyu oinyika pamwe chete nedanda romusidhari, mucheka mutsvuku nehisopi muropa reshiri yaurayiwa pamusoro pemvura yakachena. ");
INSERT INTO sna_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Achasasa uyo anofanira kucheneswa kubva kuchirwere chamaperembudzi kanomwe, agozivisa kuti akachena. Ipapo anofanira kuregera shiri mhenyu ichienda musango. ");
INSERT INTO sna_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Munhu anofanira kucheneswa anofanira kusuka nguo dzake agoveura bvudzi rake rose agoshamba nemvura, ipapo achava akacheneswa. Mushure maizvozvi anogona kuuya mumusasa asi anofanira kugara kunze kwetende rake kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pazuva rechinomwe anofanira kuveura bvudzi rake rose. Anofanira kuveura musoro wake, ndebvu dzake, tsiye dzake, nerimwe bvudzi rake rose. Anofanira kusuka nguo dzake agozvishambidza nemvura uye achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Pazuva rorusere anofanira kuuya namakwayana maviri amakondobwe nesheshe imwe chete, dzose dzine gore dzisina kuremara, pamwe chete nezvikamu zvitatu kubva mugumi zveefa zvoupfu hwakatsetseka hwakasanganiswa namafuta sechipiriso chezviyo nerogi imwe chete yamafuta. ");
INSERT INTO sna_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Muprista achazivisa kuti akachena, anofanira kuuya nouya anofanira kucheneswa nezvipiriso zvake pamberi paJehovha pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ipapo muprista anofanira kutora gwayana rimwe chete gono agoripa sechipiriso chemhosva pamwe chete nerogi ramafuta; achazvininira pamberi paJehovha sechipiriso chokuninira. ");
INSERT INTO sna_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Anofanira kubaya gwayana panzvimbo tsvene apo panobayirwa chipiriso chezvivi nechipiriso chinopiswa. Sezvakaita chipiriso chezvivi, chipiriso chemhosva ndechomuprista, chitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Muprista anofanira kutora rimwe ropa rechipiriso chemhosva agoriisa pamucheto wenzeve yokurudyi yomunhu anocheneswa, pamunwe wake mukuru wokuruoko rwokurudyi uye napachigunwe chikuru chetsoka yake yokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ipapo muprista achatora imwe rogi yamafuta agodira muchanza choruoko rwake rworuboshwe, ");
INSERT INTO sna_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","agonyika munwe wake wokutendeka nawo wokurudyi mumafuta ari muchanza choruoko rwake agosasa mamwe acho nomunwe kanomwe pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Muprista achaisa mamwe mafuta anosara muchanza panzeve yokurudyi youyo anofanira kucheneswa, pamunwe mukuru woruoko rwake rwokurudyi nepachigunwe chikuru chegumbo rake rokurudyi pamusoro peropa rechipiriso chemhosva. ");
INSERT INTO sna_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mamwe mafuta ose ari muchanza make muprista achaaisa pamusoro pouyo achada kucheneswa, agomuyananisira pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Ipapo muprista achabayira chipiriso chechivi agoyananisira uyo anofanira kucheneswa kubva pakusachena kwake. Mushure maizvozvo muprista achabaya chipiriso chinopiswa ");
INSERT INTO sna_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","agochipa paaritari pamwe chete nechipiriso chezviyo, agomuyananisira, uye achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Asi kana ari murombo asingakwanisi kuuya naizvozvi, anofanira kutora gwayana gono sechipiriso chemhosva kuti aninire agomuyananisira pamwe chete nechikamu chimwe chete kubva mugumi cheefa youpfu hwakatsetseka hwakasangana namafuta sechipiriso chezviyo, zvikamu zviviri kubva muzvitatu zverogi ramafuta, ");
INSERT INTO sna_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","njiva mbiri kana hangaiwa mbiri dzaanokwanisa kuuya nadzo, imwe yechipiriso chechivi neimwe yechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Pazuva rorusere anofanira kuzviuyisa kumuprista pamusuo weTende Rokusangana pamberi paJehovha, kuti acheneswe. ");
INSERT INTO sna_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Muprista anofanira kutora gwayana rechipiriso chemhosva nerogi ramafuta agozvininira pamberi paJehovha sechipiriso chokuninira. ");
INSERT INTO sna_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Achabaya gwayana rechipiriso chemhosva agotora rimwe ropa raro agoriisa panzeve yokurudyi yomunhu anoda kucheneswa, pamunwe mukuru woruoko rwokurudyi napachigunwe chikuru chepagumbo rokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Muprista achadira mamwe mafuta muchanza choruoko rwake rworuboshwe ");
INSERT INTO sna_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","uye nomunwe wake wokurudyi wokutendeka nawo agomwaya mamwe mafuta anobva muchanza chake kanomwe pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mamwe mafuta ari muchanza chake anofanira kuaisa munzvimbo dzimwe chetedzo dzaakaisa ropa rechipiriso chemhosva panzeve yokurudyi youyo anoda kucheneswa, pamunwe mukuru woruoko rwake rwokurudyi napachigunwe chikuru chegumbo rake rokurudyi. ");
INSERT INTO sna_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mamwe mafuta ose achasara muchanza muprista achaaisa mumusoro mouyo anofanira kucheneswa, kuti ayananisirwe pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ipapo achabayira njiva kana hangaiwa diki izvo zvaanogona kuwana, ");
INSERT INTO sna_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","imwe sechipiriso chechivi neimwe sechipiriso chinopiswa pamwe chete nechipiriso chezviyo. Nenzira iyi muprista achayananisira pamberi paJehovha, panzvimbo youya anofanira kucheneswa.” ");
INSERT INTO sna_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Iyi ndiyo mirayiro pamusoro pouyo ane chirwere chamaperembudzi uye asingakwanisi kuuya nezvipiriso zvinofanira kupiwa kuti acheneswe. ");
INSERT INTO sna_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Kana mapinda munyika yeKenani iyo yandiri kukupai senhaka, ndikaita chirwere chinopararira chamaperembudzi muimba iri munyika iyoyo, ");
INSERT INTO sna_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","muridzi weimba anofanira kuenda kundoudza muprista kuti, ‘Ndaona chimwe chinhu chinenge maperembudzi mumba mangu.’ ");
INSERT INTO sna_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ipapo muprista anofanira kurayira kuti vabudise zvose zviri mumba muprista asati apinda kundotarira hosha, kuti kurege kuva nechinhu chiri mumba chichanzi hachina kuchena. Mushure maizvozvo muprista anofanira kupinda agoongorora imba. ");
INSERT INTO sna_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Anofanira kuongorora chakwindi chiri mumadziro eimba uye kana pane makomba makomba ane ruvara rwezerere kana akatsvukuruka, ");
INSERT INTO sna_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","muprista anofanira kubuda napamusuo wemba agoipfiga kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pazuva rechinomwe muprista achadzoka kuzoongorora imba. Kana maperembudzi apararira pamadziro, ");
INSERT INTO sna_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","anofanira kurayira kuti matombo ane utachiona abviswe agorasirwa kunzvimbo isina kuchena kunze kweguta. ");
INSERT INTO sna_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ipapo ngaarayire kuti madziro ose omukati memba aparwe uye zvaparwa zvigoraswa kunzvimbo isina kuchena kunze kweguta. ");
INSERT INTO sna_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ipapo vanofanira kutora mamwe matombo vagotsiva aya vagotora ivhu idzva vakodzura imba. ");
INSERT INTO sna_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Kana chakwindi chikaonekwa zvakare mumba mushure mokunge matombo abviswa imba yaparwa uye yadzurwa, ");
INSERT INTO sna_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","muprista anofanira kuenda kunozvinanʼanidza. Kana maperembudzi apararira ihosha inoparadza, imba haina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Inofanira kupazwa, matombo ayo, mapuranga nokudzura kwose, zvotorwa zvoendeswa kunze kweguta kunzvimbo isina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Munhu upi noupi achapinda muimba iyi painenge ichakapfigwa achava asina kuchena kusvika manheru. ");
INSERT INTO sna_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Munhu wose achavata kana kuti achadya ari mumba iyoyo anofanira kusuka nguo dzake. ");
INSERT INTO sna_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Asi kana muprista akauya kuzoiongorora, akaona kuti maperembudzi haana kupararira mumba mushure mokunge yadzurwa, achati imba yakachena nokuti maperembudzi aenda. ");
INSERT INTO sna_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kuti anatse imba, anofanira kutora shiri mbiri nedanda romusidhari, mucheka mutsvuku nehisopi. ");
INSERT INTO sna_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Achaurayira imwe shiri pamusoro pemvura yakachena iri muhari yevhu. ");
INSERT INTO sna_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ipapo anofanira kutora puranga romusidhari, hisopi, mucheka mutsvuku, shinda neshiri mhenyu ozvinyika muropa reshiri yafa nemvura yakachena, uye agosasa mumba kanomwe. ");
INSERT INTO sna_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Achanatsa imba neropa reshiri, mvura yakachena, shiri mhenyu, danda romusidhari, hisopi uye nomucheka mutsvuku. ");
INSERT INTO sna_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ipapo anofanira kuregedza shiri mhenyu kuti iende hayo kunze kweguta kusango. Nenzira iyi achayananisira imba uye ichava yakachena.” ");
INSERT INTO sna_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Iyi ndiyo mirayiro yechirwere chamaperembudzi, kuvava, ");
INSERT INTO sna_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","maperembudzi pamucheka kana mumba, ");
INSERT INTO sna_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","uye kuzvimba, kufunuka, kana gwapa rakacheneruka, ");
INSERT INTO sna_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kuti mugoziva kuti chinhu chakachena kana kuti hachina kuchena. Iyi ndiyo mirayiro yezvirwere zvinotapuriranwa zvamaperembudzi. ");
INSERT INTO sna_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Taurai navaIsraeri muti kwavari, ‘Kana murume upi zvake ane zvimwe zvinoerera, zvinobuda pamuviri wake, uye achava asina kunaka nokuda kwokuerera uku. ");
INSERT INTO sna_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kunyange zvikaramba zvichibuda mumuviri wake kana kuti zvikamira zvichamuita kuti ave asina kuchena. Izvi ndizvo zvinoita kuti kuerera uku kumuite kuti ave asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Mubhedha upi zvawo unorarwa nomurume anobuda zvinoerera mumuviri wake uchava usina kuchena, uye chose chaachagara pachiri chichava chisina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ani naani anobata mubhedha wake anofanira kusuka nguo dzake agoshamba nemvura uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ani naani achagara pachigaro chagarwa nomurume anobuda zvinoerera anofanira kusuka nguo dzake uye agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Ani naani achabata murume iyeye anofanira kusuka nguo dzake agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Kana murume ane zvinoerera akasvipira mumwe munhu akachena, munhu iyeye anofanira kushambidza nguo dzake agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Chinhu chose chichatasvwa nomurume iyeye chichava chisina kuchena, ");
INSERT INTO sna_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","uye ani naani achabata zvinhu zvanga zviri pasi pake achava asina kuchena kusvikira manheru; ani naani anonhonga zvinhu izvozvo anofanira kusuka nguo dzake agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Ani naani achabatwa nomurume iyeye asina kushamba maoko ake anofanira kusuka nguo dzake agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Hari yevhu ichabatwa nomurume iyeye inofanira kuputswa uye mudziyo upi zvawo wakagadzirwa nomuti unofanira kusukwa nemvura. ");
INSERT INTO sna_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Kana murume acheneswa kubva pakuerera kwake, anofanira kuverenga mazuva manomwe okucheneswa kwake; anofanira kusuka nguo dzake agoshamba nemvura yakachena, uye achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pazuva rorusere anofanira kutora njiva mbiri kana hangaiwa diki mbiri agouya nadzo pamberi paJehovha pamusuo weTende Rokusangana agodzipa kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Muprista anofanira kudzibayira, imwe sechipiriso chechivi uye imwe sechipiriso chinopiswa. Nenzira iyi achamuyananisira pamberi paJehovha nokuda kwokuerera kwake. ");
INSERT INTO sna_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Kana mbeu yomurume upi noupi ikabuda kwaari, anofanira kushamba muviri wake wose nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Chipfeko chipi zvacho chake kana dehwe rine mbeu pariri rinofanira kusukwa nemvura uye richava risina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kana murume akavata nomukadzi uye akabuda mbeu, vaviri ava vanofanira kushamba nemvura uye vachava vasina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Kana mukadzi ari kumwedzi, kusachena kwokuenda kumwedzi kwake kuchapera mushure mamazuva manomwe, uye ani naani achamubata achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Chinhu chose chaachavata pachiri achiri kutevera chichava chisina kuchena uye chose chaachagara pachiri chichava chisina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ani naani achabata paanovata anofanira kusuka nguo dzake uye agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ani naani achabata chinhu chaachagara anofanira kusuka nguo dzake uye agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Mubhedha kana chimwe chinhu chaanga akagara, kana munhu upi noupi akachibata achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Kana murume akavata naye uye kuerera kwake kwomwedzi kukasangana naye, achava asina kuchena kwamazuva manomwe, kunyange mubhedha waanovata pauri uchava usina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Kana mukadzi ano kuerera kweropa kwamazuva akawanda panguva isiri yokuva kwake kumwedzi, kana kuti akava nokuerera kunoenderera kupfuura nguva yake yokuva kumwedzi kwake, achava asina kuchena kwenguva yaanobuda ropa sapamazuva ake okuva kumwedzi. ");
INSERT INTO sna_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Mubhedha upi zvawo waachavata pauri panguva yaanenge achiri kubuda ropa, uchava usina kuchena somubhedha wapakuva kwake kumwedzi, chose chaachagara chichava chisina kuchena sapanguva yokuva kwake kumwedzi. ");
INSERT INTO sna_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ani naani achazvibata achava asina kuchena; anofanira kusuka nguo dzake agoshamba nemvura, uye achava asina kuchena kusvikira manheru. ");
INSERT INTO sna_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Kana achinge acheneswa kubva pakuerera kwake anofanira kuverenga mazuva manomwe, mushure maizvozvo achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Pazuva rorusere anofanira kutora njiva mbiri kana hangaiwa mbiri diki agouya nadzo kumuprista pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Muprista anofanira kubayira imwe sechipiriso chechivi, uye imwe sechipiriso chinopiswa. Nenzira iyi achamuyananisira pamberi paJehovha pakusachena kwake kwokubuda ropa. ");
INSERT INTO sna_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Munofanira kutsaura vaIsraeri kubva pazvinhu zvose zvinoita kuti vave vasina kuchena, kuitira kuti vasafa mukusachena kwavo nokuda kwokuti vasvibisa nzvimbo yandinogara, iri pakati penyu.’ ” ");
INSERT INTO sna_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Iyi ndiyo mirayiro yomurume anenge ane zvinoerera, youpi noupi anenge asvibiswa nokubuda kwezvinoerera, ");
INSERT INTO sna_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","yomukadzi anenge ari kumwedzi, yomurume kana mukadzi anenge ane zvinoerera, uye neyomurume anovata nomukadzi anenge asina kuchena. ");
INSERT INTO sna_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Jehovha akataura naMozisi mushure mokufa kwavanakomana vaAroni vaviri avo vakafa pavakaswedera kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Jehovha akati kuna Mozisi, “Udza mukoma wako Aroni kuti asangopinda paanodira muNzvimbo Tsvene-tsvene kuseri kwechidzitiro pamberi pechigaro chenyasha paareka, nokuti angangofa, nokuti ndinozviratidza mugore pamusoro pechigaro chenyasha. ");
INSERT INTO sna_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aya ndiwo mapindiro anofanira kuita Aroni munzvimbo tsvene: apinde nehando diki yechipiriso chechivi uye negondobwe rechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Anofanira kupfeka nguo tsvene yomucheka, nguo dzomukati dzomucheka pamuviri wake; anofanira kusunga bhanhire romucheka muchiuno chake agopfeka nguwani yomucheka. Idzi ndidzo nguo tsvene, saka anofanira kushamba nemvura asati adzipfeka. ");
INSERT INTO sna_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kubva kuungano yavaIsraeri anofanira kutora nhongo mbiri dzechipiriso chechivi uye negondobwe rechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aroni anofanira kupa hando yechipiriso chechivi chake kuti azviyananisire iye nemhuri yake. ");
INSERT INTO sna_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ipapo anofanira kutora mbudzi mbiri agouya nadzo pamberi paJehovha pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Anofanira kukanda mijenya pambudzi mbiri idzi, mumwe mujenya waJehovha nomumwe wembudzi yokutakudzwa. ");
INSERT INTO sna_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aroni anofanira kuuya nembudzi yakabatwa nomujenya waJehovha agoibayira sechipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Asi mbudzi inosarudzwa nomujenya sembudzi yokutakudzwa ichauyiswa iri mhenyu pamberi paJehovha igoshandiswa pakuyananisira, icharegedzwa ichienda kurenje sembudzi yokutakudzwa. ");
INSERT INTO sna_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aroni anofanira kuuya nehando yake yechipiriso chake chechivi, kuti azviyananisire iye nemhuri yake, uye anofanira kubaya hando yechipiriso chake chechivi. ");
INSERT INTO sna_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Anofanira kutora hadyana yakazara namazimbe ari kubvira kubva paaritari pamberi paJehovha nezvanza zviviri zvezvinonhuhwira zvakatsetseka agoenda nazvo seri kwechidzitiro. ");
INSERT INTO sna_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Anofanira kuisa zvinonhuhwira pamusoro pomoto pamberi paJehovha, uye utsi hwezvinonhuhwira huchafukidza chigaro chenyasha pamusoro peChipupuriro, kuti asafa. ");
INSERT INTO sna_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anofanira kutora rimwe ropa rehando uye nomunwe wake agorisasa pamberi pechigaro chenyasha. ");
INSERT INTO sna_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Ipapo anofanira kubaya mbudzi yechipiriso chechivi chavanhu agotora agoenda neropa racho seri kwechidzitiro agoita naro sezvaakaita neropa rehando. Acharisasa pachigaro chenyasha napamberi pacho. ");
INSERT INTO sna_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nenzira iyi achayananisira Nzvimbo Tsvene-tsvene nokuda kwokudarika uye nokumukira kwavaIsraeri, zvisinei kuti zvivi zvavo zvanga zviri zvipi. Anofanira kuitira Tende Rokusangana zvimwe chetezvo, iro riri pakati pavo, pakati pokusachena kwavo. ");
INSERT INTO sna_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Hapana munhu anofanira kunge ari muTende Rokusangana panguva inopindwamo naAroni kunoyananisira muNzvimbo Tsvene-tsvene kusvikira abuda, azviyananisira iye nemhuri yake uye neungano yose yavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Ipapo achabuda oenda kuaritari iri pamberi paJehovha agoiyananisira. Achatora rimwe ropa rehando nerembudzi agoriisa panyanga dzose dzearitari. ");
INSERT INTO sna_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Achasasa rimwe ropa racho pairi nomunwe wake kanomwe kuti aichenese uye aitsaure kubva pakusachena kwavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Kana Aroni apedza kuyananisira Nzvimbo Tsvene-tsvene, Tende Rokusangana nearitari, achauya nembudzi mhenyu. ");
INSERT INTO sna_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Anofanira kuisa maoko ake ose pamusoro wembudzi mhenyu agoreurura pamusoro payo kuipa nokumukira kwose kwavaIsraeri, zvivi zvavo zvose agozviisa pamusoro pembudzi. Acharega mbudzi ichienda kurenje nomunhu anenge apiwa basa iroro. ");
INSERT INTO sna_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mbudzi iyi ichatakura pairi zvivi zvavo zvose kunzvimbo isina vanhu, uye munhu uyu achairegedzera murenje. ");
INSERT INTO sna_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Ipapo Aroni achapinda muTende Rokusangana agobvisa nguo dzomucheka dzaapfeka asati apinda muNzvimbo Tsvene-tsvene uye achadzisiya imomo. ");
INSERT INTO sna_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Achashamba nemvura munzvimbo tsvene agopfeka nguo dzake dzamazuva ose. Ipapo achabuda agobayira chipiriso chake chinopiswa nechipiriso chinopiswa chavanhu, agozviyananisira iye navanhu. ");
INSERT INTO sna_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Achapisawo mafuta echipiriso chechivi paaritari. ");
INSERT INTO sna_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Murume achandoregedzera mbudzi yokutakudzwa, anofanira kusuka nguo dzake agoshamba nemvura; mushure maizvozvo agozopinda mumusasa. ");
INSERT INTO sna_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Hando yechipiriso chezvivi nembudzi yechipiriso chezvivi, zvine ropa rinenge rauyiswa muNzvimbo Tsvene-tsvene kuti zviyananisire, zvinofanira kuendeswa kunze kwomusasa, matehwe acho, nyama namazvizvi zvinofanira kupiswa. ");
INSERT INTO sna_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Munhu anozvipisa anofanira kusuka nguo dzake agoshamba nemvura mushure maizvozvo agozopinda mumusasa. ");
INSERT INTO sna_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Uyu unofanira kuva mutemo unogara nokusingaperi kwamuri: Pazuva regumi romwedzi wechinomwe munofanira kutsanya musingaiti kana basa, chingava chizvarwa chenyu kana mutorwa agere pakati penyu, ");
INSERT INTO sna_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","nokuti pazuva iri muchayananisirwa, kuti mucheneswe. Ipapo, pamberi paJehovha muchava vakachena pazvivi zvenyu zvose. ");
INSERT INTO sna_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Isabata rokuzorora, uye munofanira kuzvinyima; uyu murayiro unogara nokusingaperi. ");
INSERT INTO sna_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Muprista akazodzwa nokugadzwa kuti atevere baba vake somuprista mukuru anofanira kuyananisira. Anofanira kupfeka nguo dzomucheka, nguo tsvene ");
INSERT INTO sna_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","agoyananisira Nzvimbo Tsvene-tsvene neTende Rokusangana, nearitari uye navaprista navamwe vanhu vose veungano. ");
INSERT INTO sna_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Uyu unofanira kuva murayiro unogara nokusingaperi kwamuri: Kuyananisira uku kunofanira kuitwa kamwe chete pagore, nokuda kwezvivi zvose zvavaIsraeri.” Uye zvakaitwa, sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Taura kuna Aroni navanakomana vake nokuvaIsraeri vose uti kwavari, ‘Izvi ndizvo zvakarayirwa naJehovha: ");
INSERT INTO sna_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","MuIsraeri upi zvake anobayira nzombe, gwayana kana mbudzi mumusasa kana kunze kwawo, ");
INSERT INTO sna_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","panzvimbo yokuuya nayo pamusuo weTende Rokusangana kuti aipe sechipiriso kuna Jehovha pamberi petabhenakeri yaJehovha, murume iyeye achanzi ane mhosva yokudeura ropa; adeura ropa saka anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Izvi zvinoitirwa kuti vaIsraeri vauye nezvibayiro zvavo zvavanobayira kusango, kuna Jehovha. Vanofanira kuuya nazvo kumuprista, ndiko kuti, kuna Jehovha, pamusuo wokupinda muTende Rokusangana vagozvibayira sezvipiriso zvokuwadzana. ");
INSERT INTO sna_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Muprista achasasa ropa paaritari yaJehovha pamusuo weTende Rokusangana agopisa mafuta kuti ave chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Havafanirizve kupa zvibayiro zvavo zvakare kuzvifananidzo zvembudzi izvo zvavanoita ufeve nazvo. Uyu uchava murayiro unogara nokusingaperi kwavari uye nokuzvizvarwa zvichatevera.’ ");
INSERT INTO sna_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Uti kwavari: ‘MuIsraeri upi zvake kana mutorwa agere pakati pavo anopa chipiriso chinopiswa kana chibayiro ");
INSERT INTO sna_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","uye agorega kuuya nacho kumusuo weTende Rokusangana kuzochipa kuna Jehovha, munhu iyeye anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘MuIsraeri upi zvake kana mutorwa agere pakati pavo anodya ropa ripi zvaro ndichanangana nomunhu iyeye anodya ropa uye ndichamubvisa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nokuti upenyu hwenyama huri muropa uye ndaripa kwamuri kuti rikuyananisirei paaritari; ropa ndiro rinoyananisira upenyu hwomunhu. ");
INSERT INTO sna_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Naizvozvo ndinoti kuvaIsraeri, “Hapana mumwe wenyu anofanira kudya ropa, uye hapana mutorwa agere pakati penyu anofanira kudya ropa.” ");
INSERT INTO sna_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘MuIsraeri upi zvake kana mutorwa agere pakati penyu anovhima mhuka ipi neipi ingadyiwa, anofanira kudurura ropa rayo agorifushira nevhu, ");
INSERT INTO sna_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","nokuti upenyu hwechisikwa chose iropa racho. Ndiko kusaka ndati kuvaIsraeri, “Hamufaniri kudya ropa rechisikwa chipi zvacho nokuti upenyu hwechisikwa huri muropa; ani naani anoridya anofanira kubviswa pakati pavanhu vokwake.” ");
INSERT INTO sna_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Ani naani, angava chizvarwa chenyu kana mutorwa, anodya chinhu chinowanikwa chakafa, kana kuti chinowanikwa chakabvarurwa nemhuka dzomusango, anofanira kusuka nguo dzake agoshamba nemvura uye achava asina kuchena kusvikira manheru; ipapo achava akachena. ");
INSERT INTO sna_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Asi kana akarega kusuka nguo dzake akashamba iye, achapiwa mhosva.’ ” ");
INSERT INTO sna_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Taura kuvaIsraeri uti kwavari, ‘Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hamufaniri kuita sezvavanoita kuIjipiti, kwamaigara uye hamufaniri kuita sezvavanoita kuKenani, kwandiri kukuendesai. Musatevera zviito zvavo. ");
INSERT INTO sna_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Munofanira kutevera mitemo yangu uye mugochenjerera kuti mutevere mirayiro yangu. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Chengetai mirayiro nemitemo yangu nokuti munhu anoiteerera achararama nayo. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Hapana anofanira kuswedera kuhama yepedyo kuti avate naye. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Usazvidza baba vako nokusangana namai vako. Ndimai vako usasangana navo. ");
INSERT INTO sna_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Usasangana nomukadzi wababa vako, izvi zvingazvidza baba vako. ");
INSERT INTO sna_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Usasangana nehanzvadzi yako kana mwanasikana wababa vako kana mwanasikana wamai vako, zvisinei kuti akaberekwa mumba mumwe chete kana kumwewo. ");
INSERT INTO sna_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Usasangana nomwanasikana womwanakomana wako kana mwanasikana womwanasikana wako; izvi zvingauyisa kuzvidzwa kwauri. ");
INSERT INTO sna_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Usasangana nomwanasikana womukadzi wababa vako akaberekwa nababa vako, ihanzvadzi yako. ");
INSERT INTO sna_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Usasangana nehanzvadzi yababa vako, ihama yababa vako yepedyo. ");
INSERT INTO sna_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Usasangana nomukoma kana mununʼuna wamai vako nokuti ihama yamai vako yepedyo. ");
INSERT INTO sna_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Usazvidza mununʼuna kana mukoma wababa vako nokuswedera kumukadzi wavo kuti uvate naye; nokuti ndimaiguru kana mainini. ");
INSERT INTO sna_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Usasangana nomuroora wako, mukadzi womwanakomana wako; usasangana naye. ");
INSERT INTO sna_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Usasangana nomukadzi womukoma kana mununʼuna wako; izvi zvingauyisa kuzvidzwa kwomukoma kana mununʼuna wako. ");
INSERT INTO sna_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Usasangana nomukadzi pamwe chete nomwanasikana wake. Usasangana nomwanasikana womwanakomana wake kana mwanasikana womwanasikana wake; ihama dzake dzepedyo. Zvakaipa izvozvo. ");
INSERT INTO sna_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Usatora mununʼuna womukadzi wako kuti ave mukadzinyina, varwisane, ugosangana naye mukadzi wako achiri mupenyu. ");
INSERT INTO sna_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Usaswedera kumukadzi kuti usangane naye panguva yokusachena kwokuenda kumwedzi kwake. ");
INSERT INTO sna_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Usasangana nomukadzi womuvakidzani wako ugozvisvibisa naye. ");
INSERT INTO sna_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Usapa ani zvake pakati pavana vako kuti vabayirwe kuna Moreki nokuti haufaniri kumhura zita raJehovha. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Usavata nomurume somurume anovata nomukadzi; zvinonyangadza. ");
INSERT INTO sna_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Usasangana nemhuka uye ugozvisvibisa nayo. Mukadzi haafaniri kuzvipa kumhuka kuti asangane nayo; uku kunyangadza kukuru. ");
INSERT INTO sna_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Musazvisvibisa neimwe yenzira idzi nokuti ndudzi dzandichadzinga pamberi penyu dzakazvisvibisa naizvozvo. ");
INSERT INTO sna_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kunyange nyika yakasvibiswa; naizvozvo ndakairanga nokuda kwezvakaipa zvayo uye nyika yakarutsa vagari vayo. ");
INSERT INTO sna_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Asi imi munofanira kuchengeta mirayiro yangu nemitemo yangu. Zvizvarwa zvenyu navatorwa vagere pakati penyu havafaniri kuita kana chimwe chezvinhu zvinonyangadza izvi, ");
INSERT INTO sna_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","nokuti zvinhu zvose izvi zvakaitwa navanhu vaigara munyika iyoyo musati mavamo, uye nyika ikasvibiswa. ");
INSERT INTO sna_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Uye kana mukasvibisa nyika, ichakurutsirai kunze sokurutsa kwayakaita ndudzi dzaigaramo imi musati mavamo. ");
INSERT INTO sna_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Ani naani anoita zvinonyangadza izvi, vanhu vakadaro vanofanira kubviswa kubva pavanhu vokwavo. ");
INSERT INTO sna_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Chengetai zvandakakurayirai uye musatevedzera kana imwe yetsika dzinonyangadza dzaiitwa musati mauya, uye musazvisvibisa nadzo. Ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Taura kuungano yose yeIsraeri uti kwavari, ‘Ivai vatsvene nokuti ini Jehovha Mwari wenyu ndiri mutsvene. ");
INSERT INTO sna_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Mumwe nomumwe wenyu anofanira kuremekedza mai nababa vake uye munofanira kuchengetedza maSabata angu. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Musava nehanya nezvifananidzo kana kuzviitira vamwari vesimbi dzakanyungudutswa. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Kana uchipa Jehovha chibayiro chechipiriso chokuwadzana, unofanira kuchipa nenzira inoita kuti chigamuchirwe pachinzvimbo chako. ");
INSERT INTO sna_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Chichadyiwa nomusi waunochibayira kana zuva rinotevera; chinhu chipi nechipi chinosiyiwa kusvika pazuva rechitatu chinofanira kupiswa. ");
INSERT INTO sna_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kana zvimwe zvacho zvikadyiwa pazuva rechitatu hazvina kuchena uye hazvigamuchirwi. ");
INSERT INTO sna_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ani naani anozvidya achapiwa mhosva nokuti asvibisa chitsvene kuna Mwari; munhu iyeye anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Kana uchikohwa mumunda wako usakohwa kusvika kumuchetocheto womunda wako, kana kunhongera zvawira pasi pakukohwa. ");
INSERT INTO sna_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Musakohwa kechipiri mumunda wemizambiringa kana kunhonga mazambiringa adonha. Zvisiyire varombo kana vatorwa. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Usaba. “ ‘Usareva nhema. “ ‘Musanyengedzana. ");
INSERT INTO sna_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Usapika nhema nezita rangu ugozvidza zita raMwari wako. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Usabiridzira muvakidzani wako kana kumutorera chinhu nechisimba. “ ‘Usachengeta mubayiro womushandi kusvikira mangwana. ");
INSERT INTO sna_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Usatuka matsi kana kuisa chigumbuso mberi kwebofu, asi itya Mwari wako. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Usaminamisa kururamisira, usatsaura murombo uchifarira mupfumi, asi tonga muvakidzani wako zvakakodzera. ");
INSERT INTO sna_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Usafamba uchiparadzira makuhwa pakati pavanhu vokwako. “ ‘Usaita chinhu chinoisa upenyu hwomuvakidzani wako panjodzi. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Usavenga hama yako mumwoyo mako. Tsiura muvakidzani wako zviri pachena kuitira kuti usazova nomugove pamhosva yake. ");
INSERT INTO sna_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Usatsvaka kutsiva kana kugara nedaka nomumwe wavanhu vokwako, asi ida muvakidzani wako sokuda kwaunozviita iwe. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Chengeta mirayiro yangu. “ ‘Usaberekesa mhando dzemhuka dzakasiyana. “ ‘Usadyara mbeu mbiri dzakasiyana mumunda mako. “ ‘Usapfeka nguo yakarukwa nemicheka miviri yakasiyana. ");
INSERT INTO sna_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Kana murume akavata nomukadzi ari murandakadzi akavimbiswa kuno mumwe murume, asi mukadzi asina kudzikinurwa kana kupiwa rusununguko rwake, panofanira kuva nokurangwa kwakakodzera. Asi haafaniri kuurayiwa nokuti mukadzi uyu anga asati asunungurwa. ");
INSERT INTO sna_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Zvisinei, murume uyu anofanira kuuya negondobwe kumusuo weTende Rokusangana rechipiriso chemhosva kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Negondobwe rechipiriso chemhosva muprista anofanira kumuyananisira pamberi paJehovha nokuda kwechivi chaakaita, uye chivi chake chicharegererwa. ");
INSERT INTO sna_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Kana mapinda munyika iyo mukadyara muchero upi noupi, torai michero yacho seisingabvumirwi. Kwamakore matatu munofanira kuitora seisingabvumirwi. Haifaniri kudyiwa. ");
INSERT INTO sna_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mugore rechina, michero yacho yose ichava mitsvene, chipiriso chokurumbidza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Asi mugore rechishanu mungadya michero yacho. Nenzira iyi gohwo renyu richawedzerwa. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Usadya nyama ipi neipi ichine ropa. “ ‘Usaita zvokushopera kana zvouroyi. ");
INSERT INTO sna_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Musacheka bvudzi renyu kumativi omusoro kana kudimurira ndebvu dzenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Musacheka miviri yenyu nokuda kwavakafa kana kuzviisa nyora. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Usaderedza unhu hwomwanasikana wako nokumuita chifeve nokuti nyika yose ichaita ufeve ikazara nouipi. ");
INSERT INTO sna_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Chengetedza maSabata angu uye uremekedze nzvimbo yangu tsvene. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Usaenda kumasvikiro nokune vezvemidzimu nokuti uchasvibiswa navo. Ndini Jehovha Mwari wako. ");
INSERT INTO sna_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Unofanira kusimukira vachena bvudzi, ratidza rukudzo kuna vakuru uye utye Mwari wako. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Kana mutorwa akagara nemi munyika, musamubate zvakaipa. ");
INSERT INTO sna_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mutorwa anogara nemi anofanira kubatwa sechizvarwa chenyu. Mudei sokuda kwamunozviita imi nokuti maiva vatorwa muIjipiti. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Musashandise zviero zvokubiridzira kana muchiera urefu, uremu kana uwandu. ");
INSERT INTO sna_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Shandisai zviyero zvechokwadi efa rechokwadi nehini yechokwadi. Ndini Jehovha Mwari wenyu akakubudisai muIjipiti. ");
INSERT INTO sna_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Chengetai mirayiro yangu yose nemitemo yangu yose, mugoitevera. Ndini Jehovha.’ ” ");
INSERT INTO sna_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Uti kuvaIsraeri, ‘MuIsraeri upi noupi kana mutorwa upi noupi agere muIsraeri achapa vana vake kuna Moreki anofanira kuurayiwa. Vanhu vomunyika yake vanofanira kumutaka namabwe. ");
INSERT INTO sna_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ndichanangana nomunhu iyeye uye ndichamubvisa pakati pavanhu vokwake, nokuti, nokuda kwokupa vana vake kuna Moreki, asvibisa nzvimbo yangu tsvene uye amhura zita rangu dzvene. ");
INSERT INTO sna_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kana vanhu vomunyika yake vakashaya hanya kana munhu uyu achipa mumwe wavana vake kuna Moreki vakasamuuraya, ");
INSERT INTO sna_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ndichanangana nomunhu uyo nemhuri yake, uye ndichamubvisa pakati pavanhu vokwake, iye pamwe chete navose vanomutevera pakuita ufeve naMoreki. ");
INSERT INTO sna_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Ndichanangana nomunhu uyo achaenda kumasvikiro, nokuvadzimu achiita ufeve nokuvatevera uye ndichamubvisa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Zvitsaurei mugove vatsvene nokuti ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Chengetai mitemo yangu mugoitevera. Ndini Jehovha anokuitai vatsvene. ");
INSERT INTO sna_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Ani naani anotuka baba kana mai vake anofanira kuurayiwa. Atuka baba kana mai vake uye ropa rake richava pamusoro pake. ");
INSERT INTO sna_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Kana mumwe akaita upombwe nomukadzi womumwe murume, kana nomukadzi womuvakidzani wake, vose murume mhombwe nomukadzi chifeve vanofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Kana murume akavata nomukadzi wababa vake azvidza baba vake. Vose murume nomukadzi vanofanira kuurayiwa. Ropa ravo richava pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Kana mumwe akavata nomuroora wake, vose vari vaviri vanofanira kuurayiwa, zvavaita kunyangadza kukuru; ropa ravo richava pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Kana mumwe akavata nomurume seanovata nomukadzi vose vari vaviri vaita zvinonyangadza. Vanofanira kuurayiwa. Ropa ravo richava pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Kana mumwe akawana mukadzi pamwe chete namai vake, zvakaipa. Vose iye naivo vanofanira kupiswa mumoto kuitira kuti pasawanikwe kuipa pakati penyu. ");
INSERT INTO sna_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Kana murume akavata nemhuka anofanira kuurayiwa uye munofanira kuuraya mhuka yacho. ");
INSERT INTO sna_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Kana mukadzi akaswedera kumhuka kuti avate nayo, urayai zvose mukadzi nemhuka yacho. Vanofanira kuurayiwa; ropa ravo richava pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Kana murume akawana hanzvadzi yake mwanasikana wababa vake, kana kuti wamai vake, uye vakavata vose, ichi chinyadziso. Vanofanira kubviswa pamberi pameso avanhu vokwavo. Azvidza hanzvadzi yake uye achava nemhosva. ");
INSERT INTO sna_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Kana murume akavata nomukadzi panguva yokuva kwake kumwedzi akasangana naye, afumura chaipo panobva kuyerera kwake, mukadziwo azvifumura. Vose vari vaviri vanofanira kubviswa pavanhu vokwavo. ");
INSERT INTO sna_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Usavata namainini kana vatete vako nokuti uku kuzvidza hama yapedyo; mose muri vaviri muchava nemhosva. ");
INSERT INTO sna_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Kana murume akavata nomukadzi wababamunini vake azvidza babamunini vake. Vachava nemhosva; vachafa vasina vana. ");
INSERT INTO sna_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Kana murume akawana mukadzi womukoma kana womununʼuna ichi chinhu chisina kunaka, azvidza mukoma kana mununʼuna wake. Vachashaya vana. ");
INSERT INTO sna_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Chengetai mirayiro yangu nemitemo yangu mugoitevera kuitira kuti nyika yandiri kukuendesai kwairi irege kukurutsirai kunze. ");
INSERT INTO sna_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Hamufaniri kutevera tsika dzendudzi dzandichadzinga pamberi penyu. Nokuti dzakaita zvinhu zvose izvi, ndikadzisema. ");
INSERT INTO sna_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Asi ndakati kwamuri, “Muchatora nyika yavo. Ndichaipa kwamuri senhaka, nyika inoerera mukaka nouchi.” Ndini Jehovha Mwari wenyu uyo akakutsaurai kubva kune dzimwe ndudzi. ");
INSERT INTO sna_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Naizvozvo unofanira kuisa mutsauko pakati pemhuka dzakachena nedzisina kuchena uye pakati peshiri dzakachena nedzisina kuchena. Musazvisvibisa nemhuka ipi zvayo kana shiri kana chimwe chinhu chinofamba pavhu, idzo dzandakatsaura sedzisina kuchena kwamuri. ");
INSERT INTO sna_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Munofanira kuva vatsvene kwandiri nokuti ini Jehovha ndiri mutsvene. Ndakakutsaurai kubva kundudzi kuti muve vangu ndoga. ");
INSERT INTO sna_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Murume kana mukadzi svikiro kana anoita zvemidzimu pakati penyu anofanira kuurayiwa. Munofanira kuvataka namabwe. Ropa ravo richava pamusoro pavo.’ ” ");
INSERT INTO sna_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Jehovha akati kuna Mozisi, “Taura kuvaprista vanakomana vaAroni uti kwavari: ‘Muprista haafaniri kuzvisvibisa, achiitira kunyange ani zvake pakati pavanhu vake vanofa. ");
INSERT INTO sna_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Kunze kwehama yepedyo yakaita samai kana baba vake, mwanakomana kana mwanasikana wake, mukoma kana mununʼuna wake, ");
INSERT INTO sna_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kana hanzvadzi yake isina kuroorwa yaanochengeta sezvo asina murume nokuda kwaiyeyu angagona kuzvisvibisa. ");
INSERT INTO sna_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Haafaniri kuzvisvibisa nokuda kwavanhu vano ukama naye hwokuwanana, akadaro azvisvibisa. ");
INSERT INTO sna_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Vaprista havafaniri kuveurwa misoro kana kudimburira ndebvu dzavo kana kutema miviri yavo nyora. ");
INSERT INTO sna_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Vanofanira kuva vatsvene kuna Mwari wavo uye havafaniri kumhura zita raMwari wavo. Nokuti vanouyisa kuna Jehovha zvipiriso zvinoitwa nomoto, nezvokudya zvaMwari wavo; naizvozvo vanofanira kuva vatsvene. ");
INSERT INTO sna_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Havafaniri kuwana vakadzi vakasvibiswa noufeve kana kuti vakarambwa navarume vavo nokuti muprista mutsvene kuna Mwari wake. ");
INSERT INTO sna_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mutsaurei somutsvene nokuti ndiye anouya nezvokudya zvaMwari wenyu. Mutsaurei somutsvene nokuti ini Jehovha ndiri mutsvene, ini ndinokuitai vatsvene. ");
INSERT INTO sna_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Kana mwanasikana womuprista akazvisvibisa nokuva chifeve, anonyadzisa baba vake; anofanira kupiswa mumoto. ");
INSERT INTO sna_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Muprista mukuru, uyo ari pakati pamadzikoma ake navanunʼuna vake, akadirwa mafuta okuzodzwa pamusoro pake uye akagadzwa kuti apfeke nguo dzouprista, haafaniri kurega bvudzi rake risina kukamiwa, kana kubvarura nguo dzake. ");
INSERT INTO sna_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Haafaniri kupinda munzvimbo ine chitunha. Haafaniri kuzvisvibisa kunyange nokuda kwababa vake kana mai vake, ");
INSERT INTO sna_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","kana kubva munzvimbo tsvene yaMwari kana kuisvibisa, nokuti akakumikidzwa namafuta okuzodza aMwari wake. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Mukadzi waanowana anofanira kunge ari mhandara izere. ");
INSERT INTO sna_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Haafaniri kuwana chirikadzi, mukadzi akarambwa kana mukadzi akasvibiswa noufeve asi mhandara yakazara bedzi kubva kuvanhu vokwake, ");
INSERT INTO sna_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kuitira kuti arege kuzosvibisa zvizvarwa zvake pakati pavanhu vokwake. Ndini Jehovha ndinomuita mutsvene.’ ” ");
INSERT INTO sna_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Uti kuna Aroni, ‘Kuzvizvarwa zvichatevera hakuna mumwe wezvizvarwa zvako akaremara angaswedera pedyo kuzopa zvokudya zvaMwari wake. ");
INSERT INTO sna_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Hapana munhu ano urema hupi zvahwo angaswedera pedyo: hakuna bofu kana anokamhina kana akaremara; ");
INSERT INTO sna_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","hakuna munhu ane gumbo rakaremara kana ruoko rwakaremara, ");
INSERT INTO sna_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kana ane musana wakakombama, munhu akapfupikisa kana ano urema hwamaziso kana ane mamota kana ane mhezi, kana akakuvara manhu ake. ");
INSERT INTO sna_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Hapana wechizvarwa chaAroni akaremara neipi nzira angaswedera pedyo kuzopa zvipiriso zvinoitirwa Jehovha nomoto. Ano urema; haafaniri kuswedera pedyo kuzopa zvokudya zvaMwari wake. ");
INSERT INTO sna_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Angadya hake zvokudya zvitsvene-tsvene zvaMwari wake, pamwe chete nezvokudya zvitsvene; ");
INSERT INTO sna_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","asi nokuda kwourema hwake, haafaniri kusvika pedyo nechidzitiro kana kusvika paaritari, agosvibisa nzvimbo yangu tsvene. Ndini Jehovha ndinovaita vatsvene.’ ” ");
INSERT INTO sna_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Saka Mozisi akataura izvi kuna Aroni navanakomana vake nokuvaIsraeri vose. ");
INSERT INTO sna_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Udza Aroni navanakomana vake kuti varemekedze zvipiriso zvitsvene zvavaIsraeri zvavanditsaurira kuti varege kusvibisa zita rangu dzvene. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Uti kwavari, ‘Kuzvizvarwa zvichatevera, kana mumwe wezvizvarwa zvenyu asina kuchena akaswedera pedyo nezvinhu zvakatsaurirwa Jehovha navaIsraeri, munhu iyeye anofanira kubviswa pamberi pangu. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Kana chizvarwa chaAroni chikava nechirwere chamaperembudzi kana akava nezvinoyerera pamuviri wake, haangadyi zvipiriso zvitsvene kusvikira acheneswa. Achavawo asina kuchena kana akabata chimwe chinhu chakasvibiswa nechitunha kana nomumwe murume anobuda mbeu, ");
INSERT INTO sna_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kana kuti akabata chose chinokambaira chingamusvibisa kana munhu upi zvake angamusvibisa, kungava kusachena kupi zvako. ");
INSERT INTO sna_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Munhu uyo achabata kusachena uku achava asina kuchena kusvikira manheru. Haafaniri kudya zvipiriso zvipi zvazvo zvitsvene kusvikira ashamba nemvura. ");
INSERT INTO sna_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Kana zuva rovira, achava akachena, uye mushure maizvozvo angadya zvipiriso zvitsvene, nokuti ndizvo zvokudya zvake. ");
INSERT INTO sna_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Haafaniri kudya chimwe chinhu chinowanikwa chakafa kana kuti chabvamburwa nemhuka dzesango, akazosvibiswa nayo. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Vaprista vanofanira kuchengeta zvandakarayira kuitira kuti vasava nemhosva uye vakazofa nokuda kwokuti vashora zvandakarayira. Ndini Jehovha anovaita vatsvene. ");
INSERT INTO sna_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Hakuna wokunze kwemhuri yomuprista angadya chipiriso chitsvene, kana mueni womuprista kana mushandi wake angachidya. ");
INSERT INTO sna_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Asi kana muprista akatenga nhapwa nemari, kana kuti nhapwa ikaberekerwa mumba make, nhapwa iyoyo inogona kudya chokudya chake. ");
INSERT INTO sna_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kana mwanasikana womuprista akawanikwa nomumwe munhu asiri muprista haagoni kudya chipi zvacho chezvitsvene zvinouyiswa kumuprista. ");
INSERT INTO sna_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Asi kana mwanasikana womuprista akava chirikadzi kana kuti akarambwa, iye asina vana, akadzoka kuzogara mumba mababa vake sapaudiki hwake, anogona kudya chokudya chababa vake. Asi munhu asina kukodzera haangadyi kudya uku. ");
INSERT INTO sna_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Kana munhu upi zvake akadya chipiriso chitsvene nokusaziva, anofanira kudzorera kumuprista chipiriso ichi agowedzera chikamu chimwe chete muzvishanu pamusoro. ");
INSERT INTO sna_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Vaprista havafaniri kusvibisa zvipiriso zvitsvene zvinopiwa navaIsraeri kuna Jehovha, ");
INSERT INTO sna_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nokuvabvumira kudya zvipiriso zvitsvene nokudaro vakazviuyisira mhosva pamusoro pavo inoda muripo. Ndini Jehovha, anovaita vatsvene.’ ” ");
INSERT INTO sna_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Taura kuna Aroni navanakomana vake nokuvaIsraeri vose uti kwavari, ‘Kana mumwe wenyu, angava muIsraeri kana mutorwa, anogara muIsraeri, akapa chipo kuti chive chipiriso chinopiswa kuna Jehovha, kungava kuzadzisa mhiko kana kungopawo chipo, ");
INSERT INTO sna_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","munofanira kupa mukono usina kuremara wemombe, kana gwai, kana mbudzi kuitira kuti zvigogamuchirwa panzvimbo yenyu. ");
INSERT INTO sna_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Musauya nechinhu chipi zvacho chakaremara nokuti hachizogamuchirwi panzvimbo yenyu. ");
INSERT INTO sna_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kana munhu akauyisa kubva mudanga remombe kana ramakwai chipiriso chokuwadzana kuna Jehovha achizadzisa kupika kwake kana kuti sechipo chokungopawo, chinofanira kuva chisina kuremara kana chisina gwapa kuti chigamuchirwe. ");
INSERT INTO sna_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Musapa kuna Jehovha zvakapofumara, zvakakuvara kana zvakaremara, kana chinhu chine mhezi kana chine maronda anopararira. Musaisa chipi zvacho chezvinhu izvi paaritari sechipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Munogona kupa zvakadaro sechipo chokungopawo, nzombe kana gwai rakaremera kana zvine mitezo yakarebesa kana yakapfupikisa, asi hazvigamuchirwi pakuzadzisa mhiko. ");
INSERT INTO sna_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Hamufaniri kupa kuna Jehovha chipiriso chemhuka ina manhu akakuvara, akatswanywa, akabvamburwa kana akachekwa. Hamufaniri kuita izvi munyika menyu. ");
INSERT INTO sna_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Uye hamufaniri kugamuchira mhuka dzakadai kubva mumaoko omutorwa muchizodzipa sechokudya chaMwari wenyu. Hadzizogamuchirwi panzvimbo yenyu nokuti dzakaremara uye hadzina kukwana.’ ” ");
INSERT INTO sna_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Mhuru, kana gwai, kana mbudzi ikaberekwa, inofanira kugara namai vayo kwamazuva manomwe. Kubva pazuva rorusere zvichienda mberi, ichagamuchirwa sechipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Musauraya mombe nomwana wayo kana gwai nomwana waro musi mumwe chete. ");
INSERT INTO sna_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Kana muchibayira Jehovha chibayiro chokuvonga, chibayirei nenzira inoita kuti chigogamuchirwa panzvimbo yenyu. ");
INSERT INTO sna_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Chinofanira kudyiwa musi iwoyo, musasiya zvimwe zvacho kusvikira mangwana. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Chengetai mirayiro yangu mugoitevera. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Musamhura zita rangu dzvene. Ndinofanira kuzivikanwa somutsvene navaIsraeri. Ndini Jehovha anokuitai vatsvene ");
INSERT INTO sna_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","uye akakubudisai kubva muIjipiti kuti ndive Mwari wenyu. Ndini Jehovha.” ");
INSERT INTO sna_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Taura kuvaIsraeri uti kwavari, ‘Iyi ndiyo mitambo yangu yandakatara, mitambo yakatarwa yaJehovha yamunofanira kudaidzira seungano tsvene. ");
INSERT INTO sna_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Pane mazuva matanhatu amunoshanda asi zuva rechinomwe iSabata rokuzorora, zuva reungano tsvene. Hamufaniri kuita basa ripi zvaro kwose kwamunogara, iSabata kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Iyi ndiyo mitambo yakatarwa yaJehovha, ungano tsvene dzamunodaidzira panguva dzakatarwa. ");
INSERT INTO sna_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Pasika yaJehovha inotanga madekwana pazuva regumi namana romwedzi wokutanga. ");
INSERT INTO sna_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Pazuva regumi namashanu romwedzi iwoyo Mutambo waJehovha weChingwa Chisina Mbiriso unotanga; kwamazuva manomwe munofanira kudya chingwa chinobikwa chisina mbiriso. ");
INSERT INTO sna_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Pazuva rokutanga itai ungano tsvene uye musaita mabasa amazuva ose. ");
INSERT INTO sna_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwamazuva manomwe mupe chipiriso chinoitirwa Jehovha nomoto. Uye pazuva rechinomwe munofanira kuita ungano tsvene uye musaita basa ramazuva ose.’ ” ");
INSERT INTO sna_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Taura kuvaIsraeri uti kwavari, ‘Kana mapinda munyika yandichakupai, mukakohwa gohwo rayo, uyai kumuprista nechisote chezviyo zvamunotanga kukohwa. ");
INSERT INTO sna_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Anofanira kuninira chisote pamberi paJehovha kuti chigamuchirwe panzvimbo penyu. Muprista anofanira kuchininira pazuva rinotevera Sabata. ");
INSERT INTO sna_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pazuva ramunoninira chisote, munofanira kubayira sechipiriso chinopiswa kuna Jehovha, gwayana rine gore rimwe chete risina kuremara, ");
INSERT INTO sna_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","pamwe chete nechipiriso chacho chezviyo chinokwana zvikamu zviviri kubva mugumi zveefa, zvoupfu hwakatsetseka hwakasanganiswa namafuta, chipiriso chinoitirwa Jehovha nomoto, chinonhuhwira zvinofadza, nechipiriso chacho chokunwa chikamu chimwe chete kubva muzvina zvehini rewaini. ");
INSERT INTO sna_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Hamufaniri kudya chingwa chipi zvacho, kana zviyo zvakakangwa, kana zviyo zvitsva, kusvikira zuva chairo ramunouya nechipiriso ichi kuna Mwari wenyu. Uyu unofanira kuva murayiro unogara nokusingaperi kuzvizvarwa zvichatevera, kwose kwamuchagara. ");
INSERT INTO sna_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Kubva pazuva rinotevera Sabata, zuva ramakauya nechisote chechipiriso chokuninira, verengai mavhiki manomwe azere. ");
INSERT INTO sna_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Verengai mazuva makumi mashanu kusvika pazuva rinotevera Sabata rechinomwe, ipapo mugopa chipiriso chezviyo zvitsva kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kubva kupi kwose kwamunogara, uyai nezvingwa zviviri zvakaitwa nezvikamu zviviri kubva mugumi zveefa zvoupfu hwakatsetseka zvakabikwa nembiriso sechipiriso chokuninira chezvibereko zvokutanga kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pamwe chete nechingwa ichi mupe makwayana manomwe asina kuremara egore rimwe nehando imwe chete diki namakondobwe maviri. Zvichava zvipiriso zvinopisirwa Jehovha, pamwe chete nezvipiriso zvezviyo nezvipiriso zvinonwiwa, chive chipiriso chinoitwa nomoto chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ipapo bayirai nhongo imwe chete sechipiriso chechivi namakwayana maviri, ose egore rimwe chete, sechipiriso chokuwadzana. ");
INSERT INTO sna_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Muprista anofanira kuninira makwayana maviri pamberi paJehovha sechipiriso chokuninira pamwe chete nechingwa chegohwo rokutanga. Izvi zvipiriso zvitsvene kuna Jehovha zvomuprista. ");
INSERT INTO sna_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Pazuva rimwe chetero munofanira kudaidzira ungano tsvene murege basa ramazuva ose. Uyu unofanira kuva murayiro unogara nokusingaperi kuzvizvarwa zvichauya, kwose kwamuchagara. ");
INSERT INTO sna_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Kana muchikohwa gohwo renyika yenyu musakohwa kusvikira kumucheto kwomunda wenyu, kana kunhongera zvinosara pakukohwa kwenyu. Zvisiyirei varanda navatorwa. Ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Uti kuvaIsraeri, ‘Pazuva rokutanga romwedzi wechinomwe munofanira kuva nezuva rokuzorora, ungano tsvene inocherechedzwa nokuridza hwamanda. ");
INSERT INTO sna_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Musaita basa ramazuva ose, asi mupe chipiriso chinoitirwa Jehovha nomoto.’ ” ");
INSERT INTO sna_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Zuva regumi romwedzi iwoyo wechinomwe iZuva Rokuyananisa. Muite ungano tsvene uye muzvinyime zvokudya, mugopa chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Musashanda pazuva iroro, nokuti iZuva Rokuyananisira, pamunoyananisirwa pamberi paJehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Munhu wose asingazvinyimi musi iwoyo anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Munhu upi noupi achaita basa ripi zvaro, nomusi iwoyo, ndichamuparadza pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Hamufaniri kutomboita basa. Uyu unofanira kuva murayiro unogara nokusingaperi kumarudzi ose achauya, kwose kwamuchagara. ");
INSERT INTO sna_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Iri iSabata renyu rokuzorora, uye munofanira kuzvinyima. Kubva manheru ezuva repfumbamwe romwedzi kusvikira manheru anotevera munofanira kucherechedza Sabata.” ");
INSERT INTO sna_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Uti kuvaIsraeri, ‘Pazuva regumi neshanu romwedzi wechinomwe Mutambo waJehovha waMatumba unotanga, uye uchapedza mazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Zuva rokutanga iungano tsvene; musaita basa ramazuva ose. ");
INSERT INTO sna_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwamazuva manomwe mupe kuna Jehovha zvipiriso zvinoitwa nomoto uye pazuva iroro muite ungano tsvene mugopa chipiriso chinoitirwa Jehovha nomoto. Iyi ndiyo ungano yokupedzisira; musaita basa ramazuva ose. ");
INSERT INTO sna_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Iyi ndiyo mitambo yaJehovha yakatarwa yamunofanira kuparidzira ungano tsvene kuti dziuye nezvipiriso zvinoitirwa Jehovha nomoto, nezvipiriso zvinopiswa uye nezvinopiswa zvezviyo, zvibayiro nezvipiriso zvokunwa zvinodiwa mazuva ose. ");
INSERT INTO sna_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Zvipiriso izvi zvinowedzerwa pamusoro pezviya zvamaSabata aJehovha uye pamusoro pezvipo zvenyu nezvose zvamakapikira nezvipiriso zvose zvokupa nokuzvisarudzira zvamunopa kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Zvino kutanga pazuva regumi namashanu romwedzi wechinomwe, mushure mokunge mapedza kukohwa zvirimwa zvenyika, muite mutambo wokupemberera kuna Jehovha kwamazuva manomwe; zuva rokutanga izuva rokuzorora, uye zuva rorusere izuva rokuzororawo. ");
INSERT INTO sna_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pazuva rokutanga munofanira kutsara michero yakanakisisa yemiti, nemichero yemichindwe, namatavi ana mashizha akawanda, nemikonachando, uye mugofara pamberi paJehovha Mwari wenyu kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Munofanira kuitira Jehovha mutambo uyu kwamazuva manomwe gore negore. Uyu unofanira kuva murayiro unogara nokusingaperi kuzvizvarwa zvichauya; muupemberere mumwedzi wechinomwe. ");
INSERT INTO sna_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Garai mumatumba kwamazuva manomwe: Zvizvarwa zvose zvavaIsraeri zvinofanira kugara mumatumba ");
INSERT INTO sna_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","kuitira kuti zvizvarwa zvenyu zvigoziva kuti ndakaita kuti vaIsraeri vagare mumatumba pandakavabudisa kubva muIjipiti. Ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Saka Mozisi akazivisa kuvaIsraeri mitambo yakatarwa yaJehovha. ");
INSERT INTO sna_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Rayira vaIsraeri kuti vauye kwauri namafuta akaisvonaka amaorivhi akasvinwa, omwenje, kuitira kuti mwenje irambe ichibvira nguva dzose. ");
INSERT INTO sna_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Kunze kwechidzitiro cheChipupuriro muTende Rokusangana, Aroni anofanira kuchengetedza mwenje iyi pamberi paJehovha kubva manheru kusvikira kwaedza, nguva dzose. Uyu unofanira kuva murayiro unogara nokusingaperi kuzvizvarwa zvichauya. ");
INSERT INTO sna_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Mwenje iri pachigadziko chomwenje chegoridhe rakaisvonaka chiri pamberi paJehovha inofanira kuchengetedzwa nguva dzose. ");
INSERT INTO sna_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Torai upfu hwakatsetseka mugobika zvingwa gumi nezviviri muchishandisa zvikamu zviviri kubva mugumi zveefa pachingwa chimwe nechimwe. ");
INSERT INTO sna_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Zviisei mumitsara miviri, zvitanhatu mumutsara mumwe nomumwe, patafura yegoridhe rakaisvonaka pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pamutsetse mumwe nomumwe isai zvinonhuhwira zvive chirangaridzo chinomirira chingwa uye zvive chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chingwa ichi chinofanira kuiswa pamberi paJehovha nguva nenguva, Sabata neSabata zvakamirira vaIsraeri sesungano inogara nokusingaperi. ");
INSERT INTO sna_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","NdechaAroni navanakomana vake, vanofanira kuchidyira munzvimbo tsvene, nokuti ichi chikamu chitsvene-tsvene chezvipiriso zvavo zvenguva nenguva zvinoitirwa Jehovha nomoto.” ");
INSERT INTO sna_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Zvino mwanakomana wavamwe mai vechiIsraeri uye baba vake vari vechiIjipita, akafamba pakati pavana vaIsraeri, uye mwanakomana womukadzi muIsraeri akarwa nomurume muIsraeri mumusasa. ");
INSERT INTO sna_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mwanakomana womukadzi muIsraeri akatuka Zita raJehovha nechituko; naizvozvo vakauya naye kuna Mozisi. (Zita ramai vake rainzi Sheromiti, mwanasikana waDhibhiri worudzi rwaDhani.) ");
INSERT INTO sna_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Vakamuisa mutorongo kusvikira kuda kwaJehovha kwaiswa pachena kwavari. ");
INSERT INTO sna_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Tora mutuki uende naye kunze kwomusasa. Vose vakamunzwa vanofanira kuisa maoko avo pamusoro wake uye ungano yose inofanira kumutaka namabwe. ");
INSERT INTO sna_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Uti kuvaIsraeri, ‘Kana munhu upi zvake akatuka Mwari wake achava nemhosva; ");
INSERT INTO sna_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ani naani anotuka zita raJehovha anofanira kuurayiwa. Ungano yose inofanira kumutaka namabwe. Kunyange ari mutorwa kana chizvarwa chenyu, akatuka Zita raJehovha anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Ani naani anouraya munhu, anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Munhu wose anouraya chipfuwo chomumwe munhu anofanira kuripa, upenyu hunotsiviwa noupenyu. ");
INSERT INTO sna_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kana munhu akakuvadza muvakidzani wake, zvose zvaaita zvinofanira kuitwa kwaari. ");
INSERT INTO sna_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kutyora kunotsiviwa nokutyora, ziso rinotsiviwa neziso, zino rinotsiviwa nezino. Sezvaakuvadza mumwe saka naiye anofanira kukuvadzwa. ");
INSERT INTO sna_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ani naani anouraya mhuka anofanira kuripa asi ani naani anouraya munhu anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Munofanira kuva nomutemo mumwe chete pamutorwa napachizvarwa chemo. Ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ipapo Mozisi akataura navaIsraeri, vakatora mutuki vakaenda naye kunze kwomusasa, vakamutaka namabwe akafa. VaIsraeri vakaita sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Jehovha akati kuna Mozisi pagomo reSinai, ");
INSERT INTO sna_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Taura kuvaIsraeri uti kwavari: ‘Kana mapinda munyika yandichakupai, nyika pachayo inofanira kucherechedza sabata kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kwamakore matanhatu dyarai minda yenyu, uye kwamakore matanhatu, dimurirai mizambiringa yenyu mugounganidza michero yayo. ");
INSERT INTO sna_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Asi mugore rechinomwe, nyika inofanira kuva nesabata rokuzorora, sabata kuna Jehovha. Musadyara minda yenyu kana kudimurira mizambiringa yenyu. ");
INSERT INTO sna_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Musakohwa zvinomera zvoga kana kukohwa mazambiringa amagoko. Nyika inofanira kuva negore rokuzorora. ");
INSERT INTO sna_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Gohwo ripi neripi renyika resabata richava zvokudya zvenyu, zvako iwe, murandarume wako nomurandakadzi wako, uye mushandi nomueni agere pakati penyu, ");
INSERT INTO sna_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","pamwe chete nezvipfuwo zvenyu nemhuka dzesango dziri munyika yenyu. Zvibereko zvose zvomunyika zvingadyiwa. ");
INSERT INTO sna_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Verengai maSabata manomwe amakore, makore manomwe akapetwa kanomwe, kuitira kuti maSabata manomwe amakore akwane nguva inoita makore makumi mana namapfumbamwe. ");
INSERT INTO sna_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ipapo urayire kuti hwamanda iridzwe kwose pazuva regumi romwedzi wechinomwe; paZuva Rokuyananisira ridzai hwamanda munyika yenyu yose. ");
INSERT INTO sna_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Tsaurai gore ramakumi mashanu mugoparidza rusununguko munyika yose kuvagari vayo vose. Richava Jubhiri kwamuri; mumwe nomumwe wenyu anofanira kudzokera kune zvake, uye mumwe nomumwe kumhuri yake. ");
INSERT INTO sna_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Gore ramakumi mashanu richava gore reJubhiri kwamuri. Musadyara uye musakohwa mazambiringa amagoko. ");
INSERT INTO sna_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nokuti iJubhiri uye rinofanira kuva dzvene kwamuri. Idyai chete zvinotorwa kubva muminda. ");
INSERT INTO sna_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Mugore iri reJubhiri munhu wose anofanira kudzokera kune zvake. ");
INSERT INTO sna_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Kana mukatengesa munda kuno mumwe womunyika menyu kana kutenga kwaari, musabiridzirana. ");
INSERT INTO sna_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Munofanira kutenga kubva kuvagari venyika yenyu zvichienderana nouwandu hwamakore kubva pagore reJubhiri. Uye iye anofanira kutengesa zvichienderana nouwandu hwamakore asara okukohwa zvirimwa. ");
INSERT INTO sna_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kana makore awanda, munofanira kuwedzera mutengo, uye kana makore ari mashoma, munofanira kudzikisa mutengo, nokuti zvaari kukutengeserai ndizvo chaizvoizvo uwandu hwezvirimwa. ");
INSERT INTO sna_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Musabiridzirana, asi ityai Mwari wenyu. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Teverai mitemo yangu mugochenjerera kuti muteerere mirayiro yangu, ipapo muchagara makachengetedzeka munyika. ");
INSERT INTO sna_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ipapo nyika ichabereka zvibereko zvayo uye imi muchadya kusvikira maguta, mugogara makachengetedzeka. ");
INSERT INTO sna_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mungabvunza muchiti, “Ko, tichadyei mugore rechinomwe kana tisingadyari kana kukohwa zvirimwa zvedu?” ");
INSERT INTO sna_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ndichakutumirai ropafadzo mugore rechitanhatu zvokuti nyika ichabereka zvinokwana makore matatu. ");
INSERT INTO sna_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Pamunenge muchidyara mugore rorusere muchadya kubva kuzvirimwa zvakare, uye mucharamba muchidya kubva kwazviri kusvika gohwo regore rechipfumbamwe rasvika. ");
INSERT INTO sna_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Munda haufaniri kutengeswa nokusingaperi, nokuti nyika ndeyangu uye imi muri vatorwa navaeni kwandiri. ");
INSERT INTO sna_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Munyika yose yamuchatora, munofanira kutendera kudzikinurwa kwenyika. ");
INSERT INTO sna_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Kana mumwe wavagari venyika yenyu akava murombo akatengesa zvimwe zvezvinhu zvake, hama yake yepedyo inofanira kuuya kuzodzikinura zvakatengeswa nehama yake. ");
INSERT INTO sna_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Zvisinei, kana munhu ashaya angamudzikinurira zvinhu izvi, asi iye akazobudirira akawana nzira dzakakwana dzokuzvidzikinura, ");
INSERT INTO sna_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","anofanira kupima kukosha kwomutengo wazvo kubva pagore raakazvitengesa, agodzosera zvasara pamuripo wazvo, kumurume waakazvitengesera; ipapo angadzokera kune zvake. ");
INSERT INTO sna_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Asi kana akashaya nzira dzokumudzorera nadzo, zvaakatengesa zvicharamba zviri mumaoko omutengi kusvikira gore reJubhiri. Zvichadzoserwa mugore reJubhiri uye iye achagona kudzokera kune zvake. ");
INSERT INTO sna_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Kana munhu akatengesa imba muguta rino rusvingo, anoramba aine mvumo yokuidzikinura kwegore rose shure kwokutengeswa kwayo. Munguva iyoyo anogona kuidzikinura. ");
INSERT INTO sna_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kana isina kudzikinurwa gore risati rapfuura, imba iri muguta rino rusvingo ichava yowakatenga nezvizvarwa zvake nokusingaperi. Haifaniri kudzorerwa paJubhiri. ");
INSERT INTO sna_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Asi dzimba dziri mumisha isina kukomberedzwa namasvingo dzinofanira kuonekwa sesango. Dzinogona kudzikinurwa uye dzinofanira kudzoserwa muJubhiri. ");
INSERT INTO sna_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘VaRevhi vane mvumo nguva dzose yokudzikinura dzimba dzavo mumaguta avaRevhi, anova avo. ");
INSERT INTO sna_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Naizvozvo zvinhu zvavaRevhi zvinogona kudzikinurwa, zvichireva kuti imba inotengeswa muguta ravo ripi neripi inofanira kudzoserwa muJubhiri, nokuti dzimba dziri mumaguta avaRevhi zvinhu zvavo pakati pavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Asi mafuro amaguta avo haafaniri kutengeswa; inhaka yavo inogara nokusingaperi. ");
INSERT INTO sna_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Kana mumwe wehama dzenyu akava murombo uye asisagoni kuzviriritira pakati penyu, mubatsirei sezvamunoita mutorwa kana mueni kuti arambe achigara pakati penyu. ");
INSERT INTO sna_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Musatora mhindu yemhando ipi zvayo kubva kwaari, asi ityai Mwari wenyu kuitira kuti hama yenyu irambe ichigara pakati penyu. ");
INSERT INTO sna_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Hamufaniri kumukweretesa mari muchiti ichazobereka mhindu kana kumutengesera zvokudya zvine mhindu. ");
INSERT INTO sna_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ndini Jehovha Mwari wenyu akakubudisai kubva muIjipiti kuti ndikupei nyika yeKenani uye kuti ndive Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Kana mumwe wehama dzenyu akava murombo pakati penyu akazvitengesa kwamuri, musamuita kuti ashande somuranda. ");
INSERT INTO sna_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Anofanira kubatwa somushandi wamaricho kana kuti mushanyi ari pakati penyu; anofanira kukushandirai kusvikira Gore reJubhiri. ");
INSERT INTO sna_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ipapo iye navana vake vanofanira kusunungurwa, uye achadzokera kurudzi rwake nokuzvinhu zvamadzitateguru ake. ");
INSERT INTO sna_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Nokuti vaIsraeri varanda vangu vandakabudisa kubva muIjipiti, havafaniri kutengeswa senhapwa. ");
INSERT INTO sna_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Musavatonga neutsinye, asi ityai Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Nhapwa dzenyu dzechirume nedzechikadzi dzinofanira kubva mundudzi dzakakukomberedzai; munogona kutenga nhapwa kubva kwavari. ");
INSERT INTO sna_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Munogona kutengawo vatorwa vashanyi vagere pakati penyu nemhuri dzavo dzakaberekerwa munyika yenyu, uye vachava pfuma yenyu. ");
INSERT INTO sna_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Munogona kuvaita nhaka yavana venyu uye kuvaita nhapwa kweupenyu hwavo hwose, asi hamufaniri kutonga vamwe vaIsraeri zvakaomarara. ");
INSERT INTO sna_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Mutorwa kana mushanyi pakati penyu akava mupfumi, uye mumwe wavanhu venyika yenyu akava murombo akazvitengesa kumutorwa agere pakati penyu, kana kumhuri yomutorwa, ");
INSERT INTO sna_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","anoramba ane mvumo yokudzikinurwa mushure mokunge azvitengesa. Mumwe wehama dzake anogona kumudzikinura: ");
INSERT INTO sna_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Babamunini vake kana mwanakomana wababamunini vake, kana hama yake yapedyo worudzi rwake angamudzikinura. ");
INSERT INTO sna_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Iye neanomutenga vanofanira kuverenga nguva kubva pagore raakazvitengesa kusvikira paGore reJubhiri. Mutengo wokusunungurwa kwake unofanira kuenzaniswa nemari inoripwa mushandi wemaricho kwamakore iwayo. ");
INSERT INTO sna_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kana kuchine makore akawanda asara, anofanira kuripira rudzikinuro rwake, chikamu chikuru chemari yaakaripirwa. ");
INSERT INTO sna_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kana kwasara makore mashoma shoma Gore reJubhiri risati rasvika, anofanira kurangana naye agodzosera mari yorudzikinuro rwake zvichienzaniswa namakore ake. ");
INSERT INTO sna_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Anofanira kubatwa somushandi wemaricho gore rimwe nerimwe; munofanira kuona kuti tenzi wake haamutongi zvakaomarara. ");
INSERT INTO sna_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Kunyange zvake asina kudzikinurwa neimwe yenzira idzi, iye navana vake vanofanira kusunungurwa mugore reJubhiri, ");
INSERT INTO sna_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","nokuti vaIsraeri ndevangu savaranda vangu. Varanda vangu vandakabudisa kubva muIjipiti. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Musaita zvifananidzo kana kumisa chifananidzo kana ibwe rinoyera kwamuri, uye musaisa dombo rakavezwa munyika yenyu kuti mukotamire pamberi paro. Ndini Jehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Chengetai maSabata angu uye muremekedze nzvimbo yangu tsvene. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Kana mukatevera mitemo yangu uye mukachenjerera kuti muteerere mirayiro yangu, ");
INSERT INTO sna_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ndichakutumirai mvura nenguva yayo, uye ivhu richabereka zvirimwa zvaro uye miti yesango ichabereka michero yayo. ");
INSERT INTO sna_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kupura kwenyu kuchasvika pakukohwa mazambiringa uye kukohwa mazambiringa kuchasvika pakudyara, uye muchadya zvose zvamunoda uye mugogara makachengetedzeka munyika menyu. ");
INSERT INTO sna_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Ndichapa rugare panyika, uye muchavata pasi pasina achakuvhundutsai. Ndichabvisa zvikara zvesango panyika, uye munondo haungazopfuuri nomunyika yenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Muchadzinganisa vavengi venyu, uye vachawa nomunondo pamberi penyu. ");
INSERT INTO sna_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vashanu venyu vachadzinganisa zana, uye zana renyu richadzinganisa zviuru gumi uye vavengi venyu vachawa nomunondo pamberi penyu. ");
INSERT INTO sna_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Ndichakutarisai nenyasha uye ndichaita kuti muve nezvibereko uye muwande, uye ndichachengeta sungano yangu nemi. ");
INSERT INTO sna_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Muchange muchiri kudya gohwo regore rakapera pamuchazobvisa kuti muise zvitsva. ");
INSERT INTO sna_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ndichadzika tabhenakeri yangu pakati penyu uye handizokusemai. ");
INSERT INTO sna_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ndichafamba pakati penyu ndigova Mwari wenyu, uye muchava vanhu vangu. ");
INSERT INTO sna_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ndini Jehovha Mwari wenyu, ndakakubudisai kubva munyika yeIjipiti kuti musazova varanda kuvaIjipita zvakare, ndakatyora matanda ejoko renyu ndikakufambisai makati twi. ");
INSERT INTO sna_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Asi kana mukasanditeerera uye mukasaita zvose izvi zvandinorayira, ");
INSERT INTO sna_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","uye mukaramba mitemo yangu, mukasema mirayiro yangu, mukatadza kuzadzisa zvose zvandakarayira, saizvozvo mukaputsa sungano yangu, ");
INSERT INTO sna_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ipapo ndichaita izvi kwamuri: Ndichauyisa pamusoro penyu zvinotyisa, zvirwere zvinoparadza nedenda richaparadza meso enyu, uye rigokusvetai upenyu hwenyu. Muchadyarira zviyo zvenyu pasina nokuti vavengi venyu vachazvidya. ");
INSERT INTO sna_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Chiso changu chichanangana nemi zvokuti muchakundwa navavengi venyu. Avo vanokuvengai vachakutongai, uye muchatiza kunyange pasina anokudzinganisai. ");
INSERT INTO sna_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Kana mukasanditeerera mushure maizvozvi zvose, ndichakurangai kakapetwa kanomwe nokuda kwezvivi zvenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ndichaputsa kuzvikudza kwenyu ndigoita kuti denga renyu rive sesimbi, uye ivhu riri pasi penyu sendarira. ");
INSERT INTO sna_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Simba renyu richaperera pasina nokuti ivhu renyu harizobereki zvibereko, kana miti yenyika yenyu, michero yayo. ");
INSERT INTO sna_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Kana mukaramba muchirwisana neni uye mukaramba kunditeerera, ndichawedzera matambudziko enyu zvakapetwa kanomwe, sezvakafanira zvivi zvenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ndichatuma zvikara zvesango kuti zvizokurwisai, uye zvichakutorerai vana venyu, zvigoparadza mombe dzenyu zvigokuitai vashoma zvokuti nzira dzenyu dzichasara dzisina vanhu. ");
INSERT INTO sna_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Ipapo kana musingadi kudzorwa neni pazvinhu izvi, asi mukaramba muchirwisana neni, ");
INSERT INTO sna_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ini pachangu ndicharwisana nemi, uye ndichakurangai kakapetwa kanomwe nokuda kwezvivi zvenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Uye ndichauyisa munondo wehondo pamusoro penyu kuti unditsivire kuputswa kwesungano. Kana mukatizira mumaguta enyu ndichatumira denda pakati penyu, uye muchaiswa mumaoko avavengi. ");
INSERT INTO sna_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kana ndikamisa mugove wenyu wechingwa, vakadzi gumi vachagona kubika chingwa chenyu pachoto chimwe chete, uye vachakanya chingwa chenyu zviri pamwero. Muchadya, asi hamungaguti. ");
INSERT INTO sna_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Mushure maizvozvi, mukaramba musinganditeereri asi mukaramba muchienderera mberi nokundirwisa, ");
INSERT INTO sna_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ipapo mukutsamwa kwangu ndicharwisana nemi, uye ini pachangu ndichakurangai nokuda kwezvivi zvenyu kakapetwa kanomwe. ");
INSERT INTO sna_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Muchadya nyama yavanakomana venyu nenyama yavanasikana venyu. ");
INSERT INTO sna_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ndichaparadza nzvimbo dzenyu dzakakwirira, ndigotemera pasi aritari dzenyu dzezvinonhuhwira uye ndigounganidza zvitunha zvenyu pamusoro pavamwari venyu vasina upenyu, uye ndichakusemai. ");
INSERT INTO sna_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ndichaita kuti maguta enyu ave matongo uye ndigoparadza nzvimbo dzenyu tsvene, uye handizofariri munhuwi unonhuhwira zvinofadza wezvipiriso zvenyu. ");
INSERT INTO sna_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ndichaparadza nyika yenyu, zvokuti vavengi venyu vanogaramo vachashamiswa. ");
INSERT INTO sna_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ndichakuparadzirai pakati pendudzi uye ndichabudisa munondo wangu ndigokudzingirirai. Nyika yenyu ichaparara, uye maguta enyu achava matongo. ");
INSERT INTO sna_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ipapo nyika ichafarira makore ayo esabata panguva yose yokuparadzwa kwayo pamunenge muri munyika yavavengi venyu; ipapo nyika ichazorora igofadzwa namasabata ayo. ");
INSERT INTO sna_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Panguva yose yokuparadzwa kwayo nyika ichava nezororo rayakashayiwa pamasabata panguva yamakararama mairi. ");
INSERT INTO sna_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Kana vari vamwe venyu vanosara, ndichaita kuti hana dzavo dzizare nokutya munyika dzavavengi vavo zvokuti kurira kweshizha rinopeperetswa nemhepo kuchaita kuti vatize. Vachamhanya vachiwirana sokunge vari kutiza munondo, vachawa kunyange pasina ari kuvadzinganisa. ");
INSERT INTO sna_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Vachabonderana sokunge vanotiza munondo, kunyange pasina anovadzinganisa. Saka hamuzogoni kumira pamberi pavavengi venyu. ");
INSERT INTO sna_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Muchaparara pakati pendudzi; nyika yavavengi venyu ichakuparadzai. ");
INSERT INTO sna_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Avo pakati penyu vachasara, vachaonda munyika dzavavengi vavo nokuda kwezvivi zvavo; uye vachaonda nokuda kwezvivi zvamadzibaba avo. ");
INSERT INTO sna_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Asi kana vakareurura zvivi zvavo nezvivi zvamadzibaba avo, kundimukira kwavo noruvengo rwavo kwandiri, ");
INSERT INTO sna_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","zvakaita kuti ndivarwise kusvikira ndavaendesa kunyika yavavengi vavo, ipapo kana mwoyo yavo isina kudzingiswa yaninipiswa, varipira zvivi zvavo, ");
INSERT INTO sna_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ndicharangarira sungano yangu naJakobho nesungano yangu naIsaka uye nesungano yangu naAbhurahama; uye ndicharangarira nyika iyi. ");
INSERT INTO sna_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nokuti nyika yavachasiya icharamba ichifarira masabata ayo kunyange yaparadzwa saizvozvo vasimo. Vacharipira zvivi zvavo nokuti vakaramba mirayiro yangu vakasema mitemo yangu. ");
INSERT INTO sna_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Asi kunyange zvakadaro, kana vari munyika yavavengi vavo, handizovarambi kana kuvasema kuti ndivaparadze zvachose, ndichiputsa sungano yangu navo. Ndini Jehovha Mwari wavo. ");
INSERT INTO sna_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Asi nokuda kwavo ndicharangarira sungano yandakaita namadzitateguru avo vandakabudisa kubva muIjipiti pamberi pendudzi dzose kuti ndive Mwari wavo. Ndini Jehovha.’ ” ");
INSERT INTO sna_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Iyi ndiyo mitemo, mirayiro nezvakatemwa zvakamiswa naJehovha pagomo reSinai pakati pake navaIsraeri kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Taura navaIsraeri uti kwavari, ‘Kana munhu akaita mhiko yakasarudzika yokuti akumikidze vanhu kuna Jehovha nokupa mutengo wakaenzanirana, ");
INSERT INTO sna_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","utare mutengo womunhurume ane makore ari pakati pamakumi maviri namakumi matanhatu pamashekeri makumi mashanu esirivha, zvichienzaniswa neshekeri rapanzvimbo tsvene; ");
INSERT INTO sna_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","uye kana ari munhukadzi, utare mutengo wake pamashekeri makumi matatu. ");
INSERT INTO sna_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kana ari munhu ana makore ari pakati pamashanu namakore makumi maviri, utare mutengo womunhurume pamashekeri makumi maviri, uye munhukadzi pamashekeri gumi. ");
INSERT INTO sna_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kana ari munhu ari pakati pomwedzi mumwe namakore mashanu, utare mutengo womunhurume pamashekeri mashanu esirivha uye utare pamunhukadzi mashekeri matatu esirivha. ");
INSERT INTO sna_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kana munhu ane makore makumi matanhatu kana anopfuura, utare mutengo womunhurume pamashekeri gumi namashanu, uye pamunhukadzi mashekeri gumi. ");
INSERT INTO sna_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kana munhu wose anenge achiita mhiko ari murombo zvikuru zvokutotadza kuripa muripo wakatarwa, anofanira kuuya nomunhu uyu kumuprista, achatara mutengo wake zvichienderana nezvinokwaniswa nomunhu ari kuita mhiko. ");
INSERT INTO sna_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Kana chaakapika chiri mhuka inogamuchirika sechipiriso kuna Jehovha, mhuka yakadai inopiwa kuna Jehovha ichava tsvene. ");
INSERT INTO sna_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Haafaniri kuchitsinhanisa kana kuisa chakanaka panzvimbo yechakaipa, kana chakaipa panzvimbo yechakanaka; kana akaisa mhuka pachinzvimbo cheimwe, dzose dziri mbiri neyatsinhanisa dzichava tsvene. ");
INSERT INTO sna_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kana chaakapika chiri mhuka isina kuchena, iyo isingagamuchiriki sechipiriso kuna Jehovha, mhuka iyi inofanira kupiwa kumuprista, ");
INSERT INTO sna_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","uyo achatara kukosha kwayo, kuti yakanaka kana kuti yakaipa. Mutengo upi noupi uchatemwa nomuprista, ndiwo uchave mutengo wayo. ");
INSERT INTO sna_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kana muridzi achida kudzikinura mhuka iyi, anofanira kupamhidzira chikamu chimwe chete muzvishanu pamutengo wayo. ");
INSERT INTO sna_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Kana munhu akakumikidza imba yake sechinhu chitsvene kuna Jehovha, muprista achatara kukosha kwayo kuti yakanaka here kana kuti yakaipa. Mutengo upi noupi uchatemwa nomuprista, ndiwo ucharamba uripo. ");
INSERT INTO sna_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kana murume anokumikidza imba yake akaidzikinura, anofanira kupamhidzira chikamu chimwe chete muzvishanu zvomutengo wayo. Uye imba ichava yake zvakare. ");
INSERT INTO sna_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Kana munhu akakumikidza kuna Jehovha chikamu chomunda wemhuri yake, mutengo wawo unofanira kutarwa zvichienderana nouwandu hwezviyo zvinodiwa ipapo, mashekeri makumi mashanu esirivha pahomeri yezviyo yebhari. ");
INSERT INTO sna_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kana akakumikidza munda wake mugore reJubhiri, mutengo wakatarwa unoramba uripo. ");
INSERT INTO sna_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Asi kana akakumikidza munda wake mushure meJubhiri, muprista achatara mutengo zvichienderana namakore asara Jubhiri rinotevera risati rasvika, uye mutengo wawo wakatarwa uchaderedzwa. ");
INSERT INTO sna_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kana murume anokumikidza munda achida kuudzikinura, anofanira kupamhidzira chikamu chimwe chete muzvishanu pamutengo wacho, uye munda uchava wake zvakare. ");
INSERT INTO sna_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kunyange zvakadaro, kana asingadzikinuri munda wake, kana akautengesera mumwe munhu, hauzogoni kudzikinurwa. ");
INSERT INTO sna_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kana munda ukasunungurwa muJubhiri, uchava mutsvene, somunda wakapiwa kuna Jehovha; uchava munda wavaprista. ");
INSERT INTO sna_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Kana munhu akakumikidza kuna Jehovha munda waakatenga, usiri chikamu chomunda wemhuri yake, ");
INSERT INTO sna_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","muprista achatara mutengo wawo kusvikira mugore reJubhiri, uye munhu uyu anofanira kuripa mutengo wawo musi iwoyo sechinhu chitsvene kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mugore reJubhiri munda uchadzokera kumunhu waakatengeserana naye uyo aiva muridzi womunda. ");
INSERT INTO sna_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Mutengo wose unofanira kutarwa zvichienderana neshekeri repanzvimbo tsvene, makumi maviri amagera pashekeri rimwe. ");
INSERT INTO sna_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Zvisinei hazvo, hapana munhu angakumikidza dangwe remhuka, sezvo dangwe ragara riri raJehovha kare; ingava mombe kana gwai; ndezvaJehovha. ");
INSERT INTO sna_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kana iri imwe yemhuka dzisina kuchena, anogona kuidzikinura nomutengo wayo wakatarwa, achipamhidzira chikamu chimwe chete muzvishanu pamutengo wayo. Kana isina kudzikinurwa, inofanira kutengeswa nomutengo wayo wakatarwa. ");
INSERT INTO sna_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Asi hakuna chinhu chomunhu chinopiwa kuna Jehovha, angava munhu kana mhuka kana munda wemhuri, chinogona kutengeswa kana kudzikinurwa; chinhu chose chinopiwa saizvozvo chinova chitsvene kwazvo kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Hakuna munhu anopiwa kuti aparadzwe angadzikinurwa; anofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Chegumi chezvinhu zvose zvinobva mumunda, zvingava zviyo zvinobva muvhu kana michero yemiti, ndezvaJehovha; zvitsvene kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kana munhu akadzikinura chimwe chinhu pazvegumi zvake, anofanira kupamhidzira chikamu chimwe chete muzvishanu pamutengo wacho. ");
INSERT INTO sna_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Chegumi chose chemombe namakwai, mhuka yose yegumi inopfuura napasi petsvimbo yomufudzi, ichava tsvene kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Haafaniri kusarudza zvakanaka kubva mune zvakaipa kana kuzvitsinhanisa. Kana akazvitsinhanisa, mhuka dzose dziri mbiri, yatsiviwa neyatsiva, dzichava tsvene uye hadzigoni kudzikinurwa.’ ” ");
INSERT INTO sna_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Iyi ndiyo mirayiro yavaIsraeri yakapiwa Mozisi naJehovha paGomo reSinai.");
INSERT INTO sna_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Jehovha akataura naMozisi muTende Rokusangana, vari murenje reSinai, nezuva rokutanga romwedzi wechipiri, mugore rechipiri shure kwokubuda kwavaIsraeri muIjipiti, achiti, ");
INSERT INTO sna_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Verenga ungano yose yavaIsraeri nedzimba dzavo uye nemhuri dzavo, uchinyora murume wose wose nezita rake, mumwe nomumwe. ");
INSERT INTO sna_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Iwe naAroni munofanira kuverenga varume vose vari muIsraeri namapoka avo vane makore makumi maviri kana anodarika vanogona kurwa muhondo. ");
INSERT INTO sna_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Murume mumwe chete kubva kurudzi rumwe norumwe, mumwe nomumwe ari mukuru wemhuri yake achakubatsira. ");
INSERT INTO sna_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Aya ndiwo mazita avarume vanofanira kukubatsira: “kubva kwaRubheni, Erizuri mwanakomana waShedheuri; ");
INSERT INTO sna_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kubva kwaSimeoni, Sherumieri mwanakomana waZurishadhai; ");
INSERT INTO sna_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kubva kwaJudha, Nashoni mwanakomana waAminadhabhi; ");
INSERT INTO sna_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kubva kwaIsakari, Netaneri mwanakomana waZuari; ");
INSERT INTO sna_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kubva kwaZebhuruni, Eriabhi mwanakomana waHeroni; ");
INSERT INTO sna_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kubva kuvanakomana vaJosefa: kubva kuna Efuremu, Erishama mwanakomana waAmihudhi; kubva kuna Manase, Gamarieri mwanakomana waPedhazuri; ");
INSERT INTO sna_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kubva kwaBhenjamini, Abhidhani mwanakomana waGidheoni; ");
INSERT INTO sna_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kubva kwaDhani, Ahiezeri mwanakomana waAmishadhai; ");
INSERT INTO sna_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kubva kwaAsheri, Pagieri mwanakomana waOkirani; ");
INSERT INTO sna_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kubva kwaGadhi, Eriasafi mwanakomana waDheueri; ");
INSERT INTO sna_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kubva kwaNafutari, Ahira mwanakomana waEnani.” ");
INSERT INTO sna_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ava ndivo varume vakatsaurwa kubva paungano, vatungamiri vamarudzi amadzibaba avo. Ndivo vaiva vakuru vedzimba dzavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mozisi naAroni vakatora varume ava vane mazita avakanga vapiwa, ");
INSERT INTO sna_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","vakaunganidza ungano yose pamwe chete pazuva rokutanga romwedzi wechipiri. Vanhu vakaratidza madzitateguru avo, dzimba dzavo nemhuri dzavo, uye varume vaiva namakore makumi maviri kana anodarika vakanyorwa mazita avo mumwe nomumwe, ");
INSERT INTO sna_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","sezvakanga zvarayirwa Mozisi naJehovha. Nokudaro akavaverenga muRenje reSinai: ");
INSERT INTO sna_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kubva kuzvizvarwa zvaRubheni mwanakomana wedangwe waIsraeri: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakaverengwa uye vakanyorwa mazita, mumwe nomumwe, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Vakaverengwa kubva kurudzi rwaRubheni vaiva zviuru makumi mana nezvitanhatu, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kubva kuzvizvarwa zvaSimeoni: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakaverengwa uye vakanyorwa mazita, mumwe nomumwe, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Vakaverengwa vaibva kurudzi rwaSimeoni vaisvika zviuru makumi mashanu nezvipfumbamwe, namazana matatu. ");
INSERT INTO sna_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kubva kuzvizvarwa zvaGadhi: Varume vose vaiva namakore makumi maviri kana anodarika, vaigona kurwa muhondo, vakanyorwa mazita maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Vakaverengwa kubva kurudzi rwaGadhi vaisvika zviuru makumi mana nezvishanu, namazana matanhatu namakumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kubva kuzvizvarwa zvaJudha: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Vakaverengwa kubva kurudzi rwaJudha vaisvika zviuru makumi manomwe nezvina, namazana matanhatu. ");
INSERT INTO sna_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kubva kuzvizvarwa zvaIsakari: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Vakaverengwa kubva kurudzi rwaIsakari vaisvika zviuru makumi mashanu nezvina, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kubva kuzvizvarwa zvaZebhuruni: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Vakaverengwa kubva kurudzi rwaZebhuruni vaisvika zviuru makumi mashanu nezvinomwe, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kubva kuvanakomana vaJosefa: Kubva kuzvizvarwa zvaEfuremu: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Vakaverengwa kubva kurudzi rwaEfuremu vaisvika zviuru makumi mana, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kubva kuzvizvarwa zvaManase: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Vakaverengwa kubva kurudzi rwaManase vaisvika zviuru makumi matatu nezviviri, namazana maviri. ");
INSERT INTO sna_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kubva kuzvizvarwa zvaBhenjamini: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Vakaverengwa kubva kurudzi rwaBhenjamini vaisvika zviuru makumi matatu nezvishanu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kubva kuzvizvarwa zvaDhani: Varume vose vaiva namakore makumi maviri kana anodarika, vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Vakaverengwa kubva kurudzi rwaDhani vaisvika zviuru makumi matanhatu nezviviri, namazana manomwe. ");
INSERT INTO sna_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kubva kuzvizvarwa zvaAsheri: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo uye nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Vakaverengwa kubva kurudzi rwaAsheri vaisvika zviuru makumi mana nechimwe chete, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kubva kuzvizvarwa zvaNafutari: Varume vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo vakanyorwa mazita, maererano nezvinyorwa zvedzimba dzavo nezvemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Vakaverengwa kubva kurudzi rwaNafutari vaisvika zviuru makumi mashanu nezvitatu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ava ndivo varume vakaverengwa naMozisi naAroni navatungamiri veIsraeri gumi nevaviri, mumwe nomumwe achimiririra mhuri yake. ");
INSERT INTO sna_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","VaIsraeri vose vaiva namakore makumi maviri kana anodarika vaigona kurwa muhondo yeIsraeri vakaverengwa maererano nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Vose vakaverengwa vakasvika zviuru mazana matanhatu nezvitatu, namazana mashanu ana makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Kunyange zvakadaro, mhuri dzavaRevhi hadzina kuverengwa pamwe chete navamwe. ");
INSERT INTO sna_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Jehovha akanga ati kuna Mozisi: ");
INSERT INTO sna_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Haufaniri kuverenga rudzi rwaRevhi kana kuvabatanidzira pakuverengwa kwavamwe vaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Asi ugadze vaRevhi kuti vave vatariri vetabhenakeri yeChipupuriro, napamusoro pemidziyo yayo yose; vanofanira kutakura tabhenakeri nemidziyo yayo yose; vanofanira kuichengeta nokuikomberedza nemisasa yavo. ");
INSERT INTO sna_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Panguva yose inobviswa tabhenakeri, vaRevhi ndivo vanofanira kuidzikisa pasi, uye panguva yose yainomiswa, vaRevhi ndivo vanofanira kuita izvozvo. Ani zvake mumwewo anoswedera kwairi achaurayiwa. ");
INSERT INTO sna_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","VaIsraeri vanofanira kudzika matende avo namapoka avo, murume mumwe nomumwe mumusasa wake pasi pomureza wokwake. ");
INSERT INTO sna_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Zvakadaro hazvo, vaRevhi, vanofanira kudzika matende avo vakapoteredza tabhenakeri yeChipupuriro kuitira kuti hasha dzirege kuwira pamusoro peungano yavaIsraeri. VaRevhi ndivo vane basa rokuchengeta tabhenakeri yeChipupuriro.” ");
INSERT INTO sna_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","VaIsraeri vakaita izvi zvose sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Jehovha akati kuna Mozisi naAroni: ");
INSERT INTO sna_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“VaIsraeri vanofanira kuvaka musasa vakapoteredza Tende Rokusangana nechokure, mumwe nomumwe pasi pomureza wokwake nezviratidzo zvedzimba dzamadzibaba ake.” ");
INSERT INTO sna_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kumabvazuva, kwakanangana nokunobuda nezuva, mapoka okwaJudha anofanira kuvaka misasa yawo pasi pomureza wavo. Mutungamiri wavanhu vaJudha ndiNashani mwanakomana waAminadhabhi. ");
INSERT INTO sna_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Boka rake rina vanhu vanosvika zviuru makumi manomwe nezvina, namazana matanhatu. ");
INSERT INTO sna_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Rudzi rwaIsakari ruchavaka misasa pedyo navo. Mutungamiri wavanhu vaIsakari ndiNetaneri mwanakomana waZuari. ");
INSERT INTO sna_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Boka rake rina vanhu vanosvika zviuru makumi mashanu nezvina, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Rudzi rwaZebhuruni ndirwo ruchatevera. Mutungamiri wavanhu vaZebhuruni ndiEriabhi mwanakomana waHeroni. ");
INSERT INTO sna_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Boka rake rina vanhu vanosvika zviuru makumi mashanu nezvinomwe, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Varume vose vanodiwa kumusasa waJudha maererano namapoka avo, vanokwana zviuru zana namakumi masere nezvitanhatu, namazana mana. Ava ndivo vachatanga kusimuka. ");
INSERT INTO sna_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Kurutivi rwezasi kuchava namapoka emisasa yaRubheni ichange iri pasi pomureza wavo. Mutungamiri wavanhu vokwaRubheni ndiErizuri mwanakomana waShedheuri. ");
INSERT INTO sna_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Boka rake rina vanhu vanosvika zviuru makumi mana nezvitanhatu, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Rudzi rwaSimeoni ruchavaka misasa pedyo navo. Mutungamiri wavanhu vokwaSimeoni ndiSharumiri mwanakomana waZurishadhai. ");
INSERT INTO sna_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Boka rake rina vanhu vanosvika zviuru makumi mashanu nezvipfumbamwe, namazana matatu. ");
INSERT INTO sna_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Rudzi rwaGadhi ndirwo ruchatevera. Eriasafi mwanakomana waDheueri ndiye mutungamiri wavanhu vokwaGadhi. ");
INSERT INTO sna_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Boka rake rina vanhu vanosvika zviuru makumi mana nezvishanu, namazana matanhatu namakumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Varume vose vakadanwa kumusasa waRubheni maererano namapoka avo, vaisvika zviuru zana namakumi mashanu nerimwe chete, namazana mana namakumi mashanu. Ndivo vachava vechipiri pakusimuka. ");
INSERT INTO sna_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ipapo Tende Rokusangana nomusasa wavaRevhi zvichasimuka pakati pemisasa. Vachasimuka zvimwe chetezvo zvavanoita pakumisa misasa, mumwe nomumwe panzvimbo yake, pasi pomureza wake. ");
INSERT INTO sna_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Nechokumavirira kuchava namapoka emisasa yaEfuremu ari pasi pemireza yawo. Mutungamiri wavanhu vokwaEfuremu ndiErishama mwanakomana waAmihudhi. ");
INSERT INTO sna_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Boka rake rina vanhu vanosvika zviuru makumi mana, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Rudzi rwaManase ndirwo ruchavatevera. Mutungamiri wavanhu vokwaManase ndiGamarieri mwanakomana waPedhazuri. ");
INSERT INTO sna_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Boka rake rina vanhu vanosvika zviuru makumi matatu nezviviri, namazana maviri. ");
INSERT INTO sna_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Rudzi rwaBhenjamini ndirwo ruchatevera. Mutungamiri wavanhu vokwaBhenjamini ndiAbhidhani mwanakomana waGidheoni. ");
INSERT INTO sna_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Boka rake rina vanhu vanosvika zviuru makumi matatu nezvishanu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Varume vose vakadanwa kumusasa waEfuremu, maererano namapoka avo, vanosvika zviuru zana nezvisere, nezana rimwe chete. Vachava vechitatu pakusimuka. ");
INSERT INTO sna_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Nechokumusoro kuchava namapoka emisasa yaDhani, pasi pomureza wavo. Mutungamiri wavanhu vokwaDhani ndiAhiezeri mwanakomana waAmishadhai. ");
INSERT INTO sna_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Boka rake rina vanhu vanosvika zviuru makumi matanhatu nezviviri, namazana manomwe. ");
INSERT INTO sna_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Rudzi rwaAsheri ruchadzika misasa pedyo navo. Mutungamiri wavanhu vokwaAsheri ndiPagieri mwanakomana waOkerani. ");
INSERT INTO sna_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Boka rake rina vanhu vanosvika zviuru makumi mana nechimwe chete namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Rudzi rwaNafutari ndirwo ruchatevera. Mutungamiri wavanhu vokwaNafutari ndiAhira mwanakomana waEnani. ");
INSERT INTO sna_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Boka rake rina vanhu vanosvika zviuru makumi mashanu nezvitatu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Varume vose vakadanwa kumusasa waDhani vanosvika zviuru zana namakumi mashanu nezvinomwe, namazana matanhatu. Ndivo vachava vokupedzisira pakusimuka, vari pasi pemireza yavo. ");
INSERT INTO sna_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ava ndivo vaIsraeri vakaverengwa maererano nemhuri dzavo. Vose vakanga vari mumisasa, namapoka avo vanosvika zviuru mazana matanhatu nezvitatu, namazana mashanu ana makumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Kunyange zvakadaro, vaRevhi havana kuverengwa pamwe chete navamwe vaIsraeri, sokurayirwa kwakanga kwaitwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Saizvozvo vaIsraeri vakaita zvose zvakarayirwa Mozisi naJehovha; ndiyo nzira yavakamisa nayo misasa yavo pasi pemireza yavo, uye ndiyo nzira yavakasimuka nayo, mumwe nomumwe neimba yake nemhuri yake. ");
INSERT INTO sna_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iyi ndiyo nhoroondo yemhuri yaAroni naMozisi panguva iyo Jehovha akataura naMozisi paGomo reSinai. ");
INSERT INTO sna_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Mazita avanakomana vaAroni aiva Nadhabhi dangwe rake, naAbhihu, naEreazari naItamari. ");
INSERT INTO sna_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ndiwo akanga ari mazita avanakomana vaAroni, ivo vaprista vakazodzwa, vakanga vagadzwa kuti vashumire savaprista. ");
INSERT INTO sna_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kunyange zvakadaro, Nadhabhi naAbhihu, vakafa pamberi paJehovha panguva yavakaita chipiriso nomoto wakanga usingabvumirwi pamberi pake muRenje reSinai. Vakanga vasina vanakomana; saka Ereazari naItamari chete ndivo vakashumira sevaprista, Aroni baba vavo vachiri vapenyu. ");
INSERT INTO sna_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Uyisa rudzi rwaRevhi ugovaisa pamberi paAroni muprista kuti vagomubatsira. ");
INSERT INTO sna_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Vanofanira kuita mabasa ake uye vagoshandira ungano yose paTende Rokusangana nokubata basa retabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Vanofanira kuchengeta midziyo yose yeTende roKusangana, vazadzise mabasa avaIsraeri pakuita kwavo basa retabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","VaRevhi uvape kuna Aroni navanakomana vake; ndivo vaIsraeri vanofanira kupiwa kwaari zvachose. ");
INSERT INTO sna_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ugadze Aroni navanakomana vake kuti vagoshumira savaprista; ani zvake mumwewo anoswedera panzvimbo tsvene anofanira kuurayiwa.” ");
INSERT INTO sna_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Jehovha akatizve kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ndakatora vaRevhi kubva pakati pavaIsraeri pachinzvimbo chedangwe romukomana rinoberekwa nomukadzi wose weIsraeri. VaRevhi ndevangu, ");
INSERT INTO sna_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nokuti matangwe ose ndeangu. Pandakauraya matangwe muIjipiti, ndakazvitsaurira dangwe rimwe nerimwe muIsraeri, angava munhu kana mhuka. Zvinofanira kuva zvangu. Ndini Jehovha.” ");
INSERT INTO sna_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Jehovha akati kuna Mozisi ari murenje reSinai, ");
INSERT INTO sna_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Verenga vaRevhi nemhuri dzavo uye nedzimba dzavo. Uverenge vanhurume vose vane mwedzi mumwe chete kana kupfuura pakuberekwa.” ");
INSERT INTO sna_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Saka Mozisi akavaverenga. Sezvaakanga arayirwa neshoko raJehovha. ");
INSERT INTO sna_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Aya ndiwo mazita avanakomana vaRevhi: Gerishoni, Kohati naMerari. ");
INSERT INTO sna_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Aya ndiwo aiva mazita edzimba dzavaGerishoni: Ribhini naShimei. ");
INSERT INTO sna_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Dzimba dzavaKohati: Amurami, Izhari, Hebhuroni naUzieri. ");
INSERT INTO sna_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Dzimba dzavaMerari: Mari naMushi. Idzi ndidzo dzaiva dzimba dzavaRevhi maererano nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kuna Gerishoni ndiko kwaiva nedzimba dzavaRibhini navaShimei; ndivo vakanga vari vedzimba dzavaGerishoni. ");
INSERT INTO sna_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Kuwanda kwavanhurume vose vaiva nomwedzi mumwe chete kana kupfuura pakuberekwa kwaisvika zviuru zvinomwe, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Vedzimba dzavaGerishoni vaifanira kuvaka misasa nechokumavirira, shure kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mutungamiri wemhuri yavaGerishoni akanga ari Eriasafi mwanakomana waRaeri. ");
INSERT INTO sna_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","VaGerishoni ndivo vaifanira kuchengeta tabhenakeri netende, zvifukidzo zvaro, chidzitiro chapamukova wokuTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","zvidzitiro zvaparuvazhe, chidzitiro chapamukova wokupinda paruvazhe runopoteredza tabhenakeri nearitari, uye netambo, nezvinhu zvose zvaishandiswapo. ");
INSERT INTO sna_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kuna Kohati ndiko kwaiva nedzimba dzavaAmiramu, vaIsraeri, vaHebhuroni navaIzhari; ava ndivo vakanga vari vedzimba dzavaKohati. ");
INSERT INTO sna_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kuwanda kwavanhu vose vaiva nomwedzi mumwe chete kana kupfuura pakuberekwa kwaisvika zviuru zvisere namazana matanhatu. VaKohati ndivo vaiva nebasa rokuchengeta nzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","VaKohati vaifanira kudzika matende avo nechezasi kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mutungamiri wemhuri yedzimba dzavaKohati akanga ari Erizafani mwanakomana waUzieri. ");
INSERT INTO sna_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ndivo vaiva nebasa rokuchengeta areka, tafura, chigadziko chomwenje, aritari, midziyo yomunzvimbo tsvene yaishandiswa pakushumira, chidzitiro, nezvose zvaidiwa pakuzvishandisa. ");
INSERT INTO sna_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mutungamiri mukuru wavaRevhi akanga ari Ereazari mwanakomana waAroni, muprista. Ndiye akagadzwa kuti ave pamusoro paavo vaiva nebasa rokuchengeta nzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Kuna Merari ndiko kwaiva nedzimba dzavaMari navaMushi; ava ndivo vakanga vari vedzimba dzavaMerari. ");
INSERT INTO sna_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Kuwanda kwavanhurume vose vaiva nomwedzi mumwe chete, kana kupfuura, pakuberekwa avo vakaverengwa, vakanga vachisvika zviuru zvitanhatu, namazana maviri. ");
INSERT INTO sna_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mutungamiri wemhuri yedzimba dzavaMerari akanga ari Zurieri mwanakomana waAbhihairi; uye ndivo vaifanira kuvaka misasa yavo nechokumusoro kwetabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","VaMerari vakanga vagadzwa kuti vave vachengeti vamatende etabhenakeri, mbariro dzayo, mbiru, hwaro, nhumbi dzayo dzose, nezvinhu zvose zvaishandiswa pamwe chete nazvo, ");
INSERT INTO sna_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","pamwe chete nembiru dzinopoteredza ruvazhe nehwaro hwadzo, mbambo dzetende netambo dzadzo. ");
INSERT INTO sna_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mozisi naAroni navanakomana vake vaifanira kudzika misasa yavo nechokumabvazuva kwetabhenakeri, kwakatarisana nokumabudazuva, mberi kweTende Rokusangana. Ndivo vaiva nebasa rokuchengeta nzvimbo tsvene vakamirira vaIsraeri. Ani zvake mumwewo aiswedera panzvimbo tsvene aifanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Kuwanda kwavaRevhi vakaverengwa pakurayira kwaJehovha kubudikidza naMozisi naAroni maererano nedzimba dzavo, zvichisanganisira vanhurume vose vaiva nomwedzi mumwe chete kana kupfuura pakuberekwa, kwaisvika zviuru makumi maviri nezviviri. ");
INSERT INTO sna_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Jehovha akati kuna Mozisi, “Verenga matangwe ose avanhurume avaIsraeri ano mwedzi mumwe chete kana kupfuura pakuberekwa ugonyora mazita avo. ");
INSERT INTO sna_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Unditorere vaRevhi pachinzvimbo chamatangwe ose avaIsraeri, uye nezvipfuwo zvavaRevhi pachinzvimbo chezvibereko zvokutanga zvose zvezvipfuwo zvavana vavaIsraeri. Ndini Jehovha.” ");
INSERT INTO sna_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Saka Mozisi akaverenga matangwe ose avaIsraeri, sezvaakarayirwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Kuwanda kwamatangwe avanhurume vaiva nomwedzi mumwe kana kupfuura pakuberekwa vakanyorwa mazita avo, kwaisvika zviuru makumi maviri nezviviri, namazana maviri namakumi manomwe navatatu. ");
INSERT INTO sna_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Jehovha akatizve kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Tora vaRevhi pachinzvimbo chamatangwe ose eIsraeri, uye zvipfuwo zvavaRevhi pachinzvimbo chezvipfuwo zvavo. VaRevhi vanofanira kuva vangu. Ndini Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kuti udzikinure mazana maviri namakumi manomwe navatatu vamatangwe avaIsraeri, ");
INSERT INTO sna_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","unofanira kutora mashekeri mashanu kubva kuno mumwe nomumwe wavo maererano namashekeri enzvimbo tsvene, anorema magera makumi maviri. ");
INSERT INTO sna_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Upe mari yokudzikinurwa kwavaIsraeri vanopfuura uwandu hunodiwa kuna Aroni navanakomana vake.” ");
INSERT INTO sna_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Saka Mozisi akatora mari yedzikinuro kubva kuna vakanga vapfuurira uwandu hwavaya vakanga vadzikinurwa navaRevhi. ");
INSERT INTO sna_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kubva kumatangwe eIsraeri akatora sirivha yairema chiuru chimwe, namazana matatu namakumi matanhatu namashanu amashekeri, maererano neshekeri renzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mozisi akapa mari yedzikinuro kuna Aroni navanakomana vake, sezvaakanga arayirwa neshoko raJehovha. ");
INSERT INTO sna_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Jehovha akati kuna Mozisi naAroni: ");
INSERT INTO sna_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Verenga vaKohati ivo bazi ravaRevhi nedzimba dzavo nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Uverenge varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vanouya kuzoshanda basa romuTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Iri ndiro basa ravaKohati muTende Rokusangana: kuchengetedza zvinhu zvitsvene-tsvene. ");
INSERT INTO sna_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kana ungano yosimuka Aroni navanakomana vake vanofanira kupinda vagobvisa chidzitiro vagofukidza areka yeChipupuriro nacho. ");
INSERT INTO sna_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ipapo vanofanira kuchifukidza namatehwe emhou dzomugungwa, vagowarira mucheka webhuruu pamusoro pacho uye vagoisa matanda panzvimbo yawo. ");
INSERT INTO sna_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Pamusoro petafura yoKuvapo, vanofanira kuwarira mucheka webhuruu vagoisa pamusoro pawo ndiro, madhishi uye mbiya, nemikombe yezvipiriso zvinonwiwa; chingwa chamazuva ose chinofanira kuramba chiri pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pamusoro pezvinhu izvi, vanofanira kuwarira mucheka mutsvuku, vagoifukidza namatehwe emhou dzomugungwa, vagoisa matanda acho panzvimbo yawo. ");
INSERT INTO sna_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Vanofanira kutora mucheka webhuruu vagofukidza chigadziko chomwenje wokuvhenekesa, pamwe chete nemwenje yacho netambo netireya dzacho nemidziyo yacho yose yamafuta anoshandiswa pakuvhenekesa. ");
INSERT INTO sna_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ipapo vanofanira kuchiputira pamwe chete nezvimwe zvacho muchifukidzo chamatehwe emhou dzomugungwa vagochiisa pamatanda okutakurisa nawo. ");
INSERT INTO sna_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Pamusoro pearitari yegoridhe, vanofanira kuwarira mucheka webhuruu vagoufukidza namatehwe emhou dzomugungwa vagopinza matanda panzvimbo yawo. ");
INSERT INTO sna_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Vanofanira kutora midziyo yose inoshandiswa pakushumira munzvimbo tsvene, vagoiputira mumucheka webhuruu, vagofukidza izvozvo namatehwe emhou dzegungwa uye vagozviisa pamatanda okutakurisa nawo. ");
INSERT INTO sna_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Vanofanira kubvisa madota paaritari yendarira vagowarira mucheka wepepuru pamusoro payo. ");
INSERT INTO sna_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ipapo vanofanira kuisa pamusoro payo midziyo yose inoshandiswa pakushumira paaritari kusanganisira namakango, forogo dzenyama, foshoro nembiya dzokusasa. Vanofanira kuwarira chifukidzo chamatehwe emhou dzegungwa pamusoro payo, vagopinza matanda ayo panzvimbo yawo. ");
INSERT INTO sna_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Mushure mokunge Aroni navanakomana vake vapedza kufukidza midziyo yose mitsvene, uye kana vava kusimuka, vaKohati ndivo vanofanira kuuya kuzotakura. Asi havafaniri kubata zvinhu zvitsvene, kuti varege kufa. VaKohati ndivo vanofanira kutakura zvinhu zviri muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Ereazari mwanakomana waAroni, muprista, anofanira kuva mutariri wamafuta emwenje, zvinonhuhwira, chipiriso chezviyo chamazuva ose uye namafuta okuzodza. Anofanira kuva mutariri wetabhenakeri yose nezvinhu zvose zviri mairi, kusanganisira nemidziyo yayo mitsvene.” ");
INSERT INTO sna_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Uone kuti rudzi rwavaKohati haruna kuparadzwa kubva pakati pavaRevhi. ");
INSERT INTO sna_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Kuti vararame uye varege kufa pavanoswedera pedyo nezvinhu zvitsvene, uvaitire izvi: Aroni navanakomana vake vanofanira kupinda munzvimbo tsvene vagorayira murume mumwe nomumwe basa rake nezvaanofanira kuita. ");
INSERT INTO sna_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Asi vaKohati havafaniri kupinda kundotarisa zvinhu zvitsvene, kana kwechinguva, kuti varege kufa.” ");
INSERT INTO sna_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Verengawo vaGerishoni nemhuri dzavo uye nedzimba dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Uverenge varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vanouya kuzoshanda basa romuTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ndiro basa redzimba dzavaGerishoni pavanoshanda vachitakura mitoro. ");
INSERT INTO sna_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Vanofanira kutakura zvidzitiro zvetabhenakeri, Tende Rokusangana, zvifukidzo zvaro uye zvifukidzo zvokunze zvamatehwe emhou dzegungwa, zvidzitiro zvapamukova wokupinda kuTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","zvidzitiro zvaparuvazhe runopoteredza tabhenakeri nearitari, chidzitiro chapamukova, tambo nemidziyo yose inoshandiswa pakushumira. VaGerishoni vanofanira kuita zvose zvinofanira kuitwa pakushandisa zvinhu izvi. ");
INSERT INTO sna_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mabasa avo ose kungava kutakura kana kuita rimwe basa, zvinofanira kuitwa nokurayira kwaAroni navanakomana vake. Muchavatuma sebasa ravo zvose zvavanofanira kutakura. ");
INSERT INTO sna_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ndiro basa redzimba dzavaGerishoni paTende Rokusangana. Vanofanira kurayirwa pamabasa avo naItamari mwanakomana waAroni muprista. ");
INSERT INTO sna_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Verenga vaMerari nedzimba dzavo nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Verenga varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vanouya kuzoshanda basa muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iri ndiro basa ravo pavanoshanda paTende Rokusangana: kutakura matanda etabhenakeri, mbariro dzayo, mbiru nehwaro, ");
INSERT INTO sna_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","pamwe chete nembiru dzinopoteredza ruvazhe nehwaro hwadzo, mbambo dzetende, tambo, midziyo yavo yose uye nezvose zvinoshandiswa pamwe chete nazvo. Govera murume mumwe nomumwe zvinhu zvaanofanira kutakura. ");
INSERT INTO sna_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Uhu ndihwo ushumiri hwedzimba dzavaMerari pakushanda kwavo paTende Rokusangana vachitungamirirwa naItamari mwanakomana waAroni, muprista.” ");
INSERT INTO sna_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mozisi, Aroni navatungamiri veungano vakaverenga vaKohati nedzimba dzavo uye nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vakauya kuzoshanda basa romuTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","vachiverengwa nedzimba dzavo, vaisvika zviuru zviviri, namazana manomwe namakumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Uku ndiko kwaiva kuwanda kwavose vedzimba dzavaKohati vaishanda muTende Rokusangana. Mozisi naAroni vakavaverenga maererano nokurayira kwaJehovha kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","VaGerishoni vakaverengwa nedzimba dzavo nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu, vakauya kuzoshanda pabasa romuTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","vachiverengwa nedzimba dzavo nemhuri dzavo, vaisvika zviuru zviviri, namazana matanhatu namakumi matatu. ");
INSERT INTO sna_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ndiko kwakanga kuri kuwanda kwaavo vakanga vari vedzimba dzavaGerishoni vaishanda muTende Rokusangana. Mozisi naAroni vakavaverenga maererano nokurayira kwaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","VaMerari vakaverengwa nedzimba dzavo uye nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vakauya kuzoshanda basa muTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","vachiverengwa nedzimba dzavo, vaisvika zviuru zvitatu, namazana maviri. ");
INSERT INTO sna_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Uku ndiko kwakanga kuri kuwanda kwaavo vaiva mudzimba dzavaMerari. Mozisi naAroni vakavaverenga maererano nokurayira kwaJehovha kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Saka Mozisi, Aroni navatungamiri veIsraeri vakaverenga vaRevhi vose nedzimba dzavo uye nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Varume vose kubvira pane vane makore makumi matatu kusvikira pane vane makore makumi mashanu vakauya kuzoshanda basa uye vachitakura Tende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","vakasvika zviuru zvisere, mazana mashanu namakumi masere. ");
INSERT INTO sna_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mumwe nomumwe akagoverwa basa rake akaudzwa zvokuita sokurayira kwaJehovha kubudikidza naMozisi. Saizvozvo vakaverengwa, sokurayirwa kwakaitwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Rayira vaIsraeri kuti vabudise mumusasa ani zvake ane chirwere cheganda romuviri kana kuerera kupi zvako, kana akasvibiswa nokuda kwechitunha. ");
INSERT INTO sna_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Uvabudise vose varume navakadzi zvimwe chetezvo; uvabudise kunze kwomusasa kuitira kuti varege kusvibisa musasa wavo, wandigere pakati pavo.” ");
INSERT INTO sna_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","VaIsraeri vakaita saizvozvo, vakavabudisa kunze kwomusasa. Vakaita sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Uti kuvaIsraeri: ‘Kana murume kana mukadzi akakanganisira mumwe nenzira ipi zvayo uye saizvozvo akasava akatendeka kuna Jehovha, munhu uyo ane mhosva, ");
INSERT INTO sna_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","uye anofanira kureurura chivi chaakaita. Anofanira kuripira zvizere mhosva yake, achiwedzera chikamu chimwe chete muzvishanu chayo agozvipa zvose kumunhu waakatadzira. ");
INSERT INTO sna_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Asi kana munhu uyo asina hama yepedyo uyo angapiwa zviri kuripirwa mhosva, muripo uyu ndowaJehovha uye unofanira kupiwa kumuprista, pamwe chete negondobwe rokumuyananisira. ");
INSERT INTO sna_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Zvinotsaurwa zvose zvinopiwa navaIsraeri kumuprista zvichava zvake. ");
INSERT INTO sna_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Zvipo zvakatsaurwa zvomunhu mumwe nomumwe ndezvake iye pachake, asi zvaanopa kumuprista zvichava zvomuprista.’ ” ");
INSERT INTO sna_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Taura kuvaIsraeri uti kwavari: ‘Kana mukadzi womunhu akatsauka, akasava akatendeka kwaari, ");
INSERT INTO sna_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","akavata nomumwe murume, uye izvi zvikavanzwa kumurume wake uye kusvibiswa kwake kusati kwabatwa (sezvo pasina chapupu pamusoro pake uye asati abatwa achiita izvozvo), ");
INSERT INTO sna_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","uye murume wake akava neshanje mukati make uye akafungira mukadzi wake, uye iye mukadzi achinge akasvibiswa, kana dai akava neshanje uye achimufungira kunyange zvake iye asina kusvibiswa, ");
INSERT INTO sna_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ipapo anofanira kutora mukadzi wake agoenda naye kumuprista. Anofanira kuendawo nechipiriso chechegumi cheefa youpfu hwebhari pachinzvimbo chake. Haafaniri kudira mafuta pamusoro pacho kana zvinonhuhwira pachiri, nokuti chipiriso chezviyo cheshanje, chipiriso chechiyeuchidzo chokurangaridza mhosva. ");
INSERT INTO sna_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Muprista achamuuyisa agoita kuti amire pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ipapo anofanira kutora mvura tsvene mumudziyo wevhu agoisa guruva rinobva pauriri hwetabhenakeri mumvura. ");
INSERT INTO sna_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Shure kwokunge muprista amisa mukadzi uyu pamberi paJehovha, achasunungura vhudzi rake agoisa mumaoko ake chipiriso chokuyeuchidza, chipiriso chezviyo cheshanje, muprista pachake akabata mvura inovava inouyisa chituko. ");
INSERT INTO sna_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ipapo muprista anofanira kuita kuti mukadzi uyu apike uye agoti kwaari, “Kana kusina mumwe murume akavata newe uye usina kumbotsauka ukava wakasvibiswa panguva yokuwanikwa kwako nomurume wako, mvura inovava iyi, iyo inouyisa kutukwa, ngairege kukukuvadza. ");
INSERT INTO sna_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Asi kana wakatsauka iwe wakawanikwa nomurume wako uye ukazvisvibisa nokuvata nomumwe murume pachinzvimbo chomurume wako,” ");
INSERT INTO sna_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ipapo muprista anofanira kuisa mukadzi uyu pachituko ichi chemhiko achiti, “Jehovha ngaaite kuti vanhu vako vakutuke uye vakurambe paanoita kuti chidya chako chionde uye kuti dumbu rako rizvimbe. ");
INSERT INTO sna_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mvura iyi inouyisa kutuka ngaipinde mumuviri wako kuitira kuti dumbu rako rizvimbe uye chidya chako chionde.” “ ‘Ipapo mukadzi anofanira kuti, “Ameni. Ngazviite saizvozvo.” ");
INSERT INTO sna_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Muprista anofanira kunyora zvituko izvi papepa ipapo agozvisuka mumvura inovava. ");
INSERT INTO sna_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Anofanira kunwisa mukadzi uyu mvura inovava, inouyisa kutukwa, uye mvura iyi ichapinda maari igouyisa kutambudzika nokuvaviwa. ");
INSERT INTO sna_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Muprista anofanira kutora kubva mumaoko omukadzi chipiriso chezviyo cheshanje, agochininira pamberi paJehovha nokuchiuyisa kuaritari. ");
INSERT INTO sna_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ipapo muprista anofanira kutora tsama yechipiriso chezviyo sechipiriso chokurangaridza agochipisa paaritari; shure kwaizvozvo, anofanira kunwisa mukadzi uyu mvura. ");
INSERT INTO sna_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kana akazvisvibisa uye anga asina kutendeka kumurume wake, ipapo kana zvaitwa kuti anwe mvura inouyisa kutukwa, ichapinda maari igoita kuti arwadziwe zvikuru; dumbu rake richazvimba uye chidya chake chichaonda, uye achava akatukwa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kunyange zvakadaro hazvo, kana mukadzi uyo asina kuzvisvibisa uye akachena achasunungurwa pamhosva iyo uye achagona kubereka vana. ");
INSERT INTO sna_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Uyu, zvino ndiwo murayiro weshanje kana mukadzi atsauka, akazvisvibisa iye ari mukadzi womunhu, ");
INSERT INTO sna_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","uye kana murume akava neshanje nokuda kwokufungira mukadzi wake. Muprista anofanira kumumisa pamberi paJehovha agotevedza murayiro uyu wose kwaari. ");
INSERT INTO sna_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Murume achange asina mhosva pakukanganisa kupi zvako, asi mukadzi achava nemhosva yechivi chake.’ ” ");
INSERT INTO sna_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Taura kuvaIsraeri uti kwavari: ‘Kana murume kana mukadzi akada kuita mhiko yakasarudzika, iyo mhiko yokuzvitsaurira kuna Jehovha somuNaziri, ");
INSERT INTO sna_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","anofanira kusanwa waini nezvimwe zvinodhaka uye haafaniri kunwa vhiniga yakaitwa newaini kana nezvimwe zvinonwiwa zvinodhaka. Haafaniri kunwa muto wamazambiringa, kana kudya mazambiringa, kana akaomeswa. ");
INSERT INTO sna_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Panguva yose youNaziri hwake, haafaniri kudya chinhu chipi zvacho chinobva pamuti womuzambiringa, dzingava mhodzi kana mateko zvawo. ");
INSERT INTO sna_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Mazuva ose okupika kwake kwokuzvitsaura hapana chisvo chichashandiswa kuveura musoro wake. Anofanira kuva mutsvene kusvikira nguva yokutsaurirwa kwake kuna Jehovha yapera; anofanira kurega bvudzi romusoro wake rirebe. ");
INSERT INTO sna_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Haafaniri kuswedera pachitunha mazuva ose aakazvitsaurira kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Kunyange kana baba vake chaivo, kana mai vake, kana mununʼuna kana hanzvadzi vafa, haafaniri kuzvisvibisa nokuda kwavo, nokuti chiratidzo chokuzvitsaurira kuna Mwari chiri pamusoro wake. ");
INSERT INTO sna_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Mutsvene kuna Jehovha pamazuva ake ose aakazvitsaura. ");
INSERT INTO sna_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Kana mumwe munhu akafa pakarepo iye ari ipapo, nokudaro akasvibisa bvudzi raakakumikidza, anofanira kuveura musoro wake nezuva rokunatswa kwake, iro zuva rechinomwe. ");
INSERT INTO sna_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ipapo nezuva rorusere anofanira kuuya nenjiva mbiri kana twana tuviri twenjiva kumuprista ari pamusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Muprista anofanira kupa imwe yacho sechipiriso chechivi uye imwe yacho sechipiriso chinopiswa kuti amuyananisire nokuti iye akatadza paakava pedyo nechitunha. Anofanira kunatsa musoro wake nezuva iroro. ");
INSERT INTO sna_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Anofanira kuzvikumikidza kuna Jehovha panguva yokuzvitsaura kwake uye anofanira kuuya nomukono wegwayana regore rimwe chete sechipiriso chemhosva. ");
INSERT INTO sna_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Zvino uyu ndiwo murayiro womuNaziri panopera nguva yokuzvitsaura kwake. Anofanira kuuyiswa kumusuo weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Anofanira kupa kuna Jehovha chipiriso chake ipapo: mukono wegore rimwe chete wegwayana risina charingapomerwa kuti rive chipiriso chinopiswa, sheshe yegwayana regore rimwe chete isina kuremara kuti chive chipiriso chokuwadzana, ");
INSERT INTO sna_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","pamwe chete nechipiriso chezviyo nechipiriso chokunwa, uye dengu rechingwa chisina mbiriso, keke rakaitwa noupfu hwakatsetseka hwakavhenganiswa namafuta, nezvingwa zvitete zvakazorwa mafuta. ");
INSERT INTO sna_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Muprista anofanira kuuya nazvo pamberi paJehovha agoita chipiriso chechivi nechipiriso chinopiswa. ");
INSERT INTO sna_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Anofanira kuuyisa dengu rechingwa chisina mbiriso uye agobayira gondobwe sechipiriso chokuwadzana kuna Jehovha, pamwe chete nechipiriso chezviyo nechipiriso chinonwiwa. ");
INSERT INTO sna_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Zvino pamusuo weTende Rokusangana, muNaziri anofanira kuveura bvudzi riya raakakumikidza. Anofanira kutora bvudzi iro agoriisa mumoto uri pasi pechibayiro chokuwadzana. ");
INSERT INTO sna_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Shure kwokunge muNaziri aveura bvudzi rokuzvikumikidza kwake, muprista anofanira kuisa mumaoko ake bandauko rakabikwa regondobwe, uye keke nechingwa chitete kubva mudengu, zvose zvakabikwa zvisina mbiriso. ");
INSERT INTO sna_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ipapo muprista achazvininira pamberi paJehovha sechipiriso chokuninira; izvi zvitsvene uye ndezvomuprista, pamwe chete nechipfuva chakaninirwa uye chidya chakakumikidzwa. Shure kwaizvozvo, muNaziri anganwa hake waini. ");
INSERT INTO sna_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Uyu ndiwo murayiro womuNaziri anenge apikira chipiriso kuna Jehovha maererano nokuzvitsaura kwake pamusoro pezvimwe zvose zvaanenge achigona kupa. Anofanira kuzadzisa mhiko yaakaita, zviri maererano nomurayiro womuNaziri.’ ” ");
INSERT INTO sna_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Udza Aroni navanakomana vake uti, ‘Munofanira kuropafadza vaIsraeri nomutoo uyu. Muti kwavari: ");
INSERT INTO sna_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Jehovha akuropafadzei uye akuchengetei; ");
INSERT INTO sna_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Jehovha ngaapenyese chiso chake pamusoro penyu uye akunzwirei tsitsi; ");
INSERT INTO sna_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jehovha ngaarinzire chiso chake kwamuri uye akupei rugare.’ ” ");
INSERT INTO sna_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Saka vachaisa zita rangu pamusoro pavaIsraeri, uye ndichavaropafadza.” ");
INSERT INTO sna_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mozisi akati apedza kumisa tabhenakeri, akaizodza akaitsaura pamwe chete nemidziyo yayo yose. Akazodzawo nokutsaura aritari nemidziyo yayo yose. ");
INSERT INTO sna_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ipapo vatungamiri veIsraeri, vakuru vedzimba avo vakanga vari vatungamiri vamarudzi vari vatariri vavaya vakanga vaverengwa, vakapa zvipiriso. ");
INSERT INTO sna_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Vakauyisa sezvipiriso zvavo pamberi paJehovha, ngoro nhanhatu dzakafukidzirwa nenzombe gumi nembiri, nzombe kubva kumutungamiri mumwe nomumwe uye ngoro kubva kuvaviri vaviri. Izvi zvakaiswa pamberi petabhenakeri. ");
INSERT INTO sna_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Gamuchira izvi kubva kwavari kuti zvigoshandiswa mubasa paTende Rokusangana. Uzvipe kuvaRevhi maererano nebasa romunhu mumwe nomumwe.” ");
INSERT INTO sna_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Saka Mozisi akatora ngoro nenzombe akazvipa kuvaRevhi. ");
INSERT INTO sna_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Akapa kuvaGerishoni ngoro mbiri nenzombe ina, maererano nezvaidiwa pabasa ravo, ");
INSERT INTO sna_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","uye akapa ngoro ina nenzombe tsere kuvaMerari, maererano nezvaidiwa pabasa ravo. Vose vakanga vachirayirwa naItamari mwanakomana waAroni, muprista. ");
INSERT INTO sna_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Asi Mozisi haana kupa chinhu kuvanakomana vaKohati, nokuti vaifanira kutakura zvinhu zvitsvene pamapfudzi avo, iri ndiro raiva basa ravo. ");
INSERT INTO sna_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Aritari yakati yazodzwa, vatungamiri vakauya nezvipiriso zvavo zvokukumikidzwa kwayo vakazviisa pamberi pearitari. ");
INSERT INTO sna_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nokuti Jehovha akanga ati kuna Mozisi, “Zuva rimwe nerimwe, mutungamiri mumwe chete anofanira kuuya nechipiriso chake chokukumikidza aritari.” ");
INSERT INTO sna_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Nashoni mwanakomana waAminadhabhi worudzi rwaJudha, ndiye akauya nechipiriso chake pazuva rokutanga. ");
INSERT INTO sna_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, uye mbiya imwe chete yokusasa yesirivha yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, rimwe nerimwe rizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","hando duku imwe chete, gondobwe rimwe chete negwayana rimwe chete romukono wegore rimwe chete, zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nhongo imwe chete yembudzi yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chaiva chipiriso chaNashoni mwanakomana waAminadhabhi. ");
INSERT INTO sna_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Pazuva rechipiri, Netaneri mwanakomana waZuari, mutungamiri waIsakari, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Chipiriso chaakauya nacho chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, uye mbiya imwe chete yokusasa yesirivha yairema makumi manomwe amashekeri, zvose zviri zviviri zvaiva zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo, maererano neshekeri renzvimbo tsvene; ");
INSERT INTO sna_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","hando duku imwe chete, gondobwe rimwe chete nomukono wegwayana regore rimwe chete, zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nhongo imwe chete yembudzi yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chaiva chipiriso chaNetaneri mwanakomana waZuari. ");
INSERT INTO sna_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Pazuva rechitatu, Eriabhi mwanakomana waHeroni, mutungamiri wavanhu vokwaZebhuruni, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, uye mbiya imwe chete yokusasa yesirivha yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","hando duku imwe chete, gondobwe rimwe chete nomukono wegwayana regore rimwe chete zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nhongo imwe chete yembudzi yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chaiva chipiriso chaEriabhi mwanakomana waHeroni. ");
INSERT INTO sna_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Pazuva rechina, Erizuri mwanakomana waShedheuri, mutungamiri wavanhu vokwaRubheni, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, nembiya imwe chete yokusasa yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","hando duku imwe chete, gondobwe rimwe chete nomukono mumwe chete wegwayana regore rimwe chete zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chaiva chipiriso chaErizuri mwanakomana waShedheuri. ");
INSERT INTO sna_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Pazuva rechishanu, Sherumieri mwanakomana waZurishadhai, mutungamiri wavanhu vokwaSimeoni akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Chipiriso chake chakanga chiri chendiro yesirivha yakanga ichirema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","hando duku imwe chete, gondobwe rimwe chete uye mukono wegwayana mumwe chete wegore rimwe chete zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nhongo imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chaiva chipiriso chaSherumieri mwanakomana waZurishadhai. ");
INSERT INTO sna_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Pazuva rechitanhatu, Eriasafi mwanakomana waDheueri, mutungamiri wavanhu vokwaGadhi, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Chipiriso chake chakanga chiri ndiro yesirivha yairema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","hando duku imwe chete, gondobwe rimwe chete uye mukono mumwe chete wegwayana regore rimwe chete, zvechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nhongo imwe chete yembudzi yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","nenzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaEriasafi mwanakomana waDheueri. ");
INSERT INTO sna_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Pazuva rechinomwe, Erishama mwanakomana waAmihudhi, mutungamiri wavanhu vokwaEfuremu, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, uye mbiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo, ");
INSERT INTO sna_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","hando duku imwe chete, gondobwe rimwe chete uye mukono wegwayana wegore rimwe chete, kuti zvive chipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaErishama mwanakomana waAmihudhi. ");
INSERT INTO sna_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pazuva rorusere Gamarieri mwanakomana waPedhazuri, mutungamiri wavanhu vokwaManase akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","hando duku imwe chete, gondobwe rimwe chete uye mukono mumwe chete wegwayana regore rimwe chete, sechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","uye nzombe mbiri, makondobwe mashanu, nhongo shanu uye makwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaGamarieri mwanakomana waPedhazuri. ");
INSERT INTO sna_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Pazuva repfumbamwe, Abhidhani mwanakomana waGidheoni mutungamiri wavanhu vokwaBhenjamini, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, uye nembiya yesirivha yokusasa yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo. ");
INSERT INTO sna_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Ndiro yegoridhe imwe chete yairema mashekeri gumi, izere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","hando duku imwe chete, gondobwe rimwe chete uye mukono mumwe chete wegwayana regore rimwe chete, sechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","uye nzombe mbiri makondobwe mashanu, nhongo dzembudzi shanu namakwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaAbhidhani mwanakomana waGidheoni. ");
INSERT INTO sna_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Pazuva regumi, Ahiezeri mwanakomana waAmishadhai, mutungamiri wavanhu vokwaDhani, akauya nechipiriso. ");
INSERT INTO sna_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Chipiriso chake chakanga chiri chendiro yesirivha yairema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe, zvose zviri maererano neshekeri renzvimbo tsvene, zvose zviri zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","dhishi rimwe chete regoridhe rairema mashekeri gumi rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","hando duku imwe chete, gondobwe rimwe chete nomukono mumwe chete wegwayana wegore rimwe chete, sechipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi namakwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaAhiezeri mwanakomana waAmishadhai. ");
INSERT INTO sna_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pazuva regumi nerimwe, Pagieri mwanakomana waOkirani, mutungamiri wavanhu vokwaAsheri, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Chipiriso chake chakanga chiri chendiro imwe chete yesirivha yairema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe, zvose zviri zviviri maererano neshekeri renzvimbo tsvene, zvose zviviri zvakanga zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","hando duku imwe chete, gondobwe rimwe chete nomukono wegwayana wegore rimwe chete, kuti zvive chipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi namakwayana makono mashanu egore rimwe chete, kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaPagieri mwanakomana waOkirani. ");
INSERT INTO sna_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Pazuva regumi namaviri, Ahira mwanakomana waEnani, mutungamiri wavanhu vokwaNafutari, akauya nechipiriso chake. ");
INSERT INTO sna_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Chipiriso chake chakanga chiri chendiro imwe chete yesirivha yairema mashekeri zana namakumi matatu, nembiya yesirivha yokusasa imwe chete yairema mashekeri makumi manomwe zvose zviri zviviri zvizere noupfu hwakatsetseka hwakavhenganiswa namafuta sechipiriso chezviyo; ");
INSERT INTO sna_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","dhishi rimwe chete regoridhe rairema mashekeri gumi, rizere nezvinonhuhwira; ");
INSERT INTO sna_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","hando duku imwe chete, gondobwe rimwe chete uye nomukono wegwayana wegore rimwe chete, kuti zvive chipiriso chinopiswa; ");
INSERT INTO sna_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nhongo yembudzi imwe chete yechipiriso chechivi; ");
INSERT INTO sna_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","uye nzombe mbiri, makondobwe mashanu, nhongo shanu dzembudzi namakwayana makono mashanu egore rimwe chete kuti zvizobayirwa sechipiriso chokuwadzana. Ichi ndicho chakanga chiri chipiriso chaAhira mwanakomana waEnani. ");
INSERT INTO sna_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Izvi ndizvo zvakanga zviri zvipiriso zvavatungamiri veIsraeri pakukumikidzwa kwearitari payakazodzwa; ndiro dzesirivha gumi nembiri, mbiya dzesirivha dzokusasa gumi nembiri namadhishi egoridhe gumi namaviri. ");
INSERT INTO sna_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ndiro imwe neimwe yesirivha yairema mashekeri zana namakumi matatu uye mbiya imwe neimwe yokusasa yairema mashekeri makumi manomwe. Pamwe chete madhishi esirivha airema zviuru zviviri namazana mana amashekeri, maererano neshekeri renzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Madhishi egoridhe gumi namaviri akanga azere nezvinonhuhwira airema mashekeri zana namakumi maviri. ");
INSERT INTO sna_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Uwandu hwezvipfuwo zvechipiriso chinopiswa pamwe chete hwaiti hando duku gumi nembiri, makondobwe gumi namaviri namakondobwe maduku egore rimwe chete gumi namaviri, pamwe chete nechipiriso chadzo chezviyo. Nhongo dzembudzi gumi nembiri dzakashandiswa pachipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Uwandu hwezvipfuwo zvechibayiro chokuwadzana pamwe chete hwaiti nzombe makumi maviri neina, makondobwe makumi matanhatu, nhongo dzembudzi makumi matanhatu namakondobwe maduku egore rimwe chete makumi matanhatu. Izvi ndizvo zvakanga zviri zvipiriso zvokukumikidzwa kwearitari shure kwokuzodzwa kwayo. ");
INSERT INTO sna_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mozisi akati apinda muTende Rokusangana kundotaura naJehovha, akanzwa inzwi richitaura naye richibva napakati pamakerubhi maviri pamusoro pechifukidzo cheareka yeChipupuriro. Uye akataura naye. ");
INSERT INTO sna_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Taura naAroni uti kwaari, ‘Kana uchimisa mwenje minonwe, inofanira kuvhenekera nzvimbo iri mberi kwechigadziko chomwenje.’ ” ");
INSERT INTO sna_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aroni akaita saizvozvo; akamisa mwenje yakatarisa mberi kuchigadziko chomwenje, sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Aya ndiwo magadzirirwo akanga akaitwa chigadziko chomwenje: Chakanga chakaitwa negoridhe rakapambadzirwa kubva pahwaro hwacho kusvikira pamaruva acho. Chigadziko chomwenje chakanga chakagadzirwa zvakanyatsofanana nomufananidzo wakanga waratidzwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Jehovha akati kuna Mozisi: ");
INSERT INTO sna_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Bvisa vaRevhi pakati pavamwe vaIsraeri ugovanatsa. ");
INSERT INTO sna_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Pakuvanatsa, unofanira kuita izvi: Sasa pamusoro pavo mvura yokuvachenesa; ipapo ugoita kuti vaveure miviri yavo yose vagosuka nguo dzavo, kuitira kuti vazvinatse. ");
INSERT INTO sna_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Uite kuti vatore hando duku nechipiriso chayo chezviyo choupfu hwakatsetseka hwakavhenganiswa namafuta, ipapo munofanira kutorazve imwe hando duku yechipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Uuye navaRevhi mberi kweTende Rokusangana ugounganidza ungano yose yavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Unofanira kuuya navaRevhi pamberi paJehovha, uye vaIsraeri vanofanira kuisa maoko avo pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aroni anofanira kuisa vaRevhi pamberi paJehovha sechipiriso chokuninira chinobva kuvaIsraeri, kuitira kuti vagadzirire kuita basa raJehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Mushure mokunge vaRevhi vaisa maoko avo pamisoro yehando, ushandise imwe yacho sechipiriso chechivi kuna Jehovha uye imwe yacho sechipiriso chinopiswa, kuti uyananisire vaRevhi. ");
INSERT INTO sna_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Uite kuti vaRevhi vamire pamberi paAroni navanakomana vake ipapo ugovakumikidza sechipiriso chokuninira kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Nenzira iyi unofanira kutsaura vaRevhi pakati pavamwe vaIsraeri, uye vaRevhi vachava vangu. ");
INSERT INTO sna_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Mushure mokunge wanatsa vaRevhi nokuvakumikidza sechipiriso chokuninira, vanofanira kuuya kuzoita basa ravo paTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ivo ndivo vaIsraeri vachapiwa zvachose kwandiri. Ndakavatora kuti vave vangu pachinzvimbo chamatangwe, vanakomana vokutanga vomukadzi mumwe nomumwe womuIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Chibereko chose chokutanga chechikono muIsraeri, angava munhu kana chipfuwo, ndechangu. Pandakauraya matangwe ose muIjipiti, ndakazvitsaurira ivo kwandiri. ");
INSERT INTO sna_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Uye ndakatora vaRevhi panzvimbo yavanakomana veIsraeri vamatangwe. ");
INSERT INTO sna_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","PavaIsraeri vose, ndakapa vaRevhi sezvipo kuna Aroni navanakomana vake kuti vaite basa paTende Rokusangana vakamirira vaIsraeri uye kuti vayananisire vaIsraeri kuti varege kuurayiwa nedenda pavanenge vaswedera kunzvimbo tsvene.” ");
INSERT INTO sna_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mozisi, Aroni neungano yose yeIsraeri vakaitira vaRevhi sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","VaRevhi vakazvinatsa vakasuka nguo dzavo. Ipapo Aroni akavaisa pamberi paJehovha sechipiriso chokuninira akavayananisira kuti vanatswe. ");
INSERT INTO sna_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Shure kwaizvozvo, vaRevhi vakauya kuzoshanda basa ravo paTende Rokusangana vachitungamirirwa naAroni navanakomana vake. Vakaitira vaRevhi sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Izvi ndizvo zvichaitwa navaRevhi: Vamwe vana makore makumi maviri namashanu kana anopfuura vachauya kuzoshanda basa paTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","asi kana vasvika makore makumi mashanu, vanofanira kuregedza basa ravo uye varege kuzoshandazve. ");
INSERT INTO sna_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Vangabatsira havo hama dzavo kuita mabasa apaTende Rokusangana, asi ivo pachavo havafaniri kushanda basa. Zvino, izvi ndizvo zvaunofanira kurayira vaRevhi kuti vaite.” ");
INSERT INTO sna_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Jehovha akataura kuna Mozisi murenje reSinai mumwedzi wokutanga wegore rechipiri shure kwokubuda kwavo muIjipiti. Akati kwaari, ");
INSERT INTO sna_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ita kuti vaIsraeri vapemberere Pasika panguva yakatarwa. ");
INSERT INTO sna_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Muipemberere panguva yakatarwa, panguva yorubvunzavaeni pazuva regumi namana romwedzi, maererano nemitemo yayo nemirayiro yayo yose.” ");
INSERT INTO sna_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Saka Mozisi akataurira vaIsraeri kuti vapemberere Pasika, ");
INSERT INTO sna_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ivo vakaita saizvozvo murenje reSinai panguva yorubvunzavaeni nezuva regumi namana romwedzi wokutanga. VaIsraeri vakaita zvose sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Asi vamwe vavo havana kupemberera Pasika nomusi iwoyo nokuti vakanga vasina kuchena nokuda kwechitunha. Saka vakauya kuna Mozisi naAroni musi iwoyo uye, ");
INSERT INTO sna_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","vakati kuna Mozisi, “Isu tava vasina kuchena nokuda kwechitunha, asi tinodzivisirweiko kuvigira Jehovha chipiriso pamwe chete navamwe vaIsraeri panguva yakatarwa?” ");
INSERT INTO sna_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mozisi akavapindura akati, “Mirai kusvikira ndanzwa zvinorayirwa naJehovha pamusoro penyu.” ");
INSERT INTO sna_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Taurira vaIsraeri kuti: ‘Mumwe wenyu kana zvizvarwa zvenyu kana vasvibiswa nokuda kwechitunha uye kana kuti vari parwendo, naivowo vangapemberera Pasika yaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Vanofanira kuipemberera nezuva regumi namana romwedzi wechipiri panguva dzorubvunzavaeni. Vanofanira kudya gwayana, pamwe chete nechingwa chisina mbiriso nomuriwo unovava. ");
INSERT INTO sna_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Havafaniri kusiya chinhu kusvikira mangwanani kana kuvhuna mapfupa aro. Pavanopemberera Pasika, vanofanira kutevedza mitemo yose. ");
INSERT INTO sna_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Asi kana munhu akachena uye asiri parwendo akakundikana kupemberera Pasika, munhu uyo anofanira kubviswa pakati pavanhu vokwake nokuti haana kuvigira Jehovha chipiriso panguva yakatarwa. Munhu uyo achatakura zvivi zvake. ");
INSERT INTO sna_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Mutorwa agere pakati penyu anoda kupemberera Pasika yaJehovha anofanira kuita izvozvo maererano nemitemo nemirayiro yayo. Munofanira kuva nomutemo mumwe chete kumutorwa nokuna akaberekerwa munyika.’ ” ");
INSERT INTO sna_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Pazuva rakamiswa tabhenakeri, iyo Tende yeChipupuriro, gore rakaifukidza. Kubva panguva dzamadekwana kusvikira mangwanani, gore rakanga riri pamusoro petabhenakeri rakanga rakaita somoto. ");
INSERT INTO sna_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ndizvo zvarakaramba rakaita; gore rakaifukidza, uye usiku rairatidzika somoto. ");
INSERT INTO sna_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Gore raiti kana rasimudzwa kubva pamusoro peTende, vaIsraeri vaifamba; pose paimira gore, vaIsraeri vaidzika musasa ipapo. ");
INSERT INTO sna_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Pakurayira kwaJehovha, vaIsraeri vaifamba, uye pakurayira kwake, vaibva vadzika musasa. ");
INSERT INTO sna_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Gore paraimira pamusoro petabhenakeri, ivo vairamba vakadzika musasa. ");
INSERT INTO sna_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Dzimwe nguva gore raigara pamusoro petabhenakeri kwamazuva mashomanana chete; vaidzika musasa wavo sokurayira kwaJehovha uye pakurayira kwake, vaibva vafamba. ");
INSERT INTO sna_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Dzimwe nguva gore raingogara kubva panguva dzamadekwana kusvikira mangwanani, uye paraingosimuka mangwanani vaibva vafamba. Paingosimuka gore, angava masikati kana usiku, vaibva vafamba. ");
INSERT INTO sna_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kana gore rikagara pamusoro petabhenakeri kwamazuva maviri kana mwedzi, kana gore rimwe chete, vaIsraeri vairamba vari mumusasa uye vasingafambi; asi kana rikasimuka ivo vaibva vafamba. ");
INSERT INTO sna_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Sokurayira kwaJehovha, vaidzika musasa, uye sokurayira kwaJehovha, vaifamba. Vakateerera kurayira kwaJehovha, maererano nokurayira kwake kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ita hwamanda mbiri dzesirivha yakapambadzirwa, ugodzishandisa kudana ungano pamwe chete uye kuti mapoka afambe. ");
INSERT INTO sna_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Dzikaridzwa dzose dziri mbiri, ungano yose inofanira kuungana pamberi pako pamukova weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kana imwe chete ikaridzwa, vatungamiri, vakuru vedzimba dzaIsraeri, vanofanira kuungana pamberi pako. ");
INSERT INTO sna_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Hwamanda yeyambiro painoridzwa marudzi akavaka kumabvazuva anofanira kutanga kufamba. ");
INSERT INTO sna_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Paunoridza hwamanda yechipiri, misasa yezasi inofanira kufamba. Kurira kwehwamanda kuchava chiratidzo chokuti mufambe. ");
INSERT INTO sna_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kuti ungano iungane, muridze hwamanda, asi kwete namaridziro mamwe chetewo. ");
INSERT INTO sna_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Vanakomana vaAroni, vaprista ndivo vanofanira kuridza hwamanda. Uyu unofanira kuva mitemo usingaperi kwamuri nokuzvizvarwa zvinotevera. ");
INSERT INTO sna_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kana muchindorwa munyika yenyu nomuvengi anokumanikidzai, muridze hwamanda. Ipapo mucharangarirwa naJehovha Mwari wenyu uye muchanunurwa kubva kuvavengi venyu. ");
INSERT INTO sna_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Uyezve, panguva dzenyu dzokufara, pamitambo yenyu yakatarwa uye nemitambo yoKugara kwoMwedzi, munofanira kuridza hwamanda pamusoro pezvipiriso zvenyu zvinopiswa nezvipiriso zvokuwadzana, uye zvichava chirangaridzo kwamuri pamberi paMwari wenyu. Ndini Jehovha Mwari wenyu.” ");
INSERT INTO sna_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Pazuva ramakumi maviri romwedzi wechipiri, wegore rechipiri, gore rakasimuka kubva pamusoro petabhenakeri yeChipupuriro. ");
INSERT INTO sna_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ipapo vaIsraeri vakasimuka kubva murenje reSinai, vakafamba vachienda kunzvimbo nenzvimbo kusvikira gore randomira murenje reParani. ");
INSERT INTO sna_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nguva ino, kwokutanga, vakafamba sezvavakanga varayirwa naJehovha kubudikidza naMozisi. ");
INSERT INTO sna_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Mapoka omusasa waJudha ndiwo akatanga kuenda, pasi pomureza wavo. Nashoni mwanakomana waAminadhabhi akanga achivatungamirira. ");
INSERT INTO sna_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneri mwanakomana waZuari akanga ari mukuru weboka rorudzi rwaIsakari. ");
INSERT INTO sna_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Uye Eriabhi mwanakomana waHeroni akanga ari mukuru weboka rorudzi rwaZebhuruni. ");
INSERT INTO sna_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ipapo tabhenakeri yakabviswa, uye vaGerishoni navaMerari, vakanga vachiitakura, vakatanga kufamba. ");
INSERT INTO sna_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mapoka omusasa waRubheni akatevera, vari pasi pomureza wavo. Erizuri mwanakomana waShedheuri ndiye akanga achivatungamirira. ");
INSERT INTO sna_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sherumieri mwanakomana waZurishadhai akanga ari mukuru weboka rorudzi rwaSimeoni, ");
INSERT INTO sna_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","uye Eriasafi mwanakomana waDheueri akanga ari mukuru weboka rorudzi rwaGadhi. ");
INSERT INTO sna_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ipapo vaKohati vakasimuka, vakatakura zvinhu zvitsvene. Tabhenakeri yaifanira kumiswa vasati vasvika. ");
INSERT INTO sna_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mapoka omusasa waEfuremu akatevera; vari pasi pomureza wavo. Erishama mwanakomana waAmihudhi akanga achivatungamirira. ");
INSERT INTO sna_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamarieri mwanakomana waPedhazuri akanga ari mukuru weboka rorudzi rwaManase. ");
INSERT INTO sna_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Uye Abhidhani mwanakomana waGidheoni akanga ari mukuru weboka rorudzi rwaBhenjamini. ");
INSERT INTO sna_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Pakupedzisira, samapoka aichengetedza kumashure kwamapoka ose, mapoka omusasa waDhani akasimuka, ari pasi pomureza wavo. Ahiezeri mwanakomana waAmishadhai ndiye akanga achivatungamirira. ");
INSERT INTO sna_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieri mwanakomana waOkirani akanga ari mukuru weboka rorudzi rwaAsheri; ");
INSERT INTO sna_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","uye Ahira mwanakomana waEnani akanga ari mukuru weboka rorudzi rwaNafutari. ");
INSERT INTO sna_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Aya ndiwo akanga ari mafambiro amapoka avaIsraeri pakusimuka kwavo. ");
INSERT INTO sna_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Zvino Mozisi akati kuna Hobhabhi mwanakomana waReueri muMidhiani, tezvara waMozisi, “Tava kuenda kunzvimbo yatakanzi naJehovha, ‘Ndichakupai imi.’ Handei tose tigokuitirai zvakanaka, nokuti Jehovha avimbisa zvinhu zvakanaka kuna Israeri.” ");
INSERT INTO sna_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Iye akapindura akati, “Kwete, handingaendi; ndiri kudzokera kunyika yangu nokuvanhu vokwangu.” ");
INSERT INTO sna_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Asi Mozisi akati kwaari, “Ndapota hangu regai kutisiya. Munoziva patinofanira kuvaka musasa wedu murenje, uye imi mungava meso edu. ");
INSERT INTO sna_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kana mukaenda nesu, tichagovana nemi chinhu chipi nechipi chatichapiwa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Saka vakasimuka kubva pagomo raJehovha vakafamba kwamazuva matatu. Areka yaJehovha yesungano yakavatungamirira pamazuva matatu iwayo kuti vatsvakirwe nzvimbo yokuzororera. ");
INSERT INTO sna_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Gore raJehovha rakanga riri pamusoro pavo masikati pavakasimuka kubva pamusasa. ");
INSERT INTO sna_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Paingosimuka areka, Mozisi aiti, “Haiwa Jehovha, simukai! Vavengi venyu ngavaparadzirwe, vavengi venyu ngavatize pamberi penyu.” ");
INSERT INTO sna_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Payaigadzikwa pasi, iye aiti, “Haiwa Jehovha, dzokai kuzviuru nezviuru zvavaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Zvino vanhu vakanyunyuta, Jehovha achizvinzwa, pamusoro pokuomerwa kwavo, uye paakavanzwa hasha dzake dzakamutswa. Ipapo moto wakabva kuna Jehovha ukapisa pakati pavo uye ukaparadza vamwe kumucheto womusasa. ");
INSERT INTO sna_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Vanhu vakati vachema kuna Mozisi, akanyengetera kuna Jehovha moto ukadzima. ");
INSERT INTO sna_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Saka nzvimbo iyo yakanzi Tabhera, nokuti moto wakabva kuna Jehovha ukapisa pakati pavo. ");
INSERT INTO sna_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Vatorwa vakanga vari pakati pavo vakatanga kupanga zvimwewo zvokudya, uyezve vaIsraeri vakatanga kuungudza vachiti, “Ndianiko achatipa nyama kuti tidye? ");
INSERT INTO sna_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tinorangarira hove dzataidya muIjipiti tisingatengi; magaka, manwiwa, hanyanisi huru, hanyanisi diki nemhiripiri. ");
INSERT INTO sna_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Asi zvino tafinhwa; hapana chimwe chinhu chatiri kuwana kunze kwemana iyi.” ");
INSERT INTO sna_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana yakanga yakaita semhodzi yekorianda uye ichiratidzika samazambiringa akaoma. Vanhu vaitenderera vachiinhonga, uye, vaizoikuya paguyo kana kuidzvura muduri. ");
INSERT INTO sna_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Vaiibika muhari kana kuita makeke. Uye yainaka kunge chinhu chakabikwa namafuta omuorivhi. ");
INSERT INTO sna_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Dova raiti rawira pamusoro pomusasa usiku, mana yaiwawo. ");
INSERT INTO sna_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mozisi akanzwa vanhu vemhuri dzose vachiungudza, mumwe nomumwe pamukova wetende rake. Jehovha akatsamwa kwazvo, uye Mozisi akatambudzika. ");
INSERT INTO sna_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Akabvunza Jehovha akati, “Seiko makauyisa dambudziko iri pamuranda wenyu? Chiiko chandakaita chisingakufadzei zvokuti makaisa mutoro wavanhu ava vose pamusoro pangu? ");
INSERT INTO sna_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ko, ndini ndakaita kuti vanhu vose ava vaumbwe here? Ko, ndini ndakavabereka here? Seiko muchindiita kuti ndivatakure mumaoko angu, somureri anotakura mwana mucheche kuti ndiende navo kunyika yamakavimbisa nemhiko kumadzitateguru avo? ");
INSERT INTO sna_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ndingawanepiko nyama yandingapa vanhu vose ava? Vanoramba vachingondichemera vachiti, ‘Tipe nyama yokudya.’ ");
INSERT INTO sna_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Handingatakuri vanhu ava vose ndoga; mutoro unondiremera kwazvo. ");
INSERT INTO sna_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kana muchida kundiitira saizvozvo, ndiurayei henyu iye zvino, kana ndawana hangu nyasha pamberi penyu, uye musandirega ndichiona kuparara kwangu.” ");
INSERT INTO sna_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Jehovha akati kuna Mozisi, uya navakuru vavaIsraeri makumi manomwe vaunoziva savatungamiri namachinda pakati pavanhu. Uite kuti vauye kuTende Rokusangana, kuti vamire newe ipapo. ");
INSERT INTO sna_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ini ndichaburuka ndigozotaura newe ipapo, uye ndichatora Mweya uri pamusoro pako ndigoisa Mweya iwoyo pamusoro pavo. Ivo vachakubatsira kutakura mutoro wavanhu kuitira kuti iwe urege kuutakura woga. ");
INSERT INTO sna_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Udza vanhu kuti: ‘Zvinatsei mugadzirire zvamangwana, pamuchadya nyama. Jehovha akakunzwai pamakaungudza muchiti, “Dai bedzi taiva nenyama yokudya! Takanga tiri nani muIjipiti!” Zvino Jehovha achakupai nyama, uye muchaidya. ");
INSERT INTO sna_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hamungaidyi kwezuva rimwe chete, kana mazuva maviri kana mashanu, gumi kana makumi maviri, ");
INSERT INTO sna_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","asi kwomwedzi wose, kusvikira yabuda nomumhino dzenyu uye mukaisema, nokuti makaramba Jehovha, ari pakati penyu, uye maichema pamberi pake muchiti, “Takambobvireiko kuIjipiti?” ’ ” ");
INSERT INTO sna_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Asi Mozisi akati, “Hezvi ndiri pakati pavanhu mazana matanhatu ezviuru vanofamba netsoka, zvino imi munoti, ‘Ini ndichavapa nyama kuti vadye kwomwedzi wose!’ ");
INSERT INTO sna_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Zvichavaringana here kana dai vakaurayirwa makwai nemombe? Zvichavaringana here kana dai vakabatirwa hove dzose dziri mugungwa?” ");
INSERT INTO sna_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jehovha akapindura Mozisi achiti, “Ko, ruoko rwaJehovha rwakapfupiswa here? Zvino uchaona kuti zvandinoreva zvichaitika here kana kuti kwete.” ");
INSERT INTO sna_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Saka Mozisi akabuda akandoudza vanhu zvakanga zvataurwa naJehovha. Akaunganidza vakuru vavo makumi manomwe akavaita kuti vamire vakapoteredza Tende. ");
INSERT INTO sna_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ipapo Jehovha akaburuka ari mugore akataura navo uye akatora Mweya wakanga uri pamusoro pake akaisa Mweya uyu pamusoro pavakuru makumi manomwe. Mweya wakati wagara pamusoro pavo vakaprofita, asi havana kuzopamhazve. ");
INSERT INTO sna_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Kunyange zvakadaro, varume vaviri, vainzi Eridhadhi naMedhadhi, vakanga vasara mumusasa. Ivo vakanga vaverengwa pakati pavakuru, asi havana kubuda kuti vaende kuTende. Asi Mweya wakagarawo pamusoro pavo uye, vakaprofita vari mumusasa. ");
INSERT INTO sna_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mumwe mujaya akamhanya akandoudza Mozisi akati, “Eridhadhi naMedhadhi vari kuprofita vari mumusasa.” ");
INSERT INTO sna_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua mwanakomana waNuni, uyo akanga ari mubatsiri waMozisi kubva paujaya hwake, akataura nesimba akati, “Mozisi, ishe wangu, vadzivisei!” ");
INSERT INTO sna_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Asi Mozisi akapindura akati, “Ko, iwe une godo nokuda kwangu here? Ndinoshuva kuti dai vanhu vaJehovha vose vava vaprofita uye kuti dai Jehovha aisa Mweya wake pamusoro pavo!” ");
INSERT INTO sna_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ipapo Mozisi navakuru vavaIsraeri vakadzokera kumusasa. ");
INSERT INTO sna_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Zvino mhepo yakabuda ichibva kuna Jehovha ikasunda zvihuta zvichibva kugungwa. Yakazvikanda pasi kumativi ose omusasa zvikaita murwi ungada kuita makubhiti maviri kubva pasi, kusvika pangafambwa rwendo rwezuva rimwe chete kumativi ose. ");
INSERT INTO sna_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Zuva rose iroro nousiku hwose uye nezuva rose rakatevera vanhu vakabuda kundounganidza zvihuta. Hakuna akaunganidza zvaiva pasi pamahomeri gumi. Ipapo vakazviyanika vakapoteredza musasa. ");
INSERT INTO sna_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Asi nyama ichiri pakati pamazino avo uye isati yatsengwa, kutsamwa kwaJehovha kwakapfuta pamusoro pavanhu, akavarova nehosha yakaipisisa. ");
INSERT INTO sna_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Naizvozvo nzvimbo iyo yakatumidzwa kunzi Kibhuroti Hataavha, nokuti vakaviga vanhu vakanga vakarira zvimwewo zvokudya. ");
INSERT INTO sna_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Vanhu vakabva paKibhuroti Hataavha vakaenda kuHazeroti vakandogara ikoko. ");
INSERT INTO sna_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu naAroni vakatanga kupopotera Mozisi nokuda kwomukadzi wake aiva muEtiopia, nokuti akanga awana muEtiopia. ");
INSERT INTO sna_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Ko, Jehovha akangotaura naMozisi oga here? Ko, haana kutaura kubudikidza nesuwo here?” Uye Jehovha akazvinzwa. ");
INSERT INTO sna_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Zvino Mozisi akanga ari munhu akazvininipisa kwazvo, akazvininipisa kupfuura ani zvake pamusoro penyika. ");
INSERT INTO sna_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Pakarepo Jehovha akati kuna Mozisi, Aroni naMiriamu, “Budai muuye kuTende Rokusangana, mose muri vatatu.” Saka vakabuda ivo vari vatatu. ");
INSERT INTO sna_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ipapo Jehovha akaburuka ari mushongwe yegore; akamira pamukova wokupinda kuTende akadana Aroni naMiriamu. Vakati vachibuda vari vaviri, ");
INSERT INTO sna_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","akati kwavari, “Teererai mashoko angu: “Kana pano muprofita pakati penyu, ndinozviratidza kwaari nezviratidzo, ndinotaura naye muzviratidzo, ndinotaura naye muzviroto. ");
INSERT INTO sna_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Asi hazvina kudaro kuna Mozisi muranda wangu; iye akatendeka muimba yangu yose. ");
INSERT INTO sna_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ndinotaura naye takatarisana, pachena kwete nezvirahwe; iye anoona chimiro chaJehovha. Zvino makarega seiko kutya kutaura muchipopotera muranda wangu Mozisi?” ");
INSERT INTO sna_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Kutsamwa kwaJehovha kwakapfuta pamusoro pavo, uye akavasiya. ");
INSERT INTO sna_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Gore rakati rabva pamusoro peTende, onei Miriamu amirepo ava namaperembudzi, akachena sechando. Aroni akatendeukira kwaari akaona kuti akanga ava namaperembudzi. ");
INSERT INTO sna_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ipapo akati kuna Mozisi, “Ndapota, ishe wangu, regai kuisa pamusoro pedu chivi chataita noupenzi. ");
INSERT INTO sna_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Musarega achifanana nomwana akazvarwa akafa mudumbu ramai vake hafu yenyama yake yakadyiwa.” ");
INSERT INTO sna_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Saka Mozisi akachema kuna Jehovha akati, “Haiwa Mwari, ndapota hangu muporesei!” ");
INSERT INTO sna_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Jehovha akapindura Mozisi achiti, “Dai baba vake vanga vamupfira kumeso kwake, haazainyara kwamazuva manomwe here? Mubudise kunze kwomusasa kwamazuva manomwe; mugomudzosa henyu pashure.” ");
INSERT INTO sna_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Saka Miriamu akabudiswa kunze kwomusasa kwamazuva manomwe, uye vanhu havana kupfuurira mberi kusvikira adzoswa. ");
INSERT INTO sna_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Shure kwaizvozvo, vanhu vakabva paHazeroti vakandodzika musasa muRenje reParani. ");
INSERT INTO sna_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Tuma vamwe varume kuti vandosora nyika yeKenani, yandiri kupa kuvaIsraeri. Tuma mutungamiri mumwe kubva kurudzi rumwe norumwe rwamadzitateguru avo.” ");
INSERT INTO sna_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Saka, sokurayira kwaJehovha, Mozisi akavatuma vachibva nokurenje reParani. Vose vakanga vari vatungamiri vavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Haano mazita avo: kubva kurudzi rwaRubheni, Shamua mwanakomana waZakuri; ");
INSERT INTO sna_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","kubva kurudzi rwaSimeoni, Shafati mwanakomana waHori; ");
INSERT INTO sna_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","kubva kurudzi rwaJudha, Karebhu mwanakomana waJefune; ");
INSERT INTO sna_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","kubva kurudzi rwaIsakari, Igari mwanakomana waJosefa; ");
INSERT INTO sna_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","kubva kurudzi rwaEfuremu, Hoshea mwanakomana waNuni; ");
INSERT INTO sna_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","kubva kurudzi rwaBhenjamini, Pareti mwanakomana waRafu; ");
INSERT INTO sna_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","kubva kurudzi rwaZebhuruni, Gadhieri mwanakomana waSodhi; ");
INSERT INTO sna_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","kubva kurudzi rwaManase (rudzi rwaJosefa), Gadhi mwanakomana waSusi; ");
INSERT INTO sna_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","kubva kurudzi rwaDhani, Amieri mwanakomana waGemari; ");
INSERT INTO sna_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","kubva kurudzi rwaAsheri, Seturi mwanakomana waMikaeri; ");
INSERT INTO sna_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","kubva kurudzi rwaNafutari, Nabhi mwanakomana waVhofisi; ");
INSERT INTO sna_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kubva kurudzi rwaGadhi, Generi mwanakomana waMaki. ");
INSERT INTO sna_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aya ndiwo mazita avarume vakatumwa naMozisi kundosora nyika. (Mozisi akatumidza Hoshea mwanakomana waNuni zita rokuti Joshua). ");
INSERT INTO sna_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mozisi akati avatuma kundosora nyika yeKenani, akati kwavari, “Kwidzai mupinde nechokuNegevhi uye nomunyika yamakomo. ");
INSERT INTO sna_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mundoona kuti nyika yakadini uye kuti vanhu vanogarako vakasimba here kana kuti havana, vashoma here kana kuti vazhinji. ");
INSERT INTO sna_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Nyika yavanogara yakadini? Yakanaka here kana kuti yakaipa? Maguta avagere maari akadiniko? Haana masvingo here kana kuti akakomberedzwa? ");
INSERT INTO sna_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ko, ivhu racho rakadini? Rakaorera here kana kuti kwete? Mune miti here kana kuti hamuna? Muedze kwazvo kuti muuye nezvimwe zvezvibereko zvenyika iyo.” (Yakanga iri nguva yokutanga kuibva kwamazambiringa). ");
INSERT INTO sna_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Naizvozvo vakakwidza vakandosora nyika kubva kurenje reZini kusvikira kuRehobhi, kwakanangana neRebho Hamati. ");
INSERT INTO sna_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Vakakwidza vachipinda nechokuNegevhi vakasvika kuHebhuroni paigara Ahimeni, Sheshai naTarimai, zvizvarwa zvaAnaki. (Hebhuroni rakanga ravakwa makore manomwe Zoani risati ravakwa muIjipiti). ");
INSERT INTO sna_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Vakati vasvika paMupata weEshikori, vakatema davi rimwe raiva nesumbu ramazambiringa. Vaviri vavo vakaritakura nedanda pakati pavo pamwe chete namatamba uye namaonde. ");
INSERT INTO sna_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Nzvimbo iyo yakanzi Mupata weEshikori nokuda kwesumbu ramazambiringa rakatemwa ipapo navaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Mazuva makumi mana akati apera, vakadzoka kubva kundosora nyika. ");
INSERT INTO sna_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Vakadzokera kuna Mozisi naAroni nokuungano yose yavaIsraeri paKadheshi murenje reParani. Ipapo vakazivisa kwavari nokuungano yose uye vakavaratidza zvibereko zvenyika. ");
INSERT INTO sna_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Vakapa nhoroondo iyi kuna Mozisi: “Takaenda kunyika yamakatituma, uye inoerera mukaka nouchi! Hezvi zvibereko zvayo. ");
INSERT INTO sna_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Asi vanhu vanogarako vane simba kwazvo, uye maguta akakomberedzwa uye makuru kwazvo. Takaona kunyange zvizvarwa zvaAnaki ikoko. ");
INSERT INTO sna_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","VaAmareki vanogara nechokuNegevhi; vaHiti, vaJebhusi navaAmori vanogara munyika yamakomo; uye vaKenani vanogara pedyo negungwa uye nomunzvimbo inotevedza Jorodhani.” ");
INSERT INTO sna_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ipapo Karebhu akanyaradza vanhu pamberi paMozisi akati, “Tinofanira kukwidza tindotora nyika nokuti zvirokwazvo tinogona kuitora.” ");
INSERT INTO sna_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Asi varume vakanga vaenda naye vakati, “Hatigoni kurwisa vanhu ava; vakasimba kutipfuura isu.” ");
INSERT INTO sna_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Saka vakaparadzira mashoko akaipa pakati pavaIsraeri pamusoro penyika yavakanga vandosora. Vakati, “Nyika yatakandosora inodya vaya vanogaramo. Vanhu vose vatakaona ikoko vakakura kwazvo. ");
INSERT INTO sna_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Takaona vaNefirimi (izvo zvizvarwa zvavaAnaki vanobva kuvaNefirimi) ikoko. Isu tainge mhashu pakuona kwedu, uye tainge takadarowo pakuona kwavo.” ");
INSERT INTO sna_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Usiku ihwohwo vanhu vose veungano vakasimudza manzwi avo vakachema zvikuru. ");
INSERT INTO sna_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","VaIsraeri vose vakapopotera Mozisi naAroni uye ungano yose yakati kwavari, “Dai bedzi takanga tafira muIjipiti! Kana murenje rino! ");
INSERT INTO sna_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ko, Jehovha ari kuuyireiko nesu kunyika ino zvoongotirega tichindourayiwa nomunondo? Vakadzi navana vedu vachatorwa senhapwa. Hazvaiva nani here kuti tidzokere kuIjipiti?” ");
INSERT INTO sna_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Zvino vakataurirana vachiti, “Tinofanira kusarudza mutungamiri tidzokere kuIjipiti.” ");
INSERT INTO sna_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ipapo Mozisi naAroni vakawira pasi nezviso zvavo pamberi peungano yose yavaIsraeri yakanga iri ipapo. ");
INSERT INTO sna_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua mwanakomana waNuni naKarebhu mwanakomana waJefune, avo vakanga vari pakati pavaya vakanga vandosora nyika, vakabvarura nguo dzavo. ");
INSERT INTO sna_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Vakati kuungano yose yavaIsraeri, “Nyika yatakapfuura napakati payo tikaisora yakanaka kwazvo. ");
INSERT INTO sna_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kana Jehovha achifadzwa nesu, achatitungamirira kuti tipinde munyika iyoyo, nyika inoyerera mukaka nouchi, agoipa kwatiri. ");
INSERT INTO sna_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Chete imi regai kumukira Jehovha. Uye musatya vanhu venyika iyo, nokuti tichavamedza. Kudzivirirwa kwavo kwabviswa, asi Jehovha anesu. Musavatya.” ");
INSERT INTO sna_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Asi ungano yose yakataura nezvokuti vatakwe namabwe. Ipapo kubwinya kwaJehovha kwakaonekwa paTende Rokusangana navaIsraeri vose. ");
INSERT INTO sna_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Jehovha akati kuna Mozisi, “Vanhu ava vachasvika riniko vachingondizvidza? Vacharamba kunditenda kusvikira riniko, kunyange ndakaita zviratidzo nezvishamiso zvose pakati pavo? ");
INSERT INTO sna_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ndichavarova nedenda ndigovaparadza, asi iwe ndichakuita rudzi rukuru kwazvo uye rwakasimba kukunda ivo.” ");
INSERT INTO sna_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mozisi akati kuna Jehovha, “Ipapo vaIjipita vachanzwa pamusoro pazvo! Kuti makabudisa vanhu ava kubva pakati pavo nesimba renyu. ");
INSERT INTO sna_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Uye vachaudza vanhu vanogara munyika ino pamusoro pazvo. Vakatozvinzwa kare kuti imi, Jehovha, mugere navanhu ava uye kuti imi, Jehovha, makaonekwa chiso nechiso, uye kuti gore renyu rinogara pamusoro pavo, uye kuti munovatungamirira neshongwe yegore masikati uye neshongwe yomoto usiku. ");
INSERT INTO sna_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kana mukauraya vanhu vose ava panguva imwe chete, ndudzi dzakanzwa mukurumbira uyu pamusoro penyu dzichati, ");
INSERT INTO sna_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Jehovha akanga asingagoni kuisa vanhu ava kunyika yaakanga avavimbisa nemhiko; saka akavauraya murenje.’ ");
INSERT INTO sna_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Zvino simba raJehovha ngariratidzwe, sezvamakataura muchiti: ");
INSERT INTO sna_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Jehovha anononoka kutsamwa, azere norudo uye anoregerera zvivi nokumukira. Kunyange zvakadaro haangaregi kuranga ane mhosva, anoranga vana nokuda kwechivi chamadzibaba kusvikira kuchizvarwa chechitatu nechechina.’ ");
INSERT INTO sna_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Zvichienderana norudo rwenyu rukuru, regererai chivi chavanhu ava, sezvamakavaregerera kubva panguva yavakabva kuIjipiti kusvikira zvino.” ");
INSERT INTO sna_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jehovha akapindura akati, “Ndavaregerera sezvawakumbira iwe. ");
INSERT INTO sna_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Asi hazvo, noupenyu hwangu zvirokwazvo, uye zvirokwazvo sokuzara kunoita nyika yose nokubwinya kwaJehovha, ");
INSERT INTO sna_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","hakuna mumwe wavarume vakaona kubwinya kwangu nezvishamiso zvandakaita muIjipiti nomurenje asi vakasanditeerera, uye vakandiedza kanokwana kagumi, ");
INSERT INTO sna_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","hakuna mumwe wavo achazoona nyika yandakavimbisa madzitateguru avo nemhiko. Hakuna kana mumwe akandizvidza achazofa akaona nyika yandakavimbisa madzitateguru avo nemhiko. Hakuna kana mumwe akandizvidza achazofa akaiona. ");
INSERT INTO sna_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Asi nokuda kwokuti muranda wangu Karebhu ano mweya wakasiyana navamwe uye anonditevera nomwoyo wose, ndichamupinza munyika yaakaenda kwairi, uye ichava nhaka yezvizvarwa zvake. ");
INSERT INTO sna_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Sezvo vaAmareki navaKenani vachigara mumipata, dzokai mangwana mufambe makananga kurenje muchitevedza nzira inoenda nokuGungwa Dzvuku.” ");
INSERT INTO sna_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ungano iyi icharamba ichindipopotera kusvikira riniko? Ndanzwa kunyunyuta kwavaIsraeri vokungopopota havo ava. ");
INSERT INTO sna_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Saka vaudze kuti, ‘Zvirokwazvo noupenyu hwangu, ndizvo zvinotaura Jehovha, ndichakuitirai zvinhu zvacho zvandakanzwa muchireva muchiti: ");
INSERT INTO sna_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Zvitunha zvenyu zvichawira murenje rino, imi mose muna makore makumi maviri kana makumi maviri neanoraudza makaverengwa pakuverengwa uye mukandipopotera. ");
INSERT INTO sna_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Hakuna mumwe wenyu achapinda munyika yandakakupikirai noruoko rwakasimudzwa kuti uve musha wenyu, kunze kwaKarebhu mwanakomana waJefune naJoshua mwanakomana waNuni. ");
INSERT INTO sna_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Asi kana vari vana venyu vamakati vachatapwa, ndichavapinza kuti vafare munyika yamaramba imi. ");
INSERT INTO sna_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Asi imi zvitunha zvenyu zvichawira murenje rino. ");
INSERT INTO sna_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vana venyu vachava vafudzi muno kwamakore makumi mana, vachitambudzika nokuda kwokusatendeka kwenyu, kusvikira chitunha chenyu chokupedzisira chavata murenje rino. ");
INSERT INTO sna_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kwamakore makumi mana, gore richimirira zuva rimwe nerimwe ramazuva makumi mana amakasora nyika, muchatambudzika nokuda kwezvivi zvenyu uye muchaziva kuti zvinoita sei kuti ini ndirwe nemi.’ ");
INSERT INTO sna_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ini, Jehovha, ndazvitaura, uye zvirokwazvo ndichaita zvinhu izvi kuungano yose iyi yakaipa, yakabatana pamwe chete kuti indirwise. Vachaperera murenje muno; vachafira muno.” ");
INSERT INTO sna_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Saka varume vakanga vatumwa naMozisi kundosora nyika, vaya vakadzoka vakaita kuti ungano yose ipopotere Mozisi nemhaka yokuparadzira mashoko akaipa pamusoro payo: ");
INSERT INTO sna_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","varume ava vakanga vaparadzira mashoko akaipa pamusoro penyika, vakarohwa vakaurayiwa nedenda pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Pavarume vakaenda kundosora nyika, Joshua mwanakomana waNuni naKarebhu mwanakomana waJefune ndivo bedzi vakararama. ");
INSERT INTO sna_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mozisi akati azivisa izvi kuvaIsraeri vose, vakachema zvikuru. ");
INSERT INTO sna_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mangwana acho mangwanani, vakakwidza vakananga kumusoro kunyika yamakomo marefu. Vakati, “Takatadza hedu. Tichakwidza tiende kunyika yatakavimbiswa naJehovha.” ");
INSERT INTO sna_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Asi Mozisi akati kwavari, “Sei musingateereri kurayira kwaJehovha? Izvi hazvibudiriri! ");
INSERT INTO sna_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Musakwidza kumusoro nokuti Jehovha haazi pakati penyu. Muchakundwa navavengi venyu, ");
INSERT INTO sna_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","nokuti vaAmareki navaKenani vachasangana nemi ikoko. Nokuti makafuratira Jehovha, iye haangavi nemi uye muchaurayiwa nomunondo.” ");
INSERT INTO sna_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kunyange zvakadaro, nepfungwa dzavo, vakaenda vakananga kunyika yamakomo marefu, kunyange Mozisi asina kuenda uye areka yaJehovha yesungano isina kubviswawo pamusasa. ");
INSERT INTO sna_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ipapo vaAmareki navaKenani vaigara munyika yamakomo vakaburuka vakavarwisa vakavadzingirira kusvikira kuHoma. ");
INSERT INTO sna_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Taura kuvaIsraeri uti kwavari: ‘Kana mapinda munyika yandinokupai kuti mugare, ");
INSERT INTO sna_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","uye mukauya nezvipiriso zvinopiswa kuna Jehovha, kubva kumombe kana makwai, kuti muite zvinonhuhwira zvinofadza Jehovha, zvingava zvinopiswa kana zvibayiro, zvemhiko dzakasarudzika kana zvipo zvokupa nokuzvisarudzira kana zvipiriso zvemitambo, ");
INSERT INTO sna_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ipapo munhu anouya nechipiriso chake achapa kuna Jehovha chipiriso chezvipo chiri chegumi cheefa youpfu hwakatsetseka hwakavhenganiswa nechikamu chimwe chete muzvina chehini yamafuta. ");
INSERT INTO sna_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pagwayana rimwe nerimwe rechipiriso chinopiswa kana rechibayiro, munofanira kugadzira chikamu chimwe chete muzvina chehini yewaini chive chipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Munofanira kugadzira negondobwe chipiriso chezviyo chezvikamu zviviri mugumi zveefa youpfu hwakatsetseka hwakavhenganiswa nechikamu chimwe chete kubva muzvitatu chehini yamafuta, ");
INSERT INTO sna_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","uye nechikamu chimwe chete kubva muzvitatu chehini yewaini chive chipiriso chokunwa. Muchipe sechinonhuhwira chinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Pamunogadzirira Jehovha nzombe duku sechipiriso chinopiswa kana sechibayiro, chemhiko yakasarudzika kana chipiriso chokuwadzana, ");
INSERT INTO sna_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","munofanira kuuya nechipiriso chezviyo chezvikamu zvitatu kubva mugumi cheefa youpfu hwakatsetseka hwakavhenganiswa nehafu yehini yamafuta pamwe chete nehando. ");
INSERT INTO sna_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Uyezve muuye nehafu yehini yewaini sechipiriso chokunwa. Chichava chipiriso chinoitwa nomoto, chinonhuhwira chinofadza Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Hando imwe neimwe kana gondobwe, gwayana rimwe nerimwe kana mbudzana, zvinofanira kugadzirwa nenzira iyoyi. ");
INSERT INTO sna_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Munofanira kuita izvi pane chimwe nechimwe chazvo, sokuwanda kwezvamunenge magadzira. ");
INSERT INTO sna_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Munhu wose anoberekwa munyika yenyu, anofanira kuita zvinhu izvi nenzira iyi paanenge achiuya nechipiriso chinoitwa nomoto, chive chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kuzvizvarwa zvinotevera kana mutorwa kana mumwe munhuwo zvake agere pakati penyu akapa chipiriso chinoitwa nomoto, chinonhuhwira zvinofadza Jehovha, anofanira kuita zvakangofanana nezvamunoita imi. ");
INSERT INTO sna_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ungano inofanira kuva nomutemo mumwe chete kumutorwa agere pakati penyu; uyu murayiro usingaperi kusvikira kuzvizvarwa zvinotevera. Muchafanana pamberi paJehovha imi nomutorwa. ");
INSERT INTO sna_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mirayiro mimwe cheteyo ichashanda kwamuri mose, imi nomutorwa agere pakati penyu.’ ” ");
INSERT INTO sna_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Taura kuvaIsraeri uti kwavari: ‘Kana mopinda munyika yandinokuendesai ");
INSERT INTO sna_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","uye mukadya zvokudya zvenyika iyo, munofanira kupa chikamu kuna Jehovha sechipiriso. ");
INSERT INTO sna_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Munofanira kupa keke rinoitwa noupfu hwenyu hwokutanga mugoripa sechipiriso chinobva paburiro. ");
INSERT INTO sna_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kusvikira kuzvizvarwa zvinotevera munofanira kupa chipiriso ichi kuna Jehovha kubva paupfu hwenyu hwokutanga. ");
INSERT INTO sna_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Zvino kana musingatadzi nobwoni kuchengeta mirayiro iyi yakapiwa kuna Mozisi naJehovha, ");
INSERT INTO sna_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","zvipi zvazvo zvakarayirwa naJehovha kubudikidza naMozisi, kubva nezuva razvakapiwa naJehovha uye zvichienda mberi kusvikira kuzvizvarwa zvinotevera, ");
INSERT INTO sna_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","uye kana izvi zvikaitwa kwete nobwoni zvisina kuzivikanwa neungano, ungano yose inofanira kupa hando duku sechipiriso chinopiswa, sezvinonhuhwira zvinofadza kuna Jehovha, nenhongo yembudzi kuti ive chipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Muprista anofanira kuyananisira ungano yose yavaIsraeri, uye vachakanganwirwa, nokuti zvakanga zvisina kuitwa nobwoni, uye, nokuda kwokukanganisa kwavo, vakavigira Jehovha chipiriso chinopiswa uye nechipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ungano yose yavaIsraeri navatorwa vagere pakati pavo vachakanganwirwa, nokuti vanhu vose vakatadza vasingazivi. ");
INSERT INTO sna_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Asi kana munhu mumwe chete akatadza nokusaziva, anofanira kuuya nembudzana hadzi yegore rimwe chete kuti chive chipiriso chechivi. ");
INSERT INTO sna_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Muprista anofanira kuyananisira uyo akatadza pamberi paJehovha nokutadza nokusaziva, uye kana ayananisirwa, achakanganwirwa. ");
INSERT INTO sna_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Murayiro mumwe chete iwoyu unoshanda kuna vose vanotadza vasingazivi, angava akaberekerwa muIsraeri kana mutorwa. ");
INSERT INTO sna_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Asi ani naani anotadza nokuzvikudza, angava akaberekwa muIsraeri kana mutorwa, anomhura Jehovha, munhu uyo anofanira kubviswa pakati pavanhu vokwake. ");
INSERT INTO sna_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nokuti akazvidza shoko raJehovha uye akaputsa mirayiro yake, munhu uyo anofanira kubviswa zvachose; mhosva yake inogara pamusoro pake.’ ” ");
INSERT INTO sna_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","VaIsraeri vachiri murenje, mumwe murume akawanikwa achiunganidza huni nezuva reSabata. ");
INSERT INTO sna_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Avo vakamuwana achiunganidza huni vakauya naye kuna Mozisi naAroni nokuungano yose, ");
INSERT INTO sna_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","uye vakamuchengeta mutorongo, nokuti vakanga vasingazivi zvaifanira kuitwa kwaari. ");
INSERT INTO sna_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ipapo Jehovha akati kuna Mozisi, “Murume uyo anofanira kufa. Ungano yose inofanira kumutaka namabwe kunze kwomusasa.” ");
INSERT INTO sna_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Saka ungano yakamubudisa kunze kwomusasa vakamutaka namabwe kusvikira afa, sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Taura kuvaIsraeri uti kwavari: ‘Kusvikira kuzvizvarwa zvichatevera, munofanira kugadzira pfunha pamakona enguo dzenyu, dzinenge dzine tambo yebhuruu papfunha imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Muchava nepfunha idzi kuti mudzitarire uye naizvozvo mucharangarira zvakarayirwa naJehovha zvose, kuti muzviteerere mugorega kuita ufeve muchitevera kuchiva kwemwoyo yenyu nameso enyu. ");
INSERT INTO sna_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ipapo mucharangarira kuteerera mirayiro yangu yose uye muchazvitsaura kuti muve vanhu vaMwari wenyu. ");
INSERT INTO sna_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ndini Jehovha Mwari wenyu, akakubudisai kubva muIjipiti kuti ndive Mwari wenyu. Ndini Jehovha Mwari wenyu.’ ” ");
INSERT INTO sna_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora mwanakomana waIzhari, mwanakomana waKohati, mwanakomana waRevhi, navamwe vaRubheni, Dhatani naAbhiramu, vanakomana vaEriabhi, naOni mwanakomana waPoreti, vakazvikudza ");
INSERT INTO sna_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","uye vakamukira Mozisi. Vakanga vane varume mazana maviri namakumi mashanu avaIsraeri, vatungamiri vaizivikanwa kwazvo muungano vakanga vagadzwa kuti vave nhengo dzamakurukota. ");
INSERT INTO sna_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Vakauya vari chikwata kuti vazopikisa Mozisi naAroni vakati kwavari, “Mazonyanya zvino! Ungano yose itsvene, mumwe nomumwe wavo zvake, uye Jehovha ari pakati pavo. Zvino munozviisireiko pamusoro peungano yaJehovha?” ");
INSERT INTO sna_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mozisi akati anzwa izvozvo, akawira pasi nechiso. ");
INSERT INTO sna_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ipapo akati kuna Kora navateveri vake vose, “Mangwanani Jehovha acharatidza kuti vanhu vake ndavapi uye kuti mutsvene ndiani, uye achaita kuti munhu uyo aswedere kwaari. Munhu waachasarudza ndiye waachaswededza kwaari. ");
INSERT INTO sna_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Iwe Kora, navateveri vako vose munofanira kuita izvi: Torai hadyana dzezvinonhuhwira ");
INSERT INTO sna_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","uye mangwana muise moto nezvinonhuhwira madziri mugoenda nadzo pamberi paJehovha. Munhu achasarudzwa naJehovha ndiye achava mutsvene. Imi vaRevhi mazonyanya zvino!” ");
INSERT INTO sna_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mozisi akatizve kuna Kora, “Chinzwai zvino, imi vaRevhi! ");
INSERT INTO sna_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ko, hazvina kukwana kwamuri here kuti Mwari wavaIsraeri akakutsaurai pakati peungano yavaIsraeri vose akakuswededzai pedyo naye kuti muite basa patabhenakeri yaJehovha uye kuti mumire pamberi peungano mugovashandira? ");
INSERT INTO sna_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Akakuswededzai imi nehama dzenyu ivo vaRevhi, asi zvino mava kuedza kubvuta upristawo. ");
INSERT INTO sna_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Uku kurwa naJehovha zvamadai kusungana pamwe chete iyemi navose vanokuteverai. Aroni ndianiko wamunopopotera?” ");
INSERT INTO sna_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ipapo Mozisi akadana Dhatani naAbhiramu, vanakomana vaEriabhi. Asi ivo vakati, “Hatiuyiko! ");
INSERT INTO sna_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Hazvina kukwana here kuti makatibudisa munyika inoyerera mukaka nouchi kuti muzotiurayira murenje? Uye iye zvino munoda kubata ushe pamusoro pedu here? ");
INSERT INTO sna_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Pamusoro pezvo, hamuna kutisvitsa kunyika inoyerera mukaka nouchi kana kutipa nhaka yeminda neminda yemizambiringa. Muchada kutumbura meso avanhu ava here? Haiwa, isu hatiuyiko!” ");
INSERT INTO sna_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ipapo Mozisi akatsamwa zvikuru akati kuna Jehovha, “Musagamuchira chipiriso chavo. Handina kutovatorera kana mbongoro, uye handina kutadzira kana mumwe wavo.” ");
INSERT INTO sna_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mozisi akati kuna Kora, “Iwe navose vanokutevera munofanira kumira pamberi paJehovha mangwana, iwe, naivo naAroni. ");
INSERT INTO sna_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Murume mumwe nomumwe ngaatore hadyana yake aise zvinonhuhwira mairi, hadyana mazana maviri namakumi mashanu pamwe chete mugodziisa pamberi paJehovha. Iwe naAroni munofanira kuuyawo nehadyana dzenyu.” ");
INSERT INTO sna_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Saka murume mumwe nomumwe akatora hadyana yake, akaisa moto nezvinonhuhwira mairi, uye vakamira naMozisi naAroni pamukova wokupinda muTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora akati aunganidza vateveri vake vose vaipikisana navo pamukova wokupinda muTende Rokusangana, kubwinya kwaJehovha kwakaonekwa neungano yose. ");
INSERT INTO sna_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Zvitsaurei imi paungano iyi kuitira kuti ndivaparadze izvozvi.” ");
INSERT INTO sna_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Asi Mozisi naAroni vakawira pasi nezviso zvavo vakadanidzira zvikuru vachiti, “Haiwa Mwari, Mwari wemweya yavanhu vose, mungatsamwira ungano yose here munhu mumwe chete angotadza?” ");
INSERT INTO sna_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Uti kuungano, ‘Sudurukai mubve pamatende aKora, Dhatani naAbhiramu.’ ” ");
INSERT INTO sna_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mozisi akasimuka akaenda kuna Dhatani naAbhiramu uye vakuru veIsraeri vakamutevera. ");
INSERT INTO sna_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Akayambira ungano akati, “Sudurukai mubve pamatende avanhu vakaipa ava! Musabata chinhu chipi zvacho chinenge chiri chavo, kuti murege kuparadzwa nokuda kwezvivi zvavo zvose.” ");
INSERT INTO sna_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Saka vakasuduruka vakabva pamatende aKora, Dhatani naAbhiramu. Dhatani naAbhiramu vakanga vabuda kunze uye vakanga vakamira navakadzi vavo, vana navacheche vari pamukova pamatende avo. ");
INSERT INTO sna_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ipapo Mozisi akati, “Muchaziva nezvizvi kuti Jehovha akandituma kuti ndiite zvinhu izvi zvose uye kuti dzakanga dzisiri pfungwa dzangu: ");
INSERT INTO sna_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kana varume ava vakafa savamwe vanhu uye vakasangana nezvinongoitika kuvanhu vose, ipapo Jehovha anenge asina kundituma. ");
INSERT INTO sna_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Asi kana Jehovha akauyisa chimwe chinhu chitsva, uye nyika ikashamisa muromo wayo ikavamedza, nezvose zvavo, uye vakaburukira muguva vari vapenyu, ipapo muchaziva kuti varume ava vazvidza Jehovha.” ");
INSERT INTO sna_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Akati achangopedza kutaura zvose izvi, pasi pavo pakatsemuka ");
INSERT INTO sna_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","uye nyika ikashamisa muromo wayo ikavamedza, nenhumbi dzavo navanhu vose vaKora nezvinhu zvavo zvose. ");
INSERT INTO sna_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Vakaburukira muguva vari vapenyu, nezvinhu zvavo zvose; nyika ikavafukidza, vakaparara vakabva pakati peungano. ");
INSERT INTO sna_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Pavakachema, vaIsraeri vose vakanga vakavakomba vakatiza, vachidanidzira vachiti, “Nyika ichatimedza nesuwo!” ");
INSERT INTO sna_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ipapo moto wakabuda uchibva kuna Jehovha ukaparadza varume mazana maviri namakumi mashanu vakanga vachipisira zvinonhuhwira. ");
INSERT INTO sna_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Taurira Ereazari mwanakomana waAroni, muprista, kuti abvise hadyana parufuse agoparadzira mazimbe kure nokuti hadyana itsvene, ");
INSERT INTO sna_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","idzo hadyana dzavarume vaye vakatadza vakaurayiwa. Pwanyai hadyana mugoita chifukidziro chearitari nadzo, nokuti dzakauyiswa pamberi paJehovha dzikava tsvene. Ngadzive chiratidzo kuvaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Saka Ereazari muprista akaunganidza hadyana dzendarira dzakauya navaya vakanga vapiswa, akaita kuti dzipwanyiwe kuti dzigova chifukidzo chearitari, ");
INSERT INTO sna_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","sezvaakarayirwa naJehovha kubudikidza naMozisi. Ichi chaiva chirangaridzo kuvaIsraeri chokuti hakuna munhu anofanira kupisira zvinonhuhwira pamberi paJehovha kunze kwechizvarwa chaAroni kuti aregere kuzofanana naKora navateveri vake. ");
INSERT INTO sna_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Fume mangwana, ungano yose yavaIsraeri yakapopotera Mozisi naAroni. Vakati, “Imi makauraya vanhu vaJehovha.” ");
INSERT INTO sna_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Asi ungano yakati yaungana pamwe chete ichipikisana naMozisi naAroni vakatarira kuTende Rokusangana, pakarepo gore rikaifukidza uye kubwinya kwaJehovha kukaonekwa. ");
INSERT INTO sna_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ipapo Mozisi naAroni vakaenda mberi kweTende Rokusangana, ");
INSERT INTO sna_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","uye Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ibva paungano iyi kuti ndivaparadze iye zvino.” Ipapo vakawira pasi nezviso zvavo. ");
INSERT INTO sna_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Zvino Mozisi akati kuna Aroni, “Tora hadyana yako ugoisa zvinonhuhwira mairi pamwe chete nomoto unobva paaritari, uchimbidze kuenda kuungano undovayananisira. Hasha dzabuda dzichibva kuna Jehovha; denda ratotanga.” ");
INSERT INTO sna_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Saka Aroni akaita sezvakarehwa naMozisi, akamhanyira pakati peungano. Denda rakanga ratotanga pakati pavanhu, asi Aroni akapisira zvinonhuhwira akavayananisira. ");
INSERT INTO sna_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Akamira pakati pavapenyu navakafa, denda rikamirawo. ");
INSERT INTO sna_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Asi vanhu zviuru gumi nezvina namazana manomwe vakafa nedenda, vachiwedzera pane vaya vakanga vafa nokuda kwaKora. ");
INSERT INTO sna_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ipapo Aroni akadzokera kuna Mozisi pamukova wokupinda muTende Rokusangana, nokuti denda rakanga rapera. ");
INSERT INTO sna_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Taura kuvaIsraeri utore tsvimbo gumi nembiri kubva kwavari, imwe chete kubva kuno mumwe nomumwe wavatungamiri vamarudzi amadzitateguru avo. Unyore zita romurume mumwe nomumwe patsvimbo yake. ");
INSERT INTO sna_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Patsvimbo yaRevhi unyore zita raAroni, nokuti panofanira kuva netsvimbo imwe chete yomukuru mumwe nomumwe worudzi rwamadzitateguru avo. ");
INSERT INTO sna_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Udziise muTende Rokusangana pamberi peChipupuriro, pandinosangana nemi. ");
INSERT INTO sna_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Tsvimbo yomunhu wandichasarudza ichabukira mashizha, uye ndichagumisa kupopota uku kwavaIsraeri kuri kuramba kuripo pamusoro pako.” ");
INSERT INTO sna_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Saka Mozisi akataura navaIsraeri, uye vatungamiri vavo vakamupa tsvimbo gumi nembiri, imwe chete iri yomutungamiri mumwe nomumwe wamarudzi amadzitateguru avo, uye tsvimbo yaAroni yakanga iri pakati padzo. ");
INSERT INTO sna_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mozisi akaisa tsvimbo idzi pamberi paJehovha muTende reChipupuriro. ");
INSERT INTO sna_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Fume mangwana Mozisi akapinda muTende reChipupuriro uye akaona kuti tsvimbo yaAroni, iyo yaiva yakamirira imba yaRevhi, yakanga isina kungobukira bedzi asi yakanga yatungira, yava namaruva uye yabereka maarimondi. ");
INSERT INTO sna_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ipapo Mozisi akatora tsvimbo dzose kubva pamberi paJehovha akaenda nadzo kuvaIsraeri vose. Vakadzitarisa, ipapo murume mumwe nomumwe akatora tsvimbo yake. ");
INSERT INTO sna_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Jehovha akati kuna Mozisi, “Dzorera tsvimbo yaAroni pamberi peTende reChipupuriro, kuti ichengetwe sechiratidzo kuvanhu vanondimukira. Izvozvi zvichagumisa kundipopotera kwavo, kuti varege kufa.” ");
INSERT INTO sna_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mozisi akaita sezvaakarayirwa naJehovha, izvozvo ndizvo zvaakaita. ");
INSERT INTO sna_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","VaIsraeri vakati kuna Mozisi, “Isu tichafa hedu! Takarasika, takarasika isu tose! ");
INSERT INTO sna_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ani naani achaswedera patabhenakeri yaJehovha achafa. Ko, isu tose tichafa here?” ");
INSERT INTO sna_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Jehovha akati kuna Aroni, “Iwe, navanakomana vako nemhuri yababa vako munofanira kuva nebasa rokutakura mhosva dzinotadzirwa nzvimbo tsvene, uye iwe navanakomana vako bedzi ndimi munofanira kuita basa rokutakura mhosva dzinotadzirwa basa rouprista. ");
INSERT INTO sna_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Uya nehama dzako ivo vaRevhi vanobva kurudzi rwamadzitateguru ako kuti vazobatana newe uye vagokubatsira iwe navanakomana vako pamunoshumira pamberi peTende reChipupuriro. ");
INSERT INTO sna_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Vanofanira kuva pasi pako uye vanofanira kuita mabasa ose eTende asi havafaniri kuswedera pedyo nemidziyo yenzvimbo tsvene kana aritari, kana kuti mose ivo newe muchafa. ");
INSERT INTO sna_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Vanofanira kubatana newe vagoita basa rokuchengeta Tende Rokusangana, basa rose rapaTende uye hakuna mumwezve anofanira kuswedera pauri. ");
INSERT INTO sna_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Munofanira kuva nebasa rokuchengeta nzvimbo tsvene nearitari, kuti hasha dzirege kuwira pavaIsraerizve. ");
INSERT INTO sna_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ini pachangu ndakasarudza hama dzako ivo vaRevhi pakati pavaIsraeri kuti vave sechipo kwauri, vakumikidzwe kuna Jehovha kuti vaite basa paTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Asi iwe chete navanakomana vako ndimi mungashanda savaprista pazvinhu zvose zviri paaritari nezviri mukati mechifukidziro. Ndiri kukupai basa rouprista sechipo. Ani naani anoswedera panzvimbo tsvene anofanira kuurayiwa.” ");
INSERT INTO sna_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ipapo Jehovha akati kuna Aroni, “Ini ndimene ndakugadza kuti uve muchengeti wezvipiriso zvinopiwa kwandiri; zvipiriso zvose zvitsvene zvinopiwa kwandiri navaIsraeri ndinozvipa kwauri iwe navanakomana vako somugove wako uye ugova mugove wako wamazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Iwe unofanira kuva nomugove wezvipiriso zvitsvene-tsvene zvinosara pane zvinopiswa. Pazvipo zvose zvavanondivigira sezvipiriso zvitsvene-tsvene, zvingava zvezviyo kana zvechivi kana chipiriso chemhosva, chikamu ichocho ndechako iwe navanakomana vako. ");
INSERT INTO sna_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Muchidye sechinhu chitsvene-tsvene; murume wose achachidya. Chinofanira kuva chitsvene kwamuri. ");
INSERT INTO sna_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Izvi ndezvako zvakare: chimwe nechimwe chinotsaurwa kubva pazvipo zvose zvezvipiriso zvinoninirwa zvavaIsraeri. Ndinokupa izvi iwe navanakomana vako navanasikana vako somugove wako wamazuva ose. Munhu wose weimba yako anenge akachena angazvidya hake. ");
INSERT INTO sna_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ndinokupa mafuta omuorivhi akaisvonaka uye waini yose yakaisvonaka nezviyo zvavanovigira Jehovha sezvibereko zvokutanga zvegohwo ravo. ");
INSERT INTO sna_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Zvibereko zvose zvenyika zvavanovigira Jehovha zvichava zvako. Munhu wose weimba yako anenge akachena angazvidya. ");
INSERT INTO sna_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Zvinhu zvose zvakatsaurirwa Jehovha muIsraeri ndezvako. ");
INSERT INTO sna_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Chibereko chinotanga kuzarura chizvaro, chingava chomunhu kana chechipfuwo, chinopiwa kuna Jehovha, ndechako. Asi unofanira kudzikinura mwanakomana wose wedangwe uye dangwe rose remhuka dzisina kunaka. ");
INSERT INTO sna_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kana zvava nomwedzi mumwe chete, unofanira kuzvidzikinura nomutengo wedzikinuro wakatarwa wamashekeri mashanu esirivha, maererano neshekeri renzvimbo tsvene, rinorema magera makumi maviri. ");
INSERT INTO sna_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Asi haufaniri kudzikinura mhuru nzombe yedangwe, gwai kana mbudzi, zvitsvene. Usase ropa razvo paaritari ugopisa mafuta azvo sechipiriso chinoitwa nomoto, chive chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama yazvo ichava yako, sezvakangoita chityu chechipiriso chokuninira nechidya chokurudyi zvagara zviri zvako. ");
INSERT INTO sna_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ndinokupa zvose zvipiriso zvitsvene zvakatsaurirwa Jehovha navaIsraeri, iwe navanakomana navanasikana vako somugove wako wenguva yose. Isungano yemunyu nokusingaperi pamberi paJehovha kwamuri mose iwe nezvizvarwa zvako.” ");
INSERT INTO sna_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Jehovha akati kuna Aroni, “Iwe haungawani nhaka munyika mavo, uye haungavi nomugove nenhaka pakati pavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“VaRevhi ndinovapa zvegumi zvose zvavaIsraeri senhaka yavo kutsiva basa ravanoita pavanenge vachishumira paTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kubva zvino zvichienda mberi, vaIsraeri havafaniri kuswedera kuTende Rokusangana, kuti varege kuva nemhosva yezvivi zvavo vakazofa. ");
INSERT INTO sna_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","VaRevhi ndivo vanofanira kuita basa paTende Rokusangana uye vagotakura zvakaipa zvavanhu. Uyu mutemo uchagara uripo kusvikira kuzvizvarwa zvinotevera. Ivo havangawani nhaka pakati pavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Pachinzvimbo chaizvozvo ndinopa kuvaRevhi nhaka yezvegumi zvinopiwa kuna Jehovha navaIsraeri. Ndokusaka ndakati kwavari: ‘Havangavi nenhaka pakati pavaIsraeri.’ ” ");
INSERT INTO sna_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Taura kuvaRevhi uti kwavari: ‘Pamunogamuchira zvegumi kubva kuvaIsraeri zvandinokupai senhaka yenyu, munofanira kupa chegumi chezvegumi sechipiriso chaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Chipiriso chako chichaverengwa kwauri sechezviyo zvinobva paburiro kana muto wewaini unobva pachisviniro chewaini. ");
INSERT INTO sna_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nenzira iyi nemiwo munofanira kupa chipiriso kuna Jehovha kubva pazvegumi zvose zvamunogamuchira kubva kuvaIsraeri. Kubva pazvegumi izvi, munofanira kupa mugove waJehovha kuna Aroni muprista. ");
INSERT INTO sna_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Munofanira kupa somugove waJehovha chakanakisisa uye chikamu chitsvene chezvinhu zvose zvamunenge mapiwa.’ ");
INSERT INTO sna_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Uti kuvaRevhi: ‘Pamunouyisa chikamu chakanakisisa, chichagamuchirwa kubva kwamuri sechakabva paburiro kana pachisviniro chewaini, ");
INSERT INTO sna_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","iwe nemhuri yako mungadya henyu zvakasara zvose chero pamunenge muri, nokuti ndiwo mubayiro wenyu webasa renyu rapaTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Hamungazovi nemhosva pachinhu kana muchiuyisa chikamu chakanakisisa chacho; ipapo hamungazosvibisi zvitsvene zvavaIsraeri, uye hamuzofi.’ ” ");
INSERT INTO sna_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Izvi ndizvo zvinodikanwa pamurayiro wakarayirwa naJehovha. Udza vaIsraeri kuti vakuvigire tsiru dzvuku risina kuremara, kana charingapomerwa uye risina kumbosungwa pajoko. ");
INSERT INTO sna_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Uripe kuna Ereazari muprista; rinofanira kubudiswa kunze kwomusasa rigourayiwa pamberi pake. ");
INSERT INTO sna_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ipapo Ereazari muprista anofanira kutora rimwe reropa raro nomunwe agorisasa kanomwe akananga mberi kweTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Akatarisa, tsiru rinofanira kupiswa, dehwe raro, nyama yaro namazvizvi aro. ");
INSERT INTO sna_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Muprista anofanira kutora huni dzomusidhari, hisopi newuru tsvuku agozvikanda pamusoro petsiru riri kutsva. ");
INSERT INTO sna_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Shure kwaizvozvo, muprista anofanira kusuka nguo dzake uye azvishambidze nemvura. Ipapo angachipinda hake mumusasa, asi achange asina kunatswa kusvikira madekwana. ");
INSERT INTO sna_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Munhu acharipisa naiyewo anofanira kusuka nguo dzake uye agoshamba nemvura uye iyewo achava asina kuchena kusvikira madekwana. ");
INSERT INTO sna_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Munhu akachena achaunganidza madota etsiru agoaisa panzvimbo yakanaka iri kunze kwomusasa. Achachengetwa neungano yavaIsraeri kuti agoshandiswa pamvura yokunatsa; ndeyokunatswa kubva pachivi. ");
INSERT INTO sna_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Munhu anounganidza madota etsiru anofanirawo kusuka nguo dzake, naiyewo achava asina kuchena kusvikira madekwana. Mutemo uyu uchagara uripo pakati pavaIsraeri navatorwa vagere pakati pavo. ");
INSERT INTO sna_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ani naani anobata chitunha chaani zvake achava asina kuchena kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Anofanira kuzvinatsa nemvura nezuva retatu uye nezuva rechinomwe; ipapo achava akachena. ");
INSERT INTO sna_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ani naani anobata chitunha chaani zvake akasazvinatsa anosvibisa tabhenakeri yaJehovha. Munhu uyu anofanira kubviswa pakati pavaIsraeri. Nokuti mvura yokunatsa haina kumbosaswa pamusoro pake, haana kuchena; kusachena kwake kucharamba kuri paari. ");
INSERT INTO sna_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Uyu ndiwo murayiro unobata pamunhu anofira mutende: Ani naani anopinda mutende uye ani zvake ari mariri achava asina kuchena kwamazuva manomwe, ");
INSERT INTO sna_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","uye midziyo yose yakazarurwa, isina kukwidibirwa, ichava isina kuchena. ");
INSERT INTO sna_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ani naani ari musango anobata munhu akaurayiwa nomunondo kana mumwe munhu akangofawo zvake, kana munhu anobata bvupa romunhu kana guva, achava asina kuchena kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Kana munhu asina kuchena, utore dota rinobva pachipiriso chokunatsa chakapiswa ugoriisa muchirongo ugoridira mvura yakachena. ");
INSERT INTO sna_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ipapo munhu akachena anofanira kutora hisopi, ainyike mumvura agosasa tende nemidziyo yose uye navanhu vanga varimo. Anofanira kusasawo ani zvake akabata bvupa romunhu kana guva kana mumwe munhu akaurayiwa kana munhu akangofawo zvake. ");
INSERT INTO sna_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Munhu akachena anofanira kusasa munhu asina kuchena nezuva rechitatu uye nerechinomwe, uye pazuva rechinomwe anofanira kumunatsa. Munhu ari kunatswa anofanira kusuka nguo dzake agozvishambidza nemvura, uye manheru iwayo anofanira kuva akachena. ");
INSERT INTO sna_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Asi kana munhu asina kuchena akasazvinatsa, anofanira kubviswa paungano, nokuti iye asvibisa nzvimbo tsvene yaJehovha. Mvura yokunatsa haina kumbosaswa paari, nokudaro haana kuchena. ");
INSERT INTO sna_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Uyu mutemo uchagara uripo kwavari. “Munhu anosasa mvura yokunatsa anofanirawo kusuka nguo dzake, uye ani naani anobata mvura yokunatsa achava asina kunaka kusvikira madekwana. ");
INSERT INTO sna_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Chinhu chose chinobatwa nomunhu asina kuchena chinova chisina kuchena, uye ani naani anochibata anova asina kuchena kusvikira madekwana.” ");
INSERT INTO sna_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mumwedzi wokutanga, ungano yose yeIsraeri yakasvika murenje reZini, uye vakandogara paKadheshi. Ndipo pakafira Miriamu uye akavigwapo. ");
INSERT INTO sna_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Zvino pakanga pasisina mvura yeungano, uye vanhu vakaungana vakapopotera Mozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Vakapopotera Mozisi vachiti, “Dai zvedu takafa pakafira hama dzedu pamberi paJehovha! ");
INSERT INTO sna_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Seiko wakauya neungano yaJehovha murenje rino, kuti isu nezvipfuwo zvedu tifire muno. ");
INSERT INTO sna_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Seiko wakatibudisa muIjipiti uchitiuyisa munzvimbo yakaipa kudai? Haina zviyo kana maonde, mazambiringa kana matamba. Uye mvura yokunwa hapana!” ");
INSERT INTO sna_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mozisi naAroni vakabva paungano vakaenda kumukova weTende Rokusangana vakawira pasi nezviso zvavo, kubwinya kwaJehovha kukaratidzwa kwavari. ");
INSERT INTO sna_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Tora tsvimbo uye iwe nomukoma wako Aroni muunganidze ungano pamwe chete. Utaure kudombo pamberi pavo rigobudisa mvura yaro. Iwe uchabudisa mvura kubva mudombo kuti vanwe ivo nezvipfuwo zvavo.” ");
INSERT INTO sna_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Saka Mozisi akatora tsvimbo pamberi paJehovha, sezvaakanga amurayira. ");
INSERT INTO sna_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Iye naAroni vakaunganidza ungano pamwe chete pamberi pedombo, Mozisi akati kwavari, “Teererai imi vokumukira, tinofanira kukubudisirai mvura padombo iri here?” ");
INSERT INTO sna_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ipapo Mozisi akasimudza ruoko rwake akarova dombo kaviri netsvimbo yake. Mvura yakabuda, ungano nezvipfuwo zvikanwa. ");
INSERT INTO sna_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Asi Jehovha akati kuna Mozisi naAroni, “Nokuti hamuna kuvimba neni zvakakwana kuti mundikudze somutsvene pamberi pavaIsraeri, imi hamuchapinzi ungano iyi munyika yandakavapa.” ");
INSERT INTO sna_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Iyi ndiyo mvura yeMeribha, apo vaIsraeri vakarwa naJehovha uye paakazviratidza kuti mutsvene pakati pavo. ");
INSERT INTO sna_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mozisi akatuma nhume ari kuKadheshi kuna mambo weEdhomu, achiti: “Zvanzi nomununʼuna wako Israeri: Iwe unoziva matambudziko ose akatiwira. ");
INSERT INTO sna_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Madzibaba edu akaburuka achienda kuIjipiti, tikandogarako kwamakore mazhinji. VaIjipita vakatibata zvakaipa isu namadzibaba edu, ");
INSERT INTO sna_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","asi takati tadana kuna Jehovha, akatinzwa akatuma mutumwa akatibudisa muIjipiti. “Zvino tiri pano paKadheshi, guta riri kumucheto wenyika yenyu. ");
INSERT INTO sna_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tapota titendereiwo kupfuura nomunyika yenyu. Hatizopindi nomuminda ipi zvayo kana minda yemizambiringa kana kunwa zvako mvura mutsime ripi zvaro. Tichafamba hedu nomunzira huru yamambo uye hatingatsaukiri kurudyi kana kuruboshwe kusvikira tapfuura nomunyika yenyu.” ");
INSERT INTO sna_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Asi Edhomu akapindura akati: “Hamupfuuri napano; kana mukaedza, tichabuda tigokurwisai nomunondo.” ");
INSERT INTO sna_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","VaIsraeri vakapindura vakati: “Tichaenda nenzira huru, uye kana isu kana zvipfuwo zvedu zvikanwa mvura yenyu, ticharipa. Tinongoda kupfuura tichifamba netsoka, hapanazve chimwe.” ");
INSERT INTO sna_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Vakapindurazve vachiti: “Hamungapfuuri.” Ipapo Edhomu akauya kuzovarwisa nehondo huru uye ine simba. ");
INSERT INTO sna_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Sezvo Edhomu akaramba kuvabvumira kupfuura nomunyika yavo, vaIsraeri vakatsauka havo kubva kwavari. ");
INSERT INTO sna_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ungano yose yeIsraeri yakasimuka kubva kuKadheshi uye vakasvika paGomo reHori. ");
INSERT INTO sna_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","PaGomo reHori, pedyo nomuganhu weEdhomu, Jehovha akati kuna Mozisi naAroni, ");
INSERT INTO sna_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aroni achachengetwa kuvanhu vokwake. Haangapindi munyika yandakapa vaIsraeri, nokuti mose muri vaviri makamukira murayiro wangu pamvura yepaMeribha. ");
INSERT INTO sna_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tora Aroni nomwanakomana wake Ereazari ukwire navo muGomo reHori. ");
INSERT INTO sna_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ubvise nguo dzaAroni udzipfekedze mwanakomana wake Ereazari nokuti Aroni achasanganiswa navanhu vokwake; achafira ipapo.” ");
INSERT INTO sna_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mozisi akaita sezvaakanga arayirwa naJehovha: Vakakwira muGomo reHori pamberi peungano yose. ");
INSERT INTO sna_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mozisi akabvisa nguo dzaAroni akadzipfekedza mwanakomana wake Ereazari. Uye Aroni akafira ipapo pamusoro pegomo. Ipapo Mozisi naEreazari vakaburuka kubva mugomo. ");
INSERT INTO sna_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Uye ungano yose yakati yazvinzwa kuti Aroni akanga afa, imba yose yeIsraeri yakamuchema kwamazuva makumi matatu. ");
INSERT INTO sna_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mambo weAradhi muKenani aigara kuNegevhi, akati anzwa kuti vaIsraeri vakanga vachiuya nenzira inoenda kuAtarimi, akarwisa vaIsraeri akatapa vamwe vavo. ");
INSERT INTO sna_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ipapo vaIsraeri vakaita mhiko iyi kuna Jehovha, vakati: “Kana mukaisa vanhu ava mumaoko edu, tichaparadza maguta avo zvachose.” ");
INSERT INTO sna_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Jehovha akateerera chikumbiro chavaIsraeri akapa vaKenani kwavari. Vakavaparadza zvachose ivo namaguta avo; naizvozvo nzvimbo iyo ikatumidzwa kunzi Homa. ");
INSERT INTO sna_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Vakafamba vachibva nokuGomo reHori vachitevedza nzira yaienda nokuGungwa Dzvuku, kuti vapoterere Edhomu. Asi vanhu vakaora mwoyo panzira; ");
INSERT INTO sna_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","vakapopotera Mwari naMozisi, vachiti, “Makatibudisireiko muIjipiti kuti tizofira murenje? Chingwa hapana! Mvura hapana! Uye hatidi zvokudya zvokungotamburira izvi!” ");
INSERT INTO sna_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ipapo Jehovha akatuma nyoka dzino uturu pakati pavo, dzikaruma vanhu uye vaIsraeri vazhinji vakafa. ");
INSERT INTO sna_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Vanhu vakauya kuna Mozisi vakati, “Takatadza, patakapopotera Jehovha nemi. Nyengeterai kuti Jehovha atibvisire nyoka idzi pakati pedu.” Saka Mozisi akanyengeterera vanhu. ");
INSERT INTO sna_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Jehovha akati kuna Mozisi, “Gadzira nyoka ino uturu ugoiturika padanda; ani naani anorumwa, akatarira kwairi achararama.” ");
INSERT INTO sna_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Saka Mozisi akagadzira nyoka yendarira akaiturika padanda. Ipapo vaiti kana ani naani akange arumwa nenyoka, akatarisa panyoka yendarira, airarama. ");
INSERT INTO sna_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","VaIsraeri vakaramba vachifamba vakandodzika musasa paObhoti. ");
INSERT INTO sna_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ipapo vakasimuka kubva paObhoti vakandodzika musasa paIye Abharimi, mugwenga rakatarisana neMoabhu kwakanangana nokumabudazuva. ");
INSERT INTO sna_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kubva ipapo vakaenderera mberi vakandodzika musasa muMupata weZeredhi. ");
INSERT INTO sna_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Vakasimuka vakabvapo vakandodzika musasa mujinga meAnoni, riri murenje rinosvika kunyika yavaAmori. Anoni ndiwo muganhu weMoabhu, pakati peMoabhu navaAmori. ");
INSERT INTO sna_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ndokusaka Bhuku reHondo dzaJehovha richiti: “Wahebhi muSufa nehova, Anoni ");
INSERT INTO sna_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nemateru ehova dzinonanga kunzvimbo yeAri uye dzinowanikwa pamuganhu weMoabhu.” ");
INSERT INTO sna_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kubva ipapo vakapfuurira mberi vachienda vakasvika kuBheeri, patsime apo pakanzi naJehovha kuna Mozisi, “Unganidza vanhu pamwe chete uye ini ndichavapa mvura.” ");
INSERT INTO sna_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ipapo vaIsraeri vakaimba rwiyo urwu: “Tubuka, iwe tsime! Imbai pamusoro paro, ");
INSERT INTO sna_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","pamusoro petsime rakacherwa namachinda, rakacherwa namakurukota avanhu, makurukota akanga ane tsvimbo dzoushe nemidonzvo.” Ipapo vakabva murenje vakaenda kuMatana, ");
INSERT INTO sna_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","vachibva kuMatana vakaenda kuNaharieri, vachibva kuNaharieri vakaenda kuBhamoti, ");
INSERT INTO sna_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","uye vachibva kuBhamoti vakaenda kumupata uri muMoabhu pamusoro pegomo rePisiga rinotarira pasi kurenje. ");
INSERT INTO sna_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","VaIsraeri vakatuma nhume kundoti kuna Sihoni mambo wavaAmori: ");
INSERT INTO sna_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Titendereiwo kupfuura nomunyika yenyu. Hatingatsaukiri muminda yenyu kana minda yemizambiringa, kana kunwa mvura kubva patsime ripi zvaro. Tichangofamba hedu nomunzira huru yamambo kusvikira tapfuura munyika yenyu.” ");
INSERT INTO sna_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Asi Sihoni haana kutendera vaIsraeri kupfuura nomunyika yake. Akaunganidza hondo yake yose vakafamba vachienda kurenje kundorwisa vaIsraeri. Akati asvika paJahazi, vakarwa navaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kunyange zvakadaro, vaIsraeri vakamukunda nomunondo vakamutorera nyika yake kubva paAnoni kusvikira kuJabhoki, asi kusvikira kuvaAmoni bedzi, nokuti muganhu wavo wakanga wakasimba. ");
INSERT INTO sna_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","VaIsraeri vakatapa maguta ose avaAmori vakagaramo, pamwe chete neHeshibhoni nenzvimbo dzaro dzose dzokugara. ");
INSERT INTO sna_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshibhoni rakanga riri guta raSihoni mambo wavaAmori, akanga arwa namambo akanga ari weMoabhu kare akamutorera nyika yake yose kundosvika kuAnoni. ");
INSERT INTO sna_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ndokusaka vadetembi vachiti: “Uyai kuHeshibhoni uye ngarivakwezve; guta raSihoni ngaridzorerwezve. ");
INSERT INTO sna_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Moto wakabuda muHeshibhoni, iwo murazvo kubva muguta raSihoni. Wakaparadza Ari reMoabhu, ivo vagari vokwakakwirira kweAnoni. ");
INSERT INTO sna_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Une nhamo, iwe Moabhu! Maparadzwa, imi vanhu veKemoshi! Akapa vanakomana vake savatizi navanasikana vake senhapwa kuna Sihoni mambo wavaAmori. ");
INSERT INTO sna_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Asi takavakunda; Heshibhoni yakaparadzwa yose kusvikira kuDhibhoni. Takavaparadza kusvikira kuNofa, iyo inosvika kuMedhebha.” ");
INSERT INTO sna_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Saka vaIsraeri vakagara munyika yavaAmori. ");
INSERT INTO sna_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Shure kwokunge Mozisi atuma vasori kuJazeri, vaIsraeri vakatapa nzvimbo dzaro dzakanga dzakaripoteredza uye vakadzinga vaAmori vakanga vageremo. ");
INSERT INTO sna_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ipapo vakadzoka vakakwidza nenzira inoenda nokuBhashani, uye Ogi mambo weBhashani nehondo yake yose akabuda kuti andosangana navo kuti arwe navo paEdhirei. ");
INSERT INTO sna_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Jehovha akati kuna Mozisi, “Usamutya, nokuti ndamupa kwauri, nehondo yake yose uye nenyika yake. Umuitire zvawakaitira Sihoni mambo wavaAmori, uyo aitonga muHeshibhoni.” ");
INSERT INTO sna_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Saka vakamuuraya, pamwe chete navanakomana vake nehondo yake yose, vakasiya pasina kana mupenyu. Uye vakatora nyika yake. ");
INSERT INTO sna_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ipapo vaIsraeri vakafamba vachienda kumapani eMoabhu vakadzika misasa yavo vakatevedza Jorodhani nechemhiri kweJeriko. ");
INSERT INTO sna_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Zvino Bharaki mwanakomana waZipori akaona zvose zvakanga zvaitwa navaIsraeri kuvaAmori, ");
INSERT INTO sna_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moabhu akatya nokuti pakanga pane vanhu vazhinji. Zvirokwazvo, Moabhu yakazara nokudedera nokuda kwavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","VaMoabhu vakati kuvakuru veMidhiani, “Vanhu vazhinji ava vachananzva zvinhu zvose zvakatipoteredza, semombe inonanzva sora romusango.” Saka Bharaki mwanakomana waZipori, uyo akanga ari Mambo weMoabhu panguva iyoyo, ");
INSERT INTO sna_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","akatuma nhume kundodana Bharamu mwanakomana waBheori, uyo akanga ari paPetori, pedyo noRwizi, munyika yaakaberekerwa. Bharaki akati: “Vanhu vakabva kuIjipiti, vakazadza nyika yose, uye vagara pedyo neni. ");
INSERT INTO sna_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Zvino, uya utuke vanhu ava, nokuti simba ravo iguru kwazvo kwandiri. Zvichida ipapo ndingagona kuvakunda ndikavadzinga vabude munyika ino. Nokuti ndinoziva kuti avo vaunoropafadza vanoropafadzwa, uye vaunotuka vanotukwa.” ");
INSERT INTO sna_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Vakuru veMoabhu neveMidhiani vakabva, vakatora mari yokuripa kuvuka. Vakati vasvika kuna Bharamu vakamuudza zvakanga zvarehwa naBharaki. ");
INSERT INTO sna_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bharamu akati kwavari, “Chivatai pano, ndichauya nemhinduro yandichapiwa naJehovha.” Saka machinda eMoabhu akagara naye. ");
INSERT INTO sna_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mwari akauya kuna Bharamu akamubvunza akati, “Vanhu vaunavo ndivanaaniko?” ");
INSERT INTO sna_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bharamu akati kuna Mwari, “Bharaki mwanakomana waZipori, mambo weMoabhu, akanditumira nhume idzi achiti, ‘Vanhu vakabuda kubva kuIjipiti vakazadza nyika yose. ");
INSERT INTO sna_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Zvino uya unditukire vanhu ava. Zvichida izvozvi ndingagona kurwa navo ndikavadzingira kure.’ ” ");
INSERT INTO sna_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Asi Mwari akati kuna Bharamu, “Usaenda navo. Haufaniri kutuka vanhu avo, nokuti vakaropafadzwa.” ");
INSERT INTO sna_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Fume mangwana, Bharamu akamuka akati kumachinda aBharaki, “Dzokerai kunyika yokwenyu, nokuti Jehovha aramba kuti ndiende nemi.” ");
INSERT INTO sna_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Saka machinda eMoabhu akadzokera kuna Bharaki akati, “Bharamu akaramba kuuya nesu.” ");
INSERT INTO sna_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ipapo Bharaki akatumazve mamwe machinda, akawanda chose uye aikudzwa kupinda vokutanga. ");
INSERT INTO sna_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Vakasvika kuna Bharamu vakati: “Zvanzi naBharaki mwanakomana waZipori: Usatendera chimwe chinhu kukukonesa kuuya kwandiri, ");
INSERT INTO sna_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","nokuti ndichakupa mubayiro wakanaka kwazvo uye ndichaita zvose zvaunoreva. Uya unditukire vanhu ava.” ");
INSERT INTO sna_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Asi Bharamu akavapindura akati, “Kunyange dai Bharaki akandipa muzinda wake uzere nesirivha negoridhe, handingagoni kuita chimwe chinhu chikuru kana chiduku kuti tiite zvinodarika murayiro waJehovha Mwari wangu. ");
INSERT INTO sna_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Zvino chivatai pano manheru ano sezvakaita vamwe, ini ndichanzwa kana Jehovha ane zvimwe zvaangandiudza.” ");
INSERT INTO sna_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Usiku ihwohwo Mwari akauya kuna Bharamu akati kwaari, “Sezvo vanhu ava vauya kuzokudana, enda hako navo, asi uite chete zvandinokuudza.” ");
INSERT INTO sna_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bharamu akamuka mangwanani, akaisa chigaro pambongoro yake akaenda namachinda eMoabhu. ");
INSERT INTO sna_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Asi Mwari akamutsamwira zvikuru paakaenda, uye mutumwa waJehovha akamira munzira kuti amukonese. Bharamu akanga akatasva mbongoro yake, uye varanda vake vaviri vaiva naye. ");
INSERT INTO sna_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mbongoro yakati ichiona mutumwa waJehovha amire munzira ane munondo wakavhomorwa muruoko rwake, yakabuda munzira ikapinda mumunda. Bharamu akairova kuti idzokere munzira. ");
INSERT INTO sna_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ipapo mutumwa waJehovha akamira pakamanikana pakati peminda miviri yemizambiringa, paiva namasvingo kumativi ose. ");
INSERT INTO sna_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Mbongoro yakati ichiona mutumwa waJehovha, yakazvimanikidzira kurusvingo ikatsimbirira rutsoka rwaBharamu parwuri. Saka akapamhazve kuirova. ");
INSERT INTO sna_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ipapo mutumwa waJehovha akapfuurira mberi akandomira panzvimbo yakamanikana pakanga pasina mukana wokutendeukira kurudyi kana kuruboshwe. ");
INSERT INTO sna_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Mbongoro yakati ichiona mutumwa waJehovha, yakavata pasi paBharamu, iye akatsamwa zvikuru akairova netsvimbo yake. ");
INSERT INTO sna_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ipapo Jehovha akashamisa muromo wembongoro, ikati kuna Bharamu, “Ndaiteiko kwamuri zvaita kuti mundirove katatu kose aka?” ");
INSERT INTO sna_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bharamu akapindura mbongoro akati, “Wandiita benzi iwe! Dai ndanga ndiine munondo muruoko rwangu ndingadai ndakuuraya izvozvi.” ");
INSERT INTO sna_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Mbongoro yakati kuna Bharamu, “Ko, handisi mbongoro yenyu, yamunogara muchitasva kusvikira zuva rino here? Ko, ndinogara ndichikuitirai zvakadai here?” Iye akati, “Kwete.” ");
INSERT INTO sna_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ipapo Jehovha akasvinudza meso aBharamu, iye akaona mutumwa waJehovha amire munzira ane munondo wake wakavhomorwa. Saka akakotama akawira pasi nechiso chake. ");
INSERT INTO sna_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mutumwa waJehovha akamubvunza achiti, “Warovereiko mbongoro yako rutatu rwose urwu? Ini ndauya pano kuzokudzivisa nokuti nzira yako haina kururama kwandiri. ");
INSERT INTO sna_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mbongoro yandiona ikatsauka ichibva pandiri katatu aka kose. Dai isina kutsauka, zvirokwazvo ndingadai ndakuuraya izvozvi, asi iyo ndairaramisa.” ");
INSERT INTO sna_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bharamu akati kumutumwa waJehovha, “Ndatadza. Handina kuziva kuti manga mumire munzira kuti mundidzivise. Zvino kana musingafari, ndodzokera hangu.” ");
INSERT INTO sna_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mutumwa waJehovha akati kuna Bharamu, “Chienda hako navarume ava, asi utaure zvandinokuudza zvoga.” Saka Bharamu akaenda namachinda aBharaki. ");
INSERT INTO sna_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Bharaki akati anzwa kuti Bharamu akanga achiuya, akabuda kuti andosangana naye paguta ravaMoabhu pamuganhu weAnoni, kumagumo kwenyika yake. ");
INSERT INTO sna_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Bharaki akati kuna Bharamu, “Handina kukudana nokukurumidza here? Seiko usina kuuya kwandiri? Ini handigoni kukupa mubayiro here?” ");
INSERT INTO sna_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bharamu akapindura akati, “Zvakanaka, zvino ndauya kwauri. Asi ndingataura zvose zvose here? Ndinofanira kungotaura chete zvinenge zvaiswa mumuromo mangu naMwari.” ");
INSERT INTO sna_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ipapo Bharamu akaenda naBharaki kuKiriati Huzoti. ");
INSERT INTO sna_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Bharaki akabayira mombe namakwai, akapa zvimwe kuna Bharamu namachinda akanga anaye. ");
INSERT INTO sna_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Fume mangwana, Bharaki akatora Bharamu akakwidza naye kuBhamoti Bhaari, uye ikoko akaona chikamu chavanhu. ");
INSERT INTO sna_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bharamu akati, “Ndivakirei aritari nomwe pano, mugondigadzirira hando nomwe namakondobwe manomwe.” ");
INSERT INTO sna_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Bharaki akaita sezvakataurwa naBharamu, uye vose vari vaviri vakabayira hando negondobwe paaritari imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ipapo Bharamu akati kuna Bharaki, “Gara pano parutivi pechipiriso chako, ini ndimbotsaukira parutivi apa. Zvichida Jehovha angauya kuzosangana neni. Zvose zvaanondiratidza, ndichazokuudza.” Ipapo akabva akaenda pakakwirira, pakanga pasina chinhu. ");
INSERT INTO sna_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mwari akasangana naye, Bharamu akati, “Ndagadzira aritari nomwe uye paaritari imwe neimwe ndabayira hando negondobwe.” ");
INSERT INTO sna_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Jehovha akaisa shoko mumuromo waBharamu akati, “Dzokera kuna Bharaki utaure kwaari shoko iri.” ");
INSERT INTO sna_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Saka akadzokera kwaari akamuwana amire parutivi rwechipiriso chake, ana machinda ose eMoabhu. ");
INSERT INTO sna_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ipapo Bharamu akataura chirevo chake akati: “Bharaki akanditora kubva kuAramu, iye mambo weMoabhu kubva kumakomo okumabvazuva. Akati, ‘Uya unditukirewo Jakobho; uya, utsoropodze Israeri.’ ");
INSERT INTO sna_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ndingatuka seiko avo vasina kutukwa naMwari? Ndingatsoropodza seiko avo vasina kutsoropodzwa naJehovha? ");
INSERT INTO sna_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ndiri pamusoro pamatombo, ndinovaona, ndiri pakakwirira, ndinovaona. Ndinoona vanhu vanogara vari voga uye havazviverengi pakati pendudzi. ");
INSERT INTO sna_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ndianiko angaverenga guruva raJakobho kana kuverenga chikamu chechina chaIsraeri? Regai ndife rufu rwowakarurama, uye kuguma kwangu ngakuve sokwavo!” ");
INSERT INTO sna_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Bharaki akati kuna Bharamu, “Waiteiko kwandiri? Ndakakutora kuti uzotuka vavengi vangu, asi hauna chinhu chawaita asi kutovaropafadza!” ");
INSERT INTO sna_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Iye akapindura akati, “Ko, handifaniri kuti nditaure zvaiswa mumuromo mangu naJehovha here?” ");
INSERT INTO sna_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ipapo Bharaki akati kwaari, “Uya uende neni kune imwe nzvimbo yaunogona kuvaona; uchangoona chikamu chavo asi kwete vose. Uye uri ipapo ugonditukira vanhu ava.” ");
INSERT INTO sna_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Saka akamutora akaenda naye kumunda waZofimi pamusoro pePisiga, uye akavaka aritari nomwe ipapo akabayira hando negondobwe paaritari imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bharamu akati kuna Bharaki, “Gara pano iwe parutivi rwechipiriso chako ini ndichindosangana naye uko.” ");
INSERT INTO sna_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Jehovha akasangana naBharamu akaisa shoko mumuromo make akati, “Dzokera kuna Bharaki undotaura mashoko aya.” ");
INSERT INTO sna_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Saka akadzokera kwaari akamuwana amire parutivi rwechipiriso chake, ana machinda eMoabhu. Bharaki akamubvunza akati, “Jehovha ati kudiniko?” ");
INSERT INTO sna_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ipapo akataura chirevo chake akati: “Simuka, Bharaki, uye uteerere; ndinzwe, iwe mwanakomana waZipori. ");
INSERT INTO sna_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mwari haasi munhu, kuti angareva nhema, uye mwanakomana womunhu kuti ashandure pfungwa dzake. Ko, anotaura akasazviita here? Anovimbisa akasazadzisa here? ");
INSERT INTO sna_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ndakagamuchira murayiro wokuti ndiropafadze; iye aropafadza, uye ini handigoni kuzvishandura. ");
INSERT INTO sna_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Haana kuona chakaipa kuna Jakobho, hapana chakashata chakaonekwa muIsraeri. Jehovha Mwari wavo anavo; kudanidzira kwaMambo kuri pakati pavo. ");
INSERT INTO sna_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mwari akavabudisa muIjipiti; vane simba renyati. ");
INSERT INTO sna_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Hapana unʼanga hungarwa naJakobho, hapana kuvuka kunorwa naIsraeri. Zvino zvichanzi pamusoro paJakobho, napamusoro paIsraeri, ‘Tarirai zvaitwa naMwari!’ ");
INSERT INTO sna_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Vanhu vanosimuka seshumba hadzi; vanozvisimudza seshumba isingazorori kusvikira yadya chayauraya uye igonwa ropa rezvayabata.” ");
INSERT INTO sna_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ipapo Bharaki akati kuna Bharamu, “Usatombovatuka kana kuvaropafadza napaduku!” ");
INSERT INTO sna_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Asi Bharamu akapindura akati, “Handina kukuudza here kuti ndinofanira kuita zvose zvinotaurwa naJehovha?” ");
INSERT INTO sna_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ipapo Bharaki akati kuna Bharamu, “Uya, ndiende newe kune imwe nzvimbo. Zvimwe Mwari achafara nazvo kuti unditukire vanhu ava ikoko.” ");
INSERT INTO sna_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Saka Bharaki akatora Bharamu akakwira naye pamusoro pePeori pakatarisana nerenje. ");
INSERT INTO sna_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bharamu akati, “Ndivakire aritari nomwe pano, ugogadzira hando nomwe namakondobwe manomwe.” ");
INSERT INTO sna_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Bharaki akaita sezvakanga zvataurwa naBharamu, akabayira hando negondobwe paaritari imwe neimwe. ");
INSERT INTO sna_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Zvino Bharamu akati aona kuti zvinofadza Jehovha kuti aropafadze Israeri, haana kuzoita zvouroyi sepane dzimwe nguva, asi akaringisa chiso chake kurenje. ");
INSERT INTO sna_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bharamu akati atarisa kunze akaona vaIsraeri vagere pamusasa, rudzi norudzi, Mweya waMwari wakauya pamusoro pake ");
INSERT INTO sna_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","uye akataura chirevo chake achiti: “Chirevo chaBharamu mwanakomana waBheori, chirevo chaiye ana meso anonyatsoona, ");
INSERT INTO sna_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","chirevo chaiye anonzwa mashoko aMwari, anoona chiratidzo chinobva kuna Wamasimba Ose, anowira pasi nedumbu rake, uye ana meso akasvinura. ");
INSERT INTO sna_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Matende ako akanaka seiko, iwe Jakobho, nougaro hwako, iwe Israeri! ");
INSERT INTO sna_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Semipata, vakaita fararira, samapindu pedyo norwizi, segavakava rakasimwa naJehovha, s semisidhari pedyo nemvura. ");
INSERT INTO sna_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mvura ichayerera ichibva muzvirongo zvavo; mbeu dzavo dzichawana mvura yakawanda. “Mambo wavo achava mukuru kupinda Agagi; umambo hwavo huchasimudzirwa. ");
INSERT INTO sna_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Mwari akavabudisa muIjipiti; vane simba renyati. Vanomedza ndudzi dzine hasha uye vanovhuna-vhuna mapfupa adzo; Vanovabaya nemiseve yavo. ");
INSERT INTO sna_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Seshumba vanoti vhumba vagovata pasi, seshumbakadzi, ndianiko angashinga kuvamutsa? “Vose vanokuropafadza, ngavaropafadzwe uye vose vanokutuka, ngavatukwe!” ");
INSERT INTO sna_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ipapo kutsamwa kwaBharaki kwakapfuta pamusoro paBharamu. Akarova maoko ake pamwe chete akati kwaari, “Ndakakudanira kuzotuka vavengi vangu, asi wavaropafadza katatu kose aka. ");
INSERT INTO sna_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Zvino chibva izvozvi uende kwako! Ndakati ndichakupa mubayiro wakaisvonaka, asi Jehovha akudzivisa kuti upiwe mubayiro.” ");
INSERT INTO sna_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bharamu akapindura Bharaki akati, “Ko, handina kutaurira nhume dzawakatuma kwandiri here kuti, ");
INSERT INTO sna_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Kunyange dai Bharaki andipa muzinda wake wakazara nesirivha negoridhe, handaigona kuita chinhu nokuda kwangu, chakanaka kana chakaipa, kuti ndidarike murayiro waJehovha, uye kuti ndinofanira kutaura chete zvinenge zvataurwa naJehovha here’? ");
INSERT INTO sna_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Zvino ndava kudzokera kuvanhu vokwangu, asi uya ndikuyambire zvichaitirwa vanhu vako navanhu ava pamazuva anouya.” ");
INSERT INTO sna_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ipapo akataura chirevo chake akati: “Chirevo chaBharamu mwanakomana waBheori, chirevo chaiye anoona zvakajeka, ");
INSERT INTO sna_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","chirevo chaiye anonzwa mashoko aMwari, ano ruzivo runobva kuno Wokumusoro-soro, anoona chiratidzo chinobva kuna Wamasimba Ose, anowira pasi nedumbu rake, uye ana meso akasvinura: ");
INSERT INTO sna_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Ndiri kumuoona, asi kwete iye zvino; ndinomuona, asi haasi pedyo. Nyeredzi ichabuda muna Jakobho; Tsvimbo youshe ichamera kubva muna Israeri. Achapwanya huma dzavaMoabhu, madehenya avanakomana vose vaSeti. ");
INSERT INTO sna_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edhomu achakundwa; Seiri, muvengi wake, achakundwa, asi Israeri achasimba. ");
INSERT INTO sna_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mutongi achabuda muna Jakobho uye achaparadza vakasara veguta.” ");
INSERT INTO sna_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ipapo Bharamu akaona Amareki uye akataura chirevo chake achiti: “Amareki akanga ari wokutanga pakati pendudzi, asi pakupedzisira achaparadzwa.” ");
INSERT INTO sna_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ipapo akaona vaKeni uye akataura chirevo chake achiti: “Ugaro hwako hwakachengetedzeka, dendere rako rakavakwa padombo; ");
INSERT INTO sna_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","asi imi vaKeni muchaparadzwa, Ashuri paachakutapai.” ");
INSERT INTO sna_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ipapo akataura chirevo chake akati: “Haiwa, ndianiko angararama kana Mwari akaita izvi? ");
INSERT INTO sna_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Zvikepe zvichauya zvichibva kumahombekombe eKitimu; zvichakunda Ashuri neEbheri, asi naizvowo zvichaparadzwa.” ");
INSERT INTO sna_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ipapo Bharamu akasimuka akadzokera kunyika yake, uye Bharaki akaenda kwakewo. ");
INSERT INTO sna_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Panguva yakanga igere Israeri paShitimu, varume vakatanga kuita upombwe navakadzi vokuMoabhu, ");
INSERT INTO sna_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","avo vakavakoka kuti vauye kuzvibayiro zvavamwari vavo. Vanhu vakadya, vakapfugamira vamwari ava. ");
INSERT INTO sna_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Saka Israeri akabatana navo pakunamata Bhaari wePeori, uye kutsamwa kwaJehovha kukapfuta pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Jehovha akati kuna Mozisi, “Tora vatungamiri vose vavanhu ava, uvauraye uvaise pachena masikati machena pamberi paJehovha, kuti kutsamwa kunotyisa kwaJehovha kudzorwe kubva pana Israeri.” ");
INSERT INTO sna_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Saka Mozisi akati kuvatongi veIsraeri, “Mumwe nomumwe wenyu anofanira kuuraya varume ava vari pakati penyu, avo vakazvibatanidza pakunamata Bhaari wePeori.” ");
INSERT INTO sna_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ipapo mumwe murume muIsraeri akauyisa kumhuri yake mukadzi womuMidhiani pamberi paMozisi chaipo, ungano yose yaIsraeri pavakanga vachichema vari pamukova weTende Rokusangana. ");
INSERT INTO sna_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwanakomana waEreazari, mwanakomana waAroni, muprista, akati achizviona, akabva paungano, akatora pfumo muruoko rwake; ");
INSERT INTO sna_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","uye akatevera muIsraeri uyo mutende. Akavabaya vose vari vaviri nepfumo kamwe chete, rikabaya muIsraeri rikapfuurira kundobaya muviri womuMidhiani. Ipapo denda rakanga riri pamusoro pavaIsraeri rakaguma; ");
INSERT INTO sna_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","asi vose vakanga vafa nedenda vakasvika zviuru makumi maviri nezvina. ");
INSERT INTO sna_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwanakomana waEreazari, mwanakomana waAroni, muprista adzora kutsamwa kwangu kubva pavaIsraeri; nokuti akanga ane shungu sedzangu nokuda kwokusakudzwa kwangu pakati pavo, saka handina kuzovaparadza neshungu dzangu. ");
INSERT INTO sna_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Naizvozvo umuudze kuti ndava kuita sungano yorugare naye. ");
INSERT INTO sna_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Iye nezvizvarwa zvake vachava nesungano youprista husingaperi, nokuti akanga ane shungu nokukudzwa kwaMwari wake, akayananisira vaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Zita romuIsraeri akaurayiwa pamwe chete nomukadzi muMidhiani rainzi Zimuri mwanakomana waSaru, mutungamiri weimwe mhuri yaSimeoni. ");
INSERT INTO sna_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Uye zita romukadzi muMidhiani akaurayiwa rakanga richinzi Kozibhi, mwanasikana waZuri, mukuru weimwe mhuri yavaMidhiani. ");
INSERT INTO sna_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Muone vaMidhiani savavengi uye mugovauraya, ");
INSERT INTO sna_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","nokuti ivo vakakuonai savavengi pavakakunyengerai paPeori uye nehanzvadzi yavo Kozibhi, mwanasikana womutungamiri wavaMidhiani, iye mukadzi akaurayiwa pakauya denda nokuda kwePeori.” ");
INSERT INTO sna_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Shure kwedenda Jehovha akati kuna Mozisi naEreazari mwanakomana waAroni, muprista, ");
INSERT INTO sna_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Verengai ungano yose yavaIsraeri nemhuri dzavo, vose vana makore makumi maviri kana anodarika vanogona kurwa muhondo yaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Saka Mozisi naEreazari muprista vakataura navo pamapani eMoabhu paJorodhani nechokumhiri kweJeriko vakati, ");
INSERT INTO sna_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Verengai varume vana makore makumi maviri kana anodarika, sezvakarayirwa Mozisi naJehovha.” Ava ndivo vaIsraeri vakabuda kubva muIjipiti: ");
INSERT INTO sna_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Zvizvarwa zvaRubheni mwanakomana wedangwe waIsraeri zvaiva: Hanoki, kwakabva mhuri yaHanoki; Paru, kwakabva mhuri yaParu; ");
INSERT INTO sna_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezironi, kwakabva mhuri yaHezironi; Kami, kwakabva mhuri yaKami. ");
INSERT INTO sna_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Idzi ndidzo dzakanga dziri mhuri dzaRubheni; vakaverengwa vakanga vari zviuru makumi mana nezvitatu, namazana manomwe ana makumi matatu. ");
INSERT INTO sna_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwanakomana waParu akanga ari Eriabhi, ");
INSERT INTO sna_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","uye vanakomana vaEriabhi vakanga vari Nemueri, Dhatani naAbhiramu. Dhatani naAbhiramu ndivo vatungamiri veungano vaya vakamukira Mozisi naAroni uye vakanga vari pakati pavateveri vaKora pavakamukira Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nyika yakashamisa muromo wayo ikavamedza pamwe chete naKora, boka iroro parakafa, moto pawakaparadza varume mazana maviri namakumi mashanu. Uye ivo vakava chiratidzo cheyambiro. ");
INSERT INTO sna_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kunyange zvakadaro, rudzi rwaKora haruna kuparara. ");
INSERT INTO sna_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Zvizvarwa zvaSimeoni nemhuri dzavo zvaiva: Nemueri kwakabva mhuri yavaNemueri; Jamini, kwakabva mhuri yavaJamini; Jakini, kwakabva mhuri yavaJakini; ");
INSERT INTO sna_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, kwakabva mhuri yavaZera; Shauri kwakabva mhuri yavaShauri. ");
INSERT INTO sna_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Idzi ndidzo dzakanga dziri mhuri dzaSimeoni; pakanga pane varume zviuru makumi maviri nezviviri namazana maviri. ");
INSERT INTO sna_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Zvizvarwa zvaGadhi nemhuri dzavo zvaiva: Zofani, kwakabva mhuri yavaZofani; Hagi, kwakabva mhuri yavaHagi; Shumi, kwakabva mhuri yavaShumi; ");
INSERT INTO sna_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozini, kwakabva mhuri yavaOzini; Eri, kwakabva mhuri yavaEri; ");
INSERT INTO sna_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodhi, kwakabva mhuri yavaArodhi; Areri kwakabva mhuri yavaAreri. ");
INSERT INTO sna_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Idzi ndidzo dzakanga dziri mhuri dzaGadhi; vakaverengwa vakanga vari zviuru makumi mana, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri naOnani vakanga vari vanakomana vaJudha, asi vakafira muKenani. ");
INSERT INTO sna_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Zvizvarwa zvaJudha nemhuri dzavo zvaiva: Shera, kwakabva mhuri yavaSherani; Perezi, kwakabva mhuri yavaPerezi; Zera, kwakabva mhuri yavaZera; ");
INSERT INTO sna_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Zvizvarwa zvaPerezi zvaiva: Hezironi, kwakabva mhuri yavaHezironi; Hamuri, kwakabva mhuri yavaHamuri. ");
INSERT INTO sna_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Idzi ndidzo dzakanga dziri mhuri dzaJudha; vakaverengwa vakanga vari zviuru makumi manomwe nezvitanhatu, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Zvizvarwa zvaIsakari nemhuri dzavo zvaiva: Tora, kwakabva mhuri yavaTora; Pua kwakabva mhuri yavaPua; ");
INSERT INTO sna_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashubhi kwakabva mhuri yavaJashubhi; Shimironi kwakabva mhuri yavaShimironi. ");
INSERT INTO sna_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Idzi ndidzo dzakanga dziri mhuri dzaIsakari; vakaverengwa vakanga vari zviuru makumi matanhatu nezvina, namazana matatu. ");
INSERT INTO sna_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zvizvarwa zvaZebhuruni nemhuri dzavo zvaiva: Seredhi, kwakabva mhuri yavaSeredhi; Eroni, kwakabva mhuri yavaEroni; Jareeri, kwakabva mhuri yavaJareeri. ");
INSERT INTO sna_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Idzi ndidzo dzakanga dziri mhuri dzaZebhuruni; vakaverengwa vakanga vari zviuru makumi matanhatu, namazana mashanu. ");
INSERT INTO sna_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Zvizvarwa zvaJosefa nemhuri dzavo kubudikidza naManase naEfuremu zvakanga zvakadai: ");
INSERT INTO sna_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Zvizvarwa zvaManase: Makiri kwakabva mhuri yavaMakiri (Makiri akanga ari baba vaGireadhi); Gireadhi kwakabva mhuri yavaGireadhi. ");
INSERT INTO sna_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Izvi ndizvo zvaiva zvizvarwa zvaGireadhi: Iezeri, kwakabva mhuri yaIezeri; Hereki, kwakabva mhuri yavaHereki; ");
INSERT INTO sna_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asirieri, kwakabva mhuri yavaAsirieri; Shekemu, kwakabva mhuri yavaShekemu; ");
INSERT INTO sna_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemidha, kwakabva mhuri yavaShemidha; Heferi, kwakabva mhuri yavaHeferi. ");
INSERT INTO sna_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zerofehadhi mwanakomana waHeferi akanga asina vanakomana; akanga achingova navanasikana bedzi, mazita avo aiva: Mara, Noa, Hogira, Mirika naTiriza.) ");
INSERT INTO sna_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Idzi ndidzo dzakanga dziri mhuri dzaManase; vakaverengwa vakanga vari zviuru makumi mashanu nezviviri, namazana manomwe. ");
INSERT INTO sna_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Izvi ndizvo zvaiva zvizvarwa zvaEfuremu nemhuri dzavo: Shutera, kwakabva mhuri yaShutera; Bhekeri, kwakabva mhuri yaBhekeri; Tahani, kwakabva mhuri yaTahani. ");
INSERT INTO sna_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Izvi ndizvo zvaiva zvizvarwa zvaShutera: Erani, kwakabva mhuri yaErani. ");
INSERT INTO sna_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Idzi ndidzo dzakanga dziri mhuri dzaEfuremu; vakaverengwa vakanga vari zviuru makumi matatu nezviviri, namazana mashanu. Izvi ndizvo zvaiva zvizvarwa zvaJosefa nemhuri dzavo. ");
INSERT INTO sna_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Zvizvarwa zvaBhenjamini nemhuri dzavo zvaiva: Bhera, kwakabva mhuri yavaBhera; Ashibheri, kwakabva mhuri yavaAshibheri; Ahiramu, kwakabva mhuri yaAhiramu; ");
INSERT INTO sna_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shufami, kwakabva mhuri yavaShufami; Hufami, kwakabva mhuri yavaHufami. ");
INSERT INTO sna_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Zvizvarwa zvaBhera kubudikidza naAradhi naNaamani zvaiva: Aradhi, kwakabva mhuri yavaAradhi; Naamani, kwakabva mhuri yavaNaamani. ");
INSERT INTO sna_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Idzi ndidzo dzakanga dziri mhuri dzaBhenjamini; vakaverengwa vakanga vari zviuru makumi mana nezvishanu, namazana matanhatu. ");
INSERT INTO sna_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Izvi ndizvo zvaiva zvizvarwa zvaDhani nemhuri dzavo: Shuhami, kwakabva mhuri yavaShuhami. Idzi ndidzo dzaiva mhuri dzaDhani: ");
INSERT INTO sna_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Vose vakanga vari vemhuri yaShuhami; uye vakaverengwa vakanga vari zviuru makumi matanhatu nezvina, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Zvizvarwa zvaAsheri nemhuri dzavo zvaiva: Imina, kwakabva mhuri yavaImina; Ishivhi, kwakabva mhuri yavaIshivhi; Bheria, kwakabva mhuri yavaBheria; ");
INSERT INTO sna_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","uye kubudikidza nezvizvarwa zvavaBheria: Hebheri, kwakabva mhuri yavaHebheri; Marikieri, kwakabva mhuri yavaMarikieri. ");
INSERT INTO sna_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheri akanga ane mwanasikana ainzi Sera. ");
INSERT INTO sna_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Idzi ndidzo dzakanga dziri mhuri dzaAsheri; vakaverengwa vakanga vari zviuru makumi mashanu nezvitatu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Zvizvarwa zvaNafutari nemhuri dzavo zvaiva: Jazeeri, kwakabva mhuri yavaJazeeri; Guni, kwakabva mhuri yavaGuni; ");
INSERT INTO sna_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezeri, kwakabva mhuri yavaJezeri; Shiremi, kwakabva mhuri yavaShiremi. ");
INSERT INTO sna_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Idzi ndidzo dzakanga dziri mhuri dzaNafutari; vakaverengwa vakanga vari zviuru makumi mana nezvishanu, namazana mana. ");
INSERT INTO sna_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Uwandu hwavarume veIsraeri hwaisvika zviuru mazana matanhatu nechimwe, namazana manomwe ana makumi matatu. ");
INSERT INTO sna_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Nyika inofanira kugoverwa kwavari senhaka zvichienderana namazita akaverengwa. ");
INSERT INTO sna_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kuna vaya vanenge vakawanda, unofanira kuvapa nhaka huru, vashoma unovapa nhaka duku; mhuri imwe neimwe inofanira kupiwa zvakaenzana nouwandu hwokuverengwa kwavo. ");
INSERT INTO sna_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Unofanira kuona kuti nyika yagoverwa nemijenya. Nhaka ichagoverwa mhuri imwe neimwe ichange iri maererano namazita orudzi rwamadzitateguru avo. ");
INSERT INTO sna_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Nhaka imwe neimwe inofanira kugoverwa nemijenya pakati pemhuri huru nemhuri duku.” ");
INSERT INTO sna_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ava ndivo vaRevhi vakaverengwa nemhuri dzavo: Gerishoni, kwakabva mhuri yavaGerishoni; Kohati, kwakabva mhuri yavaKohati; Merari, kwakabva mhuri yavaMerari. ");
INSERT INTO sna_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ava ndivo vakanga vari mhuri dzaRevhi: mhuri yavaRibhini, mhuri yavaHebhuroni, mhuri yavaMari, mhuri yavaMushi, mhuri yavaKora. (Kohati akanga ari baba vaAmurami; ");
INSERT INTO sna_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","zita romukadzi waAmurami rainzi Jokebhedhi, chizvarwa chaRevhi, akaberekwa kuvaRevhi muIjipiti. Akaberekera Amurami Aroni, Mozisi nehanzvadzi yake Miriamu. ");
INSERT INTO sna_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aroni ndiye akanga ari baba vaNadhabhi naAbhihu, Ereazari naItamari. ");
INSERT INTO sna_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Asi Nadhabhi naAbhihu vakafa pavakaita chipiriso nomoto usina kufanira pamberi paJehovha.) ");
INSERT INTO sna_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Varume vose pakati pavaRevhi, vaiva nomwedzi mumwe chete kana kupfuura pakuberekwa vaisvika zviuru makumi maviri nezvitatu. Havana kuverengwa pamwe chete navamwe vaIsraeri nokuti havana kupiwa nhaka pakati pavo. ");
INSERT INTO sna_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ava ndivo vakaverengwa naMozisi naEreazari muprista pavakaverenga vaIsraeri pamapani eMoabhu paJorodhani uchibva mhiri kuJeriko. ");
INSERT INTO sna_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Hapana kana mumwe wavo akanga ari pakati pavaya vakaverengwa naMozisi naAroni muprista, pavakaverenga vaIsraeri murenje reSinai. ");
INSERT INTO sna_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Nokuti Jehovha akanga audza vaIsraeri avo kuti zvirokwazvo vaizofira murenje, uye hakuna kana mumwe wavo akasara kunze kwaKarebhu mwanakomana waJefune naJoshua mwanakomana waNuni. ");
INSERT INTO sna_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Vanasikana vaZerofehadhi, mwanakomana waHeferi, mwanakomana waGireadhi, mwanakomana waMakiri, mwanakomana waManase, vakanga vari vemhuri dzaManase mwanakomana waJosefa. Mazita avanasikana akanga ari: Mara, Noa, Hogira, Mirika naTiza. ");
INSERT INTO sna_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Vakasvika pamukova weTende Rokusangana vakamira pamberi paMozisi, naEreazari muprista, vatungamiri, neungano yose, vakati, ");
INSERT INTO sna_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baba vedu vakafira murenje. Vakanga vasiri pakati pavateveri vaKora, avo vakabatana pamwe chete kuti vamukire Jehovha, asi vakafira chivi chavowo vakasasiya vanakomana. ");
INSERT INTO sna_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ko, zita rababa vedu ragoshayikwa seiko pamhuri yavo, nokuti vakanga vasina mwanakomana here? Tipeiwo nhaka pakati pehama dzababa vedu.” ");
INSERT INTO sna_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Saka Mozisi akasvitsa nyaya yavo pamberi paJehovha ");
INSERT INTO sna_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Uye Jehovha akati kwaari, ");
INSERT INTO sna_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zvinorehwa navanasikana vaZerofehadhi ndezvechokwadi. Zvirokwazvo unofanira kuvapa nhaka pakati pehama dzababa vavo ugodzorera nhaka yababa vavo kwavari. ");
INSERT INTO sna_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Uti kuvaIsraeri, ‘Kana murume akafa akasasiya mwanakomana, munofanira kudzorera nhaka yake kumwanasikana wake. ");
INSERT INTO sna_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kana asina mwanasikana, mupe nhaka yake kumadzikoma ake kana vanunʼuna vake. ");
INSERT INTO sna_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kana asina madzikoma kana vanunʼuna, mupe nhaka yake kuvanunʼuna kana madzikoma ababa vake. ");
INSERT INTO sna_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kana baba vake vasina madzikoma kana vanunʼuna, mupe nhaka yake kuhama yepedyo yomumhuri yake, kuti ive yake. Uyu unofanira kuva mutemo kuvaIsraeri, sezvakarayirwa Mozisi naJehovha.’ ” ");
INSERT INTO sna_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ipapo Jehovha akati kuna Mozisi, “Kwira pamusoro pegomo iri romuAbharimi ugoona nyika yandakapa vaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Mushure mokunge waona, newewo uchasanganiswa navanhu vokwako, sezvakaita Aroni mukoma wako, ");
INSERT INTO sna_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","nokuti ungano payakandimukira pamvura yomuRenje reZini, mose muri vaviri hamuna kuteerera murayiro wangu kuti mundiremekedze somutsvene pamberi pavo.” (Iyi ndiyo mvura yapaMeribha Kadheshi, muRenje reZini.) ");
INSERT INTO sna_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mozisi akati kuna Jehovha, ");
INSERT INTO sna_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Jehovha, Mwari wemweya yamarudzi ose avanhu, ngaagadze murume pamusoro peungano iyi ");
INSERT INTO sna_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","kuti abude nokupinda pamberi pavo, uyo achavabudisa nokuvapinza, kuti vanhu vaJehovha varege kuva samakwai asina mufudzi.” ");
INSERT INTO sna_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Saka Jehovha akati kuna Mozisi, “Tora Joshua mwanakomana waNuni, murume ano mweya maari, ugoisa ruoko rwako pamusoro pake. ");
INSERT INTO sna_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Unofanira kumumisa pamberi paEreazari muprista napamberi peungano yose ugomurayira pamberi pavo. ");
INSERT INTO sna_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umupe rimwe simba rako kuti ungano yose yavaIsraeri igomuteerera. ");
INSERT INTO sna_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Anofanira kumira pamberi paEreazari muprista, uyo achamubvunzira pamberi paJehovha nokutonga kweUrimi. Pakurayira kwake, vanofanira kubuda iye neungano yose yavaIsraeri uye pakurayira kwake ivo vachapinda.” ");
INSERT INTO sna_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mozisi akaita sezvaakarayirwa naJehovha. Akatora Joshua akamumisa pamberi paEreazari muprista napamberi peungano yose. ");
INSERT INTO sna_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ipapo akaisa maoko ake pamusoro pake akamurayira, sezvakanga zvarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Upe murayiro uyu kuvaIsraeri, uti kwavari, ‘Onai kuti maisa pamberi pangu panguva yakatarwa, zvokudya zvangu zvezvipiriso zvinoitwa nomoto, sezvinonhuhwira zvinondifadza.’ ");
INSERT INTO sna_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Uti kwavari: ‘Ichi ndicho chipiriso chakaitwa nomoto chamunofanira kupa kuna Jehovha: makwayana maviri egore rimwe chete asina kuremara, sechipiriso chinopiswa chamazuva ose, zuva rimwe nerimwe. ");
INSERT INTO sna_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ugadzire gwayana rimwe chete mangwanani uye rimwe racho panguva yamadekwana, ");
INSERT INTO sna_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","pamwe chete nechipiriso chezviyo, chegumi cheefa youpfu hwakatsetseka hwakavhenganiswa nechikamu chimwe chete muzvina chehini yamafuta omuorivhi akasvinwa. ");
INSERT INTO sna_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ichi ndicho chipiriso chinopiswa chamazuva ose chakatarwa paGomo reSinai kuti chive munhuwi unonhuhwira zvinofadza, chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Panobayirwa gwayana rimwe nerimwe, chipiriso chokunwa chinopiwa panguva imwe cheteyo chinofanira kuva chikamu chimwe chete muzvina chehini, chezvinonhuhwira zvakaviriswa. Udurure chipiriso chinonwiwa kuna Jehovha panzvimbo tsvene. ");
INSERT INTO sna_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ugadzire gwayana rechipiri panguva dzamadekwana, pamwe chete nechipiriso chezviyo nechipiriso chinonwiwa, zvakafanana nezvamangwanani. Ichi ndicho chipiriso chinoitwa nomoto, chinonhuhwira zvinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Nomusi weSabata, muite chipiriso chamakwayana maviri egore rimwe chete asina kuremara, pamwe chete nechipiriso chacho chokunwa, uye nechipiriso chezviyo chezvegumi zviviri zveefa youpfu hwakatsetseka, hwakavhenganiswa namafuta. ");
INSERT INTO sna_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ichi ndicho chipiriso chinopiswa cheSabata rimwe nerimwe, pamusoro pechipiriso chinopiswa chamazuva ose uye nechipiriso chacho chinonwiwa. ");
INSERT INTO sna_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Nomusi wokutanga womwedzi woga woga, mupe kuna Jehovha chipiriso chehando duku mbiri, gondobwe rimwe chete namakwayana makono manomwe egore rimwe chete, ose asina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Pamwe chete nehando imwe neimwe, panofanira kuva nechipiriso chezviyo chezvegumi zviviri zveefa yeupfu hwakatsetseka, hwakavhenganiswa namafuta; ");
INSERT INTO sna_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","uye negwayana rimwe nerimwe, chipiriso chezviyo chechegumi cheefa yeupfu hwakatsetseka, hwakavhenganiswa namafuta. Izvi ndizvo zvinoitwa pachipiriso chinopiswa, chinonhuhwira zvinofadza, chipiriso chinoitirwa Jehovha nomoto. ");
INSERT INTO sna_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Pamwe chete nehando imwe neimwe, panofanira kuva nechipiriso chokunwa chehafu yehini yewaini; pamwe chete negondobwe, chikamu chimwe chete kubva muzvitatu chehini; uye pamwe chete negwayana rimwe nerimwe, chikamu chimwe chete muzvina chehini. Ichi ndicho chipiriso chinopiswa chomwedzi mumwe nomumwe chinofanira kupiwa pakugara kwomwedzi mumwe nomumwe pagore. ");
INSERT INTO sna_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Pamusoro pechipiriso chinopiswa chamazuva ose nechipiriso chacho chokunwa, nhongo imwe chete inofanira kupiwa sechipiriso chechivi kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Pazuva regumi namana romwedzi wokutanga munofanira kuita Pasika yaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Pazuva regumi namana romwedzi uyu, munofanira kuita mutambo; kwamazuva manomwe munofanira kudya chingwa chisina mbiriso. ");
INSERT INTO sna_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Pazuva rokutanga munofanira kuita ungano tsvene uye murege kuita mabasa amazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mupe kuna Jehovha chipiriso chakaitwa nomoto, chipiriso chinopiswa chehando duku mbiri, gondobwe rimwe chete uye makwayana makono manomwe ane gore rimwe chete, ose asina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pamwe chete nehando imwe neimwe mugadzire chipiriso chezviyo, chezvikamu zvitatu mugumi zveefa yeupfu hwakatsetseka, hwakavhenganiswa namafuta; pamwe chete negondobwe, zvikamu zviviri mugumi; ");
INSERT INTO sna_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","uye pamwe chete nerimwe nerimwe ramakwayana manomwe, chikamu chimwe chete mugumi; ");
INSERT INTO sna_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","uisewo nhongo imwe chete yembudzi sechipiriso chechivi kuti iwe uzviyananisire. ");
INSERT INTO sna_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mugadzire izvi pamwe chete nezvipiriso zvinopiswa zvamangwanani zvamazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Nenzira iyi mugadzire zvokudya zvezvipiriso zvinoitwa nomoto mazuva ose kwamazuva manomwe sezvinonhuhwira zvinofadza kuna Jehovha; zvinofanira kugadzirwa pamwe chete nezvipiriso zvinopiswa nechipiriso chacho chinonwiwa. ");
INSERT INTO sna_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Pazuva rechinomwe muite ungano tsvene uye murege kuita basa ramazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Pazuva rezvibereko zvokutanga, pamunopa zvipiriso zvenyu kuna Jehovha, zvezvitsva zvezviyo panguva yoMutambo weMavhiki, muite ungano tsvene uye murege kuita basa ramazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mupe chipiriso chinopiswa chehando duku mbiri, gondobwe rimwe chete uye makwayana manomwe makono egore rimwe chete, chive chipiriso chinofadza kuna Jehovha. ");
INSERT INTO sna_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pamwe chete nehando imwe neimwe, panofanira kuva nechipiriso chezviyo chezvikamu zvitatu mugumi zveefa yeupfu hwakatsetseka hwakavhenganiswa namafuta; pamwe chete negondobwe, zvikamu zviviri mugumi; ");
INSERT INTO sna_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","uye nerimwe nerimwe ramakwayana manomwe, chikamu chimwe chete mugumi. ");
INSERT INTO sna_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Muisewo nhongo imwe chete kuti muzviyananisire. ");
INSERT INTO sna_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Mugadzire izvi pamwe chete nezvipiriso zvazvo zvokunwa, pamusoro pezvipiriso zvinopiswa zvamazuva ose uye nechipiriso chacho chezviyo. Munofanira kuva nechokwadi kuti zvipfuwo zvacho hazvina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Pazuva rokutanga romwedzi wechinomwe, muite ungano tsvene uye murege kubata basa ramazuva ose. Izuva rokuti muridze hwamanda. ");
INSERT INTO sna_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Munofanira kugadzirira Jehovha chipiriso chinopiswa chehando imwe chete duku, gondobwe rimwe chete uye makwayana makono manomwe egore rimwe chete, ose asina kuremara, zvive zvinonhuhwira zvinofadza pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Mugadzire pamwe chete nehando duku chipiriso chezviyo chezvikamu zvitatu mugumi zveefa yeupfu hwakatsetseka hwakavhenganiswa pamwe chete namafuta, negondobwe, zvikamu zviviri mugumi; ");
INSERT INTO sna_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","pamwe chete nerimwe nerimwe ramakwayana manomwe, chikamu chimwe chete mugumi. ");
INSERT INTO sna_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Muisewo nhongo imwe chete yembudzi sechipiriso chechivi kuti muzviyananisire. ");
INSERT INTO sna_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Izvi zviri kupamhidzirwa pamusoro pezvipiriso zvinopiswa zvomwedzi nomwedzi, nezvezuva nezuva uye nezvipiriso zvezviyo nezvipiriso zvokunwa sokurongwa kwazvo. Ndizvo zvipiriso zvinoitirwa Jehovha nomoto, zvinonhuhwira zvinofadza. ");
INSERT INTO sna_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Pazuva regumi romwedzi wechinomwe munofanira kuita ungano tsvene. Munofanira kuzviramba uye murege kubata basa. ");
INSERT INTO sna_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mupe chibayiro chinopiswa chehando duku yegore rimwe chete kuna Jehovha sezvinonhuhwira zvinofadza: hando imwe chete negondobwe rimwe chete uye namakwayana makono manomwe egore rimwe chete, zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Mugadzire pamwe chete nehando, chipiriso chezviyo chezvikamu zvitatu mugumi zveefa youpfu hwakatsetseka, hwakavhenganiswa namafuta; pamwe chete negondobwe, zvikamu zviviri mugumi; ");
INSERT INTO sna_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","uye parimwe nerimwe ramakwayana manomwe, chikamu chimwe chete mugumi. ");
INSERT INTO sna_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Muisewo nhongo yembudzi sechipiriso chechivi, muchipamhidzira kuchipiriso chechivi chokuyananisira uye nechibayiro chinopiswa chamazuva ose nechipiriso chacho chezviyo, uye nezvipiriso zvazvo zvokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Pazuva regumi namashanu romwedzi wechinomwe, muite ungano tsvene uye musaita basa ramazuva ose. Muite mutambo wokupemberera Jehovha kwamazuva manomwe. ");
INSERT INTO sna_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Muuye nechibayiro chinopiswa kuti chive chinonhuhwira zvinofadza kuna Jehovha, chibayiro chinopiswa chehando duku gumi nenhatu, makondobwe maviri namakwayana makono gumi namana egore rimwe chete, ose asina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Mugadzire chipiriso chezvikamu zvitatu mugumi zveefa youpfu hwakatsetseka, hwakavhenganiswa namafuta pamwe chete neimwe neimwe yehando duku gumi nenhatu; pamwe chete nerimwe nerimwe ramakondobwe maviri, zvikamu zviviri mugumi, ");
INSERT INTO sna_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","uye pamwe chete nerimwe nerimwe ramakwayana gumi namana, chikamu chimwe chete mugumi. ");
INSERT INTO sna_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, pamusoro pechipiriso chinopiswa nechipiriso chacho chezviyo nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Pazuva rechipiri mugadzire hando duku gumi nembiri, makondobwe maviri uye makwayana makono gumi namana egore rimwe, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Mugadzire nehando, namakondobwe uye namakwayana, zvipiriso zvezviyo nezvipiriso zvinonwiwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, muchipamhidzira kuchipiriso chamazuva ose pamwe chete nechipiriso chacho uye nezvipiriso zvazvo zvokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Pazuva rechitatu, mugadzire hando gumi neimwe, makondobwe maviri uye namakwayana makono gumi namana egore rimwe chete, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Mugadzire pamwe chete nehando, makondobwe, uye namakwayana, zvipiriso zvazvo zvezviyo nezvipiriso zvokunwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, muchipamhidzira kuchipiriso chinopiswa chamazuva ose pamwe chete nechipiriso chacho chezviyo uye nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Pazuva rechina, mugadzire hando gumi, makondobwe uye makwayana gumi namana egore rimwe chete, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Pamwe chete nehando, namakondobwe, namakwayana, mugadzire zvipiriso zvazvo nezvipiriso zvokunwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, muchipamhidzira kuchipiriso chinopiswa chamazuva ose nechipiriso chacho chezviyo, uye nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Pazuva rechishanu, mugadzire hando pfumbamwe, makondobwe maviri uye namakwayana makono gumi namana egore rimwe chete, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Pamwe chete nehando, makondobwe namakwayana, mugadzire zvipiriso zvazvo zvezviyo nezvipiriso zvokunwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi muchipamhidzira kuchipiriso chinopiswa chamazuva ose nechipiriso chacho chezviyo uye nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Pazuva rechitanhatu, mugadzire hando sere, makondobwe maviri uye makwayana makono egore rimwe chete, gumi namana, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Pamwe chete nehando, namakondobwe uye namakwayana mugadzire zvipiriso zvazvo zvezviyo nezvipiriso zvokunwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, muchipamhidzira kuchipiriso chinopiswa chamazuva ose pamwe chete nechipiriso chacho chezviyo uye nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Pazuva rechinomwe, mugadzire hando nomwe, makondobwe maviri uye makwayana makono gumi namana egore rimwe chete, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Pamwe chete nehando, makondobwe namakwayana mugadzire zvipiriso zvazvo zvezviyo nezvipiriso zvokunwa maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Muisewo nhongo yembudzi imwe chete sechipiriso chechivi, muchipamhidzira kuchipiriso chinopiswa chamazuva ose pamwe chete nechipiriso chacho chezviyo uye chipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Pazuva rorusere, unganai uye murege kuita basa ramazuva ose. ");
INSERT INTO sna_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mupe chibayiro chinopiswa nomoto chive chinonhuhwira zvinofadza kuna Jehovha, chibayiro chinopiswa chehando imwe chete, gondobwe rimwe chete namakwayana makono manomwe egore rimwe chete, zvose zvisina kuremara. ");
INSERT INTO sna_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Mugadzire hando, gondobwe namakwayana, zvipiriso zvezviyo nezvipiriso zvinonwiwa, maererano nouwandu hwakarayirwa. ");
INSERT INTO sna_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Muisewo nhongo imwe chete yembudzi sechipiriso chechivi, muchipamhidzira kuchipiriso chinopiswa chamazuva ose pamwe chete nechipiriso chacho chezviyo uye nechipiriso chokunwa. ");
INSERT INTO sna_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Kupamhidzira pamusoro pezvamakapika uye zvipo zvokupa nokuzvisarudzira, mugadzirire Jehovha izvi pamitambo yenyu yakatarwa: zvipiriso zvenyu zvinopiswa, zvipiriso zvezviyo, zvipiriso zvokunwa uye nezvipiriso zvokuwadzana.’ ” ");
INSERT INTO sna_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mozisi akataurira vaIsraeri zvose zvaakarayirwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mozisi akati kuvakuru vamarudzi avaIsraeri, “Izvi ndizvo zvarayirwa naJehovha: ");
INSERT INTO sna_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Kana munhu akaita mhiko kuna Jehovha kana kuzvisunga nokupika, haafaniri kuputsa shoko rake asi anofanira kuita zvose zvaakareva. ");
INSERT INTO sna_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Kana musikana achiri kugara mumba mababa vake akaita mhiko kuna Jehovha kana kuti akazvisunga nokupika, ");
INSERT INTO sna_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","uye baba vake vakanzwa pamusoro pezvaapika, vakasataura chinhu kwaari, ipapo zvose zvaapika uye nezvose zvaazvisunga kupika zvichasimbiswa. ");
INSERT INTO sna_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Asi kana baba vake vakamudzivisa pavanonzwa nezvazvo, zvaapika zvose nezvaazvisunga nazvo achipika hazvingavi nesimba; Jehovha achamusunungura nokuti baba vake vamudzivisa. ");
INSERT INTO sna_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Kana akawanikwa mushure mokunge aita mhiko, kana mushure mokunge muromo wake wakurumidza kutaura achivimbisa nokuzvisunga, ");
INSERT INTO sna_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","uye murume wake akazvinzwa asi akasataura chinhu kwaari, ipapo mhiko dzake kana zvaakazvisunga nazvo zvichasimbiswa. ");
INSERT INTO sna_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Asi kana murume wake amudzivisa paanenge anzwa nezvazvo, anokonesa mhiko iya inomusunga, kana vimbiso yaangazvisunga nayo, uye ipapo Jehovha achamusunungura. ");
INSERT INTO sna_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mhiko ipi zvayo kana chisungo chaitwa nechirikadzi kana mukadzi akarambwa chichava nesimba kwaari. ");
INSERT INTO sna_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Kana mukadzi agere nomurume wake akaita mhiko kana kuti akazvisunga nemhiko ");
INSERT INTO sna_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","uye murume wake akanzwa nezvazvo asi akasataura chinhu kwaari uye asingamudzivisi, ipapo mhiko dzake kana zvaakazvisunga pakupika zvichava nesimba. ");
INSERT INTO sna_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Asi kana murume wake akazvikonesa paanenge anzwa nezvazvo, ipapo hapana chaakapika kana zvaakazvisunga nazvo nemhiko nezvaakataura nomuromo wake zvichava nesimba. Murume wake azvikonesa, uye Jehovha achamusunungura. ");
INSERT INTO sna_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Murume wake anogona kutsigira kana kukonesa mhiko ipi zvayo yaanopika kuti azvininipise nayo. ");
INSERT INTO sna_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Asi kana murume wake akashaya chaanotaura kwaari zuva nezuva, ipapo ari kusimbisa mhiko dzake uye zvaakapika zvinomusunga. Anozvisimbisa nokusataura kwake chinhu kwaari paanenge anzwa nezvazvo. ");
INSERT INTO sna_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kana zvakadaro, akazozvikonesa pane dzimwe nguva, mushure mokunge azvinzwa, ipapo iye achatakura mhosva yomukadzi wake.” ");
INSERT INTO sna_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Iyi ndiyo mitemo yakapiwa Mozisi naJehovha pamusoro poukama pakati pomurume nomukadzi wake, uye pakati pababa nomwanasikana wavo muduku agere mumba mavo. ");
INSERT INTO sna_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Tsiva kuvaMidhiani zvavakaitira vaIsraeri. Shure kwaizvozvo uchandosanganiswa navanhu vako.” ");
INSERT INTO sna_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Saka Mozisi akati kuvanhu, “Shongedzai vamwe varume vokwenyu nhumbi dzokurwa kuti vaende kundorwa navaMidhiani kuti vazadzise kutsiva kwaJehovha pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Endesai kuhondo varume chiuru kubva kurudzi rumwe norumwe rwavaIsraeri.” ");
INSERT INTO sna_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Saka varume zviuru gumi nezviviri vakashongedzerwa kundorwa, chiuru chimwe kubva kurudzi rumwe norumwe, vakauyiswa vachibva kumhuri dzavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mozisi akavatuma kundorwa, chiuru kubva kurudzi rumwe norumwe, pamwe chete naFinehasi mwanakomana waEreazari muprista, uyo akatorawo nhumbi dzomunzvimbo tsvene nehwamanda dzokuridza pakutungamirira. ");
INSERT INTO sna_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Vakarwisa vaMidhiani, sezvakanga zvarayirwa Mozisi naJehovha, vakauraya varume vose. ");
INSERT INTO sna_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Vakaurayiwa pakati pavo ndiEvhi, Rekemu, Zuri, Huri naRebha, madzimambo mashanu avaMidhiani. Vakaurayawo nomunondo Bharamu mwanakomana waBheori. ");
INSERT INTO sna_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","VaIsraeri vakatapa vakadzi vavaMidhiani navana vavo uye vakatora mombe dzose dzavaMidhiani, makwai nepfuma sezvinhu zvavakapamba. ");
INSERT INTO sna_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Vakapisa maguta ose avaMidhiani, pamwe chete nemisasa yavo yose. ");
INSERT INTO sna_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Vakatora zvose zvavakapamba, nepfuma, pamwe chete navanhu uye nezvipfuwo, ");
INSERT INTO sna_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","vakauya nenhapwa, nepfuma uye nezvavakapamba kuna Mozisi naEreazari muprista, uye vaIsraeri vakaungana pamisasa yavo pamapani eMoabhu, paJorodhani uchibva mhiri kuJeriko. ");
INSERT INTO sna_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mozisi, Ereazari navatungamiri vose veungano vakabuda kuti vandosangana navo kunze kwomusasa. ");
INSERT INTO sna_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mozisi akatsamwira machinda ehondo, vatungamiri vezviuru navatungamiri vamazana, vakadzoka kuhondo. ");
INSERT INTO sna_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Akavabvunza akati, “Ko, makatendera vakadzi vose kuti vararame here? ");
INSERT INTO sna_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ndivo vakanga vachitevera zano raBharamu uye ndivo vakatsausa vaIsraeri kubva kuna Jehovha pane zvakaitika paPeori, naizvozvo denda rikauya pamusoro pavanhu vaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Zvino chiurayai vakomana vose. Uye muuraye mukadzi mumwe nomumwe akavata nomurume, ");
INSERT INTO sna_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","asi muzvisiyire musikana mumwe nomumwe asina kuvata nomurume. ");
INSERT INTO sna_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Imi mose makauraya ani zvake kana kubata ani zvake akaurayiwa, munofanira kugara kunze kwomusasa kwamazuva manomwe. Pazuva rechitanhatu nezuva rechinomwe, munofanira kuzvinatsa imi nenhapwa dzenyu. ");
INSERT INTO sna_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Munatse nguo imwe neimwe pamwe chete nezvose zvakaitwa namatehwe, mvere dzembudzi kana makushe ehwai.” ");
INSERT INTO sna_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ipapo Ereazari muprista akati kuvarwi vakanga vaenda kuhondo, “Hezvino zvinodikanwa ");
INSERT INTO sna_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","pamurayiro wakapiwa Mozisi naJehovha: goridhe, sirivha, ndarira, simbi, tini, mutobvu ");
INSERT INTO sna_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","nezvimwewo zvisingaparadzwi nomoto; zvinofanira kuiswa mumoto, ipapo zvichava zvakanaka. Asi zvinofanirawo kucheneswa nemvura yokunatsa. Uye zvose zvisingagoni kukunda moto zvinofanira kupinzwa nomumvura imomo. ");
INSERT INTO sna_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Pazuva rechinomwe musuke nguo dzenyu, ipapo muchava vakachena. Ipapo mungazochipinda henyu mumusasa.” ");
INSERT INTO sna_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Iwe naEreazari muprista navakuru vemhuri veungano munofanira kuverenga vanhu vose nezvipfuwo zvakapambwa. ");
INSERT INTO sna_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mugovere zvakapambwa pakati pavarwi vakaenda kuhondo uye navakasara muungano. ");
INSERT INTO sna_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kubva kuvarwi vakanga vandorwa kuhondo, utsaure somutero waJehovha chinhu chimwe chete pazvinhu mazana mashanu, vangava vanhu, mombe, mbongoro, makwai kana mbudzi. ");
INSERT INTO sna_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Utore mutero uyu kubva pahafu yavo yomugove wavo ugopa kuna Ereazari muprista somugove waJehovha. ");
INSERT INTO sna_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kubva kuhafu inova yavaIsraeri, utsaure chinhu chimwe chete kubva pamakumi mashanu oga oga, vangava vanhu, mombe, mbongoro, makwai, mbudzi kana zvimwe zvipfuwo. Uzvipe kuvaRevhi, ivo vane basa rokuchengeta tabhenakeri yaJehovha.” ");
INSERT INTO sna_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Saka Mozisi naEreazari muprista vakaita sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Zvakatapwa zvakasara pane zvavakapamba zvakanga zvatorwa navarwi zvaisvika zviuru mazana matanhatu namakumi manomwe nezvishanu zvamakwai, ");
INSERT INTO sna_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","mombe zviuru makumi manomwe nezviviri, ");
INSERT INTO sna_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","mbongoro zviuru makumi matanhatu nechiuru chimwe chete ");
INSERT INTO sna_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","uye vakadzi zviuru makumi matatu nezviviri vakanga vasina kumbovata navarume. ");
INSERT INTO sna_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Hafu yomugove wavaya vakarwa muhondo yaiva: makwai zviuru mazana matatu namakumi matatu nezvinomwe, namazana mashanu, ");
INSERT INTO sna_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","mutero waJehovha paari wakanga uri makwai mazana matanhatu namakwai manomwe namashanu; ");
INSERT INTO sna_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","mombe dzaisvika zviuru makumi matatu nezvitanhatu, mutero waJehovha padziri waiva mombe makumi manomwe nembiri; ");
INSERT INTO sna_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","mbongoro dzaiva zviuru makumi matatu namazana mashanu, mutero waJehovha padziri wakanga uri mbongoro makumi matanhatu neimwe chete; ");
INSERT INTO sna_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","vanhu vaisvika zviuru gumi nezvitanhatu, mutero waJehovha pavari waiva vanhu makumi matatu navaviri. ");
INSERT INTO sna_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mozisi akapa mutero kuna Ereazari muprista somugove waJehovha, sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Hafu yakanga iri yavaIsraeri, yakatsaurwa naMozisi kubva kuvarume vehondo, ");
INSERT INTO sna_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","hafu yeungano yaiva makwai zviuru mazana matatu namakumi matatu namanomwe, namazana mashanu, ");
INSERT INTO sna_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","mombe zviuru makumi matatu, nezvitanhatu, ");
INSERT INTO sna_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","mbongoro dzaiva zviuru makumi matatu, namazana mashanu ");
INSERT INTO sna_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","uye vanhu vaiva zviuru gumi nezvitanhatu. ");
INSERT INTO sna_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kubva pahafu yaiva yavaIsraeri, Mozisi akatsaura munhu mumwe chete kubva pavanhu makumi mashanu, chipfuwo chimwe chete kubva pazvipfuwo makumi mashanu, sezvakarayirwa naJehovha, akazvipa kuvaRevhi, vakanga vane basa rokuchengeta tabhenakeri yaJehovha. ");
INSERT INTO sna_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ipapo machinda akanga ari vatariri vamapoka ehondo, vatungamiri vezviuru navatungamiri vamazana vakaenda kuna Mozisi ");
INSERT INTO sna_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","vakati kwaari, “Varanda venyu vaverenga varwi vari pasi pedu, hapana kana mumwe chete asipo. ");
INSERT INTO sna_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Saka tauya nechipo kuna Jehovha chezvishongo zvegoridhe zvakawanikwa nomumwe nomumwe wedu, zvishongo zvegoridhe, mhete dzomumaoko, mhete dzomunzeve nouketani hwomumutsipa kuti tizviyananisire pamberi paJehovha.” ");
INSERT INTO sna_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mozisi naEreazari muprista vakagamuchira kubva kwavari goridhe, zvinhu zvose zvakanga zvakaitwa noumhizha. ");
INSERT INTO sna_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Goridhe rose rakabva kuvatungamiri vezviuru navatungamiri vamazana rakapiwa kuna Jehovha naMozisi naEreazari muprista rairema mashekeri zviuru gumi nezvitanhatu, namazana manomwe namakumi mashanu. ");
INSERT INTO sna_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Murwi mumwe nomumwe akanga azvitorera zvake zvakapambwa. ");
INSERT INTO sna_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mozisi naEreazari muprista vakagamuchira goridhe rakabva kuvatungamiri vezviuru nokuvatungamiri vamazana vakariisa muTende Rokusangana kuti chive chirangaridzo chavaIsraeri pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","VaRubheni navaGadhi, vakanga vane mombe zhinji uye namakwai akawanda kwazvo, vakaona nyika yaJazeri neGireadhi kuti yakanga yakanakira zvipfuwo. ");
INSERT INTO sna_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Saka vakauya kuna Mozisi naEreazari muprista nokuvatungamiri veungano, vakati, ");
INSERT INTO sna_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroti, Dhibhoni, Jazeri, Nimira, Heshibhoni, Ereare, Sebhami, Nebho neBheoni, ");
INSERT INTO sna_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","nyika yakakundwa naJehovha pamberi pavanhu vaIsraeri, yakanakira zvipfuwo, uye varanda venyu vane zvipfuwo.” ");
INSERT INTO sna_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Vakati, “Kana tawana nyasha pamberi penyu, nyika iyi ngaipiwe kuvaranda venyu ive yedu. Musatiyambutsa Jorodhani.” ");
INSERT INTO sna_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mozisi akati kuvaGadhi nokuvaRubheni, “Ko, vanhu venyika yokwenyu vangaenda kuhondo imi makagara henyu pano? ");
INSERT INTO sna_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ko, munoodzerei mwoyo yavaIsraeri kuti vasayambuka vachienda kunyika yavakapiwa naJehovha? ");
INSERT INTO sna_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Izvi ndizvo zvakaitwa namadzibaba enyu pandakavatuma kubva paKadheshi Bharinea kuti vandosora nyika. ");
INSERT INTO sna_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Shure kwokukwira kwavo kuMupata weEshikori vakandoona nyika, vakaodza mwoyo yavaIsraeri kuti varege kupinda munyika yavakanga vapiwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Kutsamwa kwaJehovha kwakamutswa nomusi uyo uye akapika mhiko iyi: ");
INSERT INTO sna_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nokuda kwokuti havana kunditevera nomwoyo wose, hakuna mumwe wavo ane makore makumi maviri kana anodarika akabuda munyika yeIjipiti achaona nyika yandakanga ndavimbisa nemhiko kuna Abhurahama, Isaka naJakobho, ");
INSERT INTO sna_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","hakuna mumwe wavo kunze kwaKarebhu mwanakomana waJefune muKenizi naJoshua mwanakomana waNuni nokuti vakatevera Jehovha nomwoyo wose.’ ");
INSERT INTO sna_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Kutsamwa kwaJehovha kwakapfuta pamusoro pavaIsraeri akavaita kuti vadzungaire murenje kwamakore makumi mana, kusvikira zera rose ravaya vakaita zvakaipa pamberi pake rapera. ");
INSERT INTO sna_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Hezvino muri pano, imi chibereko chavatadzi, mumire panzvimbo yamadzibaba enyu muchiwedzera kutsamwa kwaJehovha kukuru pamusoro pavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Kana mukatsauka pakumutevera, achasiyazve vanhu ava vose murenje, uye imi ndimi muchauyisa kuparadzwa kwavo.” ");
INSERT INTO sna_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ipapo vakakwira kwaari vakati, “Tinoda kuvaka matanga ezvipfuwo zvedu kuno namaguta avakadzi vedu navana. ");
INSERT INTO sna_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Asi takagadzirira kurwa nokuenda mberi navaIsraeri kusvikira tavasvitsa kunzvimbo yavo. Pari zvino vakadzi vedu navana vedu vachagara mumaguta akakomberedzwa, kuti vadzivirirwe pavagari venyika ino. ");
INSERT INTO sna_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Hatizodzokeri kumisha yedu kusvikira vaIsraeri vose vagamuchira nhaka yavo. ");
INSERT INTO sna_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Hatizogamuchiri nhaka ipi zvayo pamwe chete navo mhiri kweJorodhani, nokuti nhaka yedu tava nayo kumabvazuva kweJorodhani.” ");
INSERT INTO sna_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Ipapo Mozisi akati kwavari, “Kana mukaita izvi, kana mukazvishongedza nhumbi dzokurwa pamberi paJehovha kuti mundorwa, ");
INSERT INTO sna_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","uye kana imi mose mukaenda makashonga nhumbi dzokurwa mhiri kwaJorodhani pamberi paJehovha kusvikira adzinga vavengi vake pamberi pake, ");
INSERT INTO sna_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ipapo kana nyika ichinge yakundwa pamberi paJehovha, mungadzokera henyu uye musununguke pabasa renyu pamberi paJehovha napamberi pavaIsraeri. Uye nyika iyi ichava yenyu pamberi paJehovha. ");
INSERT INTO sna_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Asi kana mukakoniwa kuita izvi, muchange matadzira Jehovha; uye zvirokwazvo chivi chenyu chichakuwanai. ");
INSERT INTO sna_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Vakai maguta avakadzi navana venyu, uye matanga amakwai enyu, asi muite zvamakavimbisa.” ");
INSERT INTO sna_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","VaGadhi navaRubheni vakati kuna Mozisi, “Isu varanda venyu tichaita sezvarayirwa naishe wedu. ");
INSERT INTO sna_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Vana vedu navakadzi vedu, makwai edu nemombe dzedu zvichasara kuno mumaguta eGireadhi. ");
INSERT INTO sna_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Asi varanda venyu, varume vose vakazvigadzirira kundorwa, vachayambuka kundorwa pamberi paJehovha sezvataurwa naishe wedu.” ");
INSERT INTO sna_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Ipapo Mozisi akarayira pamusoro pavo kuna Ereazari muprista nokuna Joshua mwanakomana waNuni nokuvakuru vemhuri dzamarudzi avaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Akati kwavari, “Kana vaGadhi navaRubheni, murume mumwe nomumwe akazvigadzirira kundorwa, vakayambuka Jorodhani nemi pamberi paJehovha, ipapo kana nyika ikakundwa pamberi pako, uvape nyika yeGireadhi ive yavo. ");
INSERT INTO sna_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Asi kana vakasayambuka nemi vakashonga zvokurwa, vanofanira kupiwa nhaka yavo pamwe chete nemi muKenani.” ");
INSERT INTO sna_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","VaGadhi navaRubheni vakapindura vakati, “Varanda venyu vachaita zvarehwa naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tichayambuka mhiri pamberi paJehovha tigopinda muKenani, takashonga nhumbi dzokurwa nadzo, asi nhaka yatichawana ichava kudivi rino reJorodhani.” ");
INSERT INTO sna_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ipapo Mozisi akapa kuvaGadhi, navaRubheni nehafu yorudzi rwaManase, mwanakomana waJosefa, umambo hwaSihoni mambo wavaAmori noumambo hwaOgi mambo weBhashani, nyika yose namaguta ayo uye nenyika dzose dzakavapoteredza. ");
INSERT INTO sna_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","VaGadhi vakavaka Dhibhoni, Ataroti, Aroeri, ");
INSERT INTO sna_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ataroti Shafani, Jazeri, Jogubheha, ");
INSERT INTO sna_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bheti Nimura neBheti Harani samaguta akakomberedzwa, uye vakavaka matanga amakwai avo. ");
INSERT INTO sna_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Uye vaRubheni vakavakazve Heshibhoni, Ereare Kiriatihaimi, ");
INSERT INTO sna_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","pamwe chete neNebho neBhaari Meoni (mazita aya akashandurwa) neSibhima. Vakapa mazita kumaguta avakavaka. ");
INSERT INTO sna_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Zvizvarwa zvaMakiri mwanakomana waManase zvakaenda kuGireadhi, zvikaritapa zvikadzinga vaAmori vakanga varimo. ");
INSERT INTO sna_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Saka Mozisi akapa Gireadhi kuvaMakiri, zvizvarwa zvaManase, ivo vakagara ikoko. ");
INSERT INTO sna_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jairi, chizvarwa chaManase, akakunda misha yaro akaitumidza kuti Havhoti Jairi. ");
INSERT INTO sna_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Uye Nobha akakunda Kenati nenzvimbo dzakaripoteredza akaritumidza kuti Nobha zita rake. ");
INSERT INTO sna_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hezvino zvinhanho zvorwendo rwavaIsraeri pavakabuda muIjipiti namapoka avo vachitungamirirwa naMozisi naAroni. ");
INSERT INTO sna_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mozisi akanyora zvinhanho zvorwendo rwavo. Urwu ndirwo rwendo rwavo nezvinhanho zvarwo: ");
INSERT INTO sna_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","VaIsraeri vakasimuka kubva paRamesesi nezuva regumi namashanu romwedzi wokutanga, zuva rakatevera Pasika. Vakafamba vakabuda vasingatyi pamberi pavaIjipita vose, ");
INSERT INTO sna_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","avo vakanga vachiviga matangwe avo ose, akanga aurayiwa naJehovha pakati pavo; nokuti Jehovha akanga atonga vamwari vavo. ");
INSERT INTO sna_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","VaIsraeri vakabva paRamesesi vakandodzika misasa yavo paSukoti. ");
INSERT INTO sna_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Vakabva paSukoti vakandodzika misasa yavo paEtamu, mujinga megwenga. ");
INSERT INTO sna_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Vakabva paEtamu, vakadzokera shure kuPi Hahiroti, nechokumabvazuva kweBhaari Zefoni, vakandodzika misasa yavo pedyo neMigidhori. ");
INSERT INTO sna_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Vakabva paPi Hahiroti vakapinda nomugungwa vakaenda murenje, uye vakati vafamba mazuva matatu murenje reEtami, vakadzika misasa paMara. ");
INSERT INTO sna_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Vakabva paMara vakaenda kuErimu, pakanga pane matsime gumi namaviri nemiti yemichindwe makumi manomwe, uye vakadzika misasa ipapo. ");
INSERT INTO sna_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Vakabva paErimu vakandodzika misasa paGungwa Dzvuku. ");
INSERT INTO sna_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Vakabva paGungwa Dzvuku vakandodzika misasa muGwenga reSini. ");
INSERT INTO sna_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Vakabva muGwenga reSini vakandodzika misasa paDhofika. ");
INSERT INTO sna_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Vakabva paDhofika vakandodzika misasa paArushi. ");
INSERT INTO sna_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Vakabva paArushi vakandodzika misasa paRefidhimu, apo pakanga pasina mvura yokuti vanhu vanwe. ");
INSERT INTO sna_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Vakabva paRefidhimu vakandodzika misasa muGwenga reSinai. ");
INSERT INTO sna_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Vakabva muGwenga reSinai vakandodzika misasa paKibhuroti Hataavha. ");
INSERT INTO sna_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Vakabva paKibhuroti Hataavha vakandodzika misasa paHazeroti. ");
INSERT INTO sna_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Vakabva paHazeroti vakandodzika misasa paRitima. ");
INSERT INTO sna_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Vakabva paRitima vakandodzika misasa paRimoni Perezi. ");
INSERT INTO sna_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Vakabva paRimoni Perezi vakandodzika misasa paRibhina. ");
INSERT INTO sna_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Vakabva paRibhina vakandodzika misasa paRisa. ");
INSERT INTO sna_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Vakabva paRisa vakandodzika misasa paKeherata. ");
INSERT INTO sna_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Vakabva paKeherata vakandodzika misasa paGomo reSheferi. ");
INSERT INTO sna_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Vakabva paGomo reSheferi vakandodzika misasa paHaradha. ");
INSERT INTO sna_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Vakabva paHaradha vakandodzika misasa paMakeroti. ");
INSERT INTO sna_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Vakabva paMakeroti vakandodzika misasa paTahati. ");
INSERT INTO sna_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Vakabva paTahati vakandodzika misasa paTera. ");
INSERT INTO sna_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Vakabva paTera vakandodzika misasa paMitika. ");
INSERT INTO sna_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Vakabva paMitika vakandodzika misasa paHashimona. ");
INSERT INTO sna_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Vakabva paHashimona vakandodzika misasa paMoseroti. ");
INSERT INTO sna_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Vakabva paMoseroti vakandodzika misasa paBhene Jaakani. ");
INSERT INTO sna_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Vakabva paBhene Jaakani vakandodzika misasa paHori Hagidhigadhi. ");
INSERT INTO sna_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Vakabva paHori Hagidhigadhi vakandodzika misasa paJotibhata. ");
INSERT INTO sna_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Vakabva paJotibhata vakandodzika misasa paAbhurona. ");
INSERT INTO sna_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Vakabva paAbhurona vakandodzika misasa paEzioni Gebheri. ");
INSERT INTO sna_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Vakabva paEzioni Gebheri vakandodzika misasa paKadheshi, murenje reZini. ");
INSERT INTO sna_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Vakabva paKadheshi vakandodzika misasa paGomo reHori, kumuganhu weEdhomu. ");
INSERT INTO sna_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Aroni muprista akakwira muGomo reHori sezvakarayirwa naJehovha, akandofira imomo pazuva rokutanga romwedzi wechishanu wegore ramakumi mana shure kwokubuda kwavaIsraeri muIjipiti. ");
INSERT INTO sna_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aroni akanga ava namakore zana namakumi maviri namatatu pakufa kwake paGomo reHori. ");
INSERT INTO sna_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mambo weAradhi muKenani, aigara kuNegevhi kweKenani, akanzwa kuti vaIsraeri vari kuuya. ");
INSERT INTO sna_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Vakabva kuGomo reHori vakandodzika misasa paZarimona. ");
INSERT INTO sna_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Vakabva paZarimona vakandodzika misasa paPunoni. ");
INSERT INTO sna_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Vakabva paPunoni vakandodzika misasa paObhoti. ");
INSERT INTO sna_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Vakabva paObhoti vakandodzika misasa paIye Abharimi, pamuganhu weMoabhu. ");
INSERT INTO sna_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Vakabva paIyimi vakandodzika misasa paDhibhoni Gadhi. ");
INSERT INTO sna_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Vakabva paDhibhoni Gadhi vakandodzika misasa paArimoni Dhibhurataimi. ");
INSERT INTO sna_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Vakabva paArimoni Dhibhurataimi vakandodzika misasa mumakomo eAbharimi, pedyo neNebho. ");
INSERT INTO sna_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Vakabva pamakomo eAbharimi vakandodzika misasa pamapani eMoabhu pedyo neJorodhani uchibva kuJeriko. ");
INSERT INTO sna_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Pamapani eMoabhu ipapo vakadzika misasa vakatevedza Jorodhani kubva kuBheti Jeshimoti kusvikira kuAbheri Shitimu. ");
INSERT INTO sna_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Pamapani eMoabhu pedyo neJorodhani uchibva kuJeriko, Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Taura kuvaIsraeri uti kwavari: ‘Kana mayambuka Jorodhani mapinda muKenani, ");
INSERT INTO sna_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","mudzinge vose vanogara munyika imomo pamberi penyu. Muparadze zvifananidzo zvavo zvose zvakavezwa nezvifananidzo zvavo zvakaumbwa, uye muputse nzvimbo dzose dzakakwirira. ");
INSERT INTO sna_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mutore nyika iyo mugaremo, nokuti ndakupai nyika iyi kuti ive yenyu. ");
INSERT INTO sna_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mugovere nyika nomujenya, maererano nemhuri dzenyu. Mupe vakawanda nhaka huru, uye vashoma muvapewo nhaka duku. Zvose zvichawira kwavari nomujenya zvinofanira kuva zvavo. Muigove zviri maererano namarudzi amadzitateguru enyu. ");
INSERT INTO sna_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Asi kana mukasadzinga vagere munyika iyi, vamunotendera kusara ivavo vachava rukato pamberi penyu neminzwa pamativi enyu. Vachakutambudzai munyika mamugere. ");
INSERT INTO sna_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ipapo ndichakuitirai imi zvandakaronga kuvaitira ivo.’ ” ");
INSERT INTO sna_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Rayira vaIsraeri uti kwavari: ‘Kana mapinda muKenani, nyika ichagoverwa kwamuri senhaka, ichava nemiganhu iyi: ");
INSERT INTO sna_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Rutivi rwenyu rwezasi ruchasanganisira chikamu cheGwenga reZini chinotevedzana nomuganhu weEdhomu. Muganhu wenyu wezasi, uchatangira kumagumo eGungwa roMunyu nechokumabvazuva, ");
INSERT INTO sna_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","uchiyambukira zasi kweAkirabhimu, uchipfuurira nokuZini uye uchienda nezasi kweKadheshi Bharinea. Ipapo uchazoenda nokuHazari Adhari uchindosvika kuAzimoni, ");
INSERT INTO sna_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kwaunondopota, wobatana noRukova rweIjipiti uchindogumira paGungwa. ");
INSERT INTO sna_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Muganhu wenyu wokumavirira uchange uri mahombekombe eGungwa Guru. Ndiwo uchava muganhu wenyu nechokumavirira. ");
INSERT INTO sna_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Pamuganhu wenyu wokumusoro, munofanira kutara mutaro unobva kuGungwa Guru uchisvika kuGomo reHori ");
INSERT INTO sna_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","uye kubva paGomo reHori uchisvika kuRebho Hamati. Ipapo muganhu uchaenda kuZedhadhi, ");
INSERT INTO sna_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","wopfuurira kuZifurani uchindogumira paHazari Enani. Ndiwo uchava muganhu wenyu nechokumusoro. ");
INSERT INTO sna_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Pamuganhu wenyu wokumabvazuva, munofanira kutara mutaro unobva kuHazari Enani uchisvika kuShefami. ");
INSERT INTO sna_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Muganhu uchadzika uchibva nokuShefami uchisvika kuRibhura nechokumabvazuva kweZini ugopfuurira wakatevedza materu ari kumabvazuva kweGungwa reKinereti. ");
INSERT INTO sna_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Ipapo muganhu uchadzika uchitevedza Jorodhani uchindoguma paGungwa roMunyu. “ ‘Iyi ndiyo ichava nyika yenyu, nemiganhu yayo kumativi ose.’ ” ");
INSERT INTO sna_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mozisi akarayira vaIsraeri akati, “Goverai nyika iyi nomujenya wenhaka yenyu. Jehovha akarayira kuti ipiwe kumarudzi mapfumbamwe nehafu, ");
INSERT INTO sna_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","nokuti mhuri dzorudzi rwaRubheni, norudzi rwaGadhi uye nehafu yorudzi rwaManase vakagamuchira nhaka yavo. ");
INSERT INTO sna_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Marudzi maviri aya nehafu vakagamuchira nhaka yavo kumabvazuva kweJorodhani reJeriko, kwakatarisana nokumabudazuva.” ");
INSERT INTO sna_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Aya ndiwo mazita avarume vanofanira kukugoverai nyika senhaka yenyu: Ereazari muprista naJoshua mwanakomana waNuni. ");
INSERT INTO sna_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Uye ugadze mutungamiri mumwe chete kubva kurudzi rumwe norumwe kuti vabatsire pakugova nyika. ");
INSERT INTO sna_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Aya ndiwo mazita avo: “Karebhu mwanakomana waJefune, kubva kurudzi rwaJudha; ");
INSERT INTO sna_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kubva kurudzi rwaSimeoni, Shemueri mwanakomana waAmihudhi; ");
INSERT INTO sna_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kubva kurudzi rwaBhenjamini, Eridhadhi mwanakomana waKisironi; ");
INSERT INTO sna_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Kubva kurudzi rwaDhani mutungamiri Bhuki mwanakomana waJogiri; ");
INSERT INTO sna_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Mutungamiri kubva kurudzi rwaManase mwanakomana waJosefa, Hanieri mwanakomana waEfodhi; ");
INSERT INTO sna_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Mutungamiri kubva kurudzi rwaEfuremu mwanakomana waJosefa, Kemueri mwanakomana waShifutani; ");
INSERT INTO sna_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Mutungamiri kubva kurudzi rwaZebhuruni, Erizafani mwanakomana waParanaki; ");
INSERT INTO sna_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Mutungamiri kubva kurudzi rwaIsakari, Paritieri mwanakomana waAzani; ");
INSERT INTO sna_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Mutungamiri kubva kurudzi rwaAsheri, Ahihudhi mwanakomana waSheromi; ");
INSERT INTO sna_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Mutungamiri kubva kurudzi rwaNafutari, Pedhaheri mwanakomana waAmihudhi.” ");
INSERT INTO sna_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ava ndivo varume vakarayirwa naJehovha kuti vagovere nhaka kuvaIsraeri munyika yeKenani. ");
INSERT INTO sna_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Pamapani eMoabhu pedyo neJorodhani uchibva mhiri kuJeriko, Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Rayira vaIsraeri kuti vape vaRevhi maguta okuti vagare kubva panhaka ichatorwa navaIsraeri. Uye muvape mafuro akapoteredza maguta avo. ");
INSERT INTO sna_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ipapo vachava namaguta okugara uye namafuro emombe dzavo, makwai nezvimwe zvipfuwo zvavo zvose. ");
INSERT INTO sna_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Mafuro akapoteredza maguta amunopa vaRevhi achasvitsa makubhiti chiuru chimwe chete kubva pamasvingo eguta. ");
INSERT INTO sna_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Uyere makubhiti zviuru zviviri nechokunze kweguta, kurutivi rwokumabvazuva, kurutivi rwezasi uyere makubhiti zviuru zviviri, uye kurutivi rwokumavirira makubhiti zviuru zviviri, uye nechokumusoro, makubhiti zviuru zviviri, guta riri pakati. Nzvimbo iyi ichava mafuro amaguta. ");
INSERT INTO sna_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Maguta matanhatu pane auchapa vaRevhi achava outiziro, kuti munhu anenge auraya mumwe atizireko. Pamusoro paiwayo, muvape mamwe maguta makumi mana namaviri. ");
INSERT INTO sna_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Maguta ose amunopa vaRevhi anofanira kuva makumi mana namasere, pamwe chete namafuro avo. ");
INSERT INTO sna_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Maguta amunopa vaRevhi kubva munyika inotorwa navaIsraeri anofanira kupiwa zvakaenzanirana nenhaka yorudzi rumwe norumwe: Utore maguta akawanda kubva kurudzi rune akawanda, asi utore mashoma kubva kurudzi rune mashoma.” ");
INSERT INTO sna_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ipapo Jehovha akati kuna Mozisi, ");
INSERT INTO sna_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Taura kuvaIsraeri uti kwavari: ‘Kana mayambuka Jorodhani mapinda muKenani, ");
INSERT INTO sna_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","musarudze mamwe maguta kuti ave outiziro, okuti munhu anenge auraya mumwe asingaiti nobwoni atizireko. ");
INSERT INTO sna_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Achava nzvimbo dzoutiziro kubva kumutsivi, kuitira kuti munhu anopomerwa mhosva youmhondi arege kufa asati atongwa pamberi peungano. ");
INSERT INTO sna_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Maguta matanhatu amunopa aya achava maguta enyu outiziro. ");
INSERT INTO sna_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mupe maguta matatu mhiri kwaJorodhani uye mamwe matatu muKenani kuti ave maguta outiziro. ");
INSERT INTO sna_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Maguta matanhatu aya achava nzvimbo youtiziro yavaIsraeri, vatorwa kana vamwe vanhu vagere pakati pavo, kuitira kuti ani naani anenge auraya mumwe asingaiti nobwoni atizireko. ");
INSERT INTO sna_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Kana munhu akarova mumwe nesimbi akafa, iye imhondi; mhondi ichafanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Uye kana ani naani aine dombo muruoko rwake rinogona kuuraya, akarova mumwe munhu naro akafa, iye imhondi; mhondi inofanira kuurayiwa. ");
INSERT INTO sna_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Uye kana ani naani akange ane danda muruoko rwake rinogona kuuraya, uye akarova mumwe munhu akafa, iye imhondi; mhondi ichaurayiwa. ");
INSERT INTO sna_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mutsivi weropa achauraya mhondi iyo; paanosangana naye, achamuuraya. ");
INSERT INTO sna_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Kana ani zvake anga ane ruvengo kare akasundidzira mumwe kana kupotsera chimwe chinhu kwaari nobwoni iye akafa, ");
INSERT INTO sna_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","uye kana akamurova nechibhakera achimuvenga munhu uyo akafa, munhu iyeye anofanira kuurayiwa; munhu iyeye imhondi. Mutsivi weropa achauraya mhondi iyo paanosangana naye. ");
INSERT INTO sna_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Asi kana panga pasina ruvengo mumwe akakaruka asundidzira mumwe kana kupotsera chimwe chinhu kwaari asingaiti nobwoni, ");
INSERT INTO sna_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","kana anga asingamuoni, akapotsera dombo kwaari rinogona kumuuraya, uye iye akafa, ipapo sezvo anga asiri muvengi wake uye anga asingafungi kumukuvadza, ");
INSERT INTO sna_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ungano inofanira kutonga pakati pake nomutsivi weropa maererano nemitemo iyi. ");
INSERT INTO sna_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ungano inofanira kudzivirira munhu anopomerwa umhondi kubva pamutsivi weropa uye vachamudzosera kuguta routiziro uko kwaakanga atizira. Anofanira kugara ikoko kusvikira muprista mukuru afa, uyo akanga akazodzwa namafuta matsvene. ");
INSERT INTO sna_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Asi kana uyo anopomerwa akangobuda kunze akadarika muganhu weguta routiziro, uko kwaakatizira, ");
INSERT INTO sna_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","uye mutsivi weropa akamuwana ari kunze kweguta, mutsivi weropa achauraya muurayi uyu akasapiwa mhosva youmhondi. ");
INSERT INTO sna_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Muurayi anofanira kugara muguta rake routiziro kusvikira pakufa kwomuprista mukuru; anofanira kudzokera chete kunzvimbo yake kana muprista mukuru afa. ");
INSERT INTO sna_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Izvi zvinofanira kuva murayiro wokutonga nawo kusvikira kumarudzi enyu ose anotevera, kwose kwamunogara. ");
INSERT INTO sna_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Ani naani anouraya munhu anofanira kuurayiwa semhondi kana chete pane zvapupu. Asi hapafaniri kuva nomunhu anourayiwa kana pachingova nechapupu chimwe chete. ");
INSERT INTO sna_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Murege kugamuchira dzikinuro youpenyu hwemhondi, inofanira kufa. Anofanira kufa zvirokwazvo. ");
INSERT INTO sna_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Murege kugamuchira dzikinuro yomunhu upi zvake akatiza kuguta routiziro nokudaro muchimutendera kudzokera kuti andogarazve munyika yake muprista mukuru asati afa. ");
INSERT INTO sna_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Murege kusvibisa nyika yamunogara. Kuteura ropa kunosvibisa nyika, uye nyika haingayananisirwi pamusoro peropa rakateurirwamo, asi chete neropa romunhu akariteura. ");
INSERT INTO sna_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Musasvibisa nyika yamugere uye yandinogara, nokuti ini Jehovha, ndigere pakati pavaIsraeri.’ ” ");
INSERT INTO sna_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Vakuru vemhuri yeimba yaGireadhi mwanakomana waMakiri, mwanakomana waManase, vaibva kudzimba dzezvizvarwa zvaJosefa, vakauya vakataura pamberi paMozisi navatungamiri, ivo vakuru vemhuri dzavaIsraeri. ");
INSERT INTO sna_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Vakati, “Jehovha paakarayira ishe wangu kuti ape nyika kuvaIsraeri nomujenya ive nhaka yavo, akakurayirai kuti mupe nhaka yehama yedu Zerofehadhi kuvanasikana vake. ");
INSERT INTO sna_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Zvino ivo kana vakawanikwa navarume vanobva kuna mamwe marudzi aIsraeri, ipapo nhaka yavo ichabviswa panhaka yamadzitateguru edu ikawedzerwa kurudzi urwo rwavawanikwa narwo. Nokudaro chikamu chenhaka yakagoverwa kwatiri nemijenya chichabviswa. ");
INSERT INTO sna_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Gore reJubhiri ravaIsraeri parinosvika, nhaka yavo ichawedzerwa kunhaka yorudzi urwo rwavakawanikwa kwarwuri, uye pfuma yavo ichatorwa kubva kunhaka yorudzi rwamadzibaba edu.” ");
INSERT INTO sna_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ipapo Mozisi akarayira murayiro uyu kuvaIsraeri sezvaakarayirwa naJehovha achiti, “Zvinotaurwa norudzi rwezvizvarwa zvaJosefa ndizvozvo. ");
INSERT INTO sna_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Uku ndiko kurayira kwaJehovha kuvanasikana vaZerofehadhi: Vangawanikwa havo naani zvake anovafadza kana chete ari worudzi rweimba yamadzibaba avo. ");
INSERT INTO sna_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Hakuna nhaka muvaIsraeri inofanira kubva kuno rumwe rudzi ichienda kuno rumwe rudzi, nokuti muIsraeri wose anofanira kuchengeta nyika yorudzi rwake iri nhaka inobva kumadzibaba avo. ");
INSERT INTO sna_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mwanasikana mumwe nomumwe anogara nhaka yenyika murudzi rupi zvarwo rwavaIsraeri anofanira kuwanikwa nomunhu anobva muimba yorudzi rwababa vake, kuitira kuti muIsraeri wose awane nhaka yamadzibaba ake. ");
INSERT INTO sna_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Hakuna nhaka inobva kuno rumwe rudzi ichienda kuno rumwe rudzi, nokuti rudzi rwose rwavaIsraeri runofanira kuchengeta nyika yavakapiwa senhaka.” ");
INSERT INTO sna_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Saka vanasikana vaZerofehadhi vakaita sezvakarayirwa Mozisi naJehovha. ");
INSERT INTO sna_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Vanasikana vaZerofehadhi, Mara, Tiza, Hogira, Mirika naNoa vakawanikwa navanakomana vababamunini vavo. ");
INSERT INTO sna_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Vakawanikwa mukati medzimba dzezvizvarwa zvaManase mwanakomana waJosefa, uye nhaka yavo yakaramba iri mumba yorudzi rwababa vavo. ");
INSERT INTO sna_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Iyi ndiyo mirayiro nemitemo yakapiwa kuvaIsraeri naJehovha kubudikidza naMozisi pamapani eMoabhu pedyo neJorodhani uchibva mhiri kuJeriko.");
INSERT INTO sna_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Aya ndiwo mashoko akataurwa naMozisi kuvaIsraeri vose murenje kumabvazuva kweJorodhani, mumupata weArabha wakatarisana neSufi, pakati peParani neToferi, Rabhani, Hazeroti neDhizahabhi. ");
INSERT INTO sna_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Zvinotora mazuva gumi nerimwe kubva paHorebhi kuenda kuKadheshi Bharinea nenzira yokuGomo reSeiri.) ");
INSERT INTO sna_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Mugore ramakumi mana, nezuva rokutanga romwedzi wegumi nomumwe, Mozisi akazivisa vaIsraeri zvose izvo Jehovha akamurayira pamusoro pavo. ");
INSERT INTO sna_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Izvi zvakaitika mushure mokunge akunda Sihoni mambo wavaAmori, akanga achitonga paHeshibhoni, uye paEdhirei akanga akunda Ogi mambo weBhashani, akanga achitonga muAshitaroti. ");
INSERT INTO sna_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Mozisi akatanga kududzira murayiro uyu, vari nechokumabvazuva kweJorodhani munzvimbo yeMoabhu, achiti: ");
INSERT INTO sna_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Jehovha Mwari wedu akataura kwatiri paHorebhi akati, “Magara nguva yakakwana pagomo rino. ");
INSERT INTO sna_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Putsai musasa mugoenda kunyika yezvikomo yavaAmori; muende kumarudzi ose akavakidzana muArabha, mumakomo, nemuzasi mezvikomo zvokumadokero, nomuNegevhi uye kumahombekombe egungwa, nokunyika yavaKenani uye nokuRebhanoni, kusvikira kurwizi rukuru, irwo Yufuratesi. ");
INSERT INTO sna_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Tarirai, ndakupai nyika iyi. Endaimo mundotora nyika iyo Jehovha akapika kuti achaipa kumadzibaba enyu, kuna Abhurahama, naIsaka, naJakobho, uye nokuzvizvarwa zvavo zvaizovatevera.” ");
INSERT INTO sna_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Panguva iyoyo ndakati kwamuri, “Mava mutoro unorema kwazvo kuti ndikutakurei ndiri ndoga. ");
INSERT INTO sna_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Jehovha Mwari wenyu akawedzera kuwanda kwenyu zvokuti nhasi mawanda senyeredzi dzokudenga. ");
INSERT INTO sna_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Jehovha Mwari wamadzibaba enyu, ngaakuwedzerei rune chiuru uye ngaakuropafadzei sezvaakavimbisa! ");
INSERT INTO sna_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Asi ini ndingatakure seiko matambudziko enyu nemitoro yenyu uye nokupokana kwenyu ndiri ndoga? ");
INSERT INTO sna_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Zvisarudzirei varume vakachenjera, vanonzwisisa uye vanokudzwa kubva kurudzi rumwe norumwe rwamarudzi enyu, ndingovagadza pamusoro penyu.” ");
INSERT INTO sna_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Makandipindura muchiti, “Izvo zvamataura kuti zviitwe zvakanaka.” ");
INSERT INTO sna_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Saka ndakatora varume vaitungamirira marudzi enyu, varume vakachenjera uye vaikudzwa, ndikavagadza kuti vave vakuru pamusoro penyu, vave vakuru vezviuru, navakuru vamazana, navakuru vamakumi mashanu, navakuru vevane gumi uye navatariri vamarudzi. ");
INSERT INTO sna_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Zvino panguva iyoyo ndakarayira vatongi venyu, ndikati: Inzwai kupokana kuri pakati pehama dzenyu mugovatonga zvakanaka, ingava mhaka iri pakati pavaIsraeri voga kana pakati pomumwe wavo nomutorwa. ");
INSERT INTO sna_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Musaita rusarura pakutonga; inzwai vose muduku kana mukuru zvakaenzanirana. Musatya munhu upi zvake, nokuti kutonga ndokwaMwari. Uyisai kwandiri mhaka yakanyanya kukuomerai, ndigoinzwa. ");
INSERT INTO sna_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Uye panguva iyoyo ndakakurayirai zvose zvamaifanira kuita. ");
INSERT INTO sna_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Ipapo takasimuka kubva paHorebhi tikafamba takananga kunyika yamakomo yavaAmori tikapfuura nomurenje iro rose guru rinotyisa ramakaona, uye tikasvika paKadheshi Bharinea, sezvatakarayirwa naJehovha Mwari wedu. ");
INSERT INTO sna_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ipapo ndakati kwamuri, “Masvika munyika yamakomo yavaAmori, yatinopiwa naJehovha Mwari wedu. ");
INSERT INTO sna_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Tarirai, Jehovha Mwari wenyu akupai nyika iyo. Kwirai munoitora, sezvamakaudzwa naJehovha, Mwari wamadzibaba enyu. Musatya; musaora mwoyo.” ");
INSERT INTO sna_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Ipapo imi mose makauya kwandiri mukati, “Ngatitumei varume vanofanotungamira kuti vatisorere nyika vagodzoka kuzotiudza pamusoro penzira yatingafamba nayo uye namaguta atichandosvika kwaari.” ");
INSERT INTO sna_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Pfungwa iyoyo yakanga yakandinakira; nokudaro ndakasarudza varume vane gumi navaviri pakati penyu, murume mumwe kubva kurudzi rumwe norumwe. ");
INSERT INTO sna_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Ivo vakabva vakaenda munyika yamakomo, vakasvika kumupata weEshikori vakaisora. ");
INSERT INTO sna_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Vakatora mimwe yemichero yenyika iyoyo, vakauya nayo kwatiri, vakati, “Inyika yakanaka yatiri kupiwa naJehovha Mwari wedu.” ");
INSERT INTO sna_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Asi makanga musingadi kuenda; mukamukira kurayira kwaJehovha Mwari wenyu. ");
INSERT INTO sna_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Makanyunyuta muri mumatende enyu, mukati, “Jehovha anotivenga; naizvozvo akatibudisa muIjipiti kuti azotiisa mumaoko avaAmori kuti vatiparadze. ");
INSERT INTO sna_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Tichaendepiko? Hama dzedu dzatiita kuti tiore mwoyo. Dzinoti, ‘Vanhu vacho vanotikunda pasimba napakureba; maguta acho makuru uye ane masvingo akareba zvokusvika kudenga. Takaona kunyange navaAnaki ikoko.’ ” ");
INSERT INTO sna_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Ipapo ini ndakati kwamuri, “Musavhunduka; musavatya. ");
INSERT INTO sna_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Jehovha Mwari wenyu, iye anokutungamirirai, achakurwirai, sezvaakakuitirai muIjipiti, pamberi penyu chaipo, ");
INSERT INTO sna_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","uye nomurenje. Imomo makaona kuti Jehovha Mwari wenyu akakutakurai sei, sezvinoita baba kana vachitakura mwanakomana wavo, nzira dzose dzamakafamba nadzo kudzamara muchisvika panzvimbo ino.” ");
INSERT INTO sna_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Kunyange zvakadaro, hamuna kuvimba naJehovha Mwari wenyu, ");
INSERT INTO sna_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","iye akakutungamirirai parwendo rwenyu, mumoto usiku nomugore pamasikati kuti akutsvagirei nzvimbo dzokudzika matende enyu uye kuti akuratidzei nzira yamunofanira kufamba nayo. ");
INSERT INTO sna_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Jehovha paakanzwa zvamakataura, akatsamwa akapika, achiti, ");
INSERT INTO sna_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Hakungavi nomunhu mumwe wechizvarwa ichi achaona nyika yakanaka yandakapika ndichiti ndichaipa kumadzibaba enyu, ");
INSERT INTO sna_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","kunze kwaKarebhu mwanakomana waJefune achaiona, uye ndichamupa iye nezvizvarwa zvake nyika yaakatsika netsoka dzake nokuti akateerera Jehovha nomwoyo wose.” ");
INSERT INTO sna_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Nokuda kwenyu Jehovha akanditsamwira neniwo, akati, “Newewo hauchazoipindi. ");
INSERT INTO sna_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Asi mutevedzeri wako, Joshua, mwanakomana waNuni, ndiye achapindamo. ");
INSERT INTO sna_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Asi vaduku venyu avo vamakati vachatapwa, vana venyu vasati vaziva zvakanaka kubva pane zvakaipa ndivo vachapinda munyika iyi. Ndichaipa kwavari uye vachaitora. ");
INSERT INTO sna_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Asi kana murimi, dzokai mufambe makananga kurenje nenzira yokuGungwa Dzvuku.” ");
INSERT INTO sna_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Ipapo imi makapindura mukati, “Takatadzira Jehovha. Tichaenda tigondorwa, sezvatakarayirwa naJehovha Mwari wedu.” Nokudaro makashonga mumwe nomumwe nhumbi dzokurwa, muchifunga kuti zvaiva nyore kukwidza kunyika yamakomo. ");
INSERT INTO sna_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Asi Jehovha akataura kwandiri, akati, “Vaudze kuti, ‘Musakwidza kundorwa, nokuti handiendi nemi. Muchakundwa navavengi venyu.’ ” ");
INSERT INTO sna_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Naizvozvo ndakakutaurirai, asi imi hamuna kuda kuteerera. Makamukira murayiro waJehovha uye mukuzvikudza kwenyu makafamba mukapinda munyika yamakomo. ");
INSERT INTO sna_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","VaAmori vakanga vagere mumakomo iwayo vakauya kuzokurwisai; vakakudzinganisai sezvinoita nyuchi uye vakakurovai kubva paSeiri kusvikira paHoma. ");
INSERT INTO sna_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Makadzoka mukachema pamberi paJehovha, asi iye haana kuteerera kuchema kwenyu uye haana kurerekera nzeve yake kwamuri. ");
INSERT INTO sna_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Naizvozvo makagara paKadheshi mazuva mazhinji, nguva yose yamakagarapo. ");
INSERT INTO sna_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Zvino takadzoka tikafamba takananga kurenje nenzira inoenda kuGungwa Dzvuku, sezvandakanga ndarayirwa naJehovha. Kwenguva yakareba takafamba nenzira yaipoterera nenyika yamakomo yeSeiri. ");
INSERT INTO sna_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Ipapo Jehovha akati kwandiri, ");
INSERT INTO sna_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Mafamba nenzira yokupoterera nyika iyi yamakomo kwenguva yakakwana, zvino chidzokai muende nechokumusoro. ");
INSERT INTO sna_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Rayira vanhu uti, ‘Mava pedyo kuti mupfuure nomunyika yehama dzenyu zvizvarwa zvaEsau, vagere paSeiri. Ivo vachakutyai, asi muchenjere kwazvo. ");
INSERT INTO sna_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Musavatanga kuti murwe, handingakupei chikamu chipi zvacho chenyika yavo, kunyange pangakwana kuisa rutsoka rwenyu. Ndakapa Esau nyika yamakomo yeSeiri kuti ive yake. ");
INSERT INTO sna_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Munofanira kuvaripa nesirivha zvokudya zvamuchadya nemvura yamuchanwa.’ ” ");
INSERT INTO sna_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jehovha Mwari wenyu akakuropafadzai pamabasa ose amaoko enyu. Akakutarirai parwendo rwenyu murenje iri guru. Jehovha Mwari wenyu akava nemi, makore makumi mana aya, uye hapana chinhu chamakashayiwa. ");
INSERT INTO sna_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Naizvozvo takapfuura hama dzedu zvizvarwa zvaEsau, vanogara muSeiri. Takasiya nzira inoenda kuArabha, yeArabha, inobva kuErati neEzioni Gebheri, ndokufamba nenzira yomurenje reMoabhu. ");
INSERT INTO sna_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Ipapo Jehovha akataura kwandiri, akati, “Musafurusa vaMoabhu kana kuvadenha, nokuti handizokupai chikamu chipi zvacho chenyika yavo. Ndakapa Ari kuzvizvarwa zvaRoti kuti ive yavo.” ");
INSERT INTO sna_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(VaEmi vaisigarako vaiva vanhu vakasimba, vakawanda uye vakareba savaAnaki. ");
INSERT INTO sna_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","SavaAnaki ivowo vaionekwa savaRefaimu, asi vaMoabhu vaivadana nezita rokuti vaEmi. ");
INSERT INTO sna_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","VaHori vaimbogarawo muSeiri, asi vana vaEsau vakavadzinga kubva imomo. Vakaparadza vaHori vakanga varimo ivo vasati vavamo vakagara munzvimbo yavo, sezvakangoitawo Israeri munyika yavakapiwa naJehovha kuti ive yavo). ");
INSERT INTO sna_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Uye Jehovha akati, “Zvino chisimukai muyambuke Mupata weZeredhi.” Saka takayambuka mupata. ");
INSERT INTO sna_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Makore makumi matatu namasere akanga apfuura kubva panguva yatakabva paKadheshi Bharinea kusvikira patakazoyambuka Mupata weZeredhi. Panguva iyoyi chizvarwa chose chavarume vezera rokurwa chakanga chaparara kubva pamisasa, sezvakanga zvapikirwa naJehovha kwavari. ");
INSERT INTO sna_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ruoko rwaJehovha rwakaramba ruchivarwisa kusvikira rwavaparadza zvachose. ");
INSERT INTO sna_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Zvino wokupedzisira pakati pavarume ava vokurwa akati afa, ");
INSERT INTO sna_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Jehovha akati kwandiri, ");
INSERT INTO sna_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Nhasi unofanira kupfuura nomunyika yeMoabhu, paAri. ");
INSERT INTO sna_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Kana woswedera pedyo navaAmoni, usavafurusa kana kuvadenha kuti murwisane, nokuti handingakupei kuti mutore nyika ipi zvayo yavaAmori. Ndakaipa kuti ive yezvizvarwa zvaRoti.” ");
INSERT INTO sna_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Naiyowo yainzi inyika yevaRafaimu, vaisimbogaramo; asi vaAmoni vaivadaidza kuti vaZamuzumi. ");
INSERT INTO sna_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Vaiva vanhu vakasimba, vakawanda, uye vakareba savaAnaki. Jehovha akavaparadza pamberi pavaAmoni, avo vakavadzinga ndokugara munzvimbo yavo. ");
INSERT INTO sna_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Jehovha akanga aitira zvimwe chetezvo kuzvizvarwa zvaEsau, vaigara muSeiri, paakaparadza vaHori pamberi pavo. Vakavadzinga ndokugara munzvimbo yavo kusvikira nhasi. ");
INSERT INTO sna_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Uye kana vari vaAvhi vakanga vagere mumisha kusvikira kuGaza, vaKafitori vaibva Kafitori vakavaparadza ndokugara munzvimbo yavo.) ");
INSERT INTO sna_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Budai zvino muende, muyambuke mupata weArinoni. Tarirai ndakaisa muruoko rwenyu Sihoni muAmori, mambo weHeshibhoni, nenyika yake. Tangai kuitora mugorwa naye. ");
INSERT INTO sna_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Nhasi chaiye ndichatanga kuvhundutsa nokutyisa ndud