﻿USE sofia;
DROP TABLE IF EXISTS sofia.sml_vpl;
CREATE TABLE sml_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sml_vpl WRITE;
INSERT INTO sml_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ma tagna'anna to'ongan, Tuhan ya bay amapanjari dunya maka langit. ");
INSERT INTO sml_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Na, ma waktu kapamapanjari, in dunya halam gi' aniya' pangluwahanna maka halam gi' aniya' ai-aina. Aheya kal'ddoman ma sakalibutna maka alimun e' bohe' tegob-tegoban. Ina'an isab Rū Tuhan magpehē'-pi'itu min diyata' bohe' inān. ");
INSERT INTO sml_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na angallam Tuhan, yukna, “Subay aniya' sawa.” Magtūy paniya' sawa. ");
INSERT INTO sml_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Pag'nda' Tuhan ma sawa inān, kasulutan iya. Puwas e' pinasaddī e'na sawa maka l'ddom. ");
INSERT INTO sml_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ya pangōnna ma sawa ‘llaw’, ati ya pangōnna ma l'ddom ‘sangom’. Puwas pa'in sangom bo' llaw na, ya na tagna'an llaw. ");
INSERT INTO sml_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Puwas e' angallam Tuhan pabīng, yukna, “Subay aniya' pagtonga'an ma llot bohe' min deyo' maka bohe' min diyata'.” Magtūy paniya'. ");
INSERT INTO sml_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Na, ya pangōn Tuhan ma pagtonga'an e' ‘langit’. Puwas pa'in sangom bo' llaw, llaw karuwana na. ");
INSERT INTO sml_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Angallam na isab Tuhan, yukna, “Ya bohe' ma deyo'an langit subay pinagtimuk ma dakayu' pat'nna'an supaya aniya' tana' atoho'.” Magtūy paniya'. ");
INSERT INTO sml_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","‘Tana'’ ya pangōn Tuhan ma gintana'an, ati ‘tahik’ ya pangōnna ma bohe' pinagtimuk e'. Pag'nda' Tuhan ma hinangna inān, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Manjari itu, angallam na Tuhan, yukna, “Subay patomo' ai-ai ma tana' itu, kaginisan tinanom magbibinhi' maka kaginisan kayu magbubuwa', ya taga-binhi' isab.” Magtūy aniya' paltomo'-tomo'an indaginis ma gintana'an, ");
INSERT INTO sml_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","saga tinanom magbibinhi' maka saga kakayuhan magbubuwa' ma ginis-ginisanna. Pag'nda' Tuhan, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Puwas pa'in sangom bo' llaw, llaw kat'lluna na. ");
INSERT INTO sml_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Angallam isab Tuhan, yukna, “Subay aniya' saga sawa ma diyata' langit pamasaddī llaw min sangom, manjari aniya' pamandogahan llaw maka tahun maka musim. ");
INSERT INTO sml_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Saga sawa he' subay asinag ma diyata' langit supaya amasawa dunya.” Magtūy paniya' sawa. ");
INSERT INTO sml_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Aniya' tahinang e' Tuhan duwa sawa a'aslag, ya na mata llaw maka bulan. Mata llaw ya akosog amuwan sawa ma waktu llaw, bo' bulan ya amuwan sawa ma waktu sangom. Tapaniya'na isab saga bitu'un. ");
INSERT INTO sml_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Manjari saga sawa itu pinat'nna' e' Tuhan ma diyata' langit supaya pamasawa dunya ");
INSERT INTO sml_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma waktu llaw maka ma waktu sangom, bo' aniya' pagbidda'an sawa maka l'ddom. Na, pag'nda' Tuhan ma bay hinangna itu, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Puwas pa'in sangom bo' llaw, llaw ka'mpatna na. ");
INSERT INTO sml_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Angallam isab Tuhan, yukna, “Ya tahik maka bohe' subay ap'nno' e' ginisan sattuwa anahut-a'aslag. Subay isab aheka ginisan manuk-manuk magleyangan ma tonga'an ayan.” ");
INSERT INTO sml_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Manjari itu pinapanjari e' Tuhan saga sattuwa aheya ya maglahat ma tahik, maka ai-ai maglangihan atawa maglelehan ma tahik maka ma bohe'. Pinapanjari isab e'na kamemon ginisan manuk-manuk magleyangan. Na, pag'nda' Tuhan, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Manjari itu binarakatan e' Tuhan bay pinapanjari e'na inān kamemon. Yukna ma ai-ai ma tahik, “Bang pa'in kam paheka supaya ap'nno' e'bi tahik ilu.” Yukna isab ma saga manuk-manuk, “Bang pa'in kam paheka.” ");
INSERT INTO sml_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Puwas pa'in sangom bo' llaw, llaw kalimana na. ");
INSERT INTO sml_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Angallam Tuhan, yukna, “Subay aniya' ba'anan kaginisan ma deya, saga hayop ni'ipat maka saga sattuwa talun, maka ai-ai isab maglelehan ma tana'.” Magtūy paniya' na. ");
INSERT INTO sml_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hatina tahinang e' Tuhan saga kasattuwahan talun maka kahayopan maka ba'anan ai-ai ya maglelehan ma tana'. Pag'nda' Tuhan ma bay tahinangna, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Manjari angallam isab Tuhan, yukna, “Papanjarita manusiya' pinasali' ni kita. Sigām ya pinapagbaya' ma ai-ai kamemon ma kaluha'an dunya itu, ma saga daing, ma saga ai-ai magleyangan, ma saga hayop maka sattuwa, maka ma sasuku isab maglelehan ma tana'.” ");
INSERT INTO sml_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Manjari pinapanjari manusiya' e' Tuhan ma buwat kajarihanna. Pinas'ppu sigām ni iya, nihinang sigām l'lla maka d'nda. ");
INSERT INTO sml_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Binarakatan sigām e' Tuhan. Yukna ma sigām, “Anganak kam paheka bo' pasaplag panubu'bi ma kaluha'an dunya ilu. Jari ka'am ya subay magbaya' ma dunya. Pagbaya'inbi saga daing maka saga manuk-manuk, sampay ai-ai kamemon ya taga-napas ma kareya-reyahan.” ");
INSERT INTO sml_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Angallam lagi' Tuhan, yukna, “Na, buwananta kam takakanbi saga tinanom magbibinhi' maka saga kayu magbubuwa', ya taga-binhi' isab. ");
INSERT INTO sml_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pamuwanku isab kaparangan maka dahun kayu takakan e' saga sattuwa talun maka saga manuk-manuk sampay sasuku maglelehan ma tana'.” Magtūy tahinang buwat bay panoho'an Tuhan e'. ");
INSERT INTO sml_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Manjari pag'nda' Tuhan ma kamemon bay pinapanjari e'na, kasulutan to'ongan iya. Puwas pa'in sangom bo' llaw, llaw ka'nnomna na. ");
INSERT INTO sml_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Buwattē' bay pamapanjari dunya maka langit maka kamemon ai-aina. ");
INSERT INTO sml_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ta'abut llaw kapitu'na, aubus na Tuhan ma kamemon hinangna ati pahali na iya. ");
INSERT INTO sml_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binarakatan e' Tuhan llaw kapitu' he', minulliya e'na, sabab ya he' llaw bay kahalina min hinangna amapanjari ma kamemon ai-ai. ");
INSERT INTO sml_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Na, buwattē' ya pamapanjari langit maka dunya. Tagna' bay kapamapanjari PANGHŪꞋ Tuhan ma langit maka dunya, ");
INSERT INTO sml_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","halam gi' aniya' tinanom patomo', halam gi' aniya' pasaha', sabab halam gi' aniya' ulan bay pinabeya' e' PANGHŪꞋ Tuhan ni dunya. Halam gi' aniya' manusiya' isab angisbat ma tana' pagtanoman, ");
INSERT INTO sml_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","sagō' abase' tana' e' bohe' ya patubud min deyo'. ");
INSERT INTO sml_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Manjari itu aniya' tana' niā' e' PANGHŪꞋ Tuhan, kinompol e'na nihinang baran a'a. Ninapasan e'na napas kallum ni ūng a'a inān ati tahinang iya manusiya' taga-napas na. ");
INSERT INTO sml_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na aniya' kabbun bay pinatomo' e' PANGHŪꞋ Tuhan ma lahat Eden, tampal ni sobangan. Manjari in manusiya' bay hinangna inān tapat'nna' e'na maina'an ma kabbun. ");
INSERT INTO sml_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Aniya' isab pinatomo' e' Tuhan ma kabbun inān kamemon ginisan kayu ya ahāp ni'nda' maka ahāp kinakan buwa'na. Ina'an isab ma t'ngnga' kabbun dampo'on kayu ya makabuwan kallum, maka ina'an isab dampo'on kayu makabuwan pangita'u pasal kahāpan maka kala'atan. ");
INSERT INTO sml_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aniya' sapa' anasahan min lahat Eden amohe'an kakayuhan ma kabbun. Paluwas pa'in min Eden, in sapa' inān magsanga mpat. ");
INSERT INTO sml_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dakayu' sangana inān, ya na sapa' Peson, anasahan pehē' tudju ni kaluha'an lahat Habila. Aniya' dī bulawan ma lahat ina'an-i ");
INSERT INTO sml_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","maka aniya' du isab maina'an saga palmata maka bulitik kayu pahamut. ");
INSERT INTO sml_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya sanga karuwana, ya na sapa' Gehon, anasahan pehē' ni kaluha'an lahat Kūs. ");
INSERT INTO sml_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sanga kat'lluna, ya na sapa' Tigris, anasahan pehē' tudju ni lahat Assiriya min bihingna tampal ni sobangan. Maka sanga ka'mpatna inān, ya na sapa' Alpurati. ");
INSERT INTO sml_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Sakali in manusiya' binowa e' PANGHŪꞋ Tuhan bo' pinat'nna' ma lahat Eden. Sinō' iya maghuma maka angisbat kabbunna. ");
INSERT INTO sml_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Magpanoho'an PANGHŪꞋ Tuhan ma iya, yukna, “Makajari ka amangan buwa' kayu ai-ai kabaya'annu mailu. ");
INSERT INTO sml_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ya sadja mbal takakannu buwa' kayu ya makabuwan pangita'u pasal kahāpan maka kala'atan. Ebot-ebot to'ongan, da'a ka amangan. Ya llaw kapamangannu, ya na llaw kamataynu.” ");
INSERT INTO sml_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Manjari ah'lling PANGHŪꞋ Tuhan, yukna, “Mbal ahāp bang l'lla itu karangan-danganan. Hinanganku iya limbang makatōp ma iya bo' aniya' sehe'na makatabang.” ");
INSERT INTO sml_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Jari binowa e' PANGHŪꞋ Tuhan kamemon saga hayop maka sattuwa maka kamemon saga manuk-manuk ya bay hinangna min tana'. Binowa e'na pehē' ni l'lla inān supaya kinata'uwan bang ai pangōnna ma ba'anan sattuwa, hayop maka manuk-manuk e'. Manjari ai-ai pangōnna ma sasuku taga-napas inān, ya na he' ōnna. ");
INSERT INTO sml_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Sakali kaōnan e' l'lla inān kamemon saga sattuwa maka hayop maka saga manuk-manuk, malaingkan halam aniya' minsan dakayu' makatōp ma iya. ");
INSERT INTO sml_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Angkan pinatuli a'a itu e' PANGHŪꞋ Tuhan. Ahaluk pa'in tulina, niā' e' Tuhan dakayu' gusukna, ati tinaplok pabīng maka isi ya bay pangā'an gusuk. ");
INSERT INTO sml_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Jari aniya' d'nda nihinang e' PANGHŪꞋ Tuhan min gusuk l'lla, ati binowa e'na pehē' ni l'lla. ");
INSERT INTO sml_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Angabtang magtūy l'lla, yukna, “Ndū', itiya' na sali'ku. Bokog sin bokogku, isi sin isiku. Ōnanku iya ‘d'nda’ sabab bay iya ningā' min l'lla.” ");
INSERT INTO sml_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ya ilu sababanna angkan l'lla pabutas min okoman ina'-mma'na bo' parakayu' ni h'ndana. Manjari tahinang sigām dabaran. ");
INSERT INTO sml_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Na, in l'lla maka d'nda itu anantang sali'-sali', sagō' halam sigām aiya'. ");
INSERT INTO sml_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na, ma kamemon sattuwa bay pinapanjari e' PANGHŪꞋ Tuhan, sowa ya ataha' akkalna. Manjari atilaw sowa inān ma d'nda, yukna, “B'nnal bahā'? Bay kam nilāng e' Tuhan, sinō' da'a amangan buwa' kayu ai-ai ma kabbun ilu?” ");
INSERT INTO sml_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ya sambung d'nda, “Makajari kami amangan min saga buwa' kayu ma kabbun itu, ");
INSERT INTO sml_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","sagō' aniya' pangalāngan kami e' Tuhan. Sinō' kami da'a amangan buwa' kayu ya ma t'ngnga' kabbun itu. Minsan hal ni'ntanan buwa' inān, na amatay kami.” ");
INSERT INTO sml_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yuk sowa, “Ā! Mbal du kam amatay. ");
INSERT INTO sml_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Angkan buwattē' pamissala Tuhan, sabab kata'uwanna asal bang kam ganta' makakakan, makata'u kam kahāpan maka kala'atan, hatina tahinang kam sali' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sakali itu, pag'nda' d'nda ni buwa' kayu-i, kalingkatan iya. Buwa'na inān ahāp kinakan, ahāp isab pangā'an pangita'u. Jari ang'ttu' iya buwa' min kayu inān bo' kinakan e'na. Binuwanan isab e'na h'llana, ati kinakan e'na. ");
INSERT INTO sml_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Aubus pa'in sigām amangan, magtūy aniya' panayu sigām in sigām anantang sali'-sali'. Manjari angā' sigām dahun kayu igira tinuhug-tuhug e' sigām nihinang panambun. ");
INSERT INTO sml_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na, akohap-kohap pa'in lahat, takale e' sigām bahonos PANGHŪꞋ Tuhan pal'ngngan min deyom kakabbunan e'. Magtūy sigām patapuk karuwangan ma deyom kakayu-kayuhan supaya mbal ta'nda' e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Sagō' angalingan PANGHŪꞋ Tuhan ma l'lla, yukna, “Maingga na ka?” ");
INSERT INTO sml_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ya sambung l'lla, “Takaleku bahonosnu mailu ma kabbun ati tināw aku ma sabab anantang aku. Angkan aku patapuk.” ");
INSERT INTO sml_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Atilaw Tuhan, yukna, “Sai bay amata'u ka'a ya ka'a ilu anantang? Bay ka makakakan bahā' min buwa' kayu, ya bay pangalānganku ma ka'a?” ");
INSERT INTO sml_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Yuk sambung l'lla, “O'o, ya d'nda bay pamalimbangnu aku, iya ya bay amuwanan aku, angkan aku bay makakakan.” ");
INSERT INTO sml_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tinilaw d'nda isab e' PANGHŪꞋ Tuhan, yukna, “Angay ka makahinang buwattilu?” Ya sambung d'nda, “O'o, ya sowa e'. Pinarupang aku e'na, ya angkan aku makakakan.” ");
INSERT INTO sml_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Manjari amissala PANGHŪꞋ Tuhan ma sowa he', yukna, “Pagka tahinangnu ina'an-i, ka'a ya taluwa' mulka' labi lagi' min kamemon sattuwa maka hayop. Sat'ggolnu allum palele du ka maka b'ttongnu, bagunbun isab ya pagkakannu. ");
INSERT INTO sml_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Pagbantata ka maka d'nda itu. Panubu'nu maka panubu'na magbanta du saumul-umul. Kōknu ya gini'ikan e' panubu'na, maka buli' tape'na ya tanghabnu.” ");
INSERT INTO sml_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Amissala isab Tuhan ma d'nda, yukna, “Na, buwattitu pangangganta'ku ma ka'a, ganapanku to'ongan kasusahannu bang ka ab'ttong, kap'ddi'an to'ongan ka bang ka anganak. Daipara minsan buwattē', h'llanu ya kabilahiannu na pa'in, maka iya ya makapagbaya' ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ya pamissala Tuhan ma l'lla, “Ka'a isab, ma sabab kapameya'nu ma lling h'ndanu, ati kakannu buwa' kayu ya bay pangalānganku ka'a, Na, sapdahanku tana' ma sababannu. Subay ka kahunitan to'ongan amiha kalluman min tana' sat'ggolnu allum. ");
INSERT INTO sml_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","19","Patomo' kasagmotan indaginis ma tana'nu, kasagmotan aheka itingna. Jari maghulas-sangsā' du ka supaya aniya' takakannu sampay ni llaw pamole'nu ni deyom tana'. Tana' asal bay pamapanjarihan ka'a, maka tana' ya pamole'annu.” ");
INSERT INTO sml_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Manjari ya pangōn si Adam ma h'ndana ‘Hawa’. ");
INSERT INTO sml_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Na, aniya' kuwit hayop nihinang s'mmek e' PANGHŪꞋ Tuhan panambun baran si Adam maka h'ndana. ");
INSERT INTO sml_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Manjari angallam PANGHŪꞋ Tuhan, yukna, “In manusiya' itu sali' kita na, pagka makata'u na ahāp-ala'at. Mbal iya makajari ama'abut tanganna ang'ttu' buwa' kayu ya makabuwan kallum. Mbal iya subay pinarūl allum salama-lama.” ");
INSERT INTO sml_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Angkan na disi Adam pinaluwas e' PANGHŪꞋ Tuhan min kabbun Eden. Sinō' iya maghuma ma tana' bay pangahinangan iya. ");
INSERT INTO sml_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tapaluwas pa'in, aniya' mala'ikat taga-pikpik pinat'nna' e' Tuhan ma bihing kabbun Eden inān tampal ni sobangan. Aniya' isab pinat'nna' maina'an dakayu' kalis magsuleyab keyatna. Maglabad sadja, supaya halam aniya' palabayan tudju ni po'on kayu ya makabuwan kallum salama-lama. ");
INSERT INTO sml_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Na, maghulid na si Adam maka h'ndana si Hawa, jari ab'ttong iya ati anganak l'lla, ōnna si Kabil. Ya lling si Hawa, “Min tabang-tulung PANGHŪꞋ-Yawe kabuwanan aku anak l'lla.” ");
INSERT INTO sml_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Puwas e' ab'ttong si Hawa pabīng ati anganak isab l'lla, ōnna si Habil. Na, asangpot pa'in sigām, si Habil tahinang a'a magi'ipat bili-bili, bo' si Kabil ya tahinang a'a maghuhuma. ");
INSERT INTO sml_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na, ta'abut pa'in ajatu tanoman si Kabil, aniya' saga buwa' binowa e'na panukbalna ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ya tinukbal e' si Habil dakayu' bili-bili ya bay dahū nianakan ma ba'anan bili-bilina. Sinumbali' e'na bo' yampa tukbalanna ni PANGHŪꞋ isina ya ahāp to'ongan. Na, kasulutan PANGHŪꞋ ma hinang si Habil buwattē' ati tinaima' tutukbalanna. ");
INSERT INTO sml_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Malaingkan si Kabil maka saga buwa' ya tutukbalanna halam tinaima' e' Tuhan. Jari akagit magtūy atay si Kabil, ala'at isab s'mmuna. ");
INSERT INTO sml_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Manjari ah'lling PANGHŪꞋ ma si Kabil, yukna, “Otō', angay akagit ataynu? Angay angkan ala'at s'mmunu? ");
INSERT INTO sml_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bang taluwa' hinangnu tantu du aku kasulutan ma ka'a. Damikiyanna bang mbal taluwa', na, ilu mailu dusa angagad anasat ma ka'a. Ya kabaya'anna subay ang'ntanan ka'a, sagō' subay atuhannu.” ");
INSERT INTO sml_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Manjari itu ah'lling si Kabil ma siyalina si Habil, yukna, “Otō', sūng kita pehē' ni huma.” Ma huma pa'in, binono' si Habil e' si Kabil pinapatay. ");
INSERT INTO sml_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Atilaw PANGHŪꞋ ma si Kabil, yukna, “Maingga siyalinu?” Ya sambung si Kabil, “Sitta'a. Angay? Hinangku bahā' anganjagahan danakanku?” ");
INSERT INTO sml_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Manjari ah'lling PANGHŪꞋ, yukna, “Angay angkan tahinangnu ilu-i! Sumbang ko' ilu! O'ō, ilu laha' siyalinu sapantun a'a mikibalos ma aku min deyom tana'. ");
INSERT INTO sml_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na, taluwa' sapda du ka. Mbal na ka makabāk kalluman min tana' ilu sabab kasobsoban na e' laha' siyalinu. ");
INSERT INTO sml_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Minsan buwattingga pagtuyu'nu maghinang ma tana', mbal ajatu tinanomnu. Maglunsulan sadja ka pi'ingga-pi'ingga ma dunya itu, sagō' mbal ka makabāk lahat pat'ttogannu.” ");
INSERT INTO sml_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ah'lling si Kabil ma PANGHŪꞋ, “Arōy! Abuhat makalandu' ya paniksa'nu ma aku! ");
INSERT INTO sml_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Itiya' aku pala'annu min tana' bay paghuma'anku, maka palawaknu aku min matahannu. Halam du aniya' lahat pat'ttoganku ma dunya itu, tahinang aku a'a magsampig-manampig sadja. Bang aku ganta' talanggal e' sai-sai, binono' du aku pinapatay.” ");
INSERT INTO sml_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Sagō' ya sambung PANGHŪꞋ ma iya, “Mbal du. Bang aniya' amono' ka'a subay iya binalosan min pitu'.” Magtūy aniya' gindan pinat'nna' e' PANGHŪꞋ ma si Kabil supaya iya takilā e' sai-sai makalanggal ma iya. Hatina mbal iya makajari binono'. ");
INSERT INTO sml_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Manjari itu ala'an na si Kabil min alopan PANGHŪꞋ pehē' ni lahat Nōd ma dambila' Eden tampal ni sobangan, ati mahē' iya pat'nna'. ");
INSERT INTO sml_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Na, magdakayu' si Kabil maka h'ndana ati angiram iya. Maka'anak iya l'lla ōnna si Idris. Manjari si Kabil ya bay makahinang kauman, niōnan e'na Idris buwat ōn anakna he'. ");
INSERT INTO sml_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Si Idris itu taga-anak l'lla, ōnna si Irad ya mma' si Mihuja'il. Si Mihuja'il taga-anak isab l'lla, ōnna si Mitusail ya mma' si Lamek. ");
INSERT INTO sml_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamek itu duwa h'ndana, si Ada maka si Silla. ");
INSERT INTO sml_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Manjari anganak si Ada l'lla, ōnna si Jabal. Si Jabal itu panagna'an saga manusiya' magi'ipat hayop maka magluma' tolda ma masa awal e'. ");
INSERT INTO sml_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Aniya' isab siyali si Jabal ōnna si Jubal. Si Jubal ya panagna'an manusiya' apanday magsuling maka maggitara. ");
INSERT INTO sml_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Na, si Silla isab anganak l'lla, ōnna si Tubal-Kabil. Apanday iya magsasal tumbaga maka basi' nihinang kapanyapan kaginisan. Aniya' isab siyali si Tubal-Kabil d'nda, ōnna si Na'ama. ");
INSERT INTO sml_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Manjari amissala si Lamek ma saga h'ndana, yukna, “O Ada, O Silla, ka'am h'ndaku, kalehunbi kabtanganku. Bay aku makapatay subul ma sabab kapangalagutna ma aku. ");
INSERT INTO sml_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Na, bang bineya' bissala Tuhan ma si Kabil in iya subay binalosan min pitu', ya lagi'na bang aniya' amono' aku, a'a inān subay binalosan min pitumpū' maka pitu'.” ");
INSERT INTO sml_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Jari maghulid isab si Adam maka h'ndana, ati kabuwanan na isab sigā anak l'lla. Yuk si Hawa, “Itiya' aku pinasuku'an anak l'lla e' Tuhan, pangangganti' ma si Habil ya bay binono' e' si Kabil.” Sakali niōnan e'na Sēt. ");
INSERT INTO sml_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Na, si Sēt taga-anak l'lla ōnna si Enos. Masa si Enos e', ya na masa panagna'an manusiya' anabbut ōn Yawe pagtuhanan sigām. ");
INSERT INTO sml_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ya na itu salsila panugsugan si Adam. Ma waktu pamapanjari Tuhan ma manusiya' bay sigām pina'anggil ma iya. ");
INSERT INTO sml_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Pinapanjari sigām e'na d'nda maka l'lla. Binarakatan sigām e'na ati manusiya' ya pangōnna ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Na, pagabut dahatus maka t'llumpū' tahun umul si Adam, aniya' anakna l'lla an'ppu iya, ōnna si Sēt. ");
INSERT INTO sml_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aubus pa'in min bay panganak ma si Sēt, aniya' gi' walu' hatus tahun umul si Adam, maka aniya' gi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Manjari pagabut siyam hatus maka t'llumpū' tahun umul si Adam, awapat na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Na si Sēt isab, dahatus pa'in maka limantahun umulna, aniya' anakna l'lla, ōnna si Enos. ");
INSERT INTO sml_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Aubus pa'in min bay panganak ma si Enos e', aniya' gi' walu' hatus maka pituntahun umul si Sēt, maka aniya' gi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Jari pagabut siyam hatus maka sangpū' maka duwantahun umul si Sēt, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Na, si Enos isab, pagabut siyampū' tahun umulna, taga-anak iya l'lla, ōnna si Kenan. ");
INSERT INTO sml_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Aubus pa'in min bay panganak ma si Kenan, aniya' gi' walu' hatus maka sangpū' maka limantahun umul si Enos, maka aniya' lagi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Na, pagabut siyam hatus maka limantahun umul si Enos, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Si Kenan isab, pagabut umulna pitumpū' tahun, aniya' anakna l'lla, ōnna si Mahalalel. ");
INSERT INTO sml_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Aubus pa'in min bay panganak ma si Mahalalel, aniya' gi' walu' hatus maka mpatpū' tahun umul si Kenan, maka aniya' lagi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Jari pagabut siyam hatus maka sangpū' tahun umul si Kenan, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Si Mahalalel isab, pagabut nnompū' maka limantahun umulna, taga-anak iya l'lla, ōnna si Jared. ");
INSERT INTO sml_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Aubus pa'in min bay panganak ma si Jared e', aniya' gi' walu' hatus maka t'llumpū' tahun umul si Mahalalel, maka aniya' lagi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Jarina, pagabut walu' hatus maka siyampū' maka limantahun umul si Mahalalel, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Na, si Jared isab, pagabut dahatus maka nnompū' maka duwantahun umulna, aniya' anakna l'lla, ōnna si Idris. ");
INSERT INTO sml_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Manjari aubus pa'in min bay panganak ma si Idris, aniya' gi' walu' hatus tahun umul si Jared, maka aniya' lagi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Manjari pagabut siyam hatus maka nnompū' maka duwantahun umul si Jared, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Si Idris isab, pagabut umulna nnompū' maka limantahun, taga-anak iya l'lla, ōnna si Mitusala. ");
INSERT INTO sml_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Puwas e', ma deyom t'llu hatus tahun, magda'atay si Idris maka Tuhan. Aniya' gi' isab saga anakna d'nda-l'lla. Sakali itu, ta'abut pa'in t'llu hatus maka nnompū' maka limantahun umulna, palanyap sadja iya pagka niā' e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Na si Mitusala isab, pagabut umulna dahatus maka walumpū' maka pituntahun, taga-anak iya l'lla, ōnna si Lamek. ");
INSERT INTO sml_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Aubus pa'in min bay panganak ma si Lamek, aniya' gi' pitu' hatus maka walumpū' maka duwantahun umul si Mitusala, maka taga-anak lagi' iya d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jari ta'abut pa'in siyam hatus maka nnompū' maka siyam tahun umul si Mitusala, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Si Lamek isab, pagabut umulna dahatus maka walumpū' maka duwantahun, taga-anak iya l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ya pangōnna ma iya Nū ati aniya' pagkallam si Lamek ma pasalna. “Onde' itu,” yukna, “amowa kahāpan du luwas min tana' ya bay sinapdahan e' PANGHŪꞋ, jari kabuwanan kitam pahalian min hulas-sangsā'tam.” ");
INSERT INTO sml_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Aubus pa'in min bay panganak ma si Nū, aniya' gi' lima hatus maka siyampū' maka limantahun umul si Lamek, maka aniya' gi' anakna d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Manjari pagabut pitu' hatus maka pitumpū' maka pituntahun umul si Lamek, amatay na iya. ");
INSERT INTO sml_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Na, in si Nū itu, aniya' na lima hatus tahun umulna bo' yampa iya taga-anak. Manjari t'llu anakna l'lla, ya na si Sēm, si Hām maka si Japet. ");
INSERT INTO sml_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Manjari itu, salta' angaheka na bangsa manusiya' ma deyom dunya, aniya' isab anak sigām budjang. ");
INSERT INTO sml_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ta'nda' pa'in saga budjang itu e' kal'llahan ya ngga'i ka a'a dunya, na, kalingkatan sigām. Jari sasuku budjang kinabaya'an e' saga l'lla inān, ningā' h'nda e' sigām. ");
INSERT INTO sml_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Manjari angallam PANGHŪꞋ-Yawe, yukna, “Mbal na pataptap Rū-ku ma saga manusiya' itu, subay sigām buwananku ganta'an. Mbal na pinalabi umul sigām min dahatus maka duwampū' tahun.” ");
INSERT INTO sml_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na, ma waktu he'-i sampay ma tahun damuli gi' minnē', aniya' maitu ma dunya saga a'a kosogan maka alanjang, ya niōnan bangsa Nipilim. Aesog sigām maka abantug ma kalahat-lahatan. Panubu' asal sigām min saga l'lla ngga'i ka a'a dunya ya bay makah'nda budjang a'a dunya. ");
INSERT INTO sml_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Na, in binangsa manusiya' ma dunya itu ta'nda' e' PANGHŪꞋ ap'nno' e' dusa maka ala'at lullun hona'-hona' sigām. ");
INSERT INTO sml_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Pag'nda'na, magkarukka'an iya ati magsusun na ma pasal pamapanjarina manusiya' maitu ma dunya. ");
INSERT INTO sml_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Angkan angallam PANGHŪꞋ, yukna, “Pahalamku na binangsa manusiya' ya bay papanjariku. Pahalamku sigām sampay ba'anan sattuwa maka hayop, pahalamku isab ai-ai maglelehan maka manuk-manuk magleyangan. Sababna magsusun to'ongan aku ma bay papanjariku.” ");
INSERT INTO sml_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Daipara pag'nda' PANGHŪꞋ ma si Nū, kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Ya itu salsila panugsugan si Nū. T'llu du anakna l'lla, ya si Sēm, si Hām maka si Japet. Luwal si Nū halam dusahan ma waktu he'-i, magda'atay isab iya maka Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Malaingkan saga pagkahina manusiya' kumarukan kala'atan sigām ma matahan Tuhan. Ap'nno' deyom dunya e' kajahulaka'an sigām. ");
INSERT INTO sml_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Angkan ta'nda' e' Tuhan in dunya itu alumu' na ma sabab kasabulan ya nihinang e' saga manusiya' kamemon. ");
INSERT INTO sml_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Manjari magkallam Tuhan ma si Nū, yukna, “Pahalamku na saga manusiya' kamemon ma sabab kajahulaka'an sigām maingga-maingga ma dunya. Pagmulka'anku na sigām kamemon, maka lubuku isab sampay baran dunya. ");
INSERT INTO sml_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Na, angahinang na ka adjung ma ka'am,” yukna ma si Nū. “Subay kayu apagon ya pangahinangnu. Hinangin saga bilik ma deyom, bo' kitlanun lullun deyom-luwasanna. ");
INSERT INTO sml_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ya sukuranna subay buwattitu: taha'na pitumpū' maka limand'ppa, luhana sangpū' maka duwand'ppa maka tonga', maka langkawna subay pitund'ppa maka tonga'. ");
INSERT INTO sml_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Hinangin olangan duwa h'kka langana ma llot diyata' dinding maka bihing atop. Hinangin t'llu angkap, angkap deyo', angkap t'ngnga' maka angkap diyata'. Hinangin isab dakayu' lawang ma bihingna. ");
INSERT INTO sml_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Hatiun pahāp,” yuk Tuhan. “Itiya' na aku song amaniya' latap ma kaluha'an dunya itu pamahalamku kamemon indaginis, sasuku taga-napas. Manjari kamemon ai-ai ma dunya itu amatay du. ");
INSERT INTO sml_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Malaingkan pat'nna'anta ka paljanji'an, in ka'am magtai'anak sampay ayuwannu d'nda pariyata' du ni adjung ya hinangnu ilu. ");
INSERT INTO sml_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Subay duwa'nu isab min ba'anan ai-ai taga-napas bo' pinakallum sambeya' maka ka'am. Patimuk du ni ka'am kamemon ginisan manuk-manuk, kamemon ginisan sattuwa maka hayop, sampay ginisan ai-ai maglelehan ma tana'. Magbeya' du sigām duwa-ruwa maglimbang. ");
INSERT INTO sml_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bowahun isab takakan indaginis. Tau'un pagkakanbi maka pagkakan saga sattuwa maka hayop maka kamanuk-manukan.” ");
INSERT INTO sml_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Manjari bineya' e' si Nū kamemon bay panoho'an Tuhan ma iya. ");
INSERT INTO sml_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Na, aubus pa'in nihinang adjung e', magsuwala PANGHŪꞋ-Yawe ma si Nū, yukna, “Pariyata' na kam magtai'anak, sabab hal ka'a ya ta'nda'ku halam dusahan ma kaluha'an dunya. ");
INSERT INTO sml_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pasambeya'un ma ka'am kamemon ginisan hayop halal, pitu' l'lla pitu' d'nda ma ginis-ginisanna. Bang sattuwa ya mbal tahalal, duwa-ruwa sadja ya niruwa', dakayu' l'lla dakayu' d'nda maglimbang. ");
INSERT INTO sml_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Damikiyanna du isab ginisan manuk-manuk, pitu' l'lla pitu' d'nda ma ginis-ginisanna. Hinangun buwattilu supaya aniya' anatas allum min ginisan binangsa ai-ai kamemon bo' angaheka du pa'in pabalik ma kaluha'an dunya. ");
INSERT INTO sml_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pitung'llaw minnitu patumbukku ulan alandos ma deyom mpatpū' ng'llaw, mpatpū' bahangi. Jari pahalamku na kamemon taga-napas ya bay papanjariku.” ");
INSERT INTO sml_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na, bineya' e' si Nū kamemon bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ta'abut pa'in kapangalatap dunya, aniya' na nnom hatus tahun umul si Nū. ");
INSERT INTO sml_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","In iya maka anak-h'ndana sampay ayuwanna d'nda bay pariyata' ni adjung bo' mbal ta'abut e' latap. ");
INSERT INTO sml_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Manjari patimuk ni si Nū kamemon ginisan hayop maka sattuwa, halal maka ngga'i ka halal, sampay saga manuk-manuk maka kamemon maglelehan ma kuwit tana', duwa-ruwa maglimbang. Pariyata' na kamemon ni deyom adjung e' buwat bay panoho'an Tuhan ma si Nū. ");
INSERT INTO sml_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sakali itu, ta'abut pa'in pitung'llaw minnē', yampa patumbuk ulan. ");
INSERT INTO sml_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pagabut pa'in nnom hatus tahun si Nū, bulan karuwana, sangpū' maka pitu' kasobangan ma tahun ina'an, abustak kamemon tuburan bohe' ya asal ma deyom tana'. Taukab isab taplok langit bo' patumbuk ulan alandos. ");
INSERT INTO sml_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Halam aniya' hondonganna ma deyom mpatpū' bahangi. ");
INSERT INTO sml_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ma llaw katagna' ulan inān, ina'an asal disi Nū ma deyom adjung, iya maka h'ndana sampay saga anakna t'llungan si Sēm, si Hām maka si Japet sampay h'nda sigām. ");
INSERT INTO sml_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tabeya' isab ma sigām kamemon ginisan sattuwa maka hayop aheya-ariki', sattuwa talun maka hayop ni'ipat, sampay saga maglelehan ma tana'. Tabeya' isab kamemon ginisan manuk-manuk maka ai-ai magleyangan. ");
INSERT INTO sml_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Manjari aniya' patipun ni si Nū l'lla maka d'nda maglimbang min binangsa kaginisan kamemon sasuku taga-napas, pinariyata' ni adjung. ");
INSERT INTO sml_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ya na ina'an panoho'an Tuhan asal ma si Nū inān. Na, mahē' pa'in sigām kamemon ma deyom adjung, magtūy sigām tinambolan lawang e' PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ma deyom mpatpū' bahangi pasōng na pa'in latap e', pasōng palalom bohe', sampay pagūng na adjung e'. ");
INSERT INTO sml_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pasōng palalom bohe' sampay talaran na adjung. ");
INSERT INTO sml_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Palalom na pa'in bo' palalom bohe', sampay aletop na kamemon saga kabūd-būran. ");
INSERT INTO sml_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Palalom na pa'in bohe' sampay pa'abut saga mpat d'ppa lalomna min diyata' saga pussuk būd. ");
INSERT INTO sml_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Manjari maglembohan to'ongan sasuku bay taga-napas ma dunya, ba'anan kamanuk-manukan, kasattuwahan talun, kahayop-hayopan maka ai-ai maglelehan ma tana'. Magpatayan kamemon sampay binangsa manusiya'. ");
INSERT INTO sml_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kamemon ai-ai bay taga-napas ma gintana'an wa'i magpatayan lullun. ");
INSERT INTO sml_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Alaglag sasuku taga-napas kamemon, saga manusiya', kasattuwahan, kamanuk-manukan maka saga ai-ai maglelehan ma kuwit tana'. Ya du takapin allum si Nū maka saga kamemon bay ameya' ma iya ma deyom adjung. ");
INSERT INTO sml_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Na, in latap inān halam bay pakō' ma deyom dahatus maka limampū' bahangi. ");
INSERT INTO sml_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Malaingkan nientom e' Tuhan disi Nū sampay saga sattuwa maka hayop ya ma deyom adjung, ati aniya' baliyu akosog pinatiyup e' Tuhan, manjari pakulang bohe' he'. ");
INSERT INTO sml_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tinambol pabīng e' Tuhan saga bohe' bay min deyom tana' maka bohe' min langit bo' pahondong na angulan. ");
INSERT INTO sml_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","In bohe' latap-i pakō'-kō' na pa'in ma deyom dahatus maka limampū' bahangi. ");
INSERT INTO sml_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Sakali itu, ta'abut pa'in bulan kapitu'na ma tahun e'-i, sangpū' maka pitu' kasobangan, yamboho' sumanglad adjung e' pehē' ni dakayu' būd ma jadjahan Ararat. ");
INSERT INTO sml_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pakō'-kō' na pa'in bohe' sampay ni panagna'an bulan ma bulan sangpū' he', jari ta'nda'an di-na na saga pussuk kabūd-būran. ");
INSERT INTO sml_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Na, palabay pa'in mpatpū' bahangi min bay katuwa' pussuk būd e', niukab e' si Nū tandawan bay tahinangna ma adjung ");
INSERT INTO sml_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bo' paleyangna dakayu' owak ni luwasan. Jari paleyang na pa'in owak e' pi'ingga-pi'ingga sampay aniya' katoho'an pat'ppakanna. ");
INSERT INTO sml_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mbal at'ggol pinaleyang na isab e' si Nū dakayu' assang bo' kata'uwanna bang pakō' na bohe' min kareyahan. ");
INSERT INTO sml_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Sagō' masi aletop e' bohe', maka assang e' mbal makabāk pat'ppakanna. Manjari paleyang pabīng ni adjung. Na niabut e' si Nū assang e' labay min tandawan bo' pinasōd pabīng ni deyom adjung e'. ");
INSERT INTO sml_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Angagad lagi' si Nū pitumbahangi bo' yampa paleyangna assang e' pabīng. ");
INSERT INTO sml_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pagkohap pa'in, na, ilu na assang pabalik ni iya, ananga' dahun kayu jaitun baha'u bay k'ttu'na. Minnē' kinata'uwan agtūy e' si Nū ya bohe' latap pakō' na. ");
INSERT INTO sml_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Angagad gi' iya pitumbahangi bo' yampa paleyangna assang e' pabīng. Jari ma l'ngngan itu halam na makabīng ni adjung. ");
INSERT INTO sml_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ta'abut pa'in nnom hatus maka dantahun umul si Nū, bo' sahali bulan ma bulan dakayu' ma tahun e'-i, pakō' na latap. Manjari nila'anan e' si Nū sapaw adjung e'. Ang'nda' iya paluwas ati ta'nda'na atoho'-toho' na kuwit tana'. ");
INSERT INTO sml_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ta'abut pa'in ni t'llu kamatayan bulan ma bulan karuwana, atoho' na to'ongan. ");
INSERT INTO sml_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Manjari magkallam Tuhan ma si Nū, yukna, ");
INSERT INTO sml_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pareyo' na kam magtai'anak maka saga ayuwannu. ");
INSERT INTO sml_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pareyo'un isab ma ka'am saga kamanuk-manukan kamemon maka kahayop-hayopan, maka ai-ai maglelehan ma tana', supaya anganak paheka ma kaluha'an dunya itu.” ");
INSERT INTO sml_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Manjari magdeyo'an na si Nū maka anak-h'ndana sampay ayuwanna. ");
INSERT INTO sml_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Pareyo' du isab saga kahayop-hayopan maka saga kamanuk-manukan sampay ai-ai maglelehan ma tana'. Pareyo' sigām daginis maka daginis. ");
INSERT INTO sml_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Manjari amangkat batu si Nū nihinang pagkukulbanan ni PANGHŪꞋ-Yawe. Pagubus, angā' iya hayop maka manuk-manuk halal daginis maka daginis. Sinumbali' e'na bo' yampa tinunu' ma pagkukulbanan. ");
INSERT INTO sml_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kasulutan PANGHŪꞋ ma hamut kukulbanan inān, manjari yukna ma deyom atayna, “Mbal na pagmulka'anku pabalik dunya itu ma sababan manusiya', minsan ala'at asal hona'-hona' sigām sangay min kanahut sampay ni kaheya sigām. Mbal na paka'atku pabīng kamemon ya sasuku taga-napas buwat bay hinangku itu. ");
INSERT INTO sml_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sat'ggol anatas dunya itu, sat'ggol isab mags'lle'-s'lle' musim maka waktu, musim pagtanom maka musim pagani, waktu haggut maka waktu pasu', pang'llaw maka pangulan, llaw maka sangom.” ");
INSERT INTO sml_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Manjari si Nū maka saga anakna l'lla binarakatan na e' Tuhan. Magkallam iya ma sigām, yukna, “Anganak kam paheka supaya ap'nno' e'bi kaluha'an dunya ilu. ");
INSERT INTO sml_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ka'am ilu kinatāwan du e' kamemon sattuwa maka hayop, manuk-manuk maka ai-ai maglelehan ma tana', sampay saga daing. Buwananta kam kapatut magdūl-baya' ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Manjari takakanbi na ai-ai taga-napas ilu. Ma waktu dahū inān, tinanom ya bay pamuwanku ma ka'am, sagō' buwattitu pamuwanku na kamemon. ");
INSERT INTO sml_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Saguwā' aniya' pangalānganku ma ka'am subay mbal kakanbi, ya na sumbali'an halam tapaluwas laha'na, sabab laha' ya pameya'an nyawa. ");
INSERT INTO sml_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Damikiyanna laha'bi manusiya', pameya'an nyawa isab angkan subay tinungbasan to'ongan. Sai-sai a'a amahuddud laha' pagkahina manusiya' sampay amatay, tungbasanku du. Minsan sattuwa, bang aniya' amapatay ma manusiya', subay du papatayku. ");
INSERT INTO sml_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Sabab aku ya bay amapanjari manusiya' pina'anggil ni aku, angkan na bang aniya' a'a amahuddud laha' pagkahina, binalosan du a'a inān, pinahuddud isab laha'na e' pagkahina manusiya'. ");
INSERT INTO sml_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na, ka'am ilu subay anganak paheka supaya asaplag kaluha'an dunya e' saga panubu'bi magsuring-magsaingsing.” ");
INSERT INTO sml_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Manjari itu magkallam isab Tuhan ma si Nū maka saga anakna l'lla, yukna, ");
INSERT INTO sml_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Itiya' aku amat'nna' paljanji'anku ma ka'am sampay ma saga panubu'bi magpangkat-mamangkat. ");
INSERT INTO sml_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ya du ai-ai taga-napas kamemon ya bay tabeya' ma ka'am ma adjung e', talapay du isab pinat'nna'an paljanji'an, ai-na ka manuk-manuk, ai-na ka hayop, ai-na ka sattuwa. ");
INSERT INTO sml_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ya na itu pagkallamku pasal paljanji'anku ma ka'am: tinagna'an minnitu in dunya itu mbal na taluwa' latap pabalik, maka ai-ai taga-napas kamemon mbal du alaglag e' latap. ");
INSERT INTO sml_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aniya' isab tanda' palsaksi'an pat'nna'ku ma ka'am magtubu'-manubu' sampay ma sasuku taga-napas kamemon. ");
INSERT INTO sml_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Pat'nna'ku biradaliku ma kagabunan, bo' aniya' paltanda'an pamaentom saga manusiya' ma pasal paljanji'anku ma kamemon ya ma dunya. ");
INSERT INTO sml_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Bang pa'andomku lahat bo' aniya' biradali patuwa' min deyom andom, ");
INSERT INTO sml_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","entomku du paljanji'anku ma ka'am saga manusiya' sampay ma kamemon taga-napas mailu ma dunya. Janji'anta kam, halam na aniya' latap makalaglag pabīng.” ");
INSERT INTO sml_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yuk Tuhan isab, “Bang patuwa' biradali ma kagabunan sumiyan-sumiyan, nda'ku maka entomku paljanji'anku ma ai-ai taga-napas ma babaw dunya, paljanji'an anatas ni kasaumulan.” ");
INSERT INTO sml_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Buwattē' pagkallam Tuhan ma si Nū, yukna, “Ya na ina'an tanda' sin paljanji'an ya tahinangku ma sasuku taga-napas mailu ma dunya.” ");
INSERT INTO sml_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Na, saga anak si Nū ya bay sehe'na ma adjung e', ya na disi Sēm, si Hām maka si Japet. (Si Hām ya mma' si Kana'an.) ");
INSERT INTO sml_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","In anak si Nū kat'llungan itu, ya na pang'mbo'an ma kamemon manusiya' ya pasaplag ma kaluha'an dunya. ");
INSERT INTO sml_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Na si Nū itu a'a maghuhuma asal, jari anagna' iya magtanom anggul. ");
INSERT INTO sml_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Manjari itu, aniya' inuman makalango nihinang e' si Nū min bohe' anggul e'. Paginumna, nilango iya ati ahurusan di-na saga s'mmekna. Ati pabahak iya anantang ma deyom tolda ya pagluma'anna. ");
INSERT INTO sml_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mahē' pa'in iya pabahak, makasōd pehē' anakna si Hām, ya mma' si Kana'an. Manjari tapandang e'na harapan mma'na. Pagpandangna itu, magtūy iya paluwas anuli-nulihan saga danakanna ");
INSERT INTO sml_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","si Sēm maka si Japet. Sigā duwangan itu bay angā' s'mmek magtūy. Pinasablay ma baha sigā bo' yampa pasōd dahū bukut anambunan mma' sigā. Halam sigā palingi' bo' mbal ta'nda' kaiya'anna. ");
INSERT INTO sml_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Na, pagsayu si Nū min bay kalangona, bo' kata'uwanna bay hinang anakna kasiyalihan ma iya, ");
INSERT INTO sml_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","magtūy pabukaganna. Yukna, “Si Kana'an itu t'kkahan sukna'. Tahinang iya ata ma deyo'an saga danakanna.” ");
INSERT INTO sml_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ah'lling isab si Nū, “Pudjiku PANGHŪꞋ ya pagtuhanan si Sēm! Bang pa'in pa'ata ni iya si Kana'an sampay panubu'na. ");
INSERT INTO sml_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Si Japet isab, bang pa'in angaluha paglahatan saga panubu'na. Bang pa'in sigām palamud sangkahāpan ma saga panubu' si Sēm. Bang pa'in isab pa'ata ni sigām si Kana'an maka panubu'na.” ");
INSERT INTO sml_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Na, damuli pa'in min latap e' aniya' gi' t'llu hatus maka limampū' tahun kallum si Nū. ");
INSERT INTO sml_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ta'abut pa'in siyam hatus maka limampū' tahun umulna, awapat na iya. ");
INSERT INTO sml_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ya na itu salsila panugsugan si Sēm, si Hām maka si Japet, ya anak si Nū. Aniya' na anak sigām puwas bay min latap. ");
INSERT INTO sml_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Na, ya na itu saga anak si Japet l'lla, maka ōn bangsa isab ya patubu' min sigām: si Gomer, si Magog, si Maday, si Jaban, si Tubal, si Mesek maka si Tiras. ");
INSERT INTO sml_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Tubu'an si Gomer ya na saga a'a Askenas, a'a Ripat maka a'a Togarma. ");
INSERT INTO sml_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Tubu'an si Jaban ya na saga a'a Elisa, Tarsis, Kīt, maka Rodan. ");
INSERT INTO sml_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Manjari tubu'an si Jaban tahinang saga bangsa ya maglahat ma bihing tahik maka ma kapū'-pū'an. Kaniya-kaniya sigām magsaddī-saddī lahat maka bahasa sigām. ");
INSERT INTO sml_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Na, ya na itu saga anak si Hām l'lla, maka ōn bangsa isab ya patubu' min sigām: si Kūs, si Misil, si Pūt maka si Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Tubu'an si Kūs, ya na saga a'a Seba, Habila, Sabta, Ra'ama maka Sabteka. Tubu'an si Ra'ama isab ya na saga a'a Seba maka Dedan. ");
INSERT INTO sml_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Aniya' isab anak si Kūs dakayu', ōnna si Nimrud. In si Nimrud itu dahū min a'a kamemon akosog angagaw lahat maitu ma dunya. ");
INSERT INTO sml_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Abantug isab iya ma sabab kosogna magpana' sattuwa. Angkan na pinagbahasa h'lling itu, “Bang pa'in ka pasali' ni si Nimrud ya akosog magpapana' ma sabab tabang min PANGHŪꞋ-Yawe.” ");
INSERT INTO sml_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Na, ya tagna'an da'ira pinagbaya'an e' si Nimrud itu, ya na Babilon, Erek, Akkad maka Kalne, ya bay mahē' ma lahat Babilon. ");
INSERT INTO sml_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Pinaluha isab pagnakura'na sampay ni lahat Assiriya ati mahē' iya amahinang da'ira Niniba maka Rehobot-Ēl maka Kala. ");
INSERT INTO sml_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Bay pahinangna isab da'ira Resen ma tonga'an Niniba maka Kala, ya da'ira aheya ōnna. ");
INSERT INTO sml_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Manjari panubu' si Misil isab, ya na saga a'a Lūd, Anam, Lehab, Naptu, ");
INSERT INTO sml_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Kaslu maka Kiriti. A'a Kiriti itu ya na paluwasan bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Kana'an taga-anak l'lla, si Sidun ya siyaka, bo' pasunu' si Hīt. ");
INSERT INTO sml_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Kana'an isab ya pang'mbo'an saga a'a Jibus, Amor. Gilgas, ");
INSERT INTO sml_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hīb, Arka, Sīn, ");
INSERT INTO sml_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arbad, Semar maka Hamat. Pasaplag asal saga bangsa paltubu'an si Kana'an itu, ");
INSERT INTO sml_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","min lahat Sidun sampay ta'abut lahat Gerar ya ma kasekotan lahat Gasa. Pasampay isab sigām tudju ni lahat Sodom, Gomora, Adma maka Seboyim, ya ma kasekotan lahat Lasa. ");
INSERT INTO sml_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Na, ya du ilu saga panubu' si Hām ya tahinang palbangsa-bangsahan. Kaniya-kaniya sigām magsaddī-saddī lahat maka bahasa. ");
INSERT INTO sml_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Na, si Sēm isab, siyaka si Japet, ya na pang'mbo'an si Eber sampay panubu'na kamemon. ");
INSERT INTO sml_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Saga anak si Sēm l'lla ya na si Elam, si Assur, si Alpaksad, si Lūd maka si Aram. ");
INSERT INTO sml_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Saga panubu' si Aram ya na saga a'a Ūs, Hūl, Geter maka Mesek. ");
INSERT INTO sml_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Manjari si Alpaksad ya mma' si Sela, bo' si Sela ya mma' si Eber. ");
INSERT INTO sml_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Si Eber itu duwa anakna l'lla. Ya pangōn ma anakna dangan inān si Peleg sabab binangsa manusiya' bay abahagi' ma deyom masana. Si Joktan ya danakan si Peleg. ");
INSERT INTO sml_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Manjari ya panubu' si Joktan ya na saga a'a Almodad, Selep, Hasamabet, Jera, ");
INSERT INTO sml_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO sml_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimail, Seba, ");
INSERT INTO sml_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Habila, maka Jobab. Panubu' si Joktan asal sigām kamemon itu. ");
INSERT INTO sml_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ya paglahatan sigām ma lahat Mesa sampay ta'abut lahat Separ, ya lahat kabūd-būran tampal ni sobangan. ");
INSERT INTO sml_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ya na ina'an saga panubu' si Sēm. Kaniya-kaniya sigām magsaddī-saddī lahat maka bahasa. ");
INSERT INTO sml_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Na, panubu' si Nū saga a'a kamemon ya tasabbut inān, kaniya-kaniya sigām magsaddī-saddī panugsugan. Lāgi, damuli pa'in min latap, pasaplag ma dunya saga kabangsa-bangsahan kamemon, luwas min panganak si Nū. ");
INSERT INTO sml_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Na, ma masa awal e' dakayu' du bahasa pah'lling saga manusiya' kamemon ma sakalingkal dunya. ");
INSERT INTO sml_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Maglatun-latun na pa'in sigām ma lahat sobangan sampay ta'abut e' sigām karatagan aluha ma lahat Babilon. ");
INSERT INTO sml_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Maina'an pa'in, magisun-isun sigām, yuk-i, “Sūng kitam angahinang tisa' paheka, tinapa ma api bo' patuwas.” Ngga'i ka batu ya ginuna e' sigām pangahinang luma' sagō' tisa' pinagpikit maka kitlan. ");
INSERT INTO sml_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yuk sigām isab, “Gom na kitam maghinang da'ira taga-luma' pamantawan. Pamantawan itu subay alangkaw to'ongan sa'agon-agon maka'abut langit. Manjari abantug kitam, maka mbal tapulak-palik ni mpat pidju alam.” ");
INSERT INTO sml_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Manjari pareyo' PANGHŪꞋ-Yawe pina'an ang'nda' da'ira maka luma' pamantawan ya nihinang e' saga a'a inān. ");
INSERT INTO sml_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","“Na,” yukna, “Dabangsa asal manusiya' itu kamemon, maka bahasa sigām dakayu' du isab, ya angkan sigām makarapat angahinang da'ira buwattitu. Tagna'anna sadja ko' itu, gana-gana angahinang du sigām ai-ai kamaksuran sigām. ");
INSERT INTO sml_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Gom gi' kita patulun pehē' amapaglamud-lamugay bahasa sigām pakaniya-kaniya supaya sigām mbal maghati-hiyatihi dansehe'an.” ");
INSERT INTO sml_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Manjari kinanat-kanat e' PANGHŪꞋ saga manusiya' kamemon ni mpat pidju alam ati pahali sigām maghinang da'ira he'. ");
INSERT INTO sml_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ya he' sababna angkan lahat inān niōnan Babel sabab ya ina'an lahat paglamud-lamugayan bahasa saga manusiya', lahat isab pagkanat-kanatan sigām e' PANGHŪꞋ ni kalahat-lahatan ma mpat pidju alam. ");
INSERT INTO sml_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Na, balikta salsila panugsugan si Sēm. Duwantahun palabay min bay latap ma dunya, bo' dahatus tahun na umul si Sēm, aniya' anakna l'lla ōnna si Alpaksad. ");
INSERT INTO sml_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Palabay pa'in min bay kapaganak ma si Alpaksad aniya' gi' lima hatus tahun umul si Sēm, maka aniya' lagi' anakna d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Na si Alpaksad isab, pagabut t'llumpū' maka limantahun umulna, aniya' anakna l'lla ōnna si Sela. ");
INSERT INTO sml_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Palabay pa'in min kapaganak ma si Sela, aniya' gi' mpat hatus maka t'lluntahun umul si Alpaksad, maka aniya' lagi' anakna d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Na si Sela isab, pagabut t'llumpū' tahun umulna, aniya' anakna l'lla ōnna si Eber. ");
INSERT INTO sml_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Puwas e', aniya' gi' mpat hatus maka t'lluntahun umul si Sela, maka aniya' lagi' anakna d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Na si Eber isab, pagabut t'llumpū' maka mpat tahun umulna, taga-anak iya l'lla ōnna si Peleg. ");
INSERT INTO sml_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Palabay pa'in min bay kapaganak ma si Peleg, aniya' gi' mpat hatus maka t'llumpū' tahun umul si Eber maka aniya' lagi' anakna d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Na si Peleg isab, pagabut t'llumpū' tahun umulna, taga-anak iya l'lla ōnna si Riyu. ");
INSERT INTO sml_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Palabay pa'in min bay kapaganak ma si Riyu, aniya' gi' duwa hatus maka siyam tahun umul si Peleg, maka aniya' lagi' anakna d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Na si Riyu isab, ta'abut pa'in umulna t'llumpū' maka duwantahun, taga-anak iya l'lla ōnna si Serog. ");
INSERT INTO sml_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Palabay pa'in min bay kapaganak ma si Serog, aniya' gi' duwa hatus maka pituntahun umul si Riyu. Taga-anak lagi' iya d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Na, ta'abut pa'in t'llumpū' tahun umul si Serog, aniya' anakna l'lla ōnna si Nahor. ");
INSERT INTO sml_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Palabay pa'in min bay kapaganak ma si Nahor, aniya' gi' duwa hatus tahun umul si Serog. Taga-anak lagi' iya d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Na si Nahor isab, ta'abut pa'in umulna duwampū' maka siyam tahun, aniya' anakna l'lla ōnna si Tera. ");
INSERT INTO sml_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Manjari min bay kapaganak ma si Tera, aniya' gi' dahatus maka sangpū' maka siyam tahun umul si Nahor. Taga-anak gi' iya d'nda-l'lla bo' yampa iya amatay. ");
INSERT INTO sml_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Na si Tera itu, pitumpū' tahun umulna bo' yampa iya taga-anak. Si Ibram ya anakna siyaka, bo' pasunu' si Nahor, bo' si Haran ya kasiyalihan. ");
INSERT INTO sml_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Na, ya na itu salsila pasal si Tera maka saga panubu'na. Si Tera itu mma' disi Ibram, si Nahor maka si Haran. Si Haran itu aniya' anakna ōnna si Lōt. ");
INSERT INTO sml_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Saguwā' ma allum lagi' mma'na si Tera, amatay na si Haran ma lahat Uru, ya lahat paglahatan bangsa Kaldiya, lahat bay kapanganakan iya asal. ");
INSERT INTO sml_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Na si Ibram maka si Nahor taga-h'nda karuwangan. Si Saray ya h'nda si Ibram, sagō' halam aniya' anak sigā sabab si Saray mbal to'ongan maka'anak. Si Milka anak si Haran ya h'nda si Nahor. Aniya' danakan si Milka niōnan si Iska. ");
INSERT INTO sml_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Manjari magla'anan na disi Tera min Uru ya bay paglahatan bangsa Kaldiya. Tabeya' ma iya anakna si Ibram maka mpuna si Lōt anak si Haran. Tabeya' isab ayuwanna si Saray h'nda si Ibram. Ya tinudju e' sigām lahat Kana'an sagō' at'kka pa'in sigām ni da'ira Haran, mahē' sigām maglahat. ");
INSERT INTO sml_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Na, kat'ddasan sigām ma Haran sampay amatay na si Tera, duwa hatus maka limantahun umulna. ");
INSERT INTO sml_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Na aniya' palman PANGHŪꞋ-Yawe ma si Ibram, yukna, “Ala'an ka min lahatnu luggiya' ilu. Ala'an ka min saga lūng-kampungnu maka min okoman mma'nu bo' ka pehē' ni lahat dakayu' ya pa'nda'anku ni ka'a ma sinosōng. ");
INSERT INTO sml_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Hinangta ka po'onan bangsa aheya maka abantug. Buwananta ka kahāpan maka pabantugku ōnnu. Saga pagkahinu manusiya' isab kabuwanan kahāpan ma sababnu. ");
INSERT INTO sml_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Sasuku anabbut ōnnu ni kahāpan buwananku isab kahāpan. Sasuku anabbut ōnnu ni kala'atan pagmulka'anku du. Manjari saga kabangsa-bangsahan kamemon maitu ma dunya pinasuku'an kahāpan ma sababnu.” ");
INSERT INTO sml_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Sakali ta'abut pa'in pitumpū' maka limantahun umul si Ibram, ala'an iya min lahatna Haran tudju ni lahat Kana'an, buwat bay panoho'an PANGHŪꞋ ma iya. Ameya' isab si Lōt. ");
INSERT INTO sml_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Manjari ya binowa e' si Ibram h'ndana si Saray, kamanakanna si Lōt, sampay saga ata bay b'llina ma lahat Haran. Binowa isab pangalta'na kamemon bay tausahana mahē'. ");
INSERT INTO sml_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Na pagt'kka sigām ni lahat Kana'an, nilanjalan na pa'in l'ngngan sigām sampay ta'abut kayu pagduwa'ahan ma More, ma tongod lahat Sekem. (Kabangsa-bangsahan Kana'an ya tag-lahat ma masa inān.) ");
INSERT INTO sml_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Manjari magpa'nda' PANGHŪꞋ ma si Ibram bo' magkallam ma iya, yukna, “Ma sinosōng pamuwanku lahat Kana'an itu ma saga panubu'nu.” Magtūy si Ibram angahinang tambak batu panukbalanna kulban tudju ni PANGHŪꞋ, ya bay magpa'nda' ma iya. ");
INSERT INTO sml_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Puwas e' palanjal iya tudju ni kabūran ma jadjahan Betel tampal ni sobangan. Mahē' iya pahanti' ma tonga'an kauman Betel maka kauman Ayi. Aniya' isab panukbalan kulban tahinangna maina'an pagsumbahanna ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Puwas e' pauntas na si Ibram tudju ni lahat Negeb. ");
INSERT INTO sml_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na aniya' gotom maina'an ma lahat Kana'an, asigpit to'ongan, angkan palūd disi Ibram ni lahat Misil bo' pahanti' mahē'. ");
INSERT INTO sml_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Manjari itu, song pa'in sigām at'kka ni lahat Misil, ah'lling si Ibram ma h'ndana si Saray, yukna, “Saray, ka'a ilu ahāp d'nda. ");
INSERT INTO sml_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bang ka ganta' ta'nda' e' saga a'a Misil, kinata'uwan e' sigām in ka'a h'ndaku. Jari pinapatay aku e' sigām bo' ka'a ya pinakallum. ");
INSERT INTO sml_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Gom na yuknu ma sigām magdanakan kita, supaya aku kinahāpan e' sigām ma sababnu. Manjari aku itu mbal ni'inay.” ");
INSERT INTO sml_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Na, pagt'kka sigām ni lahat Misil, bo' pag'nda' saga a'a maina'an ma si Saray, b'nnal alingkat. ");
INSERT INTO sml_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ta'nda' pa'in iya e' saga a'a pangandolan Pira'un, magtūy sigām angahaka pehē' ni Pira'un-i pasal kalingkatna. Sakali binowa si Saray pehē' ni deyom astana'. ");
INSERT INTO sml_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Bo' si Ibram ya kinahāpan e' Pira'un ma sabab si Saray. Binuwanan iya ba'anan bili-bili, kambing, sapi', kura' maka unta', sampay isab saga ata d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sagō' in Pira'un pinat'kkahan saki aheya e' PANGHŪꞋ ma sabab pangā'na ma si Saray. Talapay isab saga a'a kamemon ma deyomanna. ");
INSERT INTO sml_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Angkanna pinalinganan si Ibram e' Pira'un bo' tilawna bang ai sababna. “Angay aku putingannu?” yuk Pira'un. “Angay aku halam pata'unu in iya h'ndanu? ");
INSERT INTO sml_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Yuknu ma aku in si Saray ilu danakannu, angkan iya arak ta'ā'ku h'nda. O'o, h'ndanu itu, ā! Ngā'un iya pabalik bo' kam ala'an minnitu!” ");
INSERT INTO sml_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Manjari magpanoho'an Pira'un ma saga tendogna ma pasal disi Ibram. Sinō' iya pinala'an ma sigām min lahat Misil, iya baranna maka h'ndana sampay ai-aina kamemon. ");
INSERT INTO sml_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Manjari ala'an na disi Ibram min lahat Misil bo' pabīng ni Negeb mahē' ma lahat Kana'an. Ameya' isab h'ndana maka pangalta'na kamemon sampay isab kamanakanna si Lōt. ");
INSERT INTO sml_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Magkarayahan na to'ongan si Ibram. Aheka to'ongan ba'anan kahayop-hayopanna maka aheka isab pamulawanna indaginis. ");
INSERT INTO sml_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Manjari palintas sigām min Negeb bo' maglatun-latun tudju ni kauman Betel, ni bay pahanti'an sigām tagna' ma tonga'an Betel maka da'ira Ayi. ");
INSERT INTO sml_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Asal aniya' bay maina'an pagtukbalan kulban bay tahinang e' si Ibram ma waktu palabay. Maina'an isab iya anabbut ma ōn Yawe. ");
INSERT INTO sml_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na si Lōt isab, ya sehe' si Ibram maglatun-latun, aniya' anak-h'ndana maka saga sosoho'anna. Aheka isab kahayopanna, saga kambing, bili-bili maka sapi'. ");
INSERT INTO sml_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Jari aheka sidda kahayopan sigām karuwangan, angkan mbal s'ddong ma kaparangan lahat inān bang masi na pa'in sigām dambeya'an. ");
INSERT INTO sml_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ya he' sababna angkan magsasaw saga magi'ipat hayop si Ibram maka saga a'a magipat hayop si Lōt. Masi isab aniya' saga a'a bangsa Kana'an maka bangsa Peres maglahat maina'an ma masa disi Ibram inān. ");
INSERT INTO sml_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Sakali si Ibram bay amowa si Lōt maggara', yukna, “Otō', dalaha' du kita angkan aku mbal bilahi bang aniya' pagsasawan, ai-na ka ma kita, atawa ma saga tendogta. ");
INSERT INTO sml_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gom kita magokat sabab aluha lahat itu. Ka'a ya amene' maingga-maingga kabaya'annu paglahatan. Bang kabaya'annu tana' tampal ni gibang, ma aku na tampal ni kowan. Bang kabaya'annu tana' tampal ni kowan, ma aku na tampal ni gibang.” ");
INSERT INTO sml_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Na amantaw si Lōt ni kapantayan ma bihing sapa' Jordan tobtob ni lahat Sowar. Pag'nda'na ma kapantayan inān, na, aheka bohe'na, buwat lahat Eden ya bay pinaniya' e' PANGHŪꞋ ma awal jaman. Dahāp isab maka lahat Misil. (Ma waktu ītu halam gi' bay minulka'an e' PANGHŪꞋ da'ira Sodom maka Gomora.) ");
INSERT INTO sml_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Manjari ya tapene' e' si Lōt palsuku'anna tana' kapantayan kamemon ya ma bihing sapa' Jordan. Pagubus, papinda na iya pehē' tudju ni sobangan. Na buwattē' ya kapag'bba si Ibram maka si Lōt. ");
INSERT INTO sml_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Si Ibram ya pat'nna' maina'an ma kabūran lahat Kana'an, bo' si Lōt ya pat'nna' ma kapantayan asekot ni da'ira Sodom. Mahē' na iya amat'ngge tolda pagluma'an sigām. ");
INSERT INTO sml_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na, saga a'a Sodom itu asal jahulaka' maka lumandu'an dusa sigām ni si Yawe. ");
INSERT INTO sml_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Makala'an pa'in si Lōt, angallam PANGHŪꞋ-Yawe ma si Ibram, yukna, “Ang'nda' ka ni katilibutnu ilu. ");
INSERT INTO sml_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ya kaluha'an lahat ta'nda'nu ilu, pamuwanku du ma ka'a sampay ma saga panubu'nu salama-lama. ");
INSERT INTO sml_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Buwananta ka tubu' paheka, mbal taitung, sapantun heka gusung ma gintana'an. ");
INSERT INTO sml_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Na, pehē' na ka, latagun kaluha'an lahat ilu, sabab pamuwanku du ma ka'a ma sinosōng.” ");
INSERT INTO sml_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Jari papinda si Ibram pehē' ni Hebron, ati mahē' iya maglahat ma tongod saga kakayuhan Mamre, ya pagduwa'ahan a'a kasehe'an. Aniya' isab pagtunu'an kulban nihinang e' si Ibram maina'an panumbahanna ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","3","Na, ma masa he', aniya' mpat sultan magbono' maka lima pagkahi sigām sultan. Ya itu ōn mpat sultan maka lahat bay pagnakura'an sigām: si Amdapel sultan min lahat Babilon, si Areyok sultan min da'ira Ellasal, si Kedollomer sultan min Elam, maka si Tidal sultan min Goyem. Aniya' isab lima sultan saddī ya kuntara sigām: si Bera sultan min da'ira Sodom, si Bilsa sultan min da'ira Gomora, si Sinab sultan min Adma maka si Semeber sultan min Seboyim. Kalimana sultan min kauman Bela (hatina Sowar). Na, lima sultan itu bay amatimuk kasundaluhan sigām ma Kapantayan-Siddim, ya niōnan isab Tahik Ma'asin. ");
INSERT INTO sml_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sangpū' maka duwantahun ya t'ggol sigām ma pang'ntanan sultan Kedollomer, sagō' ta'abut pa'in sangpū' ka t'lluntahun, anawakkal sigām angatu ma iya. ");
INSERT INTO sml_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na, ta'abut pa'in sangpū' maka mpat tahun, at'kka pina'an si Kedollomel maka saga sultan ya gapi'na. Jari tara'ug e' sigām bangsa Repa ma lahat Asterot Karnaim, tara'ug bangsa Sūs ma lahat Hām, maka bangsa Ēm ma Kapantayan Kiriyataim. ");
INSERT INTO sml_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Tara'ug isab bangsa Hōr ma kabūd-būran lahat Se'er ati taturul sigām sampay ta'abut jadjahan Elparan ya ma bihing lahat paslangan. ");
INSERT INTO sml_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Puwas e', pabīng isab saga sundalu disi Kedollomel inān pehē' ni lahat Kades, ya bay pinagōnan En-Mispat ma waktu tagna'. Tara'ug isab e' sigām bangsa Amalek, ati ta'agaw kaluha'an lahat sigām. Ya du bangsa Amor ya maglahat ma da'ira Hasason-Tamar, ka'agawan isab. ");
INSERT INTO sml_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na, balikta sultan lima hekana, hatina sultan min da'ira Sodom, min Gomora, min Adma, min Seboyim maka min Bela. Bay sigām magtimuk ma Kapantayan-Siddim magbono' ");
INSERT INTO sml_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","maka si Kedollomel sultan Elam maka saga sultan ya gapi'na. Ya na si Tidal sultan Goyem, si Amdapel sultan ma lahat Babilon, maka si Areyok sultan Ellasal. Hatina lima sultan min dambila', mpat isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Aheka asal lowang ma Kapantayan-Siddim e', ap'nno' e' kitlan. Na, maglahian pa'in sultan Sodom maka sultan Gomora min pagbono'an, aniya' saga tendog sigām bay ahūg ni deyom lowang e', maka aniya' isab bay makalahi pehē' ni kabūd-būran. ");
INSERT INTO sml_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Manjari itu, anganda'ug pa'in saga sultan mpat hekana he', ta'agaw e' sigām kamemon pangalta' maka balanja' bay ma deyom da'ira Sodom maka da'ira Gomora. Pagubus, magla'anan sigām minnē'. ");
INSERT INTO sml_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tabowa isab e' sigām si Lōt kamanakan si Ibram, iya baranna sampay alta'na kamemon, pagka da'ira Sodom ya paglahatanna. ");
INSERT INTO sml_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Sakali itu aniya' a'a makal'ppa min pang'ntanan disi Kedollomel amowa lapal ni si Ibram, ya bangsa Hibrani. Ina'an iya maglahat ma tongod kakayuhan pagduwa'ahan, ya ma si Mamre a'a bangsa Amor. Aniya' isab danakan si Mamre, si Eskol maka si Aner. Pagapi' asal sigām magdanakan itu ma si Ibram. ");
INSERT INTO sml_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Na, pagta'u si Ibram wa'i tasaggaw kamanakanna si Lōt, magtūy iya amatipun saga tendogna ya bay asal ma deyomanna, a'a ata'u magbono'. T'llu hatus maka sangpū' maka walu' puhu' ya heka sigām. Atimuk pa'in, magtūy sigām paturul ni mpat sultan inān sampay ta'abut lahat Dān. ");
INSERT INTO sml_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Sangom pa'in, pinagbahagi' e' si Ibram saga tendogna bo' parugpak ni kuntara sigām. Aga'os disi Ibram inān ati anurul saga kuntara sigām sampay ni kauman Hoba, ya ma dambila' da'ira Damaskus tampal ni uttala'. ");
INSERT INTO sml_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ta'abut pa'in kauman Hoba, magtūy ta'ā' pabalik saga pangalta' kamemon bay tataban e' mpat sultan e'. Ta'ā' isab pabīng e' si Ibram kamanakanna si Lōt maka alta'na, sampay saga kar'ndahan maka a'a kasehe'an ya bay tasaggaw inān. ");
INSERT INTO sml_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sakali tara'ug e' si Ibram sultan Kedollomel maka saga sultan gapi'na. Ma labayan pa'in iya tudju amole', bo' ta'abut L'bbak Sabe, ya pinagōnan isab L'bbak sin Kasultanan, sinampang iya e' sultan min da'ira Sodom. ");
INSERT INTO sml_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sinampang isab iya e' si Malkisadik, sultan ma lahat Salem maka imam maghinang ni Tuhan Mahatinggi. Aniya' tinapay maka binu-anggul binowa e'na pangalabotna ma si Ibram, ");
INSERT INTO sml_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","bo' yampa angamu'-amu'an iya kahāpan, yukna, “Bang pa'in si Ibram kabuwanan kahāpan e' Tuhan Mahatinggi, ya magpapanjari dunya maka langit! ");
INSERT INTO sml_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pudjiku Tuhan Mahatinggi, ya bay anukbal saga bantanu ni deyom pang'ntanannu!” Manjari saga alta' bay ta'agaw pabīng e' si Ibram, binahagi' e'na pasangpū', ati dabahagi' he' pangahulmatna ma si Malkisadik. ");
INSERT INTO sml_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ah'lling isab sultan min da'ira Sodom ma si Ibram, yukna, “Ma ka'a na kamemon pangalta'ku ilu. Sagō' amu'ku pole'in sadja ni aku saga tendogku ya bay tabowanu pal'ppa ilu.” ");
INSERT INTO sml_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ya sambung si Ibram, “Saksi'ku si Yawe, ya Tuhan Mahatinggi bay magpapanjari dunya maka langit. Bay aku makasapa ma iya, ");
INSERT INTO sml_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mbal aku anaima' ai-ai palsuku'annu, minsan la'a dalamba salbannu atawa engkot taumpa'nu bo' mbal ka makapah'lling ka'a ya bay makaparaya ma aku. ");
INSERT INTO sml_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mbal aku anambut ai-ai min ka'a, luwal ya bay panganggastu saga a'aku. Sagō' aniya' a'a bay makarapit ma aku amono', ya na disi Aner, si Eskol maka si Mamre. Patut sigām pinahampitan.” ");
INSERT INTO sml_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pagubus ina'an-i, takale e' si Ibram suwala PANGHŪꞋ-Yawe magkallam ma iya hinabuna atuli, yuk-i, “O Ibram, da'a ka tināw. Aku ya anampanan ka'a, sali' hantang taming. Ahāp to'ongan panungbasku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Anambung si Ibram, yukna, “O Yawe, ka'a Panghū'ku, ai pūsna bang aku tungbasannu bo' halam aniya' anakku? Ya pinusaka'an alta'ku ya na si Ele'eser, a'a Damaskus. ");
INSERT INTO sml_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Halam aku bay buwanannu anak, angkan dakayu' ipatanku itu ya pinasuku'an pusaka'.” ");
INSERT INTO sml_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na, takalena suwala PANGHŪꞋ pabīng, yukna, “Ngga'i ka ipatannu ya pamusaka'annu, sagō' anaknu lissi.” ");
INSERT INTO sml_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Sakali binowa iya e' Tuhan paluwas min luma'na bo' ah'lling ma iya, yuk-i, “Pahangad ka ni diyata' langit, sulayin ni'itung saga bitu'un ilu. Saheka-heka taitungnu ilu, ya isab heka panubu'nu.” ");
INSERT INTO sml_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Na, am'nnal to'ongan si Ibram ma pangallam PANGHŪꞋ e'. Jari minnē', min pam'nnalna, kasulutan Tuhan ma iya ati ni'itung iya a'a abontol. ");
INSERT INTO sml_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Magkallam isab Tuhan ma si Ibram, yukna, “Aku si Yawe, ya Tuhan bay amowa ka'a pi'itu min Uru lahat bangsa Kaldiya bo' supaya pamasuku'ku lahat itu ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Atilaw gi' si Ibram ma PANGHŪꞋ, yukna, “O Yawe, ka'a Tuhanku, buwattingga e'ku makatantu in lahat itu ma aku du?” ");
INSERT INTO sml_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Anambung PANGHŪꞋ, yukna, “Angā' ka dakayu' sapi' d'nda, dakayu' kambing d'nda maka dakayu' bili-bili l'lla, t'llu-t'llun tahun pangumulanna. Angā' ka isab dakayu' manuk-manuk malapati maka dakayu' anak assang ati bowahun pi'itu ni aku.” ");
INSERT INTO sml_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Jari binowa saga hayop itu ni Tuhan e' si Ibram. Binila' duwa bo' yampa pinapagalop bila'anna. Sagō' halam binila' saga manuk-manuk, hal pinat'nna' sadja. ");
INSERT INTO sml_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sakali aniya' saga belle' pat'ppak ma sumbali'an inān arak amangan, daipara tin'ggal e' si Ibram. ");
INSERT INTO sml_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pags'ddop mata llaw tatuli si Ibram, ahaluk to'ongan tulina. Kal'ddoman iya sidda maka sinōd tāw aheya. ");
INSERT INTO sml_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Manjari angallam PANGHŪꞋ ma iya, yukna, “Ma tahun sinōng in panubu'nu tahinang a'a liyu ma lahat ngga'i ka lahat sigām. Tahinang sigām banyaga' ma lahat e' ati pinissoko' sigām to'ongan ma deyom mpat hatus tahun. ");
INSERT INTO sml_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Saguwā',” yuk Tuhan, “pat'kkaku mulka' ma bangsa ya amanyaga' sigām. Ta'abut pa'in waktu katulak sigām min lahat inān, makabowa du isab sigām alta' lumandu'an hekana. ");
INSERT INTO sml_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sagō' in pasalnu, Ibram, pataha'ku du umulnu ati amatay du ka ma deyom kasannangan, maka takubul ka pahāp. ");
INSERT INTO sml_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","In pasal panubu'nu isab, subay palabay mpat masa bo' yampa sigām pabīng ni lahat Kana'an itu sabab in paldusahan bangsa Amor subay pinajukup dahū.” ");
INSERT INTO sml_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Manjari, pas'ddop pa'in llaw bo' angal'ddom na lahat, aniya' sali' hantang lapohan maka suwariyan palabay ma tonga'an saga sumbali'an bay pinagdambila' inān. Maghumbu asal lapohan maka arokot suwariyan. ");
INSERT INTO sml_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Magtūy ma waktu ina'an, aniya' paljanji'an pamat'nna' e' PANGHŪꞋ ma si Ibram, yuk-i, “Pamuwanku du katibu'ukan lahat itu ma saga panubu'nu, tobtob min sapa' lahat Misil sampay ni sapa' Alpurati ya sapa' aheya. ");
INSERT INTO sml_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tabeya' isab tana' saga bangsa Kēn, Kenes, Kadmon, ");
INSERT INTO sml_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hīt, Pirissi, Repa, ");
INSERT INTO sml_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor, Kana'an, Gilgas maka Jibus.” ");
INSERT INTO sml_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Na, si Saray h'nda si Ibram halam anakan. Sagō' aniya' ipatanna d'nda Misil, ōnna si Hajara. ");
INSERT INTO sml_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Manjari itu, ta'abut pa'in sangpū' tahun kapaglahat si Ibram ma Kana'an, ah'lling ma iya si Saray, yukna, “Kahandak min PANGHŪꞋ ya angkan aku mbal maka'anak. Bang bahā' hulidnu ipatanku itu. Kalu aniya' anakku labay min iya.” Kasulutan isab si Ibram ma h'lling si Saray. Jari binowa e' si Saray ipatanna si Hajara pamah'ndana ma h'llana. ");
INSERT INTO sml_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Manjari maghulid si Ibram maka si Hajara ati angiram na iya. Makananam pa'in si Hajara in iya angiram na, magtūy pareyo'-deyo'na si Saray. ");
INSERT INTO sml_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Anumbung magtūy si Saray ma si Ibram, yukna, “Dusanu ya angkan aku pinareyo'-deyo' e' si Hajara itu. Ya b'nnalna, aku ya bay amuwan iya ma ka'a. Sagō' pagta'una ab'ttong na iya, mbal na iya magaddat ma aku. Na, baya'-baya' si Yawe angahukum ma kita duwangan.” ");
INSERT INTO sml_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Anambung si Ibram, yukna, “Ipatannu ko' ilu, baya'-baya'nu na minsan ai hinangnu ma iya.” Manjari alahi si Hajara pagka kinabigsi'an e' si Saray. ");
INSERT INTO sml_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Sakali itu, hinabu si Hajara ma lahat paslangan, tabāk iya e' mala'ikat PANGHŪꞋ ma atag dakayu' tuburan bohe', ina'an ma labayan tudju ni lahat Sūr. ");
INSERT INTO sml_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ya lling mala'ikat ma iya, “O Hajara, ka'a ipatan si Saray, bay ka minningga? Maka pi'ingga isab ka?” Ya sambung si Hajara, “Itiya' aku alahi min si Saray ya bay pagipatanku.” ");
INSERT INTO sml_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yuk mala'ikat-i, “Subay ka amole' pehē' ni nakura'nu magpa'ata ma iya pabīng.” ");
INSERT INTO sml_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ah'lling isab mala'ikat ma si Hajara, yukna, “Buwananta ka tubu' paheka, mbal taitung hekana. ");
INSERT INTO sml_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ilu ka ab'ttong, jari anganak du ka l'lla. Si Isma'il ya pangōnnu iya sabab takale e' PANGHŪꞋ kasusahannu. ");
INSERT INTO sml_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Malaingkan anaknu ilu tahinang sali' kura' talun mbal tasoho'. Pinagsagga' e'na saga pagkahina manusiya', maka anagga' isab saga a'a kamemon ma iya. Jari mbal iya makapagdakayu' lahat maka saga kakampunganna.” ");
INSERT INTO sml_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yuk si Hajara ma deyom atayna, “Arī! Masi bahā' aku allum minsan ta'nda'ku Tuhan?” Manjari ya pangōnna ma PANGHŪꞋ ya bay ah'lling ma iya, “Tuhan ya Maka'nda' ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Angkan na tuburan bohe' inān pinagōnan Be'er-Lahai-Ruwi, hatina ‘Bohe' Tuhan ya Maka'nda' ma aku.’ Bohe' itu, ina'an ma tonga'an lahat Kades maka kauman Bered. ");
INSERT INTO sml_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Na anganak na si Hajara, angkan aniya' anak si Ibram l'lla. Si Isma'il ya pangōn si Ibram ma iya. ");
INSERT INTO sml_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Walumpū' maka nnom tahun ya umul si Ibram ma waktu panganak si Hajara ma si Isma'il-i. ");
INSERT INTO sml_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Manjari pagabut siyampū' maka siyam tahun umul si Ibram, magpa'nda' PANGHŪꞋ-Yawe ma iya. “Aku ya Tuhan Sangat Kawasa,” yukna. “Beya'un panoho'anku, maka pabontolun isab hinangnu kamemon, ");
INSERT INTO sml_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ati tumanku paljanji'anku ma ka'a. Pahekaku to'ongan isab paltubu'annu.” ");
INSERT INTO sml_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Na, pasujud magtūy si Ibram. Ya palman Tuhan ma iya, ");
INSERT INTO sml_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Buwattitu ya paljanji'anku ma ka'a, hinangta ka pagmatto'ahan ma kabangsa-bangsahan. ");
INSERT INTO sml_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Maka pindahanku isab ōnnu. Puwas itu ngga'i ka na si Ibram ya pangōn ka'a, sagō' si Ibrahim na, sabab hinangta ka pagmatto'ahan saga bangsa kaginisan. ");
INSERT INTO sml_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aho', pahekaku to'ongan saga panubu'nu ati tahinang sigām kabangsa-bangsahan. Ma sinosōng isab aniya' saga sultan patubu' min ka'a. ");
INSERT INTO sml_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Pahogotku to'ongan paljanji'anku itu ma ka'a sampay ma saga panubu'nu magpangkat-mamangkat. Janji' itu mbal magbaluba ni kasaumulan. Aku ya Tuhannu, maka pagtuhanan saga panubu'nu. ");
INSERT INTO sml_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","In katibu'ukan lahat Kana'an itu, ya paghanti'annu ma buwattina'an, pamuwanku du ma ka'a sampay ma saga panubu'nu saumul-umul. Aku ya pagtuhanan sigām.” ");
INSERT INTO sml_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Magkallam isab Tuhan ma si Ibrahim, yukna, “Na ka'a isab, subay bogbogannu paljanji'anta itu, damikiyanna isab saga panubu'nu magpangkat-mamangkat salama-lama. ");
INSERT INTO sml_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Buwattitu ya pamogbogbi ma janji' pagsulutanta itu, kamemon kal'llahan ma deyomanbi subay ni'islam. ");
INSERT INTO sml_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ya du ilu tanda' ma paljanji'an ya pagsulutanta itu, in ka'am kal'llahan subay ni'islam. ");
INSERT INTO sml_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Puwas min waktu itu sampay ma waktu sinōng, in l'lla kamemon ya nianakan ma deyomanbi tahun ni tahun, ai-na ka anakbi, ai-na ka isab anak ata, subay ni'islam bang ta'abut walung'llaw ma luwasan. Ya du isab saga ata bay b'llinu min a'a liyu subay ni'islam isab. Aho',” yuk Tuhan, “kamemon kal'llahanbi ilu subay ni'islam, manjari aniya' pangilāhan ma baranbi in janji' pagsulutanta itu kakkal saumul-umul. ");
INSERT INTO sml_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Saguwā' sai-sai l'lla halam taislam, mbal iya taitung suku'ku sabab halam bogboganna paljanji'anku itu.” ");
INSERT INTO sml_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Magkallam lagi' Tuhan ma si Ibrahim, yukna, “Na, ya pasal h'ndanu si Saray, ngga'i na ka si Saray ya pangōnnu iya puwas itu, sagō' si Sara na. ");
INSERT INTO sml_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Buwananku iya kahāpan bo' aniya' anaknu l'lla min iya. Aho', tantu iya buwananku kahāpan manjari tahinang iya ina' ma kabangsa-bangsahan. Aniya' isab saga sultan luwas min panubu'na.” ");
INSERT INTO sml_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Na, pasujud magtūy si Ibrahim maka e'na anittowa. Yukna ma baranna, “Arī! Makabuwan tubu' gi' bahā' bang a'a dahatus tahun umulna? Maka'anak bahā' si Sara minsan siyampū' tahun umulna!” ");
INSERT INTO sml_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yukna isab ma Tuhan, “O Tuhan, bang pa'in mura-murahan pagka'inagonannu anakku si Isma'il!” ");
INSERT INTO sml_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Anambung Tuhan ma si Ibrahim, “Aho', makajari. Sagō' aniya' du anaknu l'lla min h'ndanu si Sara. Si Isa'ak ya pangōnnu iya. Pahogotku paljanji'anku ma iya sampay ma paltubu'anna salama-lama. ");
INSERT INTO sml_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na, ya pasal si Isma'il, takaleku isab bay pangamu'nu-i. Buwananku iya kahāpan, pahekaku panganakna bo' aheka to'ongan saga panubu'na. Manjari aniya' sangpū' a'a min panubu'na makapagdatu' ma sinosōng. Saga panubu'na isab nihinang e'ku bangsa ga'osan. ");
INSERT INTO sml_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Saguwā' anaknu si Isa'ak ya pahogotanku janji'ku. Nianakan du iya e' si Sara ma tahun balik sali' bulan itu.” ");
INSERT INTO sml_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Aubus pa'in e' Tuhan amalman ma si Ibrahim, magtūy iya ala'an. ");
INSERT INTO sml_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Na ma llaw ina'an-i, bineya' e' si Ibrahim panoho'an Tuhan ma iya. Taislam e'na anakna si Isma'il sampay kal'llahan kamemon ma deyomanna. Ya du isab saga ata bay nianakan ma deyomanna sampay saga ata bay tab'llina. ");
INSERT INTO sml_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ya umul si Ibrahim ma waktu pagislam ma iya maka si Isma'il, siyampū' maka siyam tahun. ");
INSERT INTO sml_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ya umul si Isma'il sangpū' maka t'lluntahun. ");
INSERT INTO sml_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Jari magdongan si Ibrahim maka anakna si Isma'il ni'islam ma dang'llaw du. ");
INSERT INTO sml_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tabeya' isab ni'islam ma llaw ina'an-i saga atana kamemon, a'a bay nianakan ma deyomanna sampay ata bay tab'llina. ");
INSERT INTO sml_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Manjari aniya' llaw magpa'nda' PANGHŪꞋ-Yawe ma si Ibrahim ma tongod kakayuhan pagduwa'ahan, ina'an ma tana' si Mamre. Alanga na llaw, maka ina'an si Ibrahim aningkō'-ningkō' ma bowa' lawang luma'na tolda. ");
INSERT INTO sml_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Na, ta'nda' e'na t'llungan a'a an'ngge-n'ngge ma dahuanna. Pag'nda'na itu, magtūy iya magdai'-dai' anampang sigām, maka e'na pasujud. ");
INSERT INTO sml_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Yukna ma sigām, “Saga tuwan, pahapit gi' kam ni luma' kami minsan mbal na apatut. ");
INSERT INTO sml_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Pabowahanta kam bohe' pangose' tape'bi bo' kam pahali-hali ma sindungan kayu itu. ");
INSERT INTO sml_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Bowahanta pa'in kam saga pagkakan isab minsan mbal na apatut. Subay na ahāp palasahanbi pabīng bo' yampa kam palanjal ni pal'ngngananbi.” Ya sambung sigām ma si Ibrahim, “Aho', magsukul.” ");
INSERT INTO sml_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Na, magdai'-dai' si Ibrahim pasōd ni deyom luma' tolda angalinganan si Sara. “Dāng,” yukna, “angā' ka tirigu ahāp, t'llu t'ppongna, bo' ka angahinang tinapay. Dai'-dai'un pa'in.” ");
INSERT INTO sml_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pagubus, magdai'-dai' si Ibrahim pehē' ni buluyan hayopna amene' dakayu' anak sapi' ahāp isina. Sinoho' sinumbali' ma sosoho'anna bo' niadjal saru'un-du'un. ");
INSERT INTO sml_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Jari asakap pa'in kamemon, binowa e' si Ibrahim gatas maka sapi' pangalabotna ma saga a'a-i. Hinabu sigām amangan, si Ibrahim magbaran amuhatan sigām ma lindung kayu. ");
INSERT INTO sml_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na, tinilaw e' sigām si Ibrahim, “Ma'ai h'ndanu si Sara?” Ya sambung si Ibrahim, “Ina'an ma deyom.” ");
INSERT INTO sml_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Manjari angallam PANGHŪꞋ-Yawe, “Ma tahun sinōng ilu, buwat bulan itu, pabalik du aku pi'itu. H'ndanu si Sara anganak du, l'lla ya anakna.” Na maina'an asal si Sara pakale-kale ma bukut lawang. ");
INSERT INTO sml_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ato'a iya, mbal na pinaglaha'. Maka si Ibrahim isab, ato'a na asal. ");
INSERT INTO sml_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Angkanna, pagkale si Sara ma bissala inān, tatittowa iya ati yukna ma deyom atayna, “Ē, buwattingga lagi' pagkōg kami maglakibini pagka ato'a na kami sali'-sali'?” ");
INSERT INTO sml_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sakali angallam PANGHŪꞋ ma si Ibrahim, yukna “Angay si Sara tatittowa? Angay buwattē' llingna, ya yukna, ‘Buwattingga e'ku anganak pagka aku ato'a na?’ ");
INSERT INTO sml_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aniya' bahā' ahunit ma si Yawe? Pahati ka, pagabut bulan bay pangahakaku ma ka'a pabalik du aku pi'itu, bo' h'ndanu si Sara anganak l'lla.” ");
INSERT INTO sml_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Na, tināw si Sara angkan iya maglimbung, yukna, “Halam aku bay atittowa.” Sagō' anambung Tuhan, yukna, “Allā! Bay ka anittowa.” ");
INSERT INTO sml_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Sakali itu palanjal na a'a t'llungan e'. Tinūran e' si Ibrahim sampay taromol e' sigām lahat Sodom. ");
INSERT INTO sml_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Manjari ah'lling PANGHŪꞋ, yukna, “Mbal limbunganku min si Ibrahim ya song hinangku ma lahat Sodom. ");
INSERT INTO sml_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Sababna in iya po'onan bangsa aheya maka abantug. Buwananku isab kahāpan saga bangsa manusiya' kamemon labay min iya. ");
INSERT INTO sml_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tapene'ku iya supaya iya amandu'an saga anak-mpuna ameya' ma kabaya'anku. Subay sigām angahinang ni kahāpan maka ni kabontolan, manjari tumanku to'ongan paljanji'anku ma iya.” ");
INSERT INTO sml_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Manjari amissala PANGHŪꞋ ma si Ibrahim, yukna, “Aniya' takaleku sumbungan pasal saga a'a ma da'ira Sodom maka Gomora, lumandu'an kono' la'at dusa sigām. ");
INSERT INTO sml_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Subay aku pehē' ang'nda' bang b'nnal saga sumbungan e'. Jari kata'uwanku bang b'nnal ka atawa mbal.” ");
INSERT INTO sml_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Sakali palanjal na duwangan min sigām-i pehē' ni lahat Sodom, sagō' pa'bba gi' Tuhan maina'an ma si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Na pasekot si Ibrahim pehē' ni PANGHŪꞋ, yukna, “O Panghū'ku, palamudnu bahā' a'a halam aniya' dusana pinagmulka'an sali'-sali' maka a'a taga-dusa? ");
INSERT INTO sml_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bang saupama,” yukna, “aniya' limampū' a'a abontol ma lahat e', pagmulka'annu bahā' kamemon? Mbal bahā' ka ma'ase' ma lahat inān ma sabab limampū' a'a abontol maina'an? ");
INSERT INTO sml_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bang pa'in du mbal pagsali'nu a'a halam aniya' dusana maka a'a taga-dusa, bang pa'in sigām mbal pagmulka'annu. Ka'a ya maghuhukum ma saga manusiya' kamemon ma deyom dunya, maka hukumannu subay abontol sadja.” ");
INSERT INTO sml_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Manjari ya sambung PANGHŪꞋ ma si Ibrahim, “Aho', bang aniya' tabākku ma lahat Sodom ilu limampū' a'a halam aniya' dusana, mbal du pagmulka'anku lahat ilu ma sababan sigām.” ");
INSERT INTO sml_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Manjari angallam si Ibrahim pabīng, yukna, “O Panghū'ku, manusiya' du aku, halam aniya' kawasaku, sagō' anawakkal aku angamu' ma ka'a pabīng. ");
INSERT INTO sml_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Bang saupama aniya' mpatpū' maka lima a'a abontol ma lahat inān, pagmulka'annu lagi' bahā' ma saukat kulang lima min heka a'a bay amu'ku-i?” Anambung isab PANGHŪꞋ, “Bang aniya' tabākku mpatpū' maka lima a'a abontol, mbal pagmulka'anku lahat ilu.” ");
INSERT INTO sml_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Na, ah'lling si Ibrahim pabalik, yukna, “O Panghū'ku, bang saupama aniya' mpatpū' du?” Ya sambung PANGHŪꞋ, “Aho', ma sabab mpatpū' a'a abontol, mbal pagmulka'anku lahat ilu.” ");
INSERT INTO sml_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Angamu' lagi' si Ibrahim, “Ndū' Panghū'ku, da'a akagit ataynu, dūlin aku angamu' pabīng. Bang saupama aniya' du t'llumpū' a'a tabāknu abontol, pagmulka'annu bahā'?” Ya sambung Tuhan, “Bang aniya' tabākku t'llumpū' a'a abontol, na, mbal pagmulka'anku lahat ilu.” ");
INSERT INTO sml_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Manjari angamu' na pa'in si Ibrahim, “Ampunun lagi' aku, O Panghū'ku, anawakkal gi' aku angamu' ma ka'a pabīng. Bang saupama aniya' tabāknu duwampū' du a'a halam magdusa, pagmulka'annu lagi' bahā'?” Ya sambung Tuhan, “Ma sabab duwampū' a'a abontol ilu, mbal du pagmulka'anku lahat ilu.” ");
INSERT INTO sml_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Manjari ya katapusan niamu' e' si Ibrahim, yukna, “O Panghū'ku, ndū', da'a akagit ataynu, ya sadja itu amu'ku ma ka'a. Bang saupama aniya' sangpū' sadja tabāknu mailu halam magdusa?” Na, ya sambung Tuhan, “Ma sabab sangpū' a'a, sagarin na, mbal na pagmulka'anku lahat ilu.” ");
INSERT INTO sml_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Manjari aubus pa'in kapagbissala PANGHŪꞋ maka si Ibrahim, ala'an na iya minnē'. Amole' isab si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Na, song na sangom, at'kka na duwa mala'ikat e' ni da'ira Sodom, hinabu si Lōt aningkō'-ningkō' ma atag lawang da'ira. Pag'nda' si Lōt ma duwangan itu, pasampang iya ma sigām maka e'na pasujud. ");
INSERT INTO sml_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Yuk si Lōt, “Saga tuwan, pahapit lagi' kam pi'itu ni luma'ku minsan mbal na apatut. Ngā'anta kam bohe' pangose' tape'bi. Labotta kam, ati maitu na kam atuli. Subay na subu bo' yampa kam palanjal.” Ya sambung sigām, “Sagarin na, maitu sadja kami atuli ma halaman itu.” ");
INSERT INTO sml_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Sagō' pinogos sigām e' si Lōt subay pinasōd ni luma'na, manjari ameya' na sigām. Magpanoho'an si Lōt ma saga sosoho'anna, sinō' magadjal sampay angahinang tinapay halam pinasuligan pangalabot ma sigām. Atahak pa'in, amangan na sigām. ");
INSERT INTO sml_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Na, halam lagi' sigām atuli, alibut na luma' si Lōt e' saga kal'llahan kamemon onde'-matto'a min sakalibutan da'ira Sodom inān. ");
INSERT INTO sml_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Angalingan sigām ma si Lōt, yuk sigām, “Oy, Lōt! Ma'ai na saga a'a bay bowanu ni luma'nu insini'-i? Paluwasun sigām pi'itu ni kami. Bilahi kami angusiba'an sigām duwangan.” ");
INSERT INTO sml_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Pagkale si Lōt, magtūy iya paluwas min luma'na. Tinambol e'na lawang ");
INSERT INTO sml_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ati yukna ma kal'llahan inān, “Saga tuwan, angamu' aku junjung ma ka'am. Da'a kam maghinang jahulaka' ilu. ");
INSERT INTO sml_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Pakale lagi' kam. O'o, itiya' duwangan anakku budjang. Soho'ku sigām paluwas pi'ilu ati baya'-baya'bi na. Da'a sadja saga a'a itu sabab itiya' sigām ma deyomanku, subay sigām halli'anku.” ");
INSERT INTO sml_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Saguwā' ya sambung saga kal'llahan Sodom e' ma si Lōt, yuk-i, “Pasebog ka minnilu! Sai sa ka'a ilu amituwa ma kami? Ka'a ilu ngga'i ka a'a minnitu. Na, bang ka mbal pasebog minnilu, hinang kami ma ka'a akalap lagi' min duwangan a'a ilu.” Magtūy nijudjalan si Lōt e' sigām ni bihing lawang, song to'ongan nilarak e' sigām tambolna inān. ");
INSERT INTO sml_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Daipara ya duwangan ma deyom-i makaukab lawang supaya tahella' si Lōt pareyom. Ma deyom pa'in, tinambol magtūy e' sigām lawang. ");
INSERT INTO sml_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Manjari saga l'lla kamemon ma luwasan luma', ai-na ka onde'-onde', ai-na ka matto'a, bay kasilawan e' a'a duwangan-i bo' mbal makabāk lawang. ");
INSERT INTO sml_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Manjari atilaw duwangan mala'ikat e' ma si Lōt, yuk sigām, “Aniya' lagi' kampungnu maitu ma lahat Sodom, anaknu d'nda-l'lla ka, atawa ayuwannu? Bang aniya', subay sigām bowanu alahi min da'ira itu ");
INSERT INTO sml_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","sabab lubu kami lahat itu. Takale asal e' PANGHŪꞋ-Yawe sumbungan pasal kala'atan saga a'a Sodom, makalandu' na to'ongan. Angkan kami sinoho' pi'itu e'na amaka'at katibu'ukan lahat itu.” ");
INSERT INTO sml_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Magtūy pehē' si Lōt ni duwangan l'lla ya tunang anakna budjang ati yukna, “O, pal'kkas kam, ala'an kam minnitu sabab lahat itu song nilubu e' PANGHŪꞋ.” Saguwā' mbal sigām am'nnal ma si Lōt. Pangannal sigām in iya hal maglata. ");
INSERT INTO sml_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pagdai' llaw pinogos si Lōt e' saga mala'ikat-i, yuk sigām, “Pal'kkas ka magmomos. Bowahun anak-h'ndanu ala'an min lahat itu bo' supaya kam mbal talapay pinagmulka'an e' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Saguwā' magduwa-ruwa lagi' si Lōt angkan iya arak taluwa' mulka', daipara ma'ase' PANGHŪꞋ ma iya. Niambit iya e' mala'ikat, iya baranna sampay h'ndana maka duwangan anakna budjang. Jari binowa sigām paluwas min da'ira he'. ");
INSERT INTO sml_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ma luwasan pa'in, ah'lling mala'ikat dangan, yukna, “Anginosog kam paragan bo' kam mbal magmula. Da'a kam pahogga' ma kapantayan ilu. Da'a kam minsan palingi'. Alahi sadja kam pehē' ni kabūd-būran supaya kam mbal talapay amatay.” ");
INSERT INTO sml_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Sagō' aniya' pah'lling si Lōt ma iya. “Oy da'a saga tuwanku,” yukna. ");
INSERT INTO sml_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","“Aheya pagsukulanku ma ka'am, tatabangbi ginhawa baranku. Sagō', ndū', alawak makalandu' kabūran e'. Marai' mbal tasampayku ati ta'abut mulka' aku. ");
INSERT INTO sml_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nda'un ba kauman inān, anahut asal maka asekot pi'itu. Bang bahā' tugutannu aku alahi pina'an, sabab ta'nda'nu kanahutna. Manjari asalamat du aku.” ");
INSERT INTO sml_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Na, ya sambung mala'ikat ma si Lōt, “Aho', makajari kam pina'an. Mbal du paka'atku kauman ina'an-i. ");
INSERT INTO sml_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Saguwā' paragan kam pahāp. Subay kam at'kka pehē' bo' yampa lanjalanku hinangku.” Manjari ya kauman kapē'an disi Lōt inān, kaōnan Sowar ma sabab bissala si Lōt, ya yukna anahut-nahut kono'. ");
INSERT INTO sml_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Na, pagt'kka disi Lōt ni Sowar yamboho' pasobang mata llaw. ");
INSERT INTO sml_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lahat Sodom maka lahat Gomora he' pinatumbukan ulan api e' PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Manjari kamulka'an e'na duwa lahat e'. Talapay isab saga kaluma'an ma kaluha'an kapantayan inān sampay manusiya'na kamemon sampay isab paltomo'-tomo'anna kamemon. ");
INSERT INTO sml_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Sagō' bay palingi' h'nda si Lōt ni buli'anna ati tahinang iya magtūy batu asin. ");
INSERT INTO sml_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na, pagsalung dakayu' bo' subu-subu lagi', magdai'-dai' si Ibrahim pabīng pehē' ni bay pat'nggehanna ma matahan PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Niromolan e'na karatagan lahat Sodom maka Gomora. Humbu sadja ya ta'nda'na maina'an, sali' humbu tapahan aheya makalandu'. ");
INSERT INTO sml_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Daipara kinannal si Ibrahim e' Tuhan hinabuna amat'kka mulka' ma saga da'ira bay paglahatan si Lōt. Hatina si Ibrahim ya sababna angkan si Lōt pinapuwas e' Tuhan min mulka'. ");
INSERT INTO sml_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Na, si Lōt maka duwa anakna budjang inān tināw maglahat ma lahat Sowar. Manjari ala'an sigām pehē' ni kabūd-būran ati mahē' na sigām pat'nna' ma deyom dakayu' songab batu. ");
INSERT INTO sml_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dakayu' llaw magsuli-suli anak si Lōt karuwangan. Yuk siyaka ma siyali, “Nneng, ato'a na si Mma' maka halam na aniya' l'lla ma lahat itu tahinangta h'lla buwat kabiyaksahan manusiya'. ");
INSERT INTO sml_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Gom lagi' palangota si Mma', jari maghulid kita maka iya bo' supaya aniya' tubu'ta.” ");
INSERT INTO sml_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na pagsangom pa'in, pinalango si Lōt e' anakna-i ati pabihing ni iya anakna siyaka. Halam tasayu e' si Lōt sabab nilango iya. ");
INSERT INTO sml_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pag'llaw, amissala siyaka ma siyali, yukna, “Aku ya bay ma bihing si Mma' dibuhi'. Na, sangom ilu, palangota iya pabīng ati ka'a na ya pabihing atuli. Manjari,” yukna, “sali'-sali' kita makabāk tubu' min mma'ta.” ");
INSERT INTO sml_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Sakali itu pagsangom pa'in, pinalango si Lōt e' duwangan anakna bo' pabihing ni iya anakna siyali. Halam du isab aniya' ai-ai tasayu e' si Lōt sabab nilango iya. ");
INSERT INTO sml_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Manjari ab'ttong e' si Lōt duwangan anakna. ");
INSERT INTO sml_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Siyaka anganak l'lla ati ōnanna Mowab. Si Mowab itu ya na po'onan saga bangsa Mowab buwattina'an. ");
INSERT INTO sml_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ya du anak si Lōt siyali, anganak isab l'lla ati niōnan e'na Bin-ammi. Manjari si Bin-ammi itu, ya na po'onan saga bangsa Ammon buwattina'an. ");
INSERT INTO sml_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Na, maglain disi Ibrahim min lahat Mamre tudju ni Negeb ma lahat Kana'an bo' pahanti' ma tonga'an Kades maka Sūr. Puwas e', palanjal sigām ni da'ira Gerar, ati ma Gerar pa'in, ");
INSERT INTO sml_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","angahaka si Ibrahim pasal h'ndana si Sara, in iya danakanna kono'. Manjari pagta'u itu e' si Abimelek, ya sultan ma lahat Gerar, pinabowa e'na si Sara bo' hinangna h'nda. ");
INSERT INTO sml_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pagsangom pa'in, pinauppihan si Abimelek e' Tuhan. Yuk Tuhan ma iya ma deyom uppina, “Amatay ko' ka'a ilu sabab d'nda bay ta'ā'nu ilu taga-h'lla asal.” ");
INSERT INTO sml_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Na, halam gi' makabihing si Abimelek ni si Sara, angkan iya anambung ma Tuhan, yukna, “O Panghū'ku, papataynu aku bahā', sampay saga a'aku, ma halam aniya' dusaku? ");
INSERT INTO sml_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Bay aku nihaka'an e' si Ibrahim ya d'nda itu danakanna kono'. Ya du d'nda-i, bay angahaka isab in sigām magdanakan kono'. Tu'ud aku a'awam, halam kata'uwanku in iya taga-h'lla, maka halam aku makahinang ala'at.” ");
INSERT INTO sml_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Manjari ya sambung Tuhan ma si Abimelek ma deyom uppina, “Aho', kata'uwanku a'awam ka. Angkan ka bay sagga'ku bo' mbal makasekot ni iya, maka mbal isab makahinang dusa ma aku. ");
INSERT INTO sml_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Na, papole'un na d'nda ilu pehē' ni h'llana. Nabi asal iya ati angamu'-ngamu' iya ni aku ma pasalnu supaya ka mbal amatay. Sagō' bang saupama mbal papole'nu, tantu du ka amatay sampay saga a'a ma deyomannu kamemon.” ");
INSERT INTO sml_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Pagsubu-subu pa'in, pinatimuk e' si Abimelek kamemon saga tendogna supaya pata'una sigām pasal bay tumaluwa' ma iya inān. Magtūy aheya tāw sigām. ");
INSERT INTO sml_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Si Ibrahim isab sinō' patampal ni si Abimelek bo' tilawna, yukna, “Ala'at pahāp hinangnu ma kami! Ai dusaku ma ka'a ya angkan kami maka bebeya'anku katōngannu dusa landu' aheya itu? Mbal manjari! ");
INSERT INTO sml_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ai po'onanna ya angkan ka makahinang buwattilu?” ");
INSERT INTO sml_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Na, ya sambung si Ibrahim, “Tuwan sultan, pangannalku halam aniya' ma lahat itu tināw ma Tuhan. Angkanna ya ma deyom atayku binono' du aku bo' ta'ā' h'ndaku. ");
INSERT INTO sml_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","B'nnal isab, magdanakan kami, da'mma', duwa ina'. Jari tahinangku iya h'nda. ");
INSERT INTO sml_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na, ma masa bay panoho' Tuhan ma aku subay palawak min deyoman mma'ku, bay sa yukku ma h'ndaku, ‘Bang ka sab'nnal-b'nnal ma'ase' ma aku, pi'ingga-pi'ingga lahat kat'kkahanta angahaka ka in kita magdanakan.’ ” ");
INSERT INTO sml_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Na, pagkale lling itu e' si Abimelek, pinapole' e'na si Sara ni si Ibrahim. Aniya' isab saga bili-bili, saga sapi' maka saga ata d'nda-l'lla pamuwan e' si Abimelek ma si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Amissala lagi' iya ma si Ibrahim, yukna, “Nda'un luha lahatku itu. Amene' ka maingga-maingga kabaya'annu pat'nna'an.” ");
INSERT INTO sml_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Yukna isab ma si Sara, “Itiya' buwananku danakannu dangibu pilak dī pilak pangandiyat kasā'anku, paltanda'an in ka'a halam bay makahinang dusa minsan ai.” ");
INSERT INTO sml_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Na, saga kar'ndahan kamemon ma okoman si Abimelek bay pinatigangan kandang e' PANGHŪꞋ-Yawe ma sabab kapangā'na ma si Sara h'nda si Ibrahim. Jari angamu'-ngamu' si Ibrahim ni Tuhan ma pasalan disi Abimelek, ati nirūlan pangamu'-ngamu'na. Hatina kauli'an si Abimelek maka h'ndana sampay saga ipatanna d'nda ati maka'anak sigām pabīng. ");
INSERT INTO sml_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Na, tinuman e' PANGHŪꞋ-Yawe bay panganjanji'na ma si Sara, kabuwanan iya kahāpan. ");
INSERT INTO sml_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Hatina ab'ttong iya ati anganak iya l'lla. Jari taga-anak na si Ibrahim ma kato'ana. Ya waktu kapanganak si Sara ya na waktu asal bay pangallam Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Manjari si Isa'ak ya pangōn si Ibrahim ma anakna min si Sara. ");
INSERT INTO sml_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ta'abut pa'in walumbahangi si Isa'ak ma luwasan, magtūy iya ni'islam e' si Ibrahim buwat bay panoho'an Tuhan ma iya. ");
INSERT INTO sml_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Dahatus tahun na umul si Ibrahim ma waktu kapanganak ma si Isa'ak e'. ");
INSERT INTO sml_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sakali ang'bbat si Sara, yukna, “Itiya' aku kabuwanan kakōgan maka pagtittowahan e' Tuhan. Sasuku isab makakale ma pasal itu-i magbeya' du magtittowa maka aku.” ");
INSERT INTO sml_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Yukna lagi', “Ma waktu dahū halam aniya' a'a makatawakkal ah'lling ma si Ibrahim in aku itu makaparuru' gi'. Sagō' itiya' aku kabuwanan anak minsan ato'a na h'llaku.” ");
INSERT INTO sml_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Na, aheya-heya pa'in si Isa'ak, nilutas iya min ina'na. Manjari aheya jajamuhan pinasakap e' si Ibrahim ma llaw kalutas onde' inān. ");
INSERT INTO sml_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pagubus, ta'nda' e' si Sara anakna si Isa'ak pinagtittowahan e' onde'-onde' ya anak si Ibrahim min si Hajara ya bangsa Misil. ");
INSERT INTO sml_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sakali ah'lling si Sara ni si Ibrahim, yukna, “Tuwanku, pala'anun banyaga' itu maka anakna si Isma'il. Mbal iya subay binahagi'an alta' ya pamusaka'nu ma anakta si Isa'ak.” ");
INSERT INTO sml_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na, pagkale si Ibrahim ma lling h'ndana-i, landu' iya asusa sabab anakna du isab si Isma'il. ");
INSERT INTO sml_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Saguwā' magsuwala Tuhan ma si Ibrahim, yukna, “Da'a ka asusa pasal onde' ilu maka ina'na ya atanu. Beya'un sadja pah'lling si Sara ma ka'a, sabab si Isa'ak ya po'onan paltubu'annu. ");
INSERT INTO sml_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ya pasal anak si Hajara, pahekaku panubu'na sampay sigām tahinang bangsa, sabab anaknu du iya.” ");
INSERT INTO sml_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Sakali pagsalung, subu-subu pa'in, aniya' sinakap e' si Ibrahim kinakan maka kuwit kambing isihan bohe'. Pinatanggung e'na ma baha si Hajara bo' yampa pinatulak e'na, iya maka anakna si Isma'il. Jari pal'ngngan-l'ngngan sigām ma paslangan lahat Be'erseba bo' halam sali' aniya' patudjuhan sigām tantu. ");
INSERT INTO sml_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Na, aubus pa'in bohe' bay lutu' sigām, ka'bbahan e' si Hajara anakna ma lindung kayu areyo'-deyo'. ");
INSERT INTO sml_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Paokat iya saga limampū' d'ppa lawakna aningkō'. Ya ma pikilanna, “Arōy, mbal aku makasandal ang'nda' bang amatay anakku.” Jari magdohon iya pagtingkō'na ma tongod ina'an. ");
INSERT INTO sml_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Daipara takale tangis onde'-onde' inān e' Tuhan. Magtūy aniya' suwala mala'ikat min deyom sulga' ah'lling ni si Hajara, yuk-i, “O Hajara, angay ka asusa? Da'a ka tināw sabab takale e' Tuhan pagtangis anaknu hinabuna palege ma dambila' ilu. ");
INSERT INTO sml_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Bangunun iya bo' ambitun pahāp, sabab ma sinosōng hinangku paltubu'anna bangsa ga'osan.” ");
INSERT INTO sml_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Sakali itu aniya' bohe' pama'nda' Tuhan ma si Hajara. Magtūy iya pehē' anauk bo' pin'nno'an kuwit kambing ya bay bowana, ati pamainum e'na ma anakna inān. ");
INSERT INTO sml_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Manjari si Isma'il itu halam bay pinasagaran e' Tuhan hinabuna pasulig. Ina'an iya maglahat ma Paslangan Paran. Apanday asal si Isma'il magpana' hayop talun. ");
INSERT INTO sml_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mahē' pa'in sigām ma lahat Paran, aniya' d'nda niā' min lahat Misil e' si Hajara pamah'ndana ma si Isma'il. ");
INSERT INTO sml_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na ma masa ina'an-i, pinehē' si Ibrahim e' sultan Abimelek maka si Pikul, nakura' kasundaluhanna. Yuk si Abimelek ma si Ibrahim, “Tuwan, kata'uwanku in ka'a tinabang sadja e' Tuhan ma ai-ai hinangnu. ");
INSERT INTO sml_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Manjari aniya' maksudku ni ka'a. Anapa ka maitu ma matahan Tuhan in ka'a mbal angakkal ma aku sampay ma anak-mpuku tubu'-manubu'. Bay aku amogbogan ka'a, manjari ka'a isab subay amogbogan aku sampay saga a'a kamemon ma deyom lahat ya pahanti'annu itu.” ");
INSERT INTO sml_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Anambung si Ibrahim, yukna, “Aho' tuwan, anapa aku.” ");
INSERT INTO sml_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sakali itu aniya' palkala' pagdugalan si Ibrahim ma si Abimelek. Aniya' kono' bohe' kali si Ibrahim bay niagaw e' saga tendog si Abimelek. ");
INSERT INTO sml_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ya sambung si Abimelek, “Tuwan, mbal kata'uwanku bang sai magkahinangan ya yuknu ilu. Halam aku asal bay pata'unu, yamboho' takaleku ma buwattina'an.” ");
INSERT INTO sml_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Manjari aniya' saga bili-bili maka sapi' binowa e' si Ibrahim pamuwanna ma si Abimelek bo' aniya' kapagsulutan sigām ahogot. ");
INSERT INTO sml_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aniya' isab pitu' anak bili-bili, d'nda lullun, pinasaddī pa'ataganna min ba'anan bili-bilina kasehe'. ");
INSERT INTO sml_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Magtūy iya tinilaw e' si Abimelek, yukna, “Pamagaynu anak bili-bili pitu' hekana ya pasaddīnu ilu?” ");
INSERT INTO sml_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ya sambung isab si Ibrahim, “Tuwan sultan, taima'un kono' pitu' anak bili-bili itu paltanda'an in aku bay amakali bohe' he'.” ");
INSERT INTO sml_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ya he' sababna angkan lahat inān kaōnan Be'erseba, sabab bay pagsapahan si Ibrahim maka si Abimelek. ");
INSERT INTO sml_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Aubus pa'in sigām maghinang paljanji'an maina'an ma lahat Be'erseba, amole' na disi Abimelek maka si Pikul ni lahat sigām bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Na aniya' po'on kayu tamaris tinanom e' si Ibrahim ma lahat Be'erseba-i ati maina'an iya anabbut ma ōn Yawe, ya Tuhan kakkal salama-lama. ");
INSERT INTO sml_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Manjari at'ggol kapaglahat disi Ibrahim ma lahat bangsa Pilistin e'. ");
INSERT INTO sml_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na, at'ggol-t'ggol pa'in, sinulayan si Ibrahim e' Tuhan. Nilinganan iya, “O Ibrahim!” Magtūy anaul si Ibrahim, yukna, “Itiya' aku.” ");
INSERT INTO sml_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ya lling Tuhan ma iya, “Bowahun anaknu tunggal ilu, si Isa'ak ya kalasahannu to'ongan, pehē' ni lahat Muriya. Tō'anta ka būd ya pamowahannu iya. Jari pagt'kkabi pehē', sumbali'un iya bo' tunu'un pagkulbannu ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Dai' llaw pa'in, abati' na si Ibrahim an'tta' kayu panunu' sumbali'an. Niruwa' magtūy ni kura'na maka binowa isab anakna si Isa'ak maka duwa sosoho'anna. Jari palintas sigām tudju pehē' ni atag bay panoho'an Tuhan ma iya. ");
INSERT INTO sml_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ta'abut pa'in kat'llu llawna, ta'nda' e' si Ibrahim būd ya patudjuhan sigām min kalawakan lagi'. ");
INSERT INTO sml_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yuk si Ibrahim ma duwangan sosoho'anna, “Angagad kam maitu maka kura' ilu. Aku maka onde' itu palanjal gi' ni atag e' maghinang ni Tuhan. Pabīng du kami pi'itu bang aubus na.” ");
INSERT INTO sml_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Manjari nihawas e' si Ibrahim kayu panunu' kukulbanan, ati pinatanggung e'na ma baha si Isa'ak. Si Ibrahim ya amowa lahut maka baga pangapi ati magbeya' sigā patukad. ");
INSERT INTO sml_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Pasalta', ah'lling si Isa'ak ni mma'na, yukna, “Mma'!” Anambung si Ibrahim, “Ai, Otō'?” Ya lling si Isa'ak, “Mma', ilu ma ka'a baga pangandokot api, maka itiya' ma aku saga kayu. Sagō' maingga bahā' anak bili-bili ya sinumbali' maka tinunu' pagkulbanta?” ");
INSERT INTO sml_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Anambung magtūy si Ibrahim, yukna, “Otō', Tuhan du ya amaniya' bili-bili pagkulbanta.” Manjari palanjal na sigā karuwangan. ");
INSERT INTO sml_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Na, makat'kka pa'in sigā ni būd bay panō' Tuhan ma si Ibrahim e', magtūy iya anambak batu pagtunu'an kulban. Aubus pa'in, pinat'nna' kayu ma diyata'na ati niengkotan anakna si Isa'ak bo' yampa palegena ma diyata' kayu. ");
INSERT INTO sml_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Puwas e' niā' bari' e' si Ibrahim panumbali' anakna. ");
INSERT INTO sml_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Malaingkan aniya' mala'ikat PANGHŪꞋ angalingan min deyom sulga', yukna “Ibrahim! O Ibrahim!” Anaul magtūy si Ibrahim, “Itiya' aku.” ");
INSERT INTO sml_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ah'lling mala'ikat-i, “Da'a sumbali'un anaknu! Da'a iya inayun! Kata'uwanku na in ka'a magmahaltabat sab'nnal-b'nnal ma Tuhan. Sabab minsan anaknu tunggal halam ka'llogannu, gom pa'in tukbalannu ni Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Na palingi' si Ibrahim ati aniya' ta'nda'na dakayu' bili-bili l'lla sumagnat tandukna ma kayu. Magtūy ningā' e'na bo' yampa sinumbali'. Jari tinunu' pagkulban ni Tuhan, pangangganti' baran anakna. ");
INSERT INTO sml_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ya pangōn si Ibrahim ma lugal inān ‘Yawe-Yiri,’ hatina, ‘Pinaniya'an kitam e' PANGHŪꞋ.’ Sampay isab ni kabuwattituhan ya pangōn a'a ma lahat inān, yuk sigām, “Ma būd si Yawe kitam pinaniya'an e'na.” ");
INSERT INTO sml_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nilinganan si Ibrahim pabīng min deyom sulga'. Mala'ikat PANGHŪꞋ ya angalingan, kaminduwana na. ");
INSERT INTO sml_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Yukna, “Ibrahim, aku itu si Yawe ya angallam itu ma ka'a, maka ōnku luggiya' ya pamahogotan janji'ku. Bay ka ameya' ma panoho'anku ati halam ka'llogannu anaknu tunggal, gom pa'in tukbalannu ni aku. ");
INSERT INTO sml_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ya he' sababna angkan aku amat'nna'an ka'a lidjiki' aheya, lidjiki' tuman. Pahekaku du panubu'nu, sali' heka bitu'un ma diyata' langit atawa heka solagan gusung ma bihing tahik. Anganda'ug sadja saga panubu'nu ati ta'agaw e' sigām lahat bay suku' kabantahan sigām. ");
INSERT INTO sml_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Manjari bangsa kamemon ma deyom dunya angamu' kahāpan du min aku pinasali' ni kahāpan ya pamuwanku ma panubu'nu. Angkan buwattē', sabab bay ka ameya' ma panoho'anku.” ");
INSERT INTO sml_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Puwas e' pabalik na disi Ibrahim ni saga sosoho'anna. Jari magbeya' sigām amole' pehē' ni lahat Be'erseba ati mahē' sigām pat'nna'. ");
INSERT INTO sml_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Na at'ggol-t'ggol pa'in, kahaka'an si Ibrahim pasal danakanna si Nahor. Aniya' anakna min h'ndana si Milka, walu' hekana. ");
INSERT INTO sml_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ya siyaka to'ongan si Ūs, ya pasunu' si Būs, bo' si Kimuwil mma' si Aram. ");
INSERT INTO sml_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Puwas si Kimuwil si Kesed, bo' si Haso, bo' si Pildas, bo' si Jidlap, bo' kasiyalihan to'ongan si Bituwil ");
INSERT INTO sml_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ya mma' si Ripka. Ya na ina'an saga anak l'lla si Milka h'nda si Nahor danakan si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Aniya' isab kalu'a si Milka, ōnna si Rema. Taga-anak isab iya mpat. Ya siyaka si Teba, pasunu' si Gaham, bo' si Tahas, bo' si Ma'aka ya kasiyalihan. ");
INSERT INTO sml_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Na si Sara, ta'abut pa'in dahatus maka duwampū' maka pituntahun umulna, ");
INSERT INTO sml_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","amatay na iya ma lahat Kana'an, ma kauman Hebron, ya kaōnan Kiriyat-Aba ma waktu bay palabay. Manjari pareyom si Ibrahim anangisan h'ndana. ");
INSERT INTO sml_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Aubus pa'in, pabuhat iya min bihing mayat h'ndana bo' paluwas amowa saga bangsa Hīt maggara'. Yukna ma sigām, ");
INSERT INTO sml_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Saga tuwan, aku itu a'a liyu maglihan sadja ma deyomanbi. Ya amu'ku ma ka'am, amab'lli kono' kam tana' bo' aniya' pangubulanku h'ndaku.” ");
INSERT INTO sml_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Anambung saga a'a bangsa Hīt ma si Ibrahim, yuk-i, ");
INSERT INTO sml_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tuwan, kalehun kono'. Bang ma kami ka'a ilu a'a alanga, patut pinagaddatan. Kubulun h'ndanu ma deyom tampat kami ya katapusan ahāp. Amene' ka kono' maingga-maingga kabaya'annu pangubulan. Halam aniya' min kami makapagin'mbal ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Na, pakuru' magtūy si Ibrahim ma dahuan saga a'a Hīt, ya bangsa tag-lahat, bo' yukna ma sigām, ");
INSERT INTO sml_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Bang aku parūlbi angubul h'ndaku maitu, magpati'llot kam ma aku maka si Epron anak si Sohar. ");
INSERT INTO sml_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Suli-sulihinbi iya pasal songab batu ya ma tōng tana'na, ya ma jadjahan lahat Makpela inān. Bang iya bilahi amab'lli, na, b'lliku du minsan pila pangahalga'na ma aku, jari hinangku pagkubulan. Maitu du aku magbayad ma dahuanbi kamemon.” ");
INSERT INTO sml_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Na maina'an asal si Epron samatingkō' maka kasehe'anna bangsa Hīt ya patimuk ma atag lawang pagsōd-luwasan da'ira inān. Magtūy sambunganna si Ibrahim ma pagkalehan sigām kamemon, yukna, ");
INSERT INTO sml_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tuwan, kalehun kono' pah'llingku itu. In tana' ilu sampay songab batuna pamuwanku du ma ka'a. Saksi'ku saga lūng-kampungku itu. Na, taima'un kono' pangubulannu h'ndanu.” ");
INSERT INTO sml_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Na, pakuru' si Ibrahim pabīng ma dahuan sigām bangsa Hīt. ");
INSERT INTO sml_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ah'lling iya ma si Epron ma pagkalehan sigām kamemon, yukna, “Tuwan, kalehun aku. B'lliku tana' ilu kamemon. Bayaranta ka pila-pila halga'na. Taima'un kono' bayad itu supaya aku makakubul mayat h'ndaku mahē'.” ");
INSERT INTO sml_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Anambung magtūy si Epron, yukna, ");
INSERT INTO sml_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tuwan, ya halga' tana' ilu mpat hatus pilak sadja. Saguwā' pamagayta ilu-i? Kubulun na h'ndanu pehē'.” ");
INSERT INTO sml_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Na kasulutan si Ibrahim ma bay pangahalga' si Epron ma pagkalehan saga a'a inān kamemon. Tinimbang e' si Ibrahim mpat hatus pilak tibu'uk ma buwat pagtimbang saga palilitu ma waktu ina'an-i, ati bayaranna na. ");
INSERT INTO sml_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Manjari palsuku'an si Ibrahim na tana' si Epron, ya ma jadjahan Makpela ma bihing lahat Mamre. Palsuku'anna na tana' maka songab batu, sampay kakayu-kayuhan kamemon isab ya ma deyomna. ");
INSERT INTO sml_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Manjari kasaksi'an e' a'a bangsa Hīt kamemon ya magtimuk maina'an ma pagsosōran da'ira, in si Ibrahim na tag-dapu tana' inān. ");
INSERT INTO sml_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Aubus pa'in, kinubul e' si Ibrahim h'ndana si Sara ma deyom songab batu inān ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Na, ya na he'. Ya tana' maka songab batu bay ma a'a bangsa Hīt palsuku'an na ma si Ibrahim, pagkubulanna. ");
INSERT INTO sml_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na, ato'a na to'ongan si Ibrahim. Aheka asal kahāpan bay pamuwan iya e' PANGHŪꞋ-Yawe ma ai-ai hinangna. ");
INSERT INTO sml_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Manjari aniya' dakayu' llaw ah'lling si Ibrahim ma dakayu' sosoho'anna, ya tag-ntanan pangalta'na kamemon. Yukna, “Dai' ka. Pat'nna'un tangannu ma llotan pa'aku. ");
INSERT INTO sml_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Anapa ka ma ōn Yawe, ya Tuhan tag-sulga' maka dunya, da'a pah'nda'in anakku si Isa'ak ni d'nda min bangsa Kana'an, ya tag-lahat pat'nna'anku itu. ");
INSERT INTO sml_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Pehē' ka gom pa'in ni saga kakampunganku mahē' ma lahatku porol, ati piha'in si Isa'ak d'nda minnē' pamah'nda ma iya.” ");
INSERT INTO sml_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Manjari tinilaw si Ibrahim e' sosoho'anna-i, yukna, “Tuwan, bang saupama mbal bilahi d'nda ameya' ma aku pi'itu ni lahat itu, ai subay hinangku? Bowaku anaknu pehē' bahā', ni bay lahatnu tagna'?” ");
INSERT INTO sml_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ya sambung si Ibrahim, “Oy da'a! Amay-amay, da'a bowahun anakku pehē'. ");
INSERT INTO sml_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Si Yawe ya Tuhan tag-sulga' bay amapi'itu aku min lahatku porol maka min kakampunganku. Aniya' isab janji' pagkallamna ma aku. Lahat itu kono' pamuwanna du ma saga panubu'ku. Tantu du Tuhan itu amabeya' mala'ikatna parahū min ka'a anakap ai-ai supaya ka makapiha d'nda minnē' pamah'nda ma anakku si Isa'ak. ");
INSERT INTO sml_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Malaingkan,” yuk si Ibrahim, “bang d'nda ilu mbal bilahi ameya' ma ka'a pi'itu, puwas na ka min palkala' ya pagsapahanta itu. Ya sadja pangamay-ngamayku ma ka'a, da'a bowahun anakku pehē'.” ");
INSERT INTO sml_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Magtūy anapa sosoho'an si Ibrahim pasal ina'an-i, maka pinat'nna' tanganna ma deyo' pa'a nakura'na. ");
INSERT INTO sml_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pagubus, sinakap e'na unta' si Ibrahim sangpū' hekana, niruwa'an ginisan alta' bo' aniya' kasampangan. Jari pauntas iya tudju pehē' ni kauman si Nahor ma lahat Mesopotami. ");
INSERT INTO sml_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Palabay pa'in daka pilang'llaw, at'kka na sosoho'an si Ibrahim pehē' ni kaluma'an si Nahor, ati pinatingkō' e'na saga unta' ma atag bohe' ya ma luwasan kaluma'an. Abay kohap na lahat, waktu pagā' bohe' e' saga kar'ndahan. ");
INSERT INTO sml_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Manjari angamu'-ngamu' iya ma Tuhan, yukna, “O Yawe, ya pagtuhanan nakura'ku si Ibrahim, tabangin aku llaw itu bo' ta'ā'ku maksudku. Pa'nda'in isab lasanu maka ase'nu ma nakura'ku he'. ");
INSERT INTO sml_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Itiya' aku an'ngge ma tongod pagbohe'an, maka ilu na isab saga kabudjangan pi'itu min kaluma'an supaya angā' bohe'. ");
INSERT INTO sml_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na, bang sigām ganta' palūd pi'itu, ya pah'llingku ma dakayu' min sigām, ‘Arung, painumun lagi' aku bohe' min kibutnu ilu.’ Na, bang iya ina'an d'nda ya asal tapene'nu pamah'nda ma sosoho'annu si Isa'ak, na, mura-murahan bang pa'in buwattitu panambungna: ‘Aho' tuwan, anginum ka, maka ngā'anta lagi' ka bohe' pamainum saga unta'nu.’ Na, bang hati' buwattē', magtūy kata'uwanku in kasi-lasanu ma nakura'ku aheya to'ongan.” ");
INSERT INTO sml_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Manjari itu, halam gi' aubus pangamu'-ngamu'na, aniya' budjang palūd pina'an magtanggung kibut, ōnna si Ripka. Na, mma' si Ripka itu si Bituwil, anak si Nahor maka si Milka. Si Nahor itu magdanakan maka si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ahāp d'nda si Ripka, alingkat to'ongan, maka halam bay makalabay l'lla. Palūd iya ni bohe' angisihan kibutna bo' yampa patukad pabalik. ");
INSERT INTO sml_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Pal'kkas magtūy sosoho'an si Ibrahim anampang iya, yukna, “Arung, painumun lagi' aku bohe' min kibutnu ilu.” ");
INSERT INTO sml_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ya sambungna, “Aho', Tuwan, anginum na ka.” Magtūy pinareyo' kibutna supaya makainum a'a-i. ");
INSERT INTO sml_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Aubus pa'in e'na anginum, yuk budjang ma iya, “Angagad gi' ka, tuwan, ngā'anku lagi' bohe' pamainum saga unta'nu sampay sigām asso.” ");
INSERT INTO sml_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Magtūy tinuwangan isi kibutna pehē' ni pagi'inuman saga hayop, ati magkuwat-kuwat iya angā' bohe' sampay tapainumna kamemon. ");
INSERT INTO sml_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Halam ah'lling sosoho'an-i. Hal ang'nda'-ng'nda' maka e'na maghona'-hona' bang kalu ta'ā'na maksudna sabab tabang min PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Aubus pa'in anginum saga unta' inān, aniya' kasampangan nihawas e' sosoho'an-i min duwa'anna: dakayu' singsing ahalga' maka duwa gallang aheya, bulawan lullun, ati pamuwanna ma budjang-i. ");
INSERT INTO sml_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Puwas e' atilaw iya ma budjang, yukna, “Arung, sai mma'nu? Makajari kami atuli ma luma'bi sangom ilu? S'ddong bahā'?” ");
INSERT INTO sml_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Yuk sambung budjang, “Mma'ku si Bituwil, mbo'ku si Nahor maka si Milka. ");
INSERT INTO sml_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Aheka parang-parang kami pamakan saga unta'nu, aniya' isab kapantayan paghali-halian. Maka luma' kami aheya du isab.” ");
INSERT INTO sml_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Magtūy pakuru' sosoho'an inān amudji PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Yukna, “Pudjiku si Yawe ya pagtuhanan nakura'ku si Ibrahim, pagka itiya' pa'nda'anna lasana maka ase'na ma iya. B'nnal-b'nnal katō'an aku e'na lān tudju ni kakampungan nakura'ku.” ");
INSERT INTO sml_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Sakali itu magdai'-dai' budjang-i parahū amole' ni pagluma'an ina'na. Kasuli-sulihan sigām kamemon pasal bay kahālanna inān. ");
INSERT INTO sml_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Na aniya' danakan si Ripka l'lla ōnna si Leban. Pagkale si Leban itu ma suli-suli si Ripka, maka pag'nda'na isab singsing ma ūngna maka gallang ma l'ngngonna karuwambila', magtūy iya magdai'-dai' pehē' ni bohe'. Ta'nda'na a'a bay panuli-nuli e' danakanna an'ngge maina'an ma bihing saga unta'na. ");
INSERT INTO sml_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yuk si Leban ma iya, “O tuwan, ka'a binarakatan e' Tuhan. Angay ka paddas maitu? Sūng kita pehē' ni luma'. Sakap na ma ka'a maka aniya' isab palegehan kaunta'annu.” ");
INSERT INTO sml_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Manjari pehē' a'a-i ni luma', ati nihawasan saga duwa'an min bukut saga unta'na e' si Leban. Pinakan isab unta' he' maka pinat'nna'an parang-parang pabahakan. Aniya' isab bohe' binowahan sosoho'an si Ibrahim maka saga sehe'na pangose' tape' sigām. ");
INSERT INTO sml_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Pagbuhat pa'in lalabotan ma sosoho'an si Ibrahim-i, ah'lling iya, yukna, “Mbal lagi' aku amangan, tuwan. Subay paluwasku gawiku dahū.” Yuk si Leban, “Na aho', paluwasun kono'.” ");
INSERT INTO sml_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Jari ah'lling na, yukna, “In aku itu sosoho'an si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Aheya kahāpan tapamuwan si Yawe ma iya, manjari dayahan na. Ya pamuwan Tuhan ma iya ba'anan hayop kaginisan, angkan jukup iya ma bili-bili, kambing, sapi', unta' maka kura'. Aheka isab bulawan kaginisan, aheka isab atana d'nda-l'lla. ");
INSERT INTO sml_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na h'ndana si Sara bay anganak l'lla ma kato'ana, ati pamusaka' na e' si Ibrahim ma anakna itu karayana kamemon. ");
INSERT INTO sml_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Manjari aku itu bay binowa magsapa e' nakura'ku he'. Yukna ma aku, ‘Da'a pah'nda'in anakku si Isa'ak d'nda minnitu min lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Subay ka pehē' ni kakampunganku, ni dī kausbahanku bo' supaya ka amiha d'nda maina'an pamah'nda ma anakku.’ ");
INSERT INTO sml_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Magtūy tilawku nakura'ku, yukku, ‘Bang saupama aniya' d'nda tapihaku sagō' mbal bilahi ameya' ma aku pi'itu ni lahat itu, painay?’ ");
INSERT INTO sml_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ya sambungna ma aku, ‘Ya PANGHŪꞋ pagbeya'anku, tantu iya anoho' mala'ikatna anehe'an ka'a supaya ta'ā'nu maksudnu. Tantu aniya' d'nda min kakampunganku tabowanu pamah'nda ma anakku. ");
INSERT INTO sml_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Malaingkan,’ yuk nakura'ku-i, ‘bang ka saupama pehē' ni saga kausbahanku bo' ka mbal tinaima', apuwas na ka min palkala' ya pagsapahanta itu.’ ” ");
INSERT INTO sml_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Anuli-nuli gi' sosoho'an si Ibrahim, yukna, “Na, makat'kka pa'in aku ni bohe' insini', angamu'-ngamu' aku. Yukku, ‘O Yawe, ya pagtuhanan nakura'ku si Ibrahim, tabangin aku supaya ta'ā'ku maksudku. ");
INSERT INTO sml_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Itiya' aku ma bihing bohe'. Jari bang aniya' budjang pi'itu angā' bohe', angamu' du aku pinainum bohe' min kibutna. ");
INSERT INTO sml_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Na Tuhan, bang ya na d'nda ya asal tapene'nu pamah'nda ma anak nakura'ku, na, bang pa'in buwattitu panambung budjang-i ma aku, “Aho' tuwan, anginum ka. Ngā'anta ka bohe' isab pamainum saga unta'nu.” ’ ");
INSERT INTO sml_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Sakali itu,” yuk a'a-i ma disi Leban, “halam gi' aubus e'ku angamu'-ngamu' ni Tuhan ma deyom atayku, ina'an si Ripka patuwa' magtanggung kibut. Palūd iya magtūy angā' bohe'. Aubus pa'in, yukku ma iya, ‘Arung, makajari aku painumnu bohe'?’ ");
INSERT INTO sml_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Pinareyo' kibut magtūy min bahana. Yukna ma aku, ‘Aho' tuwan, anginum na ka. Painumku isab saga unta'nu.’ Jari anginum na aku, maka pinainum isab unta'ku. ");
INSERT INTO sml_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Bay iya tilawku isab, ‘Sai mma'nu?’ Ya sambungna ma aku, ‘Aku itu anak si Bituwil, mbo'ku si Nahor maka si Milka.’ Manjari tuwan,” yuk a'a, “bay sangonanku singsing ilu ni ūngna maka pasulugku isab gallang ma l'ngngonna karuwambila'. ");
INSERT INTO sml_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Pagubus, pakuru' aku magtūy amudji si Yawe ya pagtuhanan nakura'ku si Ibrahim. Aheya pagsukulanku ma iya sabab katuli'an aku e'na pi'itu ni saga lahasiya' si Ibrahim. Tapihaku na anak sigām budjang pamah'nda ma anak nakura'ku, bang hati aniya' dapat. ");
INSERT INTO sml_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Na, bang aniya' lasabi ma nakura'ku pagka kam maglahasiya' du, haka'inbi aku sab'nnal-b'nnal bang taima'bi maksudku itu atawa mbal. Bang hati' mbal, na maghona'-hona' lagi' aku bang ai subay hinangku.” ");
INSERT INTO sml_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Anambung si Leban maka si Bituwil, yuk sigām, “Ya palkala' ilu min kabaya'an PANGHŪꞋ du, jari halam aniya' kapatut kami angaho' atawa magin'mbal. ");
INSERT INTO sml_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Itiya' si Ripka, bowahun iya pasambeya' ma ka'a tudju ni pamole'anbi. Pah'nda'un iya ma anak nakura'nu. Tu'ud kahandak PANGHŪꞋ ko' ilu.” ");
INSERT INTO sml_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Na, pagkale sosoho'an si Ibrahim ma sambung disi Leban-i, magtūy iya pasujud magsarang-sukul ma PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Puwas e', pinaluwas e'na saga s'mmek maka pamulawan dī bulawan bo' yampa pamuwanna ma si Ripka. Aniya' isab kasampangan ahalga' pamuwanna ma disi Leban sampay ma ina' si Ripka. ");
INSERT INTO sml_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Na aubus pa'in ina'an-i, magkakanan maka maginum sosoho'an si Ibrahim maka saga sehe'na bo' yampa sigām atuli. Pag'llaw dakayu' bo' magbati'an na sigām, ama'id sosoho'an e' min disi Leban. Yukna, “Amuhun lagi' aku amole' ni nakura'ku.” ");
INSERT INTO sml_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Saguwā' mbal bilahi danakan si Ripka maka ina'na, yuk sigām, “Tuwan, bang bahā' minaitu gi' si Arung saga sangpū' bahangi. Pagpuwas, ameya' du iya ma ka'am.” ");
INSERT INTO sml_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Malaingkan yuk sosoho'an, “Ndū' ampunun aku, sagō' ahāp kami da'a taggahinbi. Ta'ā'ku na in maksudku ma sabab tabang min PANGHŪꞋ, manjari papole'unbi na aku bo' pabīng ni nakura'ku he'.” ");
INSERT INTO sml_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ya sambung sigām, “Lingananta gi' si Ripka. Tilawta iya bang ai kabaya'anna.” ");
INSERT INTO sml_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Sakali nilinganan si Ripka bo' tinilaw. Yuk-i, “Na buwattingga? Bilahi ka ameya' ma a'a itu?” Ya sambung si Ripka, “Aho', ameya' aku.” ");
INSERT INTO sml_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Manjari pinatulak kakasi sigām si Ripka ameya' ma a'a inān sampay saga sehe'na. Pinabeya' isab ma iya matto'a d'nda ya bay angipat iya min kariki'-diki'na gi'. ");
INSERT INTO sml_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Niamu'-amu'an isab iya duwa'a min Tuhan e' disi Leban. Yuk pangamu' sigām, “Arung, mura-murahan bang pa'in laksa'an heka panubu'nu! Bang pa'in ta'agaw e' panubu'nu lahat kabantahan sigām.” ");
INSERT INTO sml_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Puwas e' magsakap na si Ripka maka saga sehe'na d'nda ati pakura' sigām ni saga unta' bo' ameya' ma tendog si Ibrahim e'. Jari pauntas sigām kamemon ni pal'ngnganan sigām. ");
INSERT INTO sml_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na in si Isa'ak, wa'i na pat'nna' ma lahat Negeb (lahat tampal ni satan min lahat Kana'an). Yamboho' iya makapole' min bohe' niōnan Be'er-Lahai-Ruwi. ");
INSERT INTO sml_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Manjari itu, abay kohap pa'in lahat, hinabuna maglunsul-lunsul ma kaparangan, aniya' ta'nda'na saga unta' magt'kkahan. ");
INSERT INTO sml_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ahā, ta'nda' isab si Isa'ak e' si Ripka. Pag'nda'na, magtūy iya pareyo' min unta' ");
INSERT INTO sml_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","bo' tilawna sosoho'an si Ibrahim. Yukna, “Sai bahā' l'lla ma kaparangan inān, ya pal'ngngan tudju pi'itu ni kita?” Ya sambung sosoho'an si Ibrahim, “Si Isa'ak ko' inān, ya nakura'ku.” Magtūy niā' e' si Ripka turungna panambunna ma baihu'na. ");
INSERT INTO sml_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Makasampay pa'in sigām ni si Isa'ak, nihaka'an iya e' sosoho'an e' pasal kamemon bay kalabayanna. ");
INSERT INTO sml_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pagubus, binowa si Ripka e' si Isa'ak tudju ni deyom kamalig bay pagluma'an ina'na si Sara. Gana-gana tahinangna h'nda. Alasa to'ongan si Isa'ak ma si Ripka, manjari kauli'an karukka'anna min kamatay ina'na. ");
INSERT INTO sml_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Manjari si Ibrahim makapagh'nda na pabīng, ōn h'ndana si Kitura. ");
INSERT INTO sml_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nnom anakna l'lla min si Kitura. Ya siyaka si Simran, pasunu' si Joksan, bo' si Medan, bo' si Midiyan, kalimana si Isbak bo' si Suwa ya kasiyalihan. ");
INSERT INTO sml_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Joksan itu ya na mma' si Seba maka si Dedan. Manjari saga panubu' si Dedan, ya na bangsa Assur, bangsa Litus maka bangsa Leyom. ");
INSERT INTO sml_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Aniya' isab saga anak si Midiyan l'lla. Ōn sigām si Epa, si Eper, si Hanok, si Abida maka si Elda. Na, iya na ina'an panubu' si Ibrahim min h'ndana si Kitura. ");
INSERT INTO sml_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Si Isa'ak ya pamusaka'an e' si Ibrahim suku'na kamemon. Daipara sasangna allum lagi', aniya' alta' pamuwanna ma saga anakna min saga h'ndana saddī min si Sara. Sinoho' sigām maglahat ma lahat dakayu' tampal ni sobangan bo' supaya sigām alawak min anakna si Isa'ak. ");
INSERT INTO sml_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Na ataha' to'ongan umul si Ibrahim, dahatus maka pitumpū' maka limantahun. Manjari amatay na iya ma deyom kasannangan ati pinapagtimuk iya maka ka'mbo'-mbo'anna. ");
INSERT INTO sml_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Kinubul iya e' anakna si Isa'ak maka si Isma'il ma deyom songab batu ma tana' si Makpela tampal ni sobangan min tana' si Mamre. Songab batu itu asal ma tana' bay bin'lli e' si Ibrahim min si Epron anak si Sohar bangsa Hīt. Jari kinubul si Ibrahim ma bihing h'ndana si Sara. ");
INSERT INTO sml_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Na, pagka amatay na si Ibrahim, si Isa'ak ya pas'lle' binuwanan kahāpan na pa'in e' Tuhan. Maglahat si Isa'ak ma tongod bohe' Be'er-Lahai-Ruwi. ");
INSERT INTO sml_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ya na itu saga panubu' si Isma'il, anak si Ibrahim min si Hajara a'a bangsa Misil, ya bay ipatan si Sara. ");
INSERT INTO sml_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya itu ōn saga anak si Isma'il magsunu'-sunu': si Nebayot ya kasiyakahan, pasunu' si Kedar, bo' si Abbe'el, bo' si Mibsam. ");
INSERT INTO sml_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Ya pasunu' ma si Mibsam si Misma, bo' si Duma, bo' si Massa. ");
INSERT INTO sml_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Bo' si Hadad, bo' si Tema, bo' si Jetor, bo' isab si Napis, kasiyalihan si Kedema. ");
INSERT INTO sml_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na saga anak si Isma'il itu tahinang po'onan sangpū' maka duwa tumpuk. Maka ōn sigām tahinang ōn lahat isab, ya pat'nna'an ba'anan katumpukan itu. ");
INSERT INTO sml_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ta'abut pa'in umul si Isma'il dahatus maka t'llumpū' maka pituntahun, amatay na iya ati pinapagtimuk maka ka'mbo'-mbo'anna. ");
INSERT INTO sml_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Manjari saga panubu' si Isma'il itu ina'an maglahat ma tonga'an lahat Habila maka Sūr, ma bihing lahat Misil tampal ni sobangan. Magsaddī asal pat'nna'an sigām min saga panubu' si Ibrahim kasehe'an. ");
INSERT INTO sml_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ya na itu salsila pasal si Isa'ak, anak si Ibrahim. Si Ibrahim ya mma' si Isa'ak. ");
INSERT INTO sml_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Mpatpū' tahun ya umul si Isa'ak waktu pah'ndana ma si Ripka danakan si Leban, anak si Bituwil. (Si Bituwil itu a'a Aram min lahat Mesopotami.) ");
INSERT INTO sml_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Sakali itu, pagka halam maka'anak si Ripka minsan at'ggol na pagpūn sigām, angamu'-ngamu' si Isa'ak ni PANGHŪꞋ-Yawe bang pa'in pinapangiram h'ndana. Manjari pinarūl pangamu'na e' PANGHŪꞋ ati ab'ttong si Ripka. ");
INSERT INTO sml_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ya kinab'ttongan e' si Ripka k'mbal, sagō' ma halam lagi' paluwas tananamna sigām magkosog-kosogan ma deyom b'ttongna. Yuk si Ripka, “Angay bahā' buwattitu pagb'ttongku?” Jari angaru iya ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ati yuk PANGHŪꞋ ma iya, “Ya ma deyom b'ttongnu ilu, duwa onde'-onde', manjari tahinang sigām duwa bangsa mbal to'ongan magsulut. Sababna dakayu' ilu akosog min dakayu', maka anaknu siyaka ilu pinagbaya'an du e' siyali.” ");
INSERT INTO sml_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Manjari ta'abut na bulanan si Ripka, k'mbal l'lla anakna. ");
INSERT INTO sml_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ya dahū paluwas, akeyat-keyat kuwitna maka bahibuan baranna kamemon sali' kahantang kakana' akasap. Angkan iya niōnan Esaw. ");
INSERT INTO sml_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ya paluwas damuli wa'i amalut pahogot ma buli' tape' si Esaw. Angkanna iya niōnan si Yakub. Nnompū' tahun asal umul si Isa'ak ma waktu kapanganak ma anakna k'mbal itu. ");
INSERT INTO sml_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Manjari asangpot pa'in umul duwangan k'mbal itu, si Esaw ya a'a magpapana', apanday to'ongan angā' hayop talun. Ya katagihanna subay ma luwasan sadja. Saddī kajarihan si Yakub. Ahantap iya, ya katagihanna subay pataptap ma kauman. ");
INSERT INTO sml_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Na, aheya lasa si Isa'ak ma si Esaw sabab asōb iya amangan susumbali'an ya tapana' e' si Esaw. Sagō' si Yakub ya kalasahan si Ripka. ");
INSERT INTO sml_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Manjari dakayu' llaw, hinabu pa'in si Yakub itu maghinang sayul batung keyat niloho'an, makapole' si Esaw min pagpana'an. Lingantu to'ongan iya, ");
INSERT INTO sml_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","angkan yukna ma si Yakub, “Buwanin aku min loho' keyat ya b'llanu ilu. Sidda aku pinunung!” Ya he' sababanna angkan iya niranglay si Edom, hatina ‘keyat.’ ");
INSERT INTO sml_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ya sambung si Yakub, “Aho', sagō' buwanin aku kapatutannu dahū, ya pamusaka' anak siyaka.” ");
INSERT INTO sml_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ya sambung isab si Esaw, “Na, pehē'un na, ma ka'a na kapatutan e'. Pamagayku bang aku arai' na patay otas?” ");
INSERT INTO sml_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yuk si Yakub ma iya, “Subay ka anapa dahū, in kapatutan pamusaka' ma ka'a pamuwannu na ma aku sab'nnal-b'nnal.” Magtūy sinapahan e' si Esaw, jari pamuwanna pusaka'na ma siyalina. ");
INSERT INTO sml_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Pagsapa si Esaw, binuwanan iya tinapay maka loho' keyat e' k'mbalna. Na, amangan na iya sampay anginum bo' na paluwas. Halam to'ongan pinahalga' e'na kapatutanna ya pamusaka' ma anak siyaka. ");
INSERT INTO sml_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Sakali itu aniya' gotom ma lahat Kana'an e', saddī min gotom bay kalabayan disi Ibrahim ma waktu dahū. Jari maglain disi Isa'ak pehē' ni Gerar, ya lahat pagsultanan si Abimelek sultan bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Bay na magpa'nda' asal PANGHŪꞋ ma si Isa'ak maka e'na ah'lling, yuk-i, “Isa'ak, da'a ka pehē' ni lahat Misil. Ya paglahatannu subay lahat song panō'ku ma ka'a. ");
INSERT INTO sml_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sagō' pahanti' ka buwattina'an ma jadjahan ya pat'nna'annu ilu. Taptap du aku mailu ma ka'a amuwanan ka'a kahāpan. Saga lahat kamemon ma jadjahan itu-i pamasuku'ku ma ka'a sampay ma saga panubu'nu. Tumanku isab bay paljanji'anku ma mma'nu si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Buwananta ka paltubu'an aheka, buwat saga bitu'un ma diyata' langit ya heka sigām. Pamuwanku du isab katibu'ukan lahat ilu ma sigām. Manjari kabangsahan kamemon ma deyom dunya angamu' kahāpan du min aku bang pa'in pinasali' ni kahāpan ya pamuwanku ma saga panubu'nu. ");
INSERT INTO sml_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Aho', buwananta ka kahāpan ma sabab kapameya' si Ibrahim ma panoho'anku. Bay kabogbogan e'na sara' maka panoho'an bay pamat'nna'ku ma iya.” ");
INSERT INTO sml_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Manjari mahē' na si Isa'ak pahanti' ma lahat Gerar. ");
INSERT INTO sml_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Na, tinilaw pa'in iya e' saga l'lla minna'an pasal si Ripka, ya sambungna ma sigām, “Danakanku ko' ilu.” Halam bay bontolna in si Ripka h'ndana du, sabab tināw iya. Pangannalna in iya binono' e' saga a'a inān bo' ta'ā' si Ripka e' sigām pagka ahāp d'nda sidda. ");
INSERT INTO sml_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sakali itu, at'ggol-t'ggol pa'in kamahē' disi Isa'ak ma lahat Gerar, aniya' dakayu' llaw amantaw sultan Abimelek min tandawanna. Ta'nda' e'na si Isa'ak anapu-napu si Ripka. ");
INSERT INTO sml_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Magtūy pinalinganan si Isa'ak e' si Abimelek, sinō' patampal ma iya. Yukna, “Halam aniya' pagduwa-ruwana, h'ndanu ko' ilu. Angay kami putingannu in iya kono' danakannu?” Ya sambung si Isa'ak, “Tuwan sultan, tu'ud aku tināw binono' bang aku angahaka sab'nnal-b'nnal in iya h'ndaku.” ");
INSERT INTO sml_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Yuk si Abimelek, “Angay kami tala'atnu buwattilu? Bang saupama aniya' a'aku bay makabihing atuli ma iya, na, ka'a ya sababna bang kami kat'kkahan dusa.” ");
INSERT INTO sml_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Angkanna sinanggupan e' si Abimelek saga tendogna kamemon, yukna, “Sai-sai angala'at a'a itu atawa h'ndana, pat'nna'anku iya hukuman ni kamatay.” ");
INSERT INTO sml_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Manjari itu, ma Gerar pa'in si Isa'ak maglahat, maghuma iya ati ahāp to'ongan buwa' tinanomna ma tahun inān. Maghatusan buwa'na dampo'on maka dampo'on ma sabab lidjiki' min PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pak'nnop na pa'in alta' si Isa'ak sampay aheya to'ongan karayana. ");
INSERT INTO sml_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Na, pagka aheka to'ongan bili-bilina, kambingna maka sapi'na, maka aheka isab saga sosoho'anna, nijingki iya e' bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ya he' sababna angkan nirasokan tana' saga pagbohe'an kamemon bay kinali e' saga sosoho'an mma'na si Ibrahim ma masana allum lagi'. ");
INSERT INTO sml_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Angkanna si Abimelek bay amowa si Isa'ak maggara', yukna, “Tuwan, subay kam papinda ni lahat saddī, sabab aga'os na kam min kami.” ");
INSERT INTO sml_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Sakali pauntas disi Isa'ak pehē' ni L'bbak Gerar ati mahē' na sigām pat'nna'. ");
INSERT INTO sml_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aniya' saga pagbohe'an asal ma tongod ina'an-i bay kinali ma masa lagi' mma'na si Ibrahim, sagō' amatay pa'in si Ibrahim bay nirasokan tana' e' saga a'a Pilistin. Manjari ya bohe' inān bay pinakali pabīng e' si Isa'ak, pinat'nna'an isab ōn bay pangōn e' mma'na-i. ");
INSERT INTO sml_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Puwas e' aniya' pagbohe'an baha'u bay kinali e' saga sosoho'an si Isa'ak ma l'bbak inān ati makabāk sigām bohe' ahāp. ");
INSERT INTO sml_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sagō' magsagga' saga a'a Gerar maka saga a'a magi'ipat hayop si Isa'ak. Yuk a'a Gerar e', “Kami dapu bohe' ilu.” Ya he' sababna angkan bohe' inān niōnan ‘Esek’ e' si Isa'ak, hatina ‘Pagsagga'an.’ ");
INSERT INTO sml_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Na angali gi' saga sosoho'an si Isa'ak pagbohe'an saddī, jari ya du ina'an tahinang pagsasawan e' saga a'a Gerar, angkan niōnan e' si Isa'ak Sitna, hatina “Pagbantahan.” ");
INSERT INTO sml_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Palawak gi' disi Isa'ak minnē' bo' yampa angali bohe' saddī. Na halam na aniya' pagsagga'an ma pagbohe'an itu angkan niōnan Rehobot, hatina “Kaluhaya'an.” Yuk si Isa'ak, “Itiya' kitam pinaluhaya e' PANGHŪꞋ-Yawe pat'nna' to'ongan ma lahat itu. Tantu kitam makabāk kahāpan maitu.” ");
INSERT INTO sml_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Na, patukad sigām minnē' tudju ni lahat Be'erseba. ");
INSERT INTO sml_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pagt'kka sigām pehē' bo' sangom na, magpa'nda' PANGHŪꞋ ma si Isa'ak magsuwala, yuk-i, “Aku ya Tuhan pagtuhanan mma'nu si Ibrahim. Da'a ka tināw sabab taptap du aku mailu ma ka'a. Buwananta ka kahāpan, pahekaku panubu'nu ma sabab sosoho'anku si Ibrahim.” ");
INSERT INTO sml_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aniya' pagtunu'an kulban nihinang e' si Isa'ak maina'an, bo' ana'at iya ma ōn si Yawe. Jari maina'an iya pat'nna', maina'an isab saga sosoho'anna bay angali pagbohe'an. ");
INSERT INTO sml_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Na aniya' dakayu' llaw pinehē' si Isa'ak e' si Abimelek, ya sultan ma lahat Gerar. Ya sehe' si Abimelek si Ahussat, ya bagayna pangandolan, maka si Pikul, ya nakura' saga kasundaluhanna. ");
INSERT INTO sml_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Atilaw si Isa'ak ma sigām, yukna, “Tuwan sultan, ai gawinu pi'itu? Bay aku pala'anbi min lahatbi inān maka aheya kab'nsibi ma aku. Na, ai maksudbi ma aku?” ");
INSERT INTO sml_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ya sambung sigām, “Aho' tuwan, saguwā' kata'uwan kami in ka'a tinabang sadja e' si Yawe, angkan yuk kami subay aniya' pagsulutantam. Manjari ya maksud kami itu mikisapa ma ka'a, ");
INSERT INTO sml_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","supaya ka mbal angala'at kami. Bistahun, sat'ggol kam bay ma lahat kami kahāpan sadja ya tahinang kami ma ka'am. Maka ta'abut waktu isab kala'anbi, pinatulak kam ma deyom kasannangan. Tantu ka kabuwanan kahāpan na pa'in e' si Yawe.” ");
INSERT INTO sml_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Pagkale si Isa'ak, magpajamu iya pangahulmatna ma disi Abimelek ati magsalu sigām amangan maka anginum. ");
INSERT INTO sml_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pagsubu pa'in magjanji' sigām min karuwambila', magsapa in sigām mbal na magbono' dansehe'an. Pagubus, pinaba'id disi Abimelek e' si Isa'ak ati amole' sigām magatay pote'. ");
INSERT INTO sml_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na, ma llaw ina'an-i, pina'an ni si Isa'ak saga sosoho'anna angahaka'an iya pasal pagbohe'an yamboho' kinali e' sigām. “Makabāk kami bohe'!” yuk sigām. ");
INSERT INTO sml_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ya pangōn si Isa'ak ma bohe' inān Siba'. Ya he' sababna angkan kauman inān kaōnan Be'erseba sampay ni kabuwattituhan. ");
INSERT INTO sml_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Na, in pasal si Esaw, ta'abut pa'in mpatpū' tahun umulna, makapagh'nda iya duwa d'nda bangsa Hīt, ya na si Judit anak si Be'ere maka si Basemat anak si Elon. ");
INSERT INTO sml_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aheya isab kasukkalan si Isa'ak maka si Ripka, ya matto'a si Esaw, ma sabab duwangan d'nda itu. ");
INSERT INTO sml_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Na palabay pa'in daka pilantahun, ato'a na si Isa'ak, mbal na maka'nda'. Jari aniya' llaw pangalinganna ma si Esaw, ya anakna siyaka. Yukna ma iya, “Otō'.” Ya sambung si Esaw, “Oy, Mma'.” ");
INSERT INTO sml_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yuk si Isa'ak, “Otō', ta'nda'nu aku itu ato'a na. Sōng-sōng na ta'abut ganta'anku, angkan aniya' amu'ku ma ka'a. ");
INSERT INTO sml_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Bowahun pana'nu pehē' ni kareya-reyahan amiha'an kita hayop susumbali'an. ");
INSERT INTO sml_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Adjalin aku pagkakan ahāp nanamna ya kasōbanku. Bowahun pi'itu bo' kakanku ati amu'-amu'anta ka ni Tuhan bang pa'in ka pinasuku'an lidjiki'. Pang'bbaku ma ka'a sasangku masi allum.” ");
INSERT INTO sml_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Na, hinabu pa'in si Isa'ak magsuli-suli maka si Esaw, ina'an si Ripka pakale-kale. Jari makalanjal pa'in si Esaw kaleya amana', ");
INSERT INTO sml_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","magtūy ah'lling si Ripka ni si Yakub, yukna, “Otō', yamboho' takaleku mma'nu ah'lling ma siyakanu, yukna, ");
INSERT INTO sml_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Piha'in kita susumbali'an ma deya. Adjalun pahāp bo' aniya' palaukku ahāp nanamna. Aubus pa'in aku amangan, amu'-amu'anta ka kahāpan ni Tuhan bang pa'in ka pinasuku'an lidjiki' ya kapatutan pamasuku' ma anak siyaka. Ya du ina'an pang'bbaku ma ka'a sasangku masi allum. Si Yawe ya saksi'ku.’ ");
INSERT INTO sml_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Na, Otō',” yuk si Ripka, “kalehun aku. Beya'un panoho'anku itu. ");
INSERT INTO sml_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pehē' na ka ni buluyan hayopta. Pene'un duwa anak kambing ahāp l'mmokna ati bowahun pi'itu ni aku. Aku ya angadjalan mma'nu lauk alanab ya kasōbanna to'ongan. ");
INSERT INTO sml_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Atahak pa'in lauk e', ka'a ya amowa pehē' ni mma'nu ati ka'a ya amakan iya. Manjari ka'a ya niamu'-amu'an kahāpan min Tuhan e' mma'nu sasangna masi allum lagi'.” ");
INSERT INTO sml_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yuk si Yakub ni ina'na, “Oy, Ina', bahibuan asal si Esaw. Aku ngga'i ka, alanu' kuwitku. ");
INSERT INTO sml_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Painay bahā' bang aku sinanaw e' si Mma', bo' kata'uwanna magtūy in aku amarupang ma iya. Bang buwattē' ngga'i ka kahāpan ya ta'ā'ku, saguwā' sukna'.” ");
INSERT INTO sml_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Na ya sambung ina'na ma iya, “Mbal, Otō'. In sukna' inān subay papelleng ni aku, ngga'i ka ni ka'a. Pehē' na ka, ngā'in kita kambing.” ");
INSERT INTO sml_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Sakali pehē' na si Yakub angā' duwa anak kambing. Binowa e'na pehē' ni ina'na bo' adjalanna lauk ya kasōban si Isa'ak kinakan. ");
INSERT INTO sml_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pagubus, pinaluwas e' si Ripka badju' si Esaw ahāp to'ongan, ya bay ma deyom tau'an. Jari pasulugna na ma anakna siyali, ya si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Niā' isab e' si Ripka kuwit kambing bay ta'adjal inān ati pangalapis e'na ma bukut tangan si Yakub sampay ma buli' k'llongna supaya iya bahibuan sali'. ");
INSERT INTO sml_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Aubus pa'in e'-i, ni'nde'an e' si Ripka ni si Yakub lauk ahāp nanamna, maka tinapay baha'u bay hinangna. ");
INSERT INTO sml_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sakali pehē' na si Yakub ni mma'na, yukna, “O Mma'!” Yuk si Isa'ak, “Aho', Otō'. Sai sa ka'a ilu?” ");
INSERT INTO sml_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ya sambung si Yakub, “Si Esaw, anaknu siyaka. Tahinangku na bay panoho'annu ma aku. Itiya' na lauk bay adjalanku ka'a. Papunduk ka amangan bo' aku yampa amu'-amu'annu kahāpan ni Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ah'lling gi' si Isa'ak ma si Yakub, yukna, “Al'kkas pahāp kapihanu susumbali'an ilu. Angay bahā'?” Ya sambung si Yakub, “Tu'ud aku tinabang e' si Yawe, ya pagtuhanannu.” ");
INSERT INTO sml_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yuk si Isa'ak isab, “Otō', pasekot ka kono'. Sanawta ka bang ka b'nnal-b'nnal anakku si Esaw.” ");
INSERT INTO sml_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Manjari pasekot na si Yakub ni mma'na bo' tasanaw e'na. Yuk si Isa'ak, “Lagamnu sali' lagam si Yakub, malaingkan tangannu itu sali' tangan si Esaw.” ");
INSERT INTO sml_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Na, halam takilāna in a'a inān si Yakub, sabab tasanawna tanganna bahibuan, dasali' maka tangan si Esaw. Na, arai' pa'in si Isa'ak angamu'-ngamu' kahāpan tudju ni Tuhan, ");
INSERT INTO sml_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tinilaw e'na si Yakub pabīng, yukna, “B'nnal bahā'? Ka'a ilu anakku si Esaw?” “Aho', Mma',” yuk si Yakub. “Halam saddī.” ");
INSERT INTO sml_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Sakali ah'lling si Isa'ak, yukna, “Ndiya na lauk bay adjalannu aku-i. Amangan na aku bo' yampa ka amu'-amu'anku kahāpan tudju ni Tuhan.” Magtūy iya binowahan lauk maka binu-anggul e' si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Aubus pa'in, nilinganan iya. Yuk mma'na ma iya, “Otō', pi'itu ka kono', siyumun aku.” ");
INSERT INTO sml_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Manjari pasekot na si Yakub ni mma'na aniyum iya. Sakali itu, tahamut pa'in s'mmekna e' si Isa'ak, hamut si Esaw to'ongan, magtūy iya niamu'-amu'an kahāpan ni Tuhan. Ya pagkallam si Isa'ak ma iya, “Ya hamut anakku itu sali' hamut tana' paghuma'an kabuwanan kahāpan e' si Yawe. ");
INSERT INTO sml_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Bang pa'in binusugan tana'nu e' Tuhan maka alu' min diyata' langit. Bang pa'in isab pinajatu e'na tanomannu, supaya aheka buwa'na pagkakannu maka paginumnu! ");
INSERT INTO sml_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bang pa'in kapagbaya'annu saga kabangsa-bangsahan, bang pa'in sigām pasujud ma ka'a. Bang pa'in ka magnakura' ma kakampungannu kamemon, bang pa'in isab pasujud ma ka'a kapanubu'an ina'nu. Bang pa'in kataluwa'an mulka' sasuku anabbut ōnnu ni kala'atan. Bang pa'in binuwanan kahāpan sasuku anabbut ōnnu ni kahāpan.” ");
INSERT INTO sml_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Manjari itu, aubus pa'in pangamu'-ngamu' si Isa'ak, bo' yamboho' paluwas si Yakub, ina'an na si Esaw at'kka min deya. ");
INSERT INTO sml_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Magtūy du iya angadjal lauk ahāp nanamna bo' yampa bowana pehē' ni mma'na. Yukna, “O Mma', itiya' na lauk bay adjalanku ka'a. Papunduk ka amangan bo' yampa aku amu'-amu'annu kahāpan ni Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tinilaw iya magtūy e' si Isa'ak, “Arī, sai sa ka'a ilu?” Ya sambung si Esaw, “Aku itu si Esaw, anaknu siyaka.” ");
INSERT INTO sml_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Agsai takuddat si Isa'ak, amidpid to'ongan baranna. Yukna, “Sai sa a'a bay amowahan aku palauk insini'. Susumbali'an kono' bay tapana' e'na! Yamboho' takakanku ma waktu kat'kkanu itu. Baha'u du iya bay amu'-amu'anku kahāpan ni Tuhan. Pangannalku ka'a, sagō' kahāpan ilu mbal kapindahan sabab makalagtik na d'lla'ku.” ");
INSERT INTO sml_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Na, pagkale si Esaw ma lling mma'na he' magtūy iya anangis pakosog kabowa kagit atayna. Yukna, “Arōy, aku isab Mma', amu'-amu'in aku kahāpan isab!” ");
INSERT INTO sml_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ya sambung si Isa'ak, yukna, “Arōy, Otō'. Bay aku tarupang e' siyalinu. Ta'ā'na na kahāpan ya arak pamasuku'ku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“Ā,” yuk si Esaw, “tinōp iya niōnan Yakub, sabab min duwa na aku ka'akkalan e'na. Ta'agaw e'na pusaka' ya kapatutanku pagka aku anak siyaka. Maka ma buwattina'an isab, ta'ā'na kahāpan min Tuhan ya subay pamasuku' aku. Mma', halam bahā' aniya' lidjiki' bay kapinannu aku?” ");
INSERT INTO sml_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Anambung si Isa'ak, yukna, “Bay na amu'-amu'anku si Yakub kahāpan bang pa'in iya tahinang nakura'nu. Maka kampungna kamemon subay tahinang sosoho'anna. Ta'amu'-amu'ku isab bang pa'in iya binalanja'an kinakan ahāp e' Tuhan maka binu-anggul paginumna. Hatina, Otō', si Yakub ya pinasuku'an kamemon, ati halam aniya' tahinangku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Sakali angamu' na pa'in si Esaw, yukna, “Mma', min t'dda sadja ka bahā' angamu'-ngamu' kahāpan ni Tuhan? Mbal bahā' kaisaban? Ndū' Mma', amu'-amu'in aku kahāpan isab.” Jari aheya tangisna. ");
INSERT INTO sml_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Manjari magkallam si Isa'ak ma si Esaw, yukna, “Paglahatannu alawak du min huma ya taptap pinajatu e' Tuhan. Mbal ka pinasuku'an tana' ya binusugan maka alu' min diyata' langit, tana' akansang buwa'na. ");
INSERT INTO sml_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Magbono' du ka bo' aniya' tatabannu pagkallumannu, sagō' siyalinu ya pagnakura'annu na pa'in. Malaingkan bang ka mbal makasandal pinagbaya'an e'na, angatu du ka ati makal'ppa min komkomanna.” ");
INSERT INTO sml_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Sakali ab'nsi sidda si Esaw ma si Yakub ma sabab kahāpan ya pamasuku' ma iya e' mma' sigām. Ya minohot e' si Esaw ma deyom atayna, “Mbal at'ggol amatay du si Mma' ati papatayku si Yakub itu.” ");
INSERT INTO sml_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Daipara kahaka'an si Ripka pasal kamohotan si Esaw. Makata'u pa'in iya, magtūy lingananna si Yakub, yukna, “Otō', pakale ka. Agara' si Esaw amalosan ka'a. ");
INSERT INTO sml_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Na, buwattitu panganggara'ku ma ka'a, Otō'. Ala'an ka magdai'-dai' pehē' ni kauman Haran, ni danakanku si Leban e'. ");
INSERT INTO sml_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Subay ka pahanti' ma deyomanna sampay alungay na kab'nsi siyakanu ma ka'a. ");
INSERT INTO sml_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Jari bang ahāp-hāp na atayna ni ka'a, bo' alungay min pangentomna bay hinangnu ma iya, na, tambukuhanta pa'in ka bo' ka makapole' pi'itu. Tu'ud aku mbal bilahi kalungayan duwa anak ma dang'llaw.” ");
INSERT INTO sml_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sakali aniya' pah'lling si Ripka ma si Isa'ak, yukna, “Ab'nsi aku ma saga d'nda bangsa Hīt buwat h'nda si Esaw itu. Bang si Yakub ganta' magh'nda isab ma bangsa Hīt, na, ahāp lagi' aku amatay.” ");
INSERT INTO sml_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Manjari halam gi' makauntas si Yakub, pinalinganan iya e' si Isa'ak. Maina'an pa'in, sinagina iya maka niamay-amayan. Yuk mma'na ma iya, “Otō', da'a ka magh'nda d'nda Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pehē' ka gom pa'in ni lahat Mesopotami, ni tumpuk si Bituwil ya mbo'nu min ina'. Pene'un d'nda ngā'nu h'nda min ka'anakan bapa'nu si Leban. ");
INSERT INTO sml_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mura-murahan, bang pa'in ka binuwanan kahāpan e' Tuhan Sangat Kawasa, bang pa'in pinaheka panubu'nu bo' ka tahinang pag'mbo'an ma kabangsa-bangsahan. ");
INSERT INTO sml_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bang pa'in pinasampay ni ka'am dapanubu'an ya kahāpan bay panganjanji' Tuhan ma mma'ku si Ibrahim. Hatina ka'am iya tahinang tag-dapu lahat pahanti'antam itu, ya lahat bay pamuwan asal e' Tuhan ma mma'ku.” ");
INSERT INTO sml_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aubus pa'in e' si Isa'ak ah'lling ma si Yakub, pinatulak na iya bo' pauntas tudju ni lahat Mesopotami, ni kauman si'itna si Leban. Ya si Leban itu anak si Bituwil a'a Aram. ");
INSERT INTO sml_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Manjari tata'u e' si Esaw pasal si Isa'ak bay angamu'-ngamu'an si Yakub kahāpan. Bay patulakna isab pehē' ni lahat Mesopotami amiha d'nda ngā'na h'nda. Niamay-amayan iya sinō' da'a magh'nda d'nda bangsa Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ya takale isab e' si Esaw in si Yakub kono' bay ameya' ma panoho'an matto'ana, hatina wa'i na pal'ngngan tudju ni lahat Mesopotami. ");
INSERT INTO sml_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Na minnē' kinata'uwan na e' si Esaw in mma'na si Isa'ak mbal to'ongan kasulutan ma saga d'nda bangsa Kana'an, ");
INSERT INTO sml_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","angkan iya pehē' ni si'itna si Isma'il anak si Ibrahim. Maina'an pa'in, makah'nda iya ni si Mahalat anak si Isma'il, danakan isab si Nebayot. Manjari t'llu na h'nda si Esaw. ");
INSERT INTO sml_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Na, pauntas na si Yakub min lahat Be'erseba bo' pal'ngngan tudju ni kauman Haran. ");
INSERT INTO sml_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Manjari makasampay pa'in iya ni dakayu' pa'atagan, pahanti' iya maina'an sabab pas'ddop na llaw. Angā' iya dakayu' batu paū'anna bo' yampa pabahak atuli. ");
INSERT INTO sml_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Jari anguppi iya. Ya ta'nda'na ma deyom uppina haronan bay pinat'ngge min tana' tudju ni diyata' langit. Aniya' isab ta'nda'na saga mala'ikat magdeyo'-diyata'. ");
INSERT INTO sml_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ina'an isab PANGHŪꞋ an'ngge min diyata'na maka e'na magsuwala. Yukna, “Aku itu si Yawe ya pagtuhanan mbo'nu si Ibrahim maka mma'nu si Isa'ak. Ya tana' pabahakannu ilu pamuwanku ma ka'a sampay ma saga panubu'nu. ");
INSERT INTO sml_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Pahekaku du tubu'nu, ya heka sigām sali' solagan gusung ma gintana'an. Paheka du sigām ma kaluha'an lahat itu, min sobangan sampay ni s'ddopan. Maka kabangsa-bangsahan kamemon maitu ma dunya buwananku kahāpan du ma sababannu maka ma sababan saga panubu'nu. ");
INSERT INTO sml_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na, taptap du aku mailu ma ka'a, jagahanta ka pi'ingga-pi'ingga pal'ngnganannu, sampay ni waktu pamowata ka'a pabīng ni lahat itu. Mbal ka bbahanku, maka tumananku to'ongan ya paljanji'anku itu ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jari abati' na si Yakub maka e'na amikilan. “Sab'nnal-b'nnal, itiya' PANGHŪꞋ ma lahat itu, sagō' halam bay kata'uwanku.” ");
INSERT INTO sml_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Sinōd iya tāw angkan yukna, “Ag'mma sumangatku ma tongod itu-i! Pagluma'an Tuhan ko' itu. Itiya' isab maitu lawang pagsosōran sulga'.” ");
INSERT INTO sml_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pagsubu-subu pa'in, binuhat e' si Yakub batu bay paū'anna sangom-i bo' pinat'ngge e'na sali' hāg. Tapat'ngge pa'in, binase' maka ns'llan bo' nihinang e'na tampat pangentoman. ");
INSERT INTO sml_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Manjari Betel ya pangōn si Yakub ma lahat inān. (Lūs ya ōn kauman ma atag ina'an ma masa awal lagi'.) ");
INSERT INTO sml_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sakali magnajal si Yakub ni Tuhan, yukna, “Bang ka'a-i sab'nnal-b'nnal pataptap anganjagahan aku ma l'ngngananku itu, bang ka amuwanan aku pagkakan maka tamongon, ");
INSERT INTO sml_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","maka bang aku papole'nu isab ni luma' mma'ku ma deyom kasalamatan, na, si Yawe ya Tuhanku, halam aniya' saddī. ");
INSERT INTO sml_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ya batu tapat'nggeku itu ibarat luma' pagsusumbahan ni ka'a. Tukbalanku isab ma ka'a bahagi' sangpū' min ai-ai kamemon ya pamasuku'nu ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Pal'ngngan na pa'in si Yakub sampay ta'abutna lahat sobangan. ");
INSERT INTO sml_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Maina'an pa'in, bo' ma tongod kaparangan, aniya' ta'nda'na bohe' kali tinambolan asal maka batu aheya. Aniya' isab bili-bili t'llu ba'ananna pahali-hali ma tongod ina'an angagad pinainum. ");
INSERT INTO sml_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sagō' ya kabiyaksahan saga a'a magi'ipat bili-bili maina'an, subay atipun ba'anan bili-bili kamemon bo' yampa sigām angaligiran batu sampay amainum. Jari aubus pa'in pinainum ba'anan bili-bili kamemon, magtūy tinūran batu-i ni baina. ");
INSERT INTO sml_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Manjari itu atilaw si Yakub ma saga a'a magi'ipat inān, yukna, “Saga tuwan, minningga sa ka'am ilu?” Ya sambung saga a'a inān, “Kami itu min Haran, tuwan.” ");
INSERT INTO sml_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yuk si Yakub isab, “Magkata'u kam bahā' maka si Leban, mpu si Nahor?” Ya sambung sigām, “Aho' tuwan, kata'uwan kami.” ");
INSERT INTO sml_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Atilaw gi' si Yakub, yukna, “Ahāp isab ginhawa baranna?” “Aho' tuwan”, yuk a'a-i, “Ahāp du. O'o, ilu'un na anakna si Rakiya maka ba'anan bili-bilina.” ");
INSERT INTO sml_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yuk si Yakub, “Nda'unbi ba, masi alanga llaw. Mbal gi' waktu pamapole' hayop ni deyom sasak. Bang bahā' painumbi buwattina'an bo' yampa bowabi ni kaparang-parangan pinakan pabīng.” ");
INSERT INTO sml_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ya sambung saga a'a he', “Mbal makajari, tuwan. Subay atimuk pi'itu kaba'anan bili-bili kamemon bo' yampa ligiran kami tambol batu itu. Makajari pinainum bang maitu na kamemon.” ");
INSERT INTO sml_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Na, hinabu pa'in si Yakub magsuli-suli itu maka saga a'a magi'ipat inān, at'kka na si Rakiya maka ba'anan bili-bili mma'na. Tu'ud hinangna angipat bili-bili. ");
INSERT INTO sml_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jari pag'nda' si Yakub ma kakina si Rakiya maka bili-bili si'itna si Leban, magtūy niligiran e'na batu min bowa' bohe' bo' painumna saga bili-bili ya suku' si'itna. ");
INSERT INTO sml_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Aubus pa'in, siniyum e'na si Rakiya maka e'na anangis ma sabab kakōganna. ");
INSERT INTO sml_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yuk si Yakub ma iya, “Aku itu si Yakub, kamanakan mma'nu. Ina'ku si Ripka, ya danakan mma'nu.” Na, pagkale si Rakiya, magtūy iya paragan amole' angahaka'an mma'na. ");
INSERT INTO sml_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Manjari itu, makata'u pa'in si Leban pasal kat'kka kamanakanna si Yakub, magtūy iya magdai'-dai' pehē' anampang. Ginapus e'na si Yakub, siniyum isab ati binowa pehē' ni luma'. Pagka ma deyom luma' na, sinuli-sulihan si Leban e' si Yakub pasal kamemon bay kalabayanna. ");
INSERT INTO sml_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","“Ā,” yuk si Leban ma iya, “lahasiya'ta ka sab'nnal-b'nnal, magdalaha' magdaisi.” Manjari dambulan ya kahanti' si Yakub ma deyoman disi Leban. ");
INSERT INTO sml_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Palabay pa'in dambulan-i, ah'lling si Leban ma si Yakub, yukna, “Otō', minsan kita magdalaha', bang ka ganta' maghinang ma aku mbal apatut bang halam aniya' tongodna. Subay ka gadjihanku. Haka'in aku bang pila kabaya'annu?” ");
INSERT INTO sml_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na, aniya' duwa anak si Leban budjang. Ya ōn siyaka si Leya maka si Rakiya ya ōn siyali. ");
INSERT INTO sml_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Bulahaw asal mata si Leya, sagō' si Rakiya ya alingkat, ahāp pamarananna. ");
INSERT INTO sml_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jari kinabilahian si Rakiya itu e' si Yakub ati yukna ma si Leban, “Bapa' bang ka'a-i asulut, maghinang aku maitu ma ka'a pituntahun, minsan aku mbal gadjihannu. Ya sadja amu'ku ma ka'a bang pa'in pamah'ndanu ma aku anaknu si Rakiya.” ");
INSERT INTO sml_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ya sambung si Leban, yukna, “Ā, gom lagi' ka'a ya pamah'llaku ma iya, da'a a'a saddī. Maitu na ka ma deyomanku.” ");
INSERT INTO sml_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Manjari pituntahun ya paghinang si Yakub ma si Leban supaya tah'ndana si Rakiya, sagō' halam tabistana t'ggolna ma sabab kaheya lasana ma si Rakiya. ");
INSERT INTO sml_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Na, palabay pa'in pituntahun e', yuk si Yakub ma si Leban, “Bapa', ta'abut na waktu, kawinun kami maka si Rakiya bo' kami makapagdakayu' na.” ");
INSERT INTO sml_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Angaho' si Leban ati magsakap iya jajamuhan. Pinata'u e'na saga a'a kamemon ma lahatna, sinō' paluruk ni pagkawinan. ");
INSERT INTO sml_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Saguwā' pagsangom e', ngga'i ka si Rakiya ya ni'nde'an e' si Leban ni si Yakub sagō' si Leya. (Aniya' isab ipatan si Leban ōnna si Silpa bay pamuwanna ma si Leya nihinang ipatan.) Jari si Yakub maka si Leya magbihing na atuli. ");
INSERT INTO sml_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Na, pagk'llat pa'in llaw dakayu', yamboho' tasayu e' si Yakub in si Leya bay sehe'na sangom inān! Pehē' iya magtūy ni si Leban. “Bapa',” yukna, “angay buwattilu hinangnu ma aku? Jukup na pituntahun ya paghinangku ma ka'a bo' supaya si Rakiya ta'ā'ku h'nda. Angay aku angkan akkalannu?” ");
INSERT INTO sml_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ya sambung si Leban, “Otō', ya addat kami maitu, mbal makajari bang siyali pinah'lla'an dahū min siyaka. ");
INSERT INTO sml_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tangguhanta dapitu' lagi'. Subay na aubus paglami-lami ma si Leya itu bo' yampa ka pakawin kami maka si Rakiya. Saguwā' aniya' tongodna. Ya paghinangnu maitu ma aku subay sinugpatan pituntahun lagi'.” ");
INSERT INTO sml_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Na, kasulutan si Yakub. Aubus pa'in dapitu' iya paglami-lami sigām ma si Leya, pinakawin si Yakub e' si Leban ma anakna si Rakiya. ");
INSERT INTO sml_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Damikiyanna du isab, aniya' ipatan d'nda pamuwan si Leban ma si Rakiya, ōnna si Bilha. ");
INSERT INTO sml_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Sakali itu magdakayu' na si Yakub maka si Rakiya. Aheya sidda lasana ma si Rakiya, labi-labi min lasana ma si Leya. Jari pituntahun gi' ya paghinang si Yakub ma deyoman si Leban. ");
INSERT INTO sml_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Na, ta'nda' pa'in e' PANGHŪꞋ ariki' asal lasa si Yakub ma si Leya, aniya' kahāpan pamuwanna ma iya. Jari si Leya ya makapangiram du, sagō' si Rakiya mbal maka'anak. ");
INSERT INTO sml_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Jari ab'ttong na si Leya ati anganak iya l'lla. Yukna, “Ta'nda' kasusahanku e' PANGHŪꞋ. Tantu aku kinalasahan na e' h'llaku.” Manjari Rubin ya pangōnna ma anakna he'. ");
INSERT INTO sml_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Manjari ab'ttong iya pabīng ati l'lla du isab anakna. Yukna, “Ya anak itu pamuwan PANGHŪꞋ ma aku sabab takalena pasal aku mbal kinalasahan.” Angkan Simiyun ya pangōnna ma onde'. ");
INSERT INTO sml_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Na, ab'ttong iya pabīng ati l'lla isab anakna. Yukna, “Na, tantu h'llaku pat'ttog na ma aku sabab t'llu na anak l'lla ya pamuwanku ma iya.” Manjari Libi ya pangōnna ma onde' itu. ");
INSERT INTO sml_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Anā, ab'ttong si Leya pabīng, ka'mpatna na, l'lla du isab. Yukna, “Pudjiku na PANGHŪꞋ buwattina'an.” Angkan ōnanna anakna si Yahud. Na minnē' pahondong si Leya maganak. ");
INSERT INTO sml_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Na si Rakiya itu, pagka tasayuna in iya mbal to'ongan makabuwanan si Yakub anak, angimbū na ma siyakana si Leya. Ah'lling iya ma si Yakub, yukna, “Buwanin aku anak. Bang aku mbal maka'anak, gom gi' aku amatay.” ");
INSERT INTO sml_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Apasu' magtūy atay si Yakub ma si Rakiya, yukna, “Pangannalnu aku itu Tuhan bahā', makapagbaya' amuwanan ka'a anak maka mbal?” ");
INSERT INTO sml_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ya lling si Rakiya ma iya, “O'o, ipatanku si Bilha itu. Pahulid ka ma iya supaya iya anganak ganti' min aku, ati taga-tubu' aku min iya.” ");
INSERT INTO sml_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Jari sinōngan e'na ipatanna si Bilha ma si Yakub pamah'ndana. Magbihing sigām atuli, ");
INSERT INTO sml_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ati ab'ttong si Bilha maka anganak l'lla. ");
INSERT INTO sml_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ya lling si Rakiya, “Kabogbogan aku e' Tuhan in aku patut taga-anak. Takalena bay pangamu'-ngamu'ku ma iya, ati kabuwanan aku anak l'lla.” Manjari Dān ya pangōnna ma iya. ");
INSERT INTO sml_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ab'ttong na isab si Bilha pabīng ati aniya' gi' anak si Yakub l'lla min iya, karuwana na. ");
INSERT INTO sml_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ya pah'lling si Rakiya, “Aheya paggaggud kami maka siyakaku, sagō' ma aku da'ugan.” Manjari Naptali ya pangōnna ma onde'. ");
INSERT INTO sml_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Na si Leya isab, pagka tasayuna in iya mbal na anganak, manjari pamuwanna isab ipatanna si Silpa ma si Yakub pamah'ndana. ");
INSERT INTO sml_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ab'ttong isab si Silpa ati anganak l'lla. ");
INSERT INTO sml_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","“Ahāp sukudku!” yuk si Leya. Jari Gād ya pangōnna ma anakna he'. ");
INSERT INTO sml_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Damuli pa'in minnē', anganak pabīng si Silpa itu, jari duwa na anak si Yakub min iya. ");
INSERT INTO sml_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ya pah'lling si Leya, “Aheya kakōganku! Pinagsuli-sulihan du aku e' saga kar'ndahan in aku itu d'nda akōd.” Angkan na Aser ya pangōn si Silpa ma anakna. ");
INSERT INTO sml_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na ma musim pagani lagi', ina'an si Rubin anak si Leya maglunsul ma huma. Aniya' tabākna buwa' kayu tapagtambal pamapangiram, jari binowa e'na pehē' ni ina'na si Leya. Ah'lling magtūy si Rakiya ni si Leya, yukna, “Kaka', buwanin aku min buwa' kayu ya tabāk e' anaknu ilu.” ");
INSERT INTO sml_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ya sambung si Leya, “Ē, mamarahi pahāp ka'a ilu! Bay ta'agawnu h'llaku ati agawnu lagi' buwa' kayu anakku?” Yuk si Rakiya, “Bang aku buwanannu, tugutanku si Yakub pabihing ma ka'a sangom ilu.” ");
INSERT INTO sml_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Manjari itu, pagt'kka si Yakub min huma abay kohap na, sinampang iya e' si Leya. Yukna ma si Yakub, “Subay ka pabihing ma aku atuli sangom ilu. Makapagisun kami maka si Rakiya insini'. Bay iya buwananku saga buwa' kayu ya tapuwa' e' anakku si Rubin, manjari pinatuli ka ma aku.” Manjari pabihing si Yakub ma si Leya ma sangom inān. ");
INSERT INTO sml_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Na nirūlan si Leya e' Tuhan. Ab'ttong iya ati anganak l'lla. Manjari lima na anak si Yakub l'lla min h'ndana si Leya. ");
INSERT INTO sml_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yuk si Leya, “Katungbasan aku e' Tuhan ni kahāpan ma sabab kapamuwanku ipatanku ma h'llaku.” Angkanna Issakar ya pangōnna ma anakna itu. ");
INSERT INTO sml_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Angiram isab si Leya pabīng, paganakna l'lla. Manjari nnom na anak si Yakub l'lla bay min si Leya. ");
INSERT INTO sml_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","“Na,” yuk si Leya, “ahalga' to'ongan ya pamuwan Tuhan ma aku. Tantu aku pinaheya na e' h'llaku ma sabab nnom na anakna l'lla min aku.” Manjari Sibulun ya pangōn si Leya ma anakna itu. ");
INSERT INTO sml_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Na, mbal pa'in at'ggol, ab'ttong si Leya pabīng ati anganak iya d'nda. Dina ya pangōnna ma iya. ");
INSERT INTO sml_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Na, in si Rakiya isab, taentom du e' Tuhan. Takale bay pangamu'-ngamu' si Rakiya ma iya, ati nirūlan iya bo' makapangiram na. ");
INSERT INTO sml_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Manjari ab'ttong si Rakiya ati anganak iya l'lla. Ah'lling iya, yukna, “Kala'anan na kaiya'anku e' Tuhan sabab itiya' aku kabuwanan anak. ");
INSERT INTO sml_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mura-murahan bang pa'in aniya' gi' anakku l'lla pinasunu' e' PANGHŪꞋ ni onde' dakayu' itu.” Manjari Yusup ya pangōn si Rakiya ma anakna-i. ");
INSERT INTO sml_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Manjari itu, bay pa'in nianakan si Yusup, binowa e' si Yakub mato'ana si Leban magisun. Yuk si Yakub, “Bapa', paba'irun aku sabab bilahi na aku amole' ni lahatku. ");
INSERT INTO sml_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pabeya'un ma aku saga anak-h'ndaku, ya tausahaku maitu ma deyomannu. Kata'uwannu du ya katuyu'ku maghinang ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sagō' ya sambung si Leban ma si Yakub, “Otō', da'a gi'. Aniya' pamowahanta ka'a magsuli-suli. Ta'nda'ku ma putika'an ka'a iya sababna ya angkan aku nilidjiki'an e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ah'lling sadja ka. Gadjihanta ka pila-pila kabaya'annu.” ");
INSERT INTO sml_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Anambung si Yakub, yukna “Kata'uwannu du bang buwattingga e'ku maghinang maitu ma ka'a. Angahāp sadja kahayopannu ma deyom kapagipatku. ");
INSERT INTO sml_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ma halam gi' aku maitu, kulang asal pangalta'nu. Malaingkan aheka na ma buwattina'an. Minsan maingga-maingga paghinanganku ma deyomannu, nilidjiki'an sadja ka e' PANGHŪꞋ-Yawe. Bang ma aku ta'abut na waktu pamas'lle' ma aku, bo' supaya aniya' palsuku'an ma kami sampay anak-h'ndaku.” ");
INSERT INTO sml_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Atilaw si Leban ma iya, yukna, “Na, subay pila panganggadji ma ka'a?” Ya sambung si Yakub, “Ngga'i ka gadji ya kabaya'anku. Bang pagsulutanta, subay aku parūlnu angipat ba'anan hayopnu buwat bay dahū. Saguwā' aniya' amu'ku ma ka'a. ");
INSERT INTO sml_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tugutin aku angaliling ba'anan hayopnu ma llaw itu to'ongan. Ingga aniya' bili-bili ettom atawa kambing kabang-kabang, ma aku na palsuku'anku. Ya du ilu pangangganti'nu gadjiku. ");
INSERT INTO sml_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Manjari ma sinosōng, bang ka ganta' bilahi angitung bang pila panambanu ma aku, kata'uwannu magtūy bang aku kapangandolan atawa mbal. Bang saupama aniya' ta'nda'nu ma aku kambing ngga'i ka kabang atawa bili-bili ngga'i ka ettom, takilānu du bay tangkawku min ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ya sambung si Leban, “Aho', sulut. Buwattē' na.” ");
INSERT INTO sml_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Malaingkan karahūan si Yakub e' si Leban ma llaw ina'an-i. Pinasaddī e'na pat'nna'an saga kambingna l'lla jali'-jali' maka kambing d'nda kabang-kabang maka bili-bili ettom-ettom isab. Pinaipat kamemon ma saga anakna e' si Leban, ");
INSERT INTO sml_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ati palawak sigām min si Yakub saga t'llung'llaw nil'ngngan. Si Yakub ya ta'bba maina'an angipat kaheka'an hayop si Leban ya halam binowa. ");
INSERT INTO sml_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na pagka buwattē' akkal si Leban, aniya' saga sanga kayu nilabas e' si Yakub min kayu t'llungginis. Kinupas-kupasan kuwitna supaya magjali'-jali' ettom maka pote'. ");
INSERT INTO sml_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kakupasan pa'in, pinat'nna' e'na ma deyom pagbohe'an saga hayop bo' ta'nda' e' sigām pasalta' anginum pehē'. Bang ta'abut timpu pagd'nda saga hayop, ");
INSERT INTO sml_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","magd'nda du ma dahuan saga sanga kayu jali'-jali' he'. Manjari tapangā'an lihi e' kambing d'nda maka bili-bili d'nda ati jali'-jali' maka kabang-kabang maka b'ttikan ya nianakan e' sigām. ");
INSERT INTO sml_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Na, ya anak hayop e' pinasaddī na pa'in e' si Yakub. Saguwā' ya hayop asangpot pinaharap e'na tudju ni saga hayop jali'-jali' maka ettom-ettom ya suku' si Leban. Minnē' pinapagsaddī ba'anan hayop si Yakub maka ba'anan hayop si Leban. ");
INSERT INTO sml_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tiyap-tiyap aniya' hayop d'nda ahāp baranna ya magd'nda, pinat'nna' e' si Yakub saga sanga kayu nijali'-jali' ma deyom paginuman bo' supaya magd'nda ma kasekotan saga sanga-i. ");
INSERT INTO sml_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Saguwā' bang hayop kulang ahāp ya magd'nda, mbal pinat'nna'an kayu-kayu. Ya kat'kkahanna, in hayop kulang hāpna pinasuku' ma si Leban. Malaingkan ya pinasuku' ma si Yakub anak hayop ahāp sadja baranna. ");
INSERT INTO sml_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ya kat'kkahanna, paheka na pa'in bo' paheka karaya si Yakub. Gana-gana aheka na ba'anan bili-bili maka kambingna. Aheka isab saga unta'na maka kura'na. Ya du saga sosoho'anna d'nda-l'lla, aheka du isab. ");
INSERT INTO sml_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Na, kahaka'an si Yakub in iya pinah'llingan ala'at e' saga ipalna anak si Leban. Yuk sigām, “Saga kahayop-hayopan mma'ta wa'i ta'ā' e' si Yakub. Ya angkan iya dayahan ma sabab pangalta' bay suku' si Mma'.” ");
INSERT INTO sml_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ta'nda' isab e' si Yakub apinda na addat si Leban ma iya, ngga'i ka na buwat bay tagna'. ");
INSERT INTO sml_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Magkallam PANGHŪꞋ ma si Yakub, yukna, “Pabīng ka pehē' ni lahat kamatto'ahannu, ni kakampungannu. Pataptap du aku ma ka'a ma l'ngnganannu.” ");
INSERT INTO sml_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Anambuku magtūy si Yakub ma disi Rakiya maka si Leya. Sinō' sigām kaleya ni iya, ni tongod pagipatanna hayop. ");
INSERT INTO sml_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Makat'kka pa'in sigām pehē', yukna ma sigām, “Saga dayang, tasayuku apinda na pamaihu'an mma'bi ma aku, ngga'i ka buwat bay dahū. Daipara tatabang aku e' Tuhan ya pagtuhanan mma'ku. ");
INSERT INTO sml_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Makata'u kam bay pagsangsā'ku maghinang ma deyoman mma'bi. ");
INSERT INTO sml_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Sagō' minsan na, parupangna sadja aku pagka pinagpinda-pinda e'na gadjiku. Ngga'i ka hal min t'dda, min sangpū'. Daipara halam aku bay tainay e'na sabab mbal bilahi Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Bang saupama aniya' h'lling si Leban ma aku, yukna, ‘saga hayopan b'ttikan ya panganggadjiku ma ka'a,’ na, b'ttikan lullun ya nianakan e' saga hayop inān. Ya du bang pindahanna llingna bo' yukna, ‘hayop jali'-jali'an ya panganggadjiku ma ka'a,’ na, jali'-jali' na pa'in ya nianakan e' saga hayop kamemon. ");
INSERT INTO sml_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hatina Tuhan ya bay angala'anan karaya mma'bi bo' pamuwanna ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Anuli-nuli gi' si Yakub, yukna. “Aniya' bay tauppiku ma waktu pagd'nda saga kambing. Kabang-kabang maka jali'-jali'an lullun saga kambing l'lla ya ta'nda'ku magd'nda ma deyom uppiku. ");
INSERT INTO sml_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Jari aniya' pah'lling mala'ikat Tuhan ma aku, yukna, ‘O Yakub!’ “Ya sambungku, ‘Oy, itiya' aku.’ ");
INSERT INTO sml_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Agsai angabtang mala'ikat-i, yukna, ‘Ang'nda' ka pehē'. Saga kambing l'lla ya magd'nda ilu, kabang lullun maka jali'-jali'an. Min kabaya'anku ko' ilu, sabab kata'uwanku bay pamarupang si Leban ma ka'a. ");
INSERT INTO sml_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aku ya Tuhan bay magpa'nda' ma ka'a ma lahat Betel. Ya na lahat bay pamat'nggehannu batu pangentomannu ma aku, lahat isab bay pagnajalannu. Na,’ yukna, ‘magsakap na ka buwattina'an bo' ka amole' pehē' ni lahatnu porol.’ ” ");
INSERT INTO sml_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Na anambung disi Rakiya maka si Leya. Yuk sigām ma si Yakub, “Tuwan, halam aniya' pusaka' taholat kami min si Mma'. ");
INSERT INTO sml_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tahinang kami sali' a'a liyu, ngga'i na ka anakna lissi. Bang pinagbahasa, in kami itu sali' dagangan pinab'llihan e'na, sagō' aubus e'na b'llihanna. ");
INSERT INTO sml_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ya kataluwa'anna, in pangalta' bay kala'anan e' Tuhan min si Mma' palsuku'an na ma kami maka ma saga ka'anakantam. Angkan na, tuwan, beya'un sadja ai-ai panoho'an Tuhan ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Manjari itu magsakap na si Yakub amole' pehē' ni mma'na ma lahat Kana'an. Pinakura' e'na anak-h'ndana ma saga unta', maka pinal'ngngan saga ba'anan hayopna kamemon dahū min iya. Binowa isab ai-aina kamemon ya bay tausahana t'ggolna bay ma lahat Mesopotami. ");
INSERT INTO sml_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Na, alikut pa'in si Leban magguntingan bulbul saga bili-bilina, tinangkaw saga ta'u-ta'u pagtutuhananna e' anakna si Ripka. ");
INSERT INTO sml_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jari si Leban bangsa Aram bay kalimbungan e' si Yakub, pagka halam pinata'u pasal mohot si Yakub ala'an na amole' ni lahatna. ");
INSERT INTO sml_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jari magdai'-dai' si Yakub ala'an maka e'na amowa ai-ai palsuku'anna kamemon. Pauntas iya ni dambila' sapa' Alpurati bo' patudju pehē' ni kabūd-būran ma lahat Giliyad. ");
INSERT INTO sml_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Manjari makalabay pa'in t'llumbahangi, kahaka'an si Leban pasal kala'an disi Yakub. ");
INSERT INTO sml_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tinurul iya magtūy e' si Leban maka saga kampungna, pitumbahangi ya t'ggol kapanurulna. Yamboho' ta'abutna disi Yakub ma kabūd-būran lahat Giliyad. ");
INSERT INTO sml_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Jari ma sangom e' aniya' pah'lling Tuhan ma si Leban ma deyom uppina. Yuk Tuhan ma iya, “Amay-amay, da'a sanggupin si Yakub, ai-na ka ahāp, ai-na ka ala'at.” ");
INSERT INTO sml_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Na, ina'an disi Yakub pahanti' ma kabūd-būran lahat Giliyad pagabut si Leban ma iya. Pahanti' isab si Leban maka saga kampungna ma tongod ina'an-i. ");
INSERT INTO sml_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Manjari itu ah'lling si Leban ma si Yakub, yukna, “Otō', angay aku akkalannu? Angay buwattilu pamowanu ma saga anakku? Bā'nu d'nda tasaggaw! ");
INSERT INTO sml_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Angay ka ala'an patapuk, halam minsan ama'id min aku? Bang ka bay ama'id, bay du pa'in kam tapatulakku ma deyom paglami-lamihan maka saga kalangan. Bay ka isab kabiyulahan maka katambulan. ");
INSERT INTO sml_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Angay aku halam minsan pasiyumnu ma saga anak-mpuku bo' kami mag'bba sangkahāpan? Dupang-dupang ka maghinang buwattilu! ");
INSERT INTO sml_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aniya' kapatutku angala'at ma ka'a, daipara talāng aku dibuhi' e' Tuhan ya pagtuhanan mma'nu, da'a sinō' ananggupan ka'a. ");
INSERT INTO sml_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kata'uwanku du bang ai sababna ya angkan ka ala'an. Tu'ud ka angentom lahatnu maka kakampungannu. Sagō' iya paginu-inuhanku, angay tangkawnu saga ta'u-ta'uku?” ");
INSERT INTO sml_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Anambung si Yakub ma si Leban, yukna, “Bapa', angkan aku halam ama'id min ka'a sabab tināw aku. Pangannalku in saga anaknu d'nda itu niagaw min aku. ");
INSERT INTO sml_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Sagō' in pasal saga ta'u-ta'unu, Bapa', sitta'aku. Bang hati tabāknu ma deyom duwa'an kami, minsan ma sai-sai, subay iya pinapatay. Itiya' kakampunganta anaksi'. Na, piha'un to'ongan. Bang aniya' tapihanu maitu ai-ai palsuku'annu, ngā'un na.” Tu'ud awam si Yakub, halam tasayuna in si Rakiya bay anangkaw saga ta'u-ta'u ya pagtuhanan mma'na. ");
INSERT INTO sml_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Manjari tolda si Yakub ya pamiha'an si Leban dahū. Pasunu', tolda si Leya, bo' ni deyom tolda duwangan ipatan d'nda. Sagō' halam tabāk maina'an saga ta'u-ta'u. Pagpuwas, pasōd na isab iya ni deyom tolda si Rakiya. ");
INSERT INTO sml_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Na in ta'u-ta'u itu bay tinapukan asal e' si Rakiya ma pakol unta'na bo' tiningkō'an e'na. Makasōd pa'in si Leban, agsai binulangkayat e'na duwa'an kamemon ya ma deyom tolda inān, sagō' halam aniya' tapihana. ");
INSERT INTO sml_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ah'lling si Rakiya ma mma'na, yukna “Mma', da'a pa'in ala'at ataynu ma aku. Ampunun aku, sabab itiya' aku binulan, ya po'on aku mbal makat'ngge ma kamaitunu.” Na, minsan buwattingga e' si Leban amiha ta'u-ta'una inān, halam to'ongan tabāk maina'an. ");
INSERT INTO sml_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Manjari akalintaw si Yakub, angkan yukna ma mato'ana, “Ai dusaku? Sara' ai bay talanggalku ya angkan aku turulnu pi'itu? ");
INSERT INTO sml_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tajagjagnu duwa'anku kamemon. Aniya' bahā' suku'nu tabāknu mailu? Bang hati aniya', paluwasun kono' pi'itu ma pang'nda'an saga lahasiya'ta itu ati sigām ya maghukum ma kita duwangan bang sai magsab'nnal, ka'a ka atawa aku. ");
INSERT INTO sml_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Duwampū' tahun,” yuk si Yakub, “bay t'ggolku ma deyomannu. Halam aniya' bili-bilinu atawa kambingnu kapulakan. Maka halam aku bay makakakan minsan dakayu' kambingnu l'lla. ");
INSERT INTO sml_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tiyap-tiyap bang aniya' hayop tatanggal e' sattuwa talun, halam bay bowaku ni ka'a. Sagō' akuhanku sinambi'an minsan ngga'i ka suku'ku. Maka bang aniya' hayopnu tinangkaw sumiyan-sumiyan, llaw ka atawa sangom, patanggungnu na pa'in ma aku, soho'nu ginanti'an ma aku. ");
INSERT INTO sml_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Buwattē' na pa'in bay kahālanku. Kapasu'an aku sidda ma ka'llawan, kahaggutan ma waktu sangom. Ai na ka llaw, ai-na ka sangom, halam ahāp e'ku atuli. ");
INSERT INTO sml_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Buwattē' sadja kahālanku ma deyomannu duwampū' tahun t'ggolna. Sangpū' maka mpat tahun isab ya t'ggolku maghinang ma ka'a supaya ta'ā'ku h'nda duwangan anaknu itu. Nnom tahun isab ya kapaghinangku ma ka'a supaya aniya' saga hayop ma aku. Aheya asal untungnu min aku, sagō' minsan na, min pila bay pagpinda-pindanu panganggadjinu ma aku. ");
INSERT INTO sml_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Daipara nientom aku e' Tuhan, ya pagtuhanan mbo'ku si Ibrahim, ya pagmatāwan mma'ku si Isa'ak. Bang aku halam bay bogboganna, arak aku bay patulaknu ma halam aniya' ai-ai tabowaku. Saguwā' ta'nda' e' Tuhan katiksa'anku sampay lu'ug-liksa'ku ma deyomannu. Ya he' sababna angkan ka'a nilāng e'na dibuhi'.” ");
INSERT INTO sml_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ya sambung si Leban ma si Yakub, “Aku ya tag-dapu ma ai-ai kamemon ilu. H'ndanu ilu, anakku du. Anaknu ilu, mpuku du. Kaba'anan hayop ilu, aku ya tag-dapuna. Saguwā' minsan na, halam na aniya' dapatku angokoman saga anakku maka ka'anakan sigām. ");
INSERT INTO sml_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Manjari Otō', in kita itu subay magjanji' buwattina'an. Subay kita amangkat batu isab pangentoman supaya mbal takalipatta.” ");
INSERT INTO sml_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Magtūy aniya' batu dansolag pinuwa' e' si Yakub niosol maina'an. ");
INSERT INTO sml_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yuk isab si Yakub ma saga a'ana, “Angahangkut kam batu pinatumpuk pi'itu.” Pagubus, mahē' na sigām amangan ma bihing tumpukan batu he'. ");
INSERT INTO sml_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Na ya pangōn si Leban ma tumpukan batu he' bang ma bahasa sigām, Jegar Sahaduta. Ya pangōn si Yakub, ma bahasana isab, Gale'ed. ");
INSERT INTO sml_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ya pamissala si Leban ma si Yakub, “Ya tumpukan batu itu paltanda'an in kita duwangan bay makapagjanji' ma llaw itu.” Angkanna tumpukan e' kaōnan Gale'ed. ");
INSERT INTO sml_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Niōnan Mispa isab ma sabab kabtangan si Leban, ya yukna, “Bang pa'in kita pineyanan e' si Yawe sat'ggolta magsaddī lahat.” ");
INSERT INTO sml_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Aniya' gi' lling si Leban, yukna, “Bang ka saupama aminjala' saga anakku itu atawa magh'nda ma d'nda saddī, entomun to'ongan, ilu du Tuhan ang'nda' ma kita minsan halam aniya' makata'u. ");
INSERT INTO sml_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","“Nda'un isab,” yuk si Leban, “tumpukan batu itu maka batu bay osolanta. ");
INSERT INTO sml_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Paltanda'an ko' itu ma kita duwangan ma pasal paljanji'anta dakayu'. In aku itu mbal paliyu min tumpukan batu itu angala'at ma ka'a. Damikiyanna isab, in ka'a ilu mbal paliyu min batu itu angala'at ma aku. ");
INSERT INTO sml_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Na, mura-murahan bang pa'in kita nihukum e' Tuhan ya pagtuhanan mbo'nu si Ibrahim maka pagtuhanan mbo'ku si Nahor.” Manjari anapa na si Yakub ma ōn Tuhan ya pagmatāwan e' mma'na si Isa'ak. Ya pagsapana in iya amogbog ma paljanji'an sigām. ");
INSERT INTO sml_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sakali itu, aniya' hayop sinumbali' e' si Yakub maina'an pagkulbananna ni Tuhan. Nilinganan isab saga kakampunganna sinō' magjamu. Jari maina'an sigām magtulihan ma bihing būd inān. ");
INSERT INTO sml_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Pagdai' llaw pa'in siniyum e' si Leban saga mpuna maka saga anakna. Niamu'-amu'an isab sigām kahāpan bo' yampa iya amole' ni lahatna. ");
INSERT INTO sml_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ya du si Yakub bay pauntas ni patudjuhanna. Sakali itu, ma labayan pa'in, aniya' saga mala'ikat min Tuhan anampang iya. ");
INSERT INTO sml_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ya lling si Yakub pag'nda'na ma sigām, “Kilāku, pat'nna'an kasundaluhan Tuhan ko' itu.” Ati Mahanaim ya pangōnna ma lahat inān. ");
INSERT INTO sml_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Manjari aniya' panoho'an si Yakub ma saga a'ana, yukna, “Parahū kam min aku ni danakanku si Esaw, ina'an ma jadjahan Se'er, ma lahat Edom. ");
INSERT INTO sml_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ya llingbi ma iya subay buwatittu, ‘Tuwan, aniya' itu lapal min atanu si Yakub. Yuk lapal itu, “At'ggol aku bay maglahat ma deyoman si'itta si Leban. Halam aku bay magla'an-la'an minnē'. ");
INSERT INTO sml_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aheka na hayop palsuku'anku, buwat saga sapi', kura', bili-bili, maka kambing. Aheka na isab saga sosoho'anku d'nda-l'lla. Manjari, tuwan, ya angkan pabowaku lapal itu ni ka'a, bang pa'in aku taima'nu magatay pote'.” ’ ” ");
INSERT INTO sml_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Sakali itu, makabīng pa'in saga a'a bay pamabowahan lapal si Yakub, aniya' pangahaka sigām ma iya, yuk-i, “Tuwan, bay kami patampal pehē' ni danakannu si Esaw, maka ilu'un na iya pasampang ma ka'a. Aniya' ma iya saga tendogna mpat hatus hekana.” ");
INSERT INTO sml_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Na, sinōd tāw magtūy si Yakub, aheya to'ongan kasusahanna, angkan binahagi' duwa saga a'a ya bebeya'anna. Ya du ba'anan hayopna sampay saga unta'na, binahagi' duwa isab. ");
INSERT INTO sml_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ya ma deyom pikilan si Yakub, bang si Esaw ganta' pina'an amono' sigām, makal'ppa sigām dabahagi'. ");
INSERT INTO sml_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jari angamu'-ngamu' si Yakub ni Tuhan, yukna, “O Tuhanku, ka'a ya pagtuhanan mbo'ku si Ibrahim maka mma'ku si Isa'ak, angamu' aku tabang ma ka'a. O Yawe, ka'a ya bay anoho' aku subay amole' ni lahatku maka ni kakampunganku. Bay aku janji'annu isab in aku buwanannu kahāpan ma ai-ai hinangku. ");
INSERT INTO sml_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Atanu aku, a'a mbal tinōp subay nihāp e'nu. Sagō' minsan na, aheya ase' maka lasanu ma aku. Waktu lagi' kauntasku ni dambila' sapa' Jordan, halam aniya' tabowaku, luwal la'a dakayu' tungkud ma tanganku. Saguwā' ma buwattina'an itiya' na aku magduwa tumpukan ma labayan tudju amole'. ");
INSERT INTO sml_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Tuhan, tabangin aku sabab aheya kagawahanku ma siyakaku si Esaw. Pi'itu iya arai' amono' aku sampay saga anak-h'ndaku. ");
INSERT INTO sml_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Entomun lagi' bay paljanji'annu ma aku, in aku buwanannu kahāpan, maka buwanannu aku tubu' mbal taitung hekana, sapantun heka solagan gusung ma bihing tahik.” Ya na he' pangamu'-ngamu' si Yakub ma Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Manjari pahanti' iya maina'an dambahangi. Pagsubu, amene' iya hayop aheka pamasampangna ma si Esaw. ");
INSERT INTO sml_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ya tapene'na duwa hatus kambing d'nda maka duwampū' kambing l'lla, duwa hatus bili-bili d'nda maka duwampū' bili-bili l'lla, ");
INSERT INTO sml_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","t'llumpū' unta' d'nda taga-anak masi anganduru', mpatpū' sapi' d'nda maka sangpū' sapi' mandangan, duwampū' kura' d'nda maka sangpū' kura' l'lla. ");
INSERT INTO sml_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jari pinagbahagi' magba'an-ba'an saga hayop itu e' si Yakub ati patunggu'anna ma saga a'ana. Ya panoho'anna ma sigām, “Pauntas kam dahū min aku. Paglawak-lawakunbi isab saga hayop ilu damba'an maka damba'an.” ");
INSERT INTO sml_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Aniya' isab pamandu'na ma sosoho'anna dakayu' ya parahū min kamemon, yukna, “Bang ka saupama talanggal e' siyakaku, bo' yukna ma ka'a, ‘Pi'ingga ka, maka sai nakura'nu, maka sai isab tag-dapu saga hayop ilu?’ ");
INSERT INTO sml_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ya panambungnu ma iya subay buwattitu. Yuknu, ‘Tuwan, atanu si Yakub ya tag-dapu itu kamemon. Sinō' binowa pi'itu ni ka'a kasampangan. Ilu'un na iya paturul min buli'an.’ ” ");
INSERT INTO sml_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ya du panoho'an si Yakub ma saga a'ana magsunu'-sunu' ya tag-tunggu'an saga hayop kasehe'. Yukna, “Bang kam ganta' talanggal e' siyakaku si Esaw, ya pangahakabi ma iya subay buwattitu, ");
INSERT INTO sml_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Aho' tuwan, ilu'un du atanu si Yakub paturul min buli'an.’ ” Ya ma deyom pikilan si Yakub, bang aniya' kasampangan pinabeya'an si Esaw dahū gi' min kapaglanggal sigām, kalu ahāp atayna tudju ni si Yakub ati magkahāp sigām pabīng. ");
INSERT INTO sml_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Manjari pinarahū e' si Yakub kasampanganna inān kamemon. Sagō' si Yakub baranna angagad gi' ma pahanti'an sigām dambahangi. ");
INSERT INTO sml_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Na, ma sangom inān, papunduk si Yakub min patulihanna. Niā' h'ndana karuwangan maka ipatan sigām, sampay anakna l'lla kasangpū' maka dda. Ni'nde'an sigām e'na pehē' ni dambila' sapa' Jabbok. ");
INSERT INTO sml_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ma dambila' pa'in saga anak-h'ndana, pinauntas isab e' si Yakub kaniya'na kamemon. ");
INSERT INTO sml_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sagō' in iya baranna pat'nna' dangan-danganna ma tongod ina'an. Sakali aniya' magpasalupa ma si Yakub amowa iya magkosogan sampay asekot ni karai'-llawan ");
INSERT INTO sml_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Na, pagnanam e' a'a inān in si Yakub mbal tara'ugna, magtūy tibu'na ma pangkulna ati magsā' lo'atanna. ");
INSERT INTO sml_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ya yuk a'a-i ma iya, “Bbahin aku, marai' na llaw.” Anambung si Yakub, yukna, “Ē, mbal ka bbahanku. Subay ka amuwanan aku barakat dahū.” ");
INSERT INTO sml_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Manjari tinilaw si Yakub bang sai ōnna. “Si Yakub,” yukna. ");
INSERT INTO sml_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Angabtang a'a inān, yukna, “Ngga'i ka na Yakub ya pangōn ka'a puwas minnitu, sagō' si Isra'il na, ma sabab kapagkosognu maka Tuhan maka ma pagkahinu manusiya'. Bay tara'ugnu sali'-sali'.” ");
INSERT INTO sml_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ah'lling gi' si Yakub, “Tuwan, pahati'un aku kono' bang sai ōnnu.” Anambung a'a-i, yukna, “Oy, angay tilawnu ōnku?” Manjari barakatanna si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ya pah'lling si Yakub, “Arī, magharap aku maka Tuhan, bo' pa'in itiya' aku masi allum.” Angkanna lahat inān niōnan Peniyēl e' si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yamboho' paluwas mata llaw ma waktu kalanjal si Yakub min lahat Peniyēl e'. Magpengka'-pengka' isab iya ma sabab dambila' lo'atan pangkulna magsā'. ");
INSERT INTO sml_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ya he' sababna angkan bangsa Isra'il mbal to'ongan amangan ugat sumbali'an ya ma lo'atan pangkul. Ya ina'an addat sigām sampay ni kabuwattituhan, tu'ud nientom mbo' sigām si Yakub bay waktu kapanibu' pangkulna. ");
INSERT INTO sml_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Manjari itu, maka'nda' pa'in si Yakub ni dahuanna, ilu na si Esaw maka saga tendogna mpat hatus puhu'. Magtūy pinapagtumpuk e' si Yakub saga onde'-onde' maka kaina'an sigām magkaniya-kaniya. ");
INSERT INTO sml_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ya pinarahū e'na si Bilha maka si Silpa sampay saga anak sigām. Pasunu' disi Leya maka saga anakna, ati karamulihan si Rakiya maka anakna si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Si Yakub baranna ya parahū min kamemon. Na, asekot-sekot pa'in iya ni si Esaw, magtūy iya pasujud min pitu' pagaddatna ma siyakana. ");
INSERT INTO sml_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Malaingkan si Esaw paragan anampang si Yakub. Anganggapus iya maka aniyum, ati magtangis sigām karuwangan. ");
INSERT INTO sml_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Pag'nda' si Esaw ma saga kar'ndahan maka saga onde'-onde', atilaw iya ma si Yakub, yukna, “Sai kasehe'annu ilu?” Ya sambung si Yakub, “Kaka' tuwan, ya na itu ka'anakan bay pangalidjiki' Tuhan ma aku, ya atanu itu.” ");
INSERT INTO sml_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Manjari pasōng isab saga ipatan si Yakub maka ka'anakan sigām, ati pasujud ma dahuan si Esaw. ");
INSERT INTO sml_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Pasunu' isab si Leya maka saga anakna, karamulihan si Rakiya maka anakna si Yusup, pasujud sigām kamemon. ");
INSERT INTO sml_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Atilaw gi' si Esaw, yukna, “Pamagay ba'anan tumpukan hayop bay talanggalku ma lān ina'an? Ai kagunahanna?” Ya sambung si Yakub, “Ya kagunahanna, Kaka' tuwan, pamuwanku ma ka'a pamahāp ataynu tudju ni aku.” ");
INSERT INTO sml_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Yuk si Esaw, “Otō', da'a na. Aheka du ma aku. Mailuhun na ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yuk si Yakub, “Ndū', Kaka' tuwan, bang sab'nnal-b'nnal ahāp na ataynu ma aku, taima'un kasampanganku itu ma ka'a. Ya pagharapku maka ka'a llaw itu, sali' hantang pagharapku maka Tuhan, sabab ahāp sidda pamaihu'annu ma aku. ");
INSERT INTO sml_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Taima'un, Kaka' tuwan, ya kasampanganku itu ma ka'a, sabab aheya kahāpan ya bay pamuwan Tuhan ma aku. Halam aniya' kulang ma aku.” Jari tinaima' na e' si Esaw pagka tapogos e' si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Na,” yuk si Esaw, “Sūng na kitam. Sehe'anta kam.” ");
INSERT INTO sml_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sagō' mbal si Yakub. Yukna, “Kaka' tuwan, kata'uwannu du. Alamma saga onde'-onde' itu. Maka pagsusahanku isab saga bili-bili maka saga sapi' taga-anak duru'an lagi'. Bang puspusanta pal'ngngan minsan dang'llaw sadja, marai' magpatayan du kamemon. ");
INSERT INTO sml_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ndū', Kaka',” yuk si Yakub ma si Esaw, “parahū gi' ka min kami. Kami maka saga anakku sampay saga ba'anan hayop itu subay paturul min damuliannu. Painut-inut sadja kami pal'ngngan sampay ka ta'abutku mahē' ma lahat Se'er.” ");
INSERT INTO sml_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“Na aho', Otō',” yuk si Esaw. “Bbahanku isab saga a'aku pagapi' ma ka'am.” Yuk si Yakub, “Minsan mbal na, Kaka' tuwan. Ya sadja aheya ma aku bang pa'in ahāp na ataynu ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Manjari ma llaw ina'an-i magpamole' na disi Esaw ni lahatna Se'er. ");
INSERT INTO sml_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sagō' si Yakub iya pehē' gom pa'in ni lahat Sokkot. Ma Sokkot pa'in, angahinang iya luma' pat'nna'anna maka saga anak-h'ndana. Angahinang isab iya saga kamalig pasindungan ba'anan kahayopanna. Ya he' sababna angkan lahat inān niōnan Sokkot. ");
INSERT INTO sml_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ya hatulanna, makapole' pa'in si Yakub min lahat Mesopotami, at'kka na ni lahat Kana'an ma halam aniya' baya-baya. Tat'kkana da'ira Sekem ati maina'an iya magpat'ngge tolda pagluma'an sigām, ina'an ma anggopan da'ira. ");
INSERT INTO sml_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Manjari ya tana' pat'nna'an sigām inān bay bin'lli e'na min saga panubu' si Hamor mma' si Sekem, dahatus pilak tibu'uk ya pam'llina. ");
INSERT INTO sml_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Aniya' isab pagtunu'an kulban nihinang e' si Yakub ma tana' ina'an. El-Elohe-Isra'il ya pangōnna ma pagkukulbanan inān. ");
INSERT INTO sml_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Na, aniya' anak si Yakub maka si Leya budjang, ōnna si Dina. Dakayu' llaw pal'ngngan si Dina itu anibaw saga bagayna d'nda, a'a Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Jari ta'nda' iya e' si Sekem anak si Hamor, ya pagbebeya'an ma lahat inān. (A'a bangsa Hīb disi Hamor itu.) Pag'nda' si Sekem ma si Dina, magtūy saggawna bo' yampa usiba'anna. ");
INSERT INTO sml_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sagō' ka'amuhan iya ma si Dina he' maka sinōd lasa. Jari bissalahanna pahāp-hāp, kalu tabowa alasa isab ma iya. ");
INSERT INTO sml_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yuk si Sekem ma mma'na si Hamor, “Mma', pah'nda'un ma aku d'nda itu.” ");
INSERT INTO sml_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sakali itu, makata'u pa'in si Yakub pasal pangusiba' itu ma anakna si Dina, halam aniya' tapah'llingna pasal palkala' itu. Subay na bay makapole' saga anakna min kaparangan, min hinang sigām anunggu' kahayopan. ");
INSERT INTO sml_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Manjari si Hamor, ya mma' si Sekem-i, pehē' ni si Yakub amowa iya maggara'. ");
INSERT INTO sml_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Maina'an isab saga anak si Yakub l'lla baha'u bay at'kka min deya. Kahaka'an pa'in sigām pasal palkala' itu, magtūy sigām astolan makalandu' ma sabab pangusiba' si Sekem ma danakan sigām si Dina. Mbal to'ongan manjari, talapay saga a'a Isra'il kamemon nihinangan kaiya'an. ");
INSERT INTO sml_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ah'lling si Hamor ma si Yakub maka saga anakna-i, yukna, “Ndū' tuwan, in anakku si Sekem itu aheya to'ongan baya'na ma anaknu si Dina. Taima'un iya, pah'nda'un ma anaknu. ");
INSERT INTO sml_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ahāp kitam magpikit-pikiti d'nda maka l'lla. ");
INSERT INTO sml_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bang hati buwattē', makapaglahat du kam maitu maingga-maingga kabaya'anbi pat'nna'an. Aluhaya du kam angusaha maitu, makajari isab am'lli tana'.” ");
INSERT INTO sml_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ah'lling isab si Sekem ma mma' si Dina sampay ma saga danakanna, yukna, “Ndū', saga Tuwan, bang pa'in aku makasulut ataybi. Ai-ai amu'bi ma aku pamuwanku du ma ka'am. ");
INSERT INTO sml_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Haka'inbi aku bang pila ungsudna maka sokatna ati akuhanku du, bang aku pakawinbi ma si Dina.” ");
INSERT INTO sml_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sagō' angakkal saga anak si Yakub ma si Sekem maka mma'na si Hamor, ma sabab pangusiba'na ma danakan sigām si Dina. ");
INSERT INTO sml_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yuk sigām, “Ē, mbal makajari. In danakan kami itu mbal tapah'lla ma l'lla halam bay taislam. Kaiya'an ko' ilu ma kami. ");
INSERT INTO sml_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Magsulut du kitam bang pa'in ni'islam kal'llahanbi kamemon, buwat pagislam ma kami. ");
INSERT INTO sml_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Jari magpikit-pikiti du kitam. Magdalahat kitam magdabangsa. ");
INSERT INTO sml_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Malaingkan bang kam mbal ameya' ma gara' kami itu, pagka mbal bilahi magislam, na, ngā' kami na danakan kami d'nda itu bo' ala'an minnitu.” ");
INSERT INTO sml_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Manjari kasulutan si Hamor maka anakna si Sekem ma gara' bay nihūgan sigām e' saga anak si Yakub e'. ");
INSERT INTO sml_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mbal pa'in at'ggol, bineya' e' si Sekem gara' sigām ma sabab baya'na ma si Dina anak si Yakub. Si Sekem ya pinagaddatan asal labi min kakampunganna kasehe'an. ");
INSERT INTO sml_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Manjari pehē' na iya maka mma'na si Hamor ni tongod pasōran da'ira bo' amowa magisun saga l'lla ya magtipun maina'an. ");
INSERT INTO sml_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Yuk sigām, “Saga tuwan, in bangsa Isra'il itu patibagayun asal. Ahāp bang sigām tugutanta maglahat maitu maka magusaha isab ma deyom kaluhaya'an, sabab aluha asal lahattam. Ahāp isab bang tugutantam saga anak sigām subul-budjang magkawin-kiyawani maka anaktam. ");
INSERT INTO sml_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Saguwā' mbal gi' sigām makajari magdalahat-magdabangsa maka kitam. In kitam kal'llahan subay magislam dahū buwat kapagislam ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Manjari bang beya'ta addat sigām e', in hayop sigām kamemon maka pangalta' sigām kamemon ma kitam du ma waktu sinōng. Jari patut bahā' bang kitam magsulut supaya sigām maglahat maitu ma kitam?” ");
INSERT INTO sml_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Manjari kasulutan saga l'lla ma da'ira inān kamemon. Bineya' e' sigām gara' si Hamor maka anakna si Sekem ati magislam sigām kamemon. ");
INSERT INTO sml_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Na, palabay pa'in t'llumbahangi min bay pagislam e', bo' halam gi' kauli'an, pina'an na duwangan anak si Yakub l'lla, si Simiyun maka si Libi ya langgung si Dina. Pasōd sigām magtakos kalis ni deyom da'ira inān ma halam aniya' pangalab-ngalab saga a'a maina'an. Jari nilagut pinapatay saga l'lla inān kamemon e' sigām karuwangan. ");
INSERT INTO sml_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Talapay isab si Hamor maka anakna si Sekem pinapatay. Si Dina iya niā' e' sigām min deyom luma' si Sekem. ");
INSERT INTO sml_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Magpatayan pa'in saga a'a itu, paturul isab saga anak si Yakub kasehe'an anaban kamemon ai-ai bay ma deyom da'ira. Ya he' pamalos sigām ma kaiya'an danakan sigām budjang. ");
INSERT INTO sml_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tinaban e' sigām pangalta' kamemon ma deyom-luwasan da'ira inān, buwat saga kambing, bili-bili, sapi' maka kura', hatina ai-ai taga-guna. ");
INSERT INTO sml_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tinaban pangalta' kamemon bay ma deyom luma', sinaggaw isab saga d'nda maka kaonde'an kamemon. ");
INSERT INTO sml_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Na, kinata'uwan pa'in e' si Yakub hinang si Simiyun maka si Libi itu, magtūy pah'llinganna sigām. Yukna, “Arōy! Aheya kasusahan ya pamuwanbi itu ma aku. Binantahan du aku e' saga bangsa Kana'an maka bangsa Pirissi sampay bangsa a'a kamemon ma lahat itu. Ariki' du kitam. Bang sigām ganta' magdakayu' pi'itu angandugpak, tantu kitam alaglag kamemon magtai'anak.” ");
INSERT INTO sml_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ya sambung si Simiyun maka si Libi, “Pasagaranta bahā' bang danakan kami si Dina tahinang sali' d'nda pinagtatambahan?” ");
INSERT INTO sml_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Na aniya' panoho'an Tuhan ma si Yakub, yukna, “Patukad ka ni Betel bo' ka maglahat mahē'. Hinangun pagtunu'an isab mahē' pagkulbanannu ma aku, ya Tuhan bay magpa'nda' ma ka'a waktu lagi' kalahinu min siyakanu si Esaw.” ");
INSERT INTO sml_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ah'lling si Yakub ma saga anak-h'ndana sampay ma saga a'a bebeya'anna kamemon, yukna, “Timaninbi saga ta'u-ta'u kamemon ya pagtutuhananbi ilu. Sussihunbi baranbi pahāp bo' yampa kam magsalinan badju' al'ssin. ");
INSERT INTO sml_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pagubus, patukad kitam ni Betel ati angahinang aku pagkulbanan maina'an pangarapan ni Tuhan ya bay anabangan aku ma waktu kasukkalanku. Ginapi' na pa'in aku e'na pi'ingga-pi'ingga bay pal'ngngananku.” ");
INSERT INTO sml_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Manjari bineya' lling si Yakub e' saga a'ana inān ati sinōngan ni iya saga ta'u-ta'u sigām kamemon sampay saga aretes bay ma tainga sigām. Jari kinubul kamemonna e' si Yakub ma tongod po'on kayu pagduwa'ahan ya ma Sekem. ");
INSERT INTO sml_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pagubus, pasalta' pa'in disi Yakub atulak minnē', pinat'kkahan tāw aheya saga a'a ma kakauman Sekem angkan sigām mbal makatawakkal anurul disi Yakub amalos. ");
INSERT INTO sml_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Manjari itu magt'kkahan na si Yakub sampay saga a'ana kamemon ni Lūs, ya pinagōnan Betel ma tahun damuli itu. Ma lahat Kana'an ko' inān. ");
INSERT INTO sml_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Aniya' pagtunu'an kulban nihinang e' si Yakub mahē'. El-Betel ya pangōnna ma lahat inān, sabab ya na lahat bay pagpa'nda'an Tuhan ma iya waktu bay kalahina min siyakana. ");
INSERT INTO sml_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Amatay na si Debora, ya d'nda bay angayurahan si Ripka min kariki'-diki'na gi'. Takubul iya ma tongod dakayu' po'on kayu ya ma lūran lahat Betel. Allon Bakut (hatina Kayu Pagkarukka'an) ya pangōn a'a ma kayu inān. ");
INSERT INTO sml_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Na, ma waktu kapamole' si Yakub min lahat Mesopotami, bay magpa'nda' Tuhan ni iya pabalik maka amuwanan iya kahāpan. ");
INSERT INTO sml_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ya pangallam Tuhan ma iya, “Ōnnu si Yakub sagō' puwas itu ngga'i ka na si Yakub ya pangōn ka'a, sagō' si Isra'il na.” Hatina Tuhan to'ongan ya bay angōnan iya si Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Manjari angallam na isab Tuhan ma iya, “Aku itu Tuhan Sangat Kawasa. Anganak ka paheka, manjari ma waktu sinōng aniya' kabangsa-bangsahan patubu' min ka'a. Lāgi aniya' saga sultan isab luwa' min panubu'nu. ");
INSERT INTO sml_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ya lahat bay pamuwanku ma mbo'nu si Ibrahim maka mma'nu si Isa'ak pamuwanku isab ma ka'a sampay ma saga panubu'nu.” ");
INSERT INTO sml_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pagubus, ala'an na Tuhan min lugal bay pagsuli-sulihanna maka si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Na maina'an, ma tongod bay pangallaman Tuhan ma iya, aniya' batu niosolan e'na. Taosol pa'in, binusug e' si Yakub binu-anggul maka ns'llan jaitun ma diyata'na panukbal ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Manjari Betel ya pangōn si Yakub ma lahat ina'an-i. ");
INSERT INTO sml_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Pagpuwas, palanjal na si Yakub maka saga anak-h'ndana min Betel inān. Na alawak-lawak lagi' sigām min kauman Eprata, ta'abut na bulanan si Rakiya anganak. Kahunitan iya to'ongan. ");
INSERT INTO sml_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Jari itu, pagka makalandu' hunitna, yuk panday ma iya, “Ndū', Rakiya, da'a ka tināw, l'lla ko' itu.” ");
INSERT INTO sml_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Song pa'in ab'kkat napasna, si Benoni (hatina ‘anak kasusahanku’) ya ōn pang'bba si Rakiya ma anakna. Manjari amutawan na iya. Saguwā' Benjamin ya pangōn si Yakub ma onde'-onde' he'. ");
INSERT INTO sml_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Pagka amatay na si Rakiya, kinubul iya ma bihing lān tudju ni kauman Eprata, ya pinagōnan Betlehem ma tahun damuli itu. ");
INSERT INTO sml_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jari aniya' batu lakit niosolan e' si Yakub, batu panganggindanan kubul si Rakiya. Ina'an du isab sampay ni buwattina'an. ");
INSERT INTO sml_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Pagpuwas, palanjal na disi Yakub (ya pinagōnan isab si Isra'il) ati magpat'ngge tolda pagluma'an sigām ma liyuhan Migdal-Eder. ");
INSERT INTO sml_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sakali itu, waktu lagi' disi Isra'il pat'nna' ma liyuhan Migdal-Eder inān, makapagbihing anakna si Rubin maka h'nda-h'ndana si Bilha. Kahaka'an si Yakub pasal ina'an-i angkan akagit atayna. Na, si Yakub itu, sangpū' maka duwa anakna l'lla. ");
INSERT INTO sml_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ya itu saga anakna min si Leya: si Rubin ya pagsiyakahan, bo' si Simiyun, si Libi, si Yahud, maka si Issakar, si Sibulun ya kasiyalihan. ");
INSERT INTO sml_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Saga anak si Yakub min si Rakiya: si Yusup ya siyaka, bo' si Benjamin. ");
INSERT INTO sml_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Anakna isab min si Bilha ya ipatan si Rakiya: si Dān maka si Naptali. ");
INSERT INTO sml_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Anakna isab min si Silpa ya ipatan si Leya: si Gād maka si Aser. In sangpū' maka duwa anak si Yakub l'lla itu bay nianakan ma lahat Mesopotami. ");
INSERT INTO sml_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Manjari at'kka na si Yakub ni mma'na si Isa'ak ma lahat Mamre (hatina lahat Hebron), ya na lahat bay paglahatan si Isa'ak maka si Ibrahim. ");
INSERT INTO sml_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Na, ta'abut pa'in dahatus maka walumpū' tahun umul si Isa'ak, ");
INSERT INTO sml_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","awapat na iya ma deyom kasannangan, ati pinapagtimuk iya maka ka'mbo'-mbo'anna. Takubul iya e' anakna karuwangan si Esaw maka si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ya na itu salsila panugsugan saga panubu' si Esaw, ya pinagōnan isab si Edom. ");
INSERT INTO sml_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Min lahat Kana'an h'ndana kat'llungan. H'ndana dakayu' si Ada anak si Elon, a'a bangsa Hīt. Karuwana si Oholebama anak si Ana anak si Sebeyon, a'a bangsa Hīb. ");
INSERT INTO sml_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Kat'lluna si Basemat anak si Isma'il, ya magdanakan maka si Nebayot. ");
INSERT INTO sml_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Si Elepas ya anak si Esaw min si Ada, si Ruwil iya anakna min si Basemat. ");
INSERT INTO sml_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Saga anakna min si Oholebama, ya na si Jiyus, si Jalam maka si Kora. In itu kamemon bay nianakan ma si Esaw ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Manjari aniya' waktu pabutas na si Esaw min siyalina si Yakub, maglain ni lahat saddī. Tabeya' ma iya saga anak-h'ndana sampay saga tendogna kamemon. Tabowa isab kahayopanna sampay pangalta'na kamemon bay tausahana ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ya angkan si Esaw pabutas min si Yakub, sabab aheka makalandu' ba'anan hayop ya suku' sigā karuwangan, mbal s'ddong ma tana' bay paglahatan sigā he'. Mbal na sigā makapagdakayu' lahat. ");
INSERT INTO sml_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Manjari si Esaw, hatina si Edom, pehē' na ni kabūd-būran lahat Se'er bo' maglahat mahē'. ");
INSERT INTO sml_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ya na itu isab salsila panugsugan panubu' si Esaw, ya pang'mbo'an bangsa Edom, a'a kabūd-būran Se'er. ");
INSERT INTO sml_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Saga anak si Esaw l'lla: Si Elepas ya anakna min h'ndana si Ada, si Ruwil ya anakna min h'ndana si Basemat. ");
INSERT INTO sml_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Saga anak si Elepas l'lla: si Teman, si Omar, si Sepo, si Gatam maka si Kenas. ");
INSERT INTO sml_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Aniya' h'nda-h'nda isab si Elepas, ōnna si Timna, ya bay anganakan l'lla, ōnna si Amalek. Ya du ina'an saga mpu si Esaw min h'ndana si Ada. ");
INSERT INTO sml_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Saga anak si Ruwil l'lla: si Sera, si Samma maka si Missa. Ya du ina'an saga mpu si Esaw min h'ndana si Basemat. ");
INSERT INTO sml_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aniya' gi' anak si Esaw l'lla min h'ndana si Oholebama anak si Ana, mpu isab si Sebeyon: si Je'us, si Jalam maka si Kora. ");
INSERT INTO sml_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Itiya' na saga datu' bay patubu' min si Elepas anak si Esaw siyaka: si Teman, si Omar, si Sepo, si Kenas, ");
INSERT INTO sml_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","si Kora, si Gatam maka si Amalek. Si Ada h'nda si Esaw ya mbo' saga a'a magdaratu' itu ya bay panubu' si Esaw. ");
INSERT INTO sml_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Saga datu' isab bay patubu' min si Ruwil ya anak si Esaw dakayu': si Nahat, si Sera, si Samma maka si Missa. Si Basemat h'nda si Esaw ya mbo' sigām. ");
INSERT INTO sml_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Saga anak si Esaw isab min h'ndana si Oholebama anak si Ana: si Je'us, si Jalam maka si Kora, a'a magdaratu' kamemon. ");
INSERT INTO sml_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Manjari ya du ina'an saga bangsa maka ba'anan datu' sigām ya bay patubu' min si Esaw (ya pinagōnan isab si Edom). ");
INSERT INTO sml_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Na, in pasal saga bangsa porol ma lahat Edom, si Se'er bangsa Hōr ya pang'mbo'an sigām. Saga anak si Se'er ya tahinang datu', ya na si Lotan, si Sobal, si Sebeyon, si Ana, si Disun, si Eser maka si Disan. ");
INSERT INTO sml_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Saga anak si Lotan: si Hore maka si Homan. Si Timna ya danakan si Lotan d'nda. ");
INSERT INTO sml_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Saga anak si Sobal: si Alban, si Manahat, si Ebal, si Sepo maka si Onam. ");
INSERT INTO sml_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Saga anak si Sebeyon isab: si Aya maka si Ana. Si Ana itu bay makabāk bohe' amukal-mukal ma lahat paslangan, hinabuna magipat saga kura' mma'na. ");
INSERT INTO sml_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Saga anak si Ana: si Disun ya anakna l'lla, si Oholebama ya anakna d'nda. ");
INSERT INTO sml_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Saga anak si Disun: si Hemdan, si Esban, si Itran maka si Keran. ");
INSERT INTO sml_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Saga anak si Eser anak si Se'er: si Bilhan, si Sa'aban maka si Akan. ");
INSERT INTO sml_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Saga anak si Disan: si Ūs maka si Aran. ");
INSERT INTO sml_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Itiya' na isab ōn saga a'a pagdatu'an kabangsa-bangsahan Hōr ya bay maglahat ma lahat Se'er: si Lotan, si Sobal, si Sebeyon, si Ana, si Disun, si Eser maka si Disan. ");
INSERT INTO sml_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Na, ya na itu saga a'a magsusultan ma lahat Edom masa halam gi' aniya' sultan ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela anak si Beyor tahinang sultan ma bangsa Edom. Dinhaba ya ōn da'ira pagsultananna. ");
INSERT INTO sml_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Amatay pa'in si Bela, si Johab anak si Sera' ya pas'lle' aningkō' magsultan. A'a iya min lahat Bosla. ");
INSERT INTO sml_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Amatay pa'in si Johab, ya pas'lle' magsultan si Husam a'a min jadjahan bangsa Teman. ");
INSERT INTO sml_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Amatay pa'in si Husam, ya pas'lle' magsultan si Hadad anak si Bedad. Abit iya ōn da'ira pagsultananna. Si Hadad itu bay makara'ug ma bangsa Midiyan ma deyom lahat Mowab. ");
INSERT INTO sml_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Amatay pa'in si Hadad, ya pas'lle' magsultan si Samla min lahat Masleka. ");
INSERT INTO sml_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pagmatay si Samla, ya pas'lle' magsultan si Sa'ul, a'a min lahat Rehobot ma bihing sapa' aheya. ");
INSERT INTO sml_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Na, amatay pa'in si Sa'ul, ya pas'lle' magsultan si Ba'al-Hanan anak si Akbor. ");
INSERT INTO sml_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Amatay pa'in si Ba'al-Hanan anak si Akbor, ya pas'lle' magsultan si Hadad. Pau ya ōn da'ira pagsultananna. Si Mehetabel anak si Matered, mpu si Mesahab, ya h'nda si Ba'al-Hanan itu. ");
INSERT INTO sml_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Itiya' na isab ōn saga datu' bay patubu' min si Esaw, kaniya-kaniya sigām magsaddī-saddī lahat maka bangsa: si Timna, si Alba, si Jetet, ");
INSERT INTO sml_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","si Oholebama, si Ela, si Pinun, ");
INSERT INTO sml_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","si Kenas, si Teman, si Mibsar, ");
INSERT INTO sml_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","si Magde'el maka katapusan si Iram. Saga panubu' si Esaw itu kamemon bay datu' ma lahat Edom kaniya-kaniya ma paglahatan sigām. Na, ya na ina'an salsila pasal paltubu'anan si Esaw, ya po'onan bangsa Edom. ");
INSERT INTO sml_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2","Ya na itu salsila pasal si Yakub maka anak-mpuna. Maglahat asal iya ma Kana'an, ya lahat bay paghanti'an mma'na si Isa'ak. Manjari itu, ya anakna si Yusup wa'i angipat saga hayop sigām, beya' isab saga danakanna l'lla min saddī ina', min si Bilha maka si Silpa. Sangpū' maka pituntahun umul si Yusup ma waktu ina'an-i. Jari sinumbung e' si Yusup saga danakanna itu ni mma' sigām. Aniya' kono' hinang sigām mbal taluwa'. ");
INSERT INTO sml_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na, aheya lasa si Yakub ma si Yusup. Salasa-lasa iya ma anakna kasehe', alasa gi' ma si Yusup sabab anak ma kato'ana. Jari pinatahi'an e'na si Yusup juba alingkat. ");
INSERT INTO sml_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kinata'uwan pa'in e' saga dauranakan kaheya lasa si Yakub ma si Yusup, labi-labi min lasana ma sigām kasehe'an, magtūy sigām ab'nsi ma iya. Mbal na sigām amissala sangkahāpan ma iya. ");
INSERT INTO sml_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Manjari itu, aniya' waktu anguppi si Yusup. Kahaka'an pa'in dauranakanna pasal uppina, gom pa'in ab'nsi sigām ma iya. ");
INSERT INTO sml_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yukna ma sigām, “Ā, kalehunbi bay tauppiku. ");
INSERT INTO sml_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","In kitam kamemon bay ma huma magp'kkos pai, manjari ya p'kkosan pai bay ma aku magtūy an'ngge pabontol. Ya du saga p'kkosan pai bay ma ka'am, an'ngge isab bo' patilibut ni p'kkosanku ati pasujud.” ");
INSERT INTO sml_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sinambungan si Yusup e' danakanna, yuk sigām, “Ē! Ka'a ilu magsultan bahā' ma kami? Pagbaya'annu kami?” Pasōng gom pa'in kab'nsi sigām ma iya ma sabab uppina maka suli-sulina he'. ");
INSERT INTO sml_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Pinauppihan na isab si Yusup pabalik ati suli-sulihanna isab saga danakanna. Yukna ma sigām, “Kalehunbi pasal uppiku dakayu' itu. Tauppiku llaw maka bulan sampay saga bitu'un sangpū' maka ssa hekana pasujud ni aku.” ");
INSERT INTO sml_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Anuli-nuli isab si Yusup ma mma'na pasal uppina itu. Magtūy iya pinah'llingan e' mma'na, yuk-i, “Oy! Uppi ai ilu? Pikilnu bahā' in aku maka ina'nu sampay saga danakannu subay pasujud ni ka'a?” ");
INSERT INTO sml_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Manjari akagit atay saga danakan si Yusup ma iya. Sagō' kinannal e' mma'na palkala' inān. ");
INSERT INTO sml_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Manjari dakayu' llaw, pagka maina'an saga danakan si Yusup ma lahat Sekem angipat ba'anan kahayopan ya suku' mma' sigām, ");
INSERT INTO sml_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","aniya' panoho'an si Isra'il (hatina si Yakub) ma si Yusup. Yukna, “Otō', kata'uwannu asal, ina'an saga danakannu ma Sekem angipat hayop. Bilahi aku anoho' ka'a pehē'.” Ya sambung si Yusup, “Aho', Mma', pehē' aku.” ");
INSERT INTO sml_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yuk mma'na isab, “Na, pehē' na ka. Tibawun danakannu inān bang ahāp du kahālan sigām maka saga hayopta bo' ka amole' isab pi'itu angahaka'an aku.” Jari pinatulak iya min kapantayan Hebron tudju ni lahat Sekem. Pagt'kkana ni Sekem, ");
INSERT INTO sml_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","hinabuna amiha saga danakanna ma kaparang-parangan, aniya' a'a makalanggal ma iya. Yukna, “Otō', ai pihanu ilu?” ");
INSERT INTO sml_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ya sambung si Yusup, “Ya pihaku, tuwan, saga danakanku. Maitu kono' sigām angipat kahayopan kami. Kata'uwannu bahā' tuwan bang maingga sigām?” ");
INSERT INTO sml_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yuk a'a inān, “Ā, halam na sigām maitu. Takaleku sigām magsuli-suli, ni lahat Dotan kono'.” Manjari paturul si Yusup ni saga danakanna sampay ta'abutna sigām ma tongod Dotan. ");
INSERT INTO sml_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Na, alawak-lawak gi' si Yusup, ta'nda' iya he' saga danakanna. Magtūy iya pinagisunan pinapatay e' sigām. ");
INSERT INTO sml_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Yuk sigām dansehe'an, “O'o, nda'unbi. Ilu na si Pangunguppi. ");
INSERT INTO sml_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sūng, bono'ta iya ati timananta baranna ni deyom lowang bay pagtau'an bohe' itu. Ya pangahakata ma pasalna in iya bay pinapatay maka kinakan e' sattuwa talun. Nda'ta minnē' bang ai kapūsan uppina.” ");
INSERT INTO sml_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Na, pagkale pagisun itu e' siyaka sigām si Rubin, magtūy iya amikil bang buwattingga e'na anabang si Yusup bo' mbal kinala'atan e' saga danakanna. Yukna ma sigām, “Ndū', da'a iya papatayhunbi. ");
INSERT INTO sml_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Hūgta sadja iya ni lowang itu. Halam aniya' a'a maglahat maitu. Saguwā' da'a iya inay-inayunbi.” Angkan buwattē' lling si Rubin sabab magmaksud iya angā' si Yusup pabalik bo' pinapole' ni mma'na. ");
INSERT INTO sml_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ahā, pagt'kka si Yusup pehē' ni saga danakanna, magtūy iya sinaggaw e' sigām bo' niurusan jubana alingkat e'. ");
INSERT INTO sml_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Puwas e', binowa iya nihūg ni deyom lowang halam bohe'na sabab atigang na. ");
INSERT INTO sml_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sakali itu, hinabu saga danakan si Yusup aningkō' amangan, na, aniya' ta'nda' e' sigām saga a'a bangsa Isma'il. Ina'an sigām magturul-turul min lahat Giliyad tudju ni lahat Misil. Aniya' isab dagangan paruwa' ma saga unta' sigām, saga ginisan bulitik pahamut maka ginisan pamapā. ");
INSERT INTO sml_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ah'lling magtūy dakayu' danakan sigām ōnna si Yahud, “Ai untungna bang bono'ta siyalita itu bo' limbunganta kamatayna? ");
INSERT INTO sml_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Gom lagi' iya pab'llihanta ni saga a'a Isma'il itu. Da'a sadja iya mulata sabab danakanta du iya, dalaha' maka kitam.” Manjari kasulutan saga danakan si Yahud ma llingna he'. ");
INSERT INTO sml_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Manjari itu, makasekot pa'in saga a'a magdaragang e', nihella' si Yusup paluwas min deyom lowang bo' yampa pinab'llihan ma saga bangsa Isma'il e'. Ya b'llihanna duwampū' pilak tibu'uk. Pagb'lli pa'in, tabowa iya pehē' ni lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Na, pabalik si Rubin ni lowang bay pangahūgan si Yusup arak angā' iya. Pagdomolna halam maina'an si Yusup, agsai gineret e'na badju'na tanda' sin pagdukkana. ");
INSERT INTO sml_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Pabīng iya magdai'-dai' ni tongod saga danakanna bo' yukna, “Arōy! Halam maina'an si Yusup! Daka painay hinangku!” ");
INSERT INTO sml_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Jari, anumbali' sigām kambing ati niledje juba si Yusup maka laha'na. ");
INSERT INTO sml_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Binowa juba inān amole' bo' pina'nda'an ni mma' sigām. Ya yuk sigām, “Ndū' Mma', nda'un ba bay tabāk kami. Juba si Yusup bahā'?” ");
INSERT INTO sml_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Takilā magtūy e' si Yakub. “Aho',” yukna. “Ma si Yusup ko' ilu! Kilāku aniya' sattuwa talun bay angā' iya anagpe' baranna. Arōy! Anakku si Yusup!” ");
INSERT INTO sml_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Magtūy gineret e' si Yakub badju' ma baranna bo' yampa magbinadju' karut, tanda' ma pagkarukka'anna. Jari at'ggol to'ongan pagdukka si Yakub ma anakna. ");
INSERT INTO sml_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Pina'an ni iya saga anakna d'nda-l'lla bahasa amauli' karukka'anna, saguwā' mbal iya, subay pasangdan magdukka. Angabtang iya, yukna, “Mbal ala'an pagdukkaku ma anakku sampay aku amole' ni ahirat.” Manjari kasangdanan si Yakub magdukka ma anakna si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Pasalta', si Yusup bay binowa ni lahat Misil e' saga magdaragang. Ma Misil pa'in, pinab'llihan iya ni dakayu' kapitan pangandolan Pira'un, ōnna si Putipar. Pagnakura'an iya ma saga jaga ma deyom astana' Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na, ma waktu ina'an pabutas na si Yahud min saga danakanna bo' pehē' ni da'ira Adullam pat'nna' ma luma' si Hira. ");
INSERT INTO sml_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mahē' pa'in si Yahud, makapagkilā iya maka budjang, anak si Suwa bangsa Kana'an. Jari tahinangna h'nda. ");
INSERT INTO sml_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Anganak iya l'lla ati si Ēr ya pangōn si Yahud ma iya. ");
INSERT INTO sml_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Angiram h'ndana pabīng bo' anganak isab l'lla. Onan ya pangōnna ma iya. ");
INSERT INTO sml_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma lahat Keseb pa'in, anganak gi' iya pabīng, l'lla isab. Sela ya pangōnna ma iya. ");
INSERT INTO sml_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Na palabay pa'in daka pilantahun, si Yahud bay amah'nda'an anakna siyaka, ya si Ēr, ma si Tamar. ");
INSERT INTO sml_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Sagō' lumandu'an ala'at kajarihan si Ēr ma pang'nda' PANGHŪꞋ-Yawe, angkan iya magtūy minomos. ");
INSERT INTO sml_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Manjari ah'lling si Yahud ma si Onan ya anakna pasunu'. “Otō',” yukna, “ipalnu si Tamar abalu na. Subay ka magpūn maka iya supaya aniya' tubu' siyakanu. Ya na addat bang aniya' amatay ma halam aniya' anakna.” ");
INSERT INTO sml_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Sagō' kinata'uwan asal e' si Onan bang si Tamar ganta' ab'ttong e'na bo' anganak, in anak inān mbal taitung anakna. Taitung anak siyakana. Angkanna si Onan itu, sakahaba' iya magbihing maka si Tamar, mbal tino'ongan e'na supaya halam aniya' tubu' ma siyakana ya bay amatay he'. ");
INSERT INTO sml_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ala'at isab hinang si Onan inān ma pang'nda' PANGHŪꞋ angkan amatay isab iya. ");
INSERT INTO sml_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na, aniya' lling si Yahud ma ayuwanna si Tamar, yukna, “Amole' na ka ni okoman mma'nu. Da'a ka magh'lla saddī, lagarin gi' anakku si Sela. Subay na iya asangpot bo' kam magpūn.” Angkan buwattē' lling si Yahud sabab ahalli' iya ma si Sela. Kalu iya amatay buwat duwangan siyakana he'. Jari amole' na si Tamar ni matto'ana. ");
INSERT INTO sml_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","At'ggol-t'ggol pa'in, amatay isab anak si Suwa ya h'nda si Yahud. Ataptap pa'in pangatayan si Yahud itu min bay kamatay h'ndana, magbeya' iya maka bagayna si Hira a'a Adullam. Amaklay sigām karuwangan pehē' ni lahat Timna, ni lugal pagguntingan bulbul saga bili-bili si Yahud. ");
INSERT INTO sml_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Manjari aniya' makahaka ma si Tamar in mato'ana song at'kka ni Timna angangguntingan saga bili-bilina. ");
INSERT INTO sml_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Na pagta'u si Tamar, magtūy iya analinan s'mmekna balu. Tinambunan isab baihu'na maka sulban bo' mbal takilā, ati aningkō' iya ma tongod pagsosōran ni deyom kauman Inaim, ya ma bihing kalsara tudju ni Timna. Kinata'uwan asal e' si Tamar in si Sela asangpot na, sagō' halam gi' tapamah'lla ma iya. ");
INSERT INTO sml_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Na, ta'nda' e' si Yahud si Tamar e' sagō' halam takilāna. Pangannalna d'nda pinagtatambahan sabab magtambun baihu'na. ");
INSERT INTO sml_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Manjari itu, pagka halam kinata'uwan e' si Yahud in d'nda inān ayuwanna, pina'an si Yahud ni tongodna ma bihing lān. Yukna ma iya, “Bilahi ka ameya' ma aku?” Yuk si Tamar, “Ai panambanu aku?” ");
INSERT INTO sml_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ya sambung si Yahud, “Pabeya'anta ka dakayu' anak kambing min ba'anan kambingku.” “Na,” yuk si Tamar, “makajari. Sagō' subay aniya' sanda' pang'bbanu ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Atilaw si Yahud, “Ai pang'bbaku?” Yuk d'nda, “Ā, engkot k'llongnu ilu maka tungkudnu.” Na sinōngan magtūy e' si Yahud ati magbihing na sigā maka angiram iya. ");
INSERT INTO sml_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Puwas e' amole' na si Tamar bo' yampa nila'anan sulban bay panambun baihu'na ati magsin'mmek iya balu pabīng. ");
INSERT INTO sml_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Na, si Yahud itu bay amabeya' kambing ma bagayna si Hira. Sinō' e'na angā' ai-ai bay pang'bbana ma d'nda he', sagō' halam tabāk e'na. ");
INSERT INTO sml_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Aniya' isab saga a'a Inaim bay tinilaw e' si Hira bang maingga d'nda pinagtatambahan ya bay ma bihing lān. Ya sambung saga l'lla he', “Tuwan, bay min katagna' lagi' halam aniya' d'nda pinagtambahan maitu.” ");
INSERT INTO sml_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Pabalik si Hira pehē' ni si Yahud angahaka'an iya. Yukna, “Tuwan, halam tabākku. Yuk isab saga l'lla maina'an halam kono' aniya' d'nda pinagtambahan maina'an min katagna'.” ");
INSERT INTO sml_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“Na,” yuk si Yahud, “ya niyatku subay anambahan iya dakayu' anak kambing, sagō' halam ya tabāknu. Ma iya na ai-ai bay pang'bbaku. Pasagarin na bo' kita mbal pagtunggīngan e' a'a.” ");
INSERT INTO sml_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Sakali itu, palabay pa'in saga t'llumbulan, aniya' a'a makahaka ma si Yahud, yukna, “Ayuwannu si Tamar ala'at kajarihanna magusaha'an baranna, maka ab'ttong na iya.” Magpanoho'an si Yahud, yukna, “Bowahunbi iya paluwas min kauman itu. Tunu'unbi bo' amatay.” ");
INSERT INTO sml_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hinabu si Tamar binowa paluwas bahasa tinunu', bay iya amabeya' lapal ni mato'ana. Yuk lapalna, “Ab'ttong aku e' a'a ya tag-dapu engkot k'llong maka tungkud itu. Nda'un pahāp, kalu takilānu.” ");
INSERT INTO sml_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Takilā magtūy e' si Yahud. Yukna, “Abontol iya labi-labi min aku. Tinaikutan e'ku addattam pagka halam bay pamah'llaku ma iya anakku si Sela.” Jari puwas minnē' halam iya bay makasekot pabalik ni ayuwanna si Tamar e'. ");
INSERT INTO sml_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Na, ta'abut pa'in bulan panganak si Tamar, k'mbal l'lla ya nianakan e'na. ");
INSERT INTO sml_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ang'ddon pa'in iya, amaluwas tanganna k'mbal dakayu'. Magtūy niengkotan e' panday maka salban keyat. “Ya itu,” yukna, “k'mbal siyaka.” ");
INSERT INTO sml_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sagō' sinuhutan tanganna. Jari ya k'mbal pasunu' paluwas dahū. Yuk panday isab, “Mamarahi pahāp ka'a ilu pa'agaw paluwas dahū!” Jari si Peres ya pangōn onde'-onde' dahū paluwas e'. ");
INSERT INTO sml_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Puwas e', paluwas na k'mbal ya taga-salban keyat ma tanganna, l'lla du isab, ati niōnan iya si Sera. ");
INSERT INTO sml_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Na, in si Yusup bay na tabowa ni lahat Misil e' saga a'a bangsa Isma'il. Pinab'llihan iya e' sigām ni si Putipar, ya pagnakura'an saga jaga ma deyom astana' Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Manjari itu, ahāp sadja kat'kkahan ai-ai nihinang e' si Yusup hinabuna pat'nna' ma luma' nakura'na si Putipar a'a Misil. Tu'ud iya tinabang na pa'in e' si Yawe. ");
INSERT INTO sml_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ta'nda' isab e' si Putipar in si Yusup tinabang asal e' si Yawe, maka ahāp kasōngan hinangna kamemon. ");
INSERT INTO sml_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Manjari kasulutan si Putipar ma si Yusup ati tahinang iya pangandolanna. Binuwanan iya kapatut magnakura' ma a'ana kamemon sampay ma pangalta'na kamemon. ");
INSERT INTO sml_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Na, tinagna'an min waktu ina'an-i, si Putipar a'a Misil bay nilidjiki'an e' PANGHŪꞋ ma sabab si Yusup. Paheka na pa'in palsuku'anna, ai-na ka ma deyom luma', ai-na ka ma humana maka ma kabbunna. ");
INSERT INTO sml_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Angandol to'ongan si Putipar ma si Yusup, angkan pangandolna ma iya pangalta'na kamemon. Halam aniya' pagsusahan si Putipar, luwal pagkakanna. Na, si Yusup itu dakayu' l'lla ahāp luwana maka pamarananna. ");
INSERT INTO sml_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sakali itu, mbal isab at'ggol, kinabilahian iya e' h'nda si Putipar. Yukna ma si Yusup, “Pi'itu ka ni deyom bilik, maghulid kita.” ");
INSERT INTO sml_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Sagō' mbal si Yusup. Ya llingna ma d'nda he', “Oy, aku itu pangandolan e' nakura'ku, ya na h'llanu. Mbal pamagayna ai-ai pangalta'na ma deyom luma' itu pagka pangandolna ma aku. ");
INSERT INTO sml_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bang binista, in kapatutku daheya du maka kapatutna ma deyom luma' itu. Pagdūl-baya'anku kamemon, luwal du ka'a sabab h'ndana ka. Angkan aku mbal makahinang la'at ya yuknu ilu, sabab dusa ko' ilu ni Tuhan!” ");
INSERT INTO sml_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na minsan buwattē' lling si Yusup, masi-masi du iya nilogos e' h'nda si Putipar, saguwā' mbal to'ongan iya ameya' maghulid maka iya. Mbal minsan pasekot ni tongodna. ");
INSERT INTO sml_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Sakali aniya' dakayu' llaw, makasōd pa'in si Yusup ni deyom luma' maghinang ai-ai kabiyaksahanna, halam aniya' sosoho'an saddī ma deyom luma'. ");
INSERT INTO sml_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Pagsōdna, magtūy iya tahella' ma tōng badju'na e' h'nda si Putipar. Yukna ma iya, “Dai' na ka. Maghulid kita.” Daipara makakawas si Yusup min balutanna maka e'na alahi paluwas. Ka'bbahan badju'na ma tangan d'nda. ");
INSERT INTO sml_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Na, pag'nda' h'nda si Putipar ma si Yusup paragan paluwas, maka badju' bay ka'bbahan e'na, ");
INSERT INTO sml_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","magtūy lingananna saga sosoho'anna. “Nda'unbi,” yukna, “a'a Hibrani bay pinapi'itu e' h'llaku angahina' kitam. Bay iya anōd bilikku, arak aku niusiba'an e'na, manda' aku angolang saru'un-du'un. ");
INSERT INTO sml_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Na, pagolangku itu,” yukna, “alahi iya paluwas magdai'-dai'. O'o, badju'na bay bbahanna ma bilikku.” ");
INSERT INTO sml_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Manjari d'nda inān bay ang'nna' badju' si Yusup ma bihingna sampay at'kka h'llana. ");
INSERT INTO sml_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Na, at'kka pa'in si Putipar magtūy iya sinuli-sulihan e' h'ndana. Yukna, “O, ya atanu Hibrani bay bowanu pi'itu, bay makasōd ni deyom bilikku insini' amuwanan aku kaiya'an. ");
INSERT INTO sml_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Daipara angolang aku saru'un-du'un. Pagolangku, magtūy iya alahi magdai'-dai' paluwas. Sagō' ta'bba badju'na ma bihingku.” ");
INSERT INTO sml_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Na, pagkale pa'in si Putipar ma sumbungan h'ndana pasal bay tahinang kono' e' atana he', magtūy akagit sidda atayna, ");
INSERT INTO sml_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ati soho'na si Yusup sinaggaw bo' pinakalabusu ma deyom luma' pagkumbisan saga pilisu bay makalanggal sara' Pira'un. Kasangdanan si Yusup ma deyom kalabusu, ");
INSERT INTO sml_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","malaingkan halam bay pinasagaran e' PANGHŪꞋ. Taptap iya pinat'kkahan lasa maka ase', ya angkan iya makasulut atay nakura' kalabusu inān. ");
INSERT INTO sml_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Si Yusup kabuwanan e'na kapatut magbaya' ma saga pilisu kasehe'an, maka pangandolna isab ma iya kahinangan ai-ai maina'an ma kalabusu. ");
INSERT INTO sml_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Manjari itu, pagka si Yusup ya a'a pangandolan ma deyom kalabusu, halam aniya' pagsusahan nakura' inān sabab aheya tabang PANGHŪꞋ ma si Yusup. Ai-ai hinangna ahāp sadja kasōnganna. ");
INSERT INTO sml_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Na at'ggol-t'ggol pa'in, aniya' duwa sosoho'an Pira'un makarusa ma iya. Dakayu' itu bay pagnakura'an saga a'a magbubuhat inumanna, maka dakayu' ya pagnakura'an saga a'a maghinang tinapayna. Angastol Pira'un ma sigām karuwangan itu, ");
INSERT INTO sml_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ati pinakalabusu sigām ma deyom luma' kapitan saga jaga, hatina luma' pangumbisan si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Maina'an pa'in sigām, aniya' hinang pamat'nna' kapitan jaga ma si Yusup. Sinō' iya anabangan a'a duwangan-i ma ai-ai kagunahan sigām. Na, at'ggol-t'ggol pa'in sigām ma deyom kalabusu, ma dasangom du, ");
INSERT INTO sml_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","aniya' tauppi e' duwangan pilisu itu, ya bay pagnakura'an ma deyom astana' Pira'un. Magsaddī uppi sigām dangan maka dangan, maka saddī isab ma'anana. ");
INSERT INTO sml_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","7","Pagsubu, pasekot si Yusup ni duwangan sosoho'an Pira'un ya sehe'na ma deyom kalabusu itu. Ta'nda'na magtūy aniya' pagsusahan sigām angkan tilawna. “Asusa pahāp pamaihu'anbi ilu. Angay bahā'?” ");
INSERT INTO sml_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ya sambung sigām karuwangan, “Aniya' uppi kami dibuhi', sagō' halam aniya' maitu ata'u angama'anahan iya.” “Ā,” yuk si Yusup, “dakayu'-kayu' du Tuhan makabuwan pangita'u magma'ana. Haka'in aku kono' ya bay tauppibi ilu.” ");
INSERT INTO sml_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Manjari ah'lling a'a dangan ya pagnakura'an saga a'a magbubuhat inuman Pira'un, yukna, “Ya ta'nda'ku ma deyom uppiku dampo'on bahan anggul ");
INSERT INTO sml_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","t'llu sangana. Paguplutna, magtūy anumping. Pagsumping itu, magtūy patahak buwa'na. ");
INSERT INTO sml_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na, ina'an asal sawan pagi'inuman Pira'un ma tanganku, jari k'ttu'ku buwa' anggul e' bo' yampa p'gga'ku ni deyom sawan. Puwas e', bay sōnganku bohe'na pehē' ni Pira'un. Na, halam na.” ");
INSERT INTO sml_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yuk si Yusup, “Ya na itu ma'ana uppinu ilu. Ya t'llu sanga ilu, hatina t'llung'llaw. ");
INSERT INTO sml_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","T'llung'llaw gi' minnitu in ka'a pinaluwas du e' Pira'un min deyom kalabusu. Pinabīng du ka ni bay hinangnu dahū magbubuhat inumanna. ");
INSERT INTO sml_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sagō' aniya' pangamu'ku ma ka'a,” yuk si Yusup. “Bang ka ma deyom kasannangan na, ndū', entomun pa'in aku sangkahāpan. Sabbutun kahālanku ma munda'an Pira'un supaya aku makaluwas min deyom kalabusu itu. ");
INSERT INTO sml_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Sabab ya b'nnalna, in aku itu bay tasaggaw min lahatku porol, ya lahat bangsa kami Hibrani. Damikiyanna isab maitu ma lahat Misil, takalabusu aku ma halam aniya' sababna.” ");
INSERT INTO sml_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na, takale pa'in kahāp ma'ana itu e' nakura' dakayu' ya maghihinang tinapay Pira'un, magtūy iya amaluwas uppina ma si Yusup. Yukna, “Ya du aku taga-uppi dibuhi'. Ma deyom uppiku in aku baranku bay angandurung t'llu ligu magbangkat-bangkat. ");
INSERT INTO sml_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Aniya' ginisan tinapay maka bāng-bāng ma ligu diyata', arak pangalabot Pira'un, sagō' pinagtittuk e' saga manuk-manuk. Na, ya du ilu uppiku.” ");
INSERT INTO sml_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Manjari ah'lling si Yusup ma nakura' maghihinang tinapay, “Ya ma'ana uppinu ilu,” yukna “buwattitu. Ya t'llu ligu sapantun t'llung'llaw. ");
INSERT INTO sml_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Jari t'llung'llaw minnitu in ka'a-i pinaluwas du e' Pira'un min deyom kalabusu bo' yampa paponggolanna kōknu. Pagpuwas, pinasagnat bangkaynu ma diyata' hāg bo' pinagtittuk isina e' saga manuk-manuk.” ");
INSERT INTO sml_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Na, t'llung'llaw pa'in damuli minnē', ta'abut na llaw pagmahaltabat kapaganak ma Pira'un. Pinagjamuhan e'na kamemon saga tendogna ya pagnakura'an, maka soho'na pinaluwas min kalabusu ya nakura' magbubuhat inumanna inān sampay nakura' maghihinang tinapayna. Pinatampal sigā ni matahan ba'anan nakura' inān. ");
INSERT INTO sml_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ya nakura' magbubuhat inuman pinabalik e' Pira'un ni bay hinangna. ");
INSERT INTO sml_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Saguwā' in nakura' maghihinang tinapay inān sinō' pinasagnat bangkayna ni hāg. Jari taluwa' bay pagma'ana si Yusup ma pasal panguppi duwangan itu. ");
INSERT INTO sml_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Malaingkan halam taentom e' nakura' magbubuhat inuman ya bay tambuku si Yusup ma iya. Takalipatna na. ");
INSERT INTO sml_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na, aniya' saga duwantahun palabay, anguppi isab Pira'un. Ma deyom uppina, ina'an iya an'ngge-n'ngge ma bihing sapa' Nīl. ");
INSERT INTO sml_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Jari aniya' pitu' sapi' al'mmok maka alanu' patukad min deyom sapa' e' bo' amangan ma kaparangan. ");
INSERT INTO sml_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pagpuwas, aniya' pitu' sapi' saddī patukad min sapa', angagkag lullun maka ahigtal. Jari pasekot saga sapi' damuli itu ni sapi' al'mmok ya ma bihing sapa' e'. ");
INSERT INTO sml_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ahā, saga sapi' al'mmok kinakan magtūy e' saga sapi' angagkag. Na, makabati' na Pira'un min uppina. ");
INSERT INTO sml_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pagtulina pabīng, anguppi na isab iya. Ya tauppina pitumbatang pai ahāp isina maka asambu, patomo' asal min dampo'on. ");
INSERT INTO sml_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mbal at'ggol, aniya' isab pitumbatang pai saddī patomo' min po'onna. Ak'ppes isi paina maka alūs e' baliyu apasu'. ");
INSERT INTO sml_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Manjari tin'llon magtūy e' pai ak'ppes in pai asambu inān. Na, pagbati' pa'in Pira'un e', tasayuna in iya bay anguppi. ");
INSERT INTO sml_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pagsubu, aheya kasusahanna angkan palingananna saga a'a ilmu'an maka kamemon a'a bal-akkal ma kaluha'an lahat Misil. Maina'an pa'in sigām ma Pira'un, nihaka'an sigām e'na pasal uppina, malaingkan halam aniya' min sigām makapahati iya bang ai ma'anana. ");
INSERT INTO sml_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Manjari aniya' lling nakura' magbubuhat inuman ma Pira'un. Yukna, “Tuwan Pira'un, yamboho' taentomku ma llaw itu, aniya' kasā'an bay tahinangku. ");
INSERT INTO sml_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ma waktu kakagit ataynu ma aku maka ma nakura' maghihinang tinapay, bay kami pakalabusunu ma luma' kapitan saga jaga. ");
INSERT INTO sml_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Manjari dakayu' sangom makauppi kami karuwangan, bo' saddī ma'anana. ");
INSERT INTO sml_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na, aniya' a'a Hibrani bay sehe' kami ma deyom kalabusu, subul lagi', sosoho'an kapitan jaga. Bay iya haka'an kami pasal bay tauppi kami. Pagkalena, magtūy mina'anahan e'na pakaniya-pakaniya. ");
INSERT INTO sml_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ya kaluwasanna, tatuman ai-ai kamemon bay pagma'anana ma kami. Aku itu bay pinabīng ni bay hinangku. Ya a'a maghihinang tinapaynu bay soho'nu pinapatay.” ");
INSERT INTO sml_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Angkan na pinalinganan magtūy si Yusup e' Pira'un ati pinaluwas iya magdai'-dai' min deyom kalabusu. Aubus pa'in e'na amagongan p'ngngotna sampay analinan badju'na, paharap iya pehē' ni Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Yuk Pira'un ma si Yusup, “Makauppi aku sagō' halam aniya' minsan dakayu' makapahati aku ma pasalna. Na kahaka'an aku pasal ka'a. Bang aniya' uppi a'a takalenu, ata'u ka kono' angama'anahan iya.” ");
INSERT INTO sml_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ya sambung si Yusup ma Pira'un, “Tuwan sultan, ngga'i ka min pangita'uku. Tuhan dakayu'-kayu' ya makabuwanan ka'a ma'ana ahāp.” ");
INSERT INTO sml_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ya lling Pira'un ma si Yusup, “Ma deyom uppiku, ina'an aku an'ngge-n'ngge ma bihing sapa' Nīl. ");
INSERT INTO sml_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Manjari aniya' ta'nda'ku pitu' sapi' al'mmok maka alanu' patukad min deyom sapa' amangan ma kaparangan. ");
INSERT INTO sml_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Puwas e', aniya' patukad pitu' sapi' saddī, angagkag maka ahigtal. Yamboho' aku maka'nda' sapi' buwattē' la'atna minsan ma'ingga-ma'ingga ma lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sakali itu, in sapi' al'mmok inān kinakan magtūy e' saga sapi' angagkag. ");
INSERT INTO sml_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Malaingkan halam apinda baran saga sapi' bay amangan. Bā'nu halam bay makakakan ai-ai sabab masi angagkag. Na halam na, makabati' magtūy aku. ");
INSERT INTO sml_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Pagtuliku pabīng, anguppi na isab aku. Ya ta'nda'ku ma deyom uppiku damuli itu, pitumbatang pai patomo' min dampo'on. Ahāp isi paina, asambu lullun. ");
INSERT INTO sml_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Puwas e', aniya' patomo' pitumbatang pai saddī, min dampo'on du isab. Ak'ppes isi paina maka alūs e' baliyu apasu'. ");
INSERT INTO sml_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Oy na, ya pai asambu inān tat'llon magtūy e' pai ak'ppes. Na, iya na he' tauppiku. Manjari haka'anku saga a'a ilmu'an pasal bay tauppiku he', sagō' halam aniya' minsan dakayu' min sigām makapahatian aku bang ai ma'anana.” ");
INSERT INTO sml_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yuk si Yusup ma Pira'un, “Tuwan Pira'un, ya duwa uppinu ilu dama'ana du. Tu'ud ka pinata'u e' Tuhan bang ai hinangna ma sinosōng. ");
INSERT INTO sml_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ya pitu' sapi' al'mmok ilu, maka pitumbatang pai asambu, sapantun pituntahun ahāp to'ongan anihanna. ");
INSERT INTO sml_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Buwattē' isab pitu' sapi' angagkag ya patukad ma karamulihan, maka pitumbatang pai ya alūs e' baliyu, sapantun pituntahun gotom. ");
INSERT INTO sml_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Buwat bay pangahakaku ma ka'a, Tuwan Pira'un, in ka'a pinata'u na e' Tuhan bang ai nihinang e'na ma sinosōng. ");
INSERT INTO sml_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hatina, ma deyom pituntahun ya song pat'kka itu, ajatu to'ongan saga tinanom ma katilibut lahat Misil, magdayas-dayas ma kinakan. ");
INSERT INTO sml_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pasunu' isab pina'an pituntahun gotom, jari in lahat Misil itu magkasigpitan, ati takalipat e' saga a'a kamemon bay timpu pagdayas-dayas e'. ");
INSERT INTO sml_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Alungay timpu kahāpan min pangentom manusiya' ma sabab kabisa paggotom ya makasunu'. ");
INSERT INTO sml_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tuwan, ya angkan ka pinauppihan min duwa e' Tuhan, sabab ahogot niyatna. In pakaradja'an bay tauppinu ilu marai' na pinat'kka e'na. ");
INSERT INTO sml_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Da'a busung, Tuwan Pira'un, bang bahā' aku angahūgan ka'a gara'? Subay ka amiha dakayu' a'a bal-akkal, a'a alalom pangita'una, pinapagnakura' e'nu ma katilingkal lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Subay ka amat'nna' saga mandul isab maka subay aniya' kapatut sigām angā' bahagi' lima min ai-ai pinagani ma deyom pituntahun ya aheka anihanna. ");
INSERT INTO sml_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Subay aniya' isab kapatut sigām deyo' min Pira'un amatipun kamemon anihan inān sat'ggol ahāp tahunanna, maka subay tinau' pahogot ma deyom saga da'ira. ");
INSERT INTO sml_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ya kinakan tatipun itu subay tinagama pagbalanja' manusiya' ma timpu gotom ya song pat'kka ni lahat Misil. Manjari mbal sigām patay otas.” ");
INSERT INTO sml_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na, kasulutan Pira'un maka kamemon saga tendogna ma bay panganggara' si Yusup e'. ");
INSERT INTO sml_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Angkan yuk Pira'un ma sigām, “Mbal na kitam makapiha a'a saddī makasali' ni si Yusup itu. In iya dakayu' a'a katulunan pikilan alalom e' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Angabtang Pira'un ma si Yusup, yukna, “Pagka ka'a ya bay kabuwanan pangita'u maka pikilan alalom e' Tuhan, mattan halam aniya' angatu ma ka'a ma akkal maka pamikil.” ");
INSERT INTO sml_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ah'lling gi' Pira'un ma si Yusup, yukna, “Itiya' aku angangg'llal ka'a pagmakōkan ma pagsultananku itu. Ai-ai panoho'annu subay bineya' sadja e' saga a'aku kamemon. Luwal kawasaku ya aheya min kawasanu, sabab Pira'un aku. ");
INSERT INTO sml_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Buwattina'an g'llalta na ka gubnul ma sakalingkal lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Manjari niurusan e' Pira'un singsingna taga-gindan pagsultanna, ati pasulugna ma tangan si Yusup. Pinasulugan iya juba ahalga' kakana'na isab, maka engkot k'llong bulawan. ");
INSERT INTO sml_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Puwas e' binuwanan iya dakayu' kalesa, ya pamasuku' a'a bangsahan ya pasunu' ma Pira'un. Aniya' isab jaga sinō' parahū min kalesana amasimay saga a'a bo' aluhaya palabayanna. Manjari si Yusup ya pinapaggubnul ma kaluha'an lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ah'lling Pira'un ma si Yusup, yukna, “B'nnal, aku ya sultan maitu ma Misil, sagō' halam aniya' a'a ma katilibut lahat Misil itu makatawakkal maghinang ai-ai bang ngga'i ka min panoho'annu.” ");
INSERT INTO sml_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Jari aniya' ōn saddī pamuwan Pira'un ma si Yusup ma bahasa Misil. Niōnan iya Sapenat-Paneya. Pinah'nda'an isab iya e' Pira'un ma si Asenat anak si Potepera, dakayu' imam ma da'ira Ūn. T'llumpū' tahun ya umul si Yusup ma waktu katagna'na maghinang ma deyoman Pira'un ya magsultan ma lahat Misil. Makaluwas pa'in iya min deyom astana', nilibut e'na kaluha'an lahat. ");
INSERT INTO sml_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Manjari itu ma deyom pituntahun ahāp, aheka to'ongan buwa' tinanom ya niani ma lahat e'. ");
INSERT INTO sml_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Pinatau' e' si Yusup ma saga da'ira pakaniya-pakaniya ya ingga-ingga bay ta'ani min kahuma'an ya ma katilibut saga da'ira inān. Buwattē' na pa'in hinang si Yusup ma deyom pituntahun ya ahāp pagani. ");
INSERT INTO sml_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tinipun bo' tinipun sampay palasay min pagtau'an. Angkan pinahondong e' si Yusup saga sosoho'anna inān angitung t'pponganna. Tu'ud aheka makalandu', buwat ibarat gusung ma bihing tahik mbal taitung. ");
INSERT INTO sml_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Na, ma halam lagi' ta'abut waktu gotom, aniya' duwa anak si Yusup l'lla min h'ndana si Asenat ya anak si Potepera imam ma da'ira Ūn. ");
INSERT INTO sml_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Si Manasse ya pangōn si Yusup ma anakna siyaka inān. Ya pangabtang si Yusup, “Min Tuhan ya angkan aku kalungayan pangentom ma kakampunganku kamemon, sampay kabinasahan kamemon bay kalabayanku.” ");
INSERT INTO sml_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Manjari si Epra'im ya pangōnna ma anakna pasunu'. Angabtang isab si Yusup, yukna, “Kabuwanan aku tubu' ma lahat ya bay makabuwanan aku kabinsana'an.” ");
INSERT INTO sml_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na, ta'abut na tobtoban pituntahun ya aheka anihanna ma lahat Misil, ");
INSERT INTO sml_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ati anagna' pituntahun gotom buwat bay pangahaka si Yusup. Taluwa' gotom kalahat-lahatan inān kamemon, malaingkan aniya' kinakan ma sakalingkal lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kakulangan pa'in balanja' saga a'a Misil e', angamu' sigām ni Pira'un. Angkan na aniya' panoho'anna ma saga a'a inān kamemon, sinō' sigām pehē' ni si Yusup bo' ameya' ma ai-ai pamat'nna'na ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pasōng na pa'in gotom sampay pa'abut ni kaluha'an lahat Misil. Jari magpanoho'an si Yusup, sinō' niukab saga bodega panau'an kinakan bo' yampa pinab'llihan ma saga a'a Misil. ");
INSERT INTO sml_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Damikiyanna saga a'a ma kamemon kalahat-lahatan, kasigpitan sidda ma sabab gotom. Angkan na sigām pehē' ni lahat Misil am'lli balanja' min si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na, makata'u pa'in si Yakub mma' si Yusup aniya' balanja' tab'lli ma lahat Misil, ah'lling iya ma saga anakna l'lla. Yukna, “Angay kam hal aningkō'? ");
INSERT INTO sml_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Takaleku aniya' balanja' tab'lli mahē' ma Misil. Pehē' kam, b'llihinbi bo' kitam mbal patay otas.” ");
INSERT INTO sml_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Manjari pehē' na saga siyaka si Yusup sangpū' puhu' am'lli balanja' ni Misil. ");
INSERT INTO sml_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ya halam pinabeya' e' si Yakub anakna kasiyalihan si Benjamin, ya langgung si Yusup. Nihalli'an iya e' mma'na bo' mbal t'kkahan la'at ma l'ngnganan. ");
INSERT INTO sml_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Manjari pa'abay na saga anak si Yakub ma a'a kasehe'an pehē' ni lahat Misil am'lli balanja', sabab kaluha'an lahat Kana'an inān talapay gotom isab. ");
INSERT INTO sml_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na, pagka si Yusup ya gubnul ma lahat Misil, taga-kapatut iya magpab'lli balanja' ma sai na. Sakali itu, at'kka pa'in saga danakan si Yusup pina'an, magtūy sigām pasujud ma dahuanna. ");
INSERT INTO sml_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Magtūy sigām takilā e' si Yusup, sagō' magbau'-bau' sadja iya in sigām mbal kata'uwanna. Akasla isab llingna ma sigām, yukna, “Oy, minningga kam?” Ya sambung sigām, “Min lahat Kana'an, tuwan. Bay kami pi'itu am'lli balanja'.” ");
INSERT INTO sml_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Minsan takilā e' si Yusup saga danakanna, in iya halam takilā e' sigām. ");
INSERT INTO sml_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Jari taentom e' si Yusup bay tauppina ma masa palabay pasal saga danakanna inān, angkan yukna, “Ā, mata-mata ko' ka'am ilu bay pi'itu ang'nda'-ng'nda' lahat kami bang tongod ai ya aluhay sinōd.” ");
INSERT INTO sml_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","11","Ya sambung saga danakanna, “Arōy tuwan, kami itu ngga'i ka mata-mata. Halam aniya' maksud kami ala'at. Sosoho'annu du isab kami bay pi'itu am'lli balanja'. Magdanakan kami, a'a asaltun lullun.” ");
INSERT INTO sml_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“Ē!” yuk si Yusup. “Mbal aku am'nnal. Ya gawibi pi'itu ang'nda'-ng'nda' bang tongod ai ya aluhay sinōd ma lahat kami.” ");
INSERT INTO sml_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ya sambung sigām ma si Yusup, “Tuwan Gubnul, in kami sosoho'annu itu bay sangpū' maka duwa magdanakan. Mma' kami ina'an ma lahat Kana'an, maka ina'an ma iya danakan kami kasiyalihan. Aniya' isab danakan kami amatay na.” ");
INSERT INTO sml_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Ā,” yuk si Yusup, “B'nnal ya yukku insini', in ka'am ilu mata-mata. Ala'at maksudbi. ");
INSERT INTO sml_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Sulayanta kam bang b'nnal llingbi. Ya danakanbi kasiyalihan e' subay pinapi'itu. Bang hati' mbal, na sapahanta kam min ōn Pira'un, in ka'am mbal to'ongan makala'an minnitu. ");
INSERT INTO sml_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Dangan min ka'am subay pehē' angā' siyalibi he'. Kasehe'anbi subay tinahan maitu ma deyom kalabusu sampay tata'u bang b'nnal llingbi atawa mbal. Bang mbal, mattan du in ka'am mata-mata. Ōn Pira'un ya pagsapahanku.” ");
INSERT INTO sml_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Manjari pinakalabusu na sigām e' si Yusup t'llung'llaw t'ggolna. ");
INSERT INTO sml_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na, ta'abut pa'in llaw kat'lluna, ah'lling na si Yusup ni saga danakanna, yukna, “Aku itu magmatāw ma Tuhan. Mbal kam papatayku bang pa'in kam ameya' ma pamat'nna'ku itu. ");
INSERT INTO sml_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Bang kam b'nnal asaltun, ahāp maksudbi, subay aniya' mattanna. Dakayu' a'a min ka'am ta'bba maitu ma deyom kalabusu, bo' kasehe'anbi ilu tinugutan amole' amowa balanja' ma saga anak-h'ndabi ya agon-agon patay otas. ");
INSERT INTO sml_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pagubus, bowahunbi siyalibi pi'itu ni aku. Bang buwattē' hinangbi kamattanan aku in llingbi ma aku b'nnal to'ongan. Jari mbal na kam papatayku.” Na, kasulutan sigām magdanakan ma lling si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Magsuli-suli sigām pakaniya-pakaniya, yuk-i, “Na, tantu kitam katongoran ma bay tahinangtam ma siyalitam e'. Bay ta'nda'tam kasigpitanna waktu kapangamu'na ase' ma kitam. Sagō' halam asiptam. Ya he' sababanna angkan kitam t'kkahan sigpit buwattina'an.” ");
INSERT INTO sml_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ah'lling isab si Rubin, yukna, “Bay na sa yukku ma ka'am da'a binasahunbi onde' e', sagō' halam aku bay beya'bi. Na, itiya' kitam binalosan pasal kamatayna.” ");
INSERT INTO sml_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tahati asal e' si Yusup ai-ai pamissala sigām, saguwā' halam kinata'uwan e' sigām sabab kahaba' sigām anuli-nuli ma si Yusup aniya' magsasalin bahasa sigām ni bahasa Misil. ");
INSERT INTO sml_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Pagkale si Yusup ma pamissala sigām, tatangis iya ati pataikut min sigām. Pahondong pa'in tangisna bo' makasuwala pabīng, pabaihu' iya ni dauranakanna. Pinene' e'na si Simiyun, bo' soho'na niengkotan ma matahan sigām. ");
INSERT INTO sml_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Na, arai' pa'in amole' saga danakan si Yusup kasehe'an, magpanoho'an si Yusup ma saga tendogna, sinō' pin'nno'an balanja' saga karut sigām pakaniya-pakaniya. Sinō' isab ni'isi ni karut sigām sīn bay pamayad sigām dangan maka dangan. Pinalutu'an lagi' sigām bo' aniya' takakan-kakan sigām ma labayan. ");
INSERT INTO sml_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kaniya-kaniya sigām anganduwa' ni kura' sigām saga balanja' bay tab'lli sigām. Pagduwa' itu, palanjal na sigām amole'. ");
INSERT INTO sml_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Sangom pa'in, pahondong sigām ma pahanti'an. Sakali itu, aniya' dangan min sigām angukab karutna bahasa angā' gandum pamakan kura'na. Pagukabna, na, aniya' sīn ma bowa' karut e'. ");
INSERT INTO sml_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Agsai lingananna saga danakanna, yukna, “Oy, itiya' sīnku bay pinabīng ni karutku.” Na taluwa' sigām sukkal aheya, jari magpamidpid sigām ati magtilaw-tilawan dansehe'an, yuk-i, “Ai sa ya pamat'kka kitam itu e' Tuhan?” ");
INSERT INTO sml_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Manjari itu, at'kka pa'in sigām ni lahat Kana'an maka ni si Yakub ya mma' sigām, sinuli-sulihan iya pasal kamemon bay kalabayan sigām. ");
INSERT INTO sml_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Yuk sigām, “Mma', binissalahan kami e' Gubnul ya pagnakura'an lahat Misil, akasla sidda. Tinuna'an kami e'na angamata-mata kono' ma lahatna. ");
INSERT INTO sml_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ya sambung kami, ‘Tuwan, ngga'i ka kami saga mata-mata. A'a abontol kami, ahāp sadja maksud kami. ");
INSERT INTO sml_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sangpū' maka duwa kami magdanakan, da'mma' kamemon. Dakayu' danakan kami wa'i na amatay. Maka danakan kami kasiyalihan ina'an tabba ma mma' kami ma lahat Kana'an.’ Ya he' bay pah'lling kami ma Gubnul e'. ");
INSERT INTO sml_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ya sambungna ma kami, ‘Nda'ku na bang kam b'nnal a'a abontol. Tahanku maitu a'a dangan min deyomanbi. Jari in ka'am kasehe'an makajari amole' bo' amowa balanja' ma anak-h'ndabi ya mbal makasandal otas. ");
INSERT INTO sml_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Malaingkan,’ yuk gubnul-i, ‘ya siyalibi subay bowabi pi'itu ni aku. Minnē' kamattanan aku in ka'am ngga'i ka mata-mata bay pi'itu amiha lugal aluhay sinōd. Jari nde'anku ni ka'am danakanbi bay tahanku ati aluhaya na kam magusaha ma lahat itu.’ Na, buwattē' lling gubnul inān ma kami.” ");
INSERT INTO sml_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sakali itu, hinabu sigām angukab karut sigām pakaniya-pakaniya bo' anumpahan isina, allā! Ya putusan sīn bay pamayad sigām balanja', ina'an ma deyom karut. Pag'nda' sigām magtūy sigām sinōd tāw. Ya du si Yakub ya mma' sigām, sinōd tāw isab. ");
INSERT INTO sml_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yukna ma sigām, “Arōy, kalungayan aku anak ma sababanbi. Halam na si Yusup, halam na si Simiyun, ati kabaya'anbi subay amowa si Benjamin? Aku ya marasahi magkarukka'an.” ");
INSERT INTO sml_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Manjari yuk si Rubin ma mma'na, “Mma', pangandolun si Benjamin ma aku. Bang saupama mbal tabowaku pabalik ni ka'a, makajari papataynu anakku l'lla karuwangan ilu.” ");
INSERT INTO sml_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Saguwā' mbal tapogos si Yakub. Yukna, “Mbal makabeya' ma ka'am anakku kabungsuhan itu. Wa'i na amatay langgungna, hal iya takapin allum. Bang aniya' makamula ma iya ma l'ngnganan, paheya gom pa'in karukka'anku ati tabowa aku amole' ni ahirat, sabab ato'a na aku.” ");
INSERT INTO sml_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Na, karuhunan gotom ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ya balanja' bay tab'lli e' saga anak si Yakub ma lahat Misil aubus na kamemon. Manjari ah'lling si Yakub ma saga anakna, yukna, “Pabalik kam pehē' ni Misil am'lli balanja' minsan mbal aheka.” ");
INSERT INTO sml_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Sagō' yuk si Yahud ma iya, “Mma', bay kami sinanggupan e' gubnul ma lahat-i, yukna bang kami mbal amowa siyali kami pehē', mbal kami makajari paharap ni iya. ");
INSERT INTO sml_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bang hati pabeya'nu siyali kami itu, na, pehē' du kami am'lli balanja'. ");
INSERT INTO sml_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Sagō' bang iya mbal pabeya'nu, in kami itu mbal pehē' pagka mbal tinugutan paharap ni gubnul.” ");
INSERT INTO sml_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ya sambung si Isra'il (hatina si Yakub), “Angay kam bay makahaka'an a'a inān aniya' gi' danakanbi saddī? Kasusahan sadja ya pamat'kkabi ma aku.” ");
INSERT INTO sml_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ya sambung sigām, “Tu'ud mbal pahali a'a inān anilosa kami ma pasal kaukampungan kami. Tinilaw kami e'na pasal mma' kami bang masi allum, maka bang aniya' danakan kami saddī? Manjari, Mma', mbal kami makapagin'mbal ma panilawna. Maka halam isab bay makani-pikilan kami in siyali kami sinō' binowa pina'an ni iya.” ");
INSERT INTO sml_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Manjari si Yahud ya ah'lling, yukna, “Mma', pangandolun onde' ilu ma aku bo' kami pehē' magtūy am'lli balanja' supaya halam aniya' min kitam patay otas. ");
INSERT INTO sml_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Paglilla'ku baranku angakuhan iya min ai-ai makamula. Bang aniya' tum'kka ni iya, aku ya binīngan. Bang iya s'lle'-bale puhu' mbal tabowaku amole' pi'itu ni ka'a ma halam baya-baya, aku ya kasusunan sat'ggolku allum. ");
INSERT INTO sml_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mma', bang kami halam bay taggahannu, bay du kami magpehē'-pi'itu min duwa na.” ");
INSERT INTO sml_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yuk si Isra'il ya mma' sigām, “Na, bang buwattē', subay kam amowa kasampangan pangahulmatbi ma gubnul e'. Isihunbi ni karutbi ai-ai ya katapusan ahāp min lahatta itu, saga bulitik ahamut maka gula' buwani minsan sadja dangkuri', maka ginisan pamapā isab, maka saga kinakan ahāp nanamna buwat bigi-pistasyo maka bigi-almon. ");
INSERT INTO sml_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bowahunbi isab sīn nilipat duwa min bay pam'llibi tagna' he', kalna' in sīn bay tabākbi ma bowa' karut subay pinabalik ni sigām. Arai' aniya' bay makasā'. ");
INSERT INTO sml_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Na, bowahunbi na siyalibi bo' kam magdai'-dai' pehē' ni gubnul. ");
INSERT INTO sml_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bang pa'in iya pinat'kkahan atay ahāp e' Tuhan Sangat Kawasa supaya aniya' ase'na amabīng ni ka'am si Benjamin maka danakanbi dakayu'. Malaingkan bang aku saupama kalungayan anak, na, magsabal aku.” ");
INSERT INTO sml_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Sakali itu, palanjal na saga ka'anakan si Yakub maka e' sigām amowa kasampangan maka sīn nilipat duwa min bay dahū e'. Tabowa isab si Benjamin. Pagt'kka sigām ni Misil, pehē' sigām paharap ni si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Manjari, pag'nda' si Yusup ma si Benjamin, magtūy soho'na sosoho'an ya ang'ntan kapatut ma luma'na. Yukna, “Bowahun saga a'a itu pehē' ni luma'ku. Pasumbali'un hayop maka pa'adjalin pagkakan. Magsalu kami amangan ugtu llaw ilu.” ");
INSERT INTO sml_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Bineya' e' sosoho'an inān bay panoho'an si Yusup ma iya, ati binowa saga dauranakanna pehē' ni luma'. ");
INSERT INTO sml_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Sakali itu, sabu pa'in sigām binowa ni luma', t'kkahan sigām tāw. Ma hona'-hona' sigām, “Ya angkan kitam binowa pi'itu ma sabab sīn ya bay pinabīng ni deyom karuttam tagna' kitam bay am'lli balanja'. Marai' bahā' pataggaha' kitam nirugpak, ati sinaggaw kitam nihinang ata. Niagaw isab saga kura'tam.” ");
INSERT INTO sml_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Angkan na, pagabut sigām ni bowa' lawang, pasekot sigām ni a'a ang'ntan kapatut ma luma' si Yusup amowa iya magbissala. Yuk sigām, ");
INSERT INTO sml_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Tuwan, da'a busung, aniya' pah'lling kami ma ka'a. Bay kami makapi'itu mint'dda am'lli balanja'. ");
INSERT INTO sml_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Sagō' makahanti' pa'in kami ma l'ngnganan tudju amole', taukab kami saga karut pakaniya-pakaniya. Pagukab itu, ta'nda' kami ma bowa' karut sīn bay pamayad kami balanja', jukup to'ongan. Daka sai bay amat'nna' sīn inān ni deyom karut kami. Angkan na itiya' kami amowa sīn e' pinapole' ni ka'am. Maka aniya' itu sīn saddī pam'lli kami balanja' ma l'ngngan itu.” ");
INSERT INTO sml_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ya sambung a'a ang'ntan kapatut e', “Da'a kam asusa. Da'a kam tināw. Tuhanbi, ya pagtuhanan mma'bi, bay makaisi sīn inān ni deyom karutbi. Bay du tasambutku bayadbi.” Puwas e' pinaluwas e'na si Simiyun ni'nde'an ni sigām. ");
INSERT INTO sml_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Na, binowa na saga danakan si Yusup ni deyom luma'na e' sosoho'anna he'. Binuwanan sigām bohe' pangose' tape' sigām maka binuwanan isab pagkakan saga kura' sigām. ");
INSERT INTO sml_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Makata'u pa'in sigām binowa sigām amangan ma luma' si Yusup, sinakap ba'anan kasampangan pangahulmat sigām ma iya pagt'kkana ni luma' ugtu llaw. ");
INSERT INTO sml_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Manjari pagt'kka si Yusup ni luma', pasujud sigām ma dahuanna maka e' sigām amuwanan iya saga kasampangan bay binowa e' sigām ni deyom luma'. ");
INSERT INTO sml_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tinilaw sigām e' si Yusup pasal kahālan sigām. Yukna, “Painay na mma'bi ya bay pangahakabi ma aku ato'a na? Masi iya allum?” ");
INSERT INTO sml_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ya sambung sigām, “Aho' tuwan, ahāp masi mma' kami maka alasig.” Pasujud na isab sigām ni si Yusup pagaddat sigām ma iya. ");
INSERT INTO sml_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Na, pag'nda' si Yusup ma langgungna si Benjamin, yukna, “Ā, ya na ka itu siyalibi, ya bay panuli-nulibi ma aku? Bang pa'in ka binuwanan kahāpan e' Tuhan, Otō'.” ");
INSERT INTO sml_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Agon-agon ahansul pangatayan si Yusup pag'nda'na ma langgungna. Angkan iya parai'-dai' paluwas sabab mbal tasandal bohe' matana am'ttak. Jari pasōd iya ni deyom bilikna anangis maina'an. ");
INSERT INTO sml_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pagpuwas, akula'up iya bo' pabalik ni saga danakanna. Sinandalan e'na bohe' matana maka e'na anoho' saga a'ana amat'nna' kinakan sigām. ");
INSERT INTO sml_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Pinat'nna'an si Yusup dangan-danganna. Saga danakanna pinat'nna'an ma pamanganan saddī, sigām-sigām sadja. Saddī isab ma saga bangsa Misil ya magkakan maina'an. Mbal sigām makapagsalu maka bangsa Hibrani, sabab asammal bang ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Jari pinatingkō' saga danakan si Yusup ma anggopanna, maka pinagsunu'-sunu' isab tingkō'an sigām min siyaka ni siyali. Pag'nda' sigām ma pagpatingkō' ma sigām buwattē', magtūy sigām mag'nda' mata tabowa e' kainu-inuhan sigām. ");
INSERT INTO sml_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Manjari aniya' palauk pangalabot ma sigām bay min lamisahan si Yusup, sagō' ya pangalabot si Benjamin nilipat lima min bay pangalabot saga danakanna. Na magjamu sigām maka si Yusup, maginum sampay maglami-lami. ");
INSERT INTO sml_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Manjari aniya' panoho'an si Yusup ma a'a ang'ntan kapatut ma deyomanna, yukna, “P'nno'in balanja' karut sigām ilu kamemon, pila-pila ya takaya binowa e' sigām. Pole'in isab sīn bay pamayad sigām pakaniya-pakaniya, pat'nna'un ma diyata' balanja' ya ma deyom karut sigām. ");
INSERT INTO sml_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ngā'un isab ya sawanku dī pilak bo' pat'nna'un pehē' ni deyom karut kasiyalihan e', pabeya'un ma sīn bay pamayadna.” Na bineya' e' a'a inān bay panoho'an si Yusup ma iya. ");
INSERT INTO sml_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pagsubu-subu lagi', pinapole' na saga dauranakan e' maka saga kura' ya pagduruwa'an sigām. ");
INSERT INTO sml_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sakali itu, ma halam lagi' sigām makalawak min da'ira bay kamahē'an sigām-i, ah'lling si Yusup ma a'a tag-kapatut ma deyomanna. “Pal'kkas ka,” yukna. “Turulun saga a'a inān. Pagabutnu, tilosahun sigām. Yuknu, ‘Ē, ka'am ilu! Kabuwanan kam kahāpan ati kala'atan ya panungbasbi! ");
INSERT INTO sml_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Angay tatangkawbi sawan pilak ya suku' nakura'ku? Sawan panginumanna ko' ilu, sawan isab pagputika'anna. Langgal sara' to'ongan ya tahinangbi ilu!’ ” ");
INSERT INTO sml_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na, maka'abut pa'in sosoho'an si Yusup-i ni sigām magdanakan, magtūy isabanna kabtangan bay pah'lling si Yusup ma iya. ");
INSERT INTO sml_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ya panambung saga magdanakan ma iya, “Tuwan, angay kami pah'llingannu buwattilu? Makabusung ko' ilu bang kami makahinang buwat yuknu ilu. ");
INSERT INTO sml_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Entomun sīn ya bay tabāk kami ma bowa' karut kami. Bay tabowa kami min lahat Kana'an bo' tinūran ni ka'a. Jari pangannalnu bahā' in kami makatangkaw pilak atawa bulawan min deyom luma' nakura'nu? ");
INSERT INTO sml_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tuwan, bang sawan ilu ganta' tabāk ma sai-sai min kami, a'a inān subay papataynu, maka kami kasehe'an subay magpa'ata ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ya sambung a'a si Yusup-i, “Sulut na,” yukna, “sagō' ya sadja hinangku ata, bang ma sai kabākan sawan ilu. Malaingkan ka'am kasehe'an puwas min palkala'.” ");
INSERT INTO sml_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Magtūy sigām magdai'-dai' amareyo' duwa'an sigām bo' yampa angukab karut pakaniya-pakaniya. ");
INSERT INTO sml_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Manjari pinaglungkad to'ongan saga karut sigām magdanakan e' sosoho'an si Yusup. Tinagna'an min siyaka tudju ni siyali. Allā, tabākna in sawan pilak ma deyom karut si Benjamin. ");
INSERT INTO sml_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pagbāk itu, magtūy gineret e' saga dauranakan si Yusup saga badju' sigām ma sabab kaheya susa sigām. Taparuwa' pa'in ai-ai sigām ma saga kura', pehē' na sigām pabalik ni da'ira. ");
INSERT INTO sml_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pagt'kka si Yahud maka saga danakanna ni luma' si Yusup, ina'an iya masi. Magtūy sigām pak'ppang ni tana' ma dahuanna. ");
INSERT INTO sml_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yuk si Yusup ma sigām, “Angay kam makahinang buwattē'? A'awam kam bahā'? Bang a'a buwat aku ata'u ang'nda' putika'an, halam aniya' kalimbungan min aku.” ");
INSERT INTO sml_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ya sambung si Yahud, “Daka ai pangabtang kami ma ka'a, tuwan. Halam aniya' panganda'awahan kami in kami itu asaltun. Tapabukis na dusa kami e' Tuhan. Atanu na kami itu kamemon, ngga'i ka sadja ya a'a dangan bay kabākan sawannu.” ");
INSERT INTO sml_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ya sambung si Yusup, “Ā, mbal. Mbal aho'anku ya yuknu ilu. Ya sadja hinangku ata ya a'a bay kabākan sawanku. Ka'am kasehe'an ilu makajari na amole' pehē' ni mma'bi ma deyom kasalamatan.” ");
INSERT INTO sml_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Sakali si Yahud pasekot ni si Yusup maka e'na ah'lling, yukna, “Tuwan, da'a aku busung, aniya' pamowahanta ka magsuli-suli. Da'a isab ap'ddi' ataynu ma aku, sabab bang ma aku in ka'a sali' Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tuwan,” yuk si Yahud, “bay kami tatilawnu bang aniya' lagi' mma' kami atawa danakan kami saddī. ");
INSERT INTO sml_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ya sambung kami ma ka'a, aniya' mma' kami sagō' ato'a na. Maka aniya' gi' siyali kami l'lla bay nianakan ma kato'a si Mma'. Duwangan sigām maglanggung sagō' amatay na langgung siyaka. Manjari hal iya la'a takapin min sigām da-ina', angkan iya kinalasahan to'ongan e' si Mma'.” ");
INSERT INTO sml_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ah'lling gi' si Yahud, yukna, “Manjari, tuwan, bay soho'nu kami amowa siyali kami pi'itu ni ka'a supaya iya ta'nda'nu. ");
INSERT INTO sml_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ya sambung kami ma ka'a, ‘Onde' he' mbal makabutas min mma'na, sabab bang iya abutas, arakala' amatay si Mma'.’ ");
INSERT INTO sml_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sagō' ya llingnu in kami mbal makapagharap maka ka'a pabalik, luwal bang tabeya' pi'itu siyali kami. ");
INSERT INTO sml_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na manjari tuwan, pagbīng kami pehē' ni si Mma', magtūy iya kahaka'an pasal bay pangabtangnu ma kami. ");
INSERT INTO sml_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Na, mbal at'ggol, sinoho' na isab kami e' si Mma' pi'itu pabalik am'lli balanja' mbal aheka. ");
INSERT INTO sml_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ya sambung kami ma iya, ‘Mma', bang mbal pabeya'nu si Benjamin mbal kami makapehē', sabab mbal tinugutan paharap ni gubnul e' bang halam tabeya' danakan kami kasiyalihan.’ ");
INSERT INTO sml_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Ya sambung si Mma' ma kami, ‘Kata'uwanbi asal, duwa du anakku l'lla min h'ndaku si Rakiya. ");
INSERT INTO sml_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Dakayu' e' halam na. Marai' iya bay tasagpe' e' sattuwa talun, sabab halam iya ta'nda'ku pabīng sangay min llaw bay kala'anna.’ ");
INSERT INTO sml_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Yukna isab ma kami, ‘Bang pabutasbi si Benjamin min aku bo' aniya' kamulahan pataluwa' ma iya, na, pat'kkahanbi aku karukka'an mbal kasandalan e' a'a to'a. Ati tabowa aku amatay e' karukka'an.’ ” ");
INSERT INTO sml_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ah'lling gi' si Yahud ma si Yusup. “Bang pinagbahasa, tuwan, onde' itu ya kapangā'an lasig si Mma'. Bang aku ganta' amole' bo' ta'nda' e' si Mma' in onde' halam tabeya' ma aku, piligdu, amatay du iya magkarukka'an. ");
INSERT INTO sml_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Paligay aku itu, tuwan,” yukna, “bay angakuhan kallum onde' itu. Yukku ma si Mma', ‘Bang iya mbal tabowaku pabīng pi'itu ni ka'a, aku iya kasusunan sat'ggolku allum.’ ");
INSERT INTO sml_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ndū' tuwan,” yuk si Yahud, “bang pa'in tugutannu aku magpa'ata ma ka'a ganti' siyaliku. Paronganun iya ma saga danakanna kasehe'an amole' pehē' ni si Mma'. ");
INSERT INTO sml_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Daka painay e'ku amole' pehē' ni mma'ku bang halam ma aku onde' itu. Mbal aku makasandal ang'nda' ma pagkarukka'an si Mma'.” ");
INSERT INTO sml_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Manjari mbal na kasandalan e' si Yusup kahansul atayna angkan soho'na paluwas minna'an saga a'a Misil bay ma deyom luma'na. Na, halam pa'in aniya' a'a saddī maina'an, magpakilā na iya ma saga danakanna. ");
INSERT INTO sml_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Akosog pagtangis si Yusup, takale isab e' saga a'a Misil. Jari pinasampay habalna pehē' ni astana' Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yuk si Yusup ma saga danakanna, “Aku na ko' itu si Yusup. Masi allum si Mma'?” Na, pagkale llingna itu e' saga danakanna, magtūy sigām sinōd tāw, kapam'ngngangan. ");
INSERT INTO sml_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Na amissala si Yusup ma sigām, yukna, “Pasekot kam pi'itu.” Jari pasekot na sigām. Yuk si Yusup isab, “Aku na ko' itu si Yusup, ya danakanbi bay pab'llihanbi bo' binowa ni Misil. ");
INSERT INTO sml_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na, da'a kam asukkal. Da'a isab pagsusuninbi baranbi pasal pamab'llibi ma aku. Ya angkan aku makapi'itu, sabab Tuhan ya bay amapi'itu aku, ngga'i ka ka'am. Tu'ud aku pinarahū e'na min ka'am supaya kalappasan bangsa manusiya' min gotom. ");
INSERT INTO sml_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ma buwattina'an yampa duwantahun paggotom ma lahat, jarina aniya' gi' limantahun halam aniya' tinanom, halam aniya' buwa' niani. ");
INSERT INTO sml_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bay aku pinapi'itu e' Tuhan dahū min ka'am supaya kam kalappasan ma sabab kawasana makainu-inu, bo' aniya' du pa'in panubu'bi maitu ma dunya. ");
INSERT INTO sml_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Hatina,” yuk si Yusup, “ngga'i ka ka'am ya bay amapi'itu aku, sagō' Tuhan. Min kahandakna ya angkan aku sali' sapantun pag'mma'an Pira'un angahūgan iya gara'. Tahinang aku pagmakōkan ma deyomanna, maka gin'llal aku nakura' ang'ntanan sakalingkal lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Na, pal'kkas na kam amole' ni si Mma'. Pasampayunbi ni iya lapalku itu. ‘Min kahandak Tuhan ya angkan aku (yuk si Yusup) tahinang pagnakura'an ma sakalingkal lahat Misil. Palūd ka pi'itu saru'un-du'un, da'a ka ananggu. ");
INSERT INTO sml_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Maitu na ka pat'nna' ma lahat Gosen supaya asekot ni aku. Bowahun pi'itu saga anak-mpunu kamemon, sampay saga kahayopannu, bili-bili ka, kambing ka, sapi' ka. Bowahun isab pangalta'nu kamemon. ");
INSERT INTO sml_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Bang ka maina'an na ma Gosen aku ya angupiksa' ka'a. Aniya' gi' limantahun t'ggol gotom itu. Mbal aku bilahi bang ka'am magtai'anak atawa ba'anan hayopnu patay otas.’ ” Ya du ina'an lapal si Yusup ma mma'na si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ah'lling gi' si Yusup ma saga danakanna, yukna, “Benjamin, ta'nda'nu na aku itu langgungnu. Maka ka'am ilu kamemon ta'nda'bi na, aku na ko' itu. ");
INSERT INTO sml_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Suli-sulihinbi si Mma' pasal kawasaku maitu ma lahat Misil. Suli-sulihinbi pasal kamemon ya ta'nda'bi maitu. Jari pasa'ut kam amowa iya pi'itu.” ");
INSERT INTO sml_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Magtūy ginapus e' si Yusup siyalina si Benjamin. Ginapus isab si Yusup e' si Benjamin, jari tatangis sigām karuwangan. ");
INSERT INTO sml_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Siniyum e'na danakanna kamemon dakayu' maka dakayu', maka e'na anangisan sigām. Pagubus, magsambung-siyambungi sigām magbissala. ");
INSERT INTO sml_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na, makasampay pa'in ni astana' Pira'un habal pasal kat'kka saga danakan si Yusup, akōd to'ongan Pira'un maka saga tendogna pagnakura'an. ");
INSERT INTO sml_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Yuk Pira'un ma si Yusup, “Soho'un saga dauranakannu angamomos saga kura' sigām bo' pabalik ni lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Sō'un sigām angā' mma'bi sampay anak-h'nda sigām kamemon bo' binowa e' sigām pi'itu waktu kapabalik sigām. Buwananku sigām tana' landu' ahāp maitu ma Misil, supaya sigām maglabi-labi ma kalluman.” ");
INSERT INTO sml_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Amissala gi' Pira'un, yukna, “Soho'un sigām amowa saga karitun minnitu pameya'an saga anak-h'nda sigām pi'itu, ya lagi'na mma'bi. ");
INSERT INTO sml_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Da'a na kinabimbangan palsuku'an sigām ta'bba ma lahat, sabab ma sigām na ai-ai ya ahāp to'ongan maitu ma Misil.” ");
INSERT INTO sml_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Manjari bineya' panoho'an Pira'un inān e' saga anak si Yakub. Binuwanan sigām saga karitun e' si Yusup ma buwat bay pah'lling Pira'un ma iya. Binuwanan sigām balanja' isab palutu' sigām ma l'ngnganan. ");
INSERT INTO sml_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Aniya' isab dapangampu'an s'mmek ahalga' pamuwan sigām pakaniya-pakaniya. Malaingkan ya pamuwan si Yusup ma si Benjamin, lima pangampu'an s'mmek pagsalinanna maka t'llu hatus pilak. ");
INSERT INTO sml_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Mma'na ya pinabowahan e' si Yusup sangpū' kura' l'lla ap'nno' e' ai-ai ahāp hinangan Misil, maka sangpū' kura' d'nda ap'nno' e' balanja' maka saga tinapay maka ginisan takakan-kakan pamalutu' iya ma l'ngngananna tudju ni Misil. ");
INSERT INTO sml_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Manjari itu, pinalanjal na saga danakanna e' si Yusup. Yukna ma sigām, “Ebot-ebot, da'a kam magkalukassa ma pal'ngngananbi.” ");
INSERT INTO sml_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Na, ala'an na sigām min Misil bo' pabalik pehē' ni lahat Kana'an. Pagt'kka sigām, magtūy sigām angahaka ma mma' sigām, yuk-i, ");
INSERT INTO sml_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Mma', masi allum si Yusup! Pagnakura'an iya buwattina'an ma sakalingkal lahat Misil.” Magtūy tak'bbal atay si Yakub, sali' alungay pangannalna, mbal agon makapam'nnal ma bay pangahaka ma iya e' saga anakna. ");
INSERT INTO sml_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Malaingkan pagkalena kamemon bay panambuku si Yusup ma sigām, maka pag'nda'na isab saga karitun bay pinabeya'an iya e' si Yusup pameya'anna tudju ni Misil, magtūy pabalik pangannalna. ");
INSERT INTO sml_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yuk si Yakub, “Kamattanan na aku. Allum du anakku si Yusup. Halam aniya' angutku saddī, bang pa'in aku makapehē' ang'nda' iya dahū sat'ggolku masi allum.” ");
INSERT INTO sml_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Na, palintas na disi Isra'il (hatina si Yakub) min lahat Kana'an maka e' sigām amowa ai-ai sigām kamemon. Tat'kka pa'in e' sigām lahat Be'erseba, anumbali' iya hayop pagkulbanna tudju ni Tuhan ya pagtuhanan mma'na si Isa'ak. ");
INSERT INTO sml_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Jari itu, sangom pa'in, takale e' si Isra'il itu suwala Tuhan angalinganan iya. “Yakub, O Yakub,” yukna. Ya sambung si Yakub, “Oy, itiya' aku.” ");
INSERT INTO sml_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ya lling suwala-i, “Aku itu Tuhan ya pagtuhanan mma'nu. Da'a ka tināw palain ni lahat Misil, sabab mahē' aku angahinang saga panubu'nu bangsa akosog. ");
INSERT INTO sml_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Pataptap du aku ma ka'a, maka bowaku isab panubu'nu pabalik pi'itu ni lahat itu ma sinosōng. Bang ta'abut na waktunu awapat, ina'an du si Yusup ma bihingnu.” ");
INSERT INTO sml_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Manjari palanjal na disi Yakub min Be'erseba tudju ni lahat Misil. Si Yakub ya pinariyata' e' saga anakna ni karitun bay min Pira'un pameya'an sigām. Ya du pinariyata' isab saga anak-h'nda sigām. ");
INSERT INTO sml_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bay binowa e' sigām ba'anan kahayopan sigām maka palsuku'an bay tausaha sigām maina'an ma lahat Kana'an bo' na palūd ni lahat Misil. Binowa e' si Yakub saga tubu'na kamemon. ");
INSERT INTO sml_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Tabeya' ma iya kamemon saga anak-mpuna l'lla maka d'nda. ");
INSERT INTO sml_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ya na itu salsila ma kapanubu'an si Isra'il (hatina si Yakub) bay tabeya' ma iya waktu kapaglainna ni Misil: Si Rubin ya kasiyakahan. ");
INSERT INTO sml_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Anak si Rubin l'lla, ya na disi Hanok, si Pallu, si Hesdon maka si Karmi. ");
INSERT INTO sml_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Pasunu' si Simiyun maka saga anakna l'lla, ya na disi Jamuwal, si Jamin, si Hūd, si Yakin, si Sohar maka si Sa'ul. Si Sa'ul itu anakna min d'nda bangsa Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Pasunu' isab si Libi maka saga anakna l'lla, ya disi Gerson, si Kohat maka si Merari. ");
INSERT INTO sml_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Pasunu' si Yahud maka saga anakna l'lla, ya disi Sela, si Peres maka si Sera. Aniya' isab duwa anak si Yahud l'lla bay amatay ma lahat Kana'an lagi', ya na si Ēr maka si Onan. Aniya' isab saga anak si Peres l'lla, ya na si Hesdon maka si Hamul. ");
INSERT INTO sml_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Pasunu' isab si Issakar maka saga anakna l'lla, disi Tola, si Puwa, si Jasub, maka si Semlon. ");
INSERT INTO sml_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Kasiyalihan si Sibulun. Ya itu ōn anakna l'lla, disi Sered, si Elon maka si Jahale'el. ");
INSERT INTO sml_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jari ya na ina'an saga anak si Yakub min h'ndana po'on si Leya, ya bay nianakan mahē' ma lahat Mesopotami. Aniya' isab anakna d'nda si Dina. Jari t'llumpū' maka t'llu ya heka panubu' si Yakub min h'ndana po'on si Leya. ");
INSERT INTO sml_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ya anak si Yakub siyaka min h'nda-h'ndana si Silpa, ya na si Gād. Ya itu ōn anakna l'lla, disi Sepon, si Haggi, si Suni, si Esbon, si Iri, si Arod maka si Arili. ");
INSERT INTO sml_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Pasunu' si Aser maka anakna l'lla, ya disi Imna, si Isba, si Isbi, si Biriya, maka dakayu' d'nda isab si Sera. Aniya' isab anak si Biriya l'lla duwa hekana, si Heber maka si Malki'il. ");
INSERT INTO sml_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Jari sangpū' maka nnom ya heka panubu' si Yakub min si Silpa, ya d'nda ipatan bay pamuwan e' si Leban ma si Leya waktu kapagpūnna maka si Yakub. ");
INSERT INTO sml_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Saga anak si Yakub l'lla isab min h'ndana si Rakiya, ya na si Yusup maka si Benjamin. ");
INSERT INTO sml_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Si Manasse isab maka si Epra'im, ya anak si Yusup l'lla bay nianakan ma lahat Misil e' si Asenat anak si Potipero imam ma da'ira Ūn. ");
INSERT INTO sml_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Na, si Benjamin du isab maka saga anakna l'lla, ya na disi Bela, si Beker, si Asbel, si Gera, si Na'aman, si Ihi, si Rōs, si Muppim, si Huppim maka si Harid. ");
INSERT INTO sml_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ya du ina'an saga tubu' si Yakub min h'ndana si Rakiya, sangpū' maka mpat puhu'. ");
INSERT INTO sml_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ya anak si Yakub siyaka min h'nda-h'ndana si Bilha, ya na si Dān. Ya anak si Dān l'lla si Husim. ");
INSERT INTO sml_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Pasunu' si Naptali, maka anakna l'lla, disi Jasil, si Guni, si Jeser maka si Sillim. ");
INSERT INTO sml_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ya du ina'an saga tubu' si Yakub pitu' puhu' hekana min si Bilha, ya d'nda ipatan bay pamuwan ma si Rakiya e' mma'na si Leban. ");
INSERT INTO sml_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Manjari nnompū' maka nnom ya heka panubu' si Yakub lissi bay tabeya' ma iya pehē' ni Misil, halam talapay ni'itung saga ayuwanna d'nda. ");
INSERT INTO sml_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pak'nnop isab duwangan anak si Yusup ya bay nianakan ma Misil. Manjari pitumpū' ya heka sigām kamemon. ");
INSERT INTO sml_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Manjari si Yahud ya sinō' e' si Yakub parahū min sigām ni tongod si Yusup, bo' aniya' magmalim ma lahat Gosen. Pagt'kka pa'in sigām pehē', ");
INSERT INTO sml_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","bo' kinata'uwan e' si Yusup, magtūy pinasakap e'na kalesana. Jari parai'-dai' iya ni Gosen amāk mma'na. Magbāk pa'in, magtūy ginapus si Yusup ma mma'na maka e'na anangis pat'ggol. ");
INSERT INTO sml_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ya lling si Isra'il ma si Yusup, “Ndū' anakku, allum du hati ka! Lilla' na aku amatay pagka ka'a-i ta'nda'ku na.” ");
INSERT INTO sml_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","32","Puwas e', ah'lling si Yusup ma saga danakanna sampay ma lahasiya'na kamemon ya ma deyoman mma'na. Yukna, “Patut aku subay paharap ni Pira'un amata'uwan iya in dauranakanku sampay lahasiya'ku kamemon magt'kkahan na min lahat Kana'an. Itiya' na kam ma aku. Pata'uku isab iya pasal pagusahabi magipat bili-bili maka sapi', ya angkan tabowabi pi'itu ba'anan kahayopan maka pangalta' bay suku'bi ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Jarina, bang kam sinō' patampal ni Pira'un bo' kam tinilaw bang ai pagusahabi, ");
INSERT INTO sml_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","sambungunbi iya buwattitu, yukbi, ‘Ya kami sosoho'annu itu, a'a magi'ipat hayop asal min jaman kaonde'-onde' kami. Ang'ntan kami bay pagusaha ka'mbo'-mbo'an kami.’ Na, bang buwattē' panambungbi, tinugutun du kam pat'nna' ma lahat Gosen. Sababna ya addat bangsa Misil mbal magdalahat maka a'a magi'ipat hayop, asammal kono' ma pang'nda' sigām.” ");
INSERT INTO sml_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Na, pehē' si Yusup ni Pira'un. Yukna ma iya, “Tuwan sultan, ilu na mma'ku maka saga danakanku at'kka min Kana'an. Tabowa e' sigām ba'anan saga kahayopan maka pangalta' sigām kamemon. Ina'an sigām ma jadjahan Gosen buwattina'an.” ");
INSERT INTO sml_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Manjari aniya' lima danakanna pinene' e' si Yusup pinakilā ma Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tinilaw sigām e' Pira'un, “Ai usahabi?” Ya sambung sigām, “Tuwan Pira'un, in kami sosoho'annu itu a'a magi'ipat bili-bili, buwat bay ka'mbo'-mbo'an kami. ");
INSERT INTO sml_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bay kami pi'itu arak maglahat maitu sabab asigpit na gotom ma lahat Kana'an. Halam aniya' minsan sagmot pagkakan saga hayop kami. Angkan ko' kami parahing ni ka'a, Tuwan, bang pa'in kami tugutannu pat'nna' ma Gosen.” ");
INSERT INTO sml_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Angabtang Pira'un ma si Yusup, yukna, “Na, pagka ilu na mma'-danakannu ma ka'a, ");
INSERT INTO sml_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","makajari na sigām maglahat maingga-maingga kabaya'an sigām ma kaluha'an lahat Misil. Piha'in sigām tana' umbul-satu paglahatan sigām ma Gosen. Maka bang aniya' a'a kata'uwannu min sigām taga-kapandayan, pat'nna'un iya magmandul ma saga a'a ya magi'ipat ba'anan hayopku.” ");
INSERT INTO sml_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pagpuwas ina'an, binowa e' si Yusup mma'na si Yakub pinakilā pehē' ni Pira'un. Ati angamu'an si Yakub pahala' ma Pira'un pangahulmatna ma iya. ");
INSERT INTO sml_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Jari aniya' patilaw Pira'un ma iya, yukna, “Pilantahun na umulnu, tuwan?” ");
INSERT INTO sml_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ya sambung si Yakub, “Tuwan sultan, dahatus na maka t'llumpū' tahun ya paglunsul-lunsulku maitu ma dunya. Aheka isab kasukkalan bay kalabayanku. Sagō' mbal sakit at'ggol, ngga'i ka buwat bay paglunsul-lunsul kamatto'ahanku.” ");
INSERT INTO sml_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Na niamu'-amu'an Pira'un kahāpan isab e' si Yakub bo' yampa ama'id paluwas minnē'. ");
INSERT INTO sml_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Manjari pinatuntul pahāp e' si Yusup paglahat mma'na maka saga danakanna maina'an ma lahat Misil. Bineya' e'na panoho'an Pira'un angkan disi Yakub kabuwanan tana' ahāp to'ongan ma jadjahan da'ira Ramisis. ");
INSERT INTO sml_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jari amalanja' na pa'in si Yusup ma mma'na maka ma saga danakanna sampay ma lūng-kampungna kamemon. Talapay isab saga kamanahutan. ");
INSERT INTO sml_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Pasōng na pa'in kasigpit gotom sampay halam na to'ongan aniya' kinakan minsan maingga-maingga. Jari saga a'a kamemon ma kalahat-lahatan Misil maka Kana'an magkalammahan na e' punung. ");
INSERT INTO sml_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Magb'lli na pa'in sigām balanja' pehē' ni si Yusup. Tinipun e'na kamemon sīn pam'lli sigām bo' yampa bowana ni deyom astana' Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na, apuppus pa'in saga sīn kamemon ma kalahatan Misil maka lahat Kana'an, pina'an ni si Yusup saga a'a Misil parahing. Yuk sigām, “Arōy, tuwan, buwanin kami pagkakan! Halam aniya' sīn kami pam'lli. Da'a pa'in kami pasagarin amatay e' punung itu!” ");
INSERT INTO sml_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ya sambung si Yusup, “Bang hati' halam aniya' sīnbi, na, bowahun pi'itu saga hayopbi panambi' kinakan.” ");
INSERT INTO sml_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Manjari binowa saga hayop sigām, saga kura', bili-bili, kambing maka sapi'. Binowa e' sigām pehē' ni si Yusup panambi' pagkakan. Jari aniya' kinakan pamalanja' sigām e' si Yusup ma deyom dantahun inān, panambi' saga hayop sigām. ");
INSERT INTO sml_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Aubus pa'in dantahun e', pabalik na isab sigām pehē' ni si Yusup. Ya lling sigām, “Tuwan, mbal kalimbungan kami min ka'a, halam na aniya' sīn kami maka ilu ma ka'a isab saga hayop kami kamemon. Halam aniya' takapin pamuwan kami ma ka'a, luwal baran kami maka tana' kami. ");
INSERT INTO sml_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ndū' tuwan, da'a kami pasagarin pinunung. Kaugun isab tana' kami bang halam aniya' makapajatu iya. B'llihun baran kami sampay tana' kami panambi' kinakan. Minsan kami pina'ata ma Pira'un, minsan tana' kami pinasuku' ma iya, bang pa'in kami mbal amatay gotom. Buwanin kami isab binhi' tinanom bo' mbal kaugun tana' kami.” ");
INSERT INTO sml_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Na, pagka buwattē' kabisa gotom, tab'lli e' si Yusup tana' kamemon bay suku' saga a'a Misil pakaniya-pakaniya. Manjari Pira'un na tag-tana' kamemon, ");
INSERT INTO sml_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ati saga a'a kamemon ma lahat Misil tahinang atana ma sabab hinang si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ya sadja halam tab'lli e' si Yusup tana' saga kaimaman. Aniya' balanja' sigām min Pira'un sakahaba' llaw, angkan halam bay tapab'lli saga tana' sigām. ");
INSERT INTO sml_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Manjari aniya' pamissala si Yusup ma saga a'a inān kamemon, yukna, “Na buwattina'an, pagka tab'lliku ka'am sampay tana'bi bo' kam suku' Pira'un na, na, itiya' na saga binhi' pananombi ma deyom tana'. ");
INSERT INTO sml_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Malaingkan, bang kam magani buwa' tinanombi, ya buwa'na subay binahagi' palima. Dabahagi' ilu subay pinasuku' ma Pira'un, ya mpat bahagi' takapin subay ma ka'am bo' aniya' pananombi pabīng maka aniya' takakanbi magtai'anak.” ");
INSERT INTO sml_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ya sambung sigām “Tuwan, kalappasan kami min kamatay sabab ka'a. Bang pa'in ahāp sadja ataynu tudju ni kami, kami itu magpa'ata na ma Pira'un.” ");
INSERT INTO sml_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Manjari aniya' sara' pinat'nna' e' si Yusup ma lahat Misil, subay pinasuku' ma Pira'un bahagi' lima min ai-ai pinagani ma deyom lahat. Bineya' sara' inān sampay ni kabuwattina'anan. Luwal tana' saga kaimaman halam bay pinasuku' ma Pira'un. ");
INSERT INTO sml_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Manjari maglahat na bangsa Isra'il ma Gosen, ma deyom lahat Misil. Pasōng heka puhu' sigām, pasōng isab heka pangalta' sigām. ");
INSERT INTO sml_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sangpū' maka pituntahun ya paglahat si Yakub mahē' ma Misil sampay dahatus maka mpatpū' maka pituntahun umulna. ");
INSERT INTO sml_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Manjari itu, song pa'in ta'abut waktuna, nilinganan e'na anakna si Yusup. Yukna, “Bang ka'a-i alasa du ma aku, pat'nna'un lagi' tangannu ma llotan pa'aku bo' yampa ka magsapa in janji'nu ma aku mbal binalubahan. Janji'in aku in aku mbal kubulnu maitu ma lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bilahi aku kinubul ma pangubulan saga ka'mbo'-mbo'anku. Angkan na bang aku amatay, bowahun bangkayku paluwas min Misil itu ati kubulunbi aku ma bay pagkubulan sigām.” Ya sambung si Yusup, “Aho' Mma', beya'ku llingnu ilu.” ");
INSERT INTO sml_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“Magsapa ka,” yuk si Yakub e'. Agsai pinagsapahan e' si Yusup. Manjari mahē' na si Yakub patukku' ma pabahakanna angamu' duwa'a ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Palabay pa'in waktu, kahaka'an si Yusup pasal mma'na alamma na, angkan iya patibaw pehē'. Binowa isab e'na karuwangan anakna si Manasse maka si Epra'im. ");
INSERT INTO sml_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Pagta'u si Yakub ilu na at'kka si Yusup, magtūy iya pakulasog papunduk. ");
INSERT INTO sml_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ah'lling iya ma si Yusup, yukna, “Waktu kamahē'ku lagi' ma Lūs ya ma lahat Kana'an, bay magpa'nda' ma aku Tuhan Sangat Kawasa. Aniya' kahāpan pamuwanna ma aku, ");
INSERT INTO sml_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","yukna, ‘Pahekaku panubu'nu sampay sigām tahinang kabangsa-bangsahan. Pamuwanku isab lahat Kana'an ilu palsuku'an saga panubu'nu sampay ni kasaumulan.’ ” ");
INSERT INTO sml_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Magsibahat na pa'in si Yakub ma si Yusup, yukna, “Yusup, in pasal anaknu, ya bay nianakan ma lahat Misil dahū gi' min kapi'ituku, in sigām karuwangan subay pamasuku' ma aku. Aho', si Epra'im maka si Manasse subay ni'itung anakku luggiya' buwat si Rubin maka si Simiyun. ");
INSERT INTO sml_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Malaingkan bang aniya' gi' anaknu liyu min sigām duwangan itu, suku'nu na. Maka tana' pamusaka' sigām subay niā' min bahagi' tana' ya pamasuku' ma si Epra'im maka si Manasse. ");
INSERT INTO sml_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ina'nu si Rakiya ya sababanna angkan sigām ni'itung anakku. Landu' aheya dukkaku ma kamatayna. Ma l'ngnganan pa'in kami pabīng ni Kana'an min lahat Mesopotami, alawak-lawak gi' min kauman Eprata, amatay na iya. Jari takubulku iya mahē' ma bihing lān tudju ni Eprata.” Eprata itu, ya na Betlehem ma buwattina'an. ");
INSERT INTO sml_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Manjari pag'nda' si Yakub ma saga anak si Yusup, atilaw iya, “Sai saga onde' itu?” ");
INSERT INTO sml_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ya sambung si Yusup, “Mma', ya na ko' itu anakku l'lla bay pamuwan Tuhan ma aku maitu ma Misil.” Yuk si Yakub, “Pasōngun sigām pi'itu supaya sigām kapangamu'anku kahāpan min Tuhan.” ");
INSERT INTO sml_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Na si Yakub itu, mbal agon maka'nda' sabab ato'a na iya to'ongan. Angkan pinasekot e' si Yusup saga anakna. Magtūy sigām ginapus e' si Yakub sampay siniyum. ");
INSERT INTO sml_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yuk si Yakub ma si Yusup, “Halam aku bay makaholat ang'nda' ka'a pabīng, daipara kahandak min Tuhan itiya' ka ta'nda'ku sampay isab anaknu.” ");
INSERT INTO sml_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Pagpuwas, pinala'an e' si Yusup anakna min gibahan mma'na bo' yampa iya pasujud ma dahuanna. ");
INSERT INTO sml_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Manjari binalutan e' si Yusup anakna duwangan bo' pinasekot ni si Yakub. Si Epra'im ya pinasekot ni tangan si Yakub gibang, si Manasse ni tanganna kowan. ");
INSERT INTO sml_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Saguwā' pinagsaliyu e' si Yakub tangan mma'na bo' pinat'nna' tanganna kowan ma kōk si Epra'im minsan iya siyali. Maka tanganna gibang pinat'nna' ma kōk si Manasse, ya siyaka. ");
INSERT INTO sml_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Pagbuwattē', niamu'an duwa'a disi Yusup e' si Yakub, yukna, “Bang pa'in saga onde' itu binuwanan kahāpan e' Tuhan ya pameya'an mbo'ku si Ibrahim maka mma'ku si Isa'ak. Bang pa'in sigām pinat'kkahan lidjiki' e' Tuhan, ya bay angupiksa' aku min kanahutku sampay ni kabuwattituku, Bang pa'in nianughala'an duwangan onde' itu e' Mala'ikat ya bay amapuwas aku min kamulahan kamemon. Bang pa'in sigām pas'lle' amowa ōnku maka ōn mma'ku si Isa'ak sampay ōn mbo'ku si Ibrahim. Bang pa'in paheka to'ongan isab saga panubu' sigām maitu ma babaw dunya itu.” ");
INSERT INTO sml_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Na, pag'nda' si Yusup ma mma'na amat'nna' tanganna kowan ma kōk si Epra'im, halam iya kasulutan. Binalutan e'na tangan mma'na kowan, arak pinat'nna' ma kōk si Manasse. ");
INSERT INTO sml_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yukna ma mma'na, “Mma', asā' ko' ilu! Ya itu siyaka, ya subay pinat'nna'an tangannu kowan.” ");
INSERT INTO sml_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Sagō' mbal bilahi si Yakub, yukna, “Aho' Otō', kata'uwanku du. Si Manasse ilu b'nnal paheka panubu'na tahinang bangsa ga'osan. Malaingkan siyalina ya labi akosog min iya. Saga panubu' si Epra'im itu subay paheka to'ongan sampay sigām tahinang aheka bangsa gaga'osan.” ");
INSERT INTO sml_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Manjari niamu'-amu'an sigām kahāpan ma llaw ina'an-i. Yuk si Yakub, “Ma tahun sinōng, bang aniya' a'a Isra'il angamu'an kahāpan ma sai-sai, ōnbi ya panabbutanna. Buwattitu ya pangamu' sigām, ‘Bang pa'in kam binuwanan kahāpan e' Tuhan buwat bay ma si Epra'im maka si Manasse.’ ” Buwattē' pah'lling si Yakub, pagka paheyana si Epra'im labi min si Manasse. ");
INSERT INTO sml_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Puwas e', ah'lling isab si Yakub ma anakna si Yusup, yukna, “Nda'un, asekot na waktuku. Saguwā' mbal kam pinasagaran e' Tuhan. Pagapi' du iya ma ka'am bo' kam tabowana pabīng ni lahat ka'mbo'-mbo'anbi. ");
INSERT INTO sml_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma deyom saga anakku, ka'a ya pusaka'anku tana' lahat Sekem, ya tana' ahāp ma kabūd-būran bay ngā'ku min bangsa Amor. Ya bay pangā'ku iya pakokosku kalis maka pana'.” ");
INSERT INTO sml_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Manjari nilinganan e' si Yakub saga anakna kamemon. “Pasekot kam,” yukna, “patipun kam ni aku. Haka'anta kam dangan maka dangan bang ai ya kasōnganbi ma tahun damuli. ");
INSERT INTO sml_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Patipun kam saga anak si Yakub, pakale kam ma pangabtang ya pang'bbahan ka'am e' mma'bi si Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ka'a Rubin, anakku kasiyakahan, anak min kosogku, paltanda'an pagkal'llaku. Min kamemon saga anakku, ka'a ya pagmakōkan akosog maka abantug. ");
INSERT INTO sml_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Saguwā' ya salla'nu, bay pakaiya'nu mma'nu pagka hulidnu h'ndana dakayu'. Napsunu ilu sali' dunuk mbal katiyara'an, angkan ka mbal na makalanga min dauranakannu. ");
INSERT INTO sml_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","6","Ka'am Simiyun maka Libi, dalimbang du kam. Mbal aku bilahi palamud ma pagisunanbi, mbal pasōd ni deyom palhimpunanbi. Asapat kam angahublut pakokosbi ma saukat apasu' pangatayanbi. Bang kam niastolan, magtūy kam amono' a'a, tapengkolbi saga sapi' mandangan ma halam sababna. ");
INSERT INTO sml_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bang pa'in kam pinat'kkahan mulka' ma sabab pangastolbi mbal tasangsang. Pinapulak-palik saga panubu'bi ma katilibutan lahat Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Na, ka'a Yahud, pinudji du ka e' saga dauranakannu. Pasujud sigām pagmahaltabat ma ka'a. Tara'ugnu du palbantahannu. ");
INSERT INTO sml_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ka'a ilu ibarat halimaw asangpot kosogna. Bang aubus e'na an'kkob hayop maka amangan magtūy pah'nnat atuli ma tongod ina'an. Halam aniya' makatawakkal pasekot anasat iya. ");
INSERT INTO sml_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Saga panubu'nu, Yahud, sinusultan salama-lama. Mbal alungay kapatutnu kapagsultan sampay at'kka a'a dangan ya apatut pinaghulmatan. Kapagbaya'anna saga kabangsa-bangsahan. ");
INSERT INTO sml_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kaengkotan kura'na ni batang anggul, ya ahāp suliganna min kamemon. Ajatu to'ongan ba'anan buwa' anggulna, landu' aheka bohe'na bang tap'gga', manjari pangandakdakan s'mmekna. ");
INSERT INTO sml_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana arokot keyatna min bohe' anggul, emponna apote' sidda min gatas. ");
INSERT INTO sml_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Na, anakku si Sibulun, bihing tahik ya paglahatanna, manjari paglalayohan kappal. Aluha isab tana'na, maka'abut sampay ni lahat Sidun. ");
INSERT INTO sml_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Na, si Issakar, sali' sapantun kura' akosog baranna, pabahak sadja ma t'ngnga' duwa'anna. ");
INSERT INTO sml_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Pagsayuna ahāp pabahakanna, magtūy iya amuspus kosogna angahangkut. Pagsayuna ahāp paglahatanna, magtūy iya lilla' pina'ata maghulas-magsangsā'. ");
INSERT INTO sml_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Anakku si Dān, amat'nna' hukuman abontol ma saga a'ana, pagka dapanubu' sigām ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ibarat iya sowa abisa pat'nna' ma bihing lān. Bang aniya' palabay minna'an a'a magkura', tinanghab e'na kura' inān ma buli' tape'na supaya pahantak ni buli'an a'a angura' he'. ");
INSERT INTO sml_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Yawe, lagaranku waktu pangalappasnu ma aku. ");
INSERT INTO sml_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Na, anakku si Gād isab, nilangpasan ko' ka'a ilu e' saga mundu, sagō' taturulnu sigām sampay ka'atuhannu. ");
INSERT INTO sml_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Si Aser isab, alanab kinakan ya niā' min tana'nu, kinakan ahāp nanamna patut pagkakan sultan. ");
INSERT INTO sml_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Si Naptali isab, sali' sapantun usa d'nda bay pinal'ppa min sasak. Alingkat isab saga anakna. ");
INSERT INTO sml_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Na, anakku si Yusup, sali' hantang po'on kayu ajatu to'ongan buwa'na, ya patomo' asal ma bihing bohe'. Palabung saga sanga sampay parambila' sasak. ");
INSERT INTO sml_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nirugpak iya e' saga a'a magtakos pana', nijingki iya e' sigām. ");
INSERT INTO sml_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Malaingkan atotog l'ngngonna, ahogot e'na ang'ntan pana' ma sabab tabang min Tuhan Sangat Kawasa, ya Tuhan pagtuhanan si Yakub. Niupiksa' iya e' Tuhan, ya Batu-Lakit pasindungan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tinabang du si Yusup e' Tuhanku ya pagtuhanan mma'nu, binarakatan ka e' Tuhan Sangat Kawasa. Kabuwanan ka kahāpan, ulan min diyata' langit, bohe' min deyom tana', kahāpan panganak maka kahāpan pamaruru'. ");
INSERT INTO sml_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","In lidjiki' pangamu'-ngamu'anku ka'a itu labi ahāp min lidjiki' kabūd-būran, lidjiki' bay min awal. Mura-murahan, bang pa'in saga lidjiki' itu kamemon makani-si Yusup, ya tapene' e' Tuhan pinaliyu min dauranakanna. ");
INSERT INTO sml_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Anakku isab si Benjamin, a'a aesog iya, sali' sapantun ero' talun. Subu-subu amangan ai-ai bay papatayna. Abay kohap amahagi' ai-ai bay tatabanna ma pagbono'an.” ");
INSERT INTO sml_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Na, ya du ina'an saga bangsa Isra'il kasangpū' maka duwa. Ya ina'an kabtangan bay pang'bba e' si Yakub ma anakna kasangpū' maka duwa, ya makatōpan sigām dangan maka dangan. ");
INSERT INTO sml_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Manjari aniya' panoho'an pang'bba e' si Yakub ma saga anakna he', “Itiya' aku arai' na patipun ni ka'mbo'-mbo'anku. Bang aku ta'abut na, kubulunbi aku ma deyom songab batu bay pangubulan ka'mbo'-mbo'anku. Ina'an ma lahat Kana'an, ma tana' Makpela ya ma anggopan Mamre. Songab batu inān sampay tana'na bay tab'lli e' mbo'ku si Ibrahim min si Epron bangsa Hīt. ");
INSERT INTO sml_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ina'an maina'an pagkubulan si Ibrahim maka h'ndana si Sara, mma'ku si Isa'ak maka ina'ku si Ripka. Ina'an isab pagkubulanku h'ndaku si Leya. ");
INSERT INTO sml_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ya tana' maka songab ilu bay tab'lli min saga bangsa Hīt.” ");
INSERT INTO sml_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Aubus pa'in e' si Yakub ang'bba panoho'anna inān ma saga anakna, magtūy iya pabahak bo' yampa ab'kkat napasna. Hatina magtipun na iya maka kamatto'ahanna. ");
INSERT INTO sml_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Awapat pa'in si Yakub, magtūy iya ginapus pahogot e' anakna si Yusup. Tinangisan iya, siniyum isab baihu'na. ");
INSERT INTO sml_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Pagpuwas, magpanoho'an si Yusup ma saga panday ya tendogna, sinō' kinapul bangkay mma'na. ");
INSERT INTO sml_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Manjari aniya' mpatpū' llaw ya t'ggol sigām magkapul. Addat Misil ko' inān. Pitumpū' llaw isab ya paghinang saga a'a Misil pagdukka sigām ma iya. ");
INSERT INTO sml_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Atammat pa'in paghinang e', ah'lling si Yusup ma saga tendog Pira'un, yukna, “Bang makajari, pasampayunbi lapalku itu pehē' ni Pira'un, yukbi, ");
INSERT INTO sml_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tuwan sultan, marai' pa'in waktu mma'ku, bay aku pinasapa e'na. Bangkayna kono' subay kinubul ma lahat Kana'an, ma pagkubulan bay tagamahanna ma baranna. Jari makasapa aku, ya angkan subay beya'ku na. Angamu' aku ma ka'a, Tuwan, bang pa'in aku tugutannu pehē' ni Kana'an angubul mma'ku.’ Pabalik du aku pi'itu bang aubus na.” ");
INSERT INTO sml_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ya sambung Pira'un ma si Yusup, “Makajari,” yukna. “Pehē' na ka angubul mma'nu. Beya'un bay pagsapahannu maka iya.” ");
INSERT INTO sml_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Manjari palanjal na si Yusup angubul mma'na. Pabunyug isab ma iya kamemon saga tendog ya pagnakura'an ma okoman Pira'un, ma deyom astana' ka atawa ma kaluha'an lahat Misil. ");
INSERT INTO sml_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ya du pabunyug ma si Yusup saga dauranakanna maka saga a'a kamemon ya ma deyomanna. Tabeya' isab saga a'a bay ma deyoman mma' sigām. Ya sadja halam tabeya' kamanahutan maka ba'anan hayop sigām. Tabba maina'an ma Gosen. ");
INSERT INTO sml_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aniya' pagapi' ma sigām saga a'a magkakaritun sampay saga a'a magkukura'. Jari landu' aheka sigām bay maglurukan angubul mma' si Yusup. ");
INSERT INTO sml_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ta'abut pa'in sigām paggi'ikan pai ma Atad, ma bihing sapa' Jordan, magkarukka'an sigām ma mma' si Yusup. Akosog sidda pagdukka sigām. Jari pitumbahangi ya t'ggol paghinang si Yusup ma mma'na ma atag ina'an. ");
INSERT INTO sml_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na pag'nda' paghinang itu e' saga bangsa Kana'an ya maglahat maina'an, yuk sigām, “Kaheya du pa'in karukka'an saga bangsa Misil e'.” Angkan kaōnan lahat inān Abel Misraim. ");
INSERT INTO sml_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Na, bineya' e' saga anak si Yakub buwat bay panoho'anna ma sigām. ");
INSERT INTO sml_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Binowa bangkayna ni lahat Kana'an bo' kinubul e' sigām ma deyom songab batu ma tana' Makpela ya ma anggopan Mamre. Tana' inān bay tab'lli asal e' si Ibrahim min si Epron bangsa Hīt bo' pagkubulan. ");
INSERT INTO sml_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na, takubul pa'in, pabalik na disi Yusup ni lahat Misil, iya maka saga danakanna sampay sigām kamemon bay amunyugan mma'na he'. ");
INSERT INTO sml_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na, pagka amatay na mma' sigām, magisun-isun saga danakan si Yusup. Yuk sigām, “Kalu aniya' akon-akon tatau' e' si Yusup ma deyom atayna pasal kala'atan kamemon bay tahinangtam ma iya. Painay bang kitam binalosan e'na?” ");
INSERT INTO sml_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Manjari anambuku sigām pehē' ni si Yusup, yuk-i, “Tuwan, ma halam lagi' amatay Mma'tam, aniya' bay panoho'anna. ");
INSERT INTO sml_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Sinō' ka tinambukuhan buwattitu: ‘Ampunun dauranakannu ma pasal dusa maka kala'atan bay tahinang sigām ma ka'a.’ Ya du ilu panambuku si Mma' ma ka'a. Manjari, Tuwan, itiya' kami parahing ma ka'a bang pa'in kami ampunnu, pagka in kami itu ata Tuhan ya pagtuhanan mma'tam.” Na, pagkale lapal itu e' si Yusup, magtūy iya tatangis. ");
INSERT INTO sml_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Puwas e', patampal saga danakanna ni si Yusup bo' yampa sigām pak'ppang ni tana' ma munda'anna. Ya lling sigām ma iya, “Tuwan, itiya' kami magpatiata ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sagō' ya sambung si Yusup ma sigām, “Da'a kam tināw ma aku. Ngga'i ka aku ya magbaya', luwal Tuhan. ");
INSERT INTO sml_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","B'nnal, ala'at asal bay maksudbi, sagō' kahāpan ya pangangganti' e' Tuhan, ya angkan tahinang hinangku itu angalappasan manusiya' aheka min kamatay. ");
INSERT INTO sml_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Angkan yukku ma ka'am, da'a kam agawa. Akuhanku balanja'bi sampay saga ka'anakanbi.” Sakali asannang na pangatayan sigām ma sabab kahanunut bissala si Yusup e'. ");
INSERT INTO sml_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Manjari maina'an na pa'in si Yusup pat'nna' ma lahat Misil maka saga a'a kamemon bay ma okoman mma'na. Allum iya sampay dahatus maka sangpū' tahun umulna. ");
INSERT INTO sml_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ta'abutna saga anak-mpu si Epra'im, maka tagibana isab mpu si Manasse min anakna si Makil. ");
INSERT INTO sml_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na, angabtang na si Yusup ma saga danakanna, yukna, “Aku itu arai' na ta'abut, sagō' ka'am ilu tinabang du e' Tuhan. Ma waktu sinōng binowa kam e'na paluwas min lahat itu tudju ni lahat bay panganjanji'na ma kamatto'ahantam disi Ibrahim, si Isa'ak maka si Yakub.” ");
INSERT INTO sml_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jari pinasapa e' si Yusup saga pagkahina panubu' si Isra'il (ya kaōnan isab si Yakub). “Sapahinbi aku,” yukna, “in to'olangku bowabi du bang ta'abut waktu panabang Tuhan ma ka'am paluwas min lahat itu.” ");
INSERT INTO sml_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Manjari awapat na si Yusup maina'an ma Misil, dahatus maka sangpū' tahun umulna. Kinapul bangkayna bo' yampa ni'isi ni deyom lalungan.");
INSERT INTO sml_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Na, ya na itu saga anak nabi Isra'il l'lla ya bay ameya' ma iya papinda ni lahat Misil maka anak-h'nda sigām. ");
INSERT INTO sml_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ōn sigām si Rubin, si Simiyun, si Libi maka si Yuda, ");
INSERT INTO sml_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","si Issakar, si Sibulun maka si Benjamin, ");
INSERT INTO sml_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","si Dān, si Naptali, si Gād maka si Aser. ");
INSERT INTO sml_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Pitumpū' ya heka saga panubu' si Isra'il kamemon ma waktu ina'an-i, sagō' anakna si Yusup halam bay taitung sabab wa'i asal ma Misil. ");
INSERT INTO sml_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Manjari palabay pa'in patahunan, amatay na disi Yusup magdauranakan sampay anak-mpu sigām. ");
INSERT INTO sml_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Malaingkan saga tubu' sigām anganak paheka sampay asaplag na ma lahat Misil. Makalandu' na heka sigām. ");
INSERT INTO sml_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Manjari itu, ma masa damuli gi', aniya' sultan saddī aningkō' magsultan ma lahat Misil, sultan a'awam ma pasal bay kahālan si Yusup. ");
INSERT INTO sml_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yuk sultan itu ma saga a'ana, “Nda'unbi na saga a'a Isra'il ilu, makalandu' to'ongan heka sigām, mbal na ka'atuhantam. ");
INSERT INTO sml_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Jari in kitam itu subay maggara' pahāp. Bang pasagaranta sigām paheka, bo' aniya' bantatam ganta' parugpak pi'itu, piligdu. Pagapi' arai' bangsa Isra'il itu ma saga bantatam. Magdakayu' sigām amono' kitam ati makaluwas sigām min lahat Misil itu.” ");
INSERT INTO sml_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ya he' sababna angkan aniya' saga a'a Misil bay gin'llal amanyaga' ma saga a'a Isra'il. Abuhat makalandu' ya hinang pamahinang e' saga bag'llal itu ma saga a'a Isra'il angkan sigām mbal na aholat nilappasan. Aniya' duwa da'ira nihinang e' sigām pagtau'an ba'anan anihan tinanom ya suku' Pira'un. Pitum maka Ramisis ya pagōn saga da'ira he'. ");
INSERT INTO sml_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Sagō' minsan buwattingga e' saga a'a Misil amanyaga' ma bangsa Isra'il, luhūy pasōng heka sigām sampay pasaplag na ma kaluha'an lahat. Angkan sigām kinagawahan e' saga bangsa Misil, ");
INSERT INTO sml_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","manjari gom pa'in pinabuhatan saga hinang ya pamahinang e' saga a'a Misil ma bangsa Isra'il e'. ");
INSERT INTO sml_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Pinahunitan sidda kahālan sigām, mbal agon kasandalan. Sinō' sigām angahinang saga luma' tisa' maka sinō' maghinang abuhat ma kahuma-huma'an. Jari ab'ngngis saga a'a Misil, mbal to'ongan ma'ase'. ");
INSERT INTO sml_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Manjari itu ma dakayu' llaw pa'in, aniya' panoho'an sultan Misil ma si Sipra maka si Puwa, duwangan panday ya magpa'anak ma saga d'nda Hibrani. ");
INSERT INTO sml_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ya panoho'an sultan ma sigām, “Ka'am ilu,” yukna, “bang kam ama'anak ma saga kar'ndahan Hibrani bo' ta'nda'bi l'lla ya anakna, papatayhunbi saru'un-du'un. Bang d'nda, pasagarinbi allum.” ");
INSERT INTO sml_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Sagō' saga panday inān magmatāw asal ma Tuhan angkan halam bineya' e' sigām bay panoho'an sultan e'. Halam pinapatay saga onde'-onde' l'lla bay nianakan. ");
INSERT INTO sml_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na, pagka buwattē', pinalinganan pabalik saga panday itu e' sultan bo' tinilaw e'na. “Angay,” yukna, “halam beya'bi panoho'anku? Angay pakallumbi saga onde'-onde' l'lla bay nianakan?” ");
INSERT INTO sml_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Anambung sigām ma Pira'un, yuk-i, “Tuwan sultan, ya b'nnalna, in d'nda Hibrani kaluhayan sidda bang maganak, ngga'i ka buwat saga d'nda Misil. Pagt'kka panday ni luma', ina'an na asal ma luwasan onde'-onde'.” ");
INSERT INTO sml_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Manjari nihāp duwangan panday inān e' Tuhan ma sabab pagaddat sigām ma iya, ati kabuwanan sigām tubu'. Maka ba'anan bangsa Isra'il isab gom pa'in paheka. ");
INSERT INTO sml_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ya katobtobanna aniya' panoho'an Pira'un ma saga a'ana kamemon. Yukna, “Bang aniya' onde'-onde' l'lla baha'u nianakan ma bangsa Hibrani, timaninbi ni sapa' Nīl supaya amatay kamemon. Sagō' bang onde'-onde' d'nda, da'a inayunbi.” ");
INSERT INTO sml_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na, aniya' dakayu' l'lla bangsa Isra'il panubu' si Libi makah'nda ni pagkahina tubu' si Libi. ");
INSERT INTO sml_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Manjari, ab'ttong d'nda itu sampay anganak l'lla. Ta'nda'na pa'in ya kahāp luwa onde'-onde' bay nianakan e'na, na, tinapukan e'na ma deyom t'llumbulan bo' mbal tabāk e' a'a Misil. ");
INSERT INTO sml_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Sagō' ta'abut pa'in mbal na katapukan, in d'nda itu bay angā' ambung nihinang min batang parang. Bay pininta maka kitlan bo' mbal ang'mman, ati pinalege onde' ma deyomna bo' yampa pinagūng ma deyom kaparangan alangkaw ya patomo' ma bihing sapa' Nīl. ");
INSERT INTO sml_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ina'an asal siyakana d'nda an'ngge min kalawak-lawakan anganjagahan onde'-onde' inān bang ai tum'kka ni iya. ");
INSERT INTO sml_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Sakali itu makapina'an dayang-dayang anak Pira'un amandi ma sapa'. Ina'an isab saga ipang-ipangna anusul-nusul min bihing sapa'. Manjari ta'nda' e' dayang-dayang ambung e' pagūng ma bihing sapa', ma kaparangan. Pag'nda'na, magtūy sinoho' e'na dakayu' ipang-ipangna palūd pina'an angā'. ");
INSERT INTO sml_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ta'ā' pa'in ambung e', niukab magtūy e' dayang-dayang ati ta'nda' e'na onde'-onde' l'lla ma deyomna anangis. Jari sinōd iya ase' ma iya. “Ndū',” yukna, “anak Hibrani ko' itu.” ");
INSERT INTO sml_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Manjari pina'an d'nda-d'nda ya siyaka onde' bo' atilaw ma dayang-dayang ya anak sultan e'. “Dayang-dayang,” yukna, “bilahi ka bahā' bang aku amiha'an ka'a d'nda Hibrani amaruru' onde'-onde' ilu?” ");
INSERT INTO sml_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ya sambung dayang-dayang, “Aho', arung. Pehē' ka amiha.” Magtūy iya pehē' angā' ina'na. ");
INSERT INTO sml_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pagt'kka ina' onde', yuk dayang-dayang ma iya, “Ā, onde'-onde' itu. Bowahun iya amole' ni luma'bi bo' paruru'in aku. Tambahanta pa'in ka angipat iya.” Manjari onde'-onde' inān binowa amole' e' ina'na pinaruru' maka ni'ipat pahāp. ");
INSERT INTO sml_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Na, aheya-heya pa'in onde'-onde' itu, ni'nde'an na e' ina'na pehē' ni dayang-dayang ati tahinang sali' anakna luggiya'. Ya ma pikilan dayang-dayang e', “Ōnanku iya Musa, sabab bay iya paluwasku min deyom bohe'.” ");
INSERT INTO sml_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Asangpot pa'in kasubul si Musa, pehē' na iya ni atag paghinangan saga pagkahina bangsa Hibrani. Ta'nda'na sigām ma deyom kabinasahan pagka pinahinang abuhat e' bangsa Misil. Aniya' isab dakayu' a'a Misil ta'nda' e' si Musa angandaplosan dakayu' pagkahina bangsa Hibrani. ");
INSERT INTO sml_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Na, maglingi'-lingi' si Musa. Pag'nda'na halam aniya' a'a saddī maina'an, magtūy binono' e'na a'a Misil e' bo' yampa l'bbonganna bangkayna ma deyom gusung. ");
INSERT INTO sml_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pagsalung pa'in, makabalik si Musa ni bay papehē'anna. Sakali aniya' ta'nda'na maina'an duwangan a'a Hibrani magbono'. Yuk si Musa ma a'a dangan ya taga-dusa, “Angay la'ugannu pagkahinu Hibrani?” ");
INSERT INTO sml_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ya sambung a'a inān ma si Musa, “Ē, sai bay amuwanan ka'a kapatut magbaya' maka angahukum ma kami! Papataynu isab aku buwat bay pamapataynu a'a Misil e'?” Magtūy tināw si Musa. Yukna ma deyom atayna, “Tantu tasayu bay hinangku ma a'a Misil e'.” ");
INSERT INTO sml_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na kahaka'an pa'in Pira'un pasal palkala' itu, anganiyat iya subay pinapatay si Musa. Daipara makalahi si Musa tudju ni lahat Midiyan bo' pat'nna' mahē'. Ma dakayu' llaw, wa'i iya aningkō' ma bihing pagbohe'an. ");
INSERT INTO sml_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Jari aniya' at'kka pina'an pitu' budjang anak si Jetro ya imam ma lahat Midiyan. Ya gawi sigām angā' bohe' bo' tinumpahan ni paginuman saga kahayopan ya suku' mma' sigām. ");
INSERT INTO sml_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Sagō' saga budjang inān bay nilāng e' saga a'a kasehe', ya magi'ipat ba'anan bili-bili sigām. Jari itu, pagka mbal pinasauk saga kabudjangan e', an'ngge si Musa angandapitan sigām. Anauk iya bohe' isab pamainumna ma saga bili-bili sigām. ");
INSERT INTO sml_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Manjari itu, pagpole' saga kabudjangan itu ni si Jetro ya mma' sigām, tinilaw sigām. Yukna, “Al'kkas pahāp kam at'kka llaw itu! Angay bahā'?” ");
INSERT INTO sml_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ya sambung saga anakna, “Sabab kami bay tinabangan e' dakayu' a'a Misil pagka kami nila'at e' saga a'a magi'ipat bili-bili. Lāgi, sinaukan kami bohe' e'na maka bay pinainum e'na saga kambing maka bili-bilitam.” ");
INSERT INTO sml_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ya lling matto'a he', “Maingga na iya? Angay iya pasagaranbi mahē'? Ngā'unbi iya pehē' bo' magsalu maka kitam.” ");
INSERT INTO sml_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Na, kasulutan si Musa maglahat maina'an, ati pinapagā' iya e' si Jetro maka anakna si Sippura. ");
INSERT INTO sml_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","At'ggol-t'ggol pa'in, anganak l'lla si Sippura. Gersom ya pangōn si Musa ma iya, sabab yukna, “Aku itu a'a liyu ma ngga'i ka lahatku.” ");
INSERT INTO sml_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Palabay pa'in daka pilantahun, amatay na sultan Misil e'. Malaingkan bangsa Isra'il masi du magaruhuy ma sabab pamanyaga' bangsa Misil ma sigām. Angandahing na pa'in sigām ni Tuhan bang pa'in sigām tinabangan. ");
INSERT INTO sml_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Jari takale e' Tuhan pangandahing sigām. Nientom e'na bay paljanji'anna ma disi Ibrahim, si Isa'ak maka si Yakub, ya pag'mbo'an sigām. ");
INSERT INTO sml_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ta'nda' isab e' Tuhan kabinasahan sigām ati kina'ase'an sigām e'na. ");
INSERT INTO sml_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Na aniya' waktu kapangipat si Musa ma saga kambing maka bili-bili mato'ana si Jetro, ya imam ma lahat Midiyan. Binowa e'na ba'anan hayop e' pauntas ni dambila' lahat paslangan. Jari pasampay iya ni Būd Horeb, ya pinagōnan isab Būd Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Maina'an pa'in, magpa'nda' ni si Musa mala'ikat si Yawe min t'ngnga' po'on kayu areyo', magpasalupa api asuleyab. Pag'nda' si Musa ma po'on kayu inān halam atunu' minsan arokot, ");
INSERT INTO sml_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","amikil-mikil gi' iya, yukna, “Oy! Pabidda' pahāp po'on kayu itu, asuleyab sagō' halam atunu'. Angay bahā'? Sekotku gi' bo' lilingku.” ");
INSERT INTO sml_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Na, pag'nda' PANGHŪꞋ-Yawe ma si Musa pasekot pehē' angaliling, magtūy nilinganan e'na min deyom po'on kayu he'. Yukna, “Musa, O Musa!” Anambag si Musa yukna, “Oy, itiya' aku.” ");
INSERT INTO sml_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yuk Tuhan, “Da'a ka pasekot pi'itu. La'anin taumpa'nu, sabab mahasussi tana' ya pan'nggehannu ilu.” ");
INSERT INTO sml_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ah'lling gi' iya yukna, “Aku itu Tuhan ya pagtuhanan ka'mbo'-mbo'anbi si Ibrahim, si Isa'ak maka si Yakub.” Takale pa'in e' si Musa, magtūy tampananna baihu'na sabab tināw iya patampal ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Angallam lagi' PANGHŪꞋ yukna, “Ta'nda'ku kabinasahan ya kalabayan saga a'a suku'ku maina'an ma Misil. Takaleku isab pangandahing sigām ma sabab saga a'a ya amanyaga' sigām. Aho', asusa isab aku ma pasal kabinasahan sigām. ");
INSERT INTO sml_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Angkan na aku makatulun pi'itu amuwasan sigām min komkoman saga bangsa Misil. Bowaku sigām paluwas min deyom lahat Misil tudju ni lahat ahāp maka aluha, ap'nno' isab e' kalluman landu' ahāp. Lahat itu kapaglahatan asal e' bangsa Kana'an, bangsa Hīt, bangsa Amor, bangsa Pirissi, bangsa Hīb maka bangsa Jibus.” ");
INSERT INTO sml_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ah'lling gi' Tuhan yukna, “Itiya' pasampay ni aku pangandahing bangsa Isra'il. Ta'nda'ku isab paminasa saga bangsa Misil ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Angkan ka soho'ku pehē' ni Pira'un bo' supaya ka amowa saga a'aku bangsa Isra'il paluwas min lahat Misil. Na, pehē' na ka.” ");
INSERT INTO sml_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Sagō' aniya' pah'lling si Musa ma Tuhan, yukna, “Ya Tuhanku, sai sa aku itu, ya angkan aku soho'nu paharap ni Pira'un amowa bangsa Isra'il paluwas min lahat Misil?” ");
INSERT INTO sml_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Anambung Tuhan yukna, “Tantu du aku anehe'an ka'a. Buwananta ka paltanda'an supaya ka makata'u in aku bay anoho' ka'a. Jari bang tabowanu na saga a'aku paluwas min lahat Misil, anumba du kam ni aku ma būd itu.” ");
INSERT INTO sml_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Yuk si Musa ni Tuhan, “Bang aku saupama pehē' ni saga a'a Isra'il bo' haka'anku sigām, ‘In Tuhan pagtutuhanan saga ka'mbo'-mbo'anbi bay anoho' aku pi'ilu ni ka'am.’ Na bang aku ganta' tinilaw e' sigām bang sai ōn Tuhan ya bay anoho' aku, ai bahā' panambungku ma sigām?” ");
INSERT INTO sml_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Anambag Tuhan ma si Musa, yukna, “Aku itu si Yawe, ya Tuhan-asal-Tuhan. Ya pah'llingnu ma saga a'a Isra'il subay buwattitu, ‘Tuhan-asal-Tuhan bay anoho' aku pi'itu ni ka'am.’ ” ");
INSERT INTO sml_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Aniya' gi' pah'lling Tuhan ma si Musa. Sinō' iya angahaka'an saga a'a Isra'il in si Yawe, ya pagtuhanan disi Ibrahim, si Isa'ak maka si Yakub, bay anoho' iya ni sigām. Yuk Tuhan isab, “Si Yawe ya ōnku salama-lama, ōn panabbutan aku e' saga a'a Isra'il magpangkat-mamangkat. ");
INSERT INTO sml_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Pehē' na ka,” yuk Tuhan ni si Musa, “patimukun saga pagmatto'ahan bangsa Isra'il bo' ka amissala ma sigām. Yuknu, ‘Bay magpanyata' ni aku si Yawe, ya pagtuhanan ka'mbo'-mbo'antam si Ibrahim, si Isa'ak maka si Yakub. Aheya pagka'inagonna ma ka'am, maka ta'nda'na isab paminjala' saga bangsa Misil ma ka'am. ");
INSERT INTO sml_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ya he' sababna angkan iya anganjanji' ma ka'am, in ka'am lappasan min deyom katiksa'an ya kalabayanbi ilu ma lahat Misil. Binowa kam e'na ni lahat ahāp, lahat ap'nno' e' kalluman landu' ahāp. Ya na paglahatan saga bangsa Kana'an, bangsa Hīt, bangsa Amor, bangsa Pirissi, bangsa Hīb maka bangsa Jibus.’ ” ");
INSERT INTO sml_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Yuk Tuhan isab ma si Musa, “Bin'nnal bissalanu e' saga pagmatto'ahan a'a Isra'il. Subay ka magbeya' maka sigām paharap pehē' ni sultan Misil. Ya yukbi ma iya, ‘Tuwan sultan, si Yawe, ya pagtuhanan kami bangsa Hibrani, bay magpakilā di-na ni kami. Manjari itiya' kami ama'id min ka'a pehē' ni lahat paslangan t'llung'llaw t'ggolna. Magkulban kami ni si Yawe ya pagtuhanan kami.’ ");
INSERT INTO sml_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Sagō',” yuk Tuhan ma si Musa, “kata'uwanku asal, in sultan bangsa Misil inān mbal amatugut, luwal bang tananamna kasangat kawasaku. ");
INSERT INTO sml_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Angkan subay pa'nda'ku kawasaku amat'kka saga bala' makatāw-tāw ma bangsa Misil. Pagubus, tinugutan du kam pal'ngngan paluwas min lahat. ");
INSERT INTO sml_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Palunukku du isab pangatayan saga a'a Misil ni ka'am bangsa Isra'il,” yuk Tuhan. “Jari aniya' pangalta' tabowabi bang kam paluwas na min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Saga d'nda Isra'il kamemon subay angamu' alta' min saga kar'ndahan Misil, ai-na ka d'nda ma kauman, ai-na ka d'nda paokom ma luma' sigām. Jari ya pamulawan maka s'mmek pamuwan sigām subay pinasulug ma ka'anakanbi d'nda-l'lla. Minnē' tabowabi pangalta' bangsa Misil bang kam magla'anan min lahat e'.” ");
INSERT INTO sml_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Anambung si Musa ma Tuhan yukna, “Painay bang mbal magkahagad saga a'a Isra'il maka mbal isab angasip ma pangahakaku? Bang saupama yuk sigām ma aku, ‘Ē, mbal kami magkahagad in PANGHŪꞋ-Yawe bay magpanyata' ni ka'a!’ ” ");
INSERT INTO sml_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Na, atilaw PANGHŪꞋ ma si Musa yukna, “Ai ma tangannu ilu?” “Tungkud,” yuk sambung si Musa. ");
INSERT INTO sml_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ah'lling gi' PANGHŪꞋ yuk-i, “Hantakin ni tana'.” Paghantakna pa'in, tahinang sowa ya bay tungkud e'. Magtūy alahi si Musa. ");
INSERT INTO sml_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Magpanoho'an gi' PANGHŪꞋ ma iya, “Abutun sowa ilu maka tangannu. Ntanin ma togelna.” Jari niabut sowa e' si Musa bo' ni'ntanan. Magtūy tahinang tungkud pabalik. ");
INSERT INTO sml_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ah'lling lagi' PANGHŪꞋ, yukna, “Hinangun buwattilu ma saga a'a Isra'il supaya sigām makapam'nnal in ka'a bay pinagpanyata'an e' si Yawe, ya pagtuhanan saga ka'mbo'-mbo'anbi si Ibrahim, si Isa'ak maka si Yakub.” ");
INSERT INTO sml_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Pagubus, yuk PANGHŪꞋ ma si Musa, “Pasōrun dambila' tangannu ni deyom badju'nu.” Magtūy pinasōd e'na. Pagpaluwasna pa'in, na, kinamuti' tanganna, makalandu' apote'. ");
INSERT INTO sml_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yuk Tuhan isab, “Pasōrun pabīng.” Magtūy pinasōd pabīng ni deyom badju'na. Pagpaluwasna pa'in, kauli'an tanganna, al'ssin na buwat bay ka'ina tagna'. ");
INSERT INTO sml_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Sagō',” yuk PANGHŪꞋ, “bang sigām saupama mbal am'nnal ma bissalanu, maka mbal isab kamattanan ma tungkud bay tahinang sowa, kalu sigām tabowa am'nnal bang ka makahinang paltanda'an karuwana itu. ");
INSERT INTO sml_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Malaingkan, bang sigām mbal am'nnal ma paltanda'an duwa hekana ya bay tahinangnu, maka mbal isab am'nnal ma bissalanu, na, anauk ka bohe' min sapa' Nīl bo' bu'usin ni tana'. Pagbu'usnu, bohe' ilu tahinang laha'.” ");
INSERT INTO sml_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Sagō' ya lling si Musa ma si Yawe, “Ya Panghū'ku, aku itu,” yukna, “min kariki'-diki'ku sampay ni waktu kapamissalanu itu ma aku, halam aniya' kapandayanku amissala ma mairan. Alallay e'ku ah'lling, tamamang aku.” ");
INSERT INTO sml_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Magsuwala lagi' PANGHŪꞋ, yukna, “Sai ya angahinang bowa' manusiya'? Sai isab amaumaw maka sai amabisu? Sai amuwan pang'nda' maka sai amabuta? Luwal aku, si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Angkan ka soho'ku pehē'. Tabanganta ka amissala, maka pandu'anta ka bang ai subay pah'llingnu.” ");
INSERT INTO sml_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Sagō' angamu' lagi' si Musa, yukna, “Ndū', Panghū'ku, bang makajari amiha na ka a'a saddī soho'nu.” ");
INSERT INTO sml_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Pagka buwattē' sambung si Musa, akagit atay PANGHŪꞋ-Yawe ma iya. Yukna, “Bang bahā' danakannu si Harun ya tubu' si Libi? Kata'uwanku in iya apanday magbissala. Ilu na iya ma labayan tudju pi'itu anampang ka'a. Akōd du iya pag'nda'na ma ka'a. ");
INSERT INTO sml_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Bowahun iya magsuli-suli. Pata'uhun iya bang ai subay pamissalana, sabab iya ya ganti'nu amissala ma kaheka'an saga a'a Isra'il. Hatina in iya sali' sapantun bowa'nu amissala, maka ka'a ya sapantun pagtuhananna. Tabanganta kam karuwangan magbissala maka pandu'anta kam bang ai subay hinangbi. ");
INSERT INTO sml_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bowahun tungkudnu ilu pangahinangnu saga paltanda'an makainu-inu ma saga a'a.” Ya na ina'an pamalman Tuhan ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Puwas e', amole' na si Musa pehē' ni mato'ana si Jetro bo' ama'id min iya. “O Bapa',” yukna, “dūlin lagi' aku pabīng ni lahat Misil ang'nda' saga kampungku bang sigām allum lagi'.” Magtūy iya pinaba'id e' si Jetro, yukna, “Aho', pehē' na ka. Bang pa'in ka mura-murahan asalamat.” ");
INSERT INTO sml_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Manjari itu, hinabu lagi' si Musa ma lahat Midiyan, aniya' bay pangallam PANGHŪꞋ-Yawe ma iya, yukna, “Pabalik ka pehē' ni Misil, sabab wa'i na magpatayan saga a'a kamemon ya bay arak amapatay ka'a.” ");
INSERT INTO sml_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Angkan pinasakat e' si Musa h'ndana maka duwangan anakna ni kura' bo' yampa sigām pauntas tudju ni lahat Misil. Binowa isab e'na tungkud ya bay min Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Magsuwala PANGHŪꞋ ma si Musa pabīng yukna, “Pagt'kkanu ni Misil, subay ka angahinang ma matahan Pira'un saga hinang makainu-inu kamemon ya bay pamahinangku ma ka'a. Hinangun min kawasa bay pamuwanku ka'a. Sagō' patuwasku kōk Pira'un bo' mbal tugutanna saga a'a Isra'il paluwas min Misil. ");
INSERT INTO sml_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Pagka buwattē', subay pasampaynu lapal itu ni Pira'un. Yuknu ma iya, ‘Palman itu bay min si Yawe. In bangsa Isra'il sapantun anakna l'lla kasiyakahan. ");
INSERT INTO sml_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Bay ka soho'na anugutan sigām paluwas min lahatnu supaya sigām makapagpudji ma iya. Sagō' mbal ka bilahi, angkan papatayna anaknu l'lla kasiyakahan.’ ” Ya du ina'an lapal ya sinō' pinasampay ni Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Na, ma paghanti'an pa'in disi Musa hinabu sigām pal'ngngan tudju ni Misil, niharap iya e' si PANGHŪꞋ. Arak bin'kkat nyawana, ");
INSERT INTO sml_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","daipara h'ndana si Sippura bay angā' batu atalom bo' yampa angislam anakna l'lla. Pagubus, ya kuwit bay niutas e' pina'abut e' si Sippura ni tape' h'llana. Ya llingna ma si Musa, “B'nnal to'ongan, in ka'a h'llaku kapehē'an laha' du pa'in.” ");
INSERT INTO sml_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Angkan buwattē' pah'lling si Sippura ma sabab pagislam e'.) Manjari si Musa halam tainay e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Sakali aniya' panoho'an PANGHŪꞋ ma si Harun, yukna, “Pehē' ka ni lahat paslangan anampang danakannu si Musa mahē'.” Jari tasampang si Musa e' si Harun ma atag Būd Tuhan. Tasiyumna isab. ");
INSERT INTO sml_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Puwas e', nihaka'an si Harun e' si Musa pasal kamemon bay panoho'an ma iya e' PANGHŪꞋ subay pinasampay ni Pira'un. Nihaka'an isab pasal saga paltanda'an makainu-inu ya pamahinang Tuhan ma iya. ");
INSERT INTO sml_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Pagt'kka si Musa maka si Harun ni lahat Misil, pinatimuk e' sigā saga pagmatto'ahan bangsa Isra'il kamemon. ");
INSERT INTO sml_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Pinata'u sigām e' si Harun pasal kamemon bay pangallam PANGHŪꞋ ma si Musa. Tahinang isab e'na saga paltanda'an ma matahan sigām, ");
INSERT INTO sml_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","manjari am'nnal na sigām. Makata'u pa'in sigām ma pasal aniya' pagka'inagon PANGHŪꞋ ma sigām, maka ma pasal pang'nda'na ma kabisa katiksa'an sigām, magtūy sigām pasujud anumba. ");
INSERT INTO sml_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Puwas e', paharap na si Musa maka si Harun pehē' ni Pira'un. Yuk sigā ma iya, “Tuwan sultan, ya na itu palman min si Yawe, ya pagtuhanan kami a'a Isra'il. Ya yuk Tuhan itu ma ka'a, ‘Tugutin saga a'aku paluwas ni lahat paslangan inān supaya sigām maghinang ma aku.’ ” ");
INSERT INTO sml_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Agsai anambung Pira'un, yukna, “Sai sa si Yawe? Angay iya subay beya'ku? Angay subay tugutanku saga a'a Isra'il paluwas min lahat itu? Mbal kata'uwanku si Yawe. Mbal isab tugutanku saga a'a Isra'il paluwas minnitu.” ");
INSERT INTO sml_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Yuk disi Musa maka si Harun, “Ya Tuhan kami bangsa Hibrani bay magpakilā di-na ma kami. Bang pa'in kami patugutannu pal'ngngan t'llung'llaw sadja ni lahat paslangan inān supaya kami makapagkulban ni si Yawe, ya Tuhan kami. Bang kami saupama mbal tugutannu, na, aniya' saki makapatay atawa bono' pinat'kka e' Tuhan ni kami.” ");
INSERT INTO sml_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Saguwā' ya panambung sultan Misil ma si Musa maka si Harun. “Angay bowabi saga pagkahibi Isra'il pahali maghinang tisa'? Pabīng kam ni hinangbi!” ");
INSERT INTO sml_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Aniya' gi' pah'lling Pira'un yukna, “Bistahun saga bangsa Hibrani ilu, aheka na makalandu', ati bowabi sigām ang'bba min hinang ya pamahinang sigām.” ");
INSERT INTO sml_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Manjari itu, ma llaw ina'an-i, aniya' panoho'an Pira'un ma saga a'a Misil magbabanyaga' maka saga a'a Isra'il ya pinat'nna' magkapatas. ");
INSERT INTO sml_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","Yuk panoho'an e', “In bangsa Isra'il angalisu' na maghinang, ya angkan sigām angamu' na pa'in subay paluwas min Misil itu bo' magkulban ni Tuhan sigām. Jari soho'ta kam da'a subay amuwanan sigām batang bay paganihan pangalamud sigām ma pisak ya nihinang tisa'. Puwas minnitu in sigām subay amiha'an di-sigām. Sagō' ya tisa' pamahinangbi ma sigām subay mbal kinulangan hekana minsan dansolag. ");
INSERT INTO sml_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Maka itu gi', ya pamahinangbi ma sigām subay gom pa'in pinabuhat min bay dahū supaya halam aniya' halian sigām, jari halam aniya' waktu sigām akale ma saga bissala kaputingan.” ");
INSERT INTO sml_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Manjari paluwas minnē' saga tag-soho'an ata maka saga kapatas Isra'il bo' magpasampay lapal sultan e' ni saga Isra'il kamemon. Yuk lling sigām, “Mbal na kam pinaniya'an batang bay paganihan pamapagon tisa'. ");
INSERT INTO sml_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Subay kam amiha'an di-bi na, maingga-maingga kapamiha'anbi. Malaingkan ya heka tisa' hinangbi subay mbal pakulang min bay tahinangbi tagna'.” ");
INSERT INTO sml_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Na pagka buwattē', alatag sakalibut lahat Misil e' saga a'a Isra'il pamiha'an sigām batang pangalamud sigām tisa'. ");
INSERT INTO sml_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nilogos na pa'in sigām e' saga a'a Misil tag-soho'an ata. Yuk-i, “Talusunbi hinang ya pamahinang ka'am kahaba' llaw minsan kam mbal na binuwanan batang.” ");
INSERT INTO sml_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Jari niraplosan na saga kapatas Isra'il e' saga tag-soho'an ata, maka tinilaw isab. Yuk sigām e', “Ya tisa' tahinangbi di'ilaw maka llaw itu akulang hekana min bay hinangbi tagna'. Angay bahā'?” ");
INSERT INTO sml_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Pagubus, pehē' magtūy saga kapatas Isra'il mikitabang ma Pira'un ma pasal palkala' itu. Yuk sigām, “Tuwan sultan, angay buwattitu hinangnu ma kami saga sosoho'annu? ");
INSERT INTO sml_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Halam kami kabuwanan batang paganihan, sagō' masi-masi na pa'in kami sinoho' angahinang tisa'. Pinagdaplosan na pa'in kami parahāl ngga'i ka kami ya taga-sā'. Sagō' saga tendognu iya.” ");
INSERT INTO sml_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ya sambag sultan ma sigām, “Ē, lisu'an pahāp ka'am ilu! Ahuskaw kam maghinang, angkan du kam mbal pahali ama'id min aku subay tinugutan paluwas min Misil bo' magkulban ni si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pabalik kam pehē' ni kahinanganbi! Mbal kam binuwanan batang paganihan, sagō' ya heka tisa' tahinangbi subay mbal pakulang min bay dahū.” ");
INSERT INTO sml_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Takale pa'in panoho'an Pira'un itu e' saga kapatas Isra'il, magtūy tasayu in kasusahan sigām aheya to'ongan. Sinō' sigām angahinang tisa' llaw-llaw ma halam aniya' kulangna min bay tagna'. ");
INSERT INTO sml_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Na hinabu saga kapatas itu magla'anan min astana', tasampang e' sigām si Musa maka si Harun sabab bay maina'an asal angalagaran sigām. ");
INSERT INTO sml_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ah'lling saga kapatas e' ma si Musa maka si Harun, “Bang pa'in kam ni'nda' e' PANGHŪꞋ bo' kam tinungbasan e'na. Kinab'nsihan na kami e' Pira'un maka saga wakilna sabab min ka'am. Maka ka'am ya bay amuwanan sigām sababan amapatay kami.” ");
INSERT INTO sml_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Magtūy pabīng si Musa paharap ni PANGHŪꞋ-Yawe, yukna, “O Panghū'ku, angay tat'kkanu kasusahan ma bangsa kami itu? Ai maksudnu ya angkan aku soho'nu pi'itu? ");
INSERT INTO sml_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sampay min waktu kapehē'ku ni Pira'un amasampay lapalnu, mbal iya pahali aminjala' saga bangsa Isra'il itu. Halam isab aniya' panabangnu ma saga a'a suku'nu minsan dangkuri'.” ");
INSERT INTO sml_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Magtūy anambung PANGHŪꞋ ma si Musa yukna, “Sōng na ta'nda'nu bang ai hinangku ma Pira'un. Min kosog kawasaku, ya angkan iya anugutan saga a'a Isra'il paluwas. Aho', min kosog kawasaku ya angkan sigām tin'ggal e'na pala'an min lahatna.” ");
INSERT INTO sml_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Amalman gi' Tuhan ma si Musa, yukna, “Aku si Yawe, ya Tuhan-asal-Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Bay aku magpakilā di-ku ma disi Ibrahim, si Isa'ak maka si Yakub, in aku Tuhan Sangat-Kawasa. Sagō' ōnku Yawe halam bay pata'uku ma sigām ma waktu ina'an-i. ");
INSERT INTO sml_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Bay pat'nna'ku isab paljanji'anku ma sigām t'llungan. Yukku in sigām subay pinasuku'an lahat Kana'an, ya lahat bay paglihanan sigām. ");
INSERT INTO sml_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Na,” yuk Tuhan, “takaleku na pagaruhuy saga a'a Isra'il ya tahinang ata ilu e' bangsa Misil. Entomku isab paljanji'an bay pat'nna'anku sigām. ");
INSERT INTO sml_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Angkan ka soho'ku amasampay lapalku itu ma sigām. Buwattitu ya pah'llingnu ma sigām deyo' min aku, ‘Aku itu si Yawe ya Tuhan-asal-Tuhan, jari paluwasku ka'am min kasigpitan ya pamasigpit ka'am e' bangsa Misil. Aku ya angalappas ka'am min deyom pamanyaga'an. Aku ya angal'kkat ka'am min pang'ntanan saga a'a Misil pagka patuwa'ku na kosog kawasaku maka mulka'ku landu' abisa. ");
INSERT INTO sml_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ka'am ya tahinangku bangsa suku'ku, maka aku ya Tuhanbi. Jari makata'u du kam sab'nnal-b'nnal in aku si Yawe ya Tuhanbi, bang kam kalappasanku na min komkoman saga bangsa Misil. ");
INSERT INTO sml_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Bowata du kam,’ yukna, ‘pehē' ni lahat bay panganjanji'ku tuman ma saga ka'mbo'-mbo'anbi disi Ibrahim, si Isa'ak maka si Yakub. Buwananta kam lahat inān palsuku'anbi. Aku itu si Yawe.’ ” ");
INSERT INTO sml_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ya du ilu lapal Tuhan bay panganasihat si Musa ma saga bangsa Isra'il, sagō' halam iya kinale e' sigām. Tu'ud asukkal pangatayan sigām pagka halam aniya' pangasa-ngasa sigām pinaluwas min pamanyaga'an ab'ngngis makalandu'. ");
INSERT INTO sml_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Sakali itu angallam PANGHŪꞋ-Yawe pabalik ni si Musa, yukna, ");
INSERT INTO sml_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pehē' ka, haka'in sultan Misil in iya subay anugutan saga bangsa Isra'il paluwas min lahatna.” ");
INSERT INTO sml_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Sagō' anambung si Musa ma PANGHŪꞋ, yukna, “Akale bahā' Pira'un ma aku? Minsan saga pagkahiku bangsa Isra'il mbal akale pagka halam aniya' ta'uku amissala.” ");
INSERT INTO sml_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Malaingkan angalogos gi' PANGHŪꞋ ma si Musa maka si Harun. Kinallaman sigā subay amasampay lapalna ni saga a'a Isra'il sampay ni sultan Misil, hatina in sigā duwangan sinō' amowa bangsa Isra'il paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ya na itu saga a'a pagnakura'an bangsa Isra'il, tinagna'an min tumpuk si Rubin sampay ni tumpuk si Libi. Dahū si Rubin, ya anak aymulla Yakub siyaka. Mpat anakna l'lla, si Hanok, si Pallu, si Hesdon maka si Karmi. Buwattē' isab ōn saga tumpuk ya panubu' min si Rubin. ");
INSERT INTO sml_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Pasunu' si Simiyun ya anak si Yakub karuwana. Saga anak si Simiyun l'lla si Jamuwal, si Jamin, si Ohad, si Jakin, maka si Sohar. Katapusan si Sa'ul anak d'nda bangsa Kana'an. Buwattē' isab ōn saga tumpuk ya panubu' min si Simiyun. ");
INSERT INTO sml_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Pasunu' isab si Libi. Saga anakna l'lla si Gerson, si Kohat maka si Merari. Awapat pa'in si Libi, umulna dahatus maka t'llumpū' maka pituntahun. ");
INSERT INTO sml_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Si Gerson, duwa anakna l'lla, ōnna si Libni maka si Simi. Buwattē' isab ōn tumpuk ya panubu' min iya. ");
INSERT INTO sml_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Si Kohat, aniya' mpat anakna l'lla. Ōn sigām si Imran, si Isahar, si Hebron maka si Usil. Na, awapat pa'in si Kohat, umulna dahatus maka t'llumpū' maka t'lluntahun. ");
INSERT INTO sml_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Si Merari, duwa anakna l'lla, ōn sigām si Mali maka si Musi. Ya du ina'an saga tumpuk panubu' si Libi, bang sinalsila isab. ");
INSERT INTO sml_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Si Imran (mpu si Libi) bay makah'nda ni danakan mma'na, ōnna si Jokebet. Duwa anak si Imran min si Jokebet itu, ya na si Harun maka si Musa. Awapat pa'in si Imran, umulna dahatus maka t'llumpū' maka pituntahun. ");
INSERT INTO sml_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Si Isahar, t'llu anakna l'lla, ōn sigām disi Kora, si Nepeg maka si Sikri. ");
INSERT INTO sml_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Si Usil isab, t'llu anakna l'lla, ōn sigām si Misail, si Elsapan, maka si Sitri. ");
INSERT INTO sml_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Manjari si Harun bay makah'nda ni si Eleseba, anak si Aminadab maka danakan isab si Nason. Taga-anak sigām mpat l'lla, ya na si Nadab, si Abihu, si Eleyasar maka si Itamar. ");
INSERT INTO sml_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Si Kora (anak si Isahar) taga-anak l'lla, ya na si Assir, si Elkana maka si Abiyasap. Ya ina'an isab ōn saga tumpuk panubu' si Kora. ");
INSERT INTO sml_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleyasar anak si Harun bay makah'nda ni dakayu' anak si Putil. Si Pinihas ya anakna. Na, iya na ina'an ōn saga a'a ya pag'mbo'an ba'anan saga tumpuk kapanubu'an si Libi. ");
INSERT INTO sml_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Na, in si Harun maka si Musa ya sinalsilahan itu, ya na a'a bay kawakilan e' PANGHŪꞋ-Yawe sinō' amowa saga a'a Isra'il magtumpuk-manumpuk paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Sigām duwangan itu bay amasampay lapal Tuhan ni Pira'un, hatina sultan Misil, pasal bangsa Isra'il subay tugutanna paluwas min Misil. ");
INSERT INTO sml_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Manjari itu, ma waktu kapah'lling PANGHŪꞋ ma si Musa mahē' lagi' ma Misil, ");
INSERT INTO sml_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","buwattitu pah'llingna, “Aku si Yawe, ya Tuhan-asal-Tuhan. Pasampayun ni sultan Misil kamemon pangahakaku itu ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Sagō' ya sambung si Musa ma PANGHŪꞋ, “Akale bahā' Pira'un ma aku? Sali' aku tamamang bang amissala?” ");
INSERT INTO sml_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Anambung PANGHŪꞋ-Yawe ma si Musa, yukna, “Musa, hinangta ka buwat ibarat tuhan ma pang'nda' Pira'un. Maka siyakanu si Harun isab ibarat nabi ya soho'nu amaluwas lapalnu. ");
INSERT INTO sml_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Pata'uhun si Harun ai-ai kamemon ya pangallamku ma ka'a, ati iya ya amasampay panoho'anku ni Pira'un, in saga a'a Isra'il subay tugutanna paluwas min lahatna. ");
INSERT INTO sml_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Sagō' patuwasku kōk Pira'un. Jari minsan pat'kkaku saga bala' makatāw-tāw pila-pila hekana ma lahat Misil, ");
INSERT INTO sml_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","mbal iya akale ma ka'am. Buwattē' pa'in, pananamanku iya kosog kawasaku. Pat'kkaku mulka' ma lahat Misil bo' bowaku paluwas minnē' saga a'aku bangsa Isra'il magtumpuk-manumpuk. ");
INSERT INTO sml_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Pagnanam saga a'a Misil ma kawasaku, magtūy kinata'uwan e' sigām in aku si Yawe ya Tuhan-asal-Tuhan bang pat'kka na mulka'ku ni lahat sigām, maka bang paluwasku na saga a'a Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Na, tahinang e' si Musa maka si Harun kamemon bay panoho'an PANGHŪꞋ ma sigā. ");
INSERT INTO sml_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Manjari ma waktu kapaharap sigā ma Pira'un walumpū' tahun na umul si Musa, maka si Harun walumpū' maka t'lluntahun umulna. ");
INSERT INTO sml_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Sakali itu, ah'lling gi' Tuhan ma sigā karuwangan, yukna, ");
INSERT INTO sml_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Bang kam saupama tinukas e' Pira'un subay maghinang saga hinang makainu-inu, soho'un si Harun angahantak tungkudna ma dahuan sultan-i bo' tahinang sowa.” ");
INSERT INTO sml_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Jari pehē' na si Musa maka si Harun paharap ni Pira'un ati tahinang e' sigā bay panoho'an si Yawe ma sigā. Kahantakan e' si Harun tungkudna ma dahuan Pira'un maka saga wakilna ati tahinang sowa magtūy. ");
INSERT INTO sml_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pag'nda' Pira'un, pinalinganan e'na saga a'ana ilmu'an maka saga a'a ata'u maghinang-hinang. Jari tahinang e' sigām buwat bay tahinang si Harun e', pagka ginuna ilmu' sigām. ");
INSERT INTO sml_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Paghantak sigām saga tungkud sigām magkaniya-kaniya, manjari tahinang sowa, sagō' tin'llon ba'anan tungkud sigām e' tungkud si Harun. ");
INSERT INTO sml_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Malaingkan minsan buwattē', masi na pa'in magmatuwas kōk Pira'un. Mbal to'ongan pakale ma disi Musa, buwat bay pangahaka asal e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Sakali itu, angallam PANGHŪꞋ-Yawe ma si Musa pabīng, yukna, “Atuwas na kōk Pira'un. Mbal to'ongan tugutanna saga bangsa Isra'il paluwas min lahatna. ");
INSERT INTO sml_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Angkan ka subay paharap ni iya salung subu, hinabuna palūd ni sapa' Nīl. Lagarin iya maina'an. Bowahun isab tungkud bay tahinang sowa ilu. ");
INSERT INTO sml_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Makasampang pa'in ka ni Pira'un, subay buwatittu pangahakanu ma iya, yuknu, ‘Si Yawe, ya Tuhan bangsa Hibrani, bay anoho' aku amasampay llingna ma ka'a. Sinō' ka anugutan saga a'a suku'na paluwas min Misil itu bo' maghinang ni iya ma lahat paslangan. Saguwā' halam tabeya'nu panoho'anna itu sampay ni kabuwattituhan.’ ");
INSERT INTO sml_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Manjari ya na itu pamalman si Yawe ma ka'a, yukna, ‘Kamattanan ka in aku Tuhan-asal-Tuhan ma sabab paltanda'an ya hinangku itu. T'bba'anku bohe' sapa' Nīl maka tungkud ya balutanku itu. Jari tahinang laha' bohe'na. ");
INSERT INTO sml_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Amatay ba'anan karaingan ma deyom sapa'. Bauwan isab, mbal tainum bohe'na.’ ” ");
INSERT INTO sml_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yuk PANGHŪꞋ isab ma si Musa, “Soho'un si Harun amabantang tungkudna tampal ni kabohe'-bohe'an Misil kamemon, ai-na ka kasapa'-sapa'an, ai-na ka saga bohe' kali. Manjari in bohe' kamemon ma kaluha'an lahat Misil tahinang laha', sampay bohe' ma deyom ba'anan pangisihan.” ");
INSERT INTO sml_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Na, tahinang e' si Musa maka si Harun bay panoho'an PANGHŪꞋ ma sigā. Tapabantang e' si Harun tungkudna ma matahan Pira'un maka saga wakilna ati t'bba'na bohe' sapa' Nīl. Manjari laha' na kabohe'-bohe'an kamemon. ");
INSERT INTO sml_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Magkamatay lullun saga daing bay ma deyom sapa' e' ati abau sidda, angkan mbal tainum bohe'na e' bangsa Misil. Jari laha' sadja minsan maingga-maingga ma sakalingkal lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Sagō' bineya'an hinang disi Harun e' saga a'a Misil ilmu'an pagka ginuna pangilmu' sigām. Magmatuwas na pa'in kōk Pira'un buwat bay pah'lling PANGHŪꞋ ma pasalna. Mbal to'ongan iya pakale ma si Musa maka si Harun. ");
INSERT INTO sml_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Halam tapagmagayna kahālan ina'an-i, gom pa'in iya pataikut min sigā bo' pasōd ni deyom astana'. ");
INSERT INTO sml_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Saguwā' saga a'a Misil kamemon bay magkali saga lowang ma bihing sapa' Nīl inān pangā'an sigām bohe' ni'inum, sabab bohe' sapa' inān mbal to'ongan tainum. ");
INSERT INTO sml_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Na palabay gi' pitung'llaw min bay pagmulka' PANGHŪꞋ-Yawe ma sapa' Nīl. ");
INSERT INTO sml_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Manjari angallam PANGHŪꞋ-Yawe ma si Musa pabalik, yukna, “Pehē' ka ni Pira'un amasampay lapalku itu ma iya. Yuknu, ‘Ya na itu pamalman si Yawe ma ka'a, tugutin saga a'aku paluwas ni lahat paslangan supaya sigām makapagsumba ma aku. ");
INSERT INTO sml_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Bang ka mbal, pagmulka'anku du lahatnu kamemon, aliput e' ambak. ");
INSERT INTO sml_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Angulatap saga ambak aheka to'ongan ma sapa' Nīl. Patukad minnē' bo' pasōd ni deyom astana'nu maka ni deyom bilik patulihannu, bo' pariyata' isab ni pabahakannu. Pasōd isab ni kaluma'an saga a'a pangandolannu maka kaluma'an saga a'anu kamemon. Saga pam'llahanbi maka pagaddunanbi tinapay, sinōd du e' ambak. ");
INSERT INTO sml_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ka'a barannu maka baran saga a'a pangandolannu sampay saga a'anu kamemon kapaglaksu-laksuhan e' saga ambak.’ ” ");
INSERT INTO sml_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Angallam gi' PANGHŪꞋ ma si Musa, yukna, “Soho'un si Harun amabantang tungkudna paharap ni saga kasapa'-sapa'an maka ni kamemon saga pagbohe'an bo' supaya patukad ba'anan ambak angaliput kaluha'an lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Na pinabantang e' si Harun tungkudna paharap ni kabohe'-bohe'an kamemon ati paluwas ba'anan saga ambak angaliput kaluha'an lahat inān. ");
INSERT INTO sml_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Sagō' bineya'an hinang si Harun itu e' saga a'a Misil ata'u maghinang-hinang pagka ginuna pangilmu' sigām. Tabowa isab saga ambak paluwas min deyom sapa' tudju ni gintana'an. ");
INSERT INTO sml_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Sakali pinalinganan si Musa maka si Harun e' Pira'un. Pagt'kka pa'in, yukna ma sigā, “Amu'-amu'inbi aku ni si Yawe bang pa'in la'ananna ba'anan ambak itu. Jari tugutanku saga a'abi paluwas supaya kam makapagkulban tudju ni Tuhanbi si Yawe.” ");
INSERT INTO sml_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ya sambung si Musa, “Tuwan sultan, ka'a ya pinagbaya' bang sumiyan waktu ya pangamu'ku duwa'a ma kahālanbi, hatina ma ka'a barannu, ma saga a'a pangandolannu, sampay ma saga a'anu kamemon. Bang buwattē' halam na aniya' ambak takapin ma deyom kaluma'anbi, luwal maina'an ma deyom sapa' Nīl.” ");
INSERT INTO sml_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Yuk Pira'un, “Salung.” Anambung si Musa, “Abeya' pagkallamnu, bo' kata'uwannu halam aniya' tuhan makasali' ni si Yawe ya Tuhan kami. ");
INSERT INTO sml_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Pagsalung ala'an saru'un-du'un saga ka'ambakan min ka'a maka min saga luma'bi, min saga a'a pangandolan maka min saga a'a suku'nu kamemon. Halam aniya' takapin luwal ma deyom sapa' Nīl ilu.” ");
INSERT INTO sml_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Makala'an pa'in si Musa maka si Harun min astana' Pira'un, magtūy angamu' junjung si Musa ni PANGHŪꞋ bang pa'in la'ananna saga ambak bay pamat'kkana ma Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Jari nirūlan e' PANGHŪꞋ pangamu'-ngamu' si Musa itu. Amatay na saga ambak kamemon, ai-na ka ma deyom kaluma'an, ai-na ka ma halaman, ai-na ka ma saga kahuma'an. ");
INSERT INTO sml_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Pinagtumpuk-tumpuk patay ambak inān e' saga a'a Misil, jari angahangsu katilibut lahat Misil e' bau patay ambak. ");
INSERT INTO sml_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Sakali, pag'nda' Pira'un in kahālan sigām pagām-gām na, agsai magmatuwas kōkna pabīng. Mbal na pakale ma disi Musa, buwat bay pangallam asal e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Pagubus ina'an, angallam PANGHŪꞋ-Yawe pabīng ma si Musa, yukna, “Soho'un si Harun angahantak tōng tungkudna ni bagunbun, ati bagunbun inān tahinang hanglop ma sakalingkal lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Magtūy nihantakan e' si Harun tōng tungkudna ni bagunbun e', ati in bagunbun kamemon ma katilibut Misil tahinang hanglop na. Manjari kapilahan e' hanglop saga manusiya' kamemon maka kahayopan kamemon. ");
INSERT INTO sml_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pasulay isab saga a'a Misil ilmu'an magpaniya' hanglop luwas min ilmu' sigām, sagō' mbal makakole'. Manjari hanglop angulatapan na pa'in ni manusiya' maka ni hayop. ");
INSERT INTO sml_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ah'lling saga a'a ilmu'an inān ma Pira'un, yuk sigām, “Halam pagduwa-ruwana, min kawasa Tuhan ko' itu.” Sagō' Pira'un iya masi magmatuwas kōkna. Mbal to'ongan pakale ma disi Musa, buwat bay pangallam PANGHŪꞋ ma pasalna. ");
INSERT INTO sml_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Puwas e', angallam PANGHŪꞋ ma si Musa pabīng, yukna, “Salung subu, dai' llaw lagi', papunduk ka angaharap Pira'un hinabuna palūd ni sapa' Nīl. Ya pah'llingnu ma iya subay buwattitu, yuknu, ‘Ya na itu pamalman si Yawe ma ka'a. Sinō' ka anugutan saga a'aku paluwas min lahatnu supaya makapagsumba ma aku. ");
INSERT INTO sml_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Bang sigām saupama mbal paluwasnu, pat'kkaku ni ka'am saga ba'anan langaw patapu' ma ka'a, ma saga a'a pangandolannu sampay ma saga a'anu bangsa Misil kamemon. Ap'nno' e' langaw saga kaluma'anbi, aliput isab kuwit tana'. ");
INSERT INTO sml_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Malaingkan mbal lapayku jadjahan Gosen, ya lahat paglahatan saga a'a suku'ku. Halam du aniya' langaw angulapat maina'an, supaya kata'uwannu in aku si Yawe, itiya' ma deyom lahat itu. ");
INSERT INTO sml_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Papagbidda'ku saga a'aku maka saga a'anu. Subay na salung bo' tahinang paltanda'an makainu-inu itu.’ ” ");
INSERT INTO sml_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Manjari, aniya' ba'anan langaw aheka makalandu' pinarugpak e' PANGHŪꞋ ni astana' sultan maka ni kaluma'an saga a'a kawakilanna. Sa'agon-agon magka'at sakalibutan lahat Misil ma sabab langaw. ");
INSERT INTO sml_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Magtūy pinalinganan si Musa maka si Harun e' Pira'un pabalik. Pagt'kka pa'in, yukna ma sigā, “Pehē'un na, tukbalinbi pagkulban ni Tuhanbi, bang pa'in ma lahat itu-i.” ");
INSERT INTO sml_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","“Ā,” yuk si Musa, “mbal makajari. Ya hayop pagkulban kami ni si Yawe ya Tuhan kami, mbal apatut pinagkulban bang ma addatbi bangsa Misil. Jari bang kami maghinang kulban bo' asammal ma pang'nda' sigām, tantu kami binantung e' sigām pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Subay kami pal'ngngan ni lahat paslangan t'llung'llaw t'ggolna, bo' magsumbali' saga hayop pagkulban ni si Yawe, ya pagtuhanan kami. Sabab ya na ilu panoho'anna ma kami.” ");
INSERT INTO sml_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Yuk Pira'un, “Tugutanta du kam pehē' ni lahat paslangan bo' kam magtukbal hayop pagkulban ni si Yawe ya Tuhanbi. Sagō' da'a kam palawak minnitu. Amu'-amu'inbi isab aku duwa'a.” ");
INSERT INTO sml_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Anambung si Musa, yukna, “Pagluwasku min matahannu, amu'ku duwa'a magtūy ni si Yawe, bang pa'in magla'anan saga langaw ilu salung, min ka'a maka min saga a'a kawakilannu maka min saga a'anu kamemon. Sagō' da'a pa'in kami akkalin pabīng, da'a kami sagga'un pehē' maghinang kulban ni si Yawe.” ");
INSERT INTO sml_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Pagluwas pa'in si Musa min Pira'un, magtūy iya angamu' duwa'a ni PANGHŪꞋ-Yawe, ");
INSERT INTO sml_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ati nirūlan iya ma pangamu'na. Magla'anan na ba'anan langaw inān kamemon min sultan, min saga a'a kawakilanna maka min saga a'ana kamemon. Halam aniya' langaw takapin minsan dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Saguwā' minsan buwattē', masi magmatuwas kōk Pira'un ati halam katugutanna saga a'a Isra'il palanjal maghinang ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Na, angallam PANGHŪꞋ-Yawe ma si Musa pabalik. Sinoho' iya paharap ni Pira'un amasampay lapal deyo' bay min iya. Yuk lapalna he', “Ya na itu pamalman ka'a e' si Yawe, ya Tuhan bangsa Hibrani. Tugutin saga a'aku paluwas min lahatnu supaya sigām makapagsumba ma aku. ");
INSERT INTO sml_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Bang ka pasangdan na pa'in magin'mbal ati mbal tugutannu sigām, ");
INSERT INTO sml_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","na, pinagmulka'an lahatnu e' si Yawe min kosog kawasana. Aniya' musiba landu' abisa pamat'kkana ma saga kahayopanbi kamemon, hatina ma kura'bi, unta'bi, sapi'bi, kambingbi maka bili-bilibi. ");
INSERT INTO sml_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Sagō' pinapagbidda' e' si Yawe saga hayop bangsa Isra'il maka saga hayopbi bangsa Misil. Halam aniya' hayop palsuku'an bangsa Isra'il amatay minsan dakayu'.” ");
INSERT INTO sml_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jari aniya' waktu pangangganta' e' PANGHŪꞋ. “Subay na salung bo' pat'kkaku bala' inān,” yukna. ");
INSERT INTO sml_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Pagsalung pa'in, tahinang e' Yawe buwat bay pangallamna. Alaglag saga hayop bangsa Misil, sagō' halam aniya' amatay minsan dakayu' ma kahayop-hayopan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Sakali aniya' a'a sinoho' e' Pira'un atilaw bang ai kahālanna ma saga kauman bangsa Isra'il. B'nnal, halam aniya' hayop sigām amatay minsan dakayu'. Sagō' minsan buwattē', iya ya na pa'in magmatuwas kōk Pira'un. Mbal to'ongan anugutan saga a'a Isra'il paluwas. ");
INSERT INTO sml_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Puwas e', angallam PANGHŪꞋ pabīng ma si Musa maka si Harun, yukna, “Angakup kam abu min pagtunu'an bo' pinasabulakan pariyata' ma si Musa ma munda'an Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Manjari in abu ilu tahinang sali' bagunbun pasaplag ma kaluha'an lahat Misil. Maka sasuku kapakpakan bagunbun ilu, maingga-maingga pa'ataganna, manusiya' ka atawa hayop, taluwa' bautut paluwasan nana'.” ");
INSERT INTO sml_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Manjari itu, aniya' abu ta'akup e' sigā duwangan. Makaharap pa'in sigā pehē' ni Pira'un, sinabulakan e' si Musa tudju pariyata'. Magtūy aniya' bautut paluwasan nana' makataluwa' ni saga manusiya' maka ni kahayop-hayopan. ");
INSERT INTO sml_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Saga a'a Misil ya ata'u maghinang-hinang mbal makapagharap maka si Musa sabab ya du sigām aliput e' bautut, buwat saga a'a Misil kamemon. ");
INSERT INTO sml_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Saguwā' kōk Pira'un pinatuwas gom pa'in e' PANGHŪꞋ-Yawe. Mbal iya pakale ma si Musa maka si Harun, jari katumanan bay pangallam PANGHŪꞋ ma pasalna. ");
INSERT INTO sml_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Manjari angallam PANGHŪꞋ pabalik ma si Musa, yukna, “Salung subu, dai' llaw lagi', papunduk ka angaharap Pira'un. Ya llingnu ma iya subay buwattitu, yuknu, ‘Ya na itu pamalman ma ka'a e' si Yawe, ya Tuhan bangsa Hibrani. Yukna, tugutin saga a'aku paluwas min lahat itu supaya sigām makapagsumba ma aku. ");
INSERT INTO sml_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Bang sigām saupama mbal tugutannu, na tantu du aku amatumbuk mulka' lumandu'an bisana ma ka'a, ma saga a'a pangandolannu sampay ma saga a'anu bangsa Misil kamemon, bo' supaya kata'uwannu in aku Tuhan dakayu'-kayu', halam aniya' sibu'ku ma babaw dunya. ");
INSERT INTO sml_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Bang aku bay bilahi, bay du aku amat'kka musiba makalaglag ma ka'a maka ma saga a'anu kamemon, manjari halam aniya' takapin allum. ");
INSERT INTO sml_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Daipara halam bay kalanjalanku bala' ina'an. Ya angkan ka sabalanku magsultan sabab aheya maksudku ma ka'a. Ya kabaya'anku subay pama'nda'ku ma ka'a kosog kawasaku supaya patanyag ōnku ni manusiya' kamemon ma sakalibutan dunya. ");
INSERT INTO sml_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Malaingkan ka'a ilu mbal pahali anagga' saga a'aku, mbal isab anugutan sigām paluwas min lahatnu. ");
INSERT INTO sml_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Angkanna, pagsalung subu, ma waktu buwattē' du, paulananku tigtigan aes ma lahatnu. Sangay min katagna' bangsa Misil, halam bay aniya' ulan buwattē', yamboho'. ");
INSERT INTO sml_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Soho'un saga tendognu pasa'ut amasindung ba'anan hayopbi maka palsuku'anbi kamemon bay pat'nna' ma luwasan. Sabab ai-ai ta'bba ma luwasan, manusiya' ka atawa hayop, bang kaulanan e' tigtigan aes ilu, amatay sadja.’ ” ");
INSERT INTO sml_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Manjari saga sosoho'an Pira'un, sasuku tināw ma palman Tuhan, magdai'-dai' amasindung saga ata maka saga hayop sigām. ");
INSERT INTO sml_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Sagō' sasuku sigām anaikutan panoho'an PANGHŪꞋ, pinasagaran e' sigām ai-ai sigām ma luwasan, halam pinasindung. ");
INSERT INTO sml_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pagubus, yuk PANGHŪꞋ ma si Musa, “Pah'nnatun tangannu tudju ni langit bo' angulan tigtigan aes ni sakalingkal Misil, ni saga manusiya' maka ni saga hayop, sampay ni tinanom kamemon ya patomo' ma kahuma-huma'an mailu ma lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Pagangkat e' si Musa tungkudna paharap ni langit, magtūy aniya' l'ggon maka tigtigan aes pinatumbuk e' PANGHŪꞋ. Aniya' l'tte' isab pahūg ni kuwit tana'. Min PANGHŪꞋ ko' inān, ");
INSERT INTO sml_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ulan alandos to'ongan kalamuran aes, maka lāt isab min dambila' maka min dambila'. Yamboho' aniya' hunus buwattē' kosogna sangay min katagna' bangsa Misil. ");
INSERT INTO sml_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Taluwa' tigtigan aes saga manusiya' kamemon maka hayop kamemon ya halam tapasindung ma kaluha'an lahat Misil. Ah'bba' saga tinanom kamemon ma kahuma-huma'an, maka halam aniya' dahun kayu takapin, magka'at kamemon. ");
INSERT INTO sml_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Luwal jadjahan Gosen halam bay katumbukan tigtigan aes. Ya na ko' ina'an paglahatan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Magtūy pinalinganan si Musa maka si Harun e' Pira'un. Pagt'kka itu, yukna ma sigā, “Tasayuku na, taga-dusa aku. Si Yawe ya tag-da'ugan. Kami maka saga a'aku ya makasā'. ");
INSERT INTO sml_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Amu'inbi kami duwa'a kono' ni si Yawe bang pa'in pahali l'ggon itu maka tigtigan aes, sabab sarang na. Janji'anta kam, tugutanta du kam paluwas minnitu. Mbal na kam taggahanku maitu.” ");
INSERT INTO sml_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Anambag si Musa, yukna, “Aho', pagluwasku sadja min da'ira itu, sanggaku tanganku pangamu'ku ni si Yawe. Pahali du l'ggon maka pahalam du isab tigtigan aes itu bo' supaya kata'uwannu si Yawe sadja ya tag-dapu dunya. ");
INSERT INTO sml_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Sagō',” yuk si Musa, “kata'uwanku ka'am maka saga a'a kawakilannu, mbal na pa'in kam tināw ma si Yawe, ya Tuhan-asal-Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ya tinanom magka'at e' ulan, ya na saga tinanom ajatu maka tinanom yampa angugbus. ");
INSERT INTO sml_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Sagō' in ginis tinanom paghinangan tirigu halam bay magka'at sabab halam gi' angugbus, subay ma bulan sinosōng. ");
INSERT INTO sml_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Pagpuwas, ang'bba si Musa min Pira'un inān bo' paluwas min deyom da'ira. Ma luwasan pa'in iya, sinangga tanganna maka e'na angamu' duwa'a ni PANGHŪꞋ. Agsai pahali na l'tte' maka tigtigan aes, halam na isab angulan. ");
INSERT INTO sml_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Na, pag'nda' Pira'un ma l'tte' maka tigtigan aes maka ulan pahali na, magdusa iya pabalik. Magtuwas-tuwas iya di-na, beya' isab saga a'a kawakilanna. ");
INSERT INTO sml_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Jari tatuman bay pah'lling PANGHŪꞋ ni si Musa ma pasal Pira'un. Halam tinugutan e'na bangsa Isra'il paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Manjari angallam PANGHŪꞋ-Yawe ma si Musa, yukna, “Pehē' ka angaharap Pira'un. Tapatuwasku kōkna maka kōk saga a'a kawakilanna supaya hinangku saga paltanda'an makainu-inu ma pang'nda' sigām. ");
INSERT INTO sml_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Manjari aniya' panuli-nulinu ma saga anak-mpunu ma waktu sinōng pasal katiksa'an ya tapat'nna'ku itu ma saga a'a Misil, maka pasal paltanda'an makainu-inu ya tahinangku ma deyoman sigām. Minnē' kata'uwanbi in aku si Yawe ya Tuhan-asal-Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Sakali pehē' disi Musa maka si Harun ni Pira'un. Yuk sigā duwangan ma iya, “Aniya' itu pamalman ma ka'a e' si Yawe ya pagtuhanan bangsa kami Hibrani. Yukna, ‘Sumiyan lagi' ka pahali magtanggu-tanggu bo' yampa magmalilla' ma aku? Tugutin saga a'aku ala'an min Misil itu supaya sigām makapagsumba ma aku. ");
INSERT INTO sml_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Bang ka pasangdan na pa'in magin'mbal ma kala'an sigām, pabowaku saga ampan dulu ni lahatnu salung. ");
INSERT INTO sml_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Aliput kaluha'an gintana'an ilu e' ampan dulu pagka aheka makalandu'. Pinagkakan e' sigām tinanom kamemon maka kakayu-kayuhan kamemon ya takapin allum ma kahuma-huma'anbi, ai-ai halam bay magka'at e' ulan tigtigan aes e'. ");
INSERT INTO sml_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Sinōd du isab e' ba'anan ampan dulu astana'nu maka kaluma'an saga wakilnu sampay luma' saga a'ana bangsa Misil kamemon. Minsan bay waktu kamatto'ahanbi, halam aniya' katiksa'an buwattitu bisana bay kalabayan sigām sangay min katagna' sigām maglahat ma tana' Misil itu.’ ” Na, aubus pa'in pah'lling si Musa buwattē', pataikut na iya bo' ala'an min matahan Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Sakali itu, makala'an pa'in si Musa, ah'lling ma Pira'un saga wakilna, yuk-i, “Sampay sumiyan bahā' ya panasat a'a itu ma kitam? Tugutin bangsa inān ala'an supaya sigām makapagsumba ni si Yawe ya Tuhan sigām. Halam gi' bahā' kata'uwannu in lahat Misil itu magka'at na?” ");
INSERT INTO sml_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Angkan na si Musa maka si Harun tabowa magharap maka Pira'un pabīng. Yukna ma sigā, “Aho', makajari. Pehē' na kam magsumba ni Tuhanbi si Yawe. Sagō' sai na pa'in ameya' ma ka'am?” ");
INSERT INTO sml_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Yuk sambung si Musa, “Magbeya' kami kamemon, onde'-onde' matto'a. Bowa kami isab saga ka'anakan kami d'nda-l'lla. Damikiyanna saga kahayopan-hayopan kami, sabab aniya' paghinang pamudji kami si Yawe.” ");
INSERT INTO sml_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Agsai ah'lling Pira'un, “Mattan ko' ilu,” yukna, “aniya' maksudbi mbal ahāp. Haka'anta kam, subay aheya tabang si Yawe ma ka'am bo' yampa aku tabowa anugutan ka'am paluwas minnitu, beya' isab kar'ndahanbi maka kaonde'-onde'an! ");
INSERT INTO sml_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ē! Mbal kam tugutanku. Subay l'lla sadja ya nirūlan paluwas anumba si Yawe, sabab ya du ina'an pangamu'bi na pa'in.” Magtūy pinala'an na si Musa maka si Harun min matahan Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Sakali aniya' gi' pangallam PANGHŪꞋ ma si Musa, yukna, “Pabantangun tangannu tudju ni lahat Misil supaya angulatup pi'ilu ba'anan ampan dulu bo' amangan saga tinanom kamemon, ingga-ingga ya halam magka'at e' tigtigan aes.” ");
INSERT INTO sml_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Na, tapabantang pa'in e' si Musa tungkudna tudju ni katana'-tana'an Misil, magtūy aniya' baliyu akosog pinatumbuk e' PANGHŪꞋ luwas min sobangan, min llaw ina'an sampay ni kasubuhan. Ta'abut pa'in subu, ina'an na saga ampan dulu bay tabowa e' baliyu he'. ");
INSERT INTO sml_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Manjari sakalingkal lahat Misil maka kahuma-huma'anna kamemon wa'i kat'ppakan ampan dulu landu' aheka. Sangay min awal sampay ni ahil, halam bay buwattē' hekana. ");
INSERT INTO sml_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Aettom kuwit tana' pagka aliput e' ampan dulu. Aubus pinagkakan tinanom kamemon ya takapin min bay hunus tigtigan aes. Beya' na saga buwa' kayu. Halam aniya' dahun takapin ma saga po'on kayu kamemon maka tinanom kamemon ma sakalibutan Misil. ");
INSERT INTO sml_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pagka buwattē', magdai'-dai' Pira'un amalinganan si Musa maka si Harun. Maina'an pa'in, yukna ma sigā, “Taga-rusa aku ma si Yawe ya pagtuhananbi. Taga-rusa isab ma ka'am. ");
INSERT INTO sml_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Na ampununbi dusaku min t'dda sadja la'a. Maka amu'-amu'inbi aku duwa'a ni Tuhanbi si Yawe, bang pa'in ala'an min aku bala' makamula itu.” ");
INSERT INTO sml_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Pagubus itu, ang'bba disi Musa min Pira'un bo' angamu' tabang ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Na, pinapinda e' PANGHŪꞋ baliyu min sobangan inān, manjari baliyu min s'ddopan na landu' akosog makabowa ba'anan saga ampan inān pehē' ni dilaut Tahik Keyat. Halam aniya' ampan dulu takapin ma lahat Misil, minsan dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Sagō' ya kōk Pira'un masi pinatuwas e' PANGHŪꞋ, angkan halam tugutanna saga a'a Isra'il paluwas min lahatna. ");
INSERT INTO sml_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Sakali itu, aniya' pangallam PANGHŪꞋ ma si Musa, yukna, “Pa'angkatun tangannu tudju ni langit bo' angalendom bitu-bituhan ma sakalibut lahat Misil ilu.” ");
INSERT INTO sml_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Na, wa'i pina'angkat e' si Musa tanganna. Magtūy angalendom ma lahat Misil ma deyom t'llung'llaw. ");
INSERT INTO sml_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mbal na makapag'nda' saga a'a Misil dansehe'an, mbal minsan makala'an min kaluma'an sigām t'llung'llaw t'ggolna. Sagō' asawa ma jadjahan paglahatan saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Magtūy pinalinganan si Musa e' Pira'un. Maina'an pa'in, yuk Pira'un ma iya, “Pehē' na kam anumba ni si Yawe ya Tuhanbi. Makajari isab ameya' sampay anak-h'ndabi, saguwā' subay ta'bba maitu ba'anan bili-bilibi maka kambingbi maka sapi'bi.” ");
INSERT INTO sml_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Anambung si Musa ma Pira'un, yukna, “Subay kami dūlannu amowa saga hayop kami bo' aniya' sinumbali' maka tinunu' panukbal ni Tuhan kami si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Subay ameya' ma kami saga kahayop-hayopan kami kamemon. Subay halam aniya' ni'bbahan minsan dakayu', sabab kagunahan kami hayop kasehe'an itu pangahulmat kami ni Tuhan Yawe. Maka mbal gi' kinata'uwan bang hayop ingga ya pinene' pagkulban. Subay na kami at'kka pehē' ni pagsumbahan bo' yampa kinata'uwan.” ");
INSERT INTO sml_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Sagō' pinatuwas e' PANGHŪꞋ-Yawe kōk Pira'un inān, angkan iya mbal to'ongan anugutan saga Isra'il paluwas min lahatna. ");
INSERT INTO sml_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Yuk Pira'un ma si Musa, “Ala'an kam min matahanku. Amay-amay, da'a ka pabaihu' ma aku pabīng. Ya llaw paka'nda'nu ma aku, ya na llaw kamataynu.” ");
INSERT INTO sml_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“Aho',” yuk si Musa, “ka'a ya beya'ku. Mbal aku pabaihu' ma ka'a pabalik.” ");
INSERT INTO sml_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na, aniya' asal bay pangallam PANGHŪꞋ-Yawe ma si Musa, ya yukna, “Dakayu' la'a mulka' takapin pamat'kkaku ma Pira'un sampay ma saga a'ana bangsa Misil, bo' yampa kam tinugutan paluwas minnitu. Tin'ggal kam e'na supaya kam pinala'an pagsakali. ");
INSERT INTO sml_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Haka'in saga a'a Isra'il d'nda-l'lla,” yukna, “in sigām subay angamu' pamulawan ni saga bangsa Misil ya magsekot luma' maka sigām.” ");
INSERT INTO sml_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Min kahandak PANGHŪꞋ ya angkan ahāp pangatayan saga bangsa Misil tudju ni bangsa Isra'il. Kapagmahaltabatan isab si Musa baranna e' saga wakil sultan maka saga a'a Misil kamemon. ");
INSERT INTO sml_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Manjari itu, aniya' pamalman Tuhan pamalatun e' si Musa ma Pira'un, yukna, “Ya na itu palman Tuhan Yawe, ‘Sangom ilu, tonga' bahangi, palabay du aku min deyom lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ma paglabayku, amatay kamemon saga l'lla pagsiyakahan ma bangsa Misil, tinagna'an min anak Pira'un ya pinusaka'an magsultan, sampay ni anak ata ya maggiling gandum. Damikiyanna isab amatay saga hayop ya dahū bay nianakan ");
INSERT INTO sml_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Jari landu' akosog ya paglemong saga a'a kamatayan ma katilibut Misil. Min awal sampay ni ahil, halam aniya' pagtangis buwattē' kosogna. ");
INSERT INTO sml_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Malaingkan in bangsa Isra'il maka ba'anan hayop sigām mbal ainay, mbal minsan tinanghulan e' ero'.’ Minnē',” yuk si Musa ma Pira'un, “makata'u kam aniya' pagbidda'an pinat'nna' e' si Yawe ma bangsa Misil maka bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Pareyo' du isab ni aku saga wakilnu ilu kamemon angamu'an aku junjung bang pa'in aku ala'an sampay saga bebeya'anku kamemon. Bang ta'abut na ina'an-i, ala'an du aku.” Akagit makalandu' atay si Musa, mbal agon kasandalan. Magtūy iya ala'an min matahan Pira'un. ");
INSERT INTO sml_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Na, aniya' bay pangallam PANGHŪꞋ ma si Musa, ya yukna, “Pira'un ilu, mbal to'ongan akale ma ka'am bo' supaya paheka lagi' saga hinangku makainu-inu ya paniya'ku ma lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ya katobtobanna, minsan tahinang e' si Musa maka si Harun saga kahinangan makainu-inu itu kamemon ma matahan Pira'un, in kōkna masi na pa'in pinatuwas e' PANGHŪꞋ. Ya he' sababna angkan mbal tugutanna saga a'a Isra'il paluwas min lahatna. ");
INSERT INTO sml_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Manjari itu, maina'an lagi' si Musa maka si Harun ma lahat Misil, aniya' pamalman PANGHŪꞋ ma sigā. ");
INSERT INTO sml_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Yukna, “In bulan itu subay itungbi bulan panagna'an tahun. ");
INSERT INTO sml_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pata'uhunbi saga ummat bangsa Isra'il kamemon. Bang ta'abut sangpū' kasobangan ma bulan tagna'an itu, saga l'lla magmakōk ma luma' pakaniya-pakaniya subay angā' anak bili-bili atawa kambing pagkulban sigām. ");
INSERT INTO sml_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Bang isab aniya' a'a magtai'anak mbal makaubus amangan dakayu' bili-bili, subay sigām magbahagi' maka pagkahi sigām magsekot luma'. Sagō' bistahunbi pahāp puhu'bi bo' supaya atopod e'bi amangan. ");
INSERT INTO sml_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ya hayop pene'bi subay hayop l'lla dantahun umulna, halam isab aniya' salla'na, ai-na ka bili-bili, ai-na ka kambing. ");
INSERT INTO sml_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Jagahinbi saga hayop ya tapene'bi sampay ta'abut sangpū' maka mpat kasobangan ma bulan ilu. Pagabay kohap ma llaw ina'an, ya ka'am ummat bangsa Isra'il kamemon subay magsama-sama anumbali' saga hayopbi. ");
INSERT INTO sml_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Puwas e', subay kam angā' laha' sumbali'an ilu bo' pahirinbi ni diyata' bowa' lawang maka ni bihingna karuwambila' ma luma' ya pagkakananbi hayop-i. ");
INSERT INTO sml_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Na, sangom pa'in, ya hayop ilu subay tinapa bo' pinagkakan maka sayul apa'it maka tinapay halam bay pinasuligan. ");
INSERT INTO sml_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","In isi hayop ilu mbal manjari ni'inta' atawa nilaga', subay tinapa ma katibu'ukanna, beya' na isab kōkna, tape'na sampay pagdayaw baranna. ");
INSERT INTO sml_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bang aniya' takapin, da'a tau'unbi sampay ni kasubuhan, subay tinunu'. ");
INSERT INTO sml_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ya pagkakanbi subay asapat hinabubi magsakap atulak. Subay kam magbinadju', magsinontoron, magtinaumpa', magtinungkud. Hinang Paglakad ko' ilu, hinang pamaheyabi ma aku PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ma sangom ilu du,” yuk PANGHŪꞋ, “palabay aku min deyom lahat Misil amapatay saga l'lla pagsiyakahan kamemon, ai-na ka manusiya', ai-na ka hayop. Pagmulka'anku saga pagtutuhanan bangsa Misil kamemon, sabab si Yawe aku, ya Tuhan-asal-Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","In laha' pamahidbi ma bihing bowa' lawang tahinang paltanda'an ma saga luma' ya pat'nna'anbi. Jari pag'nda'ku laha' ilu, lakaranta sadja kam, ati halam aniya' kamulahan pat'kka ni ka'am ma waktu kapangamulka'ku lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Angallam gi' PANGHŪꞋ, yukna, “Llaw itu subay pagjamuhunbi sakahaba' tahun magpangkat-mamangkat pamaentoman bay kahāpku ma ka'am. Hatulan itu subay taptap bogboginbi. ");
INSERT INTO sml_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ma deyom pitung'llaw,” yukna, “ya tinapay pagkakanbi subay halam aniya' pasuligna. Ma llaw tagna'an ma dapitu' inān, sinō' kam angala'anan pasulig kamemon min deyom kaluma'anbi. Sabab sai-sai makakakan ai-ai taga-pasulig ma deyom dapitu' he', mbal na taitung bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Subay kam magtipun magsambahayang ma llaw tagna'an dapitu' he', damikiyanna du isab ma llaw kapitu'na. Mbal kam makajari maghinang ai-ai ma deyom duwang'llaw pagsambahayang e', luwal hinangbi magadjal pagkakan. ");
INSERT INTO sml_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Hinangunbi Hinang Tinapay Halam Pasuligna, pangentomanbi llaw bay kapamowaku ka'am magtumpuk-manumpuk paluwas min lahat Misil. Paghinangunbi llaw ina'an-i sakahaba' tahun sampay ni kasaumulan. ");
INSERT INTO sml_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kahaba' bulan panagna'an tahun, subay kam magkakan tinapay halam taga-pasulig, tinagna'an min waktu abay kohap ma sangpū' maka lima kasobangan sampay ni abay kohap isab ma duwampū' maka duwa kasobangan. ");
INSERT INTO sml_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Subay halam aniya' pasulig tabāk ma deyom kaluma'anbi ma deyom pitu' llaw ilu. Sai-sai amangan ai-ai kalamuran pasulig, ai-na ka a'a liyu, ai-na ka a'a porol bangsa Isra'il, mbal taitung jama'a bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ma'ai-ma'ai paglahatanbi wajib kam da'a amangan kinakan bay kalamuran pasulig. Ya sadja takakanbi ma deyom dapitu' subay pagkakan halam aniya' pasuligna.” ");
INSERT INTO sml_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Puwas e', nilinganan e' si Musa saga pagmatto'ahan bangsa Isra'il kamemon. Atipun pa'in, magpanoho'an iya ma sigām, yukna, “Ka'am kamemon kaniya-kaniya subay pasa'ut amene' anak bili-bili atawa anak kambing sinumbali' bo' supaya kam magtai'anak maghinang Hinang Paglakad. ");
INSERT INTO sml_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Angā' kam isab dakayu' sanga-sanga jambangan hissup bo' t'nno'inbi ni laha' bay pasalud ma pinggan. Abase' pa'in, pahirinbi laha' ilu ni bowa' lawang luma'bi, ni diyata'na maka ni bihingna karuwambila'. Na, ma waktu ina'an subay halam aniya' min ka'am minsan dangan paluwas min luma' sampay ni kasubuhan. ");
INSERT INTO sml_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Sabab ma sangom ina'an du, palabay si Yawe min lahat Misil angamulka'an saga a'a Misil. Sagō' ka'am ilu lakaranna du pagka ta'nda'na laha' ma bihing bowa' lawangbi. Mbal pasagaranna mala'ikat pangmumulka' pasōd ni deyom luma'bi amapatay ka'am.” ");
INSERT INTO sml_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Yuk si Musa isab, “Saga panoho'an itu wajib subay bogboganbi magpangkat-mamangkat salama-lama. ");
INSERT INTO sml_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Bogboginbi isab hinang pagkulban itu bang kam makat'kka na ni lahat ya bay panganjanji' ma ka'am e' PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Lāgi bang kam saupama tinilaw e' saga ka'anakanbi bang ai sababna ya angkan kam maghinang buwattē', ");
INSERT INTO sml_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","pandu'inbi sigām. Yukbi, ‘Hinang ko' itu pamudji ma PANGHŪꞋ, hinang pangentoman bay Paglakadna ma kitam. In ka'anakan siyaka bangsa Misil bay pagmulka'anna, saguwā' kaluma'antam bangsa Isra'il bay kalakaran e'na. Ya he' sababna angkan kitam maghinang buwattitu.’ ” Pagkale saga ummat Isra'il kamemon ma lling si Musa itu, magtūy sigām pasujud amudji Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Pagubus, patūy saga a'a Isra'il angahinang buwat bay panoho'an PANGHŪꞋ ma si Musa maka si Harun e'. ");
INSERT INTO sml_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Manjari itu, ta'abut pa'in tonga' bahangi, pinapatay e' PANGHŪꞋ-Yawe saga l'lla kamemon ya anak siyaka ma bangsa Misil. Tinagna'an min anak Pira'un ya pinusaka'an pagsultanna sampay ni anak pilisu ma deyom kalabusu, sampay isab hayop ya dahū bay nianakan, wa'i pinapatay kamemon. ");
INSERT INTO sml_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Makabati' magtūy Pira'un maka saga a'a kawakilanna ma hinabu sangom inān, sampay saga a'a Misil kamemon makabati' du isab. Aheya paglemong ma sakalibut lahat Misil sabab halam aniya' luma' sigām ma halam kamatayan. ");
INSERT INTO sml_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Na, ma sangom ina'an du, magpanoho'an Pira'un ma si Musa maka si Harun subay paharap ni iya. Makaharap pa'in, yukna ma sigā, “Ē! Ala'an kam min saga bangsaku, ka'am baranbi sampay bangsabi Isra'il! Ala'an kam pehē' amudji si Yawe buwat bay pangamu'bi! ");
INSERT INTO sml_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bowahunbi saga kahayop-hayopanbi buwat yukbi, bang pa'in kam magla'anan na. Maka amu'-amu'inbi aku duwa'a.” ");
INSERT INTO sml_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ya du saga a'a Misil kamemon, akosog e' sigām angamu' ni saga a'a Isra'il subay ala'an magdai'-dai'. “Sababna,” yuk sigām, “bang kam mbal ala'an, tantu kami magpatayan kamemon!” ");
INSERT INTO sml_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Sakali itu, pagka mbal makat'ggol, binowa e' saga a'a Isra'il addunan tinapay sigām ma halam gi' pinalamuran pasulig. Jari pinutus sampay pangisihanna maka s'mmek bo' yampa tinanggung e' sigām. ");
INSERT INTO sml_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Bineya' isab e' bangsa Isra'il bay panoho'an si Musa ma sigām, hatina magpangamu' sigām saga pamulawan maka s'mmek min saga a'a Misil. ");
INSERT INTO sml_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ya kat'kkahanna, saga a'a Isra'il bay kabuwanan ai-ai pangamu' sigām ma bangsa Misil, pagka alunuk pangatayan saga a'a Misil tudju ni sigām, sabab min kawasa PANGHŪꞋ. Jarina landu' aheka pangalta' suku' Misil bay ta'ā' e' saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Na, magl'ngnganan bangsa Isra'il min da'ira Ramisis tudju ni kauman Sokkot. Ya heka puhu' sigām saga nnom hatus ngibu bang hal l'lla ni'itung, saddī kar'ndahan maka kaonde'-onde'an. ");
INSERT INTO sml_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Aheka du isab a'a bangsa saddī pasambeya' ma sigām, maka aheka isab katumpukan bili-bili, kambing maka sapi' tabowa sigām. ");
INSERT INTO sml_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Makahanti' pa'in, ya addunan bay binowa e' sigām min Misil tahinang tinapay na, tinapay halam aniya' pasuligna. Addunan inān halam bay kalamuran pasulig sabab nilogos sigām e' bangsa Misil subay ala'an magdai'-dai'. Halam sigām pinarūl minsan angamomos kinakan palutu' sigām. ");
INSERT INTO sml_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Na, mpat hatus maka t'llumpū' tahun ya t'ggol bay kapaglahat sigām bangsa Isra'il ma lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ajukup pa'in mpat hatus maka t'llumpū' tahun e', ma llaw ina'an du, ya na waktu kaluwas saga a'a suku' PANGHŪꞋ magtumpuk-manumpuk min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","PANGHŪꞋ-Yawe ya bay anganjagahan sigām ma sangom e' bo' supaya paluwasna sigām min lahat Misil. Ya he' sababna angkan saga a'a Isra'il subay magjaga bang ta'abut sangom ina'an-i sakahaba' tahun sampay ni kasaumulan, pamaheya sigām ma PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Aniya' gi' isab kabtangan PANGHŪꞋ-Yawe ma si Musa maka si Harun, yukna, “Buwattitu kal'ngngananna bang kam maghinang Hinang Paglakad. Bang a'a saddī bangsana, mbal makajari palamud amangan. ");
INSERT INTO sml_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Makajari du bang a'a bay b'llibi magata, bang pa'in bay taislambi. ");
INSERT INTO sml_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sagō' bang a'a liyu ya pahanti' ma ka'am atawa a'a ginadjihan maghinang ma deyomanbi, mbal makajari. ");
INSERT INTO sml_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Bang kam amangan sumbali'an pagkulban, subay ma deyom luma' bay pangadjalan iya, mbal makajari binowa paluwas. Da'a isab pōngunbi to'olangna minsan dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Wajib isab saga jama'a Isra'il kamemon maghinang pagjamu itu, ");
INSERT INTO sml_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","sagō' sasuku halam taislam, mbal makajari palamud magjamu. Ya balikna, bang aniya' a'a bangsa saddī bilahi maghinang Hinang Paglakad pamaheyana ma PANGHŪꞋ-Yawe, bo' a'a inān at'ggol na asal maglahat mailu ma ka'am, makajari du bang pa'in iya taislam sampay saga l'lla kamemon ma deyomanna. A'a inān taitung sali' porol a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Manjari sali' du panoho'an ya pinat'nna'an ka'am kamemon, porol bangsa Isra'il ka atawa bangsa saddī ya maglahat asal maina'an ma ka'am.” Ya he' kabtangan Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Na, bineya' e' saga bangsa Isra'il kamemon bay panoho'an PANGHŪꞋ ma si Musa maka si Harun. ");
INSERT INTO sml_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Jari ma llaw ina'an du, in bangsa Isra'il magtumpuk-manumpuk tabowa na e' PANGHŪꞋ-Yawe paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Magkallam isab PANGHŪꞋ-Yawe ma si Musa, yukna, ");
INSERT INTO sml_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Pamasuku'unbi ma aku saga anak kasiyakahan l'lla kamemon, sabab aku ya tag-suku' ma kamemon ya dahū paluwas ma ka'am bangsa Isra'il, ai-na ka manusiya', ai-na ka hayop.” ");
INSERT INTO sml_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Manjari ah'lling si Musa ma saga a'a Isra'il, yukna, “Entomunbi llaw kala'anbi itu min lahat Misil, lahat bay pamanyaga'an ka'am. Entomunbi pahāp sabab ya na itu llaw bay kapamaluwas ka'am e' si Yawe sabab min kosog kawasana. Da'a isab kam amangan ai-ai taga-pasulig ma llaw ītu. ");
INSERT INTO sml_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ilu kam magla'anan buwattina'an min lahat Misil, ma Bulan Abib ya bulan panagna'an tahun. ");
INSERT INTO sml_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Binowa na kam e' PANGHŪꞋ ni lahat bay panganjanji'na ma ka'mbo-mbo'antam, ya lahat paglahatan asal e' saga bangsa Kana'an, bangsa Hīt, bangsa Amor, bangsa Hīb maka bangsa Jibus. Ahāp sidda lahat inān, ap'nno' e' kalluman landu' ahāp. Manjari, bang kam tapasōd na e' PANGHŪꞋ ni deyom lahat e', subay kam angisbat paghinang itu pamudjibi Tuhan kahaba'-kahaba' tahun bang ta'abut bulan Abib itu. ");
INSERT INTO sml_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Manjari ma deyom pitung'llaw paghinang itu, mbal kam makajari amangan ai-ai taga-pasulig. Ta'abut pa'in llaw kapitu'na, subay kam magpajamu pamaheyabi ma PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ma deyom pitung'llaw ilu mbal kam makajari amangan ai-ai taga-pasulig. Subay halam aniya' pasulig tabāk ma lahatbi ilu minsan maingga-maingga. ");
INSERT INTO sml_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ta'abut pa'in waktu paghinang itu, suli-sulihinbi saga anakbi bang ai sababna. Ya yukbi ma sigām, ‘Angkan aku angisbat paghinang itu sabab nientom bay tabang PANGHŪꞋ-Yawe ma aku waktu kala'anku min lahat Misil.’ ” ");
INSERT INTO sml_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ah'lling gi' si Musa, yukna, “In kahinangan itu sali' sapantun tanda' binaggot ma tanganbi maka ma tuktukbi, pamaentom ka'am in sara' panoho'an PANGHŪꞋ subay taptap pah'llingbi. Sabab hatina in ka'am ilu bay binowa e' PANGHŪꞋ paluwas min lahat Misil sabab min kosog kawasana. ");
INSERT INTO sml_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Subay sabuhunbi paghinang itu sakahaba' tahun bang ta'abut waktuna.” ");
INSERT INTO sml_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Amissala lagi' si Musa, yukna, “Pinasampay du kam e' PANGHŪꞋ-Yawe ni lahat bangsa Kana'an, lahat bay panganjanji'na pinamuwan ma ka'am sampay ma saga ka'mbo'-mbo'anbi. ");
INSERT INTO sml_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Makat'kka pa'in kam ni lahat e', subay pasuku'unbi ma PANGHŪꞋ saga anakbi l'lla kasiyakahan kamemon. Damikiyanna saga anak hayop ya dahū l'lla nianakan, subay pinasuku'an PANGHŪꞋ isab. ");
INSERT INTO sml_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sagō' bang saga anak kura' ya dahū nianakan mbal taluwa' kinulban. Gom pa'in nil'kkat, hatina subay aniya' anak bili-bili atawa kambing sinumbali' ganti'na. Bang anak kura' mbal l'kkatbi, na subay pinōngan buli'-k'llongna. Saga anakbi l'lla kasiyakahan isab, subay nil'kkat maka susumbali'an pagkulbanbi ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ma sinosōng isab, bang kam ganta' tinilaw e' anakbi pasal paghinang kasiyakahan ilu bang ai sababna, ya sambungbi subay buwatittu. ‘Ma sabab kapamowa PANGHŪꞋ ma kami paluwas min lahat Misil, ya lahat amanyaga', maka min kosog kawasana isab. ");
INSERT INTO sml_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Bay atuwas sidda kōk Pira'un ma waktu inān ati mbal to'ongan anugutan kami ala'an minnē', pinapatay e' PANGHŪꞋ saga anak l'lla kasiyakahan kamemon ma kaluha'an lahat Misil, manusiya' ka atawa hayop. Ya he' sababna angkan subay pamasuku'ku ma PANGHŪꞋ saga anak l'lla ai-ai ya dahū paluwas, maka anakku l'lla kasiyakahan subay l'kkatku maka anak bili-bili atawa kambing.’ ");
INSERT INTO sml_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ya hinang itu sali' sapantun tanda' binaggot ma tangantam atawa ma tuktuktam pamaentom kitam pasal bay kapamowa PANGHŪꞋ ma kitam paluwas min lahat Misil, min kosog kawasana isab.” Minnē' aubus kabtangan si Musa. ");
INSERT INTO sml_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Manjari, tapaluwas pa'in saga bangsa Isra'il e' Pira'un, halam sigām binowa e' Tuhan palabay min lān tudju ni lahat Pilistin, minsan asekot-sekot. Tu'ud halli'anna bangsa Isra'il bang sigām agon-agon nirugpak e' saga a'a amowa sigām magbono', marai' al'kkas apinda pikilan sigām ati bilahi sigām pabalik pehē' ni Misil. ");
INSERT INTO sml_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Angkan na sigām binowa e' Tuhan labay min lahat paslangan tampal ni Tahik Keyat. Magtinakos asal sigām bo' asakap magbono'. ");
INSERT INTO sml_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Pagla'an sigām min Misil, binowa e' disi Musa saga to'olang bangkay si Yusup, sabab ma waktu allum lagi' si Yusup, bay pasapana saga anakna. Yukna ma sigām, “Tantu kam tinabang e' Tuhan ma sinosōng bo' kam makaluwas min lahat Misil itu. Amay-amayanta kam, bang ta'abut waktu kaluwasbi, bowahunbi isab bangkayku.” ");
INSERT INTO sml_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Na, ala'an pa'in bangsa Isra'il itu min lahat Sokkot, pahanti' sigām ma Etam, dakayu' lahat ma kasekotan paslangan. ");
INSERT INTO sml_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Manjari ina'an PANGHŪꞋ-Yawe anganjagahan sigām ma pal'ngnganan. Sakahaba' llaw ina'an iya ma dahuan sigām amandogahan sigām min deyom gabun-Tuhan. Sakahaba' sangom ina'an iya ma deyom api-Tuhan amuwanan sigām kasawahan. Minnē' sigām makal'ngngan llaw-sangom. ");
INSERT INTO sml_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mbal ala'an gabun-Tuhan inān min munda'an sigām ma waktu llaw, mbal isab ala'an api-Tuhan ma waktu sangom. ");
INSERT INTO sml_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Angallam na isab PANGHŪꞋ-Yawe ma si Musa, yukna, ");
INSERT INTO sml_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Soho'un saga a'a Isra'il palibut bo' pahanti' ma atag kauman Pī-Hahirut, mahē' ma tonga'an Migdul maka Tahik Keyat, ma anggopan isab kauman Ba'al-Sepon. ");
INSERT INTO sml_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Sabab bang ta'nda' e' Pira'un bangsa Isra'il magsōng-suhut, pinikil e'na marai' in ka'am alungay pagka kam maglibut-libut sadja ma lahat paslangan.” ");
INSERT INTO sml_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Angallam gi' Tuhan, yukna, “Patuwasku isab kōk Pira'un bo' soho'na saga sundaluna angapas ka'am. Sagō' da'ugku iya sampay kasundaluhanna. Jari in panganda'ugku inān amuwanan aku kabantugan, lāgi magkahagad saga bangsa Misil in aku si Yawe, ya Tuhan-asal-Tuhan.” Ati bineya' e' saga bangsa Isra'il bay panoho'an Tuhan e'. ");
INSERT INTO sml_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sakali itu, kahaka'an pa'in Pira'un pasal bangsa Isra'il wa'i alahi, apinda pikilanna. Ya du saga wakilna, ati magsusun sigām. “Arōy,” yuk sigām, “mbal manjari! Wa'i pasagarantam saga a'a Isra'il ala'an min lahat itu ati alungay min kitam saga banyaga' ya bay maghinang ma kitam!” ");
INSERT INTO sml_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Angkan pinasakap e' Pira'un kalesana pagbobono', maka sinō' isab saga kasundaluhanna magsakap. ");
INSERT INTO sml_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Binowa e' Pira'un ba'anan kalesana kamemon sampay saga sundalu ya pagmakōkan kalesa inān pakaniya-pakaniya. Beya' isab saga kalesana ya katapusan ahāp, nnom hatus hekana. ");
INSERT INTO sml_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Manjari itu, atuwas na pa'in kōk Pira'un ya sultan lahat Misil sabab min kabaya'an PANGHŪꞋ, angkan apasna bangsa Isra'il, ya anawakkal paluwas min lahatna ma mata mairan. ");
INSERT INTO sml_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ya magpangapas inān ba'anan kasundaluhan Pira'un, saga sundalu magpangura', ba'anan saga kalesa pagbobono' sampay kakompol-kompolan sundalu magtape'. Ta'abut e' sigām bangsa Isra'il ina'an pahanti' ma bihing Tahik Keyat, ma kasekotan kauman Pi-Hahirut maka Ba'al Sepon. ");
INSERT INTO sml_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Manjari itu, asekot pa'in pina'an Pira'un maka saga kasundaluhanna, ta'nda' sigām e' saga a'a Isra'il. Pag'nda' itu, magtūy sigām sinōd tāw ati parahing ni PANGHŪꞋ-Yawe angamu' tabang. ");
INSERT INTO sml_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Amūng-mūng sigām ma si Musa, yuk-i, “Mbal manjari hinangnu itu, atiya' kami bowanu paluwas min lahat Misil! Halam bahā' aniya' pangubulan ma lahat Misil, ya angkan kami bowanu pi'itu magpatayan ma lahat paslangan? ");
INSERT INTO sml_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bay ka pah'llingan kami ma lahat Misil gi', ya yuk kami ma ka'a, ‘Pasagarin kami maghinang gi' ma bangsa Misil.’ Padpad kami amatay ma lahat paslangan itu, gom lagi' kami magpa'ata ma sigām.” ");
INSERT INTO sml_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Anambung si Musa, yukna, “Da'a kam agawa. Pahogotun pangatayanbi ati ta'nda'bi bang buwattingga e' Tuhanta Yawe angalappas ma ka'am. Puwas min llaw itu, mbal na ta'nda'bi pabīng saga a'a Misil ilu. ");
INSERT INTO sml_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Patotog kam, sabab PANGHŪꞋ ya ganti'bi amono' sigām.” ");
INSERT INTO sml_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Angallam gi' PANGHŪꞋ-Yawe ma si Musa, yukna, “Angay ka angamu' tabang na pa'in ni aku? Soho'un palanjal saga a'a Isra'il ilu. ");
INSERT INTO sml_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Pabantangun isab tungkudnu paharap ni tahik bo' abahagi' duwa. Manjari paniya' katoho'an ma t'ngnga' tahik palabayanbi bangsa Isra'il tudju parambila'. ");
INSERT INTO sml_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Patuwasku du kōk saga a'a Misil bo' supaya sigām tabowa angapas ka'am sampay ni t'ngnga' tahik. Jari pasōng gi' kabantuganku sabab panganda'ugku min Pira'un maka saga kasundaluhanna, ai-na ka sigām ameya' min kalesa pagbono', ai-na ka sigām magpangura'. ");
INSERT INTO sml_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Paheya gom pa'in kabantuganku ati magparassaya saga bangsa Misil kamemon in aku si Yawe, ya Tuhan-asal-Tuhan, pagka tara'ugku Pira'un maka kasundaluhanna kamemon.” ");
INSERT INTO sml_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Puwas e' in mala'ikat Tuhan ya bay parahū asal ma munda'an bangsa Isra'il, pasuhut na ni buli'an. Damikiyanna isab gabun-Tuhan ya bay ma dahuan, pasuhut isab ni buli'an. ");
INSERT INTO sml_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Jari magpati'llot na gabun inān ma saga bangsa Isra'il maka ba'anan kompolan sundalu Misil. Taluwa' kalendoman saga sundalu Misil, sagō' saga a'a Isra'il ma deyom kasawahan na pa'in minsan sangom. Jari halam bay makapagsekot saga a'a Misil maka saga a'a Isra'il waktu sangom inān sampay ni kasubuhan. ");
INSERT INTO sml_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Sakali itu pinabantang e' si Musa tungkudna paharap ni tahik. Pagpabantangna pa'in, magtūy aniya' baliyu akosog pinat'kka e' PANGHŪꞋ min sobangan animpus ni kasubuhan. Minnē' aniya' katoho'an ma t'ngnga' tahik. Jari abahagi' duwa tahik ");
INSERT INTO sml_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","bo' aniya' t'bbahan palabayan saga bangsa Isra'il parambila'. Maka tahik inān tahinang sali' dinding min bihing sigām karuwambila'. ");
INSERT INTO sml_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Magtūy pa'apas saga sundalu Misil ma sigām, beya' isab saga kalesa Pira'un kamemon maka saga a'ana magpangura', paurul ma sigām sampay ni tahik. ");
INSERT INTO sml_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na, song pa'in pak'llat llaw, paromol PANGHŪꞋ min deyom gabun maka api. Ta'nda'na ba'anan kompolan saga sundalu Misil, ati aheya hiluhala' pamat'kkana ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Pinaloblob e'na saga silikan kalesa sigām ya angkan sigām kahunitan magsōng-suhut. Yuk saga sundalu Misil, “Tinabangan saga bangsa Isra'il itu e' si Yawe, angkan halam aniya' dapattam. Sūng kitam alahi!” ");
INSERT INTO sml_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Angallam gi' PANGHŪꞋ-Yawe ma si Musa, yukna, “Pabantangun tangannu bo' palalom tahik pabalik, ati bo' alimun ba'anan saga sundalu Misil, beya' isab saga kalesa sigām maka saga kompolan sundalu magpangura'.” ");
INSERT INTO sml_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Magtūy pinabantang e' si Musa tanganna paharap ni tahik. Pagk'llat llaw pa'in, pabīng na tahik ni bay baina. Alahi ba'anan a'a Misil inān kalu makapuwas, sagō' nilokoban sigām e' PANGHŪꞋ maka tahik. ");
INSERT INTO sml_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Jari makabīng pa'in tahik ni bay baina, alembo kasundaluhan Pira'un kamemon, ya bay angapas saga bangsa Isra'il sampay ni tahik. Talapay saga kalesa sigām maka ba'anan sundalu magpangura'. Halam aniya' takapin allum minsan dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Sagō' saga bangsa Isra'il, pal'ngngan ma katoho'an sampay pa'abut ni dambila'. Aniya' tahik sali' hantang dinding min bihing sigām karuwambila'. ");
INSERT INTO sml_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Jari ma llaw ina'an, lappasan saga a'a Isra'il e' PANGHŪꞋ min pang'ntanan saga bangsa Misil. Ta'nda' e' sigām ba'anan saga bangkay a'a Misil ma bihing tahik. ");
INSERT INTO sml_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na, pag'nda' saga a'a Isra'il itu ma kosog kawasa PANGHŪꞋ-Yawe ya bay panganda'ugna ma saga bangsa Misil e', magtūy sigām magmatāw ma iya. Jari angandol sigām ma iya sampay ma sosoho'anna si Musa. ");
INSERT INTO sml_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na, magpangalang disi Musa maka saga bangsa Isra'il pamudji sigām ni si PANGHŪꞋ. Ya na itu kalangan sigām: Magkalangan aku ni Yawe sabab abantug da'uganna. Kalarukan e'na saga kura' ni tahik, talapay isab saga a'a magpangura'. ");
INSERT INTO sml_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Si Yawe ya amuwanan aku kosog, in iya pagkalanganku pagka aku kalappasanna. In iya Tuhanku, pudjiku iya, Tuhan isab kamatto'ahanku, paheyaku ōnna. ");
INSERT INTO sml_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Aesog asal si Yawe ma pagbono'an, si Yawe ya ōnna. ");
INSERT INTO sml_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Saga kalesa suku' Pira'un sampay ba'anan kasundaluhanna kalarukan e' Tuhan ni tahik. Saga jiniral Pira'un ya katapusan aesog, wa'i alembo ma Tahik Keyat. ");
INSERT INTO sml_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","He' na sigām ma t'ngnga' s'llang sali' hantang batu pat'nde ni kalaloman. ");
INSERT INTO sml_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Yawe, ka'a ya Sangat-Kawasa, kosognu mbal tapula'-pula'. Tapodjak saga palbantahannu sabab min kosog kawasanu. ");
INSERT INTO sml_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Pinahantak sasuku angatu ma ka'a pagka sigām taluwa' kosog kawasanu. Atunu' sigām sali' sapantun sagmot pagka taluwa' mulka'nu. ");
INSERT INTO sml_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pabūd tahik sabab min kosog napasnu, An'ngge goyak sali' hantang dinding, Akompol isab t'ngnga' s'llang. ");
INSERT INTO sml_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Yuk pangabbu saga palbantahannu, “Apasku saga a'a Isra'il sampay saggawku, Suku'ku pangalta' ya tatabanku min sigām. Karūlan aku amene' ai-ai kanapsuhanku. Hublutku kalisku,” yuk banta inān, “bo' papatayku sigām kamemon.” ");
INSERT INTO sml_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Sagō' ka'a, Tuhan, pagtiyupnu mint'dda alimun magtūy palbantahannu e' tahik. Pat'nde sigām ma timbang sali' sapantun tingga'. ");
INSERT INTO sml_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O Yawe, halam aniya' makasali' ni ka'a ma deyom katuhan-tuhanan ya pagta'atan manusiya'. Halam to'ongan aniya' sali'nu. Ka'a iya sangat mahasussi, sangat asahaya, sangat akawasa, sangat makahinang saga hinang makatāw-tāw ya kainu-inuhan a'a. ");
INSERT INTO sml_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Pinabantang sadja tangannu kowan, magtūy aliyaw saga banta kami e' gumi. ");
INSERT INTO sml_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ya Tuhan, mbal amaluba kasi-lasanu ma saga a'a kalappasannu, angkan sigām malimnu. Bowanu sigām ni lahatnu mulliya sabab min kosog kawasanu. ");
INSERT INTO sml_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Makakale saga bangsa liyu pasal pakaradja'an itu, kinobla'an sigām sampay amidpid. Saga a'a Pilistin sinōd tāw mbal kasandalan, ");
INSERT INTO sml_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Saga datu' bangsa Edom agawa makalandu', pagbebeya'an bangsa Mowab niumagad. Saga bangsa Kana'an alanyap sadja, angorog-ngorog sigām sabab min tāw. ");
INSERT INTO sml_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Sinōd tāw kamemon saga kabangsa-bangsahan ma sabab kosog kawasanu. An'ngge sadja sigām sampay makalabay na saga a'anu, ya tal'kkatnu min pagbanyaga'an. ");
INSERT INTO sml_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Tuhan, tantu kami pasampaynu ni lahatnu bo' pat'nna' ma būd ya palsuku'annu lissi, ni pat'nna'an ya tapene'nu, ni pagluma'an sussi ya tahinangnu. ");
INSERT INTO sml_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","O Yawe, ka'a Tuhan-asal-Tuhan, makapagbaya' du ka salama-lama. ");
INSERT INTO sml_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Na, ya na ina'an kalangan disi Musa. Manjari itu, ma waktu kapehē' ni t'ngnga' tahik saga sundalu Pira'un magpangura', maka saga kalesana pagbobono' sampay ba'anan kura'na, alimun sigām kamemon e' tahik ya pinabīng ni baina e' PANGHŪꞋ. Sagō' in bangsa Isra'il magl'ngnganan ma kat'bbahan sampay makat'kka ni dambila'. ");
INSERT INTO sml_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Sakali magkalangan si Mariyam, dakayu' nabi ya danakan si Harun d'nda. Angā' iya tambul-tambulna maka e'na angigal. Bineya'an isab iya e' saga kar'ndahan magpamowa tambul-tambul di-sigām maka magpangigal isab. ");
INSERT INTO sml_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Magkalangan si Mariyam ma ba'anan sehe'na inān, yukna, “Pagkalanginbi si Yawe pamudjibi ma iya, sabab abantug da'uganna. Kalarukan e'na saga kura' ni tahik, tabeya' isab saga a'a magpangura'.” ");
INSERT INTO sml_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Na, binowa e' si Musa saga bangsa Isra'il ala'an min Tahik Keyat inān tudju ni lahat paslangan ya pinagōnan Sūr. T'llung'llaw ya t'ggol sigām magl'ngngan-l'ngngan ma lahat paslangan e' ma halam aniya' bohe' tabāk sigām. ");
INSERT INTO sml_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sakali, maka'abut pa'in sigām ni Mara, mbal tainum bohe' maina'an sabab landu' apa'it. Angkan na lahat inān pinagōnan ‘Mara’, sabab hatina ‘apa'it.’ ");
INSERT INTO sml_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Manjari pinagdugalan si Musa e' saga a'a Isra'il. Yuk sigām, “Arōy! Daka ai na inumtam itu!” ");
INSERT INTO sml_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Parahing si Musa ni PANGHŪꞋ-Yawe angamu' tabang ati pina'nda'an iya dambatang kayu-kayu. Niā' kayu itu e' si Musa bo' larukanna ni deyom bohe' apa'it e'. Paglaruk itu, magtūy at'bbag bohe' inān, ahāp ni'inum. Manjari itu, mahē' pa'in bangsa Isra'il ma lahat Mara he', aniya' sara' pamat'nna' e' PANGHŪꞋ panulayanna ma sigām bang ameya' atawa mbal. ");
INSERT INTO sml_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yukna, “Bang kam pakale to'ongan ma aku, ya Tuhanbi si Yawe, maka bang kam angahinang kabontolan ya makasulut atayku, maka bang kam amogbog isab ma panoho'anku maka pamituwaku kamemon, na, mbal kam pat'kkahanku saga saki ya bay pat'kkaku ma saga bangsa Misil e'. Aku si Yawe ya magpauli' saga sakibi.” ");
INSERT INTO sml_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Pagubus, palanjal na sigām sampay ta'abut pagbohe'an niōnan Ilim. Sangpū' maka duwa ya heka tuburan bohe' maina'an, maka pitumpū' po'onan hulma. Jari pahanti' sigām maina'an ma bihing bohe'. ");
INSERT INTO sml_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Palabay pa'in daka pilang'llaw ya kahanti' bangsa Isra'il ma Ilim, magbeya' sigām kamemon palanjal minnē'. Jari itu, ma bulan karuwana min bay kaluwas sigām min lahat Misil, sangpū' maka lima kasobangan, makasampay na sigām ni lahat Sīn, ya ma olangan Ilim maka Būd Turusina. Paslangan asal lahat Sīn itu, ahunit pamiha'an kalluman. ");
INSERT INTO sml_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Sakali itu, mahē' pa'in sigām ma lahat Sīn, magkarugalan kamemon saga a'a Isra'il pasal kulang pagkakan sigām. ");
INSERT INTO sml_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ya pah'lling sigām ma si Musa maka si Harun, “Ahāp kami amatay min kahandak PANGHŪꞋ ma lahat Misil lagi'. Ahāp bay pamangan kami mahē'. Aniya' saga sumbali'an niloho'an maka palauk indaginis, pila-pila ya kabaya'an kami. Sagō' nda'unbi kahālan kami buwattina'an, itiya' kami tabowabi ni paslangan itu bo' patay otas kamemon.” ");
INSERT INTO sml_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Sakali itu, pagka buwattē' pagmusmud saga a'a Isra'il, angallam PANGHŪꞋ-Yawe ma si Musa, yukna, “Paniya'anta kam pagkakan sali' sapantun ulan deyo' min langit. Soho'un saga a'a ilu paluwas min kaluma'an sigām amuwa' pagkakan kahaba' llaw. Ya tatimuk e' sigām subay sarang-sarang pagkakan sigām ma dang'llaw sadja. Minnē' kasulayanku sigām bang ameya' ma panoho'anku atawa mbal. ");
INSERT INTO sml_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ya ta'adjal e' sigām ma llaw ka'nnomna subay nilipat duwa bo' sarang pagkakan duwang'llaw.” Ya du ina'an pangallam Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Manjari amissala si Musa maka si Harun ma kamemon bangsa Isra'il. “Abay kohap ilu,” yuk sigā, “kamattanan kam in Tuhanbi si Yawe bay amowa ka'am paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Pagsalung subu isab maka'nda' kam sahaya si Yawe, sabab takale e'na pagdugalbi ma iya. Ngga'i ka kami ya pagdugalanbi, sabab ngga'i kami ya tag-soho'an.” ");
INSERT INTO sml_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Yuk si Musa isab, “PANGHŪꞋ-Yawe ya amuwanan ka'am sumbali'an pagkakanbi kohap, maka tinapay pagkakanbi kahaba' subu, pila-pila ya maka'ssohan ka'am. Sabab hatina takale e' PANGHŪꞋ pagdugalbi. Maka ngga'i ka kami ya pagdugalanbi sagō' Tuhan. Ngga'i ka kami ya tag-kapatut.” ");
INSERT INTO sml_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Puwas e' ah'lling si Musa ma si Harun, yukna, “Soho'un saga a'a ilu kamemon paharap ni PANGHŪꞋ sabab takale e'na pagdugal sigām.” ");
INSERT INTO sml_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Sakali itu, sabu pa'in si Harun amissala ma saga a'a inān, na, pa'alop sigām tudju ni paslangan. Magtūy saru'un-du'un ta'nda' e' sigām sahaya si Yawe asinag min deyom gabun. ");
INSERT INTO sml_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yukna ma si Musa, ");
INSERT INTO sml_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Takaleku pagdugal saga a'a Isra'il. Buwattitu ya pangahakanu ma sigām, ‘Abay kohap itu amangan kam isi sumbali'an, maka salung subu amangan kam pagkakan sampay kam asso na. Minnē' kata'uwanbi in aku si Yawe ya Tuhanbi.’ ” ");
INSERT INTO sml_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Na, abay kohap pa'in, ap'nno' magtūy kauman sigām e' saga manuk-manuk ūl-ūl landu' aheka. Jari aniya' susumbali'an takakan sigām. Pagsubu isab, abase' e' alu' sakalibut kaluma'an. ");
INSERT INTO sml_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Atoho' pa'in, aniya' sali' luwa aes anipis-nipis to'ongan pat'nna' ma kuwit tana'. ");
INSERT INTO sml_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Pag'nda' saga a'a Isra'il, halam kinata'uwan e' sigām bang ai, angkan sigām magtilaw-tilaw dansehe'an, yuk-i, “Ai ilu?” Ya sambung si Musa, “Pagkakan ko' ilu ya pamuwan PANGHŪꞋ ma ka'am. ");
INSERT INTO sml_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Sinō' kam e' PANGHŪꞋ animuk pagkakan ilu pila-pila ya kagunahanbi ma dang'llaw. Ganta'unbi duwa gantang ma a'a dangan maka dangan sasuku paokom ma luma'bi.” ");
INSERT INTO sml_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Na, bineya' e' saga a'a Isra'il ya bay panoho'an Tuhan e'. Aniya' sigām bay animuk aheka, aniya' isab bay animuk ariki'. ");
INSERT INTO sml_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Sagō' pagt'ppong pa'in, saga a'a bay animuk aheka mbal maglabi, maka saga a'a isab bay animuk ariki' mbal magkulang. Atopod sigām sali'-sali'. ");
INSERT INTO sml_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ah'lling gi' si Musa ma sigām, yukna, “Subay kam da'a angapin pagkakanbi salung.” ");
INSERT INTO sml_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Sagō' aniya' sigām kasehe'an mbal ameya' ma pah'lling si Musa-i, ati aniya' kinapin e' sigām. Pagsalung pa'in, na, niulat na maka bau halu'. Jari akagit atay si Musa ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Manjari itu, kahaba'-kahaba' subu, animuk pagkakan saga a'a kamemon, pila-pila ya kagunahan sigām. Ya halam tatimuk atunaw lullun e' llaw. ");
INSERT INTO sml_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sagō' ta'abut pa'in llaw ka'nnomna, nilipat duwa ya tinimuk e' sigām, hatina mpat gantang ma a'a dangan maka dangan. Sakali itu, makata'u pa'in ba'anan a'a pagbebeya'an pasal pagtimuk aheka ilu, magtūy sigām anumbung pehē' ni si Musa. ");
INSERT INTO sml_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ya sambung si Musa ma sigām, yukna, “Makajari du, sabab aniya' panoho'an PANGHŪꞋ pasal llaw kapitu'na, buwattitu. ‘Salung ya llaw paghali-hali, llaw mulliya pagtata'atbi ma PANGHŪꞋ-Yawe.’ Manjari adjalunbi ya bay tatimukbi insini'. Bang kabaya'anbi angahinang dī tinapay, na hinangunbi. Bang kabaya'anbi kinakan sadja, b'llahunbi na. Ai-ai takapin subay tinau' pagkakanbi salung.” ");
INSERT INTO sml_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Jari tinau' e' sigām kapinna pagkakan sigām ma llaw kapitu'na, buwat bay pamituwa si Musa. Halam niulat, halam isab bauwan. ");
INSERT INTO sml_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Pagka llaw kapitu'na na, ah'lling si Musa ma sigām, yukna, “Kakanunbi na pagkakan ya tatau'bi ilu, sabab ya na itu llaw kapitu'na, llaw paghali-hali, llaw mulliya pagta'at ni PANGHŪꞋ. Mbal kam makapuwa' tinapay ma tana' ma llaw itu. ");
INSERT INTO sml_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nnom llaw ya pagtimukbi, sagō' bang ta'abut llaw kapitu'na, ya llaw mulliya pagta'at ni Tuhan, halam aniya' tatimukbi.” ");
INSERT INTO sml_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Na, ya du isab, minsan buwattē' pamituwa si Musa, aniya' saga a'a paluwas min kaluma'an arak animuk kinakan ma llaw kapitu', sagō' halam to'ongan aniya' tabāk. ");
INSERT INTO sml_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Angkan amissala PANGHŪꞋ ma si Musa, yukna, “Ka'am saga bangsa Isra'il, sumiyan kam pahali anagga' saga sara' panoho'anku? ");
INSERT INTO sml_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Entomunbi, aku si Yawe ya amat'nna'an ka'am llaw mulliya itu pagta'atbi ma aku. Ya he' sababna angkan kam buwananku pagkakan nilipat duwa ma llaw ka'nnomna bo' makasarangan ka'am duwang'llaw. Subay kam patotog ma luma'bi ma llaw kapitu'na, da'a kam magluwas-luwas.” ");
INSERT INTO sml_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Manjari pahali-hali saga a'a Isra'il inān ma llaw kapitu'na. ");
INSERT INTO sml_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ya pangōn saga bangsa Isra'il ma tinapay inān manna. Luwana sali' binhi' anahut-nahut walna' pote'. Ahāp nanamna, sali' bāng-bāng lamuran gula' buwani. ");
INSERT INTO sml_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Yuk si Musa ma sigām, “Ya panoho'an PANGHŪꞋ isab, subay tau'ta duwa gantang manna bo' supaya ta'nda' luwana e' panubu'tam magpangkat-mamangkat. Jari kinata'uwan e' sigām ma sinosōng pasal tinapay ya bay pamuwan Tuhan pagkakantam ma lahat paslangan, masa lagi' kapamowana kitam ala'an min lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Yuk si Musa isab ma si Harun, “Angā' ka garapun bo' isihun duwa gantang manna. Pat'nna'un ma matahan PANGHŪꞋ bo' tinau' maina'an pamaentom saga panubu'tam pangkat-mamangkat.” ");
INSERT INTO sml_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Bineya' magtūy e' si Harun panoho'an PANGHŪꞋ itu. Pinat'nna' e'na garapun isihan manna ma dahuan Ba'ul Paljanji'an bo' tinau' pahāp. ");
INSERT INTO sml_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Manjari itu, in bangsa Isra'il inān magkakanan manna na pa'in ma deyom mpatpū' tahun, sampay ni waktu kat'kka sigām ni lahat taga-a'a. Subay bay ta'abut bihing lahat Kana'an bo' yampa sigām pahali amangan. ");
INSERT INTO sml_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Epa ya t'ppongan sigām ma masa awal e', lima gantang ma da-epa.) ");
INSERT INTO sml_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Na, pauntas na saga bangsa Isra'il kamemon min lahat Sīn bo' angalatun lahat, pi'ingga-pi'ingga ya panoho'an PANGHŪꞋ-Yawe ma sigām. Ta'abut pa'in lahat Repidim, pahanti' sigām maina'an sagō' halam aniya' bohe'na ni'inum. ");
INSERT INTO sml_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Jari anoway saga a'a Isra'il ma si Musa. Yuk sigām, “Buwanin kami bohe'.” Anambung magtūy si Musa yukna, “Angay aku panowayanbi? Angay sulayanbi si Yawe?” ");
INSERT INTO sml_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Sagō' atoho' to'ongan k'llong sigām, ya angkan sigām angandugal ma si Musa, yuk-i, “Angay kami bay bowanu ala'an min Misil bo' supaya patay bohe' kami kamemon maka saga ka'anakan kami sampay isab ba'anan hayop kami?” ");
INSERT INTO sml_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Na, pagka buwattē' pah'lling sigām, parahing si Musa ni PANGHŪꞋ angamu' tabang, yukna, “Ya Tuhanku, inayku saga a'a itu? Agon-agon aku pinagbantung e' sigām.” ");
INSERT INTO sml_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Anambag PANGHŪꞋ ma si Musa, yukna, “Pal'ngngan ka parahū min saga a'a ilu. Pabeya'un isab ma ka'a saga kamatto'ahan bangsa Isra'il kasehe'. Bowahun tungkud ya bay pangalubaknu ma sapa' Nīl. Pehē' na ka,” yuk Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","“An'ngge du aku ma matahannu mahē' ma bihing batu lakit ya ma tampalan būd Horeb. Pagt'kkanu pehē', lubakun batu inān maka tungkudnu, ati aniya' bohe' patubud minna'an pamainum saga a'a.” Bineya' e' si Musa panoho'an Tuhan itu ma matahan saga pagmatto'ahan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ya pangōn si Musa ma atag bohe' inān Massa maka Mereba, ma sabab kapamūng-mūng saga bangsa Isra'il maka ma sabab panulayan sigām ma PANGHŪꞋ-Yawe, ya yuk sigām, “Itiya' bahā' si Yawe ma kitam? Atawa halam?” ");
INSERT INTO sml_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Na, ma Repidim pa'in bangsa Isra'il, nirugpak sigām e' saga bangsa Amalek. ");
INSERT INTO sml_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Manjari anoho' si Musa ma si Yussa', ya nakura' sundalu. Yuk si Musa, “Pene'in kitam saga l'lla ati bowahun sigām magbono' maka bangsa Amalek inān. Pagsalung, an'ngge aku ma diyata' būd ilu maka e'ku ang'ntan tungkud ya bay pamuwan aku e' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Bineya' e' si Yussa' panoho'an si Musa he'. Binowa e'na saga a'ana angatu ma bangsa Amalek. Sagō' si Musa maka si Harun, maka sehe' sigām si Hūr, bay patukad ni diyata' būd e'. ");
INSERT INTO sml_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Sat'ggol pina'angkat e' si Musa tanganna karuwambila' anganda'ug saga bangsa Isra'il. Sagō' bang pinareyo', bangsa Amalek ya anganda'ug. ");
INSERT INTO sml_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Manjari itu, ta'abut pa'in angalongkoy tangan si Musa, aniya' batu binowahan iya e' si Harun maka si Hūr pamatingkō'an iya. An'ngge sigām duwangan min bihing si Musa karuwambila' ama'angkat tanganna, manjari atotog sampay pas'ddop mata llaw. ");
INSERT INTO sml_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Na, minnē' tara'ug ba'anan sundalu bangsa Amalek e' disi Yussa'. ");
INSERT INTO sml_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pagubus, amissala PANGHŪꞋ ma si Musa, yukna, “Sulatun pakaradja'an itu bo' mbal takalipat. Pakalehun isab si Yussa', sabab lapnasku bangsa Amalek itu sampay sigām alungay tūy min pangentom manusiya'.” ");
INSERT INTO sml_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Manjari amangkat batu si Musa nihinang pagkulbanan ni Tuhan. Yawe-Nissi ya pangōn si Musa ma pagkulbanan-i, hatina “si Yawe ya Panjiku.” ");
INSERT INTO sml_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Yuk si Musa, “Pat'nggehunbi panji si Yawe. Binantahan e'na saga bangsa Amalek magpangkat-mamangkat.” ");
INSERT INTO sml_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Na si Jetro, ya imam ma lahat Midiyan, mato'a isab si Musa, bay makakale pasal kaheya tabang si Yawe ma disi Musa sampay ma saga bangsana Isra'il. Bay kono' sigām tapaluwas e'na min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Si Jetro itu bay angokoman si Sippura h'nda si Musa maka duwangan anakna, waktu bay kapamapole' iya e' h'llana. Si Gersom ya ōn anakna dakayu' inān. “Sabab,” yuk si Musa, “aku itu a'a liyu ma ngga'i ka lahatku.” ");
INSERT INTO sml_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Si Ele'eser ya ōn anakna pasunu'. “Sabab,” yuk si Musa, “tinabangan aku e' Tuhan ya pagtuhanan mma'ku. Kalappasan aku e'na min pang'ntanan Pira'un waktu iya bilahi amono' ma aku.” ");
INSERT INTO sml_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Manjari, takale pa'in e' si Jetro pasal kahālan si Musa itu, patibaw iya pehē' ni pahanti'an disi Musa, ya ma atag būd Tuhan ma lahat paslangan. Ina'an isab ameya' ma iya h'nda si Musa maka duwangan anakna. ");
INSERT INTO sml_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Aniya' isab tambuku bay pinabeya' e' si Jetro ni si Musa, yukna, “Pi'ilu aku patibaw ni ka'a, beya' isab h'ndanu maka duwangan anaknu.” ");
INSERT INTO sml_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Na, song pa'in at'kka disi Jetro, pehē' si Musa anampang. Pag'nda'na ma mato'ana, magtūy iya paruku'. Aubus, siniyum e'na mato'ana. Magaddat-iyaddati sigā bo' yampa pasōd ni deyom luma' si Musa tolda. ");
INSERT INTO sml_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Sinuli-sulihan si Jetro e' si Musa pasal kamemon bay nihinang e' si Yawe ma Pira'un maka ma a'a Misil kamemon, sabab min lasana ma bangsa Isra'il. Sinuli-suli isab pasal kasigpitan ya kalabayan sigām ma l'ngnganan sigām, maka buwattingga kalappas PANGHŪꞋ-Yawe ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","10","Makakale pa'in si Jetro pasal kahāpan kamemon ya tahinang e' PANGHŪꞋ-Yawe ma saga bangsa Isra'il, kinōgan iya. Yukna, “Pudjita si Yawe, ya bay angalappasan ka'am min komkoman Pira'un maka saga bangsana. Sanglitanta iya, ya bay amaluwas ka'am min pagbanyaga'an. ");
INSERT INTO sml_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kata'uwanku na, akawasa gi' si Yawe min katuhan-tuhanan kamemon ya pagta'atan manusiya', sabab tapareyo' e'na saga a'a Misil ya bay amissoko' ka'am bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Puwas e' aniya' dakayu' hayop binowa e' si Jetro mato'a si Musa panukbal ni Tuhan, tinunu' ma katibu'ukanna. Maka aniya' gi' susumbali'an saddī tinukbal isab. Jari magtipun si Harun maka kamemon saga pagmatto'ahan bangsa Isra'il bo' magjamu maka si Jetro ma matahan Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pag'llaw dakayu', ina'an si Musa analassay palkala' ya binowa ni iya e' saga a'a kamemon. Magabut-abut sigām magtimuk ma sakalibutna min subu-subu sampay ni kasangoman. ");
INSERT INTO sml_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Pag'nda' si Jetro ma hinang si Musa itu abuhat makalandu', yukna ma iya, “Angay ka angkan maghinang buwattilu ma ba'anan a'a ilu! Angay subay ka'a dangan-dangannu ya analassay ba'anan palkala' sigām, maka sigām ya magt'nggehan ma sakalibutnu sampay ni kasangoman?” ");
INSERT INTO sml_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ya sambung si Musa ma mato'ana, “Bapa', angkan buwattitu, sabab aku ya pangaruhan sigām pasal kahandak Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bang aniya' palkala' pagsagga'an sigām sumiyan-sumiyan, aku ya amituwahan sigām pasal sara' maka panoho'an Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yuk si Jetro ma iya, “Ā, mbal taluwa' hinangnu ilu. ");
INSERT INTO sml_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ahusa' makalandu'. Binale' ka sampay saga a'a ya angalagaran ka'a. Mbal takole'nu bang halam aniya' anabangan ka'a. ");
INSERT INTO sml_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Na,” yuk si Jetro isab, “kalehun pahāp, aniya' gara' pangahūganku ka'a, mura-murahan isab bang pa'in pataptap Tuhan ma ka'a. Ka'a ya subay paharap ni Tuhan ganti' saga a'a Isra'il bang aniya' palkala' sigām. Ati pasampayun ba'anan palkala' itu ni Tuhan bo' kinata'uwan bang ai kahandakna. ");
INSERT INTO sml_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Pata'uhun sigām pasal kasara'an maka panoho'an Tuhan. Pandu'in sigām pasal addat-tabi'at ya patut bineya' e' sigām maka hinang ya wajib nihinang. ");
INSERT INTO sml_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Subay ka isab amene' saga a'a min bangsa Isra'il. Ya pene'nu subay a'a taga-pangita'u, a'a magmatāw ma Tuhan, a'a kapangandolan ya mbal katambahan maka sīn. Buwanin sigām kapatut magmakōk ma pagkahi sigām dakompolan, sangpū' ka ma dakompolan, limampū' ka, dahatus ka, atawa dangibu. ");
INSERT INTO sml_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Pat'nna'un sigām analassay palkala' ma saga a'a Isra'il sakahaba' llaw. Sagō' bang palkala' landu' ahunit, ya mbal takole' niusay e' sigām, subay pinasampay ni ka'a. Bang palkala' aluhay-luhay, sigām ya analassay. Minnē' palampung hinangnu pagka aniya' sehe'nu magtabang. ");
INSERT INTO sml_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Na, bang beya'nu gara'ku itu, maka bang panoho'an Tuhan du isab, mbal ka sakit ahusa'. Magpole'an isab ba'anan saga a'a itu ma halam na aniya' makasasaw deyom atay sigām.” ");
INSERT INTO sml_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Manjari bineya' e' si Musa gara' kamemon bay pangahūg mato'ana inān ma iya. ");
INSERT INTO sml_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Tapene' e'na saga l'lla taga-pangita'u min saga bangsa Isra'il. Pinat'nna' sigām magmakōk ma kompolan pagkahi sigām, aniya' magmakōk ma sangpū', aniya' ma limampū', aniya' ma dahatus, aniya' isab ma dangibu. ");
INSERT INTO sml_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Binuwanan sigām kapatut analassay palkala' kahaba' llaw. Bang palkala' aluhay-luhay, sigām ya analassay. Sagō' bang palkala' ahunit, pinasampay ni si Musa. ");
INSERT INTO sml_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na, pinaba'id si Jetro e' ayuwanna si Musa bo' pinatulak amole' ni lahatna. ");
INSERT INTO sml_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Na, makauntas pa'in saga bangsa Isra'il min Repidim, at'kka na sigām ni dakayu' lahat, ōnna Paslangan Turusina. Angahinang sigām paghanti'an maina'an ma deyo'an Būd Turusina. Sahali bulan ya kat'kka sigām pina'an, ma bulan kat'lluna min bay kala'an sigām min Misil. ");
INSERT INTO sml_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Manjari itu patukad si Musa minnē' bo' paharap ni Tuhan, ati nilinganan iya e' si Yawe min būd, yuk-i, “Ya na itu pamissalanu ma saga a'a Isra'il, hatina saga panubu' si Yakub. ");
INSERT INTO sml_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Bay na ta'nda'bi bang ai bay tahinangku ma saga bangsa Misil maka bang buwattingga e'ku bay amowa kam pi'itu ni aku. Ya pamowaku ma ka'am sali' sapantun belle' amowa ba'anan anakna ma pikpikna. ");
INSERT INTO sml_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Na buwattina'an, aniya' pangalapalku ma ka'am. Bang kam ameya' to'ongan ma panoho'anku maka amogbog ma paljanji'anku maka ka'am, na, ka'am ya pene'ku min deyom kabangsa-bangsahan kamemon ma babaw dunya. Manjari ka'am ya palsuku'anku landu' ahalga' ma atayku. Suku'ku asal katilibut dunya itu, ");
INSERT INTO sml_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","sagō' ka'am ya itungku bangsaku sussi maka tubu'an kaimaman maghinang ma aku.’ Na,” yuk Tuhan, “ya du ilu lapal-kabtangan ya pamissalanu ma saga a'a Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Manjari palūd si Musa minnē' ati soho'na patimuk saga pagmatto'ahan bangsa Isra'il. Makatimuk pa'in, pinasampay e'na ni sigām saga lapal-kabtangan kamemon ya sinō' e' Tuhan pangahakana ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Na, dauyunan saga a'a Isra'il inān kamemon ati anambung sigām magsama-sama. “Beya' kami ai-ai panoho'an si Yawe ma kitam.” Jari pinasampay e' si Musa ni PANGHŪꞋ-Yawe ya panambung sigām. ");
INSERT INTO sml_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Angallam gi' PANGHŪꞋ-Yawe ma si Musa, yukna, “Pi'ilu aku ni ka'a min gabun magdo'om-do'om bo' supaya takale suwalaku e' saga a'a ilu hinabuku magsuli-suli maka ka'a. Ati tabowa sigām am'nnal to'ongan ma ka'a sampay ni kasaumulan.” Angahaka isab si Musa ma PANGHŪꞋ pasal bay pah'lling saga a'a he', ");
INSERT INTO sml_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ati amissala PANGHŪꞋ ma iya, yukna, “Pehē' na ka ni saga a'a ilu. Pasuku'un sigām ma aku llaw itu maka salung. Soho'un sigām angandakdakan saga badju' sigām, ");
INSERT INTO sml_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","bo' supaya sigām asakap pagabut simuddai. Sabab simuddai ya llaw katulunku ni būd Turusina ma pang'nda' sigām kamemon. Si Yawe aku, ya Tuhan-asal-Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Angallam gi' Tuhan-i. “Pat'nna'un gindan,” yukna, “bo' aniya' pangahāran saga a'a, maka soho'un sigām kamaya'-maya'. Subay halam aniya' min sigām paliyu minna'an bo' patukad ni būd atawa pa'abut ni deyo'anna. Bang ganta' aniya' a'a pa'abut atawa pagi'ik ni būd itu, subay iya pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ya pamapatay ma iya subay batu atawa pana', mbal iya makajari ni'ntanan maka tangan. Ai na ka manusiya', ai-na ka hayop, bang pa'abut ni būd, mbal manjari pinasagaran allum. Malaingkan, bang takale lling tanduk kambing tiniyup, yampa sigām makajari patukad ni atag būd e'.” ");
INSERT INTO sml_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Puwas e', makalūd pa'in si Musa min būd, pinasuku' e'na ni Tuhan saga a'a Isra'il kamemon ati nirakdakan saga s'mmek sigām. ");
INSERT INTO sml_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Amissala gi' si Musa, yukna, “Subay kam angamomos kamemon bo' kam sakap ma llaw simuddai. Da'a isab kam maghulid l'lla maka d'nda sampay apuwas min llaw ina'an.” ");
INSERT INTO sml_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na, pagsimuddai subu pa'in, aniya' l'ggon maka lāt, maka aniya' gabun magdo'om-do'om ma diyata' būd e'. Aniya' isab tanduk-kambing tiniyup, landu' akosog llingna. Jari magpamidpid min tāw saga a'a kamemon ya ma pustu inān. ");
INSERT INTO sml_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Na, minaliman saga a'a inān e' si Musa, binowa paluwas min atag paghanti'an sigām e' bo' paharap ni Tuhan. Jari ina'an sigām magt'nggehan ma deyo'an būd. ");
INSERT INTO sml_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Aputus Būd Turusina e' humbu sabab bay patulun pina'an si Yawe ma deyom keyat api. Pat'bbud humbu inān buwat humbu min lapohan landu' aheya. Ajogjog isab katibu'ukan būd, akosog jogjogna. ");
INSERT INTO sml_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ya pagtiyup tanduk-kambing inān pasōng na pa'in kosogna, bo' pasōng. Amissala si Musa ati sinambungan iya e' l'ggon, ya na suwala Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ina'an asal si Yawe bay patulun ni puttuk Būd Turusina bo' lingananna si Musa sinō' patukad pehē' ni iya. Jari patukad magtūy si Musa ");
INSERT INTO sml_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","bo' aniya' pah'lling PANGHŪꞋ-Yawe ma iya. Yukna, “Palūd na ka pehē'. Banda'in saga a'a inān subay da'a paliyu min gindan ya pangahāran sigām, minsan buwattingga baya' sigām ang'nda' ma aku. Tantu aheka sigām amatay bang ganta' paliyu. ");
INSERT INTO sml_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Minsan saga imam, ya biyasa pasekot ma aku, subay anussi di-sigām. Bang sigām mbal ameya', pat'kkahanku sigām mulka'.” ");
INSERT INTO sml_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Yuk si Musa ni PANGHŪꞋ, “Mbal makatukad saga a'a Isra'il ni Būd Turusina itu sabab ka'a ya bay anoho' kami amat'nna' jangka'an ma sakalibutna. Būd itu subay nihalli'an bo' minulliya ma ka'a sadja.” ");
INSERT INTO sml_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ya sambung PANGHŪꞋ ma si Musa, “Palūd gi' ka amowa si Harun pi'itu. Sagō' da'a pasagarin saga kaimaman maka ba'anan saga a'a paliyu min jangka'an bo' pi'itu ang'nda' ma aku. Bang sigām makaliyu, pat'kkahanku sigām mulka'.” ");
INSERT INTO sml_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Sakali palūd na si Musa ni deyo'an būd bo' pangahakana ma saga a'a ya lapal Tuhan e'. ");
INSERT INTO sml_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Manjari buwattitu saga lapal-kabtangan ya pamalman Tuhan, ");
INSERT INTO sml_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Aku si Yawe ya Tuhanbi, ya bay amowa ka'am pala'an min lahat Misil, lahat bay pamanyaga'an ka'am. ");
INSERT INTO sml_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Wajib kam da'a magtuhan saddī min aku. ");
INSERT INTO sml_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Wajib kam da'a angahinang tuhan-tuhan angaluwa ai-ai ma diyata' langit, atawa ma gintana'an, atawa ma tahik. ");
INSERT INTO sml_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Wajib kam da'a pasujud atawa anumba ma ba'anan tuhan-tuhan inān, sabab si Yawe aku, ya Tuhanbi. Ab'nsi aku niagawan kapagtuhanku e' sai-sai. Pat'kkahanku katiksa'an sasuku anaikutan aku, papole'ku dusana ni saga anak-mpuna magpangkat-mamangkat sampay ni mpuna kengkeng. ");
INSERT INTO sml_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Sagō' sasuku magmalasa ma aku maka ameya' isab ma panoho'anku, pat'kkaku lasaku tuman ma saga anak-mpuna sampay ni saga panubu'na magibu-ibuhan pangkat. ");
INSERT INTO sml_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Wajib kam da'a anabbut ōn si Yawe ya pagtuhananbi ma halam aniya' pūsna tantu, sabab itungku taga-dusa sasuku anabbut ōnku ma halam kapūsanna. ");
INSERT INTO sml_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Bogboginbi Llaw Paghali, pagka Llaw Mulliya tudju ni aku. ");
INSERT INTO sml_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Makajari kam maghinang atawa magusaha ma deyom nnom llaw, ");
INSERT INTO sml_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","sagō' ya llaw kapitu'na wajib pinagmulliya pamudjibi ma aku ya Tuhanbi si Yawe. Subay halam aniya' ma ka'am maghinang ai-ai ma llaw ina'an-i. Ai na ka ka'am baranbi, ai-na ka ka'anakanbi, ai-na ka ipatanbi d'nda-l'lla, ai-na ka hayopbi, subay to'ongan pahali maghinang. Minsan a'a bangsa liyu ya pahanti' ma luma'bi, subay mbal isab maghinang. ");
INSERT INTO sml_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kalna' aku si Yawe ya Tuhanbi. Nnom llaw ya bay pamapanjariku langit maka dunya maka tahik, sampay kamemon isina. Sagō' ta'abut pa'in llaw kapitu'na, pahali na aku maghinang. Angkan minulliya e'ku llaw inān, nihinang llaw pamaheyabi ma aku. ");
INSERT INTO sml_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Pagaddatinbi ina'-mma'bi bo' supaya ataha' pangumulanbi ma lahat ya pamuwan ka'am e' si Yawe ya Tuhanbi. ");
INSERT INTO sml_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Wajib kam da'a amono' ma pagkahibi manusiya'. ");
INSERT INTO sml_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Wajib kam da'a magjina. ");
INSERT INTO sml_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Wajib kam da'a anangkaw. ");
INSERT INTO sml_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Wajib kam da'a anaksi' puting pasal pagkahibi manusiya'. ");
INSERT INTO sml_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Wajib kam da'a anganapsuhan luma' pagkahibi. Da'a kanapsuhinbi ai-ai suku' pagkahibi, ai-na ka h'ndana, ai-na ka ipatanna d'nda-l'lla, ai-na ka sapi'na atawa kura'na.” ");
INSERT INTO sml_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Na, magpamidpid min tāw ba'anan a'a Isra'il, pagka takale e' sigām l'ggon maka tanduk-kambing pinagtiyup pakosog. Ta'nda' isab e' sigām lāt maka būd angahumbu. Angagad sadja sigām min kalawakan. ");
INSERT INTO sml_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Yuk sigām ma si Musa, “Bang pa'in ka'a sadja ya amissala ma kami, ati pakale du kami. Sagō' da'a papagsuwalahun Tuhan ni kami, sabab makapatay ko' inān.” ");
INSERT INTO sml_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Yuk si Musa ma sigām, “Da'a kam tināw. Sinulayan sadja kam e' Tuhan bang buwattingga pameya'bi ma iya. Kabaya'anna ma ka'am subay magmatāw ma iya supaya kam mbal makapagdusa.” ");
INSERT INTO sml_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Jari angagad-ngagad gi' saga a'a kamemon inān min kalawakan. Luwal si Musa ya pasekot ni atag karo'om-do'oman ya patulunan Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Sakali amalman gi' PANGHŪꞋ-Yawe ma si Musa, yukna, “Palatunun palmanku itu ni saga bangsa Isra'il. Ya yuknu, ‘Kasaksi'anbi na in aku bay ah'lling ni ka'am min diyata' langit. ");
INSERT INTO sml_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Da'a pagtuhaninbi saga ta'u-ta'u ya hinangbi min pilak atawa min bulawan. Subay halam aniya' pagtuhananbi saddī min aku. ");
INSERT INTO sml_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Ya pangarapanbi ma aku subay tana' pinagtambak. Maina'an ya pangulbananbi saga bili-bilibi maka kambing maka sapi' ya sumbali'bi bo' tinunu' ma katibu'ukanna. Maka maina'an isab ya pagduwa'ahanbi salamat. Maingga-maingga lugal ya pene'ku panabbutanbi ōnku, pi'ilu du aku amuwanan ka'am kahāpan. ");
INSERT INTO sml_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bang kam saupama anambak batu pangarapanbi ma aku, subay batu halam bay pinagsapsapan, sabab batu bay kasapsapan asammal ma aku. ");
INSERT INTO sml_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Lāgi, da'a kam angahinang haronan pariyata'anbi ni tambak batu ilu, sabab ta'nda' harapanbi hinabubi pariyata'.’ ” ");
INSERT INTO sml_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Na, angallam gi' Tuhan ma si Musa yukna, “Itiya' na ba'anan sara' panoho'anku ya subay palatunnu ni saga a'a Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Yuk Tuhan, “Bang kam am'lli pagkahibi bangsa Hibrani nihinang ata, ya t'ggolna maghinang ma ka'am subay mbal palabi min nnom tahun. Ta'abut pa'in tahun kapitu'na subay iya paluhaya'unbi ma halam aniya' bayadna. ");
INSERT INTO sml_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Bang ata halam taga-h'nda ma waktu kasōdna ni pangipatannu, patut iya dangan-danganna pinaluhaya. Damikiyanna bang ata bay makabowa h'nda, subay amowa h'ndana isab ma waktu kaluwasna. ");
INSERT INTO sml_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Bang aniya' isab ata bay pinah'nda'an e' a'a pa'atahanna, ati aniya' anakna d'nda-l'lla minnē', in anak-h'ndana inān subay taitung suku' a'a pa'atahanna he'. Hal iya dangan-danganna pinaluwas. ");
INSERT INTO sml_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Malaingkan, bang ata inān magsubali in iya alasa ma a'a pa'atahanna sampay ma saga anak-h'ndana, ati mbal bilahi pinaluhaya min pagatahanna, na buwatittu hatulanna: ");
INSERT INTO sml_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","in a'a inān subay binowa e' nakura'na ni lugal paghukuman. Maina'an pa'in, subay iya pinabihing e' nakura'na ni tambol lawang atawa ni hāgna ati bo' nilowangan taingana. Pagka buwattē', tattap na iya maghinang ma a'a pa'atahanna inān sat'ggolna allum. ");
INSERT INTO sml_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Na, bang aniya' a'a amab'llian anakna budjang nihinang ata, in d'nda inān mbal tapaluhaya buwat ata l'lla. ");
INSERT INTO sml_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Bang iya mbal makasulut nakura'na ya bay arak angā' iya h'nda, in matto'a d'nda he' subay binuwanan lawang angal'kkat iya min pagatahan. Halam aniya' kapatut ma a'a paipatanna amab'llian iya ni a'a bangsa saddī, sabab kabalubahan bay janji'na ma iya. ");
INSERT INTO sml_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Bang saupama aniya' a'a am'lli dakayu' budjang pamah'ndana ma anakna, ya addatna tudju ni iya subay dasali' maka addatna ni anakna lissi. ");
INSERT INTO sml_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Bang a'a isab magh'nda'an atana d'nda, bo' aniya' gi' d'nda saddī pagkalu'ana, in h'ndana po'on inān mbal manjari siniya-siya. Subay iya binuwanan ai-ai kapatutna, hatina pagkakan, pan'mmek, paghulid maka h'llana. ");
INSERT INTO sml_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Bang l'lla inān mbal ganta' amuwanan iya ai-ai kapatutna, na, subay iya paluhayana ma halam aniya' bayadna. ");
INSERT INTO sml_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Sasuku angala'ugan pagkahina bo' amatay, a'a inān wajib subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sagō' bang halam taniyat e' a'a makabono' inān, tu'ud ganta'anna min Tuhan, subay iya alahi ni lahat patapukan ya song pene'anku ka'am (Tuhan ya ah'lling). ");
INSERT INTO sml_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Sagō' bang a'a anganiyat amapatay a'a dangan bo' tapapatayna, a'a inān subay pinapatay minsan iya amalut ma tampat pagkulbanan ma aku. La'aninbi iya minnē', papatayhunbi. ");
INSERT INTO sml_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Sai-sai angala'ugan mma'na atawa ina'na subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Sai-sai ta'abut bay anaggaw pagkahina manusiya' subay pinapatay. Minsan wa'i pinab'llian a'a bay tasaggawna he', atawa minsan isab masi ma deyomanna, subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Sai-sai anukna'an mma'na atawa ina'na subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Bang aniya' duwangan a'a maglugat bo' dangan ya angala'ugan sehe'na, buwat saga anuntuk atawa am'ppok iya maka batu, a'a inān mbal kasā'an luwal bang amatay sehe'na he'. Bang iya hal tabowa palege ma pabahakanna, bo' makabungkal du sampay makal'ngngan na ma luwasan luma' minsan magtungkud-tungkud, na, ya a'a bay angala'ug inān subay pina'atas amayaran ai-ai pagtambal iya sampay kauli'an to'ongan. Subay pina'atas isab angangganti' usahana sat'ggolna mbal makausaha. ");
INSERT INTO sml_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Bang aniya' a'a angalubakan atana d'nda atawa l'lla, bo' amatay magtūy, subay iya sinā'an. ");
INSERT INTO sml_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sagō' bang ata inān mbal amatay sagō' palege sadja saga duwa ni t'llung'llaw bo' yampa makabungkal, in a'a bay makalubak mbal kasā'an sabab atana asal, suku'na. ");
INSERT INTO sml_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Bang aniya' saga a'a magsuntuk, bo' aniya' d'nda ab'ttong talapay ati tabowa anganak ma mbal gi' bulananna, sagō' mbal ainay baranna, buwattitu hatulanna: ya a'a bay anganjudjal d'nda he' subay pinaluwasan pangandiyat, pila-pila ya kabaya'an h'llana, bang pa'in da'a palabi min diyat ya pangahād e' saga kahuwisan. ");
INSERT INTO sml_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Malaingkan bang d'nda ilu pali'an aheya, ya pangandiyat subay pinapagtongod maka pali'na. Bang pali' makamatay, kamatay ya pangandiyat. ");
INSERT INTO sml_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Bang mata ya magka'at subay mata isab pangandiyat. Bang empon subay empon, bang tangan subay tangan, bang tape' subay isab tape'. ");
INSERT INTO sml_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Bang tunu', subay tunu', bang bakat subay bakat, bang alom subay alom. ");
INSERT INTO sml_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","“Bang aniya' a'a angala'ugan atana, l'lla ka atawa d'nda, bo' magka'at matana atawa emponna, in atana inān subay pinaluhaya paluwas min pagatahanna. Ya he' pangandiyat ma matana atawa emponna. ");
INSERT INTO sml_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Bang aniya' a'a amatay tinanduk e' sapi' mandangan, ya sapi' inān subay binantung sampay amatay. Isina mbal manjari kinakan, sagō' tag-dapu mbal taluwa' sinā'an. ");
INSERT INTO sml_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Malaingkan bang sapi' he' panananduk asal, bo' halam bay sinasak atawa niengkotan e' tag-dapu minsan bay kasanggupan, na, saddī hatulanna. Bang sapi' panananduk ya makapatay a'a, subay binantung. Maka tag-dapuna subay pinapatay isab. ");
INSERT INTO sml_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Malaingkan bang bilahi saga usba-waris a'a ya patay tanduk e', in tag-dapu sapi' makajari amuwan kasā'an ganti' baranna supaya mbal pinapatay, pila-pila ya niamu' e' sigām. ");
INSERT INTO sml_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Buwattē' du isab bang onde'-onde' l'lla atawa d'nda ya amatay tinanduk e' sapi'. ");
INSERT INTO sml_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bang aniya' isab ata a'a amatay e' sapi', ata l'lla ka atawa ata d'nda, ya tag-dapu sapi' he' subay amayad t'llumpū' pilak tibu'uk. ");
INSERT INTO sml_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Bang a'a angala'anan tambol min lowang pagbohe'an, atawa a'a bay angahinang lowang aheya bo' halam bay tambunanna, buwatittu hatulanna: bang aniya' hayop, sapi' ka atawa kura', ahūg pareyom, ");
INSERT INTO sml_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","a'a inān subay amayaran a'a tag-dapu hayop e'. Jari suku' na ma iya in patay hayop e'. ");
INSERT INTO sml_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Bang aniya' sapi' l'lla ya suku' a'a dangan ananduk sapi' l'lla dakayu' bo' amatay, na buwattitu hatulanna: ya sapi' allum subay pinab'llihan ati b'llihanna subay binahagi' duwa ma duwangan tag-dapu he'. Ya du isi sapi' amatay he', subay binahagi' duwa. ");
INSERT INTO sml_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Arapun, bang kinata'uwan in sapi' he' panananduk asal, bo' halam bay sinasak atawa niengkotan e' tag-dapuna, a'a inān subay angangganti'an sapi' amatay. Jari suku' na ma iya patay hayop e'.” ");
INSERT INTO sml_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Angallam gi' Tuhan yukna, “Bang aniya' a'a makatangkaw sapi' atawa bili-bili bo' sinumbali' e'na atawa pinab'llihan, na, buwattitu hatulanna: a'a inān subay pinat'nna'an kasā'an. Bang dakayu' du sapi' bay tatangkawna, subay sapi' lima hekana ya pangangganti'na ni a'a bay panangkawan. Bang dakayu' du bili-bili, subay mpat bili-bili isab ya pangangganti'na. ");
INSERT INTO sml_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Bang aniya' pananangkaw ta'abut parumpās ni deyom luma' a'a waktu sangom bo' binono' pinapatay, mbal karusahan a'a bay makabono' iya. ");
INSERT INTO sml_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Sagō' bang aniya' pananangkaw ta'abut ma waktu llaw bo' yampa binono' pinapatay, a'a makabono' inān subay katōngan dusa sabab pagtu'uranna amapatay. Ai-ai tinangkaw subay ginanti'an e' a'a bay makatangkaw, sagō' bang halam ai-aina pangangganti', in iya baranna subay pinab'llihan nihinang ata, ati b'llihanna ya pangangganti' ma a'a katangkawan. ");
INSERT INTO sml_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Bang aniya' dakayu' hayop tinangkaw, bo' tabāk ma komkoman panangkaw ma halam bay ni'inay, ya panangkaw inān subay amayad nilipat duwa. Hatina bang dakayu' sapi' atawa kura' atawa bili-bili ya tinangkaw, subay duwa hekana ya pamayad. ");
INSERT INTO sml_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Bang a'a magpakan saga hayopna ma tana' atawa ma kabbun bo' halam jagahanna pahāp ati wa'i pehē' saga hayop amangan pananom ma huma a'a saddī, na buwattitu hatulanna. Ya pangangganti' tinanom magka'at e' subay pananom landu' ahāp min huma tag-dapu hayop e'. ");
INSERT INTO sml_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Bang aniya' angandokot api ma tana'na, bo' pasuleyab keyatna ni s'ggit sampay talapay tatunu' saga tinanom maka anihan ya suku' a'a dakayu', na, buwattitu hatulanna: ya a'a makarokot tunu' inān subay angangganti' ai-ai bay magka'at. ");
INSERT INTO sml_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Bang aniya' a'a amatau' sīn atawa alta' ma sehe'na, ati tatangkaw min luma' pagtatau'an inān, na, buwattitu hatulanna. Bang tasaggaw a'a bay makatangkaw, ya kasā'an ma iya subay halga' alta' inān nilipat duwa. ");
INSERT INTO sml_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Sagō' bang mbal tabāk a'a bay makatangkaw, ya a'a pagtau'an alta' inān subay binowa ni lugal paghuwisan bo' pinariksa' pahāp bang iya ya bay angā' alta' he'. ");
INSERT INTO sml_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Tiyap-tiyap aniya' palkala' pasal pagdapu alta', ai-na ka sapi', ai-na ka kura', ai-na ka bili-bili, minsan isab badju' atawa ai-ai bay tapuwa', na, buwattitu hatulanna. Duwangan a'a magdapuhan alta' inān subay binowa ni paghuwisan bo' sinalassay palkala' sigām. Manjari ya a'a taluwa' hukuman saga huwis e' subay pinat'nna'an kasā'an. Ya pamayadna ma a'a dangan subay halga' alta' inān nilipat duwa. ");
INSERT INTO sml_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Bang aniya' a'a amatau' hayopna ma sehe'na, buwat saga sapi'na, kura'na atawa bili-bilina, bo' amatay atawa kapali'an ma pagtau'an, atawa sinaggaw e' a'a saddī, na, buwattitu hatulanna. ");
INSERT INTO sml_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ya a'a bay pangandolan subay pinasapa ma matahan si Yawe, in iya halam bay makainay hayop inān. Maka tag-dapu hayop inān subay ameya' sadja ma panapa sehe'na he'. Puwas isab iya min kasā'an pagka buwattē' sapana. ");
INSERT INTO sml_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Sagō' bang hayop inān tatangkaw hinabuna ma deyoman a'a kapangandolan e', na, a'a inān subay angangganti' sabab iya ya bahala'. ");
INSERT INTO sml_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Bang saupama hayop inān bay magka'at e' sattuwa, ya kapin patayna subay binowa pina'nda'an ni huwis. Jari mbal iya sinō' angangganti'. ");
INSERT INTO sml_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Bang a'a angindam hayop bo' amatay atawa kapali'an ma halam maina'an tag-dapuna, hayop inān subay ginanti'an e' a'a bay angindam. ");
INSERT INTO sml_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Sagō' bang maina'an asal tag-dapu hayop e', mbal pinaganti' a'a bay makaindam. Ya balikna, bang hayop inān bay sinukayan, subay mbal pinaganti' a'a bay anukay he'. Panukayna ya taitung bayadna.” ");
INSERT INTO sml_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Bang a'a amidjakan budjang magbihing maka iya, bo' budjang inān halam gi' taga-tunang, ya l'lla inān subay pinabayad ungsud. Manjari h'ndana na. ");
INSERT INTO sml_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Sagō' bang mbal angaho' matto'a d'nda itu maka mbal tabowa magsulut, na, mbal nilanjalan pagkawin. Ya l'lla inān subay amayad kasā'an, pila-pila ya kataluwa'an pangungsud budjang. ");
INSERT INTO sml_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“D'nda maghihinang pantak atawa palkata'an subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Sasuku magd'nda maka hayop subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Sasuku magkulban atawa magtukbal ai-aina tudju ni pagtuhanan saddī min aku si Yawe, a'a inān subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Bang aniya' a'a bangsa liyu pat'nna' ma lahatbi, da'a jahulaka'unbi sabab bangsa liyu isab kam waktu bay kapaglahatbi ma lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Da'a kam angakkal ma balu d'nda atawa aniya-niya ma anak ilu'. ");
INSERT INTO sml_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bang sigām ganta' tala'atbi bo' angamu'-ngamu' ni aku, tantu sigām tabangku. ");
INSERT INTO sml_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Apasu' atayku sampay amat'kkahan ka'am mulka'. Pasagaranta kam binono' e' saga bantabi, manjari tabalu h'ndabi, tailu' anakbi. ");
INSERT INTO sml_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Bang kam magpautang sīn ma a'a miskin ya pagkahibi bangsa Isra'il, da'a anakinbi sīn he'. Da'a kam anengoran saga a'a ya magusaha'an sīn. ");
INSERT INTO sml_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Bang a'a isab angutang sīn ni ka'am bo' ananda' jubana, juba ilu subay tinūran ni iya kahaba' kohap, song pa'in pas'ddop llaw. ");
INSERT INTO sml_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Sababna halam aniya' pak'mmosna saddī. Bang mbal tūrannu ati angamu' iya tabang ma aku, tantu iya kaleku sabab ma'ase' asal aku. ");
INSERT INTO sml_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Da'a to'ongan kam ah'lling pangkal pasal Tuhan. Da'a kam anukna'an pagbebeya'anbi bangsa Isra'il isab. ");
INSERT INTO sml_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Panukbalinbi aku min tinanom ya ta'anibi, maka min bohe' anggul ya tap'gga'bi. Da'a kam atakal. “Pamasuku'unbi ma aku anakbi l'lla siyaka. ");
INSERT INTO sml_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ya du isab saga anak l'lla ya dahū pinaganakan ma ba'anan hayopbi. Ai na ka anak sapi', ai-na ka anak bili-bili, ai-na ka anak kambing, subay pamasuku'bi isab ma aku. Dapitu' ya pamaruru'bi ma ina'na, sagō' ta'abut pa'in llaw kawalu'na, subay pagkulbaninbi aku. ");
INSERT INTO sml_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ka'am ya bangsa palsuku'anku, angkan kam mbal makajari amangan isi hayop bay takeket e' sattuwa talun. Gom pa'in timaninbi pagkakan saga ero'.” ");
INSERT INTO sml_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Da'a kam amasaplag suli-suli ma halam aniya' kab'nnalanna. Da'a kam anaksi' puting ma munda'an sara' pangandapitbi ma a'a ala'at jaguni'na. ");
INSERT INTO sml_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Da'a kam ameya' maghinang kala'atan ma saukat ya he' kahinangan kaheka'an. Da'a kam pauyun anaksi' puting ma kaheka'an a'a ma munda'an sara'. ");
INSERT INTO sml_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Da'a bogboginbi a'a miskin bang tinandanan ni sara' ma saukat miskin iya, luwal bang abontol panganda'awana. ");
INSERT INTO sml_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Bang kam makalanggal sapi' atawa kura' bay makapuwas min engkotna, subay tūranbi magtūy ni tag-dapuna, minsan iya bantabi. ");
INSERT INTO sml_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Damikiyanna isab bang aniya' ta'nda'bi kura' mbal makat'ngge pagka kabuhatan e' duwa'anna, da'a pasagarinbi. Tabanginbi tag-dapuna minsan ya a'a kab'nsihannu asal. ");
INSERT INTO sml_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Da'a pabengkokunbi hukuman ma a'a miskin bang aniya' palkala'na ma sara'. Pabontolunbi sadja. ");
INSERT INTO sml_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Bang aniya' pagtuna' ngga'i ka b'nnal, da'a kam palamud. Da'a kam amat'nna' hukuman kamatay ma a'a halam aniya' sā'na atawa dusana. Sabab mbal papuwasku a'a min dusana bang iya amat'nna' hukuman abengkok. ");
INSERT INTO sml_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ka'am saga a'a amal'ngngan sara', da'a kam anambut tatambahan min a'a pinahukum ma ka'am. Sabab minsan sara' abontol, bang pagkatambahan mbal ahāp e'na angusay palkala'. Nirusta' e'na a'a abontol minsan b'nnal saksi'na. ");
INSERT INTO sml_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Bang aniya' a'a bangsa liyu pat'nna' ma lahatbi, da'a jahulaka'unbi, sabab bangsa liyu isab kam, waktu bay kapaglahatbi ma lahat Misil.” ");
INSERT INTO sml_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Nnom tahun subay pagtanombi kahuma-huma'anbi maka paganibi isab saga buwa'na. ");
INSERT INTO sml_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Sagō' ta'abut pa'in tahun kapitu'na, in tana' inān subay pinasagaran na ma deyom dantahun e'. Da'a araruhunbi, da'a isab tanominbi. Jari ai-ai atomo'an di-na subay pamuwanbi ma saga pagkahibi miskin. Maka ai-ai halam takakan e' sigām, pagkakan saga sattuwa talun na. Buwattē' du isab ya saga po'onanbi anggul maka saga kakayuhanbi jaitun, subay pinasagaran pagkakan saga a'a miskin. ");
INSERT INTO sml_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Maghinang kam ma deyom nnom llaw, sagō' ta'abut pa'in llaw kapitu'na subay kam pahondong maghinang. Minnē' aniya' llaw pamahali saga sapi'bi maka saga kura'bi, sampay isab saga atabi maka a'a bangsa liyu ya paokom ma ka'am. Jari pahāp palasahan sigām pabīng. ");
INSERT INTO sml_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Beya'unbi pahāp kamemon ya panoho'anku itu ma ka'am. Amay-amay, da'a ta'atunbi saga pagtuhanan saddī min aku. Minsan ōn sigām subay mbal sabbutbi.” ");
INSERT INTO sml_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Angallam gi' Tuhan, yukna, “Subay t'llu paghinang ya isbatbi na pa'in pamaheyabi ma aku ma deyom dantahun. ");
INSERT INTO sml_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Kaissana, Paghinang Tinapay Halam Pasuligna. Hinangunbi paghinang itu ma bulan Abib, sabab ya na he' bulan bay kala'anbi min lahat Misil. Ma deyom pitung'llaw ya kapaghinangbi ma hinang itu subay tinapay halam taga-pasulig ya pagkakanbi, buwat bay panoho'anku ma ka'am. “Ebot-ebot, bang kam angarap ni aku sumiyan-sumiyan, subay kam amowa tutukbalan. ");
INSERT INTO sml_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Karuwana, Paghinang Anihan Dahū, ya pinaghinang ma waktu paganibi saga buwa' tinanom ya dahū ajatu. “Kat'lluna, Paghinang Anihan Damuli, ya pinaghinang song pa'in waktu paghaggut, waktu pagtimukbi kamemon saga buwa' tinanom. ");
INSERT INTO sml_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Manjari t'llu waktu ma deyom dantahun ya pangarap kamemon saga kal'llahanbi ma matahan si Yawe ya panghū'bi.” ");
INSERT INTO sml_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Yuk Tuhan isab, “Bang kam magkulban susumbali'an, da'a pabeya'unbi pagkakan ai-ai taga-pasulig. Da'a tau'unbi lanab min kukulbanan kakanbi salung. ");
INSERT INTO sml_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Bang kam anagna' magani tinanom atawa magpusu' buwa' kayu, pene'unbi ya ahāp to'ongan bo' bowahunbi ni Luma' Pangarapan ni si Yawe ya Tuhanbi. “Bang kam anumbali' anak kambing bo' b'llabi, da'a lamurinbi gatas ina'na.” ");
INSERT INTO sml_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Angallam gi' Tuhan, yukna, “Na! Itiya' soho'ku dakayu' mala'ikat anganjagahan ka'am ma l'ngngananbi, ati pinasampay kam e'na ni lahat ya tagamahanku ka'am. ");
INSERT INTO sml_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kalehunbi bissalana, beya'unbi isab panoho'anna. Da'a iya sagga'unbi sabab tantu kam mbal niampun e'na pagka ina'an ma iya kawasaku. ");
INSERT INTO sml_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Bang iya kalebi pahāp, maka bang beya'bi kamemon panoho'anku ma ka'am, bantahanku sasuku amantahan ka'am, atuhanku isab sasuku angatu ma ka'am. ");
INSERT INTO sml_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Parahū min ka'am mala'ikatku bo' kam tabowana tudju ni lahat ya paglahatan saga bangsa Amor, bangsa Hīt, bangsa Pirissi, bangsa Kana'an, bangsa Hīb maka bangsa Jibus. Pahalamku saga bangsa inān kamemon. ");
INSERT INTO sml_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Da'a kam pasujud atawa magsumba ma pagtuhanan saga bangsa inān, da'a kam palamud ma kahinangan sigām. Paka'atunbi to'ongan saga ta'u-ta'u ya pagtuhanan sigām, podjakunbi isab saga batu paosol ya minulliya e' sigām. ");
INSERT INTO sml_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ta'atunbi aku, ya Tuhanbi Yawe. Jari buwananku kahāpan ma pagkakanbi maka ma paginumbi. Mbal kam kat'kkahan saki. ");
INSERT INTO sml_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Halam isab aniya' d'nda kapakpakan ma sakalibut lahatbi, anganak sigām kamemon. Pataha'ku isab umulbi kamemon. ");
INSERT INTO sml_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Parahū aku min ka'am amakitāw saga kabangsa-bangsahan ya talanggalbi ma lahat inān. Palengogku pikilan sigām supaya sigām mbal maka'atu ma ka'am, gom pa'in sigām pataikut bo' maglahian. ");
INSERT INTO sml_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Bowaku saga bangsa Hīb, saga bangsa Kana'an maka saga bangsa Hīt magla'anan min dahuanbi, buwat sapantun a'a pinagkeket e' tabungay. ");
INSERT INTO sml_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Sagō' mbal pala'anku saga a'a inān kamemon ma deyom dantahun sabab ariki' gi' puhu'bi. Bang sigām ganta' tinighan pinala'an, tantu kam mbal makagaga. Ap'nno' kahuma-huma'anbi e' s'ggit-man'ggit, maka paheka na pa'in ba'anan saga sattuwa talun angala'at ka'am. ");
INSERT INTO sml_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pala'anku saga bangsa inān painut-inut sampay kam paheka na, bo' kam makapagbaya' ma lahat e'. ");
INSERT INTO sml_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Manjari,” yuk Tuhan, “paluhaku lahat ya pamasuku'ku ma ka'am. Tinagna'an min Tahik Keyat sampay ni Tahik Pilistin, min lahat paslangan isab tudju ni sapa' Alpurati. Nde'anku isab ni pagbaya'anbi saga kabangsa-bangsahan ya pat'nna' mahē'. Jari bang ta'abut na waktuna, ka'am ya an'ggal paluwas min lahat e'. ");
INSERT INTO sml_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Da'a kam amiha pagsulutan maka saga bangsa inān atawa pagtuhanan sigām. ");
INSERT INTO sml_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Da'a pasagarinbi saga bangsa inān magdalahat maka ka'am bo' kam mbal tabowa-bowa e' sigām angahinang dusa ni aku. Tantu kam tajallat palamud anumba saga pagtutuhanan sigām.” ");
INSERT INTO sml_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Sakali itu, angallam gi' PANGHŪꞋ-Yawe ma si Musa, yukna, “Patukad ka ni aku. Pabeya'un isab si Harun maka duwangan anakna si Nadab maka si Abihu, sampay saga pagmatto'ahan bangsa Isra'il pitumpū' hekana. Kaheka'anbi ilu subay anumba ni aku min katāhan. ");
INSERT INTO sml_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ka'a Musa, subay dangan-dangannu sadja makasekot pi'itu ni aku. Mbal makasekot saga sehe'nu ilu. Ya du saga a'a Isra'il inān, mbal isab makabeya' ma ka'a patukad ni diyata' būd itu.” ");
INSERT INTO sml_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Na, palūd pina'an si Musa angahaka ni kaheka'an a'a inān pasal saga sara' maka panoho'an kamemon bay pamalman e' PANGHŪꞋ-Yawe. Pagkale sigām, magtūy sigām magdauyun anambung, yuk-i, “Beya' kami ya pamalman e' si Yawe ilu.” ");
INSERT INTO sml_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Manjari tasulat e' si Musa saga sara' panoho'an PANGHŪꞋ inān kamemon. Pagdai' llaw pa'in, abati' na si Musa bo' paluwas anambak batu ma bihing būd, nihinang pagtukbalan kulban. Angosol isab iya saga batu sangpū' maka duwa hekana pamandogahan sangpū' maka duwa bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pagubus, magpanoho'an si Musa ma saga onde' baha'u bangsa Isra'il. Sinō' sigām pina'an anukbal kulban ni PANGHŪꞋ, saga susumbali'an tinunu' ma katibu'ukanna. Aniya' isab saga anak sapi' l'lla tinukbal e' sigām pagduwa'a salamat. ");
INSERT INTO sml_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Sinalud e' si Musa laha' bay sinumbali' he'. Santonga' ni'isi e'na ni saga pinggan aheya, santonga' isab pinigsikan ni lugal pagkulbanan e'. ");
INSERT INTO sml_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Puwas e' niā' e' si Musa Sulat Paljanji'an bo' binassa patanog ma saga ummat inān. Ya panambung sigām, “Beya' kami ai-ai bay pamalman e' si Yawe, bogbogan kami panoho'anna.” ");
INSERT INTO sml_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Na, pagka buwattē' panambung sigām, niā' e' si Musa saga pinggan bay panaluranna laha' hayop ati pigsikanna ni saga ummat e'. Yuk si Musa, “Laha' itu pamahogot paljanji'an si Yawe, ya pinat'nna'an ka'am labay min saga panoho'anna itu kamemon.” ");
INSERT INTO sml_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Pagubus, patukad na disi Musa, si Harun, si Nadab maka si Abihu ni diyata' būd, tabeya' isab saga pagmatto'ahan bangsa Isra'il pitumpū' hekana. ");
INSERT INTO sml_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ma būd pa'in, ta'nda' e' sigām Tuhan ya pagtuhanan mbo' sigām si Isra'il. Jari aniya' sali' lantay luwa palmata bilu ta'nda' e' sigām ma deyo'an tape'na, dat'llak maka langit. ");
INSERT INTO sml_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Sagō' halam ni'inay e' Tuhan saga pagmakōkan bangsa Isra'il e'. Ta'nda' iya e' mata sigām hinabu sigām magduwa'a salamat. ");
INSERT INTO sml_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Manjari itu ah'lling PANGHŪꞋ pabalik ma si Musa, yukna, “Patukad ka pi'itu ni aku ni diyata' būd itu. Maitu lagi' ka bo' ka buwananku duwa batu amasagi'. Itiya' tasulatku saga panoho'an ya pamandu'ku ma saga ummat ilu.” ");
INSERT INTO sml_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Magtūy magsakap si Musa maka tendogna si Yussa' bo' patukad ni būd Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Yuk si Musa ma saga pagmatto'ahan bangsa Isra'il, “Lagarinbi lagi' kami maitu sampay kami makabīng pi'itu. Ilu mailu ma ka'am si Harun maka si Hūr. Sigām ya analassay bang aniya' palkala'bi.” ");
INSERT INTO sml_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Na, makatukad pa'in si Musa, katambunan Būd Turusina e' gabun. ");
INSERT INTO sml_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Patulun isab sahaya si Yawe ni pussuk būd e'. Jari animpus gabun inān nnom llaw t'ggolna. Ta'abut pa'in pitung'llaw, angalingan PANGHŪꞋ-Yawe ma si Musa min deyom gabun. ");
INSERT INTO sml_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Malaingkan in sahaya si Yawe sali' tunu' aheya makalandu' bang ma pang'nda' saga bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Manjari itu, patukad na si Musa bo' pasōd ni deyom gabun, ati mpatpū' bahangi ya kat'nna'na ma diyata' būd e'. ");
INSERT INTO sml_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Jari mahē' pa'in ma diyata' būd, angallam PANGHŪꞋ-Yawe ma si Musa, yukna, ");
INSERT INTO sml_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Soho'un saga bangsa Isra'il amowahan aku huhulmatan. Sambutun ai-ai pamuwan e' sigām bang pa'in hilas min deyom pangatayan sigām dangan maka dangan. ");
INSERT INTO sml_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Buwattitu saga huhulmatan ya patut sambutnu min saga a'a inān: bulawan, pilak maka tumbaga, ");
INSERT INTO sml_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","salban walna' bilu, taluk maka keyat, kakana' pote' ahāp hinanganna, maka bulbul kambing pangahinang kakana'. ");
INSERT INTO sml_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Kuwit bili-bili l'lla isab bay nianjibihan keyat, maka kuwit duyung, kayu akasya, ");
INSERT INTO sml_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ns'llan jaitun ma palita'an, saga pamapā ya pamahamut ns'llan pangangg'llal imam, maka ginisan pamapā kamanyan, ");
INSERT INTO sml_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ginisan palmata isab pamalingkat epod maka puyu'-daggaha ya pan'mmek imam alanga.” ");
INSERT INTO sml_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yuk Tuhan isab, “Soho'un saga bangsa Isra'il angahinangan aku Luma' Sussi supaya aku makamailu ma sigām. ");
INSERT INTO sml_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ya pangahinangbi luma' itu maka kamemon kapanyapanna subay pasali' ni suntu'an ya song pa'nda'anku ni ka'a.” ");
INSERT INTO sml_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Yuk Tuhan isab, “Soho'un sigām angahinang ba'ul min kayu akasya, lima h'kka taha'na, t'llu h'kka lambuna, t'llu h'kka isab langkawna. ");
INSERT INTO sml_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ba'ul itu subay pinutus deyom-luwasanna maka bulawan porol. Kakīranna isab subay pinalingkat maka gipis bulawan. ");
INSERT INTO sml_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Hinangunbi mpat gallang bulawan bo' patli'unbi pehē' ni tape' ba'ul inān, duwa gallang min bihing ba'ul dambila', duwa isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Hinangunbi saga tanggungan min kayu akasya, bo' putusinbi bulawan. ");
INSERT INTO sml_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tahinang pa'in, pasulugunbi ni gallang ya ma bihing ba'ul bo' aniya' pananggungan. ");
INSERT INTO sml_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ya tanggungan itu mbal manjari nila'anan min panuluganna. ");
INSERT INTO sml_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Na pagubus, pat'nna'unbi ma deyom Ba'ul Paljanji'an ya paltanda'an song pamuwanku ma ka'am. ");
INSERT INTO sml_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Hinangunbi turung sinasal min bulawan porol, lima h'kka taha'na, t'llu h'kka lambuna. Turung Pagtaubatan ko' inān. ");
INSERT INTO sml_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Sasalunbi isab duwa mala'ikat pikpikan min tōng turung karuwa, langkus bulawanna maka bulawan turung. ");
INSERT INTO sml_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Saga mala'ikat pikpikan itu subay pinapagharap maka subay angandomolan turung. In pikpik sigām subay pab'llat pariyata' bo' makalandungan turung ba'ul. ");
INSERT INTO sml_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pagubus pa'in, nna'un ma deyom Ba'ul Paljanji'an ilu ya sulat paltanda'an song pamuwanku ma ka'a, ati turungin. ");
INSERT INTO sml_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Manjari pasabu aku ma ka'a, Musa, ma llotan duwa mala'ikat pikpikan ya ma turung Ba'ul Paljanji'an e'. Pi'ilu du aku amasampay ni ka'a saga sara' kamemon ya panoho'anku ma saga bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Magkallam gi' Tuhan ma disi Musa yukna, “Hinangunbi lamisahan min kayu akasya, mpat h'kka taha'na, duwa h'kka lambuna, t'llu h'kka isab langkawna. ");
INSERT INTO sml_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Putusunbi maka bulawan porol, bo' palingkatunbi kīdna ka'mpat maka gipis bulawan. ");
INSERT INTO sml_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hinangunbi paga-paga da'mpāt-tangan lambuna ma sakalibut lamisahan e', bo' palingkatunbi isab maka bulawan gipis. ");
INSERT INTO sml_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Hinangunbi mpat gallang bulawan bo' patli'unbi pehē' ni mpat dugu lamisahan e', ma diyata'an saga tape'na. ");
INSERT INTO sml_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Pasekotun saga gallang e' ni paga-paga bo' aniya' pamasulugan tanggungan bang nihangkut pi'ingga-pi'ingga. ");
INSERT INTO sml_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Saga tanggungan ilu subay nihinang min kayu akasya pinutusan bulawan. ");
INSERT INTO sml_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Damikiyanna isab saga kapanyapan ma Luma' Pangarapan, hinangunbi min bulawan porol, buwat saga lai, saga pinggan maka saga pangisihan binu-anggul ya binu'usan pangahulmat ma Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Jari lamisahan ilu ya pamat'nna'anbi Tinapay Hadarat bo' aniya' ma matahanku sakahaba' waktu.” ");
INSERT INTO sml_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Magkallam gi' Tuhan, yukna, “Anasal kam baran palita'an min bulawan porol, dalos hinanganna min buli'na sampay ni batangna, beya' isab saga pinggan-pinggan ya pinagukilan sali' luwa sumping. ");
INSERT INTO sml_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","In batangna subay magsanga nnom, t'llu min dambila' batang, t'llu isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Maka sangana inān subay nihinangan pinggan-pinggan sali' luwa sumping almon, t'llu hekana ma saga sanga ka'nnom pakaniya-kaniya. ");
INSERT INTO sml_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ya du batang palita'an, subay nihinangan pinggan-pinggan mpat hekana sali' luwa sumping almon. ");
INSERT INTO sml_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Jari aniya' dakayu' pinggan-pinggan min deyo' saga sanga panagna'an, dakayu' min deyo' saga sanga t'ngnga'an, dakayu' isab min deyo' sanga ma diyata'. Nnom sangana kamemon. ");
INSERT INTO sml_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Subay dalos hinangan palita'an itu kamemon, baranna maka saga sumping-sumpingna maka saga sangana. Bulawan ponod ya pangahinang iya. ");
INSERT INTO sml_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Manjari, angahinang kam saga palita'an maka sumbuhan pitu' hekana. Pagubus, pat'nna'unbi ma baran palita'an bo' supaya patudju sawana ni dahuan. ");
INSERT INTO sml_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Hinangunbi isab saga kapanyapan palita'an, buwat saga sisipit pamahāp sumbuhan maka saga talam-talamna. ");
INSERT INTO sml_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ya buhat bulawan pangahinangbi palita'an itu sampay kamemon saga panyapna subay t'llumpū' maka mpat kilu. ");
INSERT INTO sml_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ebot-ebot,” yuk Tuhan ma si Musa, “beya'un suntu'an bay pa'nda'anku ma ka'a ma diyata' būd itu.” ");
INSERT INTO sml_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Na, amalman Tuhan ma si Musa, yukna, “Buwattitu ya pangahinangbi Luma' Pangarapan ni aku. Angahinang kam sangpū' sugpat kultina landu' ahāp kakana'na pinaglamuran salban bilu, salban taluk maka salban keyat bo' ahāp luwana. Pabuldahinbi isab luwa mala'ikat pikpikan ma a'a apanday magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Saga sugpat kultina itu subay dasali' sukuranna kamemon, pitund'ppa taha'na maka dand'ppa lambuna. ");
INSERT INTO sml_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Jari lima sugpatna subay tinahi' pinagbihing-bihing bo' tahinang dakayu' kultina atibu'uk, damikiyanna lima sugpat takapin. ");
INSERT INTO sml_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","6","Patahi'un tainga-tainga kakana' bilu ma bihing kultina aheya inān karuwa, hatina lima-limampū' heka tainga-tainga maganggop-anggop. Pahinangun isab limampū' kakansing bulawan pamarakayu' duwa kultina inān supaya arakayu' deyom Luma' Pangarapan ilu. ");
INSERT INTO sml_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Pagubus, pahinangun saga kultina min bulbul kambing, sangpū' maka dda heka sugpatna pangalapis kultina deyom. ");
INSERT INTO sml_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Saga sugpat itu subay dasali' sukuranna kamemon, taha'na pitund'ppa maka tonga', lambuna dand'ppa. ");
INSERT INTO sml_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","In sugpat bulbul kambing itu subay tinahi' pinagbihing-bihing isab, lima heka sugpat ma kultina dakayu', nnom heka sugpat ma kultina dakayu'. Ya kultina nnom sugpatna subay pinasangon ma dahuan luma' tampal ni pagsosōran, maka sugpatna katapusan subay nilupi' duwa. ");
INSERT INTO sml_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Patahi'un tainga-tainga kakana' ma tōng kultina karuwa, lima-limampū' hekana. ");
INSERT INTO sml_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Pahinangun isab limampū' kakansing tumbaga pamarakayu' kultina bulbul kambing itu karuwa. ");
INSERT INTO sml_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Na, pagka maglabi asal tōng kultina ya talupi' duwa, subay patontonan di-na ma kōkan luma'. ");
INSERT INTO sml_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ya du tōng kultina ma bihing luma' karuwambila', maglabi isab tonga' sin tonga' d'ppa. Jari in labina itu subay pa'abut ni tana' bo' katambunan kultina ya ma deyom. ");
INSERT INTO sml_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Pahinangun duwa ginis turung isab panurung kaluha'an tolda. Kuwit bili-bili l'lla nianjibihan keyat ya pangahinang turung itu dakayu', maka kuwit duyung ya pangahinang turung katapusan.” ");
INSERT INTO sml_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Angallam gi' Tuhan ma disi Musa yukna, “Angahinang kam saga papagan dinding min kayu akasya pamarindingan Luma' Pangarapan. ");
INSERT INTO sml_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Duwand'ppa maka tonga' langkawna, t'llu h'kka lambuna ma dakayu' sugpat. ");
INSERT INTO sml_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Saga papagan ilu kamemon subay nihinangan lagsak duwa hekana patuwa' min deyo'anna. ");
INSERT INTO sml_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","21","Pahinangun duwampū' heka papagan dinding ma dambila' luma' maka ma dambila'. Pasasalun isab mpatpū' durukan hāg min pilak aponod, hatina duwa durukan ma papagan dakayu' maka dakayu' pamatukan lagsak e'. ");
INSERT INTO sml_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Hinangunbi isab nnom papagan pangandinding ma tōng luma' tampal ni s'ddopan, ");
INSERT INTO sml_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","maka duwa papagan isab ma duguna karuwa. ");
INSERT INTO sml_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Papagtapilun saga papagan ma dugu itu min deyo' sampay pariyata'. Diyata'na subay pinasulug ni dakayu' gallang bo' mbal magpuklas. ");
INSERT INTO sml_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Manjari walu' heka papagan pangandinding ma kōkan luma', sangpū' isab maka nnom durukanna nihinang min dī pilak. Hatina duwa durukan ma saga papagan ilu dakayu' maka dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","“Angahinang kam saga batang-batang kayu akasya pamahogot dinding, lima-lima hekana ma bihing luma' karuwambila', lima isab ma kōkan tampal ni s'ddopan. ");
INSERT INTO sml_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ya batang-batang ma t'ngnga' dinding subay pa'abut min tōng luma' dakayu' ni dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Putusinbi bulawan saga papagan dinding sampay saga batang-batangna. Angahinang kam saga gallang bulawan isab pamasulugan saga batang-batang e'.” ");
INSERT INTO sml_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Angallam gi' Tuhan ma disi Musa, “Ya pangahinangbi Luma' Pangarapan ma aku subay pasali' to'ongan ni suntu'an ya bay pa'nda'anku ka'a ma diyata' būd itu.” ");
INSERT INTO sml_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Yuk Tuhan, “Hinangunbi dakayu' kultina pangalikus deyom Luma' he', tampal ni kōkan. Kultina itu subay nihinang min kakana' landu' ahāp, pinaglamuran salban bilu, salban taluk maka salban keyat. Pabuldahin isab luwa mala'ikat pikpikan ma a'a apanday magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hinangunbi hāg mpat hekana min kayu akasya ati pat'nggehun ma mpat durukan dī pilak. Putusunbi hāg ilu maka bulawan, pē'inbi isab saga sasabit bulawan panagnatan kultina. ");
INSERT INTO sml_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","34","Pagubus, pasagnatun kultina ilu min deyo' saga kakansing bay pamarakayu' duwa kultina pangatop. Jari in Luma' Pangarapan tabilik duwa na. Tampat Sussi ya pangōn bilik tampal ni pagsosōran, Tampat Mahasussi ya pangōn bilik ma liyu kultina tampal ni kōkan. Maina'an ya pamat'nna'anbi Ba'ul Pagtau'an Sulat Paljanji'an, tinurungan asal maka turungna. ");
INSERT INTO sml_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ya lamisahan bulawan subay pinat'nna' ma luwasan kultina, ma bihing luma' tampal ni kowan. Ya palita'an pitu' sangana subay pinat'nna' tampal ni gibang, maganggop maka lamisahan. ");
INSERT INTO sml_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Angahinang kam kultina panambol lawang pagsosōran ni Luma'. Hinangunbi min kakana' ahāp isina, binulda isab maka salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Hinangunbi lima hāg min kayu akasya pinutusan bulawan. Sasalunbi isab lima durukan tumbaga pamat'nna'an saga hāg e'. Pagubus, hinangunbi saga sasabit bulawan panagnatan kultina.” ");
INSERT INTO sml_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Magpanoho'an lagi' Tuhan ma si Musa, yukna, “Angahinang kam lapohan pagtunu'an kulban min kayu akasya. Magpasagi' lambuna maka taha'na sangpū' h'kka sali'-sali', nnom h'kka langkawna. ");
INSERT INTO sml_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Hinangunbi pussuk-pussuk kayu ma mpat duguna, sali' luwa tanduk. Kayuna subay dalos maka kayu ya pangahinangan baran lapohan. Jari putusunbi kamemonna maka dī tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Hinangunbi isab ba'anan kapanyapanna min tumbaga, buwat saga undam panaluran abu, saga kakagis, saga garul pangisihan laha' susumbali'an, saga tutugsuk aheya, sampay saga pangisihan baga. ");
INSERT INTO sml_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","In lapohan ilu subay nihinangan pangayakan min tumbaga, maka gallang tumbaga isab ma duguna ka'mpat. ");
INSERT INTO sml_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Pagubus, pasangonun pangayakan itu ni deyom baran lapohan min deyo' paga-paga akiput, saga ma tonga'an kīdna. ");
INSERT INTO sml_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Hinangun tanggungan isab min kayu akasya pinutus maka tumbaga ");
INSERT INTO sml_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","bo' pinasulug pehē' ni gallang ma kīd lapohan karuwambila' bang subay nihangkut. ");
INSERT INTO sml_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Beya'unbi suntu'an lapohan bay pa'nda'anku ma ka'a maina'an lagi' ma diyata' būd. Hinangunbi min papan, luwana sali' tu'ung halam turungna.” ");
INSERT INTO sml_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","13","Angallam gi' Tuhan ma si Musa, yukna, “Subay aniya' halaman ma sakalibut Luma' Pangarapan, taha'na duwampū' maka limand'ppa, luhana sangpū' maka duwand'ppa maka tonga'. Kultina landu' ahāp kakana'na ya panasak halaman itu, maka hāg nnompū' hekana panagnatan kultina. Duwa-duwampū' heka hāg min bihingna tampal ni uttala' maka ni satan, sangpū'-sangpū' isab min bihingna tampal ni sobangan maka ni s'ddopan. Saga hāg itu kamemon subay nileboran maka pilak, maka subay nihinangan durukan min dī tumbaga. Pinē'an sasabit pilak isab panagnatan kultina. ");
INSERT INTO sml_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","“Ma sasak tampal ni sobangan, pahinangun duwa kultina lima-limand'ppa taha'na panasak halaman min karuwambila' lalabayan ya pagsōd-luwasan a'a. Subay t'llu hāg jukup maka durukanna min bihing lalabayan tampal ni kowan, t'llu isab tampal ni gibang. Hatina kulang-kulang mpat d'ppa ya taha' sasak min karuwambila'. ");
INSERT INTO sml_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Hinangunbi kultina panambol pagsosōran halaman, limand'ppa taha'na. Ya pangahinangbi subay kakana' ahāp binuldahan maka salban bilu, taluk maka keyat. Subay aniya' hāg panagnatan kultina inān, mpat hekana jukup maka durukanna. ");
INSERT INTO sml_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kamemon saga hāg ma sasak inān subay nilebod maka lebod-lebod dī pilak, subay aniya' sasabitna isab nihinang min dī pilak. Tumbaga ya pangahinang saga durukan hāg e'. ");
INSERT INTO sml_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Duwampū' maka mpat d'ppa ya taha' halaman itu, sangpū' maka duwand'ppa luhana. Dand'ppa maka duwa h'kka ya langkaw kultinana, ahāp isab kakana'na. Aniya' isab durukan tumbaga ma ba'anan saga hāgna. ");
INSERT INTO sml_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Jari kapanyapan ai-ai ya ginuna ma Luma' Pangarapan itu nihinang min tumbaga. Ya du saga bale pangengkotan Luma' Pangarapan maka sasakna, tumbaga isab.” ");
INSERT INTO sml_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ah'lling gi' Tuhan ma si Musa yukna, “Soho'un saga bangsa Isra'il amowahan ka'a ns'llan jaitun halam aniya' sapalna bo' aniya' pang'ns'llan saga palita'an bo' mbal magkap'dda keyatna. ");
INSERT INTO sml_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Wajib si Harun maka saga anakna angayuput saga palita'an ya pat'nna' ma deyom Tolda Pagsasabuhan min luwasan kultina ya pangalikus ba'ul isihan Sulat Paljanji'an. Palita'an ilu subay akeyat na pa'in ma haddarat PANGHŪꞋ-Yawe min waktu abay kohap sampay ni kasubuhan. Subay bineya' panoho'an itu e' saga bangsa Isra'il kamemon magpangkat-mamangkat.” ");
INSERT INTO sml_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Amalman gi' Tuhan ma si Musa, yukna, “Palinganin danakannu si Harun maka saga anakna l'lla, ya si Nadab, si Abihu, si Eleyasar maka si Itamar. Pasaddīhun sigām min pagkahi sigām bangsa Isra'il bo' tahinang imam maghinang ni aku. ");
INSERT INTO sml_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pahinangin si Harun saga badju' alingkat ya tōp pan'mmek imam alanga, supaya iya patut pinagmahaltabatan. ");
INSERT INTO sml_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Bowahun magsuli-suli ba'anan saga a'a ata'u magtahi' ya bay buwananku kapandayan. Sō'un sigām angahinang saga badju' pan'mmek si Harun, jari pabidda' iya min kaheka'an a'a ati tag'llal imam maghinang ni aku. ");
INSERT INTO sml_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Buwattitu saga s'mmek ya pamahinangnu ma saga a'a magtatahi': kaissana puyu' pat'nna' ma daggaha, karuwana lampik s'mmek ya niōnan epod, kat'lluna juba, ka'mpatna badju' buldahan, kalimana sulban, katapusanna kambot. Ya du ilu saga pan'mmek ahalga' ya nihinangan danakannu si Harun maka saga anakna l'lla supaya sigām tag'llal imam maghinang ni aku. ");
INSERT INTO sml_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Subay lubid-lubid bulawan maka salban bilu, taluk maka keyat ya ginuna e' sigām, maka subay kakana' ahāp t'nnunanna.” ");
INSERT INTO sml_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Hinangun epod min kakana' ahāp isina maka min lubid-lubid bulawan. Salban bilu, taluk maka keyat isab ya pangangguna e' sigām ya apanday magbulda. ");
INSERT INTO sml_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Epod itu subay tinahi'an duwa sablayan ma bahana karuwambila' bo' ahāp t'nna'na ma baran imam. ");
INSERT INTO sml_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Subay aniya' sambung ahāp hinanganna isab, nihinang min kakana' ahāp maka min lubid-lubid bulawan, bo' binulda maka salban bilu, taluk maka keyat. Sambung itu subay dalos asal maka baran epod. ");
INSERT INTO sml_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Pagubus, angā' ka saga palmata onek duwa hekana pangukilan ōn saga anak si Isra'il kasangpū' maka duwa. ");
INSERT INTO sml_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Subay pinagsunu'-sunu' pangumulan sigām, nnom ōn sigām ma palmata dakayu', nnom isab ma dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Paukilun pahāp ma a'a apanday maghinang palmata maka singsing. Sasalunbi isab duwa kait bulawan pamat'nna'an duwa palmata ilu. ");
INSERT INTO sml_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Manjari in duwa kait e' subay pinasangon ma diyata' sablayan epod bo' aniya' pangentoman saga anak si Isra'il. Pagka buwattē', in ōn saga bangsa Isra'il tatanggung e' si Harun ma hadaratku,” yuk PANGHŪꞋ, “ati taentomku sigām. ");
INSERT INTO sml_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Pasasalun duwa kait bulawan maka duwa kili-kili bulawan, tinabid-tabid sali' luwa lubid. Jari in kili-kili itu subay pinaengkot ni kait e'.” ");
INSERT INTO sml_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Na,” yuk Tuhan, “pahinangun puyu'-daggaha pang'nda'an kahandak Tuhan. Pahinangun ma a'a taga-kapandayan. Soho'un pinasali' ni bay hinangan epod e', hatina kakana' ahāp isina pinaglamuran lubid-lubid bulawan, binuldahan isab maka salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kakana' puyu' itu subay nilupi' duwa bo' amasagi' dah'kka taha'na, dah'kka isab lambuna. ");
INSERT INTO sml_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pat'nna'un saga palmata kaginisan sangpū' maka duwa hekana ma dahuan puyu'. Saga palmata itu subay pinagtād-tād mpat, t'llu-t'llu hekana ma dantād. Ya ma tād diyata' subay rubi (palmata alutu' keyatna), topas (palmata kuning), maka berel (palmata jali'-jali'). ");
INSERT INTO sml_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ya ma tād pasunu' subay turkwis (palmata bilu magb'ttik-b'ttik), sappir (palmata alutu' biluna), maka emeral (palmata alutu' gaddungna). ");
INSERT INTO sml_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ma tād pasunu' gi' subay jasint (palmata bilu magb'ttik-b'ttik), agat (palmata magjali'-jali' kausun maka pote'), maka amitis (palmata taluk). ");
INSERT INTO sml_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ma tād deyo' katapusan subay krisolit (palmata biyaning), onek (palmata kausun jali'-jali'), maka jasper (palmata intan gaddung). Bulawan ya pamakaitan saga palmata itu kamemon. ");
INSERT INTO sml_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Manjari in sangpū' maka duwa palmata itu subay niukilan saga ōn anak si Isra'il l'lla, sali' hantang ukilan singsing. Ōn a'a dakayu' ma palmata dakayu' pakaniya-kaniya.” ");
INSERT INTO sml_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ah'lling gi' Tuhan ma si Musa yukna, “Hinangun duwa kili-kili min bulawan tinabid-tabid bo' aniya' pangengkot puyu', ");
INSERT INTO sml_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","26","maka hinangun isab mpat singsing bulawan tinahi' pehē' ni mpat dugu puyu', min bukutna. Pagubus, engkotin tōng kili-kili bulawan inān ni duwa singsing puyu'. Engkotin tōngna dakayu' isab ni duwa kait ya pamatukan palmata bo' pasangon ni sablayan epod, min dahuan baha. ");
INSERT INTO sml_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hinangun lagi' singsing bulawan saddī, duwa hekana isab, ati tahi'un ni tōng sablayan epod, ma atag sambungna. ");
INSERT INTO sml_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","In singsing puyu' damuli itu subay niengkotan ni singsing epod maka lubid bilu bo' supaya mbal angalambe puyu' min baran imam. ");
INSERT INTO sml_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Manjari itu,” yuk Tuhan, “sakahaba' waktu kapasōd si Harun ni Tampat Sussi ma deyom Luma' Pangarapan aku, ina'an ma atag jantungna puyu' ya pang'nda'an kahandakku. Ina'an isab maina'an saga ōn anak si Isra'il tabowa e'na pamaentoman aku, si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Pat'nna'un isab in Urim maka Tummim ma deyom puyu' inān supaya tabowa ma atag jantung si Harun bang iya pasōd ni hadaratku sumiyan-sumiyan waktu. Jari aniya' ma iya pang'nda'an bo' tata'una bang ai kahandakku,” yuk PANGHŪꞋ, “pasal saga bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Amalman gi' Tuhan ma si Musa, yukna, “Buwattitu ya pangahinangbi juba pangalapis epod. Hinangunbi min kakana' bilu halam aniya' lamudna, ");
INSERT INTO sml_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","maka hinangin lowang ma t'ngnga'na bo' aniya' pasulugan kōk a'a. Lowang itu subay sinulsi pahāp bo' mbal al'kkas agese' bang sinulug. ");
INSERT INTO sml_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Pa'ari-arihun kumpi' juba maka buwa'-buwa' dalima' nihinang min salban bilu, taluk maka keyat. Subay aniya' bagting-bagting bulawan isab pinag'llot-'llot maka buwa'-buwa' he'. ");
INSERT INTO sml_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Wajib si Harun subay magsin'mmek juba itu hinabuna maghinang ni aku, jari takale lling bagting-bagting inān ma waktu kasōdna ni hadaratku ma Tampat Mahasussi. Takale isab ma waktu kaluwasna, ati mbal ya pinapatay. Aku si Yawe ya Tuhanbi.” ");
INSERT INTO sml_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ah'lling gi' PANGHŪꞋ ma si Musa, yukna, “Amasasal ka dakayu' tapak-tapak dī bulawan niukilan maka kabtangan itu, ‘Sussi-manussi Pamasuku' si Yawe.’ Ukilanna subay sali' ukilan singsing. ");
INSERT INTO sml_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Pasangonun lubid bilu ma tapak-tapak ilu pamaengkot iya ni dahuan imam. ");
INSERT INTO sml_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Tapak-tapak inān subay pabatuk ma tuktuk si Harun, jari bang asā' e' saga a'a Isra'il anukbal ai-ai, tatanggung e' si Harun kasā'an sigām. In tapak-tapak inān subay paddas ma tuktukna sakahaba' waktu bo' tataima' e' PANGHŪꞋ-Yawe saga tutukbalan ummat Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Pat'nnunun kakana' ahāp isina nihinang badju' pamadju' si Harun, maka sulban isab maka sabitan. Sabitanna itu subay binuldahan e' a'a magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ya du saga anak si Harun l'lla, subay nihinangan badju' maka sabitan maka porong, hatina pan'mmek alingkat supaya sigām patut pinagmahaltabatan. ");
INSERT INTO sml_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pasulugun saga pan'mmek itu ma danakannu si Harun (yuk Tuhan ma si Musa) maka ma saga anakna. Pagubus, busugin kōk sigām maka ns'llan jaitun bo' tag'llal imam. Pasuku'un sigām ma aku sadja supaya sigām makapaghinang ni aku. ");
INSERT INTO sml_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Pahinangin sigām sauwal-sauwal isab panambun harapan sigām min hawakan sampay ni pa'a. ");
INSERT INTO sml_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Wajib sigām subay magsulug sauwal-sauwal ilu sakahaba' waktu kapasōd sigām ni deyom Tolda Pagsasabuhan, atawa bang sigām pasekot pehē' ni lapohan pagtukbalan ma Tampat Sussi bo' magimam ni aku maina'an. Bang sigām ganta' pasōd ma halam asauwal, dusa makapatay ko' inān. Panoho'an itu subay binogbogan e' si Harun maka saga panubu'na salama-lama tahun.” ");
INSERT INTO sml_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Angallam gi' Tuhan ma si Musa, “Buwattitu hatulanna bang pasaddīnu disi Harun magimam tudju ni aku. Pene'un dakayu' anak sapi' l'lla maka duwa bili-bili l'lla halam aniya' salla'na. ");
INSERT INTO sml_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ngā'unbi isab tirigu pinu halam aniya' pasuligna bo' hinangunbi tinapay maka mamun anahut kalamuran ns'llan, maka bāng-bāng anipis-nipis pinahiran ns'llan. ");
INSERT INTO sml_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nna'un ai-ai itu ni deyom dakayu' ambung bo' yampa tukbalin ni aku, pinapagbeya' maka sapi' maka duwa bili-bili he'. ");
INSERT INTO sml_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Pagubus, bowahun si Harun maka saga anakna l'lla pehē' ni atag pagsosōran Tolda Pagsasabuhan ati pandihun sigām maka bohe'. ");
INSERT INTO sml_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Aubus pa'in bay pinandi, pas'mmekin si Harun saga s'mmek imam. Dahū badju', bo' juba, bo' epod isab maka puyu'-daggaha. Pakambotin isab hawakanna maka sambung ya ahāp hinanganna he'. ");
INSERT INTO sml_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pasulbanin kōkna bo' pat'nna'un tapak-tapak ni dahuwan sulban e'. ");
INSERT INTO sml_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Puwas e', angā' ka ns'llan jaitun ya ginuna pangangg'llal, bo' busugin pehē' ni kōk si Harun. ");
INSERT INTO sml_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Bowahun isab saga anak si Harun l'lla bo' pinasulugan saga badju' imam. ");
INSERT INTO sml_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Paporongin kōk sigām maka pakambotin isab hawakan sigām. Buwattē' ya pangangg'llalnu disi Harun magimam, iya sampay saga anakna l'lla. Manjari tubu'an sigām magpangkat-mamangkat ya pinat'nna' magimam sampay ni kasaumulan.” ");
INSERT INTO sml_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ah'lling lagi' Tuhan ma si Musa, yukna, “Na, ya sapi' l'lla bay pene'nu subay pinasekot ni pagsosōran Tolda Pagsasabuhan. Bowahun si Harun maka saga anakna amat'nna' tangan sigām ma kōk sapi' he', ");
INSERT INTO sml_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","bo' yampa sumbali'un ma matahanku ma atag lawang Tolda Pagsasabuhan. ");
INSERT INTO sml_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Angā' ka laha' min bay tasaludnu bo' pahirun pehē' ni saga dugu lapohan tumbaga. Tōng tangannu ya pamahid. Bu'usin isab saga laha' takapin nireyo' lapohan e'. ");
INSERT INTO sml_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","“Pagubus, ngā'un lanab sapi' ilu kamemon, ya lanab amikit ma tina'ina, maka buli'-atayna, maka kidnina karuwa jukup maka lanabna. Tunu'un pehē' ni diyata' lapohan tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Sagō' ya isi sapi' maka kuwitna maka tina'ina subay tinunu' ma luwasan pustu. Pagtaubatan ko' inān pangangganti' paldusahan saga imam.” ");
INSERT INTO sml_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Angallam lagi' Tuhan, yukna, “Angā' ka dakayu' bili-bili l'lla min bay pene'nu ati bowahun si Harun maka saga anakna amat'nna' tangan sigām ma kōk bili-bili he'. ");
INSERT INTO sml_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sumbali'un magtūy, maka salurun laha'na bo' pigsikun pehē' ni mpat bihing lapohan tumbaga inān. ");
INSERT INTO sml_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Pagubus, pagk'llot-k'llotun baran bili-bili he'. Kose'in tina'ina maka saga tape'na bo' bangkatun ni kōkna maka isina. ");
INSERT INTO sml_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Manjari in baran bili-bili ilu subay tinunu' ma katibu'ukanna ma diyata' lapohan tumbaga. Pagkulban tinunu' ko' inān panukbalbi ni aku. Kasulutan isab aku ma hamutna,” yuk PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Angā' ka isab bili-bili dakayu', ati bowahun si Harun maka saga anakna amat'nna' tangan sigām ma kōkna. ");
INSERT INTO sml_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sumbali'un bo' salurun laha'na. Angakup ka dangkuri' laha' bo' peherun pehē' ni tōng tainga si Harun maka saga anakna, tampal ni kowan. Peherun isab ni dambila' bokol tangan sigām kowan maka ni bokol tape' sigām, kowan du isab. Pagubus, pigsikun laha' ni mpat bihing lapohan tumbaga he'. ");
INSERT INTO sml_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Angā' ka isab laha' min bay pamigsikannu ni lamisahan, beya' isab saga ns'llan jaitun. Jari pigsikun ni disi Harun maka saga anakna, lapayun isab saga s'mmek sigām. Minnē' sigām tasussi ma baran maka ma s'mmek, hatina suku' na sigām ma aku. ");
INSERT INTO sml_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Angā' ka lanab min bili-bili karuwana sabab bili-bili pangangg'llal imam ko' ilu. Angā' ka lanab togelna, maka lanab ya amikit ma tina'ina, maka buli'-atayna sampay saga kidnina karuwa jukup maka lanabna. Pabeya'un isab pa'ana kowan. ");
INSERT INTO sml_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Amene' ka tinapay min ambung ya pat'nna' ma matahanku. Subay dakayu' tinapay atibu'uk, dakayu' mamun-mamun kalamuran ns'llan, maka dakayu' bāng-bāng anipis, halam aniya' pasuligna kamemon. ");
INSERT INTO sml_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nde'in saga tinapay ilu maka saga k'llotan bili-bili ni pang'ntanan si Harun maka saga anakna. Pa'angkatun kamemonna ma sigām pangahulmat ma aku, ya Tuhanbi si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Pagubus, sambutun pabalik min tangan sigām bo' tunu'un pehē' ni diyata' lapohan pagtunu'an, beya' maka susumbali'an ya tinunu' ma katibu'ukanna ati kasulutan aku ma hamutna. Pagkulban tinunu' ko' inān panukbalbi ma aku, si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Pagā'nu daggaha bili-bili bay sinumbali' pangangg'llal ma si Harun, angkatun ma matahanku dahū pangahulmatnu ma aku, jari ma ka'a na. ");
INSERT INTO sml_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Pasuku'unbi ma aku dahū saga bahagi' bili-bili ya palsuku'an disi Harun maka saga anakna, hatina daggaha maka pa'a ya bay niangkat pangahulmat ma aku. ");
INSERT INTO sml_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Buwattē' l'ngngananna salama-lama tahun bang aniya' susumbali'an tinukbal pagduwa'a salamat ni si Yawe e' saga a'a Isra'il. Daggaha maka pa'a subay pamasuku' e' saga bangsa Isra'il pagkakan si Harun maka anak-panubu'na. ");
INSERT INTO sml_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Na, saga s'mmek pagimam si Harun inān subay pamusaka' saga panubu'na, pan'mmek sigām ma waktu pamat'nna' sigām magimam, waktu isab pamusug kōk sigām maka ns'llan jaitun. ");
INSERT INTO sml_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Jari sasuku pinat'nna' magimam pas'lle' min si Harun bo' pasōd ni deyom Tolda Pagsasabuhan maghinang ni aku ma Tampat Sussi, wajib subay magbinadju' s'mmek si Harun pitung'llaw t'ggolna. ");
INSERT INTO sml_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Manjari angā' na ka isi min bili-bili ya bay sinumbali' pangangg'llal ma disi Harun. Loho'in ma halaman Luma' Sussi ");
INSERT INTO sml_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ati pamakanun ma si Harun maka saga anakna ma atag pagsosōran Tolda Pagsasabuhan. Kapin tinapay bay ma deyom ambung ya palauk. ");
INSERT INTO sml_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Luwal sigām ya taga-kapatut amangan saga pagkakan ilu, sabab bay panukbal ni aku pagtaubatan dusa sigām ma waktu kapangangg'llal sigām magimam. Suku' Tuhan ko' inān angkan halam sai-na makajari amangan saddī min disi Harun. ");
INSERT INTO sml_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Bang isab aniya' isi bili-bili atawa tinapay angapin sampay ni kasubuhan, subay tinunu'. Mbal manjari kinakan sabab bay pinama-Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Na,” yuk Tuhan ma si Musa, “beya'un hatulan kamemon ya panoho'anku itu pasal pangangg'llal ma si Harun maka saga anakna. Paghinang ilu subay pitung'llaw t'ggolna. ");
INSERT INTO sml_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Anumbali' ka sapi' l'lla kahaba' llaw ma deyom dapitu'. Pagkulban panaubatan dusa ko' inān, maka pamala'an tamak dusa isab min lapohan pagtunu'an. Busugin isab maka ns'llan pamasussi bo' pinama-aku sadja. ");
INSERT INTO sml_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Subay pitung'llaw ya t'ggolbi maghinang saga hinang itu magbalik-balik, hinang pamala'an tamak dusa maka hinang pamasussi. Manjari asussi sidda lapohan itu, maka asussi isab ai-ai makasagid pehē'.” ");
INSERT INTO sml_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","39","Amalman lagi' Tuhan ma si Musa, yukna, “Ya panukbalbi ni aku ma lamisahan pagtunu'an subay duwa anak bili-bili dantahun umulna. Dakayu' ilu subay tukbalbi ma aku ma waktu subu, dakayu' isab ma abay kohap. Buwattē' hinangbi sakahaba' llaw. ");
INSERT INTO sml_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pabeya'unbi ma bili-bili subu dagantang tirigu pinu kalamuran dalitru ns'llan jaitun. Tumpahinbi isab dalitru binu-anggul pangahulmatbi ma aku. ");
INSERT INTO sml_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Damikiyanna bili-bili dakayu' ya tinukbal abay-kohap, subay pinabeya'an tirigu maka binu-anggul. Pagkulban tinunu' ko' inān ya panukbalbi ma aku, si Yawe, jari kasulutan aku ma hamutna. ");
INSERT INTO sml_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“In pagkulban tinunu' itu subay tinukbal ma matahanku kahaba' llaw, ma dahuan Tolda Pagsasabuhan. Subay tinukiran e'bi magpangkat-mamangkat. Mailu aku pasabu ma ka'a, Musa, maka e'ku amissala ma ka'a. ");
INSERT INTO sml_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mailu du isab aku magsabu maka saga bangsa Isra'il kamemon. Jari asussi makalandu' atag pagsabuhan inān pagka taluwa' sahayaku. ");
INSERT INTO sml_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Pasussiku Tolda Pagsasabuhan ilu sampay lapohan ya pagtunu'an kulban e'. Pasussiku du isab si Harun maka saga anakna l'lla, supaya sigām tahinang imam maghinang ni aku. ");
INSERT INTO sml_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Jari pat'nna' aku ma deyoman saga bangsa Isra'il ati aku ya pagtuhanan sigām. ");
INSERT INTO sml_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Minnē' sigām makata'u to'ongan in aku si Yawe ya pagtuhanan sigām, ya bay amowa sigām paluwas min lahat Misil bo' supaya aku pat'nna' ma deyoman sigām. Si Yawe aku, ya Tuhan-asal-Tuhan.” ");
INSERT INTO sml_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Magpanoho'an gi' Tuhan ma si Musa yukna, “Angahinang kam lamisahan min kayu akasya, pagtugtugan kamanyan. ");
INSERT INTO sml_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Subay amasagi' duwa h'kka taha'na maka lambuna, mpat h'kka isab langkawna. Hinangin pussuk-pussuk sali' luwa tanduk ma duguna ka'mpat, dalos asal kayuna maka kayu ya pangahinangan baran lamisahan. ");
INSERT INTO sml_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Putusun diyata'na maka bulawan porol, beya' isab kīdna maka pussuk-pussukna ka'mpat. Pehē'in gipis bulawan isab ma kakīranna pamahāp luwana. ");
INSERT INTO sml_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Hinangun duwa gallang bulawan pinasangon pehē' ni kīd lamisahan min deyo'an gipis e', dakayu' min dambila', dakayu' isab min dambila' bo' aniya' pamasulugan tanggungan. ");
INSERT INTO sml_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Saga tanggungan itu subay nihinang min kayu akasya pinutus isab maka bulawan. ");
INSERT INTO sml_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Pat'nna'un lamisahan itu min luwasan kultina ya pangalikus Ba'ul Pagtau'an Sulat Paljanji'an, bo' min luwasan Turung Pagtaubatan isab. Maina'an aku pasabu ma ka'a. ");
INSERT INTO sml_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Na, ya hinang si Harun ma waktu pamahilala'na saga palita'an kahaba' subu, subay anugtug kamanyan ahamut ma lamisahan inān. ");
INSERT INTO sml_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ya du kahaba' abay-kohap, ma waktu panū'na palita'an, subay anugtug kamanyan isab supaya aniya' pat'bbud ni PANGHŪꞋ waktu ni waktu salama-lama tahun. ");
INSERT INTO sml_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Da'a kam anukbal kamanyan saddī min kamanyan halal ma lamisahan panugtugan ilu. Mbal manjari bang panukbalan saga susumbali'an tinunu', atawa tirigu, atawa binu-anggul. ");
INSERT INTO sml_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Lamisahan ilu subay paghinangan taubat e' si Harun mint'dda dantahun bo' ta'ampun ba'anan karusahan bangsa Isra'il. In pussuk-pussukna ka'mpat subay pinahiran laha' min hayop ya sinumbali' pagtaubatan dusa min t'dda dantahun. Bogboginbi paghinang itu kahaba' tahun magpangkat-mamangkat sabab lamisahan landu' asussi ko' ilu, lamisahan suku' PANGHŪꞋ-Yawe.” ");
INSERT INTO sml_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Na ah'lling gi' PANGHŪꞋ ma si Musa, yukna, ");
INSERT INTO sml_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Bang ka angitung saga kal'llahan bangsa Isra'il, subay aniya' bayad pakaniya-pakaniya min sigām kamemon panungbas kallum sigām. Jari halam aniya' bala' tum'kka ni sigām ma waktu kapangitung e'. ");
INSERT INTO sml_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Pabayarun tonga' sekel dī pilak ma sigām pakaniya-kaniya bang sigām ni'itung na, panukbal sigām ni PANGHŪꞋ. (Timbangan sara' agama ya pagtimbangan e'.) ");
INSERT INTO sml_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Taluwa' ni'itung saga kal'llahan kamemon ya angabut duwampū' tahun umulna sampay pariyata'. Wajib sigām subay ang'nde'an tutukbalan ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ya tungbas kallum tinukbal ni PANGHŪꞋ e' a'a dayahan subay mbal palabi min tonga' sekel. Ya tinukbal e' a'a miskin isab subay mbal pakulang min tonga' sekel. ");
INSERT INTO sml_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Timukun sīn panungbas kallum itu bo' panganggastuhun ai-ai tahinang ma Tolda Pagsasabuhan. Manjari aniya' pangentoman ma matahan si Yawe, paltanda'an in ka'am bay makatungbas kallumbi.” ");
INSERT INTO sml_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Pagubus ina'an, ah'lling gi' PANGHŪꞋ-Yawe ma si Musa yukna, ");
INSERT INTO sml_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Angahinang kam dakayu' garul tumbaga pagailan saga imam. Hinanginbi isab patinggilan pamat'nna'an iya, tumbaga isab. Ya pamat'nna'anbi garul itu subay ma llotan Tolda Pagsasabuhan maka lamisahan pagkukulbanan. Isihinbi bohe' isab. ");
INSERT INTO sml_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Si Harun maka saga anakna subay magailan tape'-tangan sigām ");
INSERT INTO sml_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ma waktu kapasōd sigām ni deyom Tolda Pagsasabuhan Tuhan maka manusiya'. Jari mbal sigām taluwa' pinapatay. Buwattē' du isab bang sigām pasekot ni lamisahan pagkukulbanan bo' anunu' susumbali'an ni aku,” yuk PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","“Tangan maka tape' sigām subay niailan bo' supaya sigām mbal amatay. Panoho'an itu subay binogbogan e' si Harun maka saga panubu'na magpangkat-mamangkat.” ");
INSERT INTO sml_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ah'lling isab PANGHŪꞋ ma si Musa yukna, ");
INSERT INTO sml_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","24","“Angahinang kam ns'llan sussi min ns'llan jaitun mpat litru. Lamurinbi isab mpat ginis pamapā pamahamut iya. Issa, bulitik mūr masi bohe'an, saga nnom kilu buhatna bang ma timbangan sara' agama. Karuwana, kuwit kayu sinamun ahamut saga t'llu kilu buhatna. Kat'lluna, batang parang ahamut t'llu kilu isab buhatna. Ka'mpatna, kuwit kayu kassiya nnom kilu buhatna, ahamut isab. ");
INSERT INTO sml_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Papaglamurunbi saga kapanyapan itu kamemon nihinang ns'llan ahamut landu' asussi, bo' aniya' pamehed ai-ai pamasuku' ma Tuhan. Beya'unbi kapandayan saga a'a ata'u angahinang pahamut. ");
INSERT INTO sml_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Gunahun ns'llan sussi itu panussi Tolda Pagsabuhan sampay kamemon saga pagdayawna. Lapayun Ba'ul ya Pagtau'an Sulat Paljanji'an, ");
INSERT INTO sml_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","maka lamisahan pamat'nna'an tinapay sampay kapanyapanna, maka palita'an bulawan beya' isab panyapna, maka lamisahan panugtugan kamanyan. ");
INSERT INTO sml_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ya du lapohan pagtunu'an kulban sampay kapanyapanna kamemon, maka garul pagailan isab sampay pat'nna'anna. ");
INSERT INTO sml_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","In itu kamemon subay pinehē'an ns'llan sussi supaya asussi to'ongan, manjari suku'ku na. Bang aniya' isab makasagid ni ai-ai bay tasussi itu, subay suku'ku na.” ");
INSERT INTO sml_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Yuk Tuhan lagi', “Busugin ns'llan kōk disi Harun maka saga anakna, paltanda'an in sigām ma aku sadja, jari imam na sigām patut maghinang ma aku. ");
INSERT INTO sml_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Pahati'un saga bangsa Isra'il in ns'llan sussi itu subay aheya kagunahanna ma ka'am sampay ma panubu'bi magpangkat-mamangkat. ");
INSERT INTO sml_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Da'a pamahirunbi ma baran sai-na saddī min imam, da'a isab sengorinbi hinanganna. Suku' Tuhan ko' ilu, angkan subay halli'anbi. ");
INSERT INTO sml_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Bang aniya' a'a saddī angahinang ns'llan pahamut buwattitu hinanganna, atawa pamahidna ma a'a saddī min imam, in a'a inān mbal na taitung bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Angallam lagi' PANGHŪꞋ-Yawe ma si Musa yukna, “Buwattitu ya pangahinangbi kamanyan. Angā' kam duwa ginis bulitik ahāp isina maka hamutna, maka kuwit kūs-kūs maka kamanyan pote'. Buhatna kaniya-kaniya subay dasali' kamemon. ");
INSERT INTO sml_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ta'ā'bi pa'in ai-ai itu, beya'unbi kapandayan saga a'a ata'u angahinang pahamut. Paglamurunbi bo' tahinang kamanyan ahāp to'ongan hamutna. Pagubus, asininbi supaya al'ssin maka asussi. ");
INSERT INTO sml_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Pipisun kasehe'anna nihinang kamanyan anahut bo' pat'nna'un ma dahuan Ba'ul Paljanji'an ya ma deyom Tolda Pagsasabuhan. Mailu du aku magsabu maka ka'a. Kamanyan itu subay taitungbi sussi min sussi sabab suku'ku asal. ");
INSERT INTO sml_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Wajib kam da'a angahinang kamanyan buwattitu pamahamut baranbi. Niyatunbi kamanyan sussi ma aku sadja. ");
INSERT INTO sml_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Sasuku angahinang kamanyan buwattitu lamudna bo' pamahamutna baranna, mbal na taitung bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Na, angallam lagi' PANGHŪꞋ-Yawe ma si Musa yukna, ");
INSERT INTO sml_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Pata'u ka. Ya tapene'ku angahinang Luma' Pangarapan ma aku ya na si Besalel anak si Uri, mpu si Hūr, min panubu' si Yahud. ");
INSERT INTO sml_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Katulunanku iya kapandayan, akkal maka pangita'u bo' ahāp e'na angahinang ai-ai ya hinangan tangan. ");
INSERT INTO sml_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ata'u iya angangguhit suntu'an ma ai-ai tahinang min bulawan, pilak atawa tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ata'u iya anganggaugari' ginisan palmata bo' yampa pat'nna'na ma kait bulawan. Ya du bang kayu ya pangahinanganna, ata'u isab iya. Hatina ata'u iya angahinang indaginis. ");
INSERT INTO sml_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tapene'ku isab si Oholeyab anak si Ahisamak, min bangsa Dān, bo' aniya' sehe' si Besalel anabangan iya ma hinangna. Aho', buwananku kapandayan kamemon saga a'a maghihinang supaya sigām makahinang ai-ai bay panoho'anku ma ka'a, ya tasulat ma lista itu: ");
INSERT INTO sml_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tolda Pagsasabuhan, Ba'ul Pagtatau'an Sulat Paljanji'an maka Turungna ya pagtaubatan dusa, maka kapanyapan ai-ai ya pamapanyap Tolda. ");
INSERT INTO sml_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Lamisahan pamat'nna'an tinapay maka panyapna, Palita'an Bulawan maka panyapna, Lamisahan pagtugtugan kamanyan. ");
INSERT INTO sml_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Lapohan pagtunu'an kulban, beya' isab kapanyapanna. Garul pangailan sampay patinggilanna. ");
INSERT INTO sml_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Saga s'mmek mulliya ya tin'nnun pan'mmek disi Harun maka saga anakna ma waktu kapagimam sigām. ");
INSERT INTO sml_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Katapusan ya Ns'llan sussi pangangg'llal ma saga a'a maghinang ni Tuhan, maka kamanyan ahamut ya kagunahan ma Luma' Sussi. In itu kamemon subay nihinang e' saga a'a ya katulunan akkal maka kapandayan. Subay bineya' bay panoho'anku ma ka'a, Musa.” ");
INSERT INTO sml_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Na, angallam PANGHŪꞋ-Yawe ma si Musa yukna, ");
INSERT INTO sml_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Pasampayun palmanku itu ni saga bangsa Isra'il, ya yuk-i, ‘Wajib kam amogbog ma llaw ya ōnanku Llaw Mulliya. Jari in pangammalbi ma llaw mulliya tahinang pandoga pamaentom ka'am magtubu'-manubu' in aku maka ka'am bay makapagjanji'. Jari makata'u kam in aku si Yawe, ya makahinang ka'am bangsa sussi, bangsa suku'ku.’ Buwattē' ya pamasampaynu ma sigām.” ");
INSERT INTO sml_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Angallam gi' Tuhan yukna, “Bogboginbi Llaw Paghali, sabab Llaw Mulliya ma ka'am. Sasuku mbal angammal ma Llaw Mulliya subay pinapatay. Sasuku isab makahinang ai-ai ma llaw ina'an, subay itungbi sali' a'a liyu, ngga'i ka bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nnom llaw ya pamihabi kalluman ma deyom dapitu', sagō' bang ta'abut llaw kapitu'na, ya na llaw paghali, Llaw Mulliya pamaheyabi ma aku. Sasuku maghinang ai-ai ma llaw ina'an, subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","In ka'am bangsa Isra'il magtubu'-manubu' subay amogbog ma Llaw Mulliya itu bo' mbal takalipat paljanji'antam ya anatas salama-lama. ");
INSERT INTO sml_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","In Llaw Mulliya itu sali' pandoga pamaentom ka'am ni kasaumulan in aku maka ka'am bay makapagjanji'. Sababna nnom llaw ya bay kapamapanjariku dunya maka langit. Sagō' ta'abut pa'in llaw kapitu'na, pahali na aku min hinangku.” ");
INSERT INTO sml_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Na, aubus pa'in pangallam PANGHŪꞋ ma si Musa ma diyata' Būd Turusina, magtūy pamuwanna ma iya duwa batu amasagi' ya bay pangukilanna Sara' paljanji'anna maka bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Manjari itu, pagka tasayu e' saga a'a Isra'il in si Musa at'ggol halam bay makalūd min būd, patimuk sigām pehē' ni si Harun. Yuk sigām ma iya, “Tuwan, hinangin kitam tuhan bo' aniya' magmunda' ma kitam ma pal'ngnganan. Daka maingga si Musa inān, ya bay amowa kitam paluwas min Misil.” ");
INSERT INTO sml_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Anambung si Harun ma sigām, yukna, “Ā, sō'un nila'anan saga bulawan ya pangaretes saga h'ndabi maka anakbi l'lla-d'nda. Bowahunbi pi'itu ni aku.” ");
INSERT INTO sml_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Magtūy kala'anan e' sigām kamemon saga aretes sigām bo' binowa pehē' ni si Harun. ");
INSERT INTO sml_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tasambut pa'in ba'anan bulawan e', tinunaw e' si Harun bo' yampa hinangna ta'u-ta'u sali' luwa sapi' mandangan abata' lagi'. Aubus pa'in, ah'lling saga a'a Isra'il, yuk sigām, “Owa', ka'am saga a'a Isra'il! Nda'unbi tuhantam, ya bay amowa kitam paluwas min lahat Misil!” ");
INSERT INTO sml_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na, tasayu pa'in lling itu e' si Harun, magtūy iya angahinang pagtunu'an kulban ma munda'an sapi' bulawan e'. Yukna ma saga a'a, “Maghinang kitam salung, hinang pamaheya PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Pagsalung pa'in, waktu subu to'ongan, magbati'an saga a'a kamemon anunu' susumbali'an panukbal sigām ni Tuhan. Aniya' isab lalabotan tinukbal e' sigām pagduwa'ahan salamat. Aubus pa'in, magjamu na sigām sampay magkalumu'an d'nda maka l'lla. ");
INSERT INTO sml_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na, magsuwala PANGHŪꞋ ma si Musa, “Pasa'ut ka palūd,” yukna, “sabab saga a'anu, ya bay bowanu paluwas min Misil, wa'i na maghinang kasabulan. ");
INSERT INTO sml_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Al'kkas pahāp sigām ang'bba min kal'ngnganan ya bay panoho'anku ma sigām. Aniya' ta'u-ta'u tahinang e' sigām buwat luwa sapi' mandangan, jari pagsujuran e' sigām maka pagtukbalan saga susumbali'an. Ya pah'lling sigām, ‘O'o, pagtuhanantam bangsa Isra'il, ya bay amowa kitam paluwas min Misil.’ ” ");
INSERT INTO sml_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Magsuwala gi' PANGHŪꞋ ma si Musa yukna, “Ta'nda'ku saga a'a inān, atuwas to'ongan kōk sigām. ");
INSERT INTO sml_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Da'a aku saparun sabab apasu' sidda atayku, maka magniyat aku amahalam sigām. Jari ka'a maka panubu'nu ya hinangku bangsa aheya.” ");
INSERT INTO sml_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Sagō' angamu' junjung si Musa ni si Yawe ya pagtuhananna, yukna, “O Yawe, da'a mulahun saga a'a suku'nu itu, ya bay bowanu paluwas min lahat Misil sabab min kosog kawasanu. ");
INSERT INTO sml_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Dūlannu bahā' saga bangsa Misil amūng-mūngan ka'a ala'at kono' maksudnu, ya angkan bowanu bangsa Isra'il paluwas min Misil bo' papataynu sigām ma kabūran. Luhūy halam aniya' a'a Isra'il takapin ma babaw dunya itu? Ndū', Tuhanku, bang pa'in pindahannu kapasu' ataynu. Da'a lanjalin niyatnu angamula saga a'a suku'nu itu. ");
INSERT INTO sml_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Entomun saga sosoho'annu disi Ibrahim, si Isa'ak maka si Yakub. Entomun bay janji'nu ma sigām, ya bay pagsapahannu ma barannu, ya bay yuknu, ‘Pahekaku saga panubu'bi sampay sigām sali' heka bitu'un ma langit. Pamusaka'ku kaluha'an lahat Kana'an ma sigām salama-lama, buwat bay panganjanji'ku ma ka'am.’ ” ");
INSERT INTO sml_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na, pagka buwattē' panganjunjung si Musa, halam nilanjalan e' si Yawe niyatna amahalam saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Manjari palūd na si Musa min būd maka e'na amowa duwa batu amasagi' ya panulatan sara'-panoho'an bay panganjanji' Tuhan ma bangsa Isra'il. Batu inān bay pangukilan sara' ma dahuanna maka ma bukutna. ");
INSERT INTO sml_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tuhan to'ongan ya bay angahinang duwa batu itu, maka Tuhan ya bay angukil saga sara'. ");
INSERT INTO sml_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Na, makakale pa'in si Yussa' ma hidjulan saga a'a Isra'il, yukna ma si Musa, “Sali' hidjul pagbono' ya takaleku itu!” ");
INSERT INTO sml_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ya sambung si Musa, “Ngga'i ka hidjul panganda'ug ya takaleta, ngga'i ka isab hidjul min a'a tara'ug, sagō' hidjul min saga a'a magkalangan.” ");
INSERT INTO sml_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Makasekot pa'in si Musa ni pustu he', bo' ta'nda'na sapi' bulawan maka saga a'a magpangigal ma munda'an sapi', magtūy arugal sidda atayna. Hantakanna duwa batu amasagi' ya bay tabowana bo' alopot ma atag ina'an, ma deyo'an būd. ");
INSERT INTO sml_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Niā' isab e' si Musa sapi' bay tahinang e' saga a'a Isra'il. Aubus bay tinunu', pinagpipis-pipis e'na bo' binudburan ma kuwit bohe'. Katapusanna, pamainum e'na ma saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Yuk si Musa ma si Harun, “Ai bay tahinang ma ka'a e' saga a'a ilu ya angkan bowanu sigām maghinang dusa buwattilu heyana?” ");
INSERT INTO sml_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ya sambung si Harun, yukna, “Da'a pa'in akagit ataynu, tuwan. Kata'uwannu saga a'a itu, aluhay sigām tabowa maghinang kala'atan. ");
INSERT INTO sml_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bay sigām amissala ma aku, yuk-i, ‘Hinangin kitam tuhan magmunda' ma kitam ma pal'ngnganan. Daka maingga si Musa inān, ya bay amowa kitam paluwas min Misil.’ ");
INSERT INTO sml_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Angkan yukku ma sigām, ‘Sai-sai kam taga-pamulawan, la'aninbi.’ Magtūy ni'nde'an ni aku saga pamulawan sigām ati pehē'ku ni deyom api. Pagtunaw pa'in, paluwas sapi' mandangan inān!” ");
INSERT INTO sml_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Na, ta'nda' e' si Musa saga a'a Isra'il wa'i magkangogan, mbal takole' nihawiran e' si Harun, angkan sigām tahinang pagtittowahan ma saga banta sigām. ");
INSERT INTO sml_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Jari itu, an'ngge na si Musa ma pagsosōran pustu maka e'na amissala, yukna, “Sasuku kam bilahi ameya' ma si Yawe, pi'itu kam ni aku.” Magtūy pehē' ni iya kamemon saga kal'llahan panubu' si Libi. ");
INSERT INTO sml_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Yuk si Musa ma sigām, “Ya pamah'lling ka'am e' si Yawe Tuhan bangsa Isra'il, in ka'am subay magtinakos pakaniya-pakaniya. Latagunbi kauman itu min dampōng ni dampōng amapatay pagkahibi bangsa Isra'il ai-na ka kampungbi, ai-na ka bagaybi.” ");
INSERT INTO sml_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Na bineya' e' saga panubu' si Libi panoho'an si Musa he' ati magpatayan saga t'llungibu a'a ma llaw ina'an. ");
INSERT INTO sml_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Pagubus, yuk si Musa, “Llaw itu, in ka'am saga panubu' si Libi tapasaddī na bo' ma PANGHŪꞋ-Yawe sadja, kalna' kam bay magmalilla' amono' saga anakbi maka langgungbi. Angkan kam kabuwanan kahāpan e' PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pag'llaw dakayu', ah'lling si Musa ma saga a'a inān, yukna, “Aheya to'ongan dusa bay tahinangbi. Saguwā', minsan buwattē', patukad aku ni būd pabalik angarap ni PANGHŪꞋ. Kalu-kalu mura-murahan nirūlan aku angamu'an ka'am ka'ampunan ma pasal dusabi.” ");
INSERT INTO sml_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Manjari patukad si Musa pabalik ni PANGHŪꞋ. Yukna ma iya, “Arōy Tuhanku, aheya sidda dusa bay tahinang e' saga a'a itu. Bay sigām makahinang tuhan-tuhan min bulawan panumbahan sigām. ");
INSERT INTO sml_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ndū', bang pa'in dūlannu panganjunjungku, ampunun dusa sigām. Malaingkan bang sigām mbal ampunnu, na, papasin ōnku min kitab ya panulatannu ōn saga a'a suku'nu.” ");
INSERT INTO sml_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ya sambung PANGHŪꞋ ma si Musa, “Luwal saga a'a bay makarusa ni aku ya papasanku min kitabku. ");
INSERT INTO sml_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Na pehē' na ka. Bowahun saga a'a ilu tudju ni lahat ya bay pangahakaku ma ka'a. Ilu isab mala'ikatku parahū min ka'a ma labayan. Sagō' bang ta'abut waktuna, tiksa'ku sasuku bay makarusa ilu.” ");
INSERT INTO sml_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Jari aniya' saki landu' abangat pinat'kka e' PANGHŪꞋ ma bangsa Isra'il ma sabab bay kahinangan sigām ma sapi' bulawan ya bay tahinang e' si Harun. ");
INSERT INTO sml_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Na magsuwala PANGHŪꞋ-Yawe ma si Musa, yukna, “Patulak kam minnitu, ka'am maka saga a'a bay bowanu paluwas min lahat Misil. Pauntas kam ni lahat bay panganjanji'ku ma si Ibrahim, si Isa'ak maka si Yakub. Aniya' bay panapaku ma sigām, ya yukku, ‘Pamuwanku lahat inān ma saga panubu'bi.’ ");
INSERT INTO sml_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Pabeya'ku dakayu' mala'ikat parahū min ka'am. Dūyku isab saga kabangsahan maglalahat mahē', ya na saga bangsa Kana'an, bangsa Amor, bangsa Hīt, bangsa Pirissi, bangsa Hīb maka bangsa Jibus. ");
INSERT INTO sml_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pauntas kam ni lahat e', ya lahat ap'nno' e' kalluman landu' ahāp. Sagō' in aku itu mbal pasehe' ma ka'am sabab kalna' atuwas saga kōkbi. Bang kam saupama sehe'anku, marai' kam paka'atku to'ongan ma labayan.” ");
INSERT INTO sml_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Na, kahaka'an pa'in saga a'a Isra'il pasal pamissala makasusa itu, magtūy sigām anagna' magsusun maka halam aniya' min sigām magpamulawan. ");
INSERT INTO sml_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Sabab aniya' bay panoho'an PANGHŪꞋ ma si Musa, yukna, “Haka'in saga a'a Isra'il in sigām bangsa landu' atuwas. Bang aku pasehe' ma sigām minsan la'a dansasa'at, marai' sigām mulaku saru'un-du'un. Sō'un sigām angala'anan ba'anan pamulawan ya pamakay sigām. Kira-kiraku lagi' bang ai hinangku ma sigām.” ");
INSERT INTO sml_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Manjari itu, makalanjal pa'in saga bangsa Isra'il min atag Būd Horeb (Būd Turusina), halam na sigām magpamakay saga pamulawan. ");
INSERT INTO sml_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Na ya kabiyaksahan si Musa maingga-maingga pahanti'an sigām bangsa Isra'il, amat'ngge iya dakayu' luma' tolda alawak-lawak min pustu. “Tolda pagsabuhan Tuhan maka manusiya'” ya pangōn si Musa ma tolda inān. Jari bang aniya' bilahi angaru ni PANGHŪꞋ-Yawe, subay iya paluwas min kauman pehē' ni Tolda Pagsabuhan. ");
INSERT INTO sml_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Na sakahaba' si Musa paluwas pehē' ni luma' pagsabuhan, magt'nggehan saga a'a kamemon ma bowa' lawang tolda sigām. Ang'nda' sigām ma si Musa sampay iya pasōd na ni deyom. ");
INSERT INTO sml_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Makasōd pa'in iya, pareyo' pina'an gabun-Tuhan ni dahuan lawang luma' he' bo' paddas maina'an sat'ggol si Yawe maka si Musa magsuli-suli. ");
INSERT INTO sml_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pag'nda' saga a'a ma gabun-Tuhan pat'nna' ma atag pagsosōran luma' tolda, pabungkal sigām bo' yampa pasujud anumba ni Tuhan, kaniya-kaniya sigām ma bowa' lawang sigām. ");
INSERT INTO sml_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tiyap-tiyap maina'an si Musa ma deyom tolda, magharap PANGHŪꞋ maka iya magbissala buwat a'a magsuli-suli maka bagayna. Aubus pa'in, ya kabiyaksahan si Musa subay pabalik ni deyom kauman, sagō' tendogna si Yussa', ya anak si Nūn, halam bay paluwas min tolda pagsabuhan e'. ");
INSERT INTO sml_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ah'lling gi' si Musa ma PANGHŪꞋ-Yawe, yukna, “Tasoho'nu aku amowa saga a'a itu patukad ni lahat e', saguwā' halam aku haka'annu bang sai pasehe'nu ma aku. Yuknu in aku taitungnu bagaynu lissi, maka kasulutan ka ma aku. ");
INSERT INTO sml_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Jari bang ka ka'amuhan du ma aku, ndū', pandu'in aku ma pasal kamaksurannu supaya aku makata'u ma ka'a sampay makasulut na pa'in ma ka'a. Entomun isab bangsa itu sabab suku'nu asal.” ");
INSERT INTO sml_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ya sambung PANGHŪꞋ ma si Musa, “Sehe'anta du ka, maka buwananta ka kasannangan atay.” ");
INSERT INTO sml_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Yuk si Musa, “Ya Tuhanku, bang kami mbal sehe'annu to'ongan, ahāp lagi' kami mbal palanjalnu min jadjahan itu-i. ");
INSERT INTO sml_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Sabab bang kami siya-siyanu mbal kinata'uwan e' sai-na in ka'a kasulutan ma aku maka ma bangsa suku'nu. Bang kami mbal sehe'annu, halam aniya' pagbidda'an kami maka palbangsahan kasehe' ma sakalibut dunya itu.” ");
INSERT INTO sml_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Sakali anambung PANGHŪꞋ ma si Musa, yukna, “Dūlanku ya pangamu'nu ilu sabab kasulutan aku ma ka'a, maka kata'uwanku ōnnu.” ");
INSERT INTO sml_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na, aniya' gi' pangamu' si Musa ma Tuhan, yukna, “Bang pa'in aku pa'nda'annu sahayanu.” ");
INSERT INTO sml_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ya sambung PANGHŪꞋ, “Aho', palamanku kahāpanku kamemon ma matahannu. Maka sabbutku isab ōnku ma pakalehannu, in aku si Yawe Tuhan-asal-Tuhan. Aku ya tag-baya'an bang sai ya pinat'kkahan lasaku maka bang sai kina'ase'an. ");
INSERT INTO sml_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Malaingkan,” yuk PANGHŪꞋ, “mbal ka makajari ang'nda' ma baihu'ku. Sabab amatay sadja saga manusiya' bang maka'nda' ma aku. ");
INSERT INTO sml_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Na,” yukna, “aniya' batu lakit pan'nggehannu ilu, asekot-sekot ni aku. ");
INSERT INTO sml_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Manjari bang palabay sahayaku ma matahannu, pasindungta ka ma deyom songab batu itu. Tampananta ka maka tanganku hinabuku palabay min ka'a. ");
INSERT INTO sml_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Makalabay pa'in, la'ananku tanganku supaya ka maka'nda' bukutku. Sagō' in baihu'ku mbal makajari ni'nda'.” ");
INSERT INTO sml_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Manjari angallam gi' PANGHŪꞋ ma si Musa yukna, “Sapsapin batu amasagi' duwa hekana, daluwa maka bay dahū. Sulatku mailu saga panoho'an bay ma batu tagna', ya bay lopotnu. ");
INSERT INTO sml_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pasakap ka salung subu bo' ka patukad ni Būd Turusina itu. Pagtukadnu ni pussuk būd, an'ngge ka ma matahanku. ");
INSERT INTO sml_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Subay halam aniya' parongan ma ka'a. Minsan maingga-maingga ma sakalingkal būd itu, subay halam aniya' manusiya' ta'nda', luwal ka'a. Minsan hayop, bili-bili ka atawa sapi', subay halam aniya' magkakan ma deyo'an būd ilu.” ");
INSERT INTO sml_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Sakali sinapsapan e' si Musa duwa batu amasagi', daluwa maka bay tagna'. Pagdai'llaw pa'in, patukad iya ni Būd Turusina' maka e'na amowa duwa batu he'. Hatina bineya' e'na bay panoho'an PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Sakali patulun si Yawe min deyom gabun bo' an'ngge ma atag si Musa. Tapata'u isab e' Tuhan ōnna si Yawe ya Tuhan-asal-Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Magsuwala iya hinabuna palabay min alopan si Musa. Yukna, “Aku si Yawe ya Tuhan-asal-Tuhan. Patitabangun asal aku maka patiase'un. Alallay aku angastol, al'kkas aku amaluwas lasaku, lasa mbal magkapinda. ");
INSERT INTO sml_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Taptap lasaku ma saga manusiya' sampay ni kaibuhan pangkat. Ampunku kasā'an maka karusahan sigām. Ampunku minsan sigām anagga' sara'. Saguwā' bang a'a makarusa, mbal to'ongan pasagaranku. Papole'ku karusahanna ni anak-mpuna, sampay ni mpuna tu'ut, sampay ta'abut mpat pangkat.” ");
INSERT INTO sml_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Na pagkale si Musa ma bissala Tuhan itu, magtūy iya pasujud anumba. ");
INSERT INTO sml_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Yukna, “O Panghū'ku, bang ka kasulutan sab'nnal-b'nnal ma aku, ndū' Tuhan, bang pa'in ka pagapi' ma kami. Minsan atuwas kōk saga bangsaku itu, ampunun pa'in kala'atan maka karusahan kami. Taima'un kami ati hinangun kami saga a'a suku'nu.” ");
INSERT INTO sml_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Angallam PANGHŪꞋ-Yawe ma si Musa, yukna, “Nda'un, paniya'ku paljanji'anku ma ka'a pabīng. Angahinang aku saga hinang makainu-inu ma pang'nda'an saga a'a bangsanu Isra'il kamemon. Halam to'ongan aniya' bay makahinang buwattē', minsan ma ai lahat, minsan ma ai bangsa. Song ta'nda' hinangku makatāw-tāw e' saga a'a ya pat'nna' ma sakalibutnu, ati tasayu e' sigām bang buwattingga panabangku ma ka'a. ");
INSERT INTO sml_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Beya'un saga sara' panoho'an ya pat'nna'anku ka'am llaw itu. Dūyku min dahuannu saga bangsa Amor, bangsa Kana'an, bangsa Hīt, bangsa Pirissi, bangsa Hīb maka bangsa Jibus. ");
INSERT INTO sml_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Amay-amay, da'a kam magkahāp maka saga bangsa ya asal maglahat ma lahat ya song papehē'anbi ilu. Tantu kam pinalabayan kasasatan e' sigām, sapantun jallat ma tape'bi. ");
INSERT INTO sml_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Paka'atunbi saga tampat ya pagkulbanan sigām. Lopotunbi saga batu paosol ya pagsusumbahan sigām. Puwarunbi isab saga hāg pangilāhan si Asera, ya tuhan sigām d'nda. ");
INSERT INTO sml_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Wajib kam da'a magta'at ma pagtuhanan saddī min aku, sabab si Yawe aku, ya Tuhan-asal-Tuhan. Mbal to'ongan aku bilahi aniya' pagtuhananbi saddī min aku. ");
INSERT INTO sml_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Amay-amay, da'a kam amiha magkahāp maka saga bangsa ya asal maglahat ma lahat song papehē'anbi ilu. Sabab kalna', bang kam ganta' magkahāp maka sigām, tantu kam pinogos e' sigām ang'bba min aku bo' magta'at ni saga pagtuhanan sigām. Tabowa kam magsalu isab maka sigām ati kakanbi ba'anan susumbali'an bay pangungsud ni pagtuhanan sigām e'. ");
INSERT INTO sml_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Lāgi bang aniya' saga anak sigām budjang tapene'bi pamah'nda ma ka'anakanbi l'lla, tantu sigām kapitnahan e' saga d'nda he' subay palamud ana'at ni saga pagtuhanan sigām.” ");
INSERT INTO sml_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Amalman Tuhan, yukna, “Wajib kam da'a magsasal tumbaga nihinang ta'u-ta'u pagtuhanan.” ");
INSERT INTO sml_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Wajib kam maghinang Hinang Tinapay Halam Pasuligna sakahaba' tahun bang ta'abut bulananna. Subay pitumbahangi ya t'ggolbi magkakan tinapay halam bay pinasuligan, buwat bay panoho'anku ma ka'am. Hinangunbi ma bulan Abib, ya na bulan bay kapaluwasbi min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Pamasuku'unbi ma aku kamemon saga anakbi kasiyakahan l'lla, beya' isab saga hayop l'lla ya dahū nianakan, ai-na ka bili-bili maka kambing, ai-na ka sapi'. ");
INSERT INTO sml_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Sagō' mbal taluwa' kinulban bang kura'. Bang aniya' kura' anganak kamint'ddana, in anak kura' inān subay nil'kkat, hatina subay aniya' dakayu' anak bili-bili atawa kambing sinumbali' ganti'na. Bang saupama mbal nil'kkat, na subay pinōng buli'-k'llongna sabab kura' iya. Saga anakbi l'lla kasiyakahan isab, subay nil'kkat maka susumbali'an pagkulbanbi ni Tuhan. Amay-amay isab, bang kam angarap ni aku sumiyan-sumiyan, subay kam amowa tutukbalan. ");
INSERT INTO sml_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Makajari kam maghinang atawa magusaha ma deyom nnom llaw, sagō' subay kam pahali maghinang ma llaw kapitu'na. Minsan ma waktu pagararu atawa waktu pagani, subay kam pahali ma llaw kapitu'. ");
INSERT INTO sml_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Hinangunbi Paghinang Kapitu'an ma waktu paganibi saga buwa' tirigu. Hinangunbi Paghinang Anihan Damuli ma song pa'in waktu paghaggut. ");
INSERT INTO sml_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Manjari t'llu waktu ma deyom dantahun ya pagtipun kamemon saga kal'llahanbi ma matahan si Yawe, ya pagpanghū'an bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Da'a kabimbanginbi saga tana'bi bang kam alikut magtipun ni aku ya Tuhanbi. Halam sai-sai anganapsuhan tana'bi sabab paluwasku min dahuanbi saga bangsa Amor, bangsa Kana'an, bangsa Hīt, bangsa Pirissi, bangsa Hīb maka bangsa Jibus. Paluhaku isab lahat ya pat'nna'anbi. ");
INSERT INTO sml_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Na bang kam anumbali' hayop pagkulbanbi ni aku, da'a papagbeya'un laha'na maka tinapay halam pinasuligan. Bang kam maghinang Hinang Paglakad, da'a kapininbi isi susumbali'an sampay ni kasalungan. ");
INSERT INTO sml_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Bang kam anagna' magani tinanom atawa magpusu' buwa' kayu, pene'unbi ya ahāp to'ongan bo' bowahunbi ni Luma' pangarapanbi ni si Yawe ya Tuhanbi. “Bang aniya' anak kambing b'llabi, da'a paglamurunbi maka gatas ina'na.” ");
INSERT INTO sml_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Pagubus, ah'lling PANGHŪꞋ-Yawe ma si Musa, yukna, “Sulatun saga kabtangan itu sabab kataddangan ko' itu ma paljanji'antam.” ");
INSERT INTO sml_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Jari mpatpū' bahangi ya panimpus si Musa maina'an ma atag PANGHŪꞋ, maka halam aniya' bay takakanna atawa tainumna t'ggolna bay maina'an. Tasulat e'na ma duwa papagan batu saga kabtangan paljanji'an, hatina Sara' Panoho'an sangpū' hekana. ");
INSERT INTO sml_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Na, palūd si Musa min Būd Turusina' amowa duwa papan batu ya panulatan paljanji'an Tuhan maka bangsa Isra'il. Paglūd na pa'in, halam tasayu e' si Musa in baihu'na anahaya asal ma sabab kapagsuli-sulina maka PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Pag'nda' si Harun maka kamemon saga a'a Isra'il ma sahaya baihu' si Musa, na tināw sigām pasekot ni iya. ");
INSERT INTO sml_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Malaingkan nilinganan e' si Musa disi Harun maka kamemon saga pagbebeya'an bangsa Isra'il. Sinō' sigām pabalik ni atagna bo' sigām bissalahanna. ");
INSERT INTO sml_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pagubus, patipun ni si Musa saga a'a Isra'il kamemon ati pinasampay e'na ma sigām saga sara' kamemon bay panoho'an PANGHŪꞋ-Yawe ma iya ma diyata' Būd Turusina'. ");
INSERT INTO sml_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Aubus pa'in pamissala si Musa ma sigām, tinambunan e'na baihu'na bo' mbal ta'nda' sahayana. ");
INSERT INTO sml_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sagō' bang aniya' waktuna pasōd ni haddarat si Yawe magsuli-suli maka iya, nila'anan e'na tambunna he' sampay iya makaluwas pabīng. Pagluwas pa'in, pinalatun e'na ma saga bangsa Isra'il ai-ai bay panoho'an Tuhan ma iya. ");
INSERT INTO sml_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ta'nda' magtūy e' sigām baihu'na anahaya, angkan tinambunan baihu'na pabīng, sampay ni waktu kapagsuli-sulina maka PANGHŪꞋ-Yawe pabalik. ");
INSERT INTO sml_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Manjari itu, pinalinganan e' si Musa kamemon saga bangsa Isra'il, sinō' patipun ma iya. Yukna ma sigām, “Ka'am saga bangsa Isra'il, ya itu saga hatulan panoho'an ka'am e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Nnom llaw ya pamihabi ka'lluman, sagō' bang ta'abut llaw kapitu'na, ya na llaw mulliya, llaw paghali pamaheyabi ma PANGHŪꞋ. Sasuku maghinang ai-ai ma llaw itu subay pinapatay. ");
INSERT INTO sml_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Da'a kam minsan magparokot api ma deyom luma'bi ma Llaw Kapitu'.” ");
INSERT INTO sml_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ah'lling si Musa ma saga jama'a bangsa Isra'il kamemon, yukna, “Buwattitu panoho'an PANGHŪꞋ-Yawe ma ka'am, ");
INSERT INTO sml_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","sinō' kam amowa huhulmatan ni iya luwas min kaniya'bi. Bang isab tapangahilasbi, bowahunbi ni PANGHŪꞋ ba'anan saga ai-ai ya tinutat itu: bulawan, pilak maka tumbaga, ");
INSERT INTO sml_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","salban walna' bilu, taluk maka keyat, kakana' pote' ahāp hinanganna, bulbul kambing pangahinang kakana', ");
INSERT INTO sml_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kuwit bili-bili l'lla nianjibihan keyat, maka kuwit duyung isab. Bowahunbi kayu akasya, ");
INSERT INTO sml_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ns'llan buwa' jaitun ma palita'an, saga pamapā pamahamut ns'llan ya pangangg'llal imam, maka ginisan pamapā pamahamut kamanyan. ");
INSERT INTO sml_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Bowahunbi isab ginisan palmata pamalingkat epod (lampik-juba) maka puyu'-daggaha ya pinakay e' imam alanga.” ");
INSERT INTO sml_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Yuk si Musa isab, “Sasuku kam taga-kapandayan maghinang, pi'itu kam. Hinangunbi kamemon ya pamahinang e' PANGHŪꞋ-Yawe ma kitam. ");
INSERT INTO sml_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hinangunbi Luma' Pangarapanbi ma iya, apanyap maka toldana sampay turungna katapusan, ba'anan saga kakansingna, papagan dindingna, batang-batangna, hāgna maka durukanna isab. ");
INSERT INTO sml_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Hinangunbi Ba'ul Paljanji'an, beya' isab tanggunganna, maka turungna ya Pagtaubatan, maka kultina pangalikus. ");
INSERT INTO sml_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Hinangunbi lamisahan pamat'nna'an Tinapay Hadarat, jukup maka tanggunganna, maka saga kapanyapanna, ");
INSERT INTO sml_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","palita'an pitu' sumbuhanna ya pamasawa deyom Luma', beya' isab kapanyapanna maka ns'llan pamakeyat iya. ");
INSERT INTO sml_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Hinangunbi lamisahan pagtugtugan kamanyan maka tanggunganna, ns'llan sussi pangangg'llal imam, kamanyan ahamut, maka kultina panambol lawang ya pagsosōran ni Luma' Pangarapan. ");
INSERT INTO sml_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Hinangunbi isab lapohan pagtunu'an susumbali'an maka pangayakanna tumbaga, beya' isab tanggunganna maka saga kapanyapanna kamemon, garul pagailan nihinang min tumbaga sampay patinggilan ya pamat'nna'an iya. ");
INSERT INTO sml_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Hinangunbi saga kultina panasak halaman Luma', jukup maka saga hāg pangahāg sasak maka ba'anan durukan, beya' isab kultina ya panambol pagsosōran ni halaman e'. ");
INSERT INTO sml_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Hinangunbi bale pangengkotan tolda ya panurung Luma' Pangarapan sampay kakultinahan ya panasak halaman, maka ba'anan lubidna. ");
INSERT INTO sml_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Pagubus, t'nnununbi s'mmek pan'mmek saga imam ma waktu kapaghinang sigām ma Luma' Sussi, hatina saga s'mmek sussi ya pamakay si Harun maka saga anakna l'lla hinabu sigām magimam ma deyom Luma' Pangarapan.” ");
INSERT INTO sml_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Pagubus pamissala si Musa inān, magla'anan na min matahanna saga a'a Isra'il kamemon. ");
INSERT INTO sml_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Pabīng isab pina'an saga a'a kamemon ya taga-baya' anukbal kaniya' sigām ni PANGHŪꞋ, lilla' isab min deyom atay sigām. Binowa e' sigām ba'anan ai-ai pangahinang Tolda Pagsasabuhan, maka ai-ai pangahinang s'mmek ya pan'mmek imam. ");
INSERT INTO sml_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Jari pina'an saga l'lla maka d'nda kamemon sasuku taga-baya' amuwan, binowa e' sigām kaginisan saga pamulawan, buwat saga kait, aretes, singsing, gallang maka palmata, bo' niangkat e' sigām pangahulmat ma PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Saga a'a isab taga-salban walna' bilu, taluk maka keyat, atawa kakana' ahāp hinanganna, atawa bulbul kambing, atawa kuwit kambing l'lla bay nianjibihan keyat, atawa kuwit duyung, bay amowa saga palsuku'an sigām pina'an. ");
INSERT INTO sml_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Saga a'a isab taga-pilak atawa tumbaga aponod, bay amowa alta' sigām e' panukbal sigām ma PANGHŪꞋ. Ya du amowa saga a'a taga-kayu akasya ya kinagunahan ma luma' Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kamemon saga kar'ndahan taga-pangita'u isab bay aminsal salban, ati binowa e' sigām kakana' ahāp ya bay nihinang e' sigām min salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Sasuku sigām taga-pangita'u, ya bilahi isab palamud, bay aminsal salban min bulbul kambing. ");
INSERT INTO sml_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Saga a'a pagbebeya'an isab bay amowa palmata onek maka palmata indaginis ya pinat'nna' ma epod maka ma puyu'-daggaha ya pan'mmek imam alanga. ");
INSERT INTO sml_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Binowa isab e' sigām ns'llan jaitun ya kagunahan pamakeyat palita'an ma deyom Luma', maka pangangg'llal imam. Binowa isab pamapā pangalamud ma ns'llan e', maka pamahamut kamanyan. ");
INSERT INTO sml_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Jari sai-sai taga-baya' ma kaluha'an bangsa Isra'il, l'lla ka atawa d'nda, bay amowa huhulmatan panukbal sigām ma PANGHŪꞋ, hilas min deyom pangatayan. Tapamuwan e' sigām ai-ai ya kinagunahan ma saga hinang bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Na amissala si Musa ma saga bangsa Isra'il, yukna, “Pata'u kam. Tapene' e' PANGHŪꞋ si Besalel anak si Uri ya anak si Hūr, min bangsa Yuda. ");
INSERT INTO sml_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Aniya' pangita'u maka akkal maka kapandayan bay pamatulun e' Tuhan ma iya supaya iya makahinang ai-ai ahāp maka alingkat. ");
INSERT INTO sml_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ata'u iya angangguhit suntu'an ma ai-ai tahinang min bulawan atawa min pilak atawa min tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ata'u iya anganggaugari' ginisan palmata bo' yampa pasangonna ma kait bulawan. Ata'u isab angukil kayu, maka ata'u angahinang kapanyapan indaginis bo' ahāp ninda'. ");
INSERT INTO sml_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Aniya' akkal pamuwan e' Tuhan ma iya maka ma si Oholeyab anak si Ahisamak min bangsa Dān, supaya sigām makapandu' ma saga a'a kasehe'an. ");
INSERT INTO sml_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Jari katulunan sigām kapandayan angkan ata'u maghinang kaginisan ai-ai, ata'u isab magguhit suntu'an. Ata'u isab sigām magbuldahan kakana' pote' maka salban bilu, taluk maka keyat, ata'u isab angahinang kakana' landu' ahāp isina. Apanday kamemon saga a'a itu maghinang ai-ai ya kahinangan tangan, alalom isab pikilan sigām magguhit suntu'an kaginisan.” ");
INSERT INTO sml_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Manjari niamay-amayan si Besalel maka si Oholeyab sampay saga a'a kamemon ya kabuwanan akkal maka kapandayan e' si PANGHŪꞋ-Yawe supaya sigām makahinang Luma' Sussi maka ba'anan kapanyapanna. Sinō' sigām ameya' to'ongan ma bay panoho'an PANGHŪꞋ ma sigām.” ");
INSERT INTO sml_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Pagubus, pinalinganan na e' si Musa si Besalel maka si Oholeyab maka saga a'a kamemon ya kabuwanan kapandayan e' PANGHŪꞋ, beya' isab sasuku taga-kōg maka baya'. ");
INSERT INTO sml_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tasambut he' sigām min si Musa ba'anan saga huhulmatan bay tatukbal e' saga a'a Isra'il pamapagdayaw maka pamapanyap ma Luma' Pangarapan e'. Aniya' na pa'in saga huhulmatan pinagbowa e' saga a'a Isra'il inān kahaba' subu, ");
INSERT INTO sml_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","angkan saga a'a ata'u maghinang bay ang'bba min hinang sigām ");
INSERT INTO sml_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","bo' pehē' ah'lling ni si Musa. Ya yuk sigām, “Tuwan, maglabi to'ongan ya pinagbowa na pa'in e' saga a'a itu. Sarang na makahinangan kamemon bay panoho'an PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Jari aniya' panoho'an si Musa bay pinasaplag ma kaluha'an kauman, yukna, “Ka'am kamemon d'nda maka l'lla, sinō' pahali amowa saga huhulmatan paghinangta Luma' Sussi.” Minnē' sigām tabowa pahali ang'nde'an ba'anan bubuwanan sigām labi-manglabi. ");
INSERT INTO sml_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Sabab sarang na, maka'abut pangahinang Luma' Pangarapan sampay kamemon kapanyapanna. ");
INSERT INTO sml_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Manjari tahinang Luma' Pangarapan he' saga maghihinang, sasuku sigām alalom pikilanna. Tahinang e' sigām sangpū' sugpat kultina min kakana' ahāp isina pinaglamuran salban bilu, taluk maka keyat. Aniya' isab sali' luwa mala'ikat pikpikan binulda pina'an he' saga a'a apanday magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","In ba'anan sugpat kultina itu dasali' sukuranna kamemon, pitund'ppa taha'na maka dand'ppa lambuna. ");
INSERT INTO sml_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Lima sugpat kultina bay tinahi' e' sigām pinagbihing-bihing, damikiyanna isab lima hekana takapin, manjari duwa kultina ataha' na. ");
INSERT INTO sml_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","12","Na aniya' tainga-tainga nihinang min kakana' bilu tinahi' pehē' ni tōng kultina ataha' inān karuwa, hatina lima-limampū' heka tainga-tainga tahinang maganggop-anggop. ");
INSERT INTO sml_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Aniya' isab kakansing bulawan limampū' hekana tahinang pamarakayu' duwa kultina inān bo' supaya arakayu' deyom Luma' Pangarapan. ");
INSERT INTO sml_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Pagubus, aniya' kultina bay nihinang e' saga a'a inān min bulbul kambing, sangpū' maka dda sugpatna pangalapis kultina deyom. ");
INSERT INTO sml_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Daheya du saga sangpū' maka dda sugpat kultina damuli itu, taha'na pitund'ppa maka tonga', lambuna dand'ppa. ");
INSERT INTO sml_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Lima sugpatna bay tinahi' pinagbihing-bihing bo' tahinang dakayu' kultina ataha', damikiyanna isab nnom heka sugpatna takapin. ");
INSERT INTO sml_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Puwas e' aniya' tainga-tainga kakana' nihinang e' sigām ma tōng kultina karuwa, lima-limampū' hekana, ");
INSERT INTO sml_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","limampū' isab kakansing tumbaga pamaralos kultina bulbul kambing e'. ");
INSERT INTO sml_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Pagubus, aniya' duwa ginis turung tahinang e' saga a'a inān panurung kamemonna. Dakayu' turung inān bay tahinang min kuwit bili-bili l'lla nianjibihan keyat, dakayu' isab tahinang min kuwit duyung, ya na turung katapusan. ");
INSERT INTO sml_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Aniya' isab saga papagan tahinang e' sigām min kayu akasya pamarindingan Luma' Pangarapan e'. ");
INSERT INTO sml_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Duwand'ppa maka tonga' ya langkawna, t'llu h'kka lambuna. ");
INSERT INTO sml_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Tahinang isab lagsak duwa hekana patuwa' min deyo'anna. Buwattē' ya pangahinang saga papagan dinding kamemon, ");
INSERT INTO sml_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","26","duwampū' hekana min bihing luma' tampal ni satan, duwampū' isab min bihingna tampal ni uttala'. Aniya' isab saga durukan dī pilak tasasal e' saga a'a maghihinang, mpatpū' hekana, hatina duwa durukan ma dakayu' papagan bo' aniya' pamatukan lagsak e'. ");
INSERT INTO sml_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Tahinang isab saga papagan nnom hekana pamarindingan kōkan luma' (tampal ni s'ddopan), ");
INSERT INTO sml_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","maka duwa hekana isab ma duguna karuwa. ");
INSERT INTO sml_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","In duwa heka papagan itu bay pinapagtapil min deyo' sampay pariyata', maka diyata' bay pinasulug ni dakayu' gallang bo' mbal magpuklas. ");
INSERT INTO sml_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Manjari walu' heka papagan ya tahinang pamarindingan kōkan luma', sangpū' maka nnom isab durukan tahinang min dī pilak. ");
INSERT INTO sml_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Aniya' isab saga batang-batang pamahogot dinding bay tahinang e' saga a'a maghihinang e', lima-lima hekana ma bihing luma' dakayu' maka dakayu', lima hekana isab ma kōkan (tampal ni s'ddopan). ");
INSERT INTO sml_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ya batang-batang ma t'ngnga' dinding bay pina'abut e' sigām min tōng dakayu' tudju ni tōng dakayu'. ");
INSERT INTO sml_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Bay pinutusan bulawan saga papagan dinding itu, beya' isab batang-batangna. Maka aniya' isab saga gallang bulawan tahinang e' sigām pamasulugan ba'anan batang-batang e'. ");
INSERT INTO sml_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Pagubus, aniya' kultina tahinang pangalikus deyom Luma' Pangarapan, tampal ni kōkan. Tahinang e' sigām min kakana' landu' ahāp isina, pinaglamuran isab salban bilu, taluk maka keyat. Aniya' isab sali' luwa mala'ikat pikpikan binulda pina'an he' a'a apanday magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Aniya' saga hāg akasya mpat hekana bay tahinang e' saga a'a maghihinang e', pinutus isab maka bulawan. Aniya' isab saga sasabit bulawan tasasal e' sigām panagnatan kultina, maka durukan hāg tasasal min pilak aponod. ");
INSERT INTO sml_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Pagubus, aniya' kultina tahinang e' sigām panambol lawang pagsosōran ni Luma'. Kakana' ahāp isina ya pangahinang kultina itu, binulda maka salban bilu, taluk maka keyat e' a'a magbubulda. ");
INSERT INTO sml_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Tahinang isab e' sigām saga hāg lima hekana, jukup maka sasabit. Kōk hāg itu bay pinutus maka bulawan, batangna bay nileboran isab maka bulawan. Aniya' isab durukan tumbaga tahinang e' sigām pamat'nggehan saga hāg. ");
INSERT INTO sml_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Na, makahinang ba'ul si Besalel min kayu akasya, lima h'kka taha'na, t'llu h'kka lambuna, t'llu h'kka isab langkawna. ");
INSERT INTO sml_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Bay pinutus deyom-luwasanna maka bulawan porol, pinalingkat isab kīdna maka gipis bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nihinang e'na mpat gallang bulawan pinatli' pehē' ni tape' ba'ul, duwa gallang min bihing ba'ul dambila', duwa isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Pagubus, aniya' tanggungan nihinang e' si Besalel min kayu akasya, pinutus isab maka bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Pinasulug magtūy ni gallang ya ma bihing ba'ul bo' aniya' pananggungan. ");
INSERT INTO sml_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Tahinang isab e' si Besalel turung ba'ul, ya pinagōnan Turung Pagtaubatan. Tasasal e'na min bulawan porol, lima h'kka taha'na, t'llu h'kka lambuna. ");
INSERT INTO sml_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Pagubus, tasasal e'na duwa mala'ikat pikpikan, dakayu' min dantōng turung ba'ul, dakayu' isab min dantōng. Langkus asal bulawan mala'ikat maka bulawan turung, da-sasalan du. ");
INSERT INTO sml_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Pab'llat pariyata' pikpik mala'ikat itu makalandungan turung ba'ul. Magharap duwa mala'ikat e', maka e' sigām angandomolan turung. ");
INSERT INTO sml_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Na, bay makahinang lamisahan disi Besalel min kayu akasya, mpat h'kka taha'na, duwa h'kka lambuna, t'llu h'kka isab langkawna. ");
INSERT INTO sml_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Taputus e' sigām maka bulawan porol, maka pinalingkat mpat kīdna maka gipis bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Aniya' isab paga-paga saga da'mpāt-tangan lambuna tahinang e' sigām ma sakalibut lamisahan e', pinalingkat isab maka gipis bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Pagubus, makahinang sigām saga gallang mpat hekana bo' pinatli' pehē' ni mpat duguna, min diyata' saga tape'. ");
INSERT INTO sml_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gallang itu bay pinasekot ni paga-paga bo' aniya' pamasulugan tanggungan bang subay nihangkut. ");
INSERT INTO sml_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Tahinang isab saga tanggungan min kayu akasya taputus maka bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Manjari tahinang na isab e' disi Besalel saga kapanyapan lamisahan buwat saga lai, saga pinggan, maka saga pangisihan binu-anggul ya binu'usan pangahulmat Tuhan. Ba'anan saga kapanyapan itu bay nihinang min bulawan porol. ");
INSERT INTO sml_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Na, tahinang palita'an he' disi Besalel, sinasal min bulawan porol. Dalos asal hinanganna min buli'na sampay ni batangna, beya' isab saga pinggan-pingganna, ya pinagukilan sali' luwa sumping. ");
INSERT INTO sml_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","In batang palita'an itu magsanga nnom, t'llu min dambila' batang, t'llu isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Saga sanga itu bay kahinangan pinggan-pinggan sali' luwa sumping almon t'llu hekana ma saga sanga ka'nnom pakaniya-pakaniya. ");
INSERT INTO sml_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Damikiyanna in baran palita'an, bay kahinangan pinggan-pinggan isab sali' luwa sumping almon, mpat hekana, ");
INSERT INTO sml_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","dakayu' min deyo' saga sanga panagna'an, dakayu' min deyo' saga sanga t'ngnga'an, dakayu' isab min deyo' sanga ma diyata'an, jari nnom sangana. ");
INSERT INTO sml_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Jari langkus hinanganna kamemon, baran palita'an maka ba'anan sumping-sumpingna maka saga sangana. Bulawan porol ya pangahinang iya. ");
INSERT INTO sml_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Tahinang isab e' disi Besalel saga palita'an maka pangisihan ns'llan pitu' hekana, jukup maka saga sisipit pamahāp sumbuhan maka saga talam-talamna. Bulawan porol ya pangahinang. ");
INSERT INTO sml_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Manjari t'llumpū' maka mpat kilu ya buhat bulawan bay pangahinang palita'an maka kamemon kapanyapanna inān. ");
INSERT INTO sml_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Pasunu', aniya' lamisahan amasagi' tahinang e' sigām min kayu akasya, pagtugtugan kamanyan. Lambuna maka taha'na duwa h'kka sali'-sali', langkawna mpat h'kka. Aniya' pussuk-pussuk sali' luwa tanduk bay tahinang e' sigām ma duguna, dalos asal kayuna maka kayu bay pangahinangan baran lamisahan. ");
INSERT INTO sml_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Diyata' lamisahan maka saga kīdna, sampay isab saga pussuk-pussukna, bay pinutus maka bulawan porol. Aniya' isab gipis bulawan bay pinehē' ni kakīran lamisahan pamahāp luwana. ");
INSERT INTO sml_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Bay sigām makahinang gallang bulawan pamasulugan tanggungan. Pinasangon pehē' ni kīd lamisahan min deyo'an gipis e', dakayu' min dambila', dakayu' isab min dambila'. ");
INSERT INTO sml_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Makahinang sigām saga tanggungan isab min kayu akasya pinutus maka bulawan. ");
INSERT INTO sml_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Puwas e', bay sigām makahinang ns'llan landu' asussi ya pamehed ai-ai pinasuku' ma Tuhan, maka kamanyan ahamut. Bineya' e' sigām kapandayan saga a'a ata'u angahinang pahamut. ");
INSERT INTO sml_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Pagubus, aniya' lapohan pagtunu'an kulban tahinang e' disi Besalel min kayu akasya. Magpasagi' lambuna maka taha'na, sangpū' h'kka sali'-sali'. Nnom h'kka langkawna. ");
INSERT INTO sml_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Aniya' saga pussuk-pussuk sali' luwa tanduk bay tahinang ma duguna, dalos asal kayuna maka kayu ya pangahinangan baran lapohan. Jari taputus kamemonna maka dī tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Tahinang isab min tumbaga ba'anan kapanyapanna, buwat saga undam panaluran abu, saga kakagis, saga garul pangisihan laha' susumbali'an, saga tutugsuk aheya, sampay saga pangisihan baga. ");
INSERT INTO sml_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Aniya' pangayakan abu tahinang e' sigām min tumbaga bo' pinasangon ni deyom lapohan min deyo' paga-pagana, saga ma tonga'an kīdna. ");
INSERT INTO sml_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tasasal mpat gallang tumbaga pinehē' ni dugu pangayakan ka'mpat, ");
INSERT INTO sml_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","maka tahinang isab saga tanggungan min kayu akasya taputus maka tumbaga. ");
INSERT INTO sml_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","In tanggungan itu bay pinasulug ni gallang ya ma kīd lapohan karuwambila' bang nihangkut. Lapohan itu bay tahinang min papan, sali' luwa tu'ung halam aniya' turungna. ");
INSERT INTO sml_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Pagubus, tahinang e' disi Besalel garul pagailan maka patinggilanna. Ya tapagguna e' sigām saga tumbaga angalinig, ya bay pagsasaminan saga kar'ndahan ya magtatabang ma atag lawang pagsosōran ni Tolda Pagsasabuhan. ");
INSERT INTO sml_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","15","Pasunu', tahinang e' sigām halaman ma Luma' Pangarapan e', taha'na duwampū' maka limand'ppa, luhana sangpū' maka duwand'ppa maka tonga'. Aniya' kultina ahāp kakana'na tahinang e' sigām panasak halaman e', maka ba'anan hāgna isab panagnatan. Duwa-duwampū' heka hāg min bihingna tampal ni uttala' maka ni satan, sangpū' isab min tōngna tampal ni s'ddopan. Kamemon hāg itu bay nihinangan durukan min dī tumbaga maka sasabit pilak isab panagnatan kultina. In baran hāg isab bay nileboran pilak. Aniya' palabayan pagsōd-luwasan a'a tahinang ma tōng halaman tampal ni sobangan, maka aniya' kultina min karuwambila' lalabayan itu t'llu-t'llun d'ppa maka tonga' taha'na. Aniya' isab hāg t'llu hekana jukup maka durukanna pinat'nna' ma dambila' maka dambila'. ");
INSERT INTO sml_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ahāp kakana' ma saga kakultinahan kamemon ya panasak halaman. ");
INSERT INTO sml_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tumbaga isab ya pangahinang durukan hāg, bo' dī pilak ya pangahinang saga sasabitna maka lebod-lebodna. Saga kōk hāg isab bay pinutusan pilak, maka pilak isab ya pangalebod ma batangna. ");
INSERT INTO sml_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Manjari kultina ahāp kakana'na ya tahinang e' sigām panambol pagsosōran halaman e'. Kabuldahan isab kultina itu e' saga a'a magbubulda maka salban bilu, taluk maka keyat. Lambuna limand'ppa, langkawna dand'ppa maka tonga' sin tonga', hatina dalangkaw kultina dakayu' itu maka kultina ya panasak halaman. ");
INSERT INTO sml_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Aniya' mpat hāg bay tahinang e' saga a'a maghihinang panagnatan kultina panambol itu, maka mpat isab durukanna tahinang min tumbaga. Dī pilak ya pangahinangan sasabit hāg itu maka lebod-lebodna, maka pilak isab ya pamutus kōkna. ");
INSERT INTO sml_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Dī tumbaga saga bale ya pangahengkotan Luma' Pangarapan maka ba'anan kultina ma likusan halamanna. ");
INSERT INTO sml_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Na, ya na itu saga bulawan, pilak maka tumbaga ya tapaglagi e' saga a'a maghihinang ma Luma' Pangarapan, ya pinagōnan isab Luma' Pagtau'an Paljanji'an. Bay pinalista hekana e' si Musa ma saga panubu' si Libi. Si Itamar anak si Imam Harun ya tag-soho'an ma sigām itu. ");
INSERT INTO sml_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Si Besalel anak si Uri, mpu si Hūr min panubu' si Yuda, ya pagbebeya'an ma saga a'a maghihinang ma kamemon bay panoho'an PANGHŪꞋ-Yawe ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ya pasehe' ma si Besalel si Oholeyab anak si Ahisamak min panubu' si Dān. A'a ya apanday magguhit suntu'an maka maghinang ai-ai ya hinangan tangan. Ata'u isab iya magbuldahan kakana' ahāp maka salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Na, ya bulawan bay niangkat e' saga a'a Isra'il panukbal sigām ma Tuhan, 29 talen maka 730 sekel. Ya na bulawan bay pangahinang ba'anan ai-ai ma Luma' Sussi (Timbangan sara' agama ya pagtimbangan e'.) ");
INSERT INTO sml_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","In pilak isab bay ta'ā' min saga a'a Isra'il ma waktu kapangitung heka sigām, saga 100 talen maka 1,775 sekel bang tinimbang. (Timbangan sara' agama ya pagtimbangan e'.) Ya na pilak bay pamabayad ma kamemon saga kal'llahan Isra'il sasuku sigām duwampū' tahun umulna sampay pariyata'. 603,550 puhu' ya heka sigām bay taitung, maka tonga' sekel isab ya pamabayad ma sigām magkaniya-kaniya. ");
INSERT INTO sml_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Manjari, in dahatus talen pilak aponod inān bay pinagguna pangahinang saga durukan hāg dahatus hekana ma Luma' Sussi maka ma kultinana. Manjari dakayu' talen dī pilak tahinang dakayu' durukan. ");
INSERT INTO sml_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Pagubus, ningā' e' saga a'a maghihinang inān ya pilak aponod takapin, 1,775 sekel buhatna. Aniya' pinagguna e' sigām pangahinang saga sasabit dī pilak ma saga hāg, aniya' bay pangalebod baran saga hāg, maka aniya' bay pamutus kōk hāg e'. ");
INSERT INTO sml_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","In buhat tumbaga isab bay panukbal e' saga a'a Isra'il, 70 talen maka 2,400 sekel. ");
INSERT INTO sml_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Tapagguna e' sigām pangahinang saga durukan hāg ma lawang Tolda Pagsasabuhan, maka lapohan tumbaga, jukup isab maka pangayakanna tumbaga maka kamemon kapanyapanna. ");
INSERT INTO sml_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Tumbaga lullun ya tapangahinang saga durukan hāg ma sasak ya pangalikus halaman, maka ma labayan pagsōd-luwasanna. Tapangahinang du isab saga bale pangahengkotan ba'anan kultina ya pangatop Luma' Pangarapan, maka saga kultina ya pangalikus halamanna. ");
INSERT INTO sml_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Na aniya' saga s'mmek bay nihinang e' disi Besalel min salban bilu, taluk maka keyat, pan'mmek saga imam ya maghinang ma deyom Luma' Sussi. Aniya' isab s'mmek sussi nihinang e' sigām pamas'mmek si Harun. Jari bineya' bay panoho'an PANGHŪꞋ-Yawe ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Tahinang epod e' sigām min kakana' ahāp, binuldahan bulawan maka salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ya bulawan e' bay tinukul panipis to'ongan bo' pinagsanggi'-sanggi', jari pinalamud sanggi'anna ma salban bilu, taluk maka keyat. A'a apanday ya makahinang. ");
INSERT INTO sml_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Aniya' duwa sablayan pinatahi' e' sigām ni epod inān ma karuwambila'na bo' ahāp t'nna'na ma baran imam. ");
INSERT INTO sml_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Aniya' sambung ahāp isab nihinang e' a'a ata'u maghinang. Tahinang min kakana' ahāp bo' binuldahan sanggi' bulawan maka salban bilu, taluk maka keyat. Magdalos sambung itu maka baran epod. Jari bineya' bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Pagubus, aniya' duwa palmata onek bay pinat'nna' ma kait bulawan bo' yampa niukilan maka ōn saga anak si Isra'il l'lla kasangpū' maka duwa. Landu' anahut ukilanna, sali' ukilan singsing. ");
INSERT INTO sml_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Aubus pa'in, in palmata onek itu bay pinasangon ma sablayan epod e' saga a'a maghihinang, ma atag bahana, supaya aniya' pangentoman ma saga anak si Isra'il. Jari bineya' bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Na aniya' puyu'-daggaha tahinang e' a'a taga-kapandayan, sali' du hinanganna maka epod, hatina kakana' ahāp isina binuldahan bulawan maka salban bilu, taluk maka keyat. ");
INSERT INTO sml_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","In kakana' puyu' inān bay nilupi' duwa bo' amasagi', dah'kka taha'na, dah'kka isab lambuna. ");
INSERT INTO sml_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Na, aniya' saga palmata sangpū' maka duwa hekana bay pinat'nna' e' sigām ma dahuan puyu' he'. Pinagtād mpat, t'llu-t'llu heka palmata ma dantād. Palmata rubi (palmata alutu keyatna), topas (palmata kuning) maka berel (palmata jali'-jali') ya ma tād diyata'. ");
INSERT INTO sml_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Palmata turkwis (palmata bilu magb'ttik-b'ttik), sappir (palmata alutu biluna) maka emeral (palmata alutu' gaddungna) ya ma tād pasunu'. ");
INSERT INTO sml_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Palmata jasint (palmata bilu magb'ttik-b'ttik), agat (palmata magjali'-jali' kausun maka pote') maka amitis (palmata taluk) ya ma tād pasunu' gi'. ");
INSERT INTO sml_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Palmata krisolit (palmata biyaning), onek (palmata kausun jali'-jali') maka jasper (palmata intan gaddung) ya ma tād deyo' katapusan. ");
INSERT INTO sml_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Manjari in sangpū' maka duwa palmata itu bay niukilan saga ōn anak si Isra'il l'lla, ōn a'a dakayu' ma palmata dakayu' pakaniya-kaniya. Ya ukilanna sali' hantang ukilan singsing. ");
INSERT INTO sml_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pagubus, aniya' duwa kili-kili bulawan tinabid-tabid tahinang e' saga a'a inān pangengkot puyu' ni epod. ");
INSERT INTO sml_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","19","Tahinang isab duwa kait bulawan pinasipit ni sablayan epod min dahuanna, maka mpat singsing bulawan tinahi' pehē' ni mpat dugu puyu', min bukutna. Pagubus, ya tōng kili-kili bulawan bay niengkotan ni duwa singsing puyu', maka tōngna dakayu' isab bay niengkotan ni duwa kait ya pamat'nna'an palmata supaya pasangon ni sablayan epod min dahuan baha. ");
INSERT INTO sml_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Aniya' isab tahinang e' sigām duwa singsing saddī bo' yampa tinahi' pehē' ni tōng sablayan epod, ma atag sambungna. ");
INSERT INTO sml_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ya singsing puyu' damuli itu bay niengkotan ni singsing epod maka lubid bilu bo' mbal angalambe puyu' min baran imam. Jari bineya' e' sigām bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Pagubus, aniya' juba pangalapis epod tahinang e' saga a'a magt't'nnun min salban bilu halam aniya' lamudna. ");
INSERT INTO sml_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Juba itu bay nihinangan lowang ma t'ngnga'na, nila'upan bo' mbal al'kkas agese'. ");
INSERT INTO sml_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","In kumpi' juba isab bay pina'ari-ari maka buwa'-buwa' dalima'. Salban bilu, taluk maka keyat ya pangahinang. ");
INSERT INTO sml_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Aniya' isab bagting-bagting bulawan tahinang e' saga a'a inān, pinag'llot-'llot maka buwa'-buwa' dalima' ma kumpi' juba. ");
INSERT INTO sml_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","In juba itu maka ari-arihanna wajib subay sinulug e' imam alanga ma waktu kapagimamna tudju ni PANGHŪꞋ, buwat bay panoho'anna ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Manjari itu aniya' saga s'mmek kasehe' tahinang pamadju' disi Harun maka saga anakna l'lla. Aniya' badju' ahāp kakana' tat'nnun he' a'a apanday magt'nnun. ");
INSERT INTO sml_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Aniya' saga sulban ahāp kakana'na, maka porong, maka sauwal-sauwal ahāp isab t'nnunanna. ");
INSERT INTO sml_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Aniya' isab sabitan tahinang min kakana' pote' binuldahan maka salban bilu, taluk maka keyat. Jari bineya' bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","31","Katapusanna, aniya' tapak-tapak pangorona bay tahinang e' saga a'a magsasasal min dī bulawan. Bay kaukilan isab kabtangan itu, “Sussi-manussi Pamasuku' si Yawe.” Ukilanna inān sali' ukilan singsing. Pagubus itu, aniya' lubid bilu pinasangon ni korona inān pamaengkot iya ni dahuan sulban imam, buwat bay panoho'an PANGHŪꞋ-Yawe ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Manjari itu, atemos na saga hinang kamemon bay pangahinang Luma' Pangarapan, hatina Tolda Pagsasabuhan PANGHŪꞋ maka manusiya'. Tabeya' e' saga a'a Isra'il kamemon bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Tabowa e' sigām pehē' ni si Musa saga pagdayaw Luma' Pangarapan maka ai-aina kamemon. Tabowa toldana maka kapanyapanna kamemon. Tabowa saga kakansing, saga papagan dinding, saga babag, saga hāg isab maka ba'anan durukan. ");
INSERT INTO sml_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Tabowa saga kultina pangatop, ya kultina bay tahinang min kuwit bili-bili l'lla nianjibihan keyat, maka kultina kuwit duyung, maka kultina ya pangalikus Ba'ul. ");
INSERT INTO sml_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Tabowa isab Ba'ul Pagtau'an Sulat Paljanji'an, jukup maka tanggunganna maka turungna bulawan ya pangampunan dusa, ");
INSERT INTO sml_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tabowa lamisahan pamat'nna'an Tinapay Hadarat, jukup isab maka kapanyapanna. ");
INSERT INTO sml_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Tabowa palita'an bulawan maka sumbuhanna, jukup maka saga kapanyapan maka ns'llan pamakeyat ma iya. ");
INSERT INTO sml_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Tabowa isab lamisahan panugtugan kamanyan, maka ns'llan sussi ya pangangg'llal ma imam, maka kamanyan ahamut, maka kultina ya panambol pagsosōran ni Luma' Pangarapan. ");
INSERT INTO sml_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Tabowa lapohan tumbaga maka pangayakanna, saga tanggunganna maka ba'anan kapanyapanna, tabowa isab garul pangailan maka patinggilanna. ");
INSERT INTO sml_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Tabowa isab saga kultina ya panasak ma halaman Luma' maka ba'anan hāg maka durukanna, tabowa isab kultina ya panambol halaman. Tabowa saga lubid maka bale pangengkot sasak, ai-ai ya pinagguna he' sigām pamat'ngge Luma' Pangarapan, ya Pagsasabuhan Tuhan maka manusiya'. ");
INSERT INTO sml_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Tabowa isab ni si Musa saga s'mmek tin'nnun ya pan'mmek ma saga imam waktu paghinang sigām ma deyom Luma' Sussi, hatina saga s'mmek sussi ya pamakay imam Harun maka saga anakna l'lla ma waktu kapagimam sigām. ");
INSERT INTO sml_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Jari aubus na saga kahinangan kamemon bay tahinang e' saga bangsa Isra'il, buwat bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Manjari pagliling si Musa ma kamemon kahinangan sigām, bo' ta'nda'na in bay panoho'an PANGHŪꞋ tabeya' na to'ongan e' sigām, magtūy iya angamu'-ngamu'an sigām kahāpan ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ajukup pa'in kahinangan inān kamemon, angallam gi' PANGHŪꞋ-Yawe ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Yukna, “Pat'nggehunbi na Luma' Tolda Pagsasabuhanku maka ka'am saga bangsa Isra'il. Sahali bulan ya llaw pamat'nggebi, ma bulan panagna'an tahun. ");
INSERT INTO sml_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tapat'ngge pa'in Luma', pat'nna'unbi Ba'ul Pagtau'an Sulat Paljanji'an ma deyomna to'ongan, bo' likusin maka kultina. ");
INSERT INTO sml_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Pareyomunbi lamisahan ya pamat'nna'an tinapay, sinakap isab maka kapanyapanna. Pareyomunbi palita'an bulawan maka tagamahunbi saga sumbuhanna. ");
INSERT INTO sml_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Bowahunbi lamisahan panugtugan kamanyan bo' pat'nna'unbi ma dahuwan Ba'ul. Pagubus, tambolun bowa' lawang Luma' maka kultina. ");
INSERT INTO sml_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Lapohan tumbaga ya pagtunu'an kulban, pat'nna'unbi ma halaman Tolda Pagsasabuhan ilu, ma anggopan pagsosōranna. ");
INSERT INTO sml_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Pat'nna'unbi isab garul pagailan ma llotan Luma' maka lapohan pagtunu'an kulban e' ati isihin bohe'. ");
INSERT INTO sml_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ubus, sasakinbi katilibut halaman maka pasangonunbi isab kultina panambol pagsosōranna. ");
INSERT INTO sml_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Na, ngā'unbi ns'llan sussi ati busuginbi Luma' Pangarapan maka kapanyapanna kamemon supaya pinasuku' ma aku ya Tuhanbi, manjari asussi to'ongan. ");
INSERT INTO sml_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Busuginbi isab lapohan pagtunu'an kulban maka kapanyapanna bo' pinasuku' ma aku, manjari mahasussi to'ongan. ");
INSERT INTO sml_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ya du garul pagailan maka patinggilanna, busuginbi isab pamasuku'bi ma aku. ");
INSERT INTO sml_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Pagubus, bowahun si Harun maka saga anakna l'lla pehē' ni pagsosōran Tolda Pagsasabuhan bo' pinandi maka bohe'. ");
INSERT INTO sml_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pasulugunbi ma si Harun saga s'mmek imam alanga. Busuginbi iya maka ns'llan sussi ati pasuku'unbi iya ma aku supaya iya tōp magimam ma matahanku. ");
INSERT INTO sml_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Pabadju'inbi isab saga anakna l'lla, ");
INSERT INTO sml_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","maka busuginbi sigām ns'llan buwat bay pamusugbi ma si Harun ya mma' sigām e', supaya sigām gin'llal imam maghinang ni aku. Manjari anatas kapagimam sigām magpangkat-mamangkat salama-lama.” Buwattē' ya pagkallam Tuhan ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Na, bineya' e' si Musa kamemon bay panoho'an PANGHŪꞋ-Yawe ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Sakali itu, in Luma' Pangarapan Tuhan bay pinat'ngge e' disi Musa ma waktu sahali bulan, bulan panagna'an ma tahun karuwana min bay kaluwas sigām min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Saga durukan hāg ya pinat'nna' e' sigām dahū, bo' yampa saga papagan dinding, bo' babagna, bo' ba'anan hāg ya pamabatukan kamemon. ");
INSERT INTO sml_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Bin'llat e' sigām saga kultina maglapis-lapis pangatop kaluha'an luma'. Pagubus, ya kultina akapal to'ongan. Jari bineya' e' sigām kamemon bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Puwas e', ningā' e' si Musa saga papagan batu bay panulatan palman Tuhan bo' ninna' e'na ma deyom ba'ul. Binatuk pa'in saga tanggungan ni ba'ul e', tinurungan e'na maka turung bulawan ya panaubatan dusa. ");
INSERT INTO sml_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Pagubus, binowa ba'ul e' si Musa ni deyom Luma' Pangarapan, ni deyom Bilik Mahasussi, ati pinasagnat e'na kultina pamalikus Ba'ul, buwat bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Puwas e' isab, in lamisahan pamat'nna'an tinapay wa'i pina'atag e' si Musa ma deyom Tolda Pagsasabuhan tampal ni satan, min luwasan kultina ya angalimbuhan ba'ul. ");
INSERT INTO sml_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Jari pinat'nna' pahāp saga tinapay ma diyata' lamisahan itu, ma matahan PANGHŪꞋ-Yawe, buwat bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ya du palita'an bulawan, pina'atag e' si Musa ma deyom Tolda Pagsabuhan tampal ni uttala' bo' maganggop maka lamisahan tinapay. ");
INSERT INTO sml_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Sakali pinat'nna' e'na palita'an maka sumbuhanna maina'an ma matahan PANGHŪꞋ-Yawe, buwat bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Aubus pa'in, in lamisahan bulawan bay pinat'nna' e' si Musa ma deyom Tolda Pagsasabuhan, min dahuan kultina ya angalimbuhan ba'ul. ");
INSERT INTO sml_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Jari maina'an iya anugtug kamanyan ahamut, buwat bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ati pinasangon e' si Musa kultina ya panambol Luma' Pangarapan. ");
INSERT INTO sml_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Pagubus inān, ya lapohan pagtunu'an kulban bay pina'atag e' si Musa ma kasekotan lawang Luma' Pangarapan (ya na Tolda Pagsasabuhan) ati maina'an iya anunu' susumbali'an pagkulban sigām ni Tuhan, pinabeya' isab ginisan tirigu, buwat bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ya garul aheya pagailan isab bay pinat'nna' e' si Musa ma llot Tolda Pagsasabuhan maka lapohan pagkulbanan, bo' ni'isihan e'na bohe' pagail. ");
INSERT INTO sml_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Tapagguna bohe' itu e' si Musa maka si Harun sampay isab saga anak si Harun pangose' tape'-tangan sigām, ");
INSERT INTO sml_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","waktu kapasōd sigām ni deyom Tolda Pagsasabuhan. Ya du ma waktu kapasekot sigām ni lapohan pagkulbanan, buwat isab bay panoho'an PANGHŪꞋ ma si Musa. ");
INSERT INTO sml_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Pagubus inān, sinasakan e' disi Musa halaman ma sakalibutan Luma' Pangarapan maka lapohan pagkulbanan e'. Pinasangon isab kultina ya panambol pagsosōran ni halaman. Minnē' atangbus e' si Musa kamemon bay panoho'an PANGHŪꞋ ma iya. ");
INSERT INTO sml_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Aubus pa'in ina'an, magtūy katambunan Tolda Pagsasabuhan e' gabun-Tuhan, maka ap'nno' deyomna e' sahaya si Yawe. ");
INSERT INTO sml_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Manjari mbal makasōd si Musa sabab ina'an gabun patapu' ni diyata' Luma' maka ina'an sahaya si Yawe ma deyomna. ");
INSERT INTO sml_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Na, in bangsa Isra'il, ma waktu kapaglatun-latun sigām min lahat dakayu' ni dakayu', subay pa'angkat gabun min diyata' Luma' Pangarapan bo' yampa sigām pauntas. ");
INSERT INTO sml_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Sat'ggol mbal pa'angkat, mbal isab sigām pauntas min bay paglihanan sigām. ");
INSERT INTO sml_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ina'an gabun si Yawe ma diyata' Luma' Pangarapan ma waktu llaw, ina'an isab api ma deyom gabun ma waktu sangom. Jari ta'nda' e' kamemon saga a'a Isra'il pi'ingga-pi'ingga paglatunan sigām.");
INSERT INTO sml_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Na, pagpatay pa'in si Yussa', angaru saga bangsa Isra'il ni si Yawe ya Tuhan sigām, yuk-i, “Sai min kami ya dahū angandugpak ni bangsa Kana'an?” ");
INSERT INTO sml_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ya sambung PANGHŪꞋ-Yawe, “Panubu' si Yuda ya parahū, sabab bay pamuwanku bahagi' lahat ilu ni komkoman sigām.” ");
INSERT INTO sml_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Manjari ah'lling saga a'a bangsa Yuda ni saga kampung sigām bangsa Simiyun, yuk-i, “Gapi'inbi kami pehē' ni paglahat ya pamasuku' kami ati magdongan kitam angandugpak ni bangsa Kana'an. Pas'lle' kami isāb anganggapi' ka'am bang pehē' ni paglahat ya pamasuku' ka'am.” Jari tinabangan bangsa Yuda e' bangsa Simiyun. ");
INSERT INTO sml_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Na, parugpak pa'in saga a'a bangsa Yuda, pinara'ug sigām e' PANGHŪꞋ min bangsa Kana'an maka bangsa Peres, ati sangpū' ngibu heka a'a bay tapapatay sigām ma lahat Besek. ");
INSERT INTO sml_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Talanggal isāb maina'an si Adoni-Besek ya pagpanghū'an saga a'a Besek. Binowa iya magbono' ati pinalahi saga bangsa Kana'an maka bangsa Peres. ");
INSERT INTO sml_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Si Adoni-Besek bay makalahi isab, sagō' tinurul iya e' a'a Yuda sampay tasaggaw. Pagsaggaw itu, pinōngan bokol tanganna maka bokol tape'na karuwambila'. ");
INSERT INTO sml_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Jari ah'lling si Adoni-Besek, yukna, “Pitumpū' heka sultan bay kapōnganku bokol tangan maka bokol tape' sigām. Ya sadja takakan e' sigām momok kinakan apakpak min lamisahanku. Angkan ma buwattina'an itiya' na aku tinungbasan e' Tuhan ma bay tahinangku ma sigām.” Manjari binowa iya e' saga a'a Yuda ni da'ira Awrusalam ati mahē' kamatayanna. ");
INSERT INTO sml_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Bay tarugpak asal da'ira Awrusalam e' saga a'a Yuda ati ta'agaw e' sigām. Pinapagpatay e' sigām saga a'ana, pinagtautunu' isāb kaluma'anna. ");
INSERT INTO sml_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Pagubus, palūd saga a'a Yuda bo' angandugpak ni saga a'a Kana'an ya pat'nna' ma lahat kabūran, maka ma lahat Negeb, maka ma kabūd-būran tampal ni s'ddopan. ");
INSERT INTO sml_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Tat'kka isāb e' sigām bangsa Kana'an ya pat'nna' ma kauman Hebron (ya bay niōnan Kiriyat-Arba ma waktu tagna') ati tara'ug e' sigām disi Sesay, si Ahiman maka si Talmay. ");
INSERT INTO sml_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Aubus pa'in min Hebron, parugpak sigām ni saga a'a pat'nna' ma kauman Deber (ya bay niōnan Kiriyat-Seper ma waktu tagna'.) ");
INSERT INTO sml_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Jari ah'lling si Kaleb yukna, “Pamakawinku anakku si Aksa ma l'lla ya makatawakkal angandugpak maka angalongkop Kiriyat-Seper.” ");
INSERT INTO sml_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Si Otniyel ya makalongkop kauman inān, ati pamakawin ma iya e' si Kaleb anakna si Aksa. Si Otniyel itu siyali si Kaleb, si Kenas ya mma' sigā. ");
INSERT INTO sml_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Manjari dakayu' llaw pinogos e' si Aksa si Otniyel, sinō' angamu' tana' min mato'ana si Kaleb. Sakali pehē' si Aksa ni mma'na. Makareyo' pa'in iya min kura'na, tinilaw iya e' si Kaleb, yuk-i, “Ai tapanabangku ma ka'a, arung?” ");
INSERT INTO sml_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Yuk sambung si Aksa, “Dūlin aku ma kabaya'anku. Pagga aku bay buwanannu tana' ma Negeb, buwanin gi' isab aku saga tuburan bohe'.” Jari kabuwanan iya saga tuburan bohe' ma kabūd-būran maka ma kapantayan. ");
INSERT INTO sml_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Na, magbeya' saga a'a Yuda maka saga a'a Kēn ya panubu' mato'a si Musa. Ala'an sigām min da'ira Kapalmahan bo' papinda ni paslangan Yuda. Pasakaum sigām ma saga a'a ya asal maglahat maina'an ma Negeb, ma kasekotan kauman Arad. ");
INSERT INTO sml_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Pagubus, pasehe' saga a'a Yuda ma kaukampungan sigām bangsa Simiyun ati tarugpak e' sigām bangsa Kana'an ya pat'nna' ma da'ira Sepat. Jari alubu da'ira inān maka kaluma'anna angkan pinagōnan da'ira Horma. ");
INSERT INTO sml_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Kalongkopan isāb e' a'a Yuda saga da'ira Gasa, Askelon maka Ekron, beya' isab tana' ma sakalingkal saga da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Pagapi' na pa'in PANGHŪꞋ-Yawe ma bangsa Yuda ati ta'agaw e' sigām saga kaluma'an ma kabūd-būran. Malaingkan halam takole' e' sigām tin'ggal saga bangsa ya maglahat ma kapantayan, sabab aniya' ma sigām kalesa pagdayaw basi'. ");
INSERT INTO sml_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","In kauman Hebron bay pamasuku' ma si Kaleb buwat bay panganjanji' si Musa, ati tin'ggal e' si Kaleb t'llungan tumpukan bangsa Annak ya bay pat'nna' maina'an. ");
INSERT INTO sml_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Bo' arapun in bangsa Jibus ya maglahat asal ma Awrusalam halam bay tapala'an e' bangsa Benjamin. Angkan sigām duwa bangsa masi magsakaum maina'an. ");
INSERT INTO sml_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Bay isāb nirugpak e' bangsa Yusup da'ira Betel, pagka sigām ginapi' e' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Waktu sigām amapehē' mata-mata ni Betel (ya bay niōnan Lūs waktu tagna'), ");
INSERT INTO sml_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","aniya' l'lla ta'nda' paluwas min da'ira inān. Yuk saga mata-mata ma iya, “Pandu'in kami bang buwattingga pasōd ni da'ira ilu ati mbal ka inay kami.” ");
INSERT INTO sml_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Jari tinuli'an sigām pasōd pehē'. Pinapatay e' sigām kamemon a'a ya maglahat ma da'ira Betel. Saguwā' in l'lla bay anuli'an sigām niliyus magtai'anak e' saga mata-mata. ");
INSERT INTO sml_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Puwas pa'in he'-i, pehē' a'a inān ni lahat bangsa Hīt ati mahē' iya amaniya' da'ira. Niōnan e'na Lūs, jari Lūs ya ōnna sampay ni kabuwattituhan. ");
INSERT INTO sml_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Malaingkan halam bay tat'ggal e' bangsa Manasse saga a'a ya maglahat ma Bet-Sān, ma Ta'anak, ma Dōr, ma Ebleyam, ma Megiddo, sampay isāb ma ba'anan kaluma'an ya ma katilibut saga paglahat itu. Tu'ud magniyat bangsa Kana'an mbal ala'an min paglahat inān. ");
INSERT INTO sml_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Aga'os pa'in bangsa Isra'il, niata e' sigām bangsa Kana'an, sinō' maghinang abuhat, sagō' halam bay tapala'an tūy. ");
INSERT INTO sml_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Damikiyanna isāb bangsa Epra'im, halam bay makat'ggal bangsa Kana'an ya pat'nna' ma Geser angkan masi na pa'in sigām duwa bangsa magsakaum. ");
INSERT INTO sml_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Damikiyanna bangsa Sibulun halam du isāb bay makat'ggal bangsa Kana'an ya pat'nna' ma Kitron maka ma Nahalol. Angkan masi sigām magsakaum maina'an. Sagō' niata sigām e' bangsa Sibulun sinō' maghinang abuhat. ");
INSERT INTO sml_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Damikiyanna isab bangsa Aser, halam bay makat'ggal saga a'a pat'nna' ma Akko, ma Sidun, ma Alab, ma Aksib, ma Helba, ma Apek, maka ma Rehob. ");
INSERT INTO sml_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Angkan bangsa Aser masi magsakaum maka bangsa Kana'an ya pat'nna' ma jadjahan inān. ");
INSERT INTO sml_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Damikiyanna bangsa Naptali halam bay makat'ggal saga a'a pat'nna' ma Bet-Semes maka ma Bet-Anat, angkan ina'an sigām magsakaum maka bangsa Kana'an ya pat'nna' asal maina'an. Ya a'a Bet-Semes maka Bet-Anat tahinang ata du isab e' bangsa Naptali. ");
INSERT INTO sml_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","In bangsa Dān isāb bay pinaghāran e' bangsa Amor ma kabūd-būran, mbal tinugutan pat'nna' ma kapantayan. ");
INSERT INTO sml_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Ahogot isab pagniyat bangsa Amor in sigām mbal ala'an min Būd Heres, Ayjalon maka Sa'albim. Saguwā' ta'abut pa'in pasōng ga'os bangsa Yusup, ya du bangsa Amor nihinang ata. ");
INSERT INTO sml_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Ya tobtoban tana' bangsa Amor itu anagna' min L'bbak Jalalangking sampay ni lahat Sela maka paliyu lagi' minnē'. ");
INSERT INTO sml_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Na, in mala'ikat PANGHŪꞋ-Yawe bay patukad min Gilgal ni lahat Bokim bo' ah'lling ni bangsa Isra'il, yukna, “Bay kam bowaku paluwas min lahat Misil tudju ni lahat ya bay paljanji'anku ma saga ka'mbo'-mbo'anbi. Yukku ma waktu ina'an, ‘Mbal balubahanku janji'ku ya pagsulutanku maka ka'am. ");
INSERT INTO sml_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Bay kam sohō'ku subay da'a angahinang pagsulutan maka saga a'a porol ma paglahat ilu. Gom pa'in lubuhunbi saga tampat ya pagpudjihan sigām.’ Saguwā' halam aku bay beya'bi. Angay bahā'? ");
INSERT INTO sml_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Angkan haka'anta na kam, mbal t'ggalku saga bangsa inān, angkan sigām sapantun iting makasulaman kakīranbi. Tajallat isāb kam e' ba'anan tuhan-tuhan ya tina'at e' sigām.” ");
INSERT INTO sml_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Aubus pa'in pangallam mala'ikat PANGHŪꞋ inān, magtūy maglemong anangis kamemon saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Angkan Bokim ya pangōn sigām ma lahat inān, ati maina'an sigām angungsuran tutukbalan ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Na, bay pa'in tapatulak e' si Yussa' saga a'a Isra'il, palanjal sigām minnē' bo' nirapu e' sigām saga katana'-tana'an ya pamasuku' katumpukan sigām pakaniya-pakaniya. ");
INSERT INTO sml_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Jari sat'ggol allum si Yussa', atukid saga a'a Isra'il angisbat si Yawe ya Tuhan sigām. Angisbat na pa'in sigām sampay magpatayan na saga pagmatto'ahan sasuku bay maka'nda' saga kahinangan kawasahan ya tahinang e' PANGHŪꞋ-Yawe ma pasalan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Jari si Yussa' anak si Nūn, ya pinagōnan ‘Sosoho'an si Yawe’, amatay ma umulna dahatus maka sangpū'. ");
INSERT INTO sml_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Takubul iya ma lahat palsuku'anna ma Timnat Heres ya ma kabūd-būran Epra'im, tampal uttala' min Būd Ga'as. ");
INSERT INTO sml_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Na, magpatayan pa'in kapanubu'an ina'an-i, aniya' tubu'an baha'u pas'lle', ya mbal makakilā PANGHŪꞋ-Yawe, maka halam isāb makata'u ma bay tahinang e'na ma bangsa sigām Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Pagga buwattē', tahinang e' bangsa Isra'il kala'atan ya landu' asammal ma pang'nda' PANGHŪꞋ, ati sinumba e' sigām saga Ba'al. ");
INSERT INTO sml_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Ang'bba sigām min si Yawe ya bay pagtuhanan saga ka'mbo'-mbo'an sigām. In iya PANGHŪꞋ bay amowa saga ka'mbo'-mbo'an e' paluwas min lahat Misil, sagō' bineya' maka sinumba e' sigām saga tuhan-tuhan ya tina'at e' maglalahat ma jadjahan ina'an. Akagit atay PANGHŪꞋ ma sigām ");
INSERT INTO sml_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ma sabab kataikut sigām min iya bo' papinda anumba ni Ba'al maka saga Astoret. ");
INSERT INTO sml_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Pagka aheya ka'astol PANGHŪꞋ ma bangsa Isra'il inān, bay pasagaranna sigām nilangpasan he' saga mundu. Pinasagaran isāb sigām nira'ug e' saga palbantahan ya ma katilibut paglahat sigām. Mbal sigām maka'atu, ");
INSERT INTO sml_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","sakahaba' waktu sigām angatubang amono', mbal sigām bay pinara'ug e' PANGHŪꞋ. Ya na ina'an bay panganjanji'na. Gom pa'in paheya kasukkalan sigām. ");
INSERT INTO sml_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Na, pagga buwattē' kahālan bangsa Isra'il, aniya' saga maghuhukum bay pinaniya' e' PANGHŪꞋ angalappas sigām min ga'osan saga mundu he'. ");
INSERT INTO sml_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Malaingkan mbal akale bangsa Isra'il ma saga maghuhukum ya magmakōkan sigām, gom pa'in sigām ang'bba min si Yawe bo' papinda anumba ma saga tuhan-tuhan saddī. Pabidda' saga bangsa Isra'il itu min bay ka'mbo'-mbo'an sigām tagna', sabab magdai'-dai' sigām pasiha' min kal'ngnganan saga ka'mbo'-mbo'an e'. Halam bineya' kabiyaksahan sigām ameya' ma panoho'an PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Bang aniya' a'a pinaniya' maghukum sumiyan-sumiyan, ginapi' iya e' Tuhan bo' supaya talappas saga a'a Isra'il min komkoman saga palbantahan sigām. Buwattē' na pa'in kahālan sat'ggol masi allum a'a maghukum e'. Ma'ase' PANGHŪꞋ ma bangsa Isra'il pagka sigām magaruhuy ma sabab pinissoko' maka nijahulaka' e' banta sigām. ");
INSERT INTO sml_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Saguwā' ta'abut pa'in amatay maghuhukum e', magtūy sigām pabalik maghinang kala'atan akalap lagi' la'atna min bay kahinangan kamatto'ahan sigām. Tina'at maka pinudji e' sigām saga tuhan-tuhan saddī. Minsan ni'inay, mbal sigām pataikut min kahinangan ala'at, maka magmatuwas na pa'in kōk sigām. ");
INSERT INTO sml_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Angkan landu' akagit atay PANGHŪꞋ ma bangsa Isra'il. Yukna, “In bangsa itu hal anagga' ma pagsulutan ya bay janji'ku ma ka'mbo'-mbo'an sigām, mbal isab akale ma aku. ");
INSERT INTO sml_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Angkan mbal pala'anku min sigām saga bangsa ya halam bay tara'ug ma waktu kallum lagi' si Yussa'. ");
INSERT INTO sml_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Jari gunaku saga bangsa itu panulayan bangsa Isra'il bo' tata'uku bang b'nnal sigām an'ppu ka'mbo'-mbo'an sigām ameya' ma kabaya'anku.” ");
INSERT INTO sml_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Angkanna saga bangsa kasehe'an bay pinasagaran pat'nna' ma lahat inān. Halam sigām bay pinala'an e' PANGHŪꞋ saru'un-du'un. Halam isāb bay dūlanna si Yussa' anganda'ug min sigām. ");
INSERT INTO sml_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Na, ya itu saga bangsa bay pinasagaran e' PANGHŪꞋ-Yawe panulayna ma saga a'a Isra'il ya halam bay makalabay pagbono' ma lahat Kana'an. ");
INSERT INTO sml_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","(Subay sigām kapandu'an amono' sabab ya kaheka'an sigām halam bay makalabay bono' ma waktu tagna'.) ");
INSERT INTO sml_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Ina'an masi ma lahat Kana'an saga datu' lima hekana ya pagnakura'an bangsa Pilistin, ina'an isāb saga bangsa Kana'an magtumpuk-manumpuk, maka ina'an isāb bangsa Sidun maka bangsa Hīb ya pat'nna' ma kabūd-būran Lebanon, min būd Ba'al-Hermon sampay ni Lebo-Hamat. ");
INSERT INTO sml_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Tinugutan saga bangsa itu anulay ma saga a'a Isra'il bo' tata'u bang bineya' e' sigām saga panoho'an PANGHŪꞋ ya bay pang'bbana ma ka'mbo'-mbo'an sigām labay min si Musa. ");
INSERT INTO sml_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Na, pasakaum saga a'a Isra'il ma bangsa Kana'an, bangsa Hīt, bangsa Amor, bangsa Pirisi, bangsa Hīb maka bangsa Jebus. ");
INSERT INTO sml_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Magpikit-pikiti isāb bangsa Isra'il maka bangsa saddī inān, ati tabowa anumba ni saga tuhan-tuhan sigām. ");
INSERT INTO sml_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Jari tahinang e' saga bangsa Yahudi kala'atan ya landu' asammal ma pang'nda' PANGHŪꞋ-Yawe. Takalipat e' sigām si Yawe ya pagtuhanan sigām bo' anumba ni saga tuhan-tuhan Ba'al maka Astoret. ");
INSERT INTO sml_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Aheya kakagit atay PANGHŪꞋ-Yawe angkan pasagaranna bangsa Isra'il nira'ug e' si Kusan-Risataim ya sultan ma Aram Naharaim. Jari waluntahun t'ggol sigām ma komkoman sultan e'. ");
INSERT INTO sml_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Malaingkan parahing pa'in sigām ni PANGHŪꞋ, aniya' a'a pinaniya' e'na angaliyusan sigām. Ōn a'a itu si Otniyel anak si Kenas, ya siyali si Kaleb l'lla. Jari talappas saga a'a Isra'il e' si Otniyel. ");
INSERT INTO sml_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Pahōp Rū si Yawe ma iya ati tahinang iya maghuhukum ma bangsa Isra'il. Aesog iya ma pagbono'an maka karūlan iya e' PANGHŪꞋ-Yawe angkan tara'ug e'na si Kusan-Risataim ya sultan bangsa Aram. ");
INSERT INTO sml_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Jari aniya' na kasannangan ma lahat inān ma deyom mpatpū' tahun, sampay ni waktu kamatay si Otniyel anak si Kenas. ");
INSERT INTO sml_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Jari pabalik na isāb saga bangsa Isra'il angahinang kala'atan ya asammal ma pang'nda' PANGHŪꞋ, angkan sigām taga'os e' si Eglon sultan bangsa Mowab, min kahandak PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Si Eglon inān bay mikigapi' ma bangsa Ammon maka bangsa Amalek, ati tarugpak e' sigām bangsa Isra'il bo' kalongkopan e' sigām da'ira Kapalmahan. ");
INSERT INTO sml_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Sangpū' ka waluntahun ya t'ggol bangsa Isra'il ma komkoman si Eglon sultan bangsa Mowab e'. ");
INSERT INTO sml_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Manjari pabalik na isab saga bangsa Isra'il parahing ni PANGHŪꞋ ati aniya' isāb a'a bay pat'nna'na angaliyusan sigām min kasigpitan. Ōnna si Ehod anak si Gera, panubu' si Benjamin, a'a sakap gibang. Jari itu, sinoho' iya e' saga pagkahina bangsa Isra'il ang'nde'an buwis ni si Eglon ya sultan bangsa Mowab. ");
INSERT INTO sml_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Na aniya' punyal saga t'llu h'kka taha'na bay tahinang e' si Ehod itu, kaengkotan e'na ni pa'ana kowan bo' katambunan e' s'mmekna. ");
INSERT INTO sml_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Pagubus, binowa buwis e' si Ehod ni si Eglon sultan bangsa Mowab. Al'mmok asal si Eglon. ");
INSERT INTO sml_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Na, ka'nde'an pa'in buwis itu, pinapole' e' si Ehod saga maghahangkut pilak pamuwis. ");
INSERT INTO sml_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Maka'abut pa'in sigām ni saga batu ukilan ya ma tongod kauman Gilgal, si Ehod bay pabalik pehē' ni sultan Eglon bo' ah'lling ma iya, yuk-i, “Aniya' pah'llingku ma ka'a, tuwan sultan, ma halam aniya' makakale.” Yuk sultan ma saga sosoho'anna, “Da'a kam asagaw!” Ati paluwas sigām minnē'. ");
INSERT INTO sml_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Manjari pasekot si Ehod ni sultan e', hinabuna aningkō' karangan-danganan ma bilik angkap diyata' ya paghayang-hayanganna. Yuk si Ehod, “Aniya' lapal Tuhan pasampayku ni ka'a, tuwan.” Hinabu pabuhat sultan min paningkō'anna, ");
INSERT INTO sml_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","nihublut e' si Ehod punyal bay ma pa'ana kowan. Nihublut e'na maka tanganna gibang ati pangandugsu'na ni b'ttong sultan. ");
INSERT INTO sml_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","Ā, paloblob punyal sampay puhanna ni b'ttong sultan, palatus pehē' ni bukutna. Halam tahella' e' si Ehod punyalna inān sabab katambunan e' kal'mmokan sultan. ");
INSERT INTO sml_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Jari paluwas si Ehod ni saurung luma' bo' kinunsi' e'na saga tambol ma bilik angkap diyata' inān. ");
INSERT INTO sml_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Makala'an pa'in iya, pina'an saga sosoho'an sultan ni bilikna inān ati ta'nda' e' sigām saga tambolna bay kinunsi'. “Ā,” yuk sigām, “kalu wa'i gi' ajamban.” ");
INSERT INTO sml_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Sakali angagad-ngagad na pa'in sigām sampay sigām sinōd iya', sagō' halam taukab tambol e' sultan. Angkan sigām bay angā' kunsi' pangukab. Pagukab itu, ta'nda' e' sigām panghulu' sigām amatay pahantal ma lantay. ");
INSERT INTO sml_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Hinabu angagad saga sosoho'an e', wa'i makalahi si Ehod. Talabay e'na saga batu ukilan bo' patudju ni lahat Se'era. ");
INSERT INTO sml_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Pagt'kkana pa'in pehē' ni kabūd-būran ya paglahatan panubu' si Epra'im, amah'lling iya tiyup-tiyup. Sakali patimuk ni si Ehod saga bangsa Isra'il bay min kaburan inān, ati magbeya' sigām palūd minnē'. ");
INSERT INTO sml_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","“Pi'itu kam ameya' ma aku,” yuk panoho'an si Ehod, “sabab saga bantabi bangsa Mowab pinara'ug e' PANGHŪꞋ ma ka'am.” Angkan sigām paurul ma si Ehod, ati ta'agaw e' sigām saga kababawan ma sapa' Jordan, ya palabayan ni lahat Mowab. Halam aniya' minsan sai bay tinugutan e' disi Ehod pauntas parambila' sapa' he'. ");
INSERT INTO sml_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Jari ma llaw ina'an-i, aniya' saga sangpū' ngibu a'a Mowab tapapatay he' sigām, a'a bahani maka akosog. Halam aniya' minsan dangan bay makalahi. ");
INSERT INTO sml_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Ma llaw he'-i du taga'os bangsa Mowab e' bangsa Isra'il ati asannang paglahat inān ma deyom walumpū' tahun. ");
INSERT INTO sml_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Manjari ya pas'lle' ma si Ehod itu si Samgar anak si Anat. Si Samgar itu bay makapapatay nnom hatus a'a bangsa Pilistin. Luwal tungkud panganjudjal sapi' ya pakokosna. Bay isāb iya angaliyusan bangsa Isra'il min kasigpitan sigām. ");
INSERT INTO sml_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Amatay pa'in si Ehod, pabalik na isab saga bangsa Isra'il maghinang kala'atan ya landu' asammal ma pang'nda' si Yawe ya Tuhan sigām. ");
INSERT INTO sml_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Jari sinōngan sigām e' PANGHŪꞋ-Yawe ni komkoman si Jabin, sultan bangsa Kana'an ya amarinta ma da'ira Hasor. Ya magnakura' ma saga sundalu si Jabin itu si Sesera, a'a pat'nna' ma Haroset Haggoyim. ");
INSERT INTO sml_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Aniya' ma si Jabin saga kalesa basi' siyam hatus hekana. Nijahulaka' e'na bangsa Isra'il, pinissoko' ma deyom duwampū' tahun, angkan sigām parahing ni PANGHŪꞋ angamu' tabang. ");
INSERT INTO sml_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Ma waktu inān, si Debora h'nda si Lapidut ya magnakura' ma bangsa Isra'il. Nabi isab iya. ");
INSERT INTO sml_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Ya kabiyaksahan si Debora itu bang maghukum ma saga a'a Isra'il subay ma sindungan kayu ya pinagōnan Palma, ina'an ma llot Rama maka Betel ya ma kabūran Epra'im. Pehē' ni iya saga a'a Isra'il amapasalassay ba'anan palsagga'an sigām. ");
INSERT INTO sml_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Jari aniya' waktu kapanambuku si Debora ma si Barak, anak si Abinowam l'lla ya pat'nna' ma kauman Kedes ma lahat bangsa Naptali. Ya lapal si Debora ma si Barak, “Si Yawe ya pagtuhanan bangsatam Isra'il magpanoho'an ma ka'a. Sinō' ka pehē' ni būd Tabor, beya' isāb saga a'a sangpū' ngibu hekana min bangsa Naptali maka min bangsa Sibulun. ");
INSERT INTO sml_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Yuk Tuhan isab, ‘Sasatku si Sesera ya pagmakōkan saga sundalu si Jabin, supaya iya tabowa pehē' ni sapa' Kisun, iya baranna maka saga kalesana basi' sampay ba'anan saga sundaluna. Ati sōnganku sigām ni ga'osannu.’ ” ");
INSERT INTO sml_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Sakali ah'lling si Barak ni si Debora, yukna, “Aho', pehē' aku bang pa'in ka'a ya anehe'an aku. Sagō' bang ka mbal ameya', na mbal aku.” ");
INSERT INTO sml_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","“Ahāp na ko' ilu,” yuk si Debora. “Ameya' aku ma ka'a. Sagō' pagka buwattilu paghona'-hona'nu, halam aniya' kamahaldika'an maka-ni ka'a bang tara'ug si Sesera. Subay d'nda ya binuwanan da'ugan e' PANGHŪꞋ.” Jari parongan si Debora ma si Barak pehē' ni Kedes. ");
INSERT INTO sml_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Ma Kedes pa'in, pinalinganan e' si Barak saga a'a panubu' si Sibulun maka si Naptali, ati sangpū' ngibu ya heka sigām magbeya' maka iya. Ya du si Debora bay ameya'. ");
INSERT INTO sml_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Na, ma waktu ina'an du, aniya' a'a niōnan si Heber bay pasaddī min pagkahina bangsa Kēn. In bangsa Kēn itu panubu' si Hobab, ya bay ipal si Musa l'lla. Jari si Heber itu bay amat'ngge luma'na tolda ma atag kayu Sa'anannim, dakayu' po'on kayu aheya asekot ni Kedes. ");
INSERT INTO sml_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Kahaka'an si Sesera pasal si Barak anak si Abinowam wa'i patukad ni būd Tabor. ");
INSERT INTO sml_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Angkan tinimuk e' si Sesera saga kalesana basi' siyam hatus hekana maka kamemon kal'llahan ya tendogna, ati soho'na sigām pehē' min Haroset Haggoyim ni sapa' Kisun. ");
INSERT INTO sml_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Pagka buwattē', ah'lling si Debora ni si Barak, yukna, “Sūng! Ya na itu llaw panukbal si Sesera ni ka'a e' PANGHŪꞋ! Tuhan ya magmunda' ma ka'am!” Angkan palūd si Barak min būd Tabor maka saga a'a sangpū' ngibu hekana. ");
INSERT INTO sml_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Manjari itu, makarugpak pa'in disi Barak, pinalengog si Sesera e' PANGHŪꞋ, talapay isāb kamemon saga a'ana magkalesa maka sundaluna. Si Sesera baranna bay pakuppa min kalesana bo' alahi. ");
INSERT INTO sml_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Saguwā' niapas e' si Barak saga kalesa maka katumpukan sundalu inān sampay ni Haroset Haggoyim. Talagut saga sundalu si Sesera kamemon, halam aniya' minsan dangan takapin allum. ");
INSERT INTO sml_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Malaingkan si Sesera itu bay makalahi ni luma' tolda ya pat'nna'an si Ja'el h'nda si Heber bangsa Kēn. Magbagay asal si Jabin sultan Hasor maka kakampungan si Heber. ");
INSERT INTO sml_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Na, paluwas si Ja'el min luma'na anagina si Sesera. Yukna, “Palanjal ka, tuwanku. Pasōd ka pi'itu, da'a ka tināw.” Jari pasōd iya ni luma' tolda bo' minantahan e' si Ja'el. ");
INSERT INTO sml_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Yuk si Sesera ma iya, “Atoho' k'llongku. Bang manjari, buwanin aku bohe'.” Ati niukab e' si Ja'el dakayu' pangisihan gatas pamainum iya. Pagubus tinambunan iya pabalik. ");
INSERT INTO sml_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Ah'lling gi' si Sesera ma si Ja'el, yukna, “An'ngge ka ma bowa' lawang ilu. Bang aniya' pi'itu atilaw bang aniya' gi' a'a saddī maitu, sambungin ‘halam’.” ");
INSERT INTO sml_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Saguwā' addok pa'in tuli si Sesera ma sabab kamale'na, niā' tuku tolda maka tukul e' si Ja'el h'nda si Heber inān. Pa'agak-agak iya ni bihing si Sesera. Tinukul e'na tuku inān ni kīd tuktukna, tinukul pahāp bo' palatus parambila' pa'abut ni tana'. Minnē' amatay si Sesera. ");
INSERT INTO sml_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Na, pina'an isāb si Barak amiha si Sesera ati paluwas si Ja'el amāk iya. “Pi'itu ka,” yukna, “pa'nda'anku ka'a ya a'a pihanu.” Angkan ameya' si Barak ma si Ja'el pasōd. Ta'nda' e'na si Sesera amatay pahantal, maka masi tuku tolda ma kōkna. ");
INSERT INTO sml_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Manjari ma llaw he'-i du, in si Jabin sultan bangsa Kana'an inān bay nilongkopan e' Tuhan ma pang'nda' saga a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Ati bangsa Isra'il itu gom pa'in magsosōng ga'os sigām min sultan Jabin, sampay iya ta'abut magka'at e' sigām. ");
INSERT INTO sml_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Ma llaw ina'an du, magkalang si Debora maka si Barak ya anak si Abinowam. Yuk pagkalang sigā: ");
INSERT INTO sml_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“Pudji ni si Yawe! Saga a'a bangsahan angatas na magmunda' ma pagkahi sigām bangsa Isra'il, lilla' isāb saga a'a anukbalan baran sigām. ");
INSERT INTO sml_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","Pakale kam, saga sultan! Pakale kam saga a'a bangsahan. Angalang aku ni si Yawe, angalang aku. Anukbal aku kalangan pamudji si Yawe ya pagtuhanan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","O Yawe, pagla'annu pa'in min lahat Se'er, paglanjalnu min lahat Edom, ajogjog dunya, alandos makalandu' ulan, patumbuk ulan min kagabunan. ");
INSERT INTO sml_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Ajogjog saga kabūran ma kapi'itu si Yawe, ya Tuhan tag-suku'an būd Turusina. Aho', ajogjog ma baihu'an si Yawe, ya pagtuhanan bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","Ma waktu kapaghukum si Samgar anak si Anat, maka ma waktu si Ja'el, halam aniya' bay makalabay min lān aheya. Sasuku magtulakan subay palabay min saga lān kabiklu'-biklu'an. ");
INSERT INTO sml_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","Akulang du bay makapaglahat ma kahuma-huma'an tana' Isra'il, sat'ggol halam bay patuwa' si Debora, ya kinilā pagina'an bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Ma waktu kapapinda bangsa Isra'il ni saga tuhan-tuhan saddī, waktu isāb kat'kka bono' ma pagsōran da'ira, halam aniya' tampan atawa budjak ma saga l'lla bangsa Isra'il mpat ngibu hekana. ");
INSERT INTO sml_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Akōg pangatayanku ma saga a'a Isra'il bangsahan, maka ma saga a'a ya magmalilla' palamud ma pagbono'. Pudji ni si Yawe! ");
INSERT INTO sml_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","Pakale kam, sasuku kam pakura' ma kura' pote', ya aningkō' ma lampik pakol alingkat, beya' isāb ka'am magbabaklay ma lān, kalehunbi ");
INSERT INTO sml_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","lapal saga magkakalang ya patimuk ma atag kak'ppongan. Niusul e' sigām pasal kahinangan PANGHŪꞋ-Yawe, kahinangan a'adil lullun, niusul kahinangan saga a'a Isra'il ya aesog amono'. Maglūran na saga ummat PANGHŪꞋ pehē' ni tongod lawang ya pagsōran da'ira. ");
INSERT INTO sml_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","‘O Debora, pakosog ka bo' pakosog! Pakosog ka magkalang! O Barak, pakuyas ka! O Barak, ka'a anak si Abinowam, saggawun saga a'a bay anaggaw ka'a.’ ");
INSERT INTO sml_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","Sasuku takapin allum ma bangsa Isra'il bay patipun ni saga pagnakura'an sigām. Bay patimuk ma aku saga ummat si Yawe, beya' isāb saga a'a ya aesog amono'. ");
INSERT INTO sml_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Aniya' sigām kasehe'an bay min lahat Epra'im, ya bay paglahatan bangsa Amalek ma waktu tagna'. Ina'an isāb saga panubu' si Benjamin bay palamud ma saga a'a ya anehe'an ka'a. Aniya' saga kapitan palūd pina'an bay min Makir. Aniya' isāb saga a'a Sibulun amowa tungkud kapitan. ");
INSERT INTO sml_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Saga a'a bangsahan min bangsa Issakar bay parongan ma si Debora. Aho', ina'an saga panubu' si Issakar parongan ma si Barak, magdaganan maka iya ni kapantayan. Saguwā' magduwa-ruwa pikilan bangsa Rubin, mbal agon makapagdakayu' gara'. ");
INSERT INTO sml_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","Ka'am bangsa Rubin, angay kam bay pat'ddas ma koralanbi, anaenghog tiyup-tiyup ya pangalingan a'a ma bili-bili sigām? B'nnal, aheya pagduwa-ruwabi ameya' maka mbal. ");
INSERT INTO sml_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Saga a'a Giliyad bay magpa'bba ma dambila' sapa' Jordan, maka bangsa Dān bay angagad sadja ma saga kumpit. Bangsa Aser isāb bay pat'ddas ma bihing tahik, halam sigām bay magla'anan min deyom kalo'okan. ");
INSERT INTO sml_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Malaingkan in bangsa Sibulun bay anawakkalan kallum sigām ni pagbono'an, damikiyanna isab bangsa Naptali ma kabūd-būran. ");
INSERT INTO sml_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","Sakali magt'kkahan saga sultan bangsa Kana'an. Pakuyas sigām magbono', apaslod pagdugpak sigām ma kuta' Ta'anak ya ma bihing bohe' Megiddo, saguwā' halam aniya' pangalta' bay talangpas sigām. ");
INSERT INTO sml_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Palamud isāb saga bitu'un amono' ma si Sesera. Anabang saga mamahi sabu pa'in maguntasan min sobangan ni s'ddopan. ");
INSERT INTO sml_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Talaran si Sesera maka saga tendogna e' s'llog, talaran sigām e' sapa' Kisun, ya sapa' bay awal gi'. Ah'llingan aku di-ku. Paesog ka, yukku, palanjal ka. ");
INSERT INTO sml_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Jari takale to'ongan tagandak saga kura' si Sesera. Ina'an saga kura'na aesog magdaganan na pa'in, magdaganan. ");
INSERT INTO sml_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","‘Sapdahin saga a'a ma kauman Meros,’ yuk mala'ikat si Yawe. ‘Sapdahin sigām to'ongan, sabab halam sigām bay palamud anganggapi' ma si Yawe, halam sigām bay pagapi' ma iya angatu ma saga a'a ga'osan.’ ");
INSERT INTO sml_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","Bang pa'in binarakatan si Ja'el, h'nda si Heber bangsa Kēn. Bang pa'in iya binarakatan labi min kamemon kar'ndahan ya pat'nna' ma luma' tolda. ");
INSERT INTO sml_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Angamu' pa'in bohe' si Sesera, gatas ya pamuwan e' si Ja'el, gatas pinapīt ni'isi ma pinggan, pinggan tōp pagi'inuman a'a bangsahan. ");
INSERT INTO sml_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Pagubus, pina'abut tanganna dambila' ni tuku tolda, tanganna kowan ya pang'ntanna tukul. Jari binono' e'na si Sesera, ap'ssa' kōkna, nirugsu' iya ma kīd tuktukna bo' alopot kōkna. ");
INSERT INTO sml_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Ati palukbu' iya ma dahūan tape' si Ja'el. Pahantal iya maina'an, jari maina'an kamatayanna. ");
INSERT INTO sml_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","Ina'an ina' si Sesera patīk min tandawan, ina'an iya ma bilikna maglemong na pa'in. Magtilaw-tilawan di-na, ‘Ai bahā' makat'ggolan kalesana? Angay halam gi' takaleku tagandak saga kura'na?’ ");
INSERT INTO sml_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Manjari sinambungan iya e' dakayu' tendogna ya aladju pikilanna min kaheka'an d'nda. ");
INSERT INTO sml_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","Ya du isāb ina' si Sesera ah'llingan di-na, yukna, ‘Tantu sigām t'ggolan magbahagi'an pangalta' ya talangpas sigām, dakayu' atawa duwangan d'nda ma dakayu' l'lla, saga s'mmek ahalga' pamahampit si Sesera, saga s'mmek buldahan, s'mmek alutu' durukanna, pamasalay ma k'llongku. Tantu aheka tataban e' sigām.’ ");
INSERT INTO sml_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","Ya PANGHŪꞋ, bang pa'in alaglag kamemon palbantahannu! Malaingkan sasuku alasahan ka'a, bang pa'in sigām asahaya sapantun mata llaw bang pasinag to'ongan.” Sakali aniya' kasannangan ma paglahat inān ma deyom mpatpū' tahun. ");
INSERT INTO sml_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Pabalik na isab saga bangsa Isra'il maghinang kala'atan ya landu' asammal ma pang'nda' PANGHŪꞋ-Yawe, angkan sigām pinasagaran e'na gina'os e' bangsa Midiyan ma deyom pituntahun. ");
INSERT INTO sml_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Ma sabab kabisa pamissoko' bangsa Midiyan, makalahi saga bangsa Isra'il ni kabūd-būran bo' angahinangan di-sigām kubu'-kubu' ma saga songab batu maka ma saga tapukan ya ahunit sinōd. ");
INSERT INTO sml_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Tiyap-tiyap sigām ananom, magtūy sinōd paglahat sigām e' saga bangsa Midiyan, bangsa Amalek maka saga bangsa kasehe'an bay min sobangan. ");
INSERT INTO sml_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Kapagpustuhan e' bangsa liyu inān saga tana' ya pananoman bangsa Isra'il ta'abut sampay ni lahat Gasa. Jari pinaka'at ai-ai bay tinanom e' bangsa Isra'il ati halam aniya' kinapinan pagkakan sigām. Pinagā' isāb kamemon saga bili-bili, sapi' maka saga kura' ya suku' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Angulatap saga bangsa liyu inān pehē' ni tana' Isra'il, sapantun heka ampan dulu. Tabowa saga kahayopan sigām maka ba'anan luma' sigām tolda. Mbal agon taitung heka puhu' maka unta' ya bay pat'kka ni lahat e' bo' supaya ta'agaw ka'lluman a'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Jari magkamiskinan bangsa Isra'il e' bangsa Midiyan angkan sigām parahing angamu' tabang ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Pagga sigām bay parahing ni PANGHŪꞋ ma pasalan bangsa Midiyan, ");
INSERT INTO sml_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","bay sigām pinabeya'an dakayu' nabi. Ah'lling nabi inān, yukna, “Ya itu pangallam si Yawe ya pagtuhananbi, yukna, ‘Bay kam bowaku paluwas min lahat Misil, ya lahat bay pamanyaga'an ka'am. ");
INSERT INTO sml_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Bay kam paluwasku min pang'ntan bangsa Misil maka min komkoman saga a'a amissoko' ka'am. Bay t'ggalku saga bantabi maka bay pamuwanku ni ka'am lahat sigām. ");
INSERT INTO sml_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Bay sa kam haka'anku, yukku, “Aku si Yawe ya pagtuhananbi. Da'a kam anumba ni saga tuhan-tuhan bangsa Amor, ya bay tag-suku'an lahat pat'nna'anbi ilu.” Saguwā' halam aku bay ikutbi.’ ” ");
INSERT INTO sml_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Manjari at'kka mala'ikat si Yawe ni lahat Opra bo' aningkō' ma sindungan po'on kayu aheya, ya suku' si Jowas a'a min bangsa Abe'eser. Ina'an isāb anakna l'lla ya niōnan si Gidiyun anganggi'ikan pai-tirigu ma deyom pagp'gga'an buwa' anggul. Mahē' iya maggi'ik bo' mbal ta'nda' e' bangsa Midiyan. ");
INSERT INTO sml_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Magpa'nda' pa'in mala'ikat ma si Gidiyun, yukna, “Ka'a ya bobono'un aesog maka akosog, pataptap si Yawe ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ya sambung si Gidiyun, “Tuwan, bang si Yawe b'nnal pataptap ma kami, angay kami pinat'kkahan ba'anan saga pakaradja'an itu? Angay kami halam pina'nda'an saga hinang kainu-inuhan ya pinagsuli-suli e' kamatto'ahan kami? Bay kono' sigām binowa e' si Yawe paluwas min lahat Misil. Saguwā' ma buwattina'an, siniya-siya kami e' PANGHŪꞋ bo' tinugutan ni komkoman bangsa Midiyan.” ");
INSERT INTO sml_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Palingi' PANGHŪꞋ bo' ah'lling ni si Gidiyun, yuk-i, “Pehē' na ka, gunahun kosognu ati lappasun bangsa Isra'il min ga'osan bangsa Midiyan. Aku ya anoho' ka'a.” ");
INSERT INTO sml_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Atilaw si Gidiyun, yukna, “Aho' panghū', sagō' buwattingga e'ku angalappas bangsa kami Isra'il? Sabab ma panubu' Manasse, in pangkatan kami ya halam to'ongan aniya' ga'osna. Maka aku itu areyo' to'ongan ma kakampungan kami.” ");
INSERT INTO sml_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ya sambung PANGHŪꞋ, “Pabeya' du aku ma ka'a ati talaglagnu kamemon saga bangsa Midiyan buwat e'nu amono' a'a dangan.” ");
INSERT INTO sml_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Anambung si Gidiyun, “Na, bang hati ka kasulutan ma aku, buwanin aku paltanda'an in ka'a to'ongan amissala ni aku. ");
INSERT INTO sml_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Da'a busung, da'a lagi' ka ala'an sampay aku makabalik pi'itu amowa tutukbalan pangahulmatku ka'a.” Yuk PANGHŪꞋ-Yawe, “Na, lagaranta pa'in ka sampay ka makabalik pi'itu.” ");
INSERT INTO sml_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Sakali pehē' na si Gidiyun ni luma' bo' angadjal kambing abata'. Angaddun isāb iya saga nnom gantang tirigu nihinang tinapay halam pasuligna. Atahak pa'in, ni'isi e'na isi sumbali'an ma ambung, maka loho'na ni'isi ma kaldero bo' yampa bowana panghulmat mala'ikat Tuhan ya ma sindungan kayu. ");
INSERT INTO sml_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Jari yuk mala'ikat ni iya, “Ngā'un isi sumbali'an maka tinapay halam pasuligna bo' pat'nna'un ma batu itu, ati bu'usin loho'.” Bineya' magtūy e' si Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Jari niabut sumbali'an maka tinapay inān maka tōng tungkud ya ma tangan mala'ikat si Yawe. Saru'un-du'un pasuleyab api luwas min batu inān, ati atunu' kamemon bay tabowa e' si Gidiyun. Alanyap isāb mala'ikat si Yawe. ");
INSERT INTO sml_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Tata'u pa'in e' si Gidiyun mala'ikat PANGHŪꞋ ya bay papa'nda' ni iya, magtūy iya amanyabut, “Arōy, PANGHŪꞋ Sangat Kawasa! Bay aku makapagbaihu' maka mala'ikatnu!” ");
INSERT INTO sml_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Saguwā' amissala PANGHŪꞋ ni iya, yuk-i, “Pahantap ka! Da'a ka tināw, mbal du ka amatay.” ");
INSERT INTO sml_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Jari aniya' batu tinambak e' si Gidiyun maina'an pagtutukbalan ni PANGHŪꞋ, niōnan e'na “Si Yawe ya Kasannangan.” Ina'an masi sampay ni buwattina'an ma Opra ya ma tana' bangsa Ebe'eser. ");
INSERT INTO sml_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Na, ma sangom he'-i du, amissala PANGHŪꞋ-Yawe ni si Gidiyun, “Angā' ka dakayu' sapi' pituntahun umulna min saga sapi' mma'nu ya pasunu' kahāpna min kasehe'an. Pagā'nu, langkatun pagtutukbalan ya pasumbahan mma'nu ni tuhan-tuhan Ba'al, maka pōngun isāb hāg si Asera ya ma bihing ina'an-i. ");
INSERT INTO sml_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Talangkat pa'in, angahinang ka pagtutukbalan ya tōp panumbahan si Yawe ya pagtuhanannu. Hinangun mailu ma diyata' būd-būd itu. Ngā'un hāg tuhan-tuhan Asera ya bay pinagpōng-pōng, panunu' sapi' ya pasunu' kahāpna ilu pagkulbannu ni Tuhan.” ");
INSERT INTO sml_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Angkan si Gidiyun bay amowa sangpū' puhu' ya sosoho'anna bo' bineya' e'na bay pangallam PANGHŪꞋ ma iya. Bo' arapun nihinang e'na ma waktu sangom sabab tināw iya ma saga kampungna maka saga a'a maglahat ma kauman inan. ");
INSERT INTO sml_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Pagsubu, magbati'an pa'in saga a'a maglahat maina'an, takuddat sigām pagga alubu na pagtutukbalan ni si Ba'al, maka hāg si Asera ya ma bihingna bay pinuwad, maka in sapi' karuwana bay na pangungsud ma pagtutukbalan ya baha'u nihinang. ");
INSERT INTO sml_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Jari magtilaw-tilawan sigām di-sigām, “Sai bay magkahinangan itu?” Tapariksa' pa'in saga a'a pasal palkala' itu, tata'u na in si Gidiyun anak si Jowas ya bay magkahinangan. ");
INSERT INTO sml_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Magtūy pinalinganan si Jowas, sinō' pinaluwas anakna, sabab yuk sigām, “Patut iya pinapatay sabab talangkat e'na pagtutukbalan ni si Ba'al, maka tapuwad e'na hāg si Asera ya bay ma bihing pagtutukbalan e'.” ");
INSERT INTO sml_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Saguwā' sinambungan pakosog e' si Jowas saga a'a bilahi amapatay si Gidiyun, “Angay dapitanbi si Ba'al? Bilahi kam angalappas iya? Sasuku anganggapi' iya subay pinapatay salung subu! Bang b'nnal tuhan si Ba'al, makarapitan iya di-na bang aniya' ganta' amaka'at lugal pagtutukbalan ma iya.” ");
INSERT INTO sml_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Angkan ma llaw he'-i du in si Gidiyun niōnan e' sigām Jerub-Ba'al ma sabab pangalangkatna ma lugal pagtutukbalan si Ba'al. Ya sambatan sigām, “Pasagaranta si Ba'al angandapitan di-na.” ");
INSERT INTO sml_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Na ma waktu ina'an, magsakaum bangsa Midiyan maka bangsa Amalek maka saga bangsa kasehe'an ya min lahat sobangan ati pauntas sigām kamemon min dambila' sapa' Jordan bo' magpustu ma kapantayan Jesde'el. ");
INSERT INTO sml_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Jari pahōp Rū Yawe ma si Gidiyun, angkan iya bay amah'lling tiyup-tiyup pangalinganna ma saga panubu' Abe'eser sinō' ameya' ma iya. ");
INSERT INTO sml_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Aniya' isāb saga sosoho'an bay pinapehē' e' si Gidiyun amasaplag bissala ma bangsa Manasse, sinō' magtakos. Pinasaplagan isāb bangsa Aser, Sibulun maka Naptali, jari ya du sigām bay pasakaum ma disi Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Yuk si Gidiyun ni Tuhan, “Bang b'nnal in aku gunanu angalappas bangsa Isra'il ma buwat bay janji'nu, ");
INSERT INTO sml_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","na, amat'nna' aku bulbul bili-bili ma lugal paggi'ikan pai-tirigu. Bang hal bulbul ya abase' e' alu', ati atoho' tana' ya ma sakalibutna, minnē' kata'uwanku aku ya gunanu angalappas bangsa Isra'il buwat bay pangallamnu.” ");
INSERT INTO sml_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Jari buwattē' ya kapaniya'na. Pagk'llat subu, dai'-dai' llaw gi', abati' na si Gidiyun. Piniyutan e'na bulbul bili-bili ati ap'nno' dapinggan e' bohe' alu'. ");
INSERT INTO sml_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Aniya' gi' pah'lling si Gidiyun ma Tuhan, yukna, “Da'a busung. Da'a pa'in ap'ddi' ataynu ma aku pagka aniya' gi' amu'ku ni ka'a. Tugutin lagi' aku amiha dakayu' paltanda'an ma bulbul bili-bili itu. Ma waktu itu, kabaya'anku subay tana' ya abase' e' alu' ati bulbul bili-bili ya atoho'.” ");
INSERT INTO sml_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Jari ma sangom du he', tahinang e' Tuhan buwat bay pangamu' e' si Gidiyun. Hal bulbul bili-bili ya atoho'. Ya tana' ma sakalibutna inān abase' kamemon e' alu'. ");
INSERT INTO sml_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Jari dai' llaw pa'in, magpustu si Jerub-Ba'al (ya na si Gidiyun) maka kamemon saga a'ana ma atag dakayu' tigbaw ya niōnan Harod. Ina'an isāb bangsa Midiyan magpustu tampal ni uttala', ma kapantayan ya asekot ni būd More. ");
INSERT INTO sml_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Yuk PANGHŪꞋ-Yawe ni si Gidiyun, “Mbal ka tapara'ugku min bangsa Midiyan sabab aheka makalandu' saga a'anu. Bang kam ganta' anganda'ug ma buwattilu hekabi, ya aniya' magmalangkahi kam in kosogbi ya sababan angkan kam anganda'ug. ");
INSERT INTO sml_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Angkanna ka soho'ku amatanyagan saga a'anu buwattina'an. Ya yuknu ma sigām, ‘Sasuku kam tināw maka nileya'-leya' makajari ala'an min būd Giliyad itu bo' amole'.’ ” Jari aniya' duwampū' karuwa ngibu saga a'a bay ala'an, ati sangpū' ngibu la'a ya takapin. ");
INSERT INTO sml_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Saguwā' yuk PANGHŪꞋ ni si Gidiyun, “Masi gi' kam aheka makalandu'. Bowahun saga a'anu ilu palūd ni tigbaw, ati mahē' aku amene' bang sai ya ameya' maka mbal. Bang yukku, ‘A'a itu subay ameya' ma ka'a’, na ameya' iya. Saguwā' bang yukku, ‘A'a itu subay mbal ameya'’, na, da'a pabeya'un.” ");
INSERT INTO sml_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Jari binowa e' si Gidiyun saga a'ana palūd ni tigbaw, ati maina'an iya kinallaman e' PANGHŪꞋ, yuk-i, “Hinangun sigām duwa tumpuk. Ma tumpuk dakayu' saga a'a ya anginum min tangan sigām, hatina d'lla' sigām ni bohe' buwat ero'. Ma tumpuk dakayu' isāb saga a'a ya angōk-tu'ut bo' anginum.” ");
INSERT INTO sml_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Jari t'llu hatus a'a ya angakup bohe' bo' anginum. Ya kasehe'an wa'i angōk-tu'ut anginum. ");
INSERT INTO sml_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Pagubus, yuk PANGHŪꞋ ni si Gidiyun, “Gunaku saga t'llu hatus a'a ya bay anginum min tangan sigām ilu, ati lappasta kam maka buwananta kam da'ugan min saga a'a Midiyan. Soho'un saga a'a kasehe'an ilu amole' ni kalahatan sigām pakaniya-pakaniya.” ");
INSERT INTO sml_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Jari tinimuk e' si Gidiyun ba'anan balanja' maka tiyup-tiyup ya bay ma saga bangsa Isra'il kasehe'an bo' yampa sigām papole'na. Sagō', in t'llu hatus a'a bay magpa'bba ma iya sampay ya bay tatimuk e'. Jari ya pustu bangsa Midiyan ina'an ma l'bbak būd ma kapantayan. ");
INSERT INTO sml_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ma sangom du inān, yuk PANGHŪꞋ ma si Gidiyun, “Punduk ka bo' ka pehē' parugpak ni pustu inān sabab para'ugku ka min sigām. ");
INSERT INTO sml_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Saguwā' bang ka tināw amono', bowahun tendognu si Pura panehe'. ");
INSERT INTO sml_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Taenghogin bang ai pagsuli-sulihan sigām. Minnē' ka anawakkal parugpak ni pustu.” Angkanna palūd si Gidiyun maka tendogna si Pura pehē' ni pagjajagahan ma tōng pustu. ");
INSERT INTO sml_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Na, angulatap saga bangsa Midiyan maka bangsa Amalek maka ba'anan bangsa kasehe' ya bay min lahat sobangan. Ina'an sigām ma kapantayan, sali' sapantun ampan dulu ya heka sigām. Ya unta' sigām isāb mbal ta'ambat ni'itung, buwat sapantun gusung ma bihing tampe. ");
INSERT INTO sml_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Pagt'kka pa'in si Gidiyun, magsalta' takalena dangan a'a magsuli-suli maka bagayna pasal uppina. Yuk dangan itu, “Aniya' dansolag tinapay atibulung bay tauppiku. In tinapay itu bay pagulung ni t'ngnga' pustu Midiyan bo' parugtul ni luma' tolda. Landu' akosog hamiyuna angkan abulangkayat tolda inān sampay ah'bba'.” ");
INSERT INTO sml_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Anambung bagayna, “Ā, tantu halam aniya' ma'anana saddī. Kalis si Gidiyun ko' ilu, ya anak si Jowas a'a bangsa Isra'il. Pinara'ug iya e' Tuhan min bangsa Midiyan ati ma iya na pustu itu maka saga a'ana.” ");
INSERT INTO sml_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Takale pa'in e' si Gidiyun suli-suli itu pasal uppi maka ma'anana, pinudji e'na Tuhan, ati pabalik iya ni pustu Isra'il maka e'na angalingan, yuk-i, “Magsakap kam! Ma waktu itu pinara'ug kitam e' PANGHŪꞋ min bangsa Midiyan ati makani-kitam in pustu sigām.” ");
INSERT INTO sml_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Jari binahagi' t'llu e' si Gidiyun saga a'ana, dahatus hekana ma datumpuk. Aniya' isāb tiyup-tiyup tanduk kambing bay pat'nna'na ma saga a'a inān dangan-parangan, maka kibut halam isihan maka isāb suwariyan. ");
INSERT INTO sml_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Pagubus, yukna ma sigām, “Nda'unbi aku maka beya'unbi bang ai hinangku. Pagt'kkaku ni bihing pustu, sengorinbi aku. ");
INSERT INTO sml_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Libutunbi pustu inān, jari bang takalebi aku maka saga sehe'ku amah'lling tiyup-tiyup kami, ameya'-meya' kam amah'lling saga tiyup-tiyupbi. Angolang kam pakosog isāb, yukbi, ‘Ma si Yawe maka si Gidiyun.’ ” ");
INSERT INTO sml_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Jari atonga' pa'in bahangi, at'kka na si Gidiyun maka saga a'a karahatus hekana pehē' ni tobtoban pustu, hinabu baha'u bay magganti' saga jaga. Magtūy tiniyup e' disi Gidiyun saga tiyup-tiyup, maka nilopot isāb saga kibut ya bay bowa sigām. ");
INSERT INTO sml_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Magsabu in t'llu tumpukan bangsa Isra'il amah'lling tiyup-tiyup maka angalopot saga kibut. Tangan sigām gibang ya pang'ntan suwariyan, maka tangan kowan ya pang'ntan sigām tiyup-tiyup. Jari angolang sigām patanog, “Kalis si Yawe! Kalis si Gidiyun!” ");
INSERT INTO sml_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Sakali itu, hinabu patanam saga a'a Isra'il ma katilibut pustu, maglahian kamemon a'a Midiyan maka e' sigām magpangolang. ");
INSERT INTO sml_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Pagh'lling pa'in saga tiyup-tiyup t'llu hatus hekana, pinapagatu e' PANGHŪꞋ-Yawe saga a'a Midiyan ma kaluha'an pustu ati magbono'-biyono'i sigām dampagkahian. Maglahian sigām sampay ni kauman Bet-Sita tampal ni Serera, sampay ta'abut isāb tobtoban lahat Abel Mehola ya asekot ni Tabat. ");
INSERT INTO sml_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Jari pinalinganan saga a'a Isra'il ya min bangsa Naptali maka Aser, maka min kamemon bangsa Manasse, sinō' angapas bangsa Midiyan. ");
INSERT INTO sml_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Pagubus, aniya' saga sosoho'an pinapehē' e' si Gidiyun ni kabūd-būran lahat Epra'im bo' ah'lling ni saga a'a maina'an, yuk-i, “Palūd kam ni sapa' Jordan ma atag kaluma'an Bet-Bara ati hapa'inbi saga a'a Midiyan bo' mbal makauntas.” Magtūy bineya' panoho'an si Gidiyun ati maglūran bangsa Epra'im ni sapa' Jordan anunggu'an labayan sampay ni Bet-Bara. ");
INSERT INTO sml_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Tasaggaw isāb e' sigām duwa a'a pagnakura'an bangsa Midiyan ya niōnan si Oreb maka si Se'eb. Si Oreb bay pinapatay e' sigām ma dakayu' batu, ya niōnan Batu si Oreb, maka si Se'eb bay pinapatay ma pagp'gga'an buwa' anggul, ya niōnan Pagp'gga'an si Se'eb. Pagubus, tinurul na pa'in saga bangsa Midiyan e' bangsa Epra'im. Pinonggolan e' sigām kōk si Oreb maka si Se'eb bo' binowa ni si Gidiyun, ya ina'an lagi' ma bihing sapa' Jordan. ");
INSERT INTO sml_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Na, atilaw saga a'a Epra'im ni si Gidiyun, yuk-i, “Angay kami mbal pagaddatannu? Angay kami halam bay palinganannu ma waktu kapehē'bi magbono' maka bangsa Midiyan?” Ati sinoway e' sigām si Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Saguwā' ya sambungna ni sigām, “Mbal makasali' ai-ai bay tahinangku ni bay tahinangbi. Aheya lagi' kahāpan ya kapin buwa' anggul tapuwa' ma lahat Epra'im min kamemon pungutan buwa' anggul ya tak'ttu' e' bangsa Abise'er. ");
INSERT INTO sml_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Bay kam pinara'ug e' Tuhan ati tasaggawbi si Oreb maka si Se'eb, duwangan nakura' bangsa Midiyan. Mbal makasali' ya tahinangku ni bay tahinangbi.” Minnē' ala'an kagit atay sigām ma si Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Na, apaya si Gidiyun maka saga a'ana t'llu hatus hekana, sagō' sinandalan na pa'in e' sigām bang pa'in ta'apas saga banta sigām. Maka'abut pa'in sigām ni sapa' Jordan, magtūy sigām pauntas parambila'. ");
INSERT INTO sml_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Ma dambila' pa'in, yuk si Gidiyun ni saga a'a Sokkot, “Buwaninbi tinapay saga sundaluku itu. Apaya sigām sabab masi kami angapas si Seba maka si Salmunna, ya sultan bangsa Midiyan.” ");
INSERT INTO sml_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Saguwā' ah'lling saga pagnakura'an ma Sokkot, yuk-i, “Halam gi' tasaggawbi si Seba maka si Salmunna angkan kami mbal amuwan tinapay ma saga sundalunu.” ");
INSERT INTO sml_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Angkan anambung si Gidiyun, yukna, “Pagga buwattē', bang aku karūlan na e' PANGHŪꞋ anaggaw si Seba maka si Salmunna, gilay-gilayku baranbi maka saga kayu itingan ya tapuwa' ma paslangan.” ");
INSERT INTO sml_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Pagla'an minnē', palanjal sigām ni Peniyēl ati binalikan e' si Gidiyun bay pangamu'na dahū ma a'a Sokkot. Saguwā' ya lling a'a Peniyēl ma si Gidiyun sali' du maka buwat bay lling a'a Sokkot. ");
INSERT INTO sml_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Angkan sinambungan saga a'a Peniyēl inān e' si Gidiyun, yukna, “Bang kami makara'ug, pabalik du kami pi'itu angalubu pamantawanbi itu.” ");
INSERT INTO sml_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Na, si Seba maka si Salmunna wa'i ma lahat Karkor maka sundalu sigām saga sangpū' kalima ngibu hekana. Luwal sigām ya takapin ma kamemon saga a'a sobangan. Aniya' saga dahatus maka duwampū' ngibu a'a sigām magtakos kalis bay tapapatay e' disi Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Jari magtukaran disi Gidiyun labay min lān palabayan saga a'a maglilitu. In lān inān asal ma jadjahan lahat Noba maka Jogbeya, tampal ni sobangan. Pataggaha', tarugpak bangsa Midiyan e' disi Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Makalahi si Seba maka si Salmunna, ya duwangan sultan bangsa Midiyan, saguwā' niapas na pa'in e' disi Gidiyun sampay tasaggaw na. Arimpulag isāb ba'anan saga sundalu sigām. ");
INSERT INTO sml_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Pagubus, si Gidiyun anak si Jowas pabalik na min pagbono'an labay min lān ma llot būd, ya niōnan Lān Heres. ");
INSERT INTO sml_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Aniya' a'a Sokkot, onde' baha'u, tasaggaw e' si Gidiyun maina'an. Sinoho' iya anulat ōn a'a ya pagnakura'an ma kauman Sokkot. Jari pitumpū' ka pitu' ōn saga pagmatto'ahan ya tasulat. ");
INSERT INTO sml_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Pagubus, pehē' si Gidiyun ah'lling ni saga a'a Sokkot, “Itiya' na si Seba maka si Salmunna ya bay pagtunggīnganbi aku ma bay yukbi, ‘Halam gi' tasaggawbi si Seba maka si Salmunna, angkan kami mbal amuwan tinapay ni saga sundalunu magpayahan.’ ” ");
INSERT INTO sml_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Sakali saga pagmatto'ahan ma kauman Sokkot inān bay niraplosan e' si Gidiyun maka kayu itingan ya patomo' ma paslangan. Minnē' amintāng saga kal'llahan ma lahat Sokkot. ");
INSERT INTO sml_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Nilubu isāb e' si Gidiyun ya pamantawan ma kauman Peniyēl, maka pinapatay isāb saga kal'llahanna ma kauman inān. ");
INSERT INTO sml_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Pagubus, tinilaw e'na si Seba maka si Salmunna, “Buwattingga luwa saga kal'llahan bay tapapataybi ma Tabor?” Ya sambung sigām, “Kal'llahan buwat ka'a, pangluwahan balbangsa.” ");
INSERT INTO sml_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Yuk sambung si Gidiyun, “Saga danakanku lissi ko' he', da-ina' kami. Sapahanku ma ōn si Yawe ya Tuhan kakkal salama-lama, bang sigām halam bay tapataybi, mbal du kam papatayku.” ");
INSERT INTO sml_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Magtūy lingi'na si Jeter ya anakna kasiyakahan, “Papatayun sigām itu!” yukna. Saguwā' halam bay nihublut e' si Jeter kalisna, tu'ud iya tināw sabab masi gi' iya abata'. ");
INSERT INTO sml_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Yuk si Seba maka si Salmunna ni si Gidiyun, “Dai' ka, ka'a ya amapatay. Kalu takole'nu bang aniya' isāb kosognu.” Angkan pasōng si Gidiyun ni dahūan amapatay sigām. Ningā' isāb e'na saga pamulawan ya pama'alti k'llong unta' sigām. ");
INSERT INTO sml_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Yuk saga bangsa Isra'il ni si Gidiyun, “Ka'a na pagnakura'an kami, ka'a maka anak-mpunu, sabab bay kami lappasnu min komkoman saga a'a Midiyan.” ");
INSERT INTO sml_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Saguwā' mbal si Gidiyun. Ya sambungna ma sigām, “Mbal kam pagnakura'anku, damikiyanna isab anakku. PANGHŪꞋ-Yawe ya magnakura'an ka'am.” ");
INSERT INTO sml_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Maka yukna gi', “Aniya' dakayu' amu'ku ni ka'am dangan-parangan. Buwaninbi aku aretes min lalangpasan bay tahampitbi.” (Ya addat saga a'a Isma'il magaretes bulawan.) ");
INSERT INTO sml_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Ya sambung sigām, “Aho'. Amuwan kami.” Angkan bin'llat e' sigām dakayu' juba, ati dangan-parangan angalarukan aretes min bay pamahagi' ma iya. ");
INSERT INTO sml_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Ya buhat saga aretes bulawan bay ta'amu'na, sangpū' ka pitu' hatus sekel, halam gi' beya' saga pamulawan pangalti maka saga tonton engkot k'llong. Saddī isab saga kakana' taluk ya pinagpakay e' kasultanan Midiyan, maka saga kili-kili bulawan ya ma k'llong saga unta' sigām. ");
INSERT INTO sml_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","In kamemon bulawan bay pinahinang epod e' si Gidiyun pinat'nna' e'na ma Opra, ya kauman palahatanna. Sakali kamemon saga bangsa Isra'il pataikut min Tuhan bo' anumba pina'an ni epod, ati tahinang itu sasat ma pagtali'anak si Gidiyun. ");
INSERT INTO sml_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Buwattē' kahālan bay paniya' ma bangsa Midiyan, tara'ug sigām e' bangsa Isra'il ati halam na sigām maka'atu pabalik. Ma waktu bay kallum si Gidiyun, aniya' mpatpū' tahun ya t'ggol kasannangan ma paglahat. ");
INSERT INTO sml_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Ya katapusanna, si Jerub-Ba'al ya anak si Jowas amole' na ni lahatna. ");
INSERT INTO sml_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Aheka kah'nda'anna ati aniya' pitumpū' anakna l'lla. ");
INSERT INTO sml_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Ya h'nda-h'ndana pat'nna' ma Sekem, bay anganak l'lla ati niōnan e'na si Abimelek. ");
INSERT INTO sml_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Sakali si Gidiyun anak si Jowas, amatay ma kato'ana maka kinubul ma bay pangubulan mma'na ma kauman Opra ya suku' bangsa Abe'eser. ");
INSERT INTO sml_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Halam lagi' at'ggol kapatay si Gidiyun, pabalik na isab saga bangsa Isra'il pataikut min Tuhan bo' pasumba ni saga tuhan-tuhan Ba'al. Ba'al-Berit ya tahinang pagtuhanan sigām, ");
INSERT INTO sml_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ati takalipat e' sigām si Yawe ya pagtuhanan sigām luggiya', ya bay angalappas sigām min pang'ntanan saga palbantahan sigām paruruwambila'. ");
INSERT INTO sml_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Halam isāb ama'nda' kahāpan ni tautai'-anak si Jerub-Ba'al (ya na si Gidiyun) ma pasal kamemon kahāpan ya bay tahinangna ma sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Manjari itu, si Abimelek, dakayu' anak si Gidiyun l'lla, bay pehē' ni da'ira Sekem anibaw saga si'itna ya danakan ina'na l'lla. Amissala iya ni saga si'itna maka ni kaukampungan ina'na, yuk-i, ");
INSERT INTO sml_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“Tilawunbi saga a'a lahat Sekem itu bang sai ya kabaya'an sigām magnakura'. Ingga ahāp magnakura' ma ka'am, saga kapitumpū' anak si Jerub-Ba'al atawa dakayu' a'a sadja? Entomunbi, in aku itu lissi lahasiya'bi.” ");
INSERT INTO sml_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Na, bay pa'in bissala itu tapangahaka e' saga si'itna ni kamemon saga maglalahat ma Sekem, si Abimelek ya tapene' pagnakura'an sigām sabab in iya lahasiya' sigām lissi. ");
INSERT INTO sml_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Jari pamuwan e' sigām ma si Abimelek pitumpū' sekel dī pilak luwas bay min langgal Ba'al-Beret, ati ginuna itu e'na panamba saga a'a bula'ug tahinang tendogna. ");
INSERT INTO sml_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Pagubus, pehē' iya ni luma' mma'na ma Opra ati maina'an, ma dakayu' batu, pinapatay e'na saga danakanna kapitumpū'. Si Jerub-Ba'al ya mma' sigām kamemon. Malaingkan si Jotam, ya kasiyalihan, bay makalahi patapuk. ");
INSERT INTO sml_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Sakali magsakaum kamemon saga a'a Sekem maka Bet-Milo ma atag po'on kayu aheya ma da'ira Sekem inān bo' amat'nna' si Abimelek magsultan ma sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Kahaka'an pa'in si Jotam ma pasalan itu-i, patukad iya ni puttuk būd Gerisim ati angolang ni saga a'a Sekem, yukna, “Owa', ka'am maglalahat ma Sekem ilu, kalehunbi paralilanku itu bo' supaya kam kinale e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","Dakayu' llaw, saga po'on kayu bay maggara' amiha kayu pagsultanan sigām. Yuk sigām ni po'on kayu jaitun, ‘Dai' ka magsultanan kami.’ ");
INSERT INTO sml_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","“Saguwā' yuk sambung kayu jaitun, ‘Angay? Bbahanku bahā' hinangku maghinang ns'llanku, ya ginuna pamaheya ma saga tuhan maka ma manusiya', bo' supaya aku tahinang alanga min ka'am saga kakayu-kayuhan?’ ");
INSERT INTO sml_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“Pasunu', ah'lling saga po'on kayu itu ni dampo'on kayu igira, yuk-i, ‘Dai' ka magsultanan kami.’ ");
INSERT INTO sml_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","“Saguwā' yuk sambung kayu igira, ‘Angay? Bbahanku bahā' buwa'ku ahāp maka amamis itu, bo' supaya aku tahinang alanga min ka'am saga kakayu-kayuhan?’ ");
INSERT INTO sml_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“Ah'lling isāb saga po'on kayu itu ni tinanom anggul, yuk-i, ‘Dai' ka magsultanan kami.’ ");
INSERT INTO sml_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","“Ya sambung tinanom anggul, ‘Angay? Bbahanku bahā' binu-anggulku, ya makapalasig atay katuhanan maka manusiya', supaya aku palanga min kakayu-kayuhan kasehe'?’ ");
INSERT INTO sml_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“Ma kahinapusanna, ah'lling saga po'on kayu ni dampo'on kayu itingan, ‘Na, ka'a na ya magsultanan kami.’ ");
INSERT INTO sml_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","“Anambung kayu itingan itu, yukna, ‘Bang aku to'ongan ya pene'bi magsultanan ka'am, pi'itu kam pasindung ma lambungku. Sagō' bang ngga'i ka aku, na, bang pa'in pasuleyab api min saga sangaku bo' magtautunu' saga po'on kayu sidro ya ma kabūran Lebanon.’ ” ");
INSERT INTO sml_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","Amissala gi' si Jotam, yukna, “Kira-kirahunbi. Abontol bahā' itikadbi ma kapangahinangbi si Abimelek magsultanan ka'am? Ahāp ka niyatbi? Taluwa' bahā' ya bay hinangbi ma mma'ku si Jerub-Ba'al maka saga panganakna? Ahāp bahā' panungbasbi ma iya ma bay kahinanganna ma ka'am? ");
INSERT INTO sml_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Marai' halam taentombi bay hinang mma'ku ma pasalanbi, waktu kapangatuna ma bangsa Midiyan. Bay panūk kallumna supaya kam kaliyusan min komkoman sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Saguwā' buwattina'an, bantahanbi panubu' mma'ku pagka papataybi saga anakna l'lla pitumpū' hekana. Bay papataybi ma dakayu' batu ma saukat si Abimelek ya kampungbi, ati tahinangbi iya magsultanan saga a'a Sekem. Bo' arapun in si Abimelek ilu hal anak ata ya bay h'nda-h'nda mma'ku. ");
INSERT INTO sml_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Na, bang b'nnal to'ongan abontol itikadbi maka asaltun niyatbi tudju ni si Jerub-Ba'al magtautai'-anak, mura-murahan bang pa'in pagkōg-koyaganbi si Abimelek. Damikiyanna isāb ka'am ya pagkōganna. ");
INSERT INTO sml_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Malaingkan bang ala'at maksudbi angkan iya hinangbi sultan, na, bang pa'in aniya' api paluwas min si Abimelek ilu angalapnas ka'am saga maglalahat ma Sekem maka ma Bet-Milo! Bang pa'in isāb aniya' api paluwas min ka'am papelleng ni si Abimelek!” ");
INSERT INTO sml_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Pagubus, alahi si Jotam patapuk ni lahat Be'er ati mahē' iya pat'nna' sabab tināw iya ma danakanna si Abimelek. ");
INSERT INTO sml_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Manjari itu, palabay pa'in t'lluntahun kapamarinta si Abimelek ma bangsa Isra'il, ");
INSERT INTO sml_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","aniya' pagsababan pinat'kka e' Tuhan ma si Abimelek maka saga a'a Sekem, ya po'on sigām magsagga'. Jari mbal na angaku pinagbaya'an e' si Abimelek saga maglalahat ma da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","Pinat'kka e' Tuhan palkala' itu supaya kabalosan kamatay saga anak si Jerub-Ba'al pitumpū' hekana, ya bay pinapatay e' danakan sigām si Abimelek. Jari katungbasan si Abimelek maka saga a'a Sekem ya bay anabangan iya amono' saga dauranakanna. ");
INSERT INTO sml_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","Pagka in a'a Sekem mbal na angaku pinagbaya'an e' si Abimelek, aniya' min sigām pehē' ni kabūd-būran angahapa' maka angalangpasan sasuku palabay minna'an. Sagō' tapata'u si Abimelek ma pasalan itu-i. ");
INSERT INTO sml_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","Na, aniya' a'a niōnan si Ga'al, anak si Ebed, wa'i papinda ni Sekem, beya' isab maka saga danakanna l'lla, ati pangandolan iya e' saga a'a maina'an. ");
INSERT INTO sml_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","Ta'abut pa'in musim pagk'ttu' buwa' anggul, pehē' na saga a'a Sekem ni kabbun sigām, ati pin'gga' buwa' anggul nihinang binu. Pagubus, bay sigām amaniya' paglami-lami ma langgal tuhan-tuhan sigām. Sabu sigām magkakan maka maginum, sinapdahan e' sigām si Abimelek. ");
INSERT INTO sml_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","Yuk si Ga'al anak si Ebed, “Sai sa si Abimelek, ya angkan kitam a'a Sekem itu subay magpatireyo' ma iya? Bang aku mbal asā', in iya hal anak si Jerub-Ba'al, maka si Sebol ya pangandolanna. Ya patut subay paghinanganbi si Hamor, ya pangkatanbi saga a'a Sekem. ");
INSERT INTO sml_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","Bang sadja saga a'a itu bay kapagbaya'anku, tantu pala'anku si Abimelek. Ya pah'llingku ma iya, ‘Pasakapun saga a'anu magbobono' bo' kitam makapagatu!’ ” ");
INSERT INTO sml_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","Na, kahaka'an pa'in si Sebol ya gubnul ma da'ira inān pasal bay pah'lling si Ga'al anak si Ebed he', akagit sidda atayna. ");
INSERT INTO sml_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","Jari aniya' sosoho'an pinapehē' e'na ni si Abimelek ma halam aniya' makata'u. Yuk lapalna, “Si Ga'al maka saga danakanna l'lla bay papinda pi'itu ni Sekem ati sinūg-sūgan saga a'a angatuhan ka'a. ");
INSERT INTO sml_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","Angkan ma sangom itu, ka'a maka saga a'anu subay pi'itu patapuk ma kaparangan, ");
INSERT INTO sml_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","ati pagk'llat mata llaw, palanjal kam angandugpak ni da'ira. Makaluwas pa'in si Ga'al maka saga a'ana magbobono' angatuhan ka'am, hinangun na bang ai kabaya'annu.” ");
INSERT INTO sml_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","Angkanna, pagsangom pa'in, palanjal na si Abimelek maka kamemon saga sundaluna patapuk ma kasekotan da'ira Sekem. Mpat heka tumpukan sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","Na, wa'i si Ga'al itu an'ngge ma luwasan lawang ya pagsōran ni da'ira, salta' si Abimelek maka saga sundaluna paluwas min patapukan sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","Ta'nda' pa'in sigām e' si Ga'al, jari yukna ni si Sebol, “Nda'un ba, aniya' saga a'a palūd min saga puttuk būd inān.” Yuk sambung si Sebol, “Asā' ka, tuwan, lambung būd ko' ilu, ngga'i ka a'a.” ");
INSERT INTO sml_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","Saguwā' ah'lling pabalik si Ga'al, “Nda'un ba, aniya' to'ongan saga a'a palūd min kabūd-būran. Maka aniya' tumpukan dakayu' lum'ngngan tudju pi'itu min po'on kayu ya niōnan kayu saga magpuputika'.” ");
INSERT INTO sml_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","Ah'lling si Sebol ma si Ga'al, yuk-i, “Abowa' pahāp ka'a ilu! Bay pagtunggīngannu si Abimelek pagga yuknu, ‘Sai sa si Abimelek ya angkan kitam subay magpatireyo' ma iya?’ Ilu na saga a'a ya bay pareyo'-deyo'nu. Na, paluwas na ka pehē' angatuhan sigām!” ");
INSERT INTO sml_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","Jari palanjal si Ga'al amowa saga a'a Sekem magbono' maka disi Abimelek. ");
INSERT INTO sml_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","Niapas sigām e' si Abimelek sampay ni lawang da'ira ati aheka sigām abugtang. ");
INSERT INTO sml_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","Manjari pahanti' si Abimelek ma lahat Aruma, bo' arapun si Ga'al maka saga danakanna l'lla bay tin'ggal e' si Sebol min da'ira Sekem. ");
INSERT INTO sml_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","Pag'llaw dakayu' pa'in, kahaka'an si Abimelek in saga a'a Sekem magluwasan na ni kahuma-huma'an. ");
INSERT INTO sml_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","Angkan iya bay amowa saga a'ana magbahagi' t'llu tumpukan. Sinō' sigām patapuk ma t'ngnga' huma bo' nihapa'an saga a'a Sekem. Sakali pag'nda' si Abimelek aniya' a'a paluwas min da'ira, magtūy iya patanam amono'. ");
INSERT INTO sml_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","Magdai'-dai' iya maka dakayu' tumpukan sundaluna ni lawang da'ira bo' kajagahan labayan pagsōd-luwasan. In duwa tumpukan kasehe' wa'i angandugpak ni saga a'a Sekem ya ma kahuma-huma'an, ati nilaglag kamemon. ");
INSERT INTO sml_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","Magbono' na pa'in sigām sampay ni kakohapan, jari kalongkopan da'ira Sekem e' disi Abimelek. Pinapatay saga a'ana kamemon, nilubu kaluma'anna, maka sinabulakan asin. ");
INSERT INTO sml_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","Makata'u pa'in saga pagnakura'an ya ma pamantawan ma Sekem pasal pakaradja'an itu, magtūy sigām pehē' ni langgal Ba'al-Berit bo' patapuk ma kuta'na ahogot. ");
INSERT INTO sml_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","Kahaka'an pa'in si Abimelek pasal kapehē' saga nakura', ");
INSERT INTO sml_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","magtukaran iya maka saga a'ana ni būd Salmon. Pagmaina'an pa'in, angā' iya kapa pamōngna saga sanga kayu bo' tinanggung e'na. Bay soho'na isāb saga a'ana anengoran iya, yuk-i, “Pakasay kam! Beya'inbi hinangku!” ");
INSERT INTO sml_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","Manjari aniya' sanga kayu pinōng e' kamemon saga sundalu inān. Magpameya' sigām ma si Abimelek ati pinabangkat ba'anan sanga kayu inān ma sakalibut lugal ya patapukan saga a'a Sekem. Tabangkat pa'in, pinarokot na ati magpatayan saga a'a ma deyom pamantawan he'. Dangibu heka a'a d'nda-l'lla bay amatay. ");
INSERT INTO sml_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","Pagubus ina'an, palanjal disi Abimelek ni kauman Tebe bo' nilibut e' sigām. Jari taga'os lahat inān. ");
INSERT INTO sml_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","Saguwā' aniya' pamantawan apagon ma deyom da'ira inān, ati maglahian pehē' kamemon saga a'a Tebe, kal'llahan maka kar'ndahan. Tinambol e' sigām pahogot bo' yampa pariyata' ni karatagan atop. ");
INSERT INTO sml_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","Jari pehē' si Abimelek ni pamantawan bang kalu tarugpak e'na. Sagō' makasekot pa'in iya ni pasōran pamantawan bo' angandokot api panunu' saga a'a ma deyom, ");
INSERT INTO sml_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","aniya' d'nda bay angahūg batu gilingan, landu' abuhat. Taluwa' kōk si Abimelek ati am'kka' peya'-peya' kōkna. ");
INSERT INTO sml_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","Magtūy lingananna sehe'na ya magbobowa pakokosna, yuk-i, “Pakasay ka angahublut kalisnu angandugsu'an aku, bo' mbal tapagsuli-suli e' a'a, ‘In si Abimelek bay pinapatay e' d'nda.’ ” Jari nirugsu'an iya e' sosoho'anna, pinalatus parambila', angkan iya amatay. ");
INSERT INTO sml_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","Tanda' pa'in e' saga a'a Isra'il in si Abimelek amatay na, magpole'an na sigām. ");
INSERT INTO sml_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","Minnē' katungbasan e' Tuhan si Abimelek ma kala'atan ya bay hinangna ma mma'na, pagka tapapatay e'na dauranakanna l'lla pitumpū' puhu'. ");
INSERT INTO sml_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","Katungbasan isāb saga a'a Sekem ma pasal kala'atan ya bay tahinang sigām. Hatina papelleng ni sigām ya bay sapda si Jotam anak si Jerub-Ba'al. ");
INSERT INTO sml_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Na, awapat pa'in si Abimelek, aniya' l'lla niōnan si Tola pas'lle' angalappas bangsa Isra'il. Si Tola itu anak si Puwa, ya Puwa bay anak si Dodo, min panubu' si Issakar. Pat'nna' iya ma kaluma'an Samir ma kabūd-būran Epra'im. ");
INSERT INTO sml_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Saga duwampū' ka t'lluntahun t'ggol si Tola magmakōk ma bangsa Isra'il. Pagpatayna pa'in, kinubul iya ma Samir. ");
INSERT INTO sml_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Ya pasunu' ni si Tola si Ja'ir a'a Giliyad. Duwampū' ka duwantahun kapagmakōkna ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Taga-anak iya l'lla t'llumpū' puhu', ya pakura' ma t'llumpū' kura'. Kapagagihan e' sigām t'llumpū' heka da'ira ma lahat Giliyad, ya pinagōnan Kakauman si Ja'ir sampay ni kabuwattina'anan. ");
INSERT INTO sml_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Amatay pa'in si Ja'ir, kinubul iya ma Kamun. ");
INSERT INTO sml_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Pabalik na isāb saga bangsa Isra'il maghinang kala'atan ya landu' asammal ma pang'nda' si Yawe. Sinumba e' sigām saga tuhan-tuhan Ba'al maka Astoret, maka ba'anan tuhan-tuhan ya tina'at e' bangsa Aram, bangsa Sidun, bangsa Mowab, maka bangsa Pilistin. Kataikutan e' sigām si Yawe ya Tuhan sigām, mbal na magta'at ma iya, ");
INSERT INTO sml_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","angkan akagit atayna ma sigām. Sinōngan sigām e'na ni ga'osan bangsa Pilistin maka bangsa Ammon, ");
INSERT INTO sml_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","ya angala'ug maka amissoko' ma tahun ina'an. Sangpū' ka waluntahun ya pamissoko' saga bangsa inān ma bangsa Isra'il ya pat'nna' ma lahat Giliyad. Ina'an sigām ma dambila' sapa' Jordan tampal ni sobangan, ma paglahat bangsa Ammon. ");
INSERT INTO sml_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Na, pauntas isāb saga sundalu bangsa Ammon ni dambila' sapa' Jordan tampal ni s'ddopan bo' magbono' maka bangsa Yuda, bangsa Benjamin maka bangsa Epra'im. Jari katiksa'an makalandu' in kamemon bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Pagka buwattē', parahing sigām ni PANGHŪꞋ-Yawe, yuk-i, “Bay kami makarusa ni ka'a. Bay kami pataikut min ka'a ya pagtuhanan kami bo' maghinang ni saga tuhan-tuhan Ba'al.” ");
INSERT INTO sml_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","Anambung PANGHŪꞋ, yukna, “Bay sa kam liyusanku min komkoman saga bangsa Misil, Amor, Ammon, Pilistin, ");
INSERT INTO sml_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","Sidun, Amalek maka Ma'on. Bay kam parahing ni aku mikitabang waktu kapamissoko' saga bangsa inān ma ka'am, ati talappas kam e'ku. ");
INSERT INTO sml_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Saguwā' minsan na, ilu na isāb kam pataikut min aku bo' maghinang ni saga tuhan-tuhan saddī, angkan mbal na aku bilahi angalappas ka'am pabīng. ");
INSERT INTO sml_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","Pehē' kam parahing ni saga tuhan-tuhan ya tapene'bi. Mikilappas kam ma sigām bang kam ma deyom kasigpitan!” ");
INSERT INTO sml_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Saguwā' anganjunjung na pa'in saga bangsa Isra'il ni PANGHŪꞋ, yuk-i, “Bay kami makarusa. Hinangun ai-ai ya patut kat'kkahan kami, saguwā', ndū', ma waktu itu lappasun kami.” ");
INSERT INTO sml_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Magtūy ni'bbahan e' bangsa Isra'il saga tuhan-tuhan bangsa liyu bo' angisbat si Yawe, ati mbal kasandalanna kasukkalan sigām. ");
INSERT INTO sml_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Na ma waktu inan, bay na pasakap ba'anan sundalu bangsa Ammon bo' magpustu ma Giliyad. Jari ina'an isāb bangsa Isra'il magtipun maka magpustu ma lahat Mispa. ");
INSERT INTO sml_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Sakali makapah'lling saga pagnakura'an a'a Giliyad, yuk-i, “Sai-sai makarahū amono' saga a'a Ammon, iya na ya magmakōk ma kamemon maglalahat ma Giliyad itu.” ");
INSERT INTO sml_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Na aniya' a'a Giliyad, ōnna si Jepta, dakayu' magbobono' landu' aesog. Mma'na si Giliyad, ina'na d'nda pinagtatambahan. ");
INSERT INTO sml_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Aniya' isab saga anak si Giliyad l'lla min h'ndana po'on. Jari asangpot pa'in saga kasehe'an anakna, tin'ggal e' sigām si Jepta. Yuk sigām ma iya, “Mbal ka makahampit pusaka' min matto'a kami, sabab anak ka min saddī ina'.” ");
INSERT INTO sml_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Angkan alahi si Jepta min saga danakanna bo' pat'nna' ma lahat Tōb, ati aniya' ba'anan a'a bula'ug-bula'ug bay pabeya' ma iya. ");
INSERT INTO sml_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Palabay pa'in waktu, pagka angandugpak na bangsa Ammon ni bangsa Isra'il, ");
INSERT INTO sml_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","pehē' saga pagmatto'ahan Giliyad ni lahat Tōb bo' angā' si Jepta. ");
INSERT INTO sml_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","Yuk sigām ma iya, “Dai' ka, ka'a ya magnakura'an kami bo' ka'atuhan bangsa Ammon.” ");
INSERT INTO sml_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Anambung si Jepta ni sigām, yukna, “Ngga'i bahā' ka'am ya bay ab'nsihan aku maka an'ggal aku min okoman mma'ku? Angay aku pangamu'anbi tabang buwattina'an pagka kam ma deyom kasigpitan na?” ");
INSERT INTO sml_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Jari makapah'lling ma iya saga pagmatto'ahan Giliyad, yuk-i, “Aho' b'nnal, sagō' itiya' kami angamu' tabang ni ka'a ma buwattina'an. Gapi'in kami bo' kitam maka'atu ma bangsa Ammon. Jari ka'a na ya magnakura'an kamemon saga maglalahat ma Giliyad.” ");
INSERT INTO sml_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Yuk sambung si Jepta, “Bang aku saupama bowabi angatuhan bangsa Ammon, bo' aku pinara'ug e' PANGHŪꞋ-Yawe, pagnakura'anbi to'ongan bahā' aku?” ");
INSERT INTO sml_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Yuk sambung saga pagmatto'ahan inān, “Si Yawe ya saksi'tam, beya' kami to'ongan bang ai panoho'annu.” ");
INSERT INTO sml_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Angkanna ameya' na si Jepta ma saga pagmatto'ahan Giliyad inān bo' tahinang pagmakōkan maka pagnakura'an sigām. Ma Mispa pa'in sigām, binalikan e' si Jepta ma matahan PANGHŪꞋ-Yawe kamemon bay pah'llingna ma saga a'a Giliyad. ");
INSERT INTO sml_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Pagubus, aniya' saga a'a sinoho' e' si Jepta amowa lapal ni sultan bangsa Ammon, yuk-i, “Ai po'on-sababna ya angkan dugpakbi lahat kami?” ");
INSERT INTO sml_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Yuk sambung sultan inān ni saga sosoho'an si Jepta, “Ma waktu bay kala'an bangsa Isra'il min lahat Misil, ta'agaw e' sigām tana'ku tinagna'an min sapa' Arnon ni sapa' Jabbok, sampay isāb ni bihing sapa' Jordan. Angkan yukku ma ka'am, pabalikunbi tana' inān ni aku ma halam palsagga'an.” ");
INSERT INTO sml_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Jari pinabīng pehē' saga sosoho'an si Jepta, sinō' amowa lapalna dakayu' itu ni sultan bangsa Ammon. ");
INSERT INTO sml_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","Yuk-i, “Ya itu pangallam si Jepta: In bangsa Isra'il halam bay angagaw tana' bangsa Mowab atawa bangsa Ammon. ");
INSERT INTO sml_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Ma waktu kala'an sigām min lahat Misil, in bangsa Isra'il bay at'kka ni Tahik Keyat labay min lahat paslangan, bo' pasampay isāb ni lahat Kades. ");
INSERT INTO sml_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Ma Kades pa'in, aniya' sosoho'an bay pinapehē' e' bangsa Isra'il ni sultan bangsa Edom ama'id min iya bang pa'in dūlanna sigām palabay min lahatna. Saguwā' halam sigām bay kinale e' sultan Edom e'. Damikiyanna isāb in sultan bangsa Mowab, mbal amarūl. Angkan bay pat'ttog saga a'a Isra'il ma Kades. ");
INSERT INTO sml_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","“Pagubus, pauntas na sigām minnē' labay min paslangan. Nilibut e' sigām lahat Edom maka bihing Mowab tampal ni sobangan. Ta'abut pa'in sapa' Arnon, magpustu sigām ma dambila'na. Halam sigām bay palintas pabalik ni dambila' sapa' bo' pasōd ni lahat Mowab. ");
INSERT INTO sml_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","Na, maina'an pa'in saga a'a Isra'il ma sapa' Arnon, aniya' saga sosoho'an pinapehē' e' sigām ni si Sihon ya sultan bangsa Amor. Hesbon ya lahat pagsultananna. Jari ama'id min iya saga sosoho'an bangsa Isra'il e', yuk-i, ‘Tuwan sultan, bang makajari, tugutin kami palabay min lahatbi tudju ni lahat kami.’ ");
INSERT INTO sml_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Sagō' mbal bilahi si Sihon sabab mbal angandol ma saga a'a Isra'il. Gom pa'in pinatimuk e'na ma lahat Jahas kamemon saga a'ana magbono' bo' angandugpak bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","Malaingkan si Yawe, ya pagtuhanan bangsa Isra'il, bay amara'ug sigām min si Sihon maka saga a'ana. Ta'agaw e' saga a'a Isra'il tana' saga a'a Amor ma lahat inān. ");
INSERT INTO sml_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Kalongkopan e' sigām tana' Amor kamemon, tinagna'an min sapa' Arnon sampay ni sapa' Jabbok, min lahat paslangan isāb sampay ni sapa' Jordan. ");
INSERT INTO sml_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","“Hatina,” yuk lapal si Jepta ni sultan Ammon, “si Yawe ya Tuhan bangsa Isra'il bay an'ggal bangsa Amor bo' pamuwanna lahat sigām ni saga a'a suku'na. Jari ai kapatutnu angā' tana' inān pabalik? ");
INSERT INTO sml_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","Dapuhunbi pila-pila ya pamuwan ka'am e' tuhanbi si Kemos. Damikiyanna kami itu, dapu kami ai-ai bay pamuwan kami e' si Yawe ya pagtuhanan kami. ");
INSERT INTO sml_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","Angay, paliyu lagi' bahā' ga'osannu min si Balak anak si Sippor, ya sultan Mowab? Aniya' bahā' bay palsagga'anna maka pagbono'anna maka bangsa Isra'il? ");
INSERT INTO sml_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Aniya' na t'llu hatus tahun ya t'ggol kat'nna' saga bangsa Isra'il ma Hesbon, ma Arower maka ma kaluma'an ma jadjahanna, beya' isāb saga kauman ma bihing sapa' Arnon. Angay halam bay bawi'bi paltana'anbi ma deyom t'llu hatus tahun e'? ");
INSERT INTO sml_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Halam aniya' kasā'anku ma ka'am, saguwā' ka'am ya makasā' ma aku ma pamowabi magbono'. Pasalassayta palkala' itu ma si Yawe ya Maghuhukum, ati iya ya amene' bang sai taga-kapatut, ka'am ka bangsa Ammon atawa kami bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Saguwā' in sultan Ammon mbal angasip ma lapal ya bay pinabeya'an iya e' si Jepta. ");
INSERT INTO sml_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Jari patongod Rū Yawe ma si Jepta ati pauntas iya min lahat Giliyad maka Manasse, bo' palabay isāb min Mispa-Giliyad. Palanjal iya minnē' bo' angatuhan bangsa Ammon. ");
INSERT INTO sml_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","Pagubus, anganajal si Jepta ni PANGHŪꞋ-Yawe, yukna, “Ya Tuhan, bang tugutannu in bangsa Ammon ni komkomanku, ");
INSERT INTO sml_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","ya itu pagnajalku, ‘Sai-sai paluwas dahū min luma'ku anampang bang aku amole' na min panganda'ugku min bangsa Ammon, pamasuku'ku du ni ka'a. Tunu'ku isāb pagkulban ni ka'a.’ ” ");
INSERT INTO sml_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Na, pehē' na si Jepta magbono' maka bangsa Ammon ati pinara'ug iya e' PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Taligis e' si Jepta duwampū' kauman ya paglahatan bangsa Ammon, tinagna'an min Arower sampay ni kasekotan lahat Minnit. Ta'abut isāb lahat Abel-Keramim, tara'ug e' bangsa Isra'il bangsa Ammon ati halam na ga'osan sigām. ");
INSERT INTO sml_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Na, makapole' pa'in si Jepta ni pat'nna'anna ma Mispa, anakna d'nda ya paluwas anampang iya, maka he'na angigal maka angandapu' tambul-tambulna. Anakna tunggalan ko' inān. Halam aniya' anak si Jepta saddī min iya, d'nda ka atawa l'lla. ");
INSERT INTO sml_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Pag'nda' pa'in si Jepta ma anakna itu, magtūy gese'na badju'na. Maglemong iya, yukna, “Allō! Anakku! Arung, asukkal aku ma pasalannu sabab aniya' najalku ni PANGHŪꞋ-Yawe mbal kapindahanku.” ");
INSERT INTO sml_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Ya sambung anakna, “Mma', pagka ka bay makajanji' ni si Yawe, hinangun ma aku buwat bay tanajalnu. Sabab bay ka pinara'ug e'na min bantanu bangsa Ammon. ");
INSERT INTO sml_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Na mma', aniya' sadja amu'ku ni ka'a, bang pa'in aku dūlannu angalunsulan kabūd-būran ma deyom duwambulan. Pehē' aku magdukka maka saga panonku d'nda sabab aku itu mbal na makapagh'lla.” ");
INSERT INTO sml_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Yuk si Jepta, “Aho' arūng, pehē' na ka.” Angkan pinasagaran iya ma deyom duwambulan. Magbeya' iya maka saga bagayna kabudjangan angalunsul ma kabūd-būran. Magdukka na pa'in sigām sabab mbal na iya makapagh'lla. ");
INSERT INTO sml_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Palabay pa'in duwambulan e', pabalik iya ni mma'na ati bineya' e' si Jepta bay najalna. Budjang lagi' iya. Ya itu po'on-sababan pangaddatan bangsa Isra'il itu: ");
INSERT INTO sml_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","tahun ni tahun in kabudjangan bangsa Isra'il maglunsulan ma deya ma deyom mpat llaw pangentoman sigām ma bay pat'kka ni anak si Jepta a'a min lahat Giliyad. ");
INSERT INTO sml_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","Na, pinatimuk e' panubu' si Epra'im saga a'a sigām magbobono' bo' pauntas tudju ni lahat Sapon. Aniya' lapal pinabeya' e' sigām ni si Jepta, yuk-i, “Angay ka halam bay mikitabang ma kami, waktu kapehē'bi magbono' maka bangsa Ammon? Tunu' kami luma'nu sampay ka'am magtautai'-anak.” ");
INSERT INTO sml_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","Ya sambung si Jepta, “Bay na kam palingananku tagna' kapagsagga' kami maka bangsa Ammon e', saguwā' halam kami bay gapi'bi angatu ma sigām. ");
INSERT INTO sml_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","Pagta'uku in ka'am mbal du anabang, bay panūkku ka'llumku angatuhan bangsa Ammon ma halam aniya' pagapi'. Ati min kahandak si Yawe bay aku anganda'ug. Jari angay gi' kam pi'itu buwattina'an amowa aku magbono'?” ");
INSERT INTO sml_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","Magtūy pinatimuk e' si Jepta saga a'a Giliyad bo' magbono' maka panubu' si Epra'im, ati anganda'ug disi Jepta. Minnē' kabalosan saga a'a Epra'im ma bay pagsambatan sigām, ya yuk-i, “Ē, ka'am saga a'a Giliyad, halam aniya' pūsbi, sapantun kam s'ggit tinimanan e' pagkahibi panubu' Epra'im maka Manasse.” ");
INSERT INTO sml_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","Kapagbaya'an e' a'a Giliyad kababawan sapa' Jordan, ya palabayan tudju ni lahat Epra'im. Jari bang aniya' a'a Epra'im bay min pagbono'an at'kka ni sapa' he', bo' mikipalintas parambila', tinilaw iya e' saga a'a Giliyad, yuk-i, “Panubu' si Epra'im ka bahā'?” Bang yukna “Ngga'i ka,” ");
INSERT INTO sml_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","na, sinulayan iya e' saga a'a Giliyad. Sinō' iya angabtang “Syibolet.” Sagō' bang a'a inān mbal makakabtang pabontol ati yukna “Sibolet,” magtūy iya sinaggaw e' a'a Giliyad bo' pinapatay ma atag sapa' Jordan. Mpatpū' ka duwangibu heka panubu' Epra'im ya bay tapapatay ma waktu pagbono' he'. ");
INSERT INTO sml_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","Nnom tahun ya t'ggol si Jepta magnakura'an bangsa Isra'il. Amatay pa'in iya, kinubul iya ma atag kaluma'anna ma lahat Giliyad. ");
INSERT INTO sml_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","Manjari, si Ibsan a'a Betlehem ya pasunu' magnakura'an bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","Taga-anak iya l'lla t'llumpū' puhu', maka t'llumpū' isab anakna d'nda. Pinah'lla'an e'na saga anakna d'nda ni panubu' saddī. Damikiyanna saga anakna l'lla, bay ningā'an d'nda min panubu' saddī pamah'nda sigām. Pituntahun ya t'ggol si Ibsan magnakura' ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","Amatay pa'in iya, kinubul iya ma Betlehem. ");
INSERT INTO sml_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","Si Elon panubu' Sibulun ya paganti' min si Ibsan magnakura' ma bangsa Isra'il. Sangpū' tahun ya t'ggol kapagnakura'na. ");
INSERT INTO sml_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","Amatay pa'in si Elon, kinubul iya ma Ayjalon ma lahat Sibulun. ");
INSERT INTO sml_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","Amatay pa'in si Elon, si Abdon anak si Hellel, a'a min Piratun, ya paganti' magnakura'an bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","Taga-anak iya l'lla mpatpū' hekana, maka mpu l'lla t'llumpū' hekana. In sigām pitumpū' puhu' itu bay ameya' pakaniya-pakaniya ma kura'. Waluntahun ya t'ggol kapagnakura' si Elon ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","Jari amatay pa'in iya, kinubul iya ma Piratun-Epra'im, ma kabūran ya paglahatan saga bangsa Amalek. ");
INSERT INTO sml_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Pabalik na isab saga a'a Isra'il maghinang kala'atan ya landu' asammal ma pang'nda' PANGHŪꞋ-Yawe, angkan sigām tugutanna ni komkoman bangsa Pilistin ma deyom mpatpū' tahun. ");
INSERT INTO sml_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Na, aniya' a'a Sora niōnan si Manowa, min panubu' si Dān. Taga-h'nda iya mbal maka'anak. ");
INSERT INTO sml_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Sakali magpa'nda' ni d'nda itu mala'ikat si Yawe bo' ah'lling, yukna, “Ka'a ilu, minsan ka halam bay maka'anak, angiram du ka bo' ka anganak l'lla. ");
INSERT INTO sml_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ya pangamay-ngamayku ma ka'a, da'a ka anginum binu atawa ai-ai makalango. Da'a ka amangan isab saga pagkakan ya mbal tahalal, ");
INSERT INTO sml_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","sabab angiram du ka maka anganak ka l'lla. Bu'unna ilu subay mbal ginuntingan sabab Nasiri iya, a'a pinasuku' ni Tuhan min llaw kapaganak ma iya. Tinagna'an e'na kapangalappas bangsa Isra'il min komkoman bangsa Pilistin.” ");
INSERT INTO sml_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Jari pehē' na d'nda angahaka ni h'llana, yuk-i, “Aniya' sosoho'an Tuhan bay magpa'nda' ni aku. Ya pangluwahanna sali' mala'ikat Tuhan, makatāw-tāw. Halam iya bay tatilawku bang m'nningga, maka halam iya bay angōnan di-na. ");
INSERT INTO sml_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Saguwā' ya llingna ma aku, ‘Angiram du ka maka anganak ka l'lla.’ Sinō' aku da'a anginum binu atawa ai-ai makalango, maka sinō' da'a amangan pagkakan mbal tahalal, sabab in onde' itu Nasiri, pinasaddī min kasehe'an bo' ma Tuhan sadja min llaw kapaganak ma iya sampay ni waktu kamatayna.” ");
INSERT INTO sml_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Sakali angamu'-ngamu' si Manowa ni PANGHŪꞋ, yukna, “Bang pa'in tugutannu a'a Tuhan pabīng pi'itu amandu'an kami supaya kami ata'u pasal pangayuput onde' ya song nianakan.” ");
INSERT INTO sml_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Na, kinale si Manowa e' Tuhan ati pabalik mala'ikatna bo' panyata' ni d'nda hinabuna maghinang ma huma. Sagō' halam maina'an h'llana, ");
INSERT INTO sml_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","angkan iya magdai'-dai' pehē' angahaka. Yukna, “Itiya' l'lla ya bay magpa'nda' ni aku llaw he'-i.” ");
INSERT INTO sml_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Pagubus, pabuhat si Manowa bo' paturul ni h'ndana. Pagsekotna pa'in ni a'a inān, yukna, “Ka'a bahā' ya bay amowa magbissala ma h'ndaku?” “Aho', aku,” yukna. ");
INSERT INTO sml_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Atilaw gi' si Manowa, yuk-i, “Bang atuman na ya pangallamnu, ai na pa'in saga hatulan panunuran kami ma onde' itu ma kapaga'ana?” ");
INSERT INTO sml_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Yuk sambung mala'ikat Yawe, “Subay bineya' kamemon ya bay pah'llingku ma h'ndanu. ");
INSERT INTO sml_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Subay iya mbal amangan ai-ai ta'ā' min tinanom anggul, subay mbal anginum binu atawa inuman ai-ai makalango, maka subay mbal amangan ai-ai ya mbal halal. Wajib bineya' e'na kamemon bay panoho'anku ma iya.” ");
INSERT INTO sml_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Yuk si Manowa ni mala'ikat, “Bang manjari, da'a gi' ka ala'an. Angadjal lagi' kami dakayu' anak kambing bo' aniya' kakannu.” ");
INSERT INTO sml_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Yuk sambung mala'ikat inān, “Minsan aku taggahanbi, mbal aku amangan pagkakanbi. Sagō' bang kam anakap pagkulban tinunu', na, tukbalinbi ni si Yawe.” (Halam tasayu e' si Manowa in a'a inān mala'ikat si Yawe.) ");
INSERT INTO sml_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Atilaw isab si Manowa ni mala'ikat, yukna, “Sai ōnnu? Sabab bilahi kami amaheya ka'a bang tatuman na ya bay pangallamnu ilu.” ");
INSERT INTO sml_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Yuk sambungna, “Angay tilawnu ōnku? Mbal to'ongan tahati e' manusiya'.” ");
INSERT INTO sml_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Pagubus, bay angā' si Manowa dakayu' anak kambing, beya' isab maka tutukbalan tirigu, ati sinumbali' e'na ma diyata' batu pangahulmatna ni PANGHŪꞋ-Yawe. Pataggaha', aniya' hinang makainu-inu tahinang e' PANGHŪꞋ sabu ang'nda' si Manowa maka h'ndana. ");
INSERT INTO sml_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Aniya' api pasuleyab min pagtutukbalan inān tudju ni diyata' langit. Pasalta', in mala'ikat si Yawe ameya' pa'angkat. Pag'nda' si Manowa maka h'nda, magtūy sigā pasujud. ");
INSERT INTO sml_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Pagka mala'ikat inān halam na magpa'nda' pabalik ni sigā maglakibini, minnē' tata'u e' si Manowa mala'ikat Yawe ko' inān. ");
INSERT INTO sml_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Ah'lling si Manowa ni h'ndana, yukna, “Amatay ko' kita itu, sabab ta'nda'ta Tuhan!” ");
INSERT INTO sml_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Saguwā' anambung h'ndana, “Bang bay aniya' niyat PANGHŪꞋ amapatay kita, mbal tinaima' tutukbalan susumbali'an maka tirigu ya bay ungsuranta ni iya. Mbal kita bay pina'nda'an saga pakaradja'an itu, maka mbal bay nihaka'an pasal maksudna.” ");
INSERT INTO sml_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Pagubus, in d'nda itu bay anganak l'lla, ati Samson ya pangōnna ma iya. Pasulig na pa'in onde' inān maka taptap binarakatan e' PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Anagna' isab Rū Yawe pahōp ma iya hinabuna ma kauman Mahane-Dān, ya ma llot Sora maka Esta'ol. ");
INSERT INTO sml_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Asangpot pa'in si Samson, pehē' iya ni kauman Timna ati aniya' budjang bangsa Pilistin ta'nda'na maina'an. ");
INSERT INTO sml_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Pagpole'na, angahaka iya ni ina'-mma'na, yukna, “Maka'nda' aku budjang Pilistin ma Timna. Pah'nda'unbi aku ma iya.” ");
INSERT INTO sml_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Yuk sambung matto'ana, “Angay, Otō'? Halam bahā' aniya' d'nda ahāp min kakampunganta atawa min pagkahitam bangsa Isra'il? Angay gi' ka subay magh'nda'an bangsa Pilistin, bangsa kapil lagi'?” Saguwā' angalogos si Samson ma mma'na, yuk-i, “Ngā'in aku, mma', sabab iya ya kabaya'anku.” ");
INSERT INTO sml_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","(Halam kinata'uwan e' matto'a si Samson in baya'na itu min kahandak si Yawe asal, supaya aniya' pagsababan pangatu bangsa Isra'il ma bangsa Pilistin, sabab saga Pilistin ya magparintahan bangsa Isra'il ma waktu ina'an.) ");
INSERT INTO sml_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Dakayu' llaw, pehē' si Samson ni Timna magbeya' maka ina'-mma'na. Sabu sigām pasekot ni pagtanoman anggul ma atag kauman inan, pataggaha' aniya' halimaw amanggohong parugpak ni si Samson. ");
INSERT INTO sml_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Manjari pahōp Rū Yawe ni si Samson amuwanan iya kosog, angkan tas'kkatna halimaw itu maka tanganna, buwat pan'kkatna kambing abata'. Saguwā' halam bay tahaka pakaradja'an itu ni mma'na atawa ina'na. ");
INSERT INTO sml_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Pagubus, palanjal iya ni Timna anuli-nulihan d'nda he', maka pasōng gom pa'in baya'na ma iya. ");
INSERT INTO sml_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Palabay pa'in daka pilang'llaw, pabalik na si Samson ni Timna bo' angawinan d'nda he'. Ma labayan lagi', pasiha' iya ang'nda' ni bangkay halimaw. Pag'nda'na, na, angulatap e' ba'anan buwani maka aniya' isab gula'. ");
INSERT INTO sml_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Niakup gula' itu e' si Samson bo' kinakan e'na ma pal'ngnganan. Binuwanan isab saga matto'ana, maka ya du sigā bay amangan. Saguwā' halam sigā bay haka'anna in gula' buwani inān bay ningā' min bangkay halimaw. ");
INSERT INTO sml_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Sakali itu, pehē' na mma' si Samson ni luma' d'nda. Aniya' isab paglami-lami pinaniya' e' si Samson sabab ya na addat sigām bang l'lla song kinawin. ");
INSERT INTO sml_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Pagt'kka si Samson, pinasehe'an iya t'llumpū' l'lla Pilistin. ");
INSERT INTO sml_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Yuk si Samson ni saga a'a itu, “Aniya' pamatokodku ma ka'am. Bang tatokodbi ma deyom pitung'llaw ya paglami-lami itu, buwananta kam t'llumpū' heka kakana' ahāp maka t'llumpū' pangampu'an s'mmek. ");
INSERT INTO sml_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Saguwā' bang mbal tatokodbi, ka'am ya subay amuwanan aku t'llumpū' heka kakana' ahāp maka t'llumpū' pangampu'an s'mmek.” “Na,” yuk sigām, “pē'un. Bilahi kami akale tokod-tokodnu ilu.” ");
INSERT INTO sml_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Ah'lling si Samson, yuk-i, “Min sattuwa magtatanggal, aniya' pagkakan. Min sattuwa akosog, aniya' kamamisan.” Jari halam tatokod e' saga a'a itu ma deyom t'llung'llaw. ");
INSERT INTO sml_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ta'abut pa'in ka'mpat llawna, ah'lling sigām ni h'nda si Samson, yuk-i, “Pipitin h'llanu angahaka'an kami pasal tokod-tokod ilu bang ai kataluwa'anna. Bang ka mbal, tunu' kami kam kamemon ya ma okoman mma'nu. Bay bahā' kami abbitbi pi'itu supaya langpasanbi?” ");
INSERT INTO sml_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Angkan pagapus h'nda si Samson ni iya maka e'na anangis. Yukna, “Kab'nsihannu na aku! Mbal aku kalasahannu. Bay ka amatokod ma saga kampungku sagō' halam aku haka'annu bang ai kataluwa'anna.” Yuk sambung si Samson, “Minsan matto'aku halam bay haka'anku, ya lagi'na bahā' ka'a?” ");
INSERT INTO sml_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Ati anangis h'nda si Samson animpus ma deyom pitung'llaw paglami-lami. Manjari, ta'abut llaw kapitu'na, nihaka'an iya pasal tokod-tokod inān sabab sinumu na pinogos si Samson. Angahaka isab d'nda inān ni saga kampungna pasal kataluwa'an tokod-tokod e'. ");
INSERT INTO sml_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Na, abay kohap pa'in ma llaw kapitu'na, ah'lling ni si Samson saga a'a kauman inān, yuk-i, “Aniya' bahā' paliyu mamisna min gula' buwani? Aniya' bahā' akosog min halimaw?” Ah'lling si Samson ni sigām magparalilan, “Bang halam bay gunabi sapi'ku d'nda pangararubi, mbal tatokodbi bay pamatokodku ma ka'am.” ");
INSERT INTO sml_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Jari pahōp Rū Yawe ma si Samson ati palūd iya ni da'ira Askelon amapatay saga kal'llahan t'llumpū' puhu'. Nihurusan e'na kapanyapan maka pan'mmek sigām bo' pamuwanna ma saga a'a ya bay makatokod he'. Magtūy iya amole' ni luma' mma'na ma masi akagit atayna. ");
INSERT INTO sml_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Ati in h'nda si Samson bay pamah'nda ma l'lla ya bay panonna ma pagkawinan. ");
INSERT INTO sml_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Mbal at'ggol, ta'abut pa'in musim pagani pai-tirigu, angā' si Samson dakayu' kambing abata' bo' pehē' patibaw ni h'ndana. Yukna ni mato'ana l'lla, “Pasōd gi' aku ni bilik h'ndaku.” Saguwā' mbal amarūl mma' d'nda he'. ");
INSERT INTO sml_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Yukna ni si Samson, “Pangannalku ab'nsi ka ma iya, angkan tapamah'ndaku ni bagaynu. Sagō' aniya' siyalina alingkat gi' min iya. Ngā'un iya h'nda.” ");
INSERT INTO sml_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Yuk si Samson ni sigām, “Na, aniya' na kapatutku amalos ma ka'am bangsa Pilistin. Tantu kam mulaku.” ");
INSERT INTO sml_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Jari paluwas iya minnē' anaggaw t'llu hatus heka ero' talun. Niengkotan e'na togel sigām pinaglingkit duwa. Pagubus, aniya' saga suwariyan binatuk e'na pehē' ni togel ero' bay pinaglingkit e'. ");
INSERT INTO sml_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Sinū'an e'na saga suwariyan inān bo' yampa pal'ppana saga ero' ni ba'anan pai-tirigu ya ma kahuma'an saga Pilistin. Jari tatunu' p'kkosan pai baha'u bay niani maka pai halam gi' ta'ani. Tatunu' saga pagtatanoman anggul maka kabbun kayu jaitun. ");
INSERT INTO sml_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Atilaw saga bangsa Pilistin, yuk-i, “Sai bay magkahinangan itu?” Kahaka'an sigām magtūy, yuk-i, “Si Samson ya ayuwan a'a Timna inān, ma sabab in h'ndana wa'i pamah'nda ni bagayna.” Angkan pehē' saga Pilistin anunu' sampay amapatay d'nda ya bay h'nda si Samson beya' maka mma'na. ");
INSERT INTO sml_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Jari ah'lling si Samson ni saga a'a bay anunu' he', yukna, “Pagga buwattē' hinangbi, mbal aku pahali sat'ggol kam mbal kabalosanku.” ");
INSERT INTO sml_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Minnē' magsabil si Samson bo' angalagut saga Pilistin inān ati aheka sigām amatay. Pagubus, palūd iya minna'an bo' pat'nna' ma deyom songab batu ya niōnan Etam. ");
INSERT INTO sml_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Manjari itu, pehē' saga a'a Pilistin magpustu ma lahat Yuda, bo' parugpak ni kauman Lehi. ");
INSERT INTO sml_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Tinilaw sigām e' saga a'a bangsa Yuda, yuk-i, “Angay kami bono'bi?” Ya sambung saga Pilistin, “Bay kami pi'itu anaggaw si Samson supaya iya kabalosan ma bay hinangna ma kami.” ");
INSERT INTO sml_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Manjari aniya' t'llungibu kal'llahan min bangsa Yuda pehē' ni songab batu Etam bo' ah'lling ni si Samson, yuk-i, “Halam bahā' kata'uwannu in kitam pinagbaya'an asal e' bangsa Pilistin? Tantu kitam binalosan ma sabab kala'atan ya tahinangnu he'.” Anambung si Samson, yukna, “Ya tahinangku ma sigām buwat bay hinang sigām ma aku.” ");
INSERT INTO sml_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Yuk saga a'a Yuda, “Ya maksud kami pi'itu, amaggotan ka'a bo' ka ni'nde'an ni komkoman saga a'a Pilistin.” “Ā,” yuk si Samson, “mikijanji' aku ma ka'am, bang pa'in aku mbal papataybi.” ");
INSERT INTO sml_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Yuk sambung sigām, “Na aho'. Hal ka saggaw kami ati ni'nde'an ni komkoman bangsa Pilistin. Mbal ka papatay kami.” Jari niengkotan iya maka duwa lubid baha'u bo' binowa patukad min songab batu. ");
INSERT INTO sml_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Asekot pa'in iya ni lahat Lehi, sinampang iya e' bangsa Pilistin maka he' sigām angolang. Sakali pahōp Rū Yawe ma si Samson amuwanan iya kosog. Ya lubid ma l'ngngonna tahinang sali' lanut bay pinasekot ni api, maka ya engkot ma tanganna magtūy ap'kkalan di-na. ");
INSERT INTO sml_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Pagubus, aniya' tapuwa'na bokog-langal min kura' baha'u bay amatay, ati ginuna e'na pamono' saga a'a Pilistin dangibu hekana. ");
INSERT INTO sml_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Jari angabtang si Samson, yukna, “Tapaggunaku bokog-langal kura' ati pabūd patay bantaku. Tapaggunaku bokog-langal kura' ati dangibu hekana bay papatayku.” ");
INSERT INTO sml_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Aubus pa'in pangabtangna, tinimanan e'na bokog-langal. Jari Ramat Lehi ya pangōn a'a ma lugal inān. ");
INSERT INTO sml_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Na, pagka sidda atoho' k'llong si Samson, pajunjung iya ni PANGHŪꞋ-Yawe, yukna, “Aheya da'ugan bay pamuwannu ma sosoho'annu itu. Pasagarannu bahā' aku patay bohe', bo' ta'ā' mayatku e' bangsa kapil itu?” ");
INSERT INTO sml_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Angkan aniya' bohe' pinatubud e' Tuhan min lowang ma tana' Lehi inān. Makainum pa'in si Samson, pabalik kosogna maka akuyas na iya. Angkan tuburan bohe' inān kaōnan En Hakkore. Ina'an masi sampay ni kabuwattituhan. ");
INSERT INTO sml_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Duwampū' tahun ya kapagnakura' si Samson ma bangsa Isra'il, ma waktu kapagbaya' saga bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Dakayu' llaw, pehē' si Samson ni da'ira Gasa. Aniya' d'nda pinagtambahan ta'nda'na maina'an, jari pahulid iya ni d'nda inān pagsangom. ");
INSERT INTO sml_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Na, kahaka'an saga a'a Gasa in si Samson ina'an ma deyom da'ira. Angkan sigām bay angalibutan lugal inān ati pajaga sigām ma lawang pagluwasan da'ira sampay ni karai'-llawan. Ya yuk sigām, “Papataytam iya pagk'llat llaw.” ");
INSERT INTO sml_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Saguwā' si Samson itu halam bay atuli pat'ggol. Papunduk iya tonga' bahangi bo' pehē' ni lawang da'ira. Binalutan e'na tambolna maka lusuk-lusukna maka batang-suladna, bo' nilarut e'na patighan. Pinatanggung ma bahana, ati binowa ni diyata' būd ya maganggop maka Hebron. ");
INSERT INTO sml_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Palabay pa'in daka pilang'llaw, pahōp baya' si Samson ma dakayu' d'nda ya pat'nna' ma kapantayan Sorek, niōnan si Delila. ");
INSERT INTO sml_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Pehē' ni si Delila saga pagnakura'an bangsa Pilistin, yuk-i, “Arung, bidjakin si Samson ilu bo' tahakana bang m'nningga pangā'anna kosogna landu' aheya. Jari ga'os kami iya bo' supaya kaengkotan pahāp maka kapagbaya'an kami na. Bang tahinangnu, tinambahan ka dangibu maka dahatus sekel dī pilak e' kami dangan-parangan.” ");
INSERT INTO sml_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Angkan ah'lling si Delila ni si Samson, yukna, “Haka'in kono' aku m'nningga pangā'annu kosognu landu' aheya ilu. Bang aniya' saupama bilahi magbabaya'an ka'a, buwattingga e' sigām anaggaw ka'a bo' ka kaengkotan?” ");
INSERT INTO sml_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Anambung si Samson, “Bang aku niengkotan maka pitu' engkot kuwit sapi' ya masi abase', in kosogku tahinang la'a buwat kosog-kosog kasehe'an kal'llahan.” ");
INSERT INTO sml_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Jari saga nakura' bangsa Pilistin inān bay amowahan si Delila pitu' engkot kuwit sapi' halam gi' bay pina'llawan. Ginuna magtūy e'na pangengkotna ma si Samson, ");
INSERT INTO sml_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","salta' aniya' saga l'lla patapuk ma deyom bilik e'. Nilinganan si Samson e' si Delila, yukna, “O Samson! Itiya' na saga Pilistin anaggaw ka'a!” Sagō' saru'un-du'un du ab'kkat e'na saga engkot inān, sali' kahantang bannang bay pinasekot ni api. Ya kaluwasanna, halam tata'u bang m'nningga kosog si Samson. ");
INSERT INTO sml_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ma waktu dakayu' ah'lling na isab si Delila ni si Samson, yuk-i, “Hal aku parupangnu sabab putingannu aku. Ndū', haka'in aku kono' bang buwattingga ka kaengkotan.” ");
INSERT INTO sml_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Anambung si Samson, “Bang aniya' makaengkotan aku maka lubid baha'u halam bay tapangengkot, in kosogku pinasali' ni kosog-kosog kasehe'an kal'llahan.” ");
INSERT INTO sml_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Angkan angā' lubid baha'u si Delila pangengkotna si Samson. Sakali itu, sabu aniya' saga a'a patapuk ma bilik, angalingan si Delila. “O Samson, itiya' na saga Pilistin anaggaw ka'a!” Sagō' ya du, ab'kkat e'na saga lubid ma l'ngngonna sali' salban. ");
INSERT INTO sml_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Jari yuk si Delila ni si Samson, “Sampay buwattina'an, masi aku parupangnu maka pagputingannu. Haka'in aku sab'nnal-b'nnal bang buwattingga ka kaengkotan?” Ya sambung si Samson, “Bang ta'anyamnu pitu' sapiran bu'unku ni kakana' masi ma papagan panganyaman, maka bang pahogotnu maka sisipit, in kosogku tahinang buwat kosog-kosog l'lla kasehe'an.” Jari itu, makatuli pa'in si Samson, niā' e' si Delila pitu' sapiran bu'unna bo' nianyam ni kakana'. ");
INSERT INTO sml_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Pinahogot isab maka sisipit. Angalingan pabalik si Delila, “O Samson!” yukna. “Itiya' na saga Pilistin anaggaw ka'a!” Magtūy pabungkal si Samson min pabahakanna ati nihella' e'na sisipit maka papagan panganyaman, sampay kakana'. ");
INSERT INTO sml_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Allā, magmahi si Delila ma si Samson, yukna, “Yuknu in aku kalasahannu, saguwā' mbal aku pangandolannu. Mint'llu na aku parupangnu, sabab halam aku pata'unu bang m'nningga ya pangā'annu kosognu aheya ilu.” ");
INSERT INTO sml_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Llaw ni llaw, buwattē' na pa'in pamogos si Delila sampay mbal na kasabalan e' si Samson. ");
INSERT INTO sml_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Angkan nihaka e'na bang m'nningga kosogna. Yukna, “Halam to'ongan bay kaguntingan bu'unku, sabab aku itu Nasiri, a'a bay tapanukbal ni Tuhan min waktu bay kapaganak ma aku. Bang kaguntingan bu'unku, tantu pahalam kosogku, ati tahinang la'a aku buwat kosog saga kasehe'an l'lla.” ");
INSERT INTO sml_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Na, tananam pa'in e' si Delila in pangahaka si Samson inān b'nnal, aniya' lapal pabeya'na ni pagnakura'an bangsa Pilistin, yuk-i, “Pabalik kam pi'itu min t'dda la'a, sabab tapangahakana kamemon ma aku.” Jari pabalik pehē' saga nakura' Pilistin maka e' sigām amowa pilak buwat bay janji' sigām. ");
INSERT INTO sml_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Tapatuli pa'in si Samson e' si Delila ma pa'ana, aniya' a'a soho'na angangguntingan kapitu' sapiran bu'un si Samson. Pagka buwattē', yampa tagaga e'na si Samson sabab pahalam na kosogna. ");
INSERT INTO sml_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Jari angolang si Delila, “O Samson, itiya' na saga Pilistin anaggaw ka'a!” Makabati' pa'in iya, pagbā'na dai'-dai' du iya makakuyas buwat bay tagna'. Saguwā' halam tata'una in PANGHŪꞋ bay na ala'an min iya. ");
INSERT INTO sml_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Sakali tasaggaw iya e' bangsa Pilistin ati nilugit matana bo' iya binowa ni Gasa. Niengkotan iya maka kili-kili tumbaga, ati pinagiling iya tirigu ma deyom kalabusu. ");
INSERT INTO sml_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Samantala' mahē' pa'in iya, inut-inut na pataha' bu'unna pabalik. ");
INSERT INTO sml_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Jari magtimuk na saga pagnakura'an bangsa Pilistin bo' angungsud tutukbalan ni tuhan-tuhan sigām si Dagon. Maglami-lami sigām maka e' sigām magsibahat, yuk-i, “Pinara'ug kitam e' tuhantam, tinugutan bantatam ni komkomantam.” ");
INSERT INTO sml_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Pag'nda' pa'in saga a'a Gasa inān ma si Samson, magtūy pinudji tuhan-tuhan sigām, yuk-i, “Pinara'ug kitam e' tuhantam, tinugutan ni ga'osantam ya a'a bay amaka'at lahattam, ya bay amapatay saga a'atam lipat-manglipat.” ");
INSERT INTO sml_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Jari itu, hinabu sigām maglami-lami maka maglangohan, angolang sigām, yuk-i, “Paluwasunbi pi'itu si Samson amalasig kitam.” Jari pinaluwas iya min deyom kalabusu ati nihinang paglasig-lasigan. Pagubus pinat'ngge iya ma atag saga hāg luma'. ");
INSERT INTO sml_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Pasalta', ah'lling si Samson ni sosoho'an ya anonda' iya, yukna, “Pasekotun lagi' aku ni hāg ya panuku luma' pagtata'atan itu bo' aku makasandig.” ");
INSERT INTO sml_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Na, aragsok asal luma' inān e' saga a'a l'lla-d'nda maka kamemon saga pagnakura'an bangsa Pilistin. Aniya' sigām saga t'llu ngibu puhu' ma karatagan atop inān ang'nda'-ng'nda' ma kahinangan si Samson. ");
INSERT INTO sml_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Jari angamu'-ngamu' iya ni PANGHŪꞋ, yukna, “O Yawe, Tuhan Sangat Kawasa, entomun aku. O Tuhan, pabalikun gi' kosogku minsan hal mint'dda. Bang pa'in aku makabalos saru'un-du'un ma saga Pilistin ma bay pangalugit sigām ma duwa mataku.” ");
INSERT INTO sml_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Magtūy ni'ntanan e' si Samson duwa hāg a'aslag ya panuku luma' pagtata'atan ni Dagon inān. Binalutan e'na karuwa, tanganna kowan ma dakayu' hāg, maka tanganna gibang isab ma dakayu'. ");
INSERT INTO sml_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Pagubus, anibahat si Samson, yukna, “Bang pa'in aku magunung amatay maka saga Pilistin itu!” Magtūy iya amuspusan kosogna bo' tinulak duwa hāg inān. Jari alubu luma' pagtata'atan e'. Talapay isāb ba'anan pagnakura'an Pilistin maka saga a'a bay maina'an. Minnē' aheka lagi' tapapatay e' si Samson ma kamatayna min bay tapapatayna ma waktu gi' kallumna. ");
INSERT INTO sml_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Jari palūd pina'an saga danakan si Samson l'lla maka saga kakampunganna min mma', bo' angā' patayna. Binowa iya amole' ni lahatna bo' kinubul ma bay pangubulan mma'na si Manowa, ya ma llot Sora maka Esta'ol. Duwampū' tahun ya t'ggol kapagnakura' si Samson ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","Ma waktu he', halam aniya' gi' magsultan ma bangsa Isra'il, ati ma waktu inān in panubu' Dān amiha lugal kapaglahatan e' sigām, sabab ma saga panubu' bangsa Isra'il panubu' Dān ya halam lagi' bay makataima' pusaka'. ");
INSERT INTO sml_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","Angkan in saga panubu' Dān bay amapehē' lima a'a aesog min Sora maka min Esta'ol amantingag palahatan bo' kapaglahatan e' sigām. Ya saga kal'llahan inān, ya ina'an sapantun magnakura' ma kamemon panubu' sigām. Ah'lling saga a'a inān ni sigām, “Pehē' na kam maglahat ma tana' he'.” In kal'llahan inān bay pehē' ni kaburan Epra'im ati makat'kka ni luma' si Mika maka mahē' sigām bay amalabay/amapuwas sangom. ");
INSERT INTO sml_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","Asekot pa'in sigām ni luma' si Mika, tabahingaw e' sigām in lagaw/suwala subul ya panubu' Lebi, angkan tinullus itu e' sigām bo' tinilaw, “Angay ka itiya' ma itu? Sai bay anoho' ka'a pi'itu? Ai hinangnu ma lugalnu?” ");
INSERT INTO sml_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","Angkan angahaka subul inān ni sigām ma pasal bay tahinang si Mika ma iya maka yukna, “Bay aku ningā' e'na magimam maka maghinang ma iya.” ");
INSERT INTO sml_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","Jari ah'lling ya kal'llahan inān ni iya, “Bang manjari panilawin lagi' ni Tuhan bo' supaya kinata'uwan bang aniya' kajatuhan kal'ngnganan kami.” ");
INSERT INTO sml_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","Ya sambung imam ni sigām, “Da'a kam maghawal-hawal pabeya' du Tuhan ma ka'am ni papehē'anbi/kal'ngngananbi.” ");
INSERT INTO sml_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","Puwas e' ala'an na ya lima puhu' kal'llahan inān ati makat'kka ni Laish. Tanda' e' sigām in saga a'a maina'an ahāp kat'nna' sigām, buwat saga bangsa Sidun halam aniya' anasaw sigām maka mbal a'anib. Ma sabab jukup in paglahat sigām, jayak-jayakan in kalluman sigām. Atā isab in paglahat sigām min pat'nna'an saga bangsa Sidun maka halam aniya' pasaumbibi saddī a'a min sigām. ");
INSERT INTO sml_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","Pagbalik pa'in sigām ni Sora maka ni Esta'ol, tinilaw sigām he' saga pagkahi sigām, “Na ai na pa'in bay ta'nda'bi?” ");
INSERT INTO sml_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","Anambung saga ya lima puhu' kal'llahan inān, “Bay kami maka'nda' lahat landu' ahāp. Da'a na kam magt'ggol-t'ggol, sūng na kam anakay sigām bo' ta'agawtam in lahat e'. ");
INSERT INTO sml_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","Bang kam makapehē' maka'nda' kam saga a'a ahāp maka lahat aluha halam aniya' kulang-kabusna ya pamasuku' ma ka'am e' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","Angkan ya nnom hatus kal'llahan min panubu' Dān ala'an min Sora maka Esta'ol bo' pehē' anakay. ");
INSERT INTO sml_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","Ma pagpehē' sigām, bay sigām amat'ngge pustu asekot ni Kiriyat Jerim ma Juda. Ya angkan in lugal inān bay niōnan Manahe Dān sampay ni kabuwattina'anan. ");
INSERT INTO sml_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","La'an minnē' bay sigām palanjal ni lahat ma kaburan Epra'im sampay sigām makat'kka ni luma' si Mika. ");
INSERT INTO sml_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","Manjari ya lima kal'llahan ya bay angamata-mata ma lahat Laish ah'lling ni saga sehe' sigām, “Kata'uwanbi ba dakayu' saga kaluma'an maitu taga-epod maka taga-tuhan-tuhan bay nilangkopan pilak? Ma buwattina'an, kata'uwanbi na bang ai hinangtam.” ");
INSERT INTO sml_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","Aubus pa'in sigām bay magpah'lling, pehē' na sigām ni pat'nna'an subul ya panubu' Lebi ma luma' si Mika supaya anganyata' iya. ");
INSERT INTO sml_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","Manjari ya nnom hatus saga panubu' Dān bay magsakap pakokos sigām pagbono' an'ngge ma atag lawang pagsosōran. ");
INSERT INTO sml_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","Ati lima puhu' kal'llahan ya bay angispiya ma lugal inān bay pasōd ni deyom angā' ta'u-ta'u, epod maka kasehe'an kapanyapan tuhan-tuhan maka isab tuhan-tuhan bay nilangkopan pilak, saguwā' in imam maka ya nnom hatus kal'llahan maka saga pakokos sigām pagbobono' wa'i an'ngge ma atag lawang pagsosōran. ");
INSERT INTO sml_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","Bay pa'in makasōd in saga kal'llahan inān ni deyom luma' si Mika angā' saga kapanyapan inān, tinilaw sigām e' imam, “Ai sa hinangbi ilu?” ");
INSERT INTO sml_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","Yuk sambung sigām ni imam inān, “Da'a ka asagaw! Ameya' ka ma kami, ati ka'a na ya pangaruhan kami maka imam kami. Bang ma ka'a ai ahāp, magimam ka ma panubu' Isra'il atawa magimam ka ma dakayu' luma' sadja?” ");
INSERT INTO sml_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","Manjari kasulutan in imam inān. Ningā' e'na in epod, kasehe'an saga kapanyapan tuhan-tuhan maka ta'u-ta'u ati ameya' na iya ma saga a'a inān. ");
INSERT INTO sml_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","Ma pagla'an sigām, bay pinarahū e' sigām in saga ka'anakan sigām, kahayopan maka saga pangalta' sigām. ");
INSERT INTO sml_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","Ma halam lagi' sigām makatā min luma' si Mika, bay pinalinganan e' si Mika ya saga kal'llahan pat'nna' ma atag luma'na supaya anurul panubu' Dān. ");
INSERT INTO sml_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","Ma pangolang sigām angalinganan panubu' Dān makabalik itu ah'lling ni si Mika, “Angay ka ilu, ya angkan kami turulnu maka saga a'anu?” ");
INSERT INTO sml_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","Yuk sambungna, “Bay ngā'bi ya saga tuhan-tuhan bay pahinangku maka in imamku ati ilu bay lahiyanbi. Ai lagi' takapin ma aku? Ati ta'u lagi' kam atilaw bang angay aku?” ");
INSERT INTO sml_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","Anambung saga panubu' Dan, “Da'a na ka anugat kami bo' ka mbal minula magtai'anak e' saga kasehe'an pagsehe' kami ya apasu' pagatay sigām.” ");
INSERT INTO sml_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","Angkan palanjal na pal'ngngan in saga panubu' Dān maka tatatab itu e' si Mika mbal itu ka'atuhan e' sigām, bay na hal sigām amole' pabalik. ");
INSERT INTO sml_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","Manjari bay ningā' e' sigām ya bay nihinang e' si Mika maka imamna ati bo' palanjal ni saga a'a ma Laish. Pagubus sinakay itu e' sigām binono' maka kalis bo' tinunu' in da'ira sigām. ");
INSERT INTO sml_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","Halam aniya' minsan dangan bay makatabang ma sigām sabab atā pat'nna'an sigām min Sidun maka halam aniya' saddī sehe' sigām magsaumbibi. In da'ira inān wa'i ma kapantayan asekot ni Bet-Rehob. Pagubus he' bay itu pinahāp pabalik e' saga panubu' Dān ati maina'an na sigām maglahat. ");
INSERT INTO sml_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","Manjari bay sinambi'an e' sigām ya ōn da'ira Laish ni ōn mbo' si Dān ya bay luwas min panubu' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","Pagubus maina'an pinat'ngge e' saga panubu' Dān ya saga tuhan-tuhan pagtuhanan sigām, ati si Jonatan ya anak si Gersom l'lla mpu si Musa maka saga panubu'na ya nihinang imam e' saga panubu' Dān sampay ta'abut waktu sinakay in paglahat inān. ");
INSERT INTO sml_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","Palanjal na pa'in sigām anumba saga tuhan-tuhan ya bay nihinang e' si Mika saguwā' in luma' pagsusumbahan ni Tuhan b'nnal wa'i ma Silo. ");
INSERT INTO sml_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","Ma waktu he' halam gi' aniya' sultan bangsa Isra'il. Manjari aniya' panubu' Lebi ya pat'nna' ma kareya-reyahan ma kaburan Epra'im bay makah'nda a'a Betlehem ya ma Juda. ");
INSERT INTO sml_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","Saguwā' in d'nda inān ala'at magh'lla. Bay ang'bbahan h'llana ati amole' pabalik ni luma' mma'na ma Betlehem ya ma Juda. Palabay mpat bulan t'ggolna mahē', ");
INSERT INTO sml_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","tinurul d'nda itu he' h'llana supaya binowa amole' pabalik. Angkan pehē' na l'lla inān magbeya' maka sosoho'anna amowa duwa kura' ariki'. Manjari makat'kka pa'in sigām pina'an binowa iya e' h'ndana ni luma' mma'na. Ati tanda' pa'in iya e' mma' h'ndana, tinaima' iya min kakōgan pangatayan mato'ana. ");
INSERT INTO sml_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","Manjari pinogos iya e' mato'ana l'lla mbal gi' iya pinapole', angkan maina'an na iya ma mato'ana amangan, anginum maka atuli ma deyom t'llung-llaw. ");
INSERT INTO sml_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","Ta'abut ika'mpat llaw, subu-subu gi' abati' na sigām magsakap bo' iya makapole' na. Saguwā' yuk mma' h'ndana ni ayuwanna l'lla, “Amangan gi' kam bo' yampa kam pehē'.” ");
INSERT INTO sml_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","Angkan aningkō' in duwangan inān bo' sigām magbeya' amangan maka anginum. Pagubus he' ah'lling na isab mma' d'nda inān, “Bang manjari maitu gi' kam ma sangom itu ati maglami-lami kitam.” ");
INSERT INTO sml_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","Sōng pa'in iya pabuhat amole', tinaggahan iya e' mat'oana angkan bay sigām patagga ma pat'nna' maina'an ma sangom inān. ");
INSERT INTO sml_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","Subu pa'in ma ikalima llaw na, abati' na l'lla inān supaya amole' na. Saguwā' yuk mma' d'nda inān, “Amangan gi' kam. Kohap na kam amole'.” Angkanna amangan na sigām karuwangan ");
INSERT INTO sml_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","Manjari ala'an pa'in l'lla inān magbeya' maka h'ndana maka isab sosoho'anna, ah'lling na isab in mato'ana ya mma' h'ndana, “Nda'un ba sōng na sangom. Mbal na at'ggol angal'ddom na. Maitu na kam amalabay sangom maka maglami-lami. Salung subu pak'llaw pa'in kam amole'.” ");
INSERT INTO sml_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","Saguwā' mbal na patagga l'lla inān amalabay sangom angkan ala'an sigām tudju ni Jebus (Awrusalam) magbeya' maka duwa h'ndana maka duwa kura'na ariki' taga-lampik ma bukut. ");
INSERT INTO sml_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","Abay kohap na sigām asekot ni Jebus, yuk sosoho'an ni nakura'na, “Guru, maitu na kitam pahanti' ma da'ira bangsa Jebus amalabay sangom.” ");
INSERT INTO sml_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","Yuk sambungna, “Da'a. Mbal manjari kitam pahanti' ma da'ira itu sabab ya saga a'ana ngga'ika bangsa Isra'il. Palanjal kitam ni Gibeya.” ");
INSERT INTO sml_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","Maka yukna lagi', “Dai' na ka. Anguttam to'ongan makat'kka ni Gibeya atawa ni Rama ati mahē' kitam pahanti' amalabay sangom.” ");
INSERT INTO sml_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","Angkan palanjal sigām pal'ngngan-l'ngngan ati asekot pa'in ni Gibeya ma Benjamin, pas'ddop na mata llaw. ");
INSERT INTO sml_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","Ati mahē' sigām bay amalabay sangom. Manjari pehē' sigām aningkō' ni halaman da'ira, saguwā' halam aniya' minsan dangan bay amaidda sigām ma sangom he'. ");
INSERT INTO sml_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","Ma sangom he' aniya' matto'a l'lla lūd bay min pagumahanna. Iya inān a'a bay min kaburan Epra'im ati ina'an na pat'nna' ma Gibeya (ya tana' panubu' Benjamin.) ");
INSERT INTO sml_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","Ta'nda' pa'in e'na ma halaman da'ira ya saga a'a liyu, tinilaw itu e' matto'a l'lla inān, “Pi'ingga kam ilu? Bay kam minningga?” ");
INSERT INTO sml_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","Yuk sambung panubu' Lebi, “Bay kami la'an min Betlehem ma Juda ati amole' na kami ni kareya-reyahan ya ma kaburan lahat Epra'im. Bay aku min Betlehem ma Juda ati ma buwattina'an amole' na aku ni luma' Tuhan. Halam aniya' minsan dangan bay amaidda kami.” ");
INSERT INTO sml_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","“Tuwan, kami itu aniya' du tinapay maka i'inuman kami maka h'ndaku beya'na in sosoho'anku. Damikiyanna aniya' isab pahampean kami maka batang parang ya pahampean saga kura' kami. Angkan halam aniya' kagunahan kami.” ");
INSERT INTO sml_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","“Manjari kam mahē' ma luma'ku.” Yuk matto'a inān. “Kajukupanku kam ma ai-ai kagunahanbi. Da'a sadja kam pahanti' amalabay sangom ma halaman itu.” ");
INSERT INTO sml_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","Angkan binowa na sigām e' matto'a inān ni luma'na ati in saga kura' sigām bay pinakan e'na. Aubus pa'in sigām bay angose'an tape' sigām, ina'an na pat'nna' kinakan maka inuman sigām. ");
INSERT INTO sml_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","Sabu sigām maglami-lami, aniya' saga a'a ala'at min da'ira inān angalibutan luma' sigām. Kinuku' in tambol e' saga a'a ala'at maka e' sigām angolang ni matto'a l'lla ya tag-dapu luma' inān, “Paluwasun ya a'a baha'u bay at'kka ni luma'nu ilu bo' kausiba'an kami.” ");
INSERT INTO sml_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","Paluwas min luma' in matto'a inān ati ah'lling ni sigām, “Da'a saga bagay. Da'a jahulaka'inbi pagga a'a itu bisitaku, da'a hinanginbi ya hinang ala'at ilu.” ");
INSERT INTO sml_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","“Bang kam bilahi itiya' anakku budjang maka h'nda l'lla itu. Bowaku sigām paluwas ni ka'am buwattina'an, hinangunbi na bang ai kabaya'anbi nihinang ma sigām. Saguwā' da'a hinanginbi ya hinang ala'at ilu ma l'lla itu.” ");
INSERT INTO sml_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","Saguwā' halam iya kinale e' saga kal'llahan inān. Angkan bay pinaluwas e' panubu' Lebi in h'ndana bo' ni'nde'an ni saga a'a inān. Pagubus, niusiba'an e' sigām ma deyom dansangom, ati pagdai'llaw pinapole' na e' sigām. ");
INSERT INTO sml_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","Manjari in d'nda inān amole' na pabalik ni luma' pat'nna'an h'llana ati mahē' iya ah'bba' ma bowa' lawang luma' maka pahagtang mahē' sampay ni ka'llawan. ");
INSERT INTO sml_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","Subu pa'in, pabuhat h'llana min patulian angukab lawang supaya palanjal na amole'. Ta'nda' e'na pahagtang h'ndana maina'an maka pa'abut gi' tanganna ni deyo' tambol. ");
INSERT INTO sml_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","Ati yukna ni h'ndana inān, “Punduk na ka, pal'ngngan na kita.” Saguwā' halam na anambung. Angkan niruwa' na e'na ni kura'na bo' binowa na amole'. ");
INSERT INTO sml_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","Pagt'kkana pa'in ni lahatna, angā' iya laring bo' kin'llot e'na ni sangpū' karuwa bahagi' ya lo'atan baran h'ndana. Pinabeya' itu e'na kamemon ni saga panubu' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","Sasuku bay maka'nda' itu makapah'lling, “Sat'ggol saga bangsa Isra'il bay makaluwas min Misil, halam lagi' aniya' bay tahinang atawa pat'kka buwattitu. Pagpikilinbi kono' itu! Nda'un kono' bo' kami haka'in bang ai hinangtam!” ");
INSERT INTO sml_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","Manjari kamemon bangsa Isra'il min lahat Dān sampay ni Be'erseba maka min lahat Giliyad magsakaum bo' magdakayu' ma Mispa ma matahan Tuhan. ");
INSERT INTO sml_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","In kamemon pagnakura'an ma sakahaba' panubu' bangsa Isra'il ina'an pasakaum ni saga ummat Tuhan. Saga mpat hatus ngibu heka sundalu maka saga kalis sigām. ");
INSERT INTO sml_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","(Takale e' saga panubu' Benjamin in saga bangsa Isra'il wa'i bay patukad ni Mispa.) Jari yuk saga bangsa Isra'il, “Buwattingga bahā' bay paniya' kala'atan itu?” ");
INSERT INTO sml_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","Angkan yuk panubu' Lebi ya bay h'lla d'nda bay pinapatay, “Aku maka h'ndaku bay pahapit ni Gibeya ya sakup panubu' Benjamin supaya pahanti' mahē' amalabay sangom. ");
INSERT INTO sml_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","Jari sangom pa'in, ya saga kal'llahan ma Gibeya bay pehē' angalibutan luma' pat'nna'anku arak amapatay aku. Saguwā' h'ndaku ya bay niusiba'an e' sigām jari amatay iya. ");
INSERT INTO sml_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","Angkan bay iya bowaku amole' ati bay pagpōng-pōngku baranna bo' bay pabeya'ku dag'llot-dag'llot ni pakaniya-kaniya panubu' bangsa Isra'il, sabab bay nihinang e' sigām ya hinang kala'atan makaiya'-iya' ma Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","Ma buwattina'an, ah'lling kam ka'am saga bangsa Isra'il bang ai ya ma pikilanbi.” ");
INSERT INTO sml_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","Sakali magdakayu' an'ngge kamemon in saga a'a bo' ah'lling, “Halam aniya' minsan dangan ma kitam amole'. Halam aniya' minsan dangan ma kitam amole' pabalik ni luma'na. ");
INSERT INTO sml_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","Na, ma buwattina'an, buwattitu ya hinangtam: Magko'ot-ko'ot kitam bang sai dahū anakay pehē' ni Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","Angā' kitam sangpū' kal'llahan min dahatus puhu' ma kamemon panubu' bangsa Isra'il, ati dahatus min dangibu maka dangibu isab min sangpū' ngibu puhu', bo' amatuntul ma saga pamalanja' ma sundalu. Ati bang makat'kka na in saga sundalu ni Gibeya ya sakup panubu' Benjamin, sigām ya makabuwan tungbas ma kamemon kala'atan bay tahinang e' panubu' Benjamin ma Isra'il.” ");
INSERT INTO sml_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","Angkan kamemon kal'llahan Isra'il bay magtimuk magdakayu' anakay da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","Ya saga panubu' Isra'il bay amapehē' kal'llahan ni kamemon panubu' Benjamin bo' ah'lling, “Ai sa hinang kala'atan ya bay tahinang e' panubu'bi itu? ");
INSERT INTO sml_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","Ma buwattina'an, nde'inbi ni kami ya kal'llahan Gibeya ya bay angahinang kala'atan itu supaya tapapatay kami ati tapahalam ma Isra'il ya kala'atan itu.” Saguwā' halam bay kinale e' panubu' Benjamin ya pagkahi sigām bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","Gom pa'in sigām bay magdakayu' bo' pehē' ni Gibeya supaya angatu magbono' ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","Ma waktu he'-i du magtimuk sigām duwampū' maka nnom ngibu kal'llahan maka saga kalis sigām, pangangganap ma pitu' hatus kal'llahan ya bay tapene' ma saga pat'nna' ma Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","Ma kamemon saga sundalu inān aniya' pitu' hatus kal'llahan bay tapene' ya sakap gibang ati pakaniya-kaniya ma sigām sidda atudju amitik/amantung minsan lambahan bu'un taluwa' he' sigām. ");
INSERT INTO sml_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","Ya saga bangsa Isra'il ngga'i ka beya' ma panubu' Benjamin aniya' saga mpat hatus ngibu kal'llahan ya maka kalis sigām sidda amanday amono'. ");
INSERT INTO sml_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","In saga bangsa Isra'il wa'i patukad ni Betel bo' supaya angaru ni Tuhan. Yuk sigām, “Sai sa ma kami ya parahū anakay ni panubu' Benjamin?” Ya sambung Tuhan, “Panubu' Juda ya parahū.” ");
INSERT INTO sml_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","Dakayu' llaw pagk'llat subu, in saga bangsa Isra'il wa'i pehē' magpustu asekot ni Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","Manjari ya kal'llahan bangsa Isra'il pehē' anakay ni panubu' Benjamin maka angahapa'an sigām patanam amono' ma Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","Pagubus sikaluwasan min Gibeya ya saga panubu' Benjamin ati duwampū' karuwa ngibu heka a'a bangsa Isra'il ya bay tapapatay e' sigām ma pagbono'an ma llaw he'-i. ");
INSERT INTO sml_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","Saguwā' ya saga bangsa Isra'il gom pa'in magmahogot pangatayan dangan maka dangan ati pabalik sigām ni atag bay pangahapa'an sigām dahū. ");
INSERT INTO sml_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","Manjari ya saga bangsa Isra'il patukad ni Betel ati anangis ni Tuhan sampay ni kasangoman maka atilaw sigām ni Tuhan. Yuk sigām, “Pabalik lagi' bahā' kami ni pagbono'an anakay saga panubu' Benjamin ya pagkahi kami?” Ya sambung Tuhan, “Pehē' kam pabalik anakay sigām.” ");
INSERT INTO sml_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","Ta'abut ikaruwa llawna, sinakay e' sigām pabalik ya saga panubu' Benjamin. ");
INSERT INTO sml_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","Ma waktu inān, paluwas na isab pabalik min Gibeya ya saga panubu' Benjamin supaya amāk sigām magbono', ati sangpū' kawalu' ngibu na isab tapapatay e' sigām ma saga bangsa Isra'il. Kamemon inān taga-kalis. ");
INSERT INTO sml_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","Sakali kamemon a'a panubu' bangsa Isra'il, wa'i patukad pabalik ni Betel ati mahē' sigām aningkō' anangis ni Tuhan. Ma llaw he' bay sigām amuwasa sampay ni kasangoman maka bay anukbal pagkulban maka angungsud tutukbalan pagheya sigām ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","Ati ya saga bangsa Isra'il bay angaru pabalik ni Tuhan. (Ma waktu he', ina'an gi' maina'an ya ba'ul Paljanji'an Tuhan. ");
INSERT INTO sml_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","Ati ya magnakura' inān si Pinehas anak si Eliyasar l'lla mpu si Harun.) Yuk patilaw sigām, “Pehē' lagi' ba kami pabalik anakay panubu' Benjamin ya pagkahi kami atawa mbal na?” Anambung Tuhan, “Pehē' kam, salung para'ugku sigām ma ka'am.” ");
INSERT INTO sml_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","Manjari ya saga bangsa Isra'il patapuk angahapa' ma katilibut Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","Ma ikat'llu llawna, pehē' na isab sigām anakay ni panubu' Benjamin maka angahapa' ma lugal bay pangahapa'an sigām ma Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","Ati paluwas na isab ya saga panubu' Benjamin amāk sigām magbono' sampay sigām tagege palawak min da'ira. Buwat du bay dahū, aniya' saga t'llumpū' puhu' bay tapapatay min saga bangsa Isra'il ma kareyahan maka ma saga labayan ya tudju ni Betel maka tudju ni Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","Pasuhut pa'in saga bangsa Isra'il, yuk saga panubu' Benjamin, “Tara'ugta na isab sigām buwat bay dahū.” Saguwā' halam tata'u sigām binowa sigām e' bangsa Isra'il patā min da'ira tudju ni saga labayan. ");
INSERT INTO sml_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","Kamemon bangsa Isra'il ya bay ala'an min lugal sigām bay magtimuk patanam ma Ba'al Tamar, ati ya saga kasehe'an bay ma tapukan ma lugal tampal ni s'ddopan ma Gibeya sikaluwasan na amono'. ");
INSERT INTO sml_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","Manjari saga sangpū' ngibu kal'llahan bangsa Isra'il ya bay pinene' to'ongan. Sigām ya bay paharap anakay Gibeya. Alanat pagbono' sigām, halam tapikil e' panubu' Benjamin in kala'atan inān sōng na pat'kka ni sigām. ");
INSERT INTO sml_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","Bay pinara'ug in bangsa Isra'il min panubu' Benjamin ati ma llaw he'-i du makapapatay sigām duwampū' kalima ngibu maka dahatus puhu' saga panubu' Benjamin ya taga-kalis kamemon. ");
INSERT INTO sml_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","Minnē' tananam e' panubu' Benjamin tara'ug na sigām. Ati in panubu' Benjamin bay na pamasagad e' kal'llahan bangsa Isra'il ma kasehe'an sigām ya bay angahapa' amono' ma atag Gibeya. ");
INSERT INTO sml_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","Manjari ya saga a'a bay angahapa' inān anakay na pehē' ni Gibeya bo' magkanat maka kalis sigām amapatay saga a'a ma katilibut da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","Aniya' bay paghati'an kal'llahan bangsa Isra'il maka sehe' sigām bay angahapa' inān. Subay sigām amat'bbud humbu akapal ma da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","Bo' supaya in kal'llahan Isra'il inān makabalik ni saga sehe' sigām ma pagbono'an. Ya saga panubu' Benjamin bay na isab makapapatay t'llumpū' puhu' ma saga bangsa Isra'il, maka yuk sigām, “Tara'ugta na isab sigām buwat bay pagbono' dahū.” ");
INSERT INTO sml_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","Saguwā' anagna' pa'in an'bbud pariyata' humbu alibombo' min Gibeya, makalingi' in panubu' Benjamin maka tanda' e' sigām aniya' humbu an'bbud pariyata' min katilibut da'ira inān. ");
INSERT INTO sml_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","Pagubus in saga kal'llahan Isra'il anakay na isab ni panubu' Benjamin, angkan tināw saga a'a inān sabab tapikil e' sigām in kala'atan inān pat'kka na ni sigām. ");
INSERT INTO sml_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","Angkan bay sigām ala'an min bangsa Isra'il tudju ni paslangan saguwā' halam sigām bay makalahi min pagbono'an. Ati ya saga kal'llahan bangsa Isra'il ya bay sikaluwasan min da'ira ya ina'an bay amapatay sigām mahē'. ");
INSERT INTO sml_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","Bay sigām nilibutan e' saga bangsa Isra'il tinurul na pa'in sampay sigām al'kkas tasaggaw ma katilibut Gibeya ya tampal ni sobangan. ");
INSERT INTO sml_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","Sangpū' kawalu' ngibu saga panubu' Benjamin ya tapapatay. Kamemon inān saga a'a aesog magbono'. ");
INSERT INTO sml_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","Ya saga kasehe'an sigām inān alahi na pa'in ni paslangan tudju ni Batu Rimun, saguwā' lima ngibu puhu' min sigām ya tapapatay e' bangsa Isra'il ma labayan. Masi na pa'in sigām tinurul e' ba'anan bangsa Isra'il sampay ta'abut ni Gidom maka makapapatay gi' sigām duwa ngibu puhu'. ");
INSERT INTO sml_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","Ma llaw he'-i du duwampū' kalima ngibu puhu' panubu' Benjamin ya bay tapapatay. Kamemon inān saga a'a aesog magbono'. ");
INSERT INTO sml_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","Saguwā' nnom hatus gi' min sigām inān ya bay makalahi ni paslangan tudju ni Batu Rimun ya na pat'nna'an sigām ma deyom mpat bulan. ");
INSERT INTO sml_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","Pagubus he' bay pabalik in kal'llahan Isra'il ni saga da'ira panubu' Benjamin maka pinapatay e' sigām ya saga bay takapin mahē' sampay na saga hayop maka kamemon kaginisan ya ta'nda' e' sigām. Kamemon da'ira bay kalabayan e' sigām bay pinagtunu'. ");
INSERT INTO sml_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","Mahē' ma Mispa ya saga kal'llahan bangsa Isra'il bay anapa anganjanji', “Halam aniya' ma sigām amah'lla'an anak sigām ni panubu' Benjamin.” ");
INSERT INTO sml_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","Puwas he' pehē' sigām ni Betel ati mahē' sigām aningkō' parahing anangis ni Tuhan sampay ni kasangoman. ");
INSERT INTO sml_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","Ya pangandahing sigām, “O Tuhan, ya Tuhan bangsa Isra'il, angay itu pat'kka ni bangsa kami? Ma buwattina'an, angay gi' subay aniya' dakayu' panubu' amutawan min bangsa Isra'il?” ");
INSERT INTO sml_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","Pagk'llat llaw in saga a'a inān angahinang pagtutukbalan ati maina'an pinat'nna' ya saga pagkulban maka huhulmatan pagdakayu' sigām. ");
INSERT INTO sml_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","Manjari in saga bangsa Isra'il magtilaw-tilawan di-sigām, “Sai ma saga bangsa Isra'il ya halam bay palamud ma pagdakayu'tam paharap ni Tuhan?” Sabab bay to'ongan kapagjanji'an e' sigām mahē' ma Mispa ma matahan Tuhan sasuku ya halam bay palamud ma pagdakayu' sigām subay to'ongan pinapatay. ");
INSERT INTO sml_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","Sakali magkarukka'an to'ongan in bangsa Isra'il ma pasal panubu' Benjamin ya pagkahi sigām. Ati yuk sigām, “Ma buwattina'an, dakayu' panubu' abutas min bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","Buwattingga kapah'nda'antam ya sasuku bay takapin panubu' Benjamin, sabab bay na to'ongan kitam makapagjanji' ni Tuhan mbal pamah'ndatam ni sigām ya saga ka'anakantam d'nda?” ");
INSERT INTO sml_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","Puwas he' magtilaw-tilawan di-sigām, “Sai min saga panubu' bangsa Isra'il ya halam bay makalamud ma pagdakayu'tam ni Tuhan ma Mispa?” Sakali tata'u e' sigām halam aniya' minsan dakayu' min panubu' Jabes-Giliyad bay pehē' ni pustu palamud ma pagdakayu' sigām. ");
INSERT INTO sml_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","Sabab ma waktu sigām magitung saga a'a, tata'u e' sigām halam aniya' maina'an minsan dangan min panubu' Jabes-Giliyad. ");
INSERT INTO sml_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","Angkan ya tumpukan sigām inān bay amapehē' sangpū' karuwa ngibu kal'llahan aesog magbono' ya bay tasoho' pehē' ni Jabes-Giliyad amapatay saga a'a pat'nna' mahē' beya' na saga kar'ndahan maka saga kaonde'-onde'an. ");
INSERT INTO sml_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","Yuk sigām, “Buwattitu ya hinangunbi. Papatayunbi saga a'a l'lla-d'nda liyu sadja min saga budjang.” ");
INSERT INTO sml_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","Puwas he' makapiha sigām mahē' mpat hatus kabudjangan ya halam lagi' bay makapagdakayu' maka l'lla, ati binowa itu e' sigām ni pustu ma Silo ya ma Kana'an. ");
INSERT INTO sml_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","Manjari ya saga tumpukan bangsa Isra'il bay amabeya' lapal pagsulutan ni panubu' Benjamin ma batu Rimun. ");
INSERT INTO sml_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","Angkan ma waktu he' magpole'an na pabalik ya saga panubu' Benjamin ati bay sigām binuwanan kabudjangan panubu' Jabes-Giliyad ya bay tabowa e' bangsa Isra'il. Saguwā' kulang gi' itu ma sigām. ");
INSERT INTO sml_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","Magkarukka'an to'ongan ya saga bangsa Isra'il ma pasal panubu' Benjamin ma sabab min kahandak Tuhan angkan halam na magdakayu' ya saga panubu' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","Ati yuk saga pagmatto'ahan ma tumpukan, “Ma pasal magpatayan na ya saga kar'ndahan panubu' Benjamin, buwattingga kapamah'ndatam saga kal'llahan panubu' Benjamin ya bay takapin?” ");
INSERT INTO sml_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","Maka yuk sigām lagi', “Ya saga bay takapin allum inān subay taga-kapatut bo' mbal alungay panubu' sigām min bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","Mbal manjari tapamah'ndatam ni sigām saga ka'anakantam sabab kitam bangsa Isra'il bay to'ongan makajanji', ‘Minulka'an sai-sai amah'lla'an anak sigām ni panubu' Benjamin.’ ” ");
INSERT INTO sml_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","Saguwā' tapikil e' sigām, “Sōng na tahun haylaya paglami-lami ni Tuhan ma Silo ya tampal ni diyata'an Betel min deyo'an Lebona maka tampal ni sobangan labayan min Betel tudju ni Sekem.” ");
INSERT INTO sml_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","Angkan pinandu'an e' sigām ya saga panubu' Benjamin, “Pehē' kam patapuk ni pagtanoman anggul, ");
INSERT INTO sml_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","ati jagahinbi bang palabay na ya saga kar'ndahan Silo supaya palamud amayla, saggawunbi na min pagtanoman anggul ati dangan maka dangan min ka'am angā' na kam min sigām hinangbi h'nda ati bowahunbi na ni lahatbi panubu' Benjamin. ");
INSERT INTO sml_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","Bang magpuhun ni kami saga ka'mma'an sigām atawa saga danakan sigām l'lla, ah'lling kami ni sigām, ‘Angampun pa'in kam. Pasagarinbi na sigām sabab kulang saga kar'ndahan bay ta'ā'tam ma waktu bay pagbono'. A'awam kam sabab halam bay pamah'ndabi ma sigām ya saga ka'anakanbi d'nda.’ ” ");
INSERT INTO sml_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","Angkan buwattē' ya bay nihinang e' panubu' Benjamin. Ma sabu magpamayla ya saga kar'ndahan inān, dangan-parangan l'lla anaggaw dakayu' d'nda bo' binowa amole' ningā' h'nda e' sigā. Ati pabalik na sigā ni tana' sigām bo' binangun pabalik ya saga da'ira sigām ati mahē' na pat'nna'. ");
INSERT INTO sml_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","Sakali ala'an na minnē' ya saga bangsa Isra'il bo' amole' na pabalik ni saga panubu' maka kakampungan sigām pakaniya-kaniya paglahat sigām. ");
INSERT INTO sml_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Ma waktu he', halam gi' bay aniya' magsultan ma Isra'il. Dangan-parangan ma sigām makahinang ma ai kabaya'an sigām.");
INSERT INTO sml_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ma waktu pa'in aniya' maghuhukum analassay palkala' ma bangsa Isra'il, bay ginotom lahat sigām. Manjari aniya' dakayu' l'lla min kauman Betlehem magbeya' maka h'ndana maka duwa anakna l'lla bay papinda ni lahat Mowab. ");
INSERT INTO sml_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ya ōn l'lla itu si Elemelek, h'ndana si Naomi, ōn duwangan anakna inān si Mahalon maka si Kiliyon. Sigām itu tumpuk Eprat min kauman Betlehem ma lahat Yuda. Bay sigām papinda ni lahat Mowab bo' mahē' maglahat. ");
INSERT INTO sml_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Na, at'ggol-t'ggol pa'in sigām maina'an, amatay si Elemelek ya h'lla si Naomi, ati si Naomi la'a maka karuwangan anakna tabba. ");
INSERT INTO sml_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Makah'nda duwangan anakna inān ni d'nda bangsa Mowab, ya ōn sigām si Orpa maka si Rūt. Palabay pa'in sangpū' tahun, ");
INSERT INTO sml_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","amatay isab disi Mahalon maka si Kiliyon, jari si Naomi la'a takapin pagka amatay na anak-h'llana. ");
INSERT INTO sml_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Masi gi' sigām ma lahat Mowab, kahaka'an si Naomi pasal saga a'a ma lahatna porol, aheka kono' pagkakan sigām ma sabab kaheya tabang PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Manjari, ala'an na sigām min lahat bay pat'nna'an sigām inān bo' pabīng ni Yuda ya lahatna. ");
INSERT INTO sml_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ma pal'ngnganan pa'in, ah'lling si Naomi ni saga ayuwanna inān, yukna, “Saga dayang, amole' na kam pabalik ni saga matto'abi. Mura-murahan bang pa'in kam binuwanan kahāpan e' PANGHŪꞋ buwat kahāpan bay tahinangbi ma aku maka saga kah'lla'anbi he'. ");
INSERT INTO sml_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Bang pa'in kam isab nirūlan e'na makapagh'lla maka kaniya'an kam kahāpan ma deyoman sigām.” Jari, siniyum e' si Naomi saga ayuwanna ati anangis to'ongan duwangan itu ");
INSERT INTO sml_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","maka he' sigām ah'lling ni iya, yuk-i, “Ameya' na kami pabīng ma ka'a ni saga kampungnu.” ");
INSERT INTO sml_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Saguwā' anambung si Naomi, yukna, “Saga dayang, magpamole' na kam. Angay kam subay ameya' ma aku? Mbal na aku makabāk anak tapamah'llaku ma ka'am pabīng. ");
INSERT INTO sml_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Pehē' na kam,” yukna, “aku itu ato'a na. Mbal na aku makah'lla. Maka minsan isab aniya' h'llaku pahulid ni aku sangom ilu bo' aku maka'anak pabalik, ");
INSERT INTO sml_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","makalagad bahā' kam sampay sigām ta'abut asubul? Tantu mbal na. Gom gi' ka'am ilu saga dayang, da'a na buwat aku itu sabab ahunit landu' ya bay pamat'kka e' PANGHŪꞋ ma aku.” ");
INSERT INTO sml_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ma pasal pamissala si Naomi he', anangis sigām pabīng. Jari pasiyum maka ama'id na si Orpa, sagō' si Rūt paunung ma mato'ana. ");
INSERT INTO sml_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Yuk si Naomi, “O'o, nda'un ba, bilasnu ilu amole' na ni saga matto'ana maka ni pagtuhananna. Na, pehē' na ka ameya' ma iya.” ");
INSERT INTO sml_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Sagō' ya sambung si Rūt, “Da'a aku pogosun ang'bba atawa anaikutan ka'a. Pi'ingga-pi'ingga ka ameya' aku. Maingga-maingga pat'nna'annu mahē' isab aku. In bangsanu ya na bangsaku, jari in Tuhannu ya na pagtuhananku. ");
INSERT INTO sml_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Bang ka maingga amatay, mahē' du isab aku amatay maka kinubul. Bang pa'in aku minulka'an he' PANGHŪꞋ bang aku pa'bba min ka'a. Luwal la'a bang kamatay ya makapagbutas ma kita.” ");
INSERT INTO sml_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Tasayu pa'in e' si Naomi lilla' ameya' ma iya si Rūt, pahali na iya amogos. ");
INSERT INTO sml_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Puwas pa'in he'-i, palanjal na sigām karuwangan sampay sigām makat'kka ni Betlehem. Pag'nda' ma sigām, takuddat saga a'a ma kauman inān. Jari ah'lling saga kar'ndahan maina'an, yuk-i, “Si Naomi na bahā' ilu?” ");
INSERT INTO sml_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Sagō' yuk si Naomi ni sigām, “Da'a na aku ōninbi maka ōnku, sagō' ōninbi na aku Mara sabab bay aku pinat'kkahan e' PANGHŪꞋ kasukkalan mbal tapula'-pula'. ");
INSERT INTO sml_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Waktu bay kala'anku minnitu jukup-jukupan gi' aku, sagō' bay aku pinabalik he' PANGHŪꞋ pi'itu ma halam na aniya' ai-aiku. Angkan da'a na aku ōninbi Naomi sabab bay aku pinat'kkahan kasukkalan maka kulang-kabus he' PANGHŪꞋ Sangat Kawasa.” ");
INSERT INTO sml_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Jari makabalik si Naomi maka ayuwanna si Rūt min Mowab. At'kka sigām ni Betlehem ma timpu yampa anagna' pagani. ");
INSERT INTO sml_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Manjari, aniya' l'lla pinagōnan si Bowas, a'a taga-kaniya' maka ga'osan. Min tumpuk si Elemelek iya, pamikitan si Naomi min h'llana. ");
INSERT INTO sml_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Dakayu' llaw, ah'lling si Rūt ni si Naomi, yukna, “Babu', papehē'un gi' aku ni huma amuwa' kapin bay paganihan ma sai-sai ya bilahi pameya'anku.” Anambung si Naomi, yukna, “Aho', pehē' ka, dayang.” ");
INSERT INTO sml_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Jari lum'ngngan na si Rūt ni huma paturul min buli'an saga a'a maga'ani inān amuwa' kapin bay paganihan he'. In tag-dapu huma inān ya na si Bowas kampung si Elemelek. ");
INSERT INTO sml_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ma waktu ina'an-i, at'kka si Bowas bay min Betlehem ati sinagina e'na saga a'a maga'ani he', yukna, “Owa'! Bang pa'in PANGHŪꞋ pabeya' ma ka'am!” Yuk isab sambung saga a'a inān, “Bang pa'in ka binarakatan e' PANGHŪꞋ!” ");
INSERT INTO sml_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Jari atilaw si Bowas ni kapatas saga maga'ani yukna, “Sai sa d'nda inān?” ");
INSERT INTO sml_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Anambung kapatas itu, yukna, “D'nda ilu a'a bangsa Mowab bay ameya' pi'itu ma si Naomi min lahat Mowab. ");
INSERT INTO sml_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Bay iya ama'id min aku bang kono' iya makajari paturul min buli'an saga maga'ani amuwa' kapin bay paganihan he'. Min abay subu lagi' kapaghinangna ilu. Ya du halianna ilu pasindung dai'-dai'.” ");
INSERT INTO sml_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Jari ah'lling si Bowas ni si Rūt yukna, “Arung, akale ka pahāp. Da'a na ka paliyu amuwa' ni huma saddī. Maitu na sadja ka magbeya' maka saga sosoho'anku kar'ndahan itu. ");
INSERT INTO sml_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nda'un bang maingga paganihan saga a'aku ati pasambeya' ka ma saga kar'ndahan ilu. Bay na banda'anku saga kal'llahan maitu soho'ku ka da'a ni'inay ma sigām. Bang ka patay-bohe', pehē' pa'in ka angā' min kibut bay ni'isihan e' saga kal'llahan e'.” ");
INSERT INTO sml_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Pagka buwattē' ya bissala si Bowas, magtūy pasujud si Rūt ni tana' ati ah'lling, yukna, “Tuwan, angay aku pahalga'nu? Aku itu dakayu' sadja a'a liyu.” ");
INSERT INTO sml_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Sagō' anambung si Bowas yukna, “Bay aku kahaka'an ma pasal kahāpan bay tahinangnu ma mato'anu min bay gi' kamatay h'llanu. Bay kono' bbahannu ina'-mma'nu sampay lahatnu ati itu ka ameya' pat'nna' ma lahat halam bay kata'uwannu. ");
INSERT INTO sml_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Bang pa'in ka nilidjiki'an he' PANGHŪꞋ Sangat Kawasa ma bay tahinangnu ilu. Bang pa'in ka tinungbasan manglabi-labihan he' PANGHŪꞋ bangsa Isra'il, ya sapantun pikpik manuk pasindungannu.” ");
INSERT INTO sml_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Yuk sambung si Rūt, “Bang pa'in aku taptap makasulut pangatayannu, tuwan. Bay aluknu pangatayanku sabab kahāp sin saga bissalanu ilu minsan aku mbal makasibu' ni d'nda sosoho'annu.” ");
INSERT INTO sml_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ta'abut pa'in waktu pagkakan, nilinganan si Rūt he' si Bowas, “Pi'itu ka,” yukna, “pasalu ka ma kami amangan tinapay bo' bahugun ni suka' binu-anggul itu.” Maina'an pa'in ma pagkakanan, nilabot si Rūt e' si Bowas maka pai sinanglag. Jari amangan iya pahāp sampay asso maka aniya' gi' takapin. ");
INSERT INTO sml_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Bay pa'in he'-i, an'ngge na iya bo' pabalik ni paghinanganna. Ah'lling si Bowas ni saga sosoho'anna yukna, “Amay-amay, da'a iya lāngunbi minsan iya amuwa' ma tongod saga p'kkosan. ");
INSERT INTO sml_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Gom pa'in ngā'inbi iya min p'kkosan he' bo' pat'nna'unbi ma pamuwa'anna. Dūlinbi sadja iya.” ");
INSERT INTO sml_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Angkan mahē' na pa'in si Rūt ma huma sampay ni kasangoman. Pagt'ppana saga buwa' pai-tirigu bay tapuwa'na he', magbuhat saga sangpū' gantang. ");
INSERT INTO sml_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Manjari binowa e'na amole' ati ta'nda' e' mato'ana bang pila heka bay tatimukna. Sinōngan isab e'na ni mato'ana ya labi min bay pamangananna he'. ");
INSERT INTO sml_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Sakali tinilaw iya e' mato'ana, yuk-i, “Maingga ka bay amuwa' llaw ilu? Sai tag-dapu huma bay paghinangannu? Bang pa'in aheya kahāpan ma a'a bay amaidda ka'a ilu.” Jari nihaka e' si Rūt ma si Naomi pasalan ya tag-dapu lugal bay paghinanganna he'. “Si Bowas,” yukna, “ya ōn a'a bay paghinanganku llaw itu.” ");
INSERT INTO sml_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","“PANGHŪꞋ magbarakat ma si Bowas,” yuk si Naomi. “Halam pahali kahāpanna ma saga allum maka ma saga wa'i na magpatayan.” Ah'lling gi' si Naomi, yukna, “Ya l'lla ōnannu ilu kampungtam du. Ya ilu taga-kapatut anabangan kita.” ");
INSERT INTO sml_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ah'lling gi' si Rūt, “Bay isab iya ah'lling ma aku sinoho' gi' aku ameya' ma saga sosoho'anna sampay sigām aubus magani.” ");
INSERT INTO sml_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Yuk si Naomi ni si Rūt, “Ahāp ko' he' bang ka mahē' ma humana magbeya' maka saga sosoho'anna kar'ndahan. Sabab bang a'a saddī ya pameya'annu, aniya' arai' angala'at ka'a.” ");
INSERT INTO sml_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Jari mahē' na si Rūt maka saga sosoho'an si Bowas kar'ndahan sampay aubus musim pagani. Sagō' masi iya pat'nna' ma mato'ana. ");
INSERT INTO sml_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Dakayu' llaw ah'lling si Naomi ni si Rūt, “Dayang,” yukna, “piha'anta ka pat'nna'an atotog bo' aniya' magnapaka ma ka'a. ");
INSERT INTO sml_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kampungta asal si Bowas, ya tag-dapu huma bay paghinangan saga kar'ndahan bay pameya'annu he'. Sangom itu, pehē' iya ni tongod pagt'ppahan bo' magtahap saga bay niani he'. ");
INSERT INTO sml_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Amandi ka bo' ka amahamut di-nu. Jari sulugun badju'nu ahāp to'ongan bo' ka pehē' ni pagt'ppahan. Da'a iya pata'uhun in ka'a wa'i mahē', subay na iya aubus amangan maka anginum. ");
INSERT INTO sml_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Bang iya makalege na, gindanin bang ma atag ingga palegehanna. Jari pehē' ka, laisun mantana bo' ka abahak ma tape'anna. Nihaka'an du ka e'na bang ai subay hinangnu.” ");
INSERT INTO sml_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Anambung si Rūt yukna, “Beya'ku kamemon panoho'annu ilu, babu'.” ");
INSERT INTO sml_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Manjari bineya' he' si Rūt panoho'an mato'ana ati pehē' na iya ni tongod pagt'ppahan. ");
INSERT INTO sml_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Aubus pa'in bay amangan maka anginum si Bowas bo' hinabu ahāp palasahanna, pabahak iya ma tongod pagtau'an pai. Jari tatuli pa'in iya, pasekot pina'an si Rūt kamaya'-maya' bo' nilais manta min tape' si Bowas ati palege iya ma tape'an. ");
INSERT INTO sml_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Alalom pa'in bahangi, takuddat si Bowas angkan iya makahimuya, maka aniya' d'nda tasayuna palege ma atag tape'na. ");
INSERT INTO sml_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Sai sa ka'a ilu?” yukna. Anambung si Rūt, “Aku itu si Rūt, ya sosoho'annu,” yukna. “Pagka ka'a ilu kampung kami taga-kapatut, b'llatun gi' tōng mantanu ma aku.” ");
INSERT INTO sml_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","“Mura-murahan bang pa'in ka nilidjiki'an e' PANGHŪꞋ, dayang,” yuk si Bowas. “Ya kahāpan tahinangnu buwattina'an aheya gi' min bay tahinangnu dahū. Halam ka bay sinōd baya' ma kal'llahan abata', ai-na ka miskin atawa dayahan. ");
INSERT INTO sml_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Angkan buwattina'an, da'a na ka asusa sabab beya'ku kamemon pangamu'nu. Makata'u du isab kamemon lūng-kampungnu in ka'a ilu d'nda abontol. ");
INSERT INTO sml_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","B'nnal ya yuknu ilu, in aku dakayu' kampungnu taga-kapatut anabangan ka'a, sagō' aniya' gi' kampungnu labi aga'os min aku. ");
INSERT INTO sml_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Maitu na ka atuli sangom itu. Salung subu, pehē'ku a'a he', kalu niakuhan e'na amah'nda ka'a. Bang hati' iya angaku, ahāp. Sagō' bang mbal, na saksi'ta PANGHŪꞋ ya allum salama-lama in aku itu angakuhan ka'a du. Maitu na ka atuli.” ");
INSERT INTO sml_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Manjari palege na si Rūt maina'an sampay ni kasubuhan. Pagdai' llaw pabangun na iya ma halam lagi' aniya' makasayuhan iya. Yuk si Bowas ma saga a'ana, “Da'a kam amata'u ni sai-na saga aniya' d'nda bay makapi'itu ni pagt'ppahan.” ");
INSERT INTO sml_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ah'lling lagi' si Bowas, yukna, “Bowahun pi'itu se'ob ma barannu ilu bo' b'llatun maitu.” Pagb'llat pa'in se'ob inān, tin'ppongan iya nnom gantang pai-tirigu bay tin'ppa bo' pinadurung ma iya. Jari amole' na pabīng si Bowas ni kaumanna. ");
INSERT INTO sml_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Makapole' pa'in si Rūt, tinilaw iya e' mato'ana, yuk-i, “Buwattingga du, dayang?” Sinuli-sulihan e' si Rūt mato'ana bang ai bay tahinang e' si Bowas ma iya. ");
INSERT INTO sml_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Maka yukna gi' isab, “Bay aku binuwanan nnom gantang pai-tirigu e' si Bowas, sabab bang ma iya, sinoho' aku mbal amole' bang halam aniya' tabowaku pamuwan ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Manjari ah'lling si Naomi, “Angagad-ngagad na sadja ka, dayang, sampay tata'unu bang ai kataluwa'anna. Tantu mbal pahali si Bowas llaw itu bang halam aniya' kajatuhan palkala' itu.” ");
INSERT INTO sml_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Manjari itu, hinabu magsuli-suli si Naomi maka si Rūt, pehē' si Bowas aningkō' ma atag lawang ya pagsōran kauman Betlehem e'. Sakali palabay minna'an dakayu' kampung si Naomi ya bay pinagpa'in e' si Bowas. Magtūy lingananna bo' binowa magsuli-suli. Yuk si Bowas, “O tuwan, pi'itu gi' ka aningkō'.” Na pasekot a'a inān aningkō'. ");
INSERT INTO sml_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Sakali pinalinganan e' si Bowas sangpū' pagmatto'ahan ma kauman inān. Yukna ni sigām, “Aningkō' kam maitu saga tuwan.” Jari aningkō' isab sigām. ");
INSERT INTO sml_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Makatingkō' pa'in sigām kamemon, ah'lling si Bowas ni kampung he', yukna, “Tuwan, in si Naomi, ya balu si Elemelek, bay na pabīng pi'itu min lahat Mowab maka aniya' niyatna angandagangan tana' si Elemelek ya bay kampungta. ");
INSERT INTO sml_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Wajib ka pahatiku, kalu ka bilahi angal'kkat. Bang ka bilahi, atiya' saga pagmatto'ahanta anaksi', beya' isab saga a'a kasehe'an ya magtingkō'an maitu. Damikiyanna isab bang ka mbal, haka'in aku bo' kata'uwanku. Sabab halam aniya' saddī taga-kapatut angal'kkat tana' inān bang ngga'i ka ka'a bo' yampa aku.” “Aho', l'kkatku na,” yuk kampung si Bowas inān. ");
INSERT INTO sml_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Jari ah'lling si Bowas, “Pagka b'llinu na tana' min si Naomi maka ayuwanna si Rūt ya d'nda Mowab, akuhannu du isab ningā' h'nda si Rūt. Jari mbal alungay ōn si Mahalon minsan amatay, sabab kaniya'an iya anak min bay h'ndana, maka aniya' na pa'in tubu' pamusaka'an tana'na.” ");
INSERT INTO sml_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Anambung kampung inān, yukna, “Bang buwattilu hatulanna, mbal aku maka'aku angal'kkat tana' ilu sabab mbal du tahinangku pusaka'. Na, ka'a na ya angal'kkat sabab mbal tagagaku.” ");
INSERT INTO sml_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Na ya addat ma masa he'-i ma lahat Isra'il, bang aniya' a'a magpal'kkat atawa magdagang ai-ai pangalta'na, subay niurusan taumpa'na bo' ni'nde'an ni a'a angal'kkat inān. Ya itu hatulan sara' ma bangsa Isra'il ma takdil l'ngngan kataddangan.) ");
INSERT INTO sml_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Angkan yuk kampung inān ni si Bowas, “Ka'a na am'lli tana' ilu.” Magtūy niurusan taumpa'na. ");
INSERT INTO sml_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Buwattē' pa'in, amissala si Bowas ni saga pagmatto'ahan maka saga a'a maina'an, yukna, “Kasaksi'anbi ma llaw itu aku ya makab'lli min si Naomi kamemon palsuku'an si Elemelek, si Kiliyon maka si Mahalon. ");
INSERT INTO sml_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Damikiyanna si Rūt ya d'nda bangsa Mowab, ya bay balu si Mahalon, ta'ā'ku na h'nda bo' supaya aniya' tubu' pinusaka'an kamemon bay palsuku'an a'a mamatay itu. Mbal isab takalipat ōnna min pangentom saga kaukampunganna atawa min lahatna. Saksi' kam llaw itu.” ");
INSERT INTO sml_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Anambung saga pagmatto'ahan maka saga a'a maina'an ma tongod lawang kauman e'. Yuk-i, “Aho', saksi' kami. Mura-murahan bang pa'in d'nda ya song tah'ndanu ilu binuwanan kahāpan he' PANGHŪꞋ, pinasali' ni kahāpan bay tapamuwanna ma si Leya maka si Rakiya ya pagina'an bangsa Isra'il.” Yuk sigām gi' isab, “Bang pa'in pasōng kahaldayanu ma tumpuk Eprat maka patanyag ōnnu ma Betlehem. ");
INSERT INTO sml_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Bang pa'in aniya' tubu' pamuwan ka'a he' PANGHŪꞋ min d'nda itu, bo' pasali' ka'anakannu ni anak si Peres, ya anak si Yuda min si Tamar.” ");
INSERT INTO sml_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Manjari ningā' na h'nda si Rūt he' si Bowas. Makapagdakayu' pa'in sigā, ab'ttong si Rūt min kahandak PANGHŪꞋ ati anganak l'lla. ");
INSERT INTO sml_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Yuk saga kar'ndahan maina'an ni si Naomi, “Pudjitam PANGHŪꞋ sabab mbal ka kasiya-siyahan. Ma llaw itu du aniya' mpunu l'lla taga-kapatut amaruli ka'a. Bang pa'in atanyag onde' ilu ma katilingkal Isra'il. ");
INSERT INTO sml_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Iya ya amalasig ka'a maka angipat ka'a bang ka ta'abut na ato'a. Sabab ina' onde' ilu, ya na ayuwannu. Alasa iya ma ka'a, maka aheya halga'na ma ka'a min anak l'lla pitu' hekana.” ");
INSERT INTO sml_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ati giniba he' si Naomi onde' inān ati ni'ipat he'na. ");
INSERT INTO sml_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Yuk saga kar'ndahan ma jadjahan ina'an, “Ahā, aniya' na anak si Naomi!” Jari Obed ya pangōn sigām ma iya. Na, si Obed itu ya na mma' si Jesse, si Jesse ya na mma' si Da'ud. ");
INSERT INTO sml_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ya itu panubu' si Peres: Si Peres ya na mma' si Hesdon, ");
INSERT INTO sml_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","si Hesdon ya na mma' si Rām. Si Rām ya na mma' si Aminadab, ");
INSERT INTO sml_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","si Aminadab ya na mma' si Nason. Si Nason ya na mma' si Salmon, ");
INSERT INTO sml_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","si Salmon ya na mma' si Bowas. Si Bowas ya na mma' si Obed, ");
INSERT INTO sml_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","si Obed itu ya na mma' si Jesse, Si Jesse itu ya na mma' si Da'ud.");
INSERT INTO sml_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Na, aniya' dakayu' l'lla niōnan si Elkana maglahat ma kauman Rama ma kabūd-būran Epra'im. Panubu' Epra'im si Elkana itu, min tumpuk si Sūp. Mma'na si Jeroham anak si Elihu, mpu si Tohu ya anak si Sūp. ");
INSERT INTO sml_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Aniya' duwa h'nda si Elkana, ya si Hanna maka si Pennina. In si Pennina taga-anak bo' si Hanna halam. ");
INSERT INTO sml_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Kahaba' tahun atulak si Elkana min kaumanna patukad ni Silo supaya pasumba maka anukbal lalabotan ni si Yawe ya Tuhan Sangat Kawasa. Ya magimam ma Silo inān si Opni maka si Pinehas, karuwangan anak imam Eli. ");
INSERT INTO sml_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Sakahaba' waktu magkulban si Elkana, binahagi'an e'na si Pennina maka saga ka'anakanna. ");
INSERT INTO sml_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Sagō' labi ahāp bahagi' ya pamuwanna ma si Hanna sabab kaheya lasana ma iya, minsan iya halam kabuwanan anak min kahandak PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Na pagka halam kabuwanan anak si Hanna, sidda iya nijingki maka pinareyo'-deyo' e' kalu'ana si Pennina. ");
INSERT INTO sml_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Tahun ni tahun buwattina'an na pa'in in kahālan. Sakahaba' waktu katukad sigām ni luma' pagtata'atan ni si Yawe, nijural na pa'in si Hanna e' kalu'ana sampay iya magtangis maka mbal na amangan. ");
INSERT INTO sml_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Angkan ah'lling h'llana ni iya, yuk-i, “Oy rāng, angay ka anangis na pa'in ilu? Angay ka mbal minsan amangan? Ai karukka'annu? Kulang gi' bahā' halga'ku ma ka'a min sangpū' anak?” ");
INSERT INTO sml_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Na dakayu' waktu ma Silo, pagubus sigām amangan maka anginum, pabuhat si Hanna. Ina'an asal imam Eli aningkō' ma bangku' ma atag bowa' lawang luma' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Na, landu' aheya kasukkalan si Hanna angkan iya anangis to'ongan maka e'na angamu'-ngamu' ni si Yawe. ");
INSERT INTO sml_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Anganajal iya, yukna, “O Yawe Sangat Kawasa, ummatnu aku. Bang pa'in nda'nu kasukkalanku bo' aku palulinu pahāp. Bang aku dūlannu ati buwanannu anak l'lla, tukbalanku iya ni ka'a pabalik bo' maghinang ni ka'a sat'ggolna allum. Anganajal isab aku in kōkna mbal binagongan.” ");
INSERT INTO sml_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Ma pangamu'-ngamu' si Hanna ni PANGHŪꞋ-Yawe, ta'nda' bowa'na e' si Eli. ");
INSERT INTO sml_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Magkimut-kimut sadja bowa'na, halam magsuwala. Pangannal si Eli in iya nilango, ");
INSERT INTO sml_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","angkan yukna ma iya, “Arung, angay ka maglango sadja ilu? Timanin binunu!” ");
INSERT INTO sml_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","“Halam aku nilango, tuwan,” yuk sambung si Hanna. “Tu'ud aheya karukka'anku. Halam aku maginum binu atawa ai-ai makalango, paluwasku sadja kasukkalanku ni si Yawe. ");
INSERT INTO sml_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Da'a aku bistahun d'nda ala'at. Angamu'-ngamu' sadja aku sabab mbal kasandalan karukka'anku itu.” ");
INSERT INTO sml_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Ah'lling si Eli ni iya, “Pehē' na ka amole',” yukna, “bang pa'in ka mura-murahan asalamat maka kinale pangamu'-ngamu'nu e' Tuhan bangsatam Isra'il.” ");
INSERT INTO sml_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Ya panambung si Hanna, “Magsukul. Bang pa'in ka kasulutan ma aku, dakayu' sosoho'annu itu.” Jari ala'an na si Hanna minnē'. Aniya' isab takakanna ati ahāp na pamaihu'anna. ");
INSERT INTO sml_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Pag'llaw dakayu' pa'in, subu-subu lagi', pabangun disi Elkana maka saga anak-h'ndana bo' anumba ni PANGHŪꞋ-Yawe. Pagubus, amole' na sigām pabīng ni Rama ya lahat sigām. Pahulid si Elkana ni h'ndana si Hanna ati nirūlan e' si Yawe bay pangamu'na. ");
INSERT INTO sml_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Jari ab'ttong iya ati ta'abut pa'in bulananna anganak iya l'lla. Niōnan e'na Samwel, sabab, yukna, “bay iya amu'ku min si Yawe.” ");
INSERT INTO sml_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Na, pagga ta'abut na bulanan Paghinang Taubat, patukad disi Elkana magtai'anak ni lahat Silo maghinang ni PANGHŪꞋ-Yawe, ati tatuman isab e' si Elkana bay najalna ma iya. ");
INSERT INTO sml_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Sagō' halam ameya' patukad si Hanna. Yukna ni h'llana, “Subay na alutas onde' itu bo' bowaku pehē', ati pamasuku'ku iya ni PANGHŪꞋ. Jari mahē' iya pat'nna' sat'ggolna allum.” ");
INSERT INTO sml_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","“Hinangun bang ai ya makasulut ka'a,” yuk si Elkana. “Maitu sadja ka sampay talutasnu onde' ilu, bang pa'in tatuman bay janji' PANGHŪꞋ ma ka'a.” Jari pa'bba si Hanna ma luma' amaruru' onde' inān sampay talutas e'na. ");
INSERT INTO sml_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Manjari talutas pa'in onde' inān, bo' ariki'-diki' lagi', binowa na iya e' ina'na ni luma' si Yawe ma Silo. Bay isab bowana dakayu' sapi' t'lluntahun umulna maka dakarut tirigu maka dapangisihan binu-anggul. ");
INSERT INTO sml_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Tasumbali' pa'in sapi' he', ni'nde'an na si Samwel ni si Eli e' matto'ana. ");
INSERT INTO sml_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Manjari anibahat si Hanna ma si Eli, yukna, “Sapahanku, tuwan, aku na d'nda ya bay an'ngge maitu ma bihingnu angamu'-ngamu' ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Bay aku angamu' anak ati nirūlan e'na pangamu'-ngamu'ku. ");
INSERT INTO sml_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Angkan na buwattina'an, pamasuku'ku na ni iya onde' itu sat'ggolna allum.” Puwas pa'in he'-i, sinumba na si Yawe ma atag ina'an. ");
INSERT INTO sml_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Manjari anambahayang si Hanna, yukna, “Akōg-koyag pangatayanku ma pasal si Yawe, Pinajatu kosogku ma sabab si Yawe, angkan pagtittowahanku saga bantaku, magkalasigan aku ma sabab da'ugan ya pamuwannu ma aku, O Tuhan. ");
INSERT INTO sml_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Halam aniya' manusiya' asussi buwat kasussi si Yawe. Sapantun iya Batu Lakit pasindungan, halam aniya' makasibu'an iya. ");
INSERT INTO sml_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Sasuku kam magmalangkahi subay pahali. Sasuku kam magabbu-abbu subay pabba, sabab si Yawe ya makata'u kamemon. Iya ya angahukum kamemon kahinangan manusiya'. ");
INSERT INTO sml_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Tara'ug saga sundalu magpapana' ya tamakaesog, saguwā' sasuku bay lumukbu' binuwanan kosog labi-labihan. ");
INSERT INTO sml_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Sasuku bay asso tagna' magpatiata na bo' aniya' balanja' sigām, sagō' saga a'a bay patay otas mbal na lingantu. Sasuku bay mbal maka'anak, maka'anak na pitu' hekana, sagō' in bay aheka anakna asiya-siya du. ");
INSERT INTO sml_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Taga-kapatut si Yawe amakallum maka amapatay, amowa saga manusiya' ni ahirat maka amangun sigām. ");
INSERT INTO sml_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Makaparaya iya ba'anan a'a miskin ati makapamiskin ba'anan a'a dayahan, makapamareyo' iya maka makapamalanga. ");
INSERT INTO sml_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Tahaun e'na saga miskin min kasigpitan sigām, tapaluwas sigām min kaiya'an. Pinatingkō' sigām magbeya' maka ba'anan kasultanan bo' supaya sigām pinagmahaldika'. Si Yawe asal tag-suku'an alam maka po'onanna, ya pamapanjarihanna dunya maka kapanyapanna. ");
INSERT INTO sml_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Jagahanna sasuku sigām am'nnal ma iya, sagō' in a'a jahulaka' amatay ma deyom kalendoman. Halam aniya' makapanganda'ug bang hal min kosogna. ");
INSERT INTO sml_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Magmula isab sai-sai anagga' si Yawe. Pinal'ggonan sigām e'na min langit. Si Yawe ya angahukum katilingkal dunya. Aheya kosog pamuwanna ma a'a ya tahinangna sultan, aheya da'ugan ya pamuwanna ma a'a bay tapene'na.” ");
INSERT INTO sml_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Manjari, amole' na pabalik si Elkana maka si Hanna ni Rama. Sagō' ya si Samwel ta'bba ma Silo maghinang ni PANGHŪꞋ-Yawe ma deyo'an si Imam Eli. ");
INSERT INTO sml_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Na saga anak si Eli itu ala'at kahinangan sigām, mbal magaddatan PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Mbal isab sigām ameya' ma kauntulan ya bineya' e' saga kaimaman bang aniya' susumbali'an binowa panukbal ni Tuhan. Ma pam'llahan pa'in isi susumbali'an inān, pinapehē' dakayu' sosoho'an imam amowa tugsukna aheya. ");
INSERT INTO sml_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Jari ai-ai tatugsuk e' sosoho'an inān, ai-na ka ma kaha' atawa ma kaldero, ya na suku' imam. Buwattē' na pa'in addat kaimaman ma saga bangsa Isra'il waktu kapehē' sigām ni Silo. ");
INSERT INTO sml_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Sagō' buwattina'an, ma halam lagi' tatunu' lanab sumbali'an, aniya' sosoho'an imam pinapehē' ah'lling ni a'a magtukbal. Yukna, “Pamuwanun ma imam susumbali'an amata' ilu bo' tinapa e'na. Mbal tinaima' e'na bang talaga' na, luwal subay amata'.” ");
INSERT INTO sml_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Bang anambung a'a magtukbal inān, yukna, “Subay atunu' lanabna bo' ka angā' ya ingga kabilahiannu,” na, pinah'llingan iya e' sosoho'an imam e'. Yukna, “Hē! Mbal makajari! Sōngin na magtūy sabab bang ka mbal bilahi, agawku sadja min ka'a.” ");
INSERT INTO sml_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Na, landu' asammal ma pang'nda' PANGHŪꞋ bay kahinangan saga anak si Eli itu sabab talumu' he' sigām lalabotan ya tinukbal ma iya. ");
INSERT INTO sml_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Malaingkan, ina'an si Samwel maghinang na ni si Yawe minsan iya abata' gi'. Magbinadju' iya epod pangalampik jubana. ");
INSERT INTO sml_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Tahun ni tahun, nihinangan si Samwel juba he' ina'na, binowahan iya ma waktu katukad si Hanna maka h'llana pehē' bo' maghinang Pagtaubat. ");
INSERT INTO sml_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Jari, niamu'an barakat disi Elkana maglakibini e' si Eli. Yukna, “Mura-murahan bang pa'in kam kabuwanan anak e' PANGHŪꞋ min h'ndanu itu paganti' min onde' bay amu'na ma iya ati bay du tukbalanna pabalik ni iya.” Pagubus, amole' na sigā. ");
INSERT INTO sml_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Manjari, pinagka'inagonan si Hanna e' PANGHŪꞋ-Yawe ati kabuwanan gi' iya t'llu anak l'lla maka duwa anak d'nda. Jari pasulig na pa'in si Samwel hinabuna maghinang ni si Yawe. ");
INSERT INTO sml_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Na, minsan ato'a na si Eli, takale e'na pasal kamemon kalumu'an ya nihinang e' saga anakna l'lla ma saga bangsa Isra'il. Maka takale du isab e'na pasal paghulid sigām maka saga kar'ndahan ya maghinang ma Luma' Tolda Pagsasabuhan inān. ");
INSERT INTO sml_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Angkan ah'lling si Eli ni saga anakna, yukna, “Takaleku min saga a'a in kahinanganbi asammal! Angay kam magkahinangan buwattilu? ");
INSERT INTO sml_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Saga anak, halli'inbi na saga kahinanganbi ilu sabab ala'at kinale suli-suli ya pasaplag inān ma ba'anan jama'a PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Ah'lling gi' si Eli, yukna, “Bang a'a makarusa ma pagkahina manusiya', makapati'llot Tuhan ma sigām. Sagō' bang a'a makarusa ma PANGHŪꞋ, na sai na gi' magpati'llot ma iya?” Saguwā' mbal ameya' saga anak si Eli ma pami'atna, sabab asal kahandak PANGHŪꞋ pinapatay sigām. ");
INSERT INTO sml_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Na, pasōng na pa'in paheya si Samwel maka pasōng ta'una. Pasōng isab iya makasulut atay PANGHŪꞋ sampay manusiya'. ");
INSERT INTO sml_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Dakayu' llaw, aniya' a'a sosoho'an Tuhan pinapehē' ni si Eli amasampayan iya lling, yukna, “Buwattitu ya pangallam si Yawe ma ka'a, ‘Bay aku magpanyata' ma ka'mbo'-mbo'annu si Harun waktu sigām ma lahat Misil ma deyo'an pagparinta Pira'un. ");
INSERT INTO sml_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Bay tapene'ku si Harun min kamemon kapanubu'an bangsa Isra'il bo' supaya iya pinat'nna' imam maghinang ma lugal pagtutukbalan ni aku, maka anunu' kamanyan, maka amowa epod ma waktu kasōdna ni matahanku. Bay isab buwananku bahagi' ma saga imam min ba'anan lalabotan ya tinunu'an aku he' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Jari angay halipulubi saga kukulbanan maka lalabotan ya bay soho'ku tinukbalan ma Luma'ku? Angay paheyanu saga anaknu labi gi' min aku? Sabab ilu pagnapsuhanbi isi sumbali'an ahāp to'ongan ya ngā'bi min saga kukulbanan kamemon bay panukbal ma aku e' saga a'aku bangsa Isra'il!’ ” ");
INSERT INTO sml_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Amissala gi' sosoho'an Tuhan inān, yukna, “Angkan buwattitu pangallam si Yawe ya Tuhanbi bangsa Isra'il, yuk-i, ‘Tagna', aniya' bay panganjanji'ku ma ka'am panubu' si Libi, luba'na ka'am ma tumpukan mma'nu, subay magimam ni aku ni kasaumulan. Sagō' mbal na. Palangaku na pa'in sasuku magmahaltabatan aku, sagō' pareyo'ku sasuku mbal magaddatan aku. ");
INSERT INTO sml_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Kalehun pahāp, at'kka du waktu papu'utku umulnu maka umul saga anak-mpunu, jari halam aniya' ma panubu'nu magkato'a. ");
INSERT INTO sml_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Angkan magkarukka'an kam ati mbal na takinambi kahāpan ya pamuwanku ma bangsa Isra'il. Halam na aniya' min panubu'nu maka'abut kato'a sigām. ");
INSERT INTO sml_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","B'nnal aniya' tubu'nu pasagaranku magimam ma matahanku, sagō' binuta iya sampay makananam karukka'an landu' bisana. Jari in kaheka'an panubu'nu pinatay bono' ma sinosōng. ");
INSERT INTO sml_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","“ ‘Ya paltanda'an, magdora' amatay karuwangan anaknu, si Hopni maka si Pinehas, ma dang'llaw. ");
INSERT INTO sml_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Ati paniya'ku imam dakayu', a'a kapangandolanku, lilla' angahinang kamemon maksudku maka kabaya'anku. Patumanku saga panubu'na bo' aniya' min sigām maghinang ma matahan sultan ya pene'ku sampay ni kasaumulan. ");
INSERT INTO sml_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Manjari, in kamemon takapin ma panubu'nu magpatireyo' ma iya angamu' takakan maka pilak. Angamu' sigām junjung bang pa'in sigām binuwanan hinang minsan ai-na ma saga imam, supaya aniya' takakan sigām.’ ” ");
INSERT INTO sml_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Anubul-nubul pa'in si Samwel, maghinang iya ni PANGHŪꞋ-Yawe ma deyo'an si imam Eli. Ma waktu ina'an, alahang si Yawe amissala ni manusiya' maka alahang aniya' manusiya' pinakalehan suwalana. ");
INSERT INTO sml_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Dakayu' sangom, ina'an si Eli atuli ma bilikna. Ahawhaw na pang'nda'na, mbal na agon makapatong pahāp. ");
INSERT INTO sml_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Si Samwel isab ina'an abahak ma luwasan bilik pagpat'nna'an Ba'ul Tuhan ya ma deyom Luma' Pagtata'atan ni PANGHŪꞋ-Yawe. Ma halam lagi' ap'dda palita'an, ");
INSERT INTO sml_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","nilinganan si Samwel e' si Yawe. Anambung iya, yukna, “Owa', itiya'!” ");
INSERT INTO sml_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Magtūy iya parai'-dai' pehē' ni si Eli. “Itiya' aku,” yukna. “Bay aku linganannu.” Sagō' anambung si Eli, yukna, “Halam ka bay lingananku, pehē' ka atuli pabalik.” Angkan pabalik si Samwel ni pabahakanna. ");
INSERT INTO sml_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Manjari, angalingan pabalik si Yawe, yukna, “Samwel!” Magtūy pabungkal si Samwel bo' pehē' ni si Eli, “Itiya' aku,” yukna. “Bay aku linganannu.” Ah'lling si Eli ni iya, “Oto',” yukna, “halam aku bay angalingan. Pehē' na ka pabalik ni patulihannu.” ");
INSERT INTO sml_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Ma waktu ina'an, akulang gi' pana'u si Samwel pasal PANGHŪꞋ-Yawe, maka halam gi' aniya' palman PANGHŪꞋ bay pamukis ma iya. ");
INSERT INTO sml_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Jari, angalingan na isab si Yawe ma si Samwel, kat'lluna na. Magtūy iya magdai'-dai' pehē' ni si Eli maka he'na ah'lling, “Itiya' aku,” yukna. “Bay du aku linganannu.” Na tasayu e' si Eli, si Yawe ya angalinganan onde' inān. ");
INSERT INTO sml_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Angkan iya ah'lling ma si Samwel, yukna, “Oto', pabahak ka pehē'. Bang ka nilinganan pabīng, anambung ka buwattitu yuknu, ‘Ya PANGHŪꞋ, amissala na ka sabab akale du sosoho'annu itu.’ ” Manjari, pabīng na si Samwel ni pabahakanna. ");
INSERT INTO sml_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Na, magpanyata' na si Yawe ma si Samwel maka e'na angalingan buwat bay dahū. Yukna, “Samwel! O Samwel!” Anambung si Samwel, yukna, “Amissala ka kono', sabab akale du sosoho'annu itu.” ");
INSERT INTO sml_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Ah'lling si Yawe ma si Samwel, “Kalehun lapal itu!” yukna. “Aniya' hinang makatāw-tāw song hinangku ma deyom bangsa Isra'il, ati tak'bbal atay sasuku makakale. ");
INSERT INTO sml_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Ma waktu ina'an, hinangku du kamemon bay pangallamku ma pasal saga panubu' si Eli. ");
INSERT INTO sml_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Bay na iya asal haka'anku pasalan hukuman ya pamat'kkaku ma panubu'na. Sabab halam nilāng e'na kalumu'an ya bay nihinang e' saga anakna, minsan du bay kata'uwanna. ");
INSERT INTO sml_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Angkan aku bay anapa pasal saga panubu' si Eli, yukku, ‘Mbal ta'ampun paldusahan sigām minsan ai tataubatan atawa lalabotan.’ ” ");
INSERT INTO sml_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Manjari, tatuli na pabalik si Samwel sampay subu. Pagbati'na pa'in, niukab he'na lawang Luma' Pagtata'atan ni PANGHŪꞋ-Yawe he'. Tināw iya amissalahan si Eli pasal bay takalena min Tuhan, ");
INSERT INTO sml_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","sagō' nilinganan iya e' si Eli. “Samwel! Otō'!” yukna. Jari anambung si Samwel yukna, “Oy itiya' aku.” ");
INSERT INTO sml_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Atilaw si Eli yukna, “Ai bay pamissala Tuhan ma ka'a? Da'a limbungin min aku. Patut ka pinat'kkahan mulka' kaginisan e' Tuhan bang ka ganta' maglimbung ai-ai bay llingna ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Angkan nihaka kamemon e' si Samwel, halam iya maglimbung. Jari ah'lling si Eli, “In iya Tuhan-asal-Tuhan taga-kapatut angahinang bang ai kabaya'anna.” ");
INSERT INTO sml_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Manjari, pataptap PANGHŪꞋ-Yawe ma si Samwel sampay iya paheya, angkan atuman kamemon pah'llingna. ");
INSERT INTO sml_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Takilā iya e' kamemon bangsa Isra'il min lahat Dān sampay ni Be'erseba, in iya nabi si Yawe. ");
INSERT INTO sml_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Tinagna'an minnē', magpa'nda' na pa'in PANGHŪꞋ ma si Samwel ma Silo ati maina'an iya amakilā di-na labay min lapalna. ");
INSERT INTO sml_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Manjari itu, pasaplag na lapal si Samwel ma kaluha'an bangsa Isra'il. Na paluwas saga sundalu Isra'il min pustu sigām bo' magbono' maka bangsa Pilistin. Ina'an bangsa Isra'il magpustu ma atag Ebeneser ati ma Apek ya pagpustuhan bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Manjari magsakap saga sundalu Pilistin angandugpak bangsa Isra'il. Aheya landu' bono' ma llaw inān, jari tara'ug bangsa Isra'il, aniya' saga mpat ngibu heka sigām amatay maina'an ma pagbono'an. ");
INSERT INTO sml_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Makapole' pa'in ni pustu saga sundalu Isra'il ya takapin allum, tinilaw sigām he' pagmatto'ahan bangsa Isra'il, yuk-i, “Angay angkan kitam pinasagaran e' PANGHŪꞋ-Yawe bo' tara'ug e' ba'anan bangsa Pilistin? Ahāp lagi' kitam pehē' ni Silo angā' Ba'ul Paljanji'an si Yawe bo' pagapi' ma kitam amuwasan kitam min ga'osan saga bantatam.” ");
INSERT INTO sml_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Manjari, magpanoho'an sigām saga a'a pehē' ni Silo angā' Ba'ul Paljanji'an si Yawe Sangat Kawasa, ya aningkō' asal min llot duwa mala'ikat pikpikan, ya ma sa'ob ba'ul inān. Ina'an isab karuwangan anak si Eli, ya si Opni maka si Pinehas, bay ameya' ma Ba'ul Paljanji'an e'. ");
INSERT INTO sml_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Pagt'kka pa'in Ba'ul Paljanji'an si Yawe ni pustu bangsa Isra'il, magtūy sigām magolang pakosog to'ongan angkan ajogjog sampay tana'. ");
INSERT INTO sml_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Pagkale saga bangsa Pilistin ma pagolang bangsa Isra'il itu, magtilawan sigām di-sigām, yuk-i, “Ai bahā' kahiyulan saga Hibrani he'?” Makata'u pa'in saga bangsa Pilistin, ina'an Ba'ul si Yawe bay binowa ni pustu bangsa Isra'il, ");
INSERT INTO sml_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","magtūy sigām sinōd tāw. “Arōy!” yuk sigām. “Aniya' tuhan maina'an ma pustu. Mamarahi na kitam itu! Yampa aniya' buwattitu! ");
INSERT INTO sml_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Magmula na kitam! Halam aniya' angalappas kitam min kawasa saga tuhan ga'osan itu! Ya na ko' ina'an saga tuhan bay amat'kka bala' kaginisan ma bangsa Misil ma lahat paslangan he'. ");
INSERT INTO sml_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Oy! Ka'am saga bangsa Pilistin, pakuyas kam amono'. Paesog kam angatu, sabab bang mbal, tabanyaga' kitam e' saga Hibrani itu, buwat bay pamanyaga'tam ma sigām!” ");
INSERT INTO sml_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Angkan amono' pakosog to'ongan saga a'a Pilistin ati tara'ug e' sigām bangsa Isra'il. Makalandu' aheka abugtang, t'llumpū' ngibu heka sundalu Isra'il amatay. Jari sasuku bay takapin wa'i maglahian amole' ni pustu sigām. ");
INSERT INTO sml_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Ta'agaw e' bangsa Pilistin Ba'ul Tuhan min saga bangsa Isra'il maka amatay isab si Hopni maka si Pinehas, karuwangan anak si Eli. ");
INSERT INTO sml_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Na, ma llaw du ina'an, aniya' dakayu' l'lla min panubu' Benjamin bay makalahi min pagbono'an tudju ni Silo. Gineret e'na badju'na maka kapē'an bagunbun kōkna, tanda' pagdukkana. ");
INSERT INTO sml_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Pagt'kkana na ni Silo, ina'an asal si Eli ma tingkō'anna ma bihing lān amantaw, sabab asusa pangatayanna ma pasalan Ba'ul Tuhan. Manjari paghaka l'lla inān ma bay paniya' ma pagbono'an, magtūy maglemongan kamemon a'a ma kauman inān. ");
INSERT INTO sml_vpl VALUES ("S14_14","010_4_14","1SA","4","14","15","Ma waktu inān, siyampū' na maka waluntahun umul si Eli, mbal na maka'nda', hal amantaw sadja. Jari takale pa'in e' si Eli pagalud inān, atilaw iya, “Angay angkan magpangalud saga a'a itu?” Sinekot iya magtūy e' a'a bay makalahi inān. ");
INSERT INTO sml_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","“Tuwan,” yukna, “yampa aku alahi pi'itu min pagbono'an.” Atilaw pabalik si Eli, “Oto',” yukna, “ai bay tum'kka ni ka'am?” ");
INSERT INTO sml_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Ya sambung a'a inān, “Tuwan,” yukna, “maglahian saga sundalu Isra'il sabab tara'ug e' bangsa Pilistin. Kamatayan aheka a'atam ati talapay anaknu si Hopni maka si Pinehas. Ta'agaw isab Ba'ul Tuhan.” ");
INSERT INTO sml_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Pagkale si Eli ma pasalan ba'ul e', magtūy iya pahantak min paningkō'an maina'an ma atag pagsosōran ni kauman. Pahantak iya ni buli'an ati apōng buli'-k'llongna. Jari amatay na iya sabab ato'a na iya maka landu' al'mmok. Mpatpū' tahun bay kapagmakōkna ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Na, ma waktu inān, bulanan na ayuwan si Eli, ya h'nda si Pinehas. Pagkale d'nda itu ma habal pasal Ba'ul Tuhan bay ta'agaw e' bangsa Pilistin, maka wa'i amatay h'llana maka mato'ana, kap'ddi'an iya sampay anganak. Sagō' kahunitan sidda iya ma paganakna. ");
INSERT INTO sml_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Magkamamatay pa'in iya, amūng saga panday, yuk-i, “Ndū' nneng, da'a ka tināw. Nda'un ba, l'lla ko' anaknu itu.” Sagō' halam iya makasambung minsan ai. ");
INSERT INTO sml_vpl VALUES ("S14_21","010_4_21","1SA","4","21","22","Ma halam lagi' iya amatay, Ikabod ya pangōnna ma onde' inān. “Sabab,” yukna, “wa'i paokat in sahaya Tuhan min bangsa Isra'il.” Angkan iya makapah'lling buwattē' sabab wa'i na bay ta'agaw Ba'ul Tuhan e' bangsa Pilistin, maka in h'llana maka mato'ana wa'i na amatay. ");
INSERT INTO sml_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Na, pagga ta'agaw Ba'ul Tuhan e' bangsa Pilistin, binowa na e' sigām min Ebeneser tudju ni Asdod ya da'ira sigām. ");
INSERT INTO sml_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Manjari, ma Asdod pa'in, binowa Ba'ul itu ni deyom langgal pagsusumbahan si Dagon ya pagtuhanan sigām bo' pinapagbihing maka ta'u-ta'una. ");
INSERT INTO sml_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Pag'llaw dakayu' pa'in, subu-subu lagi', pasōd saga a'a Asdod ni langgal si Dagon inān. Pagsōd itu, ta'nda' ta'u-ta'una pakutung ma lantay, sali' hantang pasujud ma dahuwan Ba'ul si Yawe! Jari pinat'ngge ta'u-ta'u inān e' sigām ni asal bay pamat'nna'an iya. ");
INSERT INTO sml_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Saguwā', pag'llaw dakayu' na isab, wa'i na isab ta'u-ta'u si Dagon pakutung pabalik. Ya du, sali' pasujud ma dahuwan Ba'ul si Yawe! Magkapōng-pōng kōkna maka tanganna ina'an ma bowa' lawang. Hal du baranna ya takapin tibu'uk. ");
INSERT INTO sml_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Ya itu sababanna angkan sampay ni buwattina'an saga imam Pilistin atawa sai-na ma Asdod mbal pagi'ik ma bowa' lawang bang pasōd ni langgal si Dagon inān. ");
INSERT INTO sml_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Na, pinat'kkahan e' PANGHŪꞋ-Yawe bala' mamarahi bisana ma katilibut Asdod maka saga kauman ma jadjahan ina'an. Kapē'an sigām saga butig a'aslag ma baran sigām. ");
INSERT INTO sml_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Pag'nda' saga a'a Asdod ma bay tumaluwa' ni sigām inān, ah'lling sigām ni dangan-parangan, yuk-i, “Halam dapat! Mbal manjari pat'nna' maitu in Ba'ul Tuhan bangsa Isra'il, sabab itiya' kitam binantahan e'na. Tantu kitam magmula sampay tuhantam si Dagon.” ");
INSERT INTO sml_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Manjari pinalinganan kamemon pagnakura'an bangsa Pilistin ati tinilaw sigām, yuk-i, “Ai na hinangtam ma Ba'ul ya suku' pagtuhanan bangsa Isra'il itu?” Ya sambung sigām, “In ba'ul suku' tuhan bangsa Isra'il ilu subay pinapinda ni da'ira Gāt.” Angkan pinapinda Ba'ul inān. ");
INSERT INTO sml_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Saguwā', bay pa'in itu pinapinda ni Gāt, pinat'kkahan bala' da'ira inān e' PANGHŪꞋ-Yawe. Ahiluhala' katilibut paglahat maina'an sabab bay du isab pinat'kkahan butig kamemon saga manusiya', min onde'-onde' ni matto'ana. ");
INSERT INTO sml_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Angkan bay pinalanjal Ba'ul Tuhan inān min Gāt ni da'ira Ekron. Hinabu binowa pasōd Ba'ul inān ni da'ira Ekron, magpangolang saga a'a maina'an, yuk sigām, “Arōy! Itiya' na ba'ul sin tuhan bangsa Isra'il binowahan kitam supaya kitam alaglag!” ");
INSERT INTO sml_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Manjari, pinatimuk kamemon pagnakura'an ma bangsa Pilistin ati ah'lling saga a'a Ekron ma sigām, yuk-i, “Pala'anunbi m'nnitu in Ba'ul Tuhan Isra'il ilu ati pabalikunbi pehē' ni bay asal pat'nna'anna. Mamarahi na to'ongan kitam itu, magkamatay kamemon!” Angkan buwattē' pah'lling saga a'a inān sabab sinōd tāw makapatay. Tu'ud landu' abisa in bala' pinat'kkahan sigām e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Na, sasuku sigām halam amatay e' bala', bay kat'kkahan butig aheka. Jari in pagaruhuy saga a'a ma da'ira inān pa'abut sampay ni langit. ");
INSERT INTO sml_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Ta'abut pa'in pitumbulan t'ggol Ba'ul si Yawe ma lahat Pilistin, ");
INSERT INTO sml_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","pinalinganan pina'an saga kaimaman maka saga magpuputika' e' saga a'a Pilistin bo' supaya pangaruhan e' sigām. Yuk panilaw sigām, “Ai subay hinang kami ma Ba'ul si Yawe itu? Haka'inbi kami bang buwattingga e' kami amabalik iya ni bay pat'nna'anna tagna'?” ");
INSERT INTO sml_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Anambung saga a'a pangaruhan itu, yuk-i, “Ebot-ebot, bang kam anganggara' amabalik ba'ul ya suku' tuhan bangsa Isra'il, da'a pabalikunbi ma halam aniya' ai-aina pinabeya'. Pabeya'unbi isab tutukbalan pagtaubatan dusabi bo' kam kauli'an, ati minnē' kata'uwanbi bang angay kam pinat'kkahan bala' e' Tuhan.” ");
INSERT INTO sml_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Sakali anilaw saga a'a Pilistin, yuk sigām, “Tutukbalan taubat ai ya patut pamuwan kami ma tuhan itu?” Anambung saga imam maka saga magpuputika' inān, yuk-i, “Angahinang kam bulawan pinakaluwa butig maka ambaw. Subay lima-lima hekana buwat du isab heka saga pagnakura'an bangsa Pilistin. Sabab magsali' du bala' ya makataluwa' ni ka'am maka ni saga pagnakura'anbi. ");
INSERT INTO sml_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Angahinang kam bulawan pina'anggil ni butig maka ni ambaw ya angamula kaluha'an paglahattam itu, ati tukbalinbi ni Tuhan bangsa Isra'il tanda' sin pamaheyabi ma iya. Kalu iya mura-murahan ma'ase' ma ka'am ati la'ananna bala' ya pamat'kkana ni ka'am maka ni saga tuhanbi sampay lahatbi. ");
INSERT INTO sml_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Da'a kam magmatuwas. Da'a kam pasali' ni bay kahinangan Pira'un maka saga bangsa Misil ma waktu tagna' he'. Subay sadja bay makalandu' kabinsana'an pinat'kkahan sigām e' Tuhan bo' yampa sigām anugutan saga bangsa Isra'il ala'an minnē'.” ");
INSERT INTO sml_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Na, magpanoho'an saga imam bangsa Pilistin maka saga magpuputika' inān. Yuk sigām, “Pasakapunbi karitun baha'u, maka angā' kam duwa sapi' duru'an halam gi' bay kapangangguyuran karitun. Pahengkotunbi sapi' ilu ni karitun, sagō' pasaddīhun saga anak-anakna ma deyom kamalig. ");
INSERT INTO sml_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Jari duwa'unbi Ba'ul si Yawe pehē' ni karitun. Ati pat'nna'unbi isab ma bihing ba'ul ilu dakayu' tu'ung pangisihan saga tataubatan bulawan ya tukbalanbi ni iya. Taruwa' pa'in, pal'ngnganunbi saga sapi' angangguyud karitun ilu pi'ingga-pi'ingga patudjuhanna. ");
INSERT INTO sml_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Sagō' nda'unbi na pa'in. Bang patudjuhanna ilu Bet-Semes ya ma lahat bangsa Isra'il, minnē' kata'uwantam si Yawe ya bay amat'kkahan kitam bala' itu. Sagō' bang saddī patudjuhan, na ngga'i ka iya ya bay angamulahan kitam. Tu'ud magsalta' sadja.” ");
INSERT INTO sml_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Jari bineya' e' saga a'a Pilistin panoho'an inān. Ningā' e' sigām duwa sapi' d'nda bo' pinaengkot ma karitun. Saga anak-anakna bay pinagal ma kamalig. ");
INSERT INTO sml_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Sakali, pinaruwa' na Ba'ul si Yawe inān ni karitun pinapagbeya' maka tu'ung ya pangisihan saga bulawan bay pina'anggil ni ambaw maka butig e'. ");
INSERT INTO sml_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Manjari itu, lum'ngngan na saga sapi' inān magin'ngngong. Amontolan sigām tudju ni Bet-Semes ma halam pagbeklo'-beklo'na, ai-na ka ni kowan atawa ni gibang. Ina'an paurul ma buli'an saga pagnakura'an bangsa Pilistin sampay ni bihing kauman Bet-Semes. ");
INSERT INTO sml_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Ina'an isab saga a'a Bet-Semes magani pai-tirigu ma kapantayan. Jari pagtongas sigām, ta'nda' e' sigām Ba'ul Tuhan angkan landu' sigām kinōgan. ");
INSERT INTO sml_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Makat'kka pa'in karitun inān ni huma si Yussa' a'a Bet-Semes, pahogga' na ma bihing dakayu' batu aheya. Paghogga' pa'in itu, ningā' e' saga a'a maina'an kayu bay pangahinang karitun e' bo' tin'tta' pangayu. Sinumbali' isab saga sapi' he' bo' tinunu' tutukbalan pagtaubat ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Nihawas ba'ul e' saga kal'llahan panubu' si Libi, beya' isab maka tu'ung ya isihan pamulawan bay pina'anggil ni butig maka ambaw. Tahawas pa'in, bay pinabangkat e' sigām ni diyata' batu aheya. Jari ma llaw ina'an du, saga a'a kamemon ya pat'nna' ma Bet-Semes bay anukbal ni PANGHŪꞋ-Yawe saga susumbali'an pinagtunu' maka lalabotan pagtaubat. ");
INSERT INTO sml_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Ta'nda' pa'in kahinangan itu e' saga lima pagnakura'an bangsa Pilistin ya bay paurul e', magtūy sigām amole' pabalik ni Ekron, ma llaw ina'an du. ");
INSERT INTO sml_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Na, in butig bulawan ya pinabeya' e' bangsa Pilistin pagtaubat ni si Yawe, bay lima hekana bo' pinapagkaniya-kaniya ma saga pagnakura'an sigām lima hekana isab. Hatina dakayu' ma Asdod, dakayu' ma Gasa, dakayu' ma Askelon, dakayu' ma Gāt maka dakayu' isab ma Ekron. ");
INSERT INTO sml_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Damikiyanna isab saga ambaw bulawan, pinapagkaniya-kaniya ma saga kuta' maka kauman ya suku' pagnakura'an bangsa Pilistin lima hekana he'. Ya batu aheya isab bay pamat'nna'an Ba'ul si Yawe, ina'an masi ma huma si Yussa' a'a Bet-Semes, pamandogahan ma bay paniya' mahē'. ");
INSERT INTO sml_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Sagō' aniya' a'a pitumpū' hekana bay pinapatay e' Tuhan ma sabab kapang'nda' sigām ni deyom Ba'ul e'. Sakali magdukka saga lūng-kampung sigām ma pasalan hukuman bay pamat'nna' PANGHŪꞋ ma sigām. ");
INSERT INTO sml_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Angkan sigām magpangaruhuy, yuk-i, “Sai bahā' taga-kapatut pa'alop ni si Yawe, ya Tuhan sussi itu? Sai pamabeya'antam Ba'ul itu bo' supaya makala'an min deyomantam?” ");
INSERT INTO sml_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Angkan sigām bay amapehē' saga sosoho'an patukad ni Kiriyat-Jarim angahaka'an saga a'a maina'an pasal palkala' itu, yuk-i, “Itiya' pinabalik e' saga bangsa Pilistin in Ba'ul si Yawe. Bang pa'in kam pi'itu bo' bowahunbi pi'ilu ni lahatbi.” ");
INSERT INTO sml_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Manjari, in Ba'ul si Yawe bay ningā' pehē' ni Bet-Semes e' saga a'a min Kiriyat-Jarim, ati binowa ni luma' si Aminadab maina'an ma būd-būd. Si Eleyasar anak si Aminadab ya bay pinat'nna' anganjagahan Ba'ul si Yawe. ");
INSERT INTO sml_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","At'ggol kamaina'an Ba'ul Paljanji'an ma Kiriyat-Jarim, aniya' saga duwampū' tahun t'ggolna. Ma waktu inān, magdohon sidda kamemon saga bangsa Isra'il maka angamu'-ngamu' na pa'in ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Manjari ah'lling si Samwel ma mahadjana' Isra'il kamemon, yukna, “Bang sab'nnal-b'nnal kam magtaubat min deyom ataybi bo' kam pabalik to'ongan ni si Yawe, timaninbi na saga tuhan-tuhan maka ta'u-ta'u si Astoret ya pagtuhanan bangsa liyu. Pabontolunbi itikadbi ni si Yawe ya Tuhanbi. Ammalunbi iya sadja, ati tantu kam lappasanna min komkoman saga Pilistin itu.” ");
INSERT INTO sml_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Angkan tinaikutan e' bangsa Isra'il kamemon saga Ba'al maka Astoret ya bay pagtuhan-tuhanan sigām bo' angisbat ni si Yawe ma halam aniya' tuhan saddī. ");
INSERT INTO sml_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Sakali ah'lling si Samwel ni saga a'a Isra'il, yukna, “Patimuk kam kamemon ma kauman Mispa bo' kam amu'-amu'anku ni PANGHŪꞋ-Yawe.” ");
INSERT INTO sml_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Ma Mispa pa'in, bay sigām angā' bohe' bo' binu'usan ma matahan si Yawe pangahulmat sigām ma iya. Ma llaw du isab inān magpuwasa sigām kamemon, maka maina'an isab sigām bay magsab'nnal ma PANGHŪꞋ-Yawe, yuk-i, “B'nnal taga-dusa kami ma PANGHŪꞋ.” Manjari maina'an ma Mispa si Samwel ya magmakōk ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Pagta'u pa'in bangsa Pilistin ina'an saga a'a Isra'il magtipun ma Mispa, magtūy magsakap saga nakura' sigām bo' palanjal pina'an bahasa angandugpak. Na, takale pa'in habal itu e' saga a'a Isra'il, magtūy sigām magtāwan ma saga a'a Pilistin. ");
INSERT INTO sml_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Sakali anganjunjung sigām ni si Samwel, yuk-i, “Palanjalun pangamu'-ngamu'nu ni si Yawe ya Tuhantam bo' supaya kitam lappasanna min saga Pilistin itu.” ");
INSERT INTO sml_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Sakali, aniya' bili-bili halam gi' talutas bay ningā' e' si Samwel. Sinumbali' e'na bo' tinunu' pagtukbalna pagtaubatan ni si Yawe. Angamu'-ngamu' na pa'in si Samwel ni PANGHŪꞋ ma pasalan saga ummat Isra'il, jari kinale pangamu'-ngamu'na. ");
INSERT INTO sml_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Na, hinabu si Samwel magtukbal tataubatan ni Tuhan, ina'an na pasekot ba'anan a'a Pilistin amowa magbono' ma saga a'a Isra'il. Saguwā' ma llaw du isab inān, aniya' l'ggon makalandu' kosogna pinaniya' e' si Yawe ma saga sundalu Pilistin angkan landu' asasaw pikilan sigām. Tabowa sigām sikalahian ati tara'ug sigām e' bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Magluwasan magtūy saga magbobono' Isra'il anurul saga Pilistin e'. Jari pinagpapatay sigām e' saga a'a Isra'il ma palabayan sampay makaliyu min kauman Bet-Kār. ");
INSERT INTO sml_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Manjari itu, angā' batu aheya si Samwel bo' pinat'nna' e'na ma llot Mispa maka Sēn. Ebeneser ya pangōnna ma batu inān sabab, yukna, “Si Yawe ya bay anabangan kami sampay pi'itu.” ");
INSERT INTO sml_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Jari tara'ug saga bangsa Pilistin ati halam na magbalik-balik parugpak ni kalahatan bangsa Isra'il. Sat'ggol si Samwel allum gi', niatuhan na pa'in e' si Yawe saga bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Ta'ā' pabalik e' bangsa Isra'il saga kaluma'an min Ekron sampay ni Gāt, kalahatan bay kalongkopan e' bangsa Pilistin ma waktu palabay. Talappas isab min komkoman bangsa Pilistin saga paglahat kasehe' ya ma jadjahan ina'an-i, maka magsulut isab bangsa Isra'il maka bangsa Amor, mbal na magbono'. ");
INSERT INTO sml_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Pasangdan na pa'in si Samwel magmakōk ma bangsa Isra'il sat'ggolna allum. ");
INSERT INTO sml_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Tahun ni tahun, maglibutan iya saga paglahat min jadjahan Betel sampay ni Gilgal maka ni Mispa supaya auntul kapagmakōkna ma saga jama'a Isra'il. ");
INSERT INTO sml_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Saguwā' amole' na pa'in iya ni kauman Rama, ya lahatna porol. Maina'an isab iya amal'ngngan kapagmakōkna ma saga a'a Isra'il. Aniya' isab pagtutukbalan bay nihinang e' si Samwel ma Rama inān pangahulmat ma si Yawe. ");
INSERT INTO sml_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Ato'a pa'in si Samwel, pinat'nna' e'na saga anakna l'lla maghuhukum ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Si Jowel ya ōn anakna kasiyakahan, jari si Abija ya pasunu'. Lahat Be'erseba ya paghuhukuman sigā. ");
INSERT INTO sml_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Sagō' karuwangan anak si Samwel itu halam an'ppu iya ma addat-tabi'at, sabab napsuhan sigā ma pilak. Pagkatambahan sigā, mbal isab abontol pangahukum sigā. ");
INSERT INTO sml_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Angkan magtimuk kamemon pagmatto'ahan bangsa Isra'il bo' pehē' ni si Samwel ma Rama. ");
INSERT INTO sml_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Ah'lling sigām ni iya, yuk-i, “Ato'a na ka, tuwan, maka saga anaknu itu mbal ameya' ma kal'ngnganannu. Na,” yuk sigām, “ahāp lagi' pat'nna'in kami sultan magnakura'an kami buwat bangsa kasehe'.” ");
INSERT INTO sml_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Sagō' ab'nsi si Samwel ma pangamu' sigām, ya mikipat'nna' sultan pagnakura'an sigām, angkan iya angaru ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Anambung PANGHŪꞋ ma si Samwel, yukna, “Dūlin bang ai ya pinahinang e' saga ummat ilu ma ka'a. Asal du ngga'i ka ka'a ya sinulak e' sigām sagō' aku maka kapagsultanku. ");
INSERT INTO sml_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Min waktu gi' bay kapamowaku sigām paluwas min lahat Misil sampay ni kabuwattituhan, sinulak na pa'in aku e' sigām pagka sigām pasumba ni saga tuhan-tuhan saddī. Jari ya du isab ilu ya nihinang e' sigām ma ka'a. ");
INSERT INTO sml_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Na beya'un bang ai kabilahian sigām, sagō' banda'in sigām to'ongan. Pahati'un sigām pahāp bang buwattingga palantara sultan ya song magnakura'an sigām.” ");
INSERT INTO sml_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Manjari, binissala e' si Samwel kamemon bay pangallam ma iya e' PANGHŪꞋ. Yukna ni saga a'a ya angamu' pinat'nna'an sultan, ");
INSERT INTO sml_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","“Buwattitu kahinangan sultan ya song magsultanan ka'am. Ningā' e'na saga ka'anakanbi l'lla nihinang sundalu magbeya' maka saga kalesana pagbobono' maka saga a'ana magpangura'. Kasehe'an anakbi nihinang e'na magpaparagan min dahuan saga kalesana. ");
INSERT INTO sml_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Kasehe'an nihinang e'na pagnakura'an ma saga tumpukan sundalu, ai-na ka ma dangibu, ai-na ka ma limampū'. In kasehe'an isab nihinang e'na maga'araru maka maga'ani ma humana, maka kasehe'an sinō' maghinang saga pakokos pagbobono' maka saga kapanyapan kalesa. ");
INSERT INTO sml_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Ningā' e'na saga ka'anakanbi d'nda bo' maghinang saga ns'llan pahamut, maka magbab'lla, maka maga'addun saga tinapay. ");
INSERT INTO sml_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ningā' e'na saga pagtatanomanbi pai maka tirigu, maka pagtatanomanbi anggul maka jaitun, ingga-ingga ya landu' ahāp, ati pamuwanna ma saga tendogna. ");
INSERT INTO sml_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Ningā' e'na bahagi' sangpū' min saga tirigu maka buwa' anggulbi bo' pamuwanna ma saga tendogna maka ma saga a'a kawakilanna. ");
INSERT INTO sml_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Saga ipatanbi d'nda-l'lla ningā' e'na tahinang sosoho'anna. Saga sapi'bi isab maka kura'bi ya katapusan asambu tapagguna he'na. ");
INSERT INTO sml_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Ningā' isab e'na bahagi' sangpū' min saga kahayopanbi, maka sampay ka'am baranbi binanyaga' e'na. ");
INSERT INTO sml_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","At'kka pa'in waktu inān, parahing du kam ni PANGHŪꞋ-Yawe ma sabab kabinsana'an ya pinaniya'an ka'am e' sultan bay pene'bi inān, sagō' mbal kam kinale e' PANGHŪꞋ ma waktu ina'an.” ");
INSERT INTO sml_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Sagō' halam kinale si Samwel e' saga a'a inān. “Ē! Mbal!” yuk sigām. “Ya kabilahian kami subay aniya' sultan pagmakōkan kami. ");
INSERT INTO sml_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Bilahi kami pasali' ni saga bangsa kasehe'an bo' aniya' sultan magnakura'an kami maka magmunda'an kami bang ni pagbono'an.” ");
INSERT INTO sml_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Pagkale pa'in si Samwel ma kamemon bay pinah'lling e' saga a'a inān, parahing iya pabalik ni PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Angallam PANGHŪꞋ pabīng ma si Samwel, yukna, “Beya'un bang ai kabilahian sigām. Pat'nna'in sigām a'a magsultanan sigām.” Manjari, ah'lling si Samwel ma bangsa Isra'il, “Pehē' na kam,” yukna, “magpole'an pabalik ni kaluma'anbi.” ");
INSERT INTO sml_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Na, aniya' a'a min panubu' Benjamin ga'osan asal maka taga-kaniya'. Ōnna si Kīs ya bay anak si Abiya anak si Seror. Si Seror ya bay anak si Bekorat anak si Apiya, min panubu' si Benjamin du isab. ");
INSERT INTO sml_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Si Kīs itu taga-anak l'lla pinagōnan si Sa'ul. Ahāp l'lla iya, arorog maka labi alanjang min kamemon pagkahina. Halam aniya' sibu'na ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Manjari dakayu' llaw, alungay saga kura' ya suku' si Kīs, angkan iya ah'lling ni anakna si Sa'ul, yukna, “Oto', wa'i alungay saga kura'ta. Amowa ka dakayu' sosoho'anta panehe' ma ka'a bo' piha'unbi pehē'.” ");
INSERT INTO sml_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Sakali, patulak na si Sa'ul maka sosoho'an e' labay min kabūd-būran Epra'im maka min lahat Salisa sagō' halam tabāk e' sigā saga kura' e'. Palanjal na pa'in sigā ni jadjahan Sa'alim sagō' halam du mahē'. Palabay isab sigā min lahat Benjamin, sagō' halam du isab mahē'. ");
INSERT INTO sml_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Ta'abut pa'in jadjahan Sūp, ah'lling na si Sa'ul ma sosoho'an e', yukna, “Sūng na kita amole', ya aniya' ngga'i ka na saga kura' bay alungay ya pinagsusahan e' si mma', sagō' kita na.” ");
INSERT INTO sml_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Saguwā' ya sambung sosoho'an inān ma si Sa'ul, “Tuwan,” yukna, “aniya' ma kaluma'an maitu-itu dakayu' a'a sosoho'an Tuhan. Pinagmahaltabatan iya e' saga a'a kamemon maka atuman lullun pangallamna. Ahāp gi' kita pehē' ni iya, kalu-kalu kita katuli'anna lān pamiha'anta saga kura' he'.” ");
INSERT INTO sml_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Ah'lling si Sa'ul yukna, “Bang kita pehē' ni sosoho'an Tuhan inān, ai tapamuwanta ma iya? Aubus na saga pagkakan bay palutu'ta. Halam na aniya' kabowahanta iya.” ");
INSERT INTO sml_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Anambung pabalik sosoho'an inān, “Tuwan,” yukna, “aniya' gi' maitu dakayu' pisita. Ya itu pamuwanta ma iya bo' kita katuli'an e'na bang ya ingga subay palabayanta.” ");
INSERT INTO sml_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Ma waktu he'-i, “a'a talus” ya pangōn nabi e' bangsa Isra'il. Sai-na bilahi angaru ni Tuhan, ah'lling iya ma sehe'na yukna, “Sūng, pehē' kita ni a'a talus.”) ");
INSERT INTO sml_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Yuk si Sa'ul ni sehe'na inān, “Na aho'. Sūng na kita.” Jari palanjal na sigā ni kaluma'an ya pa'atagan sosoho'an Tuhan inān. ");
INSERT INTO sml_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Hinabu sigām patukad ni būd tudju ni kaluma'an e', talanggal e' sigā saga kabudjangan song anauk bohe', jari tinilaw e' sigā yuk-i, “Saga arūng, itiya' bahā' maitu in a'a talus?” ");
INSERT INTO sml_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","“Aho', tuwan,” yuk sambung saga kabudjangan inān. “Wa'i na iya makarahū min ka'am. Pasa'ut kam. Buwattina'an sadja iya makapi'itu ni kaluma'an kami, sabab aniya' pagkulban tinukbalan e' kampung kami mahē' ma tampat. ");
INSERT INTO sml_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Pagsōdbi ni kaluma'an, tabākbi iya maina'an ma mbal gi' makatukad ni tampat. Mbal magkakanan saga a'a maina'an sat'ggol iya mbal at'kka. Subay ka'amu'anna barakat saga tutukbalan he' bo' magpamangan saga a'a bay tina'abbit. Na, pehē' na kam bo' iya ta'abutbi.” ");
INSERT INTO sml_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Manjari, hinabu si Sa'ul maka sosoho'an inān pasōd ni kaluma'an e', ilu na si Samwel paluwas song patukad ni tampat. ");
INSERT INTO sml_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Aniya' asal bay pamukis e' si Yawe ma si Samwel, dang'llaw dahū lagi' min bay kapina'an si Sa'ul. Yuk pamukis e', ");
INSERT INTO sml_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Salung ma waktu buwattitu du, papi'iluku ni ka'a dakayu' a'a min panubu' Benjamin. Busugin iya ns'llan paltanda'an in iya bay tapene'ku magnakura' ma saga a'aku bangsa Isra'il. Niliyusan e'na saga a'a suku'ku min komkoman bangsa Pilistin. Ta'nda'ku asal katiksa'an sigām, maka takaleku pangandahing sigām.” ");
INSERT INTO sml_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Pag'nda' si Samwel ma si Sa'ul, magtūy angallam PANGHŪꞋ ma iya, yukna, “Ya na itu a'a bay pangahakaku ma ka'a. Iya ya magparinta ma saga a'a suku'ku.” ");
INSERT INTO sml_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Jari pasekot si Sa'ul ni si Samwel ma atag lawang ya pagsōd-luwasan ma kaluma'an inān. Atilaw iya ma si Samwel, yukna, “Tuwan, da'a busung. Makajari bahā' aku pata'unu bang maingga maitu luma' a'a talus e'?” ");
INSERT INTO sml_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Anambung si Samwel, yukna, “Aku na ko' ya patilawannu. Pehē' na kam parahū min aku ni tampat sabab magbeya' kam maka aku amangan llaw itu. Palanjalku kam salung ati hakaku ni ka'a kamemon ya ma deyom pamikilnu ilu. ");
INSERT INTO sml_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ma pasalan isab saga kura' ya bay alungay saga t'llung'llaw palabay, da'a na kasusahun sabab wa'i na tabāk. Sai lagi' niholatan e' bangsa Isra'il, bang ngga'i ka ka'a maka saga a'a kamemon ya pagtai'anak mma'nu?” ");
INSERT INTO sml_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Ya sambung si Sa'ul, “Tuwan,” yukna, “aku itu tubu' min panubu' Benjamin ko', ya tubu' ariki' asal ma bangsa Isra'il, maka pangkat kami itu areyo' min kamemon kapanubu'an Benjamin. Angay angkan ka makapah'lling buwattilu?” ");
INSERT INTO sml_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Manjari binowa patukad e' si Samwel si Sa'ul maka sosoho'an e' ni luma' pagkakanan bo' pinatingkō' min kōkan saga a'a bay tina'abbit he'. Kulang-labi t'llumpū' heka sigām. ");
INSERT INTO sml_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Jari, ah'lling si Samwel ni magb'b'lla, yukna, “Bowahun pi'itu ya isi sumbali'an bay soho'ku pinasaddī ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Na, binowa pina'an e' magb'b'lla ya pa'a susumbali'an bay pinasaddī bo' pinat'nna' ma munda'an si Sa'ul. Yuk si Samwel ma si Sa'ul, “Ya ilu bay tinau'an ka'a. Amangan ka sabab bay ko' itu asal pinasaddīhan ka'a ma palkala' itu, dahū gi' min waktu bay kapana'abbitku saga a'a kasehe'an itu.” Sakali magbeya' amangan si Sa'ul maka si Samwel ma llaw inān. ");
INSERT INTO sml_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Paglūd sigām ni kaluma'an min tampat e', aniya' patulihan sinakapan si Sa'ul ma atop karatagan ya pangatop luma' si Samwel. ");
INSERT INTO sml_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Pagdai' llaw pa'in, hinabu si Sa'ul masi ma diyata' atop e', nilinganan iya e' si Samwel, yukna, “Pabangun ka. Patuntulta ka ni pal'ngnganannu.” Jari asakap pa'in si Sa'ul, magbeya' sigā paluwas min luma'. ");
INSERT INTO sml_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Makat'kka pa'in sigā ni tōng kaluma'an inān, ah'lling si Samwel ni si Sa'ul yukna, “Soho'un na parahū sosoho'annu ilu.” Makarahū pa'in, ah'lling si Samwel ni si Sa'ul yukna, “Maitu gi' ka bo' ka pata'uku pasal lapal bay min Tuhan.” ");
INSERT INTO sml_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Puwas pa'in he'-i, bay angā' si Samwel poga-poga isihan ns'llan jaitun bo' binusugan e'na kōk si Sa'ul. Siniyum isab iya bo' yuk si Samwel, “Ka'a ya tapene' e' si Yawe magnakura' ma saga a'a palsuku'anna, ya na bangsa Isra'il. (Ka'a ya magmakōkan sigām maka angaliyusan sigām min komkoman saga banta sigām. Aniya' isab paltanda'an pamab'nnal in ka'a tapene' na e' si Yawe magsultanan bangsa palsuku'anna.) ");
INSERT INTO sml_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Pagla'annu minnitu, makalanggal ka duwa a'a ma tongod bay pangubulan si Rakiya, ina'an ma lahat Selsa ma tobtoban tana' Benjamin. Buwattitu pamissala saga a'a inān ma ka'a, ‘Wa'i na tabāk saga kura' ya bay pihanu. Ma buwattina'an, ngga'i ka na saga kura' ya pinagsusahan e' mma'nu saguwā' ka'a na. Ya panilawna na pa'in, “Buwattingga e'ku amiha anakku?” ’ ” ");
INSERT INTO sml_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Ah'lling lagi' si Samwel ma si Sa'ul, yukna, “Paglanjalnu min saga a'a he', at'kka ka ni kayu paruwa'ahan ma Tabor. Sinampang ka e' t'llungan l'lla arai' na patukad ni Betel amudji ni Tuhan. Dangan inān amowa t'llu anak kambing, dangan isab amowa t'llu tinapay maka dangan amowa dapangisihan binu-anggul. ");
INSERT INTO sml_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Sinagina ka pahāp e' sigām, maka binuwanan ka tinapay duwa hekana. Da'a taikutin, taima'un sadja. ");
INSERT INTO sml_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","“Pagubus ilu-i, pehē' ka palanjal ni Gibeya ya pinagbahasa Būd Tuhan, ina'an maina'an magpustu saga sundalu Pilistin. Pagsekotnu ni kaluma'an, magbāk ka maka tumpukan nabi lūd bay min tampat. Magbissala sigām kaligawan pagka kahōpan e' Rū Yawe. Aniya' isab min dahuan sigām saga magbibiyula maka magsusuling maka a'a magtaroro'an tambul-tambul. ");
INSERT INTO sml_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Ya du ka'a, kahōpan to'ongan ka e' Rū Yawe ati tabowa ka magbeya' maka saga nabi inān magbissala kaligawan. Tahinang ka sali' a'a saddī na. ");
INSERT INTO sml_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Jari bang paniya' saga paltanda'an itu, hinangun bang ai ya maka'amu ma ka'a, sabab ilu Tuhan taptap pagapi' ma ka'a. ");
INSERT INTO sml_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","“Na, palūd ka parahū min aku ni lahat Gilgal. Paturul du aku ni ka'a bo' anukbal susumbali'an tinunu' maka magduwa'a salamat. Saguwā' ka'a ya subay angagad pitu' llaw sampay aku makapi'ilu, bo' ka katō'anku bang ai subay hinangnu.” ");
INSERT INTO sml_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Manjari, song pa'in paokat si Sa'ul min si Samwel, pinindahan e' Tuhan pangatayan si Sa'ul e'. Atuman isab ma llaw ina'an kamemon saga paltanda'an bay binissala e' si Samwel. ");
INSERT INTO sml_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Pagt'kka disi Sa'ul ni Gibeya, bināk sigām e' tumpukan saga nabi he'. Pahōp isab Rū Tuhan ma si Sa'ul ati tabowa iya palamud ma sigām magbissala kaligawan. ");
INSERT INTO sml_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Ta'nda' pa'in iya he' saga a'a bay magkilahi maka iya, in iya ina'an magbeya' kahōpan e' Rū Tuhan, magtilaw-tilawan sigām dansehe'an yuk-i, “Ai bahā' makani-si Sa'ul ya anak si Kīs inān? Angay, nabi bahā' iya?” ");
INSERT INTO sml_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Jari anambung dakayu' a'a maglahat maina'an, yukna, “Hē, daka sai mma' saga a'a ilu.” Angkan pinagsambatan maina'an, yuk-i, “Nabi hati' si Sa'ul?” ");
INSERT INTO sml_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Na, makahondong pa'in si Sa'ul magbissala, patukad iya ni tampat. ");
INSERT INTO sml_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Sakali tinilaw si Sa'ul maka tendogna e' dakayu' si'itna, yuk-i, “Bay kam maingga?” Ya sambung si Sa'ul, “Bay kami amiha saga kura' si Mma', Bapa'. Saguwā' pagka halam tabāk kami minsan pi'ingga pamiha'an, bay kami pehē' ni si Samwel.” ");
INSERT INTO sml_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Ah'lling si'itna inān, “Oto'”, yukna, “haka'in aku bang ai bay pamissala ma ka'a e' si Samwel.” ");
INSERT INTO sml_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Anambung si Sa'ul yukna, “Ya pamissalana ma kami in kura' si Mma' bay kono' tabāk.” Saguwā' halam nihaka e' si Sa'ul ma si'itna pasalan kapagsultanna ma sinosōng. ");
INSERT INTO sml_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Manjari, pinalinganan e' si Samwel kamemon a'a Isra'il sinoho' pehē' ni lahat Mispa bo' magtimuk ma matahan PANGHŪꞋ-Yawe. ");
INSERT INTO sml_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Maina'an pa'in sigām, yukna ma sigām, “Buwattitu in pagkallam si Yawe ya Tuhantam bangsa Isra'il, yukna, ‘Aku ya bay amowa ka'am paluwas min lahat Misil maka min pang'ntanan saga a'a tag-lahat e' maka min saga bangsa kasehe' ya bay amissoko' ka'am.’ ");
INSERT INTO sml_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Sagō' minsan na, tinaikutan e'bi Tuhanbi ya bay angalappas ka'am min kabinsana'an maka kasiksa'an. Angangut kam gom pa'in mikipat'nna' sultan. Na buwattina'an, pabaihu' kam ma matahan PANGHŪꞋ-Yawe, kamemon kam ma ba'anan kapanubu'anbi magtumpuk-manumpuk.” ");
INSERT INTO sml_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Tapatipun pa'in he' si Samwel kamemon bangsa Isra'il magsunu'-sunu', bangsa Benjamin ya tapene'. ");
INSERT INTO sml_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Jari in panubu' si Benjamin magtumpuk-tumpuk binowa e' si Samwel ni matahan Tuhan, ati tumpukan si Matri ya tapene'. Ma kahinapusanna, si Sa'ul anak si Kīs ya tapene'. Sagō' pagpiha sigām, halam iya tabāk. ");
INSERT INTO sml_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Jari angaru sigām pabīng ni PANGHŪꞋ, yuk-i, “Makapi'itu na bahā' ya a'a tapene' inān?” Anambung PANGHŪꞋ, yukna, “Aho', ina'an iya patapuk ma saga duwa'an.” ");
INSERT INTO sml_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Sakali, magdai'-dai' sigām pehē' angā' si Sa'ul bo' yampa binowa paluwas ni pagtipunan a'a inān. Na alanjang asal iya min kamemon. ");
INSERT INTO sml_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Manjari, ah'lling si Samwel ni saga a'a, yukna, “Nda'unbi na a'a ya bay tapene' e' si Yawe. Halam aniya' sibu'na min kitam itu kamemon.” Magtūy magdakayu' kamemon saga a'a inān angolang, yuk-i, “Mura-murahan pinataha' umul sultan ilu!” ");
INSERT INTO sml_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Pinahati e' si Samwel saga a'a mahadjana' inān pasal hatulan pagsultan. Tasulat e'na kamemon itu ma deyom kitab bo' pinat'nna' ma matahan si Yawe. Pagubus, pinapole' e' si Samwel saga a'a inān pakaniya-pakaniya ni luma' sigām. ");
INSERT INTO sml_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Ya du si Sa'ul, bay du isab amole' ni luma'na ma Gibeya, magbeya' maka saga a'a esogan magbono' ya kabuwanan baya' e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Sagō' aniya' maina'an saga a'a asabul magpah'lling, yuk-i, “Buwattingga he' a'a itu angalappas kitam min saga bantatam?” Ati pinareyo'-deyo' e' sigām si Sa'ul. Halam aniya' huhulmatan binowa e' sigām pagmahaltabat ma iya. Sagō' halam du ah'lling minsan ai si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Na, palabay pa'in saga dambulan, tat'kka da'ira Jabes Giliyad e' si Nahas, ya sultan bangsa Ammon, ati kinumbis e'na bo' mbal makaluwas saga a'a ya maglahat maina'an. Manjari ah'lling sigām ni si Nahas yuk-i, “Magsulut kitam. Magpara'ug kami ma ka'a bang pa'in kami mbal papataynu.” ");
INSERT INTO sml_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Anambung si Nahas, yukna, “Aho', magsulut kitam bang pa'in talugitku dambila' matatam tampal ni kowan bo' supaya aheya kaiya'anbi ma bangsabi Isra'il.” ");
INSERT INTO sml_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Angkan ah'lling saga pagmatto'ahan maina'an, yuk sigām, “Patangguhun kami ma deyom pitu' llaw bo' pinasaplag kahālan itu ma katilingkal Isra'il. Bang halam sai-na anabang kami, lilla' na kami magpalongkop ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Manjari, pehē' saga magbobowa lapal ni Gibeya ya kauman palahatan si Sa'ul. Kahaka'an pa'in saga a'a maina'an ma pasalan palkala' he', magtūy sigām maglemong kamemon. ");
INSERT INTO sml_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Salta' ma waktu ina'an, at'kka si Sa'ul maka saga sapi'na bay min huma. Jari atilaw iya, yukna, “Ai kasusahan saga a'a itu? Angay sigām maglemongan?” Ati nihaka'an iya pasal bay pamissala saga a'a Jabes he'. ");
INSERT INTO sml_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Pagkale si Sa'ul ma bissala itu, magtūy pahōp ni iya Rū Tuhan, jari akagit atayna, mbal agon kasandalanna. ");
INSERT INTO sml_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Ningā' e'na duwa sapi' bo' pinagkehet-kehet, ati pinabowa kehetanna ni katilibut Isra'il pamowahan banda'na ma saga a'a kamemon. Yukna, “Buwattitu tumaluwa' ni saga kahayopan sasuku tag-dapuna mbal maguyun ameya' ma si Sa'ul maka si Samwel.” Sakali, kasōran tāw kamemon bangsa Isra'il min kahandak PANGHŪꞋ-Yawe, angkan sigām magda'atay ameya' ma si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Manjari, pinatipun e' si Sa'ul ma kauman Besek saga kal'llahan, aniya' t'llu hatus ngibu heka sigām min Isra'il maka t'llumpū' ngibu min Yuda. ");
INSERT INTO sml_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Ah'lling disi Sa'ul ma saga magbobowa lapal bay min Jabes e', yuk-i, “Pata'uhunbi saga a'a Jabes Giliyad, yukbi, ‘Salung, song pa'in ugtu llaw, alappas na kam.’ ” Kahaka'an pa'in saga a'a Jabes inān, landu' aheya kakōgan sigām, ");
INSERT INTO sml_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","ati yuk sigām ni saga a'a bangsa Ammon, “Pagsalung, lilla' na kami magpalongkop ma ka'am. Tahinangbi na ma kami bang ai kabaya'anbi.” ");
INSERT INTO sml_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Sagō' ma sangom ina'an du, bay binahagi' t'llu e' si Sa'ul saga sundaluna. Ma halam lagi' pak'llat mata llaw, tasōd e' sigām pustu saga bangsa Ammon bo' binono' e' sigām sampay ta'abut alanga llaw. Sasuku halam tapapatay bay makalahi pakaniya-kaniya. ");
INSERT INTO sml_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Na pagka buwattē', ah'lling saga a'a Isra'il ma si Samwel, yuk sigām, “Sai sa saga a'a bay mbal bilahi pinagsultanan e' si Sa'ul? Pabowahun sigām pi'itu bo' papatay kami.” ");
INSERT INTO sml_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Saguwā' amissala si Sa'ul yukna, “Mbal aniya' minsan sai-na pinapatay ma llaw itu. Sabab ya itu llaw kapamuwan da'ugan e' PANGHŪꞋ-Yawe ma bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Manjari ah'lling si Samwel ma saga a'a Isra'il yukna, “Sūng kitam ni Gilgal ati mahē' kitam amatuman pagsultan si Sa'ul.” ");
INSERT INTO sml_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Sakali, pehē' ni Gilgal kamemon saga ummat Isra'il bo' pinatuman e' sigām pagsultan si Sa'ul maina'an ma matahan si Yawe. Maina'an isab sigām bay magduwa'a salamat ni si Yawe. Pagubus, aheya paglami-lami disi Sa'ul maka kamemon saga bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Sakali ah'lling si Samwel ni saga bangsa Isra'il, yukna, “Bay na beya'ku kamemon pangamu'bi ya mikipat'nna' kam sultan. ");
INSERT INTO sml_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Na buwattina'an, ilu na aniya' sultan magnakura'an ka'am. In aku itu ato'a na, sagō' ilu du saga anakku l'lla ma deyomanbi ganti'ku. Min kabata'ku sampay ni buwattina'an bay aku magnakura'an ka'am. ");
INSERT INTO sml_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Itiya' aku pa'alop ma ka'am. Bang aniya' panuna'bi ma aku, saksi'inbi ma baihu'an PANGHŪꞋ-Yawe maka ma baihu'an sultan ya tapene'na itu. Sai bahā' ma ka'am bay katangkawanku sapi'na atawa kura'na? Sai ma ka'am bay ka'akkalanku? Sai ma ka'am bay pissoko'ku? Bay bahā' aku katambahan he' sai-na ma ka'am bo' supaya abengkok hukumanku? Bang bay tahinangku saga kahinangan itu minsan la'a hal dakayu', pabontolku na buwattina'an.” ");
INSERT INTO sml_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Manjari anambung saga bangsa Isra'il inān, yuk sigām, “Halam kami bay akkalannu atawa pissoko'nu. Halam ka bay anangkawan sai-na ma kami.” ");
INSERT INTO sml_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Yuk si Samwel ni sigām, “Llaw itu, saksi'tam PANGHŪꞋ maka sultan ya tapene'na itu, in aku mbal katōnganbi dusa.” “Aho',” yuk sambung sigām, “PANGHŪꞋ-Yawe ya saksi'tam.” ");
INSERT INTO sml_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Manjari ah'lling si Samwel, “Si Yawe ya bay amene' si Musa maka si Harun, maka Tuhan ya bay amowa saga ka'mbo'-mbo'anbi paluwas min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Na, da'a kam ala'an m'nnilu sabab bontolanta kam maitu ma baihu'an PANGHŪꞋ-Yawe pasal saga kahāpan bay tahinang he'na ma ka'am maka saga ka'mbo'anbi. ");
INSERT INTO sml_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","“Ma Misil pa'in disi Yakub, bay sigām parahing ni si Yawe angamu' tabang, ati pinabeya'an sigām si Musa maka si Harun. Sigā ya bay amowa saga ka'mbo'anbi paluwas min Misil tudju pi'itu ni lahat ītu. ");
INSERT INTO sml_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Saguwā' takalipat e' sigām si Yawe ya Tuhan sigām, angkan sigām bay pinasagaran he'na bo' tara'ug he' si Sisera ya pagnakura'an saga sundalu si Hasor. Bay isab sigām ni'nde'an ni komkoman saga bangsa Pilistin sampay sultan bangsa Mowab ya bay anguntarahan sigām. ");
INSERT INTO sml_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Pagka buwattē', bay angandahing isab saga a'a Isra'il ni PANGHŪꞋ, yuk-i, ‘Ya Tuhan, aheya landu' dusa kami ma ka'a. Sabab bay ka taikutan kami pasumba ma saga ta'u-ta'u Ba'al maka Astoret. Lappasun kami min saga banta kami itu ati pabalik kami angisbat ka'a sadja.’ ");
INSERT INTO sml_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Sakali bay pinabeya' he' PANGHŪꞋ si Jerub-Ba'al (ya niōnan isab si Gidiyun) bo' si Barak, ati bo' si Jepta, maka aku ya katapusan. Angkan kam bay kalappasan e'na min pang'ntanan saga kabantahanbi paruruwambila' bo' halam aniya' makarugpak ni lahatbi. ");
INSERT INTO sml_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“Saguwā',” yuk si Samwel, “pag'nda'bi pa'in song parugpak ni ka'am si Nahas ya sultan bangsa Ammon, subay kam angangut mikipat'nna' sultan magnakura'an ka'am. Buwattē' pangamu'bi ma aku minsan du Tuhan Yawe ya sultanbi. ");
INSERT INTO sml_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Na”, yuk si Samwel, “itiya' na in sultan bay pene'bi, ya bay amu'bi. Nda'unbi pahāp, aniya' na sultan pinat'nna'an ka'am he' PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Jari ahāp kahālanbi bang pa'in kam magmatāw ma PANGHŪꞋ, bang kam angisbat iya, bang mbal sagga'bi saga panoho'anna, bang ka'am maka sultan ya magnakura'an ka'am atukid ameya' ma si Yawe ya Tuhanbi. ");
INSERT INTO sml_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Saguwā', bang kam mbal ameya' ma si Yawe ati sagga'bi gom pa'in saga panoho'anna, taptap kam pinat'kkahan bala', buwat bay pamat'kkana ma saga ka'mbo'anbi. ");
INSERT INTO sml_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","“Na, da'a kam ala'an min pan'nggehanbi ilu bo' kam maka'nda' in hinang makainu-inu ya song nihinang e' PANGHŪꞋ-Yawe ma matahanbi. ");
INSERT INTO sml_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ta'abut na musim pagani tirigu, musim mbal pangulan. Sagō' angamu'-ngamu' aku ni PANGHŪꞋ bang pa'in pinal'ggon maka pinaulan. Ati minnē' tasayubi bang buwattingga heya kala'atan bay tahinangbi ma matahan PANGHŪꞋ pagka kam angangut subay mikipat'nna' sultan.” ");
INSERT INTO sml_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Manjari angamu'-ngamu' si Samwel ati aniya' l'ggon maka ulan pinaniya' e' PANGHŪꞋ ma llaw ina'an du. Angkan kamemon saga a'a maina'an sinōd tāw ma PANGHŪꞋ maka ma si Samwel. ");
INSERT INTO sml_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Ah'lling sigām ni si Samwel, yuk-i, “Amu'-amu'in kami ni si Yawe ya Tuhannu bo' supaya kami mbal pinapatay. Bay ganapan kami saga dusa kami ma sabab kapangangut kami subay mikipat'nna' sultan.” ");
INSERT INTO sml_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Anambung si Samwel yukna, “Da'a kam tināw. B'nnal aheka paldusahan bay tahinangbi, sagō' minsan na, da'a taikutinbi si Yawe. Wajib iya subay ni'isbat min deyom ataybi. ");
INSERT INTO sml_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Da'a kam pasiha' min iya bo' maghinang ni saga tuhan-tuhan halam kapūsanna, sabab halam du aniya' kahāpan tahinang sigām ma ka'am. Mbal sigām makalappasan ka'am. ");
INSERT INTO sml_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Kasulutan si Yawe angahinang ka'am bangsa palsuku'anna, angkan kam mbal siniya-siya he'na supaya mbal tasalla' ōnna babantugun. ");
INSERT INTO sml_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","In aku isab,” yuk si Samwel, “mbal bilahi amakay dusa ni PANGHŪꞋ-Yawe, angkan aku mbal pahali angamu'-ngamu'an ka'am tabang. Pandu'anta kam isab addat-tabi'at ahāp maka abontol. ");
INSERT INTO sml_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Amay-amay, pagmatāwinbi si Yawe maka isbatunbi iya min deyom ataybi. Entomunbi to'ongan saga kahāpan makainu-inu ya bay tahinang e'na ma ka'am. ");
INSERT INTO sml_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Sagō' bang kam pasangdan na pa'in angahinang kala'atan, tantu ka'am maka sultanbi ilu aligis.” ");
INSERT INTO sml_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","T'llumpū' tahun umul si Sa'ul waktu iya tahinang sultan ati mpatpū' maka duwantahun ya t'ggol kapagsultanna ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Na, si Sa'ul itu bay amene' sundalu t'llungibu hekana min bangsa Isra'il. Duwangibu sigām bay ma si Sa'ul ma kauman Mikmas maka ma kabūd-būran Betel, dangibu takapin bay ma si Jonatan ma Gibeya, ya ma paglahat bangsa Benjamin. Maka sasuku halam tapene' e' si Sa'ul bay pinapole' ni kaluma'an sigām. ");
INSERT INTO sml_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Na, tarugpak e' si Jonatan pustu bangsa Pilistin ma lahat Geba angkan tasayu e' saga Pilistin in bangsa Hibrani angatu na. Manjari amah'lling si Sa'ul tiyup-tiyup ma katilingkal bangsa Isra'il supaya sigām magsakap amono'. ");
INSERT INTO sml_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Minnē' takale e' kamemon bangsa Isra'il in habal itu, ya yukna, “Tarugpak pustu Pilistin e' si Sa'ul, ati aheya na kab'nsi sigām ma kitam bangsa Isra'il.” Angkan magpanoho'an si Sa'ul ma saga a'a Isra'il, sinō' patipun ma lahat Gilgal. ");
INSERT INTO sml_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Manjari, magtimukan na saga bangsa Pilistin bo' magsakap amono' bangsa Isra'il. Landu' aheka saga Pilistin e', t'llungibu heka kalesa sigām pagbobono', nnom ngibu saga sundalu magkakalesa. Ya sundalu sigām magtinape' sali' heka solagan gusung ma tampe. Patukad sigām magpustu ma Mikmas, tampal ni sobangan min Bet-Aben. ");
INSERT INTO sml_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Pag'nda' saga sundalu bangsa Isra'il in sigām kapilahan ma sabab kapaslod pagdugpak bangsa Pilistin, magtūy sigām sikatapukan ma saga songab batu, ma deyom kasagmotan, ma lugal kabatuhan, maka ma saga lowang bay kinalian. ");
INSERT INTO sml_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Aniya' isab saga Hibrani kasehe'an bay pauntas ni dambila' sapa' Jordan tudju ni lahat Gād maka Giliyad. Saguwā' si Sa'ul bay magpa'bba ma Gilgal ati magpamidpid kamemon saga kasundaluhan bay ameya' ma iya kabowa tāw sigām. ");
INSERT INTO sml_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Dapitu' ya pangagad si Sa'ul maina'an buwat bay panugun e' si Samwel ma iya. Na, halam pa'in at'kka si Samwel, magkanat-kanat na saga sundalu bay maina'an ma si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Angkan ah'lling si Sa'ul, yukna, “Bowahinbi aku hayop pagtaubat maka tutukbalan pagduwa'aku salamat.” Manjari bay tinukbalan e' si Sa'ul hayop tinunu'. ");
INSERT INTO sml_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Pagubus, at'kka si Samwel ati paluwas si Sa'ul min kaluma'an anampang iya maka anagina. ");
INSERT INTO sml_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Yuk si Samwel ma iya, “Ai bay hinangnu itu?” Anambung si Sa'ul, yukna, “Ta'nda'ku magkaukanat saga a'aku maka halam ka makat'kka ma waktu bay panugunnu. Ina'an isab saga sundalu Pilistin magtimuk ma Mikmas. ");
INSERT INTO sml_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Tapikilku in bangsa Pilistin arai' parugpak pi'itu ni Gilgal ma halam aku minsan makapangaru ni PANGHŪꞋ-Yawe. Angkan aku bay magniyat magtukbal saga tutukbalan tinunu' itu.” ");
INSERT INTO sml_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Ya sambung si Samwel ma si Sa'ul, yukna, “Dupang pahāp ka magkahinangan buwattilu! Halam bay bogbogannu panoho'an PANGHŪꞋ ma ka'a. Bang ka bay magkahagad, tuman ka'a maka saga panubu'nu pinapagsultan ma bangsa Isra'il ni kasaumulan. ");
INSERT INTO sml_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Saguwā', pagka ka halam bay ameya' ma panoho'an PANGHŪꞋ ma ka'a, mbal anatas kapagsultannu. Aniya' tapihana a'a makasulut pangatayanna, ati tapat'nna' na e'na magmakōk ma saga ummat ya palsuku'anna.” ");
INSERT INTO sml_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Pabuhat magtūy si Samwel bo' palanjal min Gilgal ni Gibeya ya ma paglahat Benjamin. Malaingkan si Sa'ul bay angitung saga sundalu ya beya' ma iya, nnom hatus heka sigām. ");
INSERT INTO sml_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Na, ina'an disi Sa'ul maka anakna si Jonatan pahanti' ma Gibeya, beya' isab saga sundalu sigām, samantala' wa'i masi ma Mikmas magpustu saga sundalu Pilistin. ");
INSERT INTO sml_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Magbahagi' t'llu saga sundalu Pilistin itu bo' angandugpak bangsa Isra'il. Datumpuk inān bay patudju ni kauman Opra ya ma jadjahan lahat Suwal, ");
INSERT INTO sml_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","datumpuk bay pehē' tudju ni Bet-Horon, jari in tumpuk kat'lluna bay pehē' ni kareyahan min diyata'an karatagan Seboyim, ya paharap ni paslangan. ");
INSERT INTO sml_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Ma waktu ina'an-i, halam aniya' minsan dakayu' magsasasal ma katilingkal Isra'il sabab mbal nirūlan e' bangsa Pilistin. Tināw asal sigām in saga bangsa Isra'il angahinang pakokos di-sigām. ");
INSERT INTO sml_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Angkan saga bangsa Isra'il subay pehē' ni saga bangsa Pilistin magpa'asa' kapanyapan sigām taga-solab, buwat saga paga'araru, saga sangkul, saga kapa maka sanggot. ");
INSERT INTO sml_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Duwa sīn tibu'uk ya halga' pagpa'asa' solab paga'araru maka sangkul, dakayu' sīn tibu'uk ya halga' isab pagpa'asa' tugsuk a'aslag maka kapa maka tōng tungkud. ");
INSERT INTO sml_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Jari halam aniya' minsan dakayu' min sundalu Isra'il magtakos kalis atawa budjak ma llaw pagbono' inān, luwal si Sa'ul maka anakna si Jonatan. ");
INSERT INTO sml_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Na, aniya' tumpukan sundalu Pilistin bay sinō' anunggu'an lān ya palabayan ma kapampangan Mikmas. ");
INSERT INTO sml_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Dakayu' llaw ah'lling si Jonatan anak si Sa'ul ni onde' baha'u ya magbobowa pakokosna, yukna, “Sūng kita pehē' ni pustu saga sundalu bangsa Pilistin ya ma dambila' inān.” Sagō' halam pinata'u mma'na. ");
INSERT INTO sml_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Pasalta', ina'an si Sa'ul maka nnom hatus sundaluna magpustu ma deyo'an kayu dalima' ma Meglon, ya ma tobtoban lahat Gibeya. ");
INSERT INTO sml_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Beya' isab maina'an si imam Ahidja ya tag-bowahan epod. Si Ahidja itu anak si Ahitub ya danakan si Ikabod. Mma' sigā si Pinehas anak si Eli ya bay maghinang ni si Yawe ma Silo. Sagō' halam sai-na makasayuhan kalikut si Jonatan e'. ");
INSERT INTO sml_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Na, aniya' pampang min karuwambila' lān ya palabayan si Jonatan tudju ni pagpustuhan saga sundalu Pilistin. Boses ya pangōn ma pampang dambila', Sene ya pangōn ma dambila'. ");
INSERT INTO sml_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Pa'anggop ni Mikmas ya pampang tampal ni uttala', pa'anggop ni Geba ya pampang tampal ni tunggara'. ");
INSERT INTO sml_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Sakali, ah'lling si Jonatan ni magbobowa pakokosna inān yukna, “Sūng kita pehē' ni pustu bangsa kapil inān. Kalu mura-murahan kita tinabangan e' PANGHŪꞋ-Yawe. Tuman halam aniya' makapaggat bang iya ya amuwan da'ugan, ai naka aheka kitam atawa akulang.” ");
INSERT INTO sml_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Anambung magbobowa pakokos inān, yukna, “Pē'un tuwan, palanjalun bang ai maksudnu. Itiya' du aku ameya' ma ka'a minsan ai tumaluwa'.” ");
INSERT INTO sml_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Ya pah'lling si Jonatan, “Sūng! Pehē' kita magpa'nda' ma sigām. ");
INSERT INTO sml_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Bang sigām ah'lling ni kita, yuk-i, ‘Angagad gi' kam mailu ati pi'ilu kami,’ na maitu sadja kita, mbal kita palanjal. ");
INSERT INTO sml_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Sagō' bang yuk sigām, ‘Patukad kam pi'itu’, na patukad kita sabab ya ina'an paltanda'an in da'ugan pamuwan ma kita e' si Yawe.” ");
INSERT INTO sml_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Sakali, magpa'nda' pa'in sigā karuwangan ni pustu saga Pilistin he', magtūy sigām ah'lling, yuk-i, “Allā! Nda'unbi ba saga Hibrani ilu, ilu na sikaluwasan min saga lowang bay patapukan sigām!” ");
INSERT INTO sml_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Jari angolang saga a'a ma pustu inān ni si Jonatan maka ni magbobowa pakokosna he', “Pasōng kam pi'itu bo' kam l'ggahan!” Angkan ah'lling si Jonatan ni sehe'na inān yukna, “Paturul ka ma aku. Tuman pamuwan in da'ugan e' si Yawe ma bangsa Isra'il.” ");
INSERT INTO sml_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Parāg si Jonatan min pampang ati paturul min buli'anna magbobowa pakokosna inān. Tapapatay he' si Jonatan saga sundalu Pilistin, maka ina'an isab sehe'na amapatay min buli'anna. ");
INSERT INTO sml_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Jari duwampū' heka Pilistin bay tapapatay ma kapangandugpak sigā kamint'dda inān. Akiput asal lugal bay pagbono'an e'. ");
INSERT INTO sml_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Manjari, ahiluhala' kamemon saga sundalu Pilistin kabowa tāw sigām. Ahiluhala' sigām ma deyom pustu, ahiluhala' sigām ma deya, ahiluhala' isab saga tumpukan magdurugpak. Magbeya' isab ajogjog tana' sabab in tāw inān bay pinaniya' e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Aniya' saga sundalu si Sa'ul ma Gibeya-Benjamin bay amantawan lahat ma sakalibut sigām, ati ta'nda' e' sigām saga sundalu Pilistin magkaukanat pehē'-pi'itu. ");
INSERT INTO sml_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Magtūy ah'lling si Sa'ul ni saga a'a ya sehe'na, yukna, “Patipununbi saga sundalutam kamemon bo' nda'unbi bang sai halam maitu.” Pag'nda' sigām, luwal si Jonatan maka magbobowa pakokosna ya halam maina'an. ");
INSERT INTO sml_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Ati ah'lling si Sa'ul ni imam Ahidja, yukna, “Bowahun pi'itu Ba'ul Paljanji'an Tuhan ilu.” (Ma waktu itu-i in Ba'ul Tuhan ina'an asal ma bangsa Isra'il.) ");
INSERT INTO sml_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Na, hinabu si Sa'ul amissala ni imam e', paruhun na pa'in kalengogan ma pustu saga bangsa Pilistin. Angkan yuk si Sa'ul ma imam e', “Pasagarin na.” ");
INSERT INTO sml_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Sakali, magsakaum si Sa'ul maka kamemon saga sundaluna bo' pakuyas ni pagbono'an. Anā, landu' aheya in kalengogan ma saga sundalu bangsa Pilistin sabab ina'an sigām magpatay dansehe'an. ");
INSERT INTO sml_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Aniya' saga Hibrani bay asal palamud ma bangsa Pilistin bo' dambeya'an maka sigām ma deyom pustu, sagō' papinda na sigām ni saga sundalu Isra'il ya bay ma disi Sa'ul maka si Jonatan. ");
INSERT INTO sml_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Sampay saga bangsa Isra'il ya bay sikatapukan ma kabūd-būran lahat Epra'im ameya' na isab angapas pagkale sigām in saga sundalu Pilistin wa'i na maglahian. ");
INSERT INTO sml_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Jari talappas bangsa Isra'il e' si PANGHŪꞋ-Yawe ma llaw ina'an du, ati palanjal na pa'in pagbono' inān sampay ni dambila' Bet-Aben. ");
INSERT INTO sml_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Na, ma llaw ina'an-i, landu' abinsana' saga sundalu bangsa Isra'il sabab bay makasubali si Sa'ul, yukna, “Bang pa'in pinagmulka'an sai-sai anginam takakan ma mbal gi' s'ddop llaw. Subay aku makabalosan saga bantaku dahū!” Angkan halam sai-na anawakkal amangan sampay ni kakohapan. ");
INSERT INTO sml_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Sakali itu, makat'kka pa'in kamemon sundalu inān ni dakayu' gulangan, aniya' gula' buwani maina'an ma kuwit tana'. ");
INSERT INTO sml_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Pagsōd sigām pehē', ta'nda' e' sigām gula' buwani inān magdayas-dayas, saguwā' halam aniya' minsan dakayu' min sigām makatawakkal an'nno'an tōng tanganna pina'an sabab kabowa tāw sigām ma bay panubali sultan Sa'ul e'. ");
INSERT INTO sml_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Saguwā', pagka halam bay takale e' si Jonatan panubali mma'na, bay pina'abut tōng tungkudna ni gula' inān bo' kininaman e'na. Pagkakanna pa'in, pasawa magtūy pamaihu'anna pagka ahāp na palasahanna. ");
INSERT INTO sml_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Nihaka'an iya magtūy e' dakayu' sundalu bay maina'an. “Tuwan,” yukna, “kami saga sundalu bay pinagsapahan e' mma'nu, sinō' mbal amangan ai-ai llaw itu. Pinagmulka'an kono' kami. Angkan ko' kami itu pinunung na e' lingantu.” ");
INSERT INTO sml_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Anambung si Jonatan, yukna, “Allā, aheya kasasawan pamat'kka e' mma'ku ma kitam kamemon! Nda'unbi ba kahāp palasahanku pagkakanku gula' buwani itu minsan la'a hal dangkuri'.” ");
INSERT INTO sml_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Yukna lagi', “Luba'na na bahā' bang kam bay makakakan ai-ai ya tatabanbi min saga bantatam. Marai' aheka lagi' bangsa Pilistin bay tapapatay.” ");
INSERT INTO sml_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Ma llaw ina'an, tapapatay e' bangsa Isra'il saga bangsa Pilistin tinagna'an min Mikmas sampay ni jadjahan Ayjalon. Pagubus, landu' apaya saga a'a Isra'il sabab lingantu. ");
INSERT INTO sml_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Angkan pinagagawan e' sigām saga bili-bili maka hayop bay tataban e' sigām bo' sinumbali' saru'un-du'un. Agsai pinagkakan e' sigām minsan masi laha'an, kabowa lingantu sigām. ");
INSERT INTO sml_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Ati aniya' makasumbung ma si Sa'ul, yukna, “Tuwan, makapakay dusa ni PANGHŪꞋ saga a'anu sabab wa'i sigām amangan sumbali'an masi taga-laha'.” Yuk si Sa'ul, “Saga panipu! Pagulungunbi saru'un-du'un pi'itu batu aheya.” ");
INSERT INTO sml_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Magpanoho'an gi' iya, yukna, “Pehē'unbi saga a'a he' bo' soho'unbi amowa pi'itu saga sapi' maka bili-bili sigām dangan maka dangan. Soho'unbi sigām anumbali' maka amangan maitu. Subay sigām mbal amakay dusa ni PANGHŪꞋ pagka sigām amangan sumbali'an masi taga-laha'.” Angkan ma sangom ina'an du, amowa sigām pakaniya-pakaniya saga sapi' maka bili-bili sigām bo' sinumbali' maina'an. ");
INSERT INTO sml_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Anambak isab batu si Sa'ul pagkulbanan ni PANGHŪꞋ-Yawe. Yampa aniya' pagkulbanan tahinang e'na. ");
INSERT INTO sml_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Manjari ah'lling si Sa'ul, “Sangom itu,” yukna, “parugpak kitam ni saga bangsa Pilistin. Gora'tam ai-ai sigām kamemon ati papatayta sigām kamemon sampay ni kasubuhan.” Anambung saga sundalu inān, “Hinangun tuwan bang ai taluwa' ma pikilannu.” Sagō' ya panambung imam, “Subay kitam angaru dahū ni Tuhan.” ");
INSERT INTO sml_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Angkan angaru si Sa'ul ni Tuhan yukna, “Ya Tuhan, parugpak na bahā' kami ni bangsa Pilistin? Pamuwannu bahā' in da'ugan ma bangsa Isra'il?” Saguwā' halam aniya' sambung Tuhan ma llaw ina'an. ");
INSERT INTO sml_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Pagka buwattē', ah'lling si Sa'ul ni saga nakura' ma tumpukan sundalu. “Pasōng kam pi'itu,” yukna, “bo' tata'u bang ai dusa bay tahinangtam ma llaw itu. ");
INSERT INTO sml_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Sapahanku ma ōn si Yawe ya Manglalappas ma bangsa Isra'il, sai-sai katōngan dusa itu minsan anakku si Jonatan, subay pinapatay.” Sagō' halam makapamūng saga a'a inān minsan dangan. ");
INSERT INTO sml_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Ah'lling lagi' si Sa'ul ni kamemon saga a'a Isra'il, yukna, “Mailu kam ma dambila', ati aku maka anakku si Jonatan maitu isab ma dambila' itu.” Jari anambung saga a'a maina'an, “Ka'a ya magkabaya'an, tuwan.” ");
INSERT INTO sml_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Sakali angamu'-ngamu' si Sa'ul ni si Yawe ya pagtuhanan bangsa Isra'il, yuk-i. “Ya PANGHŪꞋ, pata'uhun ni kami bang sai bay makarusa.” Magko'ot-ko'ot pa'in, tasayu ngga'i ka saga sundalu ya bay tag-dusahan, sabab si Jonatan maka si Sa'ul ya tako'ot. ");
INSERT INTO sml_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Magtūy ah'lling si Sa'ul, yukna, “Pagko'ot-ko'otinbi bang sai ma kami maka si Jonatan ya bay makarusa.” Jari si Jonatan ya tako'ot. ");
INSERT INTO sml_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Na, ah'lling si Sa'ul ni si Jonatan, yukna, “Haka'in aku bang ai bay tahinangnu?” Anambung si Jonatan, “Bay t'nno'anku tōng tungkudku ni gula' buwani bo' bay kinamanku dangkuri'. Na, patut bahā' aku subay pinapatay?” ");
INSERT INTO sml_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","“Aho' Jonatan” yuk si Sa'ul. “Bang pa'in aku pinat'kkahan mulka' e' Tuhan bang ka mbal papatayku.” ");
INSERT INTO sml_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Saguwā' yuk saga sundalu ni si Sa'ul, “Si Jonatan ya bay angaliyusan bangsatam Isra'il min kamulahan! Angay iya subay pinapatay? Mbal patut! Anapa kami ma ōn si Yawe ya Tuhan kakkal, in si Jonatan subay mbal ni'inay, sabab Tuhan ya bay anabangan iya ma bay tahinangna llaw itu.” Angkan kaliyusan si Jonatan e' saga a'a inān ati halam bay pinapatay. ");
INSERT INTO sml_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Manjari itu, pahondong na si Sa'ul angapas saga bangsa Pilistin angkan sigām magsuhutan na ni kalahatan sigām. ");
INSERT INTO sml_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Min waktu tagna' kapagsultan si Sa'ul ma Isra'il, niatuhan e'na saga banta sigām min paruruwambila'. Ya na bangsa Mowab, bangsa Ammon, bangsa Edom, saga sultan bangsa Soba, maka bangsa Pilistin. Minsan pi'ingga parugpakan si Sa'ul maka saga sundaluna, anganda'ug sadja sigām. ");
INSERT INTO sml_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Aesog e'na amono' ati tara'ug bangsa Amalek. Talappas e' si Sa'ul bangsa Isra'il min komkoman saga a'a bay makalangpasan ai-ai sigām. ");
INSERT INTO sml_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Ya itu saga anak si Sa'ul l'lla: si Jonatan bo' si Isboset maka si Malki-Suwa. Anakna d'nda kasiyakahan ya na si Merab, maka si Mikal ya kasiyalihan. ");
INSERT INTO sml_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Ōn h'nda si Sa'ul ya na si Ahinowam anak si Ahima'as. Ōn a'a ya nakura' katapusan alanga ma saga sundaluna ya na si Abner. Magkaki si Sa'ul maka si Abner itu pagka ");
INSERT INTO sml_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","magdanakan mma' sigām. Si Kīs ya mma' si Sa'ul, maka si Nēr ya mma' si Abner. Si Abiyel ya bay mma' sigā. ");
INSERT INTO sml_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Magbono' na pa'in bangsa Pilistin maka bangsa Isra'il sampay ni waktu kamatay si Sa'ul, halam aniya' halianna. Bang aniya' a'a akosog atawa aesog ta'nda' e' si Sa'ul ma bangsa Isra'il, ningā' magtūy e'na magsundalu. ");
INSERT INTO sml_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ah'lling si Samwel ma si Sa'ul yukna, “Aku ya bay pinabeya' e' PANGHŪꞋ amusugan ka'a ns'llan bo' ka pinat'nna' magsultan ma bangsa Isra'il, ya bangsa suku'na. Na, kalehun pahāp kallam PANGHŪꞋ Sangat Kawasa, ");
INSERT INTO sml_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","ya yuk-i, ‘Tungbasanku bangsa Amalek ma sabab bay kapangahapa' sigām bangsa Isra'il waktu kaluwas sigām min lahat Misil. ");
INSERT INTO sml_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Na, buwattina'an, pehē' na ka, dugpakun bangsa inān. Laglagun sigām kamemon maka paka'atun ai-ai palsuku'an sigām. Da'a kapinin minsan dangan. Papatayun sigām kamemon d'nda-l'lla sampay ni onde'-onde' maka anak-duru'an. Papatayun isab saga kahayopan sigām, ai naka sapi', ai naka bili-bili, ai naka unta' sampay kura'. Papatayun kamemon.’ ” ");
INSERT INTO sml_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Sakali pinalinganan e' si Sa'ul saga a'ana magbobono', sinō' patipun ma da'ira Tela'im. Jari duwahatus ngibu sundalu magtinape' ya bay patipun pina'an, maka sangpū' ngibu isab min bangsa Yuda. ");
INSERT INTO sml_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Na, pehē' disi Sa'ul tudju ni da'ira bangsa Amalek ati patapuk ma kal'bbakan bo' anipihan sigām. ");
INSERT INTO sml_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Jari magbanda' si Sa'ul ma bangsa Kēn, yukna, “Ala'an kam min deyoman saga bangsa Amalek ilu bo' kam mbal talapay pinapatay, sabab aheya kahāpan bay hinangbi ma bangsa Isra'il waktu kaluwas sigām min lahat Misil.” Angkan paokat minna'an saga bangsa Kēn. ");
INSERT INTO sml_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Sakali itu, parugpak disi Sa'ul ni bangsa Amalek, tinagna'an min Habila sampay ta'abut Sūr, ya lahat ma bihing Misil tampal ni sobangan. ");
INSERT INTO sml_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Tapapatay e' sigām kamemon saga sundalu Amalek inān sagō' si Agag ya sultan sigām hal bay sinaggaw. ");
INSERT INTO sml_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","In si Agag maka saga hayop ya katapusan ahāp, maka saga anak hayop ya asambu, halam bay ni'inay e' disi Sa'ul maka saga a'ana. Ahuskaw sigām amaka'at ai-ai ahāp angkan aniya' lagi' allum maka takapin. Sagō' sasuku halam kapūsanna bay nilaglag katūyan e' sigām. ");
INSERT INTO sml_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Manjari angallam PANGHŪꞋ ma si Samwel, yukna, ");
INSERT INTO sml_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Magsusun aku amene' si Sa'ul magsultan sabab kataikutan aku e'na, maka halam bay beya'na saga panoho'anku.” Pagkale itu-i he' si Samwel, landu' iya asusa angkan iya angamu'-ngamu' ni si Yawe animpus dasangom inān. ");
INSERT INTO sml_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Pag'llaw dakayu' hinabu subu-subu lagi', pabungkal na si Samwel arak amowa mag'nda' maka si Sa'ul, saguwā' aniya' angahaka'an iya, yukna, “Si Sa'ul bay ma kauman Karmel insini' amat'nggehan ta'u-ta'u pamaheyana ma kabantuganna. Wa'i na iya palūd ni Gilgal.” ");
INSERT INTO sml_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Makat'kka pa'in si Samwel ni Gilgal, ah'lling si Sa'ul ni iya, yuk-i, “Mura-murahan bang pa'in ka binarakatan e' si Yawe! Bay na beya'ku saga panoho'anna.” ");
INSERT INTO sml_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Anambung magtūy si Samwel, yukna, “Na bang buwattē', ai bahā' lling bili-bili maka sapi' ya takaleku itu?” ");
INSERT INTO sml_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Anambung si Sa'ul, yukna, “Ya ilu bay ta'agaw e' saga sundaluku min bangsa Amalek. Bay kinapinan e' sigām saga bili-bili maka saga sapi' ya katapusan ahāp supaya aniya' panukbal ni si Yawe ya Tuhannu. Saddī m'nnilu bay papatay kami kamemon.” ");
INSERT INTO sml_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","“Ē! Sarang na!” yuk si Samwel. “Kalehun gi' bay pangallam PANGHŪꞋ ma aku dibuhi'.” “Na, haka'in aku,” yuk si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ah'lling si Samwel yukna, “Areyo' kabantugannu arai' bang ma bistahannu, malaingkan in ka'a pagmakōkan ma saga kapanubu'an bangsa Isra'il. Tapene' ka e' si Yawe magsultan ma sigām. ");
INSERT INTO sml_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ya panoho'anna ma ka'a, yuk-i, ‘Laglagun kamemon saga a'a Amalek, ya bangsa patila'atun inān. Bono'un sigām sampay sigām amatay kamemon.’ ” ");
INSERT INTO sml_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Atilaw lagi' si Samwel yukna, “Angay halam beya'nu panoho'an PANGHŪꞋ-Yawe he'? Angay magtūy agawnu saga tatabanan ya ka makahinang kala'atan makasāk atay PANGHŪꞋ?” ");
INSERT INTO sml_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Anambung si Sa'ul, “Oy! Bay du aku magkahagad ma kabaya'an PANGHŪꞋ. Bay hinangku panoho'anna ma aku. Bay papatayku kamemon bangsa Amalek maka bay saggawku si Agag ya sultan sigām. ");
INSERT INTO sml_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Suku' ma Tuhan asal saga bili-bili maka sapi' ya tataban inān, malaingkan kinapinan e' saga sundaluku saga hayop katapusan ahāp. Itiya' na ma Gilgal bo' aniya' susumbali'an tinukbalan ni si Yawe ya Tuhannu.” ");
INSERT INTO sml_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Yuk sambung si Samwel ma si Sa'ul, “Kasulutan bahā' si Yawe ma saga susumbali'an tinunu' maka tutukbalan pagtaubat labi lagi' min pameya'ta ma saga panoho'anna? Ahāp lagi' magkahagad ma panoho'an Tuhan min amowa tutukbalan. Ahāp lagi' ameya' ma kabaya'anna min anukbal lanab min saga bili-bili l'lla. ");
INSERT INTO sml_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Pinasali' ni dusa magpuputika' ya dusa a'a anagga' ma PANGHŪꞋ, maka bang a'a magmalangkahi, pasali' la'atna ni pagsumba ni saga ta'u-ta'u. Ma pasalan kataikutnu min panoho'an PANGHŪꞋ-Yawe, tinaikutan isab he'na kapagsultannu.” ");
INSERT INTO sml_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Manjari ah'lling si Sa'ul ma si Samwel, yukna, “B'nnal, bay aku makalanggal panoho'an PANGHŪꞋ maka panoho'annu. Tu'ud aku tināw ma saga a'aku, angkan bay beya'ku pamogos sigām. ");
INSERT INTO sml_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ndū' tuwan,” yukna, “amu'ku junjung ni ka'a, ampunun aku. Sehe'in aku bo' kita pabalik pehē' anumba ni PANGHŪꞋ-Yawe.” ");
INSERT INTO sml_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Saguwā' anambung si Samwel, yukna, “Hē! Mbal aku ameya' ma ka'a sabab bay taikutannu panoho'an PANGHŪꞋ, maka ilu na ka tinaikutan he'na. Mbal na ka makapagsultan ma bangsa Isra'il!” ");
INSERT INTO sml_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Jari itu, song pa'in ala'an si Samwel, niragtu' tōng jubana e' si Sa'ul ati magtūy agese'. ");
INSERT INTO sml_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Yuk si Samwel ma iya, “Nda'un na, in kapagsultannu sapantun juba itu. Taragtu' e' PANGHŪꞋ min ka'a llaw itu, ati pamuwanna ma dakayu' pagkahinu, a'a labi ahāp min ka'a. ");
INSERT INTO sml_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","In Tuhan Kasahaya'an bangsa Isra'il, mbal magputing atawa amindahan pikilanna sabab ngga'i ka iya manusiya' magpinda-pinda pikilan.” ");
INSERT INTO sml_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Anganjunjung pabalik si Sa'ul. “Aho', bay aku makarusa,” yukna, “sagō' amu'ku ma ka'a, pagaddatin aku ma baihu'an saga pagmatto'ahan ma bangsaku Isra'il sampay ma bangsa Isra'il kamemon. Sehe'in aku bo' kita pabalik amudji ni si Yawe ya pagtuhanannu.” ");
INSERT INTO sml_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Sakali pabunyug na si Samwel ma si Sa'ul ati makapudji iya ni PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Pagubus, ah'lling si Samwel, yukna, “Bowahunbi pi'itu si Agag ya sultan bangsa Amalek.” Na, pasekot si Agag pina'an ni si Samwel ma halam aniya' kahanggawanna, sabab ma pikilanna, “Tantu palabay kapiligduhan, mbal na ko' aku itu pinapatay.” ");
INSERT INTO sml_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Saguwā' yuk si Samwel, “Ma pasalan aheka ina' kalungayan anak sabab bay papataynu, damikiyanna amatay du ka isab ati kalungayan anak ina'nu.” Jari pinaglagut-lagut si Agag e' si Samwel ma matahan si Yawe, maina'an ma Gilgal. ");
INSERT INTO sml_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Puwas pa'in e'-i, amole' na sigā karuwangan, si Samwel ni Rama bo' si Sa'ul ni Gibeya. ");
INSERT INTO sml_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Min waktu inān sampay ni llaw kamatay si Samwel halam na iya amowa mag'nda' ma si Sa'ul. Sagō' magdukka na pa'in si Samwel ma kahālan si Sa'ul. Magsusun isab si Yawe sabab kapamene'na ma si Sa'ul magsultan ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Manjari dakayu' llaw, magkallam si Yawe ma si Samwel, yukna, “Sarang na pagdukkanu ma si Sa'ul pagka kataikutan e'ku pagsultanna ma bangsa Isra'il. Isihun ns'llan jaitun ni tanduk ya bowanu ilu bo' ka pehē' ni Betlehem ni a'a pinagōnan si Jesse. Sabab aniya' anakna l'lla tapene'ku magsultan.” ");
INSERT INTO sml_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Sagō' atilaw si Samwel, yukna, “Buwattingga kapehē'ku? Bang tasayu e' si Sa'ul, tantu aku pinapatay e'na.” Ya sambung PANGHŪꞋ-Yawe, “Amowa ka dakayu' anak sapi' d'nda bo' haka'in saga a'a mahē' in ka'a pehē' amowa tutukbalan pagkulbannu ni Tuhan. ");
INSERT INTO sml_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Ta'abbitun si Jesse ni pagkulbanan ati pata'uku ni ka'a bang ai subay hinangnu. Busugin ns'llan ya a'a tō'ku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Bineya' e' si Samwel panoho'an PANGHŪꞋ ati pehē' iya ni Betlehem. Pagt'kkana, bināk iya e' saga pagmatto'ahan maina'an maka he' sigām amidpid. Atilaw sigām ma iya, yuk-i, “Tuwan, kahāpan bahā' ya pagpi'itunu ilu?” ");
INSERT INTO sml_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","“Aho',” yuk sambung si Samwel. “Pi'itu aku anukbal tutukbalan kulban ni si Yawe. Sussihunbi pamarananbi bo' kam pi'itu ameya' ma aku.” Sinussi isab e' si Samwel si Jesse maka saga anakna l'lla bo' ta'abbitna sigām ni pagkulban. ");
INSERT INTO sml_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Pagt'kka sigām, ta'nda' e' si Samwel si Eliyab ya anak si Jesse kasiyakahan, angkan pangannalna, “Tantu ya na itu bay tapene' e' PANGHŪꞋ-Yawe.” ");
INSERT INTO sml_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Saguwā' angallam PANGHŪꞋ ma si Samwel, yukna, “Da'a nda'un luwana atawa lanjangna sabab ngga'i ka iya bay tapene'ku. Magbidda' asal e'ku ang'nda' min pang'nda' manusiya'. Sabab in manusiya' mag'nda' sadja ma pangluwahan saguwā' aku si Yawe ang'nda' ma pangatayan.” ");
INSERT INTO sml_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Sakali pinalinganan e' si Jesse si Abinadab ya anakna pasunu' bo' binowa palabay min matahan si Samwel. Saguwā' yuk si Samwel, “Ngga'i ka iya bay tapene' e' PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Jari si Samma, ya anak si Jesse kat'llu na, pinalabay min si Samwel, sagō' yuk si Samwel, “Ngga'i ka du isab iya bay tapene' e' PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Tapalabay e' si Jesse kapitu' anakna l'lla min matahan si Samwel sagō' buwattē' na pa'in pah'lling si Samwel, yukna, “Halam sai-na ma sigām bay tapene' e' PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Angkan atilaw si Samwel ma si Jesse yukna, “Halam na aniya' saddī anaknu min sigām itu?” “Aniya' gi' kasiyalihan,” yuk sambung si Jesse, “saguwā' wa'i magipat saga bili-bili.” Ah'lling si Samwel, “Soho'un iya pinabowa pi'itu. Mbal kitam makatagna' sat'ggolna mbal at'kka.” ");
INSERT INTO sml_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Angkan pina'ā' e' si Jesse anakna kasiyalihan. Onde' arorog iya, amanis, maka ahāp isab ninda' matana. Jari yuk PANGHŪꞋ ma si Samwel, “Ya na ilu tapene'ku. Pē'un na, busugin iya ns'llan tanda' kapagsultanna.” ");
INSERT INTO sml_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Manjari ningā' e' si Samwel tanduk isihan ns'llan e' bo' busuganna si Da'ud ma matahan saga danakanna. Tinagna'an min llaw inān pataptap Rū si Yawe ma si Da'ud. Sakali amole' na pabalik si Samwel ni Rama. ");
INSERT INTO sml_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Sakali ala'an na Rū si Yawe min si Sa'ul ati aniya' saitan pinapehē' e' si Yawe aminsana' iya. ");
INSERT INTO sml_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Ah'lling saga tendogna, yuk-i, “Tuwan sultan, tantu ka bininsana' e' saitan bay min Tuhan. ");
INSERT INTO sml_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Angkan tuwan, soho'un kami saga sosoho'annu itu amiha dakayu' a'a ata'u magbiyula. Ati sakahaba' ka tin'kka e' saitan, magbiyula iya supaya pahāp palasahannu.” ");
INSERT INTO sml_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Angkan magpanoho'an si Sa'ul ma saga tendogna inān, yukna, “Na aho', piha'inbi aku a'a apanday magbiyula bo' bowahunbi pi'itu.” ");
INSERT INTO sml_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Jari ah'lling dakayu' sosoho'an inān yukna, “Tuwan, aniya' kata'uwanku apanday magbiyula. Anak iya si Jesse a'a min Betlehem. Aesog iya maka bobono'un. Ahantap isab himumūnganna maka arorog pamarananna. Ina'an isab PANGHŪꞋ-Yawe pat'ttog ma iya.” ");
INSERT INTO sml_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Manjari amabeya' lapal si Sa'ul ni si Jesse, yuk-i, “Papi'ituhun anaknu si Da'ud ya magi'ipat bili-bili ilu.” ");
INSERT INTO sml_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Pagkale si Jesse, magtūy iya anganduwa' ni kura' ba'anan tinapay maka dapangisihan binu-anggul maka dakayu' anak kambing. Aubus pa'in niruwa' e'na, pinatulak e'na si Da'ud pehē' ni si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Sakali anagna' na maghinang si Da'ud ma deyoman sultan Sa'ul. Kasulutan sidda si Sa'ul ma iya angkan iya nihinang dakayu' magbobowa pakokosna. ");
INSERT INTO sml_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Amabeya' lapal isab si Sa'ul pehē' ni si Jesse, yuk-i, “Pamaituhun na si Da'ud ma deyomanku sabab kasulutan aku ma iya.” ");
INSERT INTO sml_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Na, sakahaba' si Sa'ul bininsana' e' saitan bay min Tuhan, magbiyula magtūy si Da'ud. Bay pa'in iya makabiyula, pahāp palasahan si Sa'ul maka ala'an isab saitan min iya. ");
INSERT INTO sml_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Manjari magtipun saga sundalu bangsa Pilistin bo' pasakap magbono'. Magpūn sigām ma kauman Soko ya ma lahat Yuda, ati magpustu sigām ma Epes-Dammim ma llot Soko maka Aseka. ");
INSERT INTO sml_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Ina'an isab magtimuk disi Sa'ul maka saga sundalu Isra'il bo' magpustu ma L'bbak Ela. Patanam isab sigām bo' angatu ma bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","In bangsa Pilistin ina'an ma dakayu' būd, maka ina'an saga bangsa Isra'il ma būd saddī. Aniya' l'bbak-būd isab ma llot sigām. ");
INSERT INTO sml_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Sakali aniya' paluwas min pustu bangsa Pilistin dakayu' a'a bobono'un maka babantugun. Ōnna si Golayat, a'a min da'ira Gāt. Kulang-labi dand'ppa maka tonga' lanjangna. ");
INSERT INTO sml_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Magsinaruk tumbaga si Golayat itu, maka magbinadju' badju' sisikan tumbaga, buhatna saga limampū' ka lima kilu. ");
INSERT INTO sml_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Tinampanan tape'na maka tumbaga, maka aniya' budjak tumbaga pasalay ma bukutna. ");
INSERT INTO sml_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Aniya' budjakna dakayu' da'aslag batangna maka batang pagt'nnunan kakana'. Ya solabna dī basi', ya buhatna saga pitu' kilu. Aniya' magbobowa tamingna parahū min iya. ");
INSERT INTO sml_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Na, an'ngge si Golayat itu ma anggopan saga sundalu bangsa Isra'il, maka e'na angamahit, yukna, “Angay kam subay paluwas magbono'? Aku itu dakayu' ko' sundalu Pilistin, bo' ka'am ilu banyaga' sadja si Sa'ul! Pene'unbi,” yukna, “dakayu' a'abi bo' soho'unbi pi'itu angatuhan aku. ");
INSERT INTO sml_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Bang saupama aku tara'ugna, magpabanyaga' kami ma ka'am. Sagō' bang iya ya tara'ugku, ka'am ya hinang kami banyaga'.” ");
INSERT INTO sml_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Ah'lling lagi' si Golayat, yukna, “Buwattina'an tukasku kaesogbi bangsa Isra'il! Papi'ituhunbi bang aniya' angatuhan aku.” ");
INSERT INTO sml_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Ā, pagkale bissala si Golayat itu e' si Sa'ul maka kamemon saga sundalu Isra'il, magtūy sigām angalogmay maka sinōd tāw. ");
INSERT INTO sml_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Na, ina'an si Da'ud anak si Jesse, ya min tumpuk Eprata. Si Jesse inān bay pat'nna' ma Betlehem ma lahat Yuda. Walu' heka anakna, maka ato'a na iya ma waktu kapagsultan si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","T'llungan anak si Jesse kasiyakahan bay ameya' ma sultan Sa'ul ma pagbono'an. Ya siyaka to'ongan si Iliyab, bo' si Abinadab, bo' si Samma, ");
INSERT INTO sml_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","maka si Da'ud ya kasiyalihan. Jari ya t'llungan anak siyaka ameya' na pa'in ma si Sa'ul ma pagbono'an, ");
INSERT INTO sml_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","ati si Da'ud ya magpehē'-pi'itu. Bay pa'in iya maghinang ma si Sa'ul, amole' iya pabalik ni Betlehem angipat saga bili-bili mma' sigām. ");
INSERT INTO sml_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Manjari magmairan na pa'in si Golayat ma matahan bangsa Isra'il, waktu subu maka waktu kohap ma deyom mpatpū' llaw. ");
INSERT INTO sml_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Dakayu' llaw, magpanoho'an si Jesse ma si Da'ud, yukna, “Oto', pasa'ut ka pehē' ni pustu saga siyakanu. Bowahin sigām dakarut pai-tirigu bay sinanglag maka sangpū' solag tinapay itu. ");
INSERT INTO sml_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Bowahin isab nakura' tumpukan sigām sangpū' solag gatas apīt. Maka nda'un isab kahālan saga siyakanu mahē', ati bowahin aku lapal in sigām asalamat du. ");
INSERT INTO sml_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Wa'i sigām magbeya' maka sultan Sa'ul maka kamemon sundalu Isra'il ma L'bbak Ela, magbono' na pa'in maka bangsa Pilistin.” ");
INSERT INTO sml_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Dai' llaw pa'in, pabangun na si Da'ud bo' pang'bbana saga bili-bili ma dakayu' magi'ipat bili-bili du isab. Palanjal na iya amowa saga balanja' buwat bay panoho'an mma'na, ati makat'kka iya pehē' hinabu ma pal'ngnganan pa'in saga magbobono' bangsa Isra'il ni atag pagbono'an. Ina'an sigām angolang panukas palbantahan sigām bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Sakali, magharap na sundalu Isra'il maka sundalu Pilistin. ");
INSERT INTO sml_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Pagka buwattē', pang'bba e' si Da'ud ma magjajaga balanja' ai-ai bay bowana bo' magdai'-dai' pehē' angowa' ma saga siyakana. ");
INSERT INTO sml_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Hinabuna lagi' magbissala maka sigām, ina'an na si Golayat a'a Gāt an'ngge min dahuwan saga pagkahina sundalu Pilistin, maka he'na isab anukas kaesog bangsa Isra'il buwat bay kahaba'. Jari takale itu he' si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Pag'nda' saga sundalu bangsa Isra'il ma si Golayat, magtūy sigām magdauragan kabowa tāw sigām. ");
INSERT INTO sml_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Magupama na pa'in saga sundalu inān, yuk-i, “Nda'unbi ba a'a inān. Llaw-llaw iya paluwas min pustuna anukas bangsatam Isra'il. Yuk suli-suli, sai ya makapapatay ma si Golayat tinungbasan alta' aheka e' sultan Sa'ul. Pamah'nda isab e'na anakna budjang ma a'a makapatay si Golayat, ati saga anak-kampungna mbal na pinabayad buwis parinta.” ");
INSERT INTO sml_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Atilaw gi' si Da'ud ma saga a'a ya ma atagna, yukna “Ai kono' panungbas ma a'a makapatay a'a bangsa Pilistin itu, maka amuwas kaiya'antam bangsa Isra'il? Sai sa kapil itu ya makatawakkal anukas saga sundalu ya suku' Tuhan kakkal salama-lama?” ");
INSERT INTO sml_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Binalikan e' saga a'a inān ya bay pagupama sigām, yuk-i, “Buwattē' ya panungbas e' sultan ma sai ya makapatay ma Pilistin ilu.” ");
INSERT INTO sml_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Na, pagkale si Eliyab ya siyaka si Da'ud ma bay panilawna ma saga sundalu inān, magtūy akagit atayna. Angkan pah'llinganna si Da'ud, yukna, “Magay ka mailu? Sai bay pang'bbahannu saga bili-bili salat-salat ma paslangan he'? Kata'uwanku ka'a maka pagabbunu. Mamarahi to'ongan la'at pikilannu. Hal ko' ka ilu bay pi'itu ang'nda'-ng'nda' pagbono' itu!” ");
INSERT INTO sml_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Ya sambung si Da'ud, “Angay?” yukna. “Ai bay hinangku? Halam bahā' aniya' kapatutku minsan hal atilaw?” ");
INSERT INTO sml_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Jari pataikut si Da'ud min siyakana bo' atilaw ma a'a saddī ma pasal ina'an-i. Sakali magsali' du panambung sigām ma iya. ");
INSERT INTO sml_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Na, takale suli-suli si Da'ud itu ati tahaka ni si Sa'ul, angkan iya pinalinganan sinō' pehē' ni sultan. ");
INSERT INTO sml_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Pagt'kka si Da'ud, ah'lling iya ni si Sa'ul, “Tuwan sultan,” yukna, “subay kitam mbal niumagad ma a'a Pilistin ilu! Aku ya pehē', tuwan, angatuhan iya!” ");
INSERT INTO sml_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Ya sambung si Sa'ul ma iya, “Oy! Mbal ka maka'atuhan Pilistin ilu. Onde'-onde' gi' ka, bo' iya inān magbobono' asal min bay lagi' kabata'na.” ");
INSERT INTO sml_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Sagō' ah'lling si Da'ud ni si Sa'ul, yukna, “Tuwan, aku itu magi'ipat saga bili-bili mma'ku. Sakahaba' aniya' bili-bili tatanga' e' halimaw atawa baruwang, ");
INSERT INTO sml_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","aku iya magbaran anurul ati puwasanku bili-bili min bowa' sattuwa he'. Tabīng pa'in aku e' sattuwa he', magtūy lurayku ma bū-langalna bo' papatayku. ");
INSERT INTO sml_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Aho', tuwan sultan, aheka saga halimaw maka baruwang bay tapapatayku angkan pasali'ku a'a kapil bangsa Pilistin itu ni dakayu' sattuwa inān, pagka tatukas e'na kasundaluhan suku' Tuhan, ya kakkal salama-lama.” ");
INSERT INTO sml_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ah'lling lagi' si Da'ud, yukna, “Ya PANGHŪꞋ-Yawe bay angalappasan aku min kukku halimaw maka min kukku baruwang, ya du isab Tuhan angalappasan aku min pang'ntan a'a Pilistin itu.” Pagka buwattē' pa'in, ah'lling si Sa'ul ni si Da'ud, yukna, “Na, pehē' ka angatu. Bang pa'in PANGHŪꞋ pabeya' ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Manjari, pinasulug he' si Sa'ul saga pamakayna pagbono' ma si Da'ud. Pinasulug sarukna tumbaga ni kōk si Da'ud, badju'na basi' ma puhu'na. ");
INSERT INTO sml_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Pagubus itu, magtinakos si Da'ud kalis si Sa'ul, pinakambotan pehē' ni badju'na pagbobono'. Sagō' agon iya mbal makal'ngngan pagka mbal biyaksa, angkan iya ah'lling ni si Sa'ul. “Tuwan sultan,” yukna, “mbal aku makapamono' bang aku magbinadju' saga pakayan itu sabab halam aku biyaksa.” Minnē' niurusan e' si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Jari ningā' e'na tungkudna bo' pehē' ni sapa' amene' lima batu-batu alanu', pinat'nna' e'na ni deyom puyu'-puyu' ya asal pinagbowa e'na ma waktu kapangipatna saga bili-bili. Binowa isab pitikanna bo' pal'ngngan tudju ni si Golayat ya a'a Pilistin e'. ");
INSERT INTO sml_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Salta', pina'an si Golayat tudju ni si Da'ud, maka ina'an isab magbobowa tamingna min dahuanna. ");
INSERT INTO sml_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Pag'nda' si Golayat ma si Da'ud in iya onde' baha'u lagi' maka ahāp luwana, magtūy iya niudju' e'na. ");
INSERT INTO sml_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Yukna ma si Da'ud, “Hōy! Ai pangannalnu ma aku? Ero' bahā', angkan ka pi'itu ni aku maka kayu-kayunu ilu?” Sinabbut isab e'na saga tuhan ya pagtuhanan bangsa sigām Pilistin bang pa'in si Da'ud taluwa' sukna'. ");
INSERT INTO sml_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Amissala lagi' iya ma si Da'ud, “Pasōng ka pi'itu,” yukna, “bo' pamakanku isinu ilu ma saga manuk-manuk maka saga sattuwa talun!” ");
INSERT INTO sml_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Anambung si Da'ud ma Pilistin e', yukna, “Ka'a ilu magbowa kalis, budjak aheya maka budjak ariki', sagō' atuhanta ka ma ōn si Yawe, ya Tuhan tatukasnu itu. In iya Tuhan Sangat Kawasa, ya pagtuhanan saga sundalu Isra'il. ");
INSERT INTO sml_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ma llaw itu, tinukbal ka ni aku e' PANGHŪꞋ-Yawe ati papatayta ka maka ponggolanku kōknu. Pakakanku bangkaybi bangsa Pilistin ma saga manuk-manuk maka saga sattuwa talun, ati tasayu e' kamemon manusiya' aniya' Tuhan sab'nnal-b'nnal ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Kamemon saga a'a sikatimukan itu song makata'u in si Yawe makalappas saga a'a suku'na minsan halam aniya' kalis atawa budjak pakokosna. Ma iya asal in da'ugan ma pagbono' itu, ati tinukbal kam e'na ni komkoman kami.” ");
INSERT INTO sml_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Na, pagsekot na pa'in si Golayat, arak parugpak, magtūy paragan si Da'ud amāk iya. ");
INSERT INTO sml_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Kino'ot e'na dakayu' batu-batu min deyom puyu'-puyu'na bo' magtūy pinitik si Golayat. Taluwa' iya ma tuktukna ati paloblob batu he'. Magtūy iya humantak para'ub. ");
INSERT INTO sml_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Sakali anganda'ug si Da'ud minsan hal pitikan maka batu ma tanganna. Minsan halam kalisna, tabono'na maka tapatayna si Golayat. ");
INSERT INTO sml_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Paghantak si Golayat itu, paragan magtūy si Da'ud bo' an'ngge ma atagna. Nihublut e'na kalis si Golayat bo' papatayna. Pagubus, pinonggolan e'na kōk. Na, pag'nda' bangsa Pilistin in sundalu sigām babantugun amatay na, magtūy sigām maglahian. ");
INSERT INTO sml_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Sakali, magolangan saga sundalu bangsa Isra'il maka bangsa Yuda maka e' sigām pasōng ni dahuwan bo' angapas saga Pilistin sampay ni bihing da'ira Gāt maka ni pagsosōran ni Ekron. Sikahantalan bangkay saga sundalu Pilistin ma bihing lān min Sa'araim sampay ni Gāt maka ni Ekron. ");
INSERT INTO sml_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Pagbalik saga sundalu Isra'il min bay panurulan ma saga sundalu Pilistin, tataban magtūy e' sigām kamemon ai-ai takapin ma pustu saga sundalu Pilistin. ");
INSERT INTO sml_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Jari binowa e' si Da'ud kōk si Golayat ni Awrusalam, sagō' saga pakokos si Golayat bay bowana ni toldana. ");
INSERT INTO sml_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Maka'nda' pa'in si Sa'ul ma kapangatu si Da'ud ma si Golayat, atilaw iya ma si Abner ya nakura' saga sundaluna. “Abner,” yukna, “anak sai sa onde' baha'u inān?” “Minsan aku pasapanu tuwan sultan, mbal kata'uwanku,” yuk sambung si Abner. ");
INSERT INTO sml_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Yuk sultan lagi', “Panilawun bang anak sai iya.” ");
INSERT INTO sml_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Manjari makabalik pa'in si Da'ud min kapamono'na ma si Golayat, binowa iya e' si Abner paharap ni si Sa'ul, salta' ina'an lagi' kōk si Golayat binenten e'na. ");
INSERT INTO sml_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Atilaw si Sa'ul ma si Da'ud, “Anak sai ka, oto'?” yukna. Anambung si Da'ud, “Tuwan sultan,” yukna, “aku itu anak dakayu' tendognu si Jesse, a'a min Betlehem.” ");
INSERT INTO sml_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Na, aubus pa'in pagbissala si Da'ud maka si Sa'ul, makapagda'atay iya maka si Jonatan ya anak si Sa'ul. In lasa si Jonatan ma si Da'ud sali' du lasana ma baranna. ");
INSERT INTO sml_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Tinagna'an min llaw ina'an, halam na pinapole' e' si Sa'ul si Da'ud ni okoman mma'na. ");
INSERT INTO sml_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Sakali itu, pagka alasa si Jonatan ma si Da'ud buwat e'na alasahan baranna, bay iya magjanji' maka si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Nihurusan e' si Jonatan jubana bo' pamuwanna ma si Da'ud, beya' isab s'mmekna pagbobono' maka kalisna sampay pana'na maka kambotna. ");
INSERT INTO sml_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Pi'ingga-pi'ingga panoho'an si Sa'ul ma si Da'ud, aheya sadja da'uganna angkan iya tahinang nakura' alanga ma saga sundalu. In kapat'nna' ma si Da'ud itu makasulut pangatayan kamemon saga a'a Isra'il sampay saga pagnakura'an sundalu si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Manjari waktu lagi' bay kapamole' saga sundalu Isra'il puwas bay tapatay e' si Da'ud si Golayat, pina'an pabāk ni si Sa'ul saga kar'ndahan min katilingkal kauman Isra'il magpangigal maka magkalangan, magbowa sigām tambul-tambul maka biyula. ");
INSERT INTO sml_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Hinabu sigām magpangigal, angalang sigām buwattitu, “Ibuhan tapatay e' sultan Sa'ul, maka hatusan ibu isab ma si Da'ud.” ");
INSERT INTO sml_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Pagkale si Sa'ul ma pagkalang itu, landu' iya angastol angkan yukna ma deyom atayna, “Bang ma saga a'a itu hatusan ibu ya bay tapatay e' si Da'ud bo' aku itu ibuhan sadja. Na, ai lagi' bahā' takapin ya makajari niagaw e'na? Luwal la'a pagsultanku.” ");
INSERT INTO sml_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Angkan tinagna'an min llaw inān ala'at na pang'nda' si Sa'ul ma si Da'ud kabowa pangimbūna. ");
INSERT INTO sml_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Manjari pag'llaw dakayu', aniya' saitan bay min Tuhan pasangon ni si Sa'ul. Binelaw iya, maka magligaw e'na amissala ma deyom luma'na, hinabu si Da'ud magbiyula buwat kabiyaksahanna. Na, aniya' budjak ma tangan si Sa'ul, ");
INSERT INTO sml_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","ati yukna ma deyom atayna, “Gom lagbasku si Da'ud itu ni dinding.” Sakali, binudjak si Da'ud e' si Sa'ul, daipara katangkisan e'na min duwa. ");
INSERT INTO sml_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Aheya tāw si Sa'ul ma si Da'ud sabab tinabang na pa'in iya e' PANGHŪꞋ-Yawe bo' si Sa'ul tinaikutan na. ");
INSERT INTO sml_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Pagka buwattē', pinatulak e'na si Da'ud bo' pinagmakōk ma tumpukan sundalu dangibu hekana. Jari magmakōk si Da'ud ma saga sundaluna pi'ingga-pi'ingga ya pagbono'an sigām. ");
INSERT INTO sml_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Ajatu kamemon kahinanganna sabab ina'an asal PANGHŪꞋ pat'ttog ma iya. ");
INSERT INTO sml_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Ya itu sababan angkan pasōng gom pa'in tāw si Sa'ul ma si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Malaingkan in kamemon a'a Isra'il maka Yuda palasa ma si Da'ud sabab ahāp e'na magmakōkan sigām ma pagbono'an. ");
INSERT INTO sml_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Na, aniya' waktu ah'lling si Sa'ul ni si Da'ud, yukna, “Bang aesog e'nu amogbogan aku maka bang t'nggehannu pahāp pagbono' PANGHŪꞋ, pamah'ndaku ma ka'a si Merab, ya anakku siyaka.” Buwattē' pamissala si Sa'ul sabab ma pikilanna ngga'i ka iya ya amapatay si Da'ud, sagō' saga bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Saguwā' anambung si Da'ud. “Tuwan,” yukna, “aku maka saga matto'a-danakanku sampay na saga ka'mbo'anku itu a'a areyo' du ko' ma bangsa Isra'il. Angkan mbal aku patut amikit ni sultan.” ");
INSERT INTO sml_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Malaingkan, ta'abut pa'in waktu bay panugun pamakawin si Merab ma si Da'ud, pinakawin na iya ma l'lla saddī ya pinagōnan si Adare'el, a'a min Mehola. ");
INSERT INTO sml_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Na, si Mikal, ya anak si Sa'ul budjang kasiyalihan, bilahi sidda ma si Da'ud. Jari pagta'u si Sa'ul ma pasalan itu-i kasulutan iya. ");
INSERT INTO sml_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Yukna ma deyom atayna, gom pamah'ndaku si Mikal ma si Da'ud supaya iya takatina amono' bo' pinapatay e' saga bangsa Pilistin. Angkan binalikan e' si Sa'ul bay llingna ma si Da'ud, yukna, “Makajari na ka tahinang ayuwanku.” ");
INSERT INTO sml_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Manjari magpanoho'an si Sa'ul ma saga tendogna sinō' magbissala maka si Da'ud ma halam aniya' makata'u. Sinō' sigām amissalahan iya buwattitu, “Kasulutan sultan ma ka'a, maka kinalasahan ka e' kamemon saga tendogna, angkan ahāp lagi' bang ngā'nu na h'nda anakna he'.” ");
INSERT INTO sml_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Jari buwattē' pamissala saga tendog inān ma si Da'ud, sagō' anambung iya, yukna, “Angay, taluhay-luhaybi bahā' tahinang dakayu' ayuwan sultan? Aku itu a'a miskin maka ngga'i ka babantugun.” ");
INSERT INTO sml_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Makata'u pa'in si Sa'ul pasal bay kabtangan si Da'ud he', ");
INSERT INTO sml_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","yuk panambungna, “Haka'inbi si Da'ud buwattitu, ‘Halam aniya' saddī ungsud niamu' min ka'a e' sultan, luwal dahatus kuwit bay pangislaman min bangsa Pilistin. Minnē' makabalos in sultan ma saga bantana.’ ” Sagō' ya to'ongan mohot si Sa'ul in si Da'ud tapapatay e' bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Pagkale si Da'ud ma pamissala saga tendog inān, sulut na iya tahinang ayuwan sultan Sa'ul. Angkan minsan halam lagi' ta'abut waktu bay panugun, ");
INSERT INTO sml_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","parugpak si Da'ud maka saga sundaluna ni bangsa Pilistin, ati tapatay e' sigām saga duwa hatus puhu'. Pagubus, binowa e' si Da'ud duwa hatus kuwit bay pangislaman min saga Pilistin e'. Ni'nde'an e'na ni si Sa'ul supaya iya makajari na ayuwan sultan. Pagka buwattē', bay pamakawin e' si Sa'ul anakna si Mikal ma si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Tasayu pa'in e' si Sa'ul in si Da'ud tinabang e' PANGHŪꞋ maka kinalasahan e' anakna si Mikal, ");
INSERT INTO sml_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","gom pa'in magduruhun tāwna. Jari binantahan si Da'ud e' si Sa'ul sat'ggolna allum. ");
INSERT INTO sml_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Na, masi na pa'in saga pagnakura'an bangsa Pilistin amowa magbono' maka bangsa Isra'il buwat asal daran nihinang e' sigām. Jari kahaba' sigām parugpak ni saga Pilistin, aheya da'ugan si Da'ud min kasehe'an saga nakura' sundalu si Sa'ul. Minnē' landu' abantug ōn si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Na, magsuli-suli si Sa'ul ma anakna si Jonatan maka saga tendogna pangandolan pasal si Da'ud subay pinapatay. Sagō' alasa to'ongan si Jonatan ma si Da'ud, ");
INSERT INTO sml_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","angkan iya binanda'an e'na. Yuk si Jonatan, “Angamohot mma'ku si Sa'ul amapatay ka'a, angkan ka subay pahalli' salung subu. Amiha ka lugal patapukannu. Ebot-ebot, da'a ka magluwas-luwas. ");
INSERT INTO sml_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Pagsalung, magbeya' aku maka mma'ku ni huma ya patapukannu. Bissalahanku iya ma pasalannu, jari haka'anta pa'in ka bang ai ya kaluwasanna.” ");
INSERT INTO sml_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Sakali pag'llaw dakayu' pa'in, binissalahan si Sa'ul e' si Jonatan pasalan kahāp si Da'ud. Yukna, “Mma', da'a inayun si Da'ud sabab halam iya bay angala'at ka'a. Bang pina'amu, in kamemon bay tahinangna aheya sidda katabanganna ma ka'a. ");
INSERT INTO sml_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Bay paglilla'na kallumna waktu kapamono'na si Golayat ati aheya da'ugan bay pamuwan PANGHŪꞋ ma kitam bangsa Isra'il. Kasaksi'annu itu kamemon maka kinōgan ka isab. Na, angay la'atnu a'a halam dusahan buwat si Da'ud angkan iya subay papataynu?” ");
INSERT INTO sml_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Tabowa si Sa'ul ma pamissala si Jonatan inān angkan iya ah'lling, yukna, “Sapahanku ma ōn si Yawe ya kakkal salama-lama, in si Da'ud mbal na pinapatay.” ");
INSERT INTO sml_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Sakali pinalinganan si Da'ud e' si Jonatan bo' pangahakana kamemon bay kapagbissalahanna maka mma'na. Manjari binowa si Da'ud ni si Sa'ul, ati maghinang iya ma deyo'an sultan buwat bay ka'ina tagna'. ");
INSERT INTO sml_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Malaingkan paniya' na isab bono' aheya, jari pehē' si Da'ud angandugpak ni bangsa Pilistin. Apaslod sidda pangandugpakna angkan maglahian sadja saga sundalu Pilistin. ");
INSERT INTO sml_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Sagō' aniya' na saitan bay min PANGHŪꞋ pasōd ni si Sa'ul hinabuna aningkō' ma deyom luma'na maka he'na ang'ntanan budjakna. Sakali itu, hinabu si Da'ud magbiyula, ");
INSERT INTO sml_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","binudjak iya magtūy e' si Sa'ul. Daipara makatangkis si Da'ud, bo' budjak inān tumaluwa' sadja ni dinding. Jari ma sangom du inān, alahi si Da'ud minna'an. ");
INSERT INTO sml_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Sakali, magpanoho'an si Sa'ul ma saga tendogna sinō' anganjagahan luma' si Da'ud, ati sinō' iya pinapatay pagsubu. Daipara binanda'an si Da'ud e' h'ndana si Mikal, yukna, “Tuwanku, bang ka mbal alahi sangom itu, tantu ka binono' salung.” ");
INSERT INTO sml_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Angkan pinaluwas si Da'ud e' si Mikal labay min tandawan bo' iya magtūy alahi. ");
INSERT INTO sml_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Manjari aniya' ta'u-ta'u bay ningā' e' si Mikal. Pinabahak e'na ma kantil bo' yampa minantahan e'na, maka pinat'nna'an bū kambing isab ma kōkna. ");
INSERT INTO sml_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Pagt'kka pina'an saga tendog si Sa'ul bahasa anaggaw si Da'ud, ah'lling si Mikal ni sigām in si Da'ud ina'an asaki. ");
INSERT INTO sml_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Kahaka'an pa'in si Sa'ul, magtūy iya magpanoho'an ma saga a'a inān, yukna, “Pabalik kam pehē' bo' bowahunbi pi'itu si Da'ud beya' maka pabahakanna. Aku magbaran ya amapatay iya.” ");
INSERT INTO sml_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Anā, pagsōd pa'in saga sosoho'an inān ni deyom bilik, luwal ta'u-ta'u ya ta'nda' sigām pat'nna' ma pabahakan e', maka bū kambing ma kōkna. ");
INSERT INTO sml_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Pinah'llingan si Mikal e' si Sa'ul, yukna, “Angay aku akkalannu? Angay dūlannu bantaku alahi?” Yuk sambung si Mikal ni mma'na, “Ya llingna ma aku, in aku papatayna kono' bang iya mbal tugutanku alahi.” ");
INSERT INTO sml_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Manjari makalahi pa'in si Da'ud, pehē' iya ni Rama bo' angahaka'an si Samwel pasal kamemon bay kahinangan si Sa'ul ma iya. Pagka buwattē' pa'in, magbeya' sigā karuwangan ni lūngan Nayot bo' mahē' pat'nna'. ");
INSERT INTO sml_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Kahaka'an pa'in si Sa'ul in si Da'ud kono' wa'i ma Nayot, ma kauman Rama, ");
INSERT INTO sml_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","magtūy iya anoho' saga tendogna pehē' anaggaw iya. Saguwā' pagt'kka saga tendog itu, ta'nda' e' sigām dakayu' tumpukan nabi amaluwas bissala mbal tahati, maka ina'an isab si Samwel pagmakōkan sigām. Jari pahōp Rū Tuhan ma saga tendog inān, maka ya du sigām tabowa amaluwas bissala ya mbal tahati. ");
INSERT INTO sml_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Makata'u pa'in si Sa'ul pasal itu-i, aniya' tendogna saddī bay soho'na pehē'. Ya du sigām tabowa amaluwas bissala buwattē'. Jari aniya' gi' tendog kasehe' pinapehē' e' si Sa'ul, kamint'lluna na, ati ya du sigām isab amaluwas bissala mbal tahati. ");
INSERT INTO sml_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Katapusanna, magbaran si Sa'ul pehē' ni Rama bo' ni k'ppong aheya ya ma lahat Seku. Maina'an pa'in, atilaw iya, yukna, “Maingga bahā' si Samwel maka si Da'ud?” Ya sambung saga a'a bay panilawan, “Tuwan sultan, wa'i sigā ma Rama, ma lūngan Nayot.” ");
INSERT INTO sml_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Sakali, palanjal si Sa'ul ni Nayot, sagō' ya du iya kahōpan e' Rū Tuhan ati aniya' bissala mbal tahati pinaluwas e'na sampay tat'kkana lūngan Nayot e'. ");
INSERT INTO sml_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Maina'an pa'in, nihurusan e' si Sa'ul pan'mmekna maka ya du iya tabowa magbissala kaligawan ma matahan si Samwel. Jari pabahak iya maka panantangna animpus dang'llaw dambahangi. Ya itu sababan angkan pinagsambatan e' a'a, “Nabi bahā' sampay si Sa'ul?” ");
INSERT INTO sml_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Manjari, alahi na isab si Da'ud min lūngan Nayot ya ma Rama inān tudju ni si Jonatan. Ya panilawna ma si Jonatan e', “Ai kasā'an bay tahinangku? Ai dusaku ma mma'nu angkan iya angamohot amapatay aku?” ");
INSERT INTO sml_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Yuk sambung si Jonatan. “Oy, s'lle' bale puhu'nu! Mbal ko' ka'a ilu pinapatay e' si mma'! Ai-ai kahinanganna aheya-ariki', subay pangaru e'na dahū ni aku.” Yuk lagi' si Jonatan, “Angay angkan limbunganna min aku niyatna amapatay ka'a? Suli-suli sadja ko' ilu, da'a beya'-beya'un.” ");
INSERT INTO sml_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Sagō' anapa si Da'ud bo' anambung, yukna, “Kinata'uwan e' mma'nu in aku makasulut pangatayannu angkan pangannalna in ka'a subay mbal pinata'u sabab ya aniya' magkarukka'an lagi' ka.” Anubahat lagi' si Da'ud, yukna, “Sapahanku ma ōn si Yawe ya Tuhan kakkal salama-lama, maka ma ōnnu isab, in aku itu marai' na pinapatay.” ");
INSERT INTO sml_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Na, ah'lling si Jonatan, yukna, “Haka'in aku bang ai kabaya'annu. Tantu hinangku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Ya panambung si Da'ud, “Salung,” yukna, “Paghinang Bulan Baha'u, maka subay aku pajamu ma sultan. Sagō' dūlin lagi' aku patapuk ma kahuma'an deya sampay ni kasangoman ma llaw sumuddai. ");
INSERT INTO sml_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Bang saupama tasayuna in aku alikut, ah'lling ka ni iya, yuknu, ‘Bay ama'id si Da'ud min aku bo' pasa'ut amole' ni Betlehem, ya lahatna luggiya'. Subay tasabuna hinang Pagtaubat sigām maglaulahasiya'.’ ” ");
INSERT INTO sml_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Amissala lagi' si Da'ud, yukna, “Bang hal angaho' mma'nu, hatina asalamat aku. Sagō' bang iya angastol, tantu aniya' niyatna angala'at aku. ");
INSERT INTO sml_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Aniya' isab panganjunjungku ni ka'a, tuwan. Atanu asal aku, jari hinangin aku kahāpan ma sabab paljanji'an ya bay pagsapahanta ma matahan PANGHŪꞋ. Bang b'nnal aniya' kasā'an bay tahinangku, na, ka'a na ya magbaran amapatay aku! Da'a sadja aku tukbalun ni mma'nu.” ");
INSERT INTO sml_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Ya sambung si Jonatan ma si Da'ud, “Oy! Da'a ka magpikil buwattilu,” yukna. “Bang hati tasayuku b'nnal-b'nnal aniya' niyat mma'ku angamula ka'a, pata'uta ka magtūy.” ");
INSERT INTO sml_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Atilaw si Da'ud, yukna, “Bang saupama akasla panambung mma'nu ma ka'a, sai amata'u aku?” ");
INSERT INTO sml_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Anambung si Jonatan yukna, “Sūng kita kaleya.” Jari pehē' na sigām. ");
INSERT INTO sml_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Ma huma pa'in, yuk si Jonatan ma si Da'ud, “Saksi'ta si Yawe ya pagtuhanan bangsa Isra'il, salung atawa sumuddai ma sali' waktu buwattitu du, bowaku magbissala si mma'. Bang hati ahāp pamikilna ma pasalannu, pabeya'anta pa'in ka lapal. ");
INSERT INTO sml_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Saguwā' bang iya magmohot angala'at ka'a, bang pa'in aku pinagmulka'an e' PANGHŪꞋ bang ka mbal magtūy pata'uku bo' supaya ka makalahi. Mura-murahan bang pa'in ka ginapi' e' PANGHŪꞋ buwat bay panganggapi'na ma mma'ku. ");
INSERT INTO sml_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Malaingkan pangamu'ku isab ma ka'a bang pa'in aku pa'nda'annu kahāpan sat'ggolku allum, buwat kahāpan PANGHŪꞋ. Maka bang aku saupama amatay, ");
INSERT INTO sml_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","da'a b'kkatun kahāpannu ma saga panubu'ku, minsan aligis e' PANGHŪꞋ kamemon palbantahannu min babaw dunya itu.” ");
INSERT INTO sml_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Sakali aniya' lagi' paljanji'an si Jonatan ma si Da'ud maka panubu'na, yukna, “Bang pa'in tinungbasan e' Tuhan saga palbantahan si Da'ud.” ");
INSERT INTO sml_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Kinalasahan si Da'ud e' si Jonatan buwat e'na alasahan baranna, angkan soho'na si Da'ud amatuman janji'na, ma sabab lasana isab ma si Jonatan. ");
INSERT INTO sml_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Pagubus, ah'lling si Jonatan ma si Da'ud, yukna, “Salung na in Paghinang Bulan Baha'u, angkan tantu ko' ka'a ilu piniha he' si mma' pagka halam a'a ma tingkō'annu. ");
INSERT INTO sml_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Na, ma sumuddai he', saga abay kohap, pehē' ka ni lugal ya bay patapukannu waktu panagna' paniya' palkala' itu. Angagad ka mahē' ma tambak batu ya niōnan Esel, ");
INSERT INTO sml_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","ati amana' aku mint'llu ni kīd batu patapukannu he', buwat hantang to'ongan aniya' pana'ku. ");
INSERT INTO sml_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Soho'ku dakayu' onde' l'lla angā' pana' he'. Jari bang yukku ma iya, ‘Ina'an saga pana' ma atag batu tampal pi'itu, bowahun pi'itu,’ makajari ka paluwas. Sapahanta ka ma kallum PANGHŪꞋ, halam aniya' la'at tum'kka ni ka'a. Asalamat ka. ");
INSERT INTO sml_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Sagō' bang yukku ni onde' ya soho'ku inān, ‘Wa'i ma katāhan saga pana',’ hatina subay ka pasa'ut alahi sabab ya na kahandak PANGHŪꞋ ma ka'a. ");
INSERT INTO sml_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Maka pasal bay paljanji'anta inān, entomun pahāp, PANGHŪꞋ ya saksi'ta sampay salama-lama.” ");
INSERT INTO sml_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Buwattē' pa'in, patapuk na si Da'ud ma lugal bay kapagisunanna maka si Jonatan. Ta'abut pa'in Paghinang Bulan Baha'u, ina'an na sultan Sa'ul aningkō' ma pagjamuhan. ");
INSERT INTO sml_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Maina'an iya aningkō' ma bihing dinding, buwat kabiyaksahanna. Magalop iya maka si Jonatan, maka ina'an isab si Abner ma bihingna. Sagō' in paningkō'an si Da'ud halam maga'a. ");
INSERT INTO sml_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Halam ah'lling-h'lling si Sa'ul itu, sabab ma pikilanna, kalu aniya' bay tahinang e' si Da'ud ya makabatal iya. ");
INSERT INTO sml_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Sagō' pag'llaw dakayu' pa'in, llaw karuwana ma bulan inān, halam na isab maga'a paningkō'an si Da'ud. Angkan atilaw si Sa'ul ma anakna si Jonatan, yukna, “Angay sangay di'ilaw, halam pajamu pi'itu anak si Jesse ilu?” ");
INSERT INTO sml_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Anambung si Jonatan, yukna, “Bay iya ama'id min aku, mma', amole' kono' iya ni Betlehem. ");
INSERT INTO sml_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Yukna ma aku, ‘Dūlin lagi' aku amole' sabab in kami magkaukampung maghinang pagkulban ma kauman kami. Bay aku niamay-amayan e' danakanku,’ yukna, ‘sinō' pahadil.’ Bang kono' makajari ma aku,” yuk si Jonatan, “tinugutan iya amole' bo' mag'nda' maka dauranakanna. Na, ya ilu sababan angkan halam makapi'itu si Da'ud ni pagjamuhan.” ");
INSERT INTO sml_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Angastol to'ongan si Sa'ul pagkalena ma bissala si Jonatan itu, angkan yukna, “Ē! Halambiyara' itu, mamarahi tuwas kōknu. Aheya to'ongan dapitnu ma si Da'ud. Kaiya'an aheya ko' ilu ma ka'a sampay ma ina'nu! ");
INSERT INTO sml_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Halam tasayunu sat'ggol masi allum anak si Jesse ilu ma babaw dunya itu, mbal ka makapagsultanan paglahat itu. Na, soho'un iya binowa pi'itu sabab patut iya subay pinapatay!” ");
INSERT INTO sml_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Anambung si Jonatan yukna, “Angay angkan subay pinapatay si Da'ud? Ai dusana?” ");
INSERT INTO sml_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Pagka buwattē' panambung si Jonatan, magtūy iya nihiyak e' si Sa'ul maka budjak. Minnē' kinata'uwan e' si Jonatan in mma'na magmohot to'ongan amapatay si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Sakali akagit to'ongan atay si Jonatan ati an'ngge iya magtūy min pagkakanan. Manjari ma llaw pagjamu karuwana, halam iya amangan sabab ap'ddi' landu' atayna pasalan pangahina' mma'na ma si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Na, pag'llaw dakayu', pehē' na si Jonatan ni huma bay kapagisunanna pagbākanna maka si Da'ud. Aniya' isab onde' l'lla ameya' ma si Jonatan, ");
INSERT INTO sml_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","manjari ah'lling iya ni onde' inān, yukna, “Paragan ka pehē' bo' piha'un saga pana' ya pamana'ku itu.” Sakali, hinabu paragan onde' itu, pinaleyang e' si Jonatan dakayu' pana' pinaliyu min iya. ");
INSERT INTO sml_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Pagt'kka onde' ni lugal kahūgan pana' he', niolangan iya e' si Jonatan, yuk-i, “Ilu pana' ma dahuannu! ");
INSERT INTO sml_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Na, pal'kkasun dagannu ilu! Da'a ka maghogga'-hogga'!” Pinuwa' na pana' inān he' onde' bo' ni'nde'an ni nakura'na si Jonatan. ");
INSERT INTO sml_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Tu'ud halam panghati onde' inān ma saga palkala' he', luwal si Jonatan maka si Da'ud ya makata'u. ");
INSERT INTO sml_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Pagubus itu, sinōngan e' si Jonatan pana'na ni onde' l'lla inān bo' soho'na amole'. “Pehē' na ka,” yukna, “bowahun saga pana' itu amole' ni kauman.” ");
INSERT INTO sml_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Makala'an pa'in onde' he', paluwa' na si Da'ud min liyu batu bay patapukanna bo' pasujud mint'llu ma dahuwan si Jonatan. Manjari, maggapus sigām karuwangan maka he' sigām magtangis. Saguwā' palabi heya tangis si Da'ud min si Jonatan. ");
INSERT INTO sml_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Yuk si Jonatan ma iya, “Na, bagay, bang pa'in ka mura-murahan asalamat. Ma takdil kapagbagayta, PANGHŪꞋ ya saksi' ma saga paljanji'anta karuwangan sampay ma saga panubu'ta magsuring-magsaingsing.” Pagubus itu, ala'an na si Da'ud minnē', bo' si Jonatan pabalik na ni kauman. ");
INSERT INTO sml_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Pabutas pa'in si Da'ud min si Jonatan, pehē' na iya ni kauman Nōb bo' tibawna imam Ahimelek. Pagbāk si Ahimelek itu ma si Da'ud, amidpid iya kabowa tāwna. Atilaw iya, yuk-i, “Angay ka karangan-danganan ilu? Angay halam sehe'nu?” ");
INSERT INTO sml_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Yuk sambung si Da'ud, “Aniya' bay panoho'an aku e' sultan. Bay aku binanda'an e'na sinō' mbal amata'u minsan ma sai pasalan l'ngngan itu. Ma takdil saga a'aku, bay na sigām haka'anku bang maingga pagsabuhan kami.” ");
INSERT INTO sml_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Atilaw gi' si Da'ud, yukna, “Na, aniya' bahā' takakanta? Buwanin gi' aku limansolag tinapay, atawa ai-ai na aniya' mailu.” ");
INSERT INTO sml_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Anambung si Ahimelek, yukna, “Halam aniya' tinapay maitu luwal ya tinapay bay pamasuku' Tuhan, sagō' wajib sadja itu kinakan e' saga a'abi bang sigām halam bay makapaghulid maka d'nda sōngbi pi'itu.” ");
INSERT INTO sml_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Ah'lling si Da'ud yukna, “Ma addat kami, pangalāngan asal maghulid maka d'nda bang song ni pagbono'an. Asussi saga a'aku sampay pamaranan sigām minsan ma l'ngngan m'ssa' bidda'. Ya lagi'na bang ni l'ngngan aheya buwat na itu-i!” ");
INSERT INTO sml_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Sakali, pamuwan e' imam inān ma si Da'ud tinapay bay pamasuku' Tuhan, ya bay nila'anan min matahan Tuhan bo' ginanti'an magtūy maka tinapay baha'u. Halam aniya' takakan saddī tapamuwan e' imam liyu minnē'. ");
INSERT INTO sml_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Na, aniya' dakayu' sosoho'an si Sa'ul bay pasabu maina'an pagka aniya' hinangna tudju ni PANGHŪꞋ. Ōnna si Do'eg bangsa Edom, ya aesog to'ongan ma saga magi'ipat bili-bili si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Jari atilaw si Da'ud ma si Ahimelek, yukna, “Aniya' budjak atawa kalis maitu? Halam aku bay magbowa pakokos pagka asa'ut panoho'an sultan he'.” ");
INSERT INTO sml_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Yuk sambung imam, “Itiya' maitu kalis si Golayat a'a Pilistin ya bay tapataynu ma L'bbak Ela. Itiya' ma liyu epod, pinutus maka kakana'. Bang hati kabilahiannu, ngā'un na sabab halam aniya' saddī kalis minnilu.” Jari ah'lling si Da'ud, “Na, ndiya ma aku sabab halam na aniya' pahāp minnilu.” ");
INSERT INTO sml_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Jari itu palanjal na si Da'ud ma kalahina min si Sa'ul bo' pehē' ni si Akis, ya sultan ma da'ira Gāt. ");
INSERT INTO sml_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Mahē' pa'in, ah'lling ni si Akis saga tendogna pangandolan, yuk-i, “Ya na ko' ilu si Da'ud ya sultan ma paglahat Isra'il. Iya na a'a pinagkalangan e' saga kar'ndahan hinabu sigām magpangigal, yuk-i, ‘Ibuhan tapatay e' sultan Sa'ul, jari hatusan ibu ma si Da'ud’.” ");
INSERT INTO sml_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Tinali'-tali' pahāp e' si Da'ud pah'lling saga a'a itu, jari sinōd iya tāw landu' aheya ma sultan Akis. ");
INSERT INTO sml_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Angkan iya magbelaw-belaw di-na sakahaba' aniya' a'a ang'nda' iya. Hinabuna binalutan e' sigām, magbau'-bau' iya kinangog. Maggudlis iya indalupaginis ma saga tambol lawang ya ma ād da'ira inān, maka pinatū' isab bohelona ni p'ngngotna. ");
INSERT INTO sml_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Sakali ah'lling sultan Akis ni saga tendogna, yukna, “Nda'unbi ba a'a binelaw ilu! Angay iya bay bowabi pi'itu? ");
INSERT INTO sml_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Akulang bahā' a'a dupang ma aku, angkan bowabi a'a itu bo' magbelaw-belaw ma kamaituhanku? Pala'anunbi iya minnitu!” ");
INSERT INTO sml_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Manjari, ala'an si Da'ud min Gāt bo' alahi ni dakayu' songab batu ma lahat Adullam. Pagta'u pa'in itu e' saga matto'a-danakanna, pehē' sigām parakayu' ma iya. ");
INSERT INTO sml_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Parakayu' isab ma si Da'ud kamemon saga a'a sasuku kasigpitan maka ma deyom utang atawa taga-koto'-koto' ma deyom atay, ati tahinang iya pagnakura'an sigām. Saga mpat hatus puhu' ya heka sigām. ");
INSERT INTO sml_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Palanjal si Da'ud minnē' ni da'ira Mispa ma lahat bangsa Mowab bo' ah'lling ni sultan sigām, yukna, “Tuwan, angamu' aku junjung bang pa'in parūlnu ina'-mma'ku pahanti' ma deyomannu sampay kata'uwanku bang ai ya kahandak Tuhan ma aku.” ");
INSERT INTO sml_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Jari pang'bba e'na ina'-mma'na ma sultan Mowab he', ati mahē' sigām pahanti' sat'ggol si Da'ud pahanti' ma patapukan ahogot. ");
INSERT INTO sml_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Sagō' binanda'an si Da'ud e' nabi Gād, yukna, “Da'a ka pat'ggol ma tapukan ilu. Pehē' ka ni jadjahan Yuda.” Angkan ala'an si Da'ud minnē' bo' pehē' ni katalunan ma Heret. ");
INSERT INTO sml_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Mbal at'ggol, takale e' si Sa'ul pasal si Da'ud maka saga tendogna tabāk na. Pasalta', ina'an si Sa'ul ma Gibeya, aningkō' ma sindungan kayu tamaris ya ma būd e'. Aniya' asal budjak ma tanganna. Ina'an isab saga a'a kawakilanna an'ngge ma katilibutna. ");
INSERT INTO sml_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Jari ah'lling si Sa'ul ni sigām, yuk-i, “Akale kam pahāp, ka'am saga panubu' Benjamin! Ma pikilanbi bahā', kabuwanan kam kabbun anggul maka tana' paghuma'an e' anak si Jesse inān? Tahinang bahā' kam e'na nakura' alanga ma saga ibuhan atawa hatusan sundaluna? ");
INSERT INTO sml_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Ya bahā' ilu sababanna angkan kam magisunan aku? Angay halam aniya' minsan dangan min ka'am amata'uwan aku in anakku maka anak si Jesse bay makapagjanji'? Halam aniya' pagka'inagonbi ma aku atawa minsan hal la'a angahaka'an aku in anakku bay amidjakan iya amapatay aku ma labayan. Ina'an na iya anipihan aku buwattina'an!” ");
INSERT INTO sml_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Na ina'an isab si Do'eg, a'a bangsa Edom, samat'ngge maka saga pagnakura'an tendog si Sa'ul. Ah'lling si Do'eg itu, yukna, “Bay ta'nda'ku anak si Jesse pehē' ni kauman Nōb bo' patibaw ni si Ahimelek anak si Ahitub. ");
INSERT INTO sml_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Bay angaru si Ahimelek ni PANGHŪꞋ pasal si Da'ud bang ai subay hinangna, maka bay pamuwanna isab ma iya balanja' maka kalis ya bay pakokos si Golayat a'a Pilistin.” ");
INSERT INTO sml_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Manjari, magpanoho'an si Sa'ul pina'ā' si Ahimelek sampay kamemon saga kampungna ya magimam ma Nōb. Jari pina'an na sigām ni sultan. ");
INSERT INTO sml_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Maina'an pa'in, ah'lling si Sa'ul, yukna, “Akale ka Ahimelek!” “Aho', tuwan sultan,” yuk si Ahimelek. ");
INSERT INTO sml_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Atilaw si Sa'ul ma iya, yuk-i, “Angay ka bay magisun maka anak si Jesse inān bo' angatu ma aku? Bay iya buwanannu tinapay maka kalis, maka bay ka isab angaru ni Tuhan ma pasalanna, angkan iya anagga' pagsultanku maka angamohot amapatay aku ma labayan! Ina'an na iya anipihan aku buwattina'an!” ");
INSERT INTO sml_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Anambung si Ahimelek, yukna, “Tuwan, aniya' bahā' tendog kapangandolan labi min si Da'ud? Ayuwannu iya, maka pagnakura'an ma saga sundalu ya anganjagahan ka'a. Pinagaddatan isab iya e' a'a kamemon ma deyomannu. ");
INSERT INTO sml_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","In pasal pangaruku ni Tuhan ma pasalanna, tuwan, ya na tu'ud kabiyaksahanku. Arapun in pasal kapagisun angatu ma ka'a, ndū' tuwan, da'a aku tuna'un atawa minsan sai-na ma kami maglaulahasiya', sabab halam aniya' pana'uku ma pasal palkala' inān.” ");
INSERT INTO sml_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Jari yuk si Sa'ul, “Ahimelek, ka'a maka saga kakampungannu ilu subay pinapatay!” ");
INSERT INTO sml_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Magtūy magpanoho'an sultan ma saga jaga ya ma bihingna, yuk-i, “Papatayun kamemon saga imam si Yawe itu sabab ya du sigām pagapi' na ma si Da'ud. Kinata'uwan e' sigām in iya alahi min aku sagō' halam bay anumbung ni aku.” Sagō' halam sai-na min saga jaga inān makatawakkal amapatay saga imam e' pagka imam si Yawe. ");
INSERT INTO sml_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Pagubus, si Do'eg ya sinoho' e' si Sa'ul. Yukna, “Na ka'a! Papatayun saga imam itu.” Jari pinapatay e' si Do'eg kamemon saga imam he'. Walumpū' maka lima ya heka sigām magpamakay epod. ");
INSERT INTO sml_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Min panoho'an si Sa'ul isab, talaglag kamemon d'nda-l'lla, kamemon saga kaonde'-onde'an, sampay isab kamemon saga hayop ya bay ma kauman Nōb. ");
INSERT INTO sml_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Luwal si Abiyatar anak si Ahimelek, mpu si Ahitub, ya bay makaliyus bo' alahi pehē' ni si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Kahaka'an e'na si Da'ud in kamemon saga kaimaman si Yawe bay pinapatay e' si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Angkan ah'lling si Da'ud ma si Abiyatar, yukna, “Llaw he', pagta'uku in si Do'eg bangsa Edom bay mahē' ma Nōb, makatantu aku in iya anumbung du ni si Sa'ul. Aku palsababan ya angkan amatay saga lahasiya'nu kamemon. ");
INSERT INTO sml_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Na, maitu na ka ma aku sabab in a'a bilahi amapatay ka'a anganiyat isab amapatay aku. Da'a ka agawa sabab halam kamulahannu bang pa'in ka ma deyomanku.” ");
INSERT INTO sml_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Na, aniya' lapal pinasampay ni si Da'ud, yuk-i, “Wa'i parugpak saga bangsa Pilistin ni kauman Kela maka pinagtangkaw na pa'in he' sigām saga pai baha'u bay niani, ya ina'an ma pagt'ppahan.” ");
INSERT INTO sml_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Manjari angaru si Da'ud ni PANGHŪꞋ yukna, “Ya Tuhan, parugpak bahā' aku ni saga Pilistin inān?” Anambung Tuhan, “Aho'” yukna. “Dugpakun sigām bo' lappasun kauman Kela.” ");
INSERT INTO sml_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Saguwā' ah'lling ni si Da'ud saga a'ana, yuk-i, “Tuwan, minsan maitu kitam ma paglahat Yuda, landu' kitam tināw, ya lagi'na bang kitam pehē' ni Kela bahasa parugpak ni saga sundalu Pilistin.” ");
INSERT INTO sml_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Manjari angaru na isab pabalik si Da'ud ni PANGHŪꞋ, jari buwattitu ya sambung PANGHŪꞋ ma iya, yuk-i, “Palūd ka pehē' ni Kela sabab pamarūlku ma ka'a in da'ugan min saga bangsa Pilistin.” ");
INSERT INTO sml_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Angkan palanjal na disi Da'ud maka saga a'ana ni Kela. Tarugpak e' sigām saga bangsa Pilistin maka ta'ā' e' sigām saga kahayopan sigām. Aheka bangsa Pilistin bay tapapatay e' sigām bo' arapun lappasan saga a'a ma Kela. ");
INSERT INTO sml_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","(Ma waktu bay kalahi si Abiyatar anak si Abimelek pina'an ni si Da'ud, bay asal bowana epod.) ");
INSERT INTO sml_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Na, kahaka'an si Sa'ul pasal si Da'ud ina'an ma lahat Kela, angkan yukna, “Itiya' tinukbalan e' Tuhan si Da'ud ni komkomanku sabab wa'i iya bay angalikusan kauman kinuta', ya mbal agon kaluwasan.” ");
INSERT INTO sml_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Sakali, pinalinganan e' si Sa'ul kamemon sundaluna sinō' magsakap amono' bo' palūd ni Kela angahapa'an si Da'ud maka saga a'ana bo' mbal makaluwas min kauman e'. ");
INSERT INTO sml_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Pagta'u pa'in si Da'ud ma kagara'an si Sa'ul itu, magpanoho'an iya ma imam Abiyatar, yukna, “Bowahun pi'itu epod ilu.” ");
INSERT INTO sml_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Maina'an pa'in, angamu'-ngamu' si Da'ud ni Tuhan. Yukna, “O Yawe, Tuhan bangsa Isra'il, takaleku in si Sa'ul maggara' angalubu kauman Kela ma sababku. ");
INSERT INTO sml_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Tinukbalan bahā' aku e' saga a'a maitu-itu ni si Sa'ul? Pi'itu bahā' iya buwat bay pangalapal itu? Ya PANGHŪꞋ kami bangsa Isra'il, sambungin lagi' sosoho'annu itu.” Sakali anambung PANGHŪꞋ yukna, “Aho', tantu pi'ilu si Sa'ul.” ");
INSERT INTO sml_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Manjari, angamu'-ngamu' pabalik si Da'ud yukna, “Tinukbalan bahā' aku maka saga a'aku ni si Sa'ul e' saga a'a Kela?” Ya sambung PANGHŪꞋ, “Aho'.” ");
INSERT INTO sml_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Pagka buwattē', si Da'ud maka saga a'ana kulang-labi nnom hatus hekana magla'anan na min Kela bo' maglatun-latun ma kalahatan. Tata'u pa'in e' si Sa'ul in si Da'ud wa'i na makalahi min Kela he', halam na iya pehē'. ");
INSERT INTO sml_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Manjari itu, pahanti' na pa'in disi Da'ud ma saga patapukan ahogot ma paslangan Sīp maka ma kabūd-būran. Piniha iya e' si Sa'ul sakahaba' llaw, sagō' mbal iya tinugutan e' Tuhan ni komkoman si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Dakayu' llaw, ma Hores pa'in si Da'ud, ma paslangan Sīp, tata'una in si Sa'ul song pina'an amapatay iya. ");
INSERT INTO sml_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Sakali pina'an si Jonatan ni si Da'ud hinabuna ma Hores, bo' pinahogot e'na iman si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","Yuk si Jonatan ma si Da'ud, “Da'a ka tināw sabab tantu mbal ka tainay e' mma'ku si Sa'ul. Kata'uwanna asal in ka'a magsultan ma Isra'il maka aku itu ma deyo'annu.” ");
INSERT INTO sml_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Jari magpaljanji'an sigā karuwangan ma matahan PANGHŪꞋ. Pagubus itu, amole' na pabalik si Jonatan, saguwā' magpa'bba si Da'ud ma Hores. ");
INSERT INTO sml_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Manjari aniya' saga a'a min Sīp patukad ni si Sa'ul ma Gibeya bo' anumbungan iya pasal si Da'ud. Yuk sigām, “Tuwan sultan, wa'i si Da'ud patapuk ma lūngan kami ma Hores, maina'an ma būd Hakila tampal ni satan min lahat Jesemon. ");
INSERT INTO sml_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Palūd pa'in ka sumiyan-sumiyan katanamannu sabab tantu kami ya atas-pikil anukbalan iya ni ka'a.” ");
INSERT INTO sml_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Anambung si Sa'ul yukna, “Mura-murahan kam binarakatan e' PANGHŪꞋ ma sabab pagka'inagonbi ma aku. ");
INSERT INTO sml_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Pehē' na kam bo' nda'unbi pahāp bang maingga si Da'ud maka bang sai ya bay maka'nda' iya. Kahaka'an aku in si Da'ud aillag makalandu'. ");
INSERT INTO sml_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Ta'uhunbi kamemon patapukanna bo' kam pabalik pi'itu amissalahan aku bang maingga iya. Jari bang iya masi mahē', ameya' aku ma ka'am. Pihaku iya minsan alatag e'ku kamemon jadjahan ma sakalibut lahat Yuda.” ");
INSERT INTO sml_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Na, palanjal na saga a'a Sīp inān bo' parahū min si Sa'ul. Pasalta', ina'an si Da'ud maka saga a'ana ma paslangan Ma'on, ma jadjahan Araba tampal ni satan min Jesemon. ");
INSERT INTO sml_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Si Sa'ul isab maka saga sundaluna anagna' na amiha si Da'ud. Jari tasumbung pa'in ni si Da'ud pasalan pagpiha inān, magtūy iya palanjal ni būd abatu ma paslangan Ma'on ati maina'an iya pahanti'. Pagta'u si Sa'ul isab ma pasalan itu-i, niurul e'na pehē' si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Sakali, ina'an disi Sa'ul ma dambila' būd, ati ina'an isab si Da'ud maka saga a'ana ma dambila' magdai'-dai' bo' alahi. Na, baya-baya asekot pa'in si Sa'ul maka saga sundaluna anaggaw si Da'ud, ");
INSERT INTO sml_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","aniya' at'kka pina'an ni si Sa'ul dakayu' sosoho'anna amowa habal, yuk-i, “Tuwan sultan, pakasay lagi' ka. Wa'i kalangpasan lahattam e' saga Pilistin!” ");
INSERT INTO sml_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Magtūy pahali si Sa'ul min pangapasna ma si Da'ud bo' pehē' angatuhan saga Pilistin. Ya itu sababan angkan kaōnan lugal inān Sela Hammalekot. ");
INSERT INTO sml_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Sakali in si Da'ud bay patukad minnē' bo' pat'nna' ma saga patapukan ahogot ya ma kabūran En Gedi. ");
INSERT INTO sml_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Na, makabalik pa'in si Sa'ul min kapanurulna ma saga Pilistin, kahaka'an iya in si Da'ud wa'i ma Paslangan En Gedi. ");
INSERT INTO sml_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Angkan amowa si Sa'ul t'llungibu a'a Isra'il magbobono', a'a bay pene'na, bo' magsakap amiha si Da'ud maka saga a'ana pehē' ni atag Pampang Kambing-talun. ");
INSERT INTO sml_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Sakali maka'abut disi Sa'ul ni pagkukuralan saga bili-bili ya ina'an ma bihing lān. Aniya' isab songab batu maina'an, ati pasōd si Sa'ul pehē' bo' ajamban. Ina'an asal si Da'ud maka saga a'ana ma deyomna to'ongan. ");
INSERT INTO sml_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Yuk a'a inān ni si Da'ud, “Tuwan, ya na itu waktu bay pagkallam si Yawe, ya yuk-i, ‘Tukbalanku bantanu ni komkomannu bo' supaya tahinangnu bang ai ya kabilahiannu.’ ” Jari itu, kamaya'-maya' si Da'ud palele ma halam aniya' makasayuhan iya ati kin'ttob e'na tōng juba si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Tatali'-tali' pa'in e' si Da'ud kapang'ttobna itu, magsusun iya. ");
INSERT INTO sml_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Yukna ni saga a'ana, “He! S'lle' bale puhu'! Bang pa'in aku sinagga' e' PANGHŪꞋ bo' mbal makamula a'a bay pene'na nihinang sultan. Halam aniya' kapatutku angahinang kamulahan ma sultanku sabab PANGHŪꞋ ya bay amat'nna' iya.” ");
INSERT INTO sml_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Minnē' pinabukagan e' si Da'ud saga a'ana maka sinō' sigām da'a angamula si Sa'ul. Jari ala'an na si Sa'ul min songab batu he'. ");
INSERT INTO sml_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Pagubus, paluwas si Da'ud bo' angalingan ni si Sa'ul, yukna, “Owa', tuwan Sultan!” Paglingi' si Sa'ul, magtūy pasujud si Da'ud tanda' sin pagaddatna ma iya. ");
INSERT INTO sml_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Ah'lling si Da'ud yuk-i, “Angay ka akale ma pamitna saga a'a ya ah'lling in aku itu magniyat angamula ka'a? ");
INSERT INTO sml_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Kasaksi'annu na in ka'a bay pamarūl ma aku e' PANGHŪꞋ hinabunu lagi' bay ma deyom songab batu. Aniya' sehe'ku bay anoho' aku amapatay ka'a, sagō' halam ka bay inayku. Ya yukku ma sigām, ‘Mbal aku anawakkal angamula nakura'ku sabab PANGHŪꞋ ya bay amene' iya.’ ");
INSERT INTO sml_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Nda'un ba, bapa', itiya' ma tanganku ya pīs-pīs kakana' bay min jubanu! Bay k'ttobku sagō' halam ka bay papatayku. Na, dongdongin pahāp, in aku itu alipuwas na min dusa niyat amantahan ka'a. Halam aku bay angala'at ka'a sagō' ka'a na pa'in ya angapas aku supaya aku papataynu. ");
INSERT INTO sml_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Na baya'-baya' PANGHŪꞋ na angahukum kita karuwangan. PANGHŪꞋ na isab anungbasan saga kala'atan bay tahinangnu ma aku sagō' in aku baranku mbal anawakkal angamula ka'a. ");
INSERT INTO sml_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Buwat na yuk papata, ‘Min a'a ala'at paluwas kala'atan,’ angkan mbal ka inayku. ");
INSERT INTO sml_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","In ka'a sultan bangsa Isra'il, ati turulnu a'a halam aniya' pūsna? Aku itu hal sadja ko' kahantang patay ero' atawa kammut. ");
INSERT INTO sml_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Na baya'-baya' PANGHŪꞋ angahukum bang sai ma kita taga-kasā'an. Bang pa'in aku binogbogan e'na maka pinuwasan min komkomannu.” ");
INSERT INTO sml_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Pagubus si Da'ud ah'lling itu, atilaw si Sa'ul. Yukna, “Oto'? Da'ud? Ka'a ka amissala ilu?” Jari anangis to'ongan si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","“Abontol lagi' ka min aku,” yukna. “Ahāp ka ma aku saguwā' aku ya bay angala'at ka'a. ");
INSERT INTO sml_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Na, aheya landu' kahāpan ya tahinangnu ma aku sabab minsan aku bay tinukbalan e' PANGHŪꞋ ni komkomannu, halam ka anawakkal angamula aku. ");
INSERT INTO sml_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Aniya' bahā' amasagad bantana alahi ma halam bay minula e'na dahū? Tantu halam. Na, mura-murahan bang pa'in ka tinungbasan e' PANGHŪꞋ ni kahāpan ma sabab kapangahāpnu aku ma llaw itu. ");
INSERT INTO sml_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Manantuhi aku in ka'a ilu magsultan maka ahogot in kapagsultannu ma bangsa Isra'il. ");
INSERT INTO sml_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Buwattina'an, sapahin aku ma matahan PANGHŪꞋ in aku sampay saga panubu'ku mbal papataynu. Mbal isab lungaynu ōnku min salsila kapanubu'an kami.” ");
INSERT INTO sml_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Sakali anapa si Da'ud ma si Sa'ul buwat bay amu'na. Pagubus, amole' na si Sa'ul ni luma'na. Malaingkan si Da'ud maka saga a'ana bay patukad pabalik ni bay patapukan sigām e'. ");
INSERT INTO sml_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Manjari amatay na si Samwel ati magtipun kamemon saga a'a Isra'il magdukkahan iya bo' yampa iya kinubul ma atag luma'na ma Rama. Pagubus, in si Da'ud bay palūd ni paslangan Ma'on. ");
INSERT INTO sml_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Na, aniya' a'a Ma'on landu' dayahan, taga-tana' isab ma kauman Karmel. Aniya' kambingna dangibu hekana maka t'llungibu bili-bilina, jari ina'an iya ma Karmel sabab waktu na panganggunting bulbul saga hayop. ");
INSERT INTO sml_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","Si Nabal ōn a'a itu, maka si Abigail ya ōn h'ndana. Ahāp d'nda si Abigail itu maka ataha' akkalna, saguwā' ab'ngngis sidda h'llana maka ala'at kaul-pi'ilna. Ya si Nabal itu dakayu' panubu' si Kaleb. ");
INSERT INTO sml_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Hinabu lagi' si Da'ud bay ma paslangan, aniya' makahaka'an iya in si Nabal kono' wa'i magguntingan bulbul saga bili-bilina. ");
INSERT INTO sml_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Sakali magpanoho'an si Da'ud ma saga onde' baha'u sangpū' hekana. Yukna ma sigām, “Pehē' kam ni si Nabal wa'i ma Karmel bo' iya saginahunbi ma ōnku. ");
INSERT INTO sml_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Buwattitu pamissalahunbi ma iya, ‘Tuwan, mura-murahan bang pa'in ataha' umulnu. Bang pa'in isab ahāp kuwat-anggawta'nu lapay sampay anak-h'ndanu maka kamemon sasuku ma okomannu. ");
INSERT INTO sml_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Kahaka'an nakura' kami si Da'ud waktu na kono' pagpagunting saga bili-bili. Ya pamissalana ma ka'a, tuwan, sat'ggol bay kamahē' saga magi'ipat bili-bilinu ma atag pahanti'an kami, halam sigām bay la'at kami. Maka ma waktu kamahē' sigām ma Karmel, halam sigām kalungayan minsan ai-na. ");
INSERT INTO sml_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Tilawun pa'in saga tendognu ilu, tantu du ka nihaka'an e' sigām. Angkan amu'ku ma ka'a, tuwan, pa'nda'in kahāpan saga sosoho'anku itu, pagka kami pasabu ma waktu pagjamu itu. Ndū' tuwan, buwanin lagi' saga sosoho'annu itu maka lahasiya'nu si Da'ud ai-ai na tapamuwannu.’ ” ");
INSERT INTO sml_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Pagt'kka saga sosoho'an itu ni si Nabal, magtūy iya pinasampayan lapal bay min si Da'ud. Pagubus, angagad sadja sigām bang ai panambung. ");
INSERT INTO sml_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Jari anambung si Nabal buwattitu yukna, “Sai sa si Da'ud itu? Sai sa anak si Jesse itu? Ma waktu itu-i aheka na landu' saga banyaga' alahi min pagnakura'an sigām. ");
INSERT INTO sml_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Angay subay pamuwanku tinapayku maka bohe'ku ni saga a'a mbal minsan takilāku bang minningga? Maka isi susumbali'an bay tagamahanku saga a'a magguguntingan bulbul bili-biliku, pamuwanku bahā' ma daka sai?” ");
INSERT INTO sml_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Pagka buwattē' panambung si Nabal, amole' ni si Da'ud saga a'ana inān bo' angahaka'an iya kamemon ya bay binissala he' si Nabal. ");
INSERT INTO sml_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Pagkale si Da'ud magtūy iya magpanoho'an ma saga tendogna, “Takosunbi kalisbi!” Magtūy isab sigām magtinakos. Magtakos kalis isab si Da'ud bo' patukad minnē' maka saga magbobono' mpat hatus hekana. Malaingkan aniya' duwa hatus bay magpa'bba anganjagahan saga balanja' maka kapanyapan sigām. ");
INSERT INTO sml_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Na, aniya' sosoho'an disi Nabal bay amowa lapal ma si Abigail ya h'ndana, yuk-i, “Babu', si Da'ud bay magpanoho'an ma saga tendogna min paslangan deya lagi'. Sinō' sigām pehē' ni nakura' kami amowa pagaddat si Da'ud ma iya, sagō' bay tumpalakna si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Parahāl ahāp sidda addat saga a'a inān ma kami. Halam sigām bay anganjahulaka' kami, maka t'ggol kami ma atag sigām, halam kalungayan minsan dansolag ai-ai kami. ");
INSERT INTO sml_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Sat'ggol kami magipat saga kahayopan kami ma atag sigām, sigām ya jaga kami llaw-sangom, kahantang ād apagon angalikusan kami. ");
INSERT INTO sml_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Angkan na, babu', subay ka amikil pahāp bang ai ya tahinangnu ma pasalan palkala' itu, sabab tantu aniya' bala' tum'kka ni nakura' kami sampay ni anak-kampungna. Abigsi' landu' iya angkan halam sai-na makabissalahan iya.” ");
INSERT INTO sml_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Pagkale si Abigail ma lapal itu, magtūy iya magdai'-dai' magsakap. Angā' iya duwa hatus solag tinapay, duwa kuwit kambing pangisihan binu-anggul, lima bili-bili bay niadjal, lima karut pai-tirigu bay sinanglag, dahatus tundun anggul bay pina'llawan, maka duwa hatus kompolan buwa' pigi, ati pinaruwa' kamemon ni saga kura'. ");
INSERT INTO sml_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Pagubus, ah'lling iya ni saga sosoho'anna, yukna, “Parahū na kam min aku ati paturul pa'in aku.” Saguwā' halam pinata'u e'na h'llana. ");
INSERT INTO sml_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Hinabu si Abigail pakura' labay min t'ngnga' kapampangan, ina'an isab si Da'ud maka saga a'ana tudju ni iya. Jari bināk sigām he'na. ");
INSERT INTO sml_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Baha'u du bay makapah'lling si Da'ud, yuk-i, “Kaliman hulas-sangsā'ku anganjagahan palsuku'an a'a inān mahē' ma paslangan. Halam aniya' bay alungay ma saga ai-aina, sagō' kala'atan ya panungbasna ma kahāpan bay tahinangku. ");
INSERT INTO sml_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Bang pa'in aku pinagmulka'an e' Tuhan bang aniya' dakayu' l'lla min okoman si Nabal kakapinanku allum pagabut subu!” ");
INSERT INTO sml_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Pag'nda' si Abigail ma si Da'ud, magtūy iya paruwa'i min kura'na bo' pasujud ma dahuwan si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Pasekot-sekot gi' iya bo' magmalulus ma atag tape'na. Yukna ma si Da'ud, “Tuwan, amu'ku ma ka'a, aku ya bīngin. Parūlun lagi' sosoho'annu itu amissala ni ka'a. Kalehun bissalaku itu, tuwan. ");
INSERT INTO sml_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Ya pangamu'ku ma ka'a, da'a asipun a'a patila'atun inān, ya si Nabal. Magtaluwa' iya maka ōnna, hatina Dupang, pagka karupangan sadja ya kaluwasan saga hinangna. Bo' arapun, ma tongod sin sosoho'annu itu, tuwan, tu'ud halam ta'nda'ku saga a'a ya bay papehē'nu ni h'llaku. ");
INSERT INTO sml_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","“Na, tuwanku, kahandak PANGHŪꞋ asal angkan halam kalanjalannu amalos magbaran maka amapatay. Angkan sapahanku min ōn si Yawe ya kakkal salama-lama, maka min ōnnu, bang pa'in pasali' ni si Nabal saga palbantahannu maka sasuku anganiyat angamula ka'a. ");
INSERT INTO sml_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Taima'un isab, tuwan, saga huhulmatan bay bowaku itu bo' pamuwanun ma saga bebeya'annu ilu. ");
INSERT INTO sml_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Amu'ku junjung isab ni ka'a bang pa'in ampunnu kasā'an ummatnu itu. Tantu pinatatas e' PANGHŪꞋ in kapagsultannu sampay ni saga panubu'nu magsuring-magsaingsing, sabab palbantahan PANGHŪꞋ asal saga a'a ya bowanu magbono'. Mura-murahan, tuwan, bang pa'in ka mbal makahinang dusa sat'ggolnu allum. ");
INSERT INTO sml_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Malaingkan minsan ka pinagturul bo' pinapatay, mbal ka magmula sabab asalamat nyawanu, tinau' pahogot e' PANGHŪꞋ ma deyom tatau'anna. Sagō' in kallum saga bantanu sapantun batu pinitikan, mbal na tapiha. ");
INSERT INTO sml_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Bistahun, tuwan, bang ta'abut waktu kapanuman e' PANGHŪꞋ kamemon saga kahāpan bay panganjanji'na ma ka'a, ati tahinang ka pagmakōkan ma bangsa Isra'il, ");
INSERT INTO sml_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","wajib subay halam aniya' dusanu pagsusunannu. Angkan subay mbal nilanjalan niyatnu amalos atawa amapatay a'a ma halam aniya' po'on-sababna tantu. Jari bang ka nianughala'an na e' Tuhan, ndū', da'a aku kalipatun.” ");
INSERT INTO sml_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Jari ah'lling si Da'ud ni si Abigail yukna, “Pudji ni si Yawe, ya pagtuhanan bangsa Isra'il, sabab in iya bay anoho' ka'a amāk aku. ");
INSERT INTO sml_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Bang pa'in iya amuwanan ka'a kahāpan ma sabab kahāp akkalnu llaw itu. Ka'a ya sababan angkan halam kalanjalanku niyatku amapatay a'a llaw itu. Arak aku bay amalos magbaran. ");
INSERT INTO sml_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Malaingkan, sapahanku min ōn si Yawe, ya Tuhan bangsa Isra'il, in iya bay anagga' aku angamula ka'a. Sabab, bang ka bay halam makasa'ut pi'itu, arak mbal kakapinan minsan dakayu' l'lla min panubu' si Nabal pagk'llat llaw.” ");
INSERT INTO sml_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Sakali tinaima' na e' si Da'ud saga bobowahan si Abigail maka e'na ah'lling, yuk-i, “Amole' na ka ma halam aniya' kahanggawannu. Beya'ku kamemon ya bay junjungnu ilu ma aku.” ");
INSERT INTO sml_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Manjari amole' na si Abigail. Magsalta', si Nabal bay amaniya' paglami-lami ma luma'na, buwat sapantun kahinangan pagjamu sultan. Nilango to'ongan si Nabal maka magkakoyagan, angkan halam iya binissalahan ai-ai e' si Abigail sampay ni kasubuhan. ");
INSERT INTO sml_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Pagsubu pa'in bo' palabay na lango si Nabal, binissalahan iya e' h'ndana pasal kamemon bay paniya' ma pagsampangna maka si Da'ud. Pagkale si Nabal, magtūy ap'ddi' kōk atayna ati anuwas baranna. ");
INSERT INTO sml_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Palabay pa'in saga sangpū' llaw, amatay iya min kawasa PANGHŪꞋ. ");
INSERT INTO sml_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Pagta'u si Da'ud ma pasal kamatay si Nabal, ah'lling iya, yukna, “Pudji ni PANGHŪꞋ ya bay amalosan aku ma si Nabal ma sabab kapangahina'na ma aku. Tuhan ya bay angaliyusan aku min hinang kala'atan ati papelleng ni a'a inān saga kahinanganna ala'at.” Pagubus magpanoho'an si Da'ud amah'nda si Abigail ati ");
INSERT INTO sml_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","pehē' saga sosoho'anna ni Karmel amowa lapal ni si Abigail, yuk-i, “Bay kami pinapi'itu e' nakura' kami si Da'ud supaya amah'nda ka'a.” ");
INSERT INTO sml_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Pasujud magtūy si Abigail maka he'na anambung, yukna, “Aku itu atabi, sakap aku amahilala' ka'am sampay angose'an tape'bi.” ");
INSERT INTO sml_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Ati magdai'-dai' ya pakura' ni kura'na bo' pabunyug ma saga sosoho'an si Da'ud. Sinehe'an isab iya e' lima ipatanna d'nda. Minnē' iya ta'ā' h'nda e' si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Tah'nda isab e' si Da'ud si Ahinowam d'nda min Jesde'el, jari magkalu'a sigām karuwangan. ");
INSERT INTO sml_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Saguwā' si Mikal, ya bay h'nda si Da'ud po'on, wa'i pamah'nda e' si Sa'ul ma si Paltiyel ya anak si Lais, a'a min Galim. ");
INSERT INTO sml_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Na, aniya' saga a'a min lahat Sīp bay pehē' ni si Sa'ul hinabuna ma Gibeya supaya anumbung pasal si Da'ud. “Tuwan sultan,” yuk sigām, “ina'an si Da'ud patapuk ma būd Hakila ya ma anggopan Jesemon.” ");
INSERT INTO sml_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Manjari, pehē' ni paslangan Sīp si Sa'ul maka t'llungibu a'a Isra'il magbobono' ya bay pene'na, bo' amiha si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Bay magpustu asal si Sa'ul ma bihing lān, ina'an ma būd Hakila ma anggopan Jesemon, malaingkan in si Da'ud wa'i ma paslangan. Pagta'u si Da'ud pasal si Sa'ul bay anurul iya pina'an, ");
INSERT INTO sml_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","aniya' saga a'a soho'na pehē' ang'nda'. Jari tata'una min sigām, b'nnal, ina'an na si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Sakali, magsakap si Da'ud bo' pehē' ni atag pagpustuhan si Sa'ul. Ta'nda'na bang maingga patulihan si Sa'ul maka si Abner ya pagnakura'an kamemon saga sundaluna. Si Abner itu anak si Nēr. Na, ma waktu inān, in si Sa'ul atuli ma pustu, ma t'ngnga'-t'ngnga' ba'anan saga bobono'na. ");
INSERT INTO sml_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Na, atilaw si Da'ud ma si Ahimelek a'a bangsa Hīt maka si Abisai ya danakan si Jowab. (Si Seruya ya ina' sigām). Yuk panilaw si Da'ud, “Sai ameya' ma aku palūd ni si Sa'ul ma pustu inān?” Anambung si Abisai. “Aku,” yukna. ");
INSERT INTO sml_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Angkan sangom he'-i du, nil'ngngan pustu si Sa'ul e' si Da'ud maka si Abisai ati ta'nda' sigām si Sa'ul atuli maina'an. Ina'an paosol budjakna ma tana' min kōkanna, maka ina'an isab si Abner maka saga sundalu kasehe' atuli ma katilibutna. ");
INSERT INTO sml_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Maina'an pa'in, pahigung-higung si Abisai ni si Da'ud, yukna, “Tuwan, ya na itu waktu panukbal bantanu ni ka'a e' Tuhan. Dūlin aku amudjak iya ni tana'. Pamint'ddaku sadja.” ");
INSERT INTO sml_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Saguwā' yuk sambung si Da'ud, “Oy! Da'a iya bono'un! Sabab tantu tinungbasan e' Tuhan sasuku angamula sultan ya tapene'na. ");
INSERT INTO sml_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Sapahanku ma ōn si Yawe, ya Tuhan kakkal salama-lama,” yuk si Da'ud, “Tuhan sadja ya magkahandak ma ganta'an si Sa'ul. Bang ngga'i patay saki atawa patay to'a, amatay iya ma pagbono'an. ");
INSERT INTO sml_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Sagō' s'lle'-bale puhu' pinatā e' PANGHŪꞋ bang pa'in mbal tamulaku a'a bay tapene'na magsultan ilu. Na, ngā'un na budjak maka pangisihan bohe' ya ma atag kōkna ilu bo' kita sūng na!” ");
INSERT INTO sml_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Jari ningā' e' si Da'ud budjak maka pangisihan bohe' ya bay ma kōkan si Sa'ul ati ala'an na sigā. Halam aniya' minsan sai makata'u atawa maka'nda' sigām maka halam minsan sai bay makabati'. Ahaluk sidda tuli sigām kamemon sabab PANGHŪꞋ ya bay amahaluk sigām. ");
INSERT INTO sml_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Sakali itu, palintas na si Da'ud ni dambila' kapantayan bo' an'ngge maina'an ma būd, atā-tā min disi Sa'ul. Asal aluha pag'llotan sigām. ");
INSERT INTO sml_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Manjari, angolang si Da'ud ni saga sundalu si Sa'ul maka ni si Abner, yukna, “Owa' Abner! Mbal aku sambungannu?” Anambung si Abner yukna, “Sai sa ka angolangan sultan ilu?” ");
INSERT INTO sml_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Yuk si Da'ud, “L'lla ka bahā' Abner? Bang pina'amu, halam sali'nu ma Isra'il! Na, angay halam jagahannu pahāp sultan ya pagpanghū'annu ilu? Sabab aniya' a'a bay pasōd pi'ilu arak angamula iya. ");
INSERT INTO sml_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Mbal ahāp hinangnu ilu! Sapahanku ma ōn si Yawe ya kakkal salama-lama, in ka'a maka saga sehe'nu ilu patut subay pinapatay sabab halam bay jagahannu nakura'nu, ya bay tapene' e' PANGHŪꞋ. Ang'nda' ka ni katilibutnu. Maingga na budjak sultan maka pangisihanna bohe' ya bay ma kōkanna ilu?” ");
INSERT INTO sml_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Takilā magtūy e' si Sa'ul suwala si Da'ud angkan iya ah'lling, yukna, “Da'ud, oto'! Ka'a ka amissala ilu?” Anambung si Da'ud, yukna, “Aho' tuwan sultan, aku ko' itu.” ");
INSERT INTO sml_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Ah'lling lagi' si Da'ud, “Tuwan,” yukna, “kasā'an ai bay tahinang e' sosoho'annu itu angkan aku subay papataynu? Abontol sadja itikadku angkan mbal aku katōngan dusa. ");
INSERT INTO sml_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Da'a busung, tuwan sultan, kalehun lagi' pah'llingku itu. Bang hati PANGHŪꞋ ya bay anoho' ka'a amantahan aku, na, tukbalun lalabotan ni iya. Kalu tinaima' e'na. Saguwā' bang manusiya' ya amitnahan ka'a, bang pa'in sigām taluwa' sukna' PANGHŪꞋ. Sabab itiya' aku tin'ggal paluwas min lahat bay pamusaka' aku e' PANGHŪꞋ, lāgi sinoho' isab aku magsumba ni saga katuhan-tuhanan bangsa liyu. ");
INSERT INTO sml_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Ndū' tuwan,” yuk si Da'ud, “da'a aku pasagarin amatay ma lahat bangsa liyu, alawak min matahan si Yawe. Angay aku subay piniha e' sultan bangsa Isra'il? Aku itu sapantun kutu ero' ya pihanu ma kabūd-būran, buwat a'a amiha manuk-manuk.” ");
INSERT INTO sml_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Jari anambung si Sa'ul, yukna, “Bay aku makarusa. Ndū' Da'ud, oto', bang pa'in ka pabalik ni aku. Pagka ahalga' ma ka'a kallumku itu, mbal na balikanku niyatku amapatay ka'a. Sali' aku dupang, aheya kasā'an bay tahinangku ma ka'a.” ");
INSERT INTO sml_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","“Ā, itiya' budjaknu tuwan sultan,” yuk sambung si Da'ud ma si Sa'ul. “Soho'un pi'itu dakayu' tendognu ilu angā'. ");
INSERT INTO sml_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Baya'-baya' PANGHŪꞋ na anungbas ni kahāpan ma saga a'a sasuku abontol maka kapangandolan.” Ah'lling gi' si Da'ud yukna, “Ka'a tuwan, bay tinukbalan e' PANGHŪꞋ ni komkomanku insini', sagō' halam aku makatawakkal angamula ka'a sabab in ka'a sultan bay tapene' e' Tuhan. ");
INSERT INTO sml_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Mura-murahan bang pa'in aku pinagka'inagonan e' PANGHŪꞋ maka niliyusan e'na min kamemon katiksa'anku, buwat bay pagka'inagonku ma ka'a insini'.” ");
INSERT INTO sml_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Sakali ah'lling na si Sa'ul ni si Da'ud, yukna, “Oto', bang pa'in ka nilidjiki'an e' PANGHŪꞋ. Tantu ajatu ai-ai kamemon ya tagna'annu, maka anganda'ug sadja ka ma pagbono'an.” Pagubus, palanjal na si Da'ud ni pal'ngngananna, maka amole' na si Sa'ul ni lahatna. ");
INSERT INTO sml_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Saguwā' minsan buwattē' bissala si Sa'ul, maghona'-hona' na pa'in si Da'ud bo' yukna ma deyom atayna, “Tantu aku binono' e' si Sa'ul ma llaw sinosōng. Ahāp lagi' aku alahi pehē' ni lahat Pilistin. Pahali si Sa'ul amiha aku bang aubus e'na angalatag katilingkal lahat Isra'il, ati alipuwas aku min iya.” ");
INSERT INTO sml_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Jari si Da'ud maka saga a'ana nnom hatus hekana bay palanjal minna'an bo' palain ni da'ira Gāt, ni sultan Akis ya anak si Ma'ok. ");
INSERT INTO sml_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Sakali maina'an sigām pahanti' ma Gāt, ma okoman si Akis. Maina'an sigām pahanti' ma okoman sultan e', sigām kaniya-kaniya maka anak-h'nda sigām. Ina'an isab si Da'ud maka duwa h'ndana, ya na si Ahinowam min Jesde'el maka si Abigail min Karmel, ya bay balu si Nabal. ");
INSERT INTO sml_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Jari kahaka'an pa'in si Sa'ul in si Da'ud wa'i na makalahi ni Gāt, pahali na iya amiha. ");
INSERT INTO sml_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Palabay pa'in waktu, ah'lling si Da'ud ni si Akis, yukna, “Tuwan, bang ka kasulutan du ma aku, pamarūlun ma aku dakayu' kaumannu bo' supaya aku makapaglahat mahē'. Mbal patut sosoho'annu itu paokom ma ka'a ma da'ira bangsahan itu.” ");
INSERT INTO sml_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Angkan ma llaw ina'an du, pamuwan e' si Akis ma si Da'ud kauman Siklag. Jari in kauman inān tahinang palsuku'an saga sultan bangsa Yuda sampay ni kabuwattina'anan. ");
INSERT INTO sml_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Saga dantahun maka mpat bulan ya kapaglahat si Da'ud ma deyoman saga bangsa Pilistin. ");
INSERT INTO sml_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Na ma waktu inān, angalangpas na pa'in si Da'ud maka saga tendogna ni saga bangsa Gesur, bangsa Girsi maka bangsa Amalek. Saga bangsa itu bay asal maina'an min awal lagi'. Ya paglahat sigām pa'abut ni Sūr, sampay isab ni lahat Misil. ");
INSERT INTO sml_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Sakahaba' waktu kalangpas si Da'ud ni kaluma'an saga bangsa itu, halam aniya' kapinanna allum minsan dakayu' d'nda ka atawa l'lla. Ya nilangpas e'na saga bili-bili maka sapi' sampay saga kura' maka unta' maka pan'mmek. Jari pabalik na pa'in iya ni si Akis. ");
INSERT INTO sml_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Bang tinilaw si Da'ud e' si Akis bang pi'ingga bay parugpakanna, anambung iya buwattitu, yukna, “Bay kami parugpak ni lahat Yuda tampal ni satan.” Suma'an buwattitu panambungna, “Bay kami ni lahat Jerame'el tampal ni paslangan.” Atawa, “Bay kami pehē' ni kauman bangsa Kēn ya ma paslangan isab.” ");
INSERT INTO sml_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Mbal kinapinan allum e' si Da'ud minsan dakayu' d'nda atawa l'lla allum, sabab ma pikilanna, “Ya aniya', bang aniya' l'lla atawa d'nda binowa ni Gāt, makasumbung lagi' sigām bang ai bay tahinangku.” Buwattē' kahinangan si Da'ud t'ggolna pat'nna' ma lahat Pilistin. ");
INSERT INTO sml_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Manjari, pangandolan iya e' si Akis sabab yukna ni baranna, “Tantu kinab'nsihan na si Da'ud itu e' saga pagkahina bangsa Isra'il, angkan halam dapat bang iya mbal amogbogan aku sat'ggolna allum.” ");
INSERT INTO sml_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Manjari palabay pa'in waktu, pinapagtipun saga sundalu bangsa Pilistin supaya amowa magbono' ma bangsa Isra'il. Ah'lling si Akis ni si Da'ud, yukna, “Tahatinu du in ka'a maka saga tendognu ilu subay pagapi' ma aku ma pagbono'an.” ");
INSERT INTO sml_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Anguyun si Da'ud, yukna, “Na, tuwan, song ta'nda'nu bang ai tahinang e' sosoho'annu itu.” Anambung si Akis, “Ahāp ko' ilu. Angkan na ka hinangku jaga ma baranku sat'ggolku allum.” ");
INSERT INTO sml_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Malaingkan in si Samwel bay na asal amatay. Bay na iya pinagdukka'an e' kamemon saga jama'a Isra'il, ati wa'i bay kinubul e' sigām ma Rama, ya lahatna luggiya'. Ma waktu he'-i, bay na asal tin'ggal e' si Sa'ul kamemon saga a'a magpang'nda' umagad maka saga magjijīn min lahat Isra'il. ");
INSERT INTO sml_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Sakali itu, magtipun na saga sundalu Pilistin bo' pehē' magpustu ma Sunem. Pasalta' in si Sa'ul bay amatimuk saga sundaluna bangsa Isra'il bo' magpustu ma Gilbowa. ");
INSERT INTO sml_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Pag'nda' si Sa'ul ma ba'anan sundalu Pilistin, magtūy iya sinōd tāw mbal tapula'-pula'. ");
INSERT INTO sml_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Angkan iya angaru ni PANGHŪꞋ bang ai subay hinangna, sagō' halam aniya' lapal PANGHŪꞋ pinasampay ma iya, ai naka ma uppina, ai naka min Urim atawa min saga nabi. ");
INSERT INTO sml_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Pagka buwattē', ah'lling si Sa'ul ni saga tendog ya pangandolanna, yukna, “Piha'inbi aku d'nda maglilingan umagad bo' supaya aku makapangaru ma iya.” “Tuwan,” yuk sambung saga tendog inān, “aniya' kono' maina'an ma kauman Endor.” ");
INSERT INTO sml_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Sakali itu, magbinadju' saddī si Sa'ul supaya halam aniya' makakilā iya. Jari sangom inān pehē' na iya maka duwa tendogna ni luma' d'nda. Makat'kka pa'in, yuk si Sa'ul ni iya, “Bilahi aku angaru ni umagad a'a bay amatay. Tugila'ku pa'in ma ka'a bang sai subay linganannu.” ");
INSERT INTO sml_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Sagō' yuk sambung d'nda, “Tantu kasakupannu bang ai ya bay panoho'an si Sa'ul. Bay pala'anna min lahat Isra'il kamemon saga a'a maglilingan umagad maka saga magjijīn. Tu'ud ko' ka'a ilu pasulay anganjallat aku bo' supaya aku pinat'nna'an hukuman ni kamatay.” ");
INSERT INTO sml_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Pagga buwattē' anapa si Sa'ul, yukna, “Sapahanku ma ōn si Yawe, ya kakkal salama-lama, halam aniya' kamulahan tum'kka ni ka'a ma sabab palkala' itu.” ");
INSERT INTO sml_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Jari tinilaw na iya e' d'nda inān, yukna, “Umagad sai kabilahiannu lingananku?” “Umagad si Samwel,” yuk sambung si Sa'ul. ");
INSERT INTO sml_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Pag'nda' pa'in d'nda inān ma umagad si Samwel, magtūy iya angolang pakosog maka e'na atilaw ma si Sa'ul, yukna, “Angay aku bay akkalannu? Ka'a tuwi' sultan Sa'ul!” ");
INSERT INTO sml_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Sakali yuk sultan ma iya, “Da'a ka tināw. Ai ta'nda'nu ilu?” Ya sambung d'nda, “Tuwan,” yukna, “maka'nda' aku umagad pabungkal min tana'.” ");
INSERT INTO sml_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Atilaw si Sa'ul, yukna, “Buwattingga luwana?” “Matto'a l'lla magjinuba,” yuk sambung d'nda inān. Manjari kinata'uwan magtūy e' si Sa'ul si Samwel na ko' inān, angkan iya pasujud. ");
INSERT INTO sml_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Yuk si Samwel ni iya, “Angay lagi' aku sasatnu pagka aku bay soho'nu pinabangun?” Anambung si Sa'ul, yukna, “Landu' aheya kasukkalanku. Itiya' aku binono' e' saga a'a Pilistin, maka tinaikutan na aku e' PANGHŪꞋ. Mbal na sinambungan pangaruku, ai naka ma uppi atawa pinalabay min saga nabi. Angkan ka bay soho'ku pinalinganan bo' supaya aku pituwahannu bang ai subay hinangku.” ");
INSERT INTO sml_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Yuk si Samwel, “Angay lagi' aku subay pangaruhannu saukat ka bay tinaikutan maka binantahan e' PANGHŪꞋ? ");
INSERT INTO sml_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Tahinang na e'na ya bay pagkallamna labay min aku. Ilu na niragtu' e'na min ka'a kapagsultannu bo' pamuwanna na ma dakayu' pagkahinu, ya na si Da'ud. ");
INSERT INTO sml_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Angkan itu nihinang e' PANGHŪꞋ ma ka'a buwattina'an sabab halam bay beya'nu panoho'anna. Halam bay pasampaynu mulka'na ma saga bangsa Amalek. ");
INSERT INTO sml_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Jari in ka'a maka saga bangsa Isra'il marai' na tinukbalan e' PANGHŪꞋ ni komkoman bangsa Pilistin. Pagsalung,” yuk umagad si Samwel, “ka'a maka saga anaknu l'lla parakayu' du ma aku maitu ma ahirat. Damikiyanna isab saga sundalu bangsa Isra'il, tinukbalan e' PANGHŪꞋ ni komkoman bangsa Pilistin.” ");
INSERT INTO sml_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Saru'un-du'un du magtūy kum'ppang si Sa'ul ni tana', maka sinōd iya tāw landu' aheya ma pasalan pamissala si Samwel he'. Na, alamma si Sa'ul pagka halam bay amangan animpus dang'llaw maka dasangom. ");
INSERT INTO sml_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Manjari pasekot d'nda he', ati ta'nda'na ina'an si Sa'ul amidpid kabowa tāwna, angkan yukna, “Tuwan sultan, bay na beya'ku panoho'annu. Bay panūkku kallumku ni kamatay sabab pameya'ku ma panoho'annu. ");
INSERT INTO sml_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ndū' Tuwan,” yukna, “da'a busung, kalehun lagi' pamissala sosoho'annu itu maka dūlin aku angadjalan ka'a takakan bo' supaya pabalik kosognu ati bo' ka makalanjal ni pal'ngnganannu.” ");
INSERT INTO sml_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","“Ē! Mbal aku amangan!” yuk sambung si Sa'ul. Sagō' magbeya' saga tendog maka d'nda inān amogos na pa'in si Sa'ul, sampay iya tapogosna. Pagubus, pabangun iya min tana' bo' aningkō' ma pabahakanna. ");
INSERT INTO sml_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Na, aniya' anak sapi' al'mmok taipat e' d'nda inān, magtūy sinumbali' e'na. Angaddun isab iya tirigu bo' hinangna tinapay halam taga-pasulig. ");
INSERT INTO sml_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Atahak pa'in, pinat'nna' na e'na ni si Sa'ul maka saga tendogna ati amangan sigām. Pagubus, ma sangom he'i du, palanjal na sigām amole'. ");
INSERT INTO sml_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Na, magtipun na kamemon sundalu bangsa Pilistin ma Apek, ati in sundalu bangsa Isra'il ina'an magpustu ma atag tigbaw ma Jesde'el. ");
INSERT INTO sml_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Pal'ngngan na pa'in saga pagnakura'an bangsa Pilistin magbeya' maka saga tumpukan sundalu sigām ma hatusan maka ma ibuhan. Pasalta', ina'an isab si Da'ud maka saga a'ana pal'ngngan min buli'an magabay maka sultan Akis. ");
INSERT INTO sml_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Atilaw isab saga nakura' kasundaluhan Pilistin ma si Akis, yuk-i, “Magay saga Hibrani itu?” Anambung si Akis, yukna, “Si Da'ud ko' ilu, ya bay tendog si Sa'ul, ya sultan bangsa Isra'il e'. Aniya' na iya labi dantahun ma deyomanku. Min waktu lagi' kala'anna min okoman si Sa'ul sampay ni kabuwattina'anan, halam iya karapatanku.” ");
INSERT INTO sml_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Sagō' akagit atay saga nakura' sundalu inān ma si Akis angkan yuk sigām, “Papole'un a'a ilu ni kauman bay pamuwannu paglahatan ma sigām. Mbal iya wajib pabunyug ma kitam ni pagbono'an! Sabab ya aniya' papinda angatuhan kitam hinabu ma pagbono'an. Tantu iya amonggolan kōk saga sundalutam bo' supaya iya makapaghāp maka sultan ya bay nakura'na. ");
INSERT INTO sml_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Ya na ko' ilu si Da'ud, ya pinagkalang e' saga kar'ndahan, yuk-i, ‘Ibuhan tapapatay e' sultan Sa'ul, ati hatusan ibu isab ma si Da'ud’.” ");
INSERT INTO sml_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Manjari, pinalinganan si Da'ud e' si Akis bo' binowa magbissala. Yuk si Akis ma iya, “Sapahanku ma ōn si Yawe, ya kakkal salama-lama, in ka'a ilu kapangandolan angkan kasulutan sidda aku bang ka ganta' pabunyug ma aku maka saga sundaluku. Min waktu lagi' kat'kkanu sampay ni kabuwattina'anan, halam aniya' kasā'an tabākku ma ka'a. Sagō' mbal kasulutan saga pagkahiku nakura' Pilistin. ");
INSERT INTO sml_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Angkan amole' na ka ma halam aniya' lengog. Maka da'a ka angahinang ai-ai ya makala'at pangatayan sigām kasehe' itu.” ");
INSERT INTO sml_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","“Angay tuwan? Ai dusaku?” yuk si Da'ud. “Ai kasā'an bay tahinang e' tendognu itu min waktu katagna'ku paokom ma ka'a sampay ni waktu itu? Ai sababanna ya angkan aku mbal makajari ameya' ma ka'a amono' saga a'a ya amantahan ka'a, tuwan sultan?” ");
INSERT INTO sml_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Anambung si Akis, yukna, “Kasulutan sidda aku ma ka'a, sapantun ka mala'ikat Tuhan ma pang'nda'ku. Malaingkan, bay makakabtang saga nakura' Pilistin in ka'a kono' mbal wajib ameya' ma kami ni pagbono'an. ");
INSERT INTO sml_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Angkan yukku ma ka'a, in ka'a maka saga tendog si Sa'ul ya sehe'nu ilu subay angawal salung bo' magla'anan minnilu ma halam gi' pak'llat llaw.” ");
INSERT INTO sml_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Sakali, pagdai' llaw pa'in, pabungkal na si Da'ud maka saga a'ana bo' amole' pabīng ni lahat Pilistin. Sagō' in saga sundalu Pilistin patukad na ni da'ira Jesde'el. ");
INSERT INTO sml_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Manjari itu, pagpuwas pa'in t'llung'llaw, at'kka na si Da'ud maka saga a'ana ni Siklag ya kauman sigām. Sagō' waktu sigām lagi' bay ma labayan, in kauman Siklag sampay lahat Yuda tampal ni s'ddopan inān bay nirugpak e' bangsa Amalek. Tatunu' isab e' sigām saga kaluma'an ma kauman Siklag, ");
INSERT INTO sml_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","tasaggaw isab kamemon kar'ndahan sampay saga a'a kamemon onde'-matto'a ya bay maina'an. Malaingkan halam aniya' bay pinapatay minsan dakayu', hal bay sinaggaw e' saga a'a Amalek bo' binowa ala'an. ");
INSERT INTO sml_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Na, pagt'kka si Da'ud maka saga a'ana ni kauman Siklag inān, ta'nda' e' sigām atunu' kamemon, maka saga anak-h'nda sigām wa'i bay nilahiyan. ");
INSERT INTO sml_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Angkan maglemong disi Da'ud sampay sigām apaya na e' paglemong sigām. ");
INSERT INTO sml_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Ya karuwangan h'nda si Da'ud, ya si Abigail maka si Ahinowam, wa'i du talapay tasaggaw. ");
INSERT INTO sml_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Aheya isab kasusahan si Da'ud sabab pinagbambahan iya binantung e' saga a'ana kabowa astol sigām ma pasalan kasaggaw saga anak sigām d'nda-l'lla. Malaingkan pakosog iman si Da'ud ma sabab pangandolna ma si Yawe ya Tuhanna. ");
INSERT INTO sml_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Manjari ah'lling si Da'ud ni imam Abiyatar ya anak si Ahimelek. Yukna, “Tuwan, bowahin aku pi'itu epod e'.” Sakali binowa na ni iya e' si Abiyatar. ");
INSERT INTO sml_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Maina'an pa'in, angaru si Da'ud ni PANGHŪꞋ, yukna, “Wajib bahā' aku paturul ni saga a'a bay parugpak ni kauman itu? Ta'abutku bahā' sigām?” Anambung PANGHŪꞋ, yukna, “Aho', turulun sigām pehē'. Tantu sigām ta'abutnu maka talappasnu saga anak-h'ndabi.” ");
INSERT INTO sml_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Sakali, lum'ngngan na si Da'ud magbeya' maka saga a'ana nnom hatus puhu'. Makat'kka pa'in sigām ni L'bbak Besor, magpa'bba maina'an in kasehe'an sigām. ");
INSERT INTO sml_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Aniya' duwa hatus puhu' ma sigām magbale'an to'ongan angkan mbal makatukad ni pampang ya ma dambila' l'bbak inān. Malaingkan in si Da'ud maka mpat hatus a'ana bay palanjal angapas saga bangsa Amalek. ");
INSERT INTO sml_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Na, aniya' a'a Misil talanggal e' sigām ma huma, jari binowa iya e' sigām ni si Da'ud. Binuwanan iya takakan maka bohe' ni'inum. ");
INSERT INTO sml_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Ya pamakan sigām ma iya buwa' igira bay kinompol maka duwa tundun anggul bay pina'llawan. Bay pa'in iya makakakan, pahāp na palasahanna pabalik, sabab halam iya bay makakakan ai-ai atawa makainum bohe' ma deyom t'llung'llaw t'llumbahangi. ");
INSERT INTO sml_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Manjari, tinilaw iya e' si Da'ud, yukna, “Sai nakura'nu, maka m'nningga ka?” Anambung l'lla inān, yukna, “Tuwan, aku itu bangsa Misil. Banyaga' aku ma dakayu' a'a bangsa Amalek. Bay aku pinasagaran e'na t'llung'llaw na palabay pagka aku bay asaki. ");
INSERT INTO sml_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Bay kami parugpak ni lahat s'ddopan, ni tana' bangsa Keret maka ni kauman ya palsuku'an saga bangsa Yuda, maka ni tana' isab saga panubu' si Kaleb. Bay isab tunu' kami kauman Siklag.” ");
INSERT INTO sml_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Atilaw si Da'ud pabalik, yukna, “Katuli'annu aku pehē' ni saga bangsa Amalek he'?” “Aho' tuwan,” yuk sambung l'lla inān. “Kasehe'anta ka pehē' ni sigām bang pa'in sapahannu ma matahan Tuhan in aku mbal papataynu atawa tukbalannu pabalik ni bay nakura'ku.” ");
INSERT INTO sml_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Na, sinehe'an na si Da'ud e' l'lla bangsa Misil inān palūd pehē' ni saga bangsa Amalek. Ina'an sigām magkaukanat ma lugal pagpustuhan sigām, magkakanan maka maginuman. Aheya paglami-lami sigām ma sabab kaheka pangalta' bay tataban sigām min paglahat bangsa Pilistin maka min Yuda. ");
INSERT INTO sml_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Binono' magtūy sigām e' disi Da'ud min kohap inān sampay ni kasangoman ma llaw dakayu'. Halam aniya' minsan dangan min saga a'a Amalek bay makal'ppa, luwal mpat hatus onde' baha'u bay pakura' ma unta' alahi. ");
INSERT INTO sml_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Ta'ā' pabalik e' si Da'ud kamemon bay tataban e' bangsa Amalek, beya' na duwangan h'ndana. ");
INSERT INTO sml_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Ta'ā' e'na kamemon, halam kakulangan minsan dansolag, ai naka onde'-matto'a, d'nda ka atawa l'lla. Ta'ā' sampay saga pangalta' bay tataban aheya-ariki'. ");
INSERT INTO sml_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Ta'ā'na isab kamemon saga bili-bili maka saga kahayopan, bo' pinal'ngngan e' saga a'ana min dahuwan sigām. Ya pagpa'in sigām, “Palsuku'an si Da'ud tatabanan itu kamemon.” ");
INSERT INTO sml_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Na, pabīng na si Da'ud ni saga a'ana duwa hatus hekana ya ina'an bay magpa'bba ma L'bbak Besor pagka sigām bay landu' apaya. Jari pasōng saga a'a itu amāk si Da'ud maka ba'anan saga sehe'na. Asekot pa'in disi Da'ud, sinagina sigām pahāp. ");
INSERT INTO sml_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Malaingkan aniya' saga a'a asabul maka ala'at kasuddahanna pabeya' asal ma si Da'ud. Yuk saga a'a itu, “Mbal sigām patut pinahampit saga tatabanan ilu sabab halam sigām bay ameya' ma kitam. Sagō' makajari sigām angā' saga anak-h'nda sigām bo' magpole'an na.” ");
INSERT INTO sml_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","“Mbal manjari, saga danakan,” yuk sambung si Da'ud. “Da'a kam maghinang buwattilu ma bay tahinang e' PANGHŪꞋ ma kitam. Bay kitam nihampanan e'na, maka bay tukbalanna ni deyom komkomantam saga a'a ya bay amono' kitam. ");
INSERT INTO sml_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Mbal tabeya' kabilahianbi ilu, kalna' in bahagi' a'a bay magpa'bba anunggu'an saga balanja' subay pinapagsali' maka bahagi' a'a bay ameya' ni pagbono'an. Pinapagtopod in bahagi' dangan maka dangan.” ");
INSERT INTO sml_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Ya sara' bay pinaniya' e' si Da'ud itu binogbogan na pa'in e' bangsa Isra'il sampay ni kabuwattina'anan. ");
INSERT INTO sml_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Na, makabalik pa'in si Da'ud ni Siklag, bay pinabeya' e'na kasehe' tatabanan ni saga bagayna ya pagmatto'ahan ma Yuda. Aniya' isab lapalna, yukna, “Itu saga tatabanan bahagi'bi min saga a'a banta PANGHŪꞋ.” ");
INSERT INTO sml_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Bay isab binahagi'an e'na saga a'a ma Betel, ma Ramot-ni-S'ddopan maka ma Jattir. ");
INSERT INTO sml_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","Binahagi'an isab saga a'a ma Arower, ma Sepmot, ma Estemowa, ");
INSERT INTO sml_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","maka ma Rakal. Ya du saga a'a ya magsakaum ma bangsa Jerame'el maka bangsa Kēn, ");
INSERT INTO sml_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","saga a'a isab ma Horma, ma Bōr Asan, maka ma Atak, ");
INSERT INTO sml_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","sigām isab ma Heb