﻿USE sofia;
DROP TABLE IF EXISTS sofia.smkNT_vpl;
CREATE TABLE smkNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES smkNT_vpl WRITE;
INSERT INTO smkNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Si Jesus a sya a Cristo ket puri naya ni Adi' David a puri na ni Abraham. Siti a nikasunur-sunor ran puon na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham ama naya ni Isaac; si Isaac ama naya ni Jacob, tan si Jacob ama raya ni Juda tan saray bubsat na. ");
INSERT INTO smkNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda ama raya ni Fares tan Zara, si Tamar a ina ra. Si Fares ama naya ni Esrom, tan si Esrom ama naya ni Aram. ");
INSERT INTO smkNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram ama naya ni Aminadab, si Aminadab ama naya ni Naason, tan si Naason ama naya ni Salmon. ");
INSERT INTO smkNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon ama naya ni Boaz, tan si Rahab a ina na. Si Boaz ama naya ni Obed, tan si Ruth a ina na. Si Obed a ama ni Jesse. ");
INSERT INTO smkNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jesse a ama na ni Adi' David. Si David, sya a ama na ni Solomon ket si ina na ni Solomon si gindat a asawa na ni Urias. ");
INSERT INTO smkNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon ama naya ni Roboam; si Roboam ama naya ni Abias, tan si Abias ama naya ni Asa. ");
INSERT INTO smkNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa ama naya ni Josafat; si Josafat ama naya ni Joram, tan si Joram ama naya ni Ozias. ");
INSERT INTO smkNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias ama naya ni Jotam; si Jotam ama naya ni Acaz, tan si Acaz a ama na ni Ezequias. ");
INSERT INTO smkNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias ama naya ni Manases; si Manases ama naya ni Amos, tan si Amos ama naya ni Josias. ");
INSERT INTO smkNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias ama raya ni Jeconias tan saray bubsat na. Panaon intaw nin nikatalo ran Israelita konran taga Babilonia ket nai'ras sara sa nasyon nin Babilonia. ");
INSERT INTO smkNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sin nai'ras sarayna sa Babilonia, wanti et a nikasunur-sunor ra; Si Jeconias ama naya ni Salatiel, tan si Salatiel ama naya ni Zorobabel. ");
INSERT INTO smkNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel ama naya ni Abiud; si Abiud ama naya ni Eliaquim, tan si Eliaquim ama naya ni Azor. ");
INSERT INTO smkNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor ama naya ni Sadoc; si Sadoc ama naya ni Aquim, tan si Aquim ama naya ni Eliud. ");
INSERT INTO smkNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud ama naya ni Eleazar; si Eleazar ama naya ni Matan; si Matan ama naya ni Jacob, ");
INSERT INTO smkNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tan si Jacob ama naya ni Jose nin asawa na ni Maria nin si nangiyanak kona ni Jesus a mantawagen nin Cristo. ");
INSERT INTO smkNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nga'mi-nga'min, mangibwat kona ni Abraham angga kona ni David, labin'a'pat a nisusunor a kapamilyawan; labin'a'pat anamaet mangibwat kona ni David anggan sa nikai'ras ran Israelita sa Babilonia, tan labin'a'pat a lamang anamaet mangibwat sin nai'ras sarayna sa Babilonia angga sin naiyanak ya a Cristo. ");
INSERT INTO smkNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wanti ey isturya nin nikaiyanak na ni Jesus a syay Cristo: Si Maria a syay ina na, naitarato yaynan kikasal kona ni Jose. Bale' ba'yo sara nin nikalamo', natandaan a mabuktot ya. Ginmuktot ya nangibwat sa pakayadi' nan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ket si Jose a asawa na, bana' ta maong yan tawo tan kai na rabay a maikwa ya sa kading'eyan si Maria, nidisisyon na nin isyay nayayna nin matinek. ");
INSERT INTO smkNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bale' sin man'isip-isipen nayti, nanaynep ya ket sa taynep na pina'kit yay sayay anghil nan Dios tan wana kona, “Jose a puri na ni David, andi' ka mag'alangan nin mangikasal kona ni Maria. Wanin ta si buktot na ket nangibwat ya sa pakayadi' nan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Manganak ya nin lalaki ket pangaranan ma li' nin Jesus, ta sya a mangisalba konran tutawo na sa pakadusa sa kukasalanan ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sain ket mangyadi' ta pigaw nin matukid a nipaibarita' naynan na'teng nin Dios konan prupita na a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ket si sayay birhin a balasang, gumuktot ya li'! Lalaki ya li' a anak na tan tawagen ya li' nin Emmanuel.” Say rabay nan irgwen ket “Kalamo' tamoyay Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nakaimata yayna si Jose, ket ginwa' na a nipagwa' nan anghil nan Dios kona; nikasal naya si Maria. ");
INSERT INTO smkNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bale' kai naya nin kinudit si Maria leg'an nin kai ya et nin nangabing. Sin nangabing yayna si Maria, pinangaranan naya ni Jose a abing nin Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sawanin, niyanak ya si Jesus sa babalin Betlehem sa prubinsyan Judea sin kapresan a si Herodes a adi'. Ket main nin lulalakin madudunong nin rinmate' itaw sa Jerusalem nin nangibwat sara sa sayay nasyon sa baytan. ");
INSERT INTO smkNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nitepet-tepet ra, “Adti yaytaw si Adi' ra nin Judio a naiyanak? O' a ta na'kit miya a bituen nin sinyal a naiyanak yayna sin itaw kami sa baytan, ket nako kamidti ta pigaw nin pagalangan miya.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sin natandaan nayti ni Adi' Herodes, inmaburido ya tan wanin ra anamaet nin saray tutawodtaw sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Miniting nasaray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan tan tinepet na konra, “Adti ya nin wanra maiyanak a Cristo a syay mag'in nin adi'?” ");
INSERT INTO smkNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ni'bat ra kona, “Sa babalin Betlehem sa Judea; ta sain a wana nin Dios a nisurat nan prupita na. Wana, ");
INSERT INTO smkNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Si Betlehem, sa prubinsya nan Judea, Sya a sangkaimpurtantiwan nin babali konran pupangulo nin bubabali sa Judea ta mangibwat ya li' konran tawo na a pangulon mamaga li' konran tutawo ko nin saray puri na ni Israel.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sinmunor, sikriton nipakayaban nasara in ni Adi' Herodes a mumadunong nin tawo nin nangibwat sa nasyon sa baytan. Sin kaadap nasarayna, natandaan na sa nipanepet-tepet na no ka'no rayan peteg na'kit a bituen. ");
INSERT INTO smkNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kayadi', pinaibwat nasaran mako sa Betlehem tan nibibilin na konra, “Mako kamo sa Betlehem tan tandaen moyon maong a maipa'ka' konan siin a anak, tan no nadumog moyayna li', patandaan rako ta pigaw nin mataman nin si'ko ket makapika' anamaet nin mangigalang kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Sin nayadi' nasarayna nin binibilin nin Adi', nibwat saraynan mako sa Betlehem. Ket sin iti sara sa dalan na'kit rayaynaet taw si bituen nin na'kit ra intaw sin itaw sara sa baytan. Pinasyan ririket ran naka'kit anamanaet konan sitaw a bituen. Mandumaras yan iti sa temben sa u'na ra tan tinumgen ya sa temben nan peteg nin balin kami'nan nan anak a si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sinumrep sara konan bali, ket na'kit raya a anak sa dani nan ina nan si Maria. Nanalimukod sara ket pinagalangan rayan sayay adi' a anak, mi'sa inabryan ray nangwan tan niprisinta ray mablin rurigalo ra nin balitok, insinso, tan mira. ");
INSERT INTO smkNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sinmunor, nipatanda' nan Dios konra sa taynep a andi' sarayna nin sumubli' kona ni Adi' Herodes. Kanya' nin sakalakon dalan anay dinalanan ran sinmubli' sa lugar ra. ");
INSERT INTO smkNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ambo' nin na'teng sin nakaibwat sarayna ket, nipa'kit ya sa taynep a sayay anghil nan Dios kona ni Jose. Wana kona ni Jose, “Mibangon ka ket ilakwan mosaray mitraina tan ika' mosara sa Egipto, tan andi' kamo nin lumakwan itaw anggan ibarita' ko ta ipatingkap nayayna ni Herodes a anak tan ipapati naya.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ket nibangon ya si Jose tan nilakwan nasara konan siin a yabi a anak tan ina na nin nako sara sa Egipto. ");
INSERT INTO smkNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Itaw sara niikap angga sin nati ya si Herodes. Nangyadi' ti ta pigaw nin matukid a wanan Dios a nipaibarita' na konan prupita na. Wana, “Nangibwat yadtaw sa Egipto kinayaban koyay anak ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ket, sin natandaan na ni Adi' Herodes a manlingwen raya sin saytaw nin saraytaw saray mangingipadles, pinasyan sager na. Ket nipapati nasara nga'min a magtaon rwa tan kumayupa' nin ua'nak a lulalaki sa Betlehem tan sa sarban lulugar sa libed na. Binilang nay taon ra nin tinmarana' sin panaon a na'kit rayan mangingipadles nin ibat sa baytan a bituen. ");
INSERT INTO smkNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sa wanin natukid a nipadles na ni Prupita Jeremias a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Marnge' mangibwat sa babalin Rama a asisit tan agrem, ta man'abet-abetan nasara ni Raquel a pupuri nan saray Israelita tan kai ya nin maliwaliwa ta nati sara nga'min.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ket sin nati yayna si Herodes, nipa'kit ya sa taynep a sayay anghil nan Dios kona ni Jose itaw sa Egipto. Wanan anghil, ");
INSERT INTO smkNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mibangon ka. Sumubli' kayna tan saray mitraina sa nasyon moyon Israel ta nati sarayna a marabay nin mangmati konan anak.” ");
INSERT INTO smkNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nibangon ya si Jose ket nibwat saraynan sumubli' sa Israel. ");
INSERT INTO smkNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bale' sin natandaan na ni Jose nin si Arquelao nin anak na ni Herodes a sinmilin adi' sa Judea, linmi'mo yan sumubli' itaw. Konan saya anamanaet nin taynep, nibarita' na anamana nin Dios a gaw'en na ni Jose, kanya' nin nako sara sa prubinsya nin Galilea, ");
INSERT INTO smkNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ket niikap saradtaw sa babalin Nazaret nin abaw a taon. Anaod, natukid a wanran prupita nan Dios maipa'ka' kona ni Cristo, a matawag ya li' nin sayay taga Nazaret tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ket sin saytaw, main nin sayay tawo nin mamawtismo a say ngaran na ket Juan. Nako yadtaw sa lugar a ambo' nin matawo sa Judea. Nibari-barita' na konran saray inmarak itaw kona a ");
INSERT INTO smkNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","wanti: “Pagbabawian tan gurutan moyoynay duka' a man-gaw'e-gaw'en moyo ta dandani yayna nin mag'adi' iti sa mundo a Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wanin a ginwa' na ta syayti si man'ibarita' na ni Prupita Isaias sin wana, “Marnge' ya li' a sayay mampangita'wa-ta'way nin mampangipatanda' itaw sa lugar a ambo' nin matawo a wana, ‘Si'kamon tutawo, sadyaan moyoy irarate' nan Catawan, patu'riren moyoy dalanan na.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Say aysing na ni Juan ket nagwa' nangibwat sa sabot nin kamilyo tan binarkesan nan katat sa awak. Say kanen na anamaet ket dudon tan inatip nin ngiwan sa tatalon. ");
INSERT INTO smkNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abaw saray tutawon nangibwat sa syudad nin Jerusalem tan sa raruma nin bubabalidtaw sa prubinsyan Judea tan mataman et sa bubabalin adani sa Ilog Jordan a nako nangrenge'-renge' kona. ");
INSERT INTO smkNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ket sin nipatutuo ray kukasalanan ra, binawtismwan nasara sa Ilog Jordan. ");
INSERT INTO smkNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sin sain, abaw saray pangulo nin mantawagen nin Pariseo tan Saduseo a mako pabawtismo kona. Sin na'kit nasara ni Juan wana konra, “Si'kamo a bara'mo nin masirib a ulay! Ani a puon a nako kamodti? Wamoyo angangko a mapal'isan moyoy alakin sager nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","No talagan disidido kamon pabawtismo, ipa'kit moyon mampagbabawian moyoynay kukasalanan moyo yupa' sa pangwa' moyon manepeg a gugawa'. ");
INSERT INTO smkNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Andi' moyo nin ilalwan a bana' ta puri nakamo ni Abraham ket, matkap nakamon ipwira nin Dios sa panunusa na. Ibarita' koyti komoyo a magwa' nan Dios a saytin bubato ket gaw'en na a mag'in nin puri na ni Abraham nin ibi na konray nipangako' na. ");
INSERT INTO smkNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Si Dios, bilang sa sayay mammukan nin kayo a niinsayo nayayna a payakor na nin pukanen ta puuran nay barang kayon ambo' nin mabistay bunga, ket nasadya' yaynan dusawen nakamo. ");
INSERT INTO smkNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Si'ko, binawtismwan katamo sawanin nin ranom nin mangipa'kit a nagbabawian moyoynay kukasalanan moyo, bale' main li' nin sumubray kongko a sya bawtismwan nakamon Ispirito nan Dios tan nin apoy. Sya, makapangyayadi' ya dyan si'ko a kai ako gapo nin maikana' nin mataman tanan mangwarwar nin kurdon nin sandalyas na. ");
INSERT INTO smkNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sya a manintinsya sa tutawo nin bara'mo yan mangngirik. Ringgasan nayan maong a pangirikan mi'sa pipuruken nay apa tan irik. Ikwa nasaray pa'sar irik sa agamang na, bale' puuran nasaray pa'sar apa itaw sa apoy a kai gapo nin ma'rep.” ");
INSERT INTO smkNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ket rinmate' yadtaw sa Ilog Jordan nin nangibwat ya sa prubinsyan Galilea si Jesus ta pigaw nin pabawtismo ya kona ni Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bale' inima'no naya ni Juan a wana, “Kai! Si'koy manepeg nin pabawtismo komo a ambo' nin si'kay mako pabawtismo kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bale' wana ni Jesus, “Kai, ambo' nin wanin, ta matkap nin gaw'en tamo a sarba nin manepeg.” Ket inmaburoy ya si Juan tan binawtismwan naya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kayadi' na nin nabawtismwan ni Jesus, nako yaynan tampor sa rigrig. Kaaram-aram niburwang a langit tan na'kit naya a Ispirito nan Dios a bilang kalapati nin mangkumayupa' tan dinumpa' ya kona. ");
INSERT INTO smkNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ket main nin busis a nangibwat sa langit nin kami'nan nan Dios a narnge' ra. Wana, “Siti a anak kon mangkawa-kawa'nanen ko. Sya a pakaririketan kon tuloy.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kaaram, nika' nayan Ispirito nan Dios si Jesus sa kasan katawu-tawon lugar ta pigaw nin sugsugen nayan magkasalanan nin Dimunyo. ");
INSERT INTO smkNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sin napalabas a a'pat a pulo' a awro a kai ya nin nangan si Jesus, pinasyan bitil nayna. ");
INSERT INTO smkNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kinadanyan nayan Mannugsog ket wana kona, “Bana' ta si'kay peteg a Anak nan Dios, pagbaliwen mon tinapay ti say bato.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bale' ni'bat na ni Jesus, “Wana sa Masanton Kasuratan, ‘Ambo' a say kanen tamo' a ikabyay nan tawo no kai matkap na a barang sarita' a mangibwat konan Dios nin ikabyay.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kaaram, nika' naya nin pina'deng nin Dimunyo si Jesus sa sangkata'gayan a parti nan Timplo nan Dios sa Jerusalem, si Masanton Syudad. ");
INSERT INTO smkNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Wanan Dimunyo, “Bana' ta si'kay peteg a Anak nan Dios, painabo' kadti. Tutal, wana sa Masanton Kasuratan, ‘Bibilinen nasaran Dios a uanghil na a pagawan raka, tan salanggawen raka li' ta pigaw nin kai gapo nin masakitan a ayi mo nin bato.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ni'bat na ni Jesus, “O', bale' wana et a lamang sa Masanton Kasuratan, ‘Andi' ka mangwa' nin padalan nin ipanubok mo konan Uunuren a syay Dios mo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kaaram, nika' naya et nin Dimunyo si Jesus sa pinasyan kata'gayan nin talugtog tan nipa'kit na nga'min kona a sarban nunasyon sa intiron mundo tan sarban kukayamanan tan pupakayadi' ra, ");
INSERT INTO smkNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","a wana kona ni Jesus, “Sarban sain ibi ko komo no tumwek ka kongko ket unuren nako.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ni'bat na ni Jesus kona, “Lumakwan kadti, Satanas! Wana anaod sa Masanton Kasuratan, ‘Si Uunuren a Dios mo tamo' a unuren mo tan pagsirbyan mo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Linmakwan yaynay Dimunyo ket rinmate' saray uanghil tan inasikaso raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sawanin, dinakep tan nipriso ya si Juan. Sin natandaan nayti ni Jesus, sinmubli' ya sa prubinsyan Galilea. ");
INSERT INTO smkNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nako ya sa Nazaret bale' ambo' yadtaw nin niikap no kai nako ya sa syudad nin Capernaum a iti sa rigrig nan Baybay Galilea a sakop nin lugar ran puri na ni Zabulon tan puri na ni Neftali. ");
INSERT INTO smkNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nangyadi' ti nin pakatukidan nin nipadles na ni Prupita Isaias a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sa lugar nin Zabulon tan Neftali, iti sa dalan a adap sa taaw, tan itaw sa rubari' nan Ilog Jordan tan sa parti nan Galilea a luta' ran ambo' nin Judio, ");
INSERT INTO smkNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","saray tutawodtaw, bara'mo saran mampiikap sa dedlem. Say pa'sar ra et ket bara'mon nati sarayna ta naisyay sara konan Dios. Bale', ma'kit ra li' a bara'mon sangkaslagan nin palaway, ta nasiraan saradtaw nin siin nin palaway a say pangingisalba nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ket nangibwat sin rinmate' yadtaw sa Galilea, tinaranaan nayna ni Jesus a mamari-barita' konran tutawo, a wana, “Pagbabawian tan gurutan moyoynay kukasalanan moyo ta adani yayna nin mag'adi' a Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sawanin, manlumalako ya sa rigrig nan Baybay Galilea si Jesus sin na'kit nasaray mibsat nin maninilay a sara si Simon nin say sakalakon ngaran na ket Pedro, tan si Andres. Sin sain ket mampangikatkat saran eket. ");
INSERT INTO smkNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Kikalamo' kamo kongko,” wana ni Jesus, “ta gaw'en katamon maninilay, ambo' nin kuna' no kai edet, nin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ket tampor linakwanan ray eket ra tan nikikalamo' sarayna kona. ");
INSERT INTO smkNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kai sara et nakakadayo' nin tuloy, na'kit nasara et a mibsat a a'nak na ni Zebedeo a si Santiago tan si Juan. Itaw sara sa baluto ra a kalamo' raya si tatay ra nin mampangunong nin eket ra. Kinayaban nasara ni Jesus a mibsat, ");
INSERT INTO smkNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ket tampor a linakwanan rayay baluto ra tan mataman si tatay ra tan nikikalamo' sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ket nako ya sa intiron prubinsya nan Galilea si Jesus nin nako naya nin nipata-patanda' sa susinaguga a Mabistan Patanda' nin maipa'ka' sa pag'aadi' nan Dios, tan pinaanda' nasaray main nin bungat anan klasi nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Natandaan a maipa'ka' kona ni Jesus sa intiron prubinsya nin Siria. Kanya' nin saray tutawo ket nika' rasara kona a main nin sarba anan klasin masakit tan saray main nin ingar-ingaren bilang saray nasrepan nin ispiriton duka', saray matin-binulan, tan saray paralitiko, ket pinaanda' nasara nga'min ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bana' sa wanin pinasyan ka'bawan ran tinmumbu-tumbok kona ni Jesus. Main nin nangibwat sa Galilea, sa Decapolis, sa Jerusalem, sa Judea tan sa lulugar sa rubari' nan Ilog Jordan. ");
INSERT INTO smkNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na'kit nasara ni Jesus a pinasyan ka'bawan nin tutawo ket tinmangkar ya sa purod tan itaw ya tinmekre' nin mangyakay. Inmarak sara kona a tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ket tinmarana' yayna a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Makarma' saray mangalilbi' a main nin mampagkurangan ra, ta mag'in nin ikon ra a say iti sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Makarma' saray mabereng bana' sa duka' a gawa'-gawa' a mangka'kit ra sawanin ta si Dios ket liwaliwawen nasara li'. ");
INSERT INTO smkNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Makarma' saray ambo' nin mabayani a piuugali' ra ta risibyen ra li' a nipangako' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Makarma' saray makaingar sa pakatkapan ran mangwa' nin maabig sa pangingikit nan Dios, ta papdaen nasara nin Dios nin mangwa' nin sain. ");
INSERT INTO smkNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Makarma' saray mapainganga'do, ta ka'dwan nasara li' nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Makarma' saray napasayay nakem ra sa panunumbok konan Dios, ta ma'kit raya li' nin peteg a Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Makarma' saray mamitunon migugura', ta patutu'wan na li' nin Dios a a'nak nasara nin kabakas-bakas na. ");
INSERT INTO smkNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Makarma' saray mangirangep nin pammaidap ran tutawo konra bana' sa pangngawa' ran maabig sa pangingikit nan Dios, ta mampag'adi' yay Dios konra. ");
INSERT INTO smkNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Makarma' kamo no bana' ta mantumumbok kamo kongko ket pagsari-saritaan rakamo tan paidapen rakamo tan mamabrika saraynan sarban bula'-bula' maipa'ka' komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wanin anamaet a lamang a ginwa' ra nin tutawo konran prupita nan Dios sin nu'na. Kanya' nin rumiriket kamon maong ta pinasyan anda' nin gun-gunan man'isadya' na anamaet nin Dios komoyodtaw sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Si'kamo, bara'mo kamon asin para konran tutawodti sa mundo. Bale' no bilang wadi' ta tinmab'ang anay asin, kai ana gapo nin maisubli' a taway nin ma'sin. Kasaynan kabalikasan, ket itampal ana tan da'da-da'daan tana. ");
INSERT INTO smkNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Bara'mo kamon tyo' a mamalaway konran sarban tutawo. Si syudad a iti sa ata'gay nin lugar ket kai ya nin maiyadi. ");
INSERT INTO smkNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kasa anamaet nin manulsol nin tyo' mi'sa naya nin sakban, no kai edet, ikwa naya sa sayay pangngitukduan ta pigaw nin mapalawayan sara nga'min a iti sa bali. ");
INSERT INTO smkNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wanin anamaet a maabig a gugawa' moyo ta pigaw nin bana' sa sain ket raywen rayay Dios a Ama moyo nin itaw sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Andi' moyo nin ipa'ka' a nako akodti sa luta' ta pigaw nin gaw'en kon kai ana nin magkuri a Gugan-gan nin nibi na ni Moises tan say akay ran prupita nan Dios, no kai edet, nako akodti ta pigaw nin ipapalaway tan tukiden ko a niyakay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ibarita' koyti komoyo: Mintras nin iti et a langit tan luta' ni sayay litra o sayay partin litra sa Masanton Kasuratan ket kai nin magkurang no kai et nin matukid nga'min a naisurat. ");
INSERT INTO smkNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanya' anaod nin sangkaayupaan sara li' sa Pag'adian nan Dios a tawon mangwa' nin kasan kwinta konan wanra a sangkabugaan nin impurtanti nin gan-gan nan Dios tan iyakay nasara et a raruma nin gaw'en raya anamaet nin kasan kwinta. Bale' si manukid sa gan-gan nan Dios tan iyakay nasara et a raruma nin manukid anamaet, sangkata'gayan sara li' sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tukiden moyon maong nga'min ta ipangako' ko komoyo a kai kamo gapo nin makasrep sa Pag'adian nan Dios no kai moyo sara nin mapasurukan sa pangngawa' nin matunong a Pariseo tan saray Madudunong sa Gugan-gan.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bilang sa wanti e: Tanda' moyo a niyakay konran lulaking tan bubaying tamo sin nu'nan panaon a andi' sara nin mangmati ta si si'numan a mangmati nin kapada nan tawo ket umbat ya sa husgado. ");
INSERT INTO smkNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bale', si'ko, ibarita' koyti komoyo: Si mangura' sa kapada nan tawo, umbat ya et a lamang sa husgado tan si si'numan a mag'irgon mabyat sa kapada nan tawo a wana, ‘Waweng ka!’ umbat ya et sa sangkata'gayan a husgado; tan si si'numan a mangibarita' konan kapada nan tawo nin wana, ‘Kasa gapo nin sirbi mo!’ umbat ya li' sa apoy nin impyirno. ");
INSERT INTO smkNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kanya' nin no man'ida'ton moyna sa altar a da'ton mo konan Dios, ket napanemtem mon main nin masakit a nakem komo, ");
INSERT INTO smkNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibati' mo yapo' itaw a da'ton mo tan mako ka kidunong konan nagkasalananan mo mi'sa moyna nin ituloy a pangingida'ton mo konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","No main nin mangidimanda komo, mako kan tampor nin kiariglo kona mintras nin iti kamo et sa dalan, ba'yo ka nin maiyadap sa kurti, ta no kai, ipagamet nakan hwis konran pulis ket ipriso raka, ");
INSERT INTO smkNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tan, ibarita' ko komoyo, buruken rakadtaw sa tana a mabayadan mo nga'min a multa mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tanda' moya a akay et a wana, ‘Andi' ka nin kiraray sa ambo' mon asawa.’ ");
INSERT INTO smkNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Si'ko bale', ibarita' koyti komoyo: Si lalakin namastang tamo' nin main nin pangangapes konan sayay babayi, nagkasalanan yaynan kapada a namabayi ya. ");
INSERT INTO smkNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ket, no si mata moy puon nin pakasida' nin pammemper mo, sukiten ma tan itampal ma. Maong anay makasawan kan sayay parti nin lalaman mo dyan si kumplito yan page' a lalaman mo bale' maika' ka sa impyirno. ");
INSERT INTO smkNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No si wanan nin gamet mo a puon nin pakasida' nin pammemper mo, putulen ma tan itampal ma. Maong anay makasawan kan sayay parti nin lalaman mo dyan si kumplito yan page' a lalaman mo bale' maika' ka sa impyirno.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Niyakay ra et nin na'teng ana a no main nin lalakin isyay nayay asawa na, matkap nayan byan ti nin kasuratan nin pisyayan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bale' si'ko, ibarita' koyti komoyo: No isyay nayan lalaki a asawa na a kai ya anamaet nin nikilalaki, pagkasalananen naya no kikalamo' ya sa sakalakon lalaki. Ket si si'numan a mangalamo' konan babayi magkasalanan yaynamaet.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tanda' moyon lamang a main yayti et e nin akay konran lulaking tan bubaying tamo a wana, ‘Andi' mo nin kai sustinyen a sinambawan mo, no kai edet, tukiden moy sinambawan mo konan Catawan.’ ");
INSERT INTO smkNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bale' si'ko, ibarita' koyti komoyo: Andi' moyo gapo nin sambawan a nipangako' moyo. Andi' moya usaren nin sumamba a langit ta itaw yay truno nan Dios, ");
INSERT INTO smkNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tan a luta' ta siti a tukduan na. Andi' moya anamaet a lamang nin usaren a syudad nin Jerusalem ta siti a syudad nan Sangkata'gayan nin Adi' nin sarba. ");
INSERT INTO smkNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni andi' moyo usaren nin sumamba a byay moyo a bilang nin si'kamoy main nin pakauray sa sayti ta ni si sayay sabot sa ulo moyo ket kai moya nin mapauban o mapangisit. ");
INSERT INTO smkNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘O',’ wamoyo tamo' no mangipangako' kamo; o ‘Kai,’ tamo' no andi' kamo, ta animan et a ibarita' moyon ipaaluyon sa kasasamba moyo, ibat ana konan si sya a Kadukaan.” ");
INSERT INTO smkNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tanda' moya a akay et a wana, ‘Si nakabulding nin kapada nan tawo, buldingen ya anamaet. Si nakaburas nin ngipen nan kapada nan tawo, burasen anamaet a ngipen na.’ ");
INSERT INTO smkNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bale' si'ko, ibarita' koyti komoyo: Andi' kamo nin gumale' konran mangwa' nin duka' komoyo. No rampaen rayay wanan nin rupa moyo, iyadap moyay wiri nin rampaen ra et. ");
INSERT INTO smkNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No idimanda rakamo ta rabay rayan makalap a mabistan aysing moyo, ibi moya et a mas mabli nin aysing moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O, no main nin sundalo' nin mamabalatay komoyo nin sayay kilumitro sa kargada na, awiten moya nin rway kilumitro. ");
INSERT INTO smkNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No main nin kidawat komoyo, byan moyo sara; no main nin mangdam komoyo, pa'daman moyo sara. ");
INSERT INTO smkNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Main et nin akay a wana, ‘Aduen mosaray uamigo mo tan guraen mosaray kalaban mo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bale' si'ko, ibarita' koyti komoyo: Aduen moyo saray kalaban moyo tan idasalan moyo saray mampamaidap komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sa pangngawa' moyon siin, ma'kit a bara'mo kamon si Dios a Ama moyo nin itaw sa langit ta si Dios, pari-parihwen nayan pasiraen a awro para konran maong a tutawo tan para konran duka' a tutawo, tan parapegen naya para konran matunong a tutawo wanin anamaet para konran maraet a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Main paran gun-gunan mataga'nan moyo konan Dios no sara tamo' a mampangawa'nan komoyo a kawa'nanen moyo? Kasa! Saray maniningir nin buis, a wamoyon saray sangkadukaan nin tutawo, wanin a pigagawa' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wanin anamaet, no masami-sami kamo tamo' konran kukamuko moyo, ani a ipa'kit nin naiduman kamaungan moyo nin sain? Kasa! Wanin anamaet lamang a ugali' ran tutawon kai nin magtanda' konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Matkap anaod a mag'in kamon bara'mon konan si Dios a Ama moyon itaw sa langit a kasan pagkurangan na.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ilagen moyon ambo' nin parayo sa tawo a rason moyon mangwa' nin mabista, ta no wanin a rason moyo ket kai nakamo gun-gunawan nin Dios a Ama moyo nin itaw sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bilang no mami kamo konan sayay makatkap, kai moyoyna nin matkap et nin ipata-patanda' a bilang sa gawa' ran masantos kano wadi' a itaw sara mami sa sinaguga tan sa dalan ta pigaw nin raywen rasara nin tutawo. Ibarita' ko komoyo, bana' ta rinayo rasaraynan tutawo, kasaynan risibyen ran mangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","No mami kamo andi' moyoyna nin ipatanda' et abirno konan sangkaadanyan nin amigo moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sikritoy pammi moyo ket si Ama tamon itaw sa langit, a syay maka'kit nin sarban sikriton man-gaw'en, gun-gunawan nakamo.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ket no dumasal kamo andi' moyo sara nin arigen a kano wadi' ket masantos sara. Rabay-rabay ray dumasal nin naka'deng sa sinaguga tan iti sa dadalanan ta pigaw nin ma'kit rasaran tutawo ket raywen rasara. Ibarita' ko komoyo, bana' ta rinayo rasaraynan tutawo, kasaynan risibyen ran mangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bale' si'kamo, no dumasal kamo, lumuob kamo sa kwarto moyo tan isada' moyay purta. Itaw dumasal kamo konan Dios a Ama moyo nin kai nin ma'kit, a sya tamo' a maka'kit, ket gun-gunawan nakamo. ");
INSERT INTO smkNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","No dumasal kamo, andi' moyo nin paanrwen sa kasan kabalikasan a panguman-uman moyon sarita' a kapadan gawa' ran kai nin magtanda' konan Dios. Ipa'ka' ran reng'en nasaran Dios bana' sa abaw a sarita' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Andi' moyo sara nin arigen, ta ba'yo moyo et nin dawaten, si Dios a Ama moyo, tanda' nayna a matkap nin barang saya komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bilang sa wanti ey dasal moyo: O Dios, Ama mi nin isen sa langit, mapagalangan ka kumon nin liso. ");
INSERT INTO smkNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mag'adi' kayna kumon sa sangkamundwan. Maunor kumon a karabayan mo iti sa luta' kapadan pakaunor isen sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Byan rakami kumon nin kanen min inawru-awro. ");
INSERT INTO smkNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pirdunawen rakami kumon sa kukasalanan mi kapada nin pammirduna mi anamaet konran nagkasalanan komi. ");
INSERT INTO smkNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Andi' rakami nin iyadap sa mabyat tuloy a panunubok tan ikadayo' nakami konan si sya a Kadukaan. ");
INSERT INTO smkNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wanin, no pirdunawen moyo saray nagkasalanan komoyo, pirdunawen nakamo anamaet nin Dios a syay Ama moyo nin itaw sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bale' no kai moyo sara nin pirdunawen a nagkasalanan komoyo, kai nakamo anamaet lamang nin pirdunawen nin Ama tamo sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Anamaet, no magkulasyon kamo, andi' moyo nin ipa'kit sa bakas moyo nin bilang konran masantos kano wadi'. Mabereng a bakas ra tan misket saran nikasama' tan kai sara nin mangusay ta pigaw nin ipa'kit ran mampagkulasyon sara. Ibarita' ko komoyo, bana' ta rinayo rasaraynan tutawo kasaynan risibyen ran gun-guna mangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bale' si'kamo, no magkulasyon kamo, kai kumon nin ma'kit sa bakas moyo; magra'mos tan mangusay kamo, ");
INSERT INTO smkNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta pigaw nin kasan makatanda' a mampagkulasyon kamo. Si Dios nin Ama moyo a kai nin ma'kit, a sya tamo' a maka'kit, ket gun-gunawan nakamo.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Andi' kamo nin maninep nin kayamanan iti sa luta' ta say kayamanan iti ket tumaey tan maet'et ran insikto tan matakaw sa naninepan, ");
INSERT INTO smkNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","no kai edet, say kayamanan nin itaw sa langit a dinepen moyo ta kai nin tumaey tan kai nin maet'et nin insikto tan kasan makatakaw itaw. ");
INSERT INTO smkNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ket maninep kamodtaw anaod ta, no adti a kami'nan nin mabli komoyo ket itaw anamaet a nakem moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Say mata anamaet, bara'mo nin tyo' nan lalaman. No maslag a mata nan sayay tawo, bara'mon mapalaway ya nga'min a intiron lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bale' no makapoy a pangingikit na bara'mon nadedleman yay intiron lalaman na. Ket, no si palaway kumon nin kanakman na ket nag'in anan dedlem bana' sa abas a uapes na, ani ana nin dedlem nin kabibyay na.” ");
INSERT INTO smkNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kai nasara anamaet nin mapagsirbyan nin kusto nin sayay alila' a rway niduman amo na, ta no rwa ray amo na, mas kawa'nanen nayay saya dyan si saya, ket mas tutuo ya konan saya dyan konan saya. Wanin anamaet, kai moyo nin mapirngan a magsirbi konan Dios tan say umagawa kamon maningkap. ");
INSERT INTO smkNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kanya' edet nin ibarita' koyti komoyo: Andi' kamo nin umaburido maipa'ka' sa matkap moyo konan sitin byay a bilang say ikabyay, inumen, tan isket moyo. Say pipa'kaan nin byay moyo ket mas ararem dyan say pangangan tan pisisket. ");
INSERT INTO smkNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kiten moyo saray manuk-manok: Kai sara nin mampangmula ni mampangyatab o maninep nin kanen ra, bale' mampagawan nasara nin Ama moyon itaw sa langit. Kai kamo para nin mas mabli kona dyan saray manuk-manok? ");
INSERT INTO smkNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anaod, mapaanro moyo kasi a byay moyo mataman nin sayay udas tamo' no umaburido kamo? ");
INSERT INTO smkNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","O' a, ambale' a aburido kamo maipa'ka' sa isket moyo? Imatunan moyo pan gumista a bakas nin buburak nin dikot. Kai nin magtrabaho o mangabel nin isket ra. ");
INSERT INTO smkNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bale' ibarita' ko komoyo, abirno aninay pupustura nin seket na ni Adi' Solomon ta wanin anay yaman na, kai ya et nakapisket nin kapadan bista nan mataman saya tamo' sa sain nin buburak. ");
INSERT INTO smkNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ket no mapasketan nan wanin kabista nin Dios a dudikot a isen sawanin bale' dilap ket magwa' a ipuor tamo' sa syang, kai na kasi nin ibi a isket moyo? Aninay kababwan nin pagmamatalek moyo! ");
INSERT INTO smkNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanya' nin, andi' kamo nin umaburido maipa'ka' sa ikabyay moyo, a no adti kamo mangalap nin inumen, kanen, tan isket moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sain nin bubagay a iti tanan pirmi sa nakem ran tutawon kai nin magtanda' konan Dios. Anaod, main ya a Ama moyo sa langit nin magtanda' a matkap moyo in nin bubagay. ");
INSERT INTO smkNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Si'kamo bale', matkap a say mu'na-mu'na nin iti sa kanakman moyo ket say maiyadilanta a maipa'ka' sa pag'aadi' nan Dios tan say pangngawa' moyo nin say mapteg para kona, ket ibi nayti nga'min nin matkap moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kanya' nin andi' moyo nin kaaburidwan a mangyadi' sa adapen a awro; adapen moyoyna li' no isen ana. Kustoynay matkap moyon adapen sawanin.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Andi' ka nin manintinsyan kapada mon tawo a bara'mo kan hwis ta pigaw nin kai naka li' nin sintinsyawan nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","O', ta no pa'no mosaran sintinsyawan a kapada mon tawo, wantaw naka li' nin sintinsyawan nin Dios. No ani a nipanukat mo sa kapada mon tawo, wanin anamaet li' a itubale' nan panunukat nin Dios komo. ");
INSERT INTO smkNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ambale' a say kasalanan ran kapada mon tawon bara'mon puling tamo' tana a ma'kit mo, bale' kai mo nin mangkaasikaso a bara'mon truson nakasalimbeng ana sa mata mo? ");
INSERT INTO smkNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pa'no mon maibarita' kona, ‘Galten tayay puling mo,’ anta si'ka ket ni kai ma mangkaasikaso nin galten a truson nakasalimbeng sa mata mo? ");
INSERT INTO smkNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Maong ka kano wadi'! Galten mo yapo' a kadukaan sa kanakman mo ba'yo ka manita nin kapada mon tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Andi' moyo nin ipasuet a mangyakay nin maipa'ka' konan Dios konran tutawon nikasama' a kabibyay tan kasan kading'eyan. No ipasuet moyo, bara'mon nibi moyoy pirlas moyo konran baboy ket italma-talmak ra tamo' o bara'mo anamaet nin nibuntok moyo konran aso a masagradon bubagay ket birngan rakamon kayaten.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kidawat kamo konan Dios nin say matkap moyo ket byan nakamo. Ituluy-tuloy moyoy manumog kona ket tulungan nakamon manumog sa mantikapen moyo. Kumutana kamo ket pasrepen nakamo ");
INSERT INTO smkNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ta sarba ran kidawat, mabyan sara. Sarba ran manumog, makadumog sara; tan sarba ran kumutana, pasrepen sara. ");
INSERT INTO smkNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Si'kamon mumatua, byan moya paran bato no kidawat yan ma'kan a anak moyo? Kai! ");
INSERT INTO smkNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O, byan moya paran ulay no kidawat yan kuna' komoyo? Kai anaod! ");
INSERT INTO smkNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Say rabay ko nin irgwen, no si'kamo nin tawo tamo' a sikakasalanan ket tanda' moyoy mamin mabistan bubagay konran a'nak moyo, kai na kasi ibi nin Ama moyo sa langit a no ani a maabig para konran kidawat kona? ");
INSERT INTO smkNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Edet, no ani anamaet a rabay moyon gaw'en ra komoyo nin kapada moyon tawo, saytaw a matkap moyon gaw'en konra. Konan siin, matukid moyo a uakay nin Gugan-gan ni Moises tan saray prupita.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Si akipot nin purta a serpan moyo sa Pag'adian nan Dios. Anaod, si purta nin siaabri nin mako sa impyirno ket alawang ya, tan mainum'ay yan tumbuken tan abaw saraynay mampakodtaw, ");
INSERT INTO smkNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","bale' akipot yan page' a purta tan maidap yan tumbuken a dalan nin mako sa byay a iti konan Dios, ket matalag saray makadumog kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pakatalad kamo konran mibalu'-balo' a prupita nasaran Dios. Bara'mo saran mauyamo' a karniro a rabay nin irgwen ket bara'mo saran tutuon mammemper konan Dios, bale' say tutuo bara'mo saran mabayanin ayep ta say gagara ra ket manida'. ");
INSERT INTO smkNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Say pakaalilbian moyo konra ket say pigagawa' ra, kapadan pakaalilbi' moyo no maabig yay kayo o mula sa paka'kit nin bunga na. Si ambo' nin ubas, kai ya gumungan ubas, tan si arumas, kai ya gumungan igos. ");
INSERT INTO smkNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mataway a bunga nin marigsa nin kayo, ket main nin dipirinsya nin bunga nan kayon main nin sida' na. ");
INSERT INTO smkNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Si malambot nin kayo kai ya gumunga nin duka' ket si main nin sida' nin kayo kai yaynamaet gumunga nin mabista. ");
INSERT INTO smkNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pukanen tamo' mi'sa li' puuran a kayon gumungan duka'. ");
INSERT INTO smkNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wanin anamaet konran magwadi'-wadi' a prupita nasaran Dios, maalilbi' moyo sara sa paka'kit nin pigagawa' ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Pakatalad kamo! Abaw saray tumawag kongko a wanra, ‘Uunuren ko! Uunuren ko!’ bale' ambo' nin sarba ra ket risibyen nan Ama kon itaw sa langit sa Pag'adian na, no kai edet, saraytaw tamo' saray gumwa' nin karabayan na. ");
INSERT INTO smkNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sa Awron Paninintinsya, abaw sara li' a mamarita' a wanra kongko, ‘Uunuren ko, ambale' ey? Nangyakay kami anamaet nin maipa'ka' komo! Kai para a pinaanda' misaray nasrepan nin duka' a uispirito tan nakapagmilagro kami et sa pakayadi' mo?’ ");
INSERT INTO smkNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bale' i'bat koyti li' konra, ‘Ambo' katamo gapo nin trabahador! Kumadayo' kamodti kongko, si'kamon gumu-gumwa' nin duka'!’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Anaod, si rumnge' tan tumulok sa sain nin uakay ko, maipada ya sa sayay manakem nin tawo a bato a pundasyon nan nipa'deng nan bali na. ");
INSERT INTO smkNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ginmagyo ya. Marges yay rapeg tan linmanip ya. Bingkasan nayan siri bale' kai ya nin nayba' a bali ta batoy pundasyon na. ");
INSERT INTO smkNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ket si nakarnge' anamaet bale' kai ya nin mangimbabaet, maipada ya sa sayay kasinakem nin tawo a nipa'deng nayay bali na sa bubuyangin. ");
INSERT INTO smkNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ginmagyo ya anamaet a lamang. Marges yay rapeg tan linmanip ya. Bingkasan nayan siri a bali ket nayba' yan liso.” ");
INSERT INTO smkNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ket sin nayadi' yayna nin nangyakay itaw si Jesus, naka'ngap saray tutawo sa no pa'non pangangakay na. ");
INSERT INTO smkNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wanin ran tutawo ta say pangangakay na ket main nin pakayadi', ambo' nin bilang konran saray Madudunong sa Gugan-gan. ");
INSERT INTO smkNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ket sin kinmayupa' ya nangibwat sa purod si Jesus, tinumbok rayan abaw tuloy nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaaram-aram, main nin sayay tawon mampagmasakit nin duka' sa katat a mantawagen nin liprusi a kinmadani kona. Nanalimukod ya sa adapan na ni Jesus tan nipainganga'do na, “Ser, no rabay moyo magwa' moyo nin maako' rako anamanaet nin tutawo a bilang sa gindat” ");
INSERT INTO smkNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nipababo naya ni Jesus a gamet na kona tan wana, “O', rabay ko. Umanda' kayna.” Ket tampor inmanda' yay tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ket wana ni Jesus kona, “Mangrenge' kan maong. Andi' moyti ibari-barita' sa si'numan, ana edet, mako ka konan padi' ta ipadar moy nikapaanda' mo. Ket mangida'ton ka sigon sa Gugan-gan nin nibi na ni Moises ta pigaw nin maipa'kit a katutu'wan konra no si'no ako.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nako sara si Jesus sa Capernaum ket sin karate' radtaw main nin ambo' nin Judio nin sinumna' konra. Kapitan yayti nin sundalo' nin Romano ket dinawat na kona ni Jesus ");
INSERT INTO smkNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a wana, “Ser, mampagmasakit yay alila' ko. Itaw ya sa bali ko. Naparalitiko ya ket mangkapaidap yan maong.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Sigi, paandaen koya; tamoyna sa bali mo,” wana ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Ay, kai, Ser! Andi' ana,” wanan kapitan, “ta kai ako kumana' a sumrep ka sa bali mi. Ket, sadag anan ibarita' mo, ‘O', umanda' yayna,’ ket umanda' yaynay kawa'nan kon alila' ko. ");
INSERT INTO smkNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","O', maibarita' in ta mantumulok akon lamang konan pangulo kon diri, tan main nin susundalo' a iti sa pakauray ko. No ibarita' ko konan sayay sundalo' ko, ‘Mako kadtaw e,’ ket mako yaynaod; ket konan saya anamaet ibarita' ko, ‘Mako kadti,’ ket umarak ya kongko. Wanin anamaet a lamang konan aripen ko. No wangko kona, ‘Gaw'en mayti,’ gaw'en ta gaw'en naya anaod.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Naka'ngap yan tuloy si Jesus sin narnge' naytin wanan kapitan. Ket wana konran mantumumbok kona, “Ibarita' koyti komoyo a kasa gapo et nin narnge' kon tawo a main nin wantin pagmamatalek mataman kontamon Israelita! ");
INSERT INTO smkNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ibarita' ko komoyo, rumate' li' a awro nin abaw sara li' a ambo' nin Judio nin mangibwat sa baytan tan sa panrupan a kipunsya nin kidungon mangan kalamo' ran puon tamon Judio, a sara si Abraham, Isaac tan Jacob, itaw sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sara bale' a raruman Judio nin sara kumon a kipag'adi' konan Dios ket, itampal sara li' itaw sa pinasyan dedlem tan pinasyan kaday'an konan Dios ket itaw umasisit sara li' tan ngumaretenget li' a ngipen ra bana' sa pakapaidap tan bereng ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kaaram, wana ni Jesus konan kapitan, “Mako kayna. No ani a timper mo, saytaw anamaet a mangyadi'.” Ket konan sitaw si udas a inirgo na ni Jesus taw, inmanda' yay alila'. ");
INSERT INTO smkNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nako sara si Jesus sa bali ra ni Pedro. Nakaida' yay katyangan nan babayi ni Pedro ta ma'mot ya. ");
INSERT INTO smkNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gina'getan naya ni Jesus a sayay gamet na ket tampor a inmanda' ya. Nibangon yayna tan nagsirbi ya konra ni Jesus sa pangnganan. ");
INSERT INTO smkNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sin yinmabina, ni'ra-ni'ras rasaran tutawo kona ni Jesus a mampagmasakit a nasrepan nin ispiriton duka'. Pinalakwan nasara ni Jesus a dudimunyo sa irgo na tamo', tan pinaanda' nasara a sarba ran main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Napatutu'wan a wana ni Prupita Isaias sa wanin a ginwa' na ni Jesus. Wana, “Syay nanambar nin sarban mumasakit tamo tan ginlat na nga'min a sarban man'irangep tamo sa lalaman tamo.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ni'sa, sin na'kit na ni Jesus a ka'bawan ran tawo, pinasaki nasaray tumutumbok na nin makodtaw sa rubari'. ");
INSERT INTO smkNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sin sain, kinmadani ya kona ni Jesus a sayay Madunong sa Gugan-gan tan wana kona, “Maistro, mayi ako komo adtiman a keen mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ket wana ni Jesus kona, “Mas maong sarayna edet a uayep sa tatalon ta main nin piikapan ran diri, tan sara et a manuk-manok ta main nin apunan ran diri ta, si'kon si Pinaitawo, kasa nin bali kon diri a magwa' nin painawnan.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Si saya nin tumutumbok wana kona ni Jesus, “Ser, no mi'sayna li' ta itabon koya yapo' si tatay mi.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bale' wana ni Jesus kona, “Kai, mayi ka kongko. Pauryan mon saray kasa sa sirong nin pag'aadi' nan Dios a mangitabon konran nunati ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kaaram, nako ya nin rinmuran sa baluto si Jesus ket nayi saray tumutumbok kona. ");
INSERT INTO smkNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sin kapresan ran mansumaki, bigra' a tribunada ana, ket si baluto ra manlumdeg yaynan maspakan nin burakan. Sin sain, mampa'lek ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kina' raya nin pinukaw. Wanra kona, “Maistro, manlumdeg atamoyna! Isalba rakami!” ");
INSERT INTO smkNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wana ni Jesus konra, “Aninay li'mo moyo! Aninay kababwan nin pagmamatalek moyo!” Ket nibangon tan inumdeng ya tan nigan-gan nan tumgen yay siri tan kumpa' a daluyon. Tampor linumteng tan linminak yay taaw. ");
INSERT INTO smkNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naka'ngap saray kalalamo' na. “Ani ket a pitatawo nan siti a mataman si tribunada tan say daluyon, tumulok kona!” ");
INSERT INTO smkNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nakarate' saradtaw sa rubari', sa lugar a sakop nan Gadara. Rwa ran lalaki nin linumwa' sa yukib nin mampanabunan a sinumna' kona ni Jesus. Nasrepan saran ispiriton duka' ket pinasyan bayani ra kanya' nin mali'mo saran lumabas itaw a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sin naalilbi' raya si Jesus, wanran niburyaw, “Si'kan Anak nan Dios, ani ket a kabiangan mo komi? Iti ka para ta pigaw nin padya'dyaen nakami ana abirno nin kai et narate' a udas nin panunusa?” ");
INSERT INTO smkNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sin sain, sa ambo' nin adayo' sa kami'nan ra ket main nin abaw nin baboy a mampangan. ");
INSERT INTO smkNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wanran nikidawat nin inganga'do nin ispiriton duka' kona ni Jesus, “No palakwanen rakami ana, aburuyan mo tana edet a sumrep kami konran baboy.” ");
INSERT INTO smkNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Sigi, mako kamoyna,” wana ni Jesus. Ket linakwanan rasaran ispiriton duka' a lulalaki tan sinumrep sara konran baboy. Ket nangimros saray baboy nin namunta sa kikiras ket nanabo' sara sa raranom tan nati sara nga'min. ");
INSERT INTO smkNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Saray mampangalila' konran baboy, nagsipalayo saran nako sa babali tan nibari-barita' ray nangyadi' lalun-laloynay nangyadi' konran rway lalakin nasrepan nin ispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kanya' nin sin narnge' rayti nin gumabali, nako sara kona ni Jesus tan nikidawat saran inganga'do a lumakwan yaynadtaw kadi' sa lugar ra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ket rinmuran sara anamanaet sa baluto si Jesus nin sumubli' sa rubari' a mako yayna sa babali. ");
INSERT INTO smkNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ambo' nin na'teng sin itaw sarayna, main nin nirate' ran tutawo nin sayay lalakin kai nin makakimey a nakaida' sa idaan na. Na'kit na ni Jesus a pagmamatalek ra kona ket wana konan lupoy, “Rumiriket ka, amigo. Napirduna anay kukasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ket itaw, main nin umno ray Madudunong sa Gugan-gan. Sin narnge' raytaw ket wanra sa nakem ra, “Man'u'na-u'nawan nayay Dios nin sitin tawo!” ");
INSERT INTO smkNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bale', nataros na anaod ni Jesus a iti sa nakem ra kanya' nin wana konra, “Ambale' nin duka' a pangingisip moyo? ");
INSERT INTO smkNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wamoyo tana kumon ket mas magwa' et nin ibarita' a umanda' nin makalalako kayna, dyan si mapirduna anay kukasalanan mo! ");
INSERT INTO smkNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ket, ta pigaw nin matandaan moyo a si'kon si Pinaitawo ket main nin pakayadi' kon mamirdunan kukasalanan iti sa luta', ibarita' koyti,” ket anaod wana ni Jesus konan paralitiko, “Mibangon ka. Awiten ma in si undayon mo ta sumubli' kayna komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nibangon yay tawo ta nugot yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sin na'kit rayti nin tutawo nin itaw, naka'ngap saran awit a li'mo tan rinayo rayay Dios ta binyan nay tawo nin wanin a pakayadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Linmakwan yadtaw si Jesus. Sin manlumalako ya, na'kit nayay maniningir nin buis a si Mateo nin nakatekre' itaw sa upisina na. Wana ni Jesus kona, “Mag'in kan tumutumbok ko.” Inumdeng ya si Mateo tan nayi ya kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nangan yadtaw si Jesus tan saray tumutumbok na sa bali na ni Mateo, ket abaw saray maniningir nin buis tan ambo' nin rilihyuso a kadungo ra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Main nin myimbro sa dupong ran Pariseo a mampangimaton kona ni Jesus, ket wanra konran tumutumbok na, “Ambale' a mangkidungo yay maistro moyo konran wanin a tutawo?” ");
INSERT INTO smkNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Narnge' nayti ni Jesus ket inubatan nasara nin sayay alimbawa'. Wana, “Ambo' nin saray marigsa a makatkap nin duktor, no kai edet, saray main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maipa'ka' konan siin, adalen moyan maong a mabasa sa Masanton Kasuratan a wanan Dios, ‘Say mapainganga'do kamo konran kapada moyon tawo a makapaririket kongko, ambo' a say da'ton moyo.’ Adalen moya in ta nako akodti sa luta' nin mamagbabawi' konran makasalanan ambo' konra nin kano ket matunong sara.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Main nin ni'sa, nako saray tumutumbok na ni Juan a Mammawtismo kona ni Jesus. Wanra kona, “Si'kami tan saray Pariseo, ket mampagkulasyon kami. Ambale' a saray tumutumbok mo ket kai sara gapo nin mampagkulasyon?” ");
INSERT INTO smkNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ni'bat na ni Jesus konra nin saya yan alimbawa', “No main nin kasal, kasan sapo nin kiriga sara konan nubyo a kumbidado na! Leg'an a kalamo' raya et a nubyo, kai sara gapo nin gumereng. Bale' rumate' li' a panaon a maikadayo' ya ket magkulasyon sarayna.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wana et ni Jesus a maipa'ka' sa ba'yon akay na, “Kasan tawon manali'neb nin ba'yon abel sa ma'ran a aysing ta no gaw'en a wanin, si ba'yon abel kumsen ya li' ket guruyen naya a ma'ran nin abel ket maluod yay bisang na. ");
INSERT INTO smkNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kasaynamaet a lamang nin mangikwa nin mampibaliw nin arak sa ma'ran a katat nin supot a pangangwan, ta no gaw'en a wanin, si mampibaliw nin ba'yon arak tubraken naya, ket masida' yay supot tan mapirdin ma'met a arak. Matkap a say ba'yon arak ket ikwa sa ba'yon pangwan ta pigaw nin kasa konran saraytin rwa a mapirdi.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mampag'irgo ya et si Jesus sin rinmate' yay sayay pangulo nin Judio. Tinmalimukod ya sa adapan na ni Jesus tan wana, “Kai ya et nin nainsanan nin nati a anak kon babayi. Mayi ka tana kadi' sa bali ko tan ipababo moy gamet mo kona ta pigaw nin sumubli' yan mabyay.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Inumdeng ya si Jesus tan nayi ya kona. Nayi sara anamaet a tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Sin adap rayna sa bali nan upisyal, main nin babayin kinmadanin nako sa gurot na ni Jesus. Sitin babayi ket labinrway taon anan mandumaya' ya nin kasan tegen. Ket wanan sitin babayi sa nakem na, “Makudit koya tanay aysing na umanda' akoyna.” Kanya' nin kinudit nayay saroy nan aysing na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nibring yan inmadap si Jesus ket wana konan babayi, “Arikong, rumiriket ka. Bana' sa pagmamatalek mo ket inmanda' kayna.” Ket tampor konan sitaw anan udas inmanda' ya. ");
INSERT INTO smkNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nituloy raynay nako ket nakarate' sara sa bali nan pangulo. Sinumrep ya si Jesus ket sin na'kit nan itaw main nin musiko tan gewgewan ran tutawo, ");
INSERT INTO smkNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","wana, “Lumiwa' kamodti nga'min. Kai ya nin nati a anak; mampa'lek ya tamo'.” Ket kinaka'lisan rayan panuya'-tuya' kona. ");
INSERT INTO smkNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sin napaliwa' sarayna nga'min a itaw, linmuob ya si Jesus sa kwarton kami'nan nan anak. Gina'getan nay gamet na ket nibangon ya. ");
INSERT INTO smkNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Natanda-tandaan tin ginwa' na ni Jesus sa sarban bubabalidtaw. ");
INSERT INTO smkNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nibwat yaynadtaw sa bali nan upisyal si Jesus. Sin manlumalako ya, rwa ran bulag a tinmumbok konra. “Ka'dwan rakami kadi', si'kan nipangako' a puri na ni David,” wanran nita'wa-ta'way. ");
INSERT INTO smkNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sin sinumrep ya si Jesus sa bali, saray rway bulag inmarak sara kona. Tinepetan nasara a wana, “Mamper kamo nin mababa' kon gaw'en a maka'kit kamo?” “O', Maistro, mamper kami,” ni'bat ra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Inapros na a mata ra tan wana, “Mangyadi' komoyo a tepren moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ket naka'kit sarayna. Mairot nin nibibilin na konra a andi' ra ibari-barita' a maipa'ka' sa sayti. ");
INSERT INTO smkNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wanin man a wana ni Jesus, nika' ran lamang nibari-barita' sa sarban bubabalidtaw a maipa'ka' kona. ");
INSERT INTO smkNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mampibwat saraynaytaw saray rwan gindat a bulag sin main nin tawon naumel ta nasrepan yan ispiriton duka' a nirate' ran umno ran katawo kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sin napalakwan nayayna ni Jesus a ispiriton duka', nakapag'irgo yayna a tawon naumel ket naka'ngap sara nga'min a tutawodtaw. “Sawanin kami tamo' naka'kit nin wanin iti sa Israel,” wanra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bale' main nin Pariseo nin itaw ket wanra, “Si uunuren ran uispiriton duka' binyan naya in nin pakayadi' kanya' nin makapamalakwan yan ispiriton duka'.” ");
INSERT INTO smkNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kina'-kina' na ni Jesus a abaw nin bubabali tan bubaryo nin niyakay naya sa sinaguga tan nipata-patanda' nayay Mabistan Patanda' nin maipa'ka' sa pag'aadi' nan Dios. Pinaa-paanda' nasaray tutawon main nin nagsikabarang nin masakit tan man'irangep sa lalaman ra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ka'dwan nasaran tuloy a nadupong nin abaw a tutawo ta marere' sara tan kasan makatulong konra a bara'mo saran karniro nin kasan mangipastor konra. ");
INSERT INTO smkNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ket wana konran tumutumbok na, “Abaw saray nasadya' nin masagyat nin sumrep sa Pag'adian. Wanin man, matalag saray mangyayatab, ");
INSERT INTO smkNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kanya' edet nin idasal moyo konan Dios a syay main nin ikon sa yayataben a mangibaki' ya et nin saray trabahador nin kiyatab.” ");
INSERT INTO smkNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sawanin, kinayaban nasara ni Jesus a labinrwan adanin tumutumbok na tan binyan nasara nin pakayadi' nin mamalakwan nin duka' nin uispirito a nakasrep sa tutawo, tan mamaanda' nin abaw a bakas nin masakit tan man'irangep sa lalaman. ");
INSERT INTO smkNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sayti a ngaran ran saraytin labinrwan apostoles na ni Jesus: Mu'na-mu'na si Simon a pinangaranan nan Pedro, tan si Andres a busat na ni Pedro; si Santiago tan si busat na a si Juan a a'nak na ni Zebedeo; ");
INSERT INTO smkNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mi'sa si Felipe, tan si Bartolome, tan si Tomas, tan si Mateo a gindat a maniningir nin buis, tan si Santiago a anak na ni Alfeo, tan si Tadeo, ");
INSERT INTO smkNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tan si Simon a myimbro nin grupon ribulusyunaryo, tan si Judas Iscariote a syay magtraidor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nibaki' nasarayti ni Jesus saray labinrwa tan binibilin nasara a wana, “Andi' kamo nin mako sa bubabali ran ambo' nin Judio tan sa bubabali ran Samaritano, ");
INSERT INTO smkNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","no kai, mako kamo tamo' konran Israelita a saray pinili' nan tutawo nan Dios bale' bara'mo saran karniro nin pinauryan. ");
INSERT INTO smkNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ika' moyo nin ipatanda' konra a dandani yayna nin mag'adi' iti sa mundo a Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paandaen moyo saray mampagmasakit, pabyayen moyo saray nunati, paandaen moyo saray mampagmasakit nin duka' sa katat, tan palakwanen moyo saray uispiriton duka' a nakasrep sa tutawo. Nangrisibi kamon kasan bayad nangibwat konan Dios, andi' kamo anamaet nin pabayad sa gaw'en moyo konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Andi' kamo nin mibalon nin kwarta, ");
INSERT INTO smkNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tan andi' kamo nin mibag o mangawit nin pisilyan nin aysing o sapatos, o baston, ta si sayay mampagtrabaho, manepeg a ibi ran pagtrabahwan na a matkap na. ");
INSERT INTO smkNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","No rumate' kamo sa sayay babali o baryo, maningkap kamon maikana' a tawon mamagtuloy komoyo tan miikap kamo konan siin a pammali leleg nin isen kamo konan siin a lugar. ");
INSERT INTO smkNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","No rumate' kamo sa sayay bali, dawaten moyoy pammindisyon nan Dios konran main nin bali. ");
INSERT INTO smkNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No maong saran tawo, bindisyunan nasaran Dios, bale' no ambo' saran maong nin tawo, babawien moyoy nipamindisyon moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ket no main nin pammali o babali a saray tawodtaw ket kai rakamo nin pagtuluyen o kai ra nin reng'en a man'iparate' moyo konra, mibwat kamodtaw tan pagpagen moyoy ta'pok sa ayi moyo nin mangipataros a madusa sara li' sa sain a ginwa' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ibarita' koyti komoyo a sa Awro li' nin Manintinsya yay Dios, mas mabyat li' a dusan ibi nan Dios konran tutawo nan siin a babali dyan sa dusan ibi na li' konran taga Sodoma tan taga Gomorra.” ");
INSERT INTO smkNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Rumnge' kamon maong. Pakanda' kamo ta ibaki' katamon mako konran maraet a tutawo. Bara'mo kamo li' nin karniro nin nalibed ran mabayanin atap a uayep. Ket matkap a pag'inen moyon matadem a pangingisip moyo a kapada nan ulay, tan pag'inen moyon malinis a gugagara moyo a kapada kamo anamaet kaamo' nin kalapati. ");
INSERT INTO smkNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pakanda' kamo ta dakpen rakamo li' tan bistawen rakamo li' tan sanet-saneten rakamo li' itaw sa susinaguga ra. ");
INSERT INTO smkNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ika' rakamo et li' nin usisaen sa adapan ran mag'uuray tan uadi' bana' ta mangkikalamo' kamo kongko, ket pagkanawanawa moyoyna in li' nin mangipatanda' nin maipa'ka' konan Mabistan Patanda' konra tan konran raruman tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","No itaw kamoyna li' nin man'usisaen nin naiyadap konra, andi' moyo nin kaaburidwan no ani a ibarita' moyo tan no pa'noy pammarita' moyo. No udas moyoyna li' nin tumnoy, ibarita' nayna li' nin Dios komoyo a ibarita' moyo, ");
INSERT INTO smkNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ta ambo' li' nin si'kamoy mampag'irgo no kai si Ispirito nan Dios a Ama moyo a mampag'irgo yupa' komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","No saytaw, main li' nin tutawo nin mangipapati nin bubsat ra. Main li' nin uama nin mangipapati nin a'nak ra, tan main anamaet li' nin a'nak a magribildi tan mangipapati konran mangatua ra. ");
INSERT INTO smkNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wanin ta guraen rakamon sarban tutawo bana' ta mantarig'enan moyoy mangkikalamo' kongko. Bale' si tawon tarig'enan nay tumulok kongko anggan kala'pusan nin dya'dya', makarate' ya sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No padya'dyaen rakamo sa sayay babali lumakwan kamon mako sa sakalako. Ibarita' koyti komoyo a kai moyo et li' nin nakka' nin nangipatandaan a sarban bubabali nan Israel, si'kon si Pinaitawo ket sumubli' akoyna.” ");
INSERT INTO smkNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kasan si'numan nin mampag'adal a mas ata'gay dyan si maistro na. Wanin anamaet, kasan alila' a mas ata'gay dyan si amo na. ");
INSERT INTO smkNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ket makuntinto yayna a sayay mampag'adal no sa kapapa'sar ket makakipada ya konan maistro na, o si sayay alila' no makakipada ya konan amo na. Ket si'koyna anaod, nin bara'mon ulo nin pamilya, ket tinawag rakon Beelzebul a uunuren ran dudimunyo, laloynan kasan sapo a si'kamo nin tawo ko, ket pangaranan rakamo anamaet nin maraet. ");
INSERT INTO smkNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Anaod, ta si'koy amo moyo, andi' moyo sara nin ikali'mo a tutawo ta sarban bubagay a adi sawanin ket maipadar li' no marate' a udas, ta kasan sikrito nin kai nin matandaan. ");
INSERT INTO smkNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Say bubagay a si'kamo tamo' a namaritaan ko, ipatandaan moyo li' sa sarban tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Andi' moyo sara nin ikali'mo a makapangmati konan sitin lalaman bale' kai nin makapama'no konan kararwa moyo, no kai si Dios a ikali'mo moyo a syay makapangmati nin lalaman tan kararwa moyo itaw sa impyirno. ");
INSERT INTO smkNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Magwa' saran kalapsing a rway manuk-manok. Mataman wanin bale', ni saya konra kasan maragrag nin mati no kai na aburuyan nin Dios a Ama sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wanin anamaet a lamang komoyo, ni say sabot moyo sa ulo ket nabilang na et. ");
INSERT INTO smkNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kanya' anaod nin andi' kamo nin mali'mo ta mabli kamon adayo' kona dyan saray abaw a manuk-manok. ");
INSERT INTO smkNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sawanin anaod ibarita' ko, si si'numan a mangipatutuo konra nin tutawo a tumutumbok koya, ipatutuo ko li' anamaet nin tumutumbok koya kona ni Ama ko nin itaw sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bale' si si'numan a mangibudi' konran tutawo a tumutumbok koya, ibudi' ko li' anamaet kona nin Ama ko nin itaw sa langit a tumutumbok koya.” ");
INSERT INTO smkNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Andi' moyo nin ipa'ka' a nako akodti sa luta' ta pigaw nin main nin pitutuno. Kai ako nin nakodti ta pigaw nin main nin pitutuno no kai edet, ta pigaw nin main nin pilalaban. ");
INSERT INTO smkNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bana' sa gagara nin nipako kodti sa luta' kuntrawen naya li' nin anak nin lalaki a ama na, si anak nin babayi si ina na, tan si manuyang nin babayi si katyangan nan babayi. ");
INSERT INTO smkNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Saray mairot a kakuntra na li' nin sayay tawo ket saray dirin kalamanan na. ");
INSERT INTO smkNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","No mu'na-mu'na sara konan sayay tawo a mangatua na dyan si'ko, kai ya maikana' nin tumutumbok ko. O' no saray mu'na-mu'na konan sayay tawo ket saray a'nak na, kai yan lamang anamaet maikana' nin tumutumbok ko. ");
INSERT INTO smkNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","O' ta si tawo a kai ya nin mamalatay nin kudos na nin kai na ipulisay a wanin nin mabli kona, kai ya nin kumana' nin tumutumbok ko. ");
INSERT INTO smkNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Si si'numan a pablyen nay byay nadti sa mundo, mati ya li' a lamang, bale' si si'numan a gurutan nay byay nadti bana' sa pammabli na kongko, madumog na a tutuon byay.” ");
INSERT INTO smkNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Saray tutawon mangako' komoyo, si'koy inako' ra tan saray mangako' kongko, si Ama ko nin namaki' kongko a inako' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Si tawon mangako' nin sayay ibabaki' nan Dios bana' ta tanda' nan ibabaki' nayayti nin Dios, mabyan ya li' nin gun-gunan kapada nin gun-guna nan ibabaki' nan Dios tan si tawon mangako' konan sayay matunong a tawo bana' ta sitin tawon akuen na ket matunong ya, mabyan ya li' nin gun-gunan kapada nin gun-guna nan matunong a tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ibarita' koyti komoyo a mataman nin si sangkadaitean a pagsisirbi, alimbawa' say pamainom tana konan sayay ayupa' a tumutumbok ko, a pagsirbyan raya bana' ta tumutumbok koya, si mangwa' nin wanin kasan sapon mabyan ya li' nin gun-guna.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sawanin, sin nayadi' nasarayna nin binibilin ni Jesus a labinrwan tumutumbok na, linmakwan yayna konan sitaw a lugar tan nako ya sa kabaraybay nin bubabali ket itaw nipatandaan tan nipapalaway nayay Mabistan Patanda' konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Si Juan a Mammawtismo sin sain ket mangkapriso ya. Natandaan nay maipa'ka' sa mumilagro nin ginwa-ginwa' na ni Jesus a syay Cristo ket nangibaki' yan tumutumbok na nin mako raya nin tepetan. ");
INSERT INTO smkNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wanra kona ni Jesus, “Si'kayna paraytaw si nipangako' nan Dios a rumate' iti nin mag'adi', o main et nin sakalakon taga'nan mi?” ");
INSERT INTO smkNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ni'bat na ni Jesus konra, “Sumubli' kamo kona ni Juan ket ibarita' moyo kona a narnge' moyo maipa'ka' sa nibarita' ko tan say naimatunan moyon ginwa' ko. ");
INSERT INTO smkNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ibarita' moyo kona a saray bulag, maka'kit sarayna; saray lupoy, makalalako sarayna; saray main nin duka' a masakit sa katat, napaanda' sarayna; saray telek, makarnge' sarayna; saray nati, pinasubli' kosaran mabyay; tan konran maidap a byay, man'ipatanda' koyay Mabistan Patanda'. ");
INSERT INTO smkNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ket, makarma' yay tawon kai gapo nin maglat a pangungunor na kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kaibwat ran tumutumbok na ni Juan, inmadap ya si Jesus konran abaw a tutawodtaw nin ibarita' na a maipa'ka' kona ni Juan, a wana, “Sin nako kamodtaw sa lugar a ambo' nin matawo, ani a inilalwan moyon ma'kit itaw? Sayay tawo para a say pinanakem na ket kapada nin talaib a man'irpa-irpay nan siri? Kai! ");
INSERT INTO smkNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ani edet a rabay moyon ma'kit? Sayay tawon nisket nin mabli tan mapustura? Ambo' anaod nin wanin ta saray tawon misket nin mamabli ket miikap sara sa palasyo. ");
INSERT INTO smkNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ani edet a rabay moyon ma'kit? Kai para si sayay prupita nan Dios? O' bale' ibarita' ko komoyo a ambo' yan basta nin prupita si Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wanti ey wanan Dios sa Masanton Kasuratan maipa'ka' kona, ‘Si'ko, ibaki' koyan mu'nayna komo a tawo kon mangipatanda' nin maipa'ka' komo ta pigaw nin isadya' nay dalanan mo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ibarita' koyti anaod komoyo: Kasa et gapon niyanak nin makakipada kona ni Juan a Mammawtismo. Abirno nin wanin bale', si sangkaayupaan nin tawon iti sa sirong nin pag'aadi' nan si mangibwat sa langit, ket mas ata'gay ya et dyan si Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Anaod, nangibwat ana sin nitarana' na ni Juan a mangipatanda' nin maipa'ka' konan si tinudo' nan adi' nin Dios angga et sa sayti nin awro, mangkapasuet nin ipadar ana a pag'aadi' nin mangibwat sa langit, tan abaw saray tutawo nin man'ipasuet ray sumrep. ");
INSERT INTO smkNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bilang sa wanin a na'teng anan naipatanda' konran tutawo maipa'ka' konan mag'adi' a mangibwat sa langit, nangibwat et kona ni Moises tan saray prupita anggan sa tarana' nin pakatukid sin rinmate' ya si Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ket akuen moyo pa a si Juan ket syay Elias a mantaga'nan moyon sumubli'. ");
INSERT INTO smkNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Si'kamon manrumnge', adalen moyoyti nin maong.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ani a pangipadawan ko komoyo nin tutawo konan sitin panaon? A'nak. Ipada katamo konran a'nak a mampiikap sa plasa. Mangkuma'sel saray raruma konran kaikap ra a wanra, ");
INSERT INTO smkNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mampanugtog kami bale' kai kamo nin magbayli; anta mangkibereng kami komoyo ket kai kamo anamaet nin mangabet-abet.’ ");
INSERT INTO smkNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wanin ta, sin rinmate' ya si Juan, na'kit moyon nagkula-kulasyon ya tan kai ya gapo ninom nin arak, ket wamoyo, ‘Ya! Kurang-kurangen! Nasrepan yan ispiriton duka'!’ ");
INSERT INTO smkNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wanin a lamang anamaet sin rinmate' akon si Pinaitawo nin mampangan tan mampinom ako, ket wamoyo, ‘U! Kikiten moyayti e nin tawo! Masiba' ya tan mainom yan arak! Amigo rayan maniningir nin buis tan saray raruma et nin ambo' nin rilihyuso.’ Bale',” wana ni Jesus, “sa kabibyay ran saray mampagmatalek konan Dios, ma'kit nin kusto a kadunungan na.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ket binalaw nasara ni Jesus a tutawo sa lulugar a nangwaan nan abaw nin mumilagro ta kai ra et nin nagbabawian a duka' a gawa'-gawa' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ay, kado' kamoyna, si'kamon tagadti sa Corazin tan si'kamon tagadti sa Betsaida! O' ta abaw a mumilagron ginwa' kon para komoyo bale' kai moyo nin nagbabawian a kukasalanan moyo. No ginwa' ko in kumon itaw sa Tiro tan Sidon, na'teng sarayna kumon nin nisulot nin langgutsi tan tinmekre' sa abunsyang a tutawodtaw nin mangipa'kit nin pagbababawi' ra sa kukasalanan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sawanin edet, ibarita' ko komoyo, sa Awro li' nin Manintinsya yay Dios, mas mabyat li' a dusa nin ibi na komoyo dyan konran taga Tiro tan taga Sidon. ");
INSERT INTO smkNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ket si'kamo anamaet nin tagadti sa Capernaum, ipa'ka' moyo layin raywen rakamo sa langit! Kai anaod! Kasan sapon itampal rakamo sa impyirno! No ginwa' kodtaw kumon sa Sodoma a mumilagro nin ginwa' ko sa lugar moyo, kai naya kumon nin sinida' nin Dios a Sodoma tan main ya et kumon nin babali anggan sawanin. ");
INSERT INTO smkNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sawanin edet, ibarita' ko komoyo, sa Awro li' nin Manintinsya yay Dios, mas mabyat li' a dusa nin ibi na komoyo dyan say ibi na konran tutawo sa Sodoma.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sin sain, wana ni Jesus, “Ama ko a Uunuren sa langit tan sa luta', raywen kata ta kai mo nin nipatandaan konran madudunong tan di-adal nin tutawo a katutu'wan, no kai edet, nipatandaan moyti konran saray maayupa'. ");
INSERT INTO smkNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O' a ta wanin a makapaririket komo, Ama.” ");
INSERT INTO smkNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wana et ni Jesus konran tutawo, “Nipagamet nayna kongko nin Ama ko nin gaw'en tan tandaen a sarba. O', si'ko a si anak na tan si Ama ko tamo' a mitandaan nin peteg, pati sara et a pilien kon pangipadaran kona. ");
INSERT INTO smkNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Umarak kamo kongko, si'kamo nga'min nin gawa' ana nin gawa' tan mangkabyatan, ta si'koy painawnan moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tumumbok tan paiyakay kamo kongko ta madali' akon katarusan tan maayupa' a nakem ko, ket makadumog kamon inawa nin byay. ");
INSERT INTO smkNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mainum'ay a ipasunor ko, tan ambo' nin maidap tukiden a ipagwa' ko komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ambo' nin na'teng sayay awron Sabado a syay Awron Painawa, linmabas ya si Jesus tan saray tumutumbok na sa gagawa'. Mabitil saraynay tumutumbok na kanya' nin namursing saran rinakay tan nangusim sara. ");
INSERT INTO smkNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Main itaw nin Pariseo nin naka'kit konra ket wanra kona ni Jesus, “Oy, kiten mosaray tumutumbok mo! Man-gaw'en ra in, anta maiyawa' nin mangyatab no Awron Painawa!” ");
INSERT INTO smkNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ni'bat na ni Jesus, “Nalingwanan moyoyna palayi a nabasa moyodtaw sa Masanton Kasuratan maipa'ka' sa ginwa' na ni David nin mismo sin nabitilan ya tan saray kalalamo' na ta kasaynan ikabyay ra? ");
INSERT INTO smkNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kai para a sinumrep ya sa Bali nan Dios tan kinalap nay tinapay a nida'ton konan Dios? Ket sayti nitataw'an ran kinnan ni David tan saray tutawo na. Maiyawa' anaod a mangan nin saytin tinapay ta saray aburuyan tamo' nin mangan ket saray pupadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kai moyo para anamaet nin maalilbi' sa mabasa-basa sa Libron Gugan-gan a tepe' nin Awron Painawa, saray pupadi' no itaw sara sa Timplo nan Dios ket mansubagen ray Gugan-gan ta man-gaw'en ray trabaho ra? Mampagtrabaho saran page' no Awron Painawa bale' kai sara nin mampagkasalanan. ");
INSERT INTO smkNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","7","Wana nin Dios a mabasa sa Masanton Kasuratan, ‘Say mapainganga'do kamo konran kapada moyon tawo a makapaririket kongko, ambo' a say da'ton moyo.’ No mataros moyo tamo' kumon a pipa'kaan nan siin, kai moyo sara nin sinintinsyawan a kai nin nagkasalanan. Ibarita' koyti komoyo a iti sawanin komoyo a pag'aadi' nin mas makapangyayadi' dyan saytaw say maipa'ka' konan Timplo nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wanin ta si'kon si Pinaitawo, si'ko a makapangyayadi' maipa'ka' sa Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Linmakwan yadtaw si Jesus tan nako ya sa sinaguga radtaw nin Judio. ");
INSERT INTO smkNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Main nin sayay lalakidtaw a nati yay sayay takyay na. Main anamaet nin Pariseo nin itaw. Ket, bana' ta mampaningkap saran padalan a maparsawan rayan sinmubag sa Gugan-gan si Jesus, nitepet ra kona, “No paandaen nayan sayay tawo a sayay main nin masakit no Awron Painawa, sinubag na kasi a Gugan-gan?” ");
INSERT INTO smkNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ni'bat na ni Jesus, “No nanabo' ya sa ubot a ayep nan saya komoyo sa Awron Painawa, impusiblin kai naya nin keen arwasen abirno nin Awron Painawa. ");
INSERT INTO smkNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ket mabli yan adayo' a sayay tawo dyan ayep. Kanya' nin kai tamo nin subagen a Gugan-gan no tumulong atamo konan sayay tawo no Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kaaram, wana ni Jesus konan lalaki, “Ipa'nat may takyay mo.” Ket nipa'nat nayan lalaki a takyay na tan sin sain, linmimpyo ya, a kasaynan nidumawan na konan sayay takyay na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sin sain, linmakwan saraynadtaw a Pariseo tan nag'iirgwan ra no pa'no nin pammapati ra kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sin natandaan na ni Jesus a plano ran gaw'en nin Pariseo, linmakwan ya konan sitaw a lugar. Abaw saray tutawo nin nayi kona tan tinambar nasara nga'min a main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bale' binibilin nasara nin andi' ra nin ibari-barita' a ginwa' na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ket sa wanin, matukid a wana nin Dios a nisurat na ni Prupita Isaias, a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Sya ey ibabaki' kon pinili' ko. Mangkawa'nanen koya tan syay pakaririketan kon tuloy. Ibaki' koya kona a Ispirito ko tan iparate' na li' konran tutawo sa sarban lugar a mapteg nin sintinsya ko. ");
INSERT INTO smkNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kai ya nin kiaway tan kai yaynamaet nin gumurya-buryaw. Kai ya nin marnge' nin magdisku-diskurso. ");
INSERT INTO smkNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tulungan nasara li' a kasan pakababa' tan mangkakasawan anan ilalo, kapadan kai na nin pammari' nin liso konan dayamin naspok, o say kai na nin pangrep konan kuyep-kuyep a lampadawan. Ituluy-tuloy nay pangngawa' nin nipagwa' kona anggan matukid nayna li' a mapteg nin sintinsya ko ");
INSERT INTO smkNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","tan say sarban tawo ket magmatalek ana li' kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Main nin ni'ras ra kona ni Jesus nin lalaki a bulag tan umel ta nasrepan yan ispiriton duka'. Pinaanda' naya ni Jesus ket maka'kit tan makapag'irgo yayna. ");
INSERT INTO smkNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ket, saray tutawon itaw, naka'ngap saran awit a li'mo. “Siti na palayi yaytaw si nipangako' a puri na ni David?” wanra nin nitepetan. ");
INSERT INTO smkNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Main nin Pariseo nin itaw tan sin narnge' rayti wanra, “Makapalakwan yan ispiriton duka' bana' ta si Beelzebul a syay uunuren ran uispiriton duka' ket binyan nayan pakayadi'.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nataros na ni Jesus a iti sa kaisipan ra, kanya' nin wana konra, “No main nin sayay nasyon ket matau-tao tan milalaban saray tutawo na, kai ya nin magnayon. Wanin anamaet, no sa sayay pammali o babali, mapuruk-purok sara nin miaaway a saya tan saya, misisyay li' a pirat'anan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Edet a lamang, no say puon nin pakayadi' ko ket kona ni Satanas, mangkuntrawen nay kadiryan na kanya' nin pa'no ey a katutuloy nin pag'aadi' na? ");
INSERT INTO smkNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wamoyo nin si'ko ket palakwanen kosaray ispiriton duka' bana' sa pakayadi' na ni Beelzebul. Sara pa a tumutumbok moyo, mamalakwan sara paran ispiriton duka' a mangibwat anamaet sa pakayadi' na, o si Dios a mamin pakayadi' konra? Saran mismo a mamatutuo nin abas kamo sa man'iparsa moyo kongko! ");
INSERT INTO smkNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bale' sawanin, ta say pakayadi' kon mamalakwan nin ispiriton duka' ket ibat konan Ispirito nan Dios, ipadar anaod nin sayti a rinmate' anay udas nin mag'adi' yaynadti a Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tutuo in ta si Satanas ket bara'mo yan sayay magsen a tawo. Kasan makasrep sa bali na ta pigaw nin kalapen ray kukayadian na no kai raya yapo' nin baruren in a magsen nin tawo. Ket no nabaror rayayna, magwa' rayna nin kalapen nga'min a rabay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Si si'numan a kai nin kipasayan kikalamo' kongko, kuntra ya kongko. Si kai nin tumulong kongko, sambenan nako. ");
INSERT INTO smkNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bana' sa sain a pammaduka' moyo sa gawa' nan Ispirito, tandaan moyoyti: Mapirduna saray tutawo sa animan a kasalanan ra, mataman et sa duka' a irgwen ra konran kapada ran tawo o konan Dios. Bale' si si'numan a mamaduka' nin kabistawan nan Ispirito nan Dios, kai ya gapo nin mapirduna. ");
INSERT INTO smkNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mapirduna ya et a si'numan nin mag'irgo nin kuntra kongko, si'kon si Pinaitawo, bale' si si'numan a mag'irgo nin kuntra konan Ispirito nan Dios, kai ya gapo nin mapirduna anggan maka'numan.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Rway bagay tamo' a maibarita' maipa'ka' sa sain. No mabistay bunga ket mabista anamaet a ibwatan, o no duka' a bunga ket duka' anamaet a ibwatan. Sain a bilang nin matandaan no mabista o makapoy yay kayo a ma'kit sa bunga na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ket si'kamo, kasan maabig a maibarita' moyo ta duka' a pigagawa' moyo. Bara'mo kamon masirib a ulay! Lumiwa' nin lumiwa' sa bebey nan tawo no ani a iti sa kanakman na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Si tawon maabig, maabig a ibarita' na ta maabig a pinanakem na. Bale' si tawon maraet, maraet anamaet a ibarita' na ta maraet a pinanakem na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ibarita' koyti komoyo a no Awro li' nin Manintinsya yay Dios, ubatan nin barang saya a kasan kabalikasan nin susarita' a inirgo na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anaod, sigon sa susarita' a inirgo mo, sintinsyawan naka li' nin Dios no nepeg a dusawen naka o ibarita' nan mapteg ka.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kaaram, saray Madudunong sa Gugan-gan tan saray Pariseo nin itaw wanra kona ni Jesus, “Maistro, mangwa' ka pa edet nin paka'kitan ta pigaw nin ma'kit min si Dios a ibwatan nin pakayadi' mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wana ni Jesus konra, “Si'kamoynan tutawo sawanin a duka' tan malamang konan Dios! Sukat a kidawat kamo kongko nin paka'kitan! Kasan paka'kitan a ibat ako sa langit a ipa'kit komoyo no kai kal-la tamo' sitaw si na'kit a nangyadi' kona ni Prupita Jonas, ");
INSERT INTO smkNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","a itaw yan tuloy awro tan yabi sa rarem nin tyan nan alakin kuna'. Wanin anamaet li' kongko, si'kon si Pinaitawo, tuloy awro tan yabi ko li' nin iti sa rarem nin luta' nin naitabon. ");
INSERT INTO smkNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","No Awro li' nin Manintinsya yay Dios, umadap sara li' a taga Ninive ket ibarita' ra li' a manepeg nin dusawen kamo, ta sara, sin narnge' ray nipata-patanda' na ni Jonas, nagbabawi' sara tan ginurutan raynay duka' a pigagawa' ra. Si'kamo bale', iti ya sawanin komoyo a mas ata'gay et a pakataros dyan si Jonas bale' kai moyo nin man'akuen a akay na. ");
INSERT INTO smkNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No Awro li' nin Manintinsya yay Dios, umadap tan magtistigos ya li' anamaet a Rina nin taga Sheba a manepeg nin dusawen kamo, ta sya, abirno nin aninay kaday'an nin ibwatan na, nako ya nin nangrenge' sa madudunong nin akay na ni Adi' Solomon. Si'kamo bale', iti ya sawanin komoyo a mas ata'gay et a kadunungan dyan si Solomon bale' kai moyo nin akuen a akay na.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wanti et e: No napalakwan yaynay ispiriton duka' a nakasrep sa sayay tawo, mako ya nin mikadaw sa makrang nin lugar maningkap nin piikapan na. No kasan ma'kit na ");
INSERT INTO smkNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ket wana sa nakem na, ‘Sumubli' akodtaw pa sa ibwatan kon niikapan.’ Ket sumubli' ya tan marate' nayan kasan mampiikap; naringgasan tan nasider ya. ");
INSERT INTO smkNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Edet, mako ya managyat nin pito ra et nin ispiriton mas duka' et dyan sya mi'sa sumrep saran miikap konan sitaw a tawon ibwatan na. Anaod, mas grabi et li' a kapapa'sar nan sitaw a tawo dyan sin nu'na. Wanin a mangyadi' komoyon duka' a tutawo konan sitin panaon.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ket kapresan nan mampag'irgo ni Jesus konran tutawo sin rinmate' ya si nanay na tan saray bubsat na. Mantuma'gan saradtaw kona sa rikor ta rabay ray kiirgo kona. ");
INSERT INTO smkNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Main nin nangipatanda' kona a wana, “Maistro, si nanay mo tan saray bubsat mo ket itaw sara sa rikor. Rabay ray kiirgo komo.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ket wana ni Jesus kona, “O', tutuo. Itaw sara. Bale' saray ina tan bubsat kon talaga ket sakalako sara.” ");
INSERT INTO smkNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nitudo' nasaray tumutumbok na ket wana, “Sarayti a ina tan bubsat ko. ");
INSERT INTO smkNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ibarita' koy wanin ta si si'numan a man-gumwa' nin karabayan nan Ama ko sa langit, syay ina o busat ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Konan sitaw a lamang nin awro nibwat ya sa bali si Jesus tan nako ya nin tinmekre' sa rigrig nin baybay. ");
INSERT INTO smkNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pinasyan ka'bawan ra bale' nin tutawo nin inmarak kona. Kanya' nin rinmuran ya sa sayay baluto nin nakapundo ket tinmekre' yadtaw. Ket saray tutawo naka'deng sara sa abay. ");
INSERT INTO smkNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nangusar ya nin pangingiyarig sa niyakay na konra maipa'ka' sa abaw a bubagay. Wana ni Jesus, “Main nin sayay magtatalon a nako nanabwag nin bini' sa pinaririk na. ");
INSERT INTO smkNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sin man'isabwag nay bini', main nin naika' sa dadalanan. Na'kit rayti nin manuk-manok ket kinnan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Main anamaet nin naika' sa babato a iti tamo' sa babo a luta'. Rinumsik nin tampor ta ababoy luta'. ");
INSERT INTO smkNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sin na'mutan, nalanes; ket bana' ta kai nin nakayamot nin ararem, nakri'! ");
INSERT INTO smkNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Main et nin naika' sa lugar a mantubuan nin madiwin didikot. Linmambot tan kinmubpal a madiwin dikot ket nadaeg ti. ");
INSERT INTO smkNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ket main anamaet nin naika' sa madaem nin luta'. Ket main nin ginmungan tulumpulo', main nin a'nem a pulo', tan main anamaet nin sanyasot.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wana et ni Jesus, “Si'kamon manrumnge', adalen moyoyti nin maong.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kinmadani sara kona ni Jesus a tumutumbok na tan nitepet ra kona, “Ambale' a mangusar kan pangingiyarig sa pangangakay mo konran tutawo?” ");
INSERT INTO smkNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wana nin ni'bat, “O' a, ta, si'kamon peteg nin mantumumbok kongko, man'aburuyan nakamon Dios nin matandaan moyoy maipa'ka' sa pag'aadi' na a kai et nin naipataros nangibwat et sin nu'na, bale' konran raruman tutawo, kai na nin man'ipatandaan. ");
INSERT INTO smkNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Anaod, si tawon man'ipamuspusan nan matarusan a narnge' na, say pakataros na ket malamu'nan; bale' si tawon kai na rabay nin tarusan, mataman nin say tanda' na ket mag'in nin kasa. ");
INSERT INTO smkNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mangusar akon pangingiyarig bana' ta mataman nin ma'kit raynan ma'kit a man-gaw'en ko, kai ra nin mangkaipurok a mangka'kit ra; marnge' raynan marnge' a man'iyakay ko bale' kai ra nin manreng'en o mangkatarusan. ");
INSERT INTO smkNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sa sain a kapapa'sar ra ket matukid a nibarita' nan Dios a niparate' na ni Prupita Isaias. Wana, ‘Saraytin tutawo, marnge' raynan marnge' bale' kai ra nin matarusan; Ma'kit raynan ma'kit bale' kai ra nin alilbien, ");
INSERT INTO smkNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ta tinmib'ey anay ulo ra. Pinaletpetan ray tutulyan ra tan nikidem raynay mata ra ta no ambo' nin wanin, ma'kit, marnge' tan mataros ra kumon no ani a matunong, tan mamper sara kongko ket isalba kosara.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wana ni Jesus, “Bale' si'kamo, makarma' kamo ta main nin paka'kit tan pakarnge' moyo sa katutu'wan. ");
INSERT INTO smkNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ibarita' koyti komoyo a abaw saray prupita tan tutawon matunong sin nu'nan panaon a masulit nin maka'kit tan makarnge' sa mangka'kit tan mangkarnge' moyo maipa'ka' sa pangingisalba nan Dios kontamo, ket kai nin nangyadi' ti sin panaon ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wana et ni Jesus, “Reng'en moyo tan adalen moyo a pipa'kaan nan si pangingiyarig nin maipa'ka' konan magtatalon. ");
INSERT INTO smkNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Saray tutawon nakarnge' nin maipa'ka' sa pag'aadi' nan Dios bale' kai rayti nin natarusan, maipada sara sa dadalanan a naikaan nin bini'. Nako ya konra a si sya a Kadukaan ket nipalingwanan nay narnge' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Say babato nin lugar a naikaan nin bini', maipada saradti a maririket nin nakarnge' sa Sarita' nan Dios tan tampor a inako' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bale' kai nin nakayamot konra kanya' nin kai nagnayon ta sin mangirangep saraynan pakapaidap tan pammadya'dya' bana' sa nipangrisibi ra nin Sarita' nan Dios, rinmay'ep sara tan ginurutan rayna. ");
INSERT INTO smkNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Itaw sa no adti main nin tinmubo' nin madiwin dikot a naikaan nin bini', maipada sara anamaet a nangrenge' sa Sarita' nan Dios. Bale' bana' ta kaaburidwan ray kabibyay ra tan nu'na-nu'nay apes ran yumaman, ket nadaeg nin sayti a apes ran tumbuken a Sarita' nan Dios. Kai nin ginmunga sa byay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ket saytaw anamaet say madaem nin luta' a naikaan nin bini', maipada saray nangrenge' tan natarusan ray Sarita' nan Dios ket nagtrabaho sa byay ra tan ginmunga nin bara'mon bini' a main nin ginmungan tulumpulo', o a'nem a pulo', o sanyasot.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nami ya anamanaet nin sayay pangingiyarig si Jesus. Wana, “Say pag'aadi' nan Dios ket maiyarig sa nangyadi' iti konan sitin isturya. Main nin sayay lalaki nin nako nangisabwag nin sayay klasin mabistan bini' a kasan lawok nin raruma sa mantalunen na. ");
INSERT INTO smkNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bale' sayay yabi sin nakaka'lek saraynay tutawo, sayan kuntra konan sitin tawo a nako konan sitaw a mantalunen na, tan nangisabwag yan bikoy nin duka' a klasin rabot, a no tumubo' ket kapadan bakas nin saytaw say mabistan klasin bikoy. Mi'sa nibwat yayna. ");
INSERT INTO smkNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sin inmalaki tan gumungayna, maipurok anay rabot. ");
INSERT INTO smkNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naka'ngap saray padalos nan main nin luta' nin nako sara kona a wanra, ‘Don, kasan lawok nin saytaw say bikoy a nisabwag moyo sa luta' moyo. Adti taw nin nangibwat say duka' nin rabot a tinmubo'?’ ");
INSERT INTO smkNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wana, ‘Kasan sapo! Kakuntra koyay nangwa' nin sain!’ ‘Pa'no sawanin ey, di dutduten mi a rabot?’ wanra nin padalos. ");
INSERT INTO smkNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Andi',’ wanan amo, ‘ta bangli' no maikidutdot moyoy mabistan klasin mula. ");
INSERT INTO smkNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Taga'nan moyoynay pangyayatab, ta ibarita' ko li' konran mangyatab a dutduten ra mi'sa ra nin berberen nin puuran. Mayadi', yataben ra li' a mabistan klasin mula mi'sa iyator sa agamang ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Nami ya anamanaet nin sayay pangingiyarig si Jesus. Wana, “Say iyalawang nin pag'aadi' nan Dios ket maiyarig sa bikoy nin mustasa a sangkadaitean sa sarba nin bikoy. Bale' no naimula yayna, tumubo' ya tan mag'in yan sangkaalakyan sa sarban pupising. Ata'gay yan bara'mon kayo ket saray manuk-manok umapon sara kona tan mipugar sara sa susanga na.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nami ya anamanaet nin pangingiyarig si Jesus. Wana, “Say pakaitayak nin akay maipa'ka' sa pag'aadi' nan Dios ket maiyarig sa pammakbo. Nilawok nan sayay babayi a daite' nin pammakbo sa tulon latan arina. Ket kinumbo yay intiron minasa na.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa nipangibari-barita' nan sayti ni Jesus konran tutawo ket nangusar yan pangingiyarig. Kasan nibarita' na a kai ya nangusar nin pangingiyarig. ");
INSERT INTO smkNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sa wantin ginwa' na ni Jesus a nakatukidan nin wana nin Dios a nipaiparate' na konan prupita. Wana, “Mangusar ako li' nin pangingiyarig no iyakay kosara. Ipatandaan ko li' konra a bubagay nin kasa et gapon nakatanda' nangibwat sin naparsa yay mundo.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ket linakwanan nasarayna ni Jesus a tutawo tan sinumrep ya sa bali. Tinumbok raya nin tumutumbok na tan wanra kona, “Ipapalaway mo pa komi a pipa'kaan nan pangingiyarig maipa'ka' sa rabot.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wana ni Jesus, “Si'kon si Pinaitawo yaytaw si nangisabwag nin mabistan bikoy a kasan lawok. ");
INSERT INTO smkNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sitaw si mantalunen ket kaalimbawaan nayan mundo. Saytaw say mabistan klasin bikoy a kasan lawok, sara a tutawo nin si Dios a mampag'adi' sa byay ra, tan saytaw say bikoy nin duka' a klasin rabot, sara a tutawon si sya a Kadukaan a mampag'adi' sa byay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sitaw si kakuntra nan lalaki, sya a Dimunyo. Say pangyayatab, isimbulo a anggawan nan sitin panaon, tan saray mangyayatab, saray uanghil nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Saytaw say pakadutdot tan pakaberber nin puuran nin duka' a rabot, sain a mangyadi' li' konran duka' a tutawo no anggawan nan sitin panaon ");
INSERT INTO smkNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ta si'kon si Pinaitawo, ibaki' kosara li' a uanghil ko nin mako rasara galten nga'min sa Pag'adian ko a sarba ran gumu-gumwa' nin duka' a makaayat konran raruma nin magkasalanan. ");
INSERT INTO smkNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ket itampal rasara li' sa burung-burong nin apoy sa impyirno. Itaw umasisit tan umagrem sara li' tan ngumaretenget li' a ngipen ra bana' sa pakapaidap tan bereng ra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Saray pinapteg nan Dios bale', ipadar ra li' a kinamapteg na nin Dios nin kapada na kaslag nin awro itaw sa Pag'adian nan Dios, si Ama ran itaw sa langit. Si'kamon manrumnge', adalen moyoytin maong.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Si Pag'adian nan Dios ket maiyarig ya sa kayamanan a naikali sa luta'. Nadumog nayti nin sayay tawo ket tinambakan nan uman. Pinasyan ririket na ket nako ya sa bali na tan nilako' na a sarban main na mi'sa naya kina' sinaliw taw nin luta'. ");
INSERT INTO smkNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Si Pag'adian nan Dios ket maiyarig ya et konan sayay kumirsyanti nin mampaningkap nin kumprawen nan mabistan klasi tan mablin pirlas. ");
INSERT INTO smkNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sin na'kit nayaynay sangkablyan, nika' na nin nilako' nga'min a sarban main na mi'sa naya kina' sinaliw taw nin pirlas. ");
INSERT INTO smkNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Si Pag'adian nan Dios ket maiyarig ya et a lamang sa kayakas a nikatkat sa taaw a makakalap nin sarbaynan klasin kuna'. ");
INSERT INTO smkNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No abaw anay nakalap, arwasen rayayna nin maninilay mi'sa rasara nin galten tan klasyen a kuna'. Saray mabistan klasi, ikwa rasara sa gagaban ra tan saray makapoy, itampal rasara. ");
INSERT INTO smkNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wanin li' anamaet a mangyadi' no anggawan nan sitin panaon ta isyay rasara li' nin uanghil konran matunong a duka' nin tutawo, ");
INSERT INTO smkNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mi'sa rasara li' nin itampal sa burung-burong nin apoy. Itaw umasisit tan umagrem sara li' tan ngumaretenget a ngipen ra sa pakapaidap tan bereng ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nitepet na ni Jesus konran tumutumbok na, “Natarusan moyo paray nibarita' ko?” “O',” wanra. ");
INSERT INTO smkNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Anaod,” wana ni Jesus, “no si sayay mangangakay nin Sarita' nan Dios ket naadal naynan tumbuken a katutu'wan maipa'ka' sa pag'aadi' mangibwat sa langit, bara'mo yan tawon abaw a kayadian sa bali na ta ambo' tamo' nin say gindat a maiyakay na, no kai edet, pati say ba'yo.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sin nayadi' nayna nin nibi taw nin pangingiyarig ni Jesus, nibwat ya konan sitaw a lugar, ");
INSERT INTO smkNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ket, sinmubli' ya sa Nazaret a mismon babali na. Itaw nangyakay ya sa sinaguga ra ket saray nakarnge' kona naka'ngap saran maong. Wanra, “Ya! Adti ya kano in nin nag'adal? Adti in nangibwat a kaungan na nin magmilagro? ");
INSERT INTO smkNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","No, anak naya tamo' in nin si karpintiro! Siin ket si Maria a ina na tan kaka raya ni Santiago, Jose, Simon, tan ni Judas! ");
INSERT INTO smkNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sara et a ari nan bubbayi ket iti sara nin mampiikap. Adti na kadi' nin kinalap in nin kadunungan tan pakayadi' na?” ");
INSERT INTO smkNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kai ra nin kauna'nepan a maipa'ka' kona ket kai sara nin namper kona. Wana ni Jesus konra, “Rispitado yay sayay prupita pwira tamo' sa mismon babali na tan pwira konran mismon pamilya na.” ");
INSERT INTO smkNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ket ambo' nin abaw a ginwa' nadtaw nin milagro ta saray tutawo kai sara nin namper kona. ");
INSERT INTO smkNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sin sain, natandaan na ni Herodes Antipas, a syay ulon gubyirno sa Galilea, a maipa'ka' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Sya si Juan a sinmubli' nin mabyay! Ket anaod, main nin pakayadi' nan makagwa' nin mumilagro,” wana ni Herodes konran tutawo na ");
INSERT INTO smkNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ta intaw ket nipadakep naya si Juan, nipapriso tan nipakadinawan naya. Ginwa' nayti ni Herodes bana' kona ni Herodias a asawa nan busat na nin si Felipe, ");
INSERT INTO smkNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ta wana intaw nin nibari-barita' ni Juan kona ni Herodes, “Abas a i'yan ma.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Konan siin ket rabay nayaynan ipapati si Juan bale' mali'mo ya konran ka'bawan ra nin tutawo ta tepren ran saya yan prupita si Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bale' sin narate' a awron nikaiyanak na ni Herodes tan sinilibra rayti, dinmukdok yay anak nan balasang ni Herodias sa adapan ran bubisita. Napagustwan ya si Herodes ");
INSERT INTO smkNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ket wana konan balasang, “Sambawan ko nin ibi ko komo a animan nin dawaten mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Binibilin nayan ina na a balasang kanya' nin wanti a dinawat na kona ni Herodes, “Rabay kon ibi ma kongko sawanin ana nin mismo nin naikwa sa plato a ulo na ni Juan a Mammawtismo.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nagbabawian nan adi' a nipangako' na, bale' bana' ta nagpangako' yan sinambawan na ket narnge' ran bubisita na, nigan-gan nay pakaunor nin dawat nan balasang. ");
INSERT INTO smkNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nipaputol naya sa priswan a ulo na ni Juan. ");
INSERT INTO smkNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nikwa raya sa plato mi'sa raya nin nibi konan balasang, ket si balasang nika' naya konan ina na. ");
INSERT INTO smkNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ket kina' raya kinalap itaw sa priswan nin tumutumbok na ni Juan a bangkay na tan nitabon raya. Mi'sa, nika' ra nin niparate' kona ni Jesus a nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sawanin, sin natandaan na ni Jesus a maipa'ka' sa sain, nibwat ya tan saray raruman tumutumbok na nin rinmuran sa baluto a mako sa lugar a kasan tawo ta pigaw nin magbukud-bukod sara. Bale' abaw saray tutawon nakatanda' no adti a keen ra kanya' nin nibwat sara sa bubabali ra nin nangrigrig baybay saran linmalakon tinmumbok kona. ");
INSERT INTO smkNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sin nakaabay sarayna si Jesus, na'kit nasara a abaw itaw nin tutawo. Maka'dwan yan tuloy konra. Ket pinaanda' nasaray main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sin dumedlem ana, kinmadani saray tumutumbok na kona ket wanra, “Mandumedlem ana ket kasa pa et nin bubalidti, kanya' nin paibwaten mosarayna nin makapako sara sa raruman bubaryo ket makasaliw saran kanen ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Kai sara matkap nin palakwanen,” wana ni Jesus. “Si'kamoynay mamin ma'kan ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ya! Lima ray tinapay tan rwa ray kuna' tamo' bale' a main iti,” wanra. ");
INSERT INTO smkNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ket wana ni Jesus, “Ika' moyodti kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pinatekre' nasara a tutawo sa rarabot. Inagwang nay liman tinapay tan saray rwan kuna' mi'sa ya tinmangar sa langit ket nikisalamat ya konan Dios. Tinau-tao nayti tan nibi na konran tumutumbok na nin itayak ra konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakapangan sara nga'min a tutawo tan nabsoy sara. Dininep ran tumutumbok a tara' ket main nin labinrwan balyag. ");
INSERT INTO smkNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Saray nangan, limanribo saray lulalaki tan kai sarayna nin nikibilang a bubbayi tan a'nak. ");
INSERT INTO smkNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kaaram, pinaruran nasarayna ni Jesus sa baluto a tumutumbok na tan pinau'na nasaraynan mako sa rubari' nan baybay leg'an nasaran pinaibwat a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sin nakaibwat saraynay tutawo, nako ya sa sayay ata'gay nin purod, a bukud-bukod nadtaw, ta pigaw nin dumasal ya. Mandumedlem ana ket itaw ya et nin bukud-bukod. ");
INSERT INTO smkNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sara anamaet bale' a tumutumbok na nin mansumaki sa baluto, itaw sarayna sa butlay. Mangkapaidap saran sumaki ta alalaki a daluyon tan sungsong yay siri. ");
INSERT INTO smkNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sin bandan parbangon, tinmumbok ya konra nin manlumalako ya sa babon ranom. ");
INSERT INTO smkNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ket sin na'kit ran main nin manlumalako sa babon ranom, nali'mwan sara. “Main nin lampong!” nita'way ra nin pinasyan li'mo. ");
INSERT INTO smkNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nag'irgo yan tampor si Jesus a wana, “Andi' kamo nin mali'mo. Si'koyti. Paksawen moyoy nakem moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wana ni Pedro, “Catawan, no page' a si'ka in, kayaban nakon makodsen komo a lumalako ako sa babon ranom.” ");
INSERT INTO smkNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Paradti,” wana ni Jesus. Inmarawas ya sa baluto si Pedro tan linmalako yan nako kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bale' linmi'mo ya sin nadlaw nan pinasyan peres ket manlumdeg yayna. “Byayen nako, Catawan!” wanan nita'way. ");
INSERT INTO smkNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sinampat naya nin tampor ni Jesus tan wana kona, “Si'kan kurang a pagmamatalek, ambale' a nagdwadwa ka?” ");
INSERT INTO smkNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Rinmuran sara sa baluto ket linumteng ana. ");
INSERT INTO smkNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Saray itaw sa baluto nangrayo sara kona ni Jesus. Wanra, “Peteg a si'kay Anak nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sin nakaripay sarayna, inmabay sara sa Genesaret. ");
INSERT INTO smkNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Naalilbi' rayan tutawodtaw si Jesus ket nipata-patanda' ra sa nagsikabarang nin lugar itaw a pagkamain na. Ket inawit-awit rasaran tutawo kona a mampagmasakit. ");
INSERT INTO smkNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nikidawat saran inganga'do kona a aburuyan nasara tanan kuditen ray saroy nin aysing na. Ket sarba ran nakakudit inmanda' sara. ");
INSERT INTO smkNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ni'sa, main nin Pariseo tan Madudunong sa Gugan-gan a rinmate' nin ibat sa Jerusalem a nako kona ni Jesus. Nitepet ra kona, ");
INSERT INTO smkNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ambale' a man-gurutan ran tumutumbok mo a kaugalian a nangibwat et konran pupuon tamo bilang say mangan sarayna nin kai ra nin tumbuken a ugali' nin manepeg a pammusbos nin ranom sa gamet?” ");
INSERT INTO smkNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ni'bat na ni Jesus konra, “Si'kamo anamaet, ambale' a man-gurutan moyoy nigan-gan nan Dios bana' sa panunumbok moyo nin kaugalian moyo ");
INSERT INTO smkNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ta wanan Dios, ‘Igalang ma si ama mo tan si ina mo,’ tan wana et, ‘Si si'numan a mamaduka' nin ama na o ina na, kasan sapo nin patyen ya.’ ");
INSERT INTO smkNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bale' si'kamo, say man'iyakay moyo ket sakalako. Wamoyo a no main nin magwa' nan ibin tulong nin sayay tawo konran mangatua na, ibada' nayna konra a igagara na anayti nin ida'ton konan Dios ket kai na nin maibi nin tulong konra. ");
INSERT INTO smkNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ket sigon sa sain a akay moyo, kai nasarayna matkap nin lingapen a mangatua na. Sa wanin a gawa' moyo sa tanay matumbok moyo a uakay moyon bukod, ginwa' moyon kasan kwinta a nibarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mampisantu-santos kamo tamo'. Kustoy nipadles na ni Prupita Isaias maipa'ka' komoyo a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Saraytin tutawo,’ wanan Dios, ‘raywen rako sa irgo, bale' say kukanakman ra ket adayo' nin tuloy kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kasan kakanaan nin pangrarayo ra kongko ta uakay ran diri a man'ipatukid ra nin bara'mo nin gugan-gan ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pinakadani nasara ni Jesus kona a abaw nin tutawon itaw. Wana konra, “Reng'en rako tan tarusan moyoy ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ambo' a say sumrep sa bebey nan sayay tawo a puon nin pagkakasalanan na, no kai say duka' a lumiwa' sa bebey na.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kinmadani sara konay tumutumbok na ket wanra kona, “Tanda' mo paran napasager mosaray Pariseo sa saytaw say nibarita' mo?” ");
INSERT INTO smkNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ni'bat na ni Jesus konra, “Sarban mula nin kai na nin nimula ni Ama ko nin itaw sa langit ket madutdot li'. ");
INSERT INTO smkNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pauryan moyo sara. Bara'mo saran sayay bulag a mampanabin nin mangyakay dalan konan saya et nin bulag. Ambo' nin ma'teng ket pariho saran maikura'bot.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kapingmatan wana ni Pedro, “Ipapalaway mo pa komi a pipa'kaan nan sitaw si pangingiyarig nin nibarita' mo konran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Ani, anggan sawanin kapada ran raruma, kai kamo et nin makataros?” wana ni Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Kai moyo para nin maamingaw a sarban ipasrep tamo sa bebey tamo ket mako sa tyan tamo mi'sa li' a lamang nin lumiwa'? ");
INSERT INTO smkNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","No kai edet a lamang, say duka' nin lumiwa' sa bebey nan sayay tawo nin mangibwat sa nakem na, sayti a mamagkasalanan konan sayay tawo! ");
INSERT INTO smkNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wanti ana: say duka' nin kukaisipan, say mangmati, say kiraray sa ambo' nin asawa, say sarbaynan klasin pangikon ran lalaki nin kapada ran lalaki o ran babayi nin kapada ran babayi, say manakaw, say mibula'-bula', tan say manida' nin kagalangan nin raruman tawo; mangibwat in sa nakem nan sayay tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sain nin gugawa' a mamag'in konan sayay tawo nin kai kumana' sa pangingikit nan Dios. Ambo' taw say kai nin panunumbok sa kaugalian a manepeg nin pammusbos nin gamet.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Linmakwan saraynadtaw si Jesus tan nako sara sa sayay lugar nin adani sa syudad nin Tiro tan Sidon. ");
INSERT INTO smkNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Main nin mampiikap itaw nin sayay babayin ambo' nin Judio ta taga Canaan ya a tinmumbok konra. Wana nin man'ita'wa-ta'way, “Ka'dwan nako kadi', Catawan, si'kan nipangako' a puri na ni David. Nasrepan yan ispiriton duka' a anak kon babayi ket mangkapaidap yan maong.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bale' kai ya gapo nin tinumnoy si Jesus. Kinmadani sara kona a tumutumbok na tan dinawat ra nin ni'no kona a wanra, “Nangibwat naon ya in et nin tumbok anan tumbok tan ta'way anan ta'way. Paibwaten mayna pa.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ket wana ni Jesus, “Nibaki' nako bale' nin Dios nin mako tamo' konran Israelita, a sara ket bara'mo saran kukarniron nabarang.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bale', inmarak yay babayi kona tan nanalimukod ya. Nikidawat yan inganga'do nin wana, “Catawan, tulungan nako!” ");
INSERT INTO smkNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Imbatan naya ni Jesus, “Ambo' nin manepeg a kalapen a kanen ran a'nak tan ipakan konran tuwe'.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ni'bat na nin babayi, “Ser, tutuo in say wamo bale', mataman anamaet nin saray aso ket ma'kan ray pasi' ran amo ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","“Pinasyan eget nin pagmamatalek mo, Baying!” wana ni Jesus kona. “Mangyadi' in say mandawaten mo.” Ket sin saytaw nin mismo, inmanda' yay anak nan sitaw a babayi. ");
INSERT INTO smkNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Linmakwan yaynadtaw si Jesus a nangrigrig yan Baybay Galilea. Nuli' ya sa sayay purod ket tinmekre' yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abaw saray tutawon inmarak itaw kona. Abaw saray tutawon mampagmasakit nin nagsikabarang a ni'ras ra kona, bilang saray paralitiko, saray pilay, saray bulag, saray umel, tan saray main nin raruma et nin masakit. Nikwa-nikwa rasara sa adapan na ni Jesus ket pinaanda' nasara nga'min — ");
INSERT INTO smkNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","a makapag'irgo saraynay umel, makakimey saraynay paralitiko, makalalako saraynan limpyo a pilay, tan maka'kit saraynay bulag. Naka'ngap sara nga'min a tutawon itaw nin naka'kit sa sayti ket rinayo rayay Dios, si Dios a manraywen ran Israelita. ");
INSERT INTO smkNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kinayaban nasara ni Jesus a tumutumbok na ket wana konra, “Kudwa'dwan kosarayti saray tutawo ta tuloy awro raynan iti ket na'pos anay balon ra. Kai kosara rabay nin paibwaten nin kai nin nangan ta bangli' no maulaw-ulaw sara sa dalan sa bitil ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanra nin tumutumbok na, “Adti atamo mangalap iti sa wantin kasan kabali-balin lugar nin kanen a sumadag konran saraytin pinasyan ka'bawan nin tutawo ey?” ");
INSERT INTO smkNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nitepet na ni Jesus konra, “Umno ra et a natra' nin tinapay?” “Pito ra et tan main nin umno ray madidintek nin kuna',” ni'bat ra nin tumutumbok. ");
INSERT INTO smkNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ket pinatekre' nasara ni Jesus a tutawo sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kinalap nasaray piton tinapay tan say kuna' tan nikisalamat ya konan Dios. Tinau-tao nayti mi'sa na nibi-nibi konran tumutumbok na nin itayak ra konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nakapangan sara nga'min a tutawo tan nabsoy sara. Sumunor, sin dininep ran tumutumbok na a tara' ket main nin piton gagaban. ");
INSERT INTO smkNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Saray nangan, a'pat a ribo saray lulalaki tan kai sarayna nin nikibilang a bubbayi tan saray a'nak. ");
INSERT INTO smkNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kaaram, pinaibwat nasarayna ni Jesus a tutawo, mi'sa nako yayna nin rinmuran sa baluto nin mako sa lugar a sakop nan Magadan. ");
INSERT INTO smkNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Main nin Pariseo tan Saduseo nin nako kona ni Jesus. Mampangkit saran puon a sidaen ray kagalangan na kanya' nin wanran dinawat kona, “Mangwa' ka pa edet nin paka'kitan a nibaki' naka nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bale' ni'bat na ni Jesus konra, “No mu'dit yay langit no mansumrep yay awro, ibarita' moyo, ‘Mabista li' a tyimpo dilap,’ ");
INSERT INTO smkNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","tan no kabubuklas ket mu'dit a sira' nan awro tan marurem yay langit, wamoyo, ‘Rumapeg ya sawanin.’ Mataros moyoy pipa'kaan nin bakas nan langit, ket sukat a kai moyo nin mataros a pipa'kaan nin bubagay a mampangyadi' konan sitin panaon! ");
INSERT INTO smkNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Si'kamoynan tutawo sawanin a duka' tan malamang konan Dios! Mayin ta kidawat kamo kongko nin paka'kitan? Kasan paka'kitan a ibat ako sa langit nin ipa'kit komoyo no kai kal-la tamo' sitaw si na'kit a nangyadi' kona ni Jonas sin saytaw.” Sin nayadi' na anayti nin nibarita', linakwanan nasarayna. ");
INSERT INTO smkNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sinmaki saran makodtaw sa rubari' a tumutumbok na ni Jesus bale' nalingwanan ra a nibalon. ");
INSERT INTO smkNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sin nakaabay sarayna, wana ni Jesus konra, “Pakailag kamon maong sa pammakbo ran Pariseo tan Saduseo.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nag'iirgwan rayaytaw nin tumutumbok si wana. Wanra, “Wantaw a nibarita' na ta nalingwanan tamoy nibalon nin tinapay.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nataros na ni Jesus no ani a mampag'irgwan ra kanya' nin wana konra, “Ambale' a siin si nalingwanan moyoy tinapay a mampag'iirgwan moyo? Kurang a pagmamatalek moyo! ");
INSERT INTO smkNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anggan sawanin kai moyo et nin matarusan? Nalingwanan moyoyna para? Sin tinau-tao koy lima ran tinapay nin nipamakan konran limanribon lulalaki, umnoy balyag a nadinep moyon tara'; ");
INSERT INTO smkNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tan sin tinau-tao koy pito ran tinapay nin nipamakan konran a'pat a ribon lulalaki, umnoy gagaban a nadinep moyon tara'? ");
INSERT INTO smkNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ambale' a kai moyo tana nin mataros a ambo' nin maipa'ka' sa tinapay a man'ibarita' ko komoyo sin wangko nin pakailag kamo sa pammakbo ran Pariseo tan Saduseo?” ");
INSERT INTO smkNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nataros rayna sin sain nin tumutumbok a ambo' nin say pammakbo nin usaren no mangwa' nin tinapay a wana ni Jesus nin matkap ran ilagen, no kai edet, say akay ran Pariseo tan Saduseo maipa'ka' konan Cristo. ");
INSERT INTO smkNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nako ya si Jesus tan saray tumutumbok na sa lugar nin adani sa babali nan Cesarea-Filipos. Sin itaw sarayna, tinepet na ni Jesus konran tumutumbok na nin wana, “Ani a ibari-barita' ran tutawo maipa'ka' kongkon si Pinaitawo? Si'no ako kano a wanra?” ");
INSERT INTO smkNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wanra nin ni'bat, “Main nin mamarita' a si'ka si Juan a Mammawtismo, bale' main anamaet nin mamarita' a si'ka si Elias. Saray raruma et ibarita' ra a si'ka si Jeremias, o no kai, saya ka konran saray prupita.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ket si'kamo anamaet, si'no ako sa wamoyo?” nitepet na konra. ");
INSERT INTO smkNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ni'bat na ni Simon Pedro, “Si'kay Cristo, si Anak nan sibibyay a Dios nin nipangako' na.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ket wanan ni'bat ni Jesus kona, “Makarma' ka, Simon nin anak na ni Jonas, ta ambo' nin tawo a nakatandaan mon sain no kai edet, dirin si Ama kon itaw sa langit a nangipatanda' komo. ");
INSERT INTO smkNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ket si'ko, ibarita' ko a si'ka, Pedro ka. Konan siin si bara'mon sayay baton pundasyon a pangipatukduan ko nin nikapasaya ran lapag nin tutawo ko. Kasa li' gapo nin makadaeg konra, mataman et nin say pakayadi' nin mangibwat sa impyirno. ");
INSERT INTO smkNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Komo, ibi ko li' a pagkanawanawa nin mangipatanda' nin maipa'ka' kongko, a bilang nin naipya komo a tumbok nin Pag'adian nin mangibwat sa Langit ta pigaw nin makasrep saray abaw a tutawo. Say aburuyan modti sa luta' nin magwa' nin gaw'en, aburuyan nan Dios, tan say kai mo nin aburuyan iti sa luta' nin magwa' nin gaw'en, kai na nin aburuyan nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sin nayadi' nayna nin nibarita' ti ni Jesus, mairot nasaran binibilin a tumutumbok na a andi' ra gapo nin ibari-barita' a syay Cristo. ");
INSERT INTO smkNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nangibwat ana sin sain, nipatandaan nayna ni Jesus konran tumutumbok na a naiketeg anan mangyadi' kona. Wana konra, “Matkap a mako ako sa Jerusalem ket itaw mangirangep ako li' nin abaw nin pammadya'dya' ran saray Madudunong sa Gugan-gan tamo, tan saray Pupangulon Pupadi' tan saray Mangatuntawo tamo. Ipapati ako li' bale' marate' a ikatlon awro ket pasublien nako li' nin mabyay nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sin sain, nikadayo' nayan buga' ni Pedro si Jesus konran raruma tan inima'no naya a wana, “Ser, kai in nin magwa'! Si Dios kai na kumon nin aburuyan a mangyadi' in komo!” ");
INSERT INTO smkNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nibring ya si Jesus nin inadap naya si Pedro tan wana, “Satanas, lumakwan kadti! Makasamben ka kongko ta say iti sa nakem mo ket ambo' nin kumpruntado sa karabayan nan Dios, no kai edet, sa pangingisip nin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ket wana ni Jesus konran tumutumbok na, “Si sayay marabay nin mag'in nin tumutumbok ko, matkap a galten nayna sa kaisipan na a karabayan nan bukod. O' a, matkap nayan balatayen a kudos na nin ipulisay nay lalaman nan diri ket tumbuken nakon pirmi. ");
INSERT INTO smkNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wanin ta si si'numan a say byay nadti tana a mampagawan na, mati ya li' et a lamang, bale' si tawo nin gurutan nay byay nadti bana' sa pammabli na kongko, madumog na a tutuon byay. ");
INSERT INTO smkNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ani wadi' a magun-guna nan sayay tawo no maikon nay intiron kayamanan sa babon luta', bale' si byay na a nibayad na sa sain? Kasa gapo! Kasa gapo nin magwa' nan ipambot nin sayay tawo sa byay a na'met na. ");
INSERT INTO smkNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anaod, sa ambo' nin ma'teng, si'kon si Pinaitawo ket sumubli' ako li' nin main kongko a pakayadi' tan kagalangan nan Ama ko tan kalamo' kosara a uanghil na. No saytaw li' ket tubaleen ko a barang tawo sigon sa ginwa-ginwa' ra. ");
INSERT INTO smkNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ibarita' koyti komoyo a main komoyodti sawanin a sibibyay et li' no si'kon si Pinaitawo ket ipa'deng ko a pag'adian ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Napalabas a a'nem a awro, nitagad nasara ni Jesus nin nuli' sa sayan ata'gay nin talugtog si Pedro tan saray mibsat a Santiago tan Juan. Sara-sara tamo' itaw. ");
INSERT INTO smkNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Itaw, nanguman a bakas na ni Jesus nin nabantayan ra. Sinumlag a rupa na nin pinasyan salag a kapada na nin awro, tan say seket na ket nag'in nin maputi' a makapulag sa puti'. ");
INSERT INTO smkNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kapingmatan ket pinaipadar sara si Moises tan si Elias nin mangkiirgo kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wanan nag'irgo ni Pedro, “Catawan, mabista ta iti atamoyna. No rabay mo, mama'deng akon tulo ray abung-abong iti; saya para komo, saya para kona ni Moises, tan saya para kona ni Elias.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mampag'irgo ya et si Pedro sin bigra' nin nasirungan saran maslag nin gunem tan main nin busis nin nangibwat sa gunem a narnge' ra nin wana, “Siti a Anak ko nin mangkawa-kawa'nanen ko. Sya a pakaririketan kon tuloy. Reng'en moya.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pinasyan li'mo ran tumutumbok sin narnge' rayay busis ket linmukbob sara sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Inmarak ya si Jesus konra. Kinudit nasara tan wana konra, “Mibangon kamo. Andi' kamo nin mali'mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sin kinmikit sara sa libed ra, bukud-bukod nayna ni Jesus a na'kit ran kalamo' radtaw. ");
INSERT INTO smkNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sin mampanaoy sarayna sa talugtog, nibibilin nan mairot konra, “Sayti nin na'kit moyo, andi' moyo gapo nin ibari-barita' abirno nin si'no angga nin si'kon si Pinaitawo ket pinasubli' akoyna nin mabyay.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wanra nin tumutumbok na kona, “Wanra bale' nin Madudunong sa Gugan-gan ket matkap a rumate' ya yapo' si prupita Elias mi'sa sitaw si sayan nipangako' nan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wanan ni'bat ni Jesus, “Page' a rumate' ya yapo' si Elias ta pigaw nin isadya' nay sarba para konan si nipangako' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bale' ibarita' ko sawanin komoyo: Say katutu'wan ket si Elias, rinmate' yaynadti bale' kai raya nin nadlaw nin tutawo ket ginwa' ra kona a sarbaynan kadukaan a rabay ra. Wanin li' anamaet a lamang kongko nin si'kon si Pinaitawo ta padya'dyaen rako li' anamaet.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sin sain ket nataros ran tumutumbok a si Juan a Mammawtismo a rabay nan irgwen ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sin nakarate' sara si Jesus konran abaw nin tutawo, main nin sayay lalakin inmarak kona tan nanalimukod ya sa adapan na, a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Maistro, ka'dwan may anak kon tumububa'yo. Matin-binulan ya ket mangkapaidap yan maong ta no kumaro ya ket kasabyan manabo' ya sa raranom o maira'pog ya sa apoy. ");
INSERT INTO smkNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nipa'kit koya konran tumutumbok mo bale' kai raya nin napaanda'.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wana ni Jesus konra, “Abagay kamoyna! Ambale' a kasan pammemper moyo tan matiko' a pangingisip moyo? Anggan ka'no ako kadi' matkap nin kikalamo' komoyo? Anggan ka'no katamo nin anusan sa pigagawa' moyo? I'ras madti a anak.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ginan-gan naya ni Jesus a ispiriton duka' a tegnan nayaynan paidapen a anak tan lakwanan naya anayti, ket konan sitaw a lamang nin udas inmanda' yay anak. ");
INSERT INTO smkNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kinmadani saray tumutumbok na ni Jesus tan nitepet ran sara-sara tamo' a nakarnge', “Mayin bale' a kai miya nin napalakwan taw si ispirito?” ");
INSERT INTO smkNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","“Bana' ta kurang a pagmamatalek moyo,” ni'bat na ni Jesus. “Ibarita' koyti komoyo a no mag'in tana kumon nin bilang kaalakin bikoy nin mustasa a pagmamatalek moyo konan Dios, maibarita' moyo konan sitin talugtog a umalis ya sa kami'nan na ket umalis yan page'. Kasa gapon kai moyo nin magwa' nin mapangyadi'.” ");
INSERT INTO smkNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sin nadinep saradtaw sa Galilea a tumutumbok wana ni Jesus konra, “Ambo' nin ma'teng, si'kon si Pinaitawo ket maipagamet ako konran mag'uray ");
INSERT INTO smkNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ket patyen rako, bale' sa ikatlo li' nin awro pasublien ako nin mabyay.” Ket ginmereng saran maong a tumutumbok. ");
INSERT INTO smkNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Rinmate' ya si Jesus tan saray tumutumbok na sa Capernaum. Ket nako sara kona ni Pedro a maniningir nin buis para konan Timplo nan Dios. “Siin si maistro moyo, mampamayad ya para nin buis para kona nin Timplo nan Dios?” wanran nitepet kona. ");
INSERT INTO smkNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“O',” wanan ni'bat ni Pedro. Ket sin sinumrep yayna sa bali tinepetan nayan tampor ni Jesus. Wana, “Pedro, ani a iti sa wamo? Saray uadi' iti sa luta', si'noy pamuisen ra, saray a'nak ra o saray sakalakon tawo?” ");
INSERT INTO smkNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wana ni Pedro, “Saray raruman tawo.” “No wanin edet,” wana ni Jesus, “kai sara matkap nin pamayaden a a'nak ra. ");
INSERT INTO smkNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wanin man, ta pigaw nin kasan mairgo ra kontamo, mako ka mamilwit. Sa bebey nan mu'na mon mabilwit ket main nin ma'kit mon platan kwarta. Kalapen ma tan ika' ma nin ibayad sa buis ta nin rwa.” ");
INSERT INTO smkNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sin sain, nitepet ran tumutumbok kona ni Jesus, “Si'noy sangkata'gayan a butang sa Pag'adian nan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nangayab yan sayay anak si Jesus tan pina'deng nayayti sa adapan ran tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Wana konra, “Abas a pangingisip moyo, ket ibarita' koyti komoyo: No kai moyo nin silyan ta pigaw nin mag'in kamon bara'mon konan sayay anak, kai kamo gapo nin makakirama' sa pag'aadi' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Si mamaayupa' sa lalaman nan diri a kapada kaayupa' nin kapapa'sar nan sitin anak, siin a sangkata'gayan sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Si si'numan a mampangilalaman kongko a mangako' konan sayan wantin anak, si'koyna a inako' nan lamang.” ");
INSERT INTO smkNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Maong et konan sayay tawo a katinan yan mabyat nin baton gigilingan sa liey tan irebreb ya sa taaw dyan si mag'in syay puon nin pakasida' nin pagmamatalek na kongko nin saya konran sarayti nin maayupa' a pammemper ra. ");
INSERT INTO smkNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kado' saray tutawo ta abaw iti sa mundo a tukso nin pangibwatan nin masida' a pammemper ra kongko. Kai nin maglat a matukso yay sayay tawo, bale' kado' yaynay tawo nin syay puon nin masida' a pagmamatalek ran tutawo kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ket no si gamet o ayi mo a puon nin masida' a pagmamatalek mo, putulen ma tan itampal ma. Maong anay pukol ka bale' magkamain kan byay a iti konan Dios dyan si kumplito yan page' a lalaman mo bale' maika' ka sa burung-burong nin apoy a kai gapo nin ma'rep. ");
INSERT INTO smkNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No si mata mo anamaet a puon nin masida' a pagmamatalek mo, sukiten ma tan itampal ma. Maong anay saya tamo' a mata mo bale' magkamain kan byay a iti konan Dios dyan si rwa ran page' a mata mo bale' maika' kadtaw nin madusa sa apoy nin impyirno.” ");
INSERT INTO smkNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Ilagen moyon andi' nin kai baga-bagawen a ni saya konran saraytin ua'nak, ta ibarita' ko komoyo, saray uanghil ra ket man'iyadap ran pirmi a maipa'ka' konra konan Ama ko nin itaw sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ani kadi' a gaw'en nan sayay tawon main nin sanyasot saray karniro na ket si saya nabarang ya? Kai nasara kasi nin lakwanan taw saray syam a pulo' tan syam nin mampangan sa rigrig nin purod ta pigaw nin keen naya karapen a nabarang? ");
INSERT INTO smkNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ket ibarita' koyti komoyo a no nadumog nayayti li', mas maririket ya bana' konan siin a sayan napasubli' dyan bana' konran kai nin nabarang nin syam a pulo' tan syam. ");
INSERT INTO smkNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wanin anamaet kona nin Ama tamo nin itaw sa langit, kai na nin rabay a main nin mabarang ni saya man konran saraytin a'nak nin mammemper kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","No magkasalanan ya komo a busat mo sa pammemper, mako ka kona tan kairgwen ma nin si'kamo-si'kamo tamo' maipa'ka' sa kasalanan na. No akuen na a nagkasalanan ya komo, sumubli' sa gindat a pikakalamo' moyon mibsat sa pammemper. ");
INSERT INTO smkNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bale' no kai na nin akuen, mangawit kan saya o rwa ra nin tawo ta pigaw nin matistigusan ray sarban pag'irgwan moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No kai na et nin akuen, ibarita' moy maipa'ka' sa sain sa dupong moyon mammemper ket no kai na et a lamang nin akuen, ibilang maynan sayan duka' nin tawo nin iti sa rikor nin dupong tan sayay maniningir nin buis. ");
INSERT INTO smkNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ket, ibarita' ko komoyo, say aburuyan moyodti sa luta' nin magwa' nin gaw'en, aburuyan nan Dios, tan say kai moyo nin aburuyan iti sa luta' nin magwa' nin gaw'en, kai na aburuyan nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Wanin anaod, no main nin pipagketan ran dawaten nin rwa radti komoyo sa luta', si Ama ko nin itaw sa langit ket ipaga'mor na ");
INSERT INTO smkNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ta no main nin rwa o tulo ra nin nididinep ta mikakalamo' sara bana' kongko, itaw ako sa pisasa'lean ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kaaram, kinmadani ya si Pedro kona ni Jesus tan tinepet na, “Uunuren, mi'no ya nin magkasalanan kongko a kapada kon mammemper tan pirdunawen koya et a lamang? Anggan mipito?” ");
INSERT INTO smkNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ni'bat na ni Jesus, “Ambo' tamo' nin mipito, no kai edet, pipituwen may pitumpulo' ");
INSERT INTO smkNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ta say pag'aadi' nan Dios ket maipada konan sayay adi' a nidisisyon nay kikwintawan konran upisyalis na. ");
INSERT INTO smkNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kapresan nan mangkikwintawan konran upisyalis na sin main nin nirate' ra kona nin sayay upisyal na nin nangibulsan milyu-milyon nin pisos a kwarta nan adi'. ");
INSERT INTO smkNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kai nayti nin maisubli' kanya' nin nigan-gan nan adi' a ilako' ya bilang aripen, tan si asawa na, tan saray a'nak na, tan sarba nin kayadian na ta pigaw nin maisubli' na. ");
INSERT INTO smkNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Linmukob yay upisyal sa adapan nan adi' tan nipainganga'do na nin wana, ‘Anusan rako kadi' ta ipamuspusan kon maisubli' li' nga'min.’ ");
INSERT INTO smkNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ininganga'do naya nin adi' tan kai nayna nin nipasubli' ket binulusan nayayna. ");
INSERT INTO smkNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nibwat yaynay upisyal ket nakasna' yan sayay upisyal na anamaet lamang nin adi' a main nin daite' nin utang kona. Nipukpok naya mi'sa naya nin binikkel tan wana kona, ‘Bayadan moy utang mo!’ ");
INSERT INTO smkNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tinmalimukod ya sa adapan na a kapada nan upisyal tan dinawat na kona, ‘Anusan nako kadi' ta ipamuspusan kon maisubli'.’ ");
INSERT INTO smkNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bale' kai nayayti nin kina'dwan tan nipapriso naya leg'an nin kai na nin mabayadan a utang na. ");
INSERT INTO smkNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sin na'kit ran raruman upisyalis a ginwa' na, pinasyan sakit nin nakem ra ket nako sara konan adi' tan nibarita' ra kona a sarba nin nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nipakayaban nayan adi' taw si upisyal tan wana kona, ‘Si'kaynay maraet! Nikidawat kan inganga'do ket pinirduna kata sa intiron utang mo. ");
INSERT INTO smkNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sawanin, mayin ta kai ma nin kina'dwan a kapada mon upisyal bilang nin si'ko ket ininganga'do kata?’ ");
INSERT INTO smkNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pinasyan sager nan adi' ket nipadusa naya ta pigaw nin isubli' na a sarban kinalap na.” ");
INSERT INTO smkNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Wana ni Jesus, “Wanin anamaet a gaw'en na nin Ama ko nin itaw sa langit sa si'numan komoyo a kai nin makapamirduna nin liso konan kapada nan tawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sin nayadi' nayna nin nibarita' in nin uakay ni Jesus, linmakwan yayna sa Galilea tan nako ya sa lugar a sakop nan Judea nin itaw sa rubari' nin rigrig nan Ilog Jordan. ");
INSERT INTO smkNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pinasyan ka'bawan ran tutawon tinmumbok kona ket pinaanda' nasaray main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Main nin Pariseo nin nako kona ni Jesus. Mampangkit saran puon nin pamarsawan ra kona kanya' nin wanra nin nitepet kona, “Iyaburoy para nin Gugan-gan tamo a isyay nayan sayay lalaki a asawa na sa basta bungat anan nangibwatan?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ni'bat na konra, “Kai moyo para nin nabasa-basa sa Masanton Kasuratan a sin saytaw sin pinarsa a sarba, si Namarsa, pinarsa nay tawo nin lalaki tan babayi, ");
INSERT INTO smkNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ket bana' konan siti nin ginwa' na, si sayay lalaki, lakwanan nasara si ama na tan si ina na ta kipasaya ya konan asawa na ket saran rwa, mag'in saran sayan-saya? ");
INSERT INTO smkNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kanya' nin saray mitraasawa ket ambo' saraynan rwa no kai edet, sayan-saya saraynan lalaman. Edet, bana' ta wanin, saray rwa a pinipasaya nan Dios, ambo' nin manepeg a pisyayen saran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wanra et nin Pariseo, “No wanin a page', ambale' edet a si Moises, nigan-gan na a matkap nayan byan nin kasuratan nin pisyayan ra no rabay nayan isyay nin sayay lalaki a asawa na?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ket ni'bat na ni Jesus, “Si Moises, bana' sa tib'ey nin ulo moyo, inaburuyan na nin magwa' moyo saran isyay a asawa moyo. Bale' sin tarana', sin pinarsa a sarba, kai nin nigagaran wanin. ");
INSERT INTO smkNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kanya' nin si'ko, ibarita' ko komoyo, si lalaki nin mangisyay konan asawa na nin si rason ket ambo' nin bana' ta nikilalaki yay asawa na, mi'sa ya nin kikalamo' sa sakalako, konan siin mampamabayi ya.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanra nin tumutumbok kona ni Jesus, “No wanin a kapapa'sar nin sumrep sa istado, maong anay andi' nin sumrep.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bale' ni'bat na ni Jesus, “Kai magwa' nin sarban tawo a kikumpurmi konan siin, no kai sara tamo' a tulungan nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nagsikabarang a rason no ambale' a main nin kai nin sumrep sa byay a main nin asawa. Main nin bana' ta main nin dipirinsya ran nikiyanak ra; main anamaet nin bana' ta kapon sara; tan main et nin kai nin sumrep sa byay a main nin asawa ta pigaw nin makatulok saran liso sa nigan-gan nan Dios maipa'ka' sa pag'aadi' na. Si tawon makaako' konan siti nin akay, akuen na.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Main nin tutawon nangi'ras nin ua'nak kona ni Jesus ta pigaw nin ipababo nay gamet na sa ulo ran sarayti tan idasalan nasara nin bindisyunan nasara. Bale' saray tumutumbok na, inima'no rasara. ");
INSERT INTO smkNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bale' wana ni Jesus konran tumutumbok na, “Pauryan moyo saran umarak kongko a ua'nak. Andi' moyo sara nin ima'nwen, ta si tawon say kanakman na ket kapada nin saraytin ua'nak, aburuyan nayan Dios nin kipag'adi' kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ket nipababo nay gamet na sa ulo ran ua'nak nin pammindisyon na konra. Sin nayadi', linmakwan yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ni'sa, main nin lalaki nin nako kona ni Jesus. “Maistro,” wana, “ani a maong nin gaw'en ko ta pigaw nin maga'muran koy anggan-angga nin byay a iti konan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wana nin ni'bat ni Jesus, “Ambale' a tepeten mo kongko no ani a maong, ta kasan sakalako no kai si Dios tamo' a maong. Bale' say maipa'ka' sa byay a iti konan Dios, no rabay mon maga'muran, tukiden moy Gugan-gan nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Aya nin gugan-gan?” nitepet nan lalaki. Ni'bat na ni Jesus, “Andi' ka nin mangmati. Andi' ka nin mamabayi o kilalaki. Andi' ka nin manakaw. Andi' ka nin magtistigos nin ambo' nin tutuo. ");
INSERT INTO smkNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Igalang mosara si ama mo tan si ina mo. Aduen moy kapada mon tawo nin kapada nin pangangado' mo sa lalaman mon diri.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wana nin sitin lalakin iti et sa kalagu'-laguan na, “Sarban sain, mantukiden koyna. Ani et a pagkurangan ko?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wana ni Jesus kona, “No rabay mon liso kan maikana' nin makaga'mor nin kasan anggawan a byay, mako kayna tan ilako' mo a main mo tan say naglakuan, ibi mo konran pubri, ket magkamain kan kayamanan itaw sa langit. Kayadi' mon gaw'en ti, sumubli' kadti kongko tan mag'in kan tumutumbok ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sin narnge' nan lalaki in nin nibarita' na ni Jesus nibwat ya nin pinasyan bereng. Mainan yan tuloy ket! ");
INSERT INTO smkNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wana ni Jesus konran tumutumbok na, “Ibarita' koyti komoyo! Pinasyan idap ran ipaisirong nin mumayaman a lalaman ran diri sa pag'uuray nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ibarita' koynaet komoyo, mas mainum'ay ya et nin lumbot a kamilyo sa ubot nin kadayem dyan si sayan mayaman ket makakibiang ya sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanin anay nipaka'ngap ran tumutumbok na sin narnge' ra in nin wana maipa'ka' konran mayaman, ket wanra kona, “Ya! Si'no edet no wanin a maisalba?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pinastang nasaran maong ni Jesus mi'sa wana konra, “Peteg a impusiblin makaga'mor nin kasan anggawan nin byay a tutawo, bale' say sarban bagay ket magwa' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nag'irgo ya si Pedro a wana, “Ket si'kami pa edet, pinauryan mi anay sarba ta pigaw nin nikikalamo' kami komo. Ani li' a gun-guna mi?” ");
INSERT INTO smkNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“O' a, ta ibarita' koyti komoyo: Rumate' li' a awro a si Dios ket paba'yuwen nayayti nin mundo, tan si'kon si Pinaitawo, tumekre' ako li' sa truno ko ta pigaw nin mag'uray akon makapangyayadi'. Ket no saytaw li', si'kamon nikikalamo' kongko, tumekre' kamo li' anamaet sa labinrwa nin truno ket kipag'uray kamo li' konran labinrway grupo ran puri na ni Israel. ");
INSERT INTO smkNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Si si'numan a manglakwan nin pammali na, bubsat na, ama na, ina na, a'nak na, o binis na bana' kongko, magun-gunawan ya li' nin misanyasot nin ka'baw dyan say linakwanan na tan mabyan ya et a lamang li' nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bale' konan sitaw li' nin awro, main konran iti anan nu'na a maikayupa' li', tan main konran masusuyot a u'nawen li'.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ket,” wana ni Jesus, “say pag'aadi' nan Dios, maiyarig sa wanti: Main nin sayay lalakin main nin alawang a luta' na nin uubas. Sayay awron masakbay et, nako yayna naningkap nin tutawon upaan nan magtrabahodtaw sa uubas na. ");
INSERT INTO smkNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Konran nu'nan na'kit na, nikitarusan yan upaan nasara nin say kuston upa' nin sayay awro. Mi'sa nibaki' nasarayna nin magtrabaho. ");
INSERT INTO smkNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sin mag'alas nwibi nin buklas, nako ya anamanaet naningkap nin upaan nan tutawo. Ket naka'kit yadtaw sa palingki nin kasan man-gaw'en ra no kai man'umdeng tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wana konra, ‘Mako kamo anamaet nin magtrabaho sa uubas ko tan upaan katamon manepeg.’ ");
INSERT INTO smkNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ket nako sara nagtrabaho. Wanin anamaet a lamang a ginwa' na sin ugtiawro ana tan sin mag'alas tres. ");
INSERT INTO smkNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Alas singkoyna sin nako yaynamanaet sa palingki naningkap nin trabahador. Naka'kit yadtaw et a lamang nin tutawon kasan man-gaw'en ra. Wana konra, ‘Ambale' a iti kamo tamo' nin mampamirdin udas moyo?’ ");
INSERT INTO smkNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘O' a ta kasa anamaet nin mangalap komi nin magtrabaho,’ ni'bat ra kona. ‘Mako kamo anamaet nin magtrabaho sa uubas ko,’ wana konra. ");
INSERT INTO smkNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sin patpaapon ana wanan main nin plantasyon konan mampyawen nan tawo na, ‘Kayaban mosaray mampagtrabaho sa uubas ko tan ibi moy upa' ra. Upaan mosaran mangibwat konran suyot nin tinmarana' angga konran nu'nan tinmarana'.’ ");
INSERT INTO smkNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ket inupaan nasaran upa' nin sayay awroytaw saray tinmarana' nin nagtrabaho sin alas singko. ");
INSERT INTO smkNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kanya' nin sin adap ra nin risibyen a upa' ran saraytaw saray sangkau'nawan nin nagtrabaho, nipa'ka' ra nin mas abaw a upa' ra. Bale' upa' nin sayay awro anamaet a lamang a niyupa' konra. ");
INSERT INTO smkNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bere-bere saran nangrisibi nin upa' ra ket kuntra sara konan namagtrabaho konra ");
INSERT INTO smkNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a wanra, ‘Sarain saray suyot nin tinmarana', sayay udas ra tamo' nin nagtrabaho, ket si'kami nikakaawro kamin nagawgaw nin nagtrabaho. Ambale' nin pari-parihoy upa' mi ey?’ ");
INSERT INTO smkNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ket wanan namagtrabaho konra, ‘Amigo, kai taka nin sinaor. Nag'irgwan tamon upa' sa sayay awro a iyupa' ko komoyo ket siin a nibi ko komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kalapen moy manepeg nin upa' mo tan mako kayna. Karabayan kon upaan saran kapada sa upa' mo a suyot nin nagtrabaho. ");
INSERT INTO smkNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Magwa' kon gaw'en a rabay ko sa kayadian ko. Mairod ka para bana' ta mapamami ako?’ ");
INSERT INTO smkNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Konan siti anaod, man'ibarita' ko a main li' konran saray masusuyot a u'na li' sa kaalagawan, tan main li' konran saray iti anan nu'na a maikayupa' li'.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sawanin, sin tumangkar sara si Jesus tan saray tumutumbok na nin adap sa syudad nin Jerusalem, nipurok nasaray labinrwan tumutumbok na. Sin kapresan ran manlumalako, main nin nibarita' na konra nin sara-sara tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mangrenge' kamo. Adap tamoyna sawanin sa Jerusalem. Ket itaw, si'kon si Pinaitawo, maipagamet ako konran Pupangulon Pupadi' tan konran Madudunong sa Gugan-gan tamo. Sintinsyawan rako nin mati, ");
INSERT INTO smkNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mi'sa ipagamet rako konran ambo' nin Judio, ket tuya'-tuyaen rako, sanet-saneten rako tan ipasak rako sa kudos. Bale' marate' a ikatlon awro, pasublien nakon mabyay nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kinmadani ya kona ni Jesus a asawa na ni Zebedeo nin kalamo' nasaray rwan a'nak na. Nanalimukod ya sa adapan na ta main nin dawaten na kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Ani a rabay mo?” nitepet na ni Jesus kona. Ni'bat na, “No si'kayna li' a adi', patekreen mosara li' kumon sa dani moyti saray rway a'nak ko nin tumutumbok mo, saya sa pawanan mo tan saya sa pawiri mo?” ");
INSERT INTO smkNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ket wana ni Jesus konran mibsat, “Kai moyo nin tanda' no ansain say mandawaten moyo. Maako' moyo paran irangep a dya'dya' nin adapen ko nin irangep?” “O', maako' mi,” wanran ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Tutuo,” wana ni Jesus, “mangirangep kamon dya'dya' nin bilang sa dya'dya' a irangep ko. Bale' no si'noy tumekre' sa pawanan tan sa pawiri ko, ambo' nin iti sa gamet ko. Naigagara ana in nin lugar konran napili' nan Ama ko nin pangisadyaan.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ket sin narnge' ran mapulo' nin raruma et nin tumutumbok a maipa'ka' sa sayti, masager sara konran mibsat. ");
INSERT INTO smkNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanya' nin pinakadani nasara nga'min ni Jesus kona tan wana konra, “Tanda' moyon peteg no pa'noy pag'uuray ran mag'uuray iti sa mundo. Aripenen rasaray iti sa sakop ra tan saray iti sa ta'gay ket masakit-sakit sara konran saray iti sa sirong nin uray ra. ");
INSERT INTO smkNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bale' komoyo, matkap a ambo' nin wanin. Komoyo, si si'numan a marabay nin mag'in nin ata'gay, matkap a syay magsirbi konran raruma, ");
INSERT INTO smkNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","tan si si'numan komoyo a marabay nin mag'in syay ulo, matkap a magwa' nay mag'in nin aripen moyo ");
INSERT INTO smkNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kapada kongko nin si'kon si Pinaitawo. Nako akodti sa luta' ambo' ta pigaw nin pasirbi ako no kai edet, ta pigaw nin magsirbi ako tan ta pigaw nin ibi koy byay ko nin ipambot konran abaw a tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sin mampibwat sarayna sa syudad nin Jerico, abaw saray nikialuyon konra ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sa dalanan ra ket main nin rwa ray lalakin bulag nin nakatekre' sa rigrig. Sin natandaan ra nin manlumabas ya si Jesus wanra nin nita'way, “Ser, si'kan nipangako' a puri na ni David, ka'dwan nakami kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Masager saray tutawo konra tan inima'no rasaran gumargar. Bale' mas maksaw rayna edet nin nita'way, “Si'kan nipangako' a puri na ni David, ka'dwan nakami kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tinumgen ya si Jesus ket tinawag nasara. Nitepet na konra, “Ani a rabay moyon gaw'en ko para komoyo?” ");
INSERT INTO smkNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ket ni'bat ra, “Uunuren ko, rabay mi kumon a maka'kit.” ");
INSERT INTO smkNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nanabo' a inganga'do na ni Jesus konra. Inapros nay mata ra ket tampor a maka'kit sarayna, tan nikikalamo' sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ket adani sarayna si Jesus sa syudad nin Jerusalem ta itaw sarayna sa bandan baryon Betfage nin adani sa Talugtog Olibo. Ket pinau'na nasaray rwa konran tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a wana konra, “Mako kamo sa baryo a man'adapen moyo. Ket karate' moyodtaw main nin tampor nin ma'kit moyon naipuged nin asno a kalamo' nayay uybon na. Usbagen moya sara sa nakaipugedan na tan i'ras moyo saradti kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No main nin manita komoyo sa man-gaw'en moyo, ibarita' moyo kona, ‘Matkap nasarayti nin Uunuren,’ ket tampor a umaburoy yan kalapen moyo sara.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sain, nangyadi' ta pigaw nin matukid a nipaibarita' naynan na'teng nin Dios konan prupita a wana, ");
INSERT INTO smkNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ibarita' moyo konran taga Sion, ‘Syayna e a adi' moyo! Maayupa' a nakem na, ket sya manrumate' yan rinmuran tamo' sa ayep nin ipammaguroy, sayay uybon nin asno.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ket nako saraynay nibaki' tan ginwa' ray nipagwa' na ni Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ni'ras raya konay asno tan si uybon na. Nisapin ray kapa ra konra ket rinmuran ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Abaw sara konran tutawodtaw a bana' sa alakin pangigalang ra kona ni Jesus ket, niyapra-aprak ray kukapa ra sa dalanan na, tan saray raruma ket nampi-nampi' saran susangan kukayo tan niyapra-aprak ra anamaet a lamang sa dalanan na. ");
INSERT INTO smkNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pinasyan ka'bawan ran tutawo, saray raruma iti sara sa u'na na ni Jesus tan sakalako saray mantumumbok kona. Wanra nin nita'wa-ta'way, “Marayo yay si puri na ni Adi' David! Nabindisyunan nayan Dios a nibaki' na nin manrumate' anadti sawanin kontamo! Marayo yay Dios itaw sa langit!” ");
INSERT INTO smkNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sin rinmate' yadtaw si Jesus sa Jerusalem, sabtan nipaka'ngap ra nga'min nin tutawodtaw. Pittepet ra, “Si'no ya in?” ");
INSERT INTO smkNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Sya si Jesus a sayay prupita nin taga Nazaret itaw sa Galilea,” wanran ni'bat nin saray abaw nin tutawon nikialuyon kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nako ya nin linmuob sa sakop nan Timplo nan Dios si Jesus bale' itaw narat'anan nasaray mampaglako'. Ket pinala-palakwan nasara tan saray mampanaliw itaw nin say bubagay a ida'ton konan Dios tan tinali-talimbwag nay lulamisawan ran maninilin kwarta tan say tutekrean ran maglalako' nin kalapati. ");
INSERT INTO smkNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wana konra, “Kai para naisurat a wana nin Dios, ‘Si Bali ko, ket pangaranan raya nin lugar nin dadasalan.’ Bale' si'kamo,” wana ni Jesus konra, “man-gaw'en moyan pididinepan ran mannakaw!” ");
INSERT INTO smkNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nako saradtaw kona ni Jesus sa sakop nan Timplo nan Dios a bulag tan saray pilay ket pinaanda' nasara. ");
INSERT INTO smkNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Saray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan, masager saran tuloy kona ni Jesus sin na'kit ray mumilagro nin ginwa' na tan sin narnge' ray wanran ua'nak itaw nin nita'wa-ta'way, “Raywen tamoya si puri na ni Adi' David!” ");
INSERT INTO smkNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kanya' nin wanra kona, “Mangkarnge' mo in para say man'ita'wa-ta'way ran ua'nak?” “O', mangkarnge' ko,” wanan ni'bat ni Jesus. “Kai moyo para nin nabasa-basayti nin wana sa Masanton Kasuratan? Wana, ‘Si Dios, niyakay nasaray ua'nak tan mataman nin saray uabing nin mangrayo nin tutuo kona.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mi'sa linakwanan nasara ni Jesus. Nibwat ya sa syudad tan nako ya sa Betania tan itaw ya nin na'lek konan sitaw a yabi. ");
INSERT INTO smkNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kinabuklasan, sin mansumubli' yayna si Jesus sa Jerusalem, ginmitil ya. ");
INSERT INTO smkNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sa rigrig nin dalan ket naka'kit yan kayon igos. Nako yadtaw sa kami'nan na bale' kasa gapo nin ma'kit nan bunga na no kai kal-la bulong tamo', kanya' nin wana konan kayo, “Anggan maka'numan kai kayna gapo nin gumunga.” Ambo' nin na'teng, nalanes yay kayo. ");
INSERT INTO smkNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naka'ngap saray tumutumbok sin na'kit ra a nangyadi' konan kayo. Wanra, “Pa'non nangyadi' a nalanes yan bigra' ti si kayo?” ");
INSERT INTO smkNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wanan ni'bat ni Jesus konra, “Ibarita' koyti komoyo a no magmatalek kamo konan Dios tan kai kamo gapo nin magdwadwa, magwa' moyo anamaet a ginwa' ko konan sitin kayo. Ambo' tamo' in. Magwa' moyo et nin ibarita' konan sitin talugtog, ‘Gumlat kadsen tan mako ka sa taaw,’ ket mangyadi' a wamoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Anaod, animan a dawaten moyo konan Dios, no magmatalek kamo nin ibi na, gaw'en na.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nako ya anamanaet itaw sa sakop nan Timplo nan Dios si Jesus tan nangyakay ya konran tutawo. Sin kapresan nay mampangyakay, kinmadani sara kona a Pupangulon Pupadi' tan saray Mangatuntawo tan nitepet ra kona, “Ani a kanepegan mon mangwa' nin sain say man-gaw'en mo? Si'noy nami komo nin pakayadi' nin gaw'en mo in?” ");
INSERT INTO smkNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ni'bat na ni Jesus, “Ibarita' ko komoyo no ani a pakayadi' ko nin gumwa' nin saytin bubagay no ubatan moyayti si tepet ko. ");
INSERT INTO smkNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Si'noy namin kanepegan nan mamawtismo ni Juan, si Dios para o say tawo?” Nag'iirgo sara nin wanra, “Ani kadi' a i'bat tamo? No ibarita' tamon ‘si Dios’, ibarita' na kontamo, ‘Mayin edet a kai moya nin timper si Juan?’ ");
INSERT INTO smkNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ket no ibarita' tamo anamaet, ‘Say tawo,’ makapali'mo ta bangli' no ani a gaw'en ran tutawo bana' ta tepren ran saya yan prupita si Juan.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanya' nin ni'bat ra kona ni Jesus, “Kai mi nin tanda'.” Ket wana anamaet konra, “No wanin, kai koynamaet nin ibarita' komoyo no ani a kanepegan kon mangwa' nin man-gaw'en ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wana ni Jesus konra, “Ani a maibarita' moyo konan siti e? Main nin sayay ama nin main nin rwa ray a'nak na. Nako ya konan saya tan wana kona, ‘Andoy, mako ka nin magtrabaho sa gagawa' konan sitin awro.’ ");
INSERT INTO smkNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","‘O', Tatay,’ wanan ni'bat nin anak, bale' kai yan lamang nin nako. Nako ya anamaet a ama konan ikarwa tan nibarita' naytaw nin lamang say nibarita' na konan saya. ‘Andyak,’ wanan ni'bat, bale' nainsanan nin buga', nakapanemtem ya ket nako yan lamang. ");
INSERT INTO smkNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sawanin, si'no ey a tinmulok sa karabayan nan ama ra?” nitepet na ni Jesus. Ni'bat ra kona, “Sitaw si nako nin lamang.” Ket wana ni Jesus konra, “Ibarita' koyti komoyo a saray duka' a tutawo a bilang saray maniningir nin buis tan saray duka' a bubbayi, u'nawen nasaran pag'urayan nin Dios dyan si'kamo, ");
INSERT INTO smkNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ta nako yadti si Juan a Mammawtismo tan niyakay na komoyo a mapteg nin dalan nin pagkabyay ket kai moya nin timper. Sara bale' a maniningir nin buis tan saray duka' a bubbayi, timper raya. Si'kamo anamaet bale', mataman nin tanda' moyo nin nangyadi' in, kai kamo et nin nanguman tan namper kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Reng'en moyayti et nin pangingiyarig. Main nin sayay tawon nangmula nin ubas sa luta' na. Dinarekdek naya, tan nangali yan ubot sa sayay alakin bato ta pigaw nin pamespesan yan ubas. Nama'deng yan ata'gay a kami'nan ran bantay. Mi'sa nipagamet nay pangangalila' sa mula na konran umno ray padalos tan nibwat yan nako sa sayay adayo' nin lugar. ");
INSERT INTO smkNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sin narate' anay panaon nin pammutin bunga, nangibaki' yan tutawo na nin kalapen ray tao na. ");
INSERT INTO smkNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bale' saray padalos, dinakep rasara, ket tinasu-taso rayay saya, pinati rayay saya tan kinudas-kudas raya nin bato a saya et. ");
INSERT INTO smkNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nangibaki' ya anamanaet nin tutawo na a main ikon tan sawanin ket abaw sara dyan saray nu'na. Bale' saray padalos wantaw nin lamang a ginwa' ra konran saraytaw saray nu'na. ");
INSERT INTO smkNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sin kalansuyutan, si anak nayna a nibaki' na. Wana sa nakem na, ‘Kai magwa' a kai raya nin kabilangan a anak ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bale' saray padalos, sin na'kit rayay anak na, wanra, ‘Siti li' a manawir. Patyen tamoya ta pigaw nin maikon tamo a tawiren na li'!’ ");
INSERT INTO smkNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ket dinakep raya, nirikor raya sa darekdek tan pinati raya. ");
INSERT INTO smkNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sawanin, no rumate' yaynay main nin luta', ani kadi' a gaw'en na konran saraytin padalos?” tepet na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wanra nin inumbat, “Kasan sapon patyen nasara in a duka' nin tutawo, tan si luta' na ipaga'getan naya sa sakalakon padalos nin mamin tao na tepe' nin pammutin bunga.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wana ni Jesus, “Kai moyo para gapo nin nabasa-basa a wana sa Masanton Kasuratan? Wana, ‘Sitaw si bato a nibilang ran kai mausar nin saray mammanday, sitaw nin diri nin bato a nag'in nin sangkaimpurtantiwan sa pamma'deng. Say nipag'in nin wanin ket gawa' nan Catawan. Ket sa pangingikit tamo peteg a makapaka'ngap!’ ");
INSERT INTO smkNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ket ibarita' ko komoyo a bana' ta wanin, ambo' anan si'kamon Judio a Pag'adian nan Dios no kai edet, saray tutawon sumunor sa karabayan na. ");
INSERT INTO smkNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Konan siin nin bato, si si'numan a manabo', mangababari' ya tan si si'numan a madag'anan nan siin a bato, marekrek ya.” ");
INSERT INTO smkNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Narnge' ran Pupangulon Pupadi' tan Pariseo in nin pangingiyarig na ni Jesus ket nataros ran sara a mampada'gisan na. ");
INSERT INTO smkNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kanya' nin dakpen rayayna kumon si Jesus bale' mali'mo sara konran tutawo ta tepren ran sarayti a saya yan prupita si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nami ya anamanaet konra nin sayay pangingiyarig si Jesus. Wana, ");
INSERT INTO smkNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Say pag'aadi' nan Dios ket maiyarig sa nangyadi' iti konan sitin isturya. Main nin sayay adi' a nanadya' ya para sa alakin punsya ta ikasal yay anak nan lalaki. ");
INSERT INTO smkNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nibaki' nasaray aripen na nin keen rasara kayaban taw saray tutawon sinagyat naynan gindat, bale' saraytin sinagyat na ket kai ra rabay a mako. ");
INSERT INTO smkNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ket nangibaki' ya anamanaet nin raruman aripen na a wana konra, ‘Ibarita' moyo konran saraytaw saray sinagyat ko a narate' anay bansal. Napati saraynay baka tan saray raruma et nin sinunson nin uayep tan nakasadya' anay sarba. “Tamoyna sa bansal,” wamoyo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bale' saraytin tutawon sinagyat kai sara nin nangasikaso. Nituloy ra no ani a man-gaw'en ra. Main nin sayan nako sa gagawa' na, tan main anamaet nin sayan nako sa kumirsyo na. ");
INSERT INTO smkNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Saray raruma bale', dinakep rasaray raruma konran aripen, tinuya'-tuya' rasara mi'sa rasara nin pinati. ");
INSERT INTO smkNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Say sager nan adi'! Nibaki' nasaray susundalo' na nin patyen rasaraytaw saray nangmati konran aripen na tan puuran rayay syudad ra. ");
INSERT INTO smkNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kaaram, dininep nasara nin adi' a uaripen na tan wana konra, ‘Nakasadya' anay sarba para sa bansal bale' saray tutawon sinagyat ko, kai sara maikana' nin sinagyat konan sitin bansal. ");
INSERT INTO smkNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kanya' nin mako kamo sa dudalan tan sagyaten moyo sara nga'min a tutawon ma'kit moyo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ket nako saray aripen sa dudalan tan sinagyat rasara nga'min a tutawon na'kit ra, maong man o duka' a tutawo. Ket napno' yan bisita a luob nan palasyo nan adi'. ");
INSERT INTO smkNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nako yay adi' sa kami'nan ran bisita nin kikiten nasara. Main nin sayan na'kit nan kai nin nisket nin seket kibansal. ");
INSERT INTO smkNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ket wana kona, ‘Amigo, kai ka nin nisket nin seket kibansal. Pa'no nin nikasrep mo?’ Ket si tawo kai ya nin naka'bat. ");
INSERT INTO smkNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanya' nin wanan adi' konran katulong na, ‘Baruren moyoy ayi tan gamet na tan itampal moyadtaw sa rikor nin pinasyan dedlem; itaw ket main nin umasisit tan umagrem tan ngumaretenget a ngipen ra bana' sa pakapaidap tan bereng.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wanan nilamo' ni Jesus, “Page' a abaw saray sinagyat nan Dios, bale' daikleng saray napili' nan makasrep sa Pag'adian na.” ");
INSERT INTO smkNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nibwat saray Pariseo tan niplano ra no pa'no rayan makal'ot si Jesus sa pag'iirgo na. ");
INSERT INTO smkNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Say ginwa' ra, nibaki' rasara kona ni Jesus a umno ra konran tumutumbok ra nin kalamo' rasaray umno ran tawon ayon kona ni Adi' Herodes. Mikuntra saraytin pulitiko ket wanra kona ni Jesus, “Maistro, tanda' mi nin matunong kan tawo. Say pangangakay mo nin no ani a rabay nan Dios nin gaw'en ran tutawo ket tutuo, tan kasan tawon ikali'mo mo ta mampari-parihwen moy tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ket, rabay miyaytin tepeten komo: Maitukoy para, o kai, sa Gugan-gan tamo no mamayad atamon buis konan Impirador nan Roma?” ");
INSERT INTO smkNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bale' tanda' na ni Jesus nin duka' a gagara ra, kanya' nin wana konra, “Si'kamon miwadi'-wadi'! Mayin ta mansubuken rako? ");
INSERT INTO smkNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipa'kit moya in pa kongko si platan ipamuis!” Ket ni'ras raya kona. ");
INSERT INTO smkNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Si'no ya in rupa tan ngaran si isen konan plata?” nitepet ni Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Si Impirador nan Roma,” ni'bat ra. “No wanin edet,” wana ni Jesus konra, “isubli' moyo konan Impirador a ikon na, tan isubli' moyo anamaet konan Dios a ikon na.” ");
INSERT INTO smkNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naka'ngap sara sa wantin ni'bat na ket nibwat sara. ");
INSERT INTO smkNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Konan sitaw a lamang nin awro, main nin Saduseo nin nako kona ni Jesus ta tepetan raya. Sarayti saray Saduseo ket kai ra nin tepren a mapasubli' sara li' nin mabyay a nunati ana. ");
INSERT INTO smkNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maistro,” wanra kona, “niyakay na ni Moises sa nisurat na a no main nin mitraasawa ket nati yay lalaki nin kasan anak ra, manepeg a si busat na nin lalaki ket ikasal nayay babayin nabalo ta pigaw nin manganak saran ikwintan anak nan sitaw si nati. ");
INSERT INTO smkNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sawanin, main intaw nin pito ray mibubsat nin lulalaki. Nangasawa yay kaka bale' nati ya nin kasan anak. Ket si aryen na nikasal nayay babayi, ");
INSERT INTO smkNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","bale' nati yayti anamaet a lamang nin kasan anak ra. Wanin anamaet a ginwa' ran raruma, si ikatlo anggan si ikapito, bale' pari-parihon lamang a nangyadi' konra, nati saran kasan anak. ");
INSERT INTO smkNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kalansuyutan, si babayi anamaet a nati. ");
INSERT INTO smkNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ket sawanin, no napasubli' sarayna li' nin mabyay a nunati, si'no edet li' konra a main nin asawa kona ey, ta saray pito ket nag'in nin asawa raya?” ");
INSERT INTO smkNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Wanan ni'bat konra ni Jesus, “Mangkalingo kamo! Pa'no ket kai moyo nin mangkataros a wana sa Kasuratan o say maipa'ka' sa pakayadi' nan Dios! ");
INSERT INTO smkNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Anaod, no napasubli' sarayna li' nin mabyay a nunati, bara'mo sarayna li' nin uanghil itaw sa langit a kai sarayna nin mangalamo' o kikalamo'. ");
INSERT INTO smkNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ket say maipa'ka' sa katutu'wan nin isusubli' nin mabyay, kai moyo para nin nabasa-basaytin wana nin Dios komoyo sa Masanton Kasuratan maipa'ka' konran pupuon moyo? ");
INSERT INTO smkNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Wana, ‘Si'ko et a lamang a Dios na ni Abraham, si Dios na ni Isaac, tan si Dios na ni Jacob.’ Syimpri a, si sayay nati ana, kai yayna nin makapangrayo konan sayay dios. Kanya' nin mangkabyay sara in et saray nibarita' nan Dios a syay Dios ra.” ");
INSERT INTO smkNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pinasyan nipaka'ngap ran tutawon nakarnge' sa wantaw a wana ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saray Pariseo, sin natandaan ran kasan nagwaan ran Saduseo kona ni Jesus, nag'iirgo sara anamanaet. ");
INSERT INTO smkNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ket saya konra nin abugado sa Gugan-gan a nako nin nanepet kona ni Jesus ta pigaw nin usisaen naya. ");
INSERT INTO smkNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wana, “Maistro, sa sarban Gugan-gan a nisurat nin nibi na ni Moises, ani ya a sangkaimpurtantiwan nin matkap nin tukiden?” ");
INSERT INTO smkNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ni'bat na ni Jesus, “ ‘Aduen may Uunuren a si Dios mo nin intiron kanakman mo, nin intiron byay mo, tan nin intiron kaisipan mo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Siin a sangkaimpurtantiwan tan sangkau'nawan nin matkap nin tukiden a gan-gan. ");
INSERT INTO smkNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Main et nin saya nin kapada nan lamang nin siin. Wana, ‘Aduen moy kapada mon tawo nin kapada nin pangangado' mo sa lalaman mon diri.’ ");
INSERT INTO smkNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sa saytin gugan-gan, naipatukdo' a intiron Gugan-gan a nisurat na ni Moises tan say uakay ran prupita.” ");
INSERT INTO smkNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sin nadinep sara et a Pariseo, wanan nitepet ni Jesus konra, ");
INSERT INTO smkNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ani a iti sa wamoyo maipa'ka' konan Cristo? Si'no ya nin puri?” “Puri naya ni Adi' David,” wanran ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Ket no wanin, mayin edet a ‘Uunuren’ a nipanawag na ni David kona sa nipaninreg nan Ispirito nan Dios? Sayti a wana ni David, ");
INSERT INTO smkNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wanan Dios konan Uunuren ko: “Tumekre' kadti sa pawanan ko mintras nin mampasukuen kosara komo a sarba ran kukalaban mo.” ’ ");
INSERT INTO smkNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Si Adi' David a mismo, tinawag naya nin Uunuren a Cristo nin nipangako' kona, ket pa'no edet a sya ket puri naya ey?” ");
INSERT INTO smkNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ket kasa gapo nin naka'bat kona ni Jesus. Edet, nangibwat ana sin sain, kasayna gapo nin nakatpel nin nanepet-tepet kona. ");
INSERT INTO smkNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wana ni Jesus konran tutawo tan konran tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Peteg a saray Madudunong sa Gugan-gan tan saray Pariseo a namyan nin pakauray na ni Moises nin mangipapalaway nin Gugan-gan na. ");
INSERT INTO smkNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kanya' nin matkap nin gaw'en moyoy sarba nin ibarita' ra tan tumbuken moyoy uakay ra. Bale' andi' moyo nin arigen a gawa' ra ta ambo' nin kumpruntado sa man'iyakay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pinasyan ka'bawan nin ipatukid ra konran tutawo. Anta sara bale' ket kai sara gapo nin tumulong konra nin manukid sa sayti nin uakay ra. ");
INSERT INTO smkNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Say gagara ra tamo' nin mangwa' nin bubagay ket say parayo sa tutawo. Pinaagaba' ray madidintek nin kahon a nangwan nin nisurat ran partin Gugan-gan a iberber ra sa waleng tan takyay ra, tan nipaanro ray baruyboy sa saroy nin kapa ra ta pigaw nin ibarita' ran tutawo a masantos sara. ");
INSERT INTO smkNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rabay-rabay ray tumekre' sa tekrean para konran impurtantin tutawo sa sinaguga tan sa punsyawan. ");
INSERT INTO smkNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Rabay-rabay ray pagalangan ran tutawo sa publiko tan say tawagen saran ‘Maistro’. ");
INSERT INTO smkNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Si'kamo bale', andi' kamo patawag nin ‘Maistro’ ta pari-parihoy butang moyo, mibubsat kamo tan sayan-saya ya tamo' a Maistro moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Andi' moyo nin tawagen a kapada moyon tawo iti sa luta' nin ‘Ama’ a kapadan pannawag moyo konan Dios ta sayan-saya tamo' a ama moyo, si Dios nin itaw sa langit. ");
INSERT INTO smkNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wanin anamaet, andi' kamo nin patawag nin ‘Maistro’ ta sayan-saya tamo' a maistro moyo, si sya a Cristo nin nipangako' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Si sangkata'gayan komoyo, syay mampagsirbi komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Si mangita'gay nin lalaman nan diri, maikayupa' ya li', tan si mipaayupa', maita'gay ya li'.” ");
INSERT INTO smkNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo ta mansalabanan moyay purta nan Pag'adian nan Dios! Kai kamo anamaet nin sumrep tan awaan moyo sara et a marabay nin sumrep! ");
INSERT INTO smkNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo ta kayawen moyay intiron mundo sa tanay main nin masagyat moyon mayi sa pammemper moyo, ket si masagyat moyo gaw'en moyan masakit-sakit dyan si'kamo. Ket mas alaki et a rason nan madusa sa impyirno dyan si'kamo. ");
INSERT INTO smkNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kado' kamoynan tutawo! Bara'mo kamon bulag a mampangyakay sa dalan ta man'iyakay moyo a no si sayay tawo ket sinmamba ya maipa'ka' sa sayay bagay yupa' konan Timplo nan Dios, magwa' nan kai nin tukiden a nisamba na, bale' no sa balitok sa luob nan Timplo nan Dios a pangisamba na, kai nin magwa' a kai na nin tukiden a nisamba na. ");
INSERT INTO smkNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bulag kamon talaga ta mas main nin magwa' na kasin balitok sa luob nan Timplo nan Dios dyan si Timplo nan Dios nin mamasantos konan balitok! Waweng kamo! ");
INSERT INTO smkNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Man'iyakay moyo et a no si sayay tawo ket sinmamba ya maipa'ka' sa sayay bagay yupa' konan altar magwa' a kai na nin tukiden a nisamba na, bale' no say da'ton a sinambawan na kai nin magwa' a kai na nin tukiden a nisamba na. ");
INSERT INTO smkNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bulag kamon talaga ta mas main nin magwa' na kasin da'ton dyan si altar nin mamasantos konan da'ton? ");
INSERT INTO smkNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anaod, no si sayay tawo ket sinmamba ya yupa' sa altar, sinmamba yaynan lamang anamaet sa sarban itaw sa altar. ");
INSERT INTO smkNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ket no sa Timplo nan Dios ya nin sinmamba, sinmamba yaynan lamang anamaet konan Dios a syay mampiikap itaw. ");
INSERT INTO smkNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wanin anamaet a lamang, no si sayay tawo ket sinmamba ya yupa' sa langit, sinmamba yayna anamaet lamang sa truno nan Dios tan konan Dios nin nakatekre' sa truno na. ");
INSERT INTO smkNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo! Man'ibi moyo konan Dios pati kakapulo' nin mula moyon pangrikado moyo tamo' sa luto' moyo a bilang say anis, paminta tan laka', bale' manluktawan moyon gaw'en a mas maalaga nin ipagwa' nin Gugan-gan a bilang say pangwa' moyon mapteg sa kapada moyon tawo, say pag'in moyon mapainganga'do, tan say pag'in moyon mapagmatalkan. Sayti a manepeg nin gaw'en moyo bale' andi' moyo anamaet nin luktawan nin gaw'en a raruma. ");
INSERT INTO smkNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Si'kamo, bara'mo kamon bulag nin mampangyakay sa dalan. Bara'mo kamon sayay tawo nin sapiten nayay kutakti sa inumen na bale' ikiareb'eb nayan lamang a masibulot nin kamilyo. ");
INSERT INTO smkNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo! Man-gaw'en moyon maong a kaugalian moyo bilang say pangriringgas moyon rikor nin tagayan tan plato bale' say laman ket nangibwat sa kukanakman tan pigagawa' moyon napno' nin kasauran tan kaaguman. ");
INSERT INTO smkNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Si'kamon Pariseo, bulag kamo! Ringgasan moyo yapo' a laman nan tagayan ket maringgas li' anamaet a rikor na. ");
INSERT INTO smkNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo ta bara'mo kamon pantyon nin maputi' tan maringgas sa rikor, bale' sa luob ket napno' nin but'ol tan naumok nin laman nin tawo. ");
INSERT INTO smkNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wanin moyon peteg, ta no mangimey kamo say wamoyo ket matunong kamo, bale' say katutu'wan ket pulos nin piwadi'-wadi' tan kadukaan a iti sa kukaisipan moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kado' kamoyna, si'kamon Madudunong sa Gugan-gan tan si'kamon Pariseo! Mampisantu-santos kamo tamo'. Namagwa' kamon pantyon ran saray prupita nin pinati-pati ran puon moyo tan dikurasyunan moyon pabistawen a nanabunan konran tutawon nagkabyay nin matunong ");
INSERT INTO smkNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","tan wamoyon piwadi'-wadi', ‘No sibibyay kami ana kumon sin panaon ran puon mi, kai kami nin nikiranod sa ginwa' ra a pinati-pati rasaray prupita.’ ");
INSERT INTO smkNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No wanin edet, man'ipatutuo moyo a puri rakamon saray nangmati konran prupita sin saytaw. ");
INSERT INTO smkNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kanya' nin sigi! Ila'pos moyoy kadukaan a nitarana' ran puon moyo! ");
INSERT INTO smkNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bara'mo kamon masirib a ulay, bale' makapal'is kamo kasi nin madusa sa impyirno? Kai gapo! ");
INSERT INTO smkNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Anaod, ibarita' ko komoyo, mangibaki' ako komoyo nin saray mangipatanda' tan saray main nin kadunungan nin nangibwat konan Dios, tan saray mangangakay. Ket saray raruma konra, patyen moyo sara o ika' moyo saran ipasak sa kudos, ket saray raruma et, sanet-saneten moyo sara sa sinaguga moyo tan kamat-kamaten moyo saran duksa-duksaen sa adtiman nin lugar a palaywan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ket konan siin, si'kamoy mapuluan nin madusa bana' sa nipangmati konran sarba ran matunong a tutawo mangibwat ana kona ni Abel a kasan pakabalawan angga kona ni Zacarias nin anak na ni Baraquias a pinati moyo sa pisa'lean nan Sangkasantusan nin Lugar sa Timplo nan Dios tan si altar. ");
INSERT INTO smkNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ibarita' koyti komoyo, si'kamon tutawo konan sitin panaon a umbat li' sa patiti ran sarain a tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O si'kamon taga Jerusalem, patye-patyen moyo saray prupita tan kudas-kudasen moyo saran patyen a tutawo nan Dios a ibaki' na komoyo! Ni'no koyna nin sinari' nin dinepen katamon bilang sa pananayakop na sa sirong nin pakpak nan inan manok konran siwsiw na. Bale' si'kamo, andi' kamo! ");
INSERT INTO smkNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Anaod, pauryan nayayna nin Dios a lugar moyo! ");
INSERT INTO smkNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","O' ibarita' ko komoyo, kai rakoyna nin ma'kit anggan kai et nin rinmate' a panaon a maibarita' moyoy wanti: ‘Binindisyunan nayan Dios a nibaki' na nin manrumate' anadti sawanin kontamo!’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Linmiwa' ya si Jesus sa sakop nan Timplo nan Dios. Mampibwat yayna sin nako sara kona a tumutumbok na ta pigaw nin ipa'kit ra kona a pupa'deng itaw sa masakupan nin Timplo nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wana ni Jesus, “O', ket pastangen moyoynan maong sawanin ta ibarita' ko komoyo, main li' nin awro a mayba' in, ket kasayna li' gapo ni sayay bato nin isen a ma'kit nin naita'len konan saya et.” ");
INSERT INTO smkNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nako ya si Jesus sa Talugtog nin Olibo tan tinmekre' yadtaw. Nako saradtaw nin sara-sara tamo' a tumutumbok na ta main nin tepeten ra kona. Wanra, “Ka'no li' nin mangyadi' in si wamoyon mayba' ya a Timplo? Ani li' a panandaan nin isusubli' moynadti sa luta' tan say iyayangga nin kapresan a pag'uuray iti sa mundo?” ");
INSERT INTO smkNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ket wanan ni'bat ni Jesus konra, “Pakatalad kamo a kai kamo nin malingon tepren moyoy bula', ");
INSERT INTO smkNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ta abaw sara li' a mangusar nin titulo ko a wanra ket sara a Cristo nin nipangako' nan Dios. Ket abaw sara li' a malingo ra. ");
INSERT INTO smkNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Marnge' moyo a danurdor nin pigigira tan marnge-marnge' moyon main nin pigigira sa saka-sakalakon lugar. Bale' andi' kamo nin aburido ta saytin bubagay ket matkap nin mangyadi' yapo'. Bale' ambo' et nin iyayangga anan kapresan a pag'uuray iti sa mundo ");
INSERT INTO smkNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ta milalaban li' a nunasyon sa saya tan saya, tan wanin et a lamang a pupag'urayan. Magkamain li' nin bitil tan rayon sa abaw a lulugar. ");
INSERT INTO smkNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bale' sain ket tarana' tamo' et nin rumate' nin dya'dya', kapadan tarana' nan mangingar nin sayay mangabing. ");
INSERT INTO smkNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","No saytaw li' nin panaon ket dakpen tan ipagamet rakamo konran saray manusa komoyo, tan patyen rasaray raruma komoyo. Guraen rakamo li' nin tutawo nin mangibwat sa sarban nunasyon bana' ta mantarig'enan moyoy mangkikalamo' kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","No saytaw li' nin panaon ket abaw sara li' a mammemper kongko nin gurutan ra a pammemper ra. Miguraan sara li' a tutawo tan mitraiduran sara li'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Abaw sara li' a magbalu'-balo' a prupita nasaran Dios tan bula'-bula' a uakay ra, ket abaw sara li' a malingo ra. ");
INSERT INTO smkNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bana' li' ta wanin anay kadukaan iti sa mundo, tumab'ang li' a pangangado' ran abaw nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bale', si tawon tarig'enan nay tumulok kongko anggan kala'pusan nin dya'dya', makarate' ya sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maipatanda' ya li' a Mabistan Patanda' nin maipa'ka' sa pag'aadi' nan Dios sa sarban lugar ta pigaw nin matandaan ya nin sarban tutawo, ket no nayadi' ana in li' nin nagwa', saytaw ana a iyayangga nin kapresan a pag'uuray iti sa mundo. ");
INSERT INTO smkNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Anaod, si Prupita Daniel, nipadles na a maipa'ka' konan si ‘Makaparmay nin Bagay a Manida'.’ ” (Si'kan mampamasa, tarusan maytin maong!) “Saytaw no ma'kit yaynayti li' nin bagay nin itaw yayna sa Timplo nan Dios, ");
INSERT INTO smkNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","saray itaw nin mampiikap sa Judea malayo saraynan mako nin umadi sa tutalugtog. ");
INSERT INTO smkNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Si tawon itaw nin mampagprisko sa balkon bali ra, andi' yayna nin sumrep et nin mangalap nin animan a agamiren na. ");
INSERT INTO smkNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Si itaw nin mampagtrabaho sa gagawa', andi' yayna nin sumubli' et sa bali ra mangalap nin seket na. ");
INSERT INTO smkNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kado' sarayna li' a mabuktot tan saray uinan main nin ua'nak ran mampasuswen konan siin a panaon! ");
INSERT INTO smkNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kanya' nin idasal moyo konan Dios a ambo' li' kumon nin tyimpon gawat o Awron Painawa no mangyadi' in ");
INSERT INTO smkNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ta say dya'dya' li' konan sitaw a panaon ket kasa gapo nin kapada, nangibwat et sin naparsa yay mundo anggan sawanin, tan kasa gapo nin kapadan mangyadi' et li'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No kai naya paanteden in nin panaon nin Dios ket kasa li' gapo nin mabati' nin mabyay iti sa mundo. Bale' paanteden naya in li' nin panaon bana' konran pinili' na nin tutawo na. ");
INSERT INTO smkNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ket no saytaw li' ket main nin mamarita' komoyo a wana, ‘Syayna e a Cristo!’ o wana, ‘Itaw ya e!’ andi' kamo nin mamper ");
INSERT INTO smkNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ta abaw sara li' a magbalu'-balo' a sara a Cristo o a prupita sara. Mama'ki-pa'kit sara li' nin makapaka'ngap nin panandaan tan mumilagro ta pigaw nin lingwen rasaray tutawo, a no magwa' ket tagem nin saray pinili' nan Dios nin tutawo na. ");
INSERT INTO smkNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ket tandaan moyo ta nibarita' koyna nga'min komoyo ba'yo et nin mangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kanya' nin no main nin mamarita' komoyo a wanra, ‘Itaw ya si Cristo sa kasan katawu-tawon lugar,’ andi' moya nin keen karapen itaw, o no main nin mamarita' a wana, ‘Iti ya sa luob nin kwarto,’ andi' kamo nin mamper. ");
INSERT INTO smkNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wanin ta, say irarate' ko a si'kon si Pinaitawo ket mapatna-patnag a kapaday kimat nin bigra' nin kumidlap, a mamalaway sa langit mangibwat sa baytan anggan sa panrupan. ");
INSERT INTO smkNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kapada kasiguradon mangyadi' ti a no adti main nin maangot ran laman nin nati, ket itaw sara nin mididinep a mumanuk-manok a mangan nin laman nin nati. ");
INSERT INTO smkNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ket kayadi' li' nin sain a dya'dya', si awro, dumedlem ya tan si bulan, kai yayna nin sumlag. Say bubituen, mangaragrag mangibwat sa langit tan say pupakayadi' a mamauksoy sa ta'gay nin langit ket maguloyna. ");
INSERT INTO smkNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kaaram, main li' nin ma'kit sa langit nin panandaan a si'kon si Pinaitawo ket sumubli' akoynadti sa luta', ket mangabet-abet sara li' nga'min a tutawodti sa mundo. Ma'kit rako li' a si'kon si Pinaitawo nin manrumate' nin iti sa babon gunem, nin main nin pakayadi' tan kasan kapadan kagalangan. ");
INSERT INTO smkNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Patnuyen ya li' a alakin trumpita ket ibaki' kosara li' a uanghil ko nin mako sa sangkamundwan, tan dinepen rasara nga'min a tutawon pinili' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kikiten moyay kayon igos ta main nin maadal moyo mangibwat kona. No sumalingsing yayna tan gumulong, masigurado moyon rumate' anay tyimpon rapeg. ");
INSERT INTO smkNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wanin anamaet, no ma'kit moyoyna li' nin mampangyadi' ana in say nibarita' ko komoyo, matandaan moyoynan rumate' akoynan madali'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ibarita' koyti komoyo a no wanin ana li' anaod a mampangyadi', ba'yo kamo et nin mati nga'min ket matukid ana a sarban nibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Makasa a langit tan luta', bale' say ibarita' ko magnayon nin tutuo anggan-angga.” ");
INSERT INTO smkNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Bale' no ka'non peteg nin mangyadi' a nibarita' ko, kasa gapo nin makatanda', ni saray uanghil o si'kon si Anak nan Dios. Kal-la si Ama ko tamo' a makatanda'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sa panaon nin isusubli' kodti li' sa luta' nin si'kon si Pinaitawo, say kararate' ko li' ket bilang sa nangyadi' sin panaon na ni Noe ");
INSERT INTO smkNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","ta sin saytaw nin panaon a adapen nin malanip a intiron mundo, kai ra gapo nin nipa'ka' nin tutawo a main nin duka' a mangyadi'. Kanya' nin nangan saran maong, ninom sara, tan nangasawa tan nikiasawa sara angga sin mismon awron linmuob ya si Noe sa alakin baluto. Kapingmatan, linmanip yan bigra' ket naanor sara nga'min. Wanin anamaet li' a lamang no sumubli' akoyna a si'kon si Pinaitawo. ");
INSERT INTO smkNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ket, no saytaw li' nin panaon, bilang wadi' main nin rwa ray lalakin mampagtrabaho sa gagawa', si saya awiten raya li' nin uanghil ko tan ibati' raya li' a saya. ");
INSERT INTO smkNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","No main li' nin rwa ray bubbayin mampangiling, si saya awiten raya li' nin uanghil ko tan ibati' raya li' a saya. ");
INSERT INTO smkNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sumadya' kamon pirmi ta kai moyo nin tanda' no ka'noy awron sumubli' ako, si'kon si Uunuren moyo. ");
INSERT INTO smkNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kapada nan sayay main nin ikon nin bali, no tanda' na kumon no ka'no ya nin mako a mannakaw, siguradon sadyaan naya, ket si mannakaw kai ya nin makasrep. ");
INSERT INTO smkNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanya' anaod nin, matkap a sisasadya' kamon lawas ta si'kon si Pinaitawo ket bigra' nin rumate' ako li' no ka'no moyo kai nin ipa'ka'.” ");
INSERT INTO smkNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Si sayay manakem tan kapagpyawan a alila', ket pyawen nayan amo na nin mangasikaso konran kapada nan alila', nin mamin kanen ra sa kuston udas. ");
INSERT INTO smkNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Paririketen naya nin amo a wanin nin alila' no sa irarate' na ket wanin a man-gaw'en nan sitin alila'. ");
INSERT INTO smkNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anaod, ibarita' koyti komoyo a pag'inen naya nin ingkargado sa sarban main na nin amo na. ");
INSERT INTO smkNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bale' no duka' ya wadi' taw nin alila' a say wana sa nakem na ket, ‘Ma'teng ya et nin rumate' a amo ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ket sasakit-sakiten nasaray kapada nan alila' tan kipangan tan kiinuman ya konran mabubok. ");
INSERT INTO smkNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ket kapingmatan, rinmate' yay amo na nin kai na gapo nipa'ka' nin rumate' ya. ");
INSERT INTO smkNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ket kasan sapon dusawen nayan say makapati nin sitin amo na ket itampal nayadtaw nin ikalamo' konran misantu-santos ket itaw main nin umasisit tan umagrem tan ngumaretenget a ngipen ra bana' sa pakapaidap tan bereng. ");
INSERT INTO smkNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sa panaon nin isusubli' kodti, main li' nin bilang konran sarayti konan sitin isturya no maipa'ka' sa pag'aadi' nan Dios. Main nin mapulo' ray bubalasang nin barang saya konra ket main nin lampadawan na ta keen raya nin sanaen a nubyo. ");
INSERT INTO smkNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Saray lima konra ket kasinakem sara; saray lima et bale' ket manakem sara. ");
INSERT INTO smkNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Saray liman kasinakem, nangawit saran page' nin lampadawan ra bale' kasan awit ran risirba ran ladak. ");
INSERT INTO smkNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Saraytaw bale' saray liman manakem, nangawit saran risirba ran ladak. ");
INSERT INTO smkNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na'teng yan kai nin rinmate' a nubyo kanya' nin mangitungge' saraynan mantuma'gan angga sin nakaka'lek sara. ");
INSERT INTO smkNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sin kapiknga' yabi ana, bigra' a main nin tinma'way a wana, ‘Suoynay nubyo! Keen moya nin sanaen!’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nibarikwas saraytaw saray mampa'lek a bubalasang tan nisadya' ray lampadawan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wanra nin saray kasinakem konran saray manakem, ‘Byan rakami tana kadi' nin ladak moyo ta makuyep anay lampadawan mi.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ni'bat ra nin saray manakem, ‘Kai a magwa'. Kai nin makayadi' ti kontamo nga'min say awit min ladak. Mako kamoyna nin manaliw sa tindawan.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sawanin, leg'an ran nako nin nanaliw, rinmate' yay nubyo. Nayi sara anaytaw kona saray sisasadya' a bubalasang sa kami'nan nin bansal ket sin nakasrep sarayna sa bali, nisada' yaynay purta. ");
INSERT INTO smkNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ambo' nin na'teng, rinmate' saraytaw saray liman kasinakem. Itaw sara sa rikor ket nita'wa-ta'way ra, ‘Sinyor, pasrepen rakami!’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bale' si nubyo ni'bat na konra, ‘Kai gapo nin magwa'! Kai katamo nin katanda'!’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wana ni Jesus, “Kanya' anaod nin si'kamo, matkap a sisasadya' kamo abirno nin ani a udas ta kai moyo nin tanda' no ani nin awro o udas ako li' nin sumubli'.” ");
INSERT INTO smkNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maiyarig et sa wanti e a pag'aadi' na li' nin Dios sa panaon nin isusubli' kodti. Main nin sayay lalaki nin nako sa sayay adayo' a lugar. Mi'sa ya nin nibwat, kinayaban nasaray kukatulungan na ta pigaw nin ibati' nan ipaga'getan a kukayamanan na konra. ");
INSERT INTO smkNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tinau-tao na sigon sa pakababa' ran manga'get. Si saya, binyan nayan liman milyon nin pisos, si saya, rwan milyon, tan si saya et, sayan milyon. Mi'sa nibwat yayna. ");
INSERT INTO smkNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sitaw si binyan nin liman milyon, nika' nan tampor nin nikumirsyo, ket nakaganansya yan liman milyon. ");
INSERT INTO smkNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wanin anamaet lamang a ginwa' nan si binyan nin rwan milyon, ket nakaganansya yan rwan milyon. ");
INSERT INTO smkNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sitaw bale' si binyan nin sayan milyon, nika' nayaytaw nin nikali si kwarta nan amo na. ");
INSERT INTO smkNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Linmabas a anron panaon ket si amo, rinmate' ya nin mako kikwintawan konra. ");
INSERT INTO smkNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sitaw si binyan nin liman milyon, nako yadtaw kona tan niparisibi naytaw say kwartan nibi kona tan say naganansya nan liman milyon. Wana, ‘Don, binyan nakon liman milyon, ket sya e, tan ya e anamaet a liman milyon a na'kitan na.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wanan amo kona, ‘Mabistay ginwa' mo! Manakem tan kapagpyawan kan katulungan! Bana' ta kapagpyawan ka sa daite', ipya ko et komo a alaki. Paradti ta kirama' ka sa ririket ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nako yadtaw anamaet lamang taw si binyan nin rwan milyon tan wana, ‘Don, binyan nakon rwan milyon, ket sya e, tan ya e anamaet a rwan milyon a na'kitan na.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wanan amo kona, ‘Mabistay ginwa' mo! Manakem tan kapagpyawan kan katulungan. Bana' ta kapagpyawan ka sa daite', ipya ko et komo a alaki. Paradti ta kirama' ka sa ririket ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nako yadtaw anamaet taw si binyan nin sayan milyon. Wana konan amo, ‘Don, tanda' kon kasan inganga'do mo. Yataben moy kai mo nin nimula tan kalapen moy ganansya sa kai mo nin kinapagalan. ");
INSERT INTO smkNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Linmi'mo ako kanya' nin say ginwa' ko, nikali koyay kwarta mo. Suoy a kwarta mo!’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Duka' tan matamlad kan katulungan!’ wanan ni'bat nin amo. ‘Wanin anamain a tanda' mo maipa'ka' kongko, a yataben koy kai ko nin nimula tan kalapen koy ganansya sa kai ko nin kinapagalan, ");
INSERT INTO smkNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ket, mayin edet a kai ma nin nikwa sa bangko a kwarta ko ta pigaw kumon nin no rumate' ako ket risibyen koyay kwarta ko pati say abang na?’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nigan-gan nan amo konran raruman katulungan, ‘Sigi, kalapen moyoy kwartan nibati' ko kona ta ibi moyo konan si mapulo' nin milyon a kwarta na.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wanti ta, si si'numan a main kona a sayay bagay, malamu'nan ya nin umabaw yaynan umabaw ket magkamain yan malaem. Bale' mataman nin si daite' nin main kona, maglat et li' konan si si'numan a kai nin mangusar sa naipya kona. ");
INSERT INTO smkNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ket sitin kasan sirbin katulungan, itampal yadtaw sa rikor nin pinasyan dedlem, nin itaw ket main nin umasisit tan umagrem tan ngumaretenget a ngipen ra bana' sa pakapaidap tan bereng.” ");
INSERT INTO smkNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ket si'ko anaod, si Pinaitawo, sumubli' ako li' nin si'koy Adi' a kalamo' kosara a sarban uanghil tan tumekre' ako li' sa sangkata'gayan nin truno ko. ");
INSERT INTO smkNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Madinep sara li' nga'min sa adapan ko a sarban tutawodti sa mundo, tan kapadan pangingisyay nan kukarniro nan sayay mammastor konran kukanding, pisyayen kosara li' sa rway grupo a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Saray i'deng ran kukarniro ikwa kosara li' sa pawanan ko, tan saray i'deng ran kukanding ikwa kosara li' sa pawiri ko. ");
INSERT INTO smkNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ket si'kon si Adi' wangko li' konran iti sa pawanan ko, ‘Paradti, si'kamon binindisyunan na nin Dios a Ama ko. Risibyen moyay Pag'adian a naisadya' anan gindat para komoyo nangibwat et sin kapamarsa konan mundo, ");
INSERT INTO smkNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ta sin nabitilan ako ket pinakan rako; sin milata' ako ket pinainom rako; abirno nin kai rako nin katanda' ket sinan'ili rako sa pammali moyo; ");
INSERT INTO smkNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","sin kasan maisket ko ket binyan rako; sin main nin masakit ko ket inalila' rako; sin napriso ako ket binisita rako.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ket wanra li' nin saray matunong nin iti sa pawanan ko, ‘Catawan, ka'no ka nin nabitilan ket pinakan ka, o nilata' ka ket pinainom ka? ");
INSERT INTO smkNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ka'no ka nin kai nin katanda' ket sinan'ili ka sa pammali mi, o kasan maisket mo ket binyan ka; ");
INSERT INTO smkNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","tan ka'no ka nin nagmasakit o napriso ket binisita ka?’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ket si'kon si Adi', i'bat ko li', ‘Ibarita' koyti komoyo, no ginwa' moyo in konan saya konran saraytin mammemper kongko a sara ket bara'mo saran bubsat ko, abirno nin aninay kaayupaan na, ginwa' moyoynan lamang kongko.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Wangko li' anamaet konran iti sa pawiri ko, ‘Lumakwan kamodti, si'kamon nisamba na nin Dios. Mako kamodtaw sa burung-burong nin apoy a kai gapo nin ma'rep a nisadya' para konan Dimunyo tan saray uanghil na ");
INSERT INTO smkNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ta sin nabitilan ako ket kai rako nin pinakan; sin milata' ako ket kai rako nin pinainom; ");
INSERT INTO smkNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","sin kasan piikapan ko ket kai rako nin sinan'ili sa pammali moyo; sin kasa nin maisket ko ket kai rako nin binyan; sin main nin masakit ko tan sin napriso ako ket kai rako nin binisita.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ket itepet ra li', ‘Catawan, ka'no ka nin nabitilan, o nilata', o kasan piikapan, o kasan maisket, o main nin masakit, o napriso ket kai ka nin tinulungan?’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Si'ko nin si Adi', i'bat ko li', ‘Ibarita' koyti komoyo, sin nisiblet moyoy tulong moyo konan saya konran ayuyupa' nin tutawo ko, si'koy sinibletan moyo.’ ");
INSERT INTO smkNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sarain nin tutawo, maika' sara sa pakadusawan nin kasan anggawan. Sara bale' a matunong nin tutawo, mabyan sara nin anggan-angga nin byay a iti konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sin nayadi' nayna nin nibarita' nga'min in nin uakay ni Jesus, wana konran tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tanda' moyo a rway awro tana ba'yo a pista nin mantawagen nin Nipanglabas. Ket si'kon si Pinaitawo, maipagamet akoyna konran iti sa uray ta pigaw nin ipasak rako sa kudos.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Siin nin awro, nididinep saray Pupangulon Pupadi' tan saray Mangatuntawo sa palasyo nan Sangkata'gayan nin Padi' a si Caifas. ");
INSERT INTO smkNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nag'iirgwan ra no pa'no raya nin dakpen si Jesus nin kai ra matandaan nin tutawo, mi'sa raya nin patyen. ");
INSERT INTO smkNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Bale' ambo' nin no pista,” wanra, “ta bangli' no gumulo saray tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Itaw ya si Jesus sa Betania, sa bali na ni Simon a gindat nin main nin makaparmay a sakit sa katat. ");
INSERT INTO smkNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sin kapresan ray mampangan ket main nin babayin nako kona ni Jesus. Sitin babayi ket main nin awit nan sayay pangangwan a main nin laman nin banglo a pinasyan bili, ket nibu'bo' nayti sa ulo na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Masager saray tumutumbok na ni Jesus sin na'kit ray ginwa' nan babayi. Wanra, “Pinirdi nayna in nin banglo! ");
INSERT INTO smkNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Abaw in kumon nin kwarta no nilako' ya ket, naibi et kumon konran pubri.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tanda' na ni Jesus a man'irgwe-irgwen ra ket wana konra, “Ambale' ket? Pauryan moya! Pinasyan bista nin ginwa' na kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abirno nin ani a udas, isen saray pubri nin makalamo' moyo, bale' si'ko, ambo' anan ma'teng a iti ako et komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Binanglwan nayay lalaman ko nin pananadya' na para li' sa tabon ko. ");
INSERT INTO smkNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ibarita' koyti komoyo, adtiman nin lugar sa intiron mundo a pakaipatandaan nan Mabistan Patanda', say ginwa' nan sitin babayi ket maibari-barita' li' anamaet nin pammanemtem kona.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sumunor konan siin, si Judas Iscariote, saya konran labinrwan tumutumbok na ni Jesus, ket nako ya konran Pupangulon Pupadi', ");
INSERT INTO smkNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tan wana konra, “Umnoy ibi moyo kongko no bana' sa gaw'en ko ket maipagamet ya komoyo si Jesus?” Namilang saran tulumpulo' nin pirak tan nibi ra kona, ");
INSERT INTO smkNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ket, nangibwat ana sin sain, nangkit yayna nin tyimpon maipagamet naya konra si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sin primiron awro nin Pistan Pangangan nin Tinapay a Kasan Pammakbo, nako sara kona ni Jesus a tumutumbok na tan nitepet ra kona, “Adti a rabay mo nin pangisadyaan min pangapunan sa pangngisilibra tamon Pistan Nipanglabas?” ");
INSERT INTO smkNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wana ni Jesus konra, “Mako kamo konan siti nin tawo sa Jerusalem tan ibarita' moyo konayti: ‘Wana ni Maistro tamo, narate' anay udas ko. Si'ko tan saray tumutumbok ko, isen sa bali mo a pangisilibrawan mi nin Pistan Nipanglabas.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ket ginwa' ran tumutumbok a wana konra tan nisadya' raynay pangapunan ra sa pista. ");
INSERT INTO smkNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sin yabi, nidudungo sara sa pangnganan si Jesus tan saray labinrwan tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sin kapresan ran mampangan wana ni Jesus, “Ibarita' koyti komoyo, saya komoyo a magtraidor kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rinmere' saran tuloy a tumutumbok. Barang saya wana kona ni Jesus, “Uunuren, maibarita' mo para nin si'ko?” ");
INSERT INTO smkNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ni'bat na ni Jesus, “Si saya komoyo a mangkipanawsaw kongko nin tinapay sa yawong, sya a magtraidor kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anaod, si'kon si Pinaitawo, mati ako a bilang sa wana sa Kasuratan. Bale' kado' yayna in si magtraidor kongko! Mas maong ana kumon a kai ya nin naiyanak.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Si Judas a syay magtraidor kona wana, “Maistro, maibarita' mo para nin si'ko?” Ni'bat na ni Jesus kona, “Nairgo moyna.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sin kapresan ran mampangan nangalap yan tinapay si Jesus, tan nikisalamat ya konan Dios mi'sa simpi-simping naya tan nitayak na konran tumutumbok na. Wana, “Kalapen moyayti tan kanen moya. Siti a lalaman ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kaaram, kinalap nayay baso a main nin arak nin ubas. Nikisalamat ya konan Dios, mi'sa naya nin nibi konran tumutumbok a wana, “Sarba moyo, minom konan siti. ");
INSERT INTO smkNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sayti a daya' ko nin mama'get nin kataratwan konan Dios. Tumuro' li' ta pigaw nin mapirduna a kukasalanan ran abaw a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ibarita' koyti komoyo, kai akoyna gapo minom nin arak nin ubas angga konan sitaw si awron minom ako li' nin ba'yon arak a kadungo katamo sa Pag'adian nan Dios a Ama ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sin nayadi' sara nin nangansyon nin pangrarayo konan Dios nibwat saran nako sa Talugtog Olibo. ");
INSERT INTO smkNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wana ni Jesus konra, “Sarba moyo nga'min, palaywan rako konan sitin yabi a bilang sa wanan Dios a naisurat sa Kasuratan. Wana, ‘Patyen koya li' a mammastor ket saray karniro misisyak sara.’ ");
INSERT INTO smkNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bale' saytaw no napasubli' akoyna li' nin mabyay, mu'na akoyna li' tan taga'nan katamodtaw sa Galilea.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wanan nag'irgo ni Pedro, “Lakwanan rakayna nga'min, bale' si'ko kai gapo.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wana ni Jesus kona, “Ibarita' ko komo, Pedro, ba'yo main nin tumarang'ok nin manok konan sitin parbangon, mitlo moyna nin nibudi' a katanda' nako.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bale' wana ni Pedro, “Mataman et nin kalamo' nako nin patyen ra, kai ko gapo nin ibudi' a katanda' kata.” Wanin anamaet lamang a wanra nin raruman tumutumbok. ");
INSERT INTO smkNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Rinmate' sara si Jesus itaw sa sayay lugar a napangaranan nin Getsemani. Wana konran tumutumbok na, “Mabati' kamodti. Mako akodtaw e nin dumasal.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ni'ras nasaran kalalamo' na si Pedro tan saray rway a'nak na ni Zebedeo. Marere' yan tuloy tan pinasyan byat nin man'isipen na. ");
INSERT INTO smkNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wana konra, “Pinasyan tuloy nin bereng ko ket ipati koyna layi. Iti kamo tamo'. Lalamu'nen rako a andi' kamo nin ma'lek.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kinmadayo' yan buga' konra. Linmukob ya tan dinmasal ya. Wana, “Ama ko, no magwa' andi' mo kumon ipairangep kongko in say dya'dya' a adapen kon irangep. Wanin man, ambo' a karabayan ko a masunor, no kai say karabayan mo.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sin sinmubli' ya konran saray tuloy tumutumbok na, narat'anan nasaran mangka'lek. Pinukaw nasara tan wana kona ni Pedro, “Kai rako tana gapo nin malalamo' nin andi' kamo nin ma'lek abirno nin sayay udas tamo'? ");
INSERT INTO smkNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Andi' kamo nin ma'lek no kai edet, dumasal kamo ta pigaw nin kai kamo nin madaeg nin tukso, ta sa nakem moyo ket disidido kamon gaw'en moyoy manepeg bale' mapatapo' kamon kinatawo moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kinmadayo' ya anamanaet si Jesus tan dinmasal yan uman. Wana, “Ama ko, matumbok a karabayan mo. No siin a karabayan mo si matkap kon irangep in say adapen kon irangep nin dya'dya', wanin lawas.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sin sinmubli' ya anamanaet sa kami'nan ran tulon tumutumbok nin kalalamo' na, mampa'lek sara anamanaet ta talagan kai ra nin mapukpukan a elek ra. ");
INSERT INTO smkNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanya' nin linakwanan nasara anamanaet tan dinmasal yan pitlo nin wantaw a lamang sa nayadi' anan nidasal na. ");
INSERT INTO smkNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sinmubli' ya anamanaet konran tumutumbok na tan wana konra, “Mampa'lek kamo et! Pakanda' kamo! Narate' anay udas a si'kon si Pinaitawo ket maipagamet akoyna konran duka' a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mibangon kamo tan sumna' atamo. Sya eyna e a tawon nagtraidor kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mampag'irgo ya et si Jesus sin rinmate' ya si Judas a saya konran labinrwan tumutumbok na. Abaw saray tutawon kalamo' na nin nibaki' ran Pupangulon Pupadi' tan saray Mangatuntawo. Di-beneng tan di-batuta' sara. ");
INSERT INTO smkNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nibarita' naynan gindat konra ni Judas no pa'no rayan maipurok si Jesus. Wana, “Si arkan ko, syaytaw a diri. Dakpen moyan tampor.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sin rinmate' yadtaw si Judas, diri-diritso na kona ni Jesus. “Maabig a yabi, Maistro,” wana kona ket inarkan naya. ");
INSERT INTO smkNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“Amigo, gaw'en moynan tampor a gagara mo,” ni'bat na ni Jesus kona. Inmarak saray tutawo ket dinakep raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Si saya konran kalalamo' na ni Jesus, inuyos nayay beneng na tan tinaga' nayay sayay katulong nan si Sangkata'gayan nin Padi' ket naglat yay tutulyan na. ");
INSERT INTO smkNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wana ni Jesus kona, “Ikaluban mayna in si beneng mo. Saray mangyusar nin armas, armas anamaet a pakamatyan ra. ");
INSERT INTO smkNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kai mo para nin tanda' a no kidawat akon tulong konan Dios a Ama ko ket mangibaki' yadti nin ribu-ribon uanghil na? ");
INSERT INTO smkNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bale' no wanin, pa'no nin matukid a wanan Dios a naisurat sa Kasuratan a matkap nin mangyadi' in ey?” ");
INSERT INTO smkNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ket wana ni Jesus konran tutawo, “Saya ako para nin kriminal ta nakabeneng kamo tan main nin pekpek moyon manakep kongko? Inawru-awro kon nangyakay itaw sa sakop nan Timplo nan Dios, kai rakoyna nin dinakep itaw! ");
INSERT INTO smkNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bale' mampangyadi' ti nga'min nin pakatukidan nin nisurat ran prupita.” Ket nagsipalayo sara nga'min a tumutumbok na tan linakwanan raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Saraytaw saray nanakep, nika' raya si Jesus sa palasyo nan Sangkata'gayan nin Padi' a si Caifas. Itaw nididinep saray Madudunong sa Gugan-gan tan saray Mangatuntawo. ");
INSERT INTO smkNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro, tinmumbu-tumbok ya kona ni Jesus, bale' itaw ya tamo' sa dayo'. Sin sinumrep saray nanakep sa palasyo, angga yadtaw tana sa baraybay. Kaaram nituloy na sa luob nin pukok nan palasyo tan nikitekre' ya konran gwardya ta rabay nan matandaan no ani a mangyadi' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Saray Pupangulon Pupadi' tan sarba ran myimbro nan Kunsiho, naningka-tingkap saran abirno bula'-bula' nin ibidinsya kuntra kona ni Jesus ta pigaw nin masintinsyawan rayan patiti. ");
INSERT INTO smkNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bale' kasan ma'kit ran sumadag abirno nin abaw saray namarita' nin bula'-bula' nin kuntra kona. Sa ka'tengan main nin rwa ray pinaipadar. ");
INSERT INTO smkNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wanra, “Wanan siin a tawo, mababa' naya kanon sidaen mi'sa ipa'deng nayan uman sa luob nin tuloy awro a Timplo nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Inumdeng yay Sangkata'gayan nin Padi' tan wana kona ni Jesus, “Ani a mai'bat mo sa sain a man'iparsa ra komo?” ");
INSERT INTO smkNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bale' kai ya gapo nin nag'irgo si Jesus. Ket wanan Sangkata'gayan nin Padi' kona, “Igan-gan ko komo, ibarita' mo komi, sa ngaran nan sibibyay a Dios, no si'kay Cristo a Anak nan Dios a si nipangako' nan ibaki' nadti.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ni'bat na ni Jesus, “Nairgo moyna. Ket ibarita' ko komoyo, sa ambo' nin ma'teng nin panaon, ma'kit rako nin si'kon si Pinaitawo nin nakatekre' iti sa pawanan nan Dios, a sya a Makapangyayadi', nin manrumate' akon iti sa babon gunem mangibwat sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sin narnge' nayti nin Sangkata'gayan nin Padi', rinakyat nayay aysing na nin pangipa'kit nan alakin sager na. Wana, “Pangu'na-u'na konan Dios in say nibarita' na! Ani, matkap et a tistigos? Narnge' moyoynan mismo sawanin a pangu'na-u'na na konan Dios! ");
INSERT INTO smkNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ani a wamoyo?” wana. Ket ni'bat ran kalalamo' na, “Nagkasalanan ya ket manepeg a patyen ya.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ket linuda'-ludaan raya si Jesus sa rupa, tan tinasu-taso raya. Rinampa-rampa' raya nin raruma ");
INSERT INTO smkNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tan wanra, “Si'kan si syay Cristo, ibarita' mo pa no si'noy nangrampa' komo!” ");
INSERT INTO smkNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Itaw ya si Pedro nin mantumekre' sa baraybay nan palasyo. Kinmadani ya kona a sayay alila' nan babayi nin Sangkata'gayan nin Padi' ket wana kona, “Saya ka anamaet konran kalalamo' nan sitaw si Jesus a taga Galilea, a!” ");
INSERT INTO smkNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nibudi' na in ni Pedro nin narnge' ran sarba ran itaw a wana, “Kai ko nin tanda' in say man'ibarita' mo!” ");
INSERT INTO smkNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Inmalis yan nako sa purta nan pukok. Saya anamanaet nin alila' nin babayi a nakaalilbi' kona ket wana konran tutawodtaw, “Sitin tawo, kalamo' nayan siin si Jesus a taga Nazaret.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sinambawan na nin kai na anamanaet nin inalilbi' ni Pedro a wana, “Kai koya nin tanda' in nin tawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sin nainsanan nin buga' kinadanyan rayan saray lulalakin itaw tan wanra kona, “Page' pa a saya ka konran kalalamo' na. Madlaw sa punto mon mag'irgo a taga Galilea ka.” ");
INSERT INTO smkNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Sambawan ko nin kai koya nin katanda' in nin tawo,” wana ni Pedro, “ket taman mangno ako no mampibula'-bula' ako.” Kapingmatan, main nin tinmarang'ok nin manok. ");
INSERT INTO smkNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ket napanemtem nayaytaw ni Pedro si nibarita' na ni Jesus kona a wana, “Ba'yo ya nin tumarang'ok a manok, nitlo moyna nin nibudi' a katanda' nako.” Nibwat ya si Pedro tan abet-abet na. ");
INSERT INTO smkNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kinabuklasan, sarba ran Pupangulon Pupadi' tan saray Mangatuntawo, nag'iirgwan ra no pa'no rayan maipapati si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nipabaror ray gamet na mi'sa raya nin ni'ras kona ni Pilato, si gubirnador nin Romano. ");
INSERT INTO smkNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Si Judas, si nagtraidor kona ni Jesus, sin natandaan nan nasintinsyawan yan mati si Jesus, ginmereng ya sa ginwa' na. Ket, nika' na nin isubli' konran Pupangulon Pupadi' tan Mangatuntawo a tulumpulo' nin pirak. ");
INSERT INTO smkNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nagkasalanan ako!” wana. “Liniputan koyay tawon kasan kasalanan ket sawanin mapati ya bana' sa gawa' ko.” Wanra kona, “Ani a kabiangan mi ey? Prublima moyna in nin bukod!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nipasasweng na ni Judas a kwarta sa luob nin Timplo nan Dios. Mi'sa nibwat ya tan nako ya nin pinaibitay. ");
INSERT INTO smkNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinurot ran Pupangulon Pupadi' a kwarta. Ket wanra, “Bilin byay nan sayay tawoytin kwarta. Ta wanin edet, kai nin aburuyan nin Gugan-gan na ni Moises a maikalamo' ti sa kwarta nan Timplo nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ket nag'iirgwan ra no ani a gaw'en sa kwarta tan nipagketan ra nin isaliw rayti konan luta' nan sayay mangangwa' nin kuden tan paya ta pigaw nin gaw'en rayan kampusanto ran ambo' nin tawo sa Jerusalem a matidtaw. ");
INSERT INTO smkNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanya' nin anggan sawanin, bana' ta sain nin kwarta ket bilin byay nin tawo, sitaw nin luta' ket mantawagen ya nin Luta' nin Daya'. ");
INSERT INTO smkNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Konan siin natukid a wanan Dios a nipaibarita' na kona ni Prupita Jeremias. Wana, “Say tulumpulo' a pirak nin nipamrisyo ra nin saray raruman puri na ni Israel kona, kinalap ra ");
INSERT INTO smkNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nin nisaliw ra konan luta' nan sayay mangangwa' nin kuden tan paya, bilang sa nigan-gan na kongko nin Catawan.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Naiyadap ya si Jesus nin usisaen nan gubirnador a si Pilato. Tinepet nan gubirnador kona, “Si'ka paran page' a adi' ran Judio?” Ni'bat na ni Jesus, “Nairgo moyoyna.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pinarsa-parsawan rayan abas nin Pupangulon Pupadi' tan Mangatuntawo si Jesus, bale' kai ya gapo nin inumbat. ");
INSERT INTO smkNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kanya' nin wana ni Pilato kona, “Ambale'? Kai ka tana gapo nin umbat maipa'ka' sa sain say man'iparsa-parsa ra komo!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bale' kai ya gapo nin nag'irgo si Jesus kanya' nin naka'ngap yan maong a gubirnador. ");
INSERT INTO smkNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ugali' na ni Gubirnador a tepe' nin Pistan Nipanglabas mamirduna yan mangibulos nin sayay priso nin no si'no a pilien ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sin sain, main itaw nin mangkaprison sayay bandunado nin tawo a say ngaran na ket Jesus Barrabas. ");
INSERT INTO smkNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ket sin nadinep sara nga'min a tutawo, wanan nitepet ni Pilato, “Si'noy rabay moyon bulusan ko? Si Jesus Barrabas o si Jesus a mantawagen ran Cristo?” ");
INSERT INTO smkNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wanin a wana ta tanda' nan peteg a maimbel saray pupangulon Judio kona ni Jesus kanya' nin niyadap raya kona. ");
INSERT INTO smkNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sin itaw ya et nin nakatekre' sa lugar nin paninintinsyawan si Pilato, main nin rinmate' nin nipaibarita' nan asawa na kona a wana, “Andi' ka nin mangwa' nin animan a kuntra konan siin a tawo. Kasa gapo nin kasalanan na. Nanaynep akon duka' maipa'ka' kona nayabi ket napaidap ako sa taynep ko.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sara bale' a Pupangulon Pupadi' tan saray Mangatuntawo, sinugsog rasaray tutawo nin dawaten ran si Barrabas a bulusan na tan patyen ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kanya' nin sin tinepetan nasara anamanan gubirnador a tutawo no si'no konran rwa a rabay ran bulusan na, wanran ni'bat, “Si Barrabas!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wana ni Pilato, “No wanin ani a gaw'en ko kona ni Jesus a mantawagen ran Cristo?” “Ipasak ma sa kudos!” wanran ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Ambale'?” wana ni Pilato. “Main paran ginwa' nan abas?” Bale' mas maksaw rayna edet nin niburyaw, “Ipasak ma sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Naisip na ni Pilato a kasaynan magwa' na ta tumarana' saraynan gumulo a tutawo. Namakalap yan ranom tan nanguyas yan gamet na sa adapan ran tutawo a say rabay nin irgwen ket kasan kabiangan na sa patiti na ni Jesus. Wana, “Kasan kabiangan ko sa patiti nan sitin tawo. Makauray kamo!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","“O', si'kami tan saray puri mi a umbat sa patiti nan siin a tawo,” wanra nga'min nin ni'bat nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ket binulusan naya si Barrabas a bilang sa dawat ra. Nipasanet naya si Jesus mi'sa nayayna nin nipagamet konran sundalo' nin ika' raya ipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ni'ras raya si Jesus nin sundalo' nan gubirnador sa luob nin palasyo na a mantawagen nin Pretorio tan inaribungbungan raya nin sarba ran itaw nin sundalo'. ");
INSERT INTO smkNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linus'ukan raya mi'sa sinulutan raya nin kulor lilan kapa a kano wadi' ket adi' ya. ");
INSERT INTO smkNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Namalukay saran madiwin wakay a kuruna kano wadi' tan nikuruna rayayti kona ni Jesus. Pinanga'get rayan bislak sa pawanan nin gamet na a kano wadi' ket si mantawagen yayti nin setro tan nanalimukod sara sa adapan na a kano wadi' ket pangigalang ra kona. Wanra, “Viva, Adi' ran Judio!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kaaram linudaan raya mi'sa raya nin linapnit a bislak kona tan nipatuk-patok rayayti sa ulo na. ");
INSERT INTO smkNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sin sinmawa' saraynan nagpista kona, linus'ok rayaytaw kona si lilan kapa tan nisubli' ran nisulot kona a dirin seket na. Kaaram, niliwa' rayaynan ika' ipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sin manrumikor sara sa syudad, nasnaan rayay sayay lalakin taga Cirene a say ngaran na Simon. Nipasuet rayan nipabalatay kona a kudos a mambalatayen na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nirate' sara sa lugar a mantawagen nin Golgota a say rabay nan irgwen ket Lugar nin But'ol Ulo. ");
INSERT INTO smkNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Painumen raya kumon si Jesus nin arak a linawukan nin bagay a pinasyan pait a pammaka'lek. Sin natawayan nayti ket kai na nin ininom. ");
INSERT INTO smkNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sin naipasak rayayna sa kudos, nibubunutan sara ta pigaw nin mapitaw'a-taw'an ray seket na. ");
INSERT INTO smkNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sin nayadi', tinmekre' sara tan binantayan raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa ta'gay nin ulo na ni Jesus, nipasak rayay nakaisuratan nin nipakasalanan ra kona. Wana: SITI SI JESUS, SI ADI' RAN JUDIO. ");
INSERT INTO smkNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Main nin rwa ray kriminal a nikirngan ran nipasak kona ni Jesus, si saya sa bandan wanan na tan si saya anamaet sa wiri na. ");
INSERT INTO smkNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Saray tutawon lumabas, ipeyeng-peyeng ran panuya'-tuya' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wanra, “Kai para a si'ka, wamo intaw ket mababa' man yubaen tan ipa'deng nin uman sa luob nin tuloy awro a Timplo nan Dios? No page' a Anak nakan Dios, isalba mo pa edet a lalaman mo tan gumlat kadsen sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wanra in anamaet lamang nin Pupangulon Pupadi', saray Madudunong sa Gugan-gan, tan saray Mangatuntawo. Tinuya'-tuya' raya anamaet a lamang si Jesus, wanra, ");
INSERT INTO smkNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Saray raruman tawo naisalba nasara kano, bale' say lalaman nan diri, kai! Heh! Adi' tamo kanon si'tamon Israelita! No makaglat yadsen tana sa kudos, mamper atamoyna kona. ");
INSERT INTO smkNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Magmatalek ya kano konan Dios tan wanan Anak naya kanon Dios! Kikiten tamo pa edet sawanin no iligyas nayan Dios ta kawa'nan naya kano.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mataman nin saray kriminal nin karngan nan nipasak ni Jesus, tinuya'-tuya' rayan lamang nin wantaw. ");
INSERT INTO smkNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sin ugtiawro, dinmedlem yay intiron babon luta' nin narate' a tuloy udas. ");
INSERT INTO smkNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sin bandan alas tres nin yabina wana nin nita'way ni Jesus sa sarita' nin Hebreo, “Eli, Eli, lama sabachthani?” a say katarusan, “Dios ko, Dios ko, ambale' nin pinauryan nako?” ");
INSERT INTO smkNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wanran tutawodtaw nin nakarnge' kona, “Mantawagen naya si Elias!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ket, saya konra, nangred yan tampor nin nako nangipaalep'ep nin ispungha sa maalsem nin arak nin nikwa naya sa parpar nin bislak ta pigaw nin ipasepsep naya kumon kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bale' saray raruma wanra, “Heh! Pauryan ma! Kiten tamo pa no rumate' yan page' si Elias ta pigaw nin isalba naya.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tinma'way ya anamanan maksaw si Jesus, kaaram nauyos anay inanawa na. ");
INSERT INTO smkNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ket sa Timplo nan Dios, nabisang yan napiknga' nangibwat sa ta'gay anggan saroy a kurtina nin salimbeng nan Sangkasantusan nin Lugar. Rinmayon ya ket linumtak a bato. ");
INSERT INTO smkNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naabryan a pantyon tan abaw saray nati anan tutawo nan Dios a pinasubli' nin mabyay tan ");
INSERT INTO smkNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","sin pinasubli' yaynan mabyay si Jesus, linmiwa' sara sa pantyon ra nin nako sara sa Masanton Syudad a si Jerusalem tan abaw saray naka'kit konra. ");
INSERT INTO smkNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Si kapitan tan saray sundalo' nin itaw nin mampamantay kona ni Jesus, sin naaraman rayay rayon tan na'kit ray raruma et nin mampangyadi', pinasyan li'mo ra. Wanra, “Page' a anak nayaytin Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Main anamaet nin abaw nin bubbayin itaw sa dayo' a mampamantay. Tinmumbok sara kona ni Jesus nangibwat sa Galilea nin nagsirbin nangasikaso kona. ");
INSERT INTO smkNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Itaw sara si Maria nin taga Magdala, si Maria nin ina ra ni Santiago tan Jose, tan si ina ra ni Juan tan Santiago nin a'nak na ni Zebedeo. ");
INSERT INTO smkNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sin yabinayna, main nin sayay mayaman nin taga Arimatea a nakodtaw a say ngaran na Jose. Tumutumbok naya anamaet lamang ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nako ya kona ni Pilato nin nikidawat yan aburoy a kalapen nayay bangkay na ni Jesus. Ket si Pilato nibi nay aburoy kona. ");
INSERT INTO smkNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sin nakalap nayayna ni Jose a bangkay na ni Jesus, binarkot nayan ba'yo nin maputi' a mabistan klasin abel a mantawagen nin diilo, ");
INSERT INTO smkNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","tan nitabon naya sa pantyon nan diri. Sitin pantyon ket kapangali kona nin yukib ya sa bato a nisadya' yayna no mati ya si Jose. Kaaram nitulin nayan nisada' a sayay alakin bato sa purta nan si yukib mi'sa yayna nin nibwat. ");
INSERT INTO smkNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sin sain, itaw sara nin nakatekre' si Maria nin taga Magdala tan si sayay kapada nan Maria nin nakaadap sa pantyon. ");
INSERT INTO smkNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Napalabas yaytaw nin Awron Pananadya' sa Pistan Nipanglabas, saray Pupangulon Pupadi' tan saray Pariseo, nako sara kona ni Pilato. ");
INSERT INTO smkNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wanra kona, “Gubirnador, mapanemtem mi a wanan sitaw a magbalu'-balo' sin mabyay ya et a sumubli' ya kanon mabyay sa luob nin tuloy awro. ");
INSERT INTO smkNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanya' nin ipagwardyawan moya pan tuloy awro a nanabunan kona ta bangli' no saray tumutumbok na ket keen raya nin takawen a bangkay na mi'sa ra nin ibari-barita' a sinmubli' ya nin mabyay. Ket no mangyadi' a wanin mas masakit in et dyan say nu'nan nipangluko ra konran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Main ana!” wana ni Pilato, “Makauray kamoyna. Ipagwardyawan moyaynan mairot!” ");
INSERT INTO smkNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ket nako sara sa nanabunan kona ni Jesus. Tinimbryan rayay sada' nan pantyon tan nipagwardyawan raya ta pigaw nin masigurado ran kasa gapon makatege' kona. ");
INSERT INTO smkNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Napalabas anay Awron Painawa. Sin parbangon nin ararem nin Linggo, si Maria a taga Magdala tan si kapada nan Maria, kina' raya nin kinikit a nanabunan kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kapingmatan, bigra' yan rinmayon nin maksaw. Ket, si sayay anghil nan Dios kinmayupa' yan nangibwat sa langit; nitulin nayay baton sada' nan pantyon mi'sa naya nin tinekrean. ");
INSERT INTO smkNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Makapulag sa salag nin bara'mon kimat a bakas na tan say seket na ket pinasyan puti'. ");
INSERT INTO smkNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sin na'kit rayan gwardyan sundalo', nangingintar sara sa li'mo ra tan namaksir saran natumba sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ket sin wanin, wanan anghil konran bubbayi, “Andi' kamo nin mali'mo. Tanda' kon mantikapen moya si Jesus nin sitaw si nipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kasa yaynadti ta sinmubli' yan mabyay a bilang sa wana komoyo sin saytaw. Paradti ta pigaw nin ma'kit moyay nangipaidaan kona. ");
INSERT INTO smkNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sawanin, mako kamoynan apurawen moyo ta ibarita' moyoyti konran tumutumbok na, ‘Sinmubli' yaynan mabyay ket mu'na yaynadtaw sa Galilea. Itaw ket ma'kit moya.’ Andi' moyo nin lingwanan ti nin nibarita' ko komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ket nangapura saraynan nibwat itaw sa nanabunan. Mali'mo sara bale' pinasyan ririket ra. Palayo ran nako nangibarita' konran tumutumbok na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kapingmatan sinna' nasara ni Jesus. “Kumusta! Ani a idya moyo?” wana konra. Inmarak sara kona ni Jesus, nilukob ra sa adapan na tan gina'getan ray ayi na tan rinayo raya. ");
INSERT INTO smkNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Andi' kamo nin mali'mo,” wana konra. “Mako kamo konran tumutumbok ko nin para kongko ket bubsat kosarayna tan ibarita' moyon mako sara sa Galilea ta itaw kami nin misisna'.” ");
INSERT INTO smkNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sin nako saraynay bubbayi, main konran gwardya sa nanabunan a nako sa syudad tan nibarita' ra konran Pupangulon Pupadi' a nga'min nin nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Saray Pupangulon Pupadi' nag'iirgwan ra konran Mangatuntawo a gaw'en ra, mi'sa rasara nin binyan nin alakin pasuksok a sundalo'. ");
INSERT INTO smkNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wanra konra, “Ibarita' moyoy wanti e konran tutawo: ‘Sin nakaka'lek kami, nako raya nin tinakaw nin tumutumbok na ni Jesus a bangkay na.’ ");
INSERT INTO smkNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ket no bilang wadi' a matandaan nayti nin gubirnador, andi' kamo nin masalak ta si'kami anay makauray nin umbat a mapagustwan ya ta pigaw nin kai kamo nin mangno.” ");
INSERT INTO smkNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kanya' nin saray sundalo' ket kinalap ray kwarta tan ginwa' ray niyakay konra. Ket anggan sawanin, siin et a isturya nin nangyadi' a man'ibari-barita' ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Saray labinsayan tumutumbok na ni Jesus, nako sara sa talugtog itaw sa Galilea a bilang sa nibarita' nayna nin gindat ni Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sin na'kit rayadtaw si Jesus, rinayo raya, bale' main konra a nagdwadwa a si Jesus ya nin page'. ");
INSERT INTO smkNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kinmadani ya konran saray labinsaya si Jesus tan wana, “Sarban pakayadi' sa langit tan sa luta' ket naibi ana kongko. ");
INSERT INTO smkNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kanya' nin pag'inen moyo saran tumutumbok ko a tutawon mangibwat sa sarban grupon tutawo sa sarban lugar. Ket, sa kappako moyo konra, bawtismwan moyo sara sa ngaran nan Ama, nan Anak, tan nan Masanton Ispirito tan ");
INSERT INTO smkNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","iyakay moyo saran sumunor sa sarban nigan-gan ko komoyo. Ket tandaan moyo a si'ko, kalamo' moyokon pirmi anggan maka'numan.”");
INSERT INTO smkNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Siti a Mabistan Patanda' maipa'ka' kona ni Jesu-Cristo nin Anak nan Dios. Tumarana' ya ");
INSERT INTO smkNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","sa nikatukid nin nisurat na ni Prupita Isaias sa Masanton Kasuratan a wanan Catawan konan Anak na, “Si'ko, ibaki' koyan mu'nayna komo a tawo kon mangipatanda' nin maipa'ka' komo ta pigaw nin isadya' nay dalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ket “marnge' ya li' a sayay mampangita'wa-ta'way nin mampangipatanda' itaw sa lugar a ambo' nin matawo a wana, ‘Si'kamon tutawo, sadyaan moyoy irarate' nan Catawan, patu'riren moyoy dalanan na.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ket si Juan a mantawagen nin Mammawtismo, itaw ya anaod sa lugar a ambo' nin matawo nin pinata-patandaan nasaray tutawon inmarak a pagbabawian raynay duka' a gawa'-gawa' ra tan pabawtismo sara ta pigaw nin mapirduna sara. ");
INSERT INTO smkNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abaw saray nako nin nangrenge' kona nin nangibwat sa syudad nin Jerusalem tan sa prubinsya nin Judea. Ket sin nipatutuo ray kukasalanan ra, binawtismwan nasara sa Ilog Jordan. ");
INSERT INTO smkNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Say seket na ni Juan, ginwa' nangibwat sa sabot nin kamilyo tan binarkesan nan katat sa awak. Say kanen na anamaet, dudon tan inatip nin ngiwan sa tatalon. ");
INSERT INTO smkNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nibari-barita' na a wana, “Main nin sayay tawon rumate' iti a sumubray kongko. Sya ket, mas makapangyayadi' ya dyan si'ko a kai ako gapo nin kumana' nin mataman tanan mangwarwar nin kurdon nin sandalyas na. ");
INSERT INTO smkNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Si'ko, say man'ipamawtismo ko komoyo ket ranom; bale' sya, say ipamawtismo na komoyo ket si Ispirito nan Dios,” wana. ");
INSERT INTO smkNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sin kapresan nan mampamawtismo ni Juan, rinmate' yadtaw si Jesus nin nangibwat sa babalin Nazaret sa prubinsyan Galilea. Binawtismwan naya ni Juan itaw sa Ilog nin Jordan. ");
INSERT INTO smkNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ket tampor, sin inmarwas ya si Jesus sa ranom, na'kit ran niburwang a langit ket si Ispirito nan Dios a bilang yan kalapati, mangkumayupa' yan mako kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ket main anamaet nin busis a nangibwat sa langit nin kami'nan nan Dios a narnge' na. Wana, “Si'kay anak kon mangkawa-kawa'nanen ko. Napaririketan akon tuloy komo.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ket tampor si Ispirito nan Dios dinagdag nayan mako si Jesus sa kasan katawu-tawon lugar. ");
INSERT INTO smkNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ket itaw yan a'pat a pulo' a awro tan sugsugen nayan magkasalanan ni Satanas. Main itaw nin atap a uayep. Bale' main anamaet itaw nin uanghil a mampangasikaso kona. ");
INSERT INTO smkNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sawanin, sin mangkapriso ya si Juan, si Jesus anamaet ket nako ya sa prubinsyan Galilea nin nipata-patanda' nayay Mabistan Patanda' a nangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wana, “Narate' anay panaon nin pinili' nan Dios. Say pag'aadi' na ket dandani ana! Kanya' nin magbabawi' kamo tan gurutan moyoynay pangwa' nin kasalanan tan akuen moyaytin Mabistan Patanda'!” ");
INSERT INTO smkNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sin ni'sa a manlumalako ya sa rigrig nan Baybay Galilea, na'kit nasaray rwan mibsat nin maninilay, sara si Simon tan si Andres. Sin sain ket mampangikatkat saran eket. ");
INSERT INTO smkNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Kikalamo' kamo kongko,” wana ni Jesus, “ta gaw'en katamon maninilay, ambo' nin kuna' no kai edet, nin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ket tampor linakwanan ray eket ra tan nikikalamo' sarayna kona. ");
INSERT INTO smkNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kai sara et nakakadayo' nin tuloy, na'kit nasaray mibsat nin a'nak na ni Zebedeo a si Santiago tan si Juan. Itaw sara sa baluto ra a mampangunong saran eket ra. ");
INSERT INTO smkNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tampor nin kinayaban nasara anamaet ket linakwanan rayay ama ra tan saray tutawon inupaan ra sa baluto, ket nikikalamo' sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nako sara sa syudad nin Capernaum. Ket sin narate' anay Awron Painawa ran Judio, tampor nin nako sarayna si Jesus sa sinaguga tan nangyakay ya konran kapada nan Judio. ");
INSERT INTO smkNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naka'ngap saray tutawo sa no pa'non pangangakay na ni Jesus bana' ta say pangangakay na ket main nin pakayadi', ambo' nin bilang sa pangangakay ran Madudunong sa Gugan-gan ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Main nin sayay lalakidtaw a nasrepan yan ispiriton duka'. Kapingmatan anan ginmuryaw ya a ");
INSERT INTO smkNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wana, “Ah! Si'ka Jesus a taga Nazaret, ani ket a kabiangan mo komi? Nako kadti para ta pigaw nin sidaen nakami ana? Tanda' ko no si'no ka. Si'kay si Masantos nin nibaki' nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bale' ginan-gan naya ni Jesus a ispiriton duka' a wana, “Misasaet ka! Lumakwan ka kona!” ");
INSERT INTO smkNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Si ispiriton duka' ket pinamuluk-pulok nayay tawo, inmagsit yan maksaw mi'sa linmakwan yayna kona. ");
INSERT INTO smkNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Naka'ngap saray sarban itaw ket miirgu-irgo sara a wanra, “Peteg a naiduma yaytin ba'yon akay! Sitin tawo, main nin kapangyadian na mataman konran ispiriton duka' ta tumulok sara sa igan-gan na.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ket tampor, naibandu-bando a maipa'ka' kona ni Jesus sa intiron prubinsya nin Galilea. ");
INSERT INTO smkNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nangibwat sa sinaguga, tinmuloy yan tampor si Jesus tan saray tumutumbok na sa bali ra ni Simon tan Andres. Kalamo' rasara si Santiago tan si Juan. ");
INSERT INTO smkNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sin sain, si katyangan nan babayi ni Simon nakaida' yan mangka'mot, ket nibarita' rayti nin tampor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kinadanyan naya ket gina'getan nay gamet na tan binangon naya. Say amot na, kinumpa' nin tampor. Ket nagsirbi yaynay babayi konra. ");
INSERT INTO smkNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Sin sinumrep yaynay awro, nadinep sara sa ugsuran nan bali a sarba ran tutawo konan sitin babali. Inawit-awit rasara nga'min kona ni Jesus a main nin masakit tan saray nasrepan nin ispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ket abaw saray pinaanda' nan main nin nagsikabarang nin sakit, tan abaw sara anamaet a pinalakwan nan ispiriton duka'. Kai nasara nin inaburuyan ni Jesus nin mag'irgo a ispiriton duka' ta pigaw nin kai ra nin maipatanda' no si'no ya. ");
INSERT INTO smkNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Parbangon nin ararem et a lamang, nibangon yayna si Jesus tan nibwat yadtaw sa babali ket nako ya sa sayay lugar a matinek ket itaw dinmasal ya. ");
INSERT INTO smkNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ket si Simon tan saray kalalamo' na kinrap raya. ");
INSERT INTO smkNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sin nadumog raya, wanra kona, “Mantingkapen rakan tutawo!” ");
INSERT INTO smkNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ket wana, “Anaod. Bale' mako atamoyna sa kabaraybay nin bubabali ta pigaw nin itaw ket mangipatanda' ako anamaet, bana' ta sa sayti nin gagara a nako akodti.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ket naku-nako sara sa susinaguga ran Judio sa intiro nan prubinsyan Galilea nin nangipata-patanda' tan namalakwan yan uispiriton duka' konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ni'sa, main nin sayay tawon mampagmasakit nin duka' sa katat a mantawagen nin liprusi a kinmadani kona ni Jesus. Nanalimukod yayti sa adapan na tan nipainganga'do na, “No rabay moyo,” wana, “magwa' moyo nin maako' rako anamanaet nin tutawo a bilang sa gindat.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bana' sa inganga'do na ni Jesus, nipababo nayay gamet na konan lipruso tan wana, “O', rabay ko. Umanda' kayna.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ket sin sain anan lamang inmanda' yay tawo a rinminggas anay katat na. ");
INSERT INTO smkNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ket pinaibwat nayan tampor ni Jesus a tawo nin binibilin nayan maong ");
INSERT INTO smkNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a wana, “Mangrenge' kan maong. Andi' mo nin ibari-barita' ti nin nangyadi' sa si'numan, no kai, dumiritso kan mako konan padi' ta ipadar mon inmanda' kayna. Ket bana' sa nikapaanda' mo, mangida'ton ka sigon sa Gugan-gan nin nibi na ni Moises ta pigaw nin ipa'kit mo konra a man-gaw'en ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wanin man, si tawo, nibwat ya tan nibari-barita' nayna edet sa tutawo a ginwa' na ni Jesus kona. Ket bana' konan siti, abaw saray tutawon inmarak kona kanya' nin kai yayna nin basta-basta makapika' si Jesus sa nagsikabarang a babali, no kai edet, itaw ya sa lulugar a ambo' nin matawo. Wanin man, nako saran lamang a tutawo kona a nangibwat sa nagsikabarang a lulugar. ");
INSERT INTO smkNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Napalabas a umnoy awro, sinmubli' ya si Jesus sa Capernaum. Naibari-barita' a itaw ya sa balin mampiikapan na. ");
INSERT INTO smkNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ket sin sain, pinasyan ka'bawan ran tawon nadinep itaw a mataman sa liwa' nan purta ket kai nin makaseksek. Sin kapresan na ni Jesus nin man'ipapalaway konra a minsahi nin nangibwat konan Dios ");
INSERT INTO smkNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","main nin nirate' ran tutawo nin sayay lalakin lupoy a awit rayan a'pat nin katawo. ");
INSERT INTO smkNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ket sin kai sara nin makakadani kona ni Jesus bana' ta letletan ran tutawo, niyuli' raya sa bubong nin binutbot ray atep sa temben na ni Jesus, mi'sa raya nin niuy'oy nin nakaida' sa undayon na itaw sa adapan na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ket sin na'kit na a pagmamatalek ra kona, wana konan lupoy, “Amigo, napirduna anay kukasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sin sain, main itaw nin nakatekre' nin umno ran Madudunong sa Gugan-gan ran Judio. Mampangisip-isip sara a wanra sa nakem ra, ");
INSERT INTO smkNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mayin ket a sitin tawo ket mag'irgo yan wanin! Man'u'na-u'nawan nayay Dios! Anta si Dios tamo' nin bukod a makapamirdunan kukasalanan!” ");
INSERT INTO smkNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bale' tanda' na in ni Jesus nin iti sa nakem ra ket wana konra, “Mayin nin wanin a kaisipan moyo? ");
INSERT INTO smkNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wamoyo tana kumon ket mas magwa' et nin ibarita' konan lupoy a ‘Mibangon ka, awiten may undayon mo tan lumalako ka,’ dyan si ‘Napirduna ana a kukasalanan mo!’ ");
INSERT INTO smkNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ket, ta pigaw nin matandaan moyo a si'kon si Pinaitawo ket main nin pakayadi' kon mamirdunan kukasalanan iti sa luta',” ket wana ni Jesus konan lupoy, ");
INSERT INTO smkNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ibarita' ko komo: Mibangon ka. Awiten ma in si idaan mo ta sumubli' kayna komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ket nibangon yay tawo tan inawit nayaynay idaan na tan nibwat yayna nin nabantayan ra nga'min. Ket naka'ngap saran maong a tutawo ket rinayo rayay Dios a wanra, “Ni ka'numan, kai kami et gapo nin naka'kit nin bilang sa wanti!” ");
INSERT INTO smkNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ket sayay sakalakon awro, nako ya anamanaet si Jesus sa rigrig nin baybay. Abaw saray tutawo nin inmarak-arak kona, ket nangipapala-palaway yan minsahi nan Dios konra. ");
INSERT INTO smkNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ket ni'sa sin manlumalako ya, na'kit naya si Levi a anak na ni Alfeo nin nakatekre' itaw sa upisinan pammayadan nin buis. Wana ni Jesus kona, “Mag'in kan tumutumbok ko.” Inumdeng ya si Levi tan nayi ya kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ket sin nangan yadtaw si Jesus tan saray tumutumbok na sa bali na ni Levi, abaw saray maniningir nin buis tan ambo' nin rilihyuso a kadungo ra. Wanin ta abaw saray mantumumbok kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Main itaw nin Madudunong sa Gugan-gan a myimbron dupong ran Pariseo a na'kit raya si Jesus nin mangkidungon mangan konran ambo' nin rilihyuso tan maniningir nin buis, ket wanra konran tumutumbok na, “Ambale' a mangkidungo ya konran wanin a tutawo?” ");
INSERT INTO smkNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Narnge' nayti ni Jesus ket inubatan nasaran sayay alimbawa' a Pariseo. Wana, “Ambo' nin saray marigsa a makatkap nin duktor, no kai edet, saray main nin masakit. Kapada konan siin, nako akodti sa luta' nin mamagbabawi' konran makasalanan, ambo' nin konra nin kano ket matunong sara!” ");
INSERT INTO smkNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Main nin ni'sa, saray tumutumbok na ni Juan tan saray tumutumbok ran Pariseo ket kai sara nin mampangan ta saya ya in nin kaugalian ran Judio si magkulasyon. Ket main nin tutawo nin nako kona ni Jesus ket wanra, “Saray tumutumbok na ni Juan tan saray tumutumbok ran Pariseo ket magkulasyon sara. Ket ambale' nin saray tumutumbok mo, kai sara gapo nin mampagkulasyon?” ");
INSERT INTO smkNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wanan ni'bat ni Jesus konra nin sayay alimbawa', “No main nin kasal, kasan sapo nin saray kumbidado sa bansal ket kidungo saran mangan leg'an nan iti et nin nubyo konra. Kai gapo nin magwa' a magkulasyon sara. ");
INSERT INTO smkNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bale' rumate' li' a panaon a maikadayo' ya ket no saytaw li', magkulasyon sarayna.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wana et ni Jesus maipa'ka' sa ba'yon akay na, “Kasan tawon manali'neb nin ba'yon abel sa ma'ran a aysing. No gaw'en a wanin, si ba'yon abel kumsen ya li' ket guruyen naya a ma'ran ket maluod yay bisang na. ");
INSERT INTO smkNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wanin anamaet, kasan mangikwa nin mampibaliw nin arak sa ma'ran a katat nin supot a pangangwan, ta no gaw'en in, si mampibaliw nin arak tubraken naya, ket masida' yay supot tan mapirdin ma'met a arak. Matkap a say ba'yon arak ket ikwa sa ba'yon pangwan.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sayay awron Sabado a syay Awron Painawa ran Judio, manlumabas sara si Jesus sa gagawa'. Ket namursi-pursing saran rinakay nin trigo a tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ket main nin Pariseo a wanra kona ni Jesus, “Oy, kiten mosaray tumutumbok mo! Man-gaw'en ra in, anta maiyawa' nin mangyatab no Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ket wana yapo' ni Jesus, “Nalingwanan moyoyna palayi a nabasa moyodtaw sa Masanton Kasuratan maipa'ka' sa ginwa' na ni David nin mismo sin panaon a si Abiatar a Sangkata'gayan nin Padi'? Sin saytaw, nabitilan ya tan saray kalalamo' na ta kasaynan ikabyay ra, ket sinumrep ya sa Bali nan Dios tan kinnan nay tinapay a nida'ton konan Dios. Maiyawa' anaod a mangan nin saytin tinapay ta saray aburuyan tamo' nin mangan ket saray pupadi'. Bale' naaburuyan ya si David nin nangan tan binyan nasara anamaet a lamang a kalalamo' na.” ");
INSERT INTO smkNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wanan masusuyot ni Jesus, “Si Awron Painawa ket ginwa' ya para sa ikaabig nin tutawo, ambo' nin saray tutawo a mamaabig konan si Awron Painawa. ");
INSERT INTO smkNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ket anaod, si'kon si Pinaitawo, si'ko anamaet a lamang a makapangyayadi' maipa'ka' sa Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saya anamanaet nin wantin awro, nako ya anamanaet si Jesus sa sinaguga. Main nin sayay lalakidtaw a nati yay sayay takyay na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ket man'imatunan raya si Jesus nin saray kuntra kona no tambaren naya kasi mataman nin Awron Painawa, bana' ta mampaningkap saran padalan a maparsawan rayan mansumubag sa Gugan-gan. ");
INSERT INTO smkNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ket wana konan sitaw si lalaki, “Mako kadti sa adapan.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mi'sa wana konran tutawo, “Ani a aburuyan nin Gugan-gan tamo no Awron Painawa? Magwa' kasi a tumulong o a mamaidap? Magwa' kasi a mamabyay o a mangmati?” Nititinek sara tamo' bale'. ");
INSERT INTO smkNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ket masager ya bale' si Jesus a sinusa'sa nasaran pinastang. Wanin man, ka'dwan nasaran lamang ta kasan pakiingar ra sa kapada ran tawo. Ket wana konan lalaki, “Ipa'nat may takyay mo.” Nipa'nat naya ket tampor linmimpyo yay takyay na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ket linmiwa' saran tampor a Pariseo tan nako sara nin nikitarusan konran tutawo na ni Adi' Herodes no pa'non pammapati ra kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jesus tan saray tumutumbok na ket nibwat sara anamanaet nin nako sa rigrig nan Baybay Galilea. Abaw saran tuloy a tutawo nin tinmumbok konra a nangibwat sa prubinsya nin Galilea tan sa Judea, ");
INSERT INTO smkNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tan sa syudad nin Jerusalem, tan sa prubinsya nin Idumea, tan sa rubari' nan Ilog Jordan, tan sa lulibed nin syudad nin Tiro tan Sidon. Inmarak sarayti kona ni Jesus bana' ta narnge' ray maipa'ka' sa makapangyayadi' a gugawa' na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Abaw saran tuloy a tutawo kanya' nin pinangisadya' nasara ni Jesus nin ruranan nan baluto a tumutumbok na ta sali' no piraramu'yukan rayan saraytin abaw a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bana' ta abaw saray pinaanda' na, nileletletan sara sa libed na a tutawon main nin masakit ta pigaw tana nin makudit raya. ");
INSERT INTO smkNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ket barang sayay tawon nasrepan nin ispiriton duka' a maka'kit kona, lumukbob sara sa adapan na tan umagsit sara a wanra, “Si'kay Anak nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bale' binibilin nasaran maong ni Jesus a andi' ra nin ibarita' a syay Anak nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ket nako ya si Jesus sa lugar a pupurod. Nanagyat yan lulalakin mayi kona ket nayi sara. ");
INSERT INTO smkNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nanuyo' yan labinrwa sara konra a tinawag na anamaet nin apostoles ta pigaw nin kikalamo' sara kona tan ta pigaw nin ibaki' nasaran mangipata-patanda' nin minsahi nin nangibwat konan Dios a bilang sa man-gaw'en na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Binyan nasaran pakayadi' nin mamalakwan nin uispiriton duka' konran tutawon nasrepan ra. ");
INSERT INTO smkNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ket sarayti a labinrwan pinili' na: si Simon a pinangaranan nan Pedro, ");
INSERT INTO smkNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","saray a'nak na ni Zebedeo a si Santiago tan si Juan a pinangaranan nasaran Boanerges a say katarusan na ket Anak nin Kudor, ");
INSERT INTO smkNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago a anak na ni Alfeo, si Tadeo, si Simon a myimbro nin grupon ribulusyunaryo, ");
INSERT INTO smkNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tan si Judas Iscariote a syay magtraidor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sinmunor, sinmubli' sarayna sa bali. Abaw saraynaet a tutawon inmarak kona, kanya' nin kai nayna nin maadap a mangan ni Jesus tan saray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sin natandaan raytin kapamilyawan na ni Jesus, nako saradtaw ta pigaw nin kalapen raya ta wanran tutawo ket naluang yayna. ");
INSERT INTO smkNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wanra bale' nin saray Madudunong sa Gugan-gan a nangibwat sa Jerusalem, “Si Beelzebul a uunuren ran uispiriton duka', nasrep naya si Jesus. Ket sa tulong nan lamang, palakwanen nasara ni Jesus a ispiriton duka' konran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sin sain ket pinididinep nasara ni Jesus a tutawo tan wana konra a nangusar yan sayay pangingiyarig, “Pa'non sain a si Satanas ket palakwanen nay lalaman nan diri ey? ");
INSERT INTO smkNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kapada nin siin ket no bilang wadi' si sayay nasyon ket matau-tao ya tan milalaban saray tutawo na, kai ya nin magnayon. ");
INSERT INTO smkNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wanin a lamang no sa sayay pammali o babali ket, mapuruk-purok sara nin miaaway a saya tan saya, misisyay a pirat'anan ra. ");
INSERT INTO smkNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wanin anamaet no si Satanas ket mampalakwanen nasaray kapada nan uispiriton duka', say rabay nin irgwen ket mangkuntrawen nay kadiryan na. Kai edet nin mi'teng no kai magkamain nin anggawan a pakayadi' na. ");
INSERT INTO smkNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Si Satanas, kapada nayay sayay magsen nin tawo a kasan makasrep sa bali na ta pigaw nin kalapen ray kukayadian na no kai raya yapo' nin baruren in a magsen nin tawo. Ket no nabaror rayayna, magwa' rayna nin kalapen nga'min a rabay ra. ");
INSERT INTO smkNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ibarita' koyti komoyo: Mapirduna saray tutawo sa nagsikabarang a kukasalanan ra, pati sa animan et a duka' a irgwen ra konan Dios tan konran kapada ran tawo. ");
INSERT INTO smkNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bale' si si'numan a mag'irgon duka' maipa'ka' sa ginwa' nan Ispirito nan Dios, kasa gapo nin pakapirduna na no kai edet, kasalanan na in anggan-angga.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nibarita' nayti ni Jesus bana' ta wanra anaod ket nasrepan yaynan ispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sin rinmate' saradtaw si inay na tan saray bubsat na ni Jesus, tinma'gan saradtaw sa rikor tan nipakayaban raya. ");
INSERT INTO smkNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nalibed ya si Jesus nin tutawon nakatekre' ket wanra kona, “Si inay mo tan saray bubsat mo itaw sara sa rikor ket mandawaten ra a mako kadtaw konra.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ket wana ni Jesus, “O', tutuo. Itaw sara. Bale' saray alilbien ko nin ina ko tan bubsat ko ket sakalako sara.” ");
INSERT INTO smkNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pinastang nasaray tutawo sa libed na ket wana, “Sarayti a ina ko tan bubsat ko. ");
INSERT INTO smkNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ibarita' koy wanti ta si si'numan a man-gumwa' nin say rabay nan Dios syay ina o busat ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ni'sa, nako yaynaet si Jesus sa rigrig nan Baybay Galilea ta pigaw nin mangyakay ya. Pinasyan ka'bawan ran tawo nin inmarak. Kanya' nin rinmuran ya sa sayay baluto nin nakapundo ket tinmekre' yadtaw. Saray tawo anamaet itaw sara sa abay. ");
INSERT INTO smkNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nangusar yan pangingiyarig sa niyakay nan abaw nin bubagay konra. Wana, ");
INSERT INTO smkNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mangrenge' kamo! Main nin sayay magtatalon a nako nin nanabwag nin bini' sa luta' na. ");
INSERT INTO smkNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sin man'isabwag nay bini', main nin naika' sa dadalanan. Na'kit rayti nin manuk-manok ket kinnan ra. ");
INSERT INTO smkNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Main anamaet nin naika' sa babato a iti tamo' sa babo a luta'. Rinumsik nin tampor ta ababo a luta'. ");
INSERT INTO smkNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sin na'mutan, nalanes; ket bana' ta kai nin nakayamot nin ararem, nakri'! ");
INSERT INTO smkNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Main et nin naika' sa lugar a mantubuan nin madiwin didikot. Linmambot nin kinmubpal a madiwin dikot ket nadaeg ti. Kanya' nin kai nin nakabunga. ");
INSERT INTO smkNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ket main anamaet nin naika' sa madaem a luta'. Tinmubo' tan inmalaki, ket main nin ginmungan tulumpulo', main nin a'nem a pulo', tan main anamaet nin sanyasot.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wana et ni Jesus, “Si'kamon manrumnge', adalen moyoyti nin maong.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sin nagsiibwat saraynay tutawo, nabati' saray labinrwa pati saray raruman tumutumbok na. Tinepet ra kona no ani a rabay nan ibarita' nin sitaw si pangingiyarig na. ");
INSERT INTO smkNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wanan ni'bat ni Jesus, “Si'kamo nin peteg nin mantumumbok kongko, man'aburuyan nakamo nin Dios nin matandaan moyoy maipa'ka' sa pag'aadi' na a kai et nin nipatarusan nangibwat sin nu'na. Bale' konran raruma a kai sara nin tumulok kongko, naibi a pangingiyarig ");
INSERT INTO smkNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta pigaw nin sa wanin ket matandaan nin ‘Kikiten rayna man nin kikiten ket kai ra nin mangkaipurok a mangka'kit ra, tan marnge' rayna man nin marnge' bale' kai ra nin man'adalen a pipa'kaan nin mangkarnge' ra ta no ambo' nin wanin, mapaba'yo kumon a nakem ra tan mapirduna sara.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mi'sa wana ni Jesus konra, “Kai moya para nin mataros tin pangingiyarig? No wanin, pa'no moyo edet nin mataros a raruma et nin pangingiyarig ey?” ");
INSERT INTO smkNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Wanti na e: Say nisabwag nan magtatalon ket Sarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Saytaw say dadalanan a naikaan nin bini' ket sara a tutawo a nakarnge' sa Sarita' nan Dios. Bale' kapingmatan nako ya konra si Satanas ket nipalingwanan na konra a narnge' ran Sarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Saytaw anamaet say babato a naikaan nin bini', sara a tutawon maririket nin nakarnge' sa Sarita' nan Dios tan inako' ran tampor. ");
INSERT INTO smkNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bale' kai nin nakayamot konra ket kai nin nagnayon ta sin mangirangep sarayna nin pakapaidap tan pammadya'dya' bana' sa nipangrisibi ran Sarita' nan Dios, rinmay'ep sara ket ginurutan rayna. ");
INSERT INTO smkNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Saytaw anamaet say no adti main nin tinmubo' nin madiwin dikot a naikaan nin bini' ket sara et a tutawon mampangrenge' sa Sarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bale' bana' ta kaaburidwan ray kabibyay ra, tan nu'na-nu'nay apes ran yumaman tan magkamain nin nagsikabarang a bubagay, ket nadaeg nin sain a apes ran tumulok sa Sarita' nan Dios, kanya' nin kai ginmunga sa byay ra. ");
INSERT INTO smkNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ket saytaw anamaet say madaem a luta' nin naikaan, sara a tutawo nin nangrenge' sa Sarita' nan Dios. Ket rinisibi rayti ket nagtrabaho sa byay ra ket ginmunga nin bilang bini' a main nin ginmungan tulumpulo', a'nem a pulo' tan sanyasot.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wana et ni Jesus konra, “Main paran manulsol nin lampadawan mi'sa naya nin sakban nin salop o ikwa sa sirong nan katri? Kasa! No kai ikwa nayaynaod sa sayay pangngitukduan. ");
INSERT INTO smkNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wanin anamaet sa pangungusar kon pangingiyarig ta sarban adi sawanin ket mag'in li' nin mapala-palaway tan say sikrito anamaet sawanin ket matandaan li'. ");
INSERT INTO smkNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kanya' anaod nin si'kamon mampangrenge', adalen moyoy pipa'kaan nin saytin nibarita' ko!” ");
INSERT INTO smkNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Adalen moyon maong a marnge' moyo ta no wanin, padmangan nan pakataros nin Dios a pangrerenge' moyo tan ana edet lamu'nan na et a pakataros moyo. ");
INSERT INTO smkNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Anaod, si tawon man'ipamuspusan nan matarusan a narnge' na, say pakataros na ket malamu'nan; bale' si tawon kai na rabay nin tarusan, mataman nin say tanda' na ket mag'in nin kasa.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nami ya anamana nin sayay pangingiyarig si Jesus. Wana, “Say pag'aadi' nan Dios ket maiyarig sa mangyadi' no manabwag yan bini' a sayay magtatalon sa mantalunen na. ");
INSERT INTO smkNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mayadi' na nin gaw'en in, pauryan nayna ket ituloy nayna a man-gaw'en nan inawru-awro. Ket rinumsik tana a bini' tan inmalaki. Si magtatalon, kai na nin tanda' no pa'noy nikagwa' nin sayti. ");
INSERT INTO smkNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Si luta' a namatubo' sa mula. Primiro rumsik, mi'sa gumulong ket ambo' nin ma'teng gumunga. ");
INSERT INTO smkNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ket no matua anay bunga, ipayatab nayna ta narate' anay panaon nin pangyayatab.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wana et ni Jesus, “Ani et bale' a usaren kon pangngiritrato sa pag'aadi' nan Dios, o ani et a pangiyarigan ko? ");
INSERT INTO smkNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Say iyalawang nin pag'aadi' nan Dios ket maiyarig sa bikoy nin mustasa a sangkadaitean sa sarban bikoy iti sa mundo. Bale' no naimula yayna, ");
INSERT INTO smkNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tumubo' ya ket mag'in yan sangkaalakyan sa sarban pupising. Sumanga yan alalaki ket saray manuk-manok, umapon sara kona tan mipugar sara sa sirong nin susanga na.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Abaw et a wantin pangingiyarig a inusar na ni Jesus sa pangangakay na sigon sa angan-anganen nan mababa' ran tarusan. ");
INSERT INTO smkNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kasan niyakay na konran tutawo a kai ya nangusar nin pangingiyarig. Bale' no sara-sara tamo' tana nin tumutumbok na, ipapalaway nay sarba konra. ");
INSERT INTO smkNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sin yinmabi, wana ni Jesus konran tumutumbok na, “Sumaki atamon makodtaw sa rubari'.” ");
INSERT INTO smkNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ket rinmuran saraynay tumutumbok na sa baluto ta itaw yaynan gindat si Jesus. Ket linakwanan rasaray tutawo. Main anamaet nin nikialuyon konra nin raruman bubaluto. Sin kapresan ran mansumaki, ");
INSERT INTO smkNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","kapingmatan tribunada ana. Mangkaspakan yaynan daluyon a baluto ra kanya' nin mangkapno' yaynan ranom. ");
INSERT INTO smkNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sin sain, si Jesus, mampa'lek ya nin nialunan itaw sa ulin. Ket, pinukaw raya a wanra, “Maistro, kasa para nin kwinta komo a manlumdeg atamoyna?” ");
INSERT INTO smkNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ket nibangon ya mi'sa naya nin ginan-gan a tribunada a wana, “Tumgen ka!” tan wana konan taaw, “Pakatinek ka!” Ket tinumgen yay tribunada tan tinminek yay taaw. ");
INSERT INTO smkNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ket wana konran tumutumbok na, “Aninay katakrutan moyo! Kasa et nin pagmamatalek moyo!” ");
INSERT INTO smkNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pinasyan li'mo ra ket wanra sa saya tan saya, “Ani yaytin tawo a mataman nin si tribunada tan say daluyon ket tumulok kona!” ");
INSERT INTO smkNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ket nakarate' saradtaw sa rubari', sa lugar ran Geraseno. ");
INSERT INTO smkNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sin inmarawas ya si Jesus sa baluto, tampor a main nin sayay lalakin ibat sa yuyukib nin pannabunan a sinumna' kona. Sitin lalaki, nasrepan yan ispiriton duka' ");
INSERT INTO smkNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tan mampiikap yadtaw sa yuyukib nin pannabunan. Kai ya gapoyti nin mabaror mataman et nin kadina a usaren nin ipamaror kona. ");
INSERT INTO smkNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Anaod, ni'no rayayna nin binaror sa ayi tan gamet, bale' ni'nu-ni'no nayna nin binulsot a kadina tan binari' a pusas. Pinasyan kasaw na ket kasa gapo nin makapangipukpok kona. ");
INSERT INTO smkNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Awro tan yabi ket itaw ya sa tutalugtog tan sa pannabunan a tuma'wa-ta'way ya tan sugat-sugaten nan bato a lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sin naalilbi' nayayna si Jesus itaw et sa adayo', nalayo yan sinumna' tan nanalimukod ya sa adapan na. ");
INSERT INTO smkNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ket wanan niburyaw, “Jesus, Anak nan Sangkata'gayan nin Dios, ani ket a kabiangan mo kongko? Isamba mo sa adapan nan Dios a kai nako nin padya'dyaen!” ");
INSERT INTO smkNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nibarita' na a wanin ta si Jesus ket ginan-gan nayayna a wana, “Ispiriton duka', lakwanan maytin tawo!” ");
INSERT INTO smkNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tinepet na ni Jesus kona, “Ani a tawag komo?” Ket wana, “Say tawag kongko ket Rinibu-ribo ta si'kami, abaw kamin tuloy.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ket sin sain, nipainganga'do na kona ni Jesus a andi' nasara nin palakwanen konan sitaw a lugar. ");
INSERT INTO smkNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sin sain, main nin abaw nin tuloy nin baboy a mampangan-pangan sa rigrig nin talugtog itaw. ");
INSERT INTO smkNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wanan nipainganga'do nin ispiriton duka' kona ni Jesus, “Aburuyan mo tana pa a sumrep kami konran baboy.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ket wana mako sarayna edet. Kanya' nin linmiwa' sara kona nin lalaki tan sinumrep sara konran baboy. Nangimros saray baboy a magrwanribo sara ka'baw, nin namunta sara sa kikiras sa temben nin baybay. Ket nanabo' sara tan nirebreb sara nga'min. ");
INSERT INTO smkNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ket saray mampangalila' konran baboy, nagsipalayo sara tan nibari-barita' ray nangyadi' sa babali tan sa bubaryo. Saray tutawo nagsipako sara nin kumikit sa nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nako sara kona ni Jesus ket na'kit rayaytaw si tawon ibwatan ran rinibu-ribo nin ispiriton duka'. Mantumekre' ya tan nisket yayna tan limpyo anay pangingisip na. Ket linmi'mo sara sa nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Saray naka'kit nin mismo sa nangyadi', inistu-isturya ra konran raruman tutawo a nangyadi' konan tawo tan konran baboy. ");
INSERT INTO smkNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ket saray tutawo, dinawat-dawat ra kona ni Jesus a lumakwan yayna sa lugar ra. ");
INSERT INTO smkNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sin manrumuran yayna si Jesus sa baluto, sitaw si tawon ibwatan nin uispiriton duka', dinawat na a mayi kona. ");
INSERT INTO smkNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bale' kai naya nin inaburuyan ni Jesus a wana kona, “Sumubli' kaynadtaw komoyo ket ibarita' mo konran kabbali mo a sarban ginwa' nan Catawan komo tan no pa'noy nipanginga'do na komo.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ket nibwat yaynay tawo tan naku-nako ya sa intiron sakop nin Mapulo' a Bubabali a mantawagen nin Decapolis. Nika' na nin nibari-barita' nga'min a ginwa' na ni Jesus kona, ket naka'ngap sara nga'min a nakarnge'. ");
INSERT INTO smkNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sin sinmaki saraynaet si Jesus nin sinmubli' sa rubari', abaw saray tawon inmarak konadtaw sa rigrig nin baybay. ");
INSERT INTO smkNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ket main nin sayay pangulo nin sinaguga a rinmate' itaw nin say ngaran na ket Jairo. Sin na'kit naya si Jesus, nitalimukod na sa adapan na ");
INSERT INTO smkNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tan nikidawat yan inganga'do para konan gumalasitang nin anak na a wana, “Mangkamati yay anak ko. Mayi ka tana kadi' sa bali ko tan ipababo moy gamet mo kona ta pigaw nin umanda' ya tan mabyay ya et.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ket nayi ya si Jesus kona. Pinasyan ka'bawan ran tawon nayi-nayi kona a nileletletan raya. ");
INSERT INTO smkNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Main anamaet nin babayidtaw nin nalabas a reges nin karirigla na sa luob nin labinrway taon ana. ");
INSERT INTO smkNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mampangirangep ya sa katatambar ra kona nin abaw anan duktor. Na'pos anay main na sa kapapatambar na, bale' kai ya nin inmanda' no kai naluod yayna edet a masakit na. ");
INSERT INTO smkNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nakarate' kona a maipa'ka' kona ni Jesus. Kanya' nin nikiletletan ya konran tutawo anggan nakakadani ya sa gurot na ni Jesus ket kinudit nayay aysing na ");
INSERT INTO smkNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ta wana sa nakem na, “Makudit ko tanay aysing na ket umanda' akoyna.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ket kinudit naynaod a aysing na ni Jesus. Tampor nin tinumgen a kadadaya' na tan naingar na a limpyo yayna. ");
INSERT INTO smkNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sin sain, naaraman naynamaet ni Jesus nin linmiwa' kona a pakayadi'. Ket nibring yan inmadap konran tutawo ket wana, “Si'noy nangudit nin aysing ko?” ");
INSERT INTO smkNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanran tumutumbok na kona, “Maistro, mangka'kit moyna anaod nin abaw a tawo a mampileletletan raka, ket ambale' a tepeten mo et a wamo, ‘Si'noy nangudit kongko?’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bale' pasta-pastang ya si Jesus ta pigaw nin kikiten na no si'noy nangudit kona. ");
INSERT INTO smkNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sitaw si babayi, bana' ta tanda' nay nangyadi' kona, kinmadani ya kona ni Jesus nin mangingintar ya bana' sa li'mo na. Nanalimukod ya sa adapan na ket nibarita' na a sarba kona. ");
INSERT INTO smkNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wana ni Jesus kona, “Arikong, bana' sa pagmamatalek mo inmanda' kayna. Mako kayna nin matinek anay kaisipan. Inmanda' kayna nin liso konan masakit mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sin kapresan nay mampag'irgo et ni Jesus ket main nin rinmate' nin ibat sa bali na ni Jairo a wanra, “Andi' mayna nin mulistyawen et si Maistro ta nati yaynan lamang a anak moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bale' narnge' nayti ni Jesus ket wana kona ni Jairo, “Andi' ka nin mapaga; basta magmatalek ka.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ket kasan inaburuyan nan mayi kona no kai si Pedro tan saray mibsat a Santiago tan Juan tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ket nakarate' sara sa bali nan si pangulo nin sinaguga. Na'kit na ni Jesus a gewgewan, a main nin mampangabet-abet tan man'umakis nin maksaw. ");
INSERT INTO smkNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sinumrep ya sa bali tan wana konra, “Ambale' tin gewgewan? Ambale' a mampangabet-abet kamo? Kai ya nin nati; mampa'lek ya tamo'.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ket kinaka'lisan rayan panuya'-tuya' kona nin tutawo. Sin sain, pinaliwa' nasara nga'min. Mi'sa kalamo' nasaray matua nan anak tan saray tulon kalalamo' na linmuob ya si Jesus sa kwarton kami'nan nan anak. ");
INSERT INTO smkNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gina'getan nay gamet na tan wana kona sa sarita' ran Hebreo, “Talita, kumi,” a say katarusan, “Naning, mibangon ka.” ");
INSERT INTO smkNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ket tampor nin nibangon yay anak ket linmalako ya. Si anak ket labinrway taon na. Ket nga'min ra naka'ngap nin maong. ");
INSERT INTO smkNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Binibilin nasaran maong ni Jesus nin andi' rayti ibarita' abirno sa si'numan. Mi'sa nigan-gan nan byan rayan kanen a anak. ");
INSERT INTO smkNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ket sawanin, nibwat ya konan sitaw nin lugar si Jesus tan sinmubli' ya sa Nazaret a syay mismon babali na, kalamo' nasaray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sin narate' a Awron Painawa, nangyakay ya sa sinaguga. Abaw saray naka'ngap nin nakarnge' kona. Wanra, “Ya, adti ya kano in ket nag'adal? Pa'no ya in nin nagkamain nin wanin a kadunungan? Pa'no ya nin makagwa' nin wanin a milagro? ");
INSERT INTO smkNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ambo' ya tamo' paran sayay karpintiro in? Kai para a si Maria a ina nan siin tan kaka raya ni Santiago, Jose, Judas, tan Simon? Kai para a saray ari nan bubbayi ket iti saran gindat nin mampiikap?” Ket kasa gapo nin kwinta na konra tan kai sara nin namper kona. ");
INSERT INTO smkNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wanan nibarita' ni Jesus konra, “Rispitado yay sayay prupita abirno nin adti pwira tamo' sa mismon babali na, konran kukanayon na tan mismon konran iti sa pamilya na.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Main tamo' nin umno ra a tutawo nin main nin masakit a nipababo nay gamet na konra ta pigaw nin paandaen nasara. Bale' kai yadtaw nin nakagwa' nin abaw nin milagro ");
INSERT INTO smkNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ta kai sara nin mamper kona. Maka'ngap yan tuloy si Jesus ta kai sara nin namper kona a kababalyan na. Kina'-kina' na ni Jesus a abaw a bubaryo nin niyakay-akay nasaray tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kinayaban nasaray labinrwan tumutumbok na ta pigaw nin ibaki' nasaran sirwarwa sa saka-sakalakon lugar. Binyan nasaran pakayadi' nin mamalakwan nin ispiriton duka' ");
INSERT INTO smkNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","tan binibilin nasara a wana, “Sa saytin pako moyo, andi' kamo nin mangi'ras nin animan, no kai kal-la baston tamo'. Andi' kamo nin mibalon nin kanen, bag, kwarta ");
INSERT INTO smkNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","o aysing a pisilyan moyo. Bale' misandalyas kamo,” wana. ");
INSERT INTO smkNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“No sa sayay babali ket sagyaten rakamo sa sayay bali, miikap kamo konan siin nin bali anggan mibwat kamo. ");
INSERT INTO smkNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bale' no rumate' kamo sa sayay lugar ket kai rakamo nin pagtuluyen o kai sara nin rumnge' komoyo a tutawo, mibwat kamodtaw tan pagpagen moyoy ta'pok sa dapa nin ayi moyo nin mangipataros a madusa sara li' sa sain a ginwa' ra.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ket nako saraynay labinrwan tumutumbok na tan nipatanda' ra konran tutawo a matkap ray magbabawi' tan gurutan raynay pagkakasalanan ra. ");
INSERT INTO smkNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pinala-palakwan rasaray uispiriton duka' konran tutawo nin nasrepan ra tan abaw saray mampagmasakit a inamrisan ran ladak ket pinaanda' rasara. ");
INSERT INTO smkNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sin sain, si Gubirnador Herodes, natandaan nay maipa'ka' sa gugawa' na ni Jesus bana' ta bandunado ya bana' sa sayti. Main saray mangibarita' a wanra, “Sya si Juan a Mammawtismo nin sinmubli' nin mabyay. Ket anaod, main nin pakayadi' nan mangwa' nin mumilagro.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Main anamaet nin wanra, “Sya si Elias a prupita na intaw nin Dios.” Main et anamaet nin raruma a wanra, “Sayay prupita ya nin bilang konran prupita sin nu'nan panaon.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sin narnge-narnge' na anaod ni Herodes a maipa'ka' kona ni Jesus wana, “Piho! Sya in si Juan. Pinutulan koyaynan ulo; sya e bale' nin sinmubli' yan mabyay!” ");
INSERT INTO smkNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wanin a nibarita' na ni Herodes ta intaw ket nipadakep naya si Juan tan nipapriso tan nipakadinawan naya bana' kona ni Herodias. Siti si Herodias ket asawa naya ni Felipe a ari na ni Herodes ket sawanin asawa nayayna ni Herodes. ");
INSERT INTO smkNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Wana intaw nin nibari-barita' ni Juan kona ni Herodes, “Abas a i'yan may aydo mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kanya' nin sinmakit a nakem na ni Herodias kona ni Juan tan rabay nayan patyen. Bale' kai na nin magawa'-gawa' ");
INSERT INTO smkNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ta si Herodes ket man'igalang naya si Juan ket mamprutiktawan naya ta tanda' nan matunong tan makaDios yan tawo. Magulo a kaisipan na no marnge' nay papalaway na ni Juan bale' rabay-rabay naya et a lamang nin reng'en. ");
INSERT INTO smkNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bale' rinmate' a pagkanawanawa na ni Herodias sin awron nikaiyanak na ni Herodes ket namapunsya ya, tan sinagyat nasaray atata'gay nin upisyal nin gubyirno tan saray atata'gay nin upisyal nin sundalo' tan saray atata'gay nin tutawo sa Galilea. ");
INSERT INTO smkNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Si anak nan balasang, a say ngaran nan lamang ket Herodias, sinumrep ya tan dinmukdok yadtaw sa kami'nan na ni Herodes tan saray bubisita na. Ket napagustwan ya si Herodes tan saray bubisita na. Kanya' nin wana kona, “Dawaten mo kongko a animan a rabay mo ket ibi ko komo.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wana et a sinambawan na, “Animan a dawaten mo kongko, ibi ko komo; mataman et say kapiknga' nin say main ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ket linmiwa' yay balasang nin nako ya tinmepet konan ina na, “Ani ey a dawaten ko?” Ket, “Si ulo na ni Juan a Mammawtismo,” wanan ina na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ket tampor nin sinmubli' ya a balasang kona ni Herodes ket wana, “Rabay kon ibi ma kongko sawanin ana nin mismo nin naikwa sa plato a ulo na ni Juan a Mammawtismo.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nagbabawian nan maong ni Herodes a nipangako' na, bale' matkap nan tukiden bana' ta say nipagpangako' nan sinambawan na ket narnge' ran bubisita na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ket tampor a nibaki' nayay sayay bantay a ginan-gan nayan awiten naya kona a ulo na ni Juan. Sinunor nayan sundalo' ket pinutol nayay ulo na ni Juan itaw sa priswan. ");
INSERT INTO smkNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mi'sa nikwa nayay ulo sa plato ba'yo nibi naya konan balasang. Nibi nayaynamaet nin balasang konan ina na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sin saray tumutumbok na ni Juan ket natandaan rayti nin nangyadi', kina' raya nin kinalap a bangkay na tan nitabon raya. ");
INSERT INTO smkNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sawanin, saraytaw saray apostoles nin nibaki' na ni Jesus nin mangyakay, sinmubli' sarayna tan nibarita' ra kona ni Jesus a nga'min nin nagwa' tan naiyakay ra. ");
INSERT INTO smkNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Misusubray saraynaod nin rumate' tan mibwat a abaw a tawo nin mako konra kanya' nin kasaynan tyimpo ran mangan. Ket wana ni Jesus konran labinrwa, “Mako atamoyna sa sayay lugar a kasan tawo ta pigaw nin painawa kamo nin buga'.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanya' nin nibwat saran rinmuran sa baluto nin sara-sara tamo' a mako sara sa sayay lugar a kasan tawo. ");
INSERT INTO smkNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bale' abaw saray naka'kit konra nin nibwat tan naalilbi' rasara. Kanya' nin saray tutawo sa sarban bubabalidtaw ket palayo ran nako sa keen ra ni Jesus ket nakarate' saradtaw nin nu'na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sin nakaabay sarayna si Jesus, na'kit nasara a itaw nin abaw nin tawo. Maka'dwan yan tuloy konra ta bara'mo saran karniro nin kasan mangipastor konra. Ket niyakay nasaran maipa'ka' sa abaw a bubagay. ");
INSERT INTO smkNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sin dumedlem ana ket kinmadani saray tumutumbok na kona a wanra, “Mandumedlem ana ket kasa pa et nin bubalidti, ");
INSERT INTO smkNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","kanya' nin paibwaten mosara nin mako sa kabaraybay nin bubaryo ket makasaliw saran kanen ra.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bale' wana ni Jesus konra, “Si'kamoynay mamin ma'kan ra.” Ket wanra, “Adti kami kadi' nin makasaliw nin tinapay a gumli ana nin ribu-ribo ta pigaw nin ipakan konra?” ");
INSERT INTO smkNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ket nitepet na ni Jesus, “Umno ray tinapay a main? Keen moyo pa nin kikiten,” wana. Sin ibat rayna nin kinikit ket wanra, “Lima ray tinapay tan rwa ray kuna' tamo'.” ");
INSERT INTO smkNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nigan-gan na konra a patekreen rasara nga'min a tutawo nin nagrupu-grupo sa rarabot. ");
INSERT INTO smkNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kanya' nin tinmekre' sara nin sisa'sanyasot tan sililimampulo'. ");
INSERT INTO smkNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inagwang na ni Jesus a liman tinapay tan saray rwan kuna' mi'sa ya tinmangar sa langit ket nikisalamat ya konan Dios. Mi'sa tinau-tao nayti tan nibi na konran tumutumbok na nin itayak ra konran tutawo. Tinau-tao nasara anamaet a rwan kuna' para konran sarban tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ket nakapangan sara nga'min a tutawo tan nabsoy sara. ");
INSERT INTO smkNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dininep ran tumutumbok a tara' nin tinapay tan kuna', ket main nin labinrwan balyag. ");
INSERT INTO smkNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Saraytaw saray nangan, limanribo sarayna, saray lulalaki tamo' et. ");
INSERT INTO smkNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kaaram, pinaruran nasarayna ni Jesus a tumutumbok na sa baluto tan pinau'na nasaraynan mako sa rubari' sa babali nin Betsaida leg'an nasaran pinaibwat a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ket sin napaibwat nasarayna, nako ya sa sayay talugtog ta pigaw nin dumasal yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sin narate' anay yabi, itaw yaynay baluto a manruranan ran tumutumbok na sa butlay nin taaw ket si Jesus, itaw ya et nin bukud-bukod sa tangkar. ");
INSERT INTO smkNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na'kit na ni Jesus a mangkapaidap saran mansumaki ta sungsong yay siri. Sin bandan parbangon, tinmumbok ya konra nin manlumalako ya sa babon ranom. Ampadan nasarayna kumon ta pigaw nin mayi yayna konra. ");
INSERT INTO smkNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bale' na'kit ra nga'min a main nin manlumalako sa babon ranom ket nita'way ra bana' ta nipa'ka' ran lampong ya. ");
INSERT INTO smkNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pinasyan li'mo ra. Tampor nin nag'irgo ya si Jesus konra a wana, “Andi' kamo nin mali'mo! Si'koyti. Paksawen moyoy nakem moyo!” ");
INSERT INTO smkNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Rinmuran ya sa baluto ket linumteng. Ket naka'ngap saran maong a tumutumbok na ");
INSERT INTO smkNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ta kai ra gapo nin natarusan a pipa'kaan nin nipamaka'baw na intaw ni Jesus sa saytaw say tinapay tan kuna'. Wanti bana' ta kai ti et maabot nin pakataros ra. ");
INSERT INTO smkNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sin nakaripay sarayna nin nakarate' itaw sa lugar nin Genesaret, niyabay rayay baluto. ");
INSERT INTO smkNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sin nakaarawas sarayna, saray tutawodtaw, naalilbi' rayan tampor si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ket apurado sara nin naku-nako sa intiro nan sitaw nin lugar. Ket inawit-awit rasaray mampagmasakit nin nakaida' sa apay ra sa adtiman a narnge' ran kami'nan na. ");
INSERT INTO smkNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ket adtiman a kami'nan na ni Jesus, sa bubabali man, o sa bubaryo o sa lulugar a basta main nin bubali, saray main nin masakit ket ipai-paida' rasara nin tutawo sa puplasa, tan ipainganga'do ra kona a mataman no ipakudit na tana konran main nin masakit a saroy nin seket na. Ket sarba ran nakakudit kona, inmanda' sara. ");
INSERT INTO smkNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ni'sa, main nin Pupariseo tan Madudunong sa Gugan-gan ran Judio a rinmate' nin ibat sa Jerusalem a nako kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na'kit rasaray umno ran tumutumbok na ni Jesus nin mampangan ana, bale' kai ra nin ginwa' a sigon sa kaugalian sa rilihyon ran Judio a busbusan ra yapo' nin ranom a gamet ra. ");
INSERT INTO smkNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Anaod, sarba ran Judio, lalo saraynay Pariseo, kai sara nin mangan no kai ra yapo' nin busbusan nin ranom a gamet ra nin sigon sa akay ran pupuon ra. ");
INSERT INTO smkNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mataman et nin no ibat sara sa palingki, no kai ra yapo' nin warsikan a sinaliw ra kai sara nin mangan. Abaw et a raruman kaugalian nin naimatawan ra konran pupuon ra nin mantumbuken ra bilang sa pangunguyas nin inuman, pangangwan, tan panglutuan. ");
INSERT INTO smkNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kanya' nin tinepet ra kona nin saraytin rinmate' a wanra, “Ambale' a kai ra nin mantumbuken nin saray tumutumbok mo a uakay a naimatawan tamoyna nangibwat et konran pupuon tamo? Basta mangan sarayna nin kai ra tumbuken a manepeg nin pammusbos ranom sa gamet!” ");
INSERT INTO smkNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ket ni'bat na ni Jesus konra, “Kustoy nipadles na ni Prupita Isaias maipa'ka' komoyo. Mampisantu-santos kamoynaod nin bilang sa wanti sa nisurat na sa Masanton Kasuratan a wana: ‘Saraytin tutawo,’ wanan Dios, ‘raywen rako sa irgo, bale' say kukanakman ra ket adayo' nin tuloy kongko. ");
INSERT INTO smkNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kasan kakanaan nin pangrarayo ra kongko ta uakay ran diri a man'ipatukid ra nin bara'mo nin gugan-gan ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Peteg a pigagawa' moyoyti say wana ni Isaias ta man-gaw'en moyon kasan kwinta a nigan-gan nan Dios bale' mantumbuken moyoy kaugalian nin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wana et ni Jesus, “Pinasyan anda' nin padalan moyo sa nipangwa' moyon kasan kwinta sa nigan-gan nan Dios sa tanay matumbok moyoy uakay ran pupuon moyo ");
INSERT INTO smkNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ta wanti e: Si prupita Moises, nisurat na a wana nin Dios, ‘Igalang ma si ama mo tan si ina mo,’ tan wana, ‘Si si'numan a mamaduka' nin ama o ina na, kasan sapo nin patyen ya.’ ");
INSERT INTO smkNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bale' si'kamo, say man'iyakay moyo ket sakalako. Bilang konan siti e: Konan sayay tawo, sa magwa' nan ibin tulong konran mangatua na, wamoyo ket ibada' nayna konra a sayti ket nigagara nayna nin ida'ton konan Dios kanya' nin kai na anayti nin maibi nin tulong konra. ");
INSERT INTO smkNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ket sa sain nin akay moyo kai yayna nin maaburuyan nin ikana' na in konran mangatua na. ");
INSERT INTO smkNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yupa' sa sain nin uugali' a man'iyakay moyo, man-gaw'en moyon kasan kwinta a Sarita' nan Dios. Anaod, abaw et a wanti nin man-gaw'e-gaw'en moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pinakadani nasara ni Jesus kona a abaw nin tutawon itaw tan wana konra, “Reng'en rako nga'min tan tarusan moyoy ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ambo' a say sumrep konan sayay tawo a puon nin pagkakasalanan na, no kai say duka' a mangibwat sa nakem na. ");
INSERT INTO smkNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kanya' anaod nin si'kamon mampangrenge', adalen moyoy pipa'kaan nin saytin nibarita' ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Linakwanan nasara ni Jesus a tutawo tan linmuob ya sa bali. Tinepet ran tumutumbok na no ani a rabay nan ibarita' konan sitaw si wana. ");
INSERT INTO smkNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ket wana ni Jesus, “Ani, kapada ran raruma ket kai kamo et nin makataros? Kai moyo para nin maamingaw a say sumrep konan sayay tawo ket ambo' in a mamagkasalanan kona? ");
INSERT INTO smkNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wanin ta say kanen ket kai nin mako sa nakem na no kai edet, sa tyan na ket lumiwa' a lamang.” Konan siin nipatarusan na ni Jesus a sarba nga'min nin ma'kan ket kai nin mamagkasalanan no kai edet, magwa' nin kanen. ");
INSERT INTO smkNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wanan nituloy ni Jesus, “Say mangibwat sa nakem nan tawo, sayti a mamagkasalanan kona. ");
INSERT INTO smkNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wanin bana' ta sayti e ket mangibwat sa kanakman nan tawo: duka' nin kukaisipan, sarbaynan klasin ambo' nin manepeg nin pirararay, pananakaw, pangmamati, ");
INSERT INTO smkNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pammabayi o kilalaki, kaaguman, pangngawa' nin sarbaynan kadukaan, pananaktika, gawa'-gawa' a kasa gapo nin pagdadangka', imbel, pammaduka', karangasan, mipara-parabulas. ");
INSERT INTO smkNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sarba nga'min nin saytin kadukaan ket mangibwat sa nakem nan tawo tan sayti ket mamagkasalanan kona.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sawanin nibwat yadtaw si Jesus tan saray tumutumbok na tan nako sara sa sayay lugar nin adani sa syudad nin Tiro tan Sidon. Niikap ya sa sayay balidtaw. Kai na kumon nin rabay a matandaan ran tutawo a itaw ya, bale' natandaan ran lamang. ");
INSERT INTO smkNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Main itaw nin sayay babayi nin si daite' et nin anak nan babayi ket nasrepan yan ispiriton duka'. Sin natandaan nan itaw ya si Jesus ket nako yan tampor itaw kona tan nanalimukod ya sa adapan na ");
INSERT INTO smkNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","tan nikidawat yan inganga'do a palakwanen nayay ispiriton duka' konan anak na. Bale' siti nin babayi, ambo' yan Judio ta niyanak yadtaw sa lugar nin mangaran Sirofenicia. ");
INSERT INTO smkNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kanya' nin wana ni Jesus a sayay alimbawa', “Kai bale' nin magwa'. Matkap misarayna yapo' nin pakanen a a'nak, ta ambo' nin manepeg a kalapen a kanen ran a'nak tan ipakan konran tuwe'.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wana anamaet nin ni'bat “Tutuo in say wamo, Ser, bale', mataman anamaet nin saray aso sa sirong nin lamisawan ket kanen ray pasi' ran a'nak.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ket wana ni Jesus kona, “Mabista ya in si ubat mo. Ket bana' konan siin, sumubli' kayna sa bali mo. Si ispiriton duka' ket linmakwan yayna konan anak mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ket nugot yayna sa bali na a babayi, ket na'kit nayay anak na nin nakaida' sa idaan na, tan natarusan nan linmakwan yaynay ispiriton duka' kona. ");
INSERT INTO smkNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nibwat yaynadtaw si Jesus sa Tiro. Linmabas ya sa Sidon tan sa Decapolis. Sin rinmate' ya sa sakop nan Baybay Galilea, ");
INSERT INTO smkNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","main nin tutawon nangiyater kona nin sayay lalakin telek tan umel. Ket dinawat ra kona ni Jesus nin ipababo nay gamet na kona ta pigaw nin paandaen naya. ");
INSERT INTO smkNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sin sain ket nikadayo' naya ni Jesus konran tutawo. Ket sinurot nan garamay nay tutulyan nan lalaki, mi'sa linmuda' ya tan inapros nayay dila' nan tawo. ");
INSERT INTO smkNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kaaram tinmangar ya si Jesus sa langit tan sinma'wet ya tan wana, “Effata,” a say rabay nan irgwen, “Maabryan.” ");
INSERT INTO smkNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ket tampor a makarnge' yayna tan makairgo yaynan mapalaway nin ambo' yaynan umel taw si tawo. ");
INSERT INTO smkNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Binibilin nasaran maong ni Jesus a tutawo nin andi' rayti nin ibari-barita' sa abirno nin si'no. Bale' no ka'no nasara nin binibilin, lalo rayna edet nin nibari-barita'. ");
INSERT INTO smkNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wanin anan tuloy a nipaka'ngap ran nakarnge' ket wanra, “Sarba nga'min nin man-gaw'en na ket mabista! Mataman nin saray telek ket mapangrenge' nasara tan saray umel ket mapag'irgo nasara!” ");
INSERT INTO smkNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Napalabas a umnoy awro sin sain, nadinep saraynaet a tutawon abaw a nako kona ni Jesus. Ket na'pos raynay balon ra, kanya' nin kinayaban nasara ni Jesus a tumutumbok na, ket wana konra, ");
INSERT INTO smkNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kudwa'dwan kosarayti saray tutawo ta tuloy awro raynan iti ket na'pos anay balon ra. ");
INSERT INTO smkNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Main nin nangibwat et sa adadayo' nin lugar, ket no pasublien kosara anamaet sa bubali ra nin kai nin nangan, bangli' no maulaw-ulaw sara sa dalan sa bitil ra.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanran tumutumbok na, “Adti atamo ey nin mangalap iti sa wantin kasan kabali-balin lugar nin ipakan konran saraytin tutawo?” ");
INSERT INTO smkNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nitepet na ni Jesus konra, “Umno ra et a natra' nin tinapay?” “Pito ra tamo',” ni'bat ran tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pinatekre' nasara ni Jesus a tutawo sa luta'. Mi'sa kinalap nasaray piton tinapay tan nikisalamat ya konan Dios. Tinau-tao nayti mi'sa na nin nibi konran tumutumbok na nin itayak ra konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Main anamaet nin umno ray madidintek nin kuna'. Nayadi' ya nin nikisalamat konan Dios, nibi nayti konran tumutumbok na nin itayak ra anamaet konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nakapangan saray tutawo tan nabsoy sara. Sumunor, sin dininep ran tumutumbok na a tara' ket main nin piton gagaban. ");
INSERT INTO smkNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Saray nangan, mag'a'pat a ribo sara. Kaaram, pinaibwat nasarayna ni Jesus a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mi'sa tampor rinmuran yayna tan saray tumutumbok na sa baluto nin mako sa sakop nan lugar nin Dalmanuta. ");
INSERT INTO smkNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sin rinmate' saradtaw, main nin Pariseo nin nako kona ni Jesus. Ket nikidiskusyon sara kona ta mampangkit saran puon a sidaen ray kagalangan na. Kanya' nin dinawat ran mangwa' yan makapaka'ngap nin paka'kitan a nibaki' nayan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sinma'wet ya sa idap nin nakem na mi'sa wana, “Mayin bale' a wanin? Mayin a saray tutawo sawanin ket kidawat saran makapaka'ngap nin paka'kitan? Ibarita' ko komoyo, kasa gapon paka'kitan nin ipa'kit konra.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nayadi' na nin nibarita' in, linakwanan nasarayna tan rinmuran saraynaet si Jesus sa baluto nin mako sa rubari'. ");
INSERT INTO smkNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sawanin, nalingwanan ran tumutumbok na a nibalon ket main tamo' nin sayan-sayay tinapay itaw sa baluto. ");
INSERT INTO smkNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pinau-pau'nawan nasara ni Jesus, “Pakailag kamon maong sa pammakbo ran Pariseo tan sa pammakbo na ni Herodes,” wana. ");
INSERT INTO smkNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ket nag'iirgwan rayaytaw nin tumutumbok na si wana. Wanra, “Wantaw a wana bana' ta kasan balon tamon tinapay.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nataros na ni Jesus no ani a mampag'iirgwan ra ket wana konra, “Ambale' nin sain a mampag'irgwan moyo si kasan balon moyon tinapay? Ani anggan sawanin ket kai moyo et nin mapibarawes tan matarusan? Kai et para nin maabot nin pakataros moyo? ");
INSERT INTO smkNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Main nin mata moyo bale' bilang nin kai kamo nin maka'kit; main nin tutulyan moyo bale' bilang nin kai kamo nin makarnge'. Nalingwanan moyoyna para ");
INSERT INTO smkNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","sin tinau-tao kosaray liman tinapay nin nipamakan konran limanribon lulalaki? Umnoy balyag a tara'?” wana. “Labinrwa,” wanra kona. ");
INSERT INTO smkNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sin tinau-tao kosaray piton tinapay nin nipamakan konran a'pat a ribon tutawo, umnoy gagaban a nadinep moyon tara'?” wana. “Pito,” wanra kona. ");
INSERT INTO smkNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wana, “Ket kai moyo et para nin matarusan a pipa'kaan nan si alimbawa' nin nibarita' ko?” ");
INSERT INTO smkNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nakarate' yadtaw si Jesus tan saray tumutumbok na sa Betsaida. Main nin tutawodtaw nin nangiyater kona nin sayay lalakin bulag tan dinawat ra nin ipababo nay gamet na konan sitin lalaki ta pigaw nin maka'kit ya. ");
INSERT INTO smkNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ket anaod, tinabin naya ni Jesus a bulag nin nirikor naya sa babali. Mayadi' na nin linudaan a mata nan bulag nin pananambar na kona, nipababo nay gamet na kona tan nitepet na, “Maka'kit kayna para?” ");
INSERT INTO smkNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kinmikit ya ket wana, “O', maka'kit akon tutawo a bara'mo saran kukayo bale' manlumalako sara!” ");
INSERT INTO smkNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nipababo naynaet a gamet na ni Jesus sa mata nan bulag. Kinmikit yay tawo ket inmanda' yaynan maong; mapalaway ana nin tuloy a pangingikit na. ");
INSERT INTO smkNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pinaibwat nayayna ni Jesus a tawo nin mako ana sa bali na tan wanan nibibilin kona, “Andi' kayna nin dumalan sa babali.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sinmunor, nako ya si Jesus, kalamo' nasaray tumutumbok na, sa bubaryo nan Cesarea-Filipos. Sin leg'an ran manlumalako, tinepetan nasara a wana, “Ani a man'ibari-barita' ran tutawo maipa'ka' kongko? Si'no ako kano a wanra?” ");
INSERT INTO smkNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ket wanra nin ni'bat, “Si Juan a Mammawtismo; wanran raruma si Elias; saray raruma et wanra a saya ka konran saray prupita sin nu'na.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ket si'kamo anamaet, si'no ako sa wamoyo?” Ni'bat na ni Pedro a wana, “Si'kay Cristo a nipangako' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ket binibilin nasara nin andi' rayti gapo nin ibarita' nin maipa'ka' kona sa si'numan. ");
INSERT INTO smkNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ket sin sain, tinaranaan nayna ni Jesus nin nipatandaan konran tumutumbok na a adapen anan mangyadi' kona. Wana, “Si'kon si Pinaitawo ket matkap a mangirangep akon abaw nin pammadya'dya'. O' a ta ipulisay rako nin saray Mangatuntawo tamo tan saray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan tamo tan patyen rako li'. Bale' marate' a ikatlon awro, pasublien ako li' nin mabyay.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nibarita' naytin mapala-palaway konra. Kanya' nin nikadayo' naya ni Pedro tan inima'no naya sa sain a nibarita' na. ");
INSERT INTO smkNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ket nibring ya si Jesus nin inadap nasaray tumutumbok na tan kinasagran naya si Pedro a wana, “Satanas, lumakwan kadti! Anaod, say iti sa nakem mo ket ambo' nin kumpruntado sa karabayan nan Dios, no kai edet, sa pangingisip nin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pinakadani nasara ni Jesus a tutawo tan saray tumutumbok na kona, mi'sa wana, “Si sayan marabay nin mag'in nin tumutumbok ko, matkap a galten nayna sa kaisipan na a karabayan nan bukod. O' a, matkap nayan balatayen a kudos na nin ipulisay nay lalaman nan diri ket tumbuken nakon pirmi. ");
INSERT INTO smkNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wanin ta si si'numan a say byay nadti tana a mampagawan na, mati ya li' et a lamang, bale' si tawo nin gurutan nay byay nadti bana' sa pammabli na kongko tan konan Mabistan Patanda', mabyay ya nin iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ani wadi' a magun-guna nan sayay tawo no maikon nay intiron kayamanan sa babon luta', bale' nibayad nay byay na sa sain! Kasa gapo! ");
INSERT INTO smkNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kasa gapo nin magwa' nan ipambot nin sayay tawo sa byay a na'met na. ");
INSERT INTO smkNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Saray tutawo konan sitin panaon, makasalanan saran tuloy tan malamang sara konan Dios. Ket si si'numan nin mangiding'ey a tumutumbok ya kongko nin si'kon si Pinaitawo tan sa akay ko, iding'ey koya li' anamaet no sumubli' ako nin main nin pakayadi' tan kagalangan nan Ama ko tan kalamo' kosara li' a uanghil nin naitalaga kona.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wana et ni Jesus konra, “Ibarita' koyti komoyo, main komoyodti sawanin a sibibyay et li' nin ma'kit ra li' a pakayadi' nan Dios sa Pag'adian na.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Napalabas a a'nem nin awro, nitagad nasara ni Jesus nin nuli' sa sayay ata'gay nin talugtog si Pedro, si Santiago tan si Juan. Sara-sara tamo' itaw. Itaw, nanguman a bakas na ni Jesus nin nabantayan ra. ");
INSERT INTO smkNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Say seket na ket nag'in nin makapulag nin pinasyan puti' a kasan mammi'pi' iti sa babon luta' a makagwa' nin wanti. ");
INSERT INTO smkNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kapingmatan pinaipadar sara si Elias tan si Moises nin mangkiirgo sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ket si Pedro nikibba'bat ya a wana kona ni Jesus, “Ay, Ser, mabista ta iti atamoyna! Ket mama'deng kamin tulo ray abung-abong; saya para komo, saya para kona ni Moises tan saya para kona ni Elias.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nibarita' nayti ni Pedro ta kai na nin tanda' no ani a manepeg nan ibarita' ta nabagya' saran tuloy. ");
INSERT INTO smkNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kaaram, nagkamain nin gunem ket sinirungan sara tan main nin busis nin nangibwat sa gunem a narnge' ra a wana, “Siti a Anak ko nin mangkawa-kawa'nanen ko. Reng'en moya!” ");
INSERT INTO smkNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tampor a kinmikit sara sa libed ra ket kasaynan ma'kit ran raruman kalamo' ra no kai si Jesus tana. ");
INSERT INTO smkNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sin mampanaoy sarayna sa talugtog, nibibilin nan mairot konran tulon tumutumbok na a saytin na'kit ra ket andi' ra gapo nin ibari-barita' abirno si'no, anggan syan si Pinaitawo ket pinasubli' yaynan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tinumbok raytin bibilin na bale' nag'iirgwan ra et no ani a rabay nan irgwen sa wanan pasublien yan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ket tinepet ra kona, “Kai para a wanran Madudunong sa Gugan-gan ket matkap a rumate' ya yapo' si prupita Elias mi'sa sitaw si sayan nipangako' nan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ket wana ni Jesus konra, “Page' a rumate' ya yapo' si Elias ta pigaw nin isadya' nay sarba para konan si nipangako' nan Dios. Ket maipa'ka' anamaet bale' kongko nin si Pinaitawo ket main nin naisurat sa Kasuratan a mangirangep akon abaw nin pammadya'dya' tan maibilang akon kasan kwinta. ");
INSERT INTO smkNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bale' ibarita' ko sawanin komoyo: Say katutu'wan, ket si Elias, rinmate' yaynadti, ket bilang sa naisurat maipa'ka' kona, ginwa' ran tutawo kona a sarbaynan kadukaan a rabay ra.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sin mansumubli' saraynadtaw si Jesus konran raruman tumutumbok na, na'kit nan naaribungbungan saran abaw nin tutawo. Main et nin Madudunong sa Gugan-gan a mangkidiskusyon konra. ");
INSERT INTO smkNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sin na'kit ran tutawo a itaw sarayna si Jesus naka'ngap saran maong bana' ta kai raya nin man'ilalwan nin rumate', ket nalayo saran inmarak kona tan nangigalang sara kona. ");
INSERT INTO smkNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ket tinepetan nasara ni Jesus, “Ani a mangkidiskusyunan moyo konra?” ");
INSERT INTO smkNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ket saya konran tutawo, wana, “Maistro, inawit koyadti nin ika' kumon komo a anak kon lalaki a nasrepan yan sayay ispiriton duka' nin namag'in umel kona. ");
INSERT INTO smkNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tepe' nin serpan naya, tumbawen naya, gumura' yay bebey na, ngumaretenget a ngipen na, tan kumsir ya. Dinawat ko konran tumutumbok mo a palakwanen rayay ispiriton duka' bale' kai ra nin nababaan.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ket wana ni Jesus, “Abagay kamoyna! Ambale' a kasan pammemper moyo? Anggan ka'no ako kadi' nin matkap nin kikalamo' komoyo? Anggan ka'no katamo nin anusan sa pigagawa' moyo? I'ras madti a anak.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ket ni'ras raya kona ni Jesus. Ket si ispirito, sin na'kit naya si Jesus, pinangayegkeg nayay anak ket natumba ya, namuluk-pulok ya tan ginmura' yay bebey na. ");
INSERT INTO smkNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ket tinepet na ni Jesus konan ama nan siti, “Ka'no ya et nin tinmarana' nin wanin?” Ket wana, “Nangibwat et sin daite' ya. ");
INSERT INTO smkNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Si ispiriton duka', kasabyan nin ira'pog naya sa apoy tan irebreb naya sa raranom a anak ko ta pigaw nin patyen naya kumon. No mababaan mo kadi' ket panginga'do mo pa ta tulungan nakami!” ");
INSERT INTO smkNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Sukat a no mababaan mo wamo!” wana ni Jesus. “Konan si magmatalek konan Dios, say sarba nga'min ket magwa'.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ket tampor nita'way nan ama a wana, “Tumper ako! Bale' tulungan nako ta kurang et a pagmamatalek ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sin na'kit na ni Jesus a man'umabaw saray tawo, ginan-gan nayay ispiriton duka' a wana, “Si'kan ispiriton mamatelek tan mamaumel, lumakwan kayna kona tan andi' moyna umanen et a sumrep kona!” ");
INSERT INTO smkNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ket si ispirito niyagsit na tan pinangayegkeg naya ba'yo ya nin linmakwan konan anak. Si anak, nati anay bakas na ket wanran tutawo, “Nati yayna.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bale' gina'getan naya ni Jesus sa gamet tan binangon naya. Ket inumdeng yay anak. ");
INSERT INTO smkNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sin linmuob sarayna si Jesus sa bali, nitepet ran tumutumbok na a sara-sara tamo' a nakarnge', “Mayin bale' a kai miya nin napalakwan taw si ispirito?” ");
INSERT INTO smkNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ket wanan ni'bat ni Jesus, “Sa sitin bakas nin ispirito ket yupa' tamo' sa kadadasal konan Dios a pammalakwan kona.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nibwat sara si Jesus konan sitaw nin lugar tan linmabas sara sa Galilea. Kai na nin rabay nin matandaan ran tutawo a kami'nan ra ");
INSERT INTO smkNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta man'iyakay nasaray tumutumbok na. “Si'kon si Pinaitawo, maipagamet ako konran mag'uray ket patyen rako. Mataman bale' nin napati ako, pasublien akon mabyay sa ikatlon awro,” wana. ");
INSERT INTO smkNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kai ra bale' nin natarusan ti nin saray tumutumbok na a nibarita' na tan mali'mo saran manepet kona no ani a rabay nan ibarita'. ");
INSERT INTO smkNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nakarate' saradtaw sa Capernaum. Sin itaw sarayna sa bali tinepetan nasara, “Ansaytaw say nididiskusyunan moyo sa dalan?” ");
INSERT INTO smkNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bale' kai raya nin inubatan ta mading'ey sara, ta sin itaw sara sa dalan ket nididiskusyon sara no si'noy sangkaalakyan konra. ");
INSERT INTO smkNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tinmekre' ya tan pinakadani nasara konay labinrwan tumutumbok na. Wana, “Si sayay tawo no apes na a maipata'gay, matkap na a mipaayupa' nin bilang sayan mampagsirbi konran sarba.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ket pinakadani nayay sayay anak sa adapan ra. Ket inaruko naya tan wana konra, ");
INSERT INTO smkNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Si si'numan a mampangilalaman kongko a mangako' konan sayay wantin anak, si'koyna a inako' nan lamang. Ket saray mangako' kongko, ambo' ako tamo' a inako' ra, no kai pati anamaet nin si namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wana ni Juan kona, “Maistro, main nin na'kit mi nin sayay lalakin man'usaren nayay ngaran mo ta pigaw nin palakwanen nasaray ispiriton duka' sa nasrepan ran tawo ket pinaed miya bana' ta ambo' tamoyan kalamo'.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wana anamaet ni Jesus, “Andi' moya awaan ta si si'numan a mangusar nin ngaran ko ta pigaw nin makagwa' yan milagro, ket kai yayna nin makapag'irgo nin duka' maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Anaod, si kai nin kumuntra kontamo ket kiayon ya kontamo. ");
INSERT INTO smkNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ibarita' koyti komoyo, si si'numan a mamainom nin abirno tana sambaso nin ranom komoyo bana' ta tanda' ra a tumutumbok katamo nin si'ko a si Cristo, si mangwa' nin wanin kasan sapo a mabyan ya li' nin gun-guna.” ");
INSERT INTO smkNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wana et, “Maong et konan sayay tawo a katinan yan mabyat nin bato sa liey tan ibuntok ya sa taaw dyan si mag'in syay puon nin pakasida' nin pagmamatalek na kongko nin saya konran sarayti nin maayupa' sa pammemper ra. ");
INSERT INTO smkNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ket no si gamet mo a puon nin pakasida' nin pagmamatalek mo, putulen ma. Maong anay pukol ka bale' magkamain kan byay a iti konan Dios dyan si rwa ran page' a gamet mo, bale' maika' ka sa impyirno, sa apoy a kai gapo nin ma'rep. ");
INSERT INTO smkNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","No si ayi mo anamaet a puon nin pakasida' nin pagmamatalek mo, putulen ma. Maong anay pilay ka bale' magkamain kan byay a iti konan Dios dyan si rwa ran page' a ayi mo bale' maika' ka sa impyirno, sa apoy a kai gapo nin ma'rep. ");
INSERT INTO smkNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No si mata mo anamaet a puon nin pakasida' nin pagmamatalek mo, sukiten ma. Maong anay saya tamo' a mata mo bale' makapika' ka sa Pag'adian nan Dios, dyan si rwa ran page' a mata mo bale' maika' kadtaw nin madusa sa apoy nin impyirno. ");
INSERT INTO smkNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Itaw ket main nin uurer a kai nin mati a mampangan nin laman nin tutawo tan main nin apoy a kai gapo nin ma'rep. ");
INSERT INTO smkNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Sarba ran saray tumumbok kongko ket mangitpel sara nin dya'dya' a bilang nin mampuuran sara ta pigaw nin gumsen a pammemper ra kapada a say kanen ket mas tumaway no asinan. ");
INSERT INTO smkNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Say asin, maalaga. Bale' no ma'met anay ma'sin nin taway, kai ana gapo nin maisubli'. Kapada a say asin ket mamin mabistan taway sa kanen, wanin anamaet, si'kamo, magkabyay kamon mabistay pakikalamo' moyo sa saya tan saya ket mitutuno kamo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nibwat saradtaw si Jesus sa Galilea nin nako sa prubinsya nin Judea ket rinmipay sara sa Ilog Jordan. Abaw saraynaet a tutawon inmarak kona ket niyakay nasara a bilang sa ugali' nan man-gaw'en. ");
INSERT INTO smkNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Main nin Pariseo nin nako kona ni Jesus. Mampangkit saran puon nin pamarsawan ra kona. Ket wanra, “Aburuyan para nin Gugan-gan a isyay nayan sayay lalaki a asawa na?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ket wanan ni'bat ni Jesus, “Ani ket a nisurat na sa Gugan-gan ni prupita Moises nin gaw'en moyo?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ket wanra, “Niyaburoy na ni Moises nin isyay nayan sayay lalaki a asawa na mayadi' naya byan nin kasuratan nin pisyayan ra.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ket wana ni Jesus, “Bana' ta matib'ey a ulo moyo, nibi nayayti nin gan-gan komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bale' sin tarana', sin pinarsa nan Dios a sarba, pinarsa nay tawo nin lalaki tan babayi, ");
INSERT INTO smkNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ket bana' konan siti nin ginwa' na, si sayay lalaki, lakwanan nasara si ama na tan si ina na ta kipasaya ya konan asawa na ");
INSERT INTO smkNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ket saran rwa, mag'in saran sayan-saya.” Wana et ni Jesus, “Kanya' nin saray mitraasawa ambo' saraynan rwa no kai edet, sansaya saraynan lalaman. ");
INSERT INTO smkNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Edet, bana' ta wanin, saran rwa nin pinipasaya nan Dios, ambo' nin manepeg a pisyayen saran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sin itaw sarayna si Jesus sa bali nin kami'nan ra, tinepetan rayan tumutumbok na maipa'ka' anamaet konan sitaw si nibarita' na. ");
INSERT INTO smkNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ket wana, “Si lalaki nin mangisyay konan asawa na mi'sa ya nin mangalamo' nin sakalako, magkasalanan ya konan asawa nan nisyay na ta mampamabayi ya. ");
INSERT INTO smkNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wanin anamaet, si babayi nin kisyay konan asawa na mi'sa ya nin kikalamo' sa sakalako, magkasalanan ya konan asawa nan nisyay na ta mangkilalaki ya.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni'sa, main nin tutawon nangi'ras nin ua'nak kona ni Jesus ta pigaw nin ipababo nay gamet na konra nin bindisyunan nasara. Bale' saray tumutumbok na inima'no rasara. ");
INSERT INTO smkNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sin nadlaw nayti ni Jesus, nanager ya konran tumutumbok na ket wana, “Pauryan moyo saran umarak kongko a ua'nak. Andi' moyo sara nin ima'nwen, ta si tawon say kanakman na ket kapada ran saraytin ua'nak, aburuyan nayaynan Dios nin kipag'adi' kona. ");
INSERT INTO smkNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","O', ibarita' koyti komoyo, si si'numan a kai nin mipaayupa' nin paisirong sa pag'uuray nan Dios nin bilang sa pangangaburoy nan sayay anak, kai ya gapo nin makakirama' sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ket inaruko nasara ni Jesus a ua'nak tan binindisyunan nasara nin nipababo nay gamet na konra. ");
INSERT INTO smkNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sin mampibwat sarayna si Jesus nin mako sa sayay lugar, main nin sayay lalaki nin pala-palayon inmarak kona. Nanalimukod yayti sa adapan na tan nitepet na kona, “Maistro, maong ka. Ket ani a manepeg nin gaw'en ko ta pigaw nin maga'muran koy anggan-angga nin byay a iti konan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ket wana ni Jesus, “Ambale' a sabtan nako nin maong? Kasa gapo nin raruma no kai si Dios tamo' a maong. ");
INSERT INTO smkNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tanda' moynamaet a Gugan-gan: Andi' ka nin mangmati. Andi' ka nin mamabayi o kilalaki. Andi' ka nin manakaw. Andi' ka nin magtistigos nin ambo' nin tutuo. Andi' ka nin manaor. Igalang mosara si ama mo tan si ina mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ket wanan lalaki, “Maistro, sarban sain ket mantukiden koyna nangibwat et sin anak ako.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Main nin pangangawa'nan nin pinastang naya ni Jesus ket wana kona, “Main et nin saya nin matkap mon gaw'en. Mako ka tan ilako' mo a main mo tan say bili, ibi mo konran pubri ket magkamain kan kayamanan itaw sa langit. Kayadi' mo nin gaw'en ti, sumubli' kadti kongko tan mag'in kan tumutumbok ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bale' sin narnge' na in nin nibarita' na ni Jesus, rinmere' ya, tan nibwat ya nin pinasyan bereng. Mainan yan tuloy ket. ");
INSERT INTO smkNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pinastang nasara ni Jesus a tumutumbok na mi'sa wana konra, “Ay, maidap nin maong a ipaisirong ran mumayaman a lalaman ran diri sa pag'uuray nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naka'ngap saray tumutumbok na sa sain a nibarita' na. Ket wanan inuman ni Jesus konra, “Kalalamo', talagan pinasyan idap nin tumulok saray tutawon magmatalek sa kayamanan ra nin pag'urayan nasaran Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas mainum'ay ya et nin lumbot a kamilyo sa ubot nin kadayem dyan si sayay mayaman ket makakibiang ya sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalo saraynan naka'ngap a tumutumbok na konan siti nin nibarita' na, ket wanra, “Ya! Si'no edet no wanin a maisalba?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pinastang nasaran maong ni Jesus mi'sa wana, “Peteg a impusiblin makaga'mor nin kasan anggawan nin byay a tutawo, bale' ambo' nin impusibli konan Dios nin ibi nayti ta say sarban bagay ket magwa' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ket nag'irgo ya si Pedro a wana, “Ket si'kami pa edet, pinauryan mi anay sarba ta pigaw nin nikikalamo' kami komo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wana ni Jesus, “O' a, ta ibarita' koyti komoyo, si si'numan a manglakwan nin pammali na, bubsat na, ina na, ama na, a'nak na o binis na bana' kongko tan konan Mabistan Patanda', ");
INSERT INTO smkNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","magun-gunawan yan misanyasot nin ka'baw dyan say linakwanan na. Magkamain ya nin abaw a bubali, bubsat, uina, ua'nak tan binis sawanin sa kapresan anan panaon iti sa luta'. Mangirangep ya bale' nin idap tan pammadya'dya' bana' kongko, bale' rumate' li' a awro nin sya ket mabyan ya et nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ket konan sitaw li' nin awro, main konran iti anan nu'na a maikayupa' li', tan main konran masusuyot a u'nawen li'.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ket sawanin, itaw sara sa dalan nin mantumangkar saran adap sa Jerusalem. Iti ya sa u'na si Jesus. Saray tumutumbok na ket maka'ngap sara kona. Main nin raruman mantumumbok nin silili'mo saraynamaet. Pinaipurok nasaray labinrwan tumutumbok na tan nibarita' naynaet konra a mangyadi' ana li' kona. ");
INSERT INTO smkNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wana, “Mangrenge' kamo. Adap tamoyna sawanin sa Jerusalem. Ket itaw, si'kon si Pinaitawo, maipagamet ako konran Pupangulon Pupadi' tan konran Madudunong sa Gugan-gan tamo. Sintinsyawan rako nin mati, mi'sa ipagamet rako konran ambo' nin Judio; ");
INSERT INTO smkNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ket tuya'-tuyaen rako, luda'-ludaan rako, sanet-saneten rako tan patyen rako. Bale' marate' a ikatlon awro, pasublien nakon mabyay nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sawanin, kinmadani sara kona ni Jesus si Santiago tan si Juan a saray a'nak na ni Zebedeo. Wanra, “Maistro, main pa nin rabay min dawaten komo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ket wana, “Ani ngaran?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ket wanra, “Saytaw no si'kayna li' a mampag'uray nin main nin ata'gay a kagalangan, patekreen rakami li' pa sa abay mo, saya sa pawanan mo tan si saya sa pawiri mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wana ni Jesus konra, “Kai moyo nin tanda' no ansain say mandawaten moyo. Maako' moyo paran irangep a dya'dya' a adapen ko nin irangep? Maitpel moyo para a mati nin bilang sa patiti ko?” ");
INSERT INTO smkNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“O', maako' mi,” wanra. Ket wana ni Jesus konra, “Page' a mangirangep kamo nin dya'dya' nin bilang sa dya'dya' a irangep ko tan mati kamo nin bilang sa patiti ko. ");
INSERT INTO smkNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bale' no si'noy tumekre' sa pawanan tan sa pawiri ko, ambo' nin iti sa gamet ko. Naigagara ana in nin lugar konran napili' nan Dios nin pangisadyaan.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ket sin narnge' ran mapulo' nin raruma et nin tumutumbok na a maipa'ka' sa sayti, masager sara konra ni Santiago tan Juan. ");
INSERT INTO smkNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanya' nin pinakadani nasara nga'min ni Jesus kona tan wana konra, “Tanda' moyon peteg no pa'noy pag'uuray ran mag'uuray iti sa mundo. Aripenen rasaray iti sa sakop ra tan saray iti sa ta'gay ket masakit-sakit sara konran saray iti sa sirong nin uray ra. ");
INSERT INTO smkNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bale' komoyo, matkap a ambo' nin wanin. Komoyo, si si'numan a marabay nin mag'in nin ata'gay ket matkap a syay magsirbi konran raruma, ");
INSERT INTO smkNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","tan si si'numan komoyo a marabay nin mag'in nin syay ulo, matkap a magwa' nay mag'in nin aripen nin sarba. ");
INSERT INTO smkNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Arigen moyoy gawa' ko, si'kon si Pinaitawo, a nako akodti sa luta' ambo' ta pigaw nin pasirbi ako no kai edet, ta pigaw nin magsirbi ako tan ta pigaw nin ibi koy byay ko nin ipambot konran abaw a tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Rinmate' yadtaw sa Jerico si Jesus tan saray tumutumbok na. Ket sin mampibwat saraynadtaw, abaw saray tutawon nikialuyon konra. Ket, main nin kipayabor a nakatekre' itaw sa rigrig. Bulag ya. Say ngaran na ket Bartimeo a anak na ni Timeo. ");
INSERT INTO smkNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ket sin narnge' na nin si Jesus a taga Nazaret ket itaw ya, kapingmatan anan tinma'way ya a wana, “Jesus a puri na ni Adi' David, ka'dwan nako kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abaw saray masager kona a inima'no rayan gumargar. Bale' mas maksaw nayna edet nin nita'way, “Si'kan nipangako' a puri na ni Adi' David, ka'dwan nako kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tinumgen ya si Jesus ket wana, “Tawagen moyadti.” Ket tinawag rayay bulag a wanra kona, “Paksawen moy nakem mo. Umdeng ka ta man'ipakayaban naka.” ");
INSERT INTO smkNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Apuradon ginlat nayay kapa na; maliksi yan inumdeng tan inmarak ya kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Ani a rabay mon gaw'en ko para komo?” nitepet na ni Jesus kona. Ket wanan bulag, “Maistro, rabay ko kumon a maka'kit akon uman!” ");
INSERT INTO smkNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ket wana ni Jesus kona, “Sigi, mako kayna. Bana' sa pagmamatalek mo, inmanda' kayna.” Ket tampor a maka'kit yayna. Nikikalamo' ya kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ket adani sarayna si Jesus sa syudad nin Jerusalem ta itaw sarayna sa bandan baryo nin Betfage tan Betania nin adani sa Talugtog Olibo. Ket pinau'na nasaray rwa konran tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wana konra, “Mako kamo sa baryo a man'adapen moyo. Ket karate' moyodtaw, main nin tampor nin ma'kit moyon nipuged a sayay uybon nin asno nin kai et gapo nin naruranan. Usbagen moya sa nakaipugedan na tan i'ras moyadti kongko. ");
INSERT INTO smkNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No main nin manita komoyo no ambale' nin man-gaw'en moyo in, ibarita' moyo kona, ‘Matkap nayayti nin Uunuren. Ipaisubli' nayadti li' a lamang kainsanan.’ Ket tampor a umaburoy yan kalapen moya.” ");
INSERT INTO smkNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ket nako sarayna, ket page' a main nin na'kit ran uybon nin asno. Itaw ya sa dalan nin nipuged ya sa rikor nin purtan bali. Ket sin man'usbagen rayayna sa nakaipugedan na, ");
INSERT INTO smkNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wanran saray itaw, “Ambale' nin man'usbagen moya in?” ");
INSERT INTO smkNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ket say ni'bat ra ket saytaw say bibilin na ni Jesus konra, ket pinauryan rasaraynan nituloy ray man-gaw'en ra. ");
INSERT INTO smkNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ket ni'ras raya kona ni Jesus a uybon. Nisapin ray kapa ra kona, ket rinmuran ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abaw sara konran tutawodtaw a bana' sa alakin pangingigalang ra kona ni Jesus ket niyapra-aprak ray kukapa ra sa dalanan na tan nampi-nampi' saran susangan kukayo sa gagawa' tan niyapra-aprak raynamaet a lamang sa dalanan na. ");
INSERT INTO smkNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Saray tutawo ket iti sara sa u'na tan sa suyot na ni Jesus. Mantuma'wa-ta'way sara nga'min a wanra, “Marayo ya! Nabindisyunan nayan Dios a nibaki' na nin manrumate' anadti sawanin kontamo!” ");
INSERT INTO smkNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Binindisyunan naynan Dios a pag'aadi' na nin bilang sa nipag'adi' na ni puon tamon si David sin saytaw!” “Marayo yay Dios itaw sa langit!” ");
INSERT INTO smkNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ket nakarate' saraynadtaw si Jesus sa Jerusalem tan nako ya nin linmuob sa sakop nan Timplo. Nayadi' ya nin kinmikit-kikit itaw, nibwat yan nako sa Betania, pati saray labinrwan tumutumbok na, ta yabinayna. ");
INSERT INTO smkNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ket kinabuklasan, sin mansumubli' sarayna si Jesus nin ibat sa Betania, ginmitil ya. ");
INSERT INTO smkNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Natamuraw nayay sayay kayon igos a mabulong. Nako yadtaw sa kami'nan na ta pigaw nin kiten na no ginmunga yayna. Anaod, ambo' et nin panaon nin katutua. Ket sin nirate' yadtaw, kasa gapo nin ma'kit na nin bunga no kai kal-la bulong tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ket wana konan kayo, “Anggan maka'numan ket kasayna gapo nin makapangan nin bunga mo!” Ket narnge' rayti nin tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sin nakarate' sara sa Jerusalem, linmuob ya si Jesus sa sakop nan Timplo nan Dios bale' itaw narat'anan nasaray mampaglako'. Ket pinala-palakwan nasara tan saray mampanaliw itaw nin say bubagay a ida'ton konan Dios tan tinali-talimbwag nay lulamisawan ran maninilin kwarta, tan say tutekrean ran maglalako' nin kalapati. ");
INSERT INTO smkNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Niyawa' na et a lumabas itaw sa sakop nan Timplo a si'numan nin main nin awit-awit. ");
INSERT INTO smkNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mi'sa niyakay nasaray tutawo nin itaw. Wana, “Kai para naisurat a wanan Dios, ‘Si Bali ko ket pangaranan raya nin lugar nin dadasalan ran sarban tutawo kongko’? Bale' si'kamo, ginwa' moyan pididinepan ran mannakaw!” ");
INSERT INTO smkNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Natandaan ran Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan a maipa'ka' sa sayti. Ket mampaningkap sarayna nin padalan no pa'no raya nin maipapati ta ikali'mo raya si Jesus ta mangkaayat nay nakem ran tutawo sa akay na. ");
INSERT INTO smkNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sin yabi sin sain, nibwat sara anamanaet sa syudad si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kinabuklasan sin lumabas sara, na'kit rayaytaw si kayon igos nin nati ya anggan yamot. ");
INSERT INTO smkNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Si Pedro napanemtem nay nangyadi' intaw ket wana, “Maistro, kikiten may kayon igos nin nisamba mo. Nati ya!” ");
INSERT INTO smkNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ket wana ni Jesus konra, “Matkap a magmatalek kamo konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ibarita' koyti komoyo: No tepren moyo nin kai kamo nin magdwadwa a say ibarita' moyo ket mangyadi', magwa' moyon ibarita' konan sitin talugtog, ‘Gumlat kadsen tan mako ka sa taaw,’ ket mangyadi' a wamoyo. ");
INSERT INTO smkNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kanya' nin ibarita' ko komoyo, animan a dawaten moyo konan Dios, matkap a magmatalek kamo nin marisibi moyo ket talagan marisibi moyo. ");
INSERT INTO smkNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","No dumasal kamo ket main wadi' nin sakit nin nakem moyo sa si'numan, pirdunawen moya yapo' ta pigaw nin pirdunawen nakamo anamaet nin Ama tamo sa langit sa kasalanan moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ket nakarate' saraynaet si Jesus sa Jerusalem. Ket sin manlumala-lalako yadtaw sa sakop nan Timplo, kinmadani sara kona a Pupangulon Pupadi', saray Madudunong sa Gugan-gan ran Judio tan saray Mangatuntawo ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ket nitepet ra kona, “Ani a kanepegan mon mangwa' nin sain say man-gaw'en mo? Si'noy nami komo nin pakayadi' nin gaw'en mo in?” ");
INSERT INTO smkNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ket ni'bat na ni Jesus, “Ibarita' ko komoyo no ani a pakayadi' ko nin gumwa' nin saytin bubagay no ubatan moyayti si tepet ko. ");
INSERT INTO smkNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Si'noy namin kanepegan nan mamawtismo ni Juan, si Dios para o say tawo? Ani a ubat moyo?” ");
INSERT INTO smkNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ket nag'iirgo sara a wanra, “Ani kadi' a i'bat tamo? No ibarita' tamon ‘si Dios’, ibarita' na kontamo, ‘Mayin edet a kai moya nin timper si Juan?’ ");
INSERT INTO smkNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ket no ibarita' tamo anamaet, ‘Say tawo,’ makapasalak.” Wanin a wanra ta pinasyan li'mo ra konran tutawo ta tepren ran sarayti a si Juan ket saya yan talagan prupita. ");
INSERT INTO smkNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kanya' nin ni'bat ra kona ni Jesus, “Kai mi nin tanda'.” Ket wana anamaet ni Jesus konra, “No wanin, kai koynamaet nin ibarita' komoyo no ani a kanepegan kon mangwa' nin man-gaw'en ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ket nag'irgo ya konra si Jesus nin nangusar yan pangingiyarig. Wana, “Main nin sayay tawon nangmula nin ubas sa luta' na. Dinarekdek naya tan nangali yan ubot sa sayay bato ta pigaw nin pamespesan yan ubas. Nama'deng yan ata'gay nin kami'nan ran bantay. Mi'sa nipagamet nay pangangalila' sa mula na konran umno ran padalos tan nibwat yan nako sa adayo' nin lugar. ");
INSERT INTO smkNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sin narate' anay panaon nin pammutin bunga, nangibaki' yan sayay tawo na nin kalapen nay tao na. ");
INSERT INTO smkNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bale' saray padalos, dinakep raya ket tinasu-taso raya tan pinasubli' rayan kal-la gamet. ");
INSERT INTO smkNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ket nangibaki' yaynaet a main nin luta' nin sakalakon tawo na. Bale' pinekpe-pekpek raya tan pinadi-pading'eyan raya. ");
INSERT INTO smkNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ket nangibaki' yaynaet nin sakalako. Bale' pinati raya. Abaw sara et a nibaki' na, bale' pinekpe-pekpek rasara tan pinati-pati rasaray raruma. ");
INSERT INTO smkNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kalansuyutan, main nin saya tana nin nabati' nin maibaki' na, si kawa'nan nan tuloy nin si anak nan bugtong. Ket anaod, nibaki' naya. Wana sa nakem na, ‘Kai magwa' a kai raya nin kabilangan a anak ko.’ ");
INSERT INTO smkNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bale' saray padalos, sin na'kit rayay anak na wanra, ‘Siti li' a manawir. Patyen tamoya ta pigaw nin maikon tamo a tawiren na li'!’ ");
INSERT INTO smkNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ket dinakep raya tan pinati raya. Mi'sa nibantak rayay bangkay na sa rikor nin pukok na nin uubas. ");
INSERT INTO smkNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sawanin,” wana ni Jesus, “ani kadi' a gaw'en nan sitin main nin ikon nin luta' konran saraytin padalos? Kasan sapo nin mako yadtaw ket patye-patyen nasara. Mi'sa ipaga'getan naya a luta' na sa sakalakon padalos.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wana et ni Jesus, “Kai moyo para gapo nin nabasa-basaytin wana sa Masanton Kasuratan, ‘Sitaw si bato a nibilang ran kai nin mausar nin saray mammanday, sitaw nin diri nin bato a nag'in nin sangkaimpurtantiwan sa pamma'deng. ");
INSERT INTO smkNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Say nipag'in nin wanin ket gawa' nan Catawan, Ket sa pangingikit tamo, peteg a makapaka'ngap!’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Anaod, nataros ran pupangulo ran Judio a sara a mampada'gisan na ni Jesus kanya' nin dakpen rayayna kumon, bale' mali'mo sara konran tutawo kanya' nin linakwanan raya tana. ");
INSERT INTO smkNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ket, say ginwa' ran pupangulo, nangibaki' sara kona ni Jesus nin umno ran Pariseo tan umno ran tawon ayon kona ni Adi' Herodes. Ginwa' rayti ta pigaw nin kal'uten raya sa pag'iirgo na. ");
INSERT INTO smkNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ket sin itaw sarayna kona ni Jesus, wanra kona, “Maistro, tanda' mi nin matunong kan tawo. Say pangangakay mo nin no ani a rabay nan Dios nin gaw'en ran tutawo ket tutuo, tan kasan tawon ikali'mo mo ta mampari-parihwen moy tutawo. Edet anaod, rabay mi pan tepeten komo no sumubag atamo kasi, o kai, sa Gugan-gan tamo no mamayad atamon buis konan Impirador nan Roma? Matkap mi para a mamayad o kai?” ");
INSERT INTO smkNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bale' tanda' na ni Jesus a mampiwadi'-wadi' sara. Kanya' nin wana konra, “Mayin ta mansubuken moyoko? Byan rako pa nin kwartan plata ta pigaw nin kiten koya.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ket binyan raya, ket nitepet na konra a wana, “Si'no ya in rupa tan ngaran si isen konan plata?” Ket ni'bat ra, “Si Impirador nan Roma.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“No wanin edet,” wana ni Jesus konra, “isubli' moyo konan Impirador a ikon na, tan isubli' moyo anamaet konan Dios a ikon na.” Ket naka'ngap saran tuloy sa wantin ubat na. ");
INSERT INTO smkNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kaaram, main anamaet nin Saduseo nin nako kona ni Jesus. Sarayti saray Saduseo, kai ra nin tepren a mapasubli' sara li' nin mabyay a nunati ana. Ket tinepet ra kona a wanra, ");
INSERT INTO smkNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maistro, nisurat na ni Moises sa Gugan-gan tamo a no main nin mitraasawa ket nati yay lalaki nin kasan anak ra, manepeg a si busat nan lalaki ket matkap nin ikasal nayay nabalo ta pigaw nin manganak sara nin ikwintan anak nan sitaw si nati. ");
INSERT INTO smkNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ket, main intaw nin pito ray lulalakin mibubsat. Nangasawa yay kaka bale' nati ya nin kasan anak. ");
INSERT INTO smkNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ket si aryen na, nikasal nayay babayi. Bale' nati yayti anamaet a lamang nin kasan anak ra. Wanin anamaet a ginwa' nan ikatlo, ");
INSERT INTO smkNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","tan saray sumunor et kona. Sarba ra nin pito, nikasal rayay balo, bale' nati sara nga'min nin kasan anak. Kalansuyutan, nati yaynamaet a babayi. ");
INSERT INTO smkNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ket sawanin, no napasubli' sarayna li' nin mabyay a nunati, si'no edet li' a asawa nan babayi, ta saray pito ket nag'in nin asawa raya?” ");
INSERT INTO smkNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ket wana ni Jesus, “Ipa'kit nin sayti a mangkalingo kamoyna! Pa'no ket kai moyo nin mangkataros a wana sa Kasuratan o say maipa'ka' sa pakayadi' na nin Dios! ");
INSERT INTO smkNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Anaod, no napasubli' sarayna li' nin mabyay a nunati, bara'mo sarayna li' nin uanghil itaw sa langit a kai sarayna nin mangasawa o kiasawa. ");
INSERT INTO smkNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ket say maipa'ka' sa katutu'wan nin isusubli' ran mabyay nin nunati, kai moyo para nin nabasa-basayti sa nisurat na ni prupita Moises maipa'ka' sa wanan Dios itaw konan si mandumtan kayo? Siti a wanan Dios kona maipa'ka' konran pupuon tamo, ‘Si'ko et a lamang a Dios na ni Abraham, si Dios na ni Isaac, tan si Dios na ni Jacob.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nituloy na ni Jesus ket wana, “Syimpri a, si sayay nati ana, kai yayna nin makapangrayo konan sayay dios. Kanya' nin mangkabyay sara in et, saray nibarita' nan Dios a syay Dios ra. Mangkalingo kamo nin tuloy!” ");
INSERT INTO smkNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Main nin saya konran Madudunong sa Gugan-gan ran Judio a rinmate' itaw ket narnge' nayti nin pididiskusyon ra. Ket na'kit na nin mapteg a kauubat na ni Jesus. Kanya' nin tinmepet ya kona a wana, “Aya a sangkaimpurtantiwan nin matkap nin tukiden nin gan-gan?” ");
INSERT INTO smkNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ket wana ni Jesus, “Siti a sangkaimpurtantiwan nin matkap nin tukiden nin gan-gan: ‘Si'kamon puri na ni Israel, rumnge' kamo. Si Uunuren a Dios tamo, syay bukod nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Aduen may Uunuren a si Dios mo nin intiron kanakman mo, nin intiron byay mo, nin intiron kaisipan mo tan nin intiron pakababa' mo.’ ");
INSERT INTO smkNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ket siti a ikarwan sangkaimpurtantiwan: ‘Aduen moy kapada mon tawo nin kapada nin pangangado' mo sa lalaman mon diri.’ Kasaynan gan-gan nin mas impurtanti et dyan saraytin rwa.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ket wanan sitin Madunong sa Gugan-gan kona, “Kusto, Maistro. Tutuo in si wamoyo a si Dios ket sayan-saya ya tan kasan raruman Dios no kai sya tamo'. ");
INSERT INTO smkNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ket say aduen yay Dios nin intiron kanakman tan nin intiron kaisipan tan nin intiron pakababa', tan aduen saray kapadan tawo nin kapadan pangangado' sa lalaman nin diri, ket mas impurtanti et dyan si mangida'ton nin uayep a puuran tan raruma et nin duda'ton konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na'kit na ni Jesus nin maong a kauubat na ket wana kona, “Dandani kayna nin iti sa sirong nin pag'uuray nan Dios.” Ket nangibwat ana sin sain, kasaynan nakaitpel nin manepet kona. ");
INSERT INTO smkNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sin mampangyakay yadtaw si Jesus sa sakop nan Timplo, wana, “Mayin bale' a man'ibarita' ran saray Madudunong sa Gugan-gan, a si syay Cristo nin nipangako' nan Dios, ket puri naya ni Adi' David? ");
INSERT INTO smkNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ket si Adi' David a mismo, yupa' sa nipaninreg nan Ispirito nan Dios ket nibarita' na nin wana, ‘Wanan Dios konan Uunuren ko: Tumekre' kadti sa pawanan ko mintras nin mampasukuen kosara komo a sarba ran kukalaban mo.’ ");
INSERT INTO smkNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Si Adi' David nin mismo, tinawag naya nin Uunuren a Cristo nin nipangako' kona, ket pa'no edet a sya ket puri naya ey?” Saray abaw nin tawo, lalon maririket saran nangrenge' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sin mampangyakay ya konra wana, “Pakanda' kamo nin kai kamo mag'in nin bilang konran Madudunong sa Gugan-gan a rabay-rabay ray magpasyar nin anununro a aysing ra tan say pagalangan rasaran tutawo sa publiko. ");
INSERT INTO smkNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rabay-rabay ray tumekre' sa tekrean para konran impurtantin tutawo sa sinaguga. Wanin et a lamang no mako sara sa punsya. ");
INSERT INTO smkNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kitkiten ray kabyayan ran bubbayin balo, ket paanunrwen ray dasal ra nin panismula nin maraet a gawa' ra. Ket anaod pinasyan byat li' nin dusa nan Dios konra.” ");
INSERT INTO smkNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nainsanan nin buga', nako ya nin tinmekre' si Jesus sa temben nan pangnanabuan nin kwartan da'ton sa Timplo. Binanta-bantayan nay nipanginabo' ran tutawo. Malalaem a ninabo' ran mayayaman. ");
INSERT INTO smkNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ket main anamaet nin sayay pubrin babayin balo nin rinmate' itaw. Nanginabo' yan rwa ran plata nin sangkadaitean a alaga. ");
INSERT INTO smkNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pinakadani nasara ni Jesus a tumutumbok na kona tan wana konra, “Ibarita' koyti komoyo, sitin pubrin balon babayi, mas abaw a ninabo' na dyan say sarban ninabo' ra nin saray raruma et nin nanginabo' ");
INSERT INTO smkNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ta say subra-subra tamo' konra a nibi ra. Si balo bale', sa busel nin kaidapan na, nibi na a sarba nga'min nin pagkabyayan na.” ");
INSERT INTO smkNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ket sawanin, sin manlumiwa' ya sa sakop nan Timplo si Jesus, wanan saya nin tumutumbok na kona, “Maistro, kikiten mo! Aninay anda' nin pupa'deng nan siti si Timplo! Aninay kaalalakyan nin sain say bubaton inusar!” ");
INSERT INTO smkNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ket wana ni Jesus kona, “Mangkiten-kiten mo in say alalakin pupa'deng sawanin! Bale' main li' nin awro a mayba' in, ket kasayna li' gapo ni sayan bato nin isen a ma'kit nin naita'len et konan saya.” ");
INSERT INTO smkNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kaaram, nuli' sara sa Talugtog nin Olibo ket tinmekre' ya si Jesus nin nakaadap sa Timplo. Sin sain, sara-sara tamo' a si Pedro, si Santiago, si Juan, tan si Andres, ket kinmadani sara kona tan wanra, ");
INSERT INTO smkNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ka'no li' nin mangyadi' in si wamoyon mayba' ya a Timplo? Ani li' a panandaan a mangkatukid ana in?” ");
INSERT INTO smkNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ket wanan ni'bat ni Jesus konra, “Pakatalad kamo nin kai kamo nin malingon tepren moyoy bula', ");
INSERT INTO smkNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ta abaw sara li' a mangusar nin ngaran ko a wanra ket sara a Cristo nin nipangako' nan Dios. Ket abaw sara li' a malingo ra. ");
INSERT INTO smkNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Marnge' moyo li' a danurdor nin pigigira sa kadani tan marnge-marnge' moyon main nin pigigira sa saka-sakalakon lugar. Bale' andi' kamo nin aburido ta sayti nin bubagay ket matkap nin mangyadi' yapo'. Bale' ambo' et nin iyayangga ana nin kapresan a pag'uuray iti sa mundo ");
INSERT INTO smkNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ta milalaban li' a nunasyon sa saya tan saya, tan wanin et a lamang sa pupag'urayan. Magkamain li' nin rayon sa abaw nin lulugar. Magkamain anamaet nin bitil. Bale' sain tarana' tamo' in nin rumate' nin dya'dya' kapadan tarana' nan mangingar nin sayay mangabing. ");
INSERT INTO smkNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pakatalad kamo ta si'kamo, dakpen rakamo li' tan bistawen rakamo li' tan sanet-saneten rakamo li' sa susinaguga. Iyadap rakamo li' nin usisaen konran mag'uuray tan uadi' bana' ta tumutumbok katamo. Mangyadi' in ta pigaw nin magkamain kamo nin pagkanawanawan maiparate' moyo konra a maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Matkap ya yapo' nin maipatanda' a Mabistan Patanda' sa sarban tawo sa sarban lugar, mi'sa say iyaangga ana nin kapresan nin pag'uuray iti sa mundo. ");
INSERT INTO smkNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No itaw kamoyna li' nin man'usisaen, andi' moyoyna nin kaaburidwan no ani a ibarita' moyo bana' ta no udas moyoyna li' nin tumnoy ket, ibarita' nayna li' nin Dios a ibarita' moyo ta ambo' nin si'kamo li' a mag'irgo no kai edet, si Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","No saytaw, main li' nin tutawo nin mangipapati nin bubsat ra. Main li' nin uama nin mangipapati nin a'nak ra. Main anamaet li' nin a'nak a magribildi tan mangipapati konran mangatua ra. ");
INSERT INTO smkNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wanin, guraen rakamon sarban tutawo bana' ta mantarig'enan moyoy mangkikalamo' kongko. Bale' si si'numan a tumarig'en nin tumulok kongko anggan kala'pusan nin dya'dya', makarate' ya sa Pag'adian nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Marate' li' a awro a main li' nin sitaw si ‘Makaparmay nin Bagay a Manida'’ nin itaw ya sa Timplo mataman nin ambo' nan kanepegan a itaw ya. (Si'kan mampamasa, tarusan maytin maong!) No ma'kit yaynayti li' nin bagay nin itaw yayna, saray mampiikap itaw sa Judea ket matkap a malayo saraynan mako nin umadi sa tutalugtog. ");
INSERT INTO smkNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Si tawon itaw nin mampagprisko sa balkon nin bali ra, andi' yayna nin lumuob et sa bali nin mangalap nin animan a agamiren na. ");
INSERT INTO smkNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wanin anamaet konan si itaw nin mampagtrabaho sa gagawa', andi' yayna nin sumubli' et sa bali ra ta pigaw nin mangalap yan seket na. ");
INSERT INTO smkNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kado' sarayna li' a mabuktot tan saray uinan main nin ua'nak ran mampasuswen konan siin a panaon! ");
INSERT INTO smkNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kanya' nin idasal moyo konan Dios a ambo' li' kumon nin tyimpon gawat no mangyadi' in ");
INSERT INTO smkNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ta say dya'dya' li' konan sitaw a panaon ket kasa gapo et nin kapadan nangyadi' ana nangibwat et sin naparsa yay mundo anggan sawanin, tan kasa gapo nin kapadan mangyadi' et li'. ");
INSERT INTO smkNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No kai na nin idisisyon nin Dios nin paanteden naya in nin panaon ket kasa li' gapo nin mabati' nin mabyay iti sa mundo. Bale' bana' konran pinili' nan Dios nin tutawo na, paanteden naya anadtaw li' in nin panaon. ");
INSERT INTO smkNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kanya' nin no saytaw li' ket main nin mamarita' komoyo a wana, ‘Syayna e a Cristo!’ o no wana, ‘Itaw ya e!’ andi' kamo nin mamper ");
INSERT INTO smkNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ta abaw sara li' a mibalu'-balo' nin sara a Cristo o a prupita sara. Mama'ki-pa'kit sara li' nin makapaka'ngap nin panandaan tan mumilagro ta pigaw nin lingwen rasaray tutawo, a no magwa' ket tagem nin saray pinili' nan Dios nin tutawo na. ");
INSERT INTO smkNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kanya' nin pakatalad kamo! Nibarita' koyna a sarba nga'min komoyo ba'yo et nin mangyadi'.” ");
INSERT INTO smkNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ket tampor kayadi' li' nin siin a panaon nin dya'dya', si awro ket dumedlem ya, tan si bulan ket kai yayna nin sumlag. ");
INSERT INTO smkNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Say bubituen ket mangaragrag mangibwat sa langit, tan say pupakayadi' a mamauksoy nin say itaw sa ta'gay nin langit ket maguloyna. ");
INSERT INTO smkNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kaaram, ma'kit rako li' nin sarban tutawo, si'kon si Pinaitawo nin manrumate' nin iti sa gunem nin main nin alakin pakayadi' tan kasan kapadan kagalangan. ");
INSERT INTO smkNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ket ibaki' kosara li' a uanghil ko nin mako sa sangkamundwan tan dinepen rasara nga'min a tutawon pinili' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kikiten moyay kayon igos ta main nin maadal moyo mangibwat kona. No sumalingsing yaynan gumulong, masigurado moyon rumate' anay tyimpon rapeg. ");
INSERT INTO smkNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wanin anamaet, no ma'kit moyoyna li' nin mampangyadi' ana in say nibarita' ko komoyo, matandaan moyoynan rumate' akoynan madali'. ");
INSERT INTO smkNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ibarita' koyti komoyo, no wanin ana li' anaod a mampangyadi', ba'yo kamo et nin mati nga'min ket matukid ana a sarban nibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Makasa a langit tan luta', bale' say ibarita' ko magnayon nin tutuo anggan-angga. ");
INSERT INTO smkNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Bale' no ka'non peteg nin mangyadi', kasa gapo nin makatanda', ni saray uanghil, o si'kon si Anak nan Dios. Kal-la si Ama ko tamo' a makatanda'. ");
INSERT INTO smkNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kanya' anaod nin pakatalad kamo! Sumadya' kamon pirmi ta kai moyo nin tanda' no ka'no nin mangyadi' ti. ");
INSERT INTO smkNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Say isusubli' ko nin si'kon si Pinaitawo ket maiyarig sa isusubli' nan sayay tawon kinmadayo'. Mi'sa ya nin nibwat sa bali na, binyan nasaran pakayadi' a tutawo na sa kayadian na. Nibibilin na sa barang saya a trabaho na tan ginan-gan nayay gwardya nin sibabantay ya sa isusubli' na. ");
INSERT INTO smkNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wanin anamaet, kai moyo nin tanda' no ka'no ako nin sumubli' a bilang sa isusubli' nan si main nin bali, sa patpaapon man, sa kapiknga' nin yabi man, sa parbangon man o sa kabubuklas man. Kanya' nin sumadya' kamo ");
INSERT INTO smkNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ta sali' no rumate' akon bigra' ket marat'anan katamo nin bilang sa sayay gwardya a mampa'lek sa udas nin paggagwardya na. ");
INSERT INTO smkNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Si ibarita' ko komoyo tan konran sarban tutawo ket: ‘Sumadya' kamo!’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ket, rway awro tana ba'yo a rwa ran pista ran Judio. Sarayti a pistan mantawagen nin Nipanglabas tan si sayay linggon Pangangan nin Tinapay a Kasan Pammakbo. Sawanin, saray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan ket mampangisip sara no pa'no raya nin dakpen si Jesus nin kai ra nin matandaan nin tutawo, mi'sa raya nin patyen. ");
INSERT INTO smkNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wanin ta wanra, “Bangli' no gumulo sara a abaw nin tawo no dakpen tamoya no pista.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Itaw ya si Jesus sa Betania sa bali na ni Simon a gindat nin main nin makaparmay nin masakit sa katat. Sin kapresan ran mampangan, main nin babayi nin nako kona ni Jesus a main awit nan sayay pangangwan a main nin laman nan pinasyan bili nin puron banglo nin say ngaran ket nardo. Ket simbing naya sa liey a pangangwan mi'sa na nin nibu'bo' a laman nan banglo sa ulo na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bale' masager saray umno nin itaw konan siin ket wanra sa saya tan saya, “Pinirdi nayna in nin banglo! ");
INSERT INTO smkNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Magwa' yan nalako' in kumon nin masurok sa matingkapan nin sayay taon mi'sa nibi et kumon a naglakuan konran pubri.” Talagan masager sara konan babayi. ");
INSERT INTO smkNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ket wana ni Jesus, “Pauryan moya! Ambale' nin kasagran moya? Pinasyan bista nin ginwa' na kongko. ");
INSERT INTO smkNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abirno nin ani a udas, isen saray pubri nin makalamo' moyo ket animan a udas nin rabay moyo saran tulungan, matulungan moyo sara. Bale' si'ko, ambo' ana nin ma'teng nin iti ako et komoyo. ");
INSERT INTO smkNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginwa' nay anggawan nin mababa' nan sitin babayi para kongko. Binanglwan nayayna a lalaman ko nin nisadya' nayayna para sa tabon ko. ");
INSERT INTO smkNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ibarita' koyti komoyo, adtiman a lugar sa intiron mundo a pakaipatandaan nan si Mabistan Patanda', say ginwa' nan sitin babayi ket maibari-barita' li' anamaet nin pammanemtem kona.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ket si Judas Iscariote a saya konran labinrwan tumutumbok na ni Jesus, nako ya konran Pupangulon Pupadi' ta pigaw nin nikitarusan yan ipagamet naya si Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Konan siin maririket sara, ket nipapagketan ran byan rayan kwarta. Anaod, nangibwat ana sin sain, nanirib yayna si Judas nin tyimpon maipagamet naya konra si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ket sawanin, sin primiron awro nin Pistan Pangangan nin Tinapay a Kasan Pammakbo, si awron pangmamati nin karniro para sa Pista nin Nipanglabas, wanran tumutumbok na ni Jesus, “Adti a rabay mo nin pangisadyaan min pangapunan tamo para sa Pistan Nipanglabas?” ");
INSERT INTO smkNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ket nibaki' nasaray rwan tumutumbok na a wana konra, “Mako kamodtaw sa syudad. Ket main li' nin lalaki nin masnaan moyodtaw a mampangawit yan sampayan ranom. Tumbuken moya ");
INSERT INTO smkNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","angga nin lumuob ya sa sayay bali. Ket wamoyo konan main nin ikon konan bali, ‘Wana ni Maistro tamo, no adti ya kano a kwarto nin kidungwan na komi nin tumutumbok na nin mangapon no Pistan Nipanglabas?’ ");
INSERT INTO smkNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ket ipa'kit naya komoyoy sayay alawang nin kwarto sa ta'gay a nasadya' ana tan kumplito anay agamiren. Ket itaw, manadya' kamo nin kumana' kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ket nako saraytin tumutumbok na sa syudad tan nadumog rayaytaw si nibarita' na ni Jesus konra. Ket nisadya' raynay pangapunan ra sa pista. ");
INSERT INTO smkNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ket sin yabi ana, nako yadtaw si Jesus tan saray labinrwan tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sin kapresan ray mampangan, wana ni Jesus, “Ibarita' koyti komoyo, saya komoyon kadungo kodti a magtraidor kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ket rinmere' sara a tumutumbok na tan say barang saya ket wana kona ni Jesus, “Maibarita' mo para nin si'ko?” ");
INSERT INTO smkNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ket wana konra, “Si saya anaod komoyon labinrwan tumutumbok ko nin mangkipanawsaw kongko nin tinapay sa yawong. ");
INSERT INTO smkNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Si'kon si Pinaitawo, mati ako nin bilang sa wana sa Kasuratan. Bale' kado' yayna in si magtraidor kongko! Maong ana kumon a kai ya nin naiyanak.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sin kapresan ran mampangan, nangalap yan tinapay si Jesus, tan nikisalamat ya konan Dios mi'sa nin simpi-simping naya tan nitayak na konran tumutumbok na. Wana, “Kalapen moyayti. Siti a lalaman ko.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kaaram, kinalap nayay baso a main nin arak nin ubas. Nikisalamat ya konan Dios, mi'sa nibi naya konra ket ninom sara nga'min konan siti. ");
INSERT INTO smkNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ket wana konra, “Sayti a daya' ko nin mama'get nin kataratwan konan Dios. Tumuro' li' nin mati ako para sa abaw nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ibarita' koyti komoyo, kai akoyna gapo nin minom nin arak nin ubas anggan konan sitaw si awron minom ako li' nin ba'yon arak sa Pag'adian nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sin nayadi' sara nin nangansyon nin pangrarayo konan Dios, nibwat saran nako sa Talugtog Olibo. ");
INSERT INTO smkNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ket wana ni Jesus konra, “Sarba moyo nga'min ket palaywan rako li' nin bilang sa naisurat sa Kasuratan a wana, ‘Patyen koya li' a mammastor ket saray karniro misisyak sara.’ ");
INSERT INTO smkNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bale' saytaw li' no napasubli' akoyna nin mabyay, mu'na akoyna li' tan taga'nan katamodtaw sa Galilea.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wana nin nag'irgo ni Pedro, “Lakwanan rakayna nga'min, bale' si'ko ket kai gapo.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wana ni Jesus kona, “Ibarita' ko komo, Pedro, ba'yo main nin tumarang'ok nin pirwa nin manok konan sitin yabi, mitlo moyna nin nibudi' a katanda' nako.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bale' wana ni Pedro nin nipatib'ey, “Mataman et nin kalamo' nako nin patyen ana, kai ko gapo nin ibudi' a katanda' taka.” Wanin anamaet a lamang a wanra nin saray sarban tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Rinmate' sara si Jesus itaw sa sayay lugar a pinangaranan nin Getsemani. Wana konran tumutumbok na, “Mabati' kamodti leleg a mandumasal ako.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ni'ras nasaran kalalamo' na si Pedro, si Santiago tan si Juan. Marere' yan tuloy tan pinasyan byat nin man'isipen na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wana konra, “Pinasyan tuloy nin bereng ko ket ipati koyna layi. Mabati' kamodti, tan andi' kamo nin ma'lek.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kinmadayo' yan buga' konra, mi'sa linmukob ya ta pigaw nin idasal na a no magwa' kumon ket kai nayna nin dalanan in si panaon nin pangingirangep na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wana, “Ama ko! Sa sarban bagay ket main pakayadi' mo nin mangwa'. Andi' moyna kumon nin ipairangep kongko in say dya'dya' a adapen kon irangep. Wanin man, ambo' nin say karabayan ko a masunor, no kai say karabayan mo.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sin sinmubli' ya konran saray tulon tumutumbok na, narat'anan nasaran mangka'lek. Pinukaw nasara tan wana kona ni Pedro, “Simon, mampa'lek ka anamain! Kai mo tana para nin magwa' a andi' nin ma'lek yapo' abirno nin sayay udas tamo'? ");
INSERT INTO smkNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Andi' kamo nin ma'lek no kai edet, dumasal kamo ta pigaw nin kai kamo nin madaeg nin tukso, ta sa nakem moyo ket disidido kamon gaw'en moyoy manepeg bale' mapatapo' kamon kinatawo moyo.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kinmadayo' yaynamanaet tan dinmasal yan wantaw lamang sa nu'nan dasal na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sin sinmubli' yaynamanaet sa kami'nan ran tulo nin tumutumbok na ket mampa'lek sara anamanaet ta talagan kai ra nin mapukpukan a elek ra. Sin nakaimata sara, kai ra nin tanda' no ani a i'bat ra kona. ");
INSERT INTO smkNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sin sinmubli' yan pitlo konra wana, “Mangka'lek kamo et! Kustoyna in! Narate' anay udas! Pakanda' kamo! Si'kon si Pinaitawo ket maipagamet akoyna konran duka' a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mibangon kamo tan sumna' atamo! Syayna e a tawon nagtraidor kongko.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mampag'irgo ya et si Jesus ket kapingmatan nin rinmate' ya si Judas a saya konran labinrwan tumutumbok na. Abaw saray tutawon kalamo' na nin nibaki' ran Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan tan saray Mangatuntawo ran Judio. Di-beneng tan di-batuta' sara. ");
INSERT INTO smkNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nibarita' naynan gindat konra ni Judas no pa'no rayan maipurok si Jesus. Wana, “Si arkan ko, syaytaw nin diri. Dakpen moya. Ket i'ras moya nin gwardyawan moyan maong.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sin rinmate' yadtaw si Judas, diri-diritso na kona ni Jesus. Ket wana, “Maistro!” Mi'sa naya nin inarkan. ");
INSERT INTO smkNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ket dinakep rayayna si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Konan siin, si saya konran itaw a naka'deng, inuyos nayay beneng na tan tinaga' nayay sayay katulong nan si Sangkata'gayan nin Padi' ket naglat yan nataga' a tutulyan na. ");
INSERT INTO smkNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ket wana ni Jesus konran tutawo, “Saya ako para nin kriminal ta nakabeneng kamo tan main nin pekpek moyo nin manakep kongko? ");
INSERT INTO smkNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inawru-awro kon nangyakay komoyo itaw sa sakop nan Timplo, kai rakoyna nin dinakep itaw! Bale' sayti ket matkap nin mangyadi' kongko ta pigaw nin matukid a naisurat sa Kasuratan.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ket nagsipalayo sara nga'min a tumutumbok na tan linakwanan raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Main nin sayay tububa'yon tinmumbok kona ni Jesus nin nipunggos ya tamo' nin ules. Ket tinarigmusan raya nin tutawo ta pigaw nin ikidakep raya kumon. ");
INSERT INTO smkNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bale' pinaipuslit ya sa punggos nan ules ket palayo nan lus'ok. ");
INSERT INTO smkNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sawanin, nika' raya si Jesus sa bali nan Sangkata'gayan nin Padi'. Itaw nididinep sara a Pupangulon Pupadi', saray Mangatuntawo ran Judio tan saray Madudunong sa Gugan-gan. ");
INSERT INTO smkNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro, tinmumbu-tumbok ya bale' itaw sa dayo' anggan sa baraybay nin bali nan Sangkata'gayan nin Padi'. Mi'sa nako ya nin nikidupong nin tinmekre' konran gwardya nin pairangrang ya sa apoy. ");
INSERT INTO smkNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Saray Pupangulon Pupadi' tan sarba ran myimbro nan Kunsiho ran Judio ket naningka-tingkap saran maiparsa ra kona ni Jesus ta pigaw nin masintinsyawan ya nin patiti. Bale' kasan na'kit ra ");
INSERT INTO smkNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ta abirno nin abaw saray nangibarita' nin bula'-bula' nin kuntra kona ket kai anamaet nin mikukumprunta a nibarita' nin saya sa saya. ");
INSERT INTO smkNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sin wanin, main nin umno ray pinaipadar nin magtistigos nin mibula'-bula' nin kuntra kona ni Jesus. Wanra, ");
INSERT INTO smkNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Narnge' mi nin wanan siin, ‘Sidaen koyayti si Timplo nin nipa'deng ran tutawo ket sa luob nin tuloy awro, pa'dengen koyay sakalakon Timplo nin ambo' nin gawa' nin tawo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ket mataman nin say ibari-barita' ran sarayti ket kai nin mikukumprunta. ");
INSERT INTO smkNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ket sin sain, inumdeng ya a Sangkata'gayan nin Padi' sa adapan ra nga'min ta pigaw nin usisaen naya si Jesus, ket wana, “Ani a mai'bat mo sa sain nin man'iparsa ra komo?” ");
INSERT INTO smkNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bale' kai ya gapo nin nag'irgo si Jesus. Ket tinepetan naya anamanan Sangkata'gayan nin Padi' a wana, “Si'ka para a Cristo a si Anak nan Dios a sya ket Marayo ya?” ");
INSERT INTO smkNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“O', si'ko,” wana ni Jesus. “Ket ma'kit rako li' nin si'kon si Pinaitawo nin nakatekre' iti sa pawanan nan Dios a sya a Makapangyayadi', nin mangkumayupa' akon iti sa gunem mangibwat sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sin narnge' nayti nin si Sangkata'gayan nin Padi', rinakyat nay seket na nin pangipa'kit nan alakin sager na. Wana, “Matkap et paray tistigos kuntra kona? ");
INSERT INTO smkNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Narnge' moyoyna nin mismo sawanin a pangungu'na-u'na na konan Dios! Ani a wamoyo?” Ket nipapasayawan ra nga'min a sintinsyawan yan patiti. ");
INSERT INTO smkNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ket linuda'-ludaan rayaynan raruma sa rupa si Jesus. Main nin namepet nin mata na tan tinasu-taso raya a wanra, “Prupita ka; ibarita' mo edet no si'noy nanaso komo!” Ket sin naipagamet yayna konran gwardya, rinampa-rampa' raya. ");
INSERT INTO smkNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sawanin, itaw ya si Pedro sa yupa' sa baraybay nan palasyo sin nako yadtaw a sayay alila' nan babayi nin Sangkata'gayan nin Padi'. ");
INSERT INTO smkNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ket na'kit naya si Pedro nin mampairangrang. Pinastang nayan maong mi'sa wana, “Saya ka anamaet konran kalalamo' nan sitaw si Jesus a taga Nazaret.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bale' nibudi' na in ni Pedro a wana, “Kai ko nin tanda', ni matarusan in say man'ibarita' mo!” Ket inmalis yan nako sa purta nan pukok. Ket main nin tinmarang'ok nin manok. ");
INSERT INTO smkNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na'kit nayaynaet itaw nin si babayi tan nibari-barita' na konran itaw, “Siin nin tawo ket saya ya konran kalalamo' na!” ");
INSERT INTO smkNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bale' nibudi' naynaet ti ni Pedro. Nainsanan nin buga', wanra anamaet nin tutawo nin itaw kona ni Pedro, “Page' a saya ka konran kalalamo' na ta si'ka ket taga Galilea kaynamaet.” ");
INSERT INTO smkNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ket wana, “Dusawen nakon Dios no ambo' nin tutuo a man'ibarita' ko. Sambawan ko nin kai koya gapo nin katanda' in si tawon man'irgwen moyo!” ");
INSERT INTO smkNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kapingmatan, main nin tinmarang'ok nin manok nin pirwa. Ket napanemtem naytaw ni Pedro say nibarita' na ni Jesus kona nin wana, “Ba'yo main nin tumarang'ok nin manok nin pirwa, nitlo moyna nin nibudi' a katanda' nako.” Ket abet-abet na ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ket sawanin, sin kabubuklas nin tuloy, nididinep sara a Pupangulon Pupadi', saray Mangatuntawo ran Judio, saray Madudunong sa Gugan-gan tan saray raruma et nin iti sa Kunsiho ran Judio, nin nag'iirgwan ra no ani a matkap ran gaw'en kona ni Jesus. Ket binaror ray gamet na, mi'sa raya nin ni'ras kona ni Pilato a sya a gubirnador. ");
INSERT INTO smkNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ket tinepetan naya ni Pilato a wana, “Si'ka paran page' a Adi' ran Judio?” Ket ni'bat na ni Jesus, “Nairgo moyoyna.” ");
INSERT INTO smkNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ket abaw a niparsa-parsa ran Pupangulon Pupadi' kona. ");
INSERT INTO smkNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ket sin wanin tinepetan nayaynaet ni Pilato. Wana, “Kasa paran mai'bat mo? Narnge' moy abaw a man'iparsa ra komo!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bale' kai yayna gapo nin inumbat et si Jesus. Ket maka'ngap yan tuloy si Pilato. ");
INSERT INTO smkNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sawanin, ugali' na ni Pilato a mamirdunan mangibulos nin sayay priso tepe' nin Pistan Nipanglabas nin no si'no a dawaten ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sin sain, main saray tawon mangkapriso bana' ta nakapati sara sin nagribildi sara sa gubyirno. Saya konran sarayti ket si say ngaran na Barrabas. ");
INSERT INTO smkNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ket sin nako sara nin inmadap a ka'bawan ran tawo kona ni Pilato ta pigaw nin dawaten ran gaw'en nay gindat nan man-gaw'en, ");
INSERT INTO smkNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","wana konra, “Rabay moyo para a bulusan koyayti si Adi' moyon Judio?” ");
INSERT INTO smkNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wanin a wana ta tanda' nan peteg a niyadap raya si Jesus kona nin saray Pupangulon Pupadi' bana' ta maimbel sara. ");
INSERT INTO smkNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bale' sinugsog rasaran Pupangulon Pupadi' a tutawo nin dawaten ran bulusan naya si Barrabas ambo' a si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ket wana ni Pilato konra, “No wanin edet ani a gaw'en ko konan si tawon mantawagen moyon Adi' moyon Judio?” ");
INSERT INTO smkNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ket nita'way ran ni'bat, “Ipasak ma sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ambale'?” wana. “Main paran ginwa' nan abas?” Bale' mas maksaw rayna edet nin niburyaw, “Ipasak ma sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ket sin wanin, bana' ta rabay nasaran pagustwan ni Pilato a tutawo, nibulos naya si Barrabas. Ket si Jesus anamaet, nipasanet naya tan sin nayadi', nipagamet naya konran sundalo' ta pigaw nin ika' raya nin ipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sin sain, ni'ras raya nin sundalo' si Jesus sa luob nan Palasyo nan gubirnador a mantawagen yayti nin Pretorio tan pinididinep rasaray sarba ran sundalo' nin itaw. ");
INSERT INTO smkNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kaaram, sinulutan raya nin kulor ubi nin kapa a kano wadi' ket adi' ya. Namalukay saran madiwin wakay nin kuruna kano wadi' tan nikuruna rayayti kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mi'sa kano wadi' ket nangigalang sara kona a wanra, “Viva Adi' ran Judio!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mi'sa pinatuk-patok rayay ulo na tan linuda'-ludaan raya tan nanali-talimukod sara sa adapan na nin kano wadi' ket pangingigalang ra kona. ");
INSERT INTO smkNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sin sinmawa' saraynan nagpistawan ya, linus'ok rayaytaw kona si kulor ubin kapa tan nisubli' ran nisulot kona a dirin seket na. Kaaram, niliwa' rayaynan ika' nin ipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa dalan, main nin sayay lalaki nin nasnaan ra nin mampamunta sa syudad. Siti si Simon a taga Cirene. Syay ama ra ni Alejandro tan Rufo. Ket pinasuet rayan nipabalatay kona a kudos nin mambalatayen na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ket nika' rayaynadtaw si Jesus sa lugar a mantawagen nin Golgota a say rabay nan irgwen ket Lugar nin But'ol Ulo. ");
INSERT INTO smkNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sin itaw sarayna, painumen raya kumon nin arak a linawukan nin pammakdar a mantawagen nin mira bale' kai na nin ininom. ");
INSERT INTO smkNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ket nipasak rayayna sa kudos si Jesus. Kayadi', nibubunutan sara ta pigaw nin mapitaw'a-taw'an ray seket na, a no ani a mako sa barang nin saya. ");
INSERT INTO smkNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nwibi sa buklas sin nipasak raya si Jesus sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nakasurat itaw a nipakasalanan kona a wana: SITI A ADI' RAN JUDIO. ");
INSERT INTO smkNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Main anamaet nin rwa ran kriminal a nikirngan ran nipasak sa kudos kona ni Jesus, si saya sa wanan na tan si saya sa wiri na. ");
INSERT INTO smkNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Saray tutawon lumabas itaw, ipeyeng-peyeng ran manuya'-tuya' kona ni Jesus. Wanra, “Ya! Si'ka a wamo intaw ket mababa' man yubaen tan ipa'deng nin uman a Timplo nan Dios sa luob nin tuloy awro, sigi pa edet! ");
INSERT INTO smkNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Isalba moy lalaman mon diri, gumlat kadsen sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wanin ra anamaet nin Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan. Tinuya'-tuya' raya si Jesus a wanra sa saya tan saya, “Saray raruman tawo, naisalba nasara kano, bale' say lalaman nan diri, kai! ");
INSERT INTO smkNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siin si sya a Cristo nin Adi' nan Israel, makaglat yadsen tana in sa kudos sawanin nin ma'kit tamon diri, mamper atamoyna kona!” Mataman nin saray kriminal nin karngan nan nipasak ni Jesus, tinuya'-tuya' rayan lamang anamaet. ");
INSERT INTO smkNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sin ugtiawro, dinmedlem yay intiron babon luta' nin narate' a tuloy udas. ");
INSERT INTO smkNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ket sin bandan alas tres nin yabina, wanan nita'way ni Jesus, “Eloi, Eloi, lama sabachthani?” a say katarusan ket “Dios ko, Dios ko, ambale' nin pinauryan nako?” ");
INSERT INTO smkNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wanran tutawodtaw nin nakarnge' kona, “Reng'en moyaytaw e! Mantawagen naya si Elias!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ket si saya konra nangred yan nako nangipaalep'ep nin ispungha sa maalsem nin arak nin nikwa naya sa parpar nin bislak ta pigaw nin ipasepsep naya kona ni Jesus. Ba'yo wana, “A! Pauryan ma! Sawanin, kiten tamo pa no rumate' yan page' si prupita Elias nin keen naya nin galten isen sa kudos.” ");
INSERT INTO smkNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tinma'way yan maksaw si Jesus, kaaram nati yayna. ");
INSERT INTO smkNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sin sain a lamang, nabisang yan napiknga' nangibwat sa ta'gay anggan saroy a kurtina nin salimbeng nan Sangkasantusan nin Lugar sa Timplo. ");
INSERT INTO smkNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ket sin naimatunan na nin kapitan ran sundalo' a naka'deng itaw sa adapan na ni Jesus nin wanin a nipati na, wana, “Page' a anak nayaytin Dios!” ");
INSERT INTO smkNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Main anamaet nin bubbayin itaw sa dayo' nin mampamantay. Itaw sara si Maria nin taga Magdala, si Salome, tan si Maria nin ina ra ni Jose tan ni Santiago a anak et. ");
INSERT INTO smkNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sin saytaw ket nayi sarayti tan nangasikaso sara kona ni Jesus sin itaw ya sa Galilea. Abaw sara et a raruman bubbayidtaw a nayi kona sin tinmangkar yan nako sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ket yumabinayna konan siin a Awron Pananadya' para sa Awron Painawa ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Itaw ya si Jose a taga Arimatea, a sayay mapagalang nin myimbro nan Kunsiho ran Judio tan mantuma'gan ya sa irarate' nin pag'aadi' nan Dios. Bana' ta yabinayna konan siin a awro, pinaksaw nay nakem na ket nako ya kona ni Pilato nin nikidawat yan aburoy a kalapen nayay bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naka'ngap ya si Pilato nin nakarnge' a nati yaynan nadali' si Jesus. Kanya' nin nipakayaban nayay kapitan ran sundalo' ta tinepet na kona no page' a nati yayna si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ket sin natandaan na kona nin kapitan a wanin anaod, inaburuyan naya si Jose nin kalapen nayay bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ket nako ya nanaliw si Jose nin mabistan klasin abel a maputi' nin mantawagen nin diilo, mi'sa nikayupa' nayay bangkay na ni Jesus nangibwat sa kudos tan binarkot naya nin sitin abel. Mi'sa nipaida' naya konan sayay pannabunan a kinalin bara'mon yukib sa bato, ket nitulin nayan nisada' sa purta nan pannabunan a sayay alakin bato. ");
INSERT INTO smkNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ket si Maria a taga Magdala tan si Maria nin ina na ni Jose, na'kit ray nipanabon kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ket sawanin, sin napalabas anay Awron Painawa, si Maria a taga Magdala, si Salome, tan si Maria nin ina na ni Santiago, nanaliw saran banglo ta pigaw nin banglwan rayay bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sin kabubuklas nin Linggo, nako saradtaw sa nanabunan. Leg'an ran adap itaw, ");
INSERT INTO smkNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","mampiiirgo sara a wanra, “Si'no kadi' a mangitulin konan bato nin nisada' sa nanabunan?” ");
INSERT INTO smkNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wanin a wanra bana' ta pinasyan kaalakyan nan sitaw si bato. Bale' sin kinmikit saradtaw sa nanabunan, na'kit ran si bato ket naitulin yayna. ");
INSERT INTO smkNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ket sinumrep sara tan main nin na'kit radtaw nin sayay tumububa'yo nin anghil a bakas na nin mantumekre' ya sa pawanan a nisket yan anro tan maputi'. Ket nali'mwan sara kona. ");
INSERT INTO smkNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ket wana konra, “Andi' kamo nin mabigra'. Tanda' kon mantikapen moya si Jesus a taga Nazaret nin nipasak sa kudos. Kasa yaynadti ta sinmubli' yan mabyay. Kikiten moyo. Siti e a lugar nin nangipaidaan kona. ");
INSERT INTO smkNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sawanin, mako kamoyna ta ibarita' moyoyti konran tumutumbok pati kona ni Pedro nin wamoyo, ‘Mu'na yaynadtaw si Jesus sa Galilea. Itaw ket ma'kit moya nin bilang sa nibarita' na komoyo sin saytaw.’ ” ");
INSERT INTO smkNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Konan siin linmiwa' saradtaw sa nanabunan tan nangred sara ta pinasyan nikabigra' ra. Mangingintar sara sa nikali'mwan ra. Ket bana' ta wanin anay li'mo ra, kai sara gapo nin nangibarita' nin animan sa si'numan. ");
INSERT INTO smkNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ket sawanin, sin sinmubli' yaynan mabyay si Jesus sin masakbay et konan sitaw nin awron Linggo, kona ni Maria a taga Magdala nin namalakwanan nan pito ran uispiriton duka' a nu'nan nipa'kitan na. ");
INSERT INTO smkNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ket nako yan tampor si Maria konran mabereng tan man'umakis a tumutumbok na ni Jesus. Ket nibarita' na konra a sinmubli' yaynan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nibarita' na et konra a na'kit naya, bale' kai rayti nin timper. ");
INSERT INTO smkNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kayadi' nin siti, nipa'kit ya nin main nin sakalakon bakas konran rwan tumutumbok na a manlumalakon adap sa baryo. ");
INSERT INTO smkNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ket saraytin rwa, sinmubli' sara tan nibarita' rayti konran raruman tumutumbok bale' kai saraynaet nin namper konra. ");
INSERT INTO smkNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sinmunor, pinaipa'kit ya konran labinsayan tumutumbok na sin mampangan sara. Nikapuet nasara bana' ta benged sara tan bana' ta kai rasara nin timper a naka'kit kona kayadi' a sinmubli' yaynan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wana et konra, “Mako kamo nin ipatandaan moya sa sarban tawo sa sarban lugar iti sa luta' a Mabistan Patanda'. ");
INSERT INTO smkNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Si si'numan nin mamper tan mabawtismwan ya ket maisalba ya. Bale' si si'numan nin kai nin mamper ket masintinsyawan yan madusa. ");
INSERT INTO smkNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ket sayti a pupaka'kitan a magkamain konran magmatalek kongko: Makapalakwan saran uispiriton duka' yupa' sa pakayadi' ko. Makapag'irgo saran saka-sakalakon kai ra nin inadal nin uirgo. ");
INSERT INTO smkNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mataman no makaga'get saran ulay o makainom saran samal ket kai sara nin mangno. No ipababo ray gamet ra konran mampagmasakit ket umanda' sara.” ");
INSERT INTO smkNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sin nayadi' yayna nin nikiirgo si Jesus a Uunuren konran tumutumbok na, niyuli' yayna sa langit ket tinmekre' ya sa pawanan nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ket saray tumutumbok na nika' raya nin nipata-patanda' anaod a Mabistan Patanda' sa sarban lugar. Ket si Uunuren a si Jesus anamaet ket tinulungan nasara tan pina'get nay katutu'wan nin man'ipata-patandaan ra yupa' sa makapaka'ngap a pupaka'kitan nin nipagwa' na konra.");
INSERT INTO smkNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mapagalang a Teofilo: Abaw sarayna a inasirta ran nisurat a bubagay nin tinukid nan ginwa' nin Dios iti komin mammemper kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Say nisurat ra ket saytaw say nibarita' ra komi nin saray mismon naka'kit sa ginwa-ginwa' nan Dios nangibwat sin katarana', ket nipata-patanda' ra anamaet a minsahi nin nangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ket bana' anaod ta inusisa' kon maong a sarban saytin nangyadi' nangibwat sin tarana', edet naisip kon mabista anamaet nin isurat ko nin naunong para komoyo ");
INSERT INTO smkNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta pigaw nin matandaan moyon peteg a say niyakay komoyo ket tutuo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Itarana' kodti: Sin saytaw sin si Herodes a adi' sa prubinsyan Judea, main nin sayay padi' a say ngaran na ket Zacarias. Saya yan iti sa grupon pupadi' a nipangaran kona ni Abias. Si asawa na ni Zacarias nin say ngaran na ket Elisabet, puri naya ni Aaron a saya yan lamang anamaet nin padi' sin saytaw. ");
INSERT INTO smkNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Saraytin mitraasawa ket matunong sara sa pangingikit nan Dios nin mantumbuken ra a sarban gan-gan tan ipatumbok nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bale' kasan anak ra bana' ta baog ya si Elisabet. Saya et, sin sain ket masiken tan akulaw sarayna. ");
INSERT INTO smkNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ni'sa, turno nan grupo na ni Zacarias a magsirbin padi' sa Timplo nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sawanin, ugali' ran pupadi' a mibunutan ta pigaw nin matandaan no si'no a lumuob itaw sa Timplo nan Dios nin mamuor nin insinso, ket si ngaran na ni Zacarias a nabunot. ");
INSERT INTO smkNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Leg'an nan mampamuor, sarba radtaw nin mampangrayo ket mandumasal sara sa liwa'. ");
INSERT INTO smkNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ket kapingmatan main anan sayay anghil nan Dios a naka'deng sa pawanan nan altar nin pammuuran nin insinso a pina'kit kona ni Zacarias, ");
INSERT INTO smkNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ket nabigra' tan nali'mwan ya. ");
INSERT INTO smkNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wana bale' nin anghil kona, “Andi' ka nin mali'mo, Zacarias, ta rinnge' nan Dios a dasal mo. Ket si Elisabet a asawa mo, manganak ya li' nin lalaki! Pangaranan man Juan. ");
INSERT INTO smkNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Say ikaiyanak na ket mamaririket tan mamariga li' komoyo tan konran abaw a tutawo; ");
INSERT INTO smkNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bana' ta alaki tan impurtanti ya li' nin tawo sa pangingikit nan Dios. Matkap a kai yaynaod nin minom nin arak o animan nin makapabok. Mag'uray yay Ispirito nan Dios kona mataman itaw ya et sa tyan nan ina na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pasublien nasara li' a abaw nin Israelita konan Dios a Uunuren ra. ");
INSERT INTO smkNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Say pinanakem tan pakayadi' na ket bilang sa nibi nan Ispirito nan Dios kona ni Elias a prupita nan Dios sin nu'nan panaon. Pasublien na li' a mabistan pisisimbatan nin mangatua tan ua'nak. Saray subag konan Dios ket, gaw'en nan kipada anay pangingisip ra konran matunong. Ket mu'na yayna ta pigaw nin isadya' nasaray tutawo sa pag'uuray nan Uunuren.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ket, tinepetan naya ni Zacarias a anghil, “Pa'no ko wadi' nin mapihon mangyadi' in ta si'kami nin mitraasawa ket pariho kamin matuntawo ana?” ");
INSERT INTO smkNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Inumbat yay anghil kona a wana, “Si'ko si Gabriel a mampagsirbi lawas konan Dios. Si Dios nibaki' nakodti komo ta pigaw nin ika' koya iparate' ti nin mabistan patanda' komo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Edet, maumel ka leg'an a siin nin nibarita' ko komo ket kai ya et nangyadi' bana' ta kai ka nin mamper. Sitin naipatanda' komo ket siguradon mangyadi' li' no rumate' a panaon nin nitanda' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sin sain, saray tutawo anamaet, itaw sara sa rikor nin Timplo a mantaga'nan raya si Zacarias. Maka'ngap sarayna ta na'teng yaynadtaw sa luob. ");
INSERT INTO smkNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sin linmiwa' ya ket kai yayna nin makapag'irgo no kai sinya-sinyas tanay pitarusan ra ta umel yaynaod ana; kanya' nin nipa'ka' ra a main nin makapaka'ngap a nipa'kit nan Dios konadtaw sa luob. ");
INSERT INTO smkNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sin nayadi' anay turno nan grupo na ni Zacarias, sinmubli' yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ambo' nin na'teng, mabuktot yayna si Elisabet a asawa na, ket pinaipukok yan limay bulan sa bali ra. Wana sa nakem na, ");
INSERT INTO smkNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ay, narate' a lamang! Kina'dwan nakon lamang nin Dios. Ginlat naya a pakabalawan kon kai manganak!” ");
INSERT INTO smkNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sin a'nem a bulan naynan mabuktot ni Elisabet, nibaki' naya anamaet nin Dios si anghil a Gabriel sa Nazaret, sayay babali sa prubinsyan Galilea. ");
INSERT INTO smkNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pinako naya konan sayay balasang itaw a say ngaran na ket Maria. Naitanda' yaynan pakasal konan sayay lalaki a say ngaran na ket Jose, a nangibwat ya sa puri na ni adi' a David. ");
INSERT INTO smkNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ket nako ya anaod a anghil kona ni Maria tan nangigalang ya kona a wana, “Rumiriket ka, Maria! Si Dios, kinawa-kawa'nan naka ket adani ya komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nabigra' ya si Maria sa nibarita' nan anghil ket inisip-isip na no ani kadi' a pipa'kaan nin inirgo na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ket wanan anghil kona, “Andi' ka nin masalak, Maria, ta napaririketan yan tuloy a Dios komo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gumuktot ka tan lalaki yay iyanak mo, ket pangaranan ma li' nin Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pinasyan kata'gayan li' nin nikatawo na, tan tawagen ya li' nin Anak nan Sangkata'gayan nin Dios. Si Uunuren a Dios gaw'en na a siin nin iyanak mo ket mag'adi' ya sa lugar nan puon na a si adi' a David. ");
INSERT INTO smkNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag'uray ya li' konran puri na ni Israel anggan-angga tan say pag'uuray na ket kasan anggawan.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ket tinepetan naya ni Maria a anghil, “Pa'no in ket birhin ako et?” ");
INSERT INTO smkNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ni'bat nan anghil kona, “Si Ispirito nan Dios mako ya komo, ket sa pakayadi' nan Sangkata'gayan nin Dios gumuktot ka; kanya' nin si masanton iyanak mo li', nibaki' nayan Dios ket tawagen yan Anak nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wanin yan lamang si kanayon mon si Elisabet a say tanda' ket baog ya. Ginmuktot ya mataman no akulaw yaynan tuloy. Ika'nem a bulan nayna sawanin, a si iyanak na ket lalaki ya. ");
INSERT INTO smkNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anaod, kasan impusibli konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ket wana ni Maria konan anghil, “Si'ko, aripen nako nin Dios ket sain nin karabayan nan mangyadi' kongko, akuen ko.” Mi'sa, nibwat yaynay anghil. ");
INSERT INTO smkNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sin sain, nisukbot ya si Maria, tan nangapura yan nako sa sayay babalin itaw sa tutalugtog nin prubinsyan Judea, ");
INSERT INTO smkNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ta bisitawen nasara si Zacarias tan Elisabet. Sin rinmate' yadtaw konra, nangigalang ya kona ni Elisabet. ");
INSERT INTO smkNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sin narnge' naya ni Elisabet si Maria, sinmikwal yay buktot na ni Elisabet tan nag'uray yay Ispirito nan Dios kona, ");
INSERT INTO smkNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ket wanan maksaw, “Peteg a sangkakarmaan ka sa sarban bubbayi tan marayo ya li' anamaet a iyanak mo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aninaytin kagalangan a nibi nan Dios kongko ta si'kan si ina nan Uunuren ko ket mambisitawen nako! ");
INSERT INTO smkNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Anaod, eteng tuloy tamo' nin narnge' taka ket sinmikwal yay buktot ko sa ririket na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Makarma' ka, Maria, ta namper kan mangyadi' a nipatanda' nan Dios komo!” ");
INSERT INTO smkNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ket wana ni Maria, “Manraywen koyan tuloy a Catawan a Dios, ");
INSERT INTO smkNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tan maririket akon tuloy bana' konan Dios a syay Mangingisalba ko, ");
INSERT INTO smkNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ta pinili' nako mataman no ayupa' a kapapa'sar ko. Kanya' nin, mangibwat sawanin, say sarban tutawo sabtan rakon makarma' ");
INSERT INTO smkNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bana' sa makapaka'ngap a ginwa' nan Makapangyayadi' a Dios kongko. Naiduma yan peteg! ");
INSERT INTO smkNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mapainganga'do ya konran sarba ran mangunor kona, mangibwat ana konran saray nu'nan tutawo anggan sawanin. ");
INSERT INTO smkNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Man'ipa'kit na sa gawa'-gawa' na a alakin kapangyadian na. Pitayak-tayaken nasaray mampipata'gay, ");
INSERT INTO smkNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","main nin galten nay pakayadi' ran saray iti sa uray, ket itandudo' nasaray maayupa'. ");
INSERT INTO smkNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mampabsuyen nasara sa matkap ray mampagkurang, bale' konran mumayaman paibwaten nasaran kal-la gamet. ");
INSERT INTO smkNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tinulungan natamon si'tamon mampagsirbi kona nin puri na ni Israel. Anaod, tinukid na a pangako' na nin pangingipa'kit na kontamo nin inganga'do nan magnayon anggan-angga a sigon sa nipangako' na kona ni puon tamon si Abraham pati konran puri na.” Sain a wana ni Maria. ");
INSERT INTO smkNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ket itaw yan magtulon bulan si Maria konra ni Elisabet, mi'sa sinmubli' yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sawanin ket, narate' anay pangangabing na ni Elisabet. Ket lalaki yaynaod a niyanak na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sin natandaan ran kabaraybay tan kukanayon ra a maipa'ka' sa nipangabing na ni Elisabet, nikiririket sara kona bana' sa alakin inganga'do nan Dios kona. ");
INSERT INTO smkNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ket sin ikawalon awro naynan abing, abaw saray tutawon nakodtaw konra ta turien ya sigon sa kaugalian ran Judio. Pangaranan raya kumon a abing nin Zacarias a bilang sa ngaran na ni tatay na, ");
INSERT INTO smkNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","bale' wanan ina na, “Kai! Juan a ipangaran kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ket wanra anamaet nin saray tutawodtaw, “Ambale' ey? Kasa anamaet nin kanayon moyon wanin a ngaran!” ");
INSERT INTO smkNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kanya' nin nisinya-sinyas ran tinepet kona ni Zacarias no ani a rabay nan ipangaran konan anak na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nimustra na ni Zacarias a byan rayan panuratan, ket nisurat na a, “Si ngaran na ket Juan.” Ket sarba ra, naka'ngap. ");
INSERT INTO smkNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tampor nin makapag'irgo yayna si Zacarias ket rinayo nayay Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sarba ran tutawodtaw a nakatanda' sa sain, naka'ngap sara. Naibantog ti nin nangyadi' sa intiron babalin itaw sa tutalugtog nin prubinsyan Judea. ");
INSERT INTO smkNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ket sarba ran nakarnge' konan sitin nangyadi', inisip-isip ra no ani li' kadi' a liwa' na no umalaki yaytin anak. Wanin a iti sa nakem ra bana' ta mapala-palaway anaod a say pakayadi' nan Dios ket iti kona. ");
INSERT INTO smkNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sin sain, si Zacarias nin tatay na ni Juan ket nag'urayan nayan Ispirito nan Dios ket wanti a nibarita' nan minsahin ibat konan Dios: ");
INSERT INTO smkNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Marayo yay Uunuren a Dios tamon puri na ni Israel, ta rinmate' ya ta pigaw nin isalba natamon tutawo na. ");
INSERT INTO smkNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nibaki' naya kontamoy makapangyayadi' nin Mangingisalba a ibat sa puri na ni adi' David a nagsirbi konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Siin anamaet a nipangako' na nin Dios yupa' konran prupita nin naitalaga kona sin nu'nan panaon ta wana a ");
INSERT INTO smkNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","isalba natamo konran kalaban tamo tan konran sarba ran mangura' kontamo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ket ininganga'do nasaran Dios a pupuon tamo ta tukiden nayna a masagradon nipangako' na a ");
INSERT INTO smkNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sinmamba ya kona ni Abraham nin puon tamo. ");
INSERT INTO smkNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Isalba natamo konran kalaban tamo ta pigaw nin makapagsirbi atamo konan Dios nin kasan ikali'mo tamo, ");
INSERT INTO smkNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta maparinggas tan mapapteg atamoyna sa pangingikit na leleg tamon mabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ket si'ka, anak ko, Prupita nan Sangkata'gayan nin Dios a tawag li' komo; ta si'kay mangisadya' konran tutawo sa irarate' nan Catawan. ");
INSERT INTO smkNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ipatandaan mo konra a maisalba sara yupa' sa pammirduna nan kukasalanan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sayti ket magwa' mangibwat sa alakin panginga'do nan Dios kontamo. Say mangyadi' ket bara'mon manginamar yaynay awro ");
INSERT INTO smkNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nin sumira' ya kontamon iti sa kadedleman tan naiketeg nin mati, ta iyakay na kontamoy pakikituno konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ket, si anak a si Juan, inmalaki ya tan nag'in yan manakem. Itaw ya nin niikap nin pinaipurok sa lugar a ambo' nin matawo angga sin awron pinaipadar ya nin nitarana' nayna a nangyakay konran Israelita. ");
INSERT INTO smkNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sin sain a panaon a niyanak ya si Juan, nipataoy na ni Augusto a syay Impirador nan Roma, a sarba ran iti sa sakop na ket matkap nin pairihistro. ");
INSERT INTO smkNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siti a u'nan nangyadi' a pairihistro saray tutawo tan nangyadi' ti sin si Cirenio a gubirnador sa prubinsyan Siria. ");
INSERT INTO smkNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nako anaod pairihistroy sarba sa lugar a ibwatan ran puon ra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kanya' nin mataman nin si Jose, nibwat yadtaw sa syudad nin Nazaret sa prubinsyan Galilea nin nako ya sa babalin Betlehem sa prubinsyan Judea, bana' ta itaw a ibwatan nan puon na a si David a adi' sin nu'nan panaon. ");
INSERT INTO smkNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Si kalamo' na ni Jose nin pairihistro ket si Maria a naitanda' anan pakasal kona, a sin sain ket bulan anan pangangabing na. ");
INSERT INTO smkNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ket, sin itaw sarayna sa Betlehem, narate' anay pangangabing na ni Maria. ");
INSERT INTO smkNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kasaynan lugar radtaw sa balin pamagtuluyan kanya' nin itaw sara sa kami'nan ran uayep, ket niyabing nayadtaw ni Maria a kakan anak na a lalaki ya. Pinunggos nayan abel tan nipaida' naya sa sayay pangnganan ran uayep. ");
INSERT INTO smkNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Itaw sa rikor nan sitaw a lamang nin babali, main nin mammastor nin itaw sa pammasturan ta mambantayan rasaray kukarniro ra no yabi. ");
INSERT INTO smkNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kapingmatan, main anan anghil nan Dios a pina'kit konra, mi'sa bana' sa kata'gayan nan Catawan ket napalawayan sara kanya' nin sabtan li'mo ra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ket wanan anghil konra, “Andi' kamo nin mali'mo ta man'iparate' koyay Mabistan Patanda' nin pangibwatan ran rumiriket nin sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sitin yabi itaw sa Betlehem nin babali na ni Adi' a David, naiyanak yay Mangingisalba moyo a sya a Cristo tan sya a Uunuren. ");
INSERT INTO smkNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Maalilbi' moya ta pinunggos yan nipaida' sa pangnganan ran uayep.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bigra', kalamo' nasaraynan anghil a sabtan ka'bawan nin uanghil a ibat sa langit. Manraywen rayay Dios, wanra, ");
INSERT INTO smkNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Itandudo' yay ngaran nan Dios a itaw sa langit! Iti sa luta' ket kituno yay Dios konran tutawo nin makapaririket kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sin nibwat saraynan sumubli' sa langit a uanghil, wanran mammastor sa saya tan saya, “Mako atamoyna sa Betlehem ta keen tamo nin kikiten a nipatandaan nan Dios kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kanya' nin dinali'-dali' ray nibwat ket nadumog rasara si Jose tan si Maria, tan si abing nin itaw yan nakaida' sa pangnganan ran uayep. ");
INSERT INTO smkNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sin na'kit rayaynay abing, nipara-parate' ra konran tutawodtaw a nibarita' nan sitaw a anghil konra maipa'ka' kona, ");
INSERT INTO smkNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ket sarba ran nakarnge' sa nibari-barita' ran pupastor ket naka'ngap. ");
INSERT INTO smkNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Si Maria anamaet, iti tanan pirmi sa nakem na tan inisip-isip nay sarban saytin nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Saray mammastor anamaet, sinmubli' sara sa mampamasturan ran sirarayo sara konan Dios bana' sa sarban na'kit tan narnge' ran maitukoy sa nipatanda' nan anghil konra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sin waloy awro naynan abing, nipaturi' raya tan pinangaranan rayaynaod nin Jesus sigon sa nibarita' nan anghil kona ni Maria ba'yo ya et nin niinaw. ");
INSERT INTO smkNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sawanin, narate' a panaon a matkap ran gaw'en ni Maria a ritwal sa pakaparinggas mayadi' ya mangabing a sayay babayi. Sigon yayti sa nipatandaan na intaw nin Dios sa Gugan-gan yupa' kona ni Moises. Kanya' nin ni'ras raya anamaet si Jesus sa Timplo sa Jerusalem ta matkap a italaga ya konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Naisurat in sa Libron Gugan-gan, “Si lalaki a kakan anak, matkap a italaga ya konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ket ipaida'ton ra konan padi' a say matkap para sa ritwal sa pakaparinggas. Sayti ket rwa ray kalapati o anak nin palakpak. ");
INSERT INTO smkNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sin sain, sa Jerusalem, main nin tawon say ngaran na ket Simeon a sya matunong ya tan matulok ya konan Dios. Mantaga'nan nay pakatukid nin nipadles a pakaisalba ran puri na ni Israel. Mampag'uray yay Ispirito nan Dios kona ");
INSERT INTO smkNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ket nipatandaan na kona a kai ya nin mati anggan na'kit nayaynay Cristo nin nipangako' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sa nipaninreg nan Ispirito nan Dios, nako ya si Simeon sa sakop nan Timplo. Ket sin ni'ras rayadtaw si Jesus nin mangatua na ta pigaw nin tukiden ray man'ipagwa' nin Gugan-gan nan Dios, ");
INSERT INTO smkNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","na'kit naya ni Simeon ket binibi naya. Ket nikisalamat ya konan Dios nin wana, ");
INSERT INTO smkNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Uunuren, tinukid moy pangako' mo kongkon aripen mo, kanya' nin kuntinto akoyna tan taman nin kalapen nakoyna sawanin ");
INSERT INTO smkNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ta na'kit koyaynay Mangingisalba ");
INSERT INTO smkNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nin nigagara mon nibaki' para sa sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bara'mo yan tyo' nin mamalaway sa kanakman ran ambo' nin Israelita ta pigaw nin matandaan ra no pa'no sara nin maisalba. Sya anamaet a mamin pakairayo konran Israelita a tutawo mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naka'ngap sara si Maria tan Jose sa nibarita' na ni Simeon maipa'ka' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ket binindisyunan nasara ni Simeon, mi'sa wana kona ni Maria a nanay na ni Jesus, “Sitin anak, nitalaga nayan Dios nin mag'in nin pangibwatan nin pisisyay ran Israelita ket abaw saray masida' bana' kona tan main saraynamaet a maisalba bana' kona. Sya a mamin pammatalad konra bale' abaw sara a kumuntra kona ");
INSERT INTO smkNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ket sa wanin, matandaan a iti sa kaararman nin kaisipan ra. Ket si'ka, Maria, say mangyadi' kona, ikabereng mo nin bilang sinurot yay puso' mo nin daga.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sin sain, itaw yan lamang a sayay prupita a say ngaran na ket Ana nin anak naya ni Fanuel a puri na ni Aser. Akulaw yaynan tuloy. Pitoy taon saran nikalamo' nin asawa na ba'yo ya nabalo. ");
INSERT INTO smkNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Walumpulo' tan a'pat a taon nayna tan pirmi yadtaw sa sakop nan Timplo. Awro tan yabi yadtaw nin mampangigalang konan Dios yupa' sa pagkukulasyon tan kadadasal. ");
INSERT INTO smkNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ket sin sain, kinmadani ya anamaet konra ket nikisalamatan nayay Dios nin nangibarita' yan maipa'ka' kona ni Jesus konran sarba ran tawon sitata'gan sa pangingisalba nan Dios konra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sin nayadi' rayna a sarba sigon sa Gugan-gan nan Dios, sinmubli' sarayna sa dirin babali ran Nazaret sa prubinsyan Galilea. ");
INSERT INTO smkNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Si anak inmalaki ya ket mampag'in yan magsen, nag'in yan madunong tuloy; ket mantulungan naya lawas nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinaon a saray mangatua na ni Jesus ket mako sara kipista sa Pistan Nipanglabas sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ket, sin labinrway taon nayna ni Jesus, nayi ya nikipista konra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sin nayadi' anay pista, nibwat saraynan sinmubli' a matua na sa bali ra bale' kai ra tanda' nin nabati' ya sa Jerusalem si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nipa'ka' ran nayi yayna konran raruman kalalamo' ra, kanya' nin nituloy raynay linmalakon nikakaawro mi'sa tiningkap raya konran kukanayon tan katanda' ra. ");
INSERT INTO smkNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ket sin kai raya nadumog, sinubli' rayan tiningkap sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatlon awroyna sin na'kit rayadtaw sa sakop nan Timplo. Nakatekre' yan kalamo' ran mangangakay nin gan-gan, nin mampangrenge' tan mampanepet ya. ");
INSERT INTO smkNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sarba ran mampangrenge' kona ket naka'ngap sa pakataros tan ubat na. ");
INSERT INTO smkNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sin na'kit rayan itaw ket nabigra' saray matua na ket wana ni nanay na, “Anak ko, mayin a ginwa' moyti komi? Aburido kami anan tuloy ni tatay mo nin mampaningkap komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ket wana ni Jesus konra, “Mayin a tikapen rako? Ambale', kai moyo para tanda' a matkap a iti ako sa Bali na ni Ama ko?” ");
INSERT INTO smkNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kai ra bale' natarusan a rabay nan irgwen ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ket nayi yayna konran mangatua nan sinmubli' sa Nazaret. Matulok yan tuloy konra. Si Maria, iti tanan pirmi sa nakem na tan inisip-isip nay sarban mampangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Si Jesus anamaet, tinmuloy yan inmalaki tan nag'in nin madunong tan makapaririket konan Dios tan konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sin ikalabinlimay taon naynan Impirador ni Tiberio sa Roma, si Poncio Pilato a gubirnador sa Judea, si Herodes a mampag'uray sa Galilea, si busat nan si Felipe sa Iturea tan Traconite tan si Lisanias anamaet sa Abilinia. ");
INSERT INTO smkNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Si Anas tan si Caifas a Sangkata'gayan nin Padi'. Sin sain nin panaon nibi na nin Dios a minsahi na konan anak na ni Zacarias a si Juan sin itaw ya sa lugar a ambo' nin matawo. ");
INSERT INTO smkNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kanya' nin kina' na ni Juan a lulugar sa libed nan Ilog Jordan ket pinata-patandaan nasaray tutawo nin pagbabawian raynay duka' a gawa'-gawa' ra tan pabawtismo sara ta pigaw nin mapirduna sara. ");
INSERT INTO smkNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Siin nin man-gaw'en na ni Juan ket syay nikatukid nin si wana sa nisurat na ni Prupita Isaias a: “Main li' nin mampangita'wa-ta'way nin mampangipatanda' itaw sa lugar a ambo' nin matawo a wana, ‘Si'kamon tutawo, sadyaan moyoy irarate' nan Catawan, patu'riren moyoy dalanan na. ");
INSERT INTO smkNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambakan moyoy sarban alog, tubagen moyoy sarban talugtog tan purod, patu'riren moyoy matiko' a dudalan tan patagen moyoy tiba-tibagkol. ");
INSERT INTO smkNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ket ma'kit nin sarban tawo a pangingisalba nan si ibaki' nan Dios.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sin sain, abaw saray tutawon nako pabawtismo kona ni Juan ket wana konra, “Si'kamo a bara'mo nin masirib a ulay! Ani a puon a nako kamodti? Wamoyo angangko a mapal'isan moyoy alakin sager nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","No rabay moyo a maisalba, ipa'kit moyon mampagbabawian moyoynay kukasalanan moyo, ket naipatukdo' sa sain mangwa' kamon manepeg a gugawa'. Andi' moyo nin ilalwan a bana' ta puri nakamo ni Abraham ket, matkap nakamon ipal'is nin Dios sa panunusa na. Ibarita' koyti komoyo, magwa' nan Dios a saytin bubato ket gaw'en na a mag'in nin puri na ni Abraham nin ibi na konray nipangako' na. ");
INSERT INTO smkNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Edet, bilang sa sayay mammukan nin kayo a niinsayo nayayna a payakor na nin pukanen ta puuran nay barang kayon ambo' nin mabistay bunga, si Dios ket nasadya' yaynan dusawen nakamo.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sawanin, tinepet ran saray tutawo kona ni Juan, “Ani edet a gaw'en mi?” ");
INSERT INTO smkNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Wanti e,” ni'bat na. “Si main nin rwa ray aysing, ibi nayay saya konan kasa, tan si main nin kanen, byan nasara anamaet a kasa.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pati maniningir nin buis ket nako nin pabawtismo kona ni Juan. Tinepetan raya anamaet, “Ser, ani a gaw'en mi?” ");
INSERT INTO smkNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wanan ni'bat, “Andi' kamo maningir nin subra.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Saray itaw nin susundalo' tinepetan rayan lamang, “Si'kami pa edet, ani a gaw'en mi?” Wana konra, “Andi' kamo nin manglili'mo o mamarsan bula' nin pangwartawan moyo. Kuntinto kamoyna sa swildo moyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pitta'gan raynan tutawoy irarate' nan si nipangako' nin Cristo, kanya' nin man'ipa'ka' ran si Juan ket syaynayti. ");
INSERT INTO smkNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ket wana ni Juan konra, “Mambawtismwan katamon ranom bale' si sumubray kongko, mas makapangyayadi' ya a kai ako gapo kumana' nin mangwarwar nin kurdon nin sandalyas na. Ket bawtismwan nakamon Ispirito nan Dios tan nin apoy. ");
INSERT INTO smkNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sya li' a manintinsya sa tutawo nin bara'mo yan mangngirik. Ringgasan nayaynan maong a pangirikan ket say irik, ika' na nin iyator sa agamang na, bale' say apa ket ika' na nin puuran itaw sa apoy a kai gapo nin ma'rep.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ket maipa'ka' sa abaw et nin bubagay a pinasadya' nasaray tutawo ni Juan sa pangingipatanda' na nin Mabistan Patanda' konra. ");
INSERT INTO smkNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sinita nayaynamaet si Gubirnador Herodes bana' ta man'i'yan naya si Herodias a asawa nan busat na, tan sa abaw a duka' a ginwa' na ");
INSERT INTO smkNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","kanya' nin nipapriso naya si Juan. Sa wanin, nalamu'nan et a kukasalanan na. ");
INSERT INTO smkNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sin ba'yo ya nin napriso si Juan, binawtismwan nasaray abaw nin tutawo, tan si Jesus anamaet ket binawtismwan naya. Kayadi', sin kapresan nay mandumasal ni Jesus, niburwang a langit ");
INSERT INTO smkNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ket kinmayupa' tan dinumpa' ya konay Ispirito nan Dios a bakas kalapati. Kaaram wanan busis a nangibwat sa langit, “Si'kay anak kon mangkawa-kawa'nanen ko. Napaririketan akon tuloy komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Si Jesus, sin nitarana' nay mangyakay, magtulumpulo' a taon nayna. Ket say tanda' ran tutawo, si ama na ket si Jose. Si Jose ibat ya sa puri na ni Eli. Si Eli ");
INSERT INTO smkNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ibat ya sa puri na ni Matat. Si Matat ibat ya sa puri na ni Levi. Si Levi ibat ya sa puri na ni Melqui. Si Melqui ibat ya sa puri na ni Jana. Si Jana ibat ya sa puri na ni Jose. Si Jose ");
INSERT INTO smkNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ibat ya sa puri na ni Matatias. Si Matatias ibat ya sa puri na ni Amos. Si Amos ibat ya sa puri na ni Nahum. Si Nahum ibat ya sa puri na ni Esli. Si Esli ibat ya sa puri na ni Nage. Si Nage ");
INSERT INTO smkNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ibat ya sa puri na ni Maat. Si Maat ibat ya sa puri na ni Matatias. Si Matatias ibat ya sa puri na Semei. Si Semei ibat ya sa puri na ni Jose. Si Jose ibat ya sa puri na ni Juda. Si Juda ");
INSERT INTO smkNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ibat ya sa puri na ni Joanan. Si Joanan ibat ya sa puri na ni Resa. Si Resa ibat ya sa puri na ni Zorobabel. Si Zorobabel ibat ya sa puri na ni Salatiel. Si Salatiel ibat ya sa puri na ni Neri. Si Neri ");
INSERT INTO smkNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ibat ya sa puri na ni Melqui. Si Melqui ibat ya sa puri na ni Adi. Si Adi ibat ya sa puri na ni Cosam. Si Cosam ibat ya sa puri na ni Elmodam. Si Elmodam ibat ya sa puri na ni Er. Si Er ");
INSERT INTO smkNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ibat ya sa puri na ni Josue. Si Josue ibat ya sa puri na ni Eliezer. Si Eliezer ibat ya sa puri na ni Jorim. Si Jorim ibat ya sa puri na ni Matat. Si Matat ibat ya sa puri na ni Levi. Si Levi ");
INSERT INTO smkNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ibat ya sa puri na ni Simeon. Si Simeon ibat ya sa puri na ni Juda. Si Juda ibat ya sa puri na ni Jose. Si Jose ibat ya sa puri na ni Jonan. Si Jonan ibat ya sa puri na ni Eliaquim. Si Eliaquim ");
INSERT INTO smkNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ibat ya sa puri na ni Melea. Si Melea ibat ya sa puri na ni Mainan. Si Mainan ibat ya sa puri na ni Matata. Si Matata ibat ya sa puri na ni Natan. Si Natan ibat ya sa puri na ni David. Si David ");
INSERT INTO smkNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ibat ya sa puri na ni Jesse. Si Jesse ibat ya sa puri na ni Obed. Si Obed ibat ya sa puri na ni Boaz. Si Boaz ibat ya sa puri na ni Salmon. Si Salmon ibat ya sa puri na ni Naason. Si Naason ");
INSERT INTO smkNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ibat ya sa puri na ni Aminadab. Si Aminadab ibat ya sa puri na ni Admin. Si Admin ibat ya sa puri na ni Arni. Si Arni ibat ya sa puri na ni Esrom. Si Esrom ibat ya sa puri na ni Fares. Si Fares ibat ya sa puri na ni Juda. Si Juda ");
INSERT INTO smkNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ibat ya sa puri na ni Jacob. Si Jacob ibat ya sa puri na ni Isaac. Si Isaac ibat ya sa puri na ni Abraham. Si Abraham ibat ya sa puri na ni Tare. Si Tare ibat ya sa puri na ni Nacor. Si Nacor ");
INSERT INTO smkNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ibat ya sa puri na ni Serug. Si Serug ibat ya sa puri na ni Ragau. Si Ragau ibat ya sa puri na ni Peleg. Si Peleg ibat ya sa puri na ni Heber. Si Heber ibat ya sa puri na ni Sala. Si Sala ");
INSERT INTO smkNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ibat ya sa puri na ni Cainan. Si Cainan ibat ya sa puri na ni Arfaxad. Si Arfaxad ibat ya sa puri na ni Sem. Si Sem ibat ya sa puri na ni Noe. Si Noe ibat ya sa puri na ni Lamec. Si Lamec ");
INSERT INTO smkNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ibat ya sa puri na ni Matusalem. Si Matusalem ibat ya sa puri na ni Enoc. Si Enoc ibat ya sa puri na ni Jared. Si Jared ibat ya sa puri na ni Mahalaleel. Si Mahalaleel ibat ya sa puri na ni Cainan. Si Cainan ");
INSERT INTO smkNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ibat ya sa puri na ni Enos. Si Enos ibat ya sa puri na ni Set. Si Set ibat ya sa puri na ni Adan tan si Adan ibat ya konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sawanin, nibwat yayna sa Ilog Jordan si Jesus nin mampag'urayan nayan Ispirito nan Dios tan nika' naya sa kasan katawu-tawon lugar. ");
INSERT INTO smkNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Itaw, a'pat a pulo' a awro nin sugsugen nayan magkasalanan nin Dimunyo. Leleg nadtaw, kai ya gapo nin nangan kanya' nin sabtan bitil na sin nayadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ket wanan Dimunyo kona, “Bana' ta si'kay peteg a Anak nan Dios ket pagbaliwen man tinapay tin bato.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bale' ni'bat na kona ni Jesus, “Wana sa Masanton Kasuratan, ‘Ambo' a say kanen tamo' a ikabyay nin tawo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sumunor, nika' nayan Dimunyo si Jesus sa sayay ata'gay a lugar. Ket itaw, nipatamuraw na kona sa sayay kidem tamo' nin mata a sarban nunasyon sa intiron mundo ");
INSERT INTO smkNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","tan wana kona ni Jesus, “Ibi ko komoy kayamanan tan pag'uuray sa sain ta sarban sain nibi kongko, ket maibi ko sa si'numan a rabay kon pamyan. ");
INSERT INTO smkNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sawanin, unuren nako, ket maikon mo nga'min.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ket wanan ni'bat ni Jesus, “Wana sa Masanton Kasuratan, ‘Si Uunuren a Dios mo tamo' a unuren tan pagsirbyan mo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sumunor, nika' nayan Dimunyo si Jesus sa Jerusalem ket pina'deng naya sa sangkata'gayan a parti nan Timplo. Mi'sa wana kona, “Bana' ta si'kay peteg a Anak nan Dios, painabo' ka mangibwat iti. ");
INSERT INTO smkNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tutal, wana sa Masanton Kasuratan, ‘Bibilinen nasaran Dios a uanghil na nin prutiktawan raka, ");
INSERT INTO smkNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","tan salanggawen raka ta pigaw nin kai gapo nin masakitan a ayi mo nin say bato.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ket ni'bat na ni Jesus kona, “Wanadtaw lamang, ‘Andi' ka mangwa' nin padalan nin ipanubok mo konan Uunuren a syay Dios mo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sin nagwa' naynan Dimunyo a sarban pannukso na kona ni Jesus, nibwat ya ta mana'gan ya anamanan tyimpo. ");
INSERT INTO smkNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sin sain, sinmubli' ya si Jesus sa prubinsyan Galilea nin iti a pakayadi' nan Ispirito nan Dios kona. Ket naibantog a maipa'ka' kona sa sarban libed nan siin a lugar. ");
INSERT INTO smkNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ket nangyakay ya sa susinaguga nin mampangraywan ra ket rinayo yan sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sawanin, nako ya si Jesus sa Nazaret, si babalin inalakyan na. Bilang sa ugali' nan gaw'en, nako ya sa sinaguga sin Awron Painawa. Ket inumdeng ya ta pigaw nin mamasa yan Sarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nibi ran basawen nay lulon nin nisurat na ni Prupita Isaias. Binuka' naya sa parti nin wanti a nakasurat: ");
INSERT INTO smkNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Si Ispirito nan Dios mampag'uray ya kongko ta tinudo' nakon ipatanda' yay Mabistan Patanda' konran pubri. Nibaki' nakon ibarita' ko konran pa'sar nadakep ran kalaban a mabulusan sara, a paandaen saray bulag, a pag'inawnen saray mangkapaidap ");
INSERT INTO smkNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tan narate' anay tyimpon isalba nasaran Dios a tutawo na.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ket linulon naya ni Jesus a nakaisuratan, mi'sa naya nisubli' konan mampagsirbidtaw. Kayadi' sayti, tinmekre' ya. Ket sarba ran tutawodtaw, nakapastang kona. ");
INSERT INTO smkNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wana konra sin sain, “Natukid sawanin ti leleg nin manreng'en moyon binasa.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sarba ran itaw, rinayo raya tan naka'ngap sara bana' ta say inirgo na ket makapaririket nin reng'en ket wanra, “Kai para a anak naya in ni Jose?” ");
INSERT INTO smkNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ket wana ni Jesus, “Pihon ibarita' moyayti kongkon wanra, ‘Duktor, tambaren moy lalaman mo!’ tan ‘Gaw'en mo anamaet iti sa babali mon diri a narnge' min ginwa-ginwa' modtaw sa Capernaum.’ ");
INSERT INTO smkNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Anaod, kasan prupitan maako' sa lugar nan diri. ");
INSERT INTO smkNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tutuoytin ibarita' ko komoyo: Sin panaon na ni prupita a Elias, grabi a bitil iti sa nasyon tamo sin kai ya rinmapeg nin tuloy taon tan a'nem a bulan. Abaw saray Israelitan bubbayin balo a mangkapaidap, ");
INSERT INTO smkNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","bale' ambo' nin konra naya nibaki' nin Dios si Elias no kai konan sayay babayin balo a taga Sarepta a sakop nin Sidon. ");
INSERT INTO smkNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sin panaon na ni Prupita Eliseo, abaw saray Israelitan main nin liprusi bale' kasa konray pinaanda' na no kai si Naaman a taga Siria.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ket sin narnge' rayti, sarba ran itaw sa sinaguga, pinasyan sager ra kona. ");
INSERT INTO smkNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inumdeng sara mi'sa ginuruy-guroy rayan nirikor sa babali ra tan nika' raya sa ta'gay nin purod a nakaipatukduan nan babali ra, ta inabo' rayadtaw kumon. ");
INSERT INTO smkNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bale' dinmalan ya sa butlay ra si Jesus ket nibwat yayna. ");
INSERT INTO smkNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kaaram, nako ya si Jesus sa Capernaum a sayay syudad sa prubinsyan Galilea ket nangyakay-akay ya konran tutawo no Awron Painawa sa sinaguga. ");
INSERT INTO smkNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naka'ngap sara sa pangangakay na ta say pag'iirgo na ket main nin pakayadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ket sayay Awron Painawa a mampangyakay ya si Jesus sa sinaguga, main itaw nin sayay lalakin nasrepan nin ispiriton duka', ket ginmuryaw ya a wana, ");
INSERT INTO smkNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Si'ka Jesus a taga Nazaret, ani a kabiangan mo komi? Nako kadti para ta sidaen nakami ana? Tanda' ko no si'no ka. Si'kay si Masantos nin nibaki' nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bale' ginan-gan naya ni Jesus a ispiriton duka', wana, “Misasaet ka! Lumakwan ka kona!” Sin sain, nitumba nayan ispiriton duka' a lalaki sa adapan ran tutawo mi'sa linakwanan nayan kai nangno. ");
INSERT INTO smkNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naka'ngap saray sarban itaw tan wanra sa saya tan saya, “Aninaytin sarita' na? Makapangyayadi' nin tuloy! Mandawan nasaray ispiriton duka' ket lumakwan sara.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Anaod, naibantog a maipa'ka' kona ni Jesus sa sarban lugar itaw. ");
INSERT INTO smkNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sawanin si Jesus, nibwat yadtaw sa sinaguga. Nako yadtaw sa bali ra ni Simon. Sin sain, ma'mot yan tuloy a katyangan nan babayi ni Simon, kanya' nin dinawat ran paandaen naya ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inumdeng ya si Jesus tan kinadanyan nayay babayi, mi'sa nigan-gan nan kumpa' a amot na. Ket inmanda' yayna, kanya' nin tampor a nibangon ya tan sinirbyan nasara si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sin patpaapon, nika' rasaran tutawo kona ni Jesus a sarban main animan nin masakit. Ket nipababo na ni Jesus a gamet na sa barang saya konra ket napaanda' sara. ");
INSERT INTO smkNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Anamaet lamang, linmakwan saray ispiriton duka' konran nasrepan ran tawo ket wanran ita'way, “Si'kay peteg a Anak nan Dios.” Bale' inima'no nasara ni Jesus ta tanda' ra a syay Cristo ket kai na nin rabay nin sara a mangibarita' siti. ");
INSERT INTO smkNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sin mangkumalaway ana, nako ya si Jesus sa sayay lugar a matinek. Tiningkap rayan tutawo. Mi'sa sin na'kit raya, pinaed raya ta pigaw nin kai ya et nin mibwat itaw konra ");
INSERT INTO smkNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","bale' wana ni Jesus konra, “Matkap nin ipatanda' koya anamaet sa raruman lulugar a Mabistan Patanda' maipa'ka' sa pag'aadi' nan Dios ta siti a nakaibakian ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ket nibwat yan nituloy na a nangipatanda' sa susinaguga sa Judea. ");
INSERT INTO smkNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sayay awro, itaw ya si Jesus sa rigrig nin baybay nin Genesaret. Ket inaribungbungan rayan tutawo ta pigaw nin rumnge' sara sa minsahi nan Dios a man'ipatanda' na. ");
INSERT INTO smkNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sawanin, main na'kit nan rwa ray baluton nakaduong sa rigrig nin baybay a kasan nakaruran, ta saray main ikon ket inmarawas sara ta man'iwaswas ray eket ra. ");
INSERT INTO smkNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ket rinmuran ya si Jesus konan ikon na ni Simon tan dinawat nan kumadayo' saran buga' sa abay. Tinmekre' yadtaw si Jesus tan nangyakay ya konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sin nayadi' yaynan nangyakay, wana kona ni Simon, “Mako atamo sa mataaw ket ipa'leg moyoy eket moyo ta pigaw nin makakalap.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ket ni'bat na ni Simon, “Maistro, nikakayabi min nipa'leg a eket mi ket kasa anamaet nakalap mi. Bale' ta wamoyo, inabo' mi anaet.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sin nikatkat raynaod a eket ra, gulpi a nakalap ra a rumisang anay eket! ");
INSERT INTO smkNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ket inawesan rasaray kalalamo' ra sa saya et nin baluto a umarak sara ta tulungan rasara. Inmarak saraynaod, ket pinno' ran kuna' a rway baluto a dandani ana nin lumdeg. ");
INSERT INTO smkNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sin na'kit nayti ni Simon Pedro, nanalimukod ya sa adapan na ni Jesus ket wana, “Catawan, kaday'an rako ta saya akon makasalanan!” ");
INSERT INTO smkNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wanti a wana bana' ta pinasyan nipaka'ngap ra sa ka'bawan nin nakalap ran kuna'. ");
INSERT INTO smkNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ket pati sara anamaet a katagem na a si Santiago tan si Juan a a'nak na ni Zebedeo, naka'ngap saran lamang. Bale' wana ni Jesus, “Simon, andi' ka nin masalak! Mangibwat sawanin ket tawoynay pa'sar silayen mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sin naiduong raynay baluto ra, linakwanan ray sarba tan nikikalamo' sarayna kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sayay awro, sin itaw sara si Jesus sa sayay babali, sukat anan main nin nanna' kona nin sayay lalakin liprusyen. Ka'kit na kona ni Jesus, nigna' sa luta' a rupa nan tinmalimukod sa adapan na ta kidawat yan inganga'do, ket wana, “Maistro, no rabay moyo, magwa' moyo nin maako' rako anamanaet nin tutawo a bilang sa gindat.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ket nipababo nayay gamet na konan liprusyen, mi'sa wana, “O', rabay ko. Umanda' kayna!” Ket tampor nakasay liprusi na. ");
INSERT INTO smkNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ket binibilin naya ni Jesus a wana, “Andi' moyti nin ibarita' sa si'numan, ana edet mako ka konan padi' ta ipadar moy nikapaanda' mo. Mi'sa mangipaida'ton ka sigon sa Gugan-gan nin nibi na ni Moises nin mangipa'kit konran tutawo a limpyo kayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wanin man, laloynan naibantog a maipa'ka' kona ni Jesus. Mas inmabaw saray tutawon mako mangrenge' kona tan mapaanda' sa masakit ra. ");
INSERT INTO smkNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bale' ugali' na ni Jesus a mako sa lugar a kasan tawo ta pigaw nin dumasal ya. ");
INSERT INTO smkNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sin sayay awro anaet, mampangyakay ya si Jesus tan iti kona a pakayadi' nan Dios a makapaanda' yan main nin masakit. Itaw sara anamaet nin mantumekre' a umno ran Pariseo tan mangangakay nin Gugan-gan a nangibwat sa abaw nin lulugar sa Galilea tan Judea, pati sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ket rinmate' saray umno ray lulalaki. Awit rayay sayay lupoy nin nakaida' sa idaan na. Naningkap saran padalan ta pigaw nin maisrep raya ket maikadani raya kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sin kai raya nin maisrep bana' ta letletan ran tutawo, niyuli' raya sa bubong tan binutbutan ray atep a tisa' sa temben na ni Jesus, mi'sa niuy'oy raya nin iti sa idaan na a kustu-kusto sa adapan na ni Jesus sa kabutlayan ran abaw nin tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na'kit nay kaalakyan nin pagmamatalek ra ket wana konan lupoy, “Amigo, napirduna anay kukasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Konan siin, wanra sa nakem ran saray Pariseo tan Madudunong sa Gugan-gan ran Judio, “Si'no yayti ket a man'u'na-u'nawan nayay Dios? Anta si Dios tamo' a makapirdunan kukasalanan!” ");
INSERT INTO smkNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bale' tanda' na ni Jesus a iti sa kaisipan ra, ket wana konra, “Mayin nin wanin a kaisipan moyo? ");
INSERT INTO smkNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kumon ket ‘Mas magwa' nin ibarita' a makalalako kayna, dyan si mapirduna anay kukasalanan mo!’ ");
INSERT INTO smkNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ket ta pigaw nin matandaan moyo a si'kon si Pinaitawo ket main nin pakayadi' kon mamirdunan kukasalanan iti sa luta',” wana konan lupoy, “Mibangon ka. Awiten may idaan mo tan sumubli' kayna komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ket tampor, nibangon yan nabantayan nin sarba tan kinalap nayay idaan na tan nugot ya sa bali ran manraywen nayay Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Say sarba ket naka'ngap nin tuloy ket rinayo rayay Dios. Awit a li'mo, wanra, “Talagan makapaka'ngap ti nin nangyadi' a na'kit tamo konan sitin awro.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kayadi', rinmikor ya si Jesus. Ket na'kit nayay maniningir nin buis a mangaran Levi nin nakatekre' sa upisina na. Wana kona, “Mag'in kan tumutumbok ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ket linakwanan nay sarba tan nayi yayna kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nanadya' yan alakin pakan si Levi sa bali na para kona ni Jesus. Ket abaw saray maniningir nin buis tan raruma et nin tawo a kadungo ran nangan. ");
INSERT INTO smkNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Binalaw-balaw rasara nin saray Pariseo tan saray Madudunong sa Gugan-gan nin kalalamo' ra a tumutumbok na ni Jesus. Wanra, “Mayin a kidungo kamo konran maniningir nin buis tan konran raruman makasalanan?” ");
INSERT INTO smkNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bale' si Jesus a inumbat konra nin wana, “Ambo' nin saray marigsa a makatkap nin duktor, no kai edet, saray main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nako akodti sa luta' nin mamagbabawi' konran makasalanan, ambo' nin konra nin kano ket matunong sara!” ");
INSERT INTO smkNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sawanin, main nin saray wanra kona ni Jesus, “Saray tumutumbok na ni Juan a Mammawtismo, wanin sara anamaet a tumutumbok ran Pariseo, pirmi saran magkulasyon tan dumasal, bale' saray tumutumbok mo, mangan tan minom sara tanan pirmi!” ");
INSERT INTO smkNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Inubatan nasara ni Jesus nin sayay alimbawa' a wana, “Bilang wadi', saray kumbidado nin bisita sa sayay bansal, kidungo saran mangan leg'an nan iti et nin nubyo konra. ");
INSERT INTO smkNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bale' rumate' li' a panaon a maikadayo' ya ket no saytaw li', magkulasyon sarayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ket wanan lamang ni Jesus a sayay pangingiyarig, “Kasan mamisang nin ba'yon aysing ta pigaw nin itali'neb ya sa ma'ran. No gaw'en in, si ba'yon aysing masida' ya tan si ba'yo nin itali'neb ket kai ya nin maibagay sa ma'ran. ");
INSERT INTO smkNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wanin lamang, kasan mangikwa nin mampibaliw nin arak sa ma'ran nin katat nin supot a pangangwan ta no gaw'en a wanin, matubrak ya, ket mapirdi a arak tan si katat a pangwan, masida' ya. ");
INSERT INTO smkNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Matkap a say ba'yon arak ket ikwa sa ba'yon pangwan. ");
INSERT INTO smkNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Anamaet, kasan mangrabay sa ba'yon arak no mangnginom saran ma'ran nin arak ta wanra, ‘Mas mataway a ma'ran.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ni'san Awron Painawa, manlumabas sara si Jesus sa gagawa'. Saray tumutumbok na, namursing saran rinakay; rinesres ra, mi'sa ra kinusim. ");
INSERT INTO smkNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ket main nin Pariseo nin itaw a wanra konra, “Mayin nin man-gaw'en moyoy maiyawa' no Awron Painawa?” ");
INSERT INTO smkNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ket wanan ni'bat ni Jesus, “Nalingwanan moyoyna palayi a nabasa moyodtaw sa Masanton Kasuratan maipa'ka' sa ginwa' na ni David nin mismo sin nabitilan yayna tan saray kalalamo' na ta kasaynan abasto ra? ");
INSERT INTO smkNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kai para a sinumrep ya sa Bali nan Dios, tan kinalap nay tinapay a nida'ton? Kinnan raytaw say saray pupadi' tamo' a magwa' nin mangan.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ket wana et konra, “Si'kon si Pinaitawo a makapangyayadi' maipa'ka' sa Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sayay Awron Painawa anaet, nako ya si Jesus sa sinaguga tan nangyakay ya. Main itaw nin lalakin nati yay wanan nin takyay na. ");
INSERT INTO smkNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Saray Pariseo tan Madudunong sa Gugan-gan, man'imatunan raya si Jesus no mamaanda' ya kasi mataman no Awron Painawa ta pigaw nin maparsawan rayan sinmubag. ");
INSERT INTO smkNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mataman nin tanda' na ni Jesus a man'isipen ra, wanan lamang konan lalaki, “Mako kadti sa adapan.” Kanya' nin nako ya tan inumdeng yadtaw sa adapan. ");
INSERT INTO smkNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ket wana ni Jesus konra, “Tepetan katamo: Ani a aburuyan nin Gugan-gan no Awron Painawa, tumulong o mamaidap; mamabyay o mangmati?” ");
INSERT INTO smkNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ket pinastang nasara nga'min, tan wana konan lalaki, “Ipa'nat may takyay mo.” Tinmulok ya sa wana ni Jesus ket linmimpyo yay takyay na. ");
INSERT INTO smkNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Konan siin, sinmager saran maong a itaw, kanya' nin nag'iirgwan ra no ani a gaw'en ra kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sin sain a panaon, nuli' ya si Jesus sa sayay talugtog ket nikakayabi yadtaw nin dinmasal konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sin buklas ana, kinayaban nasaray tumutumbok na ta namili' yan labinrwa sara a tinawag na anamaet nin apostoles: ");
INSERT INTO smkNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","si Simon a pinangaranan nan Pedro, si Andres nin busat na, si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO smkNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago nin anak na ni Alfeo, si Simon nin myimbro nan partidon pulitika nin Zealot, ");
INSERT INTO smkNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas nin anak na ni Santiago tan si Judas Iscariote nin sya li' a magtraidor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kaaram, nanaoy sara si Jesus nin namunta sa sayay lalawak ket itaw sarayna yapo'. Abaw sara a itaw nin tumutumbok na tan tutawon nangibwat sa Judea, pati sa Jerusalem, tan sa babali nin Tiro tan Sidon nin iti sa rigrig nin taaw. ");
INSERT INTO smkNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nako saradtaw nin mangrenge' kona ni Jesus tan ta pigaw nin mapaanda' sara sa masakit ra. Napaanda' pati saray nasrepan nin ispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ket say sarba, nipamuspusan ran makudit raya si Jesus ta main nin kapangyadian nin mangibwat kona nin mamaanda' konran sarba. ");
INSERT INTO smkNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sawanin, inadap nasara ni Jesus a tumutumbok na ket wana, “Makarma' kamon si'kamon mangalilbi' a main nin mampagkurangan moyo ta mag'in nin ikon moyo a say iti sa Pag'adian nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Makarma' kamon si'kamon makaingar sawanin sa pakatkapan moyo konan Dios ta papdaen nakamo li'. Makarma' kamon si'kamon man-gumereng sawanin ta rumiriket kamo li'. ");
INSERT INTO smkNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Makarma' kamo no bana' ta mantumbuken rako nin si Pinaitawo ket gura' rakamon tutawo, ipwira, pagsari-saritaan rakamo tan ibarita' ran duka' kamon tawo! ");
INSERT INTO smkNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","No gaw'en ra in komoyo, rumiriket kamon maong ta pinasyan anda' nin gun-gunan man'isadya' nan Dios komoyodtaw sa langit. Pakatarig'en kamo ta wanin a ginwa' ran pupuon ra konran prupita nan Dios sin nu'na. ");
INSERT INTO smkNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kado' kamo li' nin mumayaman ta nagkunswilo kamoynadti sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kado' kamon mangkapda' ana sawanin ta mabitilan kamo li'. Kado' kamon mariga sawanin ta gumereng tan mangabet-abet kamo li'. ");
INSERT INTO smkNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kado' kamo no raywen rakamon ka'bawan ta wanin a ginwa' ran puon ra konran mibalu'-balo' nin prupita.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wana et ni Jesus, “Bale' wanti et a ibarita' ko komoyon si'kamon mampangrenge': Aduen moyo saray kalaban moyo. Gaw'an moyo saran maabig a mampangura' komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dawaten moyon bindisyunan nasaran Dios a mangisamba komoyo. Idasalan moyo saray mangrumi' komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No main nin manu'pak komoyo, ipatu'pak moyo et a rubari' nin rupa moyo. No main nin mangalap nin para ray'ep moyo, pauryan moyan kalapen naya et a aysing moyo. ");
INSERT INTO smkNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mami kamo konran kidawat; tan no main wadi' nin mangalap nin no ani a main moyo, andi' moyo nin bawien. ");
INSERT INTO smkNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Say rabay moyon gaw'en ra komoyo nin kapada moyon tawo, wanin anamaet a gaw'en moyo konra. ");
INSERT INTO smkNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","No sara tamo' a mampangawa'nan komoyo a kawa'nanen moyo, kai nakamo gun-gunawan nin Dios ta taman nin saray makasalanan ket aduen rasaray mangado' konra. ");
INSERT INTO smkNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No sara tamo' a gumwa' nin maabig komoyoy gaw'an moyon maabig, kai nakamo gun-gunawan nin Dios; wanin a lamang a ugali' ran makasalanan. ");
INSERT INTO smkNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No saray pa'daman moyo tamo' ket saray tanda' moyon makabayad, kai nakamo gun-gunawan nin Dios; ni saray makasalanan ket pa'daman rasaray kapada ran makasalanan no tanda' ran makabayad sara konra. ");
INSERT INTO smkNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ana edet, aduen tan gaw'an moyo saran maabig a kalaban moyo. Mama'dam kamon andi' nin milalo sa bayad. No gaw'en moyo in ket gun-gunawan kamon alaki tan maalilbi' a a'nak nakamon si Sangkata'gayan nin Dios. Anaod, si Dios, maong ya taman konran duka' tan malamang kona. ");
INSERT INTO smkNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Matkap a mapainganga'do kamo kapada nan Ama moyo a mapainganga'do ya.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Andi' kamo nin mangukom tan manintinsya ta pigaw nin kai kamo anamaet nin sintinsyawan tan ukumen. Manispinsa kamo ta pigaw nin dispinsawen kamo anamaet. ");
INSERT INTO smkNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mami kamo ket byan kamo anamaet. Anaod, no pa'no kamon mami sa kapada moyon tawo, wanin kamo anamaet nin tubaleen; malaem, sinedsed tan pinno' anggan milapwas.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ket nibarita' nayayti et e ni Jesus nin pangingiyarig: “Matabin naya kasin bulag a kapada nan bulag? Kai, ta pariho saran maikura'bot. ");
INSERT INTO smkNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Si mampag'adal anamaet ambo' yan mas ata'gay dyan si maistro na, bale' si sayan nakuston maong a nipag'adal na, makakipada ya konan maistro na. ");
INSERT INTO smkNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ambale' a say kasalanan ran kapada mon tawon bara'mon puling tamo' tana a ma'kit mo, bale' kai mo nin mangkaasikaso a bara'mon truson nakasalimbeng ana sa mata mon diri? ");
INSERT INTO smkNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pa'no mon maibarita' kona, ‘Busat, galten tayay puling mo,’ ni kai ma mangkaasikaso nin galten a bara'mon truson nakasalimbeng sa mata mo? Maong ka wadi'! Galten mo yapo' a kadukaan sa kanakman mo ta pigaw nin makapanita kan kapada mon tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wanin ta say mabistan klasin kayo kai nin gumungan duka' a klasi. Say ambo' nin mabistan klasin kayo anamaet, kai nin gumungan mabista. ");
INSERT INTO smkNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anaod, si sayay kayo, maalilbi' ya sa klasin bunga na. Kai makaputin igos sa kayon arumas, o ubas sa kayo nin didiwi. ");
INSERT INTO smkNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kapada sa sain a tawo. Si tawon maabig, maabig a bunga na ta maabig a pinanakem na. Bale' si tawon maraet, maraet anamaet a bunga na ta maraet a pinanakem na. Say iti anaod sa kanakman ket syay lumiwa' sa bebey.” ");
INSERT INTO smkNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ket nitepet na ni Jesus, “Mayin a tawagen moyokon ‘Uunuren’ no kai kamon lamang nin tumulok sa susarita' ko? ");
INSERT INTO smkNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ibarita' ko komoyoy kapada nan sayay kumadani kongko nin rumnge' ya sa susarita' ko tan tumulok ya sa sayti. ");
INSERT INTO smkNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kapada nay sayay nama'deng nin bali a nangali ya anggan narate' nay bato mi'sa itaw na nipatukdo' a pundasyon. Ket sin bigra' nin linmayos nin maksaw a agos, kai ya gapo nin natege' a bali ta magsen a nikapa'deng na. ");
INSERT INTO smkNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sawanin anamaet, si tawon mangrenge' tamo' nin kai nayti tukiden, kapada nayay sayay tawon nama'deng nin bali nin kai kinwan nin pundasyon. Ket sin linmayos nin maksaw a agos, tampor nin nayba' ya, kanya' nin nasida' yan liso.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sin nayadi' nayna nibarita' in ni Jesus konran tutawo, sinmubli' ya sa Capernaum. ");
INSERT INTO smkNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Itaw yay sayay kapitan ran sundalo' nan Roma a main nin aripen nan kawa'nan nan tuloy, bale' mampagmasakit yan dandani nin mati. ");
INSERT INTO smkNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sin narnge' nan sitin kapitan a itaw ya si Jesus, namaki' yan pupangulo ran Judio nin manawat kona nin keen naya paandaen a aripen na. ");
INSERT INTO smkNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kina' rayaynaod si Jesus tan nikidawat saran inganga'do kona nin paandaen nayay aripen nan kapitan a wanra, “Manepeg a tulungan yaytin kapitan ");
INSERT INTO smkNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ta kawa'nan natamon Judio tan namapa'deng ya et nin sinaguga tamo.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ket nayi ya si Jesus konra. Sin adani sarayna sa bali nan kapitan, nangibaki' ya a kapitan nin umno ray amigo nan ibarita' rayti kona ni Jesus, “Ser, andi' kayna nin paabara' nin mako et sa bali mi ta kai ako kumana' a sumrep ka sa bali mi. ");
INSERT INTO smkNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kanya' anamaet nin kai ako nin nag'atribidon nako komo. Sadag anan ibarita' mo, ‘O', limpyo yayna.’ ket lumimpyo yaynay kawa'nan kon alila' ko. ");
INSERT INTO smkNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","O', maibarita' in ta mantumulok akon lamang konan si nangikwa kongkodti, tan main nin susundalo' a iti sa pakauray ko. No ibarita' ko konan sayay sundalo' ko, ‘Mako kadtaw e,’ ket mako yaynaod; ket konan saya anamaet ibarita' ko, ‘Mako kadti,’ ket umarak ya kongko. Wanin anamaet a lamang konan aripen ko. No wangko kona, ‘Gaw'en mayti,’ gaw'en ta gaw'en naya anaod.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Naka'ngap yan tuloy kona si Jesus sin narnge' nayti. Ket inmadap ya konran ka'bawan a mantumumbok kona tan wana, “Ibarita' koyti komoyo, kasa et gapon narnge' kon main nin wantin pagmamatalek mataman kontamon Israelita!” ");
INSERT INTO smkNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ket sin nakarate' saraynadtaw sa bali a nibaki', narat'anan rayan limpyo anay aripen. ");
INSERT INTO smkNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ambo' nin na'teng, nako ya si Jesus sa babali nin Nain. Nayi saray tumutumbok na tan abaw nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sin adani sarayna sa serpan sa babali, naka'kit saran mako manabon. Si nati, lalaki ya nin kapagkapag a anak nan sayay babayin balo. Pinasyan ka'bawan ran tutawon ibat sa babali a kipanabon. ");
INSERT INTO smkNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sin na'kit naya ni Jesus tin babayi, kina'dwan naya ket wana kona, “Andi' ka nin umakis.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mi'sa, kinmadani ya si Jesus sa kami'nan nan nati tan gina'getan nayay mampangawitan ra kona. Ket, tinumgen saray mampamalatay. Sawanin, wana konan nati, “Arikong, ibarita' koyti komo, mibangon ka!” ");
INSERT INTO smkNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nibangon yaynaod a nati tan nag'irgo ya. Mi'sa, wana ni Jesus konan ina na, “Syayna e a anak mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sarba ran itaw, linmi'mo saran tuloy ket rinayo rayay Dios nin wanra, “Ay! Rinmate' ya kontamoy sayay makapangyayadi' a prupita nan Dios! Iti ya ta pigaw nin tulungan natamon tutawo nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ket sitin ginwa' na ni Jesus, naibantog ya sa intiron Judea tan sa kalibed-libed nin bubabali. ");
INSERT INTO smkNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ket saray tumutumbok na ni Juan, nibarita' ra konadtaw sa priswan a man-gaw'en na ni Jesus. Ket kinayaban nasaray rwa ra konra ");
INSERT INTO smkNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","tan nibaki' nasaran keen ra tepeten kona ni Jesus a wanti, “Si'kayna paraytaw si nipangako' nan Dios a rumate' iti nin mag'adi', o main et nin sakalakon taga'nan mi?” ");
INSERT INTO smkNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ket sin itaw sarayna kona ni Jesus, wanra kona, “Nibaki' nakami ni Juan nin itepet ti komo, ‘Si'kayna paraytaw si nipangako' nan Dios a rumate' iti nin mag'adi', o main et nin sakalakon taga'nan mi?’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sin sain, kapresan na ni Jesus a mampamaanda' nin abaw a main nin masakit, mampamalakwan nin ispiriton duka', tan mampanambar nin abaw a bulag ta pigaw nin maka'kit sara. ");
INSERT INTO smkNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kanya' nin wanti a ni'bat na konra, “Sumubli' kamo kona ni Juan ket ibarita' moyo kona a sarban na'kit tan narnge' moyo. Maka'kit saray bulag; makalalako saray lupoy; napaanda' saray liprusyen; makarnge' saray telek; napasubli' saran mabyay a nati; tan man'ipatanda' yay Mabistan Patanda' konran pubri. ");
INSERT INTO smkNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ket, makarma' yay tawon kai gapo nin maglat a pangungunor na kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sin nibwat saraynay nibaki' na ni Juan, inmadap ya si Jesus konran abaw a tutawo ta ibarita' na konray maipa'ka' kona ni Juan a wana, “Sin nako kamodtaw sa lugar a ambo' nin matawo, ani a inilalwan moyon ma'kit itaw? Sayay tawo para a say pinanakem na ket kapada nin talaib a man'irpa-irpay nan siri? ");
INSERT INTO smkNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","No kai, ani edet a rabay moyon ma'kit? Sayay tawon nisket nin mabli tan mapustura? Kai, ta saray misket nin mamabli, tan mampipapda' sa byay, sa palasyo sara nin ma'kit. ");
INSERT INTO smkNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ani edet a rabay moyon ma'kit? Kai para a si sayay prupita nan Dios? O', bale' ibarita' ko komoyo a ambo' yan basta nin prupita. ");
INSERT INTO smkNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wanan Dios sa Masanton Kasuratan maipa'ka' kona, ‘Si'ko, ibaki' koyan mu'nayna komo a tawo kon mangipatanda' nin maipa'ka' komo ta pigaw nin isadya' nay dalanan mo.’ ");
INSERT INTO smkNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ibarita' koyti komoyo: Anaod, kasa et gapon niyanak nin makakipada kona ni Juan. Mataman bale' nin wanin, si sangkaayupaan nin tawo nin makakibiang sa pag'aadi' nan Dios, mas ata'gay ya et dyan si Juan. ");
INSERT INTO smkNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Anaod, abaw sara a inalilbi' ran say man'ipagwa' nan Dios konra ket kusto, pati saray maniningir nin buis, sin nipabawtismo sara kona ni Juan ta nangrenge' sara kona. ");
INSERT INTO smkNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bale' saray Pariseo tan uabugado sa Gugan-gan, kai ra nin inako' a gagara nan Dios sin andi' saran pabawtismo.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ket wana et ni Jesus, “Adti kosara nin ipada a tutawo sawanin? Ani anaod a kapada ra? ");
INSERT INTO smkNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kapada ray ua'nak itaw sa plasa nin mii'ritan sara: ‘Ay! Mampanugtog kami bale' kai kamo nin magbayli; anta mangkibereng kami komoyo ket kai kamo anamaet nin mangabet-abet.’ ");
INSERT INTO smkNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","O' ta, si Juan, nagkula-kulasyon ya tan kai ya nin ninum-ninom nin arak, ket wamoyo, ‘Nasrepan ya nin ispiriton duka' ket mangkaluang ya!’ ");
INSERT INTO smkNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sin rinmate' akon si Pinaitawo nin mampangan tan mampinom ako, ket wamoyo, ‘U! Masiba' tan mainom yan arak! Amigo rayan maniningir nin buis tan saray kai nin mantumumbok sa Gugan-gan nan Dios.’ ");
INSERT INTO smkNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Taman nin wanin bale', ma'kit tamo nin kusto a kadunungan nan Dios no kikiten tamo a gawa'-gawa' ran saray mantumulok kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ni'sa, sinagyat nayan sayay Pariseo si Jesus nin mangapon itaw konra a say ngaran na Simon. Kanya' nin nako ya ket nikidungo ya konra. ");
INSERT INTO smkNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Itaw nin babali, main nin sayay babayin uupaan. Sin natandaan nan itaw yan mampangan si Jesus konra ni Simon, nako yan main nin awit nan mablin banglon si nangwan ket gawa' ya sa baton mantawagen nin alabastro. ");
INSERT INTO smkNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Inmakis ya sa dani nin ayi na ni Jesus anggan naturuan nan lwa' na. Ket pinunasan nan sabot na mi'sa na nin inarkan tan inaprusan nin banglo. ");
INSERT INTO smkNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sin na'kit naytin Pariseo nin nanagyat kona ni Jesus, wana sa nakem na, “No siti ket peteg yan prupita, tanda' na kumon a siti si babayin mampangiyapros nin banglo kona ket saya yan makasalanan.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ket si Jesus nag'irgo ya a wana, “Simon, main pan ibarita' ko komo.” Wanan ni'bat ni Simon, “O' sigi, Maistro.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wanti a wana ni Jesus, “Main nin rwa ray tawon main nin utang. Say alagan utang nan saya ket limanyasot nin swildon sayay awron pagtatrabaho tan si saya anamaet ket limampulo'. ");
INSERT INTO smkNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sin kai sara nin makabayad, ininganga'do nasaran nibarita' nan namautang a kai rayayna matkap nin bayadan.” Sinmunor, tinepetan naya si Simon, “Sawanin, si'no konran rwa a mas a pangangado' kona?” ");
INSERT INTO smkNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Sa angan-angan ko,” wanan ni'bat ni Simon, “sitaw si mas abaw a utang.” “Kustoy ubat mo,” wana ni Jesus kona. ");
INSERT INTO smkNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sin sain, inmadap ya si Jesus konan babayi, mi'sa wana kona ni Simon, “Isipen mo a maipa'ka' konan sitin babayi. Si'ka, sinagyat nakon makodti sa bali moyo bale' kai nako gapo nin binyan nin ranom nin ipanguyas ayi ko. Sya bale', inuyasan nan lwa' na tan pinunasan na et nin sabot na. ");
INSERT INTO smkNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kai nako nin inarkan nin pangrispito mo kongko bale' sya, kai ya gapo nin sinmawa' nin mangarek nin ayi ko nangibwat sin linmuob akodti. ");
INSERT INTO smkNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni kai ma nin nipaaprusan mataman nin ladak a ulo ko bale' sya, banglo et a niyapros na sa ayi ko. ");
INSERT INTO smkNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Edet, ibarita' ko komo, napirduna ana a abaw nin kasalanan na kanya' nin alaki a ado' nan nipa'kit na. Bale' anamaet, si napirduna sa daite', daite' anamaet a pangangado' nin ipa'kit na.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ket wana ni Jesus konan babayi, “Napirduna anay kukasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ket saray kalalamo' nan mampangan, wanra sa nakem ra, “Ani yaytin tawo a say kasalanan ket kano wadi' mapirduna na?” ");
INSERT INTO smkNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sin sain, wana anaet ni Jesus konan babayi, “Bana' sa pagmamatalek mo nalibri kayna sa pakadusa, mako kaynan sititinek a kanakman.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ambo' nin na'teng mayadi' ti, nako ya si Jesus sa bubabali tan bubaryo nin nipatanda' nayay Mabistan Patanda' maipa'ka' sa pag'aadi' nan Dios. Nayi saray labinrwan apostoles ");
INSERT INTO smkNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tan umno ray bubbayin pinalimpyo na. Sarayti sara: si Maria nin mantawagen nin Magdalena a linwaan nin pito ray duka' a uispirito, ");
INSERT INTO smkNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana nin asawa na ni Cusa nin ata'gay a butang nin tawo na ni Herodes Antipas, si Susana tan saray raruma et nin mampamin say pakatkapan ra ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ni'sa, gulpi saray tawon umarak kona ni Jesus a nangibwat sa bubabali. Sin nadinep sarayna, wana a sayay pangingiyarig, ");
INSERT INTO smkNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Main nin magtatalon a nako nanabwag nin bini'. Ket sin man'isabwag nay bini', main nin naika' sa dadalanan ket nada'da-da'daan ran tutawo tan kinnan ra nin manuk-manok. ");
INSERT INTO smkNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Main anamaet nin naika' sa babato, ket sin tinmubo', nalanes ta makrang a luta'. ");
INSERT INTO smkNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Main et nin naika' sa mantubuan nin dikot nin madiwi. Linmambot nin kinmubpal a dikot a madiwi ket nadaeg a tinmubo' nin bini'. ");
INSERT INTO smkNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ket main anamaet nin naika' sa madaem a luta', ket tinmubo' tan ginmunga nin yinasot a barang sayay puon.” Sin nayadi' na nibarita' ti ni Jesus wana et nin maksaw, “Si'kamon manrumnge', adalen moyoyti nin maong.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ket tinepetan raya si Jesus nin tumutumbok na no ani a pipa'kaan nan si pangingiyarig. ");
INSERT INTO smkNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wana, “Si'kamo, man'aburuyan nakamo nin Dios nin matandaan moyoy maipa'ka' sa pag'aadi' na a kai et nin nipatarusan nangibwat sin nu'na. Bale' konran raruma, pangingiyarig tamo' a naibi ta pigaw nin ‘mangka'kit ra man ket kai ran lamang nin ma'kit; mangkarnge' ra man ket kai ra nin mataros.’ ");
INSERT INTO smkNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sawanin, wanti a katarusan nan pangingiyarig: Say bini' ket say Sarita' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Say dalan nin naikaan ket saray mampangrenge'. Ket si Dimunyo, ipalingwanan na konray marnge' ra, bana' ta kai na nin rabay a mamper sara konan Dios tan maisalba sara! ");
INSERT INTO smkNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Say luta' a babato, sara a nakarnge' nin maririket ran timper a Sarita' nan Dios, bale' nadali' tamo' ta kai nin nakayamot konra. Ket sin main nin pakatukswan, ginurutan rayna. ");
INSERT INTO smkNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Say luta' nin mantubuan nin dikot a madiwi, sara a mampangrenge' nin Sarita' nan Dios, bale' nadaeg a pamper ra nin pakaaburido, nin pipayaman, tan pipariga sa byay iti. Kanya' nin say bunga sa byay ra, pulos nin apa. ");
INSERT INTO smkNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ket say madaem a luta' ket saray mampangrenge' a nangako' sa Sarita' nan Dios nin main nin maong tan matu'rir a pinanakem. Inmanos saran namper ket mabistay bunga sa byay ra.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kasa anaod nin manulsol nin tyo' mi'sa naya nin sakban o ikwa sa sirong nin katri, no kai, ikwa naya sa pangngitukduan ta pigaw nin saray sumrep sa bali ket mapalawayan sara. ");
INSERT INTO smkNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anaod, say sarban naiyadi sawanin ket matandaan li'. O' a, say sikrito sawanin ket matandaan li' ket maipadar anaod. ");
INSERT INTO smkNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kanya' nin asikaswen moyoy pangrerenge' moyon sayti bana' ta si tawon man'ipamuspusan nan matarusan a narnge' na, say pakataros na ket malamu'nan; bale' si tawon kai na rabay nin tarusan, mataman nin say sa angan-angan na ket tanda' na, mag'in nin kasa.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sawanin, kina' raya ni inay na tan saray bubsat na si Jesus bale' kai raya nin makadanyan bana' sa ka'bawan ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kanya' nin main nin nangibarita' kona ni Jesus a wana, “Itaw sara kano sa rikor si inay mo tan saray bubsat mo ta kairgwen raka.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bale' wana ni Jesus, “Saray rumnge' tan tumulok sa man'ibarita' nan Dios, ikwinta kosaran ina tan bubsat ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sayay awro, rinmuran ya sa baluto si Jesus nin kalamo' nasaray tumutumbok na. Wana konra, “Sumaki atamon makodtaw sa rubari'.” Ket sinmaki sarayna. ");
INSERT INTO smkNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Leleg ran manrumipay, nakaka'lek ya si Jesus. Kapingmatan, narat'anan saran tribunada sa taaw; ket mangkapno' yaynan ranom a baluto ra, kanya' nin iti sarayna sa piligro. ");
INSERT INTO smkNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanya' nin kina' raya pinukaw si Jesus nin saray tumutumbok na, a wanran niburyaw, “Maistro, Maistro, manlumdeg atamoyna!” Ket nimata ya, mi'sa ginan-gan nan tumgen a tribunada tan alalakin daluyon; ket tinumgen yay bagyo tan tinminek ana. ");
INSERT INTO smkNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sin sain, wana ni Jesus konra, “Mayin a kasa nin pagmamatalek moyo kongko?” Ket nabagya' tan naka'ngap sara, ket wanra sa saya tan saya “Ani yaytin tawo ta igan-gan na pati bagyo tan daluyon ket tumulok kona?” ");
INSERT INTO smkNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tinmuloy saran sinmaki si Jesus anggan sa lugar ran Geraseno a katben nan Galilea. ");
INSERT INTO smkNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ket kaarawas ra, sinna' naya si Jesus nin sayay tawon taga sa babali a nasrepan ya nin uispiriton duka'. Lus'ok yaynayti nin na'teng tan kai yayna nin mampugot sa bali ra no kai itaw yaynan mampagpirmi sa pannabunan. ");
INSERT INTO smkNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Anaod, pirmi nayan serpan nin si ispiriton duka', kanya' nin baruren ran kadina a gamet na tan ayi na. Bale' mabulsot na et ket papalaywen nayan ispirito nin mako sa lugar a kasan tawo. Bale' sin na'kit nayaynaod si Jesus, tinma'way ya mi'sa ya nin nanalimukod sa adapan na ket wana nin maksaw, “Jesus, Anak nan Sangkata'gayan nin Dios, ani ket a kabiangan mo kongko? Panginga'do mo ta andi' nako nin padya'dyaen.” Wanin a wana bana' ta ginan-gan nayayna ni Jesus nin lumakwan konan lalaki a ispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ket tinmepet ya si Jesus kona a wana, “Ani a ngaran mo?” Ket ni'bat nan ispiriton duka' a sinumrep konan lalaki, “Rinibu-ribo.” Wanin a ni'bat na bana' ta abaw sara anaod a ispiriton duka' a nakasrep konan lalaki. ");
INSERT INTO smkNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sawanin, nipainganga'do ran andi' nasara nin gan-ganen nin makodtaw sa priswan nin ubot a pakadusawan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sin sain, main saray abaw nin baboy nin mampangan sa rigrig nin talugtog itaw. Ket nipainganga'do ran uispiriton duka' kona ni Jesus a aburuyan nasara tanan sumrep konran baboy; ket wana mako sarayna edet. ");
INSERT INTO smkNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ket linmiwa' sara konan lalaki tan nako sara sinumrep konran baboy. Nangimros saray baboy nin nako sa kikiras ket nirebreb sara nga'min nin nanabo' sa baybay. ");
INSERT INTO smkNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sin na'kit ran mampangalila' konran baboy a nangyadi', nalayo saran nika' ra nibari-barita' a nangyadi' sa bubabali tan sa bubaryo. ");
INSERT INTO smkNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ket nagsipako saray tutawo nin kumikit sa nangyadi'. Sin nakarate' saradtaw konra ni Jesus na'kit rayan limpyo anay lalaki nin ibwatan nin uispiriton duka', nin nakatekre' ya sa adapan na ni Jesus. Nakaseket yayna tan limpyoynay kaisipan na ket linmi'mo sara sa nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Anaod, saray mismon naka'kit, inistu-isturya ra konran rinmate' no pa'no ya nin napaanda' a si nasrepan nin uispiriton duka'. ");
INSERT INTO smkNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sawanin, saray sarba ran tagadtaw sa libed nan babali ran Geraseno, bana' sa li'mo ra ket dinawat ra kona ni Jesus a mibwat yaynadtaw. Kanya' nin rinmuran sara si Jesus sa baluto ta pigaw nin sumubli' sarayna sa lugar a mampagpirmiwan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ba'yo saradtaw nin nibwat, si lalakin ibwatan ran uispiriton duka' ket dinawat na a kikalamo' kona bale' kai naya nin inaburuyan ni Jesus a wana kona, ");
INSERT INTO smkNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mako kaynadtaw komoyo ket ibarita' moy sarban ginwa' nan Dios komo.” Ket nibwat yaynay lalaki, nin nibari-barita' na sa intiron babali a makapaka'ngap nin ginwa' na ni Jesus kona. ");
INSERT INTO smkNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ket nakasubli' sarayna si Jesus sa lugar a mampagpirmiwan ra, ket maririket saray tutawo ta mantaga'nan rayayna. ");
INSERT INTO smkNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sin sain, main nin rinmate' nin sayay pangulo sa sinaguga a say ngaran na Jairo. Nanalimukod ya sa adapan na ni Jesus ta nikidawat yan inganga'do a mayi ya kona sa bali na, ");
INSERT INTO smkNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bana' ta si kapagkapag a anak nan babayi a magtaon nin labinrwa ket mangkamati ya. Nayi ya si Jesus kona ket sin adap raynadtaw, nileletletan saray tutawon inmaribungbong kona. ");
INSERT INTO smkNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sin sain, itaw ya anamaet a sayay babayin labinrway taon anan marges a karirigla na, bale' kasan si'numan a makapamaanda' kona. ");
INSERT INTO smkNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sawanin, kinmadani yan nako sa gurot na ni Jesus ket kinudit nayay saroy nan aysing na. Ket bigra' anan tinumgen a kadadaya' na. ");
INSERT INTO smkNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tinepet na ni Jesus, “Si'noy nangudit kongko?” Ket sin kasa gapo nin inumbat nin nangako', wana ni Pedro, “Maistro, mayin nin wanin a tepet mo ket ma'kit mo anamaet nin nileletletan saray tutawon man'umaribungbong komo?” ");
INSERT INTO smkNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bale' wana ni Jesus, “Main anaod nin nangudit kongko ta naingar kon main nin kapangyadian nin linmiwa' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sin nadlaw nan babayi nin tanda' na ni Jesus a ginwa' na, mangingintar yan kinmadani kona. Mi'sa ya nin nanalimukod sa adapan na tan nag'irgo nin mangkarnge' ran tutawon mampangimaton itaw no mayin nin gina'getan nay seket na ni Jesus. Nibarita' na et a sin ginwa' naytaw ket tampor nin inmanda' ya sa masakit na. ");
INSERT INTO smkNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kanya' nin wana ni Jesus kona, “Arikong, bana' sa pagmamatalek mo inmanda' kayna, ket mako kayna nin matinek a kaisipan.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sin kapresan nay mampag'irgo et ni Jesus, rinmate' yay sayan ibat sa bali na ni Jairo tan wana kona ni Jairo, “Andi' mayna nin mulistyawen et a Maistro ta nati yaynan lamang a anak moyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bale' sin narnge' nayti ni Jesus, wanti a ni'bat na, “Andi' ka nin mapaga; basta magmatalek ka ta mabyay ya anamaet a anak mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sin nakarate' sara sa bali na ni Jairo, kasan raruman niyayi nan linmuob no kai sara tamo' si Pedro, si Juan, si Santiago tan saray mangatua nan anak. ");
INSERT INTO smkNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sawanin, sarba ran tutawon narat'anan na ni Jesus itaw ket man'akisan tan man'abet-abetan raya ket wana konra, “Kustoyna in! Andi' kamoyna nin umakis ta kai ya anamaet nin nati; mampa'lek ya tamo'.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ket kinaka'lisan raya si Jesus nin panuya'-tuya' kona ta tanda' ran nati yaynay anak. ");
INSERT INTO smkNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ket gina'getan nay gamet na tan wana nin maksaw, “Anak ko, mibangon ka.” ");
INSERT INTO smkNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ket bigra', si anak sinmubli' a inanawa na tan nibangon yaynan tampor. Sin sain, nibibilin na a pakanen raya. ");
INSERT INTO smkNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naka'ngap saray mangatua na; ket binibilin nasara ni Jesus nin andi' ra nin ibari-barita' ti nin nangyadi' sa mataman nin si'no. ");
INSERT INTO smkNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sayay awro, dininep nasara ni Jesus a Labinrwa ta pigaw nin byan nasaran pakayadi' nin mamalakwan nin ispiriton duka' tan mamaanda' nin main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mi'sa nasara nibaki' nin ika' ra ipatanda' a maipa'ka' sa pag'aadi' nan Dios tan mamaanda' nin main masakit. ");
INSERT INTO smkNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Binibilin nasara yapo' nin wana, “Sa pako moyo sa lulugar matkap nin kasan awit moyo nin baston, o bag, o kanen, o kwarta, o pisilyan nin aysing. ");
INSERT INTO smkNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sa bali nin mamagtuloy komoyo, magmantini kamodtaw anggan mibwat kamodtaw nin lugar. ");
INSERT INTO smkNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ket no kasan mamagtuloy komoyo, mibwat kamo konan siin nin lugar. Sa pibwat moyo, pagpagen moyoy ta'pok sa ayi moyo nin mangipataros a saray tutawo ket madusa sara li'.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ket, nibwat saraynay apostoles nin nako sara sa bubaryo nin nipata-patanda' rayay Mabistan Patanda' tan namaa-paanda' saran main nin masakit sa adtiman a kina' ra. ");
INSERT INTO smkNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sin sain, natandaan na ni Herodes Antipas a sarban mampangyadi'. Nagulo a kaisipan na ta main sara a namarita' a si Juan ket pinasubli' ya nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wanran raruma ket pinaipa'kit ya si Elias a sayay prupita nan Dios sin saytaw, tan wanra anamaet nin raruma ket saya ya si Jesus konran prupita nan Dios sin nu'nan panaon a sinmubli' nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bale' wana ni Herodes, “Nipaputol koyaynay ulo na ni Juan a Mammawtismo. Si'no ya in si man-gumwa' nin saytin abaw a bubagay a mangkarnge' ko!” Kanya' nin mapilit yan ma'kit naya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sinmubli' saraynay apostoles, ket nibarita' ra kona ni Jesus a sarban nagwa' ra. Sin sain, sinagyat nasaray apostoles na nin mayi kona sa babalin Betsaida nin sara-sara tamo'. ");
INSERT INTO smkNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sin natandaan ran saray abaw nin tutawo a nibwat sara si Jesus, tinmumbok sara. Inako' nasara ni Jesus nin masibulot a nakem na tan niyakay na konray maipa'ka' sa pag'aadi' nan Dios. Pinaanda' nasara anamaet a main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sin manyumabi ana, kinmadani saray Labinrwa kona tan wanra, “Maistro, sapa no ibaki' mosaray tutawo nin mako sa kalibed-libed nin bubaryo tan babali ta pigaw nin mangkit saran pagtuluyan tan kanen ra bana' ta iti atamo sa lugar a kasa gapo nin bali.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bale' wana ni Jesus konra, “Si'kamoynay mamin ma'kan ra.” Ket wanran inumbat, “Lima ray tinapay tan rwa ray kuna' tamo' bale' a main kontamo. Pwira no mako kami nin manaliw nin ma'kan para konran sarba nin saraytin tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wanin a wanra ta saray lulalaki tana ket main nin limanribo sara. Sin sain, wana ni Jesus nin inumbat, “Patekreen moyo saran nagrupu-grupo nin sililimampulo' a barang saya.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ket wanin anaod a ginwa' ra, a pinatekre' rasara nin nga'min. ");
INSERT INTO smkNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sinmunor, inagwang na ni Jesus a liman tinapay tan saray rwan kuna' mi'sa ya tinmangar sa langit tan nikisalamat ya konan Dios. Ba'yo tinau-tao nayti tan nibi na konran tumutumbok na nin itayak ra konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sarba ra ket nakapangan tan nabsoy sara. Ket say nadinep ra nin natra', labinrway balyag. ");
INSERT INTO smkNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sayay awro, bukud-bukod nan mandumasal ni Jesus. Iti sara sa dani na a tumutumbok na. Kayadi', tinepetan nasara, “Ani a ibari-barita' ran tutawo maipa'ka' kongko? Si'no ako kano a wanra?” ");
INSERT INTO smkNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ket ni'bat ra, “Si'ka kano si Juan a Mammawtismo, bale' main anamaet nin namarita' a si'ka si Elias. Saray raruma et wanra a saya ka kano konran saray prupita nan Dios sin nu'nan panaon a sinmubli' nin mabyay.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ket wana et konra, “Ket si'kamo anamaet, si'no ako sa wamoyo?” Ni'bat na ni Pedro a wana, “Si'kay Cristo a nipangako' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ket binibilin nasaran maong ni Jesus a andi' ra gapo nin ibarita' sa si'numan no si'no ya ");
INSERT INTO smkNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ta wana konra, “Si'kon si Pinaitawo ket matkap nin mangirangep ako nin abaw nin pammadya'dya'. O' ta ipulisay rako nin saray Mangatuntawo tamo, saray Pupangulon Pupadi', tan saray Madudunong sa Gugan-gan ket patyen ako li'. Bale' sa ikatlon awro ket pasublien nako li' nin mabyay nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sawanin, wana ni Jesus konran sarba, “Si sayay marabay nin mag'in nin tumutumbok ko, matkap a galten nayna sa kaisipan na a karabayan nan bukod. O' a, matkap nayan balatayen a kudos na nin ipulisay nay lalaman nan diri nin inawru-awro ket tumbuken nako. ");
INSERT INTO smkNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wanin ta si si'numan a say byay nadti tana a mampagawan na, mati ya li' et a lamang, bale' si tawo nin gurutan nay byay nadti bana' sa pammabli na kongko, mabyay ya nin iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ani wadi' a magun-guna nan sayay tawo no maikon nay intiron kayamanan sa babon luta', bale' si byay na a nibayad na sa sain? Kasa gapo! ");
INSERT INTO smkNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si si'numan nin mangiding'ey a tumutumbok koya nin si'kon si Pinaitawo tan sa akay ko, iding'ey koya li' anamaet no sumubli' akoyna sa kata'gayan ko a syay kata'gayan nan Ama ko tan saray uanghil nin naitalaga kona. ");
INSERT INTO smkNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ket tandaan moyoyti: Main komoyodti sawanin a sibibyay et li' no si Dios ket ipa'kit nayna a pag'aadi' na.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sawanin, napalabas a nanglinggo kayadi' na nin nibarita' taw ni Jesus, nitagad nasara si Pedro, si Juan tan si Santiago nin mako dumasal itaw sa sayay talugtog. ");
INSERT INTO smkNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sin kapresan na a mandumasal ni Jesus, nanguman a bakas nin rupa na, tan say seket na ket nag'in nin makapulag sa puti'. ");
INSERT INTO smkNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kapingmatan, main anan rwa ray tawon kapada na kaslag ni Jesus nin mangkiirgo kona; sara si Moises tan si Elias. Mampag'irgwan ra a maipa'ka' sa patiti na nin syay plano nan Dios a matkap nin tukiden nadtaw sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sin sain, sabtan anda' nin elek ra ni Pedro. Ket, sin nakaaram sara, na'kit ray salag na ni Jesus tan saray rway lulalaki a kalamo' nan naka'deng. ");
INSERT INTO smkNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sin manlakwanan rayayna si Jesus nin saraytin rway lulalaki, basta ya tana nin nag'irgo nin kai ya yapo' nin nangisip si Pedro a wana, “Ay, Maistro, mabista ta iti atamoyna; mama'deng kamin tulo ray abung-abong; saya para komo, saya para kona ni Moises tan saya para kona ni Elias.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ket sin mampag'irgo ya et si Pedro, bigra' anan main nin gunem nin nanirong konra. Sinakban sara nin sitin gunem ket linmi'mo saray tulo. ");
INSERT INTO smkNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ket main nin busis nin nangibwat sa gunem a narnge' ra a wana, “Siti a Anak ko a syay Sinuyo' ko. Reng'en moya!” ");
INSERT INTO smkNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kayadi' na nin nag'irgo nin busis, na'kit ran tulo a bukod na tana ni Jesus. Leleg a kalamo' raya et si Jesus, kasa gapo nin si'numan a namaritaan ran na'kit ra. ");
INSERT INTO smkNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sin sumunor a awro, sin linmusong sara si Jesus nin nangibwat sa talugtog, sinna' rasaran abaw a tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kapingmatan, main nin sayay lalakidtaw konran abaw nin tutawo a tinma'way nin wana, “Maistro, ka'dwan ma payti si anak kon lalaki ta kapagkapag na! ");
INSERT INTO smkNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anaod, main nin ispiriton duka' a subli-subli' nin sumrep kona ket tepe' nin serpan naya, bigra' yan umagrang tan mangaridatdat anggan gumura' a bebey na. Paidapen naya tan dandani naya kai ana nin lakwanan. ");
INSERT INTO smkNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nikidawat akon inganga'do konran tumutumbok mo a palakwanen raya, bale' kai ra nin nababaan.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ket ni'bat na ni Jesus konra, “Abagay kamoyna! Ambale' nin kasan pammemper moyo tan matiko' a pangingisip moyo? Anggan ka'no ako kadi' nin matkap nin kikalamo' tan umanos komoyo?” Mi'sa wana konan lalaki, “I'ras madti a anak mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sin mangkumadani yay anak kona ni Jesus, tinumba nayan ispiriton duka' ket pinangimamater naya. Bale' ginan-gan naya ni Jesus a ispiriton duka' nin lumakwan ya konan anak. Ket pinaanda' naya ni Jesus a anak, mi'sa niparisibi nayayna konan ama na. ");
INSERT INTO smkNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Edet, sarba ran tutawo ket naka'ngap sa sangkaalakyan a pakayadi' nan Dios. Ket leleg nin mampaka'ngapan ran tutawo a sarban ginwa-ginwa' na ni Jesus, wana konran tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Reng'en moyon maong a ibarita' ko komoyo. Si'kon si Pinaitawo, maipagamet ako konran mag'uray.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kai raya bale' nin natarusan ti a nibarita' na ta kai na nin inaburuyan nin Dios a mataros raya. Ket mali'mo saran manepet kona ni Jesus no ani a rabay nan ibarita' konan sitin inirgo na. ");
INSERT INTO smkNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sawanin, nididiskusyunan ran tumutumbok na ni Jesus no si'no konra a ibilang nin sangkata'gayan. ");
INSERT INTO smkNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bale' tanda' na ni Jesus a iti sa nakem ra, kanya' nin pinakadani nayay sayay anak kona. ");
INSERT INTO smkNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mi'sa wana konra, “Si si'numan a mampangilalaman kongko ket akuen nayaytin maayupa' nin anak, si'koyna a inako' nan lamang. Ket si mangako' kongko, inako' naya anamaet a Dios Ama a namaki' kongko. Kanya' nin si si'numan komoyo a maayupa' a nakem sya a ibilang nin sangkata'gayan.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wana bale' ni Juan kona ni Jesus, “Maistro, main nin na'kit mi nin sayay lalakin man'usaren nayay ngaran mo ta pigaw nin palakwanen nasaray ispiriton duka' sa nasrepan ran tawo ket pinaed miya bana' ta ambo' tamoyan kalamo'.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ket wana ni Jesus kona, “Andi' moya awaan ta si kai nin kumuntra kontamo ket kiayon ya kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sin adani anay tyimpo nin iyuli' yayna si Jesus sa langit, nipasaya nayna a nakem na nin mako sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kanya' nin nangibaki' yan saray nu'nayna nin nako sa sayay babali sa prubinsyan Samaria ta pigaw nin mangisadya' sara nin kami'nan nan mikakayabi. ");
INSERT INTO smkNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nu'na sarayna anaod, bale' saray tutawodtaw kai raya rabay nin pagtuluyen sa lugar ra si Jesus bana' ta nipasaya nayna a nakem na nin mako sa Jerusalem nin itaw a pangraywan ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sin natandaan ra nin tumutumbok nan si Santiago tan si Juan nin kasan mamagtuloy kona ni Jesus, wanra, “Ser, rabay mo para nin igan-gan min main nin manabo' nin apoy a mangibwat sa langit ta pigaw nin mapuuran sarayna?” ");
INSERT INTO smkNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ket inadap nasara ni Jesus tan inima'no nasara. ");
INSERT INTO smkNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ket say ginwa' ra, nako sara tana sa raruman babali. ");
INSERT INTO smkNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sin sain a iti sarayna sa dalan, main nin sayay lalakin nikiirgo kona ni Jesus a wana, “Mayi ako komo adtiman a keen mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ket wana ni Jesus kona, “Mas maong sarayna edet a uayep sa tatalon ta main nin piikapan ran diri tan sara et a manuk-manok ta main nin apunan ran diri ta, si'kon si Pinaitawo, kasa nin bali kon diri a magwa' nin painawnan.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mi'sa wana anamaet ni Jesus konan saya et itaw, “Mayi ka kongko.” Ket wanan ni'bat, “Ser, no mi'sayna li' ta itabon koya yapo' si tatay mi.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bale' wana ni Jesus kona, “Pauryan mon saray kasa sa sirong nin pag'aadi' nan Dios a mangitabon konran nati ra. Bale' si'ka, mako ka nin ipatandaan moy maipa'ka' sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sawanin, wana anamaet nin saya et itaw, “Maistro, tumumbok ako komo bale' sumubli' ako yapo' nin patanid itaw komi.” ");
INSERT INTO smkNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wana ni Jesus kona, “Si tawon bilang sa sayay mampangadado nin lingay anan lingay, kai ya maibagay nin magsirbi sa Pag'adian nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sawanin, namili' ya si Jesus a Uunuren nin pitumpulo' tan rwa et a tutawo ta pigaw nin ibaki' nasara. Mi'sa nasara pinau'nayna nin sirwarwa sa barang babali tan lugar a keen na li'. ");
INSERT INTO smkNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sin sain, wana konra, “Abaw saray nasadya' nin masagyat nin sumrep sa Pag'adian. Wanin man, matalag saray mangyayatab, kanya' edet nin idasal moyo konan Dios a syay main nin ikon sa yayataben a mangibaki' ya et nin saray trabahador nin kiyatab. ");
INSERT INTO smkNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mako kamoyna, bale' pakanda' kamo ta ibaki' katamo nin bara'mo kamo li' nin karniro nin nalibed ran mabayanin atap a uayep bana' ta abaw sara li' a tutawon kumuntra komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Andi' kamo mangi'ras nin pitaka o bag o sapatos; tan andi' kamo paabara' nin kiirgo sa masnaan moyo sa dalan. ");
INSERT INTO smkNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sa adtiman a bali nin luuban moyo, wamoyo yapo', ‘Sapa kumon ta say bindisyon nan Dios ket magkamain konran mampiikap iti.’ ");
INSERT INTO smkNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No maikana' saran mangrisibi, mangyadi' in, bale' no kai, mag'in nin kasan kakanaan nan siin a bindisyon konra. ");
INSERT INTO smkNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sa balin mangrisibi komoyo, itaw kamo nin magtuloy ket andi' kamo nin mangruba-rubari' nin pagtuluyan. Kanen tan inumen moyoy animan a ipadungo ra komoyo, bana' ta si sayay mampagtrabaho, manepeg a tubaleen ya. ");
INSERT INTO smkNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sa babalin keen moyo a akuen rakamo, kanen moyo no ani a ipadungo ra komoyo, ");
INSERT INTO smkNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","paandaen moyo saray main nin masakit konan sitaw a lugar, tan ibarita' moyo a adani anay pag'aadi' nan Dios konra. ");
INSERT INTO smkNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ket sa babalin keen moyo a kai rakamo nin akuen, mako kamo sa kalsada ket wamoyodtaw, ");
INSERT INTO smkNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mataman et say ta'pok nan babali moyo a dinmalit sa ayi mi ket pagpagen mi nin mangipa'kit a si'kamon diri a mangika' nin lalaman moyon diri sa pakadusawan. Sigurado yayti bale': Adani anay pag'aadi' nan Dios.’ ");
INSERT INTO smkNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ibarita' koyti komoyo: Sa awro nin paninintinsya nan Dios, mas mabyat li' a dusan ibi na konran tutawo sa sayay babalin kai nin mangako' komoyo dyan sa dusan nibi na konran saray tutawo sa syudad nin Sodoma sin nu'nan panaon. ");
INSERT INTO smkNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ay anaod, kado' kamoyna, si'kamon tagadti sa Corazin tan si'kamon tagadti sa Betsaida! O', abaw a mumilagron ginwa' iti komoyo bale' kai moyo nin nagbabawian a kukasalanan moyo. No itaw kumon nin ginwa' in a mumilagro sa Tiro tan Sidon ket na'teng sarayna kumon nin nisulot nin langgutsi tan tinmekre' sa abunsyang a tutawodtaw nin mangipa'kit nin pagbababawi' ra sa kukasalanan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sawanin edet, ibarita' ko komoyo, sa Awro li' nin Manintinsya yay Dios, mas mabyat li' a dusa nin ibi na komoyo dyan konran taga Tiro tan taga Sidon. ");
INSERT INTO smkNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Si'kamo anamaet nin tagadti sa Capernaum, ipa'ka' moyo layin raywen rakamo sa langit! Kai gapo! Kasan sapon itampal rakamo sa impyirno!” ");
INSERT INTO smkNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ket wana et ni Jesus konran tumutumbok na, “Edet, saray rumnge' sa minsahi moyo, si'koy rinnge' ra. Saray kai nin mangako' komoyo, si'koy kai ra nin inako'. Ket saray kai nin mangako' kongko, parihoynan lamang nin kai raya nin inako' a namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sin sinmubli' saraynay pitumpulo' tan rwa kona ni Jesus, maririket saran tuloy tan wanra, “Uunuren, mataman nin saray ispiriton duka' ket tinmulok sara komi sin nigan-gan misara nin inusar mi a pakayadi' nin nibi mo komi sa pannawag mi nin ngaran mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wana konra sin sain, “Na'kit koy nikanabo' na sa nikatalo na ni Satanas nin bilang kimat sa langit. ");
INSERT INTO smkNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","O', binyan katamon pakayadi' nin madaeg moyoy nasakupan nin pakayadi' nan sitin kalaban. Ket kai kamo nin mangno mataman no makada'da' kamon ulay o sipitan. ");
INSERT INTO smkNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wanin man, ambo' ta mapasuko' moyoy ispiriton duka' ket rumiriket kamo, no kai edet, ta nailista a ngaran moyodtaw sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bana' sa nibarita' ran nangya-nangyadi' yupa' sa pakayadi' nan Ispirito nan Dios, dinmasal ya si Jesus sa ririket na a wana, “Ama ko a Uunuren sa langit tan sa luta', raywen kata ta kai mo nin nipatandaan konran madudunong tan di-adal nin tutawo a kukatutu'wan, no kai edet, nipatandaan moyti konran saray maayupa'. O' a ta wanin a makapaririket komo, Ama.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sawanin, wana ni Jesus konran tutawo, “Nipagamet nayna kongko nin Ama ko nin gaw'en tan tandaen a sarba. Kasan makatanda' nin peteg kongko a si'kon si Anak na no kai syan si Ama ko tamo'. Kasa anamaet nin katanda' ya a Ama no kai si'kon si Anak na tan saray pilien kon pangipadaran kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sin sara tanay tumutumbok na a kaadap na ni Jesus, wana konra, “Makarma' kamo ta mangka'kit moyoy bubagay a mampangyadi' sawanin! ");
INSERT INTO smkNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ibarita' koyti komoyo, abaw saray prupita nan Dios tan uadi' intaw a masulit ran ma'kit tan marnge' ti nin bilang sa paka'kit tan pakarnge' moyo sawanin kongko, ket kai nin nangyadi' ti sin panaon ra.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sayay awro, saya konran abugado sa Gugan-gan a nako kona ni Jesus nin mangusisa' kona. Kanya' nin nitepet na, “Maistro, ani a gaw'en ko ta pigaw nin maga'muran koy anggan-angga nin byay a iti konan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ket wanan ni'bat ni Jesus, “Ani a nisurat na ni Moises itaw sa Libron Gugan-gan? Ani a tanda' mo nin man'igan-gan itaw?” ");
INSERT INTO smkNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ket wanan ubat nan sitin abugado, “Aduen may Uunuren a si Dios mo nin intiron kanakman mo, nin intiron byay mo, nin intiron pakababa' mo tan nin intiron kaisipan mo, tan aduen moy kapada mon tawo a kapada nin pangangado' mo sa lalaman mon diri.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wana ni Jesus, “Kusto a ubat mo; wanin a gaw'en mo ket main nin anggan-angga nin byay mon iti konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ket sitin saya konran abugado, bana' ta rabay nan sustinyen a iti ya sa katunungan, tinepetan nayaynaet si Jesus a wana, “Si'no a kapada kon tawo nin matkap kon kawa'nanen?” ");
INSERT INTO smkNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wanan ni'bat ni Jesus a nipadalan sa sayay alimbawa', “Main nin sayay lalakin kapada tamon Israelita nin ibat sa Jerusalem a manlumusong yan mako sa Jerico. Ket sinaneban rayan tulisan sa dalan. Sinamsam ray seket na, binalba-balbal raya mi'sa linakwanan rayan mangkamati. ");
INSERT INTO smkNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sin sain, naibansag a dinmalan yadtaw a sayay padi' a kapada nan Israelita. Ket sin na'kit nayaytaw si mampangirangep nin sakit nin sugat na, pinal'isan nayan nituloy nay nako sa keen na. ");
INSERT INTO smkNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Main anamaet nin sayay katulungan ran pupadi' nin dinmalan itaw. Na'kit nayay tawon binalba-balbal bale' linabasan nayan lamang. ");
INSERT INTO smkNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kaaram, main et nin sayay lalakin linmabas bale' taga Samaria ya. Sin na'kit nayay lalakin mangkapaidap, nanabo' a inganga'do na kona. ");
INSERT INTO smkNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kinadanyan naya tan tinambar nan arak tan ladak a sugat na mi'sa na nin binerber. Kayadi', niruran naya konan asno na mi'sa naya niyater sa sayay balin pagtuluyan tan nipaasikaso naya. ");
INSERT INTO smkNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sin sumunor a awro, nami yan kwarta konan main nin bali tan wana, ‘Alilaen maytin tawo ket no magkurang ti sa magastos mo kona, bayadan ko li' no sumubli' ako.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sawanin, tinepetan naya ni Jesus tin abugado a wana, “Si'no kadi' konran tuloy tawon linmabas sa angan-angan mo a main nin pangangado' konan sinaneban ran tulisan?” ");
INSERT INTO smkNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wanan ni'bat nin abugado, “Sitaw si nangipa'kit nin inganga'do kona.” Ket wana ni Jesus, “Kusto a wamo. Mako kayna ket mangado' ka nin wanin.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nituloy na ni Jesus tan saray tumutumbok na a pako ra sa Jerusalem ket nakarate' sara sa sayay babali. Ket itaw pinagtuloy nasara sa bali ra nin sayay babayi nin say ngaran na ket Marta. ");
INSERT INTO smkNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Main nin busat na ni Marta a say ngaran na ket Maria. Ket tinmekre' yayti sa danin ayi na ni Jesus ta reng'en nay iyakay na. ");
INSERT INTO smkNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bale' si Marta, itaw yan pinasyan paga na sa abaw a gaw'en nan pangngisadya' ket nako ya kona ni Jesus tan wana, “Ser, kai moyo layi nin mangkaasikaso a man-gaw'en koyna nga'min nin bukud-bukod a sarban gawa'? Sapa no ibarita' moyo konan busat ko nin tulungan nako anamaet.” ");
INSERT INTO smkNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ket wana ni Jesus kona, “Abagay kayna, Marta. Mangkapagawan mon tuloy a abaw nin bagay. ");
INSERT INTO smkNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anta sayay bagay tamo' a matkap, ket si Maria, pinili' nayayti ket kai yayna gapo nin maglat kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sayay awro, mandumasal ya si Jesus sa sayay lugar. Kayadi' na nin dinmasal, kinmadani ya kona a saya konran tumutumbok na tan wana, “Maistro, iyakay rakami pan dumasal a bilang sa nipangyakay na ni Juan konran tumutumbok na.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wana ni Jesus konra, “Wanti e no dumasal kamo: ‘Ama, mapagalangan ka kumon nin liso. Mag'adi' kayna kumon sa sangkamundwan. ");
INSERT INTO smkNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Byan rakami kumon nin makasadag nin kanen mi sa inawru-awro. ");
INSERT INTO smkNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pirdunawen rakami kumon sa kukasalanan mi. Anaod, si'kami, mampirdunawen misara anamaet a mampangwa' nin duka' komi. Andi' rakami nin iyadap sa mabyat tuloy a panunubok.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ket wana et konra, “Bilang wadi', main nin saya komoyo a nako sa bali nan sayay amigo na sa kapiknga' nin yabi tan wana kona, ‘Amigo, pa'daman nako pan magwa' kon ipamakan ");
INSERT INTO smkNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta main nin amigo kon rinmate' nin ibat nagbyahi. Ket kasan maipadungo ko kona.’ ");
INSERT INTO smkNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ket magwa' a i'bat na nin itaw ya sa luob nin bali na, ‘Andi' nako nin isturbwen ta nakatalak yaynay purta mi. Mampida' kami ana nin saray a'nak ko, tan idapen koynay mibangon ta pigaw nin byan katan animan.’ ");
INSERT INTO smkNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ibarita' koyti komoyo, mataman nin kai ya nin mibangon tan mami a main nin bali bana' sa piamigo ra, wanin man no mapasuet yan kadadada' na nin amigo na ket mibangon yan lamang ta pigaw nin ibi nay matkap na. ");
INSERT INTO smkNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kanya' anaod nin, kidawat kamo konan Dios nin say matkap moyo ket byan nakamo. Ituluy-tuloy moyoy manumog kona ket tulungan nakamon manumog sa mantikapen moyo. Kumutana kamo ket pasrepen nakamo. ");
INSERT INTO smkNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anaod, sarba ran kidawat, mabyan sara. Sarba ran manumog, makadumog sara; tan sarba ran kumutana, pasrepen sara. ");
INSERT INTO smkNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bilang wadi', saya kan ama, ani byan man ulay a anak mo no kidawat yan kuna'? ");
INSERT INTO smkNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, byan man sipitan no kidawat yan salay? ");
INSERT INTO smkNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No si'kamo nin tawo nin sikakasalanan ket tanda' moyoy mamin mabistan bubagay konran a'nak moyo, lalo yayna si Ama a itaw sa langit. Ibi ta ibi nayan Dios a Ispirito na konran manawat kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ni'sa, mampalakwanen naya ni Jesus a ispiriton duka' nin namaumel konan sayay lalaki. Sin napalakwan nayaynayti, nakapag'irgo yayna a tawon naumel ket naka'ngap sara nga'min a tutawodtaw. ");
INSERT INTO smkNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bale' wanran raruma, “Bana' ta si Beelzebul a syay uunuren ran uispiriton duka' ket binyan nayan pakayadi' na, makapalakwan yan ispiriton duka'.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Saray raruma anamaet, sinari' ran dinawat kona ni Jesus a mangwa' yan paka'kitan a sya ket nibaki' nayan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bale' si Jesus, tanda' na a iti sa nakem ra kanya' nin wana konra, “No si sayay nasyon ket matau-tao tan milalaban saray tutawo na, kai ya nin magnayon. Wanin anamaet, no sa sayay pamilya ket mapuruk-purok nin mikukuntra a saya tan saya, misisyay li' a pirat'anan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wanin anamaet kona ni Satanas tan saray kalalamo' na; no mikukuntra sara, pa'no a katutuloy nin pag'aadi' na? Anaod, wamoyo a mamalakwan akon uispiriton duka' yupa' kona ni Beelzebul. ");
INSERT INTO smkNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No wanin, sara pa a tumutumbok moyo, sa si'no edet nin pakayadi' sara mamalakwan nin uispiriton duka'? Saran mismo a mamatutuo nin abas kamo sa man'iparsa moyo kongko! ");
INSERT INTO smkNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ket sawanin, ta say pakayadi' kon mamalakwan nin ispiriton duka' ket ibat konan Dios, ipadar nin sayti a rinmate' anay udas nin mag'adi' yaynadti a Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Si Satanas, bilang yan sayay tawon maksaw a di-armas ket no gwardyawan nayay palasyo na, kai gapo nin mangno a main na. ");
INSERT INTO smkNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bale', no si sayan mas maksaw dyan sya ket kalabanen tan daegen ya, galten nan siti a armas nin nagpyawan na ni Satanas, mi'sa na nin taw'e-taw'en a main na.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sawanin, wana et ni Jesus, “Si si'numan a kai nin kiayon kongko, kuntra ya kongko. Si kai nin kipaninep kongko, mamisisyak ya.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ket nituloy na ni Jesus nin wana, “No napalakwan yaynay ispiriton duka' a nakasrep sa sayay tawo, mako ya nin mikadaw sa makrang nin lugar nin maningkap nin piikapan na. No kasan ma'kit na ket wana sa nakem na, ‘Sumubli' akodtaw pa sa ibwatan ko.’ ");
INSERT INTO smkNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ket sumubli' ya anaod tan marate' nayan naringgasan tan nasider. ");
INSERT INTO smkNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Edet, mako ya managyat nin pito ra et nin ispiriton mas duka' et dyan sya mi'sa sumrep saran miikap konan sitaw a tawon ibwatan na. Anaod, mas grabi et li' a kapapa'sar nan siin a tawo dyan sin nu'na.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sin sain, sin kapresan nan mampag'irgo ni Jesus, main nin sayay babayin tinma'way a wana, “Makarma' ya anaod si ina mo nin nangiyanak tan namasuso komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bale' wana ni Jesus, “Mas makarma' ya bale' a mampangrenge' tan mantumulok sa man'ibarita' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sin man'aribungbungan rayaynan abaw nin tutawo, wanan nituloy ni Jesus, “Si'kamon tutawo sawanin, sabtan kadukaan moyo. Kidawat kamon paka'kitan a say pakayadi' ko ket ibat kona nin Dios bale' kasan paka'kitan a ipa'kit komoyo no kai kal-la tamo' kapadan si na'kit a nangyadi' kona ni Jonas sin saytaw. ");
INSERT INTO smkNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Say nangyadi' kona ni Jonas ket pammatalad nan Dios konran taga Ninive. Wanin anamaet, say mangyadi' kongko nin si Pinaitawo ket pammatalad nan Dios komoyon tutawo sawanin. ");
INSERT INTO smkNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No Awro li' nin Manintinsya yay Dios, mataman nin si Rina a taga Sheba ket magtistigos ya li' a manepeg nin dusawen kamo, ta ibat sa adayo' ket mako na nin reng'en a madudunong nin akay na ni Adi' Solomon. Bale' si'kamo, anta iti yayna sawanin komoyo a mas et a kadunungan na dyan si Solomon ket kai moya gapo nin akuen. ");
INSERT INTO smkNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No Awro li' nin Manintinsya yay Dios, umadap sara li' a taga Ninive ket ibarita' ra li' a manepeg nin dusawen kamo, ta sara, sin narnge' ray nipata-patanda' na ni Jonas, nagbabawi' sara tan ginurutan raynay duka' a pigagawa' ra. Si'kamo bale', iti ya sawanin komoyo a mas ata'gay et a pakataros dyan si Jonas bale' kai moyo nin man'akuen a akay na.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nag'irgo yaynaet si Jesus konra a wana, “Kasan si'numan a manulsol nin tyo' mi'sa ikwa naya sa maadin lugar o sakban nayan salop, no kai edet, ikwa naya sa pangngitukduan ta pigaw nin sarba ran sumrep sa bali ket mapalawayan sara. ");
INSERT INTO smkNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Say mata mo anamaet ket bilang tyo' nin lalaman mo. No limpyoy pangingikit mo ket, si intiron lalaman mo bara'mon lison mapalaway ya. Bale' no main nin dipikto, bilang nin si intiron lalaman mo ket nadedleman ya. ");
INSERT INTO smkNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Anaod, siguradwen moyon say palaway nin mampalawayan kamo ket kai nin mandumedlem iti komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sawanin, no say intiron kanakman moyo ket mapalaway tan kasa gapon madedlem a parti, mapalaway anamaet a intiron kinatawo moyo ket, mapalaway a bilang sa sayay lampadawan nin say salag na mamalaway komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Leg'an nan mampag'irgo ni Jesus, main nin sayay Pariseo nin nanagyat konan mangan itaw konra, kanya' nin nako yadtaw konra si Jesus tan dinmungo yaynan mangan. ");
INSERT INTO smkNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bale' naka'ngap yay Pariseo sin naasikaso nan kai na nin tinumbok ni Jesus a ritwal nin manguyas yapo' nin gamet ba'yo nin mangan. ");
INSERT INTO smkNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ket wana ni Jesus kona, “Si'kamon Pariseo, man-gaw'en moyon maong a kaugalian moyo bilang sa pangriringgas moyon rikor nin tasa tan lipong moyo, bale' say kanakman tan pigagawa' moyo ket napno' nin kaaguman tan kadukaan. ");
INSERT INTO smkNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kalawakaw kamo! Ambo' para a si Dios a syay nangwa' nin lalaman tamo ket syan lamang a nangwa' nin kanakman tamo? ");
INSERT INTO smkNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kanya' nin palinisen moyo yapo' a iti sa kanakman moyo, mi'sa mangibwat sa malinis a kanakman moyo ket mami kamo konran makatkap, ket malinis kamo anaod. ");
INSERT INTO smkNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kado' kamoyna, si'kamon Pariseo! Wanin ta man'ibi moyo konan Dios pati say kakapulo' nin mula moyon ipangrikado moyo tamo', bale' mampauryan moyoy mas maalagan ipagwa' nin Gugan-gan bilang say pangwa' moyon mapteg tan say pangangado' konan Dios. Sayti a manepeg nin gaw'en moyo leg'an moyon gaw'en lamang a raruma. ");
INSERT INTO smkNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kado' kamoyna, si'kamon Pariseo! Wanin bana' ta maalaga komoyoy tumekre' sa tekrean para konran impurtantin tutawo sa sinaguga tan say pagalang-galangan ran tutawo sa publiko. ");
INSERT INTO smkNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kado' kamoyna! Bilang kamon nanabunan a kasan marka kanya' nin mangkada'da-da'daan ran tutawo ket kai ra tanda' nin nadulingatan sarayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sin sain, main nin saya konran abugado sa Gugan-gan a inumbat kona ni Jesus a wana, “Ser, sa sain a nibarita' mo ket masakitan anamaet a nakem mi a.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ket wana ni Jesus, “O', kado' kamoyna anamaet, si'kamo nin abugado! Wanin ta mampabyaten moyoy ipatumbok moyo konran tutawo nin dandani kai nin ma'wit, bale' ni buga' ket kai kamo tumulong. ");
INSERT INTO smkNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kado' kamoyna ta mampangwa' kamon alalakin lapida bana' ta napati sarayna a prupita a saran lamang a nipapati ran saray pupuon moyo. ");
INSERT INTO smkNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mapatnag a kiayon kamo sa ginwa-ginwa' ra ta sara anaod a namapati konran saray prupita, mi'sa si'kamo anamaet a mampangwa' nin mabibistan lapida ra. ");
INSERT INTO smkNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ket si Dios a sangkadunungan ya wana maipa'ka' komoyo, ‘Ituloy koy mangibaki' konra nin prupita tan ibabaki' ko ket main sara konray patyen ra tan saray raruma ket duksaen rasara.’ ");
INSERT INTO smkNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kanya' nin, si'kamon tutawo konan sitin panaon, tandaan moyo et a lamang nin dusawen ta dusawen nakamon Dios bana' sa nipangmati ran pupuon moyo konran sarba ran prupita nangibwat ana sin pinarsa yaytin mundo, ");
INSERT INTO smkNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nangibwat sa nipangmati kona ni Abel angga kona ni Zacarias a pinati sa pisa'lean nin altar tan Timplo. O', si'kamon tutawo konan sitin panaon a umbat sa sarban sayti.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wana et ni Jesus, “Kado' kamoynan talaga, si'kamon abugado maipa'ka' sa Gugan-gan, ta ginlat moyo in konran tutawo si bara'mon tumbok sa pakataros sa maipa'ka' sa pakaisalba a mangibwat konan Dios. Si'kamo, kai moyon lamang inako' in a pakaisalba. Wanin et a sidaen moyoy kaisipan ran tutawo ta pigaw nin kai raytin lamang nin mataros.” ");
INSERT INTO smkNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sin nibwat yaynadtaw si Jesus sa bali, masager sara kona. Ket man'ipamuspusan raynan saray Pariseo tan Madudunong sa Gugan-gan a mapag'irgo raya maipa'ka' sa nagsikabarang a bubagay, ");
INSERT INTO smkNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ta la'wanen raya awa' a magkabiso' ya sa pag'iirgo na ket main nin ipakasalanan ra kona. ");
INSERT INTO smkNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Leleg nin wanin, sabtan ka'bawan raynan tutawon nididinep nin sa ka'bawan ra ket mangkapida'daan sarayna. Sara yapo' a tumutumbok na a kinairgo na ni Jesus a wana, “Pakanda' kamo ta pigaw nin kai nin magkuri komoyo a bilang nin pammakbo ran Pariseo a say piwadi'-wadi' ran maong saran tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sarban bara'mon naiyadi a kai nin tanda' sawanin, matandaan li' a lamang sa adapen ta kasan sikrito nin kai matandaan. ");
INSERT INTO smkNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kanya' nin, animan a nag'irgwan moyo nin sikrito, matandaan li' nin sarba, tan animan a iyanas moyo sa rarem nin kwarto ket maita'way li' sa rikor. ");
INSERT INTO smkNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ket ibarita' ko komoyo, si'kamon uamigo ko, andi' kamo nin mali'mo konran marabay nin mangmati komoyo ta say lalaman moyo tamo' a mapati ra. Mayadi' ket kasaynan raruma et nin magwa' ra. ");
INSERT INTO smkNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ipau'na-u'na koyna komoyo no si'noy manepeg moyon ikali'mo. Si ikali'mo moyo ket si mayadi' ya nin mangmati ket main nin pakayadi' nan mangibantak et sa impyirno. Ibarita' koyti komoyo, si Dios a manepeg nin ikali'mo moyo! ");
INSERT INTO smkNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Magwa' saran binting tamo' a liman manuk-manok. Mataman nin wanin bale', ni saya konra ket kai na nin mampauryan nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Balu'-balo' kamoyna! Ultimo et a say sabot moyo sa ulo ket nabilang na. Kanya' anaod nin andi' kamo nin mali'mo bana' ta mas mabli kamon adayo' kona dyan saray abaw a manuk-manok. ");
INSERT INTO smkNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ket ibarita' ko komoyo a si si'numan a mangipatutuo konran tutawo a tumutumbok koya, si'kon si Pinaitawo ket ipatutuo kon tumutumbok koya sa adapan ran uanghil nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bale' si si'numan a mangibudi' konran tutawo a tumutumbok koya, ibudi' ko li' anamaet a tumutumbok koya sa adapan ran uanghil nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Si si'numan a mag'irgo nin animan a kuntra kongko a si Pinaitawo, mapirduna ya et. Bale' si tawon mamaduka' nin kabistawan nan Ispirito nan Dios, kai ya gapo nin mapirduna. ");
INSERT INTO smkNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sa tyimpo a ika' rakamo nin iyadap konran mampag'uray sa susinaguga, o konran iti sa uray, o konran raruma et nin main nin pakauray ta pigaw nin usisaen rakamo bana' sa pammemper moyo kongko, andi' moyo nin kaaburidwan no ani a ibarita' moyo, o no pa'no a i'bat moyo ");
INSERT INTO smkNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","bana' ta konan sitaw li' nin udas, si Ispirito nan Dios ket iyakay nakamo no ani a manepeg moyon ibarita'.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sawanin, main nin saya konran nididinep nin tutawodtaw a nikiirgo kona ni Jesus a wana, “Maistro, bibilinen moya pay busat ko nin ibi nayna a tao ko sa tawir mi.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ket wana ni Jesus kona, “Ya! Amigo, ambo' in a nakaibakian ko si pag'urayan a pitao moyon tawir moyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ket wana et konran tutawodtaw, “Pakailag kamo maipa'ka' sa apes-apesen moyo! Andi' kamo kumon nin maagom sa animan ta say byay, ambo' nin dipindi sa ka'bawan nin kamamain.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ket namarita' ya nin sayay pangingiyarig maipa'ka' sa sain a wana, “Main nin sayay mayaman nin abaw nin tuloy a nayatab na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ket wana sa nakem na, ‘Ani kadi' a mabistan gaw'en ko ta kasaynan mapangaturan ko nin raruman nayatab ko?’ ");
INSERT INTO smkNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wana ana et, ‘A, maya' pa! Yubaen koy agamang ko tan mama'deng akon mas alalaki nin pangaturan kon yatab tan raruma et nin main ko. ");
INSERT INTO smkNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ket wangko li', “Ay! Abaw ana a nadinep nin niyator kon ikabyay para sa abaw a taon. Painawa akoyna tana, minom, mangan tan mipariga.” ’ ");
INSERT INTO smkNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bale' wana nin Dios kona, ‘Kalawakaw! Sitin yabi, kalapen koyaynay byay mo. Sawanin, si'noyna a keen nin sain say abaw a nisadya' mo para sa lalaman mo?’ ");
INSERT INTO smkNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wanin a kapapa'sar nan sayay maninep nin kayamanan para sa lalaman na bale' ambo' yan mayaman konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sawanin, wana et ni Jesus konran tumutumbok na, “Kanya' edet nin ibarita' koyti komoyo: Andi' kamo nin umaburido maipa'ka' sa matkap moyo konan sitin byay a bilang sa ikabyay tan sa isket moyo. ");
INSERT INTO smkNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Anaod, say pipa'kaan nin byay moyo ket mas ararem dyan say pangangan tan pisisket. ");
INSERT INTO smkNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Imatunan moyo saray uwak: Kai sara nin mampangmula ni mampangyatab. Kasan agamang ra o mampangaturan ran kanen ra. Wanin man, mambyan nasaran Dios nin ma'kan. Anaod, mas mabli kamo konan Dios dyan saray mumanuk-manok! ");
INSERT INTO smkNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anamaet, mapaanro moyo kasi a byay moyo mataman nin sayay udas tamo' no umaburido kamo? ");
INSERT INTO smkNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No kai moya nin magwa' in nin daite' tamo' nin bagay, mayin a kaaburidwan moyo et a raruma? ");
INSERT INTO smkNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Imatunan moyo pay kabibista nin buburak nin dikot. Kai nin magtrabaho ni mangabel nin isket ra. Bale' ibarita' ko komoyo, abirno aninay pupustura nin seket na ni Adi' Solomon ta wanin anay yaman na, kai ya et nakapisket nin kapadan bista nan saya sa sain nin buburak. ");
INSERT INTO smkNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ket no mapasketan nan wanin kabista nin Dios a dudikot a isen sawanin bale' dilap ket magwa' a ipuor tamo' sa syang, mas lalo ana a byan nakamon isket moyo! Aninay kababwan nin pagmamatalek moyo! ");
INSERT INTO smkNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanya' nin andi' moyo tana nin pirmin pipanemtem no ani a kanen o inumen moyo tan andi' moyoyti nin pakaaburidwan. ");
INSERT INTO smkNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","O' anaod, sain nin bubagay a iti sa nakem ran sarban tutawon kai nin mangalilbi' konan Dios bale', main ya a Ama moyon itaw sa langit nin magtanda' a matkap moyo in nin bubagay. ");
INSERT INTO smkNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ana edet, matkap a say mu'na-mu'na nin iti sa kanakman moyo ket si maiyadilanta a maipa'ka' sa pag'aadi' nan Dios ket ibi na anamaet in nin matkap moyo. ");
INSERT INTO smkNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Si'kamo nin mampagawan ko, umno kamo tamo'. Wanin man, andi' kamo nin mali'mo ta maririket yan maong a Ama moyon itaw sa langit nin kirama' kamo sa Pag'adian na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilako' moyoy main moyo, ket mami kamo konran makatkap sa naglakuan moyo. No wanin a gaw'en moyo, mampaninep kamo itaw sa langit nin kayamanan nin kai nin masida' tan ma'pos, nin kai ra ma'ka' nin mannakaw tan kai ra nin masida' nin insikto. ");
INSERT INTO smkNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anaod, maninep kamodtaw ta no adti a kami'nan nin mabli komoyo, itaw anamaet a nakem moyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Wana et ni Jesus, “Sumadya' kamoynan si'kamon magsisirbi. Matkap a bara'mo kamon saray ualila' nin nakasili tan nakapadta a lampadawan nin ");
INSERT INTO smkNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mantuma'gan sa iyuyugot nan amo ran ibat sa bansal. Nakasadya' sara ta pigaw nin no rumate' ya ket tumuktok ya sa purta, tampor nin maabryan raya. ");
INSERT INTO smkNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Makarma' saray wanin a ualila' a marate' nasaran amo ra nin nakasadya'. Anaod, ibarita' koyti komoyo a sitin amo, magpripira yan magsirbi konran ualila' na ");
INSERT INTO smkNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","mataman no rumate' ya sa kapiknga' nin yabi o no parbangon ana nin padungwen nasaran mangan. Paririketen nasara no nakasadya' sara! ");
INSERT INTO smkNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandaen moyoyti: No kumon ket tanda' nan main nin bali no ka'no ya nin mako a mannakaw, siguradon sadyaan naya, ket si mannakaw kai naya nin masrep a bali na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kanya' anaod nin, taman nin si'kamo, matkap a sisasadya' kamo nin lawas ta si'kon si Pinaitawo ket bigra' a rumate' ako li' no ka'no nin kai moyo ipa'ka'.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sawanin, si Pedro, tinmepet ya kona ni Jesus a wana, “Maistro, siin a pangingiyarig, para ya komin tumutumbok mo o para ya sa sarban tawo?” ");
INSERT INTO smkNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ket wanan ni'bat nin Uunuren a saya yan pangingiyarig, “Edet, si'noy kumana' nin tawo na? Si'noy sayay manakem tan kapagpyawan a alila'? Iyintriga na nin amo na kona a pangangasikaso konran kapada nan alila' tan pammi nin inawru-awron rasyon ran ikabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Paririketen naya nin amo a wanin nin ingkargado no sa irarate' na ket wanin a man-gaw'en na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Anaod, ibarita' koyti komoyo, pag'inen nayan amo na nin ingkargado sa sarban main na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bale' no siin nin ingkargado ket wana sa nakem na, ‘Ma'teng ya et nin rumate' a amo ko,’ ket sasakit-sakiten nasaray kapada na nin alila', lulalaki man o bubbayi, tan mipapda' yan mangan tan minom anggan mabok ya, ");
INSERT INTO smkNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","anta main ket, rumate' yay amo na nin kai na gapo nipa'ka' nin rumate' ya. Ket kasan sapon dusawen nayan say makapati nin amo na ket itampal nayan ikalamo' konran kai nin kapagpyawan. ");
INSERT INTO smkNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ket si ingkargado a magtanda' ana sa karabayan nan amo na, bale' kai ya nin sinmadya' o kai na nin ginwa' a man'ipagwa' kona, dusawen nayan maong nin amo na. ");
INSERT INTO smkNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bale' si ingkargado a kai nin magtanda' sa karabayan nan amo na, ket nakagwa' yan subag kona, buga' tamo' a panunusa kona. Anaod, si sayay binyan nin abaw o nangipyawan nin abaw, mas abaw anamaet a ilalwan kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wana et ni Jesus, “Nako akodti sa luta' ta pigaw nin ringgasan koyan apoy a mundo. Ket sapa kumon ta kapresan ana. ");
INSERT INTO smkNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bale' matkap a mangirangep ako yapo' nin dya'dya' ket anggan kai et nin nangyadi', say kaisipan ko ket kai nin makapainawa. ");
INSERT INTO smkNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sa wamoyo nako akodti sa luta' ta pigaw nin mitutuno saray tutawo? Kai! Nako akodti ta pigaw nin mapuruk-purok saray tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ket mangibwat sawanin, bilang wadi' sa limay katawo sa sayay pamilya, kuntrawen rasara li' nin tulo a rwa tan wanin ra anamaet nin rwa a kuntrawen rasara li' a tulo. ");
INSERT INTO smkNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wanin anamaet, saray mitraama, mikuntra sara; saray mitraina, mikuntra saran lamang; si katyangan nin babayi kikuntra ya konan manuyang nan babayi, o si manuyang nin babayi kikuntra ya konan katyangan nan babayi.” ");
INSERT INTO smkNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wana anamaet ni Jesus konran abaw nin tutawodtaw, “No ma'kit moyon mangkumubpal a gunem sa panrupan, tampor a wamoyo, ‘Rumapeg kadi'.’ Ket rinmapeg yan page'. ");
INSERT INTO smkNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No maingar moya anamaet a sirin timog wamoyo, ‘Pinasyan amot kadi'.’ Ket pinasyan amot nin page'. ");
INSERT INTO smkNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Si'kamon mampimaung-maong! Mataros moyoy pipa'kaan nin bakas nin luta' tan nin langit, ket sukat a kai moyo nin mataros a pipa'kaan nin mampangyadi' sawanin nin panaon? ");
INSERT INTO smkNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Edet, magdisisyon kamo no ani a matunong sa adapan nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bilang wadi', no main nin mangidimanda komo ket i'ras naka sa husgado, kiariglo kaynan tampor mintras nin iti kamo et sa dalan, ba'yo ka nin maiyadap sa kurti, ta no kai, ipasuet nakan i'ras konan hwis, mi'sa ipagamet nakan hwis konran pulis ket ipriso raka. ");
INSERT INTO smkNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ibarita' koyti komoyo, buruken rakadtaw sa tana a mabayadan mo a sangkaultimwan nin sintabos a multa mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sin sain, main nin tutawodtaw nin nangibarita' kona ni Jesus nin maipa'ka' konran umno ray taga Galilea a nipapati na ni Pilato leleg ra nin mampangida'ton nin pinatin uayep konan Dios ket nailawok a daya' ra sa daya' nin da'ton ra. ");
INSERT INTO smkNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ket wana ni Jesus konra, “Man'ipa'ka' moyo para nin mas mabyat a kasalanan ran saraytaw nin pinati dyan saray raruman taga Galilea bana' sa wantaw nin nikapati ra? ");
INSERT INTO smkNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ibarita' ko komoyo a ambo' nin wanin! Ket si'kamo, no kai moyo nin gurutan a pagkakasalanan moyo, madusa kamo ket mati kamon lamang nin bilang konra. ");
INSERT INTO smkNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Saya et, saray labinwaloy tawon nati nin nadag'anan nan latudi nin itaw sa Siloe, sa wamoyo, mas makasalanan sara dyan saray kapada ran mampiikap sa Jerusalem? ");
INSERT INTO smkNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ibarita' ko komoyo a ambo' nin wanin! Ket si'kamo, no kai moyo nin gurutan a pagkakasalanan moyo, madusa kamo ket mati kamon wanin lamang konra.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ket wana ni Jesus konra a sayay pangingiyarig, “Si sayay tawo ket main nin mula nan igos sa luta' na. Ni'sa, kina' na nin kinikit no main nin bunga na, ket kasa gapo nin na'kit na. ");
INSERT INTO smkNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kanya' nin, wana konan si mangngalila', ‘Ya! Tuloy taon koynan mampakodti mangkit nin bunga nan sitin puon, ket anggan sawanin kasa et gapo. Pukanen maynayti ta mangukupa ya tamo' nin lugar.’ ");
INSERT INTO smkNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ket wanan sitin mangngalila', ‘Ser, palabasen ta yapo' a sayay taon ta sukaden koy libed nin puon na tan kwan yan gwano. ");
INSERT INTO smkNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No gumunga ya li' no sumunor a taon, maong, ket no kai, saytaw yayna li' nin pukanen.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sayay Awron Painawa, anamanaet ket mampangyakay ya si Jesus sa sayay sinaguga. ");
INSERT INTO smkNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sin sain, main itaw nin sayay babayi nin labinwaloy taon naynan mangkapaidap ta nasrepan yan ispiriton duka'. Kanya' nin ginmukot ya tan kai nayayna gapo nin maitarindeg a gurot na. ");
INSERT INTO smkNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sin na'kit naya ni Jesus, kinayaban naya, mi'sa wana, “Mangibwat sawanin limpyo kayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nipababo na ni Jesus a gamet na konan si babayi ket, sin sain, tampor nin naitarindeg nay lalaman na kanya' nin rinayu-rayo nayay Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sawanin, masager yay pangulo sa sinaguga bana' ta sa Awron Painawa na ginwa' in ni Jesus ket wana konran tutawo, “Main nin a'nem a awron matkap a mag'ubra. Sa saytaw nin awro kamo makodti nin patambar ambo' no Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ket wanan ni'bat ni Jesus nin Uunuren kona, “Maong kamo wadi'! Kai para a say barang saya komoyo mataman no Awron Painawa ket usbagen moyo sara sa nakaipugedan ray ayep moyo ta ika' moyo sara nin painumen? ");
INSERT INTO smkNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Siti nin babayi, a nangibwat anaod sa puri na ni Abraham, ket pinagmasakit naya ni Satanas sa luob nin labinwaloy taon. Ambo' para nin manepeg a pa'sar balukasan ya anamaet mangibwat sa masakit na sa Awron Painawa?” ");
INSERT INTO smkNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sa sain a nibarita' na ni Jesus, sarba ran kuntra kona ket napading'eyan sara. Bale' maririket saray raruman tutawodtaw bana' sa sarban bubagay nin makapaka'ngap a ginwa-ginwa' na. ");
INSERT INTO smkNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ket nituloy na ni Jesus a pangangakay na. Wana, “Pa'noy pag'aadi' nan Dios? Adti nin maiyarig? ");
INSERT INTO smkNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Say iyadilanta nin pag'aadi' nan Dios ket maiyarig sa sangkadaitean nin bikoy nin mustasa a nika' na nimula nin sayay tawo sa pukok na. Tinmubo' ya anggan nag'in yan kayo ket nipugaran ran mumanuk-manok a susanga na.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wana et ni Jesus, “Ani et a pangiyarigan ko sa pag'aadi' nan Dios? ");
INSERT INTO smkNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Say pakaitayak nin akay maipa'ka' sa pag'aadi' nan Dios ket maiyarig et sa pammakbo. Nilawok nan sayay babayi a daite' nin pammakbo sa rwampulo' a salop nin arina ket kinumbo yay intiron minasa na.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nituloy ra ni Jesus a pako ra sa Jerusalem ket sa nadalanan ran bubabali tan bubaryo, tinumge-tumgen saran nangyakay. ");
INSERT INTO smkNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sawanin, main nin nanepet kona ni Jesus a wana, “Ser, umno sara tamo' para a maisalba nan Dios?” Ket wanan ni'bat ni Jesus konran tutawo, ");
INSERT INTO smkNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gaw'en moyoynay anggawan nin mababa' moyon makasrep sa akipot nin purta nin mako sa anggan-angga nin byay. Ibarita' koyti komoyo: Rumate' li' a panaon nin abaw saray masuet nin sumrep bale' kai sara nin makasrep. ");
INSERT INTO smkNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nisada' nayayna li' a purta nin main nin bali ket, si'kamo itaw kamo tana sa rikor, mantumuktok kamon mampangumbinsi a wamoyo, ‘Ser, pasrepen rakami pa.’ Ket si ubat na komoyo, ‘Andyak ta kai katamo nin katanda' tan kai ko nin tanda' no adti a ibwatan moyo.’ ");
INSERT INTO smkNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ket wamoyo, ‘Nakadungo rakamin nangan tan ninom, tan nangyakay kadtaw et sa lugar mi.’ ");
INSERT INTO smkNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bale' i'bat na, ‘Kai kamo nin makakibiang iti, si'kamon sarba nin gumu-gumwa' nin duka'! Kumadayo' kamo kongko!’ ");
INSERT INTO smkNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ket umasisit kamo tan ngumaretenget a ngipen moyo bana' sa pakapaidap. Anaod, ma'kit moyo saradtaw si Abraham, si Isaac, si Jacob tan sarba ran prupita nan Dios sa Pag'adian na, ket si'kamo bale', mampalakwanen kamo ket kai kamoyna gapo nin makasrep. ");
INSERT INTO smkNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Main anamaet nin tutawon kipunsyadtaw sa Pag'adian nan Dios nin mangibwat sa panrupan tan sa baytan, wanin et sa bagatanan tan sa amyanan. ");
INSERT INTO smkNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anaod, main saray tutawon mipaayupa' sara sawanin ket maita'gay sara li', tan main sara anamaet a mipata'gay sara sawanin ket maikayupa' sara li'.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Konan siin et a lamang a udas, main nin Pariseo nin nako kona ni Jesus a wanra, “Mibwat kaynadti yapo' ta rabay naka kano nin ipapati ni Adi' Herodes Antipas.” ");
INSERT INTO smkNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ket wanan ni'bat ni Jesus, “Mako kamo konan siin nin tawon bara'mon alimutang a mataktika tan ibarita' moyo kona a wangko a sawanin tan no dilap ket ituloy ko et a lamang a mamalakwan nin ispiriton duka' konran nasrepan ra tan mamaanda' nin main nin masakit. Ket sa ikatlon awro, mayadi' koyna a gawa' ko. ");
INSERT INTO smkNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","O' a, kanya' nin ituloy koy pako ko sa keen ko sawanin, no dilap tan angga et no kamakarwa bana' ta adti et anaod a lugar nin pangmatyan konan sayay prupita nan Dios no kai itaw sa Jerusalem? ");
INSERT INTO smkNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O si'kamon taga Jerusalem, patye-patyen moyo saray prupita tan kudas-kudasen moyo saran patyen a tutawo nan Dios a ibaki' na komoyo! Ni'no koyna sinari' nin dinepen katamon bilang sa pananayakop na sa sirong nin pakpak nan inan manok konran siwsiw na. Bale', si'kamo, andi' kamo! ");
INSERT INTO smkNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Anaod, pauryan nayayna nin Dios a lugar moyo! O' ibarita' koyti komoyo, kai rakoyna nin ma'kit angga nin rinmate' ana a panaon nin maibarita' moyo a wanti, ‘Binindisyunan nayan Dios a nibaki' na nin manrumate' anadti sawanin kontamo!’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Saya anamanaet nin Awron Painawa, sinagyat ya si Jesus nin mangan sa bali nan sayay pangulo ran Pariseo. Ket man'imatunan rayan itaw no ani a gaw'en na. ");
INSERT INTO smkNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Anaod ta itaw ya sa dani na a sayay lalakin umna-umnal a lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ket tinepetan nasara ni Jesus a Pariseo tan saray abugado sa Gugan-gan a wana, “No paandaen nayan sayay tawo a sayay main nin masakit no Awron Painawa, subagen na kasi a Gugan-gan, o kai?” ");
INSERT INTO smkNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nititinek sara tamo' bale'. Sin sain, nipababo nay gamet na ni Jesus konan lalaki ket inmanda' ya, mi'sa pinaugot nayayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kayadi' sain, wana ni Jesus konran saray abugado tan saray Pariseo, “Bilang wadi' a main komoyo a si anak na o si baka na ket nanabo' ya sa bubon, kai naya kasi nin arwasen nin tampor mataman no Awron Painawa?” ");
INSERT INTO smkNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ket kai sara nin naka'bat konan tepet na. ");
INSERT INTO smkNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sin sain, naasikaso na ni Jesus a main konran saray sinagyat a pinili' ran tekrean a para konran saray ata'gay nin tutawo. Kanya' nin wana konra, ");
INSERT INTO smkNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bilang wadi' ket sinagyat ka sa sayay bansal, andi' ka nin tumekre' sa tekrean a para konran saray ata'gay nin tutawo, ta bangli' no main nin sayay sinagyat nin mas ata'gay nin tawo dyan si'ka. ");
INSERT INTO smkNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ket si nanagyat ika' naya nin patekreen sa mantekrean mo tan wana komo, ‘Para konan sitin tawo ya in nin tekrean.’ No wanin ket mading'eyan ka nin erpe-erpes nin mako sa rigrig. ");
INSERT INTO smkNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ana edet, no main nin managyat komo, itaw ka sa rigrig tumekre' ket keen naka li' nin namabansal nin ibarita' na komo, ‘Amigo, taynadtaw e tumekre' sa naisadya' nin tekrean!’ Konan siin ket mapagalangan ka sa adapan ran kadungo mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anaod, si mangita'gay nin lalaman nan diri, maikayupa' ya li' ket si mipaayupa', maita'gay ya li'. ");
INSERT INTO smkNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sawanin, wana anamaet ni Jesus konan Pariseo a nanagyat kona, “No manadya' ka para sa sayay pakan, ambo' nin saray uamigo mo, bubsat mo, kukanayon mo, tan saray mumayaman nin kabaraybay moy sagyaten mo, ta masagyat raka li' anamaet ket natubale' kayna. ");
INSERT INTO smkNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ana edet, no mamakan ka, maong anan saray pubri, pilay, bulag a sagyaten mo. ");
INSERT INTO smkNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ket makarma' ka li' ta kai sara nin makatubale', bale' si Dios tubaleen naka li' no pasublien nasarayna nin mabyay a mapteg.” ");
INSERT INTO smkNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sin narnge' nayti nin saya konran saray kadungo na ni Jesus nin mampangan, wana kona, “Makarma' saray makakidungon mangan itaw sa Pag'adian nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ket wanan ni'bat ni Jesus a nipadalan na sa sayay pangingiyarig, “Main nin sayay mamapunsya ket abaw saray sinagyat na. ");
INSERT INTO smkNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sin narate' anay awron punsya, nipakayaban nasaray sinagyat konan katulong na a wana konra, ‘Kamoyna ta nakasadya' ana nga'min.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bale' sarba ra main nin bada'nan. Wanan nu'na, ‘Nakasaliw akon luta'. Matkap nin keen koya bisitawen. Kidawat akon dispinsa.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wana anamaet nin saya, ‘Nanaliw akon mapulo' ray damulag. Keen kosara nin sarien nin ipangadado. Kidawat akon dispinsa.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wana nin saya et, ‘Kayadi' ko tamo' nin nikasal kanya' nin kai ako nin makapika'.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sin sain, sinmubli' yaynay katulong tan nibarita' naytin bubada'nan ra konan amo na. Sawanin, sabtan sager nan amo kanya' nin ginan-gan nayay katulong nin wana, ‘Madali' ka, mako ka sa palingki, sa plasa tan sa kukalsada ta i'ras mosaradti a pubri, a bulag tan pilay.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ket kaaram, sinmubli' yaynaet a katulong konan amo na tan wana, ‘Ser, ginwa' koynay nigan-gan mo kongko, bale' abaw et a bakantin tekrean.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ket ni'bat nan amo konan katulong, ‘Mako ka edet sa dudalan ta pasueten mosaray tutawo nin makodti ta pigaw nin mapno' yay bali ko ");
INSERT INTO smkNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ta ibarita' koyti komoyo, ni si'numan konran saraytaw saray nu'nan sinagyat nin nagbada' ket kai nin makataway sa nisadya' ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sa nipangituloy na ni Jesus nin mako sa Jerusalem, pinasyan ka'bawan ran tutawon nayi kona. Sin sain, inmadap ya konra ket wana, ");
INSERT INTO smkNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Si si'numan a marabay nin tumumbok kongko nin mas alaki a pangangado' na konran mangatua na, asawa na, a'nak na, bubsat na, tan taman sa lalaman nan diri dyan sa pangangado' na kongko, kai ya nin magwa' nin mag'in nin tumutumbok ko. ");
INSERT INTO smkNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O' ta si tawon kai nin pa'sar mamalatay nin kudos na nin ipulisay na a sarban mabli kona, kai nan lamang nin magwa' a mag'in nin tumutumbok ko. ");
INSERT INTO smkNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Anaod, si si'numan nin tumumbok kongko ket matkap a bilang yan sayay mampagplanon mama'deng nin bali. Kwintawen na yapo' a magastos na ta pigaw nin matandaan na no sumadag a kwarta na nin ipangyadi' konan bali ");
INSERT INTO smkNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ta sali' no mayadi' na nin maipa'deng a pundasyon, kai nayayna nin maituloy ket sarba ran maka'kit kaka'lisan raya ");
INSERT INTO smkNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nin wanra, ‘Ya, siin a tawo, nama'deng ya ket kai naya nin nayadi'.’ ");
INSERT INTO smkNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wanin anamaet, no girawen yay sayay adi' a main nin mapulo' a ribon sundalo', ket si adi' a mangira kona ket main anamaet nin rwampulo' a ribon sundalo' na, siguradon isipen na yapo' tan adalen na no mababa' rasaran labanan nin mapulo' a ribon sundalo' na a rwampulo' a ribon sundalo' nan kagira na. ");
INSERT INTO smkNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ket no wadi' a kai ra nin mababa', mintras a kai sara et nin inmintra a kalaban, mangibaki' yaynan mangilalaman kona nin mangibarita' konan si saya et nin adi' no ani a matkap nan gaw'en ta pigaw nin mituno sara. ");
INSERT INTO smkNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Edet, no kai nin gurutan nin si'numan a sarbaynan main na, kai ya magwa' nin mag'in nin tumutumbok ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Anaod, say asin, maalaga; bale' no tinmab'ang ana, kai ana gapo nin maisubli' a taway nin ma'sin. ");
INSERT INTO smkNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kasaynan sirbi mataman tanan usaren sa luta' o gaw'en nin gwano ket ibantak ana. Si'kamon manrumnge', adalen moyon maong tin narnge' moyo.” ");
INSERT INTO smkNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sawanin, abaw saray maniningir nin buis tan saray raruman bantog nin makasalanan a nako nin inmaribungbong kona ni Jesus ta pigaw nin mangrenge' saran uakay na. ");
INSERT INTO smkNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ket main itaw nin Pariseo tan Madudunong sa Gugan-gan a bere-bere nin wanra, “Ya, sitin tawo ket akuen nasaray tutawon makasalanan ket kidungo ya et nin mangan konra!” ");
INSERT INTO smkNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bana' ta wanin, nibarita' nayayti ni Jesus nin pangingiyarig: ");
INSERT INTO smkNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“No wadi' ta main nin saya komoyo a main nin sanyasot a karniro, mi'sa nabarang yay saya, piho nin ibati' nasaray syam a pulo' tan syam itaw sa mampamasturan na, ta keen naya nin tikapen taw si saya nin nabarang anggan madumog naya. ");
INSERT INTO smkNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mi'sa, no nadumog nayayna, balatayen nayan siririket nin isubli' nayaynadtaw sa kami'nan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ket no rumate' yadtaw sa bali ra, kayaban nasaray uamigo na tan kukabaraybay na a wana, ‘Rumiriket a saya tan saya kontamo ta nadumog koyaynay nabarang nin karniro ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ket wana et ni Jesus, “Ibarita' koyti komoyo, wanin a lamang a mas maririket saray itaw sa langit, no si sayay tawon makasalanan ket pagbabawian nayna a kukasalanan na, dyan bana' konran syam a pulo' tan syam nin matunong kano nin man'ipa'ka' ra a kai rayna nin matkap a magbabawi'.” ");
INSERT INTO smkNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Anamaet a lamang, no wadi' ta main nin sayay babayi a main nin mapulo' ray kwartan pirak, mi'sa na'met nayay saya, piho nin manulsol yan lampadawan tan mamanis ya ta tikapen nayan maong a na'met nan kwarta angga nin madumog naya. ");
INSERT INTO smkNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ket no nadumog nayayna li', kayaban nasaray uamiga na tan kukabaraybay na tan wana, ‘Rumiriket a saya tan saya kontamo ta nadumog koyaynay na'met kon kwarta ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ket wana et ni Jesus, “Ibarita' koyti komoyo, wantin lamang konran saray uanghil nan Dios a rumiriket sara anamaet no main nin sayay makasalanan a pagbabawian nayna a kukasalanan na.” ");
INSERT INTO smkNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wana et ni Jesus, “Main nin sayay ama a main nin rwa ray a'nak nan lulalaki. ");
INSERT INTO smkNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wanan buridek konan ama na, ‘Tay, ibi mo paynay tao kon syay kanepegan nin tawiren ko.’ Kanya' nin nibi na anaod nin ama a tao nin saya tan saya konran rway a'nak na. ");
INSERT INTO smkNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ket napalabas a umnoy awro, nilako' nan sitin buridek a sarban tao na tan nako ya sa sayay adayo' a lugar. Pinirdi-pirdi nadtaw a kwarta na sa pagkabyay a kasan kabalikasan. ");
INSERT INTO smkNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sin na'pos nayna a kwarta na, nibansag et a nagkamain nin grabin bitil itaw sa lugar nin kami'nan na, ket mangkapaidap yaynan tuloy. ");
INSERT INTO smkNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kanya' nin pinatawo ya konan sayay tagadtaw ket nibaki' yan mangasikaso konran baboy itaw sa pammasturan. ");
INSERT INTO smkNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa bitil naynan tuloy, mataman nin say ipamakan konran baboy ket rabay nayna kumon nin kanen, bale' kasa nin mami kona. ");
INSERT INTO smkNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sin pa'sar naimunawan ya, ket wana sa nakem na, ‘Sarba ran mampatawo kona ni tatay ket subra-subray mangkanen ra. Bale' iti ako a mangkamati ana sa bitil! ");
INSERT INTO smkNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mako akoyna pa nin sumubli' kona ni tatay ta ibarita' ko a nagkasalanan ako konan Dios tan wanin et kona. ");
INSERT INTO smkNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akuen ko kona nin kai akoyna anaod nin kumana' nin tawagen nin anak na, no kai edet, ikwinta nako tanan saya konran mampatawo kona.’ ");
INSERT INTO smkNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sin sain, nibwat ya anaod ana nin sumubli' yadtaw konra. Adayo' ya et a lamang sa bali ra, natamuraw nayayna nin ama na. Nanabo' a inganga'do na kona, kanya' nin nalayo yan sinumna', mi'sa yinakap tan inarkan naya. ");
INSERT INTO smkNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wanan sitin anak konan ama na, ‘Tay, nagkasalanan ako konan Dios tan wanin et komo. Kai akoyna edet nin kumana' nin tawagen et nin anak mo.’ ");
INSERT INTO smkNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bale' kinayaban nasara nin ama a kukatulong na a wana, ‘Madali' kamo. Awiten moyodti a sangkabistawan nin aysing ta isulot moyo kona. Mi'sa singsingan tan sapatusan moya. ");
INSERT INTO smkNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anamaet lamang, keen moya kalapen a pinataba' nin baka ta patyen moya. Mi'sa, magpunsya atamo tan rumiriket atamo ");
INSERT INTO smkNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bana' ta sitin anak ko a man'ipa'ka' kon nati ana ket bilang yan sinmubli' nin mabyay. Sin saytaw, pa'sar nay nabarang, bale' sawanin sinmubli' yaynadti!’ Kanya' nin nitarana' ray piririga tan pagpupunsya ra. ");
INSERT INTO smkNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sin sain, si anak nin kaka ket itaw ya sa gagawa'. Sawanin, sumubli' yayna sa bali ra ket sin adani yayna, narnge' nay tunoy nin piririga. ");
INSERT INTO smkNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kanya' nin kinayaban nayay sayay alila' ra tan tinepetan naya a wana, ‘Ansain? Ani a mampangyadi'?’ ");
INSERT INTO smkNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ket wanan katulong, ‘Sinmubli' yaynay ari mo, kanya' nin nipapati naya ni tatay moyo a pinataba' nin baka bana' kona ta marigsa yan rinmate'.’ ");
INSERT INTO smkNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bana' sa saytaw nin narnge' na, sinmes'ew ya a kaka tan kai na nin rabay a kiriga konra. Kanya' nin, kinuyong naya ni tatay na a lumuob yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ket wanan ni'bat kona ni ama na, ‘Isipen moyoyti, umnoy taon koynan mampagsirbi komoyo, tan kai ako gapo nin sinmubag ni ni'sa sa sarban nigan-gan moyo kongko. Ket mataman ni ni'sa, kai nako binyan ni saya tana nin kanding ta pigaw nin miririga kami nin saray uamigo ko. ");
INSERT INTO smkNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bale' sin rinmate' yayti nin anak moyon namirdi-pirdi nin kayamanan moyo konran bubbayin duka', nipapati moya et taw si pinataba' a baka para kona!’ ");
INSERT INTO smkNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ket wanan ama kona, ‘Anak ko, si'ka, pirmi kan iti sa dani ko, tan sarban ikon ko, ikon mo anaod. ");
INSERT INTO smkNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Talagan manepeg nin miririga tan magpunsya atamo ta siti nin ari mon say pa'sar na ket nati ana, sinmubli' yan mabyay; nabarang ya bale' nakasubli' yan lamang.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ket nibarita' nayti konran tumutumbok na a wana, “Main nin sayay mayaman a main nin ingkargado sa kayamanan na. Ket natandaan na a sitin ingkargado ket mandispalkwen nay kwarta na. ");
INSERT INTO smkNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kanya' nin nipakayaban tan tinepetan nayan mayaman a ingkargado a wana, ‘Ansitin natandaan ko maipa'ka' komo? Kwintawen moynay sarban nitalek kon asikaswen mo ta galten takaynan ingkargado ko.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ket wanan ingkargado sa nakem na, ‘Ani kadi' a gaw'en ko? Galten akoyna, ket ambo' akon magsen nin mangadado tan mading'ey akon kipayabor. ");
INSERT INTO smkNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay! Tanda' koynay gaw'en ko ta pigaw nin taman no maglat akoyna, main nin mangako' kongko sa bali ra.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kanya' nin, kinayaban nasaran sa'sa-sa'sa a main nin utang konan amo na. Wana konan nu'na, ‘Umnoy utang mo konan amo ko?’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Walunyasot a galon nin ladak,’ ni'bat na. Ket wana kona, ‘Sya ey listawan mo. Dali'-dalien mo, tumekre' kadti e tan isurat mon a'pat a yasot.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mi'sa wana konan ikarwa, ‘Si'ka, umnoy utang mo?’ Ni'bat na, ‘Sanribon kaban nin irik.’ Wana kona, ‘Sya ey listawan mo. Isurat mon walunyasot.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ket sin natandaan nan amo nayti say man-gaw'en nan sitin masaor a ingkargado, rinayo naya sa kasiriban na. O' tutuo a mas masirib saray makamundo dyan saray makaDios.” ");
INSERT INTO smkNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nituloy nay nag'irgo ni Jesus a wana, “Ibarita' koyti komoyo, usaren moyoy kayamanan moyodti sa luta' para sa kaabigan ran tutawo ket no rumate' a awro a kasaynan kausaran nin kwarta, maako' kamodtaw li' sa lugar a piikapan anggan-angga. ");
INSERT INTO smkNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Si kapagpyawan sa daite', kapagpyawan ya anamaet sa abaw. Ket si masaor sa daite', masaor ya anamaet sa abaw. ");
INSERT INTO smkNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","O' no kai kamo nin kapagpyawan sa kayamanan iti sa luta', pa'no kamon pyawen sa peteg a kayamanan itaw sa langit? ");
INSERT INTO smkNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wanin anamaet, no kai kamo nin mapyan manga'get nin ikon ran raruma, kai kamo mabyan nin mag'in ikon moyon diri.” ");
INSERT INTO smkNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wana et ni Jesus, “Kai nasara mapagsirbyan nin kusto nin sayay magsisirbi a rway niduman amo na, ta no rwa ray amo na, mas kawa'nanen nayay saya dyan si saya, ket mas tutuo ya konan saya dyan konan saya. Wanin anamaet, kai moyo nin mapirngan a magsirbi konan Dios tan say umagawa kamon maningkap.” ");
INSERT INTO smkNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Narnge' ra a nibarita' na ni Jesus nin saray Pariseo nin itaw, ket tinuya'-tuya' raya bana' ta mablin tuloy konra a kwarta. ");
INSERT INTO smkNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ket wana ni Jesus konra, “Say man'ipa'kit moyo sa tawo ket si mapteg kamo bale' tanda' nan Dios a kanakman moyo. O', si mas maalaga sa tawo, ket makaparmay ya konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","O', say Gugan-gan nin nibi na ni Moises tan say nisurat ran prupita ket man'ipatumbok angga sin ityayna si Juan a Mammawtismo. Anaod sawanin man'ipata-patanda' yay Mabistan Patanda' no pa'non paisirong sa pag'aadi' nan Dios, ket man'ipasuet ray mairanod nin saray abaw a tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wanin man, mampagkuri et a Gugan-gan. Anaod, makasa yapo' a langit tan luta', ba'yo a sayay gurit nin Masanton Kasuratan. ");
INSERT INTO smkNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","O' si sayay lalaki nin isyay nayay asawa na mi'sa ya mangalamo' nin sakalako, konan siin mampamabayi ya. Wanin a lamang, si lalakin mangalamo' konan sayay babayin nisyay nan asawa na, mampagkasalanan yan mampamabayi. ");
INSERT INTO smkNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sayti et: Main nin sayay mayaman nin say seket na ket sangkablyan, tan pirmi yan mamapunsya. ");
INSERT INTO smkNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sa serpan sa pukok na ket main nin nipaida' itaw nin sayay kipayabor a say ngaran na Lazaro. Napno' yan gilgil. ");
INSERT INTO smkNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mampilalo ya tana nin mabyan sa itampal nin natra' sa kinnan nan mayaman. Ket makaluod et sa kapapa'sar na, saray maatap a aso, keen ra dildi-dildilan a gilgil na. ");
INSERT INTO smkNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sayay awro, nati ya si Lazaro ket ni'ras rayadtaw nin uanghil sa dani na ni Abraham. Kaaram, nati ya anamaet a mayaman, ket nitabon ya. ");
INSERT INTO smkNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ket nika' ya sa Hades nin itaw ket mampangirangep yan dya'dya'. Tinmangar ya ket natamuraw nayadtaw sa adayo' si Abraham nin iti ya sa dani na si Lazaro. ");
INSERT INTO smkNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ket nita'way na, ‘Ama Abraham, panginga'do mo. Ibaki' ma pa si Lazaro nin ilbet nayay tamudo' na sa ranom ket turuan nayan maparay'epan a dila' ko ta dya'dya' koynan tuloy iti sa apoy.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bale' ni'bat na ni Abraham, ‘Anak ko, panemtemen mo a leleg mon nabyay itaw sa luta' ket nipapda' ka, bale' si Lazaro ket nangirangep yan dya'dya'. Ket sawanin, syay mampainawnan iti ket si'ka anamaet a mampadya'dyaen, ");
INSERT INTO smkNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","tan ambo' in tamo' ta, main nin sangkaararman tan sangkaalawangan nin bwang sa pisa'lean tamo. Ket saray iti, kai sara makarubari' isen tan sara anamaet a isen, kai sara makarubari' iti.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ket wanan mayaman, ‘No wanin edet, Ama Abraham, ibaki' ma tana pa si Lazaro itaw konra ni tatay ko ");
INSERT INTO smkNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta itaw, main nin lima ray bubsat kon lulalaki ket pau'nawan nasara ta pigaw nin kai sara maika' iti sa pakapadya'dyaan.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ket ni'bat na ni Abraham, ‘Main anaytaw say nisurat na ni Moises tan ran saray prupita; matkap ra tana nin tepren.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ket wanan mayaman, ‘Kai ra nin tepren, Ama Abraham; bale' no main nin sinmubli' nin mabyay nin mako konra, pagbabawian raynay kukasalanan ra.’ ");
INSERT INTO smkNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ni'bat na ni Abraham, ‘No kai ra nin tepren a nipaisurat nan Dios nin niyakay ra ni Moises tan saray prupita, mataman et no main nin saya a sinmubli' nin mabyay, kai saran lamang nin mamper.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wana ni Jesus konran tumutumbok na, “Kai nin mapal'isan nin rumate' a puon nin pagkakasalanan sa byay nin tawo, bale' kauda'dwan a kaugutan nan tawon pangibwatan nin pagkakasalanan nan kapada nan tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas maong et konan sayay tawo a katinan yan mabyat nin bato sa liey tan ibuntok ya sa taaw dyan si mag'in nin syay puon nin pakasida' nin pagmamatalek na kongko nin saya konran sarayti nin maayupa' sa pammemper ra. ");
INSERT INTO smkNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kanya' nin asikaswen moyon maong a man-gaw'en moyo! No wadi' ta main nin kapada mon mammemper nin magkasalanan komo, ima'nwen ma. Ket no magbabawi' ya, pirdunawen ma. ");
INSERT INTO smkNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mataman nin magkasalanan ya komo nin mipito sa sayay awro, no tana ket mipito yan mako komo nin wana, ‘Magbabawi' ako,’ matkap a pirdunawen ma.” ");
INSERT INTO smkNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ket wanran saray apostoles kona ni Jesus nin Uunuren, “Pun'an mo pay pagmamatalek mi!” ");
INSERT INTO smkNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ket wanan ni'bat nin Uunuren, “Mataman no say pagmamatalek moyo ket bilang nin kaalaki sa sangkadaitean a bikoy, magwa' moyon ibarita' konan sitin alakin kayo a dumutdot ya tan mako yadtaw nin paimula sa taaw, ket tumulok ya. ");
INSERT INTO smkNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Anamaet a lamang, no si saya komoyo wadi' ket main nin aripen nan mampangadadon luta' na o mampamastor nin uayep na, ket karate' nan siti nin ibat sa gagawa', ibarita' na kasi kona a dumungo yaynan tampor ta mangan yayna? ");
INSERT INTO smkNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kai! Ana edet, igan-gan nan amo, ‘Misili ka tan manadya' kan pangapunan ko, mi'sa sirbyan nakon mangan tan minom. Ket kayadi' ko nin mangan, mangan kayna.’ ");
INSERT INTO smkNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sawanin, kisalamat ya kasi a amo konan sitin aripen bana' ta ginwa' nay namakian na kona? Kai anaod! ");
INSERT INTO smkNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wanin a lamang anamaet komoyo. Mataman no nagwa' moyoynay sarban nangibakian nan Dios komoyo, matkap a wamoyo, ‘Uaripen kami tamo'. Kai kami matkap nin raywen ta ginwa' mi tamo' a namakian komi.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sa katutuloy ra ni Jesus nin mako sa Jerusalem, iti sara nin dinmalan sa pisa'lean nin prubinsyan Samaria tan Galilea. ");
INSERT INTO smkNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ket sin nakarate' sara sa sayay baryo, sinumna' sara kona a mapulo' ra nin tawo nin main nin liprusi. Tinumgen saran naka'deng sa midyo adayo' ");
INSERT INTO smkNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tan wanran nita'way, “Jesus, Maistro, ka'dwan rakami pa!” ");
INSERT INTO smkNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sin na'kit nasara ni Jesus wana, “Mako kamo paipadar sa pupadi'.” Ket nako saraynaod ana. Ket sin iti sara et a lamang sa dalan, inmanda' sarayna. ");
INSERT INTO smkNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Si saya konra, sin naasikaso na a inmanda' yayna sa masakit na, sinmubli' yan tampor itaw kona ni Jesus tan nita'wa-ta'way nay pangrarayo na konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nanalimukod yan nigna' a rupa na sa luta' sa adapan na ni Jesus nin nikisalamat kona. Anta siti nin lalaki ket ambo' yan Israelita no kai Samaritano ya. ");
INSERT INTO smkNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sawanin, wana ni Jesus kona, “Mapulo' sara katawo a pinaanda' ko. Adti sara edet a syam? ");
INSERT INTO smkNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ani, kasaynan raruman sinmubli' ta pigaw nin raywen nayay Dios no kai kal-la siti si sayay san'ili?” ");
INSERT INTO smkNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sinmunor, wana ni Jesus kona, “Umdeng ka ta mako kayna sa keen mo. Bana' sa pagmamatalek mo, inmanda' kayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sayay awro, main saray Pariseo nin nanepet kona ni Jesus no ka'no nin tumarana' a pag'aadi' nan Dios. Wanan ni'bat konra, “Say itatarana' nin pag'aadi' nan Dios ket kasan sinyalis nin paka'kitan. ");
INSERT INTO smkNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iti ya komoyo nin mampag'adi' ket kai nin ma'kit kanya' nin kasan makapamarita' a ‘Iti ana!’ o ‘Itaw ana!’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sumunor, wana ni Jesus konran tumutumbok na, “Main li' nin panaon a mailiw kamon mag'uray akoynadti, si'kon si Pinaitawo, bale' kai nin magwa' in. ");
INSERT INTO smkNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anaod, main li' nin mangibarita' komoyo a wanra, ‘Iti ya!’ o ‘Itaw ya!’, bale' andi' kamo nin sumunor konra. ");
INSERT INTO smkNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wanin ta, say irarate' ko nin si'kon si Pinaitawo ket mapatna-patnag a kapaday kimat nin bigra' nin kumidlap nin mamalaway sa intiron kalangitan. ");
INSERT INTO smkNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Anta, matkap a dumalan ako yapo' sa pangingirangep nin abaw a pammadya'dya' tan kai rako nin alilbien nin saray tutawo konan sitin panaon. ");
INSERT INTO smkNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sa panaon nin isusubli' kodti sa luta' nin si'kon si Pinaitawo, say kapapa'sar ran tutawo ket kapada konran tutawo sin panaon na ni Noe. ");
INSERT INTO smkNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sin saytaw, nagkabyay saran bilang kasan rumate' nin pakadusa ket mangan sara, minom tan sumrep sara sa istado angga sin mismon awron linmuob sara si Noe sa alakin baluto. Ket sin lanip ana, nati saray sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wanin lamang anamaet a nangyadi' sin panaon na ni Lot. Ukupado saray tutawo nin mangan, minom, magkumirsyo, mangmula tan mama'deng nin bali. ");
INSERT INTO smkNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bale' sin awron linmakwan ya si Lot sa syudad nin Sodoma, pinarapeg naya nin Dios nin apoy tan asupri kanya' nin napuuran saray sarba nga'min itaw. ");
INSERT INTO smkNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wanin anamaet li' a lamang a mangyadi' sa awron isusubli' ko nin si'kon si Pinaitawo nin paipadar akoyna. ");
INSERT INTO smkNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Konan sitaw li' nin panaon, si si'numan nin itaw sa balkon nin bali na, andi' yayna nin lumuob ta pigaw nin kalapen nay main nadtaw. Wanin anamaet konan si itaw nin mampagtrabaho sa gagawa', andi' yayna nin sumubli' et sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Panemtemen moyo a nangyadi' konan asawa na ni Lot. ");
INSERT INTO smkNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Si si'numan a say byay nadti tana a kawa'nanen na ket mati ya li' et a lamang, bale' si tawo nin gurutan nay byay nadti, tumuloy yan mabyay nin iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ibarita' koyti komoyo, no wadi' ta yabi li' a isusubli' kodti sa luta', konran rwa ray tawon mampa'lek sa sayay idaan, si saya, makalap ya ket si saya, mabati' ya. ");
INSERT INTO smkNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Konran rwa ray bubbayin mampangiling, si saya, makalap ya ket si saya, mabati' ya.” ");
INSERT INTO smkNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sin sain, tinmepet saray tumutumbok na ni Jesus kona, “Catawan, adti li' ti nin mangyadi'?” Wanan ni'bat ni Jesus, “No adti main nin maangot ran laman ran nati, itaw sara nin mididinep a mumanuk-manok a mangan nin laman ran nati.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sayay awro, niyakay nasaraynaet ni Jesus a tumutumbok na yupa' sa sayay pangingiyarig a matkap nin pirmi saran dumasal konan Dios tan andi' ra nin sawaan ti nin gaw'en. ");
INSERT INTO smkNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wana, “Sa sayay babali, main nin sayay hwis a kai ya nin mali'mo konan Dios tan kai ya nin mangasikaso konran kapada nan tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Main anamaet itaw nin sayay babayin balo nin pirmin mako kona ta patulong ya maipa'ka' sa kaso na konan kakuntra na. ");
INSERT INTO smkNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Na'teng yapo' a kai naya nin man'asikaswen nin sitin hwis ket sin susuyot anan lamang wana sa nakem na, ‘Mataman nin kai koya nin ikali'mo a Dios tan kai ako nin mangasikaso konran tutawo, ");
INSERT INTO smkNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tulungan koya paynaytin babayin balo sa kaso na ta pirmi nako tanan man'isturbwen. Bangli' no mapasnep nakoyna bana' sa pako nadtin pirmi kongko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ket wana ni Jesus nin Uunuren konran tumutumbok na, “Adalen moyo in say nibarita' nan si luko nin hwis. ");
INSERT INTO smkNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Edet, no wanin a nag'in disisyon na, si Dios et wadi' a kai nin tumulong konran tutawon pinili' na a sa awro tan yabi ket man'umay'ay sara kona? Maong ya ket peteg nin tutuo a kai na nin eteng-etengen a panunulong na konra. ");
INSERT INTO smkNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibarita' koyti komoyo, ibi na nin tampor nin Dios a manepeg para konra. Anamaet bale', saytaw li' no si'kon si Pinaitawo ket sumubli' akodti sa luta', main et li' palayin marate' kon tutawon mampagmatalek kongko?” ");
INSERT INTO smkNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nag'irgo ya anamanaet si Jesus yupa' sa sayay pangingiyarig konran saray mampangipa'ka' sa lalaman ran diri a matunong saran tutawo bale' mangmuda-muda saran kapada ran tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wana ni Jesus konra, “Main nin rwa ran katawo a linmuob sa sakop nan Timplo ta pigaw nin dumasal sara. Si saya, Pariseo ya ket si saya anamaet, maniningir yan buis. ");
INSERT INTO smkNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Si Pariseo, naka'deng yan pinaipurok nin dinmasal nin sititinek a wana, ‘Kisalamat ako komo, o Dios, ta ambo' akon bilang konran raruman tutawo a maagom sara, ambo' saran mapteg, tan mamabayi sara, tan laloyna a ambo' akon bilang konan siin si maniningir nin buis. ");
INSERT INTO smkNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mampagkulasyon ako nin mirwa sa manglinggo tan man'ibi ko et komo a kakapulo' nin sarban mangkatingkapan ko.’ ");
INSERT INTO smkNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Si maniningir nin buis anamaet, itaw yan man'umdeng sa midyo adayo' nin kai na tana gapo nin maitangar a rupa na sa langit tan mangkabug-kabugen nayay kerep na sa pagbababawi' na tan mandumasal ya a wana, ‘O Dios, ka'dwan nako ta saya akon makasalanan.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ket wana et ni Jesus, “Ibarita' koyti komoyo, sitaw si maniningir nin buis a napirduna. Kanya' nin sinmubli' ya sa bali ra nin nikwintan kai nagkasalanan. Si Pariseo bale' kai ya nin pinirduna. Sawanin, si si'numan a mangita'gay nin lalaman nan diri, maikayupa' ya li', bale' si mipaayupa', maita'gay ya li'.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sawanin, main saray tutawon ni'ras rasara pati saray abing kona ni Jesus, ta pigaw nin ipababo nay gamet na konra nin bindisyunan nasara. Bale' sin na'kit raytin tumutumbok na ni Jesus, inima'no rasaray tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bale' pinakadani nasara ni Jesus a ua'nak kona tan wana konran tumutumbok na, “Pauryan moyo saray ua'nak nin umarak kongko. Andi' moyo sara nin ima'nwen ta si tawon say kanakman na ket kapada nin konran saraytin ua'nak, aburuyan nayan Dios nin kipag'adi' kona. ");
INSERT INTO smkNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","O', ibarita' koyti komoyo, si si'numan a kai nin mipaayupa' nin paisirong sa pag'uuray nan Dios nin bilang sa pangangaburoy nan sayay anak, kai ya gapo nin makakirama' sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sawanin, main nin sayay lalaki a saya ya konran pupangulo ran Judio. Tinepetan naya si Jesus a wana, “Maistro, maong ka. Ket ani a manepeg nin gaw'en ko ta pigaw nin maga'muran koy anggan-angga nin byay a iti konan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wanan ni'bat ni Jesus kona, “Ambale' a sabtan nako nin maong? Kasa gapo nin raruma no kai si Dios tamo' a maong. ");
INSERT INTO smkNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tanda' moynamaet a Gugan-gan: Andi' ka nin mamabayi o kilalaki. Andi' ka nin mangmati. Andi' ka nin manakaw. Andi' ka nin magtistigos nin ambo' nin tutuo. Igalang mosara si ama tan si ina mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ket wanan lalaki, “Sarban sain ket mantukiden koyna nangibwat et sin anak ako.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sin narnge' na in ni Jesus, wana kona, “Main et nin sayay matkap mon gaw'en. Ilako' mo nga'min a kamamain mo ket say naglakuan, ibi mo konran pubri ket magkamain kan kayamanan itaw sa langit. Kayadi' mo in nin gaw'en, sumubli' kadti kongko tan mag'in kan tumutumbok ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ket sin narnge' na in nin lalaki, ginmereng ya bana' ta sabtan nin yaman na. ");
INSERT INTO smkNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sin na'kit na ni Jesus a pinasyan bereng na, wana, “Ay, maidap nin tuloy a ipaisirong ran mumayaman a lalaman ran diri sa pag'uuray nan Dios! ");
INSERT INTO smkNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Anaod, mas mainum'ay ya et nin lumbot a kamilyo sa ubot nin kadayem dyan si sayay mayaman ket makakibiang ya sa pag'aadi' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Saray nakarnge' sa sain a wana ni Jesus wanra, “Ya! Si'no edet no wanin a maisalba?” ");
INSERT INTO smkNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wana ni Jesus, “Say kai nin magwa' sa tawo, magwa' konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ket wana ni Pedro, “Ket si'kami pa edet? Pinauryan mi anay pammali mi ta pigaw nin nikikalamo' kami komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wana ni Jesus konra, “O' a, ibarita' koyti komoyo, si si'numan a manglakwan nin pammali na o mangatua na o asawa na o bubsat na o ua'nak na bana' sa pag'aadi' nan Dios, ");
INSERT INTO smkNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tubaleen naya sa sawanin ana nin byay nin mas abaw et dyan saytaw say linakwanan na tan maga'muran na et li' a anggan-angga nin byay a iti konan Dios sa adapen nin panaon.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sawanin, pinaipurok nasara ni Jesus a labinrwan tumutumbok na mi'sa wana konra, “Mangrenge' kamo. Adap tamoyna sawanin sa Jerusalem. Ket itaw, matukid ana a sarban nisurat ran prupita nan Dios maipa'ka' kongko a si'kon si Pinaitawo. ");
INSERT INTO smkNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ipagamet rako konran ambo' nin Judio ket tuya'-tuyaen, kaka'lisan tan luda'-ludaan rako. ");
INSERT INTO smkNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mi'sa, sanet-saneten rako ba'yo rako nin patyen, bale' marate' a ikatlon awro, pasublien nakon mabyay nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bale' kai ra nin natarusan nin saray labinrwa a rabay nan ibarita' ni Jesus, bana' ta say kabalikasan, naiyadi sa pakataros ra. ");
INSERT INTO smkNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dandani sarayna nin makarate' si Jesus sa babali nin Jerico ket main nin sayay lalakin bulag a nakatekre' sa rigrig nin dalan ta mangkipayabor yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sin narnge' nay gargar ran abaw nin tutawon manlumabas, tinepet na, “Ani a mampangyadi'?” ");
INSERT INTO smkNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wanran tutawo kona, “Manlumabas sara si Jesus a taga Nazaret.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kanya' nin tinma'way ya a wana, “Jesus a puri na ni Adi' David, ka'dwan nako kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ket saray tutawodtaw sa u'na na ni Jesus, inima'no rayan gumargar bale', mas nipaksaw nayna edet nin nita'way, “Si'kan nipangako' a puri na ni Adi' David,” wana, “ka'dwan nako kadi'!” ");
INSERT INTO smkNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kanya' nin tinumgen ya si Jesus tan nigan-gan nan ikadani raya kona a lalakin bulag. Sin itaw yayna sa dani na, tinepet na ni Jesus kona, ");
INSERT INTO smkNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ani a rabay mon gaw'en ko para komo?” “Uunuren ko,” wana, “rabay ko kumon a maka'kit akon uman!” ");
INSERT INTO smkNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kanya' nin wana ni Jesus kona, “Maka'kit kayna. Bana' sa pagmamatalek mo, inmanda' kayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ket tampor, maka'kit yayna tan nikikalamo' ya konra ni Jesus, nin manraywe-raywen nayay Dios. Sarba ra nin tutawodtaw nin nakaimaton sa nipamaanda' na ni Jesus kona rinayo raya anamaet a Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nirate' sarayna si Jesus sa Jerico, ket itaw sara nin lumabas sa pako ra sa keen ra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Main itaw nin sayay lalakin say ngaran na ket Zaqueo. Saya yan pangulo ran saray maniningir nin buis tan mayaman ya. ");
INSERT INTO smkNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mapilit yan ma'kit naya si Jesus, bale' sa ka'bawan ran tawo ket, kai naya nin ma'kit bana' ta beyew ya si Zaqueo. ");
INSERT INTO smkNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanya' nin say ginwa' na, nalayo yan inu'nawan nasaray tutawo mi'sa ya nuli' sa sayay puon nin kayon mantawagen nin sikamoro, ta pigaw nin ma'kit nayan peteg si Jesus ta lumabas yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sin naipatben yaynaod si Jesus itaw sa kami'nan na ni Zaqueo, tinmangar ya ket wana, “Zaqueo, apurawen mo, manaoy kadsen! Anaod, matkap nin itaw ako nin kipagtuloy sa bali moyo!” ");
INSERT INTO smkNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Inapura naynaod ni Zaqueo a nanaoy tan maririket nayan inako' si Jesus itaw sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sara bale' a tutawodtaw nin nakaimaton, bere-bere sara a wanra, “Sukat nin kipagtuloy ya sa bali nan sayay makasalanan!” ");
INSERT INTO smkNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ket inumdeng ya si Zaqueo tan wana kona ni Jesus, “Uunuren, wanti e: Say kapiknga' nin kayamanan ko ket ibi ko konran pubri, tan isubli' koynamaet nin mi'pat nin ka'baw konran sinaur-saor ko a sinaor ko konra.” ");
INSERT INTO smkNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ket wana ni Jesus kona, “Konan sitin awro, si'ka tan saray pamilya mo ket naisalba kamo ta saya ka anamaet nin nag'in nin peteg a puri na ni Abraham bana' sa pammemper mo. ");
INSERT INTO smkNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anaod, si'kon si Pinaitawo ket nako akodti sa babon luta', ta pigaw nin tikapen tan isalba kosaray tutawon adayo' konan Dios” ");
INSERT INTO smkNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sawanin, leleg ran mampangrenge' nin tutawo sa man'ibarita' na ni Jesus, nituluy-tuloy nay nangyakay yupa' sa sayay pangingiyarig. Wanin a ginwa' na bana' ta adani sarayna sa syudad nin itaw sara nin nag'adi' a uadi' sin saytaw, tan ta pigaw nin ikusto na a man'ipa'ka' ran tutawo a tumarana' ana a pag'aadi' nan Dios no rumate' yadtaw. ");
INSERT INTO smkNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ket wana ni Jesus konra, “Main nin sayay lalakin ata'gay a nikatawo na nin mako sa sayay adayo' nin lugar ta itaw ya suyuen nin adi', ket mayadi' sumubli' ya li' nin mag'uray sa nasyon nan diri. ");
INSERT INTO smkNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sin adapen na a mibwat, kinayaban nasaray mapulo' a kukatulungan na ta pigaw nin batian nasara nin sa'san plata nin balitok tan wanan nibibilin konra, ‘Leleg a kasa ako, ikumirsyo moyo in.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bale' saray lumugar itaw sa pag'urayan na li', gura' raya kanya' nin sin nakaibwat yayna, namasunor saran mako nin mangibarita' konan si manuyo' a kai ra nin rabay a syay mag'adi' konra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wanin man, sinuyo' ya et a lamang nin mag'adi' ket sinmubli' yayna sa nasyon na. Ket nipakayaban nasaray sarban katulungan na nin binatian nan kwarta ta tepetan nasara no umnoy naganansya ra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wanan si u'nan nako kona, ‘Sinyor Adi', si kwarta moyo ket nakaganansya yan mipulo' nin ka'baw.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Mabistay ginwa' mo!’ wanan adi'. ‘Manakem kan katulungan! Bana' ta kapagpyawan ka sa taman nin daite' tamo', gaw'en katan pangulo sa mapulo' nin syudad.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wana anamaet nin ikarwan nako kona, ‘Sinyor Adi', si kwarta moyo ket nakaganansya yan milima nin ka'baw.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ket wana anamaet nin adi' kona, ‘Si'ka anamaet, gaw'en katan mangipangulo sa lima nin syudad.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ket main anaet nin sayay nako kona a wana ‘Sinyor Adi', sya ey kwarta moyo nin pinunggos koyan panyo' tan niyator koya, ");
INSERT INTO smkNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ta linmi'mo ako komoyo bana' ta tanda' kon istrikto kamo. Maningkap kamo sa ambo' nin si'kamoy nangator tan yataben moyoy ambo' nin si'kamoy nangmula.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ket inumbat yay adi' a wana, ‘Duka' kan katulungan! Kanya' nin dusawen kata sa sain nin dirin irgo mo. Tanda' mo anamain nin istrikto ako tan maningkap ako nin say ambo' nin si'koy nangator tan yataben koy ambo' nin si'koy nangmula. ");
INSERT INTO smkNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mayin edet a kai ma nin nikwa sa bangko a kwarta ko ta pigaw kumon nin no rumate' ako ket makalap ko pati ganansya na?’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sawanin, wanan adi' konran saray raruman tutawodtaw, ‘Sigi, kalapen moyo a kwartan nibati' ko kona ta ibi moyo konan si nakaganansya nin mipulo' nin ka'baw.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ket wanran tutawo kona, ‘Sinyor Adi', mapulo' rayna bale' a platan balitok nin ikon na.’ ");
INSERT INTO smkNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ket wana anamaet nin adi', ‘Ibarita' koyti komoyo, si si'numan a main kona a sayay bagay, malamu'nan ya nin umabaw yaynan umabaw. Bale' mataman nin si daite' nin main kona, maglat et li' konan si si'numan a kai nin mangusar sa naipya kona. ");
INSERT INTO smkNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sawanin, sara anamaet a kuntra kongko nin kai marabay nin mag'adi' ako konra, i'ras moyo saradti ta patyen sara sa adapan ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kayadi' na nin nibarita' in ni Jesus, nituloy raynay tinmangkar nin mako sa Jerusalem a iti ya sa u'na si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sin nakarate' sarayna si Jesus itaw sa banda ran baryon Betfage tan Betania nin iti sa rigrig nan Talugtog Olibo, pinau'na nasaray rwa konran tumutumbok na nin ");
INSERT INTO smkNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wana, “Mako kamo sa baryo a man'adapen moyo. Ket karate' moyodtaw, main tampor nin ma'kit moyon nipuged a sayay uybon nin asno a kasa et gapo nin rinmuran kona. Usbagen moya sa nakaipugedan na tan i'ras moyadti. ");
INSERT INTO smkNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No main nin manita komoyo no mayin nin man'usbagen moya, basta ibarita' moyo, ‘Matkap nayayti nin Uunuren.’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sin sain, nako saraynadtaw a rway tumutumbok na. Tutuon page' a nadumog rayaytaw si nibarita' na ni Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sin man'usbagen rayayna sa nakaipugedan na, sinita nasaran main nin ikon a wana, “Mayin nin man'usbagen moya in?” ");
INSERT INTO smkNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wanran ni'bat, “Matkap nayayti nin Uunuren.” ");
INSERT INTO smkNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ket ni'ras rayaynay uybon kona ni Jesus tan sinapinan rayan kapa ra ba'yo raya pinaruran si Jesus kona. ");
INSERT INTO smkNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Leleg nin manruranan naya ni Jesus, niyapra-aprak ran tutawo a kukapa ra sa dalanan na. ");
INSERT INTO smkNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sin adani sarayna si Jesus sa Jerusalem ta iti sarayna sa dalan nin lumusong sa Talugtog Olibo, itaw saraynay ka'bawan ran tumutumbok na nin sabtan ririket ra tan man'ita'wa-ta'way ray pangrarayo ra konan Dios bana' sa sarban milagro a ginwa-ginwa' na nin na'kit ra. ");
INSERT INTO smkNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wanra, “Binindisyunan nayan Dios a Adi' nin nibaki' na nin manrumate' anadti sawanin kontamo! Makakituno sarayna kumon a tutawo konan Dios nin itaw sa langit! Itandudo' yay ngaran nan Dios a itaw sa langit!” ");
INSERT INTO smkNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Main anamaet nin Pariseo nin nayi konran saray abaw nin tutawo tan wanra kona ni Jesus sin sain, “Maistro, pisasaeten mosara in pa saray tumutumbok mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ket wanan ni'bat ni Jesus konra, “Ibarita' koyti komoyo, no kai ra nin ibusngaw in say pangrarayo ra, pihon saytin diri say bubatodti sa dalan a tuma'way nin mangrayo kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sin adani sarayna si Jesus sa Jerusalem nin matamuraw nayayna a syudad, bana' sa pangungundo' na ket niyakis na. ");
INSERT INTO smkNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wana “Abagay kamoyna, si'kamon taga Jerusalem! No tanda' moyo tamo' kumon sawanin no ani a matkap ta pigaw nin makakituno kamoyna konan Dios; bale' angga anaod nin sawanin ket kai moyo et nin maalilbi'! ");
INSERT INTO smkNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Anaod, kauda'dwan kamo li' no rumate' a awro nin saray kukalaban moyo ket bungtu-bungtunen ra a luta' tan bubato sa libed nan syudad ta pigaw nin makaluob sara. Ket kubkuben rakamo, ta pigaw nin kai kamoyna nin makaliwa'. ");
INSERT INTO smkNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sidaen raya nin liso a syudad moyo tan patye-patyen rakamo. Kasa li' ni saya nin baton matra' nin naita'len sa saya. Mangyadi' a wanin bana' ta inandian moyo a pagkanawanawa sin nako yadti a Dios ta pigaw nin isalba nakamo kumon.” ");
INSERT INTO smkNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sin nakarate' saraynadtaw si Jesus sa Jerusalem, sinumrep ya sa sakop nan Timplo nan Dios bale' itaw narat'anan nasaray mampaglako', ket pinala-palakwan nasara. ");
INSERT INTO smkNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wana konra, “Kai para a naisurat a wana nin Dios, ‘Si Bali ko, lugar yaytin dadasalan,’ bale' si'kamo, ginwa' moyan pididinepan ran mannakaw!” ");
INSERT INTO smkNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ket nangibwat sin sain, inawru-awro yaynan nangyakay si Jesus itaw sa sakop nan Timplo. Ket saray Pupangulon Pupadi', Madudunong sa Gugan-gan tan saray pupangulo ran tutawo, man'irimidyo ray pammapati kona. ");
INSERT INTO smkNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bale' kai ra et nin magwa' in bana' ta matetek saran manrumnge' nga'min a tutawo kona. ");
INSERT INTO smkNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sayay awro, sin kapresan nay mampangyakay ni Jesus konran tutawodtaw sa luob nin sakop nan Timplo tan man'ipatanda' nay Mabistan Patanda', kinmadani sara kona a Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan a kalamo' rasaray Mangatuntawo ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tinepet ra kona, “Ibarita' mo pa komi no ani a kanepegan mon mangwa' nin sain say man-gaw'en mo. Si'noy nami komo nin pakayadi' nin gaw'en mo in?” ");
INSERT INTO smkNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ni'bat na ni Jesus, “Main anamaet nin itepet ko komoyo. Ibarita' moyo pa kongko, ");
INSERT INTO smkNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","si'noy namin kanepegan nan mamawtismo ni Juan, si Dios para o say tawo?” ");
INSERT INTO smkNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Niiirgo sara yapo' sa saya tan saya a wanra, “Ani kadi' a i'bat tamo? No ibarita' tamon ‘si Dios,’ ibarita' na kontamo, ‘Mayin edet a kai moya nin timper si Juan?’ ");
INSERT INTO smkNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ket no ibarita' tamo anamaet, ‘Say tawo,’ pihon kudas-kudasen ratamo anggan mati atamo nin sarain a tutawo bana' ta mamper sara a si Juan ket saya yan prupita.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanya' nin ni'bat ra tana kona ni Jesus, “Kai mi nin tanda'.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ket wana ni Jesus konra, “Kai ko anamaet nin ibarita' komoyo no ani a kanepegan kon mangwa' nin say man-gaw'en ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ket kinairgo nasara anamanaet a tutawo ni Jesus yupa' sa sayay pangingiyarig. Wana, “Main nin sayay tawon nangmula nin ubas sa luta' na mi'sa nipagamet nay pangangalila' konran umno ray padalos tan nibwat yan nako sa sayay adayo' a lugar ket itaw yan umnoy taon. ");
INSERT INTO smkNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sin narate' anay panaon nin pammutin bunga, nangibaki' yan sayay tawo na itaw konran padalos nin kalapen nay tao na. Bale' saray padalos, tinasu-taso raya tan pinasubli' rayan kal-la gamet. ");
INSERT INTO smkNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sin wanin, nangibaki' ya anaet nin sakalako ket binugbu-bugbog rayan lamang tan pinadi-pading'eyan raya et tan pinalakwan rayan kal-la gamet. ");
INSERT INTO smkNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sawanin, nangibaki' ya et nin ikatlo, ket sinugat-sugat rayayti mi'sa ginuruy-guroy rayan niliwa'. ");
INSERT INTO smkNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bana' ta wanin, wana nin main ikon nin kaubasan, ‘Ani bale' a gaw'en ko? Wanti e: Si anak ko nin kawa'nan ko a ibaki' ko. Siguradon kabilangan raya,’ wana. ");
INSERT INTO smkNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ket sin na'kit rayan saray padalos a anak na niiirgo sara nin wanra, ‘Siti li' a manawir. Patyen tamoya ta pigaw nin maikon tamo a tawiren na li'!’ ");
INSERT INTO smkNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ket nirikor rayadtaw sa kaubasan tan pinati raya. Sawanin,” wanan nituloy ni Jesus, “ani kadi' a gaw'en nan sitin main nin ikon nin kaubasan konran saray padalos? ");
INSERT INTO smkNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kasan sapo nin mako yadtaw ket patye-patyen nasara. Mi'sa ipaga'getan nayayna a kaubasan na sa raruma.” Sin narnge' ra in nin saray tutawo, wanra, “Andi' na tana kumon nin aburuyan nin Dios a mangyadi' in!” ");
INSERT INTO smkNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ket pinastang nasara ba'yo nasara tinepetan ni Jesus, “No wanin, ani edet a rabay nan ibarita' nin sitin wanadtaw sa Masanton Kasuratan, ‘Sitaw si bato a nibilang ran kai nin mausar nin saray mammanday, sitaw nin diri nin bato a nag'in nin sangkaimpurtantiwan sa pamma'deng.’ ");
INSERT INTO smkNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Konan siin nin bato, si si'numan nin manabo', mangababari' ya tan si si'numan a madag'anan nan siin a bato, marekrek ya.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ket nataros ran saray Madudunong sa Gugan-gan tan saray Pupangulon Pupadi' a nipuntirya ya konra a nibarita' na ni Jesus. Kanya' nin rabay rayayna kumon nin ipadakep nin tampor si Jesus bale' mali'mo sara konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ket tinma'gan sara sa pagkanawanawa ran maipadakep ya si Jesus. Nangupa' saran umno ran lulalaki ta pigaw nin keen raya nin tepetan si Jesus tan magwadi'-wadi' saran matunong saran tutawo nin mantumulok sa gugan-gan nan Dios. Bale' say katutu'wan ket rabay rayan makal'ot si Jesus sa pag'iirgo na, ta pigaw nin maipagamet raya konan gubirnador, a sya a main nin pakayadi' nin manintinsya. ");
INSERT INTO smkNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sin itaw sarayna, tinepetan rayaynaod si Jesus a wanra, “Maistro, tanda' mi a kai ka gapo nin mamili' nin tutawo tan say man'ibarita' tan man'iyakay mo ket kusto. Say pangangakay mo anamaet nin no ani a rabay nan Dios nin gaw'en ran tutawo ket tutuo. ");
INSERT INTO smkNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ket, rabay miyaytin tepeten komo: Maitukoy para, o kai, sa Gugan-gan tamo no mamayad atamon buis konan Impirador nan Roma?” ");
INSERT INTO smkNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bale' nadlaw na ni Jesus nin duka' a gagara ra kanya' nin wana konra, ");
INSERT INTO smkNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mangipa'kit kamo pa kongko nin kwartan plata.” Sin nakailiwa' saraynan plata, wana ni Jesus konra, “Si'no ya in rupa tan ngaran si isen konan plata?” “Si Impirador nan Roma,” ni'bat ra. ");
INSERT INTO smkNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sawanin, wana ni Jesus konra, “No wanin edet, isubli' moyo konan Impirador a ikon na, tan isubli' moyo anamaet konan Dios a ikon na.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ket kasan maibarita' ra ta angga tanan naka'ngap sara sa wantin ni'bat na ni Jesus. Kasan naipakasalanan ra kona mangibwat sa ni'bat na sa adapan ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Main anamaet nin umno ray Saduseo nin nako kona ni Jesus ta tepetan raya. Sarayti saray Saduseo kai ra nin tepren a mapasubli' sara li' nin mabyay a nunati ana. ");
INSERT INTO smkNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wanra kona, “Maistro, nisurat na ni Moises sa Gugan-gan tamo a no main nin mitraasawa ket nati yay lalaki nin kasan anak ra, manepeg a si busat na nin lalaki ket ikasal nayay babayi ta pigaw nin manganak sara nin ikwintan anak nan sitaw si nati.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nituloy ran Saduseo a wanra, “Ket, main intaw nin pito ray mibubsat a lulalaki. Nangasawa yay kaka bale' nati ya nin kasan anak. ");
INSERT INTO smkNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kanya' nin si aryen na nikasal nayay babayi ket nati ya anamaet nin kasan anak ra. ");
INSERT INTO smkNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sinmunor, nikasal naya anamanaet nin si ikatlo anggan saray piton mibubsat a lulalaki ket nag'in asawa rayay babayi ket pari-pariho saran nati nin kasan anak ra. ");
INSERT INTO smkNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kalansuyutan, nati ya anamaet ana a babayi. ");
INSERT INTO smkNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ket sawanin, no napasubli' sarayna li' nin mabyay a nunati, si'no edet li' a main nin asawa kona ey, ta saray pito nag'in nin asawa raya?” ");
INSERT INTO smkNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wana ni Jesus konra, “Konan sitin byay iti sa luta', saray tutawo, sumrep sara sa istado. ");
INSERT INTO smkNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bale' no pinasubli' sarayna li' nin mabyay a lulalaki tan bubbayi nin ikwinta nan Dios nin kumana' nin ipaisirong sa pag'aadi' nadtaw sa langit, ambo' saraynan iti sa kapapa'sar nin iti sa istado. ");
INSERT INTO smkNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anaod, kai sarayna nin mati no kai edet, mabyay saraynan kapada rasaran uanghil. Ua'nak nasarayna nin Dios a pinasubli' nan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sawanin, say maipa'ka' sa katutu'wan anamaet sa pammasubli' nin mabyay konran nunati, mataman si Moises ket pinatutu'wan nan maong a saray nunati, mapasubli' saran mabyay sin nisurat na a maipa'ka' sa wanan Dios kona sa mandumtan kayo. Ket nibarita' nadtaw kona ni Moises a sya et a lamang a Dios na ni Abraham, si Dios na ni Isaac tan si Dios na ni Jacob mataman no nati sarayna sin saytaw. ");
INSERT INTO smkNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Syimpri a, si sayay nati ana, kai yayna nin makapangrayo konan Dios. Edet, mangkabyay sara in et saray nibarita' nan Dios a syay Dios ra. Kibyay sarayna nga'min kona.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sin sain, wanran saray umno ran Madudunong sa Gugan-gan, “Maistro, mabista in say ubat mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kayadi' sayti, kasayna gapo nin nakatpel nin nanepet-tepet et kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sin sain, tinepetan nasara anamaet ni Jesus, “Mayin kadi' a wanran tutawo ket si syay Cristo a nipangako' ket mangibwat ya kano sa puri na ni Adi' David? ");
INSERT INTO smkNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Anta mismon si Adi' David ket nisurat nadtaw sa parti nan Libro nin Kukanta sa Masanton Kasuratan a, ‘Wanan Dios konan Uunuren ko: Tumekre' kadti e sa pawanan ko ");
INSERT INTO smkNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mintras nin mampasukuen kosara komo a sarba ran kukalaban mo.’ ");
INSERT INTO smkNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sawanin,” wana et ni Jesus, “no si Adi' David a mismo ket tinawag naya nin Uunuren a Cristo nin nipangako' kona, edet, si Cristo ket ambo' yan basta puri na tamo' ni Adi' David!” ");
INSERT INTO smkNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Leleg nin mampangrenge' saray sarban tutawo kona ni Jesus, wana konran saray tumutumbok na, ");
INSERT INTO smkNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pakanda' kamo nin kai kamo mag'in nin bilang konran saray Madudunong sa Gugan-gan a rabay-rabay ray magpasyar nin anununro a aysing ra tan say pagalangan rasaran tutawo sa publiko. Rabay-rabay ray tumekre' sa tekrean para konran impurtantin tutawo sa sinaguga. Wanin et a lamang no mako sara sa punsya. ");
INSERT INTO smkNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kai sara nin mading'ey nin sauren rasaray bubbayin balo maipa'ka' sa sarban kamamain ra, ket ta pigaw nin sa wanran tutawo ket mapteg sara, paanunrwen ray dasal ra. Anaod, pinasyan byat li' nin dusa nan Dios konra.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Leleg nin itaw ya si Jesus sa Timplo, linmingap-lingap ya ket na'kit nasaray mumayaman nin mampangnabo' nin da'ton radtaw sa pangnanabuan nin kwarta. ");
INSERT INTO smkNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ket sin sain, naasikaso nayay sayay pubrin babayin balo nin nanginabo' nin rwa ray plata nin sangkadaitean a alaga. ");
INSERT INTO smkNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wana ni Jesus konran tumutumbok na, “Ibarita' koyti komoyo, sitin pubrin babayin balo, mas abaw a ninabo' na dyan say sarban ninabo' ra nin saray raruma ");
INSERT INTO smkNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ta say subra-subra tamo' konra a nibi ran da'ton ra. Si balo bale', sa busel nin kaidapan na, nibi nay kapagkapag a main na.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Main nin umno ray tumutumbok na ni Jesus a mampag'iirgo maipa'ka' sa anda' na nin Timplo, bana' sa nikagwa' na sa mabistan bubato tan naarkusan yan mabibistan bubagay a nida'ton para konan Dios. Bale' wana ni Jesus konra, ");
INSERT INTO smkNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Main li' nin awro nin sarban sayti nin pa'deng a mangka'kit moyo ket mayba', ket kasayna li' gapo ni sayay bato nin isen a ma'kit nin naita'len et konan saya et.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tinepetan raya si Jesus nin tumutumbok na, “Maistro, ka'no nin mangyadi' in si wamoyon yubaen ya a Timplo? Ani li' a pakatandaan no dandani anayti nin mangyadi'?” ");
INSERT INTO smkNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ket wanan ni'bat konra, “Pakatalad kamo a kai kamo nin malingon tepren moyoy bula' ta abaw sara li' a mangusar nin titulo ko a wanra ket sara a Cristo nin nipangako' nan Dios, tan ibarita' ra et a mantumarana' anay pag'aadi' na bale' andi' kamo nin mamper konra. ");
INSERT INTO smkNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No marnge' moyo a main nin pigigira tan pigugulo, andi' kamo nin sumalak ta saytin bubagay ket matkap nin mangyadi' yapo'. Bale' ambo' et nin iyayangga ana nin kapresan a pag'uuray iti sa mundo. ");
INSERT INTO smkNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Milalaban li' sa saya tan saya a nunasyon tan wanin a lamang sa pupag'adian. ");
INSERT INTO smkNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Magkamain li' nin maksaw nin rayon, bitil tan sarot sa abaw a lulugar. Magkamain et li' nin makapali'mo tan makapaka'ngap nin bubagay a ma'kit sa kalangitan. ");
INSERT INTO smkNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bale' ba'yo li' nin mangyadi' a sarban sayti, dakpen tan padya'dyaen rakamo. I'ras rakamo li' konran pupangulon rilihyon ta pigaw nin usisaen mi'sa ipapriso, tan iyadap rakamo et li' konran mampag'uray tan konran uadi' bana' ta tumutumbok katamo. ");
INSERT INTO smkNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ket pagkanawanawa moyoynayti nin maiparate' konra a maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kanya' nin ipasaya moyoy kanakman moyo nin andi' moyo nin kapagawan no pa'no moyo li' nin idipinsa a lalaman moyon diri, ");
INSERT INTO smkNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ta byan katamo li' nin pakababa' nin mag'irgon main nin kadunungan a kai ra nin maubatan o masurnang nin saray mangkumuntra komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mataman et li' nin saray mismon mangatua, bubsat, kukanayon tan uamigo moyo, pagtraiduran rakamo li' tan saray raruma komoyo ket ipapati rasara li'. ");
INSERT INTO smkNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Guraen rakamo li' nin sarban tutawo bana' ta mantarig'enan moyoy mangkikalamo' kongko. ");
INSERT INTO smkNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wanin man, pagawan nakamo li' nin Dios ta pigaw nin mataman ni sayay sabot nan ulo moyo ket kai gapo nin maurot. ");
INSERT INTO smkNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kanya' nin tumarig'en kamon tumulok kongko ta no wanin a gaw'en moyo, maga'muran moyoy byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","No ma'kit moyayna li' a Jerusalem nin nalibed rayaynan sundalo' ran kalaban, sa sayti matandaan moyo a say pakasida' na ket dandani ana. ");
INSERT INTO smkNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ket no wanti ana li' a mampangyadi', saray itaw nin mampiikap sa Judea matkap a malayo saraynan mako umadi sa tutalugtog. Sara anamaet a itaw nin mampiikap sa mismon syudad nin Jerusalem, matkap a lumakwan sarayna tan saray itaw sa rikor, matkap a andi' sara ana nin lumuob ");
INSERT INTO smkNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","bana' ta siti ana a panaon nin dusawen nasara nin Dios a Israelita nin sigon sa naisurat sa Masanton Kasuratan a matkap nin matukid nin sarba. ");
INSERT INTO smkNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kado' sarayna li' a mabuktot tan saray uinan main nin ua'nak ran mampasuswen konan siin a panaon, bana' ta sa intiron lugar ket magkamain nin grabin pakapadya'dya' ta ipa'kit na nin Dios a alakin sager na konan sitin nasyon nin Israel. ");
INSERT INTO smkNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kanya' nin main konran saray Israelita a patye-patyen yupa' sa ispada tan main anamaet konra a dakpen ta i'ras saran mag'in nin aripen sa nagsikabarang nin nunasyon. Mi'sa, si Jerusalem ket daegen rayan saray kalaban a ambo' nin Judio ket sakupen raya angga nin marate' a nitanda' nan Dios nin panganggawan nin pag'uuray ra.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ket main nin bagay a ma'kit li' nin mangyadi' konan awro, bulan tan sa bubituen. Gewgewan ra li' nin sarban tutawodti sa mundo ta masalak sara bana' sa kasaw nin kanurkor nin taaw tan kaalalakyan nin daluyon. ");
INSERT INTO smkNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Makle-maklep sara li' a tutawo sa li'mo tan sa pangingisip ra sa rumate' li' nin mangyadi' iti sa babon luta', ta say pupakayadi' a mamauksoy sa ta'gay langit ket maguloyna. ");
INSERT INTO smkNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kaaram, ma'kit rako li' nin si'kon si Pinaitawo nin manrumate' nin iti sa gunem nin main pakayadi' tan kasan kapadan kagalangan. ");
INSERT INTO smkNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kanya' nin no sarban sayti ket tumarana' ana li' nin mangyadi', paksawen moyoy nakem moyo tan rumiriket kamo bana' ta say pakaisalba moyo ket adani ana.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ket nibarita' naya ni Jesus konra a sayay pangingiyarig a wana, “Kiten moyay kayon igos tan say raruma et nin kukayo. ");
INSERT INTO smkNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No sumalingsing yaynan gumulong, masigurado moyon tumarana' anay tyimpon rapeg. ");
INSERT INTO smkNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wanin anamaet, no ma'kit moyoyna li' nin mampangyadi' anaytin bubagay a nipatanda' ko, matandaan moyon adani anay pag'aadi' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ibarita' koyti komoyo, sarban nibarita' ko komoyo ket natukid ana mataman nin ba'yo kamo et nin mati nga'min. ");
INSERT INTO smkNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Makasa a langit tan luta', bale' say ibarita' ko magnayon nin tutuo anggan-angga.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nibibilin na et ni Jesus konra, “Pakailag kamo! Bangli' nin say pirmi tana nin iti sa kaisipan moyo ket say piririga, pipabok tan say kapapaga sa byay, ket siguradon bigraen nakamoyna li' nin awron isusubli' ko ");
INSERT INTO smkNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","a bilang sa sayay la'wan a bigra' nin misada'. Rumate' ya in nin awro sa sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kanya' nin matkap a sisasadya' kamon pirmi tan matkap a dumasal ta pigaw nin magkamain kamon kasaw nin nakem nin maagwantawan a sarba nga'min nin sain a mangyadi' li'. Ket no wanin, makakiadap kamo li' kongko a si'kon si Pinaitawo.” ");
INSERT INTO smkNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Inawru-awro ya nin mampangyakay si Jesus itaw sa sakop nan Timplo tan tepe' nin yabi ket mako ya sa Talugtog Olibo nin itaw yan mikakayabi. ");
INSERT INTO smkNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kabubuklas et a lamang ket mako saraynay tutawo sa Timplo ta pigaw nin rumnge' sara kona. ");
INSERT INTO smkNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Adani anay Pistan Pangangan nin Tinapay a Kasan Pammakbo nin tumarana' sa pangngisilibra nin Pistan Nipanglabas. ");
INSERT INTO smkNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sawanin, saray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan ket mampaningkap saran padalan no pa'no raya nin maipapati si Jesus nin kasan magtanda' ta mali'mo sara konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ket, sinrepan naya ni Satanas si Judas Iscariote a saya konran labinrwan apostoles na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ket nako ya si Judas konran Pupangulon Pupadi' tan pupangulo ran gwardya sa Timplo tan nikitarusan ya konra no pa'no nayan maipagamet konra si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Anaod, pinasyan riga ra ket nipangako' ran byan rayan kwarta. ");
INSERT INTO smkNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ket nikikumpurmi ya tan nangkit yayna nin tyimpon maipagamet naya konra si Jesus nin kai ra maaraman nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sawanin, narate' anay u'nan awro nin Pistan Pangangan nin Tinapay a Kasan Pammakbo a syay awron pangmamatin karniro para sa Pistan Nipanglabas. ");
INSERT INTO smkNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ket nibaki' nasara ni Jesus si Pedro tan si Juan a wana, “Mako kamoyna ta isadya' moyoy pangapunan tamo sa pista.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tinepet ra, “Adti a rabay moyo nin pangisadyaan mi?” ");
INSERT INTO smkNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ni'bat na, “Wanti e: Mansumrep kamo et tamo' sa syudad ket main li' nin lalakin masnaan moyodtaw a mampangawit yan sampaya nin ranom. Tumbuken moya sa balin keen na ");
INSERT INTO smkNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tan ibarita' moyo konan main ikon nin bali, ‘Wana ni Maistro tamo, adti ya kano a kwarton kidungwan nan mangapon komi nin tumutumbok na sitin yabi nin Pistan Nipanglabas?’ ");
INSERT INTO smkNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ket ipa'kit naya komoyoy sayay alawang nin kwarto sa ta'gay nin nasadya' tan kumplito anay agamiren. Ket itaw, manadya' kamo nin kumana' kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nako sarayna ket page' a nadumog rayaytaw si nibarita' na ni Jesus konra. Kanya' nin nisadya' raynay pangapunan ra sa pista. ");
INSERT INTO smkNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sin udas anan pangngapon, nidudungo sara sa pangnganan si Jesus nin saray apostoles na. ");
INSERT INTO smkNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sin sain, wana ni Jesus konra, “Man'apes-apesen koynaytin na'teng si makakidungo komoyo nin mangan sa sitin pista ba'yo ako nin mangirangep nin dya'dya'. ");
INSERT INTO smkNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Anaod, ibarita' koyti komoyo, kai akoyna li' anamanaet nin mangan sa wantin pista anggan matukid ana a tutuon pipa'kaan nan siti no lison mag'adi' yayna li' a Dios.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kaaram, kinalap nayay baso a main nin arak nin ubas. Nikisalamat ya konan Dios, mi'sa wana, “Kalapen moyayti ket saya-saya kamon minom, ");
INSERT INTO smkNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ta ibarita' ko komoyo a mangibwat sawanin, kai akoyna gapo nin minom nin arak nin ubas anggan si Dios ket lison mampag'adi' yayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kaaram nangalap yan tinapay tan nikisalamatan nayay Dios, mi'sa naya nin simpi-simping tan nitayak na konra, tan wana, “Siti a lalaman ko nin maida'ton para komoyo. Gaw'en moyoyti nin pirmi ta pigaw nin mapanemtem moyoy byay tan patiti ko.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wanin anamaet, sin nayadi' sarayna nin nangan, kinalap naya a baso tan wana, “Sayti nin arak a paka'kitan nin ba'yon pakitarato nan Dios sa tutawo nin pa'geten yan daya' ko nin tumuro' para komoyo. ");
INSERT INTO smkNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wanin man, reng'en moyayti: Iti yan kadungo tamoy tawon magtraidor kongko. ");
INSERT INTO smkNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Si'kon si Pinaitawo, mati ako sigon sa niketeg nan Dios bale' kado' yayna in si magtraidor kongko!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ket nagsitepetan sara no si'no kadi' konra a mampangiplanon siin. ");
INSERT INTO smkNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kaaram, nipupurpya sara anamaet a apostoles no si'no konra a ibilang nin sangkata'gayan. ");
INSERT INTO smkNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ket wana ni Jesus, “Saray uadi' iti sa mundo, man'aripenen rasaray masakupan nin uray ra; mataman nin wanin, pagalangan sara a wadi' ket matulong sara. ");
INSERT INTO smkNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bale' si'kamo, ambo' nin manepeg a gaw'en moyo in. No kai, no si'no komoyo a sangkata'gayan a butang, sya a mag'in nin sangkaayupaan, tan si sayay pangulo, sya a magsirbi. ");
INSERT INTO smkNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Si'no ket a mas ata'gay, si nakadungon mampangan o si mampagsirbi? Syimpri a, si nakadungo, kai para? Bale' si'ko, iti ako komoyo nin kapada nan sayay tagasirbi. ");
INSERT INTO smkNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Si'kamo, mandumaer kamon kalamo' ko sa pakasubok ko. ");
INSERT INTO smkNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kanya' nin no pa'no a si'ko ket binyan nakon Ama ko nin kanepegan nin mag'adi', byan katamo anamaet nin kanepegan nin kipag'uray kongko ket ");
INSERT INTO smkNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","makakidungo kamo li' kongko nin mangan tan minom no mampag'adi' akoyna. Tumekre' kamo sa tutruno ket kipag'uray kamo konran labinrway grupo ran puri na ni Israel.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon Pedro, mangrenge' ka. Si Satanas, inaburuyan naynan Dios a dawat nan subuken a pammemper moyo nga'min, a say pa'sar moyo ket kapada no pipuruken a byas tan ata' nin yakayaken. ");
INSERT INTO smkNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bale', nidasal takayna, Simon, a kai kumon nin mayegyeg a pagmamatalek mo. Ket no sinmubli' kayna li' kongko, pagsenen mosaray bubsat mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wanan ni'bat ni Pedro kona, “Uunuren, sisasadya' akon maipriso o mati nin kalamo' ka.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ket wana ni Jesus kona, “Pedro, ibarita' koyti komo, konan sitin yabi ba'yo main nin tumarang'ok nin manok, mitlo mo ibudi' a katanda' nako.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mi'sa wana ni Jesus konran saray apostoles na, “Sin nibaki' katamon mangyakay nin kai katamo nin pinibalon nin kwarta, bag tan apin nin ayi, nagkurang kamo para?” “Kai,” wanran ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ket wana ni Jesus konra, “Sawanin bale', no main nin kwarta tan bag moyo, matkap nin awiten moyo. Ket no kasan armas moyo, ilako' moyoy aysing moyo ta manaliw kamo ");
INSERT INTO smkNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ta ibarita' ko komoyo a matukid yay wanan Masanton Kasuratan maipa'ka' kongko a, ‘Naibilang yan sayay kriminal.’ Ket adani anay pakatukid nin siin kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Uunuren,” wanran saray apostoles na, “ya e a rwa ray armas.” Ket wana ni Jesus, “Kustoyna in!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bilang ugali' na, nibwat ya si Jesus nin nako sa Talugtog Olibo. Nayi saray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sin nakarate' saraynadtaw, wana ni Jesus konra, “Dumasal kamo ta pigaw nin kai kamo madaeg nin tukso.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kaaram, kinmadayo' ya konra nin kapada kaadayo' nin maabot nan sayay nibasyon bato, mi'sa ya nanalimukod nin dinmasal a wana, ");
INSERT INTO smkNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama ko, no magwa', andi' mo kumon nin ipairangep kongko in say dya'dya' a adapen kon irangep. Wanin man, ambo' a karabayan ko a masunor, no kai say karabayan mo.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ket sin sain, main nin anghil nin ibat sa langit a pinaipa'kit nin namaksaw nin nakem na. ");
INSERT INTO smkNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sa idap nin pa'sar na, lalo yaynan masuet nin dinmasal si Jesus ket nanaynge-saynget yan bara'mon daya' nin tinmuro' sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sin nayadi' yayna nin dinmasal, sinmubli' ya konran tumutumbok na ket narat'anan nasaran mampa'lek sa nalabas a bereng ra. ");
INSERT INTO smkNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wana konra, “Ambale' a mampa'lek kamo? Mibangon kamo ta dumasal kamo ta pigaw nin kai kamo madaeg nin tukso!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sin mampag'irgo ya et si Jesus, rinmate' saray abaw nin tutawo. Iti ya sa u'na si Judas a saya konran labinrwan tumutumbok na. Kinmadani ya kona ni Jesus ta pigaw nin arkan naya. ");
INSERT INTO smkNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ket wana ni Jesus kona, “Judas, ani? Traiduren nakon si Pinaitawo konan sitin arek mo?” ");
INSERT INTO smkNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sin naamingaw ran kalalamo' na ni Jesus a main nin ambo' nin mabistan mangyadi', wanra kona, “Uunuren, kilaban kami ana! Main nin beneng mi!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bigra', tinaga' nayan saya konran apostoles a sayay katulong nan Sangkata'gayan nin Padi' ket naglat yan nataga' a wanan nin tutulyan na. ");
INSERT INTO smkNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ket wana ni Jesus, “Kustoyna in!” Gina'getan nayay tutulyan nan katulong ket tampor a inmanda' ya. ");
INSERT INTO smkNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mi'sa wana ni Jesus konran Pupangulon Pupadi', upisyalis ran saray gwardya sa Timplo tan Mangatuntawo ran Judio a nakodtaw nin manakep kona, “Saya ako para nin kriminal ta nakabeneng kamo tan main nin pekpek moyo? ");
INSERT INTO smkNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inawru-awron kalamo' rakodtaw sa sakop nan Timplo, ket kai rako nin dinakep. Bale' sawanin, inaburuyan kamo nin gaw'en moyo a rabay moyo tan say rabay nan adi' nin kadedleman.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinakep raya si Jesus tan nika' raya sa bali nan Sangkata'gayan nin Padi'. Si Pedro, tinmumbu-tumbok ya bale' itaw ya tamo' sa dayo'. ");
INSERT INTO smkNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Main nin namuor itaw sa butlay nin baraybay nan bali nan Sangkata'gayan nin Padi', mi'sa tinmekre' saran pairangrang. Ket nako ya nin pairangrang nin kalamo' ra si Pedro. ");
INSERT INTO smkNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na'kit nayan sayay babayin katulong si Pedro nin mantumekre' sa danin puor ket pinastang nayan maong mi'sa wana, “Kalamo' naya in!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ket nibudi' nayti ni Pedro tan wana, “Arikong, kai pa! Ni kai koya nin katanda'!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ambo' nin na'teng, main et nin nakaalilbi' kona ket wana, “Saya ka anamaet konran kalalamo' na!” Wanan nibudi' ni Pedro, “Kai pa, amigo!” ");
INSERT INTO smkNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Napalabas a magsayay udas, sayay lalaki anamaet a nangipasuet, “Page' pan kalamo' nayayti ni Jesus ta taga Galilea ya.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bale' inumbat ya si Pedro a wana, “Amigo, kai ko gapo tanda' in say man'ibarita' mo!” Kapingmatan, leleg nan mampag'irgo ni Pedro, main nin tinmarang'ok nin manok. ");
INSERT INTO smkNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sin sain, linmingap ya si Jesus tan pinastang naya si Pedro. Sawanin, napanemtem na ni Pedroytaw say nibarita' na ni Jesus nin Uunuren kona a wana, “Ba'yo main nin tumarang'ok nin manok konan sitin yabi, nitlo moyna nin nibudi' a katanda' nako.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nibwat ya si Pedro ket inmakis ya sa bereng nan tuloy. ");
INSERT INTO smkNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sawanin, saray mampaggwardya kona ni Jesus, nag'irgu-irgo saran pammading'ey kona tan binugbu-bugbog raya. ");
INSERT INTO smkNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pinepet ra et a mata na mi'sa wanra kona, “Prupita ka! Ibarita' mo no si'noy namikas komo.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ket abaw et a nipanuya'-tuya' ra kona. ");
INSERT INTO smkNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sin buklas ana, nididinep saray iti sa Kunsiho ran Judio a saray Pupangulon Pupadi' tan Madudunong sa Gugan-gan; ket niyadap ya si Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wanra kona sin sain, “Ibarita' mo komi, si'kay Criston nipangako' nan Dios?” Ket wana ni Jesus konra, “Mataman nin ibarita' ko komoyo, kai moyon lamang nin tepren; ");
INSERT INTO smkNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ket no tepetan katamo anamaet, kai kamon lamang nin umbat. ");
INSERT INTO smkNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bale' sa ambo' ana nin ma'teng, si'kon si Pinaitawo, tumekre' akoyna li' iti sa wanan nan Dios, a sya a Makapangyayadi'.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sin sain, nagsitepet sara a wanra, “Si'ka edet a Anak nan Dios?” Ket wanan ni'bat ni Jesus, “Nairgo moyoynaod ana.” ");
INSERT INTO smkNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sawanin, wanra, “Kai tamoyna nin matkap a raruma et nin ibidinsya! Narnge' tamon diri a nibarita' nan mismo.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sin sain, inumdeng saran sarba a myimbro nan Kunsiho ta i'ras raya si Jesus kona ni Gubirnador Pilato. ");
INSERT INTO smkNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ket itaw, tinaranaan rayaynan parsawan. “Naimatunan mi a sitin tawo ket mansugsugen nasaran kumuntra sa gubyirno a tutawo. Mampaeden rakamin mamayad nin buis konan Impirador nan Roma tan wana et a sya kanoy Cristo a saya yan adi'.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kanya' nin, tinepetan naya ni Pilato a wana, “Si'ka paran page' a Adi' ran Judio?” Ket ni'bat na ni Jesus, “Nairgo moyoyna.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sin sain, wana ni Pilato konran Pupangulon Pupadi' tan konran abaw a tutawodtaw, “Kasan ma'kit kon nepeg a pakasintinsyawan na.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bale' lalo ran nipase'se' a maparsawan raya ket wanra, “Talaga pan mansugsugen nasaray tutawo, sa intiron Judea, yupa' sa uakay na, nangibwat sa Galilea anggadti sa Jerusalem.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sin narnge' na in ni Pilato, tinepet na no tutuon page' a taga prubinsyan Galilea ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ket sin natandaan na a taga yadtaw anaod sa Galilea a iti sa uray na ni Adi' Herodes, nipaiyater naya si Jesus kona a sin sain ket naibansag a itaw ya sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mariga yan tuloy si Adi' Herodes sin na'kit naya si Jesus ta na'teng nayaynan rabay nin makaadap. Bana' sa marnge-marnge' na a maipa'ka' kona, apes na nin mangwa' yan milagro para kona si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kanya' nin abaw a tinepet-tepet na kona ni Jesus sin sain, bale' kai ya gapo nin inumbat. ");
INSERT INTO smkNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Saray Pupangulon Pupadi' tan saray Madudunong sa Gugan-gan itaw sara anamaet nin naka'deng ket, pasyawan a pammaduka' ra kona. ");
INSERT INTO smkNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ket pati si Herodes tan saray susundalo' na, kinaka'lisan tan tinuya'-tuya' raya. Mi'sa sinulutan rayan mablin seket nin adi', ba'yo naya nipasubli' ni Herodes kona ni Pilato. ");
INSERT INTO smkNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ket konan sitin kaawrwan, miamigo sarayna si Herodes tan si Pilato, anta gindat ket mikuntra sara. ");
INSERT INTO smkNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nipakayaban nasara ni Pilato a Pupangulon Pupadi', saray raruman mampag'uray tan saray tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Sin itaw sarayna nin nadinep wana konra, “Nidarom moyaytin tawo kongko a wamoyo mampanugsog yan sumubag konran iti sa uray. Inimbistiga koya sa adapan moyo ket kasa anamaet nin napatutu'wan sa man'iparsa moyo kona ");
INSERT INTO smkNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","tan taman si Herodes, wanin ya, ta nipasubli' nayadti kongko. Edet ta wanin, kasan ginwa' nan nepeg nan pakasintinsyawan nin patiti. ");
INSERT INTO smkNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Wanin man, ipasanet-sanet koya tana mi'sa koyayna nin bulusan.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Konan siin bale', nirirngan saran tinma'way a wanra, “Patyen yayna in a tawo! Si Barrabas, sya a rabay mi nin bulusan!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Siti si Barrabas, mangkapriso ya bana' sa nipangitarana' nan pigugulo sa syudad nin Jerusalem tan nangmati ya. ");
INSERT INTO smkNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa apes na ni Pilato nin bulusan ya si Jesus, ket nikiirgo ya anaet konran tutawo, ");
INSERT INTO smkNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","bale' nita'way ran wanra, “Sya a ipasak sa kudos! Ipasak ma!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ikatlon parso ana a kinairgo nasara ni Pilato a wana konra, “Ambale'? Ani a maibarita' moyon ginwa' nan abas? Kasan ma'kit kon kasalanan nan pakasintinsyawan nan patiti. Kanya' nin ipasanet-sanet koya tana mi'sa koyayna nin bulusan.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bale' lalo ran nita'way nin nipasuet nin tutawo a ipasak ya sa kudos. Ket napasunor raya si Pilato ");
INSERT INTO smkNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ket sinintinsyawan naya ni Pilato si Jesus sigon sa no ani a rabay ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Binulusan nayay rabay ran bulusan, si mangkapriso bana' sa nipanugsog na konran tutawo tan nipangmati na. Bale' inaburuyan nan ipagamet ya konra si Jesus ta pigaw nin patyen ya ta siti a rabay ra. ");
INSERT INTO smkNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ket sin ika' rayayna nin ipasak sa kudos si Jesus, nipukpok rayay sayay lalakin ibat sa baryo nin mampamunta ya sa syudad. Syayti si Simon a taga Cirene. Nipabalatay rayay kudos kona nin itaw ya sa gurot na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Abaw saray tutawon mampangaluyon kona. Main nin bubbayin sabtan bereng ra tan man'abet-abetan raya. ");
INSERT INTO smkNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ket liningap nasara ni Jesus tan wana konra, “Si'kamon bubbayin taga Jerusalem, andi' rako nin akisan; akisan moyoy lalaman moyon diri tan saray ua'nak moyo. ");
INSERT INTO smkNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","O', ta marate' li' a panaon nin wamoyo li' nin tutawo, ‘Makarma' saray baog, tan saray kai nakasari' nin nanganak o namasuso!’ ");
INSERT INTO smkNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wamoyo li' sa tutalugtog, ‘Dag'an rakami!’ tan sa pupurod, ‘Tambakan rakami!’ ");
INSERT INTO smkNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","No man-gaw'en rayti kongko, a bara'mon akon malibuyong nin kayo, pa'noyna li' a pammadya'dya' ra komoyo a bara'mo kamon kayon kiri'?” ");
INSERT INTO smkNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sin sain, main anamaet nin nialuyon ra kona ni Jesus nin rwa ray kriminal nin ikirngan ran patyen kona. ");
INSERT INTO smkNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sin nakarate' sara sa lugar a mansabtan “But'ol Ulo,” nipasak rayaynadtaw si Jesus sa kudos, pati saray rway kriminal, si saya sa bandan wanan na tan si saya anamaet sa wiri na. ");
INSERT INTO smkNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ket sin sain, wana ni Jesus, “Ama, pirdunawen mosara, ta kai ra nin tanda' a man-gaw'en ra.” Ket nibubunutan ran nitaw'a-taw'an nin saray sundalo' a seket na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Saray tutawo, itaw saran mampamantay. Bale' saray mampag'uray, tinuya'-tuya' raya, “Naisalba nasaray raruma; isalba nay lalaman nan diri no syan page' a Criston sinuyo' nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pati saray sundalo', tinuya'-tuya' raya anamaet. Kinmadani sara kona ta pigaw nin painumen rayan maalsem nin arak ");
INSERT INTO smkNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tan wanra, “No page' a si'kay adi' ran Judio, isalba moy lalaman mon diri!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sa ta'gay nan ulo na ni Jesus sa kudos ket wanti e a naisurat: SITI A ADI' RAN JUDIO. ");
INSERT INTO smkNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Si saya konran kriminal a nakapasak anamaet sa kudos ket tinuya'-tuya' naya si Jesus a wana, “Kai para a si'ka a Cristo? Isalba moy lalaman mo pati si'kami anamaet!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bale' inima'no nayan saya a wana, “Kai ma ikali'moy Dios? Anaod, pari-parihoy sintinsya tamo! ");
INSERT INTO smkNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nepeg atan dusawen bana' sa ginwa-ginwa' ta. Bale' sitin tawo, kasan ginwa' nan duka'.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mi'sa wana, “Jesus, panemtemen nako li' pa no mampag'adi' kayna.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wanan ni'bat ni Jesus, “Ibarita' koyti komo, konan sitin awro kalamo' katayna itaw sa Paraiso.” ");
INSERT INTO smkNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sin nangyadi' in bandan ugtiawroyna, ket dinmedlem yay intiron babon luta' nin narate' a tuloy udas ");
INSERT INTO smkNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ta nakasay sira' nan awro. Sawanin, nabisang yan napiknga' a kurtina sa Sangkasantusan nin Lugar sa Timplo. ");
INSERT INTO smkNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ket wana ni Jesus nin nita'way nin maksaw, “Ama, ipagamet koyayna komo a kararwa ko!” Kayadi' na nin inirgoyti, nauyos anay inanawa na. ");
INSERT INTO smkNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sawanin, si kapitan nin sundalo' a mangkakaimaton sa mampangyadi', rinayo nayay Dios tan wana, “Page' a sitin tawo ket kasa gapon kasalanan na!” ");
INSERT INTO smkNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Saray tutawon nakaimaton sa sarban nangyadi', sinmubli' saran mabereng sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bale' sarba ran saray katanda' na ni Jesus pati saray bubbayin nangaluyon kona nin nangibwat sa Galilea, itaw saran naka'deng sa adayo' ket mangka'kit ray nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Main nin sayay tawon taga Arimatea a say ngaran na Jose. Maong tan matunong ya tan pitta'gan na a irarate' nin pag'aadi' nan Dios. Myimbro ya nin Kunsiho, bale' kai ya nin nikikumpurmi sa niplano tan ginwa' ra kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nako ya kona ni Pilato nin nikidawat yan aburoy a kalapen nayay bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ket nikayupa' naya sa kudos mi'sa binarkot nayan maputi' a mabistan klasin abel a mantawagen nin diilo tan nikwa naya sa pannabunan nin kinalin bara'mon yukib sa bato a siti ket kai ya et gapo nin nausar. ");
INSERT INTO smkNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sin sain, patpaapon nin Biyernes, a syay Awron Pananadya' ket dandani yayna nin tumarana' a Awron Painawa ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Saraytaw saray bubbayin nangaluyon kona ni Jesus nin nangibwat sa Galilea, tinumbok raya si Jose ket na'kit rayay nanabunan tan no pa'noy nipamakanda' konan bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ket sinmubli' saraynan tampor sa bali ra ta pigaw nin isadya' ray ipamabanglo sa bangkay na ni Jesus. Pinainawa sara bale' sa Awron Painawa sigon sa nigan-gan na nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ket sin parbangon et tamo' sin awron Linggo, nako saraynay bubbayi sa nanabunan kona ni Jesus nin awit ray banglon nisadya' ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ket narate' rayan natulin anaytaw si baton nipanada' konan nanabunan. ");
INSERT INTO smkNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bale' sin linmuob sara, kasa yaynadtaw a bangkay na ni Uunuren a Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mangkaguloy isip ra no ani bale' a nangyadi'. Ket sin sain, bigra' a main anan rwa ray lulalakin iti sa dani ra nin kumidla-kidlap a aysing ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sa li'mo ra ket tinumwek sara, ket wanran saraytin rway lulalaki konra, “Ambale' nin mantikapen moyay saya nin mabyay iti sa kami'nan ran nunati? ");
INSERT INTO smkNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kasa yaynadti si Jesus ta pinasubli' yan mabyay! Panemtemen moyaytaw si nibarita' na sin itaw ya et sa Galilea. ");
INSERT INTO smkNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kai para a wana komoyo ket, ‘Si'kon si Pinaitawo, ipagamet rako konran duka' a tutawo; ipasak rako sa kudos, bale' sa ikatlon awro pasublien akon mabyay?’ ” ");
INSERT INTO smkNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ket, napanemtem raynaod a wanin a nibarita' na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kanya' nin linmakwan saran tampor itaw sa nanabunan ket sinmubli' sarayna sa syudad tan nibarita' ray nangyadi' konran saray labinsayay apostoles tan konran raruman kalalamo' ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Saray bubbayi a sara si Maria nin taga Magdala, si Juana, si Maria nin ina na ni Santiago, tan saray raruman bubbayin kalalamo' ra a nangibarita' konran apostoles. ");
INSERT INTO smkNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bale' kai rasara nin timper, bana' ta sa wanra ket pinabrika rayti tamo'. ");
INSERT INTO smkNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wanin man, si Pedro ket inumdeng ya tan nalayo yan nako sa nanabunan. Sin rinmate' yadtaw, dinmukot yan sinmir'ip ket say kal-la na'kit na say mabistan abel nin nipamarkot konan bangkay. Ket nugot yayna sa bali ra nin man'isip-isipen na a no pa'noy nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sitaw lamang a awro, rwa ray tumutumbok na ni Jesus a manlumalakon adap sa babalin Emaus nin labinsayay kilumitro a kaday'an mangibwat sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mampag'irgwan ray nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ket mintras a mampiirgu-irgo sara, si Jesus kinmadani tan nikialuyon ya konra; ");
INSERT INTO smkNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","bale' kai raya nin naalilbi' ta kai na nin niyaburoy. ");
INSERT INTO smkNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sin sain, tinepetan nasara ni Jesus, “Ani anamaet a mampag'irgwan moyo mintras a manlumalako kamo?” Tinumgen sara nin mabereng sara. ");
INSERT INTO smkNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ket si saya konra a say ngaran na Cleopas, wana kona ni Jesus, “Si'ka tana angangkoy san'ili sa Jerusalem a kai nin magtanda' sa bubagay a kayadi' nin nangyadi' itaw!” ");
INSERT INTO smkNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nitepet na ni Jesus, “Ani in a bubagay?” Wanran ni'bat, “Say maipa'ka' kona ni Jesus a taga Nazaret. Saya yan prupita tan main nin pakayadi' nin sarita' tan gawa' na sa pangingikit nan Dios tan konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Saray Pupangulon Pupadi' tan saray raruman iti sa uray, nipasintinsyawan raya bale' nin patyen ket nipaipasak raya sa kudos; ");
INSERT INTO smkNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","sya pa et a man'ilalwan min mangilibri konran tutawo nan Israel. O', ket saya et, ikatlon awroyna sawanin nangibwat sin nangyadi' in. ");
INSERT INTO smkNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ket sukat a main nin umno ray bubbayin kalalamo' mi a naka'ngapan mi. Masakbay saran nako sa nanabunan ");
INSERT INTO smkNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bale' kai raya nin na'kit a bangkay na. Nibarita' ran main nin nipa'kit konra nin uanghil nin wanra kano ket mabyay ya. ");
INSERT INTO smkNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ket saray raruma komi, nako saradtaw sa nanabunan ket napatutu'wan ran say nibarita' ran bubbayi ket tutuo. Bale' wanin a lamang, kai raya na'kit a bangkay na ni Jesus.” ");
INSERT INTO smkNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ket wana ni Jesus konra sin sain, “Kalawakaw kamo, ta sabtan idap moyon tepren a nibarita' ran prupita! ");
INSERT INTO smkNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kai moyo para nin tanda' a si syay Cristo ket matkap nin mangitpel ya yapo' nin dya'dya' ba'yo ya nin pagalangan?” ");
INSERT INTO smkNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mi'sa, nipapalaway na ni Jesus konra a maipa'ka' konan diri a say naisurat sa Masanton Kasuratan mangibwat sa libron nisurat na ni Moises anggan sa sarban nisurat ran sarba ran prupita nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sin adani saraynay rway tumutumbok sa baryon keen ra, tumuloy yayna kumon sa keen na si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bale' pinaed rayan rway kaaluyon na a wanra, “Itaw kayna yapo' kipagtuloy komi ta manyumabi ana.” Kanya' nin nayi yayna si Jesus konra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sin dinmungo saraynan mangan, kinalap na ni Jesus a tinapay mi'sa nikisalamat ya konan Dios sa sayti. Kayadi', piniknga' na ba'yo na nin nitudol konra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kapingmatan, naalilbi' rayayna si Jesus bale' bigra' yaynan nakasadtaw. ");
INSERT INTO smkNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ket wanra sa saya tan saya, “Ay, kanya' anamain nin bilang nin napa'mot a kapusuan ta sin mangkiirgo ya konta sa dalan tan sin man'ipapalaway nay Masanton Kasuratan!” ");
INSERT INTO smkNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Konan siin a lamang nin udas, sinmubli' sara sa Jerusalem. Ket narate' rasaran nididinep a labinsayay apostoles tan raruman kalalamo' ra ");
INSERT INTO smkNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a wanra, “Peteg a mabyay yay Uunuren ta pina'kit ya kona ni Simon!” ");
INSERT INTO smkNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ket saray rwa, nipapalaway ray nangyadi' sa dalan tan say nikaalilbi' ra kona sin piniknga' nay tinapay. ");
INSERT INTO smkNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Leleg nin mampag'irgwan ray nangyadi', bigra' nin pinaipadar ya si Jesus nin inumdeng ya sa butlay ra tan wana, “Main kumon nin katinekan a kukaisipan moyo!” ");
INSERT INTO smkNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ket naka'ngap tan nali'mwan sara ta say wanra no lampong yay mangka'kit ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kanya' nin wana ni Jesus konra, “Ambale' nin nali'mwan kamo tan ambale' nin mampagdwadwa kamo kongko? ");
INSERT INTO smkNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kikiten moyoy gamet tan ayi ko. Peteg a si'koytin talaga. Karapasen moyoko; si sayay lampong ket kasan lalaman tan but'ol nan ambo' nin bilang sa mangka'kit moyo sawanin kongko.” ");
INSERT INTO smkNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ket anaod nipa'kit na konra a gamet tan ayi na. ");
INSERT INTO smkNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pinasyan ririket tan nipaka'ngap ra bale' kai sara et nin mamper ket tinepetan nasara ni Jesus, “Main paran ma'kan iti?” ");
INSERT INTO smkNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sin sain, binyan rayan sayay binayan kuna' ");
INSERT INTO smkNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ket kinalap nayayti tan kinna' naya sa adapan ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kaaram, wana ni Jesus konra, “Ba'yo ako nin pinati, nibarita' koyna komoyo a maipa'ka' sa nipaisurat nan Dios nin maipa'ka' kongko kona ni Moises tan konran prupita tan sa libron Kanta. Nibarita' ko komoyo a matkap nin matukid a sarba nga'min nin sain.” ");
INSERT INTO smkNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ket pinalawayan na ni Jesus a kukaisipan ra ta pigaw nin matarusan ray rabay nin ibarita' nin say itaw sa Masanton Kasuratan. ");
INSERT INTO smkNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wana konra, “Wanti e a naisurat: Mangirangep yan dya'dya' tan mati ya a Cristo tan sa ikatlon awro ket pasublien ya nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ket ipatandaan konran tutawo sa sarban nasyon mangibwat sa Jerusalem, a magbabawi' sara ta pigaw nin mapirduna a kasalanan ra bana' sa ginwa' na nin Cristo. ");
INSERT INTO smkNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tistigos kamo sa saytin bubagay a nangyadi' kongko. ");
INSERT INTO smkNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Anaod, ibaki' koya li' komoyo a Ispirito nan Dios nin nipangako' nan Ama ko; ket misyon kamo sa syudad anggan rumate' ya ta pigaw nin byan nakamon pakayadi' nin ibat sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kayadi' nasara nin ni'ras ni Jesus a tumutumbok na anggan sa babalin Betania, nita'gay nay gamet na ta bindisyunan nasara. ");
INSERT INTO smkNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sin kapresan nasaran mambindisyunan, nibati' nasarayna tan niyuli' yayna sa langit. ");
INSERT INTO smkNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ket rinayo raya mi'sa sinmubli' saraynay tumutumbok na sa Jerusalem a pinasyan ririket ra. ");
INSERT INTO smkNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nangibwat sin saytaw, nako saraynan pirmidtaw sa sakop nan Timplo nin mangrayo konan Dios.");
INSERT INTO smkNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sin saytaw sin ba'yo et nin pinarsa a animan, main yayna a si Kabalikasan nan Dios. Kalamo' naya nin Dios, tan si syay Kabalikasan, Dios yaynamaet. ");
INSERT INTO smkNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ba'yo et nin pinarsa a animan, kalamo' nayaynan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pinarsa nan Dios a sarba nin nipadalan kona, ket kasan animan a pinarsa nin kai nin dinmalan kona. ");
INSERT INTO smkNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Si syay Kabalikasan, pangibwatan yan byay, ket syay byay a palaway para konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ket mampalawayan nay dedlem iti konra, bale' kai rayan lamang nin maipurok nin saray iti sa dedlem. ");
INSERT INTO smkNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sawanin, main nin sayay tawon nibaki' nan Dios a say ngaran na ket Juan. ");
INSERT INTO smkNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nibaki' nayan Dios nin patutu'wan nay maipa'ka' konan siti nin palaway ta pigaw nin say sarban tawo, pagmatalkan rayayti bana' sa ipatutuo na ni Juan. ");
INSERT INTO smkNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ambo' ya si Juan ti si palaway no kai edet, nibaki' ya ta pigaw nin patutu'wan nay maipa'ka' konan si palaway. ");
INSERT INTO smkNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Siti si palaway nin tutuo ket syaytaw si nipadles nin rumate' iti sa luta' nin palawayan nay kaisipan ran sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ket mataman no rinmate' yaynadti sa mundo tan sya ket pinarsa na a sarban iti sa mundo, kai ra nin inalilbi' nin tutawo a kinasi'no na. ");
INSERT INTO smkNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nako ya konran kapada nan Judio sa nasyon nan diri, bale' kai raya nin inako'. ");
INSERT INTO smkNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wanin man, main a lamang nin nangako' kona. Ket, konran sarba ran nangako' kona, saray mampagmatalek kona, binyan nasaran kanepegan nin mag'in nin a'nak nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nagkamain saran peteg nin byay mangibwat sa gawa' nan Dios, ambo' nin mangibwat sa urdinaryo nin padalan bana' sa karabayan nin lalaman tan sa kanakman nan sayay lalaki. ");
INSERT INTO smkNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ket si syay Kabalikasan, nag'in yan tawo tan niikap ya sa busel mi ket naadal mi a kata'gayan na nin maikana' kona nin sya tamo' a kapada na nin Ama, ta kawa'nan nan liso a tutawo tan patutu'wan nan liso a maipa'ka' konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pinatutu'wan na ni Juan a maipa'ka' kona a wanan nipatanda', “Siti yaytaw si man'irgwen ko a wangko, ‘Siin si sumubray kongko, mas ata'gay ya dyan si'ko ta sya, main yayna sin saytaw et nin nu'na ya dyan si'ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Say katutu'wan, si'tamo nga'min, mangibwat sa main na nin si syay Kabalikasan, mangkaga'muran tamoynan mangkaga'muran a pangangawa'nan na ");
INSERT INTO smkNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ta mataman no nibi nan Dios a Gugan-gan na nin nipadalan kona ni Moises, si Jesu-Cristo bale' a nangipadalanan na a maga'muran tamoy pangangawa'nan na tan say katutu'wan maipa'ka' kona. ");
INSERT INTO smkNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","O', mataman no kasa et gapo ni saya nin naka'kit konan Dios abirno ana sa maka'numan, si Anak, a syan diri ket Dios ya tan kalamo' nayan pirmi, syay nangipapalaway nin maipa'ka' kona nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sawanin, wanti e a pammatutuo na ni Juan: Main nin pupadi' tan kukatulungan ra nin nako kona ni Juan. Nibaki' rasarayti nin pupangulo ran Judio itaw sa syudad nin Jerusalem nin mako mangusisa' kona a wanra, “Ani a nakaibakian mo?” ");
INSERT INTO smkNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kai na nin nibudi' ni Juan a katutu'wan no kai edet, mapala-palaway nan nibarita' a wana, “Ambo' ako a Cristo.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ket wanra kona, “Si'no ka edet? Si'ka para si Elias a wanran sumubli' iti?” Ket wana, “Kai, ambo' ako.” “Si'ka para edet taw si Prupita a man'irgwen na ni Moises?” nitepet ra anamaet kona. “Kai,” wana nin inumbat. ");
INSERT INTO smkNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wanra anamaet kona, “Si'no ka edet anaod? Ibarita' mo pa ta matkap a main nin ibarita' mi konran saray namaki' komi. Ani a magwa' min maibarita' maipa'ka' sa kinasi'no mo?” ");
INSERT INTO smkNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ni'bat na ni Juan, “Si'koy pakatukidan nin say nipadles na ni Prupita Isaias a ‘Marnge' ya li' a sayay mampangita'wa-ta'way nin mampangipatanda' itaw sa lugar a ambo' nin matawo a wana, Patu'riren moyoy dalanan nan Catawan.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Main nin Pariseo konran sarayti saray nibaki'. Ket konan siin, wanra, ");
INSERT INTO smkNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“No wanin a ambo' ka a Cristo tan ambo' ka anamaet si Elias o si Prupita nin inirgo na ni Moises, mayin edet a mampamawtismo ka?” ");
INSERT INTO smkNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Inumbat ya si Juan a wana, “Si'ko, main nin kanepegan kon mamawtismo sa ranom. Main anamaet nin iti sa busel moyo nin, si'kamo, kai moya nin mangkaalilbi'. ");
INSERT INTO smkNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Rumate' yaynan kasunor ko ket bana' sa kata'gayan na, kai ako gapo nin maikana' nin mataman tanan mangwarwar nin kurdon nin sandalyas na.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sayti, nangyadi' sa Betania sa rubari' nan Ilog Jordan nin mampamawtismwan na ni Juan. ");
INSERT INTO smkNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sin sumunor nin awro, na'kit naya ni Juan si Jesus nin man'umarak kona ket wana, “Sya e a pa'sar karniro nin nibi nan Dios a maida'ton ta pigaw nin maglat a kasalanan ran tutawo! ");
INSERT INTO smkNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Syaytaw si man'irgwen ko sin wangko a si rumate' nin kasunor ko ket mas ata'gay ya dyan si'ko ta main yayna sin saytaw et nin nu'na ya dyan si'ko. ");
INSERT INTO smkNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mataman nin si'ko nin diri, kai ko tanda' a sya anayti sin saytaw. Wanin man, nako akodti nin lamang nin mamawtismo sa ranom ta pigaw nin matandaan ko no si'no ya ket maipatandaan koya komoyo nin puri na ni Israel.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sawanin, sayti a nipamatutuo na ni Juan. “Si'kon diri, na'kit koya anaod a Ispirito nan Dios nin mangkumayupa' nin ibat sa langit nin bilang sayay kalapati tan nisyon ya konan siti. ");
INSERT INTO smkNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kai koya kumon nin tanda', bale' si nangibaki' kongko nin mamawtismo sa ranom, wana kongko, ‘Si ma'kit mo nin dupaan na nin Ispirito tan pisyunan naya, sya a mamawtismo sa Ispirito.’ ");
INSERT INTO smkNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ket si'ko, na'kit koyti anaod kanya' nin mampatutu'wan ko komoyo a sya a Pinili' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sin sinmunor nin awro, itaw ya anamanaet si Juan tan rwa ran tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na'kit nayan manlumabas si Jesus ket wana, “Sya in e a karniro a nibi nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Narnge' ra nin rway tumutumbok a wana ni Juan ket tinmumbok sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ket nibring ya si Jesus tan sin na'kit nasaran mantumumbok wana konra, “Ani a rabay moyo?” Ket wanran ni'bat kona, “Adti kamo nin mampiikap, Rabbi?” (Say katarusan nan sarita' a “Rabbi” ket Maistro.) ");
INSERT INTO smkNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Para, ta kikiten moyo,” wana. Kanya' nin nayi sara kona tan na'kit ra a mampiikapan na, ket nikipagtuloy saradtaw ta mag'alas kwatro ana. ");
INSERT INTO smkNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si saya konran sarayti saray rwan nakarnge' kona ni Juan tan tinmumbok kona ni Jesus ket si Andres. Main nin angkay na a si Simon Pedro. ");
INSERT INTO smkNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ket kina' naya yapo' nin tiningkap a busat nan si Simon tan wana kona, “Nadumog miya a Mesias.” (Say rabay nan irgwen nin Mesias ket Si Sinuyo' nin Magadi'.) ");
INSERT INTO smkNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ket, ni'ras naya si Simon kona ni Jesus. Pinastang nayan maong ni Jesus mi'sa wana, “Si'ka si Simon a anak na ni Juan, ngaranan kata nin Cefas.” (Sitin ngaran sa Griego ket Pedro tan say katarusan na ket bato.) ");
INSERT INTO smkNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Sin sumunor nin awro, nidisisyon na ni Jesus a mako sa Galilea. Na'kit naya si Felipe a taga Betsaida a kababalyan ra ni Andres tan ni Pedro ket wana kona, “Kikalamo' ka kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sawanin si Felipe, kina' naya nin tiningkap si Natanael tan wana kona, “Nadumog miya! Syaytaw si man'irgwen na ni Moises sa nisurat na tan say nisurat ra et nin prupita. Sya si Jesus a taga Nazaret nin anak na ni Jose.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Konan siin, wana ni Natanael, “Nazaret! Main para nin maabig a mangibwat itaw?” “Para, kikiten mo,” wana ni Felipe. ");
INSERT INTO smkNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sin na'kit naya ni Jesus nin man'umarak kona si Natanael, wana maipa'ka' kona, “Sya e a tutuon puri na ni Israel. Kasa gapo nin sinisirib kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tinepetan naya ni Natanael si Jesus a wana, “Pa'no rako nin nakatanda'?” Ket wana nin ni'bat ni Jesus, “Na'kit kata sa sirong nin kayon igos sin ba'yo naka nin tinawag ni Felipe.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Konan siin wana ni Natanael, “Maistro, si'kan page' a Anak nan Dios! Si'kay Adi' nan Israel!” ");
INSERT INTO smkNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wana nin ni'bat ni Jesus, “Kai para a magmatalek ka kongko bana' ta wangko ket na'kit kata sa sirong nan kayon igos? Maka'kit ka li' nin mas makapaka'ngap et nin mangyadi' dyan siin.” ");
INSERT INTO smkNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mi'sa wana konra, “Isipen moyoyti nin maong: Ma'kit moyo li' nin miabri a langit tan saray uanghil nan Dios ket muli'-manaoy sara nin mako kongko a si'kon si Pinaitawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Napalabas a rway awro, nagkamain nin bansal itaw sa babalin Cana sa prubinsyan Galilea. Itaw ya a ina na ni Jesus ");
INSERT INTO smkNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tan wanin ya anamaet si Jesus tan saray tumutumbok kona ta sinagyat sara anamaet. ");
INSERT INTO smkNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sin na'pos anay arak, wanan ina na ni Jesus kona, “Na'pusan saran arak.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ket wana ni Jesus, “Madam, say pangingisip ko, ket ambo' nin kapada a pangingisip mo. Matkap yapo' nin marate' a manepeg nin udas para kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sin sain, wana ni ina na konra nin mampagsirbi, “Gaw'en moyo a sarban ipagwa' na komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Main itaw nin a'nem ray pasig nin pangangwan nin ranom. Sayti ket para sa kaugalian ran Judio nin pangunguyas ra ta pigaw nin maikana' sara sa pangingikit nan Dios. Makalaman a barang saya nin pasig nin rwampulo' anggan tulumpulo' a galon. ");
INSERT INTO smkNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wana ni Jesus konran saray mampagsirbi, “Pun'en moyo nin ranom in say pasig.” Ket pinno' ra anaod anggan labi'. ");
INSERT INTO smkNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sin nayadi' wana konran saray mampagsirbi, “Manarok kamo tan ika' moyo konan si mampangasikasodti sa bansal.” Ket nangika' sara anaod kona. ");
INSERT INTO smkNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tinawayan nan si mampangasikason bansal ket, arak ana. Kai na nin tanda' no adti a ibwatan nin sayti ta sara tamo' anaod taw saray nanarok a makatanda'. Sin wanin, tinawag nayay lalakin nikasal ");
INSERT INTO smkNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tan wana kona, “Say ugali', say sangkatawayan nin arak a mu'na ran ipainom mi'sa no abaw ana li' a nainom ran tutawo, iliwa' raynaytaw si makapoy a taway. Si'kamo bale', nisuyot moyo a sangkatawayan nin arak!” ");
INSERT INTO smkNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sitin ginwa' nadtaw ni Jesus sa babalin Cana sa Galilea, sya a u'nan pammatutuo nin maipa'ka' no si'no ya tan mangipa'kit ti nin kata'gayan na. Ket saray tumutumbok na, lalo saraynan nagmatalek kona. ");
INSERT INTO smkNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kayadi' sain, namabaybay ya si Jesus nin nako sa syudad nin Capernaum. Kalamo' naya si inay na, saray bubsat na tan saray tumutumbok na, ket itaw sara nin umnoy awro. ");
INSERT INTO smkNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sin adani ana a pista ran Judio a mantawagen nin Nipanglabas, tinmangkar sara si Jesus sa Jerusalem ta pigaw nin kipista sara. ");
INSERT INTO smkNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nako ya sa Timplo ket narate' na a main nin maglalako' nin baka, karniro, kalapati, tan maninili nin kwarta sa sayay partidtaw. ");
INSERT INTO smkNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nangwa' ya nin sanet nin rubir tan pinalakwan nasaradtaw sa sakop nan Timplo, pati saray baka tan karniro. Nisabwag nay kwarta ran maninili tan tinali-talimbwag nay lamisawan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wana konra nin maglalako' nin kalapati, “Galten moyo saradti in! Andi' moya nin gaw'en nin palingki a Bali nan Ama ko!” ");
INSERT INTO smkNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ket napanemtem ran tumutumbok na a mabasa sa Masanton Kasuratan a wana, “Say masuet nin pangingisakit ko konan Bali mo ket man'upusen a kasaw ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Konan siin saray pupangulo ran Judio wanra kona, “Ani anamaet wadi' a pakatandaan nin maipa'kit mo a main nin pakayadi' mon mangwa' nin wanin?” ");
INSERT INTO smkNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ket ni'bat na ni Jesus konra, “Sidaen moyayti nin timplo ket paba'yuwen koya sa luob nin tuloy awro.” ");
INSERT INTO smkNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Konan siin wanra, “Narate' a a'pat a pulo' tan a'nem a taon sa nipama'deng konan sitin Timplo, ket wamo pa'dengen man uman sa luob nin tuloy awro?” ");
INSERT INTO smkNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Si timplo bale' nin man'irgwen na ni Jesus ket si lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanya' nin sin pinasubli' yaynan mabyay si Jesus, napanemtem ra nin tumutumbok nayti nin inirgo na. Ket say nangyadi', namper sara sa naisurat sa Masanton Kasuratan maipa'ka' kona tan sa nibari-barita' na. ");
INSERT INTO smkNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sin itaw ya si Jesus konan siin nin pista sa Jerusalem, abaw saray nakaimaton sa say ginwa-ginwa' nan nangipa'kit a nangibwat ya konan Dios. Ket anaod, abaw sara a namper no si'no ya. ");
INSERT INTO smkNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bale' kai na nin nipadar konra a maipa'ka' sa lalaman nan diri bana' ta tanda' nay pinanakem nin sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kai ana nin matkap a main et nin mangibarita' kona nin maipa'ka' sa si'numan ta sulpot nayna a kaisipan nin sarban tawo. ");
INSERT INTO smkNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ket, saya ya konran itaw a sayay pangulo ran Judio nin say ngaran na ket Nicodemo. Myimbro yan grupo ran Pariseo. ");
INSERT INTO smkNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ni'sa, nako yayti kona ni Jesus sin yabi ana ket wana kona, “Maistro, tanda' mi a nibaki' nakadti nin Dios nin mako mangyakay komi. Wanin bana' ta kasan makagwa' sa sain say makapaka'ngap nin paka'kitan a man-gaw'en mo no kasa ya a Dios kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wana nin ni'bat ni Jesus, “Isipen moyoyti nin maong: Kasa gapo ni saya nin makakirama' sa pag'aadi' nan Dios no kai ya nin paitawo nin uman a sayay tawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Wana ni Nicodemo, “Impusibli a maiyanak yay sayay matuntawo ana! Magwa' na para a paitawo et sa luob nin tyan nan ina na?” ");
INSERT INTO smkNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ni'bat na ni Jesus, “Isipen moyoyti nin maong: Kasa gapo nin makakirama' sa pag'aadi' nan Dios no kai ya anaod nin maiyanak nin uman a sayay tawo sa dalan nin ranom tan dalan nan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wanin ta si sayay mangibwat sa tawo, ket kinatawo tamo' a main kona; anamaet, si sayay mangibwat konan Ispirito nan Dios, kinaDios a main kona. ");
INSERT INTO smkNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Andi' ka edet nin mabigra' no ibarita' ko komo a matkap moyon tutawo a paitawo nin uman! ");
INSERT INTO smkNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Say pangibwaten nan mangyadi' nin Ispirito nan Dios konan tawon naiyanak nin uman ket iyalimbawa' ana sa siri. Makauray ya sa puntawen na. Maaraman ma bale', kai mo nin matandaan a pangibwatan na o a puntawen na.” ");
INSERT INTO smkNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ket nitepet na anamaet ni Nicodemo a wana, “Pa'no wadi' nin mangyadi' in?” ");
INSERT INTO smkNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Ani?” wana ni Jesus. “Saya kamo nin manrispitwen nin mangangakay iti sa Israel ket kai moyo in mangkaalilbi'? ");
INSERT INTO smkNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Isipen moyoyti nin maong: Say ibarita' mi ket say tanda' mi tan say na'kit mi. Bale' si'kamo, kai kamo nin mamper sa man'ibarita' mi. ");
INSERT INTO smkNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Anta mampangibarita' ako komoyo nin mangibwat sa say pupangyadi' iti sa mundo, kai moyo nin tepren. Ket tepren moyo kasi no mangibarita' ako nin maipa'ka' sa man-gaw'en itaw sa langit? ");
INSERT INTO smkNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Si'ko tamo' nin si Pinaitawo nin nangibwat itaw sa langit a makaibarita' nin maipa'ka' sa sain a bubagay, ta kasa et gapo anaod nin raruman nakapika' itaw no kai si'ko tamo'. ");
INSERT INTO smkNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ket say mangyadi' kongko, ket kapadaytaw say nipangita'gay na ni Moises konan pusti a si ginwa' nin bakas nin ulay sin itaw saray Israelita sa lugar a kasan tawo. Wanin ta si'kon si Pinaitawo, matkap a ita'gay ako li' anamaet ");
INSERT INTO smkNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta pigaw nin si si'numan a magmatalek kongko ket magkamain ya nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","O', ta wanin ana a pangangawa'nan nan Dios kontamo nin tutawo, kanya' nin kai naya nin nisiblet, no kai edet, nibi naya a Anak na nin kapagkapag ta pigaw nin si si'numan a magmatalek kona nin Anak na ket kai ya nin maisyay konan Dios ta pigaw nin madusa ya, no kai edet, magkamain ya nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wanin ta si Dios, kai naya nin nibaki' a Anak na iti sa mundo ta pigaw nin sintinsyawan nasaray tutawo, no kai edet, ta pigaw nin maisalba sara nin nipadalan kona. ");
INSERT INTO smkNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Saray magmatalek konan Anak nan Dios, kai sarayna nin sintinsyawan nin madusa, bale' saray kai nin magmatalek, nasintinsyawan sarayna nin madusa bana' anaod ta kai sara nin magmatalek konan kapagkapag a Anak nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Siti a rason a madusa sara: Si palaway nin mamalaway nin kaisipan ran tutawo ket nako yadti sa mundo bale', mas maalaga konra a kadedleman dyan say palaway. Wanin ta say man-gaw'e-gaw'en ra ket duka'. ");
INSERT INTO smkNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","O' ta saray mampangwa' nin duka' ket kai ra nin rabay a palaway tan kai ra nin rabay a mako sa palaway bana' ta, no mako sara ket maipadar a gawa'-gawa' ra. ");
INSERT INTO smkNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bale' saray sumunor sa katutu'wan a nipadar nan Dios, umarak sara sa palaway ta pigaw nin maipa'kit nin mapalaway a say ginwa' ra ket katutulok ra konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sin nayadi' in, nako ya si Jesus tan saray tumutumbok na sa raruman lugar sa prubinsya nin Judea. Ket itaw sarayna yapo' nin nitanda-tandaan saran maong tan namawti-bawtismo sara. ");
INSERT INTO smkNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Si Juan anamaet, mampamawti-bawtismo yadtaw sa Enon nin adani sa Salim ta raranom itaw nin lugar. (Sin sain ket kai ya et nin mangkapriso si Juan.) Kasan tegen ran mako nin tutawo kona ket binawti-bawtismwan nasara. ");
INSERT INTO smkNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bana' ta wanin, sayay awro, nikidiskusyon saray tumutumbok na ni Juan konan sayay Judio maipa'ka' sa saka-sakalakon kaugalian a maringgasan yay sayay tawo sa pangingikit nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ket nako saraytaw nin tumutumbok kona ni Juan. Wanra kona, “Maistro, sitaw intaw si lalaki nin kalamo' moyodtaw sa rubari' nan Ilog Jordan, sitaw si pinatutu'wan moyoy maipa'ka' kona, mampamawtismo ya anamaet ket mampako sara ana edet a sarba kona!” ");
INSERT INTO smkNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Inumbat ya si Juan ket wana konra, “Si si'numan a tawo, kasan animan nin kapapa'sar a pag'inan na no ambo' ya a Dios a nami kona. ");
INSERT INTO smkNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mapatutu'wan moyo a nibarita' ko a wangko, ‘Ambo' ako a Cristo, no kai si'ko a nibaki' nin mu'nayna kona.’ ");
INSERT INTO smkNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Say pa'sar ko, si'koy amigo na nin nubyo nin main rispunsibilidad nin mangisadya' nin sarba para sa kasal na. Abir nin sitin amigo nan nubyo ket ambo' yay makaikon konan nubya, alakin lamang a ririket na ta mangkarnge' nay pakapariga nan nubyo. Ket si'ko nin nangisadya' konra nin tutawo sa irarate' nan Cristo, alaki a ririket ko sawanin. ");
INSERT INTO smkNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Matkap a maita'gay ya, ket maikayupa' ako.” ");
INSERT INTO smkNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“O', si saya nin mangibwat sa langit, syay sangkata'gayan. Si saya nin mangibwat iti sa luta', bilang ya konran raruman tagadti sa luta', say irgwe-irgwen na say maipa'ka' iti sa luta'. Bale' si saya nin mangibwat ya sa langit, syay sangkata'gayan sa sarba. ");
INSERT INTO smkNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ibari-barita' nay na'kit tan narnge' na. Mataman bale' nin wanin, umno sara tamo' a mamper sa ibarita' na. ");
INSERT INTO smkNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ket saraynamaet a mamper kona, patutu'wan ra a say nibarita' nan Dios ket tutuo, ");
INSERT INTO smkNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ta say sarita' na mismo nin Dios a ibarita' nan sitin nibaki' na. Wanin ta konan sitin nibaki' na, mampiikapen nayan liso nin Dios a Ispirito na. ");
INSERT INTO smkNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wanin ta, si Dios a syay Ama, kawa'nan nayay Anak na, ket nipagamet na a sarba kona. ");
INSERT INTO smkNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ket, si si'numan a magmatalek konan Anak na, main ana nin anggan-angga nin byay na a iti konan Dios. Bale' si si'numan a kai nin tumulok konan Anak na, kasa yayti nin byay kona, no kai edet, dusawen naya anggan-angga nin Dios mangibwat sa alakin sager na.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Sawanin, naiparate' konran saray Pariseo a mangkakasagyat tan mampamawtismo yan mas abaw a tumutumbok na si Jesus dyan si Juan, ");
INSERT INTO smkNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","bale' say katutu'wan, ambo' nin si Jesus a mampamawtismo no kai saray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sin natandaan na ni Jesus a wanin a naiparate' konran Pariseo, nibwat ya sa Judea ta pigaw nin sumubli' ya sa Galilea, ");
INSERT INTO smkNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ket matkap a lumabas sara sa lulugar a sakop nan Samaria. ");
INSERT INTO smkNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ket nakarate' saradtaw sa Sicar, saya nin babali sa Samaria a adani sa luta' nin nibi na ni Jacob konan anak nan si Jose sin na'teng ana. ");
INSERT INTO smkNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Main itaw nin bubon nin kinali na intaw ni Jacob. Mapagal yayna si Jesus nin linmalako ta ugtiawro ana kanya' nin tinmekre' yadtaw sa dani nan bubon. ");
INSERT INTO smkNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Saray tumutumbok na anamaet, nako sara sa babali manaliw nin kanen ra. Sin sain, main nin babayi nin tagadtaw sa Samaria a nako manago'. Ket wana ni Jesus kona, “Kiinom ako pa?” ");
INSERT INTO smkNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“O', bale' saya ka nin Judio, ket ambale' ey nin kidawat kan inumen kongko a sayay babayi tan sayay tagadti sa Samaria?” wana nin ni'bat nin babayi. Wanin a wana bana' ta saray Judio, ket kai sara nin kibiang-biang konran taga Samaria. ");
INSERT INTO smkNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wanan ni'bat ni Jesus, “No tanda' mo tamo' kumon no ani a ibi nan Dios tan no si'no akoyti nin mangkidawat nin inumen komo, si'kayna edet kumon a kidawat kongko ket byan kata nin ranom a umagos tanan pirmi.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sin sain, wana nin babayi, “Ser, ararem yayti si bubon ket kasa anamaet nin ipanago' mo. Adti ka nin mangalap ey nin siin si ranom a umagos tanan pirmi? ");
INSERT INTO smkNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mas ata'gay ka et para dyan si puon tamon si Jacob? Sya a nami nin sitin bubon komi, tan iti ya nin nanago' tan saray a'nak na nin ininom ra tan saray uayep ra.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Inumbat ya si Jesus ket wana kona, “Si si'numan a minom nin saytin ranom, milata' ya li' anamanaet, ");
INSERT INTO smkNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","bale' si si'numan anamaet a minom nin ranom a ibi ko kona, kai yayna gapo nin milata'. Wanin ta si ranom nin ibi ko, mag'in nin bilang subor sa lalaman na a kai gapo nin ma'tyan a mami kona nin anggan-angga nin byay a iti konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ket wana nin babayi kona, “Ser, byan nako pa nin siin nin ranom ta pigaw nin kai akoyna gapo nin milata' ket kai koyna nin matkap a makodti et nin manago'.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wana ni Jesus kona, “Keen ma nin kayaban a asawa mo, mi'sa kamo nin sumubli' iti.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Kasa nin asawa ko,” wana nin babayi. Ket ni'bat na ni Jesus kona, “Kusto in si wamo a kasa nin asawa mo, ");
INSERT INTO smkNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta lima rayna a nag'in nin asawa mo, bale' siin si ka'yan mo sawanin ket ambo' ma nin asawa. Siin si nibarita' mo a kasan asawa mo ket tutuo ya.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sin sain, wana nin babayi, “Ser, madlaw ko a saya kamo nin mangingilalaman konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ani a kusto? Iti konan sitin talugtog, iti sara nangrayo konan Dios a pupuon mi, bale' si'kamo nin Judio, wamoyo a itaw sa Jerusalem a manepeg nin pangraywan konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sin sain, wana ni Jesus, “Madam, say katutu'wan, ambo' in a impurtanti. Tepren moyoytin ibarita' ko komoyo: Rumate' li' a panaon a ambo' ana nin konan sitin talugtog o sa Jerusalem a pangraywan ran tutawo konan Dios a syay Ama. ");
INSERT INTO smkNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Si'kamo nin taga Samaria sawanin, kurang a tanda' moyo maipa'ka' konan manraywen moyo, bale' si'kami, nipadar na komi a kadiryan nan si manraywen mi. O' ta tanda' tamo a mangibwat konran Judio a pangingisalba nan Dios konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ket say katutu'wan, rinmate' anay panaon a saray tutuon mangrarayo konan Dios a syay Ama ket ambo' nin sa sayay lugar raya nin raywen, no kai edet, raywen raya nin nangibwat sa kanakman ra nin naipatukdo' sa katutu'wan maipa'ka' sa kinasi'no na. Tutuoyti ta wanin a rabay nan Dios nin klasin pangrarayo kona. ");
INSERT INTO smkNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Dios ket ispirito ya, kanya' nin saray mangrayo kona, matkap a say pangrarayo ra ket nangibwat sa kanakman ra nin naipatukdo' sa katutu'wan maipa'ka' sa kinasi'no na.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wana nin babayi, “Tanda' ko a rumate' ya li' a Mesias, sitaw si tawagen nin Cristo. Ket no rumate' ya, ipatandaan na li' a sarba kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Si'ko nin mangkiirgo komo, si'ko ya in,” wana ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sin sain ket rinmate' saraynay tumutumbok na ni Jesus. Naka'ngap sara sin na'kit rayan mangkiirgo sa sayay babayi, bale' kasa gapo ni saya konra a nanepet kona no ani a rabay na konan babayi o no ambale' a mangkiirgo ya kona. ");
INSERT INTO smkNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sin sain anamaet, nibati' naya nin babayi a paya na tan sinmubli' ya sa babali. Wana konran tutawodtaw, ");
INSERT INTO smkNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mayi kamo kongko ta keen moya nin kiten taw si tawo nin nangibarita' kongko nin sarban gawa'-gawa' ko. Syayna palayi a mantawagen nin Cristo?” ");
INSERT INTO smkNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ket nibwat sara anaod a tutawodtaw sa babali ta mako saradtaw kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa leleg nadtaw nin babayi sa babali, saray tumutumbok na anamaet ni Jesus, wanraynan ni'nu-ni'no kona, “Maistro, mangan kamoyna.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bale' say ni'bat na konra, “Kai ana ta main nin kinnan ko nin kai moyo nin tanda'.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Konan siin, nitepetan saray tumutumbok na a wanra, “Main palayin nami nin kinnan na?” ");
INSERT INTO smkNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wana ni Jesus konra, “Siti a mangkanen ko, si tumulok ako sa karabayan nan namaki' kongko ket mayadi' a nipagwa' na kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Main yayti e si wamoyo, ‘A'pat a bulan tana ket pangyayatab ana li'.’ Sumadya' kamoyna! Kiten moyo saray tutawon man'umarak. Sara, man'iyarig kosara sa matua anan pari sa gagawa' ket matkap saraynan yataben. ");
INSERT INTO smkNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Man'upaan sarayna a mangyayatab. Ket, kiririket saray mangmumula nin minsahi nan Dios konran mangyayatab ta iyator rayna a yinatab ra a saray nakaga'mor nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma'kit a katutu'wan na sawanin nin si wanra a, ‘Sakalako a mangisabwag ket sakalako anamaet a mangyatab.’ ");
INSERT INTO smkNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wanin ta, si'ko, ibaki' katamo nin pa'sar mangyatab sa kai moyo nin kinapagalan, ket si'kamoy minabang sa kinapagalan ran raruma.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ket abaw sara a taga Samaria nin itaw konan siin nin babali a nagmatalek kona ni Jesus bana' sa wana nin babayi a nibarita' na nga'min ni Jesus a gawa'-gawa' na. ");
INSERT INTO smkNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bana' konan siin, sin nako saradtaw kona ni Jesus dinawat ra a itaw ya yapo'. Ket itaw ya yapo' anaod si Jesus nin rway awro. ");
INSERT INTO smkNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ket inmabaw sara et a nagmatalek kona ni Jesus bana' sa niyakay-akay na, ");
INSERT INTO smkNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tan wanra konan babayi, “Magmatalek kami ana, ambo' nin bana' tamo' sa nibarita' mo no kai edet, bana' ta narnge' miya ket tanda' mi nin sya a peteg nin Mangingisalba nin tutawo iti sa mundo.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Napalabas a rway awro nin itaw ya si Jesus sa Samaria, nibwat sarayna tan nituloy ray nako sa Galilea. ");
INSERT INTO smkNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mangyakay yadtaw lamang si Jesus mataman nin nibarita' nayna a wana, “Kasan rispito ra konan sayay prupita nin saray kalugaran na nin mismo.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wanin man, inako' rayadtaw nin saray taga Galilea sin rinmate' ya bana' ta nako saradtaw nin nikipista sa Jerusalem sin saytaw ket na'kit ra nga'min a ginwa-ginwa' na. ");
INSERT INTO smkNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sin itaw sarayna anaod, sinmubli' ya si Jesus sa Cana, si babali sa Galilea nin itaw ket ginwa' na nin arak a ranom. Main itaw nin sayay upisyal nin gubyirno a si anak nan lalaki ket itaw ya sa Capernaum nin main nin masakit na. ");
INSERT INTO smkNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sin narnge' nan sitin upisyal a rinmate' yadtaw sa Galilea si Jesus nin ibat sa Judea, nako ya kona tan nikidawat yan inganga'do nin mako ya sa Capernaum ta keen naya nin paandaen a anak nan mangkamati. ");
INSERT INTO smkNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ket anaod, wana ni Jesus kona, “Si'kamo nin tutawo, no kai kamo nin maka'kit nin makapaka'ngap nin pupaka'kitan, kai kamoynaod nin mamper.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ket wana nin upisyal, “Ser, panginga'do moyo ta tamoyna ba'yo ya nin mati a anak ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wana ni Jesus kona, “Mako kamoyna. Mabyay yaynaod a anak moyo.” Namper yay upisyal sa irgo na ni Jesus ket sinmubli' yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iti ya et a lamang sa dalan sin sumunor a awro, sinna' rayaynan ibabaki' na a wanra ket inmanda' yayna a anak na. ");
INSERT INTO smkNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ket tinepet na no ani a udas sin ginmana-gana a kaingaran na nin anak. Ni'bat ra kona, “Kinmayupa' a amot na sin bandan ala una naapon.” ");
INSERT INTO smkNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ket napanemtem na nin ama a sin sain nin udas na nin inirgo ni Jesus a wana, “Mabyay yaynaod a anak moyo.” Bana' ta wanin, sya tan saray sarba ran kabali na ket nagmatalek sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Siti a ikarwan ginwa' na ni Jesus nin pammatutuo nin maipa'ka' no si'no yan diri sin nako ya sa Galilea nin ibat ya sa Judea. ");
INSERT INTO smkNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kayadi' nin sain, main nin narate' a pista ran Judio ket tinmangkar ya si Jesus sa Jerusalem ta pigaw nin kipista ya. ");
INSERT INTO smkNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Itaw sa syudad, sa adani sa mantawagen nin Purta ra nin Karniro, main nin nakulong nin ranom nin paryuan a sa sarita' nin Hebreo ket mantawagen yan Betsata. Sa rigrig ket main nin lima ray sirungan. ");
INSERT INTO smkNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Sa sirong nin sayti ket nakaida' saray abaw nin main masakit, saray bulag, saray pilay tan saray paralitiko. ");
INSERT INTO smkNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Main itaw nin sayay lalaki nin mampagmasakit sa luob ana nin tulumpulo' tan waloy taon. ");
INSERT INTO smkNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sin na'kit naya ni Jesus tan sin natandaan na nin nakaida' yaynadtaw nin na'teng, wana kona, “Rabay mo para a umanda'?” ");
INSERT INTO smkNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wanan ni'bat nin si lalaki kona, “Ser, kasa bale' nin mangitaoy kongko sa ranom no nakimbor ana. Man'ipamuspusan ko tamo' et a manaoy ket main anan nakau'nan nanaoy.” ");
INSERT INTO smkNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wana ni Jesus kona, “Mibangon ka! Awiten ma in si idaan mo tan lumalako kayna.” ");
INSERT INTO smkNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ket tampor inmanda' yayna, inawit nayayna a idaan na tan linmalako yayna. Awron Painawa sin sain. ");
INSERT INTO smkNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kanya' nin saray pupangulo ran Judio wanra konan lalakin napaanda', “Sa Gugan-gan tamo, maiyawa' a awiten ma in si idaan mo ta sawanin ket Awron Painawa.” ");
INSERT INTO smkNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bale' wana nin inumbat, “Bale' wana nin si namaanda' kongko ket, ‘Awiten ma in si idaan mo tan lumalako kayna,’ ” wana. ");
INSERT INTO smkNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Si'no ya in ket a tawo si nangibarita' komo nin awiten ma in si idaan mo tan lumalako kayna?” wanran nitepet kona. ");
INSERT INTO smkNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bale' si tawo kai na nin tanda' no si'no yaytaw si namaanda' kona ta nakaibwat yaynan kai nin nadlaw si Jesus sa ka'bawan ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sinmunor, na'kit naya ni Jesus a lalakidtaw sa sakop nan Timplo ket wana kona, “Kikiten mo. Inmanda' kayna, ket andi' kayna nin magkasalanan ta bangli' no main nin mas duka' et nin rumate' komo.” ");
INSERT INTO smkNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nibwat yay lalaki tan nika' na nin nibarita' konran pupangulo ran Judio a si Jesus a namaanda' kona. ");
INSERT INTO smkNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Konan siin, tinaranaan rayaynan kuntrawen nin Judio si Jesus, bana' ta mampangwa' ya nin wanti sa Awron Painawa. ");
INSERT INTO smkNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sin wanin, wana ni Jesus konra, “Si Ama ko, kai ya gapo nin mantumgen nin gumwa', kanya' nin si'ko anamaet, kai ako nin mantumgen.” ");
INSERT INTO smkNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Konan siin, nalamu'nan a sulit ran Judio nin patyen raya si Jesus ta sa wanra ket kai na tamo' nin sinubag a Gugan-gan maipa'ka' sa Awron Painawa, no kai edet, nipada nay kadiryan na konan Dios sa nipanawag nan Ama kona. ");
INSERT INTO smkNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ket imbatan na ni Jesus in nin man'iparsa ra a wana konra, “Isipen moyoyti nin maong: Si'ko nin si Anak nan Dios, kasan magwa' kon gaw'en sa kabukudan ko tamo' no kai edet, say gaw'en ko tamo' ket say mangka'kit kon gaw'en na nin Ama ko. Animan a gaw'en na sain a gaw'en ko. ");
INSERT INTO smkNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wanin ta kawa'nan nakon Ama ko. Kanya' nin man'ipa'kit na nga'min kongko a man-gaw'en na tan main et li' nin gawa' nin ipapa'kit na kongko nin mas makapaka'ngap et dyan say ginwa' ko, ket peteg a maka'ngap kamo li'. ");
INSERT INTO smkNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bilang wadi', si Ama ko, pasublien nasaran mabyay a nati. Ket sain li' anamaet a gaw'en ko nin si Anak na ta pasublien kosara li' nin mabyay a rabay ko nin pabyayen. ");
INSERT INTO smkNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wanin et, si Ama ko, kai ya nin manintinsya nin si'numan, no kai edet, nipagamet nayna kongko nin Anak na a paninintinsya ");
INSERT INTO smkNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta pigaw nin say sarban tawo ket pagalangan rakon si Anak na a maikalamo' sa pammagalang ra konan Ama ko. Si si'numan a kai nin mamagalang kongko a si Anak na, kai naya anamaet nin mampagalangan a Ama ko a sya a namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Isipen moyoyti nin maong: Si si'numan a rumnge' tan mamper sa man'ibarita' ko nin nangibwat konan Dios a syay namaki' kongko, magkamain ya nin anggan-angga nin byay a iti konan Dios. Kai yayna nin masintinsyawan nin madusa, bana' ta say nikaisyay na kona nin Dios ket napalabas ana tan mabyay yayna anggan-angga nin iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Isipen moyoyti nin maong: Say sarban tutawo say pa'sar ket nati ana, bana' ta naisyay a sarba konan Dios. Bale' narate' anay panaon a mataman nin saray say pa'sar ra, ket nati ana ket marnge' ray irgo ko nin si Anak nan Dios. Ket saraytaw saray tumulok sa narnge' ra ket peteg a magkamain sara nin siin nin byay. ");
INSERT INTO smkNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wanin ta si Ama ko a puon nin byay. Ket wanin ako anamaet nin si Anak na bana' ta nangibwat kona a si'koy puon nin byay, ");
INSERT INTO smkNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","tan ginwa' na et nin si'kon si Anak na ket main nin kapangyadian ko nin manintinsya bana' ta pinaitawo ako. ");
INSERT INTO smkNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Andi' kamo nin mabigra' sa saytin nibarita' ko ta marate' li' a awro a sarba ran nati, marnge' ra a irgo ko, ");
INSERT INTO smkNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ket lumiwa' sara li' sa nanabunan konra. Saray nangwa' nin maabig, pasublien sara li' nin mabyay iti konan Dios, bale', saray nangwa' nin duka', pabyayen sara anamaet ket lumiwa' sara sa nanabunan konra bale' sintinsyawan sara nin madusa. ");
INSERT INTO smkNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kasa nin magwa' kon gaw'en nin kabukudan ko tamo'! Mampanintinsya ako nin dipindi sa man'ibarita' na kongko nin Ama ko. Kanya' nin say paninintinsya ko ket matunong bana' ta ambo' nin say karabayan ko a man'unuren ko no kai edet, say karabayan na nin Ama ko nin namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","No si'ko nin mismo tamo' a mamatutuo nin say maipa'ka' kongko, say ibarita' ko edet, kai nin tepren. ");
INSERT INTO smkNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bale' main ya a Ama ko nin mamatutuo sa maipa'ka' kongko, ket say ibarita' na, tutuo anaod. ");
INSERT INTO smkNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Main saraytaw anamaet intaw saray nibaki' moyo nin mako nin nangrenge' kona ni Juan ket pinatutu'wan na et a maipa'ka' sa no si'no ako. ");
INSERT INTO smkNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kai ko bale' nin matkap a pammatutuo ran tutawo sa maipa'ka' kongko, no kai ibarita' koyti say pammatutuo na ni Juan maipa'ka' kongko ta pigaw nin mamper kamo ket maisalba kamo. ");
INSERT INTO smkNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Maiyarig ya si Juan sa sayay tyo' a mandumta nin maslag ket maririket kamo intaw sa anted nin panaon a mangkapalawayan nay kukaisipan moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bale' main nin pammatutuo sa maipa'ka' kongko nin mas maksaw et dyan say nibarita' na ni Juan. Wanin ta say man-gaw'en ko a say nipagwa' na nin Ama ko, ket sain a mamatutuo a si'ko a nibaki' nan Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Si Ama ko anamaet nin nangibaki' kongko, syan diri a namatutuo nin say maipa'ka' kongko. Bale' si'kamo, kai moyo gapo nin narnge' a busis na tan kai moyo gapo na'kit a bakas na. ");
INSERT INTO smkNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Linmabas tamo' komoyo nin bilang nin siri a nibarita' na, ta kai moyoko nin akuen nin si nibaki' na. ");
INSERT INTO smkNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Man'adalen moyoynan man'adalen a Masanton Kasuratan sa pangngipa'ka' moyo anaod a mangibwat sa sayti ket magkamain kamon anggan-angga nin byay a iti konan Dios. Anta sayti nin kasuratan ket mamatutuo no si'no ako, ");
INSERT INTO smkNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","bale' andi' kamo nin adalen moyoy maipa'ka' kongko ta pigaw nin magkamain kamo kumon nin byay. ");
INSERT INTO smkNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kai ko nin tikapen a pagalangan rako nin tutawo, ");
INSERT INTO smkNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","laloyna a mangibwat komoyo ta tanda' koy kanakman moyo, a peteg a kasa nin pangangawa'nan moyo konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Alimbawa', si'ko, nako akodti nin pinakalalaman nan Ama ko, ket kai rako nin asikaswen. Bale' no main nin makodti nin ipata'gay nay lalaman nan diri, siin, asikaswen moya. ");
INSERT INTO smkNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pa'no kamo anaod nin magmatalek konan Dios ey? Say tikapen moyo ket say pangrarayo nin barang saya tan saya komoyo tan ambo' a say pangrarayo na komoyo nin sayan-saya nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wanin man, andi' moyo nin isipen a si'ko a mangiriklamo komoyo konan Ama ko, ta say nisurat na ni Moises nin sayti a mampagmatalkan moyo a mangwa' nin sain. ");
INSERT INTO smkNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kai moyo nin mantepren a nisurat na ta no peteg a mamper kamo sa nisurat na ni Moises, mamper kamo anamaet kumon kongko bana' ta maipa'ka' kongko a nisurat na. ");
INSERT INTO smkNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ket bana' anaod ta kai moyo nin tepren a nisurat na, pa'no moyo edet nin tepren a man'ibarita' ko ey?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mayadi' in, rinmipay ya si Jesus tan saray tumutumbok na nin nako sa rubari' na nin Taaw Galilea a mantawagen lamang nin Taaw Tiberias. ");
INSERT INTO smkNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pinasyan ka'bawan ran tutawo nin tumbu-tumbok konra bana' ta na'kit ray pammatutu-tutuo nin maipa'ka' kona sa nipamaanda' na konran main nin masakit. ");
INSERT INTO smkNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ket nuli' sara si Jesus sa purod tan tinmekre' saradtaw. ");
INSERT INTO smkNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Anaod, dandani ana sin sain a pista ran Judio a mantawagen nin Nipanglabas. ");
INSERT INTO smkNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ket kinmikit ya si Jesus tan na'kit nan pinasyan ka'bawan ran tutawo nin manrumate'. Ket wana kona ni Felipe, “Adti atamo kadi' mangalap nin kanen ran sarayti?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tanda' na ni Jesus no ani a gaw'en na bale' nitepet nayti ta pigaw nin subuken na no ani a i'bat na ni Felipe. ");
INSERT INTO smkNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wana ni Felipe, “Abir nin main wadi' nin ribu-ribo nin isaliw tamon tinapay ket kai nin makayadi' konra nga'min mataman no makapangan tamo' nin daite' a barang saya.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sin sain, wana nin saya konra nin tumutumbok na ni Jesus, si Andres a aryen na ni Simon Pedro, ");
INSERT INTO smkNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Main yayti e si anak a lalaki nin nibalon nin lima ray makapoy a klasi nin tinapay tan rwa ray kuna', bale' umno anayti ey sa ka'bawan ran sarain a tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Patekreen moyo sara,” wana ni Jesus konra nin tumutumbok na. Rarabot itaw ket itaw sara nin tinmekre' a tutawo. Saray lulalaki ket maglimanribo sarayna. ");
INSERT INTO smkNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kaaram, inagwang na ni Jesus a tinapay tan nikisalamat ya konan Dios. Mi'sa nipaitayak nayti konran tutawo. Wanin a lamang a ginwa' na sa kuna'. Binyan ra a barang saya nin say rabay na nin ka'baw. ");
INSERT INTO smkNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ket sin nabsoy anan nangan a sarba, wana ni Jesus konran tumutumbok na, “Dinepen moyo a natra' ta pigaw nin kai nin mapirdi.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wanin anaod a ginwa' ra ket nakapno' sara nin labinrway balyag sa natra' konran limay tinapay. ");
INSERT INTO smkNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sin na'kit ra anaod nin tutawoyti nin ginwa' na ni Jesus nin mamatutuo nin maipa'ka' kona nin diri, wanra, “Siti anan diri yaytaw si Prupita nin nipadles a makodti sa luta'!” ");
INSERT INTO smkNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bale' nadlaw na ni Jesus nin keen raya pwirsawen nin kalapen nin tutawo tan pasueten rayan gaw'en nin adi' ra. Kanya' nin nibwat ya nin bukod nin nakodtaw sa sayay purod. ");
INSERT INTO smkNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sin mandumedlem ana, nako saray tumutumbok na ni Jesus sa rigrig nin baybay. ");
INSERT INTO smkNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yabi ana ket kai ya et nin nikisna' konra si Jesus kanya' nin rinmuran sarayna sa baluto nin mako sa Capernaum. ");
INSERT INTO smkNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sin sain, inmarubuob ket inmalalaki a daluyon. ");
INSERT INTO smkNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sin nakasaki saraynan man'ibugsay rayay baluto ra nin angangko lima o a'nem a kilumitroy kaday'an, na'kit rayan man'umarak si Jesus a manlumalako ya sa babo nin ranom. Ket pinasyan li'mo ra. ");
INSERT INTO smkNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bale' wana ni Jesus konra, “Si'koyti, andi' kamo nin mali'mo!” ");
INSERT INTO smkNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ket pinasyan ririket ra nin pinaruran raya si Jesus sa baluto; ket kapingmatan iti sarayna sa abay itaw sa lugar a keen ra. ");
INSERT INTO smkNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kinabuklasan, saray tutawo nin nabati' itaw sa rubari', mapanemtem ra a saya tamo' intaw a baluto sa abay itaw tan tanda' ran kai raya nin kalamo' si Jesus nin tumutumbok na, ta sarayti tamo' a rinmuran konan si baluto. ");
INSERT INTO smkNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sin sain, main nin umno ran baluto nin ibat sa Tiberias a dinmuong itaw sa dani nan si lugar a nanganan ran tinapay nin tutawo mayadi' ya nin nikisalamat si Uunuren a Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ket bana' ta na'kit ran abaw nin tutawo a kasa yadtaw si Jesus tan wanin sara anamaet a tumutumbok na, rinmuran sarayti sa baluto tan nako sara sa Capernaum ta pigaw nin tikapen rayadtaw si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ket sin nadumog rayadtaw si Jesus sa rubari' nan taaw, wanra nin nitepet, “Maistro, pa'no kamon nakarate' iti? Tiningkap mika.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ket si wana nin ni'bat ni Jesus, “O', mantikapen rako anaod. Sawanin, isipen moyoyti nin maong: Say rason a mantikapen rako ket si nangan kamo nin tinapay ket nabsoy kamo, ambo' nin bana' ta nataros moyoy pipa'kaan nin makapaka'ngap nin nunangyadi' a nabantayan moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Matkap a ambo' a ikabyay nin masida' a tikapen moyo, no kai edet, say ikabyay nin misyon komoyo a sayti ket mami nin anggan-angga nin byay a iti konan Dios. Ket si makapami komoyo nin sain nin ikabyay ket si'kon si Pinaitawo a pinatutu'wan nan Dios a syay Ama ko nin pinili' nako.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Konan siin, wanran nitepet kona, “Ani ey a gaw'en mi nin akuen nan Dios ta pigaw nin matingkap mi in?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ket wanan ni'bat ni Jesus, “Siti a matkap moyon gaw'en nin ipagwa' nan Dios komoyo: Magmatalek kamo kongko nin si nibaki' na.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ket wanra anamanaet nin nitepet, “Ani a paka'kitan a maipa'kit mo komi ta pigaw nin tepren mi a man'ibarita' mo? Ani a gaw'en mo? ");
INSERT INTO smkNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Anaod, pinakan saran manna a pupuon mi sin itaw sara nin manlumalako sa lugar a kasan tawo tan siin lamang a mabasa sa Masanton Kasuratan a wana, ‘Pinakan nasara nin ikabyay nin ibat sa langit.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Inumbat ya si Jesus a wana, “Isipen moyo nin maong a kasan mabasa a si Moises a nami komoyo nin sain nin ikabyay nin ibat sa langit no kai edet, si Ama ko a mampami komoyo nin peteg nin ikabyay nin ibat sa langit. ");
INSERT INTO smkNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wanin ta si peteg nin ikabyay a ibi nan Dios, ket sitaw si kinmayupa' nin ibat sa langit a mami nin byay konran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ket konan siin wanra nin tutawo, “Ser, lawas nin byan rakami pa edet nin siin nin ikabyay.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wana ni Jesus nin nipapalaway, “Si'ko a ikabyay a mami nin peteg nin byay. Ket, si si'numan a umarak kongko nin magmatalek ya, mapda' yan liso a bilang kai yayna gapo nin gumitil o milata'. ");
INSERT INTO smkNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bale', bilang sa nibarita' koyna komoyo nin gindat, si'kamo, abirno nin na'kit moyoyna a paka'kitan nin ginwa' ko, kai kamo et a lamang nin magmatalek. ");
INSERT INTO smkNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Si'no sara man a italek na nin Ama ko kongko, umarak sara kongko. Si umarak kongko anamaet, kai koya gapo nin andian. ");
INSERT INTO smkNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","O', wanin a karabayan nan Ama ko tan kinmayupa' akon ibat sa langit ambo' ta pigaw nin gaw'en koy no ani a rabay ko, no kai edet, say rabay na nin si namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ket say rabay na nin Ama ko a syay namaki' kongko ket si kasan maisyay kongko konran nitalek na kongko, no kai edet, pasublien kosara li' nin mabyay kona sa suyot nin awro. ");
INSERT INTO smkNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","O', rabay na nin Ama ko a saray makatanda' rako tan magmatalek sara kongko ket magkamain sara nin anggan-angga nin byay a iti kona. Ket, si'kon diri a mamasubli' nin mabyay li' konra kona sa siin a suyot nin awro.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bere-bere saray Judio konan sitaw si wana ni Jesus a sya a ikabyay nin ibat sa langit. ");
INSERT INTO smkNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wanra, “Ambo' para a si Jesus yayti nin anak na ni Jose? Tanda' tamo saran peteg a matua na. Ambale' a wana ket kinmayupa' yan ibat sa langit?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kanya' nin wana ni Jesus konra, “Andi' kamo nin miiirgo nin mianas-anasan. ");
INSERT INTO smkNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No kai naya nin inayat a sayay tawo nin Ama ko nin si namaki' kongko, kasa nin si'numan a umarak kongko nin mamper. Ket, saray umarak kongko ket pasublien kosara li' nin mabyay konan Dios sa suyot nin awro. ");
INSERT INTO smkNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wanin ta main yayti e si mabasa sa nisurat ran prupita a wana, ‘Saray sarba ra nin tawo na ket iyakay nasaran Dios.’ Ket si'no sara man a mangrenge' sa wana nin Ama ko ta pigaw nin makaadal sara kona ket sara a umarak kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ambo' nin rabay kon ibarita' ket main ana nin naka'kit kona nin Dios a Ama, bana' ta kasa et gapo nin naka'kit kona no kai si'ko tamo' nin nangibwat kona. ");
INSERT INTO smkNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Isipen moyoyti nin maong: Si magmatalek kongko, main anan anggan-angga nin byay na a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wanin ta si'ko a ikabyay a mami nin peteg nin byay. ");
INSERT INTO smkNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Saray pupuon moyo, nangan sara nin manna sin itaw sara nin manlumalako sa lugar a kasan tawo, wanin man nati saran lamang. ");
INSERT INTO smkNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bale' si ikabyay nin man'ibarita' ko komoyo sawanin, si peteg nin ikabyay nin ibat sa langit. Si mangan nin sitin ikabyay, kai ya gapo nin mati. ");
INSERT INTO smkNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ket si'kon diri ya in si ikabyay a mami nin peteg nin byay nin ibat sa langit. Si si'numan a mangan nin sitin ikabyay, mabyay ya anggan-angga. Ket siti nin ikabyay, sya a lalaman ko nin ibi ko li' ta pigaw nin saray tutawodti sa mundo ket mabyay sara.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Konan siin nididiskusyon saray Judio a wanra, “Pa'no na kadi' nin ibi a lalaman nan siin a tawo ta pigaw nin kanen tamo?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sin sain, wana ni Jesus, “Isipen moyoyti nin maong: No kai moyo nin kanen a lalaman ko nin si Pinaitawo tan kai moyo nin inumen a daya' kon tumuro', kasa komoyo a manustini nin byay ");
INSERT INTO smkNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ta saray mangan nin lalaman ko tan minom nin daya' ko, sara a main nin anggan-angga nin byay a iti konan Dios, tan sara anamaet a pasublien ko li' nin mabyay konan Dios sa suyot nin awro. ");
INSERT INTO smkNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wanin bana' ta si lalaman ko, syay tutuo nin ikabyay tan say daya' ko, sya a tutuo nin inumen. ");
INSERT INTO smkNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ket, si mangan nin lalaman ko tan si minom nin daya' ko, misyon ya lawas kongko, tan si'ko kona. ");
INSERT INTO smkNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kapada a main nin byay kon nangibwat konan si sibibyay a Dios nin nangibaki' kongkodti, main nin byay na nin mangibwat kongko nin si mangan kongko ");
INSERT INTO smkNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ta si'ko a tutuo nin ikabyay nin ibat sa langit. Naiduma yaytin ikabyay sa kinnan ra nin pupuon moyo sin saytaw, ta saray nangan sin saytaw, nati sara nin lamang, bale' si mangan kona nin sitin tutuon ikabyay, mabyay ya anggan-angga.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nibarita' nayti nga'min ni Jesus sin nangyakay ya sa sinaguga itaw sa Capernaum. ");
INSERT INTO smkNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Edet, sin saraytaw saray mantumumbu-tumbok kona ket narnge' rayti nin nibarita' na, wanra nin ka'bawan konra, “Mabyat in say man'ibari-barita' na. Kasa gapo nin mamper sa sain.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tanda' na ni Jesus a bere-bere saran mampianas-anasan a tumutumbok na maipa'ka' sa sayti kanya' nin wana, “Bana' para sa nibarita' kon si mangan nin lalaman ko tan si minom nin daya' ko ket marmay kamoyna kongko? ");
INSERT INTO smkNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ani ana li' a pakataros moyo konan siin no ma'kit moyo nin si'kon si Pinaitawo ket muli' akoynan sumubli' sa ibwatan ko? ");
INSERT INTO smkNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Si Ispirito nan Dios a mampami nin byay. Kasan kausaran nan lalaman sa sayti, no kai edet, say man'ibari-barita' ko komoyo a main nin kausaran. Sayti ket ibat konan Ispirito tan mami nin byay. ");
INSERT INTO smkNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bale' main sara komoyo a kai ra nin akuen a man'ibari-barita' ko,” wana ni Jesus. Nibarita' nayti bana' ta tanda' nayna nin gindat no si'nu-si'no saray kai nin mamper kona tan no si'no li' a magtraidor kona. ");
INSERT INTO smkNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wana et nin nituloy ni Jesus, “Siin a rason no ambale' a nibarita' ko komoyo a kasa nin si'numan a umarak kongko no kai na nin pangibwaten nin Ama ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ket nangibwat ana sin sain, abaw sara konran saray mantumumbu-tumbok kona a ginmurot ana kona tan kai rayna nin nituloy a nayi kona. ");
INSERT INTO smkNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kanya' nin konan siin wana ni Jesus konran labinrwan tumutumbok na, “Ket sawanin, lumakwan kamoyna anamaet para?” ");
INSERT INTO smkNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ket inumbat ya si Simon Pedro a wana, “Catawan, kasaynan raruma et nin unuren mi. Si'kan diri a mampag'irgo nin say susarita' a mami nin anggan-angga nin byay a iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Si'kami, mampagmatalek kami komoyo ta kasa gapo nin dwadwa nin maalilbi' mi a si'kamo a Masantos nin nibaki' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wana ni Jesus, “Si'ko a namili' komoyo nin labinrwa, ambo' para nin wanin? Wanin man, si saya komoyo ket kaayon nayan Dimunyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si man'ibarita' na ket si Judas a anak na ni Simon Iscariote, a mataman nin saya ya konra nin labinrwan tumutumbok na, sya et a lamang li' a magtraidor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Say sinmunor sin nayadi' in, kina'-kina' na ni Jesus a lulugar sa intiron prubinsyan Galilea. Pinal'isan nay nako sa Judea ta saray pupangulo ran Judio nin itaw ket masulit sara nin patyen raya. ");
INSERT INTO smkNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Anaod, dandani ana sin sain a pista ra nin Judio a mantawagen nin Pista nin Abung-abong. ");
INSERT INTO smkNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ket saray bubsat na ni Jesus wanra kona, “Umalis kadti tan mako ka sa Judea ta pigaw nin ma'kit ran tumutumbok modtaw a makapaka'ngap nin man-gaw'e-gaw'en mo, ");
INSERT INTO smkNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ta si tawon mampangapes a mag'in yan bantog, kai na nin iyadi a man-gaw'e-gaw'en na. Anaod ta mampangwa' ka nin makapaka'ngap a bubagay, ipadar moyna ah, ta pigaw nin matandaan sa intiro nin mundo!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wanra in nin bubsat na ni Jesus ta mataman nin sara ket kai nin mamper kona. ");
INSERT INTO smkNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wana ni Jesus konra, “Kai et nin narate' a kuston panaon ko para sa wanin. Mako kamoyna ta magwa' moyoy mako abirno nin ani a udas. ");
INSERT INTO smkNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kasa nin prublima komoyo bana' ta saray iti konan sitin mundo, ket kasan puon ran guraen rakamo, bale' si'ko, gura' rako bana' ta mampatutu'wan ko a say man-gaw'e-gaw'en ra ket duka'. ");
INSERT INTO smkNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sigi, mako kamo nin kipista bale' si'ko, kai ako nin mako bana' ta kai et nin narate' a kuston panaon para kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sin naibarita' nayna in ni Jesus, pinaibati' yadtaw sa Galilea. ");
INSERT INTO smkNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nibwat sarayna anaod a bubsat na ni Jesus. Ket, nako ya anamaet sa pista nin kasan nakatanda'. ");
INSERT INTO smkNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sin sain, tikap saraynan tikap kona a pupangulo ran Judio sa pista, nin tepet saraynan tepet no adti ya. ");
INSERT INTO smkNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Saray abaw a tutawo anamaet mianas-anasan saran mampag'iirgo maipa'ka' kona. Wanra nin raruma, “Maong yan tawo.” Bale' saray raruma anamaet wanra, “Kai pa ta man'ibarang nasaray tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wanin man, kasa gapo nin nag'irgo maipa'ka' kona nin main nin nakarnge' bana' ta mali'mo sara konran pupangulo ra. ");
INSERT INTO smkNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sin iti ana sa kapikngaan a pista, nako yadtaw sa sakop nan Timplo si Jesus nin nangyakay ya. ");
INSERT INTO smkNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ket naka'ngapan raya nin saray pupangulo ran Judio a wanra, “Adti ket nin ibat in nin pakatanda' nan siin nin tawo? Ambo' ya anamaet nin di-adal nin bilang komi!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Konan siin, imbatan nasara ni Jesus a wana konra, “Sayti say man'iyakay ko, kai nin nangibwat kongko no kai edet, konan Dios a syay namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Si si'numan a magdisidido nin gaw'en na a no ani a rabay nan Dios, sya a maka'kit no say man'iyakay ko ket nangibwat konan Dios, o kaisipan ko tamo' nin diri. ");
INSERT INTO smkNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wanin ta si saya nin mampag'irgo nin nangibwat sa kaisipan na tamo' nin diri ket, man'apesen na nin mag'in ata'gay a pangingikit kona. Bale', si sayay tawon tikapen na a mapagalangan yay namaki' kona, say man'ibarita' na ket pulos nin katutu'wan ta kasa gapo nin pibula'-bula' kona. ");
INSERT INTO smkNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kai moyo para nin tanda' a Gugan-gan nin nibi na ni Moises? Sain a rabay nan Dios ket kasa gapo komoyo a mampanukid. Kikiten moyo, man'iplano rakon patyen!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Inumbat sara a tutawo a wanra, “Nasrepan ka nin ispiriton duka'! Si'no wadi' a marabay nin mangmati komo?” ");
INSERT INTO smkNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Konan siin wana ni Jesus, “Nagtrabaho ako a namaanda' akon ni'sa sa sayay Awro nin Painawa, ket nabigra' kamoyna nga'min. ");
INSERT INTO smkNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bale', magtrabaho kamo a turien moyo sara anamaet lamang a a'nak moyon lulalaki sa Awron Painawa. Wanin ta main ya in nin nigan-gan na komoyo ni Moises a naimatawan nayna anaod konra et nin saray pupuon na. ");
INSERT INTO smkNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","No gaw'en moyo in abirno nin Awron Painawa sa tana a matukid a nigan-gan na ni Moises maipa'ka' tamo' sa sayay parti nan lalaman, ambale' ey a masager kamo kongko ta namaanda' ako sa Awron Painawa ta pigaw nin si intiro nin lalaman na ket napaanda' ya? ");
INSERT INTO smkNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Andi' kamo nin manintinsya nin naipatukdo' sa pangingikit moyo tamo' no kai edet, adalen moyo yapo' nin kusto a bubagay ta pigaw nin sa katunungan a paninintinsya moyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sin sain, main saray taga Jerusalem a wanra, “Ambo' para a syayti si tawon rabay ra nin patyen? ");
INSERT INTO smkNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ket e! Iti ya nin mampag'irgo nin kasan dangka' sa adapan ran abaw a tutawo. Saray pupangulo anamaet, kai sara gapo nin mangkumuntra kona. Peteg palayi nin alilbien ra a syayna a Cristo? ");
INSERT INTO smkNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bale', kai nin magwa', ta no rumate' yay Cristo, kasa kano nin makatanda' nin pangibwatan na. Bale' sitin tawo, tanda' tamo nin peteg a ibwatan na.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sin sain, nipaksaw na ni Jesus a busis na nin mampangyakay itaw sa sakop nan Timplo a wana, “Wamoyo a tanda' rako tan tanda' moyo a ibwatan ko. Wanin man, say katutu'wan anamaet lamang, kai nin nangibwat kongko a kappika' kodti, no kai edet, main nin namaki' kongko a sya tamo' a tutuo. Si'kamo, kai moya nin tanda'! ");
INSERT INTO smkNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Si'ko bale', tanda' koya bana' ta nangibwat ako kona, tan sya anaod a namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Konan siin a nibarita' na ni Jesus, niplano ra nin dakpen ya, bale' kasa nin nanakep kona bana' ta kai et nin narate' a udas a mati ya nin pakatukid nin plano nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bale' konra nin saray abaw a tutawo, abaw sara a nagmatalek kona ni Jesus, ta wanra, “Ambo' yayti et para a rumate' nin Cristo? Kasayna angangko nin makagwa' et nin mas abaw a mumilagro nin paka'kitan dyan say man-gaw'en nan siti.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sin narnge' ra nin Pariseoyti nin man'ibari-barita' ra nin tutawo, sara tan saray Pupangulon Pupadi', namaki' sara nin gwardya sa Timplo nin keen raya nin dakpen si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ket sin sain, wana ni Jesus, “Makalamo' rako tana sa anted a panaon, mi'sa sumubli' akoyna konan namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Marate' li' a tikapen rako bale' kai rako nin madumog bana' ta itaw sa kami'nan ko ket kai kamo nin makapika'.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Konan siin, wanra nin pupangulo ran Judio sa saya tan saya, “Adti ya kadi' nin makoytin tawo nin kai tamoya kano nin ma'kit? Mako ya palayi sa adayo' nin lulugar nin kami'nan ran kapada tamon Judio ta pigaw nin mangyakay ya konran ambo' nin Judio? ");
INSERT INTO smkNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ani kadi' a pipa'kaan nin saytaw say wanan tikapen tamoya li' bale' kai tamoya nin madumog, tan sa kami'nan na ket kai atamo nin makapika'?” ");
INSERT INTO smkNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sin sangkasuyutan anan awro nin Pistan Abung-abong a syay sangkaimpurtantiwan nin awro, inumdeng ya si Jesus tan nipaksaw na a busis na a wana, “Si si'numan nin milata', umarak ya kongko ta pigaw nin minom ya. ");
INSERT INTO smkNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wanin a mabasa sa Masanton Kasuratan a wana, ‘Si si'numan a magmatalek kongko, mag'in yan bara'mon subor nin ranom ta lumiwa' kona a pa'sar ranom a makapami nin byay.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Si man'ibarita' nadti ni Jesus ket, si Ispirito nan Dios nin ibaki' na li' konran saray magmatalek kona. Kai ya et nin nibaki' konra, ta kai ya et nin nipata'gay tan pinagalangan si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Main konran saray nakarnge' sa saytin wana ni Jesus a namarita', “Peteg a siti ana a mantaga'nan nin Prupita!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Saray raruma anamaet wanra, “Syayti ana a Cristo.” Bale' saray raruma et wanra, “Impusibli in! Kai ya nin mangibwat sa Galilea a Cristo! ");
INSERT INTO smkNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","O', ta main nin mabasa sa Masanton Kasuratan a wana si sya a Cristo ket, mangibwat ya sa puri na ni David tan itaw ya nin maiyanak sa Betlehem a babali na ni David.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kanya' anaod nin, niduduma a pangngipa'ka' ra nin tutawo kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Main sara anamaet a marabay nin dakpen raya, bale', kasa nin nanakep kona. ");
INSERT INTO smkNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sin wanin, saraytaw saray gwardya sa Timplo ket sinmubli' sarayna sa kami'nan ra nin Pupangulon Pupadi' tan Pariseo. Ket inusisa' rasara, “Mayin a kai moya nin ni'ras iti?” wanra. ");
INSERT INTO smkNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ket ni'bat ra nin gwardya, “Kasa gapo nin makakipada konan sitaw nin tawo sa pakayadi' nin pag'iirgo na!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tinuya'-tuya' rasaran Pariseo a wanra, “Pati si'kamo para ket naulaw na anamaet? ");
INSERT INTO smkNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Main ana para nin tanda' moyon pupangulo o konran Pariseo nin mampagmatalek kona? Kasa gapo! ");
INSERT INTO smkNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kiayi kamo konran sarain nin ambo' nin di-adal; kasan tanda' ran sarain maipa'ka' sa Gugan-gan tamon Judio. Mirisi moyo!” ");
INSERT INTO smkNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Si saya konran Pariseo nin itaw sin sain ket si Nicodemo a sya nako ya intaw kona ni Jesus. Wana konran kalalamo' na, ");
INSERT INTO smkNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ibarita' sa Gugan-gan tamo a kai tamoya magwa' nin sintinsyawan a sayay tawo nin kai tamoya yapo' nin usisaen. Matkap a magkamain ya yapo' nin pagkanawanawa nin umbat ta pigaw nin ma'kit tamo no ani a kasalanan na. Ambo' para nin wanin?” ");
INSERT INTO smkNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Konan siin ni'bat ra kona, “Bara'mo ka anamaet nin saray taga Galilea! Keen mo nin adalen a Masanton Kasuratan ta pigaw nin matandaan mo a kasa nin prupita a mangibwat sa Galilea.” ");
INSERT INTO smkNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kayadi' nin sain, nagsiugot anay barang saya sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Si Jesus bale', nako ya sa Talugtog nin Olibo. ");
INSERT INTO smkNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Masakbay et sin kabuklasan, nako ya anamanaet itaw sa sakop nan Timplo ket inaribungbungan rayan tutawo. Konan siin, tinmekre' ya ket niyakay nasara. ");
INSERT INTO smkNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sin sain, rinmate' saray Madudunong sa Gugan-gan tan saray Pariseo a main nin awit ran sayay babayi nin nadakep nin mangkilalaki. Pina'deng rayayti sa adapan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mi'sa wanra kona ni Jesus, “Maistro, sitin babayi, nadakep ya nin mangkilalaki. ");
INSERT INTO smkNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Man'ibarita' sa Gugan-gan nin nibi na ni Moises a say wanti nin babayi ket matkap yan kudasen nin bato anggan mati ya. Si'ka pa, ani a disisyon mo?” ");
INSERT INTO smkNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wanin a wanra ta pigaw nin kal'uten raya si Jesus, ta mangibwat wadi' sa ubat na ket, main nin maiparsa ra kuntra kona. Bale', dinmukot ya si Jesus tan nanurat ya sa luta' a inusar nay garamay na. ");
INSERT INTO smkNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kai raya nin tegnan nin tepetan si Jesus, kanya' nin inumdeng ya tan wana konra, “Si si'numan komoyo a kasa nin kasalanan na, sya a mu'na nin mangudas kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mi'sa dinmukot ya anamana tan nanurat ya sa luta'. ");
INSERT INTO smkNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ket, sin narnge' raya in a wana ni Jesus, saya-saya sara nin nibwat a tinmarana' konran sangkasikenan. Ket kasa nin nabati' itaw no kai si Jesus tana tan si babayi nin itaw et nin naka'deng. ");
INSERT INTO smkNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ket inumdeng yayna si Jesus, tan wana konan babayi, “Arikong, adti saraynaytaw? Ya, kasa nin nabati' ni sayan manusa komo?” ");
INSERT INTO smkNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Kasa, Ser,” wana nin babayi. “Kai kata anamaet nin dusawen,” wana ni Jesus. “Sigi, mako kayna, bale' tegnan moynay pagkakasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mi'sa anamanaet, nag'irgo ya si Jesus konran tutawo a wana, “Si'ko a palaway nin mamalaway konran tutawodti sa mundo. Si'numan a mag'in nin tumutumbok ko, kai ya nin lumalako sa kadedleman ta main ya kona a palaway a mami nin byay.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sin sain, wanra nin Pariseo kona, “Si'kan bukod a mampagtistigos maipa'ka' sa lalaman mon diri. Ket sain say man'ibari-barita' mo kai magwa' nin tepren.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ket wana nin inumbat ni Jesus, “Abirno nin mampag'irgo ako nin pammatutuo maipa'ka' kongko nin diri, say man'ibarita' ko bale' ket tutuo, bana' ta tanda' ko no adti ako nin ibat tan no adti a keen ko. Bale' si'kamo, kai moyoyti nin tanda' nin maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Si'kamo, manintinsya kamo nin nipatukdo' moyo sa panunukat nin tawo tamo'! Si'ko bale', kai ako nin manintinsya nin si'numan. ");
INSERT INTO smkNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bale' no bilang wadi' a manintinsya ako, say paninintinsya ko ket kusto ta ambo' kon bukod a manintinsya, no kai edet, main nin kalamo' ko, si Ama ko a syay namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sa Gugan-gan moyo wana et a say pammatutuo ran rwa ray tistigos ket matkap a akuen. ");
INSERT INTO smkNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ket anaod, si'ko, patutu'wan koy maipa'ka' kongko nin diri tan patutu'wan na anamaet nin Ama ko nin namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ket konan siin nitepet ra kona, “Adti ya ket a Ama mo?” Inumbat ya si Jesus a wana, “Kai rako et nin katanda' nin peteg tan kai moya anamaet nin katanda' a Ama ko. No katanda' rako kumon, wanin moyo anamaet konan Ama ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nibarita' nayti ni Jesus sin itaw ya nin mampangyakay sa sakop nan Timplo, itaw sa bandan pangangwan nin da'ton. Bale' kasan nanakep kona ta kai et nin narate' a udas a mati ya nin pakatukid nin plano nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Wana anamanaet ni Jesus konra, “Si'ko, lumakwan akoyna li' ket, tikapen rako. Bale', mati kamo nin awit moyoy kasalanan moyo, ta sa keen ko, kai kamo nin makapika'.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Konan siin wanra nin panuya'-tuya' kona nin saray Judio, “Wana, kai atamo kano nin makapika' sa keen na. Mipati ya palayi?” ");
INSERT INTO smkNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Inumbat ya si Jesus a wana, “Si'kamo, taga kamodti sa luta', ket iti a kukaisipan moyo. Bale' si'ko, ambo' akon tagadti, no kai edet, itaw sa ta'gay ket naiduma a kaisipan ko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kanya' nin nibarita' ko komoyo a mati kamo nin awit moyoy kasalanan moyo. Mati kamoynaod nin awit moyoy kasalanan moyo no kai moyo nin akuen a ‘Si'ko yay si Main Anggaynan-angga.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Si'no ka ket?” nitepet ra kona. Ni'bat na ni Jesus, “Si'ko yaytaw si man'ibarita' koyna komoyo nangibwat et sin saytaw sin tarana'. ");
INSERT INTO smkNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No maipa'ka' komoyo, abaw a magwa' kon ibarita' nin kuntra tan ipakasalanan komoyo. Wanin man, say man'ibari-barita' ko tamo' konran tutawodti sa mundo ket saytaw say narnge' ko kona nin si namaki' kongko. Wanin ta tutuo anaod a man'ibarita' na.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kai ra nin nataros a mampag'irgo ya nin maipa'ka' konan Ama, ");
INSERT INTO smkNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","kanya' nin wana ni Jesus, “No saytaw li', no si'kon si Pinaitawo ket nikwa moyokoyna itaw sa ta'gay nin kudos, matandaan moyoyna li' a ‘Si'ko yay si Main Anggaynan-angga’. Matandaan moyo anamaet a lamang a kasa nin man-gaw'en ko sa kabukudan ko tamo'; say man'ibarita' ko tamo' ket say man'iyakay na kongko nin Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kalamo' koya anamaet a syay namaki' kongko ta kai nako gapo nin linakwanan bana' ta lawas nin man-gaw'en ko no ani a makapaririket kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ket abaw sara konran saray nakarnge' sa sain nin nibarita' na a namper kona. ");
INSERT INTO smkNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Edet, wana ni Jesus konran Judio nin namper kona, “No ituluy-tuloy moyoy sumunor sa man'ibarita' ko, peteg a tumutumbok katamo, ");
INSERT INTO smkNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ket matandaan moyo no ani a katutu'wan. Ket say katutu'wan, galten kamo sa pakaaripen.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Konan siin wanra, “Puri nakami ni Abraham, ket kai kami et gapo nag'in nin aripen nin si'numan. Ambale' a wamo nin galten kami sa pakaaripen?” ");
INSERT INTO smkNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Wana nin inumbat ni Jesus, “Isipen moyoyti nin maong: Si si'numan a mampagkasalanan ket aripen ya nin kasalanan. ");
INSERT INTO smkNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wanin man, si sayay aripen, magwa' nin masilyan a kapapa'sar na sa sayay pammali. Si sayay anak bale', magnayon ya nin anak nan ama na. ");
INSERT INTO smkNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Edet, no si'ko nin si Anak nan Dios ket galten katamo sa pakaaripen, peteg a ambo' kamoyna nin aripen. ");
INSERT INTO smkNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Alilbien koyna a puri nakamo ni Abraham. Wanin man, ambo' kamon bilang kona ta main iti komoyo a rabay rako nin patyen bana' ta kai moyo nin man'akuen a man'ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Say man'ibarita' ko ket say na'kit ko konan Ama ko. Ket kipada sa wanin anamaet a man-gaw'en moyo, ta si'kamo, mansunuren moyoy wanan si ama moyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Konan siin inumbat sara a Judio a wanra, “Peteg a si Abraham a ama mi!” Bale' wana ni Jesus, “No peteg anaod a a'nak nakamo ni Abraham, arigen moyo kumon a ginwa' na. ");
INSERT INTO smkNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bale' si'kamo, man'ipamuspusan moyo a patyen rako mataman no mampamarita' ako komoyo nin katutu'wan a narnge' ko konan Dios. Kasa gapo nin wanin a ginwa' na ni Abraham. ");
INSERT INTO smkNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Say man'arigen moyo ket say gawa' nan ama moyo.” “Si Dios a peteg nin Ama mi ta sya tamo' a mansunuren mi! Ambo' kamin a'nak sa rikor!” wanra. ");
INSERT INTO smkNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wana ni Jesus konra, “No peteg nin si Dios a Ama moyo, kawa'nan moyoko kumon bana' ta, si'ko, kapada koya tan itaw ako nin nangibwat kona. Ambo' nin nangibwat kongko a mako akodti no kai edet, kona nin syay nangibaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ambale' a kai moyo nin tarusan a man'ibarita' ko? Bana' anaod ta kai moyo rabay nin akuen a man'ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kapada nakamo nin si ama moyo a si Dimunyo, tan say gagara moyo ket say sunuren moyoy karabayan nan siin a ama moyo. Mangmamati yayna nangibwat et sin tinmarana' yan mabyay. Kasa gapo nin kabiangan na sa katutu'wan ta kasan katutu'wan iti kona. No mibula'-bula' ya, bagay kona bana' ta talagan mabula' ya tan sya a puon nin kabulaan. ");
INSERT INTO smkNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bale' si'ko, say man'ibarita' ko komoyo ket say katutu'wan, kanya' nin kai rako nin tepren. ");
INSERT INTO smkNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Main para nin iti komoyo nin makapamatutuo a main nin ginwa' ko nin kasalanan? Kasa! Wanin anaod ta katutu'wan a man'ibarita' ko. Ambale' a kai rako nin tepren? ");
INSERT INTO smkNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Saray ikon nan Dios, reng'en tan tukiden ra a wana konra. Bale' si'kamo, kai kamo nin rumnge' bana' anaod ta ambo' nakamo nin ikon.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Konan siin, wanra nin Judio, “Kuntrabida ka! Nasrepan kan ispiriton duka'!” ");
INSERT INTO smkNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Kai ako nin nasrepan nin ispiriton duka' no kai edet, mampagalangan koyay Ama ko,” wanan inumbat ni Jesus. “Wamoyo a syay ama moyo anamaet, mayin edet a kai rako nin mampagalangan? ");
INSERT INTO smkNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wanin man, kai ako nin mampaningkap nin pammagalang kongko ta main nin makauray nin maningkap nin pammagalang kongko tan sya a manintinsya no ani a kusto. ");
INSERT INTO smkNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Isipen moyoyti nin maong: Si si'numan a nipatukdo' nay pagkakabyay na sa man'ibarita' ko, kai na gapo nin dalanan a patiti.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Konan siin wanra nin Judio, “Kasa pa gapo nin dwadwa a nasrepan ka nin ispiriton duka'. O' a ta man'ibarita' mo a kai ya gapo nin mati a si'numan nin nipatukdo' nay pagkakabyay na sa man'ibarita' mo! Bale', nati ya si Abraham tan wanin ra anamaet nin prupita a saray nangiparate' anaod nin minsahi nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mas ata'gay ka et para dyan si puon min si Abraham tan saray prupita? Anaod, pari-pariho saran nati. Ani ket a pangngipa'ka' mo sa lalaman mon diri?” ");
INSERT INTO smkNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ket wanan inumbat ni Jesus, “No pagalangan koy lalaman kon diri, kasan kakanaan, bale' isen yay Ama ko a syay mamagalang kongko. Wamoyo a sya a Dios moyo ");
INSERT INTO smkNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","mataman no kai moya nin katanda'. Bale' si'ko, katanda' koya. No ibarita' ko a kai koya nin katanda', mag'in kapada moyoko nin mabula'. Bale' katanda' koya anaod tan man'ipatukdo' koy byay ko sa wana. ");
INSERT INTO smkNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wanin ana a ririket na nin puon moyon si Abraham bana' ta inilalwan na a ma'kit nay irarate' kodti. Ket page' a na'kit nayti ket maririket ya.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Konan siin, wanra nin Judio kona, “No kasa et nin limampulo' a taon mo, sukat a wamo ket na'kit mayna si Abraham!” ");
INSERT INTO smkNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ket wana ni Jesus, “Isipen moyoyti nin maong: Kai ya et nin niyanak si Abraham, main akoyna nin gindat.” ");
INSERT INTO smkNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Konan siin, nagsipurot sara nin bato ta pigaw nin kudasen rayan patyen, bale' niyadi ya si Jesus, mi'sa nibwat yaynadtaw sa sakop nan Timplo. ");
INSERT INTO smkNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sin manlumalako sara si Jesus, main nin na'kit nan lalaki a bulag yaynan niyanak. ");
INSERT INTO smkNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ket saray tumutumbok na tinepet ra kona, “Maistro, si'no a nagkasalanan kanya' nin bulag yan niyanak ti nin lalaki? Sya para nin diri o saray matua na?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Inumbat ya si Jesus a wana, “Niyanak yan bulag ti nin lalaki, ambo' nin bana' ta nagkasalanan ya o, bana' ta nagkasalanan saray matua na, no kai edet, nangyadi' a wanin ta pigaw nin maipa'kit no ani a gaw'en nin pakayadi' nan Dios kona. ");
INSERT INTO smkNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ket, matkap a gaw'en tamo a nipagwa' na nin si namaki' kongko mintras nin awro et, a siti a udas a nipagwa' nayti. Bana' ta yabi ana li' ket, kasayna li' nin makagwa' nin animan. ");
INSERT INTO smkNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bale' iti ako et konan sitin mundo, ket si'ko a palaway nin mamalaway sa tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kayadi' na nin nibarita' in ni Jesus, linmuda' ya sa luta'; mi'sa na kinalap nin ginwa' nan tupa'; ket nipulapod na sa mata na nin bulag ");
INSERT INTO smkNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a wana, “Mako ka magra'mos itaw sa dipusito nin ranom itaw sa Siloe.” (Say katarusan na nin Siloe ket, nibaki'.) Wanin anaod a ginwa' na nin lalaki ket sin nayadi', maka'kit yayna, ket nugot yayna sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ket, sin na'kit raya nin kabaraybay na tan saraytaw saray naka'kit kona sin mangkipayabor ya et, wanra, “Ambo' yayti taw para si gindat nin nakatekre' a mangkipayabor?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wanra nin raruma, “O', sya in taw.” Wanra bale' nin raruma, “Kai, kabakas naya tamo'.” Konan siin, wana nin lalaki, “O', si'ko pan diri.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ket, “Pa'no nin nangyadi' a maka'kit kayna?” wanra. ");
INSERT INTO smkNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wana nin ni'bat, “Sitaw si tawo nin mantawagen nin Jesus, nangwa' ya nin tupa', mi'sa na nin nipulapod sa mata ko, tan wana kongko, ‘Mako ka sa Siloe tan magra'mos kadtaw.’ Nako ako anaod tan nagra'mos ako, ket sin nayadi', maka'kit akoyna.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Konan siin, nitepet ra, “Adti yayna, ey?” Ket inumbat ya, “Ta'wan.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ket, ni'ras rayayti si tawo a gindat nin bulag konran Pariseo. ");
INSERT INTO smkNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wanin, ta Awron Painawa sin nangwa' ya nin tupa' si Jesus tan sin ginwa' na nin maka'kit yaynay bulag. ");
INSERT INTO smkNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ket, tinepetan raya anamaet nin Pariseo no pa'no nin nangyadi' a maka'kit yayna. Wana konra, “Pinulapudan nan tupa' a mata ko; mi'sa ako nako nin nagra'mos; ket sawanin, maka'kit akoyna.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sin sain, wanra nin raruma nin Pariseo, “Kai magwa' a nibaki' naya nin Dios in nin tawo ta kai naya nin kabilangan a Awron Painawa.” Saray raruma anamaet bale' wanra, “Bale' kai ya kumon nin makagwa' nin wanti nin makapaka'ngap nin paka'kitan no saya ya wadi' nin makasalanan.” Anaod, kai nin nitutuno a kukaisipan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ket tinepetan raya anamanaet a tawo a wanra, “Ket sawanin, si'ka, ani a maibarita' mo maipa'ka' kona, bana' ta wamo ket ginwa' nan maka'kit kayna?” Ni'bat na, “Saya ya nin prupita.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Saray pupangulo ran Judio, kai sara nin mamper a siti nin maka'kit ana sawanin ket syaytaw si gindat nin bulag nin niyanak anggan kai rasara nin matepetan a matua na. Kanya' nin nipakayaban rasara ");
INSERT INTO smkNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tan tinepetan rasara a wanra, “Anak moyayti? Peteg para nin bulag ya nin niyanak? No wanin, mayin edet a maka'kit yayna sawanin?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ket wanra nin ni'bat nin matua na, “O' peteg a anak miya in tan peteg a bulag ya nin niyanak. ");
INSERT INTO smkNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bale', si maka'kit yayna sawanin, kai mi nin tanda' no pa'no nin nangyadi', o no si'no a nangwa' nin maka'kit yayna. Sya a tepetan moyo ta iti yayna sa kuston idad ket maka'bat yayna.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nibarita' ra a wanin nin saray matua na bana' ta mali'mo sara konran pupangulo ran Judio, bana' ta nipapagketan ra a, si si'numan a mangibarita' a si Jesus syay Cristo, ket galten ya sa dupong ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Siin anaod a rason no ambale' a wanran matua na ket iti yayna sa kuston idad, sya a tepetan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Anaod, saray pupangulo ran Judio, nipakayaban rayaytaw si gindat nin bulag a wanra kona, “Ipangako' mo sa adapan nan Dios, ibarita' mo a tutuo. Tanda' mi a, sitaw si tawo nin namaanda' komo ket, makasalanan ya.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wana nin tawo, “Kai ko nin tanda' no sitaw nin tawo ket, makasalanan ya o kai. Si tanda' ko tamo' ket bulag akon gindat, bale' maka'kit akoyna sawanin.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nitepet ra kona, “O', bale', pa'no na nin ginwa' a maka'kit kayna? Ani a ginwa' na?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ket ni'bat na, “Nibarita' koyna anaod komoyo, bale' kai moyo nin asikaswen. Ambale' a rabay moyo anamana nin marnge'? Rabay moyo anamaet para a mag'in nin tumutumbok na?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Konan siin, nagsari-saritaan raya a wanra, “Ha! Si'ka a tumutumbok na nin sitaw a tawo! Bale' si'kami, tumutumbok nakami ni Moises, ");
INSERT INTO smkNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","bana' ta tanda' mi a si Dios, nag'irgo ya kona ni Moises. Bale' siin nin tawo, kai mi gapo nin tanda' no adti a ibwatan na.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sin sain, wana nin ni'bat nin tawo, “Ya, ansiin li'! Kai moyo nin tanda' a ibwatan na, ket sya a nanglat nin pag'in kon bulag. ");
INSERT INTO smkNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tanda' tamo nin peteg a kai na nin reng'en nin Dios a dawat nan sayay makasalanan, no kai edet, si reng'en na, ket si sayay mangigalang kona tan mangwa' nin karabayan na. ");
INSERT INTO smkNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nangibwat ana sin tarana' na nin mundo, kasa et gapo nin tawo nin natandaan nin nangwa' a maka'kit yaynay sayay bulag nin niyanak. ");
INSERT INTO smkNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bilang wadi' a ambo' ya nin ibat konan Dios, kai ya edet kumon gapo makagwa' nin bilang sa wanti.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Konan siin wanra nin inumbat, “Makasalanan kayna nangibwat et sin kai ka et nin niyanak, ket sukat a si'ka a mangyakay komi?” Ket sin sain, ginlat raya sa dupong ra. ");
INSERT INTO smkNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sin natandaan na ni Jesus a ginwa' ra konan tawo, tiningkap naya tan wana kona, “Magmatalek ka para kona nin si Pinaitawo?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Inumbat yay tawo a wana, “Ser, si'no ya ket? Ibarita' moyo pa kongko ta pigaw nin magmatalek ako kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ket wana ni Jesus, “Sawanin a mismo, mangka'kit ma bana' ta syayti si mangkiirgo komo.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sin sain, wanan tawo, “Ser, magmatalek ako.” Ket nanalimukod yan nangrayo kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sin sain, wana ni Jesus, “Nako akodti konan sitin mundo ta pigaw nin pipuruken kosaray tutawo. No main saray bara'mon bulag maipa'ka' konan Dios, palawayan kosara. Sara bale' a wanra ket tanda' raya a Dios, mag'in sara anamaet nin bara'mon sayay peteg nin bulag.” ");
INSERT INTO smkNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Main saray Pariseo nin itaw sa dani nin kami'nan na ni Jesus a nakarnge' sa inirgo na, ket tinepet ra kona, “Rabay mo para nin irgwen ket bulag kami anamaet maipa'ka' konan Dios?” ");
INSERT INTO smkNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ket ni'bat na ni Jesus, “Wamoyo kai, ket no bulag kamo kumon, kasa nin kasalanan moyo, bale' bana' ta wamoyo a maka'kit kamo, mampisyon a kasalanan moyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ket, wana ni Jesus, “Isipen moyoyti nin maong: Bilang wadi', main nin kural ran karniro ket si sayay tawo, sumrep yadtaw nin muli' ya sa darekdek imbis a dumalan yadtaw sa purta, saya ya anaod nin mannakaw nin samsamen nasara. ");
INSERT INTO smkNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bale', si sumrep nin dumalan ya sa purta, sya a peteg nin mammastor ran karniro. ");
INSERT INTO smkNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pasrepen naya nin gwardya. Ket maalilbi' ran karniro a tunoy na. Tawag-tawagen nasaray karniro na sa ngaran ra tan irikor nasara sa kural. ");
INSERT INTO smkNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ket no itaw saraynay sarba ran ikon na sa rikor, mu'na ya konra tan tumbuken raya bana' ta tanda' ray tunoy na. ");
INSERT INTO smkNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kai sara gapo nin tumumbok sa raruma, no kai edet, palaywan rayayti bana' ta kai ra nin tanda' a tunoy na.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nibarita' nayayti ni Jesus nin alimbawa' konra, bale' kai ra nin natarusan a rabay na nin ipatarusan. ");
INSERT INTO smkNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sin wanin, wana anamaet ni Jesus, “Isipen moyoyti nin maong: Si'ko a dadalanan ran karniro. ");
INSERT INTO smkNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sarba ra nin saray nu'na dyan si'ko nin nagwadi'-wadi' saran dadalanan, nin irikor rasaray pa'sar karniro, mannakaw sara nin samsamen rasara. Bale' kai rasara nin rinnge' nin saray pa'sar karniro. ");
INSERT INTO smkNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Si'ko a dadalanan sa pako konan Dios. Si si'numan a sumrep nin dumalan kongko, ket maisalba ya. Maipada ya sa sayay karniro nin sumrep tan lumiwa' sa kural ket makadumog yan pangnganan. ");
INSERT INTO smkNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Si sayay mannakaw, mako ya tamo' nin manakaw, mangmati tan manida'. Bale' si'ko, nako akodti ta pigaw nin saray tutawo ket magkamain sara nin byay a iti konan Dios nin sitin byay ket bastanti ya. ");
INSERT INTO smkNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Si sangkaungan nin mammastor konran karniro ket, si'ko. Asikaswen kosara mataman no pangibwatan ti nin patiti ko. ");
INSERT INTO smkNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Si sayay tawon man'upaan tamo', ma'kit naya man nin itaw et sa dayo' nin man'umarak a sayay mabayanin ayep, lakwanan nasarayna a karniro nin malayo ya bana' ta ambo' ya a mammastor tan ambo' nasara nin ikon. Ket no rumate' yaynay mabayanin ayep, kayat-kayaten nasaray karniro ket pisisyaken nasara. ");
INSERT INTO smkNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Malayo ya bana' anaod ta man'upaan ya tamo' kanya' nin kai sara nin maalaga kona. ");
INSERT INTO smkNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Bale' si'ko, sangkaungan ako nin mammastor. Wanin bana' ta say pitatandaan mi nin saray pa'sar karniro ko ");
INSERT INTO smkNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ket kapada nin pitandaan mi nin Ama ko. Wanin et, asikaswen kosara a pa'sar karniro ko mataman no pangibwatan ti nin patiti ko. ");
INSERT INTO smkNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Main et nin raruma nin pa'sar karniro ko nin kasa konan siti nin pa'sar kural. Matkap a dinepen kosara anamaet ta reng'en raynamaet a tunoy ko. Ket mag'in nin sayan-sayay pa'sar bakid sara nin saya a mammastor ra. ");
INSERT INTO smkNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Si Ama ko, kawa'nan nako bana' ta tumulok ako kona nin ibi ko a byay ko nin mati ako ta pigaw nin sumubli' ako nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kasa anaod nin makapangmati kongko no ambo' nin mangibwat kongko a mapati ako, bana' ta main nin kapangyadian ko nin ibi koy byay kon mati tan main a lamang nin kapangyadian ko nin bawien koy byay ko. Wanin bana' ta sain a niketeg nan Dios maipa'ka' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sin sain, kasa anamana nin pipapasaya nin kukaisipan ra nin Judio bana' sa sain nin nibarita' na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Saray abaw konra wanra, “Nasrepan ya nin ispiriton duka' ket mangkaluang ya! Ambale' a mangrenge' kamo kona?” ");
INSERT INTO smkNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ket wanra anamaet nin raruma, “Makapag'irgu-irgo ya para nin wanin a saya nin nasrepan nin ispiriton duka'? Matambar na para nin sayay ispiriton duka' a pag'in nan bulag nin sayay tawo?” ");
INSERT INTO smkNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sin panaon anan maray'ep, syaynay pangngisilibra sa Jerusalem nin pista a mantawagen nin Pangingididika konan Timplo. ");
INSERT INTO smkNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sin sain, itaw yan manlumala-lalako si Jesus sa lugar sa Timplo a mantawagen nin Balkon na ni Solomon ");
INSERT INTO smkNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ket inaribungbungan rayan Judio tan wanra kona, “Anggan ka'no rakami nin pangisipen et? Ibarita' moyna nin diritsawan no si'ka a Cristo.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ni'bat na ni Jesus konra, “Nibarita' koyna komoyo bale' kai moyo nin rabay a mamper. Say makapaka'ngap nin man-gaw'e-gaw'en ko nin nipagwa' na nin Ama ko, sain a mamatutuo nin maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bale' kai kamo anaod nin mamper bana' ta ambo' kamon pa'sar karniro ko, ");
INSERT INTO smkNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ta saray pa'sar karniro ko, maipurok ray tunoy ko tan si'ko anamaet, tanda' kosara, kanya' nin tumbuken rako. ");
INSERT INTO smkNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ket byan kosara nin anggan-angga nin byay a iti konan Dios. O', kai sara gapo nin maisyay konan Dios, tan kasa gapo nin makapanamsam konra kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wanin bana' ta si Ama ko nin nangipya konra kongko ket sya a makapangyayadi' sa sarba, ket kasa gapo nin makapanamsam konra sa pammaga nan Dios a syay Ama. ");
INSERT INTO smkNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Si'ko tan si Dios a syay Ama ket napasaya kami.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Konan siin, sa ikarwan parso, nagsipurot saran bato a Judio ta pigaw nin kudasen raya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sin sain, wana konra, “Abaw anay nipa'kit ko komoyo nin mabibistan gawa' a nipagwa' nan Ama ko kongko. Aya wadi' sa saytin ginwa-ginwa' ko a rason a kudasen rako?” ");
INSERT INTO smkNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Imbatan rayan Judio a wanra, “Ambo' nin bana' sa mabibistan ginwa' mo a rason a kudasen mika no kai bana' ta man'u'na-u'nawan ma a Dios. Si'ka a mapala-palaway nin tawo tamo' ket man'ipariho moy lalaman mon diri konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ket inumbat ya si Jesus a wana, “Main bale' nin naisurat sa Masanton Kasuratan a wamoyo sayti a Gugan-gan moyo maipa'ka' konra nin pupangulo moyo sin saytaw nin wanti a wana, ‘Si'ko nin si Dios, ibarita' ko a dios kamo.’ ");
INSERT INTO smkNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Siin nin wanan Dios a naisurat sa Masanton Kasuratan ket kai ya gapo nin mapakai. Anaod, no dios a nipanawag nan Dios konran saraytaw saray tawon nag'irgwan na, ");
INSERT INTO smkNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ambale' a kongko nin nitalaga na para sa sayti tan nibaki' nadti sa mundo ket wamoyo a man'u'na-u'nawan koyay Dios no wangko a si'koy Anak nan Dios? ");
INSERT INTO smkNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No kai ko kumon nin man-gaw'en a makapaka'ngap nin gugawa' a man'ipagwa' na nin Dios kongko, andi' kamo kumon nin mamper sa ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bale' anaod ta man-gaw'en ko, sain a matkap nin rason a mamper kamo no si'no ako, abirno nin kai kamo nin mamper sa ibarita' ko, ta pigaw nin mapiho moyo nin si Ama, ket iti ya kongko tan si'ko, ket iti ako anamaet kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ket, konan siin, anamanaet dakpen raya kumon si Jesus, bale' napal'isan nasara. ");
INSERT INTO smkNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mayadi' in, sinmubli' ya si Jesus itaw sa rubari' nan Ilog Jordan, itaw sa namawtismwan na intaw ni Juan. Ket itaw yayna yapo'. ");
INSERT INTO smkNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ket abaw sara a tutawo nin naku-nako kona ta wanra, “Si Juan, kai ya gapo nin nangwa' nin makapaka'ngap nin gawa' a mamatutuo nin maipa'ka' kona, bale' say sarba nin nibari-barita' na maipa'ka' kona nin sitin tawo ket peteg a tutuo.” ");
INSERT INTO smkNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ket abaw saradtaw a nagmatalek kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Main nin mibubsat a mampiikap sa babali nin Betania a say ngaran ra Maria, Marta tan Lazaro. Si Maria, syaytaw si mangiyapros nin banglo sa ayi na ni Uunuren a Jesus mi'sa na punasan nin sabot na. Ket si Lazaro, main nin masakit na. ");
INSERT INTO smkNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ket bana' ta wanin anaod, namaki' sara si Maria tan Marta nin mako nin mangiparate' kona ni Jesus a wana, “Ser, si amigo mo nin kawa'nan mo, ket main nin masakit na.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sin narnge' na in ni Jesus wana, “Siin nin masakit na, kai ya nin mangangga sa patiti, no kai edet, nangyadi' ti nin pakaipadaran nin kata'gayan nan Dios ta pigaw nin maipata'gay akon si Anak na.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Anaod, inado' nasaran maong ni Jesus tin mibubsat a Marta, Maria tan Lazaro. ");
INSERT INTO smkNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bana' konan siin, sin narnge' na a main nin masakit na ni Lazaro, namalabas ya yapo' nin rway awro itaw sa kami'nan na, ");
INSERT INTO smkNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","mi'sa wana konran tumutumbok na, “Sumubli' atamo sa Judea.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bale' wanra nin ni'bat kona, “Maistro, ambo' et nin na'teng a pinatyuan rakamon kudasen nin Judio nin itaw. Andi' kamo nin sumubli' anamanaet itaw!” ");
INSERT INTO smkNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wana ni Jesus, “Magwa' et ta italaga nan Dios a kusto nin udas para sa sayay mangyadi'. Bilang wadi', no pa'sar lumalako ya a sayay tawo no awro, kai ya nin misakin bana' ta maka'kit ya bana' sa palaway nan sitin mundo. ");
INSERT INTO smkNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bale', no pa'sar iti ya sa yabi nin lumalako, misakin ya bana' ta madedlem ket kasa yay palaway kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ket nituloy na, “Si amigo tamon si Lazaro ket mampa'lek ya. Keen koya nin pukawen.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ni'bat ran tumutumbok na, “Uunuren, no mampa'lek ya ket mabista ta umanda' yayna li'.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wanin a wanra bana' ta say pakataros ra ket mampa'lek yan page' si Lazaro, bale' say rabay nan irgwen ni Jesus ket nati ya. ");
INSERT INTO smkNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Konan siin, diritsawan nan nibarita' ni Jesus a wana, “Nati yayna si Lazaro, ");
INSERT INTO smkNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","bale' maririket ako anamaet a lamang ta kasa akodtaw sin nati ya. Nangyadi' yayti para sa kaabigan moyo, ta pigaw nin lalo kamon mamper no si'no ako. Kanya' nin mako atamo anadtaw kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Konan siin, wana ni Tomas a mantawagen nin Singin, konra nin kapada nan tumutumbok, “Sigi, mayi atamo ana ta pigaw nin kipati atamo kona ni Maistro!” ");
INSERT INTO smkNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sin rinmate' saradtaw sa Betania si Jesus, natandaan na nin a'pat a awro naynan naitabon ni Lazaro. ");
INSERT INTO smkNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Siti si baryo nin Betania, adani yadtaw sa Jerusalem ta kurang a tuloy kilumitro tamo' a kaday'an na. ");
INSERT INTO smkNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kanya' nin abaw saray Judio nin ibat itaw a nako nin nangliwaliwa konra ni Marta tan Maria sa nipati nan busat ra. ");
INSERT INTO smkNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sin narnge' na ni Marta a manrumate' ya si Jesus, kina' naya nin sinna', bale' si Maria ket nabati' yadtaw sa bali ra. ");
INSERT INTO smkNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Wana ni Marta kona ni Jesus, “Ser, no iti kamo tamo' kumon, kai ya nin nati a busat mi! ");
INSERT INTO smkNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bale' tanda' ko nin lamang a mataman nin sawanin, animan a dawaten moyo konan Dios ket iyaburoy na nin mangyadi' komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wana ni Jesus, “Sumubli' ya nin mabyay a busat mo.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ket wana anamaet ni Marta, “O' a, tanda' ko a sumubli' ya li' nin mabyay no pasublien sara nin mabyay a nunati no saytaw li' no marate' a awro.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Konan siin, wana ni Jesus, “Si'ko a main nin pakayadi' nin mamasubli' nin mabyay konran nunati ana, tan si'ko a mampami nin byay. Si si'numan a magmatalek kongko, mataman nin mati ya, mabyay ya et a lamang. ");
INSERT INTO smkNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ket, saray mabyay a mampagmatalek sara kongko, kai sara gapo nin peteg nin mati. Tepren moyti para?” ");
INSERT INTO smkNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“O' Ser,” ni'bat na ni Marta, “mamper ako a si'kay mantaga'nan mi nin rumate' iti sa mundo. Si'ka a Cristo nin Anak na nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kayadi' na nin inirgoyti ni Marta, sinmubli' ya sa bali ra. Kinayaban naya si Maria tan wanan niyanas, “Rinmate' ya si Maistro, ket man'ipakayaban naka.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sin narnge' nayti ni Maria, inumdeng yan tampor tan nako naya nin sinna' si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sin sain ket, itaw ya et sa rikor nin baryo si Jesus, itaw sa nannaan na ni Marta kona. ");
INSERT INTO smkNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Saray Judio anamaet nin mampangliwaliwa kona ni Maria, sin na'kit rayan apuradon nibwat, tinumbok raya bana' ta say wanra ket mako ya sa nanabunan kona ni Lazaro ta pigaw nin umakis ya. ");
INSERT INTO smkNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sin nakarate' yadtaw si Maria sa kami'nan na ni Jesus, nanalimukod ya sa adapan na tan wana, “Ser, no iti kamo tamo' kumon, kai ya nin nati a busat mi.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sin na'kit na ni Jesus a mampangabet-abet ya si Maria tan saray Judio nin tinmumbok kona, inmidap nin tuloy a nakem na tan ginmereng ya ");
INSERT INTO smkNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ket wana, “Adti moya nin nitabon?” “Mayi kamo, Ser, ta keen moya nin kiten,” wanra nin ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nilwa' ya si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Konan siin, wanra nin Judio, “Kiten moyo no pa'no nin kaalaki a pangangawa'nan na kona!” ");
INSERT INTO smkNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wanra anamaet nin raruma konra, “Nagwa' na a maka'kit yayna a sayay bulag. Main anamaet kumon nin nagwa' na ta pigaw nin kai ya nin nati si Lazaro.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ginmereng ya anamana nin maong si Jesus, ket kinmadani ya sa nanabunan kona ni Lazaro a siti ket yukib ya nin sinadaan nin alakin bato. ");
INSERT INTO smkNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Galten moyay bato,” nigan-gan na. Bale' andi' yay busat nan si natin si Lazaro, si Marta, a wana, “Ser, mabang'et yayna ta a'pat a awro yayna nin nitabon.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wana ni Jesus kona, “Nalingwanan moyna para a nibarita' koyna komo a no magmatalek ka kongko ket ma'kit mo a pakayadi' na nin Dios?” ");
INSERT INTO smkNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ket, ginlat rayay bato. Ket, tinmangar ya si Jesus tan wana, “Ama ko, kisalamat ako komo ta rinnge' nako. ");
INSERT INTO smkNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tanda' ko a manreng'en nako nin pirmi, bale' nibarita' koyti bana' konra nin sarayti nin tutawo, ta pigaw nin mamper sara nin si'ka a namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kayadi' na nin nibarita' ti ni Jesus, nita'way na a wana, “Lazaro, lumiwa' kadsen!” ");
INSERT INTO smkNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Linmiwa' ya anaod si Lazaro a napunggos yan abel laloynay gamet tan ayi na tan napunggos nin alakin panyo' a rupa na. Ket wana ni Jesus konran itaw, “Warwaren moyoy nipamunggos kona ta pigaw nin makakimey ya.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sin sain, main saraytaw saray Judio nin nako konra ni Maria nin naka'kit sa ginwa' na ni Jesus, ket nagmatalek sara kona. ");
INSERT INTO smkNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Saray raruma bale', nako sara konra nin Pariseo nin nika' ra nin niparate' a ginwa' na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kanya' nin sin sain, nipakayaban rasaran Pariseo tan saray pupangulo ran pupadi' a raruman myimbron Kunsiho, mi'sa wanra, “Ani a gaw'en tamo ta siin nin tawo ket abaw anay man-gaw'e-gaw'en nan bara'mon gawa' nan Dios? ");
INSERT INTO smkNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","No pauryan tamoya tana nin wanin, sarba ra nin tutawo, magmatalek kona. Ket saray mampag'uray kontamo nin taga Roma, mako saradti tan gamgamen rayayti kontamo si Timplo tamo tan si nasyon tamo.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bale' si Caifas a syay Sangkata'gayan nin Padi' sin sain a taon wana, “Si'kamo! Kai moyo gapo nin mataros. ");
INSERT INTO smkNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Matkap moyon maamingaw a mabista a sayay tawo tana a mati ta pigaw nin maisalba saray ka'bawan, dyan si sarba tamon gumabali a mati.” ");
INSERT INTO smkNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Siti nin nibarita' na ni Caifas, kai nin nangibwat sa kaisipan na nin bukod no kai edet, bana' ta syay Sangkata'gayan nin Padi', nipapadles nan Dios kona a matkap yan mati si Jesus, ta pigaw nin saray kadayaan na nin saray Judio ket maisalba sara. ");
INSERT INTO smkNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mati ya ambo' tamo' nin para konran kadayaan nan saray Judio no kai edet, para et konran sarba ran a'nak nan Dios nin natayak-tayak sa nagsikabarang nin lugar ta pigaw nin gaw'en nasaran sayan-sayay pamilya. ");
INSERT INTO smkNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ket nangibwat ana konan siin nin awro, saray pupangulo ran Judio, niplano rayna no pa'no rayan mapati si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bana' anaod ta wanin, kai sarayna nin nipa'ki-pa'kit nin lumala-lalako si Jesus itaw sa Judea no kai edet, nibwat saran nako sa Efraim, sayay babali nin adani sa lugar a ambo' nin matawo. Ket itaw sara yapo' nin saray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Edet, dandani ana sin sain a pista ra nin Judio a mantawagen nin Nipanglabas. Kanya' nin abaw saray Judio nin ibat sa bubaryo nin tinmangkar sa Jerusalem ta pigaw nin gaw'en ra a ritwal nin piriringgas ta pigaw nin magwa' ray mako sa pista. ");
INSERT INTO smkNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tiningka-tingkap rayan tutawo si Jesus, ket sin mampididinep saraynadtaw sa sakop nan Timplo, nitepetan sara sa saya tan saya a wanra, “Ani sa wamoyo? Mako yadti kasi nin kipista?” ");
INSERT INTO smkNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wanra in ta nigan-gan ran saray pupangulo ran pupadi' tan saray Pariseo a si'numan a makatanda' sa kami'nan na ni Jesus, ipatanda' na konra ta pigaw nin dakpen raya. ");
INSERT INTO smkNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ket, sin a'nem a awro adapen a pista, nako sara si Jesus sa Betania, si babali na ni Lazaro a pinasubli' na intaw nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nanadya' saran pangapunan nin pananan'ili ra kona. Si Marta a nagsirbi konra, ket si Lazaro, saya ya konra nin kadungo nan nangan ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sin sain, nangalap ya si Maria nin kapiknga' litro nin pinasyan bili nin puron banglo a say ngaran ket nardo. Niyapros nayti sa ayi na ni Jesus mintras nin mampunasan nan sabot nay ayi na. Ket inmupuop sa intiron bali a banglo. ");
INSERT INTO smkNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ket si Judas Iscariote, a syay tumutumbok na ni Jesus nin magtraidor kona wana, ");
INSERT INTO smkNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ya, nilako' in kumon nin banglo, mi'sa nin nibi konra nin pubri a naglakuan ta gumli ana in nin ribu-ribo.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wanin a nibarita' na ambo' nin bana' ta mangkapagawan nasaray pubri no kai edet, bana' ta matakaw ya. Sya a mampanga'get nin kwarta ra ket mampangalap-kalap yan dai-daite'. ");
INSERT INTO smkNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Konan siin, ni'bat na ni Jesus, “Pauryan moya, ta niyator na in nin banglo nin iyamris kongko para sa tabon ko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Saray pubri, pirmi moyo sara nin makalamo', bale' si'ko, ambo' anan ma'teng a iti ako et komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Abaw saray Judio nin nakarnge' a itaw ya sa Betania si Jesus. Kanya' nin abaw saray nakodtaw, ambo' tamo' bana' nin kona, no kai ta pigaw et nin ma'kit raya si Lazaro a si pinasubli' na nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sin wanin, saray Pupangulon Pupadi', nipapagketan ra a ipapati raya anamaet si Lazaro ");
INSERT INTO smkNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta, bana' sa nangyadi' kona, abaw sarayna a Judio nin nikisyay konra ta pigaw nin magmatalek sara kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sin sinmunor nin awro, saray pinasyan ka'bawan nin nako nikipista, natandaan ra nin adap nadtaw sa Jerusalem ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kanya' nin rinmikor saran nako namukan nin pala'pa' nin kayon bilang nin ungot ta pigaw nin sanaen raya. Wanra nin nita'wa-ta'way, “Marayo ya! Binindisyunan nayan Dios a nibaki' na nin manrumate' anadti sawanin kontamo! Syaynaod a Adi' nan Israel!” ");
INSERT INTO smkNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nakaruran ya si Jesus konan uybon nin asno nin nipakalap na. Bilang sa wanin a mabasa sa Masanton Kasuratan a wana, ");
INSERT INTO smkNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Syayna e a adi' moyo! Rinmuran ya sa uybon nin asno! Kanya' nin andi' kamo nin mali'mo, si'kamon tutawo sa Sion!” ");
INSERT INTO smkNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Saray tumutumbok na ni Jesus, kai ra et nin natarusan a pipa'kaan nin sayti nin mampangyadi' sin sain, no kai saytaw li' no nipata'gay tan pinagalangan yayna, saytaw rayna nin matarusan a sayti a nikatukid nin say naisurat a wanan Dios maipa'ka' kona ni Jesus tan sayti anaod a ginwa' ra kona. ");
INSERT INTO smkNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Edet, nipata-patanda' ray nabantayan ra nin saraytaw saray tutawo nin nakabantay nin tinawag naya ni Jesus si Lazaro nin lumiwa' sa nanabunan kona sin pinasubli' nayan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Siin a rason a saray pinasyan ka'bawan nin tutawo ket sinna' raya si Jesus, bana' ta natandaan ra in a ginwa' nan mangipa'kit a nangibwat ya konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ket saray Pariseo, wanra sa saya tan saya, “Kasayna, nadaeg natamoyna! Kiten moyo, tumutumbok nasarayna a sarban tawo!” ");
INSERT INTO smkNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Main anamaet nin ambo' nin Judio nin nikikalamo' konran saray nako nikipista ta pigaw nin mangrayo sara konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ket nako sarayti kona ni Felipe a taga Betsaida sa prubinsyan Galilea tan wanra kona, “Ser, rabay miya kumon nin makaadap si Jesus.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nika' na nin nibarita' ti ni Felipe kona ni Andres, ket nako sara kona ni Jesus tan niparate' raytin kadawatan kona. ");
INSERT INTO smkNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ket, wana ni Jesus, “Sawanin ana a si'kon si Pinaitawo ket maipata'gay ako yupa' sa mangyadi' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Anaod, isipen moyoyti nin maong: No si sayay bikoy ket kai ya nin imula ta pigaw nin no wanin ket nati ya yapo' mi'sa ya nin rumsik, magnayon ya nin sayan-saya tamo'. Bale' no imula ya ket no wanin nati ya, rumsik ya tan gumunga ya li' nin abaw. ");
INSERT INTO smkNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Si sayay tawo anamaet a lamang nin kumpunyen na nin maong a byay na, sidaen ya in li' nin lamang. Bale' no si tawo ket, ikwinta nay byay nadti sa luta' nin ambo' nin maalaga, mamprutiksyunan nan mismo ta pigaw nin mabyay ya li' anggan-angga nin iti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Anaod, si si'numan a magsirbi kongko, matkap a si'ko a lawas nin sunuren na ket abirno nin adti ako man, itaw ya anamaet li' tan pagalangan naya li' nin Ama koyti si magsirbi kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sawanin ana, man'umaburido ako nin maong a no ani wadi' a ibarita' ko konan Ama ko. Wangko para ket, ‘Ama ko, isalba nako sa dya'dya' a adapen ko nin irangep?’ Kai, bana' anaod ta sitin diri a gagara a nako akodti, si mangirangep akon sarban saytin dya'dya'.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sin sain, wana konan Dios, “Ama ko, sisisibulot a nakem kon usaren nako sa pangipadar mon mabistan gawa' mo.” Ket main nin busis nin nangibwat sa langit a wana, “Naipadar koyna tan ipadar ko li' anamanaet.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Narnge' raya anamaet nin abaw nin tawodtaw a busis ket, say wanra nin raruma, kinmudor, bale' saray raruma anamaet wanra, “Nag'irgo ya kona a sayay anghil.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sin sain, wana ni Jesus konra, “Saytaw say narnge' moyo, kai taw nin inirgo para sa kaabigan ko no kai para sa kaabigan moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mangyadi' ana sawanin a manepeg a pamatukduan nin pangungukom konran tutawodti sa mundo. Sawanin ana a panaon nin pakadaeg na ni Satanas a syay mampag'uray iti sa mundo. ");
INSERT INTO smkNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wanin ta, si'ko, no naita'gay akoyna li' sa kudos, ket paaraken ko a sarba nin tawo nin paisirong sara kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wanin a nibarita' na ni Jesus ta pigaw nin ipatarusan na no pa'no ya nin mati. ");
INSERT INTO smkNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Konan siin, wanra nin tutawo, “Ambale' a wamo ket maita'gay ya a si Pinaitawo? Wana sa Masanton Kasuratan ket si Nipangako' nan Dios nin rumate' iti ket mabyay ya anggan-angga. Si'no yayti ket si Pinaitawo?” ");
INSERT INTO smkNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ket, wana ni Jesus konra, “Ambo' ana nin ma'teng nin kalamo' moya et a palaway. Kanya' nin sunuren moya a napalawayan nin dalan antaran iti ya et a palaway komoyo ta no kai ket, madedleman kamo. Wanin ta, si saya nin manlumalako sa madedlem, kai na nin tanda' no adti a piugutan na. ");
INSERT INTO smkNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Magmatalek kamo anaod kona nin syay palaway antaran iti ya et komoyo, ta pigaw nin mag'in kamon tutawon napalawayan nan si palaway.” Kayadi' na nin nibarita' ti ni Jesus, linakwanan nasara tan kai yayna yapo' nin nipa'ki-pa'kit. ");
INSERT INTO smkNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mataman nin nangwa-nangwa' yayna si Jesus nin makapaka'ngap nin pammatutuo nin maipa'ka' kona, kai sara et a lamang nin magmatalek a tutawo kona. ");
INSERT INTO smkNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sa wanin ket, natukidtaw si nipadles na ni Prupita Isaias a wana, “Uunuren, bara'mon kasan namper sa niparate' mi konra! Ambale' a daikleng sara tamo' a nangako' nin pakayadi' nin man'ipa'ki-pa'kit mo?” ");
INSERT INTO smkNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kai sara nin mamper bana' ta mabasa et nin nisurat na ni Isaias, ");
INSERT INTO smkNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pa'sar binulag nasara nin Dios tan pinateb'ey nay kukanakman ra, ta no kai ket maka'kit tan makataros sara kumon ket mako sara kona ket isalba nasara.” ");
INSERT INTO smkNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nibarita' nayti ni Isaias bana' ta na'kit nayna nin gindat a kata'gayan na nin Cristo tan si Jesus yaytaw si man'irgwen na. ");
INSERT INTO smkNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wanin man, abaw sara anaod konran pupangulo ran Judio a namper no si'no ya si Jesus bale', kai rayti nin man'ipadar. Wanin bana' sa li'mo ra konran Pariseo a dusawen rasara nin galten ana sa dupong ran Judio ");
INSERT INTO smkNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ta mas maalaga konra a rabay-rabay rasaran tutawo dyan si rabay-rabay nasaran Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ket, wana nin nipaksaw ni Jesus, “Si si'numan a magmatalek kongko, ambo' ako tamo' a nagmatalkan na no kai pati si namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Si naka'kit kongko, na'kit nayaynan lamang a namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nako akodti nin magsirbin palaway ran tutawodti ta pigaw nin si si'numan a magmatalek kongko ket kai ya nin manangke' sa dedlem. ");
INSERT INTO smkNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ket kona nin nakarnge' nin man'ibarita' ko bale' kai na nin sunuren, ambo' ako a manintinsya, ta kai ako nin nakodti sa luta' ta pigaw nin sintinsyawan kosaray tutawo, no kai edet, ta pigaw nin isalba kosara. ");
INSERT INTO smkNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bale' main nin manintinsya konan si tawo nin andi' nin mangalilbi' kongko nin kai mangako' sa man'ibarita' ko. Sayti nin diri nin bubagay nin man'ibari-barita' ko a manintinsya li' kona no marate' a awro. ");
INSERT INTO smkNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wanin ta kai ko nin man'ibari-barita' ti nin bubagay nin nangibwat sa kaisipan ko nin bukod no kai edet, si Ama ko nin si nangibaki' kongko ket nigan-gan na no ani a ibarita' ko tan no pa'no nin pammarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kanya' nin say man'ibari-barita' ko tamo' ket say nigan-gan nan Ama ko bana' ta tanda' ko a say nigan-gan na ket pangibwatan nin anggan-angga nin byay a iti kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sawanin, adapen anay pista nin Nipanglabas. Tanda' na ni Jesus nin narate' ana a panaon a lumakwan yayna konan sitin mundo tan sumubli' yayna konan Ama na. Nangibwat sin tarana', kawa'nan nasaraynay tutawo na, ket sawanin, ipa'kit na no adti nin angga a pangangawa'nan na konra. ");
INSERT INTO smkNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Adapen raynan mangapon ni Jesus tan saray tumutumbok na. Ba'yo in et sin sain, naipasrep naynan Dimunyo sa kaisipan na ni Judas nin anak na ni Simon Iscariote a pagtraiduran nayan ipagamet si Jesus konran pupangulo. ");
INSERT INTO smkNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tanda' na anaod ni Jesus a nipagamet nayna nin Ama na kona a pakauray sa sarban mangyadi'. Tanda' na et a lamang a si Dios a nangibwatan na tan sya nin lamang a sublian na. ");
INSERT INTO smkNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mataman no wanin, sin mampangapon sara, inumdeng ya si Jesus tan linus'ok nayay kapa na, mi'sa ya nin niberber nin twalya sa awak. ");
INSERT INTO smkNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kaaram, nangwa ya nin ranom sa planggana, ba'yo na nin tinaranaan nin inuyasan a ayi ran tumutumbok na, mi'sa pinunasan na nin twalyan nakaberber sa awak na. ");
INSERT INTO smkNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ket, sin nako ya kona ni Pedro, wana ni Pedro kona, “Uunuren, ambale' a si'kamo et a manguyas nin ayi ko?” ");
INSERT INTO smkNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ket wana ni Jesus, “Kai mo nin mataros sawanin a man-gaw'en ko bale', matarusan moyna li' sa adapen.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Konan siin, wana ni Pedro, “Andyak! Kai gapo nin magwa' a uyasan moyoy ayi ko!” Bale' wana ni Jesus, “No kai kata nin uyasan, kai ka gapo nin makakibiang kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sin sain, wana ni Pedro, “Uunuren, no wanin edet, ambo' tamo' nin say ayi koy uyasan moyo no kai pati say gamet ko tan si ulo ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ket wana ni Jesus, “Si tawo nin naryo' ana, kai nayna nin matkap a maryo' anamana, bana' ta maringgas yayna. Say ayi na tana a matkap nin uyasan. Si'kamo, maringgas kamoyna, bale' ambo' nin sarba moyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nibarita' na ni Jesus in si ambo' nin sarba ra ket maringgas ana bana' ta tanda' nayna no si'no konra a magtraidor kona. ");
INSERT INTO smkNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sin nayadi' nayna nin inuyasan ni Jesus a ayi ra, nisulot naya anamana a kapa na tan sinmubli' ya sa lugar nadtaw sa pangnganan. Kaaram, wana konra, “Matarusan moyo para a kayadi' ko tamo' nin ginwa' komoyo? ");
INSERT INTO smkNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Say tawag moyo kongko ket Maistro tan Uunuren, ket kusto in ta siin ako. ");
INSERT INTO smkNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ket, ta si'ko nin si Uunuren tan Maistro moyo ket inuyasan koy ayi moyo, si'kamo, matkap a uyasan moyo anamaet a ayi nin saya tan saya. ");
INSERT INTO smkNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","16","Wanin, kanya' nin isipen moyoyti nin maong: Si sayay aripen, kai ya nin mas ata'gay dyan si amo na; wanin anamaet, si sayay nibaki', kai ya nin mas ata'gay dyan si namaki' kona. Ket ginwa' ko in komoyo nin mudilo nin arigen moyo ta pigaw nin gaw'en moyo anamaet a wanin konran kalalamo' moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ket sawanin, ta mataros moyoynayti, makarma' tan maririket kamo no gaw'en moyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Wanin man, ambo' nin sarba moyo a man'irgwen ko ta katanda' katamon maong a pinili' ko. Ket, matukid yay mabasa sa Masanton Kasuratan a wana, ‘Si mampakanen ko, nagtraiduran nako.’ ");
INSERT INTO smkNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Man'ibarita' koyaynayti komoyo sawanin ba'yo ya et nin matukid ta pigaw nin no natukid yayna nin liso ket mamper kamoyna a ‘Si'ko yay si Main Anggaynan-angga.’ ");
INSERT INTO smkNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Isipen moyoyti nin maong: Si mangako' kona nin si ibaki' ko, inako' nako, ket inako' naya anamaet a namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mayadi' na nin nibarita' in ni Jesus, maidap nin tuloy a nakem na ket wana nin diritsawan konran tumutumbok na, “Isipen moyoyti nin maong: Saya komoyo a magtraidor kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ket saray tumutumbok na nipastangan sara, a maguloy isip ra a no si'no a wana. ");
INSERT INTO smkNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Si tumutumbok nan kawa'nan na nin maong ni Jesus, syay iti sa dani na. ");
INSERT INTO smkNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininyasan nayayti ni Simon Pedro tan nipatepet na no si'no a man'irgwen na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Inmirig ya anaod nin inmadap a tumutumbok kona ni Jesus mi'sa wanan niyanas, “Uunuren, si'no ya in si wamoyo?” ");
INSERT INTO smkNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“Si pamyan ko konan siti si tinapay a man'isawit ko, sya,” niyanas nan ni'bat ni Jesus. Ket nangisawit ya anaod nin tinapay mi'sa naya nin nibi kona ni Judas nin anak na ni Simon Iscariote. ");
INSERT INTO smkNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eteng naya tana nin narisibi ni Judas a tinapay, sinumrep ya si Satanas kona. Ket wana ni Jesus kona ni Judas, “Gaw'en moynan tampor a matkap mo nin gaw'en.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Saray tumutumbok na ni Jesus nin kadungo na, kai ra nin matarusan a rabay na nin irgwen. ");
INSERT INTO smkNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ket bana' ta si Judas a mampanga'get nin kwarta ra, say wanra no nibaki' naya ni Jesus nin manaliw nin matkap ra no pista, o mako ya nin mami nin kwarta konra nin pubri. ");
INSERT INTO smkNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sin na'kan nayaynaytaw ni Judas si tinapay, nibwat yayna. Sin sain ket yabi ana. ");
INSERT INTO smkNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sin kasa yayna si Judas, wana ni Jesus, “Say ambo' ana nin ma'teng a mangyadi' kongko nin si Pinaitawo, ipadar no ambale' a nako akodti, tan mangipadar anamaet sa sangkaandaan nin gawa' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ket no naipadar anay kata'gayan nan Dios bana' kongko, si Dios, ipadar naynamaet a kata'gayan ko. Kai na nin pa'te-pa'tengen nin gaw'en ti. ");
INSERT INTO smkNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A'nak ko, ambo' ana nin ma'teng a kalamo' rako et. Tikapen rako li', bale' ibarita' koyti komoyo si nibarita' ko intaw konran pupangulo ran Judio, a kai kamo nin makapika' itaw sa keen ko. ");
INSERT INTO smkNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ket main nin ba'yo nin igan-gan ko komoyo: Matkap a kawa'nanen moyo a saya tan saya. Say pangangawa'nan moyo sa saya tan saya ket matkap a kapada nin pangangawa'nan ko komoyo ");
INSERT INTO smkNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ta, no kawa'nan moyo a saya tan saya, mangibwat sa sain, matandaan ran sarban tutawo a tumutumbok katamo.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nitepet na ni Simon Pedro, “Adti ket a keen moyo, Uunuren?” Ket ni'bat na ni Jesus, “Sa keen ko ket kai ka et nin makatumbok sawanin, bale' tumumbok ka li' sa adapen.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ket wana anamana ni Pedro, “Uunuren, ambale' a kai ako nin makatumbok sawanin ey? O' a ta iti ako nin sisasadya' nin mati para komoyo.” ");
INSERT INTO smkNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Inumbat ya si Jesus a wana, “Sisasadya' ka para nin page' nin mati para kongko? Bale' isipen moyti nin maong: Ba'yo main nin tumarang'ok nin manok, nitlo moyna nin nibudi' a katanda' nako.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Andi' kamo bale' nin aburido, no kai edet, magmatalek kamo konan Dios tan magmatalek kamo anamaet kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wanin ta sa kami'nan na nin Ama ko, abaw a piikapan. Tutuon peteg ti nin man'ibarita' ko komoyo, bana' ta mako koyna nin ariglawen para komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ket no nako koyna nin inarigla, sumubli' ako komoyo nin abrasawen katamo ta pigaw nin no adti ako ket, kalamo' katamo. ");
INSERT INTO smkNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Anaod, sa keen ko, tanda' moyaynay dalan nin makodtaw.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sin sain, wana ni Tomas, “Uunuren, kai mi nin tanda' no adti a keen moyo, pa'no miya nin tanda' a dalan ey?” ");
INSERT INTO smkNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Konan siin wana ni Jesus, “Si'ko a dalan nin mako konan Dios, ta si'ko a puon nin katutu'wan maipa'ka' konan Dios tan si mami nin byay a iti konan Dios. Kasan si'numan nin makakikalamo' konan Ama ko no kai ya yapo' et nin kikalamo' a sayay tawo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No peteg a katanda' moyokoyna, katanda' moyayna anamaet a Ama ko. Mangibwat ana nin sawanin, katanda' moyayna nin peteg tan na'kit moyayna.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ket wana ni Felipe, “Uunuren, ipa'kit moya pa edet komi a Ama moyo ket, mapda' kami ana.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Konan siin wana ni Jesus, “Felipe, na'teng rakoyna nin kalamo' ket ambale' a kai nako et nin katanda'? Si naka'kit ana kongko, na'kit nayayna a Ama ko. Ambale' a wamo et ket ipa'kit koya komoyo a Ama ko? ");
INSERT INTO smkNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kai ka para nin mamper a iti ako konan Ama ko tan si Ama ko ket iti ya kongko? Say man'ibari-barita' ko, kai nin nangibwat sa kaisipan ko nin bukod no kai edet, nangibwat konan Ama ko nin iti kongko ta syan lamang a man-gumwa' sa man'ipagwa' na kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kanya' nin mamper kamo sa wangko a iti ako konan Ama ko tan si Ama ko ket iti ya kongko. Ket no kai moyo sukat nin tepren a irgo ko, mamper kamo et a lamang bana' sa makapaka'ngap a man-gaw'e-gaw'en ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Isipen moyoyti nin maong: Si magmatalek kongko, magwa' na anamaet a makapaka'ngap nin man-gaw'e-gaw'en ko, tan mas et li' a magwa' na dyan sayti. Wanin ta mako akoyna konan Ama ko, ");
INSERT INTO smkNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ket animan a dawaten moyo bana' ta mangingilalaman kamo kongko, gaw'en ko ta pigaw nin maipata'gay ya a Ama ko bana' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Animan anaod a dawaten moyo bana' ta mangingilalaman kamo kongko, gaw'en ko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","No kawa'nan rako, tumulok kamo sa gan-gan ko; ");
INSERT INTO smkNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","si'ko anamaet, dawaten ko konan Ama ko a mamaki' ya nin kasubray ko nin tumulong komoyo, nin miikap ya komoyo anggan-angga. ");
INSERT INTO smkNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sya a Ispirito na nin mangyakay komoyo nin katutu'wan. Saray nasagyat nin say iti sa mundo, kai raya nin maako' bana' ta kai raya nin ma'kit, ni katanda'. Bale' si'kamo, katanda' moya, ta kalamo' moyayna tan miikap ya li' komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kai katamo nin lakwanan a bilang sayay ulila, ta sumubli' ako li'. ");
INSERT INTO smkNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa ambo' ana nin ma'teng, kai rakoyna nin ma'kit nin saray tutawodti sa mundo. Bale' si'kamo, ma'kit rako li' a lamang. Ket bana' ta mabyay akoynan si peteg nin byay, mabyay kamo li' anamaet. ");
INSERT INTO smkNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Konan sitaw li' nin panaon, matandaan moyo nin iti ako konan Ama ko. Matandaan moyon lamang a si'kamo, iti kamo kongko tan si'ko, iti ako komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Si tawon mangipasrep nin gugan-gan ko sa kanakman na ta pigaw nin tumulok ya sa sayti, syan diri a mampangado' kongko, ket si Ama ko, aduen naya tan si'ko anamaet, inado' koyayti tan ipadar kon diri a kanakman ko kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Konan siin nanepet ya si Judas (ambo' ya si Judas Iscariote) a wana, “Uunuren, ani a nangyadi' a paipadar kamo tamo' komi, nin ambo' konran sarba ran tutawodti sa mundo?” ");
INSERT INTO smkNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ket ni'bat na ni Jesus, “O' a ta si mangado' kongko, tumulok ya sa ibarita' ko. Sya a aduen nan Ama ko ket, si Ama ko tan si'ko, mako kami kona tan miikap kami kona. ");
INSERT INTO smkNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bale' si kai nin mangawa'nan kongko, kai na anamaet nin reng'en a ibarita' ko. Sayti say man'ibari-barita' ko, ambo' nin nangibwat sa kaisipan ko nin bukod no kai konan Ama ko nin si namaki' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nituloy na ni Jesus, “Nibarita' koynayti nin bubagay komoyo antaran iti ako et komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bale', ibaki' naya li' nin Dios komoyo a Ispirito na nin mangingilalaman kongko ta pigaw nin tulungan nakamo. Sya a mangyakay komoyo nin sarba, tan sya a mangipapanemtem komoyo nin sarba nin man'ibari-barita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Andi' kamo nin aburido tan mali'mo, bana' ta byan katamo nin katinekan nin nakem. Say katinekan nin ibi ko komoyo, ambo' nin say katinekan a man'irgwen ran tutawodti sa mundo no kai edet, say katinekan nin iti kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nibarita' koyna komoyo a lakwanan katamoyna bale' sumubli' akon lamang. No kawa'nan rako, rumiriket kamo bana' ta mako akoyna konan Ama ko a sya ket mas ata'gay ya dyan si'ko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Man'ibarita' koynayti sawanin komoyo ba'yo et nin mangyadi', ta pigaw nin no sayti ket nangyadi' ana li' ket, mamper kamo sa nibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kai koyna nin maiyanro et a pakiirgo ko komoyo ta manrumate' yayna si Satanas a syay mampag'uray konran tutawodti sa mundo. Kasa nin kapangyadian na kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wanin man, man'aburuyan koyti nin mangyadi' ta pigaw nin sarba ran tawo ket matandaan ra a kawa'nan koya a Ama ko, kanya' nin man-gaw'en kon maong nga'min a man'igan-gan na kongko. Sigi, pari kamoyna ta mako atamoyna.” ");
INSERT INTO smkNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Si'ko a pa'sar peteg nin puon nin ubas, tan si Ama ko a mangngalila'. ");
INSERT INTO smkNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mampukanen nasara a sarba ra nin pa'sar sanga nin kai man-gumunga, ket manrarusan nasara anamaet a pa'sar sanga nin man-gumunga ta pigaw nin mas gumunga sara et. ");
INSERT INTO smkNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ket si'kamo a susanga nin nararusan ana mangibwat sa niyakay-akay ko komoyo nin nipasrep moyo sa kukanakman moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ituluy-tuloy moyo a naipasaya kongko ta pigaw nin ituluy-tuloy ko anamaet a naipasaya komoyo. Si sayay sanga, kai ya gapo nin gumunga no naisyay ya konan puon. Wanin anamaet, si'kamo, kai kamo nin magkamain nin pa'sar bunga para konan Dios no kai moyo nin ituluy-tuloy a naipasaya kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wana anamanaet nin inuman ni Jesus, “Si'ko a pa'sar puon nin ubas ket si'kamo a pa'sar susanga. Si si'numan a tumuluy-tuloy nin naipasaya kongko ta pigaw nin iti ako anamaet kona, siin nin tawo ket abaw a pa'sar bunga na para konan Dios, bana' ta si sayay tawo, kasa nin mababa' na nin gaw'en no kasa ako kona. ");
INSERT INTO smkNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ket si si'numan anamaet a kai nin tumuluy-tuloy nin naipasaya kongko, kapada na a sanga nin napukan nin nitampal. Ket no nakri' anayti li' nin susanga, dinepen tan puuran. ");
INSERT INTO smkNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bale' no tumuluy-tuloy kamo nin naipasaya kongko tan ipasrep moyo sa kukanakman moyo a man'ibarita' ko ta pigaw nin tumulok kamo sa sayti, animan a dawaten moyo ket maibi komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mapagalangan ya a Ama ko no abaw a bunga moyo para kona, tan sayti ket mangipa'kit a tumutumbok katamo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Inado' katamo kapada nin pangangado' na nin Ama ko kongko. Ituluy-tuloy moyoy miikap sa pangangado' ko komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","No tumulok kamo sa gugan-gan ko, miikap kamo sa ado' ko; a bilang anaod sa katutulok ko sa gugan-gan nan Ama ko, tan mampiikap ako sa ado' na. ");
INSERT INTO smkNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nibarita' koyti komoyo ta pigaw nin mairama' kamo sa ririket ko tan malipos kamon ririket moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Igan-gan koyti komoyo: Aduen moyo a saya tan saya kapada nin pangangado' ko komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Si sangkaalakyan nin pangangado' a maipa'kit nan sayay tawo ket, si mati ya ta pigaw nin mabyay saray uamigo na. ");
INSERT INTO smkNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Anaod, uamigo katamo no tumulok kamo sa gugan-gan ko. ");
INSERT INTO smkNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ambo' ana nin aripen a pangngikwinta ko komoyo no kai edet, uamigo, bana' ta si sayay aripen ket kai na nin tanda' a iti sa kaisipan nan amo na. Bale' si'kamo, nipatandaan koyna nga'min komoyo a narnge' ko konan Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ambo' nin si'kamo a namili' kongko, no kai edet, si'ko a namili' tan nanudo' komoyo. Ginwa' ko in ta pigaw nin mako kamo nin magkamain kamo nin bunga para kongko, a sain nin pa'sar bunga moyo ket magnayon anggan-angga, tan ta pigaw nin animan a dawaten moyo konan Ama ko bana' ta mangingilalaman kamo kongko, ket maibi komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Man'ibibilin ko komoyo maipa'ka' sa sayti a anaod ket, aduen moyo a saya tan saya.” ");
INSERT INTO smkNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Andi' kamo nin maka'ngap no guraen rakamon tutawodti sa mundo. Panemtemen moyo tana a nu'na rakoyna nin ginura' dyan si'kamo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No say pigagawa' moyo kumon ket minumundo a kapada nin pigagawa' ra, kalalamo' rakamo kumon nin inado' ra. Bale' anaod, kalalamo' katamo ta pinili' katamo ta pigaw nin maiduma kamo konran raruman tawodti sa mundo, ket siin a rason a guraen rakamo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Panemtemen moyaytaw si naibarita' koyna komoyo a si sayay aripen, kai ya nin mas ata'gay dyan si amo na. No dinuksa-duksa' rako, duksa-duksaen rakamo anamaet. No tinmulok sara kumon sa nibari-barita' ko, tumulok sara anamaet sa ibari-barita' moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bale' bana' ta mangingilalaman kamo kongko, gaw'en ra a sarban sain komoyo. Wanin ta kai raya nin katanda' a si namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No kai ako kumon nin nakodti nin niparate' konra a no ani a nangibwat konan Dios, ambo' ra kumon nin kasalanan a kai rayti nin akuen. Anaod sawanin, kasayna nin maibada' ra sa pagkakasalanan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Si mampangura' kongko ket man-guraen naya anamaet a Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ambo' ra et kumon nin kasalanan no kai ko nin nipa'kit konra a makapaka'ngap nin nunangyadi' a kasa et gapo nin raruma nin nakapangwa'. Wanin man, abirno nin na'kit ra a ginwa-ginwa' ko, man-guraen rako et a lamang tan si Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bale' mampangyadi' ti anaod nin pakatukid sa wana sa Masanton Kasuratan a, ‘Guraen rako nin kasan puon tan pwit.’ ");
INSERT INTO smkNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Sawanin, mangipatutuo ya li' nin maipa'ka' kongko a Ispirito nin ibat konan Ama ko. Ibaki' koya komoyo nin mako ya tumulong komoyo. Si pangibwatan na ket si Dios ket mangyakay yan katutu'wan maipa'ka' kona. ");
INSERT INTO smkNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Si'kamo anamaet, patutu'wan moyo li' a maipa'ka' kongko, bana' ta nikikalamo' kamoyna kongko nangibwat et sin tarana'. ");
INSERT INTO smkNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nibarita' koyna in komoyo ta pigaw nin kai kamo li' nin mabigra' ket gurutan moyoy pammemper moyo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","O', galten rakamoyna li' sa pidudupong tan pangrarayo ra konan Dios nin saray kapada moyon Judio. Saya et, marate' li' a awro a main nin mangmati komoyo nin ipa'ka' ra a pagsisirbi rayti konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gaw'en ra in bana' ta kai raya nin katanda' a Ama ko tan si'ko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ket, man'ipau-pau'na koyna in komoyo ta pigaw nin no mampangyadi' ana li' ket mapanemtem moyon naibarita' koynayti intaw komoyo.” “Kai ko nin nibarita' in komoyo sin tarana' et bana' ta kalamo' rako et, ");
INSERT INTO smkNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","bale' sawanin, man'ibarita' koyna bana' ta sumubli' akoyna kona nin si namaki' kongko. Ket kasa tana para gapo komoyo nin manepet no adti a keen ko? ");
INSERT INTO smkNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wanin anaod bana' ta sa narnge' moyon nibarita' ko ket mabereng kamo. ");
INSERT INTO smkNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bale' say katutu'wan, para sa kaabigan moyo a lumakwan ako. Wanin ta no kai ako nin lumakwan, kai ya anamaet nin makodti komoyo a Ispirito na nin Dios. Bale' no lumakwan ako, ibaki' koyadti li' nin tumulong komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Saytaw no iti yayna li', patutu'wan na konran abaw nin tutawo a abas a pakatanda' ra maipa'ka' sa kasalanan, maipa'ka' sa no ani a mapteg sa adapan nan Dios tan maipa'ka' sa paninintinsya na nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Patutu'wan na konra a maipa'ka' sa kasalanan ta kai sara nin mampagmatalek kongko ket kasalanan ra in. ");
INSERT INTO smkNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Patutu'wan na et konra a maipa'ka' sa no ani a mapteg sa adapan nan Dios ta mako akoyna konan Dios a syay Ama ko, ket kai moyoyna li' nin ma'kit a kinamapteg ko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Patutu'wan na et anamaet konra a maipa'ka' sa paninintinsya nan Dios konra ta si Satanas a syay mampag'uray konran tutawodti sa mundo, sinintinsyawan nayaynan dusawen. ");
INSERT INTO smkNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Abaw et a ibarita' ko komoyo nin kai ko et nin maibarita' sawanin bana' ta kai moyo et nin maabot nin tarusan. ");
INSERT INTO smkNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bale' no iti yayna li' a Ispirito nin mangyakay nin katutu'wan, ipatyo' na li' a kaisipan moyo nin matandaan moyo a sarban katutu'wan. Wanin ta, ambo' li' nin mangibwat kona nin diri a ibarita' na, no kai edet, ipatandaan na a marnge' na mangibwat konan Dios. Ket, pati say mangyadi' sa adapen, ipatandaan na et komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pagalangan nako li' bana' ta say no ani a iti kongko ket saytaw a ipatandaan na komoyo. ");
INSERT INTO smkNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wangko a no ani a iti kongko ket sayti a ipatandaan nan Ispirito nan Dios komoyo bana' ta, say sarban iti konan Ama ko, ket saytaw anamaet a lamang a iti kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","O', sa ambo' ana nin ma'teng ket kai rakoyna nin ma'kit, bale' sa ambo' li' a lamang nin ma'teng, ket ma'kit rako anamanaet.” ");
INSERT INTO smkNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sin wanin a wana ni Jesus, saray raruma konran tumutumbok na wanra sa saya tan saya, “Ani kadi' a rabay na nin irgwen? Wana sa ambo' ana nin ma'teng ket kai tamoyayna kano nin ma'kit; mi'sa wana sa ambo' li' bale' anamaet nin ma'teng ket, ma'kit tamoya anamana kano, tan wana et ket mako ya kano konan Ama na. ");
INSERT INTO smkNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Siin si wana nin sa ambo' ana nin ma'teng, ani a rabay na nin irgwen? Kai tamo nin mataros.” ");
INSERT INTO smkNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tanda' na ni Jesus a rabay ray manepet kona kanya' nin wanayna konra, “Ambo' para a mampitepetan kamo sa saya tan saya maipa'ka' sa wangko a sa ambo' ana nin ma'teng ket kai rakoyna li' nin ma'kit, bale' sa ambo' li' a lamang nin ma'teng ket ma'kit rako anamana? ");
INSERT INTO smkNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Isipen moyoyti nin maong: Umakis tan gumereng kamo li'; saray kai bale' nin tumumbok kongko, ket rumiriket sara. Gumereng kamo anaod, bale' say kaberengan moyo, masilyan li' nin ririket. ");
INSERT INTO smkNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Say kapada ket say masakit a pangingirangep nan idap nin sayay mangabing. Bale' kayadi' nayna li' nin mangabing, malingwanan nayna a idap na bana' ta pinasya ana li' nin ririket na bana' ta naiyabing yayna a anak na. ");
INSERT INTO smkNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kapada nin siin a kapapa'sar moyo bana' ta sawanin ket mabereng kamo. Bale' marate' li' a awro a makapiki'kit atamo anamana, ket maririket kamo li'. Ket sa sain nin ririket moyo, kasa li' gapo nin makapanglat. ");
INSERT INTO smkNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","No saytaw li' nin panaon, kasaynan matkap moyo nin itepet kongko. Isipen moyoyti nin maong: Animan a dawaten moyo konan Ama ko, ibi na komoyo bana' ta mangingilalaman kamo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Anggan sa sayti nin udas, kasa et gapo nin dinawat moyo kona a naipatukdo' sa pag'in moyon mangingilalaman kongko. Sawanin bale', kidawat kamo ket mabyan kamo ta pigaw nin makusto a ririket moyo. ");
INSERT INTO smkNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Man'ibari-barita' koyti nin bubagay a mampangusar ako nin ararem a pananarita'. Bale' sa adapen nin panaon, kai akoyna nin mangusar nin ararem a pananarita', no kai edet, ibarita' koyna komoyo nin diritsawan a maipa'ka' konan Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","No saytaw li' nin panaon, syayna li' a kidawatan moyo bana' ta si'kamo ket mangingilalaman kamo kongko. Kai ko nin man'ibarita' a si'ko a kidawat kona para komoyo ");
INSERT INTO smkNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bana' ta si Dios nin Ama ket inado' nakamo nin diri. Inado' nakamo bana' ta inado' rako tan mamper kamo a nangibwat ako kona. ");
INSERT INTO smkNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Si Ama ko a ibwatan ko nin nakodti sa mundo, tan sya li' lamang a sublian ko ta lumakwan akoynadti sa mundo.” ");
INSERT INTO smkNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sin narnge' ra in nin tumutumbok na nin wana, wanra kona, “Sawanin ket mapala-palaway anay man'ibarita' moyo bana' ta diritsawan anay pag'iirgo moyo a kai kamoyna nin mampangusar nin ararem a pananarita'. ");
INSERT INTO smkNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sawanin anaod, tanda' mi anan peteg a tanda' moyo a sarba. Pati say tutepet a iti sa kanakman nin tawo, kai ana nin matkap nin ibalikas komoyo ta tanda' moyoyna. Kanya' nin mamper kami a nangibwat kamo konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ket ni'bat na ni Jesus konra, “Peteg para nin mamper kamoyna? ");
INSERT INTO smkNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ket narate' ana anaod a panaon a si'kamo ket misisyak kamo a magsiugot kamoyna sa pammali moyo ket lakwanan rakoyna nin bukud-bukod. Wanin man, ambo' kon talagan bukud-bukod ta kalamo' koyay Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Man'ibarita' koyti komoyo ta pigaw nin matinek a kaisipan moyo mangibwat sa nikaipasaya moyo kongko. Peteg a mapadya'dya' kamodti sa mundo. Wanin man, pakagsen kamo bana' ta nadaeg koyna a kukapangyadian iti sa mundo.” ");
INSERT INTO smkNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nibarita' na in ni Jesus. Ket mayadi', tinmangar ya sa langit tan wana, “Ama ko, narate' ana a panaon nin pangingirangep ko. Ipadar moy kinasi'no ko nin Anak mo ta pigaw nin maipadar ko anamaet a kinasi'no mo nin Ama ko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gaw'en mo in ta pigaw nin ibi koy anggan-angga nin byay a iti komo konran sarba ran nipudir mo kongko, ta nibi mo kongko a pakayadi' konran sarban tutawo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ket siti e a pipa'kaan nin anggan-angga nin byay a iti komo: Si katanda' raka a si'ka tamo' a peteg nin Dios tan katanda' rako nin si nibaki' mo a si Jesu-Cristo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nipadar koynay kinasi'no modti sa mundo ta nagwa' koyna a nipagwa' mo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ket sawanin, Ama ko, isubli' nako anadsen komo, sa kata'gayan nin pa'sar nin pikalamo' ta sin ba'yo ya et nin pinarsa a mundo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Saraytin tawo a nipudir mosara kongko, nipadar ko konra no si'no kan peteg. Minumundo a kabibyay ran gindat bale' ikon mosara tan nipudir mosara kongko. Ket tinmulok saran liso sa nibarita' mo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sawanin tanda' rayna a si'kay ibwatan nin sarban ginwa' tan nibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Anaod, inako' ra nga'min a nibarita' ko konra nin nibarita' mo kongko, tan sigurado saran si'ka a ibwatan ko tan namper saran maong nin si'ka a namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sarain a man'idasalan ko ta tutawo mosara. Ambo' nin saray kai nin tumumbok kongko a man'idasalan ko no kai edet, saray tutawo mo nin nipudir mo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","O' anaod, sarba nin ikon ko ket ikon mo, tan sarba nin ikon mo ket ikon ko anamaet. Ket sarayti, man'ipadar ray kinasi'no ko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kai ako nin magpirmi konan sitin mundo no kai edet, sumubli' akoyna komo. Sara bale', mabati' saradti. Ket, masantos a Ama ko, alilaen mosara pa nin makapagkabyay sara sigon sa kinasi'no mo a nitalek mo kongko ta pigaw nin mipapasaya sara kapada a napasaya ata. ");
INSERT INTO smkNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Leleg a iti ako konra, inalila' kosara nin magkabyay sara sigon sa kinasi'no mo a nitalek mo kongko. Nisakit kosara ket peteg a kasa gapo nin naisyay kongko no kai kal-la tamo' sitaw si naiketeg ana nin madusa sa impyirno. Wanin a nangyadi' ta pigaw nin say naisurat ket matukid. ");
INSERT INTO smkNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ket anaod, sumubli' akoyna li' komo, bale' iti ako et konan sitin mundo. Kanya' nin man'idasal koyti sawanin ta pigaw nin matawayan raynamaet nin peteg a ririket nin iti kongkon diri. ");
INSERT INTO smkNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nipadar ko konra a say rabay mon ipatandaan, ket nag'in gura' rasara anamaet nin saray kai nin tumumbok kongko. Wanin ta kapada kosaran naiduma konran raruman tawo nin say kaisipan ra ket iti tamo' sa mundo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wanin man, kai ko nin dawaten a galten mosaradti sa mundo no kai edet, a idipinsa mosara konan si sya a Kadukaan. ");
INSERT INTO smkNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ambo' saran iti sa sakop nadti sa mundo no kai kapada kosara. ");
INSERT INTO smkNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ket, italaga mosaran para komo nin pakaipadaran nin say katutu'wan maipa'ka' komo. Say sarita' a mangibwat komo, ket sayti a katutu'wan maipa'ka' komo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ibaki' kosara konran kapada ran tutawodti sa mundo nin kapada nin nipamaki' mo kongkodti ");
INSERT INTO smkNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","tan italaga koy kadiryan ko para konra ta pigaw nin peteg a maitalaga saran ikon mo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ambo' nin sara tamo' a man'idasalan ko no kai edet, pati saray magmatalek li' kongko mangibwat sa ipata-patandaan ra maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ama ko, sapa kumon ta mipapasaya sara kapada a nipasaya ata. Sapa anamaet kumon a naipasaya sara kontamo kapada a si'ka ket naipasaya ka kongko tan si'ko ket naipasaya ako komo, ta pigaw nin saray tutawo ket mamper sara a si'ka a namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Say nipaipadar mon kata'gayan nin kinasi'no mo kongko ket sain a ipadar ko anamaet konra ta pigaw nin mipapasaya sara kapada a napasaya ata. ");
INSERT INTO smkNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naipasaya ako konra tan naipasaya ka kongko ta pigaw nin peteg saran mipapasaya. Ket no wanin, matandaan ran lawas nin tutawo a si'ka a namaki' kongko tan say pangangawa'nan mo konra, ket kapada nin pangangawa'nan mo kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama ko, rabay ko et a saray tutawo nin nipudir mo kongko ket kalamo' kosaran pirmi ta pigaw nin kirama' sara sa kagalangan ko. Siti a kagalangan nin nibi mo kongko bana' ta kawa'nan nakoyna ba'yo ya et nin pinarsa a mundo. ");
INSERT INTO smkNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mapteg a Ama ko, saray ka'bawan nin tutawo ket kai raka nin katanda'. Si'ko bale', katanda' kata; tan sarayti saray tumutumbok ko, tanda' ra a si'ka a namaki' kongko. ");
INSERT INTO smkNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ket nipatandaan ko konra no si'no ka, tan man'ituluy-tuloy koyti nin man-gaw'en ta pigaw nin kawa'nanen ra a sarba kapada nin pangangawa'nan mo kongko tan ta pigaw nin miikap ako konra.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sin nayadi' nayna nin nidasal in ni Jesus, nibwat sara nin saray labinsayay tumutumbok na tan nako saradtaw sa rubari' nan sapa' nin Kidron. Ket linmuob sara konan sayay pukok itaw a namulawan nin kukayo. ");
INSERT INTO smkNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas a syay magtraidor kona ni Jesus, tanda' nayayti nin lugar bana' ta pirmi yan makodtaw si Jesus tan saray tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kanya' nin itaw nasara nin ni'ras a grupo nin sundalo' tan gwardya sa Timplo nin nibaki' ran saray Pupangulon Pupadi' tan saray Pariseo. Nagsiawit sara nin tyo' ra tan di-armas sara. ");
INSERT INTO smkNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tanda' na nga'min ni Jesus a mangyadi' kona kanya' nin sinna' nasarayna tan tinepet na, “Si'no a mantikapen moyo?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Si Jesus a taga Nazaret,” ni'bat ra. “Si'ko yan diri,” wana. Naka'deng yadtaw nin kalamo' ra sin sain si Judas a nagtraidor kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sin nibarita' na ni Jesus a sya anaod, inmanunor sara ket natumba sara. ");
INSERT INTO smkNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ket tinepet na anamanaet ni Jesus, “Si'no ket a mantikapen moyo?” “Si Jesus a taga Nazaret,” wanra. ");
INSERT INTO smkNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Nibarita' koyna anaod komoyo a si'ko yan diri,” wana ni Jesus. “No wanin a si'ko a mantikapen moyo, aburuyan moyo saran mako anayti saray kalalamo' ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa wanin ket matukid yaytaw si wana konan Ama na, “Ni saya tamo', kasa gapo nin maisyay kongko konran saray nipudir mo kongko.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ket si Pedro, tampor nayan inuyos a beneng na tan tinaga' nayay sayay katulong nan Sangkata'gayan nin Padi'. Ket naglat yan nataga' a wanan nin tutulyan nan katulong a say ngaran na ket Malco. ");
INSERT INTO smkNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wana ni Jesus kona ni Pedro, “Ikaluban mayna in si beneng mo! Sa wamo para ket ambo' akon disidido nin mangirangep nin dya'dya' a ipairangep nan Ama ko kongko?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Konan siin, saray sundalo' nin taga Roma a nipangulo nan kapitan ra tan saray gwardya nin Judio sa Timplo, dinakep raya si Jesus ket binaror ray gamet na. ");
INSERT INTO smkNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nu'na raya nin niyadap kona ni Anas nin katyangan na ni Caifas. Si Caifas a Sangkata'gayan nin Padi' sin sain a taon. ");
INSERT INTO smkNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Sya anamaet a namarita' intaw konran Judio a wanan maong ana konan sayay tawo a mati ta pigaw nin maisalba saray ka'bawan. ");
INSERT INTO smkNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro tan si saya et nin tumutumbok na ni Jesus, tinmumbok sara. Siti nin saya et nin tumutumbok, katanda' nayan Sangkata'gayan nin Padi', kanya' nin inaburuyan ya nin sumrep nin kalamo' na ni Jesus sa luob nin pukok nan bali nan padi', ");
INSERT INTO smkNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","bale' si Pedro, nabati' yadtaw sa rikor nan purta nin pukok. Sin wanin, sitaw si tumutumbok a katanda' nan Sangkata'gayan nin Padi', linmiwa' ya tan kina' naya nin kinairgo yaytaw si balasang a mampamantay sa purta. Ket inmaburoy ya nin paluuben ya si Pedro. ");
INSERT INTO smkNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sin manlumuob ya si Pedro, wana nin balasang kona, “Sa wangko saya ka anamaet nin tumutumbok nan siin a tawo.” Ket, “Kai,” ni'bat na ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Maray'ep sin sain, kanya' nin saray aripen tan saray gwardya ket namabaya saran uring nin pairangrangan ra. Ket, nikilawok yan pinairangrang si Pedro konra. ");
INSERT INTO smkNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sawanin, tinepetan naya nin si gindat a Sangkata'gayan nin Padi' si Jesus maipa'ka' konra nin tumutumbok na tan say akay na. ");
INSERT INTO smkNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Inumbat ya si Jesus, “Adap-adapan akon nag'irgo sa pangrerenge' ran abaw a tutawo; nangyakay-akay ako sa susinaguga tan itaw sa sakop nan Timplo, nin sayti a lugar nin pididinepan ran sarban Judio. Kasa gapo nin nibarita' ko nin budian. ");
INSERT INTO smkNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ambale' nin si'koy usisaen moyo? Saray matkap moyo nin usisaen ket saray nakarnge' kongko ta tanda' ra no ani a nibari-barita' ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sin wanin a ubat na ni Jesus, rinampa' naya nin saya konran gwardya nin itaw, a wana nin siti, “Ambale' a ubatan man wanin a Sangkata'gayan nin Padi'?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Inumbat ya si Jesus a wana, “No main nin ni'bat ko nin abas, ibarita' mo ta pigaw nin matandaan. Bale' no kasa anamaet, ambale' a rinampa' nako?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ket say sinmunor, nipaiyater naya ni Anas si Jesus nin nabaror et a gamet na, kona ni Caifas a syay Sangkata'gayan nin Padi'. ");
INSERT INTO smkNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Pedro anamaet, itaw ya et nin nikilawok nin mampairangrang, ket wanran itaw kona, “Sa wami saya ka anamaet nin tumutumbok nan siin a tawo.” “Kai pa!” ni'bat na ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sin sain, main nin aripen nadtaw nin Sangkata'gayan nin Padi' a siti ket kanayon nayan sitaw si naglatan nin tutulyan a tinaga' na ni Pedro. Wana kona ni Pedro, “Ambo' para a saya ka konran na'kit kon kalalamo' nadtaw sa pukok nin kukayo?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bale' nibudi' na anamana in ni Pedro. Bigra' a main nin tinmarang'ok nin manok. ");
INSERT INTO smkNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mayadi' ya nin nausisa' si Jesus itaw sa bali na ni Caifas, buklas ana. Ket saray pupangulo ran Judio, ni'ras raya sa palasyo na ni Gubirnador Pilato a mantawagen nin Pretorio. Kai sara nin sinumrep a Judio sa palasyo nan gubirnador ta pigaw nin kai sara nin maikwintan nikasama' ket kai sara maawaan nin mangisilibran Pistan Nipanglabas. ");
INSERT INTO smkNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Konan siin, linmiwa' ya si Pilato tan nitepet na konra, “Ani a riklamo moyo kuntra konan sitin tawo?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ket ni'bat ra, “No kasa nin ginwa-ginwa' nan duka' nin siti, kai miya kumon nin ni'ras iti komo.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Konan siin wana ni Pilato, “Si'kamoynay makauray. Si'kamoynay manintinsya kona sigon sa Gugan-gan moyo.” Ket ni'bat ra, “Si'kami bale' nin Judio ket kasa nin pakayadi' mi nin manusan patiti.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wanin a nangyadi' ta pigaw nin saytaw say nibarita' na ni Jesus maipa'ka' sa klasin pangmamati kona, ket matukid. ");
INSERT INTO smkNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sin sain, linmuob yayna sa palasyo na si Pilato, mi'sa naya nin nipakayaban si Jesus. Tinepet na kona, “Si'ka paran page' a Adi' ran Judio?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Inumbat ya si Jesus, “Nitepet mo in para mangibwat sa nakem mo nin bukod o mangibwat sa darom nin raruma?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ket ni'bat na ni Pilato, “Ya, ambale'! Saya ako para nin Judio? Saran diri a kapada mo nin Judio tan saray pupangulo ran pupadi' moyo a nangipagamet komodti kongko. Ani ket a ginwa' mo?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Inumbat ya si Jesus a wana, “Say pag'aadi' ko, ambo' nin kapada konran saray mag'uuray iti sa mundo ta no saya ako kumon nin adi' iti sa mundo, saray tutawo ko, nikilaban sara kumon ta pigaw nin kai ako nin naipagamet konran mumag'uray nin Judio. Bale' anaod, say pag'aadi' ko ket ambo' nin iti konan sitin sakop.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sin sain, wana ni Pilato, “No wanin edet, saya ka nin adi'!” Inumbat ya si Jesus, “Si'kamo a mampamarita' a saya akon adi'. Say gagara ko nin nakodti sa luta' nin nipaiyanak ket ta pigaw nin ipatandaan koy katutu'wan. Ket si si'numan nin mamaalaga sa katutu'wan, akuen na a man'ibari-barita' ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ket konan siin, nitepet na ni Pilato, “Ani wadi' a katutu'wan?” Kayadi' na nin inirgo in, linmiwa' ya anamana si Pilato tan wana konran Judio, “Kasan ma'kit ko nin kasalanan na. ");
INSERT INTO smkNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bale' main nin ugali' moyo a mangibulos ako nin sayay priso tepe' nin Pistan Nipanglabas. Rabay moyo para nin bulusan koyayti si Adi' moyon Judio?” ");
INSERT INTO smkNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ket, “Kai, ambo' ya in!” wanra nin niburyaw. “Si Barrabas a rabay mi!” Siti si Barrabas ket saya ya nin tulisan. ");
INSERT INTO smkNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mayadi' in, nipakalap naya ni Pilato si Jesus tan nipasanet-sanet naya. ");
INSERT INTO smkNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kaaram, saray sundalo', namalukay saran madiwin wakay a kuruna kano wadi' tan nikuruna rayayti kona ni Jesus. Kaaram, sinulutan rayan kapa nin kulor ubi. ");
INSERT INTO smkNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mi'sa, nibabale' sara nin inmarak kona a wanra, “Viva Adi' ran Judio!” Ba'yo raya nin rinampa-rampa'. ");
INSERT INTO smkNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Linmiwa' ya anamanaet si Pilato tan wana konra nin Judio, “Mangrenge' kamo! Iyadap koyadti komoyo ta pigaw nin matandaan moyo a kasa nin ma'kit kon nepeg nin panintinsyawan ko kona.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ket linmiwa' ya anaod si Jesus, a main nin kuruna na nin didiwi tan nakasulot yan kapa nin kulor ubi. Wana ni Pilato, “Sya ey tawo!” ");
INSERT INTO smkNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ket ka'kit ran pupangulo ran pupadi' tan saray gwardya sa Timplo kona ni Jesus, niburyaw ra, “Ipaipasak ma in sa kudos! Ipasak ma!” Bale' wana ni Pilato, “Kalapen moya edet, tan si'kamo a mangipasak kona sa kudos ta si'ko, kasa nin ma'kit ko nin kasalanan na.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ket inumbat saray Judio, “Sigon sa Gugan-gan mi, manepeg ya nin patyen bana' ta man'ibari-barita' na a sya kano a Anak na nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sin narnge' nayti ni Pilato, mas lalo yayna nin mali'mo, ");
INSERT INTO smkNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ket linmuob ya anamanaet sa bali na tan tinepet na kona ni Jesus, “Ambale'? Adti ka nin taga?” Bale' kai ya nin inumbat si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Edet, wana ni Pilato kona, “Ambale' a andi' ka nin umbat? Kai mo para nin tanda' a main nin pakayadi' ko nin ibulos kata o ipaipasak kata sa kudos?” ");
INSERT INTO smkNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Konan siin inumbat ya si Jesus ket wana kona, “Kasa kumon nin pakayadi' mo kongko no kai na nin nibi nin Dios komo. Kanya' nin mas mabyat a kasalanan nan si nangipagamet kongko komo dyan sa kasalanan mo.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sin narnge' nayti ni Pilato, ginwa' nay magwa' na nin maibulos naya si Jesus. Bale', saray Judio, nituluy-tuloy ra nin niburya-buryaw, “No bulusan ma in nin tawo, say rabay nin irgwen ket ambo' naka nin amigo nin Impirador ta si saya nin mangibarita' a saya ya nin adi', ket mangkuntrawen nayay Impirador!” ");
INSERT INTO smkNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sin narnge' na in ni Pilato nin man'iburya-buryaw ra, nipailiwa' naya anamana si Jesus, mi'sa ya nin tinmekre' sa lugar nin paninintinsyawan itaw sa parti nin mantawagen nin Simintadon Tutukduan, a sa sarita' nin Hebreo ket Gabata a tawag. ");
INSERT INTO smkNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Awro yayti nin Pananadya' sa Pista nin Nipanglabas. Sin sain, dandani alas dose ana nin ugtiawro. Ket wana ni Pilato konra nin Judio, “Sya e a Adi' moyo!” ");
INSERT INTO smkNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bale' niburya-buryaw ra, “Patyen ma! Patyen ma! Ipasak ma sa kudos!” Ket wana ni Pilato, “Rabay moyo nin ipasak koya sa kudos a Adi' moyo?” Konan siin, ni'bat ran saray pupangulo ran pupadi', “Si Impirador tamo' a adi' mi! Kasayna nin raruma!” ");
INSERT INTO smkNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sin wanin, nipagamet naya ni Pilato konra si Jesus nin ika' raya nin ipasak sa kudos. Ket saray sundalo', ");
INSERT INTO smkNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","nipabalatay raya kona ni Jesus a kudos na tan nika' rayadtaw sa lugar a mantawagen nin Lugar nin But'ol Ulo. Say tawag kona sa sarita' ran Judio ket Golgota. ");
INSERT INTO smkNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Itaw, nipasak raya sa kudos si Jesus, karngan ran rwa ra et nin tawo, saya iti sa wanan na tan saya sa wiri. ");
INSERT INTO smkNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ket main yaytaw si nipaisurat na ni Pilato nin nipasak radtaw sa kudos na ni Jesus. Siti a wana: SITI SI JESUS A TAGA NAZARET, SI ADI' RAN JUDIO. ");
INSERT INTO smkNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ket abaw saray Judio nin nakabasa konan siti bana' ta naisurat yayti sa sarita' nin Hebreo, Latin tan Griego, tan si lugar nin nangipasakan ra sa kudos kona ni Jesus ket adani ya tamo' sa syudad nin Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sin wanin, nako saray pupangulo ran pupadi' ran Judio kona ni Pilato tan wanra, “Ambo' kumon nin ‘Adi' ran Judio’ a nisurat mo no kai edet, ‘Wana nin sitin tawo, syay adi' ran Judio.’ ” ");
INSERT INTO smkNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bale' ni'bat na ni Pilato, “Say naisurat ko, naisurat koyna.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Saray sundalo' anamaet, sin nayadi' rayayna nin nipasak si Jesus, pini'pat ran nitaw'a-taw'an a seket na, bale' kai konan bata na. Wanin ta si bata na, kasa nin pidaraitan na bana' ta inabel yan diri-diritso. ");
INSERT INTO smkNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kanya' nin wanran sundalo', “Andi' tamoyayti nin bisang-bisangen. Say mabista, mibunutan atamo no si'no a pikaan na.” Nangyadi' ti ta pigaw nin matukid taw say mabasa sa Masanton Kasuratan a wana, “Nitataw'an ray seket ko. Ket si bata ko, nibubunutan raya.” Wanin anaod a ginwa' ra nin sundalo'. ");
INSERT INTO smkNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Itaw sa dani nan kudos na ni Jesus ket naka'deng ya si nanay na, si busat nan babayi ni nanay na, si Maria nin asawa na ni Cleopas tan si Maria nin taga Magdala. ");
INSERT INTO smkNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sin nadungdungan naya ni Jesus si nanay na tan si kawa'nan nan maong nin tumutumbok na nin naka'deng anamaet itaw, wana kona ni nanay na, “Syayna sawanin a anak mo.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mi'sa, wana anamaet konan tumutumbok na, “Syayna sawanin a ina mo.” Ket konan siin, sitaw si tumutumbok na, ni'ras nayayna si nanay na ni Jesus nin miikap anadtaw sa bali na. ");
INSERT INTO smkNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sin sain, sin nayadi' anayti, tanda' na ni Jesus a nagwa' nayna nga'min a matkap na nin gaw'en. Ket ta pigaw nin matukid a naisurat sa Masanton Kasuratan wana, “Milata' ako.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Main itaw nin yawong nin main laman nin maalsem nin arak. Ket saray sundalo', nangipaalep'ep saradti nin ispungha, mi'sa rayayti nigalet sa parpar nin kayu-kayo nin tanaman a mantawagen nin isopo, tan niyabot rayayti sa bebey na ni Jesus ta pigaw nin sepsepen naya. ");
INSERT INTO smkNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ket sin nasepsep naynayti ni Jesus wana, “Nayadi' ana!” Kaaram, nitwek nayayna a ulo na tan niparisibi nayayna a byay na konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kinadilapan konan siin nin awro ket syay Awron Painawa. Konra nin Judio, ambo' nin manepeg a itaw et a bangkay sa kudos no rumate' a Awron Painawa tan naiduma yayti nin awro bana' ta naibansag a pista. Kanya' nin saray pupangulo ket nika' ra nin nibarita' kona ni Pilato a saraytaw saray sundalo' ket matkap a bari'-barien ray bisit ran saraytaw saray nipasak sa kudos ta pigaw nin mati sarayna nin madali', ket maglat anadtaw a bangkay ra. ");
INSERT INTO smkNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ket, nako ra anaod nin binari' nin sundalo' a bisit ran saraytaw saray rwan karngan nan nipasak sa kudos ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sin nirate' sara bale' kona ni Jesus, kai ra nin binari' a bisit na bana' ta na'kit ra nin nati yayna. ");
INSERT INTO smkNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bale', si sayay sundalo', tinibsok nayan pika a riking na ni Jesus ket nimugsit a daya' tan ranom. ");
INSERT INTO smkNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sayti nin nangyadi', peteg a magwa' nin tepren bana' ta mampatutu'wan na nin naka'kit. Peteg a tanda' na a say man'ibarita' na ket tutuo, tan say gagara na nin mangibarita' ket ta pigaw nin magmatalek kamo kona anamaet ni Cristo. ");
INSERT INTO smkNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wantaw a nangyadi' ta pigaw nin matukid a naisurat sa Masanton Kasuratan a wana, “Kasa gapo ni saya nin mabari' nin but'ol na,” ");
INSERT INTO smkNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tan sitaw et si sakalako nin nipaisurat nan Dios a wana, “Pastangen rayaytaw li' si pinika ra.” ");
INSERT INTO smkNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sin say sarban sain ket nangyadi' ana, main nin saya a say ngaran na ket Jose, a taga ya Arimatea nin nako kona ni Pilato ta pigaw nin kidawat ya nin aburoy a kalapen nayay bangkay na ni Jesus. Siti si Jose, tumutumbok ya kona ni Jesus, bale' kai na nin man'ipa'kit bana' ta mali'mo ya konra nin pupangulo ra nin Judio. Binyan naya nin aburoy ni Pilato kanya' nin kina' naya nin kinalap a bangkay na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Si Nicodemo nin nako intaw nin nikiirgo sayay yabi kona ni Jesus, nayi ya kona ni Jose. Main nin awit nan pamabanglo, a sayti ket subran 30 kilo nin pinilawok a mira tan aloe. ");
INSERT INTO smkNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kinalap raya anaod a bangkay na ni Jesus, mi'sa, sigon sa kaugalian ran Judio, kinwan rayan mabanglo antaran mambarkuten raya nin mabistan klasin abel nin mantawagen nin diilo. ");
INSERT INTO smkNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Itaw sa dani nin lugar a nangipasakan kona ni Jesus sa kudos ket, main nin sayay mabistan pukok a namulawan nin kukayo. Ket itaw, main nin ba'yon kalin yukib nin pannabunan a kai et gapo nin nausar. ");
INSERT INTO smkNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bana' ta dandani yayna nin tumarana' a Awron Painawa, tan sitin pannabunan ket adani yadtaw, itaw rayayna nin nitabon si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ba'yo et nin kinmalaway sin buklas nin Linggo, nako saraynadtaw si Maria nin taga Magdala sa nanabunan kona ni Jesus. Sin rinmate' yadtaw, na'kit na a naglat yaynaytaw si baton nisada' konan nanabunan. ");
INSERT INTO smkNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Konan siin, nangred yan nakodtaw sa kami'nan na ni Simon Pedro tan si tumutumbok na ni Jesus nin kawa'nan na nin maong. Wana ni Maria konra, “Ginlat rayay bangkay na ni Uunuren itaw sa nanabunan ket kai mi nin tanda' no adti raya nin nika'!” ");
INSERT INTO smkNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Anaod, nako sara si Pedro tan sitaw nin tumutumbok sa nanabunan. ");
INSERT INTO smkNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nalayo sara nin pariho bale', nau'nawan nayan sitaw nin tumutumbok nin nirate' sa nanabunan si Pedro. ");
INSERT INTO smkNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dinmukot yan sinmir'ip sa luob, ket na'kit naytaw say abel a nipamarkot kona ni Jesus bale', kai ya nin linmuob. ");
INSERT INTO smkNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Rinmate' ya si Pedro ket diri-diritso nan linmuob sa nanabunan. Ket na'kit nadtaw taw say abel a nipamarkot kona ni Jesus ");
INSERT INTO smkNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","tan sitaw si abel nin nipamerber nin ulo na. Siti si nipamerber nin ulo na ket naipurok yan naberber et. ");
INSERT INTO smkNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ket, sitaw si nu'nan nakarate', linmuob ya anamaet. Sin na'kit naytaw, namper yayna nin sinmubli' yan mabyay si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wanin ta sin sain, sitaw si naisurat sa Masanton Kasuratan a wana nin matkap ya nin sumubli' nin mabyay, ket kai raya et nin natarusan. ");
INSERT INTO smkNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sinmunor, nagsisubli' saraynay tumutumbok sa kami'nan ra. ");
INSERT INTO smkNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Si Maria Magdalena bale', itaw ya et sa liwa' nin nanabunan nin man'umakis. Sin kapresan a man'umakis ya, nakadukot yan mansumir'ip sa luob ");
INSERT INTO smkNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ket main nin rwa radtaw nin anghil nin nakaputi'. Nakatekre' saradtaw sa nangipaidaan konan bangkay na ni Jesus, saya sa ulwan tan saya anamaet sa tuydan. ");
INSERT INTO smkNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nitepet ran sarayti kona, “Madam, ambale' a man'umakis ka?” Ket ni'bat na konra, “O' a ta ginlat rayay bangkay na nin Uunuren ko sa nanabunan kona ket kai ko nin tanda' no adti raya nin nika'.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nibring ya kayadi' na nin nibarita' in ket main nin na'kit nan naka'deng. Syayti si Jesus, bale' kai naya nin naalilbi'. ");
INSERT INTO smkNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wana ni Jesus, “Madam, ambale' a man'umakis ka? Si'no a mantikapen mo?” Ket si Maria, nipa'ka' na a si mammaga konan siin a lugar yayti kanya' nin wana kona, “Angkay, no si'kamo a nanglat konadti, ibarita' moyo pa no adti moya nin nika' ta keen koyadtaw nin kalapen.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ket, “Maria!” wana ni Jesus. Kinmikit ya kona si Maria Magdalena a wana, “Rabboni!” a sarita' yayti nin Hebreo nin say katarusan na ket “Maistro”. ");
INSERT INTO smkNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Wana ni Jesus, “Andi' nako nin ga'getan ta kai ako et nin nakasubli' itaw konan Ama ko. Ana edet, apurawen mon ika' nin ipatanda' konran tumutumbok ko a kwinta ana bubsat ko, a sumubli' akoynadtaw konan Ama ko nin Ama moyoynan lamang, sya a Dios ko nin Dios moyoynan lamang.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ket konan siin, nako ya anaod si Maria nin taga Magdala konra nin tumutumbok tan nibarita' na konra, “Na'kit koya a Uunuren!” Ket niparate' na anaod a nibarita' na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sin yabi konan siin nin awron Linggo, tinarangkawan ray purta sa bali nin nididinepan ran tumutumbok na ni Jesus bana' ta mali'mo sara konra nin pupangulon Judio. Ket rinmate' ya si Jesus nin inumdeng yadtaw sa butlay ra. “Main kumon nin katinekan a kukaisipan moyo,” wana konra. ");
INSERT INTO smkNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kayadi' na nin nibarita' ti, nipa'kit na konra a gamet na tan si riking na. Pinasyan ririket ran tumutumbok sin na'kit raya a Uunuren. ");
INSERT INTO smkNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wana anamanaet ni Jesus, “Main kumon nin katinekan a kukaisipan moyo. Kapada a nibaki' nako nin Ama, wanin anamaet, ibaki' katamo.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kayadi' na nin nibarita' ti, pinaysepan nasaran inanawa na ni Jesus mi'sa wana, “Akuen moya a Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Saray pirdunawen moyoy kukasalanan ra, napirduna sarayna anaod; saray kai moyo nin pirdunawen ket kai sara nin napirduna.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Si Tomas a main nin purarag nin Singin a saya konran labinrwa, kasa ya bale' sin rinmate' ya si Jesus ");
INSERT INTO smkNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","kanya' nin wanran raruma kona, “Na'kit miya a Uunuren!” Ket ni'bat na ni Tomas, “No kai ko nin ma'kit tan maarikap a ubot nin ibwatan nin pasak sa gamet na tan maikurbot a gamet ko sa riking na, kai ako nin mamper.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Napalabas a masurok a sayay linggo, nididinep sara anamana a tumutumbok sa luob nin bali, ket kalamo' raya si Tomas. Natarangkawan a purta bale' sinumrep ya si Jesus ket inumdeng ya sa butlay ra. “Main kumon nin katinekan a kukaisipan moyo,” wana konra. ");
INSERT INTO smkNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mi'sa wana kona ni Tomas, “Kiten moy gamet ko tan ikwa moy garamay mo sa ubot nin ibwatan nin pasak tan ikurbot moy gamet mo sa riking ko. Andi' kayna nin magdwadwa no kai edet, mamper kayna.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ket inumbat ya si Tomas tan wana kona ni Jesus, “Si'ka a Uunuren ko tan si Dios kon raywen ko!” ");
INSERT INTO smkNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wana ni Jesus kona, “Mamper kayna para bana' ta na'kit nakoyna? Makarma' tan maririket saray mamper mataman nin kai rako nin na'kit.” ");
INSERT INTO smkNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Abaw et a parso nin na'kit ran tumutumbok a nangwa-nangwa' ya si Jesus nin pammatutuo nin maipa'ka' kona a kai naisurat iti konan sitin libro. ");
INSERT INTO smkNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ket say naisurat iti, naisurat anaod ta pigaw nin mamper kamo a si Jesus, syay Criston nipangako' nan Dios, a sya a Anak nan Dios tan ta pigaw nin magkamain kamo nin byay yupa' sa pakikalamo' moyo kona bana' ta mantepren moyo in nin page'. ");
INSERT INTO smkNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kayadi' nin sain, nipa'kit ya anamana si Jesus konran tumutumbok na itaw sa Taaw Galilea. Wanti e a nangyadi': ");
INSERT INTO smkNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sin sain, nikakalamo' sara si Simon Pedro, si Tomas a main nin purarag nin Singin, si Natanael nin taga Cana sa Galilea, saray a'nak na ni Zebedeo, tan rwa ra et nin raruman tumutumbok na ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wana ni Simon Pedro konra, “Mako ako nin manguna'.” Ket, “Mayi kami,” wanra kona. Nako sara anaod sa taaw bale' kasa gapo nin nakalap ra sin sain a yabi. ");
INSERT INTO smkNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sin manlumiwa' yayna a awro, itaw yan naka'deng sa abay si Jesus, bale' kai raya nin maalilbi' nin tumutumbok. ");
INSERT INTO smkNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wana ni Jesus konra, “Uamigo, main nin nakalap moyo?” Ket, “Kasa gapo anaod,” wanra nin ni'bat. ");
INSERT INTO smkNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wana konra, “Ikatkat moyay eket moyo sa bandan wanan na nin baluto ket main nin makalap moyo.” Nikatkat raya anaod a eket ra ket kai rayayna nin maarwas sa ka'bawan nin nakalap. ");
INSERT INTO smkNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ket wana kona ni Pedro nin si tumutumbok a kawa'nan na ni Jesus, “Si Uunuren ya in!” Sin narnge' nayti ni Simon Pedro, niaysing ya bana' ta lus'ok yan mampagtrabaho, mi'sa ya nin linmukso sa ranom. ");
INSERT INTO smkNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bale' saray raruma, inmabay saran iti sa baluto nin guruy-guroy raya a eket nin napno' nin kuna'. Ambo' sara nin adayo' nin tuloy sa abay, magsanyasot a mitro tamo' a kaadayo' ra. ");
INSERT INTO smkNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sin itaw sarayna sa tangkar, main nin na'kit radtaw nin mandumtan baya ket main nin man'ibaya nin kuna' tan main nin umno ray tinapay. ");
INSERT INTO smkNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sin sain, wana ni Jesus konra, “Mangawit kamodti nin umno ra sa sain say nakalap moyon kuna'.” ");
INSERT INTO smkNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nako ya anaod si Simon Pedro sa baluto ket nitangkar nayay eket nin napno' nin alalakin kuna', 153 sara. Bale' mataman nin pinasyan ka'bawan ra nin kuna', kai nin rinmisang a eket. ");
INSERT INTO smkNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“Pari ana, mamuklas atamoyna,” wana ni Jesus konra. Kasa gapo ni saya konra nin tumutumbok a nakaitpel nin nanepet no si'no ya bana' ta tanda' ra a sya si Uunuren. ");
INSERT INTO smkNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kina' na nin kinalap ni Jesus a tinapay, wanin et sa kuna', mi'sa na nin nibi konra. ");
INSERT INTO smkNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Siti a ikatlon parso a nipa'kit ya si Jesus konran tumutumbok na sin sinmubli' yayna nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kayadi' ra nin nangan, nitepet na ni Jesus kona ni Simon Pedro, “Simon a anak na ni Juan, mas para a pangangawa'nan mo kongko dyan sa saytin bubagay?” “O', Uunuren, tanda' mon mampablyen kata,” ni'bat na ni Pedro. Ket wana ni Jesus kona, “Edet, pagawan mosara a pa'sar malalago' et nin karniro ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nitepet na nin pirwa ni Jesus, “Simon a anak na ni Juan, main nin pangangawa'nan mo kongko?” Ni'bat na ni Pedro, “O' Uunuren, tanda' mon mampablyen kata.” Wana ni Jesus kona, “Edet, asikaswen mosaray pa'sar karniro ko.” ");
INSERT INTO smkNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nitepet nan pitlo ni Jesus, “Simon a anak na ni Juan, si'ko para a mampablyen mo?” Ginmereng ya si Pedro ta pinitlo na nin nitepet ni Jesus no mampablyen naya. Anaod inumbat ya si Pedro a wana, “Uunuren, tanda' mo a sarba. Tanda' mo a mampablyen kata.” Wana anamanaet ni Jesus kona, “Edet, pagawan mosaray pa'sar karniro ko. ");
INSERT INTO smkNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Isipen moyti nin maong, Simon. Sin kalagu'-laguan mo, si'kan diri a mangisulot nin barkes mo tan nako ka sa rabay mo nin keen. Bale' no masiken kayna li', ipa'nat moy takyay mo tan baruren raka tan ika' rakadtaw sa kai mo nin rabay nin keen.” ");
INSERT INTO smkNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nibarita' nayti ni Jesus ta pigaw nin ipatandaan na no pa'no ya nin mati si Pedro nin mabyan yan pammagalang a Dios. Kaaram, wana ni Jesus kona ni Pedro, “Tumumbok ka kongko!” ");
INSERT INTO smkNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Linmingap ya si Pedro ket na'kit nayan mantumumbok taw si tumutumbok a kawa'nan na ni Jesus. Sitaw si kadani na sin pangngapon ra tan si nanepet intaw kona a wana, “Uunuren, si'no a magtraidor komo?” ");
INSERT INTO smkNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sin na'kit nayayti ni Pedro, nitepet na kona ni Jesus, “Uunuren, ani anamanaet a mangyadi' konan sitin tawo ey?” ");
INSERT INTO smkNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ni'bat na ni Jesus, “Bilang wadi' a rabay koya nin mabyay angga li' nin sumubli' akodti, ambale' a kapagawan mo ey? Si'ka, tumumbok ka kongko!” ");
INSERT INTO smkNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kanya' nin naibandu-bando konra nin tutawo na ni Jesus a kai ya nin mati ti nin tumutumbok mataman nin kai na nin nibarita' ni Jesus a wanin, no kai edet, wana, “Bilang wadi' a rabay koya nin mabyay angga no sumubli' akoynadti, ambale' a kapagawan mo ey?” ");
INSERT INTO smkNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Si'ko ya in nin tumutumbok. Mampatutu'wan ko a si'koy nanurat nin sayti, ket tanda' mi a say nibari-barita' ko ket tutuo. ");
INSERT INTO smkNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Abaw et a ginwa-ginwa' na ni Jesus a no isurat nga'min, sa wangko, kai nin malaman nin intiron mundo a libro nin pakaisuratan.");
INSERT INTO smkNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mampablyen kon Teofilo, Itaw konan u'nan libro ko, nisurat-surat ko a maipa'ka' sa sarban nitarana' na ni Jesus nin gaw'en tan iyakay, ");
INSERT INTO smkNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","angga sa awro nin niyuli' yayna sa langit. Ket ba'yo ya nin niyuli' sa langit, binibi-bibilin nasara sa tulong nan Ispirito nan Dios a pinili' nan apostoles na maipa'ka' sa ituloy ran gaw'en tan iyakay. ");
INSERT INTO smkNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa luob nin a'pat a pulo' a awro, mayadi' a nipati tan nisubli' nan mabyay, ni'non parso a nipa'ki-pa'kit ya konra tan niyakay-akay nasara maipa'ka' sa pag'aadi' nan Dios nin pammatutuo a sinmubli' yan mabyay. ");
INSERT INTO smkNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ni'sa nin kadungo raya, wanan nibibilin ni Jesus konra, “Andi' kamo nin lumakwan iti sa Jerusalem, no kai edet, taga'nan moyadti yapo' a nipangako' na ni Ama. Nairgo koyna intaw komoyo a maipa'ka' konan siti, ket anaod, ");
INSERT INTO smkNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ranom a nipamawtismo na ni Juan, bale' sa ambo' ana nin ma'teng, bawtismwan kamo nin Ispirito nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ket ni'sa anamanaet nin nidudungo sara, nitepet ran apostoles kona ni Jesus, “Uunuren, isubli' moyna para sawanin kontamon tawodti sa Israel a pag'uuray konan nasyon tamo?” ");
INSERT INTO smkNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ket ni'bat na konra, “Say panaon tan mumangyadi', naitanda' nayna ni Ama mangibwat sa pakayadi' na, ket kai moyoyna nin manepeg nin matandaan. ");
INSERT INTO smkNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wanin man, mabyan kamo li' anamaet nin pakayadi' no mako ya nin miikap komoyo a Ispirito nan Dios, ket si'kamoy ibaki' kon mangipatutuo nin say maipa'ka' kongko itaw sa Jerusalem, sa intiron Judea, sa Samaria, tan sa sarban lugar iti sa mundo.” ");
INSERT INTO smkNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ambo' nin na'teng kayadi' nayti nin inirgo ni Jesus, niyuli' yayna sa langit a sikikikit sara; kaaram nasalimbengan yayna nin gunem. ");
INSERT INTO smkNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ket mantumangar sara et nin mangkumikit kona ni Jesus nin niyuli' sa langit sin kapingmatan main anadtaw nin rwa ray lulalakin nisket nin maputi' a naka'deng sa dani ra. ");
INSERT INTO smkNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Si'kamon lulalaki nin taga Galilea,” wanran sarayti, “Mayin a isen kamo nin mantumangar kamo sa langit? Si Jesus ket nikadayo' ya komoyo nin niyuli' ya sa langit, tan sumubli' yadti li' nin bilang lamang sa no pa'no yan nuli' sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kayadi' nin sain, nibwat saraynadtaw sa mantawagen nin Talugtog Olibo a apostoles tan sinmubli' sara sa Jerusalem, a dandani sayay kilumitro a kaday'an. ");
INSERT INTO smkNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ket sin nirate' saraynadtaw, nuli' saradtaw sa kwarto sa ta'gay nan balin mampagtuluyan ra. Sarayti ket sara: si Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago a anak na ni Alfeo, si Simon a sayay myimbron grupo ran Ribulusyunaryo, tan si Judas a anak nan sayay mangaran nin Santiago. ");
INSERT INTO smkNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sarayti ket pirmi saran nikakalamo' nin dinmasal, kalamo' rasaray bubsat na ni Jesus, si Maria nin ina na, tan main et nin raruman bubbayi. ");
INSERT INTO smkNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Napalabas a umnoy awro, ni'san nadinep saray tumutumbok kona ni Jesus a magsanyasot tan rwampulo' sara, inumdeng ya si Pedro tan wana: ");
INSERT INTO smkNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bubsat, matkap a matukid taw say naisurat sa Masanton Kasuratan nin nipadles na ni Adi' David sa nipaninreg nan Ispirito nan Dios kona, maipa'ka' kona ni Judas a syay nangaluyon konran saraytaw saray nanakep kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Gindat, kalamo' miya ta napili' ya anamaet nin main nin kabiangan sa wantin pagtatrabaho para konan Dios,” wana ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Siti si Judas, nisaliw nan sayay pukok taw say kwartan nibayad ra kona sa duka' a gawa' na. Itaw ya nin nipati ket sin naragrag ya, tinumrak yay tyan na tan linumwa' a pait na. ");
INSERT INTO smkNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Natandaan rayti nin nangyadi' nin sarba ran tawodtaw sa Jerusalem ket pinangaranan rayaytaw a pukok nin Akeldama, a say rabay nan irgwen ket Luta' nin Daya'. ");
INSERT INTO smkNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ket wana et ni Pedro, “Say padles na ni Adi' David ket mabasa sa libro nin Kanta a wanti a wana, ‘Pauryan yayna in nin piikapan na a kasayna gapo nin miikap kona anggan maka'numan.’ Main et nin wana, ‘Kalapen kumon nin raruma a lugar na a sayay mammaga.’ ");
INSERT INTO smkNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kanya' nin matkap a mamili' atamo nin saya et nin kalamo' mi nin tistigos a sinmubli' yan mabyay si Jesus. Matkap a sya ket kala-kalamo' miya nin nakudti-nakodtaw sin intiron panaon a iti ya intaw si Uunuren tamon Jesus, nangibwat sin binawtismwan naya ni Juan angga sin niyuli' yayna sa langit.” ");
INSERT INTO smkNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ket nangirikuminda sara nin rwa ran lulalaki nin pamilian ra. Say ngaran ra ket Jose tan Matias. Konan siti si Jose, main nin manawag nin “Barsabas”; main et anamaet nin “Justo”. ");
INSERT INTO smkNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mi'sa, dinmasal sara a wanra, “Catawan, tanda' mo a linaman nin kanakman nin barang sayay tawo. Ipatandaan mo pa komi no si'no konran saraytin rwa a pinili' mo ");
INSERT INTO smkNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nin mag'in nin apostol nin sumubray nin mangwa' nin rispunsibilidad na ni Judas, a sya ket ginurutan nayti tan nako yayna sa peteg a kabagayan na.” ");
INSERT INTO smkNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nipadalan ra sa binunutan, ket si Matias a nabunot. Ket nilamo' yayna konran labinsaya. ");
INSERT INTO smkNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sin pista ran Judio a mantawagen nin Pentecostes, nididinep sara sa sayay bali a sarba ran mammemper kona ni Jesus nin itaw sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kapingmatan, main nin narnge' ran bara'mon rumaweswes nin pinasyan kasaw nin siri nin ibat sa langit, a siti ket narnge' ya sa intiro nan bali a nididinepan ra ");
INSERT INTO smkNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tan naka'kit sara nin bilang dutan apoy nin bakas dila' a dinumpa-dumpa' sa barang saya konra. ");
INSERT INTO smkNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ket nag'uray yay Ispirito nan Dios sa barang saya konra tan nakapag'irgo sara sa ambo' ran sarita' nin diri bana' sa pakababa' a nibi nan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sin sain, main saradtaw sa Jerusalem a Judio nin madibusyon konan Dios, bale' abaw sara konra a nangibwat sa nagsikabarang a nunasyon. ");
INSERT INTO smkNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sin narnge' raytaw a rumaweswes, nagsiarak saran nididinep itaw. Ket naka'ngap sara nga'min ta mangkarnge' rasaray mammemper nin mampag'irgo sa sarita' nan diri nin barang saya konra. ");
INSERT INTO smkNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa nipaka'ngap ran tuloy ket wanra, “Ambo' para a taga Galilea sarayti nin tutawo? ");
INSERT INTO smkNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ket pa'no bale' a mangkarnge-karnge' tamoynan man'irgwen ra a irgo tamon diri? ");
INSERT INTO smkNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Si'tamo nin iti ket main nin taga sa Partia, sa Media, sa Elam, sa Mesopotamia, sa Judea, sa Capadocia, sa Ponto, sa Asia, ");
INSERT INTO smkNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","sa Frigia, sa Pamfilia, sa Egipto. Main et nin taga sa lulugar sa nasyon nin Libya nin adani sa Cirene. Main anamaet et nin taga Roma nin Judio tan saray nasagyat sa pammemper nin Judio ");
INSERT INTO smkNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tan main et nin tutawo sa Creta tan sa Arabia. Ket mangkarnge' tamon mampag'irgo sara sa uirgo tamon diri maipa'ka' sa makapaka'ngap nin ginwa-ginwa' nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kai ma'pos nin isipen nin barang saya a mampangyadi' ket kai nin mabulsu-bulsot a pittepetan ran wanra, “Ani kadi' a pipa'kaan nin sayti?” ");
INSERT INTO smkNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Main sara bale' a manuya'-tuya' nin wanra, “Nabok sarain tamo'!” ");
INSERT INTO smkNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ket, nako ya sa adapan si Pedro nin kalamo' nasaray labinsaya et nin apostoles, mi'sa ya nag'irgo nin maksaw a wana, “Kababalyan tan sarba moyo nin mampiikap iti sa Jerusalem, rumnge' kamo pan maong tan andi' kamo nin malingo maipa'ka' sa mampangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kai sara nin nabok ti nin tutawo nin bilang sa man'ipa'ka' moyo. Alas nwibi tamo' et nin buklas! ");
INSERT INTO smkNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","No kai edet, saytin mampangyadi' ket say nipadles na ni Prupita Joel sin nu'nan panaon a wana: ");
INSERT INTO smkNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Wana nin Dios, “Sa panaon nin adapen ana nin kala'pusan, ibi koya nin sibubulos a Ispirito ko sa sarba. Ket saray ua'nak moyo, lulalaki man o bubbayi, mangipatanda' sara li' nin maipa'ka' kongko. Saray mangalalago' nin lulalaki, pa'kitan kosara li' nin bubagay a kai ra ma'kit nin raruman tutawo, tan saray mumasiken, manaynep sara li' nin say ipataynep ko konra. ");
INSERT INTO smkNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O', mataman konran uaripen ko, lulalaki man o bubbayi, ibi koya anamaet nin sibubulos a Ispirito ko sa saytaw li' nin panaon, ket mangipatanda' sara nin maipa'ka' kongko. ");
INSERT INTO smkNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mangipa'kit ako nin makapaka'ngap nin mangya-mangyadi' sa langit, tan mumilagro nin paka'kitan iti sa luta'. Ma'kit li' sa luta' a daya', apoy tan makubpal nin asok ");
INSERT INTO smkNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","tan sa langit, dumedlem ya li' a awro tan umudit ya li' nin bilang daya' a bulan. Ket konan siin, rinmate' anaytaw si impurtantin panaon a si'kon si Dios ket mag'uray akon main nin pinasyan kaalakyan nin pakayadi'. ");
INSERT INTO smkNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ket maisalba koyay si'numan a kidawat nin inganga'do kongkon si Uunuren.” ’ ");
INSERT INTO smkNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kanya' nin reng'en rako pa, si'kamon kapada ko nin Israelita,” wana ni Pedro. “Si Jesus a taga Nazaret, yupa' kona, nangwa' ya a Dios nin mumilagro tan makapaka'ngap a nangya-nangyadi'. Tanda' moyoynay maipa'ka' sa sayti say man'ibarita' ko ta iti nin mismo nin nangyadi' sa lugar moyo. Nipatanda' na nin Dios komoyo a si Jesus tawo naya nin nibaki' na. ");
INSERT INTO smkNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ket siti si Jesus, nipagamet ya komoyo bana' ta nidisisyon tan niplano nayna in nin gindat nin Dios. Ket nipapati moya konran ambo' nin Judio a nipasak raya sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bale' pinasubli' nayan mabyay nin Dios ket ginlat naya sa irab nin pag'in nin nati ta kai nin magwa' a mag'uray a patiti kona. ");
INSERT INTO smkNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","O' ta nisurat nayti e ni David sin nu'nan panaon a maipa'ka' konan siti si Jesus, ‘Tanda' ko nin kalamo' koyan pirmi a Dios. Iti yan pirmi sa abay ko kanya' nin kasa gapo nin makatege' kongko. ");
INSERT INTO smkNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","O' a wanin kanya' nin maririket a kanakman ko, tan mariga ako sa pag'iirgo ko; ket, mataman no tawo ako tamo', matalek ako nin liso a ");
INSERT INTO smkNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kai mo nin pauryan, O Dios, nin itaw ya tanay kararwa ko sa Hades, tan kai mo nin iyaburoy a maumok yay lalaman nan ibabaki' mon tutuo komo. ");
INSERT INTO smkNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nipatandaan ma kongko a dalan nin mangipunta kongko sa byay. Gaw'en mon malipos ako nin ririket ta kalamo' katan pirmi.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nituloy na ni Pedro maipa'ka' konan siin ket wana, “Bubsat, tanda' tamo anaod a si puon tamon si David, nati ya ket nitabon raya, tan say katutu'wan ket ke'ran na et nin pantyon na anggan sawanin. ");
INSERT INTO smkNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Si David, tanda' naytaw say nipangako' nan Dios kona ta nisamba nan Dios kona a ipata'gay naya li' a saya konran puri na nin mag'adi' ya nin bilang sa nipag'adi' na ni David. Bana' konan siin tan bana' anamaet a saya yan prupita, kanya' nin ");
INSERT INTO smkNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","tanda' naynan gindat a gaw'en na nin Dios. Ket nibarita' nayna anaod nin gindat a maipa'ka' sa isusubli' nan mabyay nin Cristo nin nipangako' nan Dios, a wana kai naya nin pinauryan nin Dios nin itaw ya tanay kararwa na sa Hades, tan a si lalaman na, kai na nin niyaburoy a maumok ya.” ");
INSERT INTO smkNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wana ni Pedro, “Ket matistigusan min sarba a si Jesus nin pinasubli' nan mabyay nin Dios a man'ibarita' na sa sain a wana. ");
INSERT INTO smkNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nikwa yayna sa sangkata'gayan nin lugar sa wanan nan Dios a syay Ama na, tan nibi nayan Ama kona a Ispiriton nipangako' na kona. Kanya' nin naimatunan tan narnge' moyo sawanin a makapaka'ngap nin nunangyadi' a pinangibwat na ni Jesus nin nangyadi' sa pakayadi' nan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","O' ta main et nin nipadles na ni David, bale' ambo' anaod nin say lalaman nan diri a mantukuyen na bana' ta kai ya nin nuli' itaw sa kami'nan nan Dios. Nisurat na a wana, ‘Wana nin Dios konan Uunuren ko, “Tumekre' kadti sa pawanan ko ");
INSERT INTO smkNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mintras a mampasukuen kosaran liso komo a kukalaban mo.” ’ ");
INSERT INTO smkNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Bana' ta wanin,” wana ni Pedro, “matkap a sarba tamon Israelita ket, matandaan tamon maong a sitaw si nipangako' nan Dios ket ginwa' nayan Uunuren tan Cristo. Sya si Jesus nin nipasak moyo sa kudos!” ");
INSERT INTO smkNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Natinreg nin maong a kanakman ran tutawo sa saytin narnge' ra ket wanran nitepet kona ni Pedro tan konran raruman apostoles, “Bubsat, ani edet a gaw'en mi?” ");
INSERT INTO smkNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ket ni'bat na ni Pedro, “Pagbabawian moyoynay kukasalanan moyo tan pabawtismo kamon mangipa'kit a man'akuen moyayti si Jesu-Cristo. Gaw'en moyoyti ta pigaw nin pirdunawen nan Dios a kukasalanan moyo, tan ibi nayan rigalo komoyoy Ispirito na. ");
INSERT INTO smkNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Anaod, siin a nipangako' na para sa kaabigan moyo tan ran saray puri moyo, tan mataman saray tutawodtaw sa adayo' nin lulugar. Saytin nipangako' nan Uunuren a si Dios tamo ket para sa barang sayan sagyaten na nin umarak kona.” ");
INSERT INTO smkNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Abaw et a nisala-salaysay na ni Pedro ta pigaw nin patutu'wan nay nibari-barita' na, tan binari-baritaan nasara a wana, “Pal'isan moyo saray tutawo konan sitin panaon a madusa sara li' bana' sa maraet a gugawa' ra.” ");
INSERT INTO smkNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ket abaw saray namper sa nibarita' na ni Pedro, ket nipabawtismo sara. Konan sitaw nin awro, nalamu'nan saran magtulunribo a mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inawru-awro, masuet saran nangrenge' sa uakay ran apostoles. Nilalangen-langen sara nin sarba ran mammemper, nidudungu-dungo saran mangan, tan pirmi sara tanan dumasal. ");
INSERT INTO smkNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ket napno' saran pangingibilang a tutawo konan Dios ta abaw a ginwa-ginwa' ran apostoles nin makapaka'ngap tan pammatutuo nin maipa'ka' konra. ");
INSERT INTO smkNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mididinep saran pirmi a mammemper tan ikon nin sarba a main nin saya tan saya ");
INSERT INTO smkNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ket nilaku'-lako' ray main tan kukayamanan ra, ket say naglakuan nibi-nibi ra konran kalalamo' ra dipindi sa pakatkapan nin barang saya. ");
INSERT INTO smkNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inawru-awro saran nipapasayadtaw sa sakop nan Timplo nin nangrayu-rayo konan Dios. Nidudungu-dungo saran nangan-nangan sa pupammali ra, a pinasyan ririket tan mabulos a nakem ran nangitao sa saya tan saya. ");
INSERT INTO smkNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nangrayo saraynan nangrayo konan Dios, tan saray tutawo, kaririktan rasaray mammemper. Ket si Uunuren, nilamo' nasara konra nin inawru-awro a man'isalba na. ");
INSERT INTO smkNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sayay awro, nako saradtaw sa sakop nan Timplo si Pedro tan si Juan, ta udas nin kadadasal itaw; mag'alas tres nin yabina. ");
INSERT INTO smkNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sa purta sa Timplo a mantawagen nin “Purtan Mabista”, main itaw nin sayay tawon lupoy nangibwat et sin niyanak ya. Sitin lupoy, ika' rayan inawru-awrodtaw ta pigaw nin kipayabor ya konran tutawon sumrep sa sakop nan Timplo. ");
INSERT INTO smkNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sin na'kit nasara si Pedro tan si Juan nin adap itaw sa sakop nan Timplo, nikipayabor ya konra. ");
INSERT INTO smkNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pinastang rayan maong, mi'sa wana ni Pedro kona, “Pastangen rakami!” ");
INSERT INTO smkNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ket pinastang nasara tan taga-taga'nan nay ibi ra kona. ");
INSERT INTO smkNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wana et ni Pedro, “Kasan balitok, ni pirak ko; no ani a main ko, siin a ibi ko komo. Sa pakayadi' na ni Jesu-Cristo nin taga Nazaret, lumalako ka.” ");
INSERT INTO smkNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gina'getan naya ni Pedro sa wanan nin takyay tan pina'deng naya, ket tampor ginumsen a ayi tan bisit na. ");
INSERT INTO smkNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ket naka'deng ya tan linmala-lalako ya. Nayi ya konra nin sinumrep sa sakop nan Timplo, a luksu-lukso ya tan manraywe-raywen nayay Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Saray tutawodtaw, na'kit ra a manlumalako ya tan manraywen nayay Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sin naalilbi' rayan tutawo a syaytaw si kipayabor nin nakatekre' itaw sa mantawagen nin Purtan Mabista sa Timplo, wanin anan tuloy a nipaka'ngap ra. ");
INSERT INTO smkNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nakaga'get yaytaw si tawo konra ni Pedro tan Juan, a itaw sara sa lugar sa Timplo a mantawagen nin “Balkon na ni Solomon”, sin niririrngan saran nalayo nin inmarak konra a tutawo bana' ta naka'ngap saran tuloy. ");
INSERT INTO smkNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sin na'kit nasara ni Pedro, wana konra, “Si'kamon kapada kon Israelita, ambale' nin naka'ngap kamon tuloy tan ambale' nin nakamulite' kamo komi? Man'ipa'ka' moyo para a nakalalako yayti nin tawo nangibwat sa pakababa' mi o bana' ta rilihyuso kami? ");
INSERT INTO smkNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Si Dios a syay nagsirbyan ra ni Abraham, Isaac, tan Jacob, tan saray pupuon tamo, nipadar nan pinasyan kata'gayan na nin si Aripen nan si Jesus. Bale' sya, nipagamet moya konran saray iti sa uray, tan ginurutan moya sa adapan na ni Pilato. Disidido nayan bulusan sin saytaw si Jesus, ");
INSERT INTO smkNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","bale' si'kamo, kai moya nin inalilbi', sya a liso nin naitalaga konan Dios tan sya nin kasa gapon kasalanan. Dinawat moyoyna edet nin sayay priso nin mangmamatin tawo a ibulos na ni Pilato. ");
INSERT INTO smkNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinati moya si Jesus a Puon nin Byay, bale' pinasubli' nayan mabyay nin Dios. Ket matistigusan mi nin tutuo in. ");
INSERT INTO smkNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ket bana' sa pagmamatalek mi sa no si'no ya si Jesus, sitin tawo nin tanda' moyon gindat a lupoy, makalalako yayna. O', nangyadi' ti bana' sa pagmamatalek mi kona ni Jesus, ket bilang sa mangkiten-kiten moyo sawanin, limpyo yaynan lisoytin tawo. ");
INSERT INTO smkNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Bubsat, tanda' ko a si'kamo tan ran saray mag'uuray, ginwa' moyo in si nipapati moya si Jesus ta nagkurang a pakataros moyo. ");
INSERT INTO smkNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sin saytaw et sin nu'nan panaon, nipatandaan rayaynan sarba ran prupita a minsahi nan Dios a si sya a Cristo nin nipangako' na nin mag'adi' ket mapadya'dya' ya, ket sawanin natukid ana in sa ginwa' moyo kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kanya' nin matkap a magbabawi' kamo sa kasalanan moyo tan sumubli' kamo konan Dios, ta pigaw nin mapirdunayna a kukasalanan moyo, ");
INSERT INTO smkNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ket gaw'en nan Dios a mainawnan a kukanakman moyo tan ibaki' nayadti si Jesus, a syay Cristo nin tinudo' naynan gindat nin adi' a mag'uray komoyo. ");
INSERT INTO smkNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Matkap a itaw ya et yapo' sa langit, anggan say sarba ket pinaba'yo nayna nin Dios bilang sa nipaibarita' nayna sin saytaw et konran prupita nin naitalaga kona. ");
INSERT INTO smkNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bilang wadi' si Moises, wana, ‘Mangipadar ya li' komoyo si Uunuren tamon Dios nin sayay Prupita nin bilang sa nipangibaki' na kongko. Saya ya li' nin kapada tamon Israelita. Matkap nin reng'en moyon maong a sarba nin ibarita' na komoyo. ");
INSERT INTO smkNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bale' si si'numan li' a kai nin mangimbabaet sa irgo na, kai yayna li' nin maibilang konran tutawo nan Dios tan madusa yan mati.’ Wanin a wana ni Moises sin saytaw et.” ");
INSERT INTO smkNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wana et ni Pedro, “Anaod, saray raruma et nin prupita, mangibwat kona ni Samuel pati sara et nga'min a sinmunor kona, nipadles ran lamang ti say mampangyadi' sawanin. ");
INSERT INTO smkNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Si'kamo, main nin biang moyo sa sayti sawanin ta puri rakamo nin sarain tan kirama' kamo sa nipangako' nan Dios sin saytaw et konran puon tamo. Nibarita' na kona ni Abraham, ‘Mangibwat konan puri mo, bindisyunan ko a sarban tutawodti sa mundo.’ ");
INSERT INTO smkNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kanya' nin,” wana ni Pedro, “sin nipadar naya tan nibaki' nayadti nin Dios a Aripen nan si Jesus, kontamon Judio ya nin nu'nan nako ta pigaw nin bindisyunan natamo yupa' sa pangwa' na a gurutan ana nin barang saya kontamo a duka' a kabibyay.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mangkiirgo sara et si Pedro tan si Juan konran tutawo sin main nin inmarak konra nin pupadi', si upisyal ra nin gwardya sa Timplo tan main anamaet nin Saduseo. ");
INSERT INTO smkNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pinasya nin sager ra konra ni Pedro tan Juan bana' ta man'ibarita' ra a pinasubli' nayan mabyay nin Dios si Jesus ket bana' kona pasublien nasara li' nin mabyay a nunati. ");
INSERT INTO smkNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nipadakep rasara si Pedro tan Juan, ket bana' ta mangkumatpaapon ana, nipukok rasarayna angga sin buklas. ");
INSERT INTO smkNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wanin man, abaw sara konran saray nakarnge' konra ni Pedro a namper sa wanra. Ket nag'in maglimanribo saray lulalaki tamo' nin mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sin sinmunor nin awro, nididinep saradtaw sa Jerusalem a mag'uuray ran Judio, saray Mangatuntawo ra tan saray Madudunong sa Gugan-gan. ");
INSERT INTO smkNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Itaw ya anamaet si Anas a syay Sangkata'gayan nin Padi', si Caifas, si Juan, si Alejandro, tan raruma et nin myimbron pamilya nan si Sangkata'gayan nin Padi'. ");
INSERT INTO smkNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinaadap rasara konra si Pedro tan Juan tan nitepet ra konra, “Yupa' sa ani nin pakayadi' moya nin napaanda' ti si lupoy? Si'no anamaet a nami nin siin nin pakayadi' komoyo?” ");
INSERT INTO smkNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ket, si Pedro, a mampag'urayan naya nin Ispirito nan Dios wana, “Si'kamo nin pupangulo tan mangatuntawo, ");
INSERT INTO smkNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","man'usisaen rakami maipa'ka' sa maabig a ginwa' mi konan siti si gindat nin lupoy. Mangkalutkuten moyo no pa'no ya nin napaanda'. ");
INSERT INTO smkNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Edet, si'kamo tan sarba ran saray kapada tamon tagadti sa Israel, manepeg a matandaan moyoyti: Siti nin tawo a gindat ket lupoy ya, sawanin iti ya sa adapan moyo nin limpyon man'umdeng ana bana' sa pakayadi' na ni Jesu-Cristo nin taga Nazaret. Sya si Jesus nin nipasak moyon pinati sa kudos; wanin man, pinasubli' nayan mabyay nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kapadan mabasa tamo sa Masanton Kasuratan, ‘Si bato nin nibilang moyon kai nin mausar nin si'kamon karpintiron namanday, Sitaw a nag'in nin sangkaimpurtantiwan sa pamma'deng.’ Siin nin bato ket si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Si Jesus tamo' a makapamakanda' nin byay tamo, bana' ta iti sa intiron sangkamundwan, kasaynan si'numan nin raruma et a nibi nan Dios nin makapangisalba kontamo.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naka'ngap saran tuloy a pupangulo ran Judio sin na'kit ran pinasyan tepel ran mag'irgo ni Pedro tan Juan, anta tanda' ran kasan inadal ra tan ka'bawan sara tamo' nin tawo. Ket napanemtem ra a kalalamo' nasara intaw ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Konan siin, kasan naibarita' ran pupangulo nin kuntra konra ta mangkiten-kiten rayaytaw si tawon napaanda' nin naka'deng sa dani ra ni Pedro tan Juan. ");
INSERT INTO smkNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kanya' nin pinaliwa' rasara yapo' nin pupangulo sa kwarto nin Kunsiho tan nag'iirgo sara. ");
INSERT INTO smkNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wanra, “Ani a gaw'en tamo konra? Tanda' nin sarba nin iti sa Jerusalem a gawa' rayaytaw si ambo' nin basta-basta nin milagro. Ket kai tamo nin maibudi' a katutu'wan. ");
INSERT INTO smkNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Say mabista, ta pigaw nin kai ana nin maitayak et konran tutawo a man'iyakay ra, ima'nwen tamo sara nin mangibari-barita' nin maipa'ka' konan siin si wanran syay Cristo a nipangako'.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ket kinayaban rasara anamanaet si Pedro tan binibilin rasara a wanra, “Andi' kamoyna gapo nin mangibari-barita' nin maipa'ka' konan siin kano a Cristo.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ket wanran inumbat ni Juan tan Pedro, “Si'kamo ana a manimbang no aya kasi a matunong sa pangingikit nan Dios: Si tumumbok kami komoyo o kona nin Dios? ");
INSERT INTO smkNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Anaod, kai mi nin magwa' a tumumbok sa wamoyo a andi' mi ana nin ibari-barita' a na'kit tan narnge' mi nin maipa'ka' kona ni Jesus.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sin sain, mas lalo rasara et yapo' nin linili'mo nin saray pupangulo si Pedro, mi'sa rasarayna nin binulusan ta kasan ma'kit ran padalan a madusa rasara; lalo ta saray tutawo ket manraywe-raywen rayay Dios bana' konan ");
INSERT INTO smkNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","si nangyadi' a paka'kitan nin pakayadi' na. Saya et, sitaw si tawo nin napaanda' ket masurok anan a'pat a pulo' a taon nin lupoy ya. ");
INSERT INTO smkNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sin sain, sin binulusan sarayna si Pedro tan Juan, sinmubli' saran tampor konran kalalamo' ra tan nibarita' ra konra a wanran Pupangulon Pupadi' tan saray Mangatuntawon iti sa uray. ");
INSERT INTO smkNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sin narnge' ra a wanra, nipapasaya saran dinmasal konan Dios a wanra, “O Catawan a main nin kapangyadian sa sarba, si'kay namarsa nin langit tan nin luta', pati say taaw tan say sarba nin main sa sayti. ");
INSERT INTO smkNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Si'kan lamang taw si namag'irgo konan si puon min si David. Saya yan aripen mo nin sa nipaninreg nan Ispirito mo kona ket wana, ‘Pinasyan bayani ra nin saray kai nin magtanda' konan Dios, tan mikukumplot sara sa duka' a gawa', bale' kasa nin pirat'anan nin sayti. ");
INSERT INTO smkNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Saray uadi' tan saray pupangulo sa nagsikabarang nin lugar iti sa mundo, sisasadya' sarayna ta nipapasaya sara ta pigaw nin kuntrawen raya a Dios tan a Cristo nin nipangako' na.’ ");
INSERT INTO smkNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Anaod, nangyadi' anan talaga in iti sa sitin syudad! Si Adi' Herodes tan si Gubirnador Poncio Pilato tan saray kalalamo' ran ambo' nin Judio, tan pati anamaet nin saray kapada min Israelita, nikukumplot sara nin patyen ya a Aripen mon nitalaga nay byay na komo, sya si Jesus, tan sya a tinudo' mo nin Cristo. ");
INSERT INTO smkNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bale', sain, iti anan gindat sa makapangyayadi' nin plano mon gaw'en ket nigagara mon talaga nin matukid. ");
INSERT INTO smkNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ket sawanin, Catawan, tanda' moy panglili'mo ra komi. Kanya' nin tulungan rakami kumon nin si'kamin uaripen mo, a kai kami nin lumi'mo nin ipatanda' mi a sarita' mo. ");
INSERT INTO smkNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipa'kit mo pa a pakayadi' mo nin mamaanda' konran main nin masakit, tan aburuyan rakami pan makagwa' nin makapaka'ngap nin pammatutuo a mangingilalaman kami komo tan raruma et nin makapaka'ngap nin bubagay, yupa' sa pakayadi' nan Aripen mon nitalaga nay byay na komo, si Jesus.” ");
INSERT INTO smkNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kayadi' ra nin dinmasal, naeyeg yay bali nin kami'nan ra. Sarba ra ket liso nan nag'urayan nin Ispirito nan Dios, ket pinasyan tepel ran nangibari-barita' nin minsahi na. ");
INSERT INTO smkNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sarba ran saray mammemper, sayan-saya a kaisipan tan apes ra, tan kasan si'numan nin nangikwinta a say main na ket para tamo' nin bukod kona, no kai edet, para sa sarba. ");
INSERT INTO smkNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Saray apostoles, naiduma a pakayadi' ra sa pangibari-barita' a pinasubli' nayan mabyay nin Dios si Uunuren tamon Jesus. Ket si Dios, nibu'bo' nay tulong na konran sarba ran mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kasa gapo nin nagkurang konra sa pakatkapan ra ta saray main nin luta' o bali ket nilako' rayti, tan say naglakuan, ");
INSERT INTO smkNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nibi ra konran apostoles nin nibi-nibi ra konran saray mampagkakurang sa matkap ra. ");
INSERT INTO smkNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Alimbawa' ket, main nin saya konra a say ngaran na Jose. Puri naya ni Levi tan taga ya sa isla nin Cyprus. Saray apostoles tinawag rayan Bernabe a say rabay nan irgwen nin sitin ngaran ket Mapangliwaliwa. ");
INSERT INTO smkNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Naglako' yan luta' na tan niparisibi nay naglakuan konran apostoles. ");
INSERT INTO smkNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sawanin, main anamaet nin saya nin lalakin say ngaran na Ananias tan si asawa na say ngaran na Safira. Sarayti, naglako' saran luta' ra. ");
INSERT INTO smkNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ket nag'irgwan ran mitraasawa a itra' ray raruman naglakuan. Ket say raruma tamo' a niparisibi na ni Ananias konran apostoles a kano wadi' ket saytaw nga'min. ");
INSERT INTO smkNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ket si Pedro wana, “Si'ka, Ananias, inaburuyan man nag'uray sa kanakman mo si Satanas ta mampibula'-bula' ka konan Ispirito nan Dios sa wamo nin sayti nga'min a naglakuan moyo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sin ba'yo moya nin nilako' a luta' moyo, iti ana komoyo no ilako' moya o kai ta ikon moya anaod, tan mataman sin nalako' moyayna, iti et a lamang komoyo no ani a gaw'en moyo sa naglakuan ta ikon moyo. Ket ambale' a naisip mon gaw'en ti? Sa saytin ginwa' mo, ambo' tamo' nin sa tutawo ka nin nibula'-bula' no kai mas lalo ana konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Sin narnge' nayti ni Ananias, natumba ya ket nati ya. Ket pinasyan nikabigra' ran sarba ran nakatanda' sa nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Saray tububa'yo nin itaw, pinunggos rayay bangkay na tan nika' raya nin nitabon. ");
INSERT INTO smkNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sin tuloy udas ana angangko a linmabas, rinmate' ya si Safira, a kai na et nin tanda' a nangyadi'. ");
INSERT INTO smkNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wana ni Pedro kona, “Si'ka, Safira, sayti tamo' para nga'min a naglakuan moyo konan luta' moyo?” Ket ni'bat na ni Safira, “O', sain tamo'” wana. ");
INSERT INTO smkNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wana et ni Pedro, “Ambale' a nikumplot kamon mitraasawa a ikwa moya sa sayay panunubok a Ispirito nan Uunuren tamo? Reng'en mo, manrumate' saraynay nako nin nanabon konan asawa mo ket sumunor ka anamaet nin ika' ra nin itabon.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Konan siin a lamang, natumba ya si Safira ket nati ya. Sin rinmate' saraynaytaw saray tububa'yo, na'kit ran nati ya si Safira ket inalsa raya tan nika' raya nin nitabon sa abay nan nanabunan konan asawa na. ");
INSERT INTO smkNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ket sin sain, saray sarba ran mammemper itaw tan saray raruma et nin nakarnge' sa nangyadi', pinasya nin li'mo ra. ");
INSERT INTO smkNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ket abaw a ginwa-ginwa' ran saray apostoles nin makapaka'ngap nin pammatutuo nin maipa'ka' konra a naimatunan ran tutawo. Sarba ran saray mammemper, itaw saran pirmi nin mididinep sa “Balkon na ni Solomon” itaw sa Timplo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Saray ambo' nin mammemper, mali'mo sara nin kilangen-langen konra. Wanin man, saray tutawo ket ata'gay a pangingikit ra konra. ");
INSERT INTO smkNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ket inmabaw saraynan inmabaw a nailamo' konra nin mammemper kona ni Uunuren a Jesus, lulalaki tan bubbayi. ");
INSERT INTO smkNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bana' sa mampangya-pangyadi', nika'-nika' rasaran tutawo sa rigrig nin dudalan a main nin masakit a nakaida' sara sa katri tan sa apay ra, ta pigaw nin mataman tana nin maalinawan nasara ni Pedro no lumabas ya. ");
INSERT INTO smkNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Abaw sara et a tutawon nangibwat sa bubabali nin iti sa libed nin Jerusalem a nakodtaw nin inawit-awit rasaray main nin masakit tan saray nasrepan nin duka' a ispirito. Ket, sarba ra nga'min ket napaanda'. ");
INSERT INTO smkNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sin sain, pinasyan imbel nan Sangkata'gayan nin Padi' tan saray kalalamo' na nin myimbro sara nin grupo ran Saduseo konran apostoles, kanya' nin nangimey sara. ");
INSERT INTO smkNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nipadakep rasaray apostoles mi'sa rasara nin nipapriso. ");
INSERT INTO smkNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bale' sin yabi, inabryan nayan sayay anghil nan Dios a priswan tan pinaliwa' nasara. Wana konra, ");
INSERT INTO smkNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mako kamodtaw sa sakop nan Timplo tan ibari-barita' moyo konran tutawo a maipa'ka' konan siti si byay a iti kona ni Jesus.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tinmulok sara konan anghil a apostoles. Sin mangkumalaway ana, nako sara sa sayay lugar itaw sa Timplo tan nangyakay sara. Sin sain anamaet, nididinep saray Sangkata'gayan nin Padi' tan kalalamo' na, tan miniting rasaray myimbro nan Kunsiho tan nga'min ran Mangatuntawo ran Judio, mi'sa sara nin namaki' nin gwardya nin keen rasara nin kalapen a apostoles sa priswan. ");
INSERT INTO smkNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bale' sin rinmate' saradtaw sa priswan a gwardya, kasa saraynadtaw a apostoles. Kanya' nin sinmubli' sarayna tan wanra, ");
INSERT INTO smkNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sin rinmate' kamidtaw sa priswan, sarado yan maong tan itaw saran mampaggwardya sa purta a gwardya. Bale' sin inabryan miya a namukukan konra, kasa gapo ni sayan tawodtaw sa luob!” ");
INSERT INTO smkNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sin narnge' rayti nin si upisyal ran gwardya sa Timplo tan saray Pupangulon Pupadi', nabagya' sara tan nangisip sara no ani a pirat'anan li' nin sayti. ");
INSERT INTO smkNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kaaram, main nin tawon rinmate' nin wana konra, “Saraytaw saray nipriso moyo, itaw sara sa sakop nan Timplo nin mampangyakay konran tutawo.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kanya' nin nako yadtaw a upisyal tan saray gwardya konran apostoles ta pigaw nin dakpen rasara. Bale' kai rasara nin pinwirsa ta mali'mo saran bangli' no kudas-kudasen rasara nin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Niyadap rasaray apostoles konran pupangulo ket si Sangkata'gayan nin Padi' wana konra, ");
INSERT INTO smkNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mairot min niyawa' komoyo a pangangakay moyo nin maipa'ka' konan siin a Cristo kano. Bale' kiten moyoy ginwa' moyo! Nitayak moyoynay akay moyodti sa Jerusalem, tan mampaliwaen moyo nin ubatan mi a patiti na.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bale' wana ni Pedro tan saray raruman apostoles, “Anaod, matkap a si Dios a tumbuken mi ambo' a tutawo! ");
INSERT INTO smkNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Si Dios nin rinayo ra nin pupuon tamo, nipata'gay naya si Jesus a dinuksa' moyon pinati nin nipasak sa sayay kayo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nikwa naya nin Dios sa lugar nin sangkata'gayan a kagalangan itaw sa wanan na, a syay Pangulo tan Mangingisalba ta pigaw nin mabyan atamon pagkanawanawan magbabawi' a si'tamon puri na ni Israel ket mapirduna a kasalanan tamo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ket tistigos kami sa sain nin nunangyadi'; wanin ya anamaet a Ispirito nan Dios nin mampiikapen nan Dios konran saray mantumulok kona.” ");
INSERT INTO smkNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sin narnge' ran pupanguloyti nin wana ni Pedro, wanin ana a sager ra, ket nag'iirgwan ra nin ipapati rasaraynay apostoles. ");
INSERT INTO smkNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bale' main nin saya konran pupangulo a inumdeng, nin say ngaran na ket Gamaliel. Sayay Pariseo yayti nin madunong ya sa Gugan-gan ran Judio tan ata'gay a pangingikit ran sarba ran tutawo kona. Ket niparikor nasara yapo' a apostoles, ");
INSERT INTO smkNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","mi'sa wana konran kalalamo' nan pupangulo, “Kapada ko nin Israelita, pakandaen tamo a gaw'en tamo konran saraytin tutawo. ");
INSERT INTO smkNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bilang wadi', sin ambo' et nin na'teng, main yaytaw si tawon say ngaran na ket Teudas, nin sa wana saya yan alaki nin tawo. Ket main nin mag'a'pat a yasot sara a naayat na nin nikikalamo' kona. Bale' napati ya. Nisisyak saray tumutumbok kona, ket say nitarana' na na'rep. ");
INSERT INTO smkNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kaaram, main yaytaw anamaet si sayay taga Galilea nin say ngaran na ket Judas sin kapresan nin sinsus para sa pammayad nin buis. Main saraytaw anamaet saray naayat nin nikikalamo' kona. Bale' napati ya anamaet nin lamang ket nisisyak saran lamang a tumutumbok na. ");
INSERT INTO smkNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kanya' nin sawanin, si ibarita' ko maipa'ka' konran saraytin tutawo ket si pauryan tamo sara tamo'. No tawo tamo' a ibwatan nin sain nin gawa' tan akay ra, mangangga li' sa kasa. ");
INSERT INTO smkNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bale' no karabayan nan Dios, kai tamo sara nin mapaed, tan lumiwa' et a mangkuntrawen tamoyay Dios.” Ket sinunor ran pupangulo a wana ni Gamaliel. ");
INSERT INTO smkNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Say ginwa' ra tana, nipakayaban rasaray apostoles, nipasanet-sanet rasara, tan inima'no rasara anamana nin mangyakay nin maipa'ka' kona ni Jesus, mi'sa rasarayna nin binulusan. ");
INSERT INTO smkNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nibwat saraynadtaw a apostoles. Maririket sara a nikwinta nan Dios a maikana' saran mangirangep nin kading'eyan alang-alang kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Inawru-awron itaw sara et a lamang sa sakop nan Timplo tan sa bubali, nin nituloy ray pangangakay tan pangingipatanda' ra a si Jesus, syay Cristo nin nipangako' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ket sin saytaw nin panaon sin man'umabaw saraynan man'umabaw a tumutumbok kona ni Jesus, nagriklamo saray Judio nin say irgo ra ket Griego kuntra konran saray puron Judio. Wanra a saray bubbayin balo sa grupo ra ket kai sara nin mangkabyan nin man'ibin tulong inawru-awro. ");
INSERT INTO smkNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kanya' nin dininep rasaran labinrwan apostoles a sarba ra nga'min nin mammemper tan nibarita' ra konra, “Bubsat, ambo' nin mabista a pauryan mi a pangangakay mi nin say man'ibarita' nan Dios ta pigaw nin pagawan mi a pangingitayak nin tulong. ");
INSERT INTO smkNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanya' nin mamili' kamo nin pito ran lulalaki komoyo, nin mabistay pitatawo ra, madudunong sara tan peteg a mampag'urayan nasara nin Ispirito nan Dios, ta pigaw nin sara a gumwa' sa sain nin trabaho. ");
INSERT INTO smkNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ket si'kami, mai'pos mi a udas mi sa kadadasal tan sa pangangakay nin minsahi nin nangibwat konan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kumpurmi sara nga'min a mammemper sa saytin wanra nin apostoles. Ket namili' sarayna tan sarayti a pinili' ra: Si Esteban, a sya, magsen a pagmamatalek na konan Dios tan peteg a mampag'urayan naya nin Ispirito nan Dios; si Felipe, si Procoro, si Nicanor, si Timon, si Parmenas, tan si Nicolas a taga Antioquia nin ambo' yan Judio bale' gindat yaynan mantumumbok sa pammemper ran Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Niyadap rasara konran apostoles, ket nidasalan rasara tan nipababo ray gamet ra konra. ");
INSERT INTO smkNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ket say minsahi nin nangibwat konan Dios, naitayak anan naitayak, tan inmabaw saraynan inmabaw a tumutumbok kona ni Jesus itaw sa Jerusalem tan abaw sara anamaet a pupadi' nin tinumper. ");
INSERT INTO smkNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Binindisyunan tan binyan nayan pakayadi' nin Dios si Esteban, ket nangwa-nangwa' ya nin paka'kitan nin pakayadi' nan Dios tan raruma et nin makapaka'ngap a bubagay sa busel ran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bale' main nin tutawo nin nanguntra kona ni Esteban. Myimbro sara nin sayan dupong ran Judio a mantawagen nin Saray Ambo' Ana nin Aripen a taga sara Cirene, taga syudad nin Alejandria, taga prubinsyan Cilicia tan taga Asia. ");
INSERT INTO smkNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bale' kai raya gapo nin nadaeg si Esteban bana' ta say kadunungan na ket ibat konan Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ket bana' ta wanin, nangupa' sara nin tutawon mamaraktika nin bula'-bula' a kuntra kona ni Esteban. Saraytin inupaan, nibari-barita' ra a narnge' raya si Esteban nin nag'irgon duka' nin kuntra kona ni Moises tan konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yupa' sa wanin, pinasager rasara kona ni Esteban a tutawo, saray Mangatuntawo ran Judio tan saray Madudunong sa Gugan-gan ran Judio. Kaaram, inataki raya tan ginuyugoy rayan nika' niyadap konan Kunsiho. ");
INSERT INTO smkNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nangalap sara anamanaet nin tutawon namaraktika nin bula'-bula' nin kuntra kona ni Esteban. Wanra, “Siin si Esteban, kai ya nin tumgen nin mag'irgon duka' maipa'ka' konan si Timplo nan Dios tan sa Gugan-gan na. ");
INSERT INTO smkNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Narnge' mi nin nibarita' na a siin kano si Jesus a taga Nazaret ket yubaen nayayti si Timplo tamo tan silyan na a naimatawan tamon kaugalian a nangibwat kona ni Moises.” ");
INSERT INTO smkNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pinastang rayan maong si Esteban nin sarba ra nin itaw, ket na'kit ra a say rupa na kapadan bakas nin rupa nan sayay anghil. ");
INSERT INTO smkNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sin sain, wanan Sangkata'gayan nin Padi' kona ni Esteban, “Tutuo in para say man'iparsa ra komo?” ");
INSERT INTO smkNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Inumbat ya si Esteban a wana, “Bubsat tan mangatutua kosara, rumnge' kamo sa sayti say ibarita' ko. Sin saytaw sin si puon tamon si Abraham ket itaw ya et nin mampiikap sa Mesopotamia, sin ba'yo ya et nin inmalis nin nako sa syudad nin Haran, si Dios nin naipadar a kata'gayan na ket nipa'kit ya kona. ");
INSERT INTO smkNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wana nin Dios kona ni Abraham sin sain, ‘Lumakwan ka konan siti nin lugar tan konran pupartidos mo tan mako ka sa lugar nin pangipatyuan ko komo.’ ");
INSERT INTO smkNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Linmakwan ya anaod itaw sa lugar nin Caldeo tan nako ya nin niikap sa Haran. Bale' sin nati yayna si tatay na, pinaalis naya anamana nin Dios si Abraham nin nakodti sa lugar a mampiikapan tamo sawanin. ");
INSERT INTO smkNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sin sain, kai naya et gapo nin binyan nin Dios si Abraham nin luta' a matawag nan ikon na nin diri. Wanin man, nipangako' nan Dios a ibi nayayti li' nin luta' kona ni Abraham tan konra nin puri na. Sin sain bale' ket kasa et nin anak na ni Abraham. ");
INSERT INTO smkNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wanti et a wana nin Dios kona ni Abraham, ‘Saray puri mo, miikap sara li' sa nasyon ran sakalakon tutawo. Maaripen sara ket maduksa-duksa' sara li' sa luob nin a'pat a yasot nin taon. ");
INSERT INTO smkNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bale' dusawen koya li' a nasyon nin mangaripen konra, ket lumakwan sara li' konan siin nin nasyon tan sumubli' saradti, ket pagsirbyan rakodti.’ Sain a wana nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mi'sa, nangwa' yan pakitarato a Dios kona ni Abraham, nin pina'get ya nin pakaturi' ran sarba ran puri na nin paka'kitan a ikon nasara nin Dios. Kanya' nin sin naiyanak ya si Isaac a anak na ni Abraham, nipaturi' naya sin waloy awro nayna. Wanin anamaet a ginwa' na ni Isaac konan anak nan si Jacob, tan wanin na anamaet ni Jacob konran labinrwan a'nak nan lulalaki a saray pupuon tamon Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Saya konran saraytin mibubsat a say ngaran na ket Jose. Saray raruma maimbel sara kona kanya' nin nilako' rayan mag'in nin aripen itaw sa Egipto, bale' kai naya nin pinauryan nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nilasat naya sa sarban kaidapan na. Binyan nayan kadunungan sin inmadap ya konan si Faraon a si adi' sa Egipto, kanya' nin napaririketan ya kona ni Jose. Ginwa' nayan gubirnador sa Egipto si Jose tan ingkargado sa intiron palasyo na. ");
INSERT INTO smkNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ambo' nin na'teng, nagkamain nin bitil itaw sa intiron Egipto tan iti sa Canaan. Pinasyan idap ra nin saray tutawo tan saray pupuon tamo ta kasan ma'kan ra. ");
INSERT INTO smkNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sin natandaan na ni Jacob a main nin ma'kan sa Egipto, nibaki' nasaradtaw a ua'nak na a saray pupuon tamo. Sitaw a u'nan nipako ra sa Egipto. ");
INSERT INTO smkNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ket sin nako saradtaw nin pirwa, nipaalilbi' yayna si Jose konran bubsat na. Sin sain, natandaan nan Faraon a maipa'ka' konran pamilya na ni Jose. ");
INSERT INTO smkNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ket nika' naya nin nipakalap ni Jose si ama na a si Jacob tan saray sarba ran kukanayon na. Sara nga'min, pitumpulo' tan lima sara. ");
INSERT INTO smkNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nako ya anaod sa Egipto si Jacob tan si intiron pamilya na. Ket itaw yayna nin naparat'anan nin nati, wanin a lamang konran ua'nak na a saray pupuon tamo. ");
INSERT INTO smkNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bale' inawit nin nisubli' a bangkay ra sa Shekem ta nitabon saradtaw sa luta' a sinaliw na ni Abraham konran ua'nak na ni Hamor nin nigagara nayan gaw'en nin pannabunan. ");
INSERT INTO smkNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sin dandani anay panaon nin tukiden nayna nin Dios a nipangako' na kona ni Abraham, saray pupuon tamo nin itaw sara sa Egipto ket inmabaw saraynan inmabaw. ");
INSERT INTO smkNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Si adi' nin mampag'uray ana sa Egipto ket kai na nin natandaan a maipa'ka' sa alakin nagwaan na ni Jose sin saytaw. ");
INSERT INTO smkNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Masirib yayti nin adi' tan rinumi'-rumi' nasaray pupuon tamo tan pinilit rasaran itampal rasaray uabing ra ta pigaw nin mati sara. ");
INSERT INTO smkNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sin sain ket syay panaon nin naiyanak ya si Moises, a sya pinasyan anda' na nin abing. Inalila' raya nin saray matua na sa bali ra sa luob nin tuloy bulan. ");
INSERT INTO smkNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ket sin kapilitan ana nin nitampal raya, napurot naya nin babayin anak nan Faraon, ket nikwinta nayan anak nan diri. ");
INSERT INTO smkNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kanya' nin niyakay ya si Moises sa sarba nin kadunungan ran taga Egipto, ket nag'in yan madunong sa sarita' tan sa gawa' na. ");
INSERT INTO smkNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Sin a'pat a pulo' a taon nayna ni Moises, naisip nasaran pinasyar a kapada nan puri nan si puon nan si Israel. ");
INSERT INTO smkNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sin sain, na'kit nayay sayay kapada nan Israelita nin manrumi'-rumien nan sayay Egipcio. Nisakit nayay kadayaan na, ket napati nayay Egipcio. ");
INSERT INTO smkNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nipa'ka' na ni Moises a ma'kit ran kapada nan Israelita a syay usaren nan Dios sa panglat na konra sa pakaaripen ra, bale' kai ra nin na'kit. ");
INSERT INTO smkNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sin sinmunor nin awro, main nin rwa ray Israelita nin na'kit nan mampiaway. Apes nasaran patgenen tan pitunwen ket wana konra, ‘Bubsat, midayaan kamo, ket ambale' a mampiaway kamo?’ ");
INSERT INTO smkNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bale' sitaw si mampangrumi' niwaksil naya si Moises tan wana, ‘Ambale' a kibba'bat kadti? Si'noy nangikwa komo nin mag'uray tan mangukom komi? ");
INSERT INTO smkNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Rabay nako anamaet para nin patyen nin bilang sa ginwa' mo naapon konan sitaw si Egipcio?’ ");
INSERT INTO smkNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sin narnge' na in ni Moises, linmi'mo ya ket nalayo yadtaw sa Egipto nin nako sa lugar nin Midian. Sayay san'ili yan niikap itaw tan itaw yayna nin nakaasawa, ket nagkamain yan rwa ray a'nak nin lalaki. ");
INSERT INTO smkNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Napalabas a a'pat a pulo' a taon, nipa'kit ya kona ni Moises a sayay anghil konan sayay mandumtan kayo, itaw sa disyirto sa danin talugtog nin Sinai. ");
INSERT INTO smkNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Naka'ngap yan tuloy si Moises konan siin nin na'kit na, ket sin kinmadani ya ta pigaw nin kikiten nayan maong, bigra' nin narnge' na a busis nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Wana, ‘Si'ko et a lamang a Dios ra nin pupuon mo, si Dios na ni Abraham, si Dios na ni Isaac, tan si Dios na ni Jacob.’ Nangingintar ya sa li'mo na si Moises, ket andi' yaynan kumikit. ");
INSERT INTO smkNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ket wana et nin Dios kona, ‘Galten moy apin nin ayi mo ta siti si lugar nin mantukduan mo ket naipurok yan para kongko. ");
INSERT INTO smkNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mangka'kit ko a peteg a mangkapadya'dya' saray tutawo kodtaw sa Egipto. Marnge' koy ay'ay ra kanya' nin nako akodti ta pigaw nin galten kosarayna sa pakaaripen ra. Ket si'ka a ibaki' kodtaw sa Egipto.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nituloy na ni Esteban a nag'irgo a wana, “Siti si Moises, kai raya intaw nin inalilbi' nin saray kadayaan na nin saray Israelita ta wanra kona, ‘Si'noy nangikwa komo nin mag'uray tan mangukom komi?’ Bale' syay nibaki' na nin Dios nin mag'uray nin pa'sar mangibulos konra sa tulong nan anghil nin itaw intaw sa mandumtan kayo. ");
INSERT INTO smkNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises a nangiliwa' konradtaw sa Egipto, a sya nakagwa' ya nin abaw a makapaka'ngap nin nunangyadi' tan paka'kitan nin pakayadi' nan Dios, sin mintras a itaw sara et sa Egipto, sin itaw sara sa mantawagen nin Mu'dit a Taaw, tan sin itaw sara sa lugar a kasan tawo, sa luob nin a'pat a pulo' a taon. ");
INSERT INTO smkNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Siti si Moises a nangibarita' konran pupuon tamon Israelita a wana, ‘Si Dios, mangibaki' ya komoyo nin sayay prupita a kapada moyon Israelita, kapada sa nipangibaki' na kongko.’ ");
INSERT INTO smkNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Siti si Moises, kalamo' raya nin pupuon tamo sin rinayo rayay Dios itaw sa lugar a kasan tawo. Sya a nikiirgwan nan anghil itaw sa talugtog nin Sinai, tan kalalamo' nasaray pupuon tamo. Sya et a lamang a nangawang nin susarita' nan Dios nin makapami nin byay, ta pigaw nin sayti ket maiparate' kontamo. ");
INSERT INTO smkNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bale' kai sara nin tinmulok kona ni Moises a pupuon tamo; ana edet, kai raya nin kinabilangan ta say rabay ra ket sumubli' sara sa Egipto. ");
INSERT INTO smkNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kanya' nin sin itaw ya sa talugtog nin Sinai si Moises, wanra kona ni Aaron, ‘Ipangwa' rakami nin uistatwa nin mag'in nin dios min mangidalan komi, ta kai mi nin tanda' no ani anay nangyadi' konan sitaw nin Moises nin nangitagad komin lumakwan itaw sa Egipto.’ ");
INSERT INTO smkNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kanya' nin nangwa' sara anaod nin bakas nin uybon nin baka. Ket nangida'ton tan nangrayo sara kona, tan nagpista sara nin para konan siti nin ginwa' ra. ");
INSERT INTO smkNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bana' sa sain, ginurutan nasarayna nin Dios tan pinauryan nasaran mangrayo nin mataman nin say bubituen, si bulan tan si awro. Sain nin ginwa' ra ket bilang sa mabasa sa libro nin nisurat ran prupita a wana, ‘Si'kamo nin puri na ni Israel, ambo' nin si'ko a nangida'tunan moyo nin saytaw say pinati moyon uayep sin saytaw sin a'pat a pulo' a taon nin itaw kamo sa lugar a kasan tawo. ");
INSERT INTO smkNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","No kai, inawit-awit moya et a abung-abong a kami'nan nan mandiosen moyon say ngaran na Moloc tan si bituen a imahin nan si mandiosen moyon say ngaran na Renfan tan saray dios-dios nin ginwa' moyo ta pigaw nin raywen sara. Kanya' nin aburuyan kon madakep rakamon kukalaban moyo tan i'ras ra sa lugar a labas nin Babilonia.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wana et ni Esteban, “Main ana bale' nin pangraywan ran saray pupuon tamo konan Dios sin saytaw a si Abung-abong nin kami'nan nin paka'kitan a kalamo' rayay Dios. Awit-awit rayayti sin itaw sara sa lugar a kasan tawo. Naipa'deng yayti sigon sa bibilin nan Dios yupa' konan nipa'kit na kona ni Moises. ");
INSERT INTO smkNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sin nati yayna si Moises ket si Josue ana a nangipangulo konran saray pupuon tamo, awit-awit rayaytaw nin Abung-abong sin kina' rayay lugar a nipangako' nan Dios tan sin pinalakwan nasaran Dios a raruman tutawo konan sitaw nin lugar. Nipagamet-gamet ya konran nisusunur-sunor nin pupuon tamo a Abung-abong nin Piikapan nan Dios anggan sin panaon na ni Adi' a David. ");
INSERT INTO smkNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Napaririket yay Dios kona ni Adi' David. Anaod, dinawat na ni David a mama'deng yan bali para konan Dios a syan lamang a Dios nin rinayo na ni Jacob. ");
INSERT INTO smkNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bale' si Adi' Solomon nin anak na ni David a inaburuyan nan mama'deng nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wanin man, si Dios a syay Sangkata'gayan, kai ya nin miikap sa ginwa' tamo' nin tawo, ta wana nin Dios a nisurat nan saya konran prupita, ");
INSERT INTO smkNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Say kalangitan a truno ko, tan say luta' a tutukduan nin ayi ko. Ani a bakas nin bali ey a maipa'deng moyo para kongko, tan ani a bakas nin lugar a magwa' akodtaw nin painawa? ");
INSERT INTO smkNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kasaynan magwa' moyo sa sain. Si'koy nangwa' nin sarba.’ Nibarita' na in nin Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nituloy na ni Esteban, “Pinasyan tib'ey nin ulo moyo! Bara'mo kamon saray tutawon kai nin mangalilbi' konan Dios ta kadar kamoyna sa irgo na nin Dios. Bilang kamo nin saray pupuon tamo sin saytaw, mansubagen moyan pirmi a Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kasa gapo ni saya konran prupita nan Dios a kai ra nin dinuksa' nin saray pupuon tamo. Pinati-pati rasaray muminsahiron nibaki' nan Dios nin mangipatanda' nin maipa'ka' sa irarate' nan sitaw si Kasa Gapon Kasalanan na. Ket sin rinmate' ya anaod, nipadakep tan nipapati moya. ");
INSERT INTO smkNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Say katutu'wan, komoyo na nin nipaibi nin Dios konran uanghil na a Gugan-gan na, bale' kai moyo nin mantulukan.” ");
INSERT INTO smkNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sin narnge' ran pupangulo in nin wana ni Esteban, pinasyan sager ra kona ket nigeget-geget sara. ");
INSERT INTO smkNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bale' si Esteban, a sin sain ket liso nayan mampag'urayan nin Ispirito nan Dios, tinmangar ya sa langit ket na'kit nay salag nin kata'gayan nan Dios tan si Jesus nin naka'deng sa wanan nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ket wana ni Esteban, “Mangka'kit kon nakaburwang a langit tan sitaw si Pinaitawo ket naka'deng ya sa wanan nan Dios!” ");
INSERT INTO smkNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bale' saray tutawo, tineteb ray tutulyan ra tan ginmuryaw sara. Nirirngan rayan inataki si Esteban. ");
INSERT INTO smkNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nirikor raya sa syudad ket saraytaw saray nagtistigos nin kuntra kona linus'ok ray bata ra tan kinudas-kudas raya nin bato. Nibati' ray aysing ra konan sayay lalakin iti sa kalagu'-laguan na et a say ngaran na Saulo. ");
INSERT INTO smkNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Leleg a mangkudasen raya si Esteban, mandumasal ya a wana, “Uunuren kon Jesus, man'iparisibi koyaynay kararwa ko komo.” ");
INSERT INTO smkNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mi'sa, nanalimukod ya tan wana nin nita'way, “Uunuren, pirdunawen mosara sa saytin kasalanan a man-gaw'en ra.” Kayadi' na nin nibarita' in, nati yayna. ");
INSERT INTO smkNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Anaod, ayon ya sa nipangmati kona ni Esteban si Saulo. Ket nangibwat ana konan sitaw nin awro, dinuksa-duksa' saraynadtaw sa Jerusalem a mammemper konan Cristo. Kanya' nin pwira sara tamo' a apostoles, nitatayak sara a main nin nako sa saka-sakalakon lugar sa prubinsyan Judea tan Samaria. ");
INSERT INTO smkNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Main bale' nin tutawon matunong a nangitabon kona ni Esteban tan inabet-abetan rayan wanin ana. ");
INSERT INTO smkNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Siin a Saulo, wanin anay nipanuksa-duksa' na konran mammemper itaw! Sinre-sinrep nay pammali ra tan dinakep-dakep nasara nin kasan pinilian, bubbayi man o lulalaki, mi'sa nasara nin nipapriso. ");
INSERT INTO smkNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sin sain edet, saraytaw saray mammemper nin nitatayak nin nako sa nagsikabarang nin lulugar, nipata-patanda' rayay minsahi maipa'ka' konan si nibaki' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si saya konra, si Felipe, nako ya sa sayay syudad sa Samaria ta ipatanda' nadtaw a maipa'ka' konan si sya a Mesias. ");
INSERT INTO smkNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nangrenge' saran maong a abaw nin tutawo sa minsahi na ni Felipe sin narnge' rayan mampag'irgo tan naimatunan ray ginwa-ginwa' nan paka'kitan nin pakayadi' nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Abaw saray uispiriton duka' a man'umasisit nin pinalakwan na konran saray nasrepan ra, tan napaanda' nasaray abaw nin paralitiko tan pilay. ");
INSERT INTO smkNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kanya' nin wanin anay ririket ran tutawo konan sitin syudad. ");
INSERT INTO smkNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sin sain, main nin mampiikap itaw nin sayay salamangkiro a say ngaran na ket Simon. Anro anay panaon nin mampaka'ngapen nasaray tutawodtaw sa Samaria yupa' sa gawa'-gawa' na, tan wana ket saya ya kanon ambo' tamo' nin urdinaryon tawo. ");
INSERT INTO smkNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sarba ran tutawodtaw sa Samaria, ayupa' man o ata'gay, nangrenge' saran maong kona ta wanra sya kanoy pakayadi' nan Dios a mantawagen ran Alakin Pakayadi'. ");
INSERT INTO smkNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na'teng ana nin talagan mampaka'ngapen nasaran tuloy a tutawo yupa' sa pagmamadyik na kanya' nin mampangrenge' sara kona. ");
INSERT INTO smkNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bale' sin nipata-patanda' naya ni Felipe a Mabistan Patanda' maipa'ka' sa pag'aadi' nan Dios tan say maipa'ka' sa no si'no ya si Jesu-Cristo, namper sara anaod ket nipabawtismo sara, bubbayi tan lulalaki. ");
INSERT INTO smkNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati si Simon, namper ya ket nipabawtismo ya, tan nayi yaynan pirmi kona ni Felipe. Naka'ngap yan tuloy sa milagro tan paka'kitan nin pakayadi' nan Dios nin ginwa-ginwa' na ni Felipe. ");
INSERT INTO smkNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Natandaan ran saray apostoles nin itaw sa Jerusalem a namper saray tutawo sa Samaria sa sain nin minsahi nan Dios kanya' nin nibaki' rasaradtaw si Pedro tan si Juan. ");
INSERT INTO smkNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sin rinmate' saradtaw si Pedro tan si Juan, nidasalan rasara a mammemper nin Samaritano a mako ya kumon nin miikap konra a Ispirito nan Dios, ");
INSERT INTO smkNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ta sin sain ket nabawtismwan sara tamo' et sa ngaran na ni Uunuren tamon Jesus tan kai ya et nin mampiikap konra a Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nipababo ra ni Pedro tan ni Juan a gamet ra konran mammemper ket nako yayna nin miikap konra a Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Naimatunan na ni Simon a nako ya nin miikap konran mammemper a Ispirito nan Dios bana' sa nipangipababo ran gamet ran apostoles konra. Inuprisiwan nasaran kwarta si Pedro tan si Juan, ");
INSERT INTO smkNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a wana, “Byan rako pa anamaet nin wanin nin pakayadi' ta pigaw nin si si'numan a pangipababwan ko nin gamet ko ket mako ya nin miikap kona a Ispirito nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ket ni'bat na ni Pedro kona, “Mako ka sa impyirno nin kalamo' moy kwarta mo, bana' sa sain nin pangngipa'ka' mo a mabayadan a pakayadi' nan Dios! ");
INSERT INTO smkNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kai ka nin makakibiang sa sayti say man'ipagwa' komi bana' ta tanda' nan Dios a say iti sa kanakman mo ket ambo' nin kusto. ");
INSERT INTO smkNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pagbabawian mo in nin duka' a mampanggepen mo tan kidawat ka nin pirduna konan Dios ta awa' a lamang nin pirdunawen naka sa sain nin duka' a kaisipan mo. ");
INSERT INTO smkNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wanin ta ma'kit ko a napno' ka nin imbel tan bara'mo ka nin priso ta kai kayna nin makaru'kang sa kadukaan mo.” ");
INSERT INTO smkNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ket wana ni Simon konra ni Pedro tan Juan, “Ipasinga'do rako pa konan Catawan ta pigaw nin sain say nibarita' moyo ket kai nin mangyadi' kongko.” ");
INSERT INTO smkNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sin nayadi' rayna nin nibari-barita' a minsahi nin nangibwat konan Catawan tan nipapalaway ray tanda' ra maipa'ka' kona ni Jesus, sinmubli' sarayna si Pedro tan si Juan sa Jerusalem. Ket sa lulugar a nalabas-labasan ra sa Samaria, nipata-patanda' raya et a Mabistan Patanda'. ");
INSERT INTO smkNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sawanin, main nin anghil nan Dios a pina'kit kona ni Felipe tan wana kona, “Mibwat ka nin makodtaw sa bandan bagatanan sa dalan sa lugar a ambo' nin matawo nin palusong nin mako sa Gaza a mangibwat sa Jerusalem.” ");
INSERT INTO smkNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nibwat ya anaod nin nako si Felipe, ket itaw na'kit nayay sayay sangkata'gayan nin upisyal sa Etiopia; siti ket kapon ya. Siti a ingkargado sa sarban kayamanan nan Candace a syay rina sa Etiopia. Nako yadtaw sa Jerusalem nin nangrayo konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ket, sin sain, mansumubli' yayna sa Etiopia a nakaruran ya sa karwahi na nin mambasawen nayay libron nisurat na ni Prupita Isaias. ");
INSERT INTO smkNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nibarita' nan Ispirito nan Dios kona ni Felipe a ampadan nayay karwahi. ");
INSERT INTO smkNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Anaod nangred yan kinmadani si Felipe ket narnge' nan mambasawen nayan upisyal a libro nin nisurat na ni Prupita Isaias. Nitepet na ni Felipe, “Mataros moyo para a pipa'kaan nin sain say mambasawen moyo?” ");
INSERT INTO smkNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ni'bat na nin upisyal, “Pa'no ko nin mataros ey no kasa nin mangipapalaway kongko?” Ket sinagyat nayan rumuran si Felipe. ");
INSERT INTO smkNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Si parti nin Masanton Kasuratan a mambasawen na ket wanti a wana, “Man'ika' ya sa pangmamatyan nin bara'mo yan sayay karniro. Anaod, say pitatawo na ket bilang sa uybon nin karniro a kai gapo nin umimi' no pukrisan a sabot na; kai ya gapo nin rinmason. ");
INSERT INTO smkNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sin tinuya'-tuya' rayan pinading'eyan, nisiblet ray hustisya kona. Ket, kasa li' nin makaibarita' nin say maipa'ka' konran puri na ta mangangga anay byay nadti sa luta'.” ");
INSERT INTO smkNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wana nin upisyal kona ni Felipe, “Si'no yaytin tawo si man'ibarita' nan sitin prupita? Sya para o raruman tawo?” ");
INSERT INTO smkNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sin sain, nitarana' na konan siin si binasa nan upisyal, nipapalaway naya ni Felipe kona a Mabistan Patanda' maipa'ka' kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Nituluy-tuloy ray pagbibyahi ra ket nirate' sara sa lugar a main nin ranom. Wanan upisyal kona ni Felipe, “Ya, yuoy a ranom! Main kasin rason a kai ako et nin mabawtismwan?” ");
INSERT INTO smkNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sin sain, nipapatgen nayan upisyal a karwahi tan nako sara sa kami'nan nin ranom ket binawtismwan naya ni Felipe. ");
INSERT INTO smkNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sin man'umarwas sarayna sa ranom, ni'ras nayaynan tampor nin Ispirito nin mangibwat konan Uunuren si Felipe ket kai nayayna nin na'kit nin upisyal. Nituloy nayna a sinmubli' sa lugar na a pinasyan ririket na. ");
INSERT INTO smkNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Naaraman na tana ni Felipe a itaw ya sa lugar nin Azoto. Nangibwat itaw, nipata-patanda' nayay Mabistan Patanda' maipa'ka' kona ni Jesus sa bubabali nin linabasan na angga sin nirate' ya sa Cesarea. ");
INSERT INTO smkNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Si Saulo anamaet, man'ituluy-tuloy nay panglili'mo tan pangmamati na konran tumutumbok kona ni Jesus. Nako ya konan Sangkata'gayan nin Padi' ");
INSERT INTO smkNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tan nangalap yan surat nin mangibarita' konran pupangulo sa susinaguga ran Judio sa syudad nin Damasco a binyan ya nin aburoy nin dakpen nasara a sarba ran ma'kit nan mantumumbok konan siti si Ba'yon Dalan, lulalaki o bubbayi man. Ket awiten nasarayti nin ipriso sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sawanin, sin itaw sarayna sa dalan si Saulo nin adani sarayna sa Damasco, bigra' anan main nin salag nin palaway nin ibat sa langit tan sinmira' ti kona ni Saulo. ");
INSERT INTO smkNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Naipalukob ya sa luta' si Saulo ket kaaram main nin busis nin narnge' na a wana, “Saulo, ambale' a manduksa'-duksaen nako?” ");
INSERT INTO smkNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ket wana ni Saulo, “Si'no kamo, Ser?” Wanan inumbat nin busis, “Si'ko si Jesus nin manduksa'-duksaen mo. ");
INSERT INTO smkNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Umdeng ka tan mako kadtaw sa syudad. Itaw main li' nin mamarita' no ani a gaw'en mo.” ");
INSERT INTO smkNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sin sain, saray kalalamo' na ni Saulo, tinumgen sara tan kai sara gapo nin nakatnoy ta main nin mangkarnge' ran mampag'irgo bale' kasa nin si'numan nin ma'kit ra. ");
INSERT INTO smkNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Inumdeng ya si Saulo tan nimulagat ya bale' kai ya nin maka'kit kanya' nin tinabin rayan nako sa Damasco nin saray kalalamo' na. ");
INSERT INTO smkNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa luob nin tuloy awro ket kai ya nin naka'kit, tan kai ya nin nangan o ninom. ");
INSERT INTO smkNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Sin sain, main itaw sa Damasco nin tumutumbok kona ni Jesus nin say ngaran na Ananias. Nipa'kit ya si Uunuren nin Jesus kona sa sayay bara'mon taynep tan wana kona, “Ananias!” Inumbat ya si Ananias a wana, “Uunuren, ambale'?” ");
INSERT INTO smkNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ket wana nin Uunuren kona, “Mako kadtaw sa dalan a mantawagen nin Matu'rir, tan itaw sa bali na ni Judas, tepeten may sayay lalaki nin taga Tarso a say ngaran na Saulo. Sya, marate' man mandumasal. ");
INSERT INTO smkNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nipa'kit koyna kona sa sayay bara'mon taynep a main nin tawon mako kona nin say ngaran na Ananias tan ipababo nay gamet na kona ta pigaw nin maka'kit ya anamanaet.” ");
INSERT INTO smkNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Bale' wanan ni'bat ni Ananias, “Uunuren, abaw saraynay nakarngean kon maipa'ka' konan siin nin tawo tan say panunuksa-duksa' na konran saray tutawo mo itaw sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ket sawanin iti ya sa Damasco ta binyan rayan pakayadi' nin saray Pupangulon Pupadi' a dakpen nasara a sarba ran mangrayo komo.” ");
INSERT INTO smkNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bale' wana nin Uunuren kona ni Ananias, “Basta mako ka, ta pinili' koya nin ipatandaan nay maipa'ka' kongko konran saray ambo' nin Judio tan konran saray mampag'uray konra, tan konra et anamaet nin saray kapada moyon Israelita. ");
INSERT INTO smkNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ket si'ko, ipatandaan ko kona a sarban matkap nan irangep para sa kakanaan ko.” ");
INSERT INTO smkNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anaod, nako yayna si Ananias sa balin kami'nan na ni Saulo. Sinumrep ya tan nipababo nay gamet na kona a wana, “Busat a Saulo, si Uunuren nin Jesus nin nipa'kit komo sa dalan sin adap modti, nibaki' nakodti komo ta pigaw nin maka'kit ka anamana tan pag'urayan naka nin Ispirito nan Dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tampor main nin naragrag nin bara'mon siksik nin kuna' nangibwat sa mata na ni Saulo ket naka'kit ya anamanaet. Inumdeng ya tan nipabawtismo ya. ");
INSERT INTO smkNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kaaram nangan yayna, ket sinmubli' a gindat nin kasaw na. Nikiikap ya nin umnoy awro si Saulo konran tumutumbok na ni Jesus itaw sa Damasco. ");
INSERT INTO smkNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tampor a nipata-patanda' nayna sa susinaguga ran Judio itaw sa Damasco a si Jesus Anak naya nin Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sarba ran saray nakarnge' kona, naka'ngap sara ket wanra, “Ambo' ya parayti taw si tawo nin nanuksa-duksa' konran mammemper kona ni Jesus itaw sa Jerusalem? Ambo' para a kanya' nin nako yadti sa Damasco ket ta pigaw nin dakpen nasara a sarba ran mangrayo kona ni Jesus iti tan baruren nasaran awiten konran Pupangulon Pupadi'?” ");
INSERT INTO smkNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wanin man, ginumsen anan ginumsen a pangangayat na ni Saulo, ket pinatutu'wan na nin ma'get a si Jesus syan diri a Cristo nin tinudo' nan Dios, kanya' nin saray Judio nin itaw sa Damasco ket kasa gapo nin maibarita' ran ipanguntra kona. ");
INSERT INTO smkNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sin abaw anay awro nin linmabas a mampangyakay ya sa susinaguga si Saulo, nag'iirgo saray pupangulo ran Judio sa Damasco no pa'no raya nin mapati. ");
INSERT INTO smkNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bale' natandaan na ni Saulo a awro tan yabi rayan mansadyaan sa purta nin padil nan syudad ta pigaw nin patyen raya. ");
INSERT INTO smkNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ket sayay yabi, saray namper kona ni Jesus bana' kona, nikwa raya sa gagaban si Saulo tan niuy'oy raya nin mamaliwa' sa dudungawan sa padil. ");
INSERT INTO smkNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sin sinmubli' ya sa Jerusalem si Saulo, inapes nay kikalamo' konran tumutumbok na ni Jesus bale' mali'mo sara kona ta kai sara nin mamper a tumutumbok nayayna ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bale' tinulungan naya ni Bernabe. Ni'ras naya konran apostoles tan nibarita' na konra a nipa'kit tan nikiirgo yay Uunuren kona ni Saulo itaw sa dalan nin mamunta sa Damasco. Nibarita' na et konra a kai ya gapo nin mali'mo si Saulo nin nangipatanda' maipa'ka' kona ni Jesus itaw sa Damasco. ");
INSERT INTO smkNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ket nangibwat ana sin sain, nikikalamo' yayna si Saulo konra tan nayi-nayi ya konra sa Jerusalem. Pinasyan tepel nan nangipatanda' itaw nin maipa'ka' kona ni Uunuren a Jesus ");
INSERT INTO smkNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tan nikidiskusyon ya konran Judio nin makapag'irgon sarita' nin Griego. Konan siin niplano rayan patyen. ");
INSERT INTO smkNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ket sin natandaan ra in nin mammemper, nika' raya sa Cesarea mi'sa raya nin pinaibwat nin mako sa lugar na nin Tarso. ");
INSERT INTO smkNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sin sain, matinek a kapapa'sar ran lapag nin tutawo nan Dios sa lulugar nin Judea, Galilea tan Samaria. Sa panunulong nan Ispirito nan Dios, ginumsen a pammemper ra tan nituluy-tuloy ray nagkabyay nin mapangunor konan Dios. Inmabaw saraynan inmabaw a mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Si Pedro anamaet, naku-nako ya sa sarban lugar a main nin mammemper kona ni Jesus. Nako yadtaw anamaet konran tutawo nan Dios sa babali nin Lida. ");
INSERT INTO smkNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ket itaw main nin tawon nadumog nan say ngaran na Eneas, a siti si Eneas, waloy taon naynan naidalit sa apay ta paralitiko ya. ");
INSERT INTO smkNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","“Eneas,” wana ni Pedro kona, “si Jesu-Cristo, paandaen nakayna, kanya' nin mibangon ka tan lulunen ma in si apay mo!” Ket, nibangon yan tampor. ");
INSERT INTO smkNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ket abaw saray tutawodtaw sa babalin Lida tan sa lugar nin Saron a namper konan Cristo sin na'kit ran napaanda' ya si Eneas. ");
INSERT INTO smkNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Itaw anamaet sa syudad nin Joppa, main nin babayin tumutumbok kona ni Jesus a say ngaran na Tabita (sa sarita' nin Griego, say ngaran na ket Dorcas). Siti si Dorcas, ugali' na a gumwa' nin maabig tan tumulong konran mumaidap. ");
INSERT INTO smkNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ket sin sain, nagmasakit ya tan nati ya. Pinaryo' raya tan nipaida' rayay bangkay na sa kwarto sa ta'gay nan bali. ");
INSERT INTO smkNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Adani ana a Joppa sa Lida, ket sin narnge' ran tumutumbok na ni Jesus a itaw ya si Pedro sa Lida, namaki' sara nin rwa ra konra nin dawaten ra kona ni Pedro a no magwa' ket mako yan tampor itaw sa lugar ra. ");
INSERT INTO smkNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nayi ya anaod nin tampor konra si Pedro. Sin nakarate' saraynadtaw sa Joppa, ni'ras raya si Pedro sa kwarto sa ta'gay nin kami'nan nan bangkay na ni Dorcas. Inaribungbungan raya si Pedro nin saray bubbayin balo a man'umakis sara tan nipa'ki-pa'kit ra kona a uaysing tan kukapa nin ginwa' na ni Dorcas sin mabyay ya et. ");
INSERT INTO smkNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pinaliwa' nasara nga'min sa kwarto ni Pedro, kaaram nanalimukod ya tan dinmasal ya. Sin nayadi' yayna nin dinmasal inadap nayay bangkay tan wana, “Tabita, mibangon ka!” Ket, nimulagat ya si Tabita tan sin na'kit naya si Pedro, nibangon ya nin tinmekre' ya. ");
INSERT INTO smkNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Gina'getan naya ni Pedro sa gamet tan tinulungan nayan inumdeng. Mi'sa nasara nin kinayaban a bubbayin balo tan saray raruma et nin tutawo nan Dios, tan niprisinta naya konra si Tabita nin mabyay ya. ");
INSERT INTO smkNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Say maipa'ka' konan sitin nangyadi' ket natanda-tandaan sa intiron Joppa, ket abaw saray nagmatalek kona ni Catawan nin Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Niikap yaynadtaw yapo' sa Joppa si Pedro, a nikipagtuloy ya konan sayan mangangwa' nin bubagay a mangusar yan katat nin ayep a say ngaran na ket Simon. ");
INSERT INTO smkNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sa syudad nin Cesarea anamaet, main itaw nin sayay lalaki nin ambo' nin Judio a say ngaran na ket Cornelio. Sya a upisyal nan grupo ran sundalo' nin Romano a mantawagen nin Batalyon a Ibat sa Italia. ");
INSERT INTO smkNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rilihyuso ya ket sya tan si intiron pamilya na manraywen rayay Dios. Malaem a tulong nin man'ibi na konran mumaidap nin Judio, tan kai na nin manlingatan a dumasal konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sayay awron bandan alas tres nin yabina, bara'mo ya nin mampanaynep si Cornelio. Main nin anghil nan Dios nin nako kona tan tinawag naya a wana, “Cornelio!” ");
INSERT INTO smkNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pinastang naya ni Cornelio a anghil a pinasyan li'mo na tan wana, “Ani a rabay moyo, Ser?” Ket wana nin anghil kona, “Napagustwan yay Dios sa dudasal mo tan sa panunulong mo, ket tubaleen naka. ");
INSERT INTO smkNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ket sawanin anaod, mamaki' kadtaw sa Joppa a keen raya nin kayaban a sayay tawon say ngaran na Simon bale' say tawag kona ket Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mangkipagtuloy ya konan sayay tawo a say ngaran na anamaet ket Simon a mangangwa' ya nin bubagay nin mangusar yan katat nin ayep. Si bali na itaw ya sa rigrig nin baybay.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sin nibwat yaynay anghil, tinawag nasaran tampor ni Cornelio a rwa ran katulong na tan saya konran saray sundalo' na. Mangrarayo yayti anamaet nin sundalo' konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nibarita' na ni Cornelio a sarba konra mi'sa nasara nin nibaki' sa Joppa. ");
INSERT INTO smkNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sin sinmunor nin awro, sin saraytaw saray nibaki' na ni Cornelio ket adani sarayna sa Joppa, si Pedro anamaet, nuli' ya sa patag nin atep nan bali nin kami'nan na ta pigaw nin dumasal ya. Sin sain, mag'ugtiawro ana. ");
INSERT INTO smkNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mabitil yayna si Pedro, ket leg'an a man'isadya' ray kanen na, bara'mo yan nanaynep. ");
INSERT INTO smkNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sa paka'kit na ket niabri a langit tan main nin bara'mon alakin ules nin naitaker a a'pat nin duyo na nin mangkumayupa' itaw sa kami'nan na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Itaw konan sitaw si bara'mon ules ket sarba anan klasi nin uayep bilang saray atap nin uayep, saray kumayam tan saray manuk-manok. ");
INSERT INTO smkNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kapingmatan main nin narnge' nan busis ni Pedro a wana, “Pedro, mangmati ka ta pigaw nin main nin kunaen mo.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bale' ni'bat na ni Pedro, “Andi' ako, Uunuren, ta kai ko et gapo nin nasari' a nangna' nin ayep a ikwinta nin nikasama' ta maiyawa' komi nin Judio.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ket wana anamanaet nin busis kona, “Andi' mo nin ibarita' nin nikasama' tan maiyawa' nin kanen a wana nin Dios ket ma'kan.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nitlo in nin nibarita' kona ni Pedro mi'sa sitaw si bara'mo nin ules ket naipata'gay yayna nin namunta sa langit. ");
INSERT INTO smkNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ket mintras nin mampaka'ngapan na ni Pedro a pipa'kaan nin sain nin nipa'kit nan Dios kona, saraytaw saray nibaki' na ni Cornelio, nadumog rayaynay bali na ni Simon. Itaw saran naka'deng sa adapan nin purta. ");
INSERT INTO smkNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kinmutana sara tan tinepet ra no main nin mampagtuloy itaw nin say ngaran na ket Simon tan mantawagen yan lamang nin Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sin sain anaod a mintras nin man'adalen na ni Pedro a pipa'kaan nin say nipa'kit nan Dios kona, si Ispirito nan Dios wana kona, “Main nin tulo ray lulalaki nin mampaningkap komo. ");
INSERT INTO smkNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Manaoy kan tampor tan andi' ka nin masuknad nin mayi konra ta nakem ko a nako saradti.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ket nanaoy ya si Pedro tan wana konra, “Si'ko a mantikapen moyo. Ani a gagara moyo kongko?” ");
INSERT INTO smkNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wanran ni'bat kona, “Nibaki' rakamidti nin sayay tawo a say ngaran na ket Cornelio. Upisyal ya nin sundalo'. Matunong ya nin tawo tan manraywen nayay Dios, tan ata'gay a pangingikit ran sarba ran Judio kona. Si sayay anghil nan Dios, nibarita' na kona a sagyaten nakan makodtaw sa bali na ta pigaw nin mangrenge' ya sa ibarita' mo kona.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pinaluob nasara ni Pedro tan pinaka'lek nasarayna yapo' itaw konan siin nin yabi. Sin kabubuklas, nayi ya konra, pati saray umno ran mammemper nin taga Joppa. ");
INSERT INTO smkNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sin sinmunor nin awro sarayna nin nakarate' sa Cesarea. Itaw saraynan mantuma'gan sa bali na si Cornelio tan saray kukanayon tan uamigo na nin sinagyat na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sin rinmate' saradtaw si Pedro, sinna' naya ni Cornelio tan nanalimukod yan linmukob sa adapan na nin pinagalangan naya. ");
INSERT INTO smkNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bale' pina'deng naya ni Pedro tan wana kona, “Umdeng kamo. Tawo ako tamo' anamaet a lamang nin kapada moyo.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mintras nin mampag'irgo sara, sinumrep sara sa bali a itaw, na'kit na ni Pedro nin abaw saray tutawo ");
INSERT INTO smkNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ket wana konra, “Tanda' moyon peteg a maiyawa' komi nin Judio a mako sa bali moyo o kilimug-limog komoyo nin ambo' nin Judio. Bale', si Dios, nipatarusan na kongko a matkap a andi' koya nin ikwinta a si'numan nin kai naya nin maako' nin Dios o kai ya nin maibagay nin kilimug-limugan. ");
INSERT INTO smkNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Edet, sin nipa'ka' rako, kai ako gapo nin masuknad nin nakodti. Ket sawanin edet, ibarita' moyo pa kongko no ambale' a nipa'ka' rako.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ket wana ni Cornelio, “Ika'pat nin awro sawanin a napalabas sin wantin mag'alas tres sa yabina a mandumasal ako, ket kapingmatan ana a main nin lalakin naka'deng sa adapan ko nin makapulag a seket na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wana kongko, ‘Cornelio, narnge' na nin Dios a dudasal mo tan kai na nin malingwanan a panunulong mo konran mumaidap. ");
INSERT INTO smkNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ket sawanin mamaki' kadtaw sa Joppa a keen raya nin kayaban a sayay tawon say ngaran na ket Simon tan mantawagen ya et nin Pedro. Mangkipagtuloy ya konan sayay tawo a say ngaran na Simon anamaet a mangangwa' ya nin bubagay nin mangusar yan katat nin ayep. Si bali na ket itaw ya sa rigrig nin baybay.’ ");
INSERT INTO smkNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Anaod, namaki' akon tampor nin nakodtaw komoyo ket kisalamat akon alaki ta nayi kamodti. Ket sawanin anaod, iti kami nga'min nin nadinep sa adapan nan Dios, nin mantuma'gan ta pigaw nin mangrenge' kami sa nigan-gan nan ipatarusan mo komi.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Sin sain, nag'irgo ya si Pedro a wana, “Sawanin mataros koynan peteg a kasan pinilian konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Akuen naya nin Dios a si'numan nin mampangunor kona tan mampangwa' nin mapteg mataman no ani a nasyon na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Maipa'ka' sa minsahi a nibi na komi nin Israelita, narnge' moyoyna in. Komi naya nin nipatanda' a Mabistan Patanda' maipa'ka' sa pakikituno na konran tutawo yupa' kona ni Jesu-Cristo a syay Uunuren nin sarba. ");
INSERT INTO smkNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tanda' moyoytaw say nangyadi' sa kami'nan ran Judio. Tinmarana' itaw sa Galilea kayadi' na nin nipata-patanda' ni Juan a maipa'ka' sa pammawtismo na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tanda' moyo a si Dios ket nitalaga naya para sa sayay gawa' si Jesus a taga Nazaret ket nibi naya a Ispirito na tan say pakayadi' kona. Naku-nako ya sa nagsikabarang nin lugar nangwa' nin maabig para konran tutawo tan pinalimpyo nasara a sarba ran mampangirangepen nan Dimunyo. Nagwa-nagwa' na in ni Jesus ta si Dios ket kaantabay naya. ");
INSERT INTO smkNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Si'kami nin apostoles na ni Jesus, matistigusan mi nga'min a maipa'ka' sa sarban ginwa-ginwa' na sa lugar mi nin Judio, sa nagsikabarang nin prubinsya, wanin et sa syudad nin Jerusalem. Matistigusan mi et nin pinati raya nin nipasak sa kudos. ");
INSERT INTO smkNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bale' siti si Jesus, sin ikatlon awro, pinasubli' nayan mabyay nin Dios, tan nipa'kit ya, ");
INSERT INTO smkNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","bale' ambo' sa sarba nin tawo no kai edet, komi tamo' nin pinili' nayna nin gindat nin Dios nin makaimaton sa mangya-mangyadi' kona. Si'kami a makatistigos ta nikidungu-dungo kami et nin nangan tan ninom kona kayadi' na nin sinmubli' nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ket ginan-gan nakami nin ipatandaan miya konran tutawo a Mabistan Patanda' maipa'ka' kona tan ibari-barita' mi a sya a nikwa nan Dios nin manintinsya li' kontamo nga'min, mabyay man o nati ana. ");
INSERT INTO smkNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Syaytaw si wanra nin sarba ra nin prupita a si si'numan nin magmatalek kona, pirdunawen nan Dios a kasalanan na yupa' tamo' sa ginwa' na.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sawanin, mintras a mampag'irgo ya si Pedro, si Ispirito nan Dios nako ya nin nag'uray sa barang saya nin mampangrenge' sa man'ibarita' na. ");
INSERT INTO smkNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ket saraytaw saray mammemper nin Judio nin kalalamo' na ni Pedro, naka'ngap saran maong ta nibi naya anamaet nin sibubulos nin Dios a Ispirito na konran ambo' nin Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Wanin ta narnge' rasaray ambo' nin Judio nin mampag'irgo nin susarita' a kai ra nin tanda' tan manraywen rayan tuloy a Dios. Sin sain anaod, wana ni Pedro, ");
INSERT INTO smkNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nibaki' naya anamaet a Ispirito nan Dios konran sarayti nin kapadan nipamaki' na kontamo. Bana' ta wanin kasan sukat nin makapaed a bawtismwan sara.” ");
INSERT INTO smkNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Konan siin, nipabawtismwan nasara ni Pedro sa ngaran na ni Jesu-Cristo. Sin nayadi' sarayna nin binawtismwan, dinawat ra kona ni Pedro a itaw ya yapo' nin umnoy awro. ");
INSERT INTO smkNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Saray apostoles tan saray mammemper itaw sa intiron prubinsyan Judea, natandaan ra a saray ambo' nin Judio, namper sarayna anamaet sa man'ipatanda' ran minsahi nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sawanin, main saraytaw saray mammemper a wanra, matkap a paturi' saray mammemper. Kanya' nin sin nugot ya sa Jerusalem si Pedro, sarayti, sinita raya a ");
INSERT INTO smkNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","wanra, “Ambale' a nikipagtuloy ka kano konran ambo' nin Judio tan nikidungu-dungo ka et kanon nangan konra?” ");
INSERT INTO smkNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Anaod, inisturya na ni Pedro konra a sarban nangyadi' nangibwat sa tarana'. ");
INSERT INTO smkNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Wana, “Ni'sa nin mandumasal ako sin itaw ako sa Joppa, main nin na'kit ko a bara'mo ako nin nanaynep. Main nin bara'mon alakin ules nin naitaker a a'pat nin duyo na a mangkumayupa' nin nangibwat sa langit ket dinumpa' ya sa dani ko. ");
INSERT INTO smkNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kinikit koyan maong ket na'kit kon konan sitaw nin bara'mon ules ket sarbaynan klasi nin uayep bilang saray atap nin uayep, saray kumayam tan saray manuk-manok. ");
INSERT INTO smkNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kapingmatan, main nin narnge' ko nin busis a wana, ‘Pedro, mangmati ka ta pigaw nin main nin kunaen mo.’ ");
INSERT INTO smkNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Bale' wangko nin ni'bat, ‘Andyak, Uunuren, ta kai ko et gapo nin nasari' a nangna' nin uayep a ikwinta nin nikasama' ta maiyawa' komi nin Judio.’ ");
INSERT INTO smkNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ket wana anamanaet nin busis nin ibat sa langit, ‘Andi' mo nin ibarita' nin nikasama' tan maiyawa' nin kanen a wana nin Dios ket ma'kan.’ ");
INSERT INTO smkNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nibarita' in nin nitlo mi'sa sitaw si bara'mo nin ules ket nipata'gay yayna nin sinmubli' sa langit. ");
INSERT INTO smkNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ket sin sain a lamang nin udas, main nin tulo ran lulalaki nin rinmate' itaw sa mampagtuluyan mi. Nibaki' sara kongko nin nangibwat sara sa Cesarea. ");
INSERT INTO smkNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Si Ispirito nan Dios, nibarita' na kongko a andi' ko nin asikaswen a ambo' saran Judio. Ket, sarayti nin a'nem nin bubsat sa pammemper a tagadtaw sa Joppa, nayi sara kongko. Ket sin itaw kami ana sa Cesarea, nako kami sa bali na ni Cornelio. ");
INSERT INTO smkNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ket nibarita' na ni Cornelio komi a main nin anghil nin nakodtaw kona sa bali na tan wana kano kona, ‘Mamaki' kadtaw sa Joppa nin keen raya nin kayaban si Simon a mantawagen et nin Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ipatandaan na komo no pa'no nin si'ka tan sarba ra sa pammali mo ket maisalba sara.’ Wanin kanoy wanan anghil kona. ");
INSERT INTO smkNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ket, sin itaw kami anaod sa bali na ni Cornelio, sin tinmarana' akon mag'irgo konran itaw, si Ispirito nan Dios nako ya nin nag'uray konra nin kapadan sin primiro nan nako nin nag'uray kontamo. ");
INSERT INTO smkNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Sin sain, napanemtem koy wana intaw ni Uunuren tamon Jesus, ‘Si Juan, say ipamawtismo na ranom, bale' si'kamo, mabawtismwan kamo li' nin Ispirito nan Dios.’ ");
INSERT INTO smkNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ket, main paran kapangyadian kon kuntrawen ya a Dios? Anaod, nibaki' nayan Dios nin miikap a Ispirito na konran ambo' nin Judio, kapadan nipamaki' nan siti kontamo sin nagmatalek atamo kona ni Uunuren a si Jesu-Cristo.” ");
INSERT INTO smkNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sin narnge' ra in nin wana ni Pedro, nitgen raynay paninita ra kona, tan rinayo rayayna edet a Dios. Wanra, “No wanin, binyan nasara anamaet anamain nin Dios nin pagkanawanawa nin magbabawi' sa kukasalanan ra a ambo' nin Judio ta pigaw nin magkamain sara nin byay a iti kona.” ");
INSERT INTO smkNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Saray mammemper, nitatayak sara anaod bana' sa nikaduksa-duksa' ra nin tinmarana' sin pinati ya si Esteban, ket nipata-patanda' ray maipa'ka' kona ni Jesus bale' konran kapada ra tamo' nin Judio. Main nin nirate' anggan sa prubinsya nin Fenicia, sa isla nin Cyprus tan sa syudad nin Antioquia. ");
INSERT INTO smkNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wanin man, main saray mammemper nin taga Cyprus tan taga Cirene nin nirate' itaw sa Antioquia, nin nipatandaan ra konran ambo' nin Judio a maipa'ka' kona ni Uunuren nin Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sa nipangipata-patanda' ra, iti a pakayadi' nan Dios konra ket abaw saray nagmatalek tan tinmulok konan Uunuren. ");
INSERT INTO smkNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Say maipa'ka' sa sayti ket nakarate' sa pakatanda' nan dupong ran mammemper itaw sa Jerusalem, ket nibaki' rayadtaw sa Antioquia si Bernabe. ");
INSERT INTO smkNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sin rinmate' yadtaw si Bernabe, na'kit na a alakin mabistan man-gaw'en nan Dios konran saraytaw nin tutawo, ket maririket ya nin tuloy. Ket binibilin nasara nga'min nin dumaer sara sa katutulok ra konan Uunuren nin napasaya a nakem ra. ");
INSERT INTO smkNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Siti si Bernabe, maong yan tawo, peteg a mampag'urayan nayan Ispirito nan Dios tan magsen a pagmamatalek na konan Dios. Kanya' nin abaw saray namper kona nin Uunuren. ");
INSERT INTO smkNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kaaram nako ya sa Tarso si Bernabe ta pigaw nin keen naya nin tikapen si Saulo. ");
INSERT INTO smkNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ket sin nadumog naya, ni'ras nayadtaw sa Antioquia. Sayay taon a nikikala-kalamo' sara konran mammemper kona ni Jesus itaw, tan nangyakay sara nin abaw nin tutawo. Itaw sa Antioquia sara nin nu'nan tinawag nin “Cristiano” a tumutumbok konan Cristo. ");
INSERT INTO smkNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sin sain nin panaon, main saraytaw saray prupita nan Dios nin rinmate' itaw sa Antioquia a ibat sara sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Saya ya konra si Agabo. Sin ni'sa a nididinep saray mammemper, inumdeng ya si Agabo sa adapan ra tan bana' sa nipaninreg nan Ispirito nan Dios, nipadles na a magkamain nin bitil sa intiron sakop nin pag'urayan nan Roma. Ket natukid in anaod sin si Claudio a Impirador sa Roma. ");
INSERT INTO smkNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Konan siin, nipapasaya saray tumutumbok kona ni Jesus itaw sa Antioquia a mama'wit saran tulong konran saray mumaidap itaw sa Judea, ket, say barang saya nami nin tulong sigon sa pakababa' na nin mami. ");
INSERT INTO smkNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ginwa' ra anaod in mi'sa ra nin nipa'wit a tulong ra konra ni Bernabe tan Saulo nin iparisibi ra konran pupangulo ran mammemper itaw. ");
INSERT INTO smkNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sin sain nin panaon, manduksa'-duksaen nasara ni Adi' Herodes a raruma konran mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nipaputulan naya nin ulo si Santiago a busat na ni Juan. ");
INSERT INTO smkNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sin na'kit na ni Herodes a mayi saran nakem a Judio sa ginwa' na, nipadakep naya et si Pedro. (Nangyadi' ti sin pista ran Judio nin mantawagen nin Pistan Pangangan nin Tinapay a Kasan Pammakbo.) ");
INSERT INTO smkNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Sin nadakep yayna si Pedro, nipapriso naya. Nipagwardyawan naya sa a'pat a grupo nin sundalo' nin sippa'pat a barang grupo tan misusubray sara. Niplano na ni Herodes nin sintinsyawan naya li' si Pedro sa adapan ra nin Judio no mayadi' a pista nin mantawagen nin Pistan Nipanglabas. ");
INSERT INTO smkNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kanya' nin itaw yan napriso anaod si Pedro. Ket sarba ran mammemper, wanin ana a suet nin kadadasal ra para kona! ");
INSERT INTO smkNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sin yabi nin sintinsyawan nayayna ni Herodes si Pedro, na'lek ya si Pedro sa butlay ra nin rway gwardya a naikadina ya konra. Sakalako sara et a mampaggwardya sa purta nan kwarto nan priswan. ");
INSERT INTO smkNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kapingmatan, main ana nin anghil nan Dios itaw sa luob nin silid nan priswan tan pinasya nin palaway. Tinapok naya si Pedro ta pigaw nin pukawen naya. Wana kona, “Mibangon ka! Madali' ka!” Sin sain a lamang ket naglat a kadina sa gamet na ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wana et nin anghil kona, “Mibuknol ka tan misandalyas ka.” Ginwa' na in ni Pedro. Wana anamanaet nin anghil, “Mikapa ka tan mayi ka kongko.” ");
INSERT INTO smkNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tinmumbok yan linumwa' sa silda si Pedro. Kai na nin tanda' nin mampangyadi' ti nin peteg yupa' sa tulong nan anghil ta man'isipen nan mampanaynep ya tamo'. ");
INSERT INTO smkNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Linabasan rayay primiron pwisto ran gwardya, mi'sa si ikarwa ket nirate' sara sa purtan pasak a sada' na a siti mamunta ya sa syudad. Niabri yan bukod a purta ket linumwa' sara. Sin itaw saraynan manlumalako sa sayay dalan sa syudad, bigra' yaynan nakasa a anghil ket bukod nayna ni Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Naimunawan ya si Pedro ket napipigaw na a ambo' tamo' nin taynep a sarba. Wana, “Sigurado ako nin nibaki' nayan Dios a anghil na ta pigaw nin isalba nako sa gamet na ni Herodes tan sa kadukaan a rabay ran mangyadi' kongko nin saray raruman Judio.” ");
INSERT INTO smkNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sin napipigaw nayna a nangyadi', nako ya sa bali na ni Maria nin ina na ni Juan a mantawagen et nin Marcos. Sin sain, abaw sara a iti konan sitin bali a mammemper nin mandumasal. ");
INSERT INTO smkNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tinmuktok ya si Pedro sa purta ket nako ya nin kinmikit a sayay alila' nin babayi a say ngaran na Roda. ");
INSERT INTO smkNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Naalilbi' nay busis na ni Pedro ket bana' sa alakin ririket na, kai naya nin inabryan a purta no kai edet, nalayo ya nin sinmubli' sa bali tan nibarita' nan itaw ya sa rikor si Pedro. ");
INSERT INTO smkNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ket, “Mangkumalawakaw ka!” wanra kona. Bale' nipase'se' nan si Pedro nin page' a itaw kanya' nin wanra bale' kona, “Si anghil nin gwardya na angangko in.” ");
INSERT INTO smkNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Si Pedro anamaet, tuktok yayna nin tuktok sa purta. Naka'ngap saran maong sin inabryan raya ta si Pedro nin page'. ");
INSERT INTO smkNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininyasan nasaran mititinek ket inisturya na konra no pa'no naya nin niliwa' sa priswan nin Catawan. Nibibilin na konra, “Ibarita' moyoyti anamaet kona ni Santiago tan konran raruman bubsat nin mammemper.” Mi'sa, nibwat yadtaw tan nako ya sa raruma nin lugar. ");
INSERT INTO smkNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kabuklasan, nagulo saran maong a gwardya maipa'ka' kona ni Pedro, no ani kadi' a nangyadi' kona. ");
INSERT INTO smkNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nipakrap naya ni Herodes bale' kai raya nin nadumog. Inimbistiga nasara a gwardya mi'sa nasara nin nipapati. Mi'sa, nibwat yadtaw sa Judea tan nako ya sa Cesarea, ket itaw yayna. ");
INSERT INTO smkNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sin sain, masager yan tuloy si Adi' Herodes konran tutawo sa syudad nin Tiro tan Sidon. Ket say ginwa' ra, nipapasaya sara nin nako kona. Inamigo raya yapo' bale' a ingkargado sa palasyo a si Blasto tan nipalalamo' sara nin mako nin kituno konan Adi'. Ginwa' ra in bana' ta sa lugar nin sakop nin pag'adian na nin mangibwat a ikabyay ra. ");
INSERT INTO smkNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nangitanda' yan awro nin piaadap ra a adi'. Sin narate' ya in nin awro, nisulot yan seket na bilang sayay adi' tan tinmekre' ya sa truno na mi'sa ya nin nagdiskurso konran tutawo. ");
INSERT INTO smkNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rinayo rayan tutawo ket wanra nin nita'wa-ta'way, “Ambo' in nin irgo nin sayay tawo tamo' no kai nin sayay dios.” ");
INSERT INTO smkNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Konan sitaw nin lamang, pinagmasakit naya nin anghil nan Dios si Herodes bana' ta say lalaman nan diri a nipasirayo na konran tutawo, ambo' yay Dios. Inurer a lalaman na ket siin anay nipati na. ");
INSERT INTO smkNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ana edet, sin sain, say minsahi nin nangibwat konan Dios, naitayak anan naitayak, ket inmabaw saraynan inmabaw a mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ket sin nagwa' raynay nipagwa' itaw konra, sinmubli' sarayna si Saulo tan si Bernabe sa Antioquia nin ibat sa Jerusalem, tan ni'ras raya si Juan a mantawagen et nin Marcos. ");
INSERT INTO smkNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sawanin, sa dupong ran mammemper itaw sa Antioquia, main saray prupita tan mangangakay nin minsahi nan Dios, bilang si Bernabe, si Simeon a say purarag na Negro, si Lucio a taga Cirene, si Manaen a kaanak-anakan tan kalamo' nan inmalaki sa palasyo na ni Gubirnador Herodes Antipas, tan si Saulo. ");
INSERT INTO smkNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ni'sa, leg'an a mampangrayo sara konan Dios ket mampagkulasyon sara, si Ispirito nan Dios wana konra, “Ipurok moyo sara si Bernabe tan Saulo para sa trabaho nin nangigagarawan ko konra.” ");
INSERT INTO smkNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ket, sin nayadi' sarayna nin nagkulasyon tan dinmasal para konra, nipababo ray gamet ra konra ni Bernabe tan Saulo, mi'sa rasarayna nin pinaibwat nin mako para konan sitin trabaho. ");
INSERT INTO smkNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ket, sawanin, bana' ta nibaki' nasaran Ispirito nan Dios si Bernabe tan si Saulo, nako sarayna, itaw yapo' sa Seleucia. Mi'sa nangibwat itaw sinmaki saran nako sa isla nin Cyprus. ");
INSERT INTO smkNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dinmuong sara sa syudad nin Salamina tan nipata-patanda' ray minsahi nin nangibwat konan Dios sa bubali nin pangraywan ran Judio konan Dios a mantawagen nin sinaguga. Kalamo' rayan katulungan ra si Juan Marcos. ");
INSERT INTO smkNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kina' ra a sarban lugar itaw sa isla angga sin nirate' sara sa babali nin Pafos. Itaw nadumog rayay sayay Judio nin maong nin magmadyik tan man'ibarita' nan prupita nayan Dios, bale' siin ket bula'. Say ngaran na Bar-Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo nayan siti a gubirnador sa isla a say ngaran na Sergio Paulo, a saya nin intilihinti nin tawo. Siti si gubirnador, nipakayaban nasara si Bernabe tan Saulo ta rabay nan marnge' a minsahi a nangibwat konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bale' sitaw si magmamadyik a si Elimas (ngaran nayayti ni Bar-Jesus sa sarita' nin Griego), ginwa' nay magwa' nan pammaed nin mamper yay gubirnador. ");
INSERT INTO smkNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bale' sin sain, si Ispirito nan Dios, liso nayan nag'urayan si Saulo a mantawagen a lamang nin Pablo. Pinastang nayan maong ni Pablo a magmamadyik, ");
INSERT INTO smkNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mi'sa wana kona, “Si'ka, Dimunyo ka! Kuntrawen mo a sarba nin mapteg. Napno' ka nin saor tan kadukaan! Kai mo nin mantegnan nin tursye-tursyen a katutu'wan maipa'ka' konan Cristo, a mampaliwaen mon bula'-bula'! ");
INSERT INTO smkNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sawanin dusawen nakaynan Uunuren! Mabulag ka nin kai ka gapo yapo' nin makapadi'rap.” Ket tampor madedlem ana a ka'kitan na ni Elimas tan kai yayna gapo nin maka'kit ket kara-karapas yayna nin naningkap nin manabin kona. ");
INSERT INTO smkNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Naimatunan nan gubirnador a nangyadi' ket nagmatalek yayna kona ni Uunuren nin Jesus. Naka'ngapan nan maong a akay nin maipa'ka' kona. ");
INSERT INTO smkNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ket si Pablo tan saray kalalamo' na, nibwat sara ana sa Pafos. Sinmaki sara nin nako sa syudad nin Perga sa prubinsyan Pamfilia. Itaw linakwanan nasara ni Juan Marcos tan sinmubli' yayna sa Jerusalem. ");
INSERT INTO smkNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nangibwat sa Perga, tinmuloy sara sa Antioquia a sakop nin prubinsyan Pisidia. Ket sin narate' a Awron Painawa, nako sara nin nangrayo konan Dios sa sinagugadtaw. ");
INSERT INTO smkNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kayadi' a main nin namasa sa Libron Gugan-gan nin nisurat na ni Moises tan sa nisurat ra nin prupita, saray pupangulo sa sinaguga, nipaibarita' ra konra ni Pablo a no main nin maibarita' ra nin makapamagsen nin pammemper ran tutawo, magwa' ra a mag'irgo. ");
INSERT INTO smkNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Inumdeng ya si Pablo tan sininyasan nasaran mititinek a tutawo. Nag'irgo ya a wana, “Si'kamon kapada kon Israelita tan si'kamon ambo' nin Judio nin mampangrayo konan Dios, mangrenge' kamo sa ibarita' ko. ");
INSERT INTO smkNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Si Dios nin manraywen tamo nin si'tamon Israelita, pinili' nasaray pupuon tamo tan pinaabaw nasara sin itaw sara nin mampiikap sa ambo' ran diri nin nasyon a sa Egipto. Ket, sa alaki nin pakayadi' na, nilakwan nasaradtaw. ");
INSERT INTO smkNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ket sa luob nin mag'a'pat a pulo' a taon, inanusan nay pigagawa' ra sin itaw sara sa lugar a kasan tawo. ");
INSERT INTO smkNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nipatalo na konran pupuon tamo a pito ra nin nunasyon sa Canaan tan nipaikon nan lamang in nin nunasyon konra. ");
INSERT INTO smkNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nangyadi' in nga'min sa luob nin a'pat a yasot tan limampulo' a taon. Mayadi' a wanin, namili' yayna a Dios nin saray mangipangulo konra a say tawag konra ket mangngukom, angga sin panaon na ni Prupita Samuel. ");
INSERT INTO smkNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sin sain a panaon, dinawat ra konan Dios a byan nasara nin adi' a mag'uray konra ket bana' ta wanin, pinili' naya nin Dios si Saulo nin anak na ni Cis a puri na ni Benjamin. Adi' raya si Saulo sa luob nin a'pat a pulo' a taon. ");
INSERT INTO smkNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ket sin ginlat nayan adi' nin Dios, nisili naya si David. Siti a wana nin Dios maipa'ka' kona ni David, ‘Siti si David nin anak na ni Jesse, tawo yayti nin makapaririket kongko. Gaw'en na a sarba nin rabay ko.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nituloy na ni Pedro, “Ket saya konran puri na ni Adi' nin David a nibaki' na nin Dios nin mangisalba kontamo nin puri na ni Israel nin bilang sa nipangako' na. Sya, si Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ba'yo na nin nitarana' a gawa' na ni Jesus, si Juan, nipata-patanda' na konran sarba radtaw sa Israel a pagbabawian raynay kukasalanan ra, mi'sa sara nin pabawtismo. ");
INSERT INTO smkNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ket sin dandani nayna nin ila'pos ni Juan a gawa' na wana konran tutawo, ‘Man'ipa'ka' moyo angangko a si'ko yaynaytaw si mantaga'nan moyon rumate'. Kai, ambo' ako! Bale' main li' nin rumate' nin makapangyayadi' yan tuloy nin adayo' dyan si'ko, ket ni magsirbin manglat nin sandalyas na, kai ako gapo nin maikana'.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Wana anamana ni Pablo, “Bubsat, si'kamo nin Judio nin kapada ko nin puri na ni Abraham tan si'kamo nin ambo' nin Judio nin mampangrayo konan Dios, man'ipatandaan nayan pari-pariho kontamo nin Dios a Mabistan Patanda' no pa'no atamo nin maisalba. ");
INSERT INTO smkNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Saray tutawodtaw sa Jerusalem tan saray pupangulo ra, kai ra nin naalilbi' a si Jesus a Mangingisalba, tan kai ra nin tinarusan a nipadles ran saray prupita a sayti ket binasa-basa konra tepe' nin Awron Painawa no mangrayo sara konan Dios. Ket sa nipangipapati ra kona ni Jesus, natukid rayti a nipadles ran prupita. ");
INSERT INTO smkNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mataman no kai ra nin napatutu'wan a main nin kasalanan na nin nepeg nan pakadusawan nin patiti, dinawat ra et kona ni Gubirnador Pilato a ipapati naya. ");
INSERT INTO smkNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sin natukid ana nga'min a sarba nin nipadles nin gaw'en kona ni Jesus, nikayupa' rayay bangkay na sa kudos nin nangipasakan ra kona mi'sa raya nin nitabon. ");
INSERT INTO smkNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bale' si Dios, pinasubli' naya nin mabyay. ");
INSERT INTO smkNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ket sin sinmubli' yayna nin mabyay, sa luob nin umnoy awro, nipa'ki-pa'kit ya konran saraytaw saray nayi kona sin saytaw sa Jerusalem nin nangibwat sa Galilea. Sawanin, saray naka'ki-ka'kit kona, man'ibari-barita' ray maipa'ka' kona konran Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ket si'kami anamaet, iti kami komoyo nin ipatandaan miya a Mabistan Patanda' maipa'ka' sa ginwa' na nin Dios sawanin a syay nipangako' na konran saray pupuon tamo. ");
INSERT INTO smkNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tinukid nay pangako' na kontamon pupuri ra sin pinasubli' naya nin mabyay si Jesus. Sain a pipa'kaan nin sitaw si wana nin Dios maipa'ka' kona ni Jesus a naisurat sa Ikarwan Kanta a wana, ‘Si'ka, anak kata. O', sawanin, pina'get koy nipanuyo' ko komo.’ ");
INSERT INTO smkNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Main ti et e nin naisurat nin maipa'ka' sa pammasubli' nan mabyay nin Dios kona ni Jesus tan say kai na nin pangiyaburoy a maumok a lalaman na ni Jesus sa nanabunan. Wana, ‘Ibi ko komoyo nin sigurado a masagrado nin bubagay nin nipangako' ko kona ni David.’ ");
INSERT INTO smkNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Main yayti et e nin nipadles na ni David nin maipa'ka' kona ni Jesus, a wana, ‘Kai mo nin iyaburoy a maumok yay lalaman nan ibabaki' mon tutuo komo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nituloy na ni Pablo, “Bubsat, ambo' anaod nin si Adi' nin David a mantukuyen isen ta tanda' tamo a sin nayadi' nayna nin ginwa' ni Adi' nin David a nipagwa' nan Dios kona, nati yayna. Nitabon raya sa nanabunan konran pupuon na ket naumok a lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bale' si Jesus, a pinasubli' naya nin mabyay nin Dios, kai ya nin naumok a lalaman na. ");
INSERT INTO smkNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Reng'en moyo! Wanti a man'ipatanda' mi komoyo: Yupa' sa ginwa' na ni Jesus, mapirdunayna a kasalanan. ");
INSERT INTO smkNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Anaod, bana' sa ginwa' na ni Jesus, nikwintan kai nin nagkasalanan a si'numan nin mampagmatalek kona. Sain nin kapapa'sar ket kai nin mapamain nin panunumbok tamo nin nagsikabarang nin gugan-gan a naipudir kona ni Moises. ");
INSERT INTO smkNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Anaod, pakatalad kamo a kai nin mangyadi' komoyoyti nin naisurat a nipadles ra sin saytaw nin prupita a wana, ");
INSERT INTO smkNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kiten moyoy gaw'en ko, si'kamon kai nin mangimbabaet sa Sarita' na nin Dios! Maka'ngap kamo ket bale' mati kamo ta kai moyo nin tepren in nin gaw'en ko sawanin leg'an a mabyay kamo et mataman no main nin mangibari-barita' komoyo.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sawanin, sin manlumiwa' sarayna sa sinaguga ran Judio si Pablo tan si Bernabe, dinawat ran tutawo konra a sumubli' sara li' no sumunor a Awron Painawa ta pigaw nin mag'irgo sara li' anamana maipa'ka' sa saytaw sa nibari-barita' ra. ");
INSERT INTO smkNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ket, sin mampibwat saraynay tutawo, abaw saray Judio tan ambo' nin Judio nin na'wit ana nin peteg sa rilihyon ran Judio a naayat nin kikalamo' konra ni Pablo tan si Bernabe. Ket sarayti, binari-baritaan rasara ni Pablo tan Bernabe nin ituluy-tuloy ra a magmatalek sa kamaungan nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Anaod, sin sumunor a Awron Painawa, dandani sarba ran tutawodtaw sa babali nin Antioquia ket nako nin nangrenge' sa minsahi a nangibwat konan Catawan. ");
INSERT INTO smkNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bale', sin na'kit rasara nin Judio a abaw nin tutawo nin nako nangrenge', pinasya nin imbel ra ket kinuntra-kuntra ray nibarita' na ni Pablo tan nag'irgu-irgo saran paninida' kona. ");
INSERT INTO smkNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wanin man, matpel sara lawas nin mag'irgo si Pablo tan Bernabe ket wanra, “Komoyo nin kapada kon Judio nin matkap nin mu'nan ipatanda' ti say a minsahi a nangibwat konan Dios. Ket bana' ta andi' kamo nin akuen ti, mansintinsyawan moyoy lalaman moyon diri nin kai nin maikana' nin manga'mor nin anggan-angga nin byay a iti konan Dios. Sawanin anaod, konran ambo' nin Judio mi ana nin ipatanda' ");
INSERT INTO smkNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ta siti nin bibilin nan Dios ket para ya anamaet komi. Wana, ‘Nigagara kata nin mag'in nin pa'sar palaway para konran ambo' nin Judio ta ibaki' kata nin ika' mo nin ipatanda' konran sarban tutawo a maisalba kosara.’ ” ");
INSERT INTO smkNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sin narnge' ra in nin saray ambo' nin Judio, pinasyan ririket ra tan nikisalamatan ray minsahi a nangibwat konan Dios. Ket sarba ran saraytaw saray nitalaga nan Dios nin magkamain nin anggan-angga nin byay a iti kona, nagmatalek sara kona. ");
INSERT INTO smkNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ket naitayak a minsahi nin nangibwat konan Catawan sa intiro nan sitaw a lugar. ");
INSERT INTO smkNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bale' sinugsog rasara nin Judio a impurtantin bubbayi nin mampangrayo konan Dios tan saray lulalaki nin ata'gay a pangingikit konra, a masager sara konra ni Pablo tan Bernabe ket mapalakwan rasaradtaw. ");
INSERT INTO smkNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sin wanin, pinagpag ra ni Pablo tan Bernabe a ta'pok sa ayi ra nin mangipa'kit a kai nasaraytaw nin inako' nin Dios a tutawo, mi'sa sara nin nibwat nin nako sa babali nin Iconio. ");
INSERT INTO smkNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Sara anamaet a tumutumbok kona ni Jesus itaw sa Antioquia, napno' sara nin ririket tan peteg a nag'urayan nasara nin Ispirito nan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Sin itaw sara anamaet si Pablo tan Bernabe sa Iconio, naku-nako saran lamang nin nangyakay sa sinaguga ran Judio. Ket sa mabistan pangingipapalaway ra sa minsahi nan Dios, abaw saray Judio tan ambo' nin Judio nin nagmatalek konan Cristo. ");
INSERT INTO smkNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bale' saraytaw saray Judio nin kai nin mamper kona ni Jesus, sinugsog rasaray ambo' nin Judio nin itaw sa babali ta pigaw nin masager sara konran mammemper. ");
INSERT INTO smkNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ket itaw sara yapo' nin midyo nin na'teng sa Iconio si Pablo tan si Bernabe ta matpel sara nin nangipata-patanda' maipa'ka' sa ginwa' nan Dios. Ket si Dios binyan nasaran pakayadi' nin makapangwa' nin makapaka'ngap a pammatutuo sa man'ipatanda' ra nin kamaungan na. ");
INSERT INTO smkNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ket natao saray tutawodtaw sa Iconio. Saray umno ra, ayon sara konran apostoles a si Pablo tan si Bernabe; saray raruma anamaet, ayon sara konran Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Konan siin, saray Judio tan saray ambo' nin Judio, a kalamo' rasaray mampag'uray konra, nag'iirgwan ra a sasakiten tan patyen rasaran kudasen nin bato si Pablo tan si Bernabe. ");
INSERT INTO smkNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Natandaan ra ni Pablo in nin plano ra kanya' nin nalayo sara nin nako sa syudad nin Listra tan Derbe tan sa kukabaraybay nin lugar sa prubinsya nin Licaonia. ");
INSERT INTO smkNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Sa sayti nin lulugar, nipata-patanda' rayay Mabistan Patanda'. ");
INSERT INTO smkNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sin itaw sara nin mampangipata-patanda' sa Listra, main itaw nin lalaki nin lupoy nangibwat et sin niyanak ya ket kai ya gapo nin makalalako. Nakatekre' ya, ");
INSERT INTO smkNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","nangrenge' ya kona ni Pablo. Pinastang nayan maong ni Pablo tan na'kit na a mampagmatalek yayti nin tawo a mapaanda' ya, ");
INSERT INTO smkNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ket nipaksaw nay busis na a wana kona, “Umdeng ka nin matu'rir!” Ket tampor inumdeng ya tan linmala-lalako ya. ");
INSERT INTO smkNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sin na'kit ra nin tutawo a nagwaan na ni Pablo, wanra nin nita'way sa irgo ra nin Licaonia, “Nanaoy saradti a dios tan nirupa saran tawo!” ");
INSERT INTO smkNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tinawag rayan Zeus si Bernabe a syay pangulo nin dios-dios ra tan tinawag raya anamaet nin Hermes si Pablo a syay ibabaki' nin dios-dios ra bana' ta sya a mag'iirgo. ");
INSERT INTO smkNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Main nin timplo nin pangraywan ra konan dios-dios ra nin si Zeus sa kaliwa' tamo' nin syudad. Sin sain, si padi' nin mampagsirbi kona ni Zeus, nangawit ya nin bubaka tan kwintas nin buburak itaw sa purta nin timplo ta pigaw nin ida'ton na tan saray tutawo nin ipangrayo ra konra ni Pablo. ");
INSERT INTO smkNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sin natandaan ran saraytin apostoles nin wanin a gaw'en ra nin tutawo, binisang ray seket ra nin mangipa'kit a kai sara nin kumpurmi sa sain a gaw'en ra. Mi'sa sara nin nalayo nin nako sa butlay ra nin tutawo tan wanran nag'irgo nin maksaw, ");
INSERT INTO smkNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Uamigo, andi' rakami nin raywen nin bilang dios! Tawo kami tamo' nin kapada moyo! Nako kamidti komoyo ta pigaw nin ipatanda' miyay Mabistan Patanda' maipa'ka' kona ni Jesus ket tumgen kamoynan mangrayo konran sarain a kasan magwaan nin dios-dios ket si raywen moyoyna si sibibyay a Dios. Sya a namarsa nin langit tan luta', pati say taaw tan say sarba nin main sa sayti. ");
INSERT INTO smkNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sa linmabas nin panaon, inaburuyan nakamo nin Dios a si'kamon ambo' nan tutawo ket gaw'en moyoy bungat ana nin rabay moyo. ");
INSERT INTO smkNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wanin man, man'ipatandaan na komoyo no si'no ya ta man-gaw'en nay no ani a maabig para komoyo. Mambyan nakamo nin rapeg tan mumula a no marate' a kuston panaon ket pabungawen na ta pigaw nin main nin kanen moyo tan ta pigaw nin maririket kamo.” ");
INSERT INTO smkNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bale' abirno nin wanin a nibarita' ra ni Pablo, napaidap sara nin namaed konran tutawo sa pangrarayo konra. ");
INSERT INTO smkNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bale' main nin rinmate' itaw nin Judio nin ibat sa Antioquia sa prubinsya nin Pisidia tan saray raruma sa Iconio. Nasagyat rasaray tutawo nin mag'in nin kuntra kona ni Pablo, ket kinudas-kudas raya nin bato si Pablo mi'sa raya nin ginuruy-guroy nin nirikor itaw sa syudad nin Listra sin say wanra ket nati yayna. ");
INSERT INTO smkNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bale' sin inaribungbungan raya nin saray tumutumbok kona ni Jesus, nibangon ya tan sinmubli' ya sa syudad. Ket sin sinmunor nin awro, nako sara ni Bernabe sa syudad nin Derbe. ");
INSERT INTO smkNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nipata-patanda' raya ni Pablo tan Bernabe a Mabistan Patanda' itaw sa Derbe ket abaw saray nasagyat ran nag'in nin tumutumbok kona ni Jesus. Mi'sa sara nin sinmubli' sa Listra, mi'sa sa Iconio, angga et sa Antioquia sa prubinsyan Pisidia. ");
INSERT INTO smkNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinaksaw ra a nakem ran saray tumutumbok kona ni Jesus nin itaw sa sain nin lugar tan binibilin rasara nin dumaer sara sa pammemper konan Cristo. Nibarita' ra et a matkap nin dumalan atamo sa abaw nin dya'dya' ba'yo natamo nin aburuyan nin Dios nin kipag'adi' kona. ");
INSERT INTO smkNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ket sa barang saya nin dupong ra nin mammemper, nanuyo' saran pupangulo si Pablo tan si Bernabe. Ket sin nidasal-dasalan rasara leleg nin nagkulasyon sara, nitalek rasaray mammemper konan Uunuren a syayna a mampagmatalkan ra. ");
INSERT INTO smkNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dinmalan sara sa prubinsyan Pisidia ket nirate' sara si Pablo sa prubinsyan Pamfilia. ");
INSERT INTO smkNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ket itaw nipatanda' ray minsahi na nin Dios sa babali nin Perga, mi'sa sara nin nako sa babali nin Atalia. ");
INSERT INTO smkNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nangibwat itaw, sinmaki saran sinmubli' ana sa Antioquia sa prubinsya nin Siria. Itaw sin saytaw ket nidasalan rasara nin saray mammemper a sapa kumon ket antabayan nasara nin Dios sa pangngawa' ra nin trabaho nin nibi na konra a sawanin ket naila'pos rayna. ");
INSERT INTO smkNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sin rinmate' saraynadtaw si Pablo tan Bernabe sa Antioquia, dininep rasara nga'min a mammemper itaw, tan nibarita' ra nga'min konra a ginwa-ginwa' nan Dios nin pakikalamo' na konra tan say nibi nan Dios nin pagkanawanawa ta pigaw nin saray ambo' nin Judio ket magmatalek sara anamaet kona. ");
INSERT INTO smkNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ket itaw sara nin na'teng sa Antioquia a kalamo' rasara a tumutumbok kona ni Jesus. ");
INSERT INTO smkNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sin sain, main nin tutawo nin rinmate' itaw sa Antioquia a ibat sa Judea ket mampangyakay sara anamaet konran mammemper. Wanran sarayti konran mammemper, “Kai kamo nin maisalba no kai kamo nin paturi' nin bilang sa wana nin gan-gan nin naipudir kona ni Moises.” ");
INSERT INTO smkNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kai sara nin nikikumpurmi si Pablo tan Bernabe sa sain nin akay ra ket nag'in nin ma'mot a pididiskusyon ra. Sin wanin, saray mammemper itaw sa Antioquia, nipapasayawan ra a sara si Pablo tan si Bernabe nin kalalamo' rasaray raruman mammemper ket, mako sara sa Jerusalem nin keen ra nin tandaen a disisyon ran apostoles tan saray pupangulo ran mammemper maipa'ka' sa nididiskusyunan radtaw sa Antioquia. ");
INSERT INTO smkNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sin sain anaod, pinaibwat nasara nin dupong ran mammemper itaw si Pablo. Itaw sara nin dinmalan sa prubinsya nin Fenicia tan Samaria, ket nibari-barita' ra konran mammemper itaw a saray abaw nin ambo' nin Judio ket mampagmatalek sara anamaet ana sawanin konan Dios. Ket saray mammemper, maririket saran tuloy sa sain a narnge' ra. ");
INSERT INTO smkNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sin rinmate' sara sa Jerusalem si Pablo, maririket rasara nin inako' nin dupong ran mammemper itaw tan saray pupangulo ra, tan saray raruma nin apostoles. Inisturya ra ni Pablo konra a sarba nin ginwa-ginwa' nan Dios nin pakikalamo' na konra. ");
INSERT INTO smkNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bale' main nin mammemper itaw nin myimbro sara nin grupo ran Pariseo a ipasuet ra nin matkap saran paturi' a mammemper a ambo' nin Judio tan matkap a tukiden ra a raruma et nin gugan-gan a naipudir kona ni Moises. ");
INSERT INTO smkNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Konan siin anaod, nagmiting saray apostoles tan saray pupangulo ra nin mammemper ta nag'irgwan ray maipa'ka' sa sain. ");
INSERT INTO smkNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Na'teng sara nin nag'iirgo, ket kayadi', inumdeng ya si Pedro tan wana, “Bubsat, pitanda-tanda' moyo a sin anron panaon ana a linmabas, pinili' nako nin Dios nangibwat kontamo nin ipatandaan koya konran ambo' nin Judio a Mabistan Patanda' maipa'ka' kona ni Jesus, ta pigaw nin mamper sara kona nin sya a Cristo. ");
INSERT INTO smkNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ket, si Dios a tanda' na a sarban iti sa kanakman ra nin tutawo, nipa'kit na a mataman nin saray ambo' nin Judio, akuen nasara ta nibaki' nayan miikap konra a Ispirito na kapada nin nibaki' naya kontamo. ");
INSERT INTO smkNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Konan Dios, kasan pidumawan tamon Judio tan saran ambo' nin Judio ta bana' ta nagmatalek sara kona ni Jesus, rininggasan nasara sa kasalanan ra kapada nin pangriringgas na kontamo. ");
INSERT INTO smkNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sawanin, mayin a man'ikwa moya sa sayan panunubok a Dios bana' sa pammatukid moyo konran tumutumbok kona ni Jesus nin sain say gugan-gan nin pinasyan idap nin tukiden? Ni saray pupuon tamo, mataman et si'tamo, ket kai nin makatukid. ");
INSERT INTO smkNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ambo' nin manepeg a wanin! Tepren tamo a naisalba atamo bana' sa kamaungan na ni Uunuren tamon Jesus kontamo. Ket isalba nasaran lamang anamaet nin Dios a ambo' nin Judio sa wanin nin padalan.” ");
INSERT INTO smkNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kasa gapo nin inumbat kona ni Pedro sin nayadi' na nin nibarita' in, no kai nangrenge' sara tana konra ni Pablo tan Bernabe sa isturya ra maipa'ka' sa makapaka'ngap nin pupaka'kitan nin pakayadi' nan Dios a ginwa-ginwa' na yupa' konra sin mampangipata-patanda' sara konran ambo' nin Judio. ");
INSERT INTO smkNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ket sin nayadi' sarayna nin nag'irgo, si Santiago anamaet a nag'irgo nin wana, “Bubsat, reng'en moyoy ibarita' ko komoyo. ");
INSERT INTO smkNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nairgo nayna komoyo ni Simon Pedro no pa'no na nu'nan nipa'kit nin Dios a inganga'do na konran saray ambo' nin Judio ta pigaw nin main anamaet konra a mag'in nin tutawo nan diri. ");
INSERT INTO smkNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nangyadi' in anaod nin tumekep sa wanan nisurat ra nin prupita nan Dios nin mabasa sa Masanton Kasuratan. Wana, ");
INSERT INTO smkNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mayadi' in, wana nin Catawan, sumubli' ako li' ta pigaw nin pa'dengen ko anamana a nasida' nin pag'adian na ni David. Pakandaen koy nasida' tan ipalasta koya ");
INSERT INTO smkNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ta pigaw nin sarba ra nin raruma nin Judio ket dumugen rako, ta saray ambo' nin Judio, ket sinagyat kosara anamaet nin mag'in nin tutawo ko. ");
INSERT INTO smkNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wanin a irgo na nin Catawan nin nipatarusan anan na'teng sin saytaw et.’ ");
INSERT INTO smkNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Edet,” wanan nituloy ni Santiago, “say ibarita' ko komoyo ket, andi' tamo sara nin pabyatan a ambo' nin Judio nin mampagmatalek konan Dios. ");
INSERT INTO smkNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Say gaw'en tamo ket si manurat atamo konra nin ibarita' tamo a andi' sara nin mangan nin say maiyawa' nin kanen a sayti ket nida'ton nin ipangrayo sa dios-dios, tan andi' ra nin sama'-samaen a lalaman ra yupa' sa ambo' nin manepeg a pirararay. Andi' sara et nin mangan nin daya' tan nin karni nin pinatin ayep a kai nin pinadaya'. ");
INSERT INTO smkNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Wanin a dawaten tamo ta say gugan-gan nin nipagamet kona ni Moises ket na'teng anan tuloy a panaon nin mambasawen sa susinaguga tepe' nin Awron Painawa tan man'iyakay sa sarba nin lugar.” ");
INSERT INTO smkNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ket sin sain anaod, nipapasayawan ra nin saray apostoles, saray pupangulo tan si intiron dupong ran mammemper itaw sa Jerusalem, a mamili' sara nin lulalaki sa grupo ra nin mayi konra ni Pablo tan Bernabe nin sumubli' sa Antioquia. Saray napili' ra ket sara si Judas nin mantawage