﻿USE sofia;
DROP TABLE IF EXISTS sofia.slu_vpl;
CREATE TABLE slu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES slu_vpl WRITE;
INSERT INTO slu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Khyehyeike bonyo Hulasokwe yala laitke kyor lasmyerke. ");
INSERT INTO slu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ti lasmyerke khaha neke lenla kika namit-namit ti, de knani a nggora, ode kelerakokke kkyahat eta tasi malosy-masir ne bo, ode Hulasokwe Memeanke knyem ti de knyem ma ti tasi desy. ");
INSERT INTO slu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","4","Lemadendye Hulasokwe tyanuk ma byu de byohe, “Lemamo kika madelah.” Dendye madelahke kimin. Hulasokwe yatos madelah desyo dyakin, dendye isali madelahke toha kelerakokke. ");
INSERT INTO slu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Lemadendye Hulasokwe yaki madelah desike ti “msarinke” ode kelerakokke ti “metdyetke.” Dendye kika sewah o msarin, neke sew a mamunake desy. ");
INSERT INTO slu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Maktei bonyo Hulasokwe byu huruk de byohe, “Lemamo kusali a wer ne ma kika klelan.” ");
INSERT INTO slu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Lemade Hulasokwe isali wer desy ma mamin ti srake ode mamin ti hahke, desikeo ktela desike kdi ti. ");
INSERT INTO slu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dendye Hulasokwe hyaly a klelan desike ti “laitke.” Lemade kika sewah o msarin, neke sew a enaruke desy. ");
INSERT INTO slu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Maktei bonyo Hulasokwe tyanuk huruk ma byu de byohe, “Lemamo wer mamin ti lasmyerke khaha neke kiwahuk i ti a wenke it, ma kika wen bakbak.” Desikeo ktela desike kdi ti. ");
INSERT INTO slu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Lemadendye Hulasokwe yaki wen bakbak desike ti kani a “rake,” klala wer mawahuk i desike yaki kanike ti a “tasike.” Hulasokwe yatos nam iala desikre mo eras. ");
INSERT INTO slu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Maktei o Hulasokwe byu huruk de byohe, “Lemamo ti lasmyerke khaha neke tnyei o nam nekre ktyuhw ti, ktyabal aw maka kisi o khatu salno salik nekre mumu, mamode kika aw o tnyei ti lasmyerke khaha ne.” Bonyo ktela desike kdi ti huruk. ");
INSERT INTO slu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Lasmyerke khaha neke kbyenw ti aw ksitu mur nekre, ktyabal nam ribun matuhw maka khatu nekre, desikeo Hulasokwe yatos ktela neke mo klyakut eras. ");
INSERT INTO slu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Dendye kika sewah o msarin, neke sew a enatelkwe desy. ");
INSERT INTO slu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Maktei bonyo Hulasokwe byu huruk de byohe, “Lemamo kika nam madelah ti laitke, ma kisali a msarinke kyor metdyetke. Ode nam madelah desikre kyeluk nyatos ma klyosu sew o hul o ain, ode nam madelah desikre kdyelah lasmyerke khahake mumu.” Dendye ktela desike kdi ti kola Hulasokwe itanuk desy. ");
INSERT INTO slu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lemadendye Hulasokwe yala nam madelah lan neke enaru, neke lan lahukke sekwe ma kdyelah a msarinke, klala kakanke neke hulke ma kdyelah metdyetke, ode yala thunare dakun. ");
INSERT INTO slu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Maktei bonyo Hulasokwe tyutuk nam desikre mumu ti laitke ma kdyelah lasmyerke khaha ne mumu, ");
INSERT INTO slu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma kdyelah msarinke o metdyetke ode kisali madelahke toha kelerakokke. Hulasokwe yatos mo eras mumu. ");
INSERT INTO slu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lemade kika sewah o msarin, neke sew a enaatke desy. ");
INSERT INTO slu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Maktei bonyo Hulasokwe itun huruk ma byohe, “Lemamo ti a tasike krala ne heal o ail a rala rti de rala rma, ode manunare o rnem ti de rnem ma ti a sra lait ne.” ");
INSERT INTO slu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mane Hulasokwe yala heal lan de lan nekre rtabal heal ribun salno salik mamorif ti a tasike krala ne, ode yala manu salno salik manem ti a sra lait ne. Hulasokwe yatos nam desikre mo eras. ");
INSERT INTO slu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Lemade Hulasokwe yal eraske ti nam ribun lan nekre mumu ma byohe, “Heal o ail e! Mbyes ma mbyenw tasike krala ne. Ode manu e, mbyes dakun ma mbyenw a lasmyerke khaha ne.” ");
INSERT INTO slu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lemade sewah desike ksyakut ode msarinke kmya, bonyo sew a enasimke desy. ");
INSERT INTO slu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dendye Hulasokwe tyanuk huruk de byohe, “Lemamo lasmyer neke khyetuk a heal salno salik mamorif nekre, neke heal malamy o heal mamaruh o mata mnas nekre.” Dendye ktela desike kdi ti. ");
INSERT INTO slu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ode Hulasokwe iala heal a lan o kakan mamaruh o mata mnas nekre, ode heal malamy ti lasmyerke khaha ne mumu maktei bonyo, Hulasokwe yatos nam ribun desikre o eras. ");
INSERT INTO slu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Maktei bonyo Hulasokwe tyanuk huruk de byohe, “Lemamo taka irire ma rola Ity. Iry nekre ana rhareta heal o ail mamin tasike krala ne, rtabal manu manem ti sra lait ne, ode heal mamaruh o malamy o mata mnas mamin a ra nekre mumu.” ");
INSERT INTO slu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lemade Hulasokwe ika irire ma rola I, neke ika iry a wamwankye ode iry a wamfwetke ma uno matat ne kola Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Maktei bonyo Hulasokwe yal eraske ti a iry deru desy, ode byu ti sir de byohe, “Mika ebnwo anamy ma mmyel ma mbyenw ti lasmyerke khaha ne, ode mhyareta ti nus ne mumu, ma msyeak a heal o ail mamin ti a tasike krala ne, rtabal manu manem ti a sra lait ne, ror heal mamin a lasmyerke khaha ne.” ");
INSERT INTO slu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hulasokwe tyanuk huruk de byohe, “Mtyomolu, ana kal nam matuhw a maka khatu ti lasmyerke ktem ne ode aw ribun a maka kisi o khatu ma kyeluk a kotw ma mi o myenw. ");
INSERT INTO slu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Klala ti a heal mamea nekre mumu, neke heal mamin ti lasmyer ne, ktyabal manu mamin ti sra nekre, ana kal a sitw o tnyei o aw ktahi molmol ribun nekre ma kyeluk a kotw ti sir.” Ode nam desikre kdi ti mumu. ");
INSERT INTO slu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Maktei o Hulasokwe yatos nam iala nekre mumu eras a ksyalik. Lemade sewahke ksyakut ode msarinke kmya, bonyo sew a nemke desy. ");
INSERT INTO slu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Lemadendye Hulasokwe yala laitke ode lasmyerke khaha neke ktyabal kisi o nam nekre mumu maktei de. ");
INSERT INTO slu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ode kyoat kinait sew a itkwe bonyo Hulasokwe lema kyarya. De imres ti sew a itw desy ti karya ikarya desikre. ");
INSERT INTO slu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Lemadendye Hulasokwe yal eraske ti sew a itw desy, ode ihatetak ma byohe, “Senweke sew a asuskye ne.” Kali ti sew desike Hulasokwe imres ti wasi karya iala desikre mumu. ");
INSERT INTO slu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Lemadendye tkunw a Hulasokwe iala laitke ode lasmyer neke teike desy de. Kyoat Hulasow YANWE iala lasmyer ne ode laitke, ");
INSERT INTO slu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","lenla kika sitw o tnyei o aw a matuhw ti lasmyerke khaha ne, kali Hulasow YANWE lenla nyauk uske ei lasmyerke khaha ne, ode lenla kika iry ma rseak ti a lasmyerke khaha ne dakun. ");
INSERT INTO slu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Keskyede yekwe kbyetik kyosy lasmyerke khaha ne ma ksyai ei srake, ma ktyubw lasmyerke khaha ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ode kyoat desikeo Hulasow YANWE yala irkye waltwanke toha rayahkwe. Maktei bonyo yohw memeanke ti iry desike nurake kralake, dendye iry desike myorif, ma wamwany a i. ");
INSERT INTO slu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Maktei bonyo Hulasow YANWE yala boke ti wen a Edenke, neke kimin ti a kseri timurke. Ode ti wen desike Hulasokwe tyutuk iry iala desike ti bo desy. ");
INSERT INTO slu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Lemadendye Hulasow YANWE yala kyakar aw nekre mumu toha lasmyerke khaha neke ma ktyuhw ti bo desy, ma tatos mo eras ode ta kisinare mo mtelas a ksyalik. Ode ti bo desike kditlanke dakun o Hulasokwe tyan akwe enaru. Neke akwe it ma kolnye iry mana aw desike kisike desikemo ana myorif nini nam, ode akwe it huruk ma kolnye iry mana aw desike kisike desikemo enmo hye eraske ode atyatke. ");
INSERT INTO slu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ode ti bo desike dakun o sahke it ma knyaha kyosy Eden ma kyabetar a bo desy. Kyosy desy, sah desike kisan ma ksanake enaat. ");
INSERT INTO slu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ksana mamunake kani a Pison, neke knyaha ma klyekw ti de klyekw ma ti lasmyerke khaha Hawila neke mumu, neke blyawanke kwenake desy. ");
INSERT INTO slu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ode blyawan manosy hnu desike eras a ksyalik. Ti desy dakun o damar bedolake kyor a hatw a krisopraske. ");
INSERT INTO slu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sahke ksana matoha mamunake kani a Gihon, neke knyaha ma klyekw ti de klyekw ma ti lasmyerke khaha Kushke ktemke mumu. ");
INSERT INTO slu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sahke ksana matoha hurukke kani a Tigris, desyo sahke ksana neke knyaha ti kseri timur hnu Asyurke. Klala sahke ksana manosy lyakwe kani a Efrat. ");
INSERT INTO slu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Lemadendye Hulasow YANWE yal iry a iala desy ma tyutuk a i ti bo Eden desy kralake, ma ilaka ode syeak ti bo desy. ");
INSERT INTO slu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Dendye Hulasow YANWE tyunik haretke ti iry desy de byohe, “Aw ribun mamin ti boke krala neke kyosy o ma mu kisinare mumu bo, ");
INSERT INTO slu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","keskyede munenenas aw maala irkye ma hye a atyat o eras desike murontyo mu kisike, kali kyoat sew muna akwe kisi desy bonyo ana mmwaty elik.” ");
INSERT INTO slu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hulasow YANWE byu huruk de byohe, “Lema eras kolnye iry neke lol mesan a i bo. Lemamo ana kala irkye it ma deruke mais-mais a sir, ma iry kuala ne syaluk iry mamuna desy.” ");
INSERT INTO slu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Lemadendye Hulasow YANWE yal heal o nam ribun iala toha lasmyer neke, ma iwahuk sir a ktyabal manu manem ti sra lait ne mumu. Maktei bonyo yety heal o manu desikre mumu ti iry desike ma Hulasokwe yatos iry desike ma yaki heal o manu desikre anitare. Dendye iry desike yaki heal o nam mamorif desikre anitare mumu, ktyoha ihalkye, ma ana heal o nam desikre rhaly anitare kola dene iry desike ihaly ne dakun. ");
INSERT INTO slu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Iry desike yaki heal raorif desikre, manu mamin ti sra nekre, ode heal mamin ti skyamur a krala nekre, keskyede ti tenanke neke lema itot irkye it elik ma ana syaluk ti i. ");
INSERT INTO slu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lemadendye Hulasow YANWE yala iry desy ma yenaf ma tyebti, maktei bonyo nyaik iry desike ruskwanke it, maktei bonyo kyahat eta kwena desy kyor kisike tebikan. ");
INSERT INTO slu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ode irkye ruskwan dai Hulasow YANWE inal toha iry desike, yal ma ika irkye it, ma wamfwet a i. Lemadendye Hulasow YANWE yor wamfwet desy ba ti iry dai desy. ");
INSERT INTO slu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma iry desike byu de byohe, “I ne nde! I neke yosy lurikkwe, ode isike kyosy isikkwe, ma ana raki i ti ‘wamfwetke,’ kali ral i toha wamwankye.” ");
INSERT INTO slu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kali koldyesike mane ana wamwankye tyutuk ena o ama ma ti yait sawa, ma deruke rawahuk sir ti nam sasamke. ");
INSERT INTO slu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kyoat desikeo iry deru desike ramleh, keskyede iry desike yor sawa de it de lema myai it, kali lema rhe o ramleh. ");
INSERT INTO slu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ni neke heal a maulak o matalik ti a heal mamin ti ra Hulasow YANWE iala nekre mumu. Lemade sew desike ni neke tyanuk ti wamfwet desy de byohe, “Aw mamin boke krala ne mumu neke bain-bain o Hulasokwe byuma kete mi kisinare e?” ");
INSERT INTO slu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Lemade wamfwet desike hyalas ni desy de byohe, “Lema koldyesy, de aw kisi mamin ti boke krala ne Hulasokwe byuma aramy mi mumu, ");
INSERT INTO slu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ode, ti boke kditlalan ne dakun o akwe enaru kimin ti. Ma akwe sasam neke Hulasokwe byuma aramy mi kisinare, klala aw idake Hulasokwe byuma kete aramy mi kisinare elik, ode kete aramy mkyumak o mikabir dakun, kali kolnye aramy myala ktela desy bonyo ana aramy myaty.” ");
INSERT INTO slu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bonyo ni desike tyanuk ti wamfwet desy de byohe, “Lema koldyesy. Ana lema mmyaty. ");
INSERT INTO slu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Hulasokwe tyanuk koldyesy kalie hye ohe ana kolnye mi aw ne kisi desikre bonyo, huhumire kimlakat ode matamire khyela i bonyo mhye eraske o atyatke kola Hulasokwe ne dakun.” ");
INSERT INTO slu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lemade wamfwet desike yatos a akwe kisi desike ma eras ode ra mo mtelas, lemade ryekan ti ralake de byohe, “Anakyai aw ne kisike kika kbuan, ma kolnye ku mo, ktwilik a khwe eras o atyat.” Dendye lyol simake ti byul akwe kisi desike ma nya, ode yal ti lai ma nya dakun. ");
INSERT INTO slu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kyoat wamfwet wamwany a rana akwe kisi desike maktei bonyo, deruke matatare khyela i ma rhe o ramleh. Dendye rutur aw ktahinare ma rlel eta smwelatare. ");
INSERT INTO slu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sewah desike deruke rtomolu ma Hulasow YANWE lyakut ti boke krala desy, lemade deruke ramtaut kali ramleh, lemade rba ti rabuny ti a aw kusu desikre ma kete Hulasokwe myatakit a sir. ");
INSERT INTO slu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Keskyede Hulasow YANWE yabuk a wamwany desy de byohe, “Adam, o ika?” ");
INSERT INTO slu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Lemade Adam a hyalas ma byohe, “O Hulasow O, ktwomolu ma mmwai bo ne kralake de, keskye kubuny kali kumtaut o kumleh.” ");
INSERT INTO slu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Lemade Hulasow YANWE yena i de byohe, “Esei ne ilosu ti o ohe mumleh ne de? De ande mu a akwe kisi kubu eta ti o ne e?” ");
INSERT INTO slu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Desike bonyo Adam a hyalas ma byohe, “De wamfwet munal i ma yaw ne i ne inal akwe kisi ne ma kuna ne nde.” ");
INSERT INTO slu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lemade Hulasow YANWE tyanuk huruk ti wamfwet desy de byohe, “Kyanmwane muala ktela ne de?” Bonyo wamfwet desike hyalas ma byohe, “De ni neke i ne iakal yaw mane kuna aw desike kisike ne nde.” ");
INSERT INTO slu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Dendye Hulasow YANWE itomolu tun desike bonyo, tyanuk ti ni desy de byohe, “Kali mala koldyesy e, kala tnyetakke ti o toha heal mamaruh nekre, ode heal mamin lasmyerke khaha ne mumu. Lemadendye kyala kyosy a senwe ma kiba knaru neke, mal a fteimkwe ma mlwamy ti lasmyerke, ode welno hahamw a ksyuruk i ti ahkwe bo. ");
INSERT INTO slu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ode ana kiba knaru neke kala o ma mor a wamfwet desy it de imnisik a it, ma ti kyait wamfwet desike tesnwo natu, ror tesnwo natumw it de imnisik a it dakun. Ma wamfwet desy tesnwo natu syosno tyabak usumkwe khatuke, ode o a ana mkwuty a tikake.” ");
INSERT INTO slu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maktei bonyo tyanuk ti a wamfwet desike ma byohe, “Ana kolnye, mor tenamkwe ode kyait sew mudur hahke mo ana mkwoman a ksunsunuke a ksyalik, ode ana mobak ma mhwareta laimw keskyede ana mutomolu ike bo.” ");
INSERT INTO slu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Maktei bonyo tyanuk ti a wamwany desike ma byohe, “Kali mbwuma mtwomolu sawamw ma mu a akwe kisi kubu eta ti e desy, lemade kala lasmyer ne ma lema kika kisnyo klaran, khyali o. Ode kibai lulkwe ne munoha kotnwo abumw ti lasmyerke khaha ne mo ana ksunw ksyalik, ");
INSERT INTO slu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","kali sitw o karkyary o tnyei mahaw nekre ana ktyuhw ti lasmyer ne dakun, ode kyosy lasmyer ne ana muknam toha. ");
INSERT INTO slu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kolnye mkwarya ma mnwoha kotnwo abumw mo, ana mal nini maslyesare ksyu o ksyaw ti tenamkwe ktem ne nini mmwaty ma molik o bai lasmyerke, kali kala o toha lasmyerke, lemade ana mulak o bai lasmyerke huruk.” ");
INSERT INTO slu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Desike bonyo Adam a yaki sawa ma ani Hawa, kali iry mamorif mamin nuske ktem ne enat a i. ");
INSERT INTO slu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lemade Hulasow YANWE yal healare dum a iblut, ode ika iry desy yor sawa-na wait rabitare. Maktei o yal ma hyonak o ryabit sir ma kyeteta tenatare. ");
INSERT INTO slu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hulasow YANWE ihonak iry desikre maktei bonyo, ryekan ti ralake ma byohe, “Iry nekre rola Ity mane, ma rhe eraske o atyatke dakun. Ode ti bo ne kditlalanke, akwe it kimin ti ma kolnye iry mana aw desy kisike desikemo ana myorif nini nam. De lemamo kaditi sir toha bo ne, kali mamak de rlol simatare ti rbul aw desike kisike ma ra desikemo ana rmorif nini nam.” ");
INSERT INTO slu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Lemade Hulasow YANWE yesak sir toha bo mamin Edenke krala desy ma rbetik, ma ti robak lasmyer salik ma rnoha boluhu-boel ti. Kali iry desike Hulasokwe ika i toha lasmyerke, lemade ti lasmyer ne yobak kotnwo abu toha dakun. ");
INSERT INTO slu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Maktei bonyo, Hulasokwe tyutuk iry manosy sra-are ti a Edenke kseri timur desy ma ralaka bo Edenke. Ode tyutuk kray a madelahke ma khyet ti de khyet ma ti desy, ma kdyotar eta sal mabai boke kralake, ma kete irire rsukar ti rbul aw desy kisi manety mormyorif nini namke. ");
INSERT INTO slu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Seure kiliku i ma Adam yenah yor sawa, desikeo sawa-na yor tenanke. Lemadendye idur hah bonyo, ananke wamwany a i, ma raki anike ti Kain, kali wamfwet desike tyanuk de byohe, “Kutot naman wamwany ne kali Hulasow YANWE lyobak yaw.” ");
INSERT INTO slu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ode klia seure huruk bonyo wamfwet desike yor tenanke ma idur hah bonyo, ananke wamwany a i huruk, lemade raki anike ti Habel, ma Kain wai amury a i. Habel neke karyaake, ilaka heal mamaruh nekre, klala Kain neke nyoha bo. ");
INSERT INTO slu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sekwe it bonyo Kain neke yal wasi bo a kisinare ma yabar ode yalela ti a Hulasow YANWE. ");
INSERT INTO slu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ode Habel yala ktela desy dakun, keskye yal dombanare anat ausw mamsun eras nekre ma kyety a sir ma yal kisi mamin-mamin nekre ma yabar ode yalela ti Hulasokwe. Dendye Hulasow YANWE dyakin Habel wasi ktela desy, ");
INSERT INTO slu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","klala lema you Kain wasi ktelake. Lemade Kain ralake atyat ode matake masbu. ");
INSERT INTO slu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Dendye Hulasow YANWE tyanuk ti Kain de byohe, “Kyanmwane ralamkwe atyat ode matamkwe masbu ne de? ");
INSERT INTO slu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kolnye mala ktela eraske mo lema mumukmuka o e? Keskyede mubrai mala ktela eraske. Lemade lim o sal neke kikitkita ma ksyukar ti khyareta o. Lemamo malkyaw o ma ktela atyat desy mbwisak ba.” ");
INSERT INTO slu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Keskyede sekwe it huruk bonyo, Kain ryubut wai amury a Habel ma byohe, “Mmwa ma ituru tbai boke.” Lemade deruke rbai bo desy, ma ti ranait bo desy bonyo, Kain yoban a hyunw a wai amury Habel. ");
INSERT INTO slu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dendye Hulasow YANWE yena Kain de byohe, “Kain o! Waimw amury a Habel neke ika?” Bonyo Kain a hyalas I de byohe, “Mbwe. Lema khwe i. De mbwuma ksweak i dakun e?” ");
INSERT INTO slu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Lemade Hulasow YANWE tyanuk ti Kain huruk ma byohe, “Kyanmwane muala ktela atyat maoly ne de? Waimw amurkye myaty ma larake kibo ti lasmyer ne. Ode larake kyabw kyosy a lasmyer ne ma Yaw, ma kbyuma koil ti o. ");
INSERT INTO slu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Lemadendye kala tnyetakke ti o ma lema mnwoha lasmyer ne de, kali lasmyer neke ktyel a waimw amurkye larake ti kyoat a mutabahunw a i desy. ");
INSERT INTO slu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ode kolnye mnwoha bo ti lasmyer ne, desikemo lasmyer neke ana lema kika kisi ti o mamak kola heitlulswo. De ana mola iry a lema maka wenat nekre, de ti de ba de ma o bo, kali lema muka wenamw a mlay ti lasmyer ne khahake.” ");
INSERT INTO slu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Lemade Kain a byu ti Hulasow YANWE de byohe, “Hulasow O, tnyetak mutunik ma yaw neke mdedan a ksyalik ma lema khwar a kal. ");
INSERT INTO slu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mane mesak a yaw toha lasmyer ne, ma ana soso lahuk yaw toha O, ma kola dene iry mamesan malakut ti de malakut ma nekre, ma lema kuka wenakw a mlay ti lasmyerke khaha ne. Ode kolnye iry dum a rait yaw mo, rtabahunw a yaw bo.” ");
INSERT INTO slu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lemadendye Hulasow YANWE tyanuk ti i de byohe, “Ana lema koldyesy, de kolnye irire rait a o ma rbuma rtabahunw a o, desikemo kala tnyetakke ti sir kdi a kla-itw elik.” Maktei bonyo Hulasow YANWE yatosa Kain ma bya nini kolnye irire dum a rait a i, desikemo kete rtabahunw a i. ");
INSERT INTO slu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ode Hulasokwe itun a yor Kain maktei bonyo, Kain a bya toha Hulasow YANWE ma bya ti tyenas ti Eden kseri timurke, neke wen desy kani Nod. ");
INSERT INTO slu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Seure kiliku i, desikeo Kain yenah yor sawa, lemade sawa-na yor tenanke. Lemadendye idur hah bonyo, ananke wamwany a i ma raki anike ti Henokh. Kyoat desy dakun o Kain a syadiri hnuke it, lemadendye yaki ti Henokh ma khyah a ananke anike. ");
INSERT INTO slu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henokh neke ananke ani a Irad, ode Irad neke ananke ani Mehuyael, ode Mehuyael neke ananke ani Metusael, ode Metusael neke ananke ani Lamekh. ");
INSERT INTO slu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ode Lamekh neke isa-ru ma ita ani Ada, ode idake ani Zila. ");
INSERT INTO slu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Desikeo Ada neke idur hah bonyo, ananke wamwany a i ma raki anike ti a Yabal. Ode Yabal neke ebnwo anan iry mamuna maka lasyery ma ramin ti ma ralaka biby o domba o saby. ");
INSERT INTO slu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal neke wai amurkye ani Yubal, ma Yubal neke ebnwo anan a sir ne rala rhe leklekke, ma rohu rhe hluitke, ode rritik a rhe juk o nam. ");
INSERT INTO slu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Klala Zila idur hah, desike bonyo ananke wamwany a i ma ani Tubal-Kain. Tubal-Kain neke ebnwo anan sir ne rala rhe yaby a hnutan o soly o nam nekre. Ode Tubal-Kain neke rahyeta-na ani a Naama. ");
INSERT INTO slu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sekwe it bonyo, Lamekh tyanuk ti sawa deruke de byohe, “Ada mor Zila, sawakw e, mlyika molumire ma mtyomolu nam kutanuk ne! Nenmo ktwabahunw a lyalakwe it, kali yoban yaw. Lyalaw neke yala yaw ma kumnu, dendye ktwabahunw a i elik. ");
INSERT INTO slu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kolnye dum a rares ma rtabahunw a Kain, desikemo rtunik atyatke ti sir kdi a kla-itw. Keskye kolnye ti yaw mo, iry mares ma matabahunw a yaw ne, desikeo ana rtunik atyatke ti sir neke karyarike hean-itw kresi itw elik.” ");
INSERT INTO slu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Seure kiliku i, desikeo Adam yenah yor sawa, lemade sawa-na yor tenanke huruk. Lemadendye idur hah bonyo, ananke wamwany a i. Ode Hawa byohe, “Hulasokwe yal namanke it ma yaw huruk ma yeluk Habel, kali Kain tyabahunw a i de. Lemade kaki anike ti Set.” ");
INSERT INTO slu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ode Set lyean ma lan i bonyo, isa ma ika anan, desyo ananke wamwany a i ma yaki anike ti Enos. Ode kyoat Enos radur ti i, nenmo irire rabuk Hulasokwe Anike ti “YANWE” ma rleru I. ");
INSERT INTO slu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam yor tesnwo natu ne, rkesy anitare. Kyoat Hulasokwe ika iry deru desy, desikeo ika sir ma rola I dakun. ");
INSERT INTO slu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Hulasokwe ika sir neke, wamwankye ode wamfwetke. Lemade Hulasokwe yal eraske ti sir, ode byohe, “Irire sir ne.” ");
INSERT INTO slu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam wasi ainke atw ksala hean-telw (130) bonyo, sawa-na idur hah huruk, desikeo ananke wamwany a i, ma raki anike ti a Set. Naman desike uno mata ne kola ama Adam. ");
INSERT INTO slu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam wasi ainke ktyabal atkwe walw (800) huruk, ma ti klelan ain desikre kieluk i, Adam sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ode Adam wasi ainke kyait a atkwe siw ksala hean-telw (930), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ode kyoat a Set wasi ainke atw kresi enasim (105) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Enos. ");
INSERT INTO slu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set wasi ainke ktyabal atkwe walw kresi itw (807) huruk, ma ti klelan ain desikre kieluk i, Set sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ode Set wasi ainke kyait a atkwe siw ksala hean a kresi enaru (912), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ode kyoat a Enos wasi ainke hean-siw (90) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Kenan. ");
INSERT INTO slu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos wasi ainke ktyabal atkwe walw ksala hean a kresi enasim (815) huruk, ma ti klelan ain desikre kieluk i, Enos sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ode Enos wasi ainke kyait a atkwe siw kresi enasim (905), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ode kyoat a Kenan wasi ainke hean-itw (70) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Mahalaleel. ");
INSERT INTO slu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan wasi ainke ktyabal atkwe walw ksala hean-at (840) huruk, ma ti klelan ain desikre kieluk i, Kenan sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ode Kenan wasi ainke kyait a atkwe siw ksala hean (910), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ode kyoat a Mahalaleel wasi ainke hean-nem a kresi enasim (65) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Yared. ");
INSERT INTO slu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleel wasi ainke ktyabal atkwe walw ksala hean-telw (830) huruk, ma ti klelan ain desikre kieluk i, Mahalaleel sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ode Mahalaleel wasi ainke kyait a atkwe walw ksala hean-siw kresi enasim (895), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ode kyoat a Yared wasi ainke atw ksala hean-nem a kresi enaru (162) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Henokh. ");
INSERT INTO slu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yared wasi ainke ktyabal atkwe walw (800) huruk, ma ti klelan ain desikre kieluk i, Yared sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ode Yared wasi ainke kyait a atkwe siw ksala hean-nem a kresi enaru (962), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ode kyoat a Henokh wasi ainke hean-nem a kresi enasim (65) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Metusalah. ");
INSERT INTO slu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henokh wasi ainke ktyabal atkwe enatelw (300) huruk, ode sew kyaki nekre ika lui yor Hulasokwe. Ode ti klelan ain desikre kieluk i, Henokh sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ode kyoat Henokh ika lui yor Hulasokwe nini wasi ainke atkwe enatelw ksala hean-nem a kresi enasim (365), desikeo lema imin, kali Hulasokwe syalak a i. ");
INSERT INTO slu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ode kyoat a Metusalah wasi ainke atw ksala hean-walw kresi itw (187) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Lamekh. ");
INSERT INTO slu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusalah wasi ainke ktyabal atkwe itw ksala hean-walw kresi enaru (782) huruk, ma ti klelan ain desikre kieluk i, Metusalah sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ode Metusalah wasi ainke kyait a atkwe siw ksala hean-nem a kresi siw (969), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ode kyoat a Lamekh wasi ainke atw ksala hean-walw kresi enaru (182) bonyo, sawa-na idur hah ma ananke wamwany a i. ");
INSERT INTO slu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Dendye Lamekh yaki anike ti Nuh, ode byu de byohe, “Naman neke ana kibai lulkwe ne yarana ity hesatare ti takarya mdedan ti lasmyer a YANWE ituhar ba ne.” ");
INSERT INTO slu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamekh wasi ainke ktyabal atkwe enasim a ksala hean-siw kresi enasim (595) huruk, ma ti klelan ain desikre kieluk i, Lamekh sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ode Lamekh wasi ainke kyait a atkwe itw ksala hean-itw kresi itw (777), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ode kyoat Nuh wasi ainke atkwe enasim (500), desikeo anan wamwankye enatelw sir, neke Sem, Ham, ode Yafet. ");
INSERT INTO slu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kyoat desikeo irire rmel ma ribun ratut sir ti nuske ktem ne, ma dum a radur hahak naman wamfwetare. ");
INSERT INTO slu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Lemade Hulasokwe wasi irire rosy laitke, ma ratos naman wamfwetare ti lasmyerke khaha neke mo eras sir a ksyalik, dendye rseak radakinare ma rasaa ror sir. ");
INSERT INTO slu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Dendye YANWE tyanuk ma byohe, “Memeakkwe ana lema ktyenas ti irkye nini nam, kali larke khatu i bo, lemade ana imorif neke wasi ainke kyait atw ksala hean-ru (120) bo.” ");
INSERT INTO slu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kyoat desike ode kiba knaru desy, neke Hulasokwe wasi irire rosy laitke ma rasaa ror naman wamfwet desikre, ma wamfwet desikre radur hahak namanare ti iry manosy lait desikre. Ode naman desikre rlean ma lan de lan sir ode malkyakaw sir ma rambrebat ode rba tantyany. ");
INSERT INTO slu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Lemadendye YANWE yatos irire ma rala tot atyatare ti lasmyerke khaha ne, ode nam rarekan ti ralat a kralanare neke kyety atyatke kimesmesan, ");
INSERT INTO slu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","dendye YANWE ralake ksyal ti ktela iatos desy, lemade syesal a I o ika irkye ti lasmyer ne. ");
INSERT INTO slu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Dendye YANWE tyanuk ma byohe, “Ana kswoly o kswarah nam ribun kuala ti lasmyerke khaha ne mumu, neke iry o, heal malamy o, mamaruh o, mata mnas nekre, rtabal manu mamin sra nekre, kali kswesal ti kuala sir ne.” ");
INSERT INTO slu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Keskyede ti YANWE ralake kralake kdyakin a Nuh. ");
INSERT INTO slu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuh wasi mormyorifke ne: Nuh neke iry mlakye, ode lema yala ktela atyatare kola iry mamorif ti taras desy, ode Nuh neke ika lui yor Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ode Nuh ananke enatelw ma wamwany a sir mumu, neke Sem, Ham ode Yafet. ");
INSERT INTO slu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ode kyoat desy dakun o Hulasokwe yatos o lasmyerke khaha ne kbyenw ti tot atyatare, ode ral resatare ma rataut ti rataut ma. ");
INSERT INTO slu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ode Hulasokwe yatos mo lasmyerke khaha neke atyat bain-bain de, kali iry mamin ti lasmyerke khaha ne mumu neke, rmorif ti atyatke kmyesan bo. ");
INSERT INTO slu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Dendye Hulasokwe tyanuk ti Nuh ma byohe, “Kohut maktei de, ana ktwabahunw nam mamorif nekre mumu, kali lasmyerke khaha ne kbyenw ti iry mahature ma rares ma rala koi-kay. Lemade, mtwomolu! Kala ma kswoly o kswarah sir a ror lasmyerke khaha ne ba! ");
INSERT INTO slu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De adoko muka batbatak lan de lanke it ti o, neke kyosy a aw a gofirke. Ode batbatak desike muka ma kika kloka it kloka it, ode mal terke ma mswimak a keta o krala ma ktem a ktem. ");
INSERT INTO slu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ode muka batbatak desy mo knaruke reke hean-itw kresi enasim (75), ode kahelnanke reke hean a kresi enaru o ktera (12,5), ode katkanake reke itw ktera (7,5). ");
INSERT INTO slu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ode mkwahat eta batbatak desy ma kete ktem, de kika klelan, neke sentike hean-at a kresi enasim (45) kyosy a srake ei ktenanke. Maktei o muka holholatke ti kserike, ode muka batbatak desy ma kika kdadi ma sra o hah ode kditlan. ");
INSERT INTO slu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kali mlay bain o Yaw ne ana kala wer maluburke ma kyahat eta lasmyerke khaha ne, ma ktyabahunw a nam mamea nekre ti laitke hah ne, ma nam mamin lasmyerke khaha ne rmaty mumu. ");
INSERT INTO slu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Keskyede Yaw ne ktwetak maktei de, ma ana mswukar ei batbatak desy kralake mor sawamw, ode anamure ror sawatare. ");
INSERT INTO slu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ode kyosy a heal salno salik mamorif ti lasmyerke khaha ne mumu neke, wamfwet wamwany ana rma ma rait a o, ma mal sir ei batbatakke krala desy ma rmorif ror a o. Mnwenas ma kyosy a manu salno salik, ode heal salno salik lan o kakan, ti lasmyerke khaha ne mumu, ana mal wamfwet wamwany ma maorif a sir. ");
INSERT INTO slu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ode muwahuk kotw sai ta sai kyalamo ra o renw ma resamy, ode mswosan ti batbatakke krala desy, ma ana mi ode heal desikre ra dakun.” ");
INSERT INTO slu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Lemadendye Nuh tyoha haret Hulasokwe itanuk ti i desikre mumu ma yala maktei de. ");
INSERT INTO slu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Lemade YANWE byu ti Nuh de byohe, “Mor a wasimw sekye kralake msyukar ei batbatakke krala desy, kali katos ti iry taras ne mo mmwesan a mlay a o. ");
INSERT INTO slu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Lemade kolnye, ktyoha heal a salno salik rasusinare, mal wamfwet wamwany neke ratsam-ratsam toha sir ma muhanun a sir, klala heal a salno salik lema rasusinare mal wamfwet wamwany neke raitw-raitw toha sir ma muhanun a sir. Maktei o kyosy manu salno salik nekre, mal wamfwet wamwany neke raitw-raitw toha sir ma muhanun a sir dakun, ma heal nekre rmorif ma rbenw a lasmyerke khaha ne. ");
INSERT INTO slu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kali lenla sekwe itw bonyo, knwauk us lan ne ti lasmyerke khaha ne, ma kyal nini sekwe hean-at. Ma nam kuala mamin lasmyerke khaha ne kswoly o kswarah ba mumu.” ");
INSERT INTO slu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lemade Nuh tyoha haret YANWE itanuk ti i desikre mumu. ");
INSERT INTO slu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kyoat a Hulasokwe iala wer maluburke ma kbyenw lasmyerke khaha ne mumu bonyo, Nuh wasi ainke atkwe nem (600). ");
INSERT INTO slu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Lemade Nuh yor sawa ode ananare ror sawatare, rsukar ei batbatakke krala desy ma kete wer maluburke ktyabahunw a sir. ");
INSERT INTO slu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Maktei bonyo heal salno salik lema rasusinare ode rasusinare, rtabal manu salno salik lema rasusinare ode rasusinare ti lasmyerke khaha ne mumu, ");
INSERT INTO slu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","neke wamfwet wamwany rahanun a sir ode rma ma rsukar ei batbatakke krala desy ma rait Nuh. Ma ktyoha haret Hulasokwe itanuk ti Nuhke. ");
INSERT INTO slu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Lemadendye sekwe itw kyolak eta bonyo, Hulasokwe yala werke ma klyubur ma kbyenw lasmyerke khaha ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kyoat a Nuh wasi ainke atkwe nem, ode ti sew a hean a kresi itkwe ti hul enaruke, desikeo lasmyerke kimnan ma wer a kmatanare klyubur ma ksyorw a lasmyerke khaha ne, ode laitke kele rsin ");
INSERT INTO slu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ma us lanke kdi kola dene kele rhodi wer laitke ei hahke ma kyal nini sekwe hean-at. ");
INSERT INTO slu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kyoat sew desy dakun o, Nuh yor sawa, ode anan detelw desike, neke Sem, Ham, ode Yafet, ror sawatare rsukar a kmuna ei batbatakke krala desy ma ramin ti. ");
INSERT INTO slu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ode manu o heal mamaruh o mata mnas, kakan o lan, rtabal heal malamy ti lasmyerke khaha ne dakun; ");
INSERT INTO slu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","neke manu o heal salno salik a mamea nekre rahanun wamfwet wamwany, ma rma ma rsukar ei batbatak desy ma rait Nuh. ");
INSERT INTO slu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Heal o manu desikre rma ma rsukar mumu ma kola haret Hulasokwe itanuk ti Nuhke. Maktei bonyo, YANWE hyolat eta holholat batbatak desy. ");
INSERT INTO slu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ti lasmyerke khaha ne mumu, wer malubur desike ksyai ma kyal nini sekwe hean-at. Lemade wer desike ksyai ma kyamanuk batbatak desy ma kimanw-kimanw. ");
INSERT INTO slu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ode wer desike ksyai-ksyai toha ma lan ti lasmyerke khaha ne, ma batbatak desike kimanw-manw ti werke khaha desy. ");
INSERT INTO slu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ode wer desike ksyai de ksyai nini atat a ksyalik ma khyalodur lasmyerke khaha ne, ma kkyahat eta huar atat mamin a lasmyerke khaha ne mumu, ");
INSERT INTO slu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ma wer malubur desike kbyilak huar a ktutunare, neke mabilakke reke enatelw ktera. ");
INSERT INTO slu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Lemadendye nam ribun lan mamorif ti lasmyerke khaha ne, rmaty mumu, neke manu o heal a mamaruh o, mata mnas o, malamy nekre rtabal iry ribun mamorif ti lasmyerke khaha ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mane nam ribun lan mamea ti lasmyerke khaha neke rmaty mumu ma teit. ");
INSERT INTO slu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Lemadendye nam ribun lan mamorif ti lasmyerke khaha ne mumu neke, iry o, heal o, manu o, heal malamy o nam nekre, Hulasokwe tyabahunw o yaha sir mumu. Klala mamin ti batbatakke krala desy, neke Nuh yor sawa o anan o sobai, rtabal a heal o manu ranor sir desikre rmesan a rmorif bo. ");
INSERT INTO slu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ode sekwe atw ksala hean-sim (150), wer malubur desike kkyahat eta lasmyerke khaha ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Keskye Hulasokwe nyenas Nuh tyabal heal mata mnas o mamaruh manor i ti batbatakke krala desy, lemade Hulasokwe yala eskwe ma kyohw ti werke khaha desy, ma khyury ma wer desike kyala ma kyorw. ");
INSERT INTO slu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Maktei o Hulasokwe kkyahat eta wer a kmatanare ti lasmyerke khaha ne mumu, ktyabal wer mamin ti laitke, ma us lan ne lema kyoras de. ");
INSERT INTO slu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ode wer desike kyorw-kyorw toha, nini sekwe atw ksala hean-sim kyolak eta, ");
INSERT INTO slu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ti sew hean a kresi itkwe ti hul itkwe krala desy bonyo, batbatak desike kele rsaa ti huarare ti Ararat. ");
INSERT INTO slu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Desikeo wer lan desike kyorw-kyorw ei hahke ma kyait hul heanke, ode ti sew mamunake ti hul hean desy bonyo, huar a ktuhunare kyar. ");
INSERT INTO slu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ode sekwe hean-at a kyolak eta bonyo, Nuh lyakat jendela kakan mamin ti batbatak desy, ");
INSERT INTO slu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ma tyunik manu alalke it, keskye lema yulak a i, de nyem ti de nyem ma bo, nini wer desike kmyety ma bakbak ti lasmyerke khaha ne. ");
INSERT INTO slu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Lemadendye tyunik huruk manu hahkye it ma ti byihy o kete werke bakbak ti lasmyerke khaha ne de. ");
INSERT INTO slu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Keskyede manu hahy desike lema itot wen ma tyuny, lemade nyem ma yulak a i mai batbatak desy, kali ti lasmyerke khaha ne mumu werke lenla bakbak. Dendye Nuh lyol simake ti kyumak manu desy ma yal i ei batbatakke kralake. ");
INSERT INTO slu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Maktei bonyo Nuh ikita sekwe itw huruk, nenmo tyunik manu hahy desy huruk toha batbatakke kralake. ");
INSERT INTO slu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ode kinohnoh ti sekwe iba bonyo, manu desike yulak i huruk ma yait Nuh, desyo mya o kyuty aw a zaitunke ksitu mur ne sasam! Lemade Nuh nenmo hye o wer malubur ti lasmyerke khaha ne kyala ma bakbak mumu de. ");
INSERT INTO slu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Maktei o, Nuh ikita sekwe itw huruk ma kisakut bonyo, tyunik manu hahy desy huruk, keskyede lema yulak i ma yait Nuh ti batbatak desy. ");
INSERT INTO slu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ode ti Nuh wasi ainke krala atkwe nem a kresi sasam desy, ti sew mamuna ti hul sasamke, neke wer malubur ti lasmyerke khaha ne mumu ne bakbak. Lemadendye Nuh lyakat batbatakke khahake tebikan, ma yatos ti yatos ma, desyo lasmyerke khaha ne mumu bakbak bain de! ");
INSERT INTO slu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ode ti hul enaruke krala desy, ti sew a hean-ru a kresi itkwe, neke wer malubur ti lasmyerke khaha ne mumu ne bakbak keskes. ");
INSERT INTO slu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lemade Hulasokwe tyanuk ti Nuh de byohe, ");
INSERT INTO slu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nuh! Mor sawamw o, anamw, ode anamure sawatare mbyetik toha batbatakke krala desy. ");
INSERT INTO slu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ode mtyabal heal mamorif minor desikre, neke manu o, heal mamaruh o, mata mnas o, heal malamy desikre, mor sir ma miktemtem a mbyetik ei mloskye, ma ana rmel ma rbenw lasmyerke khaha ne.” ");
INSERT INTO slu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Lemade Nuh yor sawa ode ananare ror sawatare, ");
INSERT INTO slu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","rtabal heal mamaruh o, heal mata mnas o, manu o, heal malamy desikre, ror nam ribun mamorif ti lasmyerke khaha ne raktemtem mumu, ktyoha wamfwet wamwany rahanun desikre ror anatare ma rbetik toha batbatakke kralake ei mloskye. ");
INSERT INTO slu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Lemade Nuh yal hature ma syadiri lat raeh heal ti Hulasokwe, ode yilik heal lema rasusinare dum ode manu lema rasusinare dum dakun, ma yal sir ma yeh a sir ti akye, ma yabar ti YANWE. ");
INSERT INTO slu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kyoat YANWE ilos a nam Nuh iabar desikre ma kihon a mtelas bonyo, YANWE tyanuk ti ralake de byohe, “Ana lema kuhnutuk lasmyerke khaha ne de, khyali irire totat atyatare. Khwe ohe irire rala rosy kakan sirke nam rarekanare atyat, keskyede ana lema kkwordalam nam ribun lan mamorif nekre de, kola nenmo kuala selsel ne. ");
INSERT INTO slu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lemade lasmyerke khaha ne ana kibai lulkwe neke, ana kika sewah o msarin, mrin o manas, sew ratan o rakety, ode leman o us, neke lema kimres elik.” ");
INSERT INTO slu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hulasokwe yal eraske ti Nuh yor ananare, ode byu ti sir de byohe, “Mika ebnwo anamy ma mmyel ma mbyenw ti lasmyerke khaha ne. ");
INSERT INTO slu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ode heal mamin lasmyerke khaha ne, ode manu manem ti sra nekre, rtabal heal malamy o, masy mamin ti tasi nekre, ana raktemtem a ramtaut e a ksyalik. Ode kal sir ti e ma mhyareta sir mumu. ");
INSERT INTO slu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ode heitlulswo kal tnyei o aw ktafran molmol nekre ti e ma mi o myenw bo, keskye senweke, ktwabal heal o ail ribun mamorif nekre mumu ma mi o myenw sir dakun. ");
INSERT INTO slu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Keskye kete mi heal a kisi lar o wahar mamin ti a nggora desikre, kali morif ne desi lar desy. ");
INSERT INTO slu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Lemade kala tnyetakke ma kolnye irkye tyabahunw irkye, desyo kal larake ma kyeluk lar desy! Ode heal matabahunw irkye, desyo kal heal desy larake ma kyeluk iry desy larake dakun. ");
INSERT INTO slu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kali kuka irkye ma yola Yaw, lemadendye kabei tyabahunw irkye, desyo tnyetakke ma rtabahunw a i dakun! ");
INSERT INTO slu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ode mnyenas, ei neke mika ebnwo anamy ma mmyel ma mbyenw ti lasmyerke khaha ne. Ou, ma ribun ratut e ma lema raki ral aryarimkye.” ");
INSERT INTO slu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Maktei o Hulasokwe tyanuk ti Nuh yor ananare huruk de byohe, ");
INSERT INTO slu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mtyomolu, kyala kyosy ne, kuhatetak kor o a mor tesnwo natumw, ");
INSERT INTO slu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","mtyabal heal mabetik toha batbatakke krala desy, neke manu o, heal mata mnas o, mamaruh o, malamy nekre, ktyabal heal ribun ana mamorif ti lasmyerke khaha ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma tnyetak kutanukke kolnye, kyala kyosy ne, nam ribun mamorif nekre, wer maluburke ana lema ktyabahunw sir mumu de, ode ana lema kala wer maluburke ma kihnutuk lasmyerke khaha ne huruk de.” ");
INSERT INTO slu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Lemade Hulasokwe byu ti Nuh yor ananare ma byohe, “Myatos wasikw keke desy. Ktwutuk i ti oanke, ma kyeluk nyatos kuhatetak kor e a myor a heal mamorif manor e nekre, ktyabal lasmyerke khaha ne mumu, ma ti kiba knaru ne ti tesnwo natumy ana mamin ti nuske ktem ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Seure rait de kala oan metmetke ti laitke, ode kolnye kekeke byetik ti oan desy, ");
INSERT INTO slu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","desikeo knwenas kal nam kuhatetak kunor e ne, mtyabal a heal mamorif nekre, ma ana lema kala wer lan maluburke, ma ktyabahunw nam ribun lan mamorif nekre mumu de. ");
INSERT INTO slu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ma kolnye keke desike byetik ti oanke, ode kuatos bonyo, knwenas kal wasikw tnyetak kunor nam ribun lan mamorif ti lasmyerke khaha ne mumu, ti kiba knaru ne.” ");
INSERT INTO slu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Lemadendye Hulasokwe byu ti Nuh de byohe, “Ou, keke desike ksyusu nyatos a kuhatetak kunor nam mamorif ti lasmyerke khaha ne mumu.” ");
INSERT INTO slu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuh anan mabetik toha batbatakke krala desy neke: Sem, Ham, ode Yafet. (Ham neke Kanaan ama i.) ");
INSERT INTO slu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuh anan detelw desy rmel ma rahe a rasakar sir ti lasmyerke khaha ne, ma iry mamorif ti nuske ktem ne mumu neke, ity ebnwo matrumat a sir. ");
INSERT INTO slu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh neke iry manoha bo i, ode i ne iala bo tasy maiskye kmuna ne. ");
INSERT INTO slu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ode ienw taskye kwen makitkye bonyo kyala i ma yonuk wasi rabit narnarkwe ma imlehleh, ode yenah ti wasi lasyerkye kralake. ");
INSERT INTO slu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Desikeo Ham (Kanaan ama) ne iatos ma ama-na imleh bonyo, bya ti ihes ti wai deru desy ti mloskye. ");
INSERT INTO slu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lemadendye Sem yor Yafet ral rabit narnarw desy ma rta ti deruke hesatare, ma rlakut a rsuka sir ei lasyerkye kralake, ode ral rabit narnarw desy ma rkahat eta amatke, ode deruke rulak matatare ma lema ratos amatke, kali amatke imleh. ");
INSERT INTO slu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ode kyoat Nuh ihe toha lbweta ma ibatar bonyo nenmo hye ktela anan amurkye iala ti desy, ");
INSERT INTO slu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","dendye byu de byohe, “Lemamo Hulasokwe tyuhar Kanaan ma ika at ti wainare.” ");
INSERT INTO slu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Maktei o Nuh byu huruk de byohe, “Klweru YANWE, Hulasow a Sem isob tike. Kuten ma kibai lulkwe ne Kanaan yor tesnwo natu raka at ti Sem yor tesnwo natu. ");
INSERT INTO slu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ode Hulasow O, kuten ma mahelak wen a Yafet imin tike ma helhela halhyali, ode mal Yafet tesnwo natu ma ror Sem tesnwo natu ma ramin ti Sem wasi lasyerire. Keskyede kibai lulkwe ne mala Kanaan ma tesnwo natu raka at ti Yafet tesnwo natu dakun.” ");
INSERT INTO slu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kyala kyosy wer malubur desy, Nuh wasi ainke ktyabal atkwe enatelw ksala hean-sim (350). ");
INSERT INTO slu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Dendye Nuh wasi ainke kyait atkwe siw ksala hean-sim (950), desikeo myaty. ");
INSERT INTO slu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kyoat wer maluburke kimres, desikeo Sem, Ham, ode Yafet sawatare radur hahak namanare ti sir. Ma klyosu Sem, Ham, ode Yafet tesnwo natut sir ne rakesy a anitare ne. ");
INSERT INTO slu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet tesnwo natu sir ne: Gomer, Magog, Madai, Yawan, Tubal, Mesekh, ode Tiras. ");
INSERT INTO slu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer tesnwo natu sir ne: Askenas, Rifat, ode Togarma. ");
INSERT INTO slu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan tesnwo natu sir ne: Elisa, Tarsis, iry mamin ti Kit-are, ode iry mamin ti Dodan-are. ");
INSERT INTO slu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Iry nekre, sir ne rahe a rasakar sir ma raka hnu ti namwatake khahake ne. Iry desikre mumu neke, Yafet tesnwo natu sir, ma ktyoha wait sei kralanare, ktyoha wait telare, ktyoha wait lasmyerare, ode ktyoha wait hnuare. ");
INSERT INTO slu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ode Ham tesnwo natu sir ne: Kusy, Misraim, Put, ode Kanaan. ");
INSERT INTO slu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusy tesnwo natu sir ne: Seba, Hawila, Sabta, Raema, ode Sabtekha. Raema ananare sir ne: Syeba yor Dedan. ");
INSERT INTO slu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusy sawa-na idur hah huruk ma ananke wamwany a i, ma raki anike ti Nimrod, iry neke i ne ihareta kmunmuna ti lasmyerke khaha ne. ");
INSERT INTO slu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrod neke YANWE syaluk i ma imbrebat ma idoha ti de idoha ma. Mane kyalamo irire ral i ma ratani i ti iry salik ma rbohe, “Anakyai YANWE syaluk o ma mumbrebat ma mudoha ti de mudoha ma kola Nimrod.” ");
INSERT INTO slu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Khyehyeike hyareta hnu Babelke, hnu Erekhke, ode hnu Akadke, ma hnu nekre mumu neke kimin a lasmyer Sinearke. ");
INSERT INTO slu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kyoat Nimrod hyareta o lasmyer Sinearke bonyo, byai lasmyer Asyurke, ti syadiri hnu a Niniweke, Rehoboth-Irke, Kalahke, ");
INSERT INTO slu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ode hnu Resenke dakun. Hnu Resen neke kimin ti a hnu Niniweke ode hnu lan Kalah desike klelanke. ");
INSERT INTO slu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ode Misraim sawa-na idur hahak iry a Lud-are, iry a Anam-are, iry a Lehab-are, iry a Naftuh-nare, ");
INSERT INTO slu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","iry a Patrus-are, iry a Kasluh-nare, ode iry a Kaftor-are. Iry a Kasluh nekre Filistin-are ebnwo matrumat sir. ");
INSERT INTO slu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ode Kanaan sawa-na idur hahak iry a Sidon-are (Sidon neke Kanaan anan ausw a i), iry a Het-are, ");
INSERT INTO slu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","iry a Yebusi-nare, iry a Amori-nare, iry a Girgas-are, ");
INSERT INTO slu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","iry a Hewi-nare, iry a Arki-nare, iry a Sini-nare, ");
INSERT INTO slu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","iry a Arwadi-nare, iry a Semari-nare, rtabal iry a Hamati-nare. Kanaan ne yor tesnwo natut nekre rmel ma sir ne rahe a rasakar sir ma ktyoha wait sei kralanare, ");
INSERT INTO slu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ma nusatke kyala kyosy a Sidon, ma kbya kola Gerar, ma ti kyait Gaza, maktei o kbya kola Sodom o Gomora, Adma, ode Zeboim, ma ti kyait o Lasa. ");
INSERT INTO slu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Iry desikre mumu neke, Ham tesnwo natu sir, ma ktyoha wait sei kralanare, ktyoha wait telare, ktyoha wait lasmyerare, ode ktyoha wait hnuare. ");
INSERT INTO slu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem neke Yafet wai ausw a i, ode iry a Eber-are ebnwo matrumat Sem. ");
INSERT INTO slu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ode Sem ananare sir ne: Elam, Asyur, Arpakhsad, Lud, ode Aram. ");
INSERT INTO slu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ananare sir ne: Us, Hul, Geter, ode Mas. ");
INSERT INTO slu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakhsad sawa-na idur hah ma ananke wamwany a i ma raki anike ti Selah, ode Selah sawa-na idur hah ma ananke ani Eber. ");
INSERT INTO slu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ode Eber sawa-na idur hah ma anan wamwankye enaru sir ma auskwe raki anike ti Peleg, kali kyoat taras radur ti i desy bonyo, iry mamin nuske ktem ne rahe a rasakar sir. Ode wai amurkye ani a Yoktan. ");
INSERT INTO slu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan ananare sir ne: Almodad, Selef, Hasarmawet, Yerah, ");
INSERT INTO slu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO slu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO slu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, ode Yobab. Sir ne mumu neke Yoktan anan sir. ");
INSERT INTO slu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yoktan tesnwo natu sir ne ramin ti lasmyer malol i bai Mesa ma kbya kola huarare ti Sefar, neke o a kseri timurke. ");
INSERT INTO slu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Iry desikre mumu neke, Sem tesnwo natu sir, ma ktyoha wait sei kralanare, ktyoha wait telare, ktyoha wait lasmyerare, ktyoha wait hnuare. ");
INSERT INTO slu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Iry rakesy ti nekre Nuh tesnwo natu sir, ma ktyoha ananare wait sei kralanare, ode wait hnuare. Ode kyala kyosy wer maluburke kimety desy ma ti kinait selsel ne, hnu mamin ti nuske ktem ne mumu neke rosy a Nuh ananare wait sei kralanare. ");
INSERT INTO slu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kyoat wer maluburke ktei ma ainare kiliku i bonyo, iry mamin lasmyerke khaha ne mumu neke ral tel sasamke, ma wait tun a khatunare mais. ");
INSERT INTO slu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lemade riar ma rba kola kseri timurke desikeo rait lasmyer maiske o a lasmyer Sinearke, dendye rmon ti wen desy. ");
INSERT INTO slu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Iry desikre it de byu ti it de byohe, “Mmya ma tba ti tal rayahkwe ma tala hatw batanare ode teh ma malkyakaw, ma bata desikre tal ma kyeluk hatw, ode tal terke ma tal ma tlatan bata desikre.” ");
INSERT INTO slu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Maktei bonyo rtanuk huruk de rbohe, “Mmya ma tawahuk ity ti ne ma tala hnu lanke it ma kete taskyui-taskyay ti lasmyerke khaha ne, ode ti hnu lan desy mmya ma tsadiri sey atatke it ma kyait laitke ma taobak kanike.” ");
INSERT INTO slu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Malmata iry mamin ti lasmyerke khaha ne rsadiri sey atat desy bonyo, YANWE yorw ma yatos hnu desy ktyabal sey atat rasadiri desy, ");
INSERT INTO slu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","lemade tyanuk ma byohe, “Iry nekre hnu sasam sir, ode tel sasam sir dakun. Mane khyehyeike o, sey atat rasadiri neke kamalkyau ne. Ode ana kiba knaru ne kolkya? Iry nekre rreky sai mo, ana kdi tike bo! ");
INSERT INTO slu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lemamo torw ba ti tahora-tasai wait telke, ma it de lema hye it wasi tel.” ");
INSERT INTO slu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Lemadendye YANWE iskyui-iskyay iry desikre ti nuske ktem ne mumu. Dendye ramres ma lema rala hnu lan desy. ");
INSERT INTO slu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Lemade kyala kyosy desy hnu lan desike raki kanike ti Babel ma ti kyait senwe, kali ti desike YANWE ihora-isai tel mamin lasmyerke khaha ne, ode ti desike dakun o YANWE iskyui-iskyay iry desikre ti nuske ktem ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem tesnwo natunare sir ne: Wer maluburke kmyety, ode ainke enaru ktyabal huruk bonyo, Sem wasi ainke atkwe sasam (100), desikeo sawa-na idur hahak naman wamwankye it, ma raki anike ti Arpakhsad. ");
INSERT INTO slu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem wasi ainke ktyabal ma atkwe enasim (500) huruk, ma ti klelan ain desikre kieluk i, Sem sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ode kyoat Arpakhsad wasi ainke hean-telw kresi enasim (35) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Selah. ");
INSERT INTO slu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpakhsad wasi ainke ktyabal ma atkwe enaat a kresi enatelw (403) huruk, ma ti klelan ain desikre kieluk i, Arpakhsad sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ode kyoat Selah wasi ainke hean-telw (30) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Eber. ");
INSERT INTO slu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Selah wasi ainke ktyabal ma atkwe enaat a kresi enatelw (403) huruk, ma ti klelan ain desikre kieluk i, Selah sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ode kyoat Eber wasi ainke hean-telw kresi enaat (34) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Peleg. ");
INSERT INTO slu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber wasi ainke ktyabal ma atkwe enaat a kresi hean-telw (430) huruk, ma ti klelan ain desikre kieluk i, Eber sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ode kyoat Peleg wasi ainke hean-telw (30) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Rehu. ");
INSERT INTO slu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg wasi ainke ktyabal ma atkwe enaru a kresi siw (209) huruk, ma ti klelan ain desikre kieluk i, Peleg sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ode kyoat Rehu wasi ainke hean-telw kresi enaru (32) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Serug. ");
INSERT INTO slu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu wasi ainke ktyabal ma atkwe enaru a kresi itw (207) huruk, ma ti klelan ain desikre kieluk i, Rehu sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ode kyoat Serug wasi ainke hean-telw (30) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Nahor. ");
INSERT INTO slu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug wasi ainke ktyabal ma atkwe enaru (200) huruk, ma ti klelan ain desikre kieluk i, Serug sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ode kyoat Nahor wasi ainke hean-ru a kresi siw (29) bonyo, sawa-na idur hah ma ananke wamwany a i, ma raki anike ti Terah. ");
INSERT INTO slu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor wasi ainke ktyabal ma atw ksala hean a kresi siw (119) huruk, ma ti klelan ain desikre kieluk i, Nahor sawa-na idur hahak naman wamfwet o wamwany. ");
INSERT INTO slu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ode kyoat Terah wasi ainke hean-itw (70) bonyo, sawa-na idur hahak anan wamwankye enatelw sir, neke Abram, Nahor, ode Haran. ");
INSERT INTO slu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","29","Terah tesnwo natu sir ne: Terah sawa-na idur hahak naman wamwankye enatelw, neke Abram, Nahor, ode Haran. Ode Haran isa ma sawa-na idur hahak naman wamwankye it ma ani Lot, ode wamfwetke enaru neke Milka yor Yiska. Kyoat Haran myaty ti nus radur i tike neke Ur-Kasdim, desikeo ama Terah myorif a nggora. Ode Nahor isaa yor Milka, neke Haran anan a i. Klala Abram isaa yor wamfwetke it ma ani Sarai. ");
INSERT INTO slu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Keskyede Sarai neke myakw ma lema ika anan. ");
INSERT INTO slu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Lemadendye Terah yor anan Abram, ode sobai Sarai, rtabal ebu Lot, neke raktemtem a riar toha Ur-Kasdim ma rbai lasmyer Kanaanke, keskye ranait hnu Haranke bonyo rmon ti desy. ");
INSERT INTO slu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ode Terah wasi ainke kyait atkwe enaru a kresi enasim (205) bonyo, myaty ti hnu desy. ");
INSERT INTO slu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","YANWE tyanuk ti Abram ma byohe, “Abram, mtwutuk amno waimw, ktyabal amamu seike, ode mbwetik toha hnuamw ma mbwai lasmyer ana kususu ti oke. ");
INSERT INTO slu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ana khwamela o ma nusamkwe lan, ode kal eraske ti o ma animkwe kimelir, ode khyali o, mane irire ratot eraske ne. ");
INSERT INTO slu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ode kolnye irire ral eraske ti o, desikeo ana kal eraske ti sir dakun, klala kolnye irire rsusnwo soba o desikeo ana kal atyatke ti iry desikre dakun. Ode kyosy a o mane, iry mamin ti lasmyerke khaha ne mumu wait sey kralanare ratot eraske.” ");
INSERT INTO slu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Lemade Abram byetik toha hnu Haranke ma ktyoha YANWE tun itanuk ti iare. Desikeo Lot a tyoha Abram ma raktem a rbetik toha hnu desy dakun. Kyoat Abram byetik toha hnu Haranke desikeo wasi ainke kyait a hean-itw kresi enasim (75). ");
INSERT INTO slu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram a bya o yor sawa Sarai, ode Lot, neke Abram wai Haran ananke, ma rba o rety wait lan o hnutat ode ror wait atare, neke ral sir toha hnu Haranke, ma raktemtem a rbai lasmyer Kanaanke ti ramin ti. ");
INSERT INTO slu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram rlakut a rlola lasmyer desy ma ti rait aw lan de lanke it ma kimin ti lasmyer Moreke, neke lema soso toha hnu Shikemke. Kyoat desyo iry Kanaan-are ramin ti desy dakun. ");
INSERT INTO slu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ti desike YANWE syusu I ti Abram, ode tyanuk ti i de byohe, “Ana kal lasmyer Kanaan ne ti tesnwo natumw.” Lemade Abram yal hature ma syadiri lat raeh heal ti YANWE, kali YANWE syusu tenanke ti Abram. ");
INSERT INTO slu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Lemadendye Abram syaur wasi laklakutke bai kseri tranke ti huarare o Betel kseri timurke. Ode rsadiri wait lasyerire ti hnu Betelke ode hnu Aike klelanke ma Betel kimin haratke, ode Ai kimin timurke. Ti desike dakun o yal hature ma syadiri lat raeh heal ti YANWE, ma syakitil ode syambayan ti YANWE. ");
INSERT INTO slu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Maktei bonyo Abram syaur huruk wasi laklakutke ma yosy wenke it ma byai wen idanare ma bya kola lasmyer Kanaanke kseri tranke ma ti yait Negeb. ");
INSERT INTO slu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kyoat desyo ti Kanaan neke lu o laar a ksyalik, dendye Abram byetik toha Negeb ma bya soso ei kseri tranke ti nus Mesirke ma imwakun ti. ");
INSERT INTO slu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ode Abram rala ma rsukar Mesir, desikeo tyanuk ti sawa Sarai de byohe, “Yaw ne khwe ohe oi neke eras o a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ode kolnye iry a Mesir-are ratos a o ana rbu de rbohe, oi neke sawakw a o, bonyo ana rtabahunw a yaw, ode rlura o ma mmworif. ");
INSERT INTO slu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lemadendye kolnye rena o desikeo mbwohe rahyetakw a o, ma yaw neke rala eras yaw ode rlura yaw ma kmworif khyali o.” ");
INSERT INTO slu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Dendye Abram rsukar Mesir bonyo, iry Mesir-are ratos a sir desikeo rbohe wamfwet desike eras i a ksyalik, ");
INSERT INTO slu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ode kyoat Firaun wasi melare ratos Sarai, desikeo rleru Sarai ersanke ti Firaun, lemade wamfwet desike ror i bai Firaun wasi sekye. ");
INSERT INTO slu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma ti ranait sekye bonyo, Firaun yala eras Abram kali dyakin wamfwet desy. Lemadendye Firaun yal a biby o, domba o, saby o, unta o, keledai wamfwet wamwany, ktyabal at wamfwet wamwany ti Abram. ");
INSERT INTO slu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Keskyede YANWE kyeyer kali Firaun yal Sarai Abram sawa desy. Lemade yal kbai atyat nekre ti Firaun, ktyabal iry mamin ti wasi sekye krala desy mumu. ");
INSERT INTO slu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Lemade Firaun yabuk Abram ma tyanuk ti i de byohe, “Abram o, kali tot sai ne muala ma yaw ne de? Kyanmwane lema mulosu de mbwohe sawamu i ne wamfwet ne de? ");
INSERT INTO slu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ode kyanmwane mutanuk de mbwohe, wamfwet ne rahyetamw a i, ma khyury ma kal i ma kusaa kor i ne de? Lemade senweke mal sawamw, ode adoko mbya!” ");
INSERT INTO slu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Dendye Firaun yal haretke ti wasi irire ma rtian Abram yor sawa Sarai, ror wait atare, ktyabal lan o hnutat o wait biby o, domba o, saby o, unta o, keledai desikre mumu ma rbetik toha Mesir. ");
INSERT INTO slu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Lemade Abram byetik toha Mesir ma yulak i bai lasmyer Negebke yor sawa Sarai ktyabal wait lan o hnutat, ode biby o, saby o, domba rtabal wasi makaryaare, ode kyoat rabetik toha Mesir bonyo Lot tyoha sir dakun. ");
INSERT INTO slu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram neke wasi malolkye lan, ma wasi blyawan kunkuny o bokbok ribun, ktyabal wasi domba o, biby o, saby nekre ribun sir dakun. ");
INSERT INTO slu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram neke byai wenke it maktei o byai wenke it huruk, ma yosy a lasmyer Negebke ma yolik i bai lasmyerke it ti hnu Betelke ode hnu Aike klelanke, neke wen a kyoat inait a kmuna ma isadiri lasyerkye tike. ");
INSERT INTO slu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Lemadendye yal hature ma syadiri lat raeh heal ti YANWE, ode Abram syakitil ma syambayan ti YANWE ti desy. ");
INSERT INTO slu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Kyoat desyo Lot tyoha Abram dakun. Ma Lot neke wasi malolkye lan dakun neke ika wasi domba o, biby o, saby o lasyery, ktyabal wasi sekye kralake ode wasi makaryaare dakun. ");
INSERT INTO slu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Keskyede lasmyer ramin ti desike lema kyait ma raktem a ramin ti, kali wait lan o hnutat ribun, ktyabal wait domba o, biby o, saby nekre ribun sir ma lema raka wenat. ");
INSERT INTO slu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ti desy dakun o iry Kanaan-are rtabal iry Feris-are radurak lasmyer desy. Ma lasmyer desike kbyenw ti irire. Dendye Abram yor Lot wait iry malaka healare railir khyali wenke. ");
INSERT INTO slu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Lemadendye Abram tyanuk ti Lot de byohe, “Oi neke anakw a o, ma lema eras ma tailir ode wasikw irire ror wasimw irire railir dakun, kali waiku anan a o. ");
INSERT INTO slu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lemade matos, lasmyer neke lan a nggora ma tamin ti. Lemade kuten toha o ma lemamo tahe lasmyer ne, ode kyosy a o bo ma mdwakin ma milik lasmyer ne kseri kabei bo, ma kolnye mbwai kseri tranke desike bonyo ana kbwai kseri seryabke, dete kolnye mdwakin ma mbwai kseri timurke desikemo ana kbwai kseri haratke.” ");
INSERT INTO slu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lemade Lot yatos ti de yatos ma ti ktebteban Yordanke ma ti kyait Zoar, neke lasmyer maiskye kmyesan, ode lasmyerke werwer kola lasmyer Mesirke, ode kola lasmyer bo Eden YANWE ialake dakun. Kyoat Lot yatos ti ktebteban Yordanke ne, desyo YANWE lenla syolyo syarah hnu Sodom o Gomora ba. ");
INSERT INTO slu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lemade Lot yilik ktebteban Yordanke ktem desy mumu. Dendye deruke rasali sir, ma Lot byai kseri timurke, ");
INSERT INTO slu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","klala Abram imin ti lasmyer Kanaanke bo. Lemade Lot byai ktebteban Yordanke ti imin hnu a klelan desikre, ode yilik wenke it ma knyey hnu Sodomke ma syadiri wasi lasyerkye ti. ");
INSERT INTO slu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ode hnu Sodom neke dakun o iry mamin tiare rahatw ksyalik, ode rasal ti YANWE. ");
INSERT INTO slu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lemade kyoat Abram yor Lot rasali sir ma Lot iba bonyo, YANWE byu ti Abram de byohe, “Abram o, mbwitil matamkwe ode matos ei lasmyer a kseri timur so, harat so, tran so, ode seryab so, ");
INSERT INTO slu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","kali lasmyer muatos desikre mumu neke ana kal ti o a mor tesnwo natumw ma wasimy ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ode kal eraske ti o ma ana tesnwo natumw nekre ribun sir kola dene laran mamin namwatake ne. Ma lema kika iry maaki kyal laran ne, kola dene ana tesnwo natumw lema kika iry maaki kyal sir dakun. ");
INSERT INTO slu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lemadendye kyala kyosy neke mlwakut ma mulili lasmyer ne, kali ana kal lasmyer ne ti o mumu.” ");
INSERT INTO slu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Lemadendye Abram hyuty wasi lasyerkye huruk, ode bya ti syadiri ti aw lan de lan nekre krintyotanare ti Mamre wasi lasmyerke neke knyey a hnu Hebronke ma imin ti desy. Ode ti wen desike dakun o Abram yal hature ma syadiri lat raeh heal tike, ma kyalamo syob ti YANWE. ");
INSERT INTO slu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kyoat desyo raja nus lanke enaat, neke raja Amrafel yosy nus Babiloniake, raja Ariokh yosy nus Elasarke, raja Kedorlaomer yosy nus Elamke, rtabal raja Tideal yosy nus Goyimke, ");
INSERT INTO slu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ode raja nus lan deat neke ramdiriat ror raja hnuke enasim, neke raja Bera yosy hnu Sodomke, raja Birsya yosy hnu Gomorake, raja Syinab yosy hnu Admake, raja Syemeber yosy hnu Zeboimke, rtabal raja hnu Belake, ma selsel ne hnu Bela neke rhaly ti Zoar. ");
INSERT INTO slu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Raja hnu desim neke ratun ma rawahuk wait suldatare ti ktebteban Sidimke, ma selsel neke rhaly o Tasi Mkeske. ");
INSERT INTO slu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ktela neke kdi ti kali raja Kedorlaomer hyareta raja hnu desim desy kyal nini ainke hean a kresi enaru. Keskyede ti ain hean a kresi enatelkwe bonyo, raja hnu desim desike rawahuk sir ma rohut ma kete rtomolu toha i de. ");
INSERT INTO slu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ode ti ain hean a kresi enaatke bonyo, raja Kedorlaomer yor raja matoha iare rtabal wait suldatare, rbetik toha nusatare ma ramdiriat ror iry Refa-are o a hnu Asyterot-Karnaimke, iry Zuz-are o a hnu Hamke, iry Em-are o a lasmyer Syawe-Kiryataimke, ");
INSERT INTO slu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ktyabal iry Hori-nare ti wait huarare ma kani a Seir. Ode raja Kedorlaomer radoha iry desikre nini rait El-Paran ti wen malosy-loskye kserike. ");
INSERT INTO slu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Maktei bonyo rulak sir mai En-Mispat, ma selsel neke rhaly ti Kadesh, ode rala ral iry Amalek-are ma rhareta iry desikre wait lasmyerke mumu, rtabal iry Amori mamin ti hnu Hazezon-Tamarke. ");
INSERT INTO slu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Lemadendye raja hnu desim ne, neke raja hnu Sodomke, raja hnu Gomorake, raja hnu Admake, raja hnu Zeboimke, rtabal raja hnu Belake, rawahuk wait suldatare ti ktebteban Sidimke ma ramdiry eta wait hnuare, ");
INSERT INTO slu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kali raja nus lan deat ne, neke raja Kedorlaomer yosy nus Elamke, raja Tideal yosy nus Goyimke, raja Amrafel yosy nus Babiloniake, ode raja Ariokh yosy nus Elasarke, rala ma rma ma ramdiriat ror raja hnu desim desy. ");
INSERT INTO slu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ma ramdiriat bonyo, raja hnu desim desike lema malkyakaw sir, dendye rala toha inamdiriatke. Ode raja hnu Sodomke yor raja hnu Gomorake ror wait suldatare rala ti ktebteban Sidimke ma suldatare dum a rdi ei kuran ter a kralanare, kali ti ktebteban Sidimke ne, kuran ter-are kimin ti kabei ta kabei bo. Klala raja hnu idanare ror wait suldatare ra-la ti rabunw oa huarare. ");
INSERT INTO slu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Lemade raja nus deat mamdiriat manor sir desikre rbai hnu Sodomke ode hnu Gomorake ti rasoruk wait a lan o hnutat, ode ral wait saby o biby o domba o ktyabal hinat kotw o abw nekre ma ralaka ba mumu. Ode rkumak iry mamin ti wait sey kralanare ma ror sir ba dakun. ");
INSERT INTO slu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kyoat desike dakun o raja desikre rkumak Lot, Abram wai-na anan desy, ktyabal wasi lan o hnutan o nam ribun lan nekre dakun, kali kyoat desike Lot imin o a hnu Sodomke. ");
INSERT INTO slu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Keskyede iry mala toha inamdiriatke it a ila ma mya ma ihes a ktela desikre mumu ti Abram, iry Ibrani desy. Kyoat desike Abram imin wenke it ma knyei Mamre iry Amori desike wasi aw lan de lan nekre. Ti desike dakun o Mamre yor wainare, neke Eskol ode Aner. Iry detelw ne ror Abram de kola ratutuk tun ma it de syaluk it. ");
INSERT INTO slu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kyoat Abram itomolu britke ohe wai-na ananke rakumak i ti inamdiriatke kralake ne bonyo, yal haretke ti wasi iry mahe inamdiriat a ksalanare. (Iry nekre radur hahak sir ti Abram wasi lasyerire, neke aryaritke atkwe enatelw ksala hean a kresi walw (318).) Lemade Abram ror sir de radoha raja nus deat desike ror wait suldatare ma ti rait hnu Danke. ");
INSERT INTO slu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ode sewahke bonyo, Abram yor wasi irire raka darkye eta sir ma rhou iry desikre ror wait suldatare, ma Abram wasi irire rala ral sir ma radoha sir ma ti rait a Hoba, neke kimin ti hnu Damsyikke kseri seryabke. ");
INSERT INTO slu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Maktei bonyo Abram rulak sir ma rma ma ral a rolik iry a Sodom o Gomora wait lan o hnutat o nam ribun lan nekre mumu, ma ral Lot wai-na anan desy dakun ktyabal wasi lan o hnutan o nam nekre, ode ral dakun a wamfwet o iry rakumak ti inamdiriatke krala desy. ");
INSERT INTO slu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ode Abram yala yal raja Kedorlaomer yor raja manor iare maktei bonyo, yolik i toha inamdiriatke. Desike bonyo raja hnu Sodomke byetik ma mya ma ikita i ti Ktebteban Syaweke, neke kyalamo rhaly o Ktebteban Rajake. ");
INSERT INTO slu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ode Melkisedek neke raja hnu Salemke, ode i neke iry mabaa klen ti irkye yor Hulasow Lan Lahukke. Kyoat desyo mya dakun ma yety rotkye ktyabal tasy maiskye kwen makitkye ti Abram. ");
INSERT INTO slu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Maktei bonyo yal eraske ti Abram ma byohe, “Kuten Hulasow Lan Lahuk maala lait o lasmyerke khaha ne ma yal eraske ti Abram oi ne. ");
INSERT INTO slu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ode klweru Hulasow Lan Lahukke anike, kali yal malkyakakwe ti o ma mala mal iry mumdiriat munor sirare.” Lemade Abram itomolu Melkisedek tunanare bonyo nam inety desikre mumu neke yal sasam toha heanke ma yal ti Melkisedek. ");
INSERT INTO slu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Lemade raja Sodomke byu ti Abram de byohe, “Abram o, lemamo mal a molik wasikw irire ma yaw, klala ara wasimy lan ribun desikre mal ma oa mosy.” ");
INSERT INTO slu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Keskyede Abram hyalas raja Sodom desy de byohe, “Kuhwab ti YANWE Hulasow Lan Lahuk maala lait o lasmyerke khaha ne, ");
INSERT INTO slu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ma kbwohe ana lema kal namit-namit toha o elik, ma olaske klaike ta sososa lwakwe ktasike dakun o ana lema kal, ma kyait o kete mbwohe khyali o mane kuka wasikw maloly ne. ");
INSERT INTO slu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Lemade yaw neke kor wasikw irire lema aramy myal namit-namit de kotw aramy mina dai desy bo. Keskyede liakw manor yaw nekre, neke Aner, ode Eskol, ode Mamre, sir ne musti mo rosy wat toha nam kunal kolik desikre.” ");
INSERT INTO slu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Lemadendye YANWE mya ma syusu I ti Abram ode tyanuk ma byohe, “Abram o, kete mumtaut kali ana kbwa eta o ti atyatke ode kal watamkwe ti o dakun o lan a ksyalik.” ");
INSERT INTO slu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Keskyede Abram hyalas YANWE de byohe, “Ebukw YANWE O, nam sai ne ana munal ma yaw ne de? Ana kmwaty bonyo Eliezer iry Damsyik neke iry makarya ma yakwe, ana idurak seikkwe ma syaa i ti malolikw ribun lan munal ma yaw ne, kali lema mal naman ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Keskyede YANWE tyanuk huruk ti Abram de byohe, “Iry makarya ti o desike ana lema syaa i ti malolimw desikre, de ana anamw elik-elik ne i ne isaa i ti malolimw desikre ne.” ");
INSERT INTO slu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Maktei bonyo YANWE yor Abram ma rbetik toha lasyerkye ei mloskye, ode tyanuk ti i de byohe, “Abram o, matos ei laitke, ode maki a thun nekre. Ana lema maki mal sir. Kola dene ana lema raki ral tesnwo natumw aryaritke dakun.” ");
INSERT INTO slu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Lemade Abram tyohak YANWE tun itanukare, dendye YANWE byohe “Abram neke iry a mlakye.” ");
INSERT INTO slu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Maktei bonyo YANWE byu ti Abram huruk de byohe, “YANWE a Yaw, ma kola kulaka o ma mbyetik toha hnu Ur-Kasdimke, ma ana kal lasmyer Kanaan neke ti mosy mumu.” ");
INSERT INTO slu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Desikeo Abram yena Hulasokwe de byohe, “Ebukw YANWE O, kyosy kabei mane kuhe o lasmyer neke ana kunosy ne de?” ");
INSERT INTO slu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Lemade YANWE hyalas i de byohe, “Desikemo mal heal a wait ainare nenmo kinait enatelw desikre, neke saby wamfwetke sasam, biby wamfwetke sasam, ode domba wamwankye sasam, ktyabal manu lakterkwe ode manu hahkye ratsam-ratsam ma Yaw.” ");
INSERT INTO slu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Dendye Abram yal heal desikre ti YANWE, neke saby o biby o domba desikre ratsam-ratsam ode syin sir ti kbya raru. Maktei bonyo tyenuk heal a kseri desikre ma it de kisara it ti desy, keskyede manu deru desike lema syin a sir. ");
INSERT INTO slu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ode manu alal kyalamo mana heal a mamaty nekre rma ma rtuny a heal dai Abram isin ti kiba raru desikre bonyo, Abram yesak sir. ");
INSERT INTO slu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lemade kyala ma sekwe idi bonyo, Abram yenah ma tyebti desy. Ode klatsam mait bonyo, kelerakok lanke kmya ma kyety matautke ma kdyan i ti desy. ");
INSERT INTO slu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Lemade YANWE byu ti Abram de byohe, “Klwosu ti o ma mhwe elik ohe tesnwo natumw nekre ana mwakun sir ti irire nusat, ode ana raka at ti iry desikre dakun, ode iry desikre ana rala atyat sir ainke atkwe enaat. ");
INSERT INTO slu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Keskyede nus ana raka at ti desike, ana kukun sir, ode kyoat tesnwo natumw a rbetik toha nus desy, desikeo ana rba o rety maloly ribun lan ne. ");
INSERT INTO slu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Keskyede oi ne ana wasimw ainke lan ma kryesik iry ribun lan ne, desikeo nenmo mmwaty. Ma ti ramlin a o mosy eraske. ");
INSERT INTO slu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Keskyede ana taras enaatke bonyo nenmo tesnwo natumw rulak sir mai ne, neke lasmyer Amorike, kali senwe iry Amori-nare wait lim o sal lenla kyoat. Keskyede taras enaat desike ana kdi ti ode iry Amori-nare wait lim o sal ne kyoat mumu, desikeo nenmo tesnwo natumw resak a iry Amori desikre.” ");
INSERT INTO slu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ode sekwe idi ma kelerkok bonyo, kele rsoru akye kwenake it ma kdyuhan ktyabal hadukke it ma kdyelaf ma kmya ma kyosy heal rasin ti kiba raru desikre klelanke. ");
INSERT INTO slu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kyoat sew desike dakun o YANWE ihatetak ti Abram ma tyanuk ti i de byohe, “Kuhatetak ti o ohe kal lasmyer ne mumu kyala kyosy sah Mesirke ma ti kyait sah Efratke ti tesnwo natumw. ");
INSERT INTO slu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Lasmyer neke iry Keni-nare, iry Kenas-are, iry Kadmon-are, ");
INSERT INTO slu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","iry a Het-are, iry Feris-are, iry Refa-nare, ");
INSERT INTO slu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","iry Amori-nare, iry Kanaan-are, iry a Girgasi-nare ode iry Yebusi-nare raktemtem ne mumu wait lasmyerare kal ti tesnwo natumw ma rosy.” ");
INSERT INTO slu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai neke Abram sawa i, ma lema ika anan, ode wasi atke it ma wamfwet a i neke yosy Mesir, ma ani Hagar, ");
INSERT INTO slu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ode sekwe it bonyo Sarai byu ti lai Abram de byohe, “Awa, mhwe ohe YANWE lema byuma kuka anakw, lemamo ti menah mor wasikw at desy. Anakyai kyosy a i, desyo idur hahak namanke it ma yaw.” Lemade Abram tyoha tun sawa-na itanuk desy. ");
INSERT INTO slu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lemadendye Sarai yal Hagar iry Mesir desy ti lai Abram ma ramruan a i. Ode kyoat desikeo Abram imin ti Kanaan ainke hean de. ");
INSERT INTO slu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Lemade Abram yenah yor Hagar. Desike bonyo Hagar yor tenanke, ode Hagar ihe ma inor tenanke bonyo, yaran wasi lalan Sarai ode ihmwai i. ");
INSERT INTO slu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Dendye Sarai tyanuk ti Abram de byohe, “Awa, salamkwe ne. Kali kal wasikw atke ti o ma menah mor i, ma inor tenanke bonyo, yaran yaw ode ihmwai yaw. Lemamo YANWE yukun tun ne ti oa mor a yaw.” ");
INSERT INTO slu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Desike bonyo Abram hyalas sawa Sarai ma byu de byohe, “He. Kolnye, at desike iry muharetake, de kyosy a o ma mala i kolkyabei ta kabei bo.” Dendye Sarai yala atyat ma ksunw lanidik ti Hagar, lemadendye Hagar ila toha sir. ");
INSERT INTO slu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ode Hagar lyakut ma bya nini inait werke kmatake it ti wen malosy-loskye bonyo, YANWE wasi Nyasoke mya ma inal a yor i. Werke kmata neke knyey a sal maba kola nus a Syurke kserike. ");
INSERT INTO slu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Lemade YANWE wasi Nyasoke tyanuk ti i de byohe, “Hagar o. Oi ne mkwarya ti Sarai. Mala kolkyabei mane mumai ne de, ode mala ma mbwai kabei ne de?” Desikeo Hagar hyalas I ma byu de byohe, “Kula toha Sarai enakw kukarya tike.” ");
INSERT INTO slu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Lemade YANWE wasi Nyasoke tyanuk huruk de byohe, “Molik o ma mbwa ti mait enamw Sarai mukarya ti desy, ode mala tenamkwe ma ne hah ne bo. Ode kyosy a i ma yala o kolkyabei ta kabei o, mtwoha bo. ");
INSERT INTO slu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kali ana kala o ma tesnwo natumw ribun sir a ksyalik, ma lema kika iry maaki kyal sir, ");
INSERT INTO slu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ode ana lema soso bonyo mudur hahak naman wamwankye it, desikeo maki anike ti Ismael kali YANWE tyomolu o ma mswer ti muhar ktela atyat ribun ne. ");
INSERT INTO slu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ode anamw desike ana mormyorhyanke kola keledai mata mnaske, ma ihatw, ode syorw kabei ta kabei bo. Ode iry kabei ta kabei dakun o ana isorw a ike dakun bo. Ode ti wen a imin tike, ana lema tyomolu waike it elik.” ");
INSERT INTO slu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Lemade Hagar byu ti YANWE matanuk tun ti i ne de byohe, “Desikemo kaki animkwe ti El-Roi.” Maktei bonyo Hagar ryekan ti ralake de byohe, “Mlay bain, ti wen neke katos a Hulasow maseak yaw ne.” ");
INSERT INTO slu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mane irire raki werke kmata desy ti “Wer Lahai-Roike.” Wer desike kimin ti hnu Kadeshke ode hnu Beredke klelanke. ");
INSERT INTO slu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Lemadendye Hagar idur hahak naman wamwankye it ti Abram, ma Abram yaki naman desy anike ti Ismael. ");
INSERT INTO slu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ode kyoat naman wamwany desy radur ti i bonyo, Abram wasi ainke hean-walw kresi nem (86). ");
INSERT INTO slu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kyoat Abram wasi ainke hean-siw kresi siw (99) bonyo, YANWE mya ma syusu I ti i ma byohe, “Abram o, Yaw neke Hulasow Malkyakaw Lahuk Yaw. Mtwomolu Yaw, ode mtwoha tun kutanukare ode mmworif mo nelnyely a o. ");
INSERT INTO slu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Dendye ana kuhatetak kor a o, ode kala o ma mmwel ma ribun o ratut e.” ");
INSERT INTO slu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lemade Abram syakitil ti I, ode Hulasokwe tyanuk huruk de byohe, ");
INSERT INTO slu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tnyetak kunor a oke ne: Yaw ne kala o ma tesnwo natumw ribun sir ma rala nus ti lasmyerke khaha ne, ode iry mamin ti nus desikre mumu ne amat a o, ");
INSERT INTO slu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","dendye ana lema animw a ‘Abram’ de, de animw a ‘Abraham’, kali ktwetak de, ma ana tesnwo natumw ribun sir ma rala nus ti lasmyerke khaha ne, ode iry mamin ti nus desikre mumu ne amat a o. ");
INSERT INTO slu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yaw ne ana kala o ma tesnwo natumw ribun ratut sir ma rala nusare ti lasmyerke khaha ne, ode kyosy sir dakun o ana dum a raka raja. ");
INSERT INTO slu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ode ana wasikw hatetak neke lema kimres, de kuhatetak ti ituru ma ti kyal tesnwo natumw ma ti ktyutw teike, ma wasimw Hulasow a Yaw, ti kyal tesnwo natumw nekre mumu. ");
INSERT INTO slu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ode lasmyer Kanaan mumwakun ti ne ana kal mumu ti o a mor a tesnwo natumw ma midurak ode mmyon ti, ti kiba knaru ne. Ode ana tesnwo natumw wait Hulasow a Yaw.” ");
INSERT INTO slu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Maktei bonyo Hulasokwe tyanuk ti Abraham huruk de byohe, “Oi neke mor ebnwo anamw ma ti kyal tesnwo natumw musti mo mtyoha haret a kutunik ti e ne ti kiba knaru ne: Ma oi neke ana mor tesnwo natumw wamwanire mumu neke musti mo ratosa tenamire. ");
INSERT INTO slu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Lemade kyala kyosy ne, naman wamwany a radur ti sir ma kolnye wait sekwe walw (8), desikeo ratosa tenatare, ma ktyoha haret a kutunik ti o ne. Ode o dakun o mor wamwany mamin wasimw sekye krala desy, rtabal wamwany makarya ti seimw desike, ror atamw wamwany muselw desikre mumu, neke musti mo ratosa tenamire dakun. Ode myatosa tenamire koldyesy ma mnyenas myal tnyetak a kuhatetak kor oke. ");
INSERT INTO slu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Lemadendye wamwany desikre mumu musti mo ratosa tenatare ma ktyoha haret a kutunik ti o ne. Rala koldyesy ma ranenenas tnyetak a kuhatetak ti oke ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ode kolnye wamwany kabei lema ratosa tenanke, desikemo wamwany desike resak i toha wasi irire, kali lema tyoha haret a kutunik ti o ne.” ");
INSERT INTO slu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Maktei bonyo Hulasokwe byu ti Abraham de byohe, “Kete mabuk sawamw ti Sarai de, de kyala kyosy neke mabuk i ti Sara. ");
INSERT INTO slu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ode kal eraske ti i, ma ana idur hahak naman wamwankye it ti o. Ode kal eraske ti i huruk ma ana tesnwo natu ribun ratut sir ma rala nusare ti lasmyerke khaha ne, ode iry mamin nus desikre mumu enat a i, ode ana tesnwo natu nekre dum a raka Raja ti nusare.” ");
INSERT INTO slu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Lemade Abraham syakitil ti Hulasokwe, keskye imahis ode ryekan ti ralake ma byohe, “Neke mlay e? Mane wasikw ainke atw de (100). Ode amosw a yaw de. Ode ana kuka anakw huruk e? Ode ana Sara ika anan kolkya, mane wasi ainke hean-siw (90) deny ode?” ");
INSERT INTO slu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dendye byu ti Hulasokwe de byohe, “Ebukw Hulasow O, lemamo Ismael ana yosy eras munal ma yaw nekre bo.” ");
INSERT INTO slu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Keskye Hulasokwe tyanuk ti i de byohe, “Abraham o, lema koldyesy! Sawamw Sara desike ana idur hahak naman wamwankye it ti o, desikeo maki anike ti Ishak. Ode tnyetak kuhatetak kunor o desy ana kal ti Ishak dakun, ma ti kyal tesnwo natu nekre ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Keskyede ktwoha nam mutenke. Lemade ana kal eraske ti Ismael dakun, ode tesnwo natu ana rmel ma ribun ratut sir. Ode Ismael neke ana rajake hean a kresi enaru (12) amat a i, ode tesnwo natu ana khwamela sir ma nusatke lan. ");
INSERT INTO slu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Keskyede tnyetak kuhatetak neke ana kkwau kor Ishak. Ode lenla ainke sasam huruk, desikeo Sara idur hahak Ishak ti o.” ");
INSERT INTO slu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kyoat Hulasokwe itanuk maktei bonyo bya toha Abraham. ");
INSERT INTO slu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ode ti sew desike dakun o Abraham yabuk anan Ismael yor wamwany mamin ti wasi lasyery krala desikre, ror wamwany iselw desikre mumu ma yatosa tenatare ma ktyoha haret a Hulasokwe itunik ti i desy. ");
INSERT INTO slu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ode kyoat Abraham ratosa tenanke, desikeo wasi ainke kyait hean-siw kresi siw (99), ");
INSERT INTO slu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","klala kyoat a ratosa Ismael tenanke desike bonyo wasi ainke hean a kresi enatelw (13). ");
INSERT INTO slu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Lemadendye, ti sew desy dakun o, Abraham yor anan Ismael, rtabal a wamwany mamin ti Abraham wasi lasyery krala desikre raktemtem mumu ne ratosa tenatare. ");
INSERT INTO slu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kyoat a Abraham imin ti wenke it ma knyey Mamre wasi aw lan de lan desikre, ode sekwe it bonyo, YANWE mya ma syusu I ti Abraham. Kyoat desyo Abraham tyaklulw ti wasi salhaha lasyerkye, kali sekwe manas i a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ode kyoat ibitil matake bonyo, myatakit irkye enatelw ma ramdiry ti lasyerkye lulkwe. Lemade Abraham imdiry ma ila yosy wasi lasyerkye ma ti iney a sir bonyo syakitil ti sir, ");
INSERT INTO slu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ode byu de byohe, “Amakw e, kete mkyeyer a yaw. Kuten ma kete mbya de mmya de mtyaklulw aduk. ");
INSERT INTO slu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ode mtyaklulw akwe kmauan ne ma mihnaw e aduk, ma lemamo kbwa ti kal werke tebikan ma myut lwaumire, ");
INSERT INTO slu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ode kbwa ti kal a rotkye it ma mi, ma kyakora e aduk, mamode mbyai kabei ta kabei o kyosy e bo. Kali kolnye amakure mtyaklulw ti wenakw kumin ti ne desikemo ketimdedan.” Lemade iry desikre rhalas i ma rbohe, “Desikemo mala kola mutanuk desy.” ");
INSERT INTO slu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Lemade Abraham lyahlaha mirin ti syukar wasi lasyery desy ti yait Sara, ma byu ti i de byohe, “Mlwaha mirin ma mal gandumke kminan eras desike kadutke sasam ma mal ma mala rotire.” ");
INSERT INTO slu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Maktei bonyo Abraham ila byai wasi saby o domba wenat, ma ti yilik saby anan mamsun eras-eras ne it, ma yal ti wasi makaryake it ma kyarya heal desy mirin. ");
INSERT INTO slu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Maktei bonyo Abraham yal bibkye wasi suskwe kwenke ode kejuke ktyabal heal dai ranoha desy ma yal ti iry desikre ra, ode imdiry ti akwe kusuke ma lema soso toha iry desikre wen raknam tike. ");
INSERT INTO slu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Raknam maktei bonyo, rena i de rbohe, “Sawamw Sara ikabei de?” Desyo Abraham hyalas ma byohe, “I so lasyerkye kralake.” ");
INSERT INTO slu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Dendye iry desikre it a byu ti i de byohe, “Ana ainke sasam huruk, kolik a yaw ma kait a o. Ma lenla kunait a o bonyo, mlay bain o sawamw Sara idur hah de, ma ananke wamwany a i.” Kyoat desikeo Sara imin ti salhaha lasyery desike, ma iry desikre rsanyetat a i, ode Sara tyomolu iry desike tun itanukare. ");
INSERT INTO slu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Keskyede Abraham yor sawa Sara neke enmosw o amosw sir de, ma lema raka anat de. ");
INSERT INTO slu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Dendye Sara imahis ti ralake ma byohe, “Yaw neke enmosw a yaw de, ode laikw dakun o amosw i de, ode ana aramy myala kolkyabei ma aramy mitot naman ma aramy mimukmuka aramy de?” ");
INSERT INTO slu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Lemade YANWE tyanuk huruk ti Abraham de byohe, “Kyanmwane Sara imahis ma byu de byohe, ‘Ana mlay bain o kudur hahak namanke it e? Mane enmosw a yaw deny ode?’ ");
INSERT INTO slu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Keskyede nam sai YANWE lema yala hye de? Kola nenmo kutanuk ti o ne: ainke sasam desikeo kulak Yaw ma kait a o, kyoat desy dakun o Sara idur hah de ma ananke wamwany a i.” ");
INSERT INTO slu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Dendye Sara imtaut, mane tyuly ma byohe, “Yaw ne lema kumahis.” Keskyede YANWE hyalas i ma byohe, “Ah, mlay bain o dai mumahis de.” ");
INSERT INTO slu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ode kyoat iry desikre raknam maktei bonyo, ramdiry ma rba. Desikeo Abraham lyakut yor sir ma kele syeak ti sir ode rlakut ba nini ranait kususwanke bonyo ranunu ei hnu Sodomke ti ktebteban Yordanke. ");
INSERT INTO slu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Desike bonyo YANWE ryekan ti ralake kralake ma byohe, “Nam kala ma kuala nekre kubrai kuhunik ti Abraham, ");
INSERT INTO slu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kali ana Abraham tesnwo natu ribun sir ma nusatke lan a ksyalik ode rhareta. Ode kyosy a i, ana kal eraske ti nus mamin ti lasmyerke khaha neke mumu. ");
INSERT INTO slu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Abraham kilik i ma ana yal haretke ti anan o tesnwo natu ma rtomolu Yaw ma rmorif eras ode ramdiry ti nam a mlaire, desikemo ana ktwoha tnyetak kuhatetak ti Abrahamke.” ");
INSERT INTO slu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Maktei bonyo YANWE tyanuk ti Abraham ma byohe, “Ktwomolu o irire rarwen kali iry a mamin ti Sodom ode Gomora nekre rahatw ode totatare atyat a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Lemamo korw ma ti katos, neke mlay bain o iry nekre totnyo yabit kola dene irire ratanuk ma Yaw ne ta lema de. Ma kolnye nam ratanuk ma Yaw nekre mlay mo khwe ode sal mo khwe dakun.” ");
INSERT INTO slu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Dendye irkye enaru rorw ma rbai a Sodom, keskyede YANWE yor Abraham ramdiry ti desy bo. ");
INSERT INTO slu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Lemadendye Abraham ti nyey a YANWE ode tyanuk de byohe, “Kolkyabei mane ana mutabahunw iry a mlay o iry maka salatare raktemtem ne de? ");
INSERT INTO slu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kolnye iry a mlaire hean-sim (50) ramin a hnu desy, desikemo ana mtwuhar a hnu desike dakun e, de lema maorif a hnu desike khyali iry a dehean-sim a mlay desy e? ");
INSERT INTO slu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kete mala koldyesy ode kete mala namit-namit ma ktyabahunw iry a mlaire kola iry maka salatare. Lemamo maditi nam maoly desikre toha O. Kali Oi ne mtwetak tunke ti iry a mamin ti lasmyerke khaha ne, ode khwe ohe ana mohut a mlakye bo.” ");
INSERT INTO slu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Lemade YANWE tyanuk de byohe, “Kolnye kait irkye hean-sim (50) ma ramorif neke rala nam a mlaire bo ti hnu Sodomke, desike bonyo lema ktwuhar hnuke ktem desy mumu khyali iry desikre.” ");
INSERT INTO slu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Keskyede Abraham hyalas huruk ma byohe, “Ebukw O, kuten ma kete mkweyer a yaw ti kures a O ma ktwanuk a kswaur tunakure ei lulkwe huruk ne, kali yaw neke iry a yaw bo. ");
INSERT INTO slu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Keskyede kolnye iry a ramorif ma rala nam a mlaire ne lema rait hean-sim, de irkye hean-at a kresi enasim sir (45) bo. Ode khyali ktera desim desy bonyo ana mtwuhar hnu desy ba mumu khyali iry a desim desy e?” Desike bonyo Hulasokwe byohe, “Kolnye kutot iry a mlakye hean-at a kresi enasim sir, desikemo hnu desike ana lema ktwuhar ba.” ");
INSERT INTO slu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Lemade Abraham tyanuk huruk de byohe, “Ebukw O, ode kolnye irkye hean-at sir (40) bonyo kolkya?” Desyo Hulasokwe hyalas i de byohe, “Ana lema kala koldyesy, khyali iry dehean-at desike.” ");
INSERT INTO slu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Desikeo Abraham ikita ma tyanuk huruk ma byohe, “Ebukw O, kolnye kutun huruk mo kete mkweyer a yaw, kolnye mutot iry a mlakye hean-telw (30) sir o so bonyo kolkya?” Desyo Hulasokwe byohe, “Kolnye kutot iry a mlakye hean-telw sir o so bo, desikeo ana lema kala namit-namit.” ");
INSERT INTO slu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Keskye Abraham byu huruk de byohe, “Ebukw O, kuten ma kete muka keyer a yaw, kolnye kswaur tunakure ei lulkwe huruk. Ebukw Hulasow O, kolnye irkye hean-ru sir (20) mo, kolkya?” Desyo Hulasokwe hyalas ma byohe, “Kolnye kutot irkye hean-ru sir, desike bonyo hnu desike ana lema ktwuhar ba.” ");
INSERT INTO slu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Lemadendye Abraham tyanuk huruk de byohe, “Ebukw Hulasow O, kete muka keyer a yaw kolnye ktwanuk it huruk. Kolnye mutot irkye hean (10) sir mo kolkya?” Desyo Hulasokwe hyalas i de byohe, “Kolnye irkye hean sir, desyo hnu desike ana lema ktwuhar ba.” ");
INSERT INTO slu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ode YANWE itanuk ti Abraham maktei bonyo bya, ode Abraham yulak i ma myai wasi lasyerkye. ");
INSERT INTO slu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Hulasokwe wasi nyaso deru manosy lait desy rait Sodom o sekwe bya. Sew desy dakun o Lot tyaklulw ti salhaha lorkye kmatake ode iatos iry desikre bonyo, imdiry ma ti byalan sir, lemade syakitil ti sir, ");
INSERT INTO slu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ode tyanuk ti sir de byohe, “Amam lan e, kuten toha e ma tbai wasikw sekye ti myut lwaumire ode myenah ti seikkwe metdyet ne. Ma msarin ode nenmo mlyakut bai lulkwe.” Keskyede iry desikre rhalas i ma rbohe, “Lema nam, de ana aramy myenah ti mleran ne bo.” ");
INSERT INTO slu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Keskyede Lot tyanuk lanidik, lemade iry desikre rtoha ma rbai Lot wasi sekye. Ti ranait sekye bonyo Lot nyoha kotw o abw mtelas nekre ktyabal rotkye ma yal ti iry desikre ma ra. ");
INSERT INTO slu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Keskyede iry desikre lenla renaf bonyo, wamwanire mumu ti hnu Sodom desike, kyala kyosy lyalaure ma ti kyait amosure, neke lema sasam yei etke dakun, de rma mumu ma rkoal eta Lot wasi sekye. ");
INSERT INTO slu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ode reik ma rtanuk ti Lot de rbohe, “Iry dai mamai seimw neke sir ka? Mal sir ei mloskye ma aramy myala atyat ti sir.” ");
INSERT INTO slu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Lemadendye Lot byetik ode hyolat eta holholatke ode tyanuk de byohe, “Hatnimakkwe kete myala ktela atyatke. ");
INSERT INTO slu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ei ne mhye o anakw wamfwetke enaru, ma wamwanire lenla rakari sir elik, lemamo ana kal sir ei mloskye ti e, ode myala sir kola dene ktela mibohe eraske ne, klala mwakun mamin seikkwe krala neke kete myala atyatke myor sir, kali ramin seikkwe kralake de.” ");
INSERT INTO slu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Keskyede iry Sodom desikre rbu ti Lot de rbohe, “Maditi lakhidik o! Oi neke nenmo mmwai ne, ma mola mwakun, ode mobak ma mhwareta aramy dakun e! Ana mhwury de aramy myala atyat ti o ma kbyilak iry deru desy!” Lemade iry desikre ralkyaw sir ti Lot ode rlubur ba ti robak ma rtual holholatke. ");
INSERT INTO slu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Keskyede Hulasokwe wasi nyaso deru desy rlol simatare ti rbity Lot ei sekye kralake, ode rholat eta holholatke. ");
INSERT INTO slu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Maktei bonyo rala iry ribun mamin holholatke kmata desy, neke kakan o lan ma matatare kbyol ma ramas ti de ramas ma keskyede lema rhe toha holholat desy. ");
INSERT INTO slu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Maktei bonyo iry deru desike rtanuk ti Lot de rbohe, “Muka hatnimamw ti ne e? Mbwu ti anamw wamfwet wamwany rtabal msalenamw o sobaimw o hatnimamure mumu, ma mor sir de mbyetik toha hnu ne, ");
INSERT INTO slu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kali ana aramy msyolyo msyarah hnu ne ba. Kali ribun a rarwen ti YANWE ti ktela atyat mamin nus ne, lemadendye YANWE yaso aramy ma mmya ma msyolyo msyarah hnu ne.” ");
INSERT INTO slu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Dendye Lot a bya ti tyanuk ti ananare lyalautare de byohe, “Mbyitil e ma adoko mbyetik toha hnu ne, kali YANWE ana syolyo syarah hnu ne ba.” Keskye ananare lyalaut desikre lema rtohak Lot nam itanuk desikre, kali rbohe syalik a sir bo. ");
INSERT INTO slu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lemade kiarasik a msarinke bonyo, Hulasokwe wasi nyaso deru desike rbu ti Lot de rbohe, “Mlwaha mirin, mbwitil o ma mor sawamw ode anamw deru ne, ma adoko mbyetik toha hnu ne ma kete mmyaty, kali Hulasokwe yala ma syoly o syarah hnu ne ba mumu.” ");
INSERT INTO slu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Keskye Lot neke ralake mdedan ma byetik, lemade Hulasokwe wasi nyaso deru desike rkumak a Lot yor sawa o anan deru desy simatare ode reuk sir ma rbetik toha hnu desy, ode rtunik sir ma rba, kali YANWE lyobak a sir. ");
INSERT INTO slu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Maktei bonyo nyaso desy it a byu ti sir de byohe, “Adoko mila ma ti myaorif tenamire, kete myulak matamire ma myatos ei lyakwe, ode kete mimres dakun ti ktebteban Yordanke, de mila a myobak huarare ma kete mmyaty liklikan.” ");
INSERT INTO slu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Keskye Lot a hyalas iry deru desy ma byohe, “Amakkwe, kuten ma kete koldyesy. ");
INSERT INTO slu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Yaw neke wasimy iry a yaw, ode khwe ohe ralamy kralanare kdyakin a yaw ma myaorif yaw, ode wasimy eraske lan ma yaw de. Keskyede lema kula a kal bai huar so kali soso, kali kumtaut o kolnye lenla kait so, desikeo reba munal ti nus ne ana ktyoha yaw ti ktyabahunw a yaw. ");
INSERT INTO slu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","De matos a hnu so. Hnu soke kakan bo, ode lema soso, de lemamo mou ma kula kbwai hnu kakan so. Hnu soke kakan bo, ma lemamo myaorif yaw o so.” ");
INSERT INTO slu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Lemade nyaso manosy lait desike hyalas i ma byohe, “Kou, ode ktwoha nam mutanuk desikre mumu de, neke hnu ana muba ti desike lema kswoly o kswarah ba. ");
INSERT INTO slu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","De mlwaha mirin ma adoko mula mbwai so, kali ana lenla kala namit-namit, kolnye lenla mait o so.” Lemadendye raki hnu desy ti Zoar, kali byu ohe hnu desike kakan. ");
INSERT INTO slu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lemade Lot rala rbai Zoar. Ode kyoat ranait bonyo sekwe byetik ma ryan nuske. ");
INSERT INTO slu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lemadendye YANWE nyauk us akye ode us hatw maharharke kyosy a laitke ma ksyoly o ksyarah hnu Sodom o, Gomora o, ");
INSERT INTO slu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","hnu mamin ti ktebteban Yordan desy mumu, ktyabal wer o aw matuhw ti lasmyer desy mumu ma ktei. ");
INSERT INTO slu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kyoat desike bonyo sawa-na yulak matake ei lyakwe, lemadendye tyoy a tul taisiskye. ");
INSERT INTO slu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ode bolbolbol ne bonyo Abraham byatar a kmuna ma lyakut bai wen a liahke imdiri yor a YANWE tike, ");
INSERT INTO slu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ode inunu ei Sodom ode Gomora ktyabal a ktebteban Yordanke mumu, neke yatos o akye kduduhanke kdyuhan kyosy lasmyerke ma kele roan ei srake. ");
INSERT INTO slu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lemadendye kyoat Hulasokwe syoly o syarah hnu ribun mamin ti ktebteban Yordanke ktyabal wen Lot imin tike bonyo, Hulasokwe nyenas yal a Abraham, lemadendye Hulasokwe yaditi Lot toha wen desy. ");
INSERT INTO slu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Maktei bonyo Lot yor anan wamfwet deru desy rbetik toha Zoar ma ti ramin ti huarare, kali Lot imtaut ma imin ti Zoar. Lemade Lot yor anan wamfwet deru desy ramin ti oaske kralake ma rmon ti desy bo. ");
INSERT INTO slu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lemade anan wamfwet auskwe byu ti wai amurkye de byohe, “Ity amatke amosw i de, ode lema kika wamwany ti ne ma rasaa ror ity ma taka ity anat. ");
INSERT INTO slu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Lemamo tal tasy maiskye kwen makitkye ti ity amatke yenw ma lema hye toha lbweta, ode tenah tor i ma taka ity tesnwo natut kyosy ity amatke.” ");
INSERT INTO slu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Lemadendye sewahke bonyo, deruke rlik tasy maiskye kwen makitkye ma ral ti amatke yenw, ode wamfwet auskwe syukar ti yenah yor amatke, keskyede amatke lema hye ktela iala ti ananke ti yenah yor i ne. ");
INSERT INTO slu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Msarinke bonyo, wamfwet auskwe byu ti amurkye de byohe, “Detke kenah kor ity amatke de, lemade sewah neke tlik tasy maiskye kwen makitkye ti ity amatke yenw huruk ma kyala i, mamode oa mswukar ti menah mor i, ma taka ity tesnwo natut toha ity amatke.” ");
INSERT INTO slu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Lemade sewahke bonyo, rlik tasy maiskye kwen makitkye ma ral ti amatke yenw, ode wamfwet amurkye syukar ti yenah yor amatke, keskyede amatke lema hye ktela iala ti ananke ti yenah yor i ne. ");
INSERT INTO slu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Dendye Lot anan wamfwet deru desy ror tenatare kali kyosy amatke. ");
INSERT INTO slu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ma auskwe idur hahak naman wamwankye, ma raki anike ti Moab, i neke iry Moab-are amat a i. ");
INSERT INTO slu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ode wamfwet amurkye idur hahak naman wamwankye dakun, ma raki anike ti Ben-Ami, i neke iry Amon-are amat a i. ");
INSERT INTO slu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Sekwe it bonyo Abraham yosy Mamre wasi lasmyerke ma byai lasmyer Negebke ma imin ti hnu Kadeshke ode hnu Syurke klelanke. Ode yosy desy ma byai hnu Gerarke ma imwakun ti. ");
INSERT INTO slu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ode Abraham neke tyanuk ti iry Gerar-are de byohe Sara neke rahyeta i. Lemade Abimelekh raja Gerar desike itomolu bonyo, yaso ma ti ral Sara ma ror i ba ti i. ");
INSERT INTO slu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lemade metdyetke it bonyo, Abimelekh yenaf, ode myey o Hulasokwe mya ma syusu tenanke ti i ma byu de byohe, “Abimelekh, ana mmwaty mane! Kali wamfwet munal desike ika lai de.” ");
INSERT INTO slu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Keskyede Abimelekh hyalas ma byohe, “Ebo, wamfwet neke lenla kenaf kor a i elik, ode kolkyabei ne mala ma mtwabahunw yaw kor nusakw a lema maka salat nekre de? ");
INSERT INTO slu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","De lema iry desike byohe, ‘Wamfwet neke rahyetakw a i’ e? Ode wamfwet ne byu dakun ma byohe, ‘Naraku i ne.’ Dendye ktela kuala ne dakun o kala kor ralakw nelnyelkye, ode simakw a krala nelnyelkye.” ");
INSERT INTO slu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lemade Hulasokwe hyalas a i ti meike kralake ma byu de byohe, “Khwe dakun o ktela muala neke mala mor ralamw nelnyelkye, lemade kyala kyosy wamfwet desike ti isukar seimkwe ma ti kyait senwe, kala o ma kete menah mor i ma kete musal ma Yaw. ");
INSERT INTO slu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Lemade adoko mal a molik wamfwet desy ti lai. Ode lai desike iry manety wasikw nyanoke, ma ana syambayan ti o ma mmworif. Keskyede kolnye lema mal a molik wamfwet desy ti lai, desikemo mnwenas, ana ktwabahunw oa mor wasimw iry ribun lan desikre mumu!” ");
INSERT INTO slu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ode bolbolke bonyo, Abimelekh yabuk wasi makaryaare mumu, ode lyosu nam Hulasokwe itanuk ti ike ti ktela ana madi tiare ti ia yor wasi nus desy bonyo, ramtaut ma ksyeman sir. ");
INSERT INTO slu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Lemade, Abimelekh yabuk Abraham ma tyanuk ti i de byohe, “Abraham, tot sai ne muala ma aramy ne de? Ode salakw sai ti o, mane munety a lim o sal lan ne ma yau kor nusakw lan ne de? Ktela muala nekre lema mlay.” ");
INSERT INTO slu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Maktei o Abimelekh tyanuk ti Abraham huruk ma byohe, “Kyanmwane muala tot maoly ne de?” ");
INSERT INTO slu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Lemade Abraham hyalas i ma byohe, “Kali, lenla kunait hnu ne bonyo, krwekan ti ralakkwe ohe, ti hah neke irire lema ramtaut Hulasokwe elik, ma ana kyalnini iry nekre rtabahunw a yaw khyali sawakw ne. ");
INSERT INTO slu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ode wamfwet ne dakun o rahyetakw a i bain, kali ara amamy sasamke, keskyede ara enamire rasalsyalik sir, lemade ara miru misa mane. ");
INSERT INTO slu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ode kyoat Hulasokwe byuma kbwetik toha amaku wasi sey o hnu ma kbwa ti de kbwa ma ti irire hnuatare, desike bonyo kbwu ti sawakw ne de kbwohe, ‘Mswusu wasimw mulobak yakwe ti iry kabei ta kabei, ma mbwohe oi neke rahyetakw a o.’ ” ");
INSERT INTO slu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Itanuk maktei bonyo, Abimelekh yal a yolik Sara ti Abraham. Desikeo yal biby o, domba o, saby, ode wasi at wamfwet wamwany ti Abraham dakun. ");
INSERT INTO slu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Maktei bonyo raja desy byu ti Abraham de byohe, “Abraham, lasmyerke ktem ne wasikw mumu, lemade kyosy a o bo ma mdwakin serkyabei ma mumin ti ode mtwenas ti bo.” ");
INSERT INTO slu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Maktei o byu ti Sara de byohe, “Kal a blyawan bokbokke ribunke sasam ti naramw de, ma klyosu ohe iry a mlay a o ti ribun lan manor o nekre, ma ti sai ta sai bo, desike bonyo mlay a o.” ");
INSERT INTO slu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Lemade Abraham syambayan ti Hulasokwe, ma Hulasokwe nyoha Abimelekh yor sawa, ode wasi at wamfwetare ma radur hahak namanare huruk. ");
INSERT INTO slu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kali khyehyeike YANWE yala wamfwet mamin ti Abimelekh wasi sekye krala desy mumu ma lema raka anat, khyali Abraham sawa Sara desy. ");
INSERT INTO slu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","YANWE syeak Sara ma kola dene itanukke, ode YANWE yala ktelake ti Sara, ma kola dene ihatetakke. ");
INSERT INTO slu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Lemade Sara yor tenanke, ma idur hahak naman wamwankye it ti Abraham, kyoat desikeo Abraham amosw a i de, keskye Hulasokwe tyenuk a ktela ne ti sew a itetak ti sirke. ");
INSERT INTO slu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Naman desike Abraham yaki anike ti Ishak. ");
INSERT INTO slu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ode kyoat Ishak wasi sekwe walw bonyo, Abraham yatosa i ma ktyoha haret Hulasokwe itunik ti Abrahamke. ");
INSERT INTO slu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Kyoat Ishak radur ti bonyo ama Abraham wasi ainke atkwe sasam. ");
INSERT INTO slu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Lemade Sara byu de byohe, “Hulasokwe yala yaw ma kumahis ode kumukmuka yaw, ode ana iry kabei ta kabei tyomolu ktela ne, desikeo ana imahis ode imukmuka i a yor yaw dakun.” ");
INSERT INTO slu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Maktei o tyanuk huruk ma byohe, “Lema kika iry mabohe kmwakw de, kali myatos, senwe kudur hahak naman wamwankye it ti Abraham, biar ma amosw a i dakun de.” ");
INSERT INTO slu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Seure kieluk i, ma Ishak tyunik suskwe bonyo, Abraham yala kalkal lan ne it. ");
INSERT INTO slu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ode kyoat desike, Sara yatos Ismael, Hagar wamfwet manosy Mesir desy anan idur hahak ti Abrahamke, ma ihmwai Ishak, Sara anan desy. ");
INSERT INTO slu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Lemade Sara byu ti Abraham de byohe, “Adoko mtwian lakhidik at wamfwet desy yor ananke ba. Kali lema kou ma at desy ananke ana syaa i ti wasimw maloly ribun lan ne. De anakw Ishak neke ana syaa i ti maloly ne mumu.” ");
INSERT INTO slu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham itomolu Sara tun itanuk desy bonyo, ralake krala ne lema eras, kali Ismael neke Abraham anan i dakun. ");
INSERT INTO slu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Keskyede Hulasokwe tyanuk ti Abraham de byohe, “Kete ralamkwe lema eras ti tun Sara itanuk ti o desy, ti kihali wasimw at wamfwetke inor anan desy. De mtwoha tun Sara itanuk desy bo, kali ana tesnwo natumw ribun sir neke kyosy Ishak. ");
INSERT INTO slu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Keskyede at wamfwet desy ananke, neke ana kala i ma tesnwo natu raka nusat dakun, kali naman desike anamw a i dakun.” ");
INSERT INTO slu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ode bolbolke bonyo, Abraham isosan kotw o abw ode yal werke ti werke kwena rala toha bibkye iblunke ma resat, ode syalak lan desikre ti Hagar hesake. Maktei bonyo Abraham yaso wamfwet desy yor ananke ma rbetik ma rba. Dendye Hagar yor naman desike rba, ma rlakut ti de rlakut ma ti wen malosy-losy Bersyebake. ");
INSERT INTO slu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ode kyoat resat wer desike ktei bonyo, Hagar tyutuk anan desy ti sitw o tnyei krintyotan ti desy, ");
INSERT INTO slu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ode lyakut bai lulkwe kasonanakke lalwakwe atw, ti tyaklulw ma soso i ti naman desy, ode syer ma telake lan, ode ryekan ti ralake de byohe, “Lema kbwuma katos anakkwe ma myaty koldyesy.” ");
INSERT INTO slu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dendye Hulasokwe itomulu naman desy telake bonyo, Hulasokwe wasi nyasoke yabw yosy laitke ma byu ti Hagar de byohe, “Hagar o! Ralamkwe kitol ti sai ne de? Kete mumtaut, kali Hulasokwe tyomolu anamkwe telake ti wen desy de. ");
INSERT INTO slu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lemade mumdiry ma adoko ti mait anamw desy, ode mkwumak simake ma mbwitil a i, kali ana kala i ma tesnwo natu ribun sir ma wait nuske lan.” ");
INSERT INTO slu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Maktei bonyo Hulasokwe yala Hagar ma myatakit werke ti desy. Lemade bya ti yal werke ti werke kwena ranety desy, ma yal ti ananke yenw. ");
INSERT INTO slu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ode Hulasokwe yaorif naman desy ode syeak ti i ma lyean ma lan a i ti wen malosy-losy desy, dendye rtenas ti wen desy ode ryaut a hye huskwe dakun. ");
INSERT INTO slu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ode kyoat ramin ti wen malosy-losy Paranke bonyo, Hagar yal wamfwet Mesirke it ti Ismael isaa yor a i. ");
INSERT INTO slu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kyoat desike raja Abimelekh yor Pikhol, neke Abimelekh wasi suldatare wait uskwe khatuke, neke rma ma rait Abraham. Desikeo Abimelekh tyanuk ti Abraham de byohe, “Oi neke aramy mhye ohe Hulasokwe syaluk o ti ktela muala nekre mumu. ");
INSERT INTO slu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Koldyesy mo muhwab ti Hulasokwe ma katos, ohe ana lema mala ktela atyatare ma yaw, ktyabal anakure ma ti kyal tesnwo natukw dakun. Kola dene kuala eras ti o ne, lemade muhwab ti Hulasokwe ohe ana mala ma yaw koldyesy, ode ana mala koldyesy ti wasikw nus a mumwakun ti ne dakun.” ");
INSERT INTO slu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Lemade Abraham hyalas ma byohe, “Kuhwab ti Hulasokwe de.” ");
INSERT INTO slu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Keskyede kalyauke bonyo Abraham yarwen ti Abimelekh, kali Abimelekh wasi makaryaare rasoruk wer Abraham ikalkye. ");
INSERT INTO slu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Lemade Abimelekh byohe, “Yaw ne dakun o lema khwe ohe esei ne iala tot maoly desy de, ode o dakun lema mlwosu ma yaw, keskyede nenmo ktwomolu ktela mutanuk desy.” ");
INSERT INTO slu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Lemade Abraham yal domba o biby o saby ti Abimelekh ma deruke rahatetak ti tun ratanukare. ");
INSERT INTO slu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Maktei o Abraham syalik huruk dombake anan wamfwetke itw toha wasi dombanare. ");
INSERT INTO slu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Lemadendye Abimelekh yena i ma byohe, “Kyanmwane musalik dombake anan wamfwetke itw ne de?” ");
INSERT INTO slu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Dendye Abraham hyalas ma byohe, “Mal dombake anan wamfwet deitw ne, ma klyosu ohe bain-bain o yaw ne kukaly wer ne.” ");
INSERT INTO slu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Lemade wen desike raki kanike ti Bersyeba, kali iry deru neke rahwab o rahatetak ti wen desy. ");
INSERT INTO slu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Iry deru desike rahwab o rahatetak ti Bersyeba maktei bonyo, Abimelekh yor Pikhol, suldatare wait uskwe khatu desy, neke rolik sir bai nusatke ti lasmyer Filistinke. ");
INSERT INTO slu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Lemade iry desikre raba bonyo, Abraham yal aw a tamariskake ma tyan ti Bersyeba, ode ti wen desike syambayan ti YANWE, neke Hulasow Mamorif Nini Namke. ");
INSERT INTO slu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kyala kyosy desy, Abraham imin ti lasmyer Filistinke klenke soso dakun. ");
INSERT INTO slu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kyoat nam ribun neke ktei, desikeo Hulasokwe iobak Abraham wasi tohtohakke, ode Hulasokwe yabuk Abraham de byohe, “Abraham o!” Lemade Abraham hyalas ma byohe, “O Ebo.” ");
INSERT INTO slu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Lemade Hulasokwe tyanuk ti Abraham ma byohe, “Mal anamw sasasam mulobak a i desy, neke Ishak, ma mbyai lasmyer Moriake ti huar ana kulosu ti oke, ode mkwotal telake ode meh a i ma mabar a i, ma yeluk heal raeh ma Yaw ne.” ");
INSERT INTO slu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ode bolbolbol ne bonyo, Abraham byatar ma isosan wasi keledaike, ode yelaw ma ti o yal ma yeh heal raabar ti Hulasokwe ne. Maktei bonyo yabuk wasi makaryake enaru, rtabal anan Ishak ma raktem a rbai wen Hulasokwe ilosu ti i desy. ");
INSERT INTO slu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kyoat rlakut bai wen desy ma kyelak sekwe enatelw bonyo, Abraham byitil matake o myatakit wen desy, keskye soso a nggora. ");
INSERT INTO slu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Lemade Abraham tyanuk ti wasi makarya deru desy ma byohe, “Miru myor keledai neke mimin ti ne aduk, ode kor Ishak de aramy mbyai so, ti aramy msyambayan, maktei o aramy myulak aramy ma myait a e ti ne.” ");
INSERT INTO slu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Lemade Abraham yal aw desikre ma syumuk ti anan Ishak a hesake ma hyar, klala Abraham kyumak boramaske ktyabal asuske, maktei o deruke rlakut ma rba. ");
INSERT INTO slu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Dendye Ishak tyanuk ti ama Abraham de byohe, “Amo.” Bonyo Abraham hyalas ma byohe, “Ou, toto.” Lemade Ishak yena ama Abraham de byohe, “Kena o ohe, akye ode aure kimin de, keskyede dombake anan ana taeh ma taabar ti Hulasokwe neke ika?” ");
INSERT INTO slu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Lemade Abraham imres mait ma hyalas ananke ma byohe, “Toto, Hulasokwe myesan a yal dombake ananke ma ity, ma ana ti o teh a i ma tabar ti I.” Abraham itanuk maktei bonyo deruke rlakut ma rba. ");
INSERT INTO slu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kyoat ranait wen Hulasokwe isusu ti Abrahamke, desike bonyo Abraham yal hature ma syadiri lat raeh heal ti Hulasokwe ti wen desy, maktei o tyenuk aw desikre ti lat desy khahake, ode byutw anan Ishak sima o lwau, maktei o lyatak Ishak ti aw khaha desikre. ");
INSERT INTO slu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Maktei bonyo Abraham yal boramaske ma yala ma kyotal ananke telake. ");
INSERT INTO slu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Keskyede YANWE wasi Nyasoke yabw yosy laitke ma byohe, “Abraham, Abraham o!” Lemade Abraham hyalas de byohe, “O Ebo, yaw san.” ");
INSERT INTO slu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Lemade YANWE wasi Nyasoke tyanuk ti Abraham de byohe, “Kete mtwabahunw a naman desy! Ode kete mala i ti de mala i ma, kali nenmo khwe ohe, senweke mumtaut Hulasokwe ma kbyilak ti mulobak anamw sasasam desy, kolnye mal i ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Dendye Abraham tyiri matake, desikeo yatos o domba wamwankye it ma imin ti etake ma sorsorunare kkyasu i ti kairwamaske kukwanke. Lemade Abraham yal a domba desike ma kyotal i ma yeh a i ma yabar i ti Hulasokwe ma kyeluk anan Ishak. ");
INSERT INTO slu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Lemade Abraham yaki wen desike kanike ti “YANWE ana yal ma ity.” Lemadendye selsel neke irire rbohe, “Ti YANWE wasi huarke sra ne ana yal ma ity.” ");
INSERT INTO slu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Lemade YANWE wasi Nyasoke tyanuk huruk ti Abraham, ");
INSERT INTO slu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ma byohe, “Tun a kutanukke ne: Yaw a YANWE kmwesan kuhwab ti tenakkwe, kali oi neke mala ktela eraske ma lema muneti anamw sasasam desy, ma mal i ma Yaw. ");
INSERT INTO slu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Lemade Yaw neke ana kal eraske ti o ma mausw ksyalik, ode kala tesnwo natumw nekre ma ribun sir a ksyalik, ma rola ne thunare o laitke, ode laranke o namwatake, ode tesnwo natumw nekre ana radurak iry mamnisik eare wait hnuare. ");
INSERT INTO slu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ode kyosy a tesnwo natumw, nuske ktem mamin ti lasmyerke khaha neke mumu ana ratot eraske, kali oi neke mtwomolu tunakure.” ");
INSERT INTO slu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Lemadendye Abraham yor Ishak rulak sir ti rait Abraham wasi makarya deru desy, ode raktemtem a rbai Bersyeba, ma rtenas ti. ");
INSERT INTO slu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kyoat desike Abraham tyomolu britke ohe Milka idur hahak naman wamwanire ti Nahor, neke Abraham wai i. Naman nekre sir ne: ");
INSERT INTO slu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, neke ausw a i, ma wai amurire sir ne: Bus, Kemuel (neke anan Aram), ");
INSERT INTO slu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildash, Yidlaf, ode Betuel. ");
INSERT INTO slu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ma Betuel neke anan Ribka. Naman dewalw neke Milka idur hahak sir ti Nahor, neke Abraham wai. ");
INSERT INTO slu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ode Nahor yor sawa imruanke neke ani Reuma, ma idur hahak namanke enaat, neke Tebah, Gaham, Tahash, ode Maakha. ");
INSERT INTO slu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara myorif ma wasi ainke kyait a atw ksala hean-ru a kresi itw (127), ");
INSERT INTO slu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","desike bonyo myaty, neke myaty o Kiryat-Arba, neke hnu Hebronke ti lasmyer Kanaanke. Lemade Abraham syera sawa Sara. ");
INSERT INTO slu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Maktei o Abraham bya ti tyanuk ti iry a Het-are, ma byohe, ");
INSERT INTO slu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Yaw neke iry salik yaw, ode kumwakun ti ei ne mumu, lemade kuten ma myal wasimy lasmyerke tebikan ma klwiw toha e, ma kkwaly asake ti, ma kamlin sawakw ti.” ");
INSERT INTO slu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Lemade iry a Het-are rhalas Abraham ma rbohe, ");
INSERT INTO slu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Amo, aramy myalan a o, kali oi neke iry lan a o, ode mumin ne ma mor aramy ti ne de. Lemade mbwa ti msweak asa eras-eraske it ma mamlin sawamw ti, kali aramy ti ne dakun o lema aramy mineti ara wasimy asake it ti o.” ");
INSERT INTO slu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Lemade Abraham imdiry ode syakitil ti iry Het desikre, ");
INSERT INTO slu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ode tyanuk ti sir de byohe, “Kolnye myou ma kor sawakw mamaty ne ma kamlin a i ti ne mo, mtyomolu yaw ode mlyobak yaw ma miten toha Efron, Zohar ananke, ");
INSERT INTO slu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ma yal wasi bob mamin wasi boke kseri mamin lasmyer Makhpelake ma yaw. Ode khesike enai mo kswelw ti i ma miktemtem a mhye o wasikw lasmyerke ode bobke ne.” ");
INSERT INTO slu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kyoat desyo Efron tyaklulw ti desy dakun, ode iry ribun mataklulw ti lorkye kmata hnu lan desike raktemtem a rtomolu Efron, iry Het desy, ma hyalas Abraham de byohe, ");
INSERT INTO slu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Lema koldyesy. Amo, de mtwomolu yaw. Senweke kal bo desy ktyabal bob mamin ti boke kseri desy ti o, ma iry mamin a ara hnuamy neke rhe mumu o kal boke ode bob desy ti o. Lemadendye mbwa ti mal sawamw mamaty desy ma mamlin i ti.” ");
INSERT INTO slu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Lemade Abraham syakitil ti iry Het desikre huruk, ");
INSERT INTO slu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ode tyanuk ti Efron ma iry desikre raktemtem a rtomolu, neke tyanuk ma byohe, “Kolnye mdwakin yaw bain-bain, desikemo mtwomolu yaw. Ana kswelw boke khesi desy ti o, desikeo mal toha yaw, mamode kamlin sawakw mamaty ne ti bob desy.” ");
INSERT INTO slu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Lemade Efron hyalas Abraham ma byohe, “Amo, mtwomolu yaw. Lasmyer tebikan desike khesi blyawan bokbokke atkwe enaat. Keskye khesi desike lema kika kbuan ti taktemtem. Lemade mamlin sawamw ti lasmyer tebikan desy bo.” ");
INSERT INTO slu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Lemade Abraham you toha Efron tun itanukke, ma tyail blyawan bokbokke ti Efron, desyo iry a Het-are ratos o blyawan bokbok desike karyarike atkwe enaat, ma kola ne iry maketa namare ratail ne dakun. ");
INSERT INTO slu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Lemade Efron wasi bo mamin ti lasmyer Makhpelake, neke knyey lasmyer Mamre kseri timurke, ktyabal bob mamin ti bo desy ode aw mamin lasmyer desy mumu ma ti kyait kserinare dakun, neke Abraham wasi. ");
INSERT INTO slu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Kali bo desy ktyabal nam desikre mumu neke Efron yal ti Abraham ma wasi, ma iry Het mamin lorkye kmata desy ror iry ribun desikre ratos ode rhe o Abraham syelw maktei de. ");
INSERT INTO slu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Lemadendye Abraham bya ti yal sawa-na tbunanke ma yamlin i ti bobke ti bo mamin ti lasmyer Makhpela desy, neke knyey a Mamre wasi lasmyer kseri timurke oa lasmyer Kanaanke. Mamre neke rhaly o Hebron dakun. ");
INSERT INTO slu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lemade iry Het-are wait boke ode bob desy, neke rala atyahkye ma klyosu ohe Abraham wasi. Ode yala ratkye ti. ");
INSERT INTO slu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham neke amosw i lahuk de ma wasi ainke kbyilak, ode YANWE yal eraske ti i ti sai ta sai bo. ");
INSERT INTO slu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sekwe it bonyo Abraham yabuk wasi makarya ausw lahuk kyalamo maseak ti wasi lan o hnutan o nam nekre ti seike kralake, ma byu ti i de byohe, “Mal a simamkwe ti lakbiakkwe hah ne, ");
INSERT INTO slu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ode muhwab ti YANWE, Hulasow a mahareta ti lait ne ode lasmyerke khaha ne, ma kete mutuna wamfwet Kanaan nekre it ti anakw Ishak elik. ");
INSERT INTO slu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","De oi neke ana mbwetik toha lasmyer Kanaan ne ma molik a o bai ara nusamkye, ma mobak wamfwetke it o so toha wasikw irire ma mena i ti anakw a Ishak.” ");
INSERT INTO slu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Lemade makarya desike yulak i ma yena Abraham de byohe, “Amo, kolnye wamfwet desike lema you ma byuma tyoha yaw ma aramy mmyai hnu ne, desikemo ana kala kolkyabei de? Lemamo kor anamkwe ma aramy mbyai nusamw a munoskye.” ");
INSERT INTO slu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Keskyede Abraham hyalas i ma byu de byohe, “Lema koldyesy! Keskye mnwenas! Murontyo mor anakkwe bai nus so elik! ");
INSERT INTO slu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kali YANWE Hulasow mahareta ti lait neke, yabuk yaw ma kbwetik toha amaku seike ode amno waiku hnuatke de. Ode ihatetak ode tyanuk ma yaw ma ana yal lasmyer ne ti tesnwo natukw. Lemade ana YANWE yaso wasi nyaso manosy laitke it ma syaluk a o ma mutot wamfwetke it o so ti anakkwe. ");
INSERT INTO slu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Keskye kolnye wamfwet desike ibrai ma tyoha o mai ne, desikeo ana wasimw inahwabke kyaditi i toha o. Ode kolkyabei ta kabei dakun o, murontyo mor anakkwe bai so elik!” ");
INSERT INTO slu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lemadendye makarya desike yal simake ti Abraham lakbiake hahke, ode ihwab o ana tyoha nam Abraham itanuk ti i desikre mumu. ");
INSERT INTO slu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Maktei bonyo makarya desike yal Abraham wasi untake hean, ktyabal lan o hnutan a khesi lan desikre dum, ode bya kola seryabke ti iry Aram-are wait lasmyerke, neke kani a Mesopotamia, ma bya ti yait hnu Nahor imin tike. ");
INSERT INTO slu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kyoat makarya desike inait hnu Nahor imin tike bonyo sekwe bya de. Lemade imres a yor unta desikre ma rney a werke it ti hnu desike kserike, kali kyalamo seure rba koldyesy, desikeo wamfwetare rma ma rtol wer desy. ");
INSERT INTO slu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Lemade makarya desike syambayan ti Hulasokwe, ma byu de byohe, “O YANWE, Hulasow a amakw Abraham isob ti O, mlwobak yaw ma wasikw harhar amakw Abraham itunik ma yaw neke kdi ti senwe, ode mswusu wasimw eras lan desy ti amakw Abraham. ");
INSERT INTO slu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ode matos, yaw ne kumdiry ti werke kserike mane, ma ana lema soso bonyo warar mamin ti hnuke krala neke rma ma rtol wer ne. ");
INSERT INTO slu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ma kolnye rma ma rtol, desikemo ktwanuk ti wararke it ma kbwohe, ‘Mlwobak yaw mo mnwauk wasimw werke kwena desy ma kenw werke tebikan aduk.’ Ma kolnye hyalas yaw ma byohe, ‘Ou, menw nde. Ode ana ktwol ti wasimw untanare ma renw dakun.’ Ma khwe ohe, warar neke, i ne mususu i ma ana isaa yor Ishak ne. Ma kolnye ktela neke kdi ti, desikeo khwe ohe mal eraske ti amakw Abraham de.” ");
INSERT INTO slu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Malmata syambayan ti Hulasokwe bonyo, kele rsoru Ribka ma mya. Warar neke eras i a ksyalik, ma lenla wamwankye it a yakari i elik. Ribka neke Betuel ananke, ode Betuel ne ena-na ani Milka ode ama-na ani Nahor, ma Nahor neke Abraham wai i. Ribka mya o yety wasi werke kwenake ma moluk ihahar, ma byai wer desy ti tyol ti wasi werke kwena desy maktei bonyo yulak a i. ");
INSERT INTO slu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kyoat yulak i ma ilakut ba bonyo, Abraham wasi makarya desike ila ti yait a i ma byu ti i de byohe, “Akasy, mlwobak yaw mo mal wasimw wer desy ma kenw tebikan aduk.” ");
INSERT INTO slu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lemade warar desy hyalas i ma byohe, “Ou, Amo.” Dendye warar desike nyauk wasi werke kwena desy ma ikumkumak ode Abraham wasi makarya desike yenw. ");
INSERT INTO slu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iyenw maktei bonyo, warar desy byu ti i huruk de byohe, “Amo, ana ktwol ti wasimw unta desikre renw dakun, ma wasimw unta desikre renw ma kinanal sir.” ");
INSERT INTO slu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Lemadendye warar desike yalik werke toha wasi werke kwena desy ti healare wait wen a raenw wer tike, keskye lema knyal sir. Lemade yulak i ma ila byai werke ti tyol huruk ma yal ti unta desikre renw, koldyesy, koldyesy, nini unta desikre renw ma kinanal-kinanal sir. ");
INSERT INTO slu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kyoat warar desike tilno laha i ti desy, Abraham wasi makarya desike mamwaw i ode yatos warar desy bo. Dendye makarya desike ryekan ohe, “Anakyai YANWE syaluk a yaw ti wasikw harhar amakw Abraham itunik ma yaw ne de.” ");
INSERT INTO slu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ode unta desikre renw werke ma kinanal sir maktei bonyo, Abraham wasi makarya desike yal anting o sikbi blyawan a khesi lan nekre toha wasi suhlwakke ma yal ti warar desy. ");
INSERT INTO slu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Maktei o makarya desike yena i ma byohe, “Akasy, amamw esei de? Ode ti amamu seike ne kika wen ma aramy myenah ti ta lema de?” ");
INSERT INTO slu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Bonyo warar desy hyalas i ma byohe, “Amo, amakw ani Betuel, ma ebukw Nahor yor Milka. ");
INSERT INTO slu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ode ti ara seimkye neke kika wen ma ana myenah ti, ode kika wen ma wasimw unta desikre renaf ti, ode tnyeinare kimin dakun ma ana mal ma mai sir.” ");
INSERT INTO slu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lemadendye makarya desike syakitil ma syambayan ti YANWE ");
INSERT INTO slu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ma byu de byohe, “Klweru O, YANWE, Hulasow amakw Abrahamke. Kali kyaki-kyaki ne Oi neke mal wasimw eras lan ne ti amakw Abraham, ode Oi ne mswusu salke ma yaw ma ti kunait elik hatnimanare ne.” ");
INSERT INTO slu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Lemade warar desike ila byai ena-na seike, ma ihes ktela dai desy. ");
INSERT INTO slu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","(Ode Ribka narake it ma ani Laban.) Ma Laban ne tyomolu rahyeta ma ihes ktela maditi tenan desy, ode yatos o anting blyawanke kitol ti rahyeta-na nurake ode sikbi blyawanare kimin lena deruke. Lemadendye Laban byetik toha sekye kralake ma ila bya ti yait iry desy, desikeo iry desike imdiri yor wasi untanare ma rney werke ti desy. ");
INSERT INTO slu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lemadendye Laban byu ti makarya desy de byohe, “Amakw a YANWE inal eraske ti o, mmwai san. Kete mumin ti ne, de mmwa ma tbai ara wasimy sekye. Kali aramy misosan wenamw ana mienaf tike de, ktyabal wasimw unta-na wenatare dakun.” ");
INSERT INTO slu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Lemadendye makarya desike tyoha Laban bai sekye. Ranait sekye bonyo, iry mamin ti seire rnauk lan desikre toha unta desikre, maktei o ral a tnyeinare ti unta desikre ra, ode rhela wakure ma unta desikre renaf ti. Maktei o ral werke ti makarya desike yor iry matoha iare ma rut a lwautare dakun. ");
INSERT INTO slu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ode rasosan kotw o abw ma rala ma raknam bonyo, makarya desike tyanuk ma byohe, “Ana lenla kuknam, kolnye lenla klwosu nyano kunetkye.” Bonyo Laban a byohe, “Ode mtwanuk a nde!” ");
INSERT INTO slu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Lemade iry desike byohe, “Yaw neke Abraham a wasi makarya yaw. ");
INSERT INTO slu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ode YANWE yal eraske ti a amakw Abraham, ma wasi malolkye lan ode yal domba o, biby o, saby o, unta o, keledai, ktyabal a blyawan kunkuny o blyawan bokbok ode at wamfwet wamwany ti i mumu. ");
INSERT INTO slu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ode Sara amakw Abraham sawa neke, kyoat enmosw a i bonyo, idur hahak naman wamwankye it ti amakw Abraham. Ode Abraham yal maloli ribun lan desikre mumu ti anan desy. ");
INSERT INTO slu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Lemade amakw Abraham yaso yaw ma kuhwab ma ktwoha wasi haretare ma kbyuma kete kuobak wamfwet a mamin ti lasmyer Kanaan so, ma ananke isaa yor i. ");
INSERT INTO slu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","De byuma musti mo kobak wamfwet toha amakw Abraham ama-na wasi irire ma ananke isaa yor i. ");
INSERT INTO slu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Lemade khwalas amakw Abraham ma kbwohe, ‘Amo, kolnye wamfwet desike lema byuma tyoha yaw mo, kolkya?’ ");
INSERT INTO slu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Keskyede amakw Abraham lyosu ma yaw ma byohe, ana Hulasow a amakw Abraham itohakke, neke YANWE, yaso wasi nyaso manosy laitke it ma syaluk a yaw ma kuba ne mo kosy a eraske ma ana kutot wamfwetke it ma ananke isaa yor i, neke wamfwet manosy amakw Abraham ama-na wasi irire. ");
INSERT INTO slu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Klala kolnye lema myou kutanukke, desikeo nenmo wasikw a inahwabke kyaditi i toha yaw. ");
INSERT INTO slu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ode senwe kmwa ma kunait wer dai so bonyo, kswambayan ti ma kbwohe, ‘O YANWE, amakw Abraham wasi Hulasow O. Mlwobak yaw ma wasikw harhar amakw Abraham itunik ma yaw neke kdi ti senwe. ");
INSERT INTO slu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ode kumdiry ti werke khaha ne ma kolnye wararke it a mya ma tyol ti wer ne, desikemo kuten toha i ma yal werke ma kenw tebikan, ");
INSERT INTO slu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ode kolnye hyalas yaw ma byohe, “Menw, ode ana ktwol ma kal ti wasimw untanare renw dakun,” desikemo warar ne i ne YANWE mususu i ma ana amakw Abraham ananke isaa inor i ne.’ ");
INSERT INTO slu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ode kusambayan ti ralakkwe ma lenla ktei bonyo, kele rsoru Ribka mya o yety a wasi werke kwenake ma kimin hesake ma mya ma tyol ti wer ne. Lemade ktwanuk ti i de kbwohe, ‘Akasy, mlwobak yaw mo mal werke ma kenw tebikan.’ ");
INSERT INTO slu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lemade lyaha mirin ma nyauk a wasi werke kwena desy toha hesake, ode byohe, ‘Menw, ode ana kal ti wasimw unta desikre ma renw dakun.’ Lemade kenw, ode yal werke ti unta desikre renw dakun. ");
INSERT INTO slu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Maktei bonyo kena i de kbwohe, ‘Amamw a esei de?’ Bonyo hyalas yaw ma byohe, ‘Amakw ani a Betuel, ma ebukw Nahor yor Milka.’ Lemade kkwasu anting blyawanke ti nurake, ode konuk sikbi blyawanare ti lena deruke. ");
INSERT INTO slu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Lemadendye kswakitil ode klweru YANWE, neke Hulasow a amakw Abrahamke. I ne isaluk yaw ma yor yaw ei ne, ma kait warar ne, neke amakw Abraham wai-na ebuke, ma ana isaa yor amakw Abraham ananke. ");
INSERT INTO slu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dendye, kolnye msyusu wasimy loblobakke ti amakw Abraham, desikemo mlyosu mlakye ma yaw, de kolnye lemamo mlyosu ma yaw dakun, ma adoko ksweak ei wisalke ta wanke.” ");
INSERT INTO slu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lemade Laban yor Betuel de rhalas ma rbohe, “Ktela ne kidi ti neke kyosy a YANWE, lemade mbwuma tala kolkya? Lema aramy mtyanuk atyatke ode lema aramy mtyanuk eraske ti o dakun. ");
INSERT INTO slu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","De matos bo, Ribka i desy imdiry desy, de myal i, ma myor i ma mbya nde. Ma ti amamw ananke isaa yor i ma ktyoha YANWE tun itanukke.” ");
INSERT INTO slu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ode kyoat Abraham wasi makarya desike itomolu tunatare bonyo, syakitil ei hah ne ode syambayan ti YANWE. ");
INSERT INTO slu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Maktei bonyo makarya desike yaditi blyawan kunkuny o blyawan bokbok desikre, ode simbol o rabit eras-eras nekre, ma yal ma syamur a Ribka, ode yal nam dakun ti Ribka nara ode ena, desyo nam eras a khesi lan nekre. ");
INSERT INTO slu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Maktei bonyo Abraham wasi makarya desike yor iry a inorare raknam o renw, ode renaf metdyet desy ti Laban wait sekye. Ode bolbol ne rbatar ma makarya desike byu ti Laban sir de byohe, “Mlyura yaw, ma aramy misuka wasikw amamke.” ");
INSERT INTO slu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Keskyede Ribka nara-na yor ena de rbu de rbohe, “Lemamo naman wamfwet neke yor aramy sekwe hean ta nam aduk, maktei o enmo iba.” ");
INSERT INTO slu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Keskyede Abraham wasi makarya desike tyanuk ti sir de byohe, “Kete mineti yaw, kali YANWE yala wasikw laklakutke ma kyosy a malolanke, ode yala wasikw harhar a amakw Abraham itunik ma yakwe kdi ti de. Lemade mlyura yaw ma kusuka wasikw amamke.” ");
INSERT INTO slu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Lemade rtanuk ti i huruk de rbohe, “Desikemo tabuk Ribka ma tena i aduk.” ");
INSERT INTO slu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Lemadendye iry desikre rabuk Ribka, ode rena i de rbohe, “Mou ma mor iry ne de mbya e?” Desikeo hyalas sir de byohe, “Ou, kou.” ");
INSERT INTO slu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Dendye iry desikre rlura Ribka yor iry kyalamo makarya ti ike, rtabal Abraham wasi makarya desy yor iry manor iare raktemtem a rala ma rba. ");
INSERT INTO slu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Lemade Ribka wasi sekye kralake raten eraske ti i de rbohe, “Ara rahyetamy o, Hulasokwe ana yal eraske ti o ma ribun lan mamin ti nuske ktem neke ana enat a o, ode tesnwo natumw nekre rambrebat ma ana radurak iry a mamnisik sirare wait hnuare.” ");
INSERT INTO slu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ratanuk maktei bonyo, Ribka yor warar mur a makarya ti i desikre neke rasosan sir ma rsai wait untanare ma rtoha Abraham wasi makarya desy ma rba. ");
INSERT INTO slu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kyoat desy dakun o Ishak neke yolik i a yosy a wer Lahai-Roike kserike ma bya ti imin ti a lasmyer Negebke. ");
INSERT INTO slu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ode kyala ma sekwe bya bonyo, Ishak byetik toha wasi lasyerkye ma yal eskwe. Kyoat ibitil matake bonyo, yatos o untanare rma. ");
INSERT INTO slu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka dakun o byitil matake ma yatos mait Ishak bonyo nyusuk toha wasi unta isai desy. ");
INSERT INTO slu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Desike bonyo byu ti Abraham wasi makarya desy de byohe, “Wamwany kabei i ne ilakut ti lasmyerke khahake ma mya sara ity ne de?” Makarya desike hyalas a i ma byu de byohe, “Amakw i desy.” Lemadendye Ribka yal wasi sinunke ma yebet eta matake. ");
INSERT INTO slu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ode ranait Ishak bonyo, makarya desike ihes nam ribun lan iala desikre mumu ti Ishak. ");
INSERT INTO slu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Lemade Ishak yal Ribka wamfwet a desy bai ena Sara wasi lasyerkye kralake, ma deruke rasa. Kyoat desike Ishak ralake kitol kali ena-na myaty. Lemade kyala kyosy sew desike, Ishak ralake lema kitol, kali syenang a yor Ribka. ");
INSERT INTO slu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Seure kieluk-kieluk a i ma soso bonyo Abraham isa huruk yor a wamfwetke it ma ani Ketura. ");
INSERT INTO slu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Desikeo sawa-na yor tenanke ma idur hah ma ananare sir ne: Zimran, Yoksan, Medan, Midian, Isybak ode Suah. ");
INSERT INTO slu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Desike bonyo Yoksan neke ananke enaru, desyo Syeba yor Dedan. Ma Dedan tesnwo natu sir ne: Iry Asyur-are, iry Letus-are, ode iry Leum-are. ");
INSERT INTO slu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Klala Midian neke ananare sir ne: Efa, Efer, Henokh, Abida, ode Eldaa. Raktemtem neke Ketura ebnwo anan sir. ");
INSERT INTO slu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Kyoat Abraham myorif, desikeo yal malolkye ratebikan ti sawa hah deru desy anatare, maktei bonyo yaso sir ma rbetik ma soso sir toha Ishak ma rba ti ramin nus Kanaanke kseri timurke. Klala wasi maloly ribun lan mamin desikre mumu, Abraham yal ti anan Ishak yosy bo. ");
INSERT INTO slu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham wasi ainke atw ksala hean-itw kresi enasim (175), ");
INSERT INTO slu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","desike bonyo myaty. ");
INSERT INTO slu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Lemadendye anan deruke neke Ishak yor Ismael ti ramlin amatke tbunanke ti bob Makhpelake. Bob desike kimin nus Mamre kseri timurke, ti Efron wasi boke. Efron neke, Zohar ananke, iry a Hetke. ");
INSERT INTO slu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bo desikre heitlulswoke Abraham lyiw toha Efron. Lemadendye imaty bonyo, ramlin i ti wen desy kola heitlulswo sawa Sara ramlin i ti desy dakun. ");
INSERT INTO slu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ode Abraham imaty bonyo, Hulasokwe yal eraske ti Ishak, Abraham ananke. Kyoat desike Ishak wen a imin tike knyei werke it ma kani wer Lahai-Roike (kbuanke o “Hulasokwe kyalamo syeak ma yaw”). ");
INSERT INTO slu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Tkunw a Ismael neke ne: Ismael neke Abraham yor sawa imruanke Hagar neke anat a i. Hagar neke yosy Mesir, ma Sara yal i kindika at dakun. ");
INSERT INTO slu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael neke ananke hean a kresi enaru, ma raki anitare ma rhaly ma kitoha-kitoha i ma sir ne: Nebayot, Ismael anan ausw i, maktei bonyo matohake: Kedar, Adbeel, Mibsam, ");
INSERT INTO slu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misyma, Duma, Masa, ");
INSERT INTO slu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafisy, ode Kedma. ");
INSERT INTO slu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Naman desikre raka iry lan ti matrumatke hean a kresi enaru. Ode wait a nus o hnu, o sey o sar, raki kaninare ma ktyoha anitare dakun. ");
INSERT INTO slu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael neke wasi ainke atw ksala hean-telw kresi itw (137) bonyo myaty. ");
INSERT INTO slu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ode Ismael ebnwo anan nekre ramin ti nus Hawilake ode Syurke klelanke, ma kimin ti Mesir kseri timur kiba sara Asyur ne. Ode rmorif mo rasalsyalik sir toha Abraham ebnwo anan idanare. ");
INSERT INTO slu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Tkunw a Ishak neke ne: Abraham yal Sara bonyo anan a Ishak. ");
INSERT INTO slu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishak a wasi ainke hean-at (40) bonyo isaa yor Ribka, Laban rahyeta amurkye, neke Betuel ananke ma yosy a nus Mesopotamiake, iry a Aramke. ");
INSERT INTO slu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kyoat desike Ribka lema ika anan de myakw. Lemade Ishak syambayan ti Hulasokwe, dendye Hulasokwe tyomolu wasi sambayanke mane hyalas a i. Lemade sawa-na yor tenanke, ");
INSERT INTO slu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","desikeo naman lakduare ti sawa-na hteike, keskyede naman desikre rawaway lanidik. Lemade Ribka isike kyiw mait ma byu de byohe, “Kyanmwane kutot a ktela neke ti tenakkwe ne de?” Lemade syambayan ti Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Dendye Hulasokwe byu ti i de byohe, “Hnuke kutuke enaru sir desy ralamkwe kralake. Naman deru desikre klyosu ohe mudur hahak hnuke kutuke enaru, desikeo ana it de imnisik a it. Amurkye hyareta ma kryesik auskwe, ode auskwe tyomolu toha amurkye bo.” ");
INSERT INTO slu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kyait wasi hul o ain ma Ribka idur hah bonyo, ananke lakdu, ma deruke wamwany sir. ");
INSERT INTO slu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Auskwe iblunke tseak mermer ode kihusy. Lemade raki i ma ani Esau. (Kali Esau kbuanke o “Ihusy.”) ");
INSERT INTO slu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ode anan idake radur ti i bonyo simake kikumkumak Esau tikake. Lemade raki i ti Yakub. (Kali Yakub kbuanke o “Tika.”) Kyoat desike Ishak wasi ainke hean-nem, bonyo nenmo Ribka idur ti naman deru desy. ");
INSERT INTO slu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Naman deru desikre rlean ma lan sir bonyo, Esau idoha kotutke ti utno arwala, kali dyakin ma imin boare. Klala wai amurkye wasi mormyorifke mamwaw i bo, ode dyakin ma imin sekye kralake bo. ");
INSERT INTO slu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishak neke kyalamo iloblobak anan auskwe kali ama-na dyakin ma nya heal o ail idohanare. Klala enatke iloblobak anan amurkye bo. ");
INSERT INTO slu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kyoat desikeo Yakub malmata inoha kotw, ode wai auskwe ti idoha ma nenmo mya ma yait, bonyo imlalar. ");
INSERT INTO slu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Lemade tyanuk ti wai amurkye de byohe, “Wai, lema kika kotw e? De kumlar a ksyalik! Mal slyety mermer munoha desike anana ma ku.” (Lemade rhaly a i ti a Edom, kali Edom kbuanke o “mermer.”) ");
INSERT INTO slu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Keskyede Yakub hyalas Esau de byohe, “Kou, keskye mal wasimw auskwe ma yaw aduk.” ");
INSERT INTO slu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Lemade Esau byu huruk de byohe, “Ausw desike kyal sai ma yaw de? Malmata kumlar ma nenma kmwaty mane.” ");
INSERT INTO slu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Keskye Yakub byu huruk de byohe, “Muhwab aduk ohe ana mal wasimw auskwe ma yaw.” Dendye Esau ihwab huruk ode byuma wasi auskwe kibsisy toha simake ti wai amurkye bo. ");
INSERT INTO slu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Lemadendye Yakub yal rotkye ode slyety mermerke tebikan ti wai auskwe ma nya. Ode wai auskwe ina maktei bonyo yenw werke maktei o, bya. Lemadendye Esau wasi ktela desike kyaranran tenanke a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nus desike laarke lan ti, kola heitlulswo Abraham myorif a nggorake. Desike bonyo Ishak bya ti yait Abimelekh, neke Filistinare wait Rajake oa hnu Gerarke. Ode Ishak iten ma lemamo ramin so. ");
INSERT INTO slu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ishak iten ma ramin o so kali Hulasokwe syusu I ti i ode byu eta ma byohe, “Kete mbyai Mesir, ");
INSERT INTO slu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","de mimin nus ne bo. Ode ana kuhnyarak mamak a o, ode kal eraske ti o. Nuske ktem neke ana kal ti o ma ti ktyudak ebnwo anamw, kola tun kutanuk ti amamw Abrahamke neke: ");
INSERT INTO slu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","‘Ana kala o ma muka tesnwo natumw ma aryarimy htunare ti lait ne. Ode ana kal Kanaan o Gerar neke ktemke mumu ti tesnwo natumw. Ode khyali tesnwo natumw desikre, iry a madurak lasmyerke khaha ne mumu ana rosy eraske toha sir.’ ");
INSERT INTO slu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ana kal eraske ti o, kali amamw Abraham kyalamo tyomolu tun kutanuk ti iare ode tyoha wasikw haretare.” ");
INSERT INTO slu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Lemadendye Ishak imin oa Gerar bo. ");
INSERT INTO slu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kyoat desike iry mamin wen desikre rena Ribka toha i, bonyo byohe, “Wamfwet neke rahyetakw a i.” Ode imtaut ma byohe, “Sawaku i ne,” kali ryekan o Ribka eras i lanidik ode Ishak imtaut o ana irire rtabahunw a i ode ral wamfwet eras desy. ");
INSERT INTO slu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ode Ishak imin so ma klenke soso ata, desyo sekwe it bonyo raja Abimelekh yatos a yosy jendelake o Ishak yor wamfwet desy, it de yoy a it. ");
INSERT INTO slu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lemadendye Abimelekh yabuk Ishak ode byu ti i de byohe, “Wamfwet munor desike bain-bain o sawamu i desy! Ode kyanmwane mubu ohe rahyetamw a i ne de?” Desike bonyo Ishak hyalas i de byohe, “Raja o, kumtaut ohe ana kyal nini irire rtabahunw a yaw ode rasoruk a i.” ");
INSERT INTO slu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Keskyede Abimelekh byu ti Ishak de byohe, “Nam sai ne muala ma aramy miatos ne de? Kolnye wasikw irire dum a renaf ror sawamw desikemo ana mal salke sara aramy.” ");
INSERT INTO slu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Lemadendye Abimelekh tyunik haretke ti ribun lan mamin nus desy ma byohe, “Esei yala atyat ti iry neke yor sawa, desikemo ttabahunw a i lakhidik.” ");
INSERT INTO slu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Dendye Ishak idurak a lasmyer desy ode nyoha boluhu-boel ma itot kotkwe mo mausw-mausw kyety kunwo-kwaya ti ainke krala desy (100 kali lipat), kali Hulasokwe yal eraske ti i. ");
INSERT INTO slu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Wasi malolkye it de ktyabtabal it ma nam lan-lan. ");
INSERT INTO slu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Dendye Filistinare rsoi ralat ti i, kali wasi biby o domba nekre ribun sir, ode ika wasi at ma ribun sir dakun. ");
INSERT INTO slu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dendye Filistinare rahlun wer heit a Ishak ama Abraham wasi atare rakalire mumu, ode rautun lasmyerke ma kyahlun eta. ");
INSERT INTO slu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Lemade Abimelekh tyanuk ti Ishak de byohe, “Mbwetik toha ara wasimy hnuke, kali lan o ma mrwesik aramy de.” ");
INSERT INTO slu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Lemadendye Ishak byetik toha nus desike ma bya ti ika hnu o Gerar a ktebtebanke ma myon ti desy. ");
INSERT INTO slu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Desike bonyo Ishak kyaly huruk wer heitlulswo ama-na ikalire. Kali Abraham imaty bonyo, wer desikre Filistinare rahlun eta. Lemadendye Ishak yaki wer desikre ti ktyoha kani Abraham iakinare. ");
INSERT INTO slu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ode kyoat Ishak wasi atare rakaly wer ti Gerar a ktebtebanke bonyo, werke kbyurik ma lan. ");
INSERT INTO slu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Dendye iry malaka biby o domba ti wen desikre railir ror Ishak wasi irire ode rbohe, wer desike wait. Dendye Ishak yaki wer desike kanike ti Esek (kbuanke o “Kyety inailir”). ");
INSERT INTO slu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Lemadendye Ishak wasi irire rkaly a wer salik, bonyo kyety a inailir huruk dendye Ishak yaki wer desy ma kani Sitna (kbuanke o “Rasoruk”). ");
INSERT INTO slu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Lemadendye byetik toha wen desy ma kyaly a wer salik, desikeo lema kika inailir o namit-namit. Dendye Ishak yaki wer desy ma kani Rehobot (neke kbuanke o “Nuske maelelke”), desyo byohe, “Nenmo Hulasokwe yal wen maelelke ti nus ne ma tamin ti sew ne mane. Lemade tmorif eras ode lema kika inailir o namit-namit, ode tamin ne ma tbes ti wen ne ma taka ity ebnwo anat.” ");
INSERT INTO slu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Maktei bonyo Ishak yosy wen desy ma byai Bersyeba. ");
INSERT INTO slu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ode metdyet desike dakun o, Hulasokwe mya ma syusu tenanke ti i ma byohe, “Ishak o, Yaw neke amamw Abraham wasi Hulasow a Yaw. Kete mumtaut! Yaw ne khwarak mamak a o. Ode ana kal eraske ti o. Ana kala o ma mrwesy a nuske ktem ne. Kala kolnye kali kola klwosu tun nekre mumu ti wasikw iry a Abraham.” ");
INSERT INTO slu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Lemadendye Ishak iutun wen isob tike ti desy ma kyalamo lyeru Hulasokwe Anike ti desy, ode imin desy ma wasi atare rkaly wer salik huruk. ");
INSERT INTO slu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sekwe it bonyo Abimelekh yosy a Gerar yor Ahuzat, neke wasi iry a masurat namke, ode Picol dakun, neke Abimelekh wasi suldatare wait uskwe khatuke. Iry nekre rma ma rait Ishak. ");
INSERT INTO slu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Lemadendye Ishak yena sir de byohe, “Kyanmwane mima ma miseak yaw kolnye ne de? Kola lenla mimnisik yaw ode mmyesak yaw toha nusamkye e?” ");
INSERT INTO slu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bonyo rhalas ma rbohe, “Nenmo aramy mhye o dene Hulasokwe hyarak mamak a o. Lemade aramy mryekan eraske ma lemamo aramy mihatetak myor o ma ");
INSERT INTO slu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","lema muilir mor aramy ode aramy dakun o lema myala atyat o. Klala kola heitlulswo aramy myala eras ti o ode aramy mlyura o ma mbwa mo eraske kitotoha o bo. Aramy myatos elik ohe dene Hulasokwe yal eraske ti o.” ");
INSERT INTO slu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Lemadendye Ishak hinau sir ma raknam o ra o renw. ");
INSERT INTO slu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ode bolbolbol ne bonyo, it de ihatetak yor it ma rsob. Maktei bonyo, Ishak lyura sir eras-eras ma rbetik toha i ma rba, ode ia imin ti desike ma eras-eras bo. ");
INSERT INTO slu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kyoat sew desike bonyo, Ishak wasi atare rma ma rlosu ti i de rbohe, “Aramy mkyaly a werke ma aramy mitot werke de!” ");
INSERT INTO slu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Lemadendye Ishak yaki wer desy ti kani Syeba (kbuanke o “Rahatetak”), mane kyait sew ne, hnu desike raki ti Bersyeba (kbuanke o “Wer Rahatetakke”). ");
INSERT INTO slu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kyoat Esau wasi ainke hean-at (40) bonyo yala ma isa. Isaa yor wamfwetke enaru. Ita ani Yudit desyo ama-na ani Beeri. Ode ita ani Basmat desyo ama-na ani Elon. Wamfwet deru neke rosy a hnu Hetke. ");
INSERT INTO slu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wamfwet deru desike wait mormyorifare atyat a ksyalik ti Esau ama-na yor ena. ");
INSERT INTO slu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kyoat Ishak amosw i lahuk de ode mata deruke ahwahw ma lema myatakit ti de myatakit ma, lemade yabuk Esau, anan auskwe, de byohe, “Esau!” Desyo Esau hyalas, “Wee, Amo.” Desyo ama-na byu ti i de byohe, “Mmwai san!” ");
INSERT INTO slu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Dendye Ishak byu ti ananke de byohe, “Mhwe ma amosw a yaw mane de, ode anakyai lema kmworif soso de. ");
INSERT INTO slu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Lemamo mal wasimw husw o rama ode mbwa ti mudoha heal o ail ti utno arwala. ");
INSERT INTO slu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ode mmwa ma mnwoha ma mtelas kola kudakinke maktei o mety ma ku. Ana kuna maktei bonyo, kuten eraske toha Hulasokwe ti o elyelik lenla kumaty ne.” ");
INSERT INTO slu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ishak yor Esau wait inahestun desike Ribka tyomolu. Ode ana Esau bya ti a idoha heal bonyo, ");
INSERT INTO slu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka yabuk Yakub ma lyosu ti ma byohe, “Amo, dai ktwomolu tun a amamu itanuk ti Esauke ohe, ");
INSERT INTO slu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mudoha healke it ma mnwoha ma matetelas ma ku, ode ana kuna maktei bonyo, kuten eraske ti o ma Hulasokwe yatos ana lenla kumaty ne.’ ");
INSERT INTO slu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Lemade anakw o mtwomolu, ode mnwoha nam kutanuk ti oke. ");
INSERT INTO slu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mbwai ity wait a bibire ramin tike ode milika mamsun eras desike enaru, ode mmwa ma knwoha ma mtelas kola amamu idakinke. ");
INSERT INTO slu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Maktei bonyo mety ba ti amamu nya mamo iten eraske ti o, elyelik lenla imaty ne.” ");
INSERT INTO slu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Keskyede Yakub a byu ti ena de byohe, “Eno, de lema Esau tenanke kihusy e, klala yakwe lema? ");
INSERT INTO slu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ana kyal nini amaku yamas tenakkwe desikeo hye ohe kukakmet a i, ode anakyai lema iten Hulasokwe ma yal eraske ma yaw de iten ma yal atyatke ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Desike bonyo ena-na byohe, “Kete mumtaut de andeka yaw khwar atyat desikre mumu. Mtwoha nam kutanukare ode adoko mbwa ti mal biby eras desikre!” ");
INSERT INTO slu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Lemade Yakub bya ti yal biby eras desikre ode yor sir ma ena. Mya ma inait bonyo, ena-na nyoha heal desikre ma mtelas kola ama-na idakinke. ");
INSERT INTO slu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Maktei bonyo ena-na yal Esau wasi rabit eras isosan ti sekye ode yal ti Yakub hyonak. ");
INSERT INTO slu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ode yal bibkye iblunke ma yal ma hyula sima o tela, kali Yakub lema ihusy. ");
INSERT INTO slu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Maktei bonyo yal kotw a mtelas desikre ktyabal roty ena-na inoha desikre ma yety ba ti ama Ishak. ");
INSERT INTO slu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Lemade Yakub bya ti inait bonyo yabuk ama de byohe, “Amo! Amo!” Desikeo ama-na hyalas i de byohe, “Ou, kabei o de? Oi neke Esau o ta Yakub o de?” ");
INSERT INTO slu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Desikeo Yakub byohe, “Amo, Esau yaw, anamw auskwe. Wasimw a nam mutanukare knwoha de. Mane mtwaklulw ode mu heal kudoha nekre ma adoko muten eraske ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Lemade Ishak byohe, “Anakw o, mbwa ti mudoha ode muma neke mtew lan ko!” Bonyo Yakub byohe, “Kali Hulasow a mutohakke syaluk a yaw nde.” ");
INSERT INTO slu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ode itanuk koldyesy bonyo Ishak byu ti Yakub de byohe, “Desikemo mmwa ma mswuri o mai san, ma kamas a o ohe bain o oi neke Esau o ta kabei o de.” ");
INSERT INTO slu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Lemade Yakub yarasik ama, ode ama-na yamas a tenanke ode byohe, “Telamw neke kola Yakub telake, keskye simamure kola Esau simanare.” ");
INSERT INTO slu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ishak lema hye toha Yakub kali simanare kihusy kola Esau simanare, keskye kyoat Ishak yala ma iten eraske ti i desikeo yena i huruk de byohe, ");
INSERT INTO slu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Bain-bain o Esau oi ne e?” Bonyo Yakub byohe, “Mlay, Amo.” ");
INSERT INTO slu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Lemade Ishak tyanuk ti i de byohe, “Mal healke kisi desy ma yaw. Ana ku maktei bonyo kuten eraske ti o.” Ishak itanuk tun desike maktei bonyo, Yakub yal healke kisi desy, ode tua minminake ti ama-na yenw. ");
INSERT INTO slu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ama-na yenw ma ktei bonyo tyanuk ti i de byohe, “Msuri o mai san, ode moy a yaw.” ");
INSERT INTO slu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Lemade Yakub tyoha ama-na tunanare ode bya ti yoy ama bonyo, ama-na lyos a Esau rabit ihonakke, dendye iten eraske ti i de byohe, “Anakw o mhwon eras kola dene boluhu-boel Hulasokwe inal eraske ti ne. ");
INSERT INTO slu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Lemamo Hulasokwe yal yekwe kyosy laitke ti wasimw a boluhu-boel, ode yal eraske ti a wasimw a kariaare ma mutot kotu kisi ribun-ribun. ");
INSERT INTO slu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ode lemamo hnuke kutu nekre rtomolu toha o, ode waimw ribun lan ne rtomolu toha o dakun. Ode ana atyatke ktyoha iry a masoba oare, klala eraske ktyoha iry a maala eras ti oare.” ");
INSERT INTO slu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ode Ishak iten eraske ti anan Yakub maktei ma iba bonyo, wai ausw Esau kele rsoru ia yosy wen idoha tike ma mya. ");
INSERT INTO slu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Lemade inoha kotw ma mtelas ode yety ba ti ama-na nya, ode tyanuk ti ama de byohe, “Amo, mtwaklulw ma mu nam kunoha nekre ma adoko muten eraske ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ama-na yena i de byohe, “Esei o de?” Bonyo Esau byohe, “Yaw nde, Amo.” ");
INSERT INTO slu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ishak itomolu Esau telake bonyo tenanke ktemke kyamlulurw ode yena de byohe, “Wah! Esei ne dai inety a kotw mtelas ma kuna nalohdaike ode kuten eraske ti i ma iba so de? Kali eras kuten ti i desike eras bain-bain ma ana yosy nini nam bo.” ");
INSERT INTO slu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ode Esau itomolu tun ama-na itanuk desike bonyo, syer ma ti kisalsal ode byu ti i de byohe, “Amo, muten eraske ma yaw dakun.” ");
INSERT INTO slu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lemade ama-na byohe, “Waimw amurkye dai mya ma yakal yaw ma hyury ma kuten eras konyo kuten ti oke ti i ma bya de.” ");
INSERT INTO slu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ode itanuk koldyesy bonyo Esau byohe, “Edo, Yakub yakal yau kdi a kla-ru mane, kolnye mane ani Yakub ne. Mya ma kal wasikw auskwe ti i de ma yobak ma ryesik yaw, maktei bonyo mya ma yal wasikw eras konyo kunalke huruk. Edo, Amo, lema kika wasimw eras ida ma muten ma yaw e?” ");
INSERT INTO slu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Bonyo Ishak byu ti i de byohe, “Ana kala i ma yola dene wasimw lalanke, ode hatnimamire ana rtomolu toha i bo, ode kal kotw o abw ribun lan ne ti i. Ode lema kika nam ma kal ti o de.” ");
INSERT INTO slu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Bonyo Esau lema byuma imres de yolak toha ama bo, ode byohe, “Lema kika wasimw a eras salik ma ana muten ma yaw e? Amo, muten eraske ma yaw dakun!” Ode tyanuk koldyesy ode syer toha. ");
INSERT INTO slu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Esau itanuk koldyesy bonyo, ama-na byu ti i de byohe, “Lema kika yew manosy lait ti o de, lema kika wasimw boluhu-boel eras, ");
INSERT INTO slu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","de ana mukahrea nini-nini nam bo, ode mtwomolu toha waimw amurkye. Ode ana mou ti i ode mtwoha i bo, mtwoha ninie muka keyer ma lema muka at ti i huruk.” ");
INSERT INTO slu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ma dai itomolu ama-na tun itanuk desike bonyo, Esau imnisnisik Yakub kali ama-na iten eraske ti i. Lemade Esau tyanuk ti ralake de byohe, “Ode krwekan mo ana lema soso desikeo amaku myaty, ode kyait ma aramy misera i maktei bonyo ana ktwabahunw a Yakub.” ");
INSERT INTO slu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ode kyoat Ribka itomolu ohe Esau ana tyabahunw a Yakub bonyo, yaso ma rabuk Yakub ma tyanuk ti i de byohe, “Mtwomolu, waimw ausw Esau ryeky ma ana tyabahunw a o. ");
INSERT INTO slu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Lemamo mtwoha nam kutanukke: adoko mbwaa samlurw ti mait narakw Laban o hnu Haranke. ");
INSERT INTO slu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ode mumin o so ma mor memimw nini klenke soso ma Esau wasi keyerke kitayar ");
INSERT INTO slu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ode imluluak toha nam mualanare desike bonyo kaso irire dum ma ti rabuk o ma mmwa. Kali kubrai anakw deruke ratayar ti sew sasamke.” ");
INSERT INTO slu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lemade Ribka tyanuk ti Ishak de byohe, “Kelik ode lema kdwakin ma katos Esau sawa manosy hnu salik nekre, ode kolnye Yakub byuma isaa yor wamfwet manosy hnu Hetke it mo, lemamo kmwaty lakhidik.” ");
INSERT INTO slu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Maktei bonyo Ishak yabuk Yakub ma yal eraske ti i ode tyanuk ti i de byohe, “Yakub, kete musaa mor wamfwet manosy nus Kanaan ne. ");
INSERT INTO slu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lemamo mbwai nus Mesopotamiake ti mait ena-mu wasi irire, neke Betuel sir, ode musaa mor memimw Laban anan wamfwetke it. ");
INSERT INTO slu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Lemamo Hulasokwe hyarak mamak o, ode yal eraske ti o ma musa desy mo anamure ribun sir ti kyal tesnwo natumw nekre dakun! ");
INSERT INTO slu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Lemamo Hulasokwe hyarak a o, ode yal eras Abraham inosy desike ti o dakun, ma ana molik o ma musoruk ma mosy ode mtwenas ti hnuke ktem nekre mumu ma kete mola iry mahlolwainare ma ktyoha Hulasokwe ihatetak ti Abrahamke.” ");
INSERT INTO slu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Lemadendye Ishak yaso Yakub ma byai nus Mesopotamiake ti yait memi Laban ode ebu Betuel iry a Aram-are, Laban neke Ribka nara auskwe, ode Ribka neke Esau yor Yakub enatke. ");
INSERT INTO slu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ode Esau itomolu ma Ishak iten eraske ti Yakub ode yaso i ma byai nus Mesopotamiake ti yobak wamfwet ma isaa yor i oso. Ode kyoat a Ishak iten eraske ti Yakub desikeo byu eta ma kete Yakub isaa yor wamfwet nus Kanaanke. ");
INSERT INTO slu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ode Esau itomolu ohe Yakub tyoha ama-na yor ena-na tun ratanukare ode byai Mesopotamia. ");
INSERT INTO slu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Desikeo nenmo Esau hye ohe ama Ishak lema dyakin wamfwet manosy nus Kanaan-are. ");
INSERT INTO slu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Lemade Esau bya ti yait ama Ismael, Abraham ananke, ode isaa yor Ismael anan wamfwetke ma ani a Mahalat, neke Nebayot rahyeta. ");
INSERT INTO slu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakub byetik toha hnu Bersyebake ode byai hnu Haranke. ");
INSERT INTO slu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kyoat desikeo sekwe bya de, ode bya nini yait wenke it bonyo sewah a kyali i ti desy. Lemade yulik a i ma yenah ti desy ode yal hatkwe ma lyun. ");
INSERT INTO slu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ode yenah desikeo myey ohe, yatos a areske it mo atat a ksyalik ma ti ktyutw laitke, ode Hulasokwe wasi nyasoare rorw de rsai ares desy. ");
INSERT INTO slu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ode ti areske ktutu desike yatos Hulasokwe ma indidiry ode tyanuk ti i de byohe, “Yakub, Yaw neke Hulasow a Yaw, Hulasow a Abraham yor Ishak rasob ma Yaw ne. Ode lasmyer muenaf ti neke ana kal ti oa mor tesnwo natumw. ");
INSERT INTO slu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tesnwo natumw ana aryarit ahkwe ti lasmyer ne, ode ana rhela nusatke ti hnuke ktem nekre mumu. Ode nuske ktem madurak lasmyerke khaha neke mumu ana rosy eraske, khyali oa mor tesnwo natumw. ");
INSERT INTO slu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mnwenas! Ana kswaluk o, ode ana kulaka o ode kor mamak a o, kolnye mbwai kabei ta kabeio, ana kala kolik o ei hnu neke bo. Ana lema ktwutuk lakhidik a o nini knwoha nam ribun lan kutanuk ti oare bo.” ");
INSERT INTO slu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ode Yakub imsel ma byatar ode tyanuk ti ralake de byohe, “Edo, Hulasokwe imin wen ne, keskyede nenmo khwe.” ");
INSERT INTO slu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Itanuk koldyesy bonyo imtaut ode tyanuk de byohe, “Wen neke kyety matatwaut, desikemo Hulasokwe imin wen ne bain-bain, ode wen neke Hulasokwe wasi sekye ne ode holholat sra ne kimlakat dakun.” ");
INSERT INTO slu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ana ti bolbolbol ne bonyo Yakub byatar ode yal hatw ilun desike ma yoditi ti wen desy ma kyeluk hatw ma yalamo inenenas. Ode yalik nul zaitunke ti hatw desike ma yal ma nyenas Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ode yaki wen desike ti kani Betel. (Kali Betel kbuanke o “Hulasokwe wasi sekye.”) Hnu desike heitlulswo kani Lus. ");
INSERT INTO slu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Lemade Yakub syob ode byu de byohe, “Hulasow O! Kolnye ana mlwobak yaw ode mor mamak yaw ti kuba de kuma ne, ode mal rabit o kotw o abw ma yaw ");
INSERT INTO slu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma ana kolik yaw bai amaku seike o eras-eras yaw bo, desikeo nenmo ktwohak Hulasow O mmwesan bo. ");
INSERT INTO slu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ode ana kal hean a ktera ti Hulasow O toha nam munal ma yaure. Ode hatw kusadiri neke ana kyeluk wen ma kswob ti Hulasow o Animkwe.” ");
INSERT INTO slu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakub syaur wasi laklakutke ma byai hnuke it oa kseri timur nus Kanaan so. ");
INSERT INTO slu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Lyakut ma bya-bya nini yatos mait werke it ma kimin nusmeske kditlalan ne. Ode yatos dombake kmetake enatelw ma rbob ma raneney wer desike, kali kyalamo ti renw wer desy. Ode wer desike hatw lanke it a kkyahat eta. ");
INSERT INTO slu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kolnye ti wer desike healare raka kmeta ma rawahuk sir mumu ti desy, desike nenmo iry a malaka sirare raditi hatw lan desike ei kserike maktei o rtol ma ral ti renw. Raenw maktei bonyo iry malaka sir desikre rkahat eta wer desy huruk. ");
INSERT INTO slu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ode Yakub bya ti yatos sir bonyo yena sir de byohe, “Hei, liakkwe, miktemtem myosy kabei de?” Iry desikre rhalas i de rbohe, “Aramy myosy Haran.” ");
INSERT INTO slu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“De mhye amam Laban, Nahor anan ne, e?” “Ou, aramy mhye i.” ");
INSERT INTO slu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“De i desy yolkya?” “I desy eras-eras i bo. Matos! Anan wamfwetke ani Rahel ma i ne inor ama-na wasi dombanare ma rama ne.” ");
INSERT INTO slu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Lemade Yakub ikita ma byu de byohe, “Sekwe dyutw nggora ma lenla kyait ma ror heal bai wenat a ramin tiare. De kyanmwane lema myal wer ti domba nekre raenw de mitutuk sir ma rana tnyeinare bony ne de?” ");
INSERT INTO slu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bonyo rhalas i de rbohe, “Lema koldyesy. De aramy mikita iry malaka dombanare ma rawahuk sir mumu ti ne, desikeo nenmo aramy mlyilik hatw desy ma heal nekre renw werke.” ");
INSERT INTO slu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Malmata Yakub itun a yor iry desikre, kele rsoru Rahel ma mya o yor ama-na wasi dombake kmetake ");
INSERT INTO slu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ode Yakub iatos Rahel bonyo, byai wer desy ode lyilik hatw ranal ma rakahat wer desy ei kserike, ode yal werke ti memi-na wasi heal desikre ma renw. ");
INSERT INTO slu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Maktei bonyo Yakub yoy a Rahel ode syer ma telake lan. ");
INSERT INTO slu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ode tyanuk ti Rahel de byohe, “Yaw neke amamu rahyeta Ribka ma anan yaw.” Lemade Rahel ila yolik i bai sekye ti lyosu ti ama. ");
INSERT INTO slu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ode ama-na itomolu brit desike bonyo, ila ma mya ma yait Yakub ode kyora i ma yoy a i. Maktei bonyo yor i bai seike kralake ti Yakub ihes wasi mormyorifke ti memi. ");
INSERT INTO slu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lemadendye memi-na byu ti i de byohe, “Tun mutanuk nekre mlay mumu ma oi neke rahyetaku anan a o.” ");
INSERT INTO slu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yakub yor memi Laban sir ti desy nini hulke sasam, lemade Laban byu ti Yakub de byohe, “Toto, mane ana mkwarya ma yaw koldyesy bony e? De mbwuma kal sai ti o de?” ");
INSERT INTO slu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban neke anan wamfwetke enaru. Auskwe ani Lea ode amurkye ani Rahel. ");
INSERT INTO slu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea neke matake madededan bo, klala Rahel neke eras a i. ");
INSERT INTO slu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakub iatos deruke bonyo, ralake kdyakin Rahel ma byuma isaa yor i. Lemadendye tyanuk ti memi Laban de byohe, “Memi, ana kkwarya ti o ainke itw ma mo kusaa kor anamw amury a Rahel desy.” ");
INSERT INTO slu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lemade memi-na byohe, “Ode mor yaw ti ne ainke itw, desikeo nenmo musaa mor Rahel. Lema eras ma kal Rahel ti iry salik rasaa ror i, ode oke lema. De lemamo kal i ti o bo, kali msalenakw elik-elik a o.” ");
INSERT INTO slu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Lemadendye Yakub kyarya ti desy ainke itw ma ana isaa yor Rahel, keskye ryekan mo lema soso kali dyakin wamfwet desy ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kyarya ti memi Laban nini ainke itw maktei bonyo, Yakub bya ti byu ti i de byohe, “Memi, kkwarya nini kbyilak ainke itw de. Ode hekyabei o mal anamw desike ma kusaa kor i de?” ");
INSERT INTO slu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lemade memi-na hyalas i de byohe, “Mukita ma tala kalkalke it aduk.” Dendye rabuk ribun lan ne ma rma ma raka kalkalke ti desy. ");
INSERT INTO slu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ti sewah desy dakun bonyo Laban yor Lea ti Yakub. (Keskye kelerkok ma Yakub lema hye ohe Rahel i ne Lea ne.) Lemade yenah yor i bo. ");
INSERT INTO slu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Desikeo dai inal Lea ti i ne, Laban yal wasi atke it ti Lea, neke ani Zilpa, ma ana syeak ti Lea.) ");
INSERT INTO slu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Msarinke bonyo Yakub kele rsumuk mait i kali yatos o Lea i ne! Lemade bya ti byu ti memi de byohe, “Memi, mala tot atyat sai ma yaw ne de? Kkwarya ainke itw ma kobak ma kal a Rahel. Ode makal a yaw ma mor Lea ma kusaa kor a i. Memi, kyanmwane muakal yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","27","Lemade memi-na hyalas i de byohe, “Kyalamo lasmyerke kwatan mamin wen aramy mimin ti neke amurkye lema isa kmuna auskwe. De auskwe isa kmuna amurkye. Desikemo mukita ma kalkal neke ktei aduk. Mamode nenmo kor a Rahel ti musaa mor a i. Keskyede mkwarya ma yaw ainke itw huruk.” ");
INSERT INTO slu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Sekwe itw ma kalkalke ktei bonyo Laban yor Rahel ba ti Yakub. ");
INSERT INTO slu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Desikeo yal wasi atke it ti Rahel dakun, ma ani Bilha. It o it o yor wasi at.) ");
INSERT INTO slu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Desike bonyo Yakub yenah yor Rahel. Lemadendye Yakub kyarya ti Laban ainke itw huruk, ode kyala kyosy desike Yakub lema dyakin Lea de dyakin Rahel bo. ");
INSERT INTO slu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Sew kyaki neke Hulasokwe syeak ma Yakub lema dyakin Lea de dyakin Rahel bo. Lemade Hulasokwe yala ma Lea mdedan i ode Rahel myakw. ");
INSERT INTO slu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea mdedan i ma idur ma ananke wamwany a i. Desike bonyo Lea tyanuk ti ralake de byohe, “Hulasokwe syeak ralakw matolke, ode laiku ana dyakin yaw kali kudur ma anakkwe wamwany a i.” Lemade raki naman desike ma ani Ruben. (Kali Ruben kbuanke o, “Hulasokwe syeak ralakw matolke.”) ");
INSERT INTO slu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ramin desy nini Lea mdedan i huruk. (Mdedan i kali wasi sambayanare Hulasokwe tyomolu.) Lemade idur bonyo Lea tyanuk ti ralake de byohe, “Hulasokwe tyomolu ohe laiku lema dyakin yaw mane kudur ma anakkwe wamwany i huruk.” Bonyo ani Simeon. (Simeon kbuanke o, “Hulasokwe tyomolu.”) ");
INSERT INTO slu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ramin desy nini Lea mdedan i huruk ma idur bonyo ananke wamwany i huruk. Lemade tyanuk ti ralake de byohe, “Anne aramy myety ral sasamke ma kudur ma anakkwe enatelw ne ma wamwany sir mumu.” Lemade naman desike raki i ti Lewi. (Kali Lewi kbuanke o, “Rety ral sasamke.”) ");
INSERT INTO slu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ramin desy nini Lea mdedan i huruk ma idur bonyo anan neke wamwany i huruk. Lemade raki i ma ani Yehuda kali Lea tyanuk ti ralake de byohe, “Selsel ne kbwitil o ksumuk Hulasokwe Anike.” (Yehuda kbuanke o, “Byitil o syumuk.”) Bonyo Hulasokwe yala Lea ma myakw aduk. ");
INSERT INTO slu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahel iatos ma wai ausw Lea ika anan ma ribun bonyo, syoi rala wai auskwe, kali Rahel lema ika anan. Lemade byu ti lai de byohe, “Lema muka anamw ma yaw e? Lemamo ana kmwaty.” ");
INSERT INTO slu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Lemade Yakub kyeyer a Rahel ma byu de byohe, “De Hulasow a yaw e? Ma mbwuma kal namanke ti o e?” ");
INSERT INTO slu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Lemade Rahel byu ti Yakub de byohe, “Wasikw a atke i ne. De mal i ma mkwol i ma kyait o anakw a i bo ode ena yaw.” ");
INSERT INTO slu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Lemadendye Yakub kyola Bilha ma ika anan ti i ");
INSERT INTO slu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ma mdedan i, ma idur bonyo ananke wamwany a i. ");
INSERT INTO slu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ode Rahel byu de byohe, “Hulasokwe syeak ralakw nelnyelkye ode tyomolu wasikw sambayanare mane yal naman ne ma yaw.” Lemade raki i ti Dan. (Kali Dan kbuanke o, “Hulasokwe syeak rala nelnyelkye.”) ");
INSERT INTO slu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha mdedan i ma idur huruk ");
INSERT INTO slu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","bonyo Rahel byohe, “Ana kalkyaw yaw ma kbwilak waikw auskwe.” Lemade raki naman desy ti ani Naftali. (Kali Naftali kbuanke o, “Kalkyaw yaw.”) ");
INSERT INTO slu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ryekan o ana lema ika anan de, lemade yal wasi at Zilpa ne ti lai-na kyol i ma ika anan ti i. ");
INSERT INTO slu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Dendye Zilpa mdedan i ma idur, idur bonyo ananke wamwany a i. ");
INSERT INTO slu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lemade Lea byohe, “Kosy eraske huruk!” Mane raki naman desy ti Gad. (Kali Gad kbuanke o, “Yosy eraske.”) ");
INSERT INTO slu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ramin desy nini Zilpa mdedan i ma idur huruk. ");
INSERT INTO slu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lemadendye Lea byu de byohe, “Kumukmuka yaw, ode wamfwet ribun lan nekre ana rbohe, ‘O Lea imukmuka i a ksyalik.’” Lemade raki naman desy ma ani Asyer. (Asyer kbuanke o, “Imukmuka i.”) ");
INSERT INTO slu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kyait inakety o nam bonyo Ruben byai boare, desikeo itot a mohw inaka ananke it. Lemade yety ma ti ena. Inety ma ti ena bonyo Rahel byu ti Lea de byohe, “Lea, mal mohw desy anana ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Desyo Lea byu ti Rahel de byohe, “Kal laikw ti o ma mal i de, ode ana kal mohw anakkwe itot ne ti o huruk e?” Lemade Rahel byu ti Lea de byohe, “Ande kal laikw ti mkwol i metdyet ne, ode mal mohw desy ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kyoat Yakub yolik i toha boare ma mya bonyo Lea ikita ma byu ti i de byohe, “Mala ma metdyet neke menah mor yaw, kali kal mohw inaka ananke ti Rahel de. Mane mkwol a yaw sewah ne.” Lemade Yakub kyol a Lea metdyet desy. ");
INSERT INTO slu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ode Hulasokwe tyomolu Lea wasi sambayanare, lemade mdedan i huruk ma idur hah, desyo ananke wamwany a i. Ma Lea anan wamwankye enasim sir. ");
INSERT INTO slu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea byu de byohe, “Hulasokwe yal nyalukake ma yaw ma ksyoi eta ktela kunal wasikw atke ti laiku sawa hah i ne.” Desike bonyo yaki naman desy ti ani Isakhar. (Kali Isakhar kbuanke o, “Nyalukake.”) ");
INSERT INTO slu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Maktei bonyo Lea mdedan i huruk, ");
INSERT INTO slu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","lemade byohe, “Hulasokwe yal nyaluka eras-eraske ma yaw, ode ana laikw yalan tenakw ne, kali kudur hah a kla-nemake mane.” Bonyo raki naman desy ma ani Zebulon. (Kali Zebulon kbuanke o, “Alanke.”) ");
INSERT INTO slu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Maktei bonyo Lea mdedan i ma idur hah huruk, desyo ananke wamfwet a i, ma raki naman desy ti ani Dina. ");
INSERT INTO slu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ode sew kyaki nekre Rahel syambayan ti Hulasokwe ma Hulasokwe tyomolu wasi sambayanare. ");
INSERT INTO slu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Dendye yala i ode lyura i ma mdedan i ma idur hah, desyo ananke wamwany a i. Lemade Rahel byu de byohe, “Hulasokwe yaditi yaw toha mamyaikw o nam nekre. Lemamo Hulasokwe tyabal namanke sasam huruk.” ");
INSERT INTO slu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Lemade naman desy raki i ti Yusuf. (Kali Yusuf kbuanke o, “Lemamo tyabal sasam huruk.”) ");
INSERT INTO slu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Kyoat Rahel idur ti Yusuf bonyo Yakub byu ti memi Laban de byohe, “Memi, mlwura yaw kor sawakw deruke ode anakure ma aramy mbyai hnuakw, kali mhwe ohe khyali sawakw deru desy kkwarya lan ti oke mo lan dakun de.” ");
INSERT INTO slu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lemade Laban byu de byohe, “Toto, mtwomolu aduk. Kolnye mdwakin yaw mo, mtwenas ti ne aduk, kali nenmo kuob ma khwe o Hulasokwe yal eraske ma yaw neke khyali o. ");
INSERT INTO slu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","De mbwu sai ma kal ti o de?” ");
INSERT INTO slu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakub byu ti memi de byohe, “Memi, mhwe ma kkwarya lan ti o a ksyalik, ode ksweak mamak wasimw biby o domba. ");
INSERT INTO slu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kuma khyehyeike mo wasimw a nam nekre ratebibikan bo, keskyede selsel neke wasimw biby o domba o lan o hnutamw ne ribun de. Kali khyali yaw Hulasokwe yal eraske ti o. Ode hekyabei o kkwarya ti sawakw o anakw nekre de?” ");
INSERT INTO slu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Desikeo Laban byu ti Yakub de byohe, “De mbwuma kal sai ti o de?” Bonyo Yakub byu de byohe, “Memi, kete munal namit-namit ma yaw. Kolnye ana kuseseak mamak wasimw a biby o domba nekre bo, klala kuten o ma mtwoha nam kutanuk ne. ");
INSERT INTO slu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mlwura yaw ma senweke kbwa koly wasimw a biby o domba nekre ma ksweak sir ma konyo domba o biby desikre iblutare kirekryeki, ode ror domba anat metmetare, desyo kal sir ma wasikw mumu ma kyeluk makolikkwe bo. ");
INSERT INTO slu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ode kyait teike mo, Memi mbwa ti mbwihy wasikw biby o domba nekre, de kolnye mutot biby o dombake it ma lema irekryeki i, ta dombake ananke it ma lema metmet a i, desy mo Memi heal kunametke i desy.” ");
INSERT INTO slu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lemade Laban byu ti Yakub de byohe, “Toto, kou nam mutanukare mumu.” ");
INSERT INTO slu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Keskyede sew desike Laban bya ti yilik domba o biby a marekryeki iare ror domba anat metmet nekre mumu ode yal ti ananare ma rseak ti sir, ");
INSERT INTO slu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ode Laban ror sir ba. Rba-rba nini sekwe enatelw ma soso sir toha Yakub, klala biby o domba ktera desikre Yakub syeak mamak sir bo. (Yakub hye ktela Memi Laban iala ti desy, keskyede mamwaw i bo.) ");
INSERT INTO slu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lemade Yakub yal akwe ksanake enatelw ma bya ti syisik kiblunare ma kola dene nam mareki i nekre, ");
INSERT INTO slu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","maktei o yal ti a bibire wenat kyalamo raenw a wer tike kralanare, kali heal desikre rdakin ma rasai ti werke khihi desy. ");
INSERT INTO slu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kyoat heal desikre rasai bonyo rmatakit aw ksana detelw isisik desy. Lemadendye biby o domba desikre radur ti anatare desikeo, kele rlaik ti iblutare metmet o bokbok (kola dene dai aw ksana isisik ma bokbok o metmet desikre). ");
INSERT INTO slu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakub syalik a biby o domba marekryeki iare ror domba anat metmet desikre mumu toha Laban wasinare ma yosy, ma ika wasi domba o biby a kmeta mesmesan bo. ");
INSERT INTO slu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ode kolnye biby o domba malkyakaw nekre rala ma rasai bonyo, Yakub yal aw ksana detelw isisik nekre ma yal ti wait wen raenw wer tike kralanare ma kolnye rasai mo rarasik aw ksana isisik desikre. ");
INSERT INTO slu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Klala lema yal aw ksana desikre ti heal lublubare. Lemade heal lublubare Laban yosy a sir bo, klala heal malkyakaure Yakub yosy a sir. ");
INSERT INTO slu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Lemadendye Yakub wasi lan o hnutan nekre ribun ode wasi biby o domba o unta o keledainare rtabal wasi atare ribun sir ma ika iry lan. ");
INSERT INTO slu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kyoat desike, Yakub a tyomolu o memi Laban a anan wamwanire ma rbohe, “Yakub a yal ity amatke wasi maloly a ribun lan ne, ode maloli nekre kyosy a ity amatke malolike.” ");
INSERT INTO slu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakub yatos mo memi Laban lema ralake eras ti i kola heitlulswo de. ");
INSERT INTO slu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lemadendye Hulasokwe byu ti a Yakub de byohe, “Molik a o ei amamw a hnua ti mait hatnimamure. Ana kuhnyarak mamak a o.” ");
INSERT INTO slu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Lemade Yakub yaso irire ma rlosu ti a Rahel yor a Lea ma rba ti rait a i, ti wena ilaka biby o domba oa boare. ");
INSERT INTO slu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Deruke ti ranait bonyo Yakub a tyanuk ti sir de byohe, “Katos mo amamkye lema eras i kola heitlulswo ma yaw de, keskyede Hulasow a amaku isob tike hyarak mamak yaw bo. ");
INSERT INTO slu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Miru mhye dakun ohe kola kkwarya ti amamkye ma kungkoli kumahal, ");
INSERT INTO slu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","keskyede amamkye yakal yaw ma yulak wasikw a katkye kdia kla-hean elik, keskye Hulasokwe lema lyura amamkye ma syusu tot a atyatare ma yaw. ");
INSERT INTO slu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kyoat desike amamkye tyanuk ma yaw de byohe, ‘Kolnye radur ti biby a marekryekiare, desikeo ana kal sir ti o ma kyeluk a makolimkwe.’ Lemade kyoat biby desikre radur bonyo, anatare rarekryeki sir mumu. Ode kyoat amamkye iatos ktela desy bonyo yulak i huruk ma byuma, kolnye ana radur ti biby a matahak a bokbok o metmetare desikeo kosy a sir. Lemade biby desikre radur bonyo anatare ratahak bokbok o metmet a sir mumu. ");
INSERT INTO slu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Lemade ktyoha ksala ne Hulasokwe yal amamkye wasi biby o domba desikre ma kosy a sir.” ");
INSERT INTO slu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yakub tyanuk huruk de byohe, “Ode kdi ti a kseunare ma ana mlol ma biby o domba desikre rasa-ralan a sir, desikeo kmwey o katos a biby a wamwanire ma rasai, desyo iblutare kirekryeki ode ratahak bokbok o metmet. ");
INSERT INTO slu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ode ti meikw desike Hulasokwe wasi nyaso manosy laitke tyanuk ma yaw ma byohe, ‘Yakub!’ Desikeo khwalas. ");
INSERT INTO slu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Bonyo nyaso desike byu huruk de byohe, ‘Matos, biby a wamwany a masai desikre, rarekryeki sir ode ratahak a bokbok o metmet a sir. Yaw ktwenuk desikre ti o mumu ma desy, kali katos mo Laban yala ktela atyat nekre ti o bo. ");
INSERT INTO slu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yaw neke Hulasow a yaw, ma sew desike kswusu yaw ti o oa Betel, ma ti soke moditi hatw desy ma kyalamo munenenas a yaw, ode hatw desike malik nul zaitunke ti ma mal ma kindika wen kyalamo musob ma Yakwe. Lemamo adoko mala ma molik o bai wenamw a radur ti o ke.’ ” ");
INSERT INTO slu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Itanuk maktei bonyo Lea yor Rahel a rhalas Yakub ma rbu de rbohe, “Kolnye, ara amamkye lema ika maloli ma ana aramy myosy de. ");
INSERT INTO slu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ode ryekan aramy o myola dene iry a madakan nekre ti a irire nusat bo. Ode kyeta aramy ma yal ma byuak nam ibuare, desike ode nam desikre hyalodur mumu ma ktei de. ");
INSERT INTO slu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mane wasimw maloly ribun lan Hulasokwe inal toha ara amamkye neke kolnye ara wasimy ode ity anatare wait dakun. Lemamo mtwoha nam a Hulasokwe itanuk ti oare.” ");
INSERT INTO slu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Lemadendye Yakub a yamlurw ma adoko bya ti a yait a ama oa nus Kanaanke. Dendye syalak a sawa o anan ti untake, ode dai yeuk a wasi biby o domba nekre rtabal wasi a sakar o sakar mamin ti Mesopotamia ode rba. ");
INSERT INTO slu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kyoat desikeo Laban malmata imin oa boare ma kyotal a dombanare husitare, ode lenla raba bonyo Rahel syukar ma inameta ama-na wasi irkye kwaltwan kyalamo malaka sirke. ");
INSERT INTO slu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Lemadendye Yakub a yakal Laban ma lema lyosu a wasi babake ti i. ");
INSERT INTO slu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Dendye yal wasi maloly ribun lan nekre ode yamlurw ti wasi babake, lemade ilaa tyusya sah Efratke ma byai kususwan a Gileadke. ");
INSERT INTO slu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nenmo sekwe enateluke bonyo irire dum a rlosu ti Laban ohe Yakub a ila toha sir. ");
INSERT INTO slu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lemadendye Laban iwahuk a hatnimanare ode raktemtem a radoha Yakub ti a sekwe itw elik, ma rait i o kususwan a Gileadke. ");
INSERT INTO slu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Metdyetke bonyo Hulasokwe mya ma syusu i ti Laban, neke Laban myey ma Hulasokwe byu ti i de byohe, “Mnwenas! Murontyo mala atyat a Yakub ma mutun atyat ti i elik.” ");
INSERT INTO slu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kyoat Laban inait Yakub bonyo, Yakub yor a wasi irire rsadiri wait a lasyerire ti kususwanke it a khaha de, lemade Laban yor a hatnimanare rsadiri wait a lasyerire ti wen desy dakun. ");
INSERT INTO slu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma ana ktei bonyo, Laban a byu ti Yakub de byohe, “Yakub, kali kyanmwane muakal a yaw ne de, ode mulaka anakure ba ma rola dene iry a rakumak eta ti inamdiriat a kralanare ne de? ");
INSERT INTO slu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ode kyanmwane muakal yaw ma muba ode lema mutuly ta muhalas yaw, de mamwaw o bony ne de? Kolnye kyalake mtwuly a yaw, anakyai e klwura o ma mbwa ode kaso ma rtutw a ninily o nam ma krela ode ramukmuka sir ma ror o ba. ");
INSERT INTO slu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ode kyanmwane lema mlwura yaw ma koy a ebukw o anakw ma klyosu ohe aramy misalik aramy ne de? Yakub, ktem a o ti wasimw a ktela ne bain. ");
INSERT INTO slu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yaw ne malkyakaw a yaw ma kolnye kala atyat ti o de, keskye detke Hulasow a amamw isob ti neke mya ma byu eta yaw ma kurontyo kala atyat ti o elik-elik. ");
INSERT INTO slu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yaw khwe dakun ohe muba neke, mdwakin ma molik o ti msweak waimw o amamw, keskye kyanmwane munamet a irkye kwaltwan malaka aramy ne de?” ");
INSERT INTO slu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Desike bonyo Yakub a ikita ma hyalas de byohe, “Kuba ode lema kutuly o kuhalas a o ne kali kumtaut ode krwekan ohe ana muneti anamw a wamfwetare toha yaw. ");
INSERT INTO slu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Keskye ti irkye kwaltwan desy, kolnye mutot a iry a manametke it ma imin ne, desikemo ana tamatik a i. Lemamo adoko mbwihy ohe wasimw a nam dum ne kimin a yaw ti ne mo, kyosy o ma mal bo, ode iry a manalke lemamo the i mumu.” Yakub a lema hye ohe Rahel i ne inamet a irkye kwaltwanke ne. ");
INSERT INTO slu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lemadendye Laban byai a Yakub a wasi lasyerkye ma syukar ti iskyui-iskyay wer o nam ma iobak, desyo lema itot. Dendye yulak i ma byai Lea wasi lasyerkye, maktei bonyo, syukar Yakub sawa deru hah desikre waitare, keskye lema itot a namit-namit ti, nini bya ate bai a Rahel wasi lasyerkye. ");
INSERT INTO slu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","(Lenla ibai a Rahel wasi a lasyerkye bonyo Rahel yal irkye kwaltwan desy ma ryoka bai untake wasi aryarkye ksakake, ma kimin a wasi lasyerkye kralake. Ode ia tyaklulw a aryarkye khaha desy ma yeteta.) Lemade Laban syukar ei Rahel wasi lasyerkye ma yobak ti. ");
INSERT INTO slu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Bonyo Rahel a tyanuk ti ama de byohe, “Amo, kete muka keyer a yaw o lema kumdiry ma ksweak a o, kali wasikw hul a atyatke ne.” Ode Laban yobak wasi walut desike keskye lema itot elik. ");
INSERT INTO slu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Lemadendye Yakub ika keyer de byohe, “Memi, mane wasikw tot atyat kuala ti o neke kimin o ka?” Tyanuk ode ikery nisy bo. “Salakw sai ne lanidik mane mudohdoha yaw kolnye ne de? ");
INSERT INTO slu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ode muhnutuk a lanakure maktei, dendye mutot wasimw a wer o nam e? Mal nam ribun desikre mumu ei mloskye ode muwahuk ti hah ne ma hatnimakure ode hatnimamure ratos, ma rhe ohe ituru neke kabei sal i ode esei mlay i de. ");
INSERT INTO slu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kor o a ainke hean-ru (20) ma ksweak mamak wasimw a biby o domba ma raka anat ma eras-eras sir bo. Ode lenla ohe ku a biby a wamwankye it toha wasimw a biby o domba kulaka ain dehean-ru ne elik. ");
INSERT INTO slu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ode kyoat a heal mahatw ranat wasimw biby o domba nekre lema kety tbunatare ba ti matos sir elik-elik, kali yaw kmwesan kal wasikure ma keluk sir bo. Ode heal iry ranamet metdyet o msarin nekre kyalamo mataut yaw ma keluk sir ti o dakun. ");
INSERT INTO slu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Seure rait mo msarinare rala manas ma yaw, ode metdyetare desyo mbrin a yaw. Dum mo lema kenah dakun. ");
INSERT INTO slu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Wasikw morif kyoat kukarya ti a o ain dehean-ru neke: ainke hean a kresi enaat kkwarya ma kutot anamw deru desy, ode ainke nem huruk desyo kutot a biby o domba kmetake. Ode kyoat desy dakun o makal eta wasikw a katkye kdi a kla-hean. ");
INSERT INTO slu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kolnye Hulasow a Abraham yor Ishak rasob tike lema syeak mamak yaw mo, oi ne maso yaw ma kolik yaw watwatan bo. Keskye Hulasokwe yatos makolikw lan a kunoha nekre, ode detke tyanuk ohut ti o maktei de.” ");
INSERT INTO slu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lemadendye Laban hyalas Yakub de byohe, “Yakub, wamfwet deru desike anakw a sir, ode anatare desyo anakure dakun. Wait biby o domba desikre wasikw dakun. Bain-bain ohe nam ribun lan muatos ti neke yaw ne wasikw. Keskye lema kala namit-namit ma kyety eta ebukw o anakw. ");
INSERT INTO slu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Lemadendye mmwa ma tahatetak ma taktemtem a tsob ode ttenuk hature ma kyeluk nyatos ma kete it de imluak it.” ");
INSERT INTO slu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lemadendye Yakub yal hatw mamin desike it ode syadiri ti desy. ");
INSERT INTO slu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Desike bonyo Yakub yaso a wasi irire ma rily a hature ma rautun. Maktei bonyo, raktemtem a rtaklulw ma lema soso sir toha utun desy ode raknam. ");
INSERT INTO slu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban yaki utun desy ma kani a “Yegar-Sahaduta” (kbuanke ohe, “Utun malosu tun rahatetak” toha tel Aramaikke) klala Yakub yaki utun desy ma kani Galed (kbuanke ohe, “Utun malosu tun rahatetak” toha tel Ibranike). ");
INSERT INTO slu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Wen desike kani Galed kali Laban tyanuk ti Yakub de byohe, “Hatw rautun neke taki kaninare ma kyalamo it de inenenas it.” ");
INSERT INTO slu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ode wen desike dakun o raki kanike ti Mizpa (kbuanke o, “Wen ramdiry tike ma rseak ba”), kali Laban tyanuk huruk de byohe, “Ana tasali ity mane, keskyede Hulasokwe yatos ituruke bo. ");
INSERT INTO slu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ode kolnye mala atyat ti a anakure, ta lemamo musaa mor wamfwet salik, ma lema kika iry mahe, keskye munenenas: Hulasokwe iseseak itkye bo. ");
INSERT INTO slu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hatw tautun nekre klyosu ohe ituru attah sasam ity. ");
INSERT INTO slu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Hatw utun nekre klyosu ohe kete kaklean ti kala atyat ti o, ode kete maklean utun desy mai san ma mala atyat ma yaw. ");
INSERT INTO slu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ode Hulasow a Abraham yor ebukw Nahor rasob ti I neke ana yohut ity tunat sal o mlay.” Lemadendye Yakub yalela ti Hulasow a ama Ishak isob ti Ike ma tyoha tun itanukare. ");
INSERT INTO slu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ode tyabahunw a healke it ma yabar ti kususwan desy ba ti Hulasokwe. Maktei bonyo yabuk wasi irire ma rma ma raktemtem a raknam. Ode raknam maktei bonyo, rametdyeta sir ti kususwan desy. ");
INSERT INTO slu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lemadendye bolbolbol ne bonyo, Laban yoy ebnwo anan ma rasalik sir, ode iten eraske ti sir, maktei o Laban yolik i bai hnu imin tike. ");
INSERT INTO slu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakub syaur wasi laklakutke ma bya nini Hulasokwe wasi nyasoare rosy laitke rma ma ranala ror i. ");
INSERT INTO slu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ode Yakub iatos sir bonyo, byu de byohe, “Hulasokwe wen lasyery ireit tike ne.” Lemadendye raki wen desike ti kani Mahanaim (kbuanke o, “Wen lasyery rareitke enaru”). ");
INSERT INTO slu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Maktei bonyo Yakub yaso wasi matumarare ma rmuna i bai Edom ti rait kausu Esau ti nus Seirke. ");
INSERT INTO slu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakub yal haretke ti iry desikre de byohe, “Mlyosu ti waikw ausw a Esau kolsyan, ‘Yaw ne Yakub, wasimw iry a yaw. Ma yaw ne kor memikw Laban nini kyait sew ne mane, ");
INSERT INTO slu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ode yaw ne kuka wasikw saby o keledai o domba o biby, ktyabal wasikw atare dakun. Ode kal brit ne ti ebukw a Esau ma klwosu yaw ti i ma dyakin yaw.’” ");
INSERT INTO slu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Lemade matumar desikre rba ti rlosu brit desy ti Esau. Maktei bonyo rolik sir ma rait Yakub ode rbu ti i de rbohe, “Aramy mbya ti myait waimw ausw a Esau de, mane i ne ima ne. Mya o yor irkye atkwe enaat (400).” ");
INSERT INTO slu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakub itomolu brit desy bonyo, imtaut a ksyalik ode lema hye nam iala. Lemade ihe iry a manor iare ma tairke enaru rtabal wasi a biby o domba o saby o unta o nam. ");
INSERT INTO slu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kali ryekan ohe ana Esau mya ma imdiriat ma syekan tairke it, desikemo tair idake rala toha i ma robak morhyatke. ");
INSERT INTO slu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Lemadendye Yakub syambayan ma byohe, “O Hulasow a ebukw Abraham yor amakw Ishak rasob ti Oke, kyalake maso yaw ma kolik yaw bai hnuakw ti kait hatnimakure. Ode Hulasow O, Oi ne mbwuma ana mtwenuk eraske ma yaw. ");
INSERT INTO slu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yaw neke khwe ohe lema kbwer o ktwahal ma kosy namit-namit toha O elik, keskye kyanmwane munal nam ribun lan neke ma yaw ne de? Khwe ma kyoat kubai memikw Labanke ma kew sah Yordanke, desyo lema kunety namit-namit elik, de lenla tektekanke bo. Ode selsel ne kolik yaw huruk, desyo kor a tairke enaru mane. ");
INSERT INTO slu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Hulasow O, lemamo mhwarak mamak yaw toha waikw Esau ode muhnyarak sawakw o anakw, kali kumtaut o ana mya ma tyabahunw aramy. ");
INSERT INTO slu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kali knwenas a nggora kola mtwanuk ma yaw ma mal eraske ma yaw, ode mala yaw ma tesnwo natukw ribun sir, ma lema irkye it a yaki yal ara aryarimkye kola laran mamin a namwata ne.” ");
INSERT INTO slu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ode metdyet desike renaf ti desy. Msarinke bonyo Yakub a yal wasi a biby o domba desikre kindika nyaluka ti wai ausw a Esau. ");
INSERT INTO slu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nyaluka desikre biby a ltyenke atkwe enaru (200) ode biby a wamwankye hean-ru (20), domba ltyenke atkwe enaru ode domba wamwankye hean-ru, ");
INSERT INTO slu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","unta masuswakwe hean-telw (30) ror anatare, ode sabiltyenke hean-at (40), ode saby a wamwankye hean (10), keledai ltyenke hean-ru ode wamwankye hean. ");
INSERT INTO slu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Heal desikre ihe a isakar sir ti wasi atare, ode tyanuk ti sir de byohe, “Mlyakut ma mitoha e ode myala e ma klenare maelel tebikan.” ");
INSERT INTO slu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakub yal haretke ti wasi at mamunake ma byohe, “Kolnye, waikw ausw a Esau mait i ti sal a klen ode yena o de byohe, ‘Ebumw ese i de? Ode ese helan nekre ode mala ma mbwai kabei ne de?’ ");
INSERT INTO slu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Desike bonyo mhwalas i de mbwohe, ‘Ara Ebumy a o, ode atamw a Yakub wasi ma yosa sir ti o, de i ne itoha mane.’” ");
INSERT INTO slu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Maktei bonyo Yakub tyanuk ti at matoha mamunake yor idanare de byohe, “Mtyoha haret sasam kutanuk ti at mamuna desy, ");
INSERT INTO slu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ode kete mimluak ma mlyosu ti ebukw a Esau ohe, ‘Atamw a Yakub i ne itoha mane.’” Kali Yakub ryekan ohe, yal heal nekre ma yaluka Esau ralake ma kolnye ana it de yait it desikemo Esau ika eras a yor Yakub. ");
INSERT INTO slu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Dendye yosa kmuna heal inal desikre ti Esau, klala ia yenah ti wen ireit ti desy bo. ");
INSERT INTO slu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Metdyet a kditlan desike Yakub byatar ma yor a sawa deruke, rtabal sawa hah deruke ode ananke hean a kresi sasam ma rba ti rew a sah Yabokke. ");
INSERT INTO slu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Maktei o yolik i ma yal wait nam ribun lan ne ma yosa bai sahke serida desy huruk. ");
INSERT INTO slu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ode myesan imin desy bo. Imin desy ma lema klenke soso bonyo wamwankye it a mya ma yait Yakub ma deruke it de yal it nini msarin a kyal sir. ");
INSERT INTO slu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kyoat desike iry desike kyoman ma lema yala yal Yakub dendye yoban Yakub lakbiake kusuke ma kyamai. ");
INSERT INTO slu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ode iry desike byu ti Yakub de byohe, “Mtwunik a yaw ma adoko kbwa, kali ana lema soso bonyo sekwe byetik de.” Keskyede Yakub byohe, “Ana lema ktwunik a o kolnye lenla mal eraske ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Lemade iry desike yena i de byohe, “Animw ka?” Bonyo hyalas i de byohe, “Anikw a Yakub.” ");
INSERT INTO slu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Dendye iry desike ikita ma byohe, “Kyala kyosy ne lema animw a Yakub deny, de animw a Israel kali mubesak oa mor Hulasokwe ktyabal irire ma malkyakaw o ma mrwesik sir.” (Mane Israel kbuanke o, “Ibesak a ia yor Hulasokwe.”) ");
INSERT INTO slu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Maktei bonyo Yakub byohe, “Mlwosu animkwe dakun.” Keskye iry desike ibrai de byohe, “Kete mena anikkwe de.” Lemadendye iry desike yal eraske ti Yakub bo. ");
INSERT INTO slu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ti ktei bonyo Yakub tyanuk de byohe, “Kunal a kor Hulasokwe ode katos uno mata de, keskye lyura yaw ma kmworif a nggora.” Mane wen neke yaki kanike ti Pniel. (Pniel kbuanke o, “Hulasokwe Uno Mata.”) ");
INSERT INTO slu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Msarinke bonyo, Yakub byetik toha wen desy (Pniel), keskyede lakbiake ksuke ktyaksal. ");
INSERT INTO slu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mane kyala kyosy desy ma kyait senweke, Israel-are lema ra heal a kisi ma kahat a klakbianare, kali Hulasokwe yoban Yakub lakbiake kusuke. ");
INSERT INTO slu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakub yatos ti mo Esau yor a irkye atkwe enaat (400) a rma. Lemadendye ihe a isakar ananare ma ror a Lea ode Rahel rtabal sawa hah deru desy. ");
INSERT INTO slu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yal sawa hah deru desikre ror anat desikre ma rmuna ma ramin lulkwe. Maktei bonyo Lea yor ananare, klala Rahel yor Yusuf rosy a lyaw lahukke. ");
INSERT INTO slu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ode Yakub bya lulu ma myuna raktemtem mumu, ma bya ti ana iarasik kausuke desikeo syakitil ode you ti i kdia kla-itw elik. ");
INSERT INTO slu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Keskye Esau ila bya ti yait Yakub ode kyora i ma yoy a i ode it de syera it. ");
INSERT INTO slu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Maktei bonyo Esau byitil matake ma yatos a wamfwet desikre ror naman desikre bonyo, yena Yakub de byohe, “Wai, esekar ne ranor o ne de?” Lemadendye Yakub ikita de byohe, “Awa, anakure sir desy, Hulasokwe yal naman nekre ma yaw mane.” ");
INSERT INTO slu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Maktei bonyo sawa hah desikre ror anatare rma ma rou ti Esau. ");
INSERT INTO slu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Maktei o Lea yor ananare rma ma rou ti Esau. Ode manosy lyaw lahukke Rahel yor Yusuf rma ma rarasik ode rou ti Esau dakun. ");
INSERT INTO slu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Desike bonyo Esau yena de byohe, “Mala sai mor wasimw tair dai kunait nekre de?” Bonyo Yakub hyalas i de byohe, “Rma ma raluka ralamkwe nde.” ");
INSERT INTO slu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Keskye Esau byohe, “Malolikkwe kryesy dakun de. Ode lema kbwuma mal namit-namit ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Keskye Yakub byohe, “Lema! Kolnye, kaluka ralamkwe, desikemo, mal nam kunal ti o nekre. Kali katos o matos yaw mo lema mkweyer a yaw, lemadendye ti yaw neke, kuatos waiku matamkwe ne kola dene kuatos Hulasokwe ne dakun. ");
INSERT INTO slu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Dendye kuten toha o ma mal nam kuosa ti o desikre, kali Hulasokwe ralake eras ma yaw ode yal nam ribun lan kubu nekre mumu ma yaw.” Desikeo Yakub tyanuk ma lyuan lanidik dendye Esau yal nam desikre. ");
INSERT INTO slu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Lemadendye Esau byohe, “Mmya ma taktemtem ma tseak ma tala ma tba.” ");
INSERT INTO slu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Keskyede Yakub hyalas ma byohe, “Away, mhwe mane naman nekre raluh a nggora, ode yaw neke ksweak mamak heal masuswaw nekre. Kolnye teuk sir mirin sekwe sasam mo ana heal nekre rmaty mumu. ");
INSERT INTO slu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Lemamo oa mety lulkwe ode yaw ktwoha lyakwe kakan bo. Yaw klwakut kakan kor a heal nekre ode anakure nini aramy myait o ti Seir, nus Edom so bo.” ");
INSERT INTO slu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Lemade Esau tyanuk huruk de byohe, “Desikemo ktwutuk wasikw iry malaka yaure dum ma ror a e.” Keskye Yakub ikita de byohe, “Away, kete koldyesy. De kbwuma kete mrwekan namit-namit, ode kuten ma kolnye molik o mo ralamkwe eras-eras ma yaw bo.” ");
INSERT INTO slu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Lemadendye, sew desike Esau yolik i bai Seir, nus Edom, ");
INSERT INTO slu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","klala Yakub lema tyoha i de yulak i ma bai Sukot, ti ika likatke ti ma imin ti ode ika biby o domba wenat ma ramin ti desy dakun. Lemadendye wen desike raki kanike ti Sukot (kbuanke o, “Likatare”). ");
INSERT INTO slu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakub syoru wasi laklakutke nini yait hnu Sikhemke. Inait wen desike bonyo syadiri wasi lasyerire ti knyey hnu Sikhem desy. Lemadendye kyoat Yakub ilakut toha Paddan Aram, nus Mesopotamiake, ma yait hnu Sikhem ti nus Kanaanke, desyo lema namit-namit atyat ti i. ");
INSERT INTO slu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Maktei bonyo Yakub lyiw a lasmyerke tebikan toha Hemor-are ti Sikhem neke khesike kuban a blyawan bokbokke atkwe sasam (100) ma ramin ti. ");
INSERT INTO slu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ode iutun hature ma kyeluk wen rasob tike, ode yaki kanike ti “El Israel” (kbuanke o, “Hulasow a Israel-are Rasob ti Ike”). ");
INSERT INTO slu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sew desike, Lea yor Yakub de anat Dina bya ti yait wamfwet Kanaan nekre. ");
INSERT INTO slu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ma sew desike Hemor iry a Hewi neke ika orankay ti nus desy, ma anan Sikhem yatos warar Dina neke ma lyakut bonyo kyumak i ode ilaka i ba ti yala atyat ti i. ");
INSERT INTO slu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Iala ktela desy maktei bonyo Sikhem ralake kdi ti wamfwet desy bain-bain ode lyobak a i. Lemade yobak ma tyenauk o yaluka wamfwet desy ma adoko ralake kdyakin Sikhem dakun. ");
INSERT INTO slu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ode Sikhem byu ti ama de byohe, “Lemamo mbwa ti muten wamfwet ne toha ama ode naranare ma yaw, kali kbwuma kusaa kor a i.” ");
INSERT INTO slu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kyoat desike Yakub tyomolu ma ananke anike kiray de, keskye lema yala namit-namit kali ananare malmata ralaka wait a biby o domba o boare ma lenla rma. ");
INSERT INTO slu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Lemade Sikhem yor ama Hemor rma ma Hemor yobak ma itun a yor Yakub ma rtanuk a mlakye. ");
INSERT INTO slu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Keskye kyoat desike Yakub ananare nenmo rosy boare ma rma, ode ratomolu tun desy bonyo, kele rsumuk mait sir ma rkeyer a ksyalik i bo, kali Sikhem yala atyat ti Dina, neke Yakub anan i, Sikhem yala ktela ne kbuanke o yaranran Israel-are mumu ma desy. ");
INSERT INTO slu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Dendye Hemor tyanuk ti Yakub de byohe, “Anakw a Sikhem dyakin anamkwe, lemade kuten toha o ma mlwura anamkwe ma isaa yor anakkwe. ");
INSERT INTO slu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mmwa ma ttenuk mlakye ma tety a ral sasamke, ma lemamo wasimw a irire ror wasikw irire rasa ma it de yal it ma tahora tasai ity, ");
INSERT INTO slu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ode taktemtem a tamin nus ne bo, kolnye mdyakin ma mimin ne ma mika wasimy a wer o nam ti ne.” ");
INSERT INTO slu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Maktei bonyo Sikhem dakun o tyanuk ti Dina ama-na yor naranare de byohe, “Kolnye ralamire eras ma yaw desikemo mbyu nam sai ta sai o ana kunal ti eke bo. ");
INSERT INTO slu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mtyanuk ohe mdyakin sai ma kal ti e de. Ode mbyu blyawan sai ma kal ma kswelw insa ne de. Ana mbyu sai mo kal ti e bo. Keskye kuten ma mlyura ma kusaa kor rahyetamy desy.” ");
INSERT INTO slu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakub ananare rakakmet a Sikhem yor ama Hemor, kali rkeyer o Sikhem yala rahyetat Dina neke ma anike kiray de. ");
INSERT INTO slu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Lemade Yakub ananare rbu ti iry deru desy de rbohe, “Aramy mmyay ma mlyura ara rahyetamkye ma, isaa yor a iry a lema rakotal amoskwe kiblunare. ");
INSERT INTO slu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aramy mtyoha tun mitanukke, keskyede aramy miten toha e ma mtyoha nam aramy mitanukke dakun. Kbuanke o wamwany mamin hah ne mumu neke rkotal wait amoskwe kiblunare ma rola aramy ne. ");
INSERT INTO slu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Desikeo nenmo aramy mtyoha tun mitanukke ma tasa ma tahora tasai ity, ode taktemtem neke tadurak nus ne ma iry sasam ity. ");
INSERT INTO slu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Keskye kolnye lema mtyoha nam aramy mitanuk neke ode lema myou ma mkyotal wasimy amoskwe kiblunare, desikemo aramy mbya ti myal ara rahyetamkye toha seimkye ma, aramy myor i ma mbyetik toha nus ne.” ");
INSERT INTO slu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Keskyede Hemor yor Sikhem rkoman ma tun desikre mlay, ");
INSERT INTO slu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","dendye Sikhem yamluru ma tyoha tun Yakub yor ananare ratanukare kali ralake kdi ti Dina ksyalik. Ode ti Sikhem wasi awakye kralake neke raktemtem a rsumw a i, kali yety alalan ode itun mo rtoha tunanare. ");
INSERT INTO slu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Lemadendye Hemor yor Sikhem de rbai wen kyalamo rawahuk sir tiare ti lorkye kmatake ode tyanuk ti iry ribun lan mamin ti hnuke krala desy de byohe, ");
INSERT INTO slu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Irya Israel nekre rbuma rmorif eras ror ity, dendye taktemtem a tadurak a hnu ne ode kyosy a sir ma rbai kabei ta kabei bo. Nus ne lan a kryesik ma sir a ramin ti dakun. Ode iti tala mo tasaa tor a wait a wamfwetare, ode sir dakun o rasaa ror a ity wait a wamfwetare. ");
INSERT INTO slu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Keskye iry desikre rbuma wamwany ity nekre tkotal ity wait amoskwe kiblunare ma tola sir, desikeo nenmo rou ma ramin ti hnu ne ma iry sasam a ity. ");
INSERT INTO slu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ode ana wait biby o domba ktyabal wait maloly a ribun lan nekre iti tosy. De lemamo adoko mmya ma tou ode tlura sir ma rma ma taktemtem a tamin nus ne.” ");
INSERT INTO slu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Lemadendye hnuke kutu mawahuk i desikre rtoha tun Hemor yor Sikhem ratanukke. Dendye wamwany a lan mamin a hnuke krala desikre rkotal wait amoskwe kiblunare. ");
INSERT INTO slu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ode sekwe enateluke bonyo wamwany desikre rkoman a wait amoskwe ksunsununare nggora, lemade Yakub anan Simeon yor Lewi, neke Dina naranare, ral wait a kraire ode rba kakan ti rsukar hnu desy ma, rtabahunw a wamwanire mumu, ");
INSERT INTO slu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ode rsoli ral Hemor yor Sikhem dakun. Maktei o ral rahyetat Dina toha Sikhem seike ma ror i de rba. ");
INSERT INTO slu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ode ratabahunw o raha iry desikre maktei bonyo, Yakub anan idanare rsukar hnu desy, desikeo ratos o irire ribun a rmaty. Lemade ral nam ribun lan ne toha hnu desy ma kyeluk rahyetatke ani eraske, kali rkeyer o rahyetatke anike kiray de. ");
INSERT INTO slu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lemade ral biby o, domba o, saby o keledainare rtabal wait a wer o nam ribun mamin a hnuke krala desy ode mamin a wait a boluhu-boel nekre, ");
INSERT INTO slu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ktyabal wait a nam maka khesi lanare maktei o rkumak eta wamfwet o naman kakan mamin ti hnu desy dakun. Maktei bonyo rasoruk lakhidik wait a nam mamin a sey kralanare ma rety ba. ");
INSERT INTO slu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Lemadendye Yakub byu ti Simeon yor a Lewi de byohe, “Miru ne mhyury a atyatke ma yaw mane. Mhyury ma iry a Kanaan-are ror a Feris-are ode hnuke ktem ne ramnisik yaw ode ana rawahuk sir ma raktemtem a rhou yaw mane, ana rtabahunw o raha ity mumu ti ity seitke kralake mane, kali lema ribun a ity.” ");
INSERT INTO slu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Desike bonyo deruke rakita ma rbohe, “Amo, mdwakin ma Sikhem yala ara rahyetamkye kola dene wamfwet a malasur nekre e?” ");
INSERT INTO slu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ode sekwe it bonyo Hulasokwe byu ti Yakub de byohe, “Yakub, Yaw ne Hulasow a Yaw, ma kola kswusu Yaw ti o kyoat a mula toha waimw a Esauke. Lemamo adoko mbwa mirin bai Betel ma mumin o so, ode muutun wenke it ma kyalamo mkwotal heal ti ma mswob ma Yaw.” ");
INSERT INTO slu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Lemadendye Yakub byu ti sawa o anan ode iry a manoriare de byohe, “Ana tosy a ne ma tbai Betel, ma ti soke kuutun wenke it ma kyalamo kswob ti Hulasokwe. Hulasow malobak yaw ode masaluk a yaw ti a kyalamo atyatke kidan yaw ne. Ode klwakut bai kabei ta kabei mo inor mamak yaw ne bo. Dendye ado mbyisak wasimy a iry kwaltwan a misosan desikre ba, ode myatlyosik wasimy a mormyorifke ma nelnyely, ode mhyonak rabit a harharure.” ");
INSERT INTO slu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Lemade ral a wait a irire waltat o wait a nitwomatu ma ral ti Yakub ode ktyabal wait a blyawan rakasu ti tliatare ne, ma Yakub kyali ti aw lanke it a kusu maney a hnu Sikhem desy. ");
INSERT INTO slu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kyoat Yakub yor a sawa o anan o wasi luike ma raba bonyo, Hulasokwe yala matautke ti iry mamin a nus desikre ma ramtaut ode lema radoha Yakub yor a wasi luike. ");
INSERT INTO slu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ode ranait a hnu Lus (Betel) ti nus Kanaanke bonyo, ");
INSERT INTO slu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakub iuutun wen rasob tike, ode yaki wen desy ma kani a El-Betel. Iyaki kolnye kali heitlulswoke Hulasokwe syusu tenanke ti i ti wen desy, kyoat a Yakub a ila toha kausu Esauke. ");
INSERT INTO slu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kyoat desike Ribka wasi iry a maseak ti ike ani Debora neke myaty. Dendye rkali i ti aw lanke it a kusu mamin kseri seryab hnu desy. Lemadendye aw desy raki kanike ti a “Aw a raser ti kusuke.” ");
INSERT INTO slu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kyoat a Yakub yolik i toha Mesopotamia ma inait bonyo, Hulasokwe syusu i ti i huruk ode yal eraske ti i, ");
INSERT INTO slu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ma byu de byohe, “Animw Yakub, keskye kyala kyosy neke ana lema rabuk animkwe ti Yakub de, klala rabuk o ti Israel.” Lemadendye Hulasokwe yaki anike ti Israel. ");
INSERT INTO slu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Maktei bonyo Hulasokwe tyanuk ti i huruk de byohe, “Yaw ne Hulasow a Yaw, ma krwesik nitwomatun o iry kwaltwan kyalamo rasob ti nekre mumu. Lemade muka anamw ma myel ma mika nuske it, ode ana kyosy tesnwo natumw desikre raka nus a khatunare dakun, ma khyali o, tesnwo natumw ana raka Raja. ");
INSERT INTO slu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ode lasmyer a kunal ti Abraham yor Ishak neke kal ti o ode ana kal ti tesnwo natumw dakun.” ");
INSERT INTO slu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Maktei bonyo Hulasokwe tyutuk Yakub ti wen desy. ");
INSERT INTO slu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Lemade Yakub lyilik hatkwe it ma syadiri ti wen Hulasokwe imdiry tike, maktei o yalela i ti Hulasokwe ma yalik arakke ktyabal nul rala toha zaitunke ti hatkwe khaha desy. ");
INSERT INTO slu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ode yaki wen desy ti kani Betel. ");
INSERT INTO slu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Maktei bonyo Yakub yor wasi tairke rbetik toha Betel, ode rba nini lema soso sir toha hnu Efratke bonyo, kyait sekwe ma Rahel idur hah. Keskye yala ma idur hah o ksunw ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Idur hah maktei bonyo iry a manoha ike tyanuk ti i de byohe, “Kete mumtaut ode kete mala ralamkwe ma kakan kali anamw neke wamwany i huruk.” ");
INSERT INTO slu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Keskyede Rahel kyarasy ti matmyatike ode memeanke kyala ma ktei, dendye yaki anan desike ti ani Ben-Oni, keskye ama-na yeluk naman desike anike huruk ma yaki i ti ani Benyamin. ");
INSERT INTO slu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Maktei o Rahel myaty. Dendye rkali i ti salke kseri maba kola Efratke (hnu Efrat ne rahaly o Betlehem ne). ");
INSERT INTO slu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Maktei bonyo Yakub syadiri hatkwe it ti wen desy ma klyosu ohe Rahel rkali i ti desy. Ode kmya ma kyait senweke, hatw ne desi a nggora. ");
INSERT INTO slu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel (Yakub) isadiri hatw desy maktei bonyo, syaur wasi laklakutke ma bya ti byilak Migdal Eder bonyo, syadiri wasi lasyerkye it ti wen desy. ");
INSERT INTO slu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ma malmata ramin wen desy desikeo, sekwe it bonyo Ruben bya ti yenaf yor a Bilha, ama-na sawa hahke. Ode lema soso bonyo, ama Yakub a tyomolu tun desy ode kyeyer, keskye mamwaw ia kyor bo. Yakub anan wamwankye hean a kresi enaru sir (12). Neke ika anan toha sawanare ma anatare sir ne: ");
INSERT INTO slu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ananare sir ne: Ruben (naman ausw a i), Simeon, Lewi, Yehuda, Isakhar, ode Zebulon. ");
INSERT INTO slu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Desyo Rahel ananare sir ne: Yusuf yor Benyamin. ");
INSERT INTO slu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Klala Rahel a wasi atke ani Bilha ma ananare sir ne: Dan yor Naftali ne. ");
INSERT INTO slu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ode Lea wasi atke ma ani Zilpa ma anan a Gad yor Asyer. Anan desikre mumu radur ti sir oa Mesopotamia ti Padan-Aram so. ");
INSERT INTO slu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ode seure kieluk i ma sew desike Yakub ti rait ama Ishak oa wen a imin tike, neke kani Mamre (knyei a Kiryat-Arba, rhaly o Hebron). Wen desike heitlulswo ebu Abraham neke imin ti dakun. ");
INSERT INTO slu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Desike ode seure it de kieluk a it, ma Ishak amosw a i lahuk deny ma anianke atw ksala hean-walw (180) ");
INSERT INTO slu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","bonyo myaty. Lemade anan Esau yor Yakub rluk tbunanke ti bobke kralake (bob desike heitlulswo Ishak lyuk ama Abraham tbunanke ti dakun). ");
INSERT INTO slu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau tesnwo natu nekre ne rahaly dakun ti Edom ne. ");
INSERT INTO slu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau isaa yor wamfwet manosy hnu Kanaanke irkye enatelw. Sawa nekre sir ne: Ada, Oholibama ode Basmat. Ada neke, Elon manosy a hnu Hetke ananke. Ode Oholibama neke, ama-na ani Ana, ode ebu-na Zibeon yosy a Hewi. ");
INSERT INTO slu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Klala Basmat neke, Ismael ananke ode kamurike i ne ani Nebayot. ");
INSERT INTO slu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Mane Ada ananke i ne: Elifas ne; ode Basmat ananke i ne: Rehuel ne; ");
INSERT INTO slu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","klala Oholibama ananare sir ne: Yeusy, Yaelam, ode Korah. Naman desikre Esau anan sir mumu ma radur ti sir ti hnu Kanaan ne. ");
INSERT INTO slu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau iwahuk a sawa detelkwe, ananare, ode iry mamin wasi sekye kralake mumu, rtabal wasi biby o domba o lan o hnutat ribun inal toha hnu Kanaanke ne, maktei bonyo byetik ma tyutuk wai amury Yakub ti wen desy ode rbai nus salik. ");
INSERT INTO slu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ktela neke kdi ti kali Esau yor wai Yakub ne deruke malolitare ribun lanidik, ode ti nus desike kotkwe lema kyoat ma kyait kyal wait biby o domba ribun lan desikre mumu. ");
INSERT INTO slu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Lemadendye Edom (Esau ani idake) tyenas ti kususwan hnu Seirke bo. ");
INSERT INTO slu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau neke Edom-are ebut mamin a kususwan Seirke, ma tesnwo natu sir ne: ");
INSERT INTO slu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau sawa-na ani Ada desikeo idur bonyo, ananke wamwany i ma ani Elifas. Elifas neke isa desikeo anan wamwankye enasim sir, ma sir ne a: Teman, Omar, Zefo, Gaetam ode Kenas. Elifas sawa imruanke ani Timna. Timna neke idur ma ananke wamwany a i ma yaki i ti ani Amalek. Ode Esau sawa idake ani Basmat, desyo idur ti anan wamwankye it ma ani Rehuel. Ode Rehuel neke isa ma anan wamwankye enaat sir, desikeo sir ne: Nahat, Zerah, Syama, ode Miza. ");
INSERT INTO slu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Klala Esau sawa Oholibama, neke Ana anan a i ode Zibeon ebu i. Oholibama neke idur ma anan wamwankye enatelw o sir ne: Yeusy, Yaelam, ode Korah. ");
INSERT INTO slu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau tesnwo natu ratuhu ralai ranoskye: Elifas neke Esau anan ausw a i. Desikeo Elifas tesnwo natu sir ne: Teman, Omar, Zefo, Kenas, ");
INSERT INTO slu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gaetam ode Amalek. Sir neke mumu rtuhwo rlai rosy a Esau yor sawa Ada. ");
INSERT INTO slu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau anan Rehuel neke tesnwo natu sir ne: Nahat, Zerah, Syama, ode Miza. Sir neke mumu rtuhwo rlai rosy a Esau yor sawa Basmat. ");
INSERT INTO slu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Klala tesnwo natu manosy a lyaw nekre dakun o rtuhwo rlai rosy Esau yor sawa Oholibama ma sir ne: Yeusy, Yaelam, ode Korah. ");
INSERT INTO slu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sir neke mumu Esau (Edom) tesnwo natu ma it o it ika usu khatu ti wait away kralanare. ");
INSERT INTO slu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Seir neke iry Horike ode ebnwo anat mamin ti nus Edom desike sir ne: Lotan, Syobal, Zibeon, Ana, Disyon, Ezer, ode Disyan. Iry nekre mumu raka usu khatu ti wait away kralanare. ");
INSERT INTO slu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan neke anan wamwankye enaru o sir ne: Hori yor Heman. Ode Lotan rahyetake sasam ma ani Timna. ");
INSERT INTO slu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ode Syobal neke anan wamwanire sir ne: Alwan, Manahat, Ebal, Syefo, ode Oman. ");
INSERT INTO slu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ode Zibeon neke anan wamwankye enaru o sir ne: Aya yor Ana. (Ana i ne kyoat ilaka ama-na wasi a keledainare, desyo itot wer manaske ma kbyurak toha lasmyerke ti nus bakbak krala ne.) ");
INSERT INTO slu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ode Ana neke ma anan wamwankye it ma ani Disyon ode wamfwetke it ma ani Oholibama. ");
INSERT INTO slu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ode Disyon neke anan wamwanire sir ne: Hemdan, Esyban, Yitran, ode Keran. ");
INSERT INTO slu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ode Ezer neke anan wamwanire sir ne: Bilhan, Zaawan, ode Akan. ");
INSERT INTO slu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Klala Disyan neke anan wamwankye enaru sir o: Us yor Aran. ");
INSERT INTO slu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Lemade Seir ebnwo anan Lotan, Syobal, Zibeon, Ana, Disyon, Ezer, ode Disyan nekre raka usu khatu ti iry a Hori mamin ti nus Edom desike. ");
INSERT INTO slu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Raja mahareta ti nus Edom neke anitare rkesy ma kitoha-kitoha i mane (kyoat lenla kika iry maka Raja ti Israel-are): ");
INSERT INTO slu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ti nus Edom neke Raja mahareta mamunake ani Bela, neke Beor ananke. Raja Bela neke yosy a hnu Dinhabake. ");
INSERT INTO slu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ode kyoat Bela imaty bonyo, Yobab, neke Zerah ananke yosy a hnu Bozrake ma ika Raja ma yeluk a Bela. ");
INSERT INTO slu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ode Yobab imaty bonyo, Husyam yosy a Teman-are wait nuske ma ika Raja ma yeluk Yobab. ");
INSERT INTO slu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ode Husyam imaty bonyo, Hadad neke Bedad anan i ma ika Raja ma yeluk Husyam. Hadad i ne imdiriat ma rala ral Midian-are oa Moab-are nusatke ne, ode Hadad neke yosy a hnu Awitke. ");
INSERT INTO slu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ode Hadad imaty bonyo, Samla yosy Masreka ma ika Raja ma yeluk Hadad. ");
INSERT INTO slu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ode Samla imaty bonyo, Saul yosy a Rehobot mamin sahke khihi desy, mya ma ika Raja ma yeluk Samla. ");
INSERT INTO slu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ode Saul imaty bonyo, Akhbor anan Baal-Hanan neke, ika Raja ma yeluk Saul. ");
INSERT INTO slu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ode Baal-Hanan imaty bonyo, Hadar ika Raja ma yeluk Baal-Hanan. Desikeo Hadar yosy a hnu Pahuke ma sawa-na ani Mehetabeel, neke Matred ananke ode Mezahab ebuke. ");
INSERT INTO slu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Lemadendye, Esau ebnwo anan maka usu khatu ti wait iry mamin hnu desikre, neke raki anitare mane: Timna, Alwa, Yetet, ");
INSERT INTO slu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO slu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibzar, ");
INSERT INTO slu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, ode Iram. Sir ne iry maka usu khatu mahareta o Edom ti wen ramin tiare. Lemadendye Esau neke Edom-are ebnwo matrumat a i. ");
INSERT INTO slu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub imin ti a nus lan Kanaanke, kola heitlulswo nus ama-na imin tike. ");
INSERT INTO slu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ode tkunw a sekye krala Yakub neke ksalake ne: Yakub anan Yusuf neke wasi ainke hean a kresi itw (17) bonyo yor a wainare ralaka wait a biby o domba. Wai nekre Bilha ananare rtabal Zilpa ananare. Bilha yor Zilpa deruke Yakub sawa hah sir bo. Sekwe it bonyo Yusuf ihes ti ama ohe wainare totatare atyat. ");
INSERT INTO slu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakub neke lyobak a anan Yusuf ne ma kryesik anan ida nekre mumu, kali kyoat Yusuf radur ti i bonyo ama-na imtu de. Lemadendye sekwe it bonyo Yakub yal rabitke it ti Yusuf, neke eras a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wainare raseak ma amatke lyobak Yusuf bonyo ramnisik a i. Lemadendye lema ratun mamak ror i. ");
INSERT INTO slu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Metdyetke it bonyo, Yusuf a myey, ma msarinkeo ihes mei desike ti wainare, desike bonyo wainare ramnisik a i lan lahuk. ");
INSERT INTO slu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ihes mei neke ti sir ma byu de byohe, “Waikw ausw e, mtyomolu! ");
INSERT INTO slu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Detke kmwey ohe taktemtem a tamin boke kralake, ma tatubuk gandumare desikeo hinakw a gandumke kimdiry lol ma mlay-mlay. Ode ea mitubukare kkyoal eta kutubukke ti kditlanke, ode kyou ti wasikkwe.” ");
INSERT INTO slu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Itanuk koly desy bonyo wainare rbu ti i de rbohe, “Kali mbwohe ana lan o ma mhwareta aramy e?” Wainare rterik a i, ode ramnisik i lan-lan, khyali meike ode tunanare. ");
INSERT INTO slu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Metdyetke it bonyo Yusuf a myey huruk, desikeo ihes meike ti wainare de byohe, “Kmwey ohe katos a sekwe, hulke, ode htunke hean a kresi sasam (11) neke rou ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mei desike tyanuk huruk ti ama. Desike bonyo, ama-na tyerik a i de byohe, “Meimw sai desy de? Kali mrwekan ohe enamw o amamw ode waimure ana rma ma rou ti o e?” ");
INSERT INTO slu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Lemade Wainare ramninisik a i, klala ama-na irerekan a mey desikre bo. ");
INSERT INTO slu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sekwe it bonyo Yusuf wainare rbai hnu Sikhemke ti a ralaka wait a biby o domba, ");
INSERT INTO slu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ode Yakub byu ti Yusuf de byohe, “Toto, mbwai Sikhem ti mait waimure ma msyeak ity wait biby o domba o so.” Desike bonyo Yusuf a you. ");
INSERT INTO slu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Lemade ama-na tyanuk ti i huruk de byohe, “Mbwa ti matos waimure ohe rseak a ity wait biby o domba mamak ta lema de, maktei bonyo mmwa ma mlwosu ma yaw.” Itanuk ti i bonyo, Yusuf a byetik toha Hebron a ktebtebanke ma bya ti yait Sikhem. ");
INSERT INTO slu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Kyoat desike malmata bya de mya ti boke kralake bonyo, inala yor wamwankye it. Wamwany desike yena i de byohe, “Nam sai ne muobak ne de?” ");
INSERT INTO slu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Bonyo, Yusuf hyalas i de byohe, “Kuobak waikure, kali sir ne raseak ara wasimy biby o domba ne.” Lemade Yusuf yena i de byohe, “Mhwe sir o ramin o kabei de?” ");
INSERT INTO slu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Iry desike byohe, “Dai rbetik toha ne de. Ktwomolu ohe rbuma rbai a hnu Dotanke.” Desike bonyo, Yusuf tyoha wainare ma bya ti inala yor sir o Dotan. ");
INSERT INTO slu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ima-ma soso a i bonyo, wainare ratos i, ma lenla inait sir bonyo, rtanuk ma rbuma rtabahunw a i. ");
INSERT INTO slu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ma it de byu ti it de byohe, “Myatos, iry mamey desike mya de. ");
INSERT INTO slu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mmya ma adoko ttabahunw a i, ode totuk tbunanke ei werke kralake. Ode ana tlosu ti ity amatke de tbohe, heal mahature rasu-raahi i ma myaty de. Andeka tseak ohe mei desikre ana kolkyabei.” ");
INSERT INTO slu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben tyomolu nam rarekan nekre bonyo, yobak ma yaorif a Yusuf. Lemade Ruben a byohe, “Ete mtyabahunw a i! ");
INSERT INTO slu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Totuk lakhidik i ei wer bakbak desy kralake. Ode ete toban o ttaba i, ta lemamo ete tanuak i o namit-namit.” Tyanuk a ktela desy, kali ibuke ma yaorif Yusuf ode yaso i ma yulak i bai sekye. ");
INSERT INTO slu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lemade Yusuf inait wainare bonyo, rkumak malkyakaw i ma ronuk wasi rabit eras desike toha i, ");
INSERT INTO slu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ode rhait i ma rtunik i ei werke krala bakbak mamin ti desy. ");
INSERT INTO slu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Desikeo malmata raknamnam bonyo, ratos a iry a Ismaelke kmetake rma ma rosy a Gilead ma rbai Mesir. Ti wait untanare rlean nam a khesi lanare kola dene balsem o damar o nam ma ti o rketa o Mesir. ");
INSERT INTO slu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Dendye Yehuda tyanuk ti wainare de byohe, “Kbuan sai mane tabu ma tatabahunw a ity wait amury ne ode tahunik a ktela ne de? ");
INSERT INTO slu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mmya ma tketa i ti a iry a Ismael desikre. Kete tala i ma ksunw o knyai. Kolkyabei ta kabeio ity wait amury a ike bo.” Lemadendye wai nekre rtoha tuna desy. ");
INSERT INTO slu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Lema klenke soso bonyo iry a Midian maketa namare rma, desikeo Yusuf wainare ral i toha wer desike, ode rketa i ti iry Ismael desikre ti hesi blyawan bokbokke hean-ru (20). Maktei bonyo, iry maketa nam desikre ror i bai Mesir. (Ode kyoat a wainare raketa i bonyo Ruben lema imin.) ");
INSERT INTO slu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben iolik i ei wer dai desy bonyo yatos ma Yusuf lema imin desy! Lemadendye isu-iahi wasi rabitke ti tenanke kali ralake kitol. ");
INSERT INTO slu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Dendye ti yait a wainare ode byohe, “Naman neke lema imin so de! De ana kala kolkya?” ");
INSERT INTO slu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Lemadendye ral bibkye sasam ma rtabahunw a i, ode redak Yusuf wasi rabitke ti bibkye lara desy. ");
INSERT INTO slu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Maktei bonyo, rabit desike rety ba ti amatke ode rbohe, “Amo, rabit ne aramy mitot, de kete rabit ne anamkwe wasi de?” ");
INSERT INTO slu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Bonyo Yakub yatos a yal rabit desy, ode byu de byohe, “Mlay, anakkwe wasi rabitke ne! Anakyai heal mahature ra i bain de. Edo, anakw a Yusuf de heal mahature ra i de!” ");
INSERT INTO slu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakub isu-iahi wasi rabitke ti tenanke ode hyonak kadutke ma serser o nanyay i kali ralake kitol a ksyalik, ma syera anan desike seu krala nekre bo. ");
INSERT INTO slu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Anan wamfwet o wamwany desikre rma ma raluka ralake, keskyede lema you de byohe, “Kswera anakkwe nini kmwaty bo.” Lemadendye serser nanyay i nini nam, khyali anan Yusuf desy. ");
INSERT INTO slu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Klala lema rhe ohe iry a Midian desikre ti ranait Mesir bonyo rketa Yusuf ti irkye it ma ani Potifar. Iry neke ika usu khatu ti iry malaka Raja Mesirke wasi sekye. ");
INSERT INTO slu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kyoat desike Yehuda byetik toha wainare ma ti yor iry a Adulamke it ma deruke rakalui, neke lian desike ani a Hira. ");
INSERT INTO slu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ti wen desike Yehuda ralake kdi ti wamfwet Kanaanke it ma ani Syua, lemade Yehuda isaa yor wamfwet desy. ");
INSERT INTO slu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wamfwet desike mdedan i ma idur hah bonyo ananke wamwany a i dendye raki anike ti Er. ");
INSERT INTO slu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ramin desy nini wamfwet desy mdedan i huruk, desikeo idur hah bonyo ananke wamwany a i, lemade raki anike ti a Onan. ");
INSERT INTO slu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Maktei bonyo Yehuda sawa-na mdedan i ma idur hah huruk bonyo ananke wamwany a i, dendye raki anike ti Syela, ode kyoat Syela radur ti i, desikeo ama Yehuda moluk imin oa Kezib. ");
INSERT INTO slu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Maktei bonyo Yehuda yal wamfwetke it ti anan ausw a Er ma isaa yor i, neke wamfwet desy ani a Tamar. ");
INSERT INTO slu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Keskyede Yehuda anan ausw Er desike Hulasokwe yatos mo totanare atyat, dendye Hulasokwe kyeyer ma tyabahunw a i. ");
INSERT INTO slu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Lemade Yehuda byu ti anan Onan, neke Er wai amurkye, ma byu de byohe, “Mbwa ti a musaa mor waimw auskwe sawa, ma meluk waimw auskwe, ode menah mor i ma ika anan ma waimw auskwe ika ebnwo anan.” ");
INSERT INTO slu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Keskyede Onan hye ohe ana naman desikre lema yosy a sir, dendye kolnye sew kyaki nekre kyol sawa, desikeo wasi amoskwe kwenke yotuk ba ma kete ika ebnwo anan ti wai auskwe. ");
INSERT INTO slu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hulasokwe yatos mo ktela Onan iala neke atyat, lemade Hulasokwe tyabahunw a i huruk. ");
INSERT INTO slu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Lemadendye Yehuda byu ti sobai Tamar desy de byohe, “Lemamo mbwa ti mumin o amamu seike ma msom o so aduk, nini anakw a Syela lan a i, desikeo nenmo misa.” Tyanuk kolnye ma yakal eta kali ryekan o alnini anan desike myaty kola wai ausw deruke. Dendye Tamar bya ti imin oa ama-na seike. ");
INSERT INTO slu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ainare kieluk-kieluk i ma soso dendye, Yehuda sawa Syua neke myaty. Ode soso ma Yehuda ralake lema kitol o sawa-na myaty de, dendye Yehuda bya ti ryubut a lian Hira, neke yosy hnu a Adulamke, ma rbai hnu Timnake ma ti rait iry kyalamo rkotal domba-na husitare. ");
INSERT INTO slu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ode Tamar tyomolu britke ohe ana ryana Yehuda byai Timna, ma ti rkotal wasi domba-na husitare ma rketa o so. ");
INSERT INTO slu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ode Tamar hye bain ohe, Yehuda anan amury Syela neke lan i de, keskyede ryanaku lea yal wamwany amury desike ma kusaa kor i elik e? Lemadendye Tamar yobak sal ti ryana Yehuda, dendye bya ti yaly a wasi rabit som desike ode hyonak rabit salik, ode yal syalke it ma hyul eta matake, kola dene wamfwet malasurare, maktei bonyo ti tyaklulw a lorkye kmata rala mo rasukar bai hnu Enaimke, neke kimin sal mabai hnu Timnake. ");
INSERT INTO slu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kyoat Yehuda iatos Tamar bonyo, ryekan ohe wamfwet desike lyasur, ");
INSERT INTO slu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","kali Tamar kyahat matake kola dene wamfwet malasurare, dendye Yehuda bya ti yarasik a i ti salke kseri desy, ode byu de byohe, “Mmwai san, ma kenah kor a o.” Tyanuk kolnye kali lema hye ohe wamfwet desike sobai elik-elik a i. Lemade wamfwet desike yena i de byohe, “Kolnye kou ma kbwuma menah mor yaw mo, ana mal sai ma yaw de?” ");
INSERT INTO slu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Desikeo Yehuda hyalas i ma byu de byohe, “Ana kal wasikw biby a murke it ti o.” Desyo Tamar ikita ma hyalas huruk ma byohe, “Kyosy o bo, keskyede mal nam dum ma kkwumak eta ma kyeluk snyoli tun mutanuk desy nini mosa biby a mur desy ma yaw bo.” ");
INSERT INTO slu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Desmyo nam sai ne ana kunal ti o ma kdyalun tun kutanuk ne de?” Desikeo wamfwet desike hyalas i ma byohe, “Mal nyatosamkwe (capke) ktyabal ktasi matol telamw desy ode tektekan mamin simamw desy ma yaw.” Lemade Yehuda yal nam desikre ba ti wamfwet desy, maktei bonyo it de kyol it ma rahuri sir. ");
INSERT INTO slu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Maktei bonyo Tamar yolik i bai wait a sekye, ode yonuk wasi syal inal ma ieteta matake ne, maktei o hyonak wasi rabit masomke huruk, ode lema soso bonyo Tamar yor tenanke. ");
INSERT INTO slu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Lema klenke soso bonyo Yehuda yaso lian Hira ma yety a biby a murke it ti wamfwet desy, ma yal a yolik a nam kola inal ti wamfwet desy, keskyede Hira lema itot wamfwet desy elik. ");
INSERT INTO slu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Lemadendye Hira yena ti de yena ma ti a iry mamin a hnu Enaim desikre de byohe, “Lema mmyatakit wamfwet malasur kyalamo mamin ti salke kseri ne e, de imin o ka?” Keskyede iry a mamin hah desikre rhalas i de rbohe, “Lema kika wamfwet malasur ti hah ne.” ");
INSERT INTO slu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Lemade Hira yolik i ma ti yait Yehuda ma byohe, “Lema kutot wamfwet desy elik, ode iry mamin Enaim sokre dakun o rbohe lema kika wamfwet malasur ti hah so.” ");
INSERT INTO slu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Dendye Yehuda byohe, “Desikemo lema nam. De wamfwet desike yosy a nam desikre bo, ma kete irire ramahis ity kali rbohe tobak wamfwet malasur. Ode bain-bain o kosa biby desy ti i de, keskyede lema mutot wamfwet desy elik-elik.” ");
INSERT INTO slu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nenma hulke enatelw (3) desikeo Yehuda tyomolu britke o sobai Tamar a yola wamfwet malasurare, ma mdedan i de. Lemade Yehuda yal haretke de byohe, “Ti mkyumak wamfwet desy ma myal akye ti i ma myaty!” ");
INSERT INTO slu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Malmata Tamar a rala ma ror i ei mloskye, desikeo yosa britke ti ryana de byohe, “Kor tenakkwe ne kali kyosy iry a maka wasi nam kukumak nekre, de mbyihy ohe esei ne wasi nyatos a ne ktyabal ktasike ode tektekan ne de?” ");
INSERT INTO slu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda byihy nam desikre maktei bonyo byohe, “Wamfwet desike lema sal a i, keskye eras i ma byilak yaw, kali yau ne lema kubu ma kunal i ti a anakw Syela isaa yor a i ne.” Ma kyala kyosy desike Yehuda lema kyol Tamar de. ");
INSERT INTO slu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kyoat Tamar a yala ma idur hah bonyo, idur hahak naman lakduare. ");
INSERT INTO slu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Malmata yolak ma idur hah desikeo, naman lakdu desike ita yeta simake ei mloskye, dendye biangke kyumak ode yal olas mermerke ma yikat ma yatosa naman desike simake. Maktei bonyo byu de byohe, “Naman neke radur ti i a kmuna.” ");
INSERT INTO slu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Keskyede naman desike byit a simake ei kralake huruk, klala naman lakdu wamwany salik desike radur i a kmuna. Lemade biang desike byohe, “Akwa amalkyaumkwe khyury ma mbwetik kolnye e?” ");
INSERT INTO slu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Lemade raki naman desike ma ani a Peres. Maktei bonyo wai-na radur ti i, desikeo simake ral olas mermerke ma ratosa i, dendye raki naman desike ti ani a Zerah. ");
INSERT INTO slu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iry Ismael desikre ror Yusuf bai Mesir. Rba ti ranait bonyo, rketa i ti Potifar ma ika at ti i. Potifar neke Mesir a i ma kyarya ti Raja Mesirke, desyo ika usu khatu ti iry a malaka Rajake seike. ");
INSERT INTO slu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Lemade Hulasokwe lyobak a Yusuf ode syaluk a i, mane kyalamo Yusuf wasi karya a kralanare eras ne. Yusuf imin ti ebu Potifar seike, ");
INSERT INTO slu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ode ebu-na yatos i mo Hulasokwe kyalamo iloblobaka i, ode syaluk i ti karyanare. ");
INSERT INTO slu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifar neke dyakin Yusuf a ksyalik, lemade syusu Yusuf ma ika usu khatu ti iry makarya ti Potifar wasi sekye krala desy, ode syeak ti Potifar yor sawa o hatnimanare ktyabal wait lan o hnutat dakun. ");
INSERT INTO slu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dendye khyali Yusuf, kyala kyosy desike Hulasokwe yal eraske ti Potifar sir ktyabal wait lan o hnutat ma ti kyait wait boluhu-boel nekre mumu. ");
INSERT INTO slu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar wasi maloly ribun lan nekre yal ti Yusuf a syeak, ode nam ribun lan nekre Potifar lema byuma hye ti kyait desy, de iheke ohe inaknamke bo. ");
INSERT INTO slu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Yusuf neke lyalaw bainke ode lyalaw eraske, ma khyury ma Potifar sawa-na ralake ti Yusuf. Lemade byu ti Yusuf de byohe, “Mmwa ma menah mor yaw ti wenakkwe.” ");
INSERT INTO slu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Keskye Yusuf lema you de byu ti i de byohe, “Eno, kete mkweyer, de ebukw Potifar kola yal nam ribun lan nekre ma ksweak ti. Ode lema byuma hye ti kyait nam ribun lan mamin sekye krala ne mumu, ");
INSERT INTO slu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","de wasi a iseak tike kola yaw kuseak tike dakun. Lema kika nam a lema inal ma kuseak, de lenla tenamkwe kmyesan bo, kali oi ne ebuku sawa o. Kala kolkyabei ma knwoha ktela atyat desy ode kala sal ti Hulasokwe de?” ");
INSERT INTO slu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tahehe ma Potifar sawa neke hyury a Yusuf sew kyaki nekre bo, keskye Yusuf ibrai yenah o yarasik a i elik. ");
INSERT INTO slu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Sekwe it bonyo Yusuf a syukar ei sekye kralake ma nyoha karianare, ode sew desike Yusuf a lema hye ohe iry salik lema ramin ti desy, de lenla Potifar sawa bo. ");
INSERT INTO slu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Lemade Potifar sawa-na bity a Yusuf wasi rabit ihonakke, ode tyanuk ti i de byohe, “Mmwa ma ituru tenah.” Bonyo Yusuf ibrai, de iway ti de iway ma nini Yusuf ibsakut toha simake, ode ila byai mloskye, keskye Yusuf wasi rabitke kimosu toha tenanke ma Potifar sawa-na ikumkumak ti simake kralake. ");
INSERT INTO slu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ana iseak ma Yusuf ila bya ode wasi rabitke kidur bonyo, ");
INSERT INTO slu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yabuk iry makarya ti seike kralake ode byu ti sir de byohe, “Myatos! Iry a Ibrani laiku inor mai sey neke ihmwai ity! Dai syukar sekye kralake ti byai wen aramy mienah tike, ode yala ma yala atyat ma yaw, keskye kbworan ma telakkwe lan, ");
INSERT INTO slu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","itomolu ma kuboran bonyo, ila byetik ti bya, ode wasi rabitke ne kidur ne.” ");
INSERT INTO slu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Lemade Potifar sawa-na syosan rabit desy nini lai-na mya. ");
INSERT INTO slu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Lai-na ima ma inait bonyo, isalik tun ti i ma byohe, “Iry a Ibrani munor mai neke syukar ei wen taenah tike ma yala ma yala atyat ma yaw. ");
INSERT INTO slu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Keskye kuboran bonyo, ila byetik ma bya ode wasi rabitke ne kidur ne.” ");
INSERT INTO slu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kyoat Potifar itomolu sawa-na tun itanukare bonyo, kyeyer o lan a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Lemade yal haretke ma adoko rkumak Yusuf ma rluk i ei sey metmetke kralake (neke ti wen a kyalamo iry makarya ti Raja Mesirke rasal mo ral sir ti desy), ode Yusuf imin ti sel desy bo. ");
INSERT INTO slu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Keskye Hulasokwe yor i ode yal eraske ti i. Lemade uskwe khatu mahareta ti wen kyalamo raluk iry masalare ti desike dyakin a Yusuf. ");
INSERT INTO slu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Dendye syusu Yusuf ma syeak ti iry a mamin wen desy mumu, ode karya ribun mamin desike syumuk ti hyar. ");
INSERT INTO slu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Uskwe khatu ti wen raluk iry ti desike lema ryekan ti karya ribun lan inal ti Yusuf desikre, kali syeak o Hulasokwe lyobak Yusuf mane wasi karya ribun lan nekre eras mumu. ");
INSERT INTO slu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Seure kheinare mlol. Desikeo iry lan makarya ti Raja Mesirke enaru: iry deru nekre wait karyaare ita ika usu khatu ma syeak ti Rajake wasi wer ienkwe ode ita ika usu khatu ma syeak ti Rajake hina roty o kukis. Iry deru neke rasal ti Rajake. ");
INSERT INTO slu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Lemade Rajake kyeyer a sir, ");
INSERT INTO slu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","dendye yal haretke ma rluk sir ti sey metmetke kralake. Sey metmet neke ti Potifar seike, neke Yusuf wen a raluk i tike dakun. ");
INSERT INTO slu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ode iry maka uskwe khatu ti iry malaka Rajake seike (Potifar neke) yal haretke ti Yusuf ma ilaka sir. Ramin sey metmet desike hul o sew ");
INSERT INTO slu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","nini metdyetke it bonyo, iry maseak ti Rajake wasi wer ienkwe ode iry maseak ti Rajake hina roty o kukis desike deruke rmey. Meit a kbuan desikre lema mais. ");
INSERT INTO slu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Bolbolke bonyo Yusuf mya ma syeak sir, yatos sir o ralatare kitol. ");
INSERT INTO slu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Lemade yena sir de byohe, “Kyanmwane miru ralamire kitol ne de?” ");
INSERT INTO slu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Lemade deruke rhalas i de rbohe, “Detke aramiru mmyey, keskye lema aramy mhye kbuanare.” Dendye Yusuf a tyanuk ti sir de byohe, “Hulasokwe myesan a syusu iry a mahe mey kbuanare. Mlyosu meimy desikre ma yaw.” ");
INSERT INTO slu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Iry maseak ti Rajake wasi wer ienw desike lyosu meike ti i de byohe, “Kmwey o katos a aw anggurke it a ktyufw ti wen kumdiry tike. ");
INSERT INTO slu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Anggur desike ksansananke enatelw. Desikeo katos o kyala ma kika ktafran. Katos huruk o khunanare kyala ma klyean, ode asamlurw o kisinare kyala ma wahar. ");
INSERT INTO slu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Desikeo kkwumak a Rajake wasi enwenukke, ode kal a anggurke ti kralake ma kal ti Rajake ma yenw.” ");
INSERT INTO slu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Itanuk maktei bonyo Yusuf byu de byohe, “Meimw desike kbuanke kolsyan: ksasanan detelw desike kbuanke sekwe enatelw. ");
INSERT INTO slu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mane ana sekwe enatelw bonyo Rajake yal eraske ti o, ode yaso o ma mbwetik toha sey metmet ne, ode yal wasimw a kmatake ti o huruk, kola heitlulswo: ma muka usu khatu ma msweak ti wasi wer ienkwe. ");
INSERT INTO slu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kolnye eras ti o de, desikemo mnwenas yaw, ode mlwobak yaw ma mlwosu wasikw a ktela neke ti Rajake ma adoko kbwetik toha sey metmet ne. ");
INSERT INTO slu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kali yaw neke kola ral yaw toha Ibrani-nare hnuatke, ode ti Mesir neke dakun o lenla kuka salakw nini rluk yaw ti sel ne bo.” ");
INSERT INTO slu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ode iry manoha Rajake hina roty desike ihe ma iry maseak ti Rajake wasi wer ienkwe meike kbuanke eras bonyo, tyanuk ti Yusuf de byohe, “Kmwey dakun ohe ksulw a rotire airke enatelw. ");
INSERT INTO slu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Air kusulw mamin sra lahukke kbyenw ti roty o kukis neke Rajake hina, keskyede manunare rma ma ra roty o kukis desikre.” ");
INSERT INTO slu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Bonyo Yusuf byohe, “Meimkwe kbuanke ne: air detelw desikre kbuanke sekwe enatelw dakun. ");
INSERT INTO slu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ode sekwe krala detelw desikre Rajake yaso irire ma rma ma rteta telamkwe ode rtola tbunamkwe ti akwe it, ode manunare rma ma ra o renw isnyo laramw.” ");
INSERT INTO slu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sekwe enatelw huruk neke kdi ti Rajake wasi sew radur ti ike, ode ika kalkalke ti iry a maka kmatanare mumu ma ramukmuka ramarmara sir. Lemade Rajake yal haretke ma iry a manoha hina roty ode iry a maseak ti wasi wer ienw desikre rbetik toha sey metmetke, ma rma ma rait a i ti iry a maka kmata desikre mumu lulutke. ");
INSERT INTO slu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Desikeo iry a maseak ti wasi wer ienw desike Rajake yal i ma idurak wasi kmatake huruk, ");
INSERT INTO slu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","klala iry a manoha hina roty desike Rajake yal haretke ma rtabahunw a i ode rtola tbunanke ti akwe. Ktela desikre mumu kdi ti ma kola tun Yusuf itanukke. ");
INSERT INTO slu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Keskye iry a maseak ti Rajake wasi wer ienw desike lema nyenas Yusuf de imluak lahuk i bo. ");
INSERT INTO slu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ainke enaru kyelak eta bonyo Raja Mesirke myey ohe imdiry ti sah Nilke khihike. ");
INSERT INTO slu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Malmata imdidiry desy, desikeo kele rsoru saby a mamsunke itw ma rbetik rosy a sah desy ma ra tnyeinare. ");
INSERT INTO slu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Desike bonyo kele rsoru saby makilatke itw huruk, desyo iblutare khyul eta luritare bo. Saby makilat desikre ramdiry ror saby mamsun desikre. ");
INSERT INTO slu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Lemade saby makilat desikre rulak sir ma ra mwat-lelea saby mamsun desikre mumu. Desike bonyo Raja desike imsel toha meike ma byatar. ");
INSERT INTO slu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Maktei o yenah ode myey huruk. Ma ti mei desike, yatos a gandumke kisike itw kimin a ktenanke sasam, desyo eras a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ti ktei bonyo, gandumke kisike itw kbyetik huruk, desyo kmyalas ode bakbak keskes khyali eskwe ksiri kyosy a nus bakbak a krala kseri timurke (neke esw desike manas a ksyalik). ");
INSERT INTO slu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ode gandum a kisi atyat desikre ktyel huhuk a gandum a kisi eras desikre! Desike bonyo Rajake kele rsumuk mait i toha meike ma byatar. Desyo nenmo hye ohe myey. ");
INSERT INTO slu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bolbol desike Rajake lema tyeman a hye, dendye yaso ma rabuk a iry mahe telare ode iry mahe namare ti Mesir a ktem ne ma rma. Iry desikre rawahuk sir bonyo, Rajake lyosu mei desikre ti sir, keskyede lema kika iry mahe ma raklol a mei-na kbuan desikre elik. ");
INSERT INTO slu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Keskye iry maseak ti Rajake wasi wer ienw desike lyosu ti Rajake de byohe, “Senweke nenmo ana kou salakkwe. ");
INSERT INTO slu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Heitlulswoke muka keyer a iry manoha hinamw rotkye yor yaw mane maso ma rluk aramiru ti selke kralake ti Potifar seike. ");
INSERT INTO slu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Desikeo metdyetke it bonyo aramiru mmyey, ode ara meimire kbuanare lema mais. ");
INSERT INTO slu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ti sel desike aramy myor lyalaw Ibranike it, ma kyalamo syaluk Potifar, iry lan malaka seimkwe. Aramy mlyosu ara meimire ti i, ode yaklol a kbuanare o ");
INSERT INTO slu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","mlay mumu, knyosi itanukke: desyo mal yaw ma kolik yaw ma kudurak wasikw kmatake huruk, klala maso ma rtabahunw iry a maka usu khatu ti iry a manoha roty ti o desy.” ");
INSERT INTO slu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Lemadendye Rajake yaso ma ral Yusuf toha sey metmetke kralake ma adoko byetik ei mloskye. Desikeo Yusuf a yatkyory nununa khusinare maktei o iris ode yaly a i, maktei bonyo bya ti hyalas Rajake. ");
INSERT INTO slu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Lemadendye Rajake byu ti i de byohe, “Yaw kmwey, ode lema kika iry maklol a kyal meiku kbuanare. Keskye ktwomolu iry dum a rlosu ma yaw ohe kyalamo oa maklol a irire meita kbuanare dakun.” ");
INSERT INTO slu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Bonyo Yusuf a hyalas i de byohe, “Lalan o, lema yakwo, de Hulasokwe I ne isusu sal a mlakye, ode iaklol ma mlay ne.” ");
INSERT INTO slu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Yusuf itanuk maktei bonyo, Rajake byu ti i de byohe, “Yaw kmwey ohe kundidiry ti sah Nilke khihike. ");
INSERT INTO slu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ode katos ti mo saby a mamsunke itw rbetik toha sahke kralake, desyo iblutare khithitik, ode ra tnyei mamin sahke khihi desy. ");
INSERT INTO slu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Lema soso bonyo, katos huruk saby makilat makohilke itw ma rbetik toha sah desy dakun, desyo iblutare khyul luritare bo. Ode yaw neke lenla ksweak heal maoly nekre ti Mesir elik, de ana nenmo ksweak sir mane. ");
INSERT INTO slu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Saby desikre ra o rtel huhuk saby mamsun deitw desikre ma teit bakbakar. ");
INSERT INTO slu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Keskyede saby makilat makohil desikre mumu rana maktei o lema ramsun, de rakilkilat sir bo. Dai kumey kolnye bonyo, kele rsumuk mait yaw ma kbwatar. ");
INSERT INTO slu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Lemade kuenaf huruk bonyo kmwey huruk o, katos a gandumke kisike itw desyo eras ma kbyetik toha ktenanke sasam. ");
INSERT INTO slu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maktei bonyo, kisike itw kbyetik huruk, desikeo kmyalas ode bakbak keskes, kali eskwe mety ode ksiri manas. ");
INSERT INTO slu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Gandum a kisi atyat desikre ktyel huhuk gandum a kisi eras desikre mumu. Keskyede dai ktwanuk mey desikre ti iry mahe telare ode mahe namare mo, lema kika iry manait ma yaklol a hye meiku kbuan desikre elik.” ");
INSERT INTO slu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Lemadendye Yusuf tyanuk ti Rajake de byohe, “Lalan o, mey deru desikre kbuanare mais, kali Hulasokwe tyanuk a nam ana inoha ti oare. ");
INSERT INTO slu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Saby mamsunw deitw desikre ksyusu ainke itw, ode gandum kisi deitw eras desikre kbuanke ksyusu ainke itw dakun. ");
INSERT INTO slu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Klala saby makilat deitw desikre ode gandum a ksara manggusal deitw desikre kbuanke ksyusu ana laarke ainke itw huruk.” ");
INSERT INTO slu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Neke knyosi nam dai kutanuk ti oke ohe Hulasokwe tyanuk nam ana inoha ti oare. ");
INSERT INTO slu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kbuanke o ana ainke itw ti nus Mesir ne, desyo ain a krala erasare. Neke kersanke ohe nam ribun nekre mausw mumu. ");
INSERT INTO slu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Maktei bonyo ana kyeluk i huruk ma ainke kralake itw, desyo lu o lar ana lan a ksyalik, ode nam ribun nekre ktyol mumu. Ode nuske ktem ne bakbak keskes, ana lema mnyenas myal ain a krala eras maba sokre, de mimluak bo. ");
INSERT INTO slu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Meimkwe kdi a kla-ru desike klyosu bain-bain o Hulasokwe tyenuk maktei de, ode nam ana inoha ti oare samlurkwe o kdi ti.” ");
INSERT INTO slu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Lemamo mobak iry mahe tel ode mahe tunke it ma mswusu i ma tyenuk ode hyareta nus Mesir ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ti ktei bonyo mal iry dum huruk ma mswusu sir ma kyalamo rily nus a kai ti ain a krala mausw desikre. Kola dene kolnye ratot kolakye enasim desyo ral sasam toha ma ral ti nus a kai. ");
INSERT INTO slu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ode Raja o, mal haretke ma rawahuk gandum ti hnu desikre ode ralaka. ");
INSERT INTO slu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Gandum desikre rsosan mumu ma kikita laar ain deitw ana mama nekre ma kete irire rmatik laarke.” ");
INSERT INTO slu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yusuf itanuk maktei bonyo Rajake yor wasi maka kmatanare mumu rou toha Yusuf rekryeki desikre. ");
INSERT INTO slu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Lemadendye Rajake tyanuk ti sir de byohe, “Krwekan mo ana lema tatot a iry salik maola Yusuf ne de, kali Yusuf neke Hulasokwe Memeanke (Rohke) kimin a i.” ");
INSERT INTO slu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Lemade Rajake tyanuk ti i de byohe, “Hulasokwe tyanuk nekre ti o mumu. Ode oi neke mhwe telke ma kryesik iry dum dakun. ");
INSERT INTO slu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Dendye kswusu o ma muka iry lan, ma mhwareta iry a mamin a seikkwe krala ne rtabal iry a mamin a Mesirke ktem ne mumu. Ode rtomolu toha o. Klala mnwenas ohe yaw neke lan yaw ma krwesik a o, mane oa mtwomolu toha yaw.” ");
INSERT INTO slu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Ode tyanuk ti i maktei bonyo yaditi wasi soltyake toha tanake ma yonuk ti Yusuf tanake. Soltya neke rkanya Rajake wasi capke ti ma klyosu wasi lanke. Ti ktei bonyo Rajake tyanuk ti i huruk de byohe, “Soltya kuonuk ti o neke klyosu ohe kswusu o ma muka lalan (gubernur) ma mhwareta nus Mesirke ktem ne mumu.” Maktei bonyo yal rabit lan eraske ti i ode kyasu blyawanke ti telake, ");
INSERT INTO slu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ode Rajake yal blilily kyalamo isai tike ti Yusuf, ma klyosu ohe Yusuf neke lan i ma tyoha rajake, ode iry malaka raja-nare rlakut ti blililkye lulkwe ode reik toha de rbohe, “Myou ti i! Myou ti i!” Mane kolnye, Rajake syusu Yusuf ma ika gubernur ti nus Mesirke ktem ne. ");
INSERT INTO slu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Desike bonyo Rajake tyanuk ti i de byohe, “Yaw neke Raja yaw. Ode kal haretke ma kolnye lenla mlwura sir, desikemo kete irkye ita yala namit-namit ti Mesirke ktem ne elik.” ");
INSERT INTO slu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Maktei bonyo Rajake yaki Yusuf anike ma ktyoha tel Mesirke ma ani Zafnat-Paaneah, ode yal wamfwetke it ti Yusuf ma isaa yor i. Wamfwet ne ani Asnat, Potifera ananke. Potifera neke iry kyalamo masob ti Onke. ");
INSERT INTO slu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Kyoat a Raja Mesirke yabuk i, desyo Yusuf wasi ainke hean-telw de (30). Maktei bonyo Yusuf byetik toha Rajake sei desy ma bya lyola nus Mesir ne ktemke ma byihy. ");
INSERT INTO slu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ainke itw krala nus Mesir ne mausw ti kotkwe o lan a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusuf iwahuk gandum desikre ode syosan ti a hnu desikre iba-iba. ");
INSERT INTO slu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Gandum iwahuk desikre ribun a ksyalik ma Yusuf lema ryekan a yal karyarike de iwahuk bo, kali ribun lanidik kola dene: laranke ti namwatake. ");
INSERT INTO slu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kyoat laarke lenla kima bonyo, Yusuf sawa Asnat ne idur hah a kla-ru, desikeo anatke enaru ma wamwany a sir. ");
INSERT INTO slu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Anan auskwe Yusuf yaki i ti ani Manasye de byohe, “Hulasokwe yala yaw ma kumluak toha kalkal atyat ribun madan yaw nekre, ode kumluak toha amaku seike ode waikw o rahyetakw.” ");
INSERT INTO slu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ode anan matohake Yusuf yaki i ti Efraim de byohe, “Hulasokwe yal naman nekre ma yaw ti nus a atyatke kidan yaw tike.” ");
INSERT INTO slu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ainke itw krala mausw desikre kisakut bonyo, ");
INSERT INTO slu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ainke itw huruk neke laarke kimesmesan ma ktyoha Yusuf tun itanukare. Ti nuske ktem ne laarke lan a ksyalik, keskye ti Mesir neke kotkwe kimin a nggora. ");
INSERT INTO slu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ode kyoat lema kika kotw ti nus Mesir dakun bonyo, Mesir-are rma ma raten kotw toha Rajake. Lemadendye Rajake byu ti sir ma rba ti rait Yusuf ma rtoha nam Yusuf itanuk ti sirare. ");
INSERT INTO slu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ode kyoat a laarke lan a ksyalik ma ti ksyorw a nus Mesirke ktem ne mumu, nenmo Yusuf yaso ma rlakat wasi likatare dum ma kyeta gandumare ti iry a Mesir-are. ");
INSERT INTO slu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ode iry ribun lan manosy nus salik nekre rma ma rliw gandum toha Yusuf ti Mesir dakun, kali laarke lan a ksyalik ti kabei ta kabei bo. ");
INSERT INTO slu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kyoat Yakub a tyomolu ohe gandumke kimin o Mesir, desike bonyo tyanuk ti ananare de byohe, “Kyanmwane mamwaw e bony ne de? ");
INSERT INTO slu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kali ktwomolu o gandumke kimin o Mesir, mbyai so ti mlyiw a gandumke ma kete tmatik laarke.” ");
INSERT INTO slu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Dendye Yusuf wai dehean desikre rbai Mesir ti rliw gandumke, ");
INSERT INTO slu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","keskye Yakub lema lyura Benyamin, Yusuf a wai amury a lahukke, ma bya, kali imtaut ana kyal nini nam dum ti i. ");
INSERT INTO slu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Lemadendye Yakub ananare rbai Mesir ti rliw a gandum, kola dene iry ribun lan ne raba ti raliw ne, kali laarke lan ti nus Kanaanke dakun. ");
INSERT INTO slu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusuf ika gubernur ti nus Mesirke ma i ne iketa gandumare ti iry mamin nus Mesirke ktem ne. Mane Yusuf wainare rma ma ranait i bonyo rsakitil ma rou ti i. ");
INSERT INTO slu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ode Yusuf iatos sir bonyo, hye sir de, keskye yala tenanke kola dene iry salik ma kele lema hye sir bo, ode yena sir malkyakaw ma byohe, “Iry a kabekar e de?” Bonyo rhalas i ma rbohe, “Aramy myosy nus Kanaanke ma aramy mmya ma mlyiw a gandum.” ");
INSERT INTO slu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusuf neke hye sir bain, keskye wainare lema rhe i elik. ");
INSERT INTO slu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ode nyenas mait meike toha sir bonyo, byu ti sir de byohe, “Ei ne mmya ma minau wasikw a hnuke ma myatos o kika iry malaka ta lema de.” ");
INSERT INTO slu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bonyo rhalas i ma rbohe, “Ebukw o, lema! De atamw aramy ne mmya ma mlyiw a gandumke toha o ne. ");
INSERT INTO slu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Aramy ne away sasam aramy, ode iry a eras aramy. Ode bain-bain o lema iry a manau nam aramy.” ");
INSERT INTO slu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Bonyo Yusuf byu ti sir de byohe, “Mikakmet! Mmya ma mbyihy a ara hnuamkye kamalkyauke.” ");
INSERT INTO slu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bonyo rhalas i de rbohe, “Aramy neke irkye hean a kresi enaru (12) aramy, ara amamy sasamke iso nus Kanaanke. Irkye sasam toha aramy neke lema imin de, ode amury lahukke idesi yor ara amamkye.” ");
INSERT INTO slu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusuf byu huruk de byohe, “Lema. Tun kutanuk desike mlay o iry manau nam e! ");
INSERT INTO slu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kal ma klwau e kolnye: kal a Rajake ma kswob ohe lema mbyetik toha hnu ne, kolnye waimy amury lahukke lema myai ne. ");
INSERT INTO slu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Lemamo myaso irkye it toha e ma bya ti yal i, ode idanare rkumak eta e ma tbihy a tun mitanukare mlay ta sal. Kolnye tunamire lema mlay, desikemo ei ne iry manau nam e!” ");
INSERT INTO slu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Lemadendye Yusuf yaso ma rkumak sir raktemtem ma rluk sir ti sey metmetke kralake sekwe enatelw. ");
INSERT INTO slu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sekwe enatelw bonyo Yusuf tyanuk ti sir de byohe, “Yaw neke iry mamtaut Hulasokwe, mane ana myorif ode lenla ktwabahunw a e, de ma klyosu ohe ei neke iry a mlay e mo myala kolnye: ");
INSERT INTO slu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","mlyura irkye it ma idur ti sey metmetke, klala kteranare mbya ma myety a gandumke ma myety ba ti ksyoy eta laaramire ti wasimy sekye kralake. ");
INSERT INTO slu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Maktei bonyo myor waimy amury lahuk desike ma yait yaw ma klyosu ohe tun mitanuk desike mlay mo, ana lema ktwabahunw a e.” Desike bonyo rou toha gubernurke tun itanuk desy. ");
INSERT INTO slu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","(Desike bonyo ral wait telke ma ratunak) ode it de byu ti it de byohe, “Kalkal neke kdyan ity tenatare ma kisalsyalik i, kali heitlulswoke tala atyat ti ity wait amurkye, ode kyoat a tatos i ma iten morifke toha ity bonyo, lema tlabir o thaduli i, lemadendye ana thar atyatke huruk mane.” ");
INSERT INTO slu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Bonyo Ruben tyanuk ti sir de byohe, “Msyeak, heitlulswo kbwu eta e ma kete myala atyat ti i, keskyede lema mtyomolu yaw. De selsel neke atyat desike kyoil a i ma ity mane nde!” ");
INSERT INTO slu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ode lema rhe ohe Yusuf hye nam ratanukare, kali kyalamo Yusuf yal irkye it ma yaklol a tunat a krelanare ti i. ");
INSERT INTO slu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mane itomolu nam ratanukke bonyo Yusuf yaditi i toha sir ode syuka i ti syer. Maktei bonyo yolik i huruk ma tyanuk ti sir, ode yal haretke ma wasi irire rkumak Simeon toha wainare ma rbutwa i, ma wainare raktemtem a ratos. ");
INSERT INTO slu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusuf yaso wasi makaryaare ma ral kadut wainare ranety desikre ma rluk gandumare ti, ode ral wainare wait kubanare huruk ma rluk ti kadut a krala desikre dakun. Ode Yusuf yaso ma raka res ti wainare wait babake. ");
INSERT INTO slu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Maktei bonyo, byuma ral kadut desikre ti wainare ma rlean wait keledainare maktei o rba. ");
INSERT INTO slu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Rba-rba nini metdyet a kyal sir ti sal a klen, lemade ramres ma renaf desy. Desike bonyo waitke it lyakat wasi kadutke it ma yal kotw ti keledainare ma ra, desikeo itot wasi kubanare ti kadutke krala desy. ");
INSERT INTO slu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Lemade kele rsumuk mait i ma byohe, “Edo, sai ne de? Wasikw kubanare rala rolik ma yaw e?” Dendye byu ti wainare de byohe, “Myatos! Kuban nekre kimin a wasikw kadutke kralake!” Desike bonyo raktemtem a ralatare kakan ode ramtaut ma it de yena it, “Nam atyat sai ne Hulasokwe yala ma ity ne de?” ");
INSERT INTO slu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kyoat a ranait nus Kanaanke bonyo, rahes nam ribun lan nekre ti amatke de rbohe, ");
INSERT INTO slu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Gubernur Mesir desike itun malkyakau ksyalik i a kyor aramy. Ode tyuky aramy ohe minau wasi hnuke. ");
INSERT INTO slu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Keskye aramy byohe, ‘Lema iry manau nam aramy, de iry eras o mlay aramy. ");
INSERT INTO slu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ma irkye hean a kresi enaru (12) aramy, ode ara amamkye sasam, klala irkye it toha aramy neke myaty de, ode ara waimy amury lahukke idesi yor ara amamkye o nus Kanaanke.’ ");
INSERT INTO slu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Desikeo gubernur desike tyanuk de byohe, ‘Kal ma klwau e ohe iry a eras e ta lema de. Lemamo irkye sasam toha e ne idur, klala kteranare myety gandum nekre bai seimire, kali sir desi ramlar. ");
INSERT INTO slu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ode ana kolnye myor waimy amury lahukke mai ne, desikeo nenmo khwe ohe iry eras e, desyo nenmo klwura waimy a kukumak eta i ti ne ma yolik i ti yait e, ode yaw dakun o klwura miktemtem a miketa nam ode myala sai ta sai ti nus ne bo.’” (Tun rahes nekre ktei ma desy de.) ");
INSERT INTO slu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ode kyoat ralaly a wait kadutare mumu bonyo, ratot wait kubanare ti kadut desikre kralanare. Ratos bonyo ror amatke de ramtaut. ");
INSERT INTO slu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Lemadendye amatke tyanuk ti sir de byohe, “Ei ne mhyury ma anakure dum lema ramin de! Yusuf yor Simeon lema ramin de, ode ana mbyuma myal Benyamin toha yaw huruk e? De yaw khwar atyat ribun lan ne mane.” ");
INSERT INTO slu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Desike bonyo Ruben tyanuk ti ama de byohe, “Amo, ana mtwabahunw anakw wamwany deru desy, kolnye lema kor Benyamin ma yolik i. Lemamo mlwura i ma kor i bai Mesir, ode ana aramy miolik aramy bonyo, kor i ma o.” ");
INSERT INTO slu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Keskye ama-na hyalas i de byohe, “Lema klwura anakkwe ma yor o ma mbya, kali wai auskwe myaty de ode myesan bo. Ana kyalnini nam dum a ktyabahunw a i ti sal a klen, desikemo mhyury ma ralakkwe kitol nini kmwati khyali i bo.” ");
INSERT INTO slu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Laarke o nus Kanaanke lan a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Gandum ranety toha Mesir desikre ktei de. Dendye lema soso bonyo Yakub byu ti ananare de byohe, “Mbyai Mesir huruk ti mlyiw a gandum ma ity.” ");
INSERT INTO slu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","4","Desike bonyo Yehuda hyalas i de byohe, “Amo, sew desike gubernurke yal haretke ma kete aramy mbya ti myait a i, kolnye lema aramy myor ara waimy amurkye. Desikemo mlwura Benyamin ma yor aramy mbya ti mlyiw a gandumke o so. ");
INSERT INTO slu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Keskye kolnye lema mlwura Benyamin ma tyoha aramy, desyo aramy mibrai mbya kali gubernur desike sew desike tyanuk ma aramy ma kete aramy mbya ti msyeak i kolnye lema aramy myor ara waimy amurkye.” ");
INSERT INTO slu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Keskye Yakub tyanuk de byohe, “Kyanmwane mihury atyatke ma yaw ne ode milosu a waimy amurkye ti iry desike ne de?” ");
INSERT INTO slu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Desike bonyo rhalas amatke de rbohe, “Amo, iry desike ienena aramy toha ity wait sekye kralake ma byohe, ‘Amamkye myorif a nggora e? Ode waimkye it desy i dakun e?’ Dendye aramy mhyalas nam iena desikre bo. De kolkyabei mane aramy mhye o ana yaso ma aramy myor ara waimkye ti i de?” ");
INSERT INTO slu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Lemadendye Yehuda byu ti ama huruk de byohe, “Amo, mlwura naman desy ma yor yaw ma aramy mbya ti myal kotw ma kyaorif ity mumu ma kete tmaty. ");
INSERT INTO slu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ode yaw neke khwatetak ma kor o ksweak mamak a i. De kolnye kmwa o lema kor i, desikemo ana khwar salke nini kmwaty bo. ");
INSERT INTO slu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Keskyede dai lema tatun ma narnarw ode takita ma soso mo, kolnye aramy mbya ode mmya kdi a kla-ru ta nam mane.” ");
INSERT INTO slu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Lemade amatke byohe, “Edo, ralakkwe kitol! Keskye ana kala kolkya? De koldyesy mo, myal nam eras-eras toha nus ne ti wasimy kadutare ma ti o mkyumak gubernur desike simake. Desikemo myety a balsem o madu o rampa o kmury o knarkye anana. ");
INSERT INTO slu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ode mbya mo myety a kuban ma kryesy kdi a kla-ru, ma msyuka kuban kola mitot toha wasimy kadut a krala desikre. Kali anakyai kyoat desy rluk sal ti wasimw kadutare. (Ode kuban a ktera desikre myal ma mlyiw a gandum harharw ma ity.) ");
INSERT INTO slu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Lemamo adoko myor waimkye ma mbya mirin ti myait gubernur desy. ");
INSERT INTO slu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kuten toha Hulasokwe ma yala iry desike ralake ma lyobak a e ode lyura Benyamin yor waimy idake ma mmya. Kolnye bain o ana anakure ratayar toha yaw mo mbwuma kala kolkya? Lemamo koldyesy bo.” ");
INSERT INTO slu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Lemadendye Yusuf wai desikre ror Benyamin ma rbai Mesir ti adoko rait Yusuf. Desyo rety a nyaluka kita i, ktyabal kuban ma kryesik kdi a kla-ru desy ma rliw a kotw. ");
INSERT INTO slu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ranait so bonyo Yusuf myatakit a Benyamin yor wainare dendye, byu ti wasi iry makarya ti i desike de byohe, “Mor iry desikre bai wasikw sekye. Ana kor sir de aramy miknam sew dutw ne. Lemamo mtwabahunw a healke it ma mnwoha i.” ");
INSERT INTO slu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Lemadendye Yusuf wasi iry a makarya desike tyoha tun itanukare ma yor Yusuf wainare bai Yusuf wasi sekye. ");
INSERT INTO slu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kyoat rabai Yusuf a seike, desikeo ramtaut a ksyalik, ode rrekan ma rbohe, “Rbuma tmai ne kali khyali kuban kola tatot toha it wait kadut a kralanare ne. Mane ne rkumak eta ity ma ral ity ti at ode ral ity wait keledainare dakun.” ");
INSERT INTO slu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ranait sekye salahke kmatake bonyo rtanuk ti gubernurke wasi iry maseak ti sey desike ma rbohe, ");
INSERT INTO slu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Amo, kete mkweyer kali kola aramy mmyai ne ma mlyiw a gandumke, ");
INSERT INTO slu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","ode kyoat aramy myolik aramy mbyai ara hnuamy, desike bonyo aramy mimres ti sal a klen kali metdyet a kyal aramy, ode aramy mlyakat kadut desikre bonyo aramy mitot huruk kuban aramy minal ma miliku gandum desikre. Ode lema aramy mhye o esei ne iluk kuban nekre ne de. Lemadendye aramy myety de myolik huruk mane. Ode aramy myety kuban dakun ma ana aramy mlyiw a gandumke huruk.” ");
INSERT INTO slu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Desike bonyo iry desike byu ti sir de byohe, “Kete mimtaut ode ralamire kakan, kali Hulasow a amamkye isob tike i ne inal kuban desikre ti wasimy kadut a kralanare ne. Khwe kali sew desike yaw ne kal kuban gandum a khesi desikre toha e.” Itanuk maktei bonyo ti yal Simeon ti wainare. ");
INSERT INTO slu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Lemadendye iry desike yor raktemtem rsukar bai sekye kralake. Ode yal wer ti rut lwautare ode yal kotw ti wait keledai desikre ma ra. ");
INSERT INTO slu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Maktei bonyo raditi wait a nyalukanare toha kadutare ma ana ral ti gubernurke, kali rlosu ti sir ohe ana gubernurke yosy kantorke ma myai sekye sekwe idutw ne ma yor sir ma raktemtem a raknam. ");
INSERT INTO slu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ode kyoat Yusuf ima ma inait sekye bonyo, wainare ral nyaluka desikre ti i ode rsakitil ma rou ti i. ");
INSERT INTO slu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Lemade Yusuf yena sir de byohe, “Eras-eras e, e?” Maktei o yena huruk de byohe, “Kyalake mtyanuk ma yaw ohe amamkye imtu lahuk de. De i desi a nggora e? Ode eras-eras i, e?” ");
INSERT INTO slu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Rhalas i de rbohe, “Ebukw o, ara amamkye idesi eras-eras ia nggora.” Lemade rsakitil ma rou ti i huruk. ");
INSERT INTO slu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ode Yusuf iatos Benyamin, wai amury elik enat sasamke bonyo, tyanuk ma byohe, “Waimy amury lahuk mitanuk-mitanuk neke i ne e?” Dendye byu ti i de byohe, “Anakw o, lemamo Hulasokwe yor mamak a o, ode yal eraske ti o.” ");
INSERT INTO slu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf ralake kisalsal ma lema tyeman a hye kali nenmo yatos wai amurkye, lemade syukar ei wasi kamarke kralake ode syer ma kisalsal. ");
INSERT INTO slu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Maktei bonyo ilarif uno mata ma byetik ei mloskye, ode yakor ralake maktei o yaso wasi irire ma rtenuk kotw. ");
INSERT INTO slu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kyoat desike, Yusuf tyaklulw ma iknam ti meja salik, ode wainare rmesan ti mejake it, klala iry Mesir desikre rsalik sir ti mejake it dakun, kali iry Mesir-are lema rdakin ma raknam a ror Ibrani-nare kali ramyeku sir. ");
INSERT INTO slu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusuf wainare wait mejake ksyorw mamak Yusuf wasi mejake ode iry makarya ti sey desike tyenuk sir mamwamwaw ma rtaklulw kyala kyosy auskwe ma ti kyait amury lahukke. Ode kyoat a it de yatos it ma ratoha sir ti rataklulw ne bonyo, ramsela sir mait. ");
INSERT INTO slu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Iry manoha kotw desikre ral kotw toha Yusuf wasi mejake ma ral ti Yusuf wainare, klala Benyamin yosy watke kdi a kla-sim toha wai ausure. Ma raktemtem a ra o renw, ode ramukmuka sir a ror Yusuf. ");
INSERT INTO slu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Raknam maktei bonyo, Yusuf yal haretke ti iry maseak ti Yusuf seike de byohe, “Mal gandumare ma mlwuk ei wait kadut a krala desikre ma kyoat karyari ranetire bo. Maktei bonyo mswosan a wait kubanare ti kadut desikre it o ita krala. ");
INSERT INTO slu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Maktei o nenmo mlwuk a wasikw enwenuk a raala toha blyawan bokbok desy ti wait amury lahukke wasi kadutke kralake, ktyabal wasi kubanare dakun.” Lemadendye iry desike tyoha Yusuf tun itanukare. ");
INSERT INTO slu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ode nyamo ne bonyo, Yusuf tyunik sir ma rbai nusat ror wait keledainare. ");
INSERT INTO slu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Raba ma lenla soso sir toha hnu desike bonyo, Yusuf yaso iry maseak ti seike ma ila tyoha sir ma byu ti i de byohe, “Mlwahamety ma mtwoha iry desikre. Ode ti munait sir bonyo, mtwanuk ti sir de mbwohe, ‘Kyanmwane minal atyatke ma mioil eraske ne de, ");
INSERT INTO slu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","neke minamety ebukkwe wasi enwenukke. Enwenuk desike ebukkwe yal ma yenuk wer ode yal kindika nam a iob. Ei ne miala tot atyatare ne!’ ” ");
INSERT INTO slu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Dendye iry a iaso desike kyoat iba ti inait sir bonyo, tyanuk ti sir tun Yusuf itanukare mumu. ");
INSERT INTO slu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bonyo rhalas i de rbohe, “Ara ebumy o, kyanmwane mutanuk kolnye de? Bain-bain ohe lema aramy myala koldyesy! ");
INSERT INTO slu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ebo, mmwesan a mhwe ma kuban kola aramy mitot toha kadut a kralanare desikeo aramy myety de myolik. Ode kyanmwane aramy minamety blyawan kunkuny o bokbokke toha gubernurke seike ne de? ");
INSERT INTO slu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ebo, ana kolnye, nam desike tatot toha aramy ne it a wasi kadutke kralake mo, andeka mtyabahunw a i ode kteranare aramy mika at ti o.” ");
INSERT INTO slu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iry nyaso desy tyanuk de byohe, “Desikemo eras. Ana kolnye, tatot enwenuk desy toha esei ne inal ne, desikemo ana ika at ma yaw, ode kteranare lema kika namit-namit ti e.” ");
INSERT INTO slu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Lemadendye rnauk lanatare asamlurw ei hahke ode it o ita lyakat wasi kadut. ");
INSERT INTO slu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Maktei o iry nyaso desike lyakut ma ilili kadut desikre yala yosy a auskwe wasike ti yait amury lahukke wasike, bonyo itot enwenuk desy ti amury lahuk Benyamin wasi kadutke kralake. ");
INSERT INTO slu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lemade wainare rser ma kiseseman sir ode rasu-raahi wait rabitare ti tenatare. Desike ode rsalak lanatare ti wait keledainare ma rolik sir bai hnu lan desy huruk. ");
INSERT INTO slu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yehuda yor wainare rba ti ranait bonyo, rsukar ei Yusuf wasi sekye kralake, desyo Yusuf idesi nggora. Bonyo, rou ti i ma rabobob lasmyerke ti a luluke. ");
INSERT INTO slu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Dendye Yusuf tyanuk ti sir de byohe, “Sai ne miala ma yaw ne de? Lema mhye ohe dene iry maola yaw neke kuobak a khwe namit-namit e?” ");
INSERT INTO slu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Desike bonyo Yehuda tyanuk ti Yusuf de byohe, “Ebukw o, tun sai aramy mtyanuk ti o de? Ode aramy myala kolkyabei ma aramy mhyalas o ma myobak ara lolamy ti o de? Hulasokwe syusu ara salamkye. Lemade aramy mika at ti o mane; de aramy miktemtem mhyar salke mumu, ode kete iry rakeni ohe manal nam desike myesan.” ");
INSERT INTO slu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Keskye Yusuf tyanuk ti sir de byohe, “Lema! Lema kbwuma myala koly desy. Kubuke ohe esei ne ratot enwenukkkwe toha i ne mo ika at ma yaw, ode kteranare lemamo myolik e ti myait amamkye bo.” ");
INSERT INTO slu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Lemade Yehuda bya ti yarasik gubernurke (Yusuf) ode iten alanke ti i de byohe, “Ebukw o, mlwura yaw ma ktwanuk tebikan ti o aduk. Oi ne mmwesan meluk iry lan kola Raja Mesirke, lemamo kete muka keyer a yaw. ");
INSERT INTO slu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ebukw o, kyalake mena aramy ohe: ‘Amamkye idesi nggora, ode waimy amurkye it idesi dakun e?’ ");
INSERT INTO slu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Desyo aramy mhyalas o ma mbyohe, ‘Ara amamkye imtu de, ode ara waimy amurkye radur ti i kyoat ara amamkye kinohnoh ti imtu ne. Wai auskwe myaty de, ode lenla kamuri lahuk enat sasamke i ne. Lemadendye ara amamkye lyobak ia ksyalik.’ ");
INSERT INTO slu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Desike bonyo maso aramy de mbwohe, ‘Mbya ode myolik e mo myor waimy amurkye ma katos a i.’ ");
INSERT INTO slu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Desyo aramy mbyohe, ‘Naman desike lema soso i toha ama kali ana kolnye, soso i toha ama desikeo ama-na byuma myaty bo.’ ");
INSERT INTO slu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Keskyede mbwu eta aramy ma ete aramy mmya ma myait o, kolnye lema aramy myor ara waimy amury desy. ");
INSERT INTO slu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Desike bonyo aramy mbya ti myait ara amamkye, ode aramy mlyosu tunamure ti i. ");
INSERT INTO slu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lema klenke soso bonyo ara amamkye yaso ma aramy mmya ma mlyiw kotw. ");
INSERT INTO slu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Keskye aramy byohe, ‘Gubernur o Mesir soke byu eta aramy ma lema aramy mbyai so huruk ti myait i, kolnye lema aramy myor ara waimy amurkye. Lemamo kete aramy mbya.’ ");
INSERT INTO slu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Desikeo ara amamkye byohe, ‘Dene mhye ohe sawakw Rahel neke ananke enaru bo. ");
INSERT INTO slu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Auskwe bya toha yaw ode krwekan ma anakyai heal o ail rtabahunw a i de, kali kimama kitudak senweke, lema katos a i. ");
INSERT INTO slu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ode kolnye ana myal anakw amurkye toha yaw ode namit-namit ti tenanke bonyo, mhyury ma ralakw matolke kyalnini ktyabahunw a yaw bo.’ ” ");
INSERT INTO slu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Lemadendye Yehuda tyanuk ti gubernurke (Yusuf) huruk ma byohe, “Kolnye aramy myolik aramy ti myait ara amamkye ode lema aramy myor a ara waimy amurkye, desikeo khyury ma ara amamkye kyalnini myaty. ");
INSERT INTO slu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ara amamkye mormyorhyanke kimin a naman ne dakun. Kyalnini aramy mhyury rala matolke ma ktyabahunw a i kali imtu lahuk de. ");
INSERT INTO slu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ode it ne dakun kali kola ktwanuk ma kal yaw ma kuliku, kolnye lema kor waikw amury desy, ana khwar atyatke nini nam bo. ");
INSERT INTO slu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Lemamo kuten toha o ma mlwura yaw ma kumin ne ma kuka at ti o, ma kyeluk ara waimy amury desy. Ode ia yor wainare raktemtem a rolik sir ma rba. ");
INSERT INTO slu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ana kala kolkyabei ti kait amakw de, kolnye lema kor naman amury ne? Lema! Lema kbwuma katos atyat ne kdi ti kdyan amakw elik-elik.” ");
INSERT INTO slu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Lemadendye Yusuf lema tyeman a hye ti iry makarya ti iare dendye, byu ti sir de byohe, “Mbyetik ei mloskye mumu!” Lemade iry makarya ti i desikre rbetik ma lenla Yusuf yor wainare. ");
INSERT INTO slu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lemade Yusuf syer ma yeik de yeik nini iry Mesir mamin a mlosy desikre rtomolu i; dendye ktela neke rlosu bai Raja Mesirke wasi sekye kralake dakun. ");
INSERT INTO slu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Klala Yusuf lyosu ti wainare de byohe, “Yau ne waimy a Yusuf yaw! De bain-bain o ity amatke idesi myorif a nggora e?” Keskye wainare lema rhalas a i kali ramtaut a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Lemade Yusuf yabuk sir ma byohe, “Mmyai san.” Ode rarasik i bonyo byu huruk de byohe, “Yau ne waimy a Yusuf yaw, mane kyoat desy mkyeta yaw bai Mesir! ");
INSERT INTO slu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kete mimtaut ode kete mmyay mlyobak tenamire ti miketa yaw ne. Kali Hulasokwe yor yaw mai ne kmuna e ma kaorif ribun lan ne. ");
INSERT INTO slu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nenmo laarke ainke enaru bo, ode ana kiba ti ainke enasim huruk bonyo, ana irire lema kika nam ma rtan ode lema kika bo a kisi ma ra o renw dakun. ");
INSERT INTO slu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Lemade Hulasokwe yor yau kmuna e mai ne ma kaorif e, ode kulaka mamak a e ti lasmyerke khaha ne ma tesnwo natumy a ratot eraske ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Mane ei ne lema mihury ma kumai nus ne ne, keskye Hulasokwe I ne tyenuk kolnye. Ode I ne syusu yaw ma kola amam ti Raja Mesirke ma khwareta o ksweak ti Raja Mesirke wasi nam ribun lan ne mumu. ");
INSERT INTO slu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Lemamo adoko myolik e ti myait ity amatke ma mlyosu ti i de mbyohe, ‘Anamw Yusuf tyanuk kolnye: “Hulasokwe syumuk yaw ma kuka amosw lan ti nus Mesirke ktem ne mumu. Lemamo adoko mmwa mirin ma mait yaw, ode kete munggonw. ");
INSERT INTO slu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Amo, ana mumin ti nus Gosyenke ma lema soso o toha yaw. Ode mumin desy mor a ebnwo anamw mtyabal biby o domba o heal o ail minalare. ");
INSERT INTO slu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ana ksweak mamak a o ti desy, kali laar neke lenla ainke enasim huruk. Dete kolnye lema, desikeo ana amaku mor a ebnwo anamw mtyabal iry a makarya ti oare miktemtem lema kika namit-namit ti e elik-elik.”’” ");
INSERT INTO slu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Maktei o Yusuf tyanuk ti wainare huruk de byohe, “Nenmo myatos yaw bain mane, ode waikw Benyamin dakun o hye o yau ne kutun a kor e ne. ");
INSERT INTO slu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mbya ti mlyosu ti ity amatke ohe yau ne kuka iry lan ma khwareta nus Mesir ne, ode mihes nam miatosare ode mihenare mumu. Lemamo ado myor i ma mirin.” ");
INSERT INTO slu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusuf itun maktei bonyo yak ba ti yor wai amury Benyamin de it de kyora it ode rasera sir. ");
INSERT INTO slu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Maktei bonyo, bya ti yoy a wainare mumu ode syera sir. Maktei o ramres ma rahestun. ");
INSERT INTO slu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kyoat iry mamin Rajake seike ratomolu ma Yusuf wainare rama bonyo, Rajake yor wasi melare ramukmuka sir. ");
INSERT INTO slu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Dendye Rajake byu ti Yusuf de byohe, “Yusuf, maso waimure ma rlean gandumke ti wait keledainare, ma rolik sir bai Kanaan ");
INSERT INTO slu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ti ral amamkye yor wait sekye kralake ma rma mumu ma rait yaw. Ana kal nusakkwe anana ti sir ma rnoha bo ti. Lasmyer desike eras ode ana ral koture ribun toha. ");
INSERT INTO slu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mbwu ti sir ma rety a blililire toha ne ma rbai Kanaan ti ral sawat o anat kakan ma rsai ti, ode ror amatke dakun ma rma. ");
INSERT INTO slu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kete rrekan ma rety nam ribun-ribun toha so ei ne, kali nam eras-eras mamin ti Mesir neke ana rosy dakun.” ");
INSERT INTO slu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Lemadendye Yakub ananare rtoha Rajake nam itanukare. Yusuf yal blililire karyari Rajake itanukare ti wainare ode ika resat dakun. ");
INSERT INTO slu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ode yal rabit harharure ratsam ti kyakar wainare raktemtem, klala wai Benyamin yosy a rabit harharkwe enasim ktyabal kubanke atkwe enatelw (300). ");
INSERT INTO slu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ode yosa ti ama keledai wamwankye hean (10) ma klyean nam eras ribun-ribun toha Mesir, ktyabal keledai wamfwetke hean (10) ma klyean gandum o roty ode kotw o abw dakun ma ana ror amatke ra ti sal a klen kolnye rosy a Kanaan ma rmai Mesir. ");
INSERT INTO slu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Maktei bonyo yor wainare ma ti tyunik sir ma rba ode byohe, “Kete mililir ti sal a klen!” ");
INSERT INTO slu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Lemadendye rbetik toha Mesir ma rbai Kanaan ti rait amatke. ");
INSERT INTO slu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ode rlosu ti amatke de rbohe, “Amo, Yusuf a myorif a nggora. Ode idesi ika gubernur ma hyareta ti nus Mesirke ktemke mumu.” Keskye amat Yakub tyomolu brit desike bonyo, mamwaw i ode lema tyohak tun desike. ");
INSERT INTO slu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Keskye ralosu tun Yusuf itanuk ti sirare mumu ti amatke, ode amatke iatos blilily Yusuf iosa ma ana ama-na isai tike ma byai Mesir bonyo, nenmo amatke ralake kimukmukai. ");
INSERT INTO slu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Lemade Yakub byu de byohe, “Eras de! Khwe ohe anakw Yusuf myorif a nggora. Kubuke ne ma lemamo adoko kbwa ti kait Yusuf elyelik lenla kumaty ne.” ");
INSERT INTO slu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakub isosan lan o hnutat mumu ma rbai Mesir. Rba nini ranait hnu Bersyebake bonyo yotno yabar heal ma syalak eraske ba ti Hulasow a kyalamo ama Ishak isob ti Ike. ");
INSERT INTO slu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Metdyet desike myey ma yatos ohe Hulasokwe tyanuk ti i de byohe, “Yakub! Yakub!” Bonyo Yakub hyalas I de byohe, “Ebukw o, yaw san.” ");
INSERT INTO slu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Desike bonyo Hulasokwe tyanuk ti i de byohe, “Yaw ne Hulasow a amamu isob ma Yaw ne. Lemade kete mumtaut ma mbwai Mesir, kali ana kala o ma tesnwo natumw nekre ribun sir o Mesir, ");
INSERT INTO slu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ode kor mamak o o so. Ana kala ma myolik e ei nus ne. Ode Yusuf a yor o nini mmwaty bo.” ");
INSERT INTO slu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Desike bonyo Yakub byetik toha Bersyeba. Yakub ananare rsalak a i yor ebu o sobainare ti blilily a Raja Mesirke iosa ma ranal sirare. ");
INSERT INTO slu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Rba desyo ror wait biby o domba o lan o hnutat mumu ma rbai Mesir, ");
INSERT INTO slu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","neke Yakub yor ebnwo anan wamfwet wamwany mumu. ");
INSERT INTO slu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakub ebu o anan mabai Mesir-are sir ne: Ruben naman auskwe. Ruben ananare sir ne: ");
INSERT INTO slu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Henokh, Palu, Hezron, ode Karmi. ");
INSERT INTO slu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ananare sir ne: Yemuel, Yamin, Ohad, Yakhin ode Zohar ror Saul neke ena-na yosy a nus Kanaanke. ");
INSERT INTO slu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi ananare sir ne: Gerson, Kehat, ode Merari. ");
INSERT INTO slu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yehuda ananare sir ne: Syela, Peres, ode Zerah. Klala Yehuda anan idanare sir ne: Er ode Onan, keskye rmaty o Kanaan. Peres ananare sir ne: Hezron yor Hamul. ");
INSERT INTO slu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakhar ananare sir ne: Tola, Pua, Ayub, ode Simron. ");
INSERT INTO slu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulon ananare sir ne: Sered, Elon ode Yahleel. ");
INSERT INTO slu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ebnwo anan nekre mumu rosy a Yakub yor Lea. Ode Lea idur hah ti anan desikre oa Mesopotamia ktyabal anan wamfwetke ani Dina. Dendye Yakub yor sawa Lea neke tesnwo natut nekre aryaritke irkye hean-telw kresi enatelw sir (33). ");
INSERT INTO slu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Klala Gad ananare sir ne: Zifyon, Hagi, Syuni, Ezbon, Eri, Arodi ode Areli. ");
INSERT INTO slu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ayer ananare sir ne: Yimna, Yiswa, Yiswi, ode Beria, rtabal Serah neke rahyetat i. Beria neke ananare sir ne: Heber yor Malkiel. ");
INSERT INTO slu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Iry de hean a kresi nem (16) desikre Yakub yor sawa hah Zilpa tesnwo natut sir. Zilpa neke at Laban inal i ti anan Leake. ");
INSERT INTO slu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ode Yakub a sawa Rahel neke ananke enaru sir, neke Yusuf yor Benyamin. ");
INSERT INTO slu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oa Mesir, Yusuf neke ananke enaru sir ne: Manasye yor Efraim. Anan deru neke yor sawa Asnat anatare. Asnat neke Potifera anan wamfwetke. Potifera neke iry kyalamo masob ti a Onke. ");
INSERT INTO slu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin ananare sir ne: Bela, Bekher, Asybel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim, ode Ared. ");
INSERT INTO slu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Irya de hean a kresi enaat desikre (14) Yakub yor sawa Rahel tesnwo natut sir. ");
INSERT INTO slu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Klala Dan neke ananke sasam ani Husim. ");
INSERT INTO slu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali ananare sir ne: Yahzeel, Guni, Yezer, ode Syilem. ");
INSERT INTO slu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Irkye itwa sir (7) neke Yakub yor sawa hah Bilha tesnwo natut sir. Bilha neke at Laban inal i ti anan Rahelke. ");
INSERT INTO slu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakub tesnwo natut nekre aryaritke hean-nem a kresi nem (66), desyo lema raki sobainare ma rtabal sir. ");
INSERT INTO slu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Mane kyoat a Yakub wasi sekye kralake ranait Mesir bonyo, Yakub yor wasi klolan wamwanire rtabal Yusuf yor anan deruke, desyo aryaritke irkye hean-itw a sir (70). ");
INSERT INTO slu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Lea ranait bonyo, Yakub yaso Yehuda ma myuna sir ma bya ti yabuk Yusuf ma mya ma syeak ama o Gosyen. Kyoat a rama ma ranait Gosyen bonyo, ");
INSERT INTO slu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf syai wasi blililkye ma bya ti yait ama ti desy. Yusuf inait ama bonyo, kyora i ode syer nini nam. ");
INSERT INTO slu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Dendye Yakub byu ti Yusuf de byohe, “Kolnye selsel neke kmwaty mo lema nam, kali ksweak o oi ne mmworif a nggora.” ");
INSERT INTO slu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Desike bonyo Yusuf tyanuk ti wainare ror amatke rtabal hatnimatare de byohe, “Kolnye, ana kbwa ti klwosu ti Rajake ohe waikure ror amaku rtabal hatnimatare rosy a Kanaan ma rma de. ");
INSERT INTO slu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ode ana klwosu dakun ohe ei neke iry a malaka domba e, mane myety wasimy a saby o domba o wasimy nam ribun lan ne dakun. ");
INSERT INTO slu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kolnye ana Rajake yabuk e ma yena o karyaamy sakar de. ");
INSERT INTO slu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Desikemo ana mlyosu ti i de mbyohe, ‘Ara karyaamkye iry a malaka domba o biby a myala myosy kakan aramkye de, kola ara ebnwo matrumamy.’ Ana milosu koly desike bonyo, Rajake lyura e ma mimin ti Gosyen, kali iry Mesir-are kyalamo ramyeku iry malaka dombanare.” ");
INSERT INTO slu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Kyoat desike, Yusuf yal irkye enasim toha wainare ma rma ma rait Raja Mesirke. Ti ranait bonyo Yusuf byu ti Rajake de byohe, “Wasikw Lalan o, amaku yor waikure rosy a nus Kanaanke ma rma de, desyo ror wait a biby o saby o domba rtabal wait wer o nam ribun nekre. Mane sir so Gosyen.” Ilosu wai desikre ti Rajake ma ihe sir ");
INSERT INTO slu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","bonyo, Rajake yena sir de byohe, “Kariamy sai de?” Lemade rhalas i ma rbohe, “Iry Lan o, aramy neke milaka dombanare kola ara ebnwo matrumamy dakun. ");
INSERT INTO slu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Aramy mmyai ne ma mimin nus ne kali laarke lan o nus Kanaanke. Ma lema kika tnyei ma ara wasimy dombanare kyalamo ra. Lemamo mlwura aramy mmya ma myon ti Gosyen so.” ");
INSERT INTO slu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Desike bonyo Rajake tyanuk ti Yusuf de byohe, “Dai amamu yor waimure rma ma sir ne. ");
INSERT INTO slu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Lemade kal Mesir neke myal kindika wasimy bo. Lemamo mtwenuk amamu yor waimure ma ramin ti Gosyen, kali Gosyen ne lasmyer eras-eras lan mamin nus Mesir ne. Ode kolnye hatnimamw desikre kika iry a makarya khyeare dum desikemo mswusu sir ma rseak ti wasikw biby o domba.” ");
INSERT INTO slu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Rajake itanuk maktei bonyo, Yusuf yor Ama Yakub ba ti Rajake hye i dakun. Dendye Yakub byu de byohe, “O Hulasow O, kuten ma mal eraske ti Raja ne!” ");
INSERT INTO slu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Desike bonyo Rajake yena i de byohe, “Wasimw ainke enai dendye?” ");
INSERT INTO slu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Bonyo Yakub hyalas i ma byohe, “Iry Lan o, kumorif ne wasikw ainke atw ksala hean-telw de (130), keskyede lema kika wen ma kmworif o ktwenas ti. Ode kumorif ne dakun o kosy atyat nekre mumu ma kbyenw ti ral matolke kimesmesan bo, ode anyakkwe kdusa kolnye kal ma ktwain toha ebnwo matrumakw. Ebnwo matrumakw ne dakun o lema kika wen ma rmorif o rtenas ti.” ");
INSERT INTO slu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Itun maktei bonyo, Yakub tyuly a Rajake ma bya ode iten eraske ti i ma byetik. ");
INSERT INTO slu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Lemade Yusuf syaluk ama yor wainare ma rmon ti Mesir, ode yal lasmyer eraske ti wainare rosy, desyo knyei hnu Rameseske ma ktyoha Rajake itanukke. ");
INSERT INTO slu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ode Yusuf isosan mamak kotw o abw ti ama-na yor wainare hatnimatare, kyala kyosy lanare ma ti ktyudak kakanare, knyosi aryaritare. ");
INSERT INTO slu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ti nuske ktem desike lema kika kotw o abw elik-elik, de laarke lan a ksyalik. Ma iry Mesir nekre ror Kanaan-are rakilat rakohil ma lublub lalyai sir. ");
INSERT INTO slu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Sew khyaki nekre rba ti rliw a gandum toha Yusuf, desyo Yusuf syosan wait kuban ranal ma raliw a gandum desikre ti Rajake wasi sekye. ");
INSERT INTO slu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ode kyoat Mesir-are ror Kanaan-are wait kubanare ktei bonyo, rba ti rseak Yusuf, ode raten toha i ma rbohe, “Gubernur o, mal gandumke ma aramy mnyoha ma mi. Kete mtwutuk aramy ma myatik laarke, kali ara wasimy kubanare ktei de!” ");
INSERT INTO slu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Desike bonyo Yusuf hyalas sir ma byohe, “Kolnye wasimw kubanare ktei de, desikemo myal wasimy biby o domba ma kyeluk kuban, desikeo nenmo kal gandumke ti e.” ");
INSERT INTO slu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Lemadendye iry desikre ral wait biby o domba ti Yusuf, ode Yusuf yal gandumke ti sir ma kyeluk wait heal kola dene: kuda o, domba o, biby o, saby o, keledai nekre mumu. Mane ti ainke krala desikre Yusuf yal gandumke ma kyeluk heal ranal ti iare. ");
INSERT INTO slu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ode ain malikuike huruk bonyo, rma ma rait Yusuf ode rtanuk hela ti i ma rbohe, “Ebo, lema kika kuban o sten o kwar ma aramy! Ode ara wasimy biby o domba mosy a sir mumu de. Ode lema kika namit-namit ma aramy de, de lenla ara tenamy watan ne ode ara wasimy boare bo. ");
INSERT INTO slu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kyanmwane muatos aramy ma mimaty bony ne de? Lemamo mlwiw aramy mtyabal ara wasimy boare ma kyeluk kotw, ode aramy myeluk at ti wasimw Rajake. De mal gandumke ma aramy mi ma kete aramy mmyati khyali laarke, ode ktyabal hinkye anana ma aramy mtyan ti bo desikre ma kete knani.” ");
INSERT INTO slu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Lemadendye Yusuf lyiw a Mesir-are wait boluhu-boel desikre mumu, kali laarke lan ti sir a ksyalik. Lemade Mesir-are wait boluhu-boel desikre Rajake yosy mumu. ");
INSERT INTO slu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ode iry mamin Mesir desikre raktemtem mumu Yusuf yal sir ma raka at ti Rajake. ");
INSERT INTO slu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Klala Yusuf lema lyiw boare toha iry masobare. Iry masob desikre lema rketa wait boluhu-boel ti Yusuf, kali Rajake kyalamo syeak o yal kotw o abw ti sir ma kyaorif sir. ");
INSERT INTO slu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Dendye Yusuf tyanuk ti hnuke kutu desy de byohe, “Mtyomolu! Senweke klwiw a miktemtem mtyabal wasimy boluhu-boel ti Rajake de. Ode kal hinkye anana ma ana mtyan ti boluhu-boel desikre. ");
INSERT INTO slu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ode ana kyait ma minal kisinare bonyo, mikay a nuske ti Rajake neke kolnye: mitot kolakye enasim, desikemo yosy a sasam toha desim desy. Klala ktera deat desike myosy ma myal ti hiny, ode mi dakun.” ");
INSERT INTO slu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bonyo rhalas ma rbohe, “Ebo, maorif aramy de! Ode aramy miten eraske ti o, ode aramy mbyuma mika at ti Rajake.” ");
INSERT INTO slu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Lemade Yusuf yal haretke ma ktela rakaya nus Mesir ne kola dene: Mesir-are hinat koture kyal kolakye hean, desikemo kolakye enaru Rajake yosy. Haret desike klyakut nini kyait sew ne, klala iry masobare wait boluhu-boel Rajake lema yosy. ");
INSERT INTO slu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Lemadendye Israel-are ramin Mesir ma rmon ti desy, neke ti Gosyen. Ramin desike mausw ti sir ode tesnwo natut o ebnwo anat ribun-ribun ti desy. ");
INSERT INTO slu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kyoat desike Yakub myorif ma imin Mesir ainke hean a kresi itw (17), ma ti kyait wasi ainke atw ksala hean-at a kresi itw (147), ");
INSERT INTO slu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","desyo knyoh ma ana Yakub yala ma imaty bonyo, yabuk anan Yusuf ode byu ti i de byohe, “Kolnye mlwobak yaw, desikemo mtwoha ity wait ktelake, neke mtweka simamkwe ti lakbiakkwe ksuke ma muhwab, ma kolnye ana kmwaty, desikemo kete mkwali yaw ti Mesir ne. ");
INSERT INTO slu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","De mety tbunakkwe bai ebnwo matrumakw wait bobke ma mtwutuk tbunakkwe ti desy, ma kor sir de asa sasam aramy.” Bonyo Yusuf hyalas i ma byohe, “Amo, ana ktwoha tun mutanukare.” ");
INSERT INTO slu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Keskye Yakub byohe, “Muhwab bain-bain o ana mtwoha tun kutanukke.” Lemade Yusuf ihwab, dendye Yakub syalak eraske ba ti Hulasokwe ti sehleke kralake. ");
INSERT INTO slu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kyoat desike lema klenke soso bonyo irire rabrita ti Yusuf de rbohe, “Amamu isike ksunw.” Lemade Yusuf yor anan deruke ma rba ti rseak Yakub. Anan deru nekre Manasye yor Efraim. ");
INSERT INTO slu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ti ranait bonyo Yakub tyomolu ohe Yusuf mya de, desike bonyo yalkyaw i ma byatar ma tyaklulw ti sehleke. ");
INSERT INTO slu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ode Ama Yakub byu ti Yusuf de byohe, “Sew maba mamuna sokre, Hulasokwe syusu tenanke ma yaw ti Lus, neke o nus Kanaanke, ode yal eraske ma yaw, ");
INSERT INTO slu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ode lyosu ma yaw de byohe, ‘Ana kal eraske ti o ma tesnwo natumw ode ebnwo anamw rresy a nus ne, ode kal nus ne ti ebnwo anamw ma radurak ti nini nam.’ ” ");
INSERT INTO slu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ode Yakub tyanuk huruk ma byohe, “Kyoat a lenla kmwai Mesir ne, desyo anamw deru Manasye yor Efraim neke radur sir ti Mesir ne de. Lemade ana kala sir kola anakw elik, kola dene Ruben yor Simeon dakun. ");
INSERT INTO slu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kolnye muka anamw huruk, ana lema kal sir kindi anakw, de anamw sir bo. Ode ana rosy a watke toha Manasye yor Efraim wait lasmyer a radurakare.” ");
INSERT INTO slu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yakub tyanuk huruk de byohe, “Kyoat kolik yaw toha Mesopotamia (Padan), desyo kmwa ma ti sal a klen bonyo, enamw Rahel ne myaty ti Kanaan, neke lema soso toha hnu Efratke, ode ralakw ne kitol a ksyalik. Lemade kkwali i o so ti salke kseri ma bai hnu Efrat so.” (Hnu Efrat neke ne kani Betlehem ne.) ");
INSERT INTO slu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Lemade kyoat Yakub iatos Yusuf anan deru desike bonyo yena de byohe, “Naman kabei kar ne de?” ");
INSERT INTO slu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Bonyo Yusuf hyalas ma byu de byohe, “Amo, anakure sir ne nde. Hulasokwe yal sir ma yaw ti Mesir ne.” Dendye Yakub byohe, “Mor sir ma yaw ma kuten eraske ti sir.” ");
INSERT INTO slu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","(Kyoat desike Yakub a amosw i lahuk deny ma matanare bobo ode lema myatakit ei lulw o lyaw.) Lemadendye Yusuf yor anan deru desy ma Yakub kyora deruke ode yoy a sir. ");
INSERT INTO slu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ode tyanuk ti Yusuf de byohe, “Lema khwe elik-elik o dene ana kait o, keskye senweke Hulasokwe lyura yaw ma kait oa mor anamure dakun.” ");
INSERT INTO slu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Maktei bonyo Yusuf yal naman deru desikre toha ama-na rihake ode ia syakitil ti ama-na luluke. ");
INSERT INTO slu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Lemade yal Efraim amury ne ti ama Yakub seri wisalke, ode Manasye auskwe ti Yakub seri wanke. ");
INSERT INTO slu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","The ohe Manasye ausw i, keskye Yakub ikoik sima deruke ma yal sima wanke ti Efraim usuke, klala wisalke kyei Manasye usuke. ");
INSERT INTO slu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Maktei bonyo syambayan ma iten eraske ti Yusuf kolnye, O Hulasow O! Oi neke ebukw Abraham yor amakw Ishak rsob ti O, ode raleru ode rbitil animkwe. Oi ne mulaka yaw ode mutenuk mormyorhyakkwe nini kait sew ne. ");
INSERT INTO slu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ode klatsam a klatsam o Hulasow O mala tenamkwe kola malaikat ne ma mmwa ma maditi yaw toha atyat nekre mumu. Lemamo o Hulasow O mal eraske ti naman deru ne dakun, ma anikkwe kmyorif; ode ebukw Abraham yor amakw Ishak de anitare kmyorif dakun khyali naman deru ne. Ode naman deru ne rmorif ma tesnwo natut nekre rbes ti nuske ktem ne. ");
INSERT INTO slu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Keskyede Yusuf iatos ma ama-na ikoik simanare koldyesy bonyo lema dyakin. Lemadendye kyumak ama-na simake ma yala ma yaditi toha Efraim ma yal ei Manasye usuke, ");
INSERT INTO slu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ode byohe, “Amo, kete mala koldyesy. Manasye neke naman ausw i; lemade mal simamw a wanke ti i.” ");
INSERT INTO slu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Keskye Ama Yakub ibrai yaditi simake ode byohe, “Anakw o, khwe dakun. Manasye neke ana iry lan a i ode byes ma tesnwo natu ribun sir, keskye wai amurkye ana ika iry lan ma ryesik a i, ode tesnwo natu nekre iry lan sir ma raka nusatare ma lan-lan.” ");
INSERT INTO slu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Lemadendye sew desike syambayan ma iten eraske ti sir de byohe, “Ana Israel-are rabuk animkye ma raten eraske ti irire ma rbu kolnye, ‘Lemamo Hulasokwe yal eraske ti o kola dene inal ti Efraim yor Manasye!’ ” Lemade Yakub syusu Efraim ma ika ausw ti Manasye. ");
INSERT INTO slu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Desike bonyo Yakub (Israel) tyanuk ti Yusuf ma byohe, “Khwe ohe lema soso bonyo kmwaty de, keskye Hulasokwe lyobak a e ode yor e ma myolik e bai ity ebnwo matrumat a hnuat. ");
INSERT INTO slu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Lemade kal hnu Sikhemke ti e, neke hnu heitlulswo kumdiriat ma kusoruk toha iry a Amori-nare, klala lema kal nus desy ti waimire.” ");
INSERT INTO slu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Lemadendye Yakub yabuk ananare ode byu ti sir de byohe, “Miwahuk e ti ne ma myarasik yaw ma kala ma ktwanuk ti e nam ana mitot ti sew mama nekre. ");
INSERT INTO slu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Anakw e, miwahuk e ode mtyomolu amamy Israel yaw. ");
INSERT INTO slu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben anakw ausw o. Oi ne anakw ausw lermatmata o. Oi ne amalkyaukkwe kidurak o; Amalkyaukw mamunake kimin o. Ode oi neke malkyakau o ti anakkwe ne mumu ma rtomolu o rsumuk animkwe. ");
INSERT INTO slu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Keskyede oi neke mola tasike ma eskwe kyohw mo kiway ti de kiway ma ode lema mtwenas, ma khyury ma oi neke lema mbwa lulu irire de, kali menah mor sawakw hahke, ma mala wasikw sehleke ma kiray. ");
INSERT INTO slu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon mor Lewi ausw amury e. Wasimy husw o rama kyeluk amalkyaumy. ");
INSERT INTO slu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Lemade lema ktwoha tun miohutke, ode lema kuahuk yaw kor e, kali ti keyeramy kralanare neke mtyabahunw o myaha iry, ode mkyeyer mo mhyet wait biby o domba-na tikat a kurtan lanare ma kyaluka ralamire. ");
INSERT INTO slu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Lemamo Hulasokwe tyuhar keyeramy desikre lakhidik ba, kali mkyeyer mo atyat a ksyalik! Lemade lema kal lasmyerke ti e ktyabal tesnwo natumy ma midurak, de ana kuhe a kusakar e ma mimin ti waimire wait lasmyer kunal ti sirare o nus Kanaan so. ");
INSERT INTO slu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda o, waimure ana rdakin o ma rbitil animkwe ma ne sra ne, ode iry a mamnisik oare mal sir ma raka at ti o, ode tesnwo natumw nekre mumu ana rsakitil ma rou ti o. ");
INSERT INTO slu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda neke mola singa murke ma idoha ma syok heal maktei bonyo yolik i ei wenake huruk, ma byob ma yenah, ode lema irkye it a ires ma yoha i elik. ");
INSERT INTO slu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yehuda o, ebnwo anamw ana raka Raja ma rkumak haretke nini irkye it a mya, desyo iry neke Raja lan lahuk i, ma ana nuske ktem neke mumu rma ma rsakitil o rou ti i. ");
INSERT INTO slu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ode ana wasimw a boluhu-boel nekre kisinare mausw-mausw ma kyety kunwo-katway ti o ma ana wasimw keledaike ananke mdwalun i ti tasy maiskye kusu eraske bo, ode ana mal tasy maiskye kwen mermer desy ma kyeluk werke ma mhwas wasimw rabitke ti. ");
INSERT INTO slu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ode matamure mermer kali menw tasy maiskye kwenke ma kindika wer bokbokke bo, ode nisimure bokbok kali menw suskwe sew kyaki nekre bo. ");
INSERT INTO slu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon o, oi neke mumin ti namwatake ode kabalare kbyaly ti wasimw namwata desy, ode nusamkwe kika aktah a kyor hnu Sidonke. ");
INSERT INTO slu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakhar o, oi neke mola dene keledai malkyakaw ne ma yulik a i ti yenah a wasi aryarkye ksakake. ");
INSERT INTO slu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Desikeo kyoat a muatos wen mumin ti desike eras a ksyalik, lemade mlwura tenamkwe ma muka at ti iry salik ti wen desy bo. ");
INSERT INTO slu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan o, oi neke ana mswon eras o atyat ode mohut irire wait tun sal o mlay, kali oi neke Israel-are wait iry a o dakun. ");
INSERT INTO slu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ode oi ne mola manunkwe ti salke kserike. Manunw neke tyutu kudake tikake ma iry masai tike kele rbisak i ba. ");
INSERT INTO slu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","(O Hulasow O, mormyorif munal ma aramy neke malmata kukitkita bo.) ");
INSERT INTO slu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad o, oi neke ana iry manametare robak ma radoha o ma rtabahunw o, keskye mulak o ma malmahalala sir huruk. ");
INSERT INTO slu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer o, oi neke kotw o abw mausw ti o a ksyalik, ode ana mtwutuk kita raja-nare. ");
INSERT INTO slu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali o, oi neke mola dene rusa wamfwet madohut wasi daldalun ne, ode anamure matatare eras a ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf o, oi neke mola keledai mata mnaske ma nyei werke, ode ila ti kususwanare. ");
INSERT INTO slu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Iry mamnisik oare rawahuk sir ma rrama o, ");
INSERT INTO slu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","keskyede Yusuf malkyakau o ma wasimw husw o rama ktye ma nenen, ode lenamkwe malkyakaw, kali Hulasow a Yakub neke syusu a malkyauke ti o, ode Hulasokwe ilaka o kola iry a malaka dombanare, ode Hulasokwe I ne yola Hatw matery eta Israel-are ne. ");
INSERT INTO slu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Hulasow a kusob ti neke iloblobak o, ode Hulasow a manal eraske ti o ne, I ne malkyakau I ma ryesik nam ribun lan ne mumu. Yal eraske ti o toha laitke sra ne, ode toha lasmyerke hah lahuk ne dakun ti o. Yal a ktyabal eraske ti sobaimure ma tesnwo natumw ribun sir. ");
INSERT INTO slu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Eras manosy amamw neke kbyilak manosy a kususwan o huar heitlulswokre. Lemamo eras-eras nekre mumu kidurak Yusuf, kali i neke eraske kimin i ma byilak wainare mumu. ");
INSERT INTO slu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin o, oi neke mola asw a utan mamlar ne, ma bolbol nekre ode sekwe bya bonyo ti syok heal o ail, ma yasu yahi sir ma inat sir.” ");
INSERT INTO slu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Mane Yakub yal eraske ti anan de hean a kresi enaru (12) desikre mumu ode anan desikre rosy a watatare it o it ma khyalak totatare. ");
INSERT INTO slu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Maktei bonyo Yakub tyanuk ti ananare ma byohe, “Kolnye ana kmwaty. Desikemo myety tbunakkwe ba ti knyei ebnwo matrumakw ti ");
INSERT INTO slu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","bob mamin a bo soke, oa Makhpela, kseri timur Mamre ti nus Kanaanke. Bob desike Abraham lyiw ktyabal bo desy toha Efron, iry a Hetke, ma Abraham myaty mo rtutuk tbunanke ti wen desy. ");
INSERT INTO slu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Wen desike rtutuk Abraham yor sawa Sara tbunatare, ktyabal anat Ishak yor sawa Ribka tbunatare, ode wen desike dakun o ktwutuk sawakw Lea tbunanke ti. ");
INSERT INTO slu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mane bo desike ktyabal bob mamin tike Ebukw Abraham heitlulswo lyiw toha iry a Het-are.” ");
INSERT INTO slu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakub itanuk ti ananare maktei bonyo, yulik i ti yerak i ti sehleke ma myaty elik. ");
INSERT INTO slu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Dendye Yusuf syai ei sehle desy ma kyora ama ma yoy uno mata ode syera i ma kisalsal ti desy. ");
INSERT INTO slu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Maktei bonyo Yusuf yaso iry a kyalamo matasa iare ma ratasa ama-na tbunanke ma kete khyon. Lemade iry matasa desikre rtoha ma ratasa Yakub a tbunanke, ");
INSERT INTO slu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","desikeo kyal sekwe hean-at (40) elik ma ktyoha kyalamo ranoha iry a mamatire ma kete rhon, ode iry a Mesir-are rsera Yakub sekwe hean-itw krala (70) elik. ");
INSERT INTO slu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sew a rasera Yusuf amatke maktei bonyo, Yusuf tyanuk ti Raja Mesirke wasi melare, ma byu de byohe, “Mel e, kolnye mlyobak yaw mo mlyosu tun ti Rajake ohe, ");
INSERT INTO slu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kyoat amaku iala ma imaty bonyo, byuma kuhwab ma kolnye myaty desikemo ana kal i ti wasi bob mamin oa nus Kanaan so. Lemamo mlwura yaw ma kbwa ti kamlin amaku tbunanke o so aduk, maktei o ana kolik yaw huruk.” ");
INSERT INTO slu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Dendye Rajake byu ti Yusuf de byohe, “Desikemo adoko mbwa ti mamlin amamu tbunanke ma mtwoha nam muhwab ti ike.” ");
INSERT INTO slu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Lemade Yusuf bya ti yamlin ama-na tbunanke ma kola itanuk ti ike. Ode Rajake wasi melare raktemtem ror iry lan makarya ti Rajake rtabal iry a lan mamin a Mesir-are raktemtem a ror Yusuf ma rba. ");
INSERT INTO slu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ode Yusuf wainare ror sawatare rtabal Yakub a hatnimanare rba dakun, klala namanare ror wait biby o domba radur ti nus Gosyenke bo. ");
INSERT INTO slu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Iry a manety blilily o masai kuda o nam nekre ribun a rba ror Yusuf ma wait lolke narnarw ksyalik. ");
INSERT INTO slu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kyoat a ranait Goren-Haatad, neke sah Yordanke seridake bonyo, iry desikre serser nanyay a sir ti desy, ode Yusuf yala kalkal matmyatkye sekwe itw elik khyali ama. ");
INSERT INTO slu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ode kyoat iry mamin nus Kanaan desikre ratos ma, iry Mesir-are rser ma ti kisalsal a ksyalik ti Goren-Haatad bonyo rbohe, “Edo, Mesir nekre wait sersera mamaty neke kyety ral masal a ksyalik.” Lemadendye wen desike raki ti Abel-Mizraim, neke wen mamin a sah Yordanke kserike. (Abel-Mizraim neke kbuanke o Mesir-are rserser nanyay a sir.) ");
INSERT INTO slu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Lemadendye Yakub ananare rtoha nam itanuk ti sirare ");
INSERT INTO slu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ma ror i bai nus Kanaanke ti ramlin tbunanke ti bob mamin a bo a Makhpela so, neke bo a Abraham iliw toha Efron, iry a Hetke. Bo neke knyei hnu Mamreke. ");
INSERT INTO slu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ode Yusuf iamlin ama-na tbunanke maktei bonyo, yulak ia yor wainare ror sawatare, ode hatnimatare rtabal iry ribun dai ranor desikre mumu ei Mesir huruk. ");
INSERT INTO slu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kyoat Yusuf amatke imaty bonyo, Yusuf wainare it de byu ti it de byohe, “Edo, kyal nini Yusuf kete yatil ity nggora de, kali yal ma nyenas heitlulswo tala atyat ti ike!” ");
INSERT INTO slu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Lemadendye rano tun ne kita Yusuf ma rbohe, “Kyoat ity amatke lenla imaty bonyo yaso aramy ma ana aramy mtyanuk ti o kolnye: ");
INSERT INTO slu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ete moil a o ti waimure khyali salatare, ode ete mnwenas a heitlulswo rala atyat ti oke. Lemamo mala eras sir, ode mumluak lakhidik salatare kali Hulasow a amamu isob ti desike wasi at a sir dakun.” Lemadendye Yusuf itomolu nyano desike bonyo syer. ");
INSERT INTO slu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Desike bonyo Yusuf wai desikre rma ma rou ode rsakitil ti a luluke ma rbohe, “Aramy mmya ma mika at ti o mane.” ");
INSERT INTO slu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Keskyede Yusuf a tyanuk ti sir ma byohe, “Kete mimtaut. De yaw ne, Hulasow a yaw e? Ma kyosy yaw ma ana kala sai ta sai ti e, e? ");
INSERT INTO slu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Heitlulswoke miktemtem a myal tun sasamke ma mbyuma myala atyat yaw, keskyede Hulasokwe yeluk atyat heit miala ma yaw desikre kyor eraske, kbuanke o syusu yaw ma ksweak mamak e, ktyabal ribun lan mamin a Mesir ode Kanaan ne mumu ma kaorif sir ma kete rmaty. ");
INSERT INTO slu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Lemade kete ralamire kakan, kali ana ksweak mormyorhyamire ktyabal anamire dakun.” Lemade tun itanuk desikre kyaluka ode tyenauk wainare ralatare. ");
INSERT INTO slu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf neke imin ti Mesir ma yor hatnima desikre ma yal nini wasi ainke atw ksala hean (110). ");
INSERT INTO slu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ode imin desy nini syoru yait ebnwo anan, ma ti kyait anan Efraim ebnwo anan ror Makhir ananare, neke Manasye ebunare dakun. ");
INSERT INTO slu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Lemade byu ti wainare de byohe, “Ana kyarasik ma kmwaty mane. Keskye Hulasokwe ana hyarak mamak e ode yor mamak e ma mbyetik ma mlyoin toha nus ne, ma mbyai nus kola heitlulswo Hulasokwe ihatetak ti Abraham, Ishak ode Yakubke.” ");
INSERT INTO slu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Lemadendye Yusuf a yaso wainare ma rsob ode byu ti sir de byohe, “Kolnye Hulasokwe yor miktemtem ei nus desy, desikemo myety a tbunakkwe dakun.” ");
INSERT INTO slu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ode ramin desy ma lema soso bonyo Yusuf myaty ti Mesir, desyo wasi ainke atw ksala hean de. Ma kyoat imaty bonyo iry a Mesir matasa iry tbunat desikre ratasa Yusuf tbunanke, maktei o rluk i ti loarke ti Mesir.");
INSERT INTO slu_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Heitlulswo lu o lar lan a ksyalik ti Israelke ktem desy mumu. Neke kdi ti, ti kyoat a iry Israel-are lenla raka wait raja, de cuma mo manety lulw ti sir nekre wait iry maohut tunare bo. Kyoat desike wamwankye it ma ani a Elimelekh, ma i neke iry a Efrat a i, ma imin ti hnu Betlehemke ti lasmyer a Yehudake. Ode Elimelekh ne sawa Naomi, ma anatke enaru, neke wamwany a sir, ma it a ani Mahlon ode it a ani Kilyon. Ode khyali lu o lar lan desy, lemade Elimelekh yor sawa Naomi, ode anat wamwany deru desy, riar bai lasmyer salik, neke lasmyer Moabke ma ramin ti. ");
INSERT INTO slu_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ode kyoat ramin ti Moab bonyo, Elimelekh a myaty, ode lenla Naomi yor anan wamwany deru desy bo. ");
INSERT INTO slu_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Seure kiliku i bonyo naman deru desy rasa, neke rasaa ror wamfwet a Moab-are, ma it a ani Orpa, ode it a ani Rut. Neke Kilyon isaa yor Orpa, ode Mahlon isaa yor Rut, ma raktemtem a ramin ti desy nini anakyai ainke hean bonyo, ");
INSERT INTO slu_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mahlon yor Kilyon a rmaty dakun. Ode lenla Naomi yor sobai deru desy bo. ");
INSERT INTO slu_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ode sekwe it bonyo, Naomi tyomolu o Hulasow YANWE yal eraske ti wasi iry a Israel-are de, neke yal mauskwe ti wait boluhu-boel. Lemade Naomi yohut ma ana byetik toha lasmyer Moabke, ma yulak i bai wasi lasmyerke huruk, neke lasmyer Yehudake. Lemadendye Naomi yor sobai deru desy rasosan lanatare, ma rala ma rbetik toha lasmyer Moab desy. ");
INSERT INTO slu_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Dendye Naomi yor sobai deru desy, rbetik ma rbai lasmyer Yehudake. Ode kyoat a rlakut ma rbai lasmyer Yehudake ma ti sal a krala bonyo, ");
INSERT INTO slu_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi tyanuk ti sobai deru desy de byohe, “Anakw e, lemamo miru myulak e bai wasimy a hnuke, ma ti myait enamy o amamy ti so. Ma lemamo Hulasow YANWE syusu wasi loblobakke ti miru, ma kola ne milobak anakure ti kyoat lenla ramaty ne, ode kola ne milobak yaw dakun ne. ");
INSERT INTO slu_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ode lemamo Hulasow YANWE yal eraske ti e, ma bisa ma misa huruk, ma it o it ne mimin ti laimire wait seire ma rseak ti e.” Kyoat Naomi itanuk koldyesy maktei bonyo, kyora sobai deru desy ode yoy a sir, dendye Orpa yor Rut de rser ma telatare lan. ");
INSERT INTO slu_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ode rtanuk ti ryanatke ma rbohe, “Eno! Aramy mibrai ma myulak aramy, de aramy mbyuma mtyoha o bo, ma tbai wasimw a hnuke.” ");
INSERT INTO slu_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Keskyede Naomi hyalas sir ma byohe, “Anakw e! Lemamo miru myulak e lakhidik! Kyanmwane mibuma mitoha yaw ne de? Ana lema bisa ma kudur hahak naman wamwanire huruk ma ana misaa myor sir. ");
INSERT INTO slu_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Anakw e, lemamo myulak e bo, kali enmosw yaw lahuk de, ode ana lema kusa de. Ma kolnye sewah ne kusa ma kutot naman wamwankye enaru, ");
INSERT INTO slu_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","desikemo ana myou ma mikita sir nini lyalaw sir aduk e? Kete mryekan koldyesy! De musti mo misaa myor iry salik. Lemadendye anakw e, masunw madan yaw ne mdedan ma kbyilak masunw a mikoman ne. Kali masunw madan yaw neke, Hulasow YANWE yukun yaw mane.” ");
INSERT INTO slu_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kyoat Rut yor Orpa de ratomolu bonyo, deruke rser ma telatare lan huruk, dendye Orpa yoy a ryana, maktei o tyuly a i ma yulak i bai wait a hnuke. Klala Rut lema you elik ma tyutuk ryana Naomi ma myesan, de kyora malkyakaw ryana ma byuma yor i bo. ");
INSERT INTO slu_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Lemade Naomi tyanuk ti Rut de byohe, “Rut, matos! Mruamw Orpa yulak i de, ma bya ti yait wasi bangsake, ode wasi adar isakitil ode iou ti sirare. Lemade anakw o, lemamo mtwoha i ma mbwa lakhidik!” ");
INSERT INTO slu_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Keskyede Rut hyalas ma byohe, “Eno, kete maso yaw ma kulak yaw, ode ktwutuk o ma mmwesan bo! Kali enakw a o ne, ana mbwai kabei, desikeo kutoha oke bo. Ma kolnye mumin ti kabei desy, desikeo kumin ti desy dakun. Ode wasimw bangsake, desikeo wasikw bangsake dakun. Ode wasimw Hulasow a musambayan ti Ike, desikeo wasikw Hulasow a I, ma kswambayan ti I dakun. ");
INSERT INTO slu_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ma kolnye enakw a o ne, mmwaty ma ramlin o ti desy, desikeo kou ma kmwaty ma ramlin yaw ti desy dakun. De lemamo Hulasow YANWE yukun yaw mo mdedan a ksyalik, kolnye kusali yaw kor a o, eno. Kali kuheke cuma mo matmyatkye bisa ma kisali ituru bo!” ");
INSERT INTO slu_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kyoat desike Naomi lema bisa ma tyanuk namit-namit de, kali hye ohe Rut neke yohut ma tyoha i bo. ");
INSERT INTO slu_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Lemadendye deruke rsaur wait laklakutke nini rait Betlehem. Ode kyoat a ranait Betlehem bonyo, hnu desike ksyorbubw, ma wamfwetare ti hnu desike rena ma rbohe, “Naomi i ne bain e?” ");
INSERT INTO slu_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Keskyede Naomi hyalas sir ma byohe, “Kete myabuk yaw ti Naomi de, de myabuk yaw ti Mara, kali Hulasow Mahareta Lan Lahukke tyutuk yaw ma kmworif ti masunw ribun lan ne, ma wasikw mormyorif neke mew o mlara. ");
INSERT INTO slu_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Kali kyoat kosy ne ma kbwa, desikeo nam ribun ne mausw ma yaw. Klala selsel neke Hulasow YANWE yor yaw mai ne, desikeo kumranran bo. Lemadendye kete myabuk yaw ti Naomi de, kali Hulasow Mahareta Lan Lahukke yukun yaw, ode I ne iala masunkwe ma kidan yaw ne.” ");
INSERT INTO slu_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Dendye tkunw a Naomi iulak i toha lasmyer Moabke, ti inor sobai Rut iry a Moab desy, ma deruke ramai hnu Betlehemke ne, neke wasi tkunkwe desy. Ode kyoat ranait a Betlehem bonyo, oras a rakety jelaike kdi ti. ");
INSERT INTO slu_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ti hnu Betlehem neke, irkye it ma ani Boas. Ma Boas neke Naomi lai Elimelekh ne wai i. Boas neke wasi malolkye lan. Ode irire ralan a i dakun. ");
INSERT INTO slu_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ode sekwe it bonyo, Rut iry a Moab desike tyanuk ti ryana Naomi de byohe, “Eno, kolnye mou mo, senwe mlwura ma kbwai boare aduk, ma ti kily a jelai irire rakety ma mabrok nekre, kolnye jelai desikre kebuke ralake eras ma yaw, ma bisa ma kily a hina jelai mabrokare.” Dendye Naomi you ma lyura Rut, ma tyanuk ti i de byohe, “Anakw o, ode mbwa.” ");
INSERT INTO slu_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Dendye Rut byai boke it, ma inait bo desy bonyo, tyoha iry makety jelai desikre etatare, ma yili-yily a jelai mabrokare. Ode eras ti i, kali bo iily jelaike toha desy, neke Elimelekh a wai-na wasi boke desy. ");
INSERT INTO slu_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ode sekwe idutw bonyo, Boas yosy a hnu Betlehemke ma myai wasi boke. Lemade inait bonyo, tyanuk ti wasi makaryaare ma byohe, “Kuten ma lemamo Hulasow YANWE yal eraske ti miktemtem.” Dendye rhalas i ma rbohe, “O amo, aramy miten ma lemamo Hulasow YANWE yal eraske ti o dakun.” ");
INSERT INTO slu_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Maktei o Boas yatos wamfwet salikke it ma yily jelai mabrok nekre ti wasi bo desy, dendye yena iry maka usu khatu ti iry makety jelai desikre ma byohe, “Wamfwet kabei desy de?” ");
INSERT INTO slu_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Lemade uskwe khatu desike hyalas Boas ma byohe, “Wamfwet desike iry a Moabke. Ma kyoat Naomi yulak i a yosy a Moab ma mya, desikeo yor wamfwet desy ma rma. ");
INSERT INTO slu_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ode wamfwet desike dai iten toha yaw, ma lemamo klwura i ma tyoha iry makety jelai nekre etatare, ma yily a jelai mabrokare. Ode klwosu ti o ohe, wamfwet desike yily a jelai mabrokare kyala kyosy dai bolbolke de, nini jam ne bony mane. Ma lema imres elik.” ");
INSERT INTO slu_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Lemade Boas bya sara Rut ma tyanuk ti i ma byohe, “Akasy, mtwomolu mamak nam ana kutanuk ti o ne. Kete mbwa ti mily a jelai o iry salik wait boare. De mumin ti ne bo, ma mor wamfwet makarya ma yaw nekre. ");
INSERT INTO slu_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ode mubalmat ti makarya ma yaw nekre, ma kolnye rbai wen kabei ta kabei ti bo ne ti rkety a jelai ti, desikeo mtwoha etatare ma mily a jelai mabrokare. Ode kete mumtaut wamwany makarya ma yaw desikre, kali kbwu eta sir de, ma kete rsalsyalik a o. Ode kolnye mbwatu, desikemo werke desy lkusy desikre, dendye mbway ma menw bo.” ");
INSERT INTO slu_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kyoat Rut itomolu Boas tun itanukare bonyo, syakitil ma you ti i, ode tyanuk ma byohe, “Amo, yaw ne mwakun yaw bo. Ode kyanmwane muala eraske kdeda ne ma yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Lemadendye Boas hyalas i ma byohe, “Yaw neke ktwomolu ktela eras muala ti ryanamkwe de, ti kyoat laimw imatkye. Neke bisa ma mtwutuk wasimw bangsake, ode mtwutuk enamw o amamw, ode mtwoha ryanamw ma mmwa ma mumin ti ne de, ma mor iry a lema muhe nekre. ");
INSERT INTO slu_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Lemamo iry a Israel aramy ne, ara wasimy Hulasow YANWE yal eraske ti o, ode ana yal ksewanke ti o, kali mmwa ma mureit I, ma yaoa o.” ");
INSERT INTO slu_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Lemade Rut hyalas i ma byohe, “Amo! Wasimw eras neke lan ma yaw ksyalik. Ode mala ralakkwe ma ksyenan, biar ma yaw neke lema kbwer o ktwahal kola wasimw makaryaare dakun.” ");
INSERT INTO slu_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ode kyoat makarya desikre rala ma raknam bonyo, Boas yabuk Rut ma byohe, “Akasy, mmwa ma taknam. Rotkye ne. Dendye mal, ode mhwuhuk ti tasy maiskye kwen ne ma mu.” Lemade Rut tyaklulu yor iry makarya desikre, ode Boas yal huruk jelai rakoilke ti Rut ma nya dakun. Lemade Rut nya hina kotw Boas inal ti i desikre nini lema nyaa yal, kali byesur de, dendye syosan a kteranare. ");
INSERT INTO slu_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Maktei o Rut bya ti yily a jelai mabrokare huruk. Ode kyoat iba bonyo, Boas byu ti wasi makarya desikre de byohe, “Kolnye wamfwet desike yal jelai maney a jelai mihoin desikre, desikemo kete mkyeyer a i, ode kete myaranran i. ");
INSERT INTO slu_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ode lemamo mnyaik jelai desikre ratebikan toha dai mihoin desikre, ma mtyunik ei hahke mamode yily. Ode kolnye yily, desikemo kete mkyeyer a i.” ");
INSERT INTO slu_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ode Rut yili-yily a jelai desikre nini sekwe bya. Maktei o yiry a jelai iily desikre ma kisinare kyaditi toha klaanare, ode yahuk kisi desikre, desikeo kolakye sasam a kbyenw mamamak. ");
INSERT INTO slu_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Maktei o Rut yulak i bai hnu Betlehemke, desyo yety jelai desikre, ma ti syusu ti ryana ohe, jelai iily nekre kdedake ne. Ode yal kotw dai ina desikre kteranare ti ryana dakun. ");
INSERT INTO slu_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Lemade ryana-na yena i de byohe, “Mily jelai ne toha kabei de? Ode senweke mkwarya ti esei wasi bo de? Eraske kimin ti iry a ralake eras ti o ne!” Lemadendye Rut ihes ti Naomi ma byohe, “Bo kuily jelai tike, neke kebuke ani Boas.” ");
INSERT INTO slu_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Maktei o Naomi tyanuk ti sobai desy ma byohe, “Lemamo Hulasow YANWE yal eraske ti boke kebu desy. Ode ktela eras madi ti o desike ksyusu ohe, Hulasow YANWE lema imluak wasi tnyetakke ti iry a mamaty o mamorif nekre. Anakw o, boke kebu desike sekye krala sasam ity, ma musti mo i desike lyitan eta ity!” ");
INSERT INTO slu_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Lemadendye Rut lyosu huruk ti ryana ma byohe, “Eno! Iry desike byuma ktwoha wasi iry makaryaare, ma kily a jelai mabrokare, ode gandum mabrokare dakun, ti wasi boare mumu, nini makarya desikre rkety jelai o gandum desikre mumu ma ktei bo.” ");
INSERT INTO slu_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Lemade Naomi tyanuk ti sobai desy ma byohe, “Anakw o, lemamo mkwaryaa mor iry desike wasi makaryaare ti wasi boare bo. Kali kolnye mbwai iry salik wait boare, desikemo mamak de kyal nini nam dum a kena o.” ");
INSERT INTO slu_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Lemade sew kyaki nekre Rut tyoha Boas wasi makarya wamfwet desikre, ma ti rkety a jelai o gandum mamin ti Boas wasi bo desikre, nini oras a rakety jelaike ktei, ode oras a rakety gandumke ktei dakun. Ode Rut a myorif yor a ryana Naomi ti hnu Betlehem desy bo. ");
INSERT INTO slu_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Sekwe it huruk bonyo Naomi tyanuk ti sobai Rut de byohe, “Anakw o, musti mo kobak wamwankye it ma musaa mor i, ma kete kika nam matol ti o. ");
INSERT INTO slu_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ode Boas neke ilura o ma mutoha wasi makarya wamfwet desikre etatare ne, ma muily jelaike ti wasi boke ne, desike ne ksyusu ohe yal eraske ti o ma desy. Boas neke sekye krala sasam ity dakun. Lemade mtwomolu mamak nam kutanuk ne! Metdyet neke Boas ana byai wen rabesak jelai tike. ");
INSERT INTO slu_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Lemade muris, ode mhwonak rabit eras-eras ne it, ode mkwasa nul mahon a mtelaske ti o, ode mbwai wen a Boas rabesak jelai tike. Keskyede msweak mamak ma kete hye o. Ode msweak ma iknam o yenw ma ktei aduk. ");
INSERT INTO slu_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ode mlwaw ma kolnye ti yenaf, desikeo mbwihy mamak wen ienaf tike. Ma kolnye mhwe wen a ienaf tike de, desikeo mlwakut kakakan bai desy, ti mbwitil kakakan wasi insekirke toha lwau-na ktutunare, maktei o menaf ti lwau-na ktutu desikre. Mamode kyoat a byatar, desikeo ana lyosu ti o ohe, musti mo ana mala sai.” ");
INSERT INTO slu_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Dendye Rut a hyalas ryana Naomi ma byohe, “Ou, eno, ana ktwoha nam mutanuk nekre mumu.” ");
INSERT INTO slu_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Lemadendye Rut byai wen a rabesak jelai tike, ode tyoha nam ryana-na isurat ti i desikre mumu. ");
INSERT INTO slu_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Ode kyoat Boas iknam ma ktei, desikeo ryekan ti wasi mormyorifke ma khyury ma ralake kimukmuka i, lemade bya ti yenaf ma nyey a jelai rautun desikre. Ode kyoat ienaf ma itebti bonyo, Rut lyakut kakakan ba ti byitil Boas wasi insekirke toha lwau-na ktutunare, maktei o yenaf ma nyey a Boas lwau-na ktutu desikre. ");
INSERT INTO slu_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ode ti metdyet a kditlan ne, Boas imsel ma iasyeri i bonyo, kele rsumuk mait i ma yatos o, irkye it a yenaf ma nyey a lwau-na ktutunare, neke wamfwet a i! ");
INSERT INTO slu_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Dendye yena wamfwet desy ma byohe, “Hei, esei o de?” Lemade Rut hyalas i ma byohe, “Yaw ne Rut, iry a lema maka kbuan ne. Kuten ma lemamo mal yaw ti wasimw rabit narnarkwe hah desy, ma sawamw a yaw. Kali oi neke mor laikw mamaty ne sekye krala sasam e, dendye musti mo oi ne mlwitan eta yaw.” ");
INSERT INTO slu_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Lemade Boas a hyalas i de byohe, “Anakw o, kuten ma Hulasow YANWE yal eraske ti o. Kali senwe ktela muala neke eras ma kbyilak ktela liahke muala ti ryanamkwe. Ma oi ne lema ti muobak a lyalaw murare ma musaa mor sir, biar ma sir desike raka wait maloly, ta lema raka wait maloly dakun. ");
INSERT INTO slu_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Lemadendye kete ralamkwe kakan. Kali nam mutanuk desikre, ana kala mumu. Kali iry ribun lan mamin hnu neke rhe ohe, oi neke wamfwet eras a o. ");
INSERT INTO slu_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Dendye mlay, yaw ne bisa ma klwitan eta o, kali kor a e ne sekye krala sasam ity. Keskyede irkye it dakun neke, ana bisa ma lyitan eta o a kmuna, kali i desike wasimy sekye krala elik-elikke i desy. ");
INSERT INTO slu_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ode metdyetke lan de, dendye kete mulak o bai hnuke de. De menaf ne bo. Ode ana bolbol ne, desikeo kbwa ti ksweak iry a kulosu i ti o ohe, ana bisa ma ilitan eta o a kmuna ne, ma kena i ohe, you ma lyitan eta o ta lema. Ma kolnye you, desike eras ma miru misa, dete kolnye lema you, desikemo kal Hulasow mamorif ne Anike, neke Hulasow YANWE, ma kuhatetak ohe, ana yaw ne kusaa kor o ma klwitan eta o. Dendye menaf ti ne bo.” ");
INSERT INTO slu_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Lemade Rut yenaf ma nyey a Boas lwau-na ktutunare ti desy nini nyamo ne, desikeo Rut byatar, ma kete irire rhe i. Kali Boas a tyanuk ti i a kmuna deny ohe, “Msweak mamak, ma kete kyal nini irire rhe ohe, mmwai wen rabesak jelaike ti ne.” ");
INSERT INTO slu_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Dendye Boas tyanuk ti i ma byohe, “Mhwela wasimw lelel smwel desy ti ne.” Lemade Rut a hyela wasi lelel smwel desike ti desy. Ode Boas syarah jelai rautun desikre ti ur akye ma kbyenw ma yalik ti lelel smwel desy. Yala koldyesy kdi a kla-nem. Maktei o syumuk ti Rut ma hyah, ma byai hnuke. Ode lema soso bonyo, nenmo Boas byai hnuke dakun. ");
INSERT INTO slu_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ode kyoat a Rut inait sekye bonyo, Naomi yena i ma byohe, “Anakw o! Mane kolkyabei ti Boas de?” Lemade Rut ihes nam ribun lan Boas itanuk ti i desikre mumu ti ryana. ");
INSERT INTO slu_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Maktei o Rut a lyosu ti ryana ohe, “Boas i ne inal jelai nekre ma yaw ne, ma kolnye kmwai hnuke ma kait a o, desikemo kete kumran ti mamake.” ");
INSERT INTO slu_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Dendye Naomi tyanuk ma byohe, “Anakw o, takita aduk ma tseak ohe, nam sai ana kdi ti. Kali khwe ohe, Boas neke lema imres elik, ma yobak a ksala nini ktela desikre kdi ti bo.” ");
INSERT INTO slu_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Sew desike Boas a byai wen rataklulw ma rawahuk sir tike, neke ti lorkye kmata hnu desy. Lemade Boas tyaklulw ti wen desy, ma ikita wamwany ana ilitan eta Rut a kmuna desy. Ma lema soso bonyo, wamwany desike kele rsoru i ma lyakut yosy sal desy. Lemadendye Boas yabuk i ma byohe, “Wai! Mmwa ma ttaklulw ti san aduk.” Dendye wamwany desike bya ti yait Boas, ma deruke rtaklulw ti desy. ");
INSERT INTO slu_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Maktei o Boas yabuk iry manety lulw ti hnu desike irkye hean, ode tyanuk ti sir ma byohe, “Amakw e, mmya ma mtyaklulw ti san aduk, ma mtyomolu ktela ana ara miru mihes nekre aduk.” Dendye iry a Boas iabuk desikre rma ma rtaklulw ti desy. ");
INSERT INTO slu_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Lemade Boas tyanuk ti wamwany desy ma byohe, “Wai, Naomi nenmo yosy a lasmyer Moabke ma mya, ma yala ma kyeta ity wait a Elimelekh wasi lasmyerke. ");
INSERT INTO slu_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Lemade krwekan o musti mo tahes a mlakye ti ktela ne aduk. Neke kolnye: kolnye mbwuma mlwiw lasmyer desy, desikemo mlwiw, mamode iry manety lulw ti ity wait hnu ne, ror iry mamdiry ti nekre mumu ne rhe dakun. Dete kolnye lema mou ma mlwiw, desikemo mlwosu ma yaw, ma khwe elik. Kali wai, oi neke musti mo mlwiw kmuna lasmyer desy, kali oi neke sekye krala elik a e. Dete kolnye lema mou ma mlwiw, desikemo ana yaw klwiw.” Lemadendye wamwany desike tyanuk ti Boas ma byohe, “Ou! Ana klwiw.” ");
INSERT INTO slu_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Dendye Boas tyanuk ti i ma byohe, “Kolnye mlwiw lasmyer desike toha Naomi, desikemo musti mo musaa mor Rut, wamfwet manosy lasmyer Moab desy. Kali Rut neke kola isaa yor Mahlon, neke Naomi ananke, keskyede Mahlon a myaty de. Dendye wai, kolnye musaa mor Rut, ma ana kolnye idur hahak naman wamwankye it, desikeo naman wamwany desike ana syaa i ti lasmyer desy, ma ebu Elimelekh anike lema bisa ma kitayar toha lasmyer desy.” ");
INSERT INTO slu_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Dendye wamwany desike hyalas Boas ma byohe, “Wai, kolnye koldyesy, desikemo kubrai klwiw a lasmyer desy. Kali kolnye klwiw, desikemo wasikw maloly ana kuhe ti anakure ne, ana ktyol ti sir ma desy. Dendye lemamo klwura ti o ma oa mlwiw bo.” ");
INSERT INTO slu_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Heitlulswo ti Israel ne, kolnye iry a wasi harharke ma lyiw a nam dum, keskye lema you ma lyiw, de lyura ti iry salik ma rliw, desikemo musti mo yonuk wasi dorike serit, ma yal ti iry ana maliw desy, ma klyosu ohe wasi harharke yal ti iry a maliw desy de, ma ktyoha iry a Israel-are wait a ktelake. ");
INSERT INTO slu_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Lemadendye kyoat a wamwany desike tyanuk ti Boas ma byohe, “Wai, oa mlwiw bo,” desikeo yonuk wasi dorike serit ma yal ti Boas. ");
INSERT INTO slu_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Dendye Boas tyanuk ti iry dehean manety lulw ti hnu desy, ror iry ribun mamdiry ti desikre dakun ma byohe, “Amakw e, senweke miktemtem a myatos elik de, ma klwiw Elimelekh yor anan Kilyon ode Mahlon wait lasmyerke, ktyabal lan o hnutat nekre mumu, toha Naomi a Elimelekh sawa desy de. ");
INSERT INTO slu_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Dendye kal Rut wamfwet Moab desy ma sawakw a i. Rut neke kola isaa yor Mahlon, keskye Mahlon a myaty de. Dendye ana kusaa kor Rut, ma kolnye idur hah ma anan wamwany auskwe, desikeo naman desike yeluk Mahlon, ma naman desike ana syaa i ti lasmyer kuliw ne, ma ti kyal ebnwo anan nekre mumu ne ana rsaa sir ti lasmyer desy dakun. Mamode any Mahlon desy, kyor lasmyer desy kete kitayar toha hnu ne. Dendye amakure myor iry mamdiry ti nekre mumu ne mnyenas, kali ei neke myatos elik de.” ");
INSERT INTO slu_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Lemadendye iry dehean manety lulw ti hnu desy, ror iry ribun mamdiry ti desike rhalas Boas ma rbohe, “Ou! Aramy miktemtem neke myatos elik a miru ti wasimy hatetakke de. Dendye aramy miten Hulasow YANWE, ma yal eraske ti wamfwet ana masukar ei wasimw sekye krala desy, ma yola Rahel ode Lea, ti radur hahak naman ribunke ti Yakub ne. Ode aramy miten ma wasimw malolkye lan, ma kbyilak a iry a Efrat ity ne, ode animkwe kimelir ti iry ribun mamin ti hnu Betlehem ne. ");
INSERT INTO slu_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ode lemamo Hulasow YANWE hyarak mamak naman ana mutot toha wamfwet mur desy, ma wasimy sekye kralake kola ity ebnwo matrumat Peres a Yehuda yor Tamar anat desy.” ");
INSERT INTO slu_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Lemadendye Boas yal Rut ma sawa i. Ode Hulasokwe yal eraske ti Rut, lemade yor tenanke, dendye idur hah bonyo, ananke wamwany a i. ");
INSERT INTO slu_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ode kyoat Rut idur ti naman desy, desikeo wamfwetare ti hnu desy neke rtanuk ti Naomi ma rbohe, “Tleru Hulasow YANWE Anike, kali lema imluak a o, mane muka ebumw mane. Ode ebumw neke wamwany a i, ma ana syaa i ti wasimw lasmyer o, lan o hnutamw nekre mumu, ode syeak o ti wasimw mormyorifke dakun. Ode aramy miten ma naman desike irire ralan a i, ma anike kimelir ti Israelke ktem ne mumu. ");
INSERT INTO slu_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ode sobaimw neke lyobak a o a ksyalik, ma kbyilak ti kola ne naman wamwankye itw a sir ti ralobak enatke ne. Ode ti senwe huruk o idur hahak naman wamwankye it ti o de, ma ebumw a i. Ode ebumw neke ana yaluka ralamkwe, ode ijaga o ti ana enmosw a o ne.” ");
INSERT INTO slu_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Lemade Naomi yal naman desy, ma myumw a i kola ne idur hahak i ne, nini lan a i. ");
INSERT INTO slu_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ode wamfwet mamin wasi serkyait desikre rtanuk ma rbohe, “Naomi ika anan de, ma wamwany a i!” Ode wamfwet desikre raki naman desy anike ti Obed. Ode Obed neke lyean ma lan a i ma isa, desikeo anan Isai. Ode Isai neke anan raja Daud. ");
INSERT INTO slu_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ode Peres tesnwo natu sir ne, neke ne: Peres anan a Hezron. ");
INSERT INTO slu_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron anan a Ram, Ram anan a Aminadab. ");
INSERT INTO slu_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab anan a Nahason, Nahason anan a Salmon. ");
INSERT INTO slu_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon anan a Boas, Boas anan a Obed. ");
INSERT INTO slu_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed anan a Isai, Ode Isai anan a Daud.");
INSERT INTO slu_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Sekwe it bonyo, Hulasokwe mya ma byu ti a Yunus, Amitai ananke, ma byu de byohe, ");
INSERT INTO slu_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Yunus o, adoko mbwai Niniwe nus lan so, ti mataut sir, ode mlwosu ti sir ohe, totat atyat raalanare kyait Yaw ma khwe de.” ");
INSERT INTO slu_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Keskyede Yunus lema tyoha haret desy, de yobak ma ilaa syanyeta ma byai Tarsis, ma soso i toha Hulasokwe. Lemade byai nus Yafoke aduk, ma ti iobak kabal bonyo, yatos o kabalke it a kbyaly ma kyala ma kbyai Tarsis. Dendye syelw tenanke ti kabal desike ma ihnabul, ode byai Tarsis. ");
INSERT INTO slu_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Lemade Hulasokwe yala us o esw ma lan ne ti tasike ma besanare lan, ode kyala kabal desike ma nenma kimrunu-kimrahas. ");
INSERT INTO slu_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Kabal a kebunare ramtaut ma kiseseman sir. Lemade it o it yabuk wasi hulasow, ode ral lan o nam rasosan ti kabal desy ma rotuk ei tasike, ma wait kabalke mran. Lenla ktela ne kdi ti bonyo, Yunus yorw ei kabalke kletike ti yenah ma tyebti desy. ");
INSERT INTO slu_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Desike bonyo uskwe khatu ti kabal desy yorw ei kabalke kletike desyo itot Yunus ma moluk a yenah. Lemade byu ti i de byohe, “Kyanmwane malmata atyatke kidan ity ode muenaf ne de? Mbwatar ma mswambayan ti wasimw Hulasokwe, anakyai tyomolu ode lyobak ity ma kete tmaty.” ");
INSERT INTO slu_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Lemadendye Yunus yor uskwe khatu desy rsai ei kabalke srake. Desikeo kabal a kebunare it de byu ti it de byohe, “Mmya ma tatubuk tasy ma tseak o esei ne ihury ma nenma tamaty ne de?” Dendye iry desikre ratubuk tasy bonyo klyosu Yunus. ");
INSERT INTO slu_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Lemade rbu ti Yunus de rbohe, “Bain o oi ne muhury ma nenma tamaty ne de? Mosy kabei, ode hnu kabei o de? Kyanmwane mumin hah neke ne de?” ");
INSERT INTO slu_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yunus hyalas sir de byohe, “Yaw ne Ibrani yaw. Kyalamo kswob ti Hulasow a mamin sra ne, ma I ne iala lait o lasmyer ne.” ");
INSERT INTO slu_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Dendye Yunus ihes ti sir ohe ila toha Hulasokwe ma kete Hulasokwe myatakit a i. Iry desikre ratomolu nam itanukke bonyo, ramtaut ma kiseseman sir a ksyalik ode rbohe, “Nam sai ne muala ne de?” ");
INSERT INTO slu_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Kyoat desike besanare lan a lan toha, ma khyury iry desikre ma rena i huruk de rbohe, “Ana aramy myala o kolkyabei ma, adoko tasi neke kele rteka de?” ");
INSERT INTO slu_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Lemade Yunus byu ti sir de byohe, “Mkyumak yaw, ode myotuk yaw ei tasike. Ana miotuk yaw ba bonyo, tasike mlin, ode lema ktyabahunw e de. Kali khwe ohe yaw ne kuhury ma, us o esw nenma kitabahunw a ity ne.” ");
INSERT INTO slu_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Keskyede kabal a kebu desikre ral amalkyautare ma rhaya wait kabal desy ei rake, keskye lema rhaya ral, kali besanare ksyai ma lan lahuk de. ");
INSERT INTO slu_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Lemadendye raten toha Hulasokwe de rbohe, “O Hulasow O, aramy miten ma kete mtwabahunw aramy, kali aramy myotuk iry ne ei tasike. Iry neke lema isal ma aramy, keskye O Hulasow O, kyosy a O ma mala sai ta sai ti i bo.” ");
INSERT INTO slu_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Lemade rkumak Yunus ma rotuk i ei tasike kralake. Desike bonyo nenmo kele rteka us o esw, ma tasi desike mlin a mlin. ");
INSERT INTO slu_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Iry desikre ratos a ktela desike bonyo, kele rsumuk mait sir ma ramtaut Hulasokwe. Lemade rkotal heal ma rabar ti Hulasokwe, ode rahatetak ti I dakun. ");
INSERT INTO slu_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Lemade Hulasokwe yaso masy lan de lan ne it ma mya ma tyel Yunus. Ode Yunus imin masy desike hteike kralake sewahke enatelw o msarinke enatelw. ");
INSERT INTO slu_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ti a maskye hteike krala desy Yunus syambayan ti ity Ebutke ");
INSERT INTO slu_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","de byohe, “O Hulasow O, atyatke kdyan yaw bonyo kabuk O, desikeo mhwalas yaw. Ti a wen mamatire ramin tike kkwairury, desikeo mtwomolu telakkwe. ");
INSERT INTO slu_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Kola motuk yaw bai wen demdemkwe ti a tasike kditlalan ne, ma kkyahat eta yaw, ode mala besa lan nekre ma kdyan eta yaw. ");
INSERT INTO slu_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ode krwekan ti ralakkwe ma kbwohe, ‘O Hulasow O, kola mesak yaw toha O de, keskyede ana kswukar huruk ti Seimkwe.’ ");
INSERT INTO slu_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Kenw tasi ne ma ktwemar ei hahke, ma matmyatikkwe kyait yaw de; lkyekare kyaklela i ti usukkwe khatuke. ");
INSERT INTO slu_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ktwemar ei tasike krala lahuk ne ma, kumin mamaty rala de, ode lema khwe morifke de. Keskye, Oi ne wasikw Hulasow O, ode Oi ne mbwity yaw ma maditi yaw toha matmyatikkwe de. ");
INSERT INTO slu_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","O Hulasow O, kyoat a isnosmwaknakw mdedan bonyo knwenas a O, ode wasikw sambayanare kyait O ti a Seimkwe kralake. ");
INSERT INTO slu_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Iry a ktemare sir ne iry matohak ti a nitwomatu nekre, ma khyury ma raditi sir toha Hulasow a maala eras sirke ode maloblobak sirke. ");
INSERT INTO slu_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Klala yaw neke kuora ma klweru Animkwe, ode ana kkwotal heal ma kabar ti O; Ode tun kuhatetak ti Oare ana ktwoha, kali mormyorif neke kyosy O a mmwesan bo.” ");
INSERT INTO slu_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Lemadendye Hulasokwe yaso masy desike ma ti myutak Yunus ei rake. ");
INSERT INTO slu_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Kdi a kla-ruake ma Hulasokwe byu ti Yunus de byohe, ");
INSERT INTO slu_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Yunus o, mbwai Niniwe nus lan so, ti mtwanuk haret kutanuk ti oare ti sir.” ");
INSERT INTO slu_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Lemade Yunus tyoha haret Hulasokwe itanukare ma byai Niniwe. Niniwe neke nus lan de lanke ma kolnye tlakut tosy hnuke lulkwe ma tbai hnuke lyakwe neke kyal sekwe enatelw (3). ");
INSERT INTO slu_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yunus inait nus desy bonyo, syukar ode lyakut a sekwe sasam ma yarasik hnuke kditlanke, desikeo nenmo yatela de byohe, “E mtyomolu haret manosy Hulasokwe. Ana sekwe hean-at (40) bonyo, Niniwe neke kiskyui-kiskyay.” ");
INSERT INTO slu_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Lemade ratomolu maktei bonyo iry Niniwe desikre mumu rtohak Hulasokwe tun itanuk desy ma rbuma lema raknam o renw, ode lan o kakan o enmosw o amosw rhonak kadutare ma klyosu ohe rasal ti Hulasokwe. Ktela ne kdi ti kolnye kali: ");
INSERT INTO slu_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Sew desike Raja Niniweke itomolu tun Yunus itanukare bonyo, yorw toha wasi kaderke, ode yonuk wasi rabit a kmata lanke, maktei o yal kadutke ma hyonak, ode tyaklulw ti ahkwe kralake ma klyosu ohe isal ti Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Dendye yal haretke ti nuske ktem desy de byohe, “Haret neke kbyetik toha Raja Niniweke yor wasi Melare ma rohut kolnye: Iry o heal o nam nekre myas mumu, ma kete miknam o myenw. ");
INSERT INTO slu_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ode miktemtem a mtyabal heal o nam nekre mhyonak kadutare mumu, kbuanke o taktemtem tasal ti Hulasokwe. Dendye taktemtem a tsambayan ti Hulasokwe neke tal ity ralat a kralanare bain-bain ma kete kyalamo tala tot atyatare de. ");
INSERT INTO slu_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Esei hye ohe ana Hulasokwe Ralake kyulak i ma lema kyeyer a ity ode lema tyabahunw o yah a ity.” ");
INSERT INTO slu_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Lemadendye Niniwe desikre mumu rtoha haret desy, ode Hulasokwe yatos o iry desikre rotuk wait totnyo yabit atyatare ba de. Dendye Hulasokwe lyobak sir ma lema byuma tyabahunw a sir ma ktyoha tun itanuk mamunake. ");
INSERT INTO slu_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Yunus lema tyeman a hye a ksyalik ma kyeyer, kali hye o Hulasokwe lema tyabahunw Niniwe-nare. ");
INSERT INTO slu_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Lemade syambayan ti Hulasokwe ma byu de byohe, “O Hulasow O, kyalake lenla kala ma kubetik toha ara wasimy hnuke bonyo, khwe ohe ana mlwobak a sir, mane kihury ma kula kbwai Tarsis ne. Kali khwe o Oi ne mulobak iry, ode klatsam a klatsam o nenmo muka keyer, kali mhwe weweanke. Ode mdwakin ma mhwasana rekryekimure ma lema mutabahunw iry. ");
INSERT INTO slu_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","O Hulasow O, lemamo mtwabahunw yaw ma kmwaty ma kete kmworif de!” ");
INSERT INTO slu_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Keskye Hulasokwe hyalas i ma byu de byohe, “Nam sai ne kihury ma mukeyer kolnye de?” ");
INSERT INTO slu_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Desike bonyo Yunus byetik toha Niniwe ma byai wenke it ti nus desike kseri timurke. Ti wen desike Yunus ika lasyerkye it ma tyaklulw ti ma kyaoa i. Ode ikita ma ibalmat ohe nam sai ne ana kyala hnu Niniweke ne de. ");
INSERT INTO slu_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Lemadendye Hulasokwe yala akluke ma kilay ei lasyery desy ma kika kmauan ma Yunus ireit, ode imukmuka i kali dyakin aklu desike a ksyalik. ");
INSERT INTO slu_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Keskyede bolbolbol ne bonyo, Hulasokwe yaso ulke it ma mya ma nya aklu desike kawanare ma khyury ma aklu desike kmyalas. ");
INSERT INTO slu_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Sekwe ibetik bonyo, Hulasokwe yala esw ne ma ksyiri kyosy kseri timurke, ktyabal sekwe ranranan manas ma ksyon Yunus usuke khatuke ma nenma myatmyuly. Ode kyala Yunus ralake ma kakan, ma byuma myaty bo. Lemade byu de byohe, “Lemamo kmwaty lakhidik ma kete kmworif de!” ");
INSERT INTO slu_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Keskyede Hulasokwe byu ti i de byohe, “Muka keyer o aklu ne kmyalas, e?” Desikeo Yunus hyalas ma byu de byohe, “Ou, kkweyer ande! Kkweyer nini kmwaty bo!” ");
INSERT INTO slu_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Lemade Hulasokwe byu huruk de byohe, “Aklu ne ktyuhw sewahke sasam bo, ode sewahke sasam huruk o kmyalas. Ode oi ne dakun o lema mungkoly ma mtwan o msweak, desyo mlwobak o kmyalas. ");
INSERT INTO slu_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ode kyanmwane lema kulobak a Niniwe nus lan ne de? Kali kbyenw ti namanare aryaritke ribunke atw ksala hean-ru (120.000) rtabal wait a biby o hahy. Ode naman ribun lan desikre dakun o lenla rrekan a rhe eraske kolkyabei ode atyatke kolkyabei.” ");
INSERT INTO slu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristus neke ebnwo matruma Daud, ode Daud ebnwo matruma Abraham. Neke ksalake kolnye, ");
INSERT INTO slu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham anan a Ishak, Ishak anan a Yakub, ode Yakub anan a Yehuda yor wainare. ");
INSERT INTO slu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda anan a Peres yor Zerah. (Peres yor Zerah neke enat Tamar.) Peres anan a Hezron, ma Hezron anan a Ram. ");
INSERT INTO slu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram neke anan Aminadab, ode Aminadab anan Nahason, ma Nahason anan a Salmon. ");
INSERT INTO slu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon sawa Rahab ma anat a Boas, ma Boas sawa Rut ma anat a Obed, Obed anan a Isai. ");
INSERT INTO slu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ode Isai anan a Daud, ma Daud neke ika raja. Ode raja Daud isaa yor enen somke, ma anat a Salomo, enen som neke Uria sawa. ");
INSERT INTO slu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ode Salomo anan a Rehabeam, ma Rehabeam anan Abia, ode Abia anan Asa, ");
INSERT INTO slu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa anan a Yosafat, Yosafat anan a Yoram, Yoram anan Uzia. ");
INSERT INTO slu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia anan Yotam, Yotam anan a Ahas, Ahas anan Hizkia, ");
INSERT INTO slu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ode Hizkia anan a Manasye, ma Manasye anan Amon, ma Amon anan Yosia, ");
INSERT INTO slu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ode Yosia anan Yekhonya yor wainare, neke radur sir ti kyoat ramin ti nus Babelke, kali iry a Babel-are rma ma rkumak Israel-are, ma rhait sir bai nus Babelke ti raka at ti so. ");
INSERT INTO slu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ode iry a Israel-are rbetik toha Babel ma rulak sir mai Israel huruk ma ramin ti bonyo, Yekhonya anan Sealtiel, ode Sealtiel anan Zerubabel. ");
INSERT INTO slu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ma Zerubabel anan Abihud, ode Abihud anan Elyakim, ma Elyakim anan Azor, ");
INSERT INTO slu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ode Azor anan a Zadok, ma Zadok a anan Akhim, ode Akhim anan Eliud, ");
INSERT INTO slu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ode Eliud anan Eleazar, ma Eleazar anan Matan, ode Matan anan Yakub. ");
INSERT INTO slu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ma Yakub anan a Yusuf, neke Maria lai i, ma Maria neke i ne idur hahak a Yesuske ne. Yesus neke Mesias I. ");
INSERT INTO slu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dendye Yesuske ebnwo matrumanare, neke kyala kyosy taras Abrahamke ma ti kyait a taras Daudke, neke taraske hean a kresi enaat ma desy. Ode kyala kyosy a taras Daudke, ma ti kyait a taras raotuk Israel-are bai Babelke, neke taraske hean a kresi enaat huruk. Maktei o kyala kyosy a taras raotuk Israel-are bai Babelke, ma ti kyait taras a Kristuske, neke taraske hean a kresi enaat huruk dakun. ");
INSERT INTO slu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Waikw o hatnimakw e, tkunw a Yesus Kristuske radur ti I ne, neke kolnye: Maria neke warar mur a i, ma ana Yesuske ena-na i desy. Ode kyoat desike Yusuf ika warara yor Maria, ma Yusuf lenla yal i ma sawa i bonyo, Maria neke yor tenanke de. Keskyede Yusuf lema hye ohe, Maria inor tenanke ne, neke Hulasokwe Memeanke kkyarya ti i ma desy. ");
INSERT INTO slu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Keskye Yusuf neke ralake eras ode nelnyely, ode tyohak ti Hulasokwe. Dendye kyoat ihe o warara Maria ne inor tenanke bonyo, yohut ti ralake ma ana lema isaa yor i. Keskye ana lema yala ma kdudu, kali lema byuma Maria ne anike kiray ti ribunke khahake. ");
INSERT INTO slu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Keskyede Yusuf ryekan ti ktela desy nini yenaf. Ode kyoat ienaf bonyo, myey o, Hulasokwe wasi nyaso manosy laitke mya ma syusu tenanke ti i, ma byohe, “Yusuf a Daud tesnwo natu o, kete ralamkwe kakan, de mal Maria ma sawamw a i. Kali naman mamin a fteike krala desy, neke Hulasokwe Memeanke kkyarya ti i ma desy, ");
INSERT INTO slu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ma ana idur hah bonyo ananke wamwany a I, desikeo musti mo maki anike ti Yesus. Kali I desike ana yaorif iry matohak ti Iare, toha wait lim o sal nekre.” ");
INSERT INTO slu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ktela desike kdi ti, ma ktyoha tun Hulasokwe itanuk ti wasi manety nyanoare, ma rakesy ti wait kitabare ne, ma kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mlay bain ohe, ana warar murke it ma lenla yenaf yor wamwankye it elik, neke yor tenanke, ma idur hahak naman wamwankye it, ma raki anike ti Imanuel, neke kbuanke o, ‘Hulasokwe yor a ity.’” ");
INSERT INTO slu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dendye kyoat Yusuf ibatar bonyo, tyoha haret nyaso manosy laitke itanuk ti i desy. Lemadendye yal Maria ma sawa i. ");
INSERT INTO slu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Keskyede Yusuf lema yenah yor Maria nini kyait a Maria wasi sew a idur hahke bo. Ode kyoat Maria idur hah bonyo, ananke wamwany a I, lemadendye Yusuf yaki naman desy anike ti Yesus. ");
INSERT INTO slu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesuske radur I o hnu Betlehemke, ti propinsi Yudeake. Kyoat desike Herodes ika raja ti propinsi Yudea desy. Ode kyoat desike dakun o iry a majusare, neke iry a mahe tel ma ratos nyatos mamin ti ftunare ne, neke rosy a Timurke ma rbai nus Yerusalemke. ");
INSERT INTO slu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ode ranait Yerusalem bonyo, rena iry mamin desikre ma rbohe, “Naman a nenmo radur ti I ne, ma ana ika raja ti iry Yahudi-nare ne imin o ka? De aramy myatos wasi ftun mabetik ti kseri Timurke, dendye aramy mmya ma myala ma msyakitil ode myou ti I mane.” ");
INSERT INTO slu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ode kyoat a raja Herodes itomolu ktela desy bonyo, kele rsumuk mait i ma ralake masbu, ode iry a mamin ti nus Yerusalem desy mumu ne, kele rsumuk mait sir dakun. ");
INSERT INTO slu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lemadendye raja Herodes iwahuk iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror Yahudi-nare wait iry mahe snurat o tnyetak Musake, ma yena tun toha sir ohe, Mesias neke radur I o ka? ");
INSERT INTO slu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lemade iry desikre rhalas raja Herodes ma rbohe, “Radur I o Betlehem ti propinsi Yudeake, ma ktyoha iry manety Hulasokwe wasi nyanoare rakesy ti wait kitabare ne, ma kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hei Betlehem o, mumin ti propinsi Yehudake, ma biar ma kakan o ti nus o hnu mamin ti lasmyer Yehuda ne, keskyede lema kakan a o. Kali kyosy a o, ana irkye it a ika usu khatu, ma ijaga ode hyareta iry a Israel-are.’” ");
INSERT INTO slu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kyoat a raja Herodes itomolu koldyesy bonyo, yabuk kakakan iry a majus desikre, ma yena sir mamamak ma byohe, “Hekyab ne mimatakit ftun desy ne de?” ");
INSERT INTO slu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Maktei bonyo yaso iry a majus desikre ma tyanuk ti sir de byohe, “Mbyai Betlehem! Ode myobak naman desy mamamak. Ma kolnye mitot a I, desikeo myal britke ma yaw, mamode kbwa ti kswakitil o kou ti I dakun.” ");
INSERT INTO slu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Dendye iry desikre ratomolu raja Herodes tun itanukare maktei bonyo rba. Ode kyoat raba bonyo, ratos ftun a kola ramatakit ti kseri Timurke ne, dendye ramukmuka ramarmara sir a ksyalik! Kali ftun desike lyakut a kmuna sir, ma ti imres ti sey a naman desike imin tike. ");
INSERT INTO slu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lemade iry desikre rsukar ei sekye krala desy, ma ti rseak a naman desike yor ena Maria, ma rsakitil ode rou ti naman desy. Maktei bonyo iry desikre rlakat wait batbatak a rasosan malolitare ti nekre, ma ral blyawan kunkuny o, kemenyan o, mur, ma ral ti naman desy. ");
INSERT INTO slu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ode kyoat a iry desikre rulak sir, desikeo lema rbai Yerusalem ma rlosu naman desy wena imin tike ti raja Herodes, de rosy sal salik ma rbai hnuat. Kali kyoat lenla rabetik toha Betlehem bonyo, metdyetke rmey o Hulasokwe byu eta sir, ma kete rba ti rlosu naman desy wena imin tike, ti raja Herodes. ");
INSERT INTO slu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kyoat iry a majus desikre rulak sir ma raba bonyo, Yusuf myey ohe, Hulasokwe wasi nyaso manosy laitke mya ma syusu tenanke ti i ma byohe, “Mbwatar ma mal naman desy yor ena, ode mila mbyai Mesir ti mimin ti aduk. Nini kolnye klwosu ti e ma myulak e, desikeo nenmo bisa ma myulak e. Kali Herodes yobak ma tyabahunw naman desy.” ");
INSERT INTO slu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dendye sewah desike Yusuf byatar elik, ma yal naman desy yor ena ma ra-la rbai Mesir. ");
INSERT INTO slu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ode ana ramin ti Mesir nini raja Herodes a myaty, desyo nenmo rbetik toha Mesir. Ktela nekre mumu ne kdi ti, ma kola tun Hulasokwe wasi manety nyanoare rakesy ti wait kitabare ne, ti kibohe, “Kabuk Anakkwe ma byetik toha Mesir.” ");
INSERT INTO slu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kyoat a sekwe enai ne kyelak eta bonyo, raja Herodes nenmo hye ohe, iry a majus desikre lema rtoha nam itanukare, dendye kyeyer a ksyalik. Lemade yal haretke ti wasi suldatare, ma rbai Betlehem, ktyabal nus o hnu mamin ti Betlehemke kseri desikre mumu, ma ti rtabahunw a naman wamwany a nenmo wait ainare raru ne, ma ti kyal naman wamwany a nenmo radur ti sir nekre, ma bisa ma Yesuske rtabahunw a I dakun. Yala koldyesy, kali yaki seure de, ma hye Yesuske wasi sew o hul o ain neke karyarike de. Neke yaki seure kyala kyosy a iry a majus desikre ralosu sew a Mesiaske wasi ftunke ibetik a kmunake ne, ma ti kyait sew a majus desikre ranal a ror Herodes ne. ");
INSERT INTO slu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ktela raja Herodes iala desy, neke ktyoha Yeremia manety Hulasokwe wasi nyano desy ti ikesy ma kibohe, ");
INSERT INTO slu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ana rtomolu serserke kyosy a hnu Ramake, neke kyety ral matol a ksyalik. Neke Rahel ebnwo anan nekre ana rser a anatare, kali anatare rmaty mumu de. Ode lema rou ma irire rma ma raluka sir.” ");
INSERT INTO slu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kyoat a Herodes myaty, desyo Yusuf a ramin ti Mesir a nggora. Ode ti desike Yusuf a myey o Hulasokwe wasi nyaso manosy laitke mya ma syusu tenanke ti i, ma tyanuk ti i de byohe, ");
INSERT INTO slu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yusuf o, mbwatar! Ode mal naman desy yor ena, ode myulak e bai negara Israelke, kali iry a maobak ma matabahunw a naman desike myaty de.” ");
INSERT INTO slu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lemade Yusuf byatar, ode yal naman desike yor ena ma rulak sir bai negara Israelke. ");
INSERT INTO slu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Keskyede kyoat Yusuf ranait Israel bonyo, tyomolu ohe, Arkhelaus ika raja ti propinsi Yudeake ma yeluk a ama Herodes. Lemade Yusuf imtaut ma byai propinsi Yudeake. Dendye nyaso manosy laitke syusu tenanke ti Yusuf huruk, kyoat a yenaf ma myey ohe, nyaso desike tyanuk ti i ma byohe, “Kete mbyai propinsi Yudeake, de mbyai propinsi Galileake bo.” Dendye Yusuf rbai propinsi Galileake. ");
INSERT INTO slu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kyoat Yusuf a ranait propinsi Galileake bonyo, rbai hnuke it ma kani a Nazaret, ma ramin ti. Ktela desike kdi ti, ma ktyoha iry a manety Hulasokwe wasi nyanoare rakesy ti wait kitabare ne, ma kbyohe, “I neke iry a Nazaret a I.” ");
INSERT INTO slu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ode kyoat Yesuske lan a I de, desikeo Yohanes Mababtiske byai wen malosy-loskye ti propinsi Yudeake, ma nenmo yabrita Hulasokwe tunanare ti desy. Ti desike yatela ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mtyunik wasimy lim o sal ba, kali Hulasokwe ima ma ihareta kola Rajake ne kyarasy de!” ");
INSERT INTO slu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ode Yohanes Mababtis neke i ne, Yesaya manety Hulasokwe wasi nyanoke ikesy ti wasi kitabke ma kbyohe, “Irkye it a yatela ti wen malosy-loskye ma byohe, ‘Msyoli salke! Ode myaklol ma mlol, ma kikita ity Ebutke!’” ");
INSERT INTO slu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes neke hyonak rabit narnarw a ratenkwe, neke ral toha untake husike, ode wasi kosarke rala toha heal a iblutare, ode kotw inanare neke larihke ktyabal maduke. ");
INSERT INTO slu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dendye iry ribun mamin ti nus Yerusalemke, ror iry ribun mamin ti propinsi Yudeake ktem desy mumu, neke rtabal iry ribun manosy nus o hnu mamin sah Yordanke kseri desikre mumu dakun, neke rma ma rseak a Yohanes, ");
INSERT INTO slu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ma rlosu wait lim o sal ti i. Maktei o, Yohanes byabtis a sir ti sah Yordanke. ");
INSERT INTO slu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Keskyede kyoat yatos iry ribun manosy a lui Farisi-nare, ror iry manosy lui Saduki-nare, ma rma ma byabtis a sir, desikeo tyanuk ti sir de byohe, “Hei iry ribun mahatw maola ni e! Esei ne ibu ti e ma mila mmyai ne ne de? Ma masunw manosy Hulasokwe ana kima o lema kena e ne de? ");
INSERT INTO slu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lemade kolnye mbyuma mlyakut ti sal a mlakye, musti mo mtyunik totnyo yabimy atyat miala desikre ba, ode myala eraske bo. ");
INSERT INTO slu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ode kete mryekan ti ralamy kralanare ohe, ana Hulasokwe lema yukun e, kali ebnwo matrumamy Abraham. Lema koldyesy! Kali kolnye Hulasokwe you ma yala hatw nekre ma ktyoy a iry, ma iry desikre Abraham tesnwo natu sir, desikeo ana kidi tike bo. ");
INSERT INTO slu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dendye mnyenas! Hroke kimin de, ma ral ma ruly aw a kisinare lema eras desikre ba, ma ti kyal a rhuty kawanare ba dakun, ode rotuk kiktemtem mumu ei akye kralake. ");
INSERT INTO slu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ode yaw neke kbwabtis e a kyor werke, ma kyabetar iblumire bo. Klala Iry a ana mama neke, ana byabtis e a kyor Hulasokwe Memeanke ktyabal akye, ma ksyukar ei ralami kralanare, ma kyarya ti ralamire. Iry a ana mama neke lan lahuk I ma byilak yaw, ma yaw neke lema kbwer o ktwahal ma kaka wasi dori-na ktasinare dakun. ");
INSERT INTO slu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ode Iry neke yola dene iry a manal a klyehkye ma itaik alyakwe ma nelnyely ne. Maktei o yal alyakwe kisi desy ma syosan ti sey nuskwe, klala kuhlanke yotuk bai akye kralake, neke ay a lema mamaty khyeke, de ay a mamorif nini nam.” ");
INSERT INTO slu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ode kyoat desy dakun o Yesuske yosy propinsi Galileake, ma byai sah Yordanke, ma Yohanes byabtis a I. ");
INSERT INTO slu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Keskyede Yohanes lema byuma byabtis Yesuske, de tyanuk ti Yesuske ma byohe, “Oi neke musti mo mbwabtis a yaw, de lema bisa ma kbwabtis a O. De kyanmwane mubuma kubabtis O ne de?” ");
INSERT INTO slu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dendye Yesuske hyalas Yohanes ma byohe, “Lemamo ktela neke musti mo kdi ti, ma ktyoha nam Hulasokwe itanukare.” Lemade Yohanes tyoha ma byabtis Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kyoat Yohanes ibabtis Yesuske maktei, ode Yesuske imdiry bonyo, laitke kimlakat, ode yatos manu hahkye ma yorw toha laitke ma mya ma tyuny a Yesuske, ma klyosu ohe, Hulasokwe Memeanke kyorw ti Yesuske de. ");
INSERT INTO slu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ode Hulasokwe telake kbyetik kyosy laitke ma kbyohe, “I neke Anakw a I, ma klwobak a I, ode kou I ti ralakkwe.” ");
INSERT INTO slu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Maktei o Hulasokwe Memeanke kyeuk Yesuske ma byai wen malosy-loskye, ma ngkeskwaure wait uskwe khatuke ana hyury a I ti wen desy. ");
INSERT INTO slu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ode ti wen desike, Yesuske yas sekwe hean at. Ma khyury ma imlar a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dendye ngkeskwaure wait uskwe khatuke mya ma tyanuk ti I de byohe, “Kolnye Hulasokwe Anan a O, desikemo maso hatw ne ma ktyoy a kotw.” ");
INSERT INTO slu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Keskye Yesuske tyanuk ti i ma byohe, “Rkesy ti Kitab Lanke de, ma irkye imorif ne lema khyali kotkwebo, de irkye imorif ne khyali Hulasokwe tunanare.” ");
INSERT INTO slu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Maktei o ngkeskwaure wait uskwe khatu desike yal Yesuske, ma yor I bai Nus Nelnyelkye, neke nus Yerusalemke, ma ramdiry ti Hulasokwe Seike wasi embuhkwe, ");
INSERT INTO slu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ode tyanuk ti I de byohe, “Kolnye Hulasokwe Anan a O, desikemo mnwusuk a mosy ne ei hahke nde! Kali rkesy ti Kitab Lanke de, ma kbyohe, ‘Khyali O, dendye Hulasokwe yal haretke ti wasi nyaso manosy laitare, ma ana rma ma rkoal eta O. Ode ana ral simatare ma ratak a O, ma kete lwaumure kena hature.’” ");
INSERT INTO slu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Keskyede Yesuske tyanuk ti i ma byohe, “Rkesy ti Kitab Lanke dakun de, ma irkye kete hyury a Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Maktei o ngkeskwaure wait uskwe khatu desike yor Yesuske bai wen atatke it, ode syusu mait nus o hnu mamin ti nuske ktem ne mumu, ktyabal nam eras mamin ti krala nekre mumu ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Maktei o tyanuk ti I de byohe, “Nam ribun-ribun nekre mumu ne ana kal ti O ma wasimw, kolnye mswakitil ode mou ma yaw.” ");
INSERT INTO slu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Keskyede Yesuske tyanuk ti i ma byohe, “Maditi lakhidik o toha ne! Kali rkesy ti Kitab Lanke de, ma musti mo irkye syakitil ode you ti Hulasokwe, ode cuma mo syambayan ti I a myesan bo.” ");
INSERT INTO slu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Maktei o ngkeskwaure wait uskwe khatuke lyoin toha Yesuske. Kyoat iloin toha Yesuske bonyo, Hulasokwe wasi nyaso manosy laitare rma ma rsaluk Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ode kyoat Yesuske tyomolu o Yohanes a rkumak i ma rluk i ei sey metmetke kralake bonyo, Yesuske yulak i bai propinsi Galileake, ");
INSERT INTO slu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ma imin ti hnu Nazaretke. Dendye byetik toha hnu Nazaretke, ma bya ti imin ti hnu Kapernaumke. Hnu Kapernaum neke kimin o Tasi Kakan Galileake kserike, ti lasmyer a heitlulswo Israel anan a Zebulon ode Naftali neke wait lasmyerare. ");
INSERT INTO slu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesuske iba ti de iba ma ti lasmyer desikre ne, neke ksyusu ohe nam Yesaya ikesy ti wasi kitabke ne kdi ti de. Nam Yesaya ikesy neke kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lasmyer a Zebulonke, ode lasmyer a Naftalike, kimin ti Tasi Kakan Galileake kserike, ti sah Yordanke kseri haratke. Ode ti lasmyer desikre dakun o, iry a lema Yahudi-nare ribun ramin ti. ");
INSERT INTO slu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ma iry mamorif ti lasmyer desikre, neke lulswoke rmorif ti kelerakokke, keskyede senweke nenmo rmatakit madelaf lan ne. Ode madelaf desike ksyusu salke ti iry a mamin ti kelerakok desikre.” ");
INSERT INTO slu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kyoat desike Yesuske nenmo yabrita ti irire ma byohe, “Mtyunik wasimy lim o sal ba, kali sew a Hulasokwe ima ma ihareta kola Rajake ne kyarasy de!” ");
INSERT INTO slu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ode sekwe it bonyo, Yesuske lyakut ti Tasi Kakan Galileake kserike, desikeo yatos Simon a raabuk i o Petrus ne, neke yor wai Andreas, ma malmata rtunik wait darkye ti tasi kakan desy, kali sir neke iry maka tasi sir. ");
INSERT INTO slu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lemade Yesuske tyanuk ti sir ma byohe, “Mmya ma mtyoha Yaw. Kali ana kajar e ma midary a iry, ma iry midary desikre rtoha Yaw.” ");
INSERT INTO slu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lemadendye rtutuk elik wait darire, ode rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Maktei o Yesuske yor deruke rlakut tebikan bai lulkwe, ma lema soso bonyo Yesuske yatos Yakobus yor wai Yohanes, neke Zebedeus ananare, ma malmata ror amatke rasosan wait darire ti aroke kralake. Lemade Yesuske yabuk Yakobus yor Yohanes ma rtoha I. ");
INSERT INTO slu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dendye deruke rorw elik toha aroke, ode rtutuk amatke ti desy, ma rba ti rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Lemade Yesuske yor matoha I desikre rlakut a rlola nus o hnu mamin ti propinsi Galileake ktem desy mumu, ma ti Yesuske yajar a irire ti sey rasambayan tiare, ode yabrita Brit Eraske ti kihali Hulasokwe ihareta kola Rajake ne. Ode nyoha iry a klurukare wait kbai sai ta sai bo, ma eras a sir. Ode yala iry a maluh maoly kabei ta kabei bo, ma malkyakaw a sir. ");
INSERT INTO slu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Dendye ktela Yesuske iala desike kimelir ti nus o hnu mamin ti Siriake ktem desy mumu. Dendye khyury ma irire ribun a ror wait iry a klurukare, ode iry a mablukutare, ode iry a ngkeskwaure rasukar sirare, rtabal iry a mahukatare dakun, ma ror sir ti Yesuske. Dendye Yesuske nyoha iry desikre wait kbainare ma eras sir mumu. ");
INSERT INTO slu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ktela Yesuske iala desikre khyury ma iry ribunke lui-lui sir ma rtoha I. Neke dum a rosy a propinsi Galileake, ode dum a rosy a lasmyer Dekapoliske, ode dum a rosy a nus Yerusalemke, ode dum a rosy a propinsi Yudeake, ode dum a rosy a lasmyer mamin ti sah Yordanke kseri timurke dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kyoat Yesuske yatos iry ribunke ma rtoha I bonyo, syaik ei kususwanke ma tyaklulw ti. Ode kyoat itaklulw bonyo, wasi matoha Iare rma ma rait a I ti desy. ");
INSERT INTO slu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lemade yajar wasi matoha I desikre ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Eraske kimin ti iry a rahe tenatare o lema rber o rtahal ti Hulasokwe ne, kali sir desike Hulasokwe wasi iry a sir de, ode sir desike iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare de. ");
INSERT INTO slu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Eraske kimin ti iry a ral matolare, kali sir desike ana Hulasokwe yaluka sir. ");
INSERT INTO slu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Eraske kimin ti iry a manauk tenatare ma babaf ne, kali sir desike ana Hulasokwe yal lasmyerke khaha harharkwe mumu ti sir. ");
INSERT INTO slu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Eraske kimin ti iry a madakin a ksyalik ma nam Hulasokwe ibuare kidi ti ne, kali ana nam Hulasokwe ibuare mausw ti sir. ");
INSERT INTO slu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Eraske kimin ti iry a rasusu ralat eras ti iry salik ne, kali ana Hulasokwe syusu rala eraske ti sir dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Eraske kimin ti iry a ral nelnyelire, kali sir desike ana ratos Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Eraske kimin ti iry a madakin ma raka eras ror iry salik, ode raka eras irire dakun ne, kali ana irire rbohe sir desike Hulasokwe anan a sir. ");
INSERT INTO slu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Eraske kimin ti iry a raoban de rataba sir ti khyali ramorif mo mlay a sir ti Hulasokwe ne, kali sir desike Hulasokwe wasi iry a sir de, ode sir desike iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne de. ");
INSERT INTO slu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ode eraske kimin ti iry a rahmway sir ne, ti khyali ratoha Yaw ne. Ode eraske kimin ti iry a raoban de rataba sir ne, ti khyali ratoha Yaw ne. Ode eraske kimin ti iry a rahes sir ma anitare kiray dakun ne, ti khyali ratoha Yaw ne. ");
INSERT INTO slu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lemadendye kolnye ktela desikre kdi ti ti e, desikemo mimukmuka mimarmara e bo. Kali ana myal ksewanke ti wen sra eras Hulasokwe imin tike, desikeo lan a ksyalik. Mnyenas! Ti heitlulswoke iry manety Hulasokwe wasi nyanoare, irire roban de rtaba sir koldyesy dakun.” ");
INSERT INTO slu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesuske tyanuk huruk ma byohe, “Ei neke myola taisiskye ti iry mamin ti nuske ktem ne. Ode taisisy ne eras, keskyede kolnye taisisy ne malmyaly, desyo ana rala taisisy malmyaly desy kolkyabei ma mkes huruk de? Koldyesikemo taisisy malmyaly desy lema kika kbuan de, dendye rbisak ba bo, ma irire rsosno rtabak. ");
INSERT INTO slu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ei neke myola damarke ma mdyelaf nuske ktem ne. Ode ei neke dakun o myola nus mamin ti huarke khahake, ma nus desike lema bisa ma kihunik i, de irire mumu ne bisa ma ratos. ");
INSERT INTO slu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Koldyesy dakun ti damarke, kali lema rtunw damarke, ode ral ti lkuskye kralake ma rkahat eta. De musti mo ral damar desy ei wen atatke it, ma bisa ma kdyelaf irire mumu ti sekye kralake. ");
INSERT INTO slu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kola ne e dakun, ma wasimy mormyorifke musti mo eras ma irire ratos, ma wasimy mormyorif eras desike kyeluk madelafke, ma kdyelaf iry mamin ti kelerakokke. Desike ne khyury ma irire mumu ne ana rleru Amamy mamin ti wen sra eraske.” ");
INSERT INTO slu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dendye Yesuske tyanuk ma byohe, “Kete mryekan o kuma neke kmwa ma kswos a tnyetak Musake ode nam a nyasoare rakesire ba. Lema! De kuma neke kmwa ma kaktemak tnyetak desike kbuanare. ");
INSERT INTO slu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dendye mtyomolu mamak nam kutanuk ne! Biar ma lasmyerke khaha neke ana klyodur, ode laitke ana lema kimin dakun de, keskye Musa wasi tnyetakke ana lema tebikan kitayar dakun, kolnye Hulasokwe lenla yala nam desikre mumu ma kdi ti. ");
INSERT INTO slu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lemadendye esei desike lema tyoha tnyetak desike sasam bo, biar ma ryekan o tnyetak desike kakan dakun, ode yajar irire ma lema rtoha tnyetak desy, desikeo ana rbohe kakan i ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare. Klala esei desike tyoha tnyetak Musa desikre, ode yajar irire ma rtoha tnyetak desikre dakun, desikeo ana rbohe lan i ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare. ");
INSERT INTO slu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dendye mnyenas tun kutanuk ne: Musti mo mimorif ne wasimy mormyorifare eras, ode mlay ma kbyilak iry a mahe snurat o tnyetak Musake, ror iry a manosy lui Farisike. Kali kolnye lema mmyorif koldyesy, desikemo Hulasokwe lema wasi iry a e. Kali Hulasokwe wasi irire sir ne, iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne.” ");
INSERT INTO slu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Lemade Yesuske tyanuk ma byohe, “Ei neke mhye nam rakesy ti ity ebnwo matrumat ne de, ma kibohe, ‘Kete mtyabahunw iry, kali kolnye esei desike tyabahunw iry, desikeo musti mo ana rukun a i.’ ");
INSERT INTO slu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Klala ktwanuk ti e ohe, esei desike kyeyer a wai o hatnima, desikeo i desike ana Hulasokwe yukun i. Ode esei desike ikanak irire, desikeo i desike ana ror i ba ti Maukun Tunare, ma rukun a i. Ode esei desike isoba iry, desikeo ana rotuk i bai mamaty rala, neke wen a ay malehur manal nini nam tike. ");
INSERT INTO slu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lemadendye ti ei ne, kolnye mety a nam muabarke ti Hulasokwe, keskye mnwenas ohe, irkye it a ralake ksunw o a nggora, ");
INSERT INTO slu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","desyo musti mo mtwutuk nam muabar desy, ma mulak o ma ti muka eras mor iry desy aduk, maktei o nenmo bisa ma mety nam muabar desy ma ti mabar ti Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ode kolnye iry dum a rreky ma ti rmanadu e ti iry a maukun tunare, desyo musti mo adoko mbya ti mika eras myor sir aduk, kyoat lenla rba ti rmanadu e. Kali kolnye lema mika eras myor sir, desikeo ana ror e bai iry maukun tunare, maktei bonyo iry maukun tunare ror e bai suldatare, ma suldatare rluk e ti sey metmetke kralake. ");
INSERT INTO slu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lemadendye mtyomolu mamak nam kutanuk ne! Ana lema mbyetik toha sey metmetke krala desy, nini msyelw a salamy desikre ma ktei, desyo nenmo mbyetik.” ");
INSERT INTO slu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Maktei o Yesuske tyanuk ma byohe, “Ei ne mhye tnyetak Musake, ti kibohe, ‘Kete taldotw.’ ");
INSERT INTO slu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Keskyede ktwabal ma ktwanuk ti e ohe, esei desike yatos wamfwetke it, ode dyakin i, desikeo iry desike ralake kralake kyaldotw ma desy. ");
INSERT INTO slu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ode kolnye matamkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mhwakilw matamkwe khatu desy ba! Kali kolnye mmworif ti wen a Hulasokwe ihareta tike mor matamkwe serit, desike ne eras a ksyalik ma kbyilak ti kolnye mmworif mor matamw deru desy, keskyede ana rotuk o bai wen ay malehur manal nini namke kralake. ");
INSERT INTO slu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ode kolnye simamkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mal turike ma mtwusy ohut simamw desy ba! Kali kolnye mmworif ti wen sra eraske nini nam a mor simamkwe serit, desike ne eras a ksyalik ma kbyilak ti kolnye mbwuma mmworif mor simamw deru desy, keskyede ana rotuk o bai wen ay malehur manal nini namke kralake.” ");
INSERT INTO slu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Lemade Yesuske tyanuk ma byohe, “Ei ne mhye tnyetak Musake, ti kibohe, ‘Esei desike ibrai sawa, desikemo musti mo kyesy atyahy a it de ibrai it ne ma yal ti sawa.’ ");
INSERT INTO slu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Keskyede ktwanuk ti e ohe, kolnye wamwankye it a byuma ibrai sawa, desike mlay kolnye sawa-na yaldotw. Keskye kolnye sawa-na lema yaldotw, de lai-na byuma ibrai i bo, desikeo lai desike hyury ma sawa-na yaldotw ma desy, kolnye sawa desike isaa yor wamwany salik. Ode kolnye wamwankye it a isa yor wamfwet a lai-na ibrai i desy, desikeo wamwany desike yaldotw dakun.” ");
INSERT INTO slu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesuske tyanuk ti iry desikre huruk ma byohe, “Ei ne mhye ohe, heit a ity ebnwo matrumat nekre rtoha tnyetak Musake ti kibohe, ‘Kolnye myal Hulasokwe Anike ma mihwab de, desikemo kete mila toha wasimy inahwab desy, de musti mo mtyoha wasimy inahwab desy.’ ");
INSERT INTO slu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Keskyede klwosu ti e ohe, kete myal laitke ma myal ma mihwab dakun, kali lait neke wen a Hulasokwe itaklulw ti ma iharetake. ");
INSERT INTO slu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ode kete myal lasmyerke ma mihwab dakun, kali lasmyer neke wen Hulasokwe isaa lwau tike. Ode kete myal a nus Yerusalemke ma mihwab dakun, kali Yerusalem neke nus a Raja Lan Lahukke imin tike. ");
INSERT INTO slu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ode kete myal usumy khatunare ma mihwab dakun, kali lema wasimy haretke ma myala hukamire ma bokbok, ode lema wasimy haretke ma myala hukamire ma metmet dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De kolnye nam sai desike ‘mlay,’ desikemo mbyohe, ‘Mlay.’ Dete kolnye nam desike ‘sal,’ desikemo mbyohe, ‘Sal.’ Klala kete kbyilak lan o mihwab, kali inahwabke kyosy a ngkeskwaure wait uskwe khatuke.” ");
INSERT INTO slu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesuske tyanuk ti sir huruk ma byohe, “Ei neke mhye ohe, tnyetak Musake kbyohe, ‘Esei desike tyabahunw iry, ana rtabahunw i dakun, ode esei desike yala iry salik ma imnu, ana rala i ma imnu dakun.’ ");
INSERT INTO slu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Keskyede ktwabal ma ktwanuk ti e ohe, kolnye irire roban e, desikemo kete myoil ma myoban sir. Ode kolnye irkye it a kyohw manyamkwe serit, desikemo mtwiri seridake ti kyohw dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ode kolnye irkye it a bya ti myanadu o ti maukun tunare, kali dyakin wasimw rabit muhonak desy, desikemo mal ti i, ode mal a ktyabal wasimw rabit narnarw bokbokke ti i dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ode kolnye irkye it a pyaksa o ma mhwar wasi nam dum, ma miktem a mlyakut ma kasonanke lalwakwe ribunke sasam (1000m), desikeo mou ma mlwakut mor i, ma kasonanke lalwakwe ribunke enaru (2000m). ");
INSERT INTO slu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ode kolnye irire raten nam toha o, desikeo mal ti sir. Ode kolnye dum a rutan nam toha o, desikeo kete makal ma mbwohe, ‘Lema kimin.’” ");
INSERT INTO slu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesuske tyanuk ma byohe, “Ei neke mhye ohe, tnyetak Musake kbyohe, ‘Musti mo mlyobak wasimy irire,’ klala mimnisik iry a maala tot atyat ti e nekre. ");
INSERT INTO slu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Keskyede ktwabal ma ktwanuk ti e ohe, musti mo mlyobak iry a mamnisik eare! Ode msyambayan ti iry a maoban de mataba e nekre! ");
INSERT INTO slu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kali kolnye myala koldyesy, desikeo irire ana rtanuk ma rbohe, ‘Ei neke Hulasokwe anan a e.’ Kali Hulasokwe yala sekwe ma ryan iry a maala ktela erasare, ode ti iry a maala ktela atyatare dakun. Ode Hulasokwe nyauk uske ti iry a maala ktela erasare, ode ti iry a maala ktela atyatare dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dendye kolnye mlyobak iry a malobak eare bo, desikemo kete mryekan o ana Hulasokwe yal ksewanke ti e. Kali iry maily usure biar ma rahatw, keskyede rlobak iry a malobak sirare dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ode kolnye myala eras iry a maala eras eare bo, desikemo kete mryekan o ana Hulasokwe yal ksewanke ti e. Kali iry a lema mahe Hulasokwe ne, rala koldyesy dakun. ");
INSERT INTO slu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Khyali desy mane mimorif neke musti mo myala eras irire mumu, kola ne Amamy mamin ti wen sra eraske iala eras irire mumu dakun ne.” ");
INSERT INTO slu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesuske tyanuk ma byohe, “Mnyenas! Musti mo myala ktela erasare. Keskye kete myala ktela eras desikre ti ribunke khahake ma irire ratos. Kali kolnye myala koldyesy, desikemo kete mhyarap o Amamy mamin ti wen sra eraske ana yal ksewanke ti e. ");
INSERT INTO slu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lemade kolnye mbyuma myal nam ti iry a lema manait ei sra o hahare, desikeo kete mihes ti ribunke khahake, kola dene iry a makakmet ma maala tenatare ma mlay ne, keskye ti ralat a kralanare ne lema mlay. Kali iry a ralat a lema mlay desikre, kolnye rbuma ral nam dum ti iry a lema manait ei sra o hahare, ti sey rasambayan tiare, dete lemamo ti sal a krala, desikeo rohw a strompetke, ode ratelat ma rlosu nam raala desikre, ma khyury ma irire ratos mamode rleru sir. Dendye mtyomolu mamak nam kutanuk ti e ne! Iry maala ktela maoly desikre, ana Hulasokwe lema yal ksewanke ti sir, de irire raleru sir desy, desike ne ksewan ratotke desy de. ");
INSERT INTO slu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Keskyede kolnye myal nam ti iry a lema manait ei sra o hah nekre, desikemo mihunik ma kete kika iry mahe. Kola ne simamw wanke kyal nam ti irire, desikemo simamw wisalke kete khye. ");
INSERT INTO slu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dendye kolnye myal nam ti iry a lema manait ei sra o hahare, desikemo mihunik ma kete irire rhe, mamode Amamy mahe nam mahunik i nekre mumu ne, ana yal ksewanke ti e.” ");
INSERT INTO slu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesuske tyanuk ma byohe, “Kolnye msyambayan mo kete msyambayan kola iry a makakmet ma maala tenatare ma mlay ne, keskye ti ralat a kralanare ne lema mlay. Kali iry desikre rdakin ma rsambayan ti sey a rasambayan tiare, ode ti sal a kralanare, ma irire ratos sir ma rleru sir. Dendye mtyomolu mamak nam kutanuk ne! Iry maoly desikre ana Hulasokwe lema yal ksewanke ti sir, de irire raleru sir desy, desike ne ksewan ratotke desy de. ");
INSERT INTO slu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lemade kolnye mbyuma msyambayan, desikemo msyukar ei kamarke, ode mhyolat eta holholatke, mamode msyambayan ti Amamy a lema mimatakit I ne. Kali Amamkye yatos nam miala ma kihunik i ne, desikeo ana yal ksewanke ti e. ");
INSERT INTO slu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ode kolnye msyambayan, desikemo kete narnarw, ode kete myoly de myoly tunamire, kola iry a lema mahe Hulasokwe ne. Kali rrekan o kyor wait sambayan narnarw desy, ana Hulasokwe hyalas wait sambayan desikre. ");
INSERT INTO slu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dendye kete msyambayan kola iry desikre, kali kolnye lenla msyambayan ma miten nam dum toha Amamkye, desikeo Amamkye hye a kmuna nam ana mitenare de. ");
INSERT INTO slu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lemadendye msyambayan mo msyambayan kolnye: ‘Oo, ara Amamy a mamin ti wen a sra eras so, aramy miten ma aramy mumu ti lasmyerke khaha ne myalan a O, kali Animkwe nelnyely. ");
INSERT INTO slu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ode aramy miten ma mmwa kola Rajake, ma mhwareta aramy mumu, ma nam sai mtwanuk, desikeo iry mamin ti lasmyerke khaha neke rtoha, kola dene irire ratomolu O ti wen a sra eras mumin tike. ");
INSERT INTO slu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ode aramy miten toha O ma senweke, mal kotw o abw ma kyoat mamak aramy. ");
INSERT INTO slu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ode mswos ara salamire ba, kola dene, aramy misos iry maka salat ma aramy ne dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ode kete mlwura aramy ma nam dum a khyury aramy ma kyor aramy ei atyatke, de aramy miten toha O ma, maditi aramy toha ktela atyat desikre mumu. Kali Oi ne lan a O, ode mkwumak haretke, ode wasimw madelafke kyal nini nam ti kiba knaru ne. Amin.’ ");
INSERT INTO slu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kali kolnye msyos iry maka salat ti eare, desikemo Amamy mamin wen sra eraske ana syos salamire ba dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Keskye kolnye lema msyos iry maka salat ti eare, desikemo Amamy mamin ti wen sra eraske dakun o ana lema syos salamire ba.” ");
INSERT INTO slu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesuske tyanuk ma byohe, “Kolnye myas ma miten nam dum toha Hulasokwe, desikemo kete myala matamire ma kimet-kiray ode lolyolyoi, ode kete myala hukamire ma ktyambalin a i dakun, kola iry a makakmet ma maala tenatare ma mlay ne, keskye ti ralat a kralanare ne lema mlay. Kali iry a raas ode raala koldyesy ne, neke rala koldyesy ma irire ratos sir, ma rbohe, ‘Iry desikre nelnyely a sir, kali malmata ras.’ Keskyede mtyomolu mamak nam kutanuk ti e ne! Iry maoly desikre ana Hulasokwe lema yal ksewanke ti sir, de irire raleru sir desy, desike ne ksewan ratotke desy de. ");
INSERT INTO slu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Keskyede kolnye myas, desikemo miris ma nelnyely a e, ode mkyar hukamire dakun, ");
INSERT INTO slu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ma kete irire rhe ohe, ei neke malmata myas, de Amamy a iatos nam miala ma kihunik i ne, myesan a hye ohe ei ne myas bo. Dendye ana yal ksewanke ti e.” ");
INSERT INTO slu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesuske tyanuk huruk ma byohe, “Kete msyosan wasimy malolire ti lasmyerke khaha ne, kali ana dedire rteta, ode kikarmwain i ma atyat, ode manametare rma ma ranamet. ");
INSERT INTO slu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","De musti mo msyosan wasimy malolire ti wen sra eraske, kali ana ti soke dedire lema rteta, ode lema kikarmwain i, ode manametare lema rma ma ranamet dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kali kolnye malolimire kimin ti wen kabei desy, desikeo ralamy kralanare kimin ti wen desy dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kola ne ity matat nekre ma kyeluk damar ti ity tenatare, ma kolnye ity matat nekre kdyelah ma tmatakit, desikemo ana ity tenat nekre knyely, ode kdyelaf dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Keskye kolnye ity matat nekre ahwahw, desikemo ana ity tenat nekre kelerkok dakun. Dendye kolnye madelaf mamin ti ity tenat nekre kyulak i ma kelerkok, desikemo ana ity tenat nekre lema khye kiba sara. ");
INSERT INTO slu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Lema bisa ma irkye it a kyarya ti lalanke enaru, kali ana koldyesy, desikemo ana imnisik it, ode dyakin it, dete lemamo ana tyomolu it, ode lema tyomolu it. Kola dene e dakun, ma kolnye mbyuma mkyarya ti Hulasokwe, desikemo kete mryekan ti malolkye de.” ");
INSERT INTO slu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Dendye Yesuske tyanuk huruk ti wasi matoha Iare ma byohe, “Lemadendye ktwanuk ti e ma kete ralamire kakan ti mimorif ne ohe, ana kika kotw o abw ma mi ta lema. Koldyesy dakun o kete ralamire kakan ohe, ana kika simbol o rabit ma mhyonak ta lema. Kali mormyorif neke kbuanke kbyilak kotw o abw desikre, ode ity tenat nekre kika kbuan ma kbyilak simbol o rabit desikre dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ode myatos ti manunare bo. Lema rkay hinkye, ode lema ral kotu kisinare, ode lema raka wait sey nusw ma rsosan kotw ti dakun. Keskyede kyaki-kyaki ne raknam, kali Hulasokwe yal kotw ti sir. Kbyilak ti desy dakun o, Amamy mamin ti wen sra eraske syeak ti e dakun, kali ti Amamkye ne, ei ne myety alalan ma kbyilak manu desikre. ");
INSERT INTO slu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ti ei ne mumu neke, esei desike ralake kakan, desikemo kyanmwane ilura ma ralake kakan koldyesy ne de? Kali rala kakan desike lema bisa ma ktyabal jamke sasam ti wasi ainke, ma narnarw huruk ti imorif ei lulkwe ne. ");
INSERT INTO slu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ode kyanmwane ralamire kakan ti simbol o rabit ne de? Myatos a tnyei tubunamake khuna eras desy, ti kituhw ti boare ne, lema kkyarya namit-namit, ode lema kitenw tais a khye. ");
INSERT INTO slu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Keskye mtyomolu nam kutanuk ti e ne! Ti heitlulswo, raja Salomo iry maka maloly desike hyonak a i mo kersan ne a ksyalik, keskye lema eras ma kbyilak tnyei tubunamake khuna desike it dakun. ");
INSERT INTO slu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lemade tnyei mamin ti bo a krala nekre senwe kimin, ode bolbolke bonyo rotuk ei akye kralake. Keskye Hulasokwe syamur tnyei desikre ma eras. Kbyilak ti desy dakun o, Hulasokwe ana hyonak o ryabit e dakun! Keskyede lema mtyohak o Hulasokwe lyobak e ma kbyilak tnyei desikre, mane wasimy tohtohakke ti Hulasokwe ne tebikan bo! ");
INSERT INTO slu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lemade kete ralamire kakan ohe, ana mi o myenw sai, ode ana mhyonak sai. ");
INSERT INTO slu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kali nam desikre mumu neke, iry a lema mahe Hulasokwe ne, sir ne kyalamo rrekan ti nam desikre kmyesan bo. Keskyede Amamy mamin ti wen sra eraske hye nam matol ti e nekre mumu de. ");
INSERT INTO slu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lemadendye kyaki-kyaki ne mbyuma Hulasokwe hyareta kola Rajake ti ralamy kralanare a kmuna,ode mimorif ne mlay, desikemo ana Hulasokwe tyabal nam ribun salno salik matol ti e nekre mumu ti e. ");
INSERT INTO slu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lemadendye kete ralamire kakan ma mryekan ti bolbolke wasi masunkwe, de mryekan ti senweke wasi masunkwe bo. Kali masunkwe ti sew desy, desikeo kyoat ti sew desy bo.” ");
INSERT INTO slu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ode Yesuske tyanuk huruk ma byohe, “Kete myukun tun ti irkye, mamode Hulasokwe kete yukun tun ti e. ");
INSERT INTO slu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kali kolnye myukun tun ti irkye, ana Hulasokwe yukun tun ti e dakun. Ode lalwaw minal ma milaw ti irkye ne, ana Hulasokwe yal ma lyaw ti e dakun. ");
INSERT INTO slu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ode kolkyabei mane bisa ma mmwatakit akwe ksinsintan mamin ti waimw matake kralake, klala lema bisa ma mmwatakit balak malosik i ti matamkwe krala desy ne de? ");
INSERT INTO slu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ode kolkyabei mane bisa ma mtwanuk ti waimw de mbwohe, ‘Mmwa ma kaditi akwe ksinsintan mamin ti matamkwe krala desy ba.’ Ode kyanmwane lema bisa ma maditi balak malosik i ti matamkwe krala desy ne de? ");
INSERT INTO slu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hei, makakmet o! Oi ne mala tenamkwe ma mlay ti ribunke khahake, keskye ti ralamkwe kralake ne lema mlay elik! Dendye oi ne musti mo maditi balak mamin ti matamw desy ba aduk, mamode nenmo bisa ma mmwatakit kena akwe ksinsintan mamin ti waimw matake, ma bisa ma maditi ba.” ");
INSERT INTO slu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lemade Yesuske tyanuk huruk ma byohe, “Kete mal nam nelnyelire ti askwe, ode kete motuk hili nisitare ti hahkye.Kali ana asw o hahy desikre rsosno rtabak nam eras desikre bo, maktei o rulak sir ti rkuty a o.” ");
INSERT INTO slu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesuske tyanuk huruk ma byohe, “Miten, desikemo ana Hulasokwe yal ti e. Miobak, desikemo ana mitot. Mtyoky holholatke, desikemo ana Hulasokwe lyakat holholatke ti e. ");
INSERT INTO slu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kali iry a matenke mo, ana yal ti i. Iry a maobakke mo, ana itot. Ode iry a matokkye mo, holholatke ana kimlakat ti i. ");
INSERT INTO slu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Lemade ti ei ne mumu neke kolnye it a ananke iten rotkye toha i, desikemo yal hatkwe ti i e? ");
INSERT INTO slu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ta kolnye ananke iten maskye toha i, desikemo ana yal nike ti i e? Lema. ");
INSERT INTO slu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ode biar ma iry mahatw a e dakun, keskye kyalamo myal nam erasare ti anamire. Apalai Amamy mamin ti wen sra eraske ana yal nam erasare ti e, ma kbyilak nam eras a miala desikre dakun, neke yal nam erasare ti iry a maten toha Ike.” ");
INSERT INTO slu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Lemade kolnye mbyuma nam sai desike irire rala ti e, desikemo myala koldyesy ti irire a kmuna. Desike ne kibohe tnyetak Musake mumu, ode manety Hulasokwe wasi nyanoare wait kitabare mumu, neke kisike desy.” ");
INSERT INTO slu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Dendye Yesuske tyanuk huruk ma byohe, “Kolnye mbyuma msyukar ei wen sra eraske, desikemo msyukar myosy sal haha butbutke. Kali sal mabai matmyaty manal nini namke, neke wasi sal hahake helhela ode lan, ode irire ribun a rlakut rosy sal desy. ");
INSERT INTO slu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Klala sal mabai mormyorif eras manal nini namke, neke wasi sal hahake butbut ode kakan, ma biar ma irire ribun a robak, keskye irkye ru ta telw ratot bo. Ode ana ksunw ksyalik ma irire rlakut a rosy sal desy.” ");
INSERT INTO slu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Dendye Yesuske tyanuk huruk ma byohe, “Mijaga mamak a e toha iry a makakmet ma rabohe, sir ne ranety a Hulasokwe wasi nyanoare ne. Kali ana rma ma rait a e, desikeo rala tenatare ma kola dombake, keskyede lema mhye mo, sir desike rola asw utan mahatw nekre. ");
INSERT INTO slu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kali kolnye mbyuma mhye irkye, desikemo ana mhye toha totanare. Kali sitw o karkyary lema kisi anggurke, ode lema kisi aw arake kisike. ");
INSERT INTO slu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kola dene aw mamorif eraske, desikeo ana kisinare eras, klala aw mamorif atyatke, desikeo ana kisinare atyat dakun. ");
INSERT INTO slu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kali lema kika aw mamorif eras ma kisinare atyat, ode lema kika aw mamorif atyat ma kisinare eras. ");
INSERT INTO slu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dendye kolnye aw a maka kisike, keskye kisinare lema eras, desikemo ruly ba ma rotuk ei akye kralake, ma akye knya ma ktei. ");
INSERT INTO slu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kola iry a makakmet ma rabohe, sir ne ranety a Hulasokwe wasi nyanoare ne, desike ne ana bisa ma mhye sir toha totat raalanare.” ");
INSERT INTO slu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesuske tyanuk huruk ma byohe, “Kolnye mtyomolu irire ma rabuk Yaw o, ‘Amam Lan O! Amam Lan O!’ Desike ne kete mryekan ohe, sir desike mumu ne iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. Lema koldyesy! De iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne, neke cuma mo iry a matomolu ode matoha nam Amakw mamin ti wen sra eraske ibuke. ");
INSERT INTO slu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kali ana kyait sew a Hulasokwe iukun irkye bonyo, ana iry ribunke lema bisa rsukar, dendye rtanuk ma Yaw de rbohe, ‘Amam Lan O! Amam Lan O! De lema aramine kola minal Animkwe ma mtyanuk Hulasokwe wasi nyanoke ne e? Ode khyali Animkwe, desikeo aramy neke myesak ngkeskwaure, ode aramy myala ktela masalsyalik iare e?’ ");
INSERT INTO slu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Keskyede kyoat desike Yaw neke ana khwalas sir elik ma kbwohe, ‘Yaw neke lema khwe e! Myaditi e toha ne, kali ei neke lema mtyomolu ode lema mtyoha nam Hulasokwe itanukare.’” ");
INSERT INTO slu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuske tyanuk ma byohe, “Kolnye irire dum a rtomolu nam kutanukare, ode rtoha, desikemo rola dene iry a mahe tel ma masadiri sey ti hatkwe khahake ne. ");
INSERT INTO slu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma biar ma uske lan ma khyury ma weraunare knyaha, ode esumetkye ksiri wasi sey desy, keskyede sey desike ana lema klyily, kali rsadiri ti hatkwe khahake. ");
INSERT INTO slu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Klala iry matomolu nam kutanukare, ode lema rtoha, desikemo rola dene iry ktemke, ma syadiri wasi sekye ti laranke khaha ne bo. ");
INSERT INTO slu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ode kyait ma uske lan ma khyury ma weraunare knyaha, ode esumetkye ksiri wasi sey desy, desike bonyo wasi sey desike klyily ma kiskyui-kiskyay, kali syadiri ti laranke khahake bo, ma lema malkyakaw.” ");
INSERT INTO slu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kyoat iry ribunke ratomolu nam Yesuske iajarare bonyo, rheran a ksyalik, ");
INSERT INTO slu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kali Hulasokwe yal haretke ti I, ma tun iajar desikre kyety mdedan, de lema kola nam iry mahe snurat o tnyetak Musake raajarare. ");
INSERT INTO slu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kyoat Yesuske yoru yosy a kususwanke, desikeo irire ribun a lui-lui sir ma rtoha I. ");
INSERT INTO slu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Desikeo irkye it ma kbai mbaulke kbyenw tenanke, ma mya ma syakitil ode you ti Yesuske, ode tyanuk ma byohe, “Amo, kolnye mou mo, kuten ma maditi kbai ne ba toha yaw, ma tenakw ne nelnyely.” ");
INSERT INTO slu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lemadendye Yesuske yeta simake ti kyumak iry desy, ode tyanuk ma byohe, “Kou ma tenamkwe nelnyely.” Dendye kyala mait bonyo, iry desike wasi kbai mbaul desike kitayar elik. ");
INSERT INTO slu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lemadendye Yesuske tyanuk ti iry a mambaul desy ma byohe, “Mnwenas! Mbwa, ode kete muhes ktela ne ti irkye it dakun, de musti mo mtwoha haret Musake, neke ti mswusu tenamkwe ti iry mabaa klen ti irkye yor Hulasokwe ne, ma rhe o wasimw a mbaul desike kitayar de. Ode mety heal ana muabar ti Hulasokwe desy, ma mal ti sir, ma rhe bain-bain o eras a o de.” ");
INSERT INTO slu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kyoat Yesuske syukar ei hnu Kapernaumke, desikeo suldatare wait uskwe khatuke mya ma yait a Yesuske, ode yal ralake kralake bain-bain ma iten toha Yesuske ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Amo, wasikw makaryake it ma kluruk a i, ma idudur wena bo ti wasikw sekye, kali wasi kbaike mdedan a ksyalik, ma yety ti de yety ma ti masunw madan a ike.” ");
INSERT INTO slu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dendye Yesuske tyanuk ti uskwe khatu suldat desike ma byohe, “Desikemo ana kbwai wasimw sekye, ti knwoha wasimw makarya desike wasi kbaike ma eras a i.” ");
INSERT INTO slu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Keskyede suldatare wait uskwe khatu desike hyalas Yesuske ma byohe, “Amo, kete mbwai wasikw sekye, kali lema kbwer o ktwahal ma kal O ei wasikw sekye kralake. De kolkyabei mo mtwanuk tunke khatuke it ti ne, ma bisa ma wasikw makaryake eras a i bo. ");
INSERT INTO slu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kali yaw ne dakun o iry dum a rhareta yaw ma ktwoha sir. Ode khwareta suldat kakanare ma rtoha yaw dakun. Lemade kolnye ktwanuk ti suldat kakan ne it ma kbwohe, ‘Mbwa!’ Desyo bya. Ode ktwanuk ti it huruk ma kbwohe, ‘Mmwa!’ Desyo mya. Dete lemamo ktwanuk ti wasikw makaryake it de kbwohe, ‘Mkwarya nam ne!’ Desikeo kyarya.” ");
INSERT INTO slu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kyoat Yesuske itomolu nam suldatare wait uskwe khatu desike itanuk desy bonyo, hyeran a ksyalik. Dendye tyanuk ti iry a ribun matoha I desikre ma byohe, “Mtyomolu mamak nam kutanuk ne! Biar ma iry ne lema iry a Yahudi i, keskyede wasi tohtohakke malkyakaw ksyalik! Ti iry Yahudi-nare ne lenla ksweak irkye it ma wasi tohtohakke kolnye elik. ");
INSERT INTO slu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dendye klwosu ti e ohe, ana iry a lema Yahudi-nare ribun sir a rosy a kseri timur o harat ne, ma rma ma rtaklulw ma raknam ti kalkal inaknam lanke a ror Abraham, Ishak ode Yakub, ti wen Hulasokwe ihareta kola Rajake tike. ");
INSERT INTO slu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Keskye iry a Yahudi-nare ribun sir a ana rotuk sir ei wen a kelerakok a ksyalikke. Ode ti wen desike ana masunkwe kdyan sir, ode serserke lan ti. Kali Hulasokwe yabuk sir ma wasi iry a sir, neke iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne, ma rma ma raknam ti kalkal inaknam lan desy, keskye iry a Yahudi desikre rabrai rma.” ");
INSERT INTO slu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dendye Yesuske tyanuk ti suldatare wait uskwe khatu desy ma byohe, “Mulak a o, kali nam mubuke kdi ti de, ma ktyoha wasimw tohtohakke.” Kyoat desy dakun o uskwe khatu suldat desike wasi makaryake eras a i elik. ");
INSERT INTO slu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kyoat Yesuske syukar ei Petrus a wasi sekye bonyo, yatos o Petrus a ryana wamfwetke yenaf, kali kbai mrinke kena i. ");
INSERT INTO slu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lemadendye Yesuske kyumak enen desike simake bonyo, enen desike wasi kbai mrin desike kitayar elik. Dendye enen desike byatar, ode isosan kotw o abw ti Yesuske sir ma raknam. ");
INSERT INTO slu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ode kyala ma sewah bonyo, irire ror iry a isy masunure, ode iry a ngkeskwaure rasukar sirare ne, ma ror sir ti Yesuske. Dendye Yesuske tyanuk a tunke khatuke it, ma yal ma yesak ngkeskwaure ma rbetik toha iry desikre, ode yal ma nyoha iry a isy masunw desikre wait kbainare ma eras sir dakun. ");
INSERT INTO slu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesuske yala ktela desikre mumu ma kola Yesaya iry manety Hulasokwe wasi nyanoke, ti heitlulswo ikesy ti wasi kitabke ma kibohe, “I ne ihar a masunw madan a ity nekre, ode I ne inoha ity wait a kbainare ma eras ne.” ");
INSERT INTO slu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kyoat Yesuske yatos iry ribunke ma rkoal eta I, desike bonyo yaso wasi matoha Iare ma rasosan wait aroke, ma rala ma rbai tasi kakanke seridake. ");
INSERT INTO slu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Desike bonyo iry a mahe snurat o tnyetak Musake it a mya ma tyanuk ti Yesuske ma byohe, “Tuanggurw, kbwuma ktwoha O bai kabei ta kabei bo.” ");
INSERT INTO slu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Keskyede Yesuske tyanuk ti i ma byohe, “Asw a utan mata mnaske ika wena ma byob ti, ode manuke o ika nuka ma imin ti dakun, keskyede Irkye Anankelema ika wena ma imres ti, ode yenaf ti.” ");
INSERT INTO slu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ode Yesuske wasi matoha Ike it a tyanuk ti Yesuske ma byohe, “Amam Lan O, mlwura yaw ma kbwa ti kamlin amakw aduk, mamode nenmo kmwa ma ktwoha O.” ");
INSERT INTO slu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Keskyede Yesuske tyanuk ti i de byohe, “Mtwoha Yaw! Ode mlwura ma iry mamatire rmesan a ramlin iry mamatire bo.” ");
INSERT INTO slu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lemadendye Yesuske yor wasi matoha Iare rsai aroke ma rbity larke ti, ma rbai tasi kakanke seridake. ");
INSERT INTO slu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ode kyoat raba bonyo, Yesuske yenah ti aroke kralake. Ode kyala mait bonyo eskwe mety ksyalik ti tasi kakan desy, ma besanare lan ma ksyukar aro desy, ma nenma klyodur. ");
INSERT INTO slu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lemadendye Yesuske wasi matoha Iare roha I ma rbohe, “Tuanggurw, Tuanggurw O, mbwatar! Msweak mamak ity! Kali ana tteb ma tmaty mane!” ");
INSERT INTO slu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lemade Yesuske byatar, ode tyanuk ti wasi matoha Iare ma byohe, “Kyanmwane mimtaut ne de? Wasimy tohtohakke o ka?” Dendye Yesuske imdiry, ode yaswel esw o besa lan desikre ma kele rtenauk. Ma tasi kakan desike mlin mait elik. ");
INSERT INTO slu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dendye wasi matoha I desikre rheran, ode it de tyanuk ti it ma rbohe, “Iry neke esei bain de? Mane inal haretke ti esw o besa nekre, desikeo kele rateka mait ne de!” ");
INSERT INTO slu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ode kyoat Yesuske ranait a tasi kakanke seridake, neke iry Gadara-nare wait lasmyerke bonyo, wamwankye enaru ma ramin ti ratkye ti lasmyer Gadara desy, ma ramatakit Yesuske bonyo, rlakut sara I. Wamwany deru desike ngkeskwaure rsukar sir soso de, ma rahatw ksyalik, ma khyury ma lema irkye it a ires ma yosy a sal desy dakun. ");
INSERT INTO slu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ode iry deru desike reik ma rbu de rbohe, “Hei, Hulasokwe Anan O! Nam sai ne mureky ma aramy ne de? Lenla kyait sew a Hulasokwe itetakke bonyo, mmwa ma moban de mtwaba aramy ma ne e?” ");
INSERT INTO slu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ode kyoat desy dakun o, hahkye kmetake, ma moluk a raobak kotut ti desy, ma lema soso toha wen Yesuske ramin tike. ");
INSERT INTO slu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lemade ngkeskwaw desikre raten bain-bain toha Yesuske ma rbohe, “Kolnye mbwuma mesak aramy mtyoha iry deru ne, desikemo mlwura aramy ma ti msyukar ei hahy sokre.” ");
INSERT INTO slu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dendye Yesuske tyanuk ti ngkeskwaw desikre ma byohe, “Ou, koldyesikemo, mbyetik ma mbya!” Dendye ngkeskwaw desikre rbetik toha iry deru desy, ma ti rsukar ei hahy desikre, ma hahkye kmeta desike ra-la rba ti rnusuk ei tasike ma rlodur, ma renw tasike ma rmaty ti desy. ");
INSERT INTO slu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lemade iry majaga hahy desikre ratos a ktela desy bonyo, ra-la rbetik toha wen desy, ma rba ti rahes ti iry mamin ti nus serida desy, ti ktela madi ti hahy desikre, ktyabal ktela ngkeskwaure rabetik toha iry deru desy. ");
INSERT INTO slu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lemadendye iry mamin ti nus desike rbetik mumu toha wait nus desy, ma ti rait Yesuske ti desy. Ode raten bain-bain toha Yesuske ma byetik toha wait lasmyer desy. ");
INSERT INTO slu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Lemadendye Yesuske yor wasi matoha Iare rsai aroke, ode rbity larke ti, ma rosy a tasi kakanke kseri tran timurke, ma rbai hnu Yesuske imin tike, neke hnu Kapernaumke ti tasi kakanke kseri seryab haratke. ");
INSERT INTO slu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ode ranait hnu Kapernaumke bonyo, irire rhar a mbelukke, ma iry mablukutke imin ti khahake, ma ror i ba ti Yesuske. Kyoat Yesuske iatos iry desikre wait tohtohakke bonyo, tyanuk ti iry a mablukut desy ma byohe, “Wai!Kete ralamkwe kakan, kali kswos wasimw lim o sal nekre ba de.” ");
INSERT INTO slu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kyoat iry mahe snurat o tnyetak Musake dum a ratos ktela desike bonyo, rtanuk ti ralat a kralanare ma rbohe, “Iry neke ikanak Hulasokwe mane.” ");
INSERT INTO slu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Keskyede Yesuske hye nam iry mahe snurat o tnyetak Musa desikre rarekan ti ralat a kralanare, lemade tyanuk ti sir ma byohe, “Kyanmwane mirekan atyatke koldyesy ne de? ");
INSERT INTO slu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kabei bisa ma mran ma ktwanuk de? Kali kolnye ktwanuk ti iry mablukut desy ma kbwohe, ‘Wasimw lim o sal nekre kswos ba de.’ Desikeo ana lema mmyatakit o, wasi lim o sal desikre kswos ba deny ta lema. Klala kolnye ktwanuk ti iry mablukut desy ma kbwohe, ‘Mbwatar ode mlwakut ba.’ Desikeo ana mhye ode myatos elik o, nam kutanuk desike kdi ti ta lema. ");
INSERT INTO slu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dendye ana kswusu ohe, wasikw haretke ma kswos lim o sal nekre ba, kolnye kala iry ne ma eras i.” Maktei bonyo Yesuske yulak I sara iry mablukut desy, ode tyanuk ti i ma byohe, “Mumdiry! Ode mal wasimw a mbeluk desy, ma mulak o bai wasimw sekye!” ");
INSERT INTO slu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lemade iry desike byatar elik, ode lyakut bai waitke. ");
INSERT INTO slu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ode kyoat iry ribun desikre raatos a ktela desy bonyo, ramtaut, ode rleru Hulasokwe ti inal haret maoly desike ti irkye ne. ");
INSERT INTO slu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ode kyoat a Yesuske byetik toha wen desy bonyo, myatakit iry a maily uskwe it, neke ani Matius, ma malmata tyaklulw ti wen ikarya tike. Lemade Yesuske tyanuk ti i de byohe, “Mmwa ma mtwoha Yaw!” Lemade Matius imdiry elik, ode tyoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ode sekwe it bonyo Matius yabuk Yesuske yor wasi matoha Iare, ma rbai wasi sekye ti raknam. Ode kyoat raknam bonyo, iry ribun maily usw nekre, rtabal iry maaka wait lim o sal nekre rma dakun, ma raknam a ror Yesuske sir ti desy. ");
INSERT INTO slu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Keskyede kyoat iry manosy lui Farisi-nare ratos a Yesuske yor wasi matoha Iare, ma raknam a ror iry maily usw o iry a lim o sal nekre bonyo, rtanuk ti Yesuske wasi matoha Iare ma rbohe, “Kyanmwane wasimy Tuanggurkwe iknam a yor iry a maily usw o iry a lim o sal desikre ne de?” ");
INSERT INTO slu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kyoat Yesuske itomolu nam iry desikre ratanukare bonyo, tyanuk ti sir ma byohe, “Iry a lema klurukare lema robak dokterke, klala iry a klurukare robak dokterke. ");
INSERT INTO slu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lemade mbya, ode myajar tunke khatu mamin ti Kitab Lanke kralake, ti kibohe, ‘Msyusu wasimy loblobakke ti irire, neke eras ma kbyilak ti miabar heal ma Yaw ne.’ Kali kuma neke, lema kmwaa khyali iry a marekan tenatare o mlay a sir ne, de kmwaa khyali iry a marekan tenatare o raka wait lim o sal ne.” ");
INSERT INTO slu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ode sew desike dakun o, Yohanes Mababtiske wasi matoha iare rma ma rait Yesuske, ode rena i ma rbohe, “Tuanggurw, aramy neke myas, ode iry manosy lui Farisi-nare o ras dakun. Ode kyanmwane wasimw matoha Oare lema raas ne de?” ");
INSERT INTO slu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lemade Yesuske hyalas sir ma byohe, “Yaw ne kola wamwany masake it. Ode kyalamo rasa ma rala kalkal, ma wamwany masa desy lianare rma ma ramukmuka sir a ror i, desikeo myaso sir ma ras e? Krwekan mo lema koldyesy. Keskyede ana kyait sekwe, ma irire rma ma ral wamwany masa desike toha lianare, desikeo kyala kyosy desy nenmo lian desikre ras.” ");
INSERT INTO slu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lemade Yesuske yal tun inahliakke it ma tyanuk de byohe, “Lema irkye it a kyotal rabit harharkwe tebikan, ma yal ma byatak rabit a mtu mamahkye. Kali ana kyait ma rhas bonyo, rabit harharw desike kimtuk ma kakan, ma kyala rabit a mtu desike ma kimahy huruk, ode wasi mamahy desike ktyabal toha ma lan. ");
INSERT INTO slu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kola dene tasy maiskye kwen minminake, lema bisa ma ralik ti kwena mtuke, kali ana tasy maisy desike makity bonyo, kyala tasy maiskye kwena mtu desike ma kimahy, ma tasy maiskye kwen desike kibo ba mumu. De musti mo tasy maiskye kwen minminake, ralik ti kwena harharkwe ma deruke kihnyarak i.” ");
INSERT INTO slu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ode malmata Yesuske itun a yor sir, desikeo irkye it ma mya dakun. Iry neke ika usu khatu ti Yahudi-nare wait sey rasambayan tike. Ode kyoat iatos Yesuske bonyo, bya ti syakitil ti Yesuske wasi lulululw ne, ma yal ralake kusuke bain-bain, ma iten toha Yesuske ma byohe, “Tuanggurw! Anakw wamfwetke nenmo myaty. Lemade kuten toha O, ma mbwai wasikw sekye ti mswaa simamkwe ti anakkwe ma myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dendye Yesuske yor wasi matoha Iare, ror iry desy ma rbai wasi sekye. ");
INSERT INTO slu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ode ti iry ribun desikre dakun o, wamfwetke it ma kbai larke khatu maskyakye kyala i ainke hean a kresi enaru de, neke lyakut a yosy lyakwe ma ti nyey a Yesuske, ode kyambil mait Yesuske wasi rabit narnarkwe kninike. ");
INSERT INTO slu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kali wamfwet desike tyanuk ti ralake ma byohe, “Biar ma kalkyaw yaw ma kkwambil mait Yesuske wasi rabit narnarkwe bo, desikeo ana wasikw a kbai ne kitayar ma eras yaw elik.” ");
INSERT INTO slu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lemade Yesuske yulak i ma yatos wamfwet desy, ode tyanuk ti i ma byohe, “Eno,kete ralamkwe kakan, kali wasimw tohtohakke kyaorif a o de.” Dendye jam desike wamfwet desike eras i elik. ");
INSERT INTO slu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ode kyoat Yesuske yait iry a maka usu khatu ti sey rasambayan tike wasi sekye bonyo, yatos o irire dum a rohw fluit, ode irire ribun sir a rser a naman wamfwet mamaty desy. ");
INSERT INTO slu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lemade Yesuske tyanuk ti sir ma byohe, “Mbyetik ei mloskye, kali naman neke lema myaty, de yenaf bo.” Keskye iry ribun desikre ratomolu Yesuske ma itanuk koldyesy bonyo, ramahis a I, kali rhe ohe naman desike myaty de. ");
INSERT INTO slu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ode kyoat iry desikre rabetik ei mloskye bonyo, Yesuske syukar ti kyumak naman mamaty desike simake bonyo, naman desike myorif elik! ");
INSERT INTO slu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lemade ktela madi ti naman wamfwet desike kimelir ma ti ksyorw a nus o hnu mamin ti propinsi Galileake ktem desy mumu. ");
INSERT INTO slu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kyoat Yesuske byetik toha sey desy, ma syaur wasi laklakutke bai lulkwe bonyo, ti salke kralake ne, iry matmabolke enaru rlakut a rtoha I, ode ratelat ma rbohe, “Yesus! Raja Daud tesnwo natu O! Mlwobak aramy!” ");
INSERT INTO slu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ode kyoat Yesuske syukar ei sekye it a krala bonyo, iry deru matatare kibol desike rsukar dakun ma ti rait I. Lemade Yesuske yena sir ma byohe, “Mtyohak o Yaw ne bisa ma kala e ma mmyatakit e?” Lemade deruke rhalas Yesuske ma rbohe, “Ou, Amo, aramy mtyohak ohe, ana mala aramy ma aramy mmyatakit.” ");
INSERT INTO slu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lemade Yesuske syaa simake ti matatare, ode tyanuk ti sir ma byohe, “Mbya, kali wasimy a tohtohakke kyala e ma mmyatakit de.” ");
INSERT INTO slu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kyoat desy dakun o iry deru desike rmatakit. Lemade Yesuske tyanuk ti sir ma byohe, “Mtyomolu! Mijaga ma kete irkye it a hye ktela madi ti miru ne elik.” ");
INSERT INTO slu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Keskyede iry deru desike rabetik bonyo, rba ti rabrita Yesuske Anike ti nus o hnu mamin ti propinsi Galileake ktem desy mumu. ");
INSERT INTO slu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kyoat iry deru matmabol desike raba bonyo, irkye it a yor iry a ngkeskwakwe syukar i ma nunu ktem, ma yor i ba ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dendye Yesuske yesak ngkeskwaw desike toha iry nunu ktem desy. Ode kyoat Yesuske yesak ngkeskwaw desy bonyo, iry desike itun eras elik. Ma iry ribun maseak desikre rheran, ode rtanuk ma rbohe, “Lenla tatos ktela maoly ne ti negara Israel ne elik.” ");
INSERT INTO slu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Keskyede iry manosy lui Farisi-nare rbohe, “Iry desike yal a ngkeskwaure wait uskwe khatuke wasi haretke, ma yal ma yesak ngkeskwakwe.” ");
INSERT INTO slu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Maktei o Yesuske lyakut a lyola nus o hnu mamin ti propinsi Galileake mumu, ma yajar ti Yahudi-nare wait sey rasambayan tiare, ma yabrita Brit Eraske ti kolkyabei ma Hulasokwe ima ma ihareta kola Rajake ne. Ode nyoha kbainare toha iry a klurukare ma eras sir, ode yala iry a maluhare ma malkyakaw sir. ");
INSERT INTO slu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ode kyoat Yesuske yatos iry ribun matoha I desikre bonyo, ralake krala ne klyobak sir a ksyalik, kali iry desikre lema reti ral de, ode lema rhe raba sara, de rola dene dombanare ti lema kika iry a majaga sir ne. ");
INSERT INTO slu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Iry mabuma matomolu Brit Eras nekre ribun sir, ma rola ne alyaw rala ma raketkye. Alyaw neke lan a ksyalik, keskyede makaryaare lema ribun sir. ");
INSERT INTO slu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lemadendye miten toha boke Kebuke ma tyabal makaryaare ma ribun sir,ma rkety alyaw desy mo klyahamety, ma adoko ktei.” ");
INSERT INTO slu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lemade Yesuske yabuk iry matoha Iare, ma yilik irkye hean a kresi enaru toha iry desikre, ma yal sir ma wasi nyaso sir. Dendye yal haretke ti sir, ma ti resak ngkeskwakwe toha irire, ode rnoha irire wait kbai sai ta sai bo ma eras sir, ode rnoha iry a mablukutare ma rlakut dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ode Yesuske wasi nyaso dehean a kresi enaru inal haretke ti sir desy, neke sir ne: Mamunake Simon kyalamo raabuk i o Petrus ne, yor wai Andreas. Ode Yakobus yor wai Yohanes, iry deru neke Zebedeus ananare. ");
INSERT INTO slu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Maktei o Filipus, ode Bartolomeus, ode Tomas, ode Matius iry a maily uskwe, ode Yakobus Alfeus ananke, ode Tadeus, ");
INSERT INTO slu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ode Simon iry manosy lui Zelotke, ode Yudas Iskariotke, ma i ne ana iketa Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sew desike, Yesuske yala ma yaso wasi nyaso dehean a kresi enaru desy bonyo, tyanuk ti sir ma byohe, “Kete mbyai lasmyer a iry lema Yahudi-nare ramin tike, ode kete mbyai iry a Samaria-nare wait nus o hnu dakun, ");
INSERT INTO slu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","de mbyai iry a Yahudi-nare wait nus o hnu bo, kali sir desike rola dene domba matayar nekre. ");
INSERT INTO slu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dendye mbya, ode mtyanuk ti sir ma mbyohe, ‘Hulasokwe ima ma ihareta kola Rajake ne kyarasy de.’ ");
INSERT INTO slu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ode miba neke, mnyoha iry a isy masunure wait a kbainare ma eras sir, ode myala iry a mamatire ma rmorif, ode myala iry a mambaulare ma iblutare nelnyely, ode myesak ngkeskwakwe toha irire dakun. Ode mnyenas! Kolnye msyaluk irire, desikemo kete miten namit-namit toha sir, kali Hulasokwe yal haret lan ne ti e, desikeo lema iten namit-namit toha e. ");
INSERT INTO slu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ode mbya o kete mlyuk kuban blyawan kunkuny o bokbok, ta senke it dakun ti wasimy a suhlwakare. ");
INSERT INTO slu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ode kete myety res ma kbyilak, ode kete myety rabit ma kbyilak, ode kete myety sososa lwaw ma kbyilak, ode kete myety tektekan dakun. Kali ei neke iry makarya e, ma mkyarya ti irire, dendye iry a mikarya ti sir desy, musti mo rselw wasimy katire ti e. ");
INSERT INTO slu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ode kolnye msyukar ei nuske it, ta hnuke it, desikemo msyeak myobak iry a ral eraske it, ma you ma yal e ma mimin ti wasi sekye. Ode kolnye myor i ti wasi sekye de, desikeo myor i nini mbyetik ma mbyai hnu salik bo. ");
INSERT INTO slu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ode kolnye msyukar ei sekye it, desikeo miten ma Hulasokwe yal eraske ti sekye krala desy. ");
INSERT INTO slu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ode kolnye sekye kebu desike ralake eras ti e, desikemo eras miten ma Hulasokwe inal ti sekye krala desike ne, ana kimin a sir. Dete kolnye sekye kebu desike ralake lema eras ti e, desikemo eras miten ma Hulasokwe inal ti sekye krala desike ne, ana kyulak i ti e huruk. ");
INSERT INTO slu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dete kolnye msyukar a hnuke it, ode lema rou ma ral e ei wait seire, ta lema rbuma rtomolu e, desikemo mbyetik toha hnu desy, ode mryitik a ahkwe toha lwaumire, ma klyosu ohe ana Hulasokwe ibu a ituly hnu desy.” ");
INSERT INTO slu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maktei o Yesuske tyanuk ti wasi nyaso desikre huruk ma byohe, “Mtyomolu mamak nam kutanuk ne! Ana kyait sekwe ma Hulasokwe yukun nuske ktem ne mumu, desikeo iry mamin ti nus o hnu a lema rou ma ratomolu e neke, Hulasokwe ana yal masunkwe ti sir o kbyilak masunw ana Hulasokwe inal ti iry a Sodom o Gomora nekre dakun.” ");
INSERT INTO slu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lemade Yesuske tyanuk ti wasi nyasoare huruk ma byohe, “Mnyenas! Mijaga mamak a e, kali wen kuaso e ma miba ti nekre, wen a iry mahature. Kola dene dombake imin ti asw utan mahatw nekre wait kditlalanke ne. Lemadendye ei neke it o it neke, samlurkwe o mhye telke kola nike, keskye myala ralamire ma nelnyely kola manu hahkye. ");
INSERT INTO slu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Keskyede mijaga mamak a e ti iry ribunke, kali ana dum a rhait e bai iry a manety lulw ti Yahudi-nare, ma roban de rtaba e ti sey a rasambayan tiare. ");
INSERT INTO slu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ode khyali mitoha Yaw ne, desikeo ana irire rkumak a e, ma rhait e ba ti maharetanare ode raja-nare dakun. Ode kyoat desike, ei ne bisa ma myabrita Yaw ti iry a lema mahe Hulasokwe ne ma desy. ");
INSERT INTO slu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ode kyoat rahait e ba ti iry maukun tunare, desikemo kete ralamire kakan ti nam ana mihalas o mitanuk ti iry maukun tun desikre. Kali nam ana mihalas o mitanuk desikre, neke lema kbyetik kyosy a nam mirekanare, de kbyetik kyosy Hulasokwe Memeanke kirekanare kmyesan bo. ");
INSERT INTO slu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kali ei ne ana lema mitun, de Amamy Hulasokwe Memean mamin ti wen sra eraske, ana kitun ti ralamy kralanare. ");
INSERT INTO slu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kyoat desy dakun o irire ana ral wait o hatnimat, ma ror sir ba ti haretke ma rtabahunw a sir. Ode amamare ana ral anatare ma ror sir ba ti rtabahunw a sir dakun. Ode ana namanare rulak sir ma rsorw a enat o amat. Ode ana raso irire ma rtabahunw enat o amat dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ode ana irire mumu ne ramnisik a e, kali mtyoha yaw. Keskyede esei desike ana ineti manenen ralake ma tyohak ma Yaw nini nam ribun nekre ktei, desikeo i desike ana Hulasokwe yaorif a i. ");
INSERT INTO slu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ode kolnye roban de rtaba e ti nuske it, desikemo mila mbyai nus salik. Mtyomolu mamak nam kutanuk ne! Kyoat lenla mbyaa myoli nus mamin ti negara Israel nekre mumu, desikeo Irkye Anankemyaa kmuna de. ");
INSERT INTO slu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ode mhye ohe, lema kika naman a skol mahe tel ma kbyilak wasi tuanggurkwe, ode lema kika at manety alalan ma kbyilak wasi amam lanke dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Keskyede naman a skol a kolnye ti yaskol ma ti ktyutw teike, desikeo ana hye telke kola wasi tuanggurkwe dakun. Kola dene atke ma kolnye yala tenanke ma yety alalan, desikeo at desike ana yola wasi amam lanke dakun. Mnyenas ohe Yaw neke kuka usu khatu ti sekye kralake, ode ei neke myola dene anakure. Mane dai irire rabuk Yaw o Beelzebul,desikemo maola e ne ana rabuk e kolkya? Ana rahmway e ma kbyilak ti rahmway Yaw ne dakun! ");
INSERT INTO slu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Dendye kete mimtaut ti iry a masorw a e nekre, ti wait ktela raala ma kihunik i nekre. Kali lema kika nam mabuny ma ana lema kbyetik, ode lema kika nam mahunik i ma ana irire lema rhe ode lema rahes. ");
INSERT INTO slu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ode nam sai kihunik i ma ktwanuk ti e, desikemo kete mihunik, de mbya ti myabrita ma irire mumu ne rhe. Ode nam sai kububu ti molumire ti sewahke, desikemo mikita ma msarin bolbolbol ne, desyo myatelamy ti kabei ta kabei bo, ma irire mumu ne rhe. ");
INSERT INTO slu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ode kete mimtaut iry a matabahunw tenamire ne, kali lema bisa ma rtabahunw a smwaknamire. De musti mo mimtaut Hulasokwe, kali wasi haretke lan ma bisa ma tyabahunw a smwaknamire ode tenamire dakun ti wen ay malehur manal nini namke kralake. ");
INSERT INTO slu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Keskye mryekan ne aduk: Manu lmuanke enaru, neke bisa ma rliw a sir o khesike ne hah lahuk ne. Ma biar ma koldyesy dakun, keskyede manu lmuan desike sasam a lema bisa ma dyi ei lasmyerke khaha ne, kolnye Amamy Hulasokwe lema you. ");
INSERT INTO slu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kola dene hukamire dakun, ma biar ma ribun dakun, keskye Hulasokwe hye karyarike mumu de. ");
INSERT INTO slu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Koldyesikemo kete mimtaut. Kali ti Hulasokwe, ei neke myety alalan ma kbyilak manu lmuan desikre.” ");
INSERT INTO slu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesuske tyanuk ti wasi nyasoare huruk de byohe, “Kolnye esei desike you ti ribunke khahake ohe tyohak ma Yaw, desikemo Yaw ne ana kou iry desy dakun, ti Amakw mamin ti wen sra eraske ohe, iry desike wasikw iry a i. ");
INSERT INTO slu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Keskyede esei desike lema you Yaw ti irkye wasi lulw ne, desikemo Yaw dakun o ana lema kou i ti Amakw mamin ti wen sra eraske.” ");
INSERT INTO slu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Lemadendye Yesuske tyanuk huruk ti wasi nyasoare ma byohe, “Kete mryekan o kumai nuske ktem ne ma kala irire mumu ma it de ika eras yor it. Lema koldyesy! De klwosu ti e ohe, kumai nuske ktem ne, neke kmwa ma kala irire ma it de syorw a it ma rakahrea. ");
INSERT INTO slu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kali ti Kitab Lanke kbyohe, ‘Kmwa ma kala naman wamwanire ma rsorw a amatare, ode kala naman wamfwetare ma rsorw a enatare, ode kala naman wamfwet masaare ma rsorw a ryanat wamfwetare dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ode ana inamnisik o inailir nekre lan a ksyalik ti wasimy sey kralanare.’ ");
INSERT INTO slu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ode kolnye esei desike lyobak ama, ta lemamo lyobak ena ma kbyilak Yaw, desikeo lema bisa ma kal i ma tyoha Yaw. Ode esei desike lyobak anan wamwankye, ta lyobak anan wamfwetke ma kbyilak Yaw, desikeo lema bisa ma kal i ma tyoha Yaw dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ode kolnye esei desike byuma tyoha Yaw, keskye lema byuma hyar wasi tul masanwalw ike,desikemo ana lema kal i ma tyoha Yaw dakun. ");
INSERT INTO slu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ktwanuk koldyesy, kali kolnye esei desike kyumak eta wasi mormyorifke,ma lema you ma tyoha Yaw, desikemo ana lema myorif nini nam ti kiba knaru ne. Klala esei desike tyutuk wasi mormyorifke, ode you ma myatykhyali itoha Yaw ne, desikemo i desike ana myorif nini nam ti wen sra eras Hulasokwe imin tike.” ");
INSERT INTO slu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Lemadendye Yesuske tyanuk ti wasi nyasoare ma byohe, “Esei desike you ma yal e ei wasi sekye kralake, desikemo kola ne you ma yal Yaw dakun ma desy. Ode esei desike you ma yal Yaw, desikemo kola ne you ma yal Hulasow a maso Yaw ne ma desy. ");
INSERT INTO slu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ode esei desike you ma yal iry manety Hulasokwe wasi nyanoke, kali hye ohe iry desike yety Hulasokwe wasi nyanoare, desikeo ana Hulasokwe yal ksewanke ti i, kola ksewan ana Hulasokwe inal ti iry manety nyano desy. Ode esei desike you ma yal iry mlakye, kali hye ohe iry desike iry mlay a i, desikeo ana Hulasokwe yal ksewanke ti i, kola ksewan ana Hulasokwe inal ti iry mlay desy dakun ne. ");
INSERT INTO slu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ode esei desike itera wer masihkwe tebikan ti wasikw iry matohakke it, biar ma irire rbohe wasikw iry matohak desike lema byero tyahal dakun, desikemo pasti ma Hulasokwe ana yal ksewanke ti iry a matera wer desy.” ");
INSERT INTO slu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kyoat Yesuske syurat a ktela ribun nekre ti wasi nyaso dehean a kresi enaru desy maktei bonyo, yaso sir ma rba. Ode Ia byai nus o hnu mamin ti propinsi Galilea desikre, ma yajar ode yabrita Brit Eras manosy Hulasokwe ti irire. ");
INSERT INTO slu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ode kyoat desike dakun o Yohanes Mababtiske malmata imin ti sey metmetke kralake, ode itomolu Yesuske ti nam ialanare bonyo, ");
INSERT INTO slu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yaso wasi nyasoke irkye enai ne, ma ti rena Yesuske ma rbohe, “Amo, iry a aramy mikita ma ana ima ma ktyoha nam Hulasokwe ihatetak ne, neke O e? Ta musti mo aramy mikita iry salik de?” ");
INSERT INTO slu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lemade Yesuske hyalas iry desikre ma byohe, “Mbya, ode mtyanuk ti Yohanes ti nam sai miatos ode mitomolu nekre: ");
INSERT INTO slu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","neke matmabolke myatakit de, ode mablukutke lyakut de, ode mambaulke iblunke nelnyely de, ode mamolkwe tyomolu de, ode mamatkye myorif huruk de, ode iry a lema manait ei sra o hah nekre, kabrita Brit Eraske ti sir dakun de. ");
INSERT INTO slu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lemadendye iry a lema ralake kakan khyali itoha Yaw ne, ode iry a lema mabu a matuly Yaw ne, eras manosy Hulasokwe kimin a i.” ");
INSERT INTO slu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kyoat iry a Yohanes iaso desikre raba bonyo, Yesuske ihes Yohanes ti iry ribun desikre ma byohe, “Kyanmwane kola mibuma mibai wen malosy-loskye ti miatos Yohanes ne de? Ti myatos iry a matoh ti de matoh ma kola tnyeike ti eskwe kisiri ti de kisiri ma o kitoha bony ne e? Lema! ");
INSERT INTO slu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta nam sai ne kihury ma miba ti miatos ne de? Ti myatos iry a mahonak rabit eras ne e? Lema koldyesy! Kali iry a mahonak eras ike, lema imin ti wen malosy-loskye, de imin ti sey lan rajake imin tike. ");
INSERT INTO slu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ode kolkyabei mane miba ti miatos i ne de? Ti myatos iry manety Hulasokwe wasi nyanoke o de? Desike mlay. Dendye klwosu ti e ohe, Yohanes neke lan i ma byilak iry manety Hulasokwe wasi nyano nekre mumu. ");
INSERT INTO slu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kali khyali Yohanes, mane heitlulswo rkesy ti Kitab Lanke ma kbyohe, ‘Matos, i neke wasikw nyaso kuasoke, ma myaa kmuna O, ma bya ti syoli salke ma kikita O.’” ");
INSERT INTO slu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lemade Yesuske tyanuk huruk ma byohe, “Mtyomolu mamak nam kutanuk ne! Ti nuske ktem ne, kyala kyosy khyehyeike ma ti kyait senwe, lema irkye it a lan i ma byilak Yohanes Mababtiske elik! Klala kyala kyosy senwe, esei desike itotomolu tel ti Hulasokwe kola dene wasi Raja I ne, ma biar ma kakakan lahuk i dakun, keskyede ana lan i ma byilak Yohanes Mababtiske. ");
INSERT INTO slu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ode kyala kyosy sew a Yohanes Mababtiske iabrita Hulasokwe ti ana ima ma ihareta kola Rajake ne, ma kyala kyosy sew desy ma ti kyait senwe, neke irire dum a ralkyaw sir ma rataut irire, ma kete rtomolu brit a Hulasokwe, ti ima ma ihareta kola Rajake ne. Kali iry desikre rbuma rmesan a rhareta iry a matohak ti Hulasokwe ne. ");
INSERT INTO slu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kali kyala kyosy a heitlulswo, ma ti kyait a Yohanes Mababtiske ima desy, neke Musa yor iry a manety Hulasokwe wasi nyanoare mumu ne, rkesy ti wait kitabare, ma klyosu ktela ana madi ti nekre, ti senwe mane, neke Hulasokwe mya ma hyareta kola Rajake ti irire ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dendye kolnye mbyuma mtyomolu Yaw, desikemo klwosu ti e ohe, Yohanes Mababtiske, i neke Elia ana mama ne i desy, ma ktyoha heitlulswo Hulasokwe itetakke de. ");
INSERT INTO slu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dendye esei desy ika molu desikemo tyomolu!” ");
INSERT INTO slu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Lemadendye Yesuske tyanuk ma byohe, “Ana kal sai ma kuhliak ode kulalau kyor iry a mamin ti taras ne de? Iry nekre rola dene namanare, ma rtaklulw ti wen kyalamo irire raketa nam tike, ma rarwen ti liatare ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aramy mkyohw tihal ti e ma misety, keskyede lema misety. Ode aramy miora inaora manety ral matolare, keskyede lema msyer.’ ");
INSERT INTO slu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ktwanuk koldyesy, kali kyoat Yohanes Mababtiske mya, desike bonyo lema yenw tasy maiskye kwen makitkye elik, ode kyalamo yas dakun, ma lema nya rotkye. Keskye lema mdyakin i, de mtyanuk ma mbyohe, ‘Ngkeskwakwe syukar i.’ ");
INSERT INTO slu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Klala Irkye Anankemya, desikeo lema yas de iknam o yenw bo. Keskyede lema mdyakin I dakun, de mihes I ma mbyohe, ‘Myatos I e! I neke ikotw atyat, ode yenw tua manas. Ode lema eras I, kali ika lui yor iry maily usure, rtabal iry maka wait lim o sal nekre.’ Ode biar ma mtyanuk koldyesy, keskyede kolnye myatos Hulasokwe wasi irire tot raalanare, desikeo bisa ma mhye ohe, Hulasokwe wasi hehei lulw o lyakwe mlay.” ");
INSERT INTO slu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lemadendye Yesuske yala ma tyerik nus o hnu a lema mabuma matunik wait lim o sal nekre, biar ma ti nus o hnu desikre kyalamo Yesuske yala ktela masalsyalik iare ribun ti dakun. Lemadendye tyanuk ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Atyatke ana kidurak iry mamin ti nus Khorazimke, ode iry mamin ti nus Betsaidake. Kali kola kala ktela masalsyalik iare ribun ti wasimy a nus o hnu desikre, keskye lema mbyuma mtyunik wasimy lim o sal desikre ba elik. Klala kolnye ana kbwai nus Tirus o nus Sidon iry mahatw desikre, ma kolnye kala ktela masalsyalik iare ti desy, ma kola ktela masalsyalik i nenmo kuala o nus Khorazimke ode nus Betsaida desy, desikemo iry mahatw mamin ti nus Tirus o nus Sidon desikre, ana rtunik a wait lim o sal nekre ba elik. Neke rhonak rabit boare, ode rritik ahkwe ti tenatare, ma klyosu ohe, rasesal tenatare de ti lim o sal raalanare, biar ma sir neke lema iry Yahudi sir dakun. ");
INSERT INTO slu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dendye ana kyait sekwe ma Hulasokwe yukun nuske ktem ne mumu, desikeo Hulasokwe ana yal masunkwe ti iry a Khorazim o Betsaida desikre, desikeo ksunw ksyalik ma kbyilak masunw ana inal ti iry a Tirus o Sidon desikre. ");
INSERT INTO slu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ode iry a Kapernaum e, desi mryekan o ana Hulasokwe byitil e bai wen sra eras Hulasokwe imin tike e? Lema koldyesy! De ei neke ana Hulasokwe yotuk e bai wen ay malehur manal nini namke kralake! Kali kolnye heitlulswo kbwai nus Sodom iry mahatw desikre, ma kolnye kala ktela masalsyalik iare ti desy, kola nenmo kuala ti hnu Kapernaum ne, desikemo iry mamin ti nus Sodom desikre rtunik wait lim o sal raala desikre ba elik. Ma kolnye rala koldyesy, desikemo nus Sodom desike bisa ma kimin a nggora nini kyait senwe. ");
INSERT INTO slu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lemadendye ktwanuk ti e ohe, ana kyait ma Hulasokwe yukun nuske ktem ne mumu, desikeo masunw Hulasokwe inal ti iry a Sodom-are, ana mran ma kbyilak masunw ana inal ma kidan iry a Kapernaum e ne.” ");
INSERT INTO slu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kyoat desike dakun o Yesuske syambayan ma byohe, “O Amo, Amam Lan O, Oi ne muhareta lait o lasmyerke khaha ne. Kswalak eraske ba ti O, kali nam nekre mumu ne muhunik ti iry mahe telare, ode ti iry mahei lulw o lyaw nekre. Klala mlwosu nam nekre mumu ti iry a manauk tenatare ma babaf kola naman kakanare ne. ");
INSERT INTO slu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ktela muala desy, ne kiala ma ralamkwe kimukmuka i ne.” ");
INSERT INTO slu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesuske syambayan maktei bonyo, tyanuk ti iry mamin ti desikre ma byohe, “Amaku yal haretke mumu ma Yaw de. Ode lema irkye it a hye Yaw dakun, de lenla Amaku myesan a hye Anan a Yaw ne bo. Ode lema irkye it a hye Amakw dakun, de lenla Anan Yaw kmwesan a khwe I bo, ktyabal iry a kudakin ma ana kulosu Amakw ti sir ne, ma bisa ma rhe Amakw dakun. ");
INSERT INTO slu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hei iry ribun a lema maneti kyal ode mahar a mdedan e! Mmya ma myait Yaw, kali ana kaditi harhar mdedan desikre ba toha e, ode kala e ma mmyea mo ktyutw. ");
INSERT INTO slu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lemade mtyomolu ode mtyoha nam a kuhareta ti e ne. Ode mmya ma kajar a e, ma mtyoha ma myala nam kutanukare. Kali Yaw neke ral lublubke kimin Yaw, ode knwauk tenakw ne ma bababaf, mamode kala e ma kele rteka ralamire. ");
INSERT INTO slu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kali nam kuhareta ti e ne, kyor harhar kunal ti e ne lema mdedan.” ");
INSERT INTO slu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kyoat sew Inamreske it, desikeo Yesuske yor wasi matoha Iare rlakut ti bo gandumke. Ode wasi matoha Iare riry gandumke ratebikan ti simatare, ode rkaslyaw ma ra, kali ramlar. ");
INSERT INTO slu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kyoat iry manosy lui Farisi-nare ratos ktela desy bonyo, rtanuk ti Yesuske ma rbohe, “Matos! Wasimw matoha O nekre rbilak ity wait tnyetak kubkubakke de, kali rkarya ti sew Inamreske ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lemade Yesuske hyalas sir ma byohe, “Ei ne mbyaca Kitab Lanke de, ma mhye nam kidi ti ti kyoat Daud yor lianare ramlar desy de. ");
INSERT INTO slu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Neke Daud syukar ei Hulasokwe wasi Lasyerkye kralake, ode yal roty a raabar ti Hulasokwe desy ma nya. Ode isakar a roty desikre kteranare ti lianare ma ra dakun. Keskyede kolnye ktyoha ity wait tnyetak kubkubakke mo, the ohe Daud yor lianare lema bisa ma ra roty desikre, de taheke o iry mabaa klen ti irkye yor Hulasokwe ne, rmesan a bisa ma ra roty desikre bo, kali haretke kimin a sir. ");
INSERT INTO slu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ode tbaca ti tnyetak Musake de, ti kibohe, iry mabaa klen ti irkye yor Hulasokwe ne ana rkarya ti Hulasokwe Seike, ti wait sew a rakarya tike bo, biar ma sew desike kdi ti sew a Inamreske dakun. Ode Hulasokwe lema byohe sal sir, biar ma rbilak tnyetak Musake ti rakarya ti sew Inamreske desy. ");
INSERT INTO slu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lemade ktwanuk ti e ohe, ti wen tamin ti neke irkye it a Iry lan I ma byilak Hulasokwe Seike. ");
INSERT INTO slu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ode ti Kitab Lanke kbyohe, ‘Iry masusu rala eraske ti iry salikare ne, iry desike yala ralakkwe ma ksyenan, ma kbyilak iry a maabar nam ma Yaw ne.’Lemade kolnye mhye tun desikre kbuanare, desikemo ana lema bisa ma myoit salke ti iry a lema maala salke. ");
INSERT INTO slu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ode klwosu ti e ohe, Irkye Anankewasi haretke ma yohut ohe, nam sai bisa ma rala ti sew Inamreske, ode nam sai lema bisa ma rala ti sew Inamreske dakun.” ");
INSERT INTO slu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lemade Yesuske byetik yosy wen desy, ma bya ti syukar ei Yahudi-nare wait sey rasambayan tike. ");
INSERT INTO slu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti desy dakun o irkye it ma simake serit a kmyaty. Lemade iry manosy lui Farisi-nare dum a rena Yesuske ma rbohe, “Bisa ma rnoha iry a isy masunw maoly ne ti sew Inamreske ta lema de?” Iry a Farisi desikre rena koldyesy, kali robak a ksala ma roit salke ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lemade Yesuske tyanuk ti iry desikre de byohe, “Ti ei ne mumu neke, kolnye it a wasi dombake it a dyi ei kuranke kralake ti sew Inamreske, desikemo ti sew desy dakun o, lema adoko bya ti byity wasi domba desy toha kuranke krala desy e? ");
INSERT INTO slu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","De lema mhye o Hulasokwe lyobak irkye ma kbyilak dombake e? Dendye kolnye tsaluk irire ma eras sir ti sew Inamreske, desikemo lema tbilak ity wait tnyetak kubkubakke, de ttoha ity wait tnyetak kubkubakke ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lemade Yesuske itanuk koldyesy ti iry a Farisi desikre maktei bonyo, tyanuk ti iry a simake serit a kimaty desy ma byohe, “Mlwol simamkwe ma!” Dendye iry desike ilol simake ba sara Yesuske bonyo, sima desy eras elik, ma eras kola sima seridake dakun! ");
INSERT INTO slu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lemade iry manosy lui Farisi desikre rbetik toha sey rasambayan ti desy, ode ti rawahuk sir ma rkau tunke ti sasam, ma rbuma rtabahunw a Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT12_15a","070_12_15a","MAT","12","15a","15a","Keskyede Yesuske hye iry desikre wait rekryekkye, dendye byetik toha wen desy. ");
INSERT INTO slu_vpl VALUES ("MT12_15b","070_12_15b","MAT","12","15b","15b","Kyoat Yesuske byetik toha wen desy, desikeo iry ribunke rtoha I. Ode nyoha iry a klurukare mumu ne wait a kbainare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Maktei o Yesuske byu eta malkyakaw iry desikre, ma kete rahes I ti irire. ");
INSERT INTO slu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lemadendye ktela masalsyalik i a Yesuske iala desikre ne, kdi ti ma ktyoha tun a Hulasokwe itanuk ti Yesaya iry manety Hulasokwe wasi nyanoke, ma ikesy ti wasi kitabke, ti kilosu Mesiaske ne, ma kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Hulasokwe tyanuk ma byohe, “Myatos! Wasikw nyasoke I ne, ma kilik I de. Ma klwobak I, ode kou I ti ralakkwe de. Ode yala ralakkwe ma ksyenan. Ma ana kal Memeakkwe ti I, ode I neke ana yabrita wasikw eras a mlakye ti bangsa-nare. ");
INSERT INTO slu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ode I dakun o ana lema itun lan, ode lema itaur nunw, ode lema yal o teltela ti sal a krala. ");
INSERT INTO slu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ode ana syusu rala eraske ti iry a maluhare. Neke kolnye: I neke kolnye yait a kbabil mabelke, desikeo ana lema yohut ma kisalik a i. Ode kolnye yait damarke ma kelelnanke kibail-kibail, desikeo ana lema yohu hyunw dakun. Ode I dakun o ana yalkyaw tenanke nini ktela mlay a kuohut nekre kdi ti mumu. ");
INSERT INTO slu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ode bangsa nekre mumu neke ana ral wait mormyorifare ti I a myesan bo.” ");
INSERT INTO slu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lemade irire ror a irkye it ti Yesuske, neke iry desike matake kbyol, ode nunuke ktem, kali ngkeskwakwe syukar a i. Dendye Yesuske nyoha kbai desikre toha iry desy ma eras i, ma bisa ma myatakit ode itun elik. ");
INSERT INTO slu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dendye iry ribun desikre mumu ne rheran a ksyalik ti raatos ktela desike ne, dendye rtanuk ma rbohe, “Anakyai Mesias a raja Daud tesnwo natu a heitlulswo Hulasokwe ihatetak o ana ima neke, I ne e!?” ");
INSERT INTO slu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Keskyede kyoat iry manosy lui Farisi-nare ratomolu iry ribun desikre ma ratanuk koldyesy bonyo, iry Farisi desikre rtanuk ma rbohe, “Lema koldyesy! De Iry neke bisa ma yesak ngkeskwakwe, kali Beelzebul a ngkeskwaure wait uskwe khatu desike yal haretke ti I ma desy!” ");
INSERT INTO slu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Keskye Yesuske hye iry manosy lui Farisi desikre nam rarekanare, lemade tyanuk ti sir ma byohe, “Ti negarake it, ma wasi masyarakatke rahe a rasakar sir, ma it de syorw a it ma rakahrea, desikeo khyury ma negara desike kiskyui-kiskyay. Kola dene ti nuske it, ta sekye kralake it, ma kolnye it de lema yor eras it, desikeo khyury ma nus desike ana kiskyui-kiskyay, ode iry mamin ti sekye krala desy ana raskyui-raskyay dakun. ");
INSERT INTO slu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Koldyesy dakun ti kolnye ngkeskwaure resak ngkeskwaure, ma khyury ma it de syorw a it ma rakahrea, desikemo wen rahareta tike ana kolkya, de lema wen desike ana kiskyui-kiskyay e? ");
INSERT INTO slu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dendye kolnye mtyanuk ma mbyohe, kal Beelzebul wasi haretke ma kesak ngkeskwaure, dendye kena e ohe, haret kabei ne wasimy matoha eare ranal ma raesak ngkeskwaure ne de? Kolnye mryekan koldyesy, desikemo ana wasimy matoha e desikre rmesan a rbohe ei neke sal e, ti mirekan koldyesy ne. ");
INSERT INTO slu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Keskyede Yaw ne kal Hulasokwe Memeanke ma kal ma kesak ngkeskwaure. Ode ktela kuala desikre ne klyosu ohe, Hulasokwe ima ma ihareta kola Rajake ne, kmya ti e bain de.” ");
INSERT INTO slu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Dendye Yesuske ihliak tunke it huruk ma byohe, “Kolnye irire dum a rreky ma rsukar ei iry a malkyakakwe it a wasi sekye ma ranamet wasi malolkye, desikemo khyehyei neke musti mo ral ranteke ma rdalun a iry a malkyakaw desy aduk, maktei o nenmo bisa ma rsukar ei wasi sekye kralake ti ranamet wasi malolkye. Kola ne kuala ti ngkeskwaure wait uskwe khatuke ne dakun de. ");
INSERT INTO slu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Dendye esei desike lema byuma tyoha Yaw, desikemo yobak ma syorw a Yaw ma desy. Ode esei desike lema syaluk Yaw ti karyaakure, desikemo i ne yobak ma iskyui-iskyay karyaakure ma desy. ");
INSERT INTO slu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lemadendye mtyomolu mamak nam kutanuk ti e ne! Hulasokwe bisa ma syos irkye wasi lim o sal ba mumu, biar ma ikanak Hulasokwe dakun. Keskyede esei desike ikanak Hulasokwe Memeanke, ana Hulasokwe lema bisa ma syos iry desike wasi lim o sal ti ikanak Hulasokwe Memeanke ne ba elik. ");
INSERT INTO slu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kolnye esei desike ikanak Irkye Ananke, ana Hulasokwe bisa ma syos sala desy ba. Klala esei desike ikanak Hulasokwe Memeanke, ana Hulasokwe lema bisa ma syos sala desy ba elik, biar ma ti nuske ktem ne, ta ti taras selsel ne, ma ti kyait nuske ktem harharw ana mama ne dakun.” ");
INSERT INTO slu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lemadendye Yesuske tyanuk ti iry a Farisi desikre huruk ma byohe, “Aw eraske desikeo ana kisinare eras. Ode aw lema eraske, desikeo ana kisinare lema eras dakun. Ode tahe akwe ohe eras ode lema eras ne, neke the toha kisinare. ");
INSERT INTO slu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hei iry mahatw maola ni e, ei neke mihatw! Dendye kolkyabei ma bisa ma mtyanuk tun erasare de? Kali sai desy mtyanuk, desikeo kbyetik kyosy ralamy kralanare. ");
INSERT INTO slu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kola dene iry eraske tyanuk tun erasare, kali kbyetik kyosy rala eraske. Ode iry atyatke tyanuk tun atyatare, kali atyatke kbyenw ti ralake kralake. Dendye nam sai desike kimin ti ralamy kralanare, desikeo ana mtyanuk ma kbyetik. ");
INSERT INTO slu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lemade mnyenas! Kolnye kyait sekwe ma Hulasokwe yukun irkye, desikeo irire it o it neke ana ramdiry ma rsara Hulasokwe, ma rlosu tunat ratanuk ma lema kiety mdedan nekre mumu ti I. ");
INSERT INTO slu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kali tunamy mitanukare kmyesan a klyosu o mlay a e, dete lemamo sal a e.” ");
INSERT INTO slu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sew desike dakun o, iry mahe snurat o tnyetak Musake dum, ror iry manosy lui Farisi-nare dum dakun, neke rma ma rait Yesuske, ode rtanuk ti I ma rbohe, “Tuanggurw, aramy miten ma mala ktela masalsyalik ike it ma klyosu ohe, Oi neke mlay bain-bain o Hulasokwe wasi nyaso O ta lema.” ");
INSERT INTO slu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Keskyede Yesuske hyalas iry desikre ma byohe, “Taras neke taras iry mahature. Ode iry mamin ti taras neke rbuma kala nyatos harharkwe it ti sir, ma bisa ma rtohak ma Yaw, keskyede ana lema kala nyatoske sasasam ti sir dakun. De cuma mo kala nyatos maola nyatos a heitlulswo madi ti Yunus iry manety Hulasokwe wasi nyano desy bo. ");
INSERT INTO slu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kali Yunus neke imin ti masy lan ne fteike kralake sewahke enatelw, ode msarinke enatelw. Kola ne Irkye Ananke ana imin ti lasmyerke kralake sekwe enatelw, ode sewahke enatelw dakun. ");
INSERT INTO slu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ode kyoat nuske ktem ne kyala ma klyodur, ma ana Hulasokwe yukun irire mumu bonyo, iry a Niniwe-nare ramdiry ror a iry mamorif ti taras ne, ma iry a Niniwe desikre rtudu iry mamin ti taras ne o sal sir. Kali iry Niniwe desikre rtunik wait lim o sal ba de, ti kyoat ratomolu nyano a Yunus itanukke. Keskyede ti senweke Irkye it lan a I ma byilak Yunus, ma mya ti taras ne ma tyanuk dakun, keskye taras ne lema rhaduli ma rtomolu I, ode lema rbuma rtunik totat atyatare ba dakun. ");
INSERT INTO slu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ode kyoat nuske ktem ne kyala ma kilodur desy, ratuke it ma imdiry ti desy dakun, ma yoit salke ti iry mamorif ti taras ne. Ratu neke yosy nus a kseri Tran so, ma heitlulswo mya ma yobak ma tyomolu ode yajar heheke toha raja Salomo, biar ma ratu ne wasi nuske soso ti raja Salomo wasi nuske dakun. Klala senweke, ti wen ne Irkye it a lan a I ma byilak Salomo, keskyede taras neke lema rbuma rtomolu I.” ");
INSERT INTO slu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Lemade Yesuske tyanuk huruk ma byohe, “Kolnye ngkeskwakwe byetik toha irkye, desikemo lema kika wen ma imin ti de, de bya ti de bya ma ti wen bakbak keskes nekre, ma yobak wen ma imin ti, keskye lema itot wen ma imin ti. ");
INSERT INTO slu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dendye tyanuk ma byohe, ‘Lemamo kolik yaw bai wenakw a kola kubetik tohake.’ Lemade ngkeskwaw desike yolik i bai iry a ibetik tohake, desikeo yatos o iry desike yola sey a knanike, ma rsoly a kralake de, ode rasosan ma eras, keskye lema kika iry ma ramin ti sey desy kralake. ");
INSERT INTO slu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lemade ngkeskwaw desike bya ti ryubut ngkeskwakwe itw elik, neke rahatw ksyalik ma rbilak a i, ode yor sir ma rma ma rsukar iry desy huruk ma rmon ti. Dendye iry desike isike ksunw ma lan, ma kbyilak a mamunake dakun. Lemadendye ktela maoly desike, ana kdi ti iry mahatw mamin ti taras ne dakun.” ");
INSERT INTO slu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kyoat Yesuske malmata itun a yor iry ribunke ti sekye krala desy, desike bonyo ena-na yor wainare rma ma rseak I, keskyede lema bisa ma rait a I, kali irire ribun sir a ksyalik ti sey desy, dendye ramdiry ti mloskye bo. ");
INSERT INTO slu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lemade irkye it a lyosu ti Yesuske de byohe, “Enamw yor waimure sir ne mloskye, ma rala ma rseak a O.” ");
INSERT INTO slu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Keskye Yesuske hyalas iry desy ma byohe, “Esei ne enakw a i ne de? Ode esekar ne waikw a sir ne de?” ");
INSERT INTO slu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lemadendye Yesuske syusu sara wasi matoha Iare, ode tyanuk ma byohe, “Iry nekre enakw o waikw a sir. ");
INSERT INTO slu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kali kolnye esei desike tyomolu ode lyakut a tyoha Amakw mamin ti wen sra eraske ibuke, desikeo i desike enakw i, ode waikw i, dete lemamo rahyetakw i.” ");
INSERT INTO slu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti sew desike dakun o, Yesuske byetik toha sey desike kralake, ma bya ti tyaklulw ti namwata Tasi Kakan Galileake. ");
INSERT INTO slu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Desikeo iry ribunke rma ma rkoal Yesuske ti desy, ma rtomolu nam iajarare. Lemade syai ei aroke it ti tyaklulw ti kralake, klala iry ribun desikre ramdiry ti laranke khahake bo. ");
INSERT INTO slu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ode kyalamo Yesuske iajar irire ne, neke yal tun inahliakare ma yajar sir. Dendye kyoat yajar iry ribun mamdiry ti laranke khaha desikre, desikeo yal tun inahliakke it ma yajar sir ma byohe, “Iry manoha boke it ma kyay a hina hinkye ti wasi boke kralake. ");
INSERT INTO slu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ode kyoat ikay a hiny desy bonyo, hiny desike dum a kdi ti salke kserike, dendye manunare rorw ma ra ma ktei. ");
INSERT INTO slu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ode hiny desike tebikan a kdi ti lasmyer maniniaske, ma hatkwe kimin ti lasmyer desike kletike. Hiny madi ti lasmyer maninias desike samlurw o ktyuhw. ");
INSERT INTO slu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Keskyede kyoat sekwe ibetik bonyo, hiny matuhw desike kmyalas, kali kawanare lema kbya demdemw. ");
INSERT INTO slu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ode hiny desike tebikan a kdi ti sitw o karkyari krala, ma ktyuhw, keskye lema kisi, kali sitw o karkyary desikre klyean a kyor hiny desy, ma kyah a hiny desy ma lema kisi. ");
INSERT INTO slu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ode hiny desike tebikan a kdi ti lasmyer maiskye, ma ktyuhw ma kisi. Kyoat kisi bonyo, kusunare ratsam neke dum a kisinare hean-telw kbyilak, dum a kisinare hean-nem a kbyilak, ode dum a kisinare atw kbyilak dakun.” ");
INSERT INTO slu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kyoat Yesuske tyanuk tun inahliak desy maktei bonyo tyanuk ma byohe, “Ese ika molu desikemo musti mo tyomolu!” ");
INSERT INTO slu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lemade Yesuske wasi matoha Iare rma ma rena I ma rbohe, “Tuanggurw! Kyanmwane mutanuk tunare ti iry nekre mo, muhliak tunare ne de?” ");
INSERT INTO slu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lemade Yesuske hyalas wasi matoha Iare ma byohe, “Ei neke Hulasokwe yal eraske ti e, ma mhye nam mahunik i ti ktela Hulasokwe ihareta kola Rajake ti irire ralat a kralanare ne, klala sir desike lema rhe. ");
INSERT INTO slu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dendye mnyenas! Esei desike byuma tyomolu nam Hulasokwe iajarare, desikeo ana Hulasokwe lyosu kbuanare ti i, ode ana tyabal heheke ti i ma hye ma kbyilak. Klala esei desike lema byuma tyomolu nam Hulasokwe iajarare, biar ma hye kbuanke tebikan dakun, keskyede ana Hulasokwe yal a yolik toha ike bo. ");
INSERT INTO slu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Khyali desike mane, kajar sir a kyor tun inahliakare, ma biar ma ratos, keskyede lema rmatakit, ode biar ma rtomolu, keskyede lema rhe kbuanare. ");
INSERT INTO slu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Koldyesy ma nam Yesaya iry a manety Hulasokwe wasi nyanoke ikeskye kdi ti, neke kolnye: ‘Ana ei neke mtyomolu ode mtyomolu, keskye ana lema mhye kbuanare, ode ana myatos ode myatos dakun, keskye ana lema mhye o nam sai ne ana kidi ti ne. ");
INSERT INTO slu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kali bangsa neke ralatare ngkora de, kali rkok eta matatare ode rbakas eta molutare de. Rala koldyesy ma matatare kete kmyatakit, ode molutare kete ktyomolu namit-namit. Ode nam dum a kkyahat eta huhutare ma lema rrekan a rhe de. Ma kete rulak sir ma Yaw ma knwoha wait kbainare ma eras sir.’” ");
INSERT INTO slu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lemadendye Yesuske tyanuk huruk ti wasi matoha Iare ma byohe, “Keskyede Hulasokwe yal eraske ti e, ma bisa ma myatos ktela kuala nekre mumu, ode bisa ma mtyomolu nam kuajar nekre mumu, ma mhye. ");
INSERT INTO slu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ode mtyomolu mamak nam kutanuk ne! Heitlulswo iry manety Hulasokwe wasi nyanoare, ror iry a mlaire, robak ma ratos nam a miatos nekre, keskyede rmaty de, dendye lema ratos. Ode robak ma rtomolu nam mitomolu nekre, keskyede rmaty de, dendye lema rtomolu. ");
INSERT INTO slu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Koldyesikemo mtyomolu tun kuhliak ti iry manoha boke ti ikay hinkye ne kbuanke, neke kolnye: ");
INSERT INTO slu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hiny a madi ti salke kseri desike, kola ne iry a matomolu tun malosu ohe, Hulasokwe byuma hyareta kola Rajake ti irire ralat a kralanare ne, keskye iry a matomolu tun desikre lema rhe kbuanke. Dendye ngkeskwakwe mya ma isoruk Hulasokwe tuna desy toha iry desikre. ");
INSERT INTO slu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ode hiny madi ti lasmyer mamin ti hatu khaha desikre, kola dene iry matomolu Hulasokwe tunanare ma rtohak, ode ramukmuka sir. ");
INSERT INTO slu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Keskye wait tohtohakke lema malkyakaw. Dendye kyoat masunkwe kdyan sir, dete lemamo roban de rtaba sir khyali Hulasokwe tuna desikre, desikeo ra-la toha wait tohtohakke huruk. ");
INSERT INTO slu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ode hiny madi ti sitw o karkyari krala desikre, kola dene iry a matomolu Hulasokwe tuna desikre ode rtohak, keskye seure kiliku i, desikeo ralatare kakan ti wait mormyorifare o ana eras ta atyat, ode ral wait mormyorifare ti malolkye bo. Ma khyury ma Hulasokwe tuna desikre ktyuhw ti ralat a kralanare, keskye lema kika kisi. Dendye wait tohtohakke lema kika kbuan ti sir. ");
INSERT INTO slu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Klala hiny madi ti lasmyer maiskye, kola dene iry madakin ma rtomolu ode rtoha Hulasokwe tunanare ne, ode rsosan mamamak ti ralat a kralanare. Iry desikre wait tohtohakke ti Hulasokwe ne malkyakaw, dendye rala ktela erasare kmyesan bo, kola dene hiny a matuhw ma kisinare ribun ne. Ma kola ne ttan hinkye sasam, desikeo kisike hean-telw kbyilak, dete lemamo kisike hean-nem a kbyilak, dete lemamo kisike atw kbyilak dakun.” ");
INSERT INTO slu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuske tyanuk tun inahliakke it huruk ti iry ribun desikre ma byohe, “Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene iry manoha boke, ma ti tyan hiny a gandum eras-eras nekre ti wasi boke. ");
INSERT INTO slu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Keskyede kyoat metdyet a kditlan ma irire renaf mumu de, desikeo iry mamnisik boke kebu desy, neke mya ma yabur a wakwe khunanare ti bo gandum desy, maktei o ila bya. ");
INSERT INTO slu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ode kyait ma gandum desike kituhw ma ana kihun bonyo, wakwe ktyuhw dakun ti bo gandum desy. ");
INSERT INTO slu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lemade kyoat a makarya ti bo desikre raatos bo desy bonyo, rma ma rtanuk ti boke kebu desy ma rbohe, ‘Amo, kola mtwan hiny eraske ti wasimw bo ne e? Ode kolkyabei mane wakwe kituhw ti dakun ne de?’ ");
INSERT INTO slu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dendye boke kebu desike hyalas sir ma byohe, ‘Iry mamnisik yaw ne it a totanare desy.’ Dendye makarya desikre rtanuk ti i ma rbohe, ‘Amo, mbwuma aramy mbya ti mhyuty wakw desy ba e?’ ");
INSERT INTO slu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Keskyede boke kebu desike tyanuk ti makarya desikre ma byohe, ‘Kete! Kali ana kolnye mhyuty wakwe, desikeo ana gandumke kimhuty dakun. ");
INSERT INTO slu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","De mlyura ma deruke ktyuhw mais bo, nini kyait sew a rakety gandumke bo. Kali ana kyait sew a inaketkye, desikeo ktwanuk ti maketire ma kbwohe, “Kolnye mikety maktei, desike bonyo miwahuk gandum desikre ti wasikw sey nuskwe, maktei bonyo mhyuty wakw desikre ma miutun, ode myal akye ti.”’” ");
INSERT INTO slu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Maktei o Yesuske ihes tun inahliakke it huruk ti iry ribun desikre ma byohe, “Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene lasyeke khatuke, ma irire ral ma rtan ti wait boare. ");
INSERT INTO slu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma lasye neke khatuke kakakan a ksyalik ti nam ribun ida nekre khatunare. Keskyede kolnye kyait ma ktyuhw, desikeo atat ma kbyilak nam salik ratan nekre, ma manunare rma ma raka nukat ti ksananare.” ");
INSERT INTO slu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Maktei o, Yesuske ihes tun inahliakke huruk ti iry desikre ma byohe, “Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene wamfwetare ma ral ragike tebikan, ode rahora ktyabal teriguke kadutke sasam, ma kbyes nini lan.” ");
INSERT INTO slu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ode kolnye Yesuske yajar irire mo, yal tun inahliakare kmyesan ma yajar sir, ");
INSERT INTO slu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ma ktyoha tun Hulasokwe itanuk ti wasi manety nyanoare ma rakesy ne, neke kolnye: “Ana kal tun inahliakare ma kajar irire, Ode ana klwosu nam a mahunik iare ti kyoat heitlulswo Hulasokwe iala nuske ktem ne.” ");
INSERT INTO slu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuske yajar iry ribun desikre maktei bonyo, tyutuk sir ti desy ode syukar ei sey imin tike kralake. Dendye wasi matoha Iare rma ma rtanuk ti I ma rbohe, “Tuanggurw, mlwosu inahliak a wakwe kituhw ti boke ne, neke kbuanke ma aramy.” ");
INSERT INTO slu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lemadendye Yesuske hyalas sir ma byohe, “Iry a makay a hiny eraske neke Irkye Ananke. ");
INSERT INTO slu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ode boke neke kola ne nuske ktem ne. Hiny eras desike kola ne Hulasokwe wasi irire, klala wakwe kola ne ngkeskwaure wait uskwe khatuke wasi irire. ");
INSERT INTO slu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ode iry a mamnisik boke kebu desy, ma ti iabur a wakwe khunake ti bo desy, neke yola dene ngkeskwaure wait uskwe khatuke. Ode sew inaketkye, neke kyoat nuske ktem ne klyodur. Ode iry maketire, neke Hulasokwe wasi nyaso manosy laitare. ");
INSERT INTO slu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ode ktela rautun wakw desikre ma ranal akye ti ne, kola dene nam ana madi ti, ti kyoat nuske ktem ne ana kilodur ne. ");
INSERT INTO slu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kali ana ti sew desy dakun o, Irkye Ananke ana yaso wasi nyaso manosy laitare, ma rawahuk a iry a mahury ma irire radi ei lim o sal nekre, rtabal iry a maala ktela atyatare mumu ne, ma raditi sir toha iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma iry a maala ktela atyat desikre mumu ne, ana rotuk sir ei ay malehurke kralake. Ode ti desike ana masunkwe lan a ksyalik ode serserke lan dakun. ");
INSERT INTO slu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kyoat desike ne iry a mlaire ana rdelaf kola sekwe ranrananke, ti wen sra eras Amat Hulasokwe imin tike. Lemadendye esei desy ika molu, desikemo musti mo tyomolu.” ");
INSERT INTO slu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Dendye Yesuske ihliak tunke it huruk ma byohe, “Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene, maloly lan ne ma ksyuruk i ti lasmyerke it a krala. Ode irkye it a lyakut ti lasmyer desy nini itot maloly lan desy, desikeo imukmuka i a ksyalik. Dendye kyaly kuranke ma syosan mamak maloly desy ti lasmyer desy huruk. Ode khyali maloly lan itot desy, dendye bya ti kyeta wasi lan o hnutan nekre mumu, ode yal khesinare ma yal ma lyiw a lasmyer desy. ");
INSERT INTO slu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kola dene ti iry mabuma Hulasokwe ihareta kola Rajake ti ralake kralake ne, neke yola ne iry maketa namke it ma yobak a hilkye nisi maka khesi lanke. ");
INSERT INTO slu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ma kolnye itot a hilkye nisi maka khesi lan desy bonyo, bya ti kyeta wasi lan o hnutan nekre mumu, ma yal khesinare ma yal ma lyiw a hilkye nisi maka khesi lan desy.” ");
INSERT INTO slu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesuske tyanuk huruk ma byohe, “Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene darkye ma rtunik ti tasike, ma knyal a masy a salno salik nekre mumu. ");
INSERT INTO slu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma kolnye knyal masire mo ratai kmata ti dary desy, desikeo rhait dary desy ei rake, ode rtaklulw ma rolik masy desikre toha dary desy. Maktei o rilik masy erasare ma rluk sir ti wait airare, klala masy atyatare, desikemo rotuk sir ba bo. ");
INSERT INTO slu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kola dene kyait ma nuske ktem ne klyodur, desikeo Hulasokwe wasi nyasoare rosy laitke, neke ana rma ma rasali iry a mlaire toha iry a atyatare. ");
INSERT INTO slu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dendye nyaso desikre rotuk iry a atyat desikre ei ay malehurke kralake. Ode ti wen desike ana masunkwe lan a ksyalik ode serserke lan dakun.” ");
INSERT INTO slu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lemadendye Yesuske yena wasi matoha Iare ma byohe, “Mhye inahliak nekre kbuanare mumu deny e?” Desikeo Yesuske wasi matoha Iare rhalas I ma rbohe, “Ou Tuanggurw, aramy mhye kbuanare mumu de.” ");
INSERT INTO slu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lemadendye Yesuske tyanuk ti sir ma byohe, “Koldyesike mane ei ne heit a myola iry a mahe snurat o tnyetak Musake, ma nenmo mtyohak nam kuajar ti ktela Hulasokwe ima ma ihareta kola Rajake ne. Desikemo myola dene sekye kebuke it, ti itot maloly a harharkwe, ma yal ma ktyabal wasi maloly a mtuke, ma iwahuk deruke ode ihe ti wasi irire.” ");
INSERT INTO slu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kyoat Yesuske ihes tun inahliak desikre mumu maktei bonyo, byetik toha wen desy, ");
INSERT INTO slu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma lyakut bai hnu Nazaretke, neke hnu a lan a I tike. Desikeo byai sey a rasambayan tike, ma yajar irire. Desikeo iry desikre rheran a ksyalik, ode rtanuk ma rbohe, “Iry neke yosy kabei mane hye ei lulw o lyaw ne de? Ode yal haretke toha kabei mane iala ktela masalsyalik iare ne de? ");
INSERT INTO slu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","De lema I neke ama-na ika tukan aw e? Ode lema ena-na ani Maria, ode wainare sir ne: Yakobus ta, Yusuf ta, Simon ode Yudas ne e? ");
INSERT INTO slu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ode rahyetanare sir ne ranor ity ti ne e? Ode kyosy kabei ne ihe nam ribun nekre mumu ne de?” ");
INSERT INTO slu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iry desikre rrekan koldyesy, dendye lema rou ma rtomolu Yesuske, ma khyury ma lema rtohak ti I. Lemade Yesuske tyanuk ti sir ma byohe, “Iry a manety Hulasokwe wasi nyanoke, neke ralan I ti kabei ta kabei bo, klala ti wasi hnuke kmyesan neke lema ralan a I.” ");
INSERT INTO slu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dendye khyury ma Yesuske lema yala ktela masalsyalik iare ribun ti hnu desy, kali ti desike ribun a lema rtohak ti I. ");
INSERT INTO slu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kyoat desike Herodes Antipas ika raja ma hyareta ti propinsi Galileake, desikeo tyomolu Yesuske abritake ti nam ialanare. ");
INSERT INTO slu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Lemadendye tyanuk ti wasi makaryaare ma byohe, “Yesus a mihes neke, Yohanes Mababtis a kutabahunw a i ne i desy! Ma myorif huruk toha mamatire, mane haret lan ne kimin a i, dendye bisa ma yala ktela masalsyalik iare.” ");
INSERT INTO slu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Raja Herodes tyanuk koldyesy, kali kyoat lenla tyomolu Yesuske abritake bonyo, Herodes yaso wasi suldatare ma rkumak a Yohanes Mababtiske, ode ral ranteke ma rdalun i, maktei o rluk a i ti sey metmetke kralake. Herodes yala koldyesy, ma kyaluka sawa Herodias ne ralake kralake. Herodias neke heit a Filipus sawa i, ma raja Herodes isoruk i toha wai Filipus ne, ma yal i ma isaa yor i de. ");
INSERT INTO slu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Keskyede Yohanes Mababtis neke lema you ktela raja Herodes iala desy, dendye kyaki-kyaki ne Yohanes tyerik raja Herodes, ma byohe, “Lema bisa ma musaa mor Herodias, kali waimw a Filipus sawa-na i desy. Kali kolnye ktyoha tnyetak Musake, desikeo tnyetak desike kbyu eta ity ma kete tasaa tor ity waitare sawatare.” ");
INSERT INTO slu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lemadendye raja Herodes yobak ma tyabahunw a Yohanes, keskyede imtaut a iry ribunke, kali rbohe Yohanes neke iry manety a Hulasokwe wasi nyanoke it ne. ");
INSERT INTO slu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Keskyede kyoat a raja Herodes wasi sew a radur i tike kdi ti, desike bonyo ika kalkal. Ode ti wasi kalkal desy, yabuk Herodias anan wamfwetke, ma mya ma myenari ti ia yor wasi mwakunare wait lulululw ne. Ode warar mur desike wasi menari desike khyury ma Herodes ralake ksyenan a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Lemadendye raja Herodes ihatetak ti warar mur desy ma byohe, “Kolnye muten sai toha yaw, desikeo ana kal nam mutenke ti o bo.” ");
INSERT INTO slu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dendye warar mur desike ena-na yaso i ma bya ti tyanuk ti raja Herodes ma byohe, “Amo, kuten ma mal Yohanes Mababtiske usuke khatuke ti mbinan helhelake kralake, ode mal ma yaw.” ");
INSERT INTO slu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kyoat Herodes itomolu warar mur desike nam itenke bonyo, syesal tenanke. Keskye lema bisa ma byity suka wasi hatetak desy de, kali wasi mwakun desikre rtomolu wasi hatetak desy dakun de. Dendye musti mo tyoha nam ihatetak desy. ");
INSERT INTO slu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Lemade Herodes yal haretke elik ti wasi suldat majakke it, ma byai sey metmetke ti syoby ohut Yohanes Mababtiske telake. ");
INSERT INTO slu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Maktei o suldat desike yal Yohanes usuke khatuke ti mbinan helhelake kralake, ode yety ba ti warar mur desy. Maktei bonyo warar mur desike yety ba ti yal ti ena. ");
INSERT INTO slu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ode ktela desike kidi ti maktei bonyo, Yohanes wasi matoha iare rma ma ral Yohanes tbunanke, ma ti ramlin a i. Maktei bonyo rulak sir ma rba ti rlosu ktela madi ti Yohanes desy ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kyoat Yesuske itomolu brit desy bonyo, yor wasi matoha Iare rsai aroke ma rbetik toha wen desy, ma rbai wen kele ratelinke it ti ramin ti. Keskyede iry ribunke ratomolu ma Yesuske ana ibai wen kele ratelin desy bonyo, rbetik toha wait nus o hnu nekre, ma rlakut rosy sal rake ma ti rakita Yesuske ti wen desy. ");
INSERT INTO slu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ode kyoat Yesuske rsara sir ma yorw toha aroke ei laranke khahake bonyo, yatos o irire ribun sir a ksyalik, ma khyury ma lyobak sir. Lemadendye nyoha iry a isy masunure wait a kbainare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ode kyoat sekwe yala ma idi bonyo, Yesuske wasi matoha Iare rma ma rtanuk ti I ma rbohe, “Amam Lan O, wen neke kele rtelin, ode sekwe yala ma dyi mane. Lemamo maso iry ribun nekre ma rbai hnu maney nekre, ma bisa ma ti rliw a kotw o abw ti hnu desikre ma ra.” ");
INSERT INTO slu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Keskyede Yesuske tyanuk ti wasi matoha Iare ma byohe, “Lema koldyesy! De musti mo ei neke myal kotw ti iry nekre ma ra.” ");
INSERT INTO slu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Desike bonyo wasi matoha Iare rhalas I de rbohe, “Amam Lan O! Mane ara hinamy a rotkye enasim ode maskye enaru bo.” ");
INSERT INTO slu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Lemade Yesuske byohe, “Desikemo myety kotw desikre ma katos aduk.” ");
INSERT INTO slu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesuske iatos kotw desikre bonyo, yaso iry ribun lan desikre ma rtaklulw a tnyei na khahanare ti desy. Ode yal a roty desim desy ktyabal masy deru desy, maktei o yatnyarak ei laitke ode syalak eraske ba ti Hulasokwe ti khyali kotw desikre. Maktei bonyo byini-byiny a roty o masy desikre, ode yeta ti wasi matoha Iare ma rasakar ti ribun lan desikre, ");
INSERT INTO slu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ma raktemtem a ra nini rbesur, ma kteranare kimin a nggora. Dendye Yesuske wasi matoha Iare rili rahuk roty o masy ktera desikre, desikeo kbyenw a kolakye hean a kresi enaru. ");
INSERT INTO slu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iry a maknam desikre mumu neke aryaritke, wamwany a lanare rmesan bonyo, irkye ribunke enasim sir. Klala lenla raki wamfwetare ror namanare ti ktyabal. ");
INSERT INTO slu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kyoat iry ribun desikre raknam maktei bonyo, Yesuske yaso wasi matoha Iare ma rsai aroke ma rmuna I bai tasi kakanke seridake. Maktei o yulak I ma yaso iry ribun desikre, ma rulak sir bai wait nus o hnu. ");
INSERT INTO slu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kyoat iry ribun desikre raba bonyo, Yesuske syai ei kususwanke ti myesan, ode syambayan. Ma ti metdyet desike myesan ti wen desy bo. ");
INSERT INTO slu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ode kyoat Yesuske wasi matoha Iare wait aroke soso toha rake bonyo, eskwe kyosy lulkwe ode mety ksyalik, ma khyury ma besanare lan ma ksyumuk de khyau aro desy. ");
INSERT INTO slu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ode anakyai kyoban enatelkwe ti kinoh ma nyamo ne, desike bonyo Yesuske lyakut ti tasike khahake ma tyoha sir. ");
INSERT INTO slu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kyoat Yesuske wasi matoha Iare ratos Yesuske ma lyakut ti tasike khahake, desikeo rakeni I ma rbohe, “He! Anakyai watkwe kebuke I ne!” Dendye raktemtem mumu neke ratos I bonyo, rboran kali ramtaut ma ramlulurw. ");
INSERT INTO slu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Keskyede samlurkwe bonyo, Yesuske tyanuk ti sir ma byohe, “Hei, mamwaw e! Kete mimtaut! Kali Yaw ne.” ");
INSERT INTO slu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dendye Petrus a yatela ma hyalas Yesuske ma byohe, “Ebo, kolnye Oi ne bain mo, maso yaw ma klwakut ti tasike khaha ne dakun ma ti kait a O.” ");
INSERT INTO slu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lemade Yesuske byu ti Petrus de byohe, “Mmwa nde!” Dendye Petrus a yorw toha aroke, ma lyakut ti tasike khahake ma bya ti yait Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Keskyede kyoat a Petrus iatos ma besanare lan, ode eskwe mety bonyo imtaut, ma khyury ma yala ma tyemar ei tasike kralake. Dendye byoran ma byohe, “Ebo, muboli yaw aduk!” ");
INSERT INTO slu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lemade samlurkwe bonyo, Yesuske yeta simake ti kyumak a Petrus, ode tyanuk ti i ma byohe, “Hei, kyanmwane wasimw tohtohakke lema malkyakaw, ma kihury ma mumtaut ne de?” ");
INSERT INTO slu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ode kyoat deruke rsai ei aroke bonyo, esw desike kele rteka elik. ");
INSERT INTO slu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ode Yesuske wasi matoha I mamin ti aroke krala desike, rsakitil ode rou ti Yesuske, ma rtanuk de rbohe, “Mlay bain! Oi neke Hulasokwe Anan a O.” ");
INSERT INTO slu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ode kyoat Yesuske yor wasi matoha Iare ranait tasi kakanke seridake, desikeo rsara sir ti hnu Genesaretke. ");
INSERT INTO slu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma sew desy dakun o, nenmo iry ribunke rhe ohe Yesuske imin ti desy. Lemade ti rabrita Yesuske Anike ti nus o hnu mamin ti desikre. Ma irire ror wait iry a klurukare mumu ne ba ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ode iry desikre raten toha Yesuske bain-bain ma, iry a kluruk desikre bisa ma rkambil a Yesuske wasi rabit narnarkwe kninike bo. Dendye kyoat iry a kluruk desikre rakambil Yesuske wasi rabit narnarkwe kninike bonyo, wait kbainare kitayar elik ma eras sir mumu. ");
INSERT INTO slu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sekwe it bonyo iry a manosy lui Farisi-nare dum, ror iry a mahe snurat o tnyetak Musake dum, neke rbetik rosy a Yerusalem, ma rma ma rait a Yesuske. Ode rena I ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kyanmwane wasimw a matoha Oare lema ratoha Yahudi ity ne, ity ebnwo matrumat a wait ktelanare ne de? Ma musti mo rut simatare aduk, maktei o nenmo raknam.” ");
INSERT INTO slu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Lemade Yesuske hyalas sir ma byohe, “Kyanmwane e dakun o lema mtyoha tnyetak manosy Hulasokwe, de mtyoha ity ebnwo matrumat a wait ktelanare ne de? ");
INSERT INTO slu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kali Hulasokwe tyanuk de byohe, ‘Musti mo myalan a enamy o amamy; kali kolnye esei desike syusno syoba ena o ama, desikeo musti mo rtunik tnyetak matmyatkye ti i.’ ");
INSERT INTO slu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Keskyede ei neke myajar irire ma rtanuk ti enat o amat ma rbohe, ‘Kete mkyeyer, kali nam a musti mo kunal ti e ma kusaluk e ne, neke lema kal ti e, de kety ba mumu ei sey rasambayan tike, ma rabar ti Hulasokwe de.’ ");
INSERT INTO slu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wasimy ktela miala desikre, myajar irire ma lema ralan a enat o amat ma desy! Mane kihury ma lema mitoha haret Hulasokwe ne, de mbyuma mtyoha ebnwo matrumamy wait a ktelanare bo. ");
INSERT INTO slu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ei ne mikakmet ma myala tenamire ma mlay ti iry ribunke, keskye ti ralami kralanare ne lema mlay! Mtyomolu! Tun a heitlulswo Hulasokwe itanuk ti wasi iry manety nyano Yesaya ne, ma ikesy ti wasi kitabke ne, neke kihes a e bain-bain, ma kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bangsa neke rleru Anikkwe kyor nunut a ktutunare bo, keskyede ralat a kralanare soso toha Yaw ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ode lema kika kbuan ti iry nekre rasambayan ma Yaw ne, kali rbohe nam raajar desikre kyosy tnyetak Hulasokwe. Keskyede nam raajar desikre kyosy a tnyetak irkye bony ma desy.’” ");
INSERT INTO slu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lemadendye Yesuske yabuk iry ribun desikre, ode tyanuk ti sir ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Mtyomolu mamamak nam kutanuk nekre. Lema kika nam ma ksyukar kyosy irkye hahake, ma kyala iry desy ma iray. De nam sai desike kbyetik toha irkye hahake, desikeo nam desike ne kiala iry desy ma iray ne.” ");
INSERT INTO slu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lemade Yesuske wasi matoha Iare rma ma rena I de rbohe, “Tuanggurw, tun mutanuk desikre iry manosy lui Farisi-nare rkoman, ma khyury ma rkeyer.” ");
INSERT INTO slu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dendye Yesuske hyalas sir ma byohe, “Nam sai desike Amakw mamin wen sra eraske lema tyan, desikemo ana hyuty ktyabal kawanare ba mumu. ");
INSERT INTO slu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dendye kete mtyomolu sir, kali sir desike rola iry a matmabolke ma lema myatakit, keskye byuma yety lulkwe ti irire bo. Ma kolnye matmabolke yeuk matmabolke, ana deruke rdi ei kuranke kralake.” ");
INSERT INTO slu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lemade Petrus a tyanuk ma byohe, “Amam Lan O! Kuten ma mlwosu tun muhliak ti nam masukar kyosy irkye hahake ma lema kiala i ma iray ne, neke kbuanke ma aramy.” ");
INSERT INTO slu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Lemade Yesuske hyalas sir huruk ma byohe, “Ei ne dakun o lenla bisa ma mhye inahliak ne kbuanke elik e? ");
INSERT INTO slu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","De lema mhye ohe, kotw a tana nekre ana kyorw ei ity fteitare, maktei o tadaik ba bo. ");
INSERT INTO slu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Klala nam mabetik toha irkye hahake, neke kyosy a ralake kralake, ma nam desike ne kiaraik a i ne. ");
INSERT INTO slu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kali nam atyat ribun lan ne kbyetik kyosy irkye ralake kralake, kola ne: rrekan ti ktela atyatare, dete lemamo rtabahunw iry, ta lemamo rbilak lean sawatare ta laitare, dete lemamo wamfwetare ror wamwanire it de hyury a it koi-kay ma rala ktela atyatare, ta lemamo ranamet, dete lemamo rakakmet, ta lemamo rakanak iry. ");
INSERT INTO slu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nam maoly desikre mumu ne kiaraik irkye ne! Klala kolnye irkye lema yut a simake de iknam bo, desikemo ktela iala desy, lema kyety rakye ti ralake kralake.” ");
INSERT INTO slu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lemade Yesuske byetik toha propinsi Galilea desy, ma byai negara salik, neke nus Tiruske ode nus Sidonke kimin ti. ");
INSERT INTO slu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ode wamfwet a lema Yahudike it ma yosy negara desy, neke mya ma yatela ma tyanuk ti Yesuske ma byohe, “Yesus! Raja Daud tesnwo natu O! Mlwobak a yaw! Kali anakw a wamfwetke ngkeskwakwe syukar a i ma yala i ma isike ksunw ksyalik.” ");
INSERT INTO slu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Keskyede Yesuske lema hyalas enen desy elik. Lemade Yesuske wasi matoha Iare rma ma raten toha I, ma rbohe, “Amam Lan O, lemamo maso enen desy ma bya lakhidik toha wen ne, ma kete tyoha ity ma yal o teltela.” ");
INSERT INTO slu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lemade Yesuske tyanuk ti enen desy ma byohe, “Amaku yaso Yaw ma kmwa ma kswaluk iry a Israel a malakut salare, kali rola dene domba matayar nekre.” ");
INSERT INTO slu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Keskyede enen desike mya ma nyey a Yesuske ma syakitil ode you ti I, ode tyanuk ma byohe, “Ebo, mlwobak yaw.” ");
INSERT INTO slu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lemade Yesuske hyalas enen desy ma byohe, “Lema eras, kolnye kal kotw a rasosan kita namanare ne, ma kotuk ba ti asure ma ra.” ");
INSERT INTO slu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Keskye enen desike hyalas ma byohe, “Ebo, nam mutanuk desy mlay! Keskye asw nekre dakun o, rakita ma ra namanare hinat kotw ktera madi toha mejake ei hahke ne.” ");
INSERT INTO slu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lemade Yesuske hyalas enen desy huruk ma byohe, “Eno, wasimw tohtohakke malkyakaw ksyalik! Dendye nam mutenke kdi ti de, ma ktyoha mubuke.” Lemade kyala mait bonyo, enen desike ananke eras i elik. ");
INSERT INTO slu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kyoat Yesuske byetik toha negara desy ma yulak i bai propinsi Galileake, desike bonyo lyakut a niny a namwata Tasi Kakan Galileake, ma ti syaik bai kususwanke it, ma tyaklulw ti. ");
INSERT INTO slu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dendye iry ribunke lui-lui sir ma rma ma rait a I, desikeo rma o ror iry mablukut o, lwaw mabel o, matmabol o, nunw ktem o, rtabal iry a klurukare dum dakun, ma rtutuk sir daku Yesuske. Dendye Yesuske nyoha wait kbainare ma eras sir mumu. ");
INSERT INTO slu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Neke iry mablukutke imdiry ma lyakut ti de lyakut ma, ode nunu ktemke bisa ma itun, ode lwaw mabelke lyakut eras, ode matmabolke myatakit dakun. Dendye iry ribun mamin ti desikre ratos a ktela desy bonyo, rheran a ksyalik. Lemade raktemtem mumu ne rleru Hulasow a Israel-are rasambayan ti I ne. ");
INSERT INTO slu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kyoat desike Yesuske yabuk wasi matoha Iare, ode tyanuk ti sir ma byohe, “Klwobak iry ribun lan ne a ksyalik, kali sekwe enatelw neke ror Yaw ti wen ne de. Ode lema kika kotw ma ra, kali hinat koture ktei de. Dendye kolnye kaso sir ma rulak sir bai wait seire, desikeo ana kete rlakut nini dum a rlily ti sal a krala kali ramlar.” ");
INSERT INTO slu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dendye Yesuske wasi matoha Iare rtanuk ti I ma rbohe, “Amam Lan O, wen neke kele rtelin, ode ana tal kotw o abw toha kabei ma tal ti iry ribun lan nekre ma ra, ma rbesur de?” ");
INSERT INTO slu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lemade Yesuske yena sir ma byohe, “De hinamy a rotkye enai desy de?” Desikeo rhalas Yesuske ma rbohe, “Rotkye itw bo. Ode masy kakan ne enai bony mane.” ");
INSERT INTO slu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dendye Yesuske yaso iry ribun desikre ma rtaklulw ti lasmyerke khahake. ");
INSERT INTO slu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Maktei o yal roty deitw desy, ode masy kakan desikre, ode syalak eraske ba ti Hulasokwe ti roty o masy desikre. Maktei o byini-byiny a roty o masy desikre, ode yal ti wasi matoha Iare ma rasakar ti iry ribun desikre ma ra. ");
INSERT INTO slu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ode iry ribun desikre mumu ne raknam nini rbesur. Maktei o Yesuske wasi matoha Iare rili rahuk roty o masy ktera desikre, desikeo kbyenw a kolakye itw. ");
INSERT INTO slu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iry matoha ma maknam desikre, neke wamwankye bonyo aryaritke ribunke enaat sir, klala lenla raki wamfwetare ror namanare. ");
INSERT INTO slu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lemadendye Yesuske yaso iry ribun desikre ma rbai wait nus o hnu. Maktei bonyo nenmo Yesuske syai aroke ma rbai lasmyer a nus Magadanke. ");
INSERT INTO slu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ode sekwe it bonyo, iry manosy lui Farisi-nare dum, ode iry manosy lui Saduki-nare dum dakun, neke rma ma robak sal ti Yesuske. Lemade raten toha Yesuske, ma yala nyatos masalik i manosy wen sra eraske it, ma bisa ma rhe ohe, Yesus neke haret manosy Hulasokwe kimin a I ta lema. ");
INSERT INTO slu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lemadendye Yesuske tyanuk ti iry desikre ma byohe, “Kolnye sekwe bya, ode myatos laitke ma mermer, desikeo mtyanuk ma mbyohe, ana bolbol o laitke nelnyely. ");
INSERT INTO slu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ode kolnye bolbolbol ne myatos laitke ma mermer, ode sekwe lema byetik, desikeo mbyohe, sew ne lema eras, kali kyala ma uske. Koldyesikemo bisa ma mikea mhye nyatos mamin ti laitke de, keskyede lema bisa ma mikea mhye nyatosare ti kidi ti taras selsel ne. ");
INSERT INTO slu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ei neke taras iry mahatw a e, ode lema mhye Hulasokwe. Ei neke mbyuma kala nyatos masalsyalik ike ti e. Keskyede ana lema kala nyatos salik ti e de, de cuma mo ana kala nyatoske it ti e, neke nyatos maola nyatos a heitlulswo Hulasokwe iala ti Yunus, iry manety Hulasokwe wasi nyano desy bo.” Yesuske itanuk koldyesy maktei bonyo, tyutuk iry desikre ti desy, ode lyakut ma bya. ");
INSERT INTO slu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kyoat Yesuske yor wasi matoha Iare rait Tasi Kakan Galileake seridake, desikeo wasi matoha Iare nenmo kelersumuk mait sir ma rhe ohe, ramluak ma rety res. ");
INSERT INTO slu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Lemade Yesuske tyanuk ti sir de byohe, “Mijaga mamak e toha iry a Farisi-nare ror iry a Saduki-nare hinat ragike.” ");
INSERT INTO slu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kyoat Yesuske wasi matoha Iare ratomolu tun Yesuske itanuk desy bonyo, it de tyanuk ti it ma rbohe, “Tyanuk koldyesy kali lema tety roty.” ");
INSERT INTO slu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Keskyede Yesuske hye wasi matoha Iare nam rarekanke, lemade tyanuk ti sir ma byohe, “Edowe, mitohak ma Yaw ne lenla malkyakaw! Kyanmwane mitanuk a ktela lema kika roty ne de? ");
INSERT INTO slu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lenla mhye Yaw elik e? De lema mnyenas ti roty desim a kubiny ma misakar ti irkye ribunke enasim ma rana desy e? Ma kteranare miwahuk ti kolakye enai ma kibenw desy e? ");
INSERT INTO slu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","De lema mnyenas ti roty deitw a mihe ti irkye ribunke enaat desy e? Ma kteranare miwahuk ti kolakye enai ma kibenw desy e? ");
INSERT INTO slu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ode kyanmwane lema mihe kbuanke ne de? Mnyenas! Lema ktwanuk rotkye. De nam kutanukke, musti mo mijaga mamak e toha iry a Farisi-nare ror iry a Saduki-nare hinat ragike.” ");
INSERT INTO slu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kyoat desike Yesuske wasi matoha Iare nenmo rhe ohe, Yesuske lema tyanuk ragike ti ranal ma rahora teriguke ne, de byuma rajaga mamak sir toha iry manosy lui Farisi-nare ror iry manosy lui Saduki-nare nam raajar a lema mlaire. ");
INSERT INTO slu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kyoat Yesuske yor wasi matoha Iare rait lasmyer a nus Kaisarea Filipike, desikeo Yesuske yena wasi matoha Iare ma byohe, “Irire rtanuk ma rbohe, Irkye Anankeneke esei de?” ");
INSERT INTO slu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lemade wasi matoha Iare rhalas I ma rbohe, “Irire dum a rbohe, Oi neke Yohanes Mababtiske. Ode irire dum a rbohe, Oi neke Elia O. Ode dum a rtanuk huruk ma rbohe, Oi neke Yeremia O. Ode dum a rtanuk huruk ma rbohe, Oi neke iry a manety Hulasokwe wasi nyano heitlulswoke it ne dakun, ma myorif huruk mane.” ");
INSERT INTO slu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dendye Yesuske yena sir huruk ma byohe, “De ktyoha e mo, mryekan mo esei ne Yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lemade Simon Petrus hyalas ma byohe, “Oi neke Mesias O. Neke Hulasow Mamorifke Anan O!” ");
INSERT INTO slu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lemade Yesuske hyalas i ma byohe, “Simon, Yunus anan o! Eraske kimin a o. Kali tun mutanuk desy lema irkye it a lyosu ti o, de Amakw mamin ti wen sra eraske, I ne ilosu tun desy ti o ne. ");
INSERT INTO slu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lemade ktwanuk ti o ohe, senweke animw a Petrus! Kbuanke o hatw a malkyakakwe. Ma ana kswadiri wasikw gerejake ti hatw a malkyakakwe khaha desy. Ma lema irkye it a bisa ma yulik yal wasikw gereja desy, ma ti kyal matmyatkye lema kyala kyal dakun. ");
INSERT INTO slu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ode ana kal haretke ti o ma mety lulkwe ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne.Ma nam sai mbwu eta ti nuske ktem ne, desikeo ana Hulasokwe byu eta nam desy ti wen sra eraske dakun. Ode nam sai mou ti nuske ktem ne, desikeo ana Hulasokwe you nam desy ti wen sra eraske dakun.” ");
INSERT INTO slu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lemade Yesuske byu eta wasi matoha Iare, ma kete rahes ti esei ta esei dakun ohe, Yesus neke Mesias a I. ");
INSERT INTO slu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ode kyoat desike nenmo Yesuske tyanuk ma syisy hela ti wasi matoha Iare ohe, musti mo I neke byai Yerusalem. Ma ti soke ana hyar masunw ribun lan ne toha iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe neke wait usu khatunare, ror a iry mahe snurat o tnyetak Musake dakun. Ode musti mo rtabahunw a I, keskye ana sekwe enatelw bonyo, myorif huruk. ");
INSERT INTO slu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dendye Petrus byity Yesuske ei kserike, ma tyerik I ma byohe, “Amam Lan O! Kuten ma Hulasokwe yaditi ktela ne toha O, ma kete ktela mutanuk neke kdi ti O!” ");
INSERT INTO slu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lemade Yesuske yulak I ma syara Petrus, ode tyanuk ti i ma byohe, “Ngkeskwaw o, maditi lakhidik o toha ne! Kali oi neke meluk ailhat ma mbwa etno eta Yaw.Ma lema mrwekan nam Hulasokwe irekanke, de mrwekan nam irkye irekanke kmyesan bo.” ");
INSERT INTO slu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dendye Yesuske tyanuk ti wasi matoha Iare ma byohe, “Kolnye esei desike byuma tyoha Yaw, musti mo ibu a ituli tenanke ti sai ta sai bo, ode sew kyaki nekre hyar wasi tul masanwalw ike ma tyoha Yaw. ");
INSERT INTO slu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kali esei desike kyumak eta wasi mormyorifke ti lasmyerke khaha ne, desikemo mormyorhyanke ti wen sra eraske ana kitayar. Klala esei desike tyutuk wasi mormyorifke, ode ires ma myaty khyali tyohak ma Yaw, desikemo ana myorif nini nam ti wen sra eraske. ");
INSERT INTO slu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ode kolnye esei desike wasi malolkye lan, ma ti kyal nuske ktem ne mumu, ode kolnye myaty, keskye lema byai wen sra eraske, de Hulasokwe yotuk i bai wen ay malehur manal nini namke kralake, desikemo wasi maloly desikre kbuan sai ti i de? Kali lema bisa ma iliku wasi maloly desikre kyor mormyorif manal nini namke. ");
INSERT INTO slu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dendye mnyenas! Kali Irkye Ananke ana myaa yor Ama-na wasi madelahke. Ode kyoat desike ana byihy a irkye ma yukun sir, ma ktyoha it o it ne totnyo yabit raalanare. ");
INSERT INTO slu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mtyomolu mamak nam kutanuk ne! Ti ei ne mumu neke, dum a ana lenla mmyaty, kolnye lenla mmyatakit a Irkye Ananke, ma mya kola Rajake ma imdiry ti wen ihareta tike.” ");
INSERT INTO slu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kyoat sekwe nem a kbyilak bonyo, Yesuske yor Petrus, ode Yakobus yor wai Yohanes, neke rsaik bai huar atatke it. Ti desike cuma mo deatke rmesan bo. ");
INSERT INTO slu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ode Yesuske wasi matoha I detelw desike ratos mo, Yesuske ihihi i, ma uno mata ne knyely kola ne sekwe ti iran ne, ode wasi rabitke kihihi i ma bokbokbok ma knyely malay dakun. ");
INSERT INTO slu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ode kyala mait bonyo, Yesuske wasi matoha I detelw desy ratos mo Musa yor Elia ramdiry ma ratun a ror Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Desikeo Petrus tyanuk ti Yesuske ma byohe, “Amam Lan O! Eras a ksyalik ti aramy mimin ti wen ne. Kolnye mou mo kswadiri lasyerkye enatelw, ma sasam ti O, sasam ti Musa, ode sasam ti Elia dakun.” ");
INSERT INTO slu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ode moluk a Petrus itanuk koldyesy bonyo, kyala mait o, oan bokbokke khatuke it a kmya ma kkyahat eta raktemtem. Ode rtomolu teltelke it ma kyosy oanke krala desy, ma ktyanuk ti sir de kbyohe, “Anakkwe I ne, ma klwobak I a ksyalik. Mtyomolu I!” ");
INSERT INTO slu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ode kyoat wasi matoha I detelw desy ratomolu tel desy bonyo, rsakitil ode rou ma nenma rakikisy lasmyerke, kali ramtaut ma ksyeman sir. ");
INSERT INTO slu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lemade Yesuske bya ti kyambil wasi matoha I detelw desy, ode tyanuk ti sir de byohe, “Mimdiry! Kete mimtaut!” ");
INSERT INTO slu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ode kyoat wasi matoha I detelw desy rbitil matatare, desikeo ratos o lema kika iry ti desy de, de lenla Yesuske myesan bo. ");
INSERT INTO slu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dendye kyoat raorw toha huar desy bonyo, Yesuske syurat sir de byohe, “Kete mihes ktela miatos desy ti irkye it dakun, de mikita nini sekwe kdi ti, neke Irkye Anankemyorif toha mamatire, desikeo nenmo bisa ma mihes ktela desy.” ");
INSERT INTO slu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lemade Yesuske wasi matoha I detelw desy rena i ma rbohe, “Tuanggurw! Kyanmwane Iry mahe snurat o tnyetak Musake rtanuk ohe, musti mo Elia imaa kmuna Mesiaske ne de?” ");
INSERT INTO slu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dendye Yesuske hyalas sir ma byohe, “Mlay, Elia iry manety Hulasokwe wasi nyano desy, ana myaa kmuna ma isosan nam ribun nekre mumu aduk. ");
INSERT INTO slu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ode ktwanuk ti e huruk ohe, Elia neke mya de, keskyede irire lema rhe i, de rala i koi-kay ma masunkwe kdyan i, ma ktyoha rabuare bo. Kola ne dakun ti Irkye Ananke, ma ana irire rala I koi-kay ma masunkwe kdyan I dakun, ma ktyoha rabuare bo.” ");
INSERT INTO slu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kyoat Yesuske itanuk tun desikre maktei bonyo, wasi matoha I detelw desy nenmo rhe tun Yesuske itanuk khyali Elia desike, neke kbuanke ohe, Yesuske tyanuk Yohanes Mababtiske ma desy. ");
INSERT INTO slu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Maktei o Yesuske yor wasi matoha I detelw desike rorw rosy a huarke srake ei hahke, ma rait a wasi matoha idanare, ror iry ribunke ma malmata rakita I ti desy. Desikeo irkye it a mya ma syakitil ode you ti Yesuske wasi lulululw ne ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Amam Lan O! Mlwobak anakkwe, kali kluruk i ma lan a ksyalik, ma kola dene ihukat ne, ma khyury ma seure rait mo dyi ei akye kralake, ode seure rait mo dyi ei werke kralake dakun. ");
INSERT INTO slu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Daike kuten toha wasimw matoha O nekre de, ma rnoha anakkwe wasi kbai desy, keskyede lema rala ral wasi kbai desy.” ");
INSERT INTO slu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lemade Yesuske tyanuk ti iry ribun desikre mumu ma byohe, “Hei, taras lema matohak e, ei neke lema mhye mibasara de! Dendye ana kor e nini kolkya? Ode ana kukita nini hekyab o mtyohak Yaw de? Amo, mor anamw desy ma.” ");
INSERT INTO slu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lemadendye ror naman desy ba ti Yesuske, ode Yesuske telake lan ma yaswel ngkeskwaw desy, ma jam desike ngkeskwaw desike byetik toha naman desy, ma naman desy eras a i elik. ");
INSERT INTO slu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maktei o Yesuske yor wasi matoha Iare rba ti ramin ti wenke it ma rmesan, desikeo wasi matoha Iare rena I ma rbohe, “Tuanggurw, kyanmwane lema bisa ma aramy myesak a ngkeskwaw desike ne de?” ");
INSERT INTO slu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Desike bonyo Yesuske hyalas ma byohe, “Kali ei neke wasimy tohtohakke lenla malkyakaw! Dendye mtyomolu mamak nam kutanuk ne! Biar ma ei neke wasimy tohtohakke kakan ma kdeda lasyeke khatuke dakun, keskye bisa ma myaso huar atat ne ma mbyohe, ‘Huar o! Muhmua toha ne ma mbwai so!’ Desikemo ana huar desike kihmua ike bo. Kali lema kika nam mitanuk ma ana lema kdi ti.  ");
INSERT INTO slu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Keskyede kolnye mbyuma myesak ngkeskwaw maoly ne, desikemo myas ode msyambayan aduk. Ma Hulasokwe yal haretke ti e, mamode nenmo bisa ma myesak myal ngkeskwaw maoly desy.” ");
INSERT INTO slu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kyoat Yesuske yor wasi matoha Iare rawahuk sir ti Galilea huruk, desike bonyo Yesuske tyanuk ti sir ma byohe, “Lema soso bonyo Irkye Ananke ana ral I ba ti iry mahature ma rhareta I. ");
INSERT INTO slu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ode ana rtabahunw a I. Keskye sekwe enatelw bonyo, ana myorif huruk toha mamatire.” Kyoat Yesuske wasi matoha Iare ratomolu tun itanuk desy bonyo, ralatare ksyal a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kyoat Yesuske yor wasi matoha Iare ranait a hnu Kapernaumke bonyo, iry a kyalamo maily usw a Hulasokwe Seike ne, it a mya ma tyanuk ti Petrus ma byohe, “Kyalamo wasimy Tuanggurkwe yal kuban blyawan bokbokke enaru ma syelw a usw a Hulasokwe Seike ta lema de?” ");
INSERT INTO slu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Desikeo Petrus hyalas ma byohe, “Ou, kyalamo syelw.” Ode kyoat Petrus yulak i bai sey a Yesuske imin tike, ma lenla itanuk namit-namit bonyo, Yesuske yena i a kmuna ma byohe, “Petrus o, kolnye ktyoha o mo, raja-nare ti nuske ktem ne kyalamo rily uskwe toha wait masyarakatare, ta raja desikre rataut iry salik ma rselw uskwe ti sir de?” ");
INSERT INTO slu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dendye Petrus a hyalas ma byohe, “Rily toha iry salik!” Lemade Yesuske tyanuk ti Petrus de byohe, “Koldyesikemo ity neke lema tselw a uskwe, kali raja nekre wait masyarakat ity dakun. ");
INSERT INTO slu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Keskyede ma kete khyury ma maily usw desikre usut a khatunare ksunw ma rkeyer a ity, desikemo mbwa ti mail ti tasi kakanke. Ode masy a mamuna mubitkye, desyo mnwan hahake, kali kuban blyawan bokbokke enaat desy kimin ti hahake kralake. Dendye mal a kuban desikre, ode mbwa ti mswelw a ituru ity wait usw a Hulasokwe Seike ti sir.” ");
INSERT INTO slu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kyoat desike Yesuske wasi matoha Iare rma ma rena I ma rbohe, “Tuanggurw, esei ne ana lan i ti kyoat Hulasokwe ima ma ihareta kola Rajake ne de?” ");
INSERT INTO slu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lemade Yesuske yabuk naman kakanke it, ode yaso i ma imdiry ti wait a kditlalan ne, ");
INSERT INTO slu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ode tyanuk ma byohe, “Mtyomolu mamak nam kutanuk ne! Esei desike lema tyunik totnyo yabi atyat desikre ba, ma tyohak ti Hulasokwe kola naman kakanke, i desike ana Hulasokwe lema wasi iry a i. Kali Hulasokwe wasi irire sir ne, iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Klala esei desike nyauk tenanke ma babaf kola naman kakanke, desikemo i desike lan a i ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ode esei desike kolnye khyali Yaw, desikeo you ma yal iry a lema maber o ktyahal maola naman kakanke ne,desikemo ktela iala desike kola ne you ma yal Yaw dakun ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ode Yesuske tyanuk ti sir huruk ma byohe, “Esei desike hyury a iry a wasi tohtohakke lenla malkyakaw ma Yaw ne,ma dyi ei lim o sal, desikemo iry mahury desike, ana Hulasokwe yukun i o ksunw ksyalik, ma kbyilak ti kolnye rikat a hatw lan ne ti iry mahury desike telake, ode rtolar i ei tasike kralake. ");
INSERT INTO slu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ode ana atyatke kidurak nuske ktem ne, kali rhury irire ma rdi ei lim o sal. Mlay bain, hurhury neke kimin ti nuske ktem ne a nggora, keskyede kolnye esei desike yala ktela kihury ma irire radi ei lim o sal ne, ana atyatke kdyan iry maala ktela desy. ");
INSERT INTO slu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dendye kolnye simamkwe serit a khyury ma mala lim o sal, ta lwaumkwe serit a khyury ma mala lim o sal, desikemo mal turike ma mtwusy ohut lwaumw ta simamw desy ma motuk ba. Kali lemamo mmworif ti wen sra eraske nini nam a mor lwaumkwe serit, ta simamkwe serit, desike ne eras ma kbyilak ti kolnye mbwuma mmworif mor lwaumw deru desy, ta simamw deru desy, keskyede ana rotuk o bai ay malehur nini namke kralake. ");
INSERT INTO slu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ode kolnye matamkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mhwakilw matamkwe khatu desy ba! Kali lemamo mmworif ti wen sra eraske mor matamkwe serit, desike ne eras ma kbyilak ti kolnye mmworif mor matamw deru desy, keskyede ana rotuk o bai wen ay malehur nini namke kralake. ");
INSERT INTO slu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mnyenas! Kete mikanak iry a lema maber o ktyahal maola naman kakan nekre, kali Hulasokwe wasi nyaso manosy laitare kyaki-kyaki ne rajaga mamak iry a lema maber o ktyahal desikre. Ode nyaso desikre dakun o, kyaki-kyaki ne ramdiry ti Amakw wasi lulw ne ti wen sra eraske.  ");
INSERT INTO slu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kali Irkye Anankeima ne, neke mya ma yaorif iry malakut sal nekre! ");
INSERT INTO slu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesuske tyanuk huruk ma byohe, Ti ei ne mumu neke ese wasi dombake atw, ma kolnye sasam itayar, desikeo ana yala sai de? De lema iry desike tyutuk domba dehean-siw kresi siw desy ti wenatke, ode bya ti yobak sasam matayar desy e? ");
INSERT INTO slu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mtyomolu mamak nam kutanuk ne! Kolnye itot domba sasam matayar desy, desikeo imukmuka imarmara i khyali domba sasam matayar desy, ma kbyilak ti domba hean siw kresi siw lema matayar desikre. ");
INSERT INTO slu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kola dene Amamy mamin ti wen sra eraske, lema you ma iry a wasi tohtohakke lenla malkyakaw ne, it a itayar dakun.” ");
INSERT INTO slu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesuske tyanuk ma byohe, “Kolnye waimw matohakke it a yala sal ti o, desikemo mbwa ti mait i, ma muhes tun a mor i ma mlwosu sal ialanare. Keskye kete kika iry mahe, de miru ne mhye bo. Ode kolnye tyoha nam mutanukare, ma you ohe nam iala desikre sal, desikemo inaka eraske kimin a e huruk ma desy. ");
INSERT INTO slu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Keskyede kolnye lema tyomolu nam mutanukare, desikemo mabuk irkye sasam ta enaru ma ti rait a o, ma mor sir ma mbyai iry desy huruk. Ma bisa ma iry desikre rtanuk a mlakye ti waimw desy ohe, i desike sal a i. ");
INSERT INTO slu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ode kolnye lema tyomolu iry desikre wait snuratare dakun de, desikemo ti mlwosu ti ribun matohakare ti wen rawahuk sir tike. Ode kolnye lema you ma tyomolu ribun matohak desikre dakun, desikemo kete muka lui mor i, de mrwekan o, i desike ihatw kola iry maily usure, dete lemamo yola iry a lema mahe Hulasokwe ne. ");
INSERT INTO slu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Lemade mtyomolu mamak nam kutanuk ne! Nam sai desike mbyu eta ti nuske ktem ne, desikeo Hulasokwe byu eta o wen sra eras imin tike dakun. Ode nam sai desike mbyohe mlay ma myala ti nuske ktem ne, desikeo Hulasokwe you ohe nam desike mlay o wen sra eras imin tike dakun. ");
INSERT INTO slu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ode mtyomolu mamak nam kutanuk ne! Kolnye ti ei neke irkye enaru, ma rety ral sasamke, ode rsambayan ma raten sai ta sai toha Amakw o wen sra eraske, desikeo ana Amakw yal nam raten desy ti sir. ");
INSERT INTO slu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kali kolnye ti wen desike irkye enaru ta enatelw ne rawahuk sir khyali rtohak ma Yaw, desikemo Yaw ne kor sir ti desy dakun.” ");
INSERT INTO slu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lemadendye Petrus mya ma yait Yesuske, ode yena I ma byohe, “Tuanggurw, kolnye waikw matohakke it, ma yala sal ma yaw, desikemo kswos wasi sal iala desy ba neke klai de? Musti mo kla-itw e?” ");
INSERT INTO slu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dendye Yesuske hyalas i ma byohe, “Lema kla-itw, ode lema hean-itw kresi itw dakun! De musti mo mswos wasi sal desy nini lema maki mal karyarike. ");
INSERT INTO slu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dendye kuhliak ktela Hulasokwe ima ma ihareta kola Rajake ne, neke kolnye: Rajake it a yala ma byihy a wasi makaryaare wait utanare mumu. ");
INSERT INTO slu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dendye kyoat raja desike byihy wasi makarya desikre wait utanare bonyo, wasi makaryake it ma wasi utanke lan a ksyalik, neke blyawan bokbokke tatyailke ribunke atkwe enatelw ksala hean-at (340.000kg).Dendye raja desy yaso ma ror makarya desy ma syara i. ");
INSERT INTO slu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ode khyali makarya desike lema syelw yal wasi utanke ma ktei, lemade raja desike yal haretke ma rketa makarya desy yor sawa o anan, ktyabal a lan o hnutat nekre mumu, ma ral khesike ma ral ma rselw a wasi utan desy ti raja desy. ");
INSERT INTO slu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lemadendye kyoat makarya desike itomolu ma rajake itanuk koldyesy bonyo, syakitil ode you ti raja desike wasi lulw ne. Ode yal ralake kralake ma iten toha rajake ma byohe, ‘Amam lan o, kuten ma mal klelanke tebikan ma yaw aduk, ma bisa ma kobak a ksala ma kswelw wasikw utan desy mumu ma ktei.’ ");
INSERT INTO slu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dendye raja desike ralake klyobak makarya desy ksyalik, lemade raja desike syos makarya desike wasi utanare ba mumu ma ktei. ");
INSERT INTO slu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Keskyede kyoat makarya desike ibetik bonyo, inal a yor lian makaryake it dakun, ma lian desike ika wasi utan ti makarya dai rabihy desy, neke karyarike kuban blyawan bokbokke atw.Lemade makarya desike tye lian desy telake ode byohe, ‘Hei, mswelw wasimw utan muutan toha yaw desy mirin!’ ");
INSERT INTO slu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dendye lian desike syakitil ode you ti wasi lulululw ne, ode iten ma byohe, ‘Liakw, mukita aduk! Mlwobak yaw mo mal klelanke tebikan ma yaw aduk, ma kobak a ksala ma kswelw wasikw utanke mumu ti o!’ ");
INSERT INTO slu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Keskyede makarya desike lema you elik, de yor lian desy ba ti lyuk a i ei sey metmetke kralake, nini lian desike syelw wasi utan desike mumu ma ktei. ");
INSERT INTO slu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ode kyoat liat makarya idanare raatos a ktela desy bonyo, ralatare ksyal a ksyalik ti ktela desy, dendye rba ti rlosu ktela desike ti rajake. ");
INSERT INTO slu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lemade rajake yabuk makarya dai rabihy desy, ode tyanuk ti i ma byohe, ‘Makarya mahatw o! Wasimw utanke ribun ma yaw ksyalik, keskyede kswos ba bo. Kali marwen daku yaw, mane klwobak a o. ");
INSERT INTO slu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ode kyanmwane lema mlwobak liamw desy, kola dene kulobak o dakun ne de?’ ");
INSERT INTO slu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lemade raja desike kyeyer a ksyalik. Dendye yaso ma rluk makarya mahatw desike ei sey metmetke kralake. Ode yaso iry majaga ti sey metmet desy ma roban makarya desy, nini syelw wasi utanare mumu ma ktei.” ");
INSERT INTO slu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Lemadendye Yesuske tyanuk ti wasi matoha Iare ma byohe, “Ana Amakw mamin ti wen sra eraske, yala ktela desy ti e dakun, neke ktela maola raja desike iala ti wasi makarya mahatw desy, kolnye lema mbyuma myal ralami kralanare mumu, ma mlyobak waimire ma msyos wait sal raala ti e desikre ba.” ");
INSERT INTO slu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kyoat Yesuske yajar iry ribunke ma ktei bonyo, byetik toha propinsi Galileake ma byai propinsi Yudeake, neke lyakut yosy a sah Yordanke kseri timurke. ");
INSERT INTO slu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kyoat desy dakun o iry ribunke rtoha I, dendye nyoha irire wait a kbainare ti desy ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lemadendye iry manosy lui Farisi-nare dum a rma ma robak sal ti Yesuske, ma rena I ma rbohe, “Tuanggurw, mlay bain o ktyoha ity wait ktela kubkubakke mo, khyali sai ta sai bo, bisa ma wamwanire rbisak sawatare ba e?” ");
INSERT INTO slu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dendye Yesuske hyalas sir ma byohe, “De lema mbyaca ti Kitab Lanke ohe, khyehyeike ‘Hulasokwe ika irkye neke wamfwetke ode wamwankye’ e? ");
INSERT INTO slu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ode rkesy ti Kitab Lanke ma kbyohe, ‘Koldyesike mane wamwankye it a isa, desikeo ana tyutuk ena o ama, ma ti yor sawa, ma deruke rawahuk sir ti sasam, ma nam sasam sir.’ ");
INSERT INTO slu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dendye deruke lema enaru sir de, de sasasam a sir bo. Kali koldyesike mane, nam sai desy Hulasokwe yeti yahuk ti sasam de, desikemo kete irkye isali de.” ");
INSERT INTO slu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lemade iry desikre rtanuk ti Yesuske huruk ma rbohe, “Koldyesikemo kyanmwane Musa yal tnyetakke ma ity ma kbyohe, kolnye wamwankye byuma ibrai wamfwetke, desikeo wamwankye cuma mo kyesy atyahy a inabraike aduk, ma yal ti wamfwet ana ibisak ba desy ne de?” ");
INSERT INTO slu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dendye Yesuske tyanuk ti sir ma byohe, “Musa lyura e ma mbyisak sawamire ba, kali usumy khatunare lan. Klala kyala kyosy khyehyeike ne Hulasokwe lema you ma myala koldyesy. ");
INSERT INTO slu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dendye ktwanuk ti e ohe: Esei desike kolnye sawa-na lema yenaf a yor wamwany salik, keskye lai-na byisak i ba bo, ode bya ti isa a yor wamfwet salik, desikeo lai desike yaldotw ma desy, kali byilak lean sawa.” ");
INSERT INTO slu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lemadendye Yesuske wasi matoha Iare rtanuk ti I ma rbohe, “Kolnye ktela insa maoly desike ti irkye, desikemo taneti ity tenatare ma kete tasa bo.” ");
INSERT INTO slu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Keskyede Yesuske tyanuk ti sir ma byohe, “Irire mumu neke lema bisa ma rmorif kola tun mitanuk desy. De cuma mo iry a Hulasokwe iilikare, neke bisa ma rmorif kola tun mitanuk desy bo. ");
INSERT INTO slu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ode irire dum a lema bisa ma rasa, kali kyala kyosy a radur ti sirke, desikeo roly desy de. Ode irire dum a lema bisa ma rasa, kali iry salik a rala sir ma lema bisa ma rasa.Ode irire dum dakun o rmesan a rbuma lema rasa, de rbuma rasaa ror Hulasokwe bo. Esei desy tyomolu ode byuma yal nam kuajar nekre, desikemo yal bo.” ");
INSERT INTO slu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maktei bonyo irire ror anat kakanare ti Yesuske, ma syaa sima ti sir, ode syambayan ti sir. Keskyede kyoat wasi matoha Iare ratos a ktela desy bonyo, rkeyer a iry desikre. ");
INSERT INTO slu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Keskyede Yesuske tyanuk ti wasi matoha Iare ma byohe, “Mlyura naman kakan desikre ma rma ma rait Yaw, de kete mbya etno eta sir. Kali iry maola naman kakan desikre, ana Hulasokwe wasi iry a sir, kali Hulasokwe wasi irire sir ne, iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne.” ");
INSERT INTO slu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lemadendye Yesuske syaa sima ti naman kakan desikre, ma iten eraske ti sir, maktei o byetik toha wen desy ma byai wen salik. ");
INSERT INTO slu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sekwe it bonyo lyalaw murke it a mya ma tyanuk ti Yesuske ma byohe, “Tuanggurw, kala ktela eras kabei ma musti mo ana kmworif ti wen sra eraske nini nam de?” ");
INSERT INTO slu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dendye Yesuske hyalas i ma byohe, “Kyanmwane muena Yaw ti nam eraske ne de? Lema kika nam eras, de lenla Hulasokwe myesan eras I bo. Keskyede kolnye mbwuma mmworif ti wen sra eraske nini nam, desikemo mtwoha Hulasokwe wasi tnyetakare.” ");
INSERT INTO slu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lemade iry desike yena Yesuske huruk ma byohe, “Tnyetak sai ne musti mo kutoha ne de?” Dendye Yesuske tyanuk ti i ma byohe, “Oi neke mhwe nam a Hulasokwe itetakare de, neke kete maldotw, kete mtwabahunw iry, kete munamet, kete mukakmet ma moit salke ti iry salik, ");
INSERT INTO slu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ode musti mo malan a enamw o amamw, ode mlwobak irire, kola dene mulobak tenamkwe kmyesan ne.” ");
INSERT INTO slu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Desike bonyo lyalaw mur desike tyanuk ti Yesuske ma byohe, “Tuanggurw, nam mutanuk nekre ktwoha mumu kyala kyosy kakan a yakwe de, ode lenla sai huruk de?” ");
INSERT INTO slu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dendye Yesuske tyanuk ti i ma byohe, “Kolnye mbwuma mlay a o bain-bain, desikemo ktelake sasam neke musti mo mtwoha. Neke mulak a o bai wasimw sekye, ode mkweta malolimw o lan o hnutamw desikre mumu, ode mal khesinare ma muhe ti iry a lema manait ei sra o hahare. Koldyesikemo oi neke ana Hulasokwe yal malolkye ti o ti wen sra eras imin tike. Mala koldyesy maktei, nenmo mmwa ma mtwoha Yaw.” ");
INSERT INTO slu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kyoat lyalaw mur desike itomolu tun Yesuske itanuk desikre bonyo, ralake ksyal ti nam itomolu desy, kali iry desike wasi malolkye lan. Dendye yulak i ma byai waitke. ");
INSERT INTO slu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Mtyomolu mamak nam kutanuk ne! Iry a maaka malolkye ana ksunw ma syukar ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dendye ktwanuk ti e huruk ohe, kalkal ti a untake syukar ei balbyalkye kuranke, keskye ksunw ksyalik ti iry maaka malolkye syukar ti iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne.” ");
INSERT INTO slu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kyoat a Yesuske wasi matoha Iare ratomolu tun Yesuske itanuk desike bonyo, rheran a ksyalik, dendye rtanuk ma rbohe, “Koldyesikemo esei ne ana Hulasokwe iaorif i, ma isukar ei wen sra eras Hulasokwe imin tike ne de?” ");
INSERT INTO slu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dendye Yesuske yulak matake ma yatos wasi matoha Iare, ode tyanuk ti sir ma byohe, “Hulasokwe yala hye nam a irkye lema iala hyeke.” ");
INSERT INTO slu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lemadendye Petrus a tyanuk ti Yesuske ma byohe, “Tuanggurw, aramy neke mtyutuk ara wasimy nam ribun nekre mumu de, ma aramy mtyoha O, desikemo ana aramy mitot sai de?” ");
INSERT INTO slu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dendye Yesuske tyanuk ti wasi matoha Iare ma byohe, “Mtyomolu mamak nam kutanuk ne! Kolnye kyait sekwe ma Irkye Anankemya, ma tyaklulw ti wasi kader madelahke ma hyareta, desikeo ei neke ana mtyaklulw ti wasimy kaderare kola raja-nare ma mhyareta Israel-are wait klolan dehean a kresi enaru desy. ");
INSERT INTO slu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ode esei ta esei bo, ma khyali itoha Yaw ne, desikeo tyutuk bain-bain wasi sekye, wai o rahyeta, ena o ama, ananare, ode lan o hnutan, desikemo iry desike ana Hulasokwe yal nam ti i o karyarike atw kbyilak. Ode ana myorif nini nam ti wen sra eraske. ");
INSERT INTO slu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Keskyede iry ribun kyalamo mamin ti lulw nekre, ana ramin ti lyakwe, klala iry a mamin ti lyaw nekre ana wenatke so lulkwe.” ");
INSERT INTO slu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Lemadendye Yesuske tyanuk huruk ma byohe, “Kuhliak ktela Hulasokwe ima ma ihareta kola Rajake ne, neke kolnye: Irkye it a wasi bo tasy maiskye, ma kebuke bolbolbol ne byetik ti yobak iry, ma rba ti rkarya wasi bo desy. ");
INSERT INTO slu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dendye itot makaryaare bonyo itun a yor sir, ma kolnye rou ma rkarya wasi bo desy, desikeo ana syelw a sir, neke ktyoha kyalamo raselw irire wait katire ti seure ratsam ne, neke khesike dinarke sasam.Lemade iry desikre rou de, dendye byu ti sir ma ti rkarya wasi bo tasy maisy desy. ");
INSERT INTO slu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ode anakyai kyoban sikwe bonyo, boke kebu desike byetik huruk ma byai wen raketa nam tike. Ti desike yatos o irire dum a rtaklulw bo, kali lema raka karyaat. ");
INSERT INTO slu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lemade tyanuk ti sir ma byohe, ‘Mbya ti mkyarya wasikw bo tasy maiskye, ode ana kswelw a khesike ti e, ma ktyoha karya mikarya desy.’ Lemade iry desikre rtoha ma rba. ");
INSERT INTO slu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ode anakyai kyoban hean a kresi enaru ti sedutw ne bonyo, boke kebu desike byai wen raketa nam tike huruk, ode yatos o irire dum a rtaklulw ti desy nggora. Dendye tyanuk ti sir kola dai itanuk ti mamunanare ne huruk. Maktei o kyoban enatelw ti sew maba ne, desikeo boke kebu desike yala koldyesy ti irire dum huruk. ");
INSERT INTO slu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ode anakyai kyoban enasimke ti seswery ne, boke kebu desike byetik ma byai wen raketa nam tike huruk bonyo, inal a yor irire dum, ma rtaklulw ti desy bo. Dendye yena sir ma byohe, ‘Senweke lema mitot karya, mane mitaklulw bony ne e?’ ");
INSERT INTO slu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lemade iry desikre rhalas i ma rbohe, ‘Ou, lema kika iry ma ral karya ma aramy mkyarya, mamode rselw aramy.’ Lemade bo tasy maisy desike kebuke tyanuk ti sir ma byohe, ‘Desikemo mbya ti mkyarya o wasikw bo tasy maiskye dakun.’ ");
INSERT INTO slu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ode metdyetke bonyo, boke kebu desike tyanuk ti wasi makarya desikre wait uskwe khatuke ma byohe, ‘Mabuk makarya desikre mumu, ode mswelw a wait katire ti sir. Keskyede mswelw wait katire ti sir kolnye: mswelw ti iry a nenmo masukar ma makarya desikre a kmuna. Maktei o kitoha-kitoha i nini makarya mamunanare rosy lyakwe, desikeo nenmo mswelw wait katire ti sir.’ ");
INSERT INTO slu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lemade makarya desikre rma. Desikeo uskwe khatu desike syelw a iry a nenmo makarya ti kyoban enasimke ti seswery ne wait katire a kmuna. Ma uskwe khatu desike yal kuban dinarke ratsam-ratsam ti iry desikre ma kyakar sir. Kuban dinar neke sasam o kdeda katkye sekwe sasam. ");
INSERT INTO slu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dendye makarya mamuna kyala kyosy bolbolbol neke rrekan ohe, ana ral katy ti sir o kbyilak dai nenmo makarya seswery nekre, kali rrekan ohe rkaryaa rala rosy bolbolbol ne de. Kyosy desy ma o ral kuban dinarke ratsam-ratsam ti sir dakun bo. ");
INSERT INTO slu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dendye kyoat wait uskwe khatuke inal wait katire ti sir bonyo, lema rou ma ral, kali rkeyer a boke kebu desy ma it a tyanuk ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Edo! Makarya manosy lyaw desikre nenmo rsukar ma rkarya jamke sasam bo, klala aramy neke mkyaryaa myala myosy a bolbolbol ne, ma sew manas ne kena aramy nini ti sewah, desikeo mswelw a ara wasimy katire o kdeda nenmo makarya ti seswery neke wait katire dakun.’ ");
INSERT INTO slu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lemade boke kebu desike hyalas makarya desy ma byohe, ‘Liakw, lema kuka salakw ti e. Kali dai bolbolke tatuna khesike ma ktei de, desikeo myou ti sekwe sasam neke musti mo kswelw a kuban dinarke ratsam-ratsam ma kyakar e ode? ");
INSERT INTO slu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lemade mal wasimw katkye ode mbwa. Kali kbwuma kal katy ti iry nenmo makarya desikre, neke mais kola dene kunal ti o ne. ");
INSERT INTO slu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Dendye kbwuma kala sai ta sai, desyo kyosy a yaw bo. Kali wasikw! Dendye kete mswoi ralamw ti kuala eraske ti irire ne dakun.’” ");
INSERT INTO slu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lemade Yesuske tyanuk huruk ma byohe, “Iry manosy lyakwe ana myuna, klala iry mamunake ana yosy lyakwe.” ");
INSERT INTO slu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kyoat Yesuske lyakut bai nus Yerusalemke, ma ti wait laklakutke a nggora ne, desike bonyo yabuk wasi matoha I dehean a kresi enaru desy, ma rawahuk sir a rmesan, ma soso sir toha ribunke. Ode tyanuk kakan ti sir ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mtyomolu! Tala ma tbai Yerusalem mane. Ode ti soke Irkye Anankeana ral I ti usu khatu mabaa klen ti irkye yor Hulasokwe, ror iry mahe snurat o tnyetak Musake, ma rtunik tnyetak matmyatkye ti I. ");
INSERT INTO slu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Maktei o ral I ti iry a lema Yahudi-nare, ma rahmway I, roban de rtaba I, ode rbakw a I ti tul masanwalw ike ma myaty. Keskyede sekwe enatelw bonyo ana myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lemadendye Zebedeus sawa, yor anan a Yakobus ode Yohanes, neke rma ma rseak Yesuske. Ma Zebedeus sawa-na syakitil o you ti Yesuske wasi lulw ne, ma iten namke it toha I. ");
INSERT INTO slu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lemade Yesuske yena i ma byohe, “Eno, sai ne mubuma kunal ti o ne de?” Dendye enen desike hyalas ma byohe, “Kbwuma anakw deru neke it a tyaklulw ti serimw wisalke, ode it a tyaklulw ti serimw wanke, kolnye kyait ma muka Raja, ode mtwaklulw ti wasimw kader madelafke ma mhwareta ti.” ");
INSERT INTO slu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Keskye Yesuske tyanuk ti sir ma byohe, “Ei neke lema mhye nam mitenke. De ei neke bisa ma mhyar masunw ana kuhar ne e?” Lemade iry desikre rhalas Yesuske ma rbohe, “Ou, bisa ma aramy mhyar.” ");
INSERT INTO slu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lemade Yesuske tyanuk ti sir ma byohe, “Ou mlay, ana mhyar masunw kuhar ne dakun. Keskyede ti nam miten desy, lema wasikw haretke desy ma kswusu ohe, ana ese tyaklulw ti serikw wisalke, ode ana ese tyaklulw ti serikw wanke. Kali haret desike kimin a Amaku myesan bo, ma ana syusu wen desikre ti wasi iry a iilikare de.” ");
INSERT INTO slu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ode kyoat Yesuske wasi matoha I dehean desike ratomolu nam liat deru desike raten toha Yesuske desy bonyo, rkeyer a deruke a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lemade Yesuske yabuk raktemtem, ode tyanuk ti sir ma byohe, “Mhye ohe usu khatu mahareta ti wait bangsa nekre ti nuske ktem ne, kyalamo rhareta wait masyarakatke ne ksunw ksyalik, ode rdakin ma rala wait masyarakatke kola ne wait atare ne bo. ");
INSERT INTO slu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Keskyede ei neke kete myala koldyesy. De kolnye esei desike byuma iry lan a i, musti mo nyauk tenanke ma babaf ma yola makarya ne bo. ");
INSERT INTO slu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ode esei desike byuma imin ti lulkwe ma lan lahuk i ti e, desikeo i desike musti mo ika at ma kyarya ti e mumu. ");
INSERT INTO slu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kola Irkye Ananke ti imai nuske ktem ne, lema byuma irkye kyarya ti I, de mya ma kyarya ma syaluk irkye, ode yal tenanke ma myaty ma lyitan eta iry ribunke dakun.” ");
INSERT INTO slu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ode kyoat Yesuske yor wasi matoha Iare rbetik toha Yerikho, desikeo iry ribunke lui-lui sir ma rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kyoat desy dakun o irkye enaru ma matatare kbyol, ode rtaklulw ti salke kserike. Ode ratomolu Yesuske ma ilakut ti desy bonyo, ratelat ti Yesuske ma rbohe, “Yesus! Raja Daud tesnwo natu O! Mlwobak aramy!” ");
INSERT INTO slu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Keskyede iry ribun desikre rterik malkyakaw iry deru desy ma mamwaw sir. Keskyede iry deru desike lema rhaduli iry ribun desikre, de reik ma rbohe, “Yesus! Raja Daud tesnwo natu O! Mlwobak aramy.” ");
INSERT INTO slu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lemade Yesuske imres, ode tyanuk ti iry deru desy ma byohe, “Nam sai ne miten ma kuala ti e ne de?” ");
INSERT INTO slu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lemade iry desikre rhalas Yesuske ma rbohe, “Ebo, aramy mbyuma aramy myatakit.” ");
INSERT INTO slu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dendye Yesuske ralake klyobak sir a ksyalik, lemade syaa simake ti iry deru desy matatare bonyo, deruke rmatakit elik. Dendye deruke rlakut ma rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kyoat desike Yesuske yor wasi matoha Iare rarasy ei nus Yerusalemke de. Keskyede lenla rait Yerusalem, desikeo musti mo ana rait a hnuke it a kmuna. Hnu neke hnu Betfageke, ma kimin ti kususwan Zaitunke, neke knyey a nus Yerusalemke dakun. Dendye rala ma ranait hnu desy bonyo, Yesuske yabuk wasi matoha Ike irkye enaru ma yaso sir, ");
INSERT INTO slu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma tyanuk ti sir ma byohe, “Mbyai hnu mamin ti lulw ne. Ode ana misukar ei hnuke krala desy, desikeo myait elik keledai ltyenke it ma yor ananke, ma rikat sir ti desy. Lemade myaka tasy a ranal ma raikat sir desikre, ode myor sir mai ne. ");
INSERT INTO slu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ode kolnye irkye it a yena e ti nam miala desy, desikeo mhyalas i ma mbyohe, ‘Ity Ebutke byuma pyake keledai nekre aduk. Ode ana pyake sir ma ktei, desikeo nenmo yaso ma rety de rolik sir ei wenatke huruk.’” ");
INSERT INTO slu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ktela desike kdi ti ma ktyoha tun heitlulswo iry manety Hulasokwe wasi nyanoare rakesy ti wait kitabare ti kibohe, ");
INSERT INTO slu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mtwanuk ti iry a Sion-are ma mbwohe, ‘Myatos! Wasimy rajake mya ma ne. Ode nyauk tenanke ma babaf, ode syai keledaike, neke keledai mur ne bo.’” ");
INSERT INTO slu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lemade iry a Yesuske iaso desikre rba, ode rala kola nam Yesuske itanuk ti sirare. ");
INSERT INTO slu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dendye iry deru desike ral keledai ltyen desy yor ananke, ma ror sir ba ti Yesuske. Kyoat ranait Yesuske bonyo, deruke ronuk wait rabit narnarure, ma ral ma rary a keledai mur desike rutunanke, ma Yesuske syai ti ma byai Yerusalem. ");
INSERT INTO slu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ode iry ribun mamin ti desikre, dum a rhela wait rabit narnarure dakun ti salke kralake, ode dum a ral aw ktahinare ma rhela ti salke kralake dakun. Iry desikre rala koldyesy ma ksyusu ohe ralan Yesuske ma desy. ");
INSERT INTO slu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ode iry ribun desikre dum a rlakut a kmuna Yesuske, ode dum a rosi lyakwe, ode raktemtem ne ratelat ma rbohe, “Tleru raja Daud Tesnwo natu ne! Eraske kimin a I, kali myaa yor Hulasokwe wasi haretke! Lemade tleru Hulasow a mamin ti sra lahuk so!” ");
INSERT INTO slu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ode kyoat Yesuske yait Yerusalem bonyo, nus Yerusalemke ksyorbubw ma iry mamin ti Yerusalem desikre mumu ne rena ma rbohe, “Ese I ne de?” ");
INSERT INTO slu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lemade iry ribun matoha Yesuske ne rhalas sir ma rbohe, “Yesuske I ne. I neke iry manety Hulasokwe wasi nyanoke, ma yosy hnu Nazaretke ti propinsi Galileake.” ");
INSERT INTO slu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kyoat Yesuske inait nus Yerusalemke bonyo, byai Hulasokwe Seike. Ti desike yesak iry maketa nam ti kintal Hulasokwe Seike. Ode hyau balik meja raliku kuban tike, ktyabal mban a kyalamo rataklulw ti ma raketa manu hahire ti ne dakun. ");
INSERT INTO slu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ode tyanuk ti sir ma byohe, “Rkesy ti Kitab Lanke ma kbyohe, ‘Seikw neke sey rasambayan tike.’ Keskye ei ne myal ti kindika wen a iry manametare rawahuk sir tike bo.” ");
INSERT INTO slu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lemade iry matmabol o iry mablukut nekre rmai Hulasokwe Seike, ma Yesuske nyoha wait kbainare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Keskyede iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry mahe snurat o tnyetak Musake ratos a ktela masalsyalik i Yesuske iala desikre, ktyabal a rtomolu naman kakanare ma rleru Yesuske ma rbohe, “Tleru raja Daud Tesnwo natu ne.” Desike bonyo usu khatu desikre rkeyer a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Lemadendye usu khatu desikre rba ti rena Yesuske ma rbohe, “Mtwomolu naman kakan nekre tun ratanukare deny e?” Lemade Yesuske hyalas sir ma byohe, “Ktwomolu de! De lema mbyaca Kitab Lanke ti kibohe, ‘Biar ma sir neke naman kakanare ode naman masuswaure dakun, keskye Oi neke majar sir de, ma rleru O.’” ");
INSERT INTO slu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lemade Yesuske tyutuk iry desikre ti desy, ode byetik toha nus desy, ma byai hnu Betaniake, ma sewahare ne yenaf ti so. ");
INSERT INTO slu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ode bolbolke bonyo, Yesuske rulak sir bai Yerusalem, desikeo Yesuske kyoman o imlar. ");
INSERT INTO slu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ode ti salke kditlalan, desikeo Yesuske myatakit aw arake it, lemade bya sara aw ara desy, ma yatos o kika kisi ta lema. Keskyede lema myatakit aw ara desike kisike it elik, de ktafranare kmyesan bo. Lemade tyanuk ti aw desy ma byohe, “Ana kiba knaru ne lema muisy de!” Yesuske itanuk koldyesy ma ktei bonyo, aw ara desike kimraw ma kmyaty elik. ");
INSERT INTO slu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kyoat Yesuske wasi matoha Iare ratos a ktela desy bonyo, rheran a ksyalik. Dendye rtanuk ma rbohe, “Kyanmwane aw ara neke bisa ma kimraw elik ne de?” ");
INSERT INTO slu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Lemade Yesuske tyanuk ti sir ma byohe, “Mtyomolu mamak nam kutanuk ne! Kolnye esei desike mlay bain ma lema ralake kakan, de tyohak ti Hulasokwe bain-bain, desikeo i desike bisa ma yala nam kuala ti aw ara ne. Ode lema desike kmyesan bo, de ana yal haretke ti huarke ma byohe, ‘Huar o! Muhmua toha ne, ma ti mdwi o tasike krala so!’ Desikeo huar desike ana kihmua i, ma ti kdi o tasike krala so. ");
INSERT INTO slu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ode kolnye msyambayan ti Hulasokwe ma miten sai ta sai toha I, desikeo ana yal nam miten desy ti e, kolnye mtyohak bain-bain ti I.” ");
INSERT INTO slu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lemade kyoat Yesuske inait nus Yerusalemke bonyo, syukar ei Hulasokwe Seike huruk. Ode kyoat iajar ti desy bonyo, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manety lulw ti Yahudi-nare rma ma rena I ma rbohe, “Mlwosu ma aramy ohe, haret kabei ne munal ma muala ktela nekre mumu ne de? Ode esei ne inal haret ne ti O ne de?” ");
INSERT INTO slu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lemade Yesuske tyanuk ma byohe, “Kena e ma mlyosu ma Yaw aduk, ma kolnye mlyosu ma Yaw, desikeo ana klwosu ti e ohe, haret kabei ne kunal ma kuala ktela nekre ne. ");
INSERT INTO slu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanes Mababtiske yal haretke toha esei, mane ibabtis irire ne de? Yal toha Hulasokwe ta yal toha irkye de?” Lemade iry desikre raktemtem a rrekan ma it de tyanuk ti it ma rbohe, “Ana kolnye thalas ma tbohe, ‘Yohanes Mababtiske yal haretke toha Hulasokwe,’ desikeo ana tyanuk ma ity ma byohe, ‘Koldyesikemo kyanmwane lema mitohak Yohanes ne de?’ ");
INSERT INTO slu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Keskyede kolnye thalas ma tbohe, ‘Yohanes yal haretke toha irkye bo,’ desikeo tamtaut iry ribun nekre mumu. Kali iry ribun nekre rtohak ohe, Yohanes neke iry manety Hulasokwe wasi nyanoke.” ");
INSERT INTO slu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lemade iry desikre rhalas Yesuske de rbohe, “Lema aramy mhye o Yohanes wasi haret neke kyosy esei.” Dendye Yesuske tyanuk ti sir de byohe, “Desikemo Yaw dakun o lema klwosu ti e ohe, haret kabei ne kunal ma kuala ktela ribun nekre ne.” ");
INSERT INTO slu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Lemadendye Yesuske tyanuk ti iry desikre ma byohe, “Mryekan a ktela ne: Irkye it ma anan wamwankye enaru sir. Ode sekwe it bonyo iry desike byai anan auskwe, ode tyanuk ti i ma byohe, ‘Anakw o, senweke mbwai bo tasy maiskye, ma kolnye kika karya, desikemo mkwarya.’ ");
INSERT INTO slu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lemade naman ausw desike hyalas ama ma byohe, ‘Amo, lema kbwa!’ Keskyede naman desike ryekan ti de ryekan ma nini byai bo tasy maisy desy ti kyarya. ");
INSERT INTO slu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Maktei o amam desike byai anan amurkye ma tyanuk koldyesy huruk ti i, desikeo anan amury desike hyalas ama ma byohe, ‘Ou amo, ana kbwa.’ Keskyede lema bya.” ");
INSERT INTO slu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lemade Yesuske yena iry desikre huruk ma byohe, “Ktyoha e mo, ti naman deru desike, neke ese tyoha ama-na nam itanukke de?” Iry desikre rhalas ma rbohe, “Naman auskwe.” Lemade Yesuske tyanuk ti sir ma byohe, “Mlay! Mtyomolu mamak nam kutanuk ti e ne. Iry a maily usure, ode wamfwet atyatare ana rmuna e, ma sir desike ana raka iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne. ");
INSERT INTO slu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kali Yohanes Mababtiske mya ma syusu sal a mlakye ti e, keskye lema mbyuma mtyohak a i. De maily usure ror wamfwet atyatare rtohak a i. Klala ei neke myatos ohe, maily usure ode wamfwet atyat desikre rtohak Yohanes Mababtiske de, keskye ei ne lema mbyuma mbyisak totamy atyatare ba, ode lema mbyuma mtyohak nam itanukare.” ");
INSERT INTO slu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ode Yesuske tyanuk ti iry desikre ma byohe, “Mtyomolu tun inahliak ne huruk. Irkye it a kyuy a boke, ode ika losan ti ma kyaklelela. Maktei o tyan tasy maiskye ti bo desy, ode kyaly a kuranke ma yala wen ana raisy tasy maiskye tike. Maktei o ika sekye ti bo desy ma irire ramin ti, ma rajaga bo desy. Kyoat iry desike iala nam desikre mumu maktei bonyo, itun a yor irire dum ma rseak ti bo desy, mamode ana rahe kisinare ma ror a i. Maktei o ihlolwain bai nus salik. ");
INSERT INTO slu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ode kyait ma ral bo desy kisinare bonyo, boke kebu desy yaso wasi makarya salik, ma rba ti rseak iry manoha bo desikre, ma raten boke kebu desy watanke toha sir, ma rety ba ti boke kebu desy. ");
INSERT INTO slu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Keskyede kyoat iry desikre ranait bo desy bonyo, manoha bo desikre rkumak sir, ma roban it, ode rtabahunw it, ode ral hature ma ratdya idake. ");
INSERT INTO slu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Lemade boke kebuke yaso wasi makarya salik, neke ribun sir ma rbilak mamunanare, keskye manoha bo desikre rala ti sir, kola dai rala ti liat mamunanare dakun. ");
INSERT INTO slu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lemadendye boke kebu desike ryekan ti ralake ma byohe, ‘Koldyesikemo kaso anakw a kuloblobak ne ma bya bo. Kali i neke musti mo ana ralan a i.’ ");
INSERT INTO slu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Keskyede iry manoha bo desikre raatos naman desike ma ima bonyo, it de tyanuk ti it ma rbohe, ‘I neke, I ne ana isaa i ti bo ne. Lemamo ttabahunw a i, ma ity neke tsaa ity ti bo ne.’ ");
INSERT INTO slu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lemade manoha bo desikre rkumak naman desy, ode rhait i bai boke ketake ti rtabahunw a i ti desy.” ");
INSERT INTO slu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lemade Yesuske yena iry desikre ma byohe, “Koldyesikemo bo tasy maisy desike kebuke ana yala kolkyabei iry manoha bo desikre de?” ");
INSERT INTO slu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lemade iry desikre rhalas Yesuske ma rbohe, “Koldyesikemo boke kebu desike ana mya ma tyabahunw iry manoha bo desikre mumu. Maktei o nenmo yal iry salik ma rnoha wasi bo desy, ma ana kyait sekwe ma ral bo desike kisinare, desikeo ral boke kebu desy watanke ti i.” ");
INSERT INTO slu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lemade Yesuske tyanuk ti iry desikre ma byohe, “De mbyaca tunke khatu rakesy ti Kitab Lanke ne ta lema de? Ti kibohe, Hatw neke iry masadiri seire lema ral ma rsadiri sey, de rbisak ba bo. Keskyede hatw neke Hulasokwe yal ma yal ti hatw mamunmunake ti wasi sekye. Ma ktela neke tatos mo kisalsyalik i bo. ");
INSERT INTO slu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lemade klwosu ti e ohe, wasimy hakke ma ana mika iry a Hulasokwe ihareta kola Rajake ti ralat a kralanare ne, keskye ana Hulasokwe yal a yolik hak desike toha e, ma ana yal ti bangsa matoha nam itanukare ne.  ");
INSERT INTO slu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dendye esei desike ana dyi ti hatkwe khaha desy, desikemo ana ibtasy elik. Ode esei desike ana hatw desy kdi ma kdyan i, desikemo ana iahw elik.” ");
INSERT INTO slu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kyoat iry mabaa klen ti irkye yor Hulasokwe, neke wait usu khatunare, ror iry manosy lui Farisi-nare ratomolu Yesuske tun ihliak desy bonyo, nenmo rhe ohe tun ihliak desike ktyanuk sara sir ma desy. ");
INSERT INTO slu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lemade robak ksala ma rkumak Yesuske, keskyede ramtaut iry ribun mamdiry ti desy, kali iry ribun desikre rtohak ohe, Yesus neke iry manety Hulasokwe wasi nyano I. ");
INSERT INTO slu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Lemadendye Yesuske tyanuk tun inahliakke it huruk ti iry ribun desikre ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ktela Hulasokwe ima ma ihareta kola Rajake ne, kola dene rajake it ma anan wamwankye yala ma isa, dendye raja desike yala kalkal lan ne. ");
INSERT INTO slu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Lemadendye kyoat kalkal lan desike kidi ti bonyo, raja desike yaso wasi makaryaare ma rba ti rabuk iry a ranal undangan ti sir ne, ma rmai kalkal insa desy. Keskyede iry a manal undangan desikre rabrai ma rmai kalkal desy. ");
INSERT INTO slu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lemadendye yaso wasi makarya salik huruk ma ti rtanuk ti iry a ranal undangan ti sir desikre ma rbohe, ‘Mmya aduk, kali nam ribun lan ne kimin mumu de, neke rkotal saby a wamwany lan ne, ktyabal sabkye anan mamsun ne, ma rnoha sir de. Ma nam nekre mumu ne kimin de, dendye mmya ma tbai kalkal a insa so.’ ");
INSERT INTO slu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Keskyede iry a raabuk desikre, lema rhaduli ma rtomolu makarya desikre nam ratanukare elik. De iry a raabuk desikre dum a rbai wait boare, ode dum a rba ti rseak wait karya salik. ");
INSERT INTO slu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ode dum a rkumak makarya dai ti maabw desikre, ma roban de rtaba sir, nini rtabahunw dum dakun. ");
INSERT INTO slu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma khyury ma raja desike kyeyer a ksyalik, lemade yaso wasi suldatare ma rba ti rtabahunw iry a raabuk desikre, ode ral akye ti wait nuske. ");
INSERT INTO slu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maktei o raja desike tyanuk ti wasi makaryaare ma byohe, ‘Ti kalkal lan insa ne, nam ribun lan ne kimin mumu de, keskyede iry raabuk desikre lema rber o rtahal ma rmai kalkal lan ne de. ");
INSERT INTO slu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lemadendye mbyai sal a krala sokre, ode minal a myor esei ta esei bo, desikeo myabuk i ma myai kalkal lan insa ne.’ ");
INSERT INTO slu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dendye makarya desikre rba, ode rabuk iry ribun lan ranait sir ti sal a krala nekre, neke iry eras o atyat nekre, ma rma mumu ma rabebenw a kalkal lan insa desy. ");
INSERT INTO slu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ode kyoat a raja desike isukar ei kalkal desy, desikeo yatos irkye it ma lema hyonak rabit kyalamo rahonak ma rabai kalkal insa nekre. ");
INSERT INTO slu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lemade tyanuk ti iry desy ma byohe, ‘Hei wai, kyanmwane musukar ei kalkal insa ne o lema muhonak a rabit a kyalamo rahonak ma rabai kalkal insa maoly nekre ne de?’ Keskyede iry desike lema itun, de mamwamwaw i bo. ");
INSERT INTO slu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lemadendye raja desike tyanuk ti wasi makaryaare ma byohe, ‘Mbyutw myahuk a iry neke sima o lwau, ode myotuk i bai wen a kelerakokke. Ti wen desike serserke ode masunkwe kimin ti.’ ");
INSERT INTO slu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kali Hulasokwe yabuk irire ribun sir, keskyede ana yilik irire rutatelw bo, ma wasi iry a sir.” ");
INSERT INTO slu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lemadendye iry manosy lui Farisi-nare rawahuk sir, ma rena Yesuske, ma robak sal ti nam Yesuske itanukare, ma bisa ma rkumak a I. ");
INSERT INTO slu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dendye raso wait matoha sirare dum, rtabal raja Herodes wasi irire dum, ma ti rena Yesuske ma rbohe, “Tuanggurw, aramy mhye ohe, nam mutanuk o muajar nekre mlay, kali lema mukakmet. Ode Oi neke lema mukea ode museak mat, de Oi neke majar a irire bain, ma rmorif kola Hulasokwe ibuke. Ode lema mumtaut irire wait tunare dakun, kali lema mbwek ti de mbwek ma, ma muobak animw. ");
INSERT INTO slu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lemadendye mlwosu ma aramy ohe, bisa ma aramy msyelw a uskwe ti Kaisarke, ta lema de?” ");
INSERT INTO slu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Keskyede Yesuske hye iry desikre wait rekryekkye o atyat, lemade tyanuk ti sir ma byohe, “Hei iry makakmet e, kyanmwane miobak sal ma Yaw kolnye ne de? ");
INSERT INTO slu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Msyusu kuban blyawan bokbok ranal ma raselw a uskwe ne it ma Yaw aduk.” Lemade iry desikre reta kuban blyawan bokbokke it ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dendye Yesuske yena sir ma byohe, “Esei ne ragambar i, ode rakesy anike ti kuban ne ne de?” ");
INSERT INTO slu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Desikeo iry desikre rhalas Yesuske ma rbohe, “Kaisarke.” Lemade Yesuske tyanuk ti sir de byohe, “Koldyesikemo nam sai desike Kaisarke wasi, desikemo myal ti Kaisarke. Ode nam sai desike Hulasokwe wasi, desikemo myal ti Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kyoat iry desikre ratomolu Yesuske ma itanuk koldyesy bonyo, rheran mait ode rtutuk lakhidik Yesuske ti desy, ode rlakut ma rba. ");
INSERT INTO slu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti sew desike dakun o iry manosy lui Saduki-nare dum a rma ma rena Yesuske, ti irkye imaty maktei o imorif huruk ne, kali lema rtohak o irkye myaty maktei o myorif huruk. Dendye rena Yesuske ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tuanggurw, Musa kyesy a tnyetakke it ma ity, neke kolnye: ‘Wamwankye it ma isa, ma lenla ratot naman, desikeo wamwany desike myaty. Koldyesikemo wamwany desike wai amury a matoha ike musti mo isaa yor wai ausw mamaty desike sawa, ma raka anat ti wai ausw mamaty desy.’ ");
INSERT INTO slu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dendye kolnye ausw o amury ma irkye itw a sir. Ma auskwe isaa yor wamfwetke it, ma lenla raka anat bonyo, wamwany ausw desike myaty, desike bonyo wai amury matoha kausu desy isaa yor wamfwet desy huruk, ");
INSERT INTO slu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ma lenla raka anat bonyo, wamwany desike myaty dakun. Dendye ktela desike kdi ti koldyesy, ti iry deitw ausw o amury desy ma ti kyal wait amury lahukke dakun. ");
INSERT INTO slu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dendye wamwany desikre ramaty mumu bonyo, wamfwet desike myaty dakun. ");
INSERT INTO slu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lemadendye kolnye ana kyait sekwe ma iry mamatire rmorif huruk, desikemo ana ese sawa wamfwet desy de? Kali deitkwe mumu ne rasaa ror wamfwet desy dakun de.” ");
INSERT INTO slu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lemade Yesuske hyalas iry desikre ma byohe, “Hei iry malakut sal e, ei neke ana lema mhye miba sara, kali lema mhye nam rakesy ti Kitab Lanke krala ne kbuanare, ode lema mhye Hulasokwe wasi haretke dakun. ");
INSERT INTO slu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kali ana kyait ma iry mamatire rmorif huruk, desikeo lema kika insa o inlana de. De rmorif kola Hulasokwe wasi nyasoare o wen sra eras Hulasokwe imin tike. ");
INSERT INTO slu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Keskyede ti ktela irkye imaty o imorif ne, neke lema mbyaca Hulasokwe tunanare ti Kitab Lanke ti kibohe, ");
INSERT INTO slu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yaw ne Hulasow a Abraham, Ishak, ode Yakub rasambayan ti a nggorake.’ Ode biar ma iry detelw ne rmaty de, keskye the ohe iry detelw ne rmorif huruk de, kali Hulasokwe lema ika Hulasow ti iry mamatire, de Hulasokwe ika Hulasow ti iry mamorifare.” ");
INSERT INTO slu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dendye iry ribun mamin ti wen desike rheran ti ratomolu tun ribun-ribun Yesuske iajar desikre. ");
INSERT INTO slu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kyoat iry manosy lui Farisi-nare rtomolu Yesuske tun itanuk ti iry Saduki desikre, ma kihury ma ratamuk nunutare elik ne, lemade iry Farisi desikre rawahuk sir, ma robak ksala ma roit salke ti Yesuske huruk. ");
INSERT INTO slu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dendye wait irkye it, neke iry a mahe snurat o tnyetak Musake, neke yobak a ksala ma yena Yesuske ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tuanggurw, tnyetak Musa kabei kbyilak tnyetak nekre mumu de?” ");
INSERT INTO slu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Lemade Yesuske hyalas iry desy ma byohe, “‘Musti mo mdwakin Ebumw Hulasokwe, kyor wasimw mormyorifke mumu, ode kyor amalkyaumkwe mumu, ode kyor nam murekan nekre mumu, ode kyor ralamkwe kralake mumu.’ ");
INSERT INTO slu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tnyetak desike neke tnyetak mabilak tnyetak ida nekre mumu ne. ");
INSERT INTO slu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ode tnyetak matohake, neke mais kola tnyetak mamuna desy dakun, neke kolnye, ‘Musti mo mlwobak irire, kola dene mulobak tenamkwe kimesan ne dakun.’ ");
INSERT INTO slu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dendye klwosu ti e ohe, kolnye mtyoha tnyetak deru ne, desikemo kola ne mtyoha tnyetak Musa idanare mumu ma desy, ode mtyoha dakun tun iry manety Hulasokwe wasi nyanoare rakesy ti wait kitabare ne mumu ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kyoat iry manosy lui Farisi desikre moluk a rawahuk sir ti desy nggora, desike bonyo Yesuske yena sir ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ktyoha e mo Mesias ne, esei de? Ode ese tesnwo natu I de?” Lemade iry a Farisi desikre rhalas Yesuske ma rbohe, “Mesias neke raja Daud tesnwo natu I.” ");
INSERT INTO slu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dendye Yesuske tyanuk ti sir de byohe, “Koldyesikemo, kyanmwane Daud a hyaly Mesiaske o wasi Amam Lan a I, ti kyoat Hulasokwe Memeanke kkyarya ti Daud, ma kyesy ti Mazmurke ma kbyohe, ");
INSERT INTO slu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Hulasokwe tyanuk ti wasikw Amam Lanke ma byohe, “Mtwaklulw ti wen manety alanke, neke ti serikw wanke, mamode kala iry mamnisik Oare ma mswaa lwaumw ti uno matat nekre.”’ ");
INSERT INTO slu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lemadendye, kolnye raja Daud yabuk Mesiaske ti wasi Amam Lanke, ode kolkyabei mane raja Daud tesnwo natu I ne de?” ");
INSERT INTO slu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kyoat desyo lema kika iry a mares ma rhalas Yesuske ti tun itanuk desikre elik, ode lema irkye it a ires ma yena namit-namit toha Yesuske dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lemadendye Yesuske tyanuk ti wasi matoha Iare, ror iry ribun lan desikre ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iry mahe snurat o tnyetak Musake, ror iry manosy lui Farisi-nare wait karyake, neke rajar tnyetak Musake wasi kbuanare ti e, kola dene heitlulswo Musa iajar ti iry a Israel-are ne. ");
INSERT INTO slu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Koldyesikemo mtyoha ma myala kola nam raajar ti eare mumu. Keskyede kete mtyoha wait tot raalanare. Kali rajar tnyetak Musake ti e, keskyede sir a rmesan a lema rtoha, ma rala kola nam raajar desikre. ");
INSERT INTO slu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ode ralkyaw sir, ma rpaksa irire mumu ma musti mo rtoha wait tnyetak kubkubak ribun a ratenuk nekre,keskye wait tnyetak ratenuk desikre ksunw ksyalik ma irire rtoha. Ode biar ma koldyesy, keskyede sir neke lema rsaluk irire ti ratoha wait tnyetak kubkubak ribun a ratenuk desikre. De kola dene rasaa balak lan ne ti irire hesatare ne. ");
INSERT INTO slu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ode ktela raala nekre mumu ne, rala ma khyury ma irire mumu ne ratos, ma ana rleru sir ode rdakin sir bo. Neke rkesy a Hulasokwe tunanare ti atyahkye, ma rluk ti kwena raala ma lan ma kbyilak kyalamo irire raalanare, ode ral ma rlel ti simat o sout. Ode kyaki-kyaki ne rhonak rabit narnarure, ktyabal a lelel smwel ktasi narnarw nekre. ");
INSERT INTO slu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ode kolnye rsukar Yahudi-nare wait sey a rasambayan tiare, desikeo rdakin ma rtaklulw ti kader mamin ti lulw nekre. Ode kyalamo rbai kalkal inaknam lan nekre, desikeo robak ma rtaklulw ti wen erasare ma irire ralan sir. ");
INSERT INTO slu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ode rdakin dakun ma irire rou ti sir ti sal a krala, ode rdakin dakun ma irire rabuk sir ti ‘Tuanggurw.’ ");
INSERT INTO slu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Keskyede ei neke kete myou ma rabuk e ti ‘tuanggurw,’ kali wasimy Tuanggurkwe sasasam I bo.Ode ei ne mumu neke mihatnima e, kali sekye krala sasam e. ");
INSERT INTO slu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ode kete myabuk irkye it ti nuske ktem ne ma mbyohe, ‘Amamy a i.’ Kali Amamkye sasasam I bo, ma imin ti wen sra eraske. ");
INSERT INTO slu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ode kete mdyakin ma irire rbohe ei ne mika usu khatu, kali wasimy Uskwe Khatuke sasasam I bo, neke Mesiaske. ");
INSERT INTO slu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dendye esei desike byuma lan a i ti ei ne mumu, desikeo musti mo nyauk tenanke ma syalwir ti irire. ");
INSERT INTO slu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kali kolnye esei desike byitil tenanke ma atat, desikemo ana Hulasokwe nyauk a i. Klala esei desike nyauk tenanke ma babaf, desikemo ana Hulasokwe byitil a i.” ");
INSERT INTO slu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Maktei o Yesuske tyanuk huruk ma byohe, “Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei ne mbya etno eta iry a mabuma Hulasokwe ihareta sir kola Rajake ne. Klala ei ne lema myou elik ma Hulasokwe hyareta e kola Rajake, ode ei ne dakun o mbya etno eta iry mabuma Hulasokwe ihareta sir ne.  ");
INSERT INTO slu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei ne mikakmet a enen som nekre, ma misoruk wait sey o sar nekre, ktyabal wait malolire. Ode kolnye msyambayan ti ribunke khahake, desikeo wasimy sambayanare narnarnarw ksyalik, ma kyeteta totamy atyat mialanare. Dendye Hulasokwe ana yukun e mo ksunw ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei ne mihlolwain ma mnyusuk soar, ode mlyakut ma myorw de msyai kususwan o huar nekre ma myobak iry, ma kolnye mitot irkye it, desikeo myajar i ma tyoha wasimy a tnyetak kubkubak ribun desikre, ma khyury ma iry desike tyoha e de. Keskyede kalyauke o ei ne myala iry desike ma ana syukar ei wen ay malehur manal nini namke kralake, kali wasi lim o sal nekre ribun ma kbyilak e dakun de. ");
INSERT INTO slu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Atyatke ana kidurak iry manety lulw e ne! Ei ne lema mmyatakit namit-namit! Kali myajar irire ma mbyohe, ‘Kolnye irkye it ma yal Hulasokwe Seike kanike ma yal ma ihwab, desikemo iry desike wasi inahwab desy lema malkyakaw, ode lema kyety eta i. Klala kolnye yal blyawan kunkuny mamin ti Hulasokwe Seike ma ihwab, desikemo iry desike wasi inahwab desy malkyakaw ode ana kyety eta i, ma musti mo ana yala kola wasi inahwab desy.’ ");
INSERT INTO slu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hei iry ktem a lema mamatakit namit-namit e! Kyanmwane mikea koldyesy ne de? Ktyoha e mo kabei nelnyely de? Blyawan kunkuny desy ta Hulasokwe Seike de? De lema Hulasokwe Seike ne kiala blyawan kunkuny desy ma nelnyely ne e? ");
INSERT INTO slu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ode kolnye mtyanuk huruk ma mbyohe, ‘Kolnye irkye it a yal lat raeh heal ti ma raabar ti Hulasokwe ne kanike ma yal ma ihwab, desikemo wasi inahwab desy ana lema kyety eta i. Klala kolnye kabei desike yal heal raabar desy anike ma ihwab, desikemo iry desike wasi inahwab desy ana kyety eta i, ma musti mo ana yala kola wasi inahwab desy.’ ");
INSERT INTO slu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hei, matamire kbyol ma lema myatakit e! Nam sai nelnyely ma kbyilak de? Heal raeh ma raabarke, ta lat raeh heal tike de? De lema lat raeh heal tike ne kiala heal raabar desy ma nelnyely a i ne e? ");
INSERT INTO slu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dendye kolnye esei desike yal lat raeh heal tike kanike ma ihwab, desikemo yal lat desike kanike, ktyabal a nam mamin ti lat raeh heal tike khaha desikre mumu ma ihwab dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ode esei desike yal Hulasokwe Seike kanike ma ihwab, desikemo yal Hulasokwe Seike, ktyabal Hulasokwe Anike dakun ma ihwab, kali Hulasokwe imin ti Sey desy dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ode kolnye esei desike yal wen sra eras Hulasokwe imin tike ma ihwab, desikemo yal Hulasokwe wasi kader Rajake, ktyabal Hulasokwe Anike dakun ma ihwab, kali Hulasokwe myesan tyaklulw ti kader desy bo. ");
INSERT INTO slu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali mindil ma myatos ti ktela kakanare bo, kola ne: hinamy a maresan o, selasi o, wakw mahon o, bawang mermer desikre, ktyabal nam salik mitan ti wasimy bo desikre, khesinare mumu neke, myal sasam toha heanke ma myal ti Hulasokwe de. Nam miala desikre eras, keskye lema mindil ma mtyoha tnyetak Musa ida nekre, neke eras lan-lan ma kbyilak ti minal sasam toha heanke ma minal ti Hulasokwe desy. Tnyetak desikre kolnye: Kyaki-kyaki ne nam miohutare musti mo mlay, ode musti mo milobak iry, ode musti mo mkyumak manenen wasimy tohtohakke ti Hulasokwe dakun. Tnyetak desikre mumu ne musti mo mtyoha ma myala, de kete mtyoha ma myala dum bo, klala lema myala dum. ");
INSERT INTO slu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lemade iry manety lulw e! Ei ne lema mmyatakit namit-namit! Kali lema myalkyaw e ma myala nam a mlay mamin ti tnyetak Musake, de myalkyaw e ma myala nam lema maka kbuan nekre bo. Kola ne ei ne mindil ma myaditi ninake toha wasimy a wer mienure ma kete myenw a nina desy, klala lema myatakit unta lan ne ma myaditi i, de mtyel i iktemtem bo. ");
INSERT INTO slu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei neke myola iry a kyalamo maut a sru o mbinan nekre, ma mindil ma myut ketanare ma nelnyely bo, klala kralanare lema myut, de kimet-kiray koldyesy bo. Desike klyosu elik ralamy krala maray nekre ma desy. Kali mihatw ode mdyakin irire wait nam ma misoruk toha sir. ");
INSERT INTO slu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lemade iry a Farisi matmabol e, musti mo myala ralamy kralanare ma nelnyely aduk, mamode nam mitanuk ode nam miala nekre mlay, ode eras dakun. Kola ne kolnye myut wasimy nam miknam tiare kralanare, desikemo ana ketanare nelnyely dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei neke myola ne mamatire wait asa-nare ma raka seire ti. Ma sey desikre ral aurke ma rlabur ketanare ma bokbok ode nelnyelnyely, keskye asa-na krala desikre khyon busu, kali kbyenw ti mamatire luritare, ktyabal a ray ribun lan ne dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kola ne e dakun, ma irire rseak e, desyo rbohe ei ne ralamire eras, keskyede mikakmet, ode ralamy kralanare kihatw, ode khyon busu. ");
INSERT INTO slu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Atyatke ana kidurak iry mahe snurat o tnyetak Musa e ne, ode iry manosy lui Farisi e ne! Ei ne mikakmet ma myala tenamire ma mlay, keskye ti ralami kralanare ne lema mlay! Kali ei neke msyadiri sey eras-eras nekre, ti wen a iry a heitlulswo manety Hulasokwe wasi nyano ma ramaty neke wait asa ramlin sir tiare khahanare. Ode iry a mamorif a mlay nekre ma ramaty ne, neke miyabi wait tugunare ma eras dakun. ");
INSERT INTO slu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ode mtyanuk ma mbyohe, ‘Kolnye aramy neke myorif ti taras ara ebnwo matrumamy, desikemo lema aramy mtyoha sir ma mtyabahunw a iry manety Hulasokwe wasi nyano desikre.’ ");
INSERT INTO slu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Keskyede ktyoha nam mitanukare, desikeo klyosu elik ohe, ei neke ebnwo matrumamy sir ne ratabahunw a iry manety Hulasokwe wasi nyanoare ne! ");
INSERT INTO slu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dendye lemamo myaktemak elik ebnwo matrumamy wait tot atyat raala desikre. ");
INSERT INTO slu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hei! Ni o manunwtesnwo natut e! Myala kolkyabei ma kete rotuk e bai wen ay malehur manal nini namke kralake de? ");
INSERT INTO slu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lemadendye mtyomolu! Yaw neke ana kaso iry manety Hulasokwe wasi nyanoare dum, ode iry mahetelare dum, ode iry mahe snurat o tnyetak Musake dum, ma ti rait a e ma rajar e. Keskyede iry nekre ana mtyabahunw dum, ode mbyakw a dum ti tul masanwalw ike, ode mbyaa myoli sir ti wait nus o hnu, ma myoban de mtyaba dum ti sey rasambayan tiare. ");
INSERT INTO slu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dendye ei neke ana mhyar iry a lema maka salat de ratabahunw sir mumu nekre laratare. Iry a ratabahunw sir ne, neke kyala kyosy a Habel iry mlay desy, ma kmya nini kyait a Zakharia. Zakharia neke Berekhya ananke, ma kola mtyabahunw i ti klelan wen a lat raeh heal tike, kyor wen nelnyely rasambayan tike. ");
INSERT INTO slu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lemadendye mtyomolu mamak nam kutanuk ti e ne. Ktela atyat dai kutanuk nekre mumu neke ana taras selsel neke mhyar!” ");
INSERT INTO slu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lemadendye Yesuske ralake kitol ma yatela ma byohe, “Weee Yerusalem, Yerusalem eee! Ei ne mitabahunw a iry manety Hulasokwe wasi nyanoare ne, ode myal hature ma myatdya iry a Hulasokwe iaso nekre nini rmaty! Yaw ne sew kyaki neke kou ma kuwahuk e, ma kkwarduan miktemtem mumu, kola ne sihi ltyenke kyuru yahuk ananare, ma lyukut o kyoka sir, keskyede lema myou. ");
INSERT INTO slu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Myatos! Wasimy sey ne,ana Hulasokwe tyutuk lakhidik ma knani koldyesy bo. ");
INSERT INTO slu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lemadendye ktwanuk ti e ohe, kyala kyosy senwe, ana lema myatakit Yaw dakun de, nini mtyanuk ma mbyohe, ‘Hulasokwe yal eraske ti I, kali myaa yor ity Ebutke Anike.’” ");
INSERT INTO slu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kyoat a Yesuske yor wasi matoha Iare rala ma rbetik toha Hulasokwe Seike bonyo, wasi matoha Ike it a tyanuk ti I ma byohe, “Tuanggurw, matos Hulasokwe Sei ne, ktyabal sey ribun mamin ti Sei ne wasi kintal ne eras a ksyalik!” ");
INSERT INTO slu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Myatos a sey lan a eras-eras nekre deny ode? Dendye mtyomolu mamak nam kutanuk ne! Ana kyait sekwe, desikeo irire rma ma raskyui-raskyay hatw ranal ma raala sey desikre mumu ma kiskyui-kiskyay, ma sasam lema kimin ti kwenake dakun.” ");
INSERT INTO slu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lemade Yesuske lyakut ma syai bai kususwan Zaitunke ti tyaklulw ti desy. Desike bonyo wasi matoha Iare rma ma rena I ma rbohe, “Mtwanuk ma aramy ohe, hekyabei o nam mutanuk nekre mumu ne kdi ti de? Ode nyatos sakar ne kilosu o ana muma huruk ne de? Ode nyatos sakar ne kilosu huruk o nuske ktem ne kyala ma kilodur ne de?” ");
INSERT INTO slu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dendye Yesuske hyalas sir ma byohe, “Mijaga mamak a e, ma irire kete rakakmet a e! ");
INSERT INTO slu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kali irire ribun ana rma ma ral Anikkwe ma rtanuk de rbohe, sir neke Mesias sir.Ma khyury ma rakakmet a irire ribun ma rtoha sir. ");
INSERT INTO slu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ode kolnye mtyomolu britke o irire ramdiriat,ktyabal inamdiriatke ksorbubuke, desikeo kete mimtaut. Kali nam desikre mumu neke musti mo kdi ti a kmuna, keskye lenla kyait sekwe ma nuske ktem ne klyodur. ");
INSERT INTO slu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ode bangsa mamin ti nuske ktem ne ana it de syorw a it ma ramdiriat, ktyabal raja-nare ramdiriat a ror raja salik. Ode ana lu o laar lan a ksyalik ti kabei ta kabei bo. Ode ana lurwakyeksunw ksyalik ti kabei ta kabei dakun. ");
INSERT INTO slu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Masunw desike ksunsunuke kola ne enen maala ma madur hahke, ti idur hah o ikoman a ksunsunuke ne. Ktela desikre mumu ne, nenmo masunkwe khyehyeike ti taras harharw ne ma desy, keskyede masunw desikre ana ksunsununare ktyabal a ktyabal toha. ");
INSERT INTO slu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kyoat desy dakun o ana irire rkumak a e, ma rluk a dum ti sey metmetke kralake, ode ror dum ba ti roban de rtaba sir, ode rtabahunw a dum dakun. Ode ana bangsa mamin nuske ktem ne mumu ne ramnisik a e, kali mtyohak ma Yaw. ");
INSERT INTO slu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ode irire ribun ana rulak sir ma lema rtohak ma Yaw, dendye it de kyeta it, ode it de imnisik it. ");
INSERT INTO slu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ode irire ribun ana rma ma rakakmet ma rbohe, sir neke iry manety Hulasokwe wasi nyano sir. Ktela desike ne kyala irire ribun ma lema rhe raba sara. ");
INSERT INTO slu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ode tot atyatke ti nuske ktem ne ktyabal a ktyabal toha, dendye khyury ma it de lema lyobak it de. ");
INSERT INTO slu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Keskyede kolnye mkyumak malkyakaw wasimy tohtohakke ma Yaw nini kyait teike, desikemo ana mmyorif nini nam ti wen sra eraske. ");
INSERT INTO slu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ode ana rabrita Brit Eras a Hulasokwe ihareta kola Rajake ne ti nuske ktem ne mumu, ma irire mumu ne rtomolu Brit Eras desy ma ktei, desikeo nenmo nuske ktem ne klyodur.” ");
INSERT INTO slu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Lemadendye Yesuske tyanuk huruk ma byohe, “Ana kyait sekwe ma nam Daniel iry a manety Hulasokwe wasi nyano neke ikeskye ana kdi ti. Neke kyesy kolnye: ‘Ei ne ana myatos iry mahatw ksyalikke it, ma imdiry ti wen nelnyelnyely a lema bisa ma irkye isukar ma imdiry ti ne. Keskyede iry mahatw desike ne isukar ma iala wen nelnyelnyely desy ma kiray ne.’” –iry mabacaare musti mo mhye nam Yesuske itanuk ne kbuanke– ");
INSERT INTO slu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Kyoat desike iry mamin ti propinsi Yudeake musti mo riar toha desy, ma ra-la rbai kususwanare. ");
INSERT INTO slu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ti sew desy dakun o, kolnye iry mamin a mlosire, desikemo kete rsukar ei sey kralanare ma ral lan o hnutat. ");
INSERT INTO slu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ode kolnye ramin ti boare, desikemo kete rulak sir ei hnuke ma ral wait simbol o rabit. ");
INSERT INTO slu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sew desy dakun o enen a manor tenatare ne, ror enen a masusw anatare ne, ana rkoman masunkwe lan-lan. ");
INSERT INTO slu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lemadendye musti mo msyambayan ma sew a mila toha masunw desy kete kdi ti ti sew a Inamreske, ta kete kdi ti ti sew a us o esw. ");
INSERT INTO slu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kali kyoat desike ana masunkwe kdyan irkye o ksunw ksyalik. Ode irkye lenla kyoman masunw maoly desy elik, neke kyala kyosy khyehyei a Hulasokwe iala nuske ktem ne, ma ti kyait sew desy. Ode kyala kyosy sew desy ma kibai lulkwe ne, masunw maoly desike ana lema kdyan irkye de. ");
INSERT INTO slu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kyoat desike Hulasokwe yatuukseure ti taras masunw desy, kali kolnye lema yatuuk seure ti sew masunw desikre, desikemo lema irkye it a myorif dakun. Keskyede kali Hulasokwe lyobak wasi iry a iilikare, lemade yatuuk seure ti taras masunw desy. ");
INSERT INTO slu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kyoat desike irire rtanuk ti e ma rbohe, ‘Myatos, Mesiaske imin ti ne.’ Ta dum a rbohe, ‘Imin ti so.’ Desikemo kete mtyohak tun ratanuk desikre. ");
INSERT INTO slu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kali kyoat desike irire ribun ana rma ma rakakmet ma rbohe, sir neke Mesias sir. Ode irire ribun ana rma dakun ma rakakmet ma rbohe, sir ne iry a manety Hulasokwe wasi nyano sir. Ode ana rala nyatos o ktela masalsyalik iare dakun. Mamode ktela o nyatos raala desikre khyury ma kikakmet a iry mamin ti nuske ktem ne, ma ti kyal a robak ma rakakmet a iry a Hulasokwe iilikare dakun. ");
INSERT INTO slu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lemadendye mijaga mamak a e! Kali ktwanuk tun nekre mumu ti e a kmuna de. ");
INSERT INTO slu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Dendye kolnye irire rtanuk ti e ma rbohe, ‘Myatos, Mesiaske I so wen malosy-loskye!’ Desikemo kete mbyai wen so. Ta rbohe, ‘Myatos, I ne ibuny ti sekye kralake ne!’ Desikemo kete mtyohak. ");
INSERT INTO slu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kali kyoat Irkye Anankeana yulak I ma mya, desikeo iry mamin nuske ktem ne mumu ne rmatakit a I. Kali ana mya, desikeo kola dene hitikke kihitik a kyosy a laitke ksuu timurke, ma kbyai ksuu haratke. ");
INSERT INTO slu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kola dene tatos de manu lusire rawahuk sir ti desy, desikeo mamatire tbunatare kimin ti desy dakun. Koldyesy dakun ti, kolnye myatos nyatos desikre, desikeo mhye ohe, ana kuma huruk ne kyarasy ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Lemade Yesuske tyanuk ti wasi matoha Iare huruk ma byohe, “Kyoat masunw lan desike kisakut bonyo, ‘Sekwe lema ryan, de kelerkok, ode hulke lema nyely dakun, ode ana ftunare rdi toha laitke ei lasmyerke khaha ne, ode nam mahareta salik mamin ti laitke ne, ana rdi ma raskyui-raskyay.’ ");
INSERT INTO slu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kyoat desy dakun o Irkye Ananke ana syusu wasi nyatos ana ima ne ti laitke. Neke khyury ma iry a mamin ti nuske ktem ne mumu ma lema ratohak ti I ne, neke ralatare ksyal, ti raatos nyatos desy. Ode Irkye Ananke ana yorw yosy laitke ma mya, desikeo imin ti oanke kralake. Ode ana ima neke yety wasi haretke mumu, ktyabal wasi madelaf a masalsyalik i ne. ");
INSERT INTO slu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ode kyoat desy dakun o ana yaso wasi nyasoare ma rohw a wait a strompetare o laitke ma kdudunare lan. Maktei o yaso wasi nyasoare ma rorw rosy laitke, ma rma ma rawahuk iry a Hulasokwe iilikare ti lasmyerke khaha ne mumu, neke kyala kyosy a kseri timur o harat, seryab o tran.” ");
INSERT INTO slu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Lemade Yesuske tyanuk tun inahliakke ti wasi matoha Iare ma byohe, “Myatos ti aw ara desy bo, kolnye myatos aw ara desike ma kihun, desikemo mhye ohe, kyarasy ti lemanke ma desy. ");
INSERT INTO slu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Koldyesy dakun ti miatos a nyatos masunw ribun lan kutanuk desikre, ma kolnye kdi ti mumu de, desikeo bisa ma mhye ohe, sew a Irkye Ananke ima huruk neke kyarasy de. Ma wasi sew a ima neke, ne kitaktaka i ti holholatke kmatake ne. ");
INSERT INTO slu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mtyomolu mamak nam kutanuk ti e ne! Iry a mamorif ti taras neke dum a ana lenla rmaty, kolnye nam nekre mumu ne lenla kdi ti. ");
INSERT INTO slu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dendye mnyenas! Lait o lasmyer ne ana kitayar, klala tunakure lema kitayar, de kimin ma kyal nini nam ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Biar ma koldyesy, keskyede lema irkye it a hye ohe, Irkye Ananke ima huruk ne ana hekyab o kdi ti. Ma ti kyal nyaso manosy laitare lema rhe, ode Irkye Ananke o lema hye dakun. De lenla Amaku myesan a hye bo.” ");
INSERT INTO slu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ode kolnye kyoat Irkye Ananke ana mya huruk mai nuske ktem ne, ana irire kele rsumuk mait sir, kola dene irire ti taras a heitlulswo Nuh a imorif tike, ti kele rasumuk mait sir ne. ");
INSERT INTO slu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kali kyoat wer maluburke lenla kmya, desikeo irire wait a ktela ramukmuka sir ti wait insa o inlana ne, ode ti rala kalkal ma raknam o raenw ne, nini ti kyait sew a Nuh isukar ei batbatakke kralake ne. ");
INSERT INTO slu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma iry desikre lema rhe ohe sai ana kdi ti, de kele rsumuk mait sir bonyo, wer maluburke kmya ma ktyabahunw a sir mumu, desikeo nenmo rhe toha lbwetat. Koldyesy dakun ti ana kyait sew a Irkye Ananke mya huruk mai nuske ktem ne. ");
INSERT INTO slu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kola dene wamwankye enaru ma rkarya ti boke, desikeo Hulasokwe yilik sasam ma yor i ma rba, klala sasam a tyutuk a i. ");
INSERT INTO slu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kola dene wamfwetke enaru ma rtaklulw ma rtutu hettilkye, desikeo Hulasokwe yilik sasam ma yor i ma rba, klala sasam a tyutuk a i. ");
INSERT INTO slu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lemadendye mijaga mamak a e, kali ana lema mhye ohe, sew kabei o wasimy Amam Lanke mya huruk. ");
INSERT INTO slu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Keskyede mnyenas mamak wasikw inahliak ne! Kolnye sekye kebuke hye ohe, kyoban enai ti kyoat manametke ana ima ne, lemade sekye kebu desike dakun o ana lema yenaf, de ijaga bain-bain ma iry manamet desike lema bisa ma syukar ei sekye kralake elik. ");
INSERT INTO slu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lemadendye ei ne musti mo kyaki-kyaki ne mijaga mamamak a e. Kali Irkye Ananke ana mya, keskye miktemtem neke lema mhye o hekyabei.” ");
INSERT INTO slu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Lemade ity Ebut Yesuske tyanuk ma byohe, “Ti makarya ei ne mumu ne, esei desike kyarya mamak ti wasi lalanke, ode hye telke, ode itotomolu tel ti wasi lalanke, desikemo i desike wasi lalanke ana byitil i, ma ika usu khatu ti makarya ida nekre, ma i neke sew kyaki nekre ihe kotw ti makarya ida desikre ma ra. ");
INSERT INTO slu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Desikemo ana eraske kimin ti makarya maoly desy, kolnye wasi lalanke yulak i ma syeak makarya desy, desikeo malmata kyarya wasi karya desy. ");
INSERT INTO slu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dendye mtyomolu mamak nam kutanuk ne! Makarya desike wasi lalanke ana byitil i huruk, ma syosan lalan desy wasi malolkye, ode syeak ti wasi lan o hnutan desikre mumu. ");
INSERT INTO slu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Klala kolnye makarya desike ryekan atyatke ma tyanuk ti ralake kralake ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Wasikw lalanke soso i a nggora ma lenla mya.’ Lemade makarya desike yoban makarya ida nekre, ode iknam o yenw yor maenw tuanare. ");
INSERT INTO slu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dendye makarya desike lema hye mait o wasi lalanke yulak i ma mya de. ");
INSERT INTO slu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dendye wasi lalan desike yatos makarya desy wasi ktela iala desike bonyo, tyabahunw makarya desy, ode yotuk i bai wen iry a rakakmet ma rala tenatare ma mlay keskye ti ralat a kralanare lema mlay ne, neke ti wenat raotuk sir tike. Ti wen desike masunkwe ode serserke lan ti a ksyalik.” ");
INSERT INTO slu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuske tyanuk tun inahliakke it huruk ma byohe, “Hulasokwe ima ma ihareta kola Rajake ne, neke kuhliak ti wararke hean, ma rtunw wait damarare ma ti rbalan wamwany masake it. ");
INSERT INTO slu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ti warar dehean desike enasim a ktem sir, ode enasim a rhe ei lulw o lyaw. ");
INSERT INTO slu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ode warar desim a ktem desikre rba, desikeo rety a wait damarare, ma nulke cuma mo kimin ti damar desikre bo. Klala lema rety a nul ma kbyilak, ma kolnye nulare bakbak ti damar desikre, desikeo lema kika nul ma ana ralik ti wait damar desikre huruk. ");
INSERT INTO slu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Klala warar desim a mahei lulw o lyaw desikre rba, desikeo rety a wait damarare, ktyabal nul mabilakare ma kimin ti it o it ne wasi botal, ma kolnye nulare bakbak ti wait damarare, desikeo ana ralik wait nul mamin botal desikre ti wait damarare huruk. ");
INSERT INTO slu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Keskyede wamwany a maala ma masa desike inggonw ti mamake, lemade warar dehean desike matatare koskosa, dendye renaf. ");
INSERT INTO slu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ode kyoat metdyet a kditlan ne bonyo, rtomolu irire dum ma ratelat ma rbohe, ‘Wamwany masa ne mya de! Mya ma tba ti tbalan a i!’ ");
INSERT INTO slu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lemade warar dehean desike rbatar mumu, ma rasosan wait damarare. ");
INSERT INTO slu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dendye warar desim a ktem desikre rtanuk ti warar desim a mahei lulw o lyaw desikre ma rbohe, ‘Myal nulare ratebikan ma aramy, kali ara wasimy damarare kyala ma kmyaty ma ne.’ ");
INSERT INTO slu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Keskyede warar desim a mahei lulw o lyaw desikre rhalas warar desim a ktem desikre ma rbohe, ‘Kete mkyeyer, kali lema bisa ma aramy myal ti e. Kali kolnye aramy mihe nul ne ma myor a e, desikemo ana lema kyait aramy, ode ana lema kyait e dakun. De myou mo, mbya ti mlyiw o maketa nulare o so.’ ");
INSERT INTO slu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Keskyede kyoat warar desim a ktem desikre rba ti raliw a nulke bonyo, wamwany maala ma masa desike mya dakun. Lemade warar desim a mahei lulw o lyaw desikre ror wamwany masa desy ma rsukar ei wen raknam tike, ode rholat eta holholatke. ");
INSERT INTO slu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dendye kyoat warar desim a ktem desikre rama bonyo, holholatke khyolat a i de, dendye ratelat ma rbohe, ‘Amam lan o, mlwakat holholatke ma aramy.’ ");
INSERT INTO slu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Keskyede Amam lan desike hyalas sir ma byohe, ‘Ei neke lema khwe e elik-elik.’” ");
INSERT INTO slu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dendye Yesuske tyanuk ti wasi matoha Iare ma byohe, “Koldyesikemo mijaga mamamak a e, kali lema mhye o kyoban enai, ode sew kabei, desikeo kmwa huruk.” ");
INSERT INTO slu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuske tyanuk huruk ma byohe, “Kolnye taras ana Hulasokwe ima ma ihareta kola Rajake ne kmya, neke kuhliak ti iry maala ma mahlolwain bai hnu sosoke it. Ma kolnye yala ma bya bonyo, yabuk wasi makaryaare, ode byu ti sir ma rseak ti wasi malolkye. ");
INSERT INTO slu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Lemadendye ihe wasi maloly desike ti wasi makarya desikre, ma ktyoha makarya desikre amalkyautare. Wasi makarya desikre irkye enatelw a sir. Dendye iry mahlolwain desike yal kuban blyawan bokbokke ribunke enasim ti it, ode yal kuban blyawan bokbokke ribunke enaru ti it, ode yal kuban blyawan bokbokke ribunke sasam ti it. Maktei bonyo nenmo iry desike ihlolwain bai hnu soso desy. ");
INSERT INTO slu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dendye iry manosy a kuban blyawan bokbok ribun desim desike, bya ti lyiw nam ma ti kyeta, desikeo itot a kuban blyawan bokbokke ribunke enasim huruk, ma ktyabal a kuban blyawan bokbok ribunke enasim ranal ti i desy. ");
INSERT INTO slu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ode manosy a kuban blyawan bokbok ribunke enaru desike, yala koldyesy dakun, desikeo itot a kuban blyawan bokbokke ribunke enaru huruk, ma ktyabal a kuban blyawan bokbok ribunke enaru ranal ti i desy. ");
INSERT INTO slu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Klala iry manosy a kuban blyawan bokbok a ribunke sasam desy, bya ti kyaly a lasmyerke, ode itina amam lan desike wasi kuban desy ti. ");
INSERT INTO slu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ode klenke soso dakun de, ma makarya desikre wait a amam lan desike yulak i ma mai hnuke. Dendye yabuk wasi makarya detelw desy, ma it o it neke rlosu wait kuban mabilakare ti i. ");
INSERT INTO slu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dendye makarya manosy kuban blyawan bokbok ribunke enasim desike mya, desikeo yety kuban blyawan bokbokke ribunke hean ma yal ti wasi amam lanke. Ode tyanuk ti wasi amam lanke ma byohe, ‘Amam lan o, kuban ribun desim a munal ma yaw desy, neke kbwa ti kliw nam ma kmwa ma kkweta, desikeo kutot mabilakke neke kuban blyawan bokbokke ribunke enasim huruk. Lemade kuwahuk ti ktyabal munal ma yakwe, desikeo kyal ribunke hean ma ne.’ ");
INSERT INTO slu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lemade amam lan desike tyanuk ti wasi makarya desy ma byohe, ‘Oi ne makarya eras a o, ode mutotomolu tel. Kali karyaamw muala desy eras a ksyalik. Dendye ktwohak o ti ktela kakanare de, lemade ana ktwohak o ti ktela lanare dakun. Dendye mswukar ma mor yaw ma tala kalkal ma tamukmuka ity.’ ");
INSERT INTO slu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Maktei o makarya manosy kuban blyawan bokbok ribun deru desike mya, desikeo yety kuban blyawan bokbokke ribunke enaat ma yal ti wasi amam lanke, ode tyanuk ti wasi amam lanke ma byohe, ‘Amam lan o, kuban blyawan bokbok ribunke enaru munal ma yaw desy, neke kbwa ti kliw nam ma kmwa ma kkweta, desikeo kutot mabilakke, neke kuban blyawan bokbokke ribunke enaru huruk. Lemade kuwahuk ti ktyabal munal ma yaw desy, desikeo kyal ribunke enaat ma ne.’ ");
INSERT INTO slu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lemade amam lan desike tyanuk ti wasimw makarya desy ma byohe, ‘Oi ne makarya eras a o, ode mutotomolu tel. Kali karyaamw muala desy eras a ksyalik. Dendye ktwohak o ti ktela kakanare de, lemade ana ktwohak o ti ktela lanare dakun. Dendye mswukar ma mor yaw ma tala kalkal ma tamukmuka ity.’ ");
INSERT INTO slu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ode makarya ida manosy a kuban ribun sasam desike mya dakun ma byohe, ‘Amam lan o, khwe ohe oi neke ralamkwe ngkora a ksyalik. Ode oi neke mukita ma mu irire maslyesatare, kali mukita ma mal iry salik wait boa kisinare, keskye lema mtwan namit-namit ti bo desy. ");
INSERT INTO slu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lemadendye kumtaut ohe, ana kala sal kuban desy, desikeo mkweyer a yaw. Dendye kbwa ti kutina wasimw kuban blyawan bokbok ribunke sasam munal ma yaw desy, ti lasmyerke kralake. Lemade kety ma mane. Dendye mal, kali wasimw.’ ");
INSERT INTO slu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lemade amam lan desike tyanuk ti wasi makarya desy ma byohe, ‘Hei, oi ne mukbo ma mkwarya, ode totamure atyat! Ode mrwekan ohe yaw ne ralakkwe ngkora ksyalik e? Ode mrwekan dakun ohe lema kuka wasikw bo ma ktwan namit-namit ti, de kukita ma ku irire maslyesatare toha wait boa kisinare bony e? ");
INSERT INTO slu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Dendye mhwe ma koldyesy mo, kyanmwane lema munal wasikw kuban desy ti iry salik, ma ti rabeta bai lulkwe ne de? Ma kolnye kulak yaw ma kmwa, desikemo kal wasikw kuban desy ktyabal a wasi mabilakke nde.’ ");
INSERT INTO slu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lemadendye amam lan desy tyanuk ti wasi makarya idanare ma byohe, ‘Myal kuban desy toha wan desy, ode myal ti iry makumak wasikw kuban blyawan bokbok ribun dehean desy.’ ");
INSERT INTO slu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lemade amam lan desike hyalas iry desikre ma byohe, ‘Mnyenas! Esei desike yala mamak nam kunal ti i nekre, desikemo ana kal nam ti i o kbyilak. Klala esei desike lema yala mamak nam kunal ti i nekre, ma biar ma tebikan dakun o, ana kala kolik nam desy toha ike bo. ");
INSERT INTO slu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dendye myotuk makarya ma lema maka kbuan desy bai wen a kelerakokke. Ti wen desike masunkwe ode serserke lan ti a ksyalik.’” ");
INSERT INTO slu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuske tyanuk huruk ma byohe, “Kyoat a Irkye Anankeana mya huruk mai nuske ktem ne, desikeo ana myaa yor wasi madelafke, ode kyor malkyakaw manosy Ama Hulasokwe, ode yor wasi nyasoare mumu toha laitke. Ode ana ima neke, mya ma tyaklulw ti wasi kader maharetake, ma yukun tun ti irire mumu ti nuske ktem ne. ");
INSERT INTO slu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dendye bangsa mamin nuske ktem ne mumu ana rawahuk sir, ma ti rsara Irkye Anan desy. Ode ana ihe sir kola dene majaga dombake, ti ihe dombanare toha bibire ne, ");
INSERT INTO slu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ma ana yal dombanare ei seri wanke, ode yal bibire ei seri wisalke. ");
INSERT INTO slu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ode ana Irkye Anan maka Raja desike ana tyanuk ti iry mamin ti seri wan desikre ma byohe, ‘Hei, iry a Amaku inal a eraske ti e ne! Mmya ma mimin ti wen Amaku ihareta tike. Kali Amaku syosan wen ne kita e de, ti kyoat nuske ktem ne lenla kimin ne. ");
INSERT INTO slu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kali kyoat kumlar, desyo myal kotw ma ku. Ode kyoat kbwatu, desyo myal wer ma kenw. Ode kyoat a kmwa kola mwakunke, desyo myal Yaw ei wasimy sey kralanare. ");
INSERT INTO slu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ode kyoat lema khwonak Yaw, desikeo myal rabit ma khwonak. Ode kyoat kluruk Yaw, desikeo mnyoha wasikw a kbaike ma eras Yaw. Ode kyoat rluk Yaw ti sey metmetke kralake, desikeo mbya ti msyeak Yaw.’ ");
INSERT INTO slu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Keskyede iry mamdiry ti seri wan desy, neke iry a wait mormyorifare mlay ne, neke rhalas I ma rbohe, ‘Ebo, hekyab ne aramy neke myatos O ma mumlar, ma aramy myal kotw ti mu de? Ta mbwatu ma aramy myal wer ti menw de? ");
INSERT INTO slu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ode hekyab ne aramy myatos a O ma mmwa kola mwakun, ma aramy myal O ei sekye kralake de? Ode hekyab ne aramy myatos a O ma lema mhwonak O, ma aramy myal simbol o rabit ti O ma mhwonak de? ");
INSERT INTO slu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ode hekyab ne aramy myatos O ma kluruk O, ta rluk O ei sey metmetke kralake, ma aramy mbya ti msyeak a O de?’ ");
INSERT INTO slu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Lemadendye ana Raja desike tyanuk ti iry desikre ma byohe, ‘Mtyomolu mamak nam kutanuk ne! Kolnye myala nam eras ribun nekre ti wasikw irire, biar ma lema rber o rtahal dakun, desikeo kola ne myala nam eras desikre ma Yaw dakun ma desy.’ ");
INSERT INTO slu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Maktei o Raja desike tyanuk ti iry mamin ti seri wisal desikre ma byohe, ‘Hei iry a ana mamaty e! Myaditi lakhidik e toha ne, ma mbyai ay malehur manal nini namke krala rasosan kita ngkeskwaure wait uskwe khatuke, inor wasi nyasoare ne. ");
INSERT INTO slu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kali kyoat kumlar, desikeo lema myal kotw ma ku. Ode kyoat a kbwatu, desikeo lema myal wer ma kenw. ");
INSERT INTO slu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ode kyoat a kmwa kola mwakunke, desikeo lema myal Yaw ei wasimy sey kralanare. Ode kyoat lema khwonak Yaw, desikeo lema myal simbol o rabit ma khwonak. Ode kyoat a kluruk Yaw, ode rluk Yaw ei sey metmetke kralake, desikeo lema mbya ti msyeak a Yaw.’ ");
INSERT INTO slu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dendye iry mamin ti Rajake seri wisal desikre ana rhalas I ma rbohe, ‘Ebo, hekyab ne aramy myatos O ma mumlar, ta mbwatu, ta mmwa kola mwakunke, ta lema mhwonak O, ta kluruk O, ta rluk O ei sey metmetke kralake, desikeo lema aramy mbya ti msyeak O de?’ ");
INSERT INTO slu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Lemade Raja desike ana tyanuk ti iry desikre ma byohe, ‘Mtyomolu mamak nam kutanuk ne! Kolnye ei neke lema mbyuma msyaluk wasikw iry a lema maber o ktyahal nekre, desikeo kola ne ei neke lema mbyuma msyaluk Yaw dakun ma desy.’ ");
INSERT INTO slu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lemade ktwanuk ti e ohe, iry a mamin ti serikw wisal nekre, ana rsukar ei ay a malehur manal nini namke. Klala iry a mamin ti serikw wanke ne, ana rmorif nini nam ti wen sra eraske.” ");
INSERT INTO slu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ode kyoat Yesuske yajar iry ribunke maktei bonyo, tyanuk ti wasi matoha Iare ma byohe, ");
INSERT INTO slu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ei neke mhye ohe, lenla sekwe enaru bonyo, Yahudi-nare wait sew lan Paskahkekdi ti de. Ode kyoat desy dakun o, irire ana ral Irkye Ananketi iry mamnisik Iare, ma rbakw a I ti tul masanwalw ike.” ");
INSERT INTO slu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kyoat desike iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manety lulw ti Yahudi-nare, neke rawahuk sir ti iry lan lahuk i ti usu khatu mabaa klen desikre, neke wasi sekye. Iry mabaa klen lan lahuk desike, ani Kayafas. ");
INSERT INTO slu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Iry desikre rawahuk sir, ma robak a ksala ma rkumak Yesuske, ma rtabahunw a I. Keskye rahunik ma lema irkye it a hye elik. ");
INSERT INTO slu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Keskyede iry desikre rtanuk huruk de rbohe, “Kete tkumak I ti sew lan Paskahke, kali ana kyety oror o nanwaw ti ribunke khahake.” ");
INSERT INTO slu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kyoat desike Yesuske imin ti hnu Betaniake, desikeo imin ti Simon wasi sekye. Simon neke lulswoke imbaul, keskye eras i de. ");
INSERT INTO slu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ode malmata Yesuske tyaklulw ma iknam bonyo, wamfwetke it ma mya o yety a nul mahon a mtelas a khesi lan ne, ma kimin ti botalke. Botal neke rala toha hatw a marmerke. Ode wamfwet desike yalik nul mahon a mtelas desike mumu ti Yesuske usuke khatuke. ");
INSERT INTO slu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lemade kyoat Yesuske wasi matoha Iare ratos a ktela desy bonyo, rkeyer. Dendye it de tyanuk ti it ma rbohe, “Kyal sai ti ibyata nul mahon a mtelas ne, ne de? ");
INSERT INTO slu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Lemamo kyeta nul mahon a mtelas desy, kali khesike lan. Mamode yal khesi desy ma ihe ti iry a lema manait ei sra o hahare.” ");
INSERT INTO slu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Keskyede Yesuske hye iry desikre nam ratanukare, dendye tyanuk ti sir ma byohe, “Kyanmwane mirekan koldyesy ma mikeyer a wamfwet ne, ne de? De lema mhye o, yala ktela eraske ma Yaw ma ne e? ");
INSERT INTO slu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","De lema mhye ohe, iry a lema manait ei sra o hahare sir ne kyaki-kyaki mo ranor a e ne e? Ode kolnye sew kabei ta kabei ma mbyuma msyaluk a sir, desikemo bisa ma msyaluk sir bo. Klala Yaw neke ana lema kor a e ti sew kyaki nekre de. ");
INSERT INTO slu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kali lenla kmwaty ma ti ramlin a Yaw, keskyede wamfwet neke yalik nul mahon a mtelaske a kmuna ti tenakkwe de, ma kikita elik ti ana kumaty ma ti ramlin a Yaw ne. ");
INSERT INTO slu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lemade mtyomolu mamak nam kutanuk ne! Kyoat a Brit Eras ne rabrita ti kabei ta kabei bo, ti nuske ktem ne, desikeo ana rahes a ktela wamfwet ne ialake dakun, ma kyaki-kyaki ne irire ranenenas a i.” ");
INSERT INTO slu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yudas Iskariot neke Yesuske wasi matoha Ike it ne dakun, ti wasi matoha I dehean a kresi enaru desy. Ma i neke bya ti yait iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ");
INSERT INTO slu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ode tyanuk ti sir ma byohe, “Ana kswusu Yesuske ti e ma mkyumak a I, keskye ana myal sai ma yaw de?” Lemade usu khatu desikre raki kuban blyawan bokbokke hean telw ma ral ti i. ");
INSERT INTO slu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dendye kyala kyosy sew desy, Yudas yobak a klelan a mlakye it, ma bisa ma syusu Yesuske ti iry a mabaa klen ti irkye yor Hulasokwe wait usu khatu desikre. ");
INSERT INTO slu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kyoat sew mamunake ti sew lan a Rana Roty a Lema Ranal Ragi Tike kdi ti, desikeo Yesuske wasi matoha Iare rma ma rena I ma rbohe, “Amam Lan O, wen kabei ne mou ma ti aramy misosan ma ana tana kotw Paskahke ti ne de?” ");
INSERT INTO slu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dendye Yesuske hyalas sir ma byohe, “Mbyai nus Yerusalemke krala desy, ode ana ti desike minal a myor irkye it, ode mtyanuk ti i ma mbyohe, ‘Ara wasimy Tuanggurkwe byohe wasi sekwe kyarasy de, dendye yena ohe, wen kabei ne, ana inor wasi matoha Iare rana kotw Paskahke ti ne de?’” ");
INSERT INTO slu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lemade Yesuske wasi matoha Iare rtoha ma rala kola Yesuske nam itanuk ti sir desikre. Dendye ti wen desike ne rasosan kotw o abw ma ana ror Yesuske raktem a raknam Paskahke ti ne. ");
INSERT INTO slu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dendye sewahke bonyo, Yesuske tyaklulw yor wasi matoha I dehean a kresi enaru desy, ma raktem a raknam Paskahke. ");
INSERT INTO slu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ode kyoat a raknam ti Paskah desy bonyo, Yesuske tyanuk ti wasi matoha Iare ma byohe, “Mtyomolu mamak nam kutanuk ne! Ti ei ne mumu ne, ana irkye it a kyeta Yaw.” ");
INSERT INTO slu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kyoat wasi matoha Iare ratomolu tun itanuk desy bonyo, ralatare kitol a ksyalik, dendye it o it ne rena Yesuske ma rbohe, “Ebo, esei de? Lema yaw o de?” ");
INSERT INTO slu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lemade Yesuske hyalas sir ma byohe, “Iry ana maketa Yaw neke, i ne inor yaw ma aramy mihuhuk a rotkye ti werke ma aramy mina ne. ");
INSERT INTO slu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ktwanuk koldyesy, kali rkesy ti Kitab Lanke ma kbyohe, Irkye Ananke musti mo ana myaty. Keskyede ana atyatke kidurak a iry maketa Irkye Anan desy. Lemamo iry desike kyalake mo kete radur ti i elik.” ");
INSERT INTO slu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Lemadendye Yudas ana maketa Yesuske ne yena Yesuske ma byohe, “Tuanggurw, kete yaw de?” Dendye Yesuske tyanuk ti i ma byohe, “Mmwesan a mtwanuk koldyesy bo.” ");
INSERT INTO slu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kyoat Yesuske yor wasi matoha Iare malmata raknam, desike bonyo Yesuske yal rotkye, ode syambayan ma syalak eraske ba ti Hulasokwe ti roty desy. Maktei o byini-byiny roty desy ma yal ti wasi matoha Iare ode tyanuk ma byohe, “Myal, ode mi. Tenakkwe ne.” ");
INSERT INTO slu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Maktei o yal takwe ma tasy maiskye kwen makitkye kimin ti, ma syambayan ma syalak eraske ba ti Hulasokwe ti tasy maiskye kwen makity desy. Ode isambayan maktei bonyo, yal ti wasi matoha Iare, ode tyanuk ti sir ma byohe, “Myal taw ne, ma myenw kyakar e. ");
INSERT INTO slu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kali larakkwe ne, ma ana kibo ei hahke ma klyitan eta iry ribunke toha wait lim o sal. Ode larakw mabo ei hah neke kyeluk nyatos ohe, tnyetak harharkwe ti irkye yor Hulasokwe, neke nenmo kimin mane. ");
INSERT INTO slu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Keskyede mtyomolu mamak ma ktwanuk ti e. Mlay bain! Kyala kyosy ne ana lema kenw tasy maiskye kwen ne de, nini kyait sew a Amakw ima ma ihareta kola Rajake ti nuske ktem ne, kola ne ihareta ti wen sra eraske ne. Ode ti sew desike, nenmo ana kenw tasy maiskye kwenke kor e huruk ma desy.” ");
INSERT INTO slu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lemade Yesuske yor wasi matoha Iare raora inaorake it ma rleru Hulasokwe, maktei bonyo rlakut ma rbai Kususwan Zaitunke. ");
INSERT INTO slu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Lemade kyoat Yesuske yor wasi matoha Iare raba bonyo, Yesuske tyanuk ti sir ma byohe, “Sewah neke, ana ei ne mumu ne mila toha Yaw, khyali ktela ana kidi ti ma Yaw ne. Kali rkesy ti Kitab Lanke ma kbyohe, ‘Ana ktwabahunw a majaga dombake, ma khyury ma wasi dombanare ana ra-la a raskyui-raskyay.’ ");
INSERT INTO slu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Keskyede ana Hulasokwe yala Yaw ma kmworif huruk toha mamatire, desikeo ana kmuna e bai propinsi Galileake.” ");
INSERT INTO slu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lemade Petrus tyanuk ti Yesuske ma byohe, “Tuanggurw, biar ma sir ne mumu neke ra-la toha O, keskyede yaw ne lema kula toha O elik.” ");
INSERT INTO slu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Keskye Yesuske tyanuk ti i ma byohe, “Petrus o, mtwomolu mamak nam kutanuk ti o ne! Metdyet neke sihkye lenla kyokoak, desikeo mubu a mutuli Yaw kdi a kla-telw de, ma mbwohe lema mhwe Yaw elik.” ");
INSERT INTO slu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Keskyede Petrus a hyalas Yesuske bain-bain ma byohe, “Biar ma rtabahunw a yaw kali ktwoha O, keskye lema bisa ma kubu a kutuli O elik.” Desikeo lianare mumu ne rtanuk koldyesy dakun. ");
INSERT INTO slu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ode kyoat Yesuske yor wasi matoha Iare ranait a kususwan Zaitunke, ma ti wenke it neke kani bo Getsemanike, desike bonyo Yesuske tyanuk ti wasi matoha I desikre ma byohe, “Mtyaklulw ti ne, ma ti kswambayan ti so aduk.” ");
INSERT INTO slu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dendye Yesuske ryubut Petrus, ode Yakobus yor Yohanes a Zebedeus anan deru ne, ma raktem a rba. Kyoat desike Yesuske ralake ksyal a ksyalik, ode ralake lema ktyeka i de. ");
INSERT INTO slu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Lemade tyanuk ti iry detelw desy ma byohe, “Ralakw neke ksyal a ksyalik, kola ne kala ma kmwaty mane. Dendye mimin ne, ode kete myenaf de mijaga mamak.” ");
INSERT INTO slu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Maktei o Yesuske lyakut tebikan bai lulkwe, ode syakitil ma syambayan ti Hulasokwe ma byohe, “O Amo, Oi ne bisa ma mala nam sai ta sai bo. Dendye mou mo, kuten ma ktela masunw ana madi ti ma Yaw neke, maditi toha Yaw.Keskye Amo, kete mtwoha kubuke, de mtwoha mubuke bo.” ");
INSERT INTO slu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Maktei bonyo Yesuske yulak I ma mya ma yait a wasi matoha I detelw desy, desikeo yatos sir o malmata renaf. Lemade tyanuk ti Petrus ma byohe, “Petrus! Lema bisa ma mujak jamke sasam ti munor Yaw ne e? ");
INSERT INTO slu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mijaga mamak ode msyambayan, ma kete nam dum a khyury a e ma mdyi ei lim o sal. Kali ralamy kralanare kbyuma myala nam a mlaire, keskye lema bisa ma myala, kali tenamire lema malkyakaw.” ");
INSERT INTO slu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lemade Yesuske yulak I huruk bai wen isambayan tike, ma syambayan huruk ma byohe, “O Amo, Oi ne bisa ma mala nam sai ta sai bo. Keskye kolnye masunw desike musti mo kdi ti ma Yaw, desikemo kou ma ktela desike kdi ti ma Yaw, ma ktyoha mubuke.” ");
INSERT INTO slu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Maktei o yulak I huruk ma mya ma yait a wasi matoha I detelw desy, desikeo renaf huruk, kali matatare koskosa a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lemade Yesuske tyutuk wasi matoha I detelw desy ti desy, ode yulak I a kla-teluke bai wen isambayan tike ma syambayan. Desyo yoly a wasi sambayan dai desy huruk bo. ");
INSERT INTO slu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maktei o yulak I ma ti yait wasi matoha I detelw desy, desikeo renaf a nggora. Dendye tyanuk ti sir ma byohe, “Myenaf a nggora e? Mienafke mo knyal e de. Myatos! Kyait jamke de. Ma Irkye Ananke rala ma ral I ba ti iry a lim o salare mane. ");
INSERT INTO slu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lemade mbyatar ma tba, kali iry maketa Yaw neke mya de.” ");
INSERT INTO slu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kyoat Yesuske malmata itun a yor wasi matoha Iare, desikeo kele rsoru Yudas ma mya. Yudas neke Yesuske wasi matoha Ike it ne dakun, ti wasi matoha I dehean a kresi enaru desy. Yudas neke mya o yor iry ribunke, kali iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manety lulw ti Yahudi-nare, neke raso iry ribun desy ma rma. Iry ribun desikre rma o rety a kray o oboban, ma rma ma rkumak Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ode kyoat iry ribun desikre lenla rma, desikeo Yudas iry a maketa Yesuske ne tyanuk ktelake it ti iry ribun desikre ma byohe, “Iry ana mikumak neke msyeak de koy a I, iry neke I desy de.” ");
INSERT INTO slu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kyoat iry ribun desikre ranait bonyo, Yudas lyakut elik sara Yesuske ma byohe, “Tuanggurw! Kuten sewah eraske ti O.” Maktei o yoy a I. ");
INSERT INTO slu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Lemade Yesuske tyanuk ti Yudas ma byohe, “Liakw, nam murekkye mala a nde.” Dendye iry ribun desikre rlakut ba ti rkumak Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Keskyede Yesuske wasi matoha Ike it a nyaik a wasi krakye, ma syoby ohut irkye it a tliake. Iry a tlia madohut desike ika at ti iry mabaa klen lan lahukke. ");
INSERT INTO slu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lemadendye Yesuske tyanuk ti iry desy ma byohe, “Hoe! Mswihik wasimw kray desy ei kasulnanke! Kali esei desy ibrenak a mnaske, ana mnas desy kyulak i ma ktyabahunw a i dakun. ");
INSERT INTO slu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Desi mrwekan ohe, Yaw neke lema bisa ma kuten toha Amakw ma yaorif Yaw e? Bisa ma kbwu ti Amakw, ma yaso elik wasi nyaso manosy laitke, neke irkye ribunke hean a kresi enaru a kbyilak (12.000+), ma rma ma rsaluk Yaw. ");
INSERT INTO slu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Keskyede kolnye kala koldyesy, desikemo nam rakesy ti Kitab Lanke lema bisa ma kdi ti!” ");
INSERT INTO slu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lemadendye Yesuske tyanuk ti iry ribun a rama ma rakumak I ne, ma byohe, “Desi mbyohe Yaw neke iry a manamet Yaw e? Mane mmya o myety a kray o oboban nekre ma mikumak Yaw ne e? Sew kyaki nekre kunonor e ti Hulasokwe Seike, desikeo lema mkyumak Yaw. ");
INSERT INTO slu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Keskyede ktela madi ti ma Yaw nekre mumu ne musti mo kdi ti kolnye, ma ktyoha nam a iry manety Hulasokwe wasi nyanoare rakesy ti Kitab Lanke ne.” Kyoat desike Yesuske wasi matoha Iare ra-la mumu toha wen desy, ode rtutuk I ti desy bo. ");
INSERT INTO slu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lemade iry ribun desikre rkumak Yesuske ma rhait I bai Kayafas wasi sekye. Kayafas neke iry mabaa klen lan lahuk a i. Ti desike iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare mumu, ror iry mahe snurat o tnyetak Musake, rtabal iry manety lulw ti Yahudi-nare, neke raktemtem a rawahuk sir ti desy. ");
INSERT INTO slu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ode Petrus a tyoha dakun, keskyede sososo a i ti Yesuske bo. Ode kyoat ranait sey desy bonyo, Petrus a syukar bai sey desike wasi kintalke, ma ti tyaklulw yor suldatare ti desy, ma yobak ma hye o, nam sai ne ana kidi ti Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lemadendye ti sekye krala desy, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror Iry Lan Maohut Tun desikre mumu ne, neke robak iry salik ma bisa ma iry salik desikre rakakmet ma roit salke ti Yesuske. Mamode Iry Lan Maohut Tun desikre musti mo rtunik tnyetak matmyatkye ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Keskyede biar ma ratot irire ribun ma rou ma rakakmet ma roit salke ti Yesuske, keskye tun iry desikre ratanukare lema bisa ma kyala kyal ma rtunik tnyetak matmyatkye ti Yesuske. Dendye kalyauke bonyo, irkye enaru rlakut ei lulkwe, ode rtanuk ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Aramy mtyomolu iry ne ma tyanuk de! Ma tyanuk de byohe, bisa ma iskyui-iskyay Hulasokwe Seike, ode sekwe enatelw bonyo ana syadiri harharkwe de.” ");
INSERT INTO slu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Lemade iry mabaa klen lan lahukke imdiry, ode tyanuk ti Yesuske ma byohe, “De lema mhwalas tun a iry nekre ratanuk ma raoit salke ti O ne e?” ");
INSERT INTO slu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Keskyede Yesuske mamwaw I bo. Dendye iry mabaa klen lan lahuk desike yena I huruk ma byohe, “Hulasow a mamorif ne tyomolu nam mutanukke de. Dendye mlwosu mlakye ma aramy ohe, Oi neke Mesias a iry a Hulasokwe isusu ma muka Raja ode muaorif irkye ne e? Ode Hulasokwe Anan O e?” ");
INSERT INTO slu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Desike bonyo Yesuske hyalas ma byohe, “Mmwesan a mtwanuk bony de! Klala mtyomolu ma ktwanuk ti e. Ti sew ana mama ne, ana myatos Irkye Ananke ma tyaklulw ti Hulasow Mahareta Lan Lahukke seri wanke. Ode kyoat a yorw yosy laitke, desikeo imin ti oanke kralake.” ");
INSERT INTO slu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kyoat iry mabaa klen lan lahuk desike itomolu ma Yesuske itanuk koldyesy bonyo, kyeyer a ksyalik ma myesan yahy a wasi rabitke ti tenanke, ode tyanuk ma byohe, “Takita esei ma tyanuk huruk de? Ei ne mumu ne mtyomolu wan ne ma ihmwai Hulasokwe o de? ");
INSERT INTO slu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dendye mryekan kolkya?” Lemade iry desikre rhalas ma rbohe, “I neke musti mo rtunik tnyetak matmyatkye ti I.” ");
INSERT INTO slu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lemadendye iry desikre rasburik ti Yesuske matake kralake, ode roban a I. Maktei o rhul eta matake, ode rkohw matake, ");
INSERT INTO slu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ode rakanak I ma rbohe, “Hei! Kolnye Oi ne Mesias O, desikemo mlwosu ma aramy ohe, esei ne ioban a O ne de?” ");
INSERT INTO slu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kyoat desyo Petrus imin ti iry a mabaa klen lan lahuk desike wasi kintalke a nggora. Desike bonyo iry mabaa klen lan lahuk desike wasi makarya wamfwetke it a mya ma yait Petrus, ma tyanuk ti i ma byohe, “Oi ne kyalamo mor Yesus iry a Galilea desy dakun o de?” ");
INSERT INTO slu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Keskyede ti ribunke khaha desy, Petrus a ibu a ituli ma byohe, “Eno! Lema khwe nam mutanukke kbuanke.” ");
INSERT INTO slu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lemade kyoat Petrus ilakut bai holholat lorkye kmatake bonyo, wamfwet makarya salikke it huruk ma yatos a Petrus, dendye tyanuk ti iry mamin ti desikre ma byohe, “Iry neke kyalamo yor Yesus iry a Nazaret desy.” ");
INSERT INTO slu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Desikeo Petrus a ihwab, ode tyuly huruk ma byohe, “Lema khwe iry desy.” ");
INSERT INTO slu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ode lema soso bonyo, iry mamin ti desikre it a mya ma tyanuk ti Petrus ma byohe, “Mlay! Iry neke i ne inor Yesuske dakun ne, kali wait telke mais.” ");
INSERT INTO slu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Keskyede Petrus ihwab a myaty o myorif ma byohe, “Lema khwe iry desy.” Kyoat Petrus itanuk ma ktei bonyo, sihkye kyokoak dakun. ");
INSERT INTO slu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lemadendye Petrus a nyenas yal mait ity Ebut Yesuske tun itanuk ti ike, ti kibohe, “Sihkye lenla kyokoak, desikeo mubu a mutuly Yaw a kdi a kla-telw de.” Lemade Petrus a byetik toha wen desy, ode bya ti syer ma kisalsal. ");
INSERT INTO slu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kyoat desike bolbolbol a nggora bonyo, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manety lulw ti Yahudi-nare, rawahuk sir, ode rohut ma rbuma rtunik tnyetak matmyatkye ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dendye iry desikre raso irire ma rba ti rsik ranteke ti Yesuske simanare, ode ror I ba ti gubernur a propinsi Yudeake, neke yosy a Romawi, ma ani Pontius Pilatus. ");
INSERT INTO slu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kyoat a Yudas maketa Yesuske ne, iatos ma ratunik a tnyetak matmyatkye ti Yesuske bonyo, isesal a i ti wasi ktela ialake. Lemadendye kuban blyawan bokbok hean-telw a iketa Yesuske ma ranal ti i desy, neke yety de yolik ba ti iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ");
INSERT INTO slu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ode tyanuk ti sir ma byohe, “Yaw neke wasikw lim o sal lan ti Hulasokwe, kali kal iry a lema maaka sala ne ba ti iry a rabuma ratabahunw a I ne.” Keskyede iry desikre rhalas Yudas ma rbohe, “Aramy myosy kabei ma aramy mhye ti kyait desy de? Salamkwe desy bony ande!” ");
INSERT INTO slu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lemadendye Yudas yotuk lakhidik kuban blyawan bokbok desikre bai Hulasokwe Seike kralake, ode byetik toha desy, ma bya ti syury a taskye ti telake, ma itol-itol ti desy nini myaty. ");
INSERT INTO slu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Keskyede iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare rily rahuk kuban blyawan bokbok desikre, ode rtanuk ma rbohe, “Kuban nekre kuban larke desy, kali ral ma rselw a irkye de, ma tyabahunw iry salik. Dendye ktyoha ity wait tnyetak kubkubakke mo, lema bisa ma tluk kuban nekre ei wen a raluk natzar tike.” ");
INSERT INTO slu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dendye iry desikre rawahuk sir ma rtanuk maiske, ode rohut ma ral kuban desikre, ma ral ma rliw a lasmyerke tebikan, toha iry maala khye ur akye ne, neke wasi lasmyerke. Ma lasmyer desike rtutuk ma kolnye mwakunare rmaty, desikemo rba ti ramlin a sir ti. ");
INSERT INTO slu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dendye kyala kyosy a sew desike ma ti kyait senwe, lasmyer desike rhaly kanike o Lasmyer Larke. ");
INSERT INTO slu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ktela nekre kdi ti koldyesy, ma ktyoha Yeremia iry manety Hulasokwe wasi nyanoke nam ikeskye, ma kbyohe, “Iry manety lulw ti Israel desikre ral kuban blyawan bokbok hean-telw desy, neke karyarike ktyoha manety lulw desikre raohutke, neke irkye sasam hesi ratunikke desy. ");
INSERT INTO slu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ode ral kuban desike ma rliw lasmyerke toha iry maala khye ur akye ne, neke wasi lasmyerke, ma kola ne ity Ebutke iaso yaw ma kukesy ne.” ");
INSERT INTO slu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dendye Yesuske imdiry ma syara gubernur Pilatus. Lemade Pilatus yena Yesuske de byohe, “Oi ne iry Yahudi-nare wait raja O e?” Dendye Yesuske hyalas ma byohe, “O a mmwesan a mtwanuk koldyesy bo.” ");
INSERT INTO slu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Keskyede iry manety lulw ti Yahudi-nare ror iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, rtanuk tun ribun lan ne ma roit sal ti Yesuske, keskyede Yesuske lema hyalas tun desikre sasam dakun. ");
INSERT INTO slu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lemadendye Pilatus tyanuk ti Yesuske huruk ma byohe, “Hei! Iry nekre roit sal ribun lan ne ti O, ode kyanmwane lema muhalas sir ne de?” ");
INSERT INTO slu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Keskyede Yesuske lema hyalas tunke it dakun, ma khyury ma gubernur desike hyeran a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ode kyalamo kyait sew lan Paskahke, desikeo gubernur Pilatus wasi ktelake de, ma tyunik irkye it toha iry a raluk sir ei sey metmetke kralake ne. Keskyede iry a Pilatus itunik i toha sey metmetke kralake ne, neke ktyoha iry a Yahudi-nare ratenke bo. ");
INSERT INTO slu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ode kyoat desike dakun o irkye it ma irire mumu ne rhe ohe i neke ihatw ksyalik, ma rluk a i ti sey metmetke kralake dakun, neke ani Yesus Barabas. ");
INSERT INTO slu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ode kyoat desy dakun o, iry ribunke rawahuk sir ti Pilatus wasi sekye lulkwe, lemade Pilatus yena sir ma byohe, “Myou ma ktwunik esei ti e de, Yesus Barabaske ta, Yesus a rabohe Mesias I ne de?” ");
INSERT INTO slu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gubernur Pilatus ne yena sir koldyesy kali hye ohe, iry manety lulw ti Yahudi-nare wait kubkubakke neke rsoi ralat Yesuske, mane ranal I ti Pilatus ma iukun a I ne. ");
INSERT INTO slu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kyoat malmata Pilatus tyaklulw ti wasi kader a itaklulw ma iukun tunke bonyo, sawa-na yaso irkye it ma bya ti tyanuk ti Pilatus ma byohe, “Kete muhor tun a iry mlay desy. Kali detke kmwey I, desikeo memyeikw desike kyala yaw ma kumtaut a ksyalik.” ");
INSERT INTO slu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Keskyede iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, rsuy malkyakaw a iry ribun desikre, ma iry ribun desikre ralkyau sir ma raten toha Pilatus, ma tyunik Barabas toha sey metmetke ti sir, ode tyunik a tnyetak matmyatkye ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Keskyede gubernur Pilatus tyanuk ti iry desikre ma byohe, “Ti iry deru neke myou ma ktwunik kabei ti e de?” Desikeo iry desikre mumu ne rhalas ma rbohe, “Barabas.” ");
INSERT INTO slu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dendye Pilatus tyanuk ti sir huruk ma byohe, “Koldyesikemo, musti mo kala sai ti Yesus a rabohe Mesias I ne de?” Desikeo iry desikre mumu ne rboran ma rbohe, “I desike musti mo rbakw a I ti tul masanwalw ike!” ");
INSERT INTO slu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lemade Pilatus tyanuk ti iry ribun desikre ma byohe, “Keskye iry neke yala sal sai de?” Keskyede iry desikre rboran de rboran ma rbohe, “I desike musti mo rbakw a I ti tul masanwalw ike!” ");
INSERT INTO slu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lemade Pilatus hye ohe wasi rekryeky iala ma iobak a ksala ma itunik Yesuske toha matmyatkye ne, neke lema bisa ma kdi ti, de hye ohe rekryeky desike khyury ma ana kyal nini iry ribun desikre rsorw a i. Dendye yal werke ma yut simanare ti iry ribun desikre wait lulululw ne ma ratos, maktei o tyanuk ti sir ma byohe, “Lema kusal ti iry ne ti ana imaty ne, de ei ne myesan wasimy harharke desy bo!” ");
INSERT INTO slu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lemade iry ribun desikre rboran ma rbohe, “Biar ma iry ne larake kolnye kyobak kwena, desikeo aramy myor ara ebnwo anamy nekre, aramy mmyesan a mhyar bo!” ");
INSERT INTO slu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lemadendye Pilatus tyunik Barabas ti iry desikre, ode yaso wasi suldatare ma roban de rtaba Yesuske, maktei o ror I ba ti rbakw a I ti tul masanwalw ike. ");
INSERT INTO slu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lemade gubernur Pilatus wasi suldatare ror Yesuske ma rbetik toha wen raukun tun tike, ma rbai wen a suldatare rawahuk sir tike, ode rabuk suldat Romawi desikre mumu, ma rma ma rkoal eta Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ode ronuk wasi rabitke toha I, maktei o ral rabit narnarw a kmata molmol ebuske ma ral ma rhonak a I. ");
INSERT INTO slu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ode ranak karkyary a mahaw ne ma kola snyamurke, ode ronuk ti Yesuske usuke khatuke, ma ral ma rahmway I. Maktei o ral temarke klauke ti kyumak ti sima wanke, ma kyeluk tektekan. Ode rala rhury ma rsakitil ode rou ti wasi lulululw ne, ode rtanuk ma rbohe, “Raja iry Yahudi O, aramy myalan O!” ");
INSERT INTO slu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ode rasburik a I, ode ral temar desy toha I ode raeluk-raeluk sir ma roban usuke khatuke. ");
INSERT INTO slu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ode kyoat rahmway I ma ktei bonyo, ronuk rabit narnarw a kmata molmol ebus desy toha I. Ode ral wasi rabitke ma ral ma rhonak I huruk. Maktei o ror i bai mloskye ti rbakw a I ti tul masanwalw ike. ");
INSERT INTO slu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kyoat suldat desikre ror Yesuske ma rbetik toha nus desy, ma rbai wen ana rabakw a Yesuske tike, desikeo ti salke kditlalan ne ranal a ror irkye it ma ani Simon, iry a Kirene-ke. Lemade suldat desikre rpaksa i ma hyar a Yesuske wasi tul masanwalw i desy. ");
INSERT INTO slu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ode rba ti ranait a wenke it ma kani Golgota, neke kbuanke o, Wen Uskwe Keburake kimin tike. ");
INSERT INTO slu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ode ral nam mew maola healare eut nekre, ma rahora kyor tasy maiskye kwen makitkye, ode ral ti Yesuske ma yenw, keskyede kyoat a hye wer desy bonyo, ibrai yenw. ");
INSERT INTO slu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Maktei o suldat desikre rbakw a Yesuske ti tul masanwalw ike. Maktei bonyo ral wasi rabitke ode rhuty aluri ti ma rhe o, ana esei ne inosy simbol o rabit nekre. ");
INSERT INTO slu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maktei o rtaklulw ti desy ma rajaga Yesuske. ");
INSERT INTO slu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ode rkesy ti mbanke klaike it ma rbakw ti tul masanwalw i desy wasi srake, ma kinununu Yesuske usuke khatuke, neke rkesy kolnye: Yesus neke raja iry Yahudi-nare. Tunke khatu rakesy neke, ksyusu sal raoit ti Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ode kyoat a rbakw Yesuske, desikeo rbakw iry mahatkwe enaru dakun, ma it a imin ti Yesuske seri wisalke, ode it a imin ti Yesuske seri wanke. ");
INSERT INTO slu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ode iry malakut manosy wen desike dakun o rahmwai Yesuske, ode rayayak usut daku I, ma rtanuk de rbohe, ");
INSERT INTO slu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Hei, Oi ne mutanuk ma mubohe, ana muskyui-muskyay Hulasokwe Seike, ode sekwe enatelw o mswadiri huruk. Koldyesikemo maorif tenamkwe a nde. Ode kolnye Hulasokwe Anan a O, desikemo morw toha tul masanwalw i desy!” ");
INSERT INTO slu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ode iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, rtabal iry a mahe snurat o tnyetak Musake, rahmwai I dakun ma it de tyanuk ti it ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ohe, I neke yala tenanke kola dene bisa ma yaorif iry salik, keskyede myatos, tenanke kmyesan o lema bisa ma yaorif! Ohe, I neke Israel-are wait Raja I, koldyesikemo musti mo yorw toha tul masanwalw i desy, mamode nenmo tou ma ttohak ti I. ");
INSERT INTO slu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kali ohe I neke tyohak ti Hulasokwe, ode tyanuk ma byohe, Hulasokwe Anan a I, dendye tseak o Hulasokwe mya ma yaorif a I ta lema.” ");
INSERT INTO slu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma ti kyal iry deru mahatw a rabakw a sir ti tul masanwalw i desikre, rakanak I dakun. ");
INSERT INTO slu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kyoat desike sekwe dyutw mais-mais, desikeo kyala mait bonyo, kelerkok ti nuske ktem desy mumu, nini kyal jamke enatelw. ");
INSERT INTO slu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ode kyoban enatelkwe ti sekwe iba ne bonyo, Yesuske yatela ma byohe, “Eli, Eli, lama sabakhtani?” Neke kbuanke o, “O Hulasow O, Hulasow O, kyanmwane mututuk Yaw kolnye ne de?” ");
INSERT INTO slu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kyoat iry ribun mamdiry ti wen desike ratomolu nam Yesuske itanuk desy, desike bonyo, rtomolu sal ma rbohe, “Mtyomolu ma yabuk Elia, iry a heitlulswo manety Hulasokwe wasi nyano desy.” ");
INSERT INTO slu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lemadendye irkye it a ila bya ti yal temarke, ode yutuk ti aurke khunake, maktei o hyuhuk aurke khuna desy ti tasy maiskye kwen makitkye, ode yala ma yal ti Yesuske nunuke ma byusak. ");
INSERT INTO slu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Keskyede iry salik a rbu eta iry desy ma rbohe, “Kete mal ti yenw, mamode tseak o, Elia Hulasokwe wasi manety nyanoke ana mya ma yaorif I ta lema.” ");
INSERT INTO slu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ode kyoat desike Yesuske yatela huruk, ma kitei bonyo myaty. ");
INSERT INTO slu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kyoat desike kain mal de mal a ratola ma kieteta wen nelnyely mamin ti Hulasokwe Seike kralake, kele rahy ti kbya enaru, neke kyala kyosy srake ma ti kyait hahke. Ode lurwakye lan, ma hatw mamin a kususwanare kele rsin dakun. ");
INSERT INTO slu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ode mamatire wait asanare kimlakat, ma iry matohak ti Hulasokwe ma ramaty neke ribun a rmorif huruk. ");
INSERT INTO slu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ode kyoat Yesuske imorif huruk desy bonyo, iry matohak ti Hulasokwe ma ramaty neke, rbetik toha wait asanare, ma rsukar ei Yerusalem nus nelnyely desy, ma rsusu tenatare ti iry ribunke. ");
INSERT INTO slu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kyoat suldatare wait uskwe khatuke yor wasi suldat majaga Yesuske ne, raseak a lurwakye ktyabal ktela madi ti desy bonyo, ramtaut ma ksyeman a sir, lemade rtanuk ma rbohe, “Mlay bain! Iry neke Hulasokwe Anan a I!” ");
INSERT INTO slu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ode ti desike dakun o, wamfwetare dum a ramdiry ma sososo a sir, ma ratos ktela madi ti desy. Wamfwet desikre sir ne rlakut a rtoha Yesuske, ma rsaluk I ti sai ta sai bo, neke rtoha I a rala rosy a propinsi Galileake ma ti rait wen desy. ");
INSERT INTO slu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ti wamfwet desikre mumu ne, neke wamfwetke enatelw sir dakun, neke: Maria Magdalena, ode Maria Yakobus yor Yusuf neke enatke, rtabal a Zebedeus sawa, neke Yakobus yor Yohanes enatke. ");
INSERT INTO slu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kyoat sekwe yala ma dyi, desikeo irkye it ma wasi malolkye lan, neke yosy a nus Arimateake ti propinsi Yudeake, i neke ani Yusuf ma Yesuske wasi matoha Ike it ne dakun. ");
INSERT INTO slu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yusuf neke bya ti yait gubernur Pilatus, ma iten Yesuske tbunanke ma ti yamlin. Lemade Pilatus yal haretke ma ral Yesuske tbunanke ti Yusuf. ");
INSERT INTO slu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dendye Yusuf yulak i ba ti nyauk Yesuske tbunanke toha tul masanwalw ike, maktei o yal kain lenan bokbok malilikwe ma yal ma hyul a Yesuske tbunan desy. ");
INSERT INTO slu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Maktei bonyo bya ti yamlin Yesuske tbunan desy ti bobke kuranke, ode lyilik hatw lan ne ti kyeteta bobke kuran desy, maktei o bya. Bobke kuran neke heit a irire rhak hatkwe ksouke ma kuran. Ode bobke kuran desy, Yusuf wasi, ma knani a nggora, ma lenla ral irkye it a tbunanke ti dakun. ");
INSERT INTO slu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ode Maria Magdalena, yor Maria idanare ramin desy dakun, ma rtaklulw ti bobke wasi lulw desy. ");
INSERT INTO slu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ode bolbol ne ti sew a Inamreske bonyo, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manosy lui Farisi-nare raktemtem ne rba ti rait Pilatus, ");
INSERT INTO slu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ode rtanuk ti i ma rbohe, “Amam lan o, aramy mnyenas a iry a makakmet desy ti kyoat a imorifke, desikeo tyanuk ma byohe, ‘Ana sekwe enatelw kyelak eta bonyo myorif huruk.’ ");
INSERT INTO slu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lemadendye aramy mmya ma miten toha o, ma mal haretke ti wasimw suldatare, ma ti rajaga iry makakmet desy wasi asa desy nini kyait sew a enatelkwe. Kali kolnye lema rajaga, desikeo ana wasi matoha Iare rma ma ranamet a tbunanke, ode rtanuk ti iry ribunke ohe, Yesuske myorif huruk toha mamatire de, ma ana khyury ma wasi kakmet manosy lyaw desike ana ksunw ma kbyilak wasi kakmet mamuna ibohe, I neke Mesias a I ne.” ");
INSERT INTO slu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dendye Pilatus tyanuk ti usu khatu desikre ma byohe, “Wasikw suldat majagare sir ne, lemade myor sir ma mbya, ode mijaga asa desy mamamak.” ");
INSERT INTO slu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lemadendye iry desikre ror suldat majak desikre ma rba, ode rlatan metraike ti hatw ranal ma rakahat eta bobke kuran desy, ma kete irire rlakat, maktei o ramin ti desy ma rajaga. ");
INSERT INTO slu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kyoat sew Inamreske kisakut, ma sew mingguke wasi bolbolbol ne bonyo, Maria Magdalena yor wamfwetke it ma ani Maria dakun, neke rbai bobke kuran a ramlin Yesuske tbunanke tike. ");
INSERT INTO slu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ode kyoat ranait bobke kuran desy bonyo, kyala mait ne lurwakye lan a ksyalik, kali Hulasokwe wasi nyaso manosy laitke it a yorw yosy wen sra eraske, ma mya ma lyilik hatw a ranal ma raeteta bobke kuran a ramlin Yesuske tbunanke ti desy ei kserike, maktei o tyaklulw ti khahake. ");
INSERT INTO slu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nyaso manosy lait desike uno mata ne knyely malay kola ne hitikke ne, ode wasi rabitke bokbokbok ma kola kahaske ne. ");
INSERT INTO slu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ode suldat majak ti bobke kuran ramlin Yesuske ti desy, ramtaut a ksyalik ma ramlulurw, ma rlily ti wenatare ma rmaty muly elik. ");
INSERT INTO slu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lemade Hulasokwe wasi nyaso manosy lait desike tyanuk ti wamfwet deru desy ma byohe, “Kete mimtaut, kali khwe ohe ei ne miobak Yesus a rabakw a I ti tul masanwalw ike ne. ");
INSERT INTO slu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Keskye lema imin ti ne de, kali myorif huruk de, ma kola tun itanukke. Mmya ma msyukar ma myatos wen ramlin I tike. ");
INSERT INTO slu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ode mbya! Keskye mnyenas tun kutanuk ti e ne, ma ti mtyanuk ti wasi matoha Iare ma mbyohe, ‘Yesuske myorif huruk de! Ode myuna e bai Galilea de. Ode ti soke ana myatos a I.’” ");
INSERT INTO slu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lemade wamfwet desikre rulak sir toha bobke kuran desy bonyo ramtaut, keskye ralatare kimukmuka i a ksyalik. Ode rlahlaha mirin ma adoko rba ti rait Yesuske wasi matoha Iare, ma rahes ktela ribun ramatakit ode rahe desikre ti sir. ");
INSERT INTO slu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Keskyede malmata rlakut ba, desikeo kyala mait bonyo, ranal a ror Yesuske ti salke kralake, dendye Yesuske tyanuk ti sir ma byohe, “Eraske kimin a e.” Lemade wamfwet deru desy ti rney a Yesuske, ode rkora lwaunare, ode rsakitil ma rou ti I. ");
INSERT INTO slu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lemadendye Yesuske tyanuk ti sir ma byohe, “Kete mimtaut. De mbya, ode mlyosu ti waikure ma rbai Galilea, kali ti soke ana ratos Yaw.” ");
INSERT INTO slu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kyoat wamfwet deru desy rulak sir ma raba bonyo, suldat majaga bobke kuran a ramlin Yesuske tbunanke ti desy, neke dum a rba ti rlosu ktela madi ti desy, ti iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare. ");
INSERT INTO slu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lemadendye usu khatu mabaa klen desikre, rba ti rawahuk sir a ror iry manety lulw ti Yahudi-nare, ma rtanuk maiske ma ana ral kuban ti suldat majaga bobke kuran a ramlin Yesuske tbunanke ti desy. ");
INSERT INTO slu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ode rtanuk ti suldat desikre ma rbohe, “Musti mo mikakmet ma mtyanuk ti irire ma mbyohe, ‘Kyoat metdyet a kditlan ma aramy myenaf bonyo, Yesuske wasi matoha Iare rma ma ranamet Yesuske tbunanke toha bobke kuran a ramlin I ti desy.’” ");
INSERT INTO slu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Maktei o rtanuk huruk ti suldat majaga bobke kuran desikre ma rbohe, “Ana kolnye gubernur Pilatus tyomolu kena brit ne, desikeo ana aramy myory eta e, ma kete kyal nini Pilatus yukun a e.” ");
INSERT INTO slu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Lemadendye suldat majak desikre ral kuban desikre, ode rala ma ktyoha iry manety lulw ti iry Yahudi desikre nam ratanuk ti sirke. Dendye ktela kakmet suldat desikre rahes desike khyury ma irire rahes a rsaur ma kimelir ti iry Yahudi-nare, nini ti kyait senwe. ");
INSERT INTO slu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lemade Yesuske wasi matoha I dehean a kresi sasam desikre rbai propinsi Galileake, ma ti rait kususwanke it ti Galilea desy, ma ktyoha tun Yesuske itanuk ti sirke. ");
INSERT INTO slu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ode kyoat ratos Yesuske ti desy bonyo, rsakitil ode rou ti Yesuske, keskyede ti sir neke dum a lenla rtohak mamak o Yesuske I ne. ");
INSERT INTO slu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lemadendye Yesuske bya ti nyey a sir, ode tyanuk ti sir ma byohe, “Haret mamin ti wen sra eras so, ode mamin ti lasmyerke khaha ne mumu, Amaku yal ma Yaw de. ");
INSERT INTO slu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lemadendye mbyai nuske ktem ne mumu, ode myabrita Brit Eraske ti sir, ma rtohak ma Yaw ma wasikw iry a sir. Ode mbyabtis sir a kyor Amaku Anike, Anikkwe, ode Amaku Memeanke kanike dakun. ");
INSERT INTO slu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ode myajar sir ma rtoha nam kutanuk ti eare mumu. Ode mnyenas! Ana kunonor e nini nuske ktem ne klyodur.”");
INSERT INTO slu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Waikw o hatnimakw e, Brit Eras mamunake ne, neke kihes a Yesus Kristus Hulasokwe Anan ne. ");
INSERT INTO slu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Brit Eras neke heitlulswo Hulasokwe wasi manety nyano Yesaya neke kyesy ti wasi kitabke ohe, Hulasokwe byohe: “Myatos, kaso wasikw nyasoke ma myuna O, ma bya ti syoli salke ma kikita O; ");
INSERT INTO slu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ode yatela ti wen malosy-loskye de byohe, ‘Msyoli salke ode myaklol ma mlol, ma kikita ity Ebutke.’” ");
INSERT INTO slu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lemadendye kmya ma nenmo taras neke, iry a Hulasokwe iaso desy, neke ani Yohanes. Dendye Yohanes byai wen malosy-loskye, ode yatela ma byohe, “Mtyunik totamy atyat manety lim o sal desikre ba, ode mmya ma rbabtis e, ma Hulasokwe syos salamire ba.” ");
INSERT INTO slu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dendye iry mamin ti propinsi Yudeake ktem desy mumu, ode iry mamin ti nus Yerusalemke ktem desy mumu dakun ne, rba ti rlosu wait lim o sal, ma Yohanes byabtis sir ti sah Yordanke. ");
INSERT INTO slu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes neke hyonak rabit narnarw ratenkwe, neke ral toha untake husike, ode wasi kosarke kyosy a heal a iblutare, ode kotw inanare neke larihke ktyabal maduke. ");
INSERT INTO slu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Maktei o Yohanes tyanuk huruk ma byohe, “Iry a ana mama neke lan lahuk I ma byilak yaw, ma yaw ne lema kbwer o ktwahal ma kaka wasi dori-na ktasinare dakun. ");
INSERT INTO slu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ode yaw neke kbwabtis e a kyor werke ma kyabetar iblumire bo, klala Iry ana mama neke ana byabtis e a kyor Hulasokwe Memeanke!” ");
INSERT INTO slu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kyoat Yohanes byabtis irire, desikeo Yesuske yosy a hnu Nazaretke o propinsi Galileake, ma mya ma Yohanes byabtis I ma hyuhuk I ti sah Yordanke. ");
INSERT INTO slu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ode kyoat Yesuske byitil I, desikeo yatos elik ma laitke kimlakat, ode Hulasokwe Memeanke kyorw ti I, neke kola ne manu hahkye inem ma ituny a I ne. ");
INSERT INTO slu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ode Hulasokwe telake kbyetik kyosy laitke ma kbyohe, “Oi neke Anakw a O, ma klwobak a O, ode kou O ti ralakkwe.” ");
INSERT INTO slu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kyoat Yesuske rbabtis I maktei bonyo, Hulasokwe Memeanke kyeuk I elik bai wen malosy-loskye. ");
INSERT INTO slu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ode kyoat ti wen malosy-losy desy, Yesuske yor heal mahatw nekre ti desy, ode ngkeskwaure wait uskwe khatuke hyury a I nini sekwe hean-at. Keskye Hulasokwe wasi nyasoare rosy laitke ma rma ma rsaluk I. ");
INSERT INTO slu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kyoat Yohanes rkumak i, ma rluk i ei sey metmetke kralake, desikeo Yesuske byai propinsi Galileake, ti yabrita Brit Eras manosy Hulasokwe ti so, ");
INSERT INTO slu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ma byohe, “Sew a Hulasokwe mya ma hyareta kola Rajake ne kyarasy de. Lemade mtyunik totamy atyat manety lim o sal desikre ba, ode mtyohak Brit Eras manosy Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ode Yesuske lyakut ti Tasi Kakan Galileake kserike, desikeo yatos Simon yor wai Andreas, ma malmata rtunik wait darkye ti tasi kakan desy, kali sir neke iry maka tasi sir. ");
INSERT INTO slu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lemade Yesuske tyanuk ti sir ma byohe, “Mmya ma mtyoha Yaw. Kali ana kajar e ma mlyuy dary ti irkye.” ");
INSERT INTO slu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lemadendye rtutuk elik wait darire, ode rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Maktei o Yesuske syaur wasi laklakutke tebikan ei lulkwe huruk, desikeo yatos Yakobus yor wai Yohanes, neke Zebedeus ananare, ma malmata rtoy wait dary mamahire ti aroke kralake. ");
INSERT INTO slu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lemade Yesuske yabuk elik sir, desikeo deruke rorw toha aroke ma rtoha Yesuske, ode rtutuk amatke yor wasi makaryaare ti desy. ");
INSERT INTO slu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lemade Yesuske yor wasi matoha Iare rbai hnu Kapernaumke. Ode kyoat ti sew Inamreske bonyo, byai Yahudi-nare sey rasambayan tike, ma yajar ti. ");
INSERT INTO slu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kyoat iry desikre ratomolu nam iajarare bonyo rheran, kali tun itanukare kyety mdedan, ode lema kola iry mahe snurat o tnyetak Musake nam raajarare. ");
INSERT INTO slu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ode ti sey rasambayan tike krala desy, irkye it ma ngkeskwakwe syukar i soso de, neke byoran mait ma byohe, ");
INSERT INTO slu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hei! Yesus iry a Nazaret O, mrweky sai ma aramy ne de? Mmwa ma mkwordalam aramy mane e? Yaw ne khwe o esei O. Oi neke Iry Nelnyely manosy a Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dendye Yesuske yaswel i, ode tyanuk ti i de byohe, “Mamwaw o! Ode mbwetik toha iry ne!” ");
INSERT INTO slu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lemade ngkeskwaw desike byoran ma telake lan, ode byesak a iry desy daku ribun lan desy. Maktei o byetik toha iry desy. ");
INSERT INTO slu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dendye iry ribun mamin desikre mumu ne rheran, ode it de tyanuk ti it ma rbohe, “Wah, iry ne tunanare kyety mdedan a ksyalik. Kali bisa ma yesak ngkeskwakwe, desyo byetik elik.” ");
INSERT INTO slu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lemade Yesuske abritake kimelir mait ti hnu kabei ta kabei ti propinsi Galileake. ");
INSERT INTO slu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Kyoat Yesuske yor wasi matoha Iare rbetik toha Yahudi-nare sey rasambayan tike, desikeo Yakobus, ode Yohanes ror sir dakun, ma rbai Simon yor Andreas wait sekye. Ma nenmo ranait bonyo, iry mamin ti desike dum a rlosu ti Yesuske yor wasi matoha I desikre ma rbohe, “Simon ryana wamfwetke kluruk i, kali kbai mrinke kyala i.” ");
INSERT INTO slu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lemadendye Yesuske bya ti imdiry ti enen desike wena ienah tike kserike, ode kyumak enen desike simake ma syabyatar i, desikeo enen desike wasi kbai mrin desy kitayar elik. Lemade enen desike byitil i, ma bya ti syalwir ti Yesuske yor iry desikre. ");
INSERT INTO slu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kyoat sekwe iba bonyo, irire ror wait iry a isy masunure, ode iry a ngkeskwaure rasukar sirare ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dendye iry ribun mamin hnu desike, rma ma rawahuk sir mumu ti Simon yor Andreas wait sekye lulkwe. ");
INSERT INTO slu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ode Yesuske nyoha iry ribunke wait kbai salno salik nekre, ode yesak ngkeskwaw ribunke dakun toha iry desikre ma rbetik, ode lema lyura ngkeskwaw desikre ma ratun, kali rhe ohe Yesus neke Hulasokwe Anan a I. ");
INSERT INTO slu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ode bolbolbol ne, ma sekwe lenla ibetik ne bonyo, Yesuske byatar ode lyakut ma byai wen kele ratelinke it, ti syambayan. ");
INSERT INTO slu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dendye Simon yor lianare rba ti raobak a I. ");
INSERT INTO slu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ode kyoat ranait I bonyo, rtanuk ti I ma rbohe, “Tuanggurw, iry ribunke robak O.” ");
INSERT INTO slu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Keskyede Yesuske hyalas sir ma byohe, “Mmya ma tbai hnu salik, neke ti nus o hnu maney nekre, ma kabrita Brit Eraske ti, kali khyali Brit Eraske mane kbwaa koli nus o hnu nekre.” ");
INSERT INTO slu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lemade Yesuske byai propinsi Galileake ktem desy mumu, ode syukar ei Yahudi-nare sey rasambayan tiare, ma yabrita Brit Eraske, ode yesak ngkeskwaure toha irire. ");
INSERT INTO slu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ode kyoat Yesuske yait a hnuke it, desikeo irkye it ma kbai mbaulke kbyenw tenanke. Ode iatos Yesuske bonyo, mya ma syakitil ti Yesuske wasi lulululw ne, ode iten toha I ma byohe, “Amo! Kolnye mou mo, kuten ma maditi kbai ne toha yaw, ma tenakw ne nelnyely!” ");
INSERT INTO slu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Lemade Yesuske lyobak iry desy, dendye yeta simake ti kyumak iry desy, ode tyanuk ti i ma byohe, “Kou ma tenamkwe nelnyely.” ");
INSERT INTO slu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ode kyala mait bonyo, iry desike wasi kbai mbaul desy kitayar, ma tenanke nelnyely. ");
INSERT INTO slu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dendye Yesuske tyerik malkyakaw iry desike ma kete ihes ktela madi ti i desike ti irkye it elik. Maktei o yaso i ma adoko bya. ");
INSERT INTO slu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ode tyanuk ti i de byohe, “Musti mo mtwoha haret Musake, ma adoko mbwa mirin ti mswusu tenamkwe ti iry mabaa klen ti irkye yor Hulasokwe, ma mety heal ana raabar ti Hulasokwe desy, ma mal ti sir, ma rhe bain-bain o eras a o de.” ");
INSERT INTO slu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Keskyede iry desike lema hyaduli elik, de bya ti ihes a ktela madi ti i desike ti kabei ta kabei bo, ma khyury ma Yesuske lema bisa ma syukar ei nus o hnu nekre de. De imin ti wen kele ratelin nekre bo, keskye irire rosy kabei ta kabei ma rma ma robak I bo. ");
INSERT INTO slu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lemadendye sekwe enai ne kyelak eta bonyo, Yesuske yulak I bai Kapernaum, ma irire rabrita ohe Yesuske I so imin ti sekye it. ");
INSERT INTO slu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lemade iry ribunke lui-lui sir ma rma ma rbenw a sey desy kralake, ma ti kyal a mloskye dakun. Ma moluk a rtomolu Yesuske ma yabrita Hulasokwe tunanare ti sir. ");
INSERT INTO slu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ode malmata Yesuske yabrita Hulasokwe tunanare, desikeo irkye enaat a rhar a mbelukke, desyo iry mablukutke imin ti khahake, ma ror i ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Keskyede iry desikre lema rtutu ral ei sekye kralake, kali irire ribun sir ti desy. Lemadendye rsai ei sekye srake, ti raskyaik tnyarukke tebikan, ma rtolar mbeluk desy ei hahke daku iry ribun desikre, desikeo kyal mamamak Yesuske wasi lulululw ne. ");
INSERT INTO slu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kyoat Yesuske yatos iry mablukut desy, tyabal iry manauk mbeluk desikre wait tohtohakke bonyo, byu ti iry mablukut desy de byohe, “Wai,wasimw a lim o sal desikre kswos ba de.” ");
INSERT INTO slu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Keskyede ti desike iry mahe snurat o tnyetak Musa nekre dum a rtaklulw ti desy dakun, ode rrekan ti ralat a kralanare ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kyanmwane iry ne itanuk koldyesy ne de? Esei mane ires ma ikanak a Hulasokwe ne de? Ode ryekan o bisa ma syos lim o sal nekre ba e? Taheke o Hulasokwe myesan a syos lim o sal nekre ba bo.” ");
INSERT INTO slu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Keskyede Yesuske hye iry desikre nam rarekanare, lemade tyanuk elik ti sir ma byohe, “Kyanmwane mirekan ti ralamy kralanare koldyesy ne de? ");
INSERT INTO slu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kali kolnye irkye tyanuk ti iry mablukut ne ma byohe, ‘Wasimw lim o sal nekre kswos ba de.’ Desikeo lema ksunw ma irkye tyanuk tun ne, kali lema tmatakit ma the o wasi lim o sal desikre syos ba deny ta lema. Klala kolnye irkye tyanuk ti iry mablukut ne ma byohe, ‘Mbwatar ode mal wasimw a mbelukke ode mlwakut ba.’ Desikeo ksunw ksyalik ma irkye tyanuk, kali ana tmatakit o nam itanuk desike kdi ti ta lema. ");
INSERT INTO slu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Keskyede ma mhye ohe ti nuske ktem ne Irkye Anankehyareta ma syos lim o sal nekre ba, dendye myatos!” Lemade Yesuske tyanuk ti iry mablukut desy huruk ma byohe, ");
INSERT INTO slu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mbwatar! Ode mal wasimw a mbeluk desy, ma mulak o bai wasimw sekye.” ");
INSERT INTO slu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lemade iry desike byatar elik toha wenake, ode yal wasi mbelukke ma lyakut ei mloskye, desikeo iry ribun desikre ratos. Lemade iry desikre rheran mumu, ode rleru Hulasokwe Anike, ode rtanuk ma rbohe, “Lenla aramy myatos ktela maoly ne it elik.” ");
INSERT INTO slu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kyoat Yesuske yulak I bai Tasi Kakan Galileake kserike bonyo, iry ribunke rma ma rait I ti desy, ma yajar sir. ");
INSERT INTO slu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ode kyoat Yesuske malmata lyakut bonyo, myatakit iry a maily uskwe it ma ani Lewi, neke Alfeus ananke ma malmata tyaklulw ti wen ikarya tike. Desike bonyo Yesuske byu ti i de byohe, “Mmwa ma mtwoha Yaw.” Lemadendye Lewi imdiry elik toha wen a ikarya tike, ode tyoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lemade Yesuske byai Lewi wasi sekye ti iknam, desikeo Lewi lian maily usure rtabal iry maka wait lim o sal nekre, rma dakun ma raknam a ror Yesuske yor wasi matoha Iare, kali irire ribun a rtoha I. ");
INSERT INTO slu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Keskyede kyoat iry mahe snurat o tnyetak Musa manosy lui Farisike, ratos Yesuske yor wasi matoha Iare ma malmata raknam a ror iry maily usure, ode iry a lim o sal nekre bonyo, rtanuk ti Yesuske wasi matoha Iare ma rbohe, “Kyanmwane Yesuske iknam a yor iry a maily usw o, iry a maka wait lim o sal nekre ne de?” ");
INSERT INTO slu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kyoat Yesuske itomolu ma ratanuk koldyesy bonyo, hyalas sir ma byohe, “Iry a lema klurukare lema robak dokterke, klala iry a klurukare robak dokterke. De kuma neke lema kabuk iry a marekan tenatare o mlay nekre, keskyede kuma neke kabuk iry mabihy a tenatare o raka wait lim o sal nekre.” ");
INSERT INTO slu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sekwe it bonyo Yohanes Mababtiske wasi matoha iare, ror iry manosy lui Farisi-nare, malmata ras, desike bonyo irire rma ma rtanuk ti Yesuske ma rbohe, “Kyanmwane Yohanes Mababtiske wasi matoha iare, ror iry a manosy lui Farisi-nare ras, keskyede wasimw matoha Oare lema raas ne de?” ");
INSERT INTO slu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lemade Yesuske ihliak tunke ma yal ma hyalas sir ma byohe, “Yaw ne kola wamwany masake it. Ode kyalamo rasa ma rala kalkal, ode wamwany masa desy lianare rma ma ramukmuka sir a ror i. Desikeo myaso sir ma ras e? Krwekan mo lema koldyesy. ");
INSERT INTO slu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Keskyede ana kyait sekwe, ma wamwany masa desike ral i toha lianare, desikeo kyala kyosy desike nenmo iry desikre ras.” ");
INSERT INTO slu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ode lema irkye it a kyotal rabit harharkwe tebikan ma yal ma byatak rabit a mtuke. Kali ana kyait ma rhas bonyo rabit harharw desike kimtuk ma kakan, ma kyala rabit a mtu desike ma kimahy, ode wasi mamahy desike ktyabal toha ma lan.” ");
INSERT INTO slu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Kola ne dakun ti tasy maiskye kwen minminake,neke lema eras ma rsosan ti werke kwena mtuke,kali ana koldyesy bonyo, tasy maiskye kwen minmina desike makity, ma kisuhan i ti werke kwena mtu desy, ma khyury ma werke kwena mtu desike kibserw ma atyat,ode tasy maiskye kwen desike kibo ba bo. De musti mo tasy maiskye kwen minminake ralik ti werke kwena harharkwe, ma deruke kihnyarak i.” ");
INSERT INTO slu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ode kyoat sew Inamreske it bonyo, Yesuske yor wasi matoha Iare rlakut ti bo gandumke. Ode malmata rlakut ti bo desy, desikeo wasi matoha Iare riry gandumke ratebikan ti simatare, ode rkaslyaw ma kiblunke kyaditi i, maktei o ra kisike. ");
INSERT INTO slu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Keskyede iry manosy lui Farisi-nare rtanuk ti Yesuske ma rbohe, “Matos! Kyanmwane iry nekre rabilak a ity wait tnyetak kubkubakke ma rakarya ti sew Inamreske ne de?” ");
INSERT INTO slu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lemade Yesuske hyalas sir ma byohe, “De lema mbyaca Kitab Lanke ti nam Daud iala desikre, ti kyoat inor iry a matoha iare ti ramlar desy e? ");
INSERT INTO slu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ode lema mnyenas ti kolkyabei mane Daud isukar ei Hulasokwe wasi Lasyerkye kralake ne e? Kyoat desyo Abyatar iry mabaa klen lan lahukke, malmata ijaga ti Hulasokwe wasi Lasyerkye, desyo Daud iten ma yal roty raabar ti Hulasokwe desy ma nya, ode yal ti wasi matoha iare ma ra dakun. Keskye ktyoha ity wait tohtohakke mo, nam raabar desikre, iry mabaa klen ti irkye yor Hulasokwe rmesan a ra bo. Ode kyanmwane nam Daud iala desike lema kyety lim o sal ti i ne de?” ");
INSERT INTO slu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Lemade Yesuske tyanuk ti sir huruk ma byohe, “Hulasokwe yala sew Inamreske ma ksyaluk irkye, de lema yala irkye ma ika at ti sew Inamreske. ");
INSERT INTO slu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dendye Irkye Ananke kyumak haretke ti sew Inamreske, ma yohut ti ktela irkye bisa ma ialanare ode ktela irkye lema bisa ma ialanare dakun ti sew Inamreske.” ");
INSERT INTO slu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lemade sekwe enai ne kyelak eta bonyo, Yesuske syukar ei Yahudi-nare sey rasambayan tike. Ti desike irkye it a sima wanke kmyaty. ");
INSERT INTO slu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ti desy dakun o iry manosy lui Farisi-nare robak a ksala ma rmanadu Yesuske, dendye rabalmat ti I o ana ti sew Inamreske ne, nyoha irire wait a kbainare ma eras sir ta lema. ");
INSERT INTO slu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dendye Yesuske tyanuk ti iry a sim mamaty desy ma byohe, “Mmwa ma mumdiry ti lulw san.” Lemade iry desike bya ti imdiry ti lulkwe. ");
INSERT INTO slu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Maktei o Yesuske tyanuk ti iry a mamin ti desikre de byohe, “Kena e ohe, ktyoha tnyetak ity wait kubkubakke mo, tala sai ti sew Inamreske de? Tala eraske ta, tala atyatke de? Taorif irire ta, tamatik irire de?” Keskyede iry desikre mamwaw a sir bo. ");
INSERT INTO slu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lemade Yesuske kyeyer ti iatos iry desikre mumu ne, ode ralake kitol ti iry desikre usut a khatu malkyakaw ne. Dendye tyanuk ti iry a sim mamaty desy ma byohe, “Mlwol simamkwe ma!” Iry desike ilol simake bonyo, simake eras elik! ");
INSERT INTO slu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lemade iry manosy lui Farisi desikre rbetik toha sey rasambayan tike, ma rba loran elik ti rawahuk sir a ror raja Herodes wasi irire, ma rtanuk maiske ma rreky ma rtabahunw a Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lemadendye Yesuske yor wasi matoha Iare rbai Tasi Kakan Galileake kserike, ma soso sir toha iry ribun desikre, keskyede iry ribun manosy Galilea desikre rtoha Yesuske. Ode ribun a rosy Yudea dakun, ");
INSERT INTO slu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ode dum a rosy Yerusalem, ode dum a rosy lasmyer Idumeake, ode dum a rosy kseri timur sah Yordanke, ode dum a rosy hnu mamin ti lasmyer Tiruske ode Sidonke dakun. Iry desikre mumu neke, rma ma rseak Yesuske, kali rtomolu ktela Yesuske ialanare mumu de. ");
INSERT INTO slu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lemade kyoat Yesuske iatos iry desikre ma ribun sir, desike bonyo yaso wasi matoha Iare ma rasosan aroke ti I, ma syai ma yajar iry ribun desikre, ma yajar sir mo, kete masekan ti I. ");
INSERT INTO slu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dendye Yesuske yajar sir maktei bonyo, nenmo nyoha iry a klurukare wait a kbainare, ma khyury ma iry a kluruk lenla inoha wait kbainare ne, neke it de syekan it, ma robak ma rkumak I. ");
INSERT INTO slu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Klala iry a ngkeskwaure rasukar sirare, kolnye ratos Yesuske, desike bonyo rsakitil ti Yesuske wasi lulululw ne, ode reik ma rbohe, “Oi neke Hulasokwe Anan a O!” ");
INSERT INTO slu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Keskyede Yesuske tyerik malkyakaw sir, ma kete rahes ti irire ohe, ese I ne Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lemadendye Yesuske syai bai kususwanke, ode yabuk iry a ibuma ana iilik sir ma raka nyaso ti I desy, lemade iry desikre rma ma rait a I. ");
INSERT INTO slu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dendye yilik iry a iou sir ti ralake ne, neke irkye hean a kresi enaru, ma tyanuk ti sir de byohe, “Kilik a e, ma myor Yaw ma ana kaso e ma ti myabrita Brit Eraske. ");
INSERT INTO slu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ode kal haretke ti e, ma bisa ma myesak a ngkeskwaure toha irire dakun.” ");
INSERT INTO slu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ode iry a dehean a kresi enaru Yesuske iilik desikre neke: Simon, a Yesuske iaki anike ti Petrus ne. ");
INSERT INTO slu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ode Yakobus yor wai Yohanes, neke Zebedeus anan a sir. Iry deru neke Yesuske yaki anitare ti Boanergeske, neke kbuanke o krutuke ananare. ");
INSERT INTO slu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ode Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus, neke Alfeus ananke, Tadeus, Simon (iry a lui Zelot desy), ");
INSERT INTO slu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ode Yudas Iskariotke, ma i ne ana iketa Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lemade Yesuske yulak I huruk bai sey ramin tike. Keskye iry ribunke rtoha I ma rbai sey desy dakun, ma khyury ma Yesuske yor wasi matoha Iare lema bisa ma raknam o renw elik. ");
INSERT INTO slu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kyoat desy dakun o irire dum a rtanuk ma rbohe, “Yesuske hyukat de!” Dendye kyoat Yesuske wai o hatnima nekre ratomolu tun desy bonyo, rma ma robak ma ral I ma ana ror I bai wait a hnuke. ");
INSERT INTO slu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ode iry a mahe snurat o tnyetak Musa manosy a nus Yerusalemke rtanuk ma rbohe, “Iry desike Beelzebul a syukar I! Kali yal ngkeskwaure wait uskwe khatuke amalkyauke, ma yal ma yesak ngkeskwaure.” ");
INSERT INTO slu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lemade Yesuske yabuk iry ribun desikre, ode ihliak tunke ma yal ma yena sir de byohe, “Kolkyabei ma ngkeskwaure wait uskwe khatuke, bisa ma yesak ngkeskwaure wait uskwe khatuke de? ");
INSERT INTO slu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ode kolnye ti nuske it, ma iry mamin tiare it de syorw a it ma rakahrea, ma rahe a rasakar sir, desikeo khyury ma nus desike kiskyui-kiskyay. ");
INSERT INTO slu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kola ne sekye kralake it ma kolnye it de lema yor eras it, desikeo sekye krala desike kiskyui-kiskyay dakun. ");
INSERT INTO slu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Koldyesy dakun o kolnye ngkeskwaure wait uskwe khatuke yor wasi ngkeskwaw matoha iare, it de syorw a it ma rakahrea ma rahe a rasakar sir, desikeo khyury ma wait haret desikre lema kyal nini nam, de kimres tei klen bo. ");
INSERT INTO slu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kola dene irire dum a ralkyaw sir, ma rsukar ei iry malkyakakwe it a wasi sekye ma ranamet wasi malolkye, desikemo khyehyei neke musti mo rikat iry malkyakaw desy aduk, maktei o nenmo bisa ma rsukar ei wasi sekye, ti ranamet wasi malolkye. ");
INSERT INTO slu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dendye mtyomolu ma ktwanuk ti e, kolnye esei desike yala lim o sal, ode ikanak irire, desikeo ana Hulasokwe bisa ma syos sala desy ba. ");
INSERT INTO slu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Keskyede esei desike ikanak Hulasokwe Memeanke, desikeo ana Hulasokwe lema syos sala desy ba. De iry desike hyar wasi lim o sal desike nini nam.” ");
INSERT INTO slu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuske tyanuk koldyesy kali irire dum a rtanuk ma rbohe, “Ngkeskwakwe syukar I.” ");
INSERT INTO slu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lemade Yesuske ena-na yor Yesuske wainare rma ma rseak I, keskye ramdiry ti mloskye, ode raso ma rabuk Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ode irire ribun moluk a rtaklulw ma rkoal Yesuske, dendye dum a rlosu ti Yesuske de rbohe, “Matos! Enamw yor waimure sir ne mloskye, ma robak ma rseak a O.” ");
INSERT INTO slu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Keskyede Yesuske hyalas sir ma byohe, “Esekar ne enakw o waikw a sir ne de?” ");
INSERT INTO slu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lemade Yesuske yatos iry ribun mataklulw desikre, ode tyanuk ti sir ma byohe, “Ei ne mumu neke, klwobak a e kola ne kulobak enakw o waikure ne. ");
INSERT INTO slu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dendye mtyomolu! Iry a matomolu Hulasokwe tunanare ode rtoha, iry desikre sir ne rola dene enakw o waikw sir dakun ne.” ");
INSERT INTO slu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sekwe it bonyo, Yesuske yajar ti namwata Tasi Kakan Galileake, desikeo iry ribunke rma ma rkoal a I. Lemade bya ti syai aro mabalkye it ma tyaklulw ti khahake. Ode iry ribun desikre ramdiry ti tasi kakanke kseri desy. ");
INSERT INTO slu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dendye Yesuske yajar ktela ribun nekre kyor tun inahliakare ti iry ribun desikre. Ode kyoat iajar desy, desikeo tyanuk ti iry desikre ma byohe, ");
INSERT INTO slu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mtyomolu! Iry manoha boke it a bya ti kyay a hina hinkye ti wasi boke. ");
INSERT INTO slu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma kyoat ikay hiny desy bonyo, hiny desike tebikan a kdi ti sal mamin ti boke krala desy, ma manunare rorw ma ra ma ktei. ");
INSERT INTO slu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ode hiny desike tebikan a kdi ti lasmyer maniniaske, ma hatkwe kimin ti lasmyer desike kletike. Hiny madi ti lasmyer maninias desike samlurw o ktyuhw. ");
INSERT INTO slu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Keskyede kyoat sekwe ibetik bonyo, hiny matuhw desike kmyalas, kali kawanare lema kbya demdemw. ");
INSERT INTO slu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ode hiny desike tebikan a kdi ti sitw o karkyary krala, ma ktyuhw, keskye lema kisi, kali sitw o karkyary desikre klyean a kyor hiny desy, ma kyah a hiny desy ma lema kisi. ");
INSERT INTO slu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ode hiny desike tebikan a kdi ti lasmyer maiskye, ma ktyuhw ma kisi. Kyoat kisi bonyo, kusunare ratsam neke dum a kisinare hean-telw kbyilak, dum a kisinare hean-nem a kbyilak, ode dum a kisinare atw kbyilak dakun.” ");
INSERT INTO slu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kyoat Yesuske ihes tun inahliak desy maktei bonyo, tyanuk ti sir ma byohe, “Esei desike ika molu, desikemo musti mo tyomolu!” ");
INSERT INTO slu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kyoat a rlaw ma iry ribun desikre raba ma Yesuske imesan bonyo, iry matoha Iare dum a ror wasi matoha I dehean a kresi enaru desy, rena I ti tun inahliak desike kbuanke. ");
INSERT INTO slu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dendye Yesuske hyalas sir ma byohe, “Ana klwosu ti e, kali ei neke Hulasokwe lyura e ma mhye nam mahunik i ti irkye, ti kolkyabei ma Hulasokwe ihareta kola Rajake ne. Klala ti iry ribunke, kajar sir a kyor tun inahliakare bo, ");
INSERT INTO slu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ma ‘Biar ma ratos manenen dakun, keskyede lema rhe kbuanare. Ode biar ma rtomolu elik, keskye lema rhe kbuanare dakun. Kali kolnye ratos ode rhe kbuanare, desikeo ana rulak sir ma Hulasokwe syos wait lim o sal ba.’” ");
INSERT INTO slu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lemade Yesuske tyanuk ti sir ma byohe, “De lema mhye tun inahliak ne kbuanke e? Kolnye lema mhye tun inahliak ne kbuanke, desikemo kolkyabei ma ana bisa ma mhye tun inahliak salik nekre mumu ne kbuanare de? ");
INSERT INTO slu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dendye mtyomolu! Iry makay a hiny desike, neke kbuanke o iry a maabrita Hulasokwe tunanare. Ode hiny desike Hulasokwe tunanare desy. ");
INSERT INTO slu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ode hiny madi ti salke krala mamin ti bo desy, kola dene iry a matomolu Hulasokwe tuna rabrita ti sir desy, keskye ngkeskwaure wait uskwe khatuke mya ma yal elik Hulasokwe tuna desikre toha sir. ");
INSERT INTO slu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ode hiny a madi ti hatw khahanare, desike kbuanke o, iry matomolu Hulasokwe tunanare ma rtohak kyor ralat mamukmuka iare. ");
INSERT INTO slu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Keskye lema raneti ral wait tohtohakke, ode lema rsosan Hulasokwe tuna desikre ti ralat a kralanare. Dendye kolnye masunkwe kdyan sir, ta roban de rtaba sir khyali Hulasokwe tuna desikre, desikeo ra-la toha wait tohtohak desy elik, ma lema rtohak Yesuske de. ");
INSERT INTO slu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ode hiny madi ti sitw o karkyary krala ne, neke kbuanke o iry a matomolu Hulasokwe tunanare. ");
INSERT INTO slu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Keskyede ralatare kakan ti ktelanare ribun. Ode rbuma raka wait maloly ma ribun, ode rdakin ktela ribun salno salik mamin ti nuske ktem ne dakun. Dendye ktela desikre mumu neke, ne kisekan Hulasokwe tunanare toha ralat a kralanare, dendye Hulasokwe tuna desikre lema kika kbuan ti sir, kola ne hiny desike ma lema ktyuhw ma kisi kali sitw o karkyary kyah. ");
INSERT INTO slu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Keskyede hiny madi ti lasmyer maiskye, neke kbuanke o iry a matomolu Hulasokwe tunanare ode rtohak, ma rsosan ti ralat a kralanare. Ode ramorif ne rala ktela erasare kmyesan, ma ktyoha Hulasokwe tuna desikre. Iry desikre rola dene hiny a maisy ma kisinare ribun ne, ma dum a kisinare hean telw kbyilak, ode dum a kisinare hean-nem a kbyilak, ode dum a kisinare atw kbyilak dakun.” ");
INSERT INTO slu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lemade Yesuske tyanuk ma byohe, “Lema irkye it a tyunw damarke, ode yal ti lkuskye kralake ma kyahat eta, ta lemamo yal ti rintyotake ma kitina i. De musti mo yal ei kwena atatke ma kdyelaf a sekye kralake. ");
INSERT INTO slu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kali nam Hulasokwe iala ma kibuny nekre, ana yala ma kbyetik mumu. Ode rekryeky a Hulasokwe ihunik nekre, ana irire mumu ne bisa ma rhe. ");
INSERT INTO slu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lemadendye esei desy ika molu, desikemo musti mo tyomolu.” ");
INSERT INTO slu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ode Yesuske tyanuk huruk ma byohe, “Mryekan mamak nam mitomolu nekre! Kali lalwaw minal ma milaw ti irire ne, ana Hulasokwe yal ma lyaw ti e dakun. Ode lema desy bo, de ana lyaw o tyabal ma kbyilak ti e dakun. ");
INSERT INTO slu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kali esei desike, syosan mamak tun kutanukare ma hye, desikeo Hulasokwe tyabal hehe desy ti i ma kbyilak. Klala esei desike tyomolu ode lema syosan mamak tun kutanukare, biar ma ryekan o hye tunakure de, keskyede ana Hulasokwe yal a yolik hehe desy toha i.” ");
INSERT INTO slu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dendye Yesuske tyanuk huruk ma byohe, “Hulasokwe ihareta kola Rajake, neke kola iry a manoha boke ti itan hinkye ti wasi boke ne. ");
INSERT INTO slu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lemade sewahare bonyo iry desike yenaf, ode msarinare o byatar ma yal karyake. Klala hiny desike kmyesan a ktyuhw, ode kmyesan a klyean ma lan. Keskye iry desike lema hye o, nam sai ne kiala hiny desike ma kituhw ma lan ne. ");
INSERT INTO slu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","De cuma mo lasmyer neke kmyesan a kyala ma ktyuhw, maktei o kisitw ma ksitunare ribun, ode kihun ma kisi. ");
INSERT INTO slu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ode kolnye kyait sekwe ma kisinare knyor de, desikeo boke kebu desike, mya ma yal elik kisi desikre.” ");
INSERT INTO slu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Maktei o Yesuske tyanuk huruk ma byohe, “Ana kal sai ma kulalau kyor Hulasokwe ima ma ihareta kola Rajake ne de? Dete lemamo kal tun inahliak sai ma kuhliak de?” ");
INSERT INTO slu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dendye Yesuske tyanuk ma byohe, “Hulasokwe ima ma ihareta kola Rajake ne, neke kuhliak ti lasyeke khatu rakay ti lasmyerke ne. Lasyeke khatu neke kakakan bain ti hiny nekre mumu ti nuske ktem ne. ");
INSERT INTO slu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Keskyede kolnye tkay lasyeke khatu desy ti boke ma ktyuhw ma lan, ma kbyilak nam matuhw ida nekre mumu, ode kisan ma ksananare lan, ma khyury ma manunare raka nukat ti, ma ramin ti.” ");
INSERT INTO slu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Koldyesike mane Yesuske yal inahliak ribun maoly desikre, ma yal ma yajar iry ribun desikre, ma ktyoha wait hehe rarekanare kinaitare bo. ");
INSERT INTO slu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dendye sew kyaki ne Yesuske yajar iry ribunke kyor tun inahliakare. Klala kolnye Yesuske yor wasi matoha Iare ma rmesan, desikeo nenmo yaklol tun inahliak desikre kbuanare mumu ti sir. ");
INSERT INTO slu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ode ti sew desike dakun o sekwe yala ma dyi, desikeo Yesuske tyanuk ti wasi matoha I dehean a kresi enaru desy ma byohe, “Mmya ma tsai aroke ma tbity lar ti ma tbai tasi kakanke serida so.” ");
INSERT INTO slu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lemade wasi matoha Iare rtutuk iry ribun desikre ti desy, ode rew ba ti rsai aro Yesuske itaklulw ti desy, ma rbity larke ti ma rba. Desikeo aroare dum a rbity lar ma rtoha sir dakun. ");
INSERT INTO slu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ode kyala mait bonyo, eskwe mety ksyalik ode besanare lan, ma tasike ksyukar ei aroke kralake ma nenma rlodur. ");
INSERT INTO slu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kyoat desy dakun o Yesuske malmata yenaf ti aroke lyakwe, ode lyun a lunlunke ma tyebti. Lemade wasi matoha Iare roha I ma rbohe, “Tuanggurw O! Tala ma tmaty mane, lema mhwaduli ity e?” ");
INSERT INTO slu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lemade Yesuske byatar, ode tyerik esw desy, ode tyenauk besa atat desikre ma byohe, “Mamwaw o!” Desike bonyo kele rtenauk esw desy, ode besanare ti tasi kakan desike kele rteka ma mlin a mlin. ");
INSERT INTO slu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Kyanmwane mimtaut ne de? Ode kyanmwane lenla mitohak Yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lemade wasi matoha I desikre ramtaut a ksyalik, ode it de tyanuk ti it ma rbohe, “Iry neke esei bain de? Mane inal haretke ti esw o besa nekre, desikeo kele rateka mait ne de!” ");
INSERT INTO slu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lemade Yesuske yor wasi matoha Iare rsara sir ti tasi kakanke seridake, neke iry Gerasa-nare wait lasmyerke. ");
INSERT INTO slu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ode kyoat Yesuske nenmo yorw toha aroke, desikeo wamwankye it ma ngkeskwaure rsukar i, ma yosy a ratkye ma mya ma lyakut sara Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iry desike imin ti ratkye, ma lema irkye it a bisa ma kyumak yal i elik, biar ma ral ranteke ma rdalun i desyo lema bisa dakun. ");
INSERT INTO slu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kali kyalamo irire ral ranteke ma rdalun sima o lwau, keskyede byesak i ti de byesak i ma, nini kele yohut rante ranal ma radalun i desy ma kiskyui kiskyay. Ode irkye it a lema malkyakaw i ma, bisa ma kyumak yal i elik. ");
INSERT INTO slu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ode sewah o msarin neke lyakut ti de lyakut ma ti ratkye krala desy, ode ti kususwanare dakun, ma byoran ti de byoran ma bo. Ode yal hatkwe ma yal ma tyutu tenan ne nini kimnu a kimlarit. ");
INSERT INTO slu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ode kyoat iatos Yesuske ma sososo a I ne bonyo, ila ma ti yait Yesuske ma syakitil ti Yesuske wasi lulululw ne. ");
INSERT INTO slu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Lemade Yesuske tyanuk ti iry desike ma byohe, “Hei ngkeskwaw o, mbwetik toha iry ne!” Dendye iry desike telake lan ma tyanuk de byohe, “Yesus Hulasow Lan Lahukke Anan O, mrweky sai ma yaw ne de? Kuten ma muhwab ti Hulasokwe ma ana lema muhdawan yaw, ma isikkwe ksunw!” ");
INSERT INTO slu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Maktei o Yesuske yena iry desy ma byohe, “Animw ka?” Desikeo iry desike hyalas ma byohe, “Anikw a Legion ande, kali ribun aramy!” ");
INSERT INTO slu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lemade ngkeskwaw desikre raten mirmirmirin toha Yesuske, ma kete Yesuske yaso sir ma rbetik toha lasmyer desy. ");
INSERT INTO slu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ode ti soke dakun o hahire ribun a sir a ksyalik, ma moluk a raobak kotut ti kususwanke kserike. ");
INSERT INTO slu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lemade ngkeskwaw desikre raten bain-bain toha Yesuske ma rbohe, “Kolnye mesak aramy tyoha iry ne, desikemo mlwura aramy ma ti msyukar ei hahy sokre.” ");
INSERT INTO slu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dendye Yesuske you tyoha tun ratanuk desy. Lemadendye ngkeskwaw desikre rbetik toha iry desy, ode ti rsukar ei hahkye kmeta desy. Ma hahkye kmeta desike anakyai ribunke enaru sir, neke ra-la roruk ma ti rnusuk toha iskye ksouke ei tasi kakanke ma rlodur, ode renw tasi ma rmaty. ");
INSERT INTO slu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lemade iry majaga hahy desikre ratos a ktela desy bonyo, ra-la toha wen desy, ma rba ti rahes ktela desy ti iry mamin ti nus o hnu kabei ta kabei ti lasmyer Gerasa desy. Dendye iry ribun lan desikre ratomolu brit desy bonyo, rbetik rosy wait nus o hnu desikre ma rbai wen desy, ti ratos ktela madi ti desy. ");
INSERT INTO slu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ode kyoat iry desikre rma ma rait a Yesuske bonyo, ratos o iry a ngkeskwaure rasukar i desike eras i de. Ma hye toha lbweta de, ode hyonak a i de, ma tyaklulw. Lemade iry desikre raatos a ktela desike bonyo ramtaut. ");
INSERT INTO slu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ode iry a maatos a kmuna ktela desike elik neke, rahes ti iry a nenmo mamaare, ti ktela madi ti iry a ngkeskwaure rasukar i desy. Ode rahes a ktela madi ti hahkye kmeta desy ti sir dakun. ");
INSERT INTO slu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lemadendye iry desikre ralkyaw sir ma raten toha Yesuske ma byetik toha wait lasmyer desy. ");
INSERT INTO slu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ode kyoat Yesuske syai ei aroke huruk bonyo, iry a ngkeskwaure rabetik toha i desike iten ma tyoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Keskyede Yesuske lema you, de tyanuk ti iry desy ma byohe, “Mulak a o bai wasimw sekye, ode muhes ti sekye kralake ror iry mamin ti wasimw a hnuke dakun, ti kolkyabei mane Hulasokwe ilobak a o ne, ode ti kolkyabei mane iala ktela nekre mumu ti o ne.” ");
INSERT INTO slu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lemade iry desike bya, ode yabrita ktela Yesuske iala ti i nekre mumu, ti iry mamin ti lasmyer Dekapoliske. Ode iry a matomolu ktela ihes desikre, sir mumu ne rheran a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lemade Yesuske yor wasi matoha Iare rbity lar ti ma rulak sir bai tasi kakanke seridake. Ode kyoat Yesuske yorw toha aroke ma imdiry ti laranke khahake bonyo, iry ribunke lui-lui sir ma rma ma rkoal a I. ");
INSERT INTO slu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ode irkye it ma ani Yairus ma mya dakun. Yairus neke ika usu khatu ti Yahudi-nare sey rasambayan tike. Ode kyoat iatos Yesuske bonyo, bya ti syakitil ti Yesuske lwau-na ktutunare, ");
INSERT INTO slu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma yal ralake kusuke bain-bain, ma iten toha Yesuske ma byohe, “Tuanggurw! Anakw wamfwetke kluruk a i, ma nenma myaty. Lemade kuten toha O, ma mbwai wasikw sekye ti mswaa simamkwe ti anakkwe ma eras i, ma kete myaty.” ");
INSERT INTO slu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lemade Yesuske yor Yairus ma rbai Yairus wasi sekye. Keskye iry ribunke lui-lui sir ma rtoha Yesuske, ma it de dyekin it, ma robak ma rney a Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ti iry ribun desikre dakun o wamfwetke it ma kbai larke khatu maskyakye kyala i ainke hean a kresi enaru de, ");
INSERT INTO slu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ma dokterare raeluk-raeluk sir ma rnoha wasi kbai desy, keskye lema kika iry a manoha kyal wasi kbai desy. Ode biar ma yal wasi malolkye mumu ti dokter desikre nini ktei, keskyede lema kika kbuan, de wasi kbaike ktyabal a ktyabal ma mdedan toha. ");
INSERT INTO slu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ode wamfwet desike tyomolu Yesuske nam ialanare de, dendye biar ma irire ribun sir, keskyede wamfwet desike isia ia yosy a lyakwe ma ti nyey a Yesuske, ma kyambil mait wasi rabit narnarkwe. ");
INSERT INTO slu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kali wamfwet desike ryekan ti ralake ma byohe, “Biar ma kkwambil mait Yesuske wasi rabit narnarkwe bo, desikeo ana wasikw a kbaike kitayar ma eras yaw elik.” ");
INSERT INTO slu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lemade kyoat wamfwet desike yalkyaw i ma isia i ti iry ribun desikre ma ikambil Yesuske wasi rabit narnarkwe bonyo, kyoman o wasi kbai desike kitayar elik. ");
INSERT INTO slu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ode kyoat desike dakun o Yesuske hye elik ohe, amalkyauke kbyetik kyosy tenanke. Dendye yulak i sara iry ribun desikre, ode yena sir ma byohe, “Esei ne ikambil wasikw rabitke ne de?” ");
INSERT INTO slu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Keskye wasi matoha Iare rhalas I ma rbohe, “Tuanggurw! Matos, iry ribun lan neke radekin ma robak ma rney a O, ode kyanmwane muena o esei ne ikambil wasimw rabitke ne de?” ");
INSERT INTO slu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lemade Yesuske yulak I ma yatos iry desikre mumu, ma yobak ma hye o esei ne iala ktela desike ne. ");
INSERT INTO slu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lemade wamfwet desike hye o Yesuske hye ktela iala desy, dendye imtaut ma huake kyamlulurw. Lemade lyakut ti syakitil ti Yesuske wasi lulululw ne. Ode yal ralake kusuke bain-bain ma ihes nam madi ti i ne mumu ti Yesuske, mane kihury ma ikambil Yesuske wasi rabitke ne. ");
INSERT INTO slu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lemadendye Yesuske tyanuk ti wamfwet desy ma byohe, “Eno, Hulasokwe nyoha wasimw kbaike ma eras a o de, khyali wasimw tohtohakke. Dendye mbwaa mor inaka eras manosy Hulasokwe, kali wasimw kbaike eras de.” ");
INSERT INTO slu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Malmata Yesuske itun a yor wamfwet desy, desikeo irire dum a rosy Yairus wasi sekye, ma rma ma rtanuk ti Yairus de rbohe, “Amo, anamkwe myaty de. Dendye kete mhwury ma tuanggurkwe byai wasimw sekye de.” ");
INSERT INTO slu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Keskyede Yesuske itomolu tun ratanuk desike bonyo, lema hyaduli, de tyanuk ti Yairus ma byohe, “Kete mumtaut, de mtwohak bo. Anamkwe ana myorif.” ");
INSERT INTO slu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dendye Yesuske byu eta ma kete irkye it a tyoha I, de cuma mo tyanuk ti Petrus, ode Yakobus yor wai Yohanes, ma ror Yesuske de raktem a rba bo. ");
INSERT INTO slu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kyoat ranait Yairus wasi sekye bonyo, Yesuske yatos o irire ribun sir, ma serser nanyay a sir ode telatare lan ma ralola-ratanuk ti desy. ");
INSERT INTO slu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ode kyoat Yesuske syukar ei Yairus wasi sekye kralake bonyo, tyanuk ti iry desikre ma byohe, “Kyanmwane serser nanyay e ne de? Naman ne lema myaty, de yenaf bo!” ");
INSERT INTO slu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Keskyede kyoat iry desikre ratomolu Yesuske nam itanuk desy bonyo ramahis. Lemade Yesuske byu ti iry desikre mumu ma rbetik ei mloskye. Ode tyanuk ti naman desike ena-na yor ama, ode wasi matoha I detelw desy, ma raktem a rsukar ei naman desike wasi kamarke. ");
INSERT INTO slu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ode Yesuske kyumak naman desike simake, ode yal naman desike wait telke ma tyanuk de byohe, “Talita kum,” neke kbuanke o, “Akasy, mbwatar!” ");
INSERT INTO slu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kyala mait bonyo naman desike byatar, ode imdiry ma lyakut, kali wasi ainke hean a kresi enaru de. Ode iry desikre mumu neke rheran a ksyalik ti ratos ktela desy. ");
INSERT INTO slu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Keskyede Yesuske byu eta sir, ma kete rahes ktela desy ti irkye it elik. Lemade yaso ma ral kotw ti naman desike ma nya. ");
INSERT INTO slu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lemadendye Yesuske yor wasi matoha Iare rbetik toha Yairus wasi sekye ma rbai Nazaret, neke Yesuske wasi hnu a lan I tike. ");
INSERT INTO slu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ode kyoat sew Inamreske bonyo, Yesuske yajar ti Yahudi-nare sey rasambayan tike. Dendye iry ribun nekre rheran ti ratomolu I ne, lemade rtanuk ma rbohe, “Nam iajar nekre kyosy kabei de? Ode esei ne inal hehei lulw o lyaw ne ti I ma iajar kolnye de? Ode kyanmwane bisa ma yala ktela masalsyalik iare ne de? ");
INSERT INTO slu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","De lema I neke ika tukan aw e? Ma Maria anan a I e? Ma wainare sir ne Yakobus, Yoses, Yudas ode Simon sir e? Ma rahyetanare sir ne ranor a ity ti ne e?” Lemadendye iry desikre ralatare ksunw, dendye lema rou ma ral Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lemade Yesuske tyanuk ti sir ma byohe, “Iry manety Hulasokwe wasi nyanoke, ralan i ti hnu kabei ta kabei bo, klala wai o hatnima mamin ti wasi hnuke, neke rmesan lema ralan a I!” ");
INSERT INTO slu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ti desike dakun o Yesuske lema yala ktela masalsyalik ike it dakun, kali iry desikre lema rtohak I. De cuma mo syaa sima ti irire dum, ode nyoha wait kbainare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Ode Yesuske hyeran, kali iry desikre lema rtohak I. ");
INSERT INTO slu_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Maktei o Yesuske yor wasi matoha I dehean a kresi enaru desy rbetik rosy a hnu Nazaretke, ode rlakut a rlola hnuare ma Yesuske yajar irire. ");
INSERT INTO slu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lemadendye Yesuske iwahuk wasi matoha I dehean a kresi enaru desy. Ode ihanun wasi matoha I desikre raru-raru ti sasam, maktei o yal wasi haretke ti sir, ma bisa ma resak ngkeskwaure. ");
INSERT INTO slu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ode yaso sir de byohe, “Miba neke kete myety namit-namit, neke kete myety a res, ode kete myety a suhlwak, ode kete myety a kuban dakun, de myety a wasimy tektekanare bo. ");
INSERT INTO slu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ode mbya o kete myety rabit ma kbyilak, de rabit mamin ti tenamire, ode dori mamin ti lwaumire bo.” ");
INSERT INTO slu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maktei o Yesuske tyanuk ti sir huruk ma byohe, “Kolnye myait a hnuke it, ode irkye it a yal e ma mimin ti wasi sekye, desikemo mimin ti sey desy nini mbyuma mbyetik toha hnu desy, ma mbyai hnu salik. ");
INSERT INTO slu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Keskye kolnye msyukar a hnuke it, ode lema rou ma ral e ei wait seire, ode lema rbuma rtomolu e dakun, desikemo mbyetik toha hnu desy. Keskye mryitik a ahkwe toha lwaumire ti desy aduk, ma klyosu ohe Hulasokwe ana yukun hnu desy.” Yesuske itanuk koldyesy ti sir maktei bonyo, yaso sir ma rba. ");
INSERT INTO slu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lemadendye wasi matoha dehean a kresi enaru desike rbai nus o hnu mamin ti desy ma ti rabrita ohe, irire musti mo rtunik wait lim o sal ba. ");
INSERT INTO slu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ode sir dakun o resak a ngkeskwaure, ode rkasa nulke ti iry a klurukare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lemade Yesuske Anike kimelir ti kabei ta kabei bo, ti ktela ribun iala nekre. Ode raja Herodes Antipas tyomolu irire ma rbohe, “Yesus neke Yohanes Mababtiske i ne, ma myorif huruk toha mamatire de. Dendye haret lan ne kimin i ma bisa ma yala ktela masalsyalik iare.” ");
INSERT INTO slu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ode irire dum a rtanuk huruk ma rbohe, “Yesus neke Elia!” Ode irire dum dakun neke rtanuk ma rbohe, “I neke, iry a manety Hulasokwe wasi nyanoke, kola iry a heitlulswo ranety Hulasokwe wasi nyanoare ne.” ");
INSERT INTO slu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Keskyede kyoat raja Herodes Antipas itomolu ktela desy bonyo, tyanuk ma byohe, “Nde! De kete Yohanes Mababtis kola kuaso ma rasoby ohut telake i ne, ma senwe myorif huruk mane!” ");
INSERT INTO slu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Keskye lenla tun desike kdi ti bonyo, raja Herodes neke yaso ma rkumak Yohanes, ma rluk i ti sey metmetke kralake. Yala koldyesy, kali Herodes sawa Herodias ne kyeyer a Yohanes ne a ksyalik. Herodias ne heit a raja Herodes wai Filipus ne sawa i. Ode Herodias ne kyeyer a Yohanes, kali kyaki-kyaki ne Yohanes tyerik raja Herodes, ma byu eta i ma byohe, “Ktela muala desike sal! Kali Hulasokwe wasi tnyetak inal ti Musake kbyu eta ma kete tasaa tor ity waitare sawatare.” ");
INSERT INTO slu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Desike ne kihury ma Herodias yatil Yohanes, ma yobak ma tyabahunw a i. Keskye lema bisa ma tyabahunw a i, ");
INSERT INTO slu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kali raja Herodes neke ryiw a Yohanes, kali hye ohe Yohanes neke iry a mlakye, ode nelnyely a i. Lemadendye byelat eta i. Ode raja Herodes neke dyakin ma tyomolu Yohanes ma ihes tun. Ode biar ma dyakin ma tyomolu Yohanes ma ihes tun, keskyede tun itomolu desikre kyala ralake kralake ma lema ktyeka i. ");
INSERT INTO slu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lemadendye Herodias itot klelanke it ti kyoat raja Herodes yala kalkal lan ne, ti wasi sew radur hahak ike. Ti sew desike raja Herodes yabuk wasi maka kmata lan nekre mumu, ror usu khatu suldatare, rtabal iry manety lulw ti Galilea nekre mumu dakun, ma rmai wasi kalkal desy. ");
INSERT INTO slu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma kyoat a kalkal desike klyakut, desikeo Herodias anan wamfwetke mya ma myenari ti kalkal desy. Ode wasi menari desike kyala raja Herodes ralake ma ksyenan a ksyalik, ktyabal maka kmata lan a raabuk ti kalkal desy ralatare ksyenan dakun. Dendye raja Herodes tyanuk ti warar mur desy ma byohe, “Kolnye mdwakin sai ma muten toha yaw, desikeo ana kunal ti oke bo!” ");
INSERT INTO slu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lemadendye raja Herodes ihatetak bain-bain ti warar mur desy ma byohe, “Nam sai desike muten, ana kal ti o. Ma ti kyal wen kuhareta ti ne serit dakun, ana kunal ti oke bo!” ");
INSERT INTO slu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dendye warar desike byetik toha kalkal desy, ode bya ti yena ena Herodias ma byohe, “Eno, musti mo kuten sai toha raja Herodes de?” Lemade ena-na hyalas i ma byohe, “Musti mo muten a Yohanes Mababtiske usuke khatuke.” ");
INSERT INTO slu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lemadendye warar desike lyahlaha mirin ma yulak i ti tyanuk ti raja Herodes ma byohe, “Amo, jam ne dakun o kuten a Yohanes Mababtiske usuke khatuke, ma mal ti mbinan helhelake, ode mal ma yaw.” ");
INSERT INTO slu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kyoat raja Herodes itomolu warar desy nam itenke bonyo, ralake kitol a ksyalik. Keskye lema bisa ma byity suka wasi hatetak desy de, kali wasi mwakun desikre dakun o, rtomolu wasi hatetak desy de. ");
INSERT INTO slu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lemadendye raja Herodes yal haretke elik ti wasi suldat majakke it, ma byai sey metmetke, ti syoby ohut Yohanes Mababtiske telake. ");
INSERT INTO slu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Maktei o yal Yohanes usuke khatuke ti mbinan helhelake, ode yety ma yal ti warar desy. Ode warar desike yeta syaur ti ena Herodias. ");
INSERT INTO slu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kyoat a Yohanes wasi matoha iare ratomolu ktela desy bonyo, rma ma ral Yohanes tbunanke ma ti ramlin o ratkye. ");
INSERT INTO slu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ode kyoat a Yesuske wasi nyasoare rulak sir ma rawahuk sir a ror Yesuske, desikeo rahes a ktela rakarya ode raajar nekre mumu ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Keskye iry ribunke ti de ba de ma sir ti desy, ma khyury ma Yesuske yor wasi nyaso dehean a kresi enaru desy, lema bisa ma raknam o renw. Dendye Yesuske tyanuk ti wasi nyaso desikre ma byohe, “Mmya ma tbai wen kele ratelinke it, ma tamin ti ma tmea tebikan aduk.” ");
INSERT INTO slu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lemadendye Yesuske yor wasi nyaso desikre rsai aroke ma rbai wen a kele ratelinke it, ma soso sir toha iry ribunke. ");
INSERT INTO slu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Keskyede kyoat raba bonyo, iry ribunke ratos sir ode rhe wen raba tike. Lemadendye iry mamin ti nus o lasmyer desy mumu ne, rlakut a rlahamety ma rosy sal rake, ma rmuna Yesuske yor wasi nyaso desikre bai wen kele ratelin desy. ");
INSERT INTO slu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ode kyoat a Yesuske rsara sir ti wen kele ratelin desy bonyo, yatos o irire ribun sir a rawahuk sir ti wen desy de. Lemadendye khyury ma Yesuske lyobak sir a ksyalik, kali rola dene dombanare ti lema kika iry majaga sir ne. Dendye Yesuske yajar ktela ribunke ti iry ribun desikre. ");
INSERT INTO slu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ode kyoat sekwe yala ma idi bonyo, Yesuske wasi matoha Iare rma ma rtanuk ti I ma rbohe, “Tuanggurw O, wen neke kele rtelin, ode sekwe yala ma dyi mane. ");
INSERT INTO slu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lemamo maso iry nekre ma rba, ma bisa ma ti rliw a kotw o abw ti hnu maney nekre ma ra.” ");
INSERT INTO slu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Keskyede Yesuske hyalas wasi matoha Iare ma byohe, “Lema! Ei neke musti mo myal kotw ti iry nekre ma ra.” Lemade rhalas Yesuske de rbohe, “Kolkyabei ma bisa ma aramy mlyiw roty karyari ne, ma aramy myal ti iry nekre mumu ma ra de? Roty desikre khesike anakyai kubanke atkwe enaru!” ");
INSERT INTO slu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dendye Yesuske yena wasi matoha I desikre de byohe, “Hinamy a rotkye enai desy de? Myatos aduk!” Kyoat ratos bonyo rlosu ti Yesuske ma rbohe, “Rotkye enasim ode maskye enaru bony mane.” ");
INSERT INTO slu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Lemade Yesuske yaso iry desikre ma rtaklulw ma kukwan it kukwan it ti tnyei na khahanare. ");
INSERT INTO slu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dendye iry desikre rtoha ma rtaklulw ma kukwan it kukwan it, ma kukwanare dum a irkye rait atw, ode kukwanare dum a irkye rait a hean-sim. ");
INSERT INTO slu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kyoat iry ribun lan desikre rataklulw bonyo, Yesuske yal roty desim desy, ode masy deru desy, ode yatnyarak ei laitke ma syalak eraske ba ti Hulasokwe ti khyali roty o masy desikre. Maktei o byiny a roty o masy desikre, ode yal ti wasi matoha Iare ma rasakar ti iry ribun lan desy. ");
INSERT INTO slu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma raktemtem mumu neke raknam nini rbesur. ");
INSERT INTO slu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Maktei o Yesuske wasi matoha Iare rili rahuk roty o masy ktera desikre, desikeo kbyenw a kolakye hean a kresi enaru. ");
INSERT INTO slu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iry a maknam mamin ti desikre mumu, kolnye raki wamwanire rmesan bonyo, irkye ribunke enasim sir. Klala lenla raki wamfwetare ror namanare. ");
INSERT INTO slu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kyoat raknam maktei bonyo, Yesuske tyanuk elik ti wasi matoha Iare, ma rmuna I bai hnu Betsaidake, ti tasi kakanke seridake. Lemade wasi matoha Iare roruk ma ti rsai aroke, ma rbity lar ti ma rba. Ode Yesuske yaso iry ribun desikre ma rulak sir bai wait a hnuare. ");
INSERT INTO slu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kyoat iry desikre raba mumu bonyo, Yesuske syai bai kususwanke ti syambayan. ");
INSERT INTO slu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ode kyoat sekwe dyi ma kelerkok bonyo, Yesuske wasi matoha Iare rait ei tasi kakanke kditlalan ne, ode lenla Yesuske myesan imin ti rake bo. ");
INSERT INTO slu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ode Yesuske yatos wasi matoha Iare, ma lema rhaya ral wait aroke, kali eskwe kyosy lulkwe. Ode anakyai kyoban enatelkwe ti nyamo ne, desikeo Yesuske lyakut ti tasike khahake, ma bya sara sir ma yala ma myuna sir. ");
INSERT INTO slu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kyoat wasi matoha Iare ratos Yesuske ma lyakut ti tasike khahake, desikeo rakeni ohe, watkwe kebuke it ne. Dendye rboran, ");
INSERT INTO slu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kali raktemtem neke ratos I bonyo, ramtaut ma ramlulurw. Keskyede Yesuske tyanuk ti sir ma byohe, “Hei mamwaw e! Kete mimtaut! Kali Yaw ne.” ");
INSERT INTO slu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lemade Yesuske syai ei wait aroke bonyo kele rteka eskwe mait. Dendye wasi matoha Iare rheran a ksyalik ma lema rhe o rala sai. ");
INSERT INTO slu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kali sir dakun o, lenla rhe kbuanke ti ktela Yesuske inal rotkye enasim ode maskye enaru, ti iry ribun lan ne ma rana desy. Ode sir dakun o lenla rhe ohe Yesus neke esei ne bain, kali ralat a kralanare ngkora a nggora. ");
INSERT INTO slu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kyoat Yesuske yor wasi matoha Iare rbai tasi kakanke seridake, ma ranait namwata Genesaretke bonyo, rbaly ti desy. ");
INSERT INTO slu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ode kyoat raorw toha aroke bonyo, iry ribunke ratos sir, desikeo rhe Yesuske elik. ");
INSERT INTO slu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dendye iry ribun desikre ra-la a robak hnu mamin ti desikre, ma ti rlosu ti sir, ma kolnye Yesuske byai hnu kabei desy, desikeo irire ral wait iry isy masunure ti mbelukare ma ror sir ba ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma kolnye Yesuske byai nus o hnu mamin ti lasmyer desy, desikeo iry mamin ti nus o hnu desikre ror wait iry a isy masunure bai wait mleranare, ma kolnye Yesuske lyakut yosy desy, desikemo raten ma iry a isy masunw desikre rkambil wasi rabit narnarw desy kninike bo. Dendye iry a isy masunw kabei desy kyambil Yesuske wasi rabit narnarw desy kninike, desikeo wasi kbaike kitayar ma eras i elik. ");
INSERT INTO slu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sekwe it bonyo iry a manosy lui Farisike dum a ror iry a mahe snurat o tnyetak Musake dum, neke rlakut a rosy a Yerusalem ma rma ma rkoal a Yesuske, ma rbihy a I. ");
INSERT INTO slu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kyoat desike iry desikre ratos Yesuske wasi matoha Iare dum ma raknam, desikeo lema rut simatare aduk ma ktyoha ebnwo matrumat Yahudi-nare wait ktela kubkubakke. ");
INSERT INTO slu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kali iry a manosy lui Farisi-nare, ror iry a Yahudi salik nekre, kolnye rala ma raknam, desikeo musti mo rut a simatare aduk, ma ktyoha ebnwo matrumat a wait ktela kubkubakke. ");
INSERT INTO slu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ode kolnye ti rahwely o wen raketa nam tike, ode rulak sir toha wen raketa nam tike, desikeo lenla bisa ma raknam, de musti mo rut a simatare ma nelnyely aduk. Wait a ktela nekre rkumak malkyakaw kali kyosy a ebnwo matrumat. Ode wait a ktela salik nekre ribun dakun, ma musti mo rtoha. Neke ktela raut wait taw o, sru o mbinan o, ur o werany, ode nam salik raala toha soly nekre dakun. ");
INSERT INTO slu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lemade iry manosy lui Farisi-nare ror iry a mahe snurat o tnyetak Musake rena Yesuske ma rbohe, “Kyanmwane wasimw matoha Oare lema rtoha ktela ity ebnwo matrumat raalanare ne de? Ma lema rut simatare aduk de, raknam a ror simat maray nekre bony ne de?” ");
INSERT INTO slu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lemade Yesuske hyalas sir ma byohe, “Hei iry a mlay bain o makakmet e! Ei ne myola nam a Yesaya, iry a heitlulswo manety Hulasokwe wasi nyano desy, neke nam ikesy ti wasi kitabke. Neke kyesy kolnye: ‘Bangsa neke lema ral ralat a kusunare ma Yaw, de rleru Yaw kyor nunut a ktutunare bo. ");
INSERT INTO slu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ode lema kika kbuan ti rasambayan ma Yaw ne, kali nam raajar nekre irkye wasi haretke desy bo.’ ");
INSERT INTO slu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kali ei neke lema mtyoha Hulasokwe wasi haretke, de mtyoha wasimy a ktela manosy irkye bo.” ");
INSERT INTO slu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lemade Yesuske tyanuk huruk ma byohe, “Ei neke mhye telke ma lema mhyaduli haret Hulasokwe, kali mbyuma mtyoha ebnwo matrumamy wait a ktelanare bo. ");
INSERT INTO slu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kali kola Musa tyanuk de ma byohe, ‘Malan a enamw o amamw!’ Ode tyanuk huruk ma byohe, ‘Esei desike syoba ena o ama, desikeo musti mo ral tnyetak matmyatkye ti i.’ ");
INSERT INTO slu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Keskyede ei neke myajar ma mbyohe, ‘Eras ti kolnye irkye it a tyanuk ti ena ta ama ma byohe, “Eno, amo, nam kusosan ma ana kunal ma kusaluk a e ne, neke kal mumu ma kabar ti Hulasokwe de.”’ Keskyede Hulasokwe lema dyakin ktela desy! ");
INSERT INTO slu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kali nam miajar desike khyury ma irire lema rsaluk enat o amat ma desy. ");
INSERT INTO slu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ode ktela miala desikre lema ktyoha Hulasokwe tunanare, de ktyoha ebnwo matrumamy a nam raajar ti eare. Ode nam miajar desikre, ktyabal nam ribun salik miajar maoly desy dakun ne, neke ne kihury ma irire lema ratoha Hulasokwe tunanare ne.” ");
INSERT INTO slu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lemade Yesuske yabuk iry ribun desikre huruk, ode tyanuk ti sir de byohe: “Ei ne mumu ne mtyomolu mamak nam kutanuk ti e nekre, ma mhye. ");
INSERT INTO slu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Neke kolnye! Lema kika kotw o abw manosy a mloskye ma ksyukar ei irkye tenanke, ma kyala iry desy ma iray. De nam mabetik kyosy irkye tenanke ne, nam desike ne kiala iry desy ma iray ne.  ");
INSERT INTO slu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Lemade esei desike ika molu desikemo musti mo tyomolu!” ");
INSERT INTO slu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kyoat Yesuske itun maktei bonyo, tyutuk iry ribun desikre, ode yor wasi matoha Iare rsukar ei sekye it, desike bonyo wasi matoha I desikre rena I de rbohe, “Tuanggurw, tun muhliak desikre kbuanke kolkya?” ");
INSERT INTO slu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Dendye Yesuske hyalas sir ma byohe, “Kyanmwane lenla mihe inahliak ne kbuanke ne de? Lema mhye ohe kotw o abw sai ta sai ksyukar ei irkye tenanke, desikemo lema bisa ma kyala iry desike ma iray. ");
INSERT INTO slu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kali kotw o abw tana nekre lema ksyukar ei ity ralatare, de ksyukar ei ity fteitare, maktei o tadaik ba bo.” Koldyesike mane Yesuske byohe lema kika kotw tasusi, de ta kotw nekre mumu bo. ");
INSERT INTO slu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lemade Yesuske tyanuk huruk ma byohe, “Nam mabetik toha irkye ralake kralake ne, nam desike ne kiaraik a i ne. ");
INSERT INTO slu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kali nam atyat ribun lan ne kbyetik kyosy irkye ralake kralake, dendye rrekan ti ktela atyatare, ode rala ktela ayatare dakun, neke: ranamet, rtabahunw iry, wamfwetare ror wamwanire it de hyury a it koi-kay ma rala ktela atyatare, ");
INSERT INTO slu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rbilak lean sawatare ta lemamo laitare, radakin nam, rahatw, rulak de rtalik iry, rsoi ralat, lema rmay rhe de rala ktela atyatare ma ktyoha wait dakdyakinare ti sai ta sai bo, rahmway iry, rbitil tenatare ma atat ma ratun bakbak, ode usut a khatunare lan. ");
INSERT INTO slu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dendye mnyenas, ktela atyat desikre mumu ne kbyetik a kyosy irkye ralake kralake, mane kiaraik irkye ne.” ");
INSERT INTO slu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lemadendye Yesuske byetik toha wen desy, ma byai lasmyer Tiruske. Ode syukar ei sekye it, kali lema byuma irire rhe I, keskyede lema bisa ma ihunik a hye wasi mama ne, kali ribun a rhe I de. ");
INSERT INTO slu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Keskye enenke it ma anan wamfwetke ngkeskwakwe syukar a i, ma kyoat enen desike itomolu Yesuske ma ima bonyo, lema ikita de mya elik ma syakitil ti Yesuske wasi lulululw ne. ");
INSERT INTO slu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Enen desike iry a lema Yahudike, de yosy a lasmyer Fenisiake ti propinsi Siriake, neke ral tel Yunanike. Enen desike iten toha Yesuske ma yesak a ngkeskwakwe toha ananke. ");
INSERT INTO slu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lemade Yesuske ihliak tunke ma tyanuk ti enen desy ma byohe, “Oi ne lema Yahudi o, dendye kolnye kswaluk o a kmuna, nekekola ne kal namanare hinat kotw ma kotuk ti asure ra ma desy. De musti mo kal kotw ti namanare ma raknam a kmuna ma rbesur aduk, desyo kteranare nenmo bisa ma kotuk ti asure ma ra.” ");
INSERT INTO slu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Keskye enen desike hyalas ma byohe, “Ebo, mlay! Keskye asw nekre dakun o ra namanare hinat kotw ktera madi ei mejake hah ne.” ");
INSERT INTO slu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lemade Yesuske tyanuk huruk ti enen desy ma byohe, “Enen o, tun mutanuk desike mlay. Lemadendye mbwa, kali ngkeskwakwe byetik toha anamkwe de.” ");
INSERT INTO slu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kyoat a enen desike yulak i bai wasi sekye bonyo, yatos ananke o yenaf ma tyebti ti otke, kali ngkeskwakwe byetik toha i de. ");
INSERT INTO slu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lemade Yesuske byetik toha lasmyer Tiruske, neke yosy a nus Sidonke, ma lyakut yosy lasmyer Dekapoliske, ma byai Tasi Kakan Galileake. ");
INSERT INTO slu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ode ti desike dakun o, irire dum a ror irkye it ti Yesuske. Iry neke myolw ode nunuke ktem dakun. Ode raten toha Yesuske ma syaa sima ti iry desy. ");
INSERT INTO slu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lemade Yesuske yal iry desy, ma deruke soso sir toha iry ribun desikre, ma ti rmesan bo. Ode ryoka tanake ti iry desike moluke, maktei o iniw ti tanake ode yal tana desy ma yamas iry desike manke. ");
INSERT INTO slu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maktei o Yesuske yatnyarak ei laitke, ode myea o lema ktei, lemade yal tel Ibranike ma tyanuk de byohe, “Efata!” (Neke kbuanke o, “Kimlakat.”) ");
INSERT INTO slu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dendye iry desike eras i elik, ma tyomolu. Ode telake kbyetik dakun ma itun eras. ");
INSERT INTO slu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lemade Yesuske byu eta iry ribun mamin ti desy, ma kete rahes ktela iala nekre ti irkye it dakun. Ode biar ma Yesuske byu eta ma kete rahes, keskyede ktyabal ma iry desikre rahes ktela desikre ti kabei ta kabei bo. ");
INSERT INTO slu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ode iry maseak ode matomolu Yesuske nam iala desikre mumu ne, rheran a ksyalik, ode it de tyanuk ti it ma rbohe, “Yesuske nam iala nekre mumu ne eras, kali iry lema matomoluke desikeo tyomolu, ode iry a nunu ktemke desikeo itun eras elik.” ");
INSERT INTO slu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kyoat desy dakun o irire ribun sir a ksyalik, ma rawahuk sir a ror Yesuske. Keskye lema kika kotw ma ra, lemade Yesuske yabuk wasi matoha Iare ma tyanuk ti sir de byohe, ");
INSERT INTO slu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Klwobak iry ribun lan ne a ksyalik, kali sekwe enatelw neke ror Yaw de, ode lema kika kotw ma ra, kali hinat koture ktei de. ");
INSERT INTO slu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ode kolnye kaso sir ma rulak sir bai wait seire, desikeo ana kete rlakut nini dum a rlily ti sal a krala kali ramlar. Kali iry nekre dakun o dum a rosy a wen sosoare ma rma.” ");
INSERT INTO slu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lemade Yesuske wasi matoha Iare rhalas I ma rbohe, “Tala kolkyabei, ma tatot kotw ti wen soso kele ratelin ne, ma bisa ma tal ti iry nekre mumu ma ra de?” ");
INSERT INTO slu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Lemade Yesuske yena sir ma byohe, “Hinamy a rotkye enai desy de?” Desikeo rhalas I ma rbohe, “Rotkye itw bo.” ");
INSERT INTO slu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Lemadendye Yesuske yaso ma iry ribun desikre rtaklulw ti lasmyerke khahake. Ode yal roty deitw desy, ode yatnyarak ei laitke ma syalak eraske ba ti Hulasokwe ti khyali roty desy. Maktei o byini-byiny a roty desikre, ode yal ti wasi matoha Iare ma rasakar ti iry ribun lan desy. ");
INSERT INTO slu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ode iry desikre hinat masy kakan ne enai ne dakun. Lemade Yesuske yal masy desikre, ode yatnyarak ei laitke ma syalak eraske ba ti Hulasokwe ti khyali masy desikre. Maktei o yal ti wasi matoha Iare ma rasakar ti iry ribun lan desy. ");
INSERT INTO slu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma iry ribun desikre raknam nini rbesur. Lemade Yesuske wasi matoha Iare rili rahuk roty o masy ktera desikre, desikeo kbyenw a kolakye itw. ");
INSERT INTO slu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iry a maknam desikre aryaritke anakyai irkye ribunke enaat sir. Dendye Yesuske yaso iry desikre ma rulak sir bai wenatare. ");
INSERT INTO slu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ode iry desikre raba bonyo, Yesuske yor wasi matoha Iare rsai aroke, ma rbity lar ti ma rbai lasmyer Dalmanutake. ");
INSERT INTO slu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kyoat iry manosy lui Farisike dum a ratomolu Yesuske ma imai wen desy bonyo, rma ma rait Yesuske ma rataur nunw ror I. Ode rhury a I ma yala nyatos masalsyalik ike it ma ratos, ma klyosu ohe I neke Hulasokwe Anan a I. ");
INSERT INTO slu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kyoat Yesuske itomolu ma ratanuk koldyesy bonyo, ralake kralake lema eras, dendye tyanuk ma byohe, “Kyanmwane taras neke raten ma kala nyatos masalsyalik ike it, desikeo nenmo ratohak Yaw ne de? Klwosu ti e ohe, mlay bain o ti taras ne ana lema kala nyatos masalsyalik ike it elik.” ");
INSERT INTO slu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Lemade Yesuske yor wasi matoha Iare rtutuk iry desikre ti desy, ode rsai aroke ma rbai tasi kakanke seridake. ");
INSERT INTO slu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ode kyoat Yesuske yor wasi matoha Iare rbity lar ma raba bonyo, wasi matoha Iare ramluak ma rety res, de cuma mo rety rotkye sasasam bo. ");
INSERT INTO slu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lemade Yesuske tyanuk ti sir de byohe, “Mijaga mamak e toha raja Herodes yor iry a Farisi-nare hinat ragike.” ");
INSERT INTO slu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lemade Yesuske wasi matoha Iare rrekan tun Yesuske itanuk desikre, dendye it de tyanuk ti it ma rbohe, “Yesuske tyanuk koldyesy, kali tamluak ma lema tety roty ma kyoat.” ");
INSERT INTO slu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ode Yesuske hye nam ratanukare, lemade tyanuk ti sir ma byohe, “Kyanmwane mitanuk ti ktela lema kika roty ne de? Lema ktwanuk ti ktela kotw o abw ne! Ei neke lenla mhye Yaw e? Ode kyanmwane ralami kralanare ngkora kola hatkwe a nggora ne de? ");
INSERT INTO slu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ei neke mika matamy, keskyede kyanmwane lema mimatakit ne de? Ode ei neke mika molumy, keskyede kyanmwane lema mitomolu ne de? Ode kyanmwane lema minenas namke it elik ne de? ");
INSERT INTO slu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dendye kena e ohe, kyoat kubiny rotkye enasim ti irkye ribunke enasim ma rana desike, kterake miwahuk mumu o kolakye enai kbyenw de?” Desikeo wasi matoha Iare rhalas I ma rbohe, “Kolakye hean a kresi enaru ne kbyenw.” ");
INSERT INTO slu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Maktei o Yesuske yena sir huruk de byohe, “Ode kyoat kubiny rotkye itw ti irkye ribunke enaat rana desike, kterake miwahuk mumu neke kolakye enai kbyenw de?” Desikeo wasi matoha Iare rhalas I ma rbohe, “Kolakye itw kbyenw.” ");
INSERT INTO slu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lemade Yesuske tyanuk ti sir de byohe, “Koldyesikemo kyanmwane mimtaut ohe, krwekan ti ktela lema kika roty ne de? Lema koldyesy. De musti mo mhye nam nekre mumu ne kbuanare.” ");
INSERT INTO slu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kyoat Yesuske yor wasi matoha Iare ranait hnu Betsaidake, desikeo irire ror iry matmabolke it ti Yesuske, ode ral ralat a kusunare bain-bain ma raten ma syaa sima ti iry desy ma bisa ma myatakit. ");
INSERT INTO slu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Lemade Yesuske kyumak iry matmabol desy simake, ode yeuk i ma rbai hnu desike kserike. Ode Yesuske iniw ti simake ma kyasa ti iry matmabol desike matake, ode syaa sima ti iry desy, maktei o yena i ma byohe, “Mmwatakit nam dum deny e?” ");
INSERT INTO slu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Desike bonyo iry desike yatos ei lulkwe ode tyanuk ma byohe, “Ou, katos irire, kali katos ma rlakut ti de rlakut ma, keskyede rola ne aw mamdiry nekre ti kilakut ne.” ");
INSERT INTO slu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lemadendye Yesuske syaa sima ti iry desike matake huruk, ma iry desike matake kdyelaf ma myatakit eras de, ma yatos nam ribun nekre mumu. ");
INSERT INTO slu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lemade Yesuske yaso iry desy ma yulak i bai wasi sekye, ode tyanuk ti i de byohe, “Mbwa, keskye kete mosy hnuke kditlanke!” ");
INSERT INTO slu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kyoat Yesuske yor wasi matoha Iare rbai hnu mamin ti Kaisarea Filipike, desikeo ti salke kralake Yesuske yena wasi matoha Iare ma byohe, “Ktyoha irire mo esei ne Yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lemadendye wasi matoha Iare rhalas I ma rbohe, “Irire dum a rbohe, Oi neke Yohanes Mababtiske. Ode iry dum a rbohe, Oi neke Elia O. Ode iry dum a rtanuk huruk ma rbohe, Oi neke iry a heitlulswo manety Hulasokwe wasi nyanoke it ne, ma myorif huruk mane.” ");
INSERT INTO slu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lemade Yesuske yena sir huruk ma byohe, “De ktyoha e mo, esei ne Yaw ne de?” Lemade Petrus hyalas ma byohe, “Oi neke Mesias O!” ");
INSERT INTO slu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Lemadendye Yesuske byu eta malkyakaw wasi matoha Iare, ma kete rahes ti esei ta esei dakun ohe, Yesus neke Mesias I. ");
INSERT INTO slu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lemadendye kyala kyosy sew desy, desikeo Yesuske nenmo lyosu ti wasi matoha Iare ma yajar sir de byohe, “Irkye Anankemusti mo ana hyar masunkwe ribun. Ode iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe, neke wait usu khatunare, ror a iry mahe snurat o tnyetak Musake dakun, sir neke lema rou I. Ode irire musti mo rtabahunw I. Keskye ana sekwe enatelw bonyo, myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ode kyoat Yesuske syisy hela nam ribun lan ne ti wasi matoha Iare bonyo, Petrus kyumak Yesuske simake ma byity a I ma rei kserike, ode tyerik I ma kete ihes ba de. ");
INSERT INTO slu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Keskye Yesuske yulak I ma syara wasi matoha Iare, ode tyerik Petrus ma byohe, “Ngkeskwaw o, maditi lakhidik o toha ne! Kali oi neke lema mrwekan nam Hulasokwe irekanke, de mrwekan nam irkye irekanke kmyesan bo.” ");
INSERT INTO slu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dendye Yesuske yabuk iry ribun desikre mumu rtabal wasi matoha Iare ode tyanuk ti sir ma byohe, “Kolnye esei desike byuma tyoha Yaw, musti mo ibu a ituli tenanke ti sai ta sai bo, ode hyar wasi tul masanwalw ike,ma tyoha Yaw. ");
INSERT INTO slu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kali esei desike byuma kyumak eta wasi mormyorifke ti lasmyerke khaha ne, desikemo mormyorhyanke ti wen sra eraske ana kitayar. Keskye esei desike yotuk wasi mormyorifke ba, khyali Brit Eraske ma tyoha Yaw, ode ires ma myaty khyali Yaw, desikemo ana myorif ti wen sra eraske nini nam. ");
INSERT INTO slu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mtyomolu! Kolnye esei desike wasi malolkye lan, ma ti kyal nuske ktem ne mumu, keskye kolnye myaty ma lema byai wen sra eraske, de Hulasokwe yotuk i bai mamaty rala, desikemo wasi maloly desikre mumu ne kbuan sai ti i de? ");
INSERT INTO slu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Lema kika kbuan! Kali lema bisa ma ral nam dum ma reluk mormyorif manal nini namke. ");
INSERT INTO slu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ode kolnye esei desike myay ma you daku iry ribun mahatw lema matohak I ti selsel ne, ohe hye Irkye Ananke, ta myay ma you ohe hye tun a Irkye Ananke itanukare, desikemo Irkye Ananke ana lema you ma hye iry desy dakun, ti kyoat ima huruk ne. Ode kyoat Irkye Ananke ima huruk ne, ana myaa yor madelafke, ode malkyakaw manosy Ama Hulasokwe, ktyabal Hulasokwe wasi nyaso nelnyelire ma rosy laitke.” ");
INSERT INTO slu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lemade Yesuske tyanuk huruk ti sir ma byohe, “Mtyomolu mamak nam kutanuk ne. Mlay bain! Ti iry mamin ti neke, ei ne mumu ne dum a ana lenla mmyaty, kolnye lenla mmyatakit ohe, Hulasokwe mya ma hyareta kola Rajake ne, neke kmyaa kyor wasi haretke.” ");
INSERT INTO slu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ode sekwe nem a kyelak eta bonyo, Yesuske yabuk Petrus, Yakobus, ode Yohanes ma ror I ma raktem a rsaik bai huar atat ne it, ma rmesan ti desy bo. Ode iry detelw desike ratos mo, Yesuske uno mata o tenanke ktem ne kihihi i, ");
INSERT INTO slu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ode wasi rabitke bokbok ma knyely malay dakun. Ti nuske ktem ne, lema irkye it a bisa ma hyas wasi rabitke nini bokbok ma knyely malay kola Yesuske wasi rabit desy dakun. ");
INSERT INTO slu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ode kyala mait bonyo, Yesuske wasi matoha I detelw desy ratos mo Elia yor Musa ramdiry ma ratun a ror Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lemade Petrus a tyanuk ti Yesuske de byohe, “Tuanggurw, eras a ksyalik ti aramy mimin ti wen ne. Lemamo aramy msyadiri lasyerkye enatelw, ma sasam ti O, sasam ti Musa, ode sasam ti Elia dakun.” ");
INSERT INTO slu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus tyanuk koldyesy, kali lema hye o musti mo tyanuk sai, kali yor lian deru desy ramtaut ma ksyeman sir a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ode oanke khatuke kmya ma kkyahat eta raktemtem. Ode kyoat ramin ti oanke krala desy, desikeo rtomolu telke it ma kyosy oanke krala desy ma ktyanuk de kbyohe, “Anakkwe I ne, ma klwobak I a ksyalik. Mtyomolu I!” ");
INSERT INTO slu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ode kyala mait bonyo Petrus yor lian deru desy ratos ti de ratos ma o lema kika iry, de lenla Yesuske myesan bo. ");
INSERT INTO slu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ode kyoat raorw toha huar desy bonyo, Yesuske syurat sir de byohe, “Kete mihes ktela miatos desy ti irkye it dakun, de mikita nini sekwe kdi ti, neke Irkye Anankemyorif toha mamatire, desikeo nenmo bisa ma mihes ktela desy.” ");
INSERT INTO slu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dendye lema rahes ktela desy ti irkye it dakun, keskyede detelkwe it de yena it ma rbohe, “Yesuske tun itanuk ma kibohe, ana myorif toha mamatire, neke kbuan sai de?” ");
INSERT INTO slu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lemade Yesuske wasi matoha I detelw desy rena I ma rbohe, “Tuanggurw, kyanmwane iry mahe snurat o tnyetak Musake rtanuk ohe, musti mo Elia imaa kmuna Mesiaske ne de?” ");
INSERT INTO slu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dendye Yesuske hyalas sir ma byohe, “Mlay bain! Elia iry a manety Hulasokwe wasi nyano ne, ana myaa kmuna ma tyanuk ti iry ribunke ma rsosan ralatare, ma rakita Irkye Ananke. Keskyede ktyoha e mo, kyanmwane nam rakesy ti Kitab Lanke ti kihali Irkye Ananke ohe, ana irire rahmway I, ode roban de rtaba I, ode ana masunw ribunke kidan I dakun ne de? ");
INSERT INTO slu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Keskyede klwosu ti e ohe, Elia neke mya bain de.Keskye irire rala i ma ktyoha rabuare, neke roban de rtaba i, ma kyal nini rtabahunw a i dakun, ma kola ne rakesy ti Kitab Lanke ne.” ");
INSERT INTO slu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kyoat Yesuske yor Petrus, Yakobus, ode Yohanes rulak sir ma rait Yesuske wasi matoha idanare bonyo, ratos o iry ribunke rkoal sir, ma malmata ror iry mahe snurat o tnyetak Musake de rahalas tel. ");
INSERT INTO slu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kyoat iry ribun desikre ratos Yesuske bonyo rheran a ksyalik, lemade raktemtem a ra-la ti rbalan Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lemade Yesuske yena wasi matoha Iare ma byohe, “Nam sai ne kihury ma it de ihalas it ne de?” ");
INSERT INTO slu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dendye ti iry a ribun desikre, neke irkye it a tyanuk ti Yesuske ma byohe, “Tuanggurw! Kor anakkwe mai wen ne ma kuten ma msweak i, kali ngkeskwakwe syukar i ma yala i ma nunuke ktem. ");
INSERT INTO slu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma seure rait mo ngkeskwakwe syukar a i, ode byesak i ti lasmyerke, ode ryeti tenanke, ode ikernisy nini uhuhare kbyetik kyosy a nurno haha. Mane kuten toha wasimw matoha Oare de, ma resak a ngkeskwaw desy, keskyede lema resak ral i.” ");
INSERT INTO slu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Hei, iry a lema matohak e! Musti mo ana kor e nini kolkya? Ode ana kukita nini hekyab o mtyohak Yaw de?” Lemade Yesuske tyanuk ti naman desike ama ma byohe, “Mor anamw desy ma.” ");
INSERT INTO slu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dendye ror naman desy ti Yesuske. Keskyede kyoat ngkeskwaw desike iatos Yesuske bonyo, byesak naman desy elik ti lasmyerke, ode yayak i ti de yayak i ma, ma uhuhare kbyetik kyosy nurno haha. ");
INSERT INTO slu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Lemade Yesuske yena naman desike ama de byohe, “Wasi kbai ne kyal ainke enai mane de?” Desyo naman desike ama-na hyalas Yesuske ma byohe, “Kyala kyosy a kakan ike de. ");
INSERT INTO slu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ode seure rait mo ngkeskwakwe yala i ma yei akye kralake, dete lemamo tyunik i ei werke kralake, kali yobak ma tyabahunw a i. Lemade Ebo! Mlwobak aramy, ode mswaluk aramy, kolnye bisa ma mala mal ngkeskwaw ne ma byetik toha anakkwe!” ");
INSERT INTO slu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Lemade Yesuske tyanuk ma byohe, “Kyanmwane mtwanuk ma Yaw ohe, kolnye bisa ma kala kal ktela desy ne de? Dendye klwosu ti o ohe, Hulasokwe bisa ma yala sai ta sai ti o bo, kolnye mtwohak ti I.” ");
INSERT INTO slu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ode kyoat naman desike ama-na itomolu nam Yesuske itanukke bonyo, yeik ma byohe, “Tuanggurw! Yaw neke ktwohak ti Hulasokwe. Lemade mswaluk yaw ma malkyaw wasikw tohtohakke!” ");
INSERT INTO slu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kyoat Yesuske yatos iry ribunke ma rma ma rkoal I bonyo, Yesuske yaswel ngkeskwaw desy ma byohe, “Hei ngkeskwaw a maala naman ne ma imolw ode nunuke ktem dakun ne, mbwetik toha naman ne! Ode kete mulak o de!” ");
INSERT INTO slu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dendye ngkeskwaw desike byoran, ode byesak naman desy o ksunw ksyalik, maktei bonyo byetik toha naman desy. Kyoat ngkeskwaw desy ibetik toha naman desy, desikeo naman desike kola dene imaty ne, ma khyury ma iry ribunke rtanuk ma rbohe, “Naman ne myaty de.” ");
INSERT INTO slu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Keskyede Yesuske kyumak naman desike simake, ode syaluk i ma byatar, dendye naman desike byatar ma imdiry. ");
INSERT INTO slu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kyoat Yesuske yor wasi matoha Iare rmesan ti sekye it a krala, desikeo wasi matoha Iare rena I de rbohe, “Kyanmwane lema bisa ma aramy myesak ngkeskwaw desike ne de?” ");
INSERT INTO slu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lemade Yesuske hyalas sir ma byohe, “Ngkeskwaw maoly desike lema bisa ma myesak i a kyor ktela salik, de musti mo myesak i a kyor sambayanke bo.” ");
INSERT INTO slu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kyoat Yesuske yor wasi matoha Iare rbetik toha wen desy, desikeo rsaur wait laklakutke ma rlakut a rlola propinsi Galileake. Keskyede Yesuske lema you ma irire rhe ohe imin ti kabei, ");
INSERT INTO slu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kali malmata yajar wasi matoha Iare. Ode Yesuske tyanuk ti wasi matoha Iare ma byohe, “Irkye Ananke ana ral I ba ti irire ma rhareta I, ode ana rtabahunw a I, keskye sekwe enatelw bonyo ana myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Keskyede Yesuske wasi matoha Iare lema rhe tun itanuk desikre kbuanare. Ode lema rares ma rena tun desikre kbuanare toha Yesuske dakun. ");
INSERT INTO slu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ode Yesuske yor wasi matoha Iare rait hnu Kapernaumke, ode kyoat rsukar ei sekye it bonyo, Yesuske yena wasi matoha Iare ma byohe, “Nam sai ne kihury ma dai mieta tel ti salke kralake ne de?” ");
INSERT INTO slu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Keskyede wasi matoha Iare lema ratun, de mamwaw sir bo, kali rhe ohe dai raeta tel ti salke kralake, khyali robak ma rhe ohe, ese lan a i ti sir ne mumu. ");
INSERT INTO slu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Lemade Yesuske tyaklulw, ode yabuk wasi matoha I dehean a kresi enaru desy, ode tyanuk ti sir ma byohe, “Kolnye esei desike byuma lan a i, musti mo nyauk tenanke ma babaf, ma yola iry makarya ne ma syaluk irire mumu.” ");
INSERT INTO slu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lemade Yesuske kyumak naman kakan ne it simake, ode yaso i ma imdiry ti kditlalan ne. Maktei o hyot naman desy, ode tyanuk ti wasi matoha Iare ma byohe, ");
INSERT INTO slu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Esei desike you ma yal naman kakan ne khyali Yaw, desikemo kola ne you ma yal Yaw dakun. Ode esei desike you ma yal Yaw, desikemo kola ne you ma yal Hulasow a maaso Yaw ne dakun.” ");
INSERT INTO slu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dendye Yohanes a tyanuk ti Yesuske ma byohe, “Tuanggurw, aramy myatos irkye it ma yal a Animkwe, ma yesak ngkeskwakwe. Lemade aramy mbyu eta iry desy, kali lema yor lui ity.” ");
INSERT INTO slu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Keskyede Yesuske tyanuk ti sir ma byohe, “Kete mbyu eta i, kali iry manal Anikkwe ma yala ktela masalsyalik iare, iry desike ana lema ihmwai Yaw dakun. ");
INSERT INTO slu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ode esei desike lema syorw a ity, i desike yor lui ity.” ");
INSERT INTO slu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lemadendye Yesuske tyanuk ti sir huruk ma byohe, “Mlay bain, esei desike yal werke ti takwe, ma yal ti e ma myenw kali mtyoha Yaw, i desike ana yal ksewanke toha Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ode esei desike hyury a iry a wasi tohtohakke lenla malkyakaw ti itohak ma Yaw ne, ma khyury ma iry desike yala lim o sal, desikemo iry mahury desike, Hulasokwe ana yukun i o ksunw ksyalik, ma kbyilak ti kolnye raikat hatw lan ne ti telake, ode raotuk i ei tasike kralake ne. ");
INSERT INTO slu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ode kolnye simamkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mal turike ma mtwusy ohut simamw desy ba! Kali lemamo mmworif ti wen sra eraske nini nam a mor simamkwe serit. Desike ne eras ma kbyilak ti kolnye mbwuma mmworif mor simamw deru desy, keskyede ana rotuk o bai mamaty rala.  ");
INSERT INTO slu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Neke ti wen desike akye klyehur ti nini nam, ode ulare ana lema rmaty. ");
INSERT INTO slu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ode kolnye lwaumkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mal turike ma mtwusy ohut lwaumw desy ba! Kali lemamo mmworif ti wen sra eraske nini nam a mor lwaumkwe serit. Desike ne eras ma kbyilak ti kolnye mbwuma mmworif mor lwaumw deru desy, keskyede ana rotuk o bai mamaty rala.  ");
INSERT INTO slu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Neke ti wen desike akye klyehur ti nini nam, ode ulare ana lema rmaty. ");
INSERT INTO slu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ode kolnye matamkwe serit a khyury a o ma mdwi ei lim o sal, desikemo mhwakilw matamkwe khatu desy ba! Kali lemamo mmworif ti wen a Hulasokwe ihareta tike mor matamkwe serit. Desike ne eras ma kbyilak ti kolnye mmworif mor matamw deru desy, keskyede ana rotuk o bai mamaty rala. ");
INSERT INTO slu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kali ti mamaty rala neke ay mamin ti desike lema bisa ma kmyaty, ode ul mana mamatire ne lema bisa ma rmaty dakun. ");
INSERT INTO slu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dendye mnyenas, irkye yal taisiskye ti healke kisike ma kyala healke kisi desike ma nelnyely. Koldyesy dakun o Hulasokwe yal masunkwe ma ity kola ne akye kina ity ne, ma ana masunw desikre kyajar ity ma ana nelnyely a ity dakun.” ");
INSERT INTO slu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lemade Yesuske tyanuk ma byohe, “Taisiskye eras, keskyede kolnye taisisy ne malmyaly, desyo ana ral sai ma rala taisisy malmyaly desy ma mkes huruk de? Lemadendye ei neke musti mo myola taisiskye ti mimorif ne, ma mimorif neke mo it de ika eras yor it.” ");
INSERT INTO slu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kyoat Yesuske byetik a yosy hnu Kapernaumke, ma byai propinsi Yudeake o sah Yordanke kseri timurke. Ti desy dakun o iry ribunke rma ma rkoal I. Ode Yesuske wasi ktelake de, ma kolnye irire ribun sir koldyesy, desikeo yajar a sir. ");
INSERT INTO slu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dendye iry manosy lui Farisi-nare dum a rma ma robak a ksala ma roit salke ti Yesuske, desikeo rena I de rbohe, “Mlay bain o ktyoha ity wait ktela kubkubakke mo bisa ma wamwanire rbisak sawatare ba e?” ");
INSERT INTO slu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dendye Yesuske hyalas sir ma byohe, “Haret Musake khyareta e kolkyabei ti ktela mitanuk desy de?” ");
INSERT INTO slu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lemade iry desikre rhalas I ma rbohe, “Musa lyura ma it de ibrai it, keskye musti mo wamwankye kyesy atyahy a it de ibrai it ne aduk, ma yal ti wamfwet ibrai desy.” ");
INSERT INTO slu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dendye Yesuske tyanuk ti sir huruk ma byohe, “Kali khyali usumy khatu lanare, lemadendye Musa kyesy haret desy ti e ma desy. ");
INSERT INTO slu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Keskyede kyoat Hulasokwe yala nuske ktem ne, desikeo yala irkye dakun, neke wamwankye ode wamfwetke. ");
INSERT INTO slu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Lemadendye kyoat wamwankye it a isa, desikeo ana tyutuk ena o ama, ma ti yait sawa, ");
INSERT INTO slu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma deruke rawahuk sir ti nam sasamke, ma lema enaru sir de, de sasasam sir bo. ");
INSERT INTO slu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kali koldyesike mane, nam sai desy Hulasokwe yeti yahuk ti sasam de, desikemo irkye lema bisa ma isali de.” ");
INSERT INTO slu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kyoat Yesuske yor wasi matoha Iare rasukar ei sekye kralake bonyo, rena I ti ktela it de ibrai it ne. ");
INSERT INTO slu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dendye Yesuske tyanuk ti sir ma byohe, “Esei desike ibrai sawa, ode isaa yor wamfwet salik, desikeo iry desike yaldotw, kali byilak lean sawa. ");
INSERT INTO slu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Koldyesy dakun ti wamfwetke, ma kolnye ibrai lai ode isaa yor wamwany salik, desikeo wamfwet desike yaldotw, kali byilak lean lai.” ");
INSERT INTO slu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lemadendye irire ror anat kakanare ti Yesuske, ma syaa sima ti sir, keskyede kyoat wasi matoha Iare ratos a ktela desy bonyo, rkeyer a iry desikre. ");
INSERT INTO slu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kyoat Yesuske iatos ktela desy bonyo, kyeyer a wasi matoha Iare ode tyanuk de byohe, “Mlyura naman kakan desikre ma rma ma rait Yaw, de kete mbya etno eta sir. Kali iry maola naman kakan desikre, ana wenatke ne wen Hulasokwe ihareta kola Rajake tike. ");
INSERT INTO slu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dendye mtyomolu mamak nam kutanuk ne. Mlay bain! Esei desike lema tyohak Hulasokwe kola naman kakanke, i desike ana lema syukar ei wen Hulasokwe ihareta kola Rajake tike.” ");
INSERT INTO slu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lemade Yesuske hyot naman kakan desikre ratsam-ratsam, ode syaa sima ti sir ma yal eraske ti sir. ");
INSERT INTO slu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kyoat Yesuske syaur wasi laklakutke bai lulkwe, desike bonyo wamwankye it a ila bya ti syakitil ti Yesuske wasi lulululw ne ma byohe, “Tuanggurw eras o, kala kolkyabei ma musti mo ana kmworif nini nam de?” ");
INSERT INTO slu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dendye Yesuske tyanuk ti iry desy ma byohe, “Kyanmwane mubohe eras Yaw ne de? Lema irkye it a eras i, de lenla Hulasokwe myesan eras I bo. ");
INSERT INTO slu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oi neke mhwe nam a Hulasokwe itetakare de, neke kete taldotw, kete ttabahunw iry, kete tanamet, kete takakmet ma toit salke ti iry salik, kete takakmet a irire ma tal wait namit-namit, ode musti mo talan a ity enat o ity amat.” ");
INSERT INTO slu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lemade iry desike hyalas Yesuske ma byohe, “Tuanggurw, nam mutanuk nekre ktwoha mumu kyala kyosy kakan a yakwe de.” ");
INSERT INTO slu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Keskyede Yesuske yatos i ode lyobak i dendye tyanuk ti i ma byohe, “Ktelake sasam neke lenla mtwoha, neke mulak a o, ode mkweta wasimw maloly desikre mumu, ode muhe ti iry a lema manait ei sra o hahare. Koldyesikemo oi neke ana Hulasokwe yal malolkye ti o ti wen sra eras Hulasokwe imin tike. Muala koldyesy maktei desikeo nenmo mmwa ma mtwoha Yaw.” ");
INSERT INTO slu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kyoat iry desike itomolu tun Yesuske itanuk desikre bonyo, ralake ksyal ti nam itomolu desy, kali iry desike wasi malolkye lan. Dendye yulak i ma byai waitke. ");
INSERT INTO slu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lemade Yesuske yatos wasi matoha Iare ode tyanuk ti sir ma byohe, “Iry a maaka malolkye ana ksunw ma syukar ei wen Hulasokwe ihareta kola Rajake tike.” ");
INSERT INTO slu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kyoat Yesuske itanuk koldyesy bonyo, wasi matoha Iare rheran ti ratomolu tun Yesuske itanuk desy. Keskyede Yesuske syaur tunake huruk ma byohe, “Anakw e, iry a maaka malolkye ksunw ma syukar ei wen Hulasokwe ihareta kola Rajake tike. ");
INSERT INTO slu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lemade ktwanuk ti e ohe, kalkal ti a untake syukar ei balbyalkye kuranke, keskye ksunw ksyalik ti iry maaka malolkye syukar ei wen Hulasokwe ihareta kola Rajake tike.” ");
INSERT INTO slu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kyoat a Yesuske wasi matoha Iare ratomolu tun itanuk desikre bonyo, ktyabal ma rheran huruk, ode it de yena it ma rbohe, “Mane iry maaka malolkye ksunw ksyalik ma syukar ei wen sra eraske, desikemo esei ne ana Hulasokwe iaorif i ma isukar ei wen sra eraske ne de?” ");
INSERT INTO slu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dendye Yesuske yulak matake ma yatos sir, ode tyanuk ti sir ma byohe, “Hulasokwe yala hye nam a irkye lema iala hyeke. Kali Hulasokwe yala yal ma yala nam nekre mumu.” ");
INSERT INTO slu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lemadendye Petrus tyanuk ti Yesuske ma byohe, “Tuanggurw, aramy neke mtyutuk ara wasimy nam ribun nekre mumu de, ma aramy mtyoha O.” ");
INSERT INTO slu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Lemade Yesuske hyalas sir ma byohe, “Mtyomolu mamak nam kutanuk ne. Mlay bain! Ti esei ta esei bo, ma tyutuk bain-bain wasi sekye, wainare, ena o ama, ananare, ode wasi boluhu-boel, kali tyoha Yaw, ode kali bya ti yabrita Brit Eraske, ");
INSERT INTO slu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","desikeo iry desike, ti wasi mormyorif selsel ne, ana Hulasokwe yal sey o, wai o, ena o, ama o, anan o, boluhu-boel nekre ti i, desikeo karyarike atw kbyilak ti nam itutuk desikre. Ode biar ma roban de rtaba i dakun, keskyede ti taras ana mama ne, desikeo ana myorif nini nam ti wen sra eraske. ");
INSERT INTO slu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Keskyede iry maaka malolire, ode iry a raalan sir ne, ana ribun a rosy lyakwe. Klala iry a lema manait ei sra o hah nekre, ode iry a lema raalan sir nekre, ana rmuna.” ");
INSERT INTO slu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kyoat Yesuske yor wasi matoha Iare rlakut bai Yerusalem, desikeo Yesuske lyakut a kmuna. Dendye wasi matoha Iare kola ne rheran. Ode iry matoha sirare ramtaut. Lemadendye Yesuske yabuk wasi matoha Iare, ode tyanuk nam ana madi ti tenanke ne ti sir ");
INSERT INTO slu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ma byohe, “Mtyomolu! Tala ma tbai Yerusalem mane. Ma ana ti soke Irkye Anankeral I ba ti iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry mahe snurat o tnyetak Musake, ma rtunik tnyetak matmyatkye ti I. Maktei o ral I ti bangsa lema mahe Hulasokwe ne. ");
INSERT INTO slu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ode iry desikre ramahis a I, rahmway I, rasburik a I, roban de rtaba I, maktei o rbakw a I ti tul masanwalw ike ma myaty. Keskyede ana sekwe enatelw bonyo myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kyoat Yesuske itun maktei bonyo, Yakobus yor Yohanes, neke Zebedeus ananare, rba ti rney a Yesuske, ode rtanuk ti I ma rbohe, “Tuanggurw, aramy miten ma mala ktelake sasam ma aramy.” ");
INSERT INTO slu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dendye Yesuske yena sir ma byohe, “Nam sai ne mibuma kuala ti e ne de?” ");
INSERT INTO slu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lemade deruke rhalas Yesuske ma rbohe, “Aramy mbyuma aramy miru neke, it a tyaklulw ti serimw wisalke, ode it a tyaklulw ti serimw wanke, ma aramy myor a O ma thareta, kolnye kyait ma muka Raja ode mtwaklulw ti wasimw kader madelafke ma mhwareta ti.” ");
INSERT INTO slu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Keskyede Yesuske tyanuk ti sir ma byohe, “Ei neke lema mhye nam mitenke. De mryekan o ei ne bisa ma mhyar masunw a mdedanke, kola masunw a mdedan ana madan a Yaw ne e?” ");
INSERT INTO slu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lemade deruke rhalas I ma rbohe, “Bisa.” Dendye Yesuske tyanuk ti deruke ma byohe, “Mlay bain! Miru neke ana masunkwe kdyan e kola ne ana masunkwe kidan Yaw ne. Ode ana rbabtis e a ror babtis a ranal ma rababtis a Yaw ne dakun. ");
INSERT INTO slu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Keskyede lema wasikw haretke ma kswusu ohe, ana ese tyaklulw ti serikw wisalke, ode ana ese tyaklulw ti serikw wanke. Kali haret desike kimin a Amaku myesan bo, ma ana syusu wen desikre ti wasi iry a iilikare de.” ");
INSERT INTO slu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ode kyoat Yesuske wasi matoha I dehean desike ratomolu tun Yakobus yor Yohanes ratanuk desy bonyo, rkeyer a deruke a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dendye Yesuske yabuk raktemtem, ode tyanuk ti sir ma byohe, “Mhye ohe iry a lema Yahudi-nare wait iry lan nekre, ror iry a maka kmata lan nekre, sir ne rahareta wait masyarakatke o ksunw ksyalik ne. ");
INSERT INTO slu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Keskyede ti ei neke kete myala koldyesy. De kolnye esei desy byuma lan a i, musti mo nyauk tenanke ma babaf ma yola makarya ne bo. ");
INSERT INTO slu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ode esei desike byuma lan i ma byilak iry salik, desikeo musti mo i desike ika at ti e mumu. ");
INSERT INTO slu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kola Irkye Ananke ti imai nuske ktem ne, lema byuma irkye kyarya ti I, de mya ma kyarya ma syaluk irkye bo. Ode yal tenanke ma myaty ma lyitan eta iry ribunke.” ");
INSERT INTO slu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kyoat desy dakun o Yesuske yor wasi matoha Iare rait Yerikho. Maktei o ti kyoat rabetik toha Yerikho bonyo, iry ribunke lui-lui sir ma rtoha Yesuske. Desikeo iry maten namke it, ma matake kbyol, ode tyaklulw ti salke kserike ma iten nam. Iry neke ani Bartimeus, neke Timeus ananke. ");
INSERT INTO slu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ode itomolu Yesus iry Nazaret ne ma ilakut yosy wen desy bonyo, iry desike yatela ma byohe, “Yesus! Daud Anan O! Mlwobak a yaw!” ");
INSERT INTO slu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lemade iry desikre rterik malkyakaw iry matmabol desy, ma rbu ti i ma mamwaw i. Keskyede matmabol desike telake lan ma yatela huruk ma byohe, “Yesus, raja Daud tesnwo natu O, mlwobak a yaw!” ");
INSERT INTO slu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lemade Yesuske imres, ode yaso ma rabuk iry matmabol desy. Dendye iry desikre rtanuk ti iry a matmabol desy ma rbohe, “Mumdiry, ode malkyau ralamkwe, kali Yesuske yabuk a o!” ");
INSERT INTO slu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lemadendye iry a matmabol desike yonuk wasi rabit narnarkwe, ode lyahlaha mirin ma imdiry ma bya ti yait Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dendye Yesuske yena i de byohe, “Nam sai ne muten ma kuala ti o ne de?” Desike bonyo iry desy hyalas ma byohe, “Tuanggurw, kbwuma kmwatakit.” ");
INSERT INTO slu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lemade Yesuske tyanuk ti i ma byohe, “Oo, mmwatakit ande! Kali mtwohak ma Yaw de. Dendye mbwa.” Kyala mait bonyo, iry desike myatakit elik! Dendye tyoha Yesuske ma rba. ");
INSERT INTO slu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kyoat desike Yesuske yor wasi matoha Iare rarasik nus Yerusalemke de. Keskyede lenla rait Yerusalem, desikeo musti mo ana rait a hnuke enaru a kmuna. Hnu deru ne hnu Betfageke ode hnu Betaniake, neke kimin ti kususwan Zaitunke, ma knyey a nus Yerusalemke dakun. Dendye rala ma ranait hnu deru desy bonyo, Yesuske yabuk wasi matoha Ike irkye enaru ma yaso sir, ");
INSERT INTO slu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ode tyanuk ti sir de byohe, “Mbyai hnu mamin ti lulw ne. Ode ana misukar ei hnuke krala desy, desikeo myait elik keledai mur ne it ma rikat i ti desy, neke irire lenla rsai i elik. Lemade myaka tasy a ranal ma raikat keledai desy, ode myor i mai ne. ");
INSERT INTO slu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ode kolnye irkye it a tyanuk ti e de byohe, ‘Kyanmwane miala koldyesy ne de?’ Desikeo mhyalas i ma mbyohe, ‘Ity Ebutke byuma pyake keledai ne aduk. Maktei o, nenmo yaso ma rety de rolik i ei wenake huruk.’” ");
INSERT INTO slu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lemadendye iry deru desike rba, ode rait keledai mur ne it ma rikat i ti sekye lulkwe ti salke kserike, dendye deruke raka wasi taskye. ");
INSERT INTO slu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ode irire dum a ramdiry ti desy, dendye rena iry deru desy ma rbohe, “Hei, kyanmwane myaka keledai desy wasi taskye ne de?” ");
INSERT INTO slu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lemade iry deru desike rhalas iry mamdiry ti desikre, ma rtanuk kola nam dai Yesuske itanuk ti sirke. Dendye iry mamin ti desikre rlura keledai desy ti iry deru desy, ma ral i ma ror i ba. ");
INSERT INTO slu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lemade iry deru desike ror keledai desike ba ti Yesuske, ode ral wait rabit narnarure ma rary a keledai desike rutunanke, ma Yesuske syai ti. ");
INSERT INTO slu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ode iry ribun mamin ti desikre, dum a rhela wait rabit narnarure ti salke kralake, ode dum a ral aw ktahinare toha wait boare, ma ral ma rhela ti salke kralake dakun. Iry desikre ral nam desikre ti salke kralake ma ksyusu ohe ralan Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ode dum a rlakut a kmuna Yesuske, ode dum a rosi lyakwe, ode raktemtem a ratelat ma rbohe, “Mmya ma tleru Hulasokwe! Mmya ma tleru Hulasokwe! Kali myaa yor ity Ebutke Anike! ");
INSERT INTO slu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ode Hulasokwe yal eraske ti I, kali mya ma hyareta kola ity ebnwo matrumat raja Daud ne. Tleru Hulasow mamin sra lahuk ne Anike!” ");
INSERT INTO slu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kyoat ranait Yerusalem, desikeo Yesuske syukar ei kintal a Hulasokwe Seike, ma yatos nam ribun mamin ti desy mumu. Keskyede kyala ma metdyet, lemade Yesuske yor wasi matoha I dehean a kresi enaru desy, rbetik toha kintal Hulasokwe Sei desy, ma rbai hnu Betaniake. ");
INSERT INTO slu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ode bolbolke bonyo, Yesuske yor wasi matoha Iare rbetik toha Betania, kyoat desike Yesuske kyoman o imlar. ");
INSERT INTO slu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ode sososo a ne bonyo, Yesuske yatos a aw arake mo ktahinare mdat a ksyalik. Lemade bya ti nyey a aw desy ma yatos o kete kika kisi ta lema. Keskye lema itot aw desike kisike it dakun, de ktahinare bo, kali lenla kyait wasi hulke ma aw ara desike kisi. ");
INSERT INTO slu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lemadendye Yesuske tyanuk ti aw ara desike de byohe, “Kyala kyosy senweke, ana lema muisy de.” Ode kyoat itanuk koldyesy ti aw ara desy, desikeo wasi matoha Iare rtomolu tun itanuk desy dakun. ");
INSERT INTO slu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kyoat Yesuske yor wasi matoha Iare ranait Yerusalem bonyo, bya ti syukar ei kintal Hulasokwe Seike, ode yesak iry maketa nam ti kintal Hulasokwe Sei desy. Ode hyau balik mejaare ti desy, neke meja kyalamo rba ti raliku kuban tike. Ode hyau balik mbanare dakun, neke mban a kyalamo rataklulw ti ma raketa manu hahire ti ne. ");
INSERT INTO slu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ode lema lyura iry makumak a wait nam raketa desikre, ma rketa ti kintal Hulasokwe Sei desy dakun. ");
INSERT INTO slu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lemadendye yajar iry ribun desikre ma byohe, “Rkesy ti Kitab Lanke de ma kbyohe, ‘Seikw neke, sey a, bangsa mamin ti nuske ktem ne mumu ne, sey rasambayan tike.’ Keskye ei ne myal ti kindika wen a iry manametare rawahuk sir tike bo.” ");
INSERT INTO slu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kyoat desy dakun o, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry mahe snurat o tnyetak Musake rtomolu ktela Yesuske iala desikre, desike bonyo robak ksala ma rtabahunw a I. Keskyede ramtaut, kali ratos o iry ribun mamin ti desikre mumu ne rheran a ksyalik ti ratomolu Yesuske nam iajar nekre. ");
INSERT INTO slu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ode sekwe bya ma kyala ma sewah bonyo, Yesuske yor wasi matoha Iare rbetik toha nus Yerusalem desy. ");
INSERT INTO slu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ode ti bolbolbol ne bonyo, Yesuske yor wasi matoha Iare rlakut ma rbilak aw ara ituhar desy, desike bonyo ratos aw ara desike ma kimraw de, ma ti kyal kawanare dakun. ");
INSERT INTO slu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dendye Petrus nyenas yal nam liahke Yesuske itanuk ti aw ara desy, lemade tyanuk ti Yesuske de byohe, “Tuanggurw, matos! Aw ara liahke mutuhar neke kimraw de.” ");
INSERT INTO slu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Lemade Yesuske hyalas sir ma byohe, “Musti mo mtyohak Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ode tyanuk huruk ma byohe, “Mtyomolu mamak nam kutanuk ne! Kolnye esei desike mlay bain ma lema ralake kakan, de tyohak ti Hulasokwe bain-bain, desikeo bisa ma yal haretke ti huarke ma byohe, ‘Muhmua toha ne, ma ti mdwi o tasike.’ Desikemo Hulasokwe ana yala nam desike ma kdi ti, kolnye tyohak bain-bain ohe nam iten desike ana kdi ti. ");
INSERT INTO slu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lemadendye ktwanuk ti e ohe, kolnye msyambayan, ma miten sai ta sai toha Hulasokwe, desikeo musti mo mtyohak bain-bain ohe, nam miten desike ana yal ti e. ");
INSERT INTO slu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ode kolnye msyambayan, desikeo musti mo msyos iry maka salat ti e nekre ba, ma Amamy mamin ti wen sra eraske ana syos salamire ba dakun.  ");
INSERT INTO slu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Keskyede kolnye lema mbyuma msyos iry maka salat ti e nekre ba, desikemo ana Amamy mamin ti wen sra eraske lema syos salamire ba dakun.” ");
INSERT INTO slu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kyoat Yesuske yor wasi matoha Iare rulak sir bai Yerusalem huruk, ode malmata lyakut ti kintal Hulasokwe Seike, desikeo iry mabaa klen ti irkye yor Hulasokwe neke wait usu khatunare, ror iry mahe snurat o tnyetak Musake, rtabal manety lulw ti Yahudinare, rma ma rait Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ode rena I ma rbohe, “Haret kabei ne munal ma muala ktela nekre ne de? Ode esei ne inal haret ne ti O, ma muala ktela desikre ne de?” ");
INSERT INTO slu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dendye Yesuske hyalas sir ma byohe, “Kena e ti ktelake sasam aduk, ma kolnye mhyalas Yaw, desikemo nenmo klwosu ti e dakun o haret kabei ne kunal ma kuala ktela nekre ne. ");
INSERT INTO slu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ktyoha e mo, Yohanes Mababtiske wasi haretke kyosy esei de? Kyosy a Hulasokwe, ta kyosy a irkye de? Mhyalas Yaw aduk!” ");
INSERT INTO slu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lemade iry desikre raktemtem a rrekan ti de rrekan ma ode it de tyanuk it ma rbohe, “Ana kolnye thalas ma tbohe, ‘Wasi haret desy kyosy Hulasokwe,’ desikeo ana tyanuk ma ity de byohe, ‘Koldyesikemo kyanmwane lema mitohak Yohanes ne de?’ ");
INSERT INTO slu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ode kete tbohe, ‘Wasi haret desy kyosy irkye bo,’ kali kolnye ttanuk koldyesy, desikemo ana iry ribunke rkeyer a ity, kali rtohak o Yohanes neke iry manety Hulasokwe wasi nyanoke.” ");
INSERT INTO slu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lemade iry desikre rhalas Yesuske de rbohe, “Lema aramy mhye o Yohanes wasi haret desike kyosy esei.” Dendye Yesuske tyanuk ti sir de byohe, “Desikemo Yaw dakun o lema klwosu ti e ohe, esei ne inal haret ne ma Yaw, ma kal ma kala ktela nekre mumu ne!” ");
INSERT INTO slu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lemade Yesuske tyanuk tun inahliakke it ti iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror tuanggurw kubkubakare, rtabal iry manety lulw ti Yahudi-nare ma byu de byohe, “Irkye it a kyuy a boke, ode ika losan ti ma kyaklelela. Maktei o tyan tasy maiskye ti, ode kyaly a kuranke ma yala wen ana raisy tasy maiskye tike. Maktei o ika sekye ti boke ma irire ramin ti, ma rajaga bo desy. Kyoat iry desike iala nam desikre mumu maktei bonyo, yaso irire ma rseak ti bo desy, ode ana syelw a sir. Maktei o ihlolwain bai wen sosoke it. ");
INSERT INTO slu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ode kyait ma ral bo desy kisinare bonyo, boke kebu desy yaso wasi makaryake it ma bya ti yal boke kebu desy watanke toha iry manoha bo desikre. ");
INSERT INTO slu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Keskyede manoha bo desikre rkumak makarya desy ma roban a i, ode raso i ma yulak a i, desikeo imranran ti babake bo. ");
INSERT INTO slu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lemade boke kebu desy yaso wasi makaryake it huruk ma bya, keskye manoha bo desikre roban a i nini usuke khatuke kimnu, ode rahmwai ia ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Lemade boke kebu desy yaso wasi makaryake it huruk ma bya, keskye manoha bo desikre rtabahunw makarya desy. Dendye boke kebu desike yaso wasi makaryaare ma ribun sir a rba, keskye iry manoha bo desikre roban dum, ode rtabahunw dum. ");
INSERT INTO slu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dendye lema kika iry ma boke kebu desy yaso sir de, de lenla anan sasasam ilobak ne bo. Lemade byohe, ‘Lemamo kaso anakkwe ma bya, kali ana raalan ike bo.’ ");
INSERT INTO slu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Keskyede iry manoha bo desikre raatos naman desike ma ima bonyo, it de tyanuk ti it ma rbohe, ‘I neke ana syaa i ti bo ne. Lemamo ttabahunw a i, ma ity neke tsaa ity ti bo ne.’ ");
INSERT INTO slu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dendye iry desikre rkumak naman desy, ode rtabahunw a i, maktei o rotuk i bai bo tasy maisy desike ketake.” ");
INSERT INTO slu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kyoat Yesuske ihes tun inahliak desike maktei bonyo, yena usu khatu Yahudi desikre ma byohe, “Koldyesikemo boke kebu desike ana yala kolkyabei iry manoha bo desikre de? Boke kebu desike ana mya ma tyabahunw iry manoha bo desikre mumu. Maktei o nenmo ana yal iry salik ma rnoha wasi bo desy.” ");
INSERT INTO slu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ode Yesuske tyanuk huruk ma byohe, “De mbyaca tunke khatu rakesy ti Kitab Lanke ne ta lema de? Ti kibohe, ‘Hatw neke iry masadiri seire lema ral ma rsadiri sey, de rbisak ba bo. Keskyede hatw neke Hulasokwe yal ma yal ti hatw mamunmuna ti sekye. ");
INSERT INTO slu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nam Hulasokwe iala neke, kyala ity ma theran kolnye tatos!’” ");
INSERT INTO slu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lemade usu khatu Yahudi desikre ralkyaw sir ma rkumak Yesuske, kali rhe ohe tun inahliak itanuk desike, tyanuk sara sir. Keskyede ramtaut iry ribun mamin ti desy, dendye lema rkumak Yesuske, de rba bo. ");
INSERT INTO slu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lemade usu khatu Yahudi-nare raso iry manosy lui Farisi-nare dum, rtabal raja Herodes wasi irire dum, ma rba ti ratun a ror Yesuske ma rhury a Yesuske ma itun sal, ma robak a ksala ti tun itanukare, ma rkumak I. ");
INSERT INTO slu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dendye iry desikre rba ti rait Yesuske ode rtanuk ti I ma rbohe, “Tuanggurw, aramy mhye ohe, nam mutanuk o muajar nekre mlay, kali lema mukakmet. Ode Oi neke lema mukea ode museak mat, de Oi neke majar a irire bain, ma rmorif kola Hulasokwe ibuke. Lemade senweke mlwosu ma aramy ohe, bisa ma aramy msyelw a uskwe ti Kaisarke ta lema de? De musti mo aramy msyelw e?” ");
INSERT INTO slu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Keskye Yesuske hye iry desikre wait ulak o talik nekre, lemade tyanuk ti sir de byohe, “Kyanmwane mihury a Yaw kolnye ne de? Msyusu kuban dinarkeit ma katos!” ");
INSERT INTO slu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dendye reta kuban dinarke it ti Yesuske yatos. Lemade yal kuban desy, ode yena sir ma byohe, “Esei ne ragambar i ti ne de? Ode rakesy anike ti ne de?” Desikeo iry desikre rhalas ma rbohe, “Kaisarke!” ");
INSERT INTO slu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lemade Yesuske tyanuk ti sir ma byohe, “Koldyesikemo nam Kaisarke wasike mo, myal ti Kaisarke. Ode nam Hulasokwe wasike mo, myal ti Hulasokwe.” Kyoat iry desikre ratomolu Yesuske ma itanuk koldyesy bonyo, rheran a ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lemade iry manosy lui Sadukike dum a rma ma rait Yesuske. Iry nekre rtohak ohe irkye myaty desikeo lema bisa ma myorif huruk. Lemadendye rena Yesuske ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tuanggurw, Musa kyesy tnyetakke it ma ity, neke kolnye: Wamwankye it ma isa, ma lenla ratot naman, desikeo wamwany desike myaty. Koldyesikemo wamwany desike wai amurkye it a musti mo isaa yor wamfwet masom desy, ma ratot naman ti wai ausw mamaty desy. ");
INSERT INTO slu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dendye kolnye irkye itw a sir, neke ausw o amury. Ma auskwe isaa yor wamfwetke it, ma lenla raka anat bonyo wamwany ausw desike myaty. ");
INSERT INTO slu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Desike bonyo, wai amury matoha kausuke isaa yor wamfwet desy, ma lenla raka anat bonyo, wamwany matoha kausu desike myaty dakun. Dendye ktela desike kdi ti huruk ti wai amury matoha kausu nenmo mamaty desy. ");
INSERT INTO slu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ktela desike kdi ti koldyesy nini ti kyal wamwany deitw desy mumu. Ma wamwany desikre raktemtem mumu ne lema raka anat ti kyoat rasaa ror wamfwet desy. Ode kalyauke bonyo wamfwet desike myaty dakun. ");
INSERT INTO slu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dendye kolnye ana kyait sekwe ma iry mamatire rmorif huruk, desikemo ana ese sawa wamfwet desy de? Kali deitkwe mumu ne rasaa ror wamfwet desy.” ");
INSERT INTO slu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Lemade Yesuske hyalas sir ma byohe, “Ei neke ana lema mhye miba sara, kali lema mhye Kitab Lanke kralake kbuanare, ode Hulasokwe wasi haretke. ");
INSERT INTO slu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kali ana kyait ma iry mamatire rmorif, desikeo lema kika insa o inlana de. De iry desikre rmorif huruk ma rola Hulasokwe wasi nyaso manosy laitke, ma ramin ti wen sra eras Hulasokwe imin tike. ");
INSERT INTO slu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ode lema mtyohak ohe, mamatire ana rmorif huruk e? Anakyai lema mbyaca ti kitab Musa ikeskye! Kali ti kitabke krala desike, Musa ihes a kyoat Hulasokwe syusu I ti i, ti ay malehur ti kairwamaske kralake, ma Hulasokwe tyanuk ti i de byohe, ‘Yaw neke, Hulasow a Abraham, Ishak, ode Yakub a rasambayan ti Yaw nggora ne.’ ");
INSERT INTO slu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hulasokwe tyanuk koldyesy, biar ma iry detelw ne rmaty de, keskye Hulasokwe lema ika Hulasow ti iry mamatire, de ika Hulasow ti iry mamorifare. Kali ktyoha ktela irkye, desikeo iry desikre rmaty, ode lema ramin ti lasmyerke khaha ne de. Keskye ktyoha Hulasokwe, desikeo iry detelw neke rmorif a nggora. Hei iry malakut sal e, ei neke ana lema mhye miba sara, kali lema mhye Kitab Lanke kralake kbuanare.” ");
INSERT INTO slu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lemade iry mahe snurat o tnyetak Musake it a mya ma tyomolu ma iry manosy lui Sadukike rahalas tel a ror Yesuske, ma Yesuske hyalas mlay a iry desikre. Dendye iry mahe snurat o tnyetak Musa desike yena Yesuske ma byohe, “Tuanggurw, tnyetak kabei kbyilak tnyetak nekre mumu de?” ");
INSERT INTO slu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lemade Yesuske hyalas ma byohe, “Tnyetak mamunmunake, neke mtyomolu: ‘Hei iry a Israel e, ity Ebut Hulasow neke, sasasam I bo. ");
INSERT INTO slu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lemade musti mo mdwakin Ebumw Hulasokwe kyor wasimw mormyorifke mumu, kyor amalkyaumkwe mumu, kyor nam murekan nekre mumu, ode ktyabal ralamkwe kralake mumu.’ ");
INSERT INTO slu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ode tnyetak matoha tnyetak mamunmunake neke kolnye: ‘Mlwobak irire, kola dene mulobak tenamkwe ne dakun.’ Lema kika tnyetak salik ma kbyilak tnyetak deru ne.” ");
INSERT INTO slu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lemade iry mahe snurat o tnyetak Musa desike hyalas Yesuske ma byohe, “Tuanggurw, tun mutanuk desike mlay, kali Hulasow ne sasasam I bo, de lema kika hulasow salik. ");
INSERT INTO slu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dendye kolnye tdakin Hulasokwe, musti mo tdakin I a tor ity amalkyautare mumu, ode nam tarekanare mumu, ode ktyabal ity ralat a kralanare mumu. Ode tlobak irire, kola dene talobak ity tenatare kmyesan ne. Kolnye tala koldyesy, desike ne eras ma kbyilak ti tanety natzar o, taeh healare mumu ma taabar ti Hulasokwe ne.” ");
INSERT INTO slu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dendye kyoat Yesuske yatos iry mahe snurat o tnyetak Musa desy, ti nam ihalas desikre ma khyei lulw o lyaw, lemade Yesuske tyanuk ti i ma byohe, “Oi neke marasy ma mal wasimw mormyorifke ti Hulasokwe de, ma wasi iry a o!” Dendye lema irkye it a ires ma yena namit-namit toha Yesuske de. ");
INSERT INTO slu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ode malmata Yesuske yajar iry ribunke ti kintal Hulasokwe Seike, desikeo tyanuk ma byohe, “Kolkyabei mane iry mahe snurat o tnyetak Musake rtanuk ohe, Iry a Hulasokwe isusu ma ika Raja ode iaorif a irkye ne,raja Daud tesnwo natu I ne de? ");
INSERT INTO slu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kali the ohe raja Daud neke Hulasokwe Memeanke kkyarya ti i, ma tyanuk de byohe, ‘Hulasokwe tyanuk ti wasikw Amam Lanke ma byohe, “Mtwaklulw ti serikw wanke, ma kala iry mamnisik Oare ma ana mswaa lwaumw ti uno matat.”’ ");
INSERT INTO slu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ode bisa ma raja Daud yabuk Mesiaske ti Amam Lan, dendye kolkyabei mane Mesias neke raja Daud bisa ma tesnwo natu I bony ne de?” Ode iry ribun mamin ti Hulasokwe Sei desike, rdakin ma rtomolu Yesuske ma yajar. ");
INSERT INTO slu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lemadendye Yesuske tyanuk ti iry desikre mumu ma byohe, “Mijaga mamak a e ti iry mahe snurat o tnyetak Musa desikre. Kali rdakin ma rhonak rabit narnarw nekre, ma rba ti de rba ma ti wen raketa nam tiare. Ode rdakin kolnye irire rou ti sir dakun. ");
INSERT INTO slu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ode kyoat a rsukar sey rasambayan tiare, desikeo rdakin ma rtaklulw ti lulululw ne. Ode kyoat a rbai kalkal lanare, rdakin ma rtaklulw ti wen a rasosan ti iry a raalan-are. ");
INSERT INTO slu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ode iry desikre sir ne kyalamo rakakmet a enen som nekre, ma rasoruk wait sey o sar ktyabal malolitare. Ode rsambayan neke narnarnarw ksyalik, ma kyeteta totat atyatare. Lemadendye Hulasokwe ana yukun sir o mdedan a ksyalik ma kbyilak iry salik.” ");
INSERT INTO slu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kyoat Yesuske imin ti kintal Hulasokwe Seike, ma tyaklulw ma syara wen raluk natzar tike, ode yatos iry ribunke ma rluk wait natzarare ti wen raluk natzar tike. Desikeo yatos iry maka wait malolire, ma rluk wait natzarare o rluk ribun ti wen raluk natzar tike. ");
INSERT INTO slu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ode yatos enen somke it dakun ma lema yait ei sra o hah, ma mya ma lyuk wasi natzarke ti wen raluk natzar tike. Enen som desike lyuk senke enaru bo. ");
INSERT INTO slu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lemadendye Yesuske yabuk wasi matoha Iare, ma tyanuk ti sir ma byohe, “Mtyomolu mamak nam kutanuk ti e ne. Mlay bain! Enen som lema manait ei sra o hah desike yal natzarke o lan ma kbyilak iry desikre mumu ne, wait natzarare. ");
INSERT INTO slu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kali iry desikre mumu ne rety natzar toha wait maloly mabilakare, klala enen som neke biar ma lema yait ei sra o hah, keskyede yal o lan ma kbyilak sir ne mumu, kali yal wasi nam imorif ti nekre mumu ma yety ba ti Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kyoat a Yesuske yor wasi matoha Iare rbetik toha Hulasokwe Seike bonyo, wasi matoha Ike it a tyanuk ti I ma byohe, “Tuanggurw, matos! Hatw a ranal ma rala sey nekre eras a ksyalik!” ");
INSERT INTO slu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lemade Yesuske tyanuk ti wasi matoha I desike ma byohe, “Matos sey lan a eras nekre. Ana kyait sekwe, desikeo irire rma ma raskyui-raskyay hatw ranal ma raala sey desikre mumu ma kiskyui-kiskyay, ma sasam lema kimin ti kwenake dakun.” ");
INSERT INTO slu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lemade Yesuske yor wasi matoha Iare rbai kususwan Zaitunke. Ti desike Yesuske myesan a tyaklulw ma syara Hulasokwe Seike. Desikeo Petrus, Yakobus, Yohanes, ode Andreas, deatke rmesan a rma ma rait Yesuske, ma rena I ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuanggurw, mlwosu ma aramy ohe, hekyabei o nam mutanuk ne kdi ti de? Ode nyatos sakar ne ksyusu ohe, nam nekre mumu neke kyala ma kdi ti ne de?” ");
INSERT INTO slu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lemade Yesuske hyalas sir ma byohe, “Mijaga mamak a e, ma irire kete rakakmet a e! ");
INSERT INTO slu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kali irire ribun ana rma ma it o it neke ral Anikkwe ma rakakmet a e ma rbohe, sir neke Iry a Hulasokwe isusu sir ma raka Raja ode raaorif irkye ne.Iry desikre rtanuk koldyesy ma khyury ma iry ribunke rtoha sir. ");
INSERT INTO slu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ode kolnye mtyomolu britke o irire ramdiriat, ktyabal inamdiriatke ksorbubuke, desikeo kete mimtaut. Kali nam desikre mumu neke musti mo kdi ti a kmuna, keskye lenla kyait sekwe ma nuske ktem ne klyodur. ");
INSERT INTO slu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ode bangsa mamin ti nuske ktem ne ana it de syorw a it ma ramdiriat, ktyabal raja-nare ramdiriat a ror raja salik. Ode ana lurwakye ksunw ksyalik ti kabei ta kabei bo, ode ana lu o laar ne ksunw ksyalik dakun. Nam desikre mumu ne, nenmo masunkwe khyehyeike ti taras harharw ne ma desy. Masunw desike ksunsunuke kola ne enen maala ma madur hahke ti ikoman a ksunsunuke ne. ");
INSERT INTO slu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Keskyede ei neke mijaga mamak a e, kali ana rkumak e, ma ral e ti iry a Yahudi-nare wait iry maukun tunare, ma rukun a e. Ode ana roban de rtaba e ti Yahudi-nare sey rasambayan tiare. Ode ana rhait e bai raja-nare ode gubernur-are, kali mtyohak ma Yaw. Keskyede kyoat a iry desikre rala koldyesy ti e, neke ksalake desy ma myabrita Yaw ti sir ma desy. ");
INSERT INTO slu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kali Brit Eraske musti mo rabrita kmuna ti bangsa nekre mumu, ti lasmyerke khaha ne. ");
INSERT INTO slu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ode kolnye rhait e ba ti iry maukun tunare, desikemo kete ralamire kakan ti tun a musti mo ana mitanukare. De mtyanuk tun a Hulasokwe Memeanke kinal ti ralamy krala desikre. Kali tun mitanuk desikre lema kbyetik a kyosy a e, de kyosy a Hulasokwe Memeanke ma desy. ");
INSERT INTO slu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kyoat desy dakun o irire ana ral wait o hatnimat ma ror sir ba ti haretke ma rtabahunw a sir. Ode amamare ana ror anatare ti rtabahunw a sir dakun. Ode ana namanare rulak sir ma rsorw a enat o amat. Ode ana raso irire ma rtabahunw enat o amat dakun. ");
INSERT INTO slu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ode ti wen kabei ta kabei bo, iry ribunke ana ramnisik e, kali mtyohak Yaw. Keskye kolnye mtyohak manenen ma Yaw nini mmyaty, desikemo mitot mormyorif manal nini namke.” ");
INSERT INTO slu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Lemade Yesuske tyanuk huruk ma byohe, “Ei ne ana myatos irkye it ma ihatw ksyalik, ma imdiry ti wen nelnyely a lema bisa ma isukar ma imdiry tike. Ode i ne isukar ma iala wen nelnyely desy ma kiray ne.” –iry mabacaare musti mo mhye nam Yesuske itanuk ne kbuanke– “Kyoat ktela desy kidi ti bonyo, iry mamin ti propinsi Yudeake musti mo ra-la rbai huarare. ");
INSERT INTO slu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ode iry mamin ti mloskye, kete syukar ma yal nam dum toha sekye kralake. ");
INSERT INTO slu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ode iry mamin ti boare, desikemo kete yolik i bai sekye ti yal wasi simbol o rabit. ");
INSERT INTO slu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ode kyoat ra-la rbai huarare desy, desikeo enen a manor tenatare, ror enen a masusw anatare ana masunkwe kdyan sir o ksunw ksyalik. ");
INSERT INTO slu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dendye musti mo msyambayan, ma kete ktela neke kdi ti sew a us o esw. ");
INSERT INTO slu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ktwanuk koldyesy, kali kyoat desike irire ana masunkwe kdyan sir o ksunw ksyalik. Ma ti kiala kyosy a Hulasokwe yala nuske ktem ne, ma ti kinait sew desy, irkye lenla kyoman masunw maoly desy elik. Ode kyala kyosy sew desy dakun ma ti kiba knaru ne, ana masunw maoly desy lema kdyan irkye de. ");
INSERT INTO slu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kyoat desike kolnye Hulasokwe lema yatuuk seure ti taras masunw desy, desikemo lema irkye it a myorif dakun. Keskyede Hulasokwe yatuuk seure ti taras masunw desy, kali lyobak wasi iry a iilikare. ");
INSERT INTO slu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kyoat desike irire rtanuk ti e ma rbohe, ‘Myatos, Iry a Hulasokwe isusu ma ika Raja ode iaorif irkye ne imin ti ne.’ Ta dum a rbohe, ‘Imin ti so.’ Desikemo kete mtyohak tun ratanuk desikre. ");
INSERT INTO slu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kali kyoat desike irire ribun ana rma ma rakakmet ma rbohe, Hulasokwe syusu sir ma raka raja ode raorif irkye. Ode irire ribun ana rma dakun ma rakakmet ma rbohe, sir ne iry a manety Hulasokwe wasi nyano sir. Ode iry nekre mumu ne ana rala nyatos o ktela masalsyalik iare dakun. Mamode ktela o nyatos raala desikre khyury ma kikakmet a iry mamin nuske ktem ne, ma ti kyal a robak ma rakakmet a iry a Hulasokwe iilikare dakun. ");
INSERT INTO slu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lemadendye mijaga mamak a e! Kali ktwanuk tun nekre mumu ti e a kmuna de.” ");
INSERT INTO slu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ode kyoat sew a masunw lan madan irkye desy kisakut, desikeo ana sekwe lema ryan, de kelerkok, ode ana hulke lema nyely dakun, ");
INSERT INTO slu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ode ana ftunare rdi toha laitke, ode nam mahareta salik mamin ti laitke ne, ana rdi ma raskyui-raskyay. ");
INSERT INTO slu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kyoat desike bonyo, iry mamin nuske ktem ne mumu ne ana ratos Irkye Ananketi oanke kralake, ma yorw yosy laitke. Neke myaa yor wasi haret lan ne, ode wasi madelafke. ");
INSERT INTO slu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ode kyoat desy dakun o, ana Hulasokwe yaso wasi nyasoare toha laitke, ma rma ma rawahuk iry a iilikare ti nuske ktem ne mumu.” ");
INSERT INTO slu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Lemade myatos ti aw arake! Kolnye myatos aw arake ma kudu murare kbyetik ti ksananare, desikemo mhye o lemanke kyarasy de. ");
INSERT INTO slu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Koldyesy dakun o, kolnye myatos a ktela kutanuk ti e nekre mumu ma kdi ti, desikemo mhye ohe sew a Irkye Ananke ima huruk ne kyala ma kyait mane, kola ne imdiry holholatke kmatake de. ");
INSERT INTO slu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mtyomolu mamak nam kutanuk ne. Mlay bain! Iry mamorif ti taras neke ana lenla rmaty, kolnye nam nekre mumu ne lenla kdi ti. ");
INSERT INTO slu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dendye mnyenas! Lait o lasmyer ne ana kitayar, klala tunakure kimin ma ana kyal nini nam ti kiba knaru ne. ");
INSERT INTO slu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Biar ma koldyesy, keskyede lema irkye it a hye ohe hekyab o sew a Irkye Ananke ana ima huruk ne kdi ti. Ma ti kyal nyaso manosy laitare lema rhe, ode Irkye Ananke o lema hye dakun. De lenla Amaku myesan a hye bo.” ");
INSERT INTO slu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Lemade mijaga mamak a e, kali lema mhye ohe hekyab o Irkye Ananke mya huruk. ");
INSERT INTO slu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wasi mama neke kola ne iry mahlolwainke it. Ma kyoat iry neke yala ma tyutuk wasi sekye, ma byai hnu sosoke it, desikeo yal haretke ti wasi makaryaare, ma it o it neke rkarya wait karya inal ti sir ma rakarya ne. Ode yaso iry majaga holholatke ma byohe, ‘Mujaga mamamak holholat ne nini kulak yaw mai ne.’ ");
INSERT INTO slu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lemadendye musti mo mijaga mamak a e, kali lema mhye ohe sekye kebuke yulak i sew kabei. Kali wasi mama neke lema mhye o ana mya sekwe bya ta, metdyet ta, metdyet a kditlan ta, nyamomo ne. ");
INSERT INTO slu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma kolnye mya mait mo, kete yait e ma malmata myenaf. ");
INSERT INTO slu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ode nam kutanuk nekre, lema ktwanuk ti e a myesan, de ktwanuk ti irire mumu ti lasmyerke khaha ne, ma rajaga mamak a sir dakun.” ");
INSERT INTO slu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lenla sekwe enaru, desikeo iry a Yahudi-nare wait sew lan Paskahke kdi ti. Ode kyoat sew lan Paskah desike kdi ti, desikeo wait sew lan deitw a Rana Roty a Lema Ranal Ragi Tike nenmo klyakut dakun. Dendye iry mabaa klen ti irkye yor Hulasokwe neke wait usu khatunare, ror iry a mahe snurat o tnyetak Musake, neke robak a ksala ma rkumak Yesuske ma rtabahunw a I. Keskye rahunik ma lema irkye it a hye elik. ");
INSERT INTO slu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ode rtanuk huruk ma rbohe, “Kete tala ktela desy ti sew a kalkal lan ana madi ti ne, kali ana kyety oror o nanwaw ti ribunke khahake.” ");
INSERT INTO slu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kyoat Yesuske imin ti Betania, desikeo imin ti Simon wasi sekye, Simon neke lulswoke imbaul. Ode malmata Yesuske tyaklulw ma iknam, desikeo wamfwetke it ma mya o, yety a botalke it ma rala toha hatw a marmerke, ma nul mahon a mtelas a khesi lanke kimin ti, neke nul narwastuke. Ode wamfwet desike tyabanukur botal desike knunuke, maktei o yalik nul desy ti Yesuske usuke khatuke. ");
INSERT INTO slu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Keskyede iry mamin ti desikre dum a rkeyer ma it de tyanuk ti it ma rbohe, “Kyanmwane wamfwet neke ibyata nul mahon a mtelas ne kolnye ne de? ");
INSERT INTO slu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lemamo kyeta nul ne. Kali kolnye kyeta, desikeo kyal kuban blyawan bokbokke atkwe enatelw. Ode kuban desike yal ti iry a lema manait ei sra o hah nekre.” Lemadendye iry desikre ral keyerke ma rterik wamfwet desy. ");
INSERT INTO slu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Keskyede Yesuske tyanuk ti sir ma byohe, “Kyanmwane mikeyer a i ne de? Mlyura i ma yala bo. De lema mhye o nam iala ma Yaw neke eras e? ");
INSERT INTO slu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ode mhye o iry lema manait ei sra o hahare kyalamo ranonor a e. Ma sew kabei ta kabei ma mbyuma msyaluk a sir, desikemo bisa ma msyaluk sir. Klala Yaw neke ana lema kor a e sew kyaki nekre de. ");
INSERT INTO slu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ode wamfwet neke bisa ma yala nam ialanare de. Kali lenla kmwaty ma ti ramlin a Yaw, keskyede wamfwet neke yalik nul mahon a mtelaske a kmuna ti tenakkwe de, ma kikita elik ti ana kumaty ma ti ramlin a Yaw ne. ");
INSERT INTO slu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mtyomolu mamak nam kutanuk ne. Mlay bain! Ti kabei ta kabei bo, ti nuske ktem ne mumu ne, kolnye irire rabrita Brit Eraske, desikemo ktela wamfwet ne iala neke ana rabrita dakun, ma khyury ma irire mumu neke ranenenas i.” ");
INSERT INTO slu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ode Yudas neke Yesuske wasi matoha I dehean a kresi enaruke it ne dakun. Ma i neke bya ti yait iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ma byuma kyeta Yesuske ti sir. ");
INSERT INTO slu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lemadendye usu khatu desikre ramukmuka sir a ksyalik, ti Yudas ibuma iketa Yesuske ne. Lemade usu khatu desikre rahatetak ma ana ral kuban ti Yudas. Dendye Yudas yobak a klelanke it, ma bisa ma yal Yesuske ti sir. ");
INSERT INTO slu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kyoat sew mamunake ti sew lan deitw a Rana Roty Lema Ranal Ragi Tike kdi ti mingguke krala Paskah desy, desikeo ti sew desike dakun o, irire musti mo rkotal domba ma raknam Paskahke. Lemade Yesuske wasi matoha Iare rena I ma rbohe, “Amam Lan O, wen kabei ne mou ma ti aramy misosan ma ana tana kotw Paskahke ti ne de?” ");
INSERT INTO slu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Lemade Yesuske yaso irkye enaru toha wasi matoha I desikre, ma byu ti deruke de byohe, “Mbyai nus Yerusalemke krala desy, ode ana ti desike minal a myor wamwankye it ma hyar a lkuskye, ma werke kimin ti kralake. Desikeo mtyoha i ");
INSERT INTO slu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ei sey isukar tike, ode mtyanuk ti sekye kebu desy de mbyohe, ‘Ara wasimy Tuanggurkwe yena ohe, wen kabei ne ana inor wasi matoha Iare rana kotw Paskahke ti ne de?’ ");
INSERT INTO slu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Desikeo sekye kebu desike ana syusu wen lanke it, ma kimin a sekye kdadi srake. Wen desike isosan ma ktei de. Wen desike ne ana misosan kotw o abw ti, ma ti taknam Paskahke ti ne.” ");
INSERT INTO slu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lemade wasi matoha I deru desy rba ma ranait Yerusalem bonyo, nam ribun desikre kdi ti kola ne tun Yesuske itanuk ti sir ne. Dendye ti wen desike ne rasosan kotw o abw ti, ma ana raknam Paskahke ti ne. ");
INSERT INTO slu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ode sewahke bonyo, Yesuske mya o yor wasi matoha I dehean a kresi enaru desy, ma rbai sey dai rasosan desy. ");
INSERT INTO slu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ode kyoat rtaklulw ma malmata raknam, desikeo Yesuske tyanuk ti sir de byohe, “Mtyomolu mamak nam kutanuk ne. Mlay bain! Ti ei ne mumu ne, ana irkye it a kyeta Yaw. Iry neke i ne iknam a inor a Yaw ne.” ");
INSERT INTO slu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kyoat wasi matoha Iare ratomolu tun itanuk desy bonyo, ralatare kitol, dendye it o it ne rena Yesuske ma rbohe, “Ebo, esei de? Lema yaw o de?” ");
INSERT INTO slu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Lemade Yesuske hyalas sir ma byohe, “Iry neke yosy a iry dehean a kresi enaru e ne, ma i ne inor Yaw ma aramy miknam ti mbinan sasamke ne. ");
INSERT INTO slu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ktwanuk koldyesy, kali rkesy ti Kitab Lanke ohe, Irkye Anankemusti mo ana myaty mane. Keskyede ana atyatke kidurak a iry maketa Irkye Anan desy. Lemamo iry desike kyalake kete radur ti i elik.” ");
INSERT INTO slu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kyoat Yesuske yor wasi matoha Iare malmata raknam, desike bonyo Yesuske yal rotkye, ode syambayan ma syalak eraske ba ti Hulasokwe ti roty desy. Maktei o byini-byiny roty desy ma yal ti wasi matoha Iare ma byohe, “Myal, ode mi, tenakkwe ne.” ");
INSERT INTO slu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Maktei o yal takwe ma tasy maiskye kwen makitkye kimin ti, ma syambayan ma syalak eraske ba ti Hulasokwe ti tasy maiskye kwen makity desy. Isambayan maktei bonyo, yal ti wasi matoha Iare, ma reta raoly ma renw kyakar sir. ");
INSERT INTO slu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ode tyanuk ti sir ma byohe, “Larakkwe ne, ma ana kibo ei hahke ma klyitan eta iry ribunke. Ode larakw neke kyeluk nyatos ohe, tnyetak harharkwe ti irkye yor Hulasokwe, neke nenmo kimin mane. ");
INSERT INTO slu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lemade mtyomolu mamak nam kutanuk ne. Mlay bain! Kyala kyosy ne ana lema kenw tasy maiskye kwen ne de, nini kyait sew a kuma huruk ma kuhareta kola Rajake ti nuske ktem ne, kola ne kuhareta ti wen sra eraske ne. Ti sew desike dakun o nenmo kenw tasy maiskye kwenke huruk ma desy.” ");
INSERT INTO slu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lemade Yesuske yor wasi matoha Iare, raktem a raora ma rleru Hulasokwe Anike, maktei o rbai kususwan Zaitunke. ");
INSERT INTO slu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lemade kyoat Yesuske yor wasi matoha Iare raba bonyo, tyanuk ti sir ma byohe, “Ei ne mumu neke, ana mila toha wasimy tohtohak mitohak ma Yaw ne. Kali rkesy ti Kitab Lanke ma kbyohe, ‘Ana ktwabahunw a majaga dombake, ma khyury ma wasi dombanare ra-la a raskyui-raskyay.’ ");
INSERT INTO slu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Keskyede ana Hulasokwe yala Yaw ma kmworif huruk toha mamatire, desikeo ana kmuna e bai propinsi Galileake.” ");
INSERT INTO slu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lemade Petrus tyanuk ti Yesuske ma byohe, “Tuanggurw, biar ma sir ne mumu neke ra-la toha wait tohtohak ratohak ti O ne, keskyede yaw ne lema kula toha wasikw tohtohakke ti O elik.” ");
INSERT INTO slu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dendye Yesuske hyalas i ma byohe, “Petrus o, mtwomolu nam kutanuk ne. Metdyet neke sihkye lenla kyokoak a kla-ru, desikeo mubu a mutuli Yaw kdi a kla-telw de, ma mbwohe lema mhwe Yaw elik.” ");
INSERT INTO slu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Keskyede Petrus a hyalas Yesuske bain-bain ma byohe, “Biar ma rtabahunw a yaw kali ktwoha O, keskye lema bisa ma kubu a kutuli O elik.” Desikeo lianare mumu ne rtanuk koldyesy dakun. ");
INSERT INTO slu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ode Yesuske yor wasi matoha Iare rait a wenke it ma kani a bo Getsemanike. Desike bonyo Yesuske tyanuk ti wasi matoha I desikre ma byohe, “Mtyaklulw ti ne, ma ti kswambayan aduk.” ");
INSERT INTO slu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dendye yabuk Petrus, Yakobus yor Yohanes, ma ror I ma rba. Kyoat desike Yesuske ralake ksyal a ksyalik, ode ralake lema ktyeka i. ");
INSERT INTO slu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lemade tyanuk ti sir ma byohe, “Ralakw neke ksyal a ksyalik, kola ne kala ma kmwaty mane. Dendye mimin ne, ode mijaga mamak a e.” ");
INSERT INTO slu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Maktei o Yesuske tyutuk sir ti desy, ma lyakut tebikan bai lulkwe, ma syakitil ode syambayan. Yesuske syambayan ma lemamo ktela masunw ana madan I ne, neke kyaditi i toha I. ");
INSERT INTO slu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Neke syambayan kolnye, “O Amo, Oi ne bisa ma mala nam sai ta sai bo. Dendye mou mo, kuten ma ktela masunw ana madi ti ma Yaw neke, maditi toha Yaw. Keskye Amo, kete mtwoha kubuke, de mtwoha mubuke bo.” ");
INSERT INTO slu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Maktei bonyo Yesuske yulak I ma yait a wasi matoha I detelw desy, desikeo yatos sir o malmata renaf. Lemade tyanuk ti Petrus ma byohe, “Simon, kyanmwane muenaf ne de? De lema bisa ma mujak jamke sasam e?” ");
INSERT INTO slu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lemade Yesuske tyanuk ti sir huruk ma byohe, “Mijaga mamak a e ode msyambayan, ma kete nam dum a khyury a e ma mdyi ei lim o sal. Kali ralami kralanare kbyuma myala nam a mlaire, keskye lema bisa ma myala, kali tenamire lema malkyakaw.” ");
INSERT INTO slu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lemade Yesuske yulak I huruk bai wen isambayan tike, ma yoly a wasi sambayan dai desy huruk bo. ");
INSERT INTO slu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Maktei o yulak I huruk ma mya ma yait a wasi matoha I desikre, desikeo renaf huruk, kali matatare koskosa a ksyalik. Dendye tyerik a sir, desikeo lema rhe o rhalas I kolkyabei. ");
INSERT INTO slu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lemade Yesuske yulak I a kla-teluke bai wen isambayan tike ma syambayan. Ode kyoat yulak I ti yait wasi matoha I detelw desy huruk, desikeo tyanuk ti sir de byohe, “Myenaf huruk e? Mienafke mo knyal e de. Myatos! Kyait sekwe de. Irkye Ananke rala ma ral I ba ti iry a lim o salare mane. ");
INSERT INTO slu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lemadendye mbyatar ma tba. Kali iry a maketa Yaw neke mya de.” ");
INSERT INTO slu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kyoat Yesuske malmata itun a yor wasi matoha Iare, desikeo kele rsoru Yudas ma mya. Yudas neke Yesuske wasi matoha Ike it ne dakun, ti wasi matoha I dehean a kresi enaru desy. Yudas neke mya o yor iry ribunke, kali iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry mahe snurat o tnyetak Musake, rtabal a iry manety lulw ti Yahudi-nare, neke raso sir ma rma. Iry ribun desikre rma o rety a kray o oboban, ma rma ma rkumak Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ode kyoat iry ribun desikre lenla rma, desikeo Yudas tyanuk ktelake it ti sir ma byohe, “Iry ana mikumak neke msyeak de koy a I, iry neke I desy de. Lemade mkyumak I ma myor I ba, ode mijaga I mamak.” ");
INSERT INTO slu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kyoat iry ribun desikre ranait bonyo, Yudas lyakut elik sara Yesuske ma byohe, “Tuanggurw,” maktei o yoy a I. ");
INSERT INTO slu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lemade iry ribun a manor Yudas ma rama desy, neke rkumak Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dendye Yesuske wasi matoha Ike it a nyaik a wasi krakye, ma syoby ohut irkye it a tliake. Iry a tlia madohut desike, ika at ti iry mabaa klen lan lahukke. ");
INSERT INTO slu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lemadendye Yesuske tyanuk ti sir ma byohe, “Desi mryekan o Yaw neke iry mahatw a Yaw e? Mane mima o minety a kray o oboban, ma mikumak a Yaw ne e? ");
INSERT INTO slu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sew kyaki nekre kunonor e ti Hulasokwe Seike, ma kajar iry ribunke, desikeo lema mkyumak Yaw. Keskyede sai rkesy ti Kitab Nelnyelkye, musti mo kdi ti.” ");
INSERT INTO slu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lemade Yesuske wasi matoha Iare ra-la toha wen desy, ode rtutuk I ti desy. ");
INSERT INTO slu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kyoat desike lyalakwe it ma hyonak rabit maniniaske bo, ode lyakut yosy lyakwe ma tyoha Yesuske. Lemade iry mabaa klen ti irkye yor Hulasokwe wait iry a raaso desikre rala ma rkumak i dakun. Dendye rraut wasi rabit maninias desy, ");
INSERT INTO slu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","keskyede lyalaw desike yonuk rabit desy ma byisak ba, ode ila bya o imlehleh. ");
INSERT INTO slu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lemade ror Yesuske bai iry mabaa klen lan lahukke wasi sekye. Ti desike iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare mumu, ode iry mahe snurat o tnyetak Musake, ror iry manety lulw ti Yahudi-nare, neke raktemtem a rawahuk sir ti desy. ");
INSERT INTO slu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kyoat desikeo Petrus tyoha Yesuske keskyede sososo a i bo, ma ti syukar ei iry mabaa klen lan lahukke wasi kintalke kralake. Ode ti desike dakun o Petrus tyaklulw yor iry majakare ma malmata rmamuk akye. ");
INSERT INTO slu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lemadendye iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror Iry Lan Maohut Tun desikre mumu ne, neke robak a ksala ma musti mo rtunik tnyetak matmyatkye ti Yesuske. Keskyede lema ratot a Yesuske wasi salke it elik. ");
INSERT INTO slu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ode ti desike dakun o irire ribun a rtanuk tun lema mlaire, ma roit salke ti Yesuske. Keskyede tun ratanuk desikre lema mais. ");
INSERT INTO slu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lemade irkye enai ne ramdiry ma roit salke ti Yesuske, ma rtanuk tun lema mlaire ma rbohe, ");
INSERT INTO slu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Aramy mtyomolu iry ne ma tyanuk de byohe, ana iskyui-iskyay Hulasokwe Seike, neke sey a irkye ika desy. Ode sekwe enatelw bonyo ana syadiri harharkwe, neke irkye lema ika.” ");
INSERT INTO slu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Keskyede tun ratanuk desikre dakun o lema mais. ");
INSERT INTO slu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Lemade iry mabaa klen lan lahuk desike imdiry ti wen raohut tun ti desike kditlalanke, ode yena Yesuske de byohe, “Kyanmwane lema mhwalas iry ribun nekre ti raoit salke ti O ne de?” ");
INSERT INTO slu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Keskyede Yesuske mamwaw I bo, ode lema tyanuk tunke it dakun. Dendye iry mabaa klen lan lahuk desike yena I huruk ma byohe, “Oi neke Mesias a iry a Hulasokwe isusu ma muka Raja ode muaorif irkye ne e? Ode Oi neke Hulasow a taleru neke Anan a O e?” ");
INSERT INTO slu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Desike bonyo Yesuske hyalas ma byohe, “Mlay, Yaw ne nde. Ode ana myatos Irkye Ananke ma tyaklulw ti Hulasow Lan Lahukke seri wanke. Ode ana imin ti oanke kralake kyoat a yorw yosy laitke.” ");
INSERT INTO slu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kyoat iry mabaa klen lan lahuk desike itomolu Yesuske tuna desy bonyo, kyeyer ma myesan yahy a wasi rabitke ti tenanke, ode tyanuk ma byohe, “Takita esei ma tyanuk huruk de? ");
INSERT INTO slu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ei ne mumu ne mtyomolu ma wan ne ihmwai Hulasokwe de. Dendye mryekan kolkya?” Lemade iry ribun desikre rkau tunke ti sasam ode rohut ma rbohe, “I neke musti mo ttunik tnyetak matmyatkye ti I!” ");
INSERT INTO slu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lemade irkye enai ne rasburik I, ode rlel eta matake. Maktei o roban I, ode rtanuk ti I ma rbohe, “Hei, kolnye iry manety Hulasokwe wasi nyano O, desikemo bisa ma mhwe! Dendye mlwosu ma aramy ohe, esei ne ioban a O ne de?” Ode suldat majakare roban Yesuske dakun. ");
INSERT INTO slu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kyoat desyo Petrus imin ti iry a mabaa klen lan lahuk desike wasi kintalke a nggora. Desike bonyo iry mabaa klen lan lahuk desike wasi makarya wamfwetke it a myai wen desy dakun. ");
INSERT INTO slu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ode kyoat yatos o Petrus a myamuk akye dakun, dendye yatos manenen Petrus, ode tyanuk ti i ma byohe, “Oi ne kyalamo mor Yesus iry a Nazaret desy dakun o de?” ");
INSERT INTO slu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Keskyede Petrus a ibu a ituly ma byohe, “Lema khwe iry desy, ode lema khwe nam mutanuk desike kbuanke.” Lemade lyakut bai lulkwe ti imdiry ti salhaha lorkye kmatake kserike. Desikeo sihkye kyokoak dakun. ");
INSERT INTO slu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ode kyoat makarya wamfwet desike yatos Petrus huruk bonyo, tyanuk ti iry mamin desikre ma byohe, “Mlay bain! Iry neke kyalamo lyakut a yor Yesuske.” ");
INSERT INTO slu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Keskyede Petrus a ibu a ituly huruk. Ode lema soso bonyo, iry mamin ti desikre rtanuk ti Petrus huruk de rbohe, “Mlay bain! Oi neke kyalamo mor sir, kali oi neke iry Galilea o.” ");
INSERT INTO slu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Desike bonyo Petrus ihwab ma byohe, “Lema khwe iry mitanuk desy elik!” ");
INSERT INTO slu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kyoat Petrus itanuk koldyesy maktei bonyo, sihkye kyokoak a kla-ruake. Dendye Petrus nyenas yal mait tun Yesuske itanuk ti ike, ti ibohe “Sihkye lenla kyokoak kdi a kla-ru, desikeo mubu a mutuli Yaw kdi a kla-telw de.” Lemade Petrus a syer ma kisalsal ti desy. ");
INSERT INTO slu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bolbolbol ne bonyo, Iry Lan Maohut Tunare mumu ne rawahuk sir, neke iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry manety lulw ti Yahudi-nare, rtabal iry mahe snurat o tnyetak Musake. Sir ne rawahuk sir ma rkau tunke ti sasam, ma rbuma rtunik tnyetak matmyatkye ti Yesuske. Dendye iry desikre raso irire ma rsik ranteke ti Yesuske simanare, ode ror I ba ti gubernur Pilatus. ");
INSERT INTO slu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kyoat ranait so bonyo gubernur Pilatus yena Yesuske ma byohe, “Oi ne iry Yahudi-nare wait raja O e?” Yesuske hyalas ma byohe, “O a mmwesan a mtwanuk koldyesy bo.” ");
INSERT INTO slu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lemade iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, roit sal ribunke ti Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dendye gubernur Pilatus yena I huruk ma byohe, “Hei! Iry nekre roit sal ribun lan ne ti O, ode kyanmwane lema muhalas sir ne de?” ");
INSERT INTO slu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Keskyede Yesuske lema hyalas tunke it elik, ma khyury ma gubernur Pilatus a hyeran. ");
INSERT INTO slu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ode kyalamo kyait sew lan Paskahke, desikemo gubernur Pilatus wasi ktelake de, ma tyunik irkye it toha iry a raluk sir ei sey metmetke kralake ne. Iry a Pilatus itunik desike ktyoha iry Yahudi-nare ratenke bo. ");
INSERT INTO slu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kyoat desike dakun o irkye it ma ani Barabas. Barabas neke rluk i a yor iry mahature ei sey metmetke kralake, kali rsorw a haret Romake. Kyoat Barabas a rsorw haret Roma desy, desikeo rtabahunw a irire dum dakun. ");
INSERT INTO slu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lemade iry ribunke rma ma rait gubernur Pilatus, ma raten i ma tyunik irkye it, ma ktyoha ktela kyalamo iala ti sew lan Paskahke ne. ");
INSERT INTO slu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lemadendye Pilatus yena sir ma byohe, “Myou ma ktwunik Yahudi-nare wait raja ne ti e e?” ");
INSERT INTO slu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus yena koldyesy kali hye ohe, iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare ral Yesuske ti i, kali rsoi ralat Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Keskyede iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, neke rsuy iry ribunke ma iry ribun desikre raten toha Pilatus, ma tyunik Barabas toha sey metmetke kralake ti sir. ");
INSERT INTO slu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dendye Pilatus yena sir huruk ma byohe, “Koldyesikemo, iry a mibohe Yahudi-nare wait raja ne, musti mo kala I kolkya?” ");
INSERT INTO slu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Desikeo iry desikre rboran ma rbohe, “Mbwakw a I ti tul masanwalw ike!” ");
INSERT INTO slu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lemade Pilatus tyanuk ti iry desikre ma byohe, “Iry neke yala sal sai de?” Keskyede iry desikre rboran ma telatare lan ma rbohe, “Mbwakw a I ti tul masanwalw ike!” ");
INSERT INTO slu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dendye Pilatus yobak ma yala iry ribun desikre ralatare ma ksyenan, lemade tyunik Barabas toha sey metmetke ti iry desikre, klala yaso wasi suldatare ma roban Yesuske, maktei o rbakw a I ti tul masanwalw ike. ");
INSERT INTO slu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lemadendye suldatare ror Yesuske ma rsukar ei wen rawahuk sir tike. Neke kimin ti gubernur Pilatus sey lan imin tike wasi kintalke kralake. Ode rabuk suldat salikare mumu, ma rawahuk sir ti desy dakun. ");
INSERT INTO slu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ode ronuk wasi rabitke toha I, ode ral rabit narnarw a kmata molmol ebuske ma ral ma rhonak a I. Maktei o ranak karkyary a mahaw ne, ode ronuk ti Yesuske usuke khatuke, ma kola snyamurke, ma ral ma rahmway Yesuske. ");
INSERT INTO slu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maktei o rala rhury ma ralan I, ma rtanuk ma rbohe, “Raja iry Yahudi O, aramy myalan O!” ");
INSERT INTO slu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ode raeluk-raeluk sir ma ral tektekanke it ma roban Yesuske usuke khatuke, maktei o rasburik I. Ode rala rhury ma rsakitil o rou ti I. Rala koldyesy ma raranran I. ");
INSERT INTO slu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ode kyoat rahmway I o rasburik I ma ktei, desikeo ronuk rabit narnarw a kmata molmol ebus desy toha I. Ode ral wasi rabitke ma rhonak I huruk. Maktei o ror i bai mloskye ti rbakw a I ti tul masanwalw ike. ");
INSERT INTO slu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kyoat suldat desikre ror Yesuske ma rbetik toha nus desy, ma rbai wen ana rabakw a Yesuske tike, desikeo ti salke kditlalan ne ranal a ror irkye it ma ani Simon, iry a Kirene-ke. Simon neke Aleksander ode Rufus amatke, ma yala ma syukar nus Yerusalemke. Lemade suldat desikre rpaksa i ma hyar a Yesuske wasi tul masanwalw desy. ");
INSERT INTO slu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ode suldat desikre ror Yesuske bai wenke it ma kani a Golgota, neke kbuanke o, Wen uskwe keburake kimin tike. ");
INSERT INTO slu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ode rahora mohkwe ktyabal tasy maiskye kwenke, ma ral ti Yesuske yenw, keskyede Yesuske ibrai ma yenw. ");
INSERT INTO slu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Maktei o suldat desikre rbakw Yesuske ti tul masanwalw ike. Ode rhuty aluri ti wasi rabitare ma rhe o, ana esekar ne rosy simbol o rabit nekre. ");
INSERT INTO slu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ode kyoban sikwe ti bolbol ne, desikeo rbakw a Yesuske ti tul masanwalw ike. ");
INSERT INTO slu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ode rkesy ti mbanke klaike it ma rbakw ti tul masanwalw i desy wasi srake, neke rkesy kolnye: I neke raja iry a Yahudi-nare. Tunke khatu rakesy neke, ksyusu sal raoit ti Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ode kyoat a rbakw Yesuske, desikeo rbakw iry mahatkwe enaru dakun, ma it a imin ti Yesuske seri wanke, ode it a imin ti Yesuske seri wisalke.  ");
INSERT INTO slu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Koldyesike mane nam rakesy ti Kitab Lanke krala neke kdi ti de, neke ktyanuk de kbyohe, “I neke rbohe iry mahatw I dakun”. ");
INSERT INTO slu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ode iry malakut manosy wen desike dakun o rahmway I, ode rowou daku I, ma rtanuk de rbohe, “Hei, Oi ne mutanuk ma mubohe, ana muskyui-muskyay Hulasokwe Seike, ode sekwe enatelw o mswadiri huruk. ");
INSERT INTO slu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Koldyesikemo morw toha tul masanwalw i desy, ma maorif tenamkwe a nde!” ");
INSERT INTO slu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ode iry mabaa klen ti irkye yor Hulasokwe wait usu khatunare, ror iry mahe snurat o tnyetak Musake, ramdiry ti desy ma rahmway Yesuske dakun, ma it de tyanuk ti it ma rbohe, “Iry salik o bisa ma yaorif sir, ode tenanke o lema bisa ma yaorif yal dakun e! ");
INSERT INTO slu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ode kolnye iry neke you ohe, I neke Mesias I, ma iry a Israel-are wait Rajake I ne, desikemo musti mo myesan a yorw toha tul masanwalw i desy, ma tatos desikeo nenmo ttohak.” Ma ti kyal iry deru rabakw sir a ror Yesuske neke rahmway Yesuske dakun. ");
INSERT INTO slu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kyoat desike sekwe dyutw mais-mais, keskye kelerkok ti nuske ktem desy, kali Hulasokwe yala sekwe ma lema ryan, nini kyal jamke enatelw. ");
INSERT INTO slu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ode kyoban enatelkwe ti sekwe iba ne bonyo, Yesuske yatela ma byohe, “Eloi, Eloi, lama sabakhtani?” Neke kbuanke o, “Amo, Amo, kyanmwane mututuk Yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kyoat iry mamdiry ti wen desikre ratomolu nam Yesuske itanuk desy bonyo, rtanuk ma rbohe, “Mtyomolu ma yabuk Elia, iry a heitlulswo manety Hulasokwe wasi nyano desy.” ");
INSERT INTO slu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lemadendye irkye it a ila bya ti yal temarke ode yutuk ti aurke khunake, maktei o hyuhuk aurke khuna desy ti tasy maiskye kwen makitkye, ode yal ti Yesuske nunuke, ode byohe, “Ode takita ma tatos o, dai yabuk Elia dendye, tseak o ana Elia mya ma nyauk I toha tul masanwalw i ne ta lema.” ");
INSERT INTO slu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lemade Yesuske yatela huruk maktei bonyo myaty. ");
INSERT INTO slu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kyoat desike kain mal de mal a ratola ma kyeteta wen nelnyely mamin ti Hulasokwe Seike kralake, kele rahy ti kbya enaru, neke kyala kyosy srake ma ti kyait hahke. ");
INSERT INTO slu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kyoat suldatare wait uskwe khatu desike iatos ti kolkyabei ma Yesuske imaty ne bonyo, tyanuk ma byohe, “Mlay bain! I neke Hulasokwe Anan a I!” ");
INSERT INTO slu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ode ti desike wamfwetare dum a ramdiry ma sososo a sir, ma ratos a ktela desy. Wamfwet desikre neke Maria Magdalena, Salome, ode Maria. Maria ida neke Yoses yor Yakobus Kakanke enatke, ma sir neke Yesuske wai amurire. ");
INSERT INTO slu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kyoat Yesuske imin o Galilea, desikeo wamfwet detelw neke rtoha I de. Ode kyalamo rsaluk I ti nam sai ta sai bo. Ode wamfwet salik nekre ribun ramdiry ti desy dakun. Sir ne mumu ror Yesuske ma rmai Yerusalem. ");
INSERT INTO slu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kyoat desy o irire mumu ne rasosan sir ma rakita sew Inamreske, kali sekwe yala ma dyi. Desikeo Yusuf, iry manosy nus Arimateake ti propinsi Yudeake, i neke Iry Lan Maohut Tunke it ne, ode irire ralan a i dakun, dendye Yusuf neke lema imtaut de bya ti yait gubernur Pilatus, ma iten Yesuske tbunanke ma ti yamlin. Yusuf neke i ne ikita sew a Hulasokwe ima ma ihareta kola Rajake ne. ");
INSERT INTO slu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kyoat Pilatus itomolu Yusuf ma iten Yesuske tbunanke bonyo hyeran, kali nenmo hye ohe Yesuske myaty de. Lemade yabuk a suldatare wait uskwe khatuke ma yena i de byohe, “Yesuske myaty deny e?” ");
INSERT INTO slu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ode kyoat Pilatus itomolu suldatare wait uskwe khatuke ma ihalas i koldyesy bonyo, lyura Yesuske tbunan desy ti Yusuf. ");
INSERT INTO slu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lemade Yusuf lyiw a kain bokbok malilikwe, maktei o bya ti nyauk Yesuske tbunanke toha tul masanwalw ike. Inauk Yesuske tbunanke maktei bonyo yal kain bokbok maliliw desy, ma yal ma hyul a Yesuske tbunan desy. Ode bya ti yamlin ti bobke kuranke. Maktei bonyo lyilik hatw lan ne ti kyeteta bobke kuran desy. Bobke kuran neke heit a irire rhak hatkwe ksouke ma kuran. ");
INSERT INTO slu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kyoat desy dakun o Maria Magdalena, ode Maria Yoses ena neke ratos Yusuf ma tyutuk Yesuske tbunanke ti bobke kuran desy. ");
INSERT INTO slu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kyoat sew Inamreske kisakut bonyo, Maria Magdalena ode Maria Yakobus ena ne, ode Salome rba ti rliw a nyatasa o nul mahon a mtelas nekre, kali ana bolbol o rbuma rbai bobke kuran Yesuske ramlin I tike, ma ana rkasa nam raliw desikre ti Yesuske tbunanke, ma ktyoha Yahudi-nare wait ktela kubkubakke. ");
INSERT INTO slu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ode sew mingguke wasi bolbolbol ne, ma sekwe nenmo ibetik ne, desikeo rbai wen ramlin Yesuske tbunanke tike. ");
INSERT INTO slu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ode ti salke kditlalan, desikeo it de tyanuk ti it ma rbohe, “Ana ese syaluk ity ma lyilik hatw lan ranal ma raeteta bobke kuran ramlin Yesuske tbunanke ti desy de?” ");
INSERT INTO slu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Keskyede kyoat ranait bobke kuran ramlin Yesuske tbunanke ti desy bonyo, ratos o hatw lan desike kiblily ei kserike de. ");
INSERT INTO slu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lemade wamfwet desikre rsukar bai bobke krala desy. Ode kele rsumuk mait sir kali ratos o lyalaw murke it, ma hyonak rabit narnarw bokbokbokke ma tyaklulw ti bobke krala desy kseri wanke. ");
INSERT INTO slu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Keskyede lyalaw mur desike tyanuk ti sir ma byohe, “Kete mimtaut! De khwe ohe, miobak Yesus Iry a Nazaret a rabakw a I ti tul masanwalw ike ne. I neke myorif huruk. Ode lema imin ne de. Myatos! Wen a ramlin I tike ne. ");
INSERT INTO slu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dendye mbya, ode mtyanuk ti wasi matoha Iare, ode Petrus dakun ma mbyohe, ‘Yesuske myuna e bai propinsi Galileake de. Ti soke ana nenmo minal a myor I, kola dene tun itanuk a kmuna ti e desy.’” ");
INSERT INTO slu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Keskyede wamfwet desikre ramlulurw, kali ramtaut ma ksyeman sir, desikeo ra-la toha bobke kuran desy. Ode lema rares ma rahes namit-namit ti irkye it elik, kali ramtaut a nggora. ");
INSERT INTO slu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kyoat Yesuske myorif huruk, ti sew mingguke wasi bolbolbol ne, desikeo syusu tenanke kmunmunmuna ti Maria Magdalena. Maria neke, ain maba sokre Yesuske yesak ngkeskwakwe itw toha i de. ");
INSERT INTO slu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dendye Maria bya ti yabrita ti iry a kyalamo matoha Yesuske ne ohe, Yesuske myorif huruk de, kali myatakit I de. Kyoat desy o iry desikre malmata ralatare ksyal ma rser a nggora. ");
INSERT INTO slu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ode kyoat iry desikre ratomolu ohe, Yesuske myorif huruk de, ma syusu tenanke ti Maria de, keskyede iry desikre lema rtohak nam Maria itanuk desy. ");
INSERT INTO slu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Maktei o Yesuske yala matake ma kihihi i, ma kola iry salik, ma syusu tenanke huruk ti wasi matoha Ike irkye enaru. Neke kdi ti ti kyoat iry deru desike malmata rlakut rosy a Yerusalem ma rbai hnuke it. ");
INSERT INTO slu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dendye iry deru desike rulak sir ma rahes ti liatare, keskyede liat desikre lema rtohak sir dakun. ");
INSERT INTO slu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ode sekwe enai ne kyelak eta bonyo, Yesuske syusu tenanke ti wasi matoha I dehean a kresi sasam desy, ti kyoat a malmata raknam. Ode tyerik sir, kali usut a khatunare malkyakaw ma lema rtohak iry a raseak I a kmuna ti imorif huruk ne. ");
INSERT INTO slu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lemade Yesuske tyanuk ti sir ma byohe, “Musti mo mbyai wen kabei ta kabei ti nuske ktem ne, ma myabrita Brit Eraske ti esei ta esei bo. ");
INSERT INTO slu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ode kolnye esei desike tyohak Yaw ode rbabtis i, desikeo ana Hulasokwe yaorif a i. Klala esei desike lema tyohak Yaw, desikeo ana Hulasokwe yukun a i. ");
INSERT INTO slu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dendye kolnye esekar desike rtohak Yaw, desikeo ana kal wasikw haretke ti sir ma bisa ma rala ktela masalsyalik iare kola ne: ral Anikkwe ma resak ngkeskwaure, ode kolnye ratun, desikemo bisa ma ral tel a salno salik lema rahe nekre, ma ral ma ratunak. ");
INSERT INTO slu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ode kolnye rkumak manunkwe,desikeo ana lema rmaty. Ode kolnye renw a racunke, desikeo ana lema rmaty dakun. Ode kolnye rsaa simat ti iry a isy masunure, desikeo iry isy masunw desikre ana eras sir elik.” ");
INSERT INTO slu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ode kyoat Yesuske itun a yor wasi matoha Iare maktei, desikeo Hulasokwe syalak I bai wen sra eraske, ma tyaklulw ti Hulasokwe seri wanke. ");
INSERT INTO slu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lemadendye Yesuske wasi matoha Iare rba ti rabrita Brit Eraske ti kabei ta kabei bo. Ode ity Ebutke dakun o yor sir ti wait karyaare. Ode yal wasi haretke ti sir ma kyalkyaw sir ma rala ktela masalsyalik iare, ma ksyusu ohe brit ratanuk ne Brit a mlakye.");
INSERT INTO slu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teofilus amam lan o, kyala kyosy khyehyeike iry ribunke rmatakit ktela ribun a Yesuske iala nekre. Maktei o sir ne rlosu nam ramatakit desikre ma ity, ode rabrita Hulasokwe tunanare dakun. Lemade iry desikre dum a ralkyaw sir ma rkesy a brit ne ma kola dene brit a iry mamunanare ralosu ma ity ne. ");
INSERT INTO slu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lemadendye knwah lola mamamak a brit nekre mumu ti kyala kyosy khyehyeike ma ti kyait senwe. Kali krwekan a mlakye ma kkwesy brit nekre ti kitabke ti o. ");
INSERT INTO slu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Amo, Teofilus. Kkwesy kitab ne ti o, ma mhwe ohe nam raajar ti o mumu nekre, mlay ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kyoat a Herodes ika raja ti propinsi Yudeake, desikeo iry mabaa klen ti irkye yor Hulasokwe neke, it ma ani Zakharia ma yosy a lui Abiake. Ma sawa-na ani Elisabet. Iry deru neke Harun tesnwo natu sir. ");
INSERT INTO slu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iry deru neke mlay a sir ti Hulasokwe, ode ramorif neke rtoha haret o tnyetak ity Ebut Hulasokwe itenukare mumu, ma lema raka salat. ");
INSERT INTO slu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Keskyede deruke lema raka anat, kali Elisabet ne myakw, ode deruke dakun o enmosw o amosw sir de. ");
INSERT INTO slu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekwe it bonyo, iry mabaa klen ti irkye yor Hulasokwe neke raeluk sir ma lui Abiake rkarya, neke Zakharia wait luike. Mane Zakharia kyarya wasi karya ibaa klen ti irkye yor Hulasokwe ne, ti Hulasokwe Seike. ");
INSERT INTO slu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ode kyalamo iry mabaa klen ti irkye yor Hulasokwe neke wait a ktelake ma rhuty aluri, ma ksyusu ohe ese ana syukar ei ity Ebut Hulasokwe Seike kralake ti tyunw natke kduduhan mahon a mtelaske. Desike bonyo aluri rahuty desike ksyusu Zakharia. ");
INSERT INTO slu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lemade Zakharia syukar ei Hulasokwe Seike kralake ma tyunw a natke kduduhan mahon a mtelas desy. Ma wait a ktelake de ma kolnye irkye syukar ei kralake ma tyunw a natke, desike bonyo mamin mlosire rsambayan. ");
INSERT INTO slu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kyoat desy dakun o ity Ebut Hulasokwe wasi nyaso manosy laitke syusu i ti Zakharia, ma imdiry ti latke kseri wanke, neke lat blyawanke ma kyalamo rtunw natke ti. ");
INSERT INTO slu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kyoat Zakharia iatos nyaso manosy lait desy, desikeo kele rsumuk mait i ode imtaut a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Keskyede nyaso manosy lait desike tyanuk ti Zakharia de byohe, “Zakharia, kete mumtaut, kali Hulasokwe tyomolu wasimw sambayanke de, ma ana sawamw Elisabet idur hahak naman wamwankye it ti o, ode maki anike ti Yohanes. ");
INSERT INTO slu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ode kyoat naman desy radur i, ana mumukmuka o a ksyalik, ode iry ribunke ramukmuka ramarmara sir dakun. ");
INSERT INTO slu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kali ktyoha ity Ebut Hulasokwe naman neke ana iry lan a i. Ode lema bisa ma yenw tasy maiskye kwen makitkye ode lema dakun ma yenw tuake elik. Ode kyoat imin ti ena-na fteike, desikeo Hulasokwe Memeanke kbyenw a i de. ");
INSERT INTO slu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ode ana yala iry Israel ribunke ma rulak sir ma rtoha Ebut Hulasow a rasambayan tike. ");
INSERT INTO slu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma naman neke Hulasokwe Memeanke kyal malkyakakwe ti i, kola heitlulswo Hulasokwe Memeanke kyal malkyakakwe ti Elia, Elia neke iry a manety Hulasokwe wasi nyanoke. Ma Hulasokwe yaso naman neke ma myuna ity Ebutke ma ti yala amamare ralatare ma kyulak i ti anatare. Ode yala iry lema matomolu Hulasokwe, ma ralatare kyulak i ma huhutare kola iry a mlaire. Yala ktela nekre mumu ma irire rsosan ralatare, ma rakita ity Ebutke.” ");
INSERT INTO slu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Lemade Zakharia tyanuk ti nyaso manosy lait desy de byohe, “Kala kolkyabei ma khwe o nam nekre ana kdi ti de? Mane yaw neke amosw yaw de ode sawakw dakun o enmosw a i de.” ");
INSERT INTO slu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lemade nyaso manosy lait desike hyalas i de byohe, “Yaw neke Gabriel yaw, ma yaw neke kumdiry ma kswara Hulasokwe, ode Hulasokwe yaso yaw ma kety brit eras ne ti o. ");
INSERT INTO slu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Keskyede oi neke lema mtwohak nam kutanukare. Lemadendye nunumkwe ktem ma lema mutun a musobu nini kyait sew a Hulasokwe itunik ma nam kutanuk desikre mumu neke kdi ti bain-bain.” ");
INSERT INTO slu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iry ribun mamin ti mlosy desikre rakita Zakharia. Ode iry desikre rheran ti wasi inanggonkwe ti Hulasokwe Seike kralake. ");
INSERT INTO slu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kyoat ibetik bonyo, tyuky ti de tyuky ma, kali nunuke ktem, lemade iry desikre rhe ohe, Zakharia myatakit nam dum ti Hulasokwe Seike kralake. ");
INSERT INTO slu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Keskyede Zakharia ana kyarya wasi kmata ikarya ti Hulasokwe Seike krala desy ma sekwe ktei, desikeo nenmo yulak i bai wasi sekye. ");
INSERT INTO slu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lema soso bonyo Zakharia sawa Elisabet yor tenanke. Ode hulke enasim ne lema byetik toha wasi sekye kralake. ");
INSERT INTO slu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ode Elisabet tyanuk de byohe, “Ity Ebut Hulasokwe yal ktela eras ne ma yaw, ode senweke lyobak yaw, ma yaditi irire tunat ranal ma rahmway yaw ne.” ");
INSERT INTO slu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kyoat Elisabet yor tenanke ma wasi hulke nem, desike bonyo Hulasokwe yaso wasi nyaso manosy laitke neke Gabriel huruk, ma byai hnu Nazaretke ti propinsi Galileake. ");
INSERT INTO slu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hulasokwe yaso a Gabriel ma bya ti syeak warar murke it neke ani Maria. Ma Maria neke ika lyalaw yor wamwankye it ma ani Yusuf. Yusuf neke Daud tesnwo natu i. ");
INSERT INTO slu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nyaso manosy lait desike mya ma syukar ei Maria wasi sekye ma byu ti i de byohe, “Maria o, ity Ebut Hulasokwe yal eraske ti o de, ode yor a o.” ");
INSERT INTO slu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kyoat Maria itomolu tun desike bonyo, kele rsumuk mait a i ode ryekan ti ralake de byohe, “Tun neke kbuanke kolkya?” ");
INSERT INTO slu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Lemade nyaso desike tyanuk huruk de byohe, “Hei Maria, kete mumtaut, kali oi neke Hulasokwe yal eraske ti o de. ");
INSERT INTO slu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ode ana mor tenamkwe, ma ana kyait wasimw hul o sew kdi ti, ma mudur hah bonyo, anamkwe wamwany a I. Desike bonyo maki anike ti Yesus. ");
INSERT INTO slu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I neke ana lan I a ksyalik, ode I neke rbu de rbohe, ‘Hulasow Lan Lahukke anan a I.’ Ode ity Ebut Hulasokwe syusu I ma ana ika raja kola ebnwo matruma raja Daud. ");
INSERT INTO slu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ode I neke ana hyareta kola rajake, ti Yakub tesnwo natu ma lema kimres de kyal nini nam.” ");
INSERT INTO slu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Keskyede Maria tyanuk ti Hulasokwe wasi nyaso desike de byohe, “Tun mulosu neke kyala kolkyabei ma ana kdi ti de? Mane lenla wamwankye it a yenah yor yaw elik ode?” ");
INSERT INTO slu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lemade nyaso manosy lait desike hyalas i de byohe, “Hulasokwe Memeanke ana kyorw ti o, ode Hulasow Lan Lahukke amalkyauke ana kyaoa o, ma ana naman mudur ti desike nelnyely a I, ode ana rbu de rbohe, ‘Hulasokwe Ananke.’ ");
INSERT INTO slu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ode mnwenas hatnimamw Elisabet, irire rbohe myakw ode enmosw i de, keskyede yor tenanke ma wasi hulke nem de, ma naman mamin fteike krala desike wamwany a i. ");
INSERT INTO slu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kali ti Hulasokwe mo lema kika namit-namit ma lema yala hye ode lema yala yal.” ");
INSERT INTO slu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Lemade Maria tyanuk ma byohe, “Yaw neke ity Ebut Hulasokwe wasi at yaw. Lemamo nam ribun lan neke ana kdi ti ma yaw kola nam mutanukare.” Dendye nyaso manosy lait desike bya. ");
INSERT INTO slu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lema soso bonyo Maria lyahlaha mirin ma lyakut bai Elisabet wait hnuke ti kususwanare, o propinsi Yudeake. ");
INSERT INTO slu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kyoat inait hnu desy bonyo Maria syukar ei Zakharia wasi sekye ma syeak Elisabet ma yabuk i de byohe, “Awa!” ");
INSERT INTO slu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ode kyoat Elisabet itomolu Maria telake bonyo, naman mamin ti Elisabet fteike krala desy iwaway mait. Kyoat desike dakun o Hulasokwe Memeanke kbyenw a Elisabet. ");
INSERT INTO slu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Lemade Elisabet telake lan ma tyanuk ti Maria de byohe, “Maria, eraske kimin o a mmwesan, ma mbwilak wamfwet nekre mumu. Ode eraske kimin naman ana mudur ti desy dakun. ");
INSERT INTO slu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ode esei yaw mane ity Ebutke ena-na yoly ma iseak yaw ne de? ");
INSERT INTO slu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maria, khwe ohe ity Ebutke ena o, kali kyoat kutomolu telamkwe bonyo, naman mamin ti fteikkwe krala neke iway mait kali imukmuka i a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ode eraske kimin o, kali mtwohak ohe tun Hulasokwe itanuk ti o desikre, ana kdi ti.” ");
INSERT INTO slu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lemade Maria tyanuk ma byohe, “Ralakkwe klyeru Hulasokwe Anike, ");
INSERT INTO slu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ode ralakkwe krala ne kimukmuka i ti Hulasokwe, kali yaorif yaw. ");
INSERT INTO slu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ode I neke ralake eras ti wasi makarya kakan lahuk yaw ne. Ode kyala kyosy ne ma kiba knaru ne, ana iry mamin nuske ktem ne rtanuk ohe, eraske kimin a yaw, ");
INSERT INTO slu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kali Hulasokwe yala ktela eras lan nekre ma yaw. Hulasow neke malkyakaw lahuk a I ode anike nelnyely. ");
INSERT INTO slu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ode syusu wasi loblobakke ti iry mamtaut Iare, kyala kyosy khyehyeike ma ti ktyutw teike. ");
INSERT INTO slu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ode the ohe Hulasokwe malkyakaw I kali: Iskyui-iskyay iry matun bakbakare. ");
INSERT INTO slu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iry lan maharetanare mo, nyauk sir toha wenatare, ode byitil iry manauk a tenat ma babaf nekre. ");
INSERT INTO slu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iry mamlarare mo, yal mauskwe ti sir ma kinanal sir, ode yesak iry maka wait malolire ma rba o ramranran. ");
INSERT INTO slu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ode Hulasokwe syaluk a iry Israel a ity ne, neke wasi makarya ity, ma lyobak ity, kali inenenas wasi ");
INSERT INTO slu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tnyetak ihatetak ti Abraham yor tesnwo natu ity ne ti kiba knaru ne.” ");
INSERT INTO slu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kyoat Maria itanuk koldyesy maktei, yor Elisabet ti Elisabet wait sekye anakyai hulke enatelw. Desike bonyo nenmo Maria yulak i bai wasi sekye. ");
INSERT INTO slu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lemade kyait Elisabet wasi sekwe bonyo, idur hah ma ananke wamwany a i. ");
INSERT INTO slu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kyoat wasi serkyait o amno wai nekre ratomolu ma ity Ebut Hulasokwe syusu wasi loblobakke ti Elisabet, desike bonyo iry desikre raktemtem a ramukmuka sir a ror i. ");
INSERT INTO slu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ode kyait naman kakan radur desike wasi sekwe walw bonyo, iry desikre rawahuk sir huruk ma rma ma rseak naman kakan desy ma ratosa i, ode rbuma raki anike ti Zakharia ma ktyoha ama-na anike. ");
INSERT INTO slu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Keskyede ena-na byu de byohe, “Lema! I neke raki anike ti Yohanes.” ");
INSERT INTO slu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Keskye iry desikre rbu ti Elisabet de rbohe, “Ti wasimy sekye krala desike, lema kika any maoly desy.” ");
INSERT INTO slu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lemadendye iry desikre rtuky ti de rtuky ma ti naman desike ama, ma rena ohe, “Mbwu ma naman ne ani ka?” ");
INSERT INTO slu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Desikeo Zakharia iten hatw rakeskye, ode kyesy ma byohe, “Naman ne ani Yohanes.” Lemade iry desikre mumu ne rmetratw mait. ");
INSERT INTO slu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kyoat desike Zakharia nunu ktem desy, itun mait, ode lyeru Hulasokwe Anike. ");
INSERT INTO slu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lemade iry mamin ti desikre mumu ne ramtaut a Hulasokwe. Ode ktela madi ti desikre mumu ne rahes ma ksyorw hnuare mumu ti kususwanare, o propinsi Yudeake. ");
INSERT INTO slu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ode iry desikre mumu, neke ratomolu ktela desy, rrekan ti ralatare ma rbohe, “Kibai lulkwe ne, naman ne ana ika sai de?” Kali rhe o Hulasokwe yor a i. ");
INSERT INTO slu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ode naman kakan desike ama Zakharia neke, Hulasokwe Memeanke kbyenw a i, ma tyanuk nyano manosy Hulasokwe de byohe, ");
INSERT INTO slu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mmya ma tleru ity Ebut Hulasokwe Anike, neke Israel-are ity wait Hulasokwe, kali mya de, ma yoryeta wasi irire, ode yaditi sir toha iry mamnisik sirare. ");
INSERT INTO slu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ode Hulasokwe yal iry a mambrebat maorif irkye ne ma ity. Iry neke raja Daud tesnwo natu I. Raja Daud neke Hulasokwe wasi makarya i. ");
INSERT INTO slu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ktela nekre kdi ti mumu ma ktyoha tun heitlulswo iry manety Hulasokwe wasi nyanoare ratanukare. Iry nekre nelnyely a sir. ");
INSERT INTO slu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dendye iry neke mya ma yaditi ity toha iry mamnisik ity nekre ti rahareta ity ne. ");
INSERT INTO slu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hulasokwe yaso iry ne ma yaorif ity, ma ksyusu Hulasokwe wasi loblobakke ti ity ebnwo matrumat, ma ktyoha wasi tnyetak nelnyely heitlulswo. ");
INSERT INTO slu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Neke ihwab ti ity musut Abraham de, ode tyetak ma ");
INSERT INTO slu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yoryeta ity, ma yaditi ity toha iry mamnisik itire, ma kete tamtaut ma tsambayan ti I. ");
INSERT INTO slu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ode yala ity ma nelnyely a ity, ma tamin mlakye, ode tmorif tor I ti kiba knaru ne.” ");
INSERT INTO slu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lemade Zakharia tyanuk ti ananke de byohe, “Hei anakw o, ana irire rtanuk ma rbohe oi neke iry manety Hulasow Lan Lahukke wasi nyanoke. Kali Hulasokwe yaso o ma mmwuna ti mswoli salke ma kikita ity Ebutke, ");
INSERT INTO slu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ode mabrita ti Hulasokwe wasi irire ma rhe ohe kolkyabei ma Hulasokwe syos wait lim o sal nekre ma yaorif sir. ");
INSERT INTO slu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kali Hulasokwe ralake eras ode ilobak iry, lemade yaso ity Ebutke ma mya ma yait ity ti ne. Wasi mama neke kola dene sekwe ibetik ma iran ti bolbolbol ne. ");
INSERT INTO slu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Koldyesy dakun ti ity Ebutke wasi madelah manosy laitke, kdyelah iry mamin ti kelerakok a ramtaut matmyatkye ne. Ode yeuk sir ei sal mabai eraske ma ika eras sir a ror Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ode Zakharia anan desike lyean ma lan i, ma wasi tohtohakke kbya nini malkyakaw, desike bonyo, byai wen malosy-loskye ma imin ti nini kinait sekwe bonyo, nenmo ti yabrita nyano manosy Hulasokwe ti Israel-are. ");
INSERT INTO slu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kyoat kaisar Agustus neke, ika raja ti nuske ktem Romawike, desikeo yal haretke ti wasi melare, ma rbaa roli nusare ode hnuare, ma ral iry mamin ti nuske ktem Romawi desike anitare mumu ma hye aryaritare. ");
INSERT INTO slu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ktela ranal any neke nenmo rala ti nuske ktem Romawi ne, ode kyoat desy dakun o Kirenius ika gubernur ti propinsi Siriake. ");
INSERT INTO slu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lemadendye iry ribun lan desikre mesmesa rulak sir bai hnuat ti ral anitare ti. ");
INSERT INTO slu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kola dene Yusuf ne dakun ma lyakut yosy hnu Nazaretke ti propinsi Galileake ma byai hnu Betlehemke o a propinsi Yudeake. Hnu Betlehem neke heitlulswo raja Daud hnu radur i tike, lemade Yusuf byai hnu so, kali raja Daud tesnwo natu i dakun. ");
INSERT INTO slu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dendye Yusuf yor warara Maria ne rbai a hnu Betlehemke ti ral anitare o so. Kyoat desike Maria yor tenanke de. ");
INSERT INTO slu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kyoat ramin o Betlehem, desikeo kyait Maria wasi sekwe ma idur hah. ");
INSERT INTO slu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lemade idur hah bonyo ananke wamwany a I, neke naman auskwe. Ode ral taiske khisike ma rasekir eta I, ma rulik I ti biby o saby wen raknam tike kralake, kali lema kika sey ma ramin ti. ");
INSERT INTO slu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sew a Yesuske radur i desy ma wasi metdyetke, desikeo iry majaga dombanare dum a ramin ti wen knanike it ma sitw o tnyei ktyuhw ti ma rajaga wait dombanare ti. Wen desike lema soso toha hnu Betlehemke. ");
INSERT INTO slu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kyala mait bonyo, ity Ebut Hulasokwe wasi nyaso manosy laitke syusu i ti iry desikre, ode ity Ebut Hulasokwe wasi madelahke kdyelah sir, lemade ramtaut a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lemade nyaso manosy lait desike byu ti sir de byohe, “Kete mimtaut, kali kuma neke kety a brit eraske ti e. Brit neke ana kyala iry mamin nuske ktem ne mumu ma ramukmuka sir a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kali senweke Iry Maorif irkye radur I ti e, o a Betlehem raja Daud wasi hnuke. Naman ne ity Ebut a I, ode I ne Hulasokwe syusu I ma ika Raja ode yaorif irkye. ");
INSERT INTO slu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Neke wasi nyatoske kolnye, ana mbyai Betlehem, ode kolnye myatos naman kakanke it ma ral taiske khisike ma rasekir eta I, ode rulik I ti biby o saby wen raknam tike, desikemo naman ne I desy.” ");
INSERT INTO slu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kyala mait bonyo Hulasokwe wasi nyaso manosy laitke, ribun sir a ksyalik, neke ramin ma ror nyaso mamuna desy, ma raktemtem a rleru Hulasokwe Anike ma rbohe, ");
INSERT INTO slu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tleru Hulasow mamin ti laitke sra lahuk soke Anike, ode eras ti iry a ity Ebut Hulasokwe idakin sir ti lasmyerke khaha ne.” ");
INSERT INTO slu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ode nyaso desikre ratanuk maktei bonyo, rulak sir ei wen sra eras Hulasokwe imin tike, ode iry majaga domba desikre it de tyanuk ti it ma rbohe, “Mmya ma tbai Betlehem ma ti tatos naman kakan radur ti ne, kola ne nam ity Ebut Hulasokwe lyosu ma ity ne.” ");
INSERT INTO slu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lemade iry desikre rlahlaha mirin ma rbai Betlehem, bonyo rait Maria yor Yusuf, rtabal naman nenmo radur ti ne, ma rulik I ti biby o saby wen raknam tike. ");
INSERT INTO slu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ode iry majaga domba desikre ratos naman desy maktei bonyo, rbetik ti rabrita naman desy ma kola tun ratomolu toha nyaso manosy laitke. ");
INSERT INTO slu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ode iry matomolu brit a iry majaga domba desikre ratanukare, rmetratw mumu. ");
INSERT INTO slu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Keskyede Maria syosan a ktela iatos o itomolu nekre mumu ode mamwaw i ma ryekan ti ralake bo. ");
INSERT INTO slu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Maktei bonyo iry majaga domba desikre rulak sir bai wen rajaga domba tike, ode raora o rleru Hulasokwe Anike, kali nam ratomolu ode ramatakit desikre mlay mumu, ma kola tun Hulasokwe wasi nyaso manosy laitke itanukare. ");
INSERT INTO slu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ode kyait naman desike wasi sekwe walw bonyo ratosa I, ode raki anike ti Yesus. Any neke ne kola Hulasokwe wasi nyaso manosy laitke itanuk ti Maria ne, kyoat Maria lenla inor tenanke ne. ");
INSERT INTO slu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ode kyait naman desike wasi sekwe hean-at bonyo, Maria yor Yusuf rala ma rbai Yerusalem ma rabar nam ti Hulasokwe ma Maria nelnyely a i, ma ktyoha tnyetak Musake. Dendye Maria ode Yusuf ror naman desy dakun ma rbai Yerusalem ma ral naman desy ti ity Ebut Hulasokwe, ");
INSERT INTO slu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kali rkesy ti tnyetak Musake ohe ity Ebut Hulasokwe tyanuk de byohe, “Kolnye naman radur ti a kmunake wamwany a i, musti mo myal i ma Yaw.” ");
INSERT INTO slu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kyoat ranait bonyo, Maria yor Yusuf ral manuke enaru, ma rabar ti Hulasokwe ma ktyoha tnyetak ity Ebut Hulasokwe, ti heitlulswo rakesy ti Kitab Lanke, ma rabar manu lakterkwe enaru dete lemamo manu hahkye enaru. ");
INSERT INTO slu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kyoat desy dakun o ti Yerusalem neke, irkye it ma ani Simeon. I neke iry a mlakye ode indil ma tyoha tnyetak Musake kali imtaut Hulasokwe, ode Hulasokwe Memeanke kimin a i, ode ikita sew Hulasokwe ana yaditi Israel-are toha masunkwe ne. ");
INSERT INTO slu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ode Hulasokwe Memeanke klyosu ti Simeon dakun de, ma kbyu ohe i neke ana lenla myaty kolnye lenla myatakit Iry a ity Ebut Hulasokwe isusu ma ika Raja ode iaorif irkye ne. ");
INSERT INTO slu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dendye Hulasokwe Memeanke kyor Simeon bai Hulasokwe Seike. Ode kyoat Maria ode Yusuf ror Yesuske rmai Hulasokwe Seike, ma ti rala ktelake ma ktyoha tnyetak Musake bonyo, Simeon myatakit a sir. ");
INSERT INTO slu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lemade Simeon byalan sir ma yal naman desy ma hyot a I, ode lyeru Hulasokwe Anike ma byohe, ");
INSERT INTO slu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Amam Lan O, senweke tun mutanuk ma yakwe kdi ti de. Lemade mlwura wasimw makarya yaw ne, ma kmwaty mo kosy eraske. ");
INSERT INTO slu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kali matakw neke kyatos naman munal I ma yaorif aramy ne de. ");
INSERT INTO slu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","I neke mtwutuk I ma nuske ktem ne mumu ne ratos I, ");
INSERT INTO slu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ma wasi madelahke kdyelah salke ma mlay, ti iry a lema Yahudi-nare, ma rma ma rait a O. Ode wasi madelahke kdyelah wasimw iry a Israel-are dakun.” ");
INSERT INTO slu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lemade Maria yor Yusuf rmetratw ti ratomolu Simeon wasi sambayanke kisike, ti khyali anatke ne. ");
INSERT INTO slu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lemade Simeon iten Hulasokwe ma yal eraske ti Maria yor Yusuf. Maktei o, tyanuk ti Maria ma byohe, “Naman neke Hulasokwe syusu I ode khyali I, Hulasokwe ana yaorif iry ribun mamin ti Israel ne ode ana yamatik iry ribun mamin ti Israel ne dakun. Ode naman neke yeluk nyatos manosy Hulasokwe, keskyede irire ribun ana lema rou I. ");
INSERT INTO slu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lemadendye naman neke yeluk nyatos ma khyury a irire ma rhura ralat a krala eras o atyat nekre ei mloskye. Klala Maria, oi neke ralamkwe ana ksyal ma kdyohut, kola dene krakye kiutw o ne.” ");
INSERT INTO slu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ti Hulasokwe Seike dakun o iry manety Hulasokwe wasi nyanoke it, neke wamfwet a i, ma ani Hana, ma Fanuel anan i, neke Asyer a tesnwo natu sir. Kyoat Hana isa ma ainke itw bonyo lai-na myaty. Ode Hana neke syom nini a wasi ainke hean-walw kresi enaat ma enmosw a i de. Ode sewah o msarin nekre imin ti Hulasokwe Seike bo, ma yas ode syambayan ti Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kyoat Simeon itanuk maktei bonyo, Hana bya ti yait Maria yor Yusuf, ode Hana lyeru Hulasokwe Anike khyali Yesuske. Maktei o yabrita naman desy ti iry ribun lan makita Hulasokwe, ti ana ima ma iaditi Israel-are toha masunkwe ne. ");
INSERT INTO slu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ode kyoat Maria yor Yusuf rala ktelanare mumu ma ktyoha tnyetak ity Ebut Hulasokwe maktei bonyo, rulak sir bai wait hnu Nazaretke o a propinsi Galileake. ");
INSERT INTO slu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naman desike lyean ma lan I ode malkyakaw I, ode heheke kimin a I, ode eras manosy Hulasokwe kbyenw a I. ");
INSERT INTO slu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ain kyaki-kyaki nekre Yesuske ena-na yor ama de rbai Yerusalem ti rtoha Yahudi-nare wait sew lan Paskahke. ");
INSERT INTO slu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kyoat Yesuske wasi ainke hean a kresi enaru bonyo, ena-na yor ama de ror I ma rbai Yerusalem dakun ti rtoha Yahudi-nare wait sew lan Paskahke. ");
INSERT INTO slu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kyoat sew lan Paskah desike kisakut bonyo, Maria yor Yusuf rulak sir ma rbai wait hnuke, keskye Yesuske lema yor sir ma rba de imin ti Yerusalem, ma ena-na yor ama de lema rhe I. ");
INSERT INTO slu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kali ena-na yor ama de rrekan o I ne inor iry ribun malakut desikre. Ode rlakut nini sekwe bya bonyo, ena-na yor ama de rseak robak I ti lian o hatnimat ralakut ranor desikre. ");
INSERT INTO slu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Keskyede lema rmatakit a I, lemade rolik sir bai Yerusalem huruk ma ti raobak I o so. ");
INSERT INTO slu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ode robak I ti de robak I ma nini sekwe enatelw bonyo nenmo rait a naman desy ti Hulasokwe Seike, desyo malmata tyaklulu yor tuanggurw Yahudi-nare ma tyomolu sir ode yena sir ti tun sai ta sai bo. ");
INSERT INTO slu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ode iry ribun matomolu I ma ihalas tun ribun raena toha Iare, rmetratw ti wasi heheke kali tun ihalasare malalay bo. ");
INSERT INTO slu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ode kyoat ena-na yor ama de ratos I bonyo, rmetratw, lemade ena-na tyanuk ti I de byohe, “Toto, kyanmwane muala ma aramy kolnye de? Lema mumin ma khyury ma ara huamire kyamlurw ti miobak a O ne.” ");
INSERT INTO slu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lemade hyalas sir de byohe, “Eno, kyanmwane miobak Yaw ti de miobak Yaw ma ne de? De lema mhye ohe Yaw neke musti mo kumin Amaku Seike e?” ");
INSERT INTO slu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Keskye ena-na yor ama de lema rhe tun itanuk ti sir desy kbuanke. ");
INSERT INTO slu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lemade ena-na yor ama de ror I ma rulak sir bai hnu Nazaretke ma rmon ti. Ode naman desike myorif ti ena o ama-na wait snurat rasurat ti Iare. Ode ena-na syosan a ktela ribun desikre mumu ti ralake kralake. ");
INSERT INTO slu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ode Yesuske lyean ma lan a I, ode wasi heheke ktyabal huruk, ode Hulasokwe lyobak I, ode ribun a rdakin I dakun. ");
INSERT INTO slu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Seure kiliku i ma kaisar Tiberius ika raja ti nuske ktem Romawike ma hyareta ainke hean a kresi enasim de. Kyoat desy dakun o Pontius Pilatus ika gubernur ti propinsi Yudeake, klala Herodes a hyareta ti propinsi Galileake. Ode Herodes wai Filipus neke hyareta ti propinsi Itureake ktyabal propinsi Trakhonitiske, klala Lisanias hyareta ti propinsi Abilene-ke. ");
INSERT INTO slu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ode Hanas yor Kayafas neke uskwe khatu lan lahuk sir ti iry mabaa klen ti irkye yor Hulasokwe. Kyoat desy dakun o Yohanes a Zakharia ananke imin ti wen malosy-loskye, desikeo nenmo Hulasokwe lyosu nyanoke ti i ma ti yabrita ti irkye. ");
INSERT INTO slu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lemade Yohanes a byaa lyola iry mamin ti sah Yordanke kseri desy, ma yatela ti sir de byohe, “Mtyunik totamy atyat manety lim o sal desikre ba, ode mmya ma rbabtis e, ma Hulasokwe syos salamire ba.” ");
INSERT INTO slu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanes neke i ne heitlulswo Yesaya iry manety Hulasokwe wasi nyanoke ikesy ti wasi kitabke ohe, “Irkye it a yatela ti wen malosy-loskye de byohe, ‘Msyoli salke ode myaklol ma mlol, ma kikita ity Ebutke. ");
INSERT INTO slu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ktebtebanare desikemo myahlun, ode kususwan lan o kakan msyuyara ma mais, ode sal malekure desyo, myaklol ma mlol, ode sal mahoti-mahatar iare desyo myala ma mais. ");
INSERT INTO slu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ode iry mamin nuske ktem ne mumu ana ratos Hulasokwe ma yaorif irkye kolkyabei.’” ");
INSERT INTO slu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Maktei o Yohanes tyanuk ti iry ribun mama ma ibabtis sir desikre de byohe, “Hei iry ribun mahatw maola ni e, esei ne ibu ma mila myai ne de, ma masunw manosy Hulasokwe ana kima o lema kena e ne de? ");
INSERT INTO slu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kete mryekan ti ralamire de mbyohe, ‘Ana aramy myei wen sra eraske kali ara amamy Abraham.’ Lema koldyesy, kali Hulasokwe bisa ma yala hatw nekre ma ktyoy a iry ma Abraham anan sir dakun. Lemade kolnye mbyuma myei sal a mlakye, musti mo mtyunik totamy atyatare ba ma myala eraske aduk ma kola aw maisy eraske. ");
INSERT INTO slu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mnyenas! Hroke kimin de, ma ral ma ruly aw lema maisy eras desikre mumu ma ti kyait kawanare dakun, ode rotuk ei akye kralake.” ");
INSERT INTO slu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lemade iry ribun desikre rena Yohanes de rbohe, “Koldyesikemo ana aramy myala sai de?” ");
INSERT INTO slu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dendye Yohanes hyalas sir de byohe, “Kolnye esei desike wasi rabitke enaru, desikemo ihe ma yal sasam ti iry lema maka wasike, ode kolnye kabei desike ika hina kotw, desyo itera iry a lema maka hina kotkwe.” ");
INSERT INTO slu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ode iry maily usure rma dakun ma byabtis a sir, ode rena i de rbohe, “Tuanggurw, ana aramy myala sai de?” ");
INSERT INTO slu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanes hyalas sir de byohe, “Myily mo kete myily ma kbyilak haretke itunik ti eke.” ");
INSERT INTO slu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ode suldatare dakun o rena i de rbohe, “Ode aramy neke myala sai de?” Bonyo Yohanes hyalas sir de byohe, “Kete misoruk irire wait kubanare, ode kete mikakmet ma mtyudu irire ma khyury ma ramtaut e ma ral kuban ti e, de mimukmuka e a myor wasimy katy desikre bo.” ");
INSERT INTO slu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dendye iry ribun makita Iry a Hulasokwe isusu ma ika Raja ode iaorif a irkye neke, rrekan ti ralatare ma rbohe, “Anakyai Yohanes neke i ne Hulasokwe syusu i ma yaorif irire ne.” ");
INSERT INTO slu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dendye Yohanes hyalas iry ribun desikre ode tyanuk ti sir de byohe, “Yaw neke kbwabtis e a kyor werke ma kyabetar iblumire bo, klala Iry ana mama neke ana byabtis e a kyor Hulasokwe Memeanke ode akye ma ksyukar ma kyarya ti ralamy kralanare. Iry neke lan lahuk I ma byilak yaw, ma yaw ne lema kbwer o ktwahal ma kaka wasi dori-na ktasinare dakun. ");
INSERT INTO slu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ode Iry neke yola iry manal a klyehkye ma tyaik alyakwe ma nelnyely. Maktei o yal alyakwe kisi desy ma syosan ti sey nuskwe, klala kuhlanke yotuk bai akye kralake, neke ay a lema mamaty khyeke de kmyorif nini nam.” ");
INSERT INTO slu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanes tyanuk a ktela it ktela it ma yal ma syurat irire ti kyoat yabrita Brit Eraske ne. ");
INSERT INTO slu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Keskye Yohanes tyerik Herodes, iry lan mahareta ti propinsi Galilea ne, kali isaa yor Herodias, neke Herodes wai-na sawa, ode ktyabal wasi tot atyat salik iala nekre dakun. ");
INSERT INTO slu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Keskye Herodes lema byuma tyomolu Yohanes, de tyabal hatunare huruk ma lyuk Yohanes ei sey metmetke kralake. ");
INSERT INTO slu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kyoat Yohanes lenla ral i ei sey metmetke kralake bonyo, byabtis iry ribun desikre, desikeo byabtis Yesuske dakun. Ode kyoat ibabtis Yesuske bonyo, Yesuske syambayan, desikeo laitke kimlakat, ");
INSERT INTO slu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Hulasokwe Memeanke kyorw ti I, kola ne manu hahkye nyem ma tyuny a I. Ode Hulasokwe telake kbyetik kyosy laitke ma ktyanuk ti Yesuske ma kbyohe, “Oi neke Anakw a O, ma klwobak a O, ode kou O ti ralakkwe.” ");
INSERT INTO slu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kyoat Yesuske hyatuk wasi karyake bonyo anakyai wasi ainke hean-telw. Ode irire rarekanke o Yesuske ne ama Yusuf. Klala Yusuf ne ama Eli. ");
INSERT INTO slu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ama Matat. Matat ama Lewi. Lewi ama Malkhi. Malkhi ama Yanai. Yanai ama Yusuf. ");
INSERT INTO slu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf ama Matica. Matica ama Amos. Amos ama Nahum. Nahum ama Hesli. Hesli ama Nagai. ");
INSERT INTO slu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ama Maat. Maat ama Matica. Matica ama Simei. Simei ama Yosekh. Yosekh ama Yoda. ");
INSERT INTO slu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ama Yohanan. Yohanan ama Resa. Resa ama Zerubabel. Zerubabel ama Sealtiel. Sealtiel ama Neri. ");
INSERT INTO slu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ama Malkhi. Malkhi ama Adi. Adi ama Kosam. Kosam ama Elmadam. Elmadam ama Er. ");
INSERT INTO slu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ama Yesua. Yesua ama Eliezer. Eliezer ama Yorim. Yorim ama Matat. Matat ama Lewi. ");
INSERT INTO slu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ama Simeon. Simeon ama Yehuda. Yehuda ama Yusuf. Yusuf ama Yonam. Yonam ama Elyakim. ");
INSERT INTO slu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim ama Melea. Melea ama Mina. Mina ama Matata. Matata ama Natan. Natan ama Daud. ");
INSERT INTO slu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud ama Isai. Isai ama Obed. Obed ama Boas. Boas ama Salmon. Salmon ama Nahason. ");
INSERT INTO slu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason ama Aminadab. Aminadab ama Admin. Admin ama Arni. Arni ama Hezron. Hezron ama Peres. Peres ama Yehuda. ");
INSERT INTO slu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda ama Yakub. Yakub ama Ishak. Ishak ama Abraham. Abraham ama Terah. Terah ama Nahor. ");
INSERT INTO slu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ama Serug. Serug ama Rehu. Rehu ama Peleg. Peleg ama Eber. Eber ama Salmon. ");
INSERT INTO slu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon ama Kenan. Kenan ama Arpakhsad. Arpakhsad ama Sem. Sem ama Nuh. Nuh ama Lamekh. ");
INSERT INTO slu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh ama Metusalah. Metusalah ama Henokh. Henokh ama Yared. Yared ama Mahalaleel. Mahalaleel ama Kenan. ");
INSERT INTO slu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ama Enos. Enos ama Set. Set ama Adam. Ode Adam neke ama Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kyoat Yesuske rbabtis I, desikeo Hulasokwe Memeanke kbyenw a I. Lemade yulak I a yosy sah Yordanke bonyo, Hulasokwe Memeanke kyeuk I ma byai wen malosy-loskye. ");
INSERT INTO slu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ti wen desike ngkeskwaure wait uskwe khatuke hyury a Yesuske nini sekwe hean-at. Sew dehean-at desy dakun o Yesuske lema iknam, de imlar a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lemade ngkeskwaure wait uskwe khatuke tyanuk ti Yesuske de byohe, “Kolnye Hulasokwe Anan a O, desikemo maso hatw ne ma ktyoy a kotw.” ");
INSERT INTO slu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Keskye Yesuske hyalas i ma byohe, “Rkesy ti Kitab Lanke de, ma irkye imorif ne lema khyali kotkwe bo.” ");
INSERT INTO slu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lemadendye ngkeskwaure wait uskwe khatu desy yor Yesuske bai wen atatke it, ode syusu mait nuske ktem ne mumu ti Yesuske, ");
INSERT INTO slu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ma tyanuk ti I de byohe, “Nam ribun-ribun kuhareta nekre ktyabal malolkye ana kal ti O ma mhwareta, kali nam ribun nekre Hulasokwe yal ma yaw de, ode ana kdwakin esei ta esei, desyo kal ti i. ");
INSERT INTO slu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lemadendye kolnye mswakitil ode mou ma yaw, desikemo nam ribun nekre ana wasimw.” ");
INSERT INTO slu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Keskyede Yesuske hyalas i ma byohe, “Rkesy ti Kitab Lanke de, ma musti mo irkye syakitil ode you ti Hulasokwe, ode tyoha ma syambayan ti I a myesan bo.” ");
INSERT INTO slu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lemadendye ngkeskwaure wait uskwe khatu desy yor Yesuske bai Yerusalem, ma ramdiry ti Hulasokwe Seike wasi embuhkwe, ode tyanuk ti I de byohe, “Kolnye Hulasokwe Anan a O, desikemo mnwusuk a mosy ne ei hahke nde. ");
INSERT INTO slu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kali rkesy ti Kitab Lanke de ma kbyohe, ‘Oi neke Hulasokwe yal haretke ti wasi nyasoare ma rosy laitke ma rkoal eta O. ");
INSERT INTO slu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ode ral simatare ma ratak a O, ma kete lwaumure kena hature.’” ");
INSERT INTO slu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Keskyede Yesuske hyalas i ma byohe, “Rkesy ti Kitab Lanke de, ma irkye kete hyury a Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kyoat ngkeskwaure wait uskwe khatuke imres ti ktela ribun ihury a Yesuske desy maktei o, lyoin toha Yesuske ma ikita sew a salik ma hyury a I huruk. ");
INSERT INTO slu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lemade Yesuske yulak i ei propinsi Galileake, ode Hulasokwe Memeanke kamalkyauke kimin a I. Lemade Yesuske abritake kimelir ti propinsi Galileake ktem desy mumu. ");
INSERT INTO slu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ti desike dakun o yajar ti Yahudi-nare sey rasambayan tiare, ode iry mamin desikre mumu ne rleru anike. ");
INSERT INTO slu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesuske byai hnu Nazaret wen a lan I tike. Ode sew Inamreske bonyo, Yesuske syukar ei Yahudi-nare sey rasambayan tike, ma ktyoha Yesuske wasi ktelake. Ode imdiry ma yala ma byaca Kitab Lanke. ");
INSERT INTO slu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dendye iry makarya ti sey rasambayan tike krala desy ral kitab Yesaya ikeskye ti I ma byaca. Yesaya neke heitlulswo iry a manety Hulasokwe wasi nyanoke. Ode Yesuske byuka kitab Yesayake, ma byihy tunke khatuke it ma ktyanuk de kbyohe, ");
INSERT INTO slu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ity Ebutke Memeanke kimin a Yaw, kali byitil sima ma Yaw de, ma kabrita Brit Eraske ti iry a lema manait ei sra o hahare, ode Hulasokwe yaso Yaw ma katelakw ti iry rakumakare ma rtunik a sir, ode iry a lema mamatakitare ma rmatakit, ode kaditi iry mahar mdedanare, ");
INSERT INTO slu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ode kabrita ain ity Ebut Hulasokwe ilobak itkye, kmya de.” ");
INSERT INTO slu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesuske ibaca maktei bonyo kyahat kitab desy, ode yeta ti makaryake it ti sey rasambayan tike kralake, maktei o tyaklulw ma yajar. Ode iry mamin ti desikre mumu neke ratos manenen I. ");
INSERT INTO slu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lemadendye Yesuske yajar iry desikre ma byohe, “Hulasokwe tunake khatu rakesy ma kubaca ti mitomolu neke, senwe kdi ti mane.” ");
INSERT INTO slu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lemade iry desikre mumu rmetratw ti tuna mtelas itanuk desikre. Ode it de tyanuk ti it ma rbohe, “Iry ne eras a i. Yusuf ananke i ne e?” ");
INSERT INTO slu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Lemade Yesuske tyanuk ti sir ma byohe, “Khwe ohe ei neke ana mtyanuk tun ne ma Yaw ma mbyohe, ‘Hei dokter o, mnwoha tenamkwe ma eras aduk.’ Mtyanuk kolnye kali mbyuma kala ktela eras masalsyalik iare ti hnuakw ne, kola dene mitomolu ma kuala oa hnu Kapernaumke ne. ");
INSERT INTO slu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Keskye klwosu ti e ohe iry manety Hulasokwe wasi nyanoke kyalamo lema ralan i ti wasi hnuke. ");
INSERT INTO slu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dendye mtyomolu, kali heitlulswo kyoat Elia imorifke, lema uske ainke enatelw o ktera elik, ma lu o laar lan a ksyalik ti hnu desikre mumu. Ode enen somare o ribun sir ti Israel dakun. ");
INSERT INTO slu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Keskye Hulasokwe lema yaso Elia ma ti syeak enen somare ti Israel ne, de yaso i ma ti syeak enen somke it o hnu Sarfatke oa nus Sidonke bo. ");
INSERT INTO slu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ode heitlulswo kyoat Elisa iry manety Hulasokwe wasi nyanoke myorif a nggora, desikeo mambaulare ribun sir ti Israel ne. Keskye Elisa lema nyoha iry mambaul desikre ma iblutare nelnyely, de nyoha irkye it ma ani Naaman, iry a Siria desike myesan bo, ma iblunke nelnyely.” ");
INSERT INTO slu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ratomolu tun Yesuske itanuk desikre mumu bonyo, iry mamin ti sey rasambayan tike mumu ne rkeyer a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Iry desikre rbitil sir ode resak Yesuske ma byetik toha wasi hnu desy, ode ror I bai iskye ksouke ti hnuke kserike, ma robak ma rudu I a yosy iskye ksou desy ei hahke. ");
INSERT INTO slu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Keskyede Yesuske lyakut ma isia I ti sir ma bya. ");
INSERT INTO slu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lemadendye Yesuske byai hnu Kapernaumke, hnu neke kimin ti propinsi Galileake dakun. Ode ti sew Inamreske bonyo, bya ti yajar ti Yahudi-nare sey rasambayan tike. ");
INSERT INTO slu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kyoat iry desikre ratomolu nam iajarare bonyo rmetratw, kali tun itanukare kyety mdedan. ");
INSERT INTO slu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ode ti sey rasambayan tike krala desy, irkye it a ngkeskwakwe syukar i soso de, neke byoran ma byohe, ");
INSERT INTO slu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei! Yesus iry Nazaret O, mrweky sai ma aramy ne de? Mmwa ma mkwordalam aramy mane e? Yaw ne khwe o esei O de. Oi neke Iry Nelnyely manosy a Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dendye Yesuske yaswel i ode byu ti i de byohe, “Mamwaw o! Ode mbwetik toha iry ne!” Lemade ngkeskwaw desike byesak a iry desy, daku ribun lan desy. Ode ngkeskwaw desike byetik toha iry desy, ode lema yala iry desike ma isike ksunw. ");
INSERT INTO slu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ode iry desikre mumu rmetratw, ode it de tyanuk ti it ma rbohe, “Wah, iry ne tunanare kyety mdedan a ksyalik. Kali bisa ma kyesak ngkeskwakwe, desyo byetik elik.” ");
INSERT INTO slu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lemade Yesuske abritake kimelir ti hnu kabei ta kabei ti nus desy. ");
INSERT INTO slu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lemade Yesuske byetik toha Yahudi-nare sey rasambayan ti desy, ode byai Simon wasi sekye. Inait bonyo Simon ryana wamfwetke kluruk i ma mrin i a ksyalik, lemade iry desikre raten Yesuske ma nyoha wasi kbai desy. ");
INSERT INTO slu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lemadendye Yesuske imdiry ti enen desike wena ienah tike kserike, ode yaswel kbai mrin desy bonyo, kbai mrin desike kitayar mait, lemade enen desike byatar ma syalwir ti Yesuske yor iry desikre. ");
INSERT INTO slu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kyoat sekwe iba bonyo, iry desikre ror a wait iry a isy masunure ti Yesuske. Iry isy masunw desikre wait a kbai-nare ksyalno ksyalik i, ma dum a ngkeskwaure rsukar sir soso de. Lemade Yesuske syaa sima ti iry desikre ratsam-ratsam ode nyoha wait a kbai-nare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ode Yesuske yesak ngkeskwaure dakun toha iry desikre ma rabetik bonyo, rboran ma rbohe, “Oi neke Hulasokwe Anan O!” Keskye Yesuske tyerik sir ma kete ratun, kali rhe ohe I neke Iry a Hulasokwe isusu ma ika Raja ode iaorif irkye ne. ");
INSERT INTO slu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Msarinke ma sekwe lenla ibetik bonyo, Yesuske lyakut ma byai wen kele ratelinke it. Lemade iry ribun desikre robak a I, ode ratot I bonyo, ralkyaw sir ma rbu eta I, ma kete lyoin toha sir. ");
INSERT INTO slu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Keskyede Yesuske tyanuk ti sir de byohe, “Musti mo kbwai hnu salik dakun ti kabrita Brit Eraske ohe Hulasokwe mya ma hyareta kola Rajake, kali Hulasokwe yaso Yaw.” ");
INSERT INTO slu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lemade Yesuske byai propinsi Yudeake ti syukar Yahudi-nare sey rasambayan tiare ma yabrita Brit Eraske. ");
INSERT INTO slu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sekwe it bonyo, Yesuske byai namwata Tasi Kakan Genesaretke, ode imdiry ti desy ma yajar. Dendye iry ribunke raboly-raboly ti rkoal I, kali robak ma rtomolu Hulasokwe tunanare. ");
INSERT INTO slu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ode Yesuske yatos aro matunik darkye enaru, ma ktyabw a i, ma kebunare malmata rseha wait darire ti tasike. ");
INSERT INTO slu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lemade Yesuske bya ti syai ei aroke it, neke Simon wasi aroke, ma tyaklulw ti khahake. Ode yaso Simon ma yudu aro desy ata ei tasike, ma Yesuske imin ti aroke krala desy ma yajar iry ribun desikre. ");
INSERT INTO slu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesuske iajar maktei bonyo, byu ti Simon de byohe, “Msyai aro ne ma mhyesy ei demdemkwe, ode mtyunik wasimy darkye ma knyal masire.” ");
INSERT INTO slu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Desike bonyo Simon hyalas I ma byohe, “Tuanggurw O, kyala kyosy detke ma kyal nini msarin neke, aramy mtyunik dary ne de, keskye lema knyal maskye it elik. Keskyede maso yaw dendye ktwoha ma ktwunik dary ne huruk bo.” ");
INSERT INTO slu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lemdendye rtunik wait darkye maktei o rabity bonyo, knyal masy ribun lan ne, ma khyury ma wait darkye nenma kimahy. ");
INSERT INTO slu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lemade rkahy a liat mamin wait aro idake ma rma ma rsaluk sir, dendye liatare rma ma raktemtem a raboli masy desikre ei wait aroare, ma kbyenw ma nenma klyodur. ");
INSERT INTO slu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kyoat Simon Petrus iseak a ktela desy bonyo, syakitil ti Yesuske lwau-na ktutunare ma byohe, “Amam Lan O! Lemamo soso O toha yaw, kali yaw neke iry a lim o sal yaw.” ");
INSERT INTO slu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon tyanuk koldyesy kali yor lian desikre mumu rmetratw ti raseak masy ribun darkye kinal desikre. ");
INSERT INTO slu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ti desike Simon lian deru a Yakobus yor Yohanes, Zebedeus anan desikre, rmetratw dakun. Lemade Yesuske tyanuk ti Simon de byohe, “Kete mumtaut. Kyala kyosy neke ana mudary irkye.” ");
INSERT INTO slu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ode iry desikre rhait wait aroare ei rake, maktei bonyo rtutuk lakhidik nam ribun desikre mumu ode rtoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sekwe it bonyo Yesuske imin hnuke it. Ti desike irkye it a mbaulke kbyenw tenanke. Ode kyoat iatos Yesuske bonyo, mya ma syakitil ti Yesuske lwau-na ktutunare ode iten toha I ma byohe, “Amam Lan O! Kolnye mou mo, kuten ma maditi kbai ne toha yaw ma tenakkwe nelnyely!” ");
INSERT INTO slu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lemade Yesuske yeta simake ti kyumak iry desy ode byohe, “Kou ma tenamkwe nelnyely.” Ode kyala mait bonyo, iry desike wasi mbaulke kitayar. ");
INSERT INTO slu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ode Yesuske byu eta iry desy ma kete ihes ktela desike ti irkye it elik, maktei o tyanuk ti i de byohe, “Mbwa ti mswusu tenamkwe ti iry mabaa klen ti irkye yor Hulasokwe, ma hye bain o eras o de. Ode mal nam ana muabar ti Hulasokwe ne, ti iry mabaa klen desike ma yabar ti Hulasokwe, ma ktyoha Musa wasi haret desikre ma kyala o ma nelnyely a o ti Hulasokwe. Mala koldyesy ma iry ribunke rhe dakun o nelnyely o bain-bain de.” ");
INSERT INTO slu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Keskyede Yesuske abritake kimelir ma lan de. Lemade iry erasare rtabal iry a klurukare lui-lui sir ma rma ma rtomolu Yesuske, ode iry a klurukare robak ma nyoha kbainare toha sir. ");
INSERT INTO slu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Keskyede Yesuske kyalamo byaa yobak wen a kele ratelinare ma syambayan. ");
INSERT INTO slu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sekwe it huruk bonyo, Yesuske malmata yajar ti sekye it, ma iry manosy a lui Farisike ror iry mahe snurat o tnyetak Musake rtaklulw ma rtomolu I. Iry desikre rosy a hnu nekre mumu ti propinsi Galileake, Yudeake, ode dum a rosy a nus Yerusalemke. Ode ity Ebut Hulasokwe amalkyauke kimin ti Yesuske, mane nyoha iry a klurukare ma eras sir. ");
INSERT INTO slu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ode kyoat desy dakun o, irire dum a rhar mbelukke ma iry mablukutke imin ti khahake, ma robak ma rsukar ei sekye kralake ma rtutuk i daku Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Keskyede iry desikre lema rtutu ral ei sekye kralake, kali irire ribun sir ti desy. Lemadendye rsai ei sekye srake, ti raskyaik tnyarukke, ma rtolar mbeluk desy ei hahke daku iry ribun desikre, desikeo kyal mamamak Yesuske wasi lulw ne. ");
INSERT INTO slu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kyoat Yesuske yatos iry mablukut desy tyabal iry manauk mbeluk desikre wait tohtohakke bonyo, byu ti iry mablukut desy de byohe, “Wai, wasimw a lim o sal desikre kswos ba de.” ");
INSERT INTO slu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Keskye iry mahe snurat o tnyetak Musake ror a iry manosy a lui Farisi desikre rrekan ti ralat a kralanare ma rbohe, “Iry ne esei mane ires ma ikanak a Hulasokwe ne de? Ode ryekan o bisa ma syos lim o sal nekre ba e? Taheke o Hulasokwe myesan a syos lim o sal nekre ba bo.” ");
INSERT INTO slu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Keskyede Yesuske hye iry desikre nam rarekanare, lemade tyanuk ti sir ma byohe, “Kyanmwane mirekan ti ralamy kralanare koldyesy ne de? ");
INSERT INTO slu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kali kolnye irkye tyanuk ti iry mablukut ne ma byohe, ‘Wasimw lim o sal nekre kswos ba de.’ Desikeo lema ksunw ma irkye tyanuk tun ne, kali lema tmatakit ma the o wasi lim o sal desikre syos ba deny ta lema. Klala kolnye irkye tyanuk ti iry mablukut ne ma byohe, ‘Mbwatar ode mal wasimw a mbelukke ode mlwakut ba.’ Desikeo ksunw ksyalik ma irkye tyanuk, kali ana tmatakit o nam itanuk desike kdi ti ta lema. ");
INSERT INTO slu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Keskyede ma mhye ohe ti nuske ktem ne Irkye Anankehyareta ma syos lim o sal nekre ba, dendye myatos!” Lemade Yesuske tyanuk ti iry mablukut desy de byohe, “Mbwatar! Ode mal wasimw a mbeluk desy, ma mulak o bai wasimw sekye.” ");
INSERT INTO slu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lemade iry desike byatar toha wenake daku iry ribun desikre, ode yal wasi mbelukke ma lyakut bai wait sekye. Ode kyoat ilakut bai wait sekye, desikeo lyeru Hulasokwe Anike ti salke kralake. ");
INSERT INTO slu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lemade iry desikre mumu kele rsumuk mait sir kali ramtaut. Lemade rleru Hulasokwe Anike, ode rtanuk ma rbohe, “Senweke aramy mmyetratw ti miatos ktela ne.” ");
INSERT INTO slu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lemadendye kyoat Yesuske byetik toha hnu desy bonyo, myatakit iry a maily uskwe it ma ani Lewi, ma malmata tyaklulw ti wen ikarya tike. Desike bonyo Yesuske byu ti i de byohe, “Mmwa ma mtwoha Yaw.” ");
INSERT INTO slu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lemadendye Lewi imdiry ode tyutuk lakhidik nam desikre mumu ode tyoha Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dendye Lewi yala inaknam lanke ti wasi sekye khyali Yesuske. Ode Lewi lian maily usure rtabal iry salikare dum, ma rma ma raknam a ror Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Keskye iry manosy a lui Farisike ror wait iry mahe snurat o tnyetak Musake lema rdakin a ktela ne, lemade rtanuk ti Yesuske wasi matoha Iare ma rbohe, “Hei, ktela neke lema eras! Kyanmwane miknam o myenu myor a iry maily usure ror iry a lim o sal nekre de?” ");
INSERT INTO slu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Lemade Yesuske hyalas sir ma byohe, “Iry a lema klurukare lema robak dokterke, klala iry a klurukare robak dokterke. ");
INSERT INTO slu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","De kuma neke lema kabuk iry marekan tenatare o mlay nekre, keskyede kuma neke kabuk iry lim o sal nekre ma rtunik totat atyat desikre ba.” ");
INSERT INTO slu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iry Farisi desikre rtanuk ti Yesuske de rbohe, “Yohanes Mababtiske wasi matoha iare, ror iry matoha lui Farisike, seure rait mo ras ode rsambayan, ode kyanmwane wasimw matoha Oare lema ras, de raknam o renw ne de?” ");
INSERT INTO slu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lemade Yesuske tyanuk tun inahliakke ma hyalas sir ma byohe, “Yaw ne kola wamwany masake it. Ode kyalamo rasa ma rala kalkal, ode wamwany masa desy lianare rma ma ramukmuka sir a ror i. Desikeo myaso sir ma ras e? Lema ode? ");
INSERT INTO slu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Keskyede ana kyait sekwe, ma wamwany masa desike ral i toha lianare, kyala kyosy desike nenmo iry desikre ras.” ");
INSERT INTO slu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Maktei o Yesuske tyanuk tun inahliakke it huruk ti sir ma byohe, “Lema irkye it a kyotal rabit harharkwe tebikan ma yal ma byatak rabit a mtuke. Kali ana koldyesy bonyo yala rabit deru desy ma atyat, ma rabit harharkwe kimahy, ode rabit a mtuke lema knyor rabit harharw inal ma ibatak desy. ");
INSERT INTO slu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kola ne dakun ma lema irkye it a syosan tasy maiskye kwen minminake ti werke kwena mtuke.Kali ana koldyesy bonyo tasy maiskye kwen minmina desike makity, ma kisuhan i ti werke kwena mtu desy, ma khyury ma werke kwena desike kibserw,ode tasy maiskye kwen desike kibo ba bo. ");
INSERT INTO slu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lemadendye tasy maiskye kwen minminake musti mo rsosan ti werke kwena harharkwe. ");
INSERT INTO slu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Keskyede iry a kyalamo madakin ma maenw tasy maiskye kwen a mtuke, ode kolnye yenw tasy maiskye kwen harharkwe, desyo lema dyakin, kali ana byu de byohe, ‘Eras de. Tasy maiskye kwen a mtuke bo.’” ");
INSERT INTO slu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kyoat sew Inamreske, desikeo Yesuske yor wasi matoha Iare rlakut ti bo gandumke, ode wasi matoha Iare riry gandumke ratebikan ti simatare, ode rkaslyaw ma kiblunke kyaditi i, maktei o ra kisike. ");
INSERT INTO slu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Keskyede iry manosy lui Farisi-nare dum a rbu ti sir de rbohe, “Kyanmwane mibilak a ity wait tnyetak kubkubakke ne de? Ma kbyuma kete takarya ti sew Inamreske.” ");
INSERT INTO slu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Lemade Yesuske hyalas sir ma byohe, “De lema mbyaca Kitab Lanke ti a nam Daud iala desikre, kyoat yor iry matoha iare ramlar desy e? ");
INSERT INTO slu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kyoat desike Daud syukar ei Hulasokwe wasi Lasyerkye kralake, ode yal rotya raabar ti Hulasokwe desy ma nya, ode isakar roty desike kteranare ti iry matoha iare dakun. Keskye the ohe kolnye ktyoha tnyetak ity wait kubkubakke, iry mana roty desikre, neke iry mabaa klen ti irkye yor Hulasokwe bo.” ");
INSERT INTO slu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maktei o Yesuske tyanuk ti sir huruk de byohe, “Irkye Anankekyumak haretke ti sew Inamreske ma yohut ti ktela irkye bisa ma ialanare ode ktela lema bisa ma irkye ialanare dakun ti sew Inamreske.” ");
INSERT INTO slu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kyoat sew Inamres salik huruk, Yesuske syukar ei Yahudi-nare sey rasambayan tike ma yajar. Ti desike irkye it a sima wanke kmyaty. ");
INSERT INTO slu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ti desy dakun o iry a mahe snurat o tnyetak Musake rtabal iry a Farisi-nare rbuma robak a ksala ma rmanadu Yesuske. Lemade rabalmat ti I o ana nyoha iry ne ti sew Inamreske ma eras a i ta lema. ");
INSERT INTO slu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Keskyede Yesuske hye nam rarekanke, lemade tyanuk ti iry a sim mamaty desy de byohe, “Mmwa ma mumdiry ti lulw san.” Lemade iry desike byitil i ma ti imdiry o lulkwe. ");
INSERT INTO slu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lemadendye Yesuske tyanuk ti iry desikre de byohe, “Kena e ohe ktyoha tnyetak ity wait kubkubakke mo, tala sai ti sew Inamreske de? Tala eraske ta tala atyatke de? Taorif irire ta tamatik irire de?” ");
INSERT INTO slu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesuske syeak raktemtem mumu. Lemade tyanuk ti iry a sim mamaty desy ma byohe, “Mlwol simamkwe ma!” Iry desike ilol simake bonyo, simake eras elik! ");
INSERT INTO slu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Keskyede iry desikre ralatare masbu a Yesuske a ksyalik. Lemade rawahuk sir ma rrekan de rbohe, “Ana tala iry ne kolkyabei de?” ");
INSERT INTO slu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kyoat desike bonyo, Yesuske syai ei kususwanke it ma syambayan. Sewah desike syambayan ti Hulasokwe nini msarin. ");
INSERT INTO slu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lemade msarinke bonyo, yabuk wasi matoha Iare ma yilik irkye hean a kresi enaru toha iry desikre, ma yal sir ti wasi nyaso. ");
INSERT INTO slu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wasi nyaso nekre sir ne: Simon (Simon neke Yesuske yabuk i o Petrus), ode Andreas (neke Simon wai i), Yakobus yor Yohanes, Filipus, ode Bartolomeus, ");
INSERT INTO slu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius yor Tomas, Yakobus (Alfeus anan desy), ode Simon (iry a Zelot desy), ");
INSERT INTO slu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobus ananke), ode Yudas Iskariotke, ma i ne ana iketa Yesuske ne. ");
INSERT INTO slu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuske yor wasi nyasoare rorw toha kususwan desy ma ramres ti wen maiske it. Ti desike iry ribun salno salik matoha Yesuske rawahuk a sir, rtabal iry ribun lan manosy hnu mamin propinsi Yudeake ktem desy mumu. Ode dum a rosy a nus Yerusalemke, ode dum a rosy a lasmyer a nus Tiruske ode nus Sidonke, neke nus mamin ti namwatake khaha nekre. ");
INSERT INTO slu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iry desikre rma mumu ma rtomolu Yesuske, ode iry klurukare robak ma nyoha wait a kbainare toha sir ma eras sir. Ode iry ngkeskwaure rasukar sir desikre rma dakun ma Yesuske yesak ngkeskwaw desikre toha sir ma eras a sir dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lemade iry desikre mumu, ralkyaw sir ma robak ma rkumak Yesuske, kali malkyakakwe kbyetik kyosy a I ma nyoha iry desikre mumu ma eras sir. ");
INSERT INTO slu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuske yatos wasi matoha Iare ode tyanuk ti sir de byohe, “Eraske kimin ti e, kolnye lema myait ei sra o hah, kali senweke Hulasokwe wasi iry a e, ode ana mimin ti nus lan Hulasokwe ihareta tike. ");
INSERT INTO slu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Eraske kimin ti e, kolnye senwe mimlar, kali ana mbyesur. Ode eraske kimin ti e, kolnye senwe msyer, kali ana mimukmuka e. ");
INSERT INTO slu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Eraske kimin ti e, ti kolnye irire ramnisik e, rabrai e, rahmway e, ode rahes a e, kali mtyoha Irkye Ananke! ");
INSERT INTO slu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dendye kolnye ktela desike kdi ti e, desikemo mimukmuka mimarmara e bo. Kali ksewanke ana lan ma kikita e ti wen sra eras Hulasokwe imin tike. Mnyenas ohe heitlulswoke iry Yahudi-nare ebnwo matrumat rala koldyesy dakun ti iry manety Hulasokwe wasi nyanoare ne. ");
INSERT INTO slu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Keskyede atyatke ana kidurak a e, kolnye senwe mika wasimy maloly, kali malolimkye kyaluka e ti senwe bo! Keskye ana lema kika namit-namit ti e de. ");
INSERT INTO slu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ode atyatke ana kidurak a e, kolnye senwe mbyesur, kali ana mimlar. Atyatke ana kidurak a e, kolnye senwe mimahis o mimukmuka e, kali ana ralamire ksyal ma msyer. ");
INSERT INTO slu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atyatke ana kidurak a e, ti kolnye iry ribunke rleru e, kali kola dene heitlulswo iry ribun desikre ebnwo matrumat rleru iry makakmet ma manety Hulasokwe wasi nyanoare ne dakun.” ");
INSERT INTO slu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lemadendye Yesuske tyanuk huruk ma byohe, “Ktwanuk ti iry matomolu yaw ne. Neke musti mo mlyobak ode myala eras iry mamnisik eare. ");
INSERT INTO slu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Miten eraske ti iry masoba eare, ode msyambayan ti iry mahakini eare ode iry maala atyat eare dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kolnye irkye it a kyohw manyamkwe serit, desikemo mtwiri seridake ti kyohw dakun. Ode kolnye irkye it a isoruk a rabit narnarw muhonakke, desikemo mlwura ma yal a ktyabal rabit mamin tenamw desy dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kolnye irkye it a iten nam dum toha o, desikemo mal ti i. Ode kolnye irkye it a isoruk a wasimw nam dum, kete muten a molik de. ");
INSERT INTO slu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lemade kolnye mbyuma nam sai desike irire rala ti e, desikemo myala koldyesy ti iry desikre dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ode kolnye mlyobak iry malobak eare bo, mryekan mo ana mitot ksewanke toha Hulasokwe e? Lema koldyesy, kali iry maka wait lim o sal nekre dakun o rlobak iry malobak sirare dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kolnye myala eras iry maala eras eare bo, mryekan mo ana mitot ksewanke toha Hulasokwe e? Lema koldyesy, kali iry maka wait lim o sal nekre rala koldyesy dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ode kolnye miseluk nam dum ti iry a ana ral a rolik ti e huruk bony ne, desikemo ana mryekan o mitot ksewanke toha Hulasokwe e? Lema koldyesy, kali iry maka wait lim o sal nekre, raseluk nam ti iry maka wait lim o sal nekre dakun, kali rhe ohe iry desikre ana ral a rolik ti sir o karyarike mais bo. ");
INSERT INTO slu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lemade kete myala koldyesy, keskyede mlyobak ode myala eras iry mamnisik eare, ode miseluk nam ti sir mo kete mnyenas kolyanke. Myala kolnye mo, ana watamkye lan, ode ei neke Hulasow Lan Lahukke anan e, kali Hulasokwe yala eras ti iry mahature ror iry a lema maten a khye eras ti Iare dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lemamo myala ral eraske ti iry salik, kola dene Amamy Hulasokwe ralake eras ti e dakun.” ");
INSERT INTO slu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Lemadendye Yesuske tyanuk huruk ma byohe, “Kete myukun irire, ma e dakun o kete Hulasokwe yukun a e. Ode kete mtyetak salke ti irire, ma Hulasokwe kete tyetak salke ti e dakun. Ode msyos iry maka salat ti eare, ma Hulasokwe syos salamire dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Myal nam ti irire, ode ana Hulasokwe yal ti e dakun. Ana Hulasokwe yal ti e mo kola maketa namke inal lalwakwe ma lyaw ti e ma kbyilak de kbyilak ma mabebesak. Kali lalwaw minal ma milaw ti irire desike, ana Hulasokwe yal ma lyaw ti e dakun.” ");
INSERT INTO slu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lemade Yesuske ihliak tunke ti iry desikre de byohe, “Kolnye iry matmabolke yeuk iry matmabolke, ana kolkya? Kete ana deruke rdi ei kuranke kralake de?” ");
INSERT INTO slu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maktei o Yesuske ihliak tunke it huruk ma byohe, “Lema kika naman a skol mabilak wasi Tuanggurkwe, keskye naman a skol a kolnye ti yaskol ma ti ktyutw teike, ana yola wasi Tuanggurkwe dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kyanmwane mmwatakit akwe ksinsintan mamin ti waimw matake kralake, keskye lema mmwatakit balak malosik i ti matamkwe krala desy de? ");
INSERT INTO slu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ode kolkyabei mane mtwanuk ti waimw de mbwohe, ‘Mmwa ma kaditi akwe ksinsintan mamin ti matamkwe krala desy,’ ode lema mmwatakit balak malosik i ti matamkwe krala desy e? Hei, makakmet o, maditi balakke toha matamkwe krala desy aduk ma matos a mlay, ode nenmo maditi akwe ksinsintan mamin waimu mata desy.” ");
INSERT INTO slu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Maktei o Yesuske ihliak tunke it huruk ma byohe, “Lema kika aw eras ma kisinare atyat, ode lema kika aw atyat ma kisinare eras. ");
INSERT INTO slu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ode tahe akwe ne the toha kisinare. Kali irire lema rbul arake kisike toha sitw o karkyari krala, ode lema rbul tasy maiskye kisike toha sitw o karkyari krala dakun. ");
INSERT INTO slu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kola dene iry eraske yala ktela eraske, kali kbyetik kyosy rala eraske. Ode iry atyatke yala ktela atyatke, kali atyatke kbyenw a ralake kralake. Kali nam sai desike kimin ralamy kralanare desikeo ana mtyanuk ma kbyetik.” ");
INSERT INTO slu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Maktei o Yesuske ihliak tunke it huruk ma byohe, “Kyanmwane miabuk Yaw o ‘Amam Lan, Amam Lan O,’ keskyede lema mtyoha nam kutanuk ti e ne de? ");
INSERT INTO slu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Klala esei desy mya ma yor Yaw ode tyomolu tunakure ode tyoha, desyo i neke ana yola esei de? ");
INSERT INTO slu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yola dene iry masadiri seike, ma khyehyei neke kyaly lasmyerke ma demdemw ma ti kyait hatkwe, ode yoditi fanderenke ti hatkwe khaha desy, ma kolnye rean salke kmya ma kkyahat wasi sey desy, desikemo lema kiwaway, kali kimdiry ti hatkwe khahake ma malkyakaw. ");
INSERT INTO slu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Keskyede iry matomolu tunakure ode lema tyoha, yola dene iry a masadiri seike ti laranke khahake ne. Ode kyoat rean salke kmya bonyo, wasi sey desike klyily ma kiskyui-kiskyay, kali kimdiry ti laranke khahake bo, ma lema malkyakaw.” ");
INSERT INTO slu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kyoat Yesuske itanuk nam ti iry ribun desikre maktei bonyo, byai hnu a Kapernaumke. ");
INSERT INTO slu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ti hnu Kapernaum desy dakun o suldatare rosy Roma ma rajak ti. Ode suldat desikre wait uskwe khatu desy wasi atke isike ksunw ma lan ma nenma myaty, keskyede uskwe khatu desike lyobak wasi at desy ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ode kyoat suldatare wait uskwe khatu desy itomolu Yesuske abritake bonyo, yaso iry manety lulw ti Yahudike irkye enai ne ma rba ti raten Yesuske, ma mya ma nyoha kbaike toha wasi at desy. ");
INSERT INTO slu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lemade iry desikre rba ti rait Yesuske, ma ral ralat a kralanare bain-bain ma rtanuk ti Yesuske ma rbohe, “Amo, aramy miten ma ti mnwoha suldatare wait uskwe khatuke wasi atke kali isike ksunw ma lan. Aramy mmya ma miten O, kali uskwe khatu neke byer o tyahal, ");
INSERT INTO slu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ma yala eras iry Yahudi-nare, ode i ne inal nam ma tasadiri ity wait sey tasambayan ti ne.” ");
INSERT INTO slu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lemadendye Yesuske yor iry desikre ma rba. Ode rala ma ranait suldatare wait uskwe khatu desy wasi sekye bonyo, uskwe khatu desike yaso lianare dum ma rbaa rtudakal Yesuske ma rbohe, “Amo, ara liamkye yaso ma aramy mmya ma mtyanuk ti O kolnye: Kete mhwury ma mungkoly ti mubai wasi sekye ne, kali i neke byohe lema byer o tyahal ma yal O ei wasi sekye kralake, ");
INSERT INTO slu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ode lema ires ma mya ma yait O ti ne dakun. Lemade mtwanuk tunke khatuke it ti ne, ma wasi at ilobakke eras i o sekye. ");
INSERT INTO slu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hye ohe mnwoha mal wasi atke wasi kbaike, kali i ne dakun o iry dum a rhareta i ma tyoha sir. Ode hyareta suldat kakanare ma rtoha i. Lemade kolnye tyanuk ti suldat kakan ne it de byohe, ‘Mbwa!’ Desyo bya. Ode tyanuk ti irkye it huruk ma byohe, ‘Mmwa!’ Bonyo mya. Dete lemamo tyanuk ti wasi atke de byohe, ‘Mkwarya nam ne!’ Desikeo kyarya. Koldyesikemo hye ohe mtwanuk sai desy, desikeo ana kdi ti.” ");
INSERT INTO slu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lemade Yesuske itomolu tun desikre bonyo, myetratw ti itomolu iry ne. Ode yulak matake sara iry ribun matoha I desikre, ma tyanuk ti sir de byohe, “Klwosu ti e, biar ma iry ne lema iry Yahudike, keskyede wasi tohtohakke malkyakaw a ksyalik! Ti iry Yahudi-nare ne lenla ksweak irkye it ma wasi tohtohakke koldyesy elik.” ");
INSERT INTO slu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ode kyoat lian iaso desikre rulak sir ei uskwe khatu desy wasi sekye bonyo, wasi at desike eras i de. ");
INSERT INTO slu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lema soso bonyo Yesuske byai nuske it, ma nus neke kani a Nain. Yesuske wasi matoha Iare, rtabal iry ribun desikre ror I de raktem a rba ma lui-lui sir ti babake. ");
INSERT INTO slu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kyoat Yesuske yor iry ribun desikre rala ma ranait salhaha lorkye kmata nus desy bonyo, irire rhar mbelukke ei mloskye, neke mamatkye imin ti khahake. Mamaty neke enen somke it a anan wamwankye ma sasasam i bo. Ode iry ribun mamin ti nus desike rlakut ror enen som desy ma rtoha iry mahar a mbeluk desy. ");
INSERT INTO slu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ode kyoat ity Ebut Yesuske iatos enen som desy bonyo, ralake ksyal a i, ma lyobak i a ksyalik, lemade tyanuk ti enen som desy de byohe, “Eno, kete mswer.” ");
INSERT INTO slu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lemadendye Yesuske bya sara mbeluk desy ma kyumak, desike bonyo iry maharare ramres. Ode Yesuske tyanuk ma byohe, “Naman mur o, mbwatar!” ");
INSERT INTO slu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dendye naman mur a mamaty desike byatar ma tyaklulw ode itun. Lemadendye Yesuske yal i ti ena. ");
INSERT INTO slu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sew desike iry mamin ti desikre mumu neke ramtaut ode rleru Hulasokwe Anike ma rbohe, “Iry neke iry lan lahuk manety Hulasokwe wasi nyanoke it ne, ma mya ma yor a ity mane. Ode Hulasokwe I ne ma yoryeta ity mane.” ");
INSERT INTO slu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lemade Yesuske abritake kimelir ti propinsi Yudeake ktem desy, ode hnu mamin a Yudeake kseri desy mumu. ");
INSERT INTO slu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanes wasi iry matoha iare rahes Yesuske wasi ktela ialanare mumu ti Yohanes. Lemade Yohanes yabuk irkye enaru toha wasi matoha i desikre, ");
INSERT INTO slu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ode yaso deruke ma ti rena ity Ebut Yesuske ma ana rbu ti I de rbohe, “Amo, Oi ne bain o iry mama ma ktyoha Hulasokwe itetakke e? Neke Hulasokwe syusu O ma muka Raja ode maorif irkye ne, Oi ne bain e? Ta aramy mikita iry salik de?” ");
INSERT INTO slu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lemade iry deru desike rba. Kyoat ranait a Yesuske bonyo, rtanuk ti I de rbohe, “Amo, Yohanes Mababtiske yaso aramy ma mmya ma myena ohe, ‘Oi ne bain o iry mama ma ktyoha Hulasokwe itetakke e? Neke Hulasokwe syusu O ma muka Raja ode maorif irkye ne, Oi ne bain e? Ta aramy mikita iry salik de?’” ");
INSERT INTO slu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kyoat Yohanes wasi nyaso deru desy rena Yesuske, desikeo Yesuske moluk a nyoha kbainare toha iry ribun lan ne ma eras a sir, ode yala matmabolare ma rmatakit, ode yesak ngkeskwaure dakun. ");
INSERT INTO slu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lemade Yesuske hyalas iry deru Yohanes iaso desikre ma byohe, “Mbya, ode mtyanuk ti Yohanes nam sai myatos ode mtyomolu de: neke matmabolke myatakit de, mablukutke lyakut de, mambaulke iblunke nelnyely de, mamolkwe tyomolu de, mamatkye myorif de, ode iry lema manait sra o hahke kabrita Brit Eraske ti i de. ");
INSERT INTO slu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lemadendye eraske ti iry a lema mamres ma matohak Yakwe, ode eraske ti iry a lema mabu a matuly Yakwe.” ");
INSERT INTO slu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kyoat iry a Yohanes iaso desikre raba bonyo, Yesuske ihes Yohanes ti iry ribun desikre ma byohe, “Kyanmwane lulswoke miba ti miatos Yohanes ti wen malosy-loskye ne de? Mbya ti myatos iry a matoh ti de matoh ma maola tnyei a eskwe kisiri ti de kisiri ma ne e? Lema! Kali Yohanes neke lema yoly desy. ");
INSERT INTO slu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ode nam sai ne kihury ma miba ne de? Ti myatos iry mahonak rabit eraske e? Lema! Kali iry mahonak rabit eraske ode iry maka malolkye, ramin ti sey lan a rajake imin tike, de lema ti wen malosy-loskye. ");
INSERT INTO slu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lemade kolkyabei mane miba ne de? Ti myatos iry manety Hulasokwe wasi nyanoke e? Mlay. Ode klwosu ti e ohe Yohanes neke lan i ma byilak iry manety Hulasokwe wasi nyano nekre mumu. ");
INSERT INTO slu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kali Yohanes i ne heitlulswo rakesy i ti Kitab Lanke ne. Ti Kitab desy Hulasokwe tyanuk ma byohe, ‘I neke wasikw nyaso kuasoke ma myuna O, ma bya ti syoli salke ma kikita O.’” ");
INSERT INTO slu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lemade Yesuske tyanuk huruk ma byohe, “Mtyomolu. Ti nuske ktem ne, kyala kyosy khyehyeike ma ti kyait senwe, lema irkye it a lan i ma byilak Yohanes Mababtiske! Klala kyala kyosy senwe, esei desike biar ma kakakan lahuk i ti kyoat Hulasokwe ihareta kola Rajake ne, keskyede ana lan i ma byilak Yohanes Mababtiske.” ");
INSERT INTO slu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kyoat iry ribun desikre mumu rtabal iry maily usw nekre dakun ti ratomolu tun Yesuske itanuk desikre, desikeo rou o Hulasokwe mlay a I, kali lulswoke ral tenatare ti Yohanes ma byabtis sir de. ");
INSERT INTO slu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Keskyede iry a Farisi-nare, ror iry mahe snurat o tnyetak Musa nekre, rtuly nam Hulasokwe ireky ti sirke, kali sir neke lema rou ma Yohanes byabtis sir. ");
INSERT INTO slu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Lemadendye Yesuske tyanuk ma byohe, “Ana kal sai ma kuhliak ode kulalau kyor iry a mamin taras ne de? ");
INSERT INTO slu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iry nekre rola naman a mabren ti sal a krala nekre, ma it de yabw ti it ma rbohe, ‘Aramy mkyohw tihalti e, keskyede lema misety, Aramy miora inaora ral matolare, keskyede lema msyer.’ ");
INSERT INTO slu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ktwanuk koldyesy kali kyoat Yohanes Mababtiske ima bonyo, lema nya rotkye ode lema yenw tasy maiskye kwen makitkye de yas bo, keskye lema mdyakin i, de mtyanuk ma mbyohe, ‘Ngkeskwakwe syukar i.’ ");
INSERT INTO slu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Klala Irkye Anankemya bonyo, iknam o yenw, desikeo lema mdyakin I huruk, de mtyanuk ma mbyohe, ‘Myatos I! I neke ikotw atyat ode yenw tua manas. Ode atyat i kali ika lui yor iry maily usure rtabal iry maka wait lim o sal nekre.’ ");
INSERT INTO slu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Keskyede Hulasokwe tyilik eras o atyat, neke tatos ode the mlakye toha wasi iry matoha Iare wait mormyorifare.” ");
INSERT INTO slu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iry Farisike it ma ani a Simon. Neke iten a Yesuske ma byai wasi sekye ma iknam ti. Lemade Yesuske byai iry a Farisi desike waitke. Ode syukar ei sekye kralake ti raktem a raknam, desikeo rtaklulw ma rney sir ti mejake ode rlola lwautare ei lyakwe. ");
INSERT INTO slu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti hnu desike, wamfwetke it ma rhe wasi lim o sal nekre. Kyoat wamfwet desike itomolu o Yesuske moluk a iknam ti iry Farisi desike wasi sekye bonyo, yal botal a nul mahona mtelaske sasam, ");
INSERT INTO slu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ode bya ti syukar sey desy ti imdiry ei Yesuske etake, ma nyey a lwaunare. Ode syer ma suanare ktyurw ti Yesuske lwaunare ma kyabetar. Lemade syakitil ode yal hukake ma kyur Yesuske lwau desikre. Maktei bonyo yoy a Yesuske lwaunare, ode nenmo yal a nul a mahon a mtelas desike ma yalik ti. ");
INSERT INTO slu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kyoat a iry Farisi maabuk Yesuske neke iatos ktela desy bonyo, tyanuk ti ralake kralake ma byohe, “Kolnye iry ne iry manety Hulasokwe wasi nyanoke I ne, musti mo hye o wamfwet makumak I neke wasi lim o sal nekre ribun.” ");
INSERT INTO slu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Lemadendye Yesuske tyanuk ti iry Farisi desy ma byohe, “Simon, kala ma ktwanuk tunke it ti o.” Simon a hyalas I de byohe, “Tuanggurw, mtwanuk.” ");
INSERT INTO slu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dendye Yesuske tyanuk ti i ma byohe, “Kolnye irkye enaru ma rutan kuban toha iry a maka wasi kubanke. Neke it a yutan kuban blyawan bokbokke atkwe enasim, ode it a yutan kuban blyawan bokbokke hean-sim. ");
INSERT INTO slu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ode iry deru desy lema rait ma reluk kuban desikre, dendye iry a maka wasi kuban desike byuma kete reluk de ktei bo. Lemade ti iry deru neke ese iten eraske lan ma kbyilak ti iry maka wasi kuban ne de?” ");
INSERT INTO slu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon a hyalas ma byohe, “Krwekan mo iry mautan kuban ribun desy.” Yesuske hyalas ma byohe, “Tun mutanukke mlay.” ");
INSERT INTO slu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Maktei o yulak I ti yatos a wamfwet desy, ode tyanuk ti Simon de byohe, “Simon, matos wamfwet ne de? Kswukar wasimw sekye, keskyede lema mal werke ma kut a lwaukure, klala matos wamfwet ne syer ma suanare ktyurw ma kyabetar a lwaukure, ode yal a hukake ma yal ma kyur. ");
INSERT INTO slu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ode kyoat a kswukar ei ne, lema moy a Yaw ma kola kyalamo ktela tala nekre, keskyede wamfwet desike lema imres ma yoy lwaukure. ");
INSERT INTO slu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oi neke lema malik nulke ti usukkwe khatuke, klala wamfwet neke yalan Yaw ma yalik nul mahona mtelas a khesi lanke ti lwaukure. ");
INSERT INTO slu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lemadendye ktwanuk ti o, iry a wasi lim o sal ribun lan nekre Hulasokwe syos ba de, desikeo yal ralake kralake ti Hulasokwe o lan a ksyalik. Klala iry a wasi lim o sal tebikanke Hulasokwe syos ba dakun, desikeo yal ralake kralake tebikan ti Hulasokwe bo.” ");
INSERT INTO slu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lemade Yesuske tyanuk ti wamfwet desy ma byohe, “Eno, wasimw lim o sal nekre kswos ba de.” ");
INSERT INTO slu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ode iry a mataklulw ma raknam a ror Yesuske neke it de tyanuk ti it ma rbohe, “Esei ne mane isos lim o sal nekre ne de?” ");
INSERT INTO slu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Keskyede Yesuske tyanuk ti wamfwet desy ma byohe, “Hulasokwe yaorif o de, khyali wasimw tohtohakke. Dendye mbwa, kali Hulasokwe ika eras yor o de.” ");
INSERT INTO slu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lema klenke soso bonyo Yesuske lyakut a lyola hnu kakan o lan nekre, ma yabrita Brit Eraske ohe Hulasokwe mya ma hyareta kola Rajake. Kyoat desike dakun o wasi matoha I dehean a kresi enaru desike rlakut ror I. ");
INSERT INTO slu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ode wamfwetare rlakut ror I dakun. Wamfwet nekre dum a Yesuske kola yesak ngkeskwaure toha sir, ode dum a nyoha wait a kbainare ma eras sir. Ti wamfwet desikre it ma ani Maria ma kyalamo rabuk i ti Maria Magdalena. Neke Yesuske kola yesak ngkeskwaure aryaritke itw toha i dakun. ");
INSERT INTO slu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wamfwetke it dakun ma tyoha Yesuske neke ani Yohana, ma lai-na ani Khuza. Khuza neke ika usu khatu ti iry makarya mamin ti raja Herodes ne wasi sekye. Ode wamfwetke it dakun ma ani Susana yor wamfwet salno salik nekre. Wamfwet desikre ral malolit mesmesanare ma ral ma rsaluk Yesuske yor wasi matoha Iare. ");
INSERT INTO slu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kyoat desike iry ribunke rosy a wait hnuare ma rma, desikeo lui-lui sir ti mamake ma ror Yesuske. Iry desikre rma ma rawahuk sir nini ribun sir bonyo, Yesuske tyanuk tun inahliakke it ti sir ma byohe, ");
INSERT INTO slu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iry manoha boke it a bya ti kyay a hina hinkye ti wasi boke. Kyoat ikay hiny desy bonyo, hiny desike tebikan a kdi ti sal mamin ti wasi boke kralake, ma iry malakut manosy sal desike rsosa, ode manunare rorw ma ra ma ktei. ");
INSERT INTO slu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ode hiny desike tebikan a kdi ti lasmyer a hatkwe kimin ti kletike, ma kituhw bonyo, kimrau kali lema kika wer ti lasmyer desy ma kyabetar. ");
INSERT INTO slu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ode tebikan a kdi ti sitw o karkyary krala, ma sitw o karkyary desikre ktyuhw kyor hiny desy, ma kyah ma lema kisi. ");
INSERT INTO slu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Keskyede hiny desike tebikan a kdi ti lasmyer a eras maiskye, ma ktyuhw ma kisi bonyo, kusuke sasam neke kisike atw.” Kyoat Yesuske ihes tun inahliak desy maktei bonyo tyanuk ma byohe, “Ese ika molu desikemo tyomolu!” ");
INSERT INTO slu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lemade Yesuske wasi matoha Iare rena I ma rbohe, “Tun muhliak neke kbuanke kolkya?” ");
INSERT INTO slu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dendye Yesuske hyalas wasi matoha Iare ma byohe, “Ei neke Hulasokwe yal hehe eraske ti e, ma mhye o kolkyabei ma Hulasokwe mya ma hyareta kola Rajake. Klala ktela neke kihunik i ti iry salik. Mane ne kajar sir a kyor tun inahliakke, ma ‘Biar ma ratos, keskyede lema rmatakit, ode biar ma rtomolu, keskyede lema rhe kbuanare.’ ");
INSERT INTO slu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tun kuhliak neke kbuanke kolnye: Hiny desike kola Hulasokwe tunanare. ");
INSERT INTO slu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ode hiny madi ti salke krala mamin ti bo desy, kola ne iry matomolu Hulasokwe tunanare, keskye ngkeskwaure wait uskwe khatuke mya ma yal Hulasokwe tunanare toha iry desikre ralatare. Yala koldyesy ma byu eta iry desikre ma kete rtohak Hulasokwe tuna desikre, ma Hulasokwe lema yaorif sir. ");
INSERT INTO slu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ode hiny madi ti lasmyer mamin hatu khaha desikre, kola dene iry matomolu Hulasokwe tunanare ma rtohak ode ramukmuka sir. Keskye wait tohtohakke lema malkyakaw. Ode kyoat ktela masunkwe kena sir, desikeo ra-la toha wait tohtohakke huruk. ");
INSERT INTO slu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ode hiny madi ti sitw o karkyary krala nekre, kola dene iry a matomolu Hulasokwe tuna desikre ma rtohak, keskye seure kiliku i, desikeo ralatare kakan ti wait mormyorifare, dete lemamo rrekan eraske ti tenatare ode rmorif ti malolkye bo. Rala koldyesy nini wait tohtohakke lema kika kbuan ti sir kola hiny desike ma lema ktyuhw ma kisi kali sitw o karkyary kyah. ");
INSERT INTO slu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Klala hiny madi ti lasmyer eras maiskye, kola dene iry a ralat a kralanare eras ode nelnyely ti ratomolu Hulasokwe tunanare ne bonyo, rsosan mamamak ti ralat a kralanare. Iry desikre wait tohtohakke ti Hulasokwe malkyakaw, dendye rala ktela erasare, kola dene hiny a matuhw ma kisinare ribun ne.” ");
INSERT INTO slu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Dendye Yesuske tyabal ma tyanuk huruk de byohe, “Irire lema rtunw damarke, maktei o ral a lkuskye ma rkahat eta, ta lemamo ral ti rintyotake. Keskye kyalamo rtunw damarke maktei, desikeo ral ti wen helhelake ode atatke, ma kolnye irire rsukar sekye kralake desikemo rmatakit kelelnanke. ");
INSERT INTO slu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ktwanuk koldyesy kali lema kika nam mabuny ma ana lema kbyetik, ode lema kika nam mahunik i ma ana lema rhe ode rahes. ");
INSERT INTO slu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lemadendye mnyenas mamak nam kutanuk ma mitomolu ne. Kali esei desike, syosan mamak tun kutanukare ma hye, desikeo Hulasokwe tyabal hehe desy ti i ma kbyilak. Klala esei desike tyomolu ode lema syosan mamak tun kutanukare, biar ma ryekan o hye tunakure de, keskyede ana Hulasokwe yal a yolik hehe desy toha i.” ");
INSERT INTO slu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuske ena-na yor wainare rma ma rseak Yesuske, keskyede iry desikre lema rait a I kali irire ribun sir ti desy. ");
INSERT INTO slu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lemade irire rlosu ti Yesuske de rbohe, “Enamu yor waimure sir ne mloskye, ma rala ma rseak a O.” ");
INSERT INTO slu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Keskyede Yesuske hyalas sir de byohe, “Iry matomolu Hulasokwe tunanare ode rtoha, iry desikre klwobak sir kola dene kulobak enakw o waikure dakun ne.” ");
INSERT INTO slu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sekwe it bonyo, Yesuske ramin ti namwata Tasi Kakan Galileake ma syai ei aroke ma yor wasi matoha Iare, ode tyanuk ti sir ma byohe, “Mmya ma tbai serida so.” Lemadendye rbity lar ti aro desy ma rba. ");
INSERT INTO slu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kyoat rbity lar ti ma raba bonyo, Yesuske yenah ti aroke kralake. Lema soso bonyo eskwe ksyai ma mety ti tasi kakanke krala desy ma besanare lan, ma tasike ksyukar aroke kralake ma nenma rlodur. ");
INSERT INTO slu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lemadendye Yesuske wasi matoha Iare roha I ma rbohe, “Tuanggurw O, mbwatar! De ana tmaty!” Lemade Yesuske byatar, ma tyerik esw desy ode tyenauk besa atat desikre. Desikeo esw o besa desikre kimres, ma tasi kakan desike mlin a mlin. ");
INSERT INTO slu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lemade Yesuske tyanuk ti wasi matoha Iare ma byohe, “Kyanmwane lema mitohak Yaw ne de?” Iry desikre rmetratw ode ramtaut mait, ma it de tyanuk ti it ma rbohe, “Iry neke esei ne bain de? Mane inal haretke ti esw o besa nekre, ma kele rateka mait ne de!” ");
INSERT INTO slu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lemade Yesuske yor wasi matoha Iare rbity larke huruk ma ti rait Tasi Kakan Galileake seridake, neke lasmyer a Gerasake. ");
INSERT INTO slu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ti lasmyer Gerasa desike wamwankye it ma ngkeskwaure dum a rsukar i ma rhareta i soso de. Ode iry Gerasa-nare kyalamo rdalun a sima o lwau, ode rajaga malkyakaw i, kali iry desike lema byuma hyonak a i, ode lema you ma imin ti sekye kralake, de byuma imin ti ratkye bo. Keskyede ngkeskwaw desikre almalkyautke khyury ma iry desike yohut daldalun desikre. Lemade ngkeskwaw desikre ral a i ma ror i bai wen kele ratelinke. Kyoat Yesuske yorw toha aroke ei laranke, ma iry a ngkeskwaure rasukar desy iatos Yesuske bonyo, byoran, ode mya sara I ma syakitil ti I. Lemadendye Yesuske yal haretke ti ngkeskwaw mahatw desikre ma rbetik toha iry desy. Keskye iry desike telake lan ma tyanuk ti Yesuske de byohe, “Mrweky sai ma yaw ne de? Yesus O, khwe ohe Oi ne Hulasow Lan Lahukke Anan O! Lemade kuten toha O ma kete muhdawan a yaw ma isikkwe ksunw.” ");
INSERT INTO slu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Lemade Yesuske yena i de byohe, “Animw ka?” Desikeo iry desike hyalas I ma byohe, “Anikw a Legion ande!” (Tyanuk koldyesy kali Legion neke kbuanke o anakyai ribunke nem ma klyosu ohe ngkeskwaure ribun de ribun sir a ksyalik neke rsukar i de.) ");
INSERT INTO slu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lemade ngkeskwaw desikre raten mirmirin toha Yesuske, ma kete Yesuske yaso sir ma rbetik toha iry desike ma ti rsukar ei mamaty rala. ");
INSERT INTO slu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ti soke hahy ribun lan nekre moluk a raobak kotut ti kususwanke kserike. Lemade ngkeskwaw desikre raten toha Yesuske ma lyura sir ma rsukar ei hahy desikre. Dendye Yesuske you toha tun ratanuk desy. ");
INSERT INTO slu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lemadendye ngkeskwaw desikre rbetik toha iry desy, ode ti rsukar ei hahy desikre, ma hahkye kmeta desike ra-la roruk toha kususwanke ma lema ramres, de ra-la loran tasi kakanke ti rlodur, ode renw tasi ma rmaty. ");
INSERT INTO slu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lemade iry majaga hahy desikre ratos a ktela desy bonyo, iry desikre ra-la toha wen desy ma rba ti rahes ktela desy ti nus Gerasake ktyabal hnu kakan kabei ta kabei ti lasmyer desy. ");
INSERT INTO slu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dendye iry ribun lan mamin nus Gerasake rbetik ma rba ti ratos ktela madi ti desy. Ode kyoat iry desikre rma ma rait a Yesuske bonyo, ratos iry a ngkeskwaure rabetik toha desy. Iry desy tyaklulw ma nyey a Yesuske lwaunare ma hyonak a i, ode hye toha lbweta de. Lemade iry desikre ramtaut. ");
INSERT INTO slu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iry dai matos a ktela desy elik nekre rahes ti iry nenmo mamaare, ode rlosu o kolkyabei ne Yesuske iaorif a iry neke toha ngkeskwaure ma eras a i ne. ");
INSERT INTO slu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lemadendye iry Gerasa desikre mumu raten Yesuske ma tyutuk sir ode bya, kali ramtaut ma ksyeman sir. Lemade Yesuske syai aroke. ");
INSERT INTO slu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ode rala ma raba bonyo, iry a ngkeskwaure rabetik toha i desike byuma tyoha Yesuske, ma iten mirmirin toha Yesuske ma tyoha I, keskyede Yesuske yaso i ma yulak a i. Ode tyanuk ti i de byohe, ");
INSERT INTO slu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mbwai wasimy sekye, ode muhes nam ribun lan Hulasokwe iala ti o ne.” Lemade iry desike bya ti lyakut yaklelela hnu mamin ti nuske krala desy mumu, ode yabrita nam a Yesuske iala ti tenanke ne. ");
INSERT INTO slu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kyoat Yesuske yulak a I toha lasmyer Gerasake ma byai lasmyer Galileake bonyo, iry ribunke rma ma rbalan a I, kali rakita I bo. ");
INSERT INTO slu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lemade irkye it ma mya. Iry desike ani a Yairus, neke ika usu khatu ti Yahudi-nare sey rasambayan tike. Ode mya ma syakitil ti Yesuske lwau-na ktutunare, ma yal ralake kralake ma iten ma Yesuske byai wasi sekye. ");
INSERT INTO slu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yala koldyesy kali anan wamfwet sasasam neke yala ma myaty. Anan neke wasi ainke hean a kresi enaru de. Lemade Yesuske you ma byai Yairus wasi sekye. Ode kyoat ralakut bai Yairus wasi sekye bonyo, iry ribun lan desikre rlakut ma it de dyekin it ma robak ma rney a Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti iry ribun desikre dakun o wamfwetke it ma kbai larke khatu maskyakye kyala i ainke hean a kresi enaru de, ma lema kika iry ma rnoha ral wasi kbaike, biar ma yal wasi malolkye mumu nini ktei ti dokterare dakun. ");
INSERT INTO slu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wamfwet desike lyakut ma isia i a yosy a lyakwe ma ti nyey a Yesuske, ma kyambil mait wasi rabit narnarkwe kninike bonyo, wasi kbai desike kitayar elik. ");
INSERT INTO slu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lemade Yesuske yena de byohe, “Esei ne ikambil Yaw ne de?” Keskye iry desikre mumu ne rtuly ma rbohe, “Mbwe.” Lemade Petrus tyanuk ti I ma byohe, “Tuanggurw, irire ribun a rlakut ror O ma it de dyekin it, ma ana the o esei ne ikambil O ne de?” ");
INSERT INTO slu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Keskyede Yesuske tyanuk ma byohe, “Khwe ohe irkye it a kyambil a Yaw, kali kkwoman mo wasikw malkyakakwe kbyetik kyosy a Yaw.” ");
INSERT INTO slu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kyoat wamfwet desike iatos ma ktela iala desike Yesuske ihe bonyo, wamfwet desike huake kyamlulurw. Lemade syakitil ti Yesuske wasi lulululw ne, ma lyosu o kyanmwane ikambil Yesuske ne. Lemade ihes ti Yesuske ti ikambil mait I bonyo eras i elik ne. Ode iry a ribun lan mamin ti desikre raktemtem a rtomolu tun itanuk desy. ");
INSERT INTO slu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lemadendye Yesuske tyanuk ti wamfwet desy ma byohe, “Eno, Hulasokwe nyoha wasimw kbaike ma eras o de, khyali wasimw tohtohakke. Dendye mbwa, kali Hulasokwe ika eras yor o de.” ");
INSERT INTO slu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Malmata Yesuske itun a yor wamfwet desy, desikeo Yairus a wasi nyasoke mya ma tyanuk ti Yairus de byohe, “Amo, anamkwe myaty de. Mane kete mhwury ma tuanggurkwe byai wasimw sekye.” ");
INSERT INTO slu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Keskyede Yesuske itomolu tun desike bonyo, tyanuk ti Yairus de byohe, “Kete mumtaut de mtwohak bo, ode anamkwe ana myorif.” ");
INSERT INTO slu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lemade Yesuske yait a Yairus wasi sekye bonyo, Yesuske byu eta iry ribun malakut manor I desikre ma kete rsukar ei sekye kralake. De iry a masukarare neke Petrus, Yohanes, ode Yakobus, rtabal Yairus yor sawa bo. ");
INSERT INTO slu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kyoat a rsukar sekye bonyo, iry mamin ti a sekye krala desike mumu neke ralatare ksyal a naman desy ma rser. Keskye Yesuske tyanuk ti sir ma byohe, “Kete msyer, kali naman ne lema myaty, de yenaf bo.” ");
INSERT INTO slu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iry desikre ramahis Yesuske, kali iry desikre rhe o naman desike myaty de. ");
INSERT INTO slu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lemade Yesuske kyumak a naman desike simake, ode tyanuk ma byohe, “Akasy, mbwatar!” ");
INSERT INTO slu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Dendye naman desike memeanke kimin i mait ma byatar ode imdiry. Desikeo naman desike ena o ama-na rheran mait. Lemade Yesuske byuma ral kotw ti naman desike ma nya. Maktei bonyo Yesuske byu eta ena o ama ma kete rahes ktela desy ti irit-irit. ");
INSERT INTO slu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuske yabuk wasi nyaso dehean a kresi enaru desy. Ode yal wasi haretke kyor malkyakakwe ti sir, ma resak ngkeskwaure ode rnoha kbainare toha irire. ");
INSERT INTO slu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ode yaso sir ma ti rabrita ohe Hulasokwe mya ma hyareta kola Rajake, ode rnoha kbainare toha irire ma eras sir. ");
INSERT INTO slu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ode tyanuk ti sir ma byohe, “Miba ne mo kete myety namit-namit ti salke kralake, neke kete myety tektekan, suhlwak, ktyabal simbol o rabit, ode kete mika resamy, ode kete myety kuban dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ode kolnye myait hnuke it ode irkye it a yal e ma mimin ti wasi sekye, desikemo mimin ti sey desy nini mbyetik toha hnu desy, ma mbyai hnu salik bo. ");
INSERT INTO slu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dete kolnye msyukar a hnuke it ode lema rou ma ral e ei wait seire, desikemo mbyetik toha hnu desy, ode mryitik a ahkwe toha lwaumire, ma klyosu ohe Hulasokwe ibu a ituly hnu desy dakun.” ");
INSERT INTO slu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesuske tyanuk maktei bonyo, wasi nyaso desikre rbaa roli hnuare ma ti rabrita Brit Eraske, ode rnoha iry isy masunure ma eras sir, ti wen kabei ta kabei bo. ");
INSERT INTO slu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kyoat raja Herodes Antipas ihareta o propinsi Galileake, desikeo tyomolu ktela ribun Yesuske iala nekre mumu. Keskye lema hye o esei ne Yesuske, kali tyomolu o irire dum a rtanuk ma rbohe, “Yesus neke Elia, ma yorw yosy wen sra eraske ma mya huruk mane.” Ode dum a rbu de rbohe, “Yesus neke iry manety Hulasokwe wasi nyano heitlulswoke it, ma myorif huruk mane.” Ode irire dum a rbohe “Yesus neke Yohanes Mababtiske, ma myorif huruk de.” ");
INSERT INTO slu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Keskye raja Herodes a ryekan ti ralake de byohe, “Eh, Yohanes neke kaso ma rsoby ohut telake de. Ode Yesus neke esei ne de? Ktwomolu ktela ribun nekre khyali I.” Dendye raja Herodes yobak ma syeak a Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kyoat a Yesuske wasi nyasoare raulak sir bonyo, rahes a nam ribun rakarya desikre ti Yesuske. Lemade Yesuske yor a sir ma rbai wen kele ratelinke ti hnu Betsaidake kserike. Desikeo rmesan a ror Yesuske bo. ");
INSERT INTO slu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Keskyede iry ribunke rtomolu ma Yesuske yor wasi matoha Iare rbai wen kele ratelin desy bonyo, iry ribun lan desikre rlakut ma rtoha I dakun. Ode iry desikre ti ranait Yesuske ti wen desy bonyo, Yesuske yal sir ma raktemtem ti desy, ode ihes ti sir ohe Hulasokwe mya ma hyareta kola Rajake. Ode nyoha iry klurukare ma eras sir dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ode sekwe yala ma idi bonyo, Yesuske wasi matoha I dehean a kresi enaru desy rtanuk ti Yesuske ma rbohe, “Tuanggurw O, maso iry ribun desikre ma rbai hnu maney nekre, ma ti robak kotw ma ra, ode wen ma ramin ti aduk, kali wen a tamin ti neke kele rtelin.” ");
INSERT INTO slu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Keskyede Yesuske tyanuk ti wasi nyasoare ma byohe, “Lema. Ei neke musti mo myal kotw ti iry nekre ma ra.” Lemade rhalas Yesuske de rbohe, “Kotw mamin aramy nekre rotkye enasim ode maskye enaru bo. De lemamo aramy mbya ti mlyiw kotw ti ktyabal ma aramy myal ti iry nekre ra e?” ");
INSERT INTO slu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rtanuk koldyesy kali iry mamin ti wen desike wamwanire bonyo anakyai ribunke enasim sir. Dendye Yesuske byu ti wasi nyasoare de byohe, “Myaso iry desikre ma rtaklulw ma kukwan it kukwan it ma kukwanke sasam o irkye hean-sim.” ");
INSERT INTO slu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lemade Yesuske wasi nyaso desikre rtoha ma raso iry a ribun lan desikre ma rtaklulw. ");
INSERT INTO slu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kyoat iry a ribun lan desikre rataklulw maktei bonyo, Yesuske yal roty desim desy ode masy deru desy ode yatnyarak ei laitke ma iten eraske ti. Lemade byiny a roty o masy desikre maktei o, yal ti wasi nyasoare ma rasakar ti ribun lan desy. ");
INSERT INTO slu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma raktemtem a raknam nini rbesur, maktei o Yesuske wasi nyasoare rili rahuk kteranare, desikeo kbyenw a kolakye hean a kresi enaru. ");
INSERT INTO slu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sekwe it huruk bonyo, Yesuske myesan a syambayan, ode wasi matoha I desikre ror I ti desy dakun. Lemade Yesuske yena sir de byohe, “Ktyoha iry ribunke mo, esei ne Yaw ne de?” ");
INSERT INTO slu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lemadendye wasi matoha I desikre rhalas I ma rbohe, “Irire dum a rbohe, Oi neke Yohanes Mababtiske. Ode iry dum a rbohe, Oi neke Elia O. Ode iry salik a rbu huruk de rbohe, Oi neke iry a manety Hulasokwe wasi nyano heitlulswoke it ne, ma myorif huruk mane.” ");
INSERT INTO slu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Lemade Yesuske yena sir huruk ma byohe, “De ktyoha e mo, mryekan o esei ne Yaw ne de?” Lemade Petrus hyalas ma byohe, “Oi neke Mesias O!” ");
INSERT INTO slu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lemade Yesuske byu eta wasi nyasoare, ma kete rahes nam desy ti esei ta esei dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ode Yesuske tyanuk huruk ma byohe, “Irkye Anankemusti mo yety ti de yety ma ti masunkwe. Ode iry manety lulw ti Yahudi-nare, ror iry mabaa klen ti irkye yor Hulasokwe neke wait usu khatunare, ror a iry mahe snurat o tnyetak Musake dakun, sir neke ribun a musti mo lema rou I. Ode irire musti mo rtabahunw I. Keskye ana sekwe enatelw bonyo, myorif huruk.” ");
INSERT INTO slu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Maktei o Yesuske tyanuk ti iry desikre mumu de byohe, “Kolnye esei desike byuma tyoha Yaw, musti mo ibu a ituli tenanke ti sai ta sai bo, ode hyar wasi tul masanwalw ike ti sew kyaki nekre.Koldyesikemo nenmo bisa ma tyoha Yaw. ");
INSERT INTO slu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ktwanuk koldyesy kali esei desike byuma kyumak eta wasi ktela idakinare ti lasmyerke khaha ne, desikemo mormyorhyanke ti wen sra eraske ana kitayar. Keskye esei desike yotuk wasi ktela idakinare ba ma tyoha Yaw, ode ires ma myaty khyali Yaw, desikemo ana myorif ti wen sra eraske nini nam. ");
INSERT INTO slu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kolnye irkye it ma wasi nuske ktem ne mumu, keskyede imaty bonyo imin ti mamaty rala, desikeo nam desikre kbuan sai ti i de? Lema kika kbuan! ");
INSERT INTO slu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ode kolnye esei desike myay ma you ohe hye Irkye Ananke ktyabal tun itanukare, desikeo kyoat Irkye Ananke ana yorw yosy wen sra eraske ma mya, ana lema you ma hye iry desy dakun. Kyoat ana Irkye Ananke mya, desikeo wasi madelahke ode amalkyauke kimin a I. Kyoat desy dakun o madelahke ode malkyakaw manosy Ama Hulasokwe kimin a I, ktyabal madelahke ode malkyakaw manosy Hulasokwe wasi nyaso nelnyely manosy laitke kimin I dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mtyomolu mamak! Ti ei ne mumu neke, dum a ana lenla mmyaty, kolnye lenla mmyatakit a Hulasokwe mya ma hyareta kola Rajake.” ");
INSERT INTO slu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kyoat Yesuske itanuk tun desikre mumu maktei, ode anakyai kbyilak sekwe walw bonyo, Yesuske yabuk Petrus, Yohanes ode Yakobus ma ror I ma raktem a rsaik bai kususwanke ma Yesuske syambayan. ");
INSERT INTO slu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Malmata Yesuske isambayan bonyo, uno mata kihihi i ti kyal wasi rabitke ma bokbok ma knyely malay dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kyala mait bonyo, irkye enaru ramdiry ma rahes tun a ror Yesuske. Iry deru ne Musa yor Elia. ");
INSERT INTO slu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Deruke tenatare kdyelah kola madelah manosy laitke ne, ode deruke rahes tun a ror Yesuske ti ktela ana lema soso bonyo imaty ne, ti ana iala ma kidi ti o Yerusalem ma ktyoha rekryeky Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kyoat desike Petrus yor lianare renaf ma rtebti, keskye kyoat rabatar bonyo, ratos Yesuske wasi madelahke, ode irkye enaru ramdiri ror I. ");
INSERT INTO slu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ode kyoat iry deru desike rala ma raditi sir toha Yesuske ma raba bonyo, Petrus a tyanuk ti Yesuske de byohe, “Amo Tuanggurw O, eras a ksyalik ti aramy mimin wen ne. Lemamo aramy msyadiri lasyerkye enatelw, ma sasam ti O, sasam ti Musa, ode sasam ti Elia dakun.” Keskyede Petrus lema hye toha nam itanukke. ");
INSERT INTO slu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Moluk a Petrus itanuk tun desy bonyo, oanke khatuke kmya ma kkyahat eta raktemtem. Ode kyoat ramin ti oanke krala desy, Petrus yor lian deru desy ramtaut a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Desikeo rtomolu telke it ma kyosy oanke krala desy ma kbyu de kbyohe, “Anakkwe I ne. I neke kilik I de. Lemade mtyomolu I!” ");
INSERT INTO slu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kyoat ratomolu tel desike maktei bonyo, Petrus yor lian deru desy ratos o lenla Yesuske myesan bo. Lemade mamwaw sir eta bo, ode kyoat desike lema rahes ti irkye it dakun ti ktela ratos desy. ");
INSERT INTO slu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bolbolke bonyo Yesuske yor Petrus tyabal lian deru desy rorw toha kususwanke. Desike bonyo iry ribunke lui-lui sir ma rma ma rait a Yesuske. ");
INSERT INTO slu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ti iry a ribun desikre irkye it a telake lan ma tyanuk de byohe, “Tuanggurw, kuten ma msweak anakkwe, kali i neke sasasam i bo. ");
INSERT INTO slu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ma seure rait mo ngkeskwakwe syukar a i, ma yala i mait ma byoran. Ode ngkeskwaw desike yayak i ti de yayak i ma, ma uhuhare kbyetik kyosy a nurno haha. Desyo ngkeskwaw desike yala i ma isike ksunw ksyalik, ode lema byuma byetik toha i elik. ");
INSERT INTO slu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ode kuten toha wasimw matoha Oare ma resak a ngkeskwaw desy, keskyede lema rala ral i.” ");
INSERT INTO slu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lemade Yesuske tyanuk ti iry ribun desikre mumu ma byohe, “Hei, ei neke mihatw, ode lema mtyohak! De ana kor e nini kolkya? Ode ana kukita nini hekyab o mtyohak Yaw de?” Lemade Yesuske tyanuk ti naman desike ama ma byohe, “Mor anamw desy ma.” ");
INSERT INTO slu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Malmata naman desike lyakut ma ti iney a Yesuske, ngkeskwaw desike byesak naman desy ti lasmyerke, ode yayak i ti de yayak i ma. Lemade Yesuske yaswel ngkeskwaw desy ma ngkeskwaw desike byetik toha naman desy ma naman desy eras a i, maktei o Yesuske yal i ti ama. ");
INSERT INTO slu_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Lemade iry ribun mamin ti desikre raktemtem a rmetratw, ti ratos Hulasokwe wasi haret lan ne. ");
INSERT INTO slu_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Kyoat desike iry desikre mumu moluk a rmetratw ti ktela ribun lan ialanare bonyo, Yesuske tyanuk ti wasi matoha Iare ma byohe, ");
INSERT INTO slu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mtyomolu mamak, ode minenenas tun kutanuk nekre. Lema soso bonyo Irkye Ananke ana ral I ba ti irire rhareta I.” ");
INSERT INTO slu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Keskyede Yesuske wasi matoha Iare lema rhe tun itanuk desikre kbuanare. Kali kbuan desikre kihunik i ti sir ma lema rrekan a rhe tun desikre kbuanare. Ode iry desikre lema rares ma rena tun desikre kbuanare toha Yesuske dakun. ");
INSERT INTO slu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lemade Yesuske wasi matoha Iare raeta tel kali robak ma rhe ohe esei ne lan i ti sir ne mumu. ");
INSERT INTO slu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Keskye Yesuske hye iry desikre nam rarekan ti ralat a kralanare, lemade yabuk a naman kakanke it, ma imdiry ti serike. ");
INSERT INTO slu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ode tyanuk ti wasi matoha Iare ma byohe, “Esei desike you ma yal naman ne khyali Yaw, desikemo kola ne you ma yal Yaw dakun. Ode esei desike you ma yal Yaw, desikemo kola ne you ma yal Hulasow a maso Yaw ne dakun. Kali esei desike nyauk tenanke ma babaf ti ei ne mumu, desikeo ti Hulasokwe ne lan a i.” ");
INSERT INTO slu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dendye Yohanes a tyanuk ti Yesuske ma byohe, “Tuanggurw, aramy myatos irkye it ma yal a Animkwe, ma yesak ngkeskwakwe. Lemade aramy mbyu eta i, kali iry desike lema yor a ity.” ");
INSERT INTO slu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lemade Yesuske tyanuk ti sir ma byohe, “Kete mbyu eta i, kali esei desike lema syorw e, i desike yor e.” ");
INSERT INTO slu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ode kyoat kyala ma kyait sew a Yesuske isai bai wen sra eras Hulasokwe imin tike bonyo, Yesuske yohut ma byai a Yerusalem. ");
INSERT INTO slu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lemade ti salke kralake bonyo, Yesuske yaso matoha Iare dum ma rmuna I ma rbai hnuke it ti propinsi Samariake, ma rasosan nam kita I. ");
INSERT INTO slu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Keskyede iry a Samaria desikre lema rou ma ral Yesuske, kali wasi laklakutke kbya kola Yerusalem. ");
INSERT INTO slu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dendye Yesuske wasi matohake enaru, neke Yakobus yor Yohanes, kyoat rhe ohe iry a Samaria-nare lema rou ma ral Yesuske bonyo, rtanuk ti Yesuske ma rbohe, “Ah, Tuanggurw, mou ma aramy myaso akye ma kyoru kyosy laitke ma knya a khyunw iry nekre e?” ");
INSERT INTO slu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Keskyede Yesuske yulak matake ma yatos sir ode yaswel sir ma byohe, “Lema koldyesy!” ");
INSERT INTO slu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lemadendye Yesuske yor matoha Iare rbai hnu salik. ");
INSERT INTO slu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lemade Yesuske yor wasi matoha Iare rsaur a wait laklakutke bai lulkwe bonyo, ti salke kralake neke irkye it ma tyanuk ti Yesuske de byohe, “Amo, kbwuma ktwoha O bai kabei ta kabei bo.” ");
INSERT INTO slu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Lemade Yesuske tyanuk ti iry desy de byohe, “Muske ika wena ma byob ti, ode manuke ika nuka, keskyede Irkye Ananke lema ika wena ma imres ode yenah ti.” ");
INSERT INTO slu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Maktei o Yesuske tyanuk ti iry salik huruk ma byohe, “Mtwoha Yaw.” Keskyede iry desike hyalas I ma byohe, “Tuanggurw, mlwura yaw ma kbwa ti kamlin amakw aduk, mamode nenmo kmwa ma ktwoha O.” ");
INSERT INTO slu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Keskye Yesuske tyanuk ti i de byohe, “Lema. De mlwura iry mamatire ma rmesan a ramlin iry mamatkye bo.Klala oi neke mbwa ti mabrita britke ti kabei ta kabei bo ohe Hulasokwe ana mya ma hyareta kola Rajake.” ");
INSERT INTO slu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ode irkye it huruk ma tyanuk ti Yesuske ma byohe, “Tuanggurw, kala ma ktwoha O, keskyede mlwura yaw ma kbwa ti ktwuly a wasikw sekye kralake aduk mamode nenmo ktwoha O.” ");
INSERT INTO slu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Keskyede Yesuske tyanuk ti iry desy ma byohe, “Kolnye irkye it a syaban lasmyerke ti boke, ode kyoat a syaban bo desy bonyo, yulak matake ma yatos ei lyakwe, desikemo wasi karya desike lema klyakut a mlay. Neke kola iry mabu ma matoha Yaw ne. Ma kolnye tyoha Yaw, keskye iry desike yulak matake ma yatos ei lyakwe, kali ralake kralake kbyuma kyolik i ti wasi mormyorif mamunake, desikemo iry desike lema byer o tyahal ma kyarya ti haret Hulasokwe.” ");
INSERT INTO slu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Maktei o, ity Ebut Yesuske syusu iry salik matoha Ike irkye hean-itw, ode yaso iry desikre raru-raru ma rmuna bai nus o hnu a ana Yesuske iba tiare. ");
INSERT INTO slu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lenla raba bonyo, Yesuske tyanuk tun inahliakke it ti sir de byohe, “Iry mabu ma matomolu Brit Eras nekre rola ne alyaw rala ma raketkye. Alyaw ne lan a ksyalik, keskyede makaryaare lema ribun sir. Lemadendye miten toha boke kebu desike ma tyabal makaryaare ma yaso sir ma rkety alyaw desy mo klyahamety. ");
INSERT INTO slu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ode mbya! Keskyede mironrony mamak a e, kali kaso e ti iry mahature. Ei ne myola dene dombake ananke ti imin asw utan mahature wait kditlalan ne. ");
INSERT INTO slu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ode miba neke mo kete myety a suhlwak, kete myety a res, ode kete myety a sososalwaw salik, de miba ne nam mamin tenamy desikre bo. Ode milakut neke, kete mihes tun a myor irit-irit ti salke kralake, kali ana minggonw. ");
INSERT INTO slu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ode kolnye msyukar ei sekye kralake it mo, mtyanuk a kmuna ma mbyohe, ‘Hulasokwe ika eras yor e ti sekye krala ne.’ ");
INSERT INTO slu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ode ti desike kolnye sekye kebuke tyomolu e, ma yal e ei wasi sekye kralake, desikemo eras desike kimin a i. Dete kolnye lema tyomolu e, ma yal e ei wasi sekye kralake, desikemo eras mitanuk desike lema kimin a i. ");
INSERT INTO slu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ode mimin ti sekye krala desy, ma kotw sai ral ti e, desikeo mi ode myenw bo. Neke mlay kali ei neke iry makarya e ma musti mo mika wasimy katy, lemade kotw o abw desikre kyeluk katkye ti e. Ode kolnye mimin ti sey desy, desikemo kete mbyetik bai sey a salik de. ");
INSERT INTO slu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ode kolnye msyukar ei nuske it, ode rou ma ror e ti nus desy, ma kotw sai ral ti e, desikemo mi bo. ");
INSERT INTO slu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ode iry isy masunw mamin ti desikre mnyoha wait a kbainare ma eras sir. Ode mbyu ti sir de mbyohe, ‘Hulasokwe mya ma hyareta kola Rajake de.’ ");
INSERT INTO slu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Keskyede kolnye msyukar ei nuske it ode lema rou ma ror e ti nus desy mo, mbyai sal lan mamin ti nus desy ode myatelamy ma mbyohe, ");
INSERT INTO slu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Heeeeei, ribun lan e! Nus neke kahu malatan ara lwaumy nekre, aramy mryitik ti ne ma kyeluk nyatos ma klyosu ohe Hulasokwe lema yor e de. Klala mnyenas! Hulasokwe mya ma hyareta kola Rajake de.’” ");
INSERT INTO slu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lemade Yesuske tyanuk huruk ti iry matoha Iare ma byohe, “Mtyomolu! Ana kyait sekwe ma Hulasokwe yukun nuske ktem ne mumu, desikeo iry mamin nus a lema rou ma ranor e neke, Hulasokwe yal masunkwe ti sir neke, ana kbyilak masunw ana madi ti iry Sodom-are ne.” ");
INSERT INTO slu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Lemade Yesuske tyanuk a syaur tunake huruk ma byohe, “Atyatke ana kidurak nus Khorazim o Betsaida sokre, biar ma iry Yahudi sir! Kali kala ktela masalsyalik iare ma kdi ti sir, keskye lema rtunik totnyo yabit atyatare. Klala kyoat desike kolnye kbwai nus Tiruske ode Sidonke, ma kala ktela masalsyalik maola kuala ti Khorazim o Betsaida sokre, desikemo iry Tirus o Sidon desikre rtunik elik a totnyo yabit atyatare, ma rhonak rabit boare, ode rritik ahkwe ti tenatare, ma klyosu o rasesal sir ti totat atyat raalanare de, biar ma sir neke lema iry Yahudi-nare dakun. ");
INSERT INTO slu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Keskyede ana kyait sekwe ma Hulasokwe yukun nuske ktem ne mumu, desikeo Hulasokwe yal masunkwe ti iry Tirus o Sidon desikre neke mran ma kbyilak masunw ana kidi ti iry Khorazim o Betsaida desikre. ");
INSERT INTO slu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Klala iry a Kapernaum-are rrekan o ana Hulasokwe byitil sir ma ti rait sra lait ne e? Lema! De sir neke ana Hulasokwe yotuk sir bai mamaty rala!” ");
INSERT INTO slu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Lemade Yesuske tyanuk huruk ti wasi matoha Iare ma byohe, “Kolnye kabei ta kabei rtomolu e, desikemo rtomolu Yaw, ode kolnye kabei ta kabei lema rou e, desyo lema rou Yaw dakun. Lemadendye kolnye irire lema rou Yaw, desikemo lema rou Hulasow a maso Yaw ne dakun.” Yesuske tyanuk maktei bonyo, iry isusu desikre rba ti rala nam iaso desikre. ");
INSERT INTO slu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Lemade iry dehean deitw matoha Yesuske neke rulak a sir o ramukmuka sir. Ode rait Yesuske ma rbu de rbohe, “Tuanggurw, tun aramy mitanukare ngkeskwaure rtoha elik, kali aramy myesak sir neke aramy myal Animkwe ma mbyaak!” ");
INSERT INTO slu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lemade Yesuske byu ti sir de byohe, “Nde. Katos ngkeskwaure wait uskwe khatuke ma di a yosy laitke, kola dene hitikke ti kinosy laitke ne. ");
INSERT INTO slu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ode klwosu ti e ohe Yaw neke kal haretke ti e de, ma kolnye msyosa niare ta lolohisinare ode rkuty a e, desikeo lema myema ksunsunuke. Ode mkyawel ngkeskwaure wait uskwe khatuke amalkyauke de, mane lema kika nam atyat madan a e elik ne. ");
INSERT INTO slu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lemade kete mimukmuka mimarmara e ti ngkeskwaure raou ti e ne, de lemamo mimukmuka mimarmara e ohe Hulasokwe kyesy animire o wen sra eras Hulasokwe imin tike.” ");
INSERT INTO slu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kyoat desike dakun o Hulasokwe Memeanke kbyenw a Yesuske, ma khyury ma imukmuka imarmara I ode syambayan ma byohe, “Amakw a Amam Lan O, Oi ne muhareta ti lait o lasmyerke khaha ne. Klweru Animkwe, kali tun dai kutanuk nekre mumu ne muhunik ti iry mahe telare. Keskye Amo, mlwosu tun nekre mumu ti iry a manauk tenatare ma babaf ne. Ode Amo, mala koldyesy kali ktela muala desy khyury ma ralamkwe kimukmuka i.” ");
INSERT INTO slu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesuske syambayan maktei bonyo, tyanuk ti iry mamin ti desikre ma byohe, “Amaku yal haretke ma khwareta nam nekre mumu de. Ode lema kika iry mahe Yaw, de lenla Amaku myesan bo. Ode lema kika iry mahe Amakw, de lenla Anan Yaw kmwesan bo, ktwabal a iry kudakin ma kulosu Amakw ti sir ma rhe I ne dakun.” ");
INSERT INTO slu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Maktei o Yesuske yulak matake sara wasi matoha Iare, ode yal mesmesan ma tyanuk ti sir ma byohe, “Eraske kimin e kali mmyatakit ktela kuala nekre mumu. ");
INSERT INTO slu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lemade klwosu ti e ohe heitlulswo iry manety Hulasokwe wasi nyanoare ror raja-nare robak ma rtomolu ode ratos nam a miatos ode mitomolu ti senwekre, keskyede lema ratos ode lema rtomolu, kali rmaty kmuna de.” ");
INSERT INTO slu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kyoat sekwe it bonyo, iry mahe snurat o tnyetak Musake it neke yobak ma hyury Yesuske. Lemade imdiry ma yena Yesuske ma byohe, “Tuanggurw, kala kolkyabei ma musti mo kmworif ti wen sra eraske nini nam de?” ");
INSERT INTO slu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lemade Yesuske byu ti i de byohe, “Sai rkesy ti tnyetak Musake de? Ode sai ne mubaca o so ne de?” ");
INSERT INTO slu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iry desike hyalas ma byohe, “Tnyetak Musake kbyohe, ‘Musti mo mdwakin Ebumw Hulasokwe, kyor wasimw mormyorifke mumu, kyor amalkyaumkwe mumu, kyor nam murekan nekre mumu, ode ktyabal ralamkwe kralake mumu. Ode musti mo mlwobak irire, kola dene mulobak tenamkwe kimesan ne dakun.’” ");
INSERT INTO slu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lemade Yesuske byu ti i de byohe, “Mlay! Kolnye mtwoha tunamw mutanuk desy, desikemo ana mmworif nini nam.” ");
INSERT INTO slu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Keskyede iry desike yobak a mlakye ti tenanke, dendye byu ti Yesuske de byohe, “Nam rakesy desy kbyuma klwobak wasikw irire. ‘Wasikw irire’ ne esekar de?” ");
INSERT INTO slu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Lemade Yesuske hyalas iry desike de byohe, “Wamwankye it, neke iry Yahudike ma yorw yosy a Yerusalem ma byai nus Yerikhoke. Inait salke kditlalan ne bonyo, kele rsoru manametare ma rkumak i ma rasoruk wasi nam inetire mumu ktyabal rabit mamin ti tenanke dakun, ode roban de rtaba i ma imnu a imlarit ma nenma myaty. Maktei o rtutuk lakhidik i ti desy ma rba. ");
INSERT INTO slu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lema soso bonyo iry Yahudike it ma byaa klen ti irkye yor Hulasokwe neke lyakut ti sal desike dakun. Lemade yatos iry mamnu desike bonyo, lyakut a syery ma yosy salke seridake ma bya. ");
INSERT INTO slu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kola ne iry a Lewike it ma kyarya ti Hulasokwe Seike, neke lyakut ti sal desy dakun. Ode kyoat iatos iry mamnu desy, desikeo lyakut a syery ma yosy salke seridake ma bya. ");
INSERT INTO slu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Keskyede lema soso bonyo iry a lema Yahudike it ma yosy Samaria,neke lyakut ti sal desy ma yosy wen desy dakun. Ode kyoat iatos iry mamnu desy bonyo, ralake krala ne klyobak i a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lemade yarasik iry desy ma byihy soranare, ode yal tasy maiskye kwen makitkye ma yalik ti soranare ma yala ma nelnyely. Maktei o yalik nul zaitunke ti soran desikre, ode yal kainke klaike ma yal ma lyel soran desikre. Maktei o syalak i ti wasi keledaike ma yor a i ma rbai sey iselw ma imin tike, ma syeak i ti desy. ");
INSERT INTO slu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bolbolke bonyo, iry a Samariake yal kuban blyawan bokbokkeenaru ti sekye kebuke, ode byu ti i de byohe, ‘Kala ma kbwa mane. Lemade kuten ma msweak iry ne mamak. Ode kolnye muhwely ma kbyilak kuban kunal ti o ne, ana kulak yaw, desikeo keluk ti o.’” ");
INSERT INTO slu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lemadendye Yesuske yena iry mahe snurat o tnyetak Musa desy ma byohe, “Ti iry detelw ne, mrwekan mo esei yola iry a manametare raoban ne wasi irire de?” ");
INSERT INTO slu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iry desike hyalas ma byu de byohe, “Iry dai masusu wasi loblobakke ti iry a raoban desy.” Lemade Yesuske byu ti i de byohe, “Mbwa, ode mala koldyesy.” ");
INSERT INTO slu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuske yor wasi matoha Iare rsaur wait laklakutke bai Yerusalem huruk. Ma ranait hnuke it bonyo, wamfwetke it ma ani Marta, neke yal Yesuske ei wasi sekye. ");
INSERT INTO slu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta neke wai-na ani Maria, ma Maria neke tyaklulw ma nyey a ity Ebut Yesuske ode mamwamwaw i ma tyomolu tun itanukare. ");
INSERT INTO slu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Keskye Marta neke yety ti de yety ma, ma isosan sekye kralake ode kotw o abw dakun. Dendye Marta mya ma nyey a Yesuske ode byu ti I de byohe, “Ebo, lema mlwobak yaw e? Waiku tyaklulw bo, klala yaw neke kmwesan a kkwarya. Lemamo maso i ma syaluk yaw aduk.” ");
INSERT INTO slu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Keskyede ity Ebut Yesuske hyalas i ma byohe, “Marta, ralamkwe kakan, ode muhdawan tenamkwe khyali karya ribun nekre. ");
INSERT INTO slu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Keskyede lema mhwe ohe karyake it mo eras ma kbyilak karya nekre mumu. Ma Maria neke yilik a karya desy, ode ana lema kika iry manal toha i elik.” ");
INSERT INTO slu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sekwe it bonyo Yesuske syambayan ti wenke it. Kyoat isambayan maktei, desikeo wasi matoha Ike it a mya ma byu ti I de byohe, “Tuanggurw, majar ktela sambayanke ma aramy, kola dene Yohanes Mababtiske yajar wasi matoha iare ti ktela sambayanke dakun ne.” ");
INSERT INTO slu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lemadendye Yesuske byu ti sir de byohe, “Kolnye msyambayan mo, msyambayan kolnye, Oo, Amo! Aramy miten ma aramy mumu ti lasmyerke khaha ne myalan a O, kali Animkwe nelnyely. Ode aramy miten ma mmwa kola Rajake ne ma mhwareta aramy mumu. ");
INSERT INTO slu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ode aramy miten toha O ma senweke, mal kotw o abw ma kyoat mamak aramy. ");
INSERT INTO slu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ode mswos ara salamire ba, kola dene, aramy misos iry maka salat ma aramy ne dakun. Ode kete mlwura aramy, ma nam dum a khyury aramy ma kyor aramy ei atyatke.” ");
INSERT INTO slu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lemade Yesuske ihliak tunke ti iry desikre de byohe, “Kolnye metdyet a kditlan ne, irkye it a byai lianke it a wasi sekye ma byu ti i de byohe, ‘Liakw, mal a roty desike enatelw ma yaw aduk. ");
INSERT INTO slu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kali liakkwe it a yosy soso ma nenmo mya ma i desy wasikw sekye, keskyede lema kika namit-namit ma kal ti nya ode yenw.’ ");
INSERT INTO slu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lemade kolnye lian desike hyalas yosy sekye kralake ma byohe, ‘Kete moha yaw, kali khwolat eta holholatke, ma kor anakure aramy myenaf de. Ode kubrai kbwatar ma kal kotw ti o.’” ");
INSERT INTO slu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Lemade Yesuske tyanuk huruk ma byohe, “Ode mtyomolu. Kolnye khyehyeike ibrai byatar, biar ma iry desike lianke dakun, keskyede iry desike lema myay hye de iten nini nam bo. Lemade kalyauke bonyo lian desike byatar ma yal nam itenke ti i. ");
INSERT INTO slu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Khyali ktela desike mane ktwanuk ti e ma kbwohe: Miten, desikemo ana Hulasokwe yal ti e. Myobak, desikemo ana mitot. Mtyoky holholatke, desikemo ana Hulasokwe lyakat holholatke ti e. ");
INSERT INTO slu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kali iry matenke mo, ana yal ti i. Iry maobakke mo, ana itot. Ode iry matokkye mo, holholatke ana kimlakat ti i. ");
INSERT INTO slu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ti ei ne mumu neke amamke it, ma kolnye ananke iten maskye toha i, desikeo ana yal nike ti i e? Lema. ");
INSERT INTO slu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Dete lemamo iten sihkye ktesuke, desikeo yal sakdokye ti i e? Lema ode? ");
INSERT INTO slu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","De biar ma iry mahatw a e dakun, keskye myal a mhye nam eraske ti anamire. Klala Amamy Hulasow mamin wen sra eras ne lema ihatw, de eras I a ksyalik, desikeo yala hye ma kbyilak e dakun ma yal nam eras lan de lan ne ti e. Neke ana yal Hulasokwe Memeanke ti iry maten toha Iare!” ");
INSERT INTO slu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sekwe it huruk bonyo, Yesuske yor iry ribun lan nekre. Ti desike dakun o irkye it ma nunuke ktem, kali ngkeskwakwe yala i. Lemade Yesuske yesak ngkeskwaw desy toha iry desy, ma ngkeskwaw desike ibetik toha iry desy bonyo, iry desike itun mait, ode iry ribun lan ne rmetratw ti ratos ktela desy. ");
INSERT INTO slu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Keskyede ti iry ribun desikre dum a rbohe, “Yesuske yesak ngkeskwaw neke yal Beelzebul amalkyauke. Beelzebul neke ika usu khatu ti ngkeskwaw desikre mumu.” ");
INSERT INTO slu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ode irire dum dakun o robak a ksala ma rhury Yesuske. Lemade raten toha Yesuske ma yala nyatos manosy Hulasokwe ma rhe o Yesuske neke amalkyauke kyosy Hulasokwe ta lema. ");
INSERT INTO slu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Keskye Yesuske hye nam rarekanke, lemade tyanuk ma byohe, “Ti nuske it ma iry mamin tiare rahe a rasakar sir ma it de syorw a it ma rakahrea, dendye khyury ma nus desike kiskyui-kiskyay. Kola dene ti sey kralanare kiskyui-kiskyay dakun, kali it de syorw sal a it ma rakahrea. ");
INSERT INTO slu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Koldyesy dakun o kolnye ngkeskwaure wait uskwe khatuke yor wasi ngkeskwaw matoha iare rahe a rasakar sir, ma it de syorw a it ma rakahrea, dendye khyury ma ana ngkeskwaure wait haret desike kiskyui-kiskyay. Keskye mbyohe kuesak ngkeskwakwe ne kal Beelzebul amalkyauke. ");
INSERT INTO slu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lemade kena e aduk. The ohe wasimy matoha eare resak ngkeskwaure dakun, mane malkyakaw kabei ne ranal ma raesak ngkeskwaure ne de? Beelzebul dakun e? Lema! De kyanmwane mbyohe Yaw ne kal Beelzebul amalkyauke ma kesak ngkeskwakwe klala wasimy matoha eare lema! Wasimy ktela ne klyosu ohe misal ma Yaw. ");
INSERT INTO slu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Keskyede Yaw ne kal Hulasokwe amalkyauke ma kesak ngkeskwakwe. Ode ktela kuala neke klyosu ohe mlay bain o Hulasokwe mya ma hyareta kola Rajake neke kmya ti e mane.” ");
INSERT INTO slu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesuske ihliak tunke ma byohe, “Ngkeskwaure wait uskwe khatuke yola iry a malkyakakwe it. Ma kolnye wasi krakye, desikemo yal ma ijaga wasi sekye ma wasi nam ribun nekre lema kitayar. ");
INSERT INTO slu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Keskyede kolnye iry salikke it a mya, ma malkyakaw a i ma byilak iry desike, ode yala yal a i. Lemade isoruk iry desike wasi kray inal ma iresak desy, ktyabal nam ribun mamin wasi sey desy, maktei o ihe a isakar nam isoruk desikre mumu ti irire. ");
INSERT INTO slu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Esei desike lema tyoha Yaw, desikemo yobak ma syorw a Yaw. Ode esei desike lema syaluk Yaw ti karyaakkwe, desikemo i ne iskyui-iskyay karyaakure ne.” ");
INSERT INTO slu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Lemade Yesuske tyanuk huruk ma byohe, “Kolnye ngkeskwakwe resak i toha irkye, desikemo lema kika wen ma imin ti, de nyem ti de nyem ma ti wen malosy-loskye. Ode yobak wen ma imin ti, keskye lema itot. Lemade tyanuk ma byohe, ‘Lemamo kolik yaw ei wenakw a kubetik tohake.’ ");
INSERT INTO slu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lemade ngkeskwaw desike yolik i bai iry a ibetik tohake, desikeo yatos o iry desike yola sey rasosan ode rasoly kralake ma eras ne keskye lema kika iry ma ramin ti kralake. ");
INSERT INTO slu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lemade ngkeskwaw desike bya ti ryubut ngkeskwakwe itw neke rahatw ksyalik ma rbilak a i, ode yor sir ma rma ma rsukar iry desy huruk ma rmon ti. Lemadendye iry desike isike ksunw ma lan ma kbyilak a khyehyeike.” ");
INSERT INTO slu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kyoat Yesuske moluk a tyanuk tunare ti iry ribun desikre, desikeo wamfwetke it a yatela ma tyanuk ti Yesuske de byohe, “Eraske ti enen a madur hahak a Oke, ode masusw a Oke!” ");
INSERT INTO slu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Keskye Yesuske hyalas i ma byohe, “Lema koldyesy. De eraske kimin ti iry a matomolu ode matoha Hulasokwe tunanare.” ");
INSERT INTO slu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kyoat iry ribun lan ne moluk a rkoal Yesuske, desikeo Yesuske tyanuk ti sir ma byohe, “Taras neke taras iry mahature. Iry mamin taras neke rbuma kala nyatos harharkwe it ti sir ma rtohak a Yaw, keskyede ana kal nyatoske sasam ti sir bo. Neke nyatos a madi ti Yunus iry manety Hulasokwe wasi nyanoke. ");
INSERT INTO slu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Heitlulswo Yunus yeluk nyatos ti iry a Niniwe-nare, kola ne Irkye Anankeana yeluk nyatos ti taras ne dakun. ");
INSERT INTO slu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Heitlulswo ratuke it yosy nus a kseri tran so. Ode mya ma tyomolu heheke toha raja Salomo, biar ma ratu ne wasi nuske soso a ksyalik. Klala senwe ti wen ne Irkye it ma lan a I ma byilak Salomo, keskyede taras neke lema rtomolu I. Lemadendye kolnye nuske ktem neke ktei ode Hulasokwe yukun irire mumu, desikeo ratu neke ana imdiri yor iry a taras ne ma tyudu sir o sal sir. ");
INSERT INTO slu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kyoat nuske ktem neke ktei ode Hulasokwe yukun irire mumu bonyo, iry a Niniwe-nare ramdiri ror a iry mamorif ti taras ne ma rtudu iry mamin taras ne o sal sir. Kali iry Niniwe-nare rtunik totat atyatare kyoat ratomolu brit a Yunus itanukke. Keskyede ti senweke Irkye it lan a I ma byilak Yunus ma mya ti taras ne ma tyanuk dakun, keskye taras ne lema rhaduli ma rtomolu I ode lema rtunik totat atyatare.” ");
INSERT INTO slu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Lemade Yesuske ihliak tunke ma byohe, “Lema irkye it a tyunw damarke ode itina ti wen mabunkye it ta lemamo yal ei lkuskye kralake ma kkyahat eta, de musti mo tyunw damar desy, ode yal ei kwenake ma kkyela, ma kolnye irire rsukar mo rmatakit kelelanke. ");
INSERT INTO slu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Koldyesy dakun o matamu khatunare kyeluk damar ti tenamkwe, ma kolnye matamkwe eras ma kmyatakit, desikemo ana tenamkwe knyely, dete kolnye matamkwe kbyol, desikemo ana tenamkwe kbyenw ti kelerakokke. ");
INSERT INTO slu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Koldyesikemo msweak mamak ma, manely manosy Hulasow mamin ti o ne, kete mhwury ma, kelerakokke kyulak i ma kimin a o huruk. ");
INSERT INTO slu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lemadendye kolnye tenamkwe ktem ne knyely, ma lema kika kelerakokke it ti, desikemo tenamkwe kbyenw ti manelkye, ma kola dene damarke wasi kelelanke ti kkyela o ne.” ");
INSERT INTO slu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kyoat Yesuske yajar irire maktei bonyo, iry Farisike it a iten a I ma rba ti raknam ti wasi sekye. Lemade Yesuske syukar ei sey desy ti tyaklulw ma iknam. ");
INSERT INTO slu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Keskye Yesuske lenla yut simanare bonyo iknam. Ma iry Farisi desike yatos a ktela desy bonyo myetratw, kali Yesuske lema tyoha Yahudi-nare wait ktela kubkubakke. ");
INSERT INTO slu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lemade ity Ebut Yesuske tyanuk ti iry desy ma byohe, “Iry a Farisi e, ei ne myola iry a kyalamo maut a taw o antyahw ne, ma indil ma yut ketake bo, klala kralake lema yut, de kiray nggora. Kola ne ei ne dakun ma myut simamire, keskye ralamire lema nelnyely, kali mihatw ode mdyakin irire wait namit-namit. ");
INSERT INTO slu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hei, iry ktem e! Lema mhye o Hulasokwe I ne iala ketake ode kralake dakun ne e? ");
INSERT INTO slu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lemadendye kete mryekan ti ketake bo, de musti mo kyosy ralamy erasare ma mitera nam ti iry a lema manait ei sra o hahke. Kyoat miala koldyesy bonyo, tenamy o ralamy nekre nelnyely mumu. ");
INSERT INTO slu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Keskye iry Farisi e, atyatke kidurak e! Biar ma mindil ma wasimy boa kisinare mumu neke myal sasam toha heanke ma myal ti Hulasokwe, ma ti kyal nam kakan nekre mumu, kola ne maresan o, selasi o, wakw mahon o, bawang mermerke, ode ktyabal nam salik mitan desikre dakun. Keskyede lema mtyoha ma mimdiry ti nam a mlaire, ode lema mdyakin Hulasokwe. De musti mo myala ktela mlay desikre, neke musti mo mimdiry ti nam a mlaire ode musti mo mdyakin Hulasokwe. Ode kete mimluak ma myal sasam toha heanke ti Hulasokwe dakun. ");
INSERT INTO slu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Iry Farisi e, atyatke kidurak e! Kali mdyakin ma msyukar Yahudi-nare wait sey a rasambayan tike ma mtyaklulw ti kader mamin lulkwe. Ode mdyakin ma irire rou ti e ti srat a kralanare dakun. ");
INSERT INTO slu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iry Farisi e, atyatke kidurak e! Kali myola ne asake, ti lema kika nyatos ti ne, ma irire lema rhe o asake ne. De irire rlakut ti asake khaha desy, keskye lema rhe o asake krala desy busu ode khyon. Kola ei ne dakun, ma irire rseak e, ode rrekan ohe ei ne iry eras e, keskyede ralamire atyat ode khyon.” ");
INSERT INTO slu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lemade iry mahe snurat o tnyetak Musa desike it a hyalas ode tyanuk ti Yesuske ma byohe, “Tuanggurw, kyoat mutanuk koldyesy ti iry Farisi-nare, desikeo mukanak aramy dakun ma desy.” ");
INSERT INTO slu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Keskyede Yesuske hyalas i ma byohe, “Atyatke kidurak e dakun, iry mahe snurat o tnyetak Musa e! Kali mtyenuk tnyetak kubkubak ribun nekre ti irire ma rtoha, keskye tnyetak nekre ribun ma mdedan kola harhar ne, ma irire lema rhar a ral. Keskye ei ne lema msyaluk sir tebibikan dakun. ");
INSERT INTO slu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Atyatke kidurak e huruk! Kali msyadiri sey mamaty eras nekre, ti iry manety Hulasokwe wasi nyano a heitlulswokre. Keskyede heitlulswo ebnwo matrumamy lema rtomolu iry manety Hulasokwe wasi nyano desikre, de rtabahunw a sir. ");
INSERT INTO slu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ode ei ne myola ebnwo matrumamy desikre, kali lema mtyomolu iry manety Hulasokwe wasi nyano desikre dakun. Neke klyosu o myou ebnwo matrumamy wait ktelanare, biar ma ei ne msyadiri sey mamaty eras nekre ti iry manety Hulasokwe wasi nyano desikre dakun. ");
INSERT INTO slu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ode kali koldyesy, heitlulswo Hulasokwe yal heheake ma tyanuk de byohe, ‘Ana kaso iry manety wasikw nyanoare ti iry Yahudi-nare. Keskye iry Yahudi-nare lema rou sir, de roban de rtaba dum, ode rtabahunw dum dakun.’ ");
INSERT INTO slu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lemadendye Hulasokwe ana yukun taras ne ma ksunw, kali taras neke mhyar harhar iry manety Hulasokwe wasi nyanoare ti wait matmyaty nekre mumu kyala kyosy khyehyeike ti kyoat Hulasokwe yala nuske ktem ne ma ti kyait senwe. ");
INSERT INTO slu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Neke kyala kyosy Habel larake ti kyoat Kain tyabahunw a i, ma ti kyait Zakharia larake ti kyoat rtabahunw a i ti klelan Hulasokwe Seike kyor lat raeh heal ti Hulasokwe ne. Lemade klwosu ti e ohe Hulasokwe ana yukun e ma ksunw, kali taras ne mhyar iry Yahudi-nare wait ktela atyat desikre mumu. ");
INSERT INTO slu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hei iry mahe snurat o tnyetak e, atyatke kidurak e! Kali kola ne mkyumak kuskus holholat Hulasokwe heheake kimin tike, keskye ei neke lema mbyuma msyukar ei kralake ma mhye I. De iry maobak ma masukar ei kralake ma hye I, desikeo mbya eta i.” ");
INSERT INTO slu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kyoat Yesuske tyanuk tun desikre mumu maktei bonyo, byetik toha iry Farisi desike wasi sekye. Desikeo kyala kyosy sew desike, iry mahe snurat o tnyetak Musake, ror iry Farisi-nare rkeyer a I, ode rhury I ma rena I ti tunare o hye ta lema de. ");
INSERT INTO slu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ode robak ma rsuy de rkait I ti tun a itanukare ma rtudu I o sal a I. ");
INSERT INTO slu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kyoat desike dakun o iry ribunke rma ma rkoal Yesuske mo ribun sir a ksyalik, ma it de syosa it lwaut. Lemade Yesuske tyanuk ti wasi matoha Iare kmuna de byohe, “Mironrony mamak a e ti iry manosy lui Farisi desikre wait a ktelake, kali rtanuk a ksyalik i ode rlakut a ksyalik i. ");
INSERT INTO slu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Keskye lema kika nam matina i ma ana lema rmatakit, ode lema kika nam mahunik i ma ana lema kbyetik. ");
INSERT INTO slu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ode sai mtyanuk ma kihunik i ti kelerakokke, ana kibetik ti madelahke bo, ode sai mibububw ti sekye kralake, ana ratelat ti mloskye ma irire rtomolu ode raheke bo. ");
INSERT INTO slu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","O liakw e. Klwosu ti e, kete mimtaut iry a maala ma matabahunw tenamire ne, kali ana lema rala ral namit-namit ma kbyilak ti ratabahunw tenamire ne. ");
INSERT INTO slu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ana kswusu ti e ohe esei ne musti mo mimtaut I ne de. Mimtaut a Hulasokwe bo, kali kolnye tyabahunw irkye mo, I neke hyareta ma yotuk iry desy ei mamaty rala. Lemade ktwanuk ti e, ma mimtaut Hulasokwe bo. ");
INSERT INTO slu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Irire kyalamo rliw manu lmuanke mo hesike kakan bo. Keskyede Hulasokwe lema imluak manuke sasam dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kola dene hukamire dakun, kali Hulasokwe yaki ma hye karyarike mumu de. Lemade kete mimtaut, kali ti Hulasokwe ei neke myety mdedan ma kbyilak manu lmuan desikre.” ");
INSERT INTO slu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuske tyanuk ti sir huruk de byohe, “Kolnye esei desike you Yaw ti ribunke, desikemo Irkye Anankeana you iry desy dakun ti Hulasokwe wasi nyaso ribun manosy laitke. ");
INSERT INTO slu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Keskyede esei desike ibu a ituly Yaw ti ribunke, desikeo Irkye Ananke ibu a ituly iry desy dakun ti Hulasokwe wasi nyaso ribun manosy laitke. ");
INSERT INTO slu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kolnye esei desike ikanak Irkye Ananke, ana Hulasokwe bisa ma syos sala desy. Keskyede esei desike ikanak Hulasokwe Memeanke, ana Hulasokwe lema syos sala desy ba. ");
INSERT INTO slu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ode kolnye rhait e bai Yahudi-nare wait sey rasambayan tiare, ma rmanadu e ti iry matetak tunare ti desy, ta rhait e ti iry lan maharetanare ma rmanadu e ti nusare, desikemo kete ralamire kakan ti tun ana mitanuk ma mibelat eta tenamire. ");
INSERT INTO slu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kali sew desike dakun o Hulasokwe Memeanke ksyusu ti e, ti nam ana mitanukke.” ");
INSERT INTO slu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kyoat desikeo ti iry ribun desikre irkye it a tyanuk ti Yesuske ma byohe, “Tuanggurw, maso waikw ma ihe ara wasimy malolkye ma ara miru.” ");
INSERT INTO slu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Keskyede Yesuske hyalas iry desy ma byohe, “Esei ne inal Yaw ma kuohut tun ode kubaa klen ti munor waimw ne de?” ");
INSERT INTO slu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lemade Yesuske tyanuk ti iry ribun desikre ma byohe, “Mryekan mamak e, ode mironrony mamak e, ma kete mdyakin malolkye. Kali lema kika kbuan ti mimorif ti wasimy maloly lanke ne.” ");
INSERT INTO slu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Maktei o tyanuk tun inahliakke it ti sir ma byohe, “Iry maka malolkye it, ma wasi boke kisi ma mausw ti i a ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lemade iry desike ryekan ti ralake ma byohe, ‘Edo, lema kika wen ma kswosan wasikw bo a kisinare ti. Desikemo ana kala sai de? ");
INSERT INTO slu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oh! Khwe nam ana kualake de! Ana kuskyaik sey nusw nekre, ode kswadiri sey nusw lan lahukare ma kswosan gandum o, lan o hnutakw nekre ti mumu. ");
INSERT INTO slu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Maktei o yaw ne mausw ma yaw de, kali wasikw malolkye ana kyal ain a ktemare. Lemadendye ana lema kkwarya de, de kswenan bo. Ma kukita ma kuknam o kenw, ode kumukmuka yaw bo!’ ");
INSERT INTO slu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Keskyede Hulasokwe tyanuk ti i ma byohe, ‘Hei, iry ktem o! Metdyet ne dakun o ana mmwaty! Ode malolimw ribun musosan desikre ana ese syaa i ti de?’” ");
INSERT INTO slu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maktei o Yesuske tyanuk ma byohe, “Ana koldyesy dakun ti iry mawahuk malolkye ma mausw ti i, keskye ti Hulasokwe lema mausw ti i.” ");
INSERT INTO slu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuske tyanuk ti wasi matoha Iare ma byohe, “Lemadendye ktwanuk ti e, kete ralamire kakan ti mimorif neke o, ana kika kotw o abw ma mi ta lema de. Koldyesy dakun o kete ralamire kakan ti tenamire o, ana kika simbol o rabit ma mhyonak ta lema de. ");
INSERT INTO slu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kali mormyorif neke kbuanke kbyilak kotw o abw desikre, ode ity tenat nekre kika kbuan ma kbyilak simbol o rabit desikre dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ode myatos manu alal desikre, lema rkay hinkye, ode lema ral kotu kisinare, ode lema raka wait sey nusw dakun. Keskye raknam bo, kali Hulasokwe yal kotw ti sir. Kbyilak ti desy dakun o, Hulasokwe syeak ma ity dakun, kali ti Hulasokwe, iry a ity neke tety alalan ma tbilak manu desikre. ");
INSERT INTO slu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ti ei ne mumu neke, esei ralake kakan, desikemo rala kakan desike ana ktyabal wasi ainke jamke sasam, ma narnarw huruk ti imorif ei lulkwe ne e? Lema! ");
INSERT INTO slu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lemade kolnye rala kakan desike lema kyala kyal nam kakan maola jamke sasam desy, desikemo kyanmwane ralamire kakan ti nam salno salik ti nuske ktem ne de? ");
INSERT INTO slu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Myatos a tnyei tubunamake khuna eras desy, lema kkyarya namit-namit ode lema kitenw tais a khye, keskye mtyomolu ma ktwanuk ti e, raja Salomo iry maka maloly desike ti heitlulswo, hyonak a i mo kersan ne, keskye lema eras ma kola tnyei tubunamake khuna desike it dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lemade tnyei mamin ti bo a krala nekre kimin senwe, ode bolbolke bonyo rotuk ei akye kralake. Keskye Hulasokwe syamur tnyei desikre ma eras. Kbyilak ti desy dakun o, Hulasokwe ana syamur e dakun! Keskye lema mtyohak o Hulasokwe lyobak e ma kbyilak tnyei desikre, mane wasimy tohtohakke ti Hulasokwe ne tebikan bo! ");
INSERT INTO slu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lemade kete usumy khatunare ksunw ma miobak o ana mi sai ode ana myenw sai. Ode kete ralamire kakan dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kali nam desikre mumu neke iry lema mahe Hulasokwe sir ne raobobak nam desikre ne. Keskyede Amamy mamin ti wen sra eraske hye nam mibuare mumu de. ");
INSERT INTO slu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lemadendye myobak ma mtyoha Hulasokwe wasi haretare kola wasimy Rajake ne, desikemo ana Hulasokwe tyabal nam ribun salno salik nekre mumu ti e.” ");
INSERT INTO slu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Liakw matoha Yaw e, ei neke myola dene lui domba ru ta telw ne. Keskye kete mimtaut, kali Amamy Hulasokwe you e ti ralake, ode ana yal e ti wen ihareta kola Rajake ne dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lemadendye mkyeta lan o hnutamy, ode mihe ti iry a lema manait sra o hah nekre. Kolnye myala koldyesy mo, kola dene misosan wasimy malolkye ti wen sra eraske. Kola dene msyosan kubanke ti suhlwakke kralake, ode suhlwak desike ana lema atyat elik de harharharu bo. Ti wen sra eraske, wasimy malolkye lema kitayar, kali manametare lema rarasik, ode dedire lema rteta dakun. ");
INSERT INTO slu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Myala koldyesy, kali kolnye malolimkye kimin kabei desy, desikeo ralamire kimin ti desy dakun.” ");
INSERT INTO slu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesuske tyanuk huruk ma byohe, “Kete mikbo. De misosan mamak a e, ma mkyarya ti Hulasokwe metdyet o msarin ne, kola dene iry a mahonak rabit nelnyely ma kyarya ti wasi amam lanke ne ma tyun wasi damarke ma kyela nini nam bo. ");
INSERT INTO slu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Misosan mamak e, ma myola at a makita wait lalanke, ma kolnye lalanke yulak i a yosy a iry masaare, ode kolnye mya ma tyoky holholatke, desikemo ado rlakat holholatke ti i. ");
INSERT INTO slu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eraske ti at desikre, kali kyoat wait lalanke yulak i ma myai wasi sekye, desikeo at desikre lema renaf, de rakita i. Lemade ktwanuk ti e, eraske ti sir, kali ana wait lalanke hyonak i ma kyarya, ode yaso wasi at desikre ma rtaklulw, ode i neke ana syalwir ti sir. ");
INSERT INTO slu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eraske ti at desikre kolnye wait lalan desike mya o yait sir ma rakita i, biar ma mya metdyet a kditlan ta nyamo ne, keskye lema renaf de rakita i bo. ");
INSERT INTO slu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mnyenas mamak wasikw inahliak ne. Kolnye sekye kebuke hye o kyoban enai ti kyoat manamet desike ana ima ne, lemade sekye kebu desike dakun o ana ijaga mamamak ma iry manamet desike lema syukar ei wasi sekye kralake elik. ");
INSERT INTO slu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Koldyesy dakun o ei ne musti mo misosan e mamak ma mikita, kali Irkye Ananke ana mya, keskye miktemtem neke lema mhye o hekyabei de.” ");
INSERT INTO slu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lemade Petrus tyanuk ma byohe, “Tuanggurw, muhliak tun ne ma aramy, ta ti iry ribun ne de?” ");
INSERT INTO slu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lemade ity Ebut Yesuske hyalas i de byohe, “Ti ei ne mumu ne, ese kyarya mamak ti wasi lalanke, ode hye telke ode itotomolu tel, desikemo iry desike wasi lalanke ana byitil i, ma ika usu khatu ti wasi makarya idanare, ma sew kyaki nekre ihe kotw ti sir ma ra. ");
INSERT INTO slu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ana eras a ksyalik ti makarya desy, kolnye wasi lalanke yulak i ma syeak makarya desy bonyo, moluk a kyarya karyaa wasi lalanke inal ti i desy nggora. ");
INSERT INTO slu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ode mtyomolu! Kolnye lalan desy syeak o iry makarya desy moluk a kyarya, desikemo lalan desike ana byitil makarya desy huruk ma syosan lalan desy wasi malolkye, ktyabal lan o hnutan desikre mumu. ");
INSERT INTO slu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Keskye anakyai makarya desike ryekan o wasi lalanke ana lenla mya, de soso i a nggora. Koldyesikemo makarya desike ana yoban makarya idanare, ode iknam lan, ode yenw tua ma kyala i. ");
INSERT INTO slu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dendye wasi lalanke yulak i ma yait makarya desy, ti sew irire lema rahe tohake. Ode lalan desike yatos ktela makarya desike bonyo, kyeyer a ksyalik. Lemade tyusy o kyasir wasi makarya desy, ode yotuk i bai iry a lema matohakare wen ramin tike. ");
INSERT INTO slu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ode kolnye iry makaryake ma hye ktela wasi lalanke ibuare, keskye lema isosan i mamak, ode lema tyoha ma yala ktela desikre, desikemo wasi lalanke ana yoban a i ma ksunw ksyalik. ");
INSERT INTO slu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Keskyede kolnye iry makaryake yala ktela salare, kali lema hye ktela wasi lalanke ibuare, lemade wasi lalanke ana yoban kakan i bo. Kali esei desike Hulasokwe yal eraske lan ti i, iry desy musti mo kyarya lan ti Hulasokwe dakun. Ode esei desike Hulasokwe yal haretke ti i ma lan, iry desy musti mo yala mamamak haret lan desy ti Hulasokwe dakun.” ");
INSERT INTO slu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Lemade Yesuske tyanuk huruk ma byohe, “Kmwa ma kety akye ma ana korif ti lasmyerke khaha ne, ma khyury irire ma rahe a rasakar sir. Ode kdwakin a ksyalik ti kolnye ay desike kisorw de. ");
INSERT INTO slu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Keskye musti mo kety ti de kety ma ti masunkwe aduk. Ode ralakw ne kitol, kolnye masunw neke lenla kdi ti ma Yaw maktei. ");
INSERT INTO slu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kete mryekan o kmwa ma kala e ma mika eras ti lasmyerke khaha ne. Lema koldyesy! De klwosu ti e, kmwa ma kala irire ma it de syorw it ma rakahrea. ");
INSERT INTO slu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kali kyala kyosy ne, kolnye irkye enasim ramin ti sekye kralake, desikeo ana rahe a rasakar sir, ma irkye enatelw rsorw irkye enaru, ode irkye enaru rsorw irkye enatelw. ");
INSERT INTO slu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Neke ti sekye kralake amam desy syorw anan wamwankye, ode anan wamwany desy syorw ama. Enen desy syorw anan wamfwetke, ode anan wamfwet desy syorw ena. Enen desy syorw sobaike dakun, ode sobay desike syorw ryana wamfwet desy. Sir neke rakahrea khyali Yaw.” ");
INSERT INTO slu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuske tyanuk huruk ti iry ribun desikre ma byohe, “Kolnye msyeak oanke ma ksyai ti kseri haratke, desikeo mtyanuk ma mbyohe ana uske lan, lemade ktela desike kdi ti. ");
INSERT INTO slu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ode kolnye mkyoman eskwe ma ksiri kyosy a tranke, desikeo mtyanuk ma mbyohe ana sew manaske, bonyo ktela desike ana kdi ti. ");
INSERT INTO slu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hei, iry makakmet e! Ei neke mhye telke ma msyeak a mhye lasmyerke khaha ne ode lait ne, ma mhye o ana ktela sai ne kidi ti ne. Koldyesikemo kyanmwane kyoat miseak ktela kuala ti senweke, lema mihe kbuanke ne de? ");
INSERT INTO slu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ode musti mo mmyesan a mbyihi mhye o kabei sal ode kabei mlay ode myohut ma mtyoha mlakye. ");
INSERT INTO slu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kolnye irkye it yala ma myanadu o bai maharetake, lemamo malkyaw o ma mika eras ti salke kralake aduk. Kali kolnye lema mala koldyesy, anakyai iry desike tyudu o ti iry matetak tunke ohe oi ne sal o, ode iry matetak tun desike yal o ti suldatare, ma suldat desikre rhait o bai sey metmetke kralake. ");
INSERT INTO slu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Lemade klwosu ti o, ana lema mbwetik toha sey metmetke, kolnye lenla mswelw wasimw utanke ma ktei.” ");
INSERT INTO slu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kyoat desyo irire dum a rahes ti Yesuske ma rbohe, “Iry a Galilea-nare moluk a rkotal healare ma rabar ti Hulasokwe, bonyo gubernur Pilatus tyabahunw a sir.” ");
INSERT INTO slu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lemade Yesuske hyalas iry desikre de byohe, “Ei ne mryekan mo iry Galilea desikre rmaty kali wait lim o sal nekre ribun ma kryesik iry Galilea salik nekre mumu e? ");
INSERT INTO slu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lema koldyesy! Keskyede ei neke kolnye lema mtyunik totamy atyatare, desikemo ei ne mumu ana myaty kola iry desikre. ");
INSERT INTO slu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","De lema mhye ohe toreng maney Siloam desy klyily ti kdyan iry dehean a kresi walw desikre ma rmaty. Kali ei ne mryekan o ktela neke kdi ti kali iry desikre wait lim o sal ribun ma kryesik iry salik mamin ti Yerusalem desy mumu e? ");
INSERT INTO slu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lema koldyesy! Keskyede ei neke kolnye lema mtyunik totamy atyatare, desikemo ana mmyaty kola iry desikre dakun.” ");
INSERT INTO slu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lemade Yesuske tyanuk tun inahliak ne ma byohe, “Irkye it a wasi bo tasy maiskye ma arake ktyuhw ti boke krala desy dakun, ma yal irkye it ma nyoha bo desy. Ode sekwe it bonyo, boke kebu desike mya ma yobak ara desy kisinare, keskye lema itot. ");
INSERT INTO slu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dendye boke kebu desike tyanuk ti iry a manoha bo tasy maisy desy de byohe, ‘Ainke enatelw ma ne de, kmwa ma kobak aw ara ne kisinare keskye lema kutot. Lemamo muly aw ne lakhidik ma mtwan harharkwe ti, kali lema kika kbuan ti kimorif ti lasmyer ne!’ ");
INSERT INTO slu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Keskyede iry desike hyalas ma byohe, ‘Amam lan o, mlwura ma kimin ti ain ne aduk, ana kswaban lasmyerke ma kyaklelela, ode kal lasmyer maiskye ti, ");
INSERT INTO slu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ma tseak o ain mama ne o kisi ta lema, kolnye lema kisi, desikeo andeka tuly ba.’” ");
INSERT INTO slu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti sew a Inamreske it bonyo, Yesuske yajar ti Yahudi-nare wait sey rasambayan tike it a krala. ");
INSERT INTO slu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ti desike dakun o wamfwetke it, neke ngkeskwakwe syukar i ma kluruk i, ma khyury ma itdu nini ainke hean a kresi walw de. ");
INSERT INTO slu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lemade kyoat Yesuske imatakit wamfwet desy bonyo, yabuk a i ma mya ma byu ti i de byohe, “Eno, wasimw a kbaike kitayar de.” ");
INSERT INTO slu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ode Yesuske syaa sima ti wamfwet desy bonyo, wamfwet desy imdiry, ode lyeru Hulasokwe. ");
INSERT INTO slu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Keskyede uskwe khatu sey Yahudi-nare rasambayan ti desike ika keyer, kali Yesuske nyoha iry a klurukare ma eras sir ti sew Inamreske, ode tyanuk ti iry ribun ne ma byohe, “Sekwe nem neke tkarya. Desikemo tal sew denem desy ma tnoha irire wait a kbainare, de kete tnoha irire ti sew Inamreske.” ");
INSERT INTO slu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Keskyede ity Ebutke Yesuske hyalas iry desy ma byohe, “Hei iry a makakmet o, lema mhwe mo ti sew Inamreske dakun o, irire rtunik wait saby o keledai toha wait oare, ma ror sir ti ral wer ti renw. ");
INSERT INTO slu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","De lema mhwe o wamfwet neke Abraham tesnwo natu i, ma ngkeskwaure wait uskwe khatuke yety a i ma ainke hean a kresi walw neke kluruk i e? Lemade kesak a ngkeskwaw desy toha i ti sew Inamreske.” ");
INSERT INTO slu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ode kyoat itanuk koldyesy bonyo, iry a mamnisik i desikre rmay, klala iry salik desikre ramukmuka ramarmara sir mumu ti ktela madelah eras iala mumu desy. ");
INSERT INTO slu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lemade Yesuske tyanuk de byohe, “Ana kal sai ma kuhliak ti kyoat Hulasokwe mya ma hyareta kola Rajake ne de?” ");
INSERT INTO slu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lemade Yesuske ihliak ti Hulasokwe mya ma ihareta kola Rajake ne ti lasyeke khatuke ma byohe, “Irkye it a yal lasyeke ma yabur ti wasi boke, ma ktyuhw kola akwe ode manunare raka nukat ti ksananare.” ");
INSERT INTO slu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ode Yesuske tyanuk huruk ma byohe, “Ana kal sai ma kuhliak huruk ti kyoat Hulasokwe mya ma hyareta kola Rajake ne de?” ");
INSERT INTO slu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dendye Yesuske ihliak ti ragike de byohe, “Sekwe it bonyo, wamfwetke it a yal ragike ma iswail a ktyabal teriguke kminanke kadutke enatelw, ode kbyes ma lan.” ");
INSERT INTO slu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kyoat Yesuske lyakut bai Yerusalem bonyo, lyakut a yoly nusare ode hnuare ma yajar irire. ");
INSERT INTO slu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ode irkye it a tyanuk ti Yesuske ma byohe, “Ebo, mlay bain o ana iry a Hulasokwe iaorif ma ror I o laitke nini nam neke ru ta telw sir bony e?” ");
INSERT INTO slu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Dendye Yesuske hyalas iry mamin desikre ma byohe, “Myalkyaw e ma msyukar holholat butbut des