﻿USE sofia;
DROP TABLE IF EXISTS sofia.slm_vpl;
CREATE TABLE slm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES slm_vpl WRITE;
INSERT INTO slm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iya na itu kapangkatan si Isa Almasi, panubu' si Daud iya panubu' si Ibrahim. ");
INSERT INTO slm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Min si Ibrahim sampay ni si Sultan Daud, iya na itu kapanubuan na: si Ibrahim ian bayi 'mma' si Isahak, bo' si Isahak ian 'mma' si Ya'kub. Si Ya'kub bayi 'mma' si Yuda maka manga danakan na. Iya Yuda bayi 'mma' si Peres maka si Sera, si Tamar bayi ina' sigam. Iya Peres bayi 'mma' si Hesdon, iya Hesdon bayi 'mma' si Aram. Iya Aram bayi 'mma' si Amminadab, iya Amminadab bayi 'mma' si Nasson. Iya Nasson bayi 'mma' si Salmon, iya Salmon bayi 'mma' si Bowas, ina' na bayi si Rahab. Si Bowas bayi 'mma' si Obed, ina' na bayi si Rut. Si Obed bayi 'mma' si Jesse. Iya Jesse bayi 'mma' si Sultan Daud. ");
INSERT INTO slm_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Salaitu panubu' min si Daud sampay ni waktu pamakalloan bangsa Israil pahi' ni lahat Babilon: si Daud ian bayi 'mma' si Sulayman, ina' na bayi handa si Uriya. Si Sulayman bayi 'mma' si Robowam, iya Robowam bayi 'mma' si Abiya, iya Abiya bayi 'mma' si Asa. Iya Asa bayi 'mma' si Josapat, iya Josapat bayi 'mma' si Joram, iya Joram bayi 'mma' si Usiyas. Iya Usiyas bayi 'mma' si Jotam, iya Jotam bayi 'mma' si Ahas, iya Ahas bayi 'mma' si Hijikiya. Iya Hijikiya bayi 'mma' si Manasse, iya Manasse bayi 'mma' si Amon, iya Amon bayi 'mma' si Jusiya. Iya Jusiya bayi 'mma' si Jekoniya maka manga danakan na. ");
INSERT INTO slm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Salaitu isab panubu' min masa pamakalloan bangsa Israil ni lahat Babilon, sampay ni waktu kalahil si Isa: si Jekoniya bayi 'mma' si Salati, iya Salati bayi 'mma' si Sirubbabil. Iya Sirubbabil bayi 'mma' si Abiyud, iya Abiyud bayi 'mma' si Eliyakim, iya Eliyakim bayi 'mma' si Asor. Iya Asor bayi 'mma' si Sadok, iya Sadok bayi 'mma' si Akim, iya Akim bayi 'mma' si Eliyud. Iya Eliyud bayi 'mma' si Eleyasal, iya Eleyasal bayi 'mma' si Mattan, iya Mattan bayi 'mma' si Ya'kub. Iya Ya'kub bayi 'mma' si Yusup iya halla si Mariyam. Si Mariyam bayi ina' si Isa, iya iyōnan si Almasi. ");
INSERT INTO slm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Manjari niya' kapangkatan na sangpu' ka 'mpat min si Ibrahim sampay ni si Sultan Daud. Sangpu' isab ka 'mpat kapangkatan na min si Daud sampay ni waktu bayi pamakalloan manga aa Israil ni Babilon. Sangpu' ka 'mpat isab kapangkatan na minnihi' sampay ni waktu kapag-anak ma si Almasi. ");
INSERT INTO slm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Salaitu iya kalangnganan kapag-anak ma si Isa Almasi. Si Mariyam iya ina' si Isa bayi na makapagtunang asal maka si Yusup, suga' ma 'nsa' le' sigam bayi takawin, tasayu si Mariyam in iya ngiram na min kawasa Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Yusup, iya tunang na hi', aa adil asal. Hangkan na, kitauhan peen uk na in battōng na si Mariyam, baya' iya pabutas ma 'nsa' niya' makatau ma iya, sabab 'nsa' baya' muwanan si Mariyam kaiyaan. ");
INSERT INTO slm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sabu peen si Yusup mikil-mikil pasal itu, niya' paluwas ma diyōm upi ni iya dakayo' malaikat min Tuhan. Uk malaikat, “O Yusup panubu' si Daud, daa kau hawal-hawal magdakayo' maka si Mariyam iyu, sabab min kawasa Nyawa Tuhan iya hangkan niya' bittōngan uk na. ");
INSERT INTO slm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nganak du iya lalla, bo' si Isa iya pangōn nu iya sabab iya iya ngalappasan bangsa na du min karusahan sigam.” ");
INSERT INTO slm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, pitakka pakaradjaan itu kamemon bo' niya' katakkahan ma bayi tasulat ma diyōm kitab, iya bayi pilatun uk Tuhan ni kanabihan. Iya uk na, ");
INSERT INTO slm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Niya' ian budjang ngiram, bo' iya nganak lalla, Si Emmanuil iya pangōn ma iya.” (Iya hati na “Emmanuil” itu, Tuhan pabōtang ma kitabi.) ");
INSERT INTO slm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagbati' si Yusup min upihan na bine' uk na panohoan malaikat, bo' hinda na si Mariyam. ");
INSERT INTO slm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Suga' 'nsa' sigam maghulid sataggōl 'nsa' le' mag-anak si Mariyam. Mag-anak peen anak lalla, iyōnan iya si Isa uk si Yusup. ");
INSERT INTO slm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Isa bayi iyanakan ma kalumaan Betlehem ma lahat Yahudiya, ma masa kapagsultan si Herod. 'Nsa' taggōl, niya' manga aa bayi min sōbangan takka pahi' ni Awrusalam. Manga aa itu asal ngadjian pasal manga bituun. ");
INSERT INTO slm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagtakka sigam ni Awrusalam magtuwi sigam tiyaw. Uk sigam, “Maingga na onde' bahu bayi iyanakan, iya giyanta' magsultan ma bangsa Yahudi? Tanda' kami bituun iya pandōga na paluwas min sōbangan, bo' tiya' kami paitu mudji iya.” ");
INSERT INTO slm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagtake itu uk Sultan Herod, magtuwi landu' sasaw pikilan na. Sampay manga aa kamemon ma diyōm daira ian magkasasawan du isab. ");
INSERT INTO slm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Magpanohoan si Herod subay magtipun manga nakura' kaimaman maka manga guru sara' agama. Uk na ma sigam, “Maingga kono' panganakan Almasi?” ");
INSERT INTO slm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uk manga aa ian, “Ma kalumaan Betlehem, ma lahat Yahudiya, sabab salaitu iya bayi tasulat uk nabi ma diyōm Kitab. Uk na, ");
INSERT INTO slm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Iya kalumaan Betlehem itu, Mehe gaōsan na min kalumaan kasehean, iya bantug ma lahat Yahudiya, Sabab niya' du palahil minnihi' dakayo' aa magnakura', Bo' pignakuraan uk na manga aa ku bangsa Israil!’ ” ");
INSERT INTO slm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Puwas hi' manga lalla min sōbangan hi' bayi siyohoan uk Sultan Herod subay magbissala maka iya ma 'nsa' niya' makatau. Tiyaw sigam uk na bang umay waktu bayi paluwas bituun hi'. Makaba'-ba' peen manga aa ian, ");
INSERT INTO slm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","manjari sigam siyoho' pahi' ni Betlehem. Salaitu iya panohoan Sultan ma sigam, uk na, “Pahi' kaam. Pehahun bi tōōd onde'-onde' ian. Bang iya tapeha bi na, pahatihun bi aku supaya aku me' mudji ni iya.” ");
INSERT INTO slm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ubus peen sigam bissalahan uk sultan, palanjal na sigam tudju ni Betlehem. Ma labayan peen, tanda' uk sigam bituun iya bayi tanda' uk sigam ma lahat sōbangan ian. Pag'nda' sigam, sakali landu' sigam kiyōgan. In bituun ian, hi' parahu min sigam sampay taabut tōngōd pabōtangan onde'. Ian na patōngōd min diyata' na. ");
INSERT INTO slm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jari pasōd sigam ni diyōm luma' ian bo' iyampa tanda' uk sigam onde' maka ina' na si Mariyam. Pasujud sigam mudji ni onde' ian. Piluwas uk sigam iya bayi biyo pangahulmat ni onde'. Niya' bulawan, niya' kamanyan, maka niya' pahamut iyōnan mira. ");
INSERT INTO slm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Puwas hi' biyandaan sigam uk Tuhan ma diyōm upihan sigam, 'nsa' siyoho' pabayik ni si Herod. Manjari mowe' na sigam ni lahat sigam palabay min daddōk saddi. ");
INSERT INTO slm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pagmowe' manga aa hi', niya' malaikat min Tuhan palahil ni si Yusup ma diyōm upihan na. Uk na, “Punduk kau. Bohun onde' maka ina' na iyu bo' kaam lahi ni lahat Misil. Mahi' le' kaam sataggōl kaam 'nsa' pakallo' ku minnihi'. Iyu na si Herod meha onde' iyu piyatay.” ");
INSERT INTO slm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Magtuwi papunduk na si Yusup. Killo' uk na onde' maka ina' na hi' bo' sigam lahi minnihi' tudju ni lahat Misil ma waktu sangōm. ");
INSERT INTO slm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mahi' sigam pabōtang sampay matay na si Herod. Jari niya' du katawwaan ma bayi bissala Tuhan, iya tasulat ma diyōm kitab uk si Nabi Hoseya. Uk na, “Bayi soho' ku anak ku paluwas paitu min lahat Misil.” ");
INSERT INTO slm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pagtau peen itu uk si Herod in iya bayi iyakkalan uk manga aa min sōbangan ian, pasu' tōōd atay na. Magtuwi iya magpanohoan piyatay manga onde'-onde' lalla kamemon ma Betlehem sampay ma kalumaan ma katilibut na, sasuku ngumul duwan tahun sampay pareyo' le' minnihi'. Bista uk si Herod waktu na min bayi pamatau iya uk manga aa min sōbangan pasal waktu bayi kalahil bituun. ");
INSERT INTO slm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Minnihi' niya' katawwaan ma bayi tasulat uk si Nabi Irimiya, iya uk na, ");
INSERT INTO slm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Niya' lingōg take ma lahat Rama, Lingōg aa magkarukkaan maka magtangisan. Si Rakel nangisan manga anak na. 'Nsa' taparōhōng pagtangis na, Sabab hi' piyatay anak na kamemon.” ");
INSERT INTO slm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ubus peen bayi matay si Herod, niya' isab malaikat min Tuhan bayi paluwas ni diyōm upi si Yusup mahi' ni lahat Misil. ");
INSERT INTO slm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Uk malaikat, “Punduk kau. Bohun onde' iyu maka ina' na pabayik ni lahat Israil, sabab hi' na bayi matay iya bayi baya' mapatay onde' iyu.” ");
INSERT INTO slm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sakali papunduk si Yusup. Biyo uk na onde' maka ina' na pabayik ni lahat Israil. ");
INSERT INTO slm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pagtau peen uk si Yusup in si Arkilas iya paganti' min 'mma' na si Herod magsultan ma lahat Yahudiya, tiyāw iya palahat. Siyoho' iya pabayik ma diyōm upihan na, iya hangkan sigam pahi' tudju ni lahat Jalil, ");
INSERT INTO slm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bo' pabōtang sigam ma kalumaan iyōnan Nasaret. Jari niya' du katawwaan ma bayi pigpalatun uk manga kanabihan pasal si Almasi. Uk sigam, “Iyōnan du iya aa Nasaret.” ");
INSERT INTO slm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Manjari ma waktu hi', takka si Yahiya Magpapandi pahi' ni lahat Yahudiya magnasihat, pahi' ni jadjahan lahat iya 'nsa' agōn kalluman ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Uk nasihat na ni manga aa bayi patipun pay'an, “Pataikut kaam min dusa bi sabab sikōt na waktu kapagparinta Tuhan ma kitabi.” ");
INSERT INTO slm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Yahiya itu bayi pigbissala ma awwal le' uk si Isaya. Uk na, “Niya' aa ngalingan ma lahat 'nsa' agōn kalluman ayi-ayi. Salaitu pangalingan na, uk na, ‘Song na takka Panghu'. Lanuin bi daddōk palabayan na. Pabōntōlun bi palangnganan na.’ ” Salaihi' bayi pagbissala uk si Isaya hi'. ");
INSERT INTO slm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Iya pasammek si Yahiya ian bu hayōp unta' bayi tinnun, maka dakayo' sabitan kuwit sapi' pakambot ma hawakan na. Iya kiyakan na manga ampan maka gula' buwani. ");
INSERT INTO slm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sakali pahi' ni si Yahiya manga aa min daira Awrusalam maka aa min kalohahan lahat Yahudiya, maka aa isab min manga kalumaan ma katahaan sapa' Jordan. ");
INSERT INTO slm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Magpasabannal sigam pasal bayi dusa sigam, bo' piyandi sigam uk si Yahiya ma diyōm sapa' Jordan hi'. ");
INSERT INTO slm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Suga' pag'nda' si Yahiya ma baanan aa Parisi maka aa Saddusi pay'an ni iya mikipandi, uk na ni sigam, “Kaam iyu, addat bi sali' sapantun so pangangakkal. Sayi baha' bayi ma'-ma' ma kaam in kaam subay papuwas min mulka' Tuhan iya song patakka? ");
INSERT INTO slm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bang kaam sabannal-bannal pataikut na min dusa bi, hinangun bi hinang hap, palsaksian in addat bi pinda na. ");
INSERT INTO slm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Daa kaam magpikil in kaam 'nsa' miyulkaan ma sawukat kaam panubu' si Ibrahim. Baan ta kaam, minsan min manga batu itu tahinang du panubu' si Ibrahim uk Tuhan! ");
INSERT INTO slm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kaam iyu sali' hantang manga kayu song tibbōng maka kapa, tōbtōb min poon na. Sabab kayu kamemon 'nsa' hap buwa' na tibbōng du, liyarukan ni diyōm api tiyutung. ");
INSERT INTO slm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Maka aku itu,” uk si Yahiya, “bohe' sadja iya pamandi ku ma kaam, tanda' saksi' in kaam pataikut na min dusa bi. Suga' niya' paitu damuwi min aku labi le' kawasa min aku. 'Nsa' aku tiyōp minsan sadja menten tawumpa' na. Saddi bohan pamandi na ma kaam, hati na in iya mahōp Nyawa Sutsi ni diyōm baran bi. Manga aa kasehean isab piyandi uk na maka api. ");
INSERT INTO slm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pikandi du uk na aa hap maka aa laat, sali' sapantun aa nahapan payi. Iya payi na tiyawu' uk na ma diyōm pagtawuan na, bo' hapa na iya tiyutung uk na ma api 'nsa' kapaddahan.” ");
INSERT INTO slm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jari itu, ma waktu hi', takka si Isa bayi min lahat Jalil pay'an ni sapa' Jordan ian, bo' mikipandi ma si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Suga' 'nsa' baya' si Yahiya. Uk na ni si Isa, “Angay kau mikipandi ma aku? Aku itu subay pandi nu!” ");
INSERT INTO slm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Suga' nambung si Isa, uk na, “Hinangun na buttihi', sabab patut du bang be' ta panohoan Tuhan kamemon.” Jari siyulut uk si Yahiya si Isa. ");
INSERT INTO slm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ubus peen si Isa bayi piyandi, pariyata' na iya min diyōm bohe'. Sakali paukab langit, bo' tanda' na Nyawa Tuhan sali' dagbōs assang, pareyo' minnihi' patapu' ma iya. ");
INSERT INTO slm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Niya' isab suwara halling min diyōm sulga'. Uk na hi', “Iya na itu anak ku kalasahan ku, landu' makasulut atay ku.” ");
INSERT INTO slm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manjari si Isa ian biyo uk Nyawa Tuhan ni lahat 'nsa' agōn kalluman ayi-ayi, bo' siyasat iya uk nakura' sayitan may'an, kalu tabo magdusa. ");
INSERT INTO slm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","'Nsa' si Isa bayi makakakan ayi-ayi ma diyōm 'mpatpu' bahangi. Puwas hi' landu' iya giyōtas. ");
INSERT INTO slm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jari pahi' ni iya nakura' sayitan. Uk na, “Bang kau sabannal-bannal Anak Tuhan, sohoun manga batu itu papinda ni tinapay.” ");
INSERT INTO slm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Suga' nambung si Isa, uk na, “Tasulat asal ma diyōm kitab, iya uk na hi', ‘'Nsa' kiyakan baran sadja iya makakaallum ma manusiya', sampay lapal kamemon iya bissala uk Tuhan.’ ” ");
INSERT INTO slm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Puwas hi' biyo si Isa uk nakura' sayitan ni daira Awrusalam, iya iyōnan Daira Mahasutsi, bo' pitōngōd iya ma puntuk langgal mehe mahi'. ");
INSERT INTO slm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Uk sayitan hi', “Bang kau iya bannal Anak Tuhan pakuppa kau minniyu, sabab tasulat asal ma diyōm kitab, iya uk na, ‘Siyoho' uk Tuhan manga malaikat na nganjagahan kau. Tiyayak kau uk sigam bo' 'nsa' makahantak nayi' nu ni batu.’ ” ");
INSERT INTO slm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Halling si Isa, “Bayi na isab tasulat salaitu, ‘Daa sulayin bi kawasa Tuhan iya Panghu' bi.’ ” ");
INSERT INTO slm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Puwas hi' biyo si Isa uk nakura' sayitan ni diyata' bud langkaw tōōd, bo' iyampa pindaan lahat kamemon ma kalohahan dunya, maka kawasa manga aa iya mangantan kalahat-lahatan ian. ");
INSERT INTO slm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Uk nakura' sayitan ni si Isa, “Bang kau pasujud ma aku mudji, pamuwan ku ian kamemon ma kau.” ");
INSERT INTO slm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iya sambung si Isa ni iya, “Pakallo' kau, sayitan! Sabab asal tasulat ma diyōm kitab, uk na, ‘Panghu' bi Tuhan sadja iya subay pudji bi. Tunggal iya paghinangan bi!’ ” ");
INSERT INTO slm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Puwas hi' pakallo' nakura' sayitan min si Isa, bo' niya' manga malaikat paluwas pay'an ni si Isa hi' ngadjalan iya. ");
INSERT INTO slm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Manjari pagtake uk si Isa in si Yahiya Magpapandi bayi na tajil, pahi' iya ni lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","'Nsa' iya bayi pahanti' ma kalumaan Nasaret, suga' palanjal iya pahi' ni daira Kapirnaum, iya ma bihing danaw Jalil, bo' pabōtang iya may'an. Ian asal Kapirnaum ma jadjahan lahat Sibulun maka Naptali. ");
INSERT INTO slm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jari niya' katawwaan ma bayi tasulat uk si Isaya, iya uk na, ");
INSERT INTO slm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lahat Sibulun maka lahat Naptali, Iya ma ōtan sapa' Jordan maka tahik saddōpan, Lahat iyōnan lahat Jalil, lahat kalamuran manga bangsa 'nsa' Yahudi. ");
INSERT INTO slm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","In manga aa na bayi hantang pabōtang ma diyōm kalindōman, makanda' du kasawahan landu' sahaya. Manga aa bayi kalōkōban uk kamatay, Tawwa' du karantaan.” ");
INSERT INTO slm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Puwas minnihi' nagna' si Isa magnasihat lapal na. Uk na, “Tayikutin bi na dusa bi sabab sikōt na waktu kapagparinta Tuhan ma kaam.” ");
INSERT INTO slm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na, sabu si Isa mangngan ma bihing danaw Jalil, niya' tanda' na duwangan magdanakan. Dakayo' ian si Simun, iya iyōnan isab si Petros. Dakayo' ian si Andariyas. Ian sigam ngahug pōkōt ma danaw, sabab magdaraying asal sigam. ");
INSERT INTO slm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jari halling si Isa ni sigam. Uk na, “Paitu kaam me' ma aku. Bayi kaam asal magkallo' daying, suga' panduan ta kaam magkallo' pagkahi bi manusiya' me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Take peen halling si Isa uk duwangan hi', magtuwi sigam bayi ngambanan pōkōt sigam bo' iyampa me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Makalanjal peen si Isa minnihi', niya' isab tanda' na duwangan magdanakan, si Ya'kub maka si Yahiya, anak si Sibidi. Ian sigam ma diyata' bayanan sigam magbe' maka 'mma' sigam magpaayad pōkōt. Linganan uk si Isa duwangan itu, siyoho' me' ma iya. ");
INSERT INTO slm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Magtuwi 'mbanan uk sigam 'mma' sigam maka bayanan hi', bo' iyampa me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, liyatag uk si Isa kalohahan lahat Jalil ian. Mandu' na peen iya ma diyōm kalanggalan. Magnasihat iya lapal hap pasal kapagparinta Tuhan ma manusiya'. Kaulian uk na manga aa saki maka manga aa lamma min ginisan saki sigam. ");
INSERT INTO slm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jari pasaplag kabantugan na ni kalohahan lahat Siriya ian. Hangkan manga aa ian bayi mo sehe' sigam ni si Isa, sayi-sayi tawwa' saki kaginis-ginisan atawa paddi', manga aa siyōd uk sayitan, aa biyaboy-baboy, maka aa matay ugat sigam. Bo' kaulian sigam kamemon uk si Isa. ");
INSERT INTO slm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jari landu' heka manga aa bayi paturul ma iya, aa min lahat Jalil maka aa min Sangpu' Daira ian. Niya' isab manga aa min daira Awrusalam, min kalohahan lahat Yahudiya, sampay min dambiya' sapa' Jordan. ");
INSERT INTO slm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Manjari pag'nda' peen si Isa ma manusiya' katipunan ian, nukad iya ni pigi' bud ningko' may'an. Pay'an ni iya manga mulid na, patipun ma katilibut na, ");
INSERT INTO slm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","bo' nagna' iya mandu' ma sigam. Halling na ma sigam, ");
INSERT INTO slm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mehe du kahapan sasuku katauhan na in kagunahan na tōōd iya tabang min Tuhan. Sabab tantu du niya' palsukuan na ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mehe du kahapan sasuku magkarukkaan pasal kalaatan na, Sabab biyuwanan iya kasannangan uk Tuhan ma atay na. ");
INSERT INTO slm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mehe du kahapan sasuku deyo' pangatayan na Sabab makatayima' du iya bayi panganjanji' Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mehe du kahapan sasuku baya' tōōd pagmaatayan na kaadilan, Sabab diyulan du iya uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mehe du kahapan sasuku maase' ma kasehean na, Sabab kiasean du iya uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mehe du kahapan sasuku pote' atay na tudju ni Tuhan, Sabab makapag'nda' du iya maka Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mehe du isab kahapan sasuku mapagsulut ma manga pagkahi na, Sabab iyōnan du iya anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mehe isab kahapan sasuku liyaat ma sabab iya me' ma kabayaan Tuhan, Sabab niya' palsukuan na ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mehe isab kahapan bi bang kaam ganta' iyudju' maka pidjala', maka bang kaam limut 'nsa' bannal ma sabab kaam me' ma aku. ");
INSERT INTO slm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Subay kaam kiyōgan tōōd bang salaihi', sabab tantu du mehe tungbas bi ma diyōm sulga'. Salaihi' isab bayi pamidjala' ma manga nabi iya bayi ma dunya itu ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Halling le' si Isa, “Kaam bean ku sali' dalil asin para ma manusiya' kamemon. Suga' bang asin itu bayi killoan kaasin na, 'nsa' niya' makapabing asin na. 'Nsa' niya' kagunahan na, timanan sadja ma pag-iddōkan uk aa. ");
INSERT INTO slm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kaam iyu bean ku sali' dalil ilaw iya muwan kasawahan ma manusiya' kamemon. Sali' sapantun kalumaan pabōtang ma diyata' bud, tanda' uk aa kamemon, 'nsa' talimbungan. ");
INSERT INTO slm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Nsa' niya' ngandōkōtan palitaan bo' lōkōban na maka undam, suga' biyōtang du uk na ma diyata' pabōtangan na bo' muwan sawa ma sasuku ma diyōm luma' ian. ");
INSERT INTO slm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Salaihi' du isab ma kaam, subay kaam muwan sawa ma pagkahi bi manusiya'. Hati na subay tanda' kahinangan bi hap uk aa kasehean, bo' sigam tabo nanglitan 'Mma' bi ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Daa kaam magpikil manga aku paitu ngalloan sara' iya bayi pilatun uk si Musa, maka manga pandu' bayi min kanabi-nabihan hi'. In maksud ku paitu mahatihan pasal sara' hi' bang ayi kamaksuran na tōōd. ");
INSERT INTO slm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Baan ta kaam tōōd: sataggōl masi langit maka dunya itu, 'nsa' du niya' kiyulangan min sara' itu minsan laa hal dambatang sulat na maka balis na. Subay sampulna' kamemon bo' iyampa tumanan kamaksuran na. ");
INSERT INTO slm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hangkan sayi-sayi ngalanggal sara' itu minsan laa dakayo' sara' 'nsa' mehe maka piyanduan uk na sehe' na me'-me' ma iya maghinang salaihi', in aa ian deyo' tōōd ma diyōm pagparintahan Tuhan. Bo' sayi-sayi me' ma sara' sampay manduan sehe' na subay me', langkaw du iya ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Suga' baan ta kaam, 'nsa' du kaam makasōd ni diyōm pagparintahan Tuhan bang 'nsa' paliyu kaadilan bi min kaadilan manga Parisi maka manga guru ma sara' agama.” ");
INSERT INTO slm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bayi na take bi bayi panohoan ma manga aa ma masa awwal hi', iya uk na, ‘Wajib kaam daa mapatay pagkahi bi manusiya'. Sayi-sayi mapatay pagkahi na pibōtangan du iya hukuman.’ ");
INSERT INTO slm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Suga' salaitu na pamandu' ku ma kaam sayi-sayi ngandugal ma pagkahi na subay hiyukum. Maka sayi-sayi ngōn ‘dupang’ ma sehe' na subay biyo ni sara' mehe paghukuman na. Sayi-sayi isab mahallingan pagkahi na, uk na, ‘E! Babbal kau! 'Nsa' niya' kapusan nu!’ Piligdu aa ian binsana' ma diyōm api nalka'. ");
INSERT INTO slm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hangkan na, bang kau ganta' ma diyōm langgal song ngungsud ayi-ayi ni Tuhan, bo' taintōm nu in kau bayi makabuwan dusa ni pagkahi nu manusiya', ");
INSERT INTO slm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'mbanin le' pangungsud nu bo' kau pasaut ni pagkahi nu ian ngamu' ampun ni iya dahu bo' iyampa kau pabing nukbalan pangungsud nu ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bang kau tiyuntutan uk aa bo' kau biyo ni sara', bohun iya magsulut ma 'nsa' le' takkahan ni sara'. Sabab bang kau 'nsa' magsulut dahu, takkahan du kau ni huwis, bo' kau siyongan uk huwis ni manga pulis bo' iyampa kau jinil. ");
INSERT INTO slm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jari taggōlan du kau ma diyōm jil hi'. Subay puwasan nu bayi kataksilan nu kamemon bo' iyampa kau makaluwas minnihi'.” ");
INSERT INTO slm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bayi na take bi panohoan itu, iya uk na, ‘Wajib kaam daa magjina.’ ");
INSERT INTO slm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Suga' salaitu na pamandu' ku ma kaam: sayi-sayi nganda' ni danda maka uk na napsuhan iya, in aa ian magjina marimay pikilan na. ");
INSERT INTO slm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hangkan na bang mata nu ni katau ganta' mo kau magdusa, subay larutun. Gam na peen larutin mata nu iyu bo' timanan. Hap le' buta mata nu dambiya', bang peen 'nsa' kau liyarukan katibuukan nu ni diyōm nalka' ma jukup mata nu karuwambiya'. ");
INSERT INTO slm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Damikkiyan na isab bang tangan nu ni katau ganta' mo kau magdusa, hopoin. Hap le' tittōpan dambiya' tangan nu bo' timanan nu. Hap le' pukul dambiya' tangan nu, bang peen 'nsa' kau liyarukan katibuukan nu ni diyōm nalka' ma jukup tangan nu karuwambiya'.” ");
INSERT INTO slm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Niya' isab bayi panohoan sara', iya uk na, ‘sayi-sayi nimanan handa na subay iya muwan pagpasahan na.’ ");
INSERT INTO slm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Suga' salaitu na pamandu' ku ma kaam: sayi-sayi nimanan handa na ma 'nsa' niya' sababan na, ma 'nsa' du iya bayi maglalla, tahinang na iya sali' bayi magjina. Maka bang niya' lalla maghanda ma danda bayi timanan, dusahan isab iya; taitung du isab iya magjina.” ");
INSERT INTO slm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bayi na take bi isab bayi pamandu' ma manga aa ma masa awwal hi', iya uk na, ‘Wajib kaam daa magbaluba min sapa bi. Wajib isab hinangun bi iya bayi najal bi ni Tuhan.’ ");
INSERT INTO slm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Suga' salaitu na pamandu' ku ma kaam: daa na kaam magsapa. Daa sapahun bi sulga' pagsapahan bi sabab paningkoan Tuhan ko' ian. ");
INSERT INTO slm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Daa sapahun bi dunya sabab pabōtangan nayi' na ko'. Sampay daira Awrusalam, daa sapahun bi isab sabab suku' Tuhan, iya Sultan Mahatinggi. ");
INSERT INTO slm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Minsan kok bi, subay 'nsa' sapa bi pagsapahan bi sabab 'nsa' kaam iya bayi mapanjari. Minsan dalamba buun bi 'nsa' kapindahan bi walna' na ni itōm atawa ni pote'. ");
INSERT INTO slm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bang kaam nganjanji' subay kaam halling ‘aho'’ sadja, atawa ‘'nsa'’ sadja. Ayi-ayi pamasugpat bi ma bissala bi saddi minnihi', luwas min sayitan ko' iyu.” ");
INSERT INTO slm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bayi na take bi pamandu' itu, iya uk na, ‘Bang niya' makaat dambiya' mata pagkahi na subay du isab piyulihan pikaat dambiya' mata na. Damikkiyan na bang niya' ngalempongan baggaang pagkahi na subay du isab piyulihan lempongan baggaang na.’ ");
INSERT INTO slm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Suga' iya na itu pamandu' ku ma kaam: daa kaam muli bang niya' ganta' ngahinang laat ma kaam. Bang niya' ganta' aa nampak bayihu' nu dambiya', patampalun isab dambiya' panampakan aa hi'. ");
INSERT INTO slm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bang niya' ganta' nuntutan kau bo' kau miyultahan badju' nu, pamuwanun ma iya sampay juba nu. ");
INSERT INTO slm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bang niya' sundalu Roma ngalōgōs ma kau mo kapanyapan na lawak dabatu na, bohun le' ma iya ni duwa batu. ");
INSERT INTO slm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bang niya' aa ngamu' ayi-ayi ma kau, buwanin. Bang niya' baya' mōs ayi-ayi ma kau subay pibōsan.” ");
INSERT INTO slm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bayi na take bi isab pamandu' dakayo' itu, iya uk na, ‘Kalasahan bi bagay bi, suga' kabansihan bi bang banta bi.’ ");
INSERT INTO slm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Suga' iya na itu pamandu' ku ma kaam: kalasahan bi banta bi. Amu'-amuin bi kahapan min Tuhan sasuku ngahinang laat ma kaam, ");
INSERT INTO slm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bo' supaya kaam ningōd addat Tuhan, iya 'Mma' bi ma diyōm sulga'. Sabab Tuhan iya muwan kasawahan 'llaw ma aa kamemon hap maka laat sali'-sali'. Muwanan isab iya ulan ma manga aa kamemon iya maghinang kabōntōlan sampay isab ma aa maghinang kalaatan. ");
INSERT INTO slm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Daa kaam magpikil bang kaam ngalasa sadja ma asal bagay bi, niya' tahōwat bi tungbas min Tuhan, sabab minsan aa dusahan, iya manga aa ngallo' sukay parinta, ngalasa sigam ma aa ngalasahan sigam. ");
INSERT INTO slm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bang manga kabagayan sadja iya sagina bi pahap, sali' du kaam maka manga aa 'nsa' me' ma panohoan Tuhan sabab iya du sigam nagina ma aa asal kabagayan sigam. ");
INSERT INTO slm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaam iyu subay jukup ma kawul-piil bi tudju ni aa kamemon, sali' du 'Mma' bi ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kamaya'-maya' kaam. Bang niya' hinang bi hap pagtaat ni Tuhan, daa hinangun bi ma mata mayiran bo' supaya tanda' aa kamemon. Sabab bang hinang bi ian supaya kaam tanda' uk aa, 'nsa' du niya' tungbas bi min Tuhan, iya 'Mma' bi ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hangkan na, bang niya' pamuwan bi ma aa kulang-kabus, daa pagbantugun bi. “Hati na, daa singōrin bi manga aa maglaku-laku in sigam hap, iya narakka ma panganda' manga aa kamemon ma diyōm langgal sampay ma paglabayan. Baya' tōōd siyanglitan uk manga aa mahadjana'. Baan ta kaam tōōd, bang sigam kasanglitan uk manusiya', iya na hi' tungbas sigam. 'Nsa' niya' saddi. ");
INSERT INTO slm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Suga' kaam iyu, bang niya' tabang bi ni aa miskin, subay 'nsa' niya' makatauhan iya, minsan bagay bi na. ");
INSERT INTO slm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Subay ma kalimbungan tōōd. Jari bang salaihi', tiyungbasan du kaam uk 'Mma' bi Tuhan, iya makanda' ma ayi-ayi hinang bi minsan ma kalimbungan.” ");
INSERT INTO slm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bang kaam nambahayang, daa singōrin bi manga aa maglaku-laku in addat sigam hap. Sabab kiyōgan sigam nangge nambahayang ma diyōm langgal atawa ma paglabayan aa bo' supaya tanda' uk mahadjana' kamemon. Baan ta kaam tōōd, bang sigam kasanglitan uk aa, iya na hi' panungbas sigam. 'Nsa' niya' tungbas saddi tatayima' sigam. ");
INSERT INTO slm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Suga' kaam iyu, bang kaam nambahayang, pasōd kaam ni diyōm bilik bi. Tambōlun bi lawang bo' iyampa kaam nambahayang ni 'Mma' bi Tuhan, iya 'nsa' tanda'. Bo' 'Mma' bi itu, iya makanda' ma ayi-ayi hinang bi minsan ma diyōm kalimbungan, iya du nungbas ma kaam. ");
INSERT INTO slm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bang kaam nambahayang, daa paggunahun bi kabtangan heka iya 'nsa' niya' pus na, sali' panambahayang manga aa iya 'nsa' magtaat ma Tuhan tabi. Sabab biya' uk sigam in panambahayang sigam kine du uk Tuhan ma sawukat landu' taha'. ");
INSERT INTO slm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Daa singōrin bi sigam, sabab kitauhan asal uk 'Mma' bi Tuhan bang ayi kasusahan bi minsan 'nsa' le' kaam ngamu' tabang ma iya. ");
INSERT INTO slm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jari itu, bang kaam nambahayang subay salaitu iya kalangnganan na: ‘O 'Mma' kami Tuhan ma sulga', bang peen pig-addatan ōn nu sutsi uk aa kamemon, ");
INSERT INTO slm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bang peen 'nsa' taggōl bo' kau magparinta ma manusiya' kamemon ma dunya itu, Bang peen du bine' kabayaan nu ma dunya itu sali' iya asal bine' maiyu ma sulga'. ");
INSERT INTO slm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Buwanan nu kami balanja' ma 'llaw itu. ");
INSERT INTO slm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ampunun manga dusa kami, sali' kapangampun kami ma sayi-sayi makabuwanan kami dusa. ");
INSERT INTO slm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Daa kami sulayan nu biyo ni diyōm sasat, suga' papuwasun kami min nakura' sayitan, iya makalaat.’ Salaihi' subay panambahayang bi. ");
INSERT INTO slm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bang kaam ngampun manga aa makabuwan dusa ni kaam, iya du kaam iyampun uk 'Mma' bi ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Iya hati na, bang 'nsa' ampun bi aa bayi makabuwan dusa ni kaam, iya du kaam 'nsa' iyampun uk 'Mma' bi Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bang kaam magpuwasa daa subay palupahun bi pamayihuan bi, sali' aa maglaku-laku ian in sigam hap. 'Nsa' sigam ngintul di sigam, pangilahan aa kasehean in sigam magpuwasa du. Baan ta kaam tōōd, bang sigam kasanglitan uk manusiya', iya na hi' panungbas sigam. 'Nsa' niya' saddi. ");
INSERT INTO slm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Suga' kaam iyu, bang kaam magpuwasa, kuwaupin bi bayihu' bi maka sudlayun bi buun bi, ");
INSERT INTO slm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bo' 'nsa' katauhan uk aa kasehean in kaam puwasa atawa 'nsa'. Iya sadja makatau iya 'Mma' bi Tuhan, iya 'nsa' tanda' asal uk manusiya'. Bo' 'Mma' bi iyu, iya makanda' ma ayi-ayi hinang bi sampay ma diyōm kalimbungan, nungbas du ma kaam.” ");
INSERT INTO slm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Daa kaam magtipun alta' ma itu ma dunya, sabab magkaat sadja, pigkeket uk bobok, kasehean giyaha', kasehean isab liyangpasan. ");
INSERT INTO slm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Suga' maghinang kaam hap bo' niya' karaya bi tiyawuan kaam ma diyōm sulga', sabab karaya mahi' 'nsa' takeket uk bobok, 'nsa' magkagaha', maka 'nsa' talangpasan. ");
INSERT INTO slm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sabab na maingga-maingga panawuan bi alta' bi, mahi' iya pataptapan pangatayan bi.” ");
INSERT INTO slm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata ta itu sali' dalil palitaan muwan sawa ma diyōm ginhawa ta. Bang sawa mata ta, hati na, bang kita me' tōōd ma kabayaan Tuhan, iya pigbahasa sali' sawa lullun diyōm ginhawa ta. ");
INSERT INTO slm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Suga' bang mata ta 'nsa' hap, hati na, bang laat hinang ta, iya pigbahasa sali' ngalindōm diyōm ginhawa ta itu. Bang uk ta niya' ma kita kasawahan, bo' 'nsa', na mehe kalindōman ta.” ");
INSERT INTO slm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bang aa ganta' banyaga', 'nsa' niya' makapagbanyaga' ma duwa nakura'. Sabab bang duwa nakura' ma dakayo' aa, tantu kibansihan uk na nakura' na dakayo' maka kilasahan uk na dakayo'. Lut iya ma dakayo' bo' tiyayikutan uk na dakayo'. Hati na, 'nsa' kaam manjari maghinang ma Tuhan bang sin iya pamehe bi ma atay bi. ");
INSERT INTO slm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hangkan na kaam soho' ku daa kaam magsusa pasal kalluman bi, bang ayi kiyakan bi maka bang ayi inum bi. Daa kaam magsusa isab pasal ginhawa baran bi bang ayi panammek bi. Sabab kallum ta itu labi halga' na min kapamangan ta. Iya du baran ta, labi halga' na min panammek ta. ");
INSERT INTO slm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","'Ndaun bi manga manuk-manuk mariyata' paleng. 'Nsa' magtanōm, 'nsa' mag-ani. 'Nsa' isab nawu' kiyakan. Suga' biyalanjaan du sigam uk 'Mma' bi ma diyōm sulga'. Bo' kaam iyu, halga' le' tōōd min kamanuk-manukan hi'. ");
INSERT INTO slm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hangkan isab daa kaam magkasusahan sabab kasusahan bi iyu 'nsa' makapataha' umul bi. ");
INSERT INTO slm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Angay isab kaam magkasusahan ma pasal panammek bi? 'Ndaun bi manga sumping ma diyōm kaparangan bang salaingga katomo' na. 'Nsa' magsangsa' maghinang, 'nsa' maghinang kakana'. ");
INSERT INTO slm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Suga' baan ta kaam, minsan si Sultan Sulayman maka kaalti na ma masa awwal hi', 'nsa' du makaatu lingkat pakayan na ma dakayo' sumping itu. ");
INSERT INTO slm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bang Tuhan iya magpasammek ma sumping kasōmpōtan itu, iya tatasan na dangallaw du bo' pagsawung lanōs sampay tiyutung, tantu Tuhan masammekan kaam. Kulang du le' pangandōl bi ma iya! ");
INSERT INTO slm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Hangkan na kaam subay 'nsa' magmasusa. Daa kaam mag-upama: ayi pagkakan ta, ayi pag-inum ta, ayi baha' pasammek ta? ");
INSERT INTO slm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Manga aa 'nsa' tau magtaat ma Tuhan, iya na hi' kisusahan na peen uk sigam. Lipara kaam iyu, kitauhan uk 'Mma' bi ma diyōm sulga' in ian kagunahan bi asal. ");
INSERT INTO slm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Suga' dahu-dahu kannalun bi pagparinta Tuhan maka kannalun bi kabōntōlan atay iya kabayaan na. Manjari piniyaan du kaam ayi-ayi kulang-kabus bi. ");
INSERT INTO slm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hangkan kaam subay 'nsa' magkasusahan pasal sawung, sabab saddi kasusahan na. Sarang na pagsusahan bi ma 'llaw itu sadja.” ");
INSERT INTO slm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Daa sawayun bi pagkahi bi bo' kaam 'nsa' siyaway uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sabab bang kaam ganta' mabōtang hukuman ma sehe' bi, iya du isab kaam pibōtangan hukuman uk Tuhan, pipagtōngōd du maka bayi pangahukum bi sehe' bi hi'. Ayi-ayi panappōng bi ma sehe' bi, iya du isab panappōng Tuhan ma kaam. ");
INSERT INTO slm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kaam magsaway sehe' bi iyu, angay tanda' bi bukbuk kayu kalimpōnan ma diyōm mata sehe' bi, bo' 'nsa' tananam bi batang kayu ma diyōm mata bi? ");
INSERT INTO slm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mamarahi pahap kaam iyu! Uk bi, ‘Bagay kalloan ta bukbuk min mata nu iyu.’ Bo' peen niya' batang kayu ma diyōm mata bi! ");
INSERT INTO slm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaam iyu maglaku-laku in kaam iyu 'nsa' taga sā'! Kalloin bi le' dahu iya ma kaam iyu supaya sawa panganda' bi, bo' iyampa kaam ngalloan bukbuk min mata sehe' bi. ");
INSERT INTO slm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Daa kaam muwan ayi-ayi sutsi ma manga aa laat, iya sali' sapantun ero'. Kalu pabing tudju ni kaam, ngeket. Lapal bi halgaan, iya pigbahasa mussa' bi. Daa larukin bi ni manga koret. Kalu pig'ddōkan uk sigam sali' 'nsa' niya' halga' na.” ");
INSERT INTO slm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ngamu'-ngamu' kaam, bo' kaam biyuwanan. Meha kaam, bo' kaam makatawwa'. Mikiukab kaam, bo' kaam iyukaban. ");
INSERT INTO slm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sabab sayi-sayi ngamu' kabuwanan du. Sayi-sayi meha makatawwa' du. Sayi-sayi isab mikiukab iyukaban du. ");
INSERT INTO slm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kaam iyu taga anak, bila kaam iyamuan tinapay uk anak bi, buwanan bi baha' batu? ");
INSERT INTO slm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atawa bang ngamu' daying, buwanan bi baha' so? ");
INSERT INTO slm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kaam dusahan iyu, bang kaam tau du muwanan anak bi ayi-ayi makahap, luba'-luba' na na 'Mma' bi ma diyōm sulga' tau du muwanan ayi-ayi makahap ni sasuku ngamu' ni iya. ");
INSERT INTO slm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Manjari ayi-ayi hap kabayaan bi subay hinang uk manusiya' ni kaam, iya du hinangun bi ni sigam. Iya na hi' hati na, iya sara' bayi tasulat uk si Musa maka bayi pamandu' uk manga kanabi-nabihan.” ");
INSERT INTO slm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pasōd kaam min lawang kiput, sabab iya daddōk tudju ni nalka' loha pasōran na maka luhay lingngan. Heka isab manusiya' me' min daddōk ian. ");
INSERT INTO slm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Suga' iya pasōran tudju ni sulga' kiput du maka hunit lingngan. Kulang isab aa makatawwa' may'an.” ");
INSERT INTO slm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kamaya'-maya' kaam bo' kaam 'nsa' kaakkalan uk manga aa magbawu'-bawu' in sigam nabi. Bang 'nda' ta dagbōs sigam hap du sigam, sali' sapantun bili-bili 'nsa' makamula. Suga' ma diyōm atay sigam sali' sigam ero' tawun, makapakaat sadja. ");
INSERT INTO slm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Takila bi du sigam min kahinangan sigam, sali' kayu takila min buwa' na. 'Nsa' kita ngallo' buwa' anggul min kayu puhung, atawa buwa' igira min kayu itingan. ");
INSERT INTO slm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bang kayu hap, hap isab buwa' na. Suga' bang kayu 'nsa' hap, 'nsa' du isab hap buwa' na. ");
INSERT INTO slm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bang kayu hap 'nsa' makabuwan buwa' laat. Damikkiyan na bang kayu laat suring na, 'nsa' makabuwan buwa' hap. ");
INSERT INTO slm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bang niya' kayu 'nsa' hap pagbuwa' na, tibbōngan bo' timanan ni diyōm api. ");
INSERT INTO slm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hangkan uk ku ma kaam, takila bi du manga nabi iya 'nsa' bannal sabab min kahinangan sigam du.” ");
INSERT INTO slm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“'Nsa' aa kamemon iya nabbut aku ‘Panghu'’ iya makasōd ni diyōm pagparintahan Tuhan. Suga' iya du pisōd in aa me' ma kabayaan 'Mma' ku ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bang taabut na 'llaw pangahukum ma manusiya', heka du aa ian missala ni aku. Salaitu iya uk sigam: ‘O Panghu', bayi kami matanyag lapal min Tuhan ma kawasa ōn nu. Bayi piluwas uk kami manga sayitan min diyōm baran aa, maka heka isab manga hinang makainu-inu bayi tahinang kami, min kawasa ōn nu isab.’ ");
INSERT INTO slm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sakali sambungan ku du sigam. Uk ku, ‘'Nsa' kaam takila ku. Pakallo' kaam min aku, kaam kamemon maghihinang kalaatan iyu.’ ” ");
INSERT INTO slm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na, sasuku aa pake ma pandu' ku itu sampay me', iya sali' sapantun aa hap akkal na, iya bayi ngahinang luma' na ma kabatuhan. ");
INSERT INTO slm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Manjari niya' ulan landōs maka dunuk, maka baliyu kōsōg makatawwa' ma luma' ian. Suga' 'nsa' habba sabab bayi na hinang ma kabatuhan. ");
INSERT INTO slm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Sasuku isab pake ma pandu' ku bo' 'nsa' me', sali' iya aa kulang akkal na, iya bayi ngahinang luma' na ma kalabbohan. ");
INSERT INTO slm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sakali niya' ulan landōs patumbuk, maka dunuk, maka badju kōsōg tawwa' ma luma' ian. Magtuwi habba, lubu tōōd.” ");
INSERT INTO slm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ubus peen uk si Isa missala, kiyainu-inuhan pandu' na uk baanan aa bayi makake ian. ");
INSERT INTO slm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iya hangkan salaihi' sabab magbidda' tōōd pandu' si Isa maka pandu' manga guru sigam. Si Isa iya taga kawasa asal bang mandu'. ");
INSERT INTO slm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Palud peen si Isa min bud ian, heka tōōd aa bayi paturul ni iya. ");
INSERT INTO slm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Manjari niya' aa ipul pay'an ni si Isa bo' iyampa pasujud min dahuhan na. Uk na, “Tuwan, bang kau baya', pakoweun aku.” ");
INSERT INTO slm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Magtuwi piabut uk si Isa tangan na ni lalla hi'. Uk si Isa, “Asal aku baya'. Kaulian na kau!” Saruun-duun du kaulian ipul aa ian. ");
INSERT INTO slm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sakali itu uk si Isa ni iya, “Pake kau. Daa kau ma'-ma' ni sayi-sayi iya bayi tahinang ku ma kau. Suga' pahi' kau magtuwi ni imam bo' palilingun ni iya baran nu. Puwas na hi' ungsurin pagkulban ni Tuhan sali' bayi pamandu' uk si Musa, iya na tanda' saksi' ni kahekahan aa in kau kaulian na min ipul nu.” ");
INSERT INTO slm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Manjari itu, pasōd peen si Isa ni diyōm daira Kapirnaum, niya' dakayo' kapitan bangsa Roma bayi pasampang ni iya ngamu' tabang. ");
INSERT INTO slm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Uk na ni si Isa, “Tuwan, niya' sosohoan ku ma luma'. Ian iya pabahak, 'nsa' makahibal di na maka landu' paddi' baran na.” ");
INSERT INTO slm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Uk si Isa, “Pahi' du aku makowe' iya.” ");
INSERT INTO slm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Daa kau pahi', Tuwan,” uk kapitan. “'Nsa' aku tiyōp bang kau pahi' ni luma' ku. Suga' bang kau ma' minniyu, kaulian du sosohoan ku ian. ");
INSERT INTO slm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Minsan aku, biyaksa du pagbayaan uk aa min diyataan ku, maka niya' isab sundalu pagbayaan ku. Bang soho' ku dakayo' pahi', pahi' du iya. Bang soho' ku dakayo' paitu, paitu du iya ni aku. Damikkiyan na bang niya' pahinang ku ma sosohoan ku, magtuwi hinang uk na.” ");
INSERT INTO slm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagtake peen halling nakura' sundalu itu uk si Isa, inu-inu iya. Uk na ni manga aa paturul ma iya ian, “Baan ta kaam tōōd. Minsan ma diyōm bangsa tabi Israil 'nsa' aku bayi makalanggal ma aa sali' nakura' itu, kōsōg tōōd pangandōl na. ");
INSERT INTO slm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pake kaam. Ma waktu ma sosongun heka aa min bangsa kaginisan, aa bayi min sōbangan maka min saddōpan, magtingkoan du magsawu mangan maka di si Ibrahim, si Isahak maka si Ya'kub. ");
INSERT INTO slm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Suga' manga aa bangsa Israil itu, iya arapun pisōd ni diyōm pagparintahan Tuhan, liyarukan du paluwas tudju ni kalindōman, bo' may'an sigam magtallik maka magtagiōt baggaang sigam sabab min kapagsusun sigam.” ");
INSERT INTO slm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sakali missala si Isa ni nakura' sundalu ian, uk na, “Mowe' na kau. Tahinang ma kau sali' bayi pangandōlan nu.” Manjari saruun-duun du kaulian sosohoan na ian ma waktu hi'. ");
INSERT INTO slm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sakali palanjal si Isa pahi' ni luma' si Simun. Pagsōd na ni diyōm luma' ian, tanda' na matoa si Simun danda pabahak may'an, hinglaw. ");
INSERT INTO slm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Piabut uk si Isa tangan na ni tangan danda itu, bo' kaulian magtuwi bayi hinglaw na hi'. Puwas ihi' punduk iya ngalabōt ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Taabut peen pasaddōp 'llaw, heka manga aa bayi biyo pay'an ni si Isa, aa bayi siyōd uk sayitan. Piluwas uk na manga sayitan, min kabtangan na sadja. Maka aa taga saki ian kamemon bayi kaulian uk na. ");
INSERT INTO slm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pagka hinang na salaihi' magtawwa' na ma maka iya bayi tasulat uk si Nabi Isaya ma diyōm kitab, iya uk na, “Baran na iya bayi makakallo' saki tabi; bayi iya nanggung kalammahan tabi.” ");
INSERT INTO slm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tanda' peen uk si Isa heka aa ma katilibut na, uk na ni manga mulid na, “Sung kitabi pauntas ni dambiya' danaw.” ");
INSERT INTO slm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Nsa' peen sigam pauntas, niya' dakayo' guru ma sara' agama bayi pay'an ni si Isa. Uk na, “Tuwan Guru, me' aku ma kau paingga-paingga papahian nu.” ");
INSERT INTO slm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Uk sambung si Isa, “Gam hayōp tawun niya' pabōtangan na, maka manga kamanuk-manukan niya' pugaran na. Suga' aku, Anak Manusiya' itu, 'nsa' niya' tōōd luma' patōtōgan ku atawa pagtuwihan ku.” ");
INSERT INTO slm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Niya' isab dakayo' mulid ian halling ni si Isa, uk na, “Tuwan, pabairun le' aku pabing ni luma'. Subay puwas pangubul ku ma 'mma' ku dahu bo' iyampa aku me' ma kau.” ");
INSERT INTO slm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Suga' uk si Isa, “Me' na kau ma aku. Patut du bang aa matay pikubul ma manga aa kasehean iya 'nsa' kaniyaan kallum taptap.” ");
INSERT INTO slm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Puwas hi' pariyata' si Isa ni bayanan, maka me' isab manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pauntas peen sigam, sakali parugpak hunus ni danaw ian. Agōn-agōn sigam buhaw sabab bayanan hi' liyasayan uk goyak. Suga' si Isa, tuwi na peen may'an. ");
INSERT INTO slm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sakali pay'an ni iya manga mulid na mati' iya. “O Tuwan,” uk sigam. “Nabang kau! Lembo na kitabi!” ");
INSERT INTO slm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Uk si Isa ma sigam, “Angay kaam tiyāw? Kulang pahap pangandōl bi!” Manjari nangge si Isa bo' iyampa soho' na baliyu maka goyak ian parōhōng. Saruun-duun du pataddo' lahat ian magtuwi. ");
INSERT INTO slm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inu-inu manga mulid na. “Sayi baha' aa itu?” uk sigam. “Minsan baliyu maka goyak kapag-agihan du uk na.” ");
INSERT INTO slm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Puwas ian makarunggu' sigam pahi' ni dambiya' danaw, ni lahat manga aa Gadara. Manjari niya' pahi' ni iya duwangan aa bayi paluwas min diyōm kakubulan, aa siyōd uk manga sayitan. Landu' bingis manga aa itu hangkan 'nsa' niya' makatawakkal palabay min ian. ");
INSERT INTO slm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pag'nda' sigam si Isa, magtuwi sigam nuwalak, uk na, “O Anak Tuhan! Ayi lamud nu ma kami? Paitu kau baha' minsana' kami ma 'nsa' le' taabut waktu gantaan na?” ");
INSERT INTO slm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, lawak-lawak le' minnihi' niya' baanan koret magkakan. ");
INSERT INTO slm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sakali ngamu'-ngamu' manga sayitan hi' ma si Isa. Uk sigam, “Bang kami subay piluwas uk nu, papahiun kami pisōd ni diyōm baran manga koret hi'.” ");
INSERT INTO slm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Na, pahi' na kaam,” uk si Isa. Sakali pakallo' manga sayitan min baran aa bo' pinda pahi' ni diyōm baran baanan koret. Magtuwi baanan koret hi' bayi lahi min luran hi' sampay hug paligid ni diyōm danaw, bo' iyampa lembo kamemon. ");
INSERT INTO slm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jari manga aa bayi mangipat koret ian lahi pahi' ni kalumaan ma'-ma' ma manga aa may'an pasal bayi hinang uk si Isa ma manga aa bayi siyōd uk sayitan hi'. ");
INSERT INTO slm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hangkan paluwas manga aa min kalumaan ian pahi' ni si Isa. Magkalanggal peen sigam, magtuwi sigam ngamu' junjung ni iya, bang peen iya pakallo' min lahat sigam. ");
INSERT INTO slm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pariyata' na si Isa ni bayanan bayi pamean na bo' iyampa pabing ni dambiya' danaw, tudju ni lahat iya asal pabōtangan na. ");
INSERT INTO slm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Manjari may'an peen, niya' biyo ni iya aa matay baran na. Pabahak sadja ma pabahakan na. Makatau peen si Isa in aa mo ian mangandōl du ma iya, uk na ni aa matay baran na, “Oto', daa kau susa. Iyampun na dusa nu.” ");
INSERT INTO slm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niya' bayi may'an manga guru sara' agama maghōna'-hōna' kasehean. Uk sigam, “Oy! Aa itu halling pangkal tudju ni Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Suga' asal katauhan si Isa bang ayi pikilan uk sigam, bo' halling na ni sigam. Uk na, “Angay kaam mamikil laat salaiyu? ");
INSERT INTO slm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kumpasun bi bang ingga luhay: bang bissala ku ma aa ian, ‘iyampun na dusa nu’, atawa bang uk ku, ‘Papunduk kau bo' kau mangngan na’? ");
INSERT INTO slm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, buwanan ta kaam tanda' palsaksian bo' katauhan bi in aku, Anak Manusiya', taga kapatut ngampun dusa ma diyōm dunya itu.” Jari missala si Isa ni aa matay baran na hi'. “Papunduk na kau,” uk na. “Bohun pabahakan nu iyu bo' kau mowe'.” ");
INSERT INTO slm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sakali nangge aa ian bo' iya mowe'. ");
INSERT INTO slm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pag'nda' manga aa ian ma hinang si Isa, tiyāw sigam tōōd. Siyanglitan Tuhan uk sigam ma sabab kawasa bayi pamuwan na ma manusiya' makahinang salaihi'. ");
INSERT INTO slm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Makalangngan peen si Isa, niya' tanda' na dakayo' aa iyōnan si Matiyu ningko' ma diyōm upis, iya pagbayaran sukay parinta. Uk si Isa ma iya, “Paitu na kau me' ma aku.” Nangge magtuwi si Matiyu bo' me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Manjari mangan si Isa ma luma' si Matiyu. Heka isab manga aa magkallo' sukay parinta maka manga aa baldusa kasehean, ian magsawu ni si Isa maka manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Salta' peen sigam magsawu, niya' manga Parisi bayi nganda' ni sigam. Uk manga Parisi itu ni mulid si Isa, “Angay guru bi iyu palamud magsawu-sawu mangan maka manga aa magkakallo' sukay parinta maka manga aa dusahan kasehean?” ");
INSERT INTO slm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Take uk si Isa iya halling sigam bo' uk na, “Bang aa kowe' 'nsa' na magdoktor. Iya magdoktor bang aa taga saki. ");
INSERT INTO slm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pehahun bi pahi' bang ayi hati na bayi tasulat ma diyōm kitab, iya uk na, ‘'Nsa' halgaan ma aku kulbanan hayōp iya ungsuran bi, suga' iya kabayaan ku tōōd subay kaam maase' ma pagkahi bi.’ ” Uk si Isa le', “'Nsa' pasal aa adil iya maksud ku paitu ni dunya, suga' in maksud ku paitu pasal aa taga dusa bo' supaya sigam me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Manjari pahi' manga mulid si Yahiya Magpapandi ni si Isa tiyaw ma iya. Uk sigam, “Tuwan, kami maka manga aa Parisi magpuwasa na peen, suga' mulid nu iyu 'nsa' tōōd magpuwasa. Angay baha'?” ");
INSERT INTO slm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nambung si Isa magparalilan. In mulid na sali' piralil ni aa maglurukan ma pagkawinan. Uk na, “Susa baha' manga aa luruk ma samantala' may'an le' pangantin lalla ma tōngōd sigam? Tantu 'nsa'. Suga' ma 'llaw siyong, bang taabut waktu kapamakalloan pangantin lalla min sigam, minnihi' sigam nagna' magpuwasa.” ");
INSERT INTO slm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Puwas hi' magparalilan si Isa pasal pamandu' tagna' maka pamandu' na, uk na, “'Nsa' niya' aa matupak pispis kakana' bahu, kakana' 'nsa' bayi diyakdakan, ni badju' asal daan. Sabab bang salaihi' pakinkin du tupak bahu, bo' gese' du min kakana' asal. Jari pamehe na peen gese' na.” ");
INSERT INTO slm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Piralil isab pamandu' na ni inuman bahu bayi hinang, uk na, “'Nsa' niya' ngalōōn inuman bahu ni diyōm pangalōōnan kuwit hayōp bang daan na. Bang ganta' salaihi' tantu bustak. Tumpahan du inuman, bo' magkaat bayi pangalōōnan na hi'. Suga' in inuman bahu subay liyōōnan ni pangalōōnan bahu. Jari natas inuman na maka pangalōōnan na sali'-sali'.” ");
INSERT INTO slm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sabu peen si Isa masi mandu' ma sigam, niya' pay'an ni iya dakayo' nakura' ma langgal ian. Pasujud iya ma dahuhan si Isa. Uk na, “Tuwan, iyamboho' matay anak ku danda. Suga' bang kau me' ma aku maabut tangan nu ma iya, 'llum du iya.” ");
INSERT INTO slm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sakali nangge na si Isa paturul ma nakura' ian. Magbe' isab maka iya manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, niya' may'an dakayo' danda sakihan. Sangpu' ka duwa tahun 'nsa' bayi parōhōng laha' na. Pasikōt iya ni si Isa min bukutan na, bo' iyampa piabut uk na tangan na ni bihing juba si Isa. ");
INSERT INTO slm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Uk na ma diyōm pikilan na, “Bang peen ta'ntan ku minsan laa tong sammek na, kaulian du saki ku.” ");
INSERT INTO slm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jari palingi' si Isa bo' tanda' na danda itu. Uk na, “Inda', daa na kau susa. Kaulian du saki nu ma sabab pangandōl nu.” Magtuwi danda itu kaulian saruun-duun du. ");
INSERT INTO slm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pagtakka si Isa ni luma' nakura' ian, tanda' na may'an manga aa magsuling maka baanan aa maghiluhala'. ");
INSERT INTO slm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Uk si Isa ma sigam, “Paluwas kaam kamemon. 'Nsa' du matay onde' iyu. Tuwi iya sadja.” Sakali pigtattohan si Isa uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ubus manga aa ian peen bayi piluwas, pasōd na si Isa ni diyōm bilik onde' danda ian bo' iyampa intanan na tangan na. Magtuwi papunduk iya. ");
INSERT INTO slm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jari habal pasal bayi hinang si Isa ian pasaplag ni kalohahan lahat ian hi'. ");
INSERT INTO slm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Palanjal peen si Isa minnihi', niya' duwa aa buta bayi paturul ma iya. Ngalingan sigam pakōsōg, uk sigam, “Oy! Tubu' sultan Daud! Maase' na kau ma kami!” ");
INSERT INTO slm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jari pagsōd peen si Isa ni diyōm luma', pasikōt na ni iya duwangan buta ian. Uk si Isa ma sigam, “Magkahagad kaam in aku makapakowe' du?” “Aho', Tuwan,” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jari piabut uk si Isa tangan na ni mata sigam maka halling uk na, “Tahinang ma kaam sali' bayi pangandōl bi.” ");
INSERT INTO slm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Magtuwi du sigam kanda' pabayik, bo' siyoho' sigam uk si Isa, uk na, “Daa kaam ma'-ma' ni sayi-sayi pasal itu bayi tahinang ma kaam.” ");
INSERT INTO slm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Suga' pakallo' peen duwangan itu minnihi', matanyag sigam pasal si Isa ma katilibut lahat ian. ");
INSERT INTO slm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma sabu peen isab paluwas duwangan ian, niya' na manga aa pay'an ni si Isa mo dakayo' aa 'nsa' makabissala ma sabab siyōd uk sayitan. ");
INSERT INTO slm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ubus peen uk si Isa bayi makallo' sayitan min baran aa itu, magtuwi iya makabissala. Inu-inu manga aa may'an kamemon. Uk sigam, “'Nsa' niya' bayi tanda' tabi salaitu ma kalohahan lahat Israil itu.” ");
INSERT INTO slm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Suga' halling manga aa Parisi, “In aa itu bayi kabuwanan barakat uk nakura' sayitan, iya hangkan tapaluwas na manga sayitan.” ");
INSERT INTO slm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Manjari talatag uk si Isa kamemon daira maka kalumaan ma jadjahan hi'. Bayi iya mandu' ma diyōm manga langgal, bayi iya nganasihat lapal hap pasal pagparinta Tuhan. Bayi kaulian na isab manga aa iya saki sigam maka kalammahan sigam kaginis-ginisan. ");
INSERT INTO slm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pag'nda' na ma baanan aa ian, landu' iya maase' ma sigam, sabab ian sigam ma diyōm kasusahan maka 'nsa' niya' nabang ma sigam. Sali' sigam sapantun bili-bili 'nsa' niya' mag-ipat ma sigam. ");
INSERT INTO slm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sakali uk si Isa ni manga mulid na, “Manga aa itu sali' dalil huma heka buwa' na. Loha tana' na, suga' kulang aa mag-ani. ");
INSERT INTO slm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hangkan kaam subay ngamu'-ngamu' ni Tuhan, iya dapu huma, bo' supaya iya noho' manga aa mag-ani paitu.” ");
INSERT INTO slm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Manjari linganan uk si Isa mulid na sangpu' ka duwa pahi' ni iya bo' iyampa sigam biyuwanan kawasa maluwas sayitan min diyōm baran aa sampay makauli' saki maka lamma kaginis-ginisan. ");
INSERT INTO slm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iya na itu ōn sangpu' ka duwa bayi kawakilan uk si Isa: kaisa, si Simun iya iyōnan isab si Petros, maka danakan na si Andariyas, bo' si Ya'kub maka danakan na si Yahiya, manga anak si Sibidi. ");
INSERT INTO slm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pasunu' si Pilip maka si Bartolome maka si Tomas, bo' si Matiyu iya bayi magkallo' sukay ma parinta, bo' si Ya'kub iya anak si Alpa. Pasunu' isab si Taddiyu, ");
INSERT INTO slm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bo' si Simun aa pangangatu. Katapusan si Judas Iskariyut, iya nongan si Isa ni manga banta na ma waktu labay minnihi'. ");
INSERT INTO slm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","In sangpu' ka duwa aa itu bayi piyanduan uk si Isa bo' iyampa siyoho' mangngan. Salaitu panohoan na, “Daa kaam pahi' ni lahat manga aa 'nsa' bangsa Israil, atawa ni kalumaan aa Samariya. ");
INSERT INTO slm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Suga' pahi' kaam ni manga aa bangsa Israil sadja. Sali' sigam hantang bili-bili lungay min paglabayan. ");
INSERT INTO slm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pahi' kaam magnasihat pasal pagparinta Tuhan song na takka. ");
INSERT INTO slm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakoweun bi sasuku saki. Pakallumun bi manga aa bayi matay, pakoweun bi sasuku saki ipul, maka paluwasun bi manga sayitan min diyōm baran aa. Bayi kaam biyuwanan kapatut min aku ma 'nsa' niya' bayad na, hangkan kaam subay nabang ma 'nsa' niya' bayad na. ");
INSERT INTO slm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Daa kaam mo bulawan atawa pilak minsan manga pisita ma diyōm bulsa bi. ");
INSERT INTO slm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Daa kaam mo pangalōōnan kapanyapan atawa badju' pagsayinan bi, atawa tawumpa' atawa tungkud. Sabab bang aa maghinang, wajib iya biyuwanan balanja'. ");
INSERT INTO slm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bang kaam takka ni dakayo' daira atawa ni kalumaan, pehahun bi aa may'an hap kasuddahan na, bo' pabōtang kaam ma iya sataggōl 'nsa' le' kaam pakallo' min lahat ian hi'. ");
INSERT INTO slm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bang kaam pasōd ni dimay luma' aa, uk bi, ‘Bang peen kaam biyuwanan kasannangan!’ ");
INSERT INTO slm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jari bang hap kasuddahan sigam ma luma' ian, katakkahan du sigam kasannangan bayi pangamu' bi hi'. Suga' bang 'nsa' hap kasuddahan sigam, pabingun bi ni kaam kasannangan hi'. ");
INSERT INTO slm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bang ganta' niya' manga aa 'nsa' nagina kaam, atawa 'nsa' baya' pake ma kaam, pakallo' kaam min luma' atawa min kalumaan ian. Paspasin bi dahu higbun na min nayi' bi, tanda' saksi' in kaam puwas min sigam. ");
INSERT INTO slm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Baan ta kaam, bang taabut 'llaw pangahukum Tuhan ma manusiya', kalandu' le' bohat hukuman Tuhan ma manga aa ma lahat ian min bayi hukuman ni manga aa ma daira Sodom maka daira Gomora, iya lahat bantug ma sabab dusa aa na ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pake kaam,” uk si Isa. “Iyu kaam song papahi' ku ni diyōman manga aa laat. Sali' kaam sapantun bili-bili pipahi' ni diyōman baanan ero' tawun, iya bingis tōōd. Hangkan subay kaam taga akkal, maka addat bi subay hatul. ");
INSERT INTO slm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pahalli' kaam, sabab niya' ko' ian manga aa laat naggaw kaam, bo' kaam biyo ni paghukuman. Piglapdōsan du kaam uk sigam ma diyōm langgal sigam. ");
INSERT INTO slm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Biyo du kaam ni alōpan manga gubnul maka manga sultan bo' kaam hiyukum ma sabab aku iya pamean bi. Iya hangkan kaam pitampal ni sigam, bo' supaya kaam makaba' lapal hap ni sigam, sampay ni manga bangsa saddi min Yahudi. ");
INSERT INTO slm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jari bang kaam tasaggaw biyo ni sara' daa kaam magsusa bang ayi pamissala bi atawa bang salaingga uk bi halling. Biyuwanan du kaam lapal pamissala bi bang taabut waktu na. ");
INSERT INTO slm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sabab 'nsa' baran bi iya halling ma waktu hi', suga' Nyawa 'Mma' bi Tuhan iya nabangan kaam missala. ");
INSERT INTO slm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma waktu sosongun ian niya' du manga aa nukbalan danakan sigam ni sayi-sayi bo' piyatay. Niya' du isab manga 'mma' nukbalan anak sigam bo' piyatay. Manga anak isab manta du ma 'nggo'-mma' sigam, noho' isab subay piyatay. ");
INSERT INTO slm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Maka kaam manga mulid ku,” uk si Isa, “kibansihan du kaam uk aa kamemon ma sabab aku iya pamean bi. Suga' sayi-sayi hōgōt iman na sampay ni katapusan, makasampay ni kasalamatan ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bang kaam ganta' binsana' ma lahat dakayo', lahi kaam ni lahat dakayo'. Baan ta na kaam, ma 'nsa' le' bayi talatag bi kalahatan Israil kamemon magnasihat, in aku Anak Manusiya' pabayik du ni kaam. ");
INSERT INTO slm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“'Nsa' niya' mulid palangkaw min guru na. 'Nsa' niya' ata palangkaw min nakura' na. ");
INSERT INTO slm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hangkan na in mulid subay magsukul bang makasali' ni guru na, maka in sosohoan subay magsukul bang makasali' isab ni nakura' na. Na, pagka aku nakura' bi iyōnan uk sigam si Belsebul, hati na nakura' sayitan, mangkin na in kaam sosohoan ku iyōnan laat du uk sigam.” ");
INSERT INTO slm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Daa kaam tiyāw ma manga manusiya'. Kamemon bayi limbungan tantu du piluwas. Kamemon bayi tiyawu' ma diyōm atay tantu pitau du. ");
INSERT INTO slm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ayi-ayi pama' ku kaam ma diyōm kalindōman, bain bi ma kasawahan. Maka ayi-ayi bayi take bi ma 'nsa' niya' saddi makake iya, patanyagun bi ni manga aa kamemon iya 'nsa' bayi makake. ");
INSERT INTO slm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Daa kaam tiyāw ma aa iya makapatay baran bi, sabab 'nsa' taabut nyawa bi. Hap le' bang Tuhan iya katāwan bi, sabab in iya taga kawasa makatiksa' baran bi sampay nyawa bi ma diyōm nalka'. ");
INSERT INTO slm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pikilun bi manuk-manuk diki' iyu, taballi ta duwa maka pisita, suga' minsan deyo' halga' na 'nsa' niya' minsan dakayo' manuk-manuk diki' hug ni tana' bang 'nsa' min kabayaan 'Mma' bi Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iya lagi' kaam. Minsan buun bi iyu, taitung du uk Tuhan bang pila lamba heka na. ");
INSERT INTO slm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hangkan daa na kaam tiyāw, sabab halgaan le' kaam min baanan manga manuk-manuk iyu.” ");
INSERT INTO slm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sayi-sayi magsabannal ma alōpan kahekahan aa in aku pamean na, ma' du aku ma alōpan 'Mma' ku ma diyōm sulga', in aa ian palsukuan ku du. ");
INSERT INTO slm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Suga' sayi-sayi mayilu ma alōpan kahekahan in aku 'nsa' pamean na, payiluhan ku du isab aa ian ma alōpan 'Mma' ku ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Daa kaam magpikil in maksud ku paitu ni dunya supaya aku mo kasannangan sabab aku makalingōg ma manusiya'. In maksud ku paitu bo' aku tahinang pagsaggaan manga manusiya'. ");
INSERT INTO slm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bayi aku paitu mapagsagga' manusiya' dakayo' pa dakayo'. Anak lalla magsagga' maka 'mma' na, anak danda maka ina' na, ayuhan danda maka matoa na danda. ");
INSERT INTO slm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iya tahinang banta aa tōōd, iya na manga sehe' na magdaluma'. ");
INSERT INTO slm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bang aa lasahan 'mma' na maka ina' na labi min aku, 'nsa' iya wajib mulid ku. Damikkiyan na isab bang aa lasahan anak na lalla-danda labi min aku, 'nsa' iya manjari mulid ku. ");
INSERT INTO slm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sayi-sayi baya' mean aku subay iya makatanggung hag na pamapatayan iya, hati na subay piglilla' uk na kabinsanaan na sampay ni kamatay na. Bang hati 'nsa', 'nsa' iya manjari mulid ku. ");
INSERT INTO slm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sayi-sayi 'llōgan ginhawa baran na, 'nsa' du niya' kallum na taptap. Suga' sayi-sayi 'nsa' 'llōgan ginhawa baran na, bo' lilla' isab matay ma sabab ku, makatawwa' du iya kallum kakkal.” ");
INSERT INTO slm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sayi-sayi nayima' kaam, aku du iya tiyayima' uk sigam, sampay Tuhan iya bayi mapaitu aku ni dunya. ");
INSERT INTO slm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sasuku nayima' sosohoan Tuhan ma sabab lapal Tuhan iya pamissala na, niya' du palsukuan na ma ayi-ayi iya panungbas uk Tuhan ma aa magpalatun lapal na hi'. Damikkiyan na, sasuku nayima' aa adil ma sabab kaadil na, niya' du palsukuan na ma ayi-ayi panungbas uk Tuhan ma aa adil hi'. ");
INSERT INTO slm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baan ta kaam tōōd, sayi-sayi muwan minsan laa dakayo' sawan bohe' haggut ma dakayo' bean ku deyo' tōōd, ma sabab aku iya pamean na, tantu aa ian tiyungbasan kahapan.” ");
INSERT INTO slm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ubus peen uk si Isa bayi noho' ma mulid na sangpu' ka duwa ian, pakallo' iya minnihi'. Pahi' iya ni manga kalumaan sikōt may'an, magpandu' maka magnasihat mahi'. ");
INSERT INTO slm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, si Yahiya Magpapandi bayi tajil asal. Pagtake si Yahiya pasal kahinangan si Almasi, siyoho' uk na manga mulid na kasehean pahi' ni si Isa niyaw. ");
INSERT INTO slm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pagmay'an peen, uk sigam ni si Isa, “Bain kono' kami. Kau baha' iya pigbissala uk si Yahiya subay paitu ni dunya? Atawa niya' le' saddi iyagaran?” ");
INSERT INTO slm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nambung si Isa, uk na, “Pabing kaam pahi'. Bain bi si Yahiya pasal ayi-ayi take bi maka ayi-ayi tanda' bi itu. ");
INSERT INTO slm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Manga aa bayi buta makanda' na, aa bayi pengka' makalangngan na tōōd, aa bayi ipul tapalanu' kuwit na, aa bayi bisu makake na, maka aa bayi matay tapakallum na pabing. Sampay manga aa miskin pignasihatan na lapal hap. ");
INSERT INTO slm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mehe du kahapan sasuku 'nsa' magduwa-duwa pikilan na ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sasang peen manga mulid si Yahiya ian pakallo' minnihi', missala si Isa ni pagtipunan aa ian pasal si Yahiya. Uk na, “Ayi baha' bayi peha bi, bayi waktu kaam pahi' ni si Yahiya ma lahat 'nsa' agōn kalluman ayi-ayi ian? Kabayaan bi baha' nganda' dakayo' aa magpinda-pinda pikilan na sali' sapantun dawun parang, tabo magladdoy-laddoy uk baliyu? ");
INSERT INTO slm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bang 'nsa' ihi', ayi baha' bayi pig'nda' uk bi pahi'? Aa magsammek badju' halgaan? Marayi' 'nsa', sabab bang aa magsammek salaihi', ian du pabōtangan na ma diyōm luma' sultan. ");
INSERT INTO slm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bain aku tōōd bang ayi bayi pig'nda' uk bi pahi'? Dakayo' nabi baha'? Aho', nabi du, suga' iya bayi tanda' bi ian langkaw le' min manga nabi kamemon. ");
INSERT INTO slm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sabab pasal si Yahiya itu in bayi bissala Tuhan bayi tasulat ma diyōm kitab, iya uk na, ‘Tiya' sosohoan ku. Papahi' ku iya parahu min kau bo' supaya iya magpaayad palabayan nu.’ ");
INSERT INTO slm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Baan ta kaam tōōd,” uk si Isa, “pasal si Yahiya Magpapandi itu: 'nsa' du niya' bangsa paliyu le' min iya basta ma diyōm bangsa manusiya'. Suga' sayi-sayi tabe' ma diyōman pagparintahan Tuhan, minsan salaingga kareyo' kapag-aa na, langkaw le' iya min si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Min waktu nagna' si Yahiya magnasihat sampay ni buttihi', niya' manga aa nagga' ma lapal pasal pagparinta Tuhan maka liyāng uk sigam manga aa baya' me' ma pandu' hi'. ");
INSERT INTO slm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","In pagparintahan Tuhan itu bayi pilatun uk si Musa ma diyōm sara' na, maka bayi pigpalatun na peen uk manga kanabi-nabihan kamemon sampay taabut waktu kalahil si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bayi na pima' ian in si Nabi Eliyas subay du paitu ni dunya itu pabayik. Na, bang kaam baya' magkahagad ma bayi pagpalatun manga nabi hi', si Eliyas itu iya na ko' si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sasuku kaam makake, asipun bi tōōd. ");
INSERT INTO slm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Manjari,” uk si Isa, “ayi pamaralilan ku manga aa ma waktu itu? Sali' sigam hantang onde'-onde' magtingkoan ma halaman tabu'. Ngalingan manga onde' min dambiya' ni kasehean sigam. ");
INSERT INTO slm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Uk na hi', ‘Oy! Kaam iyu! Bayi kami ngalisagan kaam suga' 'nsa' du kaam ngiluk. Bayi kami ngaluguan kaam suga' kaam iyu 'nsa' me'-me' magtangis.’ ");
INSERT INTO slm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Manga aa ma waktu itu hi',” uk si Isa, “sali' sapantun onde' hi', 'nsa' tasulut. Bayi paitu si Yahiya, aa magpupuwasa. 'Nsa' nginum ayi-ayi inuman makalango. Jari pihallingan iya uk aa kamemon in iya kono' siyōd uk sayitan! ");
INSERT INTO slm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Puwas hi' in aku, Anak Manusiya', bayi paitu magkakan maka mag-inum. Magtuwi aku pihallingan uk aa kamemon. Uk sigam, ‘He! 'Ndaun bi aa itu, lagak na! Iya du aa panginginum! Magbagay iya maka aa magkallo' sukay parinta, sampay aa baldusa kasehean!’ Suga',” uk si Isa, “tanda' tabi ma sasuku me' ma Tuhan in pangatau na asal tawwa'.” ");
INSERT INTO slm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Puwas na hi' nagna' si Isa magbandaan manga aa ma diyōm manga lahat bayi pangahinangan na kahekahan hinang na kainu-inuhan aa. Iya hangkan biyandaan uk na manga aa hi' sabab 'nsa' bayi pataikut min karusahan sigam. ");
INSERT INTO slm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Uk si Isa, “Allā, kaam manga aa Korasin maka aa Betsaida, makaase'-ase' tōōd iya pamakadal ma kaam! Heka hinang makainu-inu bayi pindaan ni kaam suga' 'nsa' bayi asip bi. Daira Tira maka daira Sidun, bang bayi pindaan manga hinang ku makainu-inu hi', tantu manga aa may'an bayi pataikut min dusa sigam. Tantu sigam bayi magsammek karut, manga magbusugan di sigam abu, tanda' pagsusun sigam. ");
INSERT INTO slm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Baan ta na kaam, bang taabut 'llaw pangahukum Tuhan, bohat le' hukuman iya pitakka ni kaam min bayi hukuman ma manga aa daira Tira maka daira Sidun ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaam isab aa Kapirnaum,” uk si Isa, “iyu kaam magbantug-bantug di bi in kaam pilangkaw sampay ni sulga'! Suga' duwal nalka' iya pasampayan bi! In manga hinang makainu-inu bayi pindaan ni kaam, bang bayi pindaan ni manga aa Sodom, tantu bayi masi daira sigam ian sampay ni kabuttihian. ");
INSERT INTO slm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Baan ta kaam, bang taabut 'llaw pangahukum, bohat le' hukuman iya pitakka ni kaam min hukuman bayi pitakka ni manga aa Sodom ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Manjari itu, ma waktu ian, missala si Isa ni Tuhan. Uk na, “O 'Mma', kau iya makapagbaya' ma ayi-ayi ma langit maka ma dunya. Mehe pagsukulan ku ni kau sabab in bayi limbungan nu min aa taga pangadji' sampay min aa lōm tau na, pihati uk nu ni aa kulang tau na. ");
INSERT INTO slm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aho', 'Mma', min kōg nu maka baya' nu hangkan salaihi'.” ");
INSERT INTO slm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Manjari halling si Isa ni manga aa ian, “Bayi na pingandōl ayi-ayi kamemon ma aku uk 'Mma' ku. 'Nsa' niya' makatauhan aku, duwal 'Mma' ku hi'. Damikkiyan na, 'nsa' niya' makatauhan iya, duwal aku anak na, sampay isab sasuku tapene' ku subay pahati ku. ");
INSERT INTO slm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Me' kaam kono' ma aku, sasuku kaam miyale' maka kabohatan, bo' kaam buwanan ku pahalihan. ");
INSERT INTO slm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tayimaun bi pandu' iya pamatanggung ku ma kaam, bo' nganad kaam min aku sabab hantap asal aku, maka deyo' pangatayan ku. Minnitu kaam makatawwa' kahayangan ma nyawa bi. ");
INSERT INTO slm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sabab luhay iya pamahinang ku kaam, maka pandu' iya pamatanggung ku kaam lampung du.” ");
INSERT INTO slm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Nsa' taggōl minnihi' hi' si Isa maka manga mulid na mangngan palabay min tangnga' huma bayi tiyanōman tirigu pasalta' ma 'llaw Sabtu', iya 'llaw paghali ni Tuhan bang ma agama Yahudi. Jari itu, pagka giyōtas manga mulid na ian, bayi sigam musu' buwa' tirigu bo' iyampa kiyakan isi na. ");
INSERT INTO slm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pag'nda' manga Parisi ma bayi tahinang uk manga mulid itu, halling sigam ni si Isa, “'Ndaun ba manga mulid nu iyu. Ngalanggal sara' ma agama tabi hinang sigam salaihi' sabu ma 'llaw paghali ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nambung si Isa, uk na, “Angay, 'nsa' tabassa bi bang ayi bayi tahinang uk si Daud ma masa awwal hi', waktu bayi kagōtas sigam maka manga aa na? ");
INSERT INTO slm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bayi pasōd si Daud ni diyōm langgal pangaharapan Tuhan bo' iyampa killo' uk na manga tinapay iya pangungsud ni Tuhan hi'. Pigkakan uk sigam tinapay ian minsan sigam ngalanggal sara', sabab manga kaimaman sadja patut mangan tinapay bayi iyungsuran ian. ");
INSERT INTO slm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Nsa' isab bayi tabassa bi baha' ma diyōm kitab Tawrat pasal manga imam iya maghinang ma diyōm langgal pagkulbanan sampay ma 'llaw paghali ni Tuhan? Minsan sigam makalanggal sara' agama 'nsa' du sigam bayi magdusa. ");
INSERT INTO slm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Baan ta kaam, niya' maitu taga kapatut mehe min langgal pagkulbanan ian. ");
INSERT INTO slm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Niya' bayi tasulat ma diyōm kitab, iya uk na, ‘'Nsa' halgaan ma aku iya pangungsud bi ma aku pagkulban. Suga' iya kabayaan ku tōōd subay kaam maase' ma pagkahi bi.’ Bang bayi tahati bi pandu' itu tōōd, 'nsa' du kaam bayi mabōtang hukuman ni manga aa iya 'nsa' bayi magdusa. ");
INSERT INTO slm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sabab aku, Anak Manusiya', taga kapatut magbaya' bang ayi manjari hinang ma 'llaw paghali ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Manjari pakallo' si Isa minnihi' ni lahat dakayo', bo' iya pasōd ni diyōm langgal sigam. ");
INSERT INTO slm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Niya' ma diyōm langgal ian aa komay dambiya' tangan na, maka niya' isab manga aa baya' meha dusa ma si Isa supaya iya tatuntutan. Tiyaw iya uk sigam. Uk sigam, “Ngalanggal sara' agama tabi baha' bang kita makowe' aa saki ma 'llaw paghali ni Tuhan?” ");
INSERT INTO slm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambung si Isa, uk na, “Ayi hinang bi bang niya' sawupama dakayo' bili-bili bi hug ni diyōm lowang ma waktu 'llaw paghali? 'Nsa' kallo' bi baha' hayōp ian, piluwas min diyōm lowang? ");
INSERT INTO slm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Suga' in kita bangsa manusiya' labi halga' le' min bili-bili. Hangkan patut du bang kita maghinang kahapan ma 'llaw paghali ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sakali halling si Isa ni aa komay tangan na ian, uk na, “Pahannatun tangan nu iyu.” Na, pihannat uk na. Magtuwi kaulian tangan na sali' na ni dambiya' na. ");
INSERT INTO slm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Suga' paluwas manga Parisi min diyōm langgal ian bo' iyampa sigam mag-isun bang salaingga uk sigam mapatay ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pagkasayu si Isa ihi' pag-isunan manga Parisi hi' mantahan iya, pakallo' iya min lahat ian hi'. Heka aa bayi paturul ma iya. Sasuku aa magsakihan bayi kaulian uk na kamemon. ");
INSERT INTO slm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bayi sigam biyandaan uk na 'nsa' siyoho' ma'-ma' ni pagkahi sigam pasal iya. ");
INSERT INTO slm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","In hinang na ian magtawwa' ma palman bayi pigpalatun uk Tuhan, iya tasulat uk si Nabi Isaya. ");
INSERT INTO slm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Uk na, “Tiya' sosohoan ku bayi pene' ku, Kalasahan ku iya, landu' aku kasulutan ma iya. Pahōp ku ni iya Nyawa ku. Bo' iya iya magmahalayak ni sabarang bangsa pasal hukuman ku bōntōl. ");
INSERT INTO slm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'Nsa' du iya nganjawab, 'nsa' isab nuwalak. 'Nsa' iya matanōg suwara na ma paglabayan aa. ");
INSERT INTO slm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Maase' du iya ma sasuku lamma pangandōl na. Tiyabang uk na du sasuku 'nsa' niya' hōwat-hōwat na. Magpatanyag iya sampay tapatangge na kabōntōlan hukuman Tuhan, ");
INSERT INTO slm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bo' iya iya pangahōwatan bangsa manusiya' kamemon.” ");
INSERT INTO slm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sakali niya' bayi biyo ni si Isa dakayo' aa buta maka umaw isab, sabab bayi siyōd uk sayitan. Kaulian aa itu uk si Isa, jari makabissala maka makanda' na iya. ");
INSERT INTO slm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Inu-inu tōōd manga aa bayi may'an. Uk sigam, “Iya itu baha' tubu' si Sultan Daud dakayo'-kayo'?” ");
INSERT INTO slm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagtake halling ian uk manga Parisi, uk sigam, “Iya hangkan aa itu makapaluwas sayitan min diyōm baran aa sabab niya' kawasa bayi pamuwan ni iya uk si Belsebul, iya pagnakuraan manga sayitan.” ");
INSERT INTO slm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Suga' katauhan asal uk si Isa bang ayi pikilan uk sigam, hangkan uk na ma sigam, “Bang sawupama niya' aa ma diyōm pagsultanan magkuntara maka kasehean na bo' magbono' sali'-sali', 'nsa' taggōl magkaat pagsultanan hi'. Damikkiyan na bang niya' aa magdalahat atawa magdaluma', bo' pabutas kasehean magsagga' ma kasehean sigam, 'nsa' taggōl bo' sigam magkawukanat. ");
INSERT INTO slm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hangkan ko', bang nakura' sayitan iya maluwas manga pagkahi na sayitan min diyōm baran aa, hati na, 'nsa' taggōl magsagga' sigam bo' magkaat kōsōg kawasa na. ");
INSERT INTO slm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Uk bi in aku itu makapaluwas sayitan ma sabab niya' kawasa bayi pamuwan ma aku uk si Belsebul, nakura' sayitan. Bang ihi' bannal, minningga baha' pangalloan mulid bi kawasa, iya hangkan sigam isab makapaluwas sayitan? In mulid bi iya magpanda' kasaan pamikil bi. ");
INSERT INTO slm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Suga' iya bannal na, iya hangkan aku makapaluwas sayitan sabab kawasa ku deyo' bayi min Nyawa Tuhan. Iya na ko' iyu paltandaan in Tuhan tiya' na magparinta ma kaam. ");
INSERT INTO slm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nakura' sayitan ian sali' dalil aa gaōs. Luma' na 'nsa' du tasōd, pangalta' na 'nsa' kalangpasan. Duwal bang aa gaōsan ian ingkōtan dahu bo' iyampa kalangpasan diyōm luma' na. ");
INSERT INTO slm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sayi-sayi 'nsa' mōgbōgan aku,” uk si Isa, “iya du nagga' ma aku du. Maka sayi-sayi 'nsa' nabangan aku magtipun manga suku' ku, makawukanat du iya. ");
INSERT INTO slm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hangkan kaam baan ku, sayi-sayi kaam ngandusa maka ngahalling pangkal tudju ni Tuhan, taampun du kaam. Suga' sayi-sayi ngahalling pangkal ni Nyawa Sutsi, 'nsa' niya' kaampunan na. ");
INSERT INTO slm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sayi-sayi ngahalling laat ma aku, Anak Manusiya', makajari iya iyampunan dusa na. Suga' sayi-sayi ngahallingan pangkal ma Nyawa Sutsi, 'nsa' tōōd iyampun dusa na hi', minsan ma waktu itu, minsan ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Bang sawupama kayu hap,” uk si Isa, “hap du buwa' na. Damikkiyan na isab bang kayu laat, buwa' na 'nsa' hap. Sabab kitauhan asal kayu min buwa' na. ");
INSERT INTO slm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kaam pangangakkal! 'Nsa' kaam makabissala hap sabab laat diyōm atay bi. Ayi-ayi bayi ma diyōm atay manusiya', gana-gana paluwas min bo' na. ");
INSERT INTO slm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bang aa hap, hap du isab kawul-piil na sabab luwas du min kahapan na iya bayi tiyawu' na ma diyōm atay na. Suga' bang aa laat, laat du isab kawul-piil na sabab luwas du min kalaatan bayi tiyawu' na ma diyōm atay na. ");
INSERT INTO slm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Baan ta kaam, bang taabut 'llaw pangahukum Tuhan ma manusiya', in aa kamemon subay ma'-ma' pasal bissala kamemon bayi tapahalling na, iya 'nsa' niya' kapusan na. ");
INSERT INTO slm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sabab min pamissala na iya sababan na hangkan aa hiyukum, bang iyampun atawa binsana'.” ");
INSERT INTO slm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Manjari niya' manga guru ma sara' agama maka manga Parisi bayi may'an. Uk sigam ni si Isa, “Tuwan Guru, baya' kami nganda' dakayo' paltandaan min barakat nu.” ");
INSERT INTO slm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Suga' nambung si Isa, uk na, “In manga aa ma waktu itu, dusahan tōōd, 'nsa' tōōd baya' magtaat ni Tuhan. Kaam iyu mikipanda' paltandaan pangilahan kawasa ku. Suga' 'nsa' niya' paltandaan pandaan ku ni kaam, duwal iya paltandaan bayi min si Nabi Yunus ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sabab si Yunus hi' bayi tallu 'llaw tallu bahangi ma diyōm tungul sattuwa deyawut. Damikkiyan na aku, Anak Manusiya', tallu 'llaw tallu bahangi du aku ma diyōm liyang ma sosongun. ");
INSERT INTO slm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bang taabut na 'llaw pangahukum Tuhan ma manusiya', magtanggehan du manga aa bayi ma daira Niniba ma masa awwal hi', bo' sigam du naksian kaam in kaam taga dusa. Sabab bayi kine uk sigam nasihat si Yunus, magtuwi pinda min dusa sigam. Baan ta kaam, tiya' na dakayo' aa labi le' langkaw min si Yunus hi', suga' 'nsa' iya asip bi. ");
INSERT INTO slm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bang taabut isab 'llaw pangahukum Tuhan ma manusiya' niya' du nangge ma hi' dakayo' pangian bayi min lahat Seba ma masa awwal hi'. Naksi' du iya in kaam bayi magdusa. Iya hangkan danda ian taga kapatut naksi', sabab bayi iya paitu min lahat na ni katahan supaya iya kake ma bissala si Sultan Sulayman iya bayi lōm tōōd pangatau na hi'. Baan ta kaam, ma buttihi' niya' maitu ma kaam pasong le' pangatau na min bayi tau si Sultan Sulayman, suga' 'nsa' du iya asip bi.” ");
INSERT INTO slm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na, bang takdil ni sayitan,” uk si Isa, “bang niya' sayitan paluwas min baran aa, liyunsul uk na lahat 'nsa' bayi kaulanan meha pahalihan na. Jari bang 'nsa' niya' tapeha na, ");
INSERT INTO slm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","halling uk sayitan ian ni baran na, uk na, ‘Gam na aku pabing ni diyōm baran aa bayi pabōtangan ku tagna' hi'.’ Pagbing peen, tanda' na 'nsa' le' niya' pabōtang may'an, maka hi' bayi siyapuhan maka mimmōs. ");
INSERT INTO slm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Puwas na hi' pahi' iya ngallo' pitu' sayitan saddi, labi le' laat sigam min iya, bo' pasōd sigam kamemon ni diyōm baran aa, pabōtang may'an. Jari in aa ian kalandu' tōōd laat kahalan na damuwi min bayi dahu. Salaihi' isab ma manga aa baldusa iya 'llum ma waktu itu.” ");
INSERT INTO slm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na, ma sabu si Isa masi mandu' ni manga aa ian, bayi takka pay'an ina' na maka manga danakan na lalla. May'an sigam ngagad ma luwasan, bo' baya' magbissala maka iya. ");
INSERT INTO slm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jari niya' dakayo' aa ma'-ma' ma si Isa. Uk na, “'Ndaun Tuwan, ian na ina' nu maka manga danakan nu ngagad ma luwasan. Baya' magbissala maka kau.” ");
INSERT INTO slm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nambung si Isa, uk na, “Sayi baha' kainaan ku maka manga danakan ku?” ");
INSERT INTO slm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jari tiyo' uk si Isa tudju ni manga mulid na. Uk na, “Iya na ko' itu kainaan ku maka dawuranakan ku. ");
INSERT INTO slm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sabab sayi-sayi ngahinang kabayaan 'Mma' ku ma sulga', iya na ko' ian manga danakan ku lalla-danda, maka kainaan ku.” ");
INSERT INTO slm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma 'llaw hi' paluwas si Isa min luma' bo' iya pahi' ni bihing danaw ningko' ma hi' magpandu'. ");
INSERT INTO slm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Heka aa bayi patipun ni iya, heka kalandu'. Hangkan iya pariyata' ningko' ma bayanan bayi parunggu' ma hi'. Bo' baanan aa ian magtanggehan ma bihing parian hi'. ");
INSERT INTO slm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Heka pamandu' si Isa ma manga aa ian, pandu' pamaralilan. Uk na, “Niya' ian dakayo' aa pahi' ni huma na nabōran bigi. ");
INSERT INTO slm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pagsabōd na itu, niya' bigi kasehean pakpak ni bihing daddōk. Sakali pay'an manga manuk-manuk nōtōk bigi ian. ");
INSERT INTO slm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Niya' isab bigi kasehean pakpak ni kabatuhan, datti' tana' na. Bigi ian lakkas patomo' sabab 'nsa' lōm tana' na. ");
INSERT INTO slm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Suga' paluwas peen 'llaw, magtuwi lus ugbus na ian sampay lanōs, sabab 'nsa' lōm gamut na. ");
INSERT INTO slm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Niya' du isab bigi pakpak ni tangnga' sōmpōt itingan. Pagpasuwig tiyanōm ian, makasubud peen sōmpōt ian, magtuwi kasimbōlan tiyanōm ian. ");
INSERT INTO slm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na, iya bigi kasehean pakpak ni tana' hap, pasong-song magbuwa' hap. Niya' poon kasehean muwan buwa' landu' tōōd heka na, niya' kasehean muwan buwa' heka, maka niya' isab kasehean sarang-sarang heka na. ");
INSERT INTO slm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Na,” uk si Isa, “sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Manjari pahi' ni si Isa manga mulid na. Tiyaw iya, uk sigam, “Angay kau magparalilan bang kau manduan manga aa itu?” ");
INSERT INTO slm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sambung si Isa, “Kaam iyu kabuwanan pangatauhan bo' supaya tahati bi pasal kapagparinta Tuhan ma manga aa na, iya 'nsa' bayi patau na ni manusiya' kasehean. Suga' manga aa kasehean 'nsa' kabuwanan pangatau pasal ian hi'. ");
INSERT INTO slm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sabab sayi-sayi niya' tau na, kinnōpan le' panghati na sampay maglabi-labi. Suga' sayi-sayi 'nsa' niya' panghati na bo' peen pangannal na niya' tau na datti', killoan du ihi' min iya. ");
INSERT INTO slm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iya na itu poon sabab na hangkan aku magparalilan ma manga aa itu: sabab nganda' du sigam suga' 'nsa' tanda' uk sigam. Pake isab sigam suga' 'nsa' take tōōd uk sigam maka 'nsa' tahati. ");
INSERT INTO slm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pagsalaihi' magtawwa' addat sigam maka iya bayi pigpalatun uk si Isaya. Uk na, ‘Asal du kaam kake, suga' 'nsa' niya' tahati bi. Asal du kaam kanda', suga' 'nsa' niya' tanda' bi. ");
INSERT INTO slm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sabab manga aa itu, 'nsa' niya' pasōd ni diyōm pikilan sigam, Tainga sigam bayi tiyaplōkan, Mata sigam bayi tiyambunan. Bang bayi 'nsa' salaihi', bayi du tanda' uk mata sigam, Bayi du take uk tainga sigam, Bayi du isab tahati uk diyōm pikilan sigam. Bo' bayi du sigam pabayik magtaat ni aku, uk Tuhan, Bo' iyampun uk ku dusa sigam.’ ");
INSERT INTO slm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Suga' kaam iyu,” uk si Isa ni manga mulid na, “mehe du kahapan bi, sabab iya tanda' bi, maka iya take bi tahati bi du. ");
INSERT INTO slm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Baan ta kaam tōōd, heka manga nabi maka aa suku' Tuhan ma masa awwal hi' bayi baya' tōōd nganda' ma tanda' bi ma buttihi', suga' 'nsa' tasabu uk sigam. Baya' tōōd sigam pake ma take bi itu, suga' 'nsa' taabut uk sigam.” ");
INSERT INTO slm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na,” uk si Isa, “pake kaam tōōd bo' tahati bi kissa pasal aa bayi magsabōran bigi hi'. ");
INSERT INTO slm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Manga bigi bayi pakpak ma daddōk ian paralilan aa bayi makake pasal kapagparinta Tuhan, suga' 'nsa' tahati uk sigam. Jari pay'an ni sigam sayitan patilaatun ngandagtu' lapal bayi tiyanōm uk Tuhan ma diyōm atay. ");
INSERT INTO slm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Manga bigi bayi pakpak ni tana' kabatuhan, paralilan aa bayi makake ma palman Tuhan. Magtuwi sigam kiyōgan nayima' lapal palman hi'. ");
INSERT INTO slm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Suga' palman Tuhan hi' 'nsa' bayi nganggamut palōm ma diyōm atay sigam. 'Nsa' natas pag-iman sigam. Taabut peen sigam takkahan susa atawa liyaat uk pagkahi sigam ma sabab pame' sigam ma palman Tuhan, magtuwi sigam ngalabba min pag-iman sigam. ");
INSERT INTO slm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Manga bigi bayi pakpak ni diyōm sōmpōt itingan hi' paralilan aa bang ngasip ma palman Tuhan. Suga' pag-asip peen, magtuwi limbit pikilan sigam uk kahalan diyōm dunya itu. Iya na peen halgaan ma sigam pangalta' sigam. Hangkan na palman Tuhan, iya bayi take uk sigam, sali' dalil tiyanōm kasimbōlan 'nsa' muwan buwa'. ");
INSERT INTO slm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na, manga bigi bayi siyabōran ma diyōm tana' hap hi', paralilan manga aa bang ngasip ma palman Tuhan maka makahati tōōd. Magtuwi palman ian sali' dalil tiyanōm, muwan buwa' ma diyōm atay sigam. Kasehean heka tōōd buwa' na, kasehean isab heka, maka kasehean sarang-sarang.” ");
INSERT INTO slm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Manjari magparalilan na isab si Isa pabayik. Uk na, “In kapagparinta Tuhan ma manusiya' sali' dalil aa nabōran bigi hap ma tana' na. ");
INSERT INTO slm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Manjari itu ma waktu sangōm, sabu peen magtuwihan aa kamemon, niya' banta aa dapu huma ian pay'an nabōran bigi sōmpōt ma bayi panabōran bigi hap. Puwas na hi' pakallo' banta hi'. ");
INSERT INTO slm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na, tomo' peen tiyanōm hap ian sampay nagna' na magbuwa', tanda' isab kasōmpōtan. ");
INSERT INTO slm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Manjari pay'an manga tindōg ni aa dapu huma. Uk sigam, ‘Tuwan, hap du bigi bayi sabōran nu ma tana' nu. Minningga baha' kasōmpōtan ian?’ ");
INSERT INTO slm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nambung in aa dapu huma, uk na, ‘Niya' banta bayi makahinang hi'.’ Uk manga tindōg, ‘Baya' kau baha' bang kami ngalarutan manga sōmpōt ian?’ ");
INSERT INTO slm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Daa,’ uk na, ‘sabab bang larutan bi sōmpōt, kalu me' larut manga batang hap. ");
INSERT INTO slm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sarin bi na magbe' magtomo' sampay taabut waktu pag-ani. Jari bang taabut na waktu pag-ani, salaitu du panoho' ku ma aa mag-ani ian. Uk ku, larutin bi manga sōmpōt ian dahu. Pakkōsun bi bo' iyampa tiyutung. Puwas na hi' anihun bi buwa' min bayi tiyanōm iyu bo' tawuun bi ni diyōm bodega ku.’ ” ");
INSERT INTO slm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Puwas na hi' magparalilan si Isa pabayik. Uk na, “In kapagparinta Tuhan ma manusiya' sali' dalil dakayo' bigi diki'-diki', iya tiyanōm uk aa ma tana' na. ");
INSERT INTO slm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bigi itu nahut min bigi kamemon, suga' bang tomo' na palabi ehe na min tiyanōm kamemon. Manjari kayu na, bo' patapu' pay'an manga manuk-manuk ngahinang pugaran ma senga na.” ");
INSERT INTO slm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Magparalilan le' iya saddi. Uk na, “Iya kapagparinta Tuhan sali' dalil pasulig iya giyuna uk danda pilamud ni tirigu heka, manga duwampu' maka lima kilu. Puwas na hi' iyaddun uk na, gana-gana pasulig kamemon na.” ");
INSERT INTO slm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kahaba'-haba' si Isa magpandu' ma kahekahan aa, magparalilan sadja iya. 'Nsa' iya missala ma sigam bang 'nsa' paralilan iya pamissala na. ");
INSERT INTO slm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Minnihi' niya' magtawwa' ma bayi tasulat uk dakayo' nabi, iya uk na, “Bang aku mandu' ma sigam subay bissala pamaralilan. Baan ku sigam pasal ayi-ayi 'nsa' bayi kitauhan sataggōl min tagna' pamapanjari dunya.” ");
INSERT INTO slm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Puwas na hi' imbanan uk si Isa kahekahan aa ian bo' pasōd ni diyōm luma'. Pay'an ni iya manga mulid na. Uk sigam, “Pahatihun kono' kami paralilan pasal sōmpōt ian.” ");
INSERT INTO slm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nambung si Isa, uk na, “Bang diyalil aa bayi nabōran bigi hap ian, iya na aku, Anak Manusiya'. ");
INSERT INTO slm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tana' ian, iya na dunya itu. Bigi hap ian, iya na manga aa me' piyarinta uk Tuhan. Kasōmpōtan ian, iya na manga aa me' ma nakura' sayitan, iya patilaatun. ");
INSERT INTO slm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Banta bayi nabōran bigi sōmpōt ian, iya na nakura' sayitan. Iya waktu kapag-ani, iya na 'llaw pangiyamat dunya. Iya aa mag-ani ian, iya na manga malaikat. ");
INSERT INTO slm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bang takdil ni kasōmpōtan iya tipun ian bo' iyampa tiyutung, salaihi' du isab pakaradjaan na bang taabut na 'llaw kiyamat. ");
INSERT INTO slm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aku Anak Manusiya', soho' ku du manga malaikat ku paitu ni dunya magtipun manga aa dusahan, sasuku bayi mo pagkahi na ngandusa maka sasuku bayi maghinang kalaatan. ");
INSERT INTO slm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tatipun peen, liyarukan sigam ni diyōm api nalka'. Mahi' sigam magtallik manga magtagiōt baggaang sigam, sabab min kapagsusun sigam. ");
INSERT INTO slm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Suga' manga aa suku' Tuhan magsahaya du, sali' mata 'llaw, bang ma diyōm pagparintahan 'Mma' sigam Tuhan. Sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Magparalilan isab si Isa, uk na, “In kapagparinta Tuhan ma manga aa na sali' dalil alta' bayi katapukan ma diyōm tana'. Sakali niya' aa bayi makatawwa' iya. Pagtawwa' na itu, magtuwi tambunan na pabayik. Landu' iya kiyōgan, hangkan iya pahi' ngandagang ayi-ayi na kamemon bo' iyampa billi uk na tana', iya bayi tatawwa' na alta' hi'.” ");
INSERT INTO slm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Salaitu isab kapagparinta Tuhan,” uk si Isa. “Sali' dalil aa maglilitu bang meha manga mussa' hap. ");
INSERT INTO slm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bang iya ganta' makatawwa' dakayo' mussa' halgaan tōōd, piballihan uk na ayi-ayi na kamemon bo' iyampa billi uk na mussa' hi'.” ");
INSERT INTO slm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Salaitu isab kapagparinta Tuhan ma manusiya',” uk si Isa. “Sali' dalil pōkōt hiyug ni diyōm tahik, siyōd uk ginis-ginisan daying. ");
INSERT INTO slm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Panno' peen pōkōt hi', na giyuyud uk manga aa magdaraying ian tudju ni daplakan. Ningko' sigam may'an bo' pigsaddi baanan daying ian. Ingga hap liyōōn uk sigam ni diyōm ambung, ingga 'nsa' tapagguna timanan. ");
INSERT INTO slm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Salaihi' du isab bang kiyamat na dunya itu. Paluwas manga malaikat bo' pigsaddi uk sigam manusiya' hap maka laat. ");
INSERT INTO slm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Iya malaat liyarukan du ni diyōm api nalka'. Mahi' sigam magtallik, manga magtagiōt baggaang sigam, sabab min pagsusun sigam.” ");
INSERT INTO slm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tiyaw uk si Isa manga mulid na, uk na, “Tahati bi baha' kamemon bayi pamissala ku ma kaam hi'?” “Aho',” uk sambung sigam. ");
INSERT INTO slm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Na,” uk si Isa, “bang niya' guru ma sara' agama me' ma kapagparinta Tuhan, sali' iya dalil aa dayahan taga luma'. Heka asal alta' na bahu maka daan, hati na pangatau na pasal pandu' tagna' sampay pandu' bahu.” ");
INSERT INTO slm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pag-ubus si Isa bayi magparalilan itu, pakallo' iya min lahat ian, ");
INSERT INTO slm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bo' iyampa mowe' ni kalumaan iya asal lahat na. Manduan iya manga aa may'an ma diyōm langgal sigam. Inu-inu sigam ma pamandu' na. Uk sigam, “Oy! Minningga baha' pangalloan na pangatau na, maka barakat na iya pangahinang na manga kahinangan makainu-inu hi'? ");
INSERT INTO slm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bang kami 'nsa' sā', iya na itu anak karpentero. Ina' na si Mariyam. Manga danakan na di si Ya'kub, si Yusup, si Judas maka si Simun. ");
INSERT INTO slm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Maka manga danakan na danda, tiya' na isab ma lungan ta itu. Minningga baha' pangalloan na tau na itu?” ");
INSERT INTO slm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hangkan na si Isa kipaddian atay uk manga aa ian. Sakali halling si Isa ni sigam. “In nabi,” uk na, “pig-addatan asal ma sabarang lahat. Iya sadja 'nsa' mag-addat ma iya bang aa ma lahat na asal maka manga aa magdaluma' maka iya.” ");
INSERT INTO slm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jari kulang du hinang makainu-inu bayi tahinang uk si Isa ma lahat na sabab aa ian 'nsa' mangandōl ma iya. ");
INSERT INTO slm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma waktu hi' si sultan Herod bayi magbaya' ma lahat Jalil. Manjari itu makake iya pasal kahinangan si Isa, ");
INSERT INTO slm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","bo' halling iya ni manga sasohoan na, uk na, “Aa ian, iya na iya tōōd si Yahiya Magpapandi pikallum na pabing min kamatay na. Hangkan ko' tahinang na manga hinang makainu-inu ian.” ");
INSERT INTO slm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Hangkan salaihi' halling si Herod, sabab iya iya bayi magpanohoan mapatay si Yahiya. Salaitu bayi kahalan na: si Sultan Herod itu bayi magkabaya' maka ipal na si Herodiyas, handa siyay na si Pilip. Bo' si Pilip iya masi le' 'llum. Sakali daran si Herod biyandaan uk si Yahiya. Uk na, “'Nsa' manjari bang kau magdakayo' maka handa danakan nu! Dusahan kau!” Hangkan na si Yahiya bayi siyoho' siyaggaw uk sultan, siyoho' iyekang-ekangan bo' iyampa pisōd liyōōn ni diyōm jil. ");
INSERT INTO slm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Baya' si Herod mapatay si Yahiya suga' tiyāw iya ma kahekahan aa, sabab magkahagad sigam in si Yahiya nabi du. ");
INSERT INTO slm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jari niya' dakayo' 'llaw magjamu si Sultan Herod ma manga aa, panabu 'llaw kapag-anak ma iya. Na, ngiluk anak si Herodiyas budjang ma panganda' pagjamuhan bo' kasulutan tōōd si Herod ma pangiluk na, ");
INSERT INTO slm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hangkan panganjanjian na budjang ian. Uk na, “Janjian ta kau. Ayi-ayi amu' nu ni aku pamuwan ku du tōōd.” ");
INSERT INTO slm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na, in budjang ian bayi kapitnahan asal uk ina' na hangkan uk na ni sultan, “Pamuwanun kono' aku kok si Yahiya Magpapandi buttihi', pibōtang ma diyata' talam.” ");
INSERT INTO slm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Landu' tōōd susa sultan ian, suga' 'nsa' kapindahan bayi panganjanji' na ma alōpan manga aa luruk hi', hangkan soho' na subay diyulan budjang ma bayi amu' na hi'. ");
INSERT INTO slm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jari magpanohoan si Herod subay piyonggolan kok si Yahiya ma diyōm jil. ");
INSERT INTO slm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Puwas na hi' pibōtang kok na ma diyata' talam bo' iyampa biyo ni budjang. Bo' biyo uk budjang ian ni ina' na. ");
INSERT INTO slm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sakali pay'an manga mulid si Yahiya ngallo' patay na kiyubul. Puwas na hi' pahi' sigam ni si Isa ma'-ma' ma iya. ");
INSERT INTO slm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, take peen uk si Isa ma pasal ian hi', pakallo' iya minnihi' musay ni lahat 'nsa' mag-aa, iya didi na sadja. Kitauhan peen kamahian na uk baanan aa, maglangngan sigam min manga kalumaan sigam bo' paturul ma iya, maklay min bihing susulan. ");
INSERT INTO slm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagduwai peen si Isa min bayanan na, tanda' na manga aa ian landu' tōōd heka. Sakali takkahan iya ase' ma sigam, maka kaulian uk na sasuku taga saki. ");
INSERT INTO slm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagka song kohap na, pahi' ni si Isa manga mulid na. Uk sigam, “Song sangōm na, maka tiya' kitabi ma lahat 'nsa' niya' kalumaan na. Sohoun kono' manga aa itu pahi' ni manga kalumaan may'an bo' sigam makaballihan di sigam kiyakan.” ");
INSERT INTO slm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nambung si Isa, uk na, “Minsan sigam 'nsa' pakallo' minnitu. Kaam na iya makan sigam.” ");
INSERT INTO slm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Uk manga mulid na, “Lima du tinapay ma kami maka duwa du daying!” ");
INSERT INTO slm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Na,” uk si Isa, “bohun bi paitu.” ");
INSERT INTO slm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Manjari siyoho' baanan aa ian uk si Isa magtingkoan ma kaparangan. Puwas na hi' killo' uk na lima tinapay maka duwa daying-daying bo' iyampa iya pahangad tudju ni langit magsukul ni Tuhan. Pighopo'-hopo' uk na tinapay bo' iyampa siyongan uk na ni manga mulid na, bo' tiyōpōd-tōpōran uk sigam manga aa ian. ");
INSERT INTO slm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Magkakanan na aa ian kamemon sampay maglassohan na. Pag-ubus sigam mangan, tipun kapin kiyakan ian uk manga mulid na, niya' sangpu' ka duwa ambung mehe panno'. ");
INSERT INTO slm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iya aa bayi mangan ian niya' sigam manga limangibu lalla. Saddi danda maka onde'-onde'. ");
INSERT INTO slm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Puwas na hi' siyoho' uk si Isa manga mulid na pariyata' ni bayanan. Pirahu sigam min iya tudju ni dambiya' danaw, sabu na mapowe' kahekahan aa ian. ");
INSERT INTO slm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tapapowe' peen manga aa hi', patukad si Isa didi na nambahayang ma diyata' bud. Sangōm peen lahat, may'an iya didi na, ");
INSERT INTO slm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","bo' manga mulid na mahi' ma danaw lawak min bihing. Tawwa' sigam goyak sabab nagga' baliyu. ");
INSERT INTO slm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pagdayi' 'llaw peen, pahi' na si Isa tudju ni sigam, mangngan ma kuwit tahik. ");
INSERT INTO slm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tanda' peen iya uk manga mulid na mangngan ma kuwit tahik, landu' sigam tiyāw sabab pangannal sigam in iya lutaw. Magsuwalak sigam pakōsōg sabab tiyāw kalandu'. ");
INSERT INTO slm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Suga' missala magtuwi si Isa ni sigam. “Pataptapun bi pangatayan bi!” uk na. “Aku na ko' itu. Daa kaam tiyāw.” ");
INSERT INTO slm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sakali halling si Petros, uk na, “Nakura', bang iya na kau, sohoun aku paiyu ni kau mangngan ma kuwit tahik.” ");
INSERT INTO slm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Paitu na kau,” uk si Isa. Jari pareyo' si Petros min bayanan ian nagna' mangngan ma kuwit tahik tudju ni si Isa. ");
INSERT INTO slm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Suga' pagnanam na kōsōg baliyu ian, takkahan iya tāw bo' enot-enot iya patallōb. Magtuwi iya ngalingan, uk na, “Nakura', tabangun aku!” ");
INSERT INTO slm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Magtuwi iya iyabut uk si Isa bo' iyampa hella' uk na. Halling si Isa, “Kulang pahap iman nu! Angay aku pagduwa-duwahan nu?” ");
INSERT INTO slm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Makariyata' peen sigam ni bayanan hi', iyampa parōhōng na baliyu. ");
INSERT INTO slm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Piyudji si Isa uk manga mulid bayi ma diyata' ian. Uk sigam, “Bannal, kau Anak Tuhan du ko'!” ");
INSERT INTO slm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jari itu, makauntas peen sigam ni dambiya' danaw, hi' sigam parunggu' ni lahat Gennesaret. ");
INSERT INTO slm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Takila si Isa uk manga aa ma hi', iya hangkan sigam bayi matanyag ma sasuku taga saki ma jadjahan ian hi', siyoho' biyo ni si Isa. ");
INSERT INTO slm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ngamu' sigam junjung ni si Isa, bang peen du dulan na manga aa sakihan ngantan minsan laa ma bihing sammek na sadja. Manjari sayi-sayi bayi makaantanan sammek si Isa saruun-duun du kaulian saki na. ");
INSERT INTO slm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Manjari niya' pay'an ni si Isa manga aa Parisi maka guru ma sara' agama bayi min daira Awrusalam. Tiyaw sigam ma iya, ");
INSERT INTO slm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","uk sigam, “Angay manga mulid nu iyu 'nsa' mōgbōg ma usulan bayi pangamban uk kamaasan tabi? Mangan sigam minsan 'nsa' bayi ngosean tangan sigam pahap.” ");
INSERT INTO slm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nambung si Isa, uk na, “Na, kaam iya. Angay langgal bi panohoan Tuhan bo' be' bi manga usulan bayi min kamaasan bi? ");
INSERT INTO slm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sabab bayi na magpanohoan Tuhan, uk na, ‘Wajib kaam mag-addatan 'mma' bi maka ina' bi.’ Maka itu le', ‘Sayi-sayi iya mahalling laat ma 'mma' na atawa ma ina' na, aa ian subay piyatay.’ ");
INSERT INTO slm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Suga' kaam,” uk si Isa, “magsaddi-saddi iya pamandu' bi ma manga aa. Ma pamandu' bi, bang niya' aa ganta' missala ni 'nggo'-mma' na, uk na, ‘Alta' ku itu, iya arak bayi panabang ku kaam, 'nsa' na sabab pasuku' ku na ni Tuhan.’ ");
INSERT INTO slm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bang salaihi' hinang na makajari na bang ma kaam, minsan 'nsa' pag-addatan na 'nggo'-mma' na. Suga' minnihi' tasulak bi panohoan Tuhan supaya kaam makabōgbōg ma bayi pangamban uk kamaasan bi. ");
INSERT INTO slm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaam iyu magbawu'-bawu' sadja in kaam me' ma Tuhan, bo' 'nsa'. Asal bannal du iya bayi tasulat uk si Isaya ma diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Uk na, ‘Manga aa itu, uk Tuhan, ngahulmat aku maka lapal kabtangan sigam, Suga' lawak diyōm atay sigam min aku. ");
INSERT INTO slm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iya pagpudji sigam ma aku 'nsa' niya' pus na, Sabab iya pamandu' uk sigam panohoan bayi pihinang sadja uk manusiya', 'Nsa' bayi duwai min aku.’ ” ");
INSERT INTO slm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Puwas na hi', linganan baanan aa ian uk si Isa, siyoho' patipun pabing ni tōngōd na. Uk na ni sigam, “Pake kaam ma bissala ku. Pahati ta kaam tōōd. ");
INSERT INTO slm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","'Nsa' iya kiyakan pasōd ni diyōm bo' aa iya makatamak iya. Suga' iya makatamak iya manga bissala laat iya paluwas min bo' na.” ");
INSERT INTO slm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sakali pay'an ni si Isa manga mulid na. Uk sigam, “Katauhan nu baha' in manga Parisi paddi' atay sigam ma bayi bissala nu sini'?” ");
INSERT INTO slm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Uk sambung si Isa, “Kamemon tiyanōm iya 'nsa' bayi tiyanōm uk 'Mma' ku ma diyōm sulga', liyarutan du. ");
INSERT INTO slm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Daa kaam magsusa pasal sigam. Sigam magnakura', suga' sali' sigam aa buta. Bang buta du ngambit sehe' na buta, tantu sigam hug karuwangan ni diyōm lowang.” ");
INSERT INTO slm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sakali halling si Petros, uk na, “Pahatihun kami pasal bayi pamaralil nu iyu.” ");
INSERT INTO slm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Uk si Isa, “Oy! Sampay kaam isab masi le' kulang panghati bi! ");
INSERT INTO slm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaam isab, 'nsa' tasayu bi? 'Nsa' tahati bi baha'? Bang niya' kiyakan pasōd ni diyōm bo' aa, pasampay du ni diyōm battōng na bo' iyampa paluwas min baran na. ");
INSERT INTO slm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Suga' bissala laat iya paluwas min bo' aa, bayi piyoonan asal min diyōm atay na. Iya na hi' makatamak iya. ");
INSERT INTO slm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sabab min diyōm atay manusiya' iya paluwasan pamikil na laat, iya hangkan maghinang kalaatan, sali' manga mapatay, magjina, ngahinang kasabulan danda-lalla, nangkaw, magputing, maka ngalimut. ");
INSERT INTO slm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kamemon itu makatamak aa. Suga' bang kita mangan ma 'nsa' bayi ngosean tangan ta sali' pamandu' manga Parisi, 'nsa' ihi' makabuwan katamakan.” ");
INSERT INTO slm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sakali palanjal si Isa minnihi' tudju ni jadjahan daira Tira maka daira Sidun. ");
INSERT INTO slm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niya' danda bangsa Kanaan maglahat may'an. Manjari danda itu bayi pahi' ni si Isa ngalinganan iya. “O Tuwan,” uk na, “tubu' Sultan Daud, maase' kau ma aku. Anak ku bayi danda siyōd uk sayitan. Binsana' kalandu'.” ");
INSERT INTO slm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Suga' 'nsa' bayi makasambung si Isa minsan dakabtang. Jari pay'an ni iya manga mulid na ngalōgōs, uk sigam, “Sohoun iya pakallo'! 'Nsa' iya parōhōng nurul kitabi, maka sagaw kalandu'!” ");
INSERT INTO slm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nambung si Isa, uk na, “Bayi aku siyoho' paitu nabang manga aa bangsa Israil, iya sali' dalil bili-bili lungay min labayan.” ");
INSERT INTO slm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Suga' pagtake peen itu uk danda, magtuwi iya pasujud ni tōngōd nayi' si Isa. “O Tuwan,” uk na, “tabangun aku.” ");
INSERT INTO slm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Siyambungan iya uk si Isa piralilan. Uk na, “'Nsa' manjari killo' kiyakan manga anak bo' liyarukan ni manga ero'.” ");
INSERT INTO slm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Bannal, Tuwan,” uk danda. “Suga' minsan manga ero' mangan du momok kiyakan iya pakpak min lamisahan pag-ipatan ma sigam.” ");
INSERT INTO slm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sakali nambung si Isa, uk na, “Inda', hōgōt iman nu. Diyulan du kau bayi pangamu' nu iyu.” Manjari ma waktu hi' saruun-duun du kaulian anak na danda hi'. ");
INSERT INTO slm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Puwas na hi' pakallo' si Isa min lahat ian, maklay min bihing danaw Jalil. Jari patukad iya ni bid-bid ningko' ma hi'. ");
INSERT INTO slm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Landu' heka aa bayi pay'an ni iya mo manga pengka', manga aa piul, manga buta, manga umaw, sampay baanan aa saddi tawwa' ginisan saki. Pibōtang sigam uk sehe' sigam ma tōngōd nayi' si Isa, bo' kaulian uk na sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Inu-inu tōōd manga aa ian, pag'nda' sigam ma aa bayi umaw makapahalling na; aa bayi piul kaulian na; aa bayi pengka' makalangngan na pabōntōl; aa bayi buta makanda' na. Manjari siyanglitan uk sigam Tuhan, iya pagtaatan bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sakali linganan uk si Isa manga mulid na bo' uk na, “Maase' aku ma manga aa itu, sabab katallu 'llaw itu na iya kamaitu sigam ma aku, maka 'nsa' na niya' kiyakan sigam. 'Nsa' aku baya' mapowe' sigam ma 'nsa' bayi pakan ku dahu, arakala' piyunung sigam ma palangnganan sigam.” ");
INSERT INTO slm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tiyaw iya uk manga mulid na, uk sigam, “Minningga baha' pangalloan ta kiyakan sarang pamakan kahekahan aa itu? Tiya' kitabi ma 'nsa' niya' kalumaan na itu!” ");
INSERT INTO slm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Uk si Isa, “Pila heka tinapay bi iyu?” Sambung sigam, “Pitu' tinapay maka manga daying-daying kulang heka na.” ");
INSERT INTO slm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Manjari siyoho' uk si Isa kahekahan aa ian magtingkoan ma tana'. ");
INSERT INTO slm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Killo' uk na pitu' tinapay maka manga daying-daying ian, bo' iyampa magsukul ni Tuhan. Puwas na hi' pighopo'-hopo' uk na tinapay maka daying bo' iyampa siyongan uk na ni manga mulid na. Bo' tiyōpōd-tōpōran manga aa ian uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Magkakanan sigam kamemon sampay maglassohan na. Ubus peen bayi mangan, niya' pitu' ambung mehe panno' uk momok kiyakan bayi tatipun uk manga mulid hi'. ");
INSERT INTO slm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Manga aa bayi magkakanan ian niya' manga 'mpat ngibu lalla itung, saddi danda maka onde'-onde'. ");
INSERT INTO slm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jari pipowe' manga aa ian uk si Isa. Pariyata' iya ni bayanan bo' iyampa pauntas ni lahat Magadan. ");
INSERT INTO slm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Manjari niya' manga Parisi maka manga Saddusi bayi pay'an ni si Isa mikipanda' paltandaan. Baya' sigam nulayan iya bo' supaya sigam kanda' bang niya' kapatut na min Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Suga' nambung si Isa, uk na, “Kaam iyu, bang sawupama pasaddōp na 'llaw, uk bi, ‘A, taddo' du sawung sabab iyu keyat bihing langit.’ ");
INSERT INTO slm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pagsubu-subu isab, uk bi, ‘Ulan 'llaw itu sabab keyat bihing langit maka pandōm.’ Tau kaam nganda' pandōgahan ma bihing langit, suga' 'nsa' kapandōgahan bi paltandaan iya tanda' bi ma masa itu hi'. ");
INSERT INTO slm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Manga aa ma waktu itu hi' laat kalandu', maka 'nsa' baya' magtaat ma Tuhan. Baya' kaam baha' nganda' paltandaan barakatan? 'Nsa' niya' paltandaan pindaan kaam, duwal paltandaan bayi min si Nabi Yunus ma masa awwal hi'.” Puwas na hi' imbanan manga aa ian uk si Isa, bo' pakallo' iya minnihi'. ");
INSERT INTO slm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pagtakka manga mulid si Isa ni dambiya' danaw, 'nsa' sigam bayi makaintōm mo tinapay lutu' sigam. ");
INSERT INTO slm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Uk si Isa ni sigam, “Kamaya'-maya' kaam. Halliin bi pasulig tinapay min manga Parisi maka min manga Saddusi.” ");
INSERT INTO slm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Magbissala manga mulid na pasal halling na hi', sabab 'nsa' tahati. Uk pagbaha' sigam, “Hangkan salaihi' marayi' halling si Isa sabab 'nsa' kita bayi mo tinapay.” ");
INSERT INTO slm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kitauhan asal uk si Isa bang ayi iya pigbissala uk sigam, hangkan uk na, “Angay pagbissala bi pasal 'nsa' niya' tinapay bi? Kulang pahap pangandōl bi ni aku! ");
INSERT INTO slm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","'Nsa' le' tahati bi baha'? 'Nsa' marayi' taintōm bi bayi waktu kapaghopo'-hopo' ku tinapay lima heka na pamakan manga limangibu aa hi'? Intōmun bi bang pila ambung mehe bayi pangalōōnan bi kapin kiyakan hi'? ");
INSERT INTO slm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Maka tinapay pitu' heka na bayi pamakan 'mpat ngibu aa hi'. Pila ambung bayi pangalōōnan bi? ");
INSERT INTO slm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Angay kaam 'nsa' makahati? 'Nsa' pasal tinapay iya bayi pagbissala ku hi'. Uk ku, halliin bi pasulig tinapay manga Parisi maka Saddusi!” ");
INSERT INTO slm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Minnihi' iyampa tahati uk sigam 'nsa' pasal pasulig pamasuwig tinapay iya bayi halling na, suga' pandu' min manga Parisi maka min manga Saddusi. Iya na hi' subay hiyallian pahap. ");
INSERT INTO slm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na, pahi' di si Isa ni jadjahan lahat ma kasikōtan daira Kesareya Pilipi. May'an peen, tiyaw uk na manga mulid na, uk na, “Bang ma pangupama aa, sayi kono' aku Anak Manusiya'?” ");
INSERT INTO slm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Uk sambung manga mulid hi', “Bang ma aa kasehean kau kono' si Yahiya Magpapandi. Bang isab ma aa kasehean in kau si Nabi Eliyas atawa Nabi Irimiya. Maka bang ma aa kasehean isab dakayo' nabi kau bayi ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Na, bang ma kaam,” uk si Isa, “ayi uk bi? Sayi aku itu?” ");
INSERT INTO slm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nambung si Simun Petros. “Kau si Almasi,” uk na, “Anak Tuhan iya asal 'llum.” ");
INSERT INTO slm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Mehe kahapan ma kau, Simun anak si Yahiya,” uk si Isa, “sabab 'nsa' min manusiya' iya hangkan katauhan nu iyu hi'. Bayi pamatau kau uk 'Mma' ku ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na, iya na itu pama' ku ma kau: kau si Petros, hati na batu. Bo' ma diyata' batu iyu pangahinangan ku langgal ku, hati na manga jamaa ku kamemon. 'Nsa' sigam taraōg uk Nakura' Sayitan. ");
INSERT INTO slm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Buwanan ta kau kunsi', hati na kapatut ngukab pasōran manusiya' tudju ni diyōm pagparintahan Tuhan. Ayi-ayi liyāng uk nu ma diyōm dunya itu liyāng du isab ma diyōm sulga', maka ayi-ayi pamarul nu ma diyōm dunya itu pirul du isab uk Tuhan ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Puwas na hi' biyandaan uk si Isa manga mulid na, 'nsa' siyoho' ma'-ma' ni sayi-sayi in iya si Almasi. ");
INSERT INTO slm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Manjari puwas minnihi', nagna' si Isa mahatihan manga mulid na pasal ayi makatawwa' ma iya ma sosongun. Uk na, “Subay aku pahi' ni daira Awrusalam. Heka du kabinsanaan pitakka ni aku uk manga kamaasan, uk manga kaimaman langkaw, maka uk manga guru ma sara' agama. Piyatay du aku, suga' bang palabay na tallum bahangi pikallum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sakali si Petros bayi mo si Isa paōkat min kasehean, bo' iyampa siyamlang uk na. Uk si Petros, “Oy! Tuwan, daa kau halling salaihi'! 'Nsa' du diyulan uk Tuhan bang hinang ma kau salaihi'.” ");
INSERT INTO slm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Suga' iyalōp si Petros uk si Isa. Uk na, “Pakallo' kau min aku, sayitan! Kau iyu bilang mo aku ngalabba min kabayaan Tuhan. Iya pamikil nu iyu pikilan manusiya' ko', 'nsa' pikilan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Puwas na hi' missala si Isa ni manga mulid na, uk na, “Bang niya' baya' me' ma aku,” uk na, “subay 'nsa' kabayaan baran na iya diyulan uk na. Subay tanggung na hag na pamapatayan iya, hati na subay paglilla' na kabinsanaan ma sabab ku sampay ni kamatay. Minnihi' iya makajari me' ma aku. ");
INSERT INTO slm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sayi-sayi 'llōgan ginhawa baran na, paōkat du kallum-nyawa na min Tuhan. Suga' sayi-sayi 'nsa' 'llōg ma ginhawa baran na, lilla' isab matay ma sabab ku, makatawwa' du iya kallum kakkal. ");
INSERT INTO slm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sabab na,” uk si Isa, “bang niya' aa ganta' kaniyaan alta' diyōm dunya kamemon, mehe lugi' na bang 'nsa' niya' kallum na kakkal. Sabab 'nsa' niya' tapangalakkat na kallum-nyawa na bang paōkat na. ");
INSERT INTO slm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aku, Anak Manusiya' pabing du paitu, libut uk sahaya 'Mma' ku. Iya sehe' ku ian manga malaikat na. Tungbasan ku manusiya' kamemon, pipagtōngōd maka bayi hinang sigam dangan maka dangan. ");
INSERT INTO slm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bannal iya halling ku itu ma kaam, niya' ma itu ma kaam 'nsa' matay sataggōl aku, Anak Manusiya', 'nsa' le' paitu magparinta ma diyōm dunya. Subay na aku tanda' uk sigam bo' iyampa sigam matay.” ");
INSERT INTO slm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Palabay peen 'nnōm 'llaw min waktu hi', manjari biyo uk si Isa si Petros maka duwangan magdanakan, iya si Ya'kub maka si Yahiya, patukad ni diyata' bud langkaw, sigam-sigam sadja. ");
INSERT INTO slm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","May'an peen sigam, pinda dagbōs si Isa ma panganda' sigam. Sahaya pamayihuan na sali' mata 'llaw. Makasilaw tōōd pote' sammek na. ");
INSERT INTO slm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sakali panyata' pay'an si Musa maka si Nabi Eliyas, tanda' uk manga mulid ian magbissala maka si Isa. ");
INSERT INTO slm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Halling si Petros ni si Isa, uk na, “Tuwan Panghu', hap tōōd isab tiya' kami ma itu. Baya' kau baha' bang aku ngahinang tallu bawung-bawung pasindungan bi ma itu, dakayo' ma kau, dakayo' ma si Musa itu, maka dakayo' ma si Eliyas?” ");
INSERT INTO slm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sabu peen iya halling, niya' gabun sahaya bayi ngalandungan sigam, maka niya' suwara halling min diyōm na. Uk suwara hi', “Anak ku ko' itu kalasahan ku. Landu' aku kasulutan ma iya. Iya iya kehun bi.” ");
INSERT INTO slm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagtake peen suwara itu uk manga mulid, landu' tōōd sigam tiyāw hangkan pakappang magtuwi ni tana'. ");
INSERT INTO slm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Suga' pay'an si Isa ni sigam maabut tangan na ma sigam. Uk na, “Papunduk kaam, daa kaam tiyāw.” ");
INSERT INTO slm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagtongas sigam, 'nsa' niya' saddi tanda' uk sigam, duwal si Isa. ");
INSERT INTO slm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Manjari itu, sabu peen sigam palud min bud hi', biyandaan uk si Isa manga mulid na, uk na, “Daa kaam ma'-ma' ni sayi-sayi pasal bayi tanda' bi ma hi' ma diyata' bud hi'. Subay na aku, Anak Manusiya' itu, tapakallum pabing min kamatay ku bo' iyampa kaam ma'.” ");
INSERT INTO slm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sakali tiyaw si Isa uk sigam, uk na, “Angay manga guru ma sara' agama mandu' in si Nabi Eliyas subay dahu palahil paitu?” ");
INSERT INTO slm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nambung si Isa, uk na, “Bannal ko' iyu, si Eliyas palahil dahu min si Almasi nakapan kamemon. ");
INSERT INTO slm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Suga' baan ta kaam, bayi na palahil si Eliyas paitu bo' 'nsa' iya bayi takila uk manga manusiya'. Bayi tahinang uk sigam ma iya ayi-ayi kabayaan sigam. Damikkiyan na aku, Anak Manusiya', binsana' du isab uk sigam.” ");
INSERT INTO slm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Minnihi' tahati uk manga mulid in si Yahiya Magpapandi ko' hi', iya bissalahan uk si Isa. ");
INSERT INTO slm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na, makabing peen di si Isa ni kahekahan aa hi', niya' dakayo' aa pay'an ni iya pasujud. ");
INSERT INTO slm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Uk na ni si Isa, “Tuwan, maase' kau ma anak ku lalla. Biyaboy-baboy iya, kalandu' tōōd saki na. Daran iya pahantak ni diyōm api atawa ni diyōm bohe'. ");
INSERT INTO slm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bayi bo ku iya ni manga mulid nu suga' 'nsa' iya tapakowe' uk sigam.” ");
INSERT INTO slm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nambung si Isa, uk na, “Kaam manga aa ma waktu itu hi', sā' pahap pikilan bi! 'Nsa' tōōd niya' iman bi! Subay salaingga le' taggōl ku ma kaam nandalan addat bi bo' iyampa kaam magkahagad? Bohun paitu onde',” uk na. ");
INSERT INTO slm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tabo peen onde' ian ni si Isa, magtuwi pihalling uk na sayitan. Piluwas uk na min baran onde' bo' saruun-duun du parōhōng saki na. ");
INSERT INTO slm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Puwas na hi' tiyaw si Isa uk manga mulid na, sigam-sigam sadja. Uk sigam, “Angay kami itu 'nsa' bayi makapaluwas sayitan hi'?” ");
INSERT INTO slm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Uk si Isa, “Sabab kulang pangandōl bi ma Tuhan. Baan ta kaam tōōd, bang bayi makasali' ehe pangandōl bi ni sali' ehe bigi-bigi nahut, tahinang du uk bi kamemon minsan salaingga hunit na. Bang sawupama soho' bi bud itu papinda minnitu pay'an, papinda du.  ");
INSERT INTO slm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Suga' in ginisan sayitan ian 'nsa' tapaluwas, duwal bang kaam nambahayang maka magpuwasa dahu.” ");
INSERT INTO slm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Niya' waktu 'llaw dakayo' hi' magtipun manga mulid na ma lahat Jalil. Uk si Isa ni sigam, “Aku itu, Anak Manusiya', marayi' na siyongan ni pagbayaan manga aa, ");
INSERT INTO slm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bo' aku piyatay du uk sigam. Suga' tallum bahangi puwas min kamatay ku 'llum du aku pabing.” Minnihi' susa tōōd manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagtakka si Isa maka manga mulid na ni daira Kapirnaum, niya' pay'an ni si Petros manga aa ngamu' sukay langgal. Uk sigam ni iya, “Guru bi iyu, mayad baha' sukay langgal?” ");
INSERT INTO slm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Aho',” uk sambung si Petros. Makasōd peen si Petros ni diyōm luma' arak ma'-ma', makarahu si Isa halling ni iya, uk na, “Simun, bang ma kau, sayi killoan sukay uk manga sultan ngantan lahat ma diyōm dunya itu? Anak-kampung na, atawa aa saddi?” ");
INSERT INTO slm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Aa saddi,” uk si Petros. “Na,” uk si Isa, “bang salaiyu, hati na in kitabi anak Tuhan itu 'nsa' wajib mayad sukay hi'. ");
INSERT INTO slm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Suga' 'nsa' niya' kabayaan ta kipaddian atay uk manga aa ian. Hangkan kau subay pahi' ni bihing danaw ian muwang. Pagtinduk daying, hellaun magtuwi. Makatawwa' du kau sin ma diyōm bo' na, sarang pamayad ta sukay langgal. Kalloun sin ian bo' pamayarun pahi'.” ");
INSERT INTO slm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma waktu hi' du, pay'an ni si Isa manga mulid na tiyaw iya. Uk sigam, “Sayi langkaw katapusan ma diyōm pagparintahan Tuhan?” ");
INSERT INTO slm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sakali linganan uk si Isa dakayo' onde'-onde', siyoho' nangge ma alōpan sigam. ");
INSERT INTO slm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Uk si Isa, “Baan ta kaam tōōd: sayi-sayi 'nsa' pinda ni pamikil hap sali' pamikil onde'-onde' itu, 'nsa' tōōd pisōd ni diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sayi-sayi mareyo' atay na, pisali' ni sali' atay onde'-onde' itu, iya na ko' hi' langkaw min kasehean na ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sayi-sayi isab nayima' dakayo' onde'-onde' salaitu ma sabab ōn ku iya pamanyabutan na, sali' baran ku iya tiyayima' uk na.” ");
INSERT INTO slm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Uk si Isa le', “Bang niya' aa ganta' mo ngahinang dusa dakayo' aa deyo' sali' hantang onde' itu, aa taga pangandōl tudju ni aku, hap le' bang aa ian piggantungan batu bohat ma kallong na bo' iyampa hiyug ni sallang. Hap le' ihi', bang peen daa kalanduan hinang na salaihi'. ");
INSERT INTO slm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Makaase'-ase' tōōd manga manusiya' itu, sabab niya' na peen kasasatan makabo ma sigam maghinang dusa. Tantu niya' manga sasat-manasat paniya', suga' makaase'-ase' tōōd iya pamakadal ma sasuku nasat sehe' na mo magdusa. ");
INSERT INTO slm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Bang tangan bi atawa nayi' bi ganta' mo kaam ni magdusa, subay hopoun bi. Gam na peen tattōpin bi bo' timanan. Hap le' kaam 'llum ma diyōm sulga' ma pukul dambiya' tangan bi atawa nayi' bi, bang peen kaam 'nsa' liyarukan ma jukup nayi'-tangan bi ni diyōm api nalka' iya 'nsa' kapaddahan. ");
INSERT INTO slm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Damikkiyan du isab bang mata bi ganta' mo kaam ni magdusa, lugitin bi. Gam na peen lugitin bi bo' timanan. Hap le' kaam 'llum ma diyōm sulga' ma buta dambiya' mata bi, bang peen kaam 'nsa' liyarukan ni diyōm api nalka' ma jukup mata bi karuwambiya'.” ");
INSERT INTO slm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kamaya'-maya' kaam. Daa pareyoun bi manga aa ku minsan dakayo' onde'-onde' itu. Sabab baan ta kaam, ian tunggu' sigam manga malaikat paharap na peen ni 'Mma' ku Tuhan ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sabab aku, Anak Manusiya', bayi paitu ni dunya ngalappas manga aa iya lawak min Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bistahun bi: bang niya' aa sawupama taga bili-bili dahatus heka na, bo' hi' pasiha' dakayo', ayi baha' hinang na? Tantu pasaran na siyampu' maka siyam ma hi' ma kabid-biran bo' iyampa iya pahi' meha dakayo' bayi pasiha' hi'. ");
INSERT INTO slm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jari bang tatawwa' na, baan ta kaam, kiyōgan iya tōōd. Palabi le' kōg na ma bili-bili dakayo' ian min siyampu' maka siyam iya 'nsa' bayi lungay. ");
INSERT INTO slm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Salaihi' du isab ma 'Mma' tabi ma diyōm sulga', 'nsa' iya baya' subay lungay dakayo' onde'-onde' min ōkōman na.” ");
INSERT INTO slm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na, bang niya' pagkahi nu ganta' makabuwan dusa ma kau, bain bi iya pahi' pasal kasaan na, suga' subay kaam duwangan sadja magbissala. Bang kau iyasip uk na, bo' kabayaan na maghap maka kau, hōgōt gam peen kapagbagay bi. ");
INSERT INTO slm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Suga' bang hati 'nsa' akuhan na dusa na, bohun dakayo' atawa duwa aa saddi naksian ayi-ayi pagbissala bi, bo' supaya tabe' panohoan bayi ma diyōm kitab, iya uk na, ‘Bang niya' palkala' bi subay niya' duwangan atawa tallungan muwan saksi' bo' supaya pigsabannal.’ ");
INSERT INTO slm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Suga' bang aa ian 'nsa' ganta' ngasip ma manga aa saddi iya bo nu ian, na, bain manga sehe' bi dajamaahan kamemon. Jari bang iya 'nsa' baya' ngasip ma kagaraan manga jamaa kamemon, aa ian subay bista uk bi sali' aa 'nsa' niya' tuhan na, atawa sali' aa magkallo' sukay ma parinta iya ngakkal sadja.” ");
INSERT INTO slm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Baan ta kaam tōōd, ayi-ayi pangalang bi ma diyōm dunya itu liyāng du isab ma diyōm sulga', maka ayi-ayi parul bi ma diyōm dunya itu pirul du isab ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Niya' isab pama' ku ma kaam: bang niya' duwangan min kaam mag-uyun ma dunya itu nambahayang ngamu'-ngamu' ayi-ayi, tantu du sigam hinangan uk 'Mma' ku ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sabab bang niya' duwangan atawa tallungan aa magtipun pagka ōn ku iya pamanyabutan sigam, ian du aku ma diyōman sigam.” ");
INSERT INTO slm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Puwas ian pahi' si Petros ni si Isa niyaw. “Tuwan Panghu',” uk na, “min pila subay ampun ku pagkahi ku bang iya ngandusa ni aku? Min pitu' baha'?” ");
INSERT INTO slm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Uk si Isa, “'Nsa' min pitu' sadja, suga' min pitumpu' maka pitu'.” ");
INSERT INTO slm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jari magparalilan si Isa, uk na, “In kapagparinta Tuhan sali' dalil dakayo' sultan iya baya' mista pautangan manga tindōg na. ");
INSERT INTO slm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sakali itu, pasalta' iya magbista utang, niya' biyo ni iya dakayo' tindōg na utang na laksaan pilak. ");
INSERT INTO slm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jari in sin ma tindōg ian 'nsa' makabayaran utang na, hangkan magpanohoan sultan in aa ian, sampay handa na maka manga anak na, subay piballihan hinang ata. Subay piballihan isab ayi-ayi na kamemon pamayad utang na. ");
INSERT INTO slm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na, pasujud magtuwi tindōg itu ma alōpan sultan ngamu' junjung ni iya. ‘O Ampun,’ uk na, ‘patangguhun le' aku. Bayaran ta du kau utang ku kamemon.’ ");
INSERT INTO slm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Manjari maase' sultan ian ma tindōg na. Piddahan uk sultan utang na bo' pipowe' iya. ");
INSERT INTO slm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na, pagluwas tindōg ian min alōpan sultan, niya' tabak na pagkahi na tindōg, bo' tindōg dakayo' itu taga utang diki' du ma iya. Magtuwi giyanggut uk na pagkahi na itu bo' pikkōl. Uk na, ‘Bayarin na utang nu ma aku.’ ");
INSERT INTO slm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Magtuwi pasujud pagkahi na itu nganjunjung, uk na, ‘Patangguhun le' aku. Bayaran ta kau.’ ");
INSERT INTO slm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Suga' 'nsa' matanggu. Gam peen iya jinil uk tindōg tagna' ian sataggōl 'nsa' kapuwasan uk na utang na kamemon. ");
INSERT INTO slm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pag'nda' peen uk tindōg kasehean ma kahinangan tindōg dakayo' ian, magtuwi paddi' akkal sigam. Pahi' sigam ni sultan ma' pasal ian hi' kamemon. ");
INSERT INTO slm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jari linganan uk sultan tindōg bayi ma heka utang na hi'. ‘Jahulaka' ko' kau iyu!’ uk na. ‘Bayi paddahan ku utang nu kamemon ma sabab panganjunjung nu ma aku. ");
INSERT INTO slm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Arapun isab bayi kaasean nu pagkahi nu hi', sali' bayi kaase' ku ma kau!’ ");
INSERT INTO slm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jari landu' ngandugal sultan ian ma iya, hangkan soho' na tindōg hi' subay jinil sampay tiksa' sataggōl 'nsa' le' kabayaran utang na.” ");
INSERT INTO slm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tiyambōl uk si Isa halling na, uk na, “Salaihi' du isab hinang 'Mma' ku ma diyōm sulga' ma kaam dangan maka dangan, bang 'nsa' ampun bi pagkahi bi sampay min diyōm atay bi.” ");
INSERT INTO slm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ubus peen pamissala si Isa salaihi', pakallo' iya min lahat Jalil tudju ni lahat Yahudiya, ni jadjahan na iya ma liyu sapa' Jordan. ");
INSERT INTO slm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Heka tōōd manga aa bayi me' ma iya, bo' kaulian uk na manga saki sigam may'an. ");
INSERT INTO slm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sakali niya' pay'an ni iya manga Parisi nulayan iya bo' supaya iya tasaggaw ma bissala na. Hangkan uk sigam ma iya, “Bang ma sara' tabi, makajari baha' bang lalla nimanan handa na, minsan ayi sababan na?” ");
INSERT INTO slm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nambung si Isa, uk na, “Angay? 'Nsa' bayi tabassa bi baha' iya tasulat ma diyōm kitab, iya uk na, ‘Ma tagna' pamapanjari Tuhan ma manusiya', bayi sigam pipanjari uk na lalla maka danda?’ ");
INSERT INTO slm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Uk Tuhan hi', ‘Hangkan na lalla pakallo' min 'nggo'-mma' na, bo' parakayo' ni handa na. Manjari in bayi duwa baran, tahinang dabaran na.’ ");
INSERT INTO slm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'Nsa' na sigam duwa baran,” uk si Isa, “suga' dabaran na sigam duwangan. Hangkan ko' subay 'nsa' pipagbutas uk manusiya' bang bayi pigdakayo' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tiyaw manga Parisi ma si Isa, uk sigam, “Na angay baha'? Bang ma pandu' si Musa, makajari lalla nimanan handa na bang peen niya' sulat na pagpasahan.” ");
INSERT INTO slm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iya sambung si Isa, “Iya hangkan kaam pirul uk si Musa nimanan handa bi, sabab alōd kaam piyanduan. Suga' 'nsa' salaihi' bayi ma waktu tagna'. ");
INSERT INTO slm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Baan ta kaam, sayi-sayi nimanan handa na ma 'nsa' du iya bayi maglalla, bo' maghanda iya saddi, magjina iya, taga dusa iya ma handa na poon.” ");
INSERT INTO slm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Uk manga mulid si Isa ma iya, “Bang salaihi' kahalan na ma aa maglakibini, hap le' subay 'nsa' magdakayo'.” ");
INSERT INTO slm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nambung si Isa, uk na, “Pandu' iyu 'nsa' tabōgbōg uk manusiya' kamemon, duwal sigam iya kabuwanan kōsōg uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Magginis isab sababan iya hangkan manga aa kasehean 'nsa' maghanda. Niya' aa 'nsa' makapaghanda sabab min kariyasali na. Niya' 'nsa' makapaghanda sabab kiyabili uk aa, maka niya' isab magniyat subay 'nsa' maghanda ma sabab pagparinta Tuhan sadja iya pikil uk na. Sayi-sayi makabōgbōg salaihi', subay be' na ma pandu' ku itu.” ");
INSERT INTO slm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na, niya' manga aa bayi mo onde'-onde' sigam ni si Isa bo' pabōtangan na tangan na ma sigam bo' iyampa sigam amuan na kahapan min Tuhan. Suga' aa mamo ian bayi pihallingan uk manga mulid si Isa. ");
INSERT INTO slm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Halling si Isa, “Parulun bi paitu ni aku manga onde'-onde' iyu. Daa langun bi. Sabab sayi-sayi makasali' kawul-piil na ni sali' onde'-onde' iyu, taga palsukuan du ma diyōman pagparinta Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jari pibōtang uk si Isa tangan na ni sigam ian. Puwas na hi' pakallo' iya minnihi'. ");
INSERT INTO slm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Manjari itu niya' dakayo' aa pahi' ni si Isa. Uk na, “Tuwan Guru, ayi hinang hap subay hinang ku bo' supaya aku kaniyaan kallum iya taptap ni kasaumulan?” ");
INSERT INTO slm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Uk si Isa, “Angay aku tīyaw nu bang ingga hap? Tunggal du Tuhan hap. Bang kau baya' pisukuan kallum taptap, subay bōgbōgan nu panohoan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tiyaw lalla itu, “Panohoan ingga?” uk na. Uk sambung si Isa, “Daa kau mapatay aa. Daa kau magjina. Daa kau nangkaw. Daa kau naksi' puting. ");
INSERT INTO slm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pag-addatin ina' nu maka 'mma' nu. Maka kalasahin pagkahi nu manusiya' sali' uk nu lasahan baran nu.” ");
INSERT INTO slm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Uk lalla magtuwi, “Bayi na kabōgbōgan ku ian hi' kamemon. Ayi le' subay hinang ku?” ");
INSERT INTO slm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Uk si Isa ma iya, “Bang kau baya' tubus hap addat-tabiat nu, pahi' kau, paballihin alta' nu kamemon bo' pamuwanun ballihan na ma manga aa miskin. Manjari niya' du karaya nu ma diyōm sulga'. Puwas na hi' paitu kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagtake aa ian ma bissala si Isa, magtuwi iya pakallo' maka uk na susa sabab landu' heka alta' na. ");
INSERT INTO slm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sakali halling si Isa ni manga mulid na, uk na, “Baan ta kaam tōōd, in aa dayahan kahunitan pasōd ni diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aho', baan ta kaam, kaluhayan le' hayōp unta' palabay min buwi' jawum min aa dayahan pasōd ni diyōm pagparintahan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Inu-inu tōōd manga mulid pagtake sigam ma bissala si Isa itu. “Bang salaihi',” uk sigam, “sayi baha' makasampay ni kasalamatan ma diyōm sulga'?” ");
INSERT INTO slm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Piyandang na uk si Isa manga mulid na hi', maka uk na nambung. Uk na, “Bang manusiya', 'nsa' tōōd makarapat. Suga' 'nsa' niya' hunit ma Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sakali halling si Petros, “'Ndaun ba kami itu.” uk na. “Bayi imbanan kami ayi-ayi kamemon bo' me' ma kau. Ayi baha' panungbas kami?” ");
INSERT INTO slm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Uk si Isa, “Baan ta kaam tōōd: in aku, Anak Manusiya', bang taabut na waktu kapaningko' ku ma diyōm kasahayahan, magkapag-agi du aku ma dunya bahu. Maka iya du kaam manga be'-bean ku. Pitingko' du kaam, pilangkaw, bo' kaam iya ngahukum ma sangpu' maka duwa bangsa kapanubuan si Israil. ");
INSERT INTO slm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sasuku bayi ngambanan luma' na atawa danakan na, atawa ina' na maka 'mma' na, atawa manga anak na, atawa tana' na, bang ihi' bayi libbahan uk na ma sabab katuyu' na ma aku, tiyungbasan du iya paheka uk Tuhan, lipat manglipat min bayi libbahan uk na. Maka kaniyaan du iya kallum taptap ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Suga' heka aa makarahu buttihi', piramuwi du ma waktu sosongun. Heka isab taramuwi ma buttihi', pirahu du ma waktu sosongun.” ");
INSERT INTO slm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Magparalilan si Isa, uk na, “In kapagparinta Tuhan sali' dalil aa dapu kabbun pananōman bahan anggul. Dayi' 'llaw peen, mangngan iya meha aa maghinang ma kabbun na. ");
INSERT INTO slm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Magsulut peen iya maka sigam in panamba sigam ma dangallaw subay sali' asal pagtambahan du, jari siyoho' sigam pahi' maghinang ma kabbun na. ");
INSERT INTO slm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Puwas na hi', taabut lisag siyam subu, pabayik iya ni pagtabuan, bo' niya' tanda' na may'an manga aa nangge-nangge. 'Nsa' niya' hinang sigam. ");
INSERT INTO slm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Uk na ma sigam, ‘Pahi' kaam isab maghinang ma kabbun ku hi'. Tiyambahan du kaam pila-pila iya katōngōran hinang bi.’ ");
INSERT INTO slm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na, hi' na sigam pahi'. Taabut lattu 'llaw, pahi' na isab aa dapu kabbun meha aa kasehean maghinang ma kabbun na. Salaihi' du isab hinang na taabut lisag tallu kohap. ");
INSERT INTO slm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jari itu, song peen lisag lima kohap, pabing iya ni pagtabuan, bo' niya' tanda' na manga aa nangge-nangge may'an. Uk na ma sigam, ‘Angay kaam nimpus da 'llaw 'nsa' maghinang?’ ");
INSERT INTO slm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Uk sambung sigam, ‘Tuud 'nsa' niya' noho' kami maghinang.’ ‘Na,’ uk aa dapu, ‘pahi' kaam maghinang ma kabbun ku hi'.’ ");
INSERT INTO slm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Manjari itu, pagsong kohap na, noho' aa dapu ni bayi mandulan na ian, uk na, ‘Linganin manga aa maghihinang iyu bo' tambahin. Parahuhun manga aa bayi takallo' ku damuwi iyu, bo' paramuwihun iya bayi takallo' ku dahu.’ ");
INSERT INTO slm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jari iya panamba sigam bayi makatagna' maghinang lisag lima kohap, magtōngōd du maka hinang dangallaw, minsan dayi'-dayi' du iya bayi pangahinang sigam. ");
INSERT INTO slm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na, taabut peen tiyambahan manga aa bayi takallo' subu-subu hi', iya pangannal sigam subay pisong panamba sigam. Lipara sali' du tambahan sigam, pipagtōngōd du maka hinang dangallaw. ");
INSERT INTO slm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagsambut peen tambahan sigam, pigdub-dub uk sigam aa dapu. ");
INSERT INTO slm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Uk sigam, ‘Angay itu? Manga aa bayi kallo' nu damuwi danjam du iya bayi pangahinang sigam. Bo' kami itu bayi nimpus min subu-subu sampay ni kakohapan, maghulas-sangsa' ma kapasuan 'llaw! Suga' minsan na, pipagsali' uk nu tambahan sigam maka tambahan kami.’ ");
INSERT INTO slm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Uk aa dapu kabbun ni dangan ian, ‘Bagay, 'nsa' kau bayi akkalan ku. Iya kapagsulutan ta tambahan pipagtōngōd maka hinang dangallaw. ");
INSERT INTO slm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, kalloun na tambahan nu itu bo' kau mowe'. Tuud kabayaan ku nambahan aa bayi takallo' ku damuwi sali' du maka bayi panamba ku kau. ");
INSERT INTO slm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Angay, 'nsa' niya' kapatut ku baha' magbaya' ma sin ku? Angay paddi' atay nu ma sawukat pagmura ku sin ku?’ ” ");
INSERT INTO slm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jari tiyambōl uk si Isa bissala na, uk na, “Hangkan na, sayi-sayi bayi taramuwi ma buttihi', pirahu du ma sosongun. Maka sayi-sayi makarahu ma buttihi', piramuwi du ma waktu sosongun.” ");
INSERT INTO slm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, patukad di si Isa tudju ni daira Awrusalam. Jari ma labayan peen, biyo uk si Isa mulid na sangpu' ka duwa pasaddi min aa kasehean bo' iyampa sigam bissalahan na. ");
INSERT INTO slm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Uk na, “Pake kaam. Tiya' kitabi patukad ni Awrusalam. Ma hi' peen kitabi, in aku, Anak Manusiya', siyongan du ni pangantanan kaimaman langkaw maka manga guru ma sara' agama. Pitakkahan aku uk sigam hukuman ni kamatay. ");
INSERT INTO slm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Puwas na hi' siyongan du aku ni pangantanan manga aa 'nsa' Yahudi, bo' pig-udju'-udju' du aku uk sigam. Piglapdōsan du aku bo' iyampa liyansang ni hag piyatay. Suga' taabut tallum bahangi min kamatay ku 'llum du aku pabayik.” ");
INSERT INTO slm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sakali pay'an ni si Isa handa si Sibidi magbe' maka anak na lalla duwangan, mulid si Isa min sangpu' ka duwa. Pasujud danda itu ma dahuhan si Isa ngamu' junjung. ");
INSERT INTO slm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tiyaw iya uk si Isa, uk na, “Ayi amu' nu?” Uk danda, “Bang taabut waktu kapagparinta nu, patingkoun kono' duwangan anak ku itu min karuwambiya' nu.” ");
INSERT INTO slm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nambung si Isa, uk na ni sigam, “'Nsa' katauhan bi bang ayi iya amu' bi iyu. Makasandal kaam baha' pinanaman kabinsanaan sali' paminsana' ma aku?” “Aho', makasandal du kami,” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Uk si Isa, “Asal makananam du kaam kabinsanaan sali' kabinsanaan iya song patakka ni aku. Suga' 'nsa' niya' kapatut ku mene' bang sayi pitingko' ma bihing ku ma sakap katau atawa sakap ni kayi. Suku' ko' ian manga aa iya tiyagamahan paningkoan ian uk 'Mma' ku Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Take peen uk manga sangpu' mulid kasehean pasal bayi iyamu' uk handa si Sibidi, magtuwi paddi' atay sigam ma duwangan magdanakan hi'. ");
INSERT INTO slm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hangkan sigam kamemon siyoho' uk si Isa patipun ni tōngōd na. Uk na, “Katauhan bi iya addat manga aa ma dunya itu. Iya ngantanan pagparinta ma bangsa kasehean ian magnakura' asal ma manga aa ma deyoan sigam. Iya du manga puntuk nakura' sigam, ngahagda asal ma sigam. ");
INSERT INTO slm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Suga' kaam iyu subay 'nsa' magsalaihi'. Sayi-sayi kaam baya' pilangkaw ma diyōman bi, subay magsosohoan ni kasehean. ");
INSERT INTO slm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sayi-sayi kaam baya' pilangkaw, subay magpaata ni pagkahi na nabangan sigam. ");
INSERT INTO slm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Subay kaam paanggil ni aku, Anak Manusiya',” uk si Isa. “Iya paitu ku ni dunya 'nsa' aku subay pighinangan uk manga manusiya', suga' sigam iya subay tabang ku. Paitu isab aku bo' paglilla' ku kallum ku pangalakkat ku manga aa heka min paldusahan sigam.” ");
INSERT INTO slm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Manjari sasang peen si Isa maka mulid na pakallo' min daira Ariha, heka aa bayi paturul ma iya. ");
INSERT INTO slm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sakali niya' may'an duwa lalla buta ningko' ma bihing daddōk palabayan sigam. Makatau peen manga buta itu in si Isa ian palabay, magtuwi sigam ngalingan pakōsōg. “O Tuwan, tubu' Sultan Daud!” uk sigam. “Maase' kau ma kami.” ");
INSERT INTO slm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pihallingan sigam uk baanan aa ian, daa siyoho' maghebok. Suga' pikōsōg gam peen pangalingan sigam, uk na, “O Tuwan! Tubu' si Daud! Maase' na kau ba!” ");
INSERT INTO slm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Parōhōng si Isa bo' iya ngalingan ni duwangan buta ian, uk na, “Ayi kabayaan bi hinang ku ma kaam?” ");
INSERT INTO slm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Tuwan,” uk sigam, “baya' kami makanda' pabayik.” ");
INSERT INTO slm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jari maase' si Isa ma sigam, bo' piabut uk na tangan na ni mata sigam. Saruun-duun du sigam makanda' pabayik bo' me' sigam paturul ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jari itu, sikōt peen di si Isa ni daira Awrusalam, bo' ma tōngōd Bud Kayu Jaitun na, taabut uk sigam kalumaan Betpage. Mahi' peen, siyoho' uk si Isa duwangan mulid na parahu min sigam. ");
INSERT INTO slm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Uk na, “Pahi' na kaam ni kalumaan ma dahuhan bi iyu. Pagtakka bi pay'an, makatawwa' du kaam kura' maka anak na ingkōtan may'an. Hubarin bi bo' bohun bi paitu. ");
INSERT INTO slm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bang niya' ganta' niyaw ma kaam bang angay kallo' bi, bain bi salaitu. Uk bi, ‘Tuud pagguna uk nakura',’ jari pisaran du kaam uk na magtuwi.” ");
INSERT INTO slm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Piniya' salaihi' bo' magtanda' iya bayi pigpalatun uk dakayo' nabi, iya uk na, ");
INSERT INTO slm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bain bi manga aa Awrusalam, Iyu na sultan bi takka ni kaam Deyo' pag-atay na, Ngura' iya ma anak kura'.” ");
INSERT INTO slm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na, pahi' duwangan mulid hi', maka hinang uk sigam iya bayi panohoan si Isa. ");
INSERT INTO slm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Biyo uk sigam kura' maka anak na, liyampikan maka badju' sigam bo' iyampa panguraan uk si Isa. ");
INSERT INTO slm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ngura' peen si Isa, landu' heka aa bayi mallat sammek sigam ma daddōk palabayan na. Manga aa kasehean bayi nabulakan pay'an manga engas-engas dawunan bayi liyabasan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Manjari baanan manga aa ian, iya mangngan min dahuhan si Isa sampay sigam paturul min buwian na, mag-ōlang sama-sama. Uk na hi', “Mahaldika' ni tubu' Sultan Daud! Bang peen biyarakatan iya kawakilan uk Tuhan paitu! Sanglitan tabi Tuhan Mahatinggi!” ");
INSERT INTO slm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Manjari pagtakka si Isa ni diyōm Awrusalam, hiluhala' diyōm daira ian kamemon. Uk manga aa may'an, “Sayi baha' aa iyu?” ");
INSERT INTO slm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nambung baanan aa, uk sigam, “Si Isa ko' itu, nabi min Nasaret ma lahat Jalil.” ");
INSERT INTO slm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sakali itu pasōd si Isa ni diyōm langgal pagkulbanan bo' iyampa pipowe' uk na sasuku maglitu maka magdagang may'an. Biyaliskat uk na lamisahan manga aa magsambian sin bangsa liyu ni sin Yahudi. Iya du biyaliskat uk na paningkoan manga aa magdagang assang pagkulban. ");
INSERT INTO slm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uk si Isa ni manga aa ian, “Tasulat asal ma diyōm kitab bayi pilatun uk Tuhan, iya uk na, ‘Luma' ku itu iyōnan du luma' pagsambahayangan manga aa.’ Suga' tahinang bi na sali' luma' panapukan mundu.” ");
INSERT INTO slm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","May'an le' si Isa ma diyōm langgal, pay'an ni iya manga aa buta maka aa pengka' bo' pikowe' sigam uk na. ");
INSERT INTO slm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Suga' ngandugal manga kaimaman langkaw maka manga guru ma sara' agama, pag'nda' sigam ma hinang si Isa makainu-inu ian, maka pagtake sigam ma manga onde' mag-ōlang ma diyōm langgal, iya uk sigam, “Mahaldika' ni tubu' Sultan Daud!” ");
INSERT INTO slm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jari halling manga nakura' ian ni si Isa, uk sigam, “Take nu baha' iya pihalling itu uk manga onde'-onde'?” “Aho',” uk si Isa. “Angay? 'Nsa' bayi tabassa bi baha' iya tasulat ma diyōm kitab, iya uk na, ‘Minsan kaondean piyanduan asal muwan sanglit ni Tuhan?’ ” ");
INSERT INTO slm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Puwas na hi' pakallo' si Isa min sigam bo' paluwas min daira tudju ni kalumaan Betani. Pahanti' iya ma hi' sampay ni kasawungan. ");
INSERT INTO slm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkallat 'llaw, ma labayan peen si Isa tudju ni Awrusalam pabing, giyōtas iya. ");
INSERT INTO slm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tanda' na dakayo' kayu igira ma bihing daddōk, suga' pagpahi' na, 'nsa' niya' buwa' igira tatawwa' na may'an, duwal sadja dawun na. Jari siyuknaan uk si Isa kayu ian, uk na, “Puwas minnitu, kayu itu 'nsa' tōōd magbuwa' pabing.” Magtuwi lanōs kayu ian. ");
INSERT INTO slm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pag'nda' manga mulid na, inu-inu sigam. “Alla,” uk sigam, “angay kayu igira itu lanōs magtuwi?” ");
INSERT INTO slm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Na, baan ta kaam tōōd,” uk si Isa, “bang kaam mangandōl tōōd ma 'nsa' niya' hawal-hawal ma diyōm atay bi, makahinang du kaam sali' bayi hinang ku ma kayu igira itu. Maka 'nsa' ihi' sadja iya tahinang uk bi. Minsan bud ian, bang soho' bi pakallo' min tōngōd na bo' pabōtang ni diyōm sallang, tantu du me'. ");
INSERT INTO slm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Basta kaam mangandōl, tasambut bi du ayi-ayi pangamu'-ngamu' bi ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jari pabing na si Isa ni diyōm langgal pagkulbanan bo' iyampa mandu'. Sabu na peen mandu', pay'an ni iya manga kaimaman langkaw maka manga kamaasan Yahudi. Uk sigam, “Ayi kapatut nu maghinang salaiyu? Sayi bayi muwanan kau kapatutan?” ");
INSERT INTO slm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nambung si Isa, uk na, “Niya' dakayo' paniyaw ku ma kaam dahu. Bang itu sambungan bi, baan ta du kaam bang ayi kapatut ku maghinang salaitu. ");
INSERT INTO slm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iya bayi kapatut si Yahiya magpandi manga aa, kapatut min Tuhan baha' atawa min manusiya' sadja?” Na, mag-isun-isun sigam, uk sigam, “Bang sawupama uk ta in kapatut si Yahiya ian bayi min Tuhan, tiyaw du kitabi uk na bang angay kitabi 'nsa' bayi magkahagad ma si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Suga' bang uk ta in kapatut si Yahiya ian min manusiya' sadja, na piligdu kitabi. Sabab manga baanan aa itu magkahagad kamemon in si Yahiya nabi du min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hangkan salaitu iya panambung manga nakura' hi' ma tīyaw si Isa, uk na, “'Nsa' katauhan kami.” “Na,” uk si Isa, “iya du aku 'nsa' ma' ma kaam bang minningga iya kapatut ku maghinang manga hinang ku itu.” ");
INSERT INTO slm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Missala si Isa, uk na, “Pikilun bi paralilan ku itu. Niya' aa duwa anak na lalla. Na, pahi' aa itu ni anak na siyaka, uk na, ‘Oto', pahi' kau 'llaw itu maghinang ma kabbun.’ ");
INSERT INTO slm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uk sambung siyaka hi', ‘'Nsa' aku.’ Lipara pinda pikilan na bo' pahi' iya ni kabbun maghinang. ");
INSERT INTO slm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jari pahi' na aa itu ni anak na siyay, noho' iya pahi' sali' bayi panohoan na ma siyaka. ‘Aho', 'Mma',’ uk sambung siyay. Suga' 'nsa' iya bayi pahi'. ");
INSERT INTO slm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na,” uk si Isa ni manga aa ian, “bang ma kaam, sayi iya bayi me' ma kabayaan 'mma' na?” “Iya anak siyaka,” uk sambung sigam. “Baan ta kaam tōōd,” uk si Isa, “manga aa dusahan, iya sali' manga aa magkallo' sukay parinta maka manga danda laat, parahu sigam min kaam me' ma pagparinta Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sabab si Yahiya Magpapandi bayi paiyu ni kaam matauhan kaam bang ingga iya daddōk bōntōl, suga' 'nsa' iya kahagad bi. Malayingkan manga aa magkallo' sukay parinta maka manga danda laat, bayi du magkahagad. Maka minsan bayi tanda' bi ian hi', 'nsa' du bayi pinda pikilan bi bo' iyampa kaam magkahagad ma si Yahiya.” ");
INSERT INTO slm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pake kaam ni paralilan dakayo' itu,” uk si Isa. “Niya' dakayo' aa taga tana' bayi nanōm bahan anggul ma kabbun na. Bayi libut uk na maka ad. Kiyali uk na lowang paggipitan buwa' anggul, pangalloan bohe' na, maka hinang uk na dakayo' bawung-bawung langkaw pamantawan. Puwas na hi' pitungguan uk na kabbun ian ma manga aa magtutunggu', bo' iyampa iya pakallo' ni lahat saddi. ");
INSERT INTO slm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Taabut peen musim pagpusu' buwa' anggul, siyoho' uk aa dapu kabbun itu manga sosohoan na pahi' ni manga magtutunggu' ngallo' bahagi' na. ");
INSERT INTO slm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Suga' pagtakka pahi' manga sosohoan hi', siyaggaw sigam uk aa magtutunggu'. Dakayo' sosohoan ian bayi liyapdōsan uk sigam, dakayo' bayi piyatay, dakayo' isab bayi pighiyak maka batu. ");
INSERT INTO slm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Puwas na hi' noho' na isab aa dapu manga sosohoan saddi pahi', heka le' min bayi dahu. Iya du sigam bayi liyaat uk manga tunggu', sali' bayi pangalaat sigam ma sosohoan tagna'. ");
INSERT INTO slm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na, ma damuwi katapusan bayi soho' na pahi' anak na lalla. Uk na ma diyōm pikilan na, ‘Tantu pig-addatan anak ku uk manga tunggu' hi'.’ ");
INSERT INTO slm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Suga' pag'nda' manga tunggu' ma anak aa kabbun itu, magtuwi sigam mag-isun. Uk pag-isun sigam, ‘Iya na ko' iyu anak aa dapu. Sung kitabi, piyatay uk tabi na iya bo' takallo' tabi tana' na.’ ");
INSERT INTO slm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Manjari siyaggaw uk sigam anak aa dapu. Timanan iya ma luwasan min kabbun, bo' iyampa biyono'. ");
INSERT INTO slm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na,” uk si Isa, “bang takka aa dapu kabbun pahi', ayi baha' hinang na ma manga aa magtutunggu'?” ");
INSERT INTO slm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nambung sigam, uk na, “Tantu piyatay uk na manga tunggu' laat ian. Bo' pitungguan uk na kabbun na ma aa saddi, iya baya' muwan bahagi' palsukuan na bang taabut musim na.” ");
INSERT INTO slm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Uk si Isa ni sigam, “'Nsa' bayi tabassa bi baha' diyōm kitab? Uk na hi', ‘Iya batu bayi siyulak uk aa maghinang luma', biya' 'nsa' niya' guna na, Iya na ian batu mehe tōōd kalagihan na. Hinang Tuhan ko' ian, hap makalandu' ma panganda' kami.’ ");
INSERT INTO slm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hangkan na kaam baan ku,” uk si Isa, “killoan du min kaam bayi palsukuan bi ma diyōm pagparintahan Tuhan, pinda min kaam ni bangsa aa saddi. Jari sigam iya maluwas kahapan du, iya tōp ma pagparintahan Tuhan.  ");
INSERT INTO slm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sasuku hug ni batu itu tumu-tumu du baran na. Maka sasuku kahugan batu itu pipis du kamemon na.” ");
INSERT INTO slm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagtake uk manga kaimaman langkaw maka uk Parisi iya bayi pamaralil uk si Isa itu, magtuwi sigam makasayu sigam du iya piandigan uk na. ");
INSERT INTO slm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hangkan sigam arak naggaw si Isa, suga' 'nsa' kalanjal. Tiyāw asal sigam ma kahekahan aa ian sabab si Isa ian nabi tōōd bang ma bistahan sigam. ");
INSERT INTO slm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Manjari magparalilan isab si Isa ma kahekahan aa ian. ");
INSERT INTO slm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“In kapagparinta Tuhan,” uk na, “sali' dalil dakayo' sultan bayi magsakap ma pagjamu ma waktu kapagkawin anak na lalla. ");
INSERT INTO slm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Siyoho' uk sultan manga sosohoan na matauhan manga aa iya bayi killo'. Suga' aa bayi killo' ian 'nsa' baya' paluruk. ");
INSERT INTO slm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hangkan soho' na manga sosohoan saddi, uk na, ‘Bain bi manga aa bayi killo' ian in pagjamu ku sakap na. Bayi na siyumbay manga sapi' lalla maka manga anak sapi' lammōk. Sakap na kamemon. Sohoun sigam paluruk na ni pagkawinan.’ ");
INSERT INTO slm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Suga' 'nsa' ngasip manga aa bayi killo' ian. Iya sadja kiyannal uk sigam pag-usaha sigam. Dangan ian pahi' ni huma na maghinang, dangan pahi' ni tinda na. ");
INSERT INTO slm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kasehean isab bayi naggaw manga sosohoan sultan ian bo' iyampa liyapdōsan uk sigam maka piyatay. ");
INSERT INTO slm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pagtau peen sultan, landu' iya ngandugal hangkan soho' na manga sundalu na pahi' mapatay manga pamomono' hi'. Siyoho' isab tiyutung paglahatan sigam. ");
INSERT INTO slm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Puwas na hi' linganan uk sultan manga sosohoan na, uk na, ‘Sakap na jamu pagkawin suga' manga aa bayi killo' uk ku dahu hi' 'nsa' na tōp paluruk. ");
INSERT INTO slm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na pahi' kaam ni daddōk paglalabayan aa heka, bo' sasuku talanggal bi ma hi' sohoun bi paluruk ni pagjamuhan itu.’ ");
INSERT INTO slm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jari pahi' na manga sosohoan hi' ni karaddōk-daddōkan. Pitipun uk sigam sasuku talanggal uk sigam, manga aa laat maka aa hap. Jari in luma' pagkawinan hi' panno' na uk aa. ");
INSERT INTO slm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sakali itu, makasōd peen sultan pahi' nganda' ma manga luruk, niya' tanda' na may'an dakayo' aa makay sammek 'nsa' tōp ma pagkawinan. ");
INSERT INTO slm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Uk sultan ni aa itu, ‘Bagay, salaingga kasōd nu paitu ma 'nsa' niya' sammek nu tōp paluruk nu ni pagkawinan?’ Suga' 'nsa' nambung aa ian. ");
INSERT INTO slm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sakali halling sultan ni manga sosohoan na, uk na, ‘Ingkōtin bi aa itu nayi'-tangan na, bo' larukin bi iya pahi' ni diyōm kalindōman. Magtangis du manga aa may'an maka magtagiōt baggaang sigam.’ ");
INSERT INTO slm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Sabab na,” uk si Isa, “heka aa killo' me' ma kapagparinta Tuhan, suga' datti' du sigam pene'.” ");
INSERT INTO slm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Manjari itu paluwas manga Parisi minnihi' bo' mag-isun-isun bang salaingga uk sigam naggaw si Isa ma bissala na. ");
INSERT INTO slm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Puwas na hi' niya' manga mulid sigam maka manga sehean si Herod siyoho' uk sigam pahi' ni si Isa. “Tuwan guru,” uk sigam ma iya, “katauhan kami in kau pote' asal atay nu. Bannal sadja pamandu' nu pasal kawul-piil iya kibayaan uk Tuhan. 'Nsa' du kau tiyāw siyaway uk sayi-sayi, sabab sali' du bohan nu ma aa kamemon. ");
INSERT INTO slm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na, bain kami kono' bang ayi pikilan nu pasal itu hi': bang kita ganta' mayad sukay ni parinta Roma, iya deyo' min Sultan Mahatinggi hi', langgal ta baha' sara' agama tabi?” ");
INSERT INTO slm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Suga' kitauhan asal uk si Isa niya' kalaatan miyaksud uk sigam, hangkan uk na ni sigam, “Kaam iyu magbawu'-bawu' sadja tiyaw salaiyu. Tuud kaam baya' naggaw ma aku ma panambung ku. ");
INSERT INTO slm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pandain kono' aku sin, iya pamayad sukay parinta.” Jari biyohan iya sin pilak. ");
INSERT INTO slm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Uk si Isa ma sigam, “Patta' sayi maka ōn sayi ma sin itu?” ");
INSERT INTO slm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Patta' Sultan Mahatinggi maka sulat na,” uk sambung sigam. “Na,” uk si Isa, “pagka suku' sultan ko' itu, pamayarun bi ni iya. Damikkiyan na, bang niya' ayi-ayi suku' Tuhan, ungsurin bi isab ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagtake manga aa ian ma panambung si Isa itu, magtuwi sigam inu-inu bo' ngalabba sigam min iya bo' iyampa pakallo' minnihi'. ");
INSERT INTO slm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na, ma 'llaw hi' niya' pay'an ni si Isa manga aa Saddusi, daginis agama Yahudi iya uk na 'nsa' niya' 'llum pabing ma 'llaw damuwi. ");
INSERT INTO slm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tiyaw sigam ma si Isa. “Tuwan guru,” uk sigam, “niya' sara' bayi min si Musa pasal aa bang matay ma 'nsa' taga tubu'. In balu na subay killo' handa uk siyay na bo' supaya niya' anak bista tubu' min aa bayi matay hi'. ");
INSERT INTO slm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na,” uk sigam, “niya' bayi ma lahat kami pitu' lalla magdanakan. Taga handa siyaka hi', suga' matay na lalla. Pagka 'nsa' niya' tubu' na, balu na bayi takallo' hinda uk siyay pasunu'. ");
INSERT INTO slm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Suga' iya du siyay itu, bayi matay ma 'nsa' taga tubu'. Damikkiyan na isab siyay pasunu'. Papuut ta na, in pitu' magdanakan bayi makahanda ni dakayo' danda hi', bo' matay sigam kamemon ma 'nsa' taga anak. ");
INSERT INTO slm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma katapusan na matay isab danda. ");
INSERT INTO slm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, Tuwan,” uk sigam, “bang taabut 'llaw pagpakallum pabayik manga aa magpatayan, handa sayi baha' danda hi'? Sabab bayi iya takallo' hinda uk sigam kapitu' magdanakan.” ");
INSERT INTO slm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nambung si Isa ma sigam, uk na, “Sā' kaam, sabab 'nsa' katauhan bi bang ayi ma diyōm kitab, maka 'nsa' katauhan bi kōsōg kawasa Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sabab bang taabut waktu kallum pabing min kamatay, in manusiya' makasali' du ni bangsa malaikat ma diyōm sulga'. 'Nsa' na sigam maghanda-maghalla. ");
INSERT INTO slm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Iya pasal isab manga aa pikallum pabing min kamatay, kila ku 'nsa' tabassa bi bayi pamalman Tuhan ma kaam. ");
INSERT INTO slm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Uk na, ‘Aku iya Tuhan di si Ibrahim, si Isahak maka si Ya'kub.’ Hati na,” uk si Isa, “in Tuhan itu pagtuhanan asal uk manga aa 'llum, 'nsa' uk aa magpatayan.” (Hati na masi 'llum di si Ibrahim ian ma diyōm ahirat minsan taggōl na kamatay ginhawa-baran sigam.) ");
INSERT INTO slm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Makake peen kahekahan aa ian ma bissala si Isa, landu' sigam inu-inu. ");
INSERT INTO slm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sakali itu, pagtake manga Parisi in manga Saddusi hi' 'nsa' makasambung ni si Isa, pay'an sigam patipun ni iya. ");
INSERT INTO slm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Niya' min sigam dakayo' guru ma sara' agama bayi tiyaw ma si Isa, kalu tasaggaw ma panambung na. ");
INSERT INTO slm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Uk na ni si Isa, “Tuwan Guru, ma sara' agama, ingga iya panohoan halgaan min kamemon?” ");
INSERT INTO slm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Uk sambung si Isa, “Wajib kaam lasa tōōd ma Panghu' bi Tuhan. Iya lasa bi ma iya subay min diyōm atay bi maka min diyōm ginhawa-baran bi maka min panahuhan bi. ");
INSERT INTO slm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iya na ko' hi' panohoan umbul satu, halgaan min kamemon. ");
INSERT INTO slm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Maka iya na itu panohoan karuwa na, halgaan isab. Uk na, wajib kaam lasahan pagkahi bi manusiya' sali' uk bi lasahan baran bi. ");
INSERT INTO slm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iya panohoan kamemon bayi pangamban uk si Musa, sampay pamandu' manga nabi, paluwas asal min duwa panohoan bayi sambat ku itu.” ");
INSERT INTO slm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na, pagka patipun may'an manga Parisi, niya' tiyaw uk si Isa ma sigam. ");
INSERT INTO slm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Uk na, “Ayi pikilan bi pasal si Almasi? Tubu' iya min sayi?” Uk sambung sigam, “Tubu' sultan Daud.” ");
INSERT INTO slm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Na bang salaihi',” uk si Isa, “angay hangkan si Daud bayi ngōn ‘Panghu'’ ma si Almasi, waktu kapagbaya' Nyawa Sutsi ma iya? Salaitu asal bayi pilatun uk si Daud hi', ");
INSERT INTO slm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bayi ngabtang Tuhan ni Panghu' ku, uk na, Dayi' kau, ningko' kau ma bihing ku sakap ni katau, Bo' bo ku palbantahan nu tatawu' ma deyo' pat-nayi' nu.’” ");
INSERT INTO slm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Na,” uk si Isa, “pagka si Almasi iyōnan Panghu' uk si Sultan Daud, tantu iya 'nsa' panubu' si Daud sadja.” ");
INSERT INTO slm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Suga' 'nsa' niya' aa may'an makapanambung ma si Isa minsan dakabtang panambung na. Puwas min 'llaw hi' 'nsa' niya' makatawakkal niyaw iya ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Manjari halling si Isa ni baanan aa maka ni manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Uk na, “Manga guru ma sara' agama maka manga Parisi, niya' kapatut sigam manduan aa pasal manga sara' si Musa. ");
INSERT INTO slm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hangkan subay be' bi ayi-ayi pamandu' sigam. Subay asip bi pamissala sigam pahap-hap. Suga' daa singōrin bi kahinangan sigam, sabab 'nsa' tabe' uk sigam iya bayi pamandu' sigam ma aa kasehean. ");
INSERT INTO slm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pibohat uk sigam panohoan iya pamatanggung sigam ma manga aa kasehean, parahal 'nsa' baya' nabang ma manga aa ian, minsan laa tabang diki'. ");
INSERT INTO slm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ayi-ayi hinang uk manga Parisi maka manga guru hi' subay ma pangandaan kahekahan aa. 'Ndaun bi kaehe puyu'-puyu' pangalōōnan ayat kitab iya pikkōs ma tuktuk maka ma langngōn sigam. 'Ndaun bi isab juba sigam, iya taha' jambay na. ");
INSERT INTO slm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bang sigam ganta' ma pagjamuhan, baya' sigam subay pitingko' ma paningkoan bangsahan. Iya du bang sigam ma diyōm langgal, subay paningkoan iya tiyawuan aa langkaw. ");
INSERT INTO slm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Baya' sigam hiyulmat bang ma mayiran, baya' isab sigam siyabbut ‘Tuwan Guru’. ");
INSERT INTO slm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Suga' kaam iyu, subay kaam 'nsa' meha pig-ōnan ‘Tuwan Guru’ uk pagkahi bi, sabab sali'-sali' du kaam magdawuranakan kamemon, maka dakayo' du guru bi tōōd. ");
INSERT INTO slm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Daa panabbutin bi ‘'Mma'’ sayi-sayi ma diyōm dunya itu, sabab dakayo' du pag'mmaan bi, iya Tuhan ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Daa kaam baya' iyōnan nakura', sabab tunggal si Almasi pagnakuraan bi. ");
INSERT INTO slm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sayi-sayi baya' langkaw ma diyōman bi, subay iya magpaata ma kasehean na. ");
INSERT INTO slm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sayi-sayi magpalangkaw ma baran na, pireyo' du iya, maka sayi-sayi mareyo' di na pilangkaw du isab. ");
INSERT INTO slm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Makaase'-ase' tōōd iya pamakadal kaam iyu, manga guru ma sara' agama maka manga Parisi!” uk si Isa. “Magbawu'-bawu' sadja kaam in kaam hap addat bi. Suga' tiyambōlan uk bi manga aa bo' supaya sigam 'nsa' makasōd ni diyōm pagparintahan Tuhan. Kaam baran bi iyu 'nsa' baya' pasōd pay'an, iya poon lāng bi sasuku baya' pasōd.  ");
INSERT INTO slm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Makaase'-ase' tōōd iya pamakadal kaam, manga guru ma sara' agama maka manga Parisi, iya magbawu'-bawu' in kaam hap! Nyanyaya uk bi manga danda balu bo' takallo' bi luma' sigam, bo' pitaha' uk bi panambahayang bi paglaku-laku bi in kaam bal-iman, bahasa tiyapukan kahinangan bi malaat hi'. Hangkan du pikalap kabinsanaan ma kaam ma ahirat. ");
INSERT INTO slm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Makaase'-ase' tōōd iya pamakadal kaam, manga guru maka manga Parisi! Magbawu'-bawu' sadja in kaam hap addat bi! Tuyu' kaam masaplag pandu' bi, iya hangkan lintasan bi de-deyawut bang peen niya' tabo bi me' ma pandu' bi minsan laa dakayo' aa sadja. Bo' bang niya' ganta' makabe', kalap le' iya min kaam palgantaan nalka', ma sabab pamandu' bi iya pamean na. ");
INSERT INTO slm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makaase'-ase' tōōd iya pamakadal kaam! Sali' kaam sapantun buta ngambit ma pagkahi bi. Uk pamandu' bi, bang niya' nganjanji' bo' sabbut na langgal pagkulbanan palsaksian janji' na, 'nsa' du niya' dusa na kono' minsan 'nsa' tuman na janji' na hi'. Suga' bang kapanyapan bulawan ma diyōm langgal iya panabbutan na, wajib kono' subay tuman na tōōd. ");
INSERT INTO slm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sā' pahap pikilan bi, sali' buta mata bi! Langgal ian asal pangaharapan Tuhan, hangkan uk ta sutsi kapanyapan na. ");
INSERT INTO slm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Uk isab pamandu' bi dakayo', sayi-sayi nabbut tōngōd pagkulbanan palsaksian janji' na, makajari minsan 'nsa' tiyuman janji' na. Suga' bang panabbutan na ayi-ayi tiyukbalan ni Tuhan ma diyata' pagkulbanan hi', in janji' na kono' wajib subay tiyuman tōōd. ");
INSERT INTO slm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sā' pahap pikilan bi! Ingga mehe guna na, iya ayi-ayi tiyukbalan ma diyata' pagkulbanan, atawa pagkulbanan sutsi, iya makabuwan kasutsihan isab ma tutukbalan hi'? ");
INSERT INTO slm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hangkan na, bang niya' aa ganta' nabbut pagkulbanan, panabbutan na isab kamemon iya tiyukbalan ni Tuhan may'an. ");
INSERT INTO slm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Damikkiyan na, bang niya' nabbut langgal pagkulbanan, panabbutan na isab Tuhan iya pabōtang asal may'an. ");
INSERT INTO slm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bang niya' nabbut sulga', panabbutan na isab paningkoan Tuhan maka panabbutan na isab mismu Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Makaase'-ase' tōōd iya pamakadal kaam, manga guru sara' maka manga Parisi! Magbawu'-bawu' kaam in kaam hap addat bi. Tuyu' tōōd kaam ngungsud ni Tuhan bahagi' sangpu' min ayi-ayi bi kamemon, minsan laa ginisan sayul-sayul sadja iya pamapa bi kiyakan. Hap isab kapangungsud bi salaihi', daa subay labbahan. Suga' iya panohoan halga' min kamemon 'nsa' kabōgbōgan bi. 'Nsa' kaam adil, 'nsa' kaam maase' ma pagkahi bi, 'nsa' kaam tapangandōlan. Arapun iyu hi' panuyuan bi tōōd, dahu min kamemon. ");
INSERT INTO slm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sali' kaam aa buta ngambit ma kasehean. Iya panuyuan bi manga panohoan kulang halga' na, bo' panohoan halgaan tōōd 'nsa' du guna bi. Sali' kaam sapantun aa ngayak inuman na bo' 'nsa' makainum hamud-hamud, parahal tatallōn na unta' ma katibuukan na. ");
INSERT INTO slm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Makaase'-ase' tōōd iya pamakadal kaam, manga guru maka manga Parisi! Magbawu'-bawu' kaam in kaam hap addat bi. Sali' kaam sapantun sawan maka layi. Kiyosean uk bi luwasan na suga' lammi' diyōm na sabab panno' uk pangalangpas bi maka pagnapsu bi kalaatan. ");
INSERT INTO slm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kaam manga Parisi, sā' pahap pikilan bi! Lanuin bi dahu iya ma diyōm iyu bo' iyampa lanu' sampay luwasan na. ");
INSERT INTO slm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Makaase'-ase' tōōd iya pamakadal kaam, manga guru maka manga Parisi! Magbawu'-bawu' kaam in kaam hap addat bi. Sali' kaam sapantun kubul bayi pinta pote' luwasan na bo' hap inda', suga' diyōm na duwal bōkōg mayat maka kahaluan. ");
INSERT INTO slm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Salaihi' du isab hantang bi. Bang dagbōs bi tanda' uk aa, hap du, suga' diyōm atay bi iyu panno' uk pagbawu'-bawu' bi maka kalaatan bi.” ");
INSERT INTO slm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Makaase'-ase' iya pamakadal kaam, manga guru maka manga Parisi! Magbawu'-bawu' kaam in kaam hap addat bi. Tahinang bi tampat ma kanabi-nabihan, tapaalti bi manga kubul bayi pangubulan aa kaadilan. ");
INSERT INTO slm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bo' uk bi, ‘Bang bayi kami 'llum ma waktu ka'mboan kami hi', 'nsa' du kami bayi palamud ma hinang manga aa kasehean, waktu kapamapatay sigam ma manga nabi hi'.’ ");
INSERT INTO slm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na,” uk si Isa, “pagka salaiyu halling bi, magpasabannal du kaam in kaam panubu' du min manga aa bayi mono' kanabihan hi'. ");
INSERT INTO slm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pahiun bi na, talusun bi iya bayi tiyagnaan uk ka'mboan bi. ");
INSERT INTO slm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'Nsa' tasipat laat bi! 'Nsa' du niya' kahōwatan bi papuwas min hukuman nalka'. ");
INSERT INTO slm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Baan ta kaam, papaiyu ku du ni kaam manga nabi, manga aa bal-akkal, maka manga guru. Bono' bi du sigam kasehean. Sigam kasehean lansang bi du ni hag piyatay, kasehean liyapdōsan uk bi ma diyōm langgal, maka kasehean apas bi du min kalumaan dakayo' ni dakayo'. ");
INSERT INTO slm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hangkan kaam pitakkahan hukuman du, ma sabab pamapatay bi ma manga aa 'nsa' taga dusa, tiyagnaan min si Habil anak si 'Mbo' Adam, sampay ni si Jakariya anak si Baraki. Si Jakariya hi' bayi piyatay uk bangsa bi ma ōtan langgal maka tōngōd pagkulbanan. ");
INSERT INTO slm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Baan ta kaam tōōd, kaam ma ahil jaman itu pamatanggungan du karusahan manga aa ian kamemon.” ");
INSERT INTO slm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Magkarukkaan si Isa ma pasal manga aa ma daira Awrusalam, hangkan uk na, “'Ndu'! Kaam manga aa Awrusalam, makasusa ko' kaam iyu! Manga nabi min Tuhan piyatay uk bi sadja. Manga sosohoan Tuhan iya hiyak bi sadja maka batu bang papaiyu ni kaam. Min pila aku bayi baya' nipun kaam ma aku, sali' sapantun manuk danda bang ngōman anak-anak na ma deyo' pikpik na. Suga' 'nsa' kaam baya'. ");
INSERT INTO slm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","'Ndaun bi na, siya-siya lahat bi uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Baan ta kaam, song aku 'nsa' tanda' bi, sataggōl 'nsa' taabut waktu pananglit bi aku. Subay uk bi, ‘Bang peen biyarakatan iya pipaitu kawakilan uk Tuhan,’ bo' iyampa aku tanda' bi.” ");
INSERT INTO slm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Manjari itu, makaluwas peen si Isa min langgal pagkulbanan, pasikōt ni iya manga mulid na nudlu' hinangan langgal hi'. ");
INSERT INTO slm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Aho',” uk si Isa. “'Ndaun bi na pahap. Suga' baan ta kaam, ma sosongun in langgal itu lubu du. 'Nsa' du niya' batu na ngapin magbangkat, kiyanat du kamemon.” ");
INSERT INTO slm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Puwas na hi', ningko' peen si Isa ma hi' ma Bud Jaitun, pahi' ni iya manga mulid na, sigam-sigam sadja. Uk sigam, “Pahatihun kono' kami bang umay paniya' iya bayi uk nu sini', maka bang paltandaan ayi piluwas bo' kitauhan in kapaitu nu sikōt na, maka dunya itu song kiyamat na?” ");
INSERT INTO slm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nambung si Isa, uk na, “Kamaya'-maya' kaam bo' kaam 'nsa' kaakkalan. ");
INSERT INTO slm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabab ma sosongun heka paitu nabbut ōn ku, maglaku-laku in sigam si Almasi na, bo' heka tabo-bo iyakkalan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makake du kaam pasal pagbono' ma kasikōtan. Makake kaam isab hunub-hunub pasal pagbono' ma lahat saddi. Suga' daa kaam tiyāw. Tantu paniya' pagbono' suga' 'nsa' le' ian hi' 'llaw kiyamat. ");
INSERT INTO slm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magbono' du bangsa dakayo' maka dakayo', parinta dakayo' isab maka parinta dakayo'. Paniya' du isab gōtōm ma sabarang lahat, maka linug ma kalohahan dunya. ");
INSERT INTO slm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Suga' in bala' kamemon itu tagnaan na sadja, sali' dalil danda battōng bang iyampa tananam na paddi' song nganak. ");
INSERT INTO slm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bang taabut waktu ian hi' siyaggaw du kaam, tiyukbalan ni aa kasehean bo' supaya kaam binsana' sampay piyatay. Kibansihan du kaam uk aa kamemon ma sabab pame' bi ma aku. ");
INSERT INTO slm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Heka isab aa bayi bean ku ngalabba du min pag-iman sigam ma waktu ian hi'. Heka sigam bansihan sehe' sigam du, heka isab numbung sehe' sigam ni banta sigam bo' siyaggaw. ");
INSERT INTO slm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Heka ian maglaku-laku in sigam nabi min Tuhan, bo' heka aa kaakkalan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mamarahi pahap kalaatan ma diyōm dunya ma waktu siyong ian, iya poon kahekahan manusiya' 'nsa' na kasi-lasa ma pagkahi na. ");
INSERT INTO slm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Suga' lappasan du sayi-sayi hōgōt iman na sampay napusan kabinsanaan ian. ");
INSERT INTO slm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maka lapal hap itu pasal kapagparinta Tuhan, pignasihat du ma kalohahan dunya supaya kitauhan uk aa kamemon. Puwas na hi' kiyamat na dunya.” ");
INSERT INTO slm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bayi na pilatun asal uk si Nabi Daniyel ma pasal waktu ma sosongun, niya' du tanda' bi iya makasammal pibōtang ma diyōm langgal mahasutsi, ma 'nsa' patut pabōtangan na. (Sayi-sayi kaam makabassa itu siyoho' pahati.) ");
INSERT INTO slm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bang hi' paniya' na, sasuku pabōtang ma lahat Yahudiya subay lahi pahi' ni kabud-buran. ");
INSERT INTO slm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bang niya' aa ganta' ma luwasan luma' na subay 'nsa' pabing ma diyōm luma' na ngallo' ayi-ayi na. ");
INSERT INTO slm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bang niya' aa ma huma na subay iya mag-ōs-ōs 'nsa' minsan pabing ngallo' badju' na para ma haggut. ");
INSERT INTO slm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","'Ndu', makaase'-ase' manga danda battōng ma masa ian hi', maka manga danda taga anak duru' le'. ");
INSERT INTO slm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Amuin bi ase' ni Tuhan bang peen iya 'llaw kalahi bi ian 'nsa' magsabu maka musim haggut atawa 'llaw paghali bi ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sabab na manga kabinsanaan iya patumbuk ma masa ma sosongun ian,” uk si Isa, “kalap le' bisa na min kabinsanaan kamemon bayi kalabayan manusiya' sataggōl min tagna' kapaniya' dunya, sampay ni kabuttihian. Maka 'nsa' isab kabayikan. ");
INSERT INTO slm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lipara kiyulangan du uk Tuhan taggōl kabinsanaan ian. Bang bayi 'nsa', 'nsa' du niya' ngapin 'llum. Kiyulangan du uk Tuhan ma sabab manga aa na, iya asal tapene' na. ");
INSERT INTO slm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na, bang taabut waktu ian hi', bo' niya' ganta' ma'-ma' ni kaam, uk na, ‘'Ndaun bi! Tiya' na si Almasi,’ atawa ‘Ian na iya may'an,’ daa tōōd kahagarun bi. ");
INSERT INTO slm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sabab ma waktu ian niya' du paluwas manga aa magnahu'-nahu' in sigam si Almasi, atawa in sigam nabi min Tuhan. Magpanda' sigam manga hinang barakatan maka manga paltandaan kainu-inuhan aa, bo' supaya kaakkalan sampay aa suku' Tuhan, bang ganta' tabo iyakkalan. ");
INSERT INTO slm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pake kaam,” uk si Isa. “Bayi na kaam patau ku ma pasal ian hi' ma 'nsa' le' taabut waktu na. ");
INSERT INTO slm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hangkan ko', bang niya' ngupama ni kaam, uk na hi', ‘Ian si Almasi ma lahat 'nsa' mag-aa’, daa kaam pahi'. Atawa bang uk na, ‘Ian iya patapuk may'an’, daa be'-beun bi. ");
INSERT INTO slm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sabab aku, Anak Manusiya' itu, bang aku pabayik na, tanda' du kapaitu ku, sali' kirat nayinagan ma diyata' langit min sōbangan sampay ni saddōpan.” ");
INSERT INTO slm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Magparalilan si Isa, uk na, “Maingga-maingga lahat kaniyaan patay, may'an du pagtipunan manga owak.” ");
INSERT INTO slm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Jari ma waktu ma sosongun ian,” uk si Isa, “puwas peen manga kabinsanaan bayi sabbut ku hi', ngalindōm du mata 'llaw, maka bulan 'nsa' na muwan sawa. Manga bituun magkapakpak na min diyata' langit, maka ayi-ayi bayi pibōtang uk Tuhan ma tōngaan langit tabo du maglingas. ");
INSERT INTO slm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Puwas na hi' paluwas du tanda' ma diyata' langit, paltandaan in Anak Manusiya' pabing na. Makanda' du bangsa aa kamemon ma aku me' paitu min gabun. Magkarukkaan du sigam kamemon, pag'nda' sigam ma barakat ku maka ma kōsōg sahaya ku. ");
INSERT INTO slm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Puwas na hi' pihalling tiyup-tiyup bo' iyampa soho' ku manga malaikat ku pahi' ni 'mpat pidju alam nipun manga aa bayi tapene' ku, min bihing langit dambiya' maka dambiya'.” ");
INSERT INTO slm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Pamintangin bi poon kayu igira. Bang tanda' bi kayu igira itu ngugbus tong engas-engas na, sampay ngandawun na tōōd, minnihi' katauhan bi song musim pangallaw na. ");
INSERT INTO slm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Damikkiyan na bang tanda' bi paniya' na bayi pamissala ku ma kaam hi', minnihi' isab katauhan bi in kabayik ku ni dunya sikōt na. ");
INSERT INTO slm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Baan ta kaam tōōd,” uk si Isa, “ma 'nsa' le' magpatayan kamemon manga aa iya 'llum ma buttihian, paniya' du pakaradjaan kamemon bayi pamissala ku hi'. ");
INSERT INTO slm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Papinda du langit maka dunya, suga' kabtangan ku itu 'nsa' tōōd magkapinda. ");
INSERT INTO slm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“'Nsa' niya' makatau bang umay 'llaw maka waktu kabayik ku paitu ni dunya. Minsan bangsa malaikat ma diyōm sulga', 'nsa' kitauhan uk sigam. Minsan aku, Anak Tuhan, 'nsa' katauhan ku. Duwal 'Mma' ku Tuhan iya makatau. ");
INSERT INTO slm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bang taabut waktu kabayik ku paitu, sali' du kahalan na maka kahalan bayi ma masa si No hi'. ");
INSERT INTO slm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manga aa ma masa hi', dahu le' min dunuk mehe, bayi sigam magkakanan na peen maka mag-inuman sadja. Bayi sigam maghanda-maghalla, sampay taabut waktu kasakat di si No ni diyata' adjung. ");
INSERT INTO slm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","'Nsa' kisayuhan uk sigam bang ayi song-song pitakka ni sigam. Subay na sigam katumbukan dunuk, tabo kamemon, bo' iyampa kitauhan uk sigam. Na, salaihi' du isab kahalan manga aa ma dunya itu bang aku, Anak Manusiya', pabayik na ni dunya. ");
INSERT INTO slm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma waktu ian niya' duwangan aa maghinang ma huma, jari killo' dakayo' bo' tamban dakayo'. ");
INSERT INTO slm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Niya' ian duwangan danda magtabang nganggiling tirigu, killo' dakayo' bo' tamban dakayo'. ");
INSERT INTO slm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Hangkan kaam subay pajaga, sabab 'nsa' katauhan bi bang umay waktu pabayik Panghu' bi paitu. ");
INSERT INTO slm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bang sawupama niya' aa dapu luma', bo' bayi katauhan na bang lisag pila niya' aa panangkaw takka ni luma' na, tantu du iya bayi magjaga bo' 'nsa' tasōd luma' na. ");
INSERT INTO slm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hangkan kaam soho' ku subay sakap sakahaba' waktu, sabab pabayik du Anak Manusiya' ma waktu 'nsa' katauhan bi.” ");
INSERT INTO slm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bang niya' sosohoan hap akkal na, aa kapangandōlan, iya na ian pene' uk nakura' na magnakura' ma manga sosohoan kasehean. Iya na isab mag-atas-pikil ma balanja' sigam. ");
INSERT INTO slm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na, bang bayi likut nakura' ian, bo' takka na pabing, mehe kahapan sosohoan magnakura' ian bang iya taabut uk nakura' na ngahinang ma bayi pamahinang ma iya. ");
INSERT INTO slm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Baan ta kaam, tantu pangandōl uk nakura' ian alta' na kamemon ma sosohoan kapangandōlan hi'. ");
INSERT INTO slm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Suga' bang sosohoan magnakura' ian sawupama laat addat na, bo' uk na ma diyōm atay na in nakura' na hi' taggōl le' takka. ");
INSERT INTO slm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jari nagna' iya ngalaugan manga pagkahi na sosohoan hi'. Maglami-lami iya maka manga aa maglalango. Magkakan iya sampay mag-inum maka sigam. ");
INSERT INTO slm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sakali tagha' takka nakura' ian, ma waktu 'nsa' kitauhan uk sosohoan hi'. ");
INSERT INTO slm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Manjari liyagut iya uk nakura' na, sampay bugtang na. Pikadalan iya nalka' sali'-sali' maka manga aa iya magbawu'-bawu' in addat sigam hap. May'an sigam magtangis maka magtagiōt baggaang sigam.” ");
INSERT INTO slm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Manjari magparalilan si Isa pabayik, uk na, “Salaitu iya kapagparinta Tuhan ma waktu pabing ku paitu: sali' dalil sangpu' budjang bayi mo palitaan sigam pakaniya-kaniya, sabab sakap pahi' nampang pangantin lalla. ");
INSERT INTO slm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima budjang ian ba' nu dupang, bo' lima ian taha' asal akkal sigam. ");
INSERT INTO slm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na, in lima budjang ba' nu dupang itu bayi mo palitaan suga' 'nsa' bayi mo 'nsallan liyōōn ni palitaan sigam bang ubus na 'nsallan na. ");
INSERT INTO slm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Iya lima budjang taga akkal bayi mo pangalōōnan panno' uk 'nsallan, saddi isab iya ma diyōm palitaan. ");
INSERT INTO slm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na, pagka taggōl takka pangantin lalla, kiyaru' na sigam kamemon hangkan katuwi. ");
INSERT INTO slm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Taabut peen tōnga' bahangi, niya' ngalingan, uk na, ‘Iyu na pangantin lalla. Dayi' na kaam nampang iya.’ ");
INSERT INTO slm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bati' na sangpu' budjang ian bo' pihap uk sigam keyat palitaan sigam. ");
INSERT INTO slm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Uk manga budjang ba' nu dupang ni budjang taga akkal ian, ‘Muwan kaam kono' min 'nsallan bi iyu, sabab song na padda palitaan kami.’ ");
INSERT INTO slm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘E, 'nsa',’ uk budjang taga akkal hi'. ‘'Nsa' makaabut 'nsallan itu ma kitabi kamemon. Pahi' kaam ni tinda mallihan di bi.’ ");
INSERT INTO slm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na, pahi' na ni tinda manga budjang ba' nu dupang ian malli 'nsallan. Likut peen sigam, magtuwi takka na pangantin lalla. Iya lima budjang asal sakap bayi me' ma iya pasōd ni diyōm luma' pagkawinan bo' iyampa tiyambōl lawang. ");
INSERT INTO slm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“'Nsa' taggōl takka budjang kasehean min tinda, bo' ngalingan ni pangantin lalla. ‘O Tuwan,’ uk sigam, ‘ukabin kami.’ ");
INSERT INTO slm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Suga' nambung pangantin lalla hi'. ‘'Nsa' ukab ku,’ uk na. ‘'Nsa' kaam takila ku.’ ");
INSERT INTO slm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Hangkan na,” uk si Isa, “subay kaam pajaga tōōd. Sabab 'nsa' katauhan bi bang umay 'llaw atawa waktu kabayik ku paitu.” ");
INSERT INTO slm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Salaitu iya kapagparinta Tuhan ma waktu pabing ku paitu: sali' dalil dakayo' aa magbamba tulak ni lahat saddi. Song peen iya palanjal, siyoho' uk na manga sosohoan na pahi' ni iya, bo' pijagahan uk na alta' na ma sigam. ");
INSERT INTO slm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iya pangamban na ma sigam dangan maka dangan ian pipagtōngōd maka akkal-kapandayan na. Dangan bayi pangambanan limangibu pilak, dangan bayi duwangibu pilak, maka dangan bayi dangibu. Puwas na hi' tulak na aa hi'. ");
INSERT INTO slm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, iya tindōg bayi pangambanan limangibu pilak ian, magtuwi pag-usaha na sin ian bo' makauntung iya limangibu pilak. ");
INSERT INTO slm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Damikkiyan na sosohoan pasunu', iya bayi pangambanan duwangibu pilak, makauntung iya duwangibu pilak isab. ");
INSERT INTO slm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Suga' iya sosohoan bayi pangambanan dangibu pilak hi', bayi pahi' ngali lowang panapukan na sin nakura' ma diyōm tana'. ");
INSERT INTO slm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Taggōl minnihi' mowe' na nakura' sigam. Pagtakka na, magtuwi iya magbista maka sosohoan na. ");
INSERT INTO slm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iya sosohoan bayi pangambanan limangibu pilak hi' bayi pay'an ni nakura' mo limangibu pilak bayi tauntung na. Uk na ni nakura', ‘Tuwan, bayi aku pangambanan nu limangibu pilak pagpoon. Tiya' isab limangibu pilak bayi tauntung ku.’ ");
INSERT INTO slm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Uk nakura', ‘Hap hinang nu. Hantap kau maka kapangandōlan. Pagka kau hi' kapangandōlan ma alta' diki', pangandōl ku du isab ma kau alta' heka tōōd. Dayi' kau, palamud ma kakuyagan ku.’ ");
INSERT INTO slm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Puwas na hi' pay'an isab sosohoan pasunu', iya bayi pangambanan duwangibu pilak hi'. Uk na ni nakura', ‘Tuwan, bayi aku pangambanan nu duwangibu pilak pagpoon. Tiya' isab untung na duwangibu pilak.’ ");
INSERT INTO slm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Uk nakura' na, ‘Hap ko' hinang nu iyu. Hantap kau maka kapangandōlan. Pagka kau kapangandōlan ma alta' diki', pangandōl ku isab ma kau alta' heka. Dayi' kau, palamud ma kakuyagan ku.’ ");
INSERT INTO slm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Puwas na hi' pay'an isab sosohoan dakayo', iya bayi pangambanan dangibu pilak. Uk na ni nakura', ‘Tuwan, katauhan ku asal in kau 'nsa' maase' ma aa. Nguntung kau min bayi pig-ani bo' 'nsa' kau iya bayi magluug-liksa'. Makakallo' du kau buwa', minsan 'nsa' kau iya bayi magsangsa' nanōm. ");
INSERT INTO slm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bayi aku tiyāw ma kau, hangkan bayi tapukan ku sin nu ma diyōm tana'. A! Tiya' na sin nu.’ ");
INSERT INTO slm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nambung nakura' ian, uk na, ‘Laat kau! Lisuan kalandu'! Katauhan nu baha' in aku nguntung min 'nsa' pagluugan ku, ngallo' aku buwa' isab min 'nsa' bayi tanōm ku? ");
INSERT INTO slm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, bang salaihi', arapun bayi tiyawu' uk nu sin ku ma diyōm bangko. Jari pagtakka ku takallo' ku du sin ku sampay anak na.’ ");
INSERT INTO slm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Puwas na hi' halling nakura' ni sosohoan saddi, uk na, ‘Kalloun bi sin min iya itu bo' pamuwanun ni aa dakayo', iya niya' sin na sangpu' ngibu pilak ian. ");
INSERT INTO slm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sabab sasuku kapangandōlan ma heka, kinnōpan du ma iya sampay ni manglabi-labihan. Suga' sasuku 'nsa' kapangandōlan minsan ma diki', kiyulangan du ayi-ayi bayi ma iya. ");
INSERT INTO slm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, iya sosohoan 'nsa' niya' kapusan na itu, larukin bi iya pahi' ni diyōm kalindōman. Magtallik manga aa ma hi', magtagiōt baggaang sigam.’ ” ");
INSERT INTO slm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Masi mandu' si Isa, uk na, “Bang aku Anak Manusiya' pabayik paitu ngantan parinta, sehean du aku uk manga malaikat. Ningko' isab aku ma kasahayahan ku magparinta. ");
INSERT INTO slm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","In bangsa manusiya' kamemon pipagtipun du ma alōpan ku, bo' pagsaddi ku sigam sali' hantang aa ngipat manga hayōp. Pigsaddi uk na manga bili-bili maka manga kambing. ");
INSERT INTO slm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Manga aa adil, iya sali' hantang bili-bili, pasaddi ku tampal ni katau. Bo' kasehean, iya hantang kambing, pasaddi ku tampal ni kayi. ");
INSERT INTO slm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jari ngabtang du aku, iya pagsultanan sigam. Uk ku ma manga aa ma bihing ku sakap ni katau, ‘Kaam kabuwanan kahapan uk 'Mma' ku, paitu na kaam bo' kaam kaniyaan palsukuan ma diyōm pagparintahan ku, iya bayi tiyagamahan kaam asal uk Tuhan, sataggōl min waktu kapaniya' dunya itu. ");
INSERT INTO slm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iya na iyu panungbas kaam. Sabab na, bayi aku giyōtas bo' aku pakan bi. Bayi aku toho' kallong bo' aku painum bi. Bayi aku sali' aa liyu bo' aku hiyulmat uk bi ma diyōm luma' bi. ");
INSERT INTO slm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bayi 'nsa' niya' sammek ku bo' aku pasammekan bi. Bayi aku saki bo' aku tabang bi. Bayi aku ma diyōm jil bo' aku tibaw bi.’ ");
INSERT INTO slm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nambung du manga aa adil ian, uk sigam, ‘Umay kau bayi tanda' kami giyōtas, bo' kau pakan kami, atawa toho' kallong bo' kau painum kami? ");
INSERT INTO slm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Umay kau bayi tanda' kami sali' aa liyu, bo' kau hulmat kami ma diyōm luma' kami? Umay kau bayi tanda' 'nsa' niya' sammek nu, bo' kau pasammekan kami? ");
INSERT INTO slm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Umay kau bayi tanda' kami saki atawa ma diyōm jil, bo' kau tibaw kami?’ ");
INSERT INTO slm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sambungan ku du sigam, uk ku, ‘Baan ta kaam tōōd, umay-umay niya' tasalaihi' bi kahinangan bi ma dakayo' bean ku deyo' kapag-aa na iyu, aku iya kahinangan bi.’ ");
INSERT INTO slm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Puwas na hi' halling du aku ni manga aa kasehean ian, iya ma bihing ku sakap ni kayi. Uk ku, ‘Pakallo' kaam min aku, manga pagmulkaan Tuhan. Pahi' kaam ni api nalka', iya tiyagamahan nakura' sayitan maka manga tindōg na. ");
INSERT INTO slm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iya na itu panungbas kaam, sabab bayi aku giyōtas suga' 'nsa' aku bayi pakan bi. Bayi aku toho' kallong suga' 'nsa' aku bayi painum bi. ");
INSERT INTO slm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bayi aku sali' aa liyu suga' 'nsa' aku bayi hulmat bi ma diyōm luma' bi. Bayi 'nsa' niya' sammek ku suga' 'nsa' aku bayi kapasammekan bi. Bayi aku saki maka ma diyōm jil aku bayi, suga' 'nsa' aku minsan bayi tabang bi.’ ");
INSERT INTO slm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Jari nambung du manga aa ian, uk sigam, ‘Umay kau bayi tanda' kami giyōtas, atawa toho' kallong, atawa pay'an ni lahat kami sali' aa liyu? Umay kau bayi tanda' kami 'nsa' niya' sammek nu, atawa saki, atawa ma diyōm jil, bo' kau 'nsa' bayi tiyabang uk kami?’ ");
INSERT INTO slm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sambungan ku sigam, uk ku, ‘Baan ta kaam tōōd, umay-umay kaam 'nsa' bayi nabang ma dakayo' bean ku deyo' kapag-aa na iyu, sali' aku du iya 'nsa' bayi tabang bi.’ ");
INSERT INTO slm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Manjari manga aa ian pipahi' du ni kabinsanaan iya natas ni kasaumulan. Suga' manga aa adil pisōd du ni pagpakalluman kakkal ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ubus peen uk si Isa pamandu' na ian kamemon, halling iya ni manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Katauhan bi,” uk na, “hinang Pangintōman du sawung dambuwa'. Iya na ian 'llaw pamatukbal Anak Manusiya' ni manga aa bo' liyansang ni hag piyatay.” ");
INSERT INTO slm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Manjari manga imam langkaw maka manga kamaasan magtipun na ni luma' si Kayapas imam-nakura'. ");
INSERT INTO slm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mag-isun sigam bang salaingga uk sigam naggaw ma si Isa ma 'nsa' niya' makatauhan iya, bo' supaya iya piyatay. ");
INSERT INTO slm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Daa na pasalta' ta ma pagjamu,” uk sigam, “bo' 'nsa' hiluhala' manga aa kamemon.” ");
INSERT INTO slm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, ian si Isa ma Betani, ma diyōm luma' si Simun, aa bayi ipul. ");
INSERT INTO slm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma pagkakanan peen si Isa, niya' pay'an ni iya dakayo' danda mo bingki'-bingki' hinangan batu pote', lōōnan 'nsallan pahamut landu' halgaan. Jari tiyumpahan 'nsallan hi' ni diyata' kok si Isa. ");
INSERT INTO slm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pag'nda' manga mulid ian, magtuwi paddi' atay sigam. “Angay 'nsallan halgaan itu pikaat?” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Arapun itu piballihan ma hatusan pilak bo' ballihan na pamuwan ni manga aa miskin.” ");
INSERT INTO slm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Suga' kitauhan uk si Isa bang ayi pigbissala uk mulid ian, hangkan uk na ni sigam, “Angay sasaw bi danda itu? Hap tōōd hinang na ma aku. ");
INSERT INTO slm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Makatabang kaam manga aa miskin umay-umay kabayaan bi sadja, suga' in aku itu 'nsa' du taggōl maitu ma kaam. ");
INSERT INTO slm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iya hangkan danda itu bayi numpahan 'nsallan pahamut ni baran ku, pangawal 'llaw pagkubul ma aku. ");
INSERT INTO slm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Baan ta kaam,” uk si Isa, “paingga-paingga lahat pagnasihatan lapal hap ma kalohahan dunya, kissa du pasal bayi hinang danda itu, pangintōman manga aa ma iya.” ");
INSERT INTO slm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Puwas peen ian, si Judas Iskariyut, dakayo' mulid si Isa min sangpu' ka duwa, bayi pahi' ni kaimaman langkaw. ");
INSERT INTO slm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Uk na ma sigam, “Ayi pamuwan bi ma aku bang songan ku ni kaam si Isa?” Itungan iya tallumpu' sin pilak, panamba ma iya. ");
INSERT INTO slm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Puwas ian meha na si Judas waktu hap panong na si Isa ni sigam. ");
INSERT INTO slm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na, taabut peen tagnaan 'llaw paghinang, 'llaw pagkakan manga Yahudi tinapay 'nsa' bayi kalamuran pasulig, pahi' ni si Isa manga mulid na tiyaw iya. Uk sigam, “Maingga kabayaan nu panakapan kami pagjamuhan nu ma hinang Pangintōman?” ");
INSERT INTO slm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Uk si Isa, “Pahi' kaam ni diyōm daira ian, ni dakayo' aa may'an, bo' bain bi iya. Uk bi, ‘Siyoho' kau biyaan uk guru hi', sikōt na kono' gantaan na. Baya' iya magjamu maka manga mulid na ma luma' nu, paghinang sigam hinang Pangintōman.’ ” ");
INSERT INTO slm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na bine' uk manga mulid ian bayi panohoan si Isa ma sigam, bo' siyakap uk sigam pagjamu Pangintōman. ");
INSERT INTO slm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagsong kohap peen, magtingkoan na si Isa maka manga mulid na sangpu' ka duwa ian bo' sigam mangan na. ");
INSERT INTO slm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mangan peen, missala si Isa ni sigam, uk na, “Bannal iya halling ku itu ma kaam, niya' dangan min kaam nongan aku ni banta ku.” ");
INSERT INTO slm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Magtuwi landu' susa manga mulid hi', bo' tiyaw sigam ma si Isa magsunu'-sunu'. Uk na, “'Nsa' baha' aku, Tuwan?” ");
INSERT INTO slm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Uk sambung si Isa, “Iya sehe' ku magsawu nublakan tinapay na ni diyōm pinggan itu, iya na hi' nongan aku. ");
INSERT INTO slm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aku itu, Anak Manusiya',” uk si Isa, “matay du sali' bayi tasulat ma pasalan ku ma diyōm kitab. Suga' siya-siya du aa nongan Anak Manusiya' ni banta na. Hap le' aa ian 'nsa' bayi iyanakan.” ");
INSERT INTO slm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jari halling si Judas, iya song nukbalan si Isa ni banta na. “Tuwan Guru,” uk na, “aku na baha' iya pagbahasa nu iyu?” Uk si Isa, “Aho', sali' uk nu iyu.” ");
INSERT INTO slm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sabu peen sigam masi mangan, killo' tinapay uk si Isa. Iyamuan uk na pagsukulan bo' iyampa pighopo'-hopo' uk na, bo' pamuwan na ma manga mulid na. “Sambutun bi bo' kakanun bi,” uk na, “sabab tinapay itu iya na ko' baran ku.” ");
INSERT INTO slm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Killo' isab uk na dakayo' sawan, bo' iyamuan isab pagsukulan pabing bo' iyampa songan na ni sigam. “Kaam kamemon,” uk na, “inumun bi lōōn sawan itu. ");
INSERT INTO slm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Laha' ku ko' itu, tanda' kapagsulutan Tuhan maka manusiya'. Laha' ku song pitumpa ma sabab aa heka pangampunan dusa sigam. ");
INSERT INTO slm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Baan ta kaam, puwas itu 'nsa' aku nginum bohe' anggul itu pabing. Subay kitabi magbe' nginum bohe' anggul bahu ma diyōm pagparintahan 'Mma' ku bo' iyampa aku makainum pabing.” ");
INSERT INTO slm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Puwas na hi', ubus peen uk sigam bayi ngalang dakayo' kalangan pamudji Tuhan, paluwas na sigam tudju ni Bud Kayu Jaitun. ");
INSERT INTO slm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Manjari halling si Isa ni sigam, uk na, “Sangōm itu lahi du kaam kamemon ngalabba min aku, sabab tasulat ko' ian ma diyōm kitab. Uk na hi', ‘Piyatay uk ku,’ uk Tuhan, ‘aa bayi mag-iipat bili-bili, bo' kawukanat manga bili-bili na.’ ");
INSERT INTO slm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Suga' bang aku tapakallum na pabayik min kamatay ku, parahu aku min kaam tudju ni lahat Jalil.” ");
INSERT INTO slm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Halling si Petros ni si Isa, uk na, “'Nsa' tōōd kau labbahan ku minsan kau libbahan uk kasehean.” ");
INSERT INTO slm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Uk si Isa ni iya, “Baan ta kau tōōd. Ma sangōm itu, ma 'nsa' le' nigauk manuk, mayilu du kau min tallu in aku 'nsa' katauhan nu.” ");
INSERT INTO slm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Uk sambung si Petros, “Minsan aku paunung matay ma kau, 'nsa' du kau payiluhan ku.” Iya du manga mulid kasehean, salaihi' du isab halling sigam. ");
INSERT INTO slm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Manjari palanjal le' di si Isa ni kabbun iyōnan Getsemane. Uk si Isa ni manga mulid na, “Maitu le' kaam ningko'. Pay'an le' aku nambahayang.” ");
INSERT INTO slm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iya biyo uk si Isa sehe' na pay'an, iya na si Petros maka duwangan anak si Sibidi. Sakali magkasusahan si Isa, magkabba-kabba diyōm atay na. ");
INSERT INTO slm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Uk na ni tallungan mulid na hi', “Aku itu agōn magkamamatay ma sabab kasusahan itu. Ngagad kaam ma itu, sehein bi aku magjaga.” ");
INSERT INTO slm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Makalawak-lawak peen iya min sigam, pakappang iya ni tana' maka uk na nabbut ni Tuhan, Uk na, “'Ndu', 'Mma'! Bang makajari, kalloin le' min aku sawan kabinsanaan itu. Suga' 'nsa' du iya kabayaan ku subay diyulan, bang peen min kabayaan nu du.” ");
INSERT INTO slm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Puwas na hi' pabing si Isa ni sehe' na tallungan, bo' tatawwa' na sigam magtuwihan. Uk na ni si Petros, “Angay kaam 'nsa' makatatas magjaga maka aku minsan laa danjam sadja? ");
INSERT INTO slm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pajaga kaam, ngamu' kaam tabang ni Tuhan bo' kaam 'nsa' tabo-bo uk sasat. Baya' tōōd kaam diyōm atay bi me' ma soho' ku itu suga' 'nsa' takaya uk baran bi.” ");
INSERT INTO slm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sakali pahi' si Isa nambahayang pabing. Uk na, “O 'Mma', bang aku subay pananam nu kabinsanaan itu bo' supaya puwas na, me' aku ma kabayaan nu.” ");
INSERT INTO slm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Makabayik peen iya ni di si Petros, tatawwa' na isab sigam magtuwihan pabing sabab kiyaru' kalandu'. ");
INSERT INTO slm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Manjari pahi' si Isa nambahayang pabing sali' bayi dahu, kamintallu na na. ");
INSERT INTO slm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Puwas na hi' pabayik isab iya ni mulid na katallu ian. Uk na, “Oy, tuwi le' kaam? Pahali-hali le' kaam? 'Ndaun bi ba, taabut na waktu ku. Aku, Anak Manusiya' itu, song-song na tiyukbalan ni pangantanan manga aa laat. ");
INSERT INTO slm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Papunduk kaam. Sung kitabi, sabab iyu na aa iya nongan aku ni sigam.” ");
INSERT INTO slm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na, salta' peen si Isa halling le' ni manga mulid na, magtuwi du takka pay'an si Judas, dakayo' mulid si Isa min sangpu' ka duwa hi'. Heka aa magbe' maka iya magbo takōs maka manga kakakal. Manga aa hi' bayi siyoho' pay'an uk manga kaimaman langkaw maka uk manga kamaasan. ");
INSERT INTO slm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bayi sigam asal kabuwanan pamandōgahan uk si Judas bo' niya' pangilahan sigam ma si Isa. Bayi uk na ma sigam, “Iya aa siyum ku, iya na hi' saggawun bi.” ");
INSERT INTO slm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pagtakka si Judas pay'an magtuwi iya pahi' ni si Isa. “Tuwan Guru, assalamu alaykum,” uk na. Magtuwi siyum uk na si Isa. ");
INSERT INTO slm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“Bagay,” uk si Isa ni iya, “lanjalin hinang nu.” Sakali pasikōt ni si Isa manga aa ian naggaw iya, ingkōtan iya pahōgōt. ");
INSERT INTO slm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Suga' niya' sehe' si Isa dakayo' bayi ngahurusan patakōs na. Liyagut uk aa itu dakayo' sosohoan imam-nakura', bo' bintas magtuwi dambiya' tainga na. ");
INSERT INTO slm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Uk si Isa, “Sulugun takōs nu ni taguban na iyu, sabab sasuku mo tatakōs pamapatay aa, matay du isab iya uk takōs. ");
INSERT INTO slm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Nsa' katauhan bi baha', bang aku ngamu' tabang ni 'Mma' ku diyulan sadja aku? Piyabohan du aku malaikat na ma ibuhan. ");
INSERT INTO slm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Suga' bang aku ganta' salaihi', 'nsa' tuman iya bayi tasulat ma diyōm kitab, iya uk na in manga pakaradjaan itu subay patakka salaitu.” ");
INSERT INTO slm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Manjari halling si Isa ni baanan aa ian, Uk na, “Kaba' bi in aku itu mundu baha', iya poon kaam subay mo takōs maka kakakal panaggaw bi aku? Kahaba'-haba' 'llaw mahi' na peen aku bayi ningko' mandu' ma diyōm langgal pagkulbanan iyu, suga' 'nsa' aku tasaggaw bi. ");
INSERT INTO slm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bo' peen in pakaradjaan itu kamemon makani-aku du, bo' supaya niya' kamaksuran ma bayi tasulat uk kanabi-nabihan ma diyōm kitab.” Magtuwi maglahihan manga mulid si Isa kamemon. Jari pisaran na iya. ");
INSERT INTO slm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Manjari biyo si Isa uk aa managgaw iya, biyo pay'an ni luma' si Kayapas imam-nakura'. Ian magtipun manga guru ma sara' agama maka kamaasan. ");
INSERT INTO slm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Petros iya bayi paturul ma si Isa suga' min katahan. Paturul iya sampay pasōd na ni diyōm halaman luma' imam-nakura'. Ma diyōm peen iya, magtingkoan iya maka manga jaga imam hi' supaya tanda' na bang ayi katudjuhan si Isa. ");
INSERT INTO slm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Manga kaimaman langkaw maka manga aa ma palhimpunan, ian meha sababan panuntut sigam ma si Isa minsan 'nsa' bannal, bang peen niya' pagsababan pamapatay sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Suga' 'nsa' niya' tatawwa' uk sigam, minsan heka aa bayi naksi' puting pasal si Isa. Subay na song ubus bo' iyampa niya' aa duwangan paalōp ma palhimpunan halling, ");
INSERT INTO slm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","uk sigam, “Bayi take kami aa itu halling in iya ngalubu langgal pagkulbanan du, bo' ma diyōm tallungallaw kono' tapatangge na pabayik.” ");
INSERT INTO slm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Manjari nangge imam-nakura' missala ma si Isa, uk na, “Kau iyu, 'nsa' niya' baha' daawa nu ma panuntut ma kau itu?” ");
INSERT INTO slm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Suga' 'nsa' nambung si Isa. Missala pabing imam-nakura', uk na, “Pasapa ta kau. Saksi' ta Tuhan, iya asal 'llum. Bain kami tōōd bang kau iya si Almasi, Anak Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Aho',” uk si Isa, “iya na uk nu. Suga' baan ta kaam, 'nsa' du taggōl tanda' bi du Anak Manusiya' ningko' ma bihing Tuhan Sangat Kawasa, sakap ni katau. Maka tanda' bi du iya paitu me' ma gabun min diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Manjari gese' uk imam-nakura' pakayan na, min dugal na. Uk na, “Aa itu halling pangkal ni Tuhan! Daa na kitabi meha saksi' saddi! Take bi na halling na pangkal! ");
INSERT INTO slm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ayi pangahukum bi?” Uk sambung manga aa ma palhimpunan hi', “Subay iya pibōtangan hukuman ni kamatay.” ");
INSERT INTO slm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Puwas na hi' liyuraan si Isa uk sigam ma bayihu' na. Pigtibu' isab iya uk sigam. Niya' isab sigam bayi nampak iya. ");
INSERT INTO slm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bo' uk sigam, “Bang kau na iya si Almasi, tōkōrun kono' bang sayi iya nampak kau itu!” ");
INSERT INTO slm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Manjari ian si Petros ningko' ma halaman luma' hi'. Niya' pahi' ni iya dakayo' danda, ipatan imam-nakura'. Uk danda itu ni iya, “Kau iyu, bayi kau me' ma si Isa, iya aa Jalil ian.” ");
INSERT INTO slm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Suga' mayilu si Petros ma alōpan aa ian kamemon. “'Nsa' katauhan ku,” uk na, “bang ayi iya halling nu iyu.” ");
INSERT INTO slm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Puwas na hi' pahi' iya tudju ni bo' lawang, bo' niya' ipatan danda saddi bayi makanda' iya. Pag'nda' na ma si Petros, uk na ni manga aa may'an, “Aa itu bayi me' ma si Isa, aa Nasaret ian.” ");
INSERT INTO slm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Magtuwi mayilu si Petros pabing. Napahan iya di na. “'Nsa' katauhan ku aa ian,” uk na. ");
INSERT INTO slm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","'Nsa' taggōl, pay'an ni si Petros manga aa asal magtanggehan may'an. Uk sigam, “Katauhan kami du in kau bannal bayi sehe' di si Isa sabab takila ta du kau min bissala nu.” ");
INSERT INTO slm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sakali napahan di na si Petros bo' uk na, “'Nsa' katauhan ku aa ian!” Saruun-duun du nigauk manuk, ");
INSERT INTO slm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","bo' taintōm uk si Petros iya bayi halling si Isa ma iya, iya bayi uk na, “Ma 'nsa' le' nigauk manuk sangōm itu, mayilu du kau min tallu in aku 'nsa' katauhan nu.” Magtuwi paluwas si Petros minnihi'. Nangis iya, magkarukkaan tōōd. ");
INSERT INTO slm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Taabut peen pagkallat 'llaw, maggara' kaimaman langkaw kamemon maka manga kamaasan bangsa Yahudi bang salaingga piyatay uk sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Manjari bilangguan si Isa bo' iyampa tiyukbalan ni si Pilatu, gubnul bangsa Roma. ");
INSERT INTO slm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pagtau si Judas, iya bayi nongan si Isa ni manga banta na, in si Isa bayi na pibōtangan hukuman ni kamatay, magtuwi iya magsusun. Jari pahi' iya ni kaimaman langkaw maka ni kamaasan, arak nambut min sigam sin bayi panamba iya, tallumpu' sin pilak. ");
INSERT INTO slm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Uk na ma sigam, “Mehe dusa ku sabab bayi kasongan ku aa 'nsa' taga dusa ni banta na, maka tiya' song piyatay.” “Min kau na,” uk sigam. “'Nsa' du min kami.” ");
INSERT INTO slm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sakali hiyantakan sin ian uk si Judas ma diyōm langgal bo' iyampa iya paluwas minnihi' nganggantung di na ma kallong na bo' matay. ");
INSERT INTO slm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Manjari kaimaman ian muwa' sin bayi hiyantakan uk si Judas hi'. Uk sigam, “Sin itu haram bang ma agama ta sabab bayi tambahan pamapatay aa. 'Nsa' manjari pitipun ni sin langgal.” ");
INSERT INTO slm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dakayo' peen paggara' sigam pasal sin ian, pigguna uk sigam pamalli tana' ni aa maghihinang pōga, manjari tana' pangubulan aa liyu. ");
INSERT INTO slm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangkan ko' tana' ian iyōnan “Tana' tamba laha'” sampay ni kabuttihian. ");
INSERT INTO slm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na, ma sabab hinang ian niya' katawwaan na ma bayi tasulat uk si Nabi Irimiya ma diyōm kitab ma awwal le', iya uk na, “Manjari killo' uk sigam tallumpu' sin pilak bayi pag-isunan uk bangsa Israil pamalli baran aa, ");
INSERT INTO slm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bo' giyuna pamalli tana' ni aa maghihinang pōga. Iya na hi' bayi panohoan uk Tuhan ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Manjari ian si Isa nangge ma alōpan gubnul Pilatu, siyumariya uk na. “Kau iyu,” uk Gubnul, “sultan baha' ma bangsa Yahudi?” Nambung si Isa, uk na, “Iya na uk nu iyu.” ");
INSERT INTO slm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Nsa' iya bayi nambung manga tuntut bayi panuntut ma iya uk kaimaman langkaw maka kamaasan. ");
INSERT INTO slm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Halling si Pilatu ni iya, uk na, “'Nsa' take nu baha' iya heka panuntut uk manga aa itu ma kau?” ");
INSERT INTO slm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Suga' si Isa ian 'nsa' niya' sambung na minsan dakabtang, hangkan inu-inu tōōd gubnul hi'. ");
INSERT INTO slm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kahaba' tahun, ma waktu paghinang bangsa Yahudi ma hinang Pangintōman, iya kabiyaksahan gubnul subay niya' dakayo' pilisu palappa na, sayi-sayi pene' uk manga Yahudi. ");
INSERT INTO slm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma waktu ian niya' dakayo' pilisu babantugun, ōn na si Barabbas. ");
INSERT INTO slm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Manjari, makapagtipun peen pay'an kahekahan aa, tīyaw sigam uk si Pilatu. “Ayi kabayaan bi,” uk na, “subay palappa ku? Si Barabbas atawa si Isa itu hi', iya iyōnan Almasi?” ");
INSERT INTO slm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Malayingkan katauhan na asal bang ayi sababan na hangkan si Isa bayi pitakka ni iya. Tuud sigam ngimbu ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ningko' peen si Pilatu ma tōngōd paghukuman, niya' lapal piyabo ni iya uk handa na. Uk lapal, “Daa kau palamud ni hukuman aa maadil iyu. Sabab niya' taupi ku dibuhi' pasalan na, landu' aku bayi magkasusahan.” ");
INSERT INTO slm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Manjari baanan aa ian bayi talōgōs uk kaimaman langkaw maka uk kamaasan subay ngamu' pilappa si Barabbas, bo' si Isa iya siyoho' piyatay. ");
INSERT INTO slm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Suga' tiyaw sigam pabing uk Gubnul hi'. “Sayi ma diyōm duwangan pilisu itu,” uk na, “subay palappa ku?” “Si Barabbas,” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tiyaw si Pilatu ma sigam. “Inay ku,” uk na, “si Isa itu, iya iyōnan Almasi?” “Lansangun iya ni hag,” uk sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Suga' tiyaw le' si Pilatu. Uk na, “Ayi bayi hinang na laat?” Luhuy pakōsōg pangōlang manga aa hi'. Uk sigam, “Lansangun iya ni hag!” ");
INSERT INTO slm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagtau si Pilatu in katipunan aa ian 'nsa' talang maka marayi' na mehe kahiluhalaan, magtuwi iya ngallo' bohe' bo' iyampa kosean na tangan na ma alōpan sigam, paltandaan in iya papuwas min palkala' hi'. Uk na ni sigam, “Bang peen 'nsa' min aku bang aa itu piyatay. Min kahinangan bi na.” ");
INSERT INTO slm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nambung manga aa ian kamemon, uk sigam ma iya, “Akuhan kami kamatay na, minsan kami pabōtangan dusa sampay ni anak-mpu kami.” ");
INSERT INTO slm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sakali si Barabbas iya pilappa uk si Pilatu tudju ni baanan aa hi'. Bo' si Isa iya siyoho' liyapdōsan bo' iyampa tiyukbalan pilansang ni hag piyatay. ");
INSERT INTO slm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manjari biyo si Isa uk manga sundalu gubnul ian pahi' ni diyōm luma' gubnul, bo' patipun pahi' ma katilibut na dambaan sundalu ian. ");
INSERT INTO slm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Killoan uk sigam sammek na bo' pamajuba ma iya manta pula bo' sali' hantang sultan. ");
INSERT INTO slm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Liyubid isab bahan itingan uk sigam, hinang sali' panumping sultan pibōtang ni kok na. Puwas na hi' piantanan iya kayu-kayu ma tangan na ni katau, bo' iyampa sigam pasujud ni dahuhan na bahasa magtungging. Uk sigam, “Assalamu alaykum, Appa' Sultan Yahudi!” ");
INSERT INTO slm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pigluraan iya uk sigam. Killo' uk sigam kayu-kayu bayi ma tangan na bo' pamappōk ni kok na. ");
INSERT INTO slm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na, ubus peen uk sigam magtungging ma iya, magtuwi hiyurusan manta bayi pajuba na ian bo' iyampa iya pisammekan maka bayi sammek na tagna'. Puwas hi' biyo iya paluwas minnihi' bo' liyansang ni hag pamapatayan iya. ");
INSERT INTO slm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Salta' peen sigam paluwas min daira ian, niya' aa talanggal sigam lalla min lahat Kirini, ōn na si Simun. Liyōgōs iya uk manga sundalu, siyoho' nanggung hag si Isa. ");
INSERT INTO slm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagtakka sigam peen ni jadjahan lahat iyōnan Golgota, hati na lahat “Baung Kok”, ");
INSERT INTO slm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","arak pamainum sigam ma si Isa bohe' anggul (sali' tuba') kalamuran tambal pait. Suga' pagtananam na, 'nsa' iya nginum. ");
INSERT INTO slm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ubus peen uk manga sundalu bayi ngalansang si Isa ni hag sampay matangge hag na, pigbahigian uk sigam sammek na bo' pigkoot-kootan uk sigam bang sayi iya dapu na. ");
INSERT INTO slm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Puwas na hi' ningko' sigam may'an nganjaga. ");
INSERT INTO slm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Niya' sulat panuntut bayi pibōtang uk sigam ma hag min diyata' kok si Isa. Uk sulat hi': “Si Isa, Sultan bangsa Yahudi”. ");
INSERT INTO slm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Niya' isab duwangan mundu bayi liyansang ma hag sigam. Dakayo' ian pitangge ma bihing si Isa sakap ni katau, dakayo' ma sakap ni kayi. ");
INSERT INTO slm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na, pig-udjuan si Isa uk aa maglawulabay. Pighanduk-handukan iya uk sigam pangudju'. ");
INSERT INTO slm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Allā,” uk sigam, “kau na iya bilang ngalangkat langgal pagkulbanan ian, bo' pabangun nu pabing ma diyōm tallungallaw! Ngalappasan kau di nu bang kau bannal Anak Tuhan. Pareyo' kau min hag iyu!” ");
INSERT INTO slm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iya du magpangudju' manga imam langkaw maka manga guru ma sara' agama maka manga kamaasan. ");
INSERT INTO slm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aa itu,” uk sigam, “tau ngalappas ma aa saddi suga' 'nsa' makalappas di na. Sultan bangsa Israil kono'! Bang iya ganta' makapareyoan di na min hag, ngahagad du kitabi ma iya! ");
INSERT INTO slm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mangandōl iya ma Tuhan, maka iya kono' Anak Tuhan. 'Nda' ta le' bang Tuhan baya' ngalappas ma iya!” ");
INSERT INTO slm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iya du duwangan mundu bayi liyansang pigdambean ma si Isa, me'-me' isab ngudju' iya. ");
INSERT INTO slm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, lattu peen 'llaw, tawwa' lindōm kalohahan lahat hi' sampay ni lisag tallu kohap. ");
INSERT INTO slm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Paglisag tallu manga, kōsōg uk si Isa ngalingan, uk na, “Eli, eli, lama sabaktani?” Hati na, “Tuhan ku, O Tuhan ku, angay na aku pasaran nu?” ");
INSERT INTO slm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pagtake itu uk manga aa magtanggehan may'an, uk sigam kasehean, “Ngalinganan iya si Nabi Eliyas.” ");
INSERT INTO slm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Magtuwi niya' dakayo' aa parayi'-dayi' ngahagōman lappus ni diyōm inuman kisōm (sali' tuba') bo' iyampa pasagnat na ni tong kayu-kayu. Arak pamainum na ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Suga' 'nsa' aa kasehean ian. Uk sigam, “Ngagad le' kau. 'Nda' ta le' bang paluwas si Nabi Eliyas ngalappas ma iya.” ");
INSERT INTO slm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sakali ngōlang si Isa pabayik, magtuwi bakkat napas na. ");
INSERT INTO slm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Saruun-duun du iya kulambu' bayi pangagpang ma diyōm langgal pagkulbanan ian gese' pa duwa min diyata' na tudju pareyo'. Jōgjōg diyōm dunya, maka bilaan di na manga batu mehe. ");
INSERT INTO slm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Niya' isab kakubulan ukab maka heka manga aa suku' Tuhan bayi papunduk, 'llum pabing min kamatay sigam. ");
INSERT INTO slm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Magluwasan sigam min diyōm kubul, bo' puwas peen si Isa bayi 'llum pabing min kamatay na, magpay'an sigam ni Awrusalam, ni daira Mahasutsi. Heka aa bayi makanda' sigam may'an. ");
INSERT INTO slm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tananam peen linug maka pakaradjaan ian kamemon uk kapitan maka manga sundalu bayi sehe' na nganjaga ma pamapatay si Isa, magtuwi sigam tiyāw kalandu'. Uk sigam, “Bannal aa itu Anak Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Heka isab manga danda bayi may'an nganda' min katahan. Sigam iya bayi me' paumpig ma si Isa ngadjalan iya, tagna' na ma lahat Jalil le'. ");
INSERT INTO slm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ian si Mariyam min Magdala, si Mariyam ina' si Ya'kub maka si Yusup, maka handa si Sibidi. ");
INSERT INTO slm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagsong kohap na, niya' takka pay'an dakayo' aa dayahan, aa min lahat Arimati. Ōn na si Yusup, dakayo' mulid si Isa isab. ");
INSERT INTO slm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pahi' si Yusup itu paalōp ni si Pilatu ngamu' patay si Isa. Jari magpanohoan si Pilatu ian ni manga sundalu na, siyoho' ngalloan patay si Isa ni si Yusup. ");
INSERT INTO slm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Takallo' peen patay uk si Yusup itu, siyaput uk na maka kakana' bahu ");
INSERT INTO slm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bo' iyampa biyōtang pahi' ni kubul bayi tagamahan na di na, kubul bahu bayi kiyali ma diyōm pampang batu. Puwas na hi' giyulungan uk na batu mehe panaplōk bo' lowang hi' bo' iyampa iya pakallo' min ian. ");
INSERT INTO slm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","May'an asal si Mariyam aa Magdala, maka Mariyam dakayo' na, ningko' ma dahuhan kubul ian. ");
INSERT INTO slm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkallat 'llaw dakayo', hati na 'llaw Sabtu', patipun ni si Pilatu manga kaimaman langkaw maka manga Parisi. ");
INSERT INTO slm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Uk sigam ni iya, “Tuwan, taintōm kami du bayi halling aa putingan ian ma waktu kallum na le'. Uk na bang taabut tallungallaw min kamatay na in iya 'llum du pabing. ");
INSERT INTO slm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hangkan kubul na ian subay soho' nu jiyagahan tōōd sampay taabut katallungallaw na. Kalu pahi' manga mulid na nangkaw mayat na bo' iyampa ma'-ma' ni kasehean in iya 'llum pabing min kamatay na. Bang ganta' salaihi' kalap le' puting sigam damuwi min bayi dahu.” ");
INSERT INTO slm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Na,” uk si Pilatu. “Bohun bi sundalu pahi' ni kubul bo' pajagahun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Manjari mangngan na sigam pahi'. Niya' indan pipikit uk sigam ni taplōk batu bo' kitauhan bang niya' bayi ngukab iya. Siyoho' isab manga sundalu nganjaga may'an. ");
INSERT INTO slm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagka palabay na 'llaw Sabtu', bo' pagkallat 'llaw Ahad, ian si Mariyam aa Magdala maka Mariyam dakayo' ian pahi' nganda' kubul si Isa. ");
INSERT INTO slm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Saruun-duun du bayi jōgjōg lahat uk linug kōsōg. Niya' dakayo' malaikat Tuhan bayi pareyo' min sulga' nganggulung taplōk batu min lowang kubul bo' iyampa ningko' ma diyata' batu hi'. ");
INSERT INTO slm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sawa dagbōs malaikat ian sali' sawa kirat, maka sammek na pote' tōōd. ");
INSERT INTO slm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Manga sundalu nganjaga ian bayi katakkahan tāw hangkan midpid. Sali' sigam aa matay 'nsa' makasayu. ");
INSERT INTO slm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Manjari missala malaikat ni duwangan danda hi'. “Daa kaam tiyāw,” uk na. “Katauhan ku in kaam meha si Isa, iya bayi piyatay ma diyata' hag. ");
INSERT INTO slm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Nsa' na iya maitu sabab 'llum na min kamatay na, sali' bayi halling na. Paitu kaam nganda' ni bayi pabahakan na. ");
INSERT INTO slm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Puwas na hi', pasaut kaam pahi' ni manga mulid na mohan sigam habal in iya pikallum na min kamatay na. Parahu du iya min sigam ni lahat Jalil, bo' may'an sigam nganda' iya. Intōmun bi bayi pama' ku itu ma kaam.” ");
INSERT INTO slm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Magtuwi sakadjap sadja sigam pakallo' min kubul. Tiyāw sigam dambiya', bo' kiyōgan isab dambiya'. Paragan sigam pahi' ma'-ma' ni manga mulid si Isa. ");
INSERT INTO slm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma labayan peen, saruun-duun du paluwas si Isa ngalanggal sigam. “Kaam ko' iyu,” uk na. Pasikōt sigam ni iya ngantanan nayi' na maka uk sigam mudji iya. ");
INSERT INTO slm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Uk si Isa, “Daa kaam tiyāw. Pahi' na kaam ma'-ma' ma manga danakan ku ian in sigam subay pahi' ni lahat Jalil. Ma hi' du sigam nganda' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sabu peen duwangan danda ian palanjal ni papahian sigam, niya' pabayik ni diyōm daira manga sundalu kasehean bayi nganjagahan kubul. Biyaan uk sigam kaimaman langkaw pasal bayi pakaradjaan ma pagkubulan hi'. ");
INSERT INTO slm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Manjari magtipun kaimaman langkaw maka manga kamaasan maggara'. Iya paggara' sigam in manga sundalu ian subay biyuwanan sin heka. ");
INSERT INTO slm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Uk kaimaman hi', “Bain bi manga aa in kamuliran si Isa bayi pahi' waktu sangōm nangkaw mayat na salta' kaam bayi tuwi. ");
INSERT INTO slm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Suga' daa kaam susa bang itu ganta' kitauhan uk gubnul. Tau du kami missalahan iya bo' supaya kaam 'nsa' kataksilan.” ");
INSERT INTO slm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Manjari killo' sin ian uk manga sundalu bo' pama' uk sigam sali' bayi panohoan kaimaman hi'. Sampay ni buttihi' iya na ko' hi' hunub-hunub pisaplag ma diyōm bangsa Yahudi, hati na mayat si Isa bayi kono' tiyangkaw uk manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Manjari iya sangpu' kadda mulid si Isa ma hi' ni lahat Jalil, patukad ni dakayo' bud iya bayi pama' si Isa ma sigam. ");
INSERT INTO slm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pag'nda' sigam ma si Isa, magtuwi sigam bayi mudji iya. Suga' niya' sigam kasehean magduwa-duwa ma diyōm atay sigam bang ian hi' bannal si Isa. ");
INSERT INTO slm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pasikōt si Isa ni sigam, uk na, “Bayi na aku kabuwanan kawasa magbaya' ma dunya sampay ma sulga'. ");
INSERT INTO slm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hangkan kaam soho' ku pahi' ni sabarang bangsa bo' sigam bo bi magmulid ma aku. Pandihun bi sigam min ōn Tuhan 'Mma', maka min ōn Anak, maka min ōn Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Panduin bi sigam subay me' ma kamemon bayi panohoan ku kaam. Maka itu intōmun bi pahap: daran du aku ma iyu ma kaam sampay iyabutan masa.” ");
INSERT INTO slm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iya na itu lapal hap pasal si Isa Almasi Anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tagnaan lapal hap itu bayi tasulat asal uk si Nabi Isaya ma diyōm kitab, iya uk na hi', “ ‘Tiya' sosohoan ku,’ uk Tuhan. ‘Soho' ku iya parahu min kau bo' supaya sakapan na daddōk palabayan nu.’ ");
INSERT INTO slm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Niya' aa ngalingan ma lahat 'nsa' agōn kalluman ayi-ayi. Salaitu pangalingan na, uk na, ‘Song na takka Panghu'. Lanuin bi daddōk palabayan na. Pabōntōlun bi palangnganan na.’ ” ");
INSERT INTO slm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Manjari itu paluwas si Yahiya pay'an ni lahat 'nsa' agōn kalluman ayi-ayi. Iya na ko' ian hi' bayi mandi manga aa tanda' saksi' in sigam ngalabba na min dusa sigam. Magnasihat iya ma manga aa may'an, uk na, “Pataikut kaam min dusa bi bo' kaam piyandi, bo' iyampun du dusa bi uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jari heka aa pahi' ni si Yahiya min kalohahan lahat Yahudiya maka min daira Awrusalam. Magpasabannal sigam pasal bayi dusa sigam bo' piyandi sigam uk si Yahiya ma diyōm sapa' Jordan. ");
INSERT INTO slm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iya panammek si Yahiya ian bu hayōp unta' bayi hinang kakana' maka dakayo' sabitan kuwit sapi' pakambot ma hawakan na. Iya kiyakan na manga ampan maka gula' buwani. ");
INSERT INTO slm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nganasihat isab iya, uk na, “Niya' paitu damuwi min aku aa kawasa bidda' min aku. Minsan ingkōt tawumpa' na, 'nsa' aku tiyōp pareyo' ngahubaran iya. ");
INSERT INTO slm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aku itu, bohe' sadja iya pamandi ku ma kaam. Suga' iya ian, saddi bohan pamandi na ma kaam, hati na in iya masangōn du Nyawa Sutsi ni diyōm baran bi.” ");
INSERT INTO slm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jari itu, ma waktu hi', takka si Isa bayi min Nasaret, dakayo' kalumaan mahi' ma lahat Jalil. Piyandi iya uk si Yahiya ma diyōm sapa' Jordan hi'. ");
INSERT INTO slm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Makariyata' peen iya min diyōm bohe' sapa' magtuwi tanda' na paukab langit maka Nyawa Tuhan pareyo' tudju ni iya magpabaran sali' dagbōs assang. ");
INSERT INTO slm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Niya' isab suwara halling min diyōm sulga'. Uk na, “Kau iya anak ku kalasahan ku, landu' kau makasulut atay ku.” ");
INSERT INTO slm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jari pipahi' magtuwi si Isa uk Nyawa Tuhan ni lahat de 'nsa' agōn kalluman ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Mpatpu' 'llaw 'mpatpu' bahangi iya kamahi' na, siyasat na peen uk nakura' sayitan, kalu iya tabo magdusa. Iya sehe' na may'an manga hayōp tawun, maka niya' manga malaikat ngipat iya. ");
INSERT INTO slm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, ubus peen si Yahiya bayi tajil, pahi' si Isa ni lahat Jalil magnasihat pasal lapal hap min Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Taabut na waktu bayi pigpalatun,” uk na. “Sikōt na waktu pagparinta Tuhan ma itu ma manusiya'. Tayikutin bi na dusa bi maka kahagarun bi na lapal hap itu.” ");
INSERT INTO slm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Manjari itu, pasalta' peen si Isa mangngan ma bihing danaw Jalil, niya' tanda' na duwangan lalla magdanakan, si Simun maka si Andariyas. Ian sigam ngahug pōkōt ma danaw hi' sabab magdaraying asal sigam. ");
INSERT INTO slm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Uk si Isa ma sigam, “Paitu kaam me' ma aku. Bayi kaam asal magkallo' daying suga' bang aku iya pamean bi, panduan ta kaam magkallo' pagkahi bi manusiya' me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na, take peen halling si Isa uk duwangan ian, magtuwi libbahan uk sigam pōkōt sigam bo' me' na sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jari makalawak-lawak peen si Isa minnihi' niya' isab tanda' na duwangan lalla magdanakan, si Ya'kub maka si Yahiya, anak si Sibidi. Ian sigam ma diyata' bayanan sigam magpaayad pōkōt. ");
INSERT INTO slm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Linganan magtuwi sigam uk si Isa, jari libbahan 'mma' sigam may'an ma diyata' bayanan hi', iya maka manga tindōg na giyadjihan. Bo' me' na sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Takka di si Isa pahi' ni daira Kapirnaum. Jari taabut peen 'llaw Sabtu', 'llaw mulliya ma bangsa Yahudi, pasōd si Isa ni diyōm langgal may'an manduan manga aa. ");
INSERT INTO slm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Inu-inu manga aa makake may'an ma pamandu' na sabab tā pagbiddaan na maka pamandu' manga guru ma sara' agama. Si Isa iya taga kawasa asal bang mandu'. ");
INSERT INTO slm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Manjari itu niya' lalla pasōd ni diyōm langgal ian, aa bayi siyōd uk sayitan. Ngōlang iya pakōsōg, uk na, ");
INSERT INTO slm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Isa min Nasaret! Ayi kamaksuran nu paitu? Paitu kau baha' makaat kami? Katauhan ku du bang sayi kau. Kau iya dakayo'-kayo' sutsi iya paitu min Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Suga' liyāng sayitan ian uk si Isa, uk na, “Parōhōng kau! Paluwas kau min aa iyu!” ");
INSERT INTO slm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jari pipaspad aa ian uk sayitan bo' ngōlang iya pakōsōg bo' iyampa paluwas min baran na. ");
INSERT INTO slm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Inu-inu manga aa kamemon bayi may'an iya poon sigam magtiyawan di sigam. Uk tiyaw sigam, “Ayi baha' itu? Pandu' bahu marayi'. Aa itu taga kawasa magpanohoan minsan ma manga sayitan bo' bine' uk sigam panohoan na!” ");
INSERT INTO slm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Manjari pasaplag magtuwi kabantugan si Isa ni kalohahan lahat Jalil hi'. ");
INSERT INTO slm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Puwas hi' paluwas di si Isa min langgal bo' magtuwi iya pahi' ni luma' di si Simun maka si Andariyas. Parōngan isab ma iya si Ya'kub maka si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na, matoa si Simun ma danda hi' pabahak sabab hinglaw iya. Jari kabaan peen si Isa pasal saki na, ");
INSERT INTO slm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","bo' pay'an iya ni tōngōd pabahakan na. Intanan uk si Isa tangan danda hi', tiyabang piyunduk. Manjari kaulian bayi hinglaw na bo' magbohat iya ngalabōt ma di si Isa. ");
INSERT INTO slm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Taabut peen saddōp 'llaw, biyo uk manga aa tudju ni si Isa sasuku magsakihan atawa siyōd uk sayitan. ");
INSERT INTO slm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Magkatipunan ma luwasan luma' hi' manga aa min daira ian kamemon. ");
INSERT INTO slm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Heka aa bayi kaulian uk si Isa iya kaginisan saki sigam, maka heka isab manga sayitan bayi piluwas uk na. 'Nsa' bayi pasaran na halling-halling manga sayitan ian sabab katauhan si Isa uk sigam bang sayi iya. ");
INSERT INTO slm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagsawung na, ma 'nsa' le' minsan pote' sōbangan, papunduk si Isa bo' pakallo' min luma'. Paluwas iya min diyōm daira pahi' ni jadjahan 'nsa' niya' aa na, bo' iya nambahayang mahi'. ");
INSERT INTO slm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na, pagka iya 'nsa' mahi' ma luma', peha iya uk di si Simun. ");
INSERT INTO slm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jari tatawwa' peen iya uk sigam, halling sigam ma iya, “Ian manga aa kamemon meha kau.” ");
INSERT INTO slm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nambung si Isa, uk na, “Sung kitabi palanjal ni kalumaan kasehean ma jadjahan itu hi'. Subay aku magnasihat isab mahi' sabab iya na hi' poon na hangkan aku paitu ni dunya.” ");
INSERT INTO slm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jari liyatag uk si Isa kalohahan lahat Jalil ian. Magnasihat iya ma diyōm kalanggalan sigam maka piluwas uk na manga sayitan min baran manga aa. ");
INSERT INTO slm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Manjari niya' aa ipul pahi' ni si Isa. Pasujud iya ma tōngōd si Isa, maka uk na nganjunjung, uk na, “Bang kau baya' kaulian nu du aku.” ");
INSERT INTO slm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Takkahan ase' si Isa ma aa ian bo' piabut uk na tangan na ni iya. “Baya' sadja aku,” uk na. “Kaulian du kau.” ");
INSERT INTO slm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saruun-duun du pakallo' ipul na. Kaulian na iya. ");
INSERT INTO slm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Magtuwi iya pibaid mowe' uk si Isa maka iyamay-amayan isab uk na. ");
INSERT INTO slm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Uk si Isa ma iya, “Daa kau ma'-ma' ni sayi-sayi iya bayi tahinang ku itu ma kau. Suga' pahi' kau magtuwi ni imam bo' palilingun baran nu ni iya. Puwas hi' ungsurin isab pagkulban ni Tuhan sali' bayi pamandu' uk si Musa, tanda' saksi' ni kahekahan aa in kau hi' lanu' na min saki nu.” ");
INSERT INTO slm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Suga' aa ian paluwas minnihi' maka uk na ma'-ma' tōōd pasal ipul na bayi kaulian. Pasaplag lapal na, hangkan si Isa 'nsa' na makapaluwas ma diyōm daira. May'an sadja iya ma jadjahan kulang aa na. Suga' pahi' na peen ni iya manga aa min kalahat-lahatan. ");
INSERT INTO slm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Palabay peen pila-pila 'llaw, pabing si Isa pahi' ni daira Kapirnaum bo' kihakahan uk manga aa in iya may'an na ma luma'. ");
INSERT INTO slm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jari landu' heka aa magtipun pay'an ni luma' pabōtangan si Isa iya hangkan 'nsa' niya' palabayan aa minsan ma luwasan ma bo' lawang. Pasalta' peen si Isa nganasihat lapal min Tuhan ma sigam, ");
INSERT INTO slm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","niya' pay'an ni iya 'mpat aa magtanggung aa matay baran na. ");
INSERT INTO slm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Suga' 'nsa' sigam makasikōt ni si Isa sabab heka aa ian iya hangkan sigam bayi ngalangkat atōp tōngōd min diyata' kok si Isa. Tahinang peen pasōran uk sigam, pitonton aa matay baran na ian pabahak le' ma diyata' pabahakan na. ");
INSERT INTO slm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Makatau peen si Isa in aa mananggung ian mangandōl du ma iya, halling na ni aa matay baran na, “Oto', iyampun na dusa nu.” ");
INSERT INTO slm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, niya' magtingkoan may'an manga guru ma sara' agama. Mikil-mikil sigam pasal bayi halling si Isa hi'. ");
INSERT INTO slm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Oy!” uk sigam. “Angay aa itu! Halling iya pangkal ni Tuhan magbissala salaihi'. 'Nsa' niya' makapag-ampun dusa, duwal Tuhan dakayo'-kayo'!” ");
INSERT INTO slm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Katauhan magtuwi uk si Isa bang ayi iya pikil uk sigam bo' uk na ma sigam, “Angay kaam magtiyaw-tiyaw salaiyu ma diyōm pikilan bi! ");
INSERT INTO slm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kumpasun bi bang ingga luhay: upamahun uk ku ma aa, ‘Iyampun na dusa nu’, atawa bang uk ku, ‘Papunduk kau, bohun pabahakan nu bo' kau mangngan na’? ");
INSERT INTO slm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na, buwanan ta kaam tanda' palsaksian bo' katauhan bi in aku, Anak Manusiya', taga kapatut du ngampun dusa ma diyōm dunya itu.” Jari halling si Isa ni aa matay baran na hi', uk na, ");
INSERT INTO slm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iya na itu halling ku ma kau: papunduk na kau. Bohun pabahakan nu iyu bo' kau mowe'.” ");
INSERT INTO slm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jari nangge aa ian maka biyo uk na magtuwi pabahakan na. Paluwas iya minnihi' ma panganda' manga aa ian kamemon. Landu' sigam inu-inu kamemon, bo' siyanglitan Tuhan uk sigam. Uk sigam, “Iyamboho' kitabi makanda' buttihi'.” ");
INSERT INTO slm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jari itu pahi' na isab si Isa pabing ni bihing danaw Jalil. Patipun pahi' ni iya manga aa heka bo' panduan na sigam. ");
INSERT INTO slm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pasalta' peen iya mangngan min bihing danaw, tanda' na si Libi anak si Alpa ningko' ma diyōm upis na, iya pagbayaran sukay parinta. Uk si Isa ma iya, “Paitu na kau me' ma aku.” Nangge magtuwi si Libi bo' me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pasōng-sōng, pagka si Isa mangan na ma luma' si Libi, heka manga aa magkallo' sukay parinta maka manga aa baldusa kasehean, ian sigam magsawu ni iya maka manga mulid na. Heka asal sigam bayi me' parōngan ma iya. ");
INSERT INTO slm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jari itu niya' may'an manga Parisi, guru ma sara' agama Yahudi. Pag'nda' sigam itu ma si Isa dangkakanan maka manga aa baldusa maka manga aa magkallo' sukay parinta, halling sigam ni manga mulid si Isa, uk na “Angay si Isa palamud magsawu maka aa dusahan iyu?” ");
INSERT INTO slm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Take uk si Isa iya paniyaw manga guru ian bo' uk na ma sigam, “Bang aa kowe' 'nsa' magdoktor. Iya magdoktor bang aa taga saki. 'Nsa' kau aa hap iya maksud ku paitu ni dunya, suga' iya pamaitu ku aa taga dusa bo' supaya sigam me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma dakayo' 'llaw, pasalta' peen magpuwasa manga mulid si Yahiya maka manga aa Parisi muwasa, niya' aa pahi' ni si Isa tiyaw iya. Uk sigam, “Magpuwasa manga mulid si Yahiya Magpapandi maka manga mulid Parisi, suga' mulid nu 'nsa' magpuwasa? Angay baha'?” ");
INSERT INTO slm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nambung si Isa magparalilan. In mulid na piralil ni aa maglurukan ma pagkawinan bo' uk na, “Magpuwasa baha' manga luruk samantala' may'an le' pangantin lalla ma tōngōd sigam? Tantu 'nsa'. 'Nsa' sigam magpuwasa sataggōl ma sigam pangantin lalla. ");
INSERT INTO slm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Suga' ma 'llaw siyong, bang taabut 'llaw pamakalloan pangantin lalla min sigam, iya na hi' waktu pagpuwasa sigam.” ");
INSERT INTO slm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Maralil le' si Isa pasal pamandu' tagna' maka pamandu' na, uk na, “'Nsa' niya' aa nupak kakana' bahu, 'nsa' bayi diyakdakan, ni badju' daan. Bang ganta' salaihi' hinang na pakinkin du tupak bahu bo' gese' min badju' daan hi'. Jari pamehe gam peen gese' na.” ");
INSERT INTO slm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Piralil isab pamandu' na ni inuman bahu bayi hinang, uk na, “'Nsa' niya' aa ngalōōn inuman bahu bayi hinang, masi-masi mukal, ni diyōm pangalōōnan daan. Bang ganta' salaihi' hinang na tantu bustak pangalōōnan uk inuman hi'. Tiyumpahan inuman bo' magkaat bayi pangalōōnan hi'. Suga' in inuman bahu bayi hinang subay liyōōn ni pangalōōnan bahu.” ");
INSERT INTO slm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma dakayo' 'llaw Sabtu', 'llaw paghali ni Tuhan bang ma agama Yahudi, ian di si Isa mangngan labay min tangnga' huma pananōman tirigu. Jari itu, pasalta' peen sigam maglangngan, niya' buwa' piyusu' uk manga mulid hi'. ");
INSERT INTO slm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Halling manga Parisi ni si Isa, uk sigam, “'Ndaun ba manga mulid nu iyu! Talanggal uk sigam sara' agama kitabi maghinang salaiyu ma 'llaw Sabtu'!” ");
INSERT INTO slm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Nambung si Isa, uk na, “Angay, 'nsa' bayi tabassa bi baha' bang ayi bayi tahinang uk si Daud ma masa si Abiyata bayi imam nakura'? Bayi giyōtas si Daud maka manga aa na pagka 'nsa' niya' ayi-ayi sigam. Jari si Daud bayi pasōd ni diyōm langgal pangaharapan Tuhan hi' bo' takakan na manga tinapay, iya pibōtang may'an pangungsud ni Tuhan. Na, bang ma agama kitabi, manga kaimaman du wajib mangan tinapay bayi iyungsuran ian, suga' kiyakan uk si Daud maka bayi pamuwan na isab ma manga sehe' na pagkakan sigam. Suga' 'nsa' iya bayi makarusa maghinang salaihi'. ");
INSERT INTO slm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","In 'llaw paghali itu,” uk si Isa ma manga Parisi ian, “bayi hinang uk Tuhan panabang ma manusiya'. 'Nsa' ma sabab 'llaw paghali subay pig-addatan iya hangkan manusiya' itu pipanjari. ");
INSERT INTO slm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aku itu, anak Manusiya', taga kapatut magbaya' bang ayi manjari hinang ma 'llaw paghali ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Manjari pabayik si Isa pasōd ni diyōm langgal. Niya' may'an aa komay dambiya' tangan na. ");
INSERT INTO slm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Niya' isab manga Parisi may'an meha pagsababan panuntut sigam ma si Isa, hangkan iya jiyagahan uk sigam bang kalu makowe' saki aa hi' ma 'llaw paghali. ");
INSERT INTO slm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jari halling si Isa ni aa komay dambiya' tangan na, uk na, “Paitu kau nangge ma tangngaan itu.” ");
INSERT INTO slm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Puwas hi' tīyaw uk si Isa manga aa hi', uk na, “Ayi iya patut hinang ma 'llaw paghali? Hinang makahap atawa hinang makalaat? Makallum aa atawa mapatay?” Suga' 'nsa' niya' panambung sigam. ");
INSERT INTO slm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Piyatong sigam dangan maka dangan uk si Isa. Ngandugal iya maka susa sabab tuwas atay sigam 'nsa' lasa ma aa. Jari halling na ma aa komay tangan na hi', “Pahannatun tangan nu iyu.” Na, pihannat uk na manjari kaulian na. ");
INSERT INTO slm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Paluwas magtuwi manga Parisi min langgal hi' bo' parayi'-dayi' sigam mag-isun maka manga bean si Sultan Herod bang salaingga uk sigam mapatay ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Manjari itu magpakallo' na si Isa maka manga mulid na tudju ni bihing danaw. Landu' heka aa bayi paturul ma iya. 'Nsa' min lahat Jalil sadja suga' min lahat Yahudiya isab ");
INSERT INTO slm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","maka min daira Awrusalam. Niya' isab aa min lahat Idumiya maka min dambiya' sapa' Jordan, maka min lahat ma jadjahan daira Tira maka Sidun. Manga aa heka itu pay'an ni si Isa sabab take na uk sigam pasal manga hinang bayi tahinang na. ");
INSERT INTO slm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jari siyoho' uk si Isa manga mulid na ngalabbōs bayanan pariyataan na bo' supaya iya 'nsa' tasigpit uk manga aa ian sabab heka kalandu'. ");
INSERT INTO slm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sabab heka aa bayi kaulian uk na, hangkan sasuku taga saki magtuyu' pasikōt na peen bo' supaya paabut tangan sigam ni iya. ");
INSERT INTO slm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pag'nda' isab manga aa siyōd uk sayitan ma iya, magtuwi pahantak sigam ma dahuhan na maka uk sigam ngōlang. Uk sigam, “Kau iyu Anak Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Suga' liyāng manga sayitan uk si Isa, daa siyoho' ma' ni sayi-sayi bang sayi iya. ");
INSERT INTO slm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Manjari itu nukad si Isa pahi' ni lorosan bud. Linganan uk na pay'an ni iya manga aa kabayaan na hinang na sehe' na bo' nukad sigam pahi' ni iya. ");
INSERT INTO slm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jari pene' uk na sangpu' ka duwa aa bo' iyōnan uk na sigam aa kawakilan na. Uk na ma sigam, “Kaam iyu bayi pene' ku nehean aku. Soho' ta du kaam mangngan isab magnasihat lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Piniyaan du kaam kawasa pamakalloan manga sayitan min diyōm baran aa.” ");
INSERT INTO slm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iya na itu ōn aa sangpu' ka duwa bayi tapene' ian uk si Isa: si Simun, iya bayi ōnan na isab si Petros, ");
INSERT INTO slm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","bo' si Ya'kub maka si Yahiya, manga anak si Sibidi. Diyanglay duwangan itu uk si Isa “Bowanerges”, hati na aa sali' dalil laggōn. ");
INSERT INTO slm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pasunu' si Andariyas maka si Pilip, si Bartolome maka si Matiyu, si Tomas maka si Ya'kub anak si Alpa. Pasunu' isab si Taddiyu, bo' si Simun aa pangangatu. ");
INSERT INTO slm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Katapusan si Judas Iskariyut iya nukbal si Isa ni manga banta na ma waktu damuwi minnihi'. ");
INSERT INTO slm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na, puwas hi', pabing di si Isa ni luma'. Suga' heka aa patipun pabing pay'an, iya poon di si Isa ian 'nsa' makahawulaya minsan mangan. ");
INSERT INTO slm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jari itu, pagka take uk manga maas-danakan si Isa pasal itu hi', pahi' sigam ngallo' iya. Sabab na pihalling-hallingan si Isa uk manga aa in pikilan na sagōt. ");
INSERT INTO slm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Niya' isab manga guru ma sara' agama bayi palud pay'an min Awrusalam. Ngupama sigam, uk na, “Si Isa itu siyōd uk Belsebul iya pagnakuraan manga sayitan, hangkan iya makapakallo' manga sayitan min diyōm baran aa.” ");
INSERT INTO slm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jari linganan manga aa ian uk si Isa, siyoho' pay'an ni iya, bo' magdalilan iya ma sigam, uk na, “Na, salaingga uk sayitan maluwasan sayitan? 'Nsa' makajari! ");
INSERT INTO slm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bang sawupama niya' pagsultanan bahagi' duwa manga aa na bo' magbono' sali'-sali', 'nsa' natas pagsultanan hi'. ");
INSERT INTO slm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Damikkiyan na bang niya' aa magdaōkōm bahagi' duwa bo' magsaggaan di sigam, magkawukanat sadja sigam. ");
INSERT INTO slm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hangkan na, bang nakura' sayitan magsagga' maka manga be'-bean na sayitan bo' bahagi' sigam duwa, 'nsa' du natas pagnakura' na. Lakkas du iya patōbtōb. ");
INSERT INTO slm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nakura' sayitan itu sali' dalil aa gaōs taga luma'. Luma' na 'nsa' tasōd, ayi-ayi na 'nsa' kalangpasan, duwal bang aa gaōsan ian ingkōtan dahu bo' iyampa kalangpasan diyōm luma' na. ");
INSERT INTO slm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Bannal iya pama' ku itu ma kaam,” uk si Isa. “Iyampun du uk Tuhan kamemon dusa manusiya' sampay halling sigam pangkal tudju ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Suga' bang Nyawa Sutsi iya pihallingan pangkal uk aa, 'nsa' tōōd niya' kaampunan aa ian sabab ngakkōt dusa na ma iya saumul-umul.” ");
INSERT INTO slm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hangkan salaihi' halling si Isa sabab niya' halling-halling in iya siyōd uk sayitan. ");
INSERT INTO slm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jari itu takka pay'an ina' si Isa maka manga danakan na lalla. Ngagad sigam ma luwasan luma' hi' bo' mabo sigam lapal ni si Isa subay paluwas. ");
INSERT INTO slm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na, heka aa magtingkoan ma katilibut si Isa. Uk sigam ma si Isa, “Tuwan, ian na ina' nu maka manga danakan nu ma luwasan. Meha kau kono'.” ");
INSERT INTO slm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nambung si Isa, uk na, “Sayi baha' kainaan ku maka sayi manga danakan ku?” ");
INSERT INTO slm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nganda' iya ma manga aa magtingkoan ma katilibut na bo' uk na, “Iya na ko' itu kainaan ku maka dawuranakan ku. ");
INSERT INTO slm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sabab sayi-sayi ngahinang kabayaan Tuhan, iya na ko' ian manga danakan ku lalla-danda maka kainaan ku.” ");
INSERT INTO slm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pabayik na isab si Isa mandu' ma bihing danaw Jalil. Heka aa bayi patipun may'an ni tōngōd na, heka kalandu', hangkan iya pariyata' ningko' ma bayanan bayi palayo asal may'an. Ian isab katipunan aa ma bihing parian. ");
INSERT INTO slm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jari heka pamandu' uk si Isa ma manga aa ian, pandu' pamaralilan. Salaitu pamandu' na, uk na, ");
INSERT INTO slm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pake kaam. Niya' ian dakayo' aa pahi' ni huma na nabōran bigi. ");
INSERT INTO slm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pagsabōd na itu, niya' bigi kasehean pakpak ni bihing daddōk. Sakali pay'an manga manuk-manuk nōtōk iya. ");
INSERT INTO slm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Niya' isab bigi kasehean pakpak ni kabatuhan datti' tana' na. Bigi ian hi' lakkas patomo' sabab 'nsa' lōm tana' na. ");
INSERT INTO slm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Suga' pasilak peen 'llaw, magtuwi lus ugbus na ian sampay lanōs sabab 'nsa' lōm gamut na. ");
INSERT INTO slm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Niya' du isab bigi pakpak ni tangnga' sōmpōt itingan. Makasubud peen sōmpōt ian, magtuwi kasimbōlan tiyanōm. Jari 'nsa' magbuwa'. ");
INSERT INTO slm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na, iya bigi kasehean hi' pakpak ni tana' hap. Manjari manga bigi itu hi' patomo' maka pasuwig bo' magbuwa' du hap. Niya' batang kasehean muwan buwa' sarang-sarang, niya' kasehean muwan buwa' heka, maka niya' isab kasehean muwan buwa' kalandu' tōōd heka na. ");
INSERT INTO slm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na,” uk si Isa, “sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Manjari itu, magpakalloan peen katipunan aa hi', patōngōd ni si Isa manga mulid na sangpu' ka duwa maka manga aa kasehean bayi may'an. Tīyaw iya uk sigam pasal kissa bayi pamaralil na ma sigam hi', bang ayi hati na. ");
INSERT INTO slm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nambung si Isa, uk na, “Kaam iyu kabuwanan pangatau bo' supaya tahati bi pasal kapagparinta Tuhan ma manga aa na, iya 'nsa' patau na ni manusiya' kasehean. Suga' manga aa kasehean, iya ma luwasan, subay kissahan manga kissa pamaralilan, ");
INSERT INTO slm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","supaya sigam pisali' ni bayi tasulat ma diyōm kitab, iya uk na, ‘Nganda' du sigam suga' 'nsa' sigam kanda'. Pake du sigam suga' 'nsa' sigam makahati. Bang bayi 'nsa' salaihi' bayi du sigam makanda' maka makahati, Bo' bayi du sigam pabayik magtaat ni Tuhan bo' iyampun uk na dusa sigam.’ ” ");
INSERT INTO slm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Na,” uk si Isa ma sigam, “'nsa' tahati bi baha' bayi pamaralil ku hi' ma kaam? Bang hi' 'nsa' tahati bi salaingga uk bi makahati ma pamaralilan kamemon iya pamandu' ku. ");
INSERT INTO slm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iya aa magsabōd bigi hi',” uk si Isa, “bang hiyati, iya na aa magnasihat palman Tuhan ma manusiya'. ");
INSERT INTO slm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maka manga aa kasehean sali' dalil daddōk bayi kapakpakan bigi ian. Pagtake peen sigam ma palman Tuhan magtuwi pay'an nakura' sayitan ngandagtu' palman Tuhan iya bayi tiyanōm ma diyōm atay sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Manga aa kasehean sali' dalil tana' kabatuhan bayi kapakpakan bigi ian. Pagtake sigam ma palman Tuhan, magtuwi tayima' uk sigam maka kiyōgan sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Suga' palman Tuhan itu 'nsa' bayi nganggamut palōm ma diyōm atay sigam, hangkan pag-iman sigam 'nsa' natas taggōl. Taabut peen sigam takkahan susa atawa liyaat uk pagkahi sigam ma sabab pame' sigam ma palman Tuhan, magtuwi sigam ngalabba min pag-iman sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Manga aa kasehean isab sali' dalil tana' bayi katomoan sōmpōt itingan. Take uk sigam palman Tuhan, ");
INSERT INTO slm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","suga' limbit pikilan sigam uk kahalan diyōm dunya itu. Iya na peen halgaan ma sigam pangalta' sigam maka ayi-ayi kinapsuhan uk sigam. Jari palman Tuhan 'nsa' magbuwa' ma diyōm atay sigam, sali' dalil tiyanōm bang kasimbōlan uk sōmpōt. ");
INSERT INTO slm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Suga' manga aa kasehean sali' dalil tana' hap. Take uk sigam palman Tuhan bo' tayima' uk sigam. Jari magbuwa' du palman Tuhan ma diyōm atay sigam, sali' dalil tiyanōm. Kasehean muwan buwa' sarang-sarang heka na, kasehean buwa' heka, maka kasehean isab muwan buwa' landu' tōōd heka na.” ");
INSERT INTO slm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Halling isab si Isa ma sigam, uk na, “Niya' baha' magpalitaan bo' liyōkōban uk na maka undam atawa pabōtang na ma deyo' kantil? Tantu 'nsa'. Subay pabōtang na ma diyata' papagan na. ");
INSERT INTO slm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bang itu diyalil,” uk na, “ayi-ayi kamemon tapukan ma buttihi' piluwas du ma sosongun, maka ayi-ayi 'nsa' tahati ma buttihi' tahati du ma waktu siyong. ");
INSERT INTO slm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Uk si Isa isab ma sigam, “Isbatun bi pahap-hap ayi-ayi take bi sabab bang hap pangisbat bi hap isab palsukuan iya piniyaan kaam, maka kinnōpan le' ma kaam. ");
INSERT INTO slm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hati na itu bang aa niya' tatau na kinnōpan le' tau na. Suga' sayi-sayi 'nsa' makahati bo' peen pangannal na niya' panghati na datti', kiyulangan du min iya.” ");
INSERT INTO slm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mandu' le' si Isa, uk na, “Salaitu isab pagparinta Tuhan ma manusiya': iya dalil na sali' bigi siyabōran uk aa ma tana' na. ");
INSERT INTO slm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ubus peen uk na nabōd, tuwi iya ma waktu sangōm bo' bati' bang 'llaw maghinang hinang na kasehean. Jari bigi bayi sabōran na patomo' maka pasuwigan di na, suga' 'nsa' kitauhan uk aa ian bang salaingga kasuwig na. ");
INSERT INTO slm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Patomo' asal bigi pagka ma diyōm tana' na, bo' pasong muwan buwa'. Tagna' pauplut, bo' magsuring du bo' magbuwa' tiguma'. ");
INSERT INTO slm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pagtahak peen buwa' itu, magtuwi siyoho' piyusu' uk aa dapu tana' sabab taabut na waktu na.” ");
INSERT INTO slm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mandu' le' si Isa, uk na, “Ayi pamasalian kitabi pagparinta Tuhan ma manusiya'? Bang uk dalil ta, ayi pamaralilan kitabi? ");
INSERT INTO slm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Iya pagparinta Tuhan ma manusiya',” uk si Isa, “sali' dalil dakayo' bigi diki'-diki'. Tagna' tiyanōm bigi itu ma diyōm tana' nahut asal min bigi kamemon ma diyōm dunya. ");
INSERT INTO slm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Suga' pagtanōm peen tomo' du bo' palabi mehe na min tiyanōm kamemon. Paaslag manga senga na, hangkan makajari manga manuk-manuk ngahinang pugaran may'an ma sindungan na.” ");
INSERT INTO slm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Heka manga paralilan salaihi' bayi pagguna uk si Isa pagnasihat na ma manga aa, ingga-ingga iya takannal uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'Nsa' iya missala ma manga aa kasehean bang 'nsa' paralilan iya pamissala na. Suga' bang iya sadja maka manga mulid na, pihati uk na bissala na kamemon ma sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Manjari itu ma 'llaw ian hi', bo' song kohap na, halling si Isa ma manga mulid na. “Sung kitabi,” uk na, “pauntas ni dambiya' danaw hi'.” ");
INSERT INTO slm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Imbanan uk na kahekahan aa ian bo' pariyata' manga mulid ian ni bayanan iya asal paningkoan si Isa. Jari biyo iya uk sigam. Niya' isab manga bayanan kasehean paabay ma sigam. ");
INSERT INTO slm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sakali itu niya' hunus parugpak ni danaw ian. Song na sigam buhaw sabab liyasay uk goyak. ");
INSERT INTO slm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bo' si Isa iya ian ma buwi', tuwi maka uan na. Na, biyati' iya uk manga mulid na. “Tuwan Guru,” uk sigam, “'nsa' kau susa baha'? Tiya' kitabi song lembo!” ");
INSERT INTO slm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jari papunduk si Isa bo' iyampa soho' na baliyu maka goyak ian parōhōng. “Sarang na,” uk na ma danaw. “Pataddo' kau!” Magtuwi parōhōng baliyu maka taddo' na danaw ian tōōd. ");
INSERT INTO slm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Uk na isab ma manga mulid na, “Angay kaam tiyāw? 'Nsa' le' kaam mangandōl baha' ma aku?” ");
INSERT INTO slm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Suga' bidda' sigam takkahan tāw, hangkan sigam magtiyaw-tiyaw di sigam, uk na hi', “Sayi baha' aa itu? Minsan baliyu maka goyak me' du ma panohoan na!” ");
INSERT INTO slm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Manjari itu parunggu' di si Isa ni dambiya' danaw Jalil, ni lahat manga aa Gerasa. ");
INSERT INTO slm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagduwai peen si Isa ni bihingan niya' pasampang ni iya dangan aa bayi paluwas min diyōm kakubulan may'an, aa siyōd uk sayitan. ");
INSERT INTO slm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pabōtang asal aa itu ma diyōm kakubulan. 'Nsa' iya kaingkōtan uk aa minsan ekang-ekang basi' iya pangingkōt ma iya. ");
INSERT INTO slm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Min heka iya bayi ingkōtan ma nayi'-tangan na suga' bakkat sadja uk na manga ekang-ekang ma tangan na. Iyōkat isab uk na ingkōt nayi' na bo' 'nsa' niya' makahawiran iya sabab kōsōg na. ");
INSERT INTO slm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Iya sadja hinang na 'llaw-sangōm magpahi'-paitu ma diyōm kakubulan maka ma kabūd-būran. Ngōlang na peen iya pakōsōg sampay ngages di na maka batu. ");
INSERT INTO slm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na, pag'nda' aa itu ma si Isa min katahan le', paragan iya bo' pasujud ma dahuhan na. ");
INSERT INTO slm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kōsōg pangalingan na ma si Isa, uk na, “O Isa, Anak Tuhan Mahatinggi! Ayi lamud nu ma aku? Pasapa ta kau ma ōn Tuhan: daa aku binsanaun.” ");
INSERT INTO slm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hangkan salaihi' junjung na sabab panohoan si Isa ma sayitan hi', iya uk na, “Pakallo' kau min diyōm baran aa iyu, sayitan!” ");
INSERT INTO slm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tiyaw iya uk si Isa, uk na, “Sayi ōn nu?” Uk sambung na, “Ōn ku si Laksaan sabab kami itu asal heka.” ");
INSERT INTO slm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bo' ngamu'-ngamu' na peen manga sayitan ian ma si Isa bang peen 'nsa' pipakallo' min lahat ian hi'. ");
INSERT INTO slm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jari niya' baanan koret magkakan may'an ma luran bud, landu' heka. ");
INSERT INTO slm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sakali ngamu'-ngamu' manga sayitan ma si Isa, uk na hi', “Sohoun kami pahi' ni manga koret ian bo' pasōrun kami ni diyōm baran sigam.” ");
INSERT INTO slm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, pibaid uk si Isa manga sayitan ian bo' paluwas sigam min baran aa bo' iyampa pasōd ni diyōm baran manga koret. Magtuwi maglompatan paragan manga baanan koret ian min pampang tudju ni diyōm danaw bo' iyampa lembo kamemon. Manga koret maglembohan ian niya' kulang-labi duwangibu heka na. ");
INSERT INTO slm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pag'nda' itu uk manga aa bayi ngipat koret ian, paragan sigam pahi' ni daira maka ni kalumaan manga aa maghuma ma'-ma' ma manga aa mahi'. Jari pahi' manga aa minnihi' bo' tanda' uk sigam bang ayi bayi tahinang ian. ");
INSERT INTO slm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagtakka sigam ni tōngōd si Isa, tanda' uk sigam aa bayi siyōd uk sayitan laksaan hi'. Ian iya ningko'. Magsammek na iya maka hap na akkal-pikilan na. Jari tiyāw na sigam. ");
INSERT INTO slm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Biya'-baan isab sigam uk manga aa bayi makanda' pasal bayi tahinang ma aa siyōd uk sayitan hi' maka ma pasal manga koret. ");
INSERT INTO slm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jari ngamu'-ngamu' manga aa ian ma si Isa bang peen pakallo' min lahat sigam. ");
INSERT INTO slm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Manjari itu, pasalta' peen si Isa pariyata' ni bayanan, ngamu' aa bayi siyōd uk sayitan me' ma iya. ");
INSERT INTO slm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Suga' 'nsa' siyoho' si Isa. Uk na ma aa ian, “Mowe' na kau ni lahat nu, ni manga usba-waris nu. Bain sigam pasal hinang mehe bayi tahinang uk Tuhan ma kau maka pasal kaase' na ma kau.” ");
INSERT INTO slm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Manjari pakallo' na aa ian minnihi' ngalatag lahat iyōnan Sangpu' Daira bo' pasaplag na ma manga aa mahi' pasal hinang mehe bayi tahinang ma iya uk si Isa. Bo' inu-inu ma iya manga aa kamemon. ");
INSERT INTO slm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na, pabing si Isa pahi' ni dambiya' danaw Jalil. Pagtakka na ni bihing, heka tōōd isab manga aa patipun ni iya. ");
INSERT INTO slm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Niya' pay'an ni iya dakayo' nakura' ma langgal hi', ōn na si Jairus. Pag'nda' na ma si Isa, pasujud iya pay'an ni tōngōd nayi' na ");
INSERT INTO slm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ngamu'-ngamu' ma iya. “Tuwan,” uk na ni si Isa, “marayi' na matay anak ku danda. Dayi' le' kau mabōtang tangan nu ma iya bo' kaulian saki na bo' 'llum.” ");
INSERT INTO slm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sakali me' si Isa ma iya. Heka tōōd manga aa parōngan isab ma iya, hangkan bidda' kasimbōlan. ");
INSERT INTO slm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, niya' may'an dakayo' danda sakihan. Sangpu' ka duwan tahun na 'nsa' parōhōng laha' na. ");
INSERT INTO slm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Minsan heka doktor bayi kalabayan na sampay ubus na sin na kamemon panamba, 'nsa' niya' kaulian na. Pasong sadja saki na. ");
INSERT INTO slm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Manjari kine uk danda itu lapal pasal si Isa, hangkan iya palamud ma baanan aa ian bo' pasikōt iya ni si Isa min damuwihan na. ");
INSERT INTO slm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Halling-halling iya ma di na, uk na, “Bang peen tasagid ku minsan laa tong sammek na sadja, kaulian du saki ku.” ");
INSERT INTO slm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pagsagid na, saruun-duun du parōhōng laha' na bo' tananam na ma diyōm baran na in iya kaulian na. ");
INSERT INTO slm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Magtuwi tasayu isab uk si Isa niya' barakat bayi paluwas min baran na bo' parōhōng iya palingi' ni manga aa ma bukutan na. Halling iya ma sigam, uk na, “Sayi bayi ngantanan aku?” ");
INSERT INTO slm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Uk manga mulid na ma iya, “Tanda' nu na, Tuwan, heka aa pasigpit itu ni kau! Bo' tiyaw uk nu le' bang sayi ngantanan kau!” ");
INSERT INTO slm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Suga' nganda'-nganda' le' si Isa meha bang sayi bayi ngantanan iya. ");
INSERT INTO slm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jari danda ian, pagka katauhan na in baran na kaulian na, pahi' ni si Isa maka uk na midpid sabab landu' iya tiyāw. Pasujud iya ma tōngōd nayi' si Isa bo' ma' iya magsabannal. ");
INSERT INTO slm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Uk si Isa ma iya, “Inda', kaulian na kau ma sabab pangandōl nu ma aku. Pahi' na kau, daa kau susa. Iya saki nu iyu kaulian na tōōd.” ");
INSERT INTO slm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Manjari itu, pasalta' peen si Isa missala ni danda, niya' manga aa takka pay'an min luma' si Jairus mo lapal. Uk sigam ni si Jairus hi', “Matay na anak nu. Daa na pamaleun guru iyu!” ");
INSERT INTO slm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Suga' 'nsa' iyasip uk si Isa halling sigam hi'. Uk na ni si Jairus, “Daa kau tiyāw, mangandōl sadja kau.” ");
INSERT INTO slm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jari 'nsa' niya' diyulan uk si Isa pabe' ma iya, duwal si Petros maka duwangan magdanakan hi', si Ya'kub maka si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Makatakka peen sigam pahi' ni luma' si Jairus, tanda' na manga aa maghiluhala'. Magtangisan sigam maka magtallik pakōsōg. ");
INSERT INTO slm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pasōd si Isa ni diyōm luma' bo' uk na ma manga aa may'an, “Magay kaam maghiluhala' maka magtangis? 'Nsa' du matay onde' iyu. Tuwi iya sadja.” ");
INSERT INTO slm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sakali pigtattohan iya uk sigam, hangkan sigam soho' na paluwas kamemon. Biyo uk na ina'-mma' onde' maka mulid na tallungan pasōd ni diyōm bilik iya kamahian onde' hi'. ");
INSERT INTO slm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Intanan uk na tangan onde' bo' uk na ni iya ma sali' bahasa sigam, “Talita kum.” Hati na ma bahasa tabi, “Inda', soho' ta kau papunduk.” ");
INSERT INTO slm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Saruun-duun du papunduk onde' ian bo' mangngan na ma diyōm luma'. Umul na sangpu' ka duwan tahun. Jari inu-inu sigam ian tōōd. ");
INSERT INTO slm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Suga' siyoho' sigam uk si Isa daa subay ma' ni sayi-sayi pasal ian hi'. Siyoho' uk na isab subay piyakan onde'. ");
INSERT INTO slm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pakallo' si Isa minnihi' bo' pabing ni daira Nasaret iya asal lahat na. Me' ma iya manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Manjari itu, pag'llaw Sabtu' na, 'llaw mulliya ma bangsa Yahudi, nagna' iya mandu' ma diyōm langgal. Heka aa asal may'an pake ma iya bo' inu-inu sigam ma pamandu' na. Uk sigam, “Oy! Minningga baha' pangalloan na pangadji' na itu? Pangatau ayi baha' bayi pamuwan ma iya? Salaingga pangahinang na manga hinang na kawasahan hi'? ");
INSERT INTO slm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bang kami 'nsa' lupa iya na itu karpentero, anak si Mariyam! Manga danakan na di si Ya'kub maka si Joses maka si Judas maka si Simun. Maka danakan na danda tiya' na isab ma lungan ta itu.” Bo' kalaatan sigam atay ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hangkan halling si Isa ma sigam, “In nabi pig-addatan asal ma sabarang lahat. Iya sadja 'nsa' mag-addat ma iya bang aa min lahat na asal maka manga lahasiya' na maka manga sehe' na magdaluma'.” ");
INSERT INTO slm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jari 'nsa' niya' hinang makainu-inu tahinang uk si Isa mahi'. Hangkan datti' du manga aa sakihan bayi pabōtangan na tangan na bo' kaulian. ");
INSERT INTO slm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Inu-inu tōōd iya bang angay manga aa may'an 'nsa' mangandōl ma iya. Na, talatag uk si Isa manga kalumaan ma jadjahan ian hi' manduan manga aa. ");
INSERT INTO slm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Manjari linganan uk na manga mulid na sangpu' ka duwa pahi' ni iya, bo' soho' na sigam mangngan duwang-duwangan magnasihat lapal Tuhan. Bayi sigam buwanan na kawasa pamakallo' manga sayitan min diyōm baran aa, ");
INSERT INTO slm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","bo' soho' na sigam daa subay mo lutu' atawa bag atawa sin ma diyōm sabitan sigam. Duwal tungkud iya makajari biyo uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Makajari kono' sigam magtawumpa', suga' 'nsa' sigam siyoho' mo badju' pagsayinan. ");
INSERT INTO slm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Uk si Isa ma sigam, “Bang kaam ganta' siyagina uk aa siyoho' pasōd ni luma' na, subay may'an pahantian bi sampay taabut waktu pakallo' bi min lahat ian hi'. ");
INSERT INTO slm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maka bang niya' lahat patakkahan bi bo' 'nsa' nagina kaam manga aa na, atawa 'nsa' baya' pake ma kaam, pakallo' kaam min kalumaan ian. Paspasin bi dahu bagunbun na min nayi' bi, tanda' saksi' in kaam puwas min sigam.” ");
INSERT INTO slm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jari maglangngan manga mulid ian magnasihat. Uk pagnasihat sigam in manusiya' subay ngalabba tōōd min dusa sigam sampay papinda ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Heka manga sayitan bayi tapakallo' uk manga mulid hi' min diyōm baran aa, maka heka aa sakihan bayi panapuhan 'nsallan uk sigam manjari kaulian. ");
INSERT INTO slm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Manjari itu take uk si Sultan Herod pasal kamemon iya tahinang uk si Isa ian, sabab bantug ōn si Isa ma kalahat-lahatan. Mag-upama manga aa ma pasal na. Niya' aa kasehean maghalling, uk sigam hi', “Si Yahiya Magpapandi pikallum na pabing min kamatay na iya hangkan tahinang na manga hinang na kawasahan ian.” ");
INSERT INTO slm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Suga' uk aa kasehean, “Si Nabi Eliyas ko' ian!” Niya' isab aa kasehean maghalling, uk sigam hi', “Nabi ko' ian sali' manga kanabi-nabihan bayi ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Suga' pagtake itu uk si Herod, uk na, “Si Yahiya ko' ian, iya bayi soho' ku piyonggolan kok na. 'Llum na iya pabing.” ");
INSERT INTO slm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hangkan salaihi' halling si Herod sabab iya iya bayi magpanohoan naggaw si Yahiya. Siyoho' iya iyekang-ekangan bo' iyampa liyōōn ni diyōm jil. Salaitu iya kahalan na: si Sultan Herod itu bayi ngahanda si Herodiyas handa siyay na si Pilip, bo' peen 'llum le' si Pilip hi'. Manjari itu, pagka magdakayo' na sigam, pihallingan sultan itu uk si Yahiya. Halling si Yahiya, “'Nsa' manjari bang kau magdakayo' maka handa danakan nu! Dusahan kau!” ");
INSERT INTO slm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na, iya ian sababan na hangkan si Herodiyas taga laat ma diyōm atay na tudju ni si Yahiya. Baya' mapatay iya. Suga' 'nsa' iya karulan sabab ");
INSERT INTO slm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","lōman si Herod ma si Yahiya. Katauhan na asal in si Yahiya aa bōntōl maka adil. Hangkan iya bayi jiyagahan uk si Herod, liyōōn ni diyōm jil bo' 'nsa' inay. Siyōban si Herod pake ma pagnasihat si Yahiya suga' pagtake na sasaw diyōm pikilan na. ");
INSERT INTO slm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sakali itu niya' 'llaw pamarul kabayaan si Herodiyas. Taabut peen 'llaw pangintōman kapag-anak si Sultan Herod, magpajamu iya ma manga sehe' ma pagsultanan na, maka ma manga nakura' kasundaluhan na, maka ma manga aa taga ōn ma lahat Jalil hi'. ");
INSERT INTO slm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na, makapagtipun peen may'an sigam kamemon, pasōd pay'an anak si Herodiyas ngiluk bo' landu' kasulutan si Herod maka manga aa maglurukan hi'. Jari missala sultan ni budjang hi', uk na, “Ngamu' sadja kau. Ayi-ayi kabayaan nu, pamuwan ku du ma kau.” ");
INSERT INTO slm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Napa le' iya, uk na, “Sapahan ta kau, ayi-ayi amu' nu ni aku, pamuwan ku tōōd ma kau minsan santōnga' alta' ku kamemon.” ");
INSERT INTO slm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Paluwas budjang minnihi' bo' tiyaw na ina' na. “Ina',” uk na, “ayi subay amu' ku?” Nambung ina' na, uk na, “Amuun kok si Yahiya Magpapandi.” ");
INSERT INTO slm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Magtuwi parayi'-dayi' budjang hi' pabing pay'an ni sultan ngamu', uk na, “Appa', iya itu amu' ku ni kau: pamuwanun ma aku saruun-duun kok si Yahiya Magpapandi pibōtang ma diyata' talam!” ");
INSERT INTO slm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Landu' na tōōd susa sultan suga' 'nsa' iya baya' mindahan janji' na sabab bayi iya napa ma alōpan manga luruk hi'. ");
INSERT INTO slm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Magtuwi iya magpanohoan ma dakayo' sundalu min manga jaga na. Siyoho' iya pahi' ngallo' kok si Yahiya. Jari pahi' na sundalu monggolan kok si Yahiya ma diyōm jil. ");
INSERT INTO slm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Puwas hi' pibōtang uk na ma talam bo' iyampa bo na pahi' ni budjang hi'. Jari siyongan isab uk budjang ni ina' na. ");
INSERT INTO slm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Makake peen manga mulid si Yahiya pasal ian hi', pahi' sigam ngallo' patay na kiyubul. ");
INSERT INTO slm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na, pabing ni si Isa manga aa bayi kawakilan na. Biyaan iya uk sigam pasal kamemon bayi tahinang sigam maka bayi tapamandu' sigam ma manga aa. ");
INSERT INTO slm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Heka aa magpahi'-paitu ma tōngōd ian, iya poon sigam 'nsa' makahawulaya minsan magkakan. Hangkan uk si Isa ni sigam, “Sung kitabi pahi' ni lahat 'nsa' mag-aa, kita-kitabi sadja, bo' supaya kaam makahali-hali dayi'-dayi'.” ");
INSERT INTO slm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jari musay sigam minnihi' tudju ni lahat lau-lau, sigam-sigam sadja. ");
INSERT INTO slm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Suga' heka aa bayi makanda' katulak sigam, magtuwi sigam takila. Manjari paragan manga aa min kalumaan ian kamemon, maklay min bihing susulan tudju ni patakkahan di si Isa bo' takka sigam pahi' dahu min iya. ");
INSERT INTO slm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagduwai peen si Isa, tanda' na baanan manga aa itu, landu' tōōd heka. Takkahan iya ase' ma sigam sabab sali' sigam sapantun manga bili-bili 'nsa' niya' ngipat sigam. Jari heka pamandu' na ma sigam. ");
INSERT INTO slm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagka song kohap na pahi' ni si Isa manga mulid na. Uk sigam, “Song sangōm na, maka tiya' kitabi ma lahat lau-lau. ");
INSERT INTO slm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sohoun kono' baanan aa itu pahi' ni luma' manga aa tunggu' huma maka ni manga kalumaan ma kare-rehan itu bo' makaballihan di sigam kiyakan.” ");
INSERT INTO slm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Suga' salaitu iya halling si Isa ma manga mulid hi': “Kaam na iya makan sigam,” uk na. Uk sigam ma iya, “E! Baanan aa itu, subay tamba aa bayi mag-usaha ma diyōm walum bulan bo' makaballihan sigam tinapay! Bo' soho' nu kami baha' malli?” ");
INSERT INTO slm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tiyaw si Isa ma sigam, uk na, “Pila heka tinapay bi iyu? 'Ndaun bi kono' pahi'.” Pagtau peen, uk sigam, “Lima du tinapay maka duwa daying-daying.” ");
INSERT INTO slm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Manjari magpanohoan si Isa ma manga mulid na. Siyoho' pitingko' manga aa ian kamemon magbaan-baan ma kaparangan. ");
INSERT INTO slm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Magtingkoan na sigam magbaan-baan, niya' limampu'-limampu', niya' dahatus-dahatus ma dambaanan. ");
INSERT INTO slm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jari killo' uk si Isa lima tinapay hi' maka duwa daying-daying bo' iyampa pahangad tudju ni langit magsukul ni Tuhan. Pighopo'-hopo' uk na tinapay bo' songan na ni manga mulid na. Siyoho' biyohatan manga aa. Iya du duwa daying-daying bayi pigbahagi'-bahagi' uk na isab ma sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Magkakanan na aa ian kamemon sampay maglassohan na. ");
INSERT INTO slm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pag-ubus sigam mangan, tipun uk manga mulid kapin tinapay maka daying, bo' panno' sangpu' ka duwa ambung mehe. ");
INSERT INTO slm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iya aa bayi mangan ian niya' sigam manga limangibu bang lalla sadja itung. ");
INSERT INTO slm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Puwas ian magtuwi noho' si Isa ma manga mulid na subay pariyata' ni bayanan. Pirahu sigam uk na pauntas ni dambiya' danaw ni daira Betsaida, sabu na mapowe' kahekahan aa ian. ");
INSERT INTO slm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tapapowe' peen manga aa hi', patukad si Isa nambahayang ma bud-bud. ");
INSERT INTO slm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sangōm peen lahat, ian manga mulid na ma tangnga' danaw bo' si Isa iya ian ma de didi na. ");
INSERT INTO slm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tanda' na manga mulid na kahunitan musay sabab nagga' sigam baliyu. Jari itu, pagdayi' 'llaw peen, pahi' iya tudju ni sigam mangngan min kuwit tahik. Arak sigam labayan na, ");
INSERT INTO slm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","suga' tanda' iya uk sigam mangngan ma kuwit tahik bo' pangannal sigam lutaw. Magsuwalak sigam tōōd, ");
INSERT INTO slm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sabab tiyāw sigam kamemon pag'nda' sigam ma iya. Suga' missala magtuwi si Isa ma sigam. “Paiman kaam,” uk na, “Aku na ko' itu. Daa kaam tiyāw.” ");
INSERT INTO slm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jari pasakat si Isa ni diyata' bayanan patōngōd ni manga mulid hi'. Pagsakat na peen parōhōng baliyu bo' haylan tōōd sigam. ");
INSERT INTO slm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sabab na, minsan bayi tanda' uk sigam kawasa si Isa pamakan na manga aa limangibu hi', 'nsa' le' tahati uk sigam bang ayi tōōd maana na. Masi sigam tuwas piyanduan. ");
INSERT INTO slm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jari itu, makatakka peen sigam ni dambiya' danaw ni lahat Gennesaret, parunggu' sigam ni bihing ian. ");
INSERT INTO slm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagduwai peen sigam min bayanan, takila magtuwi si Isa uk manga aa ");
INSERT INTO slm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bo' paragan sigam ngalatag kalahatan ma jadjahan ian hi'. Jari biyo uk sigam manga aa taga saki maka pabahakan sigam, maingga-maingga lahat iya kamahian si Isa, basta kitauhan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maingga-maingga katakkahan na, ma kalumaan, atawa ma daira mehe, atawa ma lahat de, pibahak uk sigam manga aa saki ma halaman tabu'. Bo' ngamu' sigam junjung ni si Isa, bang peen taantan na manga aa sakihan minsan laa ma bihing sammek na sadja. Manjari sayi-sayi bayi makaantan ma sammek si Isa kaulian du saki na. ");
INSERT INTO slm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Manjari itu niya' patipun ni si Isa manga Parisi maka manga guru sara' agama bayi palud pay'an min Awrusalam. ");
INSERT INTO slm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tanda' uk sigam manga mulid si Isa mangan bo' 'nsa' bayi ngose' tangan sigam. Haram kono' sigam sabab 'nsa' me' ma addat maka pamandu' manga Parisi subay nutsi tangan pahap-hap. ");
INSERT INTO slm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Iya addat manga Parisi maka kamemon bangsa sigam Yahudi, 'nsa' sigam mangan bang 'nsa' bayi pangosean tangan sigam dahu, supaya mōgbōg usulan bayi pangamban uk ka'mbo'-mboan sigam. ");
INSERT INTO slm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bang sigam tapowe' min tabu' 'nsa' sigam mangan bang 'nsa' ngose' salaihi' dahu. Heka le' isab manga usulan kaginisan biyōgbōgan uk sigam, sali' pagkose' manga sawan maka sili' maka kaliru tumbaga. ");
INSERT INTO slm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hangkan si Isa tīyaw uk manga Parisi maka manga guru ma sara' agama ian. Uk tiyaw hi', “Angay manga mulid nu 'nsa' mōgbōg ma usulan bayi pangamban uk ka'mbo'-mboan tabi bo' mangan sigam minsan 'nsa' bayi siyutsi tangan sigam dahu?” ");
INSERT INTO slm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nambung si Isa, uk na, “Kaam iyu magbawu'-bawu' sadja in kaam me' ma Tuhan, bo' 'nsa'. Asal bannal du iya bayi tasulat uk si Isaya ma diyōm kitab, iya uk na hi', ‘Manga aa itu, uk Tuhan, ngahulmat aku maka lapal kabtangan sigam, Suga' lawak diyōm atay sigam min aku. ");
INSERT INTO slm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iya pagpudji sigam ma aku 'nsa' niya' pus na, Sabab iya pamandu' uk sigam panohoan bayi pighinang uk manusiya' sadja, 'Nsa' deyo' bayi min aku.’ ");
INSERT INTO slm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Iya du kaam,” uk si Isa, “nayikutan panohoan Tuhan bo' usulan manusiya' iya bōgbōgan bi na peen. ");
INSERT INTO slm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Panday kaam pahap!” uk na. “Tayikutan bi panohoan Tuhan supaya bōgbōgan bi manga usulan bayi pangamban uk kamaasan bi! ");
INSERT INTO slm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sabab malman Tuhan ma diyōm sara' bayi pamuwan ma si Musa, iya uk na hi', ‘Wajib kaam mag-addatan 'mma' bi maka ina' bi.’ Maka itu le', ‘Sayi-sayi mahallingan laat ma 'mma' na atawa ina' na, aa ian subay piyatay.’ ");
INSERT INTO slm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Suga' kaam,” uk si Isa, “magsaddi-saddi iya pamandu' bi ma manga aa. Ma pamandu' bi, bang niya' ganta' missala ni ina'-mma' na, uk na ‘'Mma' atawa Ina', in alta' ku itu iya arak bayi panabang ku ma kau, 'nsa' na sabab pasuku' ku na ni Tuhan.’ ");
INSERT INTO slm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na, bang salaihi' pamissala aa,” uk si Isa, “'nsa' na iya pahinang bi ayi-ayi panabang na ma 'mma' na atawa ina' na. ");
INSERT INTO slm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Manjari minnihi' papasan bi di panohoan Tuhan pagka panduan bi manga usulan bayi pangamban uk ka'mbo'-mboan bi. Maka heka le' isab manga hinang bi salaihi'.” ");
INSERT INTO slm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Puwas hi' linganan baanan aa ian uk si Isa, siyoho' patipun pabing ni tōngōd na. Uk na ma sigam, “Pake kaam kamemon ma bissala ku bo' kaam kahati tōōd. ");
INSERT INTO slm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'Nsa' kiyakan pasōd ni diyōm baran aa iya makatamak iya. Suga' iya makatamak iya manga ayi-ayi iya paluwas min diyōm atay na. ");
INSERT INTO slm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jari makapakallo' peen si Isa min manga aa ian, pasōd iya ni diyōm luma'. Tiyaw iya uk manga mulid na pasal bayi pamandu' na hi'. ");
INSERT INTO slm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uk na ma sigam, “Kaam isab, 'nsa' tasayu bi? 'Nsa' tahati bi baha'? Bang niya' kiyakan pasōd ni diyōm baran aa bayi min luwasan, 'nsa' du makatamak iya. ");
INSERT INTO slm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sabab na 'nsa' makasōd ni diyōm atay na suga' pasampay sadja ni diyōm battōng na bo' iyampa paluwas min baran na.” Minnihi' tapahati uk si Isa in kiyakan kamemon halal asal. ");
INSERT INTO slm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Uk si Isa le', “Iya paluwas min diyōm atay manusiya', iya hi' makatamak iya. ");
INSERT INTO slm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sabab min diyōm na, min diyōm atay na tōōd, iya paluwasan hōna'-hōna' na laat. Hangkan iya maghinang kalaatan sali' manga ngahinang kasabulan ma danda, manga nangkaw, mapatay, magjina, ");
INSERT INTO slm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nganapsu ma alta' aa, ngakkal, magbais-bais, ngimbu, ngalimut, magpalangkaw, maka manga magkarupangan. ");
INSERT INTO slm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Manga laat itu kamemon,” uk si Isa, “paluwas min diyōm atay aa bo' makatamak iya.” ");
INSERT INTO slm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jari palanjal si Isa minnihi' tudju ni jadjahan daira Tira. Mahi' peen, pasōd iya ni diyōm dakayo' luma' pahanti' mahi'. Kabayaan na subay 'nsa' niya' makatau in iya mahi' suga' 'nsa' kapaglimbuhan. ");
INSERT INTO slm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Niya' danda may'an bayi makake pasal si Isa. Danda itu taga anak danda-danda siyōd uk sayitan asal. Jari pagtake na pasal kamahi' si Isa magtuwi iya pahi' pasujud ni tōngōd nayi' na. ");
INSERT INTO slm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","'Nsa' Yahudi danda itu suga' bangsa Pinisiya, min lahat Siriya. Jari ngamu' iya junjung ni si Isa bang peen pakallo' na sayitan min diyōm baran anak na. ");
INSERT INTO slm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Suga' nambung si Isa magparalilan, uk na, “Subay pilasso dahu manga anak sabab 'nsa' manjari killo' kiyakan manga anak lahasiya' bo' liyarukan ni manga ero'.” ");
INSERT INTO slm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Bannal, Tuwan,” uk danda. “Suga' minsan manga ero' ma deyo' lamisahan mangan du momok kiyakan iya pakpak uk manga onde'.” ");
INSERT INTO slm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Manjari halling si Isa ma iya, uk na, “Mowe' na kau. Diyulan du kau ma sabab bissala nu iyu. Pakallo' na sayitan min diyōm baran anak nu.” ");
INSERT INTO slm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mowe' na danda bo' tatawwa' na anak na pabahak ma pabahakan na, bo' hi' na pakallo' sayitan. ");
INSERT INTO slm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pakallo' si Isa min jadjahan Tira ian pabayik ni tōngōd danaw Jalil. Lintas uk na lahat Sidun, labay isab min lahat iyōnan Sangpu' Daira. ");
INSERT INTO slm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na, niya' dakayo' aa bisu maka tanga' biyo ni si Isa uk manga aa bo' ngamu' sigam junjung ni iya bang peen pibōtang tangan na ma aa biyo uk sigam hi'. ");
INSERT INTO slm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jari biyo aa ian uk si Isa pasaddi min diyōm kahekahan aa ian, bo' piabut uk si Isa tong tangan na ni diyōm tainga aa hi'. Ngalura' isab iya, bo' iyampa 'ntanan na dalla' aa. ");
INSERT INTO slm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Puwas hi' pahangad si Isa tudju ni langit bo' nganapas pamehe. Uk na ni aa bisu-tanga' ian, “Eppata!” Hati na “Paukab na kaam!” ");
INSERT INTO slm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Makake magtuwi tainga aa ian. Piusay magtuwi dalla' na bo' bōntōl uk na missala. ");
INSERT INTO slm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jari iyamay-amayan manga aa ian uk si Isa, daa siyoho' ma'-ma' ni sayi-sayi ma pasal ian hi'. Lipara mangkin na sigam siyoho' daa ma'-ma', mangkin na sigam ma'-ma'. ");
INSERT INTO slm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jari haylan tōōd sasuku makake. “Aa itu,” uk sigam, “Hap asal kahinangan na kamemon. Minsan aa bisu makake uk na, maka aa umaw makabissala uk na.” ");
INSERT INTO slm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'Nsa' taggōl minnihi' heka na tōōd isab manga aa patipun pay'an, bo' 'nsa' niya' kiyakan sigam. Jari linganan uk si Isa manga mulid na pahi' ni iya bo' uk na ma sigam, ");
INSERT INTO slm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maase' aku ma baanan aa itu sabab katallu 'llaw itu na iya kamaitu sigam ma aku, maka 'nsa' na niya' kiyakan sigam. ");
INSERT INTO slm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bang sigam papowe' ku ma 'nsa' sigam bayi makakakan dahu, arakala' piyunung isab ma palangnganan, sabab niya' sigam kasehean lawak pamowean sigam.” ");
INSERT INTO slm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Uk manga mulid na ma iya, “Na, minningga baha' pangalloan ta kiyakan sarang pamakan kabanōsan aa itu? Tiya' kitabi ma 'nsa' niya' kalumaan na itu!” ");
INSERT INTO slm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tiyaw si Isa ma sigam, uk na, “Pila heka tinapay bi iyu?” “Pitu',” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Manjari siyoho' uk si Isa kahekahan aa ian magtingkoan ma tana'. Killo' uk na pitu' tinapay bo' iyampa magsukul ni Tuhan. Puwas hi' pighopo'-hopo' uk na tinapay bo' iyampa siyongan uk na ni manga mulid na. Bo' tiyōpōd-tōpōran baanan aa ian uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Niya' isab ma sigam manga daying-daying nahut, salat heka na. Pagsukul peen si Isa, tasoho' na isab manga mulid na muwan daying ma manga aa hi'. ");
INSERT INTO slm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Magkakanan sigam kamemon sampay lasso na. Puwas hi' niya' pitu' ambung mehe panno' uk momok kiyakan bayi tatipun uk manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Manga aa bayi magkakanan ian, niya' kulang-labi 'mpat ngibu aa. Manjari pipowe' manga aa ian uk si Isa, ");
INSERT INTO slm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bo' pariyata' iya magtuwi maka manga mulid na ni bayanan bo' pauntas pahi' ni lahat Dalmanuta. ");
INSERT INTO slm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagtakka di si Isa ni Dalmanuta, niya' pahi' ni iya manga aa Parisi mo iya magsual. Baya' sigam nulayan iya iya poon sigam mikipanda' paltandaan, palsaksian in iya bannal taga kapatut min Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Manjari nganapas si Isa pamehe sabab susa diyōm atay na, bo' uk na ma sigam, “Angay baha' manga aa ma waktu itu hi'? Hal sigam ngamu' tanda'. Bannal iya pama' ku ma kaam, 'nsa' niya' paltandaan pindaan kaam.” ");
INSERT INTO slm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jari pakallo' iya min sigam. Pariyata' iya pabing ni bayi pamean na bo' pauntas iya pahi' ni dambiya' danaw. ");
INSERT INTO slm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, manga mulid si Isa 'nsa' makaintōm mo lutu'. Hangkan du dakayo' tinapay bayi tabo sigam ma diyōm bayanan hi'. ");
INSERT INTO slm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jari piyanduan sigam uk si Isa, uk na, “Kamaya'-maya' kaam. Halliin bi pasulig tinapay min manga Parisi maka pasulig si Sultan Herod!” ");
INSERT INTO slm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Magbissala manga mulid pasal halling na itu sabab 'nsa' tahati. Uk pag-upama sigam, “Hangkan salaihi' marayi' halling si Isa sabab 'nsa' kita bayi mo tinapay.” ");
INSERT INTO slm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kitauhan asal uk si Isa bang ayi iya pigbissala uk sigam, hangkan uk na, “Angay pagbissala bi sawukat 'nsa' niya' tinapay bi? 'Nsa' le' tasayu bi baha'? 'Nsa' le' tahati bi? 'Nsa' kaam kapanduan, a? ");
INSERT INTO slm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niya' mata bi suga' sali' kaam aa 'nsa' makanda'. Niya' tainga bi suga' sali' kaam aa 'nsa' makake. Marayi' 'nsa' taintōm bi bayi hinang ku ma 'llaw hi', ");
INSERT INTO slm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","waktu bayi kapaghopo'-hopo' ku tinapay lima heka na pamakan manga limangibu aa hi'. Pila ambung mehe bayi pangalōōnan bi kapin kiyakan?” Uk sigam, “Sangpu' maka duwa.” ");
INSERT INTO slm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Maka tinapay pitu' heka na hi',” uk si Isa, “iya bayi paghopo'-hopo' ku ma manga aa 'mpat ngibu. Pila ambung bayi pangalōōnan bi?” “Pitu',” uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na,” uk na, “bo' masi kaam 'nsa' le' makahati.” ");
INSERT INTO slm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jari takka na di si Isa ni kalumaan Betsaida, maka niya' manga aa pay'an mo aa buta ni iya. Ngamu' sigam junjung ni iya bang peen pabōtang na tangan na ma aa buta hi'. ");
INSERT INTO slm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sakali intanan uk si Isa tangan aa buta hi' bo' iyambit uk na paluwas min kalumaan ian. Pagmaluwasan peen, liyuraan uk na mata aa hi' bo' iyampa pabōtang na tangan na ma iya. Puwas hi' tīyaw iya uk na. “Niya' baha' tanda' nu?” uk na. ");
INSERT INTO slm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Patongas aa hi' nganda' ni dahuhan na. “Aho',” uk na, “niya' tanda' ku manga aa suga' dagbōs na sali' poon kayu palangnganan di na.” ");
INSERT INTO slm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mabōtang si Isa tangan na pabing ni mata aa hi', jari pagpatong na pabayik kaulian mata na maka sawa uk na nganda' ma kamemon. ");
INSERT INTO slm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Puwas hi' pipowe' iya uk si Isa. Uk na isab ma iya, “Daa kau pasōd pabing ni diyōm kalumaan hi'.” ");
INSERT INTO slm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Manjari itu palanjal si Isa maka mulid na ni manga kalumaan ma katilibut daira Kesareya Pilipi. Na, ma labayan peen, tiyaw si Isa ma manga mulid na, uk na, “Sayi kono' aku bang ma pangupama aa?” ");
INSERT INTO slm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Uk sambung manga mulid hi', “Bang ma aa kasehean kau kono' si Yahiya Magpapandi. Bang isab ma aa kasehean in kau si Nabi Eliyas. Maka bang ma aa kasehean isab kau dakayo' nabi bayi ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Na, bang ma kaam,” uk tiyaw si Isa, “sayi aku itu?” Nambung si Petros. “Kau si Almasi,” uk na, “iya tapene' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Puwas hi' biyandaan uk si Isa manga mulid na, daa siyoho' ma'-ma' ni sayi-sayi bang sayi iya. ");
INSERT INTO slm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na, minnihi' nagna' si Isa manduan manga mulid na pasal ayi makani-iya. “Aku,” uk na, “Anak Manusiya' itu, heka du kabinsanaan song pitakka ni aku. Maka siyulak du aku uk manga kamaasan maka manga kaimaman langkaw maka manga guru ma sara' agama. Piyatay du aku suga' taabut peen katallu 'llaw na, 'llum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pipasti' tōōd uk si Isa halling na itu ma sigam. Jari biyo iya uk si Petros paōkat min kasehean bo' supaya pihallingan. ");
INSERT INTO slm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Suga' palingi' si Isa nganda' ma manga mulid na bo' pahallingan na si Petros. “Pakallo' kau min aku, sayitan! Iya pamikil nu iyu pikilan manusiya' ko', 'nsa' pikilan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jari noho' si Isa ma kahekahan aa ian maka ma manga mulid na, siyoho' patipun ni iya. “Bang niya' aa baya' me' ma aku,” uk na, “subay 'nsa' kabayaan baran na iya dulan na. Subay tanggung na hag na pamapatayan iya, hati na subay paglilla' na kabinsanaan ma sabab ku sampay ni kamatay. Minnihi' iya makajari me' ma aku. ");
INSERT INTO slm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sayi-sayi 'llōgan kallum-baran na paōkat du kallum-nyawa na min Tuhan. Suga' sayi-sayi 'nsa' 'llōg ma kallum-baran na, lilla' isab matay ma sabab ku maka ma sabab lapal hap itu, makatawwa' du iya kallum kakkal. ");
INSERT INTO slm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sabab na,” uk si Isa, “bang niya' aa ganta' kaniyaan alta' diyōm dunya kamemon mehe lugi' na bang 'nsa' niya' kallum na kakkal. ");
INSERT INTO slm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","'Nsa' niya' tapangalakkat na kallum-nyawa na bang paōkat na. ");
INSERT INTO slm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Manga aa ma waktu itu hi', dusahan asal kahekahan sigam maka 'nsa' ngisbat Tuhan. Bo' sayi-sayi iya' magsabannal ma manga aa hi' pasal kapasuku' na ma aku maka pasal kapame' na ma pandu' ku, jari aku itu, Anak Manusiya', iya' du ngakuhan aa ian ma waktu kapaitu ku pabayik. Pabayik du aku libut uk sahaya 'Mma' ku. Iya sehe' ku ian manga malaikat sutsi.” ");
INSERT INTO slm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Missala le' si Isa, uk na, “Bannal iya halling ku itu ma kaam, niya' ma itu ma kaam 'nsa' matay sataggōl 'nsa' tanda' na pagparinta Tuhan pibōtang maka kawasa na mehe.” ");
INSERT INTO slm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, palabay peen 'nnōm 'llaw min waktu hi', manjari si Petros maka si Ya'kub maka si Yahiya hi' biyo uk si Isa patukad ni diyata' bud langkaw, sigam-sigam sadja. May'an peen, pinda dagbōs si Isa ma panganda' sigam. ");
INSERT INTO slm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pote' tōōd sammek na, makasilaw bidda'. 'Nsa' niya' ma diyōm dunya itu maka papote' sammek sali' kapote' sammek ian hi'. ");
INSERT INTO slm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Panyata' isab pay'an si Nabi Eliyas maka si Musa, tanda' uk manga mulid hi' magbissala maka si Isa. ");
INSERT INTO slm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Halling si Petros ni si Isa, uk na, “Tuwan Guru, hap tōōd isab tiya' kami ma itu. Ngahinang kami tallu bawung-bawung pasindungan bi ma itu, dakayo' ma kau, dakayo' ma si Musa itu, maka dakayo' ma si Eliyas.” ");
INSERT INTO slm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Salaihi' pama' na sabab 'nsa' katauhan na bang ayi subay halling na. Mehe asal kagawahan sigam manga mulid hi'. ");
INSERT INTO slm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sakali niya' gabun bayi ngalandungan sigam, maka niya' suwara halling min diyōm na. Uk suwara hi', “Anak ku ko' itu, kalasahan ku. Iya iya kehun bi.” ");
INSERT INTO slm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pag'nda' sigam dayi'-dayi' ma katilibut sigam magtuwi 'nsa' niya' aa tanda' sigam ma tōngōd ian hi', duwal si Isa. ");
INSERT INTO slm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Manjari itu, sabu peen sigam palud min bud hi', biyandaan uk si Isa manga mulid hi', uk na, “Daa kaam ma' ni sayi-sayi pasal bayi tanda' bi ma diyata' bud hi'. Subay na aku, Anak Manusiya' itu, tapakallum pabing min kamatay ku bo' iyampa kaam ma'.” ");
INSERT INTO slm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iyasip uk sigam kabtangan si Isa itu suga' magtiyaw-tiyaw sigam tallungan bang ayi hati na iya bayi halling na pasal kapakallum min kamatay. ");
INSERT INTO slm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sakali tīyaw si Isa uk sigam, uk na hi', “Angay manga guru ma sara' agama mandu' in si Nabi Eliyas subay dahu palahil paitu?” ");
INSERT INTO slm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nambung si Isa ma sigam, uk na, “Bannal ko' iyu, si Eliyas iya palahil dahu min si Almasi nakapan kamemon. Suga' ayi sabab na hangkan tasulat ma diyōm kitab pasal Anak Manusiya' in iya subay makalabay kabinsanaan mehe maka subay hiyalipulu? ");
INSERT INTO slm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Suga' baan ta kaam pasal si Eliyas. Bayi na iya palahil bo' tahinang ma iya uk manga manusiya' ayi-ayi kabayaan sigam, sali' bayi tasulat asal ma diyōm kitab ma pasal na.” ");
INSERT INTO slm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na, makabing peen di si Isa ni manga mulid kasehean, kalandu' heka aa tanda' uk sigam magtipun ma tōngōd ian hi'. Niya' isab manga guru ma sara' agama tanda' uk sigam magjawab maka manga mulid kasehean hi'. ");
INSERT INTO slm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jari itu, makanda' peen kahekahan aa ian ma si Isa, mehe kainu-inuhan sigam bo' paragan sigam nampang iya. ");
INSERT INTO slm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tiyaw si Isa ma sigam, uk na, “Ayi pagjawaban bi iyu?” ");
INSERT INTO slm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jari niya' nambung min diyōm katipunan aa ian, uk na, “Tuwan Guru, bayi bo ku ni kau anak ku lalla sabab siyōd iya uk sayitan umaw. ");
INSERT INTO slm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kahaba' waktu, bang iya siyōd uk sayitan itu, pihantak iya ni tana'. Ngalappu bo' na, magtagiōt baggaang na, maka nuwas isab baran na. Bayi amu' ku pipakallo' uk manga mulid nu itu suga' 'nsa' takowe' uk sigam.” ");
INSERT INTO slm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nambung si Isa, uk na, “Kaam manga aa ma waktu itu hi', 'nsa' tōōd niya' iman bi! Subay salaingga le' taggōl ku ma kaam nandalan addat bi iyu? Bohun paitu onde',” uk na. ");
INSERT INTO slm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jari biyo iya uk sigam ni si Isa. Pagtanda' si Isa uk sayitan, magtuwi siyawan uk na onde' bo' pahantak iya ni tana' maspad. Ngalappu isab bo' na. ");
INSERT INTO slm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tiyaw si Isa ma 'mma' onde' ian, uk na. “Salaingga taggōl na salaitu?” “Sataggōl min kariki'-diki' na,” uk 'mma' na. ");
INSERT INTO slm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Daran iya pihantak uk sayitan ni diyōm api atawa ni diyōm bohe' bo' supaya piyatay. Bang takowe' nu, Tuwan, maase' kau. Tabangun kami!” ");
INSERT INTO slm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Uk si Isa ma iya, “Pagba' nu baha' bang takowe' ku? Bang aa taga iman,” uk na, “takowe' na kamemon.” ");
INSERT INTO slm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tanōg magtuwi halling 'mma' onde' hi'. Uk na, “Niya' du iman ku suga' kulang le' kōsōg na. Tabangin aku bo' supaya pasong kōsōg na.” ");
INSERT INTO slm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pag'nda' si Isa ma kahekahan aa ian song na pasigpit ni iya, jari liyāng uk na sayitan hi'. “Kau sayitan umaw-bisu,” uk na, “soho' ta kau pakallo' min diyōm baran onde' iyu. Daa na kau pasōd paiyu pabing!” ");
INSERT INTO slm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jari itu, ubus peen uk sayitan ngōlang pakōsōg, maspad bidda' onde' ian bo' paluwas iya min baran na. Sakali onde' ian sali' dagbōs patay, hangkan uk kahekahan aa ian, “Na! Matay na!” ");
INSERT INTO slm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Suga' si Isa iya bayi ngantanan tangan onde' ian bo' tiyabangan uk na papunduk bo' nangge iya. ");
INSERT INTO slm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, makasōd peen si Isa ni diyōm luma', tīyaw iya uk manga mulid na pagka sigam-sigam sadja. Uk sigam, “Angay kami itu 'nsa' bayi makapaluwas sayitan hi'?” ");
INSERT INTO slm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Uk si Isa, “Iya ginisan sayitan ian hi' 'nsa' tapaluwas, duwal bang iyamuan tabang ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Manjari palanjal na di si Isa minnian palabay min tangnga' lahat Jalil. Iya kabayaan si Isa subay 'nsa' niya' makatau bang paingga palangnganan na, ");
INSERT INTO slm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sabab ian iya manduan manga mulid na. Uk na ni sigam, “Aku itu, Anak Manusiya', song na siyongan ni pangantanan manga aa bo' piyatay du aku uk sigam. Suga' puwas tallum bahangi min pamapatay ma aku 'llum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Parahal 'nsa' tahati bissala si Isa ian uk manga mulid na. 'Nsa' isab sigam tawakkal niyaw iya. ");
INSERT INTO slm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Manjari itu takka na sigam ni daira Kapirnaum. Makasōd peen si Isa ni diyōm luma', tīyaw uk na manga mulid na, uk na, “Ayi bayi paglugatan bi ma labayan hi'?” ");
INSERT INTO slm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Suga' 'nsa' sigam baya' nambung sabab niya' bayi paglugatan sigam ma labayan bang sayi iya katapusan langkaw ma sigam. ");
INSERT INTO slm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jari ningko' si Isa bo' linganan na mulid na sangpu' ka duwa ian patōngōd ni iya. Uk na ma sigam, “Sayi-sayi baya' pilangkaw tōōd subay magpareyo' di na min kamemon. Subay iya magsosohoan ni pagkahi na kamemon.” ");
INSERT INTO slm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sakali killo' uk si Isa dakayo' onde'-onde', pitangge uk na ma alōpan sigam. Kikkōpan peen uk na onde' itu, uk na ni sigam, ");
INSERT INTO slm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sayi-sayi nayima' dakayo' onde'-onde' salaitu ma sabab ōn ku iya pamanyabutan na, sali' baran ku iya tayima' uk na. Maka sayi-sayi isab nayima' aku, 'nsa' aku sadja iya tayima' na. Tayima' na isab Tuhan iya bayi mapaitu aku ni dunya.” ");
INSERT INTO slm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jari itu niya' halling si Yahiya ni si Isa, uk na, “Tuwan Guru, niya' dakayo' aa tanda' kami nabbut ōn nu pamaluwas na sayitan min diyōm baran aa. Bayi iya lāng kami sabab 'nsa' sehean tabi.” ");
INSERT INTO slm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Suga' halling si Isa, uk na, “Daa iya langun bi sabab bang aa makahinang hinang kawasahan ma sabab aku iya panabbutan na, 'nsa' du iya magtuwi makapahallingan aku laat. ");
INSERT INTO slm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sabab na sayi-sayi 'nsa' nagga' kitabi mōgbōg du ma kitabi. ");
INSERT INTO slm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Baan ta kaam tōōd, sayi-sayi muwanan kaam minsan laa dasawan bohe' sadja ma sabab suku' kaam si Almasi, tantu aa ian tiyungbasan kahapan.” ");
INSERT INTO slm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Uk si Isa le', “Bang niya' ganta' mo maghinang dusa dakayo' aa deyo' sali' hantang onde' itu, aa taga pangandōl tudju ni aku, hap le' bang aa mamo ian piggantungan batu bohat ma kallong na bo' iyampa hiyug ni sallang, bang peen 'nsa' kalanduan hinang na salaihi'. ");
INSERT INTO slm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bang tangan bi ganta' mo kaam ni magdusa subay hopoan bi. Gam na peen tattōpin bi bo' 'nsa' kalanduan dusa bi. Hap le' kaam pasōd ni diyōm sulga' ma pukul dambiya' tangan bi, bang peen kaam 'nsa' liyarukan ni diyōm api nalka' iya 'nsa' kapaddahan ma jukup tangan bi karuwambiya'.  ");
INSERT INTO slm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Iya kabinsanaan aa ma diyōm nalka' hi' 'nsa' niya' haran na, iya paddi' na 'nsa' niya' tōbtōban na. ");
INSERT INTO slm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bang nayi' bi isab ganta' mo kaam ni magdusa subay hopoan bi. Gam na peen tattōpin bi. Hap le' kaam pasōd ni diyōm sulga' ma pukul dambiya' nayi' bi, bang peen kaam 'nsa' liyarukan ni diyōm api nalka' ma jukup nayi' bi karuwambiya'.  ");
INSERT INTO slm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Iya kabinsanaan aa ma diyōm nalka' hi' 'nsa' niya' haran na, iya paddi' na 'nsa' niya' tōbtōban na. ");
INSERT INTO slm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bang mata bi isab mo kaam ni magdusa subay lugitin bi. Gam na peen lugitin bi bo' 'nsa' kalanduan dusa bi. Hap le' kaam pasōd ni diyōm pagparinta Tuhan ma buta dambiya' mata bi, bang peen kaam 'nsa' liyarukan ni diyōm api nalka' ma jukup mata bi karuwambiya'. ");
INSERT INTO slm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iya kabinsanaan aa ma diyōm nalka' hi' 'nsa' niya' haran na, iya paddi' na 'nsa' niya' tōbtōban na.” ");
INSERT INTO slm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Magparalilan le' si Isa. “Aa kamemon,” uk na, “palabay du min diyōm api, hati na min diyōm katiksaan, supaya pasong iman na. ");
INSERT INTO slm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Hap asal asin itu suga' 'nsa' niya' pamabayik nanam na bang magtinu' na. Hangkan kaam isab,” uk na, “subay niya' asin ma kaam, hati na subay kaam pahatul-hatul bo' 'nsa' lungay kapagbagay bi.” ");
INSERT INTO slm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Manjari pakallo' si Isa min lahat hi' bo' pahi' ni lahat Yahudiya maka ni jadjahan lahat ma liyu sapa' Jordan. Heka isab manga aa magtipunan tudju ni iya, bo' panduan na sigam sali' asal kabiyaksahan na. ");
INSERT INTO slm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na, niya' pay'an ni iya manga aa Parisi bahasa nulayan iya bo' supaya iya tasaggaw ma bissala na. Hangkan uk sigam ma iya, “Bang ma sara' kitabi, makajari baha' bang lalla nimanan handa na?” ");
INSERT INTO slm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nambung si Isa, uk na, “Ayi bayi panohoan kaam ma sara' si Musa?” ");
INSERT INTO slm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Uk sambung sigam, “Bang ma sara' si Musa, makajari lalla nimanan handa na bang peen niya' sulat na pagpasahan.” ");
INSERT INTO slm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Uk si Isa, “Iya hangkan kaam siyulatan sara' salaiyu uk si Musa sabab alōd kaam piyanduan. ");
INSERT INTO slm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Suga' ma awwal tagna' pamapanjari Tuhan ma manusiya' bayi sigam pipanjari uk na lalla maka danda, sali' bayi tasulat ma diyōm kitab, iya uk na hi', ");
INSERT INTO slm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Hangkan na lalla pakallo' min maas na lalla-danda, bo' parakayo' ni handa na. ");
INSERT INTO slm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Manjari in bayi duwa baran, dabaran na. 'Nsa' na sigam duwa baran’,” uk si Isa, “suga' dabaran na sigam duwangan. ");
INSERT INTO slm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hangkan ko' subay 'nsa' pipagbutas uk manusiya' bang bayi pipagdakayo' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Makamarīyom luma' peen di si Isa pabing, tīyaw iya uk manga mulid na pasal pagtiman itu. ");
INSERT INTO slm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Uk na ni sigam, “Sayi-sayi nimanan handa na bo' maghanda iya saddi, taga dusa iya magjina min handa na poon. ");
INSERT INTO slm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Damikkiyan na bang danda iya nimanan halla na bo' maghalla saddi, taga dusa isab iya magjina.” ");
INSERT INTO slm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na, niya' manga aa mo anak sigam ni si Isa bo' supaya pibōtangan tangan na ma sigam. Suga' aa mamo ian bayi pihallingan uk manga mulid si Isa. ");
INSERT INTO slm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pag'nda' itu uk si Isa ngandugal iya ma manga mulid na hi' bo' uk na, “Parulun bi paitu ni aku manga kaondean iyu. Daa lāngun bi. Sabab sayi-sayi makasali' kawul-piil na ni sali' kaondean iyu, taga palsukuan du ma diyōman pagparinta Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bannal iya pama' ku ma kaam, bang aa 'nsa' nulut ma pagparinta Tuhan sali' onde'-onde' iya nulut ma panohoan maas na, aa ian 'nsa' pasōd ni pagparintahan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jari kikkōpan uk na manga onde'-onde' ian. Pibōtang uk na tangan na ma sigam bo' iyampa sigam amuan na kahapan. ");
INSERT INTO slm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Manjari itu, song peen si Isa palanjal ni palangnganan na pabing, niya' dakayo' lalla paragan tudju ni iya. Pasujud aa itu ma dahuhan si Isa maka uk na tiyaw, uk na, “Tuwan Guru, kau hi' asal hap. Ayi subay hinang ku bo' supaya aku kaniyaan kallum iya taptap ni kasaumulan?” ");
INSERT INTO slm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Uk si Isa ni iya, “Angay uk nu in aku itu hap? 'Nsa' niya' hap, duwal Tuhan dakayo'-kayo'. ");
INSERT INTO slm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Katauhan nu asal bayi panohoan Tuhan: Daa kau mono'. Daa kau magjina. Daa kau nangkaw, Daa kau naksi' puting. Daa kau ngullian pagkahi nu bahasa takallo' nu alta' na. Pag-addatin ina'-mma' nu.” ");
INSERT INTO slm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uk lalla ni iya, “Tuwan Guru, bayi na kabōgbōgan ku ian hi' kamemon sataggōl min kaonde' ku.” ");
INSERT INTO slm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pag'nda' si Isa ma aa itu takkahan iya lasa ma iya bo' uk na, “Niya' le' dakayo' 'nsa' tahinang nu. Pahi' kau, paballihin alta' nu kamemon bo' pamuwanun ballihan na ma manga aa miskin. Manjari niya' du karaya nu may'an ma diyōm sulga'. Puwas hi' paitu kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagtake aa itu ma bissala si Isa laat magtuwi aymuka na. Pakallo' iya minnihi' maka uk na susa sabab landu' tōōd heka alta' na. ");
INSERT INTO slm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nganda' si Isa tudju ni manga mulid na bo' uk na ma sigam, “Manga aa dayahan kahunitan du peen pisōd ni diyōman pagparinta Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Inu-inu manga mulid na ma bissala na hi' suga' siyugpatan le' uk na. “Manga bagay,” uk na, “hunit kalandu' pisōd ni diyōman pagparinta Tuhan! ");
INSERT INTO slm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kaluhayan le' unta' palabay min buwi' jawum min aa dayahan pasōd ni diyōm pagparintahan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Inu-inu tōōd manga mulid na ma bissala si Isa salaihi', bo' uk sigam ni iya, “Oy! Bang salaihi', sayi baha' makasampay ni kasalamatan ma diyōm sulga'?” ");
INSERT INTO slm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Piyandang uk si Isa manga mulid na hi', maka uk na halling. Uk na, “Bang manusiya' 'nsa' tōōd makarapat suga' tarapat du uk Tuhan sabab 'nsa' niya' hunit ma iya.” ");
INSERT INTO slm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sakali halling si Petros, uk na, “'Ndaun ba kami itu. Bayi na 'mbanan kami ayi-ayi kamemon bo' me' ma kau.” ");
INSERT INTO slm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Aho',” uk si Isa ma sigam, “maka baan ta kaam tōōd: sasuku bayi ngambanan luma' na, atawa danakan na, atawa ina'-mma' na, atawa anak na, atawa tana' na, tiyungbasan du iya. Bang hi' bayi 'mbanan na ma sabab katuyu' na ma aku maka ma sabab lapal hap, ");
INSERT INTO slm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tiyungbasan du iya paheka uk Tuhan ma dunya itu hi'. Tiyungbasan iya luma', danakan na, ina' na, anak na, maka tana' na, lipat manglipat min bayi 'mbanan na. Suga' pitakkahan iya kalaatan isab ma sabab pame' na ma aku. Bo' ma dunya ahirat pisukuan du iya kallum taptap ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Suga' heka aa makarahu buttihi' piramuwi du ma waktu siyong. Heka isab taramuwi ma buttihi' pirahu du ma waktu siyong.” ");
INSERT INTO slm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, ma labayan peen di si Isa patukad tudju ni daira Awrusalam. Si Isa iya hi' parahu min manga mulid na bo' inu-inu tōōd sigam diyōm atay sigam. Tiyāw isab manga aa kasehean iya paturul min damuwihan. Manjari biyo uk si Isa mulid na sangpu' ka duwa pasaddi pabayik min aa kasehean ian bo' iyampa sigam pahati na pasal ayi song patakka ni iya. ");
INSERT INTO slm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Pake kaam,” uk na. “Tiya' kitabi patukad ni Awrusalam. May'an peen kitabi, in aku, Anak Manusiya', siyongan du ni pangantanan manga kaimaman langkaw maka manga guru ma sara' agama. Pitakkahan aku uk sigam hukuman ni kamatay. Puwas hi' siyongan du aku ni pangantanan manga aa 'nsa' Yahudi, ");
INSERT INTO slm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","bo' pig-udju'-udju' aku uk bangsa ian sampay pigluraan. Piglapdōsan du aku bo' iyampa liyansang piyatay. Suga' puwas peen tallum bahangi min kamatay ku 'llum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sakali pay'an ni si Isa si Ya'kub maka si Yahiya iya anak si Sibidi karuwangan. “Tuwan Guru,” uk sigam, “niya' iyamu' uk kami subay hinang nu ma kami.” ");
INSERT INTO slm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Uk si Isa, “Ayi amu' bi?” ");
INSERT INTO slm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nambung sigam, uk na, “Bang taabut waktu kapaningko' nu magpalangngan parinta nu bangsahan, iya kabayaan kami subay kami patingko' nu ma bihing nu, dakayo' ma sakap ni katau, dakayo' ma sakap ni kayi.” ");
INSERT INTO slm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Uk si Isa, “'Nsa' katauhan bi bang ayi amu' bi iyu. Makasandal kaam baha' pinanaman kasukkalan sali' pamasukkal ma aku ma sosongun iyu? Atawa makasandal kaam pilabay min kabinsanaan iya song labayan ku?” ");
INSERT INTO slm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Aho', makasandal du kami,” uk duwangan hi'. Uk si Isa, “Asal makananam du kaam kasukkalan sali' song patakka ni aku. Makalabay du kaam min kabinsanaan iya song labayan ku. ");
INSERT INTO slm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Suga' 'nsa' niya' kapatut ku mene' bang sayi pitingko' ma bihing ku, sakap ni katau atawa sakap ni kayi. Suku' ko' ian manga aa iya tiyagamahan paningkoan ian hi' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Take peen uk manga sangpu' mulid si Isa pasal bayi iyamu' uk si Ya'kub maka si Yahiya, magtuwi duwangan itu kapaddian atay sigam. ");
INSERT INTO slm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hangkan sigam kamemon siyoho' uk si Isa patipun ni tōngōd na. Uk na, “Katauhan bi iya addat manga aa ma dunya itu. Iya bista taga kapatut ngantanan pagparinta ma bangsa kasehean ian magkawasa tōōd asal ma manga aa ma deyoan sigam. Iya du manga puntuk nakura' sigam, magbaya' asal ma sigam. ");
INSERT INTO slm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Suga' kaam iyu 'nsa' subay magsalaihi'. Sayi-sayi kaam baya' palangkaw ma diyōman bi, subay iya magsosohoan ni kasehean. ");
INSERT INTO slm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sayi-sayi kaam baya' pilangkaw subay iya magpaata ni kamemon nabangan sigam. ");
INSERT INTO slm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Subay iya ningōd ni aku iya Anak Manusiya' itu,” uk si Isa. “Iya paitu ku ni dunya 'nsa' aku subay pighinangan uk manga manusiya', suga' sigam iya subay tabang ku. Paitu isab aku bo' paglilla' ku kallum ku pangalakkat ku manga aa heka min paldusahan sigam.” ");
INSERT INTO slm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, takka na di si Isa ni daira Ariha. Jari itu, pakallo' peen iya maka manga mulid na minnihi', maka heka isab aa parōngan ma iya. Niya' aa buta ningko' ma bihing daddōk palabayan sigam. Si Bartimiyus iya, anak si Timiyu. Hinang na ngamu'-ngamu' sin. ");
INSERT INTO slm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Makatau peen iya in si Isa min Nasaret ian palabay, magtuwi iya ngalingan pakōsōg. “O Isa,” uk na, “tubu' Sultan Daud, maase' kau ba ma aku!” ");
INSERT INTO slm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pihallingan iya uk aa maheka ian, daa siyoho' maghebok. Suga' pikōsōg gam peen pangalingan na. “O Isa, tubu' Sultan Daud,” uk na, “maase' na kau ba!” ");
INSERT INTO slm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Parōhōng si Isa bo' halling ni manga sehe' na. “Linganin bi iya paitu,” uk na. Jari linganan na. “Paisōg kau,” uk manga aa hi'. “Nangge kau sabab ian si Isa ngalinganan kau.” ");
INSERT INTO slm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Magtuwi patulahad buta itu min bayi paningkoan na maka libbahan uk na manta na bayi pagkammōs na bo' patōngōd ni si Isa. ");
INSERT INTO slm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Uk si Isa ma iya, “Ayi kabayaan nu hinang ku ma kau?” “Tuwan Guru,” uk na, “baya' aku makanda' pabing.” ");
INSERT INTO slm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Uk si Isa ma iya, “Mowe' na kau. Kaulian na mata nu ma sabab pangandōl nu ma aku.” Saruun-duun du iya makanda' pabing bo' me' iya paturul ma si Isa ma palangnganan na. ");
INSERT INTO slm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jari itu, sikōt-sikōt peen di si Isa ni daira Awrusalam bo' ma tōngōd kalumaan Betpage maka Betani, taabut uk sigam Bud Kayu Jaitun hi'. Mahi' peen, siyoho' uk si Isa duwangan mulid na parahu min sigam. ");
INSERT INTO slm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Pahi' na kaam,” uk na, “ni kalumaan ma dahuhan bi iyu. Pagtakka bi pay'an makatawwa' du kaam dakayo' anak kura' bayi ingkōtan, kura' 'nsa' bayi tapanguraan aa. Hubarin bi bo' bohun bi paitu. ");
INSERT INTO slm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bang niya' ganta' niyaw kaam bang angay kallo' bi, bain bi salaitu. Uk bi, ‘Tuud pagguna uk nakura'. 'Nsa' du taggōl tiyuran du uk na.’ ” ");
INSERT INTO slm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, pahi' duwangan mulid hi' bo' tatawwa' uk sigam anak kura' ma daddōk, ingkōtan ni bihing lawang luma' may'an. Sabu peen sigam ngahubad, ");
INSERT INTO slm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tīyaw sigam uk manga aa bayi magtanggehan asal ma tōngōd ian hi'. Uk na hi', “Angay hubaran bi iyu?” ");
INSERT INTO slm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nambung duwangan mulid ian sali' bayi panohoan si Isa ma sigam bo' diyulan sigam uk manga aa ian palanjal. ");
INSERT INTO slm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Biyo kura' uk sigam ni si Isa bo' hiyanigan bukut na maka manga badju' sigam bo' iyampa kiyuraan uk si Isa. ");
INSERT INTO slm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sakali itu heka aa mallat sammek sigam ma daddōk palabayan na. Kasehean isab bayi nagpe' manga engas-engas dawunan ma diyōm huma bo' siyabulakan uk sigam ma daddōk hi'. ");
INSERT INTO slm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Manjari baanan manga aa iya mangngan ian min dahuhan si Isa, sampay sigam paturul min damuwihan na, ngalingan sama-sama. Uk na hi', “Pudji tabi iya! Bang peen biyarakatan iya kawakilan uk Tuhan paitu! ");
INSERT INTO slm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bang peen biyarakatan pagparinta na iya song pibōtang itu, pagparinta si Daud pangkat kitabi. Pudji ni Tuhan Mahatinggi!” ");
INSERT INTO slm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Manjari pagtakka si Isa ni diyōm daira Awrusalam bo' iyampa pasōd ni diyōm langgal pagkulbanan bo' liling na manga ayi-ayi kamemon ma diyōm na ian. Suga', pagka song sangōm na, paluwas iya minnihi' pabing maka manga mulid na sangpu' ka duwa ni kalumaan Betani. ");
INSERT INTO slm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pag'llaw sawung, makalintas peen sigam min Betani hi', giyōtas na si Isa. ");
INSERT INTO slm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jari niya' tanda' na min katahan dakayo' kayu igira labuk dawun na, hangkan iya pay'an nganda' bang taga buwa'. Suga' pagpay'an na, hangkan du dawun iya tanda' may'an sabab 'nsa' le' musim na magbuwa'. ");
INSERT INTO slm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Siyuknaan uk si Isa kayu ian, uk na, “Puwas minnitu 'nsa' du niya' mangan buwa' min kayu itu sampay ni kasaumulan.” Na, kine sukna' itu uk manga mulid na. ");
INSERT INTO slm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na, takka peen sigam ni Awrusalam, pasōd si Isa ni diyōm langgal pagkulbanan bo' iyampa nagna' magpaluwas manga aa magdagang-dagang maka maglitu may'an. Biyaliskat uk na lamisahan manga aa magsambian sin bangsa liyu ni sin Yahudi. Iya du paningkoan manga aa magdagang assang pagkulban, biyaliskat isab uk na. ");
INSERT INTO slm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'Nsa' niya' pasaran na ngahakut ayi-ayi labay min diyōm langgal hi'. ");
INSERT INTO slm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jari magpandu' si Isa ma manga aa ian, uk na, “Tasulat asal ma diyōm kitab iya bayi pagpalatun Tuhan, iya uk na hi', ‘Luma' ku itu iyōnan du luma' pagsambahayangan manga aa kabangsa-bangsahan.’ Suga' hinang bi na sali' luma' panapukan mundu!” ");
INSERT INTO slm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kahakahan manga imam langkaw maka manga guru ma sara' agama pasal hinang si Isa itu, iya poon sigam nagna' maggara' bang salaingga uk sigam mapatay ma iya. Tiyāw asal sigam ma iya sabab kainu-inuhan pandu' na uk mahadjana' kamemon. ");
INSERT INTO slm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagsong kohap peen, magkalloan di si Isa min Awrusalam hi'. ");
INSERT INTO slm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Subu-subu peen, ma salta' peen di si Isa palabay minnihi', tanda' uk sigam kayu igira bayi siyuknaan hi'. Lanōs na min gamut na sampay ni diyataan na. ");
INSERT INTO slm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Taintōm uk si Petros bayi halling si Isa bo' uk na, “'Ndaun ba, Tuwan! Lanōs na kayu igira bayi siyuknaan uk nu hi'!” ");
INSERT INTO slm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nambung si Isa ma sigam, uk na, “Mangandōl kaam ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Baan ta kaam tōōd, bang sawupama soho' bi bud itu pakallo' min tōngōd na bo' pabōtang ni diyōm sallang, tahinang du ma kaam bang peen 'nsa' niya' hawal-hawal ma diyōm atay bi, bang peen kaam ngahalap sadja in bayi amu' bi kajari du. ");
INSERT INTO slm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hangkan uk ku ma kaam, bang niya' ayi-ayi amu' bi ni Tuhan, tantu kaam makakallo' bang peen kaam ngahalap in kaam makasambut na. ");
INSERT INTO slm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maka bang kaam nangge nambahayang bo' niya' laat-laat ma diyōm atay bi tudju ni aa, ampunun bi aa ian bo' kaam iyampun isab uk Tuhan manga kalaatan bayi tahinang bi.  ");
INSERT INTO slm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Iya bayik na, bang 'nsa' ampun bi aa bayi makabuwan kaam dusa, iya du kaam 'nsa' iyampun uk 'Mma' bi Tuhan ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Takka sigam pabing ni Awrusalam. Manjari itu, pasalta' peen si Isa maglangngan ma diyōm langgal pagkulbanan, pahi' ni iya manga kaimaman langkaw maka manga guru ma sara' agama maka manga kamaasan Yahudi. ");
INSERT INTO slm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Uk sigam ni iya, “Ayi kapatut nu maghinang salaiyu? Sayi bayi muwanan kau kapatutan?” ");
INSERT INTO slm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Uk si Isa, “Niya' dakayo' paniyawan ku ma kaam dahu. Jari bang itu sambungan bi baan ta du kaam bang ayi kapatut ku maghinang salaitu. ");
INSERT INTO slm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iya bayi kapatut si Yahiya magpandi manga aa, kapatut min Tuhan baha' atawa min manusiya' sadja? Sambungin bi iyu hi'.” ");
INSERT INTO slm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sakali sigam mag-isun-isun, uk sigam, “Bang sawupama uk ta in kapatut si Yahiya ian bayi min Tuhan, tīyaw du kitabi uk na itu bang angay kitabi 'nsa' bayi magkahagad ma si Yahiya. ");
INSERT INTO slm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Suga' bang uk ta in kapatut si Yahiya ian min manusiya' sadja, allā, piligdu.” Tiyāw asal sigam ma manga aa mahadjana' sabab magkahagad manga aa kamemon in si Yahiya nabi du tōōd min Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hangkan salaitu iya panambung manga nakura' ian ma tiyaw si Isa, uk na hi', “'Nsa' katauhan kami bang minningga kapatut na.” “Na,” uk si Isa, “iya du aku 'nsa' ma' ma kaam bang minningga kapatut ku maghinang manga hinang ku itu.” ");
INSERT INTO slm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Manjari nagna' si Isa halling kissa paralilan ma manga aa. “Niya',” uk na, “dakayo' aa taga tana' bayi nanōm bahan anggul ma kabbun na. Bayi libut uk na maka ad, bayi kiyali lowang paggipitan buwa' anggul panawuran bohe' na. Hinang isab uk na dakayo' bawung-bawung langkaw pamantawan. Puwas hi' bayi patungguan na kabbun ian ma manga aa magtutunggu' bo' iyampa iya pakallo' tudju ni lahat saddi. ");
INSERT INTO slm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Taabut peen musim pagpusu' buwa' anggul hi', siyoho' uk aa dapu kabbun ian dakayo' sosohoan na pahi' ni manga aa magtutunggu' ngallo' bahagi' na. ");
INSERT INTO slm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Suga' pagtakka sosohoan itu pahi' siyaggaw iya uk aa magtutunggu'. Liyapdōsan iya uk sigam bo' iyampa pipowe' ma 'nsa' niya' tabo na. ");
INSERT INTO slm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Puwas hi' noho' na isab aa dapu ian dakayo' sosohoan na saddi pahi' ni sigam. Jari sosohoan na dakayo' itu kiyakal ma kok na uk manga magtutunggu'. Hiyalipulu isab iya. ");
INSERT INTO slm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Puwas hi' noho' na isab aa dapu ian dakayo' sosohoan na saddi pahi' bo' iya itu bayi piyatay uk sigam. Heka le' isab sosohoan na bayi pigsalaihi' uk manga aa magtutunggu' ian. Kasehean bayi liyapdōsan uk sigam, kasehean bayi piyatay. ");
INSERT INTO slm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hangkan du iya sadja takapin, iya anak aa dapu kabbun, iya anak na lalla kalasahan na. Jari itu, ma damuwi katapusan, bayi soho' na pahi' anak na lahasiya' itu. Uk na ma diyōm pikilan na, ‘Tantu pig-addatan anak ku itu uk manga tunggu' hi'.’ ");
INSERT INTO slm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Suga' pag'nda' manga tunggu' ma anak dapu kabbun itu, magtuwi sigam mag-isun. Uk sigam, ‘Iya na ko' iyu anak aa dapu. Sung kitabi, mapatay iya bo' takallo' tabi tana' na.’ ");
INSERT INTO slm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Manjari siyaggaw iya uk sigam. Biyono' iya bo' timanan patay na paluwas min ad hi'. ");
INSERT INTO slm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na,” uk si Isa, “ayi baha' hinang aa dapu kabbun? Tantu du iya pay'an mapatay manga aa magtutunggu' hi' bo' patungguan na tana' na ma aa saddi.” ");
INSERT INTO slm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tiyaw iya ni manga aa ian, “'Nsa' bayi tabassa bi baha' diyōm kitab, iya uk na hi', ‘Iya batu bayi tasulak uk manga aa maghihinang luma', iya kibā' 'nsa' niya' guna na, Iya na ian batu mehe tōōd kalagihan na. ");
INSERT INTO slm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hinang Tuhan ko' ian, hap makalandu' ma panganda' kami.’ ” ");
INSERT INTO slm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tasayu uk manga nakura' Yahudi ian in sigam du piandigan uk si Isa, hangkan iya arak siyaggaw uk sigam. Suga' 'nsa' kalanduan sabab tiyāw sigam ma manga Yahudi mahadjana' hi', iya poon iya pisaran uk sigam bo' sigam pakallo' minnihi'. ");
INSERT INTO slm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na, niya' pipahi' ni si Isa manga Parisi maka manga be'-bean si Herod. Siyoho' sigam tiyaw iya pahap bo' supaya iya tasaggaw ma panambung na. ");
INSERT INTO slm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jari itu pahi' sigam ni si Isa bo' uk sigam, “Tuwan Guru, katauhan kami in kau pote' asal atay nu. 'Nsa' du kau tiyāw siyaway uk sayi-sayi sabab sali' du bohan nu ma aa kamemon. Bannal sadja pamandu' nu pasal kawul maka piil iya kibayaan uk Tuhan. Na, bang ma kau, bang kita ganta' mayad sukay ni parinta Roma iya deyo' min Sultan Mahatinggi hi', langgal ta baha' sara' agama tabi? Wajib kita mayad atawa 'nsa'?” ");
INSERT INTO slm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Suga' kitauhan asal uk si Isa pangakkal sigam, hangkan uk na ni sigam. “Angay kaam baya' naggaw aku ma bissala ku? Songin aku pisita. Pandain aku.” ");
INSERT INTO slm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Biyohan iya dakayo' pisita bo' tiyaw na sigam, uk na, “Patta' sayi maka ōn sayi ma sin itu?” “Patta' Sultan Mahatinggi maka sulat na,” uk sambung sigam. ");
INSERT INTO slm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Na!” uk si Isa, “pagka suku' sultan ko' itu pamayarun bi ni iya. Damikkiyan na bang niya' ayi-ayi suku' Tuhan, ungsurin bi isab ni Tuhan.” Inu-inu magtuwi manga aa ian ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Puwas hi' niya' pay'an ni si Isa manga aa Saddusi, daginis agama Yahudi iya uk na 'nsa' niya' 'llum pabing ma 'llaw damuwi. Tiyaw sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tuwan Guru,” uk sigam, “niya' sara' bayi pangamban kitabi uk si Musa pasal aa matay ma 'nsa' taga tubu'. In balu na subay killo' handa uk siyay na bo' supaya niya' anak bista tubu' min aa bayi matay hi'. ");
INSERT INTO slm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na,” uk sigam, “niya' bayi pitu' lalla magdanakan. Maghanda siyaka hi' suga' matay iya ma 'nsa' taga anak. ");
INSERT INTO slm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jari balu hi', killo' handa uk siyay pasunu' bo' matay isab iya ma 'nsa' taga anak. Damikkiyan na isab siyay katallu na. ");
INSERT INTO slm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Papuut ta na, in pitu' magdanakan bayi makahanda ni dakayo' du danda hi' bo' matay sigam kamemon ma 'nsa' taga anak. Ma katapusan na matay isab danda. ");
INSERT INTO slm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, Tuwan,” uk sigam, “bang taabut 'llaw pagpakallum pabayik manga aa magpatayan, handa sayi baha' danda hi'? Sabab bayi iya takallo' handa uk sigam kapitu' magdanakan.” ");
INSERT INTO slm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nambung si Isa ma sigam, uk na, “Iya hangkan kaam sā' sabab 'nsa' katauhan bi bang ayi ma diyōm kitab, maka 'nsa' katauhan bi kōsōg kawasa Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sabab bang manusiya' itu pikallum min kamatay makasali' du sigam ni bangsa malaikat ma diyōm sulga' sabab 'nsa' na sigam maghanda-maghalla. ");
INSERT INTO slm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, iya pasal isab manga aa pikallum pabing min kamatay, kila ku 'nsa' tabassa bi ma diyōm kitab si Musa, iya pasal poon puhung nuleyab. Halling Tuhan ma iya, ‘Aku iya Tuhan di si Ibrahim, si Isahak maka si Ya'kub.’ ");
INSERT INTO slm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tuhan itu,” uk si Isa, “pagtuhanan asal uk manga aa 'llum, 'nsa' uk aa magpatayan. Mehe pahap kasaan bi!” (Hati na masi 'llum di si Ibrahim ian ma diyōm ahirat minsan taggōl na kamatay ginhawa-baran sigam.) ");
INSERT INTO slm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, niya' may'an dakayo' guru ma sara' agama, bo' take na pagbissala si Isa maka manga Saddusi hi'. Tapikil na peen hap panambung si Isa ma sigam, pasikōt iya ni si Isa tiyaw, uk na, “Ingga iya panohoan Tuhan halgaan min kamemon?” ");
INSERT INTO slm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Uk si Isa, “Iya na itu dakayo', iya uk na hi', ‘Pake kaam bangsa Israil! Dakayo' du Panghu' tabi, iya na Tuhan tabi Alla. ");
INSERT INTO slm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wajib kaam lasa tōōd ma Panghu' bi Tuhan. Iya lasa bi ma iya subay min diyōm atay bi, min panahuhan bi, min diyōm ginhawa-baran bi, maka min kōsōg bi.’ ");
INSERT INTO slm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iya na itu panohoan karuwa na, iya uk na hi', ‘Wajib isab kaam lasahan pagkahi bi manusiya' sali' uk bi lasahan baran bi.’ 'Nsa' niya' panohoan makaliyu min duwa panohoan iyu hi'.” ");
INSERT INTO slm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Tawwa', Tuwan Guru,” uk guru ian ni si Isa. “Bannal iya uk nu iyu. In Tuhan tabi dakayo' du. 'Nsa' niya' saddi min iya. ");
INSERT INTO slm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Maka manusiya' itu wajib lasa ma Tuhan min diyōm atay na maka min diyōm ginhawa-baran na maka min kōsōg na. Wajib isab iya lasahan pagkahi na manusiya' sali' uk na lasahan baran na. Halgaan panohoan karuwa itu, wajib biyōgbōgan labi le' min hinang pangungsud sasumbayan atawa lalabōtan kaginis-ginisan ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jari tasayu uk si Isa lōm tau aa ian nambung salaihi', hangkan uk na ma iya, “Kau iyu sikōt na ni diyōman pagparinta Tuhan.” Puwas hi' 'nsa' niya' makatawakkal tiyaw ayi-ayi ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Manjari itu, pasalta' peen si Isa mandu' ma diyōm langgal pagkulbanan, niya' tiyaw na, uk na, “Angay manga guru ma sara' agama magpandu' pasal si Almasi in iya tubu' si Sultan Daud? ");
INSERT INTO slm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sabab si Daud baran na bayi magpalatun, waktu kapagbaya' Nyawa Sutsi ma iya. Salaitu bayi pagpalatun na hi': ‘Bayi ngabtang Tuhan ni Panghu' ku, uk na, Dayi' kau; ningko' kau ma bihing ku sakap ni katau, Bo' bo ku palbantahan nu tatawu' ma deyo' pat-nayi' nu.’ ");
INSERT INTO slm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na,” uk si Isa, “pagka si Almasi iyōnan Panghu' uk si Daud, tantu iya 'nsa' panubu' si Daud sadja.” Manjari landu' heka aa kiyōgan pake ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Uk na ma diyōm pandu' na, “Halliin bi manga guru ma sara' agama, iya tagihan maglunsul magpamakay juba taha'. Tagihan isab sigam hiyulmat bang ma mayiran. ");
INSERT INTO slm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bang ma diyōm langgal baya' sigam pitingko' ma tingkoan bangsahan. Iya du bang sigam ma pagjamuhan, subay paningkoan iya tiyawuan aa langkaw. ");
INSERT INTO slm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nganyaya uk sigam manga luma' balu danda, maka pitaha' uk sigam sambahayang sigam paglaku-laku sigam in sigam bal-iman. Hangkan du pikalap kabinsanaan ma sigam ma ahirat.” ");
INSERT INTO slm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na, ningko' peen si Isa ma diyōm langgal, ma tōngōd tuung pangahugan sin pagjakat, nganda'-nganda' iya ma manga aa ngahug sin pagjakat sigam. Heka aa dayahan hi' ngahug pilak heka. ");
INSERT INTO slm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Manjari niya' pay'an dakayo' danda balu, miskin tōōd, ngahug duwa pisita tumbaga halga' na dakayo' sin. ");
INSERT INTO slm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sakali siyoho' uk si Isa manga mulid na patipun ni iya bo' uk na ma sigam, “Bannal iya pama' ku kaam itu, iya duwa pisita sin tahug uk danda miskin itu halgaan le' min pilak kamemon bayi tahug uk kasehean. ");
INSERT INTO slm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sabab kasehean ian bayi pamuwan sigam min alta' sigam maglabi-labi. Suga' danda itu, minsan iya miskin, bayi muwan sin na kamemon iya arak pamalli na balanja' na.” ");
INSERT INTO slm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Manjari itu, pasalta' peen si Isa paluwas min langgal pagkulbanan, niya' dakayo' mulid na halling ni iya, “'Ndaun ba, Tuwan!” uk na. “Lingkat pahap langgal itu maka manga batu bayi pangahinang iya!” ");
INSERT INTO slm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nambung si Isa, uk na, “Tanda' nu kamehe langgal itu kamemon, a? Suga' baan ta kau, ma sosongun in langgal itu lubu du. 'Nsa' du niya' batu na ngapin magbangkat, kiyanat du kamemon.” ");
INSERT INTO slm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Puwas hi', ningko' peen si Isa ma Bud Kayu Jaitun, ma tampalan langgal pagkulbanan hi', pay'an ni iya si Petros, si Ya'kub, si Yahiya maka si Andariyas, bo' sigam-sigam sadja na. ");
INSERT INTO slm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Uk sigam ni si Isa, “Pahatihun kono' kami bang umay paniya' iya bayi uk nu sini', maka bang paltandaan ayi piluwas bo' kitauhan in pakaradjaan ian kamemon song pitakka na?” ");
INSERT INTO slm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nambung si Isa, uk na, “Kamaya'-maya' kaam bo' kaam 'nsa' kaakkalan. ");
INSERT INTO slm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sabab ma sosongun heka paitu nabbut ōn ku, maglaku-laku in sigam si Almasi na bo' heka tabo-bo iyakkalan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bang niya' take bi hunub-hunub pagbono' ma kasikōtan atawa habal pasal pagbono' ma lahat saddi, daa kaam gawa. Tantu paniya' pagbono' suga' 'nsa' le' ian hi' 'llaw kiyamat. ");
INSERT INTO slm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magbono' du bangsa dakayo' maka dakayo', parinta dakayo' isab maka parinta dakayo'. Paniya' du isab linug ma sabarang lahat, maka paniya' isab gōtōm. Suga' in bala' itu kamemon, tagnaan na sadja, sali' dalil danda battōng bang iyampa tananam na paddi' song nganak. ");
INSERT INTO slm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Suga' kaam iyu,” uk si Isa, “subay painsap tōōd sabab siyaggaw du kaam bo' kaam pitakkahan ni paghukuman. Piglapdōsan du kaam ma diyōm manga langgal Yahudi. Biyo du kaam patampal ni manga gubnul maka ni manga sultan ma sabab aku iya pamean bi, supaya kaam makapatanyag lapal hap ni sigam. ");
INSERT INTO slm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lapal hap itu subay pignasihat dahu ni sabarang bangsa bo' iyampa taabut 'llaw kiyamat dunya. ");
INSERT INTO slm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bang kaam ganta' siyaggaw bo' pitakkahan ni sara' daa kaam magsusa dahu bang ayi subay pamissala bi. Ayi-ayi lapal pamuwan ma kaam bang taabut waktu na, iya na hi' pamissalahun bi. Sabab na 'nsa' baran bi iya halling ma waktu hi' suga' Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma waktu siyong ian niya' du manga aa nukbalan danakan sigam ni aa bo' piyatay. Niya' du isab manga maas lalla nukbalan anak na bo' piyatay. Manga anak isab manta du ma maas sigam, noho' isab subay piyatay. ");
INSERT INTO slm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maka kaam manga mulid ku,” uk si Isa, “kibansihan du kaam uk aa kamemon ma sabab aku iya pamean bi. Suga' lappasan du sayi-sayi hōgōt iman na sampay napusan kabinsanaan ian.” ");
INSERT INTO slm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ma sosongun niya' du tanda' bi ayi-ayi makasammal pibōtang ma 'nsa' patut pabōtangan na. (Sayi-sayi kaam magbassa itu hi' siyoho' pahati). Bang ihi' piniya' na, sasuku pabōtang ma tana' Yahudiya subay lahi pahi' ni kabūd-būran. ");
INSERT INTO slm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bang niya' aa ganta' ma luwasan luma' na subay 'nsa' pabing ma diyōm luma' na ngallo' ayi-ayi na. ");
INSERT INTO slm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bang niya' aa ma huma na subay 'nsa' pabing ngallo' badju' na paghaggut. ");
INSERT INTO slm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","'Ndu', makaase'-ase' manga danda battōng ma masa ian hi' maka manga danda taga anak duru' le'. ");
INSERT INTO slm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amuin bi ase' ni Tuhan bang peen pakaradjaan ian 'nsa' magsabu maka musim haggut. ");
INSERT INTO slm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sabab iya kabinsanaan patumbuk ma masa ma sosongun ian,” uk si Isa, “kalap le' bisa na min kabinsanaan kamemon bayi kalabayan manusiya' sataggōl min waktu pamapanjari dunya uk Tuhan sampay ni kabuttihian. Maka 'nsa' isab kabayikan. ");
INSERT INTO slm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lipara kiyulangan du uk Tuhan taggōl kabinsanaan ian. Bang bayi 'nsa', 'nsa' du niya' ngapin 'llum. Kiyulangan du uk Tuhan ma sabab manga aa na iya asal tapene' na. ");
INSERT INTO slm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na, bang taabut waktu ian hi' bo' niya' ganta' ma' ni kaam, uk na hi', ‘'Ndaun bi! Tiya' na Almasi,’ atawa, ‘Ian na iya may'an,’ daa tōōd kahagarun bi. ");
INSERT INTO slm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sabab na ma waktu ian niya' du paluwas manga aa magnahu'-nahu' in sigam si Almasi atawa in sigam nabi min Tuhan. Magpanda' sigam hinang barakatan maka manga paltandaan kainu-inuhan aa bo' supaya kaakkalan sampay aa suku' Tuhan iya asal tapene' na, bang ganta' tabo iyakkalan. ");
INSERT INTO slm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Suga' painsap kaam,” uk si Isa ni manga mulid na hi'. “Bayi na kaam pahati ku pasal pakaradjaan iyu kamemon, ma 'nsa' le' taabut waktu na.” ");
INSERT INTO slm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma 'llaw ma sosongun ian,” uk si Isa, “puwas peen manga kabinsanaan bayi tasabbut ku hi', ngalindōm du mata 'llaw maka bulan 'nsa' na muwan sawa na. ");
INSERT INTO slm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Manga bituun isab magkapakpak na min diyata' langit maka ayi-ayi bayi pibōtang uk Tuhan ma tōngaan ayan tabo du maglingas. ");
INSERT INTO slm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Puwas hi' makanda' du manga manusiya' ma aku, Anak Manusiya' itu, me' min gabun tudju paitu. Tanda' du uk sigam kōsōg barakat ku maka sahaya ku. ");
INSERT INTO slm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Soho' ku du manga malaikat ku ni 'mpat pidju dunya nipun manga aa bayi tapene' ku, min bihing langit dambiya' maka dambiya'.” ");
INSERT INTO slm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pamintangin bi poon kayu igira,” uk si Isa. “Bang tanda' bi kayu igira itu ngugbus tong engas-engas na sampay ngandawun na tōōd, minnihi' katauhan bi song musim pangallaw na. ");
INSERT INTO slm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Damikkiyan na bang tanda' bi paniya' na bayi pamissala ku ma kaam hi', minnihi' isab katauhan bi in kabayik ku ni dunya sikōt na. ");
INSERT INTO slm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bannal iya pama' ku itu ma kaam, ma 'nsa' le' magpatayan manga aa iya 'llum ma buttihian, paniya' du pakaradjaan kamemon bayi pamissala ku hi'. ");
INSERT INTO slm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Papinda du langit maka dunya suga' kabtangan ku itu 'nsa' tōōd magkapinda.” ");
INSERT INTO slm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“'Nsa' niya' makatau,” uk si Isa, “bang umay 'llaw maka waktu kabayik ku paitu ni dunya. Minsan bangsa malaikat ma diyōm sulga', 'nsa' kitauhan uk sigam. Minsan aku, Anak Tuhan, 'nsa' katauhan ku. Duwal 'Mma' ku Tuhan iya makatau. ");
INSERT INTO slm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Painsap kaam! Pajaga kaam, sabab 'nsa' katauhan bi ian hi' bang umay waktu pamaniya' na. ");
INSERT INTO slm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iya dalil na sali' aa magbamba pakallo' min luma' na mangngan ni lahat saddi. Pajagahan na ayi-ayi na ma manga sosohoan na. Pabōtangan na sigam hinang pakaniya-kaniya, bo' amay-amayan na tunggu' lawang, siyoho' pajaga tōōd. ");
INSERT INTO slm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na,” uk si Isa, “iya du kaam subay pajaga sabab 'nsa' katauhan bi bang umay waktu katakka iya dapu luma', bang song kohap, tōnga' bahangi, waktu panigauk manuk, atawa waktu pagkallat 'llaw. ");
INSERT INTO slm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kamaya'-maya' kaam tagha' takka iya dapu luma', arakala' taabut kaam magtuwihan. ");
INSERT INTO slm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hangkan na panohoan ku ma kaam subay sali' uk ku ma aa kamemon, ‘Pajaga kaam!’ ” ");
INSERT INTO slm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na, duwangallaw le' bo' hinang Pangintōman maka hinang pagkakan manga Yahudi tinapay 'nsa' kalamuran pasulig. Manjari manga kaimaman langkaw maka manga guru ma sara' agama mag-isun bang salaingga uk sigam naggaw ma si Isa ma 'nsa' niya' makatauhan iya, bo' supaya iya piyatay. ");
INSERT INTO slm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Daa pasalta' ta ma pagjamu,” uk sigam, “bo' 'nsa' hiluhala' manga aa mahadjana'.” ");
INSERT INTO slm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, ian si Isa ma Betani, ma diyōm luma' si Simun aa bayi ipul. Ma pagkakanan peen si Isa niya' pay'an ni iya dakayo' danda mo bingki'-bingki' hinangan batu pote', lōōnan 'nsallan pahamut. 'Nsallan itu 'nsallan narda 'nsa' niya' simbug na, landu' halgaan. Jari hiyopo' uk danda kallong bingki'-bingki' bo' tiyumpahan 'nsallan na hi' ni diyata' kok si Isa. ");
INSERT INTO slm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Niya' may'an manga aa ngandugal bo' magbissala-bissala sigam, “Angay 'nsallan halgaan itu pikaat? ");
INSERT INTO slm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Arapun piballihan labi tallu hatus pilak bo' ballihan na ian pamuwan ni manga aa miskin.” Jari siyaway bidda' uk sigam danda bayi numpa hi'. ");
INSERT INTO slm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Suga' halling si Isa, uk na, “Pasarin bi na iya. Angay iya sasaw bi? Hap kalandu' hinang na ma aku itu. ");
INSERT INTO slm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sabab saumul na peen niya' aa miskin ma kaam. Makatabang du kaam ma sigam bang niya' kabayaan bi umay-umay. Suga' aku itu 'nsa' du taggōl ma kaam. ");
INSERT INTO slm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Danda itu bayi makahinang iya takowe' na, hati na tumpahan na 'nsallan pahamut ni baran ku pangawal 'llaw pagkubul ma aku. ");
INSERT INTO slm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bannal iya halling ku itu ma kaam,” uk si Isa, “paingga-paingga lahat pagnasihatan lapal hap ma kalohahan dunya, kissa du pasal bayi hinang danda itu pangintōman manga aa ma iya.” ");
INSERT INTO slm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Puwas peen ian si Judas Iskariyut, dakayo' mulid si Isa min sangpu' ka duwa, bayi pahi' ni kaimaman langkaw bahasa mag-isun nongan si Isa ni sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagtake sigam bang ayi gawi si Judas itu, magtuwi sigam kiyōgan bo' nganjanji' sigam namba iya maka sin. Puwas ian meha na iya waktu hap panong na si Isa ni sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, taabut tagnaan 'llaw paghinang manga Yahudi ma hinang Tinapay 'Nsa' bayi Kalamuran Pasulig. Iya na ian 'llaw panumbay manga anak bili-bili iya kiyakan uk sigam pangintōman waktu bayi kapangalappas Tuhan ma ka'mbo'-mboan sigam ma lahat Misil hi'. Tīyaw si Isa uk manga mulid na. Uk sigam, “Maingga kabayaan nu panakapan kami pagjamuhan nu ma hinang Pangintōman?” ");
INSERT INTO slm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jari siyoho' uk si Isa duwangan mulid na, uk na, “Pahi' kaam ni diyōm daira iyu. Siyampang du kaam uk dakayo' lalla mo kibut lōōnan bohe'. Turulun bi iya ");
INSERT INTO slm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ni luma' iya pasōran na, bo' bain bi aa dapu luma' hi'. Uk bi, ‘Siyoho' kau tīyaw uk guru hi' bang maingga kono' bilik pagjamuhan na maka manga mulid na ma hinang Pangintōman?’ ");
INSERT INTO slm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jari pindaan du kaam bilik loha ma pangkat diyata',” uk si Isa. “Panyap asal bilik ian bo' may'an kaam magsakap kiyakan tabi.” ");
INSERT INTO slm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na, pahi' duwangan mulid hi' ni diyōm daira. Tanda' uk sigam mahi' sali' bayi pamissala sigam uk si Isa bo' siyakap uk sigam kiyakan ma hinang Pangintōman. ");
INSERT INTO slm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Taabut peen song kohap magbe' si Isa maka mulid na sangpu' ka duwa pay'an ni luma' pagsakapan kiyakan hi'. ");
INSERT INTO slm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jari itu, pasalta' sigam mangan, missala si Isa ni sigam, uk na, “Bannal iya halling ku itu ma kaam, niya' dangan min kaam maggara' nongan aku ni banta ku. Tiya' ma itu magsawu maka aku.” ");
INSERT INTO slm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Magtuwi katakkahan susa manga mulid hi' bo' tiyaw sigam ma si Isa magsunu'-sunu'. Uk na hi', “'Nsa' baha' aku?” ");
INSERT INTO slm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Uk sambung si Isa, “Aa du min kaam sangpu' ka duwa, sehe' ku magsawu nublakan tinapay na ni diyōm pinggan itu. ");
INSERT INTO slm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aku itu, Anak Manusiya',” uk si Isa, “matay du sali' bayi tasulat ma pasalan ku ma diyōm kitab. Suga' siya-siya du aa iya nongan Anak Manusiya' ni banta na. Hap le' aa ian 'nsa' bayi iyanakan.” ");
INSERT INTO slm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sabu peen sigam masi mangan, killo' tinapay uk si Isa. Iyamuan uk na pagsukulan bo' iyampa pighopo'-hopo' uk na bo' pamuwan na ma manga mulid na. “Sambutun bi,” uk na, “sabab tinapay itu baran ku ko'.” ");
INSERT INTO slm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Killo' isab uk na dakayo' sawan bo' iyamuan uk na isab pagsukulan bo' iyampa songan na ni sigam panginuman sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uk na ma sigam, “Laha' ku ko' itu, tanda' kapagsulutan Tuhan maka manusiya'. Laha' ku song pitumpa ma sabab aa heka supaya sigam kalappasan. ");
INSERT INTO slm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bannal iya pama' ku itu ma kaam, puwas itu 'nsa' aku nginum bohe' anggul itu pabing. Subay aku ma diyōm pagparintahan Tuhan na bo' iyampa aku nginum bohe' anggul bahu.” ");
INSERT INTO slm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Puwas hi', ubus peen uk sigam bayi ngalang dakayo' kalangan pamudji Tuhan, paluwas na sigam minnihi' tudju ni Bud Kayu Jaitun. ");
INSERT INTO slm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Manjari halling si Isa ni sigam, uk na, “Lahi du kaam kamemon ngalabba min aku sabab tasulat ko' ian ma diyōm kitab. Uk na hi', ‘Papatay ku,’ uk Tuhan, ‘aa bayi ngipat bili-bili bo' kawukanat manga bili-bili bayi daumpigan.’ ");
INSERT INTO slm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Suga' bang aku tapakallum na pabing min kamatay ku parahu du aku min kaam tudju ni lahat Jalil.” ");
INSERT INTO slm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Halling si Petros ni iya, uk na, “'Nsa' tōōd kau 'mbanan ku minsan kau 'mbanan uk kasehean itu.” ");
INSERT INTO slm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Uk si Isa, “Baan ta kau tōōd, ma sangōm itu, ma 'nsa' le' taminduwa panigauk manuk, mayilu du kau min tallu in aku 'nsa' katauhan nu.” ");
INSERT INTO slm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Gam peen kōsōg uk si Petros halling, uk na, “Minsan aku paunung matay ma kau 'nsa' du kau payiluhan ku.” Iya du manga mulid kasehean, salaihi' isab halling sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Manjari palanjal le' sigam ni kabbun iyōnan Getsemane bo' uk si Isa ni manga mulid na, “Maitu le' kaam ningko'. Pay'an le' aku nambahayang.” ");
INSERT INTO slm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iya biyo uk si Isa sehe' na pay'an si Petros maka si Ya'kub maka si Yahiya. Sakali magkasusahan iya, magkabba-kabba atay na. ");
INSERT INTO slm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Uk na ni tallungan mulid na hi', “Aku itu agōn magkamamatay ma sabab kasusahan itu. Ngagad kaam ma itu magjaga.” ");
INSERT INTO slm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Makalawak-lawak peen iya min sigam pahantak iya ni tana' maka uk na nabbut ni Tuhan. Iya iyamu' uk na bang makajari iya 'nsa' na pitakkahan kabinsanaan iya song taabut na. ");
INSERT INTO slm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“'Ndu', 'Mma'!” uk na. “Bang makajari pakalloin le' min aku kabinsanaan itu. Suga' 'nsa' kabayaan ku subay diyulan, bang peen min kabayaan nu.” ");
INSERT INTO slm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Puwas hi' pabing si Isa ni manga mulid na tallungan bo' tatawwa' na sigam magtuwihan. Uk na ni si Petros, “O Simun, tuwi kau? 'Nsa' kau makatatas baha' nganjaga minsan laa danjam sadja? ");
INSERT INTO slm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pajaga kaam. Ngamu' kaam tabang ni Tuhan bo' kaam 'nsa' tabo uk sasat. Baya' tōōd kaam diyōm atay bi me' ma soho' ku suga' 'nsa' takaya uk baran bi.” ");
INSERT INTO slm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sakali pahi' si Isa nabbut ni Tuhan pabing sali' bayi panabbut na dahu. ");
INSERT INTO slm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Makabayik peen iya ni di si Petros tatawwa' na isab sigam magtuwihan pabing sabab kiyaru' kalandu'. 'Nsa' kitauhan uk sigam bang ayi panambung sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pagbayik si Isa kamintallu na, uk na ni sigam, “Oy, tuwi le' kaam? Pahali-hali le' kaam? Sarang na ko' iyu. Taabut na waktu. Aku, Anak Manusiya' itu, song na tiyukbalan ni pangantanan manga aa laat. ");
INSERT INTO slm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Papunduk kaam. Sung na kitabi sabab iyu na aa iya nongan aku ni sigam.” ");
INSERT INTO slm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na, pasalta' peen si Isa halling le' ni manga mulid na, magtuwi du takka pay'an si Judas, dakayo' mulid si Isa min sangpu' ka duwa hi'. Heka aa magbe' maka iya magbo takōs maka manga kakakal. Manga aa ian bayi siyoho' pay'an uk manga kaimaman langkaw sampay uk manga guru ma sara' agama maka manga kamaasan. ");
INSERT INTO slm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Manga aa magtatakōs ian bayi asal biyuwanan pandōga uk si Judas. Bayi uk na ma sigam, “Iya aa siyum ku, iya na hi' saggaw bi. Bohun bi iya pahi' maka jagahin bi iya pahap-hap.” ");
INSERT INTO slm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pagtakka si Judas pay'an magtuwi iya pasikōt ni si Isa. “Tuwan Guru,” uk na. Jari siyum uk na si Isa. ");
INSERT INTO slm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Manjari siyaggaw na si Isa uk manga aa ian, intanan pahōgōt. ");
INSERT INTO slm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Suga' niya' dakayo' min manga aa magtanggehan may'an ngahurusan patakōs na. Liyagut uk na dakayo' sosohoan Imam-nakura' bo' bintas dambiya' tainga na. ");
INSERT INTO slm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Halling si Isa ni manga aa bayi managgaw iya, uk na, “Kaba' bi in aku mundu baha', iya poon kaam subay mo takōs maka kakakal panaggaw bi ma aku? ");
INSERT INTO slm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kahaba'-kahaba' 'llaw bayi aku mandu' ma diyōm langgal pagkulbanan hi'. Mahi' aku ma kaam bo' 'nsa' aku bayi saggaw bi mahi'. Suga' ayi-ayi bayi tasulat ma diyōm kitab subay niya' kamaksuran na.” ");
INSERT INTO slm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Manjari maglahihan manga mulid si Isa kamemon bo' pisaran iya may'an. ");
INSERT INTO slm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Niya' isab may'an dakayo' subul me' ma si Isa, magsiob-siob sadja. Arak iya siyaggaw uk sigam, ");
INSERT INTO slm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","suga' 'mbanan uk na siob bayi pisiag uk na bo' lahi iya ma 'nsa' niya' sammek na. ");
INSERT INTO slm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Manjari itu biyo si Isa uk sigam ni luma' Imam-nakura'. Ian magtipun manga kaimaman langkaw kamemon maka manga kamaasan maka manga guru ma sara' agama. ");
INSERT INTO slm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, si Petros iya bayi paturul ma si Isa suga' min katahan. Paturul iya sampay pasōd na ni diyōm halaman luma' Imam-nakura' bo' may'an iya magtingkoan maka manga jaga imam hi', parangka di na ma bihing api. ");
INSERT INTO slm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iya kaimaman langkaw maka manga aa ma palhimpunan ian kamemon, meha sababan panuntut sigam ma si Isa bo' supaya iya pibōtangan hukuman ni kamatay. Suga' 'nsa' niya' panuntutan tatawwa' uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Heka magsaksi' puting bahasa iya katuntutan suga' 'nsa' mag-uyun saksi' sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Niya' aa kasehean bayi nangge bahasa naksi' panuntut sigam ma si Isa suga' putingan isab. ");
INSERT INTO slm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Uk na hi', “Bayi take kami aa itu ngupama in iya ngalubu langgal pagkulbanan iya hinangan tangan manusiya' ian. Bo' ma diyōm tallu 'llaw kono' matangge iya saddi, suga' 'nsa' manusiya' iya ngahinang iya.” ");
INSERT INTO slm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Suga' minsan le' salaihi' panaksi' sigam 'nsa' du mag-uyun bissala sigam. ");
INSERT INTO slm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Manjari nangge Imam-nakura' ma tangngaan sigam niyaw ma si Isa. Uk na, “Kau iyu, 'nsa' niya' baha' daawa nu ma panuntut ma kau itu?” ");
INSERT INTO slm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Suga' 'nsa' halling si Isa. 'Nsa' iya nambung. Missala pabing Imam-nakura', uk na, “Kau si Almasi baha', Anak Tuhan?” ");
INSERT INTO slm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Aku na,” uk si Isa. “Bo' tanda' bi du aku, Anak Manusiya' itu, ningko' ma bihing Tuhan Sangat Kawasa, sakap ni katau. Maka tanda' bi du aku paitu me' ma gabun min diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Manjari giyese' uk Imam-nakura' juba na sabab min dugal na. Uk na, “Daa na kitabi meha saksi' saddi! ");
INSERT INTO slm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Take bi na halling na pangkal ni Tuhan! Ayi pangahukum bi?” Sakali dauyunan du pangahukum sigam kamemon, in si Isa patut subay piyatay. ");
INSERT INTO slm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jari niya' sigam kasehean nagna' ngaluraan si Isa. Tiyambunan isab bayihu' na uk sigam bo' iyampa pigtibu' uk sigam. Uk sigam ma iya, “Tōkōrun kono' bang sayi nibu' kau!” Siyampak isab iya uk manga jaga, pagkallo' peen sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na, ma diyōm peen si Petros ma halaman luma' hi', niya' palabay minnian dakayo' danda sosohoan Imam-nakura'. ");
INSERT INTO slm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pag'nda' na ma si Petros parangka ma api magtuwi 'nda' na pahap bo' uk na, “Kau iyu, bayi kau me' ma aa Nasaret ian, ma si Isa!” ");
INSERT INTO slm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Suga' mayilu magtuwi si Petros. “'Nsa' katauhan ku,” uk na. “'Nsa' tahati ku bang ayi halling nu iyu.” Bo' pakallo' iya minnihi' tudju ni bo' lawang paluwas min halaman hi'. Jari nigauk manuk. ");
INSERT INTO slm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tanda' na iya pabing uk sosohoan danda hi' bo' halling iya ni manga aa magtanggehan may'an. Bayikan uk na bayi halling na tagna'. “Aa iyu,” uk na, “bayi sehe' sigam du.” ");
INSERT INTO slm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Suga' mayilu na isab si Petros. 'Nsa' taggōl halling ni si Petros manga aa magtanggehan may'an. Uk sigam, “Katauhan kami du in kau bannal bayi sehe' di si Isa sabab aa Jalil du kau isab!” ");
INSERT INTO slm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sakali napahan di na si Petros bo' uk na, “'Nsa' katauhan ku aa pagbissala bi iyu!” ");
INSERT INTO slm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Saruun-duun du nigauk manuk, kaminduwa na na, bo' taintōm uk si Petros iya bayi halling si Isa ma iya, iya bayi uk na, “Ma 'nsa' le' nigauk manuk min duwa, mayilu du kau min tallu in aku 'nsa' katauhan nu.” Pag-intōm itu uk si Petros, magtuwi iya nangis, magkarukkaan tōōd. ");
INSERT INTO slm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Taabut peen pagkallat 'llaw, magtuwi pasaut manga kaimaman langkaw magtipun maka kamaasan maka manga guru ma sara' agama. Jari mag-isun sigam maka palhimpunan pagsaraan kamemon bang inay sigam ma si Isa. Pag-isun peen, bilangguan iya uk sigam bo' biyo pahi', tiyukbalan ni si Pilatu. ");
INSERT INTO slm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mahi' peen, tiyaw si Pilatu ma si Isa, uk na, “Kau iyu, sultan kau baha' ma bangsa Yahudi?”. Nambung si Isa, uk na, “Iya na uk nu iyu.” ");
INSERT INTO slm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na, heka panuntut manga kaimaman langkaw ian ma iya, ");
INSERT INTO slm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","hangkan iya tīyaw pabing uk si Pilatu, uk na, “'Nsa' niya' panambung nu? 'Ndaun kaheka panuntut sigam itu ma kau.” ");
INSERT INTO slm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Suga' 'nsa' niya' sambung si Isa hangkan inu-inu tōōd si Pilatu hi'. ");
INSERT INTO slm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, kahaba' tahun, ma waktu paghinang bangsa Yahudi ma hinang Pangintōman, iya kabiyaksahan si Pilatu subay niya' dakayo' pilisu palappa na, sayi-sayi pene' uk manga aa Yahudi. ");
INSERT INTO slm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jari ma waktu ian niya' aa bayi tajil, ōn na si Barabbas. Ian iya maka manga sehe' na bayi mapatay aa ma waktu panagga' sigam ma parinta. ");
INSERT INTO slm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sakali itu heka manga aa paalōp ni si Pilatu ngamu' subay pilappa uk na dakayo' pilisu sali' kabiyaksahan kahaba'-haba' tahun. ");
INSERT INTO slm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tīyaw sigam uk si Pilatu, uk na, “Baya' kaam baha' bang palappahan ku kaam sultan bangsa Yahudi itu?” ");
INSERT INTO slm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hangkan sigam tiyaw na salaihi' sabab katauhan na asal bang ayi sababan na hangkan si Isa bayi pitakka ni iya. Tuud sigam ngimbu ma si Isa. ");
INSERT INTO slm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Suga' baanan aa ian bayi pitnahan asal uk kaimaman langkaw, siyoho' ngamu' si Barabbas pilappa uk si Pilatu, 'nsa' si Isa. ");
INSERT INTO slm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Missala si Pilatu ni sigam pabing, uk na, “Inay ku na baha' aa itu, iya ōnan bi sultan bangsa Yahudi?” ");
INSERT INTO slm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngōlang sigam pakōsōg, uk na hi', “Lansangun iya ni hag!” ");
INSERT INTO slm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Angay?” uk si Pilatu. “Ayi bayi hinang na laat?” Pasong pakōsōg pangōlang sigam hi'. Uk sigam, “Lansangun iya ni hag!” ");
INSERT INTO slm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Manjari si Pilatu baya' marul ma manga aa magtipunan hi' hangkan palappa na si Barabbas ni sigam. Bo' si Isa iya siyoho' liyapdōsan bo' iyampa tiyukbalan pilansang ni hag piyatay. ");
INSERT INTO slm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manjari si Isa biyo na uk manga sundalu pahi' ni halaman ma diyōm luma' gubnul bo' linganan patipun pahi' dambaan sundalu ian kamemon. ");
INSERT INTO slm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pijubahan iya manta taluk sali' dagbōs pakayan sultan. Liyubid isab bahan itingan uk sigam, hinang sali' panumping sultan pibōtang ni kok na. ");
INSERT INTO slm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jari nagna' sigam magbawu'-bawu' mag-addat ma iya. Uk sigam, “Assalamu alaykum, Appa' Sultan Yahudi!” ");
INSERT INTO slm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pigpappōk kok na uk sigam maka kayu-kayu, maka liyuraan iya. Pasujud sigam pagmahaltabat sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na, ubus peen uk sigam magtungging ma iya, hiyurusan uk sigam manta taluk bayi pajuba na bo' iyampa iya pisammekan maka bayi sammek na tagna'. Puwas hi' biyo iya paluwas minnihi' bo' liyansang ni hag pamapatayan iya. ");
INSERT INTO slm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Manjari niya' aa palabay minnian, ōn na si Simun, palud min de tudju ni Awrusalam. (Si Simun itu 'mma' si Iskandal maka si Rupus, aa iya min lahat Kirini.) Jari liyōgōs iya uk manga sundalu, siyoho' nanggung hag song pangalansangan si Isa. ");
INSERT INTO slm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Biyo iya patukad ni jadjahan lahat iyōnan Golgota, hati na lahat “Baung Kok”. ");
INSERT INTO slm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mahi' peen, niya' arak pamainum sigam ma si Isa bohe' anggul (sali' tuba') kalamuran tambal iyōnan mira, suga' 'nsa' tayima' na. ");
INSERT INTO slm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Puwas hi' liyansang iya ni hag uk manga sundalu bo' iyampa pitangge hag na. Pigbahagian uk sigam manga sammek na, pigkoot-kootan uk sigam bo' kitauhan bang sammek ingga ma sigam dangan maka dangan. ");
INSERT INTO slm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iya waktu kapangalansang sigam ma si Isa ian bayi ma ōtan waktu subu maka waktu lattu 'llaw. ");
INSERT INTO slm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Salaitu iya sulat bayi pibōtang panuntut iya, uk na hi': “Sultan bangsa Yahudi.” ");
INSERT INTO slm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Niya' isab duwangan mundu bayi pibe' ma si Isa liyansang ma hag sigam. Dakayo' hag ian bayi pitangge ma bihing si Isa sakap ni katau, dakayo' ma sakap ni kayi.  ");
INSERT INTO slm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Minnihi' niya' kamaksuran ma bayi tasulat ma diyōm kitab, iya uk na hi', “Talapay iya ma manga aa langgal sara'”. ");
INSERT INTO slm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, piggunyak-gunyak si Isa uk aa maglawulabay. Pighanduk-handukan iya uk sigam pangudju'. “Ne!” uk sigam. “Kau na iya bilang ngalangkat langgal pagkulbanan ian bo' pabangun nu kono' pabing ma diyōm tallu 'llaw! ");
INSERT INTO slm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pareyo' kau min hag iyu bo' kau ngalappasan di nu!” ");
INSERT INTO slm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iya du magpangudju' manga imam langkaw maka manga guru ma sara' agama. Uk bissala sigam ma pasal na, “Aa itu,” uk sigam, “tau ngalappas ma aa saddi suga' 'nsa' makalappasan di na! ");
INSERT INTO slm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si Almasi kono' iya, sultan bangsa Israil. Subay iya mareyoan di na min hag ian. Jari bang iya tanda' tabi pareyo' ngahagad du kitabi ma iya!” Iya du duwangan aa bayi liyansang ni hag pibe' ma si Isa, me'-me' isab ngudju' iya. ");
INSERT INTO slm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jari itu, lattu peen 'llaw, tawwa' lindōm kalohahan lahat hi' sampay ni lisag tallu kohap. ");
INSERT INTO slm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Paglisag tallu kōsōg uk si Isa ngalingan, uk na, “Eloi, eloi, lama sabaktani?” Hati na, “Tuhan ku, O Tuhan ku, angay na aku pasaran nu?” ");
INSERT INTO slm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pagtake itu uk manga aa magtanggehan may'an, uk sigam kasehean, “Pake kaam. Ngalinganan iya si Nabi Eliyas.” ");
INSERT INTO slm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Magtuwi niya' dakayo' aa parayi'-dayi' ngahagōman lappus ni diyōm inuman kissōm (sali' tuba'). Puwas hi' pisagnat uk na ni tong kayu-kayu bo' iyampa songan na ni si Isa pamasassōp na ma iya. Uk aa hi', “Ngagad le' kaam. 'Nda' ta le' bang paluwas si Nabi Eliyas mareyo' iya min hag.” ");
INSERT INTO slm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sakali ngōlang si Isa min tadda, magtuwi bakkat napas na. ");
INSERT INTO slm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Saruun-duun du iya kulambu' bayi pangagpang ma diyōm langgal pagkulbanan ian gese' paruwa min diyata' na tudju pareyo'. ");
INSERT INTO slm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tanda' peen uk kapitan iya nangge paharap ma hag ian bang salaingga kabakkat napas si Isa, halling uk na, “Bannal aa itu Anak Tuhan!” ");
INSERT INTO slm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Niya' isab may'an manga danda nganda'-nganda' min katahan. Ian ma sigam di si Mariyam min Magdala maka si Salome, ian isab si Mariyam ina' si Joses maka si Ya'kub dakayo' iya bata' le'. ");
INSERT INTO slm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Manga danda itu bayi me' paumpig ma si Isa ngadjalan iya waktu kamahi' na le' ma lahat Jalil. Heka isab manga danda saddi may'an, aa bayi me' ma iya tudju ni Awrusalam. ");
INSERT INTO slm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","'Llaw Pagsakap ko' ian, hati na dangallaw dahu min 'llaw Sabtu'. Jari itu, pagkohap peen 'llaw ian, ");
INSERT INTO slm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","takka pay'an si Yusup aa min kalumaan Arimati. Dakayo' maas iya ma Palhimpunan, aa pig-addatan. Tuyu' asal iya ngagaran waktu pamabōtang parinta Tuhan. Sakali magtawakkal iya paalōp ni si Pilatu ngamu' patay si Isa. ");
INSERT INTO slm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Inu-inu si Pilatu pagka take na matay na si Isa. Linganan uk na kapitan bo' tiyaw na bang bannal matay na si Isa. ");
INSERT INTO slm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagtake si Pilatu ma lapal kapitan in si Isa matay na, jari diyulan uk na si Yusup ngallo' patay na. ");
INSERT INTO slm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Malli si Yusup kakana' panaput bo' pireyo' uk na patay si Isa min diyata' hag bo' iyampa siyaput uk na. Puwas hi' pibōtang uk na ma diyōm pagkubulan bayi kiyalihan ma diyōm pampang batu bo' giyulungan uk na batu panaplōk bo' lowang hi'. ");
INSERT INTO slm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ian nganda'-nganda' si Mariyam min Magdala maka si Mariyam ina' si Joses, bo' tanda' uk sigam bang maingga pangubulan si Isa. ");
INSERT INTO slm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palabay peen 'llaw Sabtu', ian si Mariyam aa Magdala maka si Salome maka si Mariyam ina' si Joses malli laksi' maka 'nsallan pahamut pamalihala' sigam ma mayat si Isa. ");
INSERT INTO slm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Manjari pagkallat 'llaw Ahad, bo' subu-subu tōōd, pahi' sigam ni pagkubulan. ");
INSERT INTO slm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Magbissala na peen sigam ma labayan. Uk na hi', “Sayi baha' nganggulungan batu panaplōk lowang hi' bo' kitabi makasōd?” Mehe asal batu ian. ");
INSERT INTO slm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pagtakka sigam pay'an tanda' uk sigam batu hi' bayi giyulungan. ");
INSERT INTO slm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jari pasōd sigam ni diyōm lowang kubul bo' niya' tanda' uk sigam dakayo' lalla bata' le', magjuba pote', ningko' tampal ni katau. Magtuwi sigam kiyōblaan tōōd. ");
INSERT INTO slm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Uk lalla itu ma sigam, “Daa kaam tiyāw. Katauhan ku, iya peha bi si Isa aa Nasaret iya bayi liyansang ni hag piyatay. 'Nsa' na iya ma itu. 'Llum na iya pabing min kamatay na. 'Ndaun bi bayi pamalegehan iya. ");
INSERT INTO slm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, pahi' na kaam,” uk na, “mo lapal itu ni manga mulid na maka ni si Petros. Uk bi ni sigam, ‘Parahu du iya min kaam ni lahat Jalil. Mahi' du kaam nganda' ma iya sali' bayi halling na ma kaam.’ ” ");
INSERT INTO slm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Manjari paluwas manga danda hi' bo' paragan sigam min kubul. Midpid asal sigam sabab min kōbla' sigam. 'Nsa' niya' halling sigam ni sayi-sayi sabab tiyāw sigam. ");
INSERT INTO slm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, 'llum peen si Isa pabing min kamatay na ma dayi'-llaw Ahad ian, magtuwi iya magpanda' dahu ni si Mariyam danda min Magdala, iya bayi piluwasan uk na pitu' sayitan. ");
INSERT INTO slm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Manjari si Mariyam itu bayi pahi' ni manga mulid si Isa ma'-ma' ma sigam. Ian asal sigam magkarukkaan maka magtangis. ");
INSERT INTO slm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Suga' biyaan peen sigam uk si Mariyam in si Isa 'llum maka bayi kono' tanda' na, 'nsa' sigam kahagad ma iya. ");
INSERT INTO slm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Puwas hi' paluwas isab si Isa ni duwangan mulid na pasalta' sigam mangngan tudju karehan, bo' saddi dagbōs na. ");
INSERT INTO slm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Manjari pabayik duwangan mulid hi' ni Awrusalam ma'-ma' ma manga sehe' sigam. Suga' iya du sigam 'nsa' kahagad uk kasehean ian. ");
INSERT INTO slm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Puwas hi' paluwas na si Isa ni mulid na sangpu' kadda pasalta' peen sigam mangan. Pihallingan sigam uk na sabab 'nsa' sigam ngahagad maka tuwas kok sigam. 'Nsa' sigam baya' magkahagad minsan sigam biyaan uk manga aa bayi makanda' si Isa 'llum na pabing min kamatay na. ");
INSERT INTO slm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Manjari missala iya ni sigam, uk na, “Pahi' kaam ni sabarang lahat ma kalohahan dunya bo' nasihatun bi lapal hap itu ni manusiya' kamemon. ");
INSERT INTO slm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sayi-sayi magkahagad sampay piyandi tanda' in sigam mangandōl ma aku,” uk si Isa, “lappasan du iya saumul-umul. Suga' sayi-sayi 'nsa' magkahagad, pibōtangan du iya hukuman Tuhan. ");
INSERT INTO slm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Manga aa mangandōl ma aku kabuwanan du kawasa maghinang manga hinang makainu-inu. Makapakallo' du sigam manga sayitan sabab min kawasa ōn ku. Makabissala isab sigam ma manga bahasa saddi 'nsa' bayi kitauhan uk sigam. ");
INSERT INTO slm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bang sigam ganta' makaantanan so, atawa makainum ayi-ayi makamula, 'nsa' du makainay ma sigam. Maka bang piabut tangan sigam ni aa taga saki kaulian du manga aa ian.” ");
INSERT INTO slm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Manjari itu, ubus peen si Panghu' Isa bayi magbissala maka manga mulid na, tabo iya paangkat tudju ni sulga' bo' ningko' iya ma bihing Tuhan sakap ni katau, ma tingkoan bangsahan. ");
INSERT INTO slm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jari mangngan na manga mulid na magnasihat ma sabarang lahat. Tiyabangan sigam uk si Panghu' Isa, biyuwanan sigam barakat maghinang manga hinang kawasahan bo' supaya kitauhan in pandu' sigam asal bannal. ");
INSERT INTO slm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Asal heka aa bayi nulat pasal kamemon bayi tahinang ma diyōman kami. ");
INSERT INTO slm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iya siyulat uk sigam ian iya bayi pangalapal ni kami uk manga aa bayi makanda' kahinangan si Isa sataggōl min katagna', maka sigam itu bayi magnasihat isab ma palman Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na, tuwan Teyopilus, pagka tapaliksa' ku pahap kamemon bayi tahinang itu sataggōl min katagna' na, tapikil ku in aku isab wajib nulatan kau ma pasal na. Subay usul ku min katagna' na sampay ni katapusan na ");
INSERT INTO slm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","bo' supaya katauhan nu kasabannalan na tōōd pasal kamemon bayi pamandu' ma kau. ");
INSERT INTO slm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Salaitu iya tagnaan na: ma timpu le' bayi pagsultan si Sultan Herod ma lahat Yahudiya niya' imam iyōnan si Jakariya. Dakayo' imam iya ma tumpukan manga imam me' maka si Imam Abiya. Iya du handa na si Elesabet, min panubu' kaimaman isab sabab tubu' min si 'Mbo' Harun. ");
INSERT INTO slm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bōntōl sadja sigam duwangan ma panganda' Tuhan. Biyōgbōgan uk sigam sara' na maka panohoan na kamemon ma 'nsa' niya' sā' na. ");
INSERT INTO slm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Suga' 'nsa' sigam taga anak sabab 'nsa' makaanak si Elesabet, maka toa na sigam duwangan. ");
INSERT INTO slm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jari itu niya' dakayo' 'llaw paghinang si Jakariya maka kasehean na ma langgal pagkulbanan, bo' si Jakariya na paganti' mag-imam. ");
INSERT INTO slm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iya addat manga imam hi' subay magkoot ōn bo' kitauhan bang sayi iya pene' nugtug kamanyan tudju ni Tuhan. Jakariya iya tapene' pasōd ni diyōm langgal Tuhan hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Maka heka aa magtipun may'an ma halaman langgal nambahayang ma waktu panugtug kamanyan hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jari niya' panyata' ni iya dakayo' malaikat min Tuhan nangge ma bihing panugtugan kamanyan, ma bihing na ni katau. ");
INSERT INTO slm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pag'nda' si Jakariya ma malaikat, magtuwi iya kiyōblaan maka tiyāw. ");
INSERT INTO slm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Suga' halling malaikat ni iya, uk na, “Daa kau tiyāw, Jakariya, sabab take uk Tuhan iya bayi amu' nu iyu. In handa nu si Elesabet nganak du dakayo' anak lalla, bo' si Yahiya iya pangōn bi ma iya. ");
INSERT INTO slm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mehe du kakōgan bi, maka heka aa isab kiyōgan bang iyanakan na si Yahiya hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sabab pilangkaw du iya ma panganda' Tuhan. 'Nsa' du iya nginum ayi-ayi makalango. Sataggōl min 'llaw panganak ma iya kahōpan asal iya uk Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Maka heka manga aa Israil tabo na du magtaat pabing ni Tuhan iya pagpanghuan sigam. ");
INSERT INTO slm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anak nu si Yahiya itu parahu du min Panghu'. Kapag-agihan iya uk Nyawa Sutsi sali' si Nabi Eliyas ma awwal jaman hi', maka pisukuan iya barakat isab sali' bayi ma si Eliyas hi'. Manga maas maka anak sigam bayi magsagga', pipaghap du uk na. Sampay manga aa bayi mabiyal ma panohoan Tuhan, tabo du uk na mindahan pikilan sigam ni pikilan bōntōl. Pisakap uk na manga aa bo' mammōs na bang takka Panghu' sigam.” ");
INSERT INTO slm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Uk si Jakariya ni malaikat hi', “Salaingga katauhan ku in bissala nu iyu bannal? Toa na aku maka handa ku toa isab.” ");
INSERT INTO slm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Iya sambung malaikat hi', uk na, “Aku itu si Jibrail. Aku iya nangge ma haddarat Tuhan. Bayi aku siyoho' uk na paitu missala ni kau masampay lapal hap itu. ");
INSERT INTO slm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pake kau. Pagka kau iyu 'nsa' magkahagad ma bissala ku, ngumaw du kau. 'Nsa' kau makabissala min 'llaw itu sampay tahinang bayi pangalapal ku ma kau. Hangkan salaihi', sabab 'nsa' kau magkahagad ma bayi lapal ku ma kau, iya lapal tantu katumanan du bang taabut waktu na.” ");
INSERT INTO slm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sabu peen ian hi' ngagad kahekahan aa hi' ma si Jakariya. Inu-inu sigam bang ayi kataggōlan na ma diyōm langgal hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Taabut peen iya paluwas 'nsa' na iya makabissala ma sigam, hangkan kitauhan uk sigam niya' bayi pinyata' ni iya ma diyōm langgal ian. Ninyal sadja iya ma sigam sabab 'nsa' na iya makapaluwas bissala. ");
INSERT INTO slm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Manjari, ubus peen waktu paghinang na ma diyōm langgal pagkulbanan hi', magtuwi iya mowe' ni lahat na. ");
INSERT INTO slm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Taggōl-taggōl peen minnihi' battōng na si Elesabet bo' ma diyōm limam bulan 'nsa' iya bayi magluwas-luwas min diyōm luma'. ");
INSERT INTO slm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Uk na, “Hap tabang Tuhan ma aku. Kapakalloan na uk na kaiyaan bayi pamakaiya' aku uk manga pagkahi ku, sabab tiya' na aku song taga anak.” ");
INSERT INTO slm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Taabut peen 'nnōm bulan ma si Elesabet, siyoho' uk Tuhan malaikat na si Jibrail pahi' ni dakayo' kalumaan ma lahat Jalil iyōnan Nasaret. ");
INSERT INTO slm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Siyoho' iya panyata' ni dakayo' budjang, ōn na si Mariyam. Si Mariyam itu magtunang maka si Yusup, dakayo' panubu' si Sultan Daud iya bayi sultan bangsa Israil ma awwal jaman. ");
INSERT INTO slm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pagpahi' malaikat hi' ni si Mariyam, uk na ni iya, “Assalamu alaykum. Mehe kahapan Tuhan ma kau, Mariyam. Kau iya tapene' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Suga' pagtake peen itu uk si Mariyam magtuwi sasaw pikilan na, bo' pikil-pikil uk na bang ayi hati na hangkan iya bissalahan salaihi'. ");
INSERT INTO slm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Manjari halling malaikat ni iya, uk na, “Daa kau giyawa, Mariyam, sabab kasulutan Tuhan ma kau. ");
INSERT INTO slm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pake kau. Song kau battōng. Nganak du kau lalla bo' si Isa iya pangōn nu iya. ");
INSERT INTO slm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bangsahan du iya tōōd, iyōnan du iya Anak Tuhan Mahatinggi. Pibōtang iya magsultan uk panghu' Tuhan, sali' bayi kapagsultan 'mbo' na si Daud ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bo' magsultan du iya ma bangsa Israil, iya panubu' si Ya'kub, sampay ni kasaumulan. 'Nsa' du patōbtōb pagsultan na.” ");
INSERT INTO slm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Uk si Mariyam ni malaikat, “Salaingga paniya' iya uk nu iyu, sabab masi le' aku budjang?” ");
INSERT INTO slm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iya sambung malaikat, uk na, “Patakka du ni kau Nyawa Sutsi maka kalandungan kau uk barakat Tuhan Mahatinggi, hangkan sutsi du onde' iya iyanakan uk nu bo' iyōnan iya Anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Intōmun isab kampung nu si Elesabet. Battōng iya buttihi' minsan toa na. Kannōm na bulan ma iya, iya bayi iyōnan danda 'nsa' makaanak. ");
INSERT INTO slm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sabab bang ma Tuhan 'nsa' niya' hunit,” uk malaikat hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jari halling si Mariyam, uk na, “Aku itu sosohoan Tuhan. Maglilla' du aku ma pama' nu iyu.” Magtuwi pakallo' malaikat hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na, 'nsa' taggōl minnihi', magsakap si Mariyam bo' parayi'-dayi' pahi' ni dakayo' kalumaan ni de ma hi' ma lahat Yahudiya. ");
INSERT INTO slm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagtakka na pahi' magtuwi iya pariyata' ni luma' si Jakariya bo' siyum uk na si Elesabet hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Take peen uk si Elesabet bissala si Mariyam, magtuwi magsikal na onde' ma diyōm battōng na bo' kahōpan iya uk Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Missala iya pakōsōg ma si Mariyam, uk na, “Kau iyu kabuwanan kahapan uk Tuhan labi min danda kamemon ma dunya itu. Damikkiyan du isab onde' iya song iyanakan uk nu, maglabi-labi isab kahapan iya pamuwan ma iya. ");
INSERT INTO slm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Angay aku subay pimehe uk ina' Panghu' ku, pagka tiya' iya nibaw ma aku? ");
INSERT INTO slm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pagtake ku ma bissala nu sini' magtuwi onde' ma diyōm battōng ku itu magsikal tōōd sabab kiyōgan na. ");
INSERT INTO slm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mehe kahapan nu sabab magkahagad du kau in palman Tuhan ma kau tiyuman du.” ");
INSERT INTO slm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Manjari halling si Mariyam, uk na, “Sanglitan ku Tuhan min diyōm atay ku. ");
INSERT INTO slm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kiyōgan aku ni Tuhan iya ngalappas ma aku. ");
INSERT INTO slm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sabab taintōm uk na aku, dakayo' sosohoan na deyo' pangatayan na. Puwas min 'llaw itu bista uk aa kamemon, in aku asal danda bayi pisukuan kahapan, ");
INSERT INTO slm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sabab makainu-inu kahinangan Tuhan Kawasa iya panabang na ma aku. Asal iya landu' sutsi. ");
INSERT INTO slm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maase' iya ma sasuku magpamehe ma iya min panubu' dakayo' sampay ni dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pindaan uk na kawasa na ma manga kahinangan na, bo' pigkawukanat uk na manga aa abbuhan maka paggara' sigam. ");
INSERT INTO slm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pikalloan uk na manga sultan min pagsultanan sigam, maka aa deyo'-deyo' pilangkaw uk na. ");
INSERT INTO slm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Manga aa tiksa' biyuwanan uk na lidjiki' heka, maka aa dayahan pipowe' uk na ma 'nsa' niya' tabo sigam. ");
INSERT INTO slm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tatuman uk Tuhan bayi janji' na ma ka'mbo'-mboan tabi, hangkan tiyabang uk na sosohoan na, iya bangsa tabi Israil. ");
INSERT INTO slm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bayi iya nganjanji' ma si Ibrahim in iya subay kaasean na saumul-umul. Damikkiyan na isab kitabi panubu' na.” ");
INSERT INTO slm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, kulang-labi tallum bulan iya kahanti' si Mariyam ma si Elesabet bo' iyampa mowe'. ");
INSERT INTO slm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taabut peen 'llaw panganak si Elesabet, jari nganak iya lalla. ");
INSERT INTO slm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagtake peen uk manga kampung maka lungan si Elesabet pasal mehe kahapan Tuhan ma iya, magbe' sigam maka iya kiyōgan. ");
INSERT INTO slm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na, pagka walu' 'llaw na onde' ma luwasan, magtipun manga aa ian mag-islam ma iya. Arak iya iyōnan si Jakariya uk sigam, sali' ōn 'mma' na, ");
INSERT INTO slm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","suga' ngalāng ina' na. Uk na, “Daa. Subay iya iyōnan si Yahiya.” ");
INSERT INTO slm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Angay?” uk sigam. “'Nsa' niya' min lung-kampung nu iyōnan si Yahiya.” ");
INSERT INTO slm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Manjari ninyal sigam ni 'mma' onde' ian bang ayi kabayaan na pangōn ma onde' ian. ");
INSERT INTO slm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ninyal isab si Jakariya ngamu' panulatan bo' salaitu iya panulat na: “Ōn na si Yahiya!” Inu-inu makalandu' manga aa ian kamemon. ");
INSERT INTO slm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Saruun-duun du makabissala si Jakariya pabayik maka siyanglitan uk na Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Takkahan tāw manga lung-kampung di si Jakariya, maka habal pasal bayi tahinang ian patanyag na peen ni kare-rehan lahat Yahudiya hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sasuku isab makake habal ian magpikilan tōōd. Uk sigam, “Ayi baha' pangangganta' Tuhan ma onde' ian?” Sabab pasti' in onde' ian kaniyaan barakat uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Manjari si Jakariya, 'mma' si Yahiya hi', bayi kahōpan uk Nyawa Sutsi bo' piluwas uk na palman Tuhan, uk na, ");
INSERT INTO slm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sanglitan tabi Panghu', iya pagtuhanan bangsa tabi Israil. Sabab na paitu na iya nabangan kitabi manga aa suku' na bo' piyuwasan na kitabi uk na min kasigpitan. ");
INSERT INTO slm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Biyuwanan du isab kitabi uk na aa makagaōs ngalappas ma kitabi. Tubu' du aa itu min si Sultan Daud iya bayi sosohoan Tuhan hi'. ");
INSERT INTO slm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Janji' Tuhan ko' itu, bayi pilatun uk manga nabi na sutsi. ");
INSERT INTO slm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iya uk janji' hi', in kitabi piyuwasan du uk na min manga banta tabi, sampay min pangantanan manga aa bansihan kitabi. ");
INSERT INTO slm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Uk Tuhan isab in bayi ka'mbo'-mboan tabi ian kaasean na du, maka tuman na du bayi janji' na pagsulutan na maka sigam. ");
INSERT INTO slm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iya na janji' bayi panganjanji' na ma si Ibrahim, pipagtapil maka sapa na, ");
INSERT INTO slm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bayi iya napa in kitabi panubu' si Ibrahim piyuwasan du min pangantanan manga banta tabi. Jari makapaghinang kitabi ma Tuhan ma 'nsa' niya' makitāw, ");
INSERT INTO slm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bo' supaya sutsi pangatayan tabi maka bōntōl kahinangan tabi sataggōl kitabi 'llum ma dunya itu.” ");
INSERT INTO slm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jari missala si Jakariya ma anak na, uk na, “Kau, Oto', iyōnan du kau nabi min Tuhan Landu' Kawasa, Kau iya parahu du min Panghu' nu mahap daddōk palabayan na. ");
INSERT INTO slm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sabab kau iya matau manga aa na in sigam lappasan du min mulka', pagka iyampun dusa sigam. ");
INSERT INTO slm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sabab Tuhan tabi landu' maase' maka lunuk atay na. Biyuwanan kitabi sawa min diyōm sulga', sali' hantang 'llaw paluwas min sōbangan. ");
INSERT INTO slm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sasuku pabōtang ma diyōm kalindōman ma sabab tiyāw matay, tawwa' du sigam sahaya na, maka piyanduan kitabi daddōk hap iya mo kita ni kasannangan atay.” ");
INSERT INTO slm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Manjari anak si Jakariya ian pasuwig na peen maka pasong isab akkal-pikilan na. Bo' pabōtang iya ma lahat de iya 'nsa' agōn kalluman ayi-ayi, sampay taabut 'llaw paluwas na ni manga aa Israil. ");
INSERT INTO slm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma waktu ian si Agustus iya Sultan Mahatinggi ma bangsa Roma. Manjari magpanoho' iya subay pigsulat ōn aa kamemon ma sabarang lahat ma kalohahan pagsultanan na. ");
INSERT INTO slm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyampa niya' panohoan salaihi' pamasulat ōn aa kamemon, maka si Kirinu iya gubnul ma kalingkal lahat Siriya ma timpu ian hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jari magpowean manga aa kamemon ni lahat ka'mbo'-mboan sigam magpasulat ōn sigam. ");
INSERT INTO slm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Yusup iya bayi pakallo' min Nasaret dakayo' kalumaan ma lahat Jalil, pahi' tudju ni lahat Yahudiya, ni kalumaan Betlehem iya bayi lahat panganakan si Sultan Daud ma masa awwal hi'. Pay'an iya magpasulat ōn na sabab tubu' iya min si Daud. ");
INSERT INTO slm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Magbe' iya maka si Mariyam, iya bayi pihandahan ma iya, supaya sigam magpasulat ōn sigam pahi'. Si Mariyam battōng na. ");
INSERT INTO slm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jari itu, mahi' peen sigam ma Betlehem, taabut 'llaw na mag-anak. ");
INSERT INTO slm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iyanakan uk na anak na siyaka, lalla. Pilampinan uk na maka sammek bo' iyampa pibahak ma diyōm tuung pamanganan hayōp ipat, sabab 'nsa' niya' lugal ma sigam ma diyōm luma' paghantian hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, niya' ma jadjahan ian hi' manga aa nunggu' bili-bili sigam ma kahayangan ma kaparangan, waktu sangōm. ");
INSERT INTO slm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sakali niya' panyata' ni sigam malaikat min Tuhan, maka nayinag sahaya Tuhan ma katilibut sigam. Jari tiyāw sigam kalandu'. ");
INSERT INTO slm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Suga' uk malaikat ni sigam, “Daa kaam tiyāw sabab tiya' aku mohan kaam lapal hap, lapal makapakōg atay manga aa kamemon. ");
INSERT INTO slm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iyanakan na aa ngalappasan kaam, hati na si Almasi, iya Panghu'. 'Llaw itu iya panganak ma iya, ma Betlehem iya bayi paglahatan si Sultan Daud ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Maka iya na itu tanda' na pamabannal ma kaam: makatawwa' du kaam anak pilampinan maka sammek, ian pabahak ma diyōm tuung pamanganan hayōp.” ");
INSERT INTO slm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Magtuwi niya' baanan malaikat min sulga' tanda' uk manga tunggu' bili-bili ian ma tōngōd malaikat dakayo' hi'. Mudji manga malaikat itu ma Tuhan, uk sigam, ");
INSERT INTO slm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wajib Tuhan siyanglitan ma diyōm sulga', Mura-murahan isab, bang peen niya' kasannangan ma dunya itu, ma sasuku makasulut iya!” ");
INSERT INTO slm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pakallo' peen manga malaikat ian pabing tudju ni sulga', magtuwi magbissala manga tunggu' bili-bili ian. Uk sigam, “Sung na kitabi ni Betlehem hi'. 'Nda' tabi bang ayi piniya' ian, iya pamatau kitabi uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Manjari magdayi'-dayi' sigam pahi' bo' tatawwa' uk sigam si Mariyam maka si Yusup. Tanda' isab uk sigam onde' pabahak ma diyōm tuung pamanganan hayōp. ");
INSERT INTO slm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Makanda' peen sigam ma onde', magtuwi sigam ma'-ma' pasal bayi pamissala malaikat ma sigam pasal onde' hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bo' kamemon makake ma habal manga tunggu' ian inu-inu tōōd. ");
INSERT INTO slm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Suga' si Mariyam iya bayi nawu' kamemon itu ma diyōm atay na bo' kiyannal uk na. ");
INSERT INTO slm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jari pabing na manga tunggu' ian ni manga hayōp sigam, maka uk sigam nanglitan maka mudji Tuhan ma sabab kamemon bayi take maka bayi tanda' uk sigam. Sabab ayi-ayi bayi pamissala uk malaikat ma sigam bannal sadja. ");
INSERT INTO slm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagwalu' 'llaw na onde' ian ma luwasan pig-islam iya, bo' iyōnan iya si Isa, ōn bayi pangōn ma iya uk malaikat ma 'nsa' le' iya bayi pingiraman. ");
INSERT INTO slm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Taabut peen 'mpatpu' bahangi min panganak si Mariyam, bine' uk sigam addat pagsutsi sali' bayi panohoan bangsa Yahudi ma sara' si Musa. Biyo onde' uk sigam tudju ni Awrusalam bo' supaya iya iyungsuran ni Tuhan ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bine' uk sigam iya tasulat ma diyōm sara' bayi pamuwan uk Tuhan, iya uk na, “Kamemon manga anak lalla siyaka subay pisuku' ma Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iyungsuran isab uk sigam pagkulban sali' bayi panohoan ma diyōm sara' Tuhan, iya uk na hi', “duwa assang atawa duwa malapati iya subay pagkulban bi.” ");
INSERT INTO slm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, ma waktu ian niya' dakayo' maas lalla maglahat ma Awrusalam. Ōn na si Simiyun, hap asal addat na, magtataat ni Tuhan. Iyagaran uk na waktu pangalappas ma bangsa Israil, maka kapagbayaan iya uk Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bayi iya pitau uk Nyawa Sutsi in iya 'nsa' matay sataggōl 'nsa' le' tanda' na si Almasi, iya bayi panganjanji' asal uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Manjari si Simiyun itu pipay'an uk Nyawa Tuhan pasōd ni diyōm langgal pagkulbanan. Jari may'an iya ma waktu katakka maas si Isa pay'an mo onde' hi' ni langgal supaya tahinang ma iya sali' bayi panohoan sara' agama pasal onde'-onde'. ");
INSERT INTO slm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tanda' peen onde' uk si Simiyun, magtuwi pipi uk na bo' iyampa magsukul ni Tuhan, uk na, ");
INSERT INTO slm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Tuhan, sosohoan nu aku. 'Nsa' du niya' kasusahan ku bang aku papowe' nu na ni diyōm ahirat, pagka tatuman na bayi janji' nu. ");
INSERT INTO slm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tanda' na uk mata ku aa nu manglalappas, ");
INSERT INTO slm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iya pisakap uk nu ma panganda' bangsa manusiya' kamemon. ");
INSERT INTO slm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sabab onde' itu sali' hantang sawa pamandaan kabayaan nu ma manga bangsa kasehean iya 'nsa' bangsa Israil, bo' taga kabantugan du manga aa nu bangsa Israil ma sabab na.” ");
INSERT INTO slm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na, inu-inu ina'-mma' si Isa ma sabab bayi bissala uk si Simiyun ma pasal na. ");
INSERT INTO slm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sakali bissalahan sigam kahapan uk si Simiyun. Uk na isab ni si Mariyam, ni ina' onde' hi', “Anak nu itu, iya pangangganta' Tuhan ma iya, in iya poon-sabab na hangkan heka aa bangsa Israil makatawwa' kalappasan maka heka isab kamulahan. Tahinang du iya paltandaan min Tuhan suga' siyulak du iya uk kahekahan aa. ");
INSERT INTO slm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bo' minnihi' kisakupan bang ayi tōōd pikil uk sigam. Maka kau iyu, Mariyam,” uk si Simiyun, “makananam du kau kasusahan sali' hantang kalis parugsu' ni diyōm atay nu.” ");
INSERT INTO slm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Niya' isab may'an dakayo' nabi danda iyōnan si Anna, anak si Panual, min pangkatan si Asel. Toa na iya tōōd, walumpu' maka 'mpat tahun umul na. Pitun tahun sadja bayi pagpun na maka halla na bo' sataggōl minnihi' balu iya. Tōtōg na peen iya ni langgal pagkulbanan. Jari may'an iya 'llaw-sangōm mudji Tuhan maka magpuwasa sampay nambahayang. ");
INSERT INTO slm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Manjari pasabu si Anna itu ma waktu ian hi' bo' magsukul tōōd iya ni Tuhan maka ma'-ma' isab iya ma pasal onde' ian ni aa kamemon, sasuku ngagaran waktu pangalappas manga aa Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Manjari itu, ubus peen uk si Yusup maka si Mariyam maghinang kamemon bayi kawajiban ma sigam ma diyōm sara' Tuhan, pabing na sigam ni jadjahan Jalil, ni Nasaret iya paglahatan sigam. ");
INSERT INTO slm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pasuwig onde' sampay pakōsōg. Lōm pangatau na maka biyuwanan iya barakat uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Magtukad asal manga maas si Isa ni Awrusalam kahaba'-kahaba' tahun bo' maghinang sigam hinang Pangintōman. ");
INSERT INTO slm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jari itu, taabut peen sangpu' ka duwan tahun umul si Isa, magbe' sigam pahi' ni paghinangan sali' asal kabiyaksahan sigam. ");
INSERT INTO slm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tammat peen paghinangan hi', mowe' na sigam ni lahat suga' si Isa iya tamban ma Awrusalam bo' 'nsa' kitauhan uk maas na. ");
INSERT INTO slm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bang ma pangannal sigam magbe' du iya maka manga sehe' sigam. Jari dangallaw iya palangngan sigam bo' iyampa sigam meha iya ma diyōm kabagayan maka kahekahan sigam, suga' 'nsa' iya tatawwa' may'an. ");
INSERT INTO slm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pagka iya 'nsa' tatawwa' uk sigam, pabing sigam tudju ni Awrusalam meha iya ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Puwas peen tallum bahangi, iyamboho' iya tatawwa' uk sigam ma diyōm langgal pagkulbanan magtingko' maka manga guru. Ian iya pake ma sigam maka tiyaw na peen ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sasuku makake ma iya inu-inu tōōd sabab lōm tau na, maka tawwa' panambung na. ");
INSERT INTO slm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pag'nda' maas na ma iya magtuwi sigam inu-inu. Uk ina' na ma iya, “Oto', angay salaiyu hinang nu ma kami? Susa tōōd aku maka 'mma' nu meha kau.” ");
INSERT INTO slm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Uk si Isa ni sigam, “Angay aku subay peha bi? 'Nsa' baha' katauhan bi in aku subay maitu ma luma' 'Mma' ku?” ");
INSERT INTO slm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Suga' 'nsa' tahati uk sigam bang ayi pamissalahan na. ");
INSERT INTO slm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jari magbe' si Isa maka maas na pabing tudju ni Nasaret bo' bine' uk na panohoan sigam, bo' si Mariyam iya bayi nawu' ian hi' kamemon ma diyōm atay na. ");
INSERT INTO slm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pasong na peen mehe si Isa maka pasong tau na. Pasong isab iya makasulut atay Tuhan sampay manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Na, pagka sangpu' maka liman tahun iya pagsultan si Tibirus, Sultan Mahatinggi ma bangsa Roma, manjari takka palman Tuhan ni si Yahiya anak si Jakariya, waktu kamahi' na ma lahat 'nsa' agōn kalluman ayi-ayi. Si Puntus Pilatu bayi maggubnul ma lahat Yahudiya ma waktu ian hi', si Herod bayi ngantan parinta ma lahat Jalil, danakan na si Pilip bayi ngantan parinta ma lahat Ituriya maka ma lahat Tarakunit, maka si Lisani bayi ngantan parinta ma lahat Abilen. Si Annas maka si Kayapas bayi imam nakura'. ");
INSERT INTO slm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kapalmanan peen si Yahiya, mangngan iya ngalatag kalahat-lahatan ma jadjahan sapa' Jordan magnasihat palman Tuhan. Uk na, “Pataikut kaam min dusa bi bo' kaam piyandi tawubat bo' iyampun du dusa bi uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na, iya hinang si Yahiya itu bayi pigbissala asal ma diyōm kitab si Nabi Isaya ma awwal le'. Uk na, “Niya' aa ngalingan ma lahat 'nsa' agōn kapaglahatan manusiya'. Salaitu pangalingan na, uk na, ‘Song na takka Panghu'. Lanuin bi daddōk palabayan na, pabōntōlun bi palangnganan na. ");
INSERT INTO slm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Manga labbak kamemon subay pipantay, maka kabūd-būran kamemon subay pipantay. Manga daddōk magbeklo'-beklo' subay pibōntōl, maka palabayan magkattud-labbak subay pilanu'. ");
INSERT INTO slm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Manjari tanda' du uk manusiya' kamemon bang salaingga uk Tuhan ngalappas ma sigam.’ ” Salaihi' bayi pagbissala uk si Isaya hi'. ");
INSERT INTO slm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, landu' heka aa pay'an ni tōngōd si Yahiya mikipandi ma iya, hangkan uk na ma sigam, “Kaam iyu, addat bi sali' sapantun addat so pangangakkal. Sayi baha' bayi mandaan kaam in kaam subay papuwas min mulka' Tuhan iya song patakka? ");
INSERT INTO slm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bang kaam sabannal-bannal pataikut na min dusa bi, hinangun bi hinang hap, palsaksian in addat bi pinda na. Daa kaam magpikil in kaam 'nsa' miyulkaan ma sawukat kaam panubu' si Ibrahim. Baan ta kaam, minsan manga batu itu tahinang du panubu' si Ibrahim uk Tuhan! ");
INSERT INTO slm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaam iyu sali' hantang manga kayu song na tibbōng maka kapa, tōbtōb min gamut na. Sabab kayu kamemon sasuku 'nsa' hap buwa' na, tibbōng du, liyarukan ni diyōm api tiyutung.” ");
INSERT INTO slm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Manjari tīyaw si Yahiya uk baanan aa ian. Uk sigam, “Ayi subay hinang kami?” ");
INSERT INTO slm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Uk si Yahiya, “Sasuku kaam magduwa badju' siyoho' muwan dakayo' ma aa 'nsa' taga badju'. Sasuku isab kaam taga kiyakan siyoho' magbahagi' maka aa tiksa'.” ");
INSERT INTO slm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niya' isab pahi' ni si Yahiya Magpapandi aa magkallo' sukay parinta. Uk manga aa itu, “Tuwan Guru, kami itu? Ayi subay hinang kami?” ");
INSERT INTO slm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Uk si Yahiya, “Bang kaam ngallo' sukay daa palabihun bi min sukay bayi panohoan kaam uk parinta.” ");
INSERT INTO slm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iya du manga sundalu bayi tiyaw ma si Yahiya. Uk sigam, “Bang sali' kami itu sundalu ayi iya subay hinang kami?” Iya sambung si Yahiya, “Daa na langpasin bi aa, daa na isab sumbungun bi ni sara' bang 'nsa' bannal. Maka subay kaam kasulutan ma gadji bi.” ");
INSERT INTO slm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na, makake peen manga aa ian ma si Yahiya, magtuwi sigam sali' hōwat-hōwat. Sabab iya pagpikil sigam bang si Yahiya iya Almasi baha', iya song pipaitu uk Tuhan ngalappasan sigam. ");
INSERT INTO slm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hangkan halling si Yahiya ma manga aa ian, uk na, “Ma aku itu, bohe' sadja iya pamandi ku ma kaam. Suga' niya' aa song paitu landu' langkaw kawasa na min aku. Minsan ingkōt tawumpa' na 'nsa' aku tiyōp ngahubaran iya. Saddi bohan pamandi na ma kaam. Hati na in iya mahōp Nyawa Sutsi ni diyōm baran bi. Kasehean isab piyandi uk na maka api. ");
INSERT INTO slm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Silang du uk na aa hap maka aa laat, sali' sapantun aa nahapan payi. Iya payi na tiyawu' uk na ma diyōm tawuan na, bo' hapa na iya tiyutung uk na ma api 'nsa' kapaddahan.” ");
INSERT INTO slm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Heka isab bissala si Yahiya saddi minnihi' bayi pagnasihat na lapal hap ma manga aa. Bayi siyoho' uk na isab sigam subay pindahan kawul-piil sigam. ");
INSERT INTO slm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Suga' si Yahiya bayi mahalling-hallingan si Gubnul Herod ma sabab dusa na magdakayo' maka si Herodiyas iya bayi handa siyay na, maka ma sabab hinang na laat kasehean. ");
INSERT INTO slm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Manjari karuhunan si Herod maghinang laat sabab pijil uk na si Yahiya. ");
INSERT INTO slm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma waktu kapamandi le' si Yahiya ma aa kamemon piyandi isab uk na si Isa. Ubus peen si Isa piyandi, ma sabu peen iya ngamu' ni Tuhan, magtuwi paukab diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bo' pareyo' Nyawa Sutsi magpabaran sali' dagbōs assang, patapu' ma iya. Niya' isab suwara halling min diyōm sulga'. Uk na, “Kau iya Anak ku kalasahan ku, landu' kau makasulut atay ku.” ");
INSERT INTO slm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na, ma waktu kapanagna' na si Isa magnasihat pandu' na ma manusiya', niya' na manga tallumpu' tahun umul na. Anak si Yusup iya bang ma pangannal manga aa, si Yusup iya bayi anak si Hili. ");
INSERT INTO slm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Hili iya bayi anak si Mattat, si Mattat bayi anak si Libi, si Libi bayi anak si Malki, si Malki bayi anak si Janni, si Janni bayi anak si Yusup. ");
INSERT INTO slm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Yusup itu bayi anak si Mattati, si Mattati bayi anak si Amos, si Amos bayi anak si Nahum, si Nahum bayi anak si Esli, si Esli bayi anak si Naggay. ");
INSERT INTO slm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Naggay iya bayi anak si Maat, si Maat bayi anak si Mattati dakayo', si Mattati itu bayi anak si Simain, si Simain bayi anak si Yosek, si Yosek bayi anak si Joda. ");
INSERT INTO slm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda iya bayi anak si Joanan, si Joanan bayi anak si Resa, si Resa bayi anak si Sirubbabil, si Sirubbabil bayi anak si Salati, si Salati bayi anak si Niri. ");
INSERT INTO slm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Niri iya bayi anak si Malki, si Malki bayi anak si Addi, si Addi bayi anak si Kosam, si Kosam bayi anak si Elmadam, si Elmadam bayi anak si El. ");
INSERT INTO slm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si El iya bayi anak si Yussa', si Yussa' bayi anak si Eleesel, si Eleesel bayi anak si Jurim, si Jurim bayi anak si Mattat, si Mattat bayi anak si Libi, ");
INSERT INTO slm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Libi bayi anak si Simiyun, si Simiyun bayi anak si Yuda, si Yuda bayi anak si Yusup, si Yusup bayi anak si Jonam, si Jonam bayi anak si Eliyakim. ");
INSERT INTO slm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliyakim iya bayi anak si Meleya, si Meleya bayi anak si Menna, si Menna bayi anak si Mattata, si Mattata bayi anak si Natan, si Natan bayi anak si Daud. ");
INSERT INTO slm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Daud hi' bayi anak si Jesse, si Jesse bayi anak si Obed, si Obed bayi anak si Bowas, si Bowas bayi anak si Sala, si Sala bayi anak si Nasson. ");
INSERT INTO slm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Nasson iya bayi anak si Amminadab, si Amminadab bayi anak si Admin, si Admin bayi anak si Arni, si Arni bayi anak si Hesdon, si Hesdon bayi anak si Peres, si Peres bayi anak si Yuda. ");
INSERT INTO slm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Yuda iya bayi anak si Ya'kub, si Ya'kub bayi anak si Isahak, si Isahak iya bayi anak si Ibrahim, si Ibrahim bayi anak si Tera, si Tera bayi anak si Nahol. ");
INSERT INTO slm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahol iya bayi anak si Sirug, si Sirug bayi anak si Reyo, si Reyo bayi anak si Peleg, si Peleg bayi anak si Ebel, si Ebel bayi anak si Sela. ");
INSERT INTO slm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sela iya bayi anak si Kainan, si Kainan bayi anak si Arpaksad, si Arpaksad bayi anak si Sem anak si No, si No bayi anak si Lamek, ");
INSERT INTO slm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamek bayi anak si Metosela, si Metosela bayi anak si Idris, si Idris bayi anak si Jared, si Jared bayi anak si Mahalalel, si Mahalalel bayi anak si Kenan. ");
INSERT INTO slm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kenan iya bayi anak si Enos, si Enos bayi anak si Set, si Set bayi anak si 'Mbo' Adam, maka si 'Mbo' Adam bayi anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Manjari itu pabing si Isa min sapa' Jordan, min bayi pamandihan iya hi'. Kahōpan iya uk Nyawa Sutsi bo' biyo iya uk Nyawa Tuhan ni lahat de 'nsa' agōn kalluman ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Mpatpu' 'llaw, 'mpatpu' bahangi iya kamahi' na siyasat na peen iya uk nakura' sayitan, kalu tabo magdusa. Sataggōl iya ma hi' 'nsa' iya bayi mangan ayi-ayi 'llaw-sangōm, jari pagpuwas ian hi' mehe na gōtas na. ");
INSERT INTO slm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Halling nakura' sayitan ma iya, uk na “Bang kau iyu sabannal-bannal Anak Tuhan sohoun manga batu itu papinda ni tinapay.” ");
INSERT INTO slm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Suga' nambung si Isa, uk na, “Tasulat asal ma diyōm kitab, uk na, ‘'nsa' kiyakan baran sadja iya makakaallum ma manusiya'.’ ” ");
INSERT INTO slm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Puwas hi' biyo si Isa ni lahat kalangkawan uk nakura' sayitan bo' iyampa pindaan na kalahatan kamemon ma diyōm dunya, ma diyōm dakaddab mata sadja. ");
INSERT INTO slm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Uk nakura' sayitan ni iya, “Buwanan ta kau kapatut bo' kau makapagbaya' ma manga kalahatan itu maka alta' na kamemon. Sabab bayi pamasuku' ma aku kamemon na itu iya hangkan aku taga kapatut muwan ma sayi-sayi kabayaan ku. ");
INSERT INTO slm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na, bang kau iyu mudji aku pamuwan ku itu kamemon ma kau.” ");
INSERT INTO slm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Uk sambung si Isa ma sayitan hi', “Tasulat asal ma diyōm kitab, uk na, ‘Panghu' bi Tuhan sadja iya subay pudji bi. Tunggal iya paghinangan bi!’ ” ");
INSERT INTO slm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Puwas hi' biyo si Isa uk nakura' sayitan ni daira Awrusalam bo' pitōngōd iya may'an ma puntuk langgal pagkulbanan. Uk sayitan hi' ni iya, “Bang kau iyu iya bannal Anak Tuhan pakuppa kau minniyu, ");
INSERT INTO slm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sabab niya' asal tasulat ma diyōm kitab, iya uk na, ‘Siyoho' uk Tuhan manga malaikat na nganjagahan kau’. ");
INSERT INTO slm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Niya' isab dakayo' sulat, iya uk na, ‘Tiyayak kau uk sigam bo' 'nsa' makahantak nayi' nu ni batu.’ ” ");
INSERT INTO slm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Suga' nambung si Isa, uk na, “Uk kitab, ‘Daa sulayan bi kawasa Tuhan iya Panghu' bi.’ ” ");
INSERT INTO slm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na, pagka ubus na sasat kaginis-ginisan bayi panasat nakura' sayitan ma si Isa, pakallo' iya min si Isa ngagaran waktu dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Manjari itu pabing si Isa ni lahat Jalil bo' ian na ma iya barakat min Nyawa Sutsi. Pasaplag na peen habal ma pasal na ni kalohahan lahat ian. ");
INSERT INTO slm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mandu' na peen iya ma diyōm kalanggal-langgalan sigam bo' siyanglitan iya uk aa kamemon. ");
INSERT INTO slm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jari itu pay'an si Isa ni Nasaret, ni bayi lahat kasuwigan na. Taabut peen 'llaw Sabtu', 'llaw mulliya ma agama Yahudi, pahi' iya ni langgal sali' asal kabiyaksahan na. Ma langgal peen, nangge iya magbassa min diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Siyongan ma iya kitab iya siyulat uk si Nabi Isaya. Iyukab uk na kitab ian bo' tapeha na kasulatan manga ayat itu hi'. Uk sulat hi', ");
INSERT INTO slm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tiya' aku kapagbayaan uk Nyawa Tuhan, sabab tapene' aku uk na masampay lapal hap ni manga aa miskin. Siyoho' aku uk na paitu ma'-ma' ni manga pilisu in sigam piluwas du, maka ma manga aa buta in sigam makanda' du pabing. Siyoho' aku uk na muwasan sasuku liyaugan, ");
INSERT INTO slm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nganasihat isab in waktu pangalappas Tuhan ma manga aa na taabut na.” ");
INSERT INTO slm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Puwas hi' tiyambōl uk si Isa kitab bayi pagbassahan na hi'. Siyongan uk na pabayik ni bilal bo' iyampa iya ningko'. Sakali piyatong iya uk aa kamemon ma diyōm langgal ian. ");
INSERT INTO slm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bo' nagna' iya missala ni sigam, uk na, “Ma 'llaw itu tatuman na manga ayat kitab bayi tabassa ku itu ma sabu kaam pake.” ");
INSERT INTO slm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kaamuhan magtuwi manga aa ian ma si Isa. Inu-inu sigam ma sabab kapanday bissala na. Magbissala sigam, uk na, “Bang kami 'nsa' lupa, iya na itu anak si Yusup!” ");
INSERT INTO slm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Halling si Isa ma sigam, “Tantu du kaam mahallingan aku sali' bayi halling kamaasan, iya uk na, ‘Pagka kau iyu tau nambal, nambal kau di nu.’ Tantu isab kaam noho' aku subay ngahinang ma itu, ma di lahat ku itu, manga hinang iya take bi bayi hinang ku ma lahat Kapirnaum hi'. ");
INSERT INTO slm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Baan ta kaam tōōd,” uk si Isa, “in nabi 'nsa' du pig-addatan ma lahat na porol. ");
INSERT INTO slm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kehun bi aku: ma waktu si Nabi Eliyas bayi 'nsa' niya' ulan ma diyōm tallun tahun maka tōnga', maka landu' gōtōm kalohahan lahat ian. Bannal heka balu danda bayi ma itu ma lahat Israil ma waktu gōtōm ian, ");
INSERT INTO slm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","suga' 'nsa' si Nabi Eliyas siyoho' uk Tuhan nabangan dakayo' min sigam. Siyoho' iya uk Tuhan pahi' nabangan dakayo' balu danda 'nsa' bangsa Israil ma hi' ma lahat Sarepta, ma jadjahan Sidun. ");
INSERT INTO slm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Damikkiyan na isab ma bayi waktu si Nabi Elisa,” uk si Isa. “Heka aa saki ipul bayi ma bangsa Israil suga' 'nsa' niya' sigam minsan dakayo' bayi kaulian ipul na. Duwal aa min bangsa Siriya iya bayi kaulian, ōn na si Nayman.” ");
INSERT INTO slm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Take peen bissala si Isa itu uk manga aa ma diyōm langgal ian, magtuwi paddi' tōōd atay sigam. ");
INSERT INTO slm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nangge sigam kamemon bo' iyampa ngahella' si Isa paluwas min kalumaan hi'. Biyo iya ni diyata' bud iya tōngōd daira sigam ian, bahasa iya hiyug uk sigam min diyata' pampang hi'. ");
INSERT INTO slm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lipara palabay iya min tangngaan sigam bo' pakallo' iya minnihi'. ");
INSERT INTO slm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Palud na si Isa min Nasaret ian tudju ni Kapirnaum, dakayo' daira ma lahat Jalil. Pagka 'llaw Sabtu' na, 'llaw mulliya, mandu' iya ma manga aa ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Inu-inu ma pamandu' na manga makake hi' sabab pamandu' na taga kawasa. ");
INSERT INTO slm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, niya' ma diyōm langgal ian dakayo' aa bayi siyōd uk sayitan. Ngōlang iya pakōsōg, ");
INSERT INTO slm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","uk na, “Allō! Isa min Nasaret! Ayi kamaksuran nu paitu? Paitu kau baha' makaat kami? Katauhan ku du bang sayi kau. Kau iya dakayo'-kayo' sutsi iya bayi paitu min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Suga' liyāng sayitan ian uk si Isa, uk na, “Patammun kau! Paluwas kau min baran aa iyu!” Magtuwi aa bayi siyōd ian pihantak uk sayitan ma tangnga' manga aa kasehean. Puwas hi' paluwas na sayitan, bo' 'nsa' du baran aa ian bayi inay-inay. ");
INSERT INTO slm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Landu' inu-inu manga aa ian kamemon. Magbissala sigam dangan maka dangan, uk sigam, “Bissala ayi baha' bissala na itu? Taga kawasa iya maka taga kapatut magpanohoan manga sayitan sabab bine' uk sigam panohoan na paluwas min baran aa.” ");
INSERT INTO slm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Manjari pasaplag na peen habal pasal si Isa ni kalohahan lahat ma jadjahan ian hi'. ");
INSERT INTO slm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Puwas hi' paluwas si Isa min langgal hi' bo' pay'an ni luma' si Simun. Na, matoa si Simun danda hinglaw bidda', bo' iyamu' si Isa uk sigam nabangan iya. ");
INSERT INTO slm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pay'an si Isa nangge ma tōngōd pabahakan danda hi' bo' siyoho' uk na pakallo' hinglaw na. Jari parōhōng bayi hinglaw na hi' bo' punduk iya magtuwi ngalabōt ma di si Isa. ");
INSERT INTO slm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pasaddōp peen 'llaw, sasuku niya' bagay na taga saki minsan saki kaginis-ginisan, bayi biyo uk sigam tudju ni si Isa. Piabut uk na tangan na ma sigam dangan maka dangan bo' kaulian sigam uk na. ");
INSERT INTO slm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Heka isab manga aa bayi kapaluwasan sayitan, bo' ngōlang pakōsōg manga sayitan ian, uk na, “Kau iya Anak Tuhan!” Suga' liyāng sigam uk si Isa, daa sigam siyoho' halling salaihi' sabab kitauhan uk sigam in iya si Almasi. ");
INSERT INTO slm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dayi' 'llaw peen pakallo' si Isa minnihi' tudju ni jadjahan 'nsa' niya' aa na. Peha iya uk manga aa bo' tatawwa' peen iya, arak iya tikkoan uk sigam bo' iya 'nsa' pakallo' minnihi'. ");
INSERT INTO slm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Suga' halling si Isa ma sigam, uk na “Subay aku pahi' isab ni manga kalumaan saddi magnasihat lapal hap ma pasal pagparinta Tuhan, sabab iya na itu poon na iya hangkan aku pipaitu uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jari magnasihat si Isa ma diyōm kalanggal-langgalan ma hi' ma lahat Yahudiya. ");
INSERT INTO slm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Manjari niya' 'llaw dakayo' nangge si Isa ma bihing danaw Gennesaret. Magtipun na peen manga aa parigpit ni iya supaya sigam pake ma palman Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na, niya' tanda' uk si Isa duwa bayanan bayi pisallad ma bihing danaw hi', bayi imbanan uk manga aa magdaraying sabab hi' sigam ngosean pōkōt sigam. ");
INSERT INTO slm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pariyata' si Isa ni dakayo' bayanan ian, iya bayanan si Simun, bo' noho' iya ma si Simun pitulak-tulak datti' min bihing parian. Jari ningko' si Isa mandu' ma manga aa magtipunan may'an. ");
INSERT INTO slm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na, ubus peen uk si Isa mandu', halling iya ni si Simun. “Palanjal le' kita ni kalōman,” uk na, “bo' hugun bi pōkōt bi pahi' bo' kaam makakallo'.” ");
INSERT INTO slm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nambung si Simun, uk na, “Tuwan Guru, liyuugan kami mōkōt dibuhi' sampay ni kallawan bo' 'nsa' kami bayi makakallo'. Suga' pagka kau iya noho', hug ku sadja.” ");
INSERT INTO slm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tahug peen pōkōt sigam ni diyōm tahik, heka tōōd daying takallo' sigam. Agōn na gese' manga pōkōt hi', ");
INSERT INTO slm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","hangkan sinyalan uk di si Petros manga sehe' sigam ma bayanan dakayo', siyoho' nabang ngahella'. Makapay'an peen manga sehe', magtuwi diyuwa' daying ian ni diyata' bayanan. 'Llōp karuwa bayanan ian uk daying, arak na sigam buhaw. ");
INSERT INTO slm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pag'nda' si Simun Petros ma baanan daying ian, magtuwi iya pasujud ma tōngōd nayi' si Isa. Uk na, “O Tuwan, palawak kau min aku sabab aku itu dusahan.” ");
INSERT INTO slm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hangkan salaihi' halling na, sabab inu-inu iya maka manga sehe' na ma pasal heka daying bayi takallo' sigam. ");
INSERT INTO slm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iya du inu-inu manga sehe' si Simun magdaraying hi', iya si Ya'kub maka si Yahiya duwangan anak si Sibidi. Manjari halling si Isa ma si Simun, uk na, “Daa kau tiyāw. Puwas min 'llaw itu iya hinang nu subay magkallo' manusiya' me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Manjari hella' uk sigam bayanan sigam ma diyata' parian bo' imbanan ayi-ayi sigam kamemon bo' iyampa me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma 'llaw dakayo', waktu peen si Isa ma dakayo' daira, niya' may'an dakayo' aa saki ipul. Lapat baran na uk saki na. Makanda' peen aa itu ma si Isa, magtuwi iya pasujud ma dahuhan na nganjunjung. “Tuwan,” uk na, “bang kau baya' tapakowe' nu du aku.” ");
INSERT INTO slm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sakali piabut uk si Isa tangan na ma aa ian. Uk si Isa, “Baya' sadja aku. Kowe' na kau.” Saruun-duun du pakallo' na ipul min baran aa ian. ");
INSERT INTO slm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iyamay-amayan iya uk si Isa, uk na, “Daa kau ma' ni sayi-sayi pasal itu hi'. Suga' pahi' kau magtuwi ni imam bo' palilingun baran nu ni iya. Puwas hi' ungsurin pagkulban ni Tuhan sali' bayi pamandu' uk si Musa, tanda' saksi' ni kahekahan aa in kau iyu kaulian na min saki nu.” ");
INSERT INTO slm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Suga' pasaplag gam peen habal pasal si Isa hangkan heka manga aa patipun ni iya, pake ma pandu' na sampay ngamu' bang pikowe' uk na manga saki sigam. ");
INSERT INTO slm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Suga' mawumu si Isa pakallo' min kahekahan aa ian ni lahat kulang aa na bo' mangarap ni Tuhan ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dakayo' 'llaw, sabu peen si Isa mandu', niya' manga Parisi maka manga guru ma sara' agama Yahudi magtingko' ma tōngōd na. Manga aa itu bayi pay'an min daira Awrusalam maka min kamemon lungan ma lahat Jalil maka ma lahat Yahudiya. Ian ma si Isa kawasa bayi min Tuhan hangkan iya makapakowe' manga aa sakihan. ");
INSERT INTO slm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Manjari niya' takka pay'an manga aa nanggung aa matay baran na. Arak sigam pariyōm luma' tudju ni tōngōd si Isa. ");
INSERT INTO slm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Suga' 'nsa' sigam makalabay sabab baanan manga aa may'an hangkan sigam parāg tudju ni diyata' luma'. Liyangkat uk sigam atōp ni tōngōd si Isa bo' iyampa pitonton aa matay baran na maka pabahakan na hi', pibōtang ma dahuhan si Isa ma diyōm baanan aa hi'. ");
INSERT INTO slm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Makatau peen si Isa in aa mamo ian mangandōl du ma iya, halling iya ni aa mamatay baran na hi', uk na, “Bagay, iyampun na dusa nu.” ");
INSERT INTO slm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na, take peen halling si Isa itu uk manga guru ma sara' agama maka uk manga Parisi, magtuwi sigam magtiyaw-tiyaw dangan maka dangan. “Sayi baha' aa itu?” uk tiyaw sigam hi'. “Mahalling iya pangkal ni Tuhan magbissala salaihi' sabab 'nsa' niya' makapag-ampun dusa, duwal Tuhan dakayo'-kayo'.” ");
INSERT INTO slm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Suga' katauhan uk si Isa bang ayi iya pikil uk sigam, bo' uk na ma sigam, “Angay kaam magtiyaw-tiyaw salaiyu ma diyōm pikilan bi? ");
INSERT INTO slm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kumpasun bi bang ingga luhay: upamahun uk ku ma aa, ‘Iyampun na dusa nu’, atawa bang uk ku, ‘papunduk kau bo' kau mangngan na’? ");
INSERT INTO slm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na, buwanan ta kaam tanda' palsaksian bo' katauhan bi in aku, Anak Manusiya', taga kapatut ngampun dusa ma diyōm dunya itu.” Jari halling si Isa ni aa matay baran na hi', uk na, “Iya na itu halling ku ma kau: papunduk na kau. Bohun pabahakan nu iyu bo' kau mowe'.” ");
INSERT INTO slm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Saruun-duun du iya nangge ma alōpan sigam kamemon. Biyohat uk na bayi pabahakan na bo' iyampa mowe' ni luma' na maka uk na nanglitan Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Inu-inu lullun manga aa ian kamemon maka tiyāw tōōd sigam. Siyanglitan Tuhan uk sigam, uk na, “Hinang makainu-inu iya tanda' kitabi 'llaw itu!” ");
INSERT INTO slm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Puwas hi' paluwas si Isa minnian bo' niya' tanda' na aa magkallo' sukay parinta, ōn na si Libi. Hi' iya ningko' ma diyōm upis na pangalloan na sukay parinta. Uk si Isa ma iya, “Paitu na kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nangge magtuwi si Libi bo' libbahan uk na kamemon na bo' iya me' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Manjari niya' jamu pibōtang uk si Libi ma diyōm luma' na pamaehe na ma si Isa. Heka isab aa magkallo' sukay parinta maka manga aa kasehean magbe' mangan ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na, niya' may'an manga aa Parisi maka manga guru ma sara' agama iya me' ma sigam. Sakali naway sigam ma di si Isa. Uk sigam ma manga mulid na, “Kaam iyu, angay kaam palamud magsawu maka manga aa magkallo' sukay parinta maka manga aa dusahan kasehean?” ");
INSERT INTO slm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nambung si Isa ma manga aa niyaw ian, uk na, “Bang aa kowe' 'nsa' magdoktor. Iya magdoktor bang aa taga saki. ");
INSERT INTO slm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'Nsa' pasal aa adil iya maksud ku paitu ni dunya, suga' iya maksud ku paitu pasal aa taga dusa bo' supaya sigam ngalabba min dusa sigam.” ");
INSERT INTO slm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Manjari niya' manga aa halling ni si Isa, uk sigam, “Manga mulid si Yahiya daran magpuwasa maka nambahayang. Iya du isab manga mulid Parisi, suga' mulid nu 'nsa'. Mangan sadja sigam maka nginum.” ");
INSERT INTO slm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nambung si Isa ma manga aa hi', sambung pamaralilan. Uk na, “Magpuwasa baha' manga luruk ma samantala' may'an le' pangantin lalla ma tōngōd sigam? Tantu 'nsa'. ");
INSERT INTO slm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Suga' ma 'llaw siyong, bang taabut waktu kapamakalloan pangantin lalla min sigam, iya na hi' waktu pagpuwasa sigam.” ");
INSERT INTO slm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Manjari maralil le' si Isa pasal pamandu' tagna' maka pamandu' na, uk na, “'Nsa' niya' nganggeret pispis min badju' bahu panupak na ni badju' daan. Bang ganta' salaihi', hinang na geret uk na bayi badju' bahu maka pispis bahu hi' 'nsa' tōp panupak sammek daan hi'.” ");
INSERT INTO slm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Piralil isab uk si Isa pamandu' na ni inuman bahu bang liyōōn ni diyōm pangalōōnan bayi hinang min kuwit kambing. Uk na, “'Nsa' niya' ngalōōn inuman bahu, masi-masi mukal, ni diyōm pangalōōnan daan. Bang ganta' salaihi' hinang na, tantu bustak pangalōōnan uk inuman bahu hi'. Jari tiyumpahan inuman bo' magkaat bayi pangalōōnan hi'. ");
INSERT INTO slm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Suga' in inuman bahu subay liyōōn ni pangalōōnan bahu.” ");
INSERT INTO slm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maralil le' si Isa, uk na, “Bang aa biyaksa nginum inuman taggōl bayi ma tawuan na, 'nsa' iya baya' nginum inuman bahu. Hap kono' lassa inuman bang taggōl ma tawuan na.” ");
INSERT INTO slm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ma dakayo' 'llaw Sabtu', iya 'llaw paghali ni Tuhan bang ma agama Yahudi, ian di si Isa mangngan labay min tangnga' huma pananōman payi tirigu. Niya' buwa' sali' payi kittu' uk manga mulid hi', pisi-pisi uk sigam bo' iyampa kiyakan uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na, niya' manga Parisi tiyaw ma si Isa. Uk sigam, “Angay kaam ngalanggal sara' agama tabi?” ");
INSERT INTO slm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nambung si Isa, uk na, “Angay, 'nsa' tabassa bi bang ayi bayi tahinang uk si Daud ma masa awwal hi', waktu bayi kagōtas sigam maka manga aa na? ");
INSERT INTO slm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bayi pasōd si Daud ni diyōm langgal pangaharapan Tuhan bo' iyampa killo' uk na manga tinapay iya pangungsud ni Tuhan. Jari kiyakan uk na tinapay ian minsan 'nsa' wajib kiyakan uk aa saddi min manga kaimaman. Bayi pamuwan na isab ni manga sehe' na pagkakan sigam. Suga' 'nsa' niya' dusa na maghinang salaihi'.” ");
INSERT INTO slm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Uk si Isa isab, “Aku itu, Anak Manusiya', taga kapatut magbaya' bang ayi manjari hinang ma 'llaw paghali ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma 'llaw Sabtu' dakayo' isab pasōd si Isa ni diyōm langgal mandu'. Na, niya' ma diyōm langgal ian aa komay tangan na ni katau. ");
INSERT INTO slm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Niya' isab may'an manga guru ma sara' agama maka manga Parisi baya' meha pagsababan panuntut sigam ma si Isa. Hangkan na iya jiyagahan uk sigam bang kalu makowe' saki aa ma 'llaw paghali. ");
INSERT INTO slm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Suga' kitauhan uk si Isa bang ayi iya pikil uk sigam hi', bo' halling iya ni aa komay tangan na ian. “Paitu kau,” uk na. “Nangge kau ma tangngaan itu.” Sakali pahi' aa ian nangge ma tangngaan. ");
INSERT INTO slm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Puwas hi' halling si Isa ni manga aa hi', uk na, “Niya' tiyaw ku ni kaam. Bang ma sara', ayi iya patut hinang ma 'llaw paghali? Hinang makahap atawa hinang makalaat? Makallum aa, atawa mapatay?” ");
INSERT INTO slm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Piyatong uk si Isa manga aa ian kamemon bo' iyampa halling ni aa komay tangan na hi'. “Pahannatun tangan nu iyu,” uk na. Na, pihannat uk na, manjari kaulian na. ");
INSERT INTO slm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Suga' paddi' tōōd atay manga Parisi maka manga guru ian, iya hangkan sigam mag-isun-isun bang ayi subay hinang sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na, ma waktu ian hi' patukad si Isa ni bud ngarap ni Tuhan. May'an iya ngamu'-ngamu' ni Tuhan sangōm sampay ni kallawan. ");
INSERT INTO slm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkallat 'llaw na linganan uk na manga mulid na pay'an ni iya. Pene' uk na min sigam sangpu' ka duwa aa bo' iyōnan sigam uk na aa na kawakilan. ");
INSERT INTO slm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iya na itu ōn manga aa bayi kawakilan ian uk si Isa: si Simun iya ōnan na isab si Petros, maka si Andariyas danakan si Simun, bo' si Ya'kub maka si Yahiya, si Pilip maka si Bartolome. ");
INSERT INTO slm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Pasunu' si Matiyu maka si Tomas, bo' si Ya'kub anak si Alpa, maka si Simun iya iyōnan uk sigam “pangangatu”, ");
INSERT INTO slm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","bo' si Judas anak si Ya'kub, maka si Judas Iskariyut iya nukbalan si Isa ni manga banta na ma waktu damuwi minnihi'. ");
INSERT INTO slm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Manjari puwas ian palud si Isa maka manga mulid na bayi kawakilan na, bo' nangge iya ma kapantayan. Heka manga mulid na bayi may'an maka landu' heka isab aa kasehean, aa min lahat Yahudiya, min daira Awrusalam, maka aa isab min Tira maka Sidun iya ma bihing tahik. ");
INSERT INTO slm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bayi sigam pay'an pake ma pandu' si Isa bo' kaulian isab manga saki sigam. Sasuku isab sigam siyasat uk sayitan bayi kaulian uk si Isa. ");
INSERT INTO slm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bo' baanan aa ian kamemon bayi nuyu' na peen maabut tangan sigam ni iya sabab niya' barakat paluwas min baran na, iya hangkan sigam kaulian kamemon. ");
INSERT INTO slm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Manjari nganda' tōōd si Isa ma manga mulid na bo' uk na, “Mehe du kahapan sasuku kaam makatau in kagunahan bi tōōd iya tabang min Tuhan, sabab tantu du niya' palsukuan bi ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mehe du kahapan sasuku kaam kasigpitan ma buttihi', sabab maglassohan du kaam ma sosongun. Mehe du kahapan sasuku kaam magtangis ma buttihi', sabab magtatto du kaam ma sosongun. ");
INSERT INTO slm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mehe du kahapan ma kaam bila kaam kibansihan uk aa, bang kaam 'nsa' tayima' uk sigam, bang kaam manga hiyalipulu maka pihalling-hallingan laat ma sabab pame' bi ma aku, Anak Manusiya' itu. ");
INSERT INTO slm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Salaihi' isab bayi pangahinang kamaasan sigam ma manga kanabi-nabihan. Hangkan kaam subay kiyōgan tōōd bang kaam takkahan salaihi' sabab tantu mehe tungbas ma kaam ma diyōm sulga'. ");
INSERT INTO slm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Suga' makaase'-ase' kaam manga dayahan ma buttihi', sabab kalabayan bi na kahapan bi ma dunya itu sadja. ");
INSERT INTO slm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Makaase'-ase' isab kaam maglassohan ma buttihi', sabab niya' waktu ma sosongun giyōtas du kaam. Makaase'-ase' isab kaam kiyōgan iyu, sabab niya' waktu ma sosongun magkasusahan du kaam maka magkarukkaan. ");
INSERT INTO slm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Makaase'-ase' kaam bang kaam siyanglitan uk aa kamemon, sabab iya du manga aa ma waktu palabay, iya bayi maglaku-laku in sigam nabi. Bayi sigam siyanglitan isab uk ka'mbo'-mboan bi.” ");
INSERT INTO slm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mandu' le' si Isa, uk na, “Iya na itu halling ku ma kaam sasuku kaam pake ma aku: Kalasahin bi banta bi. Hinangun bi hap ma manga aa bansihan kaam. ");
INSERT INTO slm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Amu'-amuin bi kahapan min Tuhan sasuku nuknaan kaam. Sambahayangun bi sasuku ngalaat kaam. ");
INSERT INTO slm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bang niya' nampak kau ma bayihu' nu dambiya', patampalun isab dambiya' panampakan na. Bila niya' ngagaw jaket nu, pangahilasun sampay kamisita nu. ");
INSERT INTO slm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sayi-sayi ngamu' ma kau, buwanin. Maka bang niya' ganta' ngallo' ayi-ayi nu kamemon daa kau ngamu' pabing iya bayi killo'. ");
INSERT INTO slm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ayi-ayi kabayaan bi hinang ma kaam uk aa kasehean, iya na hi' subay hinangun bi ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bang iya sadja kalasahan bi in aa lasahan kaam, angay kaam subay pihalaan? Sabab minsan aa laat lasa du ma sasuku lasahan sigam. ");
INSERT INTO slm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Damikkiyan na, bang iya sadja tabangan bi in aa bayi makatabang ma kaam, angay kaam subay pihalaan? Sabab minsan aa laat, salaihi' du isab addat sigam. ");
INSERT INTO slm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bang iya sadja pautangan bi in aa tantu mayad, angay kaam subay ngahōwat pihalaan? Sabab minsan aa laat mautangan du ma sehe' sigam laat, bang peen niya' tantu biyayaran. ");
INSERT INTO slm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Suga' iya na itu pamandu' ku ma kaam,” uk si Isa. “Kalasahin bi banta bi maka tabangin bi sigam. Bang niya' ngutang ni kaam, pautangin bi minsan 'nsa' niya' bayad tahōwat bi. Jari mehe pahala' panungbas ma kaam bo' manjari kaam anak Tuhan Mahatinggi. Sabab hap addat Tuhan minsan ma manga aa laat, minsan ma aa 'nsa' magsukul ma iya. ");
INSERT INTO slm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Subay kaam maase', sali' 'Mma' bi Tuhan isab maase'.” ");
INSERT INTO slm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Daa sawayun bi pagkahi bi bo' kaam 'nsa' siyaway uk Tuhan. Daa pabōtangun bi hukuman ni aa kasehean bo' kaam 'nsa' pibōtangan hukuman uk Tuhan. Ampunun bi pagkahi bi bo' kaam iyampun isab uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muwan kaam ma kasehean bi bo' niya' pimuwan uk Tuhan ma kaam. Iya dalil na sali' tappōngan mehe bang tiyumpahan ni diyōm pangalōōnan bi. Minsan diyasōk, 'nsa' talōōn sabab heka na. Hati na ayi-ayi panappōng bi ma sehe' bi iya du isab panappōng Tuhan ma kaam.” ");
INSERT INTO slm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bissala uk si Isa dakayo' kissa pamaralil. Uk na ma manga aa, “Bang buta ngambit sehe' na buta, tantu sigam hug karuwangan ni diyōm lowang. ");
INSERT INTO slm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'Nsa' niya' mulid palangkaw min guru na. Suga' in mulid kamemon, bang tammat na pangadji' na, magsali' du maka guru na. ");
INSERT INTO slm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kaam magsaway sehe' bi iyu, angay tanda' bi bukbuk kayu ma diyōm mata sehe' bi bo' 'nsa' tananam bi batang kayu ma diyōm mata bi? ");
INSERT INTO slm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kaam iyu 'nsa' manjari! Baya' kaam ngalloan bukbuk min mata sehe' bi, bo' peen 'nsa' tananam bi batang kayu iya ma diyōm mata bi! Kaam iyu maglaku-laku in kaam iyu 'nsa' taga sā'! Kalloin bi le' dahu iya batang kayu ma kaam iyu, manjari sawa panganda' bi bo' makapakalloan du kaam bukbuk kayu min mata sehe' bi.” ");
INSERT INTO slm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Halling le' si Isa, uk na, “Bang sawupama kayu hap 'nsa' du muwan buwa' laat. Damikkiyan na isab bang kayu laat suwig na, 'nsa' muwan buwa' hap. ");
INSERT INTO slm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kitauhan asal kayu min buwa' na. 'Nsa' kita ngallo' buwa' igira min puhung atawa buwa' anggul min kayu itingan. ");
INSERT INTO slm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Salaihi' du isab ma manusiya', sali' dalil kayu. Bang aa hap addat na makapaluwas iya bissala hap sabab hap iya bayi tawu' na ma diyōm atay na. Suga' bang aa laat, hangkan du kalaatan iya piluwas uk na sabab laat iya tatawu' na ma diyōm atay na. Ayi-ayi ma diyōm atay manusiya' iya na hi' paluwas min bo' na.” ");
INSERT INTO slm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Angay uk bi in aku Panghu' bi, parahal 'nsa' hinang bi manga panohoan ku ma kaam? ");
INSERT INTO slm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sasuku paitu ni aku bo' pake ma pandu' ku sampay me', pahati ta kaam bang salaingga kahalan na. ");
INSERT INTO slm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aa ian sali' hantang aa maghinang luma'. Pilōm uk na lowang hag bo' osolan hag na ma diyata' katuwasan. Ubus peen hinang, ngandunuk kasapaan bo' simpoyakan luma' ian suga' 'nsa' tajōgjōg sabab hōgōt du osol na. ");
INSERT INTO slm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bang aa isab pake ma pandu' ku bo' 'nsa' me', iya dalil na aa maghinang luma' ma 'nsa' hōgōt osol na. Bang luma' ian hi' tawwa' dunuk habba magtuwi, larak tōōd.” ");
INSERT INTO slm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ubus peen uk si Isa bissala na kamemon itu ma manga aa, pasōd iya ni diyōm daira Kapirnaum. ");
INSERT INTO slm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na, niya' ma lahat ian dakayo' kapitan bangsa Roma maka niya' sosohoan na kilasahan asal uk na. Saki na sosohoan itu, song na magkamamatay. ");
INSERT INTO slm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Makake peen kapitan pasal si Isa, magtuwi iya noho' manga maas bangsa Yahudi pay'an ni si Isa ngamuan iya pay'an ni luma' na makowe' sosohoan na hi'. ");
INSERT INTO slm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Manjari pasampay manga maas ian ni si Isa bo' nganjunjung tōōd ma iya. Uk sigam, “Patut du subay tabangan nu kapitan ian, ");
INSERT INTO slm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sabab bagay tōōd iya ma bangsa tabi Yahudi, maka iya baran na bayi nganggastuhan pangahinang langgal tabi ma daira itu.” ");
INSERT INTO slm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jari me' na si Isa ma sigam. Sikōt peen iya ni luma', siyoho' uk kapitan manga bagay na pay'an mohan si Isa lapal. Uk lapal hi', “Tuwan, daa kau husa pasampay paitu sabab 'nsa' aku tiyōp bang kau pahi' ni luma' ku. ");
INSERT INTO slm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bangsahan tōōd kau hangkan pikil ku in aku 'nsa' tōp nampang kau magbaran. Suga' missala sadja kau minniyu bo' kaulian du sosohoan ku itu. ");
INSERT INTO slm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Minsan aku, biyaksa aku pigbayaan uk aa min diyataan ku maka niya' isab sundalu pagbayaan ku. Bang soho' ku dangan pahi', pahi' du iya. Bang soho' ku dangan paitu, paitu du iya ni aku. Damikkiyan na bang niya' pahinang ku ma sosohoan ku, magtuwi hinang uk na.” ");
INSERT INTO slm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagtake peen halling kapitan ian uk si Isa inu-inu iya. Jari palingi' iya tudju ni manga kahekahan aa iya paturul min buwian na. Uk na ma sigam, “Baan ta kaam, minsan ma diyōm bangsa tabi Israil 'nsa' aku bayi makatawwa' aa sali' kapitan itu kōsōg iman na.” ");
INSERT INTO slm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jari mowe' na manga aa bayi siyoho' uk kapitan bo' pagtakka sigam ni luma' tanda' uk sigam sosohoan hi' kaulian na. ");
INSERT INTO slm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","'Nsa' taggōl minnian, pahi' si Isa ni dakayo' kalumaan iyōnan Nain. Sehean iya uk manga mulid na maka baanan manga aa kasehean. ");
INSERT INTO slm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Makasikōt peen iya ni lawang pasōran tudju ni kalumaan ian, niya' may'an manga aa nanggung patay aa, biyo paluwas tudju ni pagkubulan. Lalla iya mamatay hi', anak tunggal dakayo' danda balu. Jari heka aa min kalumaan ian bayi me' ma balu hi' ngubul anak na. ");
INSERT INTO slm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na, makanda' peen si Panghu' Isa ma danda ian, magtuwi iya takkahan ase' ma iya. Uk na ma iya, “Daa na kau nangis.” ");
INSERT INTO slm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Puwas hi' pahi' si Isa ni tanggungan ngantanan iya, hangkan parōhōng manga aa mananggung hi'. Sakali halling si Isa, uk na, “Oto', punduk kau!” ");
INSERT INTO slm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Magtuwi 'llum pabayik aa matay hi'. Punduk iya maka uk na missala sabab 'llum iya pabayik. Pag-ubus siyongan iya uk si Isa ni ina' na. ");
INSERT INTO slm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na, tiyāw manga aa may'an kamemon maka siyanglitan Tuhan uk sigam. Halling sigam, “Niya' na nabi barakatan palahil paitu ni kitabi. Makapaitu na Tuhan nabangan kitabi manga aa suku' na.” ");
INSERT INTO slm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Manjari iya habal pasal bayi hinang itu uk si Isa pasaplag na peen ma kalohahan lahat Yahudiya, sampay ma manga lahat ma katilibut na. ");
INSERT INTO slm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Manjari kahakahan isab si Yahiya uk manga mulid na pasal kahinangan si Isa itu. Jari linganan uk na duwangan mulid na, ");
INSERT INTO slm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bo' siyoho' uk na sigam pahi' ni si Panghu' Isa. Siyoho' sigam niyaw iya bang iya baha' bayi pigbissala paitu ni dunya, atawa bang niya' le' saddi min iya iyagaran uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jari pagtakka duwangan itu ni si Isa, uk sigam, “Siyoho' kami paitu uk si Yahiya Magpapandi sabab niya' tiyaw na ni kau, bang kau baha' iya pigbissala paitu ni dunya? Atawa niya' saddi min kau subay iyagaran uk kami paitu?” ");
INSERT INTO slm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, ma waktu ian hi' heka aa kaulian uk si Isa iya ginisan lamma maka saki sigam, maka heka bayi kapaluwasan sayitan. Heka isab manga aa buta bayi pikanda' uk na pabing. ");
INSERT INTO slm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Manjari siyambungan uk si Isa duwangan mulid bayi siyoho' uk si Yahiya hi'. Uk na, “Pabing kaam pahi'. Bain bi si Yahiya pasal ayi-ayi tanda' bi hinang uk ku maka pasal ayi-ayi iya take bi bissala uk ku. Manga aa bayi buta makanda' na. Aa bayi pengka' makalangngan na tōōd. Aa bayi ipul kaulian na. Aa bayi bisu makake na, maka aa bayi matay tapakallum na pabing. Sampay aa miskin pignasihatan na lapal hap. ");
INSERT INTO slm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mehe du kahapan sasuku 'nsa' magduwa-duwa mangandōl ma aku.” ");
INSERT INTO slm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pakallo' peen minnihi' manga sosohoan si Yahiya hi', missala si Isa ni katipunan aa ian pasal si Yahiya. Uk na, “Ayi baha' bayi peha bi, bayi waktu kaam pahi' ni si Yahiya ma lahat 'nsa' agōn kalluman ayi-ayi ian? Kabayaan bi baha' nganda' dakayo' aa magpinda-pinda pikilan na sali' sapantun dawun parang, tabo magladdoy-laddoy uk baliyu? ");
INSERT INTO slm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bang 'nsa' ihi', ayi baha' bayi pig'nda' uk bi pahi'? Aa magsammek halgaan baha'? Tantu 'nsa', sabab bang aa magsammek salaihi' maka magpalasahan tōōd, ian sigam ma diyōm luma' aa dayahan. ");
INSERT INTO slm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bain aku tōōd bang ayi bayi pig'nda' uk bi pahi'? Dakayo' nabi baha'? Aho', nabi du, suga' iya bayi tanda' bi ian labi le' min manga nabi kamemon. ");
INSERT INTO slm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sabab si Yahiya itu bayi pigbissala ma diyōm kitab, iya uk na hi', ‘Tiya' sosohoan ku, uk Tuhan. Soho' ku iya parahu min kau, bo' supaya sakapan na daddōk palabayan nu.’ ");
INSERT INTO slm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Baan ta kaam,” uk si Isa, “si Yahiya Magpapandi itu 'nsa' du niya' labi langkaw min iya ma diyōm bangsa manusiya'. Suga' sayi-sayi ma diyōman pagparinta Tuhan minsan aa deyo' kapag-aa na, langkaw le' iya min si Yahiya.” ");
INSERT INTO slm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Manga aa kamemon bayi pake tōōd ma bissala si Yahiya, iya lagi' na manga aa magkallo' sukay parinta. Iyakuhan uk sigam in ayi-ayi pibōtang uk Tuhan asal bōntōl, iya hangkan sigam piyandi tawubat uk si Yahiya. ");
INSERT INTO slm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Suga' manga aa Parisi maka manga guru panday ma sara' agama, bayi 'nsa' baya' piyandi tawubat uk si Yahiya sabab siyulak uk sigam iya pamabōtang uk Tuhan ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Missala le' si Isa, uk na, “Ayi pamaralilan ku manga aa waktu itu? Ayi pamasalian sigam? ");
INSERT INTO slm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sali' sigam hantang onde'-onde' magtingkoan ma halaman tabu'. Ngalingan manga onde' min dambiya' ni kasehean sigam, uk na, ‘Oy! Kaam iyu! Bayi kami ngalisagan kaam suga' 'nsa' kaam bayi ngiluk! Bayi kami ngalugu' suga' kaam iyu 'nsa' me' magkarukkaan.’ ");
INSERT INTO slm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kaam iyu sali' sapantun onde' hi' 'nsa' tasulut. Bayi paitu si Yahiya Magpapandi, aa magpupuwasa maka 'nsa' nginum inuman makalango. Jari pihallingan iya uk bi in iya kono' siyōd uk sayitan. ");
INSERT INTO slm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Puwas hi' aku, Anak Manusiya', bayi paitu magkakan maka mag-inum. Magtuwi aku pahallingan bi. Uk bi, ‘He! 'Ndaun bi aa itu, lagak na! Panginginum! Magbagay iya maka manga aa magkallo' sukay parinta sampay aa baldusa kasehean.’ ");
INSERT INTO slm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Suga',” uk si Isa, “tanda' tabi ma sasuku me' ma Tuhan in pangatau na asal tawwa'.” ");
INSERT INTO slm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ma dakayo' 'llaw killo' si Isa uk dakayo' aa Parisi mangan ma luma' na. Jari pahi' na si Isa bo' ningko' ma pagkakanan. ");
INSERT INTO slm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, niya' dakayo' danda ma lahat ian laat asal hinang na. Makatau peen iya in si Isa ian mangan ma luma' Parisi hi', pahi' iya mo bingki'-bingki' hinangan batu pote', liyōōnan 'nsallan hamut. ");
INSERT INTO slm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pay'an iya nangge min bukutan si Isa, ma tōngōd nayi' na. Nangis na peen iya sampay base' na nayi' si Isa uk bohe' mata na. Siyapuhan uk na maka buun na, siyum isab uk na nayi' si Isa bo' iyampa tiyumpahan uk na maka 'nsallan hamut hi'. ");
INSERT INTO slm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tanda' peen itu uk Parisi bayi ngallo' si Isa mangan, uk na ma diyōm atay na, “Bang si Isa itu bayi nabi tōōd bayi du katauhan na bang sayi danda iya mangantanan nayi' na itu. Bayi du katauhan na in danda itu asal dusahan.” ");
INSERT INTO slm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sakali missala si Isa. “Simun,” uk na, “niya' halling ku ma kau.” “Aho', Tuwan Guru, pahallingun kono',” uk si Simun. ");
INSERT INTO slm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Missala si Isa, uk na, “Niya' duwangan aa taga utang sali'-sali' ma aa pangutangan. Dangan ian taga utang lima hatus pilak, bo' limampu' iya utang dangan. ");
INSERT INTO slm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sali'-sali' sigam 'nsa' makabayad hangkan piyuwasan utang sigam uk aa bayi pangutangan hi'. Na,” uk si Isa ma si Simun, “bang ma kau, ingga ma aa duwangan ian mehe lasa na ma aa bayi pangutangan sigam?” ");
INSERT INTO slm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nambung si Simun, uk na, “Bang ma aku, iya aa bayi piyuwasan utang na heka.” “Tawwa' sambung nu iyu,” uk si Isa. ");
INSERT INTO slm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Manjari itu palingi' si Isa ni danda bo' uk na ni si Simun, “Tanda' nu danda itu? Makasōd peen aku ni luma' nu sini' 'nsa' du aku bayi sakapan nu bohe' pangose' nayi' ku. Suga' danda itu, kiyosean uk na nayi' ku maka bohe' mata na, maka siyapuhan uk na maka buun na. ");
INSERT INTO slm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Nsa' aku bayi siyum uk nu pag-addatan suga' danda itu, sataggōl min kapaitu ku, 'nsa' bayi parōhōng niyum nayi' ku. ");
INSERT INTO slm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Nsa' du bayi 'nsallanan nu kok ku pag-addatan nu ma aku suga' danda itu bayi muusan 'nsallan halga' ma nayi' ku. ");
INSERT INTO slm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hangkan salaitu pama' ku ma kau: danda itu mehe lasa na ma aku sabab taampun dusa na heka. Bang aa kulang dusa na iyampun, kulang du isab lasa iya piluwas uk na.” ");
INSERT INTO slm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jari halling si Isa ni danda, uk na, “Iyampun na paldusahan nu.” ");
INSERT INTO slm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Minnihi' manga sehe' si Isa magsawu ian nagna' magtiyaw-tiyaw di sigam, uk na, “Sayi baha' aa itu ngampun manga dusa?” ");
INSERT INTO slm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Suga' halling si Isa ni danda ian, uk na, “Puwas du kau min mulka' Tuhan ma sabab pangandōl nu ma aku. Palanjal na kau, daa kau susa.” ");
INSERT INTO slm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'Nsa' taggōl minnihi', liyatag uk si Isa manga daira maka kalumaan magnasihat lapal hap pasal pagparinta Tuhan ma manga manusiya'. Me' ma iya mulid na sangpu' ka duwa, ");
INSERT INTO slm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","maka niya' isab manga danda parōngan ma iya. Danda kasehean itu bayi kapaluwasan sayitan uk si Isa, kasehean bayi pikowe' uk na saki sigam. Ian si Mariyam, danda min Magdala iya bayi kapaluwasan sayitan pitu' heka na. ");
INSERT INTO slm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kasehean ian si Joanna handa si Kusa, iya taga 'ntan langkaw ma diyōm luma' si Sultan Herod, maka ian si Susanna, maka heka le' manga danda saddi. Manga danda hi' bayi ngatasan di si Isa. ");
INSERT INTO slm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Niya' na peen aa magpay'an ni si Isa min manga daira maka manga kalumaan. Na, pagka heka na sigam magtipun ma tōngōd na, bissala uk na dakayo' kissa pamaralilan. Uk na, ");
INSERT INTO slm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Niya' ian dakayo' aa pahi' ni huma na nabōran bigi. Pagsabōd na itu niya' bigi kasehean pakpak ni bihing daddōk, sakali taddōk uk aa maglabayan maka tiyōttōk uk manga manuk-manuk sampay ubus na. ");
INSERT INTO slm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Niya' bigi kasehean pakpak ni tana' kabatuhan. Makatomo' peen, lakkas lanōs sabab tana' hi' 'nsa' niya' bohe' na. ");
INSERT INTO slm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Niya' isab bigi kasehean pakpak ni tangnga' sōmpōt itingan bo' kasimbōlan tiyanōm sabab magbe' pasuwig maka sōmpōt hi'. ");
INSERT INTO slm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na, iya bigi kasehean pakpak ni tana' hap bo' hap tomo' na bo' muwan buwa' heka kalandu'. “Na,” uk si Isa, “Sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tīyaw si Isa uk manga mulid na bang ayi hati na, iya kissa bayi pamaralil na ian. ");
INSERT INTO slm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nambung si Isa, uk na, “Kaam iyu kabuwanan pikilan bo' supaya tahati bi pasal kapagparinta Tuhan ma manga aa na, iya 'nsa' patau na ni manusiya' kasehean. Suga' manga aa kasehean ian subay piyanduan ma manga kissa pamaralilan supaya inda' sadja uk sigam suga' 'nsa' tasayu. Take uk sigam suga' 'nsa' tahati.” ");
INSERT INTO slm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na,” uk si Isa, “iya na itu hatihan kissa bayi pamaralil ku hi'. Iya bigi ian, iya na palman Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iya bigi bayi pakpak ni daddōk ian, iya dalil na manga aa makake palman Tuhan. Manjari pay'an nakura' sayitan ngagaw palman hi' min diyōm pikilan sigam bo' supaya sigam 'nsa' magkahagad bo' 'nsa' liyappasan. ");
INSERT INTO slm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Iya bigi bayi pakpak ni tana' kabatuhan ian, iya dalil na manga aa makake ma palman Tuhan. Magtuwi sigam kiyōgan nayima' lapal palman hi' suga' 'nsa' nganggamut palōm ma diyōm atay sigam. Dayi'-dayi' du pagkahagad sigam. Taabut peen sigam siyasat uk nakura' sayitan magtuwi sigam ngalabba min bayi pagkahagad sigam. ");
INSERT INTO slm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iya bigi bayi pakpak ni sōmpōt itingan ian, iya dalil na manga aa makake ma palman Tuhan. Suga' limbit pikilan sigam uk kahalan diyōm dunya itu. Iya na peen halgaan ma sigam manga pangalta' sigam maka napsu sigam. Sali' sigam dalil tiyanōm kasimbōlan, 'nsa' magbuwa'. ");
INSERT INTO slm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Manjari iya bayi siyabōran ni tana' hap ian, iya dalil na manga aa pake ma palman Tuhan min diyōm atay sigam. Tiyawu' uk sigam ma diyōm atay pote' maka tuyu' sigam mean iya. Jari palman ian sali' dalil tiyanōm muwan buwa' ma diyōm atay sigam, hati na hap katudjuhan na.” ");
INSERT INTO slm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mandu' le' si Isa, uk na, “'Nsa' niya' aa ngandōkōtan palitaan bo' iyampa lōkōban na maka undam atawa pabōtang na ma deyo' kantil. Tantu subay pibōtang uk na ma diyata' papagan na bo' tanda' sawa na uk manga aa pasōd ni diyōm luma' hi'. ");
INSERT INTO slm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sabab ayi-ayi tapukan ma buttihi' piluwas du ma sosongun, maka ayi-ayi limbungan ma buttihi' tahati du ma waktu siyong. ");
INSERT INTO slm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hangkan subay kehun bi pahap sabab sayi-sayi niya' tau na, kinnōpan le' tau na. Suga' sayi-sayi 'nsa' makahati, bo' peen pangannal na niya' tau na datti', kiyulangan du min iya.” ");
INSERT INTO slm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Manjari itu takka pay'an ina' si Isa maka manga danakan na lalla suga' 'nsa' sigam makasikōt ni iya sabab heka aa. ");
INSERT INTO slm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Niya' bayi halling ma si Isa, uk na, “Tuwan, ian ina' nu maka manga danakan nu nangge ma luwasan, baya' mag'nda' maka kau.” ");
INSERT INTO slm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Halling si Isa ni manga aa may'an hi', uk na, “Sayi-sayi pake ma palman Tuhan maka me' ma pandu' na, sigam iya kainaan ku maka dawuranakan ku.” ");
INSERT INTO slm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pag-abut 'llaw dakayo' pariyata' si Isa maka manga mulid na ni bayanan. Uk na ni sigam, “Sung kitabi pauntas ni dambiya' danaw hi'.” Na, pauntas na sigam. ");
INSERT INTO slm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma palangnganan peen sigam, tuwi na si Isa. Sakali itu niya' hunus parugpak ni danaw ian. Song na sigam buhaw sabab liyasayan uk goyak. Maka mehe kapiligduhan sigam. ");
INSERT INTO slm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Patōngōd ni si Isa manga mulid na mati' iya. “O Tuwan,” uk sigam, “lembo kitabi!” Jari papunduk si Isa bo' iyampa soho' na baliyu maka goyak ian parōhōng. Saruun-duun du parōhōng na bo' taddo' na tōōd danaw ian. ");
INSERT INTO slm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Puwas hi' halling si Isa ni manga mulid na, uk na, “Angay kaam! 'Nsa' kaam mangandōl ma aku?” Suga' tiyāw sigam maka inu-inu tōōd hangkan sigam magtiyaw-tiyaw di sigam, uk na, “Sayi baha' aa itu? Tasoho' na baliyu maka goyak bo' kapag-agihan du uk na.” ");
INSERT INTO slm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Manjari palanjal sigam sampay ni lahat bangsa Gerasa, iya ma dambiya' danaw min lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagduwai peen si Isa ni parian niya' aa min daira may'an pasampang ni iya, aa siyōd uk manga sayitan. Taggōl na iya 'nsa' magsammek atawa pabōtang ma diyōm luma' suga' lowang kubul iya pabōtangan na peen. ");
INSERT INTO slm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na, pag'nda' aa itu ma si Isa ngōlang iya pakōsōg maka pasujud ma dahuhan na. Kōsōg pangalingan na, uk na, “O Isa, Anak Tuhan Mahatinggi! Ayi lamud nu ma aku? Junjung ta kau, daa aku binsanaun.” ");
INSERT INTO slm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hangkan salaihi' junjung na sabab sayitan ma diyōm baran na ian hi' siyoho' uk si Isa paluwas. Daran asal aa ian bayi siyōd uk sayitan. Minsan iya ingkōtan ma nayi'-tangan na maka bilanggu' sampay jiyagahan uk manga aa, bakkat sadja uk na bilanggu' na bo' biyo iya uk sayitan maglunsul ni lahat 'nsa' agōn kalluman ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jari tīyaw iya uk si Isa, uk na, “Sayi ōn nu?” Uk sambung sayitan, “Ōn ku si Laksaan.” Sabab heka sayitan bayi pasōd ni diyōm baran aa ian. ");
INSERT INTO slm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nganjunjung manga sayitan hi' ni si Isa bang peen 'nsa' pipahi' uk na ni diyōm nalka'. ");
INSERT INTO slm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma jadjahan ian hi' niya' baanan koret, heka tōōd, magkakan ma lorosan bud. Na, ngamu'-ngamu' manga sayitan ian ma si Isa bang makajari pisōd ni diyōm manga koret ian bo' pibaid sigam uk na. ");
INSERT INTO slm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jari paluwas manga sayitan min baran aa hi' bo' pasōd ni diyōm baran manga koret. Magtuwi maglompat paragan manga koret ian min pampang tudju ni diyōm danaw bo' iyampa lembo kamemon. ");
INSERT INTO slm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pag'nda' itu uk manga aa bayi mangipat koret ian paragan sigam pahi' ni daira maka ni kalumaan de, maan manga aa may'an. ");
INSERT INTO slm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jari pay'an manga aa bo' tanda' uk sigam bang ayi bayi tahinang may'an. Pagtakka sigam ni tōngōd si Isa tanda' uk sigam aa bayi siyōd uk sayitan ningko' may'an ma bihing nayi' si Isa. Magsammek na iya maka hap na akkal-pikilan na. Manjari tiyāw sigam. ");
INSERT INTO slm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Biya'-ba' isab sigam uk manga aa bayi makanda' bang salaingga uk si Isa makowe' aa hi'. ");
INSERT INTO slm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Manjari manga aa min kalahat-lahatan Gerasa ian kamemon bayi ngamu' si Isa subay pakallo' minnihi' sabab landu' sigam tiyāw. Hangkan pariyata' si Isa ni bayanan bo' mowe' parambiya'. ");
INSERT INTO slm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aa bayi kapaluwasan sayitan hi' ngamu' me' ma si Isa suga' pipowe' iya. Uk si Isa ma iya, ");
INSERT INTO slm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mowe' na kau ni luma' nu. Bain manga aa may'an pasal hinang mehe bayi tahinang uk Tuhan ma kau.” Manjari pakallo' iya minnihi' bo' liyatag uk na diyōm daira hi' supaya tatanyag na pasal hinang mehe bayi tahinang ma iya uk si Isa. ");
INSERT INTO slm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na, makabing peen si Isa ni dambiya' danaw, kiyōgan manga aa may'an nampang iya sabab iyagaran iya uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sakali itu niya' pay'an ni iya dakayo' nakura' langgal ma lahat ian, ōn na si Jairus. Pasujud iya ni tōngōd nayi' si Isa ngamu' iya pahi' ni luma' na, ");
INSERT INTO slm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sabab niya' anak na danda dakayo'-kayo' sangpu' ka duwan tahun umul na, song magkamamatay. Sakali me' si Isa ma iya. Na, ma palangnganan peen si Isa tudju ni luma' nakura' ian, kasigpitan iya uk baanan aa ma katilibut na. ");
INSERT INTO slm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Niya' ma diyōm kahekahan aa ian dakayo' danda sakihan. Sangpu' na maka dantahun 'nsa' parōhōng laha' na. Ubus na sin na kamemon panamba doktor suga' 'nsa' niya' makapakowe' ma iya. ");
INSERT INTO slm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pasikōt iya ni si Isa min buwian na bo' maabut tangan na ni bihing sammek si Isa. Saruun-duun du parōhōng bayi paglaha' na. ");
INSERT INTO slm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sakali halling si Isa, uk na. “Sayi bayi ngantanan aku?” Mayilu manga aa ian kamemon. Uk si Petros, “Tuwan, landu' heka aa ma katilibut nu nigpitan kau, bo' tiyaw le' kau?” ");
INSERT INTO slm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Suga' halling si Isa, uk na, “Niya' bayi ngantanan aku sabab tananam ku niya' barakat paluwas min baran ku.” ");
INSERT INTO slm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sakali itu, pagka kitauhan uk danda in hinang na tasayu na, pahi' iya pasujud ni tōngōd nayi' si Isa maka uk na midpid. Minsan iya kine uk baanan aa ian biyaan uk na si Isa bang angay iya bayi maabut tangan na ni iya, maka pasal saki na kaulian magtuwi. ");
INSERT INTO slm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Uk si Isa ni iya, “Inda', kaulian na kau ma sabab pangandōl nu ma aku. Mowe' na kau, daa na kau susa.” ");
INSERT INTO slm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Manjari itu, sabu peen si Isa missala ni danda, niya' aa takka pay'an min luma' si Jairus. Uk na ni si Jairus, “Matay na anak nu. Daa na pamaleun guru iyu!” ");
INSERT INTO slm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Suga' take halling na itu uk si Isa bo' uk na ni si Jairus, “Daa kau tiyāw. Mangandōl sadja kau. 'Llum du anak nu.” ");
INSERT INTO slm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagtakka si Isa ni luma' nakura' ian 'nsa' niya' bayi diyulan uk na magbe' maka iya pasōd, duwal si Petros, si Yahiya, si Ya'kub, maka maas onde'. ");
INSERT INTO slm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Magtangisan maka magkarukkaan asal manga aa may'an kamemon ma sabab onde' hi'. Suga' halling si Isa ma sigam, uk na, “Daa kaam magtangis. 'Nsa' matay onde' itu. Tuwi iya sadja!” ");
INSERT INTO slm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pigtattohan iya uk sigam sabab katauhan sigam in onde' hi' matay na. ");
INSERT INTO slm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Manjari intanan uk si Isa tangan onde' bo' iyampa pitanōg uk si Isa suwara na, uk na, “Inda', punduk na kau.” ");
INSERT INTO slm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sakali pabayik nyawa na bo' papunduk iya magtuwi. Siyoho' iya uk si Isa subay piyakan. ");
INSERT INTO slm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inu-inu tōōd maas na suga' siyoho' sigam uk si Isa daa subay ma'-ma' ni sayi-sayi pasal ian hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Manjari itu linganan uk si Isa mulid na sangpu' ka duwa pahi' ni iya bo' sigam biyuwanan kawasa pamakallo' sayitan min diyōm baran aa sampay makowe' saki kaginisan. ");
INSERT INTO slm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Puwas hi' siyoho' sigam uk na palangngan magnasihat pasal pagparinta Tuhan ma manusiya'. Siyoho' sigam makowe' isab sasuku tawwa' saki. ");
INSERT INTO slm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Uk na ni sigam, “Daa kaam mo ayi-ayi ma palangnganan bi. Daa kaam mo tungkud atawa bag atawa lutu' atawa sin. Daa isab kaam mo badju' pagsayinan bi. ");
INSERT INTO slm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maingga-maingga lahat katakkahan bi, bang kaam siyagina uk aa siyoho' pariyata' ni luma' na, subay may'an pahantian bi sataggōl kaam ma kalumaan ian hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bang ganta' niya' kalumaan papahian bi, bo' aa na ian 'nsa' nagina kaam, pakallo' kaam min kalumaan ian. Paspasin bi dahu bagunbun na min nayi' bi tanda' saksi' in kaam puwas min sigam, bo' iyampa kaam pakallo'.” ");
INSERT INTO slm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Manjari maglangngan na manga mulid si Isa ngalatag kalahat-lahatan. Paingga-paingga takkahan sigam pignasihat uk sigam lapal hap, maka pikowe' uk sigam manga aa saki. ");
INSERT INTO slm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Manjari itu take uk si Herod, iya mangantan parinta ma lahat Jalil, pasal kamemon iya tahinang uk si Isa ian. Sasaw pikilan na sabab magsaddi-saddi pangupama manga aa. Bang ma aa kasehean si Isa iya si Yahiya Magpapandi, 'llum pabing min kamatay na. ");
INSERT INTO slm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bang ma kasehean si Nabi Eliyas ko' ian palahil paitu ni dunya. Bang ma kasehean isab si Isa iya dakayo' nabi bayi ma masa awwal, bo' 'llum na pabayik. ");
INSERT INTO slm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Uk si Herod, “Si Yahiya bayi soho' ku piyonggolan kok na. Suga' sayyanan aa itu iya take ku pasal hinang na makainu-inu?” Hangkan baya' tōōd si Herod supaya iya makanda' ma si Isa. ");
INSERT INTO slm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, manga aa bayi kawakilan uk si Isa pabing na ni iya. Biyaan iya uk sigam pasal kamemon bayi tahinang sigam. Manjari biyo sigam uk si Isa pay'an ni daira Betsaida, sigam-sigam sadja. ");
INSERT INTO slm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kitauhan peen uk baanan aa ian bang paingga si Isa, magtuwi sigam paturul ma iya. Siyagina sigam uk si Isa bo' piyanduan uk na sigam pasal pagparinta Tuhan. Pikowe' isab sasuku taga saki. ");
INSERT INTO slm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Song peen pasaddōp 'llaw, pahi' ni iya mulid na sangpu' ka duwa. Uk sigam, “Sohoun kono' baanan aa itu pahi' ni manga kalumaan ma katilibut lahat itu, maka ni luma' manga aa maghuma, bo' supaya sigam meha balanja' maka pahantian sabab 'nsa' niya' luma' ma lahat itu hi'.” ");
INSERT INTO slm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Suga' nambung si Isa ma manga mulid na hi', uk na, “Kaam na magpakan sigam.” Uk sigam, “Lima du tinapay ma kami maka duwa du daying. Duwal bang kami pahi' malli tinapay pamakan baanan aa itu!” ");
INSERT INTO slm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Niya' manga limangibu lalla may'an.) Uk si Isa ni manga mulid na, “Sohoun bi sigam magtingkoan limampu'-limampu' ma da tumpuk.” ");
INSERT INTO slm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ubus peen uk manga mulid na matingko' manga aa ian kamemon, ");
INSERT INTO slm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","killo' uk si Isa lima tinapay maka duwa daying-daying ian. Pahangad iya tudju ni langit bo' iyampa magsukul ni Tuhan. Puwas hi' pighopo'-hopo' uk na kiyakan ian bo' siyongan uk na ni manga mulid na bo' iyampa tiyōpōd-tōpōran uk sigam manga aa ian. ");
INSERT INTO slm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Magkakanan sigam kamemon sampay maglassohan na. Pag-ubus sigam mangan tipun uk manga mulid si Isa kapin kiyakan, niya' sangpu' ka duwa ambung mehe panno'. ");
INSERT INTO slm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Niya' dakayo' 'llaw, sabu peen si Isa nambahayang didihan na, pay'an ni iya manga mulid na. Jari tīyaw sigam, uk na, “Sayi kono' aku, bang ma pangupama manga aa?” ");
INSERT INTO slm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Uk sambung manga mulid hi', “Bang ma aa kasehean kau kono' si Yahiya Magpapandi hi'. Bang ma aa kasehean in kau si Nabi Eliyas, maka bang ma aa kasehean isab kau dakayo' nabi bayi ma masa awwal hi', bo' 'llum na pabing.” ");
INSERT INTO slm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Na, bang ma kaam,” uk si Isa. “Ayi uk bi? Sayi aku itu?” Nambung si Petros, uk na, “Kau iya Almasi iya tapene' uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Puwas hi' biyandaan uk si Isa manga mulid na 'nsa' siyoho' ma'-ma' ni sayi-sayi bang sayi iya. ");
INSERT INTO slm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Uk na isab ni sigam, “Aku itu, Anak Manusiya', heka du kabinsanaan pitakka ni aku. Siyulak du isab aku uk kamaasan maka uk manga kaimaman langkaw maka manga guru ma sara' agama. Piyatay du aku suga' taabut peen katallu 'llaw na, 'llum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jari halling si Isa ni manga aa ian kamemon, uk na, “Bang niya' aa baya' me' ma aku, subay 'nsa' kabayaan baran na iya dulan na. Kahaba' 'llaw subay tanggung na hag na pamapatayan iya (hati na subay piglilla' uk na kabinsanaan ma sabab ku sampay ni kamatay). Minnihi' iya makajari me' ma aku. ");
INSERT INTO slm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sayi-sayi 'llōgan kallum-baran na paōkat du kallum-nyawa na min Tuhan. Suga' sayi-sayi 'nsa' 'llōg ma kallum-baran na, bo' lilla' isab matay ma sabab ku, makatawwa' du iya kallum kakkal. ");
INSERT INTO slm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sabab na,” uk si Isa, “bang niya' aa ganta' kaniyaan alta' diyōm dunya kamemon, mehe lugi' na bang 'nsa' niya' kallum na kakkal maka bang paōkat iya min Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sayi-sayi iya' ma'-ma' ma mayiran in iya suku' ku, maka me' iya ma pandu' ku, jari aku itu, Anak Manusiya', iya' du ngakuhan aa ian ma waktu kapaitu ku pabayik. Pabayik du aku libut uk sahaya ku maka uk sahaya 'Mma' ku Tuhan maka manga malaikat na sutsi. ");
INSERT INTO slm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bannal iya halling ku itu ma kaam,” uk si Isa, “niya' ma itu ma kaam iyu 'nsa' matay sataggōl 'nsa' tanda' na pagparinta Tuhan pibōtang.” ");
INSERT INTO slm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, palabay peen manga dapitu' min bayi pamissala si Isa ian hi', biyo uk si Isa si Petros maka si Yahiya maka si Ya'kub patukad ni diyata' bud bo' iya ngarap ni Tuhan ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sabu peen iya ngamu'-ngamu', pinda dagbōs bayihu' na maka landu' pote' sammek na, makasilaw na. ");
INSERT INTO slm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sakali niya' duwangan lalla may'an magbissala maka si Isa, iya na si Musa maka si Eliyas. ");
INSERT INTO slm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bayi sigam palahil pay'an libut uk sahaya bo' magbissala sigam maka si Isa pasal bohan kamatay bayi pamakadal Tuhan ma iya, iya song kalabayan na ma daira Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, si Petros maka manga sehe' na bayi tuwi suga' bati' sigam bo' tanda' uk sigam sahaya si Isa maka aa duwangan iya nangge ma bihing na. ");
INSERT INTO slm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jari itu, song peen pakallo' duwangan ian min si Isa, halling si Petros ma si Isa, uk na, “Tuwan Guru, hap tōōd isab tiya' kami ma itu. Ngahinang kami tallu bawung-bawung pasindungan bi ma itu, dakayo' ma kau, dakayo' ma si Musa itu, maka dakayo' ma si Eliyas.” (Missala sadja iya, suga' 'nsa' katauhan na bang ayi subay halling na.) ");
INSERT INTO slm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma sabu peen iya halling, niya' gabun bayi paluwas ngalandungan sigam bo' tiyāw manga mulid ian pagka kalandungan salaihi'. ");
INSERT INTO slm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Niya' suwara halling min diyōm gabun hi', uk na, “Anak ku ko' itu bayi pene' ku. Kehun bi iya.” ");
INSERT INTO slm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Parōhōng peen suwara ian halling, na, si Isa didihan na iya tanda' uk manga mulid hi'. 'Nsa' sigam bayi halling-halling pasal ian hi'. Maka ma waktu ian 'nsa' sigam ma'-ma' ni sayi-sayi pasal bayi tanda' uk sigam hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pag'llaw sawung, palud di si Isa min bud ian. Jari heka aa tōōd pasampang ni iya. ");
INSERT INTO slm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Niya' lalla ngalingan min diyōm katipunan aa ian, uk na, “O Tuwan! Ngamu' aku junjung ni kau: kaasein kono' anak ku, anak ku tunggal itu! ");
INSERT INTO slm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sabab bang iya siyōd uk sayitan magtuwi sadja iya ngōlang, maspad manga baran na maka ngalappu bo' na. Landu' iya miyula uk sayitan, 'nsa' agōn iya diyōhōngan. ");
INSERT INTO slm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bayi amu' ku manga mulid nu itu maluwas sayitan itu suga' 'nsa' tapaluwas uk sigam.” ");
INSERT INTO slm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Uk si Isa, “Kaam manga aa ma tahun itu hi', sā' pahap pikilan bi! 'Nsa' tōōd niya' iman bi! Subay salaingga le' taggōl ku ma kaam nandalan addat bi iyu bo' iyampa kaam magkahagad?” Jari halling iya ni 'mma' onde', “Bohun anak nu paitu.” ");
INSERT INTO slm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na, sabu peen onde' ian biyo ni si Isa, hiyantakan iya ni tana' uk sayitan bo' maspad iya. Suga' pihallingan sayitan ian uk si Isa bo' pikowe' uk na onde' hi'. Puwas hi' siyongan uk na ni 'mma' na. ");
INSERT INTO slm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jari inu-inu manga aa may'an kamemon pag'nda' sigam ma kōsōg kawasa Tuhan. Masi peen mag-inu-inu manga aa ian ma manga hinang si Isa kamemon, halling iya ni manga mulid na, uk na, ");
INSERT INTO slm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kannalun bi tōōd manga bissala ku itu ma kaam. Aku itu, Anak Manusiya', song na siyongan ni pagbayaan manga aa.” ");
INSERT INTO slm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Suga' 'nsa' tahati bissala si Isa ian uk manga mulid na. Limbungan tōōd hatihan bissala na min sigam supaya 'nsa' tahati uk sigam. Maka 'nsa' sigam katawakkal niyaw ma iya bang ayi hati na bayi bissala na hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma 'llaw dakayo' magjawab manga mulid si Isa bang sayi ma sigam iya katapusan langkaw. ");
INSERT INTO slm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kitauhan asal uk si Isa bang ayi ma diyōm pikilan sigam, hangkan killo' uk na dakayo' onde'-onde' diki' bo' pitangge uk na ma bihing na. ");
INSERT INTO slm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Uk na ni sigam, “Sasuku nayima' dakayo' onde'-onde' diki' salaitu ma sabab ōn ku iya pamanyabutan na, sali' baran ku iya tayima' uk na. Maka sasuku nayima' aku, tayima' na isab Tuhan iya bayi mapaitu aku ni dunya. Sayi-sayi deyo' pangatayan na min kasehean na, iya ian katapusan langkaw.” ");
INSERT INTO slm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jari halling si Yahiya, uk na, “Tuwan, niya' tanda' kami dakayo' aa nabbut ōn nu pamaluwas na sayitan min diyōm baran aa. Bayi iya liyāng uk kami sabab 'nsa' iya sehe' tabi.” ");
INSERT INTO slm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Suga' halling si Isa, uk na, “Daa iya langun bi sabab sasuku 'nsa' nagga' kaam mōgbōgan kaam du.” ");
INSERT INTO slm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manjari itu, pagka song taabut waktu pamaangkat si Isa ni sulga', tuyu' tōōd iya pahi' ni Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niya' manga aa soho' na parahu min iya bo' pahi' sigam mangngan tudju ni dakayo' kawuman ma lahat Samariya nakapan pahantian si Isa ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Suga' manga aa ma kawuman ian 'nsa' baya' nayima' si Isa sabab Awrusalam iya patudjuhan na. ");
INSERT INTO slm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagka kitauhan itu uk duwa mulid na, si Ya'kub maka si Yahiya, uk sigam ni si Isa, “Tuwan Panghu', baya' kau baha' bang kami noho' api pahug min sulga' bo' matay manga aa ian?” ");
INSERT INTO slm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Suga' hiyarap duwangan itu uk si Isa bo' pihallingan uk na sigam. ");
INSERT INTO slm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manjari palanjal di si Isa pahi' ni kalumaan saddi. ");
INSERT INTO slm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma palangnganan peen sigam, niya' dakayo' aa missala ni si Isa, uk na, “Tuwan, baya' aku me' ma kau paingga-paingga tudjuhan nu.” ");
INSERT INTO slm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Uk si Isa ma iya, “Gam hayōp tawun niya' pabōtangan na, maka kamanuk-manukan niya' pugaran na. Suga' aku, Anak Manusiya' itu, 'nsa' niya' tōōd luma' patōtōgan ku atawa pagtuwihan ku.” ");
INSERT INTO slm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Halling si Isa ni aa dakayo', uk na, “Paitu kau me' ma aku.” Suga' halling aa hi', uk na, “Tuwan, pabairun le' aku pabing ni luma'. Subay puwas pangubul ku ma 'mma' ku dahu bo' iyampa aku me' ma kau.” ");
INSERT INTO slm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nambung si Isa, uk na, “Patut du bang aa matay pikubul ni manga aa kasehean iya 'nsa' niya' kallum sigam taptap. Suga' kau, subay pahi' magnasihat pasal pagparinta Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Niya' isab aa dangan, uk na ma si Isa, “Me' aku ma kau, Tuwan, suga' pabairun le' aku pahi' dahu maid ni anak-handa ku.” ");
INSERT INTO slm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Uk si Isa ma iya, “Bang niya' aa magbadja' ma huma na bo' palingi' nganda' sadja ni buwian na, 'nsa' hap. Damikkiyan na bang aa baya' me' ma aku bo' bimbang uk ayi-ayi bayi labbahan na hi', 'nsa' iya tiyōp pigparintahan uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Puwas hi' niya' le' pitumpu' ka duwa aa kawakilan uk si Isa. Siyoho' sigam uk na parahu ni kamemon daira maka kalumaan iya song papahian na. Pilangngan sigam uk na duwang-duwangan. ");
INSERT INTO slm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Uk na ma sigam, “Manga aa ian sali' dalil huma heka buwa' na. Loha tana' suga' kulang aa mag-ani, hangkan uk ku ma kaam: ngamu'-ngamu' kaam tabang ni iya dapu tana' bo' supaya iya noho' manga aa pahi' mag-ani. ");
INSERT INTO slm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, mangngan na kaam. Pahap-hap kaam sabab papahi' ta kaam ni diyōman manga aa laat. Sali' kaam sapantun anak bili-bili pipahi' ni diyōman baanan ero' tawun iya magpangeket. ");
INSERT INTO slm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Daa kaam mo pitaka atawa bag atawa tawumpa'. Bang niya' aa tasampang bi ma labayan daa kaam parōhōng magbissala. ");
INSERT INTO slm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bang niya' luma' pariyataan bi halling kaam dahu. Uk bi, ‘Bang peen kaam kaniyaan kasannangan!’ ");
INSERT INTO slm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Manjari bang niya' pabōtang ma luma' ian aa patut kaniyaan kasannangan, katakkahan du iya kasannangan bayi pangamu' bi hi'. Suga' bang 'nsa', pabing sadja ni kaam kasannangan hi'. ");
INSERT INTO slm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pabōtang kaam ma dakayo' luma' sadja. Daa kaam magpinda-pinda pabōtangan. Mangan kaam maka nginum kaam ayi-ayi pangalabōt ma kaam uk manga aa ma diyōm luma' hi' sabab bang aa maghinang wajib iya biyuwanan balanja' na. ");
INSERT INTO slm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Maingga-maingga kalumaan katakkahan bi, bang kaam siyagina uk manga aa na, kakanun bi ayi-ayi pibōtangan ma kaam uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakoweun bi manga aa sakihan ma hi' maka uk bi ma sigam, ‘Taabut na waktu pagparinta Tuhan ma kaam.’ ");
INSERT INTO slm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Suga' bang niya' kalumaan katakkahan bi bo' kaam 'nsa' ganta' siyagina uk aa na, paluwas kaam ni kalsada bo' kaam halling. ");
INSERT INTO slm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Uk bi, ‘Tiya' pipaspasan min nayi' kami bagunbun lahat bi itu, tanda' saksi' in kami puwas na min kaam. Suga' subay katauhan bi in pagparinta Tuhan sikōt na.’ ");
INSERT INTO slm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Baan ta kaam,” uk si Isa, “bang taabut 'llaw pangahukum Tuhan ma manusiya' bohat le' hukuman na ma manga aa ma lahat ian min bayi hukuman ma lahat Sodom, iya lahat bantug ma sabab dusa aa na ma masa awwal hi'.” ");
INSERT INTO slm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Allā!” uk si Isa. “Kaam manga aa min lahat Korasin maka aa min Betsaida, makaase'-ase' tōōd iya pamakadal ma kaam! Heka hinang makainu-inu bayi pindaan ni kaam suga' 'nsa' bayi asip bi. Bang hinang ian bayi pindaan ni aa ma daira Tira maka daira Sidun ma masa awwal hi', tantu sigam bayi pataikut min dusa sigam. Tantu sigam bayi magsammek karut, manga magbusugan di sigam maka abu, tanda' pagsusun sigam. ");
INSERT INTO slm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bang taabut 'llaw pangahukum Tuhan, bohat le' hukuman iya pitakka ni kaam min bayi hukuman ma manga aa daira Tira maka daira Sidun hi'. ");
INSERT INTO slm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaam isab aa Kapirnaum,” uk si Isa, “iyu kaam magbantug-bantug di bi in kaam pilangkaw sampay ni sulga'! Duwal bang nalka' iya pasampayan bi!” ");
INSERT INTO slm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Halling na si Isa ni manga mulid na, uk na, “Sasuku ngasip ma pandu' bi, sali' aku iya taasip na. Sayi-sayi isab nulak kaam, sali' aku iya tasulak na. Maka sayi-sayi nulak aku, tasulak na Tuhan iya bayi noho' aku paitu ni dunya.” ");
INSERT INTO slm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Nsa' taggōl, takka na pabayik ni Isa manga aa pitumpu' ka duwa bayi soho' na magnasihat. Landu' sigam kiyōgan. Uk sigam ni si Isa, “Tuwan, minsan manga sayitan bayi me' ma panohoan kami basta sabbut kami ōn nu!” ");
INSERT INTO slm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nambung si Isa, uk na, “Bayi tanda' ku nakura' sayitan sali' dagbōs kirat hug min diyata' langit, 'nsa' na niya' gaōsan na. ");
INSERT INTO slm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pake kaam. Buwanan ta kaam kawasa bo' kaam 'nsa' inay minsan taddōk bi so atawa jalalangking. Karaōgan bi isab kōsōg sayitan nakura', iya banta tabi, bo' 'nsa' niya' makamula kaam minsan ayi. ");
INSERT INTO slm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Suga' daa kaam kiyōgan ma sabab kaam binean uk manga sayitan panohoan bi. Gam du bang kaam kiyōgan ma sabab ōn bi hi' tasulat uk Tuhan ma diyōm sulga'.” ");
INSERT INTO slm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Manjari ma waktu ian kiyōgan si Isa sabab min Nyawa Sutsi bo' uk na ni Tuhan, “O 'Mma', kau iya makapagbaya' ma sulga' maka ma dunya. Mehe pagsukulan ku ni kau sabab in bayi limbuhan nu min aa taga pangadji' sampay min aa lōm tau na, pahati nu na ni manga aa kulang tau na. Aho', 'Mma', min kōg nu maka min baya' nu hangkan salaihi'. ");
INSERT INTO slm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Bayi na pingandōl ayi-ayi kamemon ma aku uk 'Mma' ku. 'Nsa' niya' makatau Anak Tuhan bang sayi iya, duwal 'Mma' ku hi'. Damikkiyan na isab, 'nsa' niya' makatau 'Mma' ku bang sayi iya, duwal aku anak na tunggal, sampay isab sasuku tapene' ku subay pahati ku.” ");
INSERT INTO slm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jari paharap si Isa ni manga mulid na bo' halling ni sigam sadja. “Mehe du kahapan bi,” uk na, “sabab makanda' na kaam ayi-ayi iya tanda' bi iyu. ");
INSERT INTO slm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Baan ta kaam, heka manga nabi maka manga sultan ma masa awwal hi' bayi baya' tōōd nganda' pakaradjaan iya tanda' bi ma buttihi', suga' 'nsa' tanda' uk sigam. Baya' isab sigam pake ma ayi-ayi take bi itu, suga' 'nsa' take uk sigam.” ");
INSERT INTO slm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Manjari niya' dakayo' guru ma sara' agama pahi' ni si Isa. Niya' tiyaw na ma si Isa panulayan iya. Uk na, “Tuwan Guru, ayi subay hinang ku bo' supaya aku pisukan kallum kakkal ni kasaumulan?” ");
INSERT INTO slm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nambung si Isa, uk na, “Ayi baha' tasulat ma diyōm sara' Tuhan, iya bayi tasulat uk si Musa? Ayi hati na iya tabassa nu ma hi'?” ");
INSERT INTO slm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uk sambung aa hi', “Wajib kaam lasa tōōd ma Panghu' bi Tuhan. Iya lasa bi ma iya subay min diyōm atay bi maka min diyōm pikilan bi maka min panahuhan bi maka min kōsōg bi. Maka wajib isab kaam lasahan pagkahi bi manusiya' sali' uk bi lasahan baran bi.” ");
INSERT INTO slm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tawwa' sambung nu,” uk si Isa. “Hinangun iyu bo' pisukuan du kau kallum kakkal ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Suga' guru ian 'nsa' baya' taraōg hangkan uk na ma si Isa, “Manjari, sayi baha' pagkahi ku iya subay kalasahan ku?” ");
INSERT INTO slm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nambung si Isa, uk na, “Niya' dakayo' aa bangsa Yahudi palud min Awrusalam tudju ni daira Ariha. Ma labayan peen, diyugpakan iya uk manga mundu. Liyaugan iya maka liyangpasan kamemon na sampay sammek bayi pasammek na. Pisaran iya may'an uk sigam, maka halōl na iya. ");
INSERT INTO slm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pasalta' niya' palabay min daddōk ian dakayo' imam Yahudi suga' pag'nda' na ma aa halōl hi', palabay iya min dambiya'. ");
INSERT INTO slm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Damikkiyan na niya' aa dakayo' makalabay pay'an, Yahudi isab suga' min tubu' si Libi (iya nabangan imam ma diyōm langgal). Suga' pag'nda' na ma aa halōl hi', palabay isab iya min dambiya'. ");
INSERT INTO slm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Puwas hi' niya' dakayo' aa bangsa Samariya mangngan may'an bo' taabut na aa halōl hi'. Pag'nda' na magtuwi iya katakkahan ase'. ");
INSERT INTO slm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pasikōt iya ni tōngōd aa hi' bo' tambalan na pali' na maka 'nsallan maka alak, bo' iyampa piyutus uk na. Puwas hi' piyakura' uk na ma diyata' kura' na bo' biyo uk na ni luma' paghantian bo' supaya ipat uk na may'an. ");
INSERT INTO slm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagsawung muwan iya sin ni aa dapu luma' hi' bo' uk na ma iya, ‘Ipatun ma aku aa itu. Bang kau makagastu palabi min sin itu, bayaran ku meen bang paiyu aku pabayik.’ ” ");
INSERT INTO slm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jari tiyaw si Isa ni guru, uk na, “Na, ma aa tallungan ian, ingga pikil nu magpanda' lasa na ma pagkahi na bayi kalangpasan uk mundu hi'?” ");
INSERT INTO slm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nambung guru, uk na, “Iya maase' ma iya sampay nabang.” “Na,” uk si Isa, “pahi' na kau. Hinangun sali' hinang aa ian.” ");
INSERT INTO slm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Manjari itu, makalanjal peen di si Isa maka manga mulid na minnihi', takka sigam ni dakayo' kalumaan bo' siyagina iya uk dakayo' danda iyōnan si Marta, siyoho' pariyata' ni luma' na. ");
INSERT INTO slm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Niya' danakan si Marta danda iyōnan si Mariyam. Si Mariyam itu ningko' na peen ma bihing nayi' si Isa pake ma pamandu' na. ");
INSERT INTO slm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Si Marta lingōg pikilan na sabab heka hinang na mag-adjal lalabōtan, hangkan iya pahi' ni si Isa missala. “Tuwan,” uk na, “'nsa' kau magparuli pasal kahalan ku itu? Sabab tiya' aku pisaran uk danakan ku mag-adjal didi ku. Sohoun iya nabang.” ");
INSERT INTO slm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Suga' nambung si Isa, uk na, “Kau Marta, sasaw kau maka heka hinang kasusahan nu, ");
INSERT INTO slm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","suga' dakayo' du hinang mehe kagunahan na. Hap iya pene' uk si Mariyam, 'nsa' du killoan min iya.” ");
INSERT INTO slm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Niya' dakayo' 'llaw nambahayang si Isa. Na, ubus peen uk na nambahayang, halling ni iya dakayo' mulid na, uk na, “Tuwan, panduin kono' kami magsambahayang sali' si Yahiya bayi manduan manga mulid na.” ");
INSERT INTO slm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nambung si Isa, uk na, “Bang kaam nambahayang subay salaitu kalangnganan na. Uk bi, ‘O 'Mma' kami Tuhan, bang peen pig-addatan ōn nu sutsi uk aa kamemon. Bang peen 'nsa' taggōl bo' kau magparinta ma manusiya' kamemon ma dunya itu. ");
INSERT INTO slm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Buwanin kami balanja' 'llaw-llaw. ");
INSERT INTO slm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampunun manga dusa kami, sabab ampun kami isab ma sayi-sayi makabuwanan kami dusa. Daa kami sulayan nu biyo ni diyōm sasat.’ ” ");
INSERT INTO slm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Halling le' si Isa ni sigam, uk na, “Bang sawupama niya' min kaam aa taga bagay. Jari pahi' kaam tōnga' bahangi ni luma' bagay bi hi' bo' uk bi, ‘O bagay, pasambiun kono' aku tinapay tallu heka na, ");
INSERT INTO slm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sabab niya' bagay ku takka bahu min paglangnganan na. Tiya' ma luma' kami, bo' 'nsa' niya' ayi-ayi pamakan ku ma iya.’ ");
INSERT INTO slm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sakali nambung bagay bi min diyōm luma', uk na, ‘Oy! Daa aku sasawun. Hōgōt na tambōl lawang maka tiya' na kami maka manga anak ku magbahakan. 'Nsa' aku makapunduk muwanan kau ayi-ayi.’ ");
INSERT INTO slm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Baan ta kaam,” uk si Isa, “minsan salaihi' panambung bagay bi hi' papunduk du iya bo' kaam biyuwanan uk na ayi-ayi kagunahan bi. 'Nsa' ma sawukat kaam bagay na asal, suga' ma sabab kaam 'nsa' parōhōng ngamu' ni iya. ");
INSERT INTO slm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Hangkan uk ku ma kaam: ngamu'-ngamu' kaam bo' biyuwanan du kaam. Meha kaam bo' makatawwa' du kaam. Mikiukab kaam bo' iyukaban du kaam. ");
INSERT INTO slm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sabab sayi-sayi ngamu' kabuwanan du, sayi-sayi meha makatawwa' du, sayi-sayi mikiukab iyukaban du. ");
INSERT INTO slm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kaam taga anak iyu, bang kaam pangamuan daying uk anak bi buwanan bi iya so baha'? ");
INSERT INTO slm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atawa bang amu' na iklug buwanan bi iya jalalangking baha'? ");
INSERT INTO slm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kaam iyu, minsan kaam taga dusa tau du muwanan anak bi ayi-ayi makahap. Luba'-luba' na na 'Mma' bi ma diyōm sulga' tau du muwanan kaam Nyawa Sutsi ni sasuku ngamu' ni iya.” ");
INSERT INTO slm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Niya' sayitan makaumaw piluwas uk si Isa. Pakallo' peen sayitan hi', makabissala na aa bayi umaw hi'. Inu-inu manga baanan aa bayi may'an, ");
INSERT INTO slm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","suga' niya' manga aa halling, “Kabuwanan iya kawasa uk si Belsebul iya pagnakuraan manga sayitan, hangkan iya makapaluwas manga sayitan.” ");
INSERT INTO slm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Niya' isab manga aa kasehean bayi ngamu' pindaan uk si Isa hinang makainu-inu panulayan sigam ma iya bang bannal bayi min Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Suga' katauhan asal uk si Isa bang ayi pikil uk sigam, hangkan uk na ma sigam, “Bang sawupama niya' pagsultanan bahagi' duwa manga aa na bo' magbono' sali'-sali', 'nsa' taggōl magkaat pagsultanan hi'. Damikkiyan na bang niya' aa magdaōkōm bahagi' duwa bo' magsaggaan di sigam, lakkas sigam magkawukanat. ");
INSERT INTO slm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Damikkiyan na bang nakura' sayitan maluwas sayitan, hati na magsagga' iya maka panindōg na, 'nsa' du taggōl kōsōg du sigam. Na, uk bi in aku itu kabuwanan kawasa uk nakura' sayitan iya hangkan aku makapaluwas sayitan. ");
INSERT INTO slm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bang ihi' bannal, minningga baha' pangalloan mulid bi kawasa, iya hangkan sigam isab makapaluwas sayitan? Mulid bi iya mabukis kasaan bi. ");
INSERT INTO slm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Suga' iya bannal na, iya hangkan aku makapaluwas sayitan sabab kawasa ku deyo' bayi min Tuhan. Iya na ko' iyu paltandaan in Tuhan tiya' na magparinta ma kaam. ");
INSERT INTO slm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sawupama aa gaōs sakap asal maka pakōkōs na, bang iya ganta' nganjagahan luma' na 'nsa' du inay pangalta' na. ");
INSERT INTO slm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Suga' bang niya' aa labi le' kōsōg na parugpak pay'an maka ngandaōg, kalangpasan du manga pakōkōs bayi pangandōlan uk aa dapu luma' hi'. Pigbahagi'-bahagian isab manga alta' na uk aa mangandaōg ian bo' pamuwan na ma manga sehe' na.” ");
INSERT INTO slm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Halling isab si Isa, uk na, “Sayi-sayi 'nsa' mōgbōgan aku nagga' aku du. Maka sayi-sayi 'nsa' nabangan aku magpatipun manga suku' ku, makawukanat du iya.” ");
INSERT INTO slm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Na, bang takdil ni sayitan,” uk si Isa, “bang niya' sayitan paluwas min baran aa liyunsul uk na ni lahat 'nsa' bayi kaulanan meha pahalihan na. Suga' 'nsa' niya' tatawwa' na. Jari halling sayitan ian ni baran na, uk na, ‘Gam na aku pabing ni diyōm baran aa bayi pabōtangan ku hi'.’ ");
INSERT INTO slm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pagbing peen, tanda' na hi' bayi siyapuhan maka mimmōs. ");
INSERT INTO slm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Puwas na hi' pahi' iya ngallo' pitu' sayitan saddi, labi le' laat sigam min iya, bo' pasōd sigam kamemon ni diyōm baran aa pabōtang may'an. Jari in kahalan aa hi' laat le' damuwihan na min bayi dahu.” ");
INSERT INTO slm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Manjari ubus peen pamissala si Isa ian hi', niya' dakayo' danda min katipunan aa ian halling patanōg. Uk na ma si Isa, “Kiyōgan pahap danda bayi nganakan kau maka bayi maruruan kau!” ");
INSERT INTO slm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Suga' nambung si Isa, uk na, “Mehe le' pagkōg-kōgan sasuku pake ma palman Tuhan sampay me' ma panohoan na.” ");
INSERT INTO slm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sasang paheka peen manga aa pay'an ni si Isa halling na ma sigam, “Kaam manga aa tahun itu hi', laat kaam. Mikipanda' kaam paltandaan panulayan bi aku bang sabannal-bannal aku min Tuhan. Suga' 'nsa' niya' paltandaan pindaan ni kaam, duwal paltandaan si Nabi Yunus bayi ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Si Yunus itu bayi hinang paltandaan uk Tuhan pamanda' ma manga aa ma daira Niniba, maka damikkiyan na isab aku, Anak Manusiya'. Tahinang du aku tanda' para ma kaam manga aa tahun itu hi'. ");
INSERT INTO slm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bang taabut na 'llaw pangahukum Tuhan ma manusiya', niya' du nangge may'an dakayo' sultan danda bayi ma lahat Seba ma masa awwal hi'. Naksi' du iya in kaam bayi magdusa. Iya hangkan danda ian taga kapatut naksi' sabab bayi iya paitu min lahat na ma bihing dunya supaya take na bissala si Sultan Sulayman, iya bayi lōm tōōd pangatau na hi'. Suga' baan ta kaam, ma buttihi' niya' ma itu ma kaam pasong le' pangatau na min si Sultan Sulayman, suga' 'nsa' du iya asip bi. ");
INSERT INTO slm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bang taabut na 'llaw pangahukum Tuhan ma manusiya' magtanggehan may'an manga aa bayi ma daira Niniba ma masa awwal hi', bo' sigam du naksian kaam in kaam taga dusa. Sabab bayi kine uk sigam nasihat si Yunus, magtuwi pinda min dusa sigam. Baan ta kaam, tiya' na dakayo' aa labi le' langkaw min si Yunus hi', suga' 'nsa' iya asip bi.” ");
INSERT INTO slm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mandu' le' si Isa, uk na, “'Nsa' niya' ngandōkōt palitaan bo' iyampa tapukan na atawa lōkōban na maka undam, suga' biyōtang du uk na ma diyata' pabōtangan na supaya tanda' sawa na uk sasuku pasōd ni diyōm luma' hi'. ");
INSERT INTO slm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata ta itu sali' dalil palitaan muwan sawa ma diyōm ginhawa ta. Bang hap panganda' ta, hati na bōntōl hinang ta, iya pigbahasa sali' sawa lullun diyōm ginhawa ta. Suga' bang mata ta 'nsa' hap, hati na laat hinang ta, iya pigbahasa sali' ngalindōm diyōm ginhawa ta itu. ");
INSERT INTO slm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hangkan kaam subay kamaya'-maya' bo' 'nsa' sā' pikilan bi. Bang uk bi niya' ma kaam kasawahan bo' 'nsa', na mehe kalindōman bi. ");
INSERT INTO slm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Suga' bang sawa lullun diyōm bi, maka bang 'nsa' niya' lindōm na minsan datti', sawa tōōd kamemon na. Iya dalil na niya' palitaan masawahan iya.” ");
INSERT INTO slm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ubus peen uk si Isa missala, niya' dakayo' aa Parisi mo iya ni luma' na mangan. Jari pasōd iya pay'an bo' ningko' mangan. ");
INSERT INTO slm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Inu-inu Parisi hi' ma si Isa sabab 'nsa' bayi ngosean tangan na dahu bo' iyampa mangan. ");
INSERT INTO slm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Uk si Isa ma iya, “Kaam manga Parisi, kiyosean uk bi sawan bi maka layi bi sampay luwasan na, suga' panno' diyōm atay bi uk panganapsu bi maka kalaatan bi. ");
INSERT INTO slm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dupang pahap kaam! Pangannal bi baha' in luwasan baran bi sadja iya pipanjari uk Tuhan, bo' diyōm na 'nsa'? ");
INSERT INTO slm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Suga' ayi-ayi ma diyōm sawan bi maka layi bi iyu, panarakkahun bi ma manga miskin, jari halal du kamemon ma kaam. ");
INSERT INTO slm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makaase'-ase' tōōd iya pamakadal ma kaam, manga Parisi! Sabab tuyu' tōōd kaam ngungsud ni Tuhan bahagi' sangpu' min ayi-ayi bi kamemon, minsan laa ginisan sayul-sayul iya pamapa bi kiyakan, sali' manga bawang maka manga sayi. Suga' 'nsa' kabōgbōgan bi manga hinang halgaan, hati na hinang bōntōl ma pagkahi bi maka lasa tudju ni Tuhan. Hap isab hinang bi ngungsud bahagi' min ayi-ayi bi, suga' daa subay tayikutan bi manga hinang halgaan hi'. ");
INSERT INTO slm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makaase'-ase' tōōd iya pamakadal ma kaam, manga Parisi! Sabab iya kabayaan bi bang kaam ganta' ma diyōm langgal, subay kaam ningko' ma paningkoan bangsahan. Bang kaam ma mayiran, iya kabayaan bi subay hiyulmat uk manga aa. ");
INSERT INTO slm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Makaase'-ase' tōōd iya pamakadal ma kaam. Sabab sali' kaam sapantun manga kubul 'nsa' niya' pangandaan na, manjari taddōk uk aa bo' 'nsa' kitauhan uk sigam in ian makasammal.” ");
INSERT INTO slm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na, niya' may'an dakayo' guru ma sara' agama halling ni si Isa, uk na, “Tuwan Guru, pagka salaihi' halling nu ma manga Parisi, iya du kami talapay nu pikaiya'.” ");
INSERT INTO slm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Aho',” uk si Isa, “makaase'-ase' isab iya pamakadal ma kaam, manga guru ma sara' agama! Sabab pabohatan bi manga aa maka manga sara' iya 'nsa' takowe' biyōgbōgan uk sigam, bo' kaam iya 'nsa' nabang mo minsan laa tabang diki' sadja. ");
INSERT INTO slm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Makaase'-ase' iya pamakadal ma kaam! Sabab pialti uk bi tampat ma manga nabi, bo' nabi ian bayi tabono' uk ka'mbo'-mboan bi ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jari kaam iyu naksian di bi in kaam pauyun du ma kahinangan ka'mbo'-mboan bi hi'. Sigam bayi mapatay manga nabi hi', bo' kaam iya maalti kubul sigam. ");
INSERT INTO slm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Hangkan na Tuhan, iya lōm asal tau na, bayi malman. Uk na, ‘Soho' ku pahi' ni bangsa Israil manga nabi maka manga aa kawakilan ku. Suga' kasehean iya soho' ku piyatay du uk sigam, bo' liyaat kasehean.’ ");
INSERT INTO slm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hangkan na,” uk si Isa, “kaam manga aa tahun itu hi', tikkahan du kabinsanaan ma sabab bayi dusa ka'mbo'-mboan bi mono' manga kanabi-nabihan sataggōl min tagna' dunya pipanjari. ");
INSERT INTO slm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Binsana' du kaam ma sabab kamatay manga nabi kamemon, tiyagnaan min si Habil anak si 'Mbo' Adam, sampay ni si Jakariya iya piyatay uk sigam ma ōtan tōngōd pagkulbanan maka baran langgal hi'. Aho', baan ta kaam manga aa ma waktu itu, pamatanggungan du kaam karusahan sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Makaase'-ase' tōōd iya pamakadal ma kaam, manga guru ma sara' agama. Sabab tambōlan bi manga aa bo' supaya sigam 'nsa' makalabay min daddōk tudju ni pangatau pasal Tuhan. Kaam iyu 'nsa' baya' palabay min daddōk ian bo' liyāng uk bi sasuku baya' palabay.” ");
INSERT INTO slm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagkallo' si Isa min luma' ian magtuwi manga Parisi maka manga guru ma sara' agama nagna' naway iya. Laat tōōd panaway sigam, maka heka isab pagtiyaw-tiyaw sigam ma iya ");
INSERT INTO slm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bo' supaya iya taabut mahalling kasaan, manjari katuntutan iya uk sigam ni sara'. ");
INSERT INTO slm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pasalta' ian hi', ibu-ibuhan manga aa magtipunan, magdigpit-digpit. Manjari missala si Isa ma manga mulid na dahu, uk na, “Halliin bi pasulig tinapay min manga Parisi, hati na hinang sigam maglaku-laku in sigam hap. ");
INSERT INTO slm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kamemon bayi kalimbuhan, tantu du piluwas. Maka kamemon bayi tatawu' ma diyōm atay tantu pitau du. ");
INSERT INTO slm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ayi-ayi bissala uk bi ma diyōm kalindōman kine du ni kasawahan. Ayi-ayi 'ssap-'ssap bi ma diyōm bilik pitanyag du ma manga aa ma mayiran.” ");
INSERT INTO slm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Baan ta kaam, manga bagay,” uk si Isa, “daa kaam tiyāw ma manga aa iya makapatay baran bi sabab 'nsa' taabut uk sigam palnyawahan bi. ");
INSERT INTO slm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Suga' panduan ta kaam bang sayi iya subay katāwan bi: katāwin bi Tuhan sabab 'nsa' baran bi sadja iya tapapatay na. Taga kapatut isab iya ngalarukan nyawa bi ni diyōm nalka'. Aho', iya iya subay katāwan bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Uk si Isa le', “Pikilun bi manga manuk-manuk diki' iyu. Taballi ta lima heka na maka duwa sin. Suga' minsan manuk-manuk diki' sali' 'nsa' niya' halga' na 'nsa' du takaipat uk Tuhan minsan dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na, luba'-luba' na kaam 'nsa' takaipat uk Tuhan. Minsan buun bi iyu taitung du uk na bang pila lamba heka na. Hangkan kaam daa subay tiyāw sabab halgaan le' kaam min baanan manga manuk-manuk diki' iyu.” ");
INSERT INTO slm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Baan ta kaam,” uk si Isa, “sayi-sayi ma'-ma' ma alōpan kahekahan aa in iya me' ma aku, Anak Manusiya', ma' du aku ma alōpan manga malaikat Tuhan in aa ian palsukuan ku du. ");
INSERT INTO slm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Suga' sayi-sayi mayilu ma alōpan kahekahan aa in aku 'nsa' pamean na, payiluhan ku isab aa ian ma alōpan manga malaikat Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Sayi-sayi mahalling laat ma aku, Anak Manusiya', makajari iya iyampunan dusa na suga' sayi-sayi mahallingan Nyawa Sutsi laat, 'nsa' tōōd iyampun dusa na hi'. ");
INSERT INTO slm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma sosongun, bang kaam siyaggaw uk aa bo' kaam biyo ni langgal sigam hiyukum atawa ni harapan manga gubnul maka manga parinta, daa kaam magsusa bang salaingga uk bi ngandaawahan di bi atawa bang ayi pamissala bi. ");
INSERT INTO slm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sabab piyanduan du kaam uk Nyawa Sutsi ma waktu ian hi' bang ayi subay pamissala bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Manjari niya' dangan min katipunan aa ian halling. Uk na ni si Isa, “Tuwan, sohoun kono' danakan ku mahagi' aku pusaka' bayi pangamban uk 'mma' kami hi'.” ");
INSERT INTO slm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Suga' uk si Isa ma iya, “Sehe', 'nsa' aku kabuwanan kapatut nara' kaam, maka 'nsa' niya' kapatut ku mahagi' alta' bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Siyugpatan isab halling na ma manga aa ian, uk na, “Kamaya'-maya' kaam. Halliin bi napsu kaginis-ginisan sabab minsan kaam dayahan makalandu', 'nsa' iya alta' bi heka iya makabuwanan kaam kallum kakkal.” ");
INSERT INTO slm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Puwas hi' niya' pamaralil uk si Isa ma manga aa ian. Uk na, “Niya' aa dayahan taga huma heka sadja buwa' na. ");
INSERT INTO slm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Manjari aa itu mikilan di na, uk na, ‘Ayi baha' subay hinang ku pagka 'nsa' niya' luma' sarang panawuan ku buwa' tiyanōm ku ma heka itu?’ ");
INSERT INTO slm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A, katauhan ku bang ayi subay hinang ku. Langkat ku manga bodega ku bo' hinang ku du bodega bahu, pasong mehe na min bayi tagna'. Jari tawu' ku ma hi' buwa' tiyanōm ku kamemon maka alta' ku kamemon. ");
INSERT INTO slm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Puwas hi' halling-hallingan aku di ku, uk ku, ‘Hap asal sukud ku. Heka na tatawu' ku paggastu ku sampay ma tahunan. Pahali-hali na aku. Mangan aku, nginum aku, maka pahap ku na palasahan ku.’ ");
INSERT INTO slm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Suga' missala Tuhan ma iya, uk na, ‘Dupang pahap kau! Ma sangōm iyu matay du kau. Ma sayi na baha' alta' bayi tawuan nu baran nu?’ ");
INSERT INTO slm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na,” uk si Isa, “salaihi' du iya kamaujuran aa bang mabud alta' pahap palasahan na, parahal miskin iya ma panganda' Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jari missala le' si Isa ma manga mulid na, uk na, “Hangkan kaam soho' ku daa magsusa pasal kalluman bi bang ayi kiyakan bi, atawa pasal ginhawa-baran bi bang ayi kapanammek bi. ");
INSERT INTO slm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sabab labi halga' kallum ta min kapamangan ta, maka halga' le' baran ta min panammek ta. ");
INSERT INTO slm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'Ndaun bi manga owak hi'. 'Nsa' magtanōm, 'nsa' mag-ani, maka 'nsa' niya' pagtawuan sigam kiyakan, suga' biyalanjaan asal sigam uk Tuhan. Bo' kaam iyu, halgaan le' tōōd min kamanuk-manukan. ");
INSERT INTO slm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sayi baha' makapataha' umul na manga danjam sadja minsan salaingga uk na magmasusa? ");
INSERT INTO slm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Manjari bang 'nsa' tapataha' bi umul bi minsan datti', angay pagsusahan bi iya kagunahan bi kasehean hi'? ");
INSERT INTO slm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Ndaun bi manga sumping bang salaingga katomo' na. 'Nsa' magsangsa' maghinang, 'nsa' maghinang kakana'. Suga' baan ta kaam, minsan si Sultan Sulayman maka kaalti na ma masa awwal hi' 'nsa' du makaatu hap sammek na ma dakayo' sumping itu. ");
INSERT INTO slm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bang Tuhan iya makapayakun sumping kasōmpōtan itu, iya tatasan na dangallaw du, pagsawung tiyutung du, iya le' na kaam pasammekan na du. Kulang pahap pangandōl bi ma iya! ");
INSERT INTO slm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Hangkan kaam 'nsa' soho' ku magsusa, daa kaam magpikil na peen bang ayi kiyakan bi atawa inum bi. ");
INSERT INTO slm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Manga aa 'nsa' tau magtaat ma Tuhan, iya na hi' kisusahan na peen uk sigam. Suga' kaam iyu, kitauhan uk 'Mma' bi Tuhan in ian kagunahan bi asal. ");
INSERT INTO slm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Suga' dahu-dahu kannalun bi pagparinta Tuhan, manjari piniyaan du kaam ayi-ayi kulang-kabus bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaam manga mulid ku,” uk si Isa, “daa kaam tiyāw minsan kaam 'nsa' heka. Sabab kiyōgan 'Mma' bi Tuhan muwanan kaam palsukuan ma diyōm pagparintahan na. ");
INSERT INTO slm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Paballihin bi alta' bi bo' panarakkahun bi ballihan na ma manga aa miskin. Bang hinang bi itu hi' sali' kaam dalil nawu' alta' bi ma diyōm pitaka 'nsa' magkaraan. Hati na, niya' karaya bi ma diyōm sulga', karaya 'nsa' pakulang. Bang ganta' may'an karaya bi 'nsa' taabut uk aa panangkaw maka 'nsa' niya' bobok makaat iya. ");
INSERT INTO slm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sabab hati na, maingga-maingga iya panawuan bi alta' bi ma hi' iya pataptapan pangatayan bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Missala le' si Isa, uk na, “Subay kaam patanam ma ayi-ayi patakka, sali' manga sosohoan ngagaran nakura' sigam bang mowe' min pagkawinan. Magsammek sigam maka 'nsa' padda palitaan sigam. Pagtakka nakura' sigam bo' pagkuku na ma lawang, magtuwi iya iyukaban uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mehe kahapan manga sosohoan ian pagka masi sigam magjaga maka sakap asal ma pagtakka nakura' sigam. Baan ta kaam tōōd,” uk si Isa, “nakura' ian ngamōmōsan di na du bo' pitingko' uk na manga sosohoan hi' bo' iyampa sigam bohatan na. ");
INSERT INTO slm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Minsan tōnga' bahangi atawa dayi' 'llaw iya katakka na, bang taabut na manga sosohoan na asal jaga, tantu mehe kahapan sigam. ");
INSERT INTO slm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sawupama aa dapu luma', bang katauhan na bang umay niya' aa panangkaw takka, tantu 'nsa' pisaran uk na luma' na liyangkat maka siyōd. ");
INSERT INTO slm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Damikkiyan na isab kaam, subay kaam sakap sadja sabab aku, Anak Manusiya', takka paitu pabing du ma waktu 'nsa' katauhan bi.” ");
INSERT INTO slm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Manjari tiyaw si Petros, uk na, “Tuwan, sayi bissalahan nu iya hangkan kau maralil salaiyu? Kami sadja atawa aa kamemon?” ");
INSERT INTO slm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nambung si Isa magparalil pabing. “Bang niya' sosohoan hap akkal na, aa kapangandōlan,” uk na, “iya na ian pene' uk nakura' na nganjaga ma manga sosohoan kasehean. Iya na isab mag-atas-pikil ma balanja' sigam. ");
INSERT INTO slm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na, bang bayi likut nakura' na ian bo' mowe' na, mehe kahapan ma nganjaga ian bang iya taabut uk nakura' na nōgōl ma bayi pamahinang ma iya. ");
INSERT INTO slm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Baan ta kaam, tantu pingandōl uk nakura' ian alta' na kamemon ma sosohoan kapangandōlan hi'. ");
INSERT INTO slm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Suga' iya nganjaga ian, bang sawupama pangannal na ma diyōm atay na in nakura' na taggōl le' takka, jari nagna' iya ngalaugan manga sosohoan kasehean lalla maka danda. Iya hinang na magkakan maka mag-inum maka maglangohan. ");
INSERT INTO slm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sakali saruun-duun sadja iya takka nakura' ian, ma 'llaw 'nsa' iyagaran uk aa nganjaga maka ma waktu 'nsa' katauhan na. Manjari liyagut iya uk nakura' na sampay bugtang na. Pikaralan iya nalka' sali'-sali' maka manga aa 'nsa' magkahagad ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Bang sosohoan tau bang ayi kabayaan nakura' na subay hinang na, bo' 'nsa' iya magsakap atawa maghinang, liyapdōsan du iya tōōd. ");
INSERT INTO slm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Suga' bang sosohoan awam pasal kabayaan nakura' na, bo' niya' tahinang na patut paminsanaan iya, liyapdōsan du isab iya suga' 'nsa' bohat tōōd. Sayi-sayi kabuwanan heka, heka isab hiyōwat ma iya. Damikkiyan na bang heka le' iya pingandōl ma iya, pasong le' heka hiyōwat ma iya.” ");
INSERT INTO slm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Uk si Isa le', “Bayi aku paitu mo api ni dunya itu bo' kabayaan ku bang iya hi' na dōkōt. ");
INSERT INTO slm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Niya' kabinsanaan subay kalabayan ku bo' kabohatan aku sataggōl 'nsa' le' ubus. ");
INSERT INTO slm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Marayi' pangannal bi in aku paitu mo kasannangan ni dunya. Suga' baan ta kaam, 'nsa' kasannangan iya tabo ku. Palsaggaan iya bo ku paitu. ");
INSERT INTO slm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sabab na puwas minnitu bang niya' lima puhu' magdakayo' luma', magsagga' du sigam. Jari tallungan sigam nagga' duwangan, maka duwangan ian ngatu ma tallungan. ");
INSERT INTO slm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Mma' nagga' anak na lalla du, maka lalla nagga' 'mma' na. Ina' nagga' anak na danda du, maka danda nagga' ina' na. Matoa danda nagga' ayuhan na danda, maka ayuhan danda nagga' matoa na danda.” ");
INSERT INTO slm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Halling isab si Isa ni kahekahan aa ian. “Bang takdil ni dagbōs lahat,” uk na, “bang tanda' bi pandōm langit tampal ni saddōpan, magtuwi uk bi, ‘Song ulan’. Maka ngulan du isab. ");
INSERT INTO slm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bang patumbuk baliyu satan, uk bi, ‘A, song pasu' lahat,’ bo' pasu' du. ");
INSERT INTO slm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","In kaam iyu magbawu'-bawu' pahap. Tau kaam nganda' pamandōgahan ma diyata' langit maka ma dunya. Angay 'nsa' tapandōga bi pakaradjaan iya patakka ma masa itu hi'?” ");
INSERT INTO slm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Angay kaam 'nsa' tau magpikilan di bi bang ingga iya patut subay hinang bi? ");
INSERT INTO slm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bang kau tiyuntutan uk aa ma sabab utang nu bo' biyo kau uk na ni sara', nuyu' kau tōōd samantala' kaam ma labayan le' bo' supaya tabo nu aa ian magsulut ma 'nsa' le' kaam takka ni sara'. Sabab piligdu bang kau 'nsa' magsulut dahu. Biyo du kau ni huwis bo' siyongan du kau uk huwis ni pulis bo' iyampa kau liyōōn ni diyōm jil. ");
INSERT INTO slm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Baan ta kau, kataggōlan du kau ma diyōm jil ian. Subay puwasan nu bayi kataksilan nu kamemon bo' iyampa kau makaluwas minnihi'.” ");
INSERT INTO slm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, ma waktu ian hi' niya' manga aa ngahabal ni si Isa pasal manga aa Jalil, iya bayi siyoho' biyono' uk si Gubnul Pilatu pasalta' ma waktu kapanumbay sigam hayōp pagkulban sigam ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nambung si Isa ma sigam, uk na, “Pangannal bi baha' manga aa ian taga dusa labi le' min aa kamemon ma itu ma lahat Jalil, iya hangkan sigam takkahan bala' salaihi'? ");
INSERT INTO slm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Nsa' du! Suga' baan ta kaam, bang kaam iyu 'nsa' ngalabba min dusa bi, iya du kaam matay sali' manga aa Jalil hi'. ");
INSERT INTO slm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Manga aa isab sangpu' maka walu' heka na, iya bayi matay ma hi' ma Silowam pagka sigam kahabbahan uk luma' pamantawan, pangannal bi baha' in sigam ian labi laat min aa kasehean maglahat ma Awrusalam? ");
INSERT INTO slm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Nsa' du! Suga' baan ta kaam, bang kaam iyu 'nsa' ngalabba tōōd min dusa bi, iya du kaam matay sali' sigam.” ");
INSERT INTO slm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Manjari niya' kissa paralilan bissala uk si Isa ma sigam. Uk na, “Niya' aa taga kayu igira patomo' ma diyōm kabbun na, iya panomoan bahan anggul. Pay'an iya meha buwa' igira suga' 'nsa' niya' tapeha na, ");
INSERT INTO slm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","hangkan uk na ni tunggu' kabbun, ‘'Ndaun: tallun tahun na pagpaitu-paitu ku ni kayu igira itu meha buwa' na suga' 'nsa' niya' tapeha ku. Tabbōngun na, bo' 'nsa' lōpas tana' itu.’ ");
INSERT INTO slm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Suga' niya' sambung tunggu' kabbun hi', uk na, ‘Daa, Tuwan. Pasaran ta le' dantahun. Tappōkan ku le' pahap tana' na. Tambalan ku maka tayi' hayōp. ");
INSERT INTO slm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bang hati muwan buwa' ma musim siyong itu, hap du. Bang 'nsa', na minsan na kita, tabbōngun ma aku.’ ” ");
INSERT INTO slm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma 'llaw dakayo', ian si Isa mandu' ma diyōm langgal manga Yahudi bo' 'llaw Sabtu' na, 'llaw sigam paghali ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Niya' may'an dakayo' danda saki sabab min sayitan, sangpu' na maka walun tahun taggōl na. Buggut kalandu' bukut na, 'nsa' tapahannat. ");
INSERT INTO slm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pag'nda' si Isa ma danda itu siyoho' iya pasikōt. Halling si Isa ma iya, “Danda, puwas na kau min saki nu iyu.” ");
INSERT INTO slm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jari piabut uk si Isa tangan na ma iya. Magtuwi iya pahannat bo' nanglit iya ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Suga' nakura' langgal ian, pasu' atay na pagka si Isa makowe' aa ma 'llaw Sabtu'. Halling na ma manga aa may'an, “'Nnōm 'llaw du ma diyōm dapitu' wajib paghinang kitabi ayi-ayi. Paitu kaam ma diyōm 'nnōm 'llaw ian bang kaam baya' kaulian saki bi, daa bang 'llaw Sabtu'.” ");
INSERT INTO slm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Siyambungan nakura' ian uk si Isa, uk na, “Magbawu'-bawu' pahap kaam iyu in kaam 'nsa' langgal sara'. Niya' baha' ma kaam 'nsa' ngahubaran sapi' na atawa kura' na bo' iyampa guyud bi paluwas supaya piinum uk bi, minsan sabu ma 'llaw Sabtu'? ");
INSERT INTO slm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Danda itu panubu' si Ibrahim du sali' kaam. Niya' na sangpu' maka walun tahun taggōl na bayi katahanan uk nakura' sayitan. 'Nsa' iya wajib baha' piyuwasan min susa na ma 'llaw Sabtu'?” ");
INSERT INTO slm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Magtuwi magkaiyaan manga aa nagga' si Isa hi' ma sabab panambung na. Suga' manga aa ian kamemon kiyōgan tōōd ma sabab hinang makainu-inu kamemon iya tahinang uk na. ");
INSERT INTO slm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Missala le' si Isa, uk na, “Ayi pamasalian kitabi pagparinta Tuhan ma bangsa manusiya'? Ayi pamaralilan ku iya? ");
INSERT INTO slm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iya pagparinta Tuhan,” uk si Isa, “sali' dalil dakayo' bigi diki'-diki', tiyanōm uk aa ma tana' na. Tomo' peen itu manjari kayu na, bo' pay'an manga manuk-manuk ngahinang pugaran ma senga na.” ");
INSERT INTO slm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Halling si Isa pabing, uk na, “Ayi pamaralilan ku pagparinta Tuhan ma manusiya'? ");
INSERT INTO slm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iya pagparinta Tuhan,” uk na, “sali' dalil pasulig giyuna uk danda pilamud ni tirigu heka, manga duwampu' maka lima kilu. Puwas hi' iyaddun uk na, pagsa' taggōl pasulig na kamemon.” ");
INSERT INTO slm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jari palanjal si Isa tudju ni daira Awrusalam sasang na ngalatag manga kalumaan mehe-diki' magpandu' ma manga aa. ");
INSERT INTO slm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Niya' ian dakayo' aa tiyaw iya, uk na, “Tuwan, kulang du baha' manga aa lappasan uk Tuhan min mulka'?” Uk sambung si Isa ma manga aa ian, ");
INSERT INTO slm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bang kaam baya' pasōd ni diyōman Tuhan subay kaam magtuyu' bo' kaam pasōd min lawang na kiput. Sabab baan ta kaam, heka aa nulay pasōd suga' 'nsa' makasōd. ");
INSERT INTO slm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Papunduk du aa dapu luma' mahōgōt tambōl lawang. Jari ma luwasan sadja kaam nguku' ma lawang sampay ngalingan. Uk bi, ‘O Tuwan, ukabin kami.’ Siyambungan du kaam uk na, ‘'Nsa' katauhan ku kaam bang minningga!’ ");
INSERT INTO slm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jari uk bi, ‘'Nsa' kami taintōm nu? Bayi kami dakakanan maka kau. Bayi kau mandu' ma lahat kami.’ ");
INSERT INTO slm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Suga' bayikan na du bayi halling na ma kaam. Uk na, ‘'Nsa' kaam katauhan ku bang minningga kaam. Pakallo' kaam min aku, kaam kamemon maghinang kalaatan!’ ");
INSERT INTO slm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Manjari magkarukkaan du kaam, magtagiōt isab baggaang bi ma waktu ian bang tanda' bi ka'mbo'-mboan bi di si Ibrahim, si Isahak maka si Ya'kub, sampay manga kanabi-nabihan kamemon hi' bayi pisōd ni diyōm pagparintahan Tuhan. Bo' kaam iya liyarukan paluwas. ");
INSERT INTO slm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Patipun du isab pay'an manga aa min 'mpat pidju alam bo' magtingkoan sigam may'an bo' magjamu ma diyōm pagparintahan Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","'Ndaun bi, niya' manga aa taramuwi ma buttihi', pirahu du ma sosongun. Maka niya' manga aa makarahu ma buttihi', piramuwi du ma waktu siyong.” ");
INSERT INTO slm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Manjari itu ma waktu ian, niya' pay'an ni si Isa manga aa Parisi. Uk sigam ni iya, “Subay kau pakallo' minnitu sabab si Sultan Herod ian baya' mapatay kau.” ");
INSERT INTO slm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nambung si Isa, uk na, “Pahi' kaam maan si Herod pangangakkal ian bang ayi hinang ku. 'Llaw itu maka sawung lanjalan ku hinang ku magpakallo' sayitan min baran aa, sampay makowe' manga saki. Bo' ma 'llaw katallu na tangbus uk ku hinang ku. ");
INSERT INTO slm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Suga' subay aku palanjal ni palangnganan ku 'llaw itu maka sawung sampay isab ni sawung dambuwa'. 'Nsa' du niya' laat makani-aku ma itu sabab Awrusalam iya lahat pamapatayan kahekahan manga nabi.” ");
INSERT INTO slm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sakali magkarukkaan si Isa ma pasal manga aa ma daira Awrusalam. “'Ndu'!”, uk na. “Kaam manga aa Awrusalam, makasusa ko' kaam iyu! Manga nabi min Tuhan piyatay uk bi sadja. Manga sosohoan Tuhan isab hiyak uk bi sadja maka batu bang sigam pipaiyu uk na ni kaam. Min pila aku bayi baya' nipun kaam ma bihing ku? Sali' sapantun manuk danda bang nipun na anak-anak na ma deyo' pikpik na. Suga' 'nsa' kaam baya'. ");
INSERT INTO slm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","'Ndaun bi na: libbahan langgal bi uk Tuhan. Maka baan ta kaam, 'nsa' na aku song tanda' bi sataggōl 'nsa' taabut waktu pananglit bi aku. Subay uk bi, ‘Bang peen biyarakatan iya pipaitu kawakilan uk Tuhan,’ bo' iyampa aku tanda' bi.” ");
INSERT INTO slm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ma dakayo' Sabtu', 'llaw paghali ni Tuhan, pay'an si Isa mangan ma luma' dakayo' nakura' manga Parisi. Jari may'an peen iya, piyatong iya uk manga aa asal may'an. ");
INSERT INTO slm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Niya' isab ma tōngōd na ian aa taga saki, maha' nayi'-tangan na. ");
INSERT INTO slm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tiyaw si Isa ni manga guru ma sara' agama ian maka ni manga Parisi, uk na, “Bang kita sawupama magpakowe' saki aa ma 'llaw Sabtu', langgal sara' agama tabi baha', atawa 'nsa'?” ");
INSERT INTO slm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Suga' 'nsa' sigam nambung. Jari intanan uk si Isa aa saki ian bo' pikowe' iya uk na bo' iyampa pipowe' uk na. ");
INSERT INTO slm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Puwas hi' tiyaw si Isa ma manga aa ian, uk na, “Bang sawupama niya' anak bi atawa sapi' bi hug ni diyōm lowang ma 'llaw paghali, ayi hinang bi? Tantu killo' uk bi piluwas min diyōm lowang hi' minsan 'llaw paghali le'.” ");
INSERT INTO slm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Suga' 'nsa' na sigam makajawab. ");
INSERT INTO slm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tapandōga uk si Isa iya bohan manga aa maglurukan pay'an. Mene' sigam magtuwi paningkoan hap, iya tiyōp ma aa langkaw bangsa na. Hangkan iya magparalilan ma sigam, uk na, ");
INSERT INTO slm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bang kaam ganta' killo' paluruk ni pagkawinan, daa kaam ningko' magtuwi ma kokan, ma paningkoan hap. Kalu niya' aa langkaw bangsa na le' min kaam bayi siyoho' paluruk. ");
INSERT INTO slm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jari paiyu ni kaam aa dapu hinangan, iya bayi ngallo' kaam duwangan paluruk pahi', bo' halling na du, ‘Papinda kaam minniyu bo' patingkoun le' aa itu hi'.’ Jari iya' du kaam bo' papinda kaam ningko' ma nayian. ");
INSERT INTO slm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Suga' bang kaam siyoho' paluruk, ningko' kaam magtuwi ma nayian. Jari paiyu du ni kaam aa dapu hinangan bo' uk na ni kaam, ‘Bagay, papinda kau ni kokan, ni paningkoan labi hap.’ Manjari tanda' kaam uk manga luruk ian kamemon, in kaam pig-addatan. ");
INSERT INTO slm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sabab hati na sayi-sayi magpalangkaw di na pireyo' du. Maka sayi-sayi magpareyo' di na pilangkaw du.” ");
INSERT INTO slm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Manjari halling si Isa ni aa bayi noho' iya mangan ma luma' na, uk na, “Na, kau isab, bagay: bang kau ngahinang pagjamuhan, daa sohoun paluruk manga bagay nu atawa manga danakan nu atawa kaheka nu atawa lung-kampung nu dayahan. Sabab bang sigam iya soho' nu paluruk, iya du kau siyoho' paluruk uk sigam ma waktu dakayo'. Jari katungbasan kau magtuwi. ");
INSERT INTO slm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Suga' bang kau ganta' ngahinang pagjamuhan, iya soho' nu paluruk subay manga aa miskin maka aa pengka', maka aa buta. ");
INSERT INTO slm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bang itu hinang nu, mehe du kahapan nu sabab 'nsa' niya' ayi-ayi sigam panungbas sigam ma kau. Tuhan iya nungbasan kau ma 'llaw damuwi, ma waktu pamakallum manga aa bōntōl pabayik.” ");
INSERT INTO slm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Take peen bissala si Isa itu uk aa dangan mangan may'an, magtuwi halling aa ian, uk na, “Bang aa magkakan ma jamuhan ma diyōm pagparintahan Tuhan, mehe asal kahapan sigam.” ");
INSERT INTO slm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Manjari halling si Isa dakayo' kissa pamaralilan, uk na, “Niya' aa bayi magsakap ma jamuhan mehe, bo' heka aa bayi killo' uk na paluruk. ");
INSERT INTO slm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Taabut peen 'llaw pagjamu, siyoho' uk na sosohoan na pahi' magpahati ma manga aa iya bayi killo'. ‘Dayi' na kaam,’ uk sosohoan hi'. ‘Sakap na kamemon.’ ");
INSERT INTO slm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Suga' sali'-sali' sigam kamemon magdaawa ma iya. Uk aa iya papahian na tagna', ‘'Nsa' aku makaluruk sabab niya' tana' bayi balli ku bo' subay 'nda' ku dahu. Ampunun le' aku.’ ");
INSERT INTO slm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Halling aa dakayo', ‘Bayi na aku makaballi manga sapi' pag-araruhan, sangpu' heka na, bo' subay sulayan ku le' kōsōg sigam. Ampunun le' aku.’ ");
INSERT INTO slm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Halling isab aa dangan, ‘Bahu aku bayi kiyawin, hangkan aku 'nsa' makaluruk.’ ");
INSERT INTO slm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Manjari mowe' sosohoan ian ma'-ma' manga daawa sigam ni nakura' na. Paddi' tōōd atay nakura' hi', bo' uk na ma sosohoan na, ‘Pasaut kau pahi' ni manga kalsada maka ni paglalabayan aa ma diyōm lahat itu. Bohun paitu manga aa miskin, manga aa tongka' manga aa buta, maka manga aa pengka'.’ ");
INSERT INTO slm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagsong-song peen, takka pabing sosohoan hi' bo' uk na ni nakura' na, ‘Tahinang ku na iya bayi panohoan nu hi' suga' niya' le' masi paningkoan ma pagjamuhan.’ ");
INSERT INTO slm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Uk nakura', ‘Pahi' kau ni paglalabayan aa ma de, ni karaddōk-daddōkan tudju pariyōm, bo' lōgōsun manga aa paitu bo' supaya panno' luma' ku. ");
INSERT INTO slm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sabab baan ta kaam,’ uk na, ‘in aa bayi killo' uk ku dahu, 'nsa' niya' min sigam makananam kiyakan bayi sakap ku.’ ” ");
INSERT INTO slm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Palanjal isab si Isa ni palangnganan na maka landu' heka aa me' parōngan ma iya. Manjari paharap iya nganda' ma sigam bo' uk na, ");
INSERT INTO slm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bang niya' aa baya' me' ma aku hinang mulid ku, iya lasa na ma aku subay palabi min lasa na ma ina'-mma' na maka ma anak-handa na, sampay ma manga danakan na lalla-danda. Minsan lasa na ma baran na subay 'nsa' palabi min lasa na ma aku. Bang 'nsa' salaihi' lasa na, 'nsa' iya manjari mulid ku. ");
INSERT INTO slm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Subay iya paglilla' na kabinsanaan na sampay ni kamatay ma sabab pame' na ma aku. Iya dalil na sali' aa nanggung hag na pamapatayan iya. Bang 'nsa', 'nsa' iya manjari mulid ku. ");
INSERT INTO slm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bang sawupama niya' ma kaam baya' ngahinang luma' pamantawan, subay iya ningko' dahu mista bang pila gastu na bo' katauhan na bang makaabut baha' sin na pangahinang luma' ian atawa 'nsa'. ");
INSERT INTO slm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sabab patangge peen hag, bo' 'nsa' makaabut sin na pangubus na luma', pig-udjuan iya uk aa kamemon nganda' pay'an. ");
INSERT INTO slm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Uk sigam, ‘Aa itu bayi makalandu' ngahinang luma' suga' 'nsa' taubus na.’ ");
INSERT INTO slm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Atawa bang sawupama niya' sultan sangpu' ngibu sundalu na, song palanjal magbono' maka sultan saddi, ningko' du iya dahu mikil-mikil bang taraōg na baha' sultan dakayo' ian, pagka duwampu' ngibu sundalu na hi'. ");
INSERT INTO slm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bang hati 'nsa' taraōg na, magtuwi iya mabo suluhan pasampang ni sultan dakayo' ian ma masi le' iya ni katāhan, bo' ngamu' iya magkahap. ");
INSERT INTO slm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Damikkiyan na isab kaam,” uk si Isa, “subay kaam mikil-mikil dahu sabab 'nsa' kaam manjari mulid ku bang kaam 'nsa' maglilla' ngalabbahan ayi-ayi bi kamemon.” ");
INSERT INTO slm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Magparalilan na isab si Isa, uk na, “Katauhan bi, hap asal asin suga' bang kallo' na kaasin na, 'nsa' niya' dapat na pamabayik kaasin na. ");
INSERT INTO slm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Manjari 'nsa' na niya' kagunahan na. 'Nsa' minsan giyuna panambal tana' atawa pangalamud ni tayi' hayōp. Hal timanan sadja. Na,” uk si Isa, “sasuku kaam makake, asipun bi tōōd.” ");
INSERT INTO slm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma dakayo' 'llaw heka manga aa magkallo' sukay parinta, maka manga aa baldusa kasehean, ian patipun ni si Isa sabab baya' pake ma pandu' na. ");
INSERT INTO slm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Manjari manga Parisi maka manga guru sara' agama magdugal na. Uk sigam, “Aa itu nayima' manga aa baldusa. Magsawu isab iya maka sigam!” ");
INSERT INTO slm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hangkan missala si Isa kissa pamaralilan itu, uk na, ");
INSERT INTO slm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bang sawupama niya' sali' kaam taga hayōp bili-bili dahatus heka na, bo' hi' lungay dakayo', ayi baha' hinang na? Tantu pasaran na siyampu' maka siyam may'an ma de bo' iyampa pahi' meha dakayo' bayi lungay sataggōl 'nsa' tatawwa' na. ");
INSERT INTO slm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pagtatawwa' na, tiyanggung uk na tudju mowe' maka uk na kiyōgan tōōd. ");
INSERT INTO slm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tapowe' peen, magtuwi linganan uk na manga bagay na maka kakampungan na. Soho' na du sigam magtipun bo' halling na ma sigam, ‘Maglami-lami na kitabi sabab tatawwa' ku na bili-bili ku bayi lungay.’ ");
INSERT INTO slm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Baan ta kaam,” uk si Isa, “damikkiyan na bang niya' dakayo' aa bayi dusahan magsusun sampay ngalabba min dusa na. Mehe kakōgan ma diyōm sulga' ma sabab aa dangan ian. Palabi le' min kakōgan ma sabab aa siyampu' maka siyam heka na, iya kibā' bōntōl maka 'nsa' kono' niya' dusa sigam subay labbahan.” ");
INSERT INTO slm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sawupama isab,” uk si Isa, “bang niya' danda taga dublun sangpu' heka na, bo' lungay dakayo', ayi baha' hinang na? Tantu iya ngandōkōt palitaan magtuwi bo' sapuhan na diyōm luma' bo' peha na pahap-hap sampay tatawwa' na. ");
INSERT INTO slm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jari pagtatawwa' na, linganan uk na bagay na maka kakampungan na. Siyoho' sigam magtipun bo' halling na ma sigam, ‘Maglami-lami na kitabi sabab tatawwa' ku na dublun ku bayi lungay.’ ");
INSERT INTO slm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Baan ta kaam,” uk si Isa, “damikkiyan na isab, mehe kakōgan ma manga malaikat sosohoan Tuhan bang niya' dakayo' aa dusahan magsusun sampay ngalabba min dusa na.” ");
INSERT INTO slm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Missala le' si Isa, uk na, “Niya' ian dakayo' aa taga anak lalla duwangan. ");
INSERT INTO slm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dakayo' 'llaw halling anak siyay ni 'mma' na, ‘'Mma', bahagiun na alta' nu bo' pamuwanun ma aku bahagi' ku.’ Jari pigbahagi uk aa ian ayi-ayi na ma anak na duwangan. ");
INSERT INTO slm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Nsa' taggōl, piballihan uk siyay itu bahagi' na bo' biyo uk na sin na tudju ni lahat tā. Mahi' peen iya, pikaat uk na sin na kamemon ma ayi-ayi kanapsuhan na. ");
INSERT INTO slm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sakali itu, pag-ubus na sin na kamemon, gōtōm kalandu' lahat ian. Manjari mehe na kasukkalan na. ");
INSERT INTO slm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hangkan iya pahi' ni dakayo' aa ma lahat ian bo' paipat ma iya. Jari siyoho' iya uk aa ian pahi' ni huma na ngipat manga koret. ");
INSERT INTO slm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na, pagka 'nsa' manjari giyōtas na, baya' iya mangan minsan kiyakan koret suga' 'nsa' niya' bayi muwanan iya minsan ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lipara tasayu na karupangan na hangkan halling na ma diyōm atay na, ‘Manga sosohoan 'mma' ku hi' maglabi-labi kiyakan sigam, suga' aku itu tiya' na song matay uk gōtas. ");
INSERT INTO slm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gam na aku mowe' pahi' ni si 'Mma'. Uk ku ma iya, “'Mma', taga dusa aku ni Tuhan sampay ni kau.” ");
INSERT INTO slm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Nsa' na aku manjari ōnan nu anak. Bistahun aku sali' dakayo' tindōg nu sadja.’ ” ");
INSERT INTO slm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jari nangge iya bo' iya mangngan tudju ni 'mma' na pabing. “Suga' lawak le' iya min luma', tanda' na iya uk 'mma' na. Maase' tōōd 'mma' na bo' paragan pahi' bo' iya kikkōpan uk na maka siyum uk na anak na. ");
INSERT INTO slm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Halling anak na ian ma iya, ‘'Mma', taga dusa aku ni Tuhan sampay ni kau. 'Nsa' na aku manjari ōnan nu anak.’ ");
INSERT INTO slm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Suga' linganan uk 'mma' na ian manga sosohoan na, bo' halling na ma sigam, ‘Palakkas kaam. Bohun bi paitu badju' hap tōōd bo' pabadjuin bi iya itu. Pasingsingin bi isab maka patawumpain bi. ");
INSERT INTO slm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Puwas hi' pahi' kaam ngallo' anak sapi' iya bayi palammōk ta hi', bo' sumbayun bi. Magjamu kitabi, manga maglami-lami. ");
INSERT INTO slm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sabab anak ku itu bayi niyat ku matay suga' tiya' na 'llum pabing. Pangannal ku lungay suga' tapowe' du.’ Manjari nagna' sigam maglami-lami. ");
INSERT INTO slm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, pasalta' peen itu hi', ian anak siyaka hi' mag-usaha ma huma. Ma labayan peen iya tudju mowe', bo' sikōt na ni luma', niya' take na magkulintangan maka magpangiluk ma diyōm luma' sigam. ");
INSERT INTO slm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Linganan uk na dakayo' sosohoan bo' tiyaw na bang magay hi'. ");
INSERT INTO slm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Halling ipatan, ‘Tapowe' na siyay nu, maka siyoho' uk 'mma' nu siyumbay anak sapi' iya pilammōk ian, sabab takka na anak na ma 'nsa' du iya bayi angay-angay.’ ");
INSERT INTO slm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Suga' anak na siyaka hi' paddi' atay na, iya hangkan 'nsa' baya' pasōd ni diyōm luma'. Paluwas 'mma' na ngamu' iya pasōd suga' 'nsa' iya baya'. ");
INSERT INTO slm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Halling na ni 'mma' na, ‘'Ndaun, 'Mma', ma tahunan na aku maghinang ma kau sali' manga banyaga' nu. 'Nsa' niya' panohoan nu bayi sagga' ku minsan dakayo'. Suga' 'nsa' aku bayi buwanan nu minsan dakayo' anak kambing supaya aku makapagjamu maka manga bagay ku. ");
INSERT INTO slm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Suga' makapowe' paitu anak nu iyu, magtuwi sumbayan nu iya anak sapi' pilammōk hi', minsan bayi pakaat na alta' nu pamalli na danda maghinang laat.’ ");
INSERT INTO slm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nambung 'mma' na, ‘Oto', kakkal du kau ma aku, maka suku' nu asal alta' ku itu kamemon. ");
INSERT INTO slm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Patut du bang kita maglami-lami maka magpajamu sabab 'llum du siyay nu iya bayi niyat ta matay hi'. Pangannal ta lungay suga' tapowe' na iya.’ ” ");
INSERT INTO slm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Manjari itu missala le' si Isa ma manga mulid na, uk na, “Niya' dakayo' aa dayahan, maka niya' isab dakayo' sosohoan na pibōtang uk na nungguan alta' na. Manjari tasumbung tindōg ian ni nakura', in iya kono' makaat alta' na sadja. ");
INSERT INTO slm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hangkan du linganan tindōg ian uk nakura', siyoho' patampal ni iya. Halling nakura' ni iya, ‘Ayi baha' take ku itu ma pasal kau? Bistahun kamemon bayi pangandōl ku ma kau. Songin ni aku bang pila. Sabab 'nsa' na kau nungguan aku.’ ");
INSERT INTO slm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mikil-mikilan di na tindōg ian, uk na, ‘Ayi tahinang ku buttihi' sabab tiya' na aku pikallo' uk nakura' ku min bayi hinang ku. 'Nsa' na aku makakowe' magkalga, maka iya' aku ngamu' sin. ");
INSERT INTO slm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, katauhan ku na,’ uk na, ‘bang ayi subay hinang ku. Jari bang aku pikallo' na min hinang ku niya' du manga bagay ku ngōkōman aku.’ ");
INSERT INTO slm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Manjari linganan uk na manga aa taga utang ma nakura' na, dangan sigam maka dangan. Uk na ni aa dahu pay'an ni iya, ‘Pila utang nu ma nakura' ku?’ ");
INSERT INTO slm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iya sambung na, ‘Dahatus mital 'nsallan.’ Halling tindōg ma iya, ‘A, tiya' katas nu. Pasaut kau ningko' bo' sulatun limampu' mital sadja.’ ");
INSERT INTO slm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Uk na isab ni aa taga utang pasunu', ‘Kau, pila utang nu?’ Uk na hi', ‘Dahatus karut buwas.’ Halling tindōg hi' ma iya, ‘Tiya' katas nu. Sulatun maiyu walumpu' karut sadja.’ ");
INSERT INTO slm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na, makake peen nakura' pasal hinang sosohoan na mangakkal ian, magtuwi siyanglitan uk na ma sabab taha' akkal na.” Uk si Isa isab, “Manga aa 'nsa' me' ma Tuhan itu, taha' le' akkal sigam min manga aa iya me' ma Tuhan, sabab tau nguntungan pagkahi sigam. ");
INSERT INTO slm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hangkan pituwahan ta kaam,” uk si Isa, “paggunahun bi alta' bi ma itu ma dunya paghinang kahapan ma baran bi. Manjari bang taabut waktu kansa' niya' alta' bi, tayima' du kaam ma hi' ma paglahatan bi kakkal. ");
INSERT INTO slm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bang aa kapangandōlan ma alta' diki', kapangandōlan du isab iya ma alta' mehe. Damikkiyan na isab bang aa 'nsa' kapangandōlan ma alta' diki', 'nsa' isab kapangandōlan ma alta' mehe. ");
INSERT INTO slm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, bang kaam pisukuan alta' ma itu ma dunya itu hi', bo' 'nsa' kaam kapangandōlan, 'nsa' du pingandōl ma kaam alta' bannal. ");
INSERT INTO slm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Maka bang kaam 'nsa' kapangandōlan ngantan alta' 'nsa' suku' bi, 'nsa' du pingandōl ma kaam alta' iya di palsukuan bi. ");
INSERT INTO slm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“'Nsa' niya' aa makapabanyaga' ma duwa nakura' sabab tantu kibansihan uk na nakura' dakayo' maka kilasahan uk na dakayo'. Lut iya ma dakayo' bo' tayikutan na dakayo'. Hati na 'nsa' kaam manjari maghinang ma Tuhan bang pilak iya pamehe bi ma atay.” ");
INSERT INTO slm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Take peen pandu' si Isa itu uk manga Parisi, magtuwi iya tittohan uk sigam sabab napsuhan sigam ma pilak. ");
INSERT INTO slm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Suga' halling si Isa ni sigam, uk na, “Kaam iyu magbōntōl-bōntōl di bi sadja ma panganda' aa, suga' kitauhan asal diyōm atay bi uk Tuhan. Iya pihalga' ma atay uk manusiya', 'nsa' du niya' kagunahan na bang ma Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Uk na isab, “Ma waktu 'nsa' le' paitu si Yahiya Magpapandi, iya na peen pignasihat kalangnganan sara' bayi pangamban uk si Musa maka sulat bayi tasulat uk manga kanabi-nabihan. Suga' sataggōl min waktu kapaitu si Yahiya sampay ni 'llaw itu, pignasihat lapal hap pasal pagparinta Tuhan. Bo' nuyu' tōōd manga aa kamemon pasōd ni diyōm pagparintahan na. ");
INSERT INTO slm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Suga' in sara' bayi pangamban uk si Musa 'nsa' du pinda kapatut na. Luhay le' liyunan dunya itu maka langit, min dakayo' balis ma sara' pindahan.” ");
INSERT INTO slm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Uk na isab, “Sayi-sayi nimanan handa na bo' ngahanda saddi, makalanggal iya sara' magjina. Maka sayi-sayi ngahanda ma danda bayi butas min halla na, makalanggal isab iya ma sara' magjina.” ");
INSERT INTO slm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Puwas hi' halling le' si Isa, uk na, “Niya' aa dayahan asal magsammek halgaan, maka hap sadja kiyakan na kahaba'-haba' 'llaw. ");
INSERT INTO slm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na niya' isab aa miskin, ōn na si Lasarus, lapat baran na uk dugsul. Iya kabiyaksahan na biyo pabahak ma tōngōd lawang dakayo' luma' aa dayahan ian. ");
INSERT INTO slm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sabab hōwat iya kabuwanan kapin kiyakan bang niya' pakpak min pagkakanan aa dayahan hi'. Minsan manga ero' pahi' isab ngandelatan dugsul na. ");
INSERT INTO slm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Manjari matay aa miskin itu bo' biyo iya uk manga bangsa malaikat ni diyōm sulga', ni diyōman si Ibrahim. Puwas hi' matay isab aa dayahan bo' kiyubul iya. ");
INSERT INTO slm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma hi' peen ma ahirat, kapaddian tōōd aa dayahan hi'. Jari pahangad iya bo' tanda' na si Ibrahim ma hi' ni katāhan, maka si Lasarus isab ma hi' ma bihing na. ");
INSERT INTO slm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hangkan na iya ngalingan magtuwi ni si Ibrahim. ‘O 'Mbo' Ibrahim,’ uk na, ‘maase' kau ma aku! Sohoun si Lasarus paitu. Bang peen tublakan na tong tudlu' na ni diyōm bohe' bo' pattakan na ni dalla' ku, sabab kapaddian aku tōōd ma diyōm api itu.’ ");
INSERT INTO slm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nambung si Ibrahim. ‘Oto',’ uk na, ‘intōmun waktu bayi kallum nu le'. Bayi kau piniyaan kahapan kaginis-ginisan, bo' si Lasarus iya bayi piniyaan kalaatan. Suga' ma buttihi' tiya' iya taga palasahan hap, bo' kau iya kapaddian. ");
INSERT INTO slm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Maka 'nsa' pasal iyu sadja, sabab niya' lowang lōm pibōtang ma ōtan kitabi hangkan sayi-sayi minnitu baya' paiyu, 'nsa' makalintas. Damikkiyan na, 'nsa' niya' minniyu makalintas paitu.’ ");
INSERT INTO slm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘Na,’ uk aa dayahan hi', ‘Bang salaiyu, 'Mbo', iya amu' ku junjung ni kau: sohoun sadja si Lasarus iyu pahi' ni luma' 'mma' ku, ");
INSERT INTO slm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sabab niya' ma hi' lima danakan ku lalla. Papahiun si Lasarus mandaan sigam bo' 'nsa' paitu ni lahat kabinsanaan itu.’ ");
INSERT INTO slm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Uk si Ibrahim, ‘Ian ma sigam iya bayi tasulat uk si Musa maka uk manga kanabi-nabihan iya makabanda' ma sigam. Iya na ian subay iyasip uk sigam.’ ");
INSERT INTO slm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Uk aa dayahan, ‘'Nsa' ba iyasip, 'Mbo'. Suga' bang niya' aa matay pikallum min kamatay na, bo' pay'an ni sigam, tantu du sigam ngalabba min dusa sigam.’ ");
INSERT INTO slm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Uk sambung si Ibrahim, ‘Bang 'nsa' taasip uk sigam iya bayi tasulat uk si Musa maka uk manga nabi kasehean, 'nsa' du sigam tabo ngahagad minsan niya' aa pikallum min kamatay na.’ ” ");
INSERT INTO slm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Mandu' le' si Isa ma manga mulid na, uk na, “Tantu niya' sasat-manasat piniya' na peen ma manusiya' makaparusa ma sigam. Suga' makaase'-ase' tōōd iya pamakaral ma sasuku nasat sehe' na mo ni magdusa, sabab binsana' du iya uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hap le' aa ian pigantungan batu bohat ma kallong na bo' iyampa hiyug ni sallang, bang peen 'nsa' makasaut hinang na magparusahan ma dakayo' aa deyo' itu, iya taga pangandōl tudju ni aku. ");
INSERT INTO slm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangkan kaam soho' ku subay kamaya'-maya',” uk na. “Bang niya' pagkahi nu ganta' makabuwan dusa ma kau, subay iya panduan nu bang ayi dusa na. Jari bang iya magtawubat ma bayi dusa na, subay iya ampun nu. ");
INSERT INTO slm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bang min pitu' iya makabuwan dusa ma kau ma diyōm dangallaw, bo' min pitu' iya paiyu ni kau ngamu' ampun, subay iya ampun nu.” ");
INSERT INTO slm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Manjari halling ni si Panghu' Isa manga mulid na bayi kawakilan na. Iya uk sigam, “Tuwan, pakōsōgun kono' pangandōl kami tudju ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Uk Panghu' hi', “Bang bayi makasali' mehe pangandōl bi ni sali' mehe bigi-bigi nahut sadja, makajari kaam magpanohoan ma kayu mehe ian. Bang uk bi, ‘Palarut kau minniyu bo' kau pabōtang ni diyōm sallang,’ bine' du sali' panohoan bi.” ");
INSERT INTO slm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Halling le' si Isa, uk na, “Bang sawupama niya' ma kaam taga sosohoan, iya hinang na mag-araru ma tana' bi, atawa mag-ipat hayōp bi bili-bili. Bang iya ganta' tapowe' min paghinangan na, halling bi baha' ma iya, ‘Dayi' na kau mangan’? ");
INSERT INTO slm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tantu 'nsa'. Suga' iya uk bi ma iya, ‘Adjalun kiyakan ku bo' iyampa kau magsayin mohatan aku. Subay na aku ubus bo' iyampa kau mangan!’ ");
INSERT INTO slm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Magsukul kaam baha' ma sosohoan bi ma sawukat manga panohoan bi iya tahinang na? 'Nsa' asal, sabab sosohoan bi du. ");
INSERT INTO slm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Damikkiyan na isab kaam iyu bang hinang bi kamemon bayi panohoan na ma kaam, subay uk bi, ‘Kami itu sosohoan sadja. Patut kami maghinang ayi-ayi bayi panohoan ma kami.’ ” ");
INSERT INTO slm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Manjari itu, ma palangnganan peen si Isa tudju ni Awrusalam, palabay iya min ōtan lahat Samariya maka lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagtakka na peen ni kalumaan niya' pasampang ni iya sangpu' aa ipul. Nangge sigam ni katāhan le', ");
INSERT INTO slm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ngalingan minnihi'. Uk sigam, “O Isa! Tuwan! Maase' na kau ma kami.” ");
INSERT INTO slm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pag'nda' si Isa ma sigam, uk na, “Pahi' kaam magtuwi ni manga imam bo' palilingun bi baran bi ma sigam, tanda' in kaam kaulian na.” Sakali itu, song sigam mangngan pahi', kaulian na sigam. ");
INSERT INTO slm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jari niya' dangan min sangpu' ian, pagtasayu na kaulian na iya, pabing magtuwi maka tanōg uk na nanglitan Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pasujud iya ni tōngōd nayi' si Isa magsukul ni iya. Aa itu bangsa Samariya asal. ");
INSERT INTO slm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Uk si Isa, “Sangpu' puhu' du kaam bayi kaulian. Maingga na siyam hi'? ");
INSERT INTO slm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Angay subay aa liyu itu sadja iya pabayik paitu magsukul ni Tuhan?” ");
INSERT INTO slm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Manjari halling si Isa ni aa hi', uk na, “Nangge na kau bo' kau palanjal na. Kaulian kau ma sabab pangandōl nu.” ");
INSERT INTO slm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ma dakayo' 'llaw niya' manga Parisi niyaw ni si Isa bang umay waktu pamabōtang uk Tuhan pagparinta na ma manusiya'. Uk sambung si Isa, “Bang pabōtang paitu pagparinta Tuhan, 'nsa' tanda' kapaitu na. ");
INSERT INTO slm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'Nsa' du niya' halling, ‘'Ndaun bi, tiya' ma itu pagparintahan Tuhan!’ atawa ‘Ian na may'an!’ Sabab na iyu du parinta Tuhan ma diyōm bi.” ");
INSERT INTO slm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Halling le' si Isa ma manga mulid na, uk na, “Niya' du ian 'llaw ma sosongun in kaam iyu baya' tōōd nganda' aku, Anak Manusiya', mag-agi na ma diyōm dunya. Baya' kaam nganda' minsan dangallaw sadja, suga' 'nsa' le' tanda' bi. ");
INSERT INTO slm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Niya' ian ngupama du ma kaam, uk na, ‘Ian iya may'an!’ atawa ‘Tiya' iya ma itu!’ Suga' daa kaam pahi' meha aku. ");
INSERT INTO slm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sabab aku itu, Anak Manusiya', bang taabut 'llaw kapaitu ku pabayik, tanda' du uk manusiya' kamemon. Sali' du panganda' sigam ma kirat bang nayinagan ma diyata' langit min bihing na dakayo' ni dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Suga' subay aku makananam kabinsanaan mehe dahu. Subay isab aku siyulak uk manga aa ma waktu itu bo' iyampa taabut 'llaw kapaitu ku pabayik. ");
INSERT INTO slm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Jari bang taabut manga 'llaw ian hi', sali' du kahalan na maka kahalan bayi ma masa si No hi'. Bayi sigam magkakanan na peen maka mag-inuman ma waktu ian hi'. Bayi sigam maghanda-maghalla sampay ni 'llaw kasakat di si No ni diyata' adjung. Manjari diyunukan dunya uk Tuhan bo' magmula manusiya' kamemon. Na, salaihi' du isab iya kahalan manusiya' bang aku, Anak Manusiya', pabing ni dunya. ");
INSERT INTO slm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Damikkiyan na isab manga aa bayi ma jaman le' si Lot hi'. Magkakanan na peen sigam maka mag-inuman, magballi maka magdagang, magtanōm maka maghinang manga luma'. ");
INSERT INTO slm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Suga' taabut peen waktu pakallo' si Lot min daira Sodom hi', magtuwi niya' api maka mayilang pitumbuk sali' ulan min diyōm langit. Jari magmula du sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na, salaihi' du isab kahalan manga aa ma dunya itu bang taabut 'llaw pamanda' aku, iya Anak Manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Pagtakka 'llaw ian, bang niya' aa ganta' ma luwasan luma' na bo' ian asal ayi-ayi na ma diyōm luma', subay 'nsa' pasōd ni luma' na ngallo' iya. Damikkiyan na isab bang niya' aa ma huma na, subay 'nsa' iya pabing ni luma' na. ");
INSERT INTO slm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pamintangun bi iya bayi patakka ni handa si Lot bayi ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sayi-sayi 'llōgan kallum baran na, 'nsa' du niya' kallum na taptap. Suga' sayi-sayi 'nsa' 'llōgan baran na ma sabab ku, minsan iya matay makatawwa' du iya kallum kakkal. ");
INSERT INTO slm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Baan ta kaam,” uk si Isa, “ma waktu pabayik ku paitu, niya' du aa duwangan tuwi ma pabahakan dakayo' du, jari killo' dakayo' ian bo' tamban du dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Niya' du ian duwangan danda magtabang nganggiling tirigu. Killo' dakayo' bo' tamban du dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Niya' isab duwangan maghinang ma huma. Killo' dakayo' bo' tamban du dakayo'.” ");
INSERT INTO slm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Manjari tīyaw si Isa uk manga mulid na, uk sigam, “Tuwan, maingga iya kaniyaan iya uk nu iyu?” Nambung si Isa magparalilan, uk na, “Maingga-maingga lahat niya' patay, may'an du pagtipunan manga owak.” ");
INSERT INTO slm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Manjari niya' kissa pamaralilan halling uk si Isa ma manga mulid na bo' supaya sigam 'nsa' siyumu nambahayang sakahaba' waktu. ");
INSERT INTO slm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uk na, “Ma dakayo' lahat niya' huwis 'nsa' tiyāw ma Tuhan, 'nsa' isab mag-addat ma pagkahi na manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Niya' isab ma lahat ian dakayo' danda balu. Na, danda itu taga palkala' bo' mawumu iya pahi' ni huwis ian ngamu' tabang. Ngalōgōs iya mikipabōntōl. Uk na, ‘Tabangin aku bo' 'nsa' ngandaōg kuntara ku hi'.’ ");
INSERT INTO slm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tagna' 'nsa' nabang huwis ian, suga' pagtaggōl-taggōl halling-hallingan iya di na, uk na, ‘Aku itu 'nsa' tiyāw ma Tuhan, 'nsa' isab mag-addat ma manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Suga' danda itu makasasaw pikilan sadja hangkan subay tabangan ku. Bang iya 'nsa' dulan ku, siyumu du aku ma kapaitu na.’ ” ");
INSERT INTO slm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Na,” uk si Isa, “hatihun bi bayi halling huwis 'nsa' bōntōl ian. ");
INSERT INTO slm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Manjari tiyaw ta na kaam: 'nsa' baha' Tuhan nabang ma manga aa tapene' na, iya ngamu'-ngamu' tabang ni iya 'llaw-sangōm? Magtanggu-tanggu le' iya baha' matuntul ma sigam? ");
INSERT INTO slm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Baan ta kaam,” uk si Isa, “lakkas du uk Tuhan matuntul ma sigam. Suga' ma sosongun, bang aku Anak Manusiya' pabayik paitu ni dunya, niya' baha' aa tatawwa' ku nōgōl mangandōl ma aku?” ");
INSERT INTO slm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, iya na itu isab kissa pamaralilan bayi pihalling uk si Isa ma manga aa, iya magbista di sigam in sigam bōntōl bo' pireyo' uk sigam pagkahi sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Uk si Isa, “Niya' duwangan aa bayi patukad pahi' ni langgal mehe nambahayang. Dangan ian aa Parisi, dangan iya aa magkallo' sukay parinta. ");
INSERT INTO slm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","May'an peen sigam ma diyōm langgal nangge aa Parisi didihan na bo' nambahayang iya ni Tuhan, uk na, ‘O Tuhan ku, mehe pagsukulan ku ni kau. Sabab in aku itu 'nsa' sali' aa kasehean, iya napsuhan ian maka ngulli' maka magjina. Magsukul isab aku in aku 'nsa' sali' aa magkallo' sukay parinta itu. ");
INSERT INTO slm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aku itu, min duwa aku magpuwasa ma diyōm dapitu', maka jakatan ku isab kamemon tausaha ku.’ ");
INSERT INTO slm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Suga' in aa magkallo' sukay parinta ian hi' nangge ma tong langgal maka 'nsa' minsan paharap ni sulga'. Pippōk-pippōk uk na dagha na sabab susa na. ‘O Tuhan,’ uk na, ‘maase' kau ma aku sabab dusahan aku.’ ");
INSERT INTO slm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Baan ta kaam,” uk si Isa, “taabut peen manga aa itu mowe' min langgal hi', aa magkallo' sukay iya bōntōl ma bistahan Tuhan, 'nsa' aa Parisi hi'. Sabab na sayi-sayi magpalangkaw ma baran na pireyo' du, maka sayi-sayi magpareyo' di na pilangkaw du isab.” ");
INSERT INTO slm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, niya' manga aa mo anak sigam ni si Isa bo' supaya iya mabōtang tangan na ma sigam. Pag'nda' itu uk manga mulid na, magtuwi pihallingan uk sigam manga aa mamo ian. ");
INSERT INTO slm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Suga' linganan onde'-onde' ian uk si Isa. Uk na ni manga mulid na, “Parulun bi manga onde'-onde' iyu paitu ni aku. Daa sigam lāngun bi sabab sayi-sayi makasali' kawul-piil na ni sali' onde'-onde' itu taga palsukuan du ma pagparinta Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bannal iya pama' ku ma kaam, bang aa 'nsa' nulut ma pagparinta Tuhan sali' kapanulut onde'-onde', na, aa ian 'nsa' du pisōd ni diyōm pagparintahan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma dakayo' 'llaw niya' Yahudi langkaw pahi' ni si Isa niyaw ma iya. “Tuwan Guru,” uk na, “kau iyu asal hap. Ayi subay hinang ku bo' aku kaniyaan kallum iya taptap ni kasaumulan?” ");
INSERT INTO slm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nambung si Isa, uk na, “Angay uk nu in aku itu hap? 'Nsa' niya' hap, duwal Tuhan dakayo'-kayo'. ");
INSERT INTO slm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Katauhan nu asal bayi panohoan Tuhan: daa kau magjina. Daa kau mono'. Daa kau nangkaw. Daa kau naksi' puting. Pag-addatin ina'-mma' nu.” ");
INSERT INTO slm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Uk lalla ni iya, “Tuwan, sataggōl min kaonde'-onde' ku bayi na kabōgbōgan ku ian hi' kamemon.” ");
INSERT INTO slm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Take peen itu uk si Isa, uk na, “Niya' le' dakayo' 'nsa' tahinang nu. Pahi' kau, paballihin alta' nu kamemon bo' pamuwanun ballihan na ma manga aa miskin. Manjari niya' du karaya nu may'an ma diyōm sulga'. Puwas hi' paitu kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Suga' pagtake aa itu ma bissala si Isa magtuwi iya susa tōōd sabab landu' heka alta' na. ");
INSERT INTO slm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tanda' uk si Isa susa na bo' uk na ni iya, “Manga aa dayahan kahunitan asal pasōd ni diyōman pagparinta Tuhan! ");
INSERT INTO slm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kaluhayan le' unta' palabay min buwi' jawum min aa dayahan pasōd ni diyōman pagparinta Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Take peen halling si Isa itu uk manga aa, halling sigam, “Bang salaihi', sayi baha' makasampay ni kasalamatan ma diyōm sulga'?” ");
INSERT INTO slm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Uk sambung si Isa, “Iya 'nsa' takowe' uk manusiya' takowe' du uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sakali halling si Petros, uk na, “'Ndaun ba kami itu. Bayi na 'mbanan kami ayi-ayi kamemon bo' me' ma kau.” ");
INSERT INTO slm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Aho',” uk si Isa ma sigam, “maka baan ta kaam tōōd: sasuku bayi ngambanan luma' na, atawa handa na, atawa danakan na, atawa ina'-mma' na, atawa manga anak na, ma sabab katuyu' na ma pagparinta Tuhan, ");
INSERT INTO slm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tiyungbasan du iya uk Tuhan ma dunya itu hi', lipat manglipat min bayi 'mbanan na. Bo' ma dunya ahirat pisukuan iya kallum taptap ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Manjari biyo uk si Isa mulid na sangpu' ka duwa pasaddi min aa kasehean bo' iyampa sigam bissalahan uk na. Halling na, “Pake kaam. Tiya' kitabi patukad tudju ni Awrusalam. May'an peen kitabi, pimattan du kamemon bayi tasulat uk manga kanabi-nabihan ma pasal aku, Anak Manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Siyongan du aku ni pangantanan manga aa 'nsa' bangsa Yahudi bo' pig-udju'-udju' aku uk sigam. Hiyalipulu isab aku sampay pigluraan. ");
INSERT INTO slm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Piglapdōsan du aku uk sigam bo' iyampa aku piyatay. Suga' taabut peen tallum bahangi min kamatay ku 'llum du aku pabing.” ");
INSERT INTO slm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Suga' 'nsa' tahati uk manga mulid na bang ayi bissala uk na ian. 'Nsa' makahōp hatihan na ni diyōm pikilan sigam. 'Nsa' tasabut uk sigam bang ayi pihalling uk si Isa hi'. ");
INSERT INTO slm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Manjari, sikōt peen di si Isa ni daira Ariha, niya' aa buta ningko' ma bihing daddōk palabayan sigam. Hinang na ngamu'-ngamu' sin. ");
INSERT INTO slm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Makake peen buta itu ma baanan aa maglabay minnian, tīyaw uk na bang ayi poon na. ");
INSERT INTO slm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Halling manga aa ian ma iya, “Tiya' palabay si Isa, aa min Nasaret.” ");
INSERT INTO slm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagtake na itu magtuwi iya ngalingan pakōsōg, “O Isa,” uk na, “tubu' Sultan Daud, maase' kau ba ma aku!” ");
INSERT INTO slm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pihallingan iya uk manga aa min dahuhan na, daa siyoho' maghebok. Suga' pikōsōg gam peen pangalingan na. “O Isa, tubu' sultan Daud,” uk na, “maase' na kau ba!” ");
INSERT INTO slm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jari parōhōng si Isa bo' soho' na aa buta ian biyo ni iya. Makasikōt peen, tiyaw si Isa ma iya, uk na, ");
INSERT INTO slm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ayi kabayaan nu hinang ku ma kau?” “Tuwan,” uk na, “kabayaan ku makanda' pabing.” ");
INSERT INTO slm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Uk si Isa ni iya, “Makanda' na kau. Kaulian na mata nu ma sabab pangandōl nu ma aku.” ");
INSERT INTO slm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Saruun-duun du iya makanda' pabing bo' me' iya paturul ma si Isa maka uk na nanglitan Tuhan. Pag'nda' itu uk baanan manga aa may'an, iya du sigam kamemon me' nanglitan Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pasōd na si Isa ni diyōm daira Ariha bo' palabay iya min tangnga' kalumaan. ");
INSERT INTO slm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na, niya' aa maglahat ma hi', ōn na si Sakkiyas. Nakura' asal iya ma manga aa magkallo' sukay parinta, maka dayahan iya. ");
INSERT INTO slm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Baya' tōōd iya nganda' ma si Isa bang sayi iya, suga' 'nsa' tanda' na sabab pandak iya maka heka aa magtipunan ian. ");
INSERT INTO slm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hangkan iya paragan parahu min kahekahan aa ian bo' parāg iya ni diyata' kayu sikamol bo' supaya tanda' na si Isa bang palabay na minnihi'. ");
INSERT INTO slm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagtakka si Isa ni tōngōd kayu ian parōhōng iya pahangad, bo' halling na ma si Sakkiyas, “O Sakkiyas, palakkas na kau paruwai sabab subay aku pahali-hali ma luma' nu 'llaw itu.” ");
INSERT INTO slm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jari parayi'-dayi' si Sakkiyas paruwai, maka kiyōgan iya mo si Isa ni luma' na. ");
INSERT INTO slm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sakali magpanaway manga aa kamemon iya makake ma bayi halling si Isa ma si Sakkiyas hi'. Uk sigam, “Allā! Me' iya pahi' mangan ma luma' aa dusahan!” ");
INSERT INTO slm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma luma' peen, nangge si Sakkiyas bo' uk na ni si Isa, “Tuwan, pake kau kono'. Santōnga' alta' ku panarakka ku du ma manga aa miskin. Maka bang niya' aa bayi akkalan ku, papowe' ku du ni iya sin na lipat 'mpat.” ");
INSERT INTO slm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Uk si Isa ni iya, “'Llaw itu lappasan kau sampay anak-handa nu sabab tubu' kau isab si Ibrahim. ");
INSERT INTO slm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aku, Anak Manusiya', iya maksud ku paitu ni dunya subay meha manga aa tā min Tuhan bo' sigam liyappasan.” ");
INSERT INTO slm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pagka peen pake manga aa ma si Isa, niya' kissa pamaralilan pihalling uk na ma sigam. Sikōt na iya ni daira Awrusalam, maka pangannal sigam in pagparinta Tuhan ma manusiya' song na tiyagnaan. ");
INSERT INTO slm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hangkan salaitu pamaralilan na: “Niya',” uk na, “dakayo' aa bangsahan magbamba pauntas ni lahat tā bo' iya tahinang sultan mahi'. Puwas hi' pabing du iya ni lahat na magsultan. ");
INSERT INTO slm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manjari itu, ma song peen tulak, linganan uk na sangpu' sosohoan na. Biyuwanan sigam uk na dublun bulawan pakaniya-pakaniya. Halling na ma sigam, ‘Lituhun bi alta' itu sataggōl ku 'nsa' maitu.’ ");
INSERT INTO slm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Suga' kibansihan aa bangsahan itu uk manga aa ma lahat na, hangkan sigam mabo aa paturul ni iya mo lapal. Uk lapal hi', ‘'Nsa' kami baya' bang kau iyu pagsultanan kami.’ ");
INSERT INTO slm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Suga' minsan salaihi', tahinang sadja iya sultan bo' pabing iya ni lahat na. Pagtakka na, magtuwi siyoho' uk na paalōp ni iya manga sosohoan bayi kabuwanan dublun bo' supaya katauhan na bang pila tauntung uk sigam dangan maka dangan. ");
INSERT INTO slm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jari paalōp ni iya sosohoan dahu bo' uk na, ‘Tuwan, iya dublun dakayo' bayi pamuwan nu ma aku taga untung na sangpu' dublun.’ ");
INSERT INTO slm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Hap du hinang nu,’ uk sultan. ‘Kau sosohoan hantap. Pagka kau iyu kapangandōlan ma alta' diki'-diki', hangkan kau buwanan ku kapatut mag-agi ma sangpu' daira.’ ");
INSERT INTO slm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Puwas hi' paalōp ni iya sosohoan karuwa na. ‘Tuwan,’ uk na, ‘iya dublun bayi pamuwan nu ma aku taga untung na lima.’ ");
INSERT INTO slm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Uk sultan ni iya, ‘Hap. Kau isab buwanan ku kapatut mag-agi ma lima daira.’ ");
INSERT INTO slm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jari paalōp isab pay'an sosohoan dakayo' bo' uk na, ‘Tuwan, oo, tiya' du dublun nu. Bayi putus ku maka panyu' bo' iyampa tawu' ku sakuli-kuli. ");
INSERT INTO slm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tiyāw asal aku ma kau sabab kau iyu 'nsa' maase' ma aa. Kallo' nu iya 'nsa' bayi pabōtang nu, maka pag-ani nu iya 'nsa' bayi pagluugan nu.’ ");
INSERT INTO slm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Uk sultan ni iya, ‘Oy! Kau iyu sosohoan 'nsa' niya' kapusan na. Pibing uk ku ni kau bayi halling nu sini' bo' kau tawwa' hukuman. Katauhan nu baha' in aku 'nsa' maase'? Kallo' ku baha' iya 'nsa' bayi pabōtang ku? Maka pag-ani ku baha' iya 'nsa' bayi pagluugan ku? ");
INSERT INTO slm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bang hati salaihi', angay 'nsa' bayi tawu' nu sin ku ni diyōm bangko bo' niya' anak na? Manjari pagtakka ku paitu takallo' ku du sin ku sampay anak na.’ ");
INSERT INTO slm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Puwas hi' halling sultan ni manga aa magpanangge may'an. ‘Kalloun bi dublun min iya bo' pamuwanun bi pay'an ni sosohoan dakayo', iya niya' dublun na sangpu' ian.’ ");
INSERT INTO slm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Suga' uk manga aa ian, ‘Tuwan! Niya' na sangpu' dublun na!’ ");
INSERT INTO slm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Baan ta kaam,’ uk sultan, ‘sasuku kapangandōlan ma heka, kinnōpan du ma iya, suga' sasuku 'nsa' kapangandōlan minsan ma diki', kiyulangan du ayi-ayi bayi ma iya. ");
INSERT INTO slm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, manga banta ku ian,’ uk sultan, ‘manga aa 'nsa' baya' bang aku pagsultanan sigam, bohun bi paitu. Papatayun bi sigam ma itu ma alōpan ku.’ ” ");
INSERT INTO slm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ubus peen bissala si Isa itu, mangngan iya parahu min sigam tudju ni Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jari itu, makasikōt peen iya ni kalumaan Betpage maka Betani, iya ian ma kasikōtan Bud Jaitun, noho' iya duwangan mulid na parahu min kasehean. ");
INSERT INTO slm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Uk na ma sigam, “Pahi' na kaam ni kalumaan ma dahuhan bi iyu. Jari pagtakka bi pay'an makatawwa' du kaam dakayo' anak kura' ingkōtan, kura' 'nsa' bayi tapanguraan aa. Hubaran bi bo' bohun bi paitu. ");
INSERT INTO slm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bang niya' ganta' niyaw kaam bang angay hiyubaran uk bi, subay halling bi, ‘Tuud pigguna uk nakura'.’ ” ");
INSERT INTO slm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sakali pahi' aa bayi siyoho' hi' bo' tatawwa' uk sigam sali' bayi pama' si Isa. ");
INSERT INTO slm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sabu peen sigam ngahubad anak kura', halling manga aa dapu na ma sigam, uk sigam, “Oy! Angay hubaran bi iyu?” ");
INSERT INTO slm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Uk sigam, “Tuud pigguna uk nakura'.” ");
INSERT INTO slm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jari biyo uk sigam anak kura' ni si Isa. Liyampikan bukut na maka manga badju' sigam bo' iyampa si Isa pitingko' ma diyata'. ");
INSERT INTO slm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na, makakura' peen si Isa, billat uk manga aa sammek sigam ma daddōk palabayan na. ");
INSERT INTO slm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pagka sikōt na si Isa ni Awrusalam, ian na ma daddōk ma luran Bud Jaitun, iya baanan manga anak-mulid na ian kamemon nagna' na magpananglit ma Tuhan. Pitanōg suwara sigam nanglitan iya ma sabab manga hinang barakatan bayi tanda' uk sigam hinang uk si Isa. ");
INSERT INTO slm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Uk sanglit sigam, “Bang peen biyarakatan Sultan itu, iya kawakilan uk Tuhan paitu. Kasannangan asal ma diyōm sulga', maka sanglit ma Tuhan Mahatinggi!” ");
INSERT INTO slm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jari halling ni si Isa manga Parisi bayi may'an ma diyōm katipunan aa. Uk sigam, “Tuwan Guru, sohoun manga mulid nu itu parōhōng nanglitan kau!” ");
INSERT INTO slm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nambung iya, uk na, “Baan ta kaam, bang ganta' sigam itu 'nsa' halling, paganti' manga batu ma daddōk itu ngōlang nanglitan aku.” ");
INSERT INTO slm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sikōt-sikōt peen si Isa ni daira Awrusalam, bo' tanda' na manga kalumaan na, magtangis iya sabab kaase' na ma manga aa ma lahat ian. ");
INSERT INTO slm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Uk na, “Allā, minsan ma 'llaw itu na, bang bayi tahati bi bang ayi kagunahan bi supaya kaam makatawwa' kasannangan. Suga' 'nsa' du tahati bi. ");
INSERT INTO slm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma waktu siyong niya' bala' takka ni kaam. Pig-agpangan du daira bi iyu uk manga banta bi, pigkutaan katilibut na uk sigam bo' kaam 'nsa' makaluwas. ");
INSERT INTO slm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Liyubu uk sigam kalumaan bi iyu kamemon sampay 'nsa' na niya' batu pagdayaw luma' takapin magpangkat-pangkat. Maka kaam kamemon magtayi'-anak iya maglahat maiyu, piyatay du isab uk sigam. Paniya' du bala' itu ma kaam sabab 'nsa' piruli uk bi waktu kapamanda' uk Tuhan ase' na ma kaam.” ");
INSERT INTO slm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Manjari pagtakka si Isa pahi' pasōd iya ni diyōm langgal pagkulbanan, bo' nagna' iya makallo' na manga aa magdagang-dagang may'an. ");
INSERT INTO slm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Uk na ma sigam, “Tasulat asal ma diyōm kitab bayi palman Tuhan, iya uk na, ‘Luma' ku itu iyōnan du luma' pagsambahayangan manga aa.’ Suga' hinang bi na sali' luma' panapukan mundu.” ");
INSERT INTO slm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mandu' na peen si Isa 'llaw-llaw ma diyōm langgal ian. Manga kaimaman langkaw maka manga guru ma sara' agama maka manga aa pamean mahi' baya' mapatay si Isa. ");
INSERT INTO slm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Suga' 'nsa' niya' lawang tapeha sigam pamapatay ma iya, sabab manga aa kamemon ian tuyu' tōōd pake ma pamissala na. ");
INSERT INTO slm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ma dakayo' 'llaw, ian isab si Isa ma langgal pagkulbanan manduan manga aa maka magnasihat lapal hap ma sigam. Jari pahi' ni iya manga kaimaman langkaw, maka manga guru ma sara' agama, maka manga kamaasan. ");
INSERT INTO slm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Halling sigam ni iya, “Ayi kapatut nu maghinang kau salaiyu? Sayi bayi muwanan kau kapatut?” ");
INSERT INTO slm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Uk na ni sigam, “Niya' dakayo' paniyaw ku ma kaam dahu. Bain bi aku: ");
INSERT INTO slm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","iya kapatut si Yahiya Magpapandi hi', kapatut min Tuhan baha' atawa min manusiya' sadja?” ");
INSERT INTO slm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sakali mag-isun-isun manga aa ian. Uk sigam, “Bang sawupama uk ta in kapatut si Yahiya ian bayi min Tuhan, tīyaw du kitabi itu uk na bang angay kitabi 'nsa' bayi magkahagad ma si Yahiya. ");
INSERT INTO slm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Suga' bang uk ta in kapatut si Yahiya ian min manusiya' sadja, na, piligdu kitabi. Hiyak kitabi maka batu uk manga mahadjana' itu kamemon sabab magkahagad asal sigam in si Yahiya nabi du min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hangkan salaitu iya panambung manga nakura' ian ma tiyaw si Isa, uk na, “'Nsa' katauhan kami bang minningga kapatut na.” ");
INSERT INTO slm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“Na,” uk si Isa, “iya du aku 'nsa' maan kaam bang minningga iya kapatut ku maghinang manga hinang ku itu.” ");
INSERT INTO slm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Manjari nagna' si Isa mahalling kissa paralilan ma manga aa. “Niya',” uk na, “dakayo' aa taga tana' bayi nanōm bahan anggul ma kabbun na. Bayi patungguan na ma manga aa magtutunggu'. Puwas hi' tulak iya ni lahat saddi bo' taggōl iya ma hi'. ");
INSERT INTO slm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taabut peen musim pagpusu' buwa' anggul hi', siyoho' uk aa dapu kabbun ian dakayo' sosohoan na pahi' ni manga aa magtutunggu' ngallo' bahagi' na. Suga' liyapdōsan ipatan ian uk sigam bo' pipowe' iya ma 'nsa' niya' tabo na. ");
INSERT INTO slm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Puwas hi' noho' na isab aa dapu ian sosohoan na saddi pahi' ni sigam. Iya du iya liyapdōsan uk sigam, hiyalipulu, maka pipowe' ma 'nsa' niya' tabo na. ");
INSERT INTO slm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Puwas hi' soho' na isab sosohoan saddi pahi', kamintallu na na. Jari sosohoan damuwi itu palian uk sigam bo' iyampa pilahi paluwas min kabbun anggul hi'. ");
INSERT INTO slm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Manjari uk aa dapu kabbun, ‘Ayi baha' subay hinang ku? Papahi' ku le' anak ku lahasiya' itu, iya kalasahan ku. Tantu iya pig-addatan du uk sigam.’ ");
INSERT INTO slm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Suga' pag'nda' manga tunggu' ma anak aa dapu hi' magtuwi sigam mag-isun. Uk sigam, ‘Iya na ko' iyu anak aa dapu. Sung na kitabi, papatay tabi na iya bo' takallo' tabi tana' na.’ ");
INSERT INTO slm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jari liyarukan iya uk sigam ma luwasan kabbun hi', bo' piyatay. “Na,” uk si Isa, “ayi baha' hinang aa dapu kabbun hi'? ");
INSERT INTO slm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pahi' du iya mapatay manga tunggu' ian, bo' patungguan na kabbun na ma aa saddi.” Pagtake peen manga aa ian ma bissala si Isa itu, uk sigam, “Oy! Bang peen 'nsa' kiyabbul bo' nu!” ");
INSERT INTO slm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Suga' piyatong sigam uk si Isa. Uk na, “Ayi hati na, kumpas bi, iya tasulat ian ma diyōm kitab, iya uk na: ‘Iya batu bayi siyulak uk aa maghinang luma', pangannal 'nsa' niya' guna na, Iya na ian batu mehe tōōd kalagihan na.’ ” ");
INSERT INTO slm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Uk si Isa le', “Sasuku hug ni batu itu tumu-tumu du baran na. Maka sasuku kahugan batu itu pipis du kamemon na.” ");
INSERT INTO slm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Manga guru ma sara' agama maka manga kaimaman langkaw baya' naggaw si Isa ma saruun-duun, sabab tasayu uk sigam in sigam iya bayi paandigan na ma paralilan pasal tunggu' kabbun ian. Suga' 'nsa' iya tasaggaw uk sigam sabab tiyāw sigam ma manga aa mahadjana'. ");
INSERT INTO slm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Meha le' sigam waktu hap bo' supaya iya siyongan uk sigam pahi' ni pangantanan gubnul. Niya' manga aa tiyambahan uk sigam, siyoho' pahi' ni si Isa magbawu'-bawu' in sigam taga atay pote' tudju ni iya, bo' supaya iya tabo magbissala bo' iya tasaggaw uk sigam ma bissala na. ");
INSERT INTO slm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jari halling manga aa tiyambahan ian ni si Isa. “Tuwan Guru,” uk sigam, “katauhan kami in bissala nu maka pandu' nu bōntōl du. 'Nsa' kau mene' ma aa minsan sayi iya, maka bannal sadja pamandu' nu pasal kawul-piil iya kibayaan uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bain kami kono'. Bang kita ganta' mayad sukay ni parinta Roma, iya deyo' min Sultan Mahatinggi hi', langgal ta baha' sara' agama tabi?” ");
INSERT INTO slm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Suga' kitauhan asal uk si Isa pangakkal sigam, hangkan uk na ma sigam, ");
INSERT INTO slm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pandain kono' aku sin.” Pagka niya' na sin, uk na, “Patta' sayi maka ōn sayi ma sin itu?” “Patta' Sultan Mahatinggi maka sulat na,” uk sambung sigam. ");
INSERT INTO slm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Na,” uk si Isa, “pagka suku' sultan ko' itu, pamayarun bi ni iya. Damikkiyan na, bang niya' ayi-ayi suku' Tuhan, ungsurin bi isab ni Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Manjari 'nsa' iya takowe' siyaggaw uk sigam ma alōpan manga mayiran. Hangkan na 'nsa' na niya' bissala sigam, maka inu-inu sigam ma panambung na. ");
INSERT INTO slm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Puwas hi' niya' pay'an ni si Isa manga aa Saddusi, daginis agama Yahudi iya uk na 'nsa' niya' aa magpatayan 'llum pabing ma 'llaw damuwi. ");
INSERT INTO slm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tiyaw sigam ma si Isa, “Tuwan Guru,” uk sigam, “niya' sara' bayi pangamban kitabi uk si Musa pasal aa bang matay ma 'nsa' taga tubu'. In balu na subay killo' handa uk siyay na, bo' supaya niya' anak tabista tubu' min aa bayi mamatay hi'. ");
INSERT INTO slm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na,” uk sigam, “niya' bayi pitu' lalla magdanakan. Maghanda siyaka suga' matay iya ma 'nsa' taga anak. ");
INSERT INTO slm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jari siyay pasunu' maghanda balu hi' bo' matay isab ma 'nsa' taga anak. ");
INSERT INTO slm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Damikkiyan na isab siyay katallu na. Jari in pitu' magdanakan bayi makahanda ni dakayo' danda hi', bo' matay sigam kamemon ma 'nsa' taga anak. ");
INSERT INTO slm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma katapusan na matay isab danda. ");
INSERT INTO slm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, Tuwan,” uk sigam, “bang taabut 'llaw pagpakallum bayik manga aa magpatayan, handa sayi baha' danda hi'? Sabab bayi iya takallo' handa uk sigam pitu' magdanakan.” ");
INSERT INTO slm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nambung si Isa ma sigam, uk na, “Manga aa ma dunya itu maghanda asal maka maghalla. ");
INSERT INTO slm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Suga' manga aa iya bista uk Tuhan makajari pikallum pabayik min kamatay, maka tiyōp maglahat ma hi' ma sulga', 'nsa' na sigam maghanda atawa maghalla. ");
INSERT INTO slm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sabab 'nsa' na sigam magkamatay suga' makasali' na sigam ni manga malaikat. Manga anak Tuhan na sigam sabab bayi na sigam pikallum pabing min kamatay sigam. ");
INSERT INTO slm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, in pasal aa magpatayan pikallum pabing, pipasti' ko' itu uk si Musa ma sulat kitab, iya pasal kayu puhung bayi keyat. Iya pangōn si Musa ma Tuhan may'an, ‘Tuhan pagtuhanan di si Ibrahim maka si Isahak maka si Ya'kub.’ ");
INSERT INTO slm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hati na Tuhan itu pagtuhanan asal uk manga aa 'llum, 'nsa' uk aa magpatayan. Bang ma bistahan Tuhan 'llum asal aa kamemon, minsan taggōl na kamatay ginhawa-baran sigam.” ");
INSERT INTO slm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Halling manga guru sara' agama kasehean. “Tuwan Guru,” uk sigam, “hap sambung nu ian.” ");
INSERT INTO slm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Nsa' na niya' makatawakkal niyaw iya pabayik. ");
INSERT INTO slm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jari tiyaw si Isa ma sigam. “Angay,” uk na, “manga aa halling pasal si Almasi in iya tubu' si Sultan Daud? ");
INSERT INTO slm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sabab na si Daud baran na bayi magpalatun ma diyōm kitab Jabul, uk na, ‘Bayi ngabtang Tuhan ni Panghu' ku, uk na, Dayi' kau, ningko' kau ma bihing ku sakap ni katau, ");
INSERT INTO slm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bo' bo ku palbantahan nu tatawu' ma deyo' pat-nayi' nu.’ ");
INSERT INTO slm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na,” uk si Isa, “pagka si Almasi iyōnan Panghu' uk si Sultan Daud, tantu iya 'nsa' panubu' si Daud sadja.” ");
INSERT INTO slm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pasalta' peen pake manga aa kamemon, uk si Isa ni manga mulid na, ");
INSERT INTO slm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Halliin bi manga guru ma sara' agama, iya tagihan maglunsul magpamakay juba taha'. Tagihan isab sigam hiyulmat bang ma mayiran. Bang ma diyōm langgal, baya' sigam pitingko' ma tingkoan bangsahan. Damikkiyan na bang sigam ma pagjamuhan, subay paningkoan iya tiyawuan aa langkaw. ");
INSERT INTO slm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nyanyaya uk sigam manga balu danda supaya takallo' luma' sigam, bo' pitaha' uk sigam sambahayang sigam, paglaku-laku sigam in sigam bal-iman, bahasa tapukan kahinangan sigam malaat hi'. Hangkan du pikalap kabinsanaan ma sigam ma ahirat.” ");
INSERT INTO slm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Manjari itu nganda' si Isa bo' tanda' na manga aa dayahan magpangahug sin pagjakat sigam ni tuung ma diyōm langgal ian. ");
INSERT INTO slm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Niya' isab tanda' na dakayo' danda balu, miskin tōōd, ngahug duwa pisita tumbaga. ");
INSERT INTO slm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Uk si Isa, “Bannal iya pama' ku ni kaam itu, iya duwa pisita tumbaga tahug uk danda miskin itu labi halgaan le' min pilak kamemon bayi tahug uk sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sabab kasehean ian,” uk si Isa, “bayi muwan min alta' sigam manglabi-labihan. Suga' danda itu, minsan iya miskin kalandu', bayi muwan sin na kamemon iya arak pamalli na balanja' na.” ");
INSERT INTO slm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niya' manga mulid na kasehean maglagtang-lagtang pasal langgal pagkulbanan ian. Hap inda' kono' manga batu bayi giyuna pangahinang langgal hi', maka ari-ari na kaginis-ginisan bayi pamuwan uk manga aa. Pagtake peen bissala sigam uk si Isa, uk na, ");
INSERT INTO slm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Iya tanda' bi itu kamemon liyubu du ma waktu siyong. 'Nsa' du niya' batu na ngapin magbangkat. Kiyanat du kamemon.” ");
INSERT INTO slm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jari tīyaw si Isa uk sigam. “Tuwan Guru,” uk sigam, “umay paniya' iya bayi uk nu sini'? Maka ayi tanda' na bo' kitauhan in pakaradjaan ian takka na?” ");
INSERT INTO slm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nambung iya, uk na, “Kamaya'-maya' kaam bo' kaam 'nsa' kaakkalan. Sabab ma sosongun iyu heka paitu nabbut ma ōn ku, maglaku-laku in sigam si Almasi na. ‘Kiyamat na,’ uk sigam. Suga' daa kaam me' ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bang niya' take bi hunub-hunub pasal pagbono' atawa pasal lingōg, daa kaam gawa. Tantu paniya' manga pagbono' suga' 'nsa' le' ian hi' 'llaw kiyamat.” ");
INSERT INTO slm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Masi halling si Isa, uk na, “Magbono' du bangsa dakayo' maka dakayo', parinta dakayo' isab maka parinta dakayo'. ");
INSERT INTO slm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Paniya' du manga linug mehe maka gōtōm maka saki laatan ma kalohahan dunya. Niya' isab manga paltandaan tanda' ma diyata' langit, paltandaan makainu-inu maka makataw-taw. ");
INSERT INTO slm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Suga' dahu min ian hi' siyaggaw du kaam uk manga aa maka liyaat du kaam. Biyo du kaam ni langgal sigam bo' kaam hiyukum maka liyōōn ni diyōm jil. Tiyukbalan du isab kaam ni manga sultan maka ni manga gubnul bo' kaam hiyukum uk sigam ma sabab pame' bi ma aku. ");
INSERT INTO slm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bang ian na kaam ma alōpan sigam, iya na ian waktu kapama' bi ma sigam lapal hap pasal aku. ");
INSERT INTO slm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Suga' magniyat kaam subay 'nsa' magsusa bang ayi pangandaawa bi waktu kapanumariya kaam, ");
INSERT INTO slm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sabab aku iya muwanan kaam tau bo' kaam makasambungan sigam. Jari 'nsa' du niya' kuntara bi makasagga' kaam, maka 'nsa' katangkisan bissala bi. ");
INSERT INTO slm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Minsan manga maas bi maka dawuranakan bi, minsan manga lung-kampung bi maka manga kabagayan bi, siyongan du kaam uk sigam ni kuntara bi. Maka niya' min kaam piyatay du uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kibansihan du kaam uk aa kamemon ma sabab pame' bi ma aku. ");
INSERT INTO slm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Suga' 'nsa' du kaam kalungayan ayi-ayi minsan dalamba buun bi. ");
INSERT INTO slm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lappasan du kaam bang peen pahōgōt bi pangandōl bi.” ");
INSERT INTO slm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bang tanda' bi daira Awrusalam itu libut uk sundalu, na, katauhan bi song na waktu pamakaat iya. ");
INSERT INTO slm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jari sasuku pabōtang ma lahat Yahudiya subay paragan pahi' ni kabud-buran. Sasuku ma diyōm daira Awrusalam subay paluwas magdayi'-dayi', maka sasuku ma de daa subay pabing pahi' ni diyōm daira. ");
INSERT INTO slm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabab iya ian manga 'llaw pangamulka' Tuhan ma manusiya'. Jari niya' na kamaujuran ma kamemon bayi tasulat ma diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Ndu', makaase'-ase' tōōd manga danda battōng ma masa ian hi', maka manga danda taga anak duru' lagi'. Sabab niya' iyu kabinsanaan mehe pitumbuk ni kalohahan lahat itu. Maka manga aa na pitakkahan du mulka' Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Niya' sigam kasehean diyugsuan uk manga sundalu, piyatay. Maka niya' aa kasehean siyaggaw, hinang banyaga' bo' biyo ni kalahat-lahatan kamemon. Daira Awrusalam itu pikaat du uk manga kabangsahan saddi. Subay na jukup gantaan pagparinta sigam bo' iyampa sigam pakallo'.” ");
INSERT INTO slm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ma waktu ma sosongun ian niya' paltandaan paniya' ma mata 'llaw maka ma bulan maka ma manga bituun. Mehe manga kasusahan iya takka ni kabangsa-bangsahan ma itu ma dunya giyawa du pangatayan sigam. Lingōg pikilan sigam sabab 'nsa' manjari pangallub tahik maka landōs goyak kalandu'. ");
INSERT INTO slm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Agōn matay manga aa sabab min tāw maka susa sigam, pagpikil sigam manga bala' song patakka ni dunya. Sabab ayi-ayi bayi pibōtang uk Tuhan ma tōngaan langit tabo du maglingas. ");
INSERT INTO slm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Puwas ian hi',” uk si Isa, “makanda' du manga aa ma aku, Anak Manusiya', paitu min gabun. Tanda' uk sigam barakat ku maka kōsōg sahaya ku. ");
INSERT INTO slm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jari bang nagna' manga pakaradjaan iya uk ku itu, nangge kaam maka pahangad sabab 'nsa' na taggōl, lappasan du kaam.” ");
INSERT INTO slm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jari niya' paralilan pihalling uk si Isa ma sigam, uk na, “Pandōgahin bi kayu igira maka manga kayu kasehean. ");
INSERT INTO slm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bang tanda' bi ngugbus dawun na, minnihi' katauhan bi song musim pangallaw na. ");
INSERT INTO slm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Damikkiyan na bang tanda' bi paniya' bayi pamissala ku ma kaam sini' hi', minnihi' isab katauhan bi sikōt na waktu pagparinta Tuhan ma itu ma manusiya'. ");
INSERT INTO slm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bannal iya pama' ku ma kaam,” uk si Isa. “Ma 'nsa' le' magpatayan kamemon manga aa iya 'llum ma buttihi', paniya' du pakaradjaan kamemon bayi uk ku hi'. ");
INSERT INTO slm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Papinda du langit maka dunya suga' kabtangan ku itu 'nsa' tōōd magkapinda.” ");
INSERT INTO slm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Subay kaam pahalli',” uk si Isa, “bo' 'nsa' lingōg pikilan bi uk hinang bi magdul-bayaan di bi maka pag-inum bi, atawa uk susa bi pasal kalluman bi. Pahalli' kaam bo' kaam 'nsa' taabut magkarupangan bang takka 'llaw pabayik ku. ");
INSERT INTO slm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sabab tagha' du takka 'llaw ian hi', sali' dalil litag bang magsik, bo' tawwa' du aa kamemon ma babaw dunya itu. ");
INSERT INTO slm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pajaga kaam tōōd. Daa kaam parōhōng ngamu' tabang ni Tuhan bang peen niya' kōsōg bi bo' kaam makasandal ma diyōm pakaradjaan ian kamemon. Ngamu' kaam tabang isab bang peen kaam makatampal ni aku, Anak Manusiya', ma 'nsa' niya' kaiyaan bi.” ");
INSERT INTO slm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kahaba'-kahaba' 'llaw mandu' na peen si Isa ma diyōm langgal pagkulbanan, suga' pagsangōm paluwas iya min daira hi' tudju ni Bud Jaitun bo' pahanti' mahi'. ");
INSERT INTO slm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dayi'-llaw le' pay'an na peen manga aa kamemon ni langgal pagkulbanan ian pake ma pandu' na. ");
INSERT INTO slm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, sikōt na paghinang manga Yahudi, waktu pagkakan sigam ma tinapay 'nsa' bayi kalamuran pasulig. Hinang ian iyōnan hinang Pangintōman. ");
INSERT INTO slm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Manga imam langkaw maka manga guru ma sara' agama mikil-mikil bang salaingga uk sigam mapatay ma si Isa ma 'nsa' niya' makatau. Sabab tiyāw sigam ma manga aa mahadjana'. ");
INSERT INTO slm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Manjari pasōd nakura' sayitan ni diyōm pikilan si Judas. Iya na si Judas Iskariyut, dakayo' mulid si Isa min sangpu' ka duwa. ");
INSERT INTO slm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pahi' na iya ni manga imam langkaw maka ni manga nakura' ma jaga langgal pagkulbanan, bo' sigam bo na mag-isun bang salaingga uk na ngakkal ma si Isa sampay nongan iya ni sigam. ");
INSERT INTO slm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kiyōgan sigam tōōd bo' nganjanji' sigam namba iya maka sin. ");
INSERT INTO slm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ngaho' magtuwi si Judas bo' nagna' iya meha waktu hap panong na si Isa ni sigam ma 'nsa' kitauhan uk kahekahan aa. ");
INSERT INTO slm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Manjari taabut na hinang, iya pagkakan sigam tinapay 'nsa' bayi kalamuran pasulig. Iya na ian 'llaw panumbay manga aa ma anak bili-bili, iya kiyakan uk sigam pangintōman sigam ma masa bayi kapamuwas Tuhan ma ka'mbo'-mboan sigam min kamatay ma hi' ma lahat Misil. ");
INSERT INTO slm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Siyoho' uk si Isa si Petros maka si Yahiya, uk na, “Pahi' kaam magsakap kiyakan kitabi ma hinang Pangintōman.” ");
INSERT INTO slm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Uk sigam ma iya, “Tuwan, ma ayi kabayaan nu panakapan kami?” ");
INSERT INTO slm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Uk na ni sigam, “Makasōd peen kaam ni diyōm daira iyu, makasampang du kaam ma dakayo' lalla mo kibut lōōnan bohe'. Turulun bi iya ni luma' pasōran na, ");
INSERT INTO slm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bo' uk bi ma aa dapu luma', ‘Siyoho' kau tīyaw uk guru hi' bang maingga kono' bilik pagtipunan na maka manga mulid na?’ ");
INSERT INTO slm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jari pindaan du kaam bilik loha ma diyata' angkap,” uk si Isa. “Panyap asal bilik ian. May'an kaam magsakap kiyakan kitabi.” ");
INSERT INTO slm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jari pahi' na sigam. Tanda' uk sigam mahi' sali' bayi pama' si Isa ma sigam bo' siyakapan uk sigam kiyakan ma hinang Pangintōman. ");
INSERT INTO slm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taabut peen waktu pagjamu, ningko' na si Isa maka manga aa bayi kawakilan na bo' iyampa sigam magkakan. ");
INSERT INTO slm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jari halling iya ni sigam, uk na, “Iya na itu asal kabayaan ku tōōd subay magsawu maka kaam mangan jamu Pangintōman itu, dahu min waktu kalabay ku kabinsanaan. ");
INSERT INTO slm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabab baan ta kaam, puwas itu 'nsa' na aku mangan jamu itu pabing. Subay magmaksud tōōd in hatihan pagjamu itu ma diyōm pagparinta Tuhan bo' iyampa kakan ku pabing.” ");
INSERT INTO slm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Manjari killo' uk na dakayo' sawan. Iyamuan uk na pagsukulan bo' iyampa halling iya ma sigam. “Sambutun bi inuman itu,” uk na, “bo' inumun bi. ");
INSERT INTO slm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sabab baan ta kaam, puwas minnitu 'nsa' aku nginum inuman anggul itu sataggōl 'nsa' le' pabōtang pagparinta Tuhan ma manusiya'.” ");
INSERT INTO slm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Puwas hi' killo' uk na tinapay. Iyamuan uk na pagsukulan bo' iyampa pighopo'-hopo' uk na bo' pamuwan na ma manga mulid na. “Tinapay itu baran ku ko', iya pamalilla' ku ma pasal bi. Hinangun bi itu hi' pangintōman bi aku.” ");
INSERT INTO slm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Damikkiyan na isab, pag-ubus sigam mangan, pamuwan uk na inuman ma sigam. “Inuman itu,” uk na, “tanda' kapagsulutan Tuhan maka manusiya' iya hinang na bahu itu. Bo' tatuman du pagka pitumpa laha' ku ma sabab bi. ");
INSERT INTO slm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Suga' 'ndaun bi,” uk si Isa, “iya aa song nongan aku ni banta ku, tiya' ma itu magsawu maka aku. ");
INSERT INTO slm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sabab aku, Anak Manusiya' itu, matay du sali' asal pangangganta' Tuhan ma aku. Suga' siya-siya du aa nongan aku ni banta ku.” ");
INSERT INTO slm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jari magtiyaw-tiyaw manga mulid ian bang sayi min sigam iya magbamba nongan si Isa ni banta na. ");
INSERT INTO slm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, maglugat manga mulid ian bang sayi ma sigam subay pilangkaw. ");
INSERT INTO slm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Suga' uk si Isa ma sigam, “Ma itu ma dunya, manga sultan ma kabangsa-bangsahan magkawasa asal ni manga aa ma deyoan sigam. Maka manga puntuk nakura' ian baya' hiyulmat uk aa mahadjana', in sigam kono' poonan kahapan ma diyōm lahat hi'. ");
INSERT INTO slm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Suga' kaam iyu daa subay magsalaihi'. Iya langkaw tōōd ma kaam subay pasali' bohan na ni siyay katapusan. Maka aa pagnakuraan subay tasoho'-soho' uk pagkahi na. ");
INSERT INTO slm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sayi baha' langkaw? Iya aa ningko' mangan atawa aa magbobohat kiyakan? Iya tantu langkaw iya ningko' mangan. Suga' aku itu, tiya' ma kaam sali' sosohoan bi. ");
INSERT INTO slm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kaam iyu bayi patōtōg ma aku minsan aku ma diyōm kasusahan. ");
INSERT INTO slm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Manjari itu, pagka aku kabuwanan kapatut uk 'Mma' ku mag'ntan parinta ma sosongun, buwanan ku isab kapatut salaihi' ma kaam. ");
INSERT INTO slm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Magbe' du kitabi mangan ma diyōm pagparintahan ku. Patingko' ta du kaam ma paningkoan bangsahan bo' kaam ngahukum ma sangpu' ka duwa bangsa kapanubuan si Israil.” ");
INSERT INTO slm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Manjari halling si Isa ma si Simun Petros. “Simun!” uk na. “Pake kau. Iyamu' kau uk nakura' sayitan siyulayan, kalu kau tabo na ni kalaatan. Iya panulay na ma kau sali' ibarat payi bang tiyahapan bo' pigsaddi buwas na maka hapa na. ");
INSERT INTO slm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Suga' bayi na kau amuan ku tabang ni Tuhan, Simun, bang peen 'nsa' pinda pangandōl nu ma aku. Tayikutan nu du aku, suga' bang kau pabing ni aku subay kau matōtōg iman manga dawuranakan nu.” ");
INSERT INTO slm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Uk si Petros, “Tuwan Nakura', 'nsa' kau tayikutan ku. Bang kau ganta' jinil, parōngan du aku ma kau. Bang kau piyatay, lilla' du aku paunung ma kau.” ");
INSERT INTO slm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Uk sambung si Isa, “Baan ta kau, Petros, ma sangōm itu ma 'nsa' le' nigauk manuk, mayilu du kau min tallu in aku 'nsa' katauhan nu.” ");
INSERT INTO slm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Halling le' si Isa ma manga mulid na, uk na, “Iya bayi panoho' ku kaam palangngan magnasihat ian, iya 'nsa' kaam bayi mo pitaka atawa paglutuan atawa tawumpa', niya' baha' bayi kulang ma kaam?” “'Nsa',” uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Suga' buttihi',” uk si Isa, “bang niya' sin bi atawa paglutuan bi, bohun bi na ma palangnganan bi. Maka sasuku 'nsa' niya' patakōs na subay paballihan na badju' na pamalli na kalis. ");
INSERT INTO slm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sabab baan ta kaam, song na maujud lapal kitab iya bayi tasulat ma sabab aku, iya uk na, ‘Talapay iya ma manga aa ngalanggal sara'.’ ” ");
INSERT INTO slm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Uk manga mulid, “'Ndaun, Tuwan, niya' ma itu duwa kalis.” “Sarang na ko' iyu,” uk na. ");
INSERT INTO slm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jari paluwas si Isa min daira tudju ni Bud Jaitun sali' asal kabiyaksahan na, maka me' ma iya manga mulid na. ");
INSERT INTO slm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagtakka na ni papahian na uk na ma sigam, “Ngamu' kaam tabang ni Tuhan bo' kaam 'nsa' tabo-bo uk sasat.” ");
INSERT INTO slm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Puwas hi' palawak-lawak iya min sigam, manga dabantungan lawak na, bo' iya pasujud nambahayang ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Uk na, “O 'Mma', bang kau baya', pakalloin le' min aku kabinsanaan itu. Suga' 'nsa' kabayaan ku subay diyulan, bang peen kabayaan nu du.” ");
INSERT INTO slm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Manjari niya' pasalupa ni iya dakayo' malaikat min sulga' muwanan iya kōsōg panandal na. ");
INSERT INTO slm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na, pagka 'nsa' manjari dukka na, kōsōg gam peen panganjunjung na ni Tuhan bo' mattak-mattak hulas na ni tana', sali' dagbōs laha'. ");
INSERT INTO slm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ubus peen uk na nambahayang, nangge iya bo' pabing pahi' ni manga mulid na bo' tatawwa' na sigam magtuwihan sabab min sukkal sigam. ");
INSERT INTO slm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Uk si Isa ma sigam, “Angay kaam tuwi? Punduk kaam nambahayang bo' kaam 'nsa' tabo-bo uk sasat.” ");
INSERT INTO slm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na, salta' peen si Isa halling le' ni manga mulid na, heka aa takka pay'an. Iya pamean sigam si Judas, dakayo' mulid si Isa min sangpu' ka duwa hi'. Paabut iya magtuwi ni si Isa arak niyum iya. ");
INSERT INTO slm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Suga' halling si Isa ma iya, uk na, “Salaitu baha', Judas, pangakkal nu ma Anak Manusiya'?” ");
INSERT INTO slm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagkitauhan uk manga mulid ma tōngōd si Isa bang ayi song hinang ma iya, tiyaw sigam ma iya, “Tuwan,” uk sigam, “guna kami na baha' kalis kami?” ");
INSERT INTO slm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jari dakayo' mulid ian, liyagut uk na sosohoan imam nakura' bo' lutas magtuwi dambiya' tainga na. ");
INSERT INTO slm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Suga' uk si Isa, “Sarang na ko' iyu.” Jari intanan uk na tainga aa hi' bo' kaulian uk na. ");
INSERT INTO slm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Halling si Isa ni manga aa bayi pay'an naggaw iya, manga imam langkaw maka manga nakura' ma aa magjajaga ma langgal pagkulbanan maka manga kamaasan bangsa Yahudi. Uk na ma sigam, “Kaba' bi ba in aku itu mundu baha', iya poon kaam subay mo kalis maka kakakal? ");
INSERT INTO slm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kahaba'-haba' 'llaw mahi' na peen aku ma diyōm langgal pagkulbanan, suga' 'nsa' aku bayi tasaggaw bi. Lipara iya na itu waktu pisukuan kaam bo' aku tasaggaw bi, maka waktu isab kapag-agi nakura' sayitan.” ");
INSERT INTO slm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Manjari siyaggaw si Isa uk sigam bo' biyo iya minnihi' tudju ni luma' imam nakura'. Si Petros iya paturul ma si Isa min katahan. ");
INSERT INTO slm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Niya' api bayi pidōkōt uk manga sundalu ma halaman luma' imam nakura' bo' parakayo' si Petros ni sigam magtingkoan ma katilibut api hi'. ");
INSERT INTO slm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jari itu, sabu peen iya ningko' ma kasawahan api, tanda' iya uk dakayo' danda ipatan imam nakura'. Piyatong iya pahap-hap uk danda itu, bo' uk na, “Iya du aa itu bayi me' ma si Isa.” ");
INSERT INTO slm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Suga' mayilu si Petros, uk na, “Danda, 'nsa' iya katauhan ku!” ");
INSERT INTO slm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Nsa' taggōl minnihi' niya' dakayo' lalla nganda' ma si Petros hi' bo' uk na, “Iya du kau iyu dambean maka sigam!” Suga' halling si Petros, uk na, “'Nsa', bagay!” uk na, “'Nsa' aku.” ");
INSERT INTO slm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Palabay peen danjam niya' isab aa saddi lōgōs uk na missala, uk na, “Katauhan ku aa itu bayi du sehe' na, sabab aa Jalil isab iya!” ");
INSERT INTO slm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Suga' uk si Petros, “Bagay,” uk na, “'nsa' katauhan ku bang ayi halling nu iyu!” Pag masi le' halling si Petros magtuwi nigauk manuk. ");
INSERT INTO slm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jari palingi' si Isa nganda' ma si Petros bo' taintōm uk si Petros bayi halling si Isa ma iya, iya uk na, “Ma 'nsa' le' nigauk manuk sangōm itu, mayilu du kau min tallu in aku 'nsa' katauhan nu.” ");
INSERT INTO slm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Magtuwi paluwas si Petros minnihi' bo' nangis iya. Magdukka' tōōd. ");
INSERT INTO slm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pigtunggingan si Isa uk manga aa nganjagahan iya, maka pigtibu' iya uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tiyambunan mata na bo' iyampa iya liyata'. “Tōkōrun kono',” uk sigam, “bang sayi nibu' kau!” ");
INSERT INTO slm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Heka le' isab halling-halling sigam pamaiya' sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkallat 'llaw na, magtipun manga kamaasan bangsa Yahudi maka manga kaimaman langkaw maka manga guru ma sara' agama. Jari si Isa biyo paharap ni palhimpunan sigam. ");
INSERT INTO slm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Uk sigam ma iya, “Bain kami tōōd bang kau iya si Almasi.” Nambung si Isa, uk na, “Minsan kaam baan ku 'nsa' du aku pagkahagad bi. ");
INSERT INTO slm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maka bang niya' tiyaw ku ma kaam, 'nsa' du kaam nambung. ");
INSERT INTO slm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Suga' puwas min 'llaw itu aku, Anak Manusiya', ian du ningko' ma bihing Tuhan Sangat Kawasa, sakap ni katau.” ");
INSERT INTO slm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Uk sigam kamemon, “Bang salaihi', Anak Tuhan kau baha'?” Uk sambung si Isa, “Iya na uk bi, aku na.” ");
INSERT INTO slm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jari halling sigam, uk na hi', “'Nsa' na kitabi subay meha saksi' saddi! Sabab makake na kitabi ma halling na itu.” ");
INSERT INTO slm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Manjari manga aa palhimpunan kamemon nangge na min paningkoan sigam bo' biyo si Isa uk sigam paharap ni si Gubnul Pilatu. ");
INSERT INTO slm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pagmay'an peen, tiyuntutan uk sigam si Isa. Uk sigam, “Bayi taabut kami aa itu mo bangsa kami nagga' ma parinta. Tasoho' na manga aa daa subay mayad sukay ni Sultan Mahatinggi. Maglaku-laku isab iya in iya Almasi, hati na iya tapene' uk Tuhan magsultan.” ");
INSERT INTO slm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tiyaw si Pilatu ma si Isa. “Kau iyu,” uk na, “sultan kau baha' ma bangsa Yahudi?” Nambung si Isa, uk na, “Iya na uk nu iyu.” ");
INSERT INTO slm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Uk si Pilatu ni manga kaimaman langkaw maka ni kahekahan aa ian, “'Nsa' niya' tapeha ku sababan pamabōtangan ku iya hukuman.” ");
INSERT INTO slm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Suga' liyōgōs na peen uk sigam, “Pilingōg uk na manga aa ma kalohahan lahat Yahudiya sabab min pamandu' na. Bayi tagnaan na hinang na ma lahat Jalil, manjari tiya' na iya pasampay paitu ni Awrusalam.” ");
INSERT INTO slm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na, pagtake itu uk si Pilatu magtuwi tiyaw na bang min lahat Jalil baha' si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Makatau peen si Pilatu in si Isa min lahat asal ma diyōm pagsultanan si Herod, siyoho' iya biyo ni si Herod hi' sabab ian iya ma Awrusalam pasalta' ma waktu ian hi'. ");
INSERT INTO slm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pag'nda' si Herod ma si Isa kiyōgan iya tōōd sabab taggōl na kabaya' na nganda' si Isa. Heka asal bissala bayi take na pasal si Isa bo' kabayaan na subay nganda' iya sasang na ngahinang manga hinang kawasahan. ");
INSERT INTO slm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hangkan taggōl paniyaw na ma si Isa suga' 'nsa' makasambung si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Manjari manga kaimaman langkaw maka manga guru ma sara' agama pasikōt na pay'an bo' kōsōg uk sigam nuntutan si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Manjari pigtunggingan si Isa uk si Herod maka manga sundalu na, maka hiyalipulu iya uk sigam. Pisammekan iya maka juba umbul dakayo' bo' iyampa siyoho' biyo pabing ni si Pilatu hi'. ");
INSERT INTO slm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, iya na ian 'llaw kapagkahāp si Herod maka si Pilatu. Bayi sigam asal magbanta dahu. ");
INSERT INTO slm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Manjari linganan uk si Pilatu manga kaimaman langkaw maka manga aa pagnakuraan maka manga aa mahadjana'. Siyoho' sigam patipun ni iya. ");
INSERT INTO slm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Uk na ma sigam, “Bayi bo bi aa itu ni aku, pagka halling bi in iya mo manga aa subay nagga' ma parinta. Bayi na iya paliksa' ku ma itu ma panganda' bi suga' 'nsa' aku makatawwa' dusa ma iya sali' panuntutan bi iya. ");
INSERT INTO slm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Iya du si Herod, 'nsa' niya' dusa tatawwa' na sabab tasoho' na iya biyo pabayik paitu ni kitabi. Pasti' ko' itu, 'nsa' niya' laat bayi tahinang uk aa itu pamabōtangan iya hukuman ni kamatay. ");
INSERT INTO slm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hangkan soho' ku sadja iya liyapdōsan bo' iyampa pilappa.”  ");
INSERT INTO slm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hangkan salaihi' halling si Pilatu sabab iya kabiyaksahan na kahaba' tahun, bang maghinang manga Yahudi ma hinang Pangintōman, subay iya malappa dakayo' pilisu. ");
INSERT INTO slm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Makake peen manga katipunan aa ma halling si Pilatu, magtuwi sigam ngallang kamemon. Uk sigam, “Papatayun aa iyu! Si Barabbas iya kabayaan kami pilappa.” ");
INSERT INTO slm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabbas itu bayi jinil ma sabab hiluhala' bayi hinang na ma daira Awrusalam, maka ma sabab hinang na mono' aa. ");
INSERT INTO slm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jari si Pilatu, pagka baya' malappa si Isa, missala pabayik ni manga aa hi'. ");
INSERT INTO slm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Suga' ngallang sadja sigam, uk sigam, “Lansangun iya ni hag! Lansangun iya ni hag!” ");
INSERT INTO slm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Halling le' si Pilatu, kamintallu na. “Angay? Ayi bayi hinang na laat?” uk na. “'Nsa' niya' tatawwa' ku sababan na pamapatay ma iya. Soho' ku sadja iya liyapdōsan bo' iyampa pilappa.” ");
INSERT INTO slm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Suga' masi sigam ngōlang pakōsōg. Iya katuyuan sigam subay liyansang si Isa ni diyata' hag. Jari 'nsa' na niya' dapat si Pilatu ian, ");
INSERT INTO slm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","hangkan pabōtang na hukuman ma si Isa sali' pangamu' sigam. ");
INSERT INTO slm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilappa uk na aa iya iyamu' uk sigam piluwas, aa bayi tajil ma sabab panagga' na ma parinta maka ma sabab pamono' na ma aa. Suga' si Isa iya tiyukbalan pahi' bo' tahinang kabayaan sigam. ");
INSERT INTO slm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Manjari itu biyo si Isa uk manga sundalu paluwas minnihi', bo' ma salta' sigam mangngan niya' aa talanggal uk sigam palud min de tudju ni Awrusalam. Ōn na si Simun, aa min lahat Kirini. Liyōgōs iya uk manga sundalu, pitanggungan hag iya song pangalansangan si Isa. Siyoho' iya nanggung min damuwihan si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Heka tōōd manga aa paturul isab ma si Isa, maka niya' isab manga danda magkarukkaan maka magtangis ma sabab na. ");
INSERT INTO slm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Palingi' si Isa nganda' ma sigam bo' uk na, “Kaam manga danda Awrusalam, daa aku panangisin bi. Baran bi iya subay panangisin bi, maka manga anak bi. ");
INSERT INTO slm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sabab niya' ian manga 'llaw takka ma sosongun kapamissala manga aa. Uk sigam ma 'llaw ian, ‘Hap sukud manga danda 'nsa' bayi makapangiram, iya 'nsa' bayi makaanak maka 'nsa' bayi makaparuru' onde'.’ ");
INSERT INTO slm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iya na ian waktu in manusiya' nuknaan du di sigam. Uk sigam, ‘Bang peen paligid ni aku manga bud itu! Bang peen aku katambunan uk manga bud!’ ");
INSERT INTO slm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sabab na,” uk si Isa, “bang laat hinang manusiya' buttihi' ma aa 'nsa' niya' dusa na, iya lagi' na bang niya' aa taga dusa ma 'llaw siyong. Tantu iya liyaat du.” ");
INSERT INTO slm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niya' le' duwangan aa saddi min si Isa biyo uk sigam piyatay, aa bayi makalanggal sara'. ");
INSERT INTO slm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jari pagtakka sigam ni lahat iyōnan “Baung Kok”, na liyansang si Isa uk sigam ni hag bo' iyampa pitangge maka hag na. Liyansang isab manga aa manga langgal sara' hi' ma hag sigam. Dakayo' ian pitangge ma bihing si Isa sakap ni katau maka dakayo' ma sakap na ni kayi. ");
INSERT INTO slm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nabbut si Isa ni Tuhan. “O 'Mma',” uk na, “ampunun manga aa ngalansang aku itu, sabab 'nsa' tahati uk sigam bang ayi hinang sigam.” Maglibut manga sundalu, pigkoot-kootan uk sigam manga sammek si Isa bang sayi karapuhan na. ");
INSERT INTO slm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pasalta' peen magtanggehan may'an manga aa nganda'-nganda' ma si Isa, pig-udju' iya uk manga pagnakuraan bangsa Yahudi. Uk sigam, “Aa itu, tau makalappas aa saddi. Subay iya ngalappasan di na bang sabannal iya si Almasi, iya tapene' uk Tuhan magsultan!” ");
INSERT INTO slm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pigtunggingan isab iya uk manga sundalu. Pasikōt sigam ni iya nongan inuman kisōm pamainum ma iya. ");
INSERT INTO slm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Uk sigam, “Bang kau iyu sabannal sultan manga Yahudi, ngalappasan kau di nu!” ");
INSERT INTO slm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Maka niya' sulat bayi pibōtang ma hag min diyata' kok na. Uk na hi', “Sultan bangsa Yahudi.” ");
INSERT INTO slm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pihalling-hallingan isab si Isa uk dakayo' aa langgal sara' bayi liyansang ian. Uk na, “Kau iya Almasi baha'? Ngalappas kau di nu, bo' kami isab bohun.” ");
INSERT INTO slm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lipara pihallingan iya uk sehe' na, uk na, “Angay? 'Nsa' niya' tāw nu tudju ni Tuhan? Sali'-sali' hukuman ma kitabi tallungan. ");
INSERT INTO slm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Suga' kita duwangan itu, wajib kita subay piyatay salaitu sabab iya na tungbas manga kahinangan tabi. Suga' aa itu, 'nsa' niya' laat bayi tahinang na.” ");
INSERT INTO slm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jari uk na ni si Isa, “O Isa, intōmun aku bang taabut waktu kapagparinta nu na.” ");
INSERT INTO slm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Uk si Isa ma iya, “Bannal iya pama' ku itu ma kau, 'llaw itu du magbe' kita ma lahat Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jari itu, lattu peen 'llaw, ngalindōm mata 'llaw bo' tawwa' lindōm kalohahan lahat hi' sampay ni lisag tallu kohap. ");
INSERT INTO slm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Maka kulambu' bayi pangagpang ma diyōm langgal pagkulbanan ian gese' paruwa. ");
INSERT INTO slm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Manjari ngōlang si Isa pakōsōg, uk na, “O 'Mma', songan ku na nyawa ku ni pangantanan nu.” Ubus peen pahalling na itu, magtuwi bakkat na napas na. ");
INSERT INTO slm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pag'nda' kapitan sundalu ma pakaradjaan ian sanglitan na Tuhan. Uk na, “Bannal aa itu hap asal addat na.” ");
INSERT INTO slm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sampay manga aa magtipun may'an nganda'-nganda', pag'nda' sigam ma bayi paniya' ian, mowe' sigam mappōk-mappōk dagha sigam sabab kamehe susa sigam. ");
INSERT INTO slm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Manga bagay si Isa kamemon sampay manga danda bayi me' paturul ma iya min lahat Jalil le', ian sigam magpanangge min katahan nganda' ma pakaradjaan ian kamemon. ");
INSERT INTO slm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Na, niya' aa may'an iyōnan si Yusup, aa min Arimati dakayo' kalumaan ma lahat Yahudiya. Aa bōntōl asal iya, hap addat-tabiat na. Tuyu' iya ngagad ma waktu pamabōtang parinta Tuhan ma manusiya'. Dakayo' maas iya ma palhimpunan suga' 'nsa' iya bayi makauyun ma kagaraan maka kahinangan sigam pamapatay sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jari pahi' si Yusup itu paalōp ni si Pilatu ngamu' patay si Isa. ");
INSERT INTO slm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pireyo' uk na patay ian min hag bo' siyaput uk na bo' iyampa pibōtang uk na ma diyōm pagkubulan bayi kiyalihan ma diyōm pampang batu. Bahu asal pagkubulan ian, 'nsa' bayi pangubulan. ");
INSERT INTO slm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kohap Jumaat na ma salaihi', song 'llaw Sabtu' sabab song na pasaddōp 'llaw. ");
INSERT INTO slm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Manga danda bayi paturul ma si Isa min lahat Jalil bayi me' isab ma si Yusup hi', bo' tanda' uk sigam kubul maka bang salaingga uk si Yusup mabōtang ma patay na. ");
INSERT INTO slm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jari mowe' na sigam nakap manga laksi' maka 'nsallan pahamut pamalihala' sigam ma mayat na. Taabut peen 'llaw Sabtu' pahali na sigam sali' panohoan sara' agama. ");
INSERT INTO slm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pagkallat 'llaw Ahad bo' subu-subu tōōd, pahi' manga danda hi' ni kubul mo manga laksi' bayi siyakap uk sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagtakka sigam pahi' tanda' uk sigam taplōk batu hi' bayi giyulungan min lowang kubul. ");
INSERT INTO slm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pasōd sigam ni diyōm suga' tanda' uk sigam in mayat si Isa 'nsa' na may'an. ");
INSERT INTO slm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sasaw pikilan sigam ma sabab ian hi'. Sakali niya' nangge ma bihing sigam duwangan lalla, makasilaw kalandu' sammek sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Manjari tiyāw kalandu' manga danda ian hangkan nganda' patondok sadja. Suga' uk duwangan lalla ni sigam, “Angay peha bi aa 'llum ma itu ma diyōm kakubulan manga aa magpatayan? ");
INSERT INTO slm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Nsa' na ma itu si Isa. 'Llum na iya pabayik. Intōmun bi bayi halling na ma kaam, waktu kamahi' na le' ma lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Uk na hi', ‘In aku, Anak Manusiya', siyongan du pahi' ni pangantanan manga aa dusahan bo' liyansang uk sigam ni hag piyatay. Bo' ma katallu 'llaw na, 'llum du aku pabing.’ ” ");
INSERT INTO slm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jari taintōm uk manga danda ian bayi halling si Isa hi', ");
INSERT INTO slm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bo' mowe' sigam min kubul tudju ni luma'. Pima' uk sigam manga pakaradjaan itu kamemon ma manga mulid si Isa kasangpu' kadda, maka ma kamemon manga mulid na kasehean. ");
INSERT INTO slm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iya danda ngalapal itu si Mariyam aa min Magdala, maka si Joanna, maka si Mariyam ina' si Ya'kub, maka manga danda saddi bayi sehe' sigam. Bayi sigam ma'-ma' ni manga aa iya kawakilan uk si Isa pasal bayi tanda' ian. ");
INSERT INTO slm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Suga' manga aa kawakilan itu 'nsa' ngahagad ma lapal sigam sabab kibā' maglegaw sadja. ");
INSERT INTO slm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lipara si Petros nangge bo' paragan ni kubul. Pagtakka na pahi' pakoko' iya pasib, suga' 'nsa' niya' tanda' na ma diyōm, duwal manga saput pabōtangan di na. Jari pakallo' iya minnihi' tudju mowe' maka uk na inu-inu ma bayi pakaradjaan ian. ");
INSERT INTO slm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma 'llaw ian hi' niya' duwangan mulid si Isa mangngan tudju ni kalumaan iyōnan Emmaus, lawak na manga sangpu' kadda batu min Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Maglagtang-lagtang na peen sigam pasal kamemon iya bahu bayi patakka ian. ");
INSERT INTO slm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pasalta' peen sigam maglagtang-lagtang, pay'an si Isa pasikōt ni sigam bo' magdōngan maka sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tanda' iya uk sigam suga' 'nsa' iya takila uk sigam in iya si Isa. ");
INSERT INTO slm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Uk na ma sigam, “Ayi paglagtang-lagtang bi salta' ma paglangngan bi?” Parōhōng sigam magtuwi, maka laat pamayihuan sigam sabab susa. ");
INSERT INTO slm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jari nambung dangan ian, iya iyōnan si Kelopas. Uk na, “Allō! Hangkan du kau ma diyōm daira Awrusalam awam pasal pakaradjaan iya bahu bayi patakka may'an sini', sabab kitauhan asal uk aa kamemon!” ");
INSERT INTO slm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Angay? Pakaradjaan ayi?” uk si Isa. “Iya tahinang ma si Isa, aa Nasaret,” uk sigam. “Si Isa itu nabi asal. Ma pamissala na kamemon maka ma kahinangan na kamemon, taga kawasa asal iya ma panganda' Tuhan maka ma pag'nda' manga aa kamemon. ");
INSERT INTO slm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bayi iya biyō ni gubnul uk manga kaimaman kami langkaw maka uk manga aa pagnakuraan bangsa kami. Biyō iya pahi' supaya iya pibōtangan hukuman ni kamatay, bo' liyansang iya ni diyata' hag bo' piyatay. ");
INSERT INTO slm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na, bayi kami ngahōwat-hōwat tōōd in iya itu dakayo'-kayo' pipaitu uk Tuhan muwasan kami manga tubu' si Israil min kasusahan. Aho', maka 'nsa' pasal ian hi' sadja sabab niya' na tallum bahangi min pamapatay sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maka niya' isab manga danda sehe' kami bayi mohan kami habal makakōbla' sini'. Dayi'-llaw sini' bayi sigam pahi' nganda' ni kubul si Isa, ");
INSERT INTO slm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","suga' 'nsa' na may'an mayat na. Jari pabayik sigam ni kamay'anan kami. Uk sigam isab niya' manga malaikat bayi magpasalupa ni sigam. Bayi halling kono' malaikat hi' in si Isa 'llum na. ");
INSERT INTO slm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sakali niya' manga sehe' kami bayi nganyata' pahi' ni kubul bo' tanda' uk sigam sali' bayi pama' manga karandahan hi'. Suga' si Isa iya 'nsa' tanda'.” ");
INSERT INTO slm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Manjari halling si Isa ni duwangan hi', uk na, “'Ndu', babbal pahap kaam iyu! Angay 'nsa' kahagad bi kamemon bayi pangabtang uk kanabi-nabihan? ");
INSERT INTO slm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sabab bang ma kabtangan sigam in si Almasi wajib subay makalabay kabinsanaan dahu bo' iyampa iya pilangkaw.” ");
INSERT INTO slm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jari pihati duwangan ian uk si Isa kamemon tasulat ma diyōm kitab ma pasal na. Tiyagnaan uk na min manga sulat si Musa, sampay ni manga sulat kanabi-nabihan kamemon. ");
INSERT INTO slm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Makasikōt peen sigam ni kalumaan iya papahian sigam, magbawu'-bawu' si Isa palanjal le'. ");
INSERT INTO slm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Suga' takkoan iya uk sigam. Uk sigam, “Paitu na kau me' ma kami sabab kohap na tōōd. Song sangōm na.” Hangkan pasōd na si Isa me' ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Makatingko' peen iya magsawu maka sigam, killo' uk na tinapay bo' iyamuan uk na pagsukulan ni Tuhan. Puwas hi' pighopo'-hopo' uk na bo' iyampa pamuwan na ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Minnihi' sawa panganda' sigam bo' takila na si Isa uk sigam. Suga' lanyap iya magtuwi min tōngōd sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jari magbissala sigam duwangan. “Hangkan na kita,” uk sigam, “landu' kahōpan sabu peen iya bayi halling ni kita ma palangnganan hi', pagpahati na ma kita pasal kitab.” ");
INSERT INTO slm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nangge sigam magtuwi bo' pabing ni Awrusalam. Pagtakka sigam pahi' tatawwa' uk sigam manga mulid si Isa sangpu' kadda magtipun-tipun maka mulid kasehean. ");
INSERT INTO slm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Uk sigam ma duwangan itu, “'Llum na Panghu' ta pabayik! 'Llum iya tōōd! Bayi na iya paluwas ni si Simun!” ");
INSERT INTO slm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Manjari ma'-ma' isab duwangan itu pasal bayi kalabayan sigam ma daddōk, maka pasal pagkakila sigam ma si Isa ma salta' na maghopo'-hopo' tinapay. ");
INSERT INTO slm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pasalta' peen magbissala duwangan hi', sakali ian si Isa nangge ma tangnga'-tangnga' sigam. Uk na ma sigam, “Bang peen kaam kaniyaan kasannangan.” ");
INSERT INTO slm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kiyōblaan tōōd sigam magtuwi, sabab pangannal sigam in si Isa ian lutaw. ");
INSERT INTO slm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Suga' uk na ma sigam, “Angay kiyōblaan diyōm atay bi? Angay kaam masi magduwa-duwa? ");
INSERT INTO slm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'Ndaun bi manga tangan ku maka nayi' ku itu. Aku na ko' itu. Nanamun bi ba baran ku itu bo' katauhan bi in aku itu 'nsa' lutaw. Sabab lutaw itu 'nsa' niya' baran na maka bōkōg na. Suga' aku itu tanda' bi du niya' baran ku.” ");
INSERT INTO slm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Salaihi' halling na ma sigam. Bo' pandaan na manga tangan na maka nayi' na ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Suga' masi sigam kahunitan magkahagad in ian bannal sabab landu' pahap kakōgan maka kainu-inuhan sigam. Hangkan uk si Isa ma sigam, “Niya' baha' ma itu ayi-ayi kiyakan?” ");
INSERT INTO slm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Siyongan iya uk sigam datti' daying tiyapa. ");
INSERT INTO slm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Killo' uk na bo' kiyakan uk na ma panganda' sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Puwas hi' halling iya ma sigam, uk na, “Iya na ko' itu bayi halling ku ma kaam dahu, waktu kapame' ku le' ma kaam. Uk ku tantu du niya' kamaujuran ma kamemon bayi tasulat ma pasal aku, iya tasulat ma diyōm sara' si Musa maka iya tasulat uk manga kanabi-nabihan, maka manga sulat ma diyōm kitab Jabul. Ayi-ayi patakka itu ma aku, iya na kamaujuran manga sulat sigam.” ");
INSERT INTO slm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Manjari pisawa uk si Isa pikilan sigam bo' supaya tahati uk sigam lapal kitab hi'. ");
INSERT INTO slm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Uk na ma sigam, “Iya na itu asal tasulat ma diyōm kitab: in Almasi subay pinanaman kabinsanaan sampay piyatay. Jari taabut peen katallu 'llaw na min kamatay na 'llum du iya pabing. ");
INSERT INTO slm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Maka bangsa kamemon subay pignasihatan lapal pasal kaampunan dusa. Bang sigam magtawubat sampay ngalabbahan dusa sigam, iyampun du sigam uk Tuhan ma sabab si Almasi. Pagnasihat itu subay tiyagnaan min Awrusalam. ");
INSERT INTO slm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kaam iya bayi makanda' ma ayi-ayi patakka ma aku, jari kaam iya subay muwan saksi'. ");
INSERT INTO slm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Maka aku baran ku iya mabohan kaam bayi panganjanji' 'Mma' ku Tuhan. Suga' daa kaam pakallo' min daira itu sataggōl kaam 'nsa' pihōpan kawasa min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jari biyo sigam uk si Isa paluwas min Awrusalam sampay makaabut na ni kalumaan Betani. Pag-abut sigam pay'an, pitangge uk si Isa tangan na pangamu' na kahapan ma sigam. ");
INSERT INTO slm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pasalta' peen iya ngamu'-ngamu' ni Tuhan, pakallo' iya min sigam bo' tabo iya paangkat ni sulga'. ");
INSERT INTO slm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mudji sigam ma iya may'an bo' iyampa sigam pabing tudju ni Awrusalam. Landu' mehe kalasigan sigam, ");
INSERT INTO slm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","bo' may'an sadja sigam ma langgal pagkulbanan nanglitan Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ma 'nsa' le' niya' dunya asal na Palman, bo' Palman hi' magdakayo' asal maka Tuhan. Tuhan du isab Palman hi'. ");
INSERT INTO slm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sataggōl min katagna' magdakayo' asal Palman maka Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Palman itu, bayi papanjari na kamemon ayi-ayi bo' peen min Tuhan du. 'Nsa' du niya' pipanjari minsan ayi bang 'nsa' min Palman. ");
INSERT INTO slm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Palman hi' asal poonan kallum bo' kallum itu bayi mo kasawahan ni bangsa manusiya'. ");
INSERT INTO slm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sayinag na peen sawa ma diyōm kalindōman, maka kalindōman 'nsa' tōōd makapaddahan iya. ");
INSERT INTO slm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Niya' aa bayi kawakilan paitu uk Tuhan, ōn na si Yahiya. ");
INSERT INTO slm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pipaitu iya ngalapal manga aa pasal sawa hi', supaya makake manga aa kamemon ma lapal Tuhan sampay magkahagad. ");
INSERT INTO slm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'Nsa' si Yahiya baran na bayi muwan sawa. Iya maksud na paitu ni dunya subay mahati pasal sawa hi'. ");
INSERT INTO slm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iya na itu sawa bannal, iya sawa paitu ni dunya masawa diyōm pikilan manusiya' kamemon. ");
INSERT INTO slm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Manjari Palman itu bayi ma dunya, maka dunya itu bayi pipapanjari asal uk na. Suga' 'nsa' iya takila uk manga aa ma dunya. ");
INSERT INTO slm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bayi iya paitu ni lahat na suga' 'nsa' iya tatayima' uk bangsa na. ");
INSERT INTO slm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lipara sasuku bayi nayima' Palman itu sampay magkahagad ma iya, buwanan na sigam kapatut bo' supaya sigam manjari anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tahinang sigam anak Tuhan suga' 'nsa' ma sali' pag-anak manusiya' atawa min kabayaan manusiya' atawa min napsu manusiya'. Iya hangkan sigam tahinang anak Tuhan sabab min kahandak Tuhan du. ");
INSERT INTO slm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Manjari Palman itu bayi palahil magbaran manusiya' paitu ni dunya bo' pabōtang ma diyōman bangsa manusiya'. Jukup asal ma iya ase' maka lasa maka kasabannalan. Tanda' kami barakat na maka sahaya na, iya asal palsukuan na pagka Anak Tuhan iya dakayo'-kayo'. ");
INSERT INTO slm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Yahiya iya bayi missala ma pasal Palman itu. Tanōg halling na, uk na, “Iya na itu bayi pama' ku ni kaam, iya uk ku hi', ‘Niya' paitu damuwi min aku, suga' langkaw le' iya min aku sabab asal na iya ma 'nsa' le' aku bayi iyanak.’ ” Iya na hi' bayi pama' si Yahiya. ");
INSERT INTO slm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pagka Palman itu kaniyaan ase' maka lasa kamemon, hangkan kitabi kamemon pihampitan kahapan maglabi-labi. ");
INSERT INTO slm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Si Musa bayi pamalatunan sara' Tuhan tudju ni manusiya', suga' si Isa Almasi, iya iyōnan Palman Tuhan, pamalatunan ase' maka lasa Tuhan maka kasabannalan. ");
INSERT INTO slm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","'Nsa' niya' bayi makanda' Tuhan suga' pitau kita pasal Tuhan uk Anak na tunggal, iya ma bihing 'Mma' na Tuhan asal na. ");
INSERT INTO slm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","(v 19, 28) Jari itu niya' manga aa pahi' ni si Yahiya sabu na magpandi manga aa ma dambiya' sapa' Joldan, ma jadjahan kalumaan Betani. Dakayo' 'llaw niya' manga imam maka manga sehe' sigam mananabang siyoho' pahi' uk manga nakura' bangsa Yahudi ma daira Awrusalam. Siyoho' sigam pahi' ni si Yahiya niyaw iya bang sayi iya. ");
INSERT INTO slm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Si Yahiya 'nsa' bayi ngalimbu bang tīyaw suga' pasti' sadja sambung na. Uk na, “'Nsa' aku si Almasi.” ");
INSERT INTO slm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Na, sayi kau?” uk sigam. “Si Eliyas baha'?” “'Nsa',” uk si Yahiya. Uk isab manga imam, “Kau baha' dakayo' nabi iya iyagaran uk bangsa tabi Yahudi?” “'Nsa',” uk na. ");
INSERT INTO slm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Manjari halling le' sigam, uk na, “Bain kami tōōd bang sayi kau, sabab kami itu subay mo lapal ni manga aa bayi noho' kami paitu. Ayi uk nu ma pasal baran nu?” ");
INSERT INTO slm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Manjari sali' du sambung si Yahiya maka bayi tasulat uk si Nabi Isaya ma diyōm kitab. Uk sambung si Yahiya, “Aku itu aa ngalingan pakōsōg ma lahat 'nsa' agōn kalluman ayi-ayi. Hawanin bi, uk ku, daddōk palabayan Panghu' tabi.” ");
INSERT INTO slm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Manga aa niyaw itu bayi siyoho' pahi' uk manga Yahudi bal-agama tōōd iya iyōnan Parisi. ");
INSERT INTO slm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jari tīyaw si Yahiya uk sigam pabing, uk sigam, “Na, angay kau hangkan magpandi manga aa bang kau 'nsa' si Almasi atawa si Nabi Eliyas atawa nabi dakayo' iya iyagad-agaran uk bangsa tabi?” ");
INSERT INTO slm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Uk sambung si Yahiya, “Aku itu, bohe' iya pagpandi ku ma manga aa, suga' niya' nangge maiyu ma tangnga' bi dakayo' aa 'nsa' katauhan bi. ");
INSERT INTO slm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Damuwi le' iya min aku, suga' minsan ingkōt tawumpa' na 'nsa' aku tiyōp ngahubaran iya sabab langkaw tōōd iya min aku.” ");
INSERT INTO slm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","(-) ");
INSERT INTO slm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagsubu peen, tanda' uk si Yahiya si Isa pahi' tudju ni iya bo' uk si Yahiya, “Iya na ko' itu dalil bili-bili pamuwan uk Tuhan pagkulban ma sabab manusiya'. Iya iya muwasan paldusahan manusiya' kamemon. ");
INSERT INTO slm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iya na ko' itu bayi pama' ku ma kaam, iya uk ku hi', ‘Niya' aa paitu damuwi min aku. Langkaw le' iya min aku sabab asal na iya ma 'nsa' le' aku iyanak.’ ");
INSERT INTO slm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tagna', 'nsa' iya bayi katauhan ku bang sayi iya. Suga' paitu aku magpandi manga aa ma diyōm bohe' bo' supaya iya pakila ku ni bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","'Nsa' le' iya bayi katauhan ku, parahal aku pipatahan uk Tuhan, iya manoho' aku magpandi manga aa ma diyōm bohe'. Uk na ma aku, ‘Bang tanda' nu Nyawa Sutsi patapu' ma dakayo' aa sampay patōtōg ma iya, aa ian saddi pamandi na ma manusiya' sabab pasangōn na Nyawa Sutsi ma sigam.’ ” Manjari salaitu panaksi' si Yahiya pasal si Isa, uk na, “Bayi na tanda' ku Nyawa Sutsi paruwai min sulga' sali' dagbōs assang. Bayi tanda' ku patapu' maka patōtōg ma si Isa. ");
INSERT INTO slm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bayi na itu tanda' ku tōōd,” uk na, “hangkan kasaksian ku si Isa in iya Anak Tuhan du.” ");
INSERT INTO slm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pag 'llaw dakayo', may'an peen si Yahiya nangge pabayik ma dambiya' sapa' Jordan maka duwangan mulid na, ");
INSERT INTO slm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","tanda' na si Isa palabay. Magtuwi halling si Yahiya, uk na, “Iya ko' ian aa dalil bili-bili min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Take uk duwangan mulid si Yahiya halling na hi', jari paturul sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paglingi' si Isa tanda' na duwangan itu paturul ni iya bo' tīyaw sigam uk na, uk na, “Ayi gawi bi?” Uk sambung sigam, “Tuwan Rabbi (hati na Tuwan Guru), maingga pabōtangan nu?” ");
INSERT INTO slm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uk si Isa, “Dayi' kaam bo' tanda' bi.” (Marayi' manga lisag 'mpat kohap ma waktu ian hi'.) Sakali sigam me' ma iya. Tanda' uk sigam bang maingga pabōtangan na bo' mahi' sigam ma iya sampay ni kasangōman. ");
INSERT INTO slm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ōn dangan bayi paturul ni si Isa ian si Andariyas, danakan si Simun Petros. ");
INSERT INTO slm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Manjari magtuwi si Andariyas meha danakan na hi'. Tatawwa' peen, halling na ni iya, “Tatawwa' kami na si Almasi.” (Almasi itu, hati na aa dakayo'-kayo' tapene' uk Tuhan ngantan parinta na ma manusiya' sampay ngalappasan sigam.) ");
INSERT INTO slm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jari si Simun itu biyo ni si Isa uk si Andariyas. Piyatong iya uk si Isa bo' uk na ma iya, “Kau si Simun anak si Yahiya, suga' ōnan ta kau si Kipas.” (ōn Kipas itu sali' du maka Petros, hati na, “Batu”.) ");
INSERT INTO slm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagsawung peen gara' si Isa pahi' ni lahat Jalil. Tatawwa' na si Pilip mahi' bo' uk na ni iya, “Dayi' kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Pilip itu aa min kalumaan Betsaida, lahat si Andariyas maka si Petros. ");
INSERT INTO slm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Puwas na hi' peha uk si Pilip si Natanael. Tatawwa' na peen, magtuwi baan na si Natanael, uk na, “Tatawwa' kami na aa bayi pipata uk si Musa ma diyōm kitab Tawrat, maka pipata isab uk manga kanabi-nabihan ma diyōm kasulatan sigam. Si Isa iya, anak si Yusup min kalumaan Nasaret.” ");
INSERT INTO slm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“He!” uk si Natanael. “Niya' baha' kahapan paluwas min lahat Nasaret?” Uk si Pilip, “Dayi' kau nganda'.” ");
INSERT INTO slm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pag'nda' si Isa ma si Natanael ian patudju ni iya, uk na, “Aa itu aa Israil tōōd, aa 'nsa' tau ngakkal!” ");
INSERT INTO slm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Uk si Natanael ni si Isa, “Salaingga katau nu aku?” Uk sambung si Isa, “Ma 'nsa' le' kau linganan uk si Pilip bayi kau tanda' ku asal ma deyo' kayu igira.” ");
INSERT INTO slm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nambung si Natanael, uk na, “Tuwan Guru, kau Anak Tuhan. Kau Sultan bangsa Israil.” ");
INSERT INTO slm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tiyaw si Isa ma si Natanael, uk na, “Magkahagad kau baha' ma aku ma sawukat uk ku in kau bayi tanda' ku ma deyo' kayu igira? Ma sosongun niya' du tanda' bi manga hinang ku kalap le' barakat na minnitu.” ");
INSERT INTO slm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Uk na isab ma sigam, “Bannal iya pama' ku itu ma kaam. Ma sosongun makanda' du kaam diyōm sulga' ukab, maka manga malaikat Tuhan magdeyo'-diyata' min aku, Anak Manusiya'.” ");
INSERT INTO slm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Palabay peen duwangallaw niya' magkawin ma kalumaan Kana, mahi' ma lahat Jalil. Hi' ina' si Isa paluruk pahi'. ");
INSERT INTO slm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iya du di si Isa maka manga mulid na bayi killo' paluruk. ");
INSERT INTO slm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jari mahi' ma pagkawinan, ubus na inuman anggul inum uk manga aa maglurukan. Halling ina' si Isa ni iya, uk na, “Ubus na inuman anggul inum uk sigam.” ");
INSERT INTO slm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Uk si Isa ni iya, “Daa na kau susa pasal ian hi', aku du magkatau. 'Nsa' le' taabut waktu pamanda' barakat ku.” ");
INSERT INTO slm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jari biyaan uk ina' si Isa ma manga sosohoan ma luma' ian. “Ayi-ayi panohoan kaam uk si Isa,” uk na, “hinangun bi.” ");
INSERT INTO slm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na niya' 'nnōm pōga batu may'an pangalōōnan bohe' pag-aelan manga aa, sabab iya na addat sigam bangsa Yahudi. Dakayo' pōga ian lōōnan manga lima mital. ");
INSERT INTO slm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Uk si Isa ni manga sosohoan hi', “Pannoin bi manga pōga ian maka bohe'.” Magtuwi pinnoan uk sigam, pigsamaitib maka bo' na. ");
INSERT INTO slm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Puwas na hi' noho' si Isa ma sigam, uk na, “Sawukin bi min pōga iyu, bo' bohun bi ni aa magnakura' ma pagkawinan itu.” Biyo na uk sigam pahi' ni nakura', ");
INSERT INTO slm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","bo' kinaman uk na inuman anggul bayi bohe'. 'Nsa' katauhan na bang minningga inuman anggul ian suga' kitauhan asal uk manga sosohoan iya bayi nawuk iya. Pagnanam peen uk nakura', magtuwi linganan na pangantin lalla. ");
INSERT INTO slm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Kamawumuhan na,” uk na, “bang ma pagkawinan, inuman hap iya pamainum dahu ma manga aa maglurukan. Subay heka tainum uk sigam bo' iyampa pamainum inuman kulang hap na. Suga' bang kau,” uk na, “inuman hap iya tawu' nu sampay ma buttihi'.” ");
INSERT INTO slm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iya na itu paltandaan tagna' hinang uk si Isa. Hinang itu uk na mahi' ma Kana, ma lahat Jalil. Pindaan uk na kawasa na, manjari magkahagad ma iya manga mulid na hi'. ");
INSERT INTO slm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Puwas na hi', palud di si Isa pahi' ni daira Kapirnaum. Iya sehe' na magbe' ian ina' na maka manga danakan na maka manga mulid na. Ian sigam pahanti' may'an manga pilam bahangi. ");
INSERT INTO slm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Manjari itu sikōt na waktu paghinang bangsa Yahudi ma hinang Pangintōman, hangkan si Isa patukad ni Awrusalam sabab lahat paghinangan. ");
INSERT INTO slm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagtakka sigam pahi' pasōd iya ni diyōm langgal pagkulbanan. Niya' tanda' na ma diyōm na hi' manga aa magdagang manga sapi' maka manga bili-bili maka manga assang. Tanda' na isab manga aa pagsambian sin ningko' ma bihing lamisahan sigam. ");
INSERT INTO slm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pag'nda' itu uk si Isa, ngallo' iya lubid hinang lalubak bo' diyuy na sigam kamemon paluwas min diyōm langgal sampay isab manga sapi' maka manga bili-bili sigam. Biyaliskat uk na manga lamisahan aa magsasambi' sin, maka pikawukanat uk na sin sigam. ");
INSERT INTO slm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Uk na ni manga aa magdagang assang. “Pakalloun bi dagangan bi min diyōm langgal itu. Daa hinangun bi tabu' langgal itu sabab luma' 'Mma' ku Tuhan!” ");
INSERT INTO slm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pag'nda' manga mulid si Isa ma hinang na itu, taintōm uk sigam iya bayi tasulat ma diyōm kitab, iya uk na, “O Tuhan, landu' tōōd aku tuyu' ma luma' nu, minsan iya makamula ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sakali tīyaw si Isa uk manga nakura' Yahudi. Uk sigam, “Ayi kapatut nu maghinang manga hinang nu iyu? Pandain kami hinang makainu-inu tanda' saksi' in kau taga kapatut.” ");
INSERT INTO slm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nambung si Isa, uk na, “Lubuhun bi langgal itu, bo' bangun ku pabayik ma diyōm tallungallaw.” ");
INSERT INTO slm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Oy!” uk manga nakura' hi'. “Langgal itu, 'mpatpu' maka 'nnōm tahun bayi pangahinang iya. Tabangun nu pabing baha' ma diyōm tallungallaw sadja?” ");
INSERT INTO slm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Malayingkan iya langgal pigbissala uk si Isa 'nsa' langgal ian hi', suga' baran na. ");
INSERT INTO slm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hangkan na, taabut peen waktu kallum si Isa pabayik min kamatay na, taintōm uk manga mulid na bissala na itu. Jari magkahagad sigam sulat kitab maka bissala si Isa. ");
INSERT INTO slm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mahi' peen si Isa ma Awrusalam salta' ma hinang Pangintōman, heka aa magkahagad ma iya pagka tanda' uk sigam manga hinang na makainu-inu. ");
INSERT INTO slm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Suga' si Isa 'nsa' mangandōl baran na ma sigam, sabab katauhan na asal kajarihan sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Minsan 'nsa' niya' matauhan iya, katauhan na asal bang ayi ma diyōm atay manusiya'. ");
INSERT INTO slm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Manjari itu niya' dakayo' nakura' ma manga Yahudi, ōn na si Nikudimus. Aa Parisi asal iya, daginis agama Yahudi. ");
INSERT INTO slm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ma dakayo' sangōm pahi' iya ni si Isa bo' uk na, “Tuwan Guru, katauhan kami in kau dakayo' guru pipaitu uk Tuhan. Sabab 'nsa' kau makahinang manga hinang makainu-inu iya hinang nu iyu, duwal bang kau tiyabangan uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nambung si Isa, uk na, “Bannal iya halling ku itu ma kau, 'nsa' niya' manusiya' makanda' pagparinta Tuhan, duwal bang aa iyanak min duwa.” ");
INSERT INTO slm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Uk si Nikudimus, “Salaingga aa iyanak pabayik bang umul na? Tantu iya 'nsa' makasōd pabayik ni diyōm battōng ina' na bo' iyanak pabayik!” ");
INSERT INTO slm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nambung si Isa, uk na, “Bannal iya halling ku itu ma kau, 'nsa' niya' aa makasōd ni diyōm pagparintahan Tuhan, duwal bang aa iyanak min bohe' maka min Nyawa Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iya iyanak uk manusiya', manusiya' du. Suga' bang aa iyanak pabayik min Nyawa Tuhan tahinang du iya anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Daa kau inu-inu pagka uk ku ma kau in kaam kamemon subay iyanak pabayik. ");
INSERT INTO slm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dalil ta baliyu. Baliyu itu me' paingga-paingga kabayaan na. Take nu bahonos na, suga' 'nsa' katauhan nu bang minningga atawa bang paingga. Salaihi' du isab bang aa iyanak min Nyawa Tuhan, 'nsa' kitauhan bang salaingga pakaniya' na.” ");
INSERT INTO slm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Salaingga kajari na itu?” uk tiyaw si Nikudimus. ");
INSERT INTO slm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nambung si Isa, uk na, “'Nsa' tahati nu baha'? Bo' peen guru kau babantugun ma bangsa ta Israil? ");
INSERT INTO slm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bannal iya halling ku itu ma kau, missala kami pasal ayi-ayi katauhan kami, maka naksi' kami pasal bayi tanda' kami. Suga' kaam iyu, 'nsa' kahagad bi panaksi' kami. ");
INSERT INTO slm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Salaingga uk bi magkahagad ma bissala ku pasal sulga' bang minsan bissala ku pasal dunya 'nsa' pagkahagad bi? ");
INSERT INTO slm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Nsa' niya' bayi makapahi' ni sulga', duwal aku, Anak Manusiya', iya paitu asal duwai min sulga'. ");
INSERT INTO slm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ma masa awwal hi', ma lahat 'nsa' agōn kalluman ayi-ayi, niya' so hinangan di tumbaga bayi iyangkat uk si Musa ma diyata' hag bo' tanda' uk manga aa bayi keket so. Jari sayi-sayi makanda' iya bayi kaulian. Damikkiyan na isab ma sosongun, in aku, Anak Manusiya', iyangkat du ma diyata' hag piyatay.” ");
INSERT INTO slm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jari sasuku mangandōl ma aku piniyaan du kallum kakkal ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mehe tōōd lasa Tuhan ma manusiya', iya poon paglilla' na Anak na tunggal piyatay bo' supaya sasuku mangandōl ma Anak na itu 'nsa' miyulkaan uk Tuhan, suga' kakkal du kallum na sampay ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iya hangkan Tuhan bayi noho' Anak na paitu ni dunya, 'nsa' subay mabōtang hukuman dusa ma manusiya', suga' supaya sigam liyappasan min dusa sigam. ");
INSERT INTO slm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sasuku mangandōl ma Anak Tuhan 'nsa' tawwa' hukuman Tuhan. Suga' sasuku 'nsa' mangandōl, tawwa' sigam hukuman asal sabab 'nsa' sigam bayi mangandōl ma si Isa, iya tunggal anak Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Salaitu iya langnganan hukuman Tuhan: si Isa iya bayi paitu ni dunya masawahan diyōm pikilan manusiya' suga' manusiya' itu 'nsa' baya' ma kasawahan. Iya kabayaan sigam subay kalindōman sabab laat manga hinang sigam. ");
INSERT INTO slm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sasuku maghinang laat bansi tōōd ma kasawahan, maka 'nsa' pasikōt ni kasawahan sabab 'nsa' baya' subay tanda' manga hinang sigam laat. ");
INSERT INTO slm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Suga' sasuku maghinang bōntōl baya' du ni kasawahan supaya tanda' in hinang sigam me' du ma panohoan Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Puwas na hi' pahi' si Isa maka manga mulid na ni lahat Yahudiya. Taggōl-taggōl pame' na ma sigam may'an. Magpandi isab iya manga aa may'an. ");
INSERT INTO slm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Dahu le' min waktu kapanganjil ma si Yahiya, magpandi isab iya manga aa ma lahat Anon, iya ma kasikōtan lahat Salim, sabab heka bohe' mahi'. Heka manga aa magpahi' na peen ni iya supaya sigam piyandi uk na. ");
INSERT INTO slm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jari niya' manga mulid si Yahiya itu magsual maka dakayo' Yahudi pasal addat Yahudi pag-ael. ");
INSERT INTO slm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hangkan na sigam pahi' ni si Yahiya bo' uk sigam ma iya, “Tuwan Guru, taintōm nu baha' aa bayi sehe' nu ma dambiya' sapa' Jordan hi', iya bayi pamissala nu? Na, ian iya magpandi manga aa buttihi'. Pay'an ni iya manga aa kamemon.” ");
INSERT INTO slm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nambung si Yahiya, uk na, “'Nsa' niya' kapatut manusiya' bang 'nsa' Tuhan iya muwanan iya. ");
INSERT INTO slm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kaam iyu makasaksian aku du, bayi na pama' ku in aku 'nsa' Almasi, suga' siyoho' aku parahu min iya nakapan ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bang sawupama niya' magkawin, pangantin lalla iya taga handa. Suga' panōn na, iya nangge ma tōngōd ian pake-ke, kiyōgan asal pagka take na pangantin lalla missala. Salaihi' kahalan na ma kami maka si Isa,” uk si Yahiya. “'Nsa' niya' kulang ma kakōgan ku pagka iya ian take na. ");
INSERT INTO slm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Si Isa iya subay pasong kabantugan na, suga' aku itu subay pakō'-kō' du kabantugan ku.” ");
INSERT INTO slm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iya paitu min sulga' langkaw asal min kamemon. Bang aa min dunya, kahalan dunya sadja iya pagbissala na sabab suku' dunya iya. Suga' iya paitu min sulga' langkaw asal min kamemon. ");
INSERT INTO slm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iya pamandu' na ayi-ayi bayi tanda' na maka take na mahi' ma diyōm sulga', suga' 'nsa' niya' magkahagad ma lapal na. ");
INSERT INTO slm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lipara bang niya' aa magkahagad ma lapal na ngaho' du aa ian in kamemon bissala uk Tuhan asal bannal. ");
INSERT INTO slm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iya pipaitu uk Tuhan, lapal Tuhan iya pamissala na. Hangkan salaihi' sabab pamuwan uk Tuhan Nyawa na ma iya, 'nsa' tōōd niya' kulang na. ");
INSERT INTO slm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lasa Tuhan ma Anak na bo' pamuwan na ma iya kapatut ngantanan kamemon. ");
INSERT INTO slm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sasuku mangandōl ma Anak Tuhan taga kallum kakkal ni kasaumulan. Sasuku 'nsa' mangandōl maka 'nsa' me' ma Anak Tuhan, 'nsa' niya' kallum sigam kakkal suga' taptap du sigam ma mulka' Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jari itu take uk manga Parisi pasal manga aa piyandi uk si Isa hinang mulid na. Labi heka kono' min manga aa iya tahinang mulid uk si Yahiya. ");
INSERT INTO slm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Suga' iya bannal na, 'nsa' si Isa baran na iya magpandi manga aa, duwal manga mulid na.) ");
INSERT INTO slm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na, pagka kitauhan uk si Isa bang ayi halling sigam hi', pakallo' iya maka manga mulid na min lahat Yahudiya bo' pabing ni lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jari subay sigam palabay min tangnga' lahat Samariya. ");
INSERT INTO slm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mahi' peen sigam ma lahat Samariya takka sigam pahi' ni dakayo' daira iyōnan Sikal. Sikōt lahat itu ni tana' bayi pamuwan uk si Ya'kub ni anak na si Yusup ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Niya' ma tana' ian bohe' kiyali bayi pihinang uk si Ya'kub bo' ningko' si Isa ma bihing bohe' ian sabab miyale' iya ma palangnganan na. Lattu na 'llaw ma waktu hi'. ");
INSERT INTO slm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","'Nsa' may'an manga mulid na sabab hi' sigam ni daira malli kiyakan sigam. Sakali itu niya' danda Samariya pay'an nganduk bohe'. Uk si Isa ni iya, “Buwanin kono' aku bohe' inum ku.” ");
INSERT INTO slm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nambung danda, uk na, “Oy, bangsa Yahudi kau! Angay aku pangamuan nu bohe'? Bangsa Samariya aku!” Hangkan salaihi' halling danda sabab bangsa Yahudi 'nsa' baya' ngangguna kapanyapan manga aa Samariya. ");
INSERT INTO slm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nambung si Isa, uk na, “Bang bayi katauhan nu bang ayi pamuwan Tuhan ma manusiya', maka bang sayi aku iya mangamu' bohe' itu ni kau, tantu du kau ngamu' bohe' ni aku. Jari painum ta du kau bohe' makakaallum.” ");
INSERT INTO slm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Tuwan,” uk danda, “minningga pangalloan nu bohe' makakaallum? 'Nsa' niya' panganggayung nu maka lōm pahap pagbohean itu. ");
INSERT INTO slm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bohe' kiyali itu bayi pangamban ma kami uk ka'mbo'-mboan tabi si Ya'kub. Sigam magtayi'-anak sampay manga hayōp sigam bayi nginum min bohe' itu. Palabi baha' kawasa nu min kawasa si Ya'kub hi'?” ");
INSERT INTO slm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nambung si Isa, uk na, “Sasuku nginum bohe' itu, luhay du toho' kallong na pabing. ");
INSERT INTO slm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Suga' sasuku nginum bohe' pamainum ku, 'nsa' tōōd toho' kallong na pabing. Sabab bohe' pamainum ku iya tajari sali' tuburan bohe' nubud ma diyōm atay na, muwanan iya bohe' makakaallum saumul-umul.” ");
INSERT INTO slm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Tuwan,” uk danda, “buwanin aku bohe' iya pama' nu itu bo' 'nsa' toho' kallong ku pabing. Bo' 'nsa' na aku subay paitu nganduk bohe'.” ");
INSERT INTO slm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Pahi' kau, ngallo' halla nu,” uk si Isa, “bo' bohun iya paitu.” ");
INSERT INTO slm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“'Nsa' niya' halla ku,” uk sambung danda hi'. Uk si Isa ni iya, “Bannal iya uk nu iyu, 'nsa' niya' halla nu. ");
INSERT INTO slm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sabab min lima kau bayi maghalla suga' iya lalla parakayoan nu buttihi' 'nsa' halla nu. Tawwa' halling nu iyu.” ");
INSERT INTO slm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uk danda, “Tuwan, tasayu ku na in kau nabi. ");
INSERT INTO slm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka'mbo'-mboan kami bangsa Samariya, ma itu ma bud itu iya panambahayangan sigam Tuhan. Suga' kaam manga Yahudi, uk bi subay mahi' ma Awrusalam iya panambahayangan tabi Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Uk si Isa ni iya, “Inda', magkahagad kau ma halling ku itu. Niya' du waktu ma sosongun, bang aa nambahayang ma 'Mma' kitabi Tuhan, 'nsa' ma bud itu atawa mahi' ma Awrusalam iya panambahayangan sigam. ");
INSERT INTO slm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kaam manga aa Samariya, magsambahayang kaam suga' awam kaam bang sayi iya sambahayang bi. Suga' kami bangsa Yahudi, katauhan kami bang sayi iya sambahayang kami, sabab iya manglalappas ma manusiya' paluwas du min bangsa Yahudi. ");
INSERT INTO slm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Suga' takka na waktu iya bayi pangagad, waktu panambahayang 'Mma' tabi Tuhan uk manga aa nambahayang sabannal-bannal. Siyambayahang iya uk sigam min diyōm atay sigam maka min kasabannalan. Salaihi' asal kabayaan 'Mma' tabi Tuhan subay nambahayang ma iya. ");
INSERT INTO slm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mismu Tuhan,” uk si Isa, “nyawa asal, 'nsa' sali' manusiya' taga baran. Maka sasuku nambahayang iya subay nambahayang min diyōm atay sigam maka min kasabannalan.” ");
INSERT INTO slm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uk danda ni si Isa, “Asal katauhan ku, ma sosongun paitu du si Almasi iya pene' uk Tuhan ngantan parinta. Pagpaitu na, patau na du kami pasal kamemon.” ");
INSERT INTO slm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Uk si Isa, “Aku na ko', iya missala itu ma kau.” ");
INSERT INTO slm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sakali takka manga mulid si Isa pabing pahi' bo' inu-inu sigam pagka tanda' uk sigam niya' danda sehe' na magbissala. Suga' 'nsa' niya' min sigam niyaw danda ian bang ayi gawi na, atawa niyaw si Isa bang angay iya magbissala maka danda. ");
INSERT INTO slm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Manjari itu libbahan uk danda ian kibut pagbohean na bo' iyampa iya pabayik pahi' ni kalumaan. Pagtakka na pahi' halling iya ni manga aa may'an. ");
INSERT INTO slm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dayi' na kaam,” uk na. “'Ndaun bi aa bayi maan aku pasal kamemon bayi hinang ku. Iya itu baha' si Almasi?” ");
INSERT INTO slm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jari paluwas manga aa ian min daira bo' mangngan pahi' nganda' si Isa. ");
INSERT INTO slm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na, ma likut peen danda hi', nganjunjung manga mulid si Isa bang peen iya mangan. Uk sigam, “Tuwan, mangan na kau.” ");
INSERT INTO slm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Suga' nambung si Isa, uk na, “Niya' kiyakan ku 'nsa' katauhan bi.” ");
INSERT INTO slm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hangkan manga mulid hi' magtiyaw-tiyaw di sigam, uk na, “Niya' baha' bayi mohan iya kiyakan?” ");
INSERT INTO slm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Uk si Isa ma sigam, “Iya makalassohan aku bang tahinang ku kabayaan Tuhan iya mapaitu aku. Maka subay taubus ku manga hinang iya bayi pamahinang na ma aku. ");
INSERT INTO slm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Niya' bissala bi, iya uk na, ‘'Mpat bulan le' bo' iyampa waktu pag-ani’? Suga' baan ta kaam,” uk si Isa, “taabut na pag-ani. 'Ndaun bi manga aa magpaitu ian. Sali' sigam ibarat buwa' huma tiguma' na, bilang na pig-ani. Hati na sakap na sigam mangandōl ma aku. ");
INSERT INTO slm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sasuku nipun sigam me' ma aku, hap tungbas na. Maka manga aa tipun isab, biyuwanan du sigam kallum kakkal ni kasaumulan. Hangkan sali'-sali' kiyōgan manga aa magtanōm maka aa magtipun. ");
INSERT INTO slm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bannal bissala ian, iya uk na, ‘Saddi aa magtanōm, saddi aa mag-ani.’ ");
INSERT INTO slm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kaam iya bayi soho' ku mag-ani buwa' minsan 'nsa' pagluugan bi. Saddi iya bayi magluug, suga' makahampit du kaam min pagluugan sigam.” ");
INSERT INTO slm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Manjari heka manga aa Samariya min daira Sikal magkahagad ma si Isa ma sabab bayi halling danda, iya uk na, “Biyaan aku uk na pasal kamemon bayi tahinang ku.” ");
INSERT INTO slm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hangkan pagtakka manga aa Samariya pahi' ni si Isa, tikkoan iya uk sigam subay pabōtang le' ma sigam. Jari duwam bahangi iya pahanti' na may'an. ");
INSERT INTO slm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pasalta' peen si Isa may'an heka le' manga aa magkahagad ma iya ma sabab pamandu' na ma sigam. ");
INSERT INTO slm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uk manga aa itu ma danda, “Buttihi' magkahagad na kami ma si Isa, 'nsa' ma sabab pama' nu ma kami suga' ma sabab baran kami na makake ma pamandu' na. Katauhan kami na in iya sabannal-bannal manglalappas ma manga manusiya' ma diyōm dunya itu.” ");
INSERT INTO slm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Puwas peen duwam bahangi kahanti' di si Isa ma daira Sikal hi', pakallo' sigam minnihi' tudju ni lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Niya' asal bayi pamissala si Isa, iya uk na, “Basta nabi, 'nsa' pig-addatan uk manga aa ma lahat na.” ");
INSERT INTO slm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pagtakka di si Isa ni lahat Jalil pasampang ni iya manga aa may'an, sabab bayi sigam ma Awrusalam sabu ma waktu hinang Pangintōman, maka bayi tanda' uk sigam kamemon iya tahinang uk si Isa may'an. ");
INSERT INTO slm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Manjari pabayik si Isa pahi' ni Kana, ma lahat Jalil. Iya na ko' hi' lahat bayi pamindahan na bohe' ni inuman anggul. Sakali itu niya' isab pasabu pahi' dakayo' nakura' min sultan. Anak na lalla hi' saki ma daira Kapirnaum. ");
INSERT INTO slm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagtake nakura' itu in si Isa ma lahat Jalil na, takka bayi min lahat Yahudiya, magtuwi iya pahi' ni si Isa ngamu' iya pahi' ni Kapirnaum makowe' anak na, sabab song na magkamamatay. ");
INSERT INTO slm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Uk si Isa ni iya, “'Nsa' du kaam magkahagad, duwal bang kaam makanda' manga paltandaan hinang pagkainu-inuhan aa.” ");
INSERT INTO slm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uk nakura' ni iya, “'Ndu', Tuwan, me' na kau ma aku baba 'nsa' le' matay anak ku.” ");
INSERT INTO slm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Pahi' le' kau,” uk si Isa. “Kaulian du anak nu.” Kihagad uk nakura' halling si Isa itu bo' pakallo' iya tudju mowe'. ");
INSERT INTO slm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma labayan peen iya, tasampang iya uk manga sosohoan na bo' biyaan iya uk sigam. “Kaulian na anak nu,” uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tīyaw sigam uk na bang lisag pila bayi kowe' saki na bo' uk sambung sigam, “Lisag dakayo' kohap hi' bayi killoan pasu' na.” ");
INSERT INTO slm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jari taintōm uk 'mma' onde' ian iya na tōōd waktu bayi kapahalling si Isa ni iya, iya uk na, “Kaulian na anak nu.” Hangkan na iya sampay manga aa kamemon ma ōkōman na magkahagad na ma si Isa. ");
INSERT INTO slm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Paltandaan si Isa karuwa na itu bayi tahinang uk na pagkainu-inuhan aa ma lahat Jalil, waktu kabayik na pahi' min lahat Yahudiya. ");
INSERT INTO slm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Puwas na hi' patukad di si Isa ni Awrusalam sabab niya' paghinang manga Yahudi mahi'. ");
INSERT INTO slm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, niya' ma Awrusalam ian bohe' danaw, ōn na Betsata bang ma bissala Hibrani. Bohe' itu sikōt ni lawang pagsōd-luwasan daira, iya iyōnan Lawang Bili-bili, maka niya' lima luma'-luma' ma tōngōd ian pagsindungan aa. ");
INSERT INTO slm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na, ma waktu ian hi' heka aa saki magbahakan ma manga pagsindungan ian. Niya' sigam buta, niya' pengka' maka niya' matay ugat na. Iya iyagaran uk sigam magbukal bohe'. ");
INSERT INTO slm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sabab na niya' waktu niya' malaikat min Tuhan paruwai ni bohe' ian bo' magbukal na bohe' hi'. Jari sayi-sayi makarahu pahi' ni diyōm bohe' ubus peen bayi magbukal, kaulian du minsan ayi saki na. ");
INSERT INTO slm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jari itu niya' may'an dakayo' aa taga saki. Tallumpu' na maka walun tahun iya taggōl saki na. ");
INSERT INTO slm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tanda' iya uk si Isa palege may'an, maka katauhan na taggōl asal kasaki aa ian. Jari tiyaw si Isa ma iya, uk na, “Baya' kau kaulian baha'?” ");
INSERT INTO slm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nambung aa sakihan, uk na, “Aho', Tuwan, suga' 'nsa' niya' mohat aku pahi' ni diyōm danaw itu bang pabukal bohe' na. Maka sabu peen aku paelod pahi', niya' parahu min aku.” ");
INSERT INTO slm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Uk si Isa ni iya, “Papunduk kau, bohun palegehan nu bo' kau magtuwi mangngan.” ");
INSERT INTO slm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saruun-duun du kaulian aa ian, magtuwi iya mangngan mo palegehan na. Na, 'llaw ian 'llaw Sabtu', iya 'llaw bangsa Yahudi paghali sigam ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hangkan na, pag'nda' manga nakura' Yahudi ma aa kaulian saki na itu mo palegehan na, uk sigam, “Oy, 'llaw paghali ko' itu! Talanggal nu sara' tabi pagka bohat nu palegehan nu.” ");
INSERT INTO slm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nambung iya ma sigam, uk na, “Iya aa bayi makowe' aku, bayi noho' aku mo palegehan ku, maka soho' na aku mangngan.” ");
INSERT INTO slm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Sayi aa bayi noho' kau?” uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Suga' 'nsa' katauhan na bang sayi sabab heka tōōd manga aa bayi ma hi' ma tōngōd bohe' danaw, maka si Isa bayi pakallo' magtuwi. ");
INSERT INTO slm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Puwas na hi' tatawwa' aa itu uk si Isa, ma diyōm langgal pagkulbanan. Uk si Isa ni iya, “'Ndaun ba, kowe' na saki nu, hangkan kau subay ngalabba na min manga dusa nu. Kalu niya' patakka ni kau kōsōg gam peen laat na.” ");
INSERT INTO slm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Manjari pakallo' aa ian minnihi' bo' pahi' maan manga nakura' Yahudi in si Isa bayi makowe' iya. ");
INSERT INTO slm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hangkan na si Isa liyaat uk manga nakura' Yahudi, sabab kaulian uk na saki aa salta' ma 'llaw paghali. ");
INSERT INTO slm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nambung si Isa ma manga nakura', uk na, “'Mma' ku Tuhan maghinang na peen sampay buttihi', maka damikkiyan na aku subay maghinang isab.” ");
INSERT INTO slm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iya na hi' poon na hangkan manga Yahudi ian luba' na manuyu' gam peen mapatay iya. 'Nsa' ma sabab kalanggal na ma sara' pasal 'llaw paghali, suga' ma sabab uk na isab pasal Tuhan in iya 'Mma' na tōōd, hati na masali' iya di na ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Manjari siyambungan uk si Isa manga nakura' ian, uk na, “Bannal iya pama' ku ma kaam, 'nsa' niya' tahinang ku bang min baran-baran ku. Suga' ayi-ayi tanda' ku hinang uk 'Mma' ku, iya na ian sadja hinang ku. Kamemon hinang uk 'Mma', iya du isab hinang uk Anak. ");
INSERT INTO slm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sabab na kilasahan asal aku uk 'Mma' ku, maka pamatau na isab ma aku kamemon iya hinang na. Ma sosongun isab pahinang na le' ma aku manga hinang labi barakat min manga hinang bayi tahinang ku dahu, bo' inu-inu du kaam kamemon. ");
INSERT INTO slm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","'Mma' ku Tuhan iya makallum manga aa magpatayan. Damikkiyan na aku itu, Anak Tuhan, pakallum ku du isab sayi-sayi kabayaan ku. ");
INSERT INTO slm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Maka 'nsa' 'Mma' ku iya ngahukum manga manusiya', suga' pamuwan na na ma aku kapatut pangahukum ku tōōd manga manusiya' kamemon, ");
INSERT INTO slm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bo' supaya aku pimehe uk aa kamemon, sali' pamehe sigam ma Tuhan. Sayi-sayi 'nsa' magpamehe ma aku, Anak Tuhan, 'nsa' isab magpamehe na 'Mma' ku iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Bannal iya pama' ku itu ma kaam, sasuku makake ma manga pamissala ku maka magkahagad isab ma bayi mapaitu aku, kakkal du kallum na sampay ni kasaumulan. 'Nsa' iya tawwa' hukuman Tuhan ma sabab dusa na, suga' puwas iya min mulka' bo' 'llum iya saumul-umul. ");
INSERT INTO slm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bannal iya pama' ku itu ma kaam,” uk si Isa, “taabut na waktu bayi pangagad. Jari aa kamemon iya 'nsa' le' magkahagad, iya sali' dalil aa magpatayan, kake du sigam ma suwara Anak Tuhan bo' sasuku sigam makake 'llum du. ");
INSERT INTO slm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Mma' ku iya poonan kallum. Maka aku itu poon kallum isab sali' 'Mma' ku du, ma sabab kapatut iya pamuwan na ma aku. ");
INSERT INTO slm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pamuwan na isab ma aku kapatut ngahukum manga manusiya' sabab Anak Manusiya' asal aku. ");
INSERT INTO slm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Daa kainu-inuhin bi halling ku itu,” uk si Isa. “Niya' waktu ma sosongun, manga aa magpatayan kamemon kake du ma suwara ku. ");
INSERT INTO slm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pagtake sigam paluwas du sigam min diyōm kakubulan sigam. Manga aa bayi maghinang hap paluwas du bo' 'llum saumul-umul. Maka manga aa bayi maghinang laat paluwas du bo' tawwa' hukuman Tuhan ma sabab dusa sigam.” ");
INSERT INTO slm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Missala le' si Isa, uk na, “'Nsa' niya' tahinang ku bang min baran-baran ku sadja. Ngahukum sadja aku sali' bayi pima' ma aku uk Tuhan, hangkan bōntōl hukuman ku. Sabab 'nsa' kabayaan ku iya tuyuan ku hinang, suga' kabayaan Tuhan iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bang aku sadja naksian di ku, 'nsa' du aku hiyalap. ");
INSERT INTO slm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Suga' niya' saddi naksian aku, maka katauhan ku du in panaksi' na ma aku bannal sadja.” ");
INSERT INTO slm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Uk si Isa le', “Kaam iyu, bayi soho' bi manga aa bi pahi' ni si Yahiya tiyaw iya, maka bannal bayi pama' na ma pasal ku. ");
INSERT INTO slm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Suga' 'nsa' saksi' min manusiya' iya pasangdōlan ku. Iya hangkan sabbut ku si Yahiya ian bo' supaya taintōm bi bo' kaam liyappasan min hukuman dusa. ");
INSERT INTO slm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Yahiya itu sali' dalil palitaan keyat muwan kasawahan ma pikilan manusiya', maka kaam iyu bayi kaamuhan dayi'-dayi' du ma sawa na, hati na kaamuhan kaam ma pamandu' na. ");
INSERT INTO slm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Suga' niya' saksi' ma aku labi le' kōsōg min panaksi' si Yahiya, hati na manga hinang ku iya bayi pamahinang ma aku uk 'Mma' ku Tuhan. Manga hinang ku itu naksian aku in aku bannal bayi pipaitu uk 'Mma' ku Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Maka 'Mma' ku, iya bayi mapaitu aku, naksi' isab ma pasal ku. Suga' kaam iyu, 'nsa' kaam bayi makake suwara na maka 'nsa' kaam bayi makanda' bayihu' na. ");
INSERT INTO slm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'Nsa' isab bayi pahōp bi lapal na ni diyōm atay bi sabab 'nsa' kaam magkahagad ma aku, iya pipaitu uk na ni dunya. ");
INSERT INTO slm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tuyu' kaam bidda' ngadji' kitab sabab pangannal bi in kaam kaniyaan du kallum kakkal ni kasaumulan basta kaam ngadji'. Suga' kitab itu, aku du bissala peen ma diyōm na. ");
INSERT INTO slm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lipara kaam iyu 'nsa' baya' paitu ni aku supaya kaam kaniyaan kallum kakkal.” ");
INSERT INTO slm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Missala le' si Isa ni manga nakura' Yahudi, uk na, “'Nsa' sanglit min manusiya' iya tuyu' ku. ");
INSERT INTO slm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Suga' katauhan ku bang ayi ma diyōm atay bi maka katauhan ku 'nsa' niya' lasa bi ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Minsan aku paitu maka kapatut ku deyo' bayi min 'Mma' ku, 'nsa' du aku tayima' bi. Suga' bang niya' aa saddi paitu mapatut di na, tayima' bi du iya. ");
INSERT INTO slm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Salaingga uk bi magkahagad ma aku? Sabab baya' kaam siyanglitan uk pagkahi bi manusiya'. Iya 'nsa' tuyu' bi sanglit min Tuhan dakayo'-kayo'. ");
INSERT INTO slm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Daa pikilun bi in aku iya nuntutan kaam ni 'Mma' ku ma 'llaw hukuman. Iya manuntutan kaam si Musa, iya bayi malatunan kaam sara' iya pangahōwatan bi. ");
INSERT INTO slm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bang kaam bayi magkahagad sabannal-bannal ma si Musa, iya du aku kahagad bi du isab, sabab aku iya pigsulat uk na ma diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Suga' salaingga pagkahagad bi ma bissala ku, pagka 'nsa' kahagad bi bayi tasulat si Musa?” ");
INSERT INTO slm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","(v 1, 4) Dakayo' 'llaw, sikōt peen ni waktu paghinang manga Yahudi ma hinang Pangintōman, pahi' si Isa ni dambiya' danaw Jalil, iya iyōnan isab danaw Tibiri. ");
INSERT INTO slm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Heka tōōd manga aa bayi paturul ni iya sabab bayi tanda' uk sigam hinang na kawasahan makowe' ma manga aa taga saki. ");
INSERT INTO slm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Manjari patukad si Isa maka manga mulid na ni bud bo' ningko' sigam mahi'. ");
INSERT INTO slm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(-) ");
INSERT INTO slm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nganda'-nganda' peen si Isa, heka tōōd manga aa tanda' na patudju pay'an ni iya, hangkan tiyaw na si Pilip dakayo' mulid na. Uk na, “Maingga pamallihan ta kiyakan pamakan ta baanan aa itu?” ");
INSERT INTO slm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Salaihi' paniyaw si Isa panulay na ma si Pilip. Bang si Isa baran na, katauhan na asal bang ayi song hinang na. ");
INSERT INTO slm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nambung si Pilip, uk na, “Minsan gadji aa mag-usaha ma diyōm walum bulan 'nsa' du makaballihan tinapay sarang pamakan manga aa itu, minsan datti' sadja pararangan.” ");
INSERT INTO slm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Manjari halling le' dakayo' mulid si Isa saddi, si Andariyas danakan si Simun Petros. ");
INSERT INTO slm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Uk na ni si Isa, “Tiya' ma itu dakayo' onde'-onde' lalla, niya' lima tinapay na maka duwa daying na. Suga' pamagay ta bang itu sadja pamakan ma baanan aa itu?” ");
INSERT INTO slm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Manjari uk si Isa ma manga mulid na, “Sohoun bi manga aa ningko'.” Niya' may'an kaparangan loha bo' magtingkoan sigam kamemon. Niya' sigam limangibu aa bang lalla sadja itung, saddi danda maka onde'-onde'. ");
INSERT INTO slm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Killo' uk si Isa tinapay onde' hi'. Iyamuan uk na pagsukul ni Tuhan bo' iyampa pagbahagian na ma manga aa magtingkoan ian. Damikkiyan na daying, bayi pagbahagian na sigam pila-pila kabayaan sigam. ");
INSERT INTO slm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lasso peen sigam kamemon, halling si Isa ni manga mulid na, uk na, “Tipunun bi kapin na iyu bo' 'nsa' lōpas.” ");
INSERT INTO slm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sakali tipun uk sigam kapin tinapay ian kamemon. Lima du tinapay bayi kiyakan uk manga aa ian, jari sangpu' na ka duwa ambung pinnoan uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pag'nda' manga aa may'an ma paltandaan iya tahinang uk si Isa ian, uk sigam, “Bannal ko' itu, iya na itu nabi asal agaran tabi paitu ni dunya.” ");
INSERT INTO slm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kitauhan uk si Isa in manga aa ian song na naggaw iya bahasa iya liyōgōs magsultan ma sigam, hangkan iya pakallo' magtuwi minnihi' bo' patukad iya didihan na ni bud. ");
INSERT INTO slm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mangalib peen lahat, palud manga mulid si Isa ni bihing danaw. ");
INSERT INTO slm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pasakat sigam ni bayanan bo' pauntas ni dambiya' danaw, tudju ni daira Kapirnaum. Sangōm na, suga' 'nsa' le' si Isa bayi makaabut ni sigam. ");
INSERT INTO slm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kōsōg na baliyu maka nganggoyak na tahik. ");
INSERT INTO slm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Makabusay peen sigam manga lima atawa 'nnōm batu lawak na, tanda' uk sigam si Isa mangngan min kuwit tahik pasikōt na tudju ni bayanan sigam. Jari tiyāw sigam tōōd. ");
INSERT INTO slm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Suga' halling si Isa ni sigam, uk na, “Daa kaam tiyāw. Aku ko' itu.” ");
INSERT INTO slm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Minnihi' sigam baya' masakat iya ni bayanan hi'. Pagsakat peen, magtuwi sakadjap sadja sigam takka ni patudjuhan sigam. ");
INSERT INTO slm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pag 'llaw dakayo', baanan aa bayi ngagad ma dambiya' danaw hi', tasayu na uk sigam dakayo' du bayanan bayi may'an. Kitauhan asal uk sigam in si Isa 'nsa' bayi pasakat pahi' me' ma manga mulid na. Duwal manga mulid sadja bayi pauntas parambiya'. ");
INSERT INTO slm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jari itu niya' manga bayanan saddi bayi min daira Tibiri parunggu' ni kasikōtan bayi pagkakanan sigam tinapay, ubus peen si Panghu' Isa bayi ngamu' pagsukulan ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na, pag'nda' manga aa itu in si Isa maka manga mulid na 'nsa' na may'an, pasakat sigam ni manga bayanan ian bo' numpang tudju ni Kapirnaum meha si Isa. ");
INSERT INTO slm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tatawwa' peen si Isa uk sigam ma dambiya' danaw, uk sigam ni iya, “Tuwan Guru, umay kapaitu nu?” ");
INSERT INTO slm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Uk sambung si Isa, “Bannal iya pama' ku itu ma kaam, iya hangkan aku peha bi sabab lasso kaam uk tinapay, suga' 'nsa' tahati bi paltandaan makainu-inu, iya bayi tahinang ku ian ma panganda' bi. ");
INSERT INTO slm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Daa pagtuyuin bi kiyakan magkaat. Iya pagtuyuan bi subay kiyakan 'nsa' magkaat, iya makallum saumul-umul. Aku, Anak Manusiya', iya muwanan kaam kiyakan itu sabab niya' kapatut pamuwan ma aku uk 'Mma' ku Tuhan, tanda' in aku makasulut atay na.” ");
INSERT INTO slm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Manjari tiyaw manga aa ian ni si Isa, uk sigam, “Na, ayi na peen subay hinang kami bo' tabe' kami kabayaan Tuhan?” ");
INSERT INTO slm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nambung si Isa, uk na, “Iya na itu kabayaan Tuhan subay hinang bi: kaam iyu subay mangandōl ma aku, iya pipaitu uk na.” ");
INSERT INTO slm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Uk sigam ni si Isa, “Paltandaan ayi pandaan nu kami supaya kami magkahagad ma kau? Manga ka'mbo'-mboan tabi ma masa awwal hi' bayi mangan manna mahi' ma lahat 'nsa' agōn kalluman ayi-ayi. Tasulat ko' ian ma diyōm kitab, iya uk na, ‘Bayi sigam buwanan na kiyakan min sulga'.’ Na, kau,” uk sigam ni si Isa, “hinang ayi tahinang nu?” ");
INSERT INTO slm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Uk si Isa ni sigam, “Bannal iya pama' ku itu ma kaam, manna ian, iya kiyakan bayi pamuwan uk si Musa, 'nsa' ihi' di kiyakan min diyōm sulga'. 'Mma' ku, Tuhan, iya muwanan kaam di kiyakan min sulga'. ");
INSERT INTO slm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sabab kiyakan iya pamuwan uk Tuhan itu, iya na aa paitu bayi min sulga', iya muwan kallum ma manusiya'.” ");
INSERT INTO slm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Manjari ngamu' manga aa ian ni si Isa, uk sigam, “Tuwan, sataggōl kami 'llum buwanin kami kiyakan iya pagbissala nu iyu.” ");
INSERT INTO slm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Uk si Isa, “Aku na ko' kiyakan makallum. Sasuku me' ma aku 'nsa' du iya giyōtas pabing. Maka sasuku mangandōl ma aku 'nsa' du toho' kallong na pabing. ");
INSERT INTO slm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bayi na kaam baan ku, minsan aku tanda' bi 'nsa' du kaam magkahagad. ");
INSERT INTO slm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kamemon iya pamasuku' aku uk 'Mma' ku me' du ma aku, maka sasuku me' ma aku 'nsa' du sulak ku. ");
INSERT INTO slm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sabab na iya hangkan aku paitu min sulga' 'nsa' subay ngahinang kabayaan baran ku, suga' kabayaan Tuhan iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iya kabayaan Tuhan subay 'nsa' niya' lungay ku manga aa bayi pamasuku' na ma aku. Gam peen pakallum ku sigam kamemon ma 'llaw katapusan. ");
INSERT INTO slm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sabab na iya kabayaan 'Mma' ku Tuhan ma aa kamemon, sasuku nganda' aku Anak na sampay magkahagad ma aku, subay sigam kaniyaan kallum kakkal ni kasaumulan. Pakallum ku isab sigam ma 'llaw katapusan.” ");
INSERT INTO slm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sakali itu magdugal manga nakura' ian ma pasal halling si Isa hi', iya uk na, “Aku itu kiyakan min sulga'.” ");
INSERT INTO slm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Uk sigam, “Bang kita 'nsa' lupa, aa itu si Isa anak si Yusup! Asal katauhan ta du ina'-mma' na. Jari angay iya halling salaihi', in iya min sulga'?” ");
INSERT INTO slm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nambung si Isa ma sigam. “Parōhōng kaam magdugal,” uk na. ");
INSERT INTO slm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“'Nsa' niya' makapame' ma aku, duwal bang sigam kabuwanan baya' uk 'Mma' ku iya bayi mapaitu aku. Bo' sasuku me' ma aku pakallum ku du ma 'llaw katapusan. ");
INSERT INTO slm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Niya' tasulat ma diyōm kitab kanabi-nabihan salaitu, uk na, ‘Piyanduan du sigam kamemon uk Tuhan.’ Sayi-sayi,” uk si Isa, “pake ma pamandu' 'Mma' ku sampay ningōd, me' du ma aku. ");
INSERT INTO slm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Nsa' isab uk ku niya' manusiya' bayi makanda' 'Mma' ku Tuhan. 'Nsa' niya' bayi makanda' Tuhan, duwal aku iya paitu min Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bannal iya pama' ku itu ma kaam, sasuku magkahagad ma aku niya' kallum na kakkal ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku iya kiyakan makallum,” uk si Isa. ");
INSERT INTO slm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Manga ka'mbo'-mboan bi bayi makakakan manna ma lahat 'nsa' agōn kalluman ayi-ayi ian, suga' hi' na sigam magpatayan. ");
INSERT INTO slm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Suga' in kiyakan min sulga' itu saddi asal. Bang niya' aa mangan iya, 'nsa' du iya magkamatay. ");
INSERT INTO slm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku na kiyakan min sulga', aku na kiyakan makallum. Bang niya' mangan kiyakan itu, 'llum du iya sampay ni kasaumulan. Iya kiyakan pamakan ku manusiya' iya na isi ku. Iya na baran ku paglilla' ku supaya 'llum manga manusiya' kamemon sampay ni kasaumulan,” uk si Isa. ");
INSERT INTO slm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sakali maglugat manga nakura' Yahudi ma sabab pagbissala si Isa ian. Uk sigam, “Aa itu, salaingga kapamuwan na isi na pamakan ma kitabi?” ");
INSERT INTO slm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Uk si Isa ni sigam, “Bannal iya pama' ku itu ma kaam, bang 'nsa' kakan bi isi Anak Manusiya' maka bang 'nsa' inum bi laha' na, 'nsa' niya' kallum bi bannal. ");
INSERT INTO slm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Suga' sasuku mangan isi ku maka nginum laha' ku, kakkal du kallum na sampay ni kasaumulan. Maka pakallum ku iya bang taabut 'llaw katapusan, ");
INSERT INTO slm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","sabab isi ku itu asal kiyakan bannal, maka laha' ku itu inuman bannal. ");
INSERT INTO slm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sasuku mangan isi ku maka nginum laha' ku nōtōg ma aku, maka aku isab nōtōg ma iya. ");
INSERT INTO slm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bayi aku pipaitu uk 'Mma' ku iya asal 'llum, maka 'llum isab aku ma sabab na. Damikkiyan na aa mangan isi ku, 'llum du isab ma sabab ku. ");
INSERT INTO slm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iya na ko' itu kiyakan paitu min sulga',” uk si Isa. “Kiyakan itu 'nsa' sali' bayi takakan uk ka'mbo'-mboan bi ma masa awwal hi', sabab minsan ihi' bayi takakan uk sigam bayi du magpatayan. Suga' kiyakan min sulga' itu, sasuku mangan iya 'llum du sampay ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Bissala itu uk si Isa waktu kapamandu' na ma diyōm langgal mahi' ma Kapirnaum. ");
INSERT INTO slm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Heka manga bean si Isa bayi makake pamandu' na itu bo' uk sigam, “Hunit kalandu' pamandu' itu. 'Nsa' niya' makasandal pake iya.” ");
INSERT INTO slm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","'Nsa' niya' bayi maan si Isa suga' katauhan na asal in pamandu' na ian hi' pighalling-halling uk sigam. Hangkan uk na ni sigam, “Laat baha' atay bi sabab pamandu' ku ian? ");
INSERT INTO slm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, salaingga baha' bang tanda' bi aku, Anak Manusiya', pabing ni lahat bayi kamahian ku? ");
INSERT INTO slm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Baan ta kaam,” uk si Isa, “Nyawa Tuhan iya makallum kitabi. Minsan painay kōsōg manusiya', 'nsa' niya' pus na bang takdil ni pamakallum. Iya bayi pamandu' ku ma kaam makallum sabab luwas ko' ian min Nyawa Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Suga' niya' ma kaam 'nsa' magkahagad ma aku.” Salaihi' halling si Isa sabab katauhan na asal sataggōl min katagna' bang sayi 'nsa' magkahagad ma iya, maka bang sayi song nukbalan iya ni manga banta na. ");
INSERT INTO slm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Halling le' si Isa, uk na, “Iya ko' itu sababan na hangkan uk ku ma kaam, 'nsa' niya' me' ma aku bang 'nsa' 'Mma' ku Tuhan iya muwanan iya baya'.” ");
INSERT INTO slm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pagka salaihi' halling si Isa, heka manga mulid na pakallo' min iya maka 'nsa' na me' ma iya. ");
INSERT INTO slm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hangkan si Isa niyaw ni manga mulid na sangpu' ka duwa. “Na, kaam,” uk na, “baya' kaam pakallo' isab?” ");
INSERT INTO slm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nambung si Simun Petros, uk na, “Tuwan, sayi pamean kami bang 'nsa' kau? Sabab kau du maluwas lapal bissala iya muwan kallum kakkal ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Magkahagad na kami ma kau, maka katauhan kami in kau dakayo'-kayo' Sutsi iya paitu asal min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Uk si Isa ni sigam, “Bayi kaam pene' ku sangpu' kaam maka duwa, suga' niya' dangan min kaam iyu siyōd uk sayitan.” ");
INSERT INTO slm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iya pigbissala ian uk si Isa si Judas anak si Simun Iskariyut. Sabab si Judas itu, minsan iya dakayo' mulid si Isa min mulid na sangpu' ka duwa, tukbalan na du si Isa ni manga banta. ");
INSERT INTO slm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Puwas na hi' maglangngan si Isa ma diyōm lahat Jalil sadja. 'Nsa' iya baya' pahi' ni lahat Yahudiya sabab manga nakura' Yahudi mahi' baya' mapatay iya. ");
INSERT INTO slm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Manjari sikōt na paghinang bangsa Yahudi, waktu paghanti' sigam ma diyōm manga bawung-bawung. ");
INSERT INTO slm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hangkan na halling ni si Isa manga danakan na lalla. Uk sigam, “Hap bang kau pakallo' minnitu. Subay kau pahi' ni lahat Yahudiya supaya tanda' uk manga mulid nu bang ayi hinang nu. ");
INSERT INTO slm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sabab na bang aa baya' bantug, 'nsa' subay limbungan na manga hinang na. Pagka kau iyu maghinang manga hinang makainu-inu itu, subay kau magpatau ni aa mahadjana' kamemon.” ");
INSERT INTO slm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Minsan manga danakan na itu 'nsa' ngahalap ma iya. ");
INSERT INTO slm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nambung si Isa ma sigam, uk na, “'Nsa' le' taabut waktu kapanda' ku. Suga' bang kaam, minsan ayi waktu makajari sadja, ");
INSERT INTO slm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","sabab kaam iyu 'nsa' tawwa' kibansihan uk manga aa ma dunya itu, iya 'nsa' ngisbat Tuhan. Suga' aku, kibansihan aku uk sigam sabab halling ku na peen in manga hinang sigam laat sadja. ");
INSERT INTO slm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pahi' kaam ni Awrusalam ni paghinangan,” uk si Isa ni manga danakan na. “Aku itu 'nsa' le' pahi' ni paghinangan sabab 'nsa' le' waktu ku.” ");
INSERT INTO slm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ubus peen bayi halling na itu, may'an le' iya ma lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Makalikut peen manga danakan na pahi' ni paghinangan, 'nsa' du taggōl mangngan isab si Isa pahi' suga' 'nsa' iya parōngan ma kahekahan aa ian hangkan 'nsa' niya' kitauhan kapahi' na. ");
INSERT INTO slm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pigpeha iya uk manga nakura' Yahudi mahi' ma paghinangan. Magtiyaw sigam bang maingga na iya. ");
INSERT INTO slm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Heka manga aa ma diyōm katipunan ian maghigung-higung ma pasalan si Isa. Uk kasehean, “Aa hap si Isa.” Uk isab kasehean, “'Nsa', sabab diyupang uk na manga aa.” ");
INSERT INTO slm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Suga' 'nsa' niya' makatawakkal missala ma kahekahan ma pasal na sabab tāw sigam ma manga nakura' sigam. ");
INSERT INTO slm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Song peen tōnga' paghinang, pahi' si Isa ni langgal pagkulbanan bo' nagna' iya mandu'. ");
INSERT INTO slm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Inu-inu manga nakura' Yahudi ma pamandu' na. Uk sigam, “Aa itu 'nsa' bayi makapagguru. Minningga baha' pangalloan na pangatau na?” ");
INSERT INTO slm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nambung si Isa ma sigam, uk na, “Pamandu' ku itu 'nsa' min pangatau ku, suga' min Tuhan iya mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bang niya' aa baya' ngahinang kabayaan Tuhan, katauhan na du pamandu' ku itu bang min Tuhan atawa min paghōna'-hōna' ku sadja. ");
INSERT INTO slm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bang aa ganta' missala min hōna'-hōna' na sadja, iya tuyu' na kabantugan ma baran na. Suga' bang tuyu' na kabantugan ma bayi manoho' iya, na, aa ian bōntōl asal maka 'nsa' ngakkal.” ");
INSERT INTO slm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Halling le' si Isa ni manga nakura' ian, uk na, “Bayi kaam kabuwanan sara' uk si Musa, baha'? Suga' 'nsa' niya' min kaam minsan dakayo' mōgbōgan sara' hi'. Angay kaam baya' mapatay aku?” ");
INSERT INTO slm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nambung kahekahan aa, uk sigam, “Kau iyu siyōd uk sayitan! Sayi baya' mapatay kau?” ");
INSERT INTO slm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Uk sambung si Isa, “Min tadda du aku bayi ngahinang hinang makainu-inu pasalta' ma 'llaw Sabtu', 'llaw paghali, bo' kainu-inuhan bi kamemon. ");
INSERT INTO slm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bayi kaam siyoho' uk si Musa subay mag-islam manga anak bi lalla. (Bo' 'nsa' min si Musa aturan itu suga' min ka'mbo'-mboan bi tagna'.) Manjari bang taabut 'llaw pag-islam anak bi lalla, minsan magsalta' maka 'llaw paghali pig-islam du uk bi. ");
INSERT INTO slm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kaam iyu, minsan ma 'llaw paghali, mag-islam du kaam manga anak bi supaya 'nsa' talanggal bi sara' si Musa. Na, angay kaam hangkan ngandugal ma aku pagka pakowe' ku saki aa ma 'llaw paghali isab? ");
INSERT INTO slm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Daa kaam magtuwi magpikil in aku aa laat ma sawukat 'nsa' kaam kaamuhan hinang ku. Gam peen pabōntōlan bi pamikil bi.” ");
INSERT INTO slm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Manjari niya' manga aa Awrusalam magbissala, uk sigam, “Iya na itu baha' aa peha uk manga nakura' piyatay? ");
INSERT INTO slm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","'Ndaun bi,” uk sigam. “Tiya' iya missala ma kahekahan suga' 'nsa' iya siyagga' uk manga nakura'. Katauhan sigam marayi', in iya bannal si Almasi? ");
INSERT INTO slm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Suga' bang si Almasi takka paitu, 'nsa' du kitauhan bang minningga iya. Parahal aa itu, katauhan tabi kamemon bang minningga.” ");
INSERT INTO slm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mandu' peen si Isa ma diyōm langgal pagkulbanan, pitanōg suwara na, uk na, “Bannal kaam? Katauhan bi aku baha'? Katauhan bi baha' bang minningga aku? 'Nsa' aku bayi paitu min kabayaan ku sadja. Siyoho' aku paitu uk Tuhan, iya 'nsa' magputing. 'Nsa' iya katauhan bi, ");
INSERT INTO slm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","suga' aku,” uk si Isa, “tau du aku ma iya sabab minnihi' asal aku, maka iya iya bayi noho' aku paitu.” ");
INSERT INTO slm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Manjari nulay sigam naggaw iya, suga' 'nsa' niya' minsan makaantanan iya sabab 'nsa' le' taabut waktu pamapatay iya. ");
INSERT INTO slm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lipara heka aa may'an magkahagad ma si Isa. Uk sigam, “Iya na itu Almasi sabab 'nsa' niya' makahinang hinang kawasahan palabi le' heka na min manga hinang si Isa itu.” ");
INSERT INTO slm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Manjari take uk manga Parisi bang ayi pighigung-higung uk kahekahan aa ian ma pasal si Isa, hangkan sigam maka manga imam nakura' noho' manga jaga langgal pahi' naggaw iya. ");
INSERT INTO slm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Missala si Isa ni manga aa magtipunan ian, uk na, “'Nsa' na aku taggōl ma itu ma kaam. Song na aku mowe' pahi' ni bayi noho' aku paitu. ");
INSERT INTO slm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Peha bi du aku, suga' 'nsa' aku tatawwa' bi sabab 'nsa' kaam makaturul ni papahian ku ian.” ");
INSERT INTO slm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Manjari magbissala manga nakura' Yahudi, uk sigam, “Paingga baha' aa itu hangkan iya 'nsa' tatawwa' tabi? Pahi' iya baha' ni kalahatan Girik, iya paglahatan bangsa tabi kasehean? Pahi' iya baha' manduan manga bangsa Girik? ");
INSERT INTO slm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uk na in kitabi meha iya, suga' 'nsa' kono' iya tatawwa' tabi. Maka 'nsa' kita makaturul kono' ni papahian na. Ayi hati na baha' iya uk na hi'?” ");
INSERT INTO slm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Manjari taabut peen 'llaw umbul satu ma paghinang ian, iya 'llaw katangbusan na, nangge si Isa missala. Pitanōg laa suwara na, uk na, “Sasuku kaam toho' kallong bi, paitu kaam ni aku bo' kaam painum ku. ");
INSERT INTO slm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sasuku magkahagad ma aku, ‘niya' paluwas min diyōm atay na sali' dalil bohe' patubud, bohe' makallum’, sali' tasulat ian ma diyōm kitab.” ");
INSERT INTO slm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iya bohe' patubud pigbissala uk si Isa itu, hati na Nyawa Tuhan iya song pamuwan ma manga aa magkahagad ma iya. Suga' ma waktu ian hi' in Nyawa Tuhan 'nsa' le' bayi tapamuwan sabab 'nsa' le' taabut waktu pamehe si Isa uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Makake peen manga aa ma bissala si Isa itu, uk sigam kasehean, “Bannal ko' itu, iya na itu nabi asal agaran kitabi.” ");
INSERT INTO slm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Uk kasehean, “Si Almasi iya.” Suga' saddi halling kasehean. Uk sigam, “'Nsa' Almasi, sabab Almasi 'nsa' min lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uk kitab in Almasi subay panubu' si Sultan Daud, maka subay iyanak ma kalumaan Betlehem sabab iya na lahat si Sultan Daud.” ");
INSERT INTO slm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jari magsaddi pamikil manga aa ma pasalan si Isa. ");
INSERT INTO slm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Niya' sigam baya' naggaw si Isa, suga' 'nsa' niya' minsan makaantan ma iya. ");
INSERT INTO slm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sakali itu pabing na manga jaga bayi siyoho' naggaw si Isa. Tīyaw sigam uk manga Parisi maka manga imam nakura', uk na, “Angay iya 'nsa' tabo bi paitu?” ");
INSERT INTO slm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nambung manga jaga hi', uk sigam, “'Nsa' tōōd niya' aa bayi magpamandu' sali' pamandu' aa ian.” ");
INSERT INTO slm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Uk manga Parisi, “Iya du kaam baha' tarupang uk na? ");
INSERT INTO slm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Niya' baha' ma kami nakura' atawa Parisi magkahagad ma iya? Tantu 'nsa', minsan dakayo'. ");
INSERT INTO slm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Iya sadja magkahagad manga aa mahadjana' itu, aa awam ma pasal sara' si Musa. Hangkan na sigam tawwa' mulka' Tuhan!” ");
INSERT INTO slm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dakayo' Parisi ian si Nikudimus, iya bayi pahi' ni si Isa magbissala maka iya ma waktu sangōm hi'. Uk si Nikudimus itu ni kasehean na, ");
INSERT INTO slm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bang ma sara' tabi 'nsa' kita manjari mabōtangan hukuman ma aa bang 'nsa' bayi pigbissala dahu, supaya kitauhan bang ayi bayi hinang na.” ");
INSERT INTO slm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nambung sigam, uk na, “Oy! Kau isab min Jalil baha'? Nganda' kau ma diyōm kitab. 'Nsa' niya' nabi paluwas min lahat Jalil.”  ");
INSERT INTO slm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Manjari manga aa ian magpowean kamemon. ");
INSERT INTO slm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Suga' si Isa iya patukad pahi' ni Bud Kayu Jaitun. ");
INSERT INTO slm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagdayi' 'llaw peen, pahi' iya pabing ni langgal pagkulbanan. Magpatipun ni iya manga aa heka bo' ningko' iya manduan sigam. ");
INSERT INTO slm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Manjari niya' dakayo' danda biyo ni iya uk manga guru ma sara' agama maka uk manga Parisi. Danda itu bayi taabut magjina. Pitampal iya ma kahekahan aa ian kamemon. ");
INSERT INTO slm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Uk manga Parisi ni si Isa, “Tuwan guru, danda itu bayi taabut magjina. ");
INSERT INTO slm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na, bang ma sara' bayi imbanan kitabi uk si Musa, iya hukuman ma danda salaitu subay biyantung maka batu piyatay. Na, bang ma kau, ayi uk nu?” ");
INSERT INTO slm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Salaihi' pamissala sigam panulay sigam ma si Isa, kalu niya' sā' ma panambung na jari niya' sababan panuntut sigam ma iya. Suga' patondok sadja si Isa nulat ma kuwit tana' maka tong tudlu' na. ");
INSERT INTO slm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na sabu peen iya tiyaw uk sigam, patongas iya bo' uk na ni sigam, “Sayi-sayi kaam 'nsa' taga dusa, wajib iya parahu mantung danda itu maka batu.” ");
INSERT INTO slm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jari patondok iya pabing nulat isab ma kuwit tana'. ");
INSERT INTO slm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagtake peen uk sigam halling si Isa itu, magtuwi sigam pakallo' kamemon dangan maka dangan, tiyagnaan min maas sampay ni kasehean. Hangkan du si Isa tamban may'an, maka danda masi ma bayi pananggehan na. ");
INSERT INTO slm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pagtongas si Isa pabing, uk na ni danda, “Maingga na sigam, Inda'? 'Nsa' niya' mabōtangan kau hukuman?” ");
INSERT INTO slm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“'Nsa' niya', Tuwan,” uk sambung danda. “Na,” uk si Isa, “minsan aku, 'nsa' du aku mabōtangan kau hukuman piyatay. Mowe' na kau pahi' suga' daa kau ngandusa pabing.” ");
INSERT INTO slm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Puwas na hi' missala si Isa ma manga Parisi pabing, uk na, “Aku itu sawa pamasawa diyōm pikilan manusiya'. Sasuku me' ma aku, 'nsa' tōōd mangngan ma diyōm kalindōman sabab niya' ma diyōm pikilan na sawa iya makallum manusiya'.” ");
INSERT INTO slm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Uk manga Parisi ni si Isa, “Kau iyu naksian di nu na. 'Nsa' tahagad saksi' nu bang kau sadja naksian di nu.” ");
INSERT INTO slm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nambung si Isa, uk na, “Minsan aku naksian di ku, mattan asal panaksi' ku sabab katauhan ku du bang minningga aku, maka bang paingga papihian ku. Suga' kaam iyu, 'nsa' katauhan bi bang minningga aku atawa bang paingga aku. ");
INSERT INTO slm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kaam iyu bang niya' hukum bi, aturan manusiya' iya pamean bi. Aku itu 'nsa' ngahukum aa. ");
INSERT INTO slm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Suga' bang aku sawupama ngahukum, bōntōl du hukuman ku sabab 'nsa' aku didi ku iya ngahukum. Duwangan kami ngahukum sabab bine' aku uk 'Mma' ku, iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tasulat ma diyōm sara' bi,” uk si Isa, “bang duwangan iya naksi' bo' mag-uyun panaksi' sigam, magtawwa' na. ");
INSERT INTO slm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jari bannal bissala ku sabab duwa saksi' ku mag-uyun. Naksian aku di ku, maka 'Mma' ku, iya bayi mapaitu aku, naksian aku du isab.” ");
INSERT INTO slm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tīyaw si Isa uk manga Parisi, uk sigam, “Maingga 'mma' nu?” Uk sambung si Isa, “'Nsa' katauhan bi 'Mma' ku, maka aku isab 'nsa' katauhan bi. Sabab bang bayi aku katauhan bi, iya du 'Mma' ku bayi katauhan bi isab.” ");
INSERT INTO slm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bissala itu uk si Isa sabu na magpandu' ma diyōm langgal pagkulbanan, ma tōngōd manga tuung pangahugan sarakka. Suga' 'nsa' niya' kasaggaw iya sabab 'nsa' le' taabut waktu pangangganta' Tuhan ma iya. ");
INSERT INTO slm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Manjari itu biyayikan uk Isa bayi pamissala na ma manga aa ian, uk na, “Song na aku pakallo'. Peha bi du aku suga' 'nsa' aku tatawwa' bi. Matay sadja kaam mo dusa bi. 'Nsa' du kaam makapahi' ni papahian ku.” ");
INSERT INTO slm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hangkan magtiyaw-tiyaw manga nakura' Yahudi, uk sigam, “Mapatay iya di na baha', iya hangkan uk na in kita 'nsa' makapahi' ni papahian na?” ");
INSERT INTO slm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Missala le' si Isa, uk na, “Kaam iyu porol asal ma babaw dunya itu. Bo' aku itu, sulga' iya lahat ku. Kajarihan bi asal min dunya, bo' kajarihan ku 'nsa'. ");
INSERT INTO slm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hangkan kaam baan ku, in kaam matay sadja mo dusa bi. Sabab bang 'nsa' pagkahagad bi bayi halling ku ma pasal baran ku bang sayi aku, tantu kaam matay mo dusa bi.” ");
INSERT INTO slm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Sayi kau tōōd?” uk tiyaw sigam. Nambung si Isa, uk na, “Sali' bayi pama' ku ma kaam sataggōl min katagna'. ");
INSERT INTO slm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Maka heka le' halling ku ma pasal kahalan bi. Heka le' isab dusa bi pamabōtangan ku hukuman. Lipara bannal sadja iya bayi mapaitu aku. Jari ayi-ayi take ku min iya, iya hi' sadja pama' ku ma manga manusiya' ma dunya itu.” ");
INSERT INTO slm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Suga' 'nsa' tahati uk sigam in 'Mma' na Tuhan iya pigbissala itu uk si Isa. ");
INSERT INTO slm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hangkan uk na ni sigam, “Bang aku, Anak Manusiya', taangkat bi na ni diyata' hag, minnihi' katauhan bi in aku baran ku iya pigbissala uk ku. Katauhan bi isab 'nsa' niya' tahinang ku bang min baran-baran ku sadja. Maka ayi-ayi bayi pima' ma aku uk 'Mma' ku, iya hi' sadja pamandu' ku. ");
INSERT INTO slm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taptap nabang ma aku iya bayi mapaitu aku. 'Nsa' du aku pisaran uk na, sabab hinang ku sadja ayi-ayi makasulut iya.” ");
INSERT INTO slm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagtake manga aa ian ma pamissala si Isa, heka sigam mangandōl ma iya. ");
INSERT INTO slm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jari itu halling si Isa ni manga Yahudi magkahagad ma iya. “Bang kaam tuyu' me' ma pandu' ku,” uk na, “mulid ku na kaam sabannal-bannal. ");
INSERT INTO slm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Makatau du kaam bang ingga iya kasabannalan min Tuhan, jari kasabannalan itu iya muwas kaam min pagbanyagaan.” ");
INSERT INTO slm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nambung sigam, uk na, “Oy! Kami itu panubu' si Ibrahim. 'Nsa' du kami bayi tabanyaga' uk sayi-sayi. Angay kau maghalling in kami papuwas du min pagbanyagaan?” ");
INSERT INTO slm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Uk sambung si Isa, “Bannal iya pama' ku itu ma kaam, sasuku magdusa biyanyaga' du uk baya' sigam magdusa. ");
INSERT INTO slm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Banyaga' itu 'nsa' kakkal ma ōkōman aa dapu. Iya kakkal may'an anak na lahasiya'. ");
INSERT INTO slm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hangkan bang Anak Tuhan iya mahawulaya kaam min pagbanyagaan, tantu du kaam hawulaya. ");
INSERT INTO slm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Katauhan ku, panubu' kaam asal si Ibrahim. Suga' baya' kaam mapatay aku sabab 'nsa' tatayima' bi pandu' ku. ");
INSERT INTO slm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iya pamandu' ku ma kaam itu bayi pamatau aku uk 'Mma' ku. Suga' kaam iyu, hinang uk bi manga hinang bayi pamatau ma kaam uk 'mma' bi.” ");
INSERT INTO slm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Uk manga Yahudi, “Si Ibrahim iya pag'mmaan kami.” Uk si Isa, “Bang bayi kaam sabannal manga panubu' si Ibrahim, bayi du tasingōd bi si Ibrahim maghinang manga hinang na. ");
INSERT INTO slm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Suga' kaam iyu baya' mapatay aku ma sawukat pama' ku ma kaam pasal kasabannalan bayi take ku min Tuhan. 'Nsa' si Ibrahim bayi makahinang salaihi'. ");
INSERT INTO slm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iya hinang bi na peen manga hinang 'mma' bi!” Magtuwi nambung manga aa ian, uk sigam, “Hangkan du Tuhan dakayo'-kayo' iya pag'mmaan kami. Maka kami itu manga anak na bannal.” ");
INSERT INTO slm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Uk si Isa, “Bang bayi Tuhan sabannal pag'mmaan bi, bayi du kaam lasahan aku sabab min Tuhan aku hangkan na aku ma itu. 'Nsa' aku bayi paitu min pagnahu'-nahu' ku, suga' pipaitu aku uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Angay 'nsa' tahati bi bissala ku? Iya hangkan 'nsa' tahati bi sabab 'nsa' kaam makatatas pake ma lapal pamandu' ku.” ");
INSERT INTO slm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Uk si Isa le' ni sigam, “Kaam iyu, nakura' sayitan iya pag'mmaan bi, maka baya' kaam subay me' ma kabayaan 'mma' bi. Pamapatay asal iya min katagna'. 'Nsa' iya bayi me' ma kasabannalan sabab 'nsa' niya' bannal ma diyōm kajarihan na. Kabiyaksahan na magputing hangkan iya magputing na peen. Putingan tōōd iya maka poonan iya kaputingan kamemon. ");
INSERT INTO slm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Suga' aku,” uk si Isa, “bannal sadja manga halling ku, iya poon kaam 'nsa' magkahagad ma aku. ");
INSERT INTO slm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","'Nsa' niya' ma kaam makatongan aku dusa. Bannal sadja halling ku. Jari angay aku 'nsa' pagkahagad bi? ");
INSERT INTO slm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bang aa ganta' suku' Tuhan, me' du iya ma pandu' Tuhan. Suga' kaam iyu 'nsa' suku' Tuhan, hangkan kaam 'nsa' baya' me'.” ");
INSERT INTO slm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sakali siyambungan si Isa uk manga nakura' Yahudi hi', uk sigam, “Tawwa' iya bayi uk kami in kau 'nsa' Yahudi. Aa Samariya kau, maka siyōran kau uk sayitan!” ");
INSERT INTO slm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Uk si Isa, “'Nsa' aku siyōd uk sayitan. Aku itu, magpamehe sadja 'Mma' ku, suga' kaam iyu ngahalipulu sadja ma aku. ");
INSERT INTO slm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Nsa' aku meha kapamehehan ku. Niya' saddi meha bo' iya ian tau ngahukum ma manusiya' kamemon. ");
INSERT INTO slm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bannal iya pama' ku itu ma kaam, sasuku me' ma pamandu' ku 'nsa' tōōd matay saumul-umul.” ");
INSERT INTO slm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Na,” uk sigam, “manantuhi kami tōōd in kau siyōd uk sayitan! Minsan si 'Mbo' Ibrahim maka kanabi-nabihan kamemon, bayi du magpatayan. Bo' uk nu 'nsa' magkamatay saumul-umul sasuku me' ma pamandu' nu. ");
INSERT INTO slm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Angay, palabi baha' kawasa nu min kawasa ka'mbo'-mboan kami si Ibrahim? Minsan si 'Mbo' Ibrahim, minsan manga kanabi-nabihan kamemon, bayi du sigam matay. Sayi kau baha' hangkan kau magnahu'-nahu' salaiyu?” ");
INSERT INTO slm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nambung isab si Isa, uk na, “Bang aku sawupama magpamehe di ku, 'nsa' niya' kapusan na. Suga' 'Mma' ku iya magpamehe aku, iya uk bi in iya pagtuhanan bi. ");
INSERT INTO slm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Nsa' minsan katauhan bi Tuhan. Suga' aku iya tauhan iya. Bang sawupama uk ku in aku 'nsa' katauhan Tuhan, na, putingan du aku sali' kaam. Lipara katauhan ku asal Tuhan, maka be' ku manga panohoan na. ");
INSERT INTO slm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ka'mbo'-mboan bi si Ibrahim ian, bayi kiyōgan pagka katauhan na niya' waktu ma sosongun kapanganda' na ma aku paitu ni dunya. Manjari pag'nda' na ma kapaitu ku landu' na iya kiyōgan.” ");
INSERT INTO slm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nambung sigam ma si Isa, uk sigam, “Salaingga kapag'nda' nu maka si Ibrahim? 'Nsa' le' minsan limampu' tahun umul nu.” ");
INSERT INTO slm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Uk si Isa le' ni sigam, “Bannal iya pama' ku itu ma kaam, ma 'nsa' le' si Ibrahim bayi iyanak, asal na aku.” ");
INSERT INTO slm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Manjari manga Yahudi ian ngallo' batu pamantung sigam ma si Isa, lipara palimbu iya bo' paluwas iya min langgal pagkulbanan hi'. ");
INSERT INTO slm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Makalangngan peen si Isa ma palangnganan na, niya' dakayo' lalla tanda' na, aa buta asal min pag-anak na. ");
INSERT INTO slm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tīyaw si Isa uk manga mulid na, uk sigam, “Tuwan guru, angay aa itu buta? Min dusa na atawa min dusa ina'-mma' na?” ");
INSERT INTO slm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Uk sambung si Isa, “Iya kabuta na itu 'nsa' ma sabab dusa na atawa dusa maas na. Iya hangkan iya buta, supaya iya pamanda' kawasa Tuhan bang ganta' makanda' na. ");
INSERT INTO slm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sataggōl niya' 'llaw, subay hinang ta manga hinang Tuhan iya bayi mapaitu aku,” uk si Isa. “Pagtaabut sangōm na, 'nsa' na niya' makapaghinang. ");
INSERT INTO slm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sataggōl ku ma itu ma dunya muwan du aku kasawahan ma pikilan manusiya'.” ");
INSERT INTO slm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Puwas peen itu halling uk si Isa, ngalura' iya ni tana'. Pipaglamugay lura' na maka tana' hinang pesak, bo' peesan uk na ni mata aa buta ian. ");
INSERT INTO slm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Uk si Isa ni aa hi', “Pahi' kau ni danaw Silowam nguwaup.” (Silowam itu niya' maana na, hati na “piyabo”). Manjari pahi' na lalla buta nguwaup. Pagbing na minnihi' makanda' na iya. ");
INSERT INTO slm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tanda' iya uk manga sehe' na dalungan sampay manga aa bayi makanda' iya ngamu' sarakka. Uk sigam, “Iya na itu baha' aa bayi ningko' ngamu' sarakka hi'?” ");
INSERT INTO slm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Uk kasehean, “Aho', iya na ko'.” Uk kasehean isab, “'Nsa'. Iya ngandagbōs sadja maka aa buta hi'.” Suga' baran aa buta halling na, uk na, “Aku na ko' itu.” ");
INSERT INTO slm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Salaingga na hangkan kau makakanda'?” uk tiyaw sigam. ");
INSERT INTO slm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nambung iya, uk na, “Aa iyōnan si Isa bayi ngahinang pesak bo' peesan uk na ni mata ku. Puwas na hi' siyoho' aku pahi' ni danaw Silowam nguwaup. Na, pahi' na aku. Makakuwaup peen aku, magtuwi na aku makanda'.” ");
INSERT INTO slm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Maingga na aa ian?” uk sigam. Uk sambung na, “'Nsa' katauhan ku.” ");
INSERT INTO slm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sakali lalla bayi buta hi' biyo uk manga aa ni manga Parisi. ");
INSERT INTO slm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iya 'llaw kapangahinang pesak uk si Isa maka kapakowe' na mata aa buta hi', 'llaw Sabtu', 'llaw paghali ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Manjari tiyaw aa hi' uk manga Parisi bang salaingga kapanganda' na. Uk na ma sigam, “Bayi iya mabōtang pesak ni mata ku. Puwas na hi' nguwaup aku. Pagkuwaup ku itu magtuwi aku makanda' na.” ");
INSERT INTO slm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Uk manga Parisi kasehean, “Aa ian 'nsa' min Tuhan, sabab talanggal na sara' pasal 'llaw paghali pagka salaihi' hinang na.” Suga' uk kasehean, “Bang aa dusahan, 'nsa' tahinang na sali' manga hinang makainu-inu itu.” Manjari magsaddi-saddi pikilan sigam. ");
INSERT INTO slm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hangkan aa bayi buta ian tīyaw pabing uk sigam, uk na, “Iya halling nu, in mata nu bayi kaulian uk aa ian. Sayi iya, bang ma bistahan nu?” Uk aa bayi buta hi', “Bang ma aku, in iya dakayo' nabi.” ");
INSERT INTO slm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Suga' manga nakura' Yahudi ian 'nsa' ngahagad in aa ian bayi buta asal dahu suga' makanda' na. Hangkan linganan uk sigam ina'-mma' na bo' tīyaw. ");
INSERT INTO slm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Uk manga nakura' ian ni sigam, “Aa itu, anak bi baha'? Bannal na, bayi buta iya asal min kapag-anak ma iya? Salaingga kakanda' na itu?” ");
INSERT INTO slm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Uk manga maas na, “Aho', anak kami ko' itu. Maka bannal isab, buta iya asal min kapag-anak na. ");
INSERT INTO slm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Suga' 'nsa' katauhan kami bang salaingga bayi kakanda' na itu atawa bang sayi bayi makapakowe' mata na. Tīyawun bi iya. Sangpōt iya, tau du iya nambung.” ");
INSERT INTO slm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Salaihi' panambung manga maas lalla hi' sabab tiyāw sigam ma manga nakura' Yahudi. Sabab bayi na maggara' manga nakura' bang niya' aa magsabannal ma si Isa, in iya Almasi min Tuhan, aa ian 'nsa' pisōd ni diyōm langgal. ");
INSERT INTO slm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hangkan uk maas na, “Tīyawun bi iya, sangpōt na iya.” ");
INSERT INTO slm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jari itu aa bayi buta hi' linganan pabayik uk manga nakura' Yahudi. Uk sigam ni iya, “Pasapahan ta kau, saksi' kitabi Tuhan. Katauhan kami in aa bayi makowe' kau ian, dusahan asal.” ");
INSERT INTO slm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nambung aa itu, uk na, “'Nsa' katauhan ku bang taga dusa iya atawa 'nsa'. Suga' iya katauhan ku itu, bayi aku buta bo' makanda' na aku.” ");
INSERT INTO slm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tīyaw iya pabayik uk sigam, uk na, “Ayi bayi hinang na ni kau? Salaingga uk na makowe' mata nu?” ");
INSERT INTO slm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nambung iya, uk na, “Bayi na kaam baan ku suga' 'nsa' take bi. Angay kaam baya' pake pabing? Baya' kaam baha' magguru ma iya?” ");
INSERT INTO slm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pihallingan iya laat uk manga nakura' ian, uk sigam, “Kau mulid na. Kami itu mulid si Musa. ");
INSERT INTO slm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Katauhan kami in si Musa bayi kapalmanan uk Tuhan. Suga' aa ian hi', 'nsa' minsan katauhan kami bang bayi minningga iya.” ");
INSERT INTO slm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nambung aa bayi buta, uk na, “Inu-inu aku ma kaam. 'Nsa' iya katauhan bi bang minningga, suga' makapakowe' iya ma mata ku. ");
INSERT INTO slm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Katauhan tabi in Tuhan 'nsa' ngasip ma aa dusahan. Iya iyasip uk Tuhan bang aa magpamehehan iya maka maghinang kabayaan na. ");
INSERT INTO slm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sataggōl min katagna' dunya, iyamboho' kita makake niya' makapakowe' aa bang bayi buta min kapag-anak na. ");
INSERT INTO slm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bang aa ian 'nsa' min Tuhan, tantu iya 'nsa' makahinang manga hinang salaitu.” ");
INSERT INTO slm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pihallingan iya uk sigam, uk na, “Angay? Dusahan kau min kapag-anak nu sampay ni kamehe nu, bo' panduan nu kami baha'?” Jari piluwas iya min diyōm langgal uk manga nakura' ian. 'Nsa' na pisōd pabayik. ");
INSERT INTO slm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Take peen uk si Isa pasal aa bayi buta ian piluwas min diyōm langgal, magtuwi pahi' si Isa meha iya. Tatawwa' peen, uk si Isa ni iya, “Magkahagad kau baha' ma aa iyōnan Anak Manusiya'?” ");
INSERT INTO slm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nambung aa itu, uk na, “Sayi iya, Tuwan? Bain aku supaya aku magkahagad ma iya.” ");
INSERT INTO slm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Uk si Isa ma iya, “Tanda' nu na iya, maka tiya' na iya magbissala ma kau buttihi'.” ");
INSERT INTO slm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Magtuwi pasujud aa itu ma dahuhan si Isa, bo' uk na, “Tuwan Panghu', magkahagad aku ma kau.” ");
INSERT INTO slm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Uk si Isa, “Hangkan aku paitu ni dunya, supaya papagsaddi ku manga manusiya'. Jari sasuku aa bayi buta makanda' du, maka sasuku bayi makanda' buta du.” ");
INSERT INTO slm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Take peen halling si Isa itu uk manga Parisi kasehean bayi may'an, tiyaw sigam ma iya. Uk sigam, “Kami baha' pahallingan nu sali' hantang buta?” ");
INSERT INTO slm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nambung si Isa, uk na, “Bang kaam buta, hati na bang kaam awam pasal kabayaan Tuhan, 'nsa' du kaam taga dusa. Lipara, pagka uk bi in kaam makanda' du, na, taga dusa le' kaam sabab 'nsa' be' bi kabayaan Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Manjari magparalilan si Isa, uk na, “Bannal pama' ku itu ma kaam, bang niya' aa pasōd ni diyōm kuralan bili-bili, bo' 'nsa' palabay min lawang suga' pasōd min palabayan saddi, aa ian panangkaw maka pangalangpas. ");
INSERT INTO slm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Suga' bang aa pasōd min lawang, iya na ian aa mag-iipat bili-bili. ");
INSERT INTO slm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iyukaban du iya uk tunggu' lawang. Paglingan na ōn manga bili-bili na magkaniya-kaniya, takila suwara na uk sigam bo' bo na sigam paluwas min diyōm kural. ");
INSERT INTO slm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Makaluwas peen, parahu iya bo' paturul manga bili-bili min damuwihan na sabab makapanhid suwara na. ");
INSERT INTO slm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bang aa saddi, 'nsa' du tiyurul uk manga bili-bili suga' lahi sadja sigam sabab 'nsa' tapanhid suwara na uk sigam.” ");
INSERT INTO slm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kissa itu bayi pamaralil uk si Isa ma manga aa ian suga' 'nsa' tahati uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hangkan na halling si Isa ma sigam pabayik, uk na, “Bannal iya pama' ku itu ma kaam, aku itu ibarat lawang palabayan manga bili-bili. ");
INSERT INTO slm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Manga aa bayi paitu dahu min aku sali' aa nangkaw, aa ngalangpas. Suga' 'nsa' sigam taasip uk manga aa suku' ku. ");
INSERT INTO slm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku itu ibarat lawang,” uk si Isa. “Sayi-sayi pasōd labay min aku, lappasan du iya. Hawulaya du iya magsōd-luwas bo' makatawwa' iya kalluman. ");
INSERT INTO slm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bang aa ngalangpas, 'nsa' niya' gawi na paitu saddi min nangkaw maka mapatay maka makaat. Suga' bang aku, iya gawi ku paitu muwan kallum ma manusiya', kallum landu' hap. ");
INSERT INTO slm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku itu,” uk si Isa, “sali' dalil aa dapu bili-bili bang hap bidda' pangipat na ma manga bili-bili na. Aa ian maglilla' matay ma sabab manga bili-bili na. ");
INSERT INTO slm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Suga' bang aa giyadjihan nunggu' ma 'nsa' iya dapu bili-bili, maka 'nsa' 'ntan na ngipat. Hangkan bang niya' tanda' na ero' tawun pasikōt, magtuwi labbahan na manga bili-bili bo' lahi iya minnihi'. Manjari bili-bili ian niya' na kasehean keket, niya' na kasehean lahi. ");
INSERT INTO slm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iya hangkan aa itu lahi sabab giyadjihan sadja iya. 'Nsa' niya' lasa na ma manga bili-bili. ");
INSERT INTO slm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Aku itu,” uk si Isa, “sali' dalil aa taga bili-bili, hap pangipat na ma manga bili-bili na. Kami maka 'Mma' ku mag-intau tōōd. Damikkiyan na aku maka manga aa suku' ku, tau aku ma sigam maka tau sigam ma aku. Maglilla' aku matay ma sabab sigam. ");
INSERT INTO slm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niya' le' manga aa suku' ku saddi minnitu. Ibarat sigam bili-bili ma kuralan saddi. Iya du sigam subay bo ku. Ngasip du sigam ma suwara ku bo' pagdakayo' ku sigam, manjari dakayo' du aa mag-iipat sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kilasahan aku uk 'Mma' ku Tuhan sabab maglilla' aku matay supaya aku pikallum pabing. ");
INSERT INTO slm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'Nsa' niya' taga kapatut mapatay aku, sabab aku iya magkabayaan bang aku matay atawa 'nsa'. Aku iya taga kapatut maglilla' kallum-baran ku, maka aku iya taga kapatut makallum baran ku pabing. Panohoan 'Mma' ku ko' itu ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Makake peen manga aa ma pamissala si Isa ian, magtuwi sigam bahagi' duwa pabayik. ");
INSERT INTO slm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Heka sigam ngupama, uk na, “Aa itu siyōd uk sayitan! Belaw! Angay iya pake bi?” ");
INSERT INTO slm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Suga' uk kasehean, “Bang aa siyōran sayitan 'nsa' iya makabissala sali' pamissala na itu. Maka bang sayitan, 'nsa' tapakanda' na aa buta.” ");
INSERT INTO slm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Manjari pangahaggut na ma timpu ian, maka taabut na waktu paghinang manga Yahudi mahi' ma Awrusalam, iya hinang iyōnan hinang Pagsutsi langgal pagkulbanan. ");
INSERT INTO slm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Si Isa hi' ma diyōm langgal maglangngan-langngan ma iyōnan Sawurung Sulayman. ");
INSERT INTO slm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jari magtipunan manga aa pahi' ni katilibut si Isa. Uk sigam ni iya, “Taggōl le' kau baha' mahati kami bang sayi kau? Bang kau sabannal Almasi, iya tapene' uk Tuhan magparinta ma kami, subay kami baan nu pahantap-hantap.” ");
INSERT INTO slm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nambung si Isa, uk na, “Bayi na kaam baan ku suga' 'nsa' aku bayi pagkahagad bi. Manga hinang ku iya tahinang sabab kawasa min 'Mma' ku, ian hi' matauhan kaam bang sayi aku. ");
INSERT INTO slm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Suga' 'nsa' aku kahagad bi sabab kaam iyu 'nsa' manga bili-bili ku, 'nsa' kaam aa suku' ku. ");
INSERT INTO slm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Manga bili-bili ku ngasip du ma suwara ku. Katauhan ku sigam maka paturul du sigam ma aku. ");
INSERT INTO slm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Buwanan ku sigam kallum kakkal ni kasaumulan. 'Nsa' tōōd sigam butas min Tuhan minsan umay-umay, maka 'nsa' niya' makaragtu' sigam min kōmkōman ku. ");
INSERT INTO slm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bayi sigam pisukuan aku uk 'Mma' ku, maka kawasa iya min kamemon. 'Nsa' niya' makaragtu' manga aa suku' ku min kōmkōman na. ");
INSERT INTO slm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aku maka 'Mma' ku dakayo' du.” ");
INSERT INTO slm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagtake manga aa ma halling si Isa hi', muwa' sigam batu pabing pamantung sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Uk na ni sigam, “Heka hinang hap bayi pandaan ku ni kaam, manga hinang bayi pamahinang aku uk 'Mma' ku Tuhan. Hinang ingga iya kabansihan bi ma manga hinang ku ian, iya hangkan kaam maggara' mantung aku?” ");
INSERT INTO slm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Uk sambung manga aa ian, “'Nsa' ma sabab hinang nu hap iya hangkan kami maggara' mantung kau, suga' ma sabab halling nu pangkal tudju ni Tuhan. Manusiya' sadja kau, bo' peen maglaku-laku kau. Uk nu Tuhan kau.” ");
INSERT INTO slm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Uk si Isa ni sigam, “Na, bayi tasulat ma diyōm kitab sara' bi iya pamissala Tuhan ni manga manusiya'. Uk na, ‘Kaam iyu manga tuhan.’ ");
INSERT INTO slm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na, katauhan tabi in kamemon tasulat ma diyōm kitab 'nsa' tōōd pinda saumul-umul. Na bang Tuhan ngōn tuhan ma manga aa bayi pamuwanan na lapal na, ");
INSERT INTO slm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","iya le' na aku patut iyōnan Anak Tuhan. Sabab aku itu, bayi tapene' uk Tuhan maka pipaitu aku uk na ni dunya. Jari angay uk bi in aku halling pangkal tudju ni Tuhan pagka uk ku in aku Anak Tuhan? ");
INSERT INTO slm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bang aku sawupama 'nsa' ngahinang manga hinang kabayaan 'Mma' ku, daa aku pagkahagarun bi. ");
INSERT INTO slm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Suga' bang tahinang ku du manga hinang ian, minsan 'nsa' kahagad bi halling ku, bang peen kahagad bi sadja manga hinang ku. Sabab minnihi' katauhan bi tōōd maka tahati bi in 'Mma' ku maka aku dakayo' du.” ");
INSERT INTO slm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Magtuwi sigam nulay pabayik naggaw si Isa, suga' papuwas iya min pangantanan sigam. ");
INSERT INTO slm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Puwas na hi' pabing si Isa pahi' ni dambiya' sapa' Jordan, ni bayi pagpandihan manga aa uk si Yahiya. Pabōtang si Isa may'an manga pilam bahangi. ");
INSERT INTO slm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jari heka aa pahi' ni iya. Uk halling sigam, “Si Yahiya 'nsa' bayi makahinang manga paltandaan kainu-inuhan aa, suga' bannal sadja kamemon bayi halling na pasal si Isa.” ");
INSERT INTO slm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bo' heka aa mahi' mangandōl ma si Isa. ");
INSERT INTO slm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Manjari itu niya' ian dakayo' lalla iyōnan si Lasarus tawwa' saki. Pabōtangan na ma kalumaan Betani. Ian isab ma Betani duwangan danakan na danda, si Mariyam maka si Marta. ");
INSERT INTO slm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Mariyam itu numpahan du 'nsallan pahamut ni nayi' si Panghu' Isa maka napuhan nayi' na maka buun na. Na, pagka saki si Lasarus danakan sigam, ");
INSERT INTO slm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","niya' lapal pabo sigam tudju ni si Isa, uk na, “Tuwan, saki bagay nu iya kalasahan nu.” ");
INSERT INTO slm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagtake peen lapal itu uk si Isa, uk na, “Iya kamaujuran na saki si Lasarus ian 'nsa' du kamatay, suga' sanglit tudju ni Tuhan, supaya siyanglitan isab Anak Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, lasa asal si Isa ma tallungan magdanakan ian, di si Marta maka si Mariyam maka si Lasarus hi'. ");
INSERT INTO slm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Suga' pagkatau na in si Lasarus hi' saki, ngagad le' iya duwangallaw mahi' ma pabōtangan na. ");
INSERT INTO slm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Puwas peen duwangallaw hi', uk si Isa ni manga mulid na, “Sung kitabi pabing pahi' ni lahat Yahudiya.” ");
INSERT INTO slm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Uk manga mulid na ni iya, “Tuwan Guru, bahu kau arak bayi pigbantung maka batu uk manga Yahudi bahasa kau piyatay. Bo' magbamba kau pabing pahi'?” ");
INSERT INTO slm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nambung si Isa magparalilan, uk na, “Daa kaam susa. Niya' sangpu' maka duwan jam sawa ma diyōm dangallaw. Bang kita ganta' mangngan ma waktu 'llaw 'nsa' du makarugtul nayi' ta sabab sawa asal dunya. ");
INSERT INTO slm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Suga' bang kita mangngan waktu sangōm makarugtul sadja sabab ma diyōm kita lindōm.” ");
INSERT INTO slm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ubus peen halling si Isa itu, uk na ni manga mulid na, “Si Lasarus bagay tabi ian hi' tatuwi. Suga' pahi' du aku mati' iya.” ");
INSERT INTO slm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Uk manga mulid na ni iya, “Tuwan, pakowe' du iya bang tuwi sadja.” ");
INSERT INTO slm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iya pighalling uk si Isa, hati na matay na si Lasarus, suga' bang ma pangannal manga mulid na tuwi iya sadja pighalling uk na. ");
INSERT INTO slm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hangkan pipasti' uk si Isa halling na, uk na, “Matay na si Lasarus. ");
INSERT INTO slm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hap na aku 'nsa' makamahi' ma Betani ma waktu kasaki si Lasarus, sabab tantu du kaam mangandōl ma aku bang tanda' bi iya hinang ku ma iya. Sung kitabi pahi' ni iya.” ");
INSERT INTO slm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Manjari si Tomas, iya diyanglay si Kambal, halling ni manga pagkahi na mulid si Isa. Uk na, “Sung kitabi. Parōngan kitabi kamemon ma guru bo' kitabi paunung ma iya sampay ni kamatay.” ");
INSERT INTO slm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Takka peen di si Isa ni Betani, biyaan iya 'mpat 'llaw na bayi pangubul si Lasarus. ");
INSERT INTO slm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani itu asal sikōt ni Awrusalam, manga dabatu lawak na, ");
INSERT INTO slm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","jari heka manga aa min lahat Yahudiya maglurukan pahi' ni si Mariyam maka ni si Marta pasal kamatay danakan sigam lalla. ");
INSERT INTO slm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Manjari itu, take peen uk si Marta pasal si Isa iyu na, pahi' iya nampang. Si Mariyam tamban sadja ma diyōm luma'. ");
INSERT INTO slm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Magtawwa' peen si Marta maka si Isa, uk na ni si Isa, “Tuwan Panghu', bang bayi kau maitu 'nsa' du bayi matay danakan ku! ");
INSERT INTO slm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Suga' katauhan ku, minsan ma buttihi', diyulan du kau uk Tuhan ma ayi-ayi amu' nu.” ");
INSERT INTO slm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Uk si Isa ni iya, “'Llum du danakan nu pabing.” ");
INSERT INTO slm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Uk si Marta, “Aho' Tuwan, katauhan ku du. Papunduk du iya ni kallum ma 'llaw katapusan.” ");
INSERT INTO slm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Uk si Isa ni iya, “Aku iya magpakallum manga aa magpatayan, maka aku iya poonan kallum. Sayi-sayi mangandōl ma aku 'llum du iya minsan iya matay na. ");
INSERT INTO slm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sasuku isab 'llum bo' mangandōl ma aku, 'nsa' magkamatay ni kasaumulan.” Manjari tiyaw si Isa ni si Marta, uk na, “Magkahagad kau baha'?” ");
INSERT INTO slm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Aho', Panghu' ku,” uk si Marta, “magkahagad na aku in kau Almasi, Anak Tuhan. Kau iya aa dakayo'-kayo' iya agaran kami paitu ni dunya.” ");
INSERT INTO slm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ubus peen halling si Marta itu, pahi' iya ngalinganan danakan na si Mariyam bo' iyampa higung-higung na, uk na, “Tiya' na guru meha kau.” ");
INSERT INTO slm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagtake itu uk si Mariyam, patulahad iya min paningkoan na bo' ōs-ōs na pahi' ni si Isa. ");
INSERT INTO slm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bo' si Isa iya 'nsa' le' makasampay pahi' ni kalumaan suga' ian iya masi le' ma bayi pasampangan si Marta ma iya. ");
INSERT INTO slm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Manga aa ma luma' ian, iya bayi paluruk ni si Mariyam, pag'nda' sigam ma iya patulahad maka paluwas magdayi'-dayi' magtuwi du sigam paturul. Kamaatay sigam in si Mariyam pahi' ni kubul magdukka' ma hi'. ");
INSERT INTO slm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Suga' si Isa iya papahian na. Pag'nda' na ma si Isa pasujud iya ni dahuhan nayi' na, maka uk na, “Panghu' ku, bang kau bayi maitu, 'nsa' du bayi matay danakan ku.” ");
INSERT INTO slm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Makanda' peen si Isa ma si Mariyam magdukka', sampay manga sehe' na Yahudi me'-me' isab magkarukkaan, magtuwi iya ngandu'-ngandu' maka hansul diyōm atay na. ");
INSERT INTO slm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Maingga,” uk na, “bayi pangubulan bi iya?” Uk sigam, “Tuwan, paitu kau, 'ndaun.” ");
INSERT INTO slm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Manjari nangis si Isa. ");
INSERT INTO slm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Halling manga aa hi', “'Ndaun bi ba kamehe lasa na ma si Lasarus.” ");
INSERT INTO slm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Suga' uk kasehean, “Si Isa itu bayi makapakanda' manga aa buta. Angay 'nsa' tatabang na si Lasarus bo' 'nsa' matay?” ");
INSERT INTO slm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na, magdukka' pabing si Isa ngandu'-ngandu' salta' iya pahi' ni kubul. Kubul ian ma diyōm longab maka niya' batu panambōl lowang na. ");
INSERT INTO slm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pagtakka sigam ni kubul uk si Isa, “Kalloun bi batu iyu.” Magtuwi missala si Marta, iya danakan aa mamatay hi'. Uk na ni si Isa, “Bawu na iya, Tuwan, sabab kampat na 'llaw itu.” ");
INSERT INTO slm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Uk si Isa ma iya, “Bayi na kau baan ku, bang peen kau magkahagad makanda' du kau kawasa Tuhan paluwas.” ");
INSERT INTO slm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sakali killoan uk sigam batu panambōl lowang kubul. Si Isa iya pahangad nambahayang. “O 'Mma',” uk na, “magsukul aku sabab ngasip du kau ma aku. ");
INSERT INTO slm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Katauhan ku in kau pake na peen ma aku, suga' paluwas ku bissala ku itu ma sabab manga aa itu supaya sigam ngahagad in kau bayi mapaitu aku.” ");
INSERT INTO slm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pag-ubus bissala na itu ngalingan iya patanōg, uk na. “Lasarus! Paluwas kau paitu.” ");
INSERT INTO slm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Magtuwi paluwas aa bayi mamatay. Masi saput na ma nayi'-tangan na maka masi turung muka na. Uk si Isa ni sigam, “Kalloun bi saput na iyu, bo' pasarin bi iya mangnganan di na.” ");
INSERT INTO slm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Heka manga aa, iya pay'an ngaluruk ni si Mariyam, bayi makanda' hinang si Isa itu bo' magkahagad na sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Suga' niya' sigam kasehean pahi' ni manga Parisi ma'-ma' pasal bayi hinang si Isa. ");
INSERT INTO slm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hangkan na manga Parisi maka manga imam nakura' mapagtipun magtuwi manga palhimpunan maas supaya mag-isun. Uk sigam, “Ayi baha' tahinang kitabi ni aa itu? Heka na tahinang na manga paltandaan kainu-inuhan aa. ");
INSERT INTO slm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bang iya pasaran tabi,” uk sigam, “magkahagad du manga aa kamemon ma iya. Bo' paitu manga nakura' Roma magkaat bangsa tabi sampay langgal tabi.” ");
INSERT INTO slm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Niya' dakayo' nambung, ōn na si Kayapas. Imam nakura' iya ma tahun ian hi'. Uk si Kayapas itu, “Kaam iyu, 'nsa' niya' panghati bi. ");
INSERT INTO slm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kannalun bi itu hi': padpad magmula katibuukan bangsa tabi kamemon, hap le' bang dakayo' aa sadja matay ganti' tabi kamemon.” ");
INSERT INTO slm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Iya halling itu uk si Kayapas 'nsa' min baran-baran na. Suga' hangkan salaihi' halling na sabab imam nakura' iya ma bayi tahun hi'. Hangkan tapaghalling uk na in si Isa subay piyatay ganti' bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Matay du si Isa, bo' 'nsa' bangsa Israil sadja iya giyantian. Matay du iya supaya isab tapagdakayo' na manga panganak Tuhan kamemon iya pulak-palik ma kalahat-lahatan. ");
INSERT INTO slm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jari itu, tōbtōb min 'llaw ian hi', maggara' manga aa ian mapatay si Isa. ");
INSERT INTO slm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hangkan iya 'nsa' na patampal ni kahekahan aa mahi' ma lahat Yahudiya. Atas iya pakallo' maka manga mulid na pahi' ni dakayo' kalumaan iyōnan Epraim. Kalumaan itu bayi ma bihing lahat 'nsa' agōn kalluman ayi-ayi, bo' may'an iya pabōtang maka manga mulid na. ");
INSERT INTO slm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Manjari sikōt na paghinang manga Yahudi iya iyōnan hinang Pangintōman. Heka manga aa min kalahat-lahatan hi' patukad ni Awrusalam mag-ael bo' supaya sigam manjari pasōd ni kahinangan hi'. ");
INSERT INTO slm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Meha na peen sigam ma si Isa bang kalu ma Awrusalam, jari tipun peen sigam ma diyōm langgal pagkulbanan, maghakika sigam dangan maka dangan. Uk sigam, “Ayi pikil bi? Paitu baha' si Isa ni paghinangan? Marayi' 'nsa', a?” ");
INSERT INTO slm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Salaihi' pagbissala sigam sabab niya' bayi panohoan manga imam nakura' maka manga Parisi, uk na, bang niya' makatau kamahian si Isa, subay patau na magtuwi manga nakura' supaya siyaggaw uk sigam si Isa. ");
INSERT INTO slm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","'Nnōm 'llaw laa bo' hinang Pangintōman iya papahi' si Isa ni Betani, kalumaan si Lasarus aa bayi pakallum na min kamatay na. ");
INSERT INTO slm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pagmahi' si Isa siyakapan iya kiyakan uk manga aa mahi', pagpamehe sigam ma iya. Si Marta nabang magbobohat, bo' si Lasarus maka aa kasehean ian dakakanan maka si Isa. ");
INSERT INTO slm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Manjari itu killo' uk si Mariyam tōnga' kilu 'nsallan pahamut, ōn na nalda. 'Nsallan itu 'nsa' niya' lamud na, halgaan tōōd. Tiyumpahan uk si Mariyam 'nsallan pahamut itu ni nayi' si Isa bo' siyapu uk na maka buun na. Saplag diyōm luma' uk hamut na. ");
INSERT INTO slm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Manjari nual si Judas Iskariyut, dakayo' mulid si Isa. Iya na itu aa nongan si Isa ni banta na ma waktu siyong. ");
INSERT INTO slm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Oy!” uk si Judas. “Arapun pahamut iyu piballihan bo' ballihan na panarakka ma manga aa miskin. Halga' na iyu sali' gadji dakayo' aa ma diyōm dantahun.” ");
INSERT INTO slm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Salaihi' bissala si Judas ian ma sabab pananangkaw iya, 'nsa' ma sabab lasa na ma manga miskin. Bayi pangandōl ma iya sin kamuliran ian, bo' peen biyaksa iya ngallo' sin ma di na minnihi'. ");
INSERT INTO slm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Manjari uk si Isa, “Pasarin danda itu. Nawu' iya 'nsallan hamut itu pamahamut na baran ku bang taabut 'llaw pangubul aku. ");
INSERT INTO slm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Umay-umay na waktu niya' du aa miskin tabang bi, suga' aku itu 'nsa' du taggōl ma kaam.” ");
INSERT INTO slm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Heka aa bayi makatau in si Isa ian ma Betani, hangkan sigam pay'an. 'Nsa' pasal si Isa sadja iya papay'an uk sigam. Baya' isab sigam nganda' ma si Lasarus, iya bayi pikallum min kamatay na uk si Isa. ");
INSERT INTO slm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hangkan mag-isun manga imam nakura' mapatay isab ma si Lasarus. ");
INSERT INTO slm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Salaihi' pag-isun sigam, sabab min si Lasarus hangkan heka manga Yahudi mangandōl na ma si Isa. 'Nsa' na me' ma manga imam sigam. ");
INSERT INTO slm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pag 'llaw dakayo', take uk baanan aa maglurukan ma hinang Pangintōman in si Isa iyu na ni Awrusalam. ");
INSERT INTO slm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jari itu nagpe' sigam manga engas-engas dawunan bo' paluwas sigam pahi' nampang si Isa. Ngalingan sigam pakōsōg, uk sigam, “Sanglitan tabi Tuhan! Bang peen biyarakatan iya kawakilan uk Tuhan paitu! Bang peen biyarakatan sultan bangsa Israil!” ");
INSERT INTO slm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Niya' dakayo' anak kura' bayi tatawwa' uk si Isa panguraan na, sali' tasulat asal ma diyōm kitab, iya uk na, ");
INSERT INTO slm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kaam manga aa Awrusalam, daa kaam tiyāw. Iyu na sultan bi ngura' ma anak kura'.” ");
INSERT INTO slm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma waktu ian hi' 'nsa' tahati uk manga mulid na bang ayi hatihan na itu. Suga' pagpowe' si Isa ni diyōm sulga', iyampa taintōm uk sigam in pakaradjaan itu hi' asal tasulat ma diyōm kitab. Maka taintōm uk sigam bayi hinang sigam ian ma iya. ");
INSERT INTO slm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Iya hangkan manga baanan aa ian nampang si Isa ma labayan, sabab bayi sigam makake pasal hinang si Isa makainu-inu ian, hati na pangalingan na ma si Lasarus paluwas min diyōm kubul, maka pamakallum na iya min kamatay na. Manga aa bayi makasabu mahi', sigam du bayi ma' pasal manga hinang si Isa itu. ");
INSERT INTO slm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sakali magbissala manga aa Parisi, uk sigam, “'Ndaun bi! Me' na ma iya manga aa kamemon. 'Nsa' niya' dapat tabi!” ");
INSERT INTO slm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Niya' manga aa bangsa Girik bayi parōngan ma manga aa magpay'an ni Awrusalam bo' supaya nambahayang ma waktu paghinang ian. ");
INSERT INTO slm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pahi' sigam itu ni si Pilip bo' uk sigam ni iya, “Tuwan, baya' kami mag'nda' maka si Isa.” Si Pilip itu dakayo' mulid si Isa, aa min kalumaan Betsaida mahi' ma lahat Jalil. ");
INSERT INTO slm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pahi' si Pilip maan si Andariyas bo' pahi' sigam duwangan maan si Isa pasal aa Girik hi'. ");
INSERT INTO slm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nambung iya, uk na, “Sikōt na waktu ku. Song na aku, in Anak Manusiya', pimehe tōōd. ");
INSERT INTO slm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bannal iya pama' ku itu ma kaam, dakayo' bigi taptap du dakayo' sadja sataggōl 'nsa' tiyanōm ma diyōm tana'. Suga' bang tiyanōm na ma diyōm tana' sali' sapantun patay kiyubul, patomo' du bo' muwan buwa' du paheka. ");
INSERT INTO slm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Damikkiyan na isab ma manusiya'. Sasuku 'llōgan kallum-baran na ma dunya itu, paōkat du kallum-nyawa na min Tuhan. Suga' sasuku 'nsa' 'llōgan kallum-baran na ma dunya, kakkal du kallum-nyawa na sampay ni kasaumulan.” ");
INSERT INTO slm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Uk si Isa le', “Sasuku baya' maghinang ni aku subay me' ma aku. Manjari paingga-paingga papahian ku, ian isab iya ma aku. Sasuku maghinang ni aku pilangkaw du uk 'Mma' ku.” ");
INSERT INTO slm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Masi halling si Isa, uk na, “Susa diyōm atay ku ma buttihi'. Ayi marayi' subay halling ku. Parahing aku ma 'Mma' ku baha' bo' 'nsa' patakka na ni aku kabinsanaan itu? Daa na, sabab iya na itu maksud ku paitu, subay labayan ku kabinsanaan itu.” ");
INSERT INTO slm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Manjari nabbut si Isa ni Tuhan, uk na. “O 'Mma', pamehehun ōn nu.” Magtuwi niya' suwara min sulga' halling, uk na, “Bayi na pamehe ku ōn ku, maka pamehe ku du pabayik.” ");
INSERT INTO slm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Take suwara itu uk manga aa magtanggehan may'an bo' uk kasehean, “Oy! Laggōn ko' ian.” Uk kasehean, “Malaikat ko' ian missala ni iya.” ");
INSERT INTO slm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Suga' uk si Isa ni sigam, “Suwara ian 'nsa' ma sabab ku. Ma sabab bi, hangkan pike. ");
INSERT INTO slm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Taabut na waktu,” uk na, “pangahukum manga manusiya' ma dunya. Taabut na waktu pamakaat kōsōg nakura' sayitan, iya mag-agi ma babaw dunya itu. ");
INSERT INTO slm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bang aku iyangkat na ni diyata' hag, bo ku du manga aa kamemon me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Bissala itu uk si Isa pamatau na ma manga aa may'an bang salaingga kamatay na.) ");
INSERT INTO slm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nambung manga aa heka ian ni si Isa, uk sigam, “Uk kitab kami in Almasi 'llum du saumul-umul. Suga' uk nu in Anak Manusiya' subay piangkat ni hag piyatay. Sayi baha' Anak Manusiya' itu?” ");
INSERT INTO slm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nambung si Isa, uk na, “Tiya' masi ma diyōman bi sawa iya muwan kasawahan ma pikilan bi, lipara 'nsa' taggōl ma itu. Sataggōl masi le' ma kaam sawa, subay palanjal bi langngan bi bo' kaam 'nsa' lindōman. Sabab sasuku mangngan ma kalindōman, 'nsa' katauhan na papahian na. ");
INSERT INTO slm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hangkan na,” uk si Isa, “subay kaam mangandōl ma sawa sataggōl masi ma kaam, supaya kaam manjari aa kapalsukuan kasawahan.” Ubus peen itu bissala uk si Isa, pakallo' iya bo' palimbu min manga aa ian. ");
INSERT INTO slm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Minsan heka hinang makainu-inu bayi tahinang na ma panganda' sigam, masi du sigam 'nsa' magkahagad ma iya. ");
INSERT INTO slm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jari tuman na iya tasulat ian ma diyōm kitab uk si Nabi Isaya, iya uk na, “O Tuhan, 'nsa' niya' magkahagad ma lapal kami. Manga aa bayi kapandaan kawasa nu, kulang du sigam makahati.” ");
INSERT INTO slm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iya na itu poon na hangkan sigam 'nsa' makajari magkahagad, sali' tasulat uk si Nabi Isaya ma ayat dakayo', iya uk na, ");
INSERT INTO slm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pibuta sigam uk Tuhan supaya 'nsa' makanda'. Limbuhan uk na pikilan sigam supaya 'nsa' makahati. Jari 'nsa' sigam papinda ni aku, uk Tuhan, hangkan sigam 'nsa' puwasan min dusa sigam.” ");
INSERT INTO slm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Bissala itu uk si nabi Isaya sabab tanda' na sahaya si Isa, maka si Isa iya pigbissala uk na. ");
INSERT INTO slm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lipara minsan salaihi', heka manga nakura' Yahudi magkahagad ma si Isa. Suga' 'nsa' sigam ma'-ma' patampal pasal pagkahagad sigam, sabab tiyāw sigam ma manga Parisi. Tiyāw piluwas min diyōm langgal, 'nsa' na pisōd pabing. ");
INSERT INTO slm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tuud sigam baya' le' kaamuhan uk sanglit min manusiya' labi le' min sanglit min Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Manjari tanōg uk si Isa missala, uk na, “Sasuku magkahagad ma aku, 'nsa' aku sadja iya pagkahagad na, suga' Tuhan isab, iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maka sasuku nganda' aku, tanda' na isab iya mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Bayi aku paitu ni dunya muwan sawa ma pikilan manusiya', bo' supaya in sasuku magkahagad ma aku 'nsa' taggōl ma diyōm kalindōman. ");
INSERT INTO slm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sasuku pake manga pandu' ku bo' 'nsa' be' na, 'nsa' aku ngahukum iya. Sabab na 'nsa' pangahukum ma manusiya' iya pamapaitu ku ni dunya. Iya hangkan aku paitu supaya sigam lappasan ku min hukuman dusa. ");
INSERT INTO slm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma 'llaw katapusan niya' du ngahukum manga aa iya manulak aku, iya 'nsa' isab nayima' manga pandu' ku. Iya bayi pamandu' ku ma sigam jari pangahukuman sigam. ");
INSERT INTO slm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tawwa' ko' itu sabab 'nsa' min pagnahu'-nahu' ku iya hangkan aku mandu', suga' min 'Mma' ku iya mapaitu aku. Bayi aku biyaan uk na bang ayi subay pamandu' ku, maka bang salaingga subay bohan na. ");
INSERT INTO slm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Maka katauhan ku in panohoan 'Mma' ku makabuwan kallum kakkal sampay ni kasaumulan. Hangkan na, ayi-ayi pamissala ku ma manusiya' bayi panohoan aku asal uk 'Mma' ku.” ");
INSERT INTO slm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Song peen tiyagnaan hinang Pangintōman, kitauhan asal uk si Isa taabut na waktu kakalloan na min dunya itu bo' pabing pahi' ni 'Mma' na. Bayi na kalasahan na asal manga aa suku' na ma dunya itu, bo' ma buttihi' pandaan na ma sigam bang salaingga ehe lasa na ma sigam. ");
INSERT INTO slm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Manjari song kohap peen, magkakan di si Isa maka manga mulid na. Si Judas anak si Simun Iskariyut ubus na bayi pihōpan pikilan uk nakura' sayitan subay nongan si Isa ni manga banta na. ");
INSERT INTO slm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kitauhan asal uk si Isa in iya bayi kabuwanan kapatut uk 'Mma' na Tuhan mag-agi ma kamemon. Katauhan na isab in iya bayi paitu min Tuhan maka pabayik du iya ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jari nangge si Isa min pagkakanan bo' hurusan na dalapis badju' na bo' iyampa mag-os maka tuwaliya. ");
INSERT INTO slm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Numpahan iya bohe' ni diyōm undam bo' nagna' iya ngosean nayi' manga mulid na pakaniya-pakaniya. Puwas hi' siyapuhan uk na nayi' sigam maka tuwaliya iya pangos na. ");
INSERT INTO slm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pag-abut na ni si Simun Petros, uk si Petros ni iya, “Kau, Panghu', kosean nu baha' nayi' ku itu?” ");
INSERT INTO slm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nambung si Isa, uk na, “'Nsa' tahati nu buttihi' bang ayi hinang ku itu suga' tahati nu du ma sosongun.” ");
INSERT INTO slm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Uk si Petros, “'Nsa' tōōd pakose' ku nayi' ku ma kau.” “Bang 'nsa' kosean ku nayi' nu,” uk si Isa, “'nsa' kau na mulid ku.” ");
INSERT INTO slm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Uk si Simun Petros ma iya, “Na, Panghu', bang salaihi' du, daa sadja nayi' ku iya kosean nu, sampay tangan ku maka kok ku.” ");
INSERT INTO slm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Uk si Isa, “Bang aa bayi mandi lanu' na baran na. Nayi' na laa iya subay kosean na pabing. Kaam kamemon, lanu' na pangatayan bi, puwas sadja min aa dangan iyu.” ");
INSERT INTO slm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Salaihi' halling si Isa sabab katauhan na asal bang sayi song nongan iya ni manga banta na, hangkan uk na in sigam kamemon lanu' na pangatayan sigam, puwas sadja min aa dangan. ");
INSERT INTO slm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ubus peen kiyosean uk si Isa nayi' manga mulid na, magbadju' iya pabing bo' iyampa ningko' ma bayi tingkoan na. Tīyaw iya ni manga mulid na, uk na, “Tahati bi baha' bang ayi bayi hinang ku itu ma kaam? ");
INSERT INTO slm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pangōnan bi aku Guru maka Panghu'. Tawwa' ko' ian, sabab guru bi du aku maka panghu' bi. ");
INSERT INTO slm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, pagka aku guru bi maka panghu' bi bayi ngosean nayi' bi, subay aku paningōran bi. Kaam iyu subay magkosean nayi' sehe' bi dangan kaam maka dangan. ");
INSERT INTO slm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bayi hinang ku itu panuntuan bi, supaya aku paningōran bi magpareyo' atay bi. ");
INSERT INTO slm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bannal iya pama' ku itu ma kaam, in banyaga' 'nsa' langkaw min nakura' na, maka sosohoan 'nsa' langkaw min aa noho' iya. ");
INSERT INTO slm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pagka tahati bi na pamandu' ku itu, tantu kaam kiyōgan bang be' bi du.” ");
INSERT INTO slm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Uk si Isa le', “'Nsa' kaam kamemon iya pagbaha' ku itu. Katauhan ku du bang sayi manga aa bayi tapene' ku me' ma aku. Suga' subay du niya' kamaujuran ma bayi siyulat ma diyōm kitab, iya uk na, ‘Liyaat du aku uk dakayo' sehe' ku magsawu mangan.’ ");
INSERT INTO slm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Baan ta kaam pasal itu hi' ma 'nsa' le' patakka. Jari bang patakka na, kahagad bi du bayi halling ku ma pasalan baran ku bang sayi aku. ");
INSERT INTO slm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bannal iya halling ku itu ma kaam,” uk si Isa, “sasuku ngahulmat aa soho' ku, sali' baran ku iya hiyulmat uk na. Maka sasuku ngahulmat aku, tahulmat na iya bayi mapaitu aku.” ");
INSERT INTO slm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ubus peen halling si Isa itu, susa tōōd diyōm atay na bo' uk na ni manga mulid na, “Bannal pama' ku itu ma kaam, niya' dangan min kaam maggara' nongan aku ni manga banta ku.” ");
INSERT INTO slm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Magpanganda' manga mulid ian dangan maka dangan. 'Nsa' tōōd kitauhan uk sigam bang sayi pahallingan na. ");
INSERT INTO slm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jari niya' dakayo' mulid si Isa, aa kalasahan na, ian ningko' ma bihing si Isa. ");
INSERT INTO slm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sinyal mulid itu uk si Simun Petros maka uk si Petros ma iya, “Tīyawun kono' si Isa bang sayi pighalling uk na hi'.” ");
INSERT INTO slm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Manjari pasandig mulid ian ni si Isa niyaw iya, uk na, “Panghu', sayi baha' nongan kau ni banta nu?” ");
INSERT INTO slm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nambung si Isa, uk na, “Iya aa buwanan ku tinapay, ubus bayi tannoan ku iya ni diyōm loho', iya na ian aa hi'.” Sakali killo' tinapay uk si Isa, tinnoan uk na ni loho' bo' iyampa pamuwan na ma si Judas anak si Simun Iskariyut. ");
INSERT INTO slm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagkallo' tinapay itu uk si Judas magtuwi pahōp nakura' sayitan ni diyōm pikilan na. Uk si Isa ni si Judas, “Dayi'-dayiun na iya song hinang nu iyu.” ");
INSERT INTO slm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","'Nsa' niya' minsan dangan min mulid na kasehean makahati bang ayi pihalling uk si Isa ma si Judas hi'. ");
INSERT INTO slm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pagka si Judas nawu' sin sigam, hangkan pangannal sigam kasehean in iya bayi siyoho' uk si Isa malli panyap paghinang atawa siyoho' magsarakka ni manga miskin. ");
INSERT INTO slm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Manjari pagsambut peen tinapay uk si Judas magtuwi iya paluwas minnihi'. Sangōm na lahat. ");
INSERT INTO slm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Paglikut si Judas, uk si Isa, “Buttihi' pindaan na kaehehan ku, Anak Tuhan. Pindaan isab kawasa Tuhan ma sabab hinang ku. ");
INSERT INTO slm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jari bang kapandaan kawasa Tuhan sabab min aku, song isab pandaan na kaehe ku. 'Nsa' du taggōl. ");
INSERT INTO slm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kaam manga anak-mulid ku,” uk si Isa, “'nsa' na aku taggōl ma itu ma kaam. Peha bi du aku, suga' pama' ku na ma kaam sali' bayi pama' ku ma manga nakura' Yahudi: ‘'Nsa' kaam makapahi' ni papahian ku ian.’ ");
INSERT INTO slm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na, niya' panohoan bahu buwanan ku ma kaam. Subay kaam maglasa-liyasahi. Maglasa kaam sali' kalasa ku ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bang kaam ganta' maglasa-liyasahi, minnihi' kitauhan uk manga manusiya' kamemon in kaam manga mulid ku du.” ");
INSERT INTO slm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Uk si Simun Petros ni si Isa, “Tuwan Panghu', paingga kau?” Uk sambung si Isa, “'Nsa' na kau makabe' ma aku buttihi' ni papahian ku hi', suga' kabe' du kau ma sosongun.” ");
INSERT INTO slm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Tuwan,” uk si Petros ni iya, “angay aku 'nsa' makabe' ma kau buttihi'? Maglilla' aku piyatay basta ma sabab nu.” ");
INSERT INTO slm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Siyambungan iya uk si Isa, uk na, “Paglilla' nu baha' baran nu piyatay ma sabab ku? Bannal iya pama' ku itu ma kau, ma 'nsa' nigauk manuk le', min tallu du kau mayilu in aku 'nsa' katauhan nu.” ");
INSERT INTO slm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Uk si Isa ni manga mulid na, “Daa pasusahun bi diyōm atay bi pasal uk ku hi'. Mangandōl sadja kaam ma Tuhan maka mangandōl kaam ma aku. ");
INSERT INTO slm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ian ma ōkōman 'Mma' ku Tuhan heka pabōtangan. 'Nsa' aku bayi maan kaam niya' bang 'nsa' bannal. Pahi' du aku nakapan kaam pabōtangan bi. ");
INSERT INTO slm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na, bang ubus na aku nakapan pabōtangan bi, pabayik du aku paitu ngallo' kaam bo' bo ta kaam pahi' ni pabōtangan ku supaya kitabi magdakayo' pabōtangan. ");
INSERT INTO slm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kaam iyu, katauhan bi labayan tudju pahi' ni papahian ku.” ");
INSERT INTO slm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Uk si Tomas ni iya, “Tuwan Panghu', 'nsa' katauhan kami bang paingga papahian nu. Salaingga uk kami makaturul pahi'!” ");
INSERT INTO slm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Uk si Isa ma iya, “Aku iya labayan tudju ni Tuhan. Aku iya poonan kasabannalan. Maka aku iya poonan kallum. 'Nsa' niya' makapahi' ni 'Mma' ku Tuhan bang 'nsa' aku iya palabayan na. ");
INSERT INTO slm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Buttihi', pagka aku katauhan bi na, katauhan bi du isab 'Mma' ku. Puwas min 'llaw itu katauhan bi du iya, maka tanda' bi du iya.” ");
INSERT INTO slm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Uk si Pilip ni si Isa, “Tuwan Panghu', pandain 'Mma' nu ma kami, bo' kami kaamuhan.” ");
INSERT INTO slm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nambung si Isa ma iya, uk na, “Taggōl aku ma kaam, Pilip, bo' 'nsa' le' katauhan nu bang sayi aku? Sayi-sayi makanda' aku, sali' 'Mma' ku na tōōd iya tanda' na. Jari angay hangkan uk nu in 'Mma' ku subay pindaan ni kaam? ");
INSERT INTO slm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Nsa' kau ngahagad baha', Pilip, in aku maka 'Mma' ku dakayo' du? Manga pandu' bayi pamandu' ku ma kaam ian, 'nsa' min paghōna'-hōna' ku suga' min 'Mma' ku, iya pataptap itu ma aku. Ngahinangan iya di na hinang na.” ");
INSERT INTO slm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uk si Isa le', “Subay aku pagkahagad bi pagka uk ku in aku maka 'Mma' ku dakayo' du. Suga' bang aku ganta' 'nsa' pagkahagad bi ma sabab pamissala ku sadja, pagkahagarun bi sadja aku ma sabab manga hinang bayi tahinang ku. ");
INSERT INTO slm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bannal iya pama' ku itu ma kaam, sayi-sayi magkahagad ma aku, tahinang na du manga hinang bayi hinang ku. Maka pasong le' manga hinang na min bayi hinang ku, sabab pahi' na aku ni 'Mma' ku Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ayi-ayi amu' bi ni 'Mma' ku ma sabab aku iya panabbutan bi, hinang ku du ma kaam supaya min hinang ku maehehan 'Mma' ku. ");
INSERT INTO slm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ayi-ayi amu' bi ni aku ma sabab panabbut bi ma aku, paniya' ku sadja du ma kaam.” ");
INSERT INTO slm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Uk si Isa le', “Bang aku kalasahan bi du, tantu be' bi manga panohoan ku ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ngamu' du aku ni 'Mma' ku bo' niya' du pamuwan na ma kaam saddi min aku nabangan kaam ganti' ku. Pataptap du iya ma kaam saumul-umul. ");
INSERT INTO slm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iya manabang itu Nyawa Tuhan, iya ma' kasabannalan pasal Tuhan. Suga' manga aa 'nsa' ngisbat Tuhan, 'nsa' tatayima' uk sigam Nyawa Tuhan sabab 'nsa' iya tasayu uk sigam, maka 'nsa' iya kitauhan. Suga' kaam iyu, katauhan bi du Nyawa Tuhan sabab iyu du iya ma kaam maka pataptap iya ma diyōm atay bi. ");
INSERT INTO slm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Minsan aku pakallo', 'nsa' du kaam pasaran ku. Pabayik du aku paitu ni kaam. ");
INSERT INTO slm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Nsa' taggōl bo' 'nsa' aku tanda' uk manga aa 'nsa' ngisbat Tuhan. Suga' kaam iyu, tanda' bi du aku bo' 'llum du kaam saumul-umul pagka aku iya asal 'llum. ");
INSERT INTO slm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taabut peen waktu ian, katauhan bi du in aku maka 'Mma' ku dakayo' asal, maka katauhan bi isab in kaam maka aku dakayo' du. ");
INSERT INTO slm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Sayi-sayi nayima' manga panohoan ku sampay me', iya iyu aa asal lasa ma aku. Jari sasuku lasahan aku, kilasahan du iya uk 'Mma' ku. Iya du aku lasahan iya, maka pahati ku di ku ma iya.” ");
INSERT INTO slm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sakali tīyaw si Isa uk si Judas, iya 'nsa' Judas Iskariyut. “Panghu',” uk na, “ayi sabab na hangkan pahati nu di nu ma kami sadja, bo' 'nsa' ma manusiya' kamemon?” ");
INSERT INTO slm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nambung si Isa, uk na, “Bang aa lasahan aku, tantu bōgbōgan na du manga pamandu' ku. Jari kilasahan du iya uk 'Mma' ku bo' pay'an du kami maka 'Mma' ku pabōtang ma iya. ");
INSERT INTO slm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Suga' bang aa 'nsa' lasa ma aku, 'nsa' isab bōgbōgan na manga pandu' ku. Maka pandu' iya take bi halling ku itu, 'nsa' min hōna'-hōna' ku suga' min 'Mma' ku, iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bayi na itu pama' ku ni kaam sasang ku masi maitu ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Suga' ma sosongun piyanduan du kaam pasal kamemon uk Nyawa Sutsi, iya pipaitu uk 'Mma' ku nabangan kaam paganti' min aku, pamaintōm kaam pasal kamemon bayi pamandu' ku ma kaam.” ");
INSERT INTO slm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Uk si Isa le', “Iya pamuwan ku ma kaam kasannangan ma diyōm atay. Kasannangan itu min aku asal, maka 'nsa' niya' sali' na ma diyōm dunya. Hangkan uk ku ma kaam, daa pasusahun bi atay bi maka daa kaam tiyāw. ");
INSERT INTO slm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bayi na take bi halling ku ma kaam, iya uk ku hi', ‘Pakallo' aku min kaam suga' pabayik du aku paiyu ni kaam.’ Bang aku kalasahan bi tantu du kaam kiyōgan pagka aku pahi' ni 'Mma' ku, sabab langkaw iya min aku. ");
INSERT INTO slm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bayi na itu pama' ku ma kaam buttihi' baba peen aku 'nsa' le' pakallo', supaya aku pagkahagad bi bang taabut na waktu ian. ");
INSERT INTO slm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Nsa' na aku makajari missalahan kaam pataggōl, sabab song na takka nakura' sayitan iya mag-agi ma babaw dunya itu. Aku itu 'nsa' du kapag-agihan uk na. ");
INSERT INTO slm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Suga' kitauhan uk manga manusiya' kamemon in aku lasa asal ma 'Mma' ku, iya hangkan aku magpanuyu' ngahinang kamemon sali' panohoan 'Mma' ku ma aku. “Na, sung na,” uk si Isa. “Magpakalloan na kitabi minnitu.” ");
INSERT INTO slm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Manjari itu magparalilan si Isa. Uk na ni manga mulid na, “Aku itu sali' dalil di poonan tiyanōm, maka 'Mma' ku dalil aa ngayaran pagtanōman. ");
INSERT INTO slm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kamemon kasengahan ku sasuku 'nsa' muwan buwa', killoan uk na. Maka kamemon kasengahan ku taga buwa' hiyawanan uk na bo' pakannōp buwa' na. ");
INSERT INTO slm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kaam iyu dalil senga bo' hawanan na kaam maka manga lapal pamandu' ku kaam. ");
INSERT INTO slm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Subay kaam patōtōg ma aku bo' patōtōg aku ma kaam. Iya dalil na senga 'nsa' buwaan di na, subay dōs maka poonan na bo' magbuwa'. Damikkiyan na kaam iyu, 'nsa' kaam makahinang hap duwal bang aku iya pamean bi kakkal. ");
INSERT INTO slm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aku itu di poonan tiyanōm, bo' kaam iya dalil kasengahan ku. Sayi-sayi kaam patōtōg ma aku, bo' aku isab patōtōg ma iya, heka buwa' na ma kawul-piil. Sabab bang aa ganta' ōkat min aku, 'nsa' niya' tahinang na hap. ");
INSERT INTO slm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sayi-sayi 'nsa' patōtōg ma aku, sali' iya dalil senga sagpe', timanan maka pilanōsan di na na. Manjari manga senga malanōs itu tipun du bo' liyarukan ni diyōm api tiyutung. ");
INSERT INTO slm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Suga' bang kaam patōtōg ma aku, maka bang tawu' bi pandu' ku ma diyōm atay bi, diyulan du kaam uk Tuhan ma ayi-ayi amu' bi. ");
INSERT INTO slm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bang kaam muwan buwa' paheka ma kawul maka piil, pimehe du 'Mma' ku, bo' minnihi' kaam tahinang mulid ku sabannal-bannal. ");
INSERT INTO slm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Lasa ku ma kaam sali' du lasa 'Mma' ku ma aku. Daa kaam pabutas min lasa ku. ");
INSERT INTO slm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bang be' bi manga panohoan ku, 'nsa' du kaam butas min lasa ku. Sali' aku, be' ku asal manga panohoan 'Mma' ku ma aku bo' 'nsa' aku butas min lasa na. ");
INSERT INTO slm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Hangkan itu pamandu' ku ma kaam, supaya kaam kahōpan sali' kakōgan ku, maka supaya jukup isab kakōgan bi. ");
INSERT INTO slm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iya na itu panohoan ku ma kaam, subay kaam maglasa-liyasahi sali' paglasa ku ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bang niya' aa lilla' matay sabab min lasa na ma manga bagay na, 'nsa' kaliyuhan lasa salaihi'. ");
INSERT INTO slm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kaam iyu, bagay ku du kaam bang hinang bi manga panohoan ku ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Nsa' na kaam ōnan ku sosohoan sabab sosohoan 'nsa' pitau bang ayi na peen hinang uk nakura' na. Suga' kaam iyu bayi patau ku kamemon iya take ku min 'Mma' ku, hangkan kaam ōnan ku na manga bagay ku. ");
INSERT INTO slm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Nsa' kaam iya bayi makapene' aku, suga' aku iya bayi mene' kaam, maka bayi ngawakilan kaam supaya heka kahapan tahinang bi, kahapan 'nsa' pinda. Jari ayi-ayi pangamu' bi ni Tuhan ma sabab aku iya panabbutan bi, tantu kaam diyulan uk na. ");
INSERT INTO slm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na iya na itu panohoan ku ma kaam, subay kaam maglasa-liyasahi.” ");
INSERT INTO slm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Uk si Isa ni manga mulid na, “Bang kaam ganta' kibansihan uk manga aa 'nsa' ngisbat Tuhan ma dunya itu, intōmun bi aku. Bayi aku kibansihan uk sigam dahu le' min kaam. ");
INSERT INTO slm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bang bayi kaam ganta' dambean maka manga aa 'nsa' ngisbat, bayi du kaam kilasahan uk sigam pagka suku' sigam. Suga' pabidda' na kaam. Bayi kaam pene' ku pisaddi min manga aa ian, hangkan kaam kibansihan uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Intōmun bi bayi halling ku ma kaam, iya uk ku hi', ‘In banyaga' 'nsa' du langkaw min nakura' na.’ Na, bang aku nakura' bi liyaat uk manga aa ian, tantu isab kaam liyaat du uk sigam. Bang bayi sigam me' ma pamandu' ku, me' du isab sigam ma pamandu' bi. ");
INSERT INTO slm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Suga' kibansihan du kaam maka liyaat du kaam uk sigam sabab suku' ku kaam. 'Nsa' tōōd sigam tau ma Tuhan, iya bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bang bayi 'nsa' aku paitu ni dunya manduan sigam, 'nsa' du sigam katōngan dusa. Suga' ma buttihi' 'nsa' na sigam makaraawa pasal manga dusa sigam sabab 'nsa' na sigam awam. ");
INSERT INTO slm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sayi-sayi bansihan aku, bansi du isab iya ma 'Mma' ku. ");
INSERT INTO slm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Manga aa ian, bang bayi 'nsa' tahinang ku ma panganda' sigam manga hinang iyampa hinang, 'nsa' du sigam bayi katōngan dusa. Suga' tanda' na uk sigam kahinangan ku ian, maka bansi na sigam ma aku maka ma 'Mma' ku. ");
INSERT INTO slm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Suga' tantu du aku kibansihan uk sigam bo' supaya tuman iya bayi tasulat ma kitab sara' sigam, iya uk na, ‘Kibansihan aku uk sigam ma 'nsa' niya' poon sabab na.’ ” ");
INSERT INTO slm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Halling le' si Isa, uk na, “Paitu du ni kaam aa Pananabang, hati na Nyawa Tuhan iya paluwas min Tuhan. Ma' iya kasabannalan pasal Tuhan. Papaitu ku iya ni kaam min 'Mma' ku. Jari pagmaitu na iya naksi' du iya ma sabab ku. ");
INSERT INTO slm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kaam isab, naksi' du kaam ma sabab ku sabab sehe' ku asal kaam sataggōl min katagna'.” ");
INSERT INTO slm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Uk si Isa ni manga mulid na, “Bayi na pama' ku itu ma kaam bo' supaya kaam 'nsa' ngalabba min pangandōl bi tudju ni aku. ");
INSERT INTO slm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kaam iyu song 'nsa' pisōd ni diyōm langgal uk manga nakura' agama. Maka takka du waktu, bang niya' aa mapatay kaam, iya pangannal sigam in hinang sigam hi' me' ma kabayaan Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hangkan salaihi' hinang manga aa ma kaam sabab 'nsa' sigam bayi makatauhan 'Mma' ku atawa aku. ");
INSERT INTO slm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Baan ta kaam pasal itu hi' supaya kaam makaintōm bang taabut waktu patakka ni kaam manga pakaradjaan itu. Taintōm bi du bayi pama' ku itu ma kaam.” “'Nsa' kaam bayi baan ku dahu sabab masi aku ma kaam. ");
INSERT INTO slm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Suga' buttihi' baan ta kaam sabab song na aku pabayik pahi' ni bayi mapaitu aku, bo' peen 'nsa' niya' min kaam bayi tiyaw aku bang paingga aku. ");
INSERT INTO slm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Makalandu' na kasusahan bi pagka kaam baan ku na. ");
INSERT INTO slm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Suga' bannal sadja iya pama' ku itu ma kaam, mehe le' kahapan ma kaam bang aku pakallo'. Sabab bang aku sawupama bayi 'nsa' pakallo', 'nsa' du paitu ni kaam iya Pananabang hi'. Suga' bang aku pakallo', papaitu ku du iya ni kaam. ");
INSERT INTO slm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pagmaitu peen ma kaam Pananabang itu, pahatihan na du manga manusiya' ma dunya itu pasal dusa, maka pasal kaadilan, maka pasal hukuman Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pahatihan na du sigam pasal dusa sigam, sabab 'nsa' sigam magkahagad ma aku. ");
INSERT INTO slm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pahatihan na du sigam pasal kaadilan, sabab pahi' na aku ni 'Mma' ku bo' 'nsa' na aku tanda' bi. ");
INSERT INTO slm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pahatihan na du sigam pasal hukuman Tuhan, sabab tahukum na nakura' sayitan, iya mag-agi ma babaw dunya itu. ");
INSERT INTO slm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Heka le' pama' ku ma kaam,” uk si Isa, “suga' 'nsa' tabo pikilan bi buttihi'. ");
INSERT INTO slm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Subay na takka paitu Nyawa Tuhan, iya magpahati kasabannalan pasal Tuhan, bo' iyampa kaam panduan pasal kasabannalan kamemon. 'Nsa' du iya mandu' min pagnahu'-nahu' na, suga' ayi-ayi take na min Tuhan, iya na hi' pamandu' na. Maka baan na du kaam pasal pakaradjaan iya patakka ma sosongun. ");
INSERT INTO slm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pimehe du aku uk Nyawa Tuhan sabab kamemon pamandu' na ma kaam asal min aku du. ");
INSERT INTO slm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ayi-ayi ma 'Mma' ku ma aku du isab, hangkan uk ku ma kaam in kamemon pama' Nyawa Tuhan ma kaam asal min aku du.” ");
INSERT INTO slm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Uk si Isa, “'Nsa' na taggōl, 'nsa' na aku tanda' bi. Pagpuwas ian isab, 'nsa' taggōl bo' aku tanda' bi du.” ");
INSERT INTO slm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Magbissala manga mulid si Isa kasehean, uk sigam, “Ayi baha' hati na, iya uk na ‘'nsa' na taggōl bo' 'nsa' na iya tanda' tabi kono', maka puwas ian hi' 'nsa' taggōl bo' tanda' ta iya kono' pabing?’ Maka bayi halling na isab, iya uk na hi', ‘sabab pahi' na iya kono' ni 'Mma' na?’ ");
INSERT INTO slm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ayi baha' hati na ‘taggōl-taggōl’, iya pagbissala na itu? Pasal ayi pagbissala na!” ");
INSERT INTO slm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kitauhan asal uk si Isa in manga mulid na ian baya' tiyaw iya pasal bissala na bang ayi hati na. Hangkan uk na ni sigam, “Sini' bayi uk ku ma kaam, ‘'nsa' taggōl bo' 'nsa' aku tanda' bi, maka 'nsa' du isab taggōl bo' tanda' bi du aku pabing’. Iya na itu baha' pagtiyaw-tiyawan bi dangan maka dangan? ");
INSERT INTO slm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bannal sadja pama' ku itu ma kaam, kaam iyu magsusa du maka magdukka', suga' kiyōgan du manga aa 'nsa' ngisbat Tuhan. Tawwa' du kaam kasusahan suga' papinda du susa bi ni kalasigan. ");
INSERT INTO slm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iya dalil na sali' danda nganak. Susa iya sasang na song nganak. Suga' pagmaluwasan na anak na, 'nsa' na taintōm na paddi' bayi kalabayan na. Gam peen iya kiyōgan sabab niya' onde'-onde' palahil na ni dunya. ");
INSERT INTO slm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Damikkiyan na ma kaam. Ma buttihi' susa kaam, suga' mag'nda' du kitabi pabing. Manjari kiyōgan du kaam tōōd maka 'nsa' niya' makapakalloan kiyōgan bi ian min diyōm atay bi. ");
INSERT INTO slm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Bang taabut 'llaw pag'nda' kitabi pabayik 'nsa' na niya' paniyawan bi aku. Bannal pama' ku itu ma kaam, ayi-ayi amu' bi ni 'Mma' ku ma sabab aku iya pamanyabutan bi, tantu kaam diyulan sadja uk na. ");
INSERT INTO slm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dahu minnitu 'nsa' kaam bayi makaamu' ayi-ayi ma sabab aku iya pamanyabutan bi. Ngamu' na kaam bo' diyulan sadja kaam bo' jukup kakōgan bi.” ");
INSERT INTO slm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Uk si Isa ni sigam, “Bayi aku magparalilan manduan kaam. Suga' niya' du 'llaw takka, 'nsa' na aku magparalilan ma kaam. Hangpas sadja pamissala ku ma kaam pasal 'Mma' ku. ");
INSERT INTO slm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Taabut peen 'llaw ian hi', kaam baran bi ngamu' du ni Tuhan ma sabab aku iya pamanyabutan bi. 'Nsa' na aku ngamuan kaam ni 'Mma' ku, ");
INSERT INTO slm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sabab mismu 'Mma' ku lasa ma kaam. Kilasahan kaam uk na ma sabab aku iya kalasahan bi maka ma sabab pagkahagad bi ma aku, in aku bayi paitu min Tuhan. ");
INSERT INTO slm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aho', bayi aku paitu min 'Mma' ku Tuhan pasampay ni dunya itu, bo' ma buttihi' pakallo' na aku min dunya bo' pabing pahi' ni 'Mma' ku.” ");
INSERT INTO slm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Uk manga mulid na ni iya, “buttihi' hangpas na pamissala nu, 'nsa' bissala paralilan. ");
INSERT INTO slm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Katauhan kami na in kau makasakupan du ayi-ayi kamemon. 'Nsa' na niya' kagunahan nu kine ma tiyaw aa sabab katauhan nu asal diyōm pikilan sigam. Hangkan na kami ngahagad tōōd in kau bayi paitu min Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Uk si Isa ma sigam, “Magkahagad na kaam baha' buttihi'? ");
INSERT INTO slm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Song na waktu, marayi' na tōōd, in kaam iyu magkawukanat du. Maglahihan du kaam ni kalumaan bi pakaniya-pakaniya bo' 'mbanan bi du aku didi ku. Suga' iya bannal na, 'nsa' aku didi ku sabab patōtōg du 'Mma' ku ma aku. ");
INSERT INTO slm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Baan ta na kaam pasal itu kamemon bo' supaya sannang diyōm atay bi, pagka kaam magdakayo' maka aku. Ma itu ma dunya, binsana' du kaam uk manga aa 'nsa' ngisbat Tuhan, suga' daa kaam tiyāw. Taraōg ku na sigam.” ");
INSERT INTO slm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ubus peen itu bissala uk si Isa, pahangad iya tudju ni sulga' nabbut ni Tuhan. “O 'Mma',” uk na, “taabut na waktu. Pamehehun aku, Anak nu, supaya aku makapamehe ma kau. ");
INSERT INTO slm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bayi aku kawakilan nu mag-agi ma manusiya' kamemon bo' supaya buwanan ku kallum kakkal ni manga aa kamemon iya pamasuku' nu ma aku. ");
INSERT INTO slm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kallum kakkal itu, iya na itu hatihan na: sasuku tau ma kau in kau Tuhan tunggal sabannal-bannal, maka tau isab ma si Isa Almasi iya papaitu nu ni dunya, niya' na kallum na kakkal ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Bayi na pandaan ku kaehehan nu ma itu ma dunya, sabab taubus na uk ku manga hinang bayi pamahinang nu aku. ");
INSERT INTO slm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O 'Mma', pamehehun aku maiyu ma haddarat nu, sali' kapamehe nu ma aku waktu kamaiyu ku ma kau ma 'nsa' le' bayi niya' dunya pipanjari. ");
INSERT INTO slm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Bayi na kau patau ku ni manga aa iya pamasuku' nu aku ma itu ma dunya. Suku' nu asal sigam, bo' pasuku' nu sigam ma aku. Tabe' uk sigam lapal palman nu, ");
INSERT INTO slm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","maka kitauhan na uk sigam in kamemon pamuwan nu aku asal min kau. ");
INSERT INTO slm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bayi na pasampay ku ni sigam lapal pamuwan nu aku, maka tatayima' na uk sigam. Katauhan sigam na in aku sabannal-bannal deyo' bayi min kau, maka magkahagad na sigam in kau bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“O 'Mma', amuan ku junjung le' manga aa itu. 'Nsa' manusiya' kamemon iya amuan ku itu, suga' manga aa bayi pamasuku' nu aku sadja, sabab sigam itu suku' nu du. ");
INSERT INTO slm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ma kau du suku' ku kamemon, maka ma aku du isab suku' nu kamemon. Tanda' isab kamehe ku ma sabab manga aa suku' ku itu. ");
INSERT INTO slm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na, song na aku pabayik paiyu ni kau. Song na labbahan ku dunya itu, suga' sigam suku' ku, tiya' le' sigam masi ma dunya. O 'Mma' ku Sutsi, jagahin le' sigam sabab min barakat ōn nu, iya ōn bayi pamuwan nu aku, bo' supaya sigam magdakayo' atay sali' kita. ");
INSERT INTO slm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sataggōl aku masi ma itu ma manga aa iya pamasuku' nu aku, bayi sigam jagahan ku min barakat ōn nu, ōn bayi pamuwan nu aku. Bayi sigam tungguan ku hangkan 'nsa' niya' min sigam bayi palungay min kau. Hangkan du dakayo', iya gantaan na lungay, bo' minnihi' tuman du peen in bayi pigpalatun ma diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Na, song na aku pabayik paiyu ni kau. Hangkan, sataggōl aku masi ma dunya itu halling ku na peen lapal ku itu bo' mehe kakōgan sigam sali' kakōgan ku. ");
INSERT INTO slm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Bayi na pasampay ku ni sigam lapal palman nu. Jari kibansihan sigam uk manga aa 'nsa' ngisbat kau, sabab saddi sigam min manga aa hi'. Sali' aku na sigam, sabab saddi asal aku min manga aa 'nsa' ngisbat kau ma diyōm dunya. ");
INSERT INTO slm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Nsa' amuan ku manga aa suku' ku itu subay pakallo' nu min dunya. Suga' iya amu' ku bang peen sigam jagahan nu bo' 'nsa' tapagagihan uk nakura' sayitan, iya patilaatun hi'. ");
INSERT INTO slm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Saddi aku min manga aa 'nsa' ngisbat kau ma diyōm dunya itu. Damikkiyan na manga aa suku' ku, saddi isab min manga aa ian. ");
INSERT INTO slm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pasaddihun maka sutsihun sigam supaya sigam ma kau sadja. Iya panutsi sigam pandu' nu bannal, hati na palman nu. ");
INSERT INTO slm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bayi sigam soho' ku pahi' ni manga aa ma dunya, sali' bayi panoho' nu ma aku paitu ni diyōm dunya. ");
INSERT INTO slm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma sabab sigam, iya hangkan aku magpasuku' di ku ma kau, supaya sigam suku' nu tōōd. ");
INSERT INTO slm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“'Nsa' sadja manga mulid ku itu hi' iya amuan ku,” uk si Isa, “suga' manga aa kamemon iya song magkahagad ma aku ma sabab lapal sigam. ");
INSERT INTO slm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O 'Mma', ngamu' aku junjung ni kau, bang peen sigam daatay kamemon sali' kita, pagka kau pataptap asal ma aku, maka aku pataptap ma kau. Mura-murahan, bang peen sigam patōtōg ma kita, bang peen isab sigam magdakayo' atay kamemon supaya magkahagad manga aa ma dunya in kau bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bayi sigam pamehe ku sali' bayi pamehe nu ma aku, supaya sigam magdakayo' atay sali' kita. ");
INSERT INTO slm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hati na pataptap aku may'an ma sigam sali' kau pataptap asal ma aku, bo' supaya sigam daatay tōōd. Jari minnihi' kitauhan uk manga aa ma dunya itu in kau bayi mapaitu aku, maka kitauhan isab in manga aa magkahagad ma aku kalasahan nu du sali' pangalasa nu ma aku. ");
INSERT INTO slm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O 'Mma'! Bayi pamasuku' nu aku manga aa itu, bo' kabayaan ku sigam subay parōngan ma aku ma kamaiyuhan ku, bo' sigam makanda' sahaya ku iya bayi pamuwan nu aku. Sabab kalasahan nu aku asal ma 'nsa' le' niya' dunya. ");
INSERT INTO slm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O 'Mma', kau iya adil. 'Nsa' kau kitauhan uk manga aa 'nsa' ngisbat kau, suga' aku itu tauhan kau du. Maka manga aa suku' ku itu, tau isab sigam in kau bayi mapaitu aku. ");
INSERT INTO slm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bayi na kau patau ku ma sigam, maka patau ku na peen bo' supaya sigam pahōpan nu lasa tudju ni pagkahi sigam, sali' lasa nu ma aku. Patau ku isab sigam supaya aku patōtōg ma diyōm atay sigam.” ");
INSERT INTO slm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Puwas peen si Isa nambahayang ni Tuhan, pakallo' iya maka manga mulid na tudju ni dambiya' sapa' iyōnan Kedron. Niya' kabbun may'an bo' pasōd di si Isa ni diyōm na. ");
INSERT INTO slm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, kitauhan uk si Judas bang paingga iya papahian si Isa sabab daran iya maka manga mulid na bayi magtipun pay'an. Si Judas itu aa song nongan si Isa ni manga banta na. ");
INSERT INTO slm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jari pay'an si Judas ni kabbun ian mo dambaanan sundalu bangsa Roma maka manga jaga min langgal pagkulbanan. Manga jaga itu bayi siyoho' uk manga imam nakura' maka uk manga Parisi. Magtakōs sigam maka magsu' maka magbo palitaan. ");
INSERT INTO slm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kitauhan asal uk si Isa kamemon iya song makani-iya, hangkan iya pasong pasampang ni manga aa ian. Uk na ni sigam, “Sayi peha bi?” ");
INSERT INTO slm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Uk sigam, “Peha kami si Isa, aa min Nasaret.” “Aku na iya,” uk si Isa. Si Judas, iya aa nongan si Isa ni manga banta na, ian magtangge maka manga aa ian. ");
INSERT INTO slm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Halling si Isa, “Aku na iya,” magtuwi sigam pasuhut pahantak. ");
INSERT INTO slm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jari tīyaw uk si Isa pabayik, uk na, “Sayi peha bi?” Uk sambung sigam, “Si Isa, aa min Nasaret.” ");
INSERT INTO slm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jari halling si Isa, uk na, “Bayi na kaam baan ku, iya na ko' aku itu. Bang aku iya peha bi, na pasarin bi manga sehe' ku itu mowe'.” ");
INSERT INTO slm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Salaitu halling na bo' niya' kamaksuran ma bayi panambahayang na ni 'Mma' na Tuhan, iya uk na hi', “O 'Mma', 'nsa' niya' lungay minsan dakayo' min manga aa bayi pamasuku' nu aku.” ");
INSERT INTO slm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Magtakōs asal si Simun Petros, jari hiyurusan uk na takōs na bo' lagut na sosohoan imam nakura'. Iya tawwa' tainga na ni katau, lutas magtuwi. Ōn sosohoan itu si Malkus. ");
INSERT INTO slm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Uk si Isa ni si Petros, “Sulugun takōs nu ni taguban na iyu. Akuhan ku du kamemon kabinsanaan iya pamakaral ma aku uk 'Mma' ku.” ");
INSERT INTO slm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Manjari siyaggaw si Isa uk manga sundalu maka kapitan sigam maka uk manga jaga Yahudi, bo' ingkōtan iya uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Biyo iya uk sigam pahi' ni si Annas dahu. Si Annas itu matoa si Kayapas, imam-nakura' ma tahun ian. ");
INSERT INTO slm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayapas iya bayi mandu' kagaraan ma manga nakura' Yahudi, iya uk na hap le' bang dakayo' du aa matay ganti' manga aa kamemon. ");
INSERT INTO slm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, paturul ma si Isa si Simun Petros maka mulid dakayo'. Mulid dakayo' itu magkatau asal maka imam nakura', hangkan iya makabe' ma si Isa sampay pasōd ni diyōm halaman luma' imam nakura' hi'. ");
INSERT INTO slm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Suga' si Petros iya tamban ma luwasan lawang. Lipara paluwas pabing mulid si Isa dakayo' hi'. Maid iya min danda ma nunggu' lawang bo' iyampa bo na si Petros pasōd. ");
INSERT INTO slm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tīyaw si Petros uk danda ma lawang ian. “Kau baha',” uk na, “dakayo' mulid isab ma aa siyaggaw ian?” Mayilu magtuwi si Petros. “'Nsa',” uk na. ");
INSERT INTO slm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na, haggut sangōm ian, hangkan manga sosohoan maka manga jaga hi' bayi ngandōkōt api, bo' ian sigam magtanggehan ma katilibut api magdangkahan. Pay'an isab si Petros patipun ni sigam parangka. ");
INSERT INTO slm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Manjari si Annas, iya bayi imam-nakura' dahu, numariya si Isa ma pasal manga mulid na maka ma pasal pamandu' na. ");
INSERT INTO slm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nambung si Isa, uk na, “Bayi aku manduan manga mahadjana' kamemon ma mata mayiran sadja. Ayi-ayi pamandu' ku bayi halling ku ma pagtipunan manga Yahudi, ma diyōm kalanggal-langgalan maka ma diyōm langgal pagkulbanan. 'Nsa' niya' bayi pamandu' ku ma kalimbungan aa. ");
INSERT INTO slm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Angay aku tiyaw nu? Tīyawun manga aa bayi kake ma pamandu' ku. Tīyawun sigam bang ayi bayi pamandu' ku. Katauhan sigam du.” ");
INSERT INTO slm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagbissala peen itu uk si Isa magtuwi iya siyampak uk dakayo' jaga bayi may'an, bo' uk na ni si Isa, “'Nsa' niya' addat nu nambungan imam-nakura' salaiyu!” ");
INSERT INTO slm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Siyambungan jaga ian uk si Isa, uk na, “Bang hati sā' halling ku ma imam-nakura', bain manga aa kamemon ma pagsaraan itu bang ayi kasaan halling ku. Suga' bang 'nsa' niya' sā' na, angay aku sampak nu?” ");
INSERT INTO slm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Puwas na hi' siyoho' si Isa uk si Annas tiyukbalan pahi' ni si Kayapas, imam-nakura', ma masi le' iya ingkōtan. ");
INSERT INTO slm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Simun Petros ian masi nangge ma parangkahan. Tīyaw iya uk manga sehe' na magtanggehan, uk sigam, “Kau baha', dakayo' mulid aa ian?” Mayilu si Petros. “'Nsa',” uk na. ");
INSERT INTO slm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ian isab dakayo' sosohoan imam nakura', niya' kasugsugan na ni aa bayi lutas tainga na uk si Petros. Uk sosohoan itu ni si Petros, “'Nsa' kau baha' bayi tanda' ku may'an ma diyōm kabbun me' ma aa hi'?” ");
INSERT INTO slm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mayilu si Petros pabing. “'Nsa',” uk na. Magtuwi du nigauk manuk. ");
INSERT INTO slm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dayi' 'llaw peen lahat, pipinda si Isa min luma' si Kayapas tudju ni luma' gubnul bangsa Roma. Suga' manga nakura' Yahudi 'nsa' pasōd ni diyōm luma' gubnul sabab bang sigam ganta' pasōd ni diyōm luma' 'nsa' luma' Yahudi, batal sigam bo' 'nsa' sigam makajari palamud magjamu ma hinang Pangintōman. ");
INSERT INTO slm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hangkan paluwas si Gubnul Pilatu ni sigam tiyaw ni sigam, uk na, “Ayi panuntutan bi aa itu?” ");
INSERT INTO slm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Uk sambung sigam, “'Nsa' du bayi tukbalan kami aa itu ni kau bang 'nsa' niya' dusa na.” ");
INSERT INTO slm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“Na,” uk si Pilatu ni sigam, “Kaam na ngahukum iya ma sali' kalangnganan sara' bi.” Nambung manga Yahudi, uk sigam, “'Nsa' niya' kapatut kami mabōtang hukuman ni kamatay minsan ma sayi.” ");
INSERT INTO slm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Salaihi' kahalan na supaya niya' kamaksuran bayi halling si Isa dahu pasal salaingga kamatay na. ");
INSERT INTO slm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pasōd si Pilatu ni diyōm luma' na pabing bo' soho' na si Isa biyo pahi' ni iya. Uk na ni si Isa, “Kau iyu, sultan baha' ma bangsa Yahudi?” ");
INSERT INTO slm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Uk sambung si Isa, “Iya tiyaw nu itu, min paghōna'-hōna' nu baha', atawa niya' aa saddi bayi ngahakahan kau ma pasalan ku?” ");
INSERT INTO slm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nambung si Pilatu, uk na, “Oy! Pangannal nu aku Yahudi baha'! Manga bangsa nu du maka manga nakura' kaimaman bi iya bayi nukbalan kau paitu ni aku. Angay, ayi dusa nu?” ");
INSERT INTO slm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nambung si Isa, uk na, “Iya pagsultanan ku 'nsa' ma itu ma dunya. Bang pagsultanan ku bayi ma itu ma dunya, bayi du ngatu manga bean ku bo' aku 'nsa' tasaggaw uk manga nakura' Yahudi. Aho', 'nsa' maitu pagsultanan ku.” ");
INSERT INTO slm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jari tīyaw iya uk si Pilatu, uk na, “Bang salaiyu, sultan kau baha'?” Uk sambung si Isa, “Kau iya halling in aku sultan. Iya na itu sababan na hangkan aku iyanak maka hangkan aku paitu ni dunya, supaya aku makapamissala ma pasal kasabannalan. Sasuku me' ma kasabannalan ningōd du ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Uk si Pilatu, “Ayi iya kasabannalan?” Puwas peen ian hi' paluwas si Pilatu pabayik pahi' ni manga Yahudi bo' uk na ma sigam, “'Nsa' niya' tapeha ku sababan pangahukuman ku aa itu. ");
INSERT INTO slm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Suga' kahaba' waktu paghinang hinang Pangintōman, iya kabiyaksahan bi subay niya' dakayo' pilisu palappa ku. Baya' kaam baha' bang palappahan ku kaam sultan bangsa Yahudi?” ");
INSERT INTO slm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Magpangōlang manga aa ian, uk sigam, “Daa bang aa iyu hi'. Si Barabbas iya kabayaan kami.” Na, si Barabbas itu mundu. ");
INSERT INTO slm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Manjari itu noho' si Pilatu si Isa subay liyapdōsan na. ");
INSERT INTO slm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Puwas na hi' niya' bahan itingan liyubid uk manga sundalu, hinang sali' dagbōs korona sultan panangōn uk sigam ma kok si Isa. Pijubahan isab iya uk sigam maka juba taluk, sali' dagbōs juba sultan. ");
INSERT INTO slm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Patampal sigam ni iya magbayik-bayik bahasa magtungging. Uk pagtungging sigam, “Assalamu alaykum, Appa' Sultan Yahudi!” Jari pigsampak iya uk sigam ma bayihu' na. ");
INSERT INTO slm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paluwas pabing si Pilatu missalahan baanan manga aa magtipunan ian, uk na, “'Ndaun bi. Tiya' si Isa paluwas ku ni kaam bo' supaya katauhan bi 'nsa' niya' tatawwa' ku sababan na pamabōtangan ku iya hukuman.” ");
INSERT INTO slm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jari paluwas isab si Isa. Masi le' bahan itingan siyangōn ma kok na, maka masi le' juba na taluk. Uk si Pilatu ni manga aa, “'Ndaun bi. Iya na itu aa hi'!” ");
INSERT INTO slm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pag'nda' peen manga imam nakura' maka manga jaga langgal ma si Isa, magtuwi sigam ngōlang, uk na, “Papatayun iya! Lansangun iya ni hag!” Uk si Pilatu ni sigam, “Baya'-baya' bi na! Kalloun bi bo' kaam na ngalansang iya ni diyata' hag. Suga' bang ma aku 'nsa' niya' sababan na tatawwa' ku pamabōtangan iya hukuman ni kamatay.” ");
INSERT INTO slm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Uk manga Yahudi ian ni iya, “Niya' sara' kami, uk na aa iyu subay piyatay sabab iya maghalling in iya Anak Tuhan kono'.” ");
INSERT INTO slm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Makake peen si Pilatu ma halling manga aa itu, gam peen pasong gawa na. ");
INSERT INTO slm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Biyo uk na si Isa pasōd pabayik ni diyōm luma' na bo' tīyaw na, uk na, “Minningga kau?” Suga' 'nsa' nambung si Isa. ");
INSERT INTO slm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Uk si Pilatu ni iya, “Angay kau? 'Nsa' aku sambungan nu? 'Nsa' katauhan nu baha', niya' kapatut ku malappa kau? Maka niya' kapatut ku ngalansang kau ni diyata' hag bo' kau piyatay.” ");
INSERT INTO slm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nambung si Isa, uk na, “Bang 'nsa' bayi min Tuhan muwanan kau kapatut, 'nsa' du niya' patut nu mapatay aku. Hangkan na aa bayi nukbalan aku ni kau mehe le' dusa na min dusa nu.” ");
INSERT INTO slm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Puwas na hi' meha lawang si Pilatu pamalappa na si Isa. Suga' magpangōlang na peen baanan Yahudi hi', uk sigam, “Bang kau malappa aa iyu, 'nsa' kau na bagay Sultan Mahatinggi. Sayi-sayi magsultan-sultan di na magbanta du maka Sultan Mahatinggi.” ");
INSERT INTO slm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagtake pamissala manga aa ian uk si Pilatu, biyo uk na si Isa paluwas. Bo' ningko' si Pilatu ma pangahukuman, ian ma halaman iyōnan Halaman Batu. (Gabbata ōn na bang ma bahasa Hibrani.) ");
INSERT INTO slm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'Llaw ian 'llaw pagsakap jamu ma hinang Pangintōman, maka song lattu 'llaw na. Jari pagtingko' si Pilatu uk na ni manga aa, “Tiya' na Sultan bi!” ");
INSERT INTO slm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Suga' magpangōlang sadja manga aa ian, uk sigam, “Papatayun na! Papatayun na! Lansangun ni diyata' hag!” Tīyaw sigam uk si Pilatu, uk na, “Angay, kabayaan bi baha' subay soho' ku sultan bi liyansang ni hag?” Nambung manga nakura' imam, uk na, “'Nsa' niya' sultan kami, duwal Sultan Mahatinggi!” ");
INSERT INTO slm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jari siyongan si Isa uk si Pilatu pahi' ni sigam, supaya iya biyo liyansang ni hag piyatay. Manjari biyo na si Isa uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Paluwas iya min daira maka uk na nanggung hag iya song pangalansangan iya. Patudju iya ni lahat iyōnan Lahat Baung Kok. (ōn na Golgota bang ma bahasa Hibrani). ");
INSERT INTO slm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pagmahi' na, liyansang si Isa ni hag uk manga sundalu bo' pitangge hag hi'. Niya' isab duwangan lalla liyansang ni diyata' hag sigam min bihing si Isa karuwambiya'. ");
INSERT INTO slm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Niya' sulat pamahati bayi siyulat uk si Gubnul Pilatu, siyoho' pipahi' ni diyata' hag si Isa. Uk sulat hi', “Si Isa aa Nasaret, Sultan bangsa Yahudi.” ");
INSERT INTO slm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Heka aa bayi makabassa sulat itu sabab lahat pamapatayan si Isa ian sikōt ni Awrusalam, maka sulat itu bayi tasulat ma bahasa Hibrani maka ma bahasa Roma maka ma bahasa Girik. ");
INSERT INTO slm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Nsa' baya' manga nakura' imam ma lapal sulat hi', hangkan uk sigam pahi' ni si Pilatu, “Daa sulatun, ‘Sultan bangsa Yahudi’. Gam na peen iya sulatun, ‘Aa itu maghalling in iya sultan bangsa Yahudi.’ ” ");
INSERT INTO slm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nambung si Pilatu, uk na, “Iya tasulat ku 'nsa' na kapindahan.” ");
INSERT INTO slm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ubus peen uk manga sundalu bayi ngalansang si Isa ni hag sampay matangge hag na, ngallo' sigam sammek na bo' bihagi' 'mpat uk sigam ma dangan maka dangan. Niya' le' dakayo' badju' si Isa 'nsa' niya' lappi' na, langkos hinangan na. ");
INSERT INTO slm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Maghalling manga sundalu, uk na, “Daa gese' ta badju' itu. Hap le' pagkootan ta bo' katauhan ta bang sayi karapuhan na.” Pagka salaihi' hinang manga sundalu ian, niya' kamaksuran ma bayi tasulat ma diyōm kitab, iya uk na, “Kapagbahagian sammek ku uk manga aa. Pigkoot-kootan uk sigam badju' ku bang sayi karapuhan na.” ");
INSERT INTO slm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, ina' si Isa, maka danakan ina' na, maka si Mariyam handa si Kolopas, maka si Mariyam min lahat Magdala, ian magtanggehan ma bihing hag bayi pangalansangan si Isa. ");
INSERT INTO slm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tanda' uk si Isa ina' na maka dakayo' mulid na iya kalasahan na may'an, bo' uk na ni ina' na, “Mulid ku iyu anak nu na.” ");
INSERT INTO slm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uk na isab ni mulid na ian, “Iyu na ina' nu.” Hangkan na puwas min 'llaw ian ina' si Isa bayi biyo uk mulid ian paōkōm ma iya. ");
INSERT INTO slm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Manjari itu kitauhan uk si Isa tangbus na kamemon bayi pamahinang ma iya. Sakali uk na, “Toho' kallong ku.” Salaitu halling na bo' niya' kamaksuran ma bayi tasulat ma diyōm kitab. ");
INSERT INTO slm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Niya' may'an dakayo' pōga-pōga liyōōnan inuman kisōm, hangkan manga sundalu bayi ngahagōman lappus ni diyōm inuman hi'. Pisagnat uk sigam ni tong kayu-kayu bo' iyampa piabut pahi' ni bo' si Isa. ");
INSERT INTO slm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Makasassōp peen si Isa ma inuman, uk na, “Tangbus na hinang ku.” Jari patoyok kok na maka bakkat na napas na. ");
INSERT INTO slm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, pagka 'llaw Jumaat na salaihi', ngamu' manga nakura' Yahudi pahi' ni si Pilatu, siyoho' hiyopoan nayi' manga aa tallungan bayi liyansang ian ni hag, bo' supaya lakkas matay, bo' tapareyo' min hag ma 'nsa' le' taabut 'llaw Sabtu'. 'Nsa' baya' manga nakura' bang patay ian taggōl pisaran ma diyata' hag sampay ma 'llaw Sabtu', sabab Sabtu' ian landu' halga' asal ma bōgbōg sigam. ");
INSERT INTO slm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hangkan pahi' manga sundalu ngahopoan nayi' manga aa duwangan bayi liyansang ni hag, iya bayi mag-abay maka si Isa, ubus nayi' dangan bo' dangan. ");
INSERT INTO slm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Suga' makaabut peen sigam ni si Isa, tanda' uk sigam in iya matay na asal, hangkan 'nsa' kalausan hiyopoan nayi' na. ");
INSERT INTO slm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gam peen biyudjak kid na maka budjak uk dakayo' sundalu ian bo' paluwas magtuwi laha' maka bohe'. ");
INSERT INTO slm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Aa bayi makanda' iya tahinang itu ma si Isa, siyulat uk na manga pakaradjaan itu supaya kaam magkahagad isab. Kapangandōlan du panaksi' aa manulat itu, maka katauhan na bannal asal bissala na.) ");
INSERT INTO slm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Patakka salaitu supaya niya' kamaksuran ma bayi tasulat ma diyōm kitab, iya uk na, “'Nsa' niya' bōkōg na hopo' minsan dakayo'.” ");
INSERT INTO slm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Maka niya' le' ayat kitab dakayo', iya uk na, “Nganda' du sigam ma aa bayi biyudjak uk sigam.” ");
INSERT INTO slm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Puwas na hi' niya' dakayo' aa min lahat Arimati, ōn na si Yusup. Dakayo' iya mulid si Isa suga' bayi limbungan na kapagmulid na sabab tiyāw iya liyaat uk manga nakura' Yahudi. Pahi' iya ni si Pilatu maid ngallo' patay si Isa. Pitugutan iya uk si Pilatu hangkan iya pay'an mareyo' patay si Isa min diyata' hag. ");
INSERT INTO slm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sehe' na si Nikudimus, iya bayi pahi' ni si Isa ma dakayo' sangōm bayi waktu palabay. Si Nikudimus itu mo manga limampu' kilu laksi', ōn na mira maka alos, duwa ginis na piglamugay. ");
INSERT INTO slm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Manjari killo' patay si Isa uk manga aa duwangan itu bo' iyampa siyaput uk sigam maka kuku pote' pihian laksi', sali' addat bangsa Yahudi bang malihala' patay. ");
INSERT INTO slm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niya' kabbun ma tōngōd bayi pamapatayan si Isa, maka niya' ma diyōm kabbun ian pangubulan bahu bayi liyowangan ma diyōm pampang batu. 'Nsa' le' niya' bayi takubul may'an. ");
INSERT INTO slm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jari itu, pagka song sangōm Sabtu' na, kiyubul mayat si Isa pay'an sabab sikōt du pangubulan ian ni bayi pamapatayan iya. ");
INSERT INTO slm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dayi' 'llaw Ahad peen, ma 'nsa' le' pote' sōbangan, pahi' ni kubul si Mariyam, danda min lahat Magdala. Tanda' na hi' na bayi pikalloan batu panambōl lowang kubul. ");
INSERT INTO slm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sakali paragan iya pahi' maan si Simun Petros maka mulid dakayo', iya kilasahan asal uk si Isa. Uk si Mariyam ni sigam, “'Nsa' na may'an Panghu' kitabi. Niya' bayi ngallo' iya min diyōm kubul maka 'nsa' katauhan kami bang maingga pamabōtangan sigam ma iya.” ");
INSERT INTO slm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Manjari si Petros maka mulid dakayo' pahi' magtuwi tudju ni kubul. ");
INSERT INTO slm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Paragan sigam karuwangan suga' lakkas le' mulid dakayo' itu min si Petros, bo' makarahu iya takka ni kubul. ");
INSERT INTO slm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pakoko' iya pasib ni diyōm na bo' tanda' na manga saput may'an, suga' 'nsa' iya pasōd. ");
INSERT INTO slm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jari takka na si Petros min damuwihan na bo' magtuwi iya pasōd ni diyōm kubul. Tanda' na saput si Isa pabōtangan di na may'an, ");
INSERT INTO slm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","maka tanda' na turung muka na liyunan. Saddi kabōtangan na, 'nsa' magbe' maka saput hi'. ");
INSERT INTO slm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Manjari mulid dakayo', iya bayi makarahu pay'an, pasōd na isab. Pag'nda' na saput magtuwi iya magkahagad na pasal si Isa. ");
INSERT INTO slm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Niya' asal bayi tasulat ma diyōm kitab ma pasalan si Isa, in iya subay 'llum du pabing min kamatay na, suga' 'nsa' le' bayi tahati lapal kitab ian uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Manjari mowe' na sigam duwangan. ");
INSERT INTO slm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Suga' si Mariyam iya nangge na peen mahi' ma tōngōd kubul hi', maka uk na nangis. Sabu peen iya nangis, pakoko' iya pasib ni diyōm kubul. ");
INSERT INTO slm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Niya' tanda' na duwa malaikat magjuba pote' ningko' may'an ma bayi pamabōtangan mayat si Isa, dangan hi' min bayi kok na, dangan hi' min bayi nayi' na. ");
INSERT INTO slm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Uk manga malaikat itu ni iya, “Inda' angay kau hangkan nangis?” Nambung si Mariyam, uk na, “Sabab hi' bayi killoan uk sigam mayat Panghu' ku, maka 'nsa' katauhan ku bang paingga iya pamabōtangan sigam ma iya.” ");
INSERT INTO slm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ubus peen itu pihalling uk si Mariyam, palingi' iya bo' tanda' na si Isa nangge may'an, suga' 'nsa' takila na bang si Isa. ");
INSERT INTO slm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Uk si Isa ni iya, “Inda', angay kau nangis? Sayi peha nu?” Kibā' uk si Mariyam in aa ian tunggu' kabbun, hangkan uk na ni iya, “Tuwan, bang kau bayi mo mayat na minnitu, bain aku bang maingga pamabōtangan nu iya bo' aku pahi' ngallo' iya pabing.” ");
INSERT INTO slm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Uk si Isa ni iya, “Mariyam.” Magtuwi harap na si Isa bo' uk na ni iya ma sali' bissala Hibrani, “Rabbuni!” Hati na “guru”. ");
INSERT INTO slm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Uk si Isa ni iya, “Daa aku intanin sabab 'nsa' le' aku bayi makapowe' pahi' ni 'Mma' ku. Suga' pahi' kau ni manga dawuranakan ku. Maka bain sigam in aku mowe' na ni 'Mma' ku maka Tuhan ku, hati na ni 'Mma' sigam maka Tuhan sigam.” ");
INSERT INTO slm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jari si Mariyam, danda min Magdala, pahi' na maan manga mulid pasal kapanganda' na ma si Panghu' Isa maka pasal bayi halling si Isa ma iya. ");
INSERT INTO slm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sangōm peen 'llaw Ahad hi', magtipun manga mulid si Isa ma diyōm luma'. Manga lawang na bayi kiyansingan pahōgōt sabab tiyāw sigam ma manga nakura' Yahudi. Sakali si Isa pay'an nangge ma tangnga'-tangnga' sigam bo' halling na ni sigam, “Mura-murahan, bang peen kaam kaniyaan kasannangan atay.” ");
INSERT INTO slm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Manjari pandaan na sigam manga limpa' ma tangan na maka ma kid na. Kiyōgan tōōd manga mulid na ian pag'nda' sigam ma Panghu' sigam. ");
INSERT INTO slm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Missala si Isa pabing, uk na ma sigam, “Mura-murahan, bang peen kaam kaniyaan kasannangan atay. Soho' ta kaam sali' bayi panohoan aku paitu uk 'Mma' ku.” ");
INSERT INTO slm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Puwas na hi' nganapas si Isa ma sigam maka uk na, “Tayimaun bi na Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bang ampun bi dusa aa, iyampunun du dusa sigam uk Tuhan. Bang 'nsa' ampun bi, iya du 'nsa' iyampunun uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, ma waktu kaluwas si Isa ni manga mulid na ian 'nsa' bayi may'an si Tomas. Si Tomas itu dakayo' mulid si Isa min sangpu' ka duwa, danglay na si Kambal. ");
INSERT INTO slm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Manjari biyaan iya uk kasehean, uk sigam, “Bayi tanda' kami Panghu' tabi.” Suga' uk si Tomas, “Bang 'nsa' tanyata' ku maka tasadsad ku limpa' lansang ma pat tangan na, maka bang 'nsa' tasadsad ku pali' ma kid na, 'nsa' du aku magkahagad.” ");
INSERT INTO slm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Labay peen pitungallaw minnihi' magtipun na pabayik manga mulid si Isa ma diyōm luma', maka ian na si Tomas. Kiyansingan asal manga lawang hi', suga' pay'an sadja si Isa nangge ma tangnga'-tangnga' sigam bo' uk na, “Mura-murahan, bang peen kaam kaniyaan kasannangan atay.” ");
INSERT INTO slm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jari halling iya ni si Tomas, uk na, “'Ndaun manga tangan ku itu. Abutun maka tong tangan nu. Paabutun tangan nu paitu ni kid ku. Daa na kau magduwa-duwa. Magkahagad na kau tōōd.” ");
INSERT INTO slm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Halling si Tomas, uk na, “Kau iya Panghu' ku maka kau Tuhan ku!” ");
INSERT INTO slm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Uk si Isa ni iya, “Iyampa kau magkahagad baha', pagka tanda' nu na aku? Mehe kalasigan manga aa magkahagad ma aku minsan aku 'nsa' tanda' uk sigam.” ");
INSERT INTO slm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Heka le' manga hinang makainu-inu bayi tahinang uk si Isa ma panganda' manga mulid na, saddi min manga hinang iya tasulat ma juran itu. ");
INSERT INTO slm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Suga' manga kahinangan iya siyulat ma diyōm juran itu, iya hangkan itu siyulat bo' supaya pagkahagad bi si Isa in iya bannal si Almasi, Anak Tuhan, maka supaya kaam kaniyaan kallum kakkal ni kasaumulan ma sabab pagkahagad bi ma iya. ");
INSERT INTO slm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Puwas manga pilangallaw minnihi' paluwas si Isa pabing ni manga mulid na mahi' ma bihing danaw Tibiri. Salaitu iya kaluwas na ian ni sigam: ");
INSERT INTO slm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Si Simun Petros bayi may'an magbe' maka si Tomas iya diyanglay si Kambal, maka si Natanael iya min kalumaan Kana mahi' ma lahat Jalil. Ian isab magbe' manga anak si Sibidi, maka duwangan mulid si Isa saddi. ");
INSERT INTO slm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na, halling si Simun Petros, uk na. “Pareyawut le' aku mōkōt.” “Me' kami,” uk kasehean hi'. Jari pariyata' sigam ni bayanan bo' pahi' ni deyawut, suga' 'nsa' niya' takallo' sigam sampay ni karayi'-llawan. ");
INSERT INTO slm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dayi' 'llaw peen, ian si Isa nangge ma bihingan suga' 'nsa' iya takila uk manga mulid na. ");
INSERT INTO slm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ngalingan iya pahi' ni sigam, uk na, “O manga bagay, 'nsa' niya' baha' takallo' bi?” “'Nsa',” uk sigam. ");
INSERT INTO slm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Na,” uk si Isa, “hugun bi pōkōt bi sakap min katau iyu bo' kaam makakallo'.” Hangkan hiyug uk sigam pōkōt hi'. Paghug itu magtuwi 'nsa' takowe' hella' uk sigam pariyata' ni diyōm bayanan, ma sabab kaheka daying na. ");
INSERT INTO slm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Manjari halling dakayo' mulid iya kilasahan uk si Isa. Uk na ni si Petros, “Panghu' ta ko' ian!” Makake peen si Simun Petros itu, magtuwi sulug na pabing badju' na bayi hurusan na, bo' iyampa iya pakuppa ni diyōm danaw tudju pahi' ni si Isa. ");
INSERT INTO slm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Manga mulid kasehean me' le' ma bayi bayanan sigam, maka uk sigam ngangguyud pōkōt panno' uk daying. Sikōt du sigam ni bihing, niya' manga limampu' dappa lawak na. ");
INSERT INTO slm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Makaruwai peen sigam ni bihing niya' tanda' uk sigam api maka manga daying tiyapa ma baga na, maka niya' isab manga tinapay. ");
INSERT INTO slm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Uk si Isa ni sigam, “Bohun bi paitu manga daying min bayi takallo' bi iyu.” ");
INSERT INTO slm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hangkan pahi' si Simun Petros pasakat pabing ni pamean sigam bo' guyud na pōkōt tudju ni de. Panno' pōkōt ian uk daying aslag, dahatus maka limampu' maka tallu heka na. Suga' pōkōt hi' 'nsa' gese' minsan lōōn na heka kalandu'. ");
INSERT INTO slm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Uk si Isa ni sigam, “Dayi' kaam mangan.” 'Nsa' niya' ma manga mulid na ian makatawakkal niyaw iya bang sayi iya, sabab kitauhan uk sigam in iya Panghu' sigam du. ");
INSERT INTO slm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jari pahi' si Isa ngallo' tinapay bo' pamuwan na ni sigam, damikkiyan na manga daying. ");
INSERT INTO slm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kamintallu na na itu kaluwas si Isa ni manga mulid na damuwi peen min 'llaw bayi pamakallum iya min kamatay na. ");
INSERT INTO slm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ubus peen uk sigam mangan, missala si Isa ni si Simun Petros. “Simun anak si Yahiya,” uk na, “lasa nu ni aku, labi le' baha' min manga sehe' nu itu?” “Aho' Panghu',” uk si Petros, “katauhan nu in aku lasa du ma kau.” Uk si Isa, “Na, ipatun manga bili-bili ku (hati na manga aa suku' ku).” ");
INSERT INTO slm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tiyaw si Isa pabing, uk na, “Simun anak si Yahiya, kalasahan nu aku baha'?” “Aho', Panghu',” uk na, “katauhan nu du in aku lasa du ma kau.” Uk si Isa, “Na, ipatun manga bili-bili ku.” ");
INSERT INTO slm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kamintallu na na paniyaw si Isa ma si Petros. “Simun anak si Yahiya,” uk na, “kalasahan nu aku baha'?” Susa na si Petros sabab pimintallu le' uk si Isa paniyaw na ma iya, iya uk na, “Lasa kau baha' ma aku.” Hangkan nambung si Petros ma si Isa, uk na, “Panghu', kasakupan nu kamemon. Katauhan nu in aku lasa du ma kau.” Uk si Isa ma iya, “Na, ipatun manga bili-bili ku. ");
INSERT INTO slm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bannal iya pama' ku itu ma kau,” uk si Isa, “ma kaonde' nu le' bayi kau makasammekan di nu. Bayi kau mangngan paingga-paingga iya kabayaan nu. Suga' bang kau toa na pahannat nu du tangan nu bo' aa saddi iya ngingkōtan kau bo' kau biyo ni papahian 'nsa' kabayaan nu.” ");
INSERT INTO slm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Bissala itu uk si Isa pamatau na bang salaingga bohan kamatay si Petros ma sosongun, kamatay pamehe na ma Tuhan. Puwas na hi' uk si Isa ma si Petros, “Me' sadja kau ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jari palingi' si Petros bo' tanda' na paturul mulid dakayo', iya kilasahan uk si Isa. Iya na itu mulid bayi paking ni si Isa ma waktu kapagjamu sigam, maka bayi tiyaw iya, iya uk na, “Tuwan Panghu', sayi baha' song nongan kau ni manga banta nu?” ");
INSERT INTO slm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pag'nda' si Petros ni mulid dakayo' itu, uk na ni si Isa, “Panghu', salaingga aa ian hi'?” ");
INSERT INTO slm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Uk si Isa ni si Petros, “Bang sawupama kabayaan ku aa ian subay 'llum sampay ni kabing ku paitu ni dunya, 'nsa' du kalagihan nu. Me' sadja kau ma aku.” ");
INSERT INTO slm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jari pigbissala uk manga bean si Isa pasal mulid na dakayo' itu 'nsa' magkamatay. Suga' 'nsa' si Isa bayi halling in aa ian 'nsa' du matay. Iya sadja uk na, bang sawupama kabayaan na mulid na ian subay 'llum sampay kabing na ni dunya, 'nsa' du kalagihan si Petros. ");
INSERT INTO slm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iya mulid pigba'-ba' itu, iya na aa ma'-ma' pasal manga pakaradjaan itu, maka iya isab bayi nulat itu kamemon. Maka katauhan kami in lapal na asal bannal. ");
INSERT INTO slm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Heka tōōd manga hinang saddi bayi tahinang uk si Isa. Bang manga hinang itu ganta' tasulat kamemon ma diyōm kitab, kumpas ku 'nsa' sarang ma diyōm dunya manga kitab iya panulatan iya. ");
INSERT INTO slm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sulat itu min si Lukas tudju ni si Teyopilus. Tuwan Teyopilus, ma kitab bayi tasulat ku dahu, bayi pama' ku manga hinang maka pandu' si Isa kamemon, sataggōl min tagna' kapaghinang na ");
INSERT INTO slm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sampay ni 'llaw bayi pamaangkat iya tudju ni sulga'. Ma 'nsa' le' iya bayi paangkat, siyoho' uk na manga aa bayi kawakilan na. Iya panohoan na ma sigam bayi min kawasa Nyawa Sutsi asal. ");
INSERT INTO slm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Puwas peen kamatay si Isa, ma diyōm 'mpatpu' 'llaw daran iya panyata' magbaran ni manga aa bayi kawakilan na hi'. Min heka iya mandaan di na bo' manyatakan tōōd in iya asal 'llum. Tanda' iya uk sigam bo' ma diyōm peen 'mpatpu' 'llaw hi', missala iya ni sigam pasal kapagparinta Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Makapagtipun peen sigam ma waktu dakayo', noho' iya ma sigam, uk na, “Daa le' kaam pakallo' min daira Awrusalam. Agarin bi dahu bayi paljanjian 'Mma' ku iya subay pamuwan na ma kaam, iya bayi pamatau ku ma kaam. ");
INSERT INTO slm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Si Yahiya hi', bohe' iya bayi pamandi na manga aa. Suga' kaam, saddi iya pamandi kaam. Labay peen manga pilang 'llaw, pisangōn du Nyawa Sutsi ni diyōm baran bi iyu.” ");
INSERT INTO slm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Manjari itu, magtipun peen sigam maka si Isa, tiyaw sigam ma iya. “Tuwan Panghu',” uk sigam, “iya na itu baha' waktu pamabayik nu ni bangsa kami Israil iya bayi kapatut kami tagna' ngantan pagparinta?” ");
INSERT INTO slm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Uk sambung si Isa, “'Mma' ku sadja iya taga kapatut mabōtang waktu maka masa. Kaam iyu subay 'nsa' makatau pasal ian. ");
INSERT INTO slm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Suga',” uk si Isa, “kabuwanan du kaam kawasa ma waktu kasangōn Nyawa Sutsi ni diyōm baran bi. Bo' kaam iya magpasabannal ma pasal ku ma daira Awrusalam itu, ma kalohahan lahat Yahudiya, ma lahat Samariya, sampay ma 'mpat pidju alam itu.” ");
INSERT INTO slm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ubus peen pamissala si Isa hi', tabo iya paangkat tudju ni sulga', sabu sigam nganda'-nganda' ma iya. Sakali kalimbuhan iya uk gabun, 'nsa' na tanda' uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Masi na peen papatong manga aa itu tudju ni langit, ni bayi kaangkatan na hi', magtuwi niya' duwangan lalla magpamakay pote' nangge ma tōngōd sigam. ");
INSERT INTO slm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Uk duwangan itu ni sigam, “Kaam manga aa Jalil! Angay kaam magtangge maiyu papatong na peen tudju ni langit? Si Isa, iya bayi tabo paangkat min kaam tudju ni sulga', pabing du, bo' kabing na paitu sali' du maka bayi kaangkat na tudju ni sulga' iya kakanda' bi sini'.” ");
INSERT INTO slm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sakali mowe' na manga aa kawakilan hi' min Bud Kayu Jaitun tudju ni Awrusalam, manga dabatu lawak na hi'. ");
INSERT INTO slm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Makatakka peen sigam ni Awrusalam, magtuwi sigam pariyata' ni bilik paghantian sigam. Ian may'an di si Petros, si Yahiya, si Ya'kub, si Andariyas, si Pilip, si Tomas, si Bartolome, si Matiyu, si Ya'kub anak si Alpa, si Simun iya diyanglay si Pangangatu, maka si Judas isab anak si Ya'kub dakayo'. ");
INSERT INTO slm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Daran sigam magtipun magsambahayang. Parōngan isab ma sigam manga karandahan, sampay si Mariyam ina' si Isa maka manga danakan si Isa lalla. ");
INSERT INTO slm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na 'nsa' taggōl minnihi', magtipun manga aa magpangandōl ma si Isa. Niya' sigam kulang-labi dahatus maka duwampu'. Manjari nangge si Petros ma tangnga' sigam missala. ");
INSERT INTO slm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Manga dawuranakan ku,” uk na, “wajib subay niya' kamaksuran ma lapal Nyawa Sutsi, iya bayi siyulat uk si Daud hi'. Lapal hi' bayi ma pasal si Judas hi', iya bayi manduan manga aa managgaw si Isa. ");
INSERT INTO slm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas hi' bayi du dansehean maka kitabi,” uk si Petros. “Bayi iya kawakilan uk si Isa maghinang sali' hinang tabi itu.” ");
INSERT INTO slm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iya sin bayi panamba si Judas ma hinang na malaat, iya panong na si Isa ni manga banta na, bayi pamalli na tana'. Taballi na peen tana' hi', hug iya pareyo' may'an bo' bustak battōng na. Paluwas lōngōn-lōngōn na kamemon. ");
INSERT INTO slm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kitauhan ian hi' uk manga aa Awrusalam kamemon, hangkan tana' ian iyōnan uk sigam Akeldama, ma bahasa Yahudi. Hati na “Tana' Tamba Laha'” ");
INSERT INTO slm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Na,” uk si Petros, “niya' tasulat ma diyōm kitab Jabul, iya uk na, ‘Bang peen kallo' pabōtangan na. Subay 'nsa' niya' pabōtang may'an pabing.’ Maka niya' isab ayat dakayo', uk na hi', ‘Subay niya' aa saddi paganti' ma bayi hinang na hi'.’ ” ");
INSERT INTO slm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Missala le' si Petros, uk na, “Hangkan na subay niya' aa saddi paganti' me' ma kitabi naksi' in si Panghu' Isa 'llum na pabing min kamatay na. Iya pene' subay aa bayi sehe' tabi ma waktu kaparōngan si Panghu' Isa ma kitabi, tagna' na ma waktu kapamandi aa uk si Yahiya sampay ni 'llaw bayi kaangkat si Isa min kitabi tudju ni sulga'.” ");
INSERT INTO slm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Sakali itu siyabbut uk sigam ōn duwangan lalla pamenean sigam. Dakayo' ian si Yusup, iya iyōnan si Barsabbas (atawa si Justus), maka dakayo' si Mattiyas. ");
INSERT INTO slm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ngamu'-ngamu' di si Petros ni Tuhan, uk sigam, “O Tuhan, katauhan nu bang ayi ma diyōm pikilan manusiya' kamemon. Toun kono' ni kami bang sayi pene' nu ma duwangan itu ");
INSERT INTO slm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ganti' si Judas, bo' tahinang na hinang iya pamasuku' nu ma manga aa kawakilan nu. Sabab hinang itu libbahan na ko' uk si Judas, maka hi' na iya mowe' ni lahat na kakkal.” ");
INSERT INTO slm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Puwas ian pigkoot uk sigam ōn aa ian. Iya takoot ian ōn si Mattiyas, jari pikannōp iya ni kasangpu' maka issa ian iya bayi kawakilan uk si Isa. ");
INSERT INTO slm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Taabut peen 'llaw paghinang iya iyōnan Pentekosta, magtipun manga aa magpangandōl ma si Isa kamemon. ");
INSERT INTO slm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Saruun-duun du niya' bahonos min langit, sali' baliyu landōs patumbuk. Magtuwi tasōd kamehehan luma' iya pagtingkoan sigam ian. ");
INSERT INTO slm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bo' tanda' uk sigam api sali' dagbōs dalla' pasaplag sampay pabōtang ma manga aa ian pakaniya-pakaniya. ");
INSERT INTO slm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Manjari sigam kamemon ian pisangōnan Nyawa Sutsi bo' nagna' sigam magbissala ma ginisan bahasa. Ayi-ayi pamuwan sigam min kawasa Nyawa Tuhan, iya na hi' pamissala uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, niya' bayi pahanti' may'an ma Awrusalam manga aa bangsa Yahudi min sabarang lahat, aa mag-aagama lullun. ");
INSERT INTO slm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagtake sigam hebok min diyōm luma' ian magtuwi landu' heka sigam bayi patipun pay'an. Inu-inu sigam ma bissala manga bean si Isa, sabab iya take uk sigam dangan maka dangan ian asal paghalling na. ");
INSERT INTO slm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kiyōblaan sigam kamemon, inu-inu bidda', hangkan uk sigam, “Painay itu! Iya magpamissala itu manga aa min lahat Jalil sadja! ");
INSERT INTO slm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Angay sigam take tabi makabissala ma asal paghalling tabi, dangan kitabi maka dangan? ");
INSERT INTO slm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kitabi itu,” uk sigam, “min kalahat-lahatan ko'. Niya' itu min lahat Partiya, min Medda, min Elam, niya' min Mesopotamiya, min lahat Yahudiya itu, min Kappadoke, min Puntus maka min Asiya. ");
INSERT INTO slm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Niya' isab kitabi min Pirigiya, min Pampiliya, min lahat Misil maka min kalahatan Libiya iya ma kasikōtan lahat Kirini. Niya' isab kitabi min daira Roma. ");
INSERT INTO slm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Niya' kitabi kasehean bangsa Yahudi, maka niya' kasehean 'nsa' Yahudi, aa papinda na ni agama Yahudi. Aho', niya' isab min pu' Kerete maka min lahat Arab. Suga' minsan kitabi minningga lahat, take tabi manga aa itu missala ma paghalling tabi. Take tabi pasal hinang kawasa iya hinang uk Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Manjari inu-inu manga aa magtipunan ian kamemon, maka sali' sasaw. Tiyaw na peen sigam dangan maka dangan, uk na, “Ayi baha' hatihan na itu?” ");
INSERT INTO slm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Suga' niya' kasehean ngudju'-ngudju' ma manga bean si Isa ian. Uk sigam, “Manga aa itu liyango!” ");
INSERT INTO slm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Suga' nangge si Petros maka sehe' na sangpu' kadda, bo' kōsōg uk na missala ma manga aa magtipunan ian. “Kaam manga pagkahi ku Yahudi,” uk na, “sampay kaam iyu maglahat ma daira Awrusalam itu! Pake kaam bo' kaam pahati ku pasal pakaradjaan iya take bi itu. ");
INSERT INTO slm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kaba' bi liyango manga aa magpamissala itu, suga' 'nsa'. 'Nsa' du niya' maglangohan bang lisag siyam le' subu! ");
INSERT INTO slm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iya tanda' bi itu, iya na ko' itu kamaksuran na bayi pilatun uk si Nabi Joel ma masa awwal hi'. Uk na, ");
INSERT INTO slm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Iya itu hinang ku ma manga 'llaw damuwi, uk Tuhan. Pasangōn ku Nyawa ku ma manusiya' kamemon. Manga panubu' bi lalla-danda maluwas du lapal ku. Manga lalla onde' bahu le' makanda' du pakaradjaan 'nsa' le' takka. Makaupi isab manga maas bi. ");
INSERT INTO slm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aho', uk Tuhan, minsan manga ata ku lalla-danda, Pasangōn ku Nyawa ku ni sigam ma masa ian hi', Bo' sigam iya maluwas palman ku. ");
INSERT INTO slm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pahinang ku isab hinang makainu-inu ma diyata' langit, Maka manga paltandaan ma babaw dunya. Tanda' laha' maka api maka humbu kapal. ");
INSERT INTO slm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mata 'llaw, maglindōm du, Maka bulan pinda ni pula, sali' dagbōs laha', Bang song takka 'llaw pangahukum uk Panghu' bi, 'llaw na mehe. ");
INSERT INTO slm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jari sayi-sayi nabbut ma ōn Tuhan mikitabang, kalappasan du iya.’ ” ");
INSERT INTO slm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Uk si Petros le', “Kaam pagkahi ku bangsa Israil, pake kaam ma bissala ku itu. Si Isa, aa Nasaret, bayi pamatumanan ma panganda' bi in iya bayi siyoho' uk Tuhan. Sabab biyuwanan iya barakat uk Tuhan hangkan tahinang na manga hinang kawasa kainu-inuhan aa, sampay manga paltandaan. Katauhan bi asal, sabab ma itu ma diyōman bi iya bayi pangahinangan na manga hinang hi'. ");
INSERT INTO slm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","In kamatay si Isa itu kitauhan asal uk Tuhan ma 'nsa' le' bayi piniya'. Min niyat na maka maksud na hangkan si Isa bayi siyongan ni pangantanan bi, bo' kaam iya bayi mapatay iya pagka pasaran bi aa jahulaka' ngalansang iya ni hag. ");
INSERT INTO slm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Suga' pikallum iya pabayik min kamatay na uk Tuhan. Pihawulaya iya uk Tuhan min katiksaan kamatay, sabab in iya 'nsa' tōōd kapagbayaan uk kamatay. ");
INSERT INTO slm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Niya' bayi tasulat uk si Daud masa awwal hi' ma pasal Isa Almasi itu. Uk na, ‘Tasayu ku Panghu' ku ma tōngōd ku sakahaba' waktu. Tiya' na iya ma bihing ku, hangkan aku 'nsa' tasasaw. ");
INSERT INTO slm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hangkan kiyōgan diyōm atay ku, Maka kiyōgan isab pamissala ku. Minsan matay baran ku hōwat sadja aku ma iya, hangkan aku taga salamat. ");
INSERT INTO slm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sabab 'nsa' du aku pasaran nu ma lahat manga magpatayan. Aku iya sosohoan nu adil, 'Nsa' pasaran nu baran ku ngahalu' ma diyōm kubul. ");
INSERT INTO slm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bayi aku panduan nu daddōk iya mo ni kallum kakkal. Basta aku maiyu ma haddarat nu, landu' tōōd kakuyagan ku.’ ");
INSERT INTO slm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Na, manga dawuranakan ku,” uk si Petros, “subay tampal pamissala ku ma kaam pasal bayi ka'mbo'-mboan ta si Sultan Daud hi'. Bayi iya matay sampay kiyubul, maka kubul na masi tasilang sampay ni 'llaw itu. ");
INSERT INTO slm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Suga' nabi iya bayi, hangkan kitauhan uk na bang ayi bayi janji' Tuhan ma iya. Sabab Tuhan iya bayi napa pasal waktu siyong subay niya' dakayo' panubu' si Daud magsultan du, sali' bayi asal kapagsultan si Daud. ");
INSERT INTO slm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Na, pagka kitauhan uk si Daud bang ayi pitakka uk Tuhan ma waktu siyong, hangkan iya bayi magpalatun pasal kallum si Almasi pabing min kamatay na. Uk pagpalatun na hi', ‘'Nsa' iya bayi imbanan ma lahat manga magpatayan. 'Nsa' isab bayi ngahalu' baran na ma diyōm paliyangan.’ ");
INSERT INTO slm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Isa ko' itu,” uk si Petros, “iya pikallum uk Tuhan pabing min kamatay na. Bo' kami kamemon itu saksi' du, in kallum na pabayik asal bannal du. ");
INSERT INTO slm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pilangkaw na iya, pitōngōd ma bihing Tuhan sakap ni katau. Siyambut uk na Nyawa Sutsi min 'Mma' na Tuhan sali' bayi panganjanji' na ma iya. Manjari iya tanda' bi maka take bi buttihi' hinang Nyawa Tuhan ko', iya pisangōnan kami uk si Isa. ");
INSERT INTO slm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Si Daud hi' bayi missala pasal dangan aa bayi tapaangkat ni diyōm sulga'. 'Nsa' si Daud iya bayi paangkat ni sulga', suga' iya na itu bayi tabissala na hi', uk na, ‘Missala Tuhan ni Panghu' ku, uk na, Dayi' kau, ningko' kau ma bihing ku sakap ni katau, ma paningkoan bangsahan, ");
INSERT INTO slm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Sampay tabo ku palbantahan nu tatawu' ma deyo' pat-nayi' nu.’ ");
INSERT INTO slm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hangkan na,” uk si Petros, “in kaam bangsa Israil kamemon, subay katauhan bi in si Isa itu, iya bayi talansang bi ni hag, tahinang na uk Tuhan. In iya Panghu' na maka Almasi, hati na pene' uk Tuhan magbaya'!” ");
INSERT INTO slm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagtake manga aa ma pamissala si Petros itu magtuwi sasaw bidda' pikilan sigam. Uk sigam ni si Petros maka ni kasehean kawakilan hi', “Manga dawuranakan,” uk sigam, “ayi subay hinang kami?” ");
INSERT INTO slm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Uk si Petros ni sigam, “Tawubatin bi tōōd dusa bi. Bo' kaam dangan maka dangan subay piyandi min ōn si Isa Almasi, palsaksian in kaam mangandōl ma iya. Manjari du iyampun dusa bi maka piniyaan du kaam Nyawa Sutsi, iya pamuwan Tuhan ma kaam. ");
INSERT INTO slm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sabab kaam du iya bayi kajanjian uk Tuhan, sampay manga panubu' bi, sampay isab sigam ma katahan, sayi-sayi bayi linganan uk Panghu' tabi Tuhan me' ma iya.” ");
INSERT INTO slm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Heka le' bissala si Petros ma manga aa ian. Biyandaan sigam uk na, junjungan pahap-hap, uk na, “Papuwas kaam kono' min mulka', iya song pitumbuk ni bangsa malaat itu!” ");
INSERT INTO slm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Manjari heka magkahagad ma bissala si Petros ian bo' piyandi sigam tanda' in sigam suku' si Isa na. Iya pikannōp ni manga aa mangandōl ma si Isa ma 'llaw ian, niya' manga tallungibu aa. ");
INSERT INTO slm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ngasip sigam ma bayi pamandu' uk manga aa kawakilan si Isa ian, maka magdakayo' sigam maka manga aa magpangandōl kasehean. Magbahagian sigam tinapay di sigam maka magbe' isab sigam nambahayang. ");
INSERT INTO slm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Heka hinang makainu-inu maka paltandaan bayi tahinang uk manga aa kawakilan hi', hangkan siyōd tāw manga aa kamemon. ");
INSERT INTO slm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Magdakayo' na peen manga aa magpangandōl kamemon, maka ayi-ayi bayi ma sigam pangahilas uk sigam ma sasuku taga sukkal. ");
INSERT INTO slm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pangalta' sigam maka kaginisan sigam bayi piballihan, bo' ballihan na bayi pamahagi' ni kasehean, sarang ma sukkal sigam dangan maka dangan. ");
INSERT INTO slm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Llaw-llaw sigam mahi' ma diyōm langgal pagkulbanan. Magsawu sigam ma kalumaan sigam. Kiyōgan sigam magbahagi' kiyakan min atay pote'. ");
INSERT INTO slm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Siyanglitan na peen Tuhan uk sigam, bo' sigam iya kihapan uk aa kamemon. Sakahaba'-haba' niya' na peen bayi pikannōp ni sigam uk Tuhan, sasuku kalappasan min hukuman dusa. ");
INSERT INTO slm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na, ma 'llaw dakayo', pahi' si Petros maka si Yahiya ni langgal pagkulbanan ma waktu sambahayang luhul. ");
INSERT INTO slm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","May'an, ma tōngōd lawang langgal iyōnan Lawang Lingkat, niya' dakayo' aa 'nsa' makalangnganan di na, asal min kandang ina' na. Biyo iya 'llaw-llaw ni tōngōd bo' lawang ian supaya iya makapangamu' sarakka ni manga aa palabay minnian tudju ni diyōm langgal. ");
INSERT INTO slm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pag'nda' na ma si Petros maka ma si Yahiya ian song pasōd, magtuwi iya ngamu' ayi-ayi ni sigam. ");
INSERT INTO slm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Inda' iya uk sigam. Uk si Petros, “Nganda' kau ni kami itu!” ");
INSERT INTO slm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Magtuwi nganda' aa ian, hōwat kabuwanan ayi-ayi uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Suga' uk si Petros ni iya, “'Nsa' niya' tōōd sin ku suga' pamuwan ku ma kau iya ma aku itu. Min kawasa ōn si Isa Almasi aa Nasaret, soho' ta kau nangge bo' mangngan!” ");
INSERT INTO slm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sakali intanan iya uk si Petros ma tangan na ni katau, tiyabang bo' makatangge. Saruun-duun du iya biyuwanan kōsōg ma nayi' na sampay ma buku-buku na. ");
INSERT INTO slm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Magtuwi iya patulahad pariyata'. Nangge iya bo' iyampa mangngan. Puwas na hi' magbe' iya maka di si Petros pasōd ni diyōm langgal. Mangngan iya maka uk na maglaksu' sampay nanglit ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tanda' iya uk manga aa magtipun may'an mangngan na peen maka nanglit na peen ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Takila iya uk sigam in iya bayi ningko' ngamu' sarakka ma langgal ma bo' Lawang Lingkat. Magtuwi sigam inu-inu maka sasaw pikilan sigam uk bayi tahinang ma aa ian. ");
INSERT INTO slm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ngantan le' aa ian ma si Petros maka ma si Yahiya, ma sawurung langgal iya iyōnan Sawurung si Sulayman. Jari inu-inu manga aa kamemon bo' paragan pay'an ni di si Petros. ");
INSERT INTO slm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pag'nda' peen si Petros ma manga aa ian missala iya ma sigam, uk na, “Oy, kaam aa Israil! Angay itu pag-inu-inuhan bi! Angay kami patongan bi? Pangannal bi baha' min kawasa kami atawa min kasutsi atay kami, iya hangkan aa itu makalangngan na? ");
INSERT INTO slm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Katauhan bi,” uk si Petros, “in ka'mbo'-mboan tabi, iya di si Ibrahim, si Isahak maka si Ya'kub, dapagtuhanan du maka kitabi. Manjari Tuhan tabi itu, bayi pilangkaw uk na sosohoan na si Isa, iya bayi songan bi ni sara'. Bayi iya tasulak bi ma alōpan si Gubnul Pilatu. Si Pilatu bayi taga niyat malappa si Isa, suga' kaam iya 'nsa' baya'. ");
INSERT INTO slm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Minsan si Isa sutsi maka adil, bayi iya sulak bi. Bo' aa pamapatay iya amu' bi ni gubnul subay piluwas. ");
INSERT INTO slm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bayi papatay bi poonan kallum, lipara pikallum iya pabing uk Tuhan min kamatay na. Kami itu saksi' in ian bannal. ");
INSERT INTO slm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na,” uk si Petros, “min kawasa ōn si Isa, hangkan aa bayi 'nsa' kalangngan itu kabuwanan kōsōg bo' makalangngan na. Tanda' bi na iya, maka takila bi asal. Aho', min pangandōl tudju ni si Isa iya hangkan aa itu kaulian ma panganda' bi. ");
INSERT INTO slm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Manga dawuranakan ku,” uk si Petros, “katauhan ku in kaam maka manga nakura' bi bayi awam, iya hangkan bayi salaihi' hinang bi ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Suga' iya na ko' hi' pamatuman palman Tuhan, iya bayi pitau uk kanabi-nabihan min awwal le' hi'. Pitau uk sigam in si Almasi subay makalabay kabinsanaan. ");
INSERT INTO slm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na,” uk si Petros, “tayikutin bi na dusa bi. Papinda kaam ni Tuhan bo' piyapasan uk na dusa bi, ");
INSERT INTO slm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","bo' kaam piniyaan kahayangan atay min Tuhan. Jari pipaitu du si Isa, iya Almasi bayi tapene' uk Tuhan magbaya' ma kaam. ");
INSERT INTO slm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Suga' subay may'an le' iya ma sulga' sampay taabut waktu pamabahu kamemon ayi-ayi uk Tuhan. Iya na ko' ian waktu bayi janji' uk Tuhan ma palman na ni manga nabi ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sabab si Musa bayi missala ni bangsa Israil, uk na, ‘Ma sosongun niya' du dakayo' nabi pipaitu ni kaam uk Tuhan iya Panghu' bi. Pipaitu iya sali' kapanoho' Tuhan ma aku, maka aa bangsa bi du iya. Wajib iya subay asip bi ma ayi-ayi pamissala na ma kaam. ");
INSERT INTO slm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sayi-sayi 'nsa' ngasip ma nabi ian, piōkat du iya uk Tuhan min bangsa suku' na sampay miyula.’ ");
INSERT INTO slm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Salaihi' du isab,” uk si Petros, “manga nabi kamemon, tiyagnaan min si Nabi Samwel sampay ni kanabi-nabihan magsusunu'. Bayi sigam magpalatun ma pasal pakaradjaan iya piniya' waktu itu. ");
INSERT INTO slm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma kaam du isab manga janji' Tuhan iya bayi pagpalatun uk manga kanabi-nabihan, maka palsukuan bi isab bayi kapagsulutan Tuhan maka ka'mbo'-mboan bi. Bayi nganjanji' Tuhan ma pangkat bi si Ibrahim, uk na, ‘In bangsa kamemon ma diyōm dunya itu piniyaan kahapan du ma sabab panubu' nu.’ ");
INSERT INTO slm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hangkan si Isa tapene' uk Tuhan sosohoan na, bo' pipaiyu iya ni kaam dahu bo' kaam piniyaan kahapan, hati na biyo kaam ngalabba min kahinangan bi laat.” ");
INSERT INTO slm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Masi le' si Petros maka si Yahiya missala ma manga aa, sakali niya' pay'an ni sigam manga imam maka kapitan jaga langgal pagkulbanan, maka manga Saddusi. ");
INSERT INTO slm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paddi' asal atay sigam sabab di si Petros ian hi' mandu' ma manga aa in si Isa bayi 'llum pabayik min kamatay na, hangkan manga aa magpatayan tantu du isab 'llum pabayik ma sosongun. ");
INSERT INTO slm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Manjari siyaggaw di si Petros, liyōōn ni diyōm jil sampay ni kasawungan sabab kohap na tōōd. ");
INSERT INTO slm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Suga' heka aa bayi kake ma bissala di si Petros bo' magkahagad ma si Isa. Iya heka sigam lalla mangandōl ma si Isa niya' manga limangibu. ");
INSERT INTO slm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Taabut peen sawung magtipun na ma Awrusalam manga kanakuraan bangsa Yahudi, manga kamaasan, maka manga guru ma sara' agama. ");
INSERT INTO slm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ian du may'an si Annas imam-nakura', maka ian isab di si Kayapas, si Yahiya, si Iskandal, maka manga kampung si Annas kasehean. ");
INSERT INTO slm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Manjari duwangan aa kawakilan hi' siyoho' paalōp ni sigam. Tīyaw sigam duwangan uk manga nakura' hi', uk na, “Salaingga uk bi makahinang iya bayi hinang bi diaw hi'? Kawasa ayi bayi pangahinang bi salaihi', atawa ōn sayi bayi panabbutan bi?” ");
INSERT INTO slm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Manjari si Petros ian pisangōnan Nyawa Sutsi, bo' sambungan na manga nakura' ian, uk na, “Kaam manga nakura' bangsa Yahudi, maka kaam manga maas, ");
INSERT INTO slm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bang kami sumariya bi ma pasal kahapan bayi tahinang ma aa 'nsa' bayi kalangngan itu, maka pasal bang salaingga bayi kapakowe' iya, ");
INSERT INTO slm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, iya na itu subay kitauhan uk bi kamemon, sampay uk bangsa Israil kamemon. Aa itu, iya nangge itu ma alōpan bi, hangkan iya kaulian na sabab kawasa si Isa Almasi aa Nasaret! Bayi iya pilansang uk bi ni hag, lipara pikallum iya min kamatay na uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Pasal si Isa itu iya bayi siyulat ma diyōm kitab, iya uk na, ‘Iya batu bayi siyulak uk bi, manga aa maghinang luma', Iya na ian batu mehe tōōd kalagihan na.’ ");
INSERT INTO slm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Nsa' tōōd niya' saddi min si Isa ma kalohahan dunya makalappas kitabi min mulka'. Duwal ōn si Isa bayi pamuwan uk Tuhan panabbutan manusiya', bo' supaya kitabi kalappasan.” ");
INSERT INTO slm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sakali inu-inu manga kanakuraan ian pag'nda' sigam ma kōsōg bissala si Petros maka si Yahiya. Kitauhan isab in sigam duwangan aa deyo' asal, 'nsa' bayi makalabay pangadji' langkaw. Manjari kila sigam pahap uk kanakuraan hi' sabab bayi sigam magsehe' maka si Isa. ");
INSERT INTO slm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Malayingkan 'nsa' niya' panganjawab uk manga nakura', sabab ian ma panganda' sigam aa bayi kaulian, nanggehan di na ma tōngōd di si Petros. ");
INSERT INTO slm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hangkan di si Petros siyoho' paluwas min palhimpunan bo' iyampa mag-isunan di sigam manga nakura' hi'. ");
INSERT INTO slm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Uk sigam, “Ayi baha' subay hinang tabi ma manga aa itu? 'Nsa' kitabi makapayilu pasal bayi tahinang uk sigam, sabab kitauhan uk aa kamemon ma diyōm Awrusalam itu niya' hinang mehe kawasa bayi tahinang uk sigam duwangan itu. ");
INSERT INTO slm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Suga',” uk sigam, “supaya 'nsa' patanyag palkala' itu, bandaan ta na sigam tōōd daa subay missala pabing ma pasal ōn si Isa.” ");
INSERT INTO slm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hangkan si Petros maka si Yahiya linganan pabayik uk manga nakura' ian. Biyandaan sigam subay daa tōōd missala atawa mandu' pabing ma pasal si Isa. ");
INSERT INTO slm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Suga' nambung si Petros maka si Yahiya ma aa bayi mamanda' hi', uk sigam, “Kumpasun bi kono' bang ingga iya bōntōl ma panganda' Tuhan: kaam manusiya' subay bine' uk kami, atawa Tuhan? ");
INSERT INTO slm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sabab 'nsa' kami makajari parōhōng ma'-ma' ma manga aa pasal iya bayi tanda' kami maka bayi take kami hi'.” ");
INSERT INTO slm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Manjari pikōsōg gam peen uk manga nakura' ian iya sanggup sigam ma di si Petros. Puwas na hi' pilappa na sigam. 'Nsa' niya' tatawwa' uk manga nakura' sababan paminsana' sigam ma di si Petros, sabab ian manga aa mahadjana' kamemon nanglitan Tuhan ma sabab hinang kawasahan bayi tahinang hi'. ");
INSERT INTO slm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na, iya aa bayi kaulian na hi' asal labi 'mpatpu' tahun na umul na. ");
INSERT INTO slm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na, tapalappa peen di si Petros, magtuwi sigam pabing ni kasehean sigam ma'-ma' pasal kamemon bayi halling manga kaimaman nakura' maka manga kamaasan. ");
INSERT INTO slm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Take peen ian hi' uk kasehean, magtuwi sigam kamemon magbe' ngamu'-ngamu' ni Tuhan. “O Tuhan Panghu' kami,” uk sigam, “kau iya bayi mapanjari langit maka dunya itu de-deyawut, sampay kakaya'-kayaan na. ");
INSERT INTO slm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bayi pabissala nu sosohoan nu si Daud, pangkat kami. Kahōpan iya uk Nyawa Sutsi, hangkan uk na, ‘Angay magdugal manga bangsa saddi ma Panghu'. Angay manga aa itu magkagaraan laat ma 'nsa' niya' pus na! ");
INSERT INTO slm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Manga kasultanan ma dunya ian magsakap! Maka manga kanakuraan magtipun na, Ngatubang Tuhan maka Almasi na, iya tapene' na mag-agi!’ ");
INSERT INTO slm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bannal Tuhan,” uk sigam, “sabab manga Yahudi bayi magdakayo' maka manga aa 'nsa' Yahudi, ma itu ma daira Awrusalam. Magbe' isab sigam maka di si Sultan Herod maka si Gubnul Puntus Pilatu bahasa ngatubang ni si Isa, iya sosohoan nu sutsi bayi tahinang nu Almasi hi'. ");
INSERT INTO slm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hinang uk sigam kamemon iya bayi niyat nu, min kawasa nu asal maka min kahandak nu. ");
INSERT INTO slm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na, Tuhan, buttihi' kehun sanggup sigam ma kami. Tabangin kami manga sosohoan nu, bo' kami 'nsa' tiyāw missala lapal nu. ");
INSERT INTO slm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Patandaun kono' kōsōg nu makowe' manga aa sakihan. Pahinangun isab manga hinang makainu-inu maka paltandaan min kawasa ōn si Isa, iya sosohoan nu sutsi.” ");
INSERT INTO slm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na, ubus peen sigam nambahayang, jōgjōg luma' bayi pagtipunan sigam bo' pihōpan sigam uk Nyawa Sutsi. Minnihi' sigam missala lapal Tuhan, 'nsa' tōōd niya' tāw sigam ma aa. ");
INSERT INTO slm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Manjari itu magdaatay maka magdakayo' kagaraan manga aa magpangandōl ma si Isa kamemon ian. 'Nsa' niya' halling pasal kaniya' na in ian suku' na sadja, suga' sama-bahagi' sigam kamemon ma ayi-ayi bayi ma sigam. ");
INSERT INTO slm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Manga aa kawakilan ian mag-abut-abut naksi' pasal kallum si Panghu' Isa pabing min kamatay na. Jari kawasa tōōd panaksi' sigam, bo' landu' sigam kahapan uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'Nsa' niya' ma diyōman sigam kulang-kabus. Sasuku taga tana' atawa luma', piballihan uk sigam bo' ballihan na bayi ");
INSERT INTO slm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","siyongan ni aa kawakilan ian. Jari in sin ian bayi pigbahagian ma sasuku taga susa. ");
INSERT INTO slm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, niya' ma diyōman sigam aa iyōnan si Yusup. Bayi iya iyanak ma pu' Kiprus suga' bangsa Yahudi iya, panubu' si Libi. Iyōnan iya si Barnabas uk manga aa kawakilan (hati na, aa matōtōg iman). ");
INSERT INTO slm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Niya' tana' bayi ma si Barnabas itu, bo' paballihan na tana'. Jari siyongan ballihan na ni manga aa kawakilan ian. ");
INSERT INTO slm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Suga' niya' ian dakayo' aa iyōnan si Ananiyas, handa na si Sappira. Niya' tana' na bayi paballihan na, ");
INSERT INTO slm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","suga' ballihan na kasehean bayi tawuan na di na. Tiyau isab itu uk handa na. Jari sin takapin bayi siyongan ni manga aa kawakilan. ");
INSERT INTO slm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Uk si Petros ni iya, “Ananiyas, angay pasaran nu nakura' sayitan magbaya' ma diyōm atay nu, mo-mo kau mutingan Nyawa Sutsi? Sabab iyu bayi tawu' nu sin kasehean bayi ballihan tana' nu hi'. ");
INSERT INTO slm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sataggōl 'nsa' bayi paballihan nu, suku' nu asal tana' ian. Maka bang hi' na bayi kapaballihan nu, suku' nu ballihan na ian kapagbayaan nu. Jari angay tapikil nu maghinang salaiyu? 'Nsa' manusiya' iya pagputingan nu, suga' Tuhan!” ");
INSERT INTO slm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pagtake peen uk si Ananiyas halling si Petros ian, magtuwi iya pahantak matay. Jari sasuku makake ma pasal kamatay na ian siyōd tāw bidda'. ");
INSERT INTO slm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sakali pasōd pay'an manga kalallahan onde' bahu le' naput patay na bo' iyampa biyo paluwas minnihi', kiyubul. ");
INSERT INTO slm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na, palabay peen manga tallun jam, takka pay'an handa si Ananiyas, suga' 'nsa' katauhan na bang ayi bayi patakka hi'. ");
INSERT INTO slm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Uk si Petros ni iya, “Bain aku. Iya na itu baha' sin kamemon bayi takallo' bi maglakibini min ballihan tana' bi?” “Aho',” uk danda, “iya na ko'.” ");
INSERT INTO slm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Uk si Petros, “Angay kaam maglakibini bayi maggara' nulayan Nyawa Tuhan! Pake kau,” uk si Petros. “Iyu na ma bo' lawang manga aa bayi ngubul halla nu sini'. Maka iya du kau biyo kiyubul uk sigam.” ");
INSERT INTO slm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Saruun-duun du pahantak danda ian ma tōngōd nayi' si Petros, matay. Pagsōd peen manga kalallahan onde' bahu, tanda' iya uk sigam matay na, hangkan iya biyo uk sigam kiyubul ni bihing halla na. ");
INSERT INTO slm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Minnihi' bidda' tāw manga jamaa si Isa kamemon sampay sasuku bayi makake ma pasal ian hi'. ");
INSERT INTO slm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Heka manga paltandaan maka hinang makainu-inu bayi tahinang ma diyōman manga aa Awrusalam ian uk manga aa kawakilan uk si Isa. Jari sasuku magpangandōl ma si Isa daran magtipun kamemon ma Sawurung si Sulayman. ");
INSERT INTO slm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mehe pag-addat manga aa mahadjana' ma sigam, suga' 'nsa' niya' aa saddi tawakkal palamud ni sigam. ");
INSERT INTO slm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Suga' masi na peen magkakannōp manga aa mangandōl ma si Panghu' Isa. Heka sigam magdanda-maglalla. ");
INSERT INTO slm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sakali itu, pagka salaihi' iya kahinangan manga aa kawakilan ian, biyo manga aa sakihan paluwas ni manga karaddōk-daddōkan, pibahak ma bangko atawa ma baluy sigam. Hangkan salaihi', kalu niya' sigam kasehean tawwa' uk lambung si Petros bang iya ganta' palabay minnian. ");
INSERT INTO slm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Heka isab manga aa bayi pay'an min manga kalumaan ma kalingkal Awrusalam, mo sehe' sigam magsakihan atawa aa siyōd uk sayitan. Jari kaulian na sigam kamemon. ");
INSERT INTO slm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na, pagka salaihi', ngimbu bidda' imam-nakura' maka kasehean na, iya min bahagi' agama Yahudi iyōnan Saddusi, bo' gara' sigam ngatu ma manga aa kawakilan si Isa. ");
INSERT INTO slm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hangkan sigam noho' subay siyaggaw manga aa bayi kawakilan ian bo' iyampa liyōōn na ni diyōm jil parinta. ");
INSERT INTO slm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Suga' sangōm ian niya' malaikat min Tuhan bayi pay'an ngukab tambōl jil, ngallo' manga aa kawakilan ian paluwas. ");
INSERT INTO slm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Uk malaikat ni sigam, “Pahi' na kaam nangge ma diyōm langgal pagkulbanan hi' bo' kaam missala ma manga aa ian pasal kallum bi bahu itu, bang ayi tōōd hatihan na.” ");
INSERT INTO slm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bine' magtuwi panohoan malaikat ian uk manga aa kawakilan, bo' pasōd sigam dayi' 'llaw le' ni diyōm langgal pagkulbanan magpandu'. Sakali in imam nakura' maka manga sehe' na ian bayi noho' magtipun manga kamaasan bangsa Israil, iya aa palhimpunan kamemon. Puwas na hi' noho' sigam ma manga tindōg pahi' ni jil mo manga aa kawakilan paalōp ni palhimpunan hi'. ");
INSERT INTO slm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Suga' pagtakka manga tindōg ni pagjilan 'nsa' tatawwa' may'an manga aa kawakilan. Hangkan pabing manga tindōg itu ni palhimpunan ma'-ma'. ");
INSERT INTO slm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Uk sigam ni palhimpunan, “Takka peen kami pay'an ni jil, asal hōgōt manga tambōl. Maka ian masi manga aa nganjagahan tambōl ian. Suga' pag-ukab kami peen, 'nsa' niya' tatawwa' kami ma diyōm!” ");
INSERT INTO slm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na, take peen ian hi' uk kapitan manga jaga langgal sampay uk kaimaman nakura', 'nsa' tapikil uk sigam pasal manga aa kawakilan ian bang ayi katudjuhan na. ");
INSERT INTO slm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sakali niya' aa takka pay'an ni palhimpunan mo lapal, uk na, “Pake kaam! Iya aa bayi pajil bi ian, ian na ma diyōm langgal manduan manga aa!” ");
INSERT INTO slm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Magtuwi pahi' kapitan maka manga aa na ngallo' di si Petros. Suga' 'nsa' sigam bayi ngandagtu' ma di si Petros sabab tiyāw sigam hiyak maka batu uk baanan manga aa may'an. ");
INSERT INTO slm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Manga aa kawakilan itu biyo uk sigam pitampal pahi' ni palhimpunan kamaasan. Jari siyumariya sigam uk imam-nakura', ");
INSERT INTO slm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","uk na, “Bayi kaam bandaan kami tōōd daa subay mandu' pasal aa iya pamean bi iyu. Suga' 'ndaun bi na iya tahinang bi itu! Saplag diyōm Awrusalam ma sabab pandu' bi. Baya' tōōd kaam mabōtangan kami dusa ni kamatay aa hi'!” uk na. ");
INSERT INTO slm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nambung si Petros maka kasehean bayi kawakilan hi', uk sigam, “Panohoan Tuhan iya subay be' kami, 'nsa' panohoan manusiya'. ");
INSERT INTO slm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Si Isa ian,” uk sigam, “bayi soho' bi liyansang ni hag bo' piyatay. Lipara pikallum iya pabing uk Tuhan, iya asal pagtuhanan manga pangkat tabi. ");
INSERT INTO slm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tapalangkaw na iya uk Tuhan, pibōtang ma bihing na sakap ni katau magnakura' sampay manglalappas ma manusiya', bo' supaya niya' pagtawubatan maka pag-ampunan dusa ma bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami itu,” uk di si Petros, “naksi' kami in pakaradjaan pamissala ku itu bannal sadja. Iya du makasaksi' Nyawa Sutsi, iya pamuwan uk Tuhan ma sasuku me' ma panohoan na.” ");
INSERT INTO slm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagtake peen bissala itu uk ma palhimpunan, pasu' tōōd atay sigam bo' nuyu' sigam mapatay manga aa kawakilan ian. ");
INSERT INTO slm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Suga' niya' dangan min palhimpunan ian nangge. Parisi iya, ōn na si Gamaliyal, dakayo' guru ma sara' agama, aa pig-addatan asal uk aa kamemon. Pagtangge na noho' iya piluwas dayi'-dayi' manga aa siyumariya ian. ");
INSERT INTO slm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Uk na ni palhimpunan ian, “Kaam pagkahi ku bangsa Israil, kamaya'-maya' kaam ayi-ayi song hinang bi ma manga aa ma luwasan itu. ");
INSERT INTO slm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Intōmun bi bayi dahu-dahu le', niya' bayi iyōnan si Tudas magpamehe di na. Niya' isab manga 'mpat hatus aa bayi paumpig ma iya. Suga' iya katudjuhan na, piyatay si Tudas bo' manga tindōg na ian kawukanat. Jari 'nsa' na. ");
INSERT INTO slm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Damuwi le' min si Tudas, niya' isab pasunu' dakayo' aa Jalil, ōn na si Judas, ma timpu pagsulat ōn aa kamemon uk parinta. Heka isab manga aa bayi tabo na paumpig ma iya, suga' iya du iya bayi piyatay maka kawukanat isab bayi tindōg na kamemon. ");
INSERT INTO slm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hangkan kaam bandaan ku na ma pasal palkala' itu hi'. Daa inayun bi manga aa itu. Pasarin bi sadja. Sabab bang hal min pikilan manusiya' iya miyaksud maka hinang uk sigam itu, 'nsa' du makasong. ");
INSERT INTO slm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Suga' bang min Tuhan du, 'nsa' tasagga' bi. Kalu isab sagga' bi kabayaan Tuhan!” Manjari be' manga aa palhimpunan ma pamissala si Gamaliyal hi'. ");
INSERT INTO slm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Linganan uk sigam manga aa kawakilan ian pisōd bo' iyampa siyoho' liyapdōsan. Biyandaan sigam daa subay missala pabing ma pasal si Isa, bo' piluwas minnihi' uk manga palhimpunan. ");
INSERT INTO slm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pakallo' manga aa kawakilan min palhimpunan hi'. Makalandu' sigam kiyōgan, sabab tabista sigam uk Tuhan tōp pilabay min kabinsanaan ma sabab pangandōl sigam ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kahaba'-haba' 'llaw ian sigam ma diyōm langgal pagkulbanan sampay manga ma luma' aa magpandu' na peen maka magnasihat lapal hap pasal si Isa Almasi. ");
INSERT INTO slm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pakannōp na peen manga aa me' ma si Isa. Jari ma masa ian niya' pagsaggaan manga Yahudi iya magbissala bahasa Girik, maka manga Yahudi kasehean iya magbissala asal bahasa Hibrani. Iya makalaat atay manga Yahudi mamissala Girik ian, in karandahan sigam balu tiyayikutan kono' ma waktu kapagtōpōd-tōpōd balanja' 'llaw-llaw. ");
INSERT INTO slm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hangkan manga bean si Isa kamemon linganan uk sangpu' ka duwa aa kawakilan, siyoho' magtipun. Uk sangpu' ka duwa ian, “'Nsa' bōntōl bang kami ngalabbahan hinang kami magnasihat palman Tuhan, bo' mahagi' manga paggastu. ");
INSERT INTO slm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hangkan na, manga dawuranakan, subay kaam mene' pitu' lalla min diyōman bi iyu. Aa ian subay katauhan bi in sigam kahōpan du uk Nyawa Sutsi, maka subay lōm tau sigam. Pagpene' bi peen, pamuwan kami ni sigam iya hinang magtōpōran balanja' ian. ");
INSERT INTO slm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Manjari kami itu,” uk aa kawakilan hi', “manuyu' na peen nambahayang maka magnasihat palman Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na, kasulutan aa ian kamemon ma bayi kagaraan hi' bo' tapene' uk sigam si Esteban, aa bal-iman maka kahōpan uk Nyawa Tuhan. Tapene' isab si Pilip, si Porokoros, si Nikanul, si Timun, si Parmenas, maka si Nikulas min Antiyuk. Si Nikulas itu 'nsa' Yahudi, aa ko' iya bayi pinda ni agama Yahudi. ");
INSERT INTO slm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iya kapitu' aa itu bayi pitampal uk kasehean ni manga aa kawakilan. Jari iyamuan sigam tabang min Tuhan uk aa kawakilan. Pitappakan sigam tangan isab, tanda' in sigam pisukuan hinang ian. ");
INSERT INTO slm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Manjari pasaplag na peen palman Tuhan. Pakannōp tōōd ma diyōm Awrusalam iya heka manga aa me' ma si Isa, maka heka isab kapakilan me' mangandōl ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban ian aa bidda' tiyabang uk Tuhan, aa biyarakatan, hangkan heka hinang makainu-inu maka paltandaan bayi tahinang uk na ma diyōman manga aa ma Awrusalam. ");
INSERT INTO slm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Suga' niya' manga aa nagga' iya, jamaa min dakayo' langgal iyōnan Langgal Aa Hawulaya. Aa ian asal min daira Kirini maka min daira Iskandal. Jari magbe' sigam maka manga Yahudi kasehean min lahat Silisi maka min lahat Asiya isab, bo' jawab si Esteban uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lipara si Esteban bayi kabuwanan pangatau lōm uk Nyawa Tuhan, hangkan manga aa ian 'nsa' makaatu ma bissala na. ");
INSERT INTO slm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sakali niya' manga aa saddi tiyambahan uk manga aa nagga' ian. Siyoho' sigam ma'-ma' puting pasal si Esteban. Iya uk puting sigam, “Bayi na take kami aa itu halling pangkal ma si Musa maka ma Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Minnihi' niya' sasaw ma kahekahan aa ian maka ma manga kamaasan maka manga guru sara' agama. Hangkan sigam pay'an ni si Esteban naggaw iya, bo' biyo iya ni palhimpunan. ");
INSERT INTO slm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Niya' isab biyo uk sigam manga aa iya magsaksi' puting ma pasal si Esteban. Uk saksi' puting hi', “Aa itu 'nsa' parōhōng missala kalaatan pasal langgal tabi sutsi itu, maka pasal sara' agama tabi. ");
INSERT INTO slm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bayi iya take kami halling in si Isa, aa Nasaret hi', song ngalangkat langgal itu. Maka pindahan uk na kono' kaaddatan kamemon bayi pangamban ma kitabi uk si Musa.” ");
INSERT INTO slm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Manjari piyatongan si Esteban uk manga aa maningko' ma palhimpunan hi' bo' tanda' uk sigam pamayihuan si Esteban ngandagbōs pamayihuan malaikat. ");
INSERT INTO slm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Manjari tīyaw si Esteban uk imam nakura', uk na, “Bannal baha' iya halling sigam iyu?” ");
INSERT INTO slm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nambung si Esteban, uk na, “Manga maas-danakan ku, pake kaam kono'. Iya Tuhan Sanglit-sahaya bayi paluwas ni pangkat tabi si Ibrahim, waktu kapaglahat na ma Mesopotamiya. 'Nsa' le' iya bayi maglahat ma Haran ma waktu ian hi'. ");
INSERT INTO slm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uk Tuhan ni iya, ‘Pakallo' kau min lahat nu porol iyu maka min kaheka nu. Pahi' kau tudju ni lahat dakayo', iya pandaan ku ni kau ma sosongun.’ ");
INSERT INTO slm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hangkan si Ibrahim bayi maglayin min lahat Kaldeya tudju ni lahat Haran maglahat may'an. Matay peen 'mma' na, pilayin iya uk Tuhan tudju ni lahat itu, iya paglahatan tabi buttihi'. ");
INSERT INTO slm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Suga' 'nsa' le' iya bayi kabuwanan tana' uk Tuhan palsukuan na ma lahat itu, minsan laa tana' sarang pag'ddōkan nayi' na sadja. Suga' janjian iya uk Tuhan, in iya sampay panubu' na subay du pisukuan lahat itu. Bo' ma waktu bayi panganjanji' Tuhan hi', bayi 'nsa' le' niya' tubu' si Ibrahim. ");
INSERT INTO slm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Salaitu bayi bissala Tuhan ma si Ibrahim, uk na, ‘Maglahat du manga panubu' nu ma lahat bangsa saddi. Tahinang du sigam banyaga' sampay tiksa' uk bangsa ian ma diyōm 'mpat hatus tahun. ");
INSERT INTO slm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Suga' pabōtang ku hukuman ku ma bangsa iya song manyaga' manga panubu' nu. Puwas na hi', paluwas ku du sigam min lahat pamanyagaan hi' bo' maghinang du sigam ni aku ma lahat itu.’ ");
INSERT INTO slm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Sakali si Ibrahim bayi kabuwanan addat pag-islam hi', tanda' palsaksian in iya maka panubu' na taga kapagsulutan maka Tuhan. Hangkan anak na si Isahak bayi pig-islam uk si Ibrahim, taabut peen walu' 'llaw ma luwasan. Iya du si Isahak, bayi du isab ngislam anak na si Ya'kub. Maka si Ya'kub hi' bayi ngislam anak na sangpu' ka duwa, iya ka'mbo'-mboan babantugun ma bangsa tabi Yahudi. ");
INSERT INTO slm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Manjari,” uk si Esteban, “si Yusup bayi imbu uk manga siyaka na, iya manga anak si Ya'kub kasehean. Hangkan iya piballihan uk sigam, biyo ni lahat Misil biyanyaga' may'an. Suga' 'nsa' iya pisaran uk Tuhan, ");
INSERT INTO slm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","bo' piyuwas iya uk Tuhan min kasusahan na kamemon bayi kalabayan na. Biyuwanan iya uk Tuhan kajarihan hap maka pangatau lōm ma waktu kaalōp na ni sultan Misil bo' kasulutan sultan ian ma iya. Hangkan iya tahinang gubnul uk sultan, mag-agi ma lahat Misil kamemon sampay ma manga aa ma diyōm ōkōman na. ");
INSERT INTO slm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sakali itu niya' bayi gōtōm ma kalohahan lahat Misil hi' sampay isab ma lahat Kanaan, iya bayi paglahatan di si Ya'kub. Manga ka'mbo'-mboan tabi, 'nsa' niya' takakan tapeha uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hangkan na, pagtake uk si Ya'kub niya' kono' kiyakan ma lahat Misil, bayi soho' na manga anak na lalla, iya asal pangkat bangsa tabi, pahi' ni Misil malli kiyakan. Iya na hi' tagnaan kapahi' sigam,” uk si Esteban. ");
INSERT INTO slm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Kaminduwa na peen kapahi' sigam, na iyampa magpakila si Yusup ma manga danakan na hi'. Jari minnihi' kitauhan uk Sultan in si Yusup taga kampung. ");
INSERT INTO slm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Puwas na hi' niya' lapal bayi piyabo uk si Yusup ni 'mma' na, ni si Ya'kub hi'. Bayi soho' na si Ya'kub magtawutayi'-anak kamemon pahi' ni lahat Misil, iya pitumpu' maka lima puhu' sigam. ");
INSERT INTO slm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sakali pahi' di si Ya'kub ni lahat Misil maglahat mahi'. Bang taabut waktu na matay si Ya'kub mahi'. Damikkiyan na isab manga anak na, iya kapangkatan tabi, bang taabut waktu sigam. ");
INSERT INTO slm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Manga bangkay sigam bayi tiyuran ni lahat Sekem bo' kiyubul mahi' ma pagkubulan bayi billi uk si Ibrahim min tubu' si Hamor ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Manjari itu, song peen taabut waktu pamaluwas sigam min lahat Misil, sali' bayi janji' Tuhan ma si Ibrahim, heka na tōōd bangsa tabi ma lahat Misil hi'. ");
INSERT INTO slm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Niya' na sultan saddi ngantanan lahat Misil, sultan 'nsa' katauhan na pasal bayi si Yusup. ");
INSERT INTO slm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In bangsa tabi bayi iyakkalan uk sultan hi',” uk si Esteban. “Bayi liyōgōs ka'mbo'-mboan tabi, siyoho' nyanyaya anak-anak sigam bo' supaya matay. ");
INSERT INTO slm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na, iya na hi' bayi waktu kapag-anak ma si Musa. Onde'-onde' durugan si Musa hi', bo' ma diyōm tallum bulan ipat iya ma luma' maas na. ");
INSERT INTO slm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Puwas peen tallum bulan hi', piluwas iya min diyōm luma'. Lipara tapuwa' iya uk anak sultan dayang-dayang, bo' tahinang anak na. ");
INSERT INTO slm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bayi iya piyanduan kamemon pangadji' bangsa Misil, bo' bantug iya ma pagbissala na maka ma manga kahinangan na. ");
INSERT INTO slm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Taabut peen 'mpatpu' tahun umul si Musa,” uk si Esteban, “nganggara' iya patibaw ni manga pagkahi na bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Makatibaw peen iya pay'an, niya' tanda' na dakayo' pagkahi na Israil liyaugan uk aa bangsa Misil. Magtuwi diyapitan pagkahi na itu uk si Musa bo' piyuli aa Misil ian piyatay. ");
INSERT INTO slm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Sabab pangannal si Musa in manga pagkahi na bangsa Israil makahati du in iya giyuna du uk Tuhan pamapuwas sigam min pagbanyagaan. Suga' 'nsa' tahati uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagsawung peen min 'llaw bayi pamono' hi', niya' tanda' uk si Musa duwangan aa Israil magbono'. Arak pipagkahap uk na karuwangan hi'. ‘Manga tuwan,’ uk na, ‘magdanakan ko' kaam. Angay kaam magbono'?’ ");
INSERT INTO slm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Suga' iya aa bayi mamono' ian bayi nugan si Musa. Uk na, ‘Sayi baha' bayi muwanan kau kapatut magnakura' ma kami? Angay kau subay ngahukum kami? ");
INSERT INTO slm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Baya' kau mapatay aku isab, sali' bayi pamapatay nu aa Misil diaw?’ ");
INSERT INTO slm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Take peen itu uk si Musa, magtuwi iya lahi min lahat Misil, pay'an ni lahat Midiyan bo' maglahat may'an. Maghanda iya may'an, sampay iyabut iya duwa anak lalla. ");
INSERT INTO slm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Manjari itu,” uk si Esteban, “palabay peen 'mpatpu' tahun iya taggōl si Musa ma lahat Midiyan hi', niya' malaikat bayi palahil ni iya min diyōm keyat api ma poon puhung, ma tōngōd bud Turusina mahi' ma lahat 'nsa' agōn kalluman ayi-ayi. ");
INSERT INTO slm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Inu-inu si Musa ma bayi tanda' na ian, hangkan iya pasikōt ni poon puhung ngaliling iya. Suga' sikōt peen iya, take na suwara Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Uk suwara hi', ‘Aku iya Tuhan pagtuhanan ka'mbo'-mboan nu, si Ibrahim, si Isahak maka si Ya'kub.’ Magtuwi midpid baran si Musa sabab min tāw na, iya hangkan 'nsa' makatawakkal nganda' pahi'. ");
INSERT INTO slm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Uk Tuhan ni iya, ‘Kalloun tawumpa' nu iyu, sabab tana' pananggehan nu iyu tana' kamaituhan.’ ");
INSERT INTO slm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Uk Tuhan le', ‘Bayi na tanda' ku paminsana' ma manga aa ku mahi' ma lahat Misil. Bayi na take ku pagdahing sigam, maka tiya' na aku paiyu ni dunya maluwas sigam. Dayi' na kau. Papahi' ta kau ni lahat Misil.’ ");
INSERT INTO slm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na,” uk si Esteban, “si Musa itu, iya na ko' aa bayi siyulak uk manga pagkahi na bangsa Israil. Pihalling-hallingan iya uk sigam, uk sigam, ‘Sayi bayi muwanan kau kapatut magnakura' ma kami! Angay kau subay ngahukum kami?’ Bo' peen si Musa iya bayi siyoho' pahi' uk Tuhan magnakura' sampay ngalappas ma manga ka'mbo'-mboan tabi hi'. Bayi iya tiyabangan uk malaikat iya bayi palahil ni iya min diyōm poon puhung marōkōt hi'. ");
INSERT INTO slm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Manjari in ka'mbo'-mboan tabi bangsa Israil bayi pignakuraan uk si Musa paluwas min lahat Misil. Bayi iya maghinang manga hinang makainu-inu maka manga paltandaan kawasahan mahi' ma Misil sampay ma tōngōd Sallang Pula. Damikkiyan na isab kahinangan na ma lahat 'nsa' agōn kalluman ayi-ayi hi', ma diyōm 'mpatpu' tahun. ");
INSERT INTO slm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Musa iya bayi missala ni bangsa Israil, uk na, ‘Ma sosongun niya' du dakayo' nabi piyabo ni kaam uk Tuhan. Piyabo iya sali' kapamabo Tuhan ma aku, maka aa bangsa bi du iya.’ ");
INSERT INTO slm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Musa itu, iya na bayi ma ka'mbo'-mboan tabi bangsa Israil waktu kapagtipun sigam ma lahat 'nsa' agōn kalluman ayi-ayi hi'. Bayi iya ma tōngōd sigam maka mahi' isab iya ma tōngōd malaikat, iya bayi malmanan iya ma diyata' bud Turusina hi'. Si Musa iya bayi makasambut min Tuhan manga lapal na iya makabuwan kallum, bo' supaya tapalatun na ni kitabi. ");
INSERT INTO slm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Suga' ka'mbo'-mboan tabi ian,” uk si Esteban hi', “'nsa' tōōd me' ma si Musa. Tiyayikutan iya uk sigam. Iya kabayaan sigam subay pabing ni lahat Misil. ");
INSERT INTO slm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Manjari, pagka taggōl si Musa mahi' ma diyata' bud Turusina, halling manga aa Israil ian ni si Harun. Uk sigam, ‘Hinangin bi kitabi manga tau-tau pagtuhanan, pagnakura' tabi. Sabab 'nsa' katauhan kami maingga na si Musa hi', iya bayi mo kitabi paluwas min Misil!’ ");
INSERT INTO slm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iya na hi' waktu bayi kapangahinang sigam dakayo' tau-tau sali' dagbōs anak sapi'. Bayi tiyukbalan uk sigam sasumbayan ni tau-tau ian. Bayi sigam maglami-lami pangahulmat sigam ma bayi hinangan tangan sigam. ");
INSERT INTO slm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hangkan ko' sigam bayi tiyayikutan uk Tuhan. Pisaran sigam mudji manga baanan bituun ma diyata' langit, sali' bayi tasulat ma diyōm kitab kanabi-nabihan, iya uk na, ‘O manga aa Israil, uk Tuhan. 'Nsa' aku iya bayi harap bi maka sasumbayan ian, iya pagkulban bi ma diyōm 'mpatpu' tahun, iya bayi kamahi' bi ma lahat 'nsa' agōn kalluman ayi-ayi ian. ");
INSERT INTO slm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iya pagbo-bo bi na peen iya ngandagbōs tau-tau tuhan bi si Molok, maka tau-tau hinangan dagbōs bituun pangaharapan bi tuhan bi si Repan. Iya na ko' ian manga tau-tau bayi hinang bi panumbahan bi. Hangkan kaam pakallo' ku tudju ni lahat liyu iya lahat Babilon.’ ");
INSERT INTO slm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Waktu kamahi' ka'mbo'-mboan tabi ma lahat 'nsa' agōn kalluman ayi-ayi,” uk si Esteban, “niya' bayi ma sigam luma' pamay'anan haddarat Tuhan. Luma' ian bayi hinang uk si Musa sali' bayi panohoan Tuhan ma iya. Binean uk si Musa iya suntuan bayi pamanda' ma iya. ");
INSERT INTO slm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Puwas na hi' luma' ian bayi pangamban ma manga pangkat kami pasunu', bo' sigam iya bayi mo luma' ian paitu ma waktu kapaitu sigam maka si Yussa', iya nakura' sigam. Iya na hi' waktu bayi kapangagaw lahat itu uk sigam min manga kabangsahan bayi tapakallo' uk Tuhan min dahuhan sigam. Jari luma' pamay'anan Tuhan ian bayi patōngōd ma itu sampay taabut waktu kapagsultan si Daud. ");
INSERT INTO slm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Si Daud hi' bayi makasulut atay Tuhan, bo' maid iya min Tuhan maghinang luma' pangaharapan iya, iya asal pagtuhanan pangkat tabi si Ya'kub. ");
INSERT INTO slm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Suga' iya pibaid uk Tuhan maghinang luma' ian si Sultan Sulayman. ");
INSERT INTO slm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Malayingkan in Tuhan Mahatinggi,” uk si Esteban, “'nsa' du pabōtang ma diyōm langgal hinangan manusiya'. Bayi tasulat uk dakayo' nabi iya pamissala Tuhan itu, iya uk na, ");
INSERT INTO slm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Sulga' iya paningkoan ku, maka dunya iya pag'ddōkan nayi' ku. Luma' ayi baha' hinangan bi aku? Maingga baha' panakapan bi aku pahalihan? ");
INSERT INTO slm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sabab aku du iya bayi makahinang ian hi' kamemon!’ ” ");
INSERT INTO slm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Missala na peen si Esteban ni manga aa ma palhimpunan ian, uk na, “Kaam iyu, tuwas pahap kok bi! Munapik kaam! Palpal pahap tainga bi, 'nsa' ngasip lapal Tuhan! Sali' du kaam maka bayi ka'mbo'-mboan bi sabab iya du kaam nagga' Nyawa Tuhan! ");
INSERT INTO slm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Niya' baha' minsan laa hal dakayo' nabi 'nsa' bayi tapidjala' uk manga ka'mbo'-mboan bi? 'Nsa'. Bayi piyatay uk sigam manga aa mo lapal Tuhan ma masa awwal hi', iya bayi magmahalayak pasal kapaitu sosohoan na adil. Manjari, pagka paitu na sosohoan na ian, tipu bi sadja sampay piyatay uk bi. ");
INSERT INTO slm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kaam iya bayi makasambut sara' Tuhan min malaikat, malayingkan 'nsa' kabōgbōgan bi sara' ian!” ");
INSERT INTO slm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Makake peen manga aa ma palhimpunan ian ma si Esteban, paddi' makalandu' atay sigam. Magtuwi sigam magtagiōt bagaang sigam sabab min pangandugal sigam ma iya. ");
INSERT INTO slm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Suga' kahōpan si Esteban uk Nyawa Tuhan bo' pahangad iya tudju ni sulga'. Tanda' na sahaya Tuhan may'an, maka tanda' na isab si Isa nangge ma bihing Tuhan sakap ni katau. ");
INSERT INTO slm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“'Ndaun bi,” uk si Esteban, “tanda' ku ukab diyōm sulga'. Maka tanda' ku isab si Isa, iya iyōnan Anak Manusiya', nangge ma bihing Tuhan sakap ni katau.” ");
INSERT INTO slm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pagka salaihi' halling si Esteban, ngōlang pakōsōg manga aa palhimpunan ian. Tiyaplōk tainga sigam maka tangan sigam. Paragan sigam tudju ni si Esteban, ");
INSERT INTO slm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bo' iyampa iya hella' paluwas min daira Awrusalam ian. Ma luwasan peen, nagna' sigam ngahiyak maka batu ni iya. Manga saksi' ian, hati na manga aa ngahiyak batu, bayi nawu' badju' sigam ma dakayo' lalla bata' le', ōn na si Saul. ");
INSERT INTO slm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ma salta' peen si Esteban pigbantung uk sigam, nabbut iya ni Panghu' na, uk na, “O Panghu' Isa, tayimaun nyawa ku.” ");
INSERT INTO slm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Puwas na hi' paluhud iya maka uk na ngalingan patanōg. Uk na, “O Panghu', daa patongin dusa pamono' itu ni sigam.” Paghalling na peen magtuwi iya matay. ");
INSERT INTO slm_vpl VALUES ("AC8_1a","074_8_1a","ACT","8","1a","1a","Bo' si Saul ian bayi ngaku piyatay si Esteban uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC8_1b","074_8_1b","ACT","8","1b","2","Si Esteban hi' kiyubul uk manga aa magtataat ni Tuhan. Pigkarukkaan tōōd iya uk sigam. Sakali itu, puwas sadja min 'llaw bayi pamapatay ma si Esteban hi', tiyagnaan na pangalaug manga jamaa si Isa ma Awrusalam. Hangkan sigam pulak-palik kamemon tudju ni kalohahan lahat Yahudi maka ni lahat Samariya. Hangkan du tamban ma Awrusalam manga aa bayi kawakilan uk si Isa. ");
INSERT INTO slm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Suga' si Saul ian, iya katuyuan na ngamula manga jamaa si Isa. Liyatag uk na kalumaan sigam, ubus luma' dakayo' bo' luma' dakayo'. Siyaggaw sigam uk na lalla-danda bo' iyampa liyōōn ni diyōm jil. ");
INSERT INTO slm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lipara manga bean si Isa bayi kawukanat ian, pahi' ni kawuman dakayo' maka dakayo' nganasihat lapal hap pasal si Isa. ");
INSERT INTO slm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Pilip iya pahi' ni dakayo' daira ma lahat Samariya nganisahatan manga aa may'an ma pasal si Almasi, iya pene' uk Tuhan magbaya'. ");
INSERT INTO slm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pagtake peen manga kabanōsan aa may'an ma bissala si Pilip, maka pag'nda' sigam ma paltandaan makainu-inu iya tahinang na, iyasip tōōd lapal na uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Heka manga aa bayi piluwasan sayitan. Kōsōg pangōlang manga sayitan salta' sigam piluwas. Heka isab manga aa kaulian, manga aa pengka' maka manga aa 'nsa' kahibalan di sigam, ");
INSERT INTO slm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","hangkan kiyōgan tōōd manga aa ma daira ian. ");
INSERT INTO slm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na, niya' ma daira ian aa iyōnan si Simun, aa tau mahikmat. Taggōl-taggōl kapaglahat na may'an bo' inu-inu manga aa Samariya ian ma kahinangan na. Maglaku-laku si Simun in iya babantugun. ");
INSERT INTO slm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jari iyasip iya uk aa kamemon ma daira ian, manga aa deyo', sampay manga aa langkaw. Iya uk sigam kamemon pasal si Simun, “Iya na ko' itu aa taga barakat min Tuhan, iya iyōnan Barakat Mehe.” ");
INSERT INTO slm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Taggōl na pag-inu-inu sigam ma paghikmat na hangkan sigam ngasip tōōd ma iya. ");
INSERT INTO slm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Suga' magkahagad peen manga aa ian ma lapal hap iya pignasihat uk si Pilip pasal pamarinta Tuhan maka ma pasal si Isa Almasi, magtuwi sigam piyandi magdanda-maglalla, pagpandi palsaksian in sigam ma si Isa na. ");
INSERT INTO slm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Iya du si Simun hi' bayi magkahagad. Ubus peen iya bayi piyandi, lut na iya ma si Pilip. Pag'nda' na manga paltandaan maka hinang makainu-inu iya tahinang si Pilip, inu-inu iya tōōd. ");
INSERT INTO slm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Manjari itu take uk manga aa kawakilan mahi' ma Awrusalam pasal manga aa Samariya bayi makatayima' lapal Tuhan, hangkan sigam bayi noho' si Petros maka si Yahiya pay'an ni lahat Samariya. ");
INSERT INTO slm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagtakka peen di si Petros pay'an, siyambahayang uk sigam manga aa Samariya ian bo' supaya sigam pisangōnan Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sabab in Nyawa Sutsi 'nsa' le' bayi pasangōn ni sigam minsan dakayo'. Suga' bayi sigam piyandi sadja, palsaksian in sigam suku' ma si Isa. Iya na hi'. ");
INSERT INTO slm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Manjari pibōtang uk si Petros maka si Yahiya tangan sigam ma manga aa Samariya magpangandōl ian, bo' kaniyaan sigam Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tanda' uk si Simun in manga aa ian bayi pihōpan Nyawa Sutsi, pagpabōtangan tangan di si Petros ma sigam. Hangkan iya nongan sin ni si Petros maka ni si Yahiya, arak panamba na ma sigam. ");
INSERT INTO slm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Uk na ni sigam, “Buwanin bi isab aku kawasa bi iyu, bo' bang niya' sayi-sayi kapabōtangan tangan ku pihōpan du isab iya Nyawa Sutsi.” ");
INSERT INTO slm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Suga' siyambungan iya uk si Petros, uk na, “Kau maka sin nu iyu! Hap le' pigmulkaan pagka pangannal nu in kahapan Tuhan taballi-balli maka sin! ");
INSERT INTO slm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","'Nsa' niya' palsukuan nu atawa lamud nu ma hinang kami itu,” uk si Petros, “sabab 'nsa' bōntōl atay nu ma panganda' Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hangkan ko', tayikutin na kalaatan nu iyu. Pikiampun kau ni Tuhan, kalu iyampunan pikilan nu malaat iyu. ");
INSERT INTO slm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sabab tasayu ku na,” uk si Petros, “in kau landu' na tōōd bansi. Sali' kau ingkōtan uk dusa nu.” ");
INSERT INTO slm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sakali halling si Simun ni si Petros maka si Yahiya, uk na, “Ngamu'-ngamu' kaam kono' ni Tuhan ma pasal ku, supaya 'nsa' patakka ni aku iya uk bi iyu.” ");
INSERT INTO slm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Puwas na hi', ubus peen halling si Petros maka si Yahiya naksi' pasal si Isa sampay nganasihat lapal Tuhan ma manga aa ian, mowe' na sigam tudju ni Awrusalam pabing. Ma labayan peen sigam, maghapit-hapit sigam ma manga kalumaan heka ma lahat Samariya ian bo' tanasihat uk sigam lapal hap. ");
INSERT INTO slm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na, niya' malaikat Tuhan bayi missala ni si Pilip, uk na, “Magsakap na kau. Pahi' kau tudju ni satan, ni kalsada iya langkosan Awrusalam maka Gasa.” (Daddōk ian hi' 'nsa' na agōn tapalabayan.) ");
INSERT INTO slm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hangkan magsakap si Pilip bo' mangngan pahi'. Manjari itu niya' aa bangsa Eteyopa bayi ma Awrusalam magpudji Tuhan. Aa itu langkaw 'ntan na. Iya hinang na ngantanan pangalta' si Kandake, iya sultan danda ma lahat Eteyopa hi'. Kiyabili asal iya. ");
INSERT INTO slm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na, mowe' peen aa ian min Awrusalam, ningko' iya ma diyata' kalesa na, maka uk na massa kitab ma juran bayi tasulat uk si Nabi Isaya. ");
INSERT INTO slm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Si Pilip iya siyoho' uk Nyawa Tuhan. Uk na, “Pay'an na kau pasikōt tudju ni kalesa ian.” ");
INSERT INTO slm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hangkan paragan si Pilip ni kalesa ian. Jari take na aa itu massa min juran si Nabi Isaya bo' tiyaw si Pilip ma iya, uk na, “Katauhan nu baha' iya bassa nu iyu?” ");
INSERT INTO slm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Uk sambung aa hi', “'Nsa'. Salaingga pakatau ku bang 'nsa' niya' mahatihan aku?” Jari soho' na si Pilip pariyata' pay'an ningko' ma bihing na. ");
INSERT INTO slm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na, iya na itu manga ayat kitab bayi tabassa na hi', uk na, “Aa itu sali' hantang bili-bili me' sadja bang biyo siyumbay. 'Nsa' iya bayi halling minsan dakabtang. Sali' iya anak bili-bili timmōn bang giyuntingan. ");
INSERT INTO slm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Biyuwanan iya kaiyaan, maka 'nsa' iya bayi biyo ni sara' bōntōl. 'Nsa' niya' makaba'-ba' pasal manga tubu' na, Sabab pipuut umul na ma diyōm dunya itu.” ");
INSERT INTO slm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uk aa hi' ni si Pilip, “Bain aku. Sayi pigbissala uk nabi itu? Baran na, atawa aa saddi?” ");
INSERT INTO slm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sakali missala si Pilip. Tiyagnaan uk na min manga ayat kitab bayi tabassa hi' bo' ba'-ba' na aa ian lapal hap pasal si Isa. ");
INSERT INTO slm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Manjari itu, ma sabu sigam palanjal ma palangnganan sigam, niya' taabut uk sigam lahat taga bohe'. Uk aa Eteyopa ian, “'Ndaun, niya' itu bohe'. Bang 'nsa' niya' makabimbang, baya' aku piyandi palsaksian in aku me' ma si Isa na.” ");
INSERT INTO slm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Uk si Pilip, “Bang kau magkahagad sampay min diyōm atay nu, makajari du.” “Aho',” uk aa ian, “magkahagad du aku in si Isa Almasi asal anak Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Magtuwi noho' aa ian marōhōng kalesa. Jari pareyo' iya maka si Pilip karuwangan tudju ni diyōm bohe' bo' iyampa iya piyandi uk si Pilip. ");
INSERT INTO slm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paluwas peen sigam min diyōm bohe', magtuwi si Pilip tabo minnihi' uk Nyawa Tuhan. 'Nsa' na iya tanda' pabing uk aa Eteyopa ian suga' palanjal iya ni katudjuhan na, maka uk na kiyōgan tōōd. ");
INSERT INTO slm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Si Pilip iya hi' makamahi' ma daira Asotus. Palanjal iya minnihi' magnasihat lapal hap ni kalumaan ian kamemon sampay takka ni lahat Kesareya. ");
INSERT INTO slm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pasalta' ian hi' masi si Saul nanggupan manga mulid si Panghu' Isa, in sigam kono' papatay na. Hi' iya pahi' ni imam-nakura' ");
INSERT INTO slm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ngamu' sulat katarangan, bo na ni manga kalanggalan mahi' ma daira Damaskus. Jari bang niya' tatawwa' na mahi' manga aa me' ma kalangngan si Panghu' Isa Almasi, niya' du kapatut na naggaw sigam lalla-danda sampay mo sigam pabing ni Awrusalam jinil. ");
INSERT INTO slm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Manjari itu, ma labayan peen si Saul itu tudju ni Damaskus bo' sikōt na, patagha' sadja niya' sawa min diyōm sulga' nayinag ma katilibut na. ");
INSERT INTO slm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pahantak iya magtuwi ni tana' bo' makake iya suwara missala ni iya. Uk suwara ian, “Saul, O Saul! Angay aku pidjala' nu?” ");
INSERT INTO slm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nambung si Saul, uk na, “Sayi kau iyu, Nakura'?” Uk suwara ian, “Aku si Isa, iya pidjala' nu na peen. ");
INSERT INTO slm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Suga' nangge na kau,” uk na. “Pahi' na kau ni diyōm daira ian. Biyaan du kau may'an bang ayi subay hinang nu.” ");
INSERT INTO slm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Manga aa bayi sehe' si Saul magbe' hal nangge sadja may'an, 'nsa' halling. Take uk sigam suwara ian bo' 'nsa' sayi-sayi bayi tanda' uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nangge si Saul min tana' bo' iyampa makallat mata na, suga' 'nsa' iya bayi makanda'. Hangkan iya piyambit uk manga sehe' na tudju ni diyōm Damaskus ian. ");
INSERT INTO slm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tallum bahangi iya 'nsa' kanda', maka 'nsa' isab iya bayi mangan atawa nginum ma diyōm tallum bahangi hi'. ");
INSERT INTO slm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Niya' ma Damaskus ian dakayo' mulid si Isa Almasi iyōnan si Ananiyas. Magpanyata' si Panghu' Isa ni iya halling, uk na, “O Ananiyas!” “Tiya' aku, Panghu',” uk na. ");
INSERT INTO slm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Uk si Panghu' Isa ni iya, “Pasakap kau. Pahi' na kau ni kalsada iyōnan Daddōk Bōntōl ian. Tīyawun pahi' ni luma' si Judas pasal dakayo' aa min Tarsus iyōnan si Saul. Hi' na iya nambahayang buttihi'. ");
INSERT INTO slm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Bayi iya patau ku bang ayi song makani-iya. Bayi kau sali' tanda' uk na pasōd ni diyōm pabōtangan na ian mabōtang tangan nu ma iya, bo' supaya iya makanda' pabing.” ");
INSERT INTO slm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Suga' nambung si Ananiyas, uk na, “Allō, Panghu' ku, heka bayi ngahakahan aku pasal si Saul ian. Laat makalandu' manga kahinangan na ma manga aa suku' nu ma Awrusalam hi'. ");
INSERT INTO slm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Maka tiya' na isab iya ma Damaskus itu. Kabuwanan iya kapatut uk kaimaman nakura' bo' tasaggaw na sasuku magpanabbut ma ōn nu.” ");
INSERT INTO slm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Suga' nambung si Panghu' Isa, uk na, “Pahi' na kau, sabab si Saul ian bayi tapene' ku maghinang ma aku. Iya iya matanyag ōn ku pahi' ni kabangsa-bangsahan aa iya 'nsa' Yahudi, maka ni manga kasultanan, maka ni manga bangsa Israil isab. ");
INSERT INTO slm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Baran ku iya,” uk si Panghu' Isa, “manduan iya pasal sukkal kamemon iya subay sandalan na ma sosongun pagka aku iya pamean na.” ");
INSERT INTO slm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jari pahi' si Ananiyas sampay pasōd ni diyōm pabōtangan si Saul ian. Pibōtang uk na tangan na ma si Saul, bo' uk na, “Saul, magdanakan na kita. Tiya' aku siyoho' paitu uk si Panghu' Isa, iya bayi panda' ni kau ma labayan ma waktu kapaitu nu ian. Siyoho' aku paitu bo' kau makanda' pabing, bo' kau pihōpan isab uk Nyawa Sutsi.” ");
INSERT INTO slm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saruun-duun niya' sali' sisik daying bayi hug min mata si Saul, jari makanda' iya pabing. Nangge iya bo' iyampa piyandi palsaksian in iya ma si Isa na. ");
INSERT INTO slm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Puwas na hi', ubus peen uk na mangan, kōsōg baran na pabayik. Na, pahanti' si Saul manga pilam bahangi ma manga mulid si Isa ma Damaskus ian. ");
INSERT INTO slm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nagna' iya magtuwi magnasihat ma diyōm kalanggalan Yahudi may'an pasal si Isa. “Si Isa itu,” uk na, “anak Tuhan du ko'!” ");
INSERT INTO slm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Inu-inu aa kamemon sasuku pake ma iya. Uk sigam, “Iya na ko' itu aa bayi ma Awrusalam hi' ngamula sasuku nabbut ma ōn si Isa. Maka iya maksud na kono' paitu subay naggaw sasuku me' ma si Isa, bo' iyampa sigam bo na pabing ni Awrusalam, ni manga imam langkaw hi'.” ");
INSERT INTO slm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Suga' iya nasihat si Saul pakannōp na peen kōsōg na. Minnihi' manyatakan tōōd pasal si Isa, in iya Almasi iya tapene' uk Tuhan ngantanan parinta na ma manusiya', hangkan manga Yahudi maglahat ma Damaskus 'nsa' tau nganjawaban iya. ");
INSERT INTO slm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Taggōl-taggōl peen minnihi' mag-isun manga Yahudi mapatay si Saul, ");
INSERT INTO slm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","lipara kahakahan iya pasal isun sigam hi'. 'Llaw-sangōm, jiyagahan uk sigam manga lawang paluwasan min daira ian bo' supaya piyatay si Saul. ");
INSERT INTO slm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Suga' sangōm peen lahat, biyo si Saul uk manga anak-mulid na pitingko' ma diyōm ambung mehe bo' iyampa tiyonton min dakayo' tandawan tudju ni luwasan kuta' daira ian. ");
INSERT INTO slm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sakali itu pahi' si Saul ni Awrusalam. Pagtakka na pahi', pasulay iya palamud ma manga kamuliran si Isa mahi'. Suga' tiyāw sigam ma iya sabab 'nsa' sigam ngahagad in iya mulid si Isa na. ");
INSERT INTO slm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lipara si Barnabas bayi nabangan iya. Bayi iya mo si Saul ni manga aa kawakilan hi'. Bayi patau na isab sigam pasal pakanda' si Saul si Panghu' Isa, ma labayan peen tudju ni Damaskus. Bayi iya kono' bissalahan isab uk si Isa may'an. Biya'-ba' isab uk si Barnabas pasal si Saul 'nsa' tiyāw magnasihat ma pasal si Isa ma diyōm daira Damaskus hi'. ");
INSERT INTO slm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Manjari pabōtang si Saul ma manga kamuliran si Isa ma Awrusalam. Lingngan uk na diyōm daira ian maka 'nsa' niya' tāw-tāw na nganasihat ma manga aa pasal si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Magbissala isab iya sampay magjawab maka manga Yahudi iya asal missala bissala Girik suga' nulay sigam mapatay iya. ");
INSERT INTO slm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tatau peen ian hi' uk manga dawuranakan na bean si Isa, magtuwi sigam bayi mo si Paul itu palud ni Kesareya bo' iyampa pilaus minnihi' tudju ni Tarsus. ");
INSERT INTO slm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na, iyampa taga kasannangan manga jamaa si Isa ian ma kalohahan lahat Yahudiya maka ma lahat Jalil, maka mahi' ma lahat Samariya. Tiyabangan sigam uk Nyawa Tuhan hangkan ngahōgōt iman sigam kamemon. Pasong isab heka sigam, maka pahap tōōd kawul-piil sigam tudju ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Manjari itu maglangngan na si Petros ngalatag kalahatan. Niya' isab waktu, pahi' iya ni daira Lidda nibaw manga aa suku' Tuhan iya maglahat mahi'. ");
INSERT INTO slm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jari niya' talanggal na mahi' aa iyōnan si Aneyas. Aa itu matay baran na, walun tahun na iya 'nsa' bayi makapunduk min palegehan na. ");
INSERT INTO slm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Uk si Petros ni iya, “Aneyas, kaulian na kau uk si Isa Almasi. Papunduk na kau, mōmōsun patuwihan nu iyu!” Magtuwi papunduk si Aneyas itu. ");
INSERT INTO slm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tanda' iya uk manga aa kamemon iya maglahat ma Lidda maka ma lahat Saron ian, bo' papinda manga aa ian magkahagad ma si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, niya' ma lahat Joppa ian dakayo' danda mulid si Isa, iyōnan si Tabita (ōn na ian bang ma bissala Girik si Dorkas, hati na 'usa'). Danda ian maghinang sadja kahapan, maka nabang ma manga aa miskin. ");
INSERT INTO slm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jari ma waktu ian hi' tawwa' saki si Tabita itu bo' matay na. Tasutsi peen patay na, pibahak iya ma dakayo' bilik ma angkap diyata'. ");
INSERT INTO slm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lahat Joppa ian 'nsa' lawak tōōd min Lidda. Sakali itu, take peen uk manga kamuliran si Isa ma Joppa in si Petros ian ma Lidda, magtuwi sigam noho' duwa lalla pahi' mo lapal ni si Petros. Uk lapal hi', “Pasaut kau kono' paitu.” ");
INSERT INTO slm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pagtau peen si Petros, magtuwi iya magsakap me' ma duwangan ian. Pagtakka na ni Joppa biyo iya pariyata' ni bilik. Jari pigtipunan iya uk manga kabaluhan danda magpanangis na peen. Pindaan ni iya uk sigam manga badju' maka manga jaket bayi tahinang uk si Dorkas waktu bayi kallum na le'. ");
INSERT INTO slm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na, piluwas sigam kamemon uk si Petros min diyōm bilik ian bo' iyampa iya paluhud ni lantay ngamu'-ngamu' ni Tuhan. Puwas na hi' paalōp iya ni patay danda ian. Uk na, “Tabita, papunduk kau!” Sakali pikallat uk si Tabita mata na, bo' punduk iya pag'nda' na ma si Petros. ");
INSERT INTO slm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piabut uk si Petros tangan na panabang iya bo' makatangge. Puwas na hi' linganan uk si Petros manga aa mangandōl ian maka manga balu bo' songan na si Tabita ni sigam, 'llum na. ");
INSERT INTO slm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pasaplag haka pasal kallum si Tabita itu ni aa kamemon ma Joppa ian, hangkan heka mangandōl ma si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Taggōl-taggōl kabōtang si Petros ma Joppa ian. Paōkōm iya ma luma' si Simun, aa mag-adjal kuwit hayōp. ");
INSERT INTO slm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, niya' aa ma lahat Kesareya iyōnan si Kornelos. Kapitan iya ma dakayo' baanan sundalu Roma, iya iyōnan “Baanan Itali”. ");
INSERT INTO slm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aa itu asal me' ma kabayaan Tuhan. Sigam kamemon magtayi'-anak magtaat asal ma Tuhan. Mehe isab panulung si Kornelos ma manga Yahudi bang kasigpitan, maka tuyu' iya nambahayang ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Manjari ma dakayo' 'llaw, manga lisag tallu kohap, niya' magpasalupa ni si Kornelos. Sawa panganda' na ma malaikat min Tuhan pasōd ni diyōm luma' na missala ni iya. Uk na, “O Kornelos!” ");
INSERT INTO slm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Piyatong uk na malaikat ian maka tiyāw iya. “Ayi kono', Tuwan?” uk na. Uk malaikat, “Kapandōgahan uk Tuhan panambahayang nu maka panulung nu ma manga miskin, bo' kiyannal du kau uk na. ");
INSERT INTO slm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sohoun manga tindōg nu pahi' ni Joppa ngallo' dakayo' aa iyōnan si Simun iya iyōnan isab si Petros. ");
INSERT INTO slm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ian na iya paōkōm ma luma' si Simun, iya mag-adjal kuwit hayōp hi'. Ian luma' na ma bihing tahik.” ");
INSERT INTO slm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pagpakallo' malaikat hi' bayi halling, linganan uk si Kornelos duwa ipatan na. Linganan isab dakayo' sundalu iya asal tindōg na, aa me' ma kabayaan Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Biyaan sigam tallungan itu uk si Kornelos pasal iya bayi ba'-ba' malaikat hi', bo' iyampa sigam palaus na pahi' ni Joppa. ");
INSERT INTO slm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagsawung, manga waktu lattu na, ma song peen takka tallungan itu ni Joppa, ian si Petros pariyata' ni kapantayan atōp luma' ian nambahayang may'an. ");
INSERT INTO slm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","'Nsa' taggōl, giyōtas si Petros, baya' mangan. Jari itu, pasalta' peen iyadjal kiyakan na, niya' panyata' ni iya. ");
INSERT INTO slm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tanda' na langit paukab maka niya' tanda' na sali' na dagbōs manta mehe tōōd bayi kaingkōtan ma kampat tong na, ian tiyontonan pareyo' ni dunya. ");
INSERT INTO slm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iya pakandung ma diyōm manta ian ginisan hayōp kamemon, maka manga ayi-ayi maglelehan, maka manga manuk-manuk. ");
INSERT INTO slm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jari niya' suwara take uk si Petros halling ni iya, uk na, “Nangge kau, Petros. Numbay kau pay'an bo' kau mangan!” ");
INSERT INTO slm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Suga' nambung si Petros, uk na, “E, Panghu', 'nsa' aku! Sataggōl ku 'llum 'nsa' aku bayi makakakan haram atawa ayi-ayi bayi lammi'.” ");
INSERT INTO slm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Take na suwara ian halling pabing, uk na, “Daa iyōnan haram basta tahalal uk Tuhan!” ");
INSERT INTO slm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Salaihi' min tallu bo' iyampa piangkat ayi-ayi ian pabing ni sulga'. ");
INSERT INTO slm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Manjari itu, ma sabu si Petros masi ngannal bang ayi hati na iya bayi tanda' na ian, takka na ni luma' si Simun uk manga aa bayi siyoho' pay'an uk si Kornelos. Ian na sigam ngagad ma bo' lawang ");
INSERT INTO slm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ngalingan. Tiyaw sigam tudju ni luma', uk sigam, “Owa'! Niya' baha' pahanti' maiyu aa iyōnan si Simun, iya iyōnan isab si Petros?” ");
INSERT INTO slm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sasang si Petros masi ngannal bang ayi hati na bayi tanda' na ian, na, halling Nyawa Tuhan ni iya, uk na, “Kehun ba. Iyu niya' tallungan aa meha kau. ");
INSERT INTO slm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nangge na kau bo' kau pareyo'. Daa kau hawal-hawal me' ma sigam sabab aku iya bayi noho' sigam paitu.” ");
INSERT INTO slm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hangkan pareyo' si Petros bo' uk na ni tallungan ian, “Aku ko' iya aa peha bi. Ayi gawi bi ni aku?” ");
INSERT INTO slm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Uk tallungan ian, “Bayi kami siyoho' paitu uk si Kapitan Kornelos. Hap addat na. Magtaat du iya ma Tuhan maka siyanglitan iya uk manga Yahudi kamemon. Bayi iya biyaan uk malaikat min Tuhan, siyoho' ngallo' kau. Jari siyoho' kau pahi' ni luma' na supaya take na bang ayi pamissala nu ma iya.” ");
INSERT INTO slm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Manjari tallungan ian bayi siyoho' pasōd uk si Petros, hiyulmat uk na sangōm ian. Pagsawung peen, magsakap na si Petros me' ma manga aa ian. Niya' isab manga dawuranakan na bean si Isa min Joppa nehean iya. ");
INSERT INTO slm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagsawung 'llaw, iyampa sigam takka ni Kesareya. Ian asal si Kornelos ngagaran sigam, maka ian isab manga kampung na maka manga panōn na bayi soho' na patipun pay'an. ");
INSERT INTO slm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Song peen pasōd si Petros, siyampang iya uk si Kornelos. Paluhud iya ma alōpan si Petros ngahulmat iya. ");
INSERT INTO slm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Suga' pitangge iya uk si Petros. “Nangge kau,” uk si Petros. “Manusiya' du aku, sali' kau.” ");
INSERT INTO slm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Magbissala sigam duwangan sabu sigam pariyōm. Ma diyōm peen, heka aa tanda' uk si Petros magtipun may'an. ");
INSERT INTO slm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Uk si Petros ni sigam, “Katauhan bi, bang ma agama kami Yahudi, 'nsa' kami makajari maglamud maka bangsa 'nsa' Yahudi. 'Nsa' kami makajari minsan patibaw ni sali' kaam itu. Suga' bayi aku pitau uk Tuhan subay 'nsa' niya' manusiya' bista ku haram atawa lammi'. ");
INSERT INTO slm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hangkan ko', pagka aku killo' uk bi paitu, 'nsa' du aku bayi ngalugat. Suga' tiyaw ta kaam: ayi pangalloan bi aku?” ");
INSERT INTO slm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nambung si Kornelos, uk na, “Niya' na tallungallaw palabay, manga salaitu dagbōs 'llaw, bayi aku ma diyōm luma' itu nambahayang lisag tallu kohap. Tagha' niya' nangge paharap ni aku dakayo' aa ngillap pamakay na. ");
INSERT INTO slm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Halling aa hi' ni aku, uk na, ‘Kornelos! Take na uk Tuhan iya bayi amu' nu hi', maka kiyannal isab uk na bayi panulung nu ma manga miskin. ");
INSERT INTO slm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Sohoun aa nu ni Joppa ngallo' paitu dakayo' aa iyōnan si Simun iya iyōnan isab si Petros. Ian iya paōkōm ma si Simun, aa mag-adjal kuwit hayōp. Ian luma' na ma bihing tahik.’ ");
INSERT INTO slm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na, iya na hi' poon na hangkan kau bayi kallo' ku paitu magtuwi,” uk si Kornelos. “Magsukul isab aku ni kau sabab tiya' na kau ma itu. Maka tiya' isab kami kamemon magtipun ma panganda' Tuhan itu bo' kami pake ma ayi-ayi bayi panohoan kau uk Panghu'.” ");
INSERT INTO slm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na, nagna' si Petros missala ma manga aa ian, uk na, “Buttihi' kamattanan na aku. Bannal tōōd, in manusiya' 'nsa' du pigbidda' uk Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sasuku magtaat ma Tuhan sampay ngahinang kabōntōlan, tayima' du uk na minsan ayi bangsa. ");
INSERT INTO slm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Katauhan bi lapal iya bayi pisampay uk Tuhan ni bangsa Yahudi, lapal hap pasal kapaghap manusiya' maka Tuhan sabab min bayi tahinang uk si Isa Almasi, iya makapagpanghu' asal ma kamemon. ");
INSERT INTO slm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Katauhan bi du pasal pakaradjaan bayi piniya' ma kalohahan lahat Yahudiya ian, iya tiyagnaan ma hi' ma lahat Jalil pag-ubus nganasihat si Yahiya pasal pandi tawubat. ");
INSERT INTO slm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Katauhan bi pasal si Isa, aa Nasaret. Bayi iya piniyaan Nyawa Sutsi uk Tuhan, maka biyuwanan iya barakat. Bayi iya maglangngan paingga-paingga maghinang hap. Maka sasuku isab bayi ma pangantanan nakura' sayitan kaulian uk na, sabab ian asal Tuhan ma iya. ");
INSERT INTO slm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jari kami itu,” uk si Petros, “muwan saksi' ma pasal kamemon bayi tahinang uk si Isa ma lahat Yahudiya sampay mahi' ma Awrusalam. Bayi iya piyatay uk manga aa, liyansang uk sigam ni hag. ");
INSERT INTO slm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Malayingkan, taabut peen tallum bahangi min kamatay na, bayi iya pikallum pabing uk Tuhan bo' pandaan na iya ni manga aa. ");
INSERT INTO slm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","'Nsa' aa kamemon bayi pamandaan. Kami sadja, iya tapene' asal uk Tuhan subay naksi' ma pasal si Isa, hati na kami iya bayi magsawu maka iya ma kallum na pabing min kamatay na. ");
INSERT INTO slm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Siyoho' kami uk si Isa itu magnasihat lapal hap ni manga aa. Siyoho' isab kami naksi' ma pasal si Isa, in iya kabuwanan kapatut uk Tuhan ngahukum ma manusiya' kamemon, ma manga 'llum le' sampay ma manga magpatayan. ");
INSERT INTO slm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iya du kanabi-nabihan kamemon, bayi makasaksi' isab ma pasal na. Iya uk sigam, sasuku mangandōl ma si Isa iyampun du paldusahan sigam sabab min kawasa ōn si Isa.” ");
INSERT INTO slm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Salta' peen si Petros missala le', pahōp Nyawa Sutsi ma manga aa ian iya pake ma lapal na. ");
INSERT INTO slm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Inu-inu manga Yahudi magpangandōl ma si Isa, iya bayi sehe' si Petros min Joppa. Iya hangkan sigam inu-inu sabab pamuwan uk Tuhan Nyawa na Sutsi sampay ma manga aa 'nsa' bangsa Yahudi. ");
INSERT INTO slm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Take uk sigam di si Kornelos missala manga bahasa saddi maka uk sigam nanglitan Tuhan ma sabab kawasa na. Halling si Petros, uk na, ");
INSERT INTO slm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Manga aa itu kaniyaan na Nyawa Sutsi sali' du maka kitabi. 'Nsa' niya' makalāng bang sigam itu piyandi.” ");
INSERT INTO slm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hangkan sigam siyoho' uk si Petros subay piyandi, paltandaan in sigam ma si Isa Almasi na. Jari itu si Petros iyamu' uk di si Kornelos subay pihanti' ma sigam pila-pilang 'llaw. ");
INSERT INTO slm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sakali itu take uk manga aa bayi kawakilan maka uk manga dawuranakan bean si Isa ma katilibut lahat Yahudiya, pasal manga aa 'nsa' Yahudi bayi makatayima' lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pagtukad peen si Petros pabayik ni Awrusalam, magtuwi iya siyaway uk manga Yahudi bean si Isa kasehean, aa masi mōgbōg ma addat sigam mag-islam. ");
INSERT INTO slm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Uk sigam, “Oy! Kau iyu bayi pasōd ni diyōm luma' manga aa 'nsa' mag-islam, magsawu maka sigam!” ");
INSERT INTO slm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hangkan sigam biyaan uk si Petros pasal kahalan na ian kamemon, sataggōl min katagna' na. ");
INSERT INTO slm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Uk na, “Bayi peen aku nambahayang ma daira Joppa ian, manjari niya' bayi panda' ni aku. Niya' tanda' ku sali' manta mehe, ingkōtan tong na kampat, tiyontonan pareyo' min langit, pitōngōd ma tōngōd ku. ");
INSERT INTO slm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pagliling ku, niya' tanda' ku ma diyōm na ian manga hayōp, manga sattuwa tawun, manga ayi-ayi maglelehan ma tana', maka manga manuk-manuk isab. ");
INSERT INTO slm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jari niya' suwara take ku halling ni aku, uk na, ‘Nangge kau, Petros. Numbay kau pay'an bo' kau mangan.’ ");
INSERT INTO slm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Suga' uk ku, ‘E, Panghu'! 'Nsa' aku! Sataggōl ku 'llum 'nsa' niya' kiyakan haram atawa lammi' bayi palabay min bo' ku!’ ");
INSERT INTO slm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Suga' take ku suwara hi' halling pabing min diyōm sulga', uk na, ‘Daa iyōnan haram basta tahalal uk Tuhan.’ ");
INSERT INTO slm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Salaihi' min tallu bo' iyampa piangkat ayi-ayi hi' kamemon pabing ni sulga'. ");
INSERT INTO slm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Salta' peen ian, niya' takka ni luma' paōkōman ku hi' tallungan lalla bayi siyoho' pahi' ni aku min lahat Kesareya. ");
INSERT INTO slm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jari siyoho' aku uk Nyawa Sutsi subay 'nsa' hawal-hawal me' ma sigam. Bayi aku sehean isab uk manga danakan tabi 'nnōm puhu' itu, aa min Joppa. Pagtakka kami ni Kesareya pasōd na kami kamemon ni diyōm luma' si Kornelos hi'. ");
INSERT INTO slm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Biyaan kami uk si Kornelos pasal niya' malaikat bayi tanda' na nangge ma diyōm luma' na, missala ma iya. Uk malaikat kono', ‘Sohoun aa pahi' ni Joppa ngallo' dakayo' aa iyōnan si Simun, iya iyōnan isab si Petros. ");
INSERT INTO slm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Biyohan kau uk na lapal, maka lappasan du kau sampay manga sehe' nu karaluma' iyu.’ ");
INSERT INTO slm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Makatagna' peen aku missala ni di si Kornelos,” uk si Petros, “sakali pahōp Nyawa Sutsi ni sigam sali' bayi kahōp ni kitabi tagna'. ");
INSERT INTO slm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Manjari taintōm ku iya bayi halling si Panghu' Isa, iya uk na hi', ‘Bohe' iya bayi pamandi manga aa uk si Yahiya, suga' saddi iya pamandi kaam. Pisangōn du Nyawa Sutsi ni diyōm baran bi iyu.’ ");
INSERT INTO slm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na,” uk si Petros, “asal pasti' na, iya pamuwan uk Tuhan ma manga aa 'nsa' Yahudi, sali' du maka bayi pamuwan na ma kita Yahudi pagka si Panghu' Isa Almasi iya kahagad ta. Maka aku itu, 'nsa' tasagga' ku Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Makake peen manga Yahudi ian ma lapal si Petros hi', 'nsa' niya' panganjawab sigam saddi. Siyanglitan Tuhan uk sigam. Uk sigam, “Bang salaihi' du kahalan na, manga kabangsahan 'nsa' Yahudi kabuwanan kahapan du isab uk Tuhan bo' supaya sigam ngalabba min dusa sigam sampay piniyaan kallum kakkal.” ");
INSERT INTO slm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na, ma waktu bayi pamapatay ma si Esteban pulak-palik manga aa magpangandōl ma si Isa pagka sigam liyaugan. Niya' sigam kasehean bayi makasampay ni lahat Pinikiya, ni pu' Kiprus, sampay isab ni daira Antiyuk. Niyasihat uk sigam lapal hap, bo' Yahudi iya pikehan sadja. ");
INSERT INTO slm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Suga' niya' sigam kasehean aa min Kiprus maka min Kirini bayi pahi' ni Antiyuk, bo' magnasihat sigam lapal hap pasal si Panghu' Isa sampay ni manga aa 'nsa' Yahudi. ");
INSERT INTO slm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ian kawasa Tuhan ma pagnasihat sigam, hangkan heka tōōd manga aa Antiyuk bayi magkahagad sampay papinda ni si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jari itu take uk manga jamaa si Isa ma Awrusalam pasal ian hi', hangkan si Barnabas bayi pipay'an uk sigam ni Antiyuk. ");
INSERT INTO slm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Takka peen si Barnabas pay'an ni Antiyuk, tanda' na iya kamehe tabang Tuhan ma manga aa ian. Magtuwi iya kiyōgan. Pituwahan sigam uk na, siyoho' patōtōg mangandōl ma si Panghu' Isa sampay min diyōm atay sigam. ");
INSERT INTO slm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Barnabas itu hap addat na. Aa iya kahōpan asal uk Nyawa Tuhan maka kōsōg pangandōl na. Manjari heka aa ma Antiyuk bayi tabo na mangandōl ma si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Puwas na hi', si Barnabas bayi pahi' ni daira Tarsus meha si Saul. ");
INSERT INTO slm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tatawwa' na peen, biyo si Saul uk na pabing ni Antiyuk. Dantahun iya taggōl si Barnabas maka si Saul pabōtang ma pagtipunan jamaa si Isa may'an, bo' heka tōōd manga aa bayi piyanduan uk sigam duwangan. Bayi ma Antiyuk iya tagna' pangōn “Almasihin” ma manga bean si Isa. ");
INSERT INTO slm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Manjari itu, ma timpu hi' du, niya' bayi palud min Awrusalam tudju ni Antiyuk manga aa missala lapal min Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Niya' dangan min sigam iyōnan si Agabus bayi nangge magpalatun ma pasal waktu siyong, bo' min kawasa Nyawa Sutsi. Uk si Agabus, “Niya' gōtōm song patakka ni kalahat-lahatan kamemon.” (Iya katakka gōtōm itu bayi ma timpu kapagsultan si Sultan Kalaudi, iya sultan Roma mahatinggi.) ");
INSERT INTO slm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hangkan manga kamuliran ma Antiyuk ian bayi nganiyat mabo tulung ni manga dawuranakan ma lahat Yahudiya, pila-pila takowe' uk sigam dangan maka dangan. ");
INSERT INTO slm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na, iya na ko' hi' bayi tahinang uk sigam ma Antiyuk ian. Jari sin ian bayi piyabo ma si Barnabas maka ma si Saul tudju ni manga maas ma katipunan jamaa si Isa ma Awrusalam. ");
INSERT INTO slm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma waktu ian hi', nagna' si Sultan Herod ngalaugan manga jamaa si Isa kasehean. ");
INSERT INTO slm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Niya' dakayo' jamaa ian, iya si Ya'kub danakan si Yahiya, bayi siyoho' piyonggolan kok na uk si Herod. ");
INSERT INTO slm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pagsayu si Herod in manga Yahudi ian kasulutan ma hinang na magpaponggol hi', bayi soho' na isab siyaggaw si Petros. Iya waktu panaggaw ma si Petros bayi pasalta' ma paghinang manga Yahudi, iya 'llaw pagkakan sigam tinapay 'nsa' kalamuran pasulig. ");
INSERT INTO slm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tasaggaw peen si Petros, siyoho' iya liyōōn ni diyōm jil uk sultan. 'Mpat baanan sundalu bayi siyoho' nganjagahan si Petros, 'mpat-mpat sigam ma diyōm dambaan. Iya gara' si Herod subay pilabay le' hinang Pangintōman bo' iyampa hiyukum si Petros ma mata mayiran. ");
INSERT INTO slm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hangkan si Petros katahanan ma diyōm jil, suga' ian manga aa ma katipunan jamaa si Isa ngamu'-ngamu' tōōd ni Tuhan ma sabab na. ");
INSERT INTO slm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Taabut peen sangōm dahu min 'llaw pamaluwas si Petros uk si Herod ni manga aa, ian si Petros tuwi ma ōtan duwa sundalu. Biyaggōt iya maka duwa bilanggu', maka niya' isab manga sundalu nganjagahan lawang jil ian. ");
INSERT INTO slm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sakali itu niya' dakayo' malaikat min Tuhan nangge patagha' sadja ma tōngōd si Petros, maka sawa diyōm jil. Intanan si Petros ma baha na uk malaikat hi', jōgjōg bo' biyati'. “Palakkas kau!” uk malaikat. “Papunduk kau!” Saruun-duun du pakpak bilanggu' min tangan si Petros. ");
INSERT INTO slm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Uk malaikat ni iya, “Sulugun sintoron nu iyu, maka magtawumpa' kau.” Tasulug peen, uk malaikat, “Pakammōsun badju' nu bo' kau me' ma aku.” ");
INSERT INTO slm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Manjari tiyurul malaikat ian uk si Petros tudju paluwas min jil. Suga' 'nsa' kitauhan uk si Petros bang bannal iya hinang malaikat ian atawa 'nsa'. Bang ma pangannal na niya' sadja bayi pamanda' ni iya. ");
INSERT INTO slm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Palabay peen sigam min jaga dakayo', bo' ni jaga pasunu', jari makaabut na sigam ni tambōl basi' iya ma lawang paluwasan min jil tudju ni daira ian. Tambōl ian magtuwi ukaban di na bo' paluwas na sigam. Mangngan sigam ma katahaan dakayo' daddōk ian, jari saruun-duun du malaikat ian pakallo' min si Petros. ");
INSERT INTO slm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pagpakallo' malaikat hi', na iyamboho' tasayu uk si Petros iya bayi talabay na. Uk na, “A, katauhan ku na, bannal-bannal ko' itu. Malaikat hi' bayi du piyabo uk Tuhan malappa aku min diyōm pangantanan si Herod maka min kalaatan kamemon iya kibayaan uk manga Yahudi hinang ma aku.” ");
INSERT INTO slm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tasayu na peen, magtuwi iya pahi' ni luma' si Mariyam, ina' si Yahiya Markus. Heka aa bayi magtipun may'an ngamu'-ngamu' ni Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kiyuku' uk na lawang ma luwasan bo' niya' ipatan danda iyōnan si Roda pahi' nganda' bang sayi. ");
INSERT INTO slm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Takila na tōōd si Petros. Jari landu' iya kiyōgan, iya poon 'nsa' taukab na lawang dahu. Gam peen paragan pariyōm pabing bo' maan kasehean na in si Petros ian nangge ma luwasan. ");
INSERT INTO slm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Oy! Belaw kau!” uk sigam ni si Roda. Suga' biyayik-bayikan uk na, asal bannal ian si Petros. Jari uk sigam, “Malaikat na ko' hi'.” ");
INSERT INTO slm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bo' si Petros iya 'nsa' parōhōng nguku', hangkan iyukab lawang uk sigam. Pag'nda' sigam ma si Petros, inu-inu tōōd sigam. ");
INSERT INTO slm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ninyal si Petros, noho' sigam daa hebok bo' iyampa sigam biyaan na bang salaingga uk Tuhan bayi malappa iya min diyōm jil. Uk si Petros, “Bain bi kono' si Ya'kub maka manga danakan tabi kasehean pasal itu hi'.” Puwas na hi' pakallo' iya minnihi' tudju ni tōngōd saddi. ");
INSERT INTO slm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagkallat 'llaw peen, mehe kahiluhalaan ma manga sundalu bayi jaga ian pasal maingga na si Petros. ");
INSERT INTO slm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nguldin sultan Herod, siyoho' peha tōōd si Petros. Suga' 'nsa' iya tatawwa'. Manjari siyumariya uk si Herod manga jaga hi' bo' iyampa iya magpanohoan subay piyatay sigam. Puwas na hi' palud si Sultan Herod min lahat Yahudiya pahi' ni Kesareya, pabōtang mahi' pila-pilang 'llaw na. ");
INSERT INTO slm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ma masa ian ngandugal tōōd si Sultan Herod ma manga aa ma lahat Tira maka ma lahat Sidun, hangkan manga aa min karuwa daira hi' bayi magbe' paalōp ni si Herod. Dahu biyagay uk sigam si Balastus, dakayo' tindōg sultan pangandōlan, bahasa sigam biyōgbōgan uk na. Manjari pahi' na sigam ni si Herod pamaap, sabab min lahat sultan iya pangalloan sigam kiyakan sigam. ");
INSERT INTO slm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sakali itu, taabut peen 'llaw iya bayi tiyugun uk na, makay na si Herod maka pakayan na pagsultan. Ningko' iya ma tingkoan pagsultanan na, maka uk na maluwas bissala na ma aa mahadjana' ian. ");
INSERT INTO slm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ngōlang pakōsōg manga aa ian. “'Nsa' manusiya' iya missala iyu,” uk sigam, “suga' dakayo' tuhan!” ");
INSERT INTO slm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Magtuwi si Herod tawwa' bala' uk malaikat Tuhan sabab 'nsa' bayi pamehe na Tuhan. Manjari itu matay iya uk kalōg bayi mangan isi na. ");
INSERT INTO slm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Suga' pasaplag na peen lapal Tuhan, maka paheka na peen manga aa mangandōl ma iya. ");
INSERT INTO slm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pagka ubus na uk si Barnabas maka si Saul iya bayi gawi sigam pahi' ni Awrusalam, pabing sigam ni Antiyuk. Biyo uk sigam si Yahiya Markus sehe' sigam. ");
INSERT INTO slm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na, ma katipunan manga jamaa si Isa ma Antiyuk, niya' manga aa magpalatun lapal min Tuhan, maka niya' isab magpandu' manga lapal na, iya na si Barnabas, si Simiyun iya diyanglay si Itōm, si Lukiyus min Kirini, si Saul, maka si Manaen iya bayi dasuwigan maka Gubnul Herod ma kariki'-diki' sigam le'. ");
INSERT INTO slm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Manjari itu, ma sabu peen sigam mudji Tuhan maka magpuwasa, missala Nyawa Sutsi ni sigam, uk na, “Pasaddihun bi ma aku si Barnabas maka si Saul iyu, bo' tahinang iya hinang pamahinang ku sigam.” ");
INSERT INTO slm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ubus peen uk sigam nambahayang maka magpuwasa, pibōtang uk sigam tangan sigam ma duwangan itu bo' iyampa pilanjal. ");
INSERT INTO slm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Manjari, pagka si Barnabas maka si Saul itu siyoho' mangngan uk Nyawa Sutsi, palud sigam tudju ni Siluki bo' iyampa sigam tulak minnihi' tudju ni pu' Kiprus. ");
INSERT INTO slm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Takka peen sigam ni pu' ian, ni kalumaan Salamis, niyasihat uk sigam lapal Tuhan ma diyōm manga kalanggalan Yahudi. Si Yahiya Markus iya nehean sigam nabang. ");
INSERT INTO slm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Latag uk sigam kalohahan pu' ian sampay taabut kalumaan iyōnan Papos. Jari niya' talanggal uk sigam may'an aa maghihikmat, ōn na si Bal-isa, bangsa Yahudi. Magnahu'-nahu' iya malatun lapal min Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Magbagay asal si Bal-isa maka si Sirgus Paulus, iya gubnul ma pu' ian. Gubnul itu asal lōm tau na. Na, linganan si Barnabas maka si Saul uk gubnul sabab baya' iya pake lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Suga' siyagga' duwangan itu uk aa maghihikmat ian. (Si Elimas ōn na bang ma bahasa Girik, Bal-isa ma bahasa Hibrani.) Iya poon nagga' si Elimas, sabab 'nsa' iya baya' bang gubnul ian ganta' magkahagad ma lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Suga' pagbayaan si Saul uk Nyawa Sutsi. (Si Saul itu, duwa ōn na. Ōn na dakayo' si Paul.) Manjari piyatong aa maghihikmat ian uk si Paul. ");
INSERT INTO slm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Uk si Paul ma iya, “Anak sayitan! Pangangakkal! Jahulaka'! Ayi-ayi makahap sagga' nu sadja. 'Nsa' kau parōhōng mabengkok kalangnganan bannal iya min Tuhan! ");
INSERT INTO slm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","'Ndaun,” uk si Paul, “takkahan kau bala' min Tuhan buttihi'. Buta du kau, taggōl-taggōl iya 'nsa' kanda' nu sawa 'llaw.” Saruun-duun du tananam uk si Elimas sali' gabun lindōm panganda' na, bo' magsanaw iya meha aa ngambit ma iya. ");
INSERT INTO slm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pag'nda' ian hi' uk gubnul, magkahagad na iya sabab inu-inu iya bidda' ma pamandu' si Paul pasal si Panghu' Isa. ");
INSERT INTO slm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na, tulak di si Paul min Papos tudju ni Perga, dakayo' daira ma lahat Pampiliya. Takka peen sigam pay'an, pakallo' si Yahiya Markus min sigam bo' mowe' pahi' ni Awrusalam. ");
INSERT INTO slm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Palanjal si Paul maka si Barnabas min Perga sampay takka na ni Antiyuk, iya Antiyuk mahi' ma lahat Pisidiya. Pag'llaw Sabtu', 'llaw mulliya ma bangsa Yahudi, pasōd sigam ni diyōm langgal Yahudi ningko' may'an. ");
INSERT INTO slm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Niya' biyassa ian min sara' si Musa maka min kitab kanabi-nabihan. Puwas na hi' killo' uk manga nakura' langgal di si Paul, uk na, “Manga danakan, bang niya' bissala bi pamatōtōg iman manga aa itu, baya' du kami.” ");
INSERT INTO slm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nangge si Paul maka uk na ninyal bo' iyampa iya missala ni manga aa hi'. Uk na, “Kaam pagkahi ku bangsa Israil, sampay kaam iya mudji Tuhan min bangsa saddi, kehun bi aku. ");
INSERT INTO slm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Manga ka'mbo'-mboan kami bayi tapene' uk Tuhan, iya asal pagtuhanan kami bangsa Israil. Pimehe uk na bangsa Israil ma masa kamahi' sigam ma lahat Misil, iya 'nsa' lahat sigam. Manjari piluwas sigam uk Tuhan min diyōm lahat Misil ian sabab min kawasa na mehe. ");
INSERT INTO slm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","'Mpatpu' tahun sigam siyandalan uk Tuhan ma lahat 'nsa' agōn kalluman ayi-ayi ian. ");
INSERT INTO slm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pitu' bangsa bayi pikaat uk Tuhan ma lahat Kanaan, bo' pamasuku' uk na lahat ian ma manga aa suku' na. ");
INSERT INTO slm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ian hi' manga 'mpat hatus maka limampu' tahun taggōl na. “Puwas na hi',” uk si Paul, “pibōtangan sigam uk Tuhan manga aa maghukum ngantanan pagparinta sampay taabut ni si Nabi Samwel iya katōbtōban na. ");
INSERT INTO slm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Puwas na hi', iyamu' uk sigam sultan magbaya' ma sigam, hangkan pene' uk Tuhan si Saul anak si Kis, tubu' si Benjamin. Bo' si Saul iya pibōtang pagsultanan sigam ma diyōm 'mpatpu' tahun. ");
INSERT INTO slm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Manjari si Saul hi' bayi pikalloan uk Tuhan min 'ntan na. Jari si Daud iya piganti' magsultan ma sigam. Iya na itu bayi pamalatun Tuhan ma pasal si Daud hi', uk na, ‘Si Daud, anak si Jesse itu, aa makasulut atay ku. Hinang du uk na kamemon kabayaan ku.’ ");
INSERT INTO slm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na,” uk si Paul, “min tubu' si Daud asal si Isa, iya pibōtang itu uk Tuhan ngalappas ma bangsa Israil, sali' bayi janji' na ma masa awwal hi'. ");
INSERT INTO slm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ma 'nsa' le' si Isa bayi nagnaan hinang na, si Yahiya bayi magnasihat ma bangsa Israil kamemon. Siyoho' sigam uk si Yahiya itu subay ngalabba min dusa sigam, maka subay piyandi tawubat tanda' in sigam magsusunan bayi dusa sigam. ");
INSERT INTO slm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na, ma song peen ubus uk si Yahiya ayi-ayi bayi pamahinang iya uk Tuhan, missala iya ma bangsa Israil, uk na, ‘Bang ma pamikil bi, sayi baha' aku itu? 'Nsa' aku iya agaran bi. Suga' niya' aa dangan pasunu' ni aku. 'Nsa' aku tōp minsan laa ngahubaran ingkōt tawumpa' na.’ ");
INSERT INTO slm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Na, manga danakan ku bangsa Israil,” uk si Paul, “sasuku kaam panubu' si Ibrahim, sampay kaam min kabangsahan saddi iya mudji ma Tuhan iyu, kitabi ko' iya piniyaan kahapan itu, manjari lappasan du kitabi min hukuman dusa. ");
INSERT INTO slm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Manga aa Awrusalam maka manga nakura' sigam, 'nsa' takila uk sigam si Isa, in iya makalappas. 'Nsa' isab tahati uk sigam manga kabtangan iya pigbassa ma diyōm manga langgal Yahudi kahaba'-haba' Sabtu', kabtangan bayi tasulat ma diyōm kitab uk manga kanabi-nabihan. Suga', minsan 'nsa' tahati uk manga aa Awrusalam, tatuman du uk sigam ayi-ayi bayi tapalatun uk manga nabi hi', pagka si Isa pibōtangan uk sigam hukuman ni kamatay. ");
INSERT INTO slm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Minsan 'nsa' niya' tatawwa' uk sigam sababan pamapatay iya, bayi sigam ngamu' ni si Gubnul Pilatu subay iya piyatay. ");
INSERT INTO slm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Manjari itu, ubus peen pimattan uk manga aa Awrusalam kamemon bayi tasulat ma diyōm kitab pasal si Isa, pireyo' patay na min hag bayi pamapatayan iya bo' iyampa kiyubul. ");
INSERT INTO slm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Suga' pikallum iya uk Tuhan pabayik min kamatay na. ");
INSERT INTO slm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jari 'llum peen iya pabing ma pila-pilam bahangi na, daran iya tanda' uk manga aa bayi sehe' na magbe' maka iya, min lahat Jalil le' sampay ni Awrusalam. Jari ma buttihi' manga aa bayi sehe' na hi' makasaksi' na ma pasal na ni manga bangsa Israil. ");
INSERT INTO slm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Na,” uk si Paul, “tiya' kami ma itu masampayan kaam lapal hap. Hati na iya bayi panganjanji' Tuhan ma ka'mbo'-mboan tabi ");
INSERT INTO slm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tatuman na ma kitabi iya panubu' sigam. Sabab tapakallum uk na si Isa min kamatay na. Magmattan tōōd iya bayi tasulat ma diyōm kitab Jabul, ma kalangan karuwa na. Uk Tuhan hi', ‘Kau iya anak ku, 'Llaw itu iya patau ku in aku 'mma' nu.’ ");
INSERT INTO slm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Maka iya na itu isab pigpalatun uk Tuhan ma pasal pamakallum na ma si Isa pabayik min kamatay na, 'nsa' pihalu' ma diyōm gumi. Uk na, ‘Buwanan ta kau manga kahapan tantu, iya kahapan bayi janji' ku ma si Daud.’ ");
INSERT INTO slm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Uk na isab ma ayat saddi, ma kitab Jabul, ‘'Nsa' pasaran nu ngahalu' ma diyōm gumi sosohoan nu sutsi atay na.’ ");
INSERT INTO slm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Si Daud hi', ma waktu bayi kallum na, bayi makahinang kamaksuran Tuhan. Puwas na hi' matay iya. Takubul iya ma tōngōd bayi pangubulan manga kamaasan na bo' ngahalu' na baran na. ");
INSERT INTO slm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Suga' iya aa bayi pikallum uk Tuhan min kamatay na itu, 'nsa' tōōd iya bayi salaihi' baran na. ");
INSERT INTO slm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Na, manga dawuranakan ku,” uk si Paul, “subay katauhan bi tōōd, minsan salaingga uk bi mōgbōgan sara' si Musa 'nsa' du kaam makapuwas min dusa. Suga' sasuku kaam mangandōl ma si Isa, puwas na kaam min dusa bi kamemon, Hangkan lapal pasal si Isa itu niyasihatan kaam bo' katauhan bi niya' kaampunan dusa bi. ");
INSERT INTO slm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Na, kamaya'-maya' kaam bo' 'nsa' patakka ni kaam iya bayi tasulat uk kanabi-nabihan, iya uk na, ");
INSERT INTO slm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaam mangudju' iyu, 'ndaun bi ba! Painu-inuhan ta kaam tōōd bo' kaam magmula, uk Tuhan. Sabab niya' hinang ku ma waktu kallum bi le', Hinang 'nsa' kahagad bi, minsan kaam pihatihan.’ ” Minnihi' ubus si Paul. ");
INSERT INTO slm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jari itu, paluwas peen si Paul maka si Barnabas min langgal hi', siyoho' sigam uk manga aa ian pabing pahi' ma Sabtu' bayik missala le' ma pasal ian hi'. ");
INSERT INTO slm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pakallo' peen isab manga aa bayi min langgal hi', heka manga aa bayi paturul ma si Paul maka si Barnabas, manga bangsa Yahudi maka manga aa bangsa saddi me' na ma agama Yahudi. Bissalahan manga aa ian uk di si Paul, siyoho' sigam patōtōg ma tatabangan Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pagsabtu' bayik peen, agōn kamemon manga aa min daira Antiyuk ian magtipun pay'an pake ma lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Suga', pag'nda' manga Yahudi kasehean ma baanan aa katipunan ian, magtuwi sigam ngimbu ma si Paul, hangkan jiyawab bissala uk sigam. Pihallingan isab iya laat. ");
INSERT INTO slm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Suga' paisōg gam peen si Paul maka si Barnabas missala. Uk na ma manga aa maghalling laat hi', “Kaam manga Yahudi wajib liyapalan palman Tuhan dahu. Suga', pagka sulak bi palman itu bo' 'nsa' kaam mista di bi manga in kaam tōp du piniyaan kallum taptap ni kasaumulan, hangkan kami ngalabba du min kaam bo' pinda magnasihat ni manga kabangsahan saddi. ");
INSERT INTO slm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sabab iya du itu isab panohoan Tuhan ma kami, uk na, ‘Sali' kaam sapantun sawa pibōtang uk ku pamasawa manga kabangsahan saddi, Supaya makaabut lapal itu ni 'mpat pidju alam, hati na in manusiya' kamemon makajari lappasan.’ ” ");
INSERT INTO slm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Take peen bissala itu uk manga aa bangsa saddi, magtuwi sigam kiyōgan bo' siyanglitan uk sigam lapal Tuhan. Manjari magkahagad na ma si Isa sasuku tapene' uk Tuhan piniyaan kallum taptap ni kasaumulan. ");
INSERT INTO slm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Patanyag na peen lapal Tuhan ma kalohahan lahat ian. ");
INSERT INTO slm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Suga' manga pagnakuraan ma daira Antiyuk ian maka manga danda bangsahan 'nsa' Yahudi, iya magtaat ni Tuhan, bayi pilingōg uk manga Yahudi. Siyoho' sigam nagga' si Paul maka si Barnabas, hangkan sigam duwangan bayi pikallo' uk manga aa ian min jadjahan hi'. ");
INSERT INTO slm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sakali piyaspasan uk di si Paul bagunbun min nayi' sigam, saksi' in sigam papuwas na min manga aa ma lahat hi'. Puwas na hi' palanjal sigam tudju ni lahat Ikuni. ");
INSERT INTO slm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Suga' manga kamuliran si Isa ma daira Antiyuk hi' kiyōgan makalandu', maka kahōpan isab uk Nyawa Sutsi. ");
INSERT INTO slm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Salaihi' isab kahalan na ma Ikuni. Si Paul maka si Barnabas bayi pasōd ni diyōm langgal Yahudi magnasihat. Hantap tōōd bissala sigam hangkan heka aa tōōd, manga Yahudi maka manga aa bangsa saddi, bayi magkahagad ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Suga' manga Yahudi may'an, iya 'nsa' baya' magkahagad, bayi missalahan manga aa 'nsa' Yahudi maka bayi malaat atay sigam tudju ni manga aa sasuku magkahagad ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Taggōl-taggōl iya kahanti' di si Paul ma Ikuni. 'Nsa' niya' tāw sigam missalahan manga aa pasal si Panghu' Isa. Maka si Isa bayi maniyaan sigam kawasa pangahinang sigam manga hinang makainu-inu maka manga paltandaan, pimattan in lapal sigam pasal tabang na bannal sadja. ");
INSERT INTO slm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bahagi' duwa manga aa ma daira hi'. Niya' sigam kasehean bayi mōgbōgan manga Yahudi, niya' isab kasehean mōgbōgan di si Paul. ");
INSERT INTO slm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jari mag-isun manga aa bangsa saddi maka manga Yahudi, sigam maka pagnakuraan sigam. Iya pig-isun uk sigam subay ngalaugan di si Paul, manga ngahiyak maka batu. ");
INSERT INTO slm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pagkatauhan peen pag-isun itu uk di si Paul magtuwi sigam lahi karuwangan tudju ni lahat Likauna. Mahi' peen, taabut uk sigam daira Listara maka daira Derbe, sampay manga kalumaan ma katilibut ian hi'. ");
INSERT INTO slm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bo' niyasihat uk sigam may'an iya lapal hap pasal si Isa. ");
INSERT INTO slm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sakali itu niya' ningko' ma Listara ian aa tongka' nayi' na min kariyasali na. 'Nsa' iya bayi makalangngan sataggōl min kapag-anak na. ");
INSERT INTO slm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pake tōōd aa itu ma bissala si Paul. Piyatong iya pahap uk si Paul, bo' tasayu uk si Paul in aa itu taga pangandōl ma si Isa in iya kaulian du uk na. ");
INSERT INTO slm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Manjari pitanōg uk si Paul suwara na, uk na, “Nangge na kau pabōntōl!” Magtuwi patulahad aa ian nangge maka uk na mangngan. ");
INSERT INTO slm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pag'nda' baanan aa ian ma bayi tahinang uk si Paul magtuwi sigam ngōlang ma sali' paghalling sigam Likauna. Uk sigam, “Magpasalupa manga tuhan ni manusiya'. Tiya' na sigam pareyo' ni kitabi.” ");
INSERT INTO slm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Iya pangōn manga aa ian ma di si Paul ōn tuhan sigam. Si Barnabas iya iyōnan si Siyus, maka si Paul iyōnan si Hermes sabab iya na aa magbibissala. ");
INSERT INTO slm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iya luma' pangaharapan sigam tuhan Siyus, ian min luwasan lawang daira. Manjari imam iya maghinang ni si Siyus bayi ngangguyud manga sapi' lalla tudju paluwas maka bayi mo manga tohan sumping. Imam itu maka kahekahan aa ian baya' numbay sapi' pangahulmat sigam ma di si Paul. ");
INSERT INTO slm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Suga' pagkatau si Barnabas maka si Paul bang ayi song hinang uk manga aa ian magtuwi geret uk sigam sammek sigam, tanda' in sigam 'nsa' baya' salaihi'. Sakali paragan sigam ni tangnga' pagtipunan aa ian maka uk sigam ngōlang. ");
INSERT INTO slm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Uk di si Paul hi', “Manga tuwan! Angay salaiyu paghinang bi ma kami? Manusiya' du kami sali' kaam. Iya poon kami paitu lapal hap, pama' kami ma kaam supaya kaam pataikut min pagtuhanan bi iyu iya 'nsa' niya' kapusan na. Tiya' kami bayi paitu bo' kaam papinda ni Tuhan 'llum, iya bayi mapanjari langit maka tana' maka tahik sampay kakaya'-kayaan na kamemon. ");
INSERT INTO slm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bayi ma masa awwal hi' pisaran uk Tuhan manga kabangsa-bangsahan kamemon me' ma ayi-ayi kabayaan sigam. ");
INSERT INTO slm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Suga' sataggōl min awwal hi' niya' na peen saksi' in iya asal Tuhan. Iya saksi' hi' manga kahapan iya tahinang na peen uk na. Pimuwan uk na ulan, pimuwan na isab manga buwa' ma tiyanōm bi bang taabut bulan na. Piniya' uk na kiyakan bi, maka pilasig uk na manga atay bi.” ");
INSERT INTO slm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Salaihi' iya pamahati di si Paul ma baanan aa ian, suga' 'nsa' sigam agōn pake. Subay magkulban le' ma sigam. ");
INSERT INTO slm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Manjari itu niya' takka ni daira Listara hi' manga Yahudi bayi min Antiyuk ma Pisidiya maka niya' min Ikuni. Jari tabo-bo uk sigam manga aa heka ian, bo' pighiyak si Paul uk sigam maka batu. Puwas na hi' giyuyud iya uk sigam tudju paluwas min kalumaan ian pagka kibā' matay na iya. ");
INSERT INTO slm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Suga' kapagtipunan peen si Paul uk manga bean si Isa, magtuwi iya nangge bo' pabing ni diyōm daira. Pagkallat 'llaw dakayo', palanjal iya maka si Barnabas tudju ni Derbe. ");
INSERT INTO slm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Makamahi' peen sigam ma Derbe, niyasihat uk sigam lapal hap ni manga aa mahi', bo' heka aa tabo uk sigam me' ma si Isa, Puwas na hi', pabing sigam ni Listara, bo' palaus ni Ikuni bo' na isab palaus ni Antiyuk iya ma lahat Pisidiya hi'. ");
INSERT INTO slm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pihōgōt uk di si Paul iya iman manga bean si Isa ma manga daira iya pahapitan sigam ian. Siyoho' sigam patōtōg mangandōl ma Tuhan. Uk pandu' di si Paul, “Subay heka katiksaan kalabayan ta bo' iyampa kita pisōd ni diyōm ōkōman pagparinta Tuhan.” ");
INSERT INTO slm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Niya' aa biyōtang uk sigam pagmaasan manga jamaa si Isa Almasi, maingga-maingga niya' lahat pagtipunan sigam. Magpuwasa di si Paul sampay ngamu'-ngamu' ni Tuhan bo' iyampa pijagahan uk na manga aa ian ma Tuhan, iya pangandōlan na uk sigam. ");
INSERT INTO slm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Talabay peen lahat Pisidiya uk di si Paul, takka sigam ni Pampiliya. ");
INSERT INTO slm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Palanjal isab ni daira Perga, bo' niyasihat uk sigam lapal Tuhan may'an. Puwas na hi' palud sigam tudju ni Attali. ");
INSERT INTO slm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jari tulak sigam minnihi' pabing ni Antiyuk. Ma Antiyuk asal sigam bayi pijagahan ni Tuhan dahu, iyamuan tatabangan na ma song peen tulak magnasihat lapal hap. Maka buttihi' taubus na uk sigam hinang sigam hi'. ");
INSERT INTO slm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Makarunggu' peen sigam ni Antiyuk, pitipun uk sigam manga jamaa si Isa may'an. Biyaan sigam uk di si Paul kamemon bayi tahinang uk na maka si Barnabas, deyo' bayi min Tuhan. Biya'-ba' isab uk sigam pasal manga bangsa 'nsa' Yahudi kabuwanan lawang na uk Tuhan bo' supaya sigam makapagkahagad isab ma si Isa. ");
INSERT INTO slm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Taggōl di si Paul paralahat may'an ma manga bean si Isa ma Antiyuk. ");
INSERT INTO slm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Manjari itu niya' manga aa takka ni Antiyuk bayi min lahat Yahudiya, bo' piyanduan uk sigam manga bean si Isa ma Antiyuk. Uk sigam, “'Nsa' kaam makajari liyappasan bang kaam 'nsa' pig-islam sali' panohoan sara' si Musa!” ");
INSERT INTO slm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jiyawab tōōd manga aa ian uk si Paul maka si Barnabas, biyo maglugat ma sabab pamandu' sigam salaihi'. Hangkan ko', si Paul maka si Barnabas maka manga aa Almasihin kasehean min Antiyuk ian giyaraan pahi' ni Awrusalam. Siyoho' sigam mo manga aa kawakilan maka manga pagmaasan may'an magbissala pasal palkala' ian hi'. ");
INSERT INTO slm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na, pilanjal di si Paul uk manga pagtipunan jamaa ma Antiyuk ian. Palabay peen sigam min lahat Pinikiya maka min Samariya, biya' uk sigam may'an pasal manga bangsa 'nsa' Yahudi makapinda na ni Tuhan. Landu' kiyōgan manga bean si Isa, pagtake sigam ma lapal di si Paul itu. ");
INSERT INTO slm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pagtakka sigam pahi' ni Awrusalam, siyagina sigam uk katipunan jamaa si Isa mahi', sampay uk manga aa kawakilan maka manga kamaasan. Biyaan sigam uk di si Paul pasal kamemon bayi tahinang uk sigam deyo' bayi min Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Suga' niya' manga Parisi mangandōl ma si Isa bayi nangge missala. Uk sigam, “Manga aa mangandōl ma si Isa min bangsa saddi ian subay pig-islam dahu, maka subay sigam mōgbōg isab ma sara' si Musa.” ");
INSERT INTO slm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jari magtipun manga aa kawakilan maka manga kamaasan mikil-mikil pasal palkala' ian. ");
INSERT INTO slm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Taggōl-taggōl peen uk sigam magbissala, nangge si Petros missala. Uk na, “Kaam manga dawuranakan ku, katauhan bi du: ma waktu palabay ian bayi aku tapene' uk Tuhan min diyōman bi, siyoho' magnasihat lapal hap ni manga kabangsahan saddi, iya 'nsa' Yahudi, bo' supaya sigam makake sampay magkahagad. ");
INSERT INTO slm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jari Tuhan, iya makatau bang ayi ma diyōm atay manusiya', bayi muwan Nyawa Sutsi ma kabangsahan saddi sali' bayi pamuwan na ma kitabi, tanda' palsaksian in iya kasulutan na ma sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sigam ian maka kitabi 'nsa' pipagbidda' uk Tuhan. Iyampun uk na manga dusa sigam ma sabab pangandōl sigam ma si Isa, sali' du maka kitabi. ");
INSERT INTO slm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Na,” uk si Petros, “angay subay parugal bi Tuhan. Sabab iyu pahunitan bi na peen manga aa pagka soho' bi mōgbōgan manga panohoan iya bayi 'nsa' tahinang uk ka'mbo'-mboan tabi, maka 'nsa' isab tahinang tabi? ");
INSERT INTO slm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Daa na. Mangandōl kitabi ma si Panghu' Isa bo' lappasan kitabi sabab min ase' na maka lasa na. Damikkiyan na isab manga aa min kabangsahan saddi ian.” ");
INSERT INTO slm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Minnihi' patammun manga aa magtipun ian kamemon pasalta' sigam pake ma pama' si Barnabas maka si Paul pasal manga paltandaan maka manga hinang makainu-inu kamemon iya bayi tahinang uk sigam ma diyōman manga kabangsahan 'nsa' Yahudi hi', deyo' bayi min Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ubus peen sigam ma'-ma', paganti' si Ya'kub missala. “Kaam dawuranakan ku,” uk na, “aku na iya kehun bi. ");
INSERT INTO slm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bayi kaam pihati uk si Simun itu sini' pasal katagna' Tuhan bayi mandaan pagparuli na ma manga bangsa 'nsa' Yahudi. Sabab niya' manga aa bayi pene' na min sigam hinang aa suku' Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mag-uyun du bissala si Simun hi' maka bayi tasulat uk manga kanabi-nabihan ma masa awwal hi'. Iya na itu bayi tasulat ma diyōm kitab, iya uk na, ");
INSERT INTO slm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Puwas itu, uk Tuhan, pabing du aku, bo' patangge ku luma' si Daud pabing (hati na bawi' ku pagsultanan na.) Bangun ku pabayik, batuk ku pagdayaw na malarak hi'. ");
INSERT INTO slm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Manjari peha aku uk aa kamemon min manga bangsa saddi, Sigam 'nsa' Yahudi kamemon, sasuku bayi talingan ku hinang aa suku' ku. ");
INSERT INTO slm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Iya na itu pamalatun Tuhan, iya bayi pitau uk na min masa awwal le'.’ ");
INSERT INTO slm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Na,” uk si Ya'kub, “bang ma aku, daa subay sasaw tabi manga aa min kabangsahan saddi iya papinda na itu me' ma Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Suga' subay sigam pabohan tabi sulat maan sigam salaitu sadja: daa sigam subay mangan ayi-ayi paglabōt ni manga tau-tau iya pagtuhanan aa, daa sigam subay maghinang kalaatan danda maka lalla, daa sigam subay mangan hayōp bayi pikkōl, maka daa subay mangan laha'. ");
INSERT INTO slm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Iya na hi', sabab sataggōl min masa awwal in panohoan sara' si Musa bayi pignasihat asal ma manga daira kamemon, biyassa isab ma diyōm kalanggal-langgalan tabi kamemon sakahaba' Sabtu'.” ");
INSERT INTO slm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Manjari magkagaraan manga aa kawakilan maka manga kamaasan maka manga jamaa ian kamemon, subay niya' manga aa min diyōman sigam pene' bo' pipahi' ni Antiyuk, pisehe' ma si Paul maka si Barnabas. Jari iya pene' ian si Judas Barsabas maka si Silas. Duwangan itu asal pig-addatan uk dawuranakan sigam bean si Isa. ");
INSERT INTO slm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Niya' isab sulat piyabo ma sigam, iya uk na hi', “Sulat itu deyo' min kami dawuranakan bi, manga aa kawakilan maka kamaasan ma itu ma Awrusalam. Pisampay itu ni kaam manga dawuranakan kami min manga bangsa saddi iya maglahat maiyu ma Antiyuk, ma Siriya, sampay manga ma Silisi. ");
INSERT INTO slm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Take kami niya' kono' manga lalla minnitu min diyōman kami bayi paiyu masusa kaam sampay nasaw pikilan bi ma sabab pandu' sigam. Suga' 'nsa' min panohoan kami iya hangkan sigam mandu' salaihi'. ");
INSERT INTO slm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hangkan kami bayi mag-isun kamemon subay kami mene' manga aa ma itu bo' siyoho' paiyu ni kaam. Jari pasehe' kami sigam ma si Barnabas maka ma si Paul, bagay kami kilasahan, ");
INSERT INTO slm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","di si Paul itu bayi magmalilla' ma kallum sigam ma sabab Panghu' tabi si Isa Almasi. ");
INSERT INTO slm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Manjari tiya' na si Judas maka si Silas, bayi soho' kami paiyu pabaran ni kaam maan kaam ayi-ayi bayi tasulat kami itu. ");
INSERT INTO slm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sabab Nyawa Sutsi maka kami itu dauyunan du, subay kaam 'nsa' pihunitan liyu min manga panohoan itu, iya wajib bine': ");
INSERT INTO slm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","daa kaam mangan ayi-ayi bayi paglabōt ni manga tau-tau iya pagtuhanan aa, daa kaam mangan laha', daa kaam mangan hayōp bayi pikkōl, maka daa na isab kaam maghinang kalaatan danda maka lalla. Bang hallian bi hi', makahap du. Mura-murahan, wassalam.” ");
INSERT INTO slm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jari itu pilangngan manga aa mo sulat ian tudju ni Antiyuk. Takka peen sigam pay'an, pitipun uk sigam manga aa dajamaa may'an bo' siyongan sulat ni sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pagbassa sigam sulat ian magtuwi sigam kiyōgan tōōd, sabab sulat ian makahōgōt atay sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na, si Judas maka si Silas itu aa asal magpalatun lapal Tuhan. Jari taggōl pagnasihat sigam ma manga bean si Isa ma Antiyuk ian, mahōgōt maka makōsōg pangandōl sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Taggōl-taggōl peen uk di si Judas pahanti' may'an, pipowe' na sigam uk manga bean si Isa may'an. “Mura-murahan, bang peen kaam salamat,” uk sigam. Manjari mowe' pabing di si Judas ni bayi manoho' sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Suga' si Silas pataggōl le' may'an.) ");
INSERT INTO slm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Sampay si Paul maka si Barnabas pahanti' le' may'an ma Antiyuk. Magbe' sigam maka baanan aa kasehean magpandu' maka magnasihat lapal Tuhan. ");
INSERT INTO slm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Puwas peen manga pilam bahangi, halling si Paul ni si Barnabas, uk na, “Sung kita patibaw pabing ni manga dawuranakan ta bean si Isa ma karairahan kamemon bayi pagnasihatan ta lapal Tuhan hi'. 'Nda' ta bang salaingga kahalan sigam.” ");
INSERT INTO slm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Si Barnabas ian baya' mo si Yahiya Markus pasehe' ma sigam, ");
INSERT INTO slm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","suga' bang ma bistahan si Paul si Markus itu 'nsa' tōp pasehe', sabab bayi iya ngalabbahan sigam bayi mahi' le' ma Pampiliya. 'Nsa' iya bayi makatatas nabangan sigam sampay ubus hinang sigam. ");
INSERT INTO slm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mehe paglugat sigam hangkan sigam magbutas na. Si Barnabas bayi mo si Markus bo' tulak sigam duwangan tudju ni pu' Kiprus. ");
INSERT INTO slm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Paul iya bayi mene' si Silas sehe' na. Song peen sigam pakallo' min Antiyuk, pijagahan sigam ma Tuhan uk manga bean si Isa may'an bo' sigam kaniyaan tatabangan na. ");
INSERT INTO slm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pakallo' peen si Paul minnihi' palabay iya min lahat Siriya maka min lahat Silisi. Maingga-maingga lahat niya' manga jamaa si Isa magtipun, pihōgōt uk na pangandōl sigam. ");
INSERT INTO slm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Manjari palanjal si Paul tudju ni Derbe maka ni Listara. Niya' ma Listara dakayo' bean si Isa iyōnan si Timuti. Ina' na bangsa Yahudi mangandōl ma si Isa, 'mma' na bangsa Girik. ");
INSERT INTO slm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Si Timuti itu bissalahan hap uk manga bean si Isa kamemon, iya ma Listara maka ma Ikuni ian. ");
INSERT INTO slm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Baya' na si Paul mo iya sehe' na ma palangnganan suga' kitauhan uk manga Yahudi kamemon ma jadjahan ian hi' in 'mma' si Timuti bangsa Girik. Hangkan iya pig-islam dahu uk si Paul bo' 'nsa' tasaway uk manga Yahudi. ");
INSERT INTO slm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na, mangngan na di si Paul ni manga kalahat-lahatan bo' biyaan uk sigam manga bean si Isa may'an pasal kagaraan bayi min manga aa kawakilan maka manga kamaasan ma Awrusalam. Siyoho' manga bean ian me' ma kagaraan hi'. ");
INSERT INTO slm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jari itu pahōgōt na peen pangandōl manga jamaa si Isa iya magtipun-tipun ma kalahatan ian, maka pasong isab heka sigam kahaba'-haba' 'llaw. ");
INSERT INTO slm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Na, iyuntas uk di si Paul lahat Pirigiya maka lahat Galatiya, sabab 'nsa' sigam diyulan uk Nyawa Sutsi, 'nsa' siyoho' magnasihat lapal Tuhan may'an ma kalingkal lahat Asiya. ");
INSERT INTO slm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Taabut peen tōbtōban lahat Misiya, pasulay sigam palanjal ni lahat Bitiniya suga' 'nsa' sigam diyulan uk Nyawa si Isa. ");
INSERT INTO slm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hangkan sigam palabay min tangnga' lahat Misiya ian sampay palud na tudju ni Torowas. ");
INSERT INTO slm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Manjari itu, ma Torowas peen bo' sangōm na, niya' bayi panda' ni si Paul. Tanda' na aa min Makidunya mikitabang ma iya. Uk aa itu, “Paitu kau parambiya' ni Makidunya bo' kami tabangun!” ");
INSERT INTO slm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ubus peen si Paul bayi makanda' ian hi', magtuwi kami magsakap tulak ni Makidunya, sabab tasayu kami in kami siyoho' du uk Tuhan nganasihat lapal hap pasal si Isa ni manga aa may'an. ");
INSERT INTO slm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tulak peen kami min Torowas ian, magtuwi kami tudju ni pu' Samoterak. Pagkallat 'llaw peen, pauntas isab kami min pu' ian hi' tudju ni Neyapoles. ");
INSERT INTO slm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pagtakka kami ni Neyapoles patukad kami tudju ni Pilipi, daira mehe ma kalingkal Makidunya ian, paglahatan bangsa Roma isab. Pahanti' kami may'an pila-pilang 'llaw na. ");
INSERT INTO slm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pagsabtu' paluwas kami min daira ian tudju ni bihing sapa', sabab ma tōkōran kami niya' du pagsambahayangan manga Yahudi may'an. Ningko' kami may'an missalahan manga karandahan iya patipun may'an. ");
INSERT INTO slm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Niya' dangan min manga danda bayi pake ian iyōnan si Lidiya, danda min daira Tatira. Iya usaha na maglitu kakana' taluk, kakana' halgaan. Danda itu magtaat asal ma Tuhan. Salta' iya pake ma kami, kabuwanan iya pikilan uk si Panghu' Isa bo' kihagad uk na bissala si Paul. ");
INSERT INTO slm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jari piyandi di si Lidiya maka manga sehe' na karaluma', palsaksian in sigam ma si Isa na. Puwas na hi' siyoho' kami uk si Lidiya paōkōm ma iya. Uk si Lidiya, “Bang aku tabista bi mangandōl na sabannal-bannal ma si Panghu' Isa, paitu kaam paōkōm ma luma' ku.” Jari talōgōs kami uk na. ");
INSERT INTO slm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Manjari itu, ma labayan peen kami tudju ni pagsambahayangan hi', niya' talanggal kami dakayo' danda banyaga'. Siyōran iya sayitan hangkan iya talus. Heka pauntungan manga aa dapu danda ian sabab min talus na. ");
INSERT INTO slm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Paturul na peen iya ma kami maka si Paul, maka uk na ngalingan. Uk na, “Manga aa itu sosohoan Tuhan Mahatinggi! Sigam iya ngalapal ma kaam bang salaingga kalappas bi!” ");
INSERT INTO slm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","'Nsa' parōhōng paglingan na salaihi' pila-pilang 'llaw. Gana-gana paddi' pikilan si Paul, hangkan iya palingi' ni danda ian bo' halling ni sayitan. Uk na, “Min kawasa ōn si Isa Almasi, soho' ta kau paluwas min danda iyu!” Saruun-duun du paluwas sayitan hi', bo' danda ian 'nsa' na makatalus. ");
INSERT INTO slm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pag'nda' peen manga aa dapu danda ian in iya 'nsa' na kapanguntungan sigam, magtuwi siyaggaw uk sigam si Paul maka si Silas. Giyuyud sigam pay'an ni manga pagnakuraan, ian ma halaman daira. ");
INSERT INTO slm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Biyo sigam ni manga aa ngantan sara' bangsa Roma bo' iyampa sigam tiyuntutan uk manga aa dapu danda ian. Uk sigam, “Manga aa itu ngahinang sadja kasasawan ma lahat tabi. Bangsa Yahudi ko' sigam. ");
INSERT INTO slm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pamandu' uk sigam manga addat 'nsa' tawwa' bang ma sara' kami. Bangsa Roma du kami. 'Nsa' kami wajib nayima' atawa ngahinang manga addat salaihi'.” ");
INSERT INTO slm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Manjari palamud manga aa iya magtipun-tipun may'an bo' me' nguntara ma di si Paul. Hiyurusan manga sammek si Paul maka si Silas uk manga aa ngantan sara' ian bo' siyoho' sigam liyapdōsan. ");
INSERT INTO slm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ubus peen sigam bayi kalapdōsan tōōd, liyōōn sigam ni diyōm jil. Iya tunggu' jil ian siyoho' uk manga aa ngantan sara' ian subay mahōgōt tōōd tambōl na. ");
INSERT INTO slm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pagtake panohoan itu uk tunggu', magtuwi liyōōn uk na di si Paul ni tangnga'-tangnga' jil bo' iyampa gallangan na nayi' sigam maka papan mehe. ");
INSERT INTO slm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Jari itu, manga tōnga' bahangi peen, nambahayang si Paul maka si Silas maka magkalangan isab manga kalangan pamudji Tuhan. Kake ma sigam manga pilisu kasehean. ");
INSERT INTO slm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tagha' sadja niya' linug mehe, jōgjōg papagan jil ian. Saruun-duun du paukab tambōl ian kamemon, pakpak du isab manga bilanggu' min pilisu ian kamemon. ");
INSERT INTO slm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bati' tunggu' jil, bo' pag'nda' na manga tambōl jil ukab na, pangannal na hi' makalappa manga pilisu. Ngahella' iya magtuwi kalis na, arak mapatay di na. ");
INSERT INTO slm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Suga' ngalingan si Paul pakōsōg, uk na, “Daa kau